﻿USE sofia;
DROP TABLE IF EXISTS sofia.arnNT_vpl;
CREATE TABLE arnNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES arnNT_vpl WRITE;
INSERT INTO arnNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tüfa Jesucristo tañi kuyfike tuwün pu che em, David em ka Abraam em tañi pu yomel ürke: ");
INSERT INTO arnNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraam em yallfi ta Isaak, ");
INSERT INTO arnNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda em Tamar mew yallfi ta Fares ka Sara. ");
INSERT INTO arnNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram em yallfi ta Aminadab, ");
INSERT INTO arnNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon em ta Raab mew yallfi ta Boos, ");
INSERT INTO arnNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isay em yallfi tati longko ülmen David. Tati longko ülmen David Uria em ñi kure mew yallfi ta Salomon. ");
INSERT INTO arnNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomon em yallfi ta Roboam, ");
INSERT INTO arnNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa em yallfi ta Josafat, ");
INSERT INTO arnNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia em yallfi ta Jotam, ");
INSERT INTO arnNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekias em yallfi ta Manase, ");
INSERT INTO arnNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia em yallfi ta Jekonia ka tañi pu peñi, feychi tripantu mew püresukonayengelu tati pu israelche Babilonia trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Dew rupalu ti tripantu ñi püresukonalepun engün, ");
INSERT INTO arnNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabel em yallfi ta Abiud, ");
INSERT INTO arnNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor em yallfi ta Sadok, ");
INSERT INTO arnNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud em yallfi ta Eleasar, ");
INSERT INTO arnNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob em yallfi ta Jose, Maria tañi füta, ");
INSERT INTO arnNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Femngechi ta kom tati mülekechi pu che, llitulu ta Abraam mew ka David mew, fentepulu mari meli tuwünche em ürke: llitulu ta David mew ka tunteñma ñi püresukonalepun ti pu israelche ta Babilonia trokiñ mapu mew ka femngechi rupay ta mari meli tuwünche. Ka femngechi mari meli tuwünche ta rupay dew lifreletulu engün tañi püresuyengefel tati israelche Babilonia trokiñ mapu mew ka puwi mari meli tuwünche feychi choyüngelu ta Jesus tati Cristo. ");
INSERT INTO arnNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Fey famngechi choyüngey ta Jesucristo: Maria, Jesus tañi ñuke, Jose engu dew eludunguniewürkey tañi kureyewael, welu petu tañi kureyewnon engu, Maria kimuwi tañi niepüñeñkülen tati Lif Küme Püllü tañi pepiluwün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Fey Jose, Maria tañi fütayeaelchi wentru kiñe rume nor piwke wentrurke, fey ayülay tañi yewelkayafiel ta Maria, feymew rakiduami tañi ellka elkünutuafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Fey Jose dew rakiduamlu tañi femngechi femael, feymew Ñidol tañi kiñe werken püllü pewfaluweyew ta pewma mew, ka feypieyew: “Jose, David tañi yomelche, ngünewkilnge tami kureyeafiel ta Maria, tati Lif Küme Püllü ñi pepiluwün mew nieay tañi püñeñ. ");
INSERT INTO arnNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria ta nieay kiñe wentru püñeñ, fey Jesus pintukulelafimi tañi üy. Famngechi feypingeay kisu am montulafilu tañi trokiñche ñi yafkan mew.” ");
INSERT INTO arnNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kom tüfachi dungu ta femngechi feley tañi mupiael kom tañi feypikünuel ta Ñidol ñi pu pelon wentru mew: ");
INSERT INTO arnNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Niepüñeñay ta kiñe üllchadomo petu fütangenolu, fey nieay ta kiñe wentru püñeñ. Emanuel pintukulelngeay tañi üy” (tüfa ta feypin ürke: “Ngünechen müley ta iñchiñ mew”). ");
INSERT INTO arnNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Feymew Jose trepelu tañi pewma mew, kom femi chumngechi tañi feypietew tati werken püllü, fey kureyefi ta Maria. ");
INSERT INTO arnNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Welu kurewen reke kudulay engu dew nielu wüla ñi wünen püñeñ ta Maria, fey Jose, Jesus pintukulelfi ti pichiche ñi üy. ");
INSERT INTO arnNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus choyüngey ta Belen waria mew, kiñe waria mülelu Judea trokiñ mapu mew, feychi mew ta Erode longko ülmenkülerkey Judea trokiñ mapu mew. Feychi küpay kiñe mufü kimke wentru tuwlu tripawe antü püle. ");
INSERT INTO arnNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Fey akulu ta Jerusalen waria mew, famngechi ramtuyawi engün: —¿Chew anta müley tati pu judiu tuwünche tañi longko ülmen, tati we choyüngelu? Pefiyiñ ti wangülen ñi küdetunagkülen chew ñi choyüngemum ti Cristo, feymew küpaiñ taiñ püramyeafiel ngillatun mew ―pi engün. ");
INSERT INTO arnNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Fey tati longko ülmen Erode rume wesa duami allkülu tüfachi dungu. Ka femngechi femi kom tati waria che mülelu ta Jerusalen. ");
INSERT INTO arnNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Feymew ti longko ülmen werküy ñi mütrümngeael kom tati longkolelu ti pu saserdote mew ka tati pu kimeltukelu Moyse ñi ley dungu, fey ramtufi chew müngell ñi choyüngeael tati Cristo. ");
INSERT INTO arnNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Fey kisu engün feypi: —Belen waria mew Judea trokiñ mapu mew, chumngechi tañi wirikünuel ti pelon wentru: ");
INSERT INTO arnNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Belen waria, mülelu ta Judea mapu mew, doy falintufal-lay tati kakelu fütrake waria mew müleyelu Judea trokiñ mapu mew. Belen mew am choyüngealu kiñe longko ülmen, fey kisu ngülamtunieafi tati Israel trokiñche’ pi. ");
INSERT INTO arnNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Feymew Erode ellka mütrümfi tati pu kimke wentru, fey ramtufi chumül müngell tañi pewfaluwün tati wangülen. ");
INSERT INTO arnNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Feymew werküfi ñi amuael engün ta Belen, fey ka feypifi: —Amumün üyew, ka küme inaramtupuafimün ñi chumngechi pichichengen tati püñeñ, fey pefilmün, kimelelmupatuan, tañi amuael kay ta iñche ñi püramyeafiel ngillatun mew ti pichiche ―pi. ");
INSERT INTO arnNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Fey kisu engün, dew allküñmafilu ñi pietew tati longko ülmen, amuy engün. Fey ti wangülen tañi peel engün tripawe antü püle wüneluwküley kisu engün mew, fey puwlu wüla elkünuwpuy üngküpüra chew tañi mülemum tati püñeñ. ");
INSERT INTO arnNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Fey tati pu kimke wentru, pefilu engün ti wangülen, rumeñma ayüwi. ");
INSERT INTO arnNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Feymew konpuy engün tati ruka mew, fey pefi engün ta Maria ñi püñeñ engu, fey lukutupuy engün ka püramyefi engün ngillatun mew. Fey nentupuy engün tañi yewün, fey elufi engün oro, insienso ka mira. ");
INSERT INTO arnNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Welu kimelngey engün ta pewma mew ñi rumetunoael engün ta Erode mew. Fey wiñotualu ñi mapu mew engün, amutuy kangelu rüpü mew. ");
INSERT INTO arnNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Fey dew amutulu tati pu kimke wentru, Ñidol tañi kiñe werken püllü pewfaluwfi ta Jose pewma mew, fey feypifi: “¡Pepikawnge! Fey yefinge tati pichiche ka tañi ñuke Egipto mapu mew. Mülepuaymün ta üyew, fey iñche kimeluwayiñ wüla chumül tamün wiñometuael, Erode am ayülelu ñi kintuafiel tati püñeñ ñi langümafiel” pi. ");
INSERT INTO arnNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Feymew Jose pepikawlu, pun tripay ti pichiche ka tañi ñuke engün ñi amuael ta Egipto, ");
INSERT INTO arnNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","fey üyew mülepuy engün. Fey lalu wüla Erode, wiñometuy engün. Fey femngechi rupay tüfachi dungu ñi mupiael ñi feypikünuel ta Ñidol feychi dungulu tati pelon wentru mew: “Egipto mew mütrümfalün tañi Fotüm” pi. ");
INSERT INTO arnNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Welu ngüneduamlu ta Erode tati pu kimke wentru ñi ngünenkaetew, rume lladküy. Feymew Erode rakiduami tunten küyen ñi dew rupan feychi kimeletew ti pu kimke wentru chumül ñi pewfaluwün ti wangülen, fey werküy ñi langümngeael kom pichikewentru püñeñ, mülelu ta Belen ka fülpüle müleyelu, petu puwülnienolu küla tripantu. ");
INSERT INTO arnNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Fey ta famngechi mupiy tañi wirintukuel tati pelon wentru Jeremia: ");
INSERT INTO arnNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Allküngey kiñe dungun ta Rama trokiñ mapu mew, rume fütra ngümakawün ka fütrake etüngün. Rakel reke ngümakawmekey kom domo langümüñmangen mew tañi püñeñ engün, fey pilay tañi yafülngeael, dew lalu am ti pichikeche” pi. ");
INSERT INTO arnNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Welu dew lalu ta Erode, Ñidol tañi kiñe werken püllü pewfaluwfi ta Jose pewma mew, Egipto mapu mew, fey feypifi: ");
INSERT INTO arnNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“¡Pepikawnge! Yetuafimi tati pichiwentru tañi ñuke engu, fey wiñotumün ta Israel mapu mew. Dew lay tati ayüfulu ñi langümafiel tati pichiwentru.” ");
INSERT INTO arnNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Feymew Jose pepikawi, fey küpaltufi tati pichiwentru tañi ñuke engu ta Israel mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Welu Jose kimlu Arkelaw ñi longkoletun ta Judea mapu mew chew longkolekefuy kisu ñi chaw Erode, llükay ñi amuael ta üyew, kom feypietew am ta Ngünechen pewma mew, fey amuy Galilea trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Fey puwlu üyew, eluwi tañi mülepuael Nasaret waria mew. Fey tüfa famngechi femi tañi mupiael ñi feypikünuel tati pu pelon wentru: Nasaretche ñi pingeael ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Fey dew rupalu fentren tripantu pewfaluwi ta Juan ti Fawtisachefe Judea tañi uwe mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Fey ta famngechi feypi tañi wewpin: “¡Wiñorakiduamtumün tamün wiñotuael ta Ngünechen mew, dew fülpalu am ta Ngünechen tañi longko ülmenngeael!” ");
INSERT INTO arnNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan ta tiye ürke tañi feypikünuel tati pelon wentru Isaia tañi wirielchi chillka mew: “Kiñe dungun ta allküngey mawkenochi uwe mapu mew: ‘Kiñe nor küme rüpü reke feletupe tamün rakiduam, femngechi tamün llowafiel ta Ñidol.’ ” ");
INSERT INTO arnNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan tañi takuwün ngürelerkey ta re kal kamellu mew, ka trariwtuley kiñe koriwen trariwe mew. Fey tañi ikeelchi iyael chori ürke ka lelfün mew mülechi miel. ");
INSERT INTO arnNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalen müleyechi pu che ka fentren che tati mülelu Judea tañi trokiñ mapu mew ka fülküleyechi trokiñke mapu ta Jordan lewfü püle, tripapay engün ñi allkütuael. ");
INSERT INTO arnNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kom che feypi ñi yafkafengen, fey Juan fawtisafi ti pu che tati Jordan lewfü mew. ");
INSERT INTO arnNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Welu Juan pefilu fentren pu farisew ka sadusew ñi akun kisu mew tañi fawtisangeael, fey feypifi: “¡Llükanngechi llepü filu reke ta feleymün! ¿Iney anta feypieymünmew tamün duamtun ta montun ti fülkülepachi fütra kutrankawün mew? ");
INSERT INTO arnNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Welu feley ñi küme kimfalael tamün mongen mew tamün wiñorakiduamtun ta Ñidol mew. ");
INSERT INTO arnNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Rakiduamkilmün tamün welukonkechi feypiael müten: ‘Abraam ñi tuwünche ta iñchiñ’. Iñche ta feypiwayiñ: Ngünechen tüfachi pu kura femkünuafuy Abraam ñi yomelchengeael. ");
INSERT INTO arnNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tati toki ta dew pepikaley ñi folil katrünentuafiel ta anümka. Fey kom anümka wülkenolu küme fün katrüngeay ka tukungeay ta kütral mew. ");
INSERT INTO arnNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Iñche ta fawtisakefiñ ko mew tati pu che rüf dungu mew wiñorakiduamtulu tañi yafkan mew, welu tati inalepalu iñche mew, fawtisacheay ti Lif Küme Püllü mew ka kütral mew reke. Kisu ta doy fütra pepiluwün niey ta iñche mew. Iñche fente tañi yamniefiel mew ta kisu nentupüroñmalayafuiñ rume tañi okota. ");
INSERT INTO arnNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kisu nüniey tati trüytrüywe tañi püntülafiel ta kachilla ka ñi wichunentuafiel tati pinu. Kisu ñi elketranwe mew tukuafi ti kachilla, fey tati pinu ütrüftukuafi chumkawnorume chongnoachi kütral mew.” ");
INSERT INTO arnNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Fey Jesus tripapay ta Galilea ñi amuael ta Jordan lewfü püle, chew ñi mülemum ta Juan, fey kisu tañi fawtisayaetew. ");
INSERT INTO arnNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Welu Juan pilafuy tañi fawtisayaetew, fey ka feypieyew: —Eymi may ta felefuy tami fawtisayafiel, fey ¿chumngelu am eymi küpaymi iñche mew? ");
INSERT INTO arnNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Fey Jesus llowdungufi ta Juan: —Fey tüfa famngechi felepe. Doy kümey tayu femael kom tañi feypikünuelchi werkün dungu ta Ngünechen. Feymew wüla ta Juan eluwi ñi fawtisayafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Fawtisangelu müten ta Jesus, tripapatuy ta ko mew. Feymew müten wengatripay reke ta kallfü wenu, fey Jesus pefi ñi nagpan ta Ngünechen ñi Lif Küme Püllü kiñe palluma reke, fey akuy kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ka allküngey ta kiñe dungun wenu mapu mew, feypilu: “Fey tüfa ta iñche ñi sakin Fotüm, ñi fentren manelnieel” pi ti dungun. ");
INSERT INTO arnNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Feymew müten tati Lif Küme Püllü ñi pepiluwün mew, Jesus puwi ti uwe mapu mew, tañi kintukaduamaetew tati weküfü. ");
INSERT INTO arnNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Fey meli mari antü ka meli mari pun ilay chem no rume, feymew wüla ngüñüy. ");
INSERT INTO arnNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Fey tati weküfü fülkontufi ta Jesus ñi kintukaduamafiel, ka feypifi: —Rüf dungu mew Ngünechen ñi Fotümngelmi, werkünge tañi kofkewtuael ta tüfachi pu kura. ");
INSERT INTO arnNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Welu Jesus ta llowdungueyew: —Tati Wirin Chillka ta feypiley: ‘Re kofke mew müten mongeluwkelay ta che, welu may mongeleay Ngünechen ñi dungu mew.’ ");
INSERT INTO arnNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Feymew tati weküfü ka yefi ta Jesus tati fütra küme waria Jerusalen mew, fey pürampufi ta doy alü pürachi wechuñ ngillatuwe ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ka feypifi: —Rüf dungu mew Ngünechen tañi Fotümngelmi, ütrüfnagümuwnge tüfa mew, tati Wirin Chillka am feypilelu: ‘Ngünechen ta werküay tañi pu werken püllü tami llüwatunieaetew. Fey pürüm witrañpüramaeymew engün tañi kuwü mew, femngechi tami allfüpunoael ti pu kura mew.’ ");
INSERT INTO arnNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Fey Jesus llowdungueyew: —Ka femngechi feypiley tati Wirin Chillka: ‘Kintukaduamkefilnge tami Ñidol Ngünechen.’ ");
INSERT INTO arnNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Fey ti weküfü ka puwülfi ta Jesus kiñe alü pürachi fütra wingkul mew. Pengelelpufi kom fütrake trokiñke mapu ka itrofill kümeke felen ñi nieel, ");
INSERT INTO arnNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","fey feypifi: —Püramyeeli ngillatun mew, iñche eluaeyu kom tami peel. ");
INSERT INTO arnNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Fey Jesus ta llowdungueyew: —Kiñe püle tripange, weküfü. Tati Wirin Chillka feypiley: ‘Püramyeafimi ngillatun mew ka poyeafimi tami Ñidol Ngünechen müten.’ ");
INSERT INTO arnNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Feymew ta weküfü elkünutufi ta Jesus, fey kiñeke werken püllü akuy tañi poyeafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Feymew Jesus allkülu ñi püresuntukungen ta Juan karsel mew, fey amuy ta Galilea mapu mew ñi puwael Nasaret waria mew. ");
INSERT INTO arnNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Welu mülenaglay ta Nasaret mew, fey amuy ta Kapernaum waria mew tañi mülepuael, inaltu Galilea lafken, Sabulon ka Neftali tañi trokiñche ñi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Fey ta famngechi femi tañi mupiael tati pelon wentru Isaia ñi wirintukuelchi dungu: ");
INSERT INTO arnNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sabulon ka Neftali tañi mapu, fül Jordan lewfü, ka lafken ad püle, Galilea mapu chew tañi mülemum tati pu judiu tuwünngenochi che. ");
INSERT INTO arnNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tati dumiñ mew reke mülechi pu che pefi kiñe fütra pelon. Tüfeychi pu che dumiñmalelu reke ñi wesake dungu mew alofmaeyew reke kiñe fütra küme dungu” pi. ");
INSERT INTO arnNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Feychi mew Jesus eluwi tañi wewpiael fey ta famngechi: “Wiñorakiduammün tamün yafkan mew. Dew fülkülepay ta Ngünechen tañi longko ülmenngen” pi. ");
INSERT INTO arnNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Fey kiñe antü Jesus miyawlu inaltu ti Galilea pingechi lafken püle, pefi ti epu peñiwen, Simon ürke, tati Pedro pingekelu, ka Andre. Mür challwafe ürke engu, fey petu ütrüftukurkey ñi challwawe pu lafken. ");
INSERT INTO arnNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Fey Jesus feypifi ti epu wentru: —Inamuchi, tamu challwafengefel, welu tüfa kintuafimu ta che tamu küpalafiel iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Feymew müten elkünuy engu ñi challwawe, fey inaeyew engu. ");
INSERT INTO arnNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ka pichi doy üyewpüle, Jesus pefi kangelu epu peñiwen: Santiaw ka Juan, Sefedew ñi epu fotüm, kiñentrür mülelu ñi chaw engün kiñe farku mew petu raletulu ñi challwawe. Fey Jesus mütrümfi ti epu wentru, ");
INSERT INTO arnNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","feymew ka müten kisu engu elkünuy tañi farku ka tañi chaw, fey inaeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus miyawürkey kom püle Galilea trokiñ mapu mew ñi kimeltuyawael fill püle mülechi sinagoga mew. Kimeltukey tati küme dungu ñi fülkülepan Ngünechen ñi longko ülmenngeael ka mongelyekefi tati pu kutrankülelu epe fill kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nütramyengey ta Jesus Siria trokiñ mapu mew, ka küpalelngeyey epe fill kutran ka fill wesake felen nielu, ka ti pu konweküfülelu, ka tati pu lalatukelu, ka tati pu lañmalelu ñi kuerpu. Fey Jesus kom mongeltufi ti pu kutran. ");
INSERT INTO arnNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Fey inaeyew fentren che tuwlu ta Galilea mapu mew, ka Dekapolis trokiñ mapu mew tuwlu, Jerusalen waria tuwlu, Judea trokiñ mapu tuwlu, ka fentren che tuwlu Jordan lewfü ñi tripawe antü püle mülechi trokiñ mapu. ");
INSERT INTO arnNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pefilu tati fentren che, Jesus pürapuy kiñe wingkul mew ka anükünuwpuy. Fey ñi pu disipulu fülkontupueyew, ");
INSERT INTO arnNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","fey Jesus llituy tañi kimeltuafiel, feypilen mew: ");
INSERT INTO arnNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ayüwün niey tati duamnielu ñi llowael Ngünechen ñi küme dungu, kisu engün ta koneltuley Ngünechen tañi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ayüwün niey tati pu weñangkülelu, Ngünechen am yafülaetew engün. ");
INSERT INTO arnNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ayüwün niey tati ñom piwkengelu, kisu engün am llowalu tati mapu Ngünechen tañi tukulpakünuletew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ayüwün niey tati ngüñülelu ka wüywülelu reke ñi femael Ngünechen tañi ayükeelchi dungu, kisu engün lloway itrokom ñi ayütunieel Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ayüwün niey tati kutranduamyekefilu ta kakelu che, Ngünechen ta ka femngechi kutranduamyeaeyew ta kisu engün. ");
INSERT INTO arnNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ayüwün niey tati lif piwkengelu, kisu engün peafi ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ayüwün niey tati ngülamtukefilu kom kakelu che ñi kümelkawkületuael, Ngünechen am ta ‘iñche ñi yall’ ñi piaetew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ayüwün niey tati kutrankawkelu ñi kayñetuyawülngen mew ñi femkeel mew Ngünechen ñi werkünieelchi dungu, Ngünechen tañi ülmen mülewe mew ta koneltuley. ");
INSERT INTO arnNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ayüwküleaymün ta eymün, iñche ñi duam fillpikaelmünmew ta pu che ka kutrankangelmün, ka üyawtungelmün epe fill koyla dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ayüwküleaymün, lliduamküleaymün, eymün am llowalu kiñe fütra fürenen ta wenu mapu, ka femngechi ta kayñetuyawülngekefuy tati pu pelon wentru tati wüne mülekelu ta eymün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Eymün ta chadi reke feleymün tüfachi mapu mew. Welu tati chadi kotrüwetunole, ¿chumngechi chey ta ka wiñome kotrütuafuy? Kümewekelay, fey ütrüfentukünungekey ta rüpü mew, fey tati pu che pünokakeeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Eymün ta küde reke feleymün ta tüfachi mapu mew. Kiñe waria mülelu wingkul mew ñi nien mew küde kom pengekey, ");
INSERT INTO arnNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","üyümngekelay ta kiñe pelontuwe tañi takukünungeael ta kiñe kakon mew, fey ta renukünungekey may tañi pelontunieafiel kom tati mülelu ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ka femngechi, eymün tamün pelon feley ñi alofael ta kom che mew, feymew pefile engün eymün tamün femken kümeke dungu, püramyeafi engün ta wenu mapu mülechi Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Iñche ñi küpan mew apümafilu tati ley dungu ka tati pu pelon wentru tañi kimeltuelchi dungu trokiwkülekilmün. Küpalan tañi apümafiel, welu may iñche küpan tañi doy küme mupiael kisu engün tañi piel. ");
INSERT INTO arnNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Rüf dungu ta feypiwayiñ petu tañi mülen ta wenu mapu ka tüfachi nag mapu, entuñmangelayay tati ley dungu kiñe puntu ka kiñe letra no rume, kom mupile wüla Ngünechen ñi adkünuelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Feymew, tati müngeltunolu kiñeke tati werkün dungu ñi nieel tati ley dungu, tunte pichin dungungeay rume, ka kimeltunofile rume tati pu che ñi müngeltuael engün, Ngünechen tañi ülmen mülewe mew doy illamtuniengeay. Welu tati müngeltulu ka kimeltufilu ta kangelu ñi müngeltuael kay, fey ta rume sakin chengeay ta wenu mapu, Ngünechen tañi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Fey ayülen tamün kimael tüfachi dungu: doy küme dungu femnolmün tati pu kimeltukelu tati ley dungu ka tati pu farisew mew, chumkawnorume konpulayaymün Ngünechen tañi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Eymün ta allkükeymün tamün kuyfike laku em tañi feypingeel engün: ‘Langümchekilnge. Tati langümchelu fey ta kondenangeay.’ ");
INSERT INTO arnNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Welu iñche ta feypiwayiñ iney rume wesa lladkütule tañi chafche, fey ta ka femngechi kondenangeay. Tati wesa pifilu tañi chafche, ramtukadungungeay tañi femel mew. Ka tati fillpikafilu tañi chafche, fey dew adküley reke tañi amuael ta kütral mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Feymew ka femngechi yealmi tami mañumtun ta ngillatuwe mew, fey tukulpalmi tami yafkawkülen tami peñi eymu, ");
INSERT INTO arnNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","elkünunge tami mañumtun tati ngillatuwe mew, fey wüne amunge tami kümelkawtuael tami peñi eymu. Fey wüla amuaymi ti ngillatuwe mew tami chalintukuael tami mañumtun. ");
INSERT INTO arnNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Iney rume ta wingkañmaelmew ka mütrümfalelmew tami trafdunguaetew, fey petu tami puwnon ti kues mew, küme dungufinge tamu kümelkawtuael. Fey femngechi tami wültukungepunoael tati kues mew, fey tati kues am ta ka femngechi wültukuaetew eymi tati pu soltaw mew, fey püresuntukukünungeaymi ta karsel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Rüf dungu ta feypiaeyu tripalayaymi ta tüfey mew kom küme kullilmi wüla tami femel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Eymün ta allkükeymün ñi feypingen ta kuyfi mew: ‘Ñiwaldomokilnge.’ ");
INSERT INTO arnNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Welu iñche ta feypiwayiñ iney rume lif piwke mew adkintunofile ta kiñe domo, dew ñiway tati domo engu kisu tañi piwke mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Femngechi llemay, tami man nge ñi duam yafkakelmi, nentufinge, fey famentufinge ta eymi mew. Doy kümey ta pichin müten tami kuerpu ñi ñamael, fey kom tami kuerpu tañi ütrüftukungenoael ta kütral mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tami man kuwü ñi duam yafkakelmi, katrünentufinge, fey famentufinge ta eymi mew. Doy kümey ta pichin müten tami kuerpu ñi ñamael, fey kom tami kuerpu ñi ütrüftukungenoael ta kütral mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ka feypingey ta kuyfi mew: ‘Iney rume ta wüdafile tañi kure, feley tañi eluafiel kiñe wirin dungu tañi wüdafiel mew tañi kure.’ ");
INSERT INTO arnNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Welu iñche ta feypiwayiñ kiñe wentru wüdale tañi kure, welu ti domo ñiwanole kangelu wentru mew, wültukumekefi tañi ñiwayael ta kangelu wentru engu. Fey kangelu wentru kureyefile tati wüdakünuelchi domo, fey ta ñiwaldomofengeay. ");
INSERT INTO arnNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ka femngechi allkükeymün eymün tañi feypingeken tamün fütake laku em: ‘Femkünukilmün tamün mupiael tamün chalintukulelfiel ta Ñidol kuyalltun mew.’ ");
INSERT INTO arnNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Iñche ta feypiwayiñ tamün kuyalltunoael ta chem dungu mew no rume. Kuyalltun mew tukukefilmün ta wenu mapu, Ngünechen am nielu ñi longko ülmen mülewe ta wenu mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ka femngechi üytukefilmün kuyalltun mew tüfachi mapu, Ngünechen am tañi namun reke pünolelu ta tüfa mew. Ka femngechi üytukefilmün kuyalltun mew Jerusalen waria no rume, Ngünechen ñi dullielchi waria tatey. ");
INSERT INTO arnNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ka üytukefilmün kuyalltun mew tamün longko no rume, ligkünulayafuymün rume kam kurükünulayafuy rume kiñe tamün kal longko. ");
INSERT INTO arnNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Fey ta famngechi ‘may’ pilmün, femngechi felepe. ‘Felelay’ pilmün, felekilpe, fey tati doyelchi amulkünulu tañi dungu, fey ta kümelay. ");
INSERT INTO arnNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Eymün allkükeymün ñi feypingekefel ta kuyfi mew: ‘Kiñe che entuñmangele kiñe nge feley ñi entuñmangeael ñi nge kay ti entungechelu, ka kiñe che entuñmangele kiñe ayewe foro ka femngechi feley ñi entuñmangeael ñi ayewe foro.’ ");
INSERT INTO arnNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Welu iñche ta feypiwayiñ: kewalayafimi tami wesake femkeetew. Tami femafel, iney rume wülelelmew tami ange mew, ka adkünulfinge kangelu ad püle tami ange. ");
INSERT INTO arnNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Iney rume müntuñmaelmew tami kamisa, ka eluwnge tami yeñmaetew tami chaketa. ");
INSERT INTO arnNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ka femngechi kiñe kilometro ka rangiñ ‘yelelen tüfachi fane chemkün’ pielmew, eymi küla kilometro meñku yelelafimi. ");
INSERT INTO arnNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Iney rume ngillatuelmew chem rume, elufinge ka wiñonentukefilnge tami aretuetew chem rume. ");
INSERT INTO arnNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ka femngechi allkükeymün tañi feypingeken ta kuyfi mew: ‘Piwkeyeafimi tami weni ka üdeafimi tami kayñe.’ ");
INSERT INTO arnNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Welu iñche ta feypiwayiñ: piwkeyefimün tamün pu kayñe ka ngillatuñmayafimün tamün malisiakeetew. Füreneafimün tamün üdekeetew ka ngillatuñmayafimün tamün pu kayñetukeetew ka tamün kutrankakeetew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Femngechi ta eymün tamün wenu mapu mülechi Chaw tañi yall pingeaymün, kisu am wülkelu ñi antü kom tati kümeke dungu femkelu mew ka tati wesake dungu femkelu mew, ka wülkey tañi mawün ti pu nor piwkengelu mew ka ti wesake piwkengelu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Eymün ta piwkeyefilmün tamün piwkeyekeetew müten, ¿chem küme femün am tüfey? Tati kofrakelu impuestu Romangealu kütu ta famngechi femkey. ");
INSERT INTO arnNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ka chalifilmün tamün pu weni müten, ¿chem küme femün am tüfey? Tati pu che feyentukenolu Ngünechen mew kütu ka femngechi femkey. ");
INSERT INTO arnNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Feymew feley tamün nor piwkengeael, chumngechi nor piwkengey tamün Chaw Ngünechen wenu mapu mülelu. ");
INSERT INTO arnNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Femkilmün kümeke dungu re tamün peaetew ti kakelu pu che. Femngechi femülmün, tamün Chaw ta mülelu wenu mapu chem mew rume fürenelayaeymünmew. ");
INSERT INTO arnNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Feymew, kellufilmi tati duamtunielu tañi elungeael, kom che mew kimngekilpe tami elufiel, chumngechi femkey tati küme piwkefaluwkechi pu che sinagoga mew ka rüpü mew. Dungulkey engün kullkull femngechi tati pu che ñi küme tukulpayaetew ta kisu engün. Femngechi femle engün, dew llowi engün tañi kullitu. ");
INSERT INTO arnNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Eymi kellufilmi tati pu pofrengelu, kimlayay tami femün tami doy küme weni no rume. ");
INSERT INTO arnNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nütramyekilnge tami wülelchi chemkün, fey tami Chaw peelmew tami wülün fey ñi kimnon iney no rume rume füreneaeymew femngechi ta kom che ñi kimael. ");
INSERT INTO arnNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Eymün ta ngillatulmün, femkelayaymün tati pu che reke re ngünen mew küme piwkefaluwkelu. Kisu engün ta ayükey ñi ngillatuael tati sinagoga mew ka tati pülasa mew femngechi kom che tañi peaetew. Rüf dungu feypiwayiñ femngechi ta kisu engün dew llowi tañi kullitu. ");
INSERT INTO arnNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Welu eymi, ngillatualmi, konnge tami katrüntuku ruka mew, rakümnge tami wülngiñ, fey kisu ngillatunge tami wenu mapu mülechi Chaw mew. Fey tami Chaw tami pekenoel, ellkan mew pekelu tami chumün, eluaeymew tami duamtuel femngechi ta kom che ñi kimael. ");
INSERT INTO arnNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Fey ngillatulmün ka wiñome feypikefilmün tamün dew ngillatuelchi dungu, chumngechi femkey tati pu feyentukenolu Ngünechen mew. Ngillatukawle doy allküñmayaetew Ngünechen trokiwkey engün. ");
INSERT INTO arnNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Fey engün reke femkelayaymün. Tamün wenu mapu Chaw dew kimniey chem tamün duamtunien, petu tamün ngillatunofiel rume. ");
INSERT INTO arnNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Fey eymün ta famngechi ngillatukeaymün: ‘Taiñ Chaw Ngünechen wenu mapu mülelu, yamniengepe tami üy. ");
INSERT INTO arnNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Itrokom che kimpe tami longko ülmenkülen kisu engün mew. Chumngechi müngeltuniengeymi wenu mapu, ka femngechi müngeltun mülepe tüfachi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Eluniemuiñ taiñ duamtuelchi kofke kake kiñeke antüngealu. ");
INSERT INTO arnNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wiñoduamamuiñ taiñ femkeelchi wesake dungu, chumngechi ta iñchiñ wiñoduamatukefiyiñ taiñ femkeetew ti wesake dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kintukaduamngeliyiñ, elumukeliyiñ taiñ femael wesake dungu ka montulniemuiñ kom wesake dungu mew. Eymi ta longko ülmen wenu mapu mew ka nieymi pepiluwün ka fütra küme felen ka rumel feleay amuleachi tripantu mew. Felepe may.’ ");
INSERT INTO arnNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Eymün ta wiñoduamatufilmün ta kakelu tamün wesake femkeetew, tamün Chaw ta wenu mapu mülelu ka femngechi wiñoduamatuaeymünmew ta eymün. ");
INSERT INTO arnNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Welu wiñoduamanofilmün ta kakelu che, ka femngechi wiñoduamalayaeymünmew tamün Chaw eymün tamün yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Eymün ta ayunalmün, weñangkülelu reke felekelayay tamün ange, tati küme piwkekawünngechi pu che reke. Weñangkülelu reke felekey engün ‘petu ayunarkey’ tañi piaetew tati pu che. Iñche ta feypiwayiñ fey tüfey tañi femün mew engün, dew llowi tañi kullitu. ");
INSERT INTO arnNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Eymi ta ayunayalmi, küllumtunge ka küme eluwnge ");
INSERT INTO arnNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tañi kimfalnoael tami ayunalen. Fey tami wenu mapu Chaw müten ta kimay eymi tami ayunalen, fey kisu füreneaeymew femngechi ta kom che ñi kimael. ");
INSERT INTO arnNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Trapümkakilmün fentren küme felen ta tüfachi mapu mew, tati wesake üñfew tañi filladtukeel ka tañi wesañmawelkeel tati chemkün, ka tati pu weñefe ñi filladtukeel ñi weñeael. ");
INSERT INTO arnNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Welu may müngeltufimün ta Ngünechen femngechi tamün nieael küme felen ta wenu mapu mew, tüfey mew tati wesake üñfew filladtukelay ka ti chemkün rume wesañmawkelay ka ti pu weñefe rume konpukelay ñi weñeael. ");
INSERT INTO arnNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Fey chew müley tami küme felen, feymew puwküleay tami rakiduam. ");
INSERT INTO arnNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Tami nge kiñe pelontuwe reke feley tami kuerpu mew, fey puwkülele kintun kiñe küme rakiduam mew, kom tami kuerpu mew müleay reke ta pelon. ");
INSERT INTO arnNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Welu femngechi femnole, kom tami kuerpu dumiñmaleay reke. Fey tami rakiduam dumiñmalele reke, ¡doy wesalkaley tati dumiñ mew! ");
INSERT INTO arnNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Iney rume ta poyelayafuy epu ülmen wentru tañi mür küdawelafiel. Kiñe müleafuy ñi illamafiel, fey kangelu ñi poyeafiel. Küme puwtunieafi kiñe, fey illamtuafi kangelu. Fey ta famngechi pepi poyengelayafuy ta Ngünechen ka fentren chemkün. ");
INSERT INTO arnNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Feymew ta, iñche feypiwayiñ: fill rakiduamkülekilmün chem tamün iyael ka tamün pütokoael femngechi tamün mongeluwküleael, takuwün mew no rume tamün tukuael. Mongen doy faliy ta iyael mew, ka femngechi ta kuerpu doy faliy takuwün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ngüneduamfimün tati pu üñüm: ngankelay engün ka kosechakelayngün rume, ka nielay engün kakon rume ñi elkünuael ñi fün ketran, welu eymün tamün Chaw Ngünechen mülelu ta wenu mapu elukeeyew ta iyael. ¡Fey eymün ta doy faliymün tati pu üñüm mew! ");
INSERT INTO arnNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Iney rume fill rakiduamkülele, doy alüntupeafuy may ñi mongen kiñe ora rewall? ");
INSERT INTO arnNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Chumngelu anta fente rakiduamkeymün chumngechi tamün peael ta takuwün? Ngüneduamfimün chumngechi ñi tremken tati lelfün mew mülechi rayen: küdawkelay ka füwkelay engün rume. ");
INSERT INTO arnNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Welu feypiwayiñ tati longko ülmen Salomon rume, kom tañi nieelchi kümeke takuwün mew, tüfachi pu rayen mew trürlafi. ");
INSERT INTO arnNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ngünechen elukefi ñi tremküleael ti pu rayen. Kiñe mufü antü müten mülekey, welu müchay müten lüpümtukeeyew ta kütral. Fey Ngünechen femngechi femfile tati pu rayen, doyelchi may eluaeymünmew tamün tukutuwael eymün, ti pu che newe mupiltulenolu. ");
INSERT INTO arnNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Fey fill rakiduamkülekilmün, ramtukawün mew: ‘¿Chem am iyaiñ?’ kam ‘¿Chem am pütokoaiñ?’ ");
INSERT INTO arnNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kom tüfachi dungu ta rakiduamelkeeyew tati pu feyentulenolu ta Ngünechen mew, welu eymün ta nieymün kiñe wenu mapu Chaw kimnielu kom tamün duamtunieel. ");
INSERT INTO arnNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Doyümnieafimün Ngünechen tañi longko ülmenngen ka tañi nor dungu ñi nien, fey kom tamün duamtunieel ka femngechi llowaymün. ");
INSERT INTO arnNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Feymew fill rakiduamkülekilmün tamün chumael ta wüle, fey wüle wüla kimaymün tamün chem chumael. Kake antü ta kisuke nieyey fentren welulkawünngechi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Entuüñfilkefilmün ta kakelu pu che, fey Ngünechen küme trokituaeymünmew. ");
INSERT INTO arnNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngünechen ta ramtukadunguaeymünmew ta eymün chumngechi tamün dunguyekefiel ta kakelu che. Ka feychi mediwe mew eymün tamün medikemum, Ngünechen ta medileltuaeymünmew ta eymün. ");
INSERT INTO arnNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“¿Chumngelu anta adkintuñmakefimi ñi pichi yafkan ñi nieel ta kangelu che kiñe pichi itrom pinu reke felelu ñi nge mew, fey tami ngüneduamnofiel ti fütra yafkan tami nieel ta eymi kiñe fütra trolüf mamüll reke felelu tami nge mew? ");
INSERT INTO arnNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Fey eymi nielmi kiñe fütra trolüf mamüll kisu tami nge mew, ¿chumngelu anta feypiafimi tami peñi: ‘Entulelaeyu tami itrom pinu tami nieel tami nge mew’? ");
INSERT INTO arnNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Küme piwkefaluwkelu! Wünelu mew wiñorakiduamtunge tami fütra yafkan mew, fey wüla ngülamafimi ta kangelu che ñi pichi yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nütramelkefilmün ti küme dungu tati üdekefilu ti küme dungu lladkülechi trewa reke felelu engün am, fey lefkontuafeymünmew ka ünatuafeymünmew, ka podkülechi sañwe reke feleyngün, fey falintulayafuy engün ti küme dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ngillatulemün, fey Ngünechen eluaeymünmew. Kintuaymün, fey peaymün. Mütrümaymün ta wülngiñ mew, fey nülalngeaymün. ");
INSERT INTO arnNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tati ngillatulelu am, llowkey. Tati kintulu, pekey. Ka tati mütrümlu wülngiñ mew, fey ta nülalngekey. ");
INSERT INTO arnNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Kiñeke ta eymün elupeafuymün may tamün fotüm kiñe kura, ‘eluen kofke’ pielmünmew? ");
INSERT INTO arnNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Ka elupeafuymün may kiñe filu ‘eluen challwa’ pielmünmew? ");
INSERT INTO arnNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Fey eymün, tamün wesake piwkengefel rume, elukefimün kümeke chemkün tamün pu yall, ¡doyelchi femay tamün Chaw wenu mapu mülelu, fey eluaeymünmew re kümeke chemkün iney rume ‘eluen’ pieleyew ñi duamtuel! ");
INSERT INTO arnNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ka femngechi ta femaymün ta eymün ta kakelu pu che mew chumngechi ta ayükeymün tamün küme trokituaetew kakelu pu che. Fey tüfa famngechi mupikey kom ñi werküel tati ley dungu ka tañi wirintukuel tati pu pelon wentru. ");
INSERT INTO arnNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Konpuaymün tati pichi rupachi wülngiñ mew. Alü rupay ka rume feyünngey tati wülngiñ ka tati rüpü yeniefilu ta che welulkawün mew, fey rume fentren che amuley feychi rüpü mew. ");
INSERT INTO arnNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Welu tati wülngiñ ka ti rüpü yeniefilu ta che rumel mongen mew, pichi rupay ka müna küdawngey ñi inangeael, fey rume pichin che konpukey tüfachi wülngiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kuñiwtuwmün tati pu koyla ngünen kimeltufe mew, fey Ngünechen ñi dungu dungufaluwkey engün. Ufisa reke akukey ta eymün mew, welu tañi piwke mew lladkülechi trapial reke feley engün. ");
INSERT INTO arnNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Eymün ta ngüneduamafimün tañi femkeel mew engün, sarsa mew ta entungekelay ta ofad, ka igo entungekelay ta troltro mew. ");
INSERT INTO arnNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Femngechi, kom kümeke anümka wülkey kümeke fün, welu tati wesake anümka wesake fün wülkey. ");
INSERT INTO arnNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tati küme anümka wül-layafuy ta wesake fün, ka ti wesa anümka no rume wül-layafuy kümeke fün. ");
INSERT INTO arnNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kom anümka wülkenolu kümeke fün, katrüngekey ka kütraltungekey. ");
INSERT INTO arnNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Feymew tüfachi koyla ngünen kimeltufe kimngeay tañi femkeelchi dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kom tañi feypikeetew: ‘Ñidol, Ñidol’, konpulayay engün ta Ngünechen tañi ülmen mülewe mew. Tati femkelu may iñche ñi Chaw wenu mapu mülelu ñi ayükeelchi dungu, konpuay tüfey mew. ");
INSERT INTO arnNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Feychi antü ta fentren che feypiaenew: ‘Ñidol, Ñidol’, iñchiñ ta dungukeiñ eymi tami üy mew. Eymi tami üy mew wemünentukeiñ weküfü, ka eymi tami üy mew femiyiñ afmanngechi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Welu feymew iñche llowdunguafiñ: ‘Chumkawnorume kimuwkelayiñ. ¡Kiñe püle tripamün iñche mew, wesake dungu femkelu!’ ");
INSERT INTO arnNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Feymew tati pu che allküñmapeetew ñi dungu ka femlu iñche tañi piel, fey tüfachi kim wentru reke femngey tati dewmalu tañi ruka chapüntu kura mew. ");
INSERT INTO arnNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Eluwi ñi mawael, fey mangiy ta lewfü ka rupay fütra kürüf, welu nengümlay rume tati ruka, chapüntu kura mew am anümkülelu. ");
INSERT INTO arnNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Welu tañi allküñmapeetew ñi dungu, fey femnolu iñche tañi piel, fey ta kiñe wedwed wentru reke feley tati dewmalu tañi ruka wente kuyüm. ");
INSERT INTO arnNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Eluwi ñi mawael, fey mangiy ta lewfü. Fütra kürüfmay ti ruka, fey tranarupay. ¡Rume wesa dungu mew rupay!” ");
INSERT INTO arnNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Feymew Jesus rupan dungulu, ti pu che rume afmatulewey, Jesus am kimeltunolu chumngechi kimeltukey tati pu wentru kimeltukelu tati ley dungu. Kisu ta kimeltuy fentren pepiluwün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Fey Jesus nagpatulu tati wingkul mew, rume fentren che inaeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Feymew fülkontueyew kiñe kutrankülechi wentru nielu lepra kutran, fey lukunagpay kisu ñi fül mew ka feypieyew: —Ñidol, pifulmi, tremoltuafen tañi kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Fey Jesus nüfi ti kutran ñi kuwü mew, fey feypifi: —Feley. ¡Tremotunge! Pichin mew müten, tati niekelu lepra kutran tremolewetuy ñi kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Feymew Jesus feypikünufi ti wentru: —Feypiaeyu, iney no rume feypilayafimi tüfachi dungu. Amunge, pewfaluwmenge tati saserdote mew müten, ka yenge ta ofrenda Moyse tañi feypikünuel ñi femael ta che, femngechi tañi kimael kom che tami dew tremolewetun tati kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus ta konpulu Kapernaum waria mew, kiñe Roma tuwchi kapitan fülkontueyew tañi “füreneen” ñi piaetew. ");
INSERT INTO arnNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Fey feypieyew: —Ñidol, iñche ñi kona müley ruka mew, rume kutranküley, pepi nengümlay rume. ");
INSERT INTO arnNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Fey Jesus llowdungufi ti kapitan: —Amuan tañi tremolafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Fey tati kapitan llowdunguy: —Ñidol, Ñidol, küpakilnge. Rume yamnieeyu tami konpuael iñche ñi ruka mew. Iñche ta Roma tuwünche. Fey eymi werkülmi müten, iñche tañi kona tremoltuay. ");
INSERT INTO arnNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iñche ta ka femngechi müley tañi werkünieetew, ka iñche ta nien soltaw tañi werkükeel. Feypifiyüm kiñeke soltaw ñi amuael, amukey. Fey feypifiyüm kangelu ñi küpayael, küpakey. Ka werküfiyüm tañi kona tañi chem chumael rume, fey femkey. ");
INSERT INTO arnNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesus allkülu tüfachi dungu afmatulewey, fey feypifi ti pu che ñi inanieetew: —Rüf dungu feypiwayiñ iney no rume ngelay israelche mew fente feyentulelu tüfachi wentru reke. ");
INSERT INTO arnNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Feypiwayiñ fentren che ñi küpayael tripawe antü püle ka konwe antü püle, ka anüay ñi iyael Abraam, Isaak ka Jakob engün Ngünechen tañi ülmen mülewe mew, ");
INSERT INTO arnNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","welu tati pu che mülefalfel tati ülmen mülewe mew, wemünentungeay wekuntu tati fütra dumiñ mew, chew tañi ngümayam ka kütrüram engün tañi foro. ");
INSERT INTO arnNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Feymew müten Jesus feypifi tati kapitan: —Amutunge tami ruka mew. Felepe kom chumngechi tami feyentun. Feychi lelen mew müten tañi kona tremolewetuy. ");
INSERT INTO arnNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesus amuy Pedro ñi ruka mew, feymew pepufi Pedro tañi llalla ngütantuluwkülelu, aling kutrankülelu am. ");
INSERT INTO arnNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus nüñmapufi tañi kuwü ti kuse, fey ti kuse mongetuy. Feymew Pedro tañi llalla witratuy, fey eluwi ñi poyeafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Fey punlu, yelelngey ta Jesus fentren che kontunieetew weküfü, fey kisu ñi dungun mew müten werküfi ñi tripayael tati pu weküfü. Ka femngechi tremolyefi kakelu pu kutran. ");
INSERT INTO arnNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Fey tüfa famngechi femi ñi mupiael tañi kimelkünuel tati pelon wentru Isaia, feychi feypilu: “Kisu kutrantupiwkey iñchiñ tati pu kutrankawkülelu mew, fey tremoltueiñmew taiñ kutran mew.” ");
INSERT INTO arnNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesus pefilu ti pu che tañi walloñmanieetew, werküy tañi nolngeael ta nome pichi lafken. ");
INSERT INTO arnNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Feymew fülkontueyew kiñe kimeltukelu Moyse tañi ley dungu, fey feypieyew: —Kimeltufe, ayülen tami inayafiel chew püle rume amulmi. ");
INSERT INTO arnNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Fey Jesus llowdungufi ti wentru: —Tati pu ngürü niey engün ta lolo ka tati pu üñüm niey engün ñi dañe, welu tati Wentrukünuwpalu nielay chew tañi küme kansatuam. ");
INSERT INTO arnNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Fey kiñe tati allkütuyawülkefilu, feypirkeeyew ta Jesus: —Ñidol, wüne üngüman ñi layael ñi fütakeche, fey wüla inayaeyu. ");
INSERT INTO arnNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Feymew Jesus llowdungufi ti wentru: —Eymi inaen, fey elkünufinge tati pu che la reke felelu ñi rüngalafiel tati pu la. ");
INSERT INTO arnNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesus konpuy kiñe farku mew, fey ñi pu disipulu kompañeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Feymew ti lafken mew triparumey kiñe fütra kürüf, fey rume newentu ingafpüramekey ti rew tati farku mew, welu Jesus umawturkey. ");
INSERT INTO arnNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Feymew tañi pu disipulu amuy ñi trepelmeaetew, fey feypimengey: —¡Ñidol, montulmuiñ! ¡Petu llañnagiyiñ! ");
INSERT INTO arnNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Fey kisu llowdunguy: —¿Chumngelu anta fente llükaymün? ¡Müna pichin mupiltun nieymün ta eymün! Feymew feypikünulu, witrapüray, fey werküfi tati kürüf ka ti rew lafken ñi tüngnagael. Feymew ti kürüf ka ti rew lafken tüngkülewetuy. ");
INSERT INTO arnNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Fey kisu engün, afmatulen welukonkechi ramtuwi engün: “¿Iney ürke am tüfachi wentru, kürüf ka ti rew lafken kütu ta müngeltueyew?” ");
INSERT INTO arnNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Feymew Jesus puwlu nometu pichi lafken, Gadara mapu mew, epu wentru konweküfülelu tripay engu eltun mew, fey fülkontupueyew ta kisu engu. Rume kuñiwünngerkefuy engu, fey iney rume rupakerkelay fülpüle chew ñi mülemum ta kisu engu. ");
INSERT INTO arnNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Fey eluwi engu ñi wirarün: —¡Kontumupakeliyiñ, Ngünechen ñi Fotüm! ¿Küpaymi anta faw tami kutrankamuafiel petu tañi puwnon tati medin antü? ―pi engu. ");
INSERT INTO arnNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Fülpüle tüfey mew mülerkey fentren sañwe ütayawlu, ");
INSERT INTO arnNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","fey llellipueyew ti pu weküfü: —Wemünentumuliyiñ, elumuiñ taiñ konpuael tüfeychi pu sañwe mew. ");
INSERT INTO arnNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Fey Jesus feypifi ti pu weküfü: —Amumün. Fey tati pu weküfü tripatuy tati epu wentru mew, fey konpuy engün tati pu sañwe mew. Fey pichin mew kom tati pu sañwe tuwi ñi lefmawün, fey lefkonpuy engün ti pichi lafken mew. Fey tüfey mew kom ürfipuy engün. ");
INSERT INTO arnNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tati pu kuydakefilu tati pu sañwe, tripay engün ñi lefmawün, fey puwlu waria mew nütramkapuy engün femngechi dungu ñi rupan, ka ñi küme feletun tati konweküfülekechi epu wentru. ");
INSERT INTO arnNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Feymew kom ti pu che mülelu ti waria mew tripapay engün, fey akuy chew ñi mülemum ta Jesus. Fey pefilu engün, llellipufi ñi tripatuael feychi lof mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Dew rupalu tüfachi dungu, Jesus konpuy kiñe farku mew. Notuy nome ti pichi lafken mew, fey puwtuy kisu tañi waria mew, Kapernaum pingelu. ");
INSERT INTO arnNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Feyti mew yelelngey kiñe kutran lañmalelu ñi kuerpu, kudulelu kiñe pichi ngütantu mew. Feymew Jesus ngüneduamfilu tati pu che ñi rume feyentulen engün, feypifi tati kutran: —Yafüluwnge, weni. Dew wiñoduamangetuymi tami yafkan mew ―pifi ti wentru. ");
INSERT INTO arnNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Fey kiñeke wentru kimeltukelu ta Moyse ñi ley dungu, allkülu tüfachi dungu, rakiduami engün: “Fey tüfa tañi feypielchi dungu mew notukafi ta Ngünechen.” ");
INSERT INTO arnNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus am kimnielu tañi femngechi rakiduamkülen engün, fey ramtufi ti pu wentru: —¿Chumngelu anta fente wesa rakiduamküleymün ta eymün? ");
INSERT INTO arnNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Chem pin anta doy küdawngelay? ¿Tañi wiñoduamangetuael che yafkan mew, kam ñi tremolngetuael kiñe kutran? ");
INSERT INTO arnNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Feymew tamün kimael tati Wentrukünuwpalu ñi nien ta pepiluwün tüfachi mapu mew ñi wiñoduamatuafiel ta che ñi yafkan mew, feypiafiñ tüfachi lemuwkenochi kutran: —Witratunge. Nütunge tami ngütantu, fey amutunge tami ruka mew ―pi. ");
INSERT INTO arnNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Fey tati kutran, lañmalelu ñi kuerpu, witratuy ka amutuy tañi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Fey tati pu che, pefilu tüfachi dungu ñi rupan, llükay ka püramyefi engün ta Ngünechen femngechi pepiluwün tañi pengelel ta wentru mew. ");
INSERT INTO arnNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus tripatuy ta tiye mew, fey pefi ta kiñe wentru Matew pingelu, anülelu chew tañi kofrakemum ta impuestu Romangealu. Fey Jesus feypifi ta Matew: —Inaen. Feymew Matew witrapüray, fey inaeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Feymew Jesus amuy ñi imeael Matew ñi ruka mew, rume fentren tati kofrakelu impuestu ta Romangealu, fey kakelu wesake dunguyen che puwi engün. Ka femngechi fülkonpuy engün ta mesa mew kiñentrür ñi iyael Jesus engün ka tañi pu disipulu. ");
INSERT INTO arnNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fey tati pu farisew, pefilu tüfachi dungu, ramtufi engün Jesus tañi pu disipulu: —¿Chumngelu am tamün kimeltufe kiñentrür imekey tati kofrakelu impuestu ka ti pu yafkafe engün? ");
INSERT INTO arnNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Fey Jesus allkülu ñi feypin engün, fey feypieyew: —Tati külfünkülelu ka mongelelu duamlay engün ta lawentuchefe, welu tati pu kutran may ta duami ta lawentuchefe. ");
INSERT INTO arnNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Amumün ka kimtukuaymün ñi chem piel ta tüfachi wirin dungu: ‘Iñche may ta duamnien tamün kutranpiwkeyecheael, welu tamün chalintukumekenoael tati langümelchi kulliñ müten.’ Iñche am küpanolu tati pu küme piwkekawünnngelu mew, welu may tati pu yafkafe ñi wiñorakiduamtuael ―pi. ");
INSERT INTO arnNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Fey Juan tati Fawtisachefe tañi pu disipulu fülkonpuy engün ta Jesus mew, fey ka ramtupufi: —Iñchiñ ka tati pu farisew ayunakeiñ, fey ¿chumngelu am tami pu disipulu kay ayunakelay engün? ");
INSERT INTO arnNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus llowdungueyew: —¿Weñangküleafuy am tati pu mangelngelu kiñe mafün mew, petu tañi mülen tati nofio ta kisu engün mew? Welu akuay ti antü ñi yengetuael tati nofio, fey wülake ta ayunayay engün. ");
INSERT INTO arnNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Iney rume ta lapatule ta kiñe llud takuwün, lapantukulelkelafi ta kiñe we katrün pañu. Tati lapantukuelchi we katrün pañu trüküfkey, fey doy wesa wikürkey tati llud takuwün, fey doy alükey tati wichafün ti lapatukeel. ");
INSERT INTO arnNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ka femngechi tukungekelay rume we pulku kiñe llud kueru mew. Femngefule, wikürafuy tati kueru, fey tati pulku ka tati kueru ngünapüdayafuy. Feymew feley tañi tukungeael tati we pulku kiñe we kueru mew, femngechi tañi fente küme chañmatuael tati epu chemkün. ");
INSERT INTO arnNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Petu dungumekelu ta Jesus, akuy kiñe longkolelu tati pu judiu mew, fey lukutunagi kisu ñi fülpüle ka feypieyew: —Tañi ñawe fewla we lapey, welu eymi amulmi ka fampuwülelfilmi tami kuwü, fey wiñomongetuay. ");
INSERT INTO arnNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Fey Jesus witrapüray, ka kompañnieeyew tañi pu disipulu, fey amuy tati wentru engün. ");
INSERT INTO arnNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Feymew kiñe domo amulerkelu mari epu tripantu dewma ñi kutrankülen, kachükerkelay ñi mollfüñ, fey fülkontufi ta Jesus furi püle, fey idañmafi ñi wechuñ takuwün. ");
INSERT INTO arnNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Famngechi rakiduamürkelu am: “Idañmafili müten tañi takuwün, tremolewetuan.” ");
INSERT INTO arnNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Welu Jesus wiñokintuy, fey pefi tati domo ka feypifi: —Yafüluwnge, papay. Tami feyentun mew ta tremotuymi. Feychi lelen mew müten tremolewetuy. ");
INSERT INTO arnNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Fey Jesus puwlu tati longko ñi ruka mew, ka pepufilu tati pu kim dungulu weñangkün musikatun ka ti pu che ñi ngümakawmeken, ");
INSERT INTO arnNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","fey feypipufi ti pu che: —Tripatumün ta tüfa mew. Tüfachi pichidomo ta lalay. Re umawküley müten. Fey Jesus ayeñeeyew ti pu che, ");
INSERT INTO arnNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","welu kisu feypifi ñi tripayael engün wekuntu ruka mew. Fey wüla konpuy ka nüñmapufi ñi kuwü tati pichidomo, fey tati pichidomo witrapüratuy. ");
INSERT INTO arnNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Fey kom tiyechi trokiñ mapu mew mülechi pu che kimi femngechi dungu ñi rupan. ");
INSERT INTO arnNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Fey tripapatulu ta Jesus tiye mew, epu trawma ta wirarkülen inaeyew: —¡David mew dullielchi Yomelche, kutranpiwkeyemuyu! ");
INSERT INTO arnNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Feymew Jesus konpulu ti ruka mew, tati epu trawma fülkontueyew, fey Jesus ramtufi ti epu trawma: —¿Feyentuymu anta eymu iñche tañi pepi femael ta tüfachi dungu? —May, Ñidol ―llowdunguy ti epu wentru. ");
INSERT INTO arnNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Feymew Jesus idañmafi ñi nge tati epu trawma, ka feypifi: —Femngechi felepe chumngechi tamu feyentulen ta eymu. ");
INSERT INTO arnNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Fey pelotuy engu. Feymew Jesus ta fente küme feypifi tati epu wentru: —Feypilayafimu iney no rume femngechi tañi kimngenoael tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Welu, tripapatulu müten, nütramkayngu kom tiyechi trokiñ mapu mew tañi femel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Petu tripatulu tati epu trawma, küpalngey Jesus mew kiñe ketrongechi wentru konweküfülelu. ");
INSERT INTO arnNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Fey Jesus wemünentufilu müten tati weküfü, tati ketrongechi wentru pepi dungutuy. Fey tati pu che afmatulen feypi: —¡Fey tüfa famngechi dungu chumkawnorume pengekelay Israel mapu mew! ");
INSERT INTO arnNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Welu tati pu farisew feypiyey engün: —Tati longkolelu ti pu weküfü mew elufi tüfachi wentru feychi pepiluwün tañi wemünentuafiel tati pu weküfü. ");
INSERT INTO arnNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus miyawenturkey kom ti pu waria che mew ka kom lelfüntripa mülechi pu che mew. Kimeltuyawi kom sinagoga mew. Kimeli tati küme dungu Ngünechen tañi longko ülmenngen, ka tremolyefi fill kutrankülelu ka ngañkolelu. ");
INSERT INTO arnNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Fey Jesus pefilu tati pu che, kutranpiwkeyefi kisulelu engün am kiñe kechan ufisa reke nienolu tañi kamañnieaetew. ");
INSERT INTO arnNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Feymew feypifi tañi pu disipulu: —Rüf dungu mew pütrüley ta kosecha, welu küdawfe rume pichiley. ");
INSERT INTO arnNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Feymew ngillatuafimün ta eymün tati ngenngelu tati ngan ketran mew ñi werküael küdawfe tañi kosechayael ti fün ketran. ");
INSERT INTO arnNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus mütrümi tañi mari epu disipulu, ka elufi ta pepiluwün tañi wemünentuafiel tati pu weküfü ka ñi tremolafiel tati pu che epe fill kutran mew kutrankawkülelu. ");
INSERT INTO arnNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Fey tüfa tañi üy tati mari epu apostol: wünelu mew ta Simon, tati Pedro pingekelu, ka kisu tañi peñi Andre pingelu; Santiaw ka kisu ñi peñi Juan pingelu, Sefedew tañi epu fotüm; ");
INSERT INTO arnNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe ka Bartolome; Tomas ka Matew, tati kofrakelu impuestu Romangealu; Santiaw, Alfew tañi fotüm, ka Tadew, ");
INSERT INTO arnNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon tati kananita, ka Juda Iskariote, fey tüfa tati ngünenmafilu ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesus werküfi ñi tripayael ta tüfachi mari epu wentru, fey famngechi kimeltukünufi: “Ti pu judiu tuwünngenolu ñi trokiñ mapu mew konpulayaymün, ka tati pu samariache tañi waria mew ka femngechi konpulayaymün. ");
INSERT INTO arnNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amuaymün may tati pu Israel trokiñche mew, tati ñamkülechi ufisa reke felelu. ");
INSERT INTO arnNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Amulelmün fey kimelaymün ñi fülkülepan Ngünechen tañi longko ülmenngeael. ");
INSERT INTO arnNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tremolafimün tati pu kutran, wiñomongeltuafimün tati pu la, liftutuafimün ñi kutran mew tati pu lepra kutran nielu ka wemünentuafimün tati pu weküfü. Eymün ta re elungeymün ta tüfachi pepiluwün. Ka femngechi re wülafimün ta eymün. ");
INSERT INTO arnNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yekilmün oro ka pülata no rume ka chem moneda no rume. ");
INSERT INTO arnNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yelayaymün rokiñ no rume, epu mudaw takuwün no rume, ka okota no rume ka retrü no rume, küdawpelu felelu am ñi elungeael tati iyael. ");
INSERT INTO arnNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Fey puwülmün ta eymün kiñe waria mew kam lelfün mew rume, kintuafimün kiñeke che küme piwkengelu, fey mülewemün feychi ruka mew müten. ");
INSERT INTO arnNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Fey konpulmün tati ruka mew, chalipuafimün kom che mülelu feychi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Küme llowelmünmew tati pu che, tañi ayütunieelchi küme tüngün kom feleay, welu küme llownoelmünmew engün, fey felelayay tañi ayütuniefelchi küme tüngün. ");
INSERT INTO arnNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Fey llowngenolmün ka pinole engün ñi allkütuael, tripatuaymün feyti ruka mew ka wariangeay rume, fey mütrowaymün ti trufür tañi nieel tamün okota. ");
INSERT INTO arnNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Rüf dungu feypiwayiñ, fey ti afaelchi antü mew feychi waria che doy wesa kutrankangeay tati pu che mew mülekefulu Sodoma ka Gomora waria mew. ");
INSERT INTO arnNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“¡Ngüneduammün! Iñche ta werküwayiñ tamün amuael ufisa reke rangi trapial reke felechi pu che mew. Nieaymün may ta adümuwün, filu reke, ka femngechi ñom piwkengeaymün palluma reke. ");
INSERT INTO arnNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Kuñiwtuwküleaymün. Chalintukungeaymün tati pu awtoridad mew, wülelkangeaymün ta sinagoga mew. ");
INSERT INTO arnNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ka femngechi wültukungeaymün tati pu gobernador mew ka tati pu longko ülmen mew iñche tañi duam. Femngechi ta pepi nütramyemuan ta iñche kisu engün mew ka tati pu katripanche mew. ");
INSERT INTO arnNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Welu chalintukungelmün tati pu awtoridad mew, rakiduamlayaymün ta eymün tamün chem piael, kam chumngechi tamün nütramyemuafiel, fey puwle tamün dunguael, Ngünechen ta eluaeymünmew chumngechi tamün dunguael. ");
INSERT INTO arnNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eymün no tati kisutu pepikayalu ñi dunguael, welu may tamün Chaw ñi Küme Püllü kelluaeymünmew tamün chem piael. ");
INSERT INTO arnNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Tati pu peñi chalintukuay ñi peñi ñi langümngeael, ka tati pu ngen fotüm chalintukuay tañi fotüm, ka tati pu fotüm kayñetuafi tañi chaw ka langümfalafi. ");
INSERT INTO arnNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kom che üdeaeymünmew ta eymün iñche ñi duam, welu tati newentulelu tuntepule ñi mongen, fey engün ta montuay. ");
INSERT INTO arnNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Inantukungelmün ta kiñe waria mew, amumün ta kangelu waria mew. Iñche ta rüf dungu feypiwayiñ ñi küpatuael ti Wentrukünuwpalu petu tamün kom rupanon israelche tañi pu waria mew. ");
INSERT INTO arnNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kiñe no rume tati kimeltukeel, doy nielay kimün tañi kimeltufe mew ka kiñe werküpeelchi kona doy pepiluwlay tañi werkükeetew mew. ");
INSERT INTO arnNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tati kimeltukeel ka femngechi adümuwle kisu ñi kimeltufe reke, kümey. Ka tati werküpeelchi kona ka femngechi pepiluwle ñi werkükeetew mew, ka kümey. Fey iñche tati ngen ruka ta Belsebu pingeli, ¿chem pingeaymün am eymün? ");
INSERT INTO arnNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ngelay tamün llükanieafiel tati pu che. Chem ellkan dungu rume ngelay tañi kimngenoael, ka chem rume ellkalelu ñi pengenoael. ");
INSERT INTO arnNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tamün feypiwpefiel ta dumiñ mew reke, eymün ta nütramyeafimün ta pelon antü mew ka tamün ellka feypiwfiel eymün, ta wirartu nütramyeafimün ta wente ruka kütu. ");
INSERT INTO arnNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Llükakefilmün tati ayülelu tamün langümaetew, welu pepi langümlayafi tamün am tati rumel mongelealu. Llükayafimün may tamün eluaetew tamün rumel layael ka tamün rumel kutrankayaetew ta kütral mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Rume pichi falifuy engün rume tati pu pichike üñüm, welu kiñe no rume ütrüfnaglayafuy engün pinofule tamün Chaw. ");
INSERT INTO arnNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Feymew ta llükakilmün. Fey eymün tamün kal longko kütu ta rakinieñmaeymünmew re kiñeke, eymün am doy falilu fentren pichike üñüm mew. ");
INSERT INTO arnNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Iney rume ta nütramyeelimew tati pu che mew, iñche ka femngechi nütramyeafiñ ta kisu iñche tañi wenu mapu mülechi Chaw mew, ");
INSERT INTO arnNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","welu tati yewentukuetew tati pu che mew, iñche kafey yewentukuafiñ tañi Chaw mew mülelu ta wenu mapu. ");
INSERT INTO arnNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Rakiduamkilmün iñche tañi küpan mew ñi müleael re kümelkawün. Küpalan tañi müleael ta küme tüngün, welu may tañi müleael kayñetuwün. ");
INSERT INTO arnNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Küpan tañi ‘kayñetuwael ta fotüm ñi chaw engu, ka domo püñeñ ñi kayñetuwael ñi ñuke engu ka ti nanüngwen ñi ka femngechi kayñetuwael. ");
INSERT INTO arnNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Fey ta famngechi tati doy reñmaniewchi pu che tañi kayñetuwael.’ ");
INSERT INTO arnNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Tati doy piwkeyelu tañi chaw ka tañi ñuke iñche mew, koneltulelay iñche mew. Ka femngechi tati doy piwkeyelu tañi fotüm kam tañi ñawe iñche mew, koneltulelay iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iney rume inaelimew, welu eluwkülenole ñi layael kütu iñche ñi duam, koneltulelay iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tati ayülu ñi montulael tañi mongen, fey ta montul-layafi, welu tati eluwkülelu ñi layael kütu iñche tañi duam, fey ta nieay montun. ");
INSERT INTO arnNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Iney rume tamün küme llowetew, iñche ta llowenew. Fey iney rume tañi küme llowetew, ka femngechi llowfi iñche tañi werküetew. ");
INSERT INTO arnNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ngünechen fürenekefi tati pu pelon wentru, fey iney rume llowfile kiñe pelon wentru Ngünechen tañi werküetew mew, ka femngechi kisu lloway küme fürenechen tati pelon wentru reke. Ngünechen ka fürenekefi kom che lif piwkengelu, fey iney rume llowfile kiñe lif piwkengechi che, ka femngechi lloway küme fürenechen tati lif piwkengelu reke. ");
INSERT INTO arnNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Iney rume elufile kiñe fasu firkün ko kiñeke tati doy ñom piwkengelu iñche tañi inanieetew, rüf dungu feypiwayiñ kutranpiwkeyeaeyew ta Ngünechen.” ");
INSERT INTO arnNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Fey Jesus dew kimeltufilu tañi mari epu disipulu, tripatuy tiye mew tañi kimeltuafiel tati werkün dungu tati müleyechi waria mew tiyechi trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Fey Juan, dew püresuntukungelu karsel mew, allkülu ñi femngechi dungu tañi femün ta Cristo, werküy kiñeke disipulu ");
INSERT INTO arnNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ñi ramtumeafiel ta Jesus: “¿Eymi am tati Cristo küpayalu Ngünechen mew ti pingeel, kam kangelu üngümaiñ?” ");
INSERT INTO arnNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Fey Jesus llowdungueyew: “Amutumün ka feypiputuafimün ta Juan tamün peel ka tamün allküel. ");
INSERT INTO arnNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nütramelputuafimün ti pu trawma ñi pelotun, ka ti pu küntro ñi trekatun, ka ti pu nielu lepra kutran ñi tremoltun, ka ti pu pilu ñi allkütun, ka ti pu la ñi wiñomongetun ka ti pu pofre ñi kimelelngen tati werkün montuluwün dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Ayüwün niey tati welulkawnolu ñi maneluwael iñche mew!” pi. ");
INSERT INTO arnNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Fey wiñotulu kisu engün, Jesus eluwi ñi dunguafiel tati pu che ñi nütramyefiel ta Juan, feypilen mew: “¿Chem am pemeymün tati lelfün uwe mapu mew? ¿Tati angken kachu pemay mefürkamekeel ti kürüf? ");
INSERT INTO arnNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Feyngenole, ¿chem am pemeymün? ¿Pemeymün am kiñe wentru kümeke takuwün tukunielu? Eymün kimnieymün tati kümeke takuwün tukuwkelu, miyawkey engün tati pu longko ülmen ñi ruka mew müten. ");
INSERT INTO arnNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Fey chem pemeymün am? ¿Kiñe pelon wentru pemay? Fey llemay, welu kiñe doy fütra pepiluwünngelu ta kiñe pelon wentru mew. ");
INSERT INTO arnNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tati Wirin Chillka feypiley kisu mew: ‘Iñche werküan tañi werken, wüne kimeltuafilu tati trokiñche, femngechi tami küme llowaetew engün’ ―pi. ");
INSERT INTO arnNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Rüf dungu feypiwayiñ ta Juan ti Fawtisachefe doy kimfali kom pu wentru mew, welu tati doy illamfalkülelu Ngünechen ñi longko ülmenngeel mew, doy sakinngeay ta kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Feychi mew pewfaluwlu ta Juan ti Fawtisachefe ka fantepu mew, Ngünechen ñi longko ülmenngen rume nütramyengey, welu rume kayñetuniengey, fey tati rume yafüluwlu, fey tüfa engün müten llowfi. ");
INSERT INTO arnNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tati ley dungu mew feypiley ka ti pu pelon wentru ñi wewpielchi dungu mew kimelngey ñi küpayael tati Cristo, fey akulu wüla ta Juan fentekünuy engün. ");
INSERT INTO arnNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Fey eymün ayüfilmün tamün feyentuafiel tüfachi dungu, fey Juan ürke tati pelon wentru küpalu Elia reke, eymün tamün üngümniefel. ");
INSERT INTO arnNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tati ayülu ñi allkütuael, allkütupe ―pi ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Fey, ¿chumngechi am adentukünuafiñ fantepu mew mülechi pu che? Tati pülasa mew anükünuwkechi pichikeche reke femkey engün, fey wirarelkefi engün tañi pu kompañ ");
INSERT INTO arnNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","fey ta famngechi: ‘Dunguleluwiyiñ ta pifüllka, welu purulaymün. Ülkantuleluwiyiñ weñangkünngechi ül, welu eymün ngümalaymün.’ ");
INSERT INTO arnNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan küpay, fey ifengelay ka putufengelay, fey niey kiñe weküfü pingey. ");
INSERT INTO arnNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Feymew ka küpay tati Wentrukünuwpalu, ikey ka putukey, fey ifengey ka putufengey pingekey, ka weniyefi ti wesake dunguyen che ka tati pu kofrakelu impuestu Romangealu. Welu Ngünechen tañi kimün kimfali ñi femkeel mew tati Wentrukünuwpalu.” ");
INSERT INTO arnNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Feymew Jesus eluwi ñi lladkütudunguafiel tati pu waria che chew tañi doy femel tañi afmanngechi pepiluwün, tüfeychi waria che am wiñorakiduamtunolu engün ta Ngünechen mew. Fey Jesus feypifi: ");
INSERT INTO arnNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Awngeymün ta eymün, Korasin waria che! ¡Ka femngechi awngeymün ta eymün, Betsayda waria che! Tiro ka Sidon waria mew pengefule ti afmanngechi pepiluwün tati femel eymün tamün adkiñ mew, kuyfi tukuafuy engün yunge wesake takuwün ka anüafuy engün trufken mew, fey ta femngechi kimfalafuy ñi wiñorakiduamtun engün Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Welu feypiwayiñ ta tiyechi afaelchi antü mew eymün ta doy fütra kutrankawaymün ta Tiro ka Sidon mülechi pu che mew. ");
INSERT INTO arnNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ka eymün, Kapernaum waria che, ¿puwalu wenu mapu trokiwküleymün am kay? Femlayaymün. ¡Doy fütra ponwitu lolo mew ta ütrüfkonpuaymün! Sodoma mew femngefule tati afmanngechi pepiluwün tati femngeel ta eymün tamün adkiñ mew, feychi waria ta petu müleafuy ta fantepu. ");
INSERT INTO arnNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Welu feypiwayiñ tati afaelchi antü mew doy kutrankawaymün ta eymün ta Sodoma waria mew mülekefuchi pu che mew” pi. ");
INSERT INTO arnNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Feychi mew Jesus feypi: “Püramyeeyu Chaw, Ñidolkülelu wenu mapu ka tüfachi nag mapu mew. Eymi tami adkünuelchi dungu elulafimi ñi kimael tati pu mallmangelu ka kimkawünngelu, welu fewla Chaw, eymi kimelelfimi tami dungu tati ñom piwkengechi pu che eymi tami pin mew. ");
INSERT INTO arnNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tañi Chaw chalintukulelenew kom dungu. Iney no rume ta küme kimlafi tati Fotüm, welu Chaw müten küme kimnieeyew. Ka iney no rume küme kimlafi ta Chaw, welu tati Fotüm küme kimnieeyew ka tüfeychi pu che müten Fotüm tañi küpa kimelelfiel. ");
INSERT INTO arnNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Feymew küpamün iñche mew kom eymün tati kansalelu tañi küdaw mew ka fanetulelu, fey iñche ta kansatuluwayiñ. ");
INSERT INTO arnNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ayütufimün tati yuku tamün tukuleluwfiel, ka inakintuaymün ta iñche mew, iñche am ñom piwkengelu ka mallmangelan rume, fey ta famngechi kansatuaymün. ");
INSERT INTO arnNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Iñche ñi yuku tamün tukuleluwfiel fanelay yen mew ka küdawngelay tamün eluwfielchi dungu” pi. ");
INSERT INTO arnNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Fey kiñe ürkütun antü mew, Jesus rumey tati ngan kachilla mew. Fey ñi pu disipulu ngüñülerkey, fey eluwürkey engün ñi suchetuafiel longko kachilla, fey ñi iyafiel ti fün. ");
INSERT INTO arnNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fey ti pu farisew pefilu tüfa, feypifi engün ta Jesus: —Tüfey tami pu disipulu ñi fempeel kümelay ñi femael ta ürkütun antü mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Fey Jesus llowdunguy: —¿Kimlaymün am ñi chumün ta David kiñe rupa kisu ka tañi pu kompañ ngüñülu engün? ");
INSERT INTO arnNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Konpuy ta Ngünechen ñi ngillatuwe ruka mew ka ipufi tati kofke chalintukulelu ta Ngünechen mew. Fey kisu ngelafuy tañi iyael ka tañi pu kompañ no rume, ti pu saserdote müten felerkefuy ñi iyafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Kam kimlaymün ñi chem pilen Moyse tañi ley dungu feyti pu saserdote ngillatuwe ruka mew kansatukelay tati ürkütun antü mew, fey yafkakelay engün? ");
INSERT INTO arnNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Fey tüfa feypiwayiñ tati mülelu ta tüfa mew doy yamfali ti ngillatuwe ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Eymün ta kimlaymün tañi chem pilen tati Wirin Chillka: ‘Iñche ayülen tamün kutranpiwkeyecheael, welu tamün chalintukunoael tati langümelchi kulliñ.’ Rüf dungu mew adümfulmün tüfachi dungu, kondenakelayafuymün tati nienolu chem yafkan no rume. ");
INSERT INTO arnNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Fey tati Wentrukünuwpalu ngüneniefi chem dungu rume ñi femael ti ürkütun antü mew ―pi. ");
INSERT INTO arnNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Fey Jesus tripatulu tiye mew, konpuy kiñe sinagoga mew mülelu tiyechi lelfün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tüfey mew müley kiñe wentru lañmalelu ñi kiñe kuwü. Fey ti pu farisew inayawületew am re koyla ngünen mew ñi feypintukuafiel ta Jesus, fey ramtueyew engün: —Tañi tremolngeael ta kiñe kutran ürkütun antü mew, ¿feley kam felelay? ");
INSERT INTO arnNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesus llowdungufi ti pu che: —¿Fey eymün chem piaymün kay? Iney rume niele kiñe ufisa, fey ti ürkütun antü mew ütrüfkonle ti ufisa kiñe rüngan mew, ¿nentupetulayafuy may? ");
INSERT INTO arnNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Fey ¡kiñe wentru ta doy faliy kiñe ufisa mew! Feymew feypiwayiñ: feley ta che ñi femael kümeke dungu ti ürkütun antü mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Feymew feypifi ta tiyechi wentru lañmalelu ñi kuwü: —Norümentunge tami kuwü. Fey ti wentru norümentuy ñi kuwü, fey küme tremolewetuy ti kangelu kuwü reke. ");
INSERT INTO arnNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Welu ti pu farisew tripatulu ti sinagoga mew, nütramkawi engün chumngechi ñi langümafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesus, kimlu tüfachi dungu, tripatulu tiye mew, fey rume fentren che inaeyew. Jesus tremolfi kom tati pu kutran ");
INSERT INTO arnNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ka feypiyefi engün tañi nütramyengenoael ta kisu rangi pu che. ");
INSERT INTO arnNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Fey tüfa famngechi femi tañi mupituael ñi kimelel tati pelon wentru Isaia, feychi feypilu: ");
INSERT INTO arnNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Tüfa ñi mülen ñi poyekeetew, iñche tañi dulliel, tañi sakin, ka tañi sakiwkemum. Kisu mew müleay iñche tañi Lif Küme Püllü, ka kimelay ti montuluwün dungu kom trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wirartuchelayay ka wirarkiyawlayay rume. Iney rume allküñmalayaeyew ñi dungun rüpü mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Illamtulayafi tati pu che newe nienolu kimün kiñe epe watrolechi rüngi reke felelu ñi kimün mew, ka chongümlayafi rume tati chomadwe kütral ella üykülelu, welu kom ñi pu kayñe apümnagümafi kisu tañi nor dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Fey kisu mew maneluway fentren che kom trokiñ mapu tuwlu.” ");
INSERT INTO arnNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yengey ta Jesus mew kiñe wentru trawmalelu ka ketrongelu. Kontunierkeeyew ta fentren weküfü, fey Jesus elutufi ñi pelotuael ka ñi dungutuael. ");
INSERT INTO arnNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Fey kom ti pu che tüfey mew mülelu, rume afmatulen welukonkechi ramtuwi engün: “¿Fey tüfa pemay ta David ñi Yomelche?” pi engün. ");
INSERT INTO arnNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Allkülu tüfachi dungu, tati pu farisew feypi engün: “Belsebu, tati longkolelu ti pu weküfü mew, fey ta elueyew pepiluwün ta tüfachi wentru tañi wemünentuael ta weküfü.” ");
INSERT INTO arnNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Welu Jesus am kimnieñmaetew engün tañi femngechi rakiduamkülen, feypi: “Chem trokiñ mapu rume kisutu weychamekele ñi pu che, kisutu apümkaway engün. Ka kiñe waria che kam kiñe ruka che wichuke püntülele, rumel mülelayay. ");
INSERT INTO arnNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ka femngechi, weküfü wemünentufile kangelu weküfü, fey famngechi femle, kisutu ta püntükawküleay engün. Fey ¿chumngechi am ngünenieway ka kiñewküleay engün? ");
INSERT INTO arnNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Eymün feypikeymün iñche tañi wemünentukefiel tati pu weküfü Belsebu tañi pepiluwün mew, welu tüfa feyngele, ¿iney am elukeeyew pepiluwün eymün tamün inanieetewchi pu che ñi wemünentuafiel ta weküfü? Feymew, kisu engün ñi femel mew kimfali eymün tamün welulkawkülen. ");
INSERT INTO arnNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Fey iñche wemünentufili ta weküfü Ngünechen ñi Lif Küme Püllü ñi pepiluwün mew, fey tüfa famngechi fente küme kimfalküley Ngünechen tañi longko ülmenngen ñi dew mülepan ta eymün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Fey kiñe wentru ayüle ñi konpuael kiñe rume newenngechi wentru ñi ruka mew femngechi ñi müntuñmayafiel tañi nieelchi chemkün, wünelu mew küme trarinofile ti ngen ruka, ¿chumngechi am konpuafuy ti ruka mew? Welu trarikünufile, fey wülake pepi müntuñmayafuy ñi nieelchi chemkün. ");
INSERT INTO arnNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Tañi kellunienoetew, fey engün ta kayñetunieenew. Ka tati küdawnolu ñi küpalafiel ti pu che, fey ta püntünentukefi ti pu che iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Feymew feypiwayiñ Ngünechen wiñoduamatuafi tati pu wentru kom tañi yafkan ka kom tañi wesa piken mew, welu wiñoduamalayafi tati kayñetudungufilu ti Lif Küme Püllü. ");
INSERT INTO arnNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ngünechen wiñoduamatuafi chem wesa pilu rume ñi üyawtudungufiel tati Wentrukünuwpalu, welu tati wesa üyawtudungufilu tati Lif Küme Püllü, wiñoduamatulayafi tüfachi mapu mew ka ti mületuachi mapu mew no rume. ");
INSERT INTO arnNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Küme dapillkayafimün ta kiñe anümka, fey wülay küme fün. Fey küdawmanofilmün, fey wülay wesake fün, tañi fün mew am kimngekelu ñi küme anümkangen. ");
INSERT INTO arnNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Eymün pu farisew, kuñiwünngechi llepü filu reke feleymün! Eymün am wesa piwkengelu, ¿chumngechi feypiafuymün kümeke dungu? Chem dungu ñi mülen ta piwke mew, fey dungukey ta wün. ");
INSERT INTO arnNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tati küme piwkengechi wentru dungukey kümeke dungu, küme dungu am mülelu kisu ñi piwke mew. Fey tati wesa piwke wentru dungukey wesake dungu, wesa dungu am mülelu kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Iñche feypiwayiñ tati afaelchi antü mew, kom che ta entudunguay engün chem wesa dungu rume ñi feypikeel engün. ");
INSERT INTO arnNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kisu tami feypikeelchi dungu mew ta nielay yafkan pingeaymi, kam kondenangeaymi.” ");
INSERT INTO arnNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Feymew kiñeke tati pu farisew ka ti kimeltukelu tati ley dungu, feypifi engün ta Jesus: —Kimeltufe, ayüleiñ taiñ peael kiñe afmatufal dungu femngechi taiñ kimael eymi rüf mew tami küpan ta Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Fey Jesus llowdungueyew: —Eymün wesake piwkengelu ka müngeltukenolu. Ayükeymün tamün peael afmatufal dungu, welu pengeleluwlayayiñ kangelu afmatufal dungu, dew kimnielu am eymün tati pelon wentru Jona ñi rupaelchi afmatufal dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Fey chumngechi ta Jona küla antü ka küla pun mülepuy tati fütra challwa tañi pütra mew, ka femngechi tati Wentrukünuwpalu küla antü ka küla pun rüngalküleay ta miñche mapu. ");
INSERT INTO arnNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tati pu Ninifeche wiñorakiduamtuy Ngünechen mew, allkülu engün am Jona tañi wewpielchi dungu. Fey afaelchi antü mew, ramtukadungungeale tati fantepu mew müleyechi pu che, tati pu Ninifeche witrapürayay ñi kondenayafiel tüfachi pu che, fewla mülelu am eymün mew kiñe doy pepiluwlu ta Jona mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ka femngechi tati longko ülmen domo waywen püle tuwlu, küpay fütra kamapu ñi allkütupayael Salomon tañi kimün. Fey afaelchi antü mew, ramtukadungungeale ta fantepu mew müleyechi pu che, tati longko ülmen domo witrapürayay ñi kondenayafiel tüfachi pu che, fewla mülelu am eymün mew kiñe doy fütra kimün nielu ta Salomon mew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Tati weküfü tripayüm ta kiñe wentru mew, miyawkey chew ñi ngenomum chem rume. Kintuyawülkey ñi kansatuam, fey penoyüm, rakiduamkey: ");
INSERT INTO arnNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Wiñotuan tati wentru mew chew tañi mülekefumum.’ Fey wiñotuyüm, pepatukefi tiyechi wentru kiñe wellin ruka reke, lepütulelu ka küme elkülelu. ");
INSERT INTO arnNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Feymew amuay ñi yemeael regle weküfü doy wesañmangelu kisu mew, fey kom kiñentrür konkey engün ñi müleael ta tiyechi wentru mew. Feymew tati wentru doy wesa mongen nietukey tañi niekefel ta wünelu mew. Ka femngechi femay ta tüfachi wesakeche.” ");
INSERT INTO arnNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Fey Jesus petu dungumekefilu tati pu che, kisu ñi ñuke ka ñi pu peñi wekuntu mülepuy engün, ayülelu engün am ñi dunguafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Fey feypingey ta Jesus: —Tami ñuke ka tami pu peñi wekuntu mülepay. Ayüley engün tami dunguaetew. ");
INSERT INTO arnNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Welu Jesus llowdungufi tañi feypietew: —¿Iney am tañi ñuke, ka iney engün am tañi peñi? ");
INSERT INTO arnNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Feymew, adkintufi tañi pu disipulu, fey feypifi: —Tüfa engün may ta iñche ñi ñuke ka tañi peñi. ");
INSERT INTO arnNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iney rume ayülelu ñi küdawyeael iñche ñi wenu mapu mülechi Chaw ñi ayükeelchi dungu, fey ta iñche ñi ñuke reke feley, ñi lamngen ka ñi pu peñi ka müten ―pi. ");
INSERT INTO arnNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Feychi antü mew müten Jesus tripapay ta ruka mew, fey anükünuwi inaltu ti pichi lafken. ");
INSERT INTO arnNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Rume fentren che am trawüluwlu, feymew Jesus konpuy kiñe farku mew fey anükünuwpuy, fey ti pu che kay mülewey inaltu ti ayliñ mew. ");
INSERT INTO arnNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Feymew eluwi ñi kimeltuafiel fentren dungu, welu re adkünu dungu mew. Fey feypifi: “Kiñe nganketrankelu tripay ñi nganael. ");
INSERT INTO arnNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Fey nganlu, kiñeke ti fün ketran pachügnagi rüpü mew, fey akulu tati pu üñüm, kom üpitufi ti fün ketran pachügnaglu rüpü mew. ");
INSERT INTO arnNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Fey ti kakelu fün pachügnagi kurantu mew, chew rüngelay ta mapu. Fey tati fün müchay müten noyüy, müte alü konkülenolu am tati mapu. ");
INSERT INTO arnNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Welu aretripalu ta antü, angkümeyew, ka müte nienolu am folil, feymew angküy. ");
INSERT INTO arnNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Ka kiñeke tati fün ketran ta pachügnagi pu troltrontu. Fey tremlu, tati troltro doy tremi. ");
INSERT INTO arnNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Welu ka kiñeke tati fün ketran pachügnagi küme mapu mew, fey rumeñma wüli fentren fün. Kiñeke longko ketran wüli pataka fün kiñe fün ketran mew, ka kiñeke fün wüli kayu mari fün, ka kiñeke wüli küla mari. ");
INSERT INTO arnNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tati nielu pilun, allküpe tüfachi dungu.” ");
INSERT INTO arnNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tati pu disipulu fülkonpuy engün ta Jesus mew ka ramtufi engün chumngelu ñi dungufiel tati pu che re adkünu dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesus ta llowdungueyew engün: “Eymün ta Ngünechen elueymünmew tamün küme kimael tati petu kimelngekenofelchi dungu mülelu wenu mapu, welu kisu engün femngelay. ");
INSERT INTO arnNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Fey tati küpa kimlu, doy elungeay kimün, fey doy fentren kimün nieay. Welu tati pinolu ñi kimael, tañi pichi kimfel kütu müntuñmangeay. ");
INSERT INTO arnNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Feymew ta dungukefiñ engün re adkünu dungun mew: ‘Kisu engün am adkintukelu, welu pekelay engün reke. Allkütukey engün, welu küme longkontukukelay engün ka ngüneduamkelafi rume engün.’ ");
INSERT INTO arnNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Femngechi, kisu engün mew ta mupituy tañi piel tati pelon wentru Isaia: “ ‘Tunte allkütuay engün rume, welu ngüneduamlayafi. Tunte adkintuay engün rume, pelayay engün reke. ");
INSERT INTO arnNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tañi rakiduam ta tüfachi trokiñche welulkawküley. Ngüdi niey tañi pilun ka umerküley reke engün tañi nge, tañi pepi penoael engün ka ñi allkünoael rume, ka tañi kimnoael rume, tañi wiñotunoael ta iñche mew ka tañi tremolnoafiel engün ta iñche.’ ");
INSERT INTO arnNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Welu ayüwün nieymün ta eymün, tamün nien mew ta pekechi nge ka allkükechi pilun. ");
INSERT INTO arnNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Rüf dungu mew, rume fentren pelon wentru ka kümeke piwkengechi pu che küpa pefuy engün ta tüfachi dungu eymün tamün peel, welu pelay engün. Küpa allkütufuy engün tüfachi dungu eymün tamün allküel, welu allkülay engün. ");
INSERT INTO arnNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Fey fewla allkütumün ñi chem pilen tati adkünu dungu ti nganketrankelu mew: ");
INSERT INTO arnNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tati allkülu ti kimelün dungu Ngünechen ñi longko ülmenngen, fey longkontukunofile, tati rüpü mew pachügnagchi fün ketran reke feley engün. Küpay ta weküfü ka müntuñmatueyew ti küme dungu ngankülelu tañi piwke mew. ");
INSERT INTO arnNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tati fün ketran ütrüfnaglu kurantu mew fey tati allkülu ti kimelün dungu ka llowfulu rume ayüwkülen, ");
INSERT INTO arnNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","welu newe nienolu am folil, rumel newentulekelay. Fey müleyüm wesake dungu kam kutrankangeyüm tañi allkütufiel mew tati küme dungu, aftukey reke ñi mupiltun. ");
INSERT INTO arnNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tati fün ketran ütrüfnaglu rangi troltro, fey tüfa adentuley tati che allkülu tati kimelün dungu, welu tati mülechi welulkawün ta tüfachi mapu mew rume aporianieeyew ka ñi rume küpa rikungeael ngünenkanieeyew. Kom tüfachi dungu ta ekullkefi reke ta tüfachi kimelün dungu ka elulafi ñi wülael fün kisu engün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Welu tati fün ketran nganel küme mapu mew, fey tüfa adentuley tati che allkülu tati kimelün dungu ka küme kimfilu, fey rume küme kosecha wülkey. Kiñeke tüfa engün tati longko ketran wüli ta pataka fün kiñe fün mew, kakelu wüli kayu mari fün, fey kangelu wüli küla mari fün.” ");
INSERT INTO arnNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus ka femngechi nütramkay kangelu adkünu dungu: “Ngünechen tañi longko ülmenkülen kiñe wentru reke feley tati nganlu küme fün ketran tañi lelfün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Welu kom umawkülelu engün, akuy kiñe kayñe, fey nganpay wesa kachu tati kachilla mew, fey amutuy. ");
INSERT INTO arnNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Fey dew tremlu tati kachilla petu pürampalu tañi longko, pewfaluwi kay tati wesa kachu. ");
INSERT INTO arnNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Feymew tati pu küdawfe amuy engün tañi feypimeafiel tati ngen kachilla: ‘Ñidol, ¿küme fün ketran ama nganlaymi tami lelfün mew? ¿Fey chumngelu am wefi tati wesake kachu?’ ");
INSERT INTO arnNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Fey tati ngen kachilla feypieyew: ‘Kiñeke tañi pu kayñe femngechi nganpay tatey.’ Tati pu küdawfe ramtueyew: ‘Eymi pilmi, amuaiñ taiñ ngedumeafiel tati wesake kachu.’ ");
INSERT INTO arnNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Welu kisu feypi: ‘Femkilmün, ngedufilmün tati wesake kachu kenü, ngedunentuafuymün tati kachilla. ");
INSERT INTO arnNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Doy kümey ñi elukünungeael ñi tremael kiñentrür walüngngen puwle wüla. Feymew werküafiñ tati kosechayalu ñi püntünentuafiel wünelu mew tati wesake kachu ñi kütrüngkünungeael, ka ñi lüpümngeael, fey wüla kosechayan tañi kachilla ñi elngeael ti elketranwe mew.’ ” ");
INSERT INTO arnNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus ka nütramelfi ti pu che tüfachi adkünu dungu: “Ngünechen tañi longko ülmenngen ta kiñe fün mostasa reke ta feley kiñe wentru tañi nganel tañi lelfün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Feyngefuy tañi doy pichin kom fün ketran mew, welu dew tremiyüm, doy alükey tati kakelu anümka mew müleyelu ta werta mew. Kiñe fütra anümka reke mületukey, fey tañi fente tremken mew tati pu üñüm dañekey ñi row mew.” ");
INSERT INTO arnNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ka nütramelfi tüfachi adkünu dungu: “Ngünechen tañi longko ülmenngen tati lefawra reke ta feley kiñe domo tañi tukuel küla rali rüngo mew, femngechi tañi fayümafiel kom tati masan.” ");
INSERT INTO arnNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus nütramelfi kom tüfachi dungu tati pu che adkünu dungu mew. Fentren dungu kimeltuy re adkünu dungu mew müten. ");
INSERT INTO arnNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Fey tüfa femngechi femi tañi mupiael ñi piel tati pelon wentru: “Kimeltuan ta adkünu dungu mew. Nütramkayan tati kimelkenofelchi dungu, feychi mew Ngünechen dewmafilu müten ta tüfachi mapu.” ");
INSERT INTO arnNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Feymew Jesus chaliyetufi tati pu che, fey konpuy ruka mew. Feymew tañi pu disipulu fülkontueyew, fey feypingey tañi küme kimelafiel tati adkünu dungu ti wesa kachu weflu ti lelfün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesus llowdungufi ñi pu disipulu: “Tati nganlu ti küme fün ketran fey tati Wentrukünuwpalu. ");
INSERT INTO arnNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Fey tati lelfün tüfachi mapu. Tati küme fün fey tüfa tati pu che koneltulelu ti longko ülmen mülewe mew, ka ti wesa kachu fey tüfa ta weküfü ñi pu kona. ");
INSERT INTO arnNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ka tati kayñe ti nganfilu tati wesa kachu, fey ta weküfü. Fey tati walüng antüngen fey tüfa ta afale ta mapu, ka tati kosechakelu ta kachilla tati walüng antüngen, fey tati pu werken püllü. ");
INSERT INTO arnNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chumngechi tati wesa kachu ñimitungekey ka tukungekey kütral mew ñi lüfael, ka femngechi femay ta afale ta mapu. ");
INSERT INTO arnNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Fey tati Wentrukünuwpalu werküay tañi pu werken püllü tañi püntünentuafiel tati ayütukelu tañi femmekeael wesake dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tüfa engün tukungeay tati chongkenochi kütral mew, chew tañi ngümayam engün ka kütrüram tañi foro. ");
INSERT INTO arnNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Feymew tiye engün tati femkelu Ngünechen tañi ayüelchi dungu, wilüfay engün antü reke iñche ñi Chaw ñi longko ülmen mülewe mew. Kom tati ayülu ñi allkütuael, allküpe tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ngünechen tañi longko ülmenkülemum kiñe ellkalechi falin chemkün reke feley mülelu kiñe lelfün mew. Kiñe wentru pey tati ellkalechi falin chemkün, ka ellkakünutufi ka tüfey mew. Fey rume ayüwünkechi amutuy ka fendey kom tañi nieel, fey ngillafi tati mapu. ");
INSERT INTO arnNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ngünechen tañi longko ülmenkülemum fey tüfa reke feley tati kintukelu ñi ngillayael tati rume küme perla. ");
INSERT INTO arnNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Fey peyüm kiñe perla rume falilu, fey amutukey ka fendekey kom tañi nieel, fey ngillakefi ti perla. ");
INSERT INTO arnNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ngünechen tañi longko ülmenkülemum ka femngey ta kiñe challwawe reke ütrüftukungelu ta lafken mew, fey entukey ta epe fill kakerume challwa. ");
INSERT INTO arnNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Fey apoyüm tati challwawe, tati pu challwafe ta entukefi ayliñ mew, anükünuwkey engün ta feymew ñi dulliafiel tati kümeke challwa. Kiñe kanasta mew tukukefi tati kümelu, fey tati kümenolu ütrüfentukefi engün. ");
INSERT INTO arnNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ka femngechi dungu ta müleay afale ta mapu: tripayay tati pu werken püllü ñi püntünentuafiel tati pu wesa piwkengelu tati pu küme piwkengelu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Fey tukungeay tati pu wesa piwkengelu tati chongkenochi kütral mew, chew tañi ngümayam ka tañi kütrüram tañi foro.” ");
INSERT INTO arnNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Fey Jesus ramtufi ñi pu disipulu: —¿Adümimün kay eymün kom tüfachi dungu? —May, Ñidol ―llowdunguyngün. ");
INSERT INTO arnNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Feymew Jesus feypifi ti pu disipulu: —Kom tati kimeltukelu Moyse tañi ley dungu ka küme adümlu Ngünechen tañi longko ülmenngen, kiñe ngen ruka reke ta feley, fey kom tañi nieelchi weke chemkün ka kuyfintuwkülechi chemkün mew, kake kiñeke kimniefi ñi tunteke falin. ");
INSERT INTO arnNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Fey Jesus rupan kimeltulu ta tüfachi adkünu dungu, tripatuy ta tiye mew, ");
INSERT INTO arnNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","fey puwtuy Nasaret waria mew. Tüye mew eluwpuy tañi kimeltuael tati mülechi sinagoga mew. Fey tati pu che afmatulen feypingün: —¿Chew am kimeltungey tüfachi wentru kom tañi adümelchi dungu? ¿Chumngechi am pepi pengeli tati afmatufal pepiluwün? ");
INSERT INTO arnNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Tati dewmarukafe ñi fotüm no anchi? ¿Ka tañi ñuke Maria pingey? ¿Ka Santiaw, Jose, Simon ka Juda ñi peñi no anchi? ");
INSERT INTO arnNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ka mülelay anchi kisu ñi pu lamngen iñchiñ taiñ waria mew? ¿Chew anta adümi kom tañi kimeltupeelchi dungu? ");
INSERT INTO arnNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Feymew pilay engün tañi allkütuael, welu Jesus feypifi ti pu che: —Kom püle ta yamngekey kiñe pelon wentru, welu kisu tañi mapu mew femngekelay ka tañi ruka mew no rume. ");
INSERT INTO arnNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Fey Jesus newe pengelpulay ta tiye mew afmanngechi pepiluwün, tiyechi pu che am ta pinolu ñi feyentuael ta kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Feychi mew müten, Erode, tati gobernadorkülelu ta Galilea mapu mew, allküy ñi nütramyengen ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Fey feypiyefi kisu tañi werkükeelchi pu che: “Juan tati Fawtisachefe wiñomongepetulay. Feymew ta niey tüfachi afmatufal pepiluwün.” ");
INSERT INTO arnNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Erode am püresufalfilu ta Juan, fey kadena mew trarilen yengey ta karsel mew. Fey tüfa ta femfi Erodia ñi duam, Felipe ñi kure. (Felipe ta Erode ñi peñi ürke.) ");
INSERT INTO arnNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan feypirkefuy ta Erode: “Ngelay tami kureyeafiel ta Erodia.” ");
INSERT INTO arnNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Fey Erode ayülefuy ñi langümafiel ta Juan, welu llükanierkefi tati pu che, kom feyentulelu engün am Juan tañi pelon wentrungen. ");
INSERT INTO arnNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Welu Erode nielu kawiñ ñi puwültripantun mew, Erodia tañi domo püñeñ eluwi tañi faylayael tati pu mangel ñi adkiñ mew. Fey ta Erode rume ayüfilu am ti faylan, ");
INSERT INTO arnNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","eludungurkefi kiñe kuyalltun mew: “chem rume eluen pilmi eluaeyu” pirkefi tati üllchadomo. ");
INSERT INTO arnNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Feymew ñi ñuke ñi feypietew mew, feypi tati üllchadomo: —Eluen kiñe rali mew Juan ti Fawtisachefe tañi longko. ");
INSERT INTO arnNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Fey tüfachi dungu rume weñangkülkaeyew tati longko ülmen Erode, kisu am wüldungulu kiñe kuyalltun mew tañi pu mangel ñi adkiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Feymew werküy tañi katrüñmamengeael ñi longko ta Juan karsel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Fey ta famngechi yelelngey kiñe rali mew ka elungepuy tati üllchadomo, fey kisu elufi tañi ñuke. ");
INSERT INTO arnNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Feymew akuyey Juan em tañi inayawülkefetewchi pu kompañ, yeñmangetuy tañi kuerpu ka rüngalmefi engün ta eltun mew. Feymew ka amuy engün tañi kimelafiel ta Jesus ñi langümngen ta Juan. ");
INSERT INTO arnNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Feymew Jesus kimlu Juan ti Fawtisachefe ñi lan, konpuy kiñe pichi farku mew ñi amuael kiñe kamapulechi lelfün mew. Welu tati pu che ngüneduami Jesus ñi kañpüle amun, feymew tripay engün ti waria mew ñi inantukuafiel engün chew ñi mülepun ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Fey petu nagpulu Jesus tati pichi farku mew, pefi fentren che, fey kisu kutranpiwkeyefi, fey tremolyefi tati pu kutran tañi puwülyeel engün. ");
INSERT INTO arnNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Fey dew putrafialu am, ñi pu disipulu fülkontueyew ka feypieyew: —Dew putrafiay, ka lelfüntripaleiñ. Feymew chalitufinge tati pu che, ñi amutuael ta waria mew ñi ngillayael ta iyael. ");
INSERT INTO arnNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Fey Jesus llowdungufi ñi pu disipulu: —Ngelay tañi amutuael engün. Eymün eluafimün ta iyael. ");
INSERT INTO arnNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Fey kisu engün llowdunguy: —Nielaiñ iyael ta tüfa mew. Kechu kofke ka epu challwa müten nieiñ. ");
INSERT INTO arnNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesus feypifi ñi pu disipulu: —Küpalelmuchi ti kofke ka ti challwa. ");
INSERT INTO arnNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Feymew feypifi tati pu che ñi anükünuwael ta kachu mew. Feymew müten nüfi ñi kuwü mew tati kechu kofke ka tati epu challwa, fey lelipüray ta wenu mapu, mañumtufi ta Ngünechen ka wükayefi ti kofke, elufi ñi pu disipulu, fey kisu engün eluyefi tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kom iyey engün fey kom ti pu che weday engün, ka apoyetuy mari epu kanasta tati sofrayechi wükanke kofke ka challwa. ");
INSERT INTO arnNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tati pu che kiñe kechu warangka wentru ürke, welu rakintukungelay tati pu domo ka tati pichikeche no rume. ");
INSERT INTO arnNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Dew rupalu tüfachi dungu, Jesus werküfi ñi pu disipulu ñi konpuael tati pichi farku mew, femngechi ñi wüne puwael engün nome ti pichi lafken mew. Welu Jesus mekey ñi chalitufiel tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Dew chalitufilu ti pu che, Jesus pürapuy kiñe wingkul mew, kisu ñi ngillatuael. Fey dew punlu, Jesus kisulewey. ");
INSERT INTO arnNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tati pichi farku dew amulewiyey alü ponwitu ti pichi lafken mew, fey tati rew rume newentu nengümkamekefi tati farku, trafyeniefilu engün am tati kürüf. ");
INSERT INTO arnNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Fey epe wünlu, Jesus trekalen amuley wente ko kisu engün püle. ");
INSERT INTO arnNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Feymew tañi pu disipulu peetew tañi trekalen ta wente ko, fey rume llükay, ka wirari engün ñi fente llükan mew: —¡Kiñe perimon tati! ―pirkey engün. ");
INSERT INTO arnNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Welu Jesus dungufi ñi pu disipulu, feypilen mew: —¡Yafüluwmün! ¡Iñche tati! ¡Llükakilmün! ");
INSERT INTO arnNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Feymew Pedro llowdungueyew: —Ñidol, rüf mew eymingelmi, werkünge iñche ñi trekalen amuael wente ko tañi puwael ta eymi mew. ");
INSERT INTO arnNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Küpange may ―pi ta Jesus. Feymew Pedro tripay ti pichi farku mew, fey llituy ñi trekayael wente ko ñi puwael ta Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Fey ngüneduamlu ñi rume newenngen tati kürüf, llükay. Ñochingelu am ñi llañnagün ti ko mew, fey wirari: —¡Montulen Ñidol! ");
INSERT INTO arnNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Feymew müten, Jesus nüñmafi ñi kuwü ta Pedro ka feypifi: —¡Rume pichin mupiltun nierkeymi! ¿Chumngelu am maneluwlaymi iñche mew? ");
INSERT INTO arnNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Fey püratulu engu müten tati pichi farku mew, kürüfwetulay. ");
INSERT INTO arnNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Feymew tati pu disipulu mülelu ti pichi farku mew, lukunagi engün Jesus ñi inafül ka feypi engün: —¡Rüf dungu mew eymi ta Ngünechen ñi Fotüm ürke! ");
INSERT INTO arnNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Feymew katrürumey tati pichi lafken mew ka puwi engün Genesaret pingechi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tati pu che müleyelu tiye mew, kimtufi engün ta Jesus, ka kimngey kom ti trokiñ mapu mew ñi puwün. Feymew küpalelngey tati pu kutran, ");
INSERT INTO arnNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ka llellipungey ñi idañmangeael rewall tañi takuwün. Fey kom tati pu kutran idañmaetew ñi wechuñ takuwün, tremolewetuy engün. ");
INSERT INTO arnNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fey kiñeke farisew ka kiñeke wentru kimeltukelu Moyse ñi ley dungu, tuwyelu ta Jerusalen, ramtupafi engün ta Jesus: ");
INSERT INTO arnNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Chumngelu am tami pu disipulu ta müngeltukelay iñchiñ taiñ fütake laku em tañi wimtun dungu? ¿Chumngelu am wüne küchakelay tañi kuwü petu tañi inon engün? ");
INSERT INTO arnNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Feymew ramtueyew Jesus: —¿Chumngelu am kay ta eymün müngeltukelafimün Ngünechen tañi werkün dungu tamün inayael kisuke tamün dewmaelchi wimtun dungu? ");
INSERT INTO arnNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ngünechen feypi: ‘Chetrokiaymi tami chaw ka tami ñuke,’ ka ‘iney rume malisiafile ñi chaw ka tañi ñuke dungun mew fey ta kondenangeay ñi langümngeael’. ");
INSERT INTO arnNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Welu eymün ta feypikeymün kiñe wentru ñi feypiafiel tañi chaw kam tañi ñuke: ‘Iñche ta pepi kellulayaeyu. Kom tañi nieel dew chalintukulelfiñ ta Ngünechen’. ");
INSERT INTO arnNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Fey iney rume feypile tüfachi dungu, fey ngelay chem mew tañi aporiangeael tañi kelluafiel tañi chaw kam tañi ñuke rume. Femngechi ta eymün falintukelafimün ta Ngünechen tañi werkün dungu tamün inayael kisuke tamün wimtun dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Koyla ngünen! Fente küme feypi tati pelon wentru Isaia ta dungulu eymün mew, feychi feypilu: ");
INSERT INTO arnNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Fey tüfachi trokiñche re wenche wün mew müten poyekeenew, welu konpiwke mew pilelay tañi müngeltuael iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Chem falilay rume tañi ngillatukeetew engün. Tañi kimeltukeel engün re che müten tañi adkünuelchi dungu.’ ");
INSERT INTO arnNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Feymew müten Jesus mütrümfi tati pu che ka feypifi: —Allkütumün ka küme kimaymün: ");
INSERT INTO arnNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chem iyael rume ile ta che elukelafi ñi wesa piwkengeael, welu may tati tripakelu ta wün mew wesalkakefi ta che. ");
INSERT INTO arnNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Feymew tati pu disipulu fülkonpuy engün ta Jesus mew ka ramtueyew: —¿Kimimi am tañi wesa duamün tati pu farisew allkülu engün tami femngechi feypin mew ta eymi? ");
INSERT INTO arnNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Kisu llowdungufi ñi pu disipulu: —Femkünukafimün müten. Chem anümka rume tañi wenu mapu Chaw ñi anümnoel, ngeduentungeay folilkülen. Trawma reke feley engün, tati rüpütulkefilu ta kakelu trawma. Kiñe trawma rüpütulfile ta kangelu trawma, mür ütrüfkonafuyngu ta kiñe lol mew. ");
INSERT INTO arnNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Feymew feypieyew ta Pedro: —Küme kimelmuiñ tami feypimupefielchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Fey Jesus llowdunguy: —¿Eymün ta ka femngechi kimlaymün? ");
INSERT INTO arnNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Kimlaymün am kom tati ikeel puwkey ta pütra mew, fey wüla tañi tripatuael ta kuerpu mew? ");
INSERT INTO arnNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Welu tati tripakechi dungun ta wün mew, che tañi piwke mew tripakey. Fey ta wesalkakefi ta che, ");
INSERT INTO arnNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","piwke mew am tripakelu ta wesake rakiduam, tati langümchen, tati ñiwaldomon, ka ti üñamyewün, tati weñen, tati koylatun ka fill wesa dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Fey tüfachi dungu ta wesalkakefi ta che, welu tati ilu iyael fey ñi küchakuwünon, fey ta wesalkakelafi ta che. ");
INSERT INTO arnNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Fey Jesus tripatuy tiyechi mapu mew ñi amuael ta Tiro ka Sidon trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Fey kiñe kananche domo müley tiyechi mapu mew, fey wirarkülen fülkontupaeyew: —¡Ñidol, David ñi Yomel tuwünche, kutranpiwkeyeen! ¡Ñi püñeñ konweküfüley! ");
INSERT INTO arnNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Welu Jesus chem llowdungulay rume. Feymew ñi pu disipulu fülkonpuy kisu mew ka llellipungey: —Feypifinge ta tüfachi domo tañi amutuael, wirarkülen am inaniepaetew ta iñchiñ. ");
INSERT INTO arnNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Fey Jesus feypi: —Ngünechen ta werküenew tati Israel trokiñche mew müten, tati ñamkülechi ufisa reke felelu. ");
INSERT INTO arnNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Welu tati domo lukutupuy kisu tañi fül mew, fey feypifi ta Jesus: —¡Ñidol, kelluen! ");
INSERT INTO arnNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus llowdungueyew: —Kümelay ñi müntuñmangeael ñi kofke tati pu fotüm fey ñi elungeael tati pu trewa. ");
INSERT INTO arnNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Fey ti domo feypifi ta Jesus: —Feley, Ñidol, welu tati pu trewa kütu ikey ta füntülnagchi kofke miñche mesa. ");
INSERT INTO arnNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Feymew feypieyew ta Jesus: —¡Papay, rume nieymi ta feyentun! Felepe may tami ngillatupeel. Feychi lelen mew müten tati domo ñi püñeñ tremolewetuy. ");
INSERT INTO arnNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus tripapatuy tiye mew, fey akuy Galilea tañi inaltu pichi lafken, feymew pürapuy kiñe wingkul mew ka anükünuwpuy. ");
INSERT INTO arnNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Fentren che trawüluwpuy chew ñi mülen ta kisu, yeniey engün tati pu küntrongelu, ti pu trawmangelu, tati pu pepi trekakenolu, ti pu ketrongelu ka fentren kakelu kutran. Puwülngey engün ta Jesus mew, fey kisu kom tremolyetufi ti pu kutranche. ");
INSERT INTO arnNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Fey tati pu che rume afmatulewey engün pefilu ñi dungutun tati pu ketro, tati pu trekakenolu ñi tremotun ka ñi trekatun, ka tati pu trawmangelu ñi pelotun. Fey eluwi engün tañi püramyeafiel Israel tañi Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus mütrümfi tañi pu disipulu, ka feypifi: —Rume kutranpiwkeyefiñ tati pu che ta küla antü dewma ñi mülepan ta tüfa mew iñche engün ka chem rume niewelay engün tañi iyael. Ayülelan tañi amutuael engün ñi ruka mew petu tañi inon tati pu che. Rume ngüñüle tranapuafuy engün rüpü mew. ");
INSERT INTO arnNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Fey tañi pu disipulu feypieyew: —Welu ¿chew am entulelafiyiñ fentren iyael tüfachi fentren chengealu? Tüfachi lelfün mapu mew ngelay kiñe rukache no rume. ");
INSERT INTO arnNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Fey Jesus ramtufi ñi pu disipulu: —¿Tunten kofke am nieymün ta eymün? —Regle kofke, ka kiñe mufün pichike challwa ―llowdunguy kisu engün. ");
INSERT INTO arnNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Feymew Jesus werküfi tati pu che ñi anükünuwael tati pülli mew. ");
INSERT INTO arnNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Feymew nüfi tati regle pichike kofke ka tati pichike challwa. Fey rupan mañumtufilu ta Ngünechen, wüdamkafi ka eluyefi tañi pu disipulu, fey kisu engün eluyefi tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kom iyey ti pu che ka fente küme weday engün, ka apolngetuy regle kanasta tati sofrachi kofke ka ti challwa mew. ");
INSERT INTO arnNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tati iyelu meli warangka wentrurke, welu rakintukungelay tati pu domo ka ti pu pichikeche. ");
INSERT INTO arnNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Feymew Jesus chaliyetufi tati pu che, konpuy kiñe pichi farku mew, fey amuy ta Magadan trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fey ti pu farisew ka ti pu sadusew amuy ñi pemeafiel engün ta Jesus tañi ngünenmayafiel. Fey feypifi engün tañi pengelael kiñe afmanngechi pepiluwün femngechi tañi küme kimafiel engün tañi küpan ka ñi werküetew ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Welu Jesus llowdungueyew: “Pu trafiayüm feypikeymün ta eymün: ‘Kelükünuwiyüm ta wenu, kümengetuay’ pikeymün. ");
INSERT INTO arnNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ka puliwen feypikeymün: ‘Kelükünuwiyüm wenu ka tromükünuwiyüm, fachantü wesa antüngeay’ pikeymün. Eymün ta fente küme ngüneduamkefimün ñi chumleken ta kallfü wenu. ¿Fey chumngelu am ngüneduamlaymün chem dungu ñi mülen fantepu mew? ");
INSERT INTO arnNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tüfachi pu che wesake piwkengelu ka kisu ngünewünngelu ayüley engün ñi pengelelngeael kiñe afmanngechi dungu, welu doy pengelelngewelayay chem rume, Jona tañi rupaelchi dungu müten.” Fey feypikünungelu engün tüfachi dungu, Jesus amutuy. ");
INSERT INTO arnNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Fey tati pu disipulu rumelu nometu ti pichi lafken mew, ngüyürkey engün tañi yeael ta kofke. ");
INSERT INTO arnNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Feymew Jesus feypifi ñi pu disipulu: —Inaduamfimün ka kuñiwtuwmün tati pu farisew ka tati pu sadusew ñi lefawra mew. ");
INSERT INTO arnNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Fey ti pu disipulu welukonkechi feypiwi engün: —¿Fey tüfachi dungu feypipelaeiñmew taiñ küpalnon mew ta kofke? ");
INSERT INTO arnNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus am kimnielu ñi femngechi rakiduamkülen engün, fey feypifi ñi pu disipulu: —¿Chumngelu anta ‘nielaiñ kofke’ pipeymün? ¡Rume pichin feyentun nieymün ta eymün! ");
INSERT INTO arnNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Petu kimlaymün am ka tukulpalaymün rume tati kechu kofke tañi wüdamkalelfiel tati kechu warangka pu che ka tunten kanasta ñi apolngetun sofrachi wükan kofke mew? ");
INSERT INTO arnNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ka tukulpalaymün rume tati regle kofke tañi wüdamkalelfiel tati meli warangka pu che ka tunten kanasta ñi apolngetun tati sofralu mew? ");
INSERT INTO arnNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chumngelu anta ngüneduamlaymün ta eymün iñche tañi nütramyemekenofiel tati kofke? Tañi feypiwpefielchi dungu feypiley tamün kuñiwtuwael tati pu farisew tañi lefawra mew ka tati pu sadusew mew. ");
INSERT INTO arnNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Feymew ngüneduami engün tañi feypinoetew ta Jesus ñi kuñiwtuwael engün tati lefawra mew tukukeel ta kofke mew, welu may tañi kuñiwtuwael tati pu farisew ñi kimeltukeelchi dungu mew ka tati pu sadusew ñi kimeltukeel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Feymew Jesus puwlu Sesarea Filipo tañi trokiñ mapu mew, ramtufi tañi pu disipulu: —Tati pu che, ¿iney pikeenew anta iñche, tati Wentrukünuwpalu? ");
INSERT INTO arnNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kisu engün llowdungueyew: —Kiñeke che Juan ti Fawtisachefe pikeeymew. Ka kiñeke Elia pikeeymew, ka kiñeke Jeremia pikeeymew ka kiñeke kakelu pu pelon wentru pikey. ");
INSERT INTO arnNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Eymün kay, ¿iney pimuken anta iñche? ―ramtungey engün. ");
INSERT INTO arnNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Fey Simon Pedro llowdungueyew: —Eymi lle tati Cristo, tati rumel mongelekechi Ngünechen tañi Fotüm. ");
INSERT INTO arnNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Feymew Jesus feypifi ta Simon Pedro: —Sakinngeymi eymi, Simon, Jona tañi fotüm. Iney no rume mülelu tüfachi mapu mew feypilaeymew ta tüfachi dungu, tañi Chaw wenu mapu mülelu fey may ta kimeleymew tati. ");
INSERT INTO arnNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Iñche ta ka feypiaeyu, eymi ta Pedro, fey tüfachi kura mew amul trawültukuniean tañi trokiñche, welu chem wesa pepiluwün ñi ngünenieel ta weküfü no rume wewlayaeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Wenu mapu ülmen mülewe ñi llafe eluaeyu. Eymi ta ‘trariley’ pifilmi ta tüfachi mapu mew, ka femngechi Ngünechen trarilelu reke leliwülnieaeyew. Ka eymi ta ‘neyfiley’ pifilmi ta tüfachi mapu mew, ka femngechi Ngünechen neyfilelu reke leliwülnieaeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Feymew müten Jesus feypifi ñi pu disipulu tañi feypinoafiel engün iney no rume kisu tañi Cristongen. ");
INSERT INTO arnNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Feymew Jesus eluwi tañi feypiafiel tañi pu disipulu ñi amuael ta kisu Jerusalen waria mew, fey ti putremke wentru ka ti longkolelu pu saserdote mew ñi rume kutrankayaetew. Feypifi tañi pu disipulu kisu tañi langümngeael, welu küla antüalu mew ñi wiñomongetuael. ");
INSERT INTO arnNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Feymew püntünentueyew ta Pedro, fey eluwi tañi feypiafiel tüfachi dungu: —¡Ngünechen montulaeymew, Ñidol! ¡Fey tüfachi dungu mew ta rupalayaymi! ");
INSERT INTO arnNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Welu Jesus adkintufi ta Pedro, fey feypifi: —¡Püntütripange ta iñche mew, weküfü! ¡Katrülkaduammekeen ta iñche! Eymi ngüneduamkelafimi Ngünechen tañi dungu. Rakiduamküleymi re che ñi dungu mew müten. ");
INSERT INTO arnNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Feymew müten Jesus feypifi tañi pu disipulu: —Iney rume ayüle iñche ñi disipulungeael, kisu ngüyünentuwpe, ka eluwkülepe ñi kutrankawael ta kürus mew ngeay rume, fey inaechimew. ");
INSERT INTO arnNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iney rume ayüle montulael ñi mongen, fey ta pelayay ta mongen, welu tati lakonlu iñche tañi duam, fey peay ta mongen. ");
INSERT INTO arnNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Chem entuafuy anta che ngenngele kom chemkün mew mülelu tüfachi mapu mew, welu ñi püllü amule kütral mapu mew? Tunten pülata rume niellefule kiñe che ñi kulliafel tañi montuam, chem rume niefule ta che montul-layafeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tati Wentrukünuwpalu am ta küpayalu Ngünechen tañi kom pepiluwün mew ka tañi pu werken püllü engün, fey wüla kulliafi reke kake kiñeke che kom tañi femel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Rüf dungu feypiwayiñ kiñekentu tati müleyelu ta tüfa mew lalayay engün pefile wüla engün tati Wentrukünuwpalu tañi longko ülmenngeael. ");
INSERT INTO arnNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Fey kayu antü rupalu, Jesus yefi ta Pedro, Santiaw ka Juan (Santiaw tañi peñi), fey püntütripay ñi amuael engün kiñe alü pürachi wingkul mew. ");
INSERT INTO arnNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Fey tiyechi wingkul mew, kisu engün ñi adkiñ mew, kangerumetuy ñi ad ta Jesus. Ñi ange alofi antü reke, ka tañi takuwün rume lingari pire reke. ");
INSERT INTO arnNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Feymew pefi engün ta Moyse ka Elia nütramkamekelu ta Jesus engün. ");
INSERT INTO arnNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Fey Pedro feypifi ta Jesus: —Ñidol, ¡rume kümey taiñ mülepan tüfa mew! Pilmi, dewmayafuiñ küla pichike küni ruka: kiñe eymingealu, ka kiñe ta Moysengealu ka kiñe Eliangealu. ");
INSERT INTO arnNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petu dungumekelu ta Pedro, kiñe alofkülechi tromü munulpaeyew kiñe llawfeñ reke, fey tati tromü mew tripay kiñe dungun feypilu: “Fey tüfa iñche tañi sakin Fotüm, iñche tañi dulliel. Allkütuñmafimün ñi dungu.” ");
INSERT INTO arnNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Allkülu engün tüfachi dungun, tati pu disipulu lloyünagümkünuy ñi longko engün pülli mew, fente ñi llükan mew. ");
INSERT INTO arnNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus fülkonpuy kisu engün mew, fey nükünufi ñi kuwü mew ka feypifi: —Witrapüratumün. Llükakilmün. ");
INSERT INTO arnNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Fey adkintulu engün, pefi engün Jesus ñi kisulewetun. ");
INSERT INTO arnNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Fey petu nagpatulu engün tati wingkul mew, Jesus feypifi ñi küla pu disipulu: —Iney no rume ta nütramel-layafimün tamün peelchi dungu, wiñomongetule wüla tati Wentrukünuwpalu küpalu ta wenu mapu. ");
INSERT INTO arnNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Fey tañi pu disipulu ramtueyew: —¿Chumngelu am feypikerkey tati pu kimeltukelu tati ley dungu Elia tañi wüne küpayael tati Cristo mew? ");
INSERT INTO arnNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Fey Jesus llowdungufi ñi pu disipulu: —Feyngey tañi wüne küpayafel ta Elia, kisu ñi kom küme elafiel ta dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Welu iñche ta feypiwayiñ, Elia ta dew küpay, fey tati pu judiu kimwetulafi, welu kisu engün chumünchumfi rume kom tañi wesa ayütuel engün. Ka femngechi, tati Wentrukünuwpalu kutrankaway kisu engün tañi fillmekeafiel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Feymew tati pu disipulu ngüneduami engün Jesus tañi nütramelmekeetew ñi tukulpafiel ta Juan ti Fawtisachefe. ");
INSERT INTO arnNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Puwlu engün chew tañi mülemum tati pu che, kiñe wentru fülkonpay ta Jesus mew, ka lukutupay kisu tañi fül mew, fey feypieyew: ");
INSERT INTO arnNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Ñidol, kutranpiwkeyeñmaen tañi fotüm. Lalatukey ka rume kutrankawkey. Kiñeke mew ütrüfkonkey kütral mew, ko mew kütu. ");
INSERT INTO arnNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tüfa mew küpalelpefuiñ tami pu disipulu, welu pepi tremolafi engün. ");
INSERT INTO arnNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Fey Jesus feypi: —¡Eymün pu ngenofeyentun che ka wesake rakiduam nielu! ¿Tunteñma anta mülerkean ta eymün mew? ¿Tuntepu mew wüla anta fentekünurkean tamün peniewafiel? Küpalelmuchi tati pichiwentru ―pirkey. ");
INSERT INTO arnNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Feymew Jesus werküfi tati weküfü ñi tripatuael tati pichiwentru mew, fey wemünentufi. Feychi mew müten tremolewetuy ti pichiwentru. ");
INSERT INTO arnNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Fey wüla ñi pu disipulu wichu nütramkaeyew, fey ramtueyew: —¿Chumngelu am iñchiñ pepi wemünentulafiyiñ tati weküfü? ");
INSERT INTO arnNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Fey Jesus llowdungufi ñi pu disipulu: —Eymün am müna pichin mupiltun nielu. Rüf dungu feypiwayiñ niefulmün ta mupiltun, kiñe pichi fün mostasa fenteafuy rume, fey feypifilmün tüfachi wingkul: ‘Tripatunge ta tüfa mew. Kañpüle amutunge’, tati wingkul ta engkef tripayafuy. Chem rume ta kisu ngünewlayafuy. ");
INSERT INTO arnNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Welu ta tüfa famngechi weküfü ñi tripatuael, feley tañi ngillatuael ka ayunayael ta che. ");
INSERT INTO arnNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Petu miyawlu kiñentrür ñi disipulu engün Galilea tañi trokiñ mapu mew, Jesus feypifi ñi pu disipulu: —Iñche tati Wentrukünuwpalu ta chalintukungean tati pu wentru mew. ");
INSERT INTO arnNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ka langümaenew engün, welu küla antüalu mew, wiñomongetuan. Tüfa famngechi feypingelu, rume weñangküy engün. ");
INSERT INTO arnNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Feymew Jesus ka tañi pu disipulu puwlu engün ta Kapernaum waria, tati pu kofrakelu impuestu ta ngillatuwe rukangealu amuy engün ñi pemeafiel ta Pedro, ka ramtufi engün: —¿Tami kimeltufe kullikelay ta impuestu tati ngillatuwe rukangealu? ");
INSERT INTO arnNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—May, kullikey ta kisu ―llowdunguy ta Pedro. Fey Pedro konputulu ruka mew, Jesus ramtufemeyew: —¿Eymi chumngentufimi kay, Pedro? Kiñe longko ülmen wentru ta tüfachi mapu mew, ¿ineykechi am kofrakefi impuestu: kisu tañi pu yall kam ti kakelu pu che? ");
INSERT INTO arnNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Fey Pedro llowdungufi ta Jesus: —Kofrakefi tati kakelu pu che. Fey Jesus feypi: —Feley tati, Pedro. Kümey tami piel. Chumngechi tati longko ülmen ñi pu yall ngelay ñi kulliael chem impuestu no rume, ka femngechi ngelafuy Ngünechen ñi pu yall ñi kulliael ti impuestu ta Ngünechen ñi ngillatuwe rukangealu. ");
INSERT INTO arnNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Welu iney rume tañi wesaduamnoael, amunge tati pichi lafken mew, ütrüftukupunge tami ansuelu ka witranentufinge tami wüne entuelchi challwa. Fey ti wün challwa mew peaymi kiñe moneda, feymew mür kulliayu tati impuestu. Yefinge ti moneda, fey kullimenge tati impuestu. ");
INSERT INTO arnNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Feychi mew müten tati pu disipulu fülkonpuy Jesus mew, fey ramtufi engün: —¿Iney anta doy sakifali ta Ngünechen tañi ülmen mülewe mew? ");
INSERT INTO arnNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Feymew Jesus mütrümfi kiñe pichiwentru, fey kisu engün ñi rangiñ mew puwülfi ");
INSERT INTO arnNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ka feypi: —Rüf dungu feypiwayiñ eymün we rakiduam nietunolmün kiñe pichiche reke, konpulayaymün ta Ngünechen ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tati doy sakifalkülelu ta Ngünechen ñi ülmen mülewe mew fey tati diñmatukenolu chemkün kiñeke tüfachi pichiche reke. ");
INSERT INTO arnNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ka iney rume llowfilu kiñe famngechi pichiche iñche tañi üy mew, iñche ka llowenew tati. ");
INSERT INTO arnNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Iney rume ngünenkafile ñi yafkayael ta kiñe feyentulelu iñche mew ñom piwkengelu kiñe pichiche reke, doy kümeafuy kiñe fütra kura ñi trapeltukukünulelngeael ñi pel mew, fey ñi ütrüftukungeael tati doy llufülechi lafken mew. ");
INSERT INTO arnNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“¡Awngey fentren kintukaduamngen dungu ñi mülen mew tüfachi mapu! Feyngey ñi mülen tüfachi wesake dungu mapu mew, welu ¡awngey tiyechi che yafkan mew tukufile ta kakelu che! ");
INSERT INTO arnNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Feymew, tami kuwü kam tami namun rume yafkantukuelmew, katrüfinge ka entufinge ta eymi mew. Doy kümey tami mongeleael ketrolipangkülen ka ketronamunkülen rume, fey nielmi ta epu kuwü kam epu namun rume, welu tami tukungeael ti chongkenochi kütral mew. ");
INSERT INTO arnNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tami nge yafkantukukeelmew, entufinge ka famentufinge ta eymi mew. Doy kümey tami mongeleael fey tami nien kiñe nge müten, fey nielmi epu nge tami tukungeael ta kütral mapu mew ―pi ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ngüneduamaymün tamün illamnienoafiel kiñe no rume ta tüfachi pichikeche. Iñche feypiwayiñ kake kiñeke kisu engün tañi werken püllü rumel puwpuwngekey chew müley iñche tañi Chaw, wenu mapu mülelu. ");
INSERT INTO arnNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tati Wentrukünuwpalu am küpalu ñi montulafiel tati pu ñamkülelu reke ñi yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Kümelu trokifimün kay? Kiñe wentru niele pataka ufisa, fey ñamkünuwle kiñe tüfa engün, ¿elkünulayafuy chey am tati pu aylla mari aylla lelfün mew, ñi amuael ñi kintumeafiel tati ñamkünuwlu? ");
INSERT INTO arnNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Fey petufile, rume ayüwafuy tañi petuelchi ufisa mew, tati aylla mari aylla mew ñamkenolu engün am. ");
INSERT INTO arnNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ka femngechi, eymün tamün Chaw, mülelu ta wenu mapu, ayülelay tañi ñamael kiñe no rume ta tüfachi pichiche reke felelu ñi feyentun mew. ");
INSERT INTO arnNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Tami feyentulechi weni wesa femelmew, dunguafimi. Kisulelmu, fey feypiafimi tañi wesa femün. Fey allkütuñmaelmew tami dungu, ka kümelkawtulmu tami weni eymu. ");
INSERT INTO arnNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Welu allkütuñmanoelmew, mütrümnge ta kiñe kam epu che, femngechi epu che kam küla che tañi dungun mew ñi küme elngetuael tati wesa dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ka femngechi pinole ñi allkütuafiel tati kakelu che, feypintukuafimi tati trokiñ feyentulelu mew. Fey ka feyentunofile tati trokiñ feyentulechi pu che, fey wüla ta feley ñi kiñe feyentulenolu ñi trokingetuael kam kiñe tati kofrakelu impuestu reke Romangealu ñi trokingetuael. ");
INSERT INTO arnNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Rüf dungu feypiwayiñ chem che rume trarifilmün reke tañi yafkan mew ta tüfachi mapu mew, ka femngechi trarileweay reke Ngünechen mew ta wenu mapu. Ka chem che rume nentu neyfifilmün reke tañi yafkan mew ta tüfachi mapu mew, ka femngechi nentu neyfilewetuay ta wenu mapu Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Fey tüfachi dungu feypiwayiñ: Epu feyentulelu, kiñewle tañi ngillatuael tañi eluen piael tüfachi mapu mew, iñche tañi wenu mapu mülechi Chaw fey ta eluaeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chew rume mülele epu kam küla che trawüluwkülelu iñche ñi üy mew, iñche mülean kisu engün mew.” ");
INSERT INTO arnNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Feymew Pedro fülkontufi ta Jesus ka ramtufi: —Ñidol, ¿mufü rupachi am feley tañi wiñoduamatuael tañi chafche, chem wesa femelimew rume? ¿Regle rupachi pemay? ");
INSERT INTO arnNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus llowdungueyew: —Regle rupachi müten pipelaeyu. Regle mari rupa regle pin may. ");
INSERT INTO arnNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Fey tüfachi dungu mew, Ngünechen tañi longko ülmenngen feley ta kiñe longko ülmen reke eluwlu ñi ramtuafiel tañi pu küdawelkeetew tunten ñi defenieetew. ");
INSERT INTO arnNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Petu llitulu tañi ramtuafiel, feymew akulelngey kiñe tañi defenieetew rume fentren pülata. ");
INSERT INTO arnNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tiyechi küdawfe am nienolu chumngechi ñi kulliael, fey tati longko ülmen werküy ñi fendengeael tati defelelu, kiñe püresukona reke, kiñentrür ñi kure engu, ñi pu yall ka kom ñi chemkün tañi nieel kütu, femngechi tañi kulliael kom tañi defeleel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Fey tati defelechi küdawfe lukutuy ti longko ülmen ñi fül mew, ka llellipufi: ‘Ñidol, kutranduamyeen ta iñche. Pichi üngümen. Kom wiñoleltuaeyu tati.’ ");
INSERT INTO arnNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Fey tati longko ülmen kutranduamyeeyew, feymew wiñoduamatufi kom tañi defelekefel mew ka lifrenentufi ti küdawfe. ");
INSERT INTO arnNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Welu tripapatulu, tiyechi küdawfe pefi kiñe tañi traf küdawfe defenieetew pichin pülata. Nüfemfi pel mew ka eluwi ñi aporiayafiel, feypiniefi: ‘¡Kullituen kom tami defeniefiel!’ ");
INSERT INTO arnNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Fey ñi traf küdawfe lukutulen llellipueyew: ‘Kutranduamyeen ta iñche. Pichi üngümen. Kom wiñoleltuaeyu tati.’ ");
INSERT INTO arnNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Welu kangelu pilay, ka amul püresuntukufi karsel mew kom kullingetule wüla tañi defeniengeel ñi tripatuael ti karsel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Fey tüfachi dungu mew rume kutrantupiwkey tati kakelu pu küdawfe, fey nütramelmefi engün tati longko ülmen ñi femngechi femfiel ñi traf küdawfe. ");
INSERT INTO arnNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Feymew tati longko ülmen mütrümfalfi, ka feypifi ti wesa piwkengechi küdawfe: ‘¡Eymi ta rume wesa piwke wentru ürke! Iñche wiñoduamatueyu nga kom tami defeniefiel mew tami llellipufiel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Feymew eymi ta ka felefuy tami wiñoduamatuafiel tami traf küdawfe. Chumngechi wiñoduamatueyu ta iñche ka femafulu ta eymi.’ ");
INSERT INTO arnNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Fey fente ñi lladkün tati longko ülmen, werküy ñi püresuntukungeael karsel mew tati wesa piwke wentru kom kullile wüla kom tañi defeleel ñi neykümkünungetuael.” ");
INSERT INTO arnNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Fey Jesus amul feypi: “Ka femngechi femaeymünmew ta eymün ta iñche ñi Chaw mülelu ta wenu mapu mew, kiñeke ta eymün kom piwke mew wiñoduamatunolmün tamün yafkaetewchi chafche.” ");
INSERT INTO arnNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Rupan feypilu ta tüfachi dungu, Jesus tripatuy ta Galilea mew, fey puwi Judea trokiñ mapu mew, Jordan tañi tripawe antü püle. ");
INSERT INTO arnNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Rume fentren che inaeyew, ka feymew Jesus tremolyefi tati pu kutrankülelu. ");
INSERT INTO arnNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kiñeke ti pu farisew fülkonpuyngün ta Jesus mew re ngünen mew tañi ramtuafiel, fey feypieyew: —¿Kümey am kiñe wentru ñi wüdakureael chem dungu mew rume? ");
INSERT INTO arnNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Feymew Jesus llowdungufi ti pu farisew: —¿Adümlafimün am tati wirikonkülechi dungu ta llituka mew müten, feychi dewmangelu ta wentru domo engu? ");
INSERT INTO arnNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ka feypi: ‘Feymew ta wentru ta wichuay ñi chaw ka tañi ñuke mew kisu ñi amayewael ñi kure engu, fey mür kiñe che reke ñi feleael engu.’ ");
INSERT INTO arnNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Feymew ta epu che reke felewetulay engu. Kiñengetuy müten. Feymew ngelay iney rume ñi wüdamentuael Ngünechen ñi trapümel. ");
INSERT INTO arnNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Feymew ramtueyew engün: —¿Chem mew ürke am Moyse werküfi ta wentru ñi eluafiel kiñe wirin dungu ñi kure tañi wüdafiel? ");
INSERT INTO arnNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Fey Jesus feypifi ti pu farisew: —Re tamün wesa yafü piwkengen mew ta eymün, Moyse elueymünmew tamün wüdayael tamün kure. Llituka mew ta ngelafuy feychi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Iñche ta feypiwayiñ tati wüdalu tañi kure fey tañi ñiwañpenoetew rume, fey ka domo kureyetule, fey ta ñiwaldomofengey. Fey kureyefilu ti wüdakünuelchi domo, ka femngechi ñiwaldomofengey. ");
INSERT INTO arnNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Fey Jesus tañi pu disipulu feypieyew: —Feychi dungu felele ñi femael ta wentru ñi kure mew, kümelay ta kurengen. ");
INSERT INTO arnNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Fey Jesus llowdungufi ñi pu disipulu: —Kom che ta pepi ngüneduamlayay ta tüfachi dungu, tiyechi pu che müten ta Ngünechen ñi eluetew ñi ngüneduamafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Müley epe fill dungu ñi katrütunieetew ta pu wentru ñi kurengeael: kiñekentu dew felen choyüngekey ñi pepi kurengenoael, ka kiñeke wentru femkünungekey tañi pepi kurengenoael, ka kiñeke re ñi pinon mew kurengekelay femngechi tañi küme poyeafiel ta Ngünechen. Tati ayülu ñi llowael ta tüfachi dungu, llowpe müten. ");
INSERT INTO arnNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yelelngey ta Jesus kiñeke pichikeche, tañi fampuwülael ñi kuwü ta kisu engün mew, fey ñi ngillatuñmayafiel, welu tati pu disipulu eluwi tañi katrütuafiel tati yeniefilu ti pichikeche. ");
INSERT INTO arnNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Feymew Jesus feypifi ñi pu disipulu: —Elufimün ti pichikeche ñi küpayael iñche mew. Katrütukefilmün. Ngünechen ñi ülmen mülewe mew koneltuley tati kisu engün reke femngelu. ");
INSERT INTO arnNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Fey fampuwülelfi ñi kuwü ti pichikeche, fey ngillatuñmafi, feymew wüla kañpüle amutuy. ");
INSERT INTO arnNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kiñe weche wentru amuy ñi pemeafiel ta Jesus, fey ka ramtupufi: —Küme piwke kimeltufe, ¿chem küme dungu am feman tañi nieael rumel mongen? ");
INSERT INTO arnNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus llowdungueyew: —¿Chem mew anta küme piwke kimeltufe pien? Kiñeley müten tati küme piwkengelu. Welu ayülmi tami nieael tati rumel mongen, müngeltuafimi tati werkün dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Chuchi werkün dungu am? ―ramtuy tati weche wentru. Fey Jesus llowdungueyew: —‘Langümchekilnge, ñiwaldomokilnge, weñekilnge, üñfitukefilnge koyla dungu mew ta kangelu, ");
INSERT INTO arnNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","yamafimi tami chaw ñuke engu, ka piwkeyeafimi tami chafche chumngechi piwkeyewimi eymi kisutu.’ ");
INSERT INTO arnNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Femken ta kom feychi dungu. ¿Ka chem am petu faltay? ―pi tati weche wentru. ");
INSERT INTO arnNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus llowdungueyew: —Ayülmi tami nieael nor mongen, amunge, fendenge tami nieel ka elufinge tati pu nienolu chem no rume. Femngechi fütra küme felen nieaymi ta wenu mapu mew. Fey küpange ka inaen. ");
INSERT INTO arnNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Feymew tati weche wentru, allkülu tüfachi dungu, rume weñangkülen amutuy, rume rikulerkelu am. ");
INSERT INTO arnNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Feymew Jesus feypifi tañi pu disipulu: —Rüf dungu feypian rume küdawngey kiñe riku ñi konpuael Ngünechen ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ka feypiwayiñ doy küdawngelay ta kiñe kamellu ñi rumeael ti longko akucha mew, fey kiñe riku ñi konael Ngünechen ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Fey allküñmaetew tañi pu disipulu, doy afmalewey engün ka feypi engün: —Fey, ¿iney am pepi monturkeay? ");
INSERT INTO arnNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus adkintufi ñi pu disipulu ka llowdungufi: —Che ñi pepilnoel, Ngünechen ta pepilniey. ");
INSERT INTO arnNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Feymew feypieyew ta Pedro: —Iñchiñ elkünuiñ kom taiñ niekefel fey ka inawiyiñ. ¿Chem am llowaiñ? ");
INSERT INTO arnNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Fey Jesus llowdungufi ñi pu disipulu: —Rüf dungu feypiwayiñ, puwle tati antü kom tañi wengetuael, feychi mew tati Wentrukünuwpalu mapu mew anüle tañi afmafalchi ülmen mülewe mew, eymün am feyentumufiel feymew ka femngechi anüaymün ta mari epu ülmen mülewe mew tamün ramtukadunguafiel Israel tañi mari epu trokiñche. ");
INSERT INTO arnNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Fey iñche tañi duam iney rume elkünule ñi ruka, peñi, kam lamngen, kam chaw, kam ñuke, kam domo, kam fotüm, kam mapu rume, llowtuay doy pataka rupachi, ka lloway tati rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Welu tüfa fentren tati wünenküleyelu, inaleyetuay. Ka pütrün ta tüfa inaleyelu, wüneleyetuay. ");
INSERT INTO arnNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Fey ka femngechi Ngünechen tañi longko ülmenngen kiñe wentru reke feley tati ngenngelu kiñe ofadentu mew, tripalu ta küme puliwen tañi kintuael küdawfe ñi katrüofadelaetew. ");
INSERT INTO arnNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Fey ti ngen ofadentu küme nütramkafi ti pu küdawfe ñi tunten kulliafiel engün kiñe antü küdaw mew, fey werküfi ñi küdawelmengeael ti ofadentu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Feymew aylla ora amulechi liwen ka tripay tati ngen ofadentu, fey pefi kiñeke küdawfe relelu pülasa mew. ");
INSERT INTO arnNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Fey feypifi: ‘Eymün amumün kay tamün küdawael iñche tañi ofadentu mew. Ka femngechi kulliwayiñ tamün küdaw mew.’ Fey kisu engün amuy ñi küdawael. ");
INSERT INTO arnNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Tati ngenngelu ka wiñome tripay rangiantülu dewma, fey tripay küla ora naglu ti antü, ka femngechi pemey ta küdawfe. ");
INSERT INTO arnNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Dewma kechu ora naglu ta antü, ka wiñome amuy ta pülasa mew, feymew ka pepuy kiñeke küdawfe relelu, fey ramtufi: ‘¿Chem mew anta müleymün eymün tüfa mew kom antü fey tamün küdawnon?’ ");
INSERT INTO arnNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Llowdungungey: ‘Iney no rume am elukenoetew küdaw ta iñchiñ.’ Feymew feypingey engün: ‘Amumün kay eymün tamün küdawael iñche tañi ofadentu mew.’ ");
INSERT INTO arnNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Feymew pu trafialu, tati ngenngelu feypifi tati ngüneduamkefilu tati pu küdawfe: ‘Mütrümfinge tati pu küdawfe, ka kullifinge. Llituaymi tati pu inangechi akulu mew, fey dewmantuaymi tati pu wünelu mew akulu.’ ");
INSERT INTO arnNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Akuyey engün, tati konyelu tañi küdawael kechu ora naglu dewma ta antü, fey kake kiñeke llowi engün tunteke ñi wewken ta kiñe küdawfe kiñe antü mew. ");
INSERT INTO arnNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Feymew ka konpuy tati pu wüneltu konlu ñi küdawpuael. Rakiduami engün ñi doy alü llowael ñi kullitu engün, welu kake kiñeke kisu engün llowi ka femngechi kiñe antü küdaw kullitu müten. ");
INSERT INTO arnNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Fey llowlu engün tañi kullitu, eluwi engün tañi fillpiafiel tati ngen ofadentu, ");
INSERT INTO arnNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","feypilen mew: ‘Tüfa engün, tati akuyelu epe konantü, kiñe ora müten ta küdawi engün. Eymi ta tunteke kullimuiñ iñchiñ ka fente kullifimi ta kisu engün. Iñchiñ ta kom antü rume küdawiyiñ ka arekawiyiñ ta antü mew.’ ");
INSERT INTO arnNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Welu tati ngenngelu llowdungufi kiñe küdawfe: ‘Weni, chem wesa ngünenkapelaeyu rume. ¿Fente küme feypiwlayu ama tami tunte kulliafiel ta kiñe antü küdaw mew? ");
INSERT INTO arnNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Fey nünge tami kullitu ka amutunge. Iñche ta küpa elufili ta tüfa engün tati inangechi konlu tañi küdawael ka fenten eymi tunteleyu, ");
INSERT INTO arnNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","iñche ta kisu tañi pülata mew chumafun rume. ¿Kam ta ütririmi iñche tañi küme piwketuchefengen mew?’ ");
INSERT INTO arnNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Feymew llemay tüfa tati inalelu, fey engün ta wüneletuay. Femngechi fewla ta wüneleyelu, inaleyetuay engün itrokom mew. Pütrüley tati mangelel, welu pichiley tati dullinieel.” ");
INSERT INTO arnNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus trekalelu rüpü mew ñi amuael ta Jerusalen, wichu mütrümentufi tañi mari epu disipulu ka feypifi: ");
INSERT INTO arnNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Fewla ngüneduamaymün taiñ amulen ta Jerusalen, chew ta chalintukungean tati longkolelu pu saserdote mew ka tati pu kimeltukelu tati ley dungu mew, ka kondenangean fey tañi langümngeael. ");
INSERT INTO arnNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ka chalintukungean tati kake trokiñke mapu küpayechi pu che mew tañi ayentukangeael ka ñi wülelkangeael ka tañi langümngeael kürus mew, welu küla antüalu mew wiñomongetuan. ");
INSERT INTO arnNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Fey Sefedew tañi kure amuy kiñentrür tañi epu püñeñ engün Jesus mew, fey lukutunagpuy kisu tañi fül püle tañi “füreneñmayaen ñi epu püñeñ” ñi piafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Feymew Jesus ta ramtueyew: —¿Chem anta duamimi? Fey tati domo feypi: —Tami longko ülmen mülewe mew kiñe tañi epu püñeñ anüpupe eymi tami man ad püle, fey kangelu ñi püñeñ, tami wele ad püle. ");
INSERT INTO arnNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus ta llowdunguy: —Eymu kimlaymu tamu ngillatupeel. ¿Putuafuymu am tati füre pulku tañi putuael ta iñche? ¿Ka femngechi fawtisangeafuymu chumngechi fawtisangen ta iñche? Fey kisu engu feypi: —May, putuafuyu. ");
INSERT INTO arnNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Feymew Jesus feypifi ñi epu disipulu: —Eymu ta putuaymu ta tüfachi füre pulku, ka fawtisangeaymu chumngechi fawtisangen ta iñche, welu tamu anüpuael iñche tañi man ad püle kam tañi wele ad püle iñche ta koneltulelan tañi feypiael. Tañi Chaw müten kimniey iney tañi füreneafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Feymew allküyelu ti kakelu mari pu disipulu ta tüfachi dungu, lladküy engün tati epu peñiwen ñi feypiel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Welu Jesus mütrümfi ñi pu disipulu, feymew feypifi: —Eymün ta kimnieymün tati pu longkoleyelu tüfachi pu trokiñche mew rume ñidolkawkülekey engün, ka tati fütrake longkolelu ayükey engün kom che tañi kimael ñi longkolen engün. ");
INSERT INTO arnNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Welu eymün mew ta ngekilpe feychi dungu. Tamün femafel, iney rume ayüle ñi longkoleael, feley tañi poyeafiel ta kakelu pu che. ");
INSERT INTO arnNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ka iney rume ta eymün mew küpa wünelele, fey ta konayeafimün. ");
INSERT INTO arnNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Fey ka femngechi tati Wentrukünuwpalu küpalay tañi poyengeael, welu may küpay tañi poyecheael, ka ñi wültukuael tañi mongen femngechi ñi lifrenentuafiel ta kom che ñi yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Fey dew tripapatulu Jesus engün ta Jeriko waria mew, rume fentren che ta inaeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Epu trawma anülelu ta inaltu rüpü, allküy engu Jesus tañi rupalen fey püle, fey wirari engu: —¡Ñidol, David mew tripachi dullin Yomelche tati küpayay piniekeel, kutranpiwkeyemuyu! ");
INSERT INTO arnNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tati pu che lladkütu dungueyew tañi wirarkümekenoael engu, welu kisu engu doy wirari: —¡Ñidol, David ñi Yomelche, kutranpiwkeyemuyu ta iñchiw! ");
INSERT INTO arnNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Feymew Jesus witrakünuwi ka mütrümfi tati epu trawma, fey ramtufi: —¿Chem duamnieymu am tamu kelluwafiel? ");
INSERT INTO arnNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Fey llowdungueyew engu: —Ñidol, ayüleyu tayu pelotuafel. ");
INSERT INTO arnNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus ta rume kutranpiwkeyefi ti epu trawma, ka idañmangey ñi nge engu. Feychi mew müten tati epu trawma pelotuy engu, fey inaeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Dewma fülkülepulu engün ta Jerusalen, puwürkey engün ta Betfage fülkülelu Jerusalen mew, Olifu fütra wingkul mew. Feymew Jesus werküfi tañi epu disipulu, ");
INSERT INTO arnNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","fey feypifi: —Amumu tati adkiñkülechi waria mew. Fey tiye mew pepuaymu ta kiñe kude furiku trapelkülelu kiñe pichi furiku inafül mülelu. Nentutrapelafimu, fey küpalelmuan. ");
INSERT INTO arnNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Iney rume ramtuelmumew chumngelu tamu fempen, feypiafimu: ‘Ñidol ta duamtueyew tati’ ka ‘Pürüm wiñolpatuafiyu’ piaymu. ");
INSERT INTO arnNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Fey tüfa ta femngechi femi tañi mupiael ñi feypiel tati pelon wentru, feychi wirintukulu: ");
INSERT INTO arnNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Feypifimün tati Sion waria che: ‘Adkintumün, tamün longko ülmen küpaley eymün tamün pepayaetew, ñom piwke mew, kawellutuley kiñe furiku, kiñe we pichi furiku mew, kutama yekechi kude kulliñ tañi koñi.’ ” ");
INSERT INTO arnNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Fey tati epu disipulu amuy ka femi engu chumngechi ñi werküetew engu ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Feymew yemefi engu tati kude furiku ka ti pichi furiku. Püramelngey chañu ti pichi furiku ñi wente furi, feymew Jesus pürakawelluy ti pichi furiku mew. ");
INSERT INTO arnNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Rume fentren che mülerkey tiye mew. Kiñekentu inüfkünuyey kisuke tañi takuwün engün rüpü mew, ka kiñekentu tranakünuyey engün row anümka tañi watro entuyeel engün anümka mew. ");
INSERT INTO arnNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Fey tati pu wüneleyelu ka tati pu inaleyelu wirarküley engün: “¡Püramyengepe tati longko ülmen David tañi Yomelche! ¡Püramyengepe tati küpalu Ngünechen mew! ¡Püramyengepe ta wenu mapu mew!” ");
INSERT INTO arnNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Feychi Jesus konpulu ta Jerusalen, kom tati pu waria che pofolkawi, ka rume fentren che welukonkechi ramtuwi engün: —¿Iney anta tüfachi wentru? ");
INSERT INTO arnNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Fey tati pu che llowdunguwi engün: —Jesus tati, ti pelon wentru Nasaret waria tuwlu, Galilea trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus konpuy tati ngillatuwe ruka mew, fey wemünentupufi tiye mew kom tati fendemekelu ka tati ngillakamekelu. Ütrüfrulpañmafi tañi mesa tati trafkintulelkefilu pülata tati pu che, ka femngechi ütrüfrulpañmafi tañi wangku tati fendekelu palluma ");
INSERT INTO arnNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ka feypifi: —Tati Wirin Chillka mew wirikonküley: ‘Iñche tañi ruka ngillatuwe ruka pingey’, welu eymün nietufimün weñefe ñi ruka reke. ");
INSERT INTO arnNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Fülkonpay engün ta Jesus mew tati ngillatuwe ruka püle tati pu trawma ka tati pu küntro, fey kisu tremolyetufi. ");
INSERT INTO arnNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Welu tati pu longkolelu ti pu saserdote mew ka ti pu kimeltukelu tati ley dungu pefilu engün ti afmanngechi dungu ñi femel ta Jesus, ka allkülu engün ti pichikeche ñi wirarkülen tati ngillatuwe ruka ñi lepün mew fey ta famngechi: “¡Püramyengepe tati longko ülmen David mew tripachi dullin Yomelche!”, rume lladküy engün. ");
INSERT INTO arnNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Feymew feypifi engün ta Jesus: —¿Allküymi am tañi feypimeken tüfachi pichikeche? Fey llowdungueyew ta Jesus: —May, allküñmafiñ. Welu ¿adümlafimün anta eymün tati wirikonkülechi dungu ta Wirin Chillka mew? Fey feypiley: ‘Ayüwimi tami püramyeaetew tati pu pichikeche ka tati pu llusu pichikeche.’ ");
INSERT INTO arnNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Feymew elkünutufi ti pu che, ka tripatuy ti waria mew, fey amuy ta Betania. Tüfey mew umañtupuy kiñe pun. ");
INSERT INTO arnNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Fey ka antü mew puliwen, konküleputulu ta waria mew, Jesus ngüñürkey. ");
INSERT INTO arnNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Feymew pefi kiñe igera mülelu inaltu rüpü, fey fülkontupufi, welu kiñe fün no rume peñmalafi, re tapül müten. Feymew feypifi tati igera: —¡Chumkawnorume ta wülwelayaymi ta fün! Feychi lelen mew müten choñfünagi tati igera, fey angküy. ");
INSERT INTO arnNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Fey tati pu disipulu, pefilu engün am ti igera ñi angkülewen, afmatulewey ka ramtuy engün: —¿Chumngechi am fente müchay angküy tati igera? ");
INSERT INTO arnNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Fey Jesus ta llowdungufi ñi pu disipulu: —Rüf dungu feypiwayiñ nielmün ta mupiltun, ka femngechi epu rakiduamkülenolmün, fey tüfachi dungu müten ta pepi femlayaymün iñche tañi femfiel tati igera. Eymün ta feypifilmün ta tüfachi wingkul: ‘Kiñe püle tripange ta tüfa mew ka ütrüfkonpunge ta lafken mew’, fey femngechi femay. ");
INSERT INTO arnNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Itrokom tami eluen piel ta ngillatun mew feyentulelmün, llowaymün ―pi. ");
INSERT INTO arnNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Dew rupalu kom tüfachi dungu, Jesus konpuy ti ngillatuwe ruka ñi lepün mew. Fey mülepulu tüfey mew ka kimeltumekelu, fülkontupueyew tati pu longkolelu ti pu saserdote mew ka ti pu longkolelu tati pu judiu mew, fey ramtufi engün ta Jesus: —¿Iney am werküeymew tami femael tüfachi dungu? ¿Iney anta elueymew ta tüfachi pepiluwün? ");
INSERT INTO arnNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus llowdungueyew feypilen mew: —Iñche ka ramtuwayiñ kiñe dungu. Fey küme llowdungulelmuli, iñche ta ka feypiwayiñ iney ñi werküetew tañi femael iñche tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juan tañi fawtisacheael, ¿iney am werküeyew? ¿Ngünechen pemay, kam tati pu che? Feymew kisu engün welukonkechi nütramkawi, feypilen mew: “ ‘Ngünechen werküeyew’, piliyiñ, feypiaeiñmew: ‘¿Chumngelu anta feyentulafimün?’ piay. ");
INSERT INTO arnNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ka pepi feypilayaiñ rume ti pu wentru ñi werküetew, fey kuñiwünngelu am tati pu che kom feyentulelu engün am Juan tañi wewpiken Ngünechen ñi dungu.” ");
INSERT INTO arnNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Feymew llowdungufi engün ta Jesus: —Kimlaiñ iney tami werküetew. Feymew Jesus llowdunguy: —Iñche ka feypiwlayayiñ iney tañi werküetew tañi femael tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Feymew Jesus ta ramtufi tati pu longkolelu: —¿Chem piafuymün kay eymün tüfachi dungu mew? Kiñe wentru nierkey epu fotüm, fey feypifi kiñe ñi fotüm: ‘Fotüm, amunge tami küdawael iñche tañi ofadentu mew.’ ");
INSERT INTO arnNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Welu tañi fotüm llowdungueyew: ‘¡Küpa amulan!’ Welu rakiduamlu wüla, fey amuy ñi küdawael. ");
INSERT INTO arnNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Feymew müten tati ngen fotüm ka legtudungufi ta kangelu, fey ka femngechi werküfi ñi küdawmeael tañi ofadentu mew. Fey tüfa llowdunguy: ‘Felepe tatey, chachay, iñche ta amuan.’ Welu amulay. ");
INSERT INTO arnNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Fey chuchi anta tüfachi epu fotüm femi tañi chaw tañi werküetewchi dungu? —Tati wünelu mew werküel ―pi ñi llowdungun engün. Fey Jesus ta feypifi tati pu longkolelu: —Rüf dungu feypiwayiñ tati pu kofrakelu impuestu Romangealu, ka tati pu küri domo, tañi feyentun mew ta wünelu mew konpuay engün ta Ngünechen ñi ülmen mülewe mew, ");
INSERT INTO arnNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan tati Fawtisachefe am küme kimeltupaetew chumngechi mongen tañi nieael ta che tüfachi mapu mew. Eymün feyentulafimün, welu ta tüfeychi pu kofrakelu ta impuestu ka tati pu küri domo, fey engün feyentufi Juan ñi wewpielchi dungu. Welu eymün, allküfuymün rume kom tüfachi dungu, wiñorakiduamtulaymün tamün feyentuafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Allkütumün ka kiñe adkünu dungu: tati kiñe ngen ruka anümi ta kiñe ofadentu ka malalmafi. Pepikay kiñe mülewe chew tañi dewmayam ta pulku ka dewmay kiñe alüpürachi ruka kom püle tañi puwkintunieam ñi ofadentu. Feymew müten amediakünulelfi ñi mapu kiñeke pu küdawfe, fey kisu amuy kañpüle. ");
INSERT INTO arnNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Fey akulu ti kosecha antüngen, werküy kiñeke tañi pu küdawfe ñi llowmeael engün tati pu küdawfe mew tañi koneltuleelchi fün ofad. ");
INSERT INTO arnNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Welu tati pu küdawfe nüfi engün tati pu kona. Kiñe wülelkafi engün ka kiñe langümfi engün, fey kangelu ütrüftukafi engün kura mew. ");
INSERT INTO arnNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Fey tati ngen ofadentu ka werküy doy alün küdawfe tati wünelu mew ñi werküel, welu tati pu küdawfe ka femngechi wesa llowfi engün chumngechi ñi wesa llowfiel ta kakelu. ");
INSERT INTO arnNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Feymew ka werküy kisu tañi fotüm, rakiduamkülen: ‘Yamüñmayaenew tañi fotüm engün tati’ pirkey. ");
INSERT INTO arnNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Welu peñmaetew tañi fotüm, tati pu küdawfe welukonkechi feypiwi engün: ‘Fey tüfa tati ngenngetualu. Langümfiyiñ, fey kom müntuñmayafiyiñ tañi ngenngeafel mew.’ ");
INSERT INTO arnNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Feymew nüfi engün, ka nentufi wekuntu tati ofadentu mew, fey langümfi engün. ");
INSERT INTO arnNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Fey tüfa, küpale tati ngenngelu tati ofadentu mew, ¿chumngepayalu ti wesake küdawfe trokifimün kay?” ");
INSERT INTO arnNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Fey llowdungungey: —Langümafi tati wesake che fey tañi pichi kutranduamyenofiel rume, fey arendaltuafi tañi mapu kakelu pu küdawfe tañi eluaetew tañi koneltuleelchi fün ofad puwle tañi kosechangeael. ");
INSERT INTO arnNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Feymew Jesus feypifi ti pu che: —¿Kimlaymün am ñi feypilen tati Wirin Chillka? Feypiley: ‘Tati pu dewmakelu ruka tañi illamelchi kura, fey tüfa ta dullin kurangetuy. Ñidol tañi femkünuel ta tüfa, fey ta afmatuleiñ.’ ");
INSERT INTO arnNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Feymew ta feypiwayiñ eymün ta müntuñmangetuaymün kom pepiluwün Ngünechen tamün elufetew, fey elungeay kangelu che tati ayülu ñi küme llowael Ngünechen ñi longko ülmenngen. ");
INSERT INTO arnNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Fey iney rume trananagpuwle tüfachi küme kura mew, watrokaleweay, welu tüfachi kura trananagle iney rume ñi wente mew, fey rüngüleweay. ");
INSERT INTO arnNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tati pu longkolelu ti pu saserdote mew ka tati pu farisew, allküñmafilu engün Jesus tañi femngechi feypin, küme inaduami engün tañi nütramyemekengen kisu engün tati adkünu dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pürüm ayüfuy engün tañi püresuafiel, welu llükaniefi engün tati pu che, tüfa engün am kiñe fütra pelon wentru trokiniefilu ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus wiñome dunguy re adkünu dungu mew, fey feypi: ");
INSERT INTO arnNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ngünechen tañi longko ülmenngen kiñe longko ülmen reke feley kiñe wentru nielu kiñe kawiñ tañi fotüm ñi mafünngealu. ");
INSERT INTO arnNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Werküfi tañi pu werken tañi amuael engün femngechi ñi yemeafiel tati pu mangel, welu tüfey engün pilay tañi küpayael. ");
INSERT INTO arnNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Fey ka werküy kakelu werken. Fente küme yefaldunguyefi: ‘Feypiafimün tati pu mangel iñche tañi kom dewmaniewiyen ta iyael. Langümfalün tañi ellakechi motrinke kulliñ, ka itrokom pepikaley. Küpape engün tañi fotüm ñi mafün mew.’ ");
INSERT INTO arnNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Welu tati pu mangel müngeltulay engün. Kiñe tüfey engün amuy tañi pemeael tañi mapu, kangelu tripay tañi neosiameael, ");
INSERT INTO arnNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","fey kakelu pu mangel nüfi ti longko ülmen ñi werken tañi kutrankayafiel ka ñi langümafiel kütu. ");
INSERT INTO arnNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Feymew tati longko ülmen rumeñma lladküy, fey werküfi tañi pu soltaw tañi langümafiel ta tiyechi pu langümchefe ka tañi lüpümüñmangeael engün tañi waria. ");
INSERT INTO arnNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Feymew müten feypifi tañi pu werken: ‘Kom pepikaley tati mafünngealu, welu ta tiyechi pu mangel kisu engün pilay tañi küpayael engün. ");
INSERT INTO arnNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Amumün ta rüpü mew chew ñi doy miyawkemum ta che, fey mangelafimün ti mafün mew kom tamün peelchi pu che.’ ");
INSERT INTO arnNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Feymew tati longko ülmen tañi pu werken tripayey engün ta rüpü mew, ka mangelfi itrokom che tañi peel engün tati pu kümeke piwkengelu ka tati pu wesake piwkengelu. Fey tati ruka apoy ti mangelelchi pu che mew. ");
INSERT INTO arnNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Feymew tati longko ülmen konpulu tañi peafiel tati pu mangel, inaduamfi ta kiñe wentru ñi tukunienon ta mafün mew tukukeelchi takuwün. ");
INSERT INTO arnNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Fey feypifi: ‘Weni, ¿chumngechi am konpaymi tüfa mew, fey tami tukunienon mafün mew tukukeelchi takuwün?’ Welu tati wentru dungulay. ");
INSERT INTO arnNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Feymew tati longko ülmen feypifi tati pu poyechemekelu ta mesa mew: ‘Trarifimün. Trariñmangepe tañi namun ka tañi kuwü ka ütrüfentukünufimün ta wekun dumiñkülelu mew, chew tañi ngümayam ka kütrüram tañi foro’ ");
INSERT INTO arnNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","pütrülelu am tati mangelel, welu pichiley tati dullinieel.” ");
INSERT INTO arnNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Fey dew rupalu kom tüfachi dungu, tati pu farisew amuy engün tañi kintukadungumeafiel ta Jesus femngechi tañi welulkawelafiel chem dungu rume feypile. ");
INSERT INTO arnNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Feymew werküngey kiñeke tati kiñewkülelu kisu engün mew, ka Erode tañi küdawelkeetewchi pu che engün, tañi feypimeafiel: —Kimeltufe, iñchiñ kimnieiñ eymi tami ayüken rüf dungu ka tami kimeltuken rüf mew Ngünechen tañi dungu. Ka kimnieiñ tami eluwkenon tami ngünenkayaetew tati pu che, inaduamüñmakenofilu am ta eymi tañi chumngechi mongen ñi nien tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Feypimuiñ may: ¿Chumngentufimi kay? ¿Kümey am tañi kullingeael impuestu ta Sesar, kam kümelay? ");
INSERT INTO arnNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesus kimüñmaeyew tañi wesa rakiduamkülen engün, fey feypieyew: —Koyla ngünenngelu, ¿chumngelu anta kintukaduammupen? ");
INSERT INTO arnNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pengelelmuchi ta kiñe moneda tañi kullingekemum ta impuestu. Kisu engün ta pengelelfi kiñe denario, ");
INSERT INTO arnNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","fey Jesus ramtuy: —¿Iney ñi ange am adentuley ka iney ñi üy wirintukuley ta tüfa mew? ");
INSERT INTO arnNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Fey llowdungungey: —Tati emperador tañi üy ka tañi ange tatey ―pirkey engün. Feymew feypi ta Jesus: —Elufimün tati emperador kisu tañi koneltuleel, ka elufimün ñi koneltuleel ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Fey ti pu che allkülu tüfachi dungu, afmatulewey engün. Fey elkünutufi ta Jesus, fey amutuy engün. ");
INSERT INTO arnNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Feychi mew müten, kiñeke pu sadusew amuy engün ñi pemeafiel ta Jesus. Tati pu sadusew feypikey ñi ngenon tañi wiñomongetuael tati pu layelu, feymew ta nütramkalngepuy ta tüfachi dungu: ");
INSERT INTO arnNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Kimeltufe, Moyse feypi kiñe wentru lale fey ñi nienon fotüm, tañi peñi feley tañi kureyeafiel tañi elelchi lantu domo, femngechi ñi nieael fotüm tañi lachi peñi. ");
INSERT INTO arnNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Fey mülekefuy may iñchiñ mew regle peñiwen. Tati wünen peñi kurengey, fey lay. Fotümngenolu am, elelfi tañi lantu domo tañi peñi inapalu kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ka femngechi femi tati inan wentru, fey ka femngechi tati kangelu inan wentru, ka femngechi kom kureyefi engün ti domo. Tati rüftu inan kütu femi. ");
INSERT INTO arnNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Feymew ka femngechi larpuy tati domo. ");
INSERT INTO arnNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Fey mülefule wiñomongetun, ¿chuchi müngell am tati regle pu wentru kureyetuafi tati domo, dew kom kureyekefulu engün am? ");
INSERT INTO arnNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Feymew llowdunguy ta Jesus, feypilen mew: —Welulkakeymün, tamün kimnon mew tati wirin dungu ka Ngünechen tañi pepiluwün. ");
INSERT INTO arnNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Feychi wiñomongetule ti pu la, ngewelayay ta kureyewün ka elungewelayay rume ta domo ñi fütangeael. Ngünechen tañi wenu mapu müleyechi pu werken püllü reke ta feletuay engün. ");
INSERT INTO arnNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ka tati pu la tañi wiñomongetuken, ¿adümlaymün anta eymün Ngünechen tañi feypin: ");
INSERT INTO arnNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iñche ta Abraam, Isaak ka Jakob tañi Ngünechen’? ¡Fey Ngünechen tati pu lalelu tañi Ngünechen no, welu may tati pu mongelelu tañi Ngünechen! ");
INSERT INTO arnNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Allkülu engün tüfachi dungu, tati pu che rume afmatulewey femngechi ñi kimeltun mew ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tati pu farisew, kimlu engün Jesus tañi ñüküfkünufiel tati pu sadusew, trawüluwi. ");
INSERT INTO arnNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Fey kiñe tati kimeltukelu ta Moyse tañi ley dungu, re ngünen mew, ramtufi ta Jesus: ");
INSERT INTO arnNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Kimeltufe, kom tati ley dungu mew, ¿chuchi werkün dungu am doy kümey? ");
INSERT INTO arnNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Fey feypieyew ta Jesus: “Piwkeyefinge tami Ñidol Ngünechen kom tami piwke mew, kom tami mongen mew, ka kom tami kimün mew.” ");
INSERT INTO arnNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Fey tüfa tati wünen werkün dungu ka doy falilu kom werkün dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Fey tati inalechi werkün dungu ka tüfa famngechi feypiley: “Piwkeyefinge tami chafche chumngechi piwkeyeniewimi ta eymi.” ");
INSERT INTO arnNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Fey tüfachi epu werkün dungu mew ta newentuwküley ta kom tati ley dungu tañi kimeltukeel tati pu pelon wentru. ");
INSERT INTO arnNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Petu tañi trawüluwkülen tati pu farisew, ");
INSERT INTO arnNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesus ta ramtufi ti pu farisew: —¿Chem rakiduamküleymün am tati Cristo mew? ¿Iney am ñi tuwünchengey? Llowdungungey: —David tañi tuwünche. ");
INSERT INTO arnNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Feymew Jesus feypifi: —¿Fey David, dungulu ti Küme Püllü ñi pepiluwün mew, chumngelu am Ñidol pifi kisu ñi yomelchengele? David am ta feypilu: ");
INSERT INTO arnNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ta Ñidol Ngünechen feypifi iñche tañi Ñidol: Anüpange iñche tañi man ad püle, wewfili wüla tami pu kayñe.’ ");
INSERT INTO arnNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Fey ¿tati Cristo David ñi tuwünngele, chumngelu am David ta Ñidol pifi tati Cristo? ");
INSERT INTO arnNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iney rume ta llowdungulaeyew kiñe dungu no rume, fey feychi antü mew ta fentekünuy ñi ramtumekeael engün, ka femngechi iney no rume doy ramtuwelay chem dungu no rume. ");
INSERT INTO arnNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kom rupalu tüfachi dungu, Jesus feypifi tati pu che ka tañi pu disipulu: ");
INSERT INTO arnNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tati pu kimeltukelu tati ley dungu ka tati pu farisew niey engün tañi küdaw ñi kimeltuafiel Moyse tañi ley dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Feymew llemay, feyentufimün ta eymün ka femaymün kom tamün feypingeel, welu inañmakefilmün kisu engün tañi femkeel, kisu engün ta feypikelu am kiñe dungu, welu ka dungu femtukey engün. ");
INSERT INTO arnNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kisu engün ñi kimeltukeelchi dungu rume fanechi küdaw reke feley, fey kakelu che tañi llangka foro mew ta püramelkefi reke engün, welu kisu engün pichi no rume duamkelay ñi mupituafiel ñi kimeltukeelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Itrokom wimtun dungu femkey engün tañi peaetew tati pu che. Ayükey ñi yeael engün ñi tol mew ka ñi lipang mew pichike wirin dungu trarilelu alüke rupachi katrün pañu mew, ka tukukey engün fütrake chiñayngechi takuwün. ");
INSERT INTO arnNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Duamkey engün tañi küme poyetungeael ta iyael mew, ka ayükey engün ñi anüpuael doy kümeke wangku mew tati sinagoga mew, ");
INSERT INTO arnNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ka ayükey engün tañi chaliaetew tati pu che rume yamün mew ta rüpü mew ka tañi Yamfal Kimeltufe ñi pingeael engün. ");
INSERT INTO arnNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Welu eymün eluwkelayaymün Yamfal Kimeltufe tamün piaetew tati pu che, kom eymün am kiñe reñmawen reke felelu ka nieymün kiñe kimeltufe müten, tati Cristo. ");
INSERT INTO arnNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ka iney no rume ta chaw pilayafimün ta tüfachi mapu mew, kiñe nielu müten am ta Chaw ta eymün: tati wenu mapu mülelu. ");
INSERT INTO arnNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ka eluwkelayaymün tamün ñidol pingeael rume, Cristo müten tamün kiñen Ñidol. ");
INSERT INTO arnNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tati wünenkülelu ta eymün mew, fey ta feley tañi poyetuafiel tati kakelu. ");
INSERT INTO arnNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Fey tati kisutu mallmawkülelu, fey ta illamngeay. Fey tati kisutu illamuwkülelu, fey ta yamfalchengeay. ");
INSERT INTO arnNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Awngeaymün ta eymün, pu kimeltukelu tati ley dungu ka pu farisew, pu koyla ngünenngelu! Rakümkefimün ta Ngünechen tañi wenu mapu wülngiñ kisu tañi ülmen mülewe mew tañi konpunoael ta kangelu. Welu eymün rume ta konpukelaymün, ka elukelafimün ñi konpuael ta kakelu che tati ayülu ñi konpuael. ");
INSERT INTO arnNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Awngeaymün eymün, pu kimeltukelu ta Moyse ñi ley dungu ka pu farisew koyla ngünenngelu! Chumngechi rume müntuñmakefimün ñi chemkün tati pu lantu domo, fey tamün küme kimngenoael ngillatukawkeymün. Fey tüfachi dungu mew ta doy fütra kondengeaymün. ");
INSERT INTO arnNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Awngeaymün eymün, pu kimeltukelu ta Moyse ñi ley dungu ka eymün pu farisew, koyla ngünenngelu! Kom mapu mew miyawkelu ka lafken mew tañi kimeltuafiel ta kakelu, fey dew femyüm engün, doy küme amuntukukefi ta che ti kütral mapu mew eymün ta famentuwkeymün. ");
INSERT INTO arnNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Awngeymün ta eymün, pu rüpütultrawmakelu!, tati feypikelu: ‘Iney rume ta wüldungulu kuyalltun mew tati ngillatuwe ruka mew, chem mew rume eluwkelay tañi koneltuael, welu kuyalltule tati oro mew mülelu ta ngillatuwe ruka mew, feymewke ta eluwküley tañi koneltuael.’ ");
INSERT INTO arnNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ngenorakiduam ka trawma! ¿Chem anta doy poyefali: tati oro kam tati ngillatuwe ruka? ¿Tati oro falintufali ñi mülen mew müten tati ngillatuwe ruka mew? ");
INSERT INTO arnNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ka feypikeymün ta eymün: ‘Iney rume ta kuyalltule kiñe eldungu ta ngillatun mew, chem mew rume ta aporia koneltulelay. Welu kuyalltule tati chalintukukeelchi chemkün mew mülelu ta ngillatuwe mew, feymewke ta koneltuley ñi mupituael ñi kuyalltuel.’ ");
INSERT INTO arnNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Trawma! ¿Chem anta doy falintufali: tati mañumtukemumchi chemkün, kam tati ngillatuwe chew tañi chalintukungekemum tati pülata? ");
INSERT INTO arnNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tati kuyalltulu tati ngillatuwe mew, tati ngillatuwe mew müten ta kuyalltulay, welu kom tati mülelu tüfey mew. ");
INSERT INTO arnNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ka tati kuyalltulu tati ngillatuwe ruka mew, tati ngillatuwe ruka mew müten ta kuyalltulay, welu may Ngünechen kuyalltulfi, tati mülelu tüfey mew. ");
INSERT INTO arnNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ka tati kuyalltulu ta kallfü wenu mew, kuyalltumekey ta Ngünechen tañi ülmen mülewe mew, ka femngechi ta Ngünechen mew, tati mülekelu tüfey mew. ");
INSERT INTO arnNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Awngeymün ta eymün, pu kimeltukelu ta Moyse ñi ley dungu ka pu farisew, koyla ngünenngelu! Wichuentulkefimün ta Ngünechen kiñe trokiñ mari puwlu mew tati menta, ka anis ka tati kuminu, welu ngüneduamkelafimün tati doy duamtufalchi dungu mülelu ti ley dungu mew: ñi müleael rüf nor dungu, tamün kutranpiwkeyecheael ka tamün rumel mupituleael kom dungu mew. Fey tüfa feley tamün femael, ka tamün elkünunoafiel ta kangelu dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Eymün, rüpütultrawmakelu, fey chaytukefimün tati pichike pülü, welu lümükefimün ta kiñe kamellu! ");
INSERT INTO arnNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Awngeymün ta eymün, kimeltukelu ta Moyse ñi ley dungu ka pu farisew, koyla ngünenngelu! Eymün ta wekuntu küchalechi fasu reke feleymün, welu ponwitu ta eymün apoleymün re weñen mew, ngünen mew, ka kom wesake dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Trawmalechi farisew! Wünelu mew liftufinge ponwitu tati fasu, fey femngechi ta ka lifkülewetuay wekuntu. ");
INSERT INTO arnNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Awngeymün eymün, pu kimeltukelu ti ley dungu ka pu farisew, koyla ngünenngelu! Fülangkülechi küfwe reke feleymün. Wekuntu rume adküley, welu apoley ponwitu foro la mew ka epe fill wesake pod mew. ");
INSERT INTO arnNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Femngeymün ta eymün: wekuntu ta rume küme piwkengelu kechilekeymün tati pu che ñi adkiñ mew, welu ponwitu apoleymün reke ta re ngünenkachen mew ka wesa femün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Awngeymün eymün, pu kimeltukelu ti ley dungu ka pu farisew, koyla ngünenngelu! Küme eleltukefimün tati pu pelon wentru ñi küfwe ka adelkalkefimün ñi küfwe tati kümeke piwkengefulu em kuyfi mew. ");
INSERT INTO arnNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Feymew ka feypikeymün: ‘Iñchiñ mülekefuliyiñ taiñ kuyfike fütakeche em iñchiñ, kellulayafuiñ engün tañi langümafiel tati pu pelon wentru.’ ");
INSERT INTO arnNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Fey tamün feypiel mew, kimfali tamün langümchefe tuwünngen. ");
INSERT INTO arnNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Eymün amulnieymün tamün femael tamün fütakeche em ñi femkefelchi dungu! ");
INSERT INTO arnNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Eymün ta rume wesa piwkengechi che! ¡Chumkawnorume montuluwlayaymün ti chongnoachi kütral mew! ");
INSERT INTO arnNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iñche ta werküleluwayiñ pelon wentru, rume kimke wentru ka kimeltufe, welu kiñeke tüfey engün tañi werküael, langümafimün ta kürus mew, fey kakelu wülelkangeay sinagoga mew ka kiñeke inantukuyawülngeay kom waria mew. ");
INSERT INTO arnNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Feymew Ngünechen eymün rume fütra kutrankayaeymünmew tañi langümngen mew kom nor piwkengechi pu che. Fey tüfa llituy Abel ñi langümngen mew, fey puwi tati nor mongenngelu Sakaria, Ferekia tañi fotüm, langümngelu tati ngillatuwe ruka ka ti ngillatuwe ñi rangiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Rüf dungu mew feypiwayiñ ta rume fütra kutrankawaymün. ");
INSERT INTO arnNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Jerusalen, Jerusalen mülechi pu che, langümkefilu tati pu pelon wentru ka ütrüftukakefilu kura mew Ngünechen tañi werken! ¡Mufü rupachi küpa ingkaniewfuiñ eymün, chumngechi ta kiñe kude achawall trapümniekey tañi pu pichike achawall tañi miñche müpü, welu pilaymün! ");
INSERT INTO arnNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Feypiwayiñ itrokom tamün waria teyfükangeay. ");
INSERT INTO arnNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tüfa ka feypiwayiñ: wiñome pemuwelayan feypingele wüla tüfachi dungu: ‘¡Püramyengepe tati küpalelu Ñidol Ngünechen mew!’ ” ");
INSERT INTO arnNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus tripatulu ta ngillatuwe ruka mew, ka dew amuletulu, fey ñi pu disipulu fülmaeyew. Fey rumeñma afmatufi engün chumngechi ñi dewkülen tati ngillatuwe ruka. ");
INSERT INTO arnNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesus feypieyew engün: —¿Pefimün am eymün kom ñi chumlen tüfachi ngillatuwe ruka? Rüf dungu feypiwayiñ, fey tüfachi ngillatuwe ruka mew ta ngewelayay kiñe kura no rume welu rentrolealu. Kom teyfükangeay. ");
INSERT INTO arnNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Feymew ka amuy engün ti Olifu pingechi wingkul mew. Jesus anükünuwpuy, fey tati pu disipulu fülkontueyew tañi wichu ramtuaetew: —Duamnieiñ tami feypimuafiel chumül tañi rupayael ta feychi dungu. ¿Chem wele dungu am müleay ta wiñometualmi ka afale ta tüfachi mapu? ");
INSERT INTO arnNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus ta llowdungufi ñi pu disipulu: —Kuñiwtuwküleaymün iney rume tamün ngünenkanoaetew. ");
INSERT INTO arnNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Rume fentren che küpayay ‘iñche tati Montulchefe’ pialu. ‘Iñche ta Cristo’ piay engün, fey rume fentren che ta ngünenkayafi engün. ");
INSERT INTO arnNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Eymün kimaymün ñi müleael ta awkan dungu kom wall mapu püle, welu llükalekilmün. Femngechi feley tañi femael, welu petu akulayay ti afachi antü. ");
INSERT INTO arnNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","“Kiñe trokiñ mapu ta weychayalu kangelu trokiñ mapu engu ka fütra trokiñ mapu weychayay kangelu fütra trokiñ mapu engu. Ka müleay ta ngüñün, ka müleay nüyün fill trokiñke mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kom feychi dungu ta mülele, fey ta we llitun müten kom kutrankawün ñi müleael. ");
INSERT INTO arnNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Feymew chalintukungeaymün ta eymün tamün kutrankangeael, ka langümngeaymün, ka kom che ta üdeaeymünmew iñche tañi duam. ");
INSERT INTO arnNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Feychi antü mew rume fentren che elkünutuay tañi feyentulen ta Ngünechen mew, ka üdeway engün ka welukonkechi ngünenmaway engün. ");
INSERT INTO arnNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ka fentren koyla pelon wentru pewfaluway, fey fentren che ngünenkayafi engün. ");
INSERT INTO arnNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Müleay fentren wesake dungu, fey rume fentren che ta niewetulayay piwkeyechen. ");
INSERT INTO arnNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Welu kom tati newenkülelu Ngünechen ñi dungu mew tuntepule ñi mongen, fey ta montuay. ");
INSERT INTO arnNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Fey tüfachi küme kimelün dungu wenu mapu nagpalu kimelngeay ta kom chüf mapu, femngechi kom trokiñke mapu mew mülechi pu che tañi kimael Ngünechen ñi dungu. Fey wüla akuay ñi afael ta antü. ");
INSERT INTO arnNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Fey ti pelon wentru Daniel wirintukuy ñi müleael rume wesa dungu, fey pefilmün Ngünechen ñi kayñe ñi fill wesa meken ti ngillatuwe ruka mew ―tati chillkatulu, ngüneduampe―, ");
INSERT INTO arnNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","feymew tati pu che mülelu Judea trokiñ mapu mew, lefmawpe engün fütrake wingkul mew. ");
INSERT INTO arnNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ka tati mülelu wekuntripa tañi ruka mew, wiñokontukilpe tañi yemetuael chem no rume. ");
INSERT INTO arnNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ka tati mülelu lelfün mew, wiñokontukilpe ñi ruka mew tañi yemetuael tañi takun no rume. ");
INSERT INTO arnNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Awngey tati pu domo tiyechi antü mew niepüñeñkülele kam niele moyol püñeñ! ");
INSERT INTO arnNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ngillatuafimün ta Ngünechen tamün lefmawnoael ta pukem antü mew kam ürkütun antü mew no rume, ");
INSERT INTO arnNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","mülealu am ta rume fütra kutrankawün. Chumkawnorume mülekelay femngechi kutrankawün ka turpu mülewelayay rume. ");
INSERT INTO arnNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ngünechen elunofile pichiñmayael ta tüfachi kutrankawün, iney rume ta montulayafuy, welu pichiñmayay tañi piwkeyefiel mew kisu tañi dullintunieelchi pu che. ");
INSERT INTO arnNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Fey iney rume feypielmünmew: ‘Allkütumün. Tüfa tañi mülen tati Cristo’, kam feypielmünmew: ‘Allkütumün. Tiye tañi mülen’, feyentukefilmün. ");
INSERT INTO arnNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Fey küpayalu am tati koylake Cristo ka koyla pelonke wentru, fey pengelay engün fütrake afmatufal dungu ka pepiluwün tañi ngünenkacheael, tañi ngünenkayafiel Ngünechen tañi dullielchi pu che kütu. ");
INSERT INTO arnNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dew kom kimelkünuwiyiñ ta eymün petu tañi ngenon feychi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Feymew ta feypingelmün: ‘Allkütumün. Tiye tañi mülen uwe mapu mew’, wütukefilmün. Ka feypingelmün: ‘Allkütumün. Tüfa tañi mülen’, feyentukefilmün. ");
INSERT INTO arnNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kiñe llüfkeñ reke tati pengekelu tañi wilüfün tripawe antü püle kam konwe antü püle, femngechi femay wiñometule tati Wentrukünuwpalu. ");
INSERT INTO arnNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Chumngechi ñi feypingeken: Chew mülele tati la, fey mew trawüluway tati pu kanin. ");
INSERT INTO arnNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Fey rupale müten ta tiyechi kutrankawün antü, ‘tati antü ta dumiñnagay, küyen ta pelontuwelayay, wangülen ta ütrüfnagpayay ta wenu ka tati wenuleyechi newen kom nengümay.’ ");
INSERT INTO arnNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Feymew ta wenu mew pengeay tati Wentrukünuwpalu tañi afmafal dungu. Ka kom chüf mapu müleyechi trokiñche rume llükayay ka ngümayay, peafilu engün am tati Wentrukünuwpalu küpalelu ta wenu tromü mew kom newen mew ka fütra afmatufalchi pepiluwün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Fey kisu werküay tañi pu werken püllü ñi newentu dungulngeael tati kullkull, femngechi ñi trawüluwael tañi dullielchi pu che küpalu tati meli witran mapu püle. ");
INSERT INTO arnNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kimafimün tati anümka igera mew inayentulechi kimeltun: petu pewüyüm tañi tapül, ngüneduamkeymün ta eymün tañi fülkülepan dewma ta walüng antü. ");
INSERT INTO arnNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ka femngechi, pefilmün kom tüfachi dungu, kimaymün tañi püllelepan ñi akuael tati Wentrukünuwpalu. ");
INSERT INTO arnNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Rüf dungu feypiwayiñ ta kom feychi dungu ta müleay petu tañi layenon tati pu che mülelu ta fantepu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Wenu mapu ka nag mapu ta ngewetulayay, welu iñche tañi dungu chumkawnorume katrütungelayay. Itrokom mupiay tañi chem pilen. ");
INSERT INTO arnNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Welu iney rume kimlay ti antü ka tati ora ñi rupayael tüfachi dungu, tati wenu mapu müleyechi werken püllü no rume, tati Fotüm no rume. Tañi Chaw müten ta kimniey. ");
INSERT INTO arnNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Fey chumngechi rupay ti dungu feychi mongelelu ta Noe, ka femngechi rupayay ti dungu wiñometule Ngünechen ñi Fotüm Wentrukünuwpalu. ");
INSERT INTO arnNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Feychi tripantu mew petu ngenolu tati fütra tripakon, tati pu che ikawmekey ka putumekey ka kureyewmekey engün. Fey konlu wüla ta Noe tañi wampo ruka mew, fentepuy engün ñi fill meken. ");
INSERT INTO arnNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Welu petu tañi chem rakiduamkülenon engün, akuy tati tripakon, fey kom ürfi engün. Ka femngechi femay ta wiñometule Ngünechen ñi Fotüm tati Wentrukünuwpalu. ");
INSERT INTO arnNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Feychi antü ta epu wentru müleay ta lelfün mew. Kiñe ta yengetuay, fey kangelu elkünungeay. ");
INSERT INTO arnNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Epu domo ta mekeay tañi mürken. Kiñe ta yengetuay, fey kangelu ta elkünungeay. ");
INSERT INTO arnNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Trepeluwkülemün reke ta eymün, kimnolu am ta eymün chem ora ñi akuael tamün Ñidol. ");
INSERT INTO arnNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Welu ngüneduamfimün tüfachi adkünu dungu: tati ngen ruka kimfule tuntepun ñi akuael ti weñefe, trepeluwküleafuy ka elulayafuy iney rume tañi konpuael ñi ruka mew tañi weñeaetew. ");
INSERT INTO arnNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Feymew, eymün ka feley tamün pewütuwküleael, tati Wentrukünuwpalu am küpayalu fey tañi üngümniengenon rume. ");
INSERT INTO arnNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Fey kiñe ülmen wentru niele kiñe küme pewütuwkülechi kona ka küme rakiduam nielu, fey tüfa elfalkünuafuy kom tañi nieel ruka mew, femngechi tañi eluaetew iyael puwle tañi imetuael. ");
INSERT INTO arnNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Fey ayüwünngey tati küme kona, fey akutuyüm tañi poyekeelchi ülmen, pepatueliyew ñi kom dewman ñi elulngeelchi küdaw. ");
INSERT INTO arnNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Rüf dungu feypiwayiñ tañi ülmen elfalkünuaeyew kom tañi nieelchi kümeke chemkün. ");
INSERT INTO arnNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Welu kangelu kona wesa wimtun nielu, ka rakiduamlu ñi pürüm wiñomenoael tañi ñidol, ");
INSERT INTO arnNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","fey eluwle ñi kutrankayafiel kakelu kona, ka trawüle tañi iyael ka ñi putuael ti pu ngollife engün, ");
INSERT INTO arnNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","fey tañi üngümnienoelchi antü mew ka ñi kimnoelchi ora mew, akutuay tañi ñidol. ");
INSERT INTO arnNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Fey tüfachi wesa kona kutrankangeay, ka kondenangeay, fey femngechi wesa üllüfay tati pu koyla ngünen che reke. Feymew ta ngümayay ka kütrüray tañi foro. ");
INSERT INTO arnNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Fey tati pu che üngümkülelu Ngünechen tañi longko ülmenkületuael kisu engün mew, fey ta femngechi adentuley tati mari üllchake domo reke, mangelkülelu ñi amuael kiñe mafün mew. Kake kiñeke nüniey engün tañi pelontuwe üykelu ta aseyte mew, fey tripay engün tañi llowmeafiel tati nofio. ");
INSERT INTO arnNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kechu tati üllchake domo pepikawkülerkelay, fey ka kechu küme pepikawkülerkey aseyte mew tañi pelontuwengealu. ");
INSERT INTO arnNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tati pepikawkülenolu yeniey engün tañi pelontuwe, welu yelay ta aseyte engün tañi ka wiñome apoltuafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Fey tati küme pepikawkülelu yeniey engün tañi pelontuwe ka kiñe fotilla aseyte, tunte dew yeniefuy engün rume tañi pelontuwe mew. ");
INSERT INTO arnNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Fey tati nofio am pürüm akunolu, kom küpa umawtuy engün, feymew umawnagi engün. ");
INSERT INTO arnNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Epe rangi punlu, allküngey ñi wirarün: ‘¡Dew küpaley tati nofio! ¡Tripamün tamün llowafiel!’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Fey kom tati üllchake domo witrafemi engün, fey eluwi tañi üyümael engün tañi pelontuwe. ");
INSERT INTO arnNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Feymew tati kechu pepikawkülenolu ñi nieael aseyte feypifi engün tati kechu pepikawkülelu: ‘Pichikelmuiñ eymün tamün nieelchi aseyte. Iñchiñ taiñ pelontuwe chongmekey.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Welu tati pepikawküleyechi pu üllchadomo llowdunguy engün: ‘Pilaiñ. Eluwliyiñ taiñ aseyte, müte pichileweafuy iñchiñngealu ka eymünngealu. Doy kümey tamün amuael chew tañi fendengekemum, fey ngillamün ta eymünngealu.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Welu petu amulelu tiyechi kechu üllchake domo tañi ngillameael aseyte, fey akuy tati nofio. Feymew tati pepikawküleyelu konpuy ta kisu engün tati mafün mew, fey rakümkünungey tati wülngiñ. ");
INSERT INTO arnNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Feymew wüla akutulu tati kakelu üllchake domo, feypi engün: ‘¡Ñidol, Ñidol, nülalmuiñ ta wülngiñ!’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Welu kisu ta llowdungufi: ‘Rüf dungu mew kimuwlaiñ tamün ineyngen.’ ” ");
INSERT INTO arnNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Feymew amul feypi ta Jesus: “Eymün feley tamün trepewküleael reke, kimnolu am eymün tati antü ka ti ora no rume ñi wiñometuael tati Wentrukünuwpalu. ");
INSERT INTO arnNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ka femngechi Ngünechen tañi longko ülmenngen ta kiñe ülmen wentru reke feley tati epe puwkülelu tañi amutuael kangelu fütra trokiñ mapu mew. Fey mütrümi tañi kellunieyeetewchi pu kona ka feypifi tañi neosialaetew tañi pülata. ");
INSERT INTO arnNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kiñe ta tüfey engün elufi kechu moneda rume falilu, kangelu elufi epu moneda, fey ka kiñe elufi kiñe moneda müten, kake kiñeke chumngechi tañi adümuwün engün. Feymew wüla tripay. ");
INSERT INTO arnNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Fey ti küdawfe llowlu kechu moneda, neosiay tati pülata mew, fey wewi ka kechu moneda. ");
INSERT INTO arnNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ka femngechi femi tati llowlu epu moneda, fey wewi ka epu moneda. ");
INSERT INTO arnNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Welu tati llowlu kiñe moneda, fey amuy tañi rüngalafiel ñi pülata. ");
INSERT INTO arnNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Fey rupalu fentren tripantu, wiñotuy ta tiyechi pu kona tañi ülmen wentru, feymew eluwi tañi rakiael ka ñi wiñoleltuafiel ti pülata. ");
INSERT INTO arnNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“Wünelu mew akuy tati llowlu ti kechu moneda, fey elutufi tati ülmen wentru ka kechu moneda tañi wewel feypilen mew: ‘Ñidol, eymi eluen kechu moneda. Fey tüfa tami nien ka kechu moneda tañi wewel.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tati ülmen wentru ta feypieyew: ‘Müna kümekünuymi. Eymi ta rume küme kona, fey rume küme puwtunngeymi. Dew am küme puwtulelu eymi pichin mew, doy fentren ta elfalkünuaeyu. Konpange. Kiñentrür nieayu ayüwün.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Feymew ka akuy tati kangelu kona ti llowlu epu moneda, ka feypi: ‘Ñidol, epu moneda eluen nga, fey tüfa tami nien ka epu moneda iñche tañi wewel.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tati ülmen ta feypieyew: ‘Rume kümey. Rume küme kona ta eymi ka külfün wentru ta eymi. Dew am küme femlu eymi pichin mew, doy alün pülata ta elfalkünuaeyu. Konpange ka kiñentrür nieayu ayüwün.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Welu akulu tati kona ti llowlu kiñe moneda, feypifi tañi ülmen: ‘Ñidol, iñche ñi rakiduam mew femngentun eymi tami yafü piwke wentrungen. Kosechakeymi chew tami ngannoel mew ka ñimitukeymi chew tami widpünoel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Feymew llükan, fey amun tañi rüngalafiel tami pülata kiñe lolo mew. Welu tüfa tami pülata.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Fey llowdungueyew tati ülmen wentru: ‘Eymi ta wesa chofü küdawfe. Fey femngechi rakiduamürkelu am eymi iñche tañi yafü piwkengen ka tañi kosechaken chew tañi ngannoel mew ka ñi nentuken chew tañi küdawnoel mew, ");
INSERT INTO arnNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿chumngelu am elelmelaen tañi pülata banku mew? Fey iñche, akutuli, llowpatuafun tañi pülata banku mew ka tañi pichike wewel kütu.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ka feypiyefi ti müleyelu tüfey mew: ‘Müntuñmafimün tañi kiñe moneda, fey elufimün tati nielu mari moneda. ");
INSERT INTO arnNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tati küme küdawyefilu tañi nieel, doy elungeay, fey doy alün nieay, welu tati küme küdawyenolu tañi nieel, tañi pichi nieel kütu ta müntuñmangetuay. ");
INSERT INTO arnNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Fey tüfachi ngenokim küdawfe, wekun entufimün dumiñ mew, chew tañi ngümayam ka kütrüram tañi foro.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Feychi wiñometule tati Wentrukünuwpalu, walloñmanieaeyew ta pelon ka kom tañi pu werken püllü, fey anüay tañi afmafalchi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kom chüf mapu mülechi pu che ta trawüluway kisu tañi adkiñ mew, fey püntünentuafi kiñeke che ti kakelu mew, chumngechi tati ufisakamañ püntünentukefi ta ufisa tati pu kapüra mew. ");
INSERT INTO arnNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tati pu ufisa tañi man püle elkünuafi, fey tati pu kapüra tañi wele püle. ");
INSERT INTO arnNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Fey tati longko ülmen feypiafi tati müleyelu tañi man püle: ‘Küpamün ta eymün, tüfey tañi Chaw ñi füreneyeetew. Llowaymün tati ülmen mülewe pepikalelu llituka mew müten eymünngealu, feychi Ngünechen dewmafilu tüfachi mapu. ");
INSERT INTO arnNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Feychi ngüñülu iñche, eymün elumun ta iyael. Ka femngechi wüywülu iñche, elumun ko ñi pütokoael. Ka penolu ñi umañtuam ta iñche, elumun ñi umañtuael tamün ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nienolu takuwün iñche, fey eymün elumun. Kutrankülelu iñche, ka witrankontumumen. Karsel mew mülelu iñche, ka küpaymün tamün pemupayafiel.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Feymew tati pu nor piwkengelu ramtuaeyew engün: ‘¿Ñidol, chumül am pewkeyiñ tami ngüñüyawün, fey eluwiyiñ ta iyael? ¿Kam chumül am pewkeyiñ tami wüywüyawün, fey ka eluwiyiñ ko tami pütokoael? ");
INSERT INTO arnNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Kam chumül anta pewkeyiñ tami nienon tami umañtuam, ka eluwiyiñ tami umañtuael, ka tami nienon takuwün ka eluwiyiñ? ");
INSERT INTO arnNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ka chumül anta kutrankülekeymi kam karsel mew püresulekeymi, ka amuiñ tami pewmeafiel?’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Fey tati longko ülmen ta llowdunguay: ‘Rüf dungu ta feypiwayiñ kom tamün femel kiñeke tüfa engün mew iñche tañi pu peñi doy duamlu ñi kellungeael, iñche ta fürenemun.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ka feymew müten tati longko ülmen feypiafi tati pu che müleyelu tañi wele püle: ‘Püntütripamün iñche mew, eymün tati müleyelu malisian dungu mew. Amumün chumkawnorume chongkenochi kütral mew pepikalelu ta weküfüngealu ka kisu ñi pu werken engün. ");
INSERT INTO arnNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Feychi ngüñülelu iñche, eymün elumulan iyael. Ka femngechi wüywülelu iñche, elumulan ko ñi pütokoael. ");
INSERT INTO arnNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Penolu iñche ñi umañtuam, ka elumulan tañi umañtuael tamün ruka mew. Nienolu takuwün iñche, eymün elumulan. Kutrankülelu iñche, ka mülelu karsel mew, witrankontumulan.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Feymew kisu engün ramtuaeyew: ‘Ñidol ¿chumül am pewkeyiñ tami ngüñülen kam tami wüywülen, kam tami pekenon tami umañtuam, kam tami nienon takuwün, kam tami kutranküleken, kam tami karsel mew müleken, fey kelluwlayiñ?’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Fey tati longko ülmen llowdunguay: ‘Rüf dungu feypiwayiñ kom tamün femnofiel kiñeke tüfachi kuñifall pu che mew, iñche mew ta ka femmulan.’ ");
INSERT INTO arnNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Fey engün tañi wele püle mülelu, amuay ti rumel kutrankawün mew, ka tati pu nor piwkengelu ti rumel mongen mew.” ");
INSERT INTO arnNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Rupan feypilu kom tüfachi dungu, Jesus feypifi tañi pu disipulu: ");
INSERT INTO arnNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Eymün kimnieymün, epu antü rupale müleay tati Paskua kawiñ antü, fey tati Wentrukünuwpalu chalintukungeay tañi langümngeael kürus mew.” ");
INSERT INTO arnNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nütramkamekelu ta Jesus tüfachi dungu, ka feychi antü mew müten, tati pu longkolelu ti pu saserdote mew ka ti pu longkolelu ti pu judiu mew trawüluwi engün Kayfas tañi ülmen ruka mew, tati Wünen Longko Saserdote. ");
INSERT INTO arnNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Trawüluwi ñi nütramkawael engün chumngechi tañi püresuafiel ta Jesus kiñe ngünen dungu mew, ka ñi langümafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Welu feypirkey engün: “Tati kawiñ antü mew no, tañi fill wesa femmekenoael tati pu che.” ");
INSERT INTO arnNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mülepulu Jesus ta Betania waria mew, Simon tañi ruka mew, tati leproso pikeel, ");
INSERT INTO arnNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","feymew kiñe domo küpalnielu kiñe fotilla perfume, rume falilu, fülkontupafi ta Jesus. Petu tañi anülen ta Jesus inafül mesa, fey ti domo wütrunagümfi tati perfume Jesus ñi wente longko. ");
INSERT INTO arnNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tati pu disipulu pefilu engün, lladküy ka eluwi tañi feypiael engün: —¿Chumngelu anta ngünamkangey ta tüfachi perfume? ");
INSERT INTO arnNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Fentren pülata mew fendengeafuy tati, tañi kellungeael tati pu pofre. ");
INSERT INTO arnNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus ta allküy, fey feypieyew engün: —¿Chumngelu anta filladtupefimün ta tüfachi domo? Fey tüfa tañi femetew mew rume kümelkaenew tati. ");
INSERT INTO arnNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tati pu pofre rumel müleay eymün mew, welu iñche ta rumel niemulayan. ");
INSERT INTO arnNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tüfachi domo tukulelpeenew perfume tañi kuerpu mew, femngechi tañi pepikañmaetew tañi kuerpu tañi rüngalngeael. ");
INSERT INTO arnNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Rüf dungu feypian chem trokiñ mapu mew rume kam chüf mapu mew chew wewpiyengele tüfachi montuluwün dungu, ka nütramyengeay tañi femün ta tüfachi domo. Ka femngechi tukulpangeay. ");
INSERT INTO arnNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kiñe tati mari epu disipulu, tati Juda Iskariote pingelu, amuy tañi pemeafiel tati pu longkolelu tati pu saserdote mew, ");
INSERT INTO arnNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","fey feypifi: —¿Tunten pülata anta elumuafun kay? Fey iñche chalintukuleluwafuiñ ta Jesus ―pi. Fey kisu engün feypi ñi tunte wülael: —Küla mari moneda pülata ―pingey. ");
INSERT INTO arnNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Feychi mew müten ta Juda rakiduamkiyawkefuy chumngechi tañi ellka wültukuafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Fey wüne llituelchi antü tati kawiñ mew ñi ingekemum tati lefawrangenochi kofke, tati pu disipulu fülkonpuy ta Jesus mew, fey ka ramtufi engün: —¿Chew anta küpa pepikalngeymi tati pun iyael? ");
INSERT INTO arnNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Fey Jesus ta llowdungueyew: —Amumün ta waria mew, kiñe wentru tañi ruka mew, fey feypiafimün: ‘Tati kimeltufe ta feypi: Fülpay tañi ora, fey amuan tami ruka mew tañi kiñentrür ayüwael ti Paskua kawiñ mew tañi pu disipulu iñchiñ.’ ");
INSERT INTO arnNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tati pu disipulu femi chumngechi tañi werküetew ta Jesus, fey pepikapuy engün tati ilelkawün Paskua kawiñ. ");
INSERT INTO arnNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Feymew dew punlu, Jesus müley inafül mesa tañi mari epu disipulu engün. ");
INSERT INTO arnNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Fey petu ilu engün, Jesus feypirumefi tañi pu disipulu: —Rüf dungu feypiwayiñ kiñe ta eymün ellka wültukuaenew. ");
INSERT INTO arnNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Fey kisu engün rume weñangkülewey, feymew kake kiñeke ramtuy engün: —Ñidol, ¿iñche pemay? ");
INSERT INTO arnNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus ta feypi: —Tati ifontukulu tañi kofke iñche engu, fey ta ellka ngünenmayaenew. ");
INSERT INTO arnNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Fey tati Wentrukünuwpalu feley tañi layael chumngechi tañi feypilen tati Wirin Chillka, welu ¡awngeay tañi ellka wültukuaetew! Doy kümeafuy tañi choyüngenoafel ta tüyechi wentru. ");
INSERT INTO arnNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Feymew Juda, tañi ngünenmanieetew, ramtueyew: —Kimeltufe, ¿iñche am tati? —May, eymi tati ―pi ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Fey petu ilu engün, Jesus nüy tañi kuwü mew ta kofke. Fey rupan mañumtufilu ta Ngünechen, wükafi ti kofke. Fey ka eluyefi tañi pu disipulu, feypilen mew: —Imün tüfa ta iñche tañi kuerpu. ");
INSERT INTO arnNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Feymew müten ka nüy kiñe kopa tañi kuwü mew. Fey rupan mañumtufilu ta Ngünechen, fey eluyefi ta kisu engün, feypilen mew: —Kom eymün putumün ta tüfachi kopa mew. ");
INSERT INTO arnNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Fey tüfa ta iñche tañi mollfüñ ka müten, fey tüfa mew rüf dungu mew mupiay tati we eldungu. Fey tañi mollfüñ wütrulngealu ñi fürenengeael ta che femngechi ta Ngünechen ñi wiñoduamatuafiel ta che tañi yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Welu feypiwayiñ tañi putuwenoafiel ta tüfachi pulku tripalu ofad mew, putuali wüla eymün iñchiñ tati we pulku iñche tañi Chaw ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Fey rupan ülkantulu engün kiñeke salmo, amuy engün tati Olifu pingechi wingkul mew. ");
INSERT INTO arnNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Feymew Jesus ta feypi: —Fey tüfachi pun kom eymün ta niewetulayaymün maneluwün ta iñche mew. Femngechi feypiley tati Wirin Chillka: ‘Langümafiñ tati kamañ. Fey tati pu ufisa kom püd tripayay engün.’ ");
INSERT INTO arnNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Welu iñche wiñomongetuli, amuan ta Galilea petu tamün amunon ta eymün. ");
INSERT INTO arnNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Fey Pedro ta llowdungueyew: —Tunte kom elkünutuay engün rume tañi maneluwün eymi mew, welu iñche femlayan. ");
INSERT INTO arnNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus feypifi ta Pedro: —Rüf dungu feypiaeyu ta tüfachi pun müten, petu ñi kakaranon ta alka ‘kimlafiñ’ piaymi ta küla rupachi. ");
INSERT INTO arnNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro ta feypieyew: —Tunte layan rume eymi iñchiw, ‘kimlafiñ’ pilayan. Fey kom tati pu disipulu ka femngechi feypi engün. ");
INSERT INTO arnNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Feymew müten amuy ta Jesus tañi pu disipulu engün Getsemani pingechi lelfün mew, fey feypifi tañi pu disipulu: —Mülewemün tüfa mew. Iñche amuan tiye mew tañi ngillatuael. ");
INSERT INTO arnNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Feymew yefi ta Pedro ka Sefedew tañi epu fotüm, feymew rume weñangkünagi ka yafüngewelay. ");
INSERT INTO arnNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Fey feypifi tañi pu disipulu: —Landuam weñangkülen tañi piwke mew. Mülewemün eymün tüfa mew, ka trepelemün iñche eymün. ");
INSERT INTO arnNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Feymew müten Jesus doy pichi wüneluwi üyew püle. Lloyünagi ka küme idapuy pülli mew tañi tol, fey famngechi ngillatuy: “Iñche ñi Chaw, pifulmi, montulaen tüfachi fütra kutrankawün mew, welu felekilpe iñche tañi ayüel, eymi tami ayüel mayfe.” ");
INSERT INTO arnNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Feymew müten küpatuy chew ñi mülemum tañi pu disipulu, fey pepatufi ñi umawkülen. Fey feypifi ta Pedro: —¿Kiñe ora rewall anta pepi trepelelaymün? ");
INSERT INTO arnNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Trepelemün, ka ngillatulemün, tamün wewnoaetew tati kintukaduamchekelu. Eymün ta ayülefuymün tamün yafüluwküleael, welu tamün kuerpu yafüngelay. ");
INSERT INTO arnNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Feymew epuchi mew püntütripay, fey famngechi ngillatupuy: “Iñche ñi Chaw, ngenole tami famentuafiel iñche ñi kutrankawael tüfachi kutrankawün mew, felepe may eymi tami ayüel.” ");
INSERT INTO arnNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Fey wiñomelu, ka pepatufi ñi umawkülen tati pu disipulu, tañi nge am kisutu umernagmekelu engün fente tañi küpa umawtun. ");
INSERT INTO arnNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Fey elkünufi ti pu disipulu ka amuy ñi ngillatuael küla rupachi, ka tukulpaniefi tañi wünelu mew ngillatukeelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Feymew wiñotuy chew tañi mülemum tati pu disipulu, fey feypifi: —¿Amukonküley tamün umawkülen ka tamün kansatulen? Akuy tati ora tañi chalintukungeael tati Wentrukünuwpalu tati pu yafkafe wentru mew. ");
INSERT INTO arnNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Witrapüramün. Amutuiñ. Dewma fülpay tañi ngünenmayaetew. ");
INSERT INTO arnNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Feymew petu tañi dungumeken ta Jesus, fey Juda, kiñe tati mari epu disipulu, akuy kompañuwkülen fentren che engün pepikawkülelu fütrake kuchillu mew ka mamüll mew. Tüfa engün ñi werküel tati pu longkolelu tati pu saserdote mew ka tati putrem pu judiu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Fey tati ngünenmachefe Juda, adkünurkey chumngechi ñi femael, feypilen mew: “Fey iñche tañi truyuel, fey tati. Püresuafimün.” ");
INSERT INTO arnNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Feymew, fülkonpalu ta Jesus mew, feypi: —¡Pun may, kimeltufe! Fey truyufi. ");
INSERT INTO arnNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus feypieyew: —Weni, femnge müten tami ayüelchi dungu. Feymew tati kakelu fülkonpuy, fey nüfi engün ta Jesus tañi püresuafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Feymew, kiñe tati mülekelu Jesus engün entupay tañi wayki, fey katrünentuñmafi ñi kiñe pilun tati Wünen Longko Saserdote tañi kona. ");
INSERT INTO arnNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus ta feypieyew: —Üchaftukutunge tami wayki chew tami niekefimum. Kom tati langümchekelu ta wayki mew, ka femngechi langümngeay ta wayki mew. ");
INSERT INTO arnNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Kimlaymi am tañi ngillatuafel ta iñche tañi Chaw, fey kisu ta werkülelafenew fewla müten doy mari epu trokiñ werken püllü? ");
INSERT INTO arnNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Welu femfuli, ¿chumngechi am mupiafuy tañi feypilen tati Wirin Chillka, feypilelu tañi femngechi felerpuael? ");
INSERT INTO arnNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Feymew müten Jesus ramtuyefi tati pu che: —¿Chumngelu anta küpalnieymün ta wayki ka mamüll tamün püresumuafiel iñche ta kiñe malochefengelu reke? Fill antü ta kimeltumekeken ta ngillatuwe ruka mew, welu turpu püresumukelafun. ");
INSERT INTO arnNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Welu kom tüfachi dungu ta feley ñi mupituael ñi piel tati pu pelon wentru tati Wirin Chillka mew. Feymew müten, kom tañi pu disipulu kisukünueyew ka lefmawi engün. ");
INSERT INTO arnNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tati pu che püresufilu ta Jesus, yefi engün Kayfas tañi ruka mew, tati Wünen Longko Saserdote, chew tañi trawüluwkülemum tati pu kimeltukelu ta Moyse ñi ley dungu ka tati pu putrem fütake judiu. ");
INSERT INTO arnNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro inanieeyew alü kamapu, fey puwi tati Wünen Longko Saserdote tañi lepün ruka mew. Feymew konpuy, ka anükünuwpuy tati llüwatulekelu engün tati ngillatuwe ruka mew tañi ngüneduamafiel ñi chumngeael ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Fey tati pu longkolelu tati pu saserdote mew ka kom tati putremke judiu kintukadungulelfi engün kiñe koyla dungu tañi kondenangeael ka ñi langümafiel engün ta Jesus, ");
INSERT INTO arnNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","welu pelay engün. Akuyefuy rume fentren che tañi feypintukupayaetew re koylake dungu mew, welu kiñe no rume kiñewlay engün tañi feypintukupaelchi dungu mew. Feymew wüla akuy epu wentru, ");
INSERT INTO arnNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","fey kiñewün feypikonpay engu: —Fey tüfachi wentru ta feypi: ‘Iñche ta teyfüafuiñ ta Ngünechen ñi ngillatuwe ruka ka dewmatuafuiñ küla antü mew.’ ");
INSERT INTO arnNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Feymew tati Wünen Longko Saserdote witratripay, ka ramtufi ta Jesus: —¿Chem llowdungulaymi rume? ¿Chem dungu anta tüfa tami femngechi feypintukumekengen? ");
INSERT INTO arnNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Welu Jesus chem pilay rume. Feymew tati Wünen Longko Saserdote feypifi ta Jesus: —Tati rumel mongelekechi Ngünechen tañi üy mew werküaeyu tami feypiael ta rüf dungu. Feypimuiñ rüf mew eymingen tati Cristo, Ngünechen tañi Fotüm. ");
INSERT INTO arnNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus ta llowdungueyew: —May, eymi tami feypipeel rüf dungu tati. Iñche ta feypiwayiñ kay eymün tamün pemuafiel tati Wentrukünuwpalu tañi anülen tati kom pepiluwünngechi Ngünechen ñi man püle, ka tañi wiñometuael wenu mapu kiñe tromü mew. ");
INSERT INTO arnNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Feymew tati Wünen Longko Saserdote wikürkay tañi takuwün ñi kimngeael tañi rume lladkün, fey feypi: —¡Tüfachi wentru tañi dungun mew notukafi ta Ngünechen! Chem dungu rume duamtuwelaiñ tañi feypintukungeael. ¡Eymün allküñmafimün tañi wesa notukafiel ta Ngünechen ñi dungun mew! ");
INSERT INTO arnNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Chumngentufimün kay? Fey kisu engün llowdunguy: —Feley tañi langümngeael. ");
INSERT INTO arnNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Feymew tofkütuñmangey ñi ange ka wülelkangey. Kakelu wülelmafi ta Jesus ñi ange, ");
INSERT INTO arnNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ka feypiniengey: —Eymi tati Cristongelmi, ¡feypimuiñ iney tami wüleletew! ");
INSERT INTO arnNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Fey Pedro anülerkey wekuntu, tati lepün mew. Feymew, kiñe üllchadomo küdawkelu ti ruka mew, fülkontueyew, fey feypieyew: —Eymi ta ka miyawkeymi ta Jesus eymu, tati wentru Galilea tuwlu. ");
INSERT INTO arnNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Welu Pedro kom che ñi adkiñ mew, feypi: —Kimlan chem dungu tami feypipefiel. ");
INSERT INTO arnNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Feymew müten wülngiñ püle witrakünuwpuy, fey tüfey mew peeyew kangelu domo, fey feypi: —Fey tüfa ta miyawkey Jesus engu, tati Nasaret tuwlu. ");
INSERT INTO arnNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Fey ka wiñome feypi ta Pedro, kuyalltulen mew: —¡Kimlafin tüfeychi wentru! ");
INSERT INTO arnNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ka pichi alün mew, tati müleyelu tüfey mew fülmapueyew ñi feypiaetew: —Rüfngey eymi ta ka femngechi kisu engün tañi kompañ. Kenü tami dungun mew kütu ta kimfalimi. ");
INSERT INTO arnNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Feymew Pedro kuyalltuy, feypilen mew: —¡Kimlafiñ tüfeychi wentru! ―pi. Feychi lelen mew müten kakaray ta kiñe alka, ");
INSERT INTO arnNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","fey Pedro tukulpay ñi feypietew ta Jesus: “Petu ñi kakaranon ta alka, küla rupachi ta ‘kimlafiñ’ piaymi.” Fey Pedro tripapatuy ta tiye mew, fey rume fütra ngümakawi. ");
INSERT INTO arnNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Fey wünlu, kom tati pu longkolelu ti pu saserdote mew ka ti putrem fütake pu judiu kiñewi engün tañi adkünuaelchi dungu femngechi ñi langümngeael ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Feymew trarilen yengey, fey chalintukungepuy ta Pilato mew, tati gobernador Roma tuwlu. ");
INSERT INTO arnNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Juda, tati ngünenmafilu ta Jesus, pefilu ñi femngechi kondenantukufiel, rumeñma wiñorakiduamtuy ka wiñoltufi tati küla mari moneda pülata tati pu longkolelu ti pu saserdote mew ka tati putrem fütake judiu mew, ");
INSERT INTO arnNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","fey feypifi: —Yafkan tañi chalintukufiel mew tañi langümngeael ta kiñe yafkakenochi wentru. Welu kisu engün ta llowdungueyew: —¿Fey iñchiñ am chumkoniyiñ? ¡Eymi may tami dungu tati! ");
INSERT INTO arnNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Feymew Juda ütrüftukukünuputufi tati pu moneda tati ngillatuwe ruka mew, fey tripay ka pültrükünuwi. ");
INSERT INTO arnNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tati pu longkolelu ti pu saserdote mew ñimitufi engün tiyechi pülata ka feypi engün: “Tüfachi pülata mew langümfalfuiñ kiñe wentru, fey ngelay taiñ deyümtukuafiel chew tañi mülemum tati ofrenda.” ");
INSERT INTO arnNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Feymew nütramkawi engün tañi ngillayael ti pülata mew kiñe mapu tati pu Widüfe Che ñi Lelfün pingelu, ñi müleael kiñe eltun chew ñi rüngalngeael tati pu kake mapu tuwünche. ");
INSERT INTO arnNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Feymew tiyechi mapu Mollfüñ Lelfün pingey tayi tüfa. ");
INSERT INTO arnNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Femngechi mupituy tañi feypifel tati pelon wentru Jeremia: “Nüfi engün tati küla mari moneda pülata, tati pu israelche ñi fante falin ñi piel engün, ");
INSERT INTO arnNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","fey ti pülata mew ngillafi engün tati pu Widüfe Che ñi Lelfün, femngechi tañi werküetew ta Ñidol.” ");
INSERT INTO arnNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Fey Jesus ta yengey tati gobernador mew, fey ramtueyew ta Pilato: —¿Eymi am tati longko ülmenkülelu ti pu judiu mew? —May, eymi rüf dungu feypipeymi ―pi ñi llowdungun ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Feymew ka dalluntukumekeeyew ti pu longkolelu tati pu saserdote mew ka tati pu putrem fütake judiu, welu Jesus chem pilay rume. ");
INSERT INTO arnNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Feymew Pilato ramtueyew: —¿Allkülaymi am tami femngechi dalluntukumekengen? ");
INSERT INTO arnNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Welu Jesus llowdungulay kiñe dungun no rume, feymew tati gobernador rume rakiduamkülewey. ");
INSERT INTO arnNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Fey müleyüm kawiñ antü, tati gobernador wimtulerkey ñi lifrenentuken kiñe püresu, iney rume tañi dulliel tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Fey mülerkey kiñe rume wesa üytun püresu Barabas pingelu, ");
INSERT INTO arnNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","fey trawüluwkülelu kisu engün, Pilato ramtufi ta Jesus: —¿Iney anta ayüniefimün ta eymün iñche ñi lifrenentutuafiel: tati Barabas, kam ta Jesus tati Cristo pingekelu? ");
INSERT INTO arnNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato am rakiduamlu tati pu judiu tañi chalintukumekefiel tati Cristo re ñi ütrirfiel mew. ");
INSERT INTO arnNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Fey Pilato anülelu tribunal mew, fey tañi kure feypifaleyew: “Chumkefilnge rume tüfeychi ngenoyafkanngechi wentru. Trafia ta rume wesa pewman kisu tañi duam.” ");
INSERT INTO arnNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Welu tati pu longkolelu ti pu saserdote mew ka tati pu putrem fütake judiu aporiafi reke tati pu trawüluwkülechi pu che ñi feypiael engün tañi neykümngetuael ta Barabas, fey ñi langümngeael ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Fey tati gobernador ka ramtueyew engün: —¿Chuchi am tati epulechi püresu ayüleymün ta eymün tañi lifrekünungetuael? Kisu engün feypi: —¡Tati Barabas pingelu! ");
INSERT INTO arnNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato ta ramtueyew engün: —¿Fey chumafiñ anta Jesus, tati Cristo pingekelu? Kom llowdunguy engün: —¡Langümngepe ta kürus mew! ");
INSERT INTO arnNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato ta feypieyew engün: —Fey ¿chem wesa femi amfe? Welu kisu engün ka wirari: —¡Langümngepe ta kürus mew! ");
INSERT INTO arnNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Feymew Pilato, rakiduamlu tañi chem entunon rume tañi doy amul fillpikawmeken engün, werküy tañi küpalelngeael ta ko fey küchay tañi kuwü kom che tañi adkiñ mew, feypilen mew: —Iñche ta chumkonlan rume tañi layael mew ta tüfachi nor mongenngechi wentru. Eymün tamün dungu tatey. ");
INSERT INTO arnNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kom tati pu che llowdunguy: —¡Iñchiñ ka taiñ yomel pu che yafkayaiñ tañi layael mew! ");
INSERT INTO arnNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Feymew Pilato lifrenentutufi ta Barabas. Feymew müten ka wimakafalfi ta Jesus ka chalintukufi ñi langümngeael ta kürus mew. ");
INSERT INTO arnNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tati gobernador tañi pu soltaw yefi engün ta Jesus tati gobernador ñi ruka mew ka trawülngey kom tati trokiñ soltaw ñi walloñmangeael ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Entuñmangey tañi takuwün, fey tukulelngey kiñe kelü takuwün. ");
INSERT INTO arnNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ka tukulelngey tañi longko mew kiñe wayngechi pülliñ korona ka kiñe katrün wifngechi mamüll tañi man kuwü mew. Feymew müten ka lukutuy engün kisu tañi fül mew, tañi ayentuafiel engün, fey feypi engün: —¡Püramyengepe tati pu judiu tañi longko ülmen! ");
INSERT INTO arnNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ka tofkütufi engün ta Jesus, ka kisu tañi mamüll mew wülelkañmafi engün ñi longko. ");
INSERT INTO arnNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Dew rupan femngechi ayentufilu engün, entuñmatufi engün tañi kelü takuwün, tukuleltufi engün kisu tañi takuwün, fey yefi engün tañi langümafiel ta kürus mew. ");
INSERT INTO arnNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Fey tripalu tiye mew, pefi engün ta kiñe wentru Simon pingelu, Sirene ta tremlu. Fey ta aporiafi tañi meñkuael Jesus ñi yenieelchi kürus. ");
INSERT INTO arnNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Puwlu engün kiñe lelfün mew Golgota pingelu, tüfa feypiafel “Kalafera lelfün”, ");
INSERT INTO arnNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","elungefuy tañi pütokoael pulku deyülelu ütrum engu, welu pilay ñi pütokoael. ");
INSERT INTO arnNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Fey dew rupan külafantukungelu kürus mew, tati pu soltaw pewütuy engün tañi wüdamkayafiel kisuke engün Jesus tañi takuwün femngechi ñi mupiael ñi feypikünuel ti pelon wentru: pewtuwi engün tañi wüdamkayafiel kisuke engün tañi takuwün. ");
INSERT INTO arnNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Feymew müten ka anükünuwi tiye mew engün tañi llüwatunieafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ka kisu tañi wente longko tukuy engün ta kiñe letreru, chew tañi wirikonkülemum chem dungu mew tañi kondenangen. Tati letreru feypiley: ");
INSERT INTO arnNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ka langümngey kürus mew epu weñefe, kiñe Jesus ñi man püle, kangelu wele püle. ");
INSERT INTO arnNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Chem che rume rupalu, fillpirpaeyew, fey nengümkay ñi longko, ");
INSERT INTO arnNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","feypilen mew: —¡Eymi, tati feypikelu tami teyfüafiel ti ngillatuwe ruka ta küla antü mew tami wiño dewmatuafiel, kisutu montuluwnge! ¡Ngünechen ñi Fotümngelmi, nagpatunge ti kürus mew! ");
INSERT INTO arnNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ka femngechi ayentueyew tati pu longkolelu ti pu saserdote mew ka ti pu kimeltukelu ti ley dungu kiñentrür tati pu putremke fütake judiu engün. Wirari engün: ");
INSERT INTO arnNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Kangelu montulfi, welu kisutu pepi montuluwlay. Israel tañi longko ülmen: ¡nagpatunge ta kürus mew, fey feyentuaiñ ta eymi mew! ");
INSERT INTO arnNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Maneluwi ta Ngünechen mew. Fey rüf piwkeyenieelmew, ta Ngünechen montulaeymew tati, Ngünechen ñi Fotüm ta iñche pikelu am ta eymi. ");
INSERT INTO arnNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Fey tati weñefe kütu petu langümngelu kürus mew, fillpieyew. ");
INSERT INTO arnNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Feychi antü rangiantülu, kom mapu dumiñmalewey küla ora. ");
INSERT INTO arnNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Feymew müten, Jesus newentu wirari: “Eli, Eli, ¿lema safaktani?” (Feypiafel tati: “Iñche ñi Ngünechen. Iñche ñi Ngünechen, ¿chem mew anta kisukünuen?”) ");
INSERT INTO arnNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kiñeke tati müleyelu feymew, allküy ka feypi engün: mütrümpefi tati pelon wentru Elia. ");
INSERT INTO arnNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pichin mew, kiñe soltaw amuy lefkülen ñi yemeael kiñe esponja, küchumfi pulku mew, trarintukufi kiñe rüngi mew ka fülümtukulelpufi tañi pütokoael. ");
INSERT INTO arnNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Welu tati kakelu feypi engün: —Femkünufinge, küpayay chey am Elia tañi montulpayaetew. ");
INSERT INTO arnNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus ka kiñechi fütra wirari, fey lay. ");
INSERT INTO arnNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Feychi lelen mew tati rünge fütra kortina tati ngillatuwe ruka mew wichafnagi. Wechuñ mew tuwi, fey felen puwi nageltu. Mapu ta nengümi, chengke kura wükakawi. ");
INSERT INTO arnNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ka tati küfwe nülayey ka fentren lif piwkengekefulu maneluwkülen Ngünechen mew, layelu, wiñomongeyetuy. ");
INSERT INTO arnNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Feymew tripayetuy tañi küfwe mew. Rupan wiñomongetulu ta Jesus, ka konpuy engün Jerusalen waria mew, feymew ta fentren che peeyew. ");
INSERT INTO arnNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Feymew tati Roma tuwchi kapitan ka tati müleyelu kisu engün ñi llüwatuafiel ta Jesus, pefi engün ñi rupan tati nüyün ka kom tüfachi dungu, fey llükay engün ka feypi engün: —¡Rüfngerkey ta tüfachi wentru ta Ngünechen ñi Fotümngen! ");
INSERT INTO arnNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tiye mew, alü kamapu adkintuley fentren domo tuwlu Galilea tañi kellufiel Jesus chemkün mew. ");
INSERT INTO arnNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Fey tüfey engün mew müley ta Maria Magdalena, Maria Santiaw ka Jose tañi ñuke, ka Sefedew tañi epu fotüm Juan engu Santiaw ñi ñuke. ");
INSERT INTO arnNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Fey dewma pu trafialu, akuy kiñe riku wentru Jose pingelu, Arimatea tuwünche, ka feyentulelu ta Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jose wütufi ta Pilato ka feypifi ñi elungetuael Jesus tañi kuerpu. Feymew Pilato werküy ñi wülngetuael ti alwe. ");
INSERT INTO arnNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Fey Jose nagümelngetuy ta Jesus ñi kuerpu ka iwüdüfi kiñe lino lif safana mew. ");
INSERT INTO arnNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ka tukukünufi kiñe we rüngan mew, kisu tañi ngenngeel mew, kisu tañi dewmafalel ti chengke kura mew. Rupan takukünufilu tati konwe rüngan lolo kiñe fütra kura mew, fey amutuy. ");
INSERT INTO arnNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Welu Maria Magdalena ka ti kangelu Maria mülewey engu, fey anükünuwi tati rüngan lolo ñi inafül. ");
INSERT INTO arnNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Fey kangelu antü, tati ürkütun antü mew, tati pu longkolelu ti pu saserdote mew ka ti pu farisew amuy engün kiñentrür tañi pemeafiel ta Pilato. ");
INSERT INTO arnNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Fey feypifi engün: —Ñidol, tukulpatukefiyiñ ta tiyechi koylatufe Jesus, feychi petu mongelefulu, feypi ‘küla antü rupale, wiñomongetuan.’ ");
INSERT INTO arnNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Feymew, werkünge ta eymi tañi fente küme llüwatuniengeael tati rüngan lolo, fey küla antü wüla puwle ñi kisukünungetuael. Anokechi küpayafuy tañi pu disipulu, fey weñenentupatuafuy engün ta Jesus ñi kuerpu, fey “wiñomongetuy ta Jesus” pituafuy engün tati pu che. Feymew tati inan koyla dungu, doy fütra koylangeafuy. ");
INSERT INTO arnNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Fey Pilato ta feypieyew: —Yemün soltaw. Fey amumün ka küme nürüfafimün tati rüngan lolo chumngechi tamün doy kümelu trokifiel. ");
INSERT INTO arnNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Fey amuy engün ka nürüfpufi engün tati rüngan lolo, fey tukulelfi engün kiñe sello takulechi kura mew. Ka tiye mew elkünupuy engün epu soltaw llüwatulealu. ");
INSERT INTO arnNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dew rupalu tati ürkütun antü, fey dew wünlu ti llituelchi antü semana mew, Maria Magdalena ka tati kangelu Maria amuy engu ñi pemeafiel tati rüngan lolo. ");
INSERT INTO arnNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Müchay müten müley kiñe fütra nüyün mapu mew kiñe werken püllü am nagpalu ta wenu mapu. Fey fülpalu tati rüngan lolo mew, famentufi tati takulekechi kura, fey ka anükünuwi tati kura mew. ");
INSERT INTO arnNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tati werken püllü wilüfi llüfkeñ reke, ka tañi takuwün fülangi pire reke. ");
INSERT INTO arnNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Fey peetew tati pu soltaw, müllmülli engün fente tañi llükan, fey la reke felewey engün. ");
INSERT INTO arnNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Fey tati werken püllü feypifi tati epu domo: —Llükakilmu. Iñche kimnien tamu kintupapefiel ta Jesus, tati langümngelu ta kürus mew. ");
INSERT INTO arnNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ngewetulay ta tüfa mew. Kisu ta wiñomongetuy chumngechi tañi feypikünuel. Pepafimu chew tañi tukukünungefumum. ");
INSERT INTO arnNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Matuke amutumu, fey feypiafimu tati pu disipulu: ‘Wiñomongetuy, ka amuay ta Galilea. Wüne puway ta eymün mew. Tiye mew ta peafimün.’ Fey tüfachi dungu ta iñche niepen tamu feypiwafiel. ");
INSERT INTO arnNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tati epu domo ta rume matukel tripapatuy engu tati rüngan lolo mew. Rume llükaley, welu ka rume ayüwküley engu, fey lefkülen küpatuy engu tañi kimelpatuafiel tati pu disipulu. Fey küpaletulu engu ñi kimelpatuafiel tati pu disipulu, ");
INSERT INTO arnNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","feymew ka müten, Jesus pewfaluweyew ka chalieyew. Feymew kisu engu fülkontufi ta Jesus ka püramyefi engu ka mafülüñmafi ñi namun, ");
INSERT INTO arnNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","fey feypieyew ta Jesus: —Llükakilmu. Feypimetufimu tañi pu peñi ñi amuael engün ta Galilea, fey üyew ta peaenew engün. ");
INSERT INTO arnNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Petu tañi amulen tati epu domo, kiñeke ti pu soltaw tati llüwatulekelu, puwtuy engün ta waria mew ka nütramelputufi tati pu longkolelu ti pu saserdote mew kom feychi dungu tañi rupan. ");
INSERT INTO arnNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Fey tüfachi pu longko amuy engün tañi dunguafiel tati putremke fütake pu judiu, tañi fente küme nütramkawael ta kisu engün. Ka fentren pülata elufi engün tati pu soltaw, ");
INSERT INTO arnNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ka fente küme feypikünufi engün: —Eymün ta feypiaymün: ‘Punkülelu, petu umawkülelu iñchiñ, Jesus tañi pu disipulu küpay. Weñenentupatufi engün tati kuerpu.’ ");
INSERT INTO arnNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tati gobernador kimle ta tüfachi dungu, iñchiñ ta küme nütramkayafiyiñ, fey eymün ta kelluwayiñ tamün kutrankangenoam. ");
INSERT INTO arnNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tati pu soltaw llowi tati pülata ka femi kom tañi feypingeel engün. Fey tüfa tañi femngechi feypingeken tayi tüfa amuley tati pu judiu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Feymew tati pu mari kiñe disipulu amuy engün ta Galilea, Jesus tañi üytukünuletewchi wingkul. ");
INSERT INTO arnNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Fey pefilu engün ta Jesus, püramyefi. Kiñekentu ta petu küme feyentulelafuy rume. ");
INSERT INTO arnNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Feymew Jesus fülkonpuy ta kisu engün mew ka feypieyew: —Ngünechen ta eluenew kom pepiluwün wenu mapu ka mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Amumün, kom chüf mapu müleyechi pu che mew. Ka kimeltuafimün femngechi tañi kimaetew engün ka iñche ñi disipulungeael engün. Fawtisayafimün ta Chaw tañi üy mew ka Fotüm ka tati Lif Küme Püllü mew, ");
INSERT INTO arnNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ka kimeltuafimün tañi feyentuael engün kom iñche tamün werküwkefiel ta eymün. Iñche rumel mülean ta eymün mew, tunte afllele rume ta mapu. Felepe may.");
INSERT INTO arnNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Fey tüfa mew llituy Jesucristo ñi küme dungu, Ngünechen tañi Fotüm. ");
INSERT INTO arnNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tati pelon wentru Isaia famngechi wirintukuy: “Iñche werkün tañi werken wünelealu eymi mew femngechi tañi kimeltuafiel tati pu che kisu tañi akuael.” ");
INSERT INTO arnNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Kiñe wirartu dungun allküngey uwe mapu mew: ‘Kiñe nor küme rüpü reke feletupe tamün rakiduam, femngechi tamün llowafiel ta Ñidol.’ ” ");
INSERT INTO arnNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Feymew ta Juan pewfaluwi ti uwe mapu mew, fey fawtisamekefi tati pu che, ka feypinieyefi tañi wiñorakiduamtuael engün ta Ngünechen mew ka tañi fawtisangeael, femngechi tañi wiñoduamatuaetew engün ta Ngünechen kom tañi yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kom ti pu che mülelu Judea trokiñ mapu mew, ka Jerusalen waria mew, tripay engün tañi allkütuael. Feypi engün tañi yafkafengen, fey Juan fawtisaeyew engün Jordan lewfü mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan tañi tukunieelchi takuwün ngüreley ta re kal kamellu mew, ka trariwtuley kiñe trülke koriwen trariwe mew. Ka ikey chori ka lelfün mew mülechi miel. ");
INSERT INTO arnNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Fey tañi wewpin mew ta feypi: “Iñche mew inalepay ta kiñe doy fütra pepiluwünngelu, fey fente tañi yamniefiel mew ta kisu nentupüroñmalayafuiñ rume tañi okota. ");
INSERT INTO arnNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iñche ta fawtisawkeyiñ ta eymün re ko mew müten, welu ta kisu fawtisayaeymünmew ti Lif Küme Püllü mew.” ");
INSERT INTO arnNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Feychi mew, Jesus tripapay ta Nasaret waria mew, Galilea trokiñ mapu mew mülelu, fey Juan fawtisaeyew ta Jordan lewfü mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Feychi lelen mew müten tripatulu ta ko mew, Jesus pefi ñi nülan ta kallfü wenu ka pefi ñi nagpan ta kisu mew tati Lif Küme Püllü kiñe palluma reke. ");
INSERT INTO arnNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ka kiñe dungun allküngey wenu mapu mew feypilu: “Eymi ta iñche ñi piwkeyen Fotüm, iñche tañi manelnieel.” ");
INSERT INTO arnNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dew rupalu tüfachi dungu, tati Lif Küme Püllü ñi pepiluwün mew, Jesus puwi ti uwe mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Fey meli mari antü mülepuy chew ñi miyawentukemum ti wapoke kulliñ ka wültukungey ñi kintukaduamaetew ta Weküfü. Fey ti pu werken püllü poyetunieeyew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Fey tukungelu ta Juan karsel mew, Jesus wiñotuy ta Galilea ñi wewpiafiel Ngünechen ñi küme dungu, ");
INSERT INTO arnNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","feypilen mew: “Akuy ta antü, ka dew mülepay Ngünechen tañi longko ülmenngen. Wiñorakiduamtumün ta Ngünechen mew, ka feyentun mew llowfimün kisu tañi we kimelün dungu.” ");
INSERT INTO arnNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus ta trekaley Galilea tañi inaltu pichi lafken püle, fey pefi ti epu peñiwen Simon Andre engu. Challwafe ürke engu. Fey petu ütrüftukulu engu tañi challwawe pu lafken, ");
INSERT INTO arnNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus ta feypifi ti epu wentru: —Inamuchi, tamu challwafengefel, welu tüfa kintuafimu ta che tamu küpalafiel iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Feychi lelen mew müten elkünuy engu tañi challwawe, fey inaeyew engu. ");
INSERT INTO arnNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Fey doy üyew püle amulelu, Jesus pefi tati epu peñiwen Santiaw ka Juan, Sefedew ñi epu fotüm, mülelu kiñe farku mew petu raletulu engu tañi challwawe. ");
INSERT INTO arnNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Feymew ka müten mangelfi ñi inayaetew, fey kisu engu elkünuy tañi chaw Sefedew tati farku mew ñi pu kona engün, fey amuy engu ta Jesus engün. ");
INSERT INTO arnNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Fey puwi engün ta Kapernaum. Fey ti ürkütun antü mew Jesus konpuy tati sinagoga mew, fey llituy tañi kimeltuael. ");
INSERT INTO arnNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Fey ti pu che ta afmatuley femngechi tañi kimeltungeel mew engün, fentren pepiluwün mew am kimeltumekelu. Ñi kimeltun trürlay chumngechi ñi kimeltuken tati kimeltukelu ta Moyse ñi ley dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Fey tati waria mew mülechi sinagoga mew mülerkey kiñe wentru konweküfülelu, fey tüfeychi wentru ta wirartufi ta Jesus: ");
INSERT INTO arnNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Chem mew anta kontumupaiñ, Jesus Nasaret tuwlu? ¿Küpaymi am taiñ apümkamuafiel? Iñche ta kimnieeyu, ka kimnien tami ineyngen. Eymi ta Ngünechen ñi dullin. ");
INSERT INTO arnNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Fey Jesus ta katrütudungueyew feypilen mew: —¡Feypikilnge tüfeychi dungu ka elkünutufinge ta tüfachi wentru! ");
INSERT INTO arnNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tati weküfü lalatulfi tati wentru, ka fütra newentu wirarüy, fey tripatuy tati wentru mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kom ti pu che mülelu sinagoga mew llükay engün, ka welukonkechi ramtuwi engün: “¿Chem dungu anta tüfa? ¡Kimeltuy ta kiñe kangerumechi we kimelün dungu kom rüfkünu dungu mew! ¡Kenü tati weküfü kütu ta werküfi, ka müngeltueyew!” ");
INSERT INTO arnNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Fey müchay müten nütramyengey ta Jesus Galilea tañi kom lof mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tripapatulu engün tati sinagoga mew, Jesus, Santiaw ka Juan amuy engün ta Simon ka Andre tañi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon tañi llalla rume aling kutrankülerkey fey ngütantuluwkülerkey. Feypingey ta Jesus ñi kutrankülen tati kuse püllü, ");
INSERT INTO arnNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","fey kisu fülkonpuy, ka nükünufi kuwü mew, fey witrañpüramfi. Feychi lelen mew müten tremotuy ñi aling kutran mew, feymew müten pepikawi tañi poyeafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Fey dew konlu ta antü, feymew Jesus yelelngey fentren tati pu kutrankülelu ka ti pu konweküfülelu, ");
INSERT INTO arnNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ka fentren che mülelu ti waria mew trawüluwpuy engün tati wülngiñ ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus tremolfi rume fentren che epe fill kutran nielu, ka wemünentufi fentren weküfü, welu elulafi tañi dunguael tati pu weküfü, kisu engün am kimnieetew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Fente küme puliwen, petu tañi dumdumkülen, Jesus tripay ti waria mew tañi ngillatumeael kiñe uwe lelfün mew ñi ngenomum che. ");
INSERT INTO arnNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon ka tañi pu kompañ amuy engün tañi kintuafiel ta Jesus, ");
INSERT INTO arnNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","fey pefilu engün feypifi: —Kom che ta kintuyawüleymew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Welu ta kisu llowdunguy: —Amuiñ tati fülküleyechi lof che mew taiñ kimelafiel engün kay tati werken dungu. Fey tüfachi dungu mew am ta küpalu ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Fey tüfa famngechi Jesus miyawi Galilea trokiñ mapu mew. Kimelkiyawüli ti werken dungu sinagoga mew müleyelu kake kiñeke lof mapu mew ka wemünentuyefi tati pu weküfü. ");
INSERT INTO arnNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kiñe wentru nielu lepra kutran fülkonpuy ta Jesus mew, fey lukutulen feypifi: —Pifulmi eymi, tremoltuafen tañi kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus ta kutranduamyeeyew, fey nüñmaeyew ñi kuwü ka feypieyew: —Ayülen tami tremotuael. ¡Tremotunge! ");
INSERT INTO arnNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Feychi lelen mew müten tati wentru tremotuy tañi lepra kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Feymew ka müten Jesus chalitueyew, ka feypieyew: ");
INSERT INTO arnNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Allkütunge. Iney no rume feypikefilnge tüfachi dungu, fey amunge tati saserdote mew tami leliwülaetew tami tremotun. Ka yeaymi tati ofrenda ta mañumtun reke, Moyse tañi werküel, femngechi ta kom che ñi kimael tami dew tremolewetun tami kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Welu amuletulu tüfachi wentru, fey eluwi tañi nütramyelafiel ta kom che femngechi dungu mew tañi rupan. Feymew ta Jesus pepi konwelay chem waria mew no rume chumngechi wimtulefuy ñi konpukefel, welu re wekuntu ti waria mülekerkey tati lelfün püle chew ngelay ruka che. Welu fill püle mülechi pu che küpakey tañi pepayaetew. ");
INSERT INTO arnNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Dew rupalu kiñe mufün antü, Jesus ka wiñokonputuy ta Kapernaum. Fey kimngelu müten tañi mülepun ta ruka mew, ");
INSERT INTO arnNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","rume fentren che trawüy. Feylay rume engün tati wülngiñ ñi lepün mew, fey kisu kimeltumekefi tati werken dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Feymew meli wentru yeleleyew ta kiñe kutran lañmalelu ñi kuerpu. ");
INSERT INTO arnNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Welu fentren che am mülelu, pepi konpulay engün chew ñi mülemum ta Jesus. Feymew wecharpufi engün tati küpül ruka, fey nagümpufi engün ti ngütantuluwkülechi kutran chew müley ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Feymew Jesus, pefilu tañi nien fentren mupiltun engün, feypifi tati kutrankülelu: —Iñche ñi weni, dew wiñoduamangetuymi tami yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Fey kiñeke tati kimeltukelu Moyse ñi ley dungu anülepulu tiye mew, rakiduami engün: ");
INSERT INTO arnNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Chumngechi anta kisu ngünewi tañi femngechi feypiael ta tüfa? Ñi femngechi dungun mew notukafi ta Ngünechen. Ngünechen müten ta wiñoduamachetuafuy ta yafkan mew.” ");
INSERT INTO arnNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Welu Jesus müchay müten ngüneduami tañi femngechi rakiduamkülen engün, fey ka ramtufi ti pu kimeltuchefe: —¿Chem mew anta femngechi rakiduamküleymün ta eymün? ");
INSERT INTO arnNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Chem pin anta doy küdawngelay tañi feypingeael tati lañmalelu tañi kuerpu: ‘Wiñoduamaletuymi tami yafkan mew’, kam ñi feypingeael: ‘Witratunge. Witrañpüramnge tami ngütantu ka trekatunge’? ");
INSERT INTO arnNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Iñche feypiwayiñ ta fewla ti Wentrukünuwpalu ñi nien ta pepiluwün tüfachi mapu mew ñi wiñoduamachetuael ta yafkan mew. Feymew feypifi tati lañmalelu ñi kuerpu: ");
INSERT INTO arnNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Eymi ta feypipeeyu: witratunge ka nünge tami ngütantu. Fey amutunge tami ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Fey tati kutran feymew müten witratuy, fey nütulu ñi ngütantu, tripapatuy tiye mew fey ñi penieetew itrokom che. Feymew ta itrokom che afmalewey ka püramyefi engün ta Ngünechen feypilen mew: —Chumkawnorume pekelaiñ femngechi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Feymew Jesus ka amuy ta inaltu pichi lafken, fey ti pu che fülkonpay ta kisu mew, feymew kisu ta kimeltufi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Fey Jesus rupalu fey püle, pefi ta Levi, Alfew tañi fotüm, anülelu chew ñi kofrangekemum ta impuestu Romangealu. Jesus feypifi ta Levi: —Inaen. Fey Levi ta witratripay ka inaeyew. ");
INSERT INTO arnNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Fey mangelngey ta Jesus ñi imeael Levi tañi ruka mew. Fey tüfey mew mülepuy fentren tati pu kofrakelu ta impuestu Romangealu, ka ti kakelu wesake dunguyen pu che. Ka femngechi anülepuy ta mesa mew kiñentrür Jesus ka ñi pu disipulu engün, fey rume fentren che puwyelu am tañi pu inayawületew. ");
INSERT INTO arnNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Fey ti pu farisew ka tati pu kimeltukelu ta Moyse ñi ley dungu, pefilu ta Jesus ñi imeken kom kiñentrür tüfey engün mew, ramtufi engün tati pu disipulu: —¿Chumngelu am tamün kimeltufe kiñentrür imekey tati pu kofrakelu impuestu ka ti pu yafkafe engün? ");
INSERT INTO arnNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus ta allküñmaeyew, fey feypingey engün: —Tati pu che külfünkülelu ka tremolkülelu fey engün duamyelay ta lawentuchefe, welu tati pu kutrankülelu may. Iñche küpalan tati pu küme piwkekawünnngelu mew, welu may tati pu yafkafe mew. ");
INSERT INTO arnNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kiñe rupachi ayunalerkey Juan tañi pu disipulu ka tati pu farisew ñi inakeetewchi pu che. Fey kiñeke tüfey engün amuy ta Jesus mew ka ramtupufi engün: —Juan tañi pu disipulu ka tati pu farisew tañi inakeetewchi pu che ayunakey engün, fey ¿chumngelu am ayunakelay kay eymi tami pu disipulu? ");
INSERT INTO arnNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus ta llowdungueyew engün: —¿Chumngelu am kay ayunayafuy tati mangelngelu ta mafün mew, petu tañi mülen tati nofio kisu engün mew? Petu tañi mülen kisu engün mew tati nofio, ngelay tañi ayunayael engün. ");
INSERT INTO arnNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Welu akuay tati antü ñi yengetuael tati nofio. Feychi akule tati antü, fey wülake ta feley ñi ayunayael engün. ");
INSERT INTO arnNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Iney rume ta lapatukelay ta kiñe llud takuwün ka tukulelkelafi ta kiñe we katrün lapan pañu, tati we katrün pañu am trüküfükelu ka wikürelkefi tati llud takuwün, fey doy wesa wikürükey tati takuwün. ");
INSERT INTO arnNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ka femngechi ta we pulku rume tukungekelay ta llud kueru mew. Tati we pulku ta pawkülkayafuy tati llud kueru, fey ngünayafuy tati pulku ka ti kueru wikürafuy. Feymew feley tati we pulku tañi wütruntukungeael kiñe we kueru mew.” ");
INSERT INTO arnNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kiñe ürkütun antü mew, Jesus trekalen rumey rangi kachilla. Fey tañi pu disipulu, petu rumelu, eluwi engün tañi suchetuafiel tati longko kachilla. ");
INSERT INTO arnNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fey ti pu farisew ramtueyew: —Fey ¿chumngelu am femngechi femkey tami pu disipulu ñi femnoafel ta che ürkütun antü mew? ");
INSERT INTO arnNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Feymew Jesus llowdungufi ti pu farisew: —¿Kimlaymün am ñi chumün ta David kiñe rupa kisu ka tañi pu kompañ ngüñülelu engün? ");
INSERT INTO arnNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar ürkefel tati Wünen Longko Saserdote. David konpuy ta Ngünechen ñi ruka mew, fey ipufi tati kofke Ngünechen tañi chalintukulelngeel. Ka femngechi eluyefi tañi kompañ ñi inanieetew, welu tati pu saserdote müten ta felerkefuy tañi iyafel ti kofke. ");
INSERT INTO arnNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Fey Jesus ka amul feypi: —Ürkütun antü ta elngey che tañi duam, welu che ta elngelay ta ürkütun antü ñi duam. ");
INSERT INTO arnNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Feymew ti Wentrukünuwpalu Ñidolküley tati ürkütun antü mew. ");
INSERT INTO arnNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus ka konpuy ta kiñe sinagoga mew. Tüfey mew mülerkey ta kiñe wentru lañmalelu tañi kuwü. ");
INSERT INTO arnNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fey inaduamniengey ta Jesus ñi tremolpeafiel may ta ürkütun antü mew, femngechi tañi dalluntukuafiel engün. ");
INSERT INTO arnNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Feymew Jesus feypifi ti wentru, lañmalelu ñi kuwü: —Witrange, ka rangi ti pu che witrakünuwnge. ");
INSERT INTO arnNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Feymew ka ramtufi ti kakelu pu che: —¿Chem dungu anta feley tañi femael ta che ürkütun antü mew: ñi femael küme dungu kam wesa dungu? ¿Ñi montulmangeael ñi mongen ta kiñe che kam ñi elungeael ñi layael? Welu kisu engün chem pilay rume. ");
INSERT INTO arnNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus lladkenkechi adkintufi ti pu che tañi walloñmanieetew, ka weñangküduami ayünolu engün am ñi piwkentukuafiel ti dungu, fey feypifi ta tiyechi wentru: —Norümentunge tami kuwü. Fey ti wentru norümentuy tañi kuwü, fey tremolewetuy. ");
INSERT INTO arnNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Welu tripatulu müten tati pu farisew, eluwi engün tañi trürümdunguael Erode tañi kelluntukunieetewchi pu che engün femngechi tañi langümafiel engün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus amuy tañi pu disipulu engün inaltu pichi lafken, fey inaeyew ta rume fentren che tuwlu ta Galilea. ");
INSERT INTO arnNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Fey kimngelu ñi femken afmatufal dungu, fey akuyey tañi pepayaetew fentren che tuwlu ta Judea, tuwlu Jerusalen, ka Idumea, ka fentren che mülelu Jordan tañi tripawe antü püle ka Tiro engu Sidon tañi trokiñ mapu. ");
INSERT INTO arnNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Fey tüfachi dungu mew, Jesus feypifi tañi pu disipulu tañi nielpayaetew kiñe farku, femngechi tañi famentuwküleael fey ñi tenfikamekenoaetew ti pu che. ");
INSERT INTO arnNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesus am fentren che tremolfilu, kom tati pu kutran rume fülkonmekepuy ta kisu mew femngechi tañi idapuaetew. ");
INSERT INTO arnNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Fey tati pu weküfü pefilu ta Jesus, lukutunagmekey engün Jesus ñi fül mew ka wirarümekey: —¡Eymi ta Ngünechen tañi Fotüm! ");
INSERT INTO arnNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Welu Jesus katrütudunguniefi ti pu weküfü newentu dungun mew ñi feypinoael engün rangi tati pu che ñi ineyngen ta kisu. ");
INSERT INTO arnNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Feymew dew rupalu tüfachi dungu, Jesus pürapuy kiñe wingkul mew, fey mütrümyefi kiñeke ti pu che kisu tañi dullitunieel. Fey dew trawüluwkülelu engün, ");
INSERT INTO arnNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","dullintuyey ta kisu engün mew mari epu wentru, tañi kompañaetew engün ka tañi werküafiel ñi kimelael tati küme werken dungu. Fey tüfa engün ta apostol pingey, ");
INSERT INTO arnNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ka elungey pepiluwün tañi wemünentuafiel tati pu weküfü. ");
INSERT INTO arnNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Fey tüfa tati mari epu wentru tañi dullintuel: Simon, tati Pedro pintukulel ñi üy, ");
INSERT INTO arnNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ti epu peñiwen Santiaw ka Juan, Sefedew tañi epu fotüm, fey engu Boanerge pintukulelfi tañi üy (tralkan tañi fotüm piael ürke) ");
INSERT INTO arnNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andre, Felipe, Bartolome, Matew, Tomas ka Santiaw, Alfew tañi fotüm Tadew, Simon tati Selote, ");
INSERT INTO arnNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ka Juda Iskariote, fey tüfa lle tati ellka ngünenmatufilu ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Feymew ka konpuy ta Jesus kiñe ruka mew. Fey trawülu am ta rume fentren che, pepi ilay rume ta kisu ka tañi pu disipulu no rume. ");
INSERT INTO arnNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Fey Jesus tañi pu reñma kimlu engün tañi femngechi dungu ñi femmeken, amuy engün ñi yemetuafiel. “Wedweduwi tati” pirkey engün. ");
INSERT INTO arnNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ka femngechi tati pu kimeltukelu ta Moyse ñi ley dungu tuwlu ta Jerusalen akuy engün ka feypipay: “Belsebu, tati rüf longkolelu ti pu weküfü mew, fey ta elueyew pepiluwün ta tüfachi wentru tañi pepi wemünentuafiel tati pu weküfü.” ");
INSERT INTO arnNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Fey Jesus mütrümfi ti pu kimeltukelu ta Moyse ñi ley dungu, fey kiñe adkünu dungu mew feypifi: “¿Chumngechi anta weküfü wemünentuafuy ta weküfü? ");
INSERT INTO arnNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kiñe fütra trokiñ mapu mew mülechi pu che wichuke püntükawkülele ka kayñetuwkülele engün turpu kiñewkülelayafuy. ");
INSERT INTO arnNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ka femngechi kiñe reñmawen pu che wichuke püntükawkülele engün, turpu kiñewkülelayafuy. ");
INSERT INTO arnNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Fey weküfü wichu püntükawkülele, ka kisutu kewatuwle, rumel küme felelayafuy. Puwafuy may kisutu ñi apümkawün. ");
INSERT INTO arnNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Iney rume ta konpulayafuy kiñe rume newenngechi wentru ñi ruka mew tañi müntuñmayafiel ñi nieelchi chemkün, wünelu mew trarinofile. Welu trarikünufile, fey wülake pepi müntuñmayafuy kom ñi nieel. ");
INSERT INTO arnNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Rüf dungu ta feypiwayiñ Ngünechen ta feleay tañi wiñoduamatufiel ta pu che, kom tañi yafkan mew ka kom tañi wesa pikeel mew engün. ");
INSERT INTO arnNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Welu tati kayñetudungufilu tati Lif Küme Püllü, chumkawnorume wiñoduamangelayay. Fey ta rumel feleay ñi yafkalen.” ");
INSERT INTO arnNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Fey tüfachi dungu feypi ta Jesus, kisu engün am “konweküfüley” pifilu engün. ");
INSERT INTO arnNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Feymew ta akuy Jesus tañi ñuke ka tañi inanke pu peñi, welu wekuntu mülepay engün. Feymew “tripapape” pifalngey. ");
INSERT INTO arnNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Fey ti pu che, anülelu Jesus tañi inafül püle, feypieyew: —Tami ñuke, ka tami pu peñi wekuntu mülepay. ‘Tripapape’ pieymew engün. ");
INSERT INTO arnNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Fey Jesus ta llowdunguy: —¿Iney anta iñche ñi ñuke ka tañi pu peñi? ");
INSERT INTO arnNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Feymew müten, adkintufi tati pu che anüleyelu kisu tañi inafül püle, ka amul feypifi: —Tüfa engün ta iñche tañi ñuke, ka tañi pu peñi. ");
INSERT INTO arnNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Fey iney rume ta küdawyefile Ngünechen tañi ayükeelchi dungu, fey iñche tañi peñi, ñi lamngen ka tañi ñuke. ");
INSERT INTO arnNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ka wiñome eluwi ta Jesus ñi kimeltucheael inaltu ti pichi lafken püle. Rume fentren che am trawüluwlu, Jesus pürapuy ta kiñe farku mew mülelu ta inaltu tiyechi pichi lafken mew. Fey anükünuwpuy ti farku mew, fey ti pu che eluwpuy inaltu lafken. ");
INSERT INTO arnNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Feymew Jesus eluwi tañi kimeltuafiel fentren adkünu dungu mew. Fey ñi kimeltun mew feypifi ti pu che: ");
INSERT INTO arnNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Allkütumün tüfachi dungu: kiñe wentru nganketrankelu tripay tañi nganael. ");
INSERT INTO arnNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Fey nganlu, kiñeke tati fün ketran pachügnagi rüpü mew. Fey akulu ti pu üñüm, üpitufi ti fün ketran. ");
INSERT INTO arnNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ka kiñeke fün ketran pachügnagi kurantu mew, chew tañi newe rüngenomum ta mapu. Feychi fün ketran müchay müten noyüy, tati mapu am newe rüngenolu. ");
INSERT INTO arnNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Welu aretripalu ta antü, angkümeyew, müte nienolu am ta folil, feymew angküy. ");
INSERT INTO arnNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Fey ka kiñeke tati fün ketran pachügnagi pu troltrontu. Fey tremyelu ti troltro, takueyew, fey fünlay. ");
INSERT INTO arnNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Welu tati kakelu fün ketran pachügnagi küme mapu mew, fey tremi, ka wüli rume fentren fün. Kiñeke fün ketran wüli küla mari fün, ti kakelu wüli kayu mari fün, ka kiñekentu pataka fün.” ");
INSERT INTO arnNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ka amul feypi ta Jesus: “Tati ayülu ñi allkütuael, allkütupe.” ");
INSERT INTO arnNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Feymew kisulewetulu ta Jesus, tati pu che fülküleyelu kisu mew ka kiñentrür müleyelu ti mari epu disipulu engün, fey ramtueyew engün tañi chem pifel ta tiyechi adkünu dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Fey kisu llowdungufi ti pu che: “Eymün kimelngeymün ta Ngünechen ñi longko ülmenngen, tati kimelkenofelchi dungu, welu tati kakelu pu che müleyelu kimeltungekey engün Ngünechen ñi longko ülmenngen re adkünu dungu mew, ");
INSERT INTO arnNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘femngechi ta tunte adkintule rume engün, ñi penoael, ka tunte allkütule rume engün ñi kimnoael, femngechi tañi wiñorakiduamtunoael engün ta Ngünechen mew, fey kisu tañi wiñoduamatunoaetew.’ ” ");
INSERT INTO arnNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Fey feypingey engün: “¿Eymün am küme kimlafimün tüfachi adkünu dungu? ¿Chumngechi anta kimafimün kom ti kakelu adkünu dungu? ");
INSERT INTO arnNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tati wentru ngankefilu ti fün ketran, fey ta adentuley tati kimelkelu ti werken dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tati rüpü mew pachügnagchi fün adentuley ta kiñeke che allkütulu ti werken dungu, welu dew allkütufiyüm, weküfü ta müntuñmatukeeyew tati ngankülechi werken dungu tañi piwke mew. ");
INSERT INTO arnNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ka kiñekentu tati fün nganngelu kurantu mew reke feley. Allkütukefi tati werken dungu ka ayüwkülen llowkefi, ");
INSERT INTO arnNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","welu newe nienolu am ta folil, müte newenkülekelay. Feymew kutrankawiyüm ta fill wesake dungu mew, kam kayñetungeyüm tati werken dungu tañi duam, elkünutukeyngün tañi feyentun. ");
INSERT INTO arnNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ka kiñekentu tati nganelchi fün pu troltrontu reke feley. Allkütukefi engün tati werken dungu, ");
INSERT INTO arnNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","welu ta tüfachi mapu mew mülechi küdaw mew rume ngenowkülekey, ka rume ayülelu tañi rikungeael fey ta ngünenkaniekeeyew, fey ayülekey ñi nieael itrokom chemkün. Kom tüfachi dungu konkey ta kisu engün mew, welu takungekey reke tati werken dungu ka elukelafi ñi müleael piwke mew ti küme dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Welu ta kiñekeley allkükelu tati werken dungu, fey engün ta llowkefi ti küme dungu, ka wülkey rume küme kosecha, küme mapu mew nganelchi fün ketran reke. Kiñekentu ta tüfa engün tati longko kachilla reke müley tati wülyelu küla mari fün kiñeke fün ketran mew, ka kiñekentu tati wülyelu kayu mari fün ka kiñekentu tati wülyelu pataka fün.” ");
INSERT INTO arnNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ka femngechi feypi: “¿Elkünungekey anta kiñe küdetuwe miñche kakon kam miñche kawitu? Femngekelay tati. Kiñe küdetuwe ta renukünungekey tañi pelontuleael. ");
INSERT INTO arnNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ka femngechi, chem ellkan dungu rume ngelay tañi pengenoael, ka chem ellkan dungu rume ngelay tañi fente küme kimngenoael. ");
INSERT INTO arnNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tati ayülu ñi allkütuael, allkütupe.” ");
INSERT INTO arnNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ka femngechi feypifi: “Ngüneduamfimün tamün allkükeelchi dungu. Chumngechi mediwe mew medilmün ta eymün, ka femngechi mediwe mew Ngünechen ta medilaeymünmew ta eymün. Ka doy amul elurpuaeymünmew. ");
INSERT INTO arnNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tati nielu, ta doy elungeay, welu tati nienolu tañi pichi nieñmuel kütu ta müntuñmangeay.” ");
INSERT INTO arnNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus ka femngechi feypi: “Ngünechen tañi longko ülmenngen ka femngechi feley kiñe wentru reke nganlu ta fün ketran ñi mapu mew: ");
INSERT INTO arnNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","tunte umawkülele rume kam trepelele rume, ka femngechi pun rume ka antü rume, tati fün ketran noyükey ka tremkey, welu kisu kimlay ta chumngechi ñi tremün tati ngan ketran. ");
INSERT INTO arnNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Fey mapu llemay kisu elukeeyew ñi tremael. Wünelu mew noyükey kiñe kachu reke, feymew ta ka eluwkey ñi longkoael, fey wüla ka apokey fün mew tati longko ketran. ");
INSERT INTO arnNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Fey dew tremiyüm tati fün, katrüngekey ka trawülngekey akulu am ta walüng antüngen.” ");
INSERT INTO arnNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ka feypi ta Jesus: “¿Chem mew anta adentuley ta Ngünechen ñi longko ülmenngen kam chem mew anta trürümafuiñ? ");
INSERT INTO arnNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kiñe ngankeelchi fün mostasa mew adentuley Ngünechen ñi longko ülmenngen. Doy pichifuy rume ta itrokom fün mew mülelu ta tüfachi mapu mew, ");
INSERT INTO arnNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","welu dew rupan ta nganngeyüm, wefkey ka tremkey ka doy alü tremkey kom anümka mew, mülelu ta werta mew. Niekey ta alüke chang tripachi row, fey pichike üñüm dañekey kütu tañi row mew.” ");
INSERT INTO arnNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Fey ta famngechi kimeltuy ta Jesus fentren adkünu dungu mew, femngechi tunten tañi pepi adümael engün. ");
INSERT INTO arnNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Welu chem dungu rume feypikelafuy adkünu dungunngenole tañi kimeltuel mew, welu wichu kom küme kimeltukefi ñi pu disipulu. ");
INSERT INTO arnNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dew punlu feychi antü müten, Jesus feypifi tañi pu disipulu: —Amuiñ ta nometu pichi lafken. ");
INSERT INTO arnNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Feymew elkünutufi engün tati pu che, fey amuy Jesus engün tati farku mew tañi dew mülemum. Fey kakelu farku ka kompañnieeyew. ");
INSERT INTO arnNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Feymew kiñe fütra kürüf triparumey, fey ti rew lafken trilkafkonmekey ti pu farku mew. ");
INSERT INTO arnNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Welu Jesus umawturkey kiñe püle ti wechuñ ti farku mew, reküluwküley kiñe metrül mew. Fey trepelmengey ka feypingey: —¡Kimeltufe! ¿Ngüneduamlaymi am taiñ llañnagmeken? ");
INSERT INTO arnNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus ta witrapüray, fey werküfi tati kürüf, ka feypifi tati lafken: —¡Ñüküfnagnge! ¡Tüngnagnge! Fey ti kürüf tüngnagi ka itrokom fente küme ñüküfkülewetuy. ");
INSERT INTO arnNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Feymew ta Jesus feypifi tañi pu disipulu: —¿Chem mew anta fente llükaleymün? ¿Petu küme feyentulaymün am? ");
INSERT INTO arnNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Welu kisu engün ta rume llükalewey, ka welukonkechi ramtuwi engün: —¿Iney ürke anta tüfachi wentru kenü ti kürüf ka lafken kütu ta müngeltueyew? ―pi. ");
INSERT INTO arnNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Puwi engün nometu pichi lafken, Gadaramapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nagpulu müten ta Jesus tati farku mew, fülkontupaeyew kiñe konweküfülechi wentru. Fey tüfachi wentru tripapay eltun mew, ");
INSERT INTO arnNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","mülentukerkelu am tüfey mew. Iney no rume pepi trariniekerkelaeyew, kadena mew no rume. ");
INSERT INTO arnNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Fentren rupachi dew trariñmangekerkefuy tañi namun ka ñi kuwü kadena mew, welu rumel katrükakerkefuy femngechi ta iney no rume pepi ngünekerkelafeyew. ");
INSERT INTO arnNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Miyawüntukerkey antü ka pun ti wingkul püle ka ti pu küfwe la mew, wirarkiyawkey ka kisutu wülelkawkerkey ta kura mew. ");
INSERT INTO arnNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Welu alü kamapu pefilu ta Jesus, lefkülen wütupafi, fey lukutupay kisu tañi inafül mew, ");
INSERT INTO arnNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","fey wirarkülen feypifi ta Jesus: —¡Kontupakeeli ta iñche, Jesus, fütra pepiluwünngechi Ngünechen tañi Fotüm! ¡Llellipuaeyu Ngünechen mew tami kutrankanoafiel! ");
INSERT INTO arnNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Fey tüfa famngechi dunguy, Jesus am ta feypietew: —¡Weküfü, tripatunge ta tüfeychi wentru mew! ");
INSERT INTO arnNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Fey Jesus ramtufi ti konweküfülelu: —¿Iney pingeymi am? Fey kisu llowdunguy: —Lekion pingen, rume fentrenngelu am ta iñchiñ. ");
INSERT INTO arnNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Fey ti pu weküfü rume llellipueyew ñi wemünentunoaetew tiyechi trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ka tiyechi wingkul ñi fül püle, rume fentren sañwe mülerkey ütayawlu, ");
INSERT INTO arnNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","feymew tati pu weküfü llellipueyew: —Werkümuiñ tati pu sañwe mew ka elumuiñ taiñ konpuael kisu engün mew. ");
INSERT INTO arnNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Feymew Jesus elufi tañi femael engün, fey tati pu weküfü tripatuy engün tati wentru mew, fey konpuy engün tati pu sañwe mew. Fey tüfa engün, ta epu warangka ürke, fey leftukuwpuy engün ti pichi lafken mew, fey tiye mew itrokom ta ürfipuy ti pu sañwe. ");
INSERT INTO arnNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Fey tati pu kuydasañwepelu lefmawi, fey amuy engün ñi nütramyemeael waria mew ka kangelu lof mapu püle ñi femngechi dungu ñi rupan. Fey ti pu che küpay engün ñi pepayael ti rupaelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Fey akulu engün chew tañi mülemum ta Jesus, pepafi engün ñi anületun, ka ñi tukuluwkületun ka ñi küme tüngduamkületun tati kontuniekefetew fentren weküfü. Fey ti pu che rume llükalerkey, ");
INSERT INTO arnNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ka tati pu che pefilu ñi rupan tüfeychi dungu tati konweküfülelu mew ka ti pu sañwe mew, fey nütramelfi engün tati kakelu pu che. ");
INSERT INTO arnNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Feymew eluwi engün tañi llellipuafiel ta Jesus ñi amutuael kañpüle kangelu lof mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Fey Jesus wiñotulu ti farku mew, fey tati konweküfülekefuchi wentru llellipueyew tañi eluafiel ñi miyawael Jesus engün. ");
INSERT INTO arnNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Welu Jesus elulaeyew ñi femael, fey feypieyew: —Amutunge tami ruka mew, tami pu reñma mew, ka nütramelputuafimi itrokom ñi chumel ta Ñidol, ka chumngechi tami kutranduamyeetew ta eymi. ");
INSERT INTO arnNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Fey tati wentru amutuy, fey eluwi tañi nütramyelafiel ti pu waria che mülelu Dekapolis mew ñi chumün ta Jesus kisu mew. Fey itrokom che afmatulewey, kimlu tüfeychi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Fey Jesus nopatulu ti pichi lafken mew, trawüñmaeyew rume fentren che, fey kisu mülewey ellakon lafken. ");
INSERT INTO arnNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Feymew akuy kiñe tati pu longkolelu ti sinagoga mew, Jayro pingelu, fey pefilu ta Jesus, lukunagpay kisu ñi namun püle. ");
INSERT INTO arnNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Fey Jayro rumeñma llellipueyew: —Iñche ñi ñawe ta epe lay. Küpange tami fampuwülael tami kuwü kisu mew, femngechi tami tremoltuafiel ka ñi mongetuael. ");
INSERT INTO arnNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Fey Jesus amuy ta kisu engu, ka fentren che ta kompañnieeyew. Welukon tenfiwi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Rangi tati pu che amulerkey kiñe domo. Dewma mari epu tripantu kutrankülerkey; kachükerkelay ñi mollfüñ ñi kuerpu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Rume kutrankawürkey. Fentren lawentuchekelu mew ruparkey, ka itrokom ñi nieñmufel kullirkey, welu pichi no rume tremorkelay. Ñi tremoafel, doy amuley ñi wesalkalen. ");
INSERT INTO arnNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Allkülu ñi nütramyengen ta Jesus, fey rangi che tüfachi domo ta fülkontupufi ta Jesus furi püle, fey idañmafi tañi takuwün, ");
INSERT INTO arnNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","famngechi rakiduamlu am: “Idañmafili müten Jesus tañi tukuwün, tremolewetuan” pirkey ñi rakiduam. ");
INSERT INTO arnNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Feychi lelen mew müten, tañi wütrulekechi mollfüñ kachütuy, fey kangentuwi tañi kuerpu mew dew tañi tremoletun ñi kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Fey Jesus, ngüneduamlu kisu ñi pepiluwün mew ñi tremoltun ta kiñe che, wiñokintuy tañi adkintuafiel tati pu che, fey ramtuy: —¿Iney anta idakünuñmapeenew tañi takuwün? ");
INSERT INTO arnNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Fey ñi pu disipulu ta feypieyew: —Tati pu che ta wall püle tenfikapeeymew, fey ramtuymi, ‘¿Iney anta idakünupeenew?’ pimi. ");
INSERT INTO arnNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Welu Jesus amuley ñi adkintun wall püle, tañi peafiel iney tañi idakünupeetew. ");
INSERT INTO arnNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Feymew tati domo, yafyafkülen ñi llükan mew, fey kimlu am tañi femngechi femün ta kisu, fey amuy ñi lukutupuael kisu ñi inafül mew, fey nütramelfi kom rüf dungu chem mew ñi idakünufiel. ");
INSERT INTO arnNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Fey Jesus feypieyew: —Papay, tami feyentun mew ta tremotuymi. Küme tüngduamkechi amuñmutunge. Dew tremolewetuymi tami kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Petu tañi dungumeken ta Jesus, fey akuyey ta kiñeke wentru tuwlu Jayro ñi ruka mew, tañi feypipayafiel ta Jayro: —Tami ñawe ta dew lay. ¿Chumael anta aporiamekefimi tami küpalafiel tati Kimeltufe? ");
INSERT INTO arnNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Welu Jesus duamkünulay tañi feypingepan ta Jayro, tati longkolelu ta sinagoga mew. Feymew Jesus feypifi tati longko: —Llükakilnge. Feyentulenge müten. ");
INSERT INTO arnNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Fey Jesus elulafi kakelu pu che ñi kompañpuwülaetew Jayro ñi ruka mew, welu Pedro müten Santiaw ka Juan, Santiaw tañi peñi. ");
INSERT INTO arnNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Fey puwlu engün ta Jayro ñi ruka mew ka pepufilu ti pu che tañi wakeñkülen ñi ngüman engün, ");
INSERT INTO arnNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","konpuy ka feypifi ti pu che: —¿Chem mew anta fente ngümakawmekeymün? Feyti pichidomo ta re umawküley müten tati. ");
INSERT INTO arnNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Fey ti pu che ayeñeeyew engün, welu Jesus feypifi ti pu che tañi tripayael wekuntu ruka. Fey tati ngen ñawe ka tati ngen püñeñ ka ñi pu kompañnieetew, konpuy chew ñi mülemum tati pichidomo. ");
INSERT INTO arnNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Fey nüñmapufi tañi kuwü ti pichidomo ka feypifi: —Talita kum (fey tüfa ta feypin ürke: “Pichidomo, eymi ta feypipeeyu, witratunge”). ");
INSERT INTO arnNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Feychi lelen mew müten, tati pichidomo, nielu mari epu tripantu, witratuy ka trekatuy. Fey ti pu che rume afmalewey engün. ");
INSERT INTO arnNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Welu Jesus feypikünufi ti pu che iney no rume tañi nütramelngenoael tüfachi dungu, feymew ka werküy ñi elungeael iyael tati pichidomo. ");
INSERT INTO arnNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus tripatuy tiye mew, fey amutuy kisu ñi tuwmumchi mapu mew, fey kiñentrür amuy tañi pu disipulu engün. ");
INSERT INTO arnNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Fey akulu tati ürkütun antü, eluwi tañi kimeltuael tati sinagoga mew. Tati trawülechi pu che, allkütuñmafilu ñi dungun ta Jesus, rume afmatulen ramtuwi engün: —¿Chew anta adümi fentren dungu ta tüfa? ¿Chew anta entuy feychi kimün ka tañi pengelelchi afmanngechi pepiluwün? ");
INSERT INTO arnNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Fey tüfa no am tati dewmarukafe, Maria tañi püñeñ, Santiaw, Jose, Juda, ka Simon engün tañi peñi? ¿Ka mülelay anchi kisu tañi pu deya tüfa mew, iñchiñ mew? Feymew eluwlay engün tañi feyentuafiel. ");
INSERT INTO arnNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Welu Jesus ta feypifi ti pu che: —Kañpüle ta allmalltungekey tañi allkütungeael ta kiñe pelon wentru, welu kisu tañi mapu mew, tañi pu reñma mew ka kisu tañi ruka mew femngekelay. ");
INSERT INTO arnNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Fey Jesus pepi pengel-lay ta tiye mew kiñe afmatufal pepiluwün no rume, welu kiñe mufün kutran mew müten ta fampuwüli ñi kuwü tañi tremolafiel. ");
INSERT INTO arnNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ka rume rakiduameleyew ta Jesus ñi feyentunoetew mew ti pu che. Jesus miyawentuy kom fülküleyechi rukache püle, fey kimeltuyawüli ti küme dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mütrümfi tati mari epu disipulu, fey eluwi tañi werküafiel re epuke. Eluyefi ta pepiluwün ñi wemünentuafiel kom weküfü. ");
INSERT INTO arnNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Fey feypifi tañi yenoael chem no rume ta rüpü mew, welu tañi yeael retrü müten. Tañi yenoael ta folson, rokiñ no rume, ka pülata no rume. ");
INSERT INTO arnNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Feley tañi tukuael engün okota, welu tañi yenoael mudaw takuwün. ");
INSERT INTO arnNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Fey feypikünufi ñi pu disipulu: —Fey konpulmün ta eymün kiñe ruka che mew, mülewemün tüfey mew, kañpüle amutualmün wüla. ");
INSERT INTO arnNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Chew rume ta llowngenolmün ka allkütuñmangenolmün rume tamün dungu, wiñomeaymün ta tiye mew ka mütrowaymün tamün namun mew mülechi trufür, femngechi tañi ngüneduamael engün tamün llownoetew mew. ");
INSERT INTO arnNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Feymew tripay tati pu disipulu tañi feypiafiel tati pu che tañi wiñorakiduamtuael engün ta Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ka femngechi wemünentuy engün fentren weküfü, ka tukulelyefi engün aseyte rume fentren kutran, fey tremoyetufi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tati longko ülmen Erode allküy tañi nütramyengen ta Jesus, kom püle kimngey tañi nütramyengen mew ti afmafal pepiluwün ñi nien. Erode kay ta feypirkey: “Juan ti Fawtisachefe ta wiñomongetuy, feymew niey ta tüfachi afmatufal pepiluwün.” ");
INSERT INTO arnNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ka kiñekentu feypirkey: “Fey tüfa tati pelon wentru Elia pingekelu.” Ka kiñekentu feypirkey: “Kiñe pelon wentru tati. Kuyfi mew mülekechi pu pelon wentru reke feley.” ");
INSERT INTO arnNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Welu Erode, allkülu ta tüfachi dungu, feypirkey: “Fey tüfa ta Juan tati. Iñche werkün tañi katrüñmangeael tañi longko, fey wiñomongetuy tati.” ");
INSERT INTO arnNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Fey Erodia ñi duam ürke, Erode werkürkey ñi püresukünungeael ta Juan ka ñi traringeael ta kadena mew, fey ñi tukungeael ta karsel mew. Erodia am ta Felipe ñi kure ürkefel, Erode tañi peñi, welu Erode ta müntukurerkefi tañi peñi. ");
INSERT INTO arnNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Fey Juan feypirkefuy ta Erode: “Kümelay tami müntuñmafiel ñi kure tami peñi.” ");
INSERT INTO arnNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Feymew ta Erodia üdekefuy ta Juan, fey küpa langümkefuy, welu pepilkerkelafuy. ");
INSERT INTO arnNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erode rume llükakerkefi ta Juan, kimniefilu am tañi rume nor wentrungen ka ñi lif mongenngen, feymew ingkañpekefuy. Fey allküñmafiyüm ñi ngülam, pekelafuy ñi chem chumael, fey Erode rume küme duamkechi allkütuñmakefi ñi nütram ta Juan. ");
INSERT INTO arnNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erode tañi kawiñ puwültripantun nielürkefi kiñe ilelkawün tañi pu longkolechi wentru ka ñi pu longkoleyechi pu soltaw ka ti pu ülmenke wentru tuwlu ta Galilea. Fey Erodia feychi antü allmalltuy ñi langümfalafiel ta Juan. ");
INSERT INTO arnNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Feymew Erodia tañi domo püñeñ konpurkey chew tañi mülemum tati kawiñ, fey faylapurkey. Fey Erode ka tati pu mangel traf imekelu rume ayüy engün tati üllchadomo ñi faylan, fey Erode feypifi tati üllchadomo: —Chem rume ta ‘eluen’ pieli, iñche ta eluaeyu. ");
INSERT INTO arnNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mufü rupachi ta kuyalltulelfi tañi eluafiel chem rume ta “eluen” pielieyew, rangiñ ñi nieelchi chemkün kütu. ");
INSERT INTO arnNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Fey ti üllchadomo tripapatulu, ramtufi tañi ñuke: —¿Chem am eluen piafuiñ? Fey ñi ñuke llowdungueyew: —‘Eluen Juan ti Fawtisachefe ñi longko’ pifinge. ");
INSERT INTO arnNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Feymew tati üllchadomo matukel konputuy chew ñi mülemum tati longko ülmen, fey feypipufi: —Duamnien pürümkechi tami eluafiel kiñe rali mew Juan ti Fawtisachefe tañi longko. ");
INSERT INTO arnNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tati longko ülmen ta rume weñangkülewey, welu dew kuyalltun dungun mew am feypikünulu tañi pu mangel tañi adkiñ mew, ngünewlay tañi elunoafiel ñi eluen pietew. ");
INSERT INTO arnNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Feymew müten werküy kiñe soltaw fey ñi katrüpelngeael ta Juan, fey ñi küpalelngeael ti üllchadomo. ");
INSERT INTO arnNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Fey amuy tati soltaw karsel mew, katrüñmapufi ñi longko ta Juan, fey küpalfi kiñe rali mew ka elupafi tati üllchadomo, fey kisu chalintukulelfi tañi ñuke. ");
INSERT INTO arnNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan tañi pu kompañ kimi engün ñi langümngen ta kisu, fey amuy engün ñi yemetuafiel ti kuerpu, tañi rüngalafiel engün. ");
INSERT INTO arnNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Rupalu kom tüfachi dungu, tati pu apostol trawüluwi Jesus engün, fey nütramelpatufi kom tañi chumün engün ka tañi kimeltuel. ");
INSERT INTO arnNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesus ta feypieyew: —Küpamün. Amuiñ iñchiñ kisu taiñ pichi kansatuael wichu püntütripalechi lelfün mew. Rume fentren che puwpuwngelu am kisu engün mew, feymew pepi ilayngün rume. ");
INSERT INTO arnNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Feymew Jesus ka tañi pu apostol konpuy engün ta kiñe farku mew, fey amuy engün kiñe alü tripalechi lelfün mew, ");
INSERT INTO arnNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","welu fentren che peeyew engün tañi amun, ka femngechi kimngey ñi puwael tiye mew. Fey fill waria mew mülechi pu che lefkülen amuy ñi wallmeael ti pichi lafken mew, feymew wüne puwi ti trokiñche kisu engün mew. ");
INSERT INTO arnNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nagpulu müten ta Jesus ti farku mew, pepufi tati fütra trawün che, fey kutranduamyefi ta tüfeychi pu che. Kiñe kechan ufisa reke feley engün ngenolu am iney no rume tañi adnieaetew, feymew Jesus eluwi tañi kimeltuafiel fentren dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Fey pu trafialu, tañi pu disipulu fülkontueyew ka feypieyew engün: —Dew pu trafiay tati, ka tüfachi lelfün mew ngelay chem rume. ");
INSERT INTO arnNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chalitufinge tati pu che, tañi amuael engün kañpüle ka fülkülechi waria mew tañi ngillañmuael engün tañi iyael. ");
INSERT INTO arnNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Fey Jesus ta llowdungufi ñi pu disipulu: —Eymün eluafimün ta iyael. Feymew kisu engün ta llowdunguy: —¿Rume fentren pülata mew may ngillapeafuiñ ta kofke, taiñ eluafiel ñi iyael kom tüfachi pu che? ");
INSERT INTO arnNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Fey Jesus feypi: —¿Tunten kofke am nieymün ta eymün? Amumün tamün pemeael tunten kofke tamün nieel. Fey dew rupan pemelu engün, feypingey ta Jesus: —Kechu kofke ka epu challwa müley. ");
INSERT INTO arnNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Feymew Jesus feypifi ñi pu disipulu ñi feypiafiel ti pu che ñi anükünuwael ka ñi wichuke trokiñkünuwael engün ti kachu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Fey wichuke trokiñ mew anükünuwyey engün. Kiñeke trokiñ niey pataka che, fey kakelu trokiñ kechu mari che. ");
INSERT INTO arnNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Feymew müten ta Jesus nüfi ñi kuwü mew tati kechu kofke ka tati epu challwa, fey pürakintulen wenu mew, mañumtufi ta Ngünechen. Fey wükayefi tati kofke ka eluyefi tañi pu disipulu tañi eluyeafiel engün tati pu che. Ka femngechi wüdamkafi tati epu challwa kom tüfeychi pu chengealu. ");
INSERT INTO arnNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Itrokom iyey engün ka itrokom küme weday engün, ");
INSERT INTO arnNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ka apolyetuy engün mari epu kanasta tati puchuyechi wükan kofke ka tati challwa mew. ");
INSERT INTO arnNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tati iyelu ta tiyechi kofke, kechu warangka wentru ürke. ");
INSERT INTO arnNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Fey dew rupalu kom tüfachi dungu, Jesus feypifi tañi pu disipulu ñi konpuael engün ti farku mew, fey ñi wüne nopuael engün nometu ti lafken mew fey ñi puwael engün Betsayda, welu Jesus petu chalimeketufi tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Fey dew chalitufilu ti pu che, amuy ta wingkul mew ñi ngillatumeael. ");
INSERT INTO arnNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Fey dew punlu, tati farku rangi lafken amulewiyerkey. Jesus am ta kisulewelu tati lelfün mew, ");
INSERT INTO arnNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","pefi tañi küdawngechi amulnien tañi farku engün. Fey ti kürüf am ta trafyenieetew, feymew newe matu amulay tati farku. Fey wünlu dewma, Jesus trekalen amuy wente ko kisu engün püle, welu kisu wüne rumealu reke femfaluwi. ");
INSERT INTO arnNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Feymew ti pu disipulu pefilu engün tañi trekalen ta wente ko, kiñe perimontun trokifi engün, feymew wirari engün. ");
INSERT INTO arnNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kom kisu engün pefilu am, rume llükay engün. Welu feymew müten Jesus feypieyew: —¡Yafüluwmün! Iñche tati. ¡Llükakilmün! ");
INSERT INTO arnNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Feymew Jesus pürapuy tati farku mew, fey tüngnagtuy tati kürüf. Fey ti pu disipulu ta rume afmatulewey ");
INSERT INTO arnNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ngüneduamnofilu engün am tati pengelelchi pepiluwün tati kofke mew, dumiñmalelu reke engün am tañi kimün. ");
INSERT INTO arnNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nopuy engün tati pichi lafken mew, fey puwi engün ta Genesaret mapu mew, fey üye mew trarintukukünupuy engün tañi farku inaltu ayliñ mew. ");
INSERT INTO arnNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Fey nagpulu müten engün tati farku mew, tati pu che kimfemtufi engün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Fey kom che mülelu feychi trokiñ mapu mew, lefkiyawi engün tañi küpalael ñi kutran pichike ngütantu mew, fey yelelfi engün chew tañi mülemum ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Chuchi mew ngeay rume konpuyüm ta kisu, lelfün trokiñ ruka che mew rume, pu waria mew ngeay rume kam lelfün mew rume, elkünukey engün tañi pu kutran inaltu rüpü. Fey ti pu che llellipukefi ta Jesus ñi idañmayaetew tañi takuwün kiñe wechuñ mew ngeay rume. Fey kom che idafilu Jesus ñi takuwün, tremolewetukey ñi kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fülkonpuy ta Jesus mew tati pu farisew, ka kiñeke tati pu kimeltukelu Moyse ñi ley dungu tati küpayelu ta Jerusalen. ");
INSERT INTO arnNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tüfa engün, pefilu Jesus ñi kiñeke pu disipulu tañi imeken engün fey ñi küchanon tañi kuwü, fey ngüneduamfi ñi mupitunofiel ti wimtun dungu ñi wüne küchayafel tañi kuwü, feymew rume nentuüñfilfi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Tati pu farisew am, ka kom ti pu Judiu inanielu engün tañi pu fütakeche em tañi wimtun dungu feypiley tañi inoael engün wüne küme küchanole ñi kuwü. ");
INSERT INTO arnNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Fey wiñomeyüm engün ta merkaw mew, ikelay engün wüne mupitunole ñi wimtun dungu tañi küchakuwüael. Rume fentren wimtun ta niey engün, tañi küchayafiel tati fasu, ka tati kopa, ka tati losa pünepeel ka ti ngütantu.) ");
INSERT INTO arnNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Feymew, tati pu farisew ka tati pu kimeltukelu Moyse ñi ley dungu, ramtufi engün ta Jesus: —¿Chem mew am tami pu disipulu ta müngeltukelay engün iñchiñ taiñ fütakeche em tañi wimtun dungu? Podkülen tañi kuwü ikey engün. ");
INSERT INTO arnNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Fey Jesus ta llowdungueyew: —Fente küme mupituy ñi piel mew tati pelon wentru Isaia tamün koyla ngünen chengen. Feychi wirintukulu feypi: ‘Fey tüfachi trokiñche ta poyekeenew re wenche wün mew müten, welu ta konpiwke mew poyenielaenew engün. ");
INSERT INTO arnNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Chem falilay rume tañi püramyemekeaetew engün: tañi kimeltukeel engün re che tañi pepikaelchi werkün dungu müten.’ ");
INSERT INTO arnNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Eymün am elkünukelu Ngünechen tañi werkün dungu tamün müngeltuafiel re che müten tañi wimtun dungu: tamün küchayafiel tati pu fasu, ka ti pu kopa, ka femngechi müngeltukefimün fentren kakelu wimtun dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ka femngechi feypi ta Jesus: —Tamün elkünunoafiel eymün tamün wimtun dungu, eymün ta falintukelafimün Ngünechen tañi werkün dungu ");
INSERT INTO arnNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moyse ta feypirkey: ‘Yamfinge tami chaw ka tami ñuke’, fey ‘Tati wesapifilu tañi chaw ka tañi ñuke, fey ta kondenaley ñi langümngeael.’ ");
INSERT INTO arnNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Welu eymün ta feypikeymün kiñe wentru tañi feypiafiel tañi chaw kam tañi ñuke: ‘Ngelay tami kelluafiel, kom tañi nieel am ta iñche korfan tati’ (tüfa ta feypin ürke: “dew chalintukunielfiñ ta Ngünechen”). ");
INSERT INTO arnNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tüfey engün tati femngechi feypikelu ngelay chem aporiawün no rume tañi kelluafiel tañi chaw kam tañi ñuke rume. ");
INSERT INTO arnNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Fey tüfa famngechi ta eymün falintukelafimün ta Ngünechen ñi werkün dungu fey tüfachi wimtun mew tamün kimeluwkeel welukonkechi. Ka femkeymün fentren kakelu femngerumechi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Feychi lelen mew müten ta Jesus mütrümfi tati pu che ka feypifi: —Küme allkütumuchi, ka longkontukuaymün: ");
INSERT INTO arnNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Chem iyael rume ile ta che, yafkalayafuy. Welu ti wesa dungu piwke mew tripalu, fey ta yafkan mew tukukefi ta che. ");
INSERT INTO arnNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Iney rume ayüle ñi allkütuael, allkütupe. ");
INSERT INTO arnNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Feymew Jesus elkünutufilu tati pu che, konpuy ta ruka mew, fey tañi pu disipulu ramtueyew tüfachi kimeltun mew. ");
INSERT INTO arnNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Feymew Jesus feypifi tañi pu disipulu: —¿Eymün am longkontukurkelafimün tati dungu? ¿Kimlaymün anta chem iyael rume ile ta che ñi yafkakenon, ");
INSERT INTO arnNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","piwke mew am ta konpukenolu, pütra mew mayfe, femngechi wüla tañi tripatuael ta kuerpu mew? (Fey tüfachi dungun mew ta feypi kom iyael tañi lifngen.) ");
INSERT INTO arnNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ka femngechi feypi: —Piwke mew tripachi dungu, feyke ta wesalkakefi ta che. ");
INSERT INTO arnNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Fey che tañi piwke mew tripakey wesake rakiduam, fill wesake femmeken wentru engu ta domo, tati weñen dungu, tati langümchen, ");
INSERT INTO arnNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tati ñiwaldomon, ka tati diñmatun, tati wesake femün, tati ngünenkachen, tati wesake wimtun, ka tati ütriruwün, ka tati dallukan, tati mallmangen ka nienolu nor rakiduam. ");
INSERT INTO arnNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kom tüfachi wesake dungu tripakey ta piwke mew, fey kisutu wesalkawkey ta che. ");
INSERT INTO arnNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Fey tiye mew tripay ta Jesus ñi amuael Tiro ka Sidon trokiñ mapu mew. Konpuy ta kiñe ruka mew, fey pilafuy iney rume tañi kimael, welu pepi ellka miyawlay tañi pengenoael. ");
INSERT INTO arnNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kiñe domo kontunieñmarkeeyew weküfü tañi domo püñeñ, müchay müten kimi ñi mülepun ta Jesus tüfey mew. Fey tiyechi domo lukutupuy Jesus tañi namun püle. ");
INSERT INTO arnNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Feychi domo ta katripanche ürke, Sirofenisia mew tuwlu. Fey puwi ñi llellipuafiel ta Jesus ñi wemünentulelafiel ti weküfü kisu ñi domo püñeñ mew. ");
INSERT INTO arnNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Welu Jesus ta feypifi tati domo: —Elufinge ta wünelu mew ñi iyael tati pu fotüm, kümenolu am tañi müntuñmangeael tañi kofke tati pu fotüm, fey ñi elungeael tati pu trewa. ");
INSERT INTO arnNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Fey ti domo ta llowdungueyew: —Felelley may, Ñidol, welu trewa kütu ikefuy ta miñche mesa tañi füntülnagümyeel tati pu fotüm. ");
INSERT INTO arnNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Fey Jesus ta feypifi ti domo: —Fente küme dunguymi tati. Fey amutunge. Tati weküfü dew tripatuy tami domo püñeñ mew. ");
INSERT INTO arnNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Fey tati domo puwtulu tañi ruka mew, peputufi tati üllchadomo ñi mülen ta ngütantu mew, welu tati weküfü ta dew tripawiyeturkey tati üllchadomo mew. ");
INSERT INTO arnNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesus ka wiñome tripatuy Tiro trokiñ mapu mew, fey rumerpuy ta Sidon ka ti müleyechi pu waria Dekapolis trokiñ mapu mew, fey puwi Galilea lafken mew. ");
INSERT INTO arnNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Fey tiye mew ta yelelngey kiñe ketrongechi wentru ka pilungelu, fey llellipungey ñi fampuwülelafiel ñi kuwü ta tüfeychi wentru. ");
INSERT INTO arnNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus ta kiñeñpüle nentufi ti wentru, wichukünufi tati pu che mew, fey tukulelfi ñi changüll kuwü tañi pilun mew ka kowün mew ilpuyüñmafi tañi kewün. ");
INSERT INTO arnNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Feymew müten, pürakintulen ta wenu, afküduami, fey feypifi tati wentru: “¡Efata!” (feypin ürke: “¡Nülange!”). ");
INSERT INTO arnNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Feychi lelen mew müten, tati pilulekefulu allkütuy ka küme dungutuy. ");
INSERT INTO arnNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Fey Jesus ta werküfi tañi feypinoafiel engün ta iney no rume, welu kisu engün tunte katrütukünungefuy rume ñi feypinoafel, fey kisu engün amulkünu nütramyeniefi ti dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Fey rume afmatulen mew, feypi engün: “Kom ti dungu ñi femkeel rume kümey. ¡Pilu kütu ta pepi allkültufi ka ti pu dungukenolu, eluyetufi ñi dunguael!” ");
INSERT INTO arnNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kiñe antü ta wiñome trawüluwlu ta rume fentren pu che, fey tüfachi pu che nierkelay engün chem rume tañi iyael. Feymew Jesus mütrümfi tañi pu disipulu, fey feypifi: ");
INSERT INTO arnNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Kutranduamyeniefiñ ta tüfachi pu che. Küla antü dewma ñi mülepan engün tüfa mew, fey chem rume nielay tañi iyael engün. ");
INSERT INTO arnNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Fey ñi inon werküfili engün ñi amutuael tañi ruka mew, rume ngañwadafuy engün ta rüpü mew, kiñekentu ta fütra kamapu küpalu engün am. ");
INSERT INTO arnNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kisu tañi pu disipulu ta llowdungueyew: —¿Chumngechi am elungeafuy iyael engün kiñe famngechi lelfün mew, chew ñi ngenomum kiñe ruka che no rume? ");
INSERT INTO arnNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Fey Jesus ta ramtufi ñi pu disipulu: —¿Mufü kofke am nieymün? —Regle kofke nieiñ ―pi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Feymew Jesus werküy ñi anükünuwael tati pu che pülli mew. Nüfi ñi kuwü mew tati regle kofke. Fey rupan mañumtufilu ta Ngünechen, wükayefi ka eluyefi tañi pu disipulu, fey kisu engün wüdamkalelfi tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ka femngechi nierkey engün kiñe mufü pichike challwa, fey Jesus mañumtufi ta Ngünechen tati pichike challwa mew, ka femngechi werküy tañi wüdamkalelngeael tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kom iyey ka weday engün, fey ka apoyetuy regle kanasta tati sofrayechi kofke ka challwa mew. ");
INSERT INTO arnNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tati iyelu epe meli warangka wentru ürke. Feymew ka müten Jesus chalitufi ti pu che, ");
INSERT INTO arnNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","fey konpuy kiñe farku mew tañi disipulu engün, fey amuy Dalmanuta trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Akuyey tati pu farisew, fey eluwi tañi notukadunguafiel engün ta Jesus, femngechi tañi kintukaduamafiel engün tañi welulkawael ñi dungun mew. Fey feypifi engün tañi pengelael kiñe afmatufal dungu femngechi tañi küme kimael engün kisu ñi werküpeetew may ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesus ta afküduami, fey feypieyew: —¿Chem mew anta pengelelngeaiñ kiñe afmanngechi ngünel dungu pipey ta tüfachi pu che? Rüf dungu feypiwayiñ, pengelelngewelayay ta tüfa engün kiñe afmanngechi dungu no rume. ");
INSERT INTO arnNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Feymew Jesus elkünutueyew engün, fey ka wiñome püratuy ta farku mew, fey amutuy ta nometu ti pichi lafken. ");
INSERT INTO arnNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Fey ti pu disipulu ngüyürkey engün tañi yeael alün kofke, fey kiñe kofke müten ta nierkey engün ta farku mew. ");
INSERT INTO arnNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Feymew Jesus ta küme feypikünueyew engün: —Ngüneduamfimün. Kuñiwtuwmün tati pu farisew ñi lefawra mew ka Erode ñi lefawra mew. ");
INSERT INTO arnNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tati pu disipulu welukonkechi nütramkawi engün: “femngechi feypi ta Jesus taiñ nienon mew alün kofke” pi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus ta ngüneduameyew ñi femngechi rakiduamkülen engün, fey feypieyew: —¿Chem mew anta ‘nielaiñ alün kofke’ pipeymün? ¿Petu longkontukulaymün ka ngüneduamlaymün iñche tañi femelchi dungu? ¿Rüf dungu mew anta petu longkontukulaymün? ");
INSERT INTO arnNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Nieymün nge, welu pelolaymün, ka nieymün allküam, welu allkülaymün? ¿Fey tukulpalaymün am? ");
INSERT INTO arnNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Feychi wüdamkafilu iñche tati kechu kofke tati kechu warangka pu che mew, ¿tunten kanasta am apolyetuymün ti sofrachi kofke ka challwa mew? Fey kisu engün ta llowdunguy: —Mari epu kanasta. ");
INSERT INTO arnNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ka feychi wüdamkalu iñche tati regle kofke meli warangka pu che mew, ¿tunten kanasta apoltuymün ti sofrachi kofke ka challwa mew? Fey llowdunguy engün: —Regle kanasta. ");
INSERT INTO arnNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Feymew feypingey engün: —¿Petu anta ngüneduamlaymün? ");
INSERT INTO arnNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Feymew ka puwi engün ta Betsayda waria mew, fey puwülelngey ta kiñe trawma ta Jesus mew, fey llellipungey tañi tremolafiel. ");
INSERT INTO arnNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus küñatuentufi ti trawma wekuntu waria. Fey ilpuyüñmafi ñi nge kowün mew, fey fampuwülelfi tañi kuwü ñi nge mew, fey ramtufi tañi aymüñ pichi pelotun. ");
INSERT INTO arnNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tati trawma allwe pichi pelotulu, fey feypi: —Pefiñ tati pu che. Trekayawchi anümka reke trokiniefiñ. ");
INSERT INTO arnNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus ka fampuwülelfi tañi kuwü ñi nge mew, fey ti wentru küme adkintuy, fey tremolewetuy. Fey kom chemkün fente küme penietuy. ");
INSERT INTO arnNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Feymew Jesus werküfi ñi amutuael tañi ruka mew, fey ka feypifi: —Wiñokontukilnge waria mew ka feypilayafimi iney no rume mülelu ti pichike trokiñ ruka che mew. ");
INSERT INTO arnNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Dew rupalu kom tüfachi dungu, Jesus ka tañi pu disipulu amuy engün tati lof ruka che mew müleyelu Sesarea Filipo trokiñ mapu mew. Fey amulelu rüpü mew, Jesus ramtufi tañi pu disipulu: —¿Iney pikeenew am iñche tati pu che? ");
INSERT INTO arnNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Fey kisu engün llowdungueyew: —Kiñekentu ta feypikey ‘Juan ti Fawtisachefe tati’ pikeeymew, ka kiñekentu ‘Elias’ pikeeymew, fey kakelu feypikey ‘kiñe tati pu pelon wentru’ pikeeymew. ");
INSERT INTO arnNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Fey eymün kay, ¿iney pimuken? ―ramtungeyngün. Fey Pedro llowdungueyew: —Eymi lle tati Cristo pikeel. ");
INSERT INTO arnNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Welu Jesus ta feypikünufi ñi pu disipulu tañi feypinoafiel engün chem che rume kisu tañi Cristongen. ");
INSERT INTO arnNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesus eluwi ñi kimeltuafiel tañi pu disipulu ñi rume kutrankawael ta Ngünechen ñi Fotüm, ka tañi illamtukayaetew tati pu putrem fütakeche, tati longkolelu pu saserdote mew ka ti pu kimeltukelu Moyse ñi ley dungu. Feypifi tañi langümngeael, welu ñi wiñomongetuael küla antüalu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Fey tüfachi dungu ta wünelu mew fente küme feypifi. Feymew Pedro wichunentueyew, fey eluwi tañi katrütudunguaetew. ");
INSERT INTO arnNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Welu Jesus wiñokintuy, fey leliwülfi tati pu disipulu, feymew katrütudungufi ta Pedro, feypilen mew: —¡Kiñe püle tripange ta iñche mew, weküfü! Eymi ta ngüneduamkelafimi tati dungu chumngechi ngüneduamniey ta Ngünechen, welu may chumngechi peniey re che müten. ");
INSERT INTO arnNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Feymew müten ta Jesus mütrümfi tañi pu disipulu ka tati pu che, fey feypifi: —Iney rume ta ayülele iñche ñi disipulungeael, kisutu ngüyünentuwpe, ka eluwkülepe ñi kutrankawael iñche reke, fey inaechimew. ");
INSERT INTO arnNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tati ayülu ñi montulael tañi mongen, montul-layafi, welu tati ütrüflu tañi mongen iñche ñi duam ka tati montuluwün dungu tañi duam, fey ta montulay ñi mongen. ");
INSERT INTO arnNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Chem entuafuy anta che ngenngele kom mapu mew mülechi chemkün, fey penole ta rumel mongen? ");
INSERT INTO arnNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Fey ka femngechi, ¿tunten chey kulliafuy ta che kisu tañi mongen mew? ");
INSERT INTO arnNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Iney rume ta yewentukuelimew ta iñche ka tañi werken dungu yewentukuñmaelimew tüfachi nor dungungenochi yafkafe pu che ñi adkiñ mew, ka femngechi tati Wentrukünuwpalu yewentukuaeyew küpale tañi Chaw ñi fütra küme pepiluwün mew ka ti pu werken püllü mew ―pi. ");
INSERT INTO arnNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesus ka femngechi feypi: —Rüf dungu feypiwayiñ kiñeke tati müleyelu fey tüfa mew lalayay engün pefile wüla ta Ngünechen tañi longko ülmenngen ñi pewfaluwael fentren pepiluwün mew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Fey rupalu kayu antü, Jesus amuy ta kiñe alü pürachi fütra wingkul mew. “Amuiñ” pifi ta Pedro, Santiaw, ka Juan müten. Tiye mew kisu engün tañi adkiñ mew, kangewerumetuy ñi felen ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tañi takuwün ta wilüfütuy ka doy fülangtuy iney rume ta fente lingarkünulayafuy tunte küme küchakayafuy rume. ");
INSERT INTO arnNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Fey ti küla disipulu pefi engün ta Elia ka Moyse, nütramkamekelu ta Jesus engün. ");
INSERT INTO arnNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Feymew Pedro feypifi ta Jesus: —Kimeltufe, ¡müna kümey taiñ mülepan! Dewmayaiñ ta küla pichike ruka: kiñe eymingealu, Moysengealu ka kiñe Eliangealu. ");
INSERT INTO arnNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tati pu disipulu rume llükalelu engün am, fey Pedro kimlay tañi chem piael. ");
INSERT INTO arnNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Feychi lelen mew, kiñe tromü nagpay fey munulpaeyew kiñe llawfeñ reke. Feytichi pu tromü mew allküngey kiñe dungun, feypilu: “¡Fey tüfa ta iñche ñi sakin Fotüm: allkütuñmafimün ta kisu müten ñi dungun!” ");
INSERT INTO arnNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Feychi lelen mew müten, adkintulu engün ta wall püle, Elia Moyse engu pengewetulay. Jesus kisulewetuy. ");
INSERT INTO arnNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Fey nagkülepatulu engün tati wingkul mew, Jesus feypifi ñi küla disipulu ñi nütramelnoafiel iney no rume tañi peel engün, wiñomongetule wüla ti Wentrukünuwpalu. ");
INSERT INTO arnNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Feymew kisu engün müten piwkentukuniefi tüfachi dungu, tunte welukonke ramtuwkefuyngün rume ñi chem pifel tati wiñomongetun dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ramtufi engün ta Jesus: —¿Chem mew am feypikey tati pu kimeltukelu ta Moyse ñi ley dungu Elia tañi wüne küpayael? ");
INSERT INTO arnNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Fey Jesus ta llowdungueyew: —Rüfngey ta Elia ñi wüne küpayael, ka kisu ñi küme eltuael kom dungu. ¿Fey chem mew am feypiley tati Wirin Chillka ñi kutrankawael tati Wentrukünuwpalu ka tañi illamngeael? ");
INSERT INTO arnNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Welu iñche ta feypiwayiñ Elia ta dew küpay, fey ti pu judiu fill wesa femfi engün kom tañi ayüel chumngechi ñi feypilen ta Wirin Chillka Elia ñi rupan tüfeychi wesake dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Fey wiñotulu engün chew tañi mülemum ti kakelu pu disipulu, peputufi engün ñi rangiñmanieetew ta fentren pu che, ka kiñekentu tati pu kimeltukelu Moyse ñi ley dungu ñi notukadungumekeetew engün. ");
INSERT INTO arnNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pengelu ta Jesus, kom lef amuy engün tañi chalimeafiel rume afmatulen mew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Fey Jesus ramtufi ti pu che: —¿Chem dungu mew anta notukadunguwmekewimün ta tüfachi pu wentru eymün? ");
INSERT INTO arnNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kiñe tati mülelu feymew llowdungueyew: —Kimeltufe, tüfa ta küpalelpeeyu iñche tañi fotüm, kontunieeyew ta kiñe weküfü fey ta ketrolnieeyew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chuchi mew rume müleyüm, nükeeyew tati weküfü. Trananagümkeeyew ta pülli mew ka trorfan entupakey kowün tañi wün mew. Kütrürülkey ñi foro, fey mütrengkülewekey. Tami pu disipulu feypipefuiñ engün tañi wemünentulelafiel tati weküfü, welu pepi wemünentulafi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Fey Jesus ta llowdunguy: —¡Mupiltunngenochi pu che! ¿Tunteñma anta mülerkean ta iñche eymün mew? ¿Tuntepu mew wüla anta tüngkülewerkean ta iñche? Küpalfimün faw püle tati pichiwentru. ");
INSERT INTO arnNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Feymew yengey tati pichiwentru Jesus mew. Welu tati weküfü, pefilu ta Jesus, lalatulfi ti pichiwentru, fey ka tranapuwi pülli mew. Imülkawi, ka trorfan entupay kowün tañi wün mew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Fey Jesus ramtufi tati ngen fotüm: —¿Tunteñma am dewma tañi femken tüfa famngechi? Fey ti ngen fotüm llowdungueyew: —Pichichengelu ñi femrumen. ");
INSERT INTO arnNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Fentren rupachi ta feychi weküfü tranapuwülkeeyew ta kütral mew ka ko mew tañi langümaetew. Feymew, pepilfulmi eymi, kutranduamyemuiñ ta iñchiñ ka kellumuiñ. ");
INSERT INTO arnNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Fey Jesus ta feypifi ti ngen fotüm: —¿Chumngechi am pepilfulmi pimi? ¡Kom pepilfali tati feyentulu mew! ");
INSERT INTO arnNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Feymew tati pichiwentru ñi chaw wirari: —Iñche ta feyentun. ¡Kelluen tañi doy feyentuael! ");
INSERT INTO arnNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Fey Jesus ngüneduamlu tañi trawüluwmeken ta rume fentren pu che, wemünentufi tati weküfü, feypilen mew: —Ketrongechi weküfü ka pilungelu, iñche ta werküaeyu tami tripatuael ta tüfachi pichiwentru mew ka tami wiñokonmeketunoael ta kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Feymew ti weküfü wirari, ka kiñe rupachi lalatulfi tati pichiwentru. Feymew müten tripatuy ta kisu mew. La reke femkünufi, fey rume fentren che ta feypiyey “dew lay tati” pi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Welu ta Jesus, nükünufi ta kuwü mew, witrañpüramfi, fey tati pichiwentru witrapüratuy. ");
INSERT INTO arnNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Feymew müten ta Jesus konpuy ta kiñe ruka mew, fey tañi pu disipulu wichu kafkü dungun mew ramtueyew: —¿Chem mew anta iñchiñ pepi wemünentulafiyiñ ta tüfeychi weküfü? ");
INSERT INTO arnNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Fey Jesus ta llowdungufi ñi pu disipulu: —Fey tüfa famngechi weküfü pepi wemünentungeafuy re ngillatun ka ayuno mew müten. ");
INSERT INTO arnNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Fey tripatulu tiye mew, rumerpuy engün ta Galilea, welu Jesus pilay iney no rume tañi kimael, ");
INSERT INTO arnNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kimeltumekefilu am tañi pu disipulu. Ka feypimekefi: “Tati Wentrukünuwpalu chalintukungeay tüfachi mapu mew mülechi pu che mew ka langümngeay. Welu küla antüalu mew wiñomongetuay.” ");
INSERT INTO arnNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kisu engün kimürkelay chem dungu ñi feypimeken ta kisu, ka llükalerkey engün tañi ramtuafiel. ");
INSERT INTO arnNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Fey puwi engün ta Kapernaum waria mew. Dew mülepulu ta ruka mew engün, Jesus ta ramtufi tañi pu disipulu: —¿Chem dungu mew am notukawkülen küpalepeymün ta rüpü mew? ");
INSERT INTO arnNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Welu chem pilay rume engün, kisu engün am notukawlu ta rüpü mew iney müngell tañi longkoleael kisu engün mew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Feymew ta Jesus anükünuwi, mütrümfi tati mari epu disipulu, fey feypifi: —Iney rume ayüle tañi longkoleael, feley tañi doy ñom piwkengeael kom kakelu mew, ka ñi eluwküleael ñi poyeafiel ta itrokom che. ");
INSERT INTO arnNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Feymew müten witrakünufi kiñe pichiwentru kisu engün ñi rangiñ mew, fey nükünufi ñi kuwü mew ka feypi: ");
INSERT INTO arnNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Iney rume llowfile kiñe pichiche tüfa reke iñche tañi üy mew, iñche ta llowaenew. Ka tati llowetew ta iñche, iñche müten ta llowlayaenew, welu may ka femngechi llowafi iñche tañi werküetew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan ta feypieyew: —Kimeltufe, pefiyiñ ta kiñe che wemünentuweküfükelu eymi tami üy mew, fey miyawkenolu am iñchiñ mew, feymew katrütufiyiñ. ");
INSERT INTO arnNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Feymew Jesus ta llowdungufi ñi pu disipulu: —Katrütukefilmün. Iney rume pengel-le kiñe afmatufal pepiluwün iñche tañi üy mew, wesa dunguyetulayafenew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Taiñ kayñetukenoetew ta iñchiñ, fey ta ingkanieeiñmew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Iney rume eluelmünmew ta eymün kiñe fasu kongeafuy rume tamün inaniefiel mew ta Cristo, rüf dungu feypiwayiñ fey tüfa füreneaeyew ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ka femngechi iney rume yafkangen tukufile kiñeke tüfachi we feyentulelu ta iñche mew, doy kümeafuy trapeltukukünulelngele ñi pel mew kiñe fütra kura, fey tañi ütrüftukungeael ta lafken mew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Tami kuwü ta yafkan mew tukukeelmew, katrünentufinge. Doy kümeay tami nieael kiñe kuwü müten tami konpuael ta rumel mongen mew, welu fey tami nien epu kuwü, mi amuael ta kütral mapu mew, chew chongkelay tati kütral, ");
INSERT INTO arnNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","chew ñi lakenomum ta piru ka ñi chongkenomum ta kütral. ");
INSERT INTO arnNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Fey tami namun yafkan mew yekeelmew, katrünentufinge. Doy kümeay tami nieael kiñe namun müten tami konpuael ta rumel mongen mew, welu fey tami nien epu namun tami ütrüftukungeael ta kütral mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Chew ñi lakenomum ta piru ka ñi chongkenomum ta kütral. ");
INSERT INTO arnNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Fey tami nge yafkan mew tukukeelmew, entufinge eymi mew. Doy kümeay tami nien kiñe nge müten tami konpuael Ngünechen tañi ülmen mülewe mew, welu fey tami nien epu nge mi ütrüftukungeael ta kütral mapu mew ");
INSERT INTO arnNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘chew ñi lakenomum ta piru ka ñi chongkenomum ta kütral.’ ");
INSERT INTO arnNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kom ta alimkangealu am ta kütral mew. Ka kom chalintukuelchi ilo chadiñmangeay. ");
INSERT INTO arnNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Chadi ta kümey, welu kotrüwetunole, ¿chumngechi am pepi wiñome kotrütuafuy ta chadi? Eymün chadi reke felemün ka tüng mongen niemün welukonkechi eymün mew.” ");
INSERT INTO arnNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus tripay ta Kapernaum waria mew, fey amuy Judea trokiñ mapu mew ka ti trokiñ mapu mülelu Jordan lewfü tañi tripawe antü ad püle. Tiye mew ka wiñome trawüluwi tati pu che, fey kisu eluwi tañi wiñome kimeltuafiel, femngechi wimtulelu am. ");
INSERT INTO arnNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fey kiñeke farisew fülkonpuy ta Jesus mew femngechi tañi entuüñfilafiel engün, fey ramtufi engün: —¿Kümey am ñi wüdakureael wentru chem dungu mew rume? ");
INSERT INTO arnNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Fey Jesus llowdungueyew: —¿Chem werkün dungu am elueymünmew ta Moyse? ");
INSERT INTO arnNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kisu engün feypi: —Moyse wüli ti werkün dungu tañi wüdangeael ta kure fey ñi elungeael ta kiñe wirin dungu tañi dew wüdangen. ");
INSERT INTO arnNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Feymew Jesus ta feypieyew: —Moyse ta femngechi feypikünuy tamün rume wesa yafü piwkengen mew ta eymün. ");
INSERT INTO arnNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Welu llituka mew kom dewmangelu, ‘Ngünechen dewmafi ta wentru ka domo.’ ");
INSERT INTO arnNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Feymew ta wentru wichuay tañi chaw mew ka tañi ñuke mew tañi wichu amayewael ñi kure engu, ");
INSERT INTO arnNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","fey mür kiñe che reke ñi feleael engu.’ Fey tüfa famngechi epu che reke mülewetulay engu, fey kiñe che reke müten. ");
INSERT INTO arnNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Fey ngelay tañi wüdamentumekeafiel Ngünechen tañi trapümel. ");
INSERT INTO arnNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dew müleputulu engün ta ruka mew, fey ti pu disipulu wiñome ramtufi ta Jesus fey tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Fey Jesus feypieyew: —Tati wüdalu tañi kure fey ka domo kureyetule, ñiwaldomofengey ñi wüdafiel mew tañi wünen kure. ");
INSERT INTO arnNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Fey tati domo kay wüdakünutule tañi füta, fey fütayetufile kangelu wentru, ka femngechi ñiwafengey. ");
INSERT INTO arnNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yelelngey ta kiñeke pichikeche ta Jesus tañi fampuwülael ñi kuwü ta kisu engün mew, welu tati pu disipulu eluwi engün tañi katrütuafiel tüfey engün tati yeniefilu ti pu pichikeche. ");
INSERT INTO arnNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Fey Jesus, ngüneduamfilu tüfachi dungu, lladküy ka feypifi ñi pu disipulu: —Elufimün tati pichikeche ñi küpayael engün iñche mew. Katrütukefilmün. Tati pichikeche reke femngelu, fey engün koneltuley Ngünechen tañi longko ülmenngen mew. ");
INSERT INTO arnNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Rüf dungu feypiwayiñ tati llownofilu kiñe pichiche reke Ngünechen tañi longko ülmenngen, konpulayay ta Ngünechen ñi mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Fey fülümtukupafi ñi lipang mew ti pichikeche, fey fampuwülelfi ñi kuwü ta kisu, fey ngillatuñmafi. ");
INSERT INTO arnNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Feymew Jesus amulerpulu tañi rüpütulen, lefkülen puwi kiñe wentru, lukunagpuy kisu tañi inafül ka ramtufi ta Jesus: —Lif mongen kimeltufe, ¿chem chuman am tañi llowael tati rumel mongen? ");
INSERT INTO arnNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus ta llowdungueyew: —¿Chem mew anta lif mongen pien? Kiñeley müten ta lif mongenngelu: Ngünechen llemay. ");
INSERT INTO arnNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dew kimimi tati werkün dungu: ‘Langümchekilnge, ñiwaldomokilnge, weñekilnge, üñfitukefilnge ta koylake dungu mew ta iney no rume, ngünenkakilnge rume, ka yamafimi tami chaw ka tami ñuke.’ ");
INSERT INTO arnNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Fey tati wentru feypifi ta Jesus: —Kimeltufe, kom tüfeychi dungu ta femken wechewentrungelu müten ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus leliwüleyew rume piwkeyen mew, fey llowdungueyew: —Kiñe dungu ta petu femlaymi. Amutunge. Fendenge kom tami nieelchi chemkün ka elufinge tati nienolu chem rume. Femngechi ta nieaymi fütra küme felen ta wenu mapu mew. Fey wüla, fey nüaymi tami kürus, küpange ka inayaen. ");
INSERT INTO arnNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Fey ti wentru allkülu tüfachi dungu, rume wesa duami, rume rikulelu am. ");
INSERT INTO arnNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Feymew Jesus adkinturupay wall püle, fey feypifi tañi pu disipulu: —¡Rume küdawngeay ñi konpuael tati nielu fentren chemkün Ngünechen ñi longko ülmenngeelchi mülewe mew! ");
INSERT INTO arnNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Fey tüfachi dungu ta rumeñma afmatulkafi tati pu disipulu, welu Jesus ka wiñome feypifi ñi pu disipulu: —Pu weni, ¡rume küdawngey konpuael Ngünechen ñi longko ülmenngeelchi mülewe mew, feyti pu che maneluwlu ñi fentren chemkün mew! ");
INSERT INTO arnNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Doy küdawngelay ta kiñe kamellu ñi rumeael ti longko akucha mew, fey kiñe riku ñi konael Ngünechen ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Femngechi allkülu ti pu disipulu, doy afmatulewey engün, fey welukonkechi ramtuwi engün: —¿Iney anta pepi monturkeay? ");
INSERT INTO arnNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus ta leliwülfi ñi pu disipulu, fey feypifi: —Che ñi pepilnoel, Ngünechen ta pepilniey. Kisu mew ta ngelay chem no rume ta pepilfalnolu. ");
INSERT INTO arnNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Fey Pedro eluwi tañi feypiaetew: —Iñchiñ ta elkünuiñ itrokom taiñ niekefel, fey inawiyiñ ta eymi. ");
INSERT INTO arnNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus feypifi ñi pu disipulu: —Rüf dungu ta feypian iney rume fey iñche tañi duam ka tati werkün montuluwün dungu ñi duam elkünule ta ruka, kam peñi, kam lamngen, kam chaw, kam ñuke, kam domo, kam fotüm, kam mapu, ");
INSERT INTO arnNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","welu fewla ta tüfachi mapu mew lloway doy pataka rupachi tañi niekefel ta ruka mew, peñi, lamngen, ñuke, fotüm ka mapu, tunte üyawtuniengeay rume. Fey tati we mületuachi mapu mew lloway tati rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Welu fentren che wüneltulelu, inaletuay. Ka fentren che tati pu inalelu, fey ta wüneletuay. ");
INSERT INTO arnNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Trekaley engün ñi amuael ta Jerusalen, fey Jesus ella wüne konküley tañi pu disipulu mew. Kisu engün ta afmatuley, ka tati pu inaleyelu llükaley engün. Jesus ka wiñome mütrümfi tañi wichudunguafiel tati mari epu disipulu, fey llituy tañi feypiafiel ñi rupayael ta kisu fey tüfachi dungu mew: ");
INSERT INTO arnNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Fey fewla amuaiñ ta Jerusalen, chew tañi chalintukungeael tati Wentrukünuwpalu ti pu longkolechi pu saserdote mew ka tati pu kimeltukelu Moyse ñi ley dungu. Fey engün ta kondenayaeyew ñi langümngeael ka chalintukungeay tati pu katripanche mew. ");
INSERT INTO arnNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ayentukangeay ta kisu, tofkütukangeay ka wülelkangeay ka langümngeay. Welu küla antü rupale, wiñomongetuay.” ");
INSERT INTO arnNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Santiaw ka Juan, Sefedew tañi epu fotüm, fülkonpuy engu ta Jesus mew, fey feypifi: —Kimeltufe, fürenemuayu tüfachi dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Fey Jesus ramtueyew engu: —¿Chem dungun anta duamtunieymu? ");
INSERT INTO arnNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Fey feypifi engu: —Elumuyu tami fütra longko ülmen mülewe mew tayu mülepuael kiñe tami man püle, kangelu tami wele püle. ");
INSERT INTO arnNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus ta llowdungueyew engu: —Eymu ta kimlaymu tamu feypipeel. ¿Ayüafuymu tamu kutrankawael ka tamu langümngeael chumngechi ta iñche ñi rupayael feychi dungu mew? ");
INSERT INTO arnNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kisu engu ta llowdungufi ta Jesus: —Femafuyu. Fey Jesus ta feypieyew engu: —Eymu kutrankawaymu ka langümngeaymu chumngechi ñi rupayael ta iñche feychi dungu mew, ");
INSERT INTO arnNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","welu tamu mülepuael iñche tañi man püle kam tañi wele püle iñche ta ngenngelan tañi ‘felepe’ ñi piael. Fey may ta elungeay ñi femael tüfey engün tati pu pepikanielel ñi puwam. ");
INSERT INTO arnNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Feymew tati kakelu mari pu disipulu allkülu engün tüfachi dungu, lladkütufi engün ta Santiaw ka Juan, ");
INSERT INTO arnNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","welu Jesus ta mütrümeyew engün, fey feypieyew: —Eymün kimnieymün tüfa tati pu judiu tuwünngenolu mew müley ta longko ülmenkülelu ka chem awtoridad rume nielu rume aporia ngünekaniekefi tati pu che chumngechi ñi ayüel, ");
INSERT INTO arnNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","welu ta eymün mew ngelay tamün femngechi femael. Ñi feleafel, tati küpa longkolelu kiñeke eymün mew, feley tañi rumel eluwküleael ñi poyeafiel ta kakelu. ");
INSERT INTO arnNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ka kiñeke ta eymün mew küpa wünenkülele, fey ta feleay ta kiñe kona reke ta kakelu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tati Wentrukünuwpalu rume am ta küpanolu tañi poyengeael, welu may ñi poyecheael ka ñi wülael tañi mongen ñi montulafiel ta rume fentren che. ");
INSERT INTO arnNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Fey puwi engün ta Jeriko waria mew. Fey Jesus tripalepatulu tati waria mew, inaniepatueyew tañi pu disipulu ka rume fentren pu che. Fey mülerkey kiñe trawma limona pikelu, Bartimew pingelu, Timew ñi fotüm, anülelu ta inaltu rüpü. ");
INSERT INTO arnNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Allkülu ñi küpalen ta Jesus Nasaret tuwlu, tati trawma eluwi tañi wirarael: —¡Jesus, David mew tripachi Dullin Yomelche, kutranduamyeen ta iñche! ");
INSERT INTO arnNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Fentren che ta feypieyew tañi ñüküfküleael, welu kisu ta doy wirari: —¡David ñi Yomelche, kutranduamyeen ta iñche! ");
INSERT INTO arnNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Feymew Jesus witrakünuwi, fey feypi: —Küpalfimün. Fey küpalngey tati trawma, feypilen mew: —Yafüluwnge. Witrapürange. Petu mütrümeymew tati. ");
INSERT INTO arnNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Fey ti trawma ütrüfentukünuy tañi takuwün, fey ringkülen fülkonpuy ta Jesus mew, ");
INSERT INTO arnNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","fey ramtueyew ta Jesus: —¿Chem am duamnieymi ñi femael iñche ta eymi mew? Fey tati trawma llowdunguy: —Kimeltufe, ayülefun tañi wiñome pelotuael. ");
INSERT INTO arnNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus ta feypieyew: —Amukatunge müten. Tami mupiltun mew ta dew tremotuymi. Feychi lelen mew müten tati trawma pelotuy, fey inafi ta Jesus rüpü mew. ");
INSERT INTO arnNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Fey dew fülpulu engün ta Jerusalen, tati epu waria Betfage ka Betania, Olifu pingechi wingkul ñi inafül mew, Jesus werküy ñi epu disipulu. ");
INSERT INTO arnNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Fey feypifi: —Amumu ta tiyechi trokiñke ruka mew. Fey konpulmu ta tüfey mew, pepuaymu ta kiñe pichi furiku trapelkülelu, iney no rume petu pürakenoetew. Nentuneyfiafimu, fey küpalafimu. ");
INSERT INTO arnNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Fey iney rume ramtuelmumew chumngelu tamu nentutrapelpefiel, feypiafimu ‘Ñidol yelelmumechi pipeeyumew’, fey müchay müten wiñome elpatuafiyu. ");
INSERT INTO arnNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Amuy engu, fey pepufi engu tati furiku trapelkülelu ina rüpü, kiñe wülngiñ ñi itrotripa, fey nentutrapelpufi engu. ");
INSERT INTO arnNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Fey kiñe wentru mülelu tiye mew ramtueyew engu: —¿Chumpeymu anta eymu? ¿Chem mew anta nentutrapelpefimu tati furiku? ");
INSERT INTO arnNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kisu engu ta llowdungufi chumngechi ñi feypikünuetew ta Jesus, fey elungey engu tañi küpalafiel ti pichi furiku. ");
INSERT INTO arnNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Feymew chañukünulfi engu ñi takuwün ti furiku, fey yelelfi engu ta Jesus. Fey Jesus pürakawellufi ti furiku. ");
INSERT INTO arnNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Fentren pu che inüfkünuyey engün ñi takuwün ti rüpü mew, fey kakelu elkünuyey katrün pichike row mamüll ñi nentuel engün lemuntu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Feymew tati wüneleyelu ka ti pu inaleyelu kütu, wirarkülen amuley engün: “¡Osana! ¡Rumel montulepe ti longko ülmen! ¡Fütra küme felen niepe tati küpalelu ta Ñidol ñi üy mew! ");
INSERT INTO arnNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Fütra küme felen niepe tati longko ülmenngealu, taiñ longko ülmen David em ñi tuwünche! ¡Fütra küme püramyengepe ta wenu mapu mew!” ");
INSERT INTO arnNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Fey konpulu Jesus ta Jerusalen mew, üngkü amuy tati ngillatuwe ruka mew. Wall püle adkintupuy, welu dew putrafiarkelu am feymew müten tripay Jerusalen mew fey amuy ta Betania waria mew tañi mari epu disipulu engün. ");
INSERT INTO arnNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Fey ka antü mew puliwen, tripalepatulu engün ta Betania mew Jesus ta ngüñürkey. ");
INSERT INTO arnNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Alü kamapu pefi ta kiñe igera nielu ta tapül, fey fülkonpuy tañi peafiel tañi niepen may ta fün, welu peñmalafi tañi fün. Re tapül müten nierkey, femngen am petu mülekerkenolu ta fün igera. ");
INSERT INTO arnNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Feymew feypifi tati igera: —¡Chumkawnorume ka iney no rume wiñome iwelayay eymi tami fün! Fey kisu ñi pu disipulu allküy ñi feypifiel tati igera. ");
INSERT INTO arnNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Fey dew puwlu engün ta Jerusalen, Jesus konpuy tati ngillatuwe ruka mew, fey wemünentufi ta tiye mew tati pu fendemekelu ka ti pu ngillakamekelu. Ütrüfrulpañmafi ñi mesa tati trafkintupülatamekelelfilu tati pu che, ka tañi anülekemum tati pu fendekelu ta palluma. ");
INSERT INTO arnNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ka elulafi iney no rume tañi konpuael ngillatuwe ruka mew fey ñi yenieael ta chemkün. ");
INSERT INTO arnNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Fey eluwi tañi kimeltuael, feypilen mew: “Tati Wirin Chillka mew ta feypiley: ‘Iñche ñi ruka ta ngillatuwe ruka pingeay kom chüf mapu mew’, welu eymün ta pu weñefe ñi ruka reke niefimün.” ");
INSERT INTO arnNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Femngechi allkülu ta tüfachi dungu tati longkolelu ti pu saserdote mew ka ti kimeltukelu Moyse ñi ley dungu, eluwi engün tañi kintukadungulelafiel chumngechi ñi langümafuel engün ta Jesus, llükaniefilu engün am ta Jesus, fey kom ti pu che am ta afmatulelu tañi femngechi kimeltukeel mew ta kisu. ");
INSERT INTO arnNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Welu dew punlu, Jesus ka tañi pu disipulu tripatuy engün ti waria mew. ");
INSERT INTO arnNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kangelu puliwen mew, rupay engün inafül tati igera, fey pefi engün ñi angkün tañi folil kütu. ");
INSERT INTO arnNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Feymew ta Pedro, tukulpafi ti rupachi dungu, fey feypifi ta Jesus: —Kimeltufe, tüfey, tati igera tami malisiael nga angkürkey. ");
INSERT INTO arnNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Fey Jesus feypi: —Mupiltulemün ta Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Rüf dungu ta feypiwayiñ iney rume feypifile ta tüfachi wingkul: ‘¡Famtripange ta tüfey mew ka ütrüfkonpunge ta lafken mew’! fey feypile newe feyentunon mew, femlayay, welu feyentulele ñi rüf feleael tañi feypiel, feymewke ta femay tañi piel. ");
INSERT INTO arnNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Feymew ta feypiwayiñ kom tamün eluen piel ta ngillatun mew, feyentuaymün fey tamün dew llowniewiyen, femngechi ta llowaymün. ");
INSERT INTO arnNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Fey petu ta ngillatulmün, wiñoduamatuafimün ti pu kakelu tamün yafkakeetew, feymew ta ka femngechi tamün Chaw ta wenu mapu mülelu wiñoduamatuaeymünmew kay eymün tamün yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Fey eymün wiñoduamachenolmün, ka femngechi tamün Chaw mülelu wenu mapu wiñoduamalayaeymünmew tamün yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kom rupalu tüfachi dungu, wiñotuy engün ta Jerusalen. Fey Jesus miyawi ta ngillatuwe ruka mew, fey fülkonpuy ta kisu mew tati pu longkolelu ti pu saserdote mew, ti pu kimeltukelu Moyse ñi ley dungu ka ti putrem fütakeche, ");
INSERT INTO arnNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","fey ramtufi engün ta Jesus: —¿Iney anta werküeymew tami femael tüfachi dungu? ¿Iney am elueymew tati pepiluwün tami femael tüfa? ");
INSERT INTO arnNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Jesus ta llowdungueyew: —Iñche ramtuwayiñ kay kiñe dungu: ¿Iney anta werküeyew ta Juan tañi fawtisacheael? ¿Ngünechen kam tati pu che? Llowdungumuchi. Fey eymün ta feypimuli tañi ramtupeel iñche, ka femngechi feypiwayiñ iney tañi werküetew ta iñche ñi femael ta tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kisu engün ta eluwi ñi notukadunguwael welukonkechi: “Fey llowdunguliyiñ ‘Ngünechen ñi werküetew’, feypiay: ‘Fey ¿chumngelu am feyentulafimün?’ ");
INSERT INTO arnNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Fey chumngechi feypiafuiñ chey ‘ti pu che werküeyew pipeafiyiñ may?...’ ” (Ekuniefi engün tati pu che, itrokom feyentulelu engün am Juan tañi dunguken rüf mew Ngünechen tañi dungu.) ");
INSERT INTO arnNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Fey llowdungufi engün ta Jesus: —Kimlaiñ iney tañi werküetew. Feymew Jesus ka feypieyew engün: —Iñche ta ka feypiwlayayiñ iney ñi werküetew ñi femael iñche ta tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesus eluwi tañi dunguaetew engün kiñe adkünu dungu mew, fey feypi: “Kiñe wentru anümi fentren ofad ka malalmakünufi. Dewmay ta kiñe kütrüwe nentuam ñi pulku ka dewmay kiñe alü pürachi wenu ruka tañi kom puwkintunieam tañi ofadentu. Feymew amediakünulelfi ñi ofadentu kiñeke ti pu küdawkelu, fey kisu eluwi ñi amuael kañpüle. ");
INSERT INTO arnNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Fey puwlu ti antü ñi kosechangeael ti fün ofad, werküy kiñe tañi kona ñi llowpayael ti pu küdawkelu mew ñi koneltuleelchi kosecha. ");
INSERT INTO arnNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Welu ta kisu engün nüfi ñi wülelkayafiel ka wemütufi fey ñi elunofiel chem no rume. ");
INSERT INTO arnNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Feymew tati ngenngelu werküy ka kiñe kona, welu ta tüfa wedokañmangey tañi longko ka fill wesaka pingey. ");
INSERT INTO arnNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Feymew ka wiñome werküy ka kiñe kona, fey tüfa ta langümngey. Feymew ka werküy fentren kakelu pu kona, fey kiñeke ta wülelkafi engün, fey kakelu kay langümfi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Fey kiñelewey ñi werküael: kisu tañi fotüm tañi rume sakinieel. Inangechi mew werküfi ta kisu, rakiduamkülen: ‘Fey ñi kakünu rakiduamnon rume, yamüñmayaenew engün ñi fotüm tati’ pirkey. ");
INSERT INTO arnNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Welu tati pu küdawfe welukonkechi feypiwi engün: ‘Fey tüfa lle tati ngenngetualu ti ofadentu mew. Langümfiyiñ, fey iñchiñngetuay taiñ küdawpeyümchi ofadentu.’ ");
INSERT INTO arnNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Fey ta famngechi nüfi ka langümfi engün, fey ütrüfentufi engün tati la wekuntu ti ofadentu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“¿Fey chumalu trokiniefimün kay tati ngenngelu ti ofadentu mew? Fey küpayay ka langümpayafi tüfeychi pu küdawfe, ka elutuafi ñi ofadentu ta kakelu pu küdawfe. ");
INSERT INTO arnNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“¿Kimlaymün am ñi chem pilen tati Wirin Chillka? Feypiley: ‘Tati pu dewmarukakelu ñi illamelchi kura, dullin kurangetuy. ");
INSERT INTO arnNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Fey tüfa ta Ñidol tañi femkünuel, fey rume afmatuleiñ.’ ” ");
INSERT INTO arnNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Feymew ayüfuy engün ñi püresuafiel ta Jesus, ngüneduamlu engün am kisu engün tañi nütramelngen ta tüfachi adkünu dungu. Welu llükaniefilu engün am tati pu che, elkünutufi ka amutuy engün. ");
INSERT INTO arnNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Werkülelngey ta Jesus kiñeke tati pu farisew ka Erode tañi kelluntukunieetewchi pu che, femngechi tañi kintukaduamafiel engün ñi dungun mew ta Jesus femngechi ñi pepi dalluntukuafiel engün. ");
INSERT INTO arnNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Fey tüfa engün wütufi ta Jesus tañi feypimeafiel: —Kimeltufe, kimnieiñ eymi tami feypiken ta rüf dungu. Chem dungu mew rume eluwkelaymi tami ngünenkangeael, ka kañmaniekelafimi ta che ineyngefule rume. Eymi ta kimeltukeymi rüf dungu mew chumngechi mongen ñi nieael ta che, Ngünechen tañi ayükeel. ¿Kümey am taiñ kulliafiel impuestu tati Roma tuwchi emperador, kam kümelay? ¿Feley kam felelay taiñ kulliael? ");
INSERT INTO arnNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Welu Jesus am kimnieetew engün tañi koyla ngünen ñi nien engün, feypieyew: —¿Chem mew anta femngechi ngünenkadungumupen? Küpalelmuchi ta kiñe moneda, tañi peafiel. ");
INSERT INTO arnNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Fey yelelngey, fey Jesus ta feypieyew engün: —¿Iney am tañi adentun ta tüfa ka ti üy wirikonkülelu ta tüfa mew? Llowdungungey: —Ti emperador tati. ");
INSERT INTO arnNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Feymew Jesus ta feypieyew engün: —Fey eluafimün tati emperador ñi koneltuleel tati emperador, fey ka femngechi eluafimün Ngünechen ñi koneltuleel ta Ngünechen. Femngechi ñi llowdunguel mew ta Jesus, rumeñma afmatulewey engün. ");
INSERT INTO arnNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Feymew amuy engün ñi pemeafiel ta Jesus kiñeke pu sadusew. Fey tüfa engün ta feypikey ñi wiñomongetukenon ti pu la, feymew ta ramtufi engün fey tüfachi dungu: ");
INSERT INTO arnNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Kimeltufe, Moyse ta eleleiñmew ta tüfachi wirin dungu fey kiñe kurengechi wentru ta lale ka nienole fotüm ñi kure mew, fey tati lachi wentru ñi peñi feley ñi kureyetuafiel ñi lantuchi fillka, femngechi ñi fotümeltuafiel tañi dew lachi peñi. ");
INSERT INTO arnNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Feymew may, mülekerkey kiñe rupa regle peñiwen, fey ti wünen kurengerkey, welu larkey, fey ñi elnon kiñe fotüm no rume. ");
INSERT INTO arnNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Feymew ti inan wentru kureyetufi ti lantuchi domo, welu kisu ka femngechi lay fey ñi elnon fotüm. Ka femngechi femi tati epu mew inanngelu, ");
INSERT INTO arnNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","fey kom tati regle peñiwen femngechi femi, welu kiñe no rume elkünulay engün ta fotüm ñawe no rume. Feymew ka larpuy tati domo. ");
INSERT INTO arnNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Fey, mülele wiñomongetun, feychi mongeletule engün, ¿chuchi am kiñeke ti regle wentru ti domo ñi fütangetuay, kom ti regle wentru am kureyefetew ta kisu? ");
INSERT INTO arnNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Fey Jesus ta llowdungueyew engün: —Eymün ta welulkawküleymün, küme adümnofilu am eymün tati Wirin Chillka Ngünechen tañi pepiluwün no rume. ");
INSERT INTO arnNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Feychi tati pu la wiñomongetule, tati pu wentru ka ti pu domo ngewetulayay ñi kureyewael. Tati pu werken püllü müleyelu wenu mapu, fey engün reke feletuay. ");
INSERT INTO arnNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Fey tañi wiñomongetuken tati pu la, ¿tukulpakelafimün am eymün Ngünechen tañi dungufiel ta Moyse tati üykülechi sarsa ti kütral mew? Fey Ngünechen feypifi ta Moyse: ‘Iñche ta Abraam, Isaak ka Jakob ñi Ngünechen’. ");
INSERT INTO arnNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Fey Ngünechen ta lalechi pu che ñi Ngünechen no, welu may tati pu mongelelu ñi Ngünechen! Fey eymün ta rume welulkawküleymün. ");
INSERT INTO arnNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Fey allkülu engün ñi fente küme wiñoldunguletew ta Jesus, kiñe tati kimeltukelu Moyse ñi ley dungu allküñmaetew ñi üyawtudungumeken, fülkonpay ta kisu mew, fey ramtufi ta Jesus: —¿Chuchi am tati doy küme fütra werkün dungu kom ti kakelu werkün dungu mew? ");
INSERT INTO arnNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Feymew Jesus ta llowdungueyew: —Tati doy küme werkün dungu kom mew fey tüfa tati: ‘Allkünge, Israel: iñchiñ taiñ Ñidol Ngünechen kiñeley. ");
INSERT INTO arnNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Piwkeyefinge ta Ñidol Ngünechen kom tami piwke mew, kom tami rakiduam mew, ka kom tami kimün mew ka kom tami newen mew.’ ");
INSERT INTO arnNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ka tüfa tati inalelu: ‘Piwkeyefinge tami chafche eymi chumngechi kisutu piwkeyewimi.’ Kiñe werkün dungu no rume ngelay ta doy kümelu tüfachi epu werkün dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Fey ti kimeltukelu Moyse ñi ley dungu feypieyew: —Rume kümey tati, kimeltufe. Rüfngey tami piel: Kiñeley müten ta Ngünechen, ka ngelay kangelu kisu müten. ");
INSERT INTO arnNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ñi piwkeyengeael ta Ngünechen kom piwke mew, kom kimün mew ka kom newen mew, ka ñi piwkeyengeael ta chafche chumngechi piwkeyewkeyiñ kisutu taiñ chengen, fey doy faliy kom chalintukukeel mew ka kom tati lüpümkeelchi ilo kulliñ ta ngillatuwe mew. ");
INSERT INTO arnNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Fey allkülu ta Jesus ti kimeltukelu ta Moyse ñi ley dungu ñi llowdungun rume küme rakiduam mew, Jesus feypifi ti wentru: —Pülleleymi reke Ngünechen tañi longko ülmenngen mew. Fey iney no rume ta doy ramtuwelaeyew chem dungu no rume. ");
INSERT INTO arnNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus mekerkey ñi kimeltun ta ngillatuwe ruka mew, fey ramtuy: —¿Chem mew am feypikey tati pu kimeltukelu Moyse ñi ley dungu ti Cristo David ñi tuwünngen? ");
INSERT INTO arnNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David, kellunieetew ti Lif Küme Püllü, feypi: ‘Tati Ñidol feypifi iñche tañi Ñidol: Anüpange iñche tañi man püle, fey iñche eluaeyu tami wewafiel kom tami pu kayñe ka tami longkoletuael kisu engün mew.’ ");
INSERT INTO arnNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Fey David ‘iñche ñi Ñidol’ pieyew, ¿fey chem mew am tati Cristo David ñi tuwünngey? Fey rume fentren che, allkülu ñi feypin ta Jesus, “rume küme pi tati” pi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus feypikey tañi kimeltun mew: “Kuñiwtuwmün tati pu kimeltukelu Moyse ñi ley dungu mew. Ayükey engün tañi nieael chiñayngechi takuwün ka ñi chalingeael engün rume yamün mew ta pülasa mew. ");
INSERT INTO arnNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kintukey engün ti doy kümeke wangku ta sinagoga mew ka iyayüm engün, dullikey doy dullilechi wangku. ");
INSERT INTO arnNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ka müntuñmakefi engün ñi ruka tati pu lantu domo, ka tañi nor mongen wentru ñi pingeael engün, fütra ngillatukawkey. Kisu engün ta doy fütra kutrankangeay kakelu pu che mew.” ");
INSERT INTO arnNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kiñe rupa anüley ta Jesus ti ofrenda ñi elngekemum ñi fül püle, adkintuniey chumngechi ñi tukumeken pülata ti pu che ti pichi kakon mew. Fentren pu riku tukumekey engün fentren pülata. ");
INSERT INTO arnNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Feymew akuy ta kiñe pofre lantu domo, fey tukupay ti pichi kakon mew chew ñi elngekemum pülata epu pichike kofre moneda, rume pichin falilu. ");
INSERT INTO arnNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Feymew Jesus mütrümfi tañi pu disipulu, fey feypifi: —Rüf dungu feypiwayiñ fey tüfachi pofre lantu domo doy alün tukupay kom ti kakelu pu che mew chew ñi tukungekemum ta pülata. ");
INSERT INTO arnNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Fey kom kakelu wülkey engün tañi sofrantunieelchi pülata, welu ti domo, pofrengefuy rume, wüli kom ñi niefel tañi mongeluwam. ");
INSERT INTO arnNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Fey tripaletulu ta Jesus ngillatuwe ruka mew, kiñe tañi pu disipulu feypieyew: —¡Kimeltufe, tüfey ta müna kümelkaleyey ti kura ka müna küme fütrake wenu ruka! ");
INSERT INTO arnNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Fey Jesus llowdungufi tati disipulu: —¿Pefimi anta tüfachi fütrake alü pürachi ruka? Welu ngewelayay kiñe kura no rume welukonke rentrolealu. Kom ta teyfükangeay. ");
INSERT INTO arnNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Feymew müten ta amuy tati Olifu pingechi wingkul mew, ngillatuwe ruka ñi itrotripa mülelu. Jesus ta anükünuwpuy, fey Pedro, Santiaw, Juan ka Andre wichu ramtueyew engün: ");
INSERT INTO arnNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Feypimuiñ chumül ñi rupayael tüfachi dungu ka chem wele dungu ñi müleael epe puwle ñi feleael tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Feymew Jesus ta llowdungufi ñi pu disipulu: —Kuñiwtuaymün iney no rume tamün ngünenkanoaetew, ");
INSERT INTO arnNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","rume fentren che am mülealu ‘iñche tati Cristo’ pialu, fey rume fentren pu che ta ngünenkayafi. ");
INSERT INTO arnNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Fey eymün ta kimelelngelmün ñi mülen ta awkan dungu tüfa püle ka üyew püle, llükakilmün. Müley tañi felerpuael, welu ta petu akulayay ti afachi antü. ");
INSERT INTO arnNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kiñe trokiñ mapu ta weychayay kangelu trokiñ mapu engu ka kiñe trokiñche wechayay ta kangelu trokiñche engu. Ka müleay ta fütrake nüyün fill mapu mew, ka müleay ta ngüñün, fey tüfa ñi llituael müten ta kutrankawün. ");
INSERT INTO arnNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kisutu kuñiwtuwkülemün ta eymün. Chalintukungeaymün tati pu awtoridad mew, fey wülelkangeaymün tati sinagoga mew. Ka puwülngeaymün ti gobernador mew ka ti pu longko ülmen mew iñche tañi duam. Femngechi ta pepi nütramyemuan ta iñche kisu engün mew. ");
INSERT INTO arnNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Petu ñi puwnon ñi afael ta antü, tati montun werkün dungu feley tañi kimelngeael ta kom chüf mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Rakiduameluwkülekilmün eymün tamün chem piael chalintukungelmün tati pu awtoridad mew. Feychi lelen mew ta feypiaymün Ngünechen tamün eluetewchi dungu tamün feypiael, eymün no am tati dungualu, welu tati Lif Küme Püllü eluaeymünmew chumngechi tamün dunguael. ");
INSERT INTO arnNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tati pu peñiwen chalintukuay ñi langümüñmangeael tani peñi, ka ti pu chaw chalintukuay tañi pu fotüm. Ka ti pu fotüm üyawtuay tañi chaw ka langümafi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kom chüf mapu mülechi pu che ta nüngaytuaeymünmew iñche tañi duam, welu tati pu che tuntepule ñi mongen yafüluwün mew inanieelimew, fey engün ta montuay. ");
INSERT INTO arnNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Fey pefilmün ñi mülen tati pelon wentru Daniel ñi wirielchi wesake dungu tati ngillatuwe ruka mew, tüfey mew ñi mülenoafel ti wesake dungu ―ti chillkatulu, küme ngüneduampe― feymew tati müleyelu ta Judea mew, ellkawpe ta fütrake lüngkawngechi wingkul mew. ");
INSERT INTO arnNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Fey ti mülelu tañi wenu ruka mew, nagkilpe ka konkilpe rume tañi entuael chem no rume tañi pu ruka. ");
INSERT INTO arnNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ka tati mülelu lelfün mew, wiñokontukilpe tañi ruka mew tañi yemetuael ñi takun no rume. ");
INSERT INTO arnNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Awngey tati pu domo tüfey engün feychi antü mew niepüñeñküleyele kam niele moyol püñeñ rume! ");
INSERT INTO arnNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ngillatuafimün eymün ta Ngünechen ñi mülenoael tüfachi dungu pu pukem, ");
INSERT INTO arnNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","rume kutrankawün antüngealu am chumkawnorume ta mülekenolu feychi Ngünechen dewmafilu ta mapu ka mülewelayay rume ta amulerpuachi antü mew. ");
INSERT INTO arnNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ñidol Ngünechen ta elunofile ñi pichiñmayael tüfeychi kutrankawün, iney no rume ta montulayafuy. Welu ta doy pichiñmayay kisu tañi piwkeyenieelchi pu che ñi duam, kisu tañi dullintunieyeel. ");
INSERT INTO arnNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Feymew llemay iney rume ta feypielmünmew: ‘Allkütumün. Tüfa tañi mülen tati Cristo’, kam ‘Allkütumün. Üyew tañi mülen’, feyentukefilmün. ");
INSERT INTO arnNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Fentren koyla ngünen Cristo ta küpayay ka koyla ngünen pu pelon wentru. Ka femay engün afmanngechi pepiluwün dungu tañi ngünenkacheam, fey pepilfule, ñi ngünenkayafiel Ngünechen tañi dullintuelchi pu che kütu. ");
INSERT INTO arnNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Kuñiwtuwaymün! Kom ta tüfachi dungu wüne dew feypikünuwpeyiñ ta eymün. ");
INSERT INTO arnNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Welu ta feychi antü mew, dew rupale tati kutrankawün, ‘ti antü ta dumiñay, küyen ta alongüwetulayay. ");
INSERT INTO arnNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wangülen ütrüfnagpayay ta wenu mew ka kom nielu pepiluwün ka ngüneluwün ta kallfü wenu mew müllmüllay.’ ");
INSERT INTO arnNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Feymew ta pengeay tati Wentrukünuwpalu ñi küpalen ta tromü mew fütra pepiluwün mew ka fütra pelon mew. ");
INSERT INTO arnNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kisu ta werküay tañi pu werken püllü, fey trawüluway tañi pu dullintuel tati meli witran mapu püle, ñi tuntepulen ta mapu ka ñi tuntepulen kütu ta kallfü wenu. ");
INSERT INTO arnNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Adümafimün ta igera mew adentulechi adkünu dungu: petu pewüyüm tañi tapül, ngüneduamkeymün ta eymün ñi dew fülkülepan ta walüng antü. ");
INSERT INTO arnNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ka femngechi feychi pefilmün ñi rupan ta tüfachi dungu, kimaymün Ngünechen tañi Fotüm ñi dew püllelen tañi küpayael. ");
INSERT INTO arnNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Rüfngey ñi feleael kom tüfachi dungu petu tañi lanon ta fantepu mülechi pu che. ");
INSERT INTO arnNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Wenu ka mapu kütu ta aftuay, welu iñche ñi dungu kom feley ñi mupiael. ");
INSERT INTO arnNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Welu ti antü ka tati ora iney rume kimlay, tati wenu mapu müleyechi pu werken püllü no rume, ka Ngünechen ñi Fotüm no rume. Chaw Ngünechen müten ta kimniey. ");
INSERT INTO arnNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Feymew llemay, trepeluwkülemün ta eymün ka llüwatuleaymün ka ngillatuleaymün, kimnolu am eymün chumül ñi akuael feychi antü. ");
INSERT INTO arnNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Fey tüfa ta kiñe wentru reke feley, epe tripalelu ñi amuael ta kangelu fütra trokiñ mapu mew. Elfalfi tañi pu kona ñi llüwatulelngeael tañi ruka. Kake kiñeke engün elungey ta küdaw, ka werküfi tati llüwatuniekelu ta wülngiñ ñi eluwmekenoael. ");
INSERT INTO arnNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Femngechi llemay, eymün ta trepeluwküleaymün, kimnolu am eymün chumül ñi akuael ta Ñidol tati ngen ruka: dew punle chemay, kam kakarale ti alka chey, kam puliwen chemay. ");
INSERT INTO arnNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Feymew ta akurumele nga, umawkülen pengepayafuymün. ");
INSERT INTO arnNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tüfachi dungu tamün feypiwpefiel, itrokom chengealu: ¡Trepeluwkülemün ta eymün!” ");
INSERT INTO arnNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Epu antülewey ñi akuam ti Paskua kawiñ, ñi ingekemum ti kofke nienolu lefawra. Fey ti pu longkolelu ti pu saserdote mew ka ti pu kimeltukelu Moyse ñi ley dungu rakiduamküley engün chumngechi ñi püresuafiel ta Jesus kiñe ngünen dungu mew, ka ñi langümafiel. ");
INSERT INTO arnNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kiñekentu ta feypiyey engün: “Tati kawiñ antü mew no, fey ti pu che tañi pofolkawnoam engün.” ");
INSERT INTO arnNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus amurkey ta Betania, Simon tañi ruka mew, tati leproso pikeel. Fey mülepulu engün mesa mew, akuy ta kiñe domo küpalnielu ta kiñe pichi fotilla apolelu perfume mew re nardo ürke ka rume falilu. Nülafi tati pichi fotilla ka wütrunagümfi tati perfume Jesus ñi longko mew. ");
INSERT INTO arnNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kiñeke tati müleyelu tüfey mew lladküy engün, ka welukonkechi feypiwi engün: —¿Chem mew anta ngünamkangey ta tüfachi perfume? ");
INSERT INTO arnNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Rume fentren pülata mew fendengeafuy em tati, ñi kellungeael tati pu pofre. Fey ti domo entuüñfileyew ti pu che. ");
INSERT INTO arnNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Welu Jesus feypifi tati pu che: —Femkünufimün. ¿Chumngelu am fillpipefimün? Fey tüfa tañi femetew mew, rume kümelkaenew tati. ");
INSERT INTO arnNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tati pu pofre rumel ta müleay eymün mew, fey engün ta füreneafuymün ta chumül rume ta küpa kellufilmün, welu ta iñche rumel ta mülelayan eymün mew. ");
INSERT INTO arnNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Fey tüfachi domo ta femi tañi pepi femel: kisu ta tukulelenew perfume petu tañi rüngalngenon ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Rüf dungu feypiwayiñ chew püle rume ta tüfachi mapu mew wewpingele ta tüfachi montuluwün dungu, ka nütramyengeay tañi femün ta tüfachi domo, ka femngechi ta tukulpangeay. ");
INSERT INTO arnNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Fey Juda Iskariote, kiñe tati pu mari epu disipulu, amuy tañi pemeafiel tati pu longkolelu tati pu saserdote mew tañi chalintukulelafiel engün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Fey allküñmangelu tañi feypipun, ayüwi engün, fey tukulpalelfi engün tañi eluafiel pülata ta Juda. Feymew Juda eluwi tañi rakiduamael chumngechi tañi doy küme ellka wültukuafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Feychi antü we llitulu ti Paskua kawiñ ñi ingekemum tati lefawrangenochi kofke ka ñi langümngekemum tati korderu, Jesus tañi pu disipulu ramtueyew: —¿Chew anta ayünieymi taiñ amuael ka taiñ pepikayael tati pun ilelkawün Paskuangealu? ");
INSERT INTO arnNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Feymew werküfi epu tañi disipulu, fey feypikünufi: —Amumu ta waria mew. Fey üyew pepuaymu ta kiñe wentru yenielu ta kiñe metawe ko. Inayafimu, ");
INSERT INTO arnNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","fey chew konpule, feypiafimu ti ngen ruka: ‘Tati kimeltufe ta ramtupey: ¿Chuchi am tati katrüntuku ruka chew taiñ iyael tañi disipulu iñchiñ tati pun ilelkawün Paskua pingelu?’ ");
INSERT INTO arnNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tiyechi wentru ta pengelelaeymumew tati wenulechi pisu ruka mew, kiñe alü tuwchi katrüntuku ñi nieel ti ruka dew pepikalelu itrokom chemkün mew. Fey tiye mew pepikayaymu taiñ ipuwael ta iñchiñ. ");
INSERT INTO arnNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tati epu disipulu tripay, fey amuy engu ta waria mew. Kom femngechi pepuy engu chumngechi ñi feypietew ta Jesus, fey pepikapuy engu tiye mew tati pun ilelkawün Paskua pingelu. ");
INSERT INTO arnNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Fey dew punlu, trawüluwpuy ta Jesus tañi mari epu disipulu engün. ");
INSERT INTO arnNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Fey mülepulu mesa mew engün, petu ilu, Jesus ta feypifi ñi pu disipulu: —Rüf dungu feypiwayiñ tüfa: kiñe ta eymün, petu ilu ta iñche engu, fey ta ellka wültukuaenew. ");
INSERT INTO arnNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kisu engün ta weñangkülewey, fey kake kiñeke eluwi engün tañi welukonkechi ramtuafiel ta Jesus: —¿Iñche pemay? ―pi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Fey Jesus ta feypi: —Kiñe tati mari epu disipulu, petu ifontukulu tañi kofke mew kisu iñchiw. ");
INSERT INTO arnNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tati Wentrukünuwpalu feley ñi rupayael feychi dungu mew chumngechi wiriley ti Wirin Chillka mew, welu ¡awngeay may tati wentru tañi ellka wültukuaetew! Doy kümeafuy ta kisu ñi choyüngenoafel. ");
INSERT INTO arnNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Petu ilu engün, Jesus nüy ñi kuwü mew tati kofke. Fey rupan mañumtufilu ta Ngünechen, wükafi ti kofke ka eluyefi tañi pu disipulu, feypilen mew: —Ifimün, fey tüfa ta iñche ñi kuerpu tati. ");
INSERT INTO arnNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ka feymew müten nüfi kiñe kopa. Fey rupan mañumtufilu ta Ngünechen, eluyefi tañi pu disipulu, fey kom putuy engün. ");
INSERT INTO arnNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Feymew Jesus feypifi ñi pu disipulu: —Fey tüfa ta iñche ñi mollfüñ. Fey tüfa mew rüfngey Ngünechen tañi we eldungun, fey ta wütrulngey fentren pu che tañi fürenengeael. ");
INSERT INTO arnNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Rüf dungu tüfa: ka wiñome putuwelayan ta ofad mew tripachi pulku, feychi antü wüla putuali ti we pulku Ngünechen tañi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Rupan ülkantulu engün kiñe salmo, amuy engün tati Olifu wingkul mew. ");
INSERT INTO arnNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Fey Jesus ta feypifi ti pu disipulu: —Kom eymün kisukünumutuan ta iñche. Chumngechi feypiley tati Wirin Chillka: ‘Langümafiñ tati ufisakamañ, fey tati pu ufisa püdyetuay engün.’ ");
INSERT INTO arnNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Welu ta iñche wiñomongetuli, fey amuan ta Galilea. Wüne puwan ta eymün mew. ");
INSERT INTO arnNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Fey Pedro ta feypieyew: —Tunte kom kakelu elkünutuay engün rume tañi maneluwün eymi mew, welu iñche femlayan. ");
INSERT INTO arnNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus ta llowdungufi ta Pedro: —Rüf dungu feypiaeyu, tüfachi pun müten, petu ñi kakaranon ta alka epu rupachi mew, küla rupachi ta ‘kimlafiñ’ piaymi. ");
INSERT INTO arnNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Welu Pedro amulkünu feypiley: —Tunte mür iñchiw rume ta layayu, ‘kimlafiñ’ pilayan. Kom ti kakelu pu disipulu ka femngechi feypi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Feymew müten amuy engün kiñe lelfün mew, Getsemani pingelu. Jesus feypifi tañi pu disipulu: —Mülewemün tüfa mew, fey iñche amuan tañi ngillatumeael. ");
INSERT INTO arnNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Welu Jesus yefi ta Pedro, Santiaw ka Juan doy üyew püle, feymew Jesus rume weñangkünagi ka ngañwadnagi. ");
INSERT INTO arnNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Feymew feypifi ñi küla disipulu: —Rume weñangküley tañi piwke. Landuamkülen. Mülewemün eymün tüfa mew, ka trepeleaymün. ");
INSERT INTO arnNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Feymew Jesus ka pichi doy üyew püle amuy. Lloyünagi fey idapuy pülli mew tañi tol, fey ngillatufi ta Ngünechen, pepilfalfule, fey ñi rupanoafel tüfeychi kutrankawün mew ta kisu. ");
INSERT INTO arnNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tañi ngillatun mew ta feypi: “Iñche ñi Chaw Ngünechen, eymi mew ta kom pepilfali. Montulen ta tüfachi fütra kutrankawün mew, welu felekilpe iñche tañi ayüel, eymi tami ayüel mayfe.” ");
INSERT INTO arnNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Feymew wiñotuy chew tañi mülemum tati küla disipulu, fey pepatufi tañi umawkülen engün. Feypifi ta Pedro: —Simon, ¿umawküleymi am? ¿Kiñe ora rewall anta pepi trepelelaymi? ");
INSERT INTO arnNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Trepewkülemün ka ngillatulemün tamün famtukungenoael ta wesake dungu mew. Eymün ta pilefuymün tamün femael kümeke dungu, welu tamün kuerpu yafüngelay. ");
INSERT INTO arnNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Fey wiñome amutuy, ka ngillatupuy feychi dungun mew müten. ");
INSERT INTO arnNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Fey wiñomelu, ka pepatufi ñi umawkülen tañi küla disipulu, tañi nge kisutu umernagmekelu am fente tañi küpa umawtun engün. Fey kimlay engün chem tañi llowdunguael. ");
INSERT INTO arnNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Küla rupachi mew wiñotuy Jesus, fey feypifi tañi küla disipulu: —¿Amuley am tamün umawkülen ka tamün kansatulen? Yochi tati. Dew puwi tañi chalintukungeael tati Wentrukünuwpalu tati pu yafkafe mew. ");
INSERT INTO arnNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Witrapüramün. Amuiñ. Fülpay dewma tati wentru ngünen mew ñi wültukuaetew. ");
INSERT INTO arnNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Petu dungumekelu ta Jesus, fey Juda, kiñe tati pu mari epu disipulu, akuy kompañuwkülen fentren che engün pepikawkülelu wayki mew ka mamüll. Küpay engün ñi werküetew mew tati pu longkolelu ti pu saserdote mew, ti pu kimeltukelu Moyse ñi ley dungu ka tati pu putrem fütake judiu. ");
INSERT INTO arnNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Juda, tati ellka chalintukuaetew, feypirkeeyew engün chumngechi ñi femael, feypilen mew: “Chuchi iñche tañi truyupuael, fey tati. Püresuafimün ka küme trarilen yeafimün.” ");
INSERT INTO arnNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Feymew Juda fülkonpuy ta Jesus mew ka feypifi: —¡Kimeltufe! Fey truyufi. ");
INSERT INTO arnNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Feymew nüngey ta Jesus ka püresungey. ");
INSERT INTO arnNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Welu kiñe tati mülelu tiye mew entupay tañi wayki, fey katrünentuñmafi tañi kiñe pilun tati Wünen Longko Saserdote tañi kona. ");
INSERT INTO arnNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Feymew Jesus ramtufi tati pu che: —¿Chem mew am küpalnieymün ta wayki ka nünieymün mamüll tamün püresumuafiel, iñche ta kiñe malochefengelu reke? ");
INSERT INTO arnNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Fill antü müleken ta eymün iñchiñ. Kimeltumekeken ta ngillatuwe ruka mew, fey chumkawnorume püresumukelafun. Welu tüfa femngechi femi tañi mupiael ñi chumngechi wirikonkülen ti dungu ta Wirin Chillka mew. ");
INSERT INTO arnNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Fey Jesus kom ñi pu disipulu kisukünueyew, ka lefmawi engün. ");
INSERT INTO arnNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Welu kiñe weche wentru ta inanieeyew, kiñe safana mew müten ta munuluwküley. Fey tüfa ta nüngey, ");
INSERT INTO arnNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","welu ta kisu neykümkünufi tati safana, fey triltrangkülen lefmawi. ");
INSERT INTO arnNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Feymew yengey ta Jesus tati Wünen Longko Saserdote mew, fey trawüluwi engün kom tati pu longkolelu tati pu saserdote mew, ka tati pu putrem fütakeche ka ti pu kimeltukelu Moyse ñi ley dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro alü kamapu inanieeyew ka konpuy ti Wünen Longko Saserdote tañi itrotripa ti wülngin ruka mew. Fey anükünuwpuy tati pu llüwatulekelu engün ta ngillatuwe ruka mew, fey eñumtuley ta inaltu kütral. ");
INSERT INTO arnNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Fey ti pu longkolelu ti pu saserdote mew ka kom tati putremke judiu kintukadungulelfi engün ta Jesus ñi kondenayafiel ka ñi langümafiel, welu ta perkelay engün chem koyla dungu rume ñi witrantulelafiel. ");
INSERT INTO arnNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Rume fentren che ta puwürkey tañi dalluntukuafiel re koylake dungu mew ta Jesus, welu kakerumey ñi dungu engün, feymew chaflay ñi dallupuel engün. ");
INSERT INTO arnNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kiñekentu ta witrapüray, fey dalluntukufi ta re koylake dungu mew, feypilen mew: ");
INSERT INTO arnNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Iñchiñ ta allküñmakefiyiñ tañi feypin: ‘Iñche ta teyfüafiñ ta tüfachi ngillatuwe ruka tati pu che ñi dewmael, fey küla antü mew witrañpüramtuan ta kangelu ngillatuwe ruka che tañi dewmanoel.’ ");
INSERT INTO arnNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Welu kisu engün tañi feypintukuelchi dungu trüruwlay. ");
INSERT INTO arnNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Feymew tati Wünen Longko Saserdote witrapüray kom che tañi adkiñ mew, fey ramtufi ta Jesus: —¿Kiñe dungu rume llowdungulayaymi am? ¿Chem dungu am tati tami feypintukumekengen? ");
INSERT INTO arnNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Welu Jesus ñüküfküley müten. Kiñe dungu no rume llowdungulay. Fey ti Wünen Longko Saserdote ka wiñome ramtufi ta Jesus: —¿Eymi am tati Cristo, tati fütra küme felenngechi Ngünechen tañi Fotüm? ");
INSERT INTO arnNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus ta feypi: —May, iñche tati. Fey eymün ta peafimün tati Wentrukünuwpalu anülelu tati kom pepiluwünngechi Ngünechen ñi man püle ka ñi küpayael ta kallfü wenu tromü mew. ");
INSERT INTO arnNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Feymew tati Wünen Longko Saserdote wikürkay tañi takuwün ñi kimfaluwael ñi fente lladkün, fey feypi: —Fey tüfa tañi feypin mew duamtuwelaiñ chem dungu no rume tañi feypingeael. ");
INSERT INTO arnNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Eymün allküñmafimün tañi feypiel. Rume wesa dunguy ta Ngünechen mew. ¿Chumngentufimün kay? Fey kom kiñewi engün ñi “yafkay” ñi piafiel ka ñi “langümngepe” ñi piael engün. ");
INSERT INTO arnNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kiñekentu eluwi engün tañi tofkütuafiel, ka takuñmangey tañi nge ka wülelfi engün, ka feypiniefi: —¡Feypinge iney am ta wülelpeeymew! Fey tati pu llüwatulekelu ngillatuwe ruka mew wülelkafi ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro ta müley nageltu ti lepün ruka mew. Feymew akuy kiñe domo ti küdawelkefilu tati Wünen Longko Saserdote. ");
INSERT INTO arnNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Fey pefilu ta Pedro, eñumtumekelu ta ina kütral, leliniewefi ka feypifi ta Pedro: —Eymi ta ka miyawkeymi ta Jesus eymu, tati Nasaret tuwchi wentru. ");
INSERT INTO arnNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro ta llumumay, feypilen mew: —Kimlafiñ tati. Ka kimlan rume tami chem pipen. Fey tripay wekuntu, itrotripa wülngiñ. Feymew kakaray kiñe alka. ");
INSERT INTO arnNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Fey ti küdawkechi domo ka pefi ta Pedro, fey eluwi ñi feypiafiel tati kakelu pu che: —Fey tüfa ta miyawkey Jesus engu. ");
INSERT INTO arnNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Welu Pedro ka wiñome “kimlafiñ” pi. Ka pichi alün mew, tati pu che müleyelu tüfey mew ka wiñome feypifi engün ta Pedro: —Rüfngey eymi ta Jesus ñi kompañ, ka femngechi Galilea tuwünche ta eymi. Ka tami dungun kütu femngerumey kisu reke. ");
INSERT INTO arnNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Feymew Pedro eluwi tañi wesa dunguael ka ñi kuyalltuael, feypilen mew: —¡Kimlafiñ ta tüfeychi wentru eymün tamün nütramyepeel! ");
INSERT INTO arnNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Feychi lelen mew müten kakaray ta alka epu rupachi, fey Pedro tukulpay ñi feypikünuetew ta Jesus: “Petu ñi epuchi kakaranon ta alka, küla rupachi ta ‘kimlafiñ’ piaymi.” Fey eluwi tañi ngümakawael. ");
INSERT INTO arnNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Fey küme wünlu, trawüluwi engün ti pu longkolelu ti pu saserdote mew ti putrem fütakeche engün, ti pu kimeltukelu ta Moyse ñi ley dungu ka kom tati putremke judiu. Fey trarilen yeniengey ta Jesus, fey chalintukungepuy ta Pilato mew. ");
INSERT INTO arnNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Fey Pilato ramtufi ta Jesus: —¿Eymi am tati pu judiu ñi longko ülmen? —Eymi ta feypipeymi ―llowdunguy ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tati pu longkolelu ti pu saserdote mew am ta dalluntukuetew ta fentren dungu mew, ");
INSERT INTO arnNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato ta ka wiñome ramtufi ta Jesus: —¿Kiñe dungu rume llowdungulaymi ta eymi? Ngüneduamnge fentren dungu mew tami dalluntukumekengen. ");
INSERT INTO arnNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Welu Jesus ta llowdungulaeyew, feymew ta Pilato rumeñma wesa duamnagi. ");
INSERT INTO arnNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Fey tati kawiñ antü mew, Pilato lifrenentukerkefi ta kiñe püresu, tati pu che tañi dullielchi püresu. ");
INSERT INTO arnNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kiñe wentru Barabas pingelu püresulerkey ta karsel mew, kiñentrür kakelu engün langümcherkey kiñe malokawün mew. ");
INSERT INTO arnNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Akuyey may tati pu che, fey eluwi engün tañi feypiafiel ta Pilato tañi lifrenentutuafiel kiñe püresu chumngechi tañi wimtulen ñi femkeel ti kawiñ antü mew. ");
INSERT INTO arnNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Fey Pilato ta llowdungufi ti pu che: —¿Ayüleymün anta eymün iñche tañi lifrenentutuafiel tati pu judiu tañi longko ülmen?― ");
INSERT INTO arnNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ngüneduamfilu am ti pu longkolelu tati pu saserdote mew ñi chalintukufiel tañi re ütrirfiel mew ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Welu tati pu longkolelu ti pu saserdote mew pofolkafi tati pu che, femngechi ñi feypiael engün tañi lifrenentungetuael ta Barabas. ");
INSERT INTO arnNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Fey Pilato ta ramtuy: —¿Fey chem am ayüleymün tañi femafiel iñche tati pu judiu tañi longko ülmen pikeel? ");
INSERT INTO arnNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Fey kisu engün wirarkülen llowdunguy: —¡Langümngepe ta kürus mew! ");
INSERT INTO arnNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Fey Pilato ta feypieyew engün: —Fey ¿chem wesa dungu femürkey amfe? Welu ta kisu engün ka wiñome wirari: —¡Langümngepe ta kürus mew! ");
INSERT INTO arnNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Feymew ta Pilato, ayünielu am tañi kümelkawküleael tati pu che engün, lifrenentutufi ta Barabas. Fey rupan werkülu ñi wimakangeael ta Jesus, chalintukufi tañi langümngeael ta kürus mew. ");
INSERT INTO arnNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Fey tati pu soltaw yefi engün ta Jesus chew ñi mülemum ti kakelu pu soltaw, fey trapümngey kom tati trokiñ soltaw. ");
INSERT INTO arnNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tukulelfi engün kiñe kurü kelü takuwün, ka ñi longko mew kiñe wayngechi pülliñ korona. ");
INSERT INTO arnNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Feymew müten eluwi tañi wirarael engün ayentun mew: —¡Püramyengepe tati pu judiu tañi longko ülmen! ");
INSERT INTO arnNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Fey wülelmafi engün ñi longko kiñe mamüll mew, tofkütufi engün, ka lukutulfi rume yamniefilu reke, fey ñi re ayentufiel engün. ");
INSERT INTO arnNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Fey dew rupan femngechi ayentukafilu engün ta Jesus, ka entuñmatufi engün tati kurü kelü takuwün, fey tukuleltufi engün kisu tañi takuwün, fey yefi tañi langümafiel engün ta kürus mew. ");
INSERT INTO arnNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kiñe wentru Sirene tuwlu, Simon pingelu, Alejandro ka Rufo tañi chaw, fey tüfa wiñomerkey ta lelfün mew. Rupalu ta tüfey püle, trenumafi engün, fey aporiangey tañi meñkuyeafiel ti kürus Jesus tañi yenieel. ");
INSERT INTO arnNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Fey yengey ta Jesus kiñe lelfün mew Golgota pingelu (tüfa ta feypin ürke: “Kalafera lelfün”), ");
INSERT INTO arnNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","fey elungey pulku deyülelu finagre engu, welu Jesus pilay ñi putuael. ");
INSERT INTO arnNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Feymew ti pu soltaw külafantukufi ta Jesus kürus mew. Fey ti pu soltaw wüdamkaleluwi engün Jesus tañi takuwün, fey pewütufi engün ñi kimael chuchi müngell ñi yeael kake kiñeke ti takuwün. ");
INSERT INTO arnNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Feychi külafantukungelu ta Jesus kürus mew, aylla orachi puliwen mew ürke. ");
INSERT INTO arnNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ka elkünulelngey kiñe letreru chew tañi wirikonkülemum chem dungu mew tañi langümngen: ");
INSERT INTO arnNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ka femngechi külafantukungey kürus mew epu fütrake weñefe Jesus ñi inafül mew, kiñe kisu ñi man püle fey ti kangelu kisu ñi wele püle. ");
INSERT INTO arnNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Femngechi mupiy chumngechi ñi wirikonkülen ta Wirin Chillka mew tati feypilelu: “fey keyü rakintukungey tati pu wesake che engün.” ");
INSERT INTO arnNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tati pu che rupayelu tiye mew, fill wesapieyew. Ütrüfütrüftuy ñi longko engün feypilen mew: —¡Eymi no am tati teyfükefilu ti ngillatuwe ruka, fey küla antü mew ka wiñome dewmatukefilu, ");
INSERT INTO arnNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","fey kisutu montuluwtunge ka nagpatunge ti kürus mew! ");
INSERT INTO arnNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ka femngechi ayentukaeyew ta Jesus ti pu longkolelu tati pu saserdote mew ka ti pu kimeltukelu Moyse ñi ley dungu. Feypi engün: —Kakelu montulfi, welu kisutu pepi montuluwlay. ");
INSERT INTO arnNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Nagpatupe ta kürus mew ta tüfeychi Cristo, Israel tañi longko ülmen, taiñ peafiel ka taiñ feyentuafiel! Ka femngechi tati weñefe tati petu langümngelu kürus mew, kafey wesa lladkütudungueyew. ");
INSERT INTO arnNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Fey rangiantülu, kom chüf mapu dumiñmalewey küla ora nagchi antü mew wüla pelonngetuy. ");
INSERT INTO arnNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ka feychi ora mew müten, Jesus ta newentu wirari: “Eloy Eloy, ¿lema safaktani?” (Fey tüfa ta feypin ürke: “iñche ñi Ngünechen, iñche ñi Ngünechen, ¿chem mew anta kisukünuen?”) ");
INSERT INTO arnNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kiñeke che müleyelu tiye mew, allküy ka feypi engün: —Allkütumün. Petu mütrümfi tati pelon wentru Elia. ");
INSERT INTO arnNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Feymew kiñe ta kisu engün lefkülen amuy, fey ifokünulfi ta kiñe esponja wesa füre pulku mew ka trarintukufi kiñe wechuñ rüngi mew, fey fülümelpufi ta Jesus tañi wün mew ñi putuafiel, feypilen mew: —Femkünufimün, küpayay chey am Elia ñi nagümpatuaetew ta kürus mew. ");
INSERT INTO arnNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Feymew Jesus fütra newentu wirari, fey lay. ");
INSERT INTO arnNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Fey tati rünge fütra kortina mülelu ta ngillatuwe ruka mew, rangi wichafnagi. Tuwi wenu, fey puwi nageltu ñi wichafnagün. ");
INSERT INTO arnNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tati Roma tuwchi kapitan, mülelu ta Jesus ñi fül mew, fey allkülu ñi wirarün ka pefilu tüfa tañi lan, feypi: —Rüfngerkey ta tüfachi wentru Ngünechen ñi Fotümngen. ");
INSERT INTO arnNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ka müleyey kiñeke domo pichi alü tripa adkintulelu. Feychi pu domo mew müley ta Maria Magdalena, Santiaw tati inan ka Jose tañi ñuke Maria pingelu, ka Salome. ");
INSERT INTO arnNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Fey tüfachi pu domo ta inayawülkefuy engün ta Jesus ka kellukefuy engün feychi mülelu Jesus Galilea mew. Ka müleyey ta tiye mew fentren kakelu pu domo tati küpayelu kiñentrür Jesus engün ta Jerusalen mew. ");
INSERT INTO arnNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Fey Jose, Arimatea tuwünche ka kiñe yamfal wentru ürke, koneltulelu tati putremke judiu mew, fey kisu ka femngechi maneluwkülerkey ñi felerpuael Ngünechen tañi longko ülmenngen. Fey dew nagantülu feychi pepikawkeelchi antü mew, epe llitulelu ti ürkütun antü, Jose wütufi füta piwkewün mew ñi feypimeafiel ta Pilato “elutuen Jesus tañi kuerpu” ñi pimeafiel. ");
INSERT INTO arnNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Feymew Pilato ta afmalewey tañi dew lawiyen mew ta Jesus, fey mütrümfi tati kapitan tañi ramtuafiel tunteñma ñi dew lawiyen. ");
INSERT INTO arnNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Fey ti kapitan kom küme feypietew, Pilato feypifi ta Jose ñi yetuafiel Jesus tañi kuerpu. ");
INSERT INTO arnNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Feymew Jose ngillay ta kiñe rünge safana, fey nagümelngey Jesus ñi kuerpu, fey iwüdüfi tati safana mew. Feymew müten yefi ka tukupufi kiñe rüngan lolo mew wengalelu chengke kura mew ka takukünufi ti konwe kiñe fütra kura mew. ");
INSERT INTO arnNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalena ka Maria Jose tañi ñuke, adkintuley engu chew püle tañi tukukünungen. ");
INSERT INTO arnNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dew rupalu tati ürkütun antü, Maria Magdalena, Maria Santiaw tañi ñuke, ka Salome, ngillay engün perfume tañi tukulelafiel engün Jesus tañi kuerpu. ");
INSERT INTO arnNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Fey ti llituchi antü semana mew, amuy engün ti rüngan lolo mew, epe tripalepalu wüla ta antü, ");
INSERT INTO arnNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","feypiniewi engün ta welukonkechi: —¿Iney am famentulelaeiñmew tati kura ti konwe mew? ");
INSERT INTO arnNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Welu adkintupulu engün, pefi tati fütra kura takuniekefulu tati rüngan lolo ñi mülewetunon ti konwe mew. ");
INSERT INTO arnNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Fey konpulu engün tati rüngan lolo mew, pefi, anülelu man ad püle, ta kiñe weche wentru tukunielu kiñe alükechi fülang takuwün. Fey tati pu domo llükay engün, ");
INSERT INTO arnNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","welu tati weche wentru feypifi ti pu domo: —Llükakilmün. Eymün kintupefuymün ta Jesus Nasaret tuwlu, tati langümngelu kürus mew. Wiñomongetuy tati. Ngewetulay ta tüfa mew. Adkintufimün chew tañi elkünungefumum. ");
INSERT INTO arnNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Amumün ka feypiafimün kisu ñi pu disipulu, ka Pedro: ‘Kisu amualu ta Galilea, fey wüne puwalu ta eymün mew. Üyew ta peafimün, chumngechi tamün dew feypikünuetew.’ ");
INSERT INTO arnNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Feymew tati pu domo lefmawkülen tripatuy engün tati rüngan lolo mew, yafyafküley engün fente tañi llükalen. Chem dungu rume ta feypilafi engün ta iney no rume, llükalelu engün am. ");
INSERT INTO arnNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Fey dew rupan wiñomongetulu ta Jesus, fey küme liwentu ti llituachi antü semana mew, wünelu mew pewfaluwfi ta Maria Magdalena, tañi wemünentulelfiel ta regle weküfü. ");
INSERT INTO arnNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kisu amuy fey kimelelpufi tati pu miyawkelu ta Jesus engün, tati pu weñangkülelu ka ngümamekelu. ");
INSERT INTO arnNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Fey ti pu disipulu ta allkülu ñi wiñomongetun ta Jesus ka Maria tañi pefiel, feyentulay engün. ");
INSERT INTO arnNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dew rupalu tüfachi dungu, Jesus ta wiñome pewfaluwfi ta lelfün püle ñi epu disipulu, trekalelu engu rüpü mew. ");
INSERT INTO arnNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Fey tüfa engu ta amuy ñi kimelafiel tati pu kakelu disipulu, welu ta kisu engu ka femngechi feyentungelay. ");
INSERT INTO arnNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Fey wüla, Jesus pewfaluwfi tati mari kiñe pu disipulu, anülelu engün mesa mew. Lladkütudungufi tañi küme feyentunon mew ka tañi yafüpiwkengen mew engün, feyentunofilu engün am tati pu che ñi dew peetew kisu ñi wiñomongetun. ");
INSERT INTO arnNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Fey feypingey engün: —Amumün ta kom chüf mapu mew tamün kimelafiel ta kom che tüfachi werken montuluwün dungu. ");
INSERT INTO arnNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tati feyentulu ka fawtisangelu, fey ta montuay, welu tati feyentunolu, fey ta kondenangeay. ");
INSERT INTO arnNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ka femngechi tüfachi afmafal dungu ta yenieay tati pu feyentulu: iñche tañi pepiluwün mew ta wemünentuay ta weküfü, ka pepi dunguay we kakerume dungun, ");
INSERT INTO arnNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","nüay engün ñi kuwü mew ta filu, tunte elungele rume chem venenu rume, wesalkalayaeyew. Ka femngechi fampuwülay engün tañi kuwü tati pu kutran mew, fey tüfa engün ta tremotuay. ");
INSERT INTO arnNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Fey Ñidol Jesus rupan dungufilu tañi pu disipulu, yengetuy ta wenu mapu, fey puwtuy ta Ngünechen ñi man ad püle. ");
INSERT INTO arnNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Fey ti pu disipulu fill püle tripay engün ñi nütramyeafiel tati we kimelün dungu, fey Ñidol ta müley ta kisu engün mew, ka yafültukunieeyew ñi wewpiafiel ti we kimelün dungu Ñidol ka kellunieeyew ñi femael afmanngechi dungu. Felepe may.");
INSERT INTO arnNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Rume pütrüley tati yafüluwyelu ñi wiriafiel tati dew rupachi dungu iñchiñ mew, ");
INSERT INTO arnNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","chumngechi taiñ kimeltuetew ta tüfeychi pu che, pefilu engün am chumngechi ñi rupan ti dungu ellaka mew müten, fey engün am yefalngelu ñi kimelafiel ti werken dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Feymew iñche ka femngechi inaramtun kuñiwtun mew chumngechi ñi rupan kom tüfachi dungu. Fey ta famngechi kümelu trokifiñ tami wirilelafiel kom tüfachi dungu, eymi rume sakin wentru Teofilo, ");
INSERT INTO arnNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","femngechi tami doy küme kimafiel ñi rüfngen tami dew kimelelngeelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Feychi tripantu mew ta Erode longkolelu Judea mapu mew, fey mülerkey kiñe saserdote Sakaria pingelu, koneltulelu ta Abia ñi trokiñ saserdote mew. Fey kisu ñi kure Isabel pingerkey, Aaron ñi reñma tuwünche ürke. ");
INSERT INTO arnNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Fey mür engu lif mongen nierkey Ngünechen mew ka müngeltuniefuy Ñidol ñi werkün ley dungu, fey ta famngechi iney rume yafkay pirkelayafeyew engu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Welu Sakaria ñi kure nierkelay püñeñ, niepüñeñkerkenolu am. Ka femngechi mür putremürkey engu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Fentren trokiñ saserdote mülerkey, fey wimtulerkey engün ñi suertiafiel femngechi ñi kimam engün chem trokiñ ñi legtu tripael ñi poyeafiel ta Ngünechen ngillatuwe ruka mew. Fey kiñe antü, Sakaria ñi koneltulemumchi trokiñ saserdote legtu tripay ñi konpuael ti doy ponwitulechi ngillatuwe mew. Fey Sakaria ñi chaf pu saserdote üytueyew kisu ñi lüpümafiel ti insienso. ");
INSERT INTO arnNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Fey petu lüflu ti insienso, kom ti trawüluwkülechi pu che mekey ñi ngillatun wekuntu ti ngillatuwe ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Feymew Ñidol ñi werken püllü pewfaluwfi ta Sakaria. Witralerkey ti ngillatuwe ñi man ad püle chew lüpümngekey ti insienso. ");
INSERT INTO arnNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Fey Sakaria, pefilu ti werken püllü, rume pellkenagi. ");
INSERT INTO arnNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Welu ti werken püllü feypieyew: —Sakaria, llükakilnge. Ngünechen ta allküñmaeymew tami ngillatun, fey tami kure Isabel nieay kiñe wentru püñeñ, fey ñi üy Juan pintukulelafimi. ");
INSERT INTO arnNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Eymi ta rume ayüwaymi, fey ka femngechi ti kakelu pu che rume ayüway ti pichiche ñi choyüngen mew, ");
INSERT INTO arnNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tami fotüm am rume fütra kim wentrungealu Ñidol ñi dungu mew. Fey kisu chumkawnorume putulayay pulku ka pitarilla no rume. Petu ñi choyüngenon, nieay ti Lif Küme Püllü ñi piwke mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Fey kisu ñi wewpiaelchi dungu mew rume fentren che, Israel mapu mew mülelu, wiñorakiduamtuay engün Ñidol Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Fey Juan wüne llituay ñi wewpiyeafiel Ñidol ñi dungu petu ñi pewfaluwnon ti Cristo. Chumngechi pepiluwün niefuy tati pelon wentru Elia ka feychi pepiluwün nieay ta kisu. Fey ti pu fotümwen kümelkawtuay engün ka ti pu wesake piwkengelu adümay ñi müngeltuael engün. Fey tüfa famngechi Juan kimeltunieafi tati pu che ñi llowafiel ta Ñidol. ");
INSERT INTO arnNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Feymew Sakaria ramtufi ti werken püllü: —¿Chumngechi am küme kiman ñi feyngeael tüfachi dungu? Iñche ta rume füchan dewma ka ñi kure rume kusey. ");
INSERT INTO arnNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Fey ti werken püllü llowdungueyew: —Iñche ta Gabriel pingen, iñche poyekefiñ ta Ngünechen. Kisu ta werküenew tami dungupayafiel ka tami feypipayafiel tüfachi küme dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Welu fewla, feyentunolu am ta eymi tami feypipefielchi dungu, feymew ketroaymi. Fey pepi dungulayaymi puwle wüla ti antü ñi mupiael kom tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Welu ti pu che wekuntu ti ngillatuwe ruka mew üngümnierkefi engün ta Sakaria ka welukonke ramtukawmekeyngün chumngelu ñi fente pütrüñman. ");
INSERT INTO arnNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Fey alün mew wüla tripapatuy, welu pepi dungurkelay. Feymew ngüneduamingün ta Sakaria ñi pen kiñe werken püllü ti ngillatuwe mew, fey ti pu che kimelelpatueyew ta Sakaria ñi kuwü mew ñi rupaelchi dungu. Fey femngechi amuley ñi pepi dungunon. ");
INSERT INTO arnNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Fey Sakaria dewelkalu ñi poyefiel ta Ngünechen, amutuy ñi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Fey dew rupalu tüfa, kisu ñi kure Isabel niepüñeñüy. Femngechi kechu küyen tripalay ñi ruka mew ñi witranngeyawael kake rukache mew, rakiduamkülerkelu am tüfachi dungu mew. Fey feypi: ");
INSERT INTO arnNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ñidol ñi piel mew niean kiñe püñeñ, fey femngechi tati pu che ‘niepüñeñkelay’ piwelayaenew” pirkey ta Isabel. ");
INSERT INTO arnNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Fey puwlu kayu küyen, Ngünechen werküfi ti werken püllü, Gabriel pingelu, kiñe waria mew Nasaret pingelu, mülelu Galilea trokiñ mapu mew, ");
INSERT INTO arnNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","tañi witranngepayael kiñe fütangenochi üllchadomo mew, Maria pingelu. Fey tüfa eludunguniewürkey ñi kureyewael kiñe wentru engu Jose pingelu, ti longko ülmen David ñi yomelche. ");
INSERT INTO arnNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Fey ti werken püllü akuy chew ñi mülemum ta Maria, fey feypipafi: —¡Chalipapeeyu, Ngünechen am sakinieetew ta eymi! Ñidol müley ta eymi mew. Rume sakifal domo ta eymi kakelu pu domo mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Feymew Maria pefilu ti werken püllü, pellkelkaeyew ñi dungun mew, fey kisutu ramtuwi ñi chem pifel chey ti chalin dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Fey ti werken püllü feypifi ta Maria: —Maria, llükakilnge. Eymi ta rume fütra ayüwün nieaymi Ngünechen tami füreneetew mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Fey niepüñeñaymi. Nieaymi ta kiñe wentru püñeñ, fey ñi üy Jesus pingeay. ");
INSERT INTO arnNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Rume fütra kim wentrungeay, fey fütra pepiluwün niechi Ngünechen ñi Fotüm pingeay. Ka femngechi Ñidol Ngünechen longko ülmenkünuaeyew, kisu ñi kuyfi tuwün em David reke, ");
INSERT INTO arnNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","fey rumel longko ülmenngeay ti Israel trokiñche mew. Fey ñi longko ülmenkülen chumkawnorume aflayay. ");
INSERT INTO arnNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Fey ramtueyew Maria: —¿Chumngechi am feleay tüfachi dungu? Petu fütangelan rume. ");
INSERT INTO arnNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Fey ti werken püllü feypifi ta Maria: —Tati Lif Küme Püllü akuay eymi mew, fey wenu mapu Ngünechen ñi pepiluwün akuay eymi mew kiñe tromü reke. Feymew ti pichiche tami choyüael Lif Mongenngeay ka femngechi Ngünechen ñi Fotüm pingeay. ");
INSERT INTO arnNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tami reñmanieelchi domo Isabel ka femngechi niealu ta kiñe wentru püñeñ, tunte dew kusefuy rume. Tati niepüñeñkenolu pikefel, fey kayu küyen dewma niepüñeñküley. ");
INSERT INTO arnNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ngünechen mew ngelay chem dungu no rume pepilfalnolu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Feymew Maria feypi: —Iñche poyekefiñ ta Ñidol. Felepe müten iñche mew tami feypipefielchi dungu. Feymew ti werken püllü amutuy. ");
INSERT INTO arnNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Fey rupalechi antü mew, Maria amuy kiñe waria mew mülelu ta Judea ñi wingkulngechi mapu püle. ");
INSERT INTO arnNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Fey puwlu Sakaria tañi ruka mew, konpuy ka chalipufi ta Isabel. ");
INSERT INTO arnNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Feymew Isabel, allkülu Maria ñi chalipun, fey ñi püñeñ nengümkawi ñi pütra mew, kisu ñi piwke mew llowlu am ti Lif Küme Püllü. ");
INSERT INTO arnNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Feymew newentu dungun mew feypi: —¡Ngünechen ta doy küme felen elueymew kom ti kakelu pu domo mew ka tami püñeñ rume küme felen eluafi! ");
INSERT INTO arnNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ineyfel anta iñche, ta Ñidol ñi ñuke tañi femngechi witrankontupayaetew? ");
INSERT INTO arnNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pürümka müten allkülu iñche tami chalipan, iñche ñi püñeñ ayüwlu nengümkawi iñche ñi pütra mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Rume sakin domongeaymi tami feyentun mew femngechi tañi mupiael kom ti dungu tami feypietew ta Ñidol. ");
INSERT INTO arnNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria feypi: “Iñche ñi piwke mew püramyefiñ ta Ñidol ñi fütra pepiluwünngen mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Iñche ñi piwke rume ayüwi ñi Montulchefe Ngünechen mew, ");
INSERT INTO arnNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ngünechen am kutranpiwkeyeetew ta iñche, tañi kuñifal domongen. Fey fantepu mew ka rumel sakin domo pingean. ");
INSERT INTO arnNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Rume fütra dungu pengeli iñche mew tati kom pepiluwünngelu, tati ¡trürümfalnochi küme üy nielu! ");
INSERT INTO arnNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ngünechen rumel kutranpiwkeyekefi tüfeychi pu che tañi yamnieetew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Afmatufal dungu femi kom ñi pepiluwün mew. Elulafi ñi femael ñi adkünuelchi dungu tati pu mallmangelu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Müntuñmafi ti pu longko ülmen ñi nieelchi pepiluwün, fey dullifi ñi füreneafiel tati kuñifall ñom piwkengelu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kümeke dungu kimeltufi tati küpa allkütulelu Ngünechen ñi dungu, welu ti pu kimkawünngelu Ngünechen ñi dungu mew kimeltulafi chem küme dungu no rume. ");
INSERT INTO arnNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kellufi tañi Israel trokiñche, kisu ñi pu kona, ka ngüyünentulafi ñi füreneafiel kutranpiwkeyen mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Femngechi tukulpakünulelürkefilu am taiñ kuyfi tuwün em, Abraam, ka ñi pu yomelche.” ");
INSERT INTO arnNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Feymew Maria mülewepuy Isabel ñi ruka mew küla küyen, fey wüla küpatuy ñi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Fey puwlu ñi püñeñael ta Isabel, fey kiñe wentru püñeñ nierkey. ");
INSERT INTO arnNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Fey kimlu ñi pu karukatu che ka ñi pu reñma ñi femngechi pengelün ñi kutranpiwkeyechen ta Ñidol kisu mew, amuy engün ñi pemeaetew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Fey pura antü nielu ti pichiche, yengey ñi sirkunsidangeael, fey rakiduamkülerkefuy engün ti pichiche ñi lakuntukuafiel ñi chaw mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Welu kisu ñi ñuke feypi: —Femlayay. Juan pingeay tati. ");
INSERT INTO arnNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Feymew llowdungungey: —Welu tami pu reñma mew iney no rume Juan pingelay. ");
INSERT INTO arnNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Feymew ka ramtungey re maychilkuwün mew ti ngen fotüm chem üy ñi nieael ti pichiche. ");
INSERT INTO arnNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Fey ti ngen fotüm feypi ñi rulelngepayael kiñe pichi trafla tañi wirintukuael ti üy. Fey wirintukuy: “Juan pingey ñi üy tati”. Fey kom ti pu che rume afmatuleweyngün. ");
INSERT INTO arnNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Fey feychi lelen mew müten Sakaria wiñome pepi dungutuy, ka eluwi ñi püramyeafiel ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Fey kom che mülelu Judea ñi wingkul trokiñ mapu mew nütramyefi engün feytichi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kom tüfeychi pu che allküyelu tüfachi dungu, kisuke ramtuwingün: “¿Chumngechi wentrungeay chey tüfachi pichiche?” rüf mew am pengel-lu ta Ñidol ñi pepiluwün tati pichiche mew. ");
INSERT INTO arnNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Fey Sakaria, tati pichiche ñi chaw, ngünenieetew ti Lif Küme Püllü, nütramyefi ta Ngünechen feypilen mew: ");
INSERT INTO arnNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Rume fütra püramyengepe ta Ñidol, Israel tañi Ngünechen, kisu küpalu am ñi montulael tañi trokiñche! ");
INSERT INTO arnNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Werküleleiñmew kiñe fütra pepiluwün niechi Montulchefe, David ñi yomelche, kisu tañi kona. ");
INSERT INTO arnNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Fey tüfachi dungu lle tañi tukulpakünuel kuyfi mew kisu ñi pu lif mongen pelon wentru mew: ");
INSERT INTO arnNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Taiñ montulaetew pu kayñe mew ka kom taiñ üdenieetew mew ");
INSERT INTO arnNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ka femngechi ñi kutranpiwkeyeafiel taiñ kuyfike tuwün em ka ñi ngüyünentunoafiel ñi nor küme eldungu. ");
INSERT INTO arnNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Fey tüfa ürke tañi kuyalltu dungulelfiel ta Abraam iñchiñ taiñ wünen chaw em: ");
INSERT INTO arnNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kisu taiñ Ñidol montulürkeaetew iñchiñ taiñ pu kayñe mew, femngechi taiñ poyeafiel ta Ñidol fey taiñ llükanon rume. ");
INSERT INTO arnNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ka femngechi taiñ müleael fill antü Ñidol ñi ayfiñ mew lif piwke mew ka nor mongen mew tuntepule taiñ mongen. ");
INSERT INTO arnNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Fey eymi kay, iñche ñi pichi fotüm, wenu mapu Ngünechen ñi pelon wentru pingeaymi, eymi am wüne llitualu tami wewpin ta Ñidol mew. Ka küme ngülamafimi ti pu che ñi llowngeael ta Ñidol. ");
INSERT INTO arnNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Femngechi ta kimeltuafimi ti trokiñche Ngünechen tañi wiñoduamatuaetew engün ñi yafkan mew ka ñi llowael ta montuluwün. ");
INSERT INTO arnNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Iñchiñ taiñ Ngünechen, ñi rume kuñillchen mew küpaleleiñmew wenu mapu mew, tati antü reke felelu kiñe we pelon nielu, ");
INSERT INTO arnNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","femngechi ñi pelontulelafiel reke ñi kimeltun mew tati müleyelu feyti doy wesake dungu mew dumiñ reke felelu, ka taiñ küme ngülamtupayaetew taiñ küme amuleael feyti küme tüngünngechi rüpü mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Fey ti pichiwentru amuley ñi doy tremkülen ka amuley ñi doy kimün, fey tremürkey ti uwe mapu mew puwlu wüla ti antü ñi pewfaluwael ñi wewpilelafiel tati pu israelche. ");
INSERT INTO arnNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Fey üyechi tripantu mew tati Roma waria mew mülechi emperador, Awgustu pingelu, werküy ñi rakingeael ti pu che mülelu kom trokiñke mapu. ");
INSERT INTO arnNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Fey tüfachi wüne rakichen müley feychi gobernadorkülelu ta Sirenio Siria trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kom che amurkealu kisuke ñi tremtripaelchi waria mew ñi wirintukuael ñi üy ka ñi rakintukungeael. ");
INSERT INTO arnNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Feymew Jose tripapay ta Nasaret waria mew, mülelu Galilea trokiñ mapu mew, fey amuy Belen waria mew, mülelu Judea trokiñ mapu mew, chew ñi choyüngemum tati longko ülmen em David pingelu, Jose am David ñi yomelche ürke. ");
INSERT INTO arnNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Fey amurkey Jose ñi kure engu üyew ñi wirintukuael ka ñi rakingeael ñi üy, fey Maria ta niepüñeñkülerkey. ");
INSERT INTO arnNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Fey mülepalu engu ta Belen, puwürkey ti antü ñi püñeñael ta Maria. ");
INSERT INTO arnNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Fey penolu engu am umañtuwe ruka chew ñi umañtuam, umañturkeyngu kiñe ruka kulliñ mew. Tüfey mew choyürkey Maria ñi wünen wentru püñeñ, fey chodimürkefi choñe mew ka umawelfi. ");
INSERT INTO arnNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Fey Belen ñi fülpüle mülerkey kiñeke ufisakamañ pun llüwatunielu ñi pu ufisa lelfün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Feymew perumefi engün Ñidol ñi kiñe werken püllü, fey Ñidol ñi fütra pepiluwün alofürkey kisu engün ñi wall püle, fey rume llükarkeyngün. ");
INSERT INTO arnNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Welu ti werken püllü feypieyew engün: “Llükakilmün. Iñche ta feypiwayiñ kiñe küme dungu, fey tüfa rume fütra ayüwünngeay ta kom che mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tüfachi pun ta choyüngey David ñi waria mew kiñe Montulchefe, feyti Cristo, tati Ñidolngealu. ");
INSERT INTO arnNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Fey ta famngechi kimaymün ñi feyngen tüfachi dungu: Pepuafimün ti pichiche, kiñe ruka kulliñ mew chodimkülelu choñe mew ka kudulelu chew ñi ikemum ti pu kulliñ.” ");
INSERT INTO arnNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Feychi lelen mew müten ka pewfaluwi fentren werken püllü wenu mapu tuwlu, fey trawüpay tati kiñe werken püllü engün, fey püramyefingün ta Ngünechen feypilen mew: ");
INSERT INTO arnNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Püramyengepe ta Ngünechen wenu mew! Ka küme tüngün mülepe ta mapu mew feytichi pu che llownielu kisu ñi fürenechen.” ");
INSERT INTO arnNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Feymew ti pu werken püllü wiñome püratulu ta wenu mapu, fey ti pu ufisakamañ welukonkechi feypiwingün: “Amuiñ ta Belen taiñ pemeael taiñ kimelngepapeelchi dungu ta Ñidol.” ");
INSERT INTO arnNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Feymew müten rume matu amuyngün, fey pepufingün ta Maria ka Jose ka ti pichiche kudulelu ti ruka kulliñ mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Fey pepufilu engün, pürüm nütramkapuy kom ñi chem pietew ti werken püllü ti pichiche mew, ");
INSERT INTO arnNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","fey kom tati allküleyelu ti pu ufisakamañ ñi feypipun tüfachi dungu, rume afmatuleweyngün. ");
INSERT INTO arnNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Welu Maria rakiduamkülerkey ka piwkentukuniey kom tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Feymew ti pu ufisakamañ wiñomelu engün, püramyeniefi ka ülkantulniefi ta Ngünechen kom tañi peel mew ka ñi allküel mew, fey kom felerkelu am chumngechi ñi feypikünungeel engün. ");
INSERT INTO arnNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Fey ti pichiche nielu pura antü, sirkunsidangey, fey Jesus pintukulelngey ñi üy, chumngechi tati werken püllü ñi feypikünufiel ta Maria, feychi petu niepüñeñkülenolu. ");
INSERT INTO arnNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Fey puwlu ti antü ñi lifngetuael engu chumngechi ñi chem pilen Moyse ñi ley dungu mew, ka yengey ti pichiche ta Jerusalen waria mew femngechi tañi ngillatuñmafalngeael ta Ñidol mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Fey tüfa femngey Ñidol ñi ley dungu am feypilelu: “Kom wünen wentru püñeñ müley ñi chalintukulelngeael ta Ñidol.” ");
INSERT INTO arnNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ka femngechi yeniey engu tañi wülmeael ñi langümngeael epu ñom maykoño ka epu pichike we palluma chumngechi feypiley Ñidol tañi ley dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Fey üyechi tripantu mülerkey Jerusalen kiñe putrem fütache Simeon pingelu. Rume lif piwke wentru ürke. Püramyekerkefi ngillatun mew ta Ngünechen ka üngümnierkey ñi montulngeael ta israelche ñi pu kayñe mew. Fey ti Lif Küme Püllü mülelu Simeon mew, ");
INSERT INTO arnNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","fey kimelürkeeyew ñi lanoael wüne penofile tati Cristo, tüfey ürke Ñidol tañi werküael. ");
INSERT INTO arnNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kimeletew mew tati Lif Küme Püllü, Simeon amuy tati ngillatuwe ruka mew. Feymew ti pichiche Jesus ñi chaw ka ñi ñuke puwüleyew ti ngillatuwe ruka mew femngechi ñi mupituael chumngechi ñi feypilen ti ley dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Feymew Simeon metatufi ti pichiche ka püramyefi ta Ngünechen feypilen mew: ");
INSERT INTO arnNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ñidol, fewla mupiy tami tukulpaelchi dungu. Adkünuafimi may tami kona ñi layael küme tüngün mew, ");
INSERT INTO arnNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","dew pefilu am iñche ti Montulchefe, ");
INSERT INTO arnNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","tami pepikaelchi montun itrokom trokiñchengealu. ");
INSERT INTO arnNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pelon reke felealu kom mapu mew, ka femngechi tañi püramyengeael tami Israel trokiñche mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jesus ñi chaw ka ñi ñuke, allküñmafilu ñi feypiel ta Simeon tati pichiche mew, rume afmatulewey engu. ");
INSERT INTO arnNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Feymew Simeon ngillatuñmafi tati pichiche, ka feypifi ta Maria, Jesus ñi ñuke: —Allkütunge. Tüfachi pichiche elngey ta Israel mew femngechi ta fentren che tañi tuteafiel ka tañi tutenoafiel. Kisu ta kiñe adkünuelchi dungu reke feleay, fey rume fentren che llowlayaeyew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Femngechi ta kimüñmangeay ñi chem rakiduamkülen tati pu che ñi piwke mew. Welu kom tüfa kiñe wayki reke feleay eymi mew tati rumealu rangiñ eymi tami piwke mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ka mülerkey tüfey mew kiñe domo Ana pingelu, dungukelu Ngünechen ñi üy mew. Fanuel ñi ñawe ürke, Aser ñi trokiñ reñma mew tuwlu. Rume kuserkey dewma. Rume üllchadomolen fütangerkefuy, fey mongeñperkeeyew ñi füta regle tripantu müten. ");
INSERT INTO arnNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pura mari meli tripantu ruparkey ñi dew lantumum. Amukerkey ti ngillatuwe ruka mew, fey püramyekerkefi ta Ñidol antü ka pun kütu. Kiñeke nag ayunakey ka ngillatulekey. ");
INSERT INTO arnNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Feymew Ana puwürkey feychi lelen mew, feymew eluwi ñi mañumafiel ta Ngünechen ka ñi nütramyeafiel ti pichiche Jesus mew kom ti pu che tati üngümnielu ñi montulngeael ta Jerusalen waria che ñi pu kayñe mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Fey dew fempalu kom ti dungu ñi werkünieel ta Ñidol ñi ley dungu, wiñotuyngün ta Galilea, kisu engün ñi waria Nasaret mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Fey ti pichiwentru amuley ñi tremkülen ka ñi doy newenngen ñi kuerpu mew ka ñi doy kimün, fey Ngünechen fürenenieeyew kom dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Fey Jesus ñi chaw ka ñi ñuke fill tripantu amukerkey Jerusalen ti Paskua pingechi kawiñ antü mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Feychi mew Jesus nielu mari epu tripantu, amurkey üyew kom engün, kiñe wimtun ürke am tati kawiñ antü. ");
INSERT INTO arnNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Welu dew rupalu tüfeychi kawiñ antü, wiñome amuletulu engün ñi ruka mew, ti pichiwentru Jesus mülewey ta Jerusalen, welu ñi chaw ka ñuke ngüneduamürkelay engu. ");
INSERT INTO arnNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Rakiduamkülerkeyngu ñi küpaletun rangi ti pu che mew. Fey kiñe kom antü trekalepaturkey engün, feymew kintufilu engu ñi pu reñma mew ka ti pu karukañma mew, ");
INSERT INTO arnNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","perkelafi engu. Feymew müten wiñotuy engu ta Jerusalen ñi kintumetuafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Fey rupalu küla antü wüla, petufingu ti ngillatuwe ruka mew. Anüley rangi ti pu kimeltukelu Moyse ñi ley dungu, allkütuñmaniengey ñi chem pimeken ka ramtukaniengey. ");
INSERT INTO arnNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Fey kom tüfeychi pu che allkütuñmanieetew ñi dungun, rume afmatulewey engün ñi rume kimün mew ka kisu ñi fente küme llowdungun mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Feymew Jose engu Maria peputufilu ta Jesus, pellkelewey engu. Fey Maria feypifi ta Jesus: —Iñche ñi püñeñ, ¿chumngelu anta femngechi femmuyu? Tami chaw ka iñche kintuyawüluwpeyiñ rume kutrantupiwken mew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Feymew Jesus llowdungueyew: —¿Chumngelu anta kintumupen? ¿Kimlaymu anta ñi müleael iñche tañi Chaw ñi dungu mew? ");
INSERT INTO arnNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Welu kisu engu kimlay ñi chem pifetew. ");
INSERT INTO arnNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Feymew Jesus wiñotuy ñi fütakeche engün Nasaret mew. Ka femngechi küme puwtulepatuy itrokom dungu mew. Fey kisu ñi ñuke piwkentukuniey kom tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Fey Jesus amuley ñi doy tremkülen ka ñi doy kimün. Ka kom dungu mew Ngünechen sakinieeyew ka femngechi femeyew ti pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mari kechu tripantu puwlu ñi longko ülmenkülen tati emperador Tiberio pingelu, Ponsio Pilato longkolerkey Judea mapu mew, Erode longkolerkey Galilea mapu mew, ka kisu ñi peñi Felipe longkolerkey Iturea ka Trakonite mapu mew, fey Lisania longkolerkey ta Abilinia mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas engu Kayfas longkolerkey tati pu saserdote mew. Feychi tripantu, Ngünechen dungufi ta Juan, Sakaria ñi fotüm, mülelu ti uwe mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan miyawi kom lelfün mew mülelu inafül Jordan lewfü püle, feypiniefi ti pu che ñi wiñorakiduamtuael engün ta Ngünechen mew ka ñi fawtisangeael, femngechi ta Ngünechen ñi wiñoduamatuaetew ñi yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Fey tüfachi dungu felerpuy chumngechi tañi wirintukuel tati pelon wentru Isaia: “Allküngey kiñe dungun ñi wirarkülen ti uwe mapu mew: ‘Kiñe nor küme rüpü reke feletupe tamün rakiduam, femngechi tamün llowafiel ta Ñidol. ");
INSERT INTO arnNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","6","Kom lüngkawngechi mapu, kom wingkul ka ti külleg ka ti lolkawkülechi rüpü feley ñi llüdümngetuael, fey femngechi kom piwke müley ñi nietuael tati we küme rakiduam. Fey ta famngechi itrokom che peay ta Ngünechen ñi wülaelchi montun.’ ” ");
INSERT INTO arnNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Fey Juan famngechi wewpilelfi ti pu che puwyelu kisu mew ñi fawtisangeael: “¡Llükangechi llepü filu reke ta feleymün! ¿Iney anta feypieymünmew fawtisangelmün tamün montuael tati fülkülepachi fütra kutrankachen mew? ");
INSERT INTO arnNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Welu may nietuaymün kiñe lif mongen femngechi ta küme pengelaymün tamün dew wiñorakiduamtun ta Ñidol mew, welu ngelay tamün feypiael kisuke ta eymün: ‘¡Iñchiñ ta Abraam ñi küpalme!’ Iñche rüf dungu feypiwayiñ Ngünechen tüfachi pu kura femkünuafuy Abraam ñi yomelchengeael. ");
INSERT INTO arnNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chumngechi ta toki puwküley ñi folil katrünentuafiel kiñe anümka, ka femngechi puwküley ta Ngünechen ñi ramtukadungucheael, fey chem che rume wiñorakiduamtunole, kiñe anümka reke katrüngeay ka tukungeay kütral mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Feymew ti pu che ramtueyew: —¿Fey chem chumaiñ anta tüfa? ");
INSERT INTO arnNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Fey Juan llowdungufi ti pu che: —Feytichi nielu epu mudaw takuwün, eluafi ti nienolu kiñe no rume. Ka feytichi nielu iyael, tañi eluafiel feytichi nienolu. ");
INSERT INTO arnNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ka femngechi fülpayngün ti pu kofrakelu impuestu Romangealu ñi fawtisangeael engün, fey ramtungey ta Juan: —Kimeltufe. ¿Iñchiñ kay, chem chumaiñ anta tüfa? ");
INSERT INTO arnNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Fey Juan feypieyew: —Doy ingentu kofrakefilmün ti pu che tamün kofrakefielchi impuestu. ");
INSERT INTO arnNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ka kiñeke ti pu soltaw ramtufi ta Juan: —Iñchiñ kay, ¿chem chumaiñ chey tüfa? Fey Juan llowdungueyew engün: —Iney no rume müntuñmakelayafimün chem chemkün no rume llükalkatun mew. Ka feypintukukelayafimün rume ta che ñi femnoelchi dungu mew. Ka küme duamkülemün tamün wewkeelchi pülata mew. ");
INSERT INTO arnNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Fey ti pu che rume afmatulen ka welukonke ramtumekeyngün, fey ñi Cristongepen may ta Juan, ");
INSERT INTO arnNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","welu Juan feypiniefi kom ti pu che: “Iñche ta feyngey tañi fawtisachepen ta ko mew, welu küpaley ta kangelu, fey ta fawtisayaeymünmew ti Lif Küme Püllü mew ka kütral mew. Kisu ta niey doy fütra pepiluwün iñche mew, fey iñche fente tañi yamniefiel mew ta kisu, nentupüroñmalayafuiñ rume tañi koriwen okota. ");
INSERT INTO arnNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kisu nüniey reke tati trüytrüywe, fey ñi liftuafiel tati kachilla ka ñi püntünentuafiel tati pinu. Fey kisu ñi elketranwe mew elkünuafi ti fün, fey lüpümafi ti pinu chumkawnorume chongnoachi kütral mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Fey ta famngechi wiñorakiduamtumün piniefi fentreken ngülam mew, Juan kimelniefi ti pu che tüfeychi küme dungu tañi wiñorakiduamtuael engün. ");
INSERT INTO arnNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ka femngechi katrütudungufuy ta Erode ti gobernadorkülelu, kisu am müntuñmafilu ñi peñi ñi kure, tati Erodia pingechi domo. Fey Juan katrütudungufuy ta Erode kom tañi wesa femkeel mew. ");
INSERT INTO arnNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Fey Erode tañi wiñorakiduamtuafel, doy amulkünuy ñi wesa femün, fey werküy ñi püresukünungeael Juan ta karsel mew. ");
INSERT INTO arnNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Fey Juan, petu fawtisafilu tati pu che, Jesus ka fawtisangey. Fey Jesus petu ngillatulu, wengatripay reke tati kallfü wenu. ");
INSERT INTO arnNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Feymew tati Lif Küme Püllü pengey ñi nagpan kisu mew kiñe palluma reke, feymew ka allküngey kiñe dungun wenu mapu, feypinagpalu: “Eymi ta iñche ñi sakin Fotüm, tañi fentren manelnieel.” ");
INSERT INTO arnNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Fey Jesus nielu kiñe küla mari tripantu, fey llituy tañi wewpin küdaw. Jose ñi fotüm trokiniengekerkefuy. ");
INSERT INTO arnNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","fey ka femngechi Matat em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ka femngechi Matatias em ñi fotüm ürkefel, ka Amos em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mat em ñi fotüm ürkefel, ka Matatias em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ka Joana em ñi fotüm ürkefel, ka Resa em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ka femngechi Melki em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josue em ñi fotüm ürkefel, ka Elieser em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ka Levi em ñi fotüm ürkefel, ka Simeon em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ka Melea em ñi fotüm ürkefel, ka Mena em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ka David em ñi fotüm ürkefel, ka Isay em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ka Aminadab em ñi fotüm ürkefel, ka Aram em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ka femngechi Jakob em ñi fotüm ürkefel, ka Isaak em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ka femngechi Serug em ñi fotüm ürkefel, ka Ragaw em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ka femngechi Kaynan em ñi fotüm ürkefel, ka Arfaksad em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ka femngechi Matusalen em ñi fotüm ürkefel, ka Enok em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ka femngechi Enos em ñi fotüm ürkefel, ka Set em ñi fotüm ürkefel, ");
INSERT INTO arnNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus ngünenieetew ti Lif Küme Püllü, wiñopay ti Jordan lewfü mew, fey Ngünechen ñi Lif Küme Püllü ñi pepiluwün mew puwi ti uwe mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Üyew mülepuy meli mari antü, fey ti weküfü kintukaduameyew. Chem iyael rume irkelay feychi rupayechi antü mew, fey rupalu ti meli mari antü wüla, fey ngüñüy. ");
INSERT INTO arnNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Feymew ti weküfü feypieyew: —Eymi ta Ngünechen ñi Fotüm, fey feypifinge may ti kura ñi kofkewtuael. ");
INSERT INTO arnNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Fey Jesus llowdungufi ti weküfü: —Ti Wirin Chillka ta feypiley: ‘Re kofke mew müten ta mongeluwkelay ta che, welu ka femngechi mongeleay Ngünechen ñi dungu mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Feymew ti weküfü kiñe lelen mew doy alü püralu mew puwüleyew. Fey pengeleleyew kom ti trokiñke mapu müleyelu kom chüf mapu mew, ");
INSERT INTO arnNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","fey feypieyew: —Iñche eluaeyu kom tüfachi pepiluwün ka femngechi tati fentren chemkün ñi nieel ti trokiñke mapu. Iñche kom elungen tati, feymew eluafiñ iney rume iñche tañi ayüel. ");
INSERT INTO arnNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Eymi kiñewülmi iñche mew ka püramyeeli ngillatun mew, kom chüf mapu eymingeay. ");
INSERT INTO arnNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Fey Jesus llowdungufi ti weküfü: —Ti Wirin Chillka mew ta feypiley: ‘Püramyeafimi ngillatun mew ka poyeafimi tami Ñidol Ngünechen müten.’ ");
INSERT INTO arnNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Feymew ti weküfü ka yeeyew ta Jerusalen waria mew, fey pürampueyew ti doy alü püralechi wechuñ ngillatuwe ruka mew, fey fepieyew: —Eymi ta Ngünechen ñi Fotüm, fey ütrüfnagümuwnge ta nageltu, ");
INSERT INTO arnNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Wirin Chillka mew am feypilelu: ‘Ngünechen werküay tañi werken püllü tami montulaetew. ");
INSERT INTO arnNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Witrañpüramtuaeymew ñi kuwü mew tami allfüpunoael ti kura mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Fey Jesus llowdungufi ti weküfü: —Ka feypiley ta Wirin Chillka: ‘Kintukaduamkefilnge ta Ñidol Ngünechen.’ ");
INSERT INTO arnNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Feymew ti weküfü, pewenolu ñi chumael ka chumngechi ñi kintukaduamafiel ta Jesus, püntütripatuy ta kisu mew kiñe mufün antü. ");
INSERT INTO arnNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Fey Jesus wiñotuy ta Galilea fey ti Lif Küme Püllü ñi pepiluwün mew. Re kisu mew müten nütramkaletuy ti pu che wall püle müleyechi trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kimeltuyawi kom püle chew ñi mülemum ta sinagoga, fey kom ti pu che rume sakieyew. ");
INSERT INTO arnNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Fey Jesus mülepuy ta Nasaret, tañi trempüramelchi waria mew. Fey ti ürkütun antü mew konpuy tati sinagoga mew femngechi wimtulerkelu am, feymew witray tañi chillkatuafiel tati Wirin Chillka. ");
INSERT INTO arnNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Fey elungey ñi chillkatuafiel Isaia ñi wirielchi dungu. Fey nülaentufilu, chillkatufi chew tañi wirintukulemum tüfachi dungun: ");
INSERT INTO arnNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ñidol tañi Lif Küme Püllü müley iñche mew. Kisu ta dullienew tañi wewpilelafiel tati we kimelün dungu tati pu ñom piwkengelu. Ka femngechi werküenew tañi kimelafiel tati pu püresulelu reke tañi yafkan mew ka ñi eluafiel pelon tati trawmangelu ka ñi montulpayafiel ti kutrankawünngechi mongelelu. ");
INSERT INTO arnNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ka tañi kimelael tañi dew akun ñi kimelngeael Ñidol ñi küme dungu.” ");
INSERT INTO arnNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Feymew Jesus pürüm chümpokünutufi ti chillka ka nüfüleltufi ti kellulelu sinagoga mew, fey anükünuwtuy. Feymew kom ti müleyelu tüfey mew lelinierkeeyew. ");
INSERT INTO arnNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Fey kisu llituy ñi dunguael feypilen mew: —Fachantü dew mupiy tüfachi wirin dungu eymün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kom ti pu che rume küme nütramyefi ta Jesus ka afmatuleweyngün ñi fente küme dungu ñi feypiel mew. Feymew welukonkechi ramtuwingün: —¿Tüfa no anta Jose tañi fotüm? ");
INSERT INTO arnNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Fey Jesus llowdunguy: —Rüf dungu mew feypimuan tati: ‘Eymi lawentuchefe, kisu wüne lawentunge tami pu che.’ Ka femngechi may ta feypimuan: ‘Taiñ allküel tami chumün ta Kapernaum ka femnge eymi tami mapu mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Fey amuley ñi feypilen: —Rüf dungu feypiwayiñ chem pelon wentru no rume, sakin chengekelay kisu ñi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Rüf dungu mew mülefuy fentren pu lantu domo Israel mew, feychi mongelelu ti pelon wentru Elia. Feychi mew mawünlay küla tripantu ka kayu küyen, fey rume müley ta ngüñün kom ti trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Fey Elia ta werküngelay ti pu lantu domo mülelu pu israelche mew, welu amuy ta Sarepta mülechi lantu domo mew, tüfa pülleley ta Sidon waria mew. ");
INSERT INTO arnNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ka rume mülerkey ti lepra kutranngelu feychi mongelelu tati pelon wentru Elisew, fey kiñe no rume tremolngelay engün, welu tremolngey ta Naman müten, Siria tuwlu. ");
INSERT INTO arnNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Femngechi feypingelu, kom tüfeychi pu che mülelu tati sinagoga mew rume lladküy engün. ");
INSERT INTO arnNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Feymew witrapüray engün ka wemünentufi engün ta Jesus feytichi waria mew, ka yefingün kiñe lilkülechi wingkul püle. Tüye mew ütrüfnagümafulu engün ta Jesus ti lilkülelu mew, ");
INSERT INTO arnNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","welu Jesus katrürupay kisu engün ñi rangiñ mew, fey kañpüle amutuy. ");
INSERT INTO arnNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Feymew Jesus amuy ta Kapernaum waria mew, tati mülelu ta Galilea. Tüfey mew kimeltumekefi ti pu che ti ürkütun antü mew. ");
INSERT INTO arnNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Feymew ti pu che rume afmatulewey tañi femngechi kimeltungen mew, ka fentren pepiluwün mew dungumekelu am. ");
INSERT INTO arnNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Fey ti sinagoga mew mülerkey kiñe wentru kontunieetew weküfü. Tati weküfü, fey tüfa wirarüy fütra newentu: ");
INSERT INTO arnNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Elkünumuiñ! ¿Chumngelu anta wütumupaiñ ta iñchiñ, Jesus Nasaret tuwlu? ¿Wütumupaiñ taiñ apümkamupayafiel? Iñche ta kimnieeyu, ka kimnien eymi ta Ngünechen tañi lif küme Dullinngen. ");
INSERT INTO arnNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Feymew Jesus katrütudungufi tiyechi weküfü feypilen mew: —¡Dungukilnge ka elkünutufinge ta tüfeychi wentru! Feymew ti weküfü ütrüfpuwülfi pülli mew ti wentru chew müley ti pu che, feymew tripatuy ti wentru mew ka chem wesa allfül-lafi rume. ");
INSERT INTO arnNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Femngechi kom pellkey engün, ka welukonkechi feypiwi engün: “¿Chem dungun anta tüfa? Kom pepiluwün mew ka newentu dungun mew tüfachi wentru wemünentufi ti weküfü ñi tripatuael ti wentru mew, ¡fey ti pu weküfü tripatukey!” ");
INSERT INTO arnNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Feymew itrokom püle mülechi pu che Galilea trokiñ mapu mew nütramyefi engün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tripatulu Jesus ti sinagoga mew, fey konpuy Simon ñi ruka mew. Simon ñi llalla rume aling kutrankülerkey, fey llellipungey ta Jesus ñi tremoltuafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Feymew Jesus nagkintufi ti kuse, fey werküfi ti aling kutran ñi tripatuael ti kuse mew, fey tremoltuy ti aling kutran mew. Feychi lelen mew müten Simon ñi llalla witratuy ka pürüm eluwi ñi poyeafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Fey dew ella konchi antü mew, kom ti pu kutranküleyelu ka fill wesake kutran nielu, küpalngey ta Jesus mew. Fey Jesus wente puwülelfi ñi kuwü kake kiñeke ti pu kutran, fey tremolyetufi. ");
INSERT INTO arnNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Fentren pu kutran mew wirarkülen tripayetuy ti pu weküfü: “¡Eymi Ngünechen ñi Fotüm lle!” pi engün. Welu Jesus katrütudunguniefi ti pu weküfü ka elulafi ñi dunguael engün. Jesus femngechi femfi tati pu weküfü, kisu engün am kimnieetew Ngünechen ñi Cristongen. ");
INSERT INTO arnNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Fey wünlu dewma, Jesus tripatuy ti waria mew, fey amuy püntütripalechi lelfün mew. Welu ti pu che kintueyew, fey puwi engün chew ñi mülepumum ta Jesus, ayürkefulu engün am Jesus ñi müleweael kisu engün mew, fey ñi amunoael kañpüle. ");
INSERT INTO arnNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Welu Jesus feypifi ti pu che: —Iñche müley tañi kimelafiel Ngünechen ñi küme dungu tati kakelu waria mew kafey, ñi femngechi femael am werküngelu ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Feyta famngechi Jesus miyawi ñi kimelafiel ti werken dungu ta Galilea müleyechi sinagoga mew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kiñe rupa, mülelu Jesus ti pichi lafken Genesaret pingelu ñi inafül mew, feytichi trokiñche welukonke rültrekawmekey kisu ñi inafül mew, ayülelu engün am tañi allkütuael Ngünechen tañi werken dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kiñeke challwafe elkünurkey epu farku inaltu ayliñ mew, feymew wellilerkey ti epu farku, feyti pu challwafe am amurkelu ñi küchametuael ñi challwawe. Feymew Jesus leliwülfi ti epu farku, ");
INSERT INTO arnNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","fey konpuy kiñe farku mew. Simon ürke tati ngenngelu, feymew Jesus feypifi ta Simon tañi pichi rültrentukungeael doy pichi ponwitu ti pichi lafken mew. Feymew anükünuwi ti farku mew, fey tüye mew Jesus eluwi ñi kimeltuafiel ti pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Fey Jesus dew kimeltuchelu, feypifi ta Simon: —Yenge tami farku chew doy llufülemum ti pichi lafken, fey tiye mew ütrüftukunge tami challwawe. Femngechi nentuaymi ta fentren challwa. ");
INSERT INTO arnNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Fey Simon llowdungueyew: —Kimeltufe, kiñe pun mekefuiñ taiñ challwan. Kiñe challwa no rume nentulaiñ, welu eymi tami feypin mew, ütrüftukutuan tañi challwawe. ");
INSERT INTO arnNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Fey femngechi femlu engün, ti challwawe epeke wiküri rume fentren challwa konlu am ti challwawe mew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Feymew maychilfingün tañi pu kompañ mülelu ti kangelu farku mew, fey tañi kellupayaetew. Feymew ñi pu kompañ amuy engün ñi kellumeaetew, fey epeke llañnagi ti ko mew ti epu farku fentren challwa am entulu engün. ");
INSERT INTO arnNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Feymew Simon ngüneduamlu ñi femngechi femel ta Jesus, lukutuy Jesus ñi inafül mew, fey feypieyew: —¡Ñidol, püntütripange ta iñche mew. Iñche ta kiñe yafkafe! ");
INSERT INTO arnNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Welu ta Simon ka kom ti kakelu llükarkey engün tañi fentren challwa ñi entun mew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ka femngechi femürkey Santiaw ka Juan, Sebedew tañi fotüm, fey tüfa engu Simon ñi kompañ ürke. Fey Jesus feypifi ta Simon: —Llükakilnge, tami challwafengefel, welu tüfa kintuafimi ta che tami küpalafiel iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Feymew nentufingün ti epu farku inaltu ti ayliñ mew, fey kom elkünuy engün ñi chemkün, fey amuy Jesus engün. ");
INSERT INTO arnNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kiñe antü, Jesus mülepulu kiñe waria mew, akuy kiñe wentru lepra kutran nielu, fey pefilu ta Jesus, lloyünagi pülli mew ka llellipufi ta Jesus: —Ñidol, pifulmi kay, tremoltuafen tañi kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus fampuwüleleyew tañi kuwü, fey feypieyew: —Ayülen tati. Tremotunge. Fey kiñe lelen mew müten niewetulay lepra kutran ti wentru, ");
INSERT INTO arnNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","feymew feypieyew ta Jesus: —Iney rume feypilayafimi tami tremoletun. Amunge tami leliwülaetew tati saserdote femngechi ñi kimael engün iñche ñi nien Ngünechen ñi pepiluwün. Tami tremotun mew, yeaymi mañumtun Moyse tañi werküel. Femngechi kom che kimay tami dew tremotun ti kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Fey tüfa ñi femün mew kake antü doy amuley ñi küme üytungen ta Jesus, ka rume fentreken che trawüluwmekey tañi allkütuaetew ka tañi tremoltuafiel ti pu kutran. ");
INSERT INTO arnNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Welu Jesus püntütripakefuy ñi ngillatuael ti lelfün püle chew ngelay kiñe ruka che no rume. ");
INSERT INTO arnNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kiñe antü Jesus mekelu ñi kimeltun, anükünuwürkey tüye püle kiñeke ti pu farisew ka ti pu kimeltukelu Moyse ñi ley dungu küpayelu kom ti lof mapu püle müleyelu Galilea, Judea ka Jerusalen waria mew. Fey Ngünechen ñi pepiluwün kimfali ñi mülen ta Jesus mew tañi tremoltukuniefiel mew ti pu kutran. ");
INSERT INTO arnNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Feymew akuy kiñe mufü wentru küpalniefilu ngütantu mew kiñe kutran lañmalelu ñi kuerpu. Ayürkefuy engün ñi konpuafel pu ruka tañi puwülafiel ti kutran Jesus ñi inafül, ");
INSERT INTO arnNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","welu pepil-lay engün chew püle ñi konpuael, mülerkelu am rume fentren che. Feymew pürapuyngün wente küpül ruka, fey wecharüfi engün ñi rulmeafiel ti kutran. Fey femngechi pültrü nagümngepuy ngütantu mew ti kutran rangi pu che, chew tañi mülemum ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Feymew Jesus ngüneduamfilu ñi nien engün fentren mupiltun, feypifi ti kutran: —Weni, dew wiñoduamangetuymi tami yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Feymew ti pu kimeltukelu Moyse ñi ley dungu ka ti pu farisew rakiduamürkey engün: “¿Iney anta tüfa? ¿Yamlafi ñi notukayafiel ta Ngünechen? Ngünechen müten ta wiñoduamachetuafuy ta yafkan mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Welu Jesus kisutu ngüneduami tañi femngechi rakiduamkülewen engün, feymew ramtufi ti pu kimeltukelu Moyse ñi ley dungu ka ti pu farisew: —¿Chem mew anta femngechi rakiduamküleymün? ");
INSERT INTO arnNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Chem pin anta doy küdawngelay: Ñi wiñoduamatuafiel ta che ñi yafkan mew, kam ñi tremoltuafiel ñi kutran mew? ");
INSERT INTO arnNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Welu tamün kimael tati Wentrukünuwpalu ñi nien ta pepiluwün ta mapu mew ñi wiñoduamachetuael ta yafkan mew, iñche tremoltuafiñ. Feymew Jesus feypifi tati lañmalelu ñi kuerpu: —Eymi ta feypipeeyu: Witrange. Nünge tami ngütantu ka amutunge tami ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Feychi lelen mew müten, ti wentru lañmalelu ñi kuerpu witrapüratuy, fey kom ti pu che penieeyew, ka yetuy ñi ngütantu chew tañi kudulefumum, fey amutuy ñi ruka mew ka püramyeniefi ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Feymew itrokom ti pu che afmatulewey, fey ka femngechi püramyefi engün ta Ngünechen. Fey rume llükan mew feypi engün: —Fachantü ta peiñ rume afmatufalchi dungu ―pi engün. ");
INSERT INTO arnNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Fey dew rupalu tüfachi dungu, Jesus tripapatulu ti ruka mew, fey pefi kiñe ti kofrakelu impuestu Romangealu, Levi pingelu. Tüfachi wentru anülerkey chew ñi kofraken ta impuestu. Fey Jesus feypifi ta Levi: —Inaen. ");
INSERT INTO arnNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Feymew Levi witrapüray, fey kom elkünuy ñi küdaw, fey inaeyew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Fey dew femlu tüfachi dungu, Levi nielürkefi ta Jesus kiñe fütra kawiñ kisu ñi ruka mew. Tüfey mew pütrülerkey ti kofrakelu impuestu Romangealu, ti kakelu pu che kafey, Jesus engün anülerkey kiñentrür ti mesa mew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Welu ti pu farisew ka ti pu kimeltukelu Moyse ñi ley dungu kiñewküley engün tañi fillpiafiel ta Jesus ñi pu disipulu. Feymew kisu engün feypifi tati pu disipulu: —¿Chumngelu am ipeymün ka putupeymün fey ti kofrakelu impuestu ka ti pu yafkafe eymün? ");
INSERT INTO arnNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Fey llowdungueyew ta Jesus kiñe adkünu dungu mew: —Kom tüfeychi külfünkülelu ka nienolu chem kutran rume duamtukelay tati lawentuchekelu, welu ti kutrankülelu may duamtukey lawentuchekelu. ");
INSERT INTO arnNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iñche küpalan tati pu küme piwkekawünnngelu mew, welu may tati pu yafkafe mew, fey ñi wiñorakiduamtuael engün ta Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Feymew ti pu farisew ka ti pu kimeltukelu Moyse ñi ley dungu feypifi engün ta Jesus: —Feytichi pu che miyawkelu Juan engün ka ti pu farisew rume ayunakey engün ka rume fentren ngillatukawkey, welu tami pu disipulu ilekey ka putulekey engün. ");
INSERT INTO arnNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Fey llowdungueyew ta Jesus: —¿Irkenoafulu anta tüfeychi mangelngelu mafün mew fey ñi mülen kisu engün mew tati nofio? ");
INSERT INTO arnNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Welu akuay ñi yengetuael ti nofio, fey akule feychi antü, fey wüla ta ayunayay engün. ");
INSERT INTO arnNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Feymew Jesus nütramelfi ti pu farisew ka ti pu kimeltukelu Moyse ñi ley dungu tüfachi adkünu dungu: —Iney rume katrükakelay kiñe we takuwün tañi lapayafiel kiñe llud takuwün. Fey famngechi femfule, rume wesalkayafuy ti we takuwün. Ka femngechi, ti we lapan kümelkalayafuy ti llud takuwün. ");
INSERT INTO arnNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ka femngechi feyti llud kueru apolngelayafuy ti we pulku mew. Feytichi we pulku wikürelafuy ti lludkülewechi kueru, femngechi ti kueru wiküray, fey ti pulku wütruay. ");
INSERT INTO arnNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Feymew müley ñi apolngeael kiñe we kueru ti we pulku mew. ");
INSERT INTO arnNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Iney rume dew putule ti wüntu pulku ayülayafuy ñi putuael ti we pulku, femngechi feypikelu am: ‘fey ti wüntu pulku doy kochüy.’ ");
INSERT INTO arnNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Fey kiñe ürkütun antü mew, Jesus rumerpuy rangi kachilla mew. Fey ñi pu disipulu suchetunenturpuy engün kiñeke longko kachilla ka rüngümyefi ñi kuwü mew ka ifingün ti fün. ");
INSERT INTO arnNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Feymew ramtueyew kiñeke ti pu farisew: —¿Chumngelu anta femimün kümenolu tañi femael ta che ti ürkütun antü mew? ");
INSERT INTO arnNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Feymew Jesus llowdungufi ti pu farisew: —Iñche David reke fempen. Rüf mew eymün kimlaymün ñi chumün ta David kiñe rupa kisu ka ñi pu kompañ ngüñülelu engün. ");
INSERT INTO arnNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Konpuy Ngünechen ñi ruka mew, fey nüpufi ti dullinke kofke Ngünechen tañi chalintukulelngeel, fey irkefi ka eluyefi ñi pu kompañ. Welu tüfachi kofke pu saserdote müten felerkefuy tañi iyafel. ");
INSERT INTO arnNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Feymew ka feypi: —Ti Wentrukünuwpalu Ñidolküley tati ürkütun antü mew. ");
INSERT INTO arnNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kangelu ürkütun antü mew, Jesus konpuy ta sinagoga mew, fey eluwpuy ñi kimeltuael. Tüfey mew mülerkey kiñe wentru lañmalelu ñi man kuwü, ");
INSERT INTO arnNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","fey ti pu kimeltukelu Moyse ñi ley dungu ka ti pu farisew ellka ngüneduamniefingün ta Jesus tañi tremolpeafiel may ti kutran ürkütun antü mew, femngechi adngell tañi dalluntukuafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Welu Jesus kimüñmafi tañi femngechi rakiduamkülen engün, fey famngechi feypifi tati wentru, lañmalelu ñi kuwü: —Witrange ka rangi ti pu che witrakünuwnge. Fey ti wentru witrapüray ka femngechi witrakünuwpuy rangi pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Feymew Jesus feypiyefi ti pu che: —Kiñe dungu ramtuwayiñ: ¿Chem anta eluniengey ta che tañi femael ürkütun antü mew? ¿Küme dungu kam wesa dungu? ¿Montulngeael kiñe mongen kam tañi elungeael ñi layael müten? ");
INSERT INTO arnNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Fey ka pürüm leliwülfi kom tüfey tañi walloñmanieetew, feymew feypifi tüyechi wentru: —Norümentunge tami kuwü. Fey ti wentru femürkey, feymew ñi kuwü tremolewetuy. ");
INSERT INTO arnNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Welu kakelu rume lladküyngün ka eluwi ñi üyawtudunguael fey ñi chem chumafiel rume engün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tüyechi antü mew, Jesus amuy kiñe wingkul mew ñi ngillatumeael, fey kiñe pun mekey ñi ngillatun ta Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Fey dew küme wünlu, mütrümfi ñi pu disipulu, fey kisu engün mew dullintufi ta mari epu wentru, fey tüfa engün apostol pintukulelfi. ");
INSERT INTO arnNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tüfa engün ürke: Simon, fey tüfa Pedro pintukulelfi ñi üy; Andre, Simon tañi peñi; Santiaw, Juan, Felipe, Bartolome, ");
INSERT INTO arnNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matew, Tomas, Santiaw, Alfew tañi fotüm; Simon tati Selote pikeel, ");
INSERT INTO arnNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juda, Santiaw ñi fotüm; ka Juda Iskariote, fey tüfa tati ellka wültukufilu ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesus nagpatuy ñi pu disipulu engün ti wingkul mew, fey mülewepay engün ti lür mapu mew. Fey trawüluwkülerkey tüye mew rume fentren che tañi inayawülkeetew ka rume fentren che tuwlu Judea trokiñ mapu, Jerusalen ka ti pu lafkenche waria Tiro ka Sidon. Akurkey engün tañi allkütuñmayafiel ta Jesus ñi kimeltun ka tañi tremolngetuael engün ñi kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Feytichi kutrankanieetew ti pu weküfü, ka femngechi tremolngeyetuy engün. ");
INSERT INTO arnNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Fey kom ti pu che ayürkey tañi idakünuafiel ta Jesus, kisu am nielu pepiluwün femngechi tañi tremolafiel tati pu kutran. ");
INSERT INTO arnNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus leliwülfi ñi pu disipulu, feymew feypifi ñi adnieelchi dungu: “Sakinngeymün eymün ti pu pofre, Ngünechen ta longko ülmenngey eymün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sakinngeymün eymün tati ngüñülelu, welu nietuaymün fentren iyael. Sakinngeymün tati ngümakelu, welu ta ayüwkületuaymün. ");
INSERT INTO arnNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Sakinngeymün üdeelmünmew ta kom pu che, ka wemünentungelmün, ka lukatungelmün ka illamtuñmangelmün tamün üy kiñe wesa üytun che reke, tat Wentrukünuwpalu ñi duam. ");
INSERT INTO arnNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Rume ayüwkeaymün, fentren ayüwün nieaymün feychi antü, eymün am llowalu kiñe fütra fürenen ta wenu mapu, fey ka femngechi llemay tüfachi pu che ñi pu tuwün em kutrankafi tati pu pelonke wentru. ");
INSERT INTO arnNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","¡Welu awngeaymün ta eymün pu riku, dew nielu am eymün tamün ayüwün! ");
INSERT INTO arnNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Welu awngeaymün eymün tati nielu kom kümeke felen, fey ngüñütuaymün! ¡Awngeaymün eymün tati ayekawkülekelu, welu ta ngümayaymün ta weñangkün mew! ");
INSERT INTO arnNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Awngeaymün ta eymün kom che mülelu mapu mew püramyeelmew, femngechi ta femkefuy tüfachi pu che kisu ñi kuyfike tuwün em, tati koylake pu pelon wentru mew! ");
INSERT INTO arnNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Welu eymün tati allkütupelu, feypiwayiñ: Piwkeyekeaymün tamün pu kayñe, küme duamtukeafimün tamün üdekeetew. ");
INSERT INTO arnNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ayülkeafimün ñi küme feleael tami wesa pikeetew, ngillatuñmakeafimün tamün wesa lukatukeetew. ");
INSERT INTO arnNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Iney rume wülelelmew kiñe püle tami ange mew, kangelu püle ka adkünulelafimi. Ka iney rume müntuñmaelmew tami takuwün, ka eluafimi tami müntuñmayaetew ti puñum takuwün. ");
INSERT INTO arnNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ka ineyngeay rume ‘eluen’ pielmew chem rume, eluafimi. Ka müntuñmaelmew eymi tami ngenngeel mew, ‘elutuen’ pipiyelayafimi. ");
INSERT INTO arnNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yamafimün ta kakelu che chumngechi ayükeymün tamün yamngeael. ");
INSERT INTO arnNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Eymün ta piwkeyefilmün tüfey engün tamün piwkeyekeetew müten, ¿chem küme dungu am tati? Tati pu yafkafe ka femngechi piwkeyewkeyngün. ");
INSERT INTO arnNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ka kellufilmün tamün kellukeetew müten, ¿chem küme dungu am tati? Tati pu yafkafe ka femngechi kelluwkey engün. ");
INSERT INTO arnNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ka femngechi arelfilmün tüfey engün tamün wiñoleltuaetew trokifiel müten, ¿chem küme dungu am tati? Ka femngechi tati pu yafkafe welukonke areluwkeyngün, femngechi tañi wiñoleltuael ñi aretuel. ");
INSERT INTO arnNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Eymün müley tamün piwkeyeafiel tamün pu kayñe, ka müley tamün femael kümeke dungu, ka tamün arengülümael, welu tamün üngümkületunoael chem kullitu rume. Femngechi ta kiñe küme kullitu llowaymün, ka femngechi eymün wenu mapu Ngünechen ñi yallngeaymün, kisu am rume küme piwkengelu kom tati mañumkenolu mew ka tati wesa piwkengelu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kutranpiwkeyechekeaymün chumngechi ta wenu Chaw kutranpiwkeyechekey. ");
INSERT INTO arnNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Yafkafengey pikelayafimün ta kakelu pu che, fey Ngünechen ka femngechi yafkafe pilayaeymünmew ta eymün. Ayülkefilnge ñi kutrankawael ta kakelu, fey Ngünechen kafey wesaduamtulayaeymünmew tamün kutrankawael. Tamün femafel, wiñoduamachetukeaymün femngechi Ngünechen wiñoduamatuaeymünmew. ");
INSERT INTO arnNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kellukeafimün ta kakelu che femngechi ta Ngünechen kelluaeymünmew ta eymün. Kisu eluaeymünmew ta kiñe küme kullitun tati kümelu, ngüchegkülelu ka küme apolelu. Ngünechen ta medilaeymünmew tamün femkeelchi dungu chumngechi ta eymün medilkefimün ta kakelu che.” ");
INSERT INTO arnNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ka feypieyew Jesus kiñe mufü adkünu dungu: “¿Kiñe trawma anta küñatuyeafuy ta rüpü mew ti kangelu trawma? ¿Mür engu may ta tranakonpeafuy chem lolo mew rume? ");
INSERT INTO arnNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ka tati we papeltulelu no rume doy kimlayafuy tañi kimeltufe mew, welu küme chillkatule, fey wüla kisu ñi kimeltufe reke ka femngechi kimay. ");
INSERT INTO arnNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Chumngelu anta fente ngüneduamüñmakefimi ti pichi itrom pinu ñi nieel ñi nge mew tami peñi, welu ngüneduamkelaymi ti itrom kiñe fütra trolüf mamüll reke felelu tami nge mew? ");
INSERT INTO arnNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Fey ngüneduamnolmi tami nien ti fütra trolüf mamüll reke felelu kisu tami nge mew, fey ¿chumngelu am feypikefimi tami peñi: ‘Nentuñmaeyu ti pichi itrom pinu tami nge mew?’ ¡Koyla ngünenngelu! Wüne nentufinge ti fütra trolüf mamüll kisu tami nge mew, feymew wüla feypiafimi tañi nentuñmayafiel ti itrom pinu ñi nieel tami peñi ñi nge mew. ");
INSERT INTO arnNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ngelay ta kümeke anümka wülkelu wesake fün, ka ngelay wesake anümka wülkelu ta kümeke fün. ");
INSERT INTO arnNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kake kiñeke anümka kimngekey kisu ñi fün mew. Wayngechi anümka wülkelay ta fün igo, ka sarsa wülkelay fün ofad. ");
INSERT INTO arnNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Fey ka femngechi ti lif piwke che re küme dungu femkey, küme dungu am mülelu kisu ñi piwke mew, welu ti wesa piwke che femkey re wesake dungu, wesake dungu am mülelu kisu ñi piwke mew. Tañi fentren dungu ñi nieel piwke mew, dungukey ta che. ");
INSERT INTO arnNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Chumngelu anta feypimuken ta eymün: ‘Ñidol, Ñidol’, welu femkelaymün iñche tañi ayüelchi dungu? ");
INSERT INTO arnNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Fey tüfa nütrameluwayiñ iney mew tañi inayentulen kiñe che feyentulu iñche mew, tañi allkütuñmaetew ka femkelu iñche ñi ayüelchi dungu: ");
INSERT INTO arnNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Feytachi wentru reke feley, fey dewmayalu ñi ruka, wüne rüngay wente chapu kura, feymew anümi ñi ruka. Fey mangilu ti lewfü, rume newentu wütrurupay ti ruka mew, fey ti ruka nengümlay rume küme newenkülelu am ti kurantu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tañi allkütuetew, welu femnolu iñche tañi ayüelchi dungu inayentuley tati wentru anümrukalu yafünochi mapu mew ka küme rüngalkülenolu ñi orkon. Fey mangilu ti lewfü, rume newentu wütrurumey ti ruka mew, fey tranarupay ti ruka. Femngechi rume wesa teyfükawi.” ");
INSERT INTO arnNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesus dew dungufilu ti pu che, fey amuy ta Kapernaum. ");
INSERT INTO arnNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mülerkey tüye mew kiñe Roma tuwchi kapitan, fey nierkey kiñe kona, tañi rume piwkeyenieel. Fey tüfachi kona rume kutrankülerkey ka femngechi epe larkey dewma. ");
INSERT INTO arnNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Fey ti kapitan allkülu ñi miyawün ta Jesus, werküfi kiñe mufü putremke judiu tañi llellipulmeaetew fey ñi tremolelpayaetew ñi kona. ");
INSERT INTO arnNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kisu engün puwi Jesus mew, fey rume llellipufi engün feypilen mew: —Tüfachi kapitan kümeafuy tami füreneafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kisu ta küme trokituñmaeiñmew taiñ trokiñche ka kisu müten dewmaleleiñmew taiñ nieelchi sinagoga. ");
INSERT INTO arnNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Feymew Jesus kiñentrür amuy tüfeychi pu che engün, fey fülpulu ti ruka mew, fey ti kapitan werküy ñi pu weni tañi feypiafiel: —Ñidol, küpakilnge. Iñche ta Roma tuwünche. Rume yamnieeyu tami konpuael iñche ñi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Feymew tatey iñche ta kisu amulan rume tami yemeafiel. Re werküdungunge müten tañi tremoltuael ñi kona. ");
INSERT INTO arnNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iñche kafey nien tañi werkükeetew tati longkolelu iñche mew ka femngechi iñche nien tañi pu soltaw ñi werkükeel. Femngechi ta werküfiyüm kiñeke tüfa engün ñi amuael, amukey. Ka femngechi werküfiyüm kangelu ñi küpayael, fey küpakey. Ka werküfiyüm ñi kona ñi femael chem küdaw rume, fey femkey. ");
INSERT INTO arnNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Feymew Jesus rume afmatulewey allkülu tüfachi dungu, fey leliwülfi ti pu che ñi inanieetew ka feypifi: —Rüf dungu feypiwayiñ, ngelay kiñe israelche rume fente feyentulelu tüfachi wentru reke. ");
INSERT INTO arnNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Feymew ti pu werken, wiñotulu engün ta ruka mew, peputufingün ti kona ñi dew tremolkületun. ");
INSERT INTO arnNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Fey dew rupalu tüfachi dungu, Jesus amuy kiñe waria mew Nain pingelu. Kompañuwkülen amuy ñi pu disipulu engün ka rume fentren che. ");
INSERT INTO arnNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Fey petu fülpulu ti waria mew, pefi ñi yeniengen ta kiñe la ñi rüngalmengeael. Feyti la kiñen püñeñ ürke ñi ñuke mew ka lanturkey ti domo. Kompañnieeyew rume fentren che mülelu ti waria mew. ");
INSERT INTO arnNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Fey Ñidol, pefilu ti domo, kutranpiwkeyefi ka feypifi: —Ngümakilnge. ");
INSERT INTO arnNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Feymew müten fülkonpuy, ka nüfi ñi kuwü mew ti llangi ñi yeniengemum ti alwe. Fey ti pu che ñi yenieetew, witrakünuwi engün. Fey Jesus feypifi ti la: —Weche, eymi ta feypipeeyu: ¡Witrapüratunge! ");
INSERT INTO arnNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Feymew ti la anüpüray ka eluwi ñi dunguael, fey Jesus elutufi ñi püñeñ ti domo. ");
INSERT INTO arnNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Fey pengelu ñi femün, kom ti pu che llükay, fey eluwi engün ñi püramyeafiel ta Ngünechen feypilen mew: —Kiñe fütra pelon wentru ta pewfaluwi iñchiñ mew. Ngünechen tukulpay tañi kelluafiel ñi trokiñche. ");
INSERT INTO arnNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Fey Judea trokiñ mapu mew ka wall püle kimngey ta Jesus ñi femün tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan kimürkey kom tüfachi dungu, kisu ñi pu disipulu am kimelürkeetew. Fey mütrümfi epu ñi disipulu, ");
INSERT INTO arnNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","fey werküfi ñi amuael engu ta Jesus mew tañi ramtumeafiel: “¿Rüf mew eymi am tati Cristo küpayalu pinieel kam üngümaiñ ta kangelu?” ");
INSERT INTO arnNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Fey Juan tañi epu werken fülkonpuy engu Jesus mew, fey feypipufingu: —Juan ti Fawtisachefe ta werküeyumew tami ramtuwafiel ta ‘¿eymi pemay tati küpayalu kam üngümaiñ ta kangelu?’ ");
INSERT INTO arnNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Feychi lelen mew müten, Jesus tremolyefi rume fentren che kutranküleyelu ka kutrankawkülelu ti pu weküfü mew ka eluyetufi ñi pelotuael rume fentren trawma. ");
INSERT INTO arnNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Feymew Jesus feypifi ta Juan ñi epu disipulu: —Amutumu ka feypiputuafimu ta Juan tamu peel ka tamu allküel. Nütramelputuafimu tati pu trawma ñi pelotun, ka ti pu küntro ñi trekatun, tati pu che nielu lepra kutran ñi tremotun, ti pu pilungelu ñi allküyetun, feyti pu la ñi wiñomongetun, ka ti pu pofre ñi wewpilelngen ti montuluwün dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Fey sakinngeay tati welulkawnolu ñi maneluwael iñche mew! ―pi. ");
INSERT INTO arnNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Fey dew amutulu Juan ñi epu werken, Jesus eluwi ñi dunguafiel ti pu che ñi chumngechi chengen ta Juan, feypilen mew: “¿Chem anta tripaymün tamün pemeael ti uwe lelfün mew? ¿Angken kachu mefürkamekeetew ta kürüf? ");
INSERT INTO arnNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Chem am pemeymün? ¿Kiñe wentru llümllüm kümeke takuwün tukunielu? Eymün kimnieymün tüfeychi re llümllüm kümeke tukuluwkülekelu ka re kawiñ mew mülekelu, tüfachi pu che ta longko ülmen ñi ruka mew müten mülekey. ");
INSERT INTO arnNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Fey ¿chem ürke amfe tripaymün tamün pemeael? ¿Kiñe pelon wentru? May, feyngey, kiñe pelon wentru, welu doy fütra pepiluwlu ti pelon wentru mew ");
INSERT INTO arnNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan mew ta mupirkey tañi feypilen ta Ngünechen ñi Wirin Chillka: ‘Iñche wüne werküan tañi werken, fey ta famngechi wüne ngülamtuafi tati trokiñche femngechi llowaeymew engün.’ ");
INSERT INTO arnNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iñche ta feypiwayiñ, ngelay iney rume trürniefilu ta Juan, welu tati dew koneltulelu Ngünechen ñi ülmen mülewe mew, doy wünenküley ta Juan mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kom tüfeychi pu che allkütufilu ta Juan, kenü ti pu kofrakelu ta impuestu Romangealu kütu fawtisaeyew ta Juan, ngüneduamlu engün am Juan ñi wewpiken Ngünechen ñi nor dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Welu ti pu farisew ka ti pu kimeltukelu ta Moyse ñi ley dungu, pilay engün ñi fawtisayaetew ta Juan, fey ta famngechi illamtufingün Ngünechen tañi ayüfel ñi füreneaetew ta kisu engün. ");
INSERT INTO arnNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“¿Chem mew chey trürümafuiñ tüfachi pu che fantepu mew müleyelu? ¿Chem mew adentuley engün? ");
INSERT INTO arnNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Inayentuley tati pichikeche mew anükünuwkelu tati pülasa mew ka wirareluwkelu ti traf pichikeche ñi ayekayael engün: ‘Dunguleluwiyiñ ta flawta, welu eymün purulaymün. Ka ülkantuleluwiyiñ ti weñangkünngechi ül, welu eymün ngümalaymün.’ ");
INSERT INTO arnNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Fey küpalu ta Juan ti Fawtisachefe kisu ta pekanka ikelay ka putukelay rume, welu eymün feypikefimün: ‘weküfü ñi ngünenieetew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ka femngechi küpay ti Wentrukünuwpalu, fey ikey ka putukey, welu eymün feypikefimün: ‘ifengey ka putufengey.’ Weniyefi ti wesake dunguyen che ka ti pu kofrakelu impuestu Romangealu. ");
INSERT INTO arnNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Welu Ngünechen ñi fütra kimün kimfalkey kom tañi llowetewchi pu che mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kiñe farisew mangelfi ta Jesus ñi imeael kisu ñi ruka mew, fey Jesus amuy ti farisew ñi ruka mew, fey anüpuy ñi iyael ta mesa mew. ");
INSERT INTO arnNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Fey tiyechi waria mew mülerkey kiñe domo yafkafe mongen nielu. Fey kimlu ñi mülepun ta Jesus ti farisew ñi ruka mew, amuy, fey puwüli kiñe pichi fotilla apolelu perfume mew. ");
INSERT INTO arnNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ngümalen fülpuy Jesus ñi namun, fey eluwi ñi küchuñmayafiel ñi külle mew. Ka pürüm piwümeltufi ñi tünay longko mew. Ka truyuñmafi ñi namun, fey ka tukulelfi perfume ñi namun mew. ");
INSERT INTO arnNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fey ti farisew mangelfilu ta Jesus, pefilu ti domo ñi femün, rakiduami: “Tüfachi wentru feyngefule ñi pelon wentrungen, ngüneduamafuy chem domo ñi nüpeetew. Tüfa ta rume wesa mongenngechi domo.” ");
INSERT INTO arnNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Feymew Jesus feypifi ta Simon: —Simon, kiñe dungu ayülen tami feypiafiel. Fey llowdungueyew ta Simon: —Feypien müten, kimeltufe. ");
INSERT INTO arnNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Feymew Jesus feypi: —Epu wentru defelerkey pülata kiñe ülmen wentru mew tati arengülümkelu ta pülata. Kiñe defelerkey kechu warangka moneda, fey kangelu kechu mari moneda. ");
INSERT INTO arnNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Fey pepi kullinolu engu am, fey ti arengülümkelu ta pülata mür wiñoduamatufi ti epu defeniekeetew. Fewla feypien: ¿chuchi chey ti epu defelelu doy piwkeyeaeyew? ");
INSERT INTO arnNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Feymew llowdungueyew Simon: —Iñche ta feypin tati doy alün defelefulu. Fey Jesus feypifi ta Simon: —Küme feypimi tati, Simon. ");
INSERT INTO arnNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Feymew Jesus leliwülfi ti domo, fey feypifi ta Simon: —¿Ngüneduamfimi ñi chumün tüfachi domo? Tayi konpapen tami ruka mew, fey elulaen ko tañi küchayael ñi namun, welu feytachi domo küchuñmaenew ñi namun kisu ñi külle mew, fey ka piwümüñmatuenew kisu ñi tünay longko mew. ");
INSERT INTO arnNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Truyulaen rume, welu ti domo konpalu müten tüfa mew, fentekünulay ñi truyuñmaetew ñi namun. ");
INSERT INTO arnNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ilfuyel-laen ta aseyte ñi longko mew, welu kisu tukulelenew perfume ñi namun mew. ");
INSERT INTO arnNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Feymew feypiaeyu kisu tañi fentren yafkan ñi nieel mew wiñoduamaletuy, kisu am rume piwkentukuetew. Welu kiñe che ineyngele rume pichin yafkan mew wiñoduamangetule, rume pichin piwkeyen pengelay. ");
INSERT INTO arnNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Feymew Jesus pürüm feypifi ti domo: —Tami yafkan mew ta dew wiñoduamangetuymi. ");
INSERT INTO arnNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Fey ti kakelu pu mangel mülelu tüye mew, eluwi ñi ramtuwael engün: “¿Iney anta tüfa, yafkan mew kütu wiñoduamachetuy?” ");
INSERT INTO arnNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Welu Jesus leliwülniefi ti domo, fey feypifi: —Tami mupiltun mew montuluwimi. Küme duamkechi amuñmutunge. ");
INSERT INTO arnNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Fey dew rupalu tüfachi dungu, Jesus ruparkey rume fentren waria püle ka lof mapu püle, wewpiyeniey ka kimeltuniey Ngünechen ñi longko ülmenngen. Tati mari epu apostol kompañkiyawüleyew. ");
INSERT INTO arnNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ka femngechi kompañkiyawüleyew kiñeke domo kisu tañi wemünentulfiel ti pu weküfü ka tañi tremoltuel wesake kutran mew. Fey kisu engün mew miyawürkey tati Maria Magdalena pingechi domo, tati wemünentulel regle weküfü. ");
INSERT INTO arnNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana kafey, Chusa tañi kure, Erode tañi longkokünuel kisu ñi nieelchi chemkün mew; ka Susana. Ka rume fentren kakelu pu domo tañi kellukeetew ñi nieelchi chemkün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Rume fentren che tripayey ti waria mew tañi peafiel Jesus, feymew rume fentren che trawüluwi. Fey Jesus nütramelfi tüfachi adkünu dungu: ");
INSERT INTO arnNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kiñe nganketrankelu tripay ñi nganael. Fey nganlu, kiñeke fün pachügnagi ti rüpü mew, fey pünokangey ka ti pu üñüm kom üpitueyew. ");
INSERT INTO arnNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kakelu fün pachügnagi ti kurantu mew. Fey noyüy ti fün, welu ti kurantu mew am ngenolu narfen mapu, feymew angküy. ");
INSERT INTO arnNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Fey kakelu fün pachügnagi pu troltrontu. Fey kiñentrür noyülu, fey ti pu troltro kom takunagümeyew. ");
INSERT INTO arnNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Welu ka femngechi kiñeke fün pachügnagi rume küme mapu mew, fey tremi, ka wüli rume küme kosecha. Kiñe fün mew tripay pataka fün.” Fey tüfa ñi feypin ta Jesus, ka amul feypi newentu dungun mew: “¡Tüfeychi allkülu, rakiduampe tañi chem pin ta iñche!” ");
INSERT INTO arnNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Fey ti pu disipulu ramtufingün ta Jesus ñi chem pifel tüfeychi adkünu dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Feymew llowdungueyew ta Jesus: “Eymün elueymünmew ta Ngünechen tamün kimafiel tati kimelngekenofelchi dungu kisu tañi longko ülmenngen, welu ta kakelu pu che müley ñi kimeltuafiel adkünu dungu mew. ‘Fey femngechi tunte lelinieafuy rume, pelayay engün. Ka tunte allküayngün rume tüfachi kimeltun, welu longkontukulayay engün.’ ");
INSERT INTO arnNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Fey tüfa tatey ñi kimeltunieel tati adkünu dungu. Feytichi fün adentuley Ngünechen ñi werküelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Fey ti rüpü mew pachügnagchi fün adentuley ti pu che allkütukelu ti werken dungu. Fey küpakey ta weküfü müntuñmayaetew ti dungu ñi piwke mew, femngechi ñi feyentunoael ka ñi montunoael engün. ");
INSERT INTO arnNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Fey ti kurantu mew pachügnaglu adentuley tati pu che allkütufilu ti werken dungu ka llowkefilu rume ayüwün mew. Fey nienolu engün am mupiltun, pichiñma müten feyentukey engün, welu mülechi kutrankawün mew, elkünutukefi engün ñi mupiltulen. ");
INSERT INTO arnNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Fey ti troltrongechi mapu adentuley tüfeychi pu che tati allkütulu ti dungu, welu ñochika amulekey ñi takuetew tati mülechi itrofill küdaw, kam ñi rikungeael fentren chemkün mew, kam ti kawiñ dungu. Fey tüfa ta femkelay chem küme dungu rume. ");
INSERT INTO arnNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Welu ti fün pachügnaglu ti küme mapu mew, adentuley tati ayükelu ñi küme llowafiel ñi piwke mew ti werken dungu ka ñi müngeltuafiel ka kom yafüluwün mew ñi amuleael. Fey ta wülkey kümeke kosecha.” ");
INSERT INTO arnNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesus ka femngechi kimeltuy tüfachi adkünu dungu: “Iney no rume üyümkelay kiñe pelontuwe, fey dew üykülelu ñi takukünuafiel, ka elkünuafiel miñche kawitu, welu may adkiñ mew elkünungekey, femngechi ñi pelontuleael tati ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ka femngechi llemay ngelay ta chem ellkan chemkün rume tañi pengenoael. Ka ngelay chem ellkan dungu rume tañi kimngenoael ka ñi wepümngenoael. ");
INSERT INTO arnNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Femngechi llemay küme allkütumün, tati küdawyelu ñi allküelchi dungu, fey ta doy elungeay kimün. Welu tati duamkünunofilu tati dungu, fey tañi nieel kütu ta müntuñmangeay.” ");
INSERT INTO arnNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus ñi ñuke ka ñi pu peñi puwi engün chew ñi mülemum ta kisu, welu pepi fülkonpulay engün kisu mew, mülelu am rume fentren che. ");
INSERT INTO arnNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Fey kiñe mülelu ti pu che mew feypifi ta Jesus: —Tami ñuke ka tami pu peñi mülepay ta wekuntu. Kisu engün ayüley tami peaetew. ");
INSERT INTO arnNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesus llowdunguy: —Tati allkütukelu Ngünechen ñi werken dungu ka küdawyefilu, fey ta iñche ñi ñuke ka ñi pu peñi. ");
INSERT INTO arnNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kiñe antü, Jesus konpuy kiñe farku mew ñi pu disipulu engün, feymew feypifi ñi pu disipulu: —Amuiñ nome lafken. Fey amuy engün. ");
INSERT INTO arnNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Fey petu nolu ti pichi lafken mew, Jesus umawtuy. Feymew triparumey kiñe fütra kürüf ti pichi lafken mew, fey ti farku mew rume trilkafkonmekey ti ko. Rume konürkey ko ti farku mew, fey femngechi rume kuñiwünngerkey ñi llañkonael. ");
INSERT INTO arnNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Feymew amuy engün ñi trepelafiel ta Jesus, ka feypifingün: —¡Kimeltufe! ¡Kimeltufe! ¡Petu llañkoniyiñ! Feymew Jesus witrapüray, fey werküdungufi ti kürüf ka ti fütrake rew lafken, feymew kom tüngnagtuy ka küme ñüküfkülewetuy. ");
INSERT INTO arnNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Feymew feypifi ñi pu disipulu: —¿Chumtuy am tamün maneluwün? Welu kisu engün llükalewey ka afmatulewey, fey welukonke ramtuwi engün: “¿Iney am tüfa? Werküdungufi ti kürüf ka ti rew lafken, fey müngeltueyew.” ");
INSERT INTO arnNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Fey ngellu puwi engün ti Gadara pingechi mapu mew, fey tüfa müley Galilea trokiñ mapu ñi üngkünome. ");
INSERT INTO arnNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Fey mülepulu engün ti mapu mew, tripapay ti waria mew kiñe wentru konweküfülelu, fey fülkontupaeyew. Rume fentren tripantu dewma ñi tukuwekenofel takuwün ka mülekelafuy rume ta ruka mew. Feytichi eltun püle miyawkerkefuy. ");
INSERT INTO arnNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Fey pefilu ta Jesus, lukunagi ti wentru ñi inafül mew, fey wirarkülen feypifi ta Jesus: —¡Fülpakilnge ta iñche mew, Jesus fütra pepiluwün niechi Ngünechen ñi Fotüm! ¡Iñche llellipuaeyu tami kutrankanoafiel! ");
INSERT INTO arnNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tüfa femngechi feypi, Jesus am werküfilu ti pu weküfü ñi tripatuael ti wentru mew. Ti weküfü müchayke ngünekakerkefi tati wentru, fey ti pu che trariñmakerkefeyew ñi kuwü ka ñi namun kadena mew tañi pepi ngüneafetew, welu kisu katrükerkefuy. Fey ti weküfü lefmawelkefui ti wentru ti uwe lelfün mapu püle. ");
INSERT INTO arnNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Feymew ramtueyew ta Jesus: —¿Iney pingeymi am? Kisu llowdungufi ta Jesus: —Iñche ta Lekion pingen. Fey tüfa feypi rume fentren weküfü am konturkeetew tati wentru. ");
INSERT INTO arnNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Fey ti pu weküfü llellipufi engün ta Jesus ñi werkünoaetew tati fütra konchi lolo mew chew ta Ngünechen kutrankakefi tati pu weküfü. ");
INSERT INTO arnNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Fey mülerkey rume fentren sañwe ütamekelu ti wingkul püle, fey ti pu weküfü llellipuy ñi konael ti pu sañwe mew. Feymew Jesus elueyew ñi konpuael. ");
INSERT INTO arnNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Fey ti pu weküfü tripatuy ti wentru mew, fey konpuyngün ti pu sañwe mew, fey tüfa engün lefnagi ti külleg püle ka ütrüftukuwpuyngün ti pichi lafken mew, fey tüye mew kom ürfipuy engün. ");
INSERT INTO arnNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Fey tati pu kuydakefilu tati pu sañwe, pefilu ñi femün tüfa engün, lefkülen tripay engün, fey kimelyefi ñi rupan tüfachi dungu kom ti pu che mülelu ti waria mew ka mülelu lelfün püle. ");
INSERT INTO arnNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Feymew ti pu che tripapay tañi pepayael ti rupaelchi dungu. Fey puwlu engün chew ñi mülemum ta Jesus, pepufi engün ti wentru konweküfülekefulu ñi anülen Jesus ñi inafül püle. Fey ti wentru tukutuwkületuy ka küme tüngduamkületuy, fey rume llükay engün. ");
INSERT INTO arnNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Feymew ti pu che, pefilu ñi rupan tüfachi dungu, nütramelngey engün chumngechi tañi tremolngetun tüfeychi wentru konweküfülekefulu. ");
INSERT INTO arnNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Fey kom ti pu che mülelu ta Gerasa trokiñ mapu mew, llellipufi engün ta Jesus tañi tripatuael tüye mew, rume llükalu engün am. Feymew Jesus konputuy ti farku mew fey ñi nopatuael. ");
INSERT INTO arnNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Fey ti wentru, tati elkünutuetew ti pu weküfü, llellipufi ta Jesus ñi miyawael ta kisu engün mew. Welu Jesus werküeyew ñi müleweael kisu ñi mapu mew ka feypieyew: ");
INSERT INTO arnNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Wiñotunge tami pu che mew, fey nütramelputuafimi engün kom ñi chumün ta Ngünechen eymi mew. Feymew ti wentru amutuy, fey nütramelputufi kom ti pu che mülelu ti waria mew ti afmafal dungu ñi femün ta Jesus kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Fey Jesus nopatulu ti pichi lafken mew, ti pu che llowtueyew rume ayüwün mew, kisu engün am kom üngümkülerkelu. ");
INSERT INTO arnNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Feymew akuy kiñe wentru Jayro pingelu, longkolerkey ta sinagoga mew. Tüfachi wentru lukutupay Jesus ñi inafül mew, fey llellipufi ñi amuael kisu ñi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kiñe ñawe müten nierkey, mari epu tripantu puwülnielu, fey tüfa epe lalerkey. Fey petu amulelu Jesus, kiñe trokiñ che inanierkeeyew, fey rume trawültukumekewi engün kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Fey rangi pu che amulerkey kiñe domo, mari epu tripantu dewma ñi kutrankülen. Kachükerkelay ñi mollfüñ, femngechi gastarkey kom ñi niekefelchi chemkün tañi kulliafiel ti pu lawentuchekelu, welu tüfey engün kiñe no rume tremolürkelaeyew. ");
INSERT INTO arnNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tüfachi domo fülpay Jesus ñi furi püle, fey idakünuñmafi ñi takuwün. Feychi lelen mew müten kachütuy ñi mollfüñ. ");
INSERT INTO arnNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Feymew Jesus ramtuy: —¿Iney anta idañmapeenew ñi takuwün? Fey kom ti pu che am pinolu ñi feypiael tañi idakünufiel engün, fey Pedro feypi: —Kimeltufe, wall püle küpalechi pu che tenfipeeymew engün. ");
INSERT INTO arnNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Welu Jesus amul feypiley: —Kiñe che ta idapeenew. Ngüneduamün ñi tripan pepiluwün iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Fey ti domo, ngüneduamlu ñi pepi llumumanon ñi femelchi dungu, müllmüllkülen amuy ñi lukutuael Jesus ñi inafül püle. Fey küme nentudunguy kom che ñi adkiñ mew chumngelu ñi idakünufiel ka ñi tremoltun femlu müten. ");
INSERT INTO arnNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Fey feypieyew ta Jesus: —Papay, dew mongetuymi feyentulu am eymi iñche mew, fey küme duamkechi amutunge. ");
INSERT INTO arnNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Petu ñi dungumeken ta Jesus, akuy kiñe werken feypiafilu ti longkolelu sinagoga mew: —Tami ñawe ta dew lay. Aporiamekekefilnge tati kimeltufe. ");
INSERT INTO arnNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Welu Jesus allkülu ti werken ñi feypiel, fey feypifi ta Jayro: —Llükakilnge. Feyentunge müten ta iñche mew, fey tami ñawe ta mongetuay. ");
INSERT INTO arnNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Fey puwlu ti ruka mew, elulafi ñi konpuael kom che, welu Pedro, Santiaw ka Juan müten kiñentrür ti ngen ñawe engün ka ti pichidomo ñi ñuke. ");
INSERT INTO arnNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Fey kakelu ti pu che kom mekey ñi ngüman ka amu wirarkümekey tati lachi pichidomo mew, welu Jesus feypifi ti pu che: —Ngümakilmün. Tati pichidomo ta lalay. Umawküley müten tati. ");
INSERT INTO arnNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kom ti pu che ayeñefi engün ta Jesus, kimfilu engün am ñi dew lan ti pichidomo. ");
INSERT INTO arnNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Feymew Jesus nüñmafi ti pichidomo ñi kuwü ka feypifi newentu dungun mew: —¡Pichidomo! ¡Witratunge! ");
INSERT INTO arnNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Feymew ti pichidomo wiñomongetuy. Feychi lelen mew müten witratuy, fey Jesus werküy ñi elungeael ta iyael. ");
INSERT INTO arnNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ti pichidomo ñi chaw ka ñi ñuke rume afmatulewey, welu Jesus feypifi ñi nütramelngenoael iney rume ñi femngechi femel tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus trawülüy ñi mari epu disipulu, fey elufi fentren newen ka pepiluwün tañi wemünentuafiel fill kakerumechi weküfü ka tañi mongelafiel tati kutrankülechi pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Fey werküfi ñi wewpiyeafiel Ngünechen ñi longko ülmenngen ka femngechi tañi mongeltuafiel tati pu kutrankülelu. ");
INSERT INTO arnNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ka feypifi: —Chem rume yelayaymün tamün miyawülael rüpü mew: retrü no rume, folson no rume, ka kofke no rume. ");
INSERT INTO arnNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Fey chem ruka mew rume puwülmün, mülewenagmün tüfey mew, kañpüle wüla amualmün tripatuaymün ti ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Fey ka femngechi kiñeke waria mew llowngenolmün, tripatuaymün tüfey mew fey mütrowafimün ti trufür mülelu tamün okota mew, fey femngechi ngüneduamayngün tamün wesa duamün. ");
INSERT INTO arnNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Feymew tripay ti pu disipulu, fey rumerpuy engün kom pichike trokiñ ruka che mew, wewpiniefingün ti werken montuluwün dungu ka mongelfingün ti pu kutran. ");
INSERT INTO arnNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tati longko ülmen Erode allküy ñi nütramyengen ta Jesus ka kom ñi femelchi dungu. Fey Erode kimlay ñi chem chumael, kiñeke che am feypilu Juan tañi wiñomongetun. ");
INSERT INTO arnNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Fey kakelu feypingün tañi pewfaluwtun tati pelon wentru Elia, welu ka kiñeke feypingün ta kiñekentu ti kuyfi mülekechi pelon wentru ñi wiñomongetun. ");
INSERT INTO arnNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Welu Erode feypi: “Iñche nga werkün ñi katrüñmangeael ñi longko ta Juan. ¿Fey iney anchi tüfa, tañi allküñmakefiel ñi femel rume fentren afmatufal dungu?” Feymew Erode ayülerkefuy ñi kimafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Fey ti pu apostol dew wiñomelu engün, fey nütramelpatufingün ta Jesus kom tañi femelchi dungu. Fey Jesus püntütripay ñi pu disipulu engün ñi amuael Betsayda pingechi waria mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Welu ti pu che kimlu Jesus ñi amun kañpüle, amuy engün chew ñi mülepumum ta Jesus. Feymew Jesus llowfi ti pu che, fey kimeltufi Ngünechen ñi longko ülmenngen ka mongelfi ti pu kutran. ");
INSERT INTO arnNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Fey dew putrafialu, tati pu disipulu fülkonpay Jesus mew, fey feypifi engün: —Chalitufinge ti pu che. Femngechi amutuayngün ñi kansatuael ka ñi kintuñmuael iyael ti pichike trokiñ ruka che mew tati fülküleyechi lelfün püle, fey tüfa mew am ngenolu ta iyael. ");
INSERT INTO arnNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Fey Jesus feypifi ñi pu disipulu: —Eymün elufimün ta iyael. Fey kisu engün llowdungueyew: —Tüfachi kechu kofke ka epu challwa müten nieiñ. ¿Ngillamepeafuiñ may ta iyael kom tüfachi pu chengealu? ");
INSERT INTO arnNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kom tüfa engün mew mülerkey kechu warangka wentru. Welu Jesus feypifi ñi pu disipulu: —Anükünuwpe engün kake wichuke trokiñ mew, fey mülepe kechu mari che kiñeke trokiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Femngechi femürkey engün, fey kom anükünuwi ti pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Feymew Jesus pürüm nüfi ñi kuwü mew ti kechu kofke ka ti epu challwa. Fey pürakintuy wenu mapu ka mañumtufi ta Ngünechen ti kofke mew ka ti challwa mew, fey wükafi ti kofke ka eluyefi ñi pu disipulu ka ñi pu kompañkiyawületew ñi wüdamkalelafiel tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Fey ti pu che iyeyngün ka küme wedayngün, welu ka apolyetuyngün mari epu kanasta ti sofrachi wükanke kofke mew ka challwa. ");
INSERT INTO arnNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kiñe antü Jesus amuy lelfün mew ñi kisutu ngillatumeael, fey ñi pu disipulu mülerkey tüfey mew, feymew Jesus ramtufi ñi pu disipulu: —¿Iney pikeenew anta ti pu che? ");
INSERT INTO arnNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Fey llowdungueyew engün: —Kiñeke che ta Juan ti Fawtisachefe pikeeymew, ka kiñekentu Elia pikeeymew, fey kakelu pu che kay feypikeeymew tami kiñe kuyfi pelon wentrungen, tati wiñomongetulu. ");
INSERT INTO arnNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Eymün kay, ¿iney pimuken anta iñche? ―ramtuy ta kisu. Feymew llowdungueyew Pedro: —Eymi ta Ngünechen ñi Cristo. ");
INSERT INTO arnNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Welu Jesus werküfi ñi pu disipulu tañi feypinoafiel engün iney no rume tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Fey ka feypifi: —Ti Wentrukünuwpalu felerkey tañi rume kutrankawael, ka tañi llownoaetew tati pu judiu ñi awtoridad, tati longkolelu pu saserdote mew ka tati pu kimeltukelu Moyse ñi ley dungu. Fey langümafi engün, welu küla antüalu mew wiñomongetuay. ");
INSERT INTO arnNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Fey wüla ka feypifi kom tati pu che mülelu tüye mew: —Iney rume ayüle iñche ñi disipulungeael, müley ñi elkünuael itrokom ñi ayütunieel, fey eluwkülepe ñi layael kütu iñche mew ka inaechimew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tati ayülu ñi montulael ñi mongen, fey ta montul-layay, welu tati ütrüflu ñi mongen ta iñche ñi duam, fey ta montulay ñi mongen. ");
INSERT INTO arnNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Chem am nentuay ta che ngenngele kom chemkün mew mülelu tüfachi mapu mew, welu montunole, fey kisutu wesalkaway? ");
INSERT INTO arnNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Fey iney rume yewentukuelimew ka yewentukuñmaelimew iñche ñi dungu, ka femngechi llemay ti Wentrukünuwpalu yewentukuaeyew feychi küpatule kisu ñi fütra pepiluwün mew ka ñi Chaw ñi fütra pepiluwün mew ka ti lif mongen pu werken püllü engün. ");
INSERT INTO arnNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Rüf dungu feypiwayiñ kiñeke eymün mülelu tüfa mew lalayay petu tañi penofiel Ngünechen ñi longko ülmenngen itrokom dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Fey dew rupalu pura antü tüfachi nütramkan, Jesus pürapuy kiñe wingkul mew tañi ngillatumeael. Kompañyeeyew ta Pedro, Santiaw ka Juan. ");
INSERT INTO arnNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Petu ngillatulu kisu, kangerumetuy ñi ad ka ñi takuwün rume lingarüy ka llümllümi. ");
INSERT INTO arnNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Fey epu wentru pewfaluwi ka nütramkamekey Jesus engün. Moyse engu Elia ürke ñi pewfaluwün. ");
INSERT INTO arnNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Alofmanieeyew kiñe fütra pelon, fey nütramkarkeyngün chumngechi ñi kutrankawael ka ñi layael ta Jesus Jerusalen mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Fey Pedro ka ñi epu kompañ rume küpa umawturkefuy engün, welu eluwürkelay ñi umawtuael engün. Feymew perkefi engün ta Jesus tañi fütra pepiluwün ka ti epu wentru engün ñi mülen. ");
INSERT INTO arnNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Fey tüyechi epu wentru petu püntütripatulu Jesus mew, Pedro feypifi ta Jesus: —Kimeltufe, ¡rume kümey taiñ mülepan tüfa mew! Dewmayaiñ küla pichike küni ruka, kiñe eymingealu, kangelu Moysengealu ka Eliangealu. Welu Pedro kimlay ñi chem pimeken. ");
INSERT INTO arnNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Fey petu dungumekelu, nagpay kiñe tromü, fey munulpaeyew kiñe llawfeñ reke. Fey mülelu engün am ti tromü ñi llawfeñ mew, rume llükay engün. ");
INSERT INTO arnNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Fey ti pu tromü mew tripay kiñe dungun, fey feypi: “Tüfa ta iñche ñi Fotüm, tañi Dullin, fey allkütuafimün.” ");
INSERT INTO arnNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Feychi lelen mew allküngelu ti dungun, Jesus kisulewetuy. Welu ti küla disipulu feypirkelafi iney no rume tüfachi dungu tañi peel engün. ");
INSERT INTO arnNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Fey kangelu antü mew, nagpatulu engün ti wingkul mew, kiñe fütra trokiñche tripay ñi trafyemetuafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Fey kiñe wentru tati pu trokiñche mew feypieyew fütra newentu dungun mew: —Kimeltufe, füreneen. Leliwülmaen ñi kiñen fotüm. ");
INSERT INTO arnNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kiñe weküfü kontukeeyew, fey wirarelkakeeyew ka lalatulkeeyew ka trorfan entukey kowün ñi wün mew. Rume wesa tülaykalkeeyew ka neykümkelaeyew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Llellipufuiñ tami pu disipulu ñi wemünentuafiel ti weküfü, welu pepi wemünentulafi engün. ");
INSERT INTO arnNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Feymew Jesus llowdunguy: —¡Wesake tuwünche, ka nienolu mupiltun! ¿Tunteñma anta mülerkealu ta iñche eymün mew ka tamün ngenoafelniewafiel? Küpalnge faw püle tami fotüm. ");
INSERT INTO arnNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Fey petu fülpalu ti weche wentru, tati weküfü ütrüfpuwüleyew ka kiñe nag lalatuleyew, welu Jesus wemünentufi ti weküfü, fey tremoltufi ti weche wentru, fey ka wiñoleltufi ti ngen fotüm. ");
INSERT INTO arnNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Feymew kom afmatulewey engün Ngünechen ñi fütra pepiluwünngen. Fey kom petu afmatulewelu engün Jesus tañi femün mew, kisu feypifi ñi pu disipulu: ");
INSERT INTO arnNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Küme allkütumün tüfa ka ngüyükilmün. Ti Wentrukünuwpalu ta chalintukungeay tati pu yafkafe che mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Welu kisu engün longkontukulay tañi feypietew, Ngünechen am elunoetew ñi kimafiel ti dungu. Welu ka femngechi llükay engün tañi “kimelmuiñ” ñi piafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Feymew ti pu disipulu eluwi ñi notukamekewael iney ñi longkoletuael kisu engün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus, ngüneduamlu ñi femngechi rakiduamkülen engün, fülümtukupafi kiñe pichiwentru kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ka feypifi ñi pu disipulu: —Iney rume llowfilu tüfachi pichiwentru, iñche ta llowaenew. Fey tati llowetew ta iñche, ka femngechi llowkefi tañi werküetew. Feymew tati doy illamfalkülelu kom eymün mew, fey may ta longkoleay itrokom mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Feymew feypieyew ta Juan: —Kimeltufe, pefiyiñ ta kiñe che ñi wemünentumekefiel ti weküfü eymi tami üy mew, welu iñchiñ katrütufiyiñ kisu am miyawkenolu iñchiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Fey Jesus llowdunguy: —Katrütukelayafimün. Tüfey engün taiñ kayñetukenoetew, fey iñchiñ mew kelluley tati. ");
INSERT INTO arnNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Petu fülpalu dewma tati antü Jesus tañi amutuael ta wenu mapu, yafüluwi ñi amuael ta Jerusalen. ");
INSERT INTO arnNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Werküy kiñe werken tañi wüne amuael Samaria tañi pichike trokiñ ruka che mew tañi kintulelngeael chew ñi umañtuael. ");
INSERT INTO arnNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Welu ti pu samariache pilay engün tañi llowaetew, kisu engün am kimnielu ñi amuael ta Jerusalen. ");
INSERT INTO arnNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Feymew ñi epu disipulu Santiaw ka Juan, kimlu ñi femngechi femün ti pu che Samaria mapu mew, feypieyew: —Ñidol, ¿eymi pifulmi kay, werküafuymi ñi nagpayael kütral wenu mapu, chumngechi ñi femel ta Elia tañi apümngeael ta tüfachi pu che? ");
INSERT INTO arnNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Welu Jesus wiñokintufi ñi epu disipulu, fey katrütudungufi: —Eymu kimlaymu chem tamu pimeken. ");
INSERT INTO arnNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tati Wentrukünuwpalu küpalay tati pu che ñi apümafiel, welu may ñi montulafiel. Feymew amuy engün kangelu pichi trokiñ ruka che mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Petu amulelu engün ti rüpü mew, kiñe wentru feypifi ta Jesus: —Ñidol, iñche ayülen tami inayafiel, chew püle rume amulmi. ");
INSERT INTO arnNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Fey llowdungueyew Jesus: —Ti pu ngürü niey tañi lolo ka ti pu üñüm niey tañi dañe, welu tati Wentrukünuwpalu nielay chew tañi küme kansatuam. ");
INSERT INTO arnNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Fey Jesus feypifi ta kangelu wentru: —Inaen. Welu kisu llowdungueyew: —Ñidol, wüne üngüman ñi layael ñi fütakeche, fey wüla inayaeyu. ");
INSERT INTO arnNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Fey Jesus llowdungufi ti wentru: —Elkünufinge tati pu che la reke felelu ñi rüngalafiel tati pu la, welu eymi amuaymi tami kimelael ta Ngünechen ñi longko ülmenngen. ");
INSERT INTO arnNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Fey kangelu feypi: —Ñidol, iñche ayülen tami inayafiel, welu wüne chalikünumetuafiñ tañi pu reñma mülelu ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Feymew Jesus llowdungufi ti wentru: —Tati nüfilu ti araw ñi kuwü mew, welu furi wiñokintulele, fey ta falilay tañi kellukonael Ngünechen ñi dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Fey dew rupalu tüfachi dungu, Ñidol ta dullirkey ti kakelu regle mari epu disipulu, fey werküfi re epuke wünelealu ta kisu mew, kom waria püle ka ti lelfün püle chew ñi rumerpuael ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Feymew feypifi kom ti pu disipulu: “Rüf feyngey tañi rume fentrelen ta che ñi kimeltungeael ti werken dungu, welu ti küdawkelu rume pichiley. Feymew eymün müley tamün ngillatuafiel tati ngenngelu ti küdaw mew, fey femngechi werküay doy fentren küdawfe tañi kimeltuafiel ti pu che ti werken dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eymün ta amuaymün, welu ngüneduamaymün tüfa. Iñche ta werküwayiñ kiñe pichi ufisa reke rangi ti pu trapial mew. ");
INSERT INTO arnNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yekilmün ta folson, pülata no rume ka epu mudaw okota no rume ka witrakünuwlayaymün ta rüpü mew tamün nütramkayafiel ta iney no rume. ");
INSERT INTO arnNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Fey konpulmün kiñe ruka che mew, wüne chalipuaymün, feypilen mew: ‘Kümelkalen mülepe tüfachi ruka mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Fey tüye mew mülele kiñe che ayükelu ñi müleael küme tüngün, eymün tamün nieelchi küme tüngün llowayngün, welu felenole, puwlayay kisu engün mew ti küme tüngün. ");
INSERT INTO arnNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Fey mülewenagaymün feychi ruka mew müten. Iyaymün ka pütokoaymün kisu engün ñi nieel. Fey ti küdawkelu müley ñi elungeael ta kullitun. Welu rupakilmün kom ruka che mew. ");
INSERT INTO arnNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Fey puwülmün kiñe waria mew ka llowngelmün, iyaymün tamün elungeel. ");
INSERT INTO arnNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ka mongelafimün tati pu kutran mülele tüye mew, ka feypiafimün: ‘Ngünechen ñi longko ülmenngen ka ñi küme dungu dew fülpay ta eymün mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Welu puwülmün kiñe waria mew, fey llowngenolmün, tripatuaymün ti kalle mew ka feypiaymün: ");
INSERT INTO arnNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘¡Tati trufür mülelu tüfachi waria mew, fey pünale taiñ namun mew, mütrowafiyiñ taiñ wesa duamün eymün mew! Welu kimaymün ta Ngünechen ñi longko ülmenngen ñi fülkülepan ta eymün mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Welu ka feypiwayiñ ti afaelchi antü mew, tüfachi waria che ta doyelchi kutrankangeay, fey ti pu che mew mülefulu ta Sodoma waria mew. ");
INSERT INTO arnNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Awngeaymün eymün Korasin waria che! ¡Awngeaymün eymün Betsayda waria che! Tüfachi afmatufal dungu pengefule ta Tiro waria ka Sidon waria mew, kuyfitu dewma wiñorakiduamtuafuyngün ta Ngünechen mew. Anükünuwafuy wente trufken ka tukuafuy ti lingoychi wesa takuwün. ");
INSERT INTO arnNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Welu ti afaelchi antü mew eymün ta doy fütra kutrankangeaymün ta Tiro ka Sidon mülechi pu che mew. ");
INSERT INTO arnNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Eymün kay Kapernaum waria che. ¿Eymün anta feyentuleymün tamün puwael ta wenu mapu? ¡Doy fütra ponwitu lolo mew ta ütrüftukungeaymün! ");
INSERT INTO arnNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Tamün allkütuetew ta eymün, allkütukeenew ta iñche. Ka tüfey tamün illamtuetew, iñche ta illamtuenew. Ka tüfey tañi illamtuetew, fey ta illamtukefi tañi werküetew.” ");
INSERT INTO arnNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Fey dew wewpimelu engün, tati regle mari epu disipulu rume ayüwkülen wiñomeyngün. Fey feypipatufi engün ta Jesus: —¡Ñidol, tati weküfü kütu müngeltueiñmew tami pepiluwün mew! ");
INSERT INTO arnNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Feymew feypieyew Jesus: —Feley. Iñche pefiñ ta weküfü ñi ütrüfnagümuwün wenu mew llüfkeñ reke. ");
INSERT INTO arnNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iñche eluwayiñ ta pepiluwün tamün trekayawael wente filu ka ti pu ilolafe mew, ka tamün wewafiel kom kayñe ñi newen, welu allfül-layaeymünmew rume. ");
INSERT INTO arnNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Welu ayüwkilmün tamün müngeltuetew ti pu weküfü, welu may ta ayüwaymün tüfachi dungu mew: ñi dew wirintukulen tamün üy ta wenu mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Feychi lelen mew, Jesus rume ayüwüy ti Lif Küme Püllü mew, feymew feypi: “Iñche ta püramyeeyu, Chaw, Ñidolkülelu ta wenu mapu mew ka nag mapu mew. Eymi ta kimelelfimi tati pu ñom piwkengelu, welu elulafimi ñi kimael tüfachi dungu tati pu fütrake kim wentru. Feyngey tati, Chaw, femngechi am ayülu ta eymi. ");
INSERT INTO arnNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Iñche ñi Chaw ta chalintukulelenew kom dungu. Iney no rume ta kimlay ñi ineyngen ta Fotüm, welu Chaw müten küme kimnieeyew. Ka iney rume kimlay ñi ineyngen ta Chaw, tati Fotüm müten ka ti pu che ta Fotüm ñi küpa kimelelfiel. Feychi pu che kimfi ta Chaw.” ");
INSERT INTO arnNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Fey wiñome leliwülfi ñi pu disipulu, fey wichu feypifi: “Sakinngeymün ta eymün tamün pefiel mew tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iñche ta feypiwayiñ rume fentren pelon wentru ka ti pu longko ülmen ayüfuyngün ñi peafiel tüfachi dungu eymün tamün peel, welu pelafi engün. Ka ayüfuy ñi allkütuafiel tüfachi dungu eymün tamün petu allkütuel, welu allkütulafi engün.” ");
INSERT INTO arnNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kiñe wentru kimeltukelu Moyse ñi ley dungu amuy ñi dungumeafiel ta Jesus, ka tañi kintukaduamafiel, fey ramtufi: —Kimeltufe, ¿chumafun chey tañi nieael ta rumel mongen? ");
INSERT INTO arnNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Fey llowdungueyew ta Jesus: —¿Chem dungu anta wirintukuley ti ley dungu mew? ¿Chem dungu anta chillkatukeymi? ");
INSERT INTO arnNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Fey ti kimeltukelu Moyse ñi ley dungu llowdungufi ta Jesus: —‘Piwkeyenge tami Ñidol Ngünechen kom tami piwke mew, kom tami kuerpu mew, kom tami newen mew, ka kom tami rakiduam mew’, ka ‘piwkeyenge tami chafche chumngechi piwkeyeniewimi ta eymi.’ ");
INSERT INTO arnNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Feymew Jesus feypieyew: —Rume küme llowdunguymi. Fey femngechi femülmi, nieaymi ta rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Welu ti kimeltukelu Moyse ñi ley dungu ayülafuy ñi kimeltulngeael ineyngen ñi chafche, feymew ramtufaluwi, fey feypifi ta Jesus: —¿Iney am tañi chafche? ");
INSERT INTO arnNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Feymew Jesus llowdungueyew: —Kiñe wentru amuley Jerusalen ñi rüpü mew amualu ta Jeriko waria, fey kiñe mufü weñefe saltiaeyew ka müntuñmaeyew ñi takuwün. Wülelkangelu, fey epe langümkünungelu, elkünutueyew engün. ");
INSERT INTO arnNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Fey küparumey kiñe saserdote ti rüpü mew, welu pefilu ti allfükalechi wentru, kiñe püle rupay, fey amuy ñi rüpütulen. ");
INSERT INTO arnNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Feymew ka kiñe Levi ñi tuwünche fülpuy kisu mew, fey pefilu, ka kiñe püle rumey, fey amuy ñi rüpütulen. ");
INSERT INTO arnNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Welu kiñe illamfal wentru Samaria tuwlu ka femngechi amulerkey feytichi rüpü mew. Fey pefilu, rume kutranpiwkeyefi ti allfükalechi wentru, ");
INSERT INTO arnNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","fey fülkonpuy kisu mew. Liftulelfi ñi allfen aseyte mew ka pulku mew, fey trariñmafi kiñe katrün pañu mew. Feymew ka püramfi kisu ñi furiku mew, ka yefi kiñe umañtuwe ruka mew ka dapipufi. ");
INSERT INTO arnNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Fey kangelu antü mew ti samariache nentuy epu moneda, fey elufi ti ngenngelu tati umañtuwe ruka mew ka feypifi: ‘Dapilelaen tüfachi wentru. Fey tami gastaelchi pülata, iñche wiñomeli, kullipatuaeyu.’ ");
INSERT INTO arnNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Fey tüfa mew, ¿chuchi am tüfachi küla wentru chafcheyefi ti allfükalechi wentru tati wülelkael ti pu weñefe mew? ");
INSERT INTO arnNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Feymew ti kimeltukelu Moyse ñi ley dungu llowdunguy: —Tüfeychi kutrantupiwkelu ta kisu mew. Feymew Jesus feypifi ti wentru: —Femngechi tati. Amunge, fey eymi ta ka femngechi femafimi tami chafche. ");
INSERT INTO arnNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus trekalerkey rüpü mew, fey puwi kiñe pichi trokiñ ruka che mew. Feymew kiñe domo Marta pingelu lloweyew kisu ñi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta nierkey kiñe lamngen Maria pingelu, fey kisu anükünuwürkey tañi allkütuael Jesus ñi nütramkamekeelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Welu Marta, kisu müten mekelu ñi duamngemeken fentren küdaw mew, fülkonpay Jesus mew ka feypifi: —Ñidol, ¿eymi pichi no rume ngüneduamlafimi iñche ñi lamngen? Kisukünuenew kom ñi küdaw mew. Werküfinge tañi kelluaetew. ");
INSERT INTO arnNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Welu Jesus llowdungueyew: —Marta, Marta, rume küdaweluwküleymi ka weñangküluwküleymi tami dewmayael rume fentren iyael. ");
INSERT INTO arnNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Welu kiñe pichin dungu müten duamtufali ta tüfey. Maria dullifi tati doy küme dungu, fey iney rume ta müntuñmalayaeyew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kiñe rupa Jesus mekerkey ñi ngillatun kiñe lelfün mew. Fey dew ngillatulu, kiñe ñi pu disipulu feypieyew: —Ñidol, kimeltumuaiñ kay taiñ ngillatuael, chumngechi ta Juan kimeltuy ñi pu disipulu. ");
INSERT INTO arnNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Feymew Jesus feypifi ñi pu disipulu: —Ngillatulmün, fey ta famngechi feypikeaymün: ‘Chaw Ngünechen wenu mapu mülelu, yamniengepe tami küme üy. Felepe may tami longko ülmenngen tüfachi mapu mew. Chumngechi müngeltuniengeymi wenu mapu ka femngechi müngeltun mülepe tüfachi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Eluniemuaiñ taiñ duamtuelchi kofke kake antüngealu. ");
INSERT INTO arnNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Wiñoduamamuiñ taiñ yafkan mew chumngechi iñchiñ wiñoduamakefiyiñ kom tüfey engün taiñ wesa femkeetew. Kintukaduamngeliyiñ, eluwmukeliyiñ taiñ femael wesake dungu ka montulniemuiñ kom wesake dungu mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ka femngechi feypi ta Jesus: —Fey kiñe wentru rangi pun amuy kangelu weni ñi ruka mew, feymew feypipufi ñi weni: ‘Weni, arelen küla kofke. ");
INSERT INTO arnNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kiñe weni akuy ñi witrankontuaetew iñche ñi ruka mew, fey nielan chem iyael rume ñi eluafiel.’ ");
INSERT INTO arnNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Fey tati mülelu ta pu ruka llowdunguy: ‘¡Feypimekepakeeli! Tati wülngiñ ruka küme rakümniefiñ. Tañi pu che iñchiñ dew kuduleiñ, feymew witralayan tami eluafiel chem no rume.’ ");
INSERT INTO arnNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Feymew feypiwayiñ tüfachi dungu: kisu tañi weningen mew witrallenoafule rume tañi eluafiel ñi duamtuel, welu may füreneafi, fey eluafi kom tañi duamtuel fente tañi wirarkümekeken mew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Feymew iñche ta feypiwayiñ: Ngillatulemün, fey ta Ngünechen eluaeymünmew tamün ngillatuel. Kintuaymün, fey ta peaymün. Mütrümkülemün wülngiñ mew, fey nülalngeaymün. ");
INSERT INTO arnNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Fey tüfa famngechi: tati ngillatulelu, elungekey. Fey ti kintulu, pekey. Ka ti mütrümlu wülngiñ mew, fey nülalngekey. ");
INSERT INTO arnNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Fey kiñe chaw elupeafuy may ñi fotüm kiñe kura, ‘eluen kofke’ pieliyew? ¿Ka elupeafuy may kiñe filu kisu ñi fotüm, ‘eluen kiñe challwa’ pieliyew? ");
INSERT INTO arnNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Kam elupeafuy may kiñe ilolafe, ‘eluen kiñe kuram’ pieliyew? ");
INSERT INTO arnNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Chumngechi wesa piwkengeafuymün rume ta eymün, kimimün tamün eluafiel kümeke chemkün tamün pu yall. ¡Fey ta wenu mapu Chaw doyelchi eluafi tati Lif Küme Püllü tüfey engün tañi ngillatuetew!” ");
INSERT INTO arnNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus wemünentufi tati weküfü ketrolniefilu kiñe wentru, fey tripatulu tati weküfü, ti wentru pepi dunguturkey. Fey ti pu che rume afmatulewey engün. ");
INSERT INTO arnNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Welu kiñekentu feypi engün: “Belsebu, tati longkolelu pu weküfü mew, fey ta elueyew ngüneluwün tüfachi wentru ñi wemünentuafiel ti pu weküfü ti wentru mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Welu tati kakelu pu che, re ngünen mew, feypieyew engün ñi pengelael kiñe afmatufal dungu ta kallfü wenu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Welu Jesus am kimlu ñi femngechi rakiduamkülen engün, fey feypifi ti pu che: “Kom trokiñ mapu püntükawkülele kayñetuwün mew, kom kisutu apümkawafuy engün. Ka kom pu reñmawen püntükawkülele, apümkawafuy engün. ");
INSERT INTO arnNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ka femngechi ta weküfü kisutu püntükawkülele ñi pu werken püllü engün, ¿fey chumngechi am ngünenieay kom ñi ngüneluwün? Tüfa ta feypipen eymün tamün feypimupefiel mew iñche tañi wemünentukefiel tati weküfü Belsebu ñi ngüneluwün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Welu tüfa feyngele, ¿iney am elukeeyew pepiluwün tati pu che tamün inakeetew femngechi tañi wemünentuafiel tati pu weküfü? Feymew, kisu engün llemay pengelniey tamün welulkawkülen eymün tamün feypimukefiel mew ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Fey iñche wemünentufili ti weküfü Ngünechen ñi pepiluwün mew, fey tüfa ta famngechi kimfalküley Ngünechen ñi longko ülmenngen ñi dew mülepan eymün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Fey kiñe wentru rume newenngelu küme pepikawkülele ka küme llüwatule ñi ruka mew, iney no rume müntuñmalayaeyew ñi nieelchi chemkün. ");
INSERT INTO arnNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Welu kangelu doy newenngelu, kisu mew akule ka wewpaeliyew, müntuñmangeay ñi weychawe tañi maneluwkülemum, ka müntuñmangeay kom tañi nieelchi chemkün. ");
INSERT INTO arnNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Fey tañi kellunienoetew, fey ta kayñe reke nieenew. Ka iñche engün küdawnolu ñi küpalafiel ti pu che, fey engün püntünentukefi ti pu che iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Fey kiñe weküfü tripatuyüm kiñe che mew, miyawkey chew ñi ngenomum chem rume. Kintuyawülkey chew ñi kansatuam, welu penoyüm ñi kintupeel, rakiduamkey: ‘Wiñotuan tati che mew chew tañi tripapatumum.’ ");
INSERT INTO arnNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Fey dew akutulu, pepatufi ti che kiñe küme adkülechi ruka reke, ka küme lepütulelu. ");
INSERT INTO arnNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Feymew amuay ñi yemeael ka regle weküfü doy wesañmangelu kisu mew, feymew kom konay engün ñi müleael ti che mew. Feymew tati che doy wesa piwkengetukey.” ");
INSERT INTO arnNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Fey petu feypilu Jesus tüfachi dungu, kiñe domo wirarüy rangi ti pu che: —¡Rume sakinngey ti domo tami choyüetew ka tami tremümetew! ");
INSERT INTO arnNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kisu llowdunguy: —Doy küme sakinngeay tüfeychi pu che engün tati allkütukelu Ngünechen ñi dungu, ka tati müngeltukelu. ");
INSERT INTO arnNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kiñe trokiñche petu trawüluwlu, fey walloñmafi engün ta Jesus, fey kisu eluwi ñi feypiafiel: “Tati pu che fantepu mew mülelu, rume wesañmangey. Ayüley ñi pengelelngeael kiñe afmatufal dungu, welu Jona ñi rupaelchi dungu müten pengelelngeay. ");
INSERT INTO arnNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Chumngechi ta Jona adkünuelchi dungu reke femkünungey tati Ninife pu che mew ka femngechi tati Wentrukünuwpalu kiñe adkünuelchi dungu reke feleay tati fantepu mülechi pu che mew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Feychi afaelchi antü mew wüldunguale ñi yafkan mew fantepu mülechi pu che, tati waywen püle küpachi longko ülmen domo fey tüfa wiñomongetule ka witrapürale fey kondenayafi tüfachi pu che, fey ti domo am küpalu rume alü kamapu ñi allkütuafiel ta Salomon ñi fütra kimün, welu iñche tüfa mew mülepan, doy fütra kimün nien ta Salomon mew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ka femngechi ta Ninife pu che puwle tañi wüldungael engün tati afaelchi antü mew, kondenayafi fantepu mülechi pu che, fey Ninife pu che am wiñoduamtulu engün ta Ngünechen mew feychi allkülu engün Jona ñi wewpielchi dungu. Fey tüfa mew mülepan ta iñche, fey doy wünenkülen ta Jona mew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Feyentumün tamün feypiwfielchi dungu: iney rume üyümkelay kiñe pelontuwe tañi kiñe püle ellkakünuafiel, ka miñche kakon mew rume tañi elafiel, welu may tañi adkiñ mew elkünuafiel, feymew tati konpulu ñi pelotupuael. ");
INSERT INTO arnNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tami nge kiñe pelontuwe reke feley tami kuerpu mew. Fey tami nge küme pelole, kom tami kuerpu nieay pelon, welu tami nge pelonole, tami kuerpu dumiñ mew reke müleay. ");
INSERT INTO arnNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kuñiwtukuwmün tati pelon tamün kimeltuwfiel ta eymün tañi dumiñngetunoael. ");
INSERT INTO arnNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Fey kom eymün nielmün iñche ñi kimeltun kiñe pelon reke, nielayay chem dumiñ no rume, fey chem dungu rume kom küme lif piwke mew penieafimün, chumngechi kiñe üykülechi pelontuwe kom küme pelontuniekey.” ");
INSERT INTO arnNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus dew fentekünulu ñi dungun, kiñe farisew mangeleyew ñi imeael kisu ñi ruka mew, feymew Jesus konpuy ka anüpuy mesa mew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Welu ti farisew rume kangeweduami peetew tañi müngeltunofiel ti wimtun dungu ñi wüne küchakuwünon mew petu ñi inon. ");
INSERT INTO arnNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Welu Ñidol feypifi ti farisew: —Eymün tamün pu farisewngen wente mew müten liftukefimün tati fasu ka rali, welu tamün piwke apoley ta wesake dungu mew, fey ponwitu trapümniey re weñen dungu ka ti wesake femün kütu. ");
INSERT INTO arnNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ngenokimün che! Tati küchafilu ti rali kom küme küchakefi ponwitu ka wekuntu. ");
INSERT INTO arnNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wülmün tamün nieelchi chemkün nor piwke mew, fey femngechi ta lifngetuay tamün mongen. ");
INSERT INTO arnNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Awngeymün tamün pu farisewngen! Wichulkefimün tamün eluafiel ta Ngünechen ta kiñe trokiñ mari puwlu mew feytichi menta kachu ka tati ruda ka fill tukukan, welu müngeltukelaymün tamün femael nor küme dungu ka tamün piwkeyeael tamün chafche. Fey tüfa llemay müley tamün femael, welu tamün femael kafey ti kakelu kümeke dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Awngeymün tamün pu farisewngen! Tati sinagoga mew ayükeymün tamün anüael ti doy dullilechi wangku mew ka ayükeymün tamün chaliaetew rüpü mew ti pu che rume yamün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Awngeymün ta eymün tamün wesa mongen mew kiñe kimfalkülenochi küfwe reke feleymün, femngechi tati pu che miyawkey wente küfwe, fey ñi kimnon rume!” ");
INSERT INTO arnNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Feymew llowdungueyew kiñe ti pu wentru kimeltukelu Moyse ñi ley dungu: —Kimeltufe, fey tami feypin mew iñchiñ piñmaltukamupeiñ may. ");
INSERT INTO arnNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Welu Jesus llowdungufi ti wentru kimeltukelu Moyse ñi ley dungu: —¡Awngeymün ta eymün, kimeltukelu ta Moyse ñi ley dungu! Ti kakelu che meñkukünulkefimün reke fentren wimtun dungu, iney rume tañi pepilnoel, welu eymün pichin no rume kellukelafimün. ");
INSERT INTO arnNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Awngeymün ta eymün! Eymün küme adelkakeymün ti pu pelon wentru ñi küfwe, tüfeychi pu pelon wentru ñi langümel eymün tamün kuyfike tuwün em. ");
INSERT INTO arnNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kom kisu engün tañi femel mew eymün ka küme trokitunieymün tañi chumün tamün kuyfike pu tuwün em, kisu engün am langümfilu ti pu pelon wentru, fey eymün küme elmatukefimün ñi küfwe. ");
INSERT INTO arnNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Feymew Ngünechen ñi fütra kimün mew feypi: ‘Werkülelafiñ engün ta pelonke wentru ka pu apostol, fey kiñeke tüfa engün langümafi, fey kakelu kutrankayafi engün.’ ");
INSERT INTO arnNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Feymew tüfachi pu che mülelu fantepu mew Ngünechen ta ramtukayaeyew engün chumngelu tañi langümyefiel engün tati pu pelon wentru feychi dewmangelu müten ta mapu. ");
INSERT INTO arnNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Llituy ta Abel ñi mollfüñ mew, Sakaria ka femngechi langümngey rangi pu ngillatuwe mew. Feymew llemay feypiwayiñ, Ngünechen ta ayüley ñi nentudungulelaetew tüfachi pu che mülelu fantepu mew tañi langümfiel mew ta tüfachi pu pelon wentru. ");
INSERT INTO arnNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Awngeymün ta eymün kimeltukelu Moyse ñi ley dungu! Ngenngeymün reke ta kimün mew, welu eymün no rume küme kimün nielaymün ka elukelafimün ñi adümael tati ayülelu ñi kimael.” ");
INSERT INTO arnNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Femngechi feypietew Jesus kom tüfachi dungu, tati pu kimeltukelu Moyse ñi ley dungu ka ti pu farisew rume lladküy engün, fey eluwingün ñi kayñetudunguafiel ka ñi ramtukayafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Fey tüfa kiñe ngünen müten ürke femngechi tañi kimüñmayafiel ñi chem piael fey ta famngechi tañi feypintukuafiel engün. ");
INSERT INTO arnNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Fey petu trawüluwlu rume fentren che, rume fentren trawüluwkülelu engün am welukonke rültrekamekewi engün. Jesus eluwi ñi dunguael, fey wünelu mew leliwülfi ñi pu disipulu, fey feypifi: “Kuñiwtukuwmün tati pu farisew ñi kimeltun mew, tüfachi dungu mew llemay kisu engün tañi koyla ngünen kimeltun lefawra reke feley. ");
INSERT INTO arnNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ngelay ta chem ellkan dungu rume tañi kimngenoael, ka chem no rume küme ellkalelu tañi pengenoael. ");
INSERT INTO arnNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Feymew llemay eymün tamün feypikeel dumiñ mew, allkütungeay pelon antü mew. Ka tamün ellka dungukeel rakümkülechi ruka mew, wirarün mew feypingetuay wente ruka kütu. ");
INSERT INTO arnNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Eymün llemay, iñche ñi pu weni, feypiwayiñ tamün llükanoafiel ta tüfeychi pu che tati ayükelu tamün langümaetew. Dew femle ngelayay ñi doy chumafel. ");
INSERT INTO arnNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Welu iñche ta feypiwayiñ iney müngell tamün llükayafiel: tati dew müntuñmafilu ñi mongen ta che ka niey pepiluwün tañi tukuafiel ta kütral mapu mew. Fey may ta llükakeafimün. ");
INSERT INTO arnNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“¿Fendengekelay anta kechu pichike üñüm epu pichike moneda mew? Welu femngellefule rume, tüfachi pichike üñüm kiñe no rume ngüyünielaeyew ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Welu ta eymün müngell, kom tamün nieelchi kal longko kütu kake kiñeke rakinieñmangeymün. Feymew llükalekilmün. Eymün ta doy faliymün fentren pichike üñüm mew. ");
INSERT INTO arnNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Fey iñche ta feypiwayiñ iney rume yewentukunoelimew tañi nütramyeaetew tati pu che mew, ka femngechi ti Wentrukünuwpalu yewentukulayaeyew tañi nütramyeaetew ta Ngünechen ñi pu werken püllü mew. ");
INSERT INTO arnNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Welu tañi llumumaetew ta iñche tati pu che mew, ka femngechi llumumayafiñ Ngünechen ñi pu werken püllü mew. ");
INSERT INTO arnNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ngünechen ta wiñoduamatuafi tüfeychi wesa yafkalu kütu ti Wentrukünuwpalu mew, welu wiñoduamatulayafi tati kayñetudungufilu tati Lif Küme Püllü. ");
INSERT INTO arnNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Fey eymün yengelmün tati sinagoga mew, ka tüfeychi pu kues mew ka ti pu awtoridad mew, fey pellkelayaymün chumngechi tamün kisutu dunguñpewael ka tamün chem piael. ");
INSERT INTO arnNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Fey akule ti antü tamün dunguael, tati Lif Küme Püllü kelluaeymünmew tamün chem piael.” ");
INSERT INTO arnNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Fey kiñe wentru mülelu tati trokiñche mew, feypifi ta Jesus: —Kimeltufe, feypifinge ñi peñi tañi eluaetew iñche ñi koneltuleelchi chemkün. ");
INSERT INTO arnNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Feymew llowdungueyew ta Jesus: —Weni, ¿iney anta kueskünuenew femngechi ñi wüdamelafiel eymün tamün nieelchi chemkün? ");
INSERT INTO arnNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ka femngechi feypi: —Kuñiwtukuwaymün ta eymün kom diñmatun dungu mew. Che ñi mongen ta kümelkalekelay tañi nien mew müten ta fentren chemkün. ");
INSERT INTO arnNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Feymew Jesus nütramelfi tüfachi adkünu dungu: “Mülekefuy kiñe riku wentru, fey ñi nganelchi ketran kisu ñi mapu mew rume küme walüngmay. ");
INSERT INTO arnNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Fey ti riku wentru eluwi ñi rakiduamael: ‘¿Chuman chey? Nielan chew ñi elkünuael tañi fün ketran.’ ");
INSERT INTO arnNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Fey kisutu feypiwi: ‘Dew kimün tañi chumael. Teyfükayan tañi nieelchi pu kakon, fey ka dewmatuan doy alükechi kakon, fey tüfey mew elkünuan tañi fün ketran ka kom tañi nieelchi chemkün. ");
INSERT INTO arnNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Feymew ka kisutu feypiwan: Iñche, rume fentren chemkün ellkanien rume fentren tripantungealu. Kansatunge, inge, putunge ka ayüwkülenge.’ ");
INSERT INTO arnNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Welu Ngünechen feypieyew: ‘Wedwed wentru, tüfachi pun müten eymi ta layaymi, fey tami ellkanieelchi chemkün ruka mew, ¿ineyngealu kay?’ ");
INSERT INTO arnNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Femngechi dungu mew ta rupakey tati wentru ngülümkelu fentren chemkün kisungealu müten, welu pofrengey ta Ngünechen mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Feymew Jesus ka feypifi ñi pu disipulu: “Tüfachi dungu feypiwayiñ: fill rakiduamkülekilmün chumngechi tamün iyael ka chem tamün mongeluwküleael ka ti takuwün mew rume tamün tukuael. ");
INSERT INTO arnNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mongen doy faliy ta iyael mew, ka femngechi ta kuerpu doy faliy tati takuwün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ngüneduamfimün tati yeku pingechi üñüm. Ngankelay ka kosechakelay, ka nielay kakon, welu Ngünechen eluniekeeyew ta iyael. ¡Doy faliymün ta eymün tati pu üñüm mew! ");
INSERT INTO arnNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Welu ka femngechi tunte ayüllefule rume kiñe che, ¿iney am rume fill rakiduamkülele, doy alüntupeafuy may ñi mongen kiñe ora rewall? ");
INSERT INTO arnNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Eymün ta pepiluwkenolmün tamün femael pichin dungu, ¿fey chumngelu am fente diñmatukefimün ti kakelu chemkün? ");
INSERT INTO arnNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ngüneduamfimün chumngechi ñi tremken tati pu rayen. Küdawkelayngün rume ka füwkelayngün rume, welu iñche feypiwayiñ tati longko ülmen Salomon rume, kom tañi nieelchi kümeke takuwün mew, tüfachi pu rayen mew trürlafi. ");
INSERT INTO arnNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ngünechen eluniefi ñi tremküleael ti kachu. Fachantü müley lelfün mew, welu wüle lüpümtukukünungeay kütral mew, ¡fey doyelchi eluaeymünmew tamün tukutuwael, eymün, chi pu che newe mupiltulenolu! ");
INSERT INTO arnNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Feymew llemay, ngelay tamün fill rakiduamküleael chem tamün iyael ka chem tamün pütokoael. ");
INSERT INTO arnNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Fey kom tüfachi dungu mew rume küdaweluwkey kom chüf mapu mülechi pu che, welu eymün nieymün kiñe Chaw dew kimnielu tamün duamtuel. ");
INSERT INTO arnNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Doyümnieafimün Ngünechen tañi longko ülmenngen, fey kom tamün duamtunieel ka femngechi llowaymün wüla. ");
INSERT INTO arnNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Llükalekilmün, iñche ñi pu ufisa reke felelu. Eymün ta pichinngeymün, welu ta Chaw Ngünechen kisu ñi kuñillchen mew, ayüley tamün eluaetew kisu ñi ülmen mülewe. ");
INSERT INTO arnNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Fendefimün tamün nieelchi chemkün, fey eluafimün tati duamtunielu. Dewmamün tati folson lludkenolu, tati afkenochi küme felen wenu mapu mew, chew ta puwkelay weñefe ka ngelay chem üñfew no rume. ");
INSERT INTO arnNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Fey chew müley tamün küme felen, fey mew puwküleay tamün rakiduam. ");
INSERT INTO arnNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Pewütuwkülemün, tukutuwkülemün ka üykülepe tamün pelontuwe. ");
INSERT INTO arnNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kiñe kona reke üngümnielu tañi wiñometuael ti ülmen wentru kiñe mafüwün mew, tañi nülalafiel ta wülngiñ dungupatule müten wekuntu wülngiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Sakinngeay tati kona akule ti ülmen wentru, fey pepaeliyew ñi pewütuwkülen. Rüf dungu mew tati ülmen wentru anümaeyew ti mesa mew ka eluway ñi poyeaetew ka ñi eluaetew ti iyael. ");
INSERT INTO arnNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sakinngeay ti kona, fey pengepale ñi trepelen tunte rangi punngeay rume ka tunte epe wünngeay rume. ");
INSERT INTO arnNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tüfachi dungu küme ngüneduamfimün: tati ngen ruka kimfule tunte pun ñi akuael ti weñefe, elulayafuy ñi nülañmangeael ñi wülngiñ ruka tañi weñengeael. ");
INSERT INTO arnNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eymün kafey pewütuwküleaymün, fey ti Wentrukünuwpalu küpayay ti ora mew tamün doy üngümnienofiel mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Fey ramtueyew ta Pedro: —Ñidol, ¿nütramelfimi tüfachi adkünu dungu iñchiñngealu müten, kam kakelu chengealu kay? ");
INSERT INTO arnNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Feymew Ñidol feypi: “¿Iney am tati küme puwtulechi longko, fey kisu tañi ülmen wentru kom elfalkünueyew tañi nieelchi chemkün ta ruka mew, fey akutule tunte antü rume tañi elufemafiel tati iyael? ");
INSERT INTO arnNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sakinngeay tüfeychi kona akule ñi ülmen nieelchi wentru akule ka pepaeliyew ñi küme küdawkülen. ");
INSERT INTO arnNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Rüf dungu mew feypiwayiñ tati ülmen wentru elfalkünuaeyew kom ñi nieelchi chemkün kisu ñi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Welu tüfeychi kona rakiduamle rume fentren mew wüla ñi akutuael ñi ülmen nieelchi wentru, fey eluwle ñi kutrankayafiel ti kakelu kona ka ti ngeñoda domo. ");
INSERT INTO arnNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Fey ti antü mew petu ñi üngümnienofiel ka ti ora ñi kimnoel akule ti ülmen wentru fey kutrankayaeyew, ka püresuntukukünuaeyew chumngechi femngekey tati wesa mongenngechi pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Tati kona kimnielu chem ayünien ti ülmen wentru, welu pewütuwkülenole ka müngeltunofile rume, fey tüfa kutrankangeay rume fentren wimakan mew. ");
INSERT INTO arnNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Welu ti kona fey ñi kimnon rume mekele ñi wesa femün, fey tüfa ta kutrankangeay, pichin wimakan mew müten. Tati rume fentren elungelu, ka femngechi doy fentren müley ñi wültuael: tati rume manelngelu, doyelchi may feley ñi wüldungutuael. ");
INSERT INTO arnNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Iñche ta küpan üyümafiel reke ta kütral kom mapu mew ka ¡ayülefun chey tañi üyküleael dewma! ");
INSERT INTO arnNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","¡Iñche ta rupayan kiñe fütra kutrankawün mew! ¡Ka femngechi rume weñangkülen tüfachi dungu mew, fey dew rupali wüla tüfachi wesa kutrankawün dungu nor duamkületuan! ");
INSERT INTO arnNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Eymün anta feyentuleymün tañi küpalel ta küme tüngün ta mapu mew? Feypiwayiñ tañi femnon, welu may ñi küpayael püntülkawün iñche ñi duam. ");
INSERT INTO arnNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tüfa amuleachi antü mew, kechu che kiñe reñmawen mew püntülkawküleay epu trokiñ mew, küla che kayñetunieafi ti epu che ka ti epu che kayñetunieeyew ti küla che. ");
INSERT INTO arnNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tati chaw kayñetunieay ñi fotüm ka ti fotüm kayñetunieay ñi chaw. Tati ñuke kayñetunieay tañi domo püñeñ ka tati domo püñeñ kayñetunieay ñi ñuke. Tati kuse nanüng kayñetunieay ñi üllcha nanüng ka ti üllcha nanüng kayñetunieay tañi kuse nanüng.” ");
INSERT INTO arnNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus ka feypifi tati pu che: “Eymün pefiyüm ti tromü ñi tripapan konwe antü püle, ‘mawünay tati’ pikeymün, fey femkey. ");
INSERT INTO arnNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ka femngechi waywen kürüfiyüm, ‘kümengetuay’ pikeymün, fey femngechi femkey. ");
INSERT INTO arnNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Koyla ngünen che! Eymün küme kimnieymün tamün ngüneduamafiel ñi chumleken tati kallfü wenu ka nag mapu. ¿Fey chumngelu am ngüneduamlaymün chem dungu ñi mülen fantepu mew? ");
INSERT INTO arnNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Fey ¿chumngelu am kisutu ngüneduamuwkelaymi ka tami femael ti nor dungu? ");
INSERT INTO arnNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Allkütumün tüfachi adkünu dungu: Fey iney rume amule tami wingkañmaaetew, fey amulmu tamu trafdunguael ti awtoridad mew, wüne küme nütramkayaymu petu tami puwnon kues mew, femngechi tami yengenoael ti kues mew. Femnolmi, ti kues wültukuaeymew ti pu soltaw mew, fey ti pu soltaw püresuntukuaeymew ti karsel mew. ");
INSERT INTO arnNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iñche ta feypieyu: tripalayaymi tüye mew dew kullilmi wüla kom tami wesa femel.” ");
INSERT INTO arnNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Feychi tripantu mew kiñeke che amurkey ñi pemeafiel ta Jesus, fey ñi nütramelelmeafiel ta Pilato ñi langümfiel tati pu wentru Galilea tuwlu, fey tüfachi pu che ñi langümngen ti ngillatuwe ruka mew chew mekey ñi chalintukun ti langümelchi kulliñ. ");
INSERT INTO arnNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Fey feypieyew ta Jesus: “Eymün rakiduamküleymün tüfachi pu wentru Galilea tuwlu ñi rupael mew tüfachi wesa dungu, fey ñi doy yafkafengen mew pemay ti kakelu pu che mew mülelu kisu engün ñi trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iñche feypiwayiñ tañi feyngenon, eymün wiñorakiduamtunolmün ta Ngünechen mew ka femngechi layaymün. ");
INSERT INTO arnNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Kam ta eymün feyentuleymün ta tüyechi mari pura layelu tañi trañmaetew mew Siloe mülechi fütra alü pürachi ruka, tüfa femngechi femi tañi doy yafkafengen mew pemay ti kakelu pu che mew mülelu ta Jerusalen mew? ");
INSERT INTO arnNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Iñche feypiwayiñ tañi feyngenon, welu eymün wiñorakiduamtunolmün ta Ngünechen mew ka femngechi layaymün.” ");
INSERT INTO arnNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Feymew Jesus nütrameleyew tüfachi adkünu dungu: “Kiñe wentru nierkefuy kiñe anüm igera ñi pu ofadentu mew, fey amuy ñi pemeafiel ñi niepen may fün igo, welu pemelay kiñe fün no rume. ");
INSERT INTO arnNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Feymew feypifi ti wentru küdawkelu ti ofadentu mew: ‘Feypiaeyu, küla tripantu dewma ñi küpaken tüfachi igera mew ñi kintupayael fün igo, welu pepakelan kiñe fün no rume. ¡Katrüfinge! Mülepüday ta mapu mew fey ñi wülkenon chem fün no rume.’ ");
INSERT INTO arnNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Welu ti küdawkefilu ti mapu llowdungueyew: ‘Ñidol, elkünufinge ka kiñe tripantu. Iñche alükon küme dapillkayafiñ ti mapu ka funañmayafiñ. ");
INSERT INTO arnNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Femngechi wülpelayay fün tati, welu femnole, fey wüla folilentuafiñ.’ ” ");
INSERT INTO arnNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kiñe rupa, tati ürkütun antü mew, Jesus mekerkey ñi kimeltun ti sinagoga mew. ");
INSERT INTO arnNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mülerkey tüye mew kiñe domo kutrankülelu mari pura tripantu dewma. Kiñe weküfü potrongelnierkeeyew, fey pepi küme norümkerkelay ñi kuerpu. ");
INSERT INTO arnNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Feymew Jesus pefilu ti domo, mütrümfi ka feypifi: —Papay, dew lifretuymi tami kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Feymew fampuwüli ñi kuwü kisu mew, fey feychi lelen mew müten ti domo nortuy ñi kuerpu, feymew eluwi ñi püramyeafiel ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Welu tati longkolelu ti sinagoga mew rume lladküy, Jesus am tremoltufilu ti ürkütun antü mew. Fey ti longko feypifi ti pu che: —Müley kayu antü ta küdawam, fey küpakeaymün feytichi antü mew tamün tremolngetuael, welu femkelayaymün tati ürkütun antü mew. ");
INSERT INTO arnNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Welu feypieyew ta Ñidol: —Koyla ngünenngelu, iney rume ta nentuneyfikey ñi mansun ka ñi furiku ti ürkütun antü mew tañi pütokolmeafiel ti wütrunko mew. ");
INSERT INTO arnNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Feytachi domo, kisu ta Abraam ñi yomelche, weküfü ta trariniefeyew reke tüfachi kutran mew, fey amulniefuy dewma mari pura tripantu. ¿Fey kümerkelafuy am ñi nentuneyfingetuael ñi kutran mew ti ürkütun antü mew? ");
INSERT INTO arnNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Feymew Jesus dew feypilu tüfachi dungu, kisu ñi pu kayñe rume yewelkawingün. Welu kakelu ti pu che rume ayüwkülerkey ti fütra dungu mew Jesus tañi femel. ");
INSERT INTO arnNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus ka feypi: “Iñche ta adentuafiñ Ngünechen ñi longko ülmenngeelchi mülewe tüfachi adkünu dungu mew: ");
INSERT INTO arnNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kiñe fün mostasa reke feley, kiñe wentru tañi nganel kisu ñi lelfün mew. Tüfa tremkey, fey kiñe fütra anümkangekey, fey rume fentre tremkelu am tati pu üñüm dañekey kisu ñi row mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ka femngechi feypi Jesus: “Tüfachi dungu mew trürümafiñ Ngünechen ñi longko ülmenngen: ");
INSERT INTO arnNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tati lefawra reke feley kiñe domo tañi tukuel küla rali rüngo mew, femngechi tañi fayümafiel kom ti masan.” ");
INSERT INTO arnNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Fey amulelu Jerusalen waria mew, Jesus kimeltulen rumerpuy kakelu pu waria mew ka ti pichike trokiñ ruka che mew. ");
INSERT INTO arnNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Fey kiñe che ramtueyew: —Ñidol ¿pichiley müten am tati montualu? Fey Jesus llowdungufi ti wentru: ");
INSERT INTO arnNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Yafüluwmün tamün konael ti pichirume wülngiñ mew. Iñche ta feypiwayiñ rume fentren che ayüay ñi konael, welu pepi konlayay engün. ");
INSERT INTO arnNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tati ngen ruka dew witrale fey rakümkünule ti wülngiñ, eymün ta mülelu wekuntu mütrümaymün famngechi: ‘Ñidol, nülalmuiñ.’ Welu kisu llowdunguaeymünmew: ‘Iñche kimuwlayiñ chew tamün tuwün.’ ");
INSERT INTO arnNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Feymew eymün eluwaymün tamün feypiael: ‘Iñchiñ ta ikefuiñ ka putukefuiñ eymi iñchiñ ka femngechi kimeltukefuymi taiñ kalle mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Welu kisu llowdunguaeymünmew: ‘Dew feypiwpeyiñ kimlan tamün chew tuwün. ¡Püntütripamün iñche mew wesake dungu femkelu!’ ");
INSERT INTO arnNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Tüyew ta ngümayaymün ka kütrüray tamün foro fente tamün kutrankawün, fey peafimün ta Abraam, Isaak, Jakob ka kom ti pu pelon wentru mülelu Ngünechen ñi ülmen mülewe mew, welu eymün wemütripaleaymün. ");
INSERT INTO arnNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Femngechi ta küpayay tati pu che pikum ad püle, waywen püle, tripawe antü püle ka konwe antü püle ñi anüpayael tañi iyael engün Ngünechen ñi longko ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Femngechi ta eymün tamün judiungen tati wünenkülefulu, inankületuaymün, fey kakelu che judiungenolu tati inankülekefulu, wünenkületuay.” ");
INSERT INTO arnNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ka femngechi akuyey kiñeke farisew, fey feypifingün ta Jesus: —Tripatunge tüfa mew, Erode ayüley tami langümaetew. ");
INSERT INTO arnNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Feymew feypieyew ta Jesus: —Amumün ka feypimefimün tati langümchefe, tüfeychi ngürü reke felelu: ‘Leliwülnge, fachantü ka wüle wemünentuafiñ tati pu weküfü ka mongeltuafiñ ti pu kutran, fey külawe fentekünuan tañi küdaw.’ ");
INSERT INTO arnNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Welu fachantü, wüle ka külawe antü mew müley tañi inayafiel ti rüpü, kiñe pelon wentru no rume am larkenoalu wekuntu Jerusalen. ");
INSERT INTO arnNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Jerusalen, Jerusalen mülechi pu che, langümkefilu tati pu pelon wentru ka ütrüftukakefimi ta kura mew Ngünechen tami werkülelfetew! ¡Tunte rupachi chey ayüfun tañi trawülafiel tami pu che, chumngechi nga kiñe kude achawall ayükey ñi trawülael ñi pichike achawall miñche ñi müpü mew, welu pilaymün! ");
INSERT INTO arnNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Adkintullemün may, eymün tamün mülekeelchi ruka mew ta kisuleweay ka wellileweay. Rüf dungu feypiwayiñ iñche ta doy pemuwelayan, fey akule wüla ti tripantu eymün tamün feypiael: ‘¡Rume küme felen nieay tati küpalu Ñidol Ngünechen ñi pepiluwün mew!’ ” ");
INSERT INTO arnNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kiñe ürkütun antü mew ürke, Jesus amurkey ñi imeael kiñe longkolechi farisew ñi ruka mew, fey kakelu pu farisew ellka ngüneduamnierkeeyew. ");
INSERT INTO arnNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ka feymew mülerkey Jesus ñi inafül püle kiñe kutran wentru, rumel pifawkülekerkey ñi epu chang. ");
INSERT INTO arnNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus ramtufi tati pu kimeltukelu Moyse ñi ley dungu ka ti pu farisew: —¿Tremolngepeafuy may kiñe kutran ti ürkütun antü mew kam tañi femngenoael? ");
INSERT INTO arnNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Welu kisu engün chem dungulay rume. Feymew Jesus fampuwülelfi ñi kuwü ti kutran, fey mongelfi, ka feypifi ñi amutuael. ");
INSERT INTO arnNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Feymew ka feypifi ti pu farisew: —Iney rume ütrüfkonle kiñe poso mew ñi fotüm kam ñi mansun, pürüm nentutuafuy, tunte ürkütun antüngeafuy rume. ");
INSERT INTO arnNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Fey chem dungu no rume llowdungulaeyew engün. ");
INSERT INTO arnNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Feymew Jesus pefilu ti pu mangel chumngechi ñi dullikameken doy kümeke wangku ti pu ülmen che ñi anüpeyüm ti mesa mew, fey famngechi ngülamfi: ");
INSERT INTO arnNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Iney rume mangelelmew kiñe kawiñ mafüwün mew, anükünuwkelayaymi doy küme wangku mew, fey akule rume kangelu mangel doy ülmen wentrungelu eymi mew. ");
INSERT INTO arnNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Fey tami mangeletew küpayay tami feypipayaetew: ‘Elufinge tami wangku tüfachi kangelu ülmen wentru.’ Feymew nga müleay tami witrapüratuael yewenkechi ka tami anükünuwtuael ti doy wesa wangku mew. ");
INSERT INTO arnNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Femngechi mangelngelmi, anükünuwaymi ti doy wesa wangku mew, feymew küpale tami mangeletew feypiaeymew: ‘Weni, faw püle küpange. Anüpange tüfachi doy küme wangku mew,’ femngechi doy fütra ülmen wentru trokingeaymi tati pu anülelu eymi engün ti mesa mew. ");
INSERT INTO arnNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Femngechi tati re kisutu mallmawkülelu, yewelkangeay. Fey tati kisu illamtuwkülelu, püramyengeay. ");
INSERT INTO arnNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesus ka feypifi ti wentru tañi mangeletew: —Femngechi eluafilmi ta iyael kam pun iyaelngeay rume, mangelkelayaymi tami pu weni, tami pu peñi no rume, ka tami pu reñma nieel no rume, ka tami rikulechi karukatu no rume. Kisu engün ta ka femngechi wiñome mangeltuaeymew, femngechi wiñolelngetuaymi tami mangelkefiel mew. ");
INSERT INTO arnNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Welu famkeaymi may, femngechi eymi nielmi kiñe kawiñ mangelkeafimi tati pu pofre, tati pepi küdawkenolu, ka ti küntrongelu, ka ti pu trawma. ");
INSERT INTO arnNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Femngechi ayüwün nieaymi. Kisu engün ta pepi kullilayaeymew, welu eymi llowaymi tati kullitun feychi antü wiñomongetule ti pu lif piwkengelu. ");
INSERT INTO arnNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Fey allkülu tüfachi dungu, kiñe ti pu wentru anülelu mesa mew, feypifi ta Jesus: —¡Sakinngeay tati iyalu Ngünechen ñi ülmen mülewe ñi kawiñ mew! ");
INSERT INTO arnNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Fey Jesus feypieyew kiñe adkünu dungu mew: —Kiñe wentru wülürkey kiñe fütra pun ilelkawün, fey werküy ñi mangelafiel rume fentren che. ");
INSERT INTO arnNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Fey puwlu ti ora ñi ingeael ti pun iyael, werküy ñi pu kona fey feypifalfi tati pu mangel: ‘Küpamün. Itrokom iyael dewküley.’ ");
INSERT INTO arnNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Welu kom nentudunguyngün ñi pepi amunoael. Tati wüne mangelngelu feypi: ‘We ngillapen kiñe lelfün, fey amuan ñi pemeafiel. Llellipuaeyu tami wesa duamnoael.’ ");
INSERT INTO arnNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kangelu feypi: ‘Ngillapen kechu trariñ mansun, fey amuan ñi pichi küdawelafiel. Llellipuaeyu tami wesa duamnoael.’ ");
INSERT INTO arnNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Fey kangelu ka feypi: ‘We kurengen, feymew pepi amulayan.’ ");
INSERT INTO arnNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Fey ti ülmen wentru ñi kona wiñomey, fey nütramelpatueyew. Feymew ti ülmen wentru rume wesa duami ka feypifi ñi kona: ‘Pürüm amunge rüpü püle ka ti pülasa püle, fey küpalfinge tati pu pofre, tati pepi küdawkenolu, ti pu trawma ka ti pu küntrongelu.’ ");
INSERT INTO arnNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Fey doy konantü tati kona feypi: ‘Ñidol, dew femün eymi tami werküfielchi dungu, welu petu apolay ti ruka.’ ");
INSERT INTO arnNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Feymew ti ülmen wentru feypifi ti kona: ‘Iñche ayülen ñi apoael ñi ruka tati pu che mew, fey amunge ti pu rüpü püle, fey aporiafinge ti pu che tañi konpayael engün, femngechi fentren che müleay tañi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iñche ta feypiwayiñ kiñe no rume tüyechi pu che tañi wüne mangelfel, konpalayay tañi ipayael iñche ñi ruka mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Fey Jesus inanierkeeyew rume fentren che, fey kisu wiñokintufi ka feypifi: ");
INSERT INTO arnNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kiñe che küpale iñche mew, welu doy piwkeyenoelimew kisu ñi chaw mew, tañi ruka mew, kisu ñi kure mew, ka ñi pu fotüm mew, ñi pu peñi ka ñi pu lamngen mew, ka femngechi doy piwkeyenoelimew kisu mew ngeay rume, iñche ñi disipulungelayay. ");
INSERT INTO arnNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ka femngechi iney rume inaelimew, welu eluwkülenole ñi layael kütu iñche ñi duam, iñche ñi disipulungelayay. ");
INSERT INTO arnNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Fey kiñe che ayüle ñi dewmayael kiñe fütra ruka, ¿wüne anükünuwpelayafuy may ñi nentukuentayael, femngechi tañi kimael tunten pülata mew ñi dewmayafiel ñi ruka? ");
INSERT INTO arnNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Femngechi dew anümle ñi ruka, fey pepi dewma entuwetunofile, fey ti pu che peeliyew eluway ñi ayentuaetew engün ");
INSERT INTO arnNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","feypin mew: ‘Tüfachi wentru eluwi ñi dewmarukan, welu pepi dewmantulay.’ ");
INSERT INTO arnNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ka femngechi kiñe longko ülmen amuale ñi weychameafiel ti kangelu longko ülmen. ¿Fey wüne anükünuwpelayafuy may ñi nentukuentayael tañi yeael mari warangka soltaw femngechi tañi weychameafiel tati nielu epu mari warangka soltaw? ");
INSERT INTO arnNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Fey pepi weychamenofile, welu ti kangelu longko ülmen petu ñi alü kamapulen, ‘amunge’ piafuy ñi werken tañi weychalmenoafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ka femngechi, ineyngeay rume kiñeke ta eymün elkünunoale kom ñi nieel, iñche ñi disipulungelayay. ");
INSERT INTO arnNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tati chadi kümey, welu kotrüwetunole, ¿chumngechi am wiñome kotrütuafuy? ");
INSERT INTO arnNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kümelay widpüngeael mapu mew no rume ka ti trumawkülechi funa mew no rume. Fey ütrüfentungekey müten. “Tati nielu pilun, allküpe tüfachi adkünu dungu.” ");
INSERT INTO arnNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Fey kom tati pu kofrakelu impuestu Romangealu ka ti kakelu pu che rume wesa dunguyen chengelu, fülkonparkey engün Jesus mew tañi allkütuñmayafiel ñi kimeltun. ");
INSERT INTO arnNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fey ti pu farisew ka ti pu kimeltukelu Moyse ñi ley dungu dunguyemekefi engün ta Jesus ñi entuüñfilfiel feypilen mew: —Tüfa llowkefi ti pu yafkafe ka kiñentrür ikey kisu engün. ");
INSERT INTO arnNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Feymew tüfachi adkünu dungu nütramkaleleyew engün ta Jesus: ");
INSERT INTO arnNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kiñe wentru niey pataka ufisa, fey kiñe ñamkünuwi. Fey ñi kintuafiel ti ñamkülechi ufisa, ¿elkünupelayafuy may lelfün mew ti aylla mari aylla ufisa? Fey petufile wüla, nor duamküleweay. ");
INSERT INTO arnNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Fey dew petufile, fente ñi ayüwün meñkupüramafi ñi llangka foro mew. ");
INSERT INTO arnNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Fey akutule ñi ruka mew, trawülay ñi pu weni ka ñi pu karukatu, fey feypiafi: ‘Kiñentrür ayüwayiñ, dew petun tañi ñamümkefelchi ufisa.’ ");
INSERT INTO arnNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iñche feypiwayiñ tati aylla mari aylla lif mongenngelu duamtulay tañi wiñorakiduamtuael, feymew doy müleay ayüwün wenu mapu mew kiñe yafkafe ñi wiñorakiduamtun ta Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ka femngechi tüfa: Kiñe domo niefuy mari moneda, welu kiñe ñamümi. ¿Fey üyümpelayafuy may ñi pelontuwe ñi lepütuael ñi ruka femngechi ñi kintuafiel kuñiwtun mew ñi ñamümelchi moneda? Fey petufile wüla, ñi norduamkületuael. ");
INSERT INTO arnNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Fey dew petufile trawülay ñi pu weniyeelchi pu domo, ka ñi pu karukatu, fey feypiafi: ‘Kiñentrür ayüwayiñ. Dew petun tañi ñamümfelchi moneda.’ ");
INSERT INTO arnNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iñche feypiwayiñ kiñe yafkafe ta wiñorakiduamtule ka femngechi rume ayüway Ngünechen ñi pu werken püllü.” ");
INSERT INTO arnNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus ka femngechi feypi: “Kiñe wentru nierkey epu fotüm. ");
INSERT INTO arnNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Fey ti doy inan weche wentru feypifi ñi chaw: ‘Chachay, eluaen ti trokiñ chemkün iñche tañi koneltuleel.’ Feymew tati ngen fotüm wüdamkalelfi ñi koneltuleelchi chemkün ñi epu fotüm. ");
INSERT INTO arnNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Fey kiñe mufü antü rupalu, ti inan fotüm kom fendey ñi chemkün, fey amuy rume alü kamapu, kangelu trokiñ mapu mew, fey tüye mew kom wesa pünekapuy ñi elungeñmuel ka rume wesa mongen niepuy. ");
INSERT INTO arnNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Welu feychi dew kom apümlu ñi pülata, tüyechi trokiñ mapu mew mülerumey kiñe fütra filla antüngen, fey kisu rume ngüñüwtuy. ");
INSERT INTO arnNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Fey amuy ñi kintuküdawmeael kiñe ülmen wentru mew mülelu tüyechi mapu mew, fey tüfa werküeyew ñi kuydasañweael lelfün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Rume küpa irkefuy tañi iyael tañi ikeel ti pu sañwe, welu fey rume elungelay ñi iyafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Fey afduamlu eluwi ñi rakiduamael: ‘¡Tunten küdawfe chey müley iñche ñi chaw ñi ruka mew, fey nieyngün fentren iyael, welu iñche tüfa mew epeke entrin ngüñün mew!’ ");
INSERT INTO arnNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wiñotuan iñche ñi chaw ñi ruka mew, ka feypiputuafiñ: ‘Chachay, yafkan ta Ngünechen mew ka eymi mew. ");
INSERT INTO arnNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yewenngey iñche ñi fotüm tami piafiel ta iñche. Kiñe tami kona trokiaen rewall.’ ");
INSERT INTO arnNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Feymew rüpütukünuwpatuy ñi küpatuael ñi chaw ñi ruka mew. “Fey petu alü kamapu küpalelu, ñi chaw peeyew fey kutranpiwkeyeeyew. Ka lefi ñi trafyemetuaetew, fey llowmeeyew kiñe pangkon mew ka kiñe truyun mew. ");
INSERT INTO arnNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Fey ti weche wentru feypifi ñi chaw: ‘Chachay, yafkan ta Ngünechen mew ka eymi mew. Yewenngey iñche ñi fotüm tami piafiel ta iñche.’ ");
INSERT INTO arnNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Welu ñi chaw werküy ñi pu kona: ‘Pürüm nentupamün ti doy kümeke takuwün ka tukutufimün. Ka tukulelfimün kiñe iwül kuwü ñi changüll kuwü mew ka okota ñi namun mew. ");
INSERT INTO arnNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Fey ka küpalfimün ti doy motrichi tripantu kulliñ, fey langümfimün. ¡Iyaiñ ka nieaiñ kawiñ. ");
INSERT INTO arnNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tüfa iñche ñi fotüm tati, lakefuy reke ka wiñomongetuy. Ñamkefuy tati, ka petufiyiñ!’ Fey eluwi engün ñi nieael ta kawiñ. ");
INSERT INTO arnNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Fey ti fütache ñi wünen fotüm miyawürkey lelfün mew. Fey wiñomelu, akutuy inafül ruka, fey allküy ti musika ka ti purun. ");
INSERT INTO arnNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Feymew mütrümfi kiñe ñi pu kona, fey ramtufi famngechi: ‘¿Chem dungu anta müley?’ ");
INSERT INTO arnNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Fey ti kona feypieyew: ‘Tami peñi ñi akutun mew tati. Fey tami chaw langümfali ti doy motrichi tripantu kulliñ, tañi küme akutun mew ka ñi küme tremolkülen mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Welu rume lladküy ti wünen fotüm. Pilay rume ñi konpatuael, feymew ñi chaw tripatueyew ñi llellipuaetew tañi konpatuael. ");
INSERT INTO arnNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Feymew kisu feypifi ñi chaw: ‘Eymi kimnieymi tunten tripantu tami küdawelkefiel, ka rumel müngeltuniekeeyu, welu kiñe nag no rume elukelaen kiñe pichi kapüra tañi kawiñael ñi pu weni iñchiñ. ");
INSERT INTO arnNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Welu akutulu tami fotüm, tami wesa pünekañmaetew tami pülata ñiwalechi pu domo mew, fey langümelfimi ti doy motrichi tripantu kulliñ kisungealu.’ ");
INSERT INTO arnNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Fey kisu ñi chaw llowdungueyew: ‘Fotüm, eymi iñchiw ta rumel mülekeyu, fey kom tañi nieel iñche eymingealu. ");
INSERT INTO arnNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Welu fewla rume kümey taiñ kawiñael ka taiñ ayüwael tami peñi tati lakefuy reke, fey wiñome mongetuy. Ñamkefuy reke tati, fey ka petufiyiñ.’ ” ");
INSERT INTO arnNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Feymew Jesus nütramelfi tüfachi adkünu dungu tañi pu disipulu: “Mülekefuy kiñe longkolechi kona küdawelkefilu kiñe riku wentru. Fey feypintukungey ti longkolechi kona ñi wesaka pünekañmafiel ti riku wentru ñi chemkün. ");
INSERT INTO arnNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Feymew ti riku wentru mütrümeyew ka feypieyew: ‘¿Chem mew anta feypingen tami femün eymi tüfachi dungu? Nentukuentange tami küdaw mew, eymi ta doy iñche ñi longkolechi konangewetulayaymi.’ ");
INSERT INTO arnNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Feymew ti longkolechi kona eluwi ñi rakiduamael: ‘¿Chuman am fewla iñche tañi ülmen wentru nentutuenew ñi küdaw mew? Niewelan ta newen tañi küdawafiel ta mapu, ka yewelen ñi ngillatuyawael chem rume. ");
INSERT INTO arnNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Welu dew kimün tañi chumael, femngechi tañi nieael iney ñi llowaetew kisu ñi ruka mew, feychi niewetunoli küdaw.’ ");
INSERT INTO arnNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Feymew mütrümfi kake kiñeke tati defelelu pichiken kisu tañi ülmen wentru mew. Kiñe wünelu mew ramtufi: ‘¿Tunten defeniefimi tañi ülmen wentru?’ ");
INSERT INTO arnNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Fey llowdungueyew: ‘¡Defeniefiñ pataka faril aseyte tati ikeel!’ Fey ti longkolechi kona feypi: ‘Tüfa tami tunte defelen. Pürüm anükünuwnge, fey dewmatunge kangelu kechu mari mew müten.’ ");
INSERT INTO arnNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Feymew ka ramtufi kangelu: ‘Eymi kay, ¿tunten defeniefimi?’ Tüfa llowdunguy: ‘Kiñe warangka saku kachilla.’ Fey kisu feypifi: ‘Tüfa tami tunte defelen, fey dewmatunge kangelu pura pataka saku mew müten.’ ");
INSERT INTO arnNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Feymew ti ülmen wentru kimlu ñi femün tati wesa longkolechi kona feypi: ‘Tüfachi wentru müchay rume küme adkünuy ñi dungu koyla ngünen mew. Fey ti mapu tuwünngechi pu che müchay adkünukey ñi dungu, welu ti pu che pelon ñi fotüm pingekelu femkelay engün.’ ");
INSERT INTO arnNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iñche ngülamuwayiñ, küme püneafimün ti chemkün mülelu tüfachi yafkafe mapu mew femngechi tamün wewael ta weni, fey dew afle ti fentren chemkün, müleay iney tamün llowaetew ta eymün ti rumel mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ka feypiwayiñ, tati manelngelu tunte pichinngeay rume, ka femngechi manelngeay ti fentrelelu mew, tati nienolu yamün ti pichin mew ka niekelay yamün ti alün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Femngechi tatey tüfachi yafkafe mapu mew mülechi fentren chemkün eymün küme pünenofilmün, ¿iney am manelaeymünmew ti fentren kümeke chemkün mew? ");
INSERT INTO arnNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka femngechi küme küdawyenofilmün kakelu che ñi chemkün, ¿chumngechi am manelngeaymün tamün küdawmeael? ");
INSERT INTO arnNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ka feypiwayiñ iney rume poyelayafuy epu ülmen wentru. Kiñe müleafuy ñi üdeafiel, fey kangelu ñi piwkeyeafiel, kam ta kiñe müten ta küme puwtuafi, fey illamtuafi ti kangelu. Ngerkelay tañi poyengeael ta Ngünechen ka fentren chemkün.” ");
INSERT INTO arnNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fey ti pu farisew, weniyefilu ta pülata allküy kom tüfachi dungu, fey ayentukafingün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Feymew Jesus feypieyew: “Eymün ta rume küme piwkekawünkeymün tati pu che mew, welu Ngünechen kimnieñmaeymünmew tamün piwke. Femngechi tati pu che mew rume küme chelelu, Ngünechen ta üdekeeyew. ");
INSERT INTO arnNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Tati ley dungu ka ti pu pelon wentru ñi dungu afpuy Juan ti Fawtisachefe mew. Feychi mew llitungey ñi kimeltungeael ti küme dungu Ngünechen ñi longko ülmenngen, feymew ta itrokom che yafüluwkey ñi konpuael wenu mapu. ");
INSERT INTO arnNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Welu ngüneduammün: tunte afllefule rume wenu mapu ka nag mapu, welu feley tañi kom mupiael ti ley dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Feymew feypiwayiñ: kiñe wentru wüdakünule ñi kure ka kureyetufile kangelu domo, fey ñiwaldomofengey. Feyti kureyewlu ti wüdakünuelchi domo engu, fey ta ka femngechi ñiwaldomofengey. ");
INSERT INTO arnNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ka femngechi feypiwayiñ kiñe adkünu dungu: Mülekerkefuy kiñe riku wentru, fey tüfa tukukefuy re kümeke takuwün ka rume küme adngechi takuwün, ka fill antü niekerkefuy kawiñ. Rume fentren kümeke chemkün pünekefuy. ");
INSERT INTO arnNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ka femngechi mülekefuy kiñe pofre wentru Lasaru pingelu, rume wesa kutran nierkefuy apo müdalerkefuy ñi trawa pitru mew, fey anülekefuy pülli mew ti riku ñi wülngiñ ruka püle. ");
INSERT INTO arnNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tüfachi pofre illutukerkefuy ñi iyafel, welu elungekelafuy ti ütrüfnagchi rüngün kofke no rume ti riku ñi mesa mew. Fey ti pu trewa fülkontukefeyew ñi küllmañmayaetew ñi pitrulechi trawa. ");
INSERT INTO arnNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kiñe antü ti pofre larkey, fey tati pu werken püllü yeturkeeyew ti ülmen mülewe mew chew ñi mülemum ta Abraam. Welu ti riku ka larkey, fey rüngalngelu, eluwünmangey. ");
INSERT INTO arnNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Fey ti riku kutrankawkülepulu tüye mew chew ñi puwkemum ti dew lalu, fey pürakintuy, feymew perkefi alü kamapu ta Abraam, ka Lasaru engu mülelu tüye mew. ");
INSERT INTO arnNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Feymew wirarüy: ‘¡Chachay Abraam, kutranpiwkeyeen ta iñche! Werküfinge ta Lasaru. Küchukünupe ñi wechuñ changüll kuwü ko mew, fey küpape tañi fiskümüñmayaetew ñi kewün. Iñche ta rume kutrankawkülen tüfachi kütral mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Welu Abraam llowdungueyew: ‘Fotüm, longkontukupange. Eymi tami mongen mew rume küme felen niekefuymi, welu Lasaru rume kutrankawün mew mongelekefuy. Fewla kisu nietuy küme felen tüfa mew, fey eymi kutrankawkületuymi. ");
INSERT INTO arnNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ka femngechi wüdamentunieeiñmew kiñe alü rupalechi lil iñchiñ taiñ mülemum ka eymün tamün mülemum, fey pepi rumelaiñ üyew püle, ka femngechi tati tüyew püle mülelu, pepi rupalayafuy faw püle.’ ");
INSERT INTO arnNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Fey ti riku feypi: ‘Iñche llellipuaeyu, chachay Abraam, tami werküafiel ta Lasaru iñche ñi chaw ñi reñma mew ");
INSERT INTO arnNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","chew ta nien kechu peñi, fey ngülamdungumeafuy femngechi ta kisu engün tañi akunoael tüfachi kütral mapu mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraam feypi: ‘Kisu engün dew niey Moyse ñi wirielchi dungu ka ti pu pelon wentru ñi wirielchi dungu: ¡Fey müngeltuafi engün!’ ");
INSERT INTO arnNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Fey ti riku llowdunguy: ‘Feyngey tati, chachay Abraam, welu kiñe ti dew lalu wiñomongetule ka pewfaluwtule, kisu engün elkünutuay ñi wesa mongen ka wiñorakiduamtuafuy engün.’ ");
INSERT INTO arnNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Welu Abraam feypieyew: ‘Llowmanofile Moyse ñi dungu ka ti pu pelon wentru ñi dungu, ka femngechi feyentulayafingün kiñe tati dew lalu, wiñomongetullefule rume.’ ” ");
INSERT INTO arnNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus feypifi ñi pu disipulu: “Rumel müleay dungu kintukaduamkefilu ta che ñi yafkayael, welu ¡awngeay ti che yafkan mew tukufile ta kakelu che! ");
INSERT INTO arnNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Doy kümeafuy trapeltukulelngele pel mew kiñe fütra kura, fey ütrüftukungele pu lafken, welu tañi tukungenoael yafkan mew kiñeke tüfachi newe nienolu mupiltun. ");
INSERT INTO arnNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Rume kuñiwtukuwmün tüfachi dungu mew! Eymi tami peñi yafkale, katrütudungufe, welu wiñoduamtule ñi nietuael kiñe küme femün, fey wiñoduamatuafimi. ");
INSERT INTO arnNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tunte yafkaelmew rume regle rupa kiñe antü mew, fey regle rupa küpale tami feypiaetew: Doy famngechi femwelayan, müley tami wiñoduamatuafiel.” ");
INSERT INTO arnNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Feymew tati pu apostol llellipufingün ta Ñidol: —Elumuiñ taiñ doy maneluwael ka taiñ mupiltuleael. ");
INSERT INTO arnNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Feymew Ñidol llowdungueyew: —Eymün niefulmün maneluwün ka mupiltun, tunte kiñe pichi fün mostasa fenteafuy rume, feypifilmün tüfachi anümka: ‘Ngedutripange tüfa mew ka anükonpunge ti pu lafken’, fey ti anümka müngeltuafeymünmew. ");
INSERT INTO arnNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Fey feypiwayiñ kangelu adkünu dungu: Kiñe che nierkey kiñe kona, fey tüfachi kona wiñomele lelfün mew, dew ketramapumele kam dew kamañufisale rume, ¿fey feypingepeafuy may: ‘Konpange faw püle. Anüpange tami ipayael?’ ");
INSERT INTO arnNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Feypingelayafuy, welu feypingeafuy may: ‘Dewmalen ta iyael, ka witratripange tami poyeafiel, fey iñche wüne ikünuan ka putuan, fey wüla eymi iyaymi ka putuaymi.’ ");
INSERT INTO arnNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ka femngechi mañumngelayay rume tati kona tañi poyefiel mew ñi werküetew. ");
INSERT INTO arnNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ka femngechi eymün, dew femülmün kom tamün werküetew ta Ngünechen, fey müley tamün feypiael: ‘Iñchiñ ta wesake konangeiñ, fey iñchiñ am femkelu kisuke taiñ nieelchi küdaw müten.’ ” ");
INSERT INTO arnNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Amulelu ta Jerusalen, Jesus rüpütuley, fey rumerpuy Samaria ka Galilea ñi trokiñke mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Fey puwlu kiñe pichi trokiñ ruka che mew, tüfey mew tripapay ñi trafyeaetew mari wentru lepra kutranngelu, fey tüfa engün witrakünuwi alü kamapu kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Fey wiraringün: —¡Jesus, Kimeltufe, kutranpiwkeyemuiñ! ");
INSERT INTO arnNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Feymew Jesus pefilu engün, feypifi ti mari wentru: —Amumün tamün leliwülaetew ti pu saserdote. Fey petu amulelu engün, lifkülewerumetuy ñi kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Fey kiñe tüfa engün, inaduamuwlu ñi lifkülewetun, wiñometuy ka püramyeniefi ta Ngünechen newentu wirarün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Fey lukutupay Jesus ñi fül mew, ka potrongnagi pülli mew tañi mañumtuafiel. Tüfachi wentru kiñe illamfal samariache ürke. ");
INSERT INTO arnNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesus feypi: —¿Mari no engün ama ti pu lifngetulu ñi kutran mew? ¿Chew am müley tati kakelu aylla wentru? ");
INSERT INTO arnNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Chem dungu anta tüfa? ¡Kiñengey müten ñi wiñometun tañi püramyeafiel ta Ngünechen tüfachi katripanche! ");
INSERT INTO arnNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Feymew Jesus feypifi ti wentru: —Witrapürange ka amutunge. Tami maneluwün mew ka tami feyentun mew ta tremotuymi. ");
INSERT INTO arnNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fey ti pu farisew ramtufingün ta Jesus tuntepu mew tañi akuael Ngünechen ñi longko ülmenngeael, fey llowdungueyew ta Jesus: —Ngünechen ñi longko ülmenngen akulayay ta kom che ñi adkiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Feypingelayay tatey: ‘Faw müley’, kam ‘tüye mew müley’. Ngünechen ñi longko ülmenngen fantepu mew dew mülepay ta eymün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Fey wüla ka feypifi ñi pu disipulu: —Akuay ta tripantu eymün ta ayüaymün tamün peafiel kiñe antü rewall tati Wentrukünuwpalu, welu pelayafimün. ");
INSERT INTO arnNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kiñeke feypiayngün: ‘Faw müley’ kam ‘tüye ñi mülen’, welu amukilmün ka inakefilmün rume. ");
INSERT INTO arnNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Chumngechi ta kiñe llüfkeñ wilüfiyüm pelontukey kiñe püle ta wenu mew, fey ka alofpukey kañpüle, femngechi ta femay feychi antü wiñometule ti Wentrukünuwpalu. ");
INSERT INTO arnNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Welu wüne müley ñi rume kutrankawael ka tañi llownoaetew ti pu che mülelu fantepu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Chumngechi rupay feychi Noe ñi tripantu mew ka femngechi femay feychi antü mew wiñometule ti Wentrukünuwpalu. ");
INSERT INTO arnNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Feychi mew ti pu che duamkülelay engün ñi akuael ti mangin ko, fey imekey ka putumekey, kurengemekey engün, feychi antü konlu wüla Noe ti fütra wampo ruka mew, fey akuy ti fütra mangin ko, feymew kom lankepi engün. ");
INSERT INTO arnNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ka femngechi femi feychi mongelelu ta Lot: ti pu che duamkülelay engün ñi akuael ti wesa antü, fey imekey ka putumekey, ngillakamekey, ka welukamekey, nganmekey ka dewmarukamekey engün. ");
INSERT INTO arnNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Welu feychi mew tripalu Lot ta Sodoma waria mew, mawün reke nagi ta kütral ka asufre wenu mew, fey kom lankepi engün. ");
INSERT INTO arnNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ka femngechi femay feychi antü mew ti Wentrukünuwpalu pewfaluwle. ");
INSERT INTO arnNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tüyechi antü mew, tati mülelu wente ruka mew, fey ka niele ñi chemkün ti pu ruka, nagkilpe ñi nentumeael. Ka tüfeychi mülelu ti lelfün mew, wiñokilpe ñi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tukulpafimün chumngechi ñi femün Lot ñi kure. ");
INSERT INTO arnNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tati ayülu ñi montulael ñi mongen, fey ta pelayay. Welu tati ütrüflu ñi mongen, fey ta montulay. ");
INSERT INTO arnNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Iñche feypiwayiñ tüyechi pun epu che kuduleay kiñe kawitu mew, fey kiñe yengetuay, welu kangelu elkünungeay. ");
INSERT INTO arnNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Epu domo kiñentrür mekeay ñi mürken kudi mew. Kiñe yengeay, fey kangelu elkünungeay. ");
INSERT INTO arnNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Epu che müleay lelfün mew: kiñe ta yengeay, fey kangelu elkünungeay.” ");
INSERT INTO arnNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Feymew ramtungey: —Ñidol, ¿chew püle am rupayay tüfachi dungu? Fey Jesus kiñe adkünu dungu mew llowdungufi ñi pu disipulu: —Chew mülele tati la, feyti mew trawüluway tati pu kanin. ");
INSERT INTO arnNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus nütramelfi ñi pu disipulu kiñe adkünu dungu femngechi tañi kimeltuafiel engün fill antü ñi ngillatuleael, ka ñi afeltukunoael. ");
INSERT INTO arnNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Fey feypifi: “Mülekefuy kiñe waria mew kiñe kues ekunienofulu ta Ngünechen ka yamkenofilu rume ti pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ka feytichi waria mew mülekefuy ta kiñe lantu domo. Fey tüfa nierkefuy kiñe pleytu dungu, fey amukerkey ti kues mew tañi ‘kelluen’ pimeafiel fey ñi küme eleltuaetew ñi dungu tañi kayñe mew. ");
INSERT INTO arnNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Rume fentre rupachi ti kues pikelafuy ñi llowaetew, fey fentren mew wüla rakiduami: ‘tunte ekunielafiñ rume ta Ngünechen ka yamkelafiñ rume ta pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Welu femkellefuli rume, tüfachi lantu domo fill antü reke küpatumekekeenew, iñche ta ingkayafiñ, fey tañi küpatumekenoaetew ka tañi lladkülkanoaetew.’ ” ");
INSERT INTO arnNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Feymew Ñidol ka feypi: “Tüfa ñi feypin tati wesa kues. ");
INSERT INTO arnNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Fey tüfa ñi femürken tati ¿Ngünechen may ingkapelayafuy ñi pu dullinieel, tüfey engün tati ngillatulekelu kisu mew antü ka pun? ¿Elupeafuy may ñi üngümküleael? ");
INSERT INTO arnNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iñche feypiwayiñ pürümkachi ingkayafi fey ñi üngümkülenoael. Welu feychi küpatuale ti Wentrukünuwpalu ¿pepapeay may ñi mülen mupiltun ta mapu mew?” ");
INSERT INTO arnNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus nütramkalelfi tüfachi kangelu adkünu dungu fey kiñekentu doy küme piwkengelu trokiwkülekelu am, fey illamtuniekefi kakelu pu che: ");
INSERT INTO arnNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Epu wentru amuy ti ngillatuwe ruka mew ñi ngillatumeael, kiñe farisew ürke, fey kangelu kiñe kofrakelu impuestu Romangealu. ");
INSERT INTO arnNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fey ti farisew, witralepuy ka famngechi ngillatupuy: ‘Ngünechen mañumkeeyu, iñche ta kakelu che reke ñi femngenon mew. Tüfa engün weñefengey ka ñiwaldomokeyngün. Ka tüfachi kofrakelu ta impuestu reke ta femngelan rume. ");
INSERT INTO arnNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iñche ikelan epu antü semana mew ka elukeeyu kiñe trokiñ mari puwlu kom tañi wewkeelchi chemkün mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Welu ti kofrakelu ta impuestu mülewey pichi alü kamapu, newe pürapaduamlay rume tañi lelipürayael, ka femngechi wülelkamekey ñi rüku fente ñi weñangkün. Ka feypimekey: ‘¡Ngünechen kutranpiwkeen may, yafkafengen ta iñche!’ ");
INSERT INTO arnNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Iñche ta feypiwayiñ tüfachi kofrakelu ta impuestu, wiñotulu ñi ruka mew, dew wiñoduamatueyew yafkan mew ta Ngünechen, welu ti farisew wiñoduamangelay ñi yafkan mew. Femngechi tati re kisutu mallmakawlu, rume illamkangeay, welu tati kisutu illamuwkülelu, fey ta rume sakinngeay.” ");
INSERT INTO arnNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ka femngechi puwülelngey pichikeche ta Jesus, tañi fampuwülael ñi kuwü ta kisu engün mew, welu ti pu disipulu, pefilu ti pichikeche, eluwi ñi katrütuafiel tati yeniefilu ti pichikeche. ");
INSERT INTO arnNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Feymew Jesus mütrümfi ka feypifi ñi pu disipulu: —Elufimün ñi küpayael iñche mew ti pichikeche, fey katrütukefilmün. Ngünechen ñi ülmen mülewe mew am koneltulelu tati pichikeche reke femngelu. ");
INSERT INTO arnNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Rüf dungu mew feypiwayiñ tati che kiñe pichiche reke llownofilu Ngünechen ñi longko ülmenngen, konpulayay ta Ngünechen ñi mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Fey kiñe ti pu longkolelu ramtufi ta Jesus: —Lif mongen kimeltufe, ¿chumafun chey tañi nieael ti rumel mongen? ");
INSERT INTO arnNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Fey llowdungueyew ta Jesus: —¿Chumngelu anta Lif mongen kimeltufe pien? Ti lif mongenngelu kiñeley müten: Ngünechen tatey. ");
INSERT INTO arnNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Dew kimnieymi ta werkün dungu: ‘Ñiwaldomokilnge, langümkilnge, weñekilnge, koylatukilnge femngechi tami wesalkanoafiel ta iney no rume, ka yamfinge tami chaw ka tami ñuke.’ ");
INSERT INTO arnNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Fey ti wentru feypi: —Kom tüfachi dungu femken iñche weche wentrungelu müten. ");
INSERT INTO arnNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Fey Jesus, allkülu tüfachi dungu, feypifi ti wentru: —Kiñe dungu petu müley tami femael: fendenge kom tami nieelchi chemkün, ka eluafimi tati pu nienolu chem no rume. Femngechi nieaymi fentren chemkün wenu mapu. Fey küpange ka inaen. ");
INSERT INTO arnNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Welu ti wentru allkülu tüfachi dungu, rume weñangküduami, kisu am rume rikulelu. ");
INSERT INTO arnNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Fey Jesus ngüneduamfilu ñi weñangkün, feypi: —¡Rume küdawngey ñi konael tati pu rikungelu Ngünechen ñi ülmen mülewe mew! ");
INSERT INTO arnNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Doy küdawngelay ta kiñe kamellu ñi rumeael ti longko akucha mew, fey kiñe riku ñi konael Ngünechen ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Fey ti pu che, allkülu Jesus ñi femngechi feypin, ramtuy engün: —Feymew ¿iney anta pepi montuafuy? ");
INSERT INTO arnNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Fey Jesus llowdungufi ti pu che: —Che ñi pepilnoel, Ngünechen ta pepilniey. ");
INSERT INTO arnNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Fey feypieyew ta Pedro: —Ñidol, iñchiñ ta elkünuiñ kom taiñ niefel ruka mew, fey inawiyiñ. ");
INSERT INTO arnNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Fey Jesus llowdunguy: —Rüf dungu feypiwayiñ iney rume, Ngünechen ñi ülmen mülewe ñi duam, elkünule ñi ruka, kam ñi kure, ñi pu peñi, ñi chaw kam tañi fotüm, ");
INSERT INTO arnNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","feley tañi doy fentren llowtuael ñi duamtuel tüfachi mapu mew, fey ti kangelu we mületuachi mapu mew, lloway tati rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus wichu mütrümfi ñi mari epu disipulu, feymew feypifi: “Fewla amuaiñ ta Jerusalen, femngechi ta kom mupituay ñi wirintukuel tati pu pelon wentru, tati Wentrukünuwpalu ñi chumlerpuael. ");
INSERT INTO arnNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Fey kisu ta wültukungeay tati pu katripanche mew, ka ayetukangeay, lukatukangeay ka tofkütukangeay. ");
INSERT INTO arnNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wimakangeay ka langümngeay, welu küla antüalu mew wiñomongetuay.” ");
INSERT INTO arnNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Welu Jesus ñi pu disipulu pichi no rume longkontukulay tañi feypingeelchi dungu, fey elungenolu am ñi kimael engün ti dungu, feymew kisu engün pepi longkontukulay tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Feychi mülepulu Jesus Jeriko ñi inafül püle, kiñe trawma mülerkey ina rüpü petu ngillatulu limona. ");
INSERT INTO arnNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Allkülu ñi rupan fentren che, ramtuy chem dungu ñi mülen. ");
INSERT INTO arnNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Feymew feypingey ñi petu rupan tüye püle Jesus Nasaret tuwlu. ");
INSERT INTO arnNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Fey ti trawma wirarüy: —¡Jesus, David ñi reñma mew tripachi Dullin Yomelche, kutranpiwkeyeen ta iñche! ");
INSERT INTO arnNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Feytichi pu che wüne amulelu katrütudungueyew tañi wirarkümekenoael, welu kisu doyelchi wirarüy. —¡David ñi reñma mew tripachi Dullin Yomelche, kutranpiwkeyeen ta iñche! ");
INSERT INTO arnNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Feymew Jesus witralewey ka werküy ñi küpalngeael, feymew fülpalu kisu mew, Jesus ramtufi ti wentru: ");
INSERT INTO arnNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Chem anta ayüleymi tami fürenengeael? Fey ti trawma llowdunguy: —Ñidol, iñche ayülefun tañi pelotuael. ");
INSERT INTO arnNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Feymew Jesus feypifi ti trawma: —¡Wiñome pelotunge! Eymi tami maneluwün mew ta iñche mew, tremolngetuymi. ");
INSERT INTO arnNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Feychi lelen mew müten ti trawma pelotuy, fey inaniefi ta Jesus ka püramyeniefi ta Ngünechen. Fey kom ti pu che pefilu ñi rupan tüfachi dungu, ka femngechi püramyefingün ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus konpuy Jeriko mew, fey rumerpuy rangi ti waria mew. ");
INSERT INTO arnNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Üyew mülerkey kiñe riku wentru, Sakew pingelu. Longkolerkey tati pu kofrakelu impuestu ta Romangealu, ");
INSERT INTO arnNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","fey tüfa ayürkey ñi kimafiel ta Jesus, welu pepi leliwülürkelafi mülerkelu am rume fentren che ka femngechi ta Sakew laftra wentrungerkey. ");
INSERT INTO arnNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Feymew lefürkey wünelualu, tañi dipuafiel ka ñi peafiel, fey pürapuy kiñe anümka mew fülpüle chew ñi rumeael ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Feymew petu rumelu Jesus inafül ti anümka püle, pürakintueyew ka feypieyew: —Sakew, pürüm nagpatunge. Fachantü iñche witranngemean eymi tami ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Feymew Sakew pürüm nagpatuy, ka rume ayüwün mew llowfi ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Fey pengelu tüfa, kom eluwi ñi fillpiafiel engün ta Jesus, ka dunguyefi engün ñi amun mew tañi witranngemeael ti yafkafe wentru ñi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Feymew Sakew witrakünuwi ka feypifi ta Ñidol: —Allkütuen, Ñidol, iñche eluafiñ tati pu pofrengelu rangiñ kom tañi nieelchi chemkün: fey weñeñmakefili chem rume ineyngeay rume, wiñoleltuafiñ doy meli rupachi tañi weñeñmakefiel mew. ");
INSERT INTO arnNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Fey feypieyew ta Jesus: —Fachantü Ngünechen dew montulfi ta tüfachi rukache, fey tüfachi wentru ka femngechi Abraam ñi yomelchengey. ");
INSERT INTO arnNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Feymew tati Wentrukünuwpalu küpay tañi kintupayafiel ka tañi montulafiel tati ñamkülekefulu ñi yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Fey ti pu che allkütuley Jesus ñi feypimeken tüfachi dungu, fey kisu nütramelfi kiñe adkünu dungu kisu mew, fey Jesus am fülkülepurkelu dewma ta Jerusalen püle, feymew kisu engün rakiduamkülerkey ñi akuael pürümkachi Ngünechen ñi longko ülmenngen. ");
INSERT INTO arnNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Feymew nütramelfi tüfachi adkünu dungu: “Mülekefuy kiñe wentru longko ülmen küpalmengelu, fey tüfa amurkey alü kamapu, tati kangelu trokiñ mapu mew, femngechi tañi longko ülmenkünungeael ka ñi wiñometuael. ");
INSERT INTO arnNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Fey petu ñi amunon, mütrümfi ñi mari pu kona ñi nieel, fey eluyefi kake kiñeke engün fentren pülata, ka feypifi: ‘Neosiayafimün tüfachi pülata femngechi ñi doy yallael, fey wiñometuli wüla elumutuan’. Fey kisu amuy. ");
INSERT INTO arnNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Welu kisu ñi trokiñ mapu mew mülechi pu che rume üdeeyew, feymew ina werkülelngey kiñe mufü che tañi feypifalngeael: ‘Iñchiñ pilelaiñ tüfachi wentru ñi longko ülmenngeael iñchiñ mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Welu kisu longko ülmenkünungey, fey wiñometuy ñi trokiñ mapu mew. Fey dew akutulu, werküy ñi mütrümelngeael ñi pu kona tüfey engün tañi elurpufiel tati pülata, tañi kimael tunten ñi wewel kake kiñeke engün. ");
INSERT INTO arnNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Fey ti wentru wüne eluel ti pülata puwi ka feypipuy: ‘Ñidol, tami pülata mew wewün doy mari rupachi.’ ");
INSERT INTO arnNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Fey ti longko ülmen llowdungueyew: ‘Rume kümey tati, eymi ta rume küme kona. Eymi ta rüf mew müngeltuymi ti pichin dungu tami werküfiel, eymi ta longkoleaymi mari waria che mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Fey ka puwi ti kangelu ka feypi: ‘Ñidol, tami pülata mew wewün doy kechu rupachi.’ ");
INSERT INTO arnNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tüfa kafey llowdungufi: ‘Eymi ta longkoleaymi kechu waria che mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Welu kangelu ka puwi feypilen mew: ‘Ñidol, tüfa ñi mülen tami pülata. Kütrüngniekefuiñ kiñe pañu mew: ");
INSERT INTO arnNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Iñche llükaeyu ta eymi, eymi am rume yafü piwke wentrungelu. Nentukeymi chew tami küdawnoel mew, ka kosechakeymi chew tami ngannoel.’ ");
INSERT INTO arnNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Feymew ti longko ülmen feypieyew: ‘Wesa kona, kisu tami dungun mew dalluntukuwimi. Rakiduamfulmi eymi iñche ñi yafü piwke wentrungen ka tañi ñimituken chew tañi küdawnoel mew ka tañi kosechaken chew tañi ngannoel mew, ");
INSERT INTO arnNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿chumngelu am tukumelafimi ti pülata ta banku mew? Femngechi wiñoleltuafen ñi wewel ti pülata, akutulu iñche tañi ruka mew.’ ");
INSERT INTO arnNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Feymew ka feypifi tüfey mew mülechi pu che: ‘Müntuñmafimün ti pülata fey elufimün ti wewlu doy mari rupachi.’ ");
INSERT INTO arnNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kisu engün feypieyew: ‘Ñidol, ¡Welu kisu dew wewi doy mari rupachi!’ ");
INSERT INTO arnNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Fey ti longko ülmen llowdunguy: ‘Iñche ta feypiwayiñ, tati nielu doy elungeay. Welu tati nienolu, tañi pichin nieel, fey kütu ta müntuñmangeay. ");
INSERT INTO arnNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tañi pu kayñe tati pinofulu iñche tañi longko ülmenngeael kisu engün mew küpalfimün tüfa mew ka langümfimün iñche ñi adkiñ mew.’ ” ");
INSERT INTO arnNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Fey dew feypilu tüfa, trekakünuwi ta Jesus ñi amuael ta Jerusalen. ");
INSERT INTO arnNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Fey dew puwlu Betfage ka Betania mew, feyti Olifu pingechi wingkul ñi pülle mew, fey werküy epu ñi disipulu ");
INSERT INTO arnNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","feypilen mew: —Amuaymu ti pichi trokiñ ruka che mew mülelu tüyechi lelfün ñi itrotripa, fey puwülmu, pepuafimu kiñe trapelkülechi pichi furiku, fey tüfa iney rume petu püralaeyew, nentutrapelafimu, fey küpalafimu. ");
INSERT INTO arnNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Fey iney rume ramtuelmumew chumngelu tamu nentutrapelpefiel, feypiafimu ‘Ñidol duamtueyew tati’. ");
INSERT INTO arnNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Fey ti epu disipulu amuyngu ka pepufingu ti pichi furiku kom chumngechi ñi feypikünuetew ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Petu nentutrapelpefilu engu ti furiku, ti ngenngelu ramtueyew: —¿Chumngelu anta petu nentutrapelpefimu? ");
INSERT INTO arnNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kisu engu llowdunguy: —Ñidol duamtufi ti furiku. ");
INSERT INTO arnNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Fey ti furiku ñi furi mew wente chañupüramelfi engün ñi takuwün ta Jesus, fey ka pürakawelluy ti furiku mew. ");
INSERT INTO arnNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Fey amulelu Jesus, ti pu che inüfkünuyeyngün ñi takuwün ti rüpü mew. ");
INSERT INTO arnNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Fey fülpulu ti küllegngechi rüpü mew tati Olifu pingechi wingkul püle, kom tañi inanieetew eluwi ñi wirarael ayüwün mew ka ñi püramyeafiel ta Ngünechen kom ti afmatufal dungu ñi peel mew. ");
INSERT INTO arnNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Fey feypi engün: “¡Fütra küme felen niepe ti longko ülmen küpalelu Ñidol Ngünechen ñi piel mew! ¡Küme tüngün mülepe ta wenu mapu mew ka fütra pepiluwün mülepe ta wenu mew!” ");
INSERT INTO arnNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Feymew kiñeke ti pu farisew küpalelu ti pu che mew feypingün: —Kimeltufe, katrütudungufinge tami inanieetewchi pu che ñi wirarkümekenoael engün. ");
INSERT INTO arnNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Welu Jesus llowdungueyew: —Iñche feypiwayiñ tüfa engün dungunole, tati pu kura wiraray. ");
INSERT INTO arnNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Feymew puwlu Jerusalen ñi fül mew, fey pefilu tati waria mew mülechi pu che, Jesus ngümayefi ");
INSERT INTO arnNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","feypilen mew: “¡Ngüneduamfulmün, ta fachantü tamün eluafetew küme tüngün! Welu fewla tüfachi dungu ellkaley ta eymün mew, feymew ta pepi küme leliwül-lafimün. ");
INSERT INTO arnNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Küpaley ta wesake antü tamün kutrankawael, feychi tami pu kayñe wall püle dewmalelaeymünmew fütrake malal, fey walloñmayaeymünmew ka weychayaeymünmew ta wall püle. ");
INSERT INTO arnNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Fey ka apümkangeaymün ta itrokom eymün. Langümkangeay ti mülechi pu che ka elngelayay kiñe kura no rume tati küme elkülefulu, fey eymün am llownofilu ka manelnofilu ta Ngünechen, feychi küpalu ta Ngünechen tami montulafetew.” ");
INSERT INTO arnNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Fey dew rupalu tüfachi dungu, Jesus konpuy ti ngillatuwe ruka mew, fey eluwi ñi wemünentuafiel tüye mew tati fendemekelu ka ngillakamekelu ñi chemkün ta pülata mew. ");
INSERT INTO arnNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ka femngechi feypifi: “Tati Wirin Chillka mew feypiley: ‘Iñche ñi ruka ta ngillatuwe ruka pingey, welu eymün ta kiñe weñefe ñi ruka reke niefimün.’ ” ");
INSERT INTO arnNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Fey Jesus kimeltukerkey ti ngillatuwe ruka mew, fey ti longkolelu tati pu saserdote mew ka ti kimeltukelu ta Moyse ñi ley dungu ka ti longkolelu ti waria mew miyawürkey ñi kintukaduamaetew engün chumngechi ñi langümafuel engün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Welu pepil-lay engün ñi chumngechikünuael tañi ayüfel engün ñi femaelchi dungu, fey kom ti pu che am kuñiwtun mew küme allkütulelu Jesus ñi kimeltumekeelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kiñe antü mülelu Jesus ti ngillatuwe ruka mew, kimeltumekefi ti pu che ka wewpimekey ti werkün montun dungu, fey akuyey tati longkolelu ti pu saserdote mew ka ti kimeltukelu ta Moyse ñi ley dungu, kiñentrür miyawi ti putremke wentru engün. ");
INSERT INTO arnNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Fey feypifi engün ta Jesus: —¿Iney anta werküeymew tami femael tüfachi dungu? ¿Iney anta elueymew tüfachi awtoridad? ");
INSERT INTO arnNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Fey llowdungueyew ta Jesus: —Iñche kay ta ramtuwayiñ kiñe dungu. Llowdungumuchi. ");
INSERT INTO arnNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Iney werküeyew ta Juan ti Fawtisachefe tañi fawtisacheael, Ngünechen pemay kam tati pu che? ");
INSERT INTO arnNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kisu engün eluwi ñi fillpiwael welukonkechi: “Fey llowdungufiliyiñ Ngünechen ñi werküetew, fey tüfa ramtuay: ¿chumngelu am taiñ feyentunofiel? ");
INSERT INTO arnNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ka femngechi ngelay taiñ feypiael ti pu che ñi werküetew. Fey tati pu che langümafeiñmew re ütrüftukan kura mew, kom kimnielu engün am Juan tañi dungukefel Ngünechen ñi üy mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Feymew llowdunguy engün ñi kimnon iney ñi werküetew ta Juan tañi fawtisacheael. ");
INSERT INTO arnNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Fey Jesus llowdungueyew: —Iñche ka feypiwlayayiñ iney ñi werküetew ñi femael tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Fey ka pürüm eluwi Jesus ñi dunguafiel tati pu che, fey nütramelfi tüfachi adkünu dungu: “Kiñe wentru anümürkey fentren ofad, ka amediakünulelfi kiñe mufü küdawfe, fey kisu eluwi ñi amuael kañpüle. ");
INSERT INTO arnNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Fey puwlu ñi kosechangeael ti ofad, werküy ñi kona ñi yelngepayael ti fün ofad ñi koneltunieel, welu kisu engün wülelfingün ka wemütufi fey pichin no rume elulafingün. ");
INSERT INTO arnNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Feymew ti ngenngelu ka werküy ñi kangelu kona, welu tüfa lukatufi ka wülelkafingün, fey ka wemünentufingün fey ñi elunofiel chem no rume. ");
INSERT INTO arnNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ka wiñome werküngey ta kangelu, welu ti pu küdawfe tüfa ka femngechi allfülkafingün, fey wemünentufi wekuntu ti ofadentu. ");
INSERT INTO arnNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Afduamlu ti ngen mapu feypi: ‘¿Chumafun chey? Werküan may ñi sakin fotüm. Tüfa yamafingün tati.’ ");
INSERT INTO arnNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Welu ti pu küdawfe peetew, fey welukonkechi feypiwingün: ‘Tüfa tati ngenngetualu langümafiyiñ, femngechi tati ofadentu mapu iñchiñngetuay.’ ");
INSERT INTO arnNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Feymew nentufingün wekuntu ti ofadentu mapu mew, fey langümfingün. “¿Chumaetew ti ngen ofadentu trokifimün kay? ");
INSERT INTO arnNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Fey küpayay langümpayafi tüfeychi pu küdawfe, fey feytichi ofadentu eluafi ta kakelu küdawfe.” Fey allkülu engün tüfachi dungu, feypi: —¡Tüfeychi dungu chumkawnorume femkilpe! ");
INSERT INTO arnNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Welu Jesus küme leliwülfi ti pu che ka feypifi: —Fey ¿chem pin am tüfa ñi feypilen mew ta Wirin Chillka? ‘Tati pu dewmarukakelu illamtufi ti kura, welu tüfa ta dullin kurangetuy.’ ");
INSERT INTO arnNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Fey iney rume wente trananagpuwle ti kura mew, rume watrokaway. Welu feytichi kura iney rume trañmafile küme rüngümkünuafi. ");
INSERT INTO arnNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Fey ti pu longkolelu pu saserdote mew ka ti pu kimeltukelu ta ley dungu ayürkefuyngün ñi püresuafiel ta Jesus, feychi lelen mew müten, kimlu am kisu engün ñi piñmaltulelngen ti adkünu dungu. Welu llükanierkefingün tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Fey werküfingün kiñeke che ñi ellka ngünenmayaetew, fey nor piwke che reke puwi engün. Fey ñi ngoymakechi welulkalafiel engün ta Jesus chem dungu rume feypile, femngechi adngell tañi wültukuafiel tati gobernador mew. ");
INSERT INTO arnNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tüfa engün ramtueyew: —Kimeltufe, iñchiñ ta kimnieiñ eymi tami feypikeel ka tami kimeltukeel ñi küme nor dungungen ka tami manelkenofiel tati re küme piwkefaluwkechi che. Eymi ta kimelkeymi chumngechi ñi tutengeael ta Ngünechen ta mongen mew. ");
INSERT INTO arnNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Kümey am taiñ kulliafiel impuestu tati Roma tuwchi emperador kam taiñ kullinoafiel? ");
INSERT INTO arnNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Fey Jesus ngüneduamfilu ñi nien engün kiñe wesa koyla ngünen dungu, feypifi ti pu che: ");
INSERT INTO arnNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Pengelelmuchi kiñe denario pingechi moneda. ¿Iney am ñi ange adentuley ka iney ñi üy wirintukuley tüfa mew? Fey llowdunguy engün: —Tati emperador. ");
INSERT INTO arnNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Fey Jesus feypifi ti pu che: —Fey eluafimün may tati emperador, tañi koneltuleel tati emperador, fey femngechi eluafimün ta Ngünechen tañi koneltuleel ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Fey kom tañi chem piel ta Jesus, tati pu che ñi adkiñ mew ngelay tañi welulkawün ñi dungun mew femngechi allmalltuafulu engün tañi püresuafiel, fey rume afmatulewey engün kisu ñi llowdungun mew, feymew dunguwetulayngün. ");
INSERT INTO arnNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Fey ngünekünulu kiñeke ti pu sadusew amuyngün tañi pemeafiel ta Jesus, fey ti pu sadusew feyentukelay ñi wiñomongetuael ti dew lalu, feymew ramtupufingün tüfachi dungu: ");
INSERT INTO arnNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Kimeltufe, Moyse ta elkünuleleiñmew ñi wirin dungu femngechi ta kiñe kurengechi wentru lale, fey nienole kiñe fotüm no rume ñi domo mew, fey ti lalu ñi peñi müley ñi kureyetuafiel ti lantu domo femngechi tañi fotümelafiel ñi lachi peñi. ");
INSERT INTO arnNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Fey mülekerkefuy kiñe rupa regle peñiwen. Fey kiñe ti wentru wüne kurengey, welu lay fey ñi elnon kiñe fotüm no rume. ");
INSERT INTO arnNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Fey ti inankülelu ka femi. ");
INSERT INTO arnNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ka ti küla mew inankülechi wentru kureyefi ti domo ka femngechi femi ti kakelu reke, fey kom ti regle wentru layey engün, fey ñi elkünurpunon kiñe yall no rume. ");
INSERT INTO arnNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Fey afpulu mew ka femngechi lay ti domo. ");
INSERT INTO arnNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Fey am wiñomongetule ti pu la ¿chuchi am kureyetuafi ti domo, fey ti regle am kom kureyefulu ti domo? ");
INSERT INTO arnNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus llowdungueyew: —Tüfachi mapu mew ti pu wentru ka ti pu domo kureyewkey engün. ");
INSERT INTO arnNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Welu ti fürenengelu ñi puwael ta wenu mapu mew ka wiñomongetule, wentrungeay rume ka domo rume, doy ngewelayay ta kureyewün. ");
INSERT INTO arnNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tüfa engün am doy lawenoalu. Femngechi tati pu werken püllü reke feletuay engün. Ka femngechi ta Ngünechen ñi yallngeayngün tañi wiñomongetuael mew. ");
INSERT INTO arnNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kuyfi mew Moyse pefilu ti üykülechi kütral sarsa mew, feymew feypi: ‘Ñidol, Abraam, Isaak ka Jakob ñi Ngünechen.’ Moyse ñi femngechi feypin mew kimfali tati pu la ñi wiñomongetuael, ");
INSERT INTO arnNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","fey ¡Ngünechen am tati pu la ñi Ngünechen no, welu ti pu mongelelu ñi Ngünechen may, fey Ngünechen mew am kom che ta mongelelu! ");
INSERT INTO arnNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Fey kiñeke ti kimeltukelu Moyse ñi ley dungu feypifi ta Jesus: —Küme pimi tati kimeltufe. ");
INSERT INTO arnNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Femngechi ta yamwefingün tañi doy ramtuweafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Feymew Jesus ramtufi ti pu che: —¿Chumngelu am feypingekey tati Cristo David ñi yomelchengen? ");
INSERT INTO arnNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Fey David kütu feypi, ti Salmo lifru mew: ‘Fey Ñidol Ngünechen feypifi tañi Ñidol: Anüpange iñche ñi man ad püle. ");
INSERT INTO arnNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Femngechi iñche elkünulelaeyu tami pu kayñe kiñe pünotuwe reke miñche tami namun.’ ");
INSERT INTO arnNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Fey chumngechi am ti Cristo David ñi tuwünngey, fey David am iñche ñi Ñidol pifilu tati Cristo? ");
INSERT INTO arnNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Fey kom ti pu che allkütulerkey, fey Jesus feypifi ñi pu disipulu: ");
INSERT INTO arnNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kuñiwtukuwmün fey ti pu kimeltukelu mew ta Moyse ñi ley dungu. Tüfa engün ta ayükey ñi tukuael ti alükechi takuwün ka ayükey ñi chalingeael fentren yamün mew tati pülasa mew. Ka kintukey engün doy kümeke wangku ta sinagoga mew, ka chew müley doy kümeke iyael ti mesa mew. ");
INSERT INTO arnNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ka müntuñmakefingün ñi ruka ti pu lantu domo, welu lif mongen che ñi pingeael rume fentreñma ngillatukawkey engün. Kisu engün ta doy fütra kutrankaway.” ");
INSERT INTO arnNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus lelinierkefi ti pu riku ñi tukumeken pülata ti pichi kakon mew chew ñi elngekemum tati ofrenda. ");
INSERT INTO arnNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Welu ka femngechi perkefi kiñe pofre lantu domo ñi tukumeken epu pichike kofre moneda. ");
INSERT INTO arnNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Feymew feypi: —Rüf dungu feypiwayiñ tüfachi pofre lantu domo doy fentre wülüy itrokom ti kakelu pu che mew. ");
INSERT INTO arnNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Fey itrokom am wülpelu ti ofrenda tañi sofranentunieel müten, welu kisu, tañi rume pofrengefel, kom wülkünuy tañi nieñmufel tañi mongeluwam. ");
INSERT INTO arnNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Fey kiñekentu nütramyemekefi ti ngillatuwe ruka ti rume adyechi kura ñi nieel mew ka ti ofrenda mew ñi adelkaniengeel. Feymew Jesus feypi: ");
INSERT INTO arnNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Küpaley ta antü fey itrokom tüfa eymün tamün petu leliwülpeel, ngewelayay kiñe kura no rume welu rentrolealu. Kom ta teyfükangeay. ");
INSERT INTO arnNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Feymew ramtungey: —Kimeltufe, ¿tuntepu mew am müleay tüfachi dungu? ¿Chem wele dungu am müleay ñi kimngeam ñi epe puwkülen ñi rupayael kom tüfachi dungu? ");
INSERT INTO arnNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Fey llowdungueyew ta Jesus: “Kuñiwtukuwküleaymün tamün ngünenkangenoael. Rume fentren küpayalu am tati feypialu: ‘Iñche ta Cristo. Fewla puwküley dewma ti antü.’ Welu eymün inakefilmün. ");
INSERT INTO arnNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Feychi allkülmün ñi mülen ti awkan dungu ka welukonke kewatuay tati pu che, llükakilmün, fey kom tüfa mülelu am ñi wüne rupayael, welu femllele rume petu akulayay ti afachi antü.” ");
INSERT INTO arnNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Fey amuley ñi feypilen: “Kiñe trokiñ lof che weychamekeway kangelu trokiñ lof che engu ka kiñe trokiñ mapu mew mülechi pu che weychayay ti kangelu trokiñ mapu mew mülechi pu che engu. ");
INSERT INTO arnNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Müleay ta fütrake nüyün, ngüñün ka ti kutran fill mapu püle, ka wenu mapu mew pengeay llükanngechi dungu ka fütrake wele dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Welu petu ñi femnon tüfa eymün ta püresungeaymün ka inantukuyawülngeaymün tamün kayñetungen. Yengeaymün tamün ramtukangeael ta sinagoga mew, ka püresuntukungeaymün ta karsel mew ka puwülngeaymün ti longko ülmen mew ka ti pu gobernador mew iñche ñi duam. ");
INSERT INTO arnNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Femngechi ta feleay tamün pepi nütramyemuafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Welu wüne rakiduamkilmün tamün chem piael kisutu tamün ingkawael. ");
INSERT INTO arnNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Iñche ta eluwayiñ fentren kimün chumngechi tamün dunguael, femngechi ta kiñe rume tami pu kayñe notukadungulayaeymünmew ka chem pilayaeymünmew rume. ");
INSERT INTO arnNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Welu tamün chaw kütu ta ellka wültukuaeymünmew. Tami pu peñi, tami pu reñma ka tami pu weni ka femay. Ka kiñekentu eymün langümngeaymün. ");
INSERT INTO arnNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Fey itrokom che mülelu mapu mew üdeaeymünmew iñche ñi duam, ");
INSERT INTO arnNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","welu kiñe tamün kal longko no rume ta ñamlayay. ");
INSERT INTO arnNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","¡Afeluwkilnge tami maneluwküleael iñche mew, femngechi ta peaymün montun! ");
INSERT INTO arnNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Feychi pefilmün ta Jerusalen walloñmalelu ti trokiñ soltaw mew, kimaymün pürümka müten ñi apümkangeael. ");
INSERT INTO arnNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Feymew tati pu che mülelu Judea mew, lefmawpe engün ti fütrake wingkul püle. Fey ti pu che mülelu Jerusalen mew, tripape engün ti waria mew, ka tati mülelu lelfün mew, wiñokontukilpe waria mew. ");
INSERT INTO arnNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Feychi antü am kutrankawün antüngealu, fey ta famngechi müley ñi mupiael kom chumngechi ñi feypilen ti Wirin Chillka. ");
INSERT INTO arnNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Awngey tati pu domo niepüñeñkülelu tüyechi antü mew kam niele moyol püñeñ rume! Rume mülealu am fentren kutrankawün ti trokiñ mapu mew, ka fütra kutrankangeay tüfeychi waria mew mülechi pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Fey kiñekentu layay chüngarkangele ta wayki mew, fey kakelu püresukona reke yengeay itrokom trokiñ mapu mew fey ti pu judiu tuwünngenolu wilukonpuay ka fill wesa dungu femay ta Jerusalen waria mew, fey puwle wüla ti tripantu tañi fentepu legtukünulngeel. ");
INSERT INTO arnNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Müleay ta wele dungu antü mew, tati küyen mew, ka ti pu wangülen mew fey kom mapu mew ti trokiñke mapu pewelayay ñi chumael engün ka rume llükayayngün tañi fütra rarakümeken mew ti rew lafken. ");
INSERT INTO arnNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Fey ti pu che rupaduammekeay engün fente ñi llükan mew kimle engün ñi rupayael tüfachi dungu itrokom mapu mew. Tati wenu mapu müleyechi pepiluwün kütu yafyafay ñi fente llükan. ");
INSERT INTO arnNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Feymew pengeay tati Wentrukünuwpalu küpalelu kiñe tromü mew ka fütra pepiluwün mew ka fütra pelon mew. ");
INSERT INTO arnNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Feychi mew llitule ñi rupayael tüfachi dungu, yafüluwmün ka newentuwmün, fülkülepalu am tamün montulngeael.” ");
INSERT INTO arnNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Fey ka femngechi nütramelfi kiñe trürümkünu dungu: “Ngüneduamfimün tati igera kam chem kangelu anümkangeay rume. ");
INSERT INTO arnNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Femngechi pefiyüm ñi choyotun ta tapül anümka kimkeymün ta eymün tañi fülkülepan dewma ta walüngantüngen. ");
INSERT INTO arnNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ka famngechi müten, feychi pefilmün ñi rupan tüfachi wele dungu, kimaymün tañi fülkülepan ta Ngünechen ñi longko ülmenngepayael. ");
INSERT INTO arnNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Rüf dungun mew feypiwayiñ kom tüfachi dungu rupayay petu ñi lanon tüfachi pu che mülelu fantepu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ti wenu mapu ka nag mapu afllefule rume, welu iñche ñi dungu kom müleay ñi mupiael. ");
INSERT INTO arnNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Welu kuñiwtukuwküleaymün ka elukefilmün tamün piwke ñi kurawael reke ka ñi konael ti wesake wimtun mew, ti putun dungu mew no rume ka tamün rume küdaweluwkülenoael tüfachi mongen mew femngechi ta tüyechi antü ñi akunoael kiñe lloftun dungu reke eymün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ka kiñe sochan dungu reke ñi femnoael. Fey tüfachi dungu am küpayalu kom tüfeychi müleyelu mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eymün ta pewütuwküleaymün, fill antü ngillatulekeaymün, femngechi tamün montuael kom tati küpalechi dungu mew ka femngechi tamün küme llowaetew tati Wentrukünuwpalu.” ");
INSERT INTO arnNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Fey fill antü Jesus kimeltukerkey ta ngillatuwe ruka mew, fey pun müleputukey tati Olifu pingechi wingkul mew. ");
INSERT INTO arnNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Fey kom ti pu che amukey puliwen ti ngillatuwe ruka mew ñi allkütuñmayafiel ñi dungu ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Fülküleparkey dewma ti kawiñ antü tañi ingekemum ti lefawrangenochi kofke, tati Paskua kawiñ ürke. ");
INSERT INTO arnNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Feyti pu longkolelu pu saserdote mew ka ti kimeltukelu ta Moyse ñi ley dungu, tüfa engün llükanierkefi tati pu che, fey dunguñmamekefi engün ta Jesus chumngechi ñi langümafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Feymew weküfü konürkey ta Juda mew, kiñe ti mari epu disipulu, tati Iskariote pikeel. ");
INSERT INTO arnNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Fey tüfa amurkey ñi pemeafiel ti longkolelu pu saserdote mew ka ti pu kellulekelu ti ngillatuwe ruka mew, fey nütramelpufi chumngechi tañi wültukulelafiel engün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kisu engün rume ayüwürkey ka feypifi engün ñi kulliafiel pülata ta Juda. ");
INSERT INTO arnNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Fey Juda ayüwmafi ñi llowafiel ti pülata ka eluwi ñi kintuael ti doy küme lelen ñi mülenoael kakelu pu che femngechi ñi ellka wültukuafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Fey akuy ti kawiñ antü tañi ingekemum ti lefawrangenochi kofke ka femngechi tañi langümngeael ti korderu ta Paskuangealu. ");
INSERT INTO arnNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus werküfi ta Pedro ka Juan, fey feypifi: —Amuaymu tamu pepikameael ti Paskua iyael. ");
INSERT INTO arnNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Fey kisu engu ramtueyew: —¿Chew püle anta ayüleymi tayu pepikameafiel tati Paskua iyael? ");
INSERT INTO arnNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Fey Jesus feypi: —Eymu petu konpulmu ta Jerusalen waria mew, trenumapuafimu ta kiñe wentru yenietulu kiñe metawe ko. Fey inayafimu. Konputule wüla ti ruka mew, ");
INSERT INTO arnNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","fey feypiafimu ti ngen ruka: ‘Ti kimeltufe ta ramtufali: ¿Chuchi anta ti katrüntukulechi ruka chew tañi iyam ti Paskua iyael tañi pu disipulu iñchiñ?’ ");
INSERT INTO arnNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Fey kisu ta pengelelaeymumew kiñe wenu ruka mew ti alü tuwchi katrüntuku dew küme elkülelu. Tüye mew pepikapuaymu taiñ iyam ti pun iyael. ");
INSERT INTO arnNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Feymew amuy kisu engu ka pepuyngu kom chumngechi tañi feypiel ta Jesus, fey pepikapuyngu ti Paskua pun iyael. ");
INSERT INTO arnNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Fey puwlu ti ora, ñi iyam engün Jesus ka ti pu apostol anüpuy engün ti mesa mew. ");
INSERT INTO arnNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Feymew Jesus feypifi ñi pu disipulu: —¡Rume ayüleken ñi iyafiel tati Paskua iyael eymün iñchiñ petu tañi lanon! ");
INSERT INTO arnNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Iñche ta feypiwayiñ ka wiñome kiñentrür iwelayan eymün iñchiñ, fey puwle wüla ñi femtuael Ngünechen ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Feymew nüfi ñi kuwü mew ti kopa, fey dew mañumtufilu ta Ngünechen, feypi: —Putufimün tüfachi pulku ka welukonkechi eluwmün. ");
INSERT INTO arnNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Iñche feypiwayiñ tañi wiñome putuwenoafiel tati ofad pulku, fey mületuliyiñ wüla Ngünechen ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Feymew ka nüfi ti kofke ñi kuwü mew, fey dew mañumtufilu Ngünechen, wükafi ti kofke, fey eluyefi ñi pu disipulu feypilen mew: —Tüfa ta iñche ñi kuerpu, wültukuael tañi layael eymün tamün fürenengeael. Femkeaymün ta tüfa iñche tamün tukulpamuafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ka femngechi femi ti kopa mew, dew ifilu ti iyael, feypilen mew: —Tüfachi kopa ti we eldungu tati, legtripaley iñche ñi mollfüñ mew, tüfa ta wütrulael eymün tamün fürenengeael. ");
INSERT INTO arnNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Welu tati wentru tañi ellka wültukuaetew müley tüfachi mesa mew. ");
INSERT INTO arnNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Femngechi tati Wentrukünuwpalu fente küme amuley ti rüpü mew tañi legtukünulngeel, welu ¡awngeay tañi ellka wültukuaetew! ");
INSERT INTO arnNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Feymew eluwi ñi welukonkechi ramtuwael ineyngen tüfey tañi wültukuaetew. ");
INSERT INTO arnNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Fey ti pu disipulu mekerkey ñi notukadunguwün engün iney müngell tañi longkoletuael kisu engün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Feymew Jesus feypifi ñi pu disipulu: “Feytichi pu judiu tuwünngenochi pu che ñi pu longko ülmen rume ngenkawkey ñi pu konayenieelchi pu che mew, ka ti pu che longkolelu kisutu feypiwkey: ‘iñchiñ rume küme dungu femkeiñ.’ ");
INSERT INTO arnNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Welu eymün ngelay chumkawnorume tamün femngechi femael. Fey tamün femafel, ti doy wünenkülelu eymün mew müley ñi doy illamuwküleael ka inankülelu reke ñi feleael, ka tüfeychi werkülekelu müley ñi doy illamuwküleael tati poyechekelu reke ñi feleael. ");
INSERT INTO arnNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Femngechi llemay: ¿Iney anta doy wünenngey tati anülelu mesa mew tañi iyael kam tati poyechepelu? ¿Feyngey llemay tati anülelu ta mesa mew ñi ülmenngen? ¿Welu ngüneduamaymün tunte wünenkülen rume ta iñche fey eymün mew mülen tati poyechekelu reke? ");
INSERT INTO arnNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Eymün ta kompañkiyawülmuken ta iñche tamün yafülmuafiel ñi kutrankawün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Feymew eluwayiñ iñche tañi ülmen mülewe, chumngechi ta iñche tañi Chaw ta eluenew ka femngechi ");
INSERT INTO arnNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","eymün ta iyaymün ka putuaymün iñche ñi mesa mew chew tañi longko ülmenngeel ta iñche, ka femngechi ta anüaymün ti ülmen ruka mew, tamün kues reke müleael tati mari epu Israel trokiñche mew.” ");
INSERT INTO arnNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ka femngechi ta Ñidol feypifi ta Pedro: —Simon, Simon, allkütunge. Weküfü ta ngillatupefuy eymün tamün chiñükayaetew kachilla reke. ");
INSERT INTO arnNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Welu iñche ta llellipupefiñ ta Ngünechen eymi mew, femngechi tañi afnoael tami mupiltun iñche mew. Fey eymi, dew wiñotulmi ta iñche mew, kelluafimi tami pu peñi tañi newentuleael engün. ");
INSERT INTO arnNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Fey Simon llowdunguy: ");
INSERT INTO arnNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Ñidol, iñche ta dew eluwkülen tañi amuael ta karsel mew tunte layan rume eymi iñchiw. Feymew Jesus feypifi ta Simon: —Pedro, iñche ta feypiaeyu fachantü müten, petu ñi kakaranon ta alka küla rupa, ‘kimlafiñ’ piaymi. ");
INSERT INTO arnNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Fey Jesus pürüm ramtufi ñi pu disipulu: —Feychi mew nga werküwiyiñ tamün yenoael folson, ka pülata no rume, ka okota no rume ¿duamtuymün kay kiñeke chemkün fey pelaymün? Fey llowdungueyew ñi pu disipulu: —Chem no rume duamtulaiñ. ");
INSERT INTO arnNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Feymew Jesus feypi: —Welu ta fewla, tati nielu ti folson, müley ñi yeael tati pülata. Fey ti nienolu wayki, fendepe ñi makuñ, fey ngillape kiñe wayki. ");
INSERT INTO arnNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iñche ta feypiwayiñ müley ñi mupiael chumngechi feypiley ta iñche mew tati Wirin Chillka: ‘Fey kisu rakintukungey ti wesake che mew.’ Kom tati Wirin Chillka ñi feypileel iñche mew, müley tañi kom mupiael. ");
INSERT INTO arnNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Fey kisu engün feypi: —Ñidol tüfa mew müley epu wayki. Fey Jesus llowdunguy: —Fey ka müten tati. ");
INSERT INTO arnNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Feymew Jesus pürüm tripay, fey kisu am wimtulelu ñi femken, fey amuy ti Olifu pingechi wingkul mew, fey ñi pu disipulu inaeyew. ");
INSERT INTO arnNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Fey puwlu ti lelfün mew, Jesus feypifi ñi pu disipulu: —Ngillatumün, femngechi tamün wewnoaetew tati kintukaduamchekelu. ");
INSERT INTO arnNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Fey pürüm püntütripay kisu engün mew tunte puwkey kiñe ütrüfkünuelchi kura fente mapu eluwpuy, ka lukutupuy ñi ngillatuael. ");
INSERT INTO arnNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Feymew feypi: “Chaw, pifulmi kay, montulafen tüfachi fütra kutrankawün mew. Felekilpe iñche kisu ñi ayüel, welu may eymi tami ayüel.” ");
INSERT INTO arnNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Feymew pewfaluweyew kiñe wenu mapu werken püllü, tañi yafültukuaetew. ");
INSERT INTO arnNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Fey rangi ti fütra kutrankawün mew, Jesus doy fütra yafüluwün mew mekey ñi ngillatun fey ñi arofün wütrunagmekey pülli mew lüykünagchi mollfüñ reke. ");
INSERT INTO arnNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Fey dew ngillatulu, witrapüratuy, fey amutuy chew ñi mülemum ñi pu disipulu, fey pepatufi ñi umawkülen. Weweyew engün ñi weñangkün. ");
INSERT INTO arnNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Fey feypipatufi: —¿Chumngelu anta umawküleymün? Witrapüramün ka ngillatumün, femngechi ta wewlayaeymünmew tati kintukaduamchekelu. ");
INSERT INTO arnNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Petu mekelu ñi nütramkan ta Jesus, fey akuy rume fentren che. Feymew Juda tüfa ta kiñe ti mari epu disipulu ürke, wüneluwkülepay ti kakelu pu che mew. Tüfa fülkonpay ñi chaliafiel kiñe truyun mew ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Welu Jesus feypieyew: —Juda, ¿kiñe truyun chalin mew ngünenmayafimi tati Wentrukünuwpalu? ");
INSERT INTO arnNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Fey ti pu disipulu müleyelu Jesus engün, pefilu ñi femngechi rupan tüfachi dungu, ramtuyngün: —Ñidol ¿wülelfiyiñ wayki mew? ");
INSERT INTO arnNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Fey kiñe ta kisu engün mew miyawlu, katrünentuñmafi ñi man pilun ti longkolechi saserdote ñi kona. ");
INSERT INTO arnNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Feymew Jesus feypifi ñi pu disipulu: —Fentekünumün. Fey ka müten. Fey pürüm nüñmafi ñi pilun ti kona, ka tremoltufi. ");
INSERT INTO arnNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ka pürüm feypifi ti pu longkolelu pu saserdote mew, ka ti kellukelu ti ngillatuwe ruka mew ka ti putremke wentru, kom tüfa engün küpayelu ñi püresuaetew: —¿Chem dungu mew anta küpaymün ta eymün ka küpalnieymün ti wayki ka mamüll? ¿Kiñe malochefe trokimun anta iñche? ");
INSERT INTO arnNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Fill antü ta müleken eymün iñchiñ ti ngillatuwe ruka mew, fey püresumukelafun. Welu tüfa puwi tamün femael tati dumiñ ngüneluwün. ");
INSERT INTO arnNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Feymew püresungey ta Jesus ka yengey ti longkolelu ti pu saserdote ñi ruka mew. Pedro inalerkey pichi alü kamapu. ");
INSERT INTO arnNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Puwlu engün, kütraltupuy ti lepün mew ka wallo anükünuwingün. Pedro ka anükünuwpuy kisu engün ñi fül püle. ");
INSERT INTO arnNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Fey tüfa mew, kiñe üllchadomo peetew ñi anülen ti ina kütral, leliwüleyew ka feypieyew: —Tüfa ka mülepefuy Jesus engu. ");
INSERT INTO arnNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Welu Pedro: —Kimlafiñ tati. Iñche no ngati, papay ―pirkey. ");
INSERT INTO arnNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Fey ka pichin mew, kangelu peeyew ka feypieyew: —Eymi ka miyawkeymi Jesus eymu. Fey Pedro llowdunguy: —Weni, iñche no tati. ");
INSERT INTO arnNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Fey kiñe ora rupalu mew, kangelu ka feypieyew: —Rüf feyngey ñi miyawken tüfachi wentru Jesus engu. Ka femngechi Galilea tuwi tati. ");
INSERT INTO arnNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Feymew Pedro feypi: —Weni, kimlan tami chem pifel. Feychi lelen mew müten, Pedro petu dungumekelu, kakaray kiñe alka. ");
INSERT INTO arnNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Feymew Ñidol wiñokintuy ka leliwülfi ta Pedro, fey Pedro tukulpay tañi feypietew ta Ñidol: “Fachantü petu ñi kakaranon ta alka, küla rupa ‘kimlafiñ’ piaymi.” ");
INSERT INTO arnNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Feymew Pedro tripay wekuntu, fey rume fütra ngümakawi. ");
INSERT INTO arnNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Feytichi pu wentru ngüneduamniefilu ta Jesus ayentuniefi ka wülelkamekefingün. ");
INSERT INTO arnNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ka munulkünuñmangey ñi nge ka ramtukangey: —¡Konewtufinge iney anta wülelpeeymew! ");
INSERT INTO arnNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ka femngechi lukatuniengey ka feypiniengey itrofill wesake dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Fey küme wünlu dewma, trawüluwi engün ti putrem fütake judiu, ka fey ti longkolelu pu saserdote mew ka ti kimeltukelu ta Moyse ñi ley dungu, fey yengey ta Jesus chew trawüluwküley ti fütake judiu wentru. Tüyew ramtukangey: ");
INSERT INTO arnNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Feypimuiñ, ¿eymi am tati Cristo, Ngünechen tañi werküel? Fey llowdungueyew ta kisu: —‘Feyngey tati’ piwliyiñ, eymün feyentumulayan. ");
INSERT INTO arnNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ka iñche ramtuwliyiñ, ka llowdungumulayan rume. ");
INSERT INTO arnNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Welu fewla dew puwküley tati Wentrukünuwpalu tañi müleputuael tati fütra pepiluwünngechi Ngünechen ñi man kuwü reke. ");
INSERT INTO arnNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Feymew kom ti pu che pürüm ramtufi ta Jesus: —Fey, ¿eymi anta Ngünechen ñi Fotüm? Feymew llowdungueyew ta Jesus: —Eymün ta kisu feypimün iñche ta Ngünechen ñi Fotümngen. ");
INSERT INTO arnNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Feymew kisu engün feypi: —¿Ka chem dungu am duamtuiñ taiñ kelluntukungeael? Iñchiñ kisuke allküñmafiyiñ ñi piel, kisu ñi wün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Fey itrokom witratripay engün tañi yeafiel ta Jesus Pilato mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Fey Pilato mew eluwi ñi dalluntukuafiel engün, feypilen mew: —Iñchiñ pekefiyiñ tüfachi wentru ñi kimeltuken re wesake dungu taiñ müngeltunoafiel tati pu awtoridad mülelu taiñ trokiñ mapu mew. Feypikeeiñmew taiñ kullinoafiel impuestu tati emperador, fey ka femngechi feypikey ta kisu ñi Cristongen, ti longko ülmen. ");
INSERT INTO arnNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Fey Pilato ramtufi ta Jesus: —¿Eymi am tati pu judiu ñi longko ülmen? —Eymi ta kisu feypimi iñche ñi longko ülmenngen ―llowdunguy ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Feymew Pilato feypifi ti pu longkolelu tati pu saserdote mew ka ti pu che: —Iñche peñmalafiñ chem yafkan rume ta tüfachi wentru. ");
INSERT INTO arnNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Welu kisu engün amul feypiley doy newentu dungun mew: —Kisu ñi kimeltuelchi dungu mew pofolkafi tati pu che. Llituy Galilea mapu mew, fewla amuley ñi femün faw Judea mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Fey allkülu tüfachi dungu ta Pilato, ramtuy feyti wentru ñi tuwün pemay ta Galilea. ");
INSERT INTO arnNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Fey feypingelu ñi Galilea tuwün, Pilato werküfi Jesus ta Erode mew, kisu am gobernadorkülelu ta Galilea mapu mew, fey tiyechi antü miyawürkey Jerusalen mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Feymew Erode pefilu ta Jesus, rume ayüwduamürkey, fey kuyfitu dewma ayükerkefuy ñi peafiel, kisu am allkükelu ñi nütramyengen ta Jesus, feymew üngümkülekerkey ñi pengelelaetew kiñe afmatufal dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Rume fentren dungu ramtukarkefi, welu Jesus llowdungurkelaeyew kiñe ramtun dungu no rume. ");
INSERT INTO arnNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ka femngechi mülerkey üye mew tati pu longkolelu ti pu saserdote mew, ka ti pu kimeltukelu ta Moyse ñi ley dungu, fey tüfa engün doyelchi dalluntukumekefi engün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Feymew Erode ka ñi pu soltaw rume illamtufi ta Jesus, fey tañi ayentungeael tukulelngey ti llümllümchi takuwün femngechi tañi kiñe longko ülmen reke ñi feleael. Feymew Erode ka pürüm wiñome werküy ñi yengetuael Jesus Pilato mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilato engu ta Erode kayñetuniewkerkefuy, welu tüyechi antü mew wenikawturkey tüfachi epu ülmen wentru. ");
INSERT INTO arnNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato trawülürkefi tati longkolelu pu saserdote mew ka ti pu awtoridad ka tati trokiñche. ");
INSERT INTO arnNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Fey feypifi: —Eymün ta küpalelmun tüfachi wentru, ka feypimun tañi pofolkafiel tati waria mew mülechi pu che ka ñi kayñetuafiel ti pu awtoridad, welu iñche ta ramtukafiñ eymün tamün adkiñ mew, fey peñmalafiñ chem welulkan rume ka chem yafkan no rume tamün dalluntukupefiel mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erode ka wiñome werküleltuenew. Feymew kimfali tañi femnon chem wesa dungu no rume fey ngünam ñi langümpürayafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Iñche ta wimakafalafiñ, fey wüla neykümfaltuafiñ. ");
INSERT INTO arnNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Fey ti kawiñ mew, Pilato tañi tuteafiel ti pu che nentukünutukerkey karsel mew kiñe püresu. ");
INSERT INTO arnNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Welu kom ti pu che kiñentrür eluwi ñi wirarün engün: —¡Langümngepe tüfa! ¡Fey lifrekünutungepe ta Barabas! ");
INSERT INTO arnNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Fey Barabas ta püresulerkey ti karsel mew ñi pofolkafiel mew ti pu che tañi müngeltunoafiel ti pu awtoridad, ka tañi langümchen mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Welu Pilato ayürkefuy ñi lifrenentutuafiel ta Jesus, fey ka wiñome dungungerkey engün, ");
INSERT INTO arnNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","welu kisu engün doy newentu wirarüy: —¡Langümngepe ta kürus mew! ¡Langümngepe ta kürus mew! ");
INSERT INTO arnNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Fey Pilato küla rupachi feypifi ti pu che: —Iñche peñmalafiñ tüfachi wentru chem wesa femün no rume, femngechi ngünam ñi langümngeael. Iñche ta wimakafalafiñ, fey wüla neykümkünutuafiñ. ");
INSERT INTO arnNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Welu kisu engün ingentu doy wirarüy, “langümngepe ta kürus mew” pileyngün. Fey fente wirarkümekelu engün am, fey elungey ñi femael kisu engün ñi ayüel. ");
INSERT INTO arnNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Feymew Pilato wültukufi tañi langümngeael ta Jesus chumngechi ñi ayüel ti pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Feymew lifrekünungetuy ta Barabas kisu ñi dulliel engün, tati püresulekefulu ta karsel mew tañi wesa femelchi dungu mew ka ñi langümchen mew, fey wültukufi ta Jesus ñi langümngeael. ");
INSERT INTO arnNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Feymew yefilu engün ta Jesus ñi langümngemeael, fey trenumafi engün kiñe wentru Simon pingelu, Sirene tuwlu. Dew wiñomelu lelfün mew, fey aporia meñkukünulelfingün tati kürus tañi ina trekaleael ta Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Rume fentren che ka rume fentren domo inaniefi ta Jesus. Ina wirarküley ñi ngüman engün fente ñi weñangkülen Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Welu Jesus adkintueyew engün, fey feypieyew: —Jerusalen tuwchi pu domo, ngümakilmün iñche mew. Eymün may kisutu ngümayewmün ka tamün pu püñeñ mew, ");
INSERT INTO arnNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","küpalelu am ta antü ñi feypingeael tüfachi dungu: ‘Sakinngeay tati niepüñeñkenochi domo ka ti moyolpüñeñkenochi moyo.’ ");
INSERT INTO arnNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Feymew ti pu che feypiafi tati fütrake külleg: ‘¡Tranarupamün iñchiñ taiñ wente mew!’ Ka ti pu wingkul: ‘¡Ellkantukumuiñ!’ ");
INSERT INTO arnNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Fey kom tüfachi dungu femle engün iñche mew ti karü mamüll reke felelu, welu ¿chumay engün chey eymün mew tati angken mamüll reke felelu? ");
INSERT INTO arnNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ka yeniengerkey ta epu wentru rume wesa mongenngelu ñi langümngeael kiñentrür ta Jesus engün. ");
INSERT INTO arnNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Feymew puwlu engün ti lelfün mew, Foro Longko (Kalafera) pingelu, Jesus wente elkünungey ti kürus mew ka ti epu wesa mongenngechi wentru, kiñe Jesus ñi man püle elngey kangelu wele püle. ");
INSERT INTO arnNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Feymew Jesus feypi: “Chaw, lelituñmakefilnge ñi yafkan ta tüfa engün. Kimlay engün tañi femmeken.” Fey ti pu soltaw suertiafi Jesus ñi tukukeelchi takuwün femngechi tañi nüafiel chuchi rume ta kisu engün legtu tripale. ");
INSERT INTO arnNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Fey ti pu che adkintulepuyngün ka ti pu awtoridad ayentukaniefi engün ta Jesus, feypilen mew: —Ti kakelu pu che montulfi, welu fewla kisutu montuluwpe rüf mew Ngünechen ñi Cristongele ka kisu ti Dullinngele. ");
INSERT INTO arnNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Fey ti pu soltaw kafey ayentukaniefi ta Jesus, fey fülkontufi engün ñi eluafiel ti kümenochi wesa kotrü pulku, ");
INSERT INTO arnNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","feypilen mew: —Tati pu judiu ñi longko ülmenngelmi, eymi kisutu montuluwnge. ");
INSERT INTO arnNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ka mülerkey Jesus ñi wente longko püle kiñe letreru feypilelu griegu, latin ka ebrewdungun mew: ");
INSERT INTO arnNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Fey kiñe ti wentru, yafkafe mongenngelu külafantukulelu ka pültrülelu kürus mew, lukatuniefi ta Jesus: —Eymi ta Cristongelmi, kisutu montuluwnge ka iñchiw montulmuyu. ");
INSERT INTO arnNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Welu ti kangelu lladkütudungufi ñi kompañ, feypilen mew: —¿Eymi llükanielafimi anta Ngünechen? Ka femngechi kutrankawün mew feleymi. ");
INSERT INTO arnNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Iñchiw ta kutrankamekengeyu rüf dungu mew femngechi tayu kullituael ti wesake dungu tayu femkeel mew, welu tüfachi wentru chem wesa dungu no rume femlay. ");
INSERT INTO arnNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ka femngechi feypi: —Jesus, tukulpayaen ta iñche, longko ülmenkületulmi. ");
INSERT INTO arnNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Feymew llowdungueyew ta Jesus: —Rüf dungu feypieyu. Fachantü müten müleputuayu eymi iñchiw tati küme rumel mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Fey dew rangiantülu, küla ora rupachi antü mew dumiñmarkey ta kom mapu. ");
INSERT INTO arnNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Fey ti antü dumiñnagi ka ti rünge kortina ngillatuwe ruka mew mülelu rangi wichafnagi. ");
INSERT INTO arnNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Feymew Jesus newentu wirari ka feypi: —Chaw, eymi mew chalintukuan tañi püllü. Fey dew feypilu, aftukuy ñi neyen. ");
INSERT INTO arnNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Fey ti Roma tuwchi kapitan, pefilu ñi femngechi rupan feytichi dungu, püramyefi ta Ngünechen feypilen mew: —Rüf dungu mew tüfachi wentru chem yafkan rume nierkelafuy. ");
INSERT INTO arnNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Fey kom ti pu che trawüluwkülepulu tüye mew, pefilu engün ñi femngechi rupan kom tüfachi dungu, wiñomeyngün küfüngkanierpatuy ñi rüku ñi weñangkün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Welu Jesus ñi kimelchi pu che ka ti pu domo tañi inapaetew Galilea mapu mew, mülewey engün tüye mew, adkintuniefi engün alü kamapu kom tüyechi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mülerkey kiñe küme piwkengechi wentru ka nor mongenngelu, Jose pingelu. Arimatea tuwünche, kiñe waria tati mülelu ta Judea mapu mew. Fey kisu koneltulerkey ti longkolechi pu judiu ñi trawün mew. ");
INSERT INTO arnNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jose maneluwkülerkey Ngünechen ñi werküaelchi longko ülmenngealu mew. Fey kisu newe küme duamürkelay ñi rakiduam mew tañi femün mew ti longkolechi pu judiu. ");
INSERT INTO arnNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Fey amuy ñi dungumeafiel ta Pilato tañi “elutuen Jesus ñi kuerpu” ñi piafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Rupan nagümtufilu ta kürus mew, fey iwüdüfi kiñe lif küme safana mew ka tukukünumefi kiñe we rüngan lolo mew, tati chengke kura mew mülelu, chew petu rüngalngekelay kiñe la no rume. ");
INSERT INTO arnNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Feychi ta pepikawün antü ürke tañi üngümngekeel tati ürkütun antü, fey tüfachi antü epe llitulerkey dewma. ");
INSERT INTO arnNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Fey ti pu domo küpalu Jesus engün tuwlu Galilea mapu mew, fey amuyngün ka pemefingün ti rüngan lolo ka inaduammefingün chumngechi ñi tukukünumengen tati kuerpu. ");
INSERT INTO arnNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Fey akutulu engün ñi ruka mew, dewmapatuy ti perfume ka ti poma. Fey ti pu domo kansatuy engün tati ürkütun antü mew, chumngechi feypiley ta Ngünechen ñi werkün dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Welu ti wüne llituelchi antü semana mew, Jesus ñi inakefetewchi pu domo amuy epe wün ti rüngan lolo mew ka yeniey engün ñi dewmaelchi perfume. ");
INSERT INTO arnNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Fey puwlu engün, pepufi ñi kiñe püle tripaletun ti kura takuniefulu ti rüngan lolo, ");
INSERT INTO arnNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","feymew konpuyngün, welu pepulafi engün ta Ñidol Jesus ñi kuerpu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Fey rume llükapuy engün fey ñi kimnon ñi chumael, feymew pürümka reke pefemi engün epu wentru witralelu kisu engün ñi inafül püle, fey rume lingari ñi takuwün engu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Fey rume llükalen lloyünagi ñi longko engün ta pülli mew, welu kiñe ti epu wentru feypieyew: —¿Chumngelu anta kintupapefimün ti pu la mew feytichi mongelelu? ");
INSERT INTO arnNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","¡Ngelay tati tüfa mew! ¡Dew wiñomongetuy! Tukulpamün tamün feypietew petu mülelu ta Galilea trokiñ mapu mew: ");
INSERT INTO arnNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Tati Wentrukünuwpalu felerkey ñi chalintukungeael ti pu yafkafe mew ka ñi langümngeael ta kürus mew, welu küla antüalu mew ñi wiñomongetuael.’ ");
INSERT INTO arnNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Feymew kisu engün tukulpatuy Jesus ñi dew feypifel tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Fey wiñopalu engün ti rüngan lolo mew, nütramelpatufi kom tüfachi dungu ti mari kiñe pu apostol, ka femngechi itrokom ti kakelu pu che. ");
INSERT INTO arnNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tati amuyelu ñi kimelafiel tüfachi dungu ti pu apostol, tüfa engün ürke: Maria Magdala waria tuwlu, Juana ka Maria, Santiaw ñi ñuke, ka ti kakelu pu domo. ");
INSERT INTO arnNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Welu ti pu apostol re wedwedka dungupelu trokifi engün tati pu domo. Feymew eluwlayngün ñi feyentuafiel. ");
INSERT INTO arnNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Welu Pedro femngen ñi duam, re lefkülen amuy ti rüngan lolo mew, fey konkintupuy ponwitu, pefi ti safana müten, feymew wiñotuy ruka mew fill rakiduamkülen ñi pefiel mew feytichi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Fey tüyechi antü mew müten, epu disipulu amulelu tati waria Emaw pingelu, mari kiñe kilometro tripalerkey ta Jerusalen waria mew ");
INSERT INTO arnNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","nütramkalen amuleyngu tañi femngechi rupael kom feytichi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Petu notuka nütramkawkülen amuley engu, fey Jesus ürke fülkonpay kisu engu mew. Feymew külangen kiñentrür trekalen amuleyngün. ");
INSERT INTO arnNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Welu tunte pefuyngu rume allwe ñüwiduamlu reke femi ñi nge engu, feymew ngüneduamlafingu ñi ineyngen. ");
INSERT INTO arnNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesus ramtueyew engu: —¿Chem dungu anta nütramkapeymu petu tamu trekalepan rüpü mew? Feymew witrakünuwingu, fey rume weñangkülen ");
INSERT INTO arnNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","llowdunguy tati disipulu Kleofa pingelu: —¿Welu eymi umañpelafuymi Jerusalen waria mew, fey kimlaymi am tati rupachi dungu? ");
INSERT INTO arnNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Fey Jesus ramtueyew engu: —¿Chem dungu anta rupay? Fey feypingey: —Jesus Nasaret tuwlu, kiñe pelon wentru rume pepiluwünngefuy ñi femael chem dungu rume ka rume adümuwi ñi kimeltuael Ngünechen ñi adkiñ mew ka itrokom che ñi adkiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Feyti longkolelu ti pu saserdote mew ka ti pu longkolelu taiñ mapu mew wültukufingün ta Jesus tañi püresungeael ka ñi langümngeael, fey langümngey kürus mew. ");
INSERT INTO arnNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Iñchiñ maneluwkülefuiñ kisu mew tañi montulafiel ta Israel trokiñche, welu küla antü amuletuy dewma ñi rupamum kom tüfeychi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Welu kiñeke ti pu domo mülelu iñchiñ engün mew pellkelkaeiñmew, amulu kisu engün epe wün ti rüngan lolo mew. ");
INSERT INTO arnNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Fey pepunofilu engün am ti kuerpu, wiñotuy engün ta ruka mew. Fey ka nütramelpatueiñmew ñi pemen epu werken püllü, fey engu feypirkeeyew Jesus ñi mongeletun. ");
INSERT INTO arnNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Feymew kiñeke taiñ pu weni amuyngün ti rüngan lolo mew, fey pepuyngün kom chumngechi tañi feypipatuel ti pu domo, welu pelafi engün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Feymew Jesus llowdungueyew engu: —Longkontukukelaymu ka rume küdawtukuymu tamu feyentuael kom tañi wirintukuel tati Wirin Chillka mew tati pu pelon wentru. ");
INSERT INTO arnNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Felerkelafuy am tañi kutrankawael tati Cristo kom tüfachi dungu fey petu ñi llownon ta kom pepiluwün? ");
INSERT INTO arnNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Fey pürümka müten eluwi ñi kimeltuafiel kom ti troy dungu wirilelu ta Wirin Chillka mew dungulelu ta kisu mew. Llituy Moyse ñi wirintukuelchi dungu mew ka ñi feypilen kom ñi wiriel ti pu pelon wentru ñi lifru mew. ");
INSERT INTO arnNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Fey fülpulu ti waria mew chew ñi amulemum engün, Jesus kañpüle amualu reke femi. ");
INSERT INTO arnNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Welu kisu engu aporiafi ñi mülewenagael feypilen mew: —Müleweiñ kiñentrür tüfa mew. Dew putrafiay, ka epe dumiñi tatey. Feymew Jesus konpuy ñi müleweael tüfey mew. ");
INSERT INTO arnNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Fey dew anülelu engün inafül ti mesa mew, fey nüfi ti kofke ñi kuwü mew ka mañumtufi ta Ngünechen, wükafi ka elufi engu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Feymew wüla kimtufingu ñi Jesusngen, we nülalu ñi nge reke femingu, welu Jesus ñamfemtuy. ");
INSERT INTO arnNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Feymew welukonkechi feypiwingu: —¿Feyngelay ama ñi rume ayüwkülepen tayu piwke petu nütramkalen küpalepeiñ nga tati rüpü mew, ka kimeltupeyumew tati wirikonkülechi dungu ti Wirin Chillka mew? ");
INSERT INTO arnNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Feymew müten witrapüratuyngu ka trekakünuwpatuyngu rüpü mew ñi wiñotuael ta Jerusalen, fey pepatufingu ñi trawüluwkülen ti mari kiñe apostol ka ñi pu kompañ, fey tüfa famngechi feypipatufi engu: ");
INSERT INTO arnNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—Rüf feyngey tañi wiñomongetun ta Ñidol. Dew pewfaluwfi ta Simon. ");
INSERT INTO arnNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Feymew kisu engu nütramelpatufi chumngechi ñi trenumafiel ta Jesus trekalelu engu rüpü mew ka femngechi ñi kimtufiel engu petu wükapefilu ti kofke. ");
INSERT INTO arnNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Petu mekelu ñi nütramkan engün tüfachi dungu, feychi lelen mew müten Jesus witralerumey kisu engün ñi rangiñ mew ka chalipuy feypilen mew: —Küme tüngün ta niemün. ");
INSERT INTO arnNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kisu engün rume llükay. Kiñe perimon püllü pewfaluwetew trokiwi engün. ");
INSERT INTO arnNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Welu Jesus feypifi ñi pu disipulu: —¿Chumngelu anta llükaymün? ¿Chem mew anta welulkawküley tamün rakiduam? ");
INSERT INTO arnNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Malüñmamuchi tañi kuwü ka tañi namun. Iñche tatey. Kiñe perimon püllü nielay ta kuerpu ka foro no rume, welu eymün peymün iñche tañi nien kuerpu ka foro. ");
INSERT INTO arnNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Fey femngechi feypifilu, malüñmangey ñi kuwü ka tañi namun. ");
INSERT INTO arnNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Welu kisu engün feyentulayngün reke tañi rume ayüwün mew ka ñi afmatulewen mew engün, feymew Jesus ramtufi ñi pu disipulu: —¿Nieymün kay tüfa mew pichin iyael? ");
INSERT INTO arnNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Elungey kiñe katrün kangkan challwa, ");
INSERT INTO arnNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","fey kisu llowi ka ifi fey ñi penieetew kisu engün. ");
INSERT INTO arnNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Feymew pürüm ka feypifi ti pu disipulu: —Iñche tañi femngechi rupaelchi dungu mew, fey iñche wüne kimeleluwiyiñ petu mülelu iñche eymün iñchiñ, felerkelu am ñi mupiael kom ti wirikonkülechi dungu iñche mew Moyse ñi ley dungu mew ka ti pu pelon wentru ñi wirielchi dungu mew ka ti pu Salmo lifru mew. ");
INSERT INTO arnNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Feymew fente küme kellufi ñi adümael engün ti wirintukulechi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Feymew Jesus feypifi ñi pu disipulu: —Wirintukuley ñi layael tati Cristo ka ñi wiñomongetuael küla antüalu mew. ");
INSERT INTO arnNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ka kisu ñi üy mew ñi llituael engün ñi wewpiael Jerusalen mew, müley ñi kimelngeael kom mapu mülechi che tañi wiñorakiduamtuael engün ta Ngünechen mew, femngechi ñi wiñoduamangetuael engün ñi yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Eymün müley tamün feypiael kom tamün allküel ka tamün peelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Fey iñche werküan eymün mew iñche ñi Chaw ñi tukulpakünuelchi Küme Püllü. Welu eymün mülewemün tüfa mew Jerusalen waria mew, llowülmün wüla ti pepiluwün nagpayalu ta wenu mapu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Feymew Jesus “amuiñ wekuntu waria Betania püle” pifi ñi pu disipulu. Fey dew chalitufilu, witrañpürami ñi epu kuwü, fey ngillatuñmafi ñi küme feleael engün. ");
INSERT INTO arnNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Fey petu ngillatuñmafilu, püntütripay kisu engün mew, fey yengetuy wenu mapu. ");
INSERT INTO arnNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Fey kisu engün püramyefi ngillatun mew ta Jesus, fey rume ayüwkülen wiñotuyngün ta Jerusalen. ");
INSERT INTO arnNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Fey trawüluwkülekerkey engün ti ngillatuwe ruka mew ka püramyeniekefi engün ta Ngünechen. Felepe may.");
INSERT INTO arnNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","We llitualu mew dew mülewiyekey tati Dungun, fey tati Dungun mülekey Ngünechen engu, fey kisu ta Ngünechen ürke. ");
INSERT INTO arnNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kisu ta dew mülekerkey Ngünechen engu, petu ñi dewmangenon chem no rume. ");
INSERT INTO arnNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kisu mew Ngünechen dewmay itrokom tati mülelu. Chem no rume tati mülelu, dewmangelay kisu tañi adkünunoel. ");
INSERT INTO arnNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kisu mew müley ta mongen, fey kisu ñi mongen pengeli ti rüf dungu kiñe pelon reke kom chengealu. ");
INSERT INTO arnNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tüfachi pelon alofküley tati dumiñ mew, fey tati dumiñ pepi wewlaeyew. ");
INSERT INTO arnNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mülerkey kiñe wentru Juan tati Fawtisachefe pingelu, tüfeychi wentru ta Ngünechen ñi werküel ");
INSERT INTO arnNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","femngechi tañi kimelael Jesucristo tañi rüfngechi pelonngen, fey femngechi itrokom che tañi feyentuael Jesucristo mew. ");
INSERT INTO arnNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan ta pelon ürke no, welu may tati werküel fey ñi nütramyeafiel tati che pelon reke felelu. ");
INSERT INTO arnNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Fey wüla tati rüfngechi pelon tati pelontuniefilu itrokom che küpay tüfachi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tati Dungun mülerkey ta mapu mew, fey kisu mew dewmangey itrokom tati mülelu, welu kimlaeyew tüfachi mapu mew mülechi pu che. ");
INSERT INTO arnNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kisu akuy ñi pu che mew, welu ñi pu che llowlaeyew, ");
INSERT INTO arnNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","welu tüfeychi pu che tañi llowetew ka feyentulu kisu mew, elufi ñi yallyetuaetew ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Fey Ngünechen ñi yallngetuy engün, tañi küme tuwünchengen mew no, ka che ñi ayüel mew no rume, welu may Ngünechen tañi piel mew. ");
INSERT INTO arnNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tüyechi Dungun Wentrukünuwpay tañi mülepayael iñchiñ mew, rume piwkeyen mew ka rüf dungu mew. Peñmafiyiñ Ngünechen ñi eluetewchi fütra pepiluwün kisu am kiñenngelu ñi femngen tañi Chaw engu. ");
INSERT INTO arnNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Fey Juan tati Fawtisachefe nütramyefi ta Jesucristo, feypilen mew: “Fey tüfa lle iñche tañi tukulpakeel: iñche mew inalepay kiñe wentru, fey ta doy pepiluwünngey ta iñche mew, kisu am wünenkülelu iñche mew” pi. ");
INSERT INTO arnNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ka femngechi Jesucristo ñi fütra pepiluwün mew, kom llowiyiñ küme felen. ");
INSERT INTO arnNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ka femngechi Moyse mew llowiyiñ tati ley dungu, welu Jesucristo mew llowiyiñ tati rüf piwkeyen ka femngechi Ngünechen ñi rüf dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Iney no rume pekelafi ta Ngünechen, welu Jesucristo, Ngünechen ñi kiñen Fotüm, tati rüf Ngünechen, pekefi ta Ngünechen, fey kisu am kiñewkülelu ta Chaw engu, fey kisu ta elueiñmew taiñ kimafiel ñi chumngen ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kiñeke pu judiu tuwlu Jerusalen werküfingün kiñeke tati pu saserdote ka kiñeke Levi ñi tuwünche ñi amuael Juan ti Fawtisachefe mew tañi ramtumeafiel ñi chem tuwünchengen. ");
INSERT INTO arnNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Fey kisu küme feypi nor dungun mew: —Iñche Cristo no tati. ");
INSERT INTO arnNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ka wiñome ramtufingün: —¿Iney müngell ürke anta eymi? ¿Tati pelon wentru Elia? Fey Juan feypi: —Fey no ta iñche. Kisu engün diküm ramtufi ta Juan: —Fey ¿eymi am tati küpayachi pelon wentru ürke? Fey Juan llowdunguy: —Fey no ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Fey feypifi engün: —¿Iney müngell ürke anta eymi? Müley taiñ feypiputuael chumngechi tami llowdungun taiñ pu werküetew mew. ¿Iney pingen pilerkeymi am? ");
INSERT INTO arnNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Fey Juan llowdungueyew: —Iñche ta kiñe newentu dunguyawlu ti uwe mapu mew: ‘Kiñe nor küme rüpü reke feletupe tamün rakiduam, femngechi tamün llowafiel ta Ñidol’ chumngechi ñi wirikünuel tati pelon wentru Isaia. ");
INSERT INTO arnNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tati pu farisew tañi werküelchi pu wentru ñi dungumeafiel engün ta Juan ");
INSERT INTO arnNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ramtuy: —Fey eymi ta Cristongenolmi, ka Eliangenolmi no rume ka kiñe pelon wentrungenolmi rume, ¿fey chumael am fawtisachekeymi? ");
INSERT INTO arnNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Fey Juan llowdungueyew: —Iñche fawtisacheken ta ko mew, welu eymün tamün rangiñ mew müley kiñe eymün tamün kimnienoel. ");
INSERT INTO arnNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Fey inalepay ta iñche mew. Iñche fente tañi yamniefiel mew ta kisu, nentupüroñmalayafuiñ rume tañi koriwen okota. ");
INSERT INTO arnNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kom tüfachi dungu rupay ta Betania pingechi waria püle, tati nome Jordan lewfü, chew ñi fawtisachemekemum ta Juan. ");
INSERT INTO arnNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Fey kangelu antü mew, Juan ti Fawtisachefe pefi ta Jesus, petu fülpulu ta kisu mew, fey feypi: “¡Leliwülfimün, fey tüfachi wentru ta Ngünechen ñi Korderu, tati montulafilu kom mapu mülechi pu che tañi yafkan mew! ");
INSERT INTO arnNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jesus ta nütramyefiñ iñche feychi feypilu: ‘Inalepay ta iñche mew kiñe tati doy pepiluwlu iñche mew, fey Jesus am wüne mülekelu iñche mew.’ ");
INSERT INTO arnNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Fey iñche kimkelafuiñ ñi ineyngen. Welu iñche ta fawtisacheken ta ko mew, femngechi tati Israel trokiñche tañi kimafiel ta Jesus” pi. ");
INSERT INTO arnNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan ti Fawtisachefe ta küme kimeli tüfachi dungu, feypilu: “Pefiñ tati Lif Küme Püllü nagpalu wenu mapu kiñe palluma reke, fey akuy ta Jesus mew, ");
INSERT INTO arnNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","fey iñche petu kimkelafuiñ ta Jesus, welu tañi werküetew ñi fawtisacheael ko mew fey ta feypienew: ‘Tüyechi wentru mew pefilmi ñi nagpan ka ñi akun kisu mew ti Lif Küme Püllü, tüfeychi wentru tati fawtisachealu ta Lif Küme Püllü mew.’ ");
INSERT INTO arnNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Iñche ta dew pefiñ, ka kimnien, fey Jesus ta Ngünechen ñi Fotümngen.” ");
INSERT INTO arnNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kangelu antü mew, Juan tati Fawtisachefe ka mülerkey üye mew ka epu ñi pu kompañ. ");
INSERT INTO arnNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Feymew pefilu ñi rupan ta Jesus, Juan feypi: —¡Leliwülfimün, tüyechi wentru ta Ngünechen ñi Korderu reke feley! ");
INSERT INTO arnNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Fey Juan ñi epu kompañ allküy engu ñi feypin ta Juan, feymew inafi engu ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus wiñokintueyew, fey pengelu engu ñi inalen, Jesus ramtueyew: —¿Chumngelu anta inaniemupan? Kisu engu feypi: —Kimeltufe ¿chew am müley tami ruka? ");
INSERT INTO arnNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesus llowdungueyew: —Amuiñ. Pengeleluwayiñ. Fey amuyngu ka pepufingu chew ñi mülemum, fey mülewepuy engu ti nagantü mew, fey dew meli ora nagwiyerkey ta antü. ");
INSERT INTO arnNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Fey kiñe tati epu allküfilu ta Juan, feyti inafilu ta Jesus Andre ürke, Simon Pedro ñi peñi. ");
INSERT INTO arnNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andre wünelu mew amuy yemealu ñi peñi Simon, fey feypifi: —Pepefiyu tati Mesia (tati Cristo ürke). ");
INSERT INTO arnNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Fey Andre pürümka müten yefi ta Simon chew ñi mülemum ta Jesus, feymew Jesus peetew, feypieyew: —Eymi ta Simon, Juan tañi fotüm, welu Sefa pingetuaymi (Pedro pin tati, fey tüfa “kura” pin ürke). ");
INSERT INTO arnNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kangelu antü mew, Jesus eluwi ñi amuael ta Galilea trokiñ mapu mew. Pefilu ta Felipe, fey feypifi: —Inaen. ");
INSERT INTO arnNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fey Felipe ta Betsayda waria tuwünche ürke, chew ñi tuwmum ta Andre ka Pedro. ");
INSERT INTO arnNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Feymew Felipe amuy ñi yemeafiel ta Natanael, fey feypifi: —Pefiñ ta tüyechi wentru, Moyse ñi tukulpael ñi wirielchi dungu mew, ka ti pu pelon wentru ñi chillka mew. Tüfachi wentru ta Jesus pingey, Jose tañi tremümel Nasaret tuwlu ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Fey Natanael feypi: —¿Chem küme dungu am tripayafuy Nasaret waria mew? Fey Felipe llowdungufi ta Natanael: —Küpange, fey küme kimafimi tati wentru. ");
INSERT INTO arnNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Feymew Jesus, pefilu ñi petu fülpan ta Natanael kisu mew, feypi: —Tüfey ñi küpalen kiñe rüfngechi israelche. Kisu mew ta ngelay chem koyla ngünen no rume. ");
INSERT INTO arnNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Fey Natanael ramtufi ta Jesus: —¿Chumngechi anta kimen? Feymew llowdungueyew ta Jesus: —Peeyu ka kimeyu petu tami mütrümnoetew ta Felipe, eymi mülelu miñche igera. ");
INSERT INTO arnNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Fey Natanael feypifi ta Jesus: —Kimeltufe, ¡eymi ta rüf mew Ngünechen ñi Fotüm! ¡Eymi ta israelche ñi longko ülmen! ");
INSERT INTO arnNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Fey llowdungueyew ta Jesus: —¿Feyentuymi am iñche mew tami feypifiel mew ‘iñche peeyu petu mülelu eymi miñche igera’? Doy fütrake dungu may peaymi fey tüfa famngelu. ");
INSERT INTO arnNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Feymew Jesus ka femngechi feypi: —Rüf dungu feypiwayiñ eymün ta peaymün fütrake afmatufal dungu nülalelu reke ta wenu mapu, fey Ngünechen ñi pu werken püllü ñi pürameketun ka ñi nagmekepan, tati Wentrukünuwpalu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Fey küla antüalu, mülerkey kiñe mafün ta Kana waria mew, Galilea trokiñ mapu mew. Jesus ñi ñuke mülerkey tüye mew. ");
INSERT INTO arnNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Fey Jesus ka ñi pu disipulu mangelngelu am engün ti mafün mew, feymew ka mülepuy engün tüfey mew. ");
INSERT INTO arnNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Fey ti longkokünungelu mafün mew afürkey ñi pulku, fey Jesus, ñi ñuke feypieyew: —Niewelay ta pulku engün. ");
INSERT INTO arnNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus ta llowdungufi ñi ñuke: —¿Chumngelu anta femngechi feypien? Petu puwlafuy tañi femael afmanngechi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Fey Maria, Jesus tañi ñuke, feypifi tati pu che poyechepelu: —Femaymün kom tañi piel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tiye mew mülerkey kayu fütrake kura meñkuwe, nieam ta ko ñi pünekeel ti pu judiu ñi liftuwtuam. Ti kake kiñeke fütrake kura meñkuwe mew konkerkey kechu mari kam kayu mari litru ko. ");
INSERT INTO arnNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus feypifi tati pu poyechepelu: —Apolfimün ko mew tüfachi pu kura meñkuwe. Fey fente küme apolfingün. ");
INSERT INTO arnNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Fey Jesus feypi: —Fey wiñome nentutumün pichin ko, fey yelelfimün tati longkokünungelu mafün mew. Fey femngechi femingün. ");
INSERT INTO arnNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Fey ti longkokünungelu mafün mew wüne pütokofi ti ko pulkuwkületulu, fey ñi kimnon rume chew ñi nentungen. Fey ti pu poyechepelu müten kimnieyngün, kisu engün am nentufilu ti ko kura meñkuwe mew. Feymew ti longkokünungelu mafün mew mütrümfi ti nofio, ");
INSERT INTO arnNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","fey feypifi: —Kom che ta wüne wülkey tati doy küme pulku, feymew dew aseleweyüm wüla ti pu mangel, wülngekey ti kangelu newe kümenochi pulku. Welu eymi ta ellka nieperkeymi ti doy küme pulku inangechi putuael wüla. ");
INSERT INTO arnNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Fey tüfachi dungu femi ta Jesus Kana waria mew, Galilea trokiñ mapu mew. Tüfa ñi wüne femelchi afmatufal dungu, tañi kimngeael ta Jesus ka ñi nien fütra pepiluwün. Fey ñi pu disipulu feyentuy engün kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Fey dew rupalu tüfachi dungu, amutuy ta Kapernaum waria mew. Kompañeyew tañi ñuke, ñi pu peñi ka ñi pu disipulu, fey tüye mew mülewepuy engün kiñe mufün antü. ");
INSERT INTO arnNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Feymew Jesus ka amuy ta Jerusalen petu fülpalu am dewma tati pu judiu ñi Paskua pingechi kawiñ antü. ");
INSERT INTO arnNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Fey Jesus puwlu, pepufi ti ngillatuwe ruka mew ti fendemekelu mansun, ufisa ka palluma ka ti anüleyechi pu che trafkintupülatamekelu. ");
INSERT INTO arnNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Fey Jesus pefilu ti pu che, nüy kiñeke katrün def, fey dewmay kiñe refengke, fey wemünentufi itrokom che ti ngillatuwe ruka mew kiñentrür ñi pu ufisa ka ñi mansun engün. Ka ti trafkintupülatamekelu widpünagümüñmafi ñi pülata ka ütrüfrulpañmafi ñi mesa. ");
INSERT INTO arnNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Fey Jesus feypifi ti pu fendekelu palluma: —¡Tüfa nentutufimün faw! ¡Kiñe merkaw reke nielayafimün iñche ñi Chaw ñi ruka! ");
INSERT INTO arnNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Feymew kisu ñi pu disipulu tukulpay engün ti Wirin Chillka mew feypilechi dungu: “Apümkaenew tañi fente lladken tami ruka ñi duam.” ");
INSERT INTO arnNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Feyti longkolechi pu judiu ramtueyew: —¿Chem kimfal dungu anta pengelelmuaiñ fey tami nien ta awtoridad tami femael ta tüfachi dungu? ");
INSERT INTO arnNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus llowdungufi ti pu judiu: —Teyfükafimün tüfachi ngillatuwe ruka, fey iñche küla antü mew wiñome dewmatuafiñ ―pirkey. ");
INSERT INTO arnNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Fey ti longkolechi pu judiu feypieyew: —Meli mari kayu tripantu küdawtungey ñi dewmangeael tüfachi ngillatuwe ruka. ¿Fey eymi küla antü mew müten dewmatuafimi? ");
INSERT INTO arnNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Welu ti ngillatuwe ruka Jesus tañi feypiel, kisu ñi kuerpu ürke tañi feypifiel. ");
INSERT INTO arnNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Feymew, wiñomongetulu ta Jesus kisu ñi pu disipulu tukulpayngün tüfey tañi feypiel ta Jesus, fey feyentuy engün tati Wirin Chillka ñi feypiel mew ka femngechi Jesus ñi dungun mew. ");
INSERT INTO arnNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesus petu mülelu ta Jerusalen tati Paskua kawiñ mew, rume fentren che feyentuy kisu mew, pefilu engün am ti afmatufal dungu ñi femel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Welu Jesus newe duamkünulafi tüfeychi pu che, fey kimnieñmafilu am ñi rakiduam ta itrokom che. ");
INSERT INTO arnNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ka femngechi duamtunielay chem dungu no rume ñi feypingeael, fey kisu am kimnieñmafilu ñi rakiduam tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mülerkey kiñe farisew Nikodemo pingelu, kiñe füta üytun wentru ürke ti pu judiu mew, koneltulelu ti pu longkolelu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tüfa amurkey pun ñi witrankontumeafiel ta Jesus, fey feypifi: —Kimeltufe, kimnieiñ Ngünechen tami werküetew taiñ kimeltumuafiel, fey chem che no rume femlayafuy tati afmatufal dungu eymi tami femkeel, mülenole ta Ngünechen ta tüfeychi che mew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus feypieyew: —Rüf dungu feypiaeyu kiñe che we choyüngetunole, pepi konpulayay ta Ngünechen ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Fey Nikodemo ramtufi ta Jesus: —¿Fey chumngechi am wiñome choyüngetuafuy ti dew putremkülewelu? Wiñome pepi konlayafuy ta kiñe che ñi ñuke mew, femngechi ñi we choyüngetuael. ¿Chem dungu anta feypipeen? ");
INSERT INTO arnNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus wiñoldungueyew: —Rüf dungu feypiaeyu fey ti choyüngenolu ko mew ka ti Lif Küme Püllü mew, pepi konlayay Ngünechen ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Feypin ürke tati choyüngelu ta kuerpu niechi chaw mew, kiñe mapu tuwünngechi kuerpu niey, welu tati choyüngelu ta Lif Küme Püllü mew, püllü tati. ");
INSERT INTO arnNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kangeweduamkilnge tami feypipefiel mew: ‘Itrokom che müley ñi we choyüngetuael reke’. ");
INSERT INTO arnNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Famngechi reke kürüf ta chew püle rume pimu amukey, fey tunte allküngeay rume ñi rarakün, pengekelay chew püle ñi küpan ka chew püle rume ñi amun. Ka femngechi femkey kom tati choyüngetulu tati Lif Küme Püllü mew ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Fey Nikodemo wiñome ramtufi ta Jesus: —¿Chumngechi am pepi femafuy tüfa? ");
INSERT INTO arnNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus llowdungueyew: —¿Eymi ta Israel ñi fütra kim wentru, fey longkontukulafimi tüfachi dungu? ");
INSERT INTO arnNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Rüf dungu feypiaeyu iñchiñ ta dungukeiñ taiñ kimnieel, ka nütramyekeiñ taiñ pekeel, welu eymün feyentukelaymün iñchiñ tamün feypiwkefiel, ");
INSERT INTO arnNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","fey feyentumunoli femngechi dunguyüm tüfachi mapu mew mülechi dungu, ¿chumngechi am feyentuaymün dunguwliyiñ ta wenu mapu mülechi dungu? ");
INSERT INTO arnNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Iney no rume pürakelay ta wenu mapu, welu may tati nagpalu müten ta wenu mapu: tati Wentrukünuwpalu, tati wenu mapu mülelu. ");
INSERT INTO arnNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Welu tati Wentrukünuwpalu witrañpüramngeay chumngechi Moyse witrañpürami tati filu ta uwe mapu mew, ");
INSERT INTO arnNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","fey ta famngechi kom tati feyentulu kisu mew ñi nieael rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Fey tüfa ta feyngey Ngünechen am rume piwkeyefilu ta kom mapu mew mülechi pu che, feymew wüli ñi kiñen Fotüm femngechi kom tati feyentulu kisu mew chumkawnorume ñi lanoael, welu may ñi nieael ta rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Fey Ngünechen am werkünolu ñi Fotüm ta mapu mew, tañi kondenayafiel ta che, welu may tañi montulafiel kom che. ");
INSERT INTO arnNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tati feyentulu Ngünechen ñi kiñen Fotüm mew fey ta kondenangelay, welu tati feyentunolu dew kondenaley, tañi feyentunon mew Ngünechen tañi kiñen Fotüm mew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ngünechen feypifi tati pu che: tati pelon küpay mapu mew, fey ti pu che llowlafi ti pelon, doyümfilu am tati dumiñ tati pelon mew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kom tati wesa femmekekelu üdekefi ta pelon, ka fülkelay ta pelon mew, fey ñi kimüñmangenoael engün tañi wesa femkeel. ");
INSERT INTO arnNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Welu tati müngeltuniefilu ñi chem pilen tati rüfngechi dungu, fülkonpakey ta pelon mew femngechi tañi kimngeael ta itrokom ñi femken chumngechi ñi ayüken ta Ngünechen.” ");
INSERT INTO arnNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dew rupalu tüfachi dungu, Jesus amuy ñi pu disipulu engün Judea trokiñ mapu mew. Tüfey mew mülepuy pichi alüñma, fey kisu engün mekepuy ñi fawtisachen. ");
INSERT INTO arnNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan ka mekerkey ñi fawtisachen Enon waria mew ka Salim waria ñi fülpüle, fey üye mew am mülelu fentren ko, fey ti pu che amukey, fey fawtisangekey. ");
INSERT INTO arnNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Fey tüfachi dungu rupay petu ñi püresungenon ta Juan karsel mew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Welu kiñekentu Juan ñi kompañ eluwi ñi üyawtuwael kiñe judiu engün feytichi liftuwün wimtun dungu mew, femngechi ñi kümelkawkületuael ta Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Fey kom amuyngün ñi feypimeafiel ta Juan: —Kimeltufe, chumül mülelu eymi Jordan ñi tripawe antü ad püle, tüfeychi wentru tami nütramelmufiel nga, fewla mekey ñi fawtisachen, fey kom che küpakey kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan feypieyew: —Kümelkamekey tati. Iney rume nielayafuy chem no rume, Ngünechen ta elunoeliyew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Eymün ta kisu allküñmamun ñi feypin küme nor dungun mew iñche tañi Cristongenon, welu may kiñe tati wüne werküel wünelealu ti Cristo mew, femngechi tañi pepikayafiel ti pu che. ");
INSERT INTO arnNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Fey kiñe mafün mew, tati nielu ti nofia fey lle tati nofio. Feychi nofio ñi nieelchi weni, mülelu ti mafün mew allküñmafilu ñi nütramkameken ti nofio, rume ayükey. Fey ta famngechi iñche rüf dungu mew rume ayüwkülen tati nofio reke. ");
INSERT INTO arnNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kisu ta amuleay ñi doy wewkülen ka ñi yamfal wentrungeael, fey iñche amuleay ñi doy illamngetun ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Tati wenu mapu küpalu wünenküley itrokom dungu mew. Tati mapu mew mülelu mapu tuwünngey, ka femkey tati mapu mew mülechi dungu. Welu tati küpalu wenu mapu mew wünenküley itrokom dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ka dungukey tañi pekeel ka ñi allkükeel, welu iney no rume feyentukelaeyew kisu tañi piel. ");
INSERT INTO arnNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Welu iney rume feyentule, rüf dungu mew kellukonkey Ngünechen ñi rüf dungu ñi nien. ");
INSERT INTO arnNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Fey Ngünechen ñi werküelchi Fotüm dungukey Ngünechen ñi dungu, Ngünechen am eluetew ñi Lif Küme Püllü. ");
INSERT INTO arnNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Fey ta Chaw piwkeyey ñi Fotüm, fey elufi ta pepiluwün itrokom dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Fey ti feyentulu ta Fotüm mew niey rumel mongen, welu tati pinolu ñi feyentuael ta Fotüm mew, nielayay rumel mongen, welu may üngümniey reke Ngünechen tañi kutrankachen.” ");
INSERT INTO arnNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tati pu farisew kimtukuy engün ta Jesus mew ñi miyawken doy fentren che ka doy alün che ñi fawtisameken ta Juan mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tunte kisu no rume tati fawtisakefulu, welu may ta kisu ñi pu disipulu. ");
INSERT INTO arnNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Feymew Jesus kimlu tüfachi dungu, tripatuy ta Judea mapu mew ñi wiñotuael ta Galilea. ");
INSERT INTO arnNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Fey rüpütuletulu, Jesus felerkey ñi rumerputuael Samaria trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Feymew puwürkey Samaria ñi waria püle Sikar pingelu, inafül tüfeychi mapu mew Jakob elurkefi kisu ñi fotüm Jose pingelu. ");
INSERT INTO arnNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tüfeychi mapu mew mülerkey Jakob ñi dewmaelchi posoko. Fey Jesus kansalewelu ñi rüpütulen mew, anükünuwpuy ti inafül posoko. Epe rangiantürkey dewma. ");
INSERT INTO arnNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Fey ñi pu disipulu amurkey engün waria mew ñi ngillameael pichiken iyael. Feymew kiñe domo Samaria trokiñ mapu tuwlu, mülelu Sikar waria mew, akuy ti posoko mew ñi nentupayael ko, fey Jesus feypifi ti domo: —Eluafen pichin ko, papay. ");
INSERT INTO arnNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Welu ti pu judiu am wenikawkenolu ti pu Samaria tuwchi pu che engün, fey ti domo llowdungueyew: —¿Chumngelu am eymi tami judiungen, fey iñche ‘eluafen pichin ko’ pipeen, iñche ta Samaria tuwchi domo? ");
INSERT INTO arnNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus llowdungufi ti domo: —Eymi kimfulmi ñi ineyngen iñche tami ngillatupeetew ta ko ka kimfulmi chem ñi wülken ta Ngünechen, fey ngillatufeli ko ta iñche, fey iñche eluafeyu ta mongen ko. ");
INSERT INTO arnNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Fey ti domo feypieyew: —Chachay, nielaymi chem rume tami nentuafiel ko ka ti posoko rume alü koni. ¿Chew anta nieymi tami eluafielchi mongen ko? ");
INSERT INTO arnNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iñchiñ taiñ kuyfi tuwün em Jakob elkünuleiñmew tüfachi posoko. Tüfa mew pütokokefuy ta kisu ka ñi pu fotüm ka pütokokefuy ñi pu kulliñ. ¿Eymi anta doy adümuwimi ta Jakob mew? ");
INSERT INTO arnNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus llowdungufi ti domo: —Kom tati pütokolu tüfachi ko, ka wiñome wüywütukey. ");
INSERT INTO arnNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Welu tati pütokoalu feytichi ko iñche ñi eluafiel, chumkawnorume ta wiñome wüywüwelayay. Feytichi ko iñche ñi eluafiel wefkülealu kiñe rumel mongen posoko reke, fey ta famngechi rumel mongeleay. ");
INSERT INTO arnNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Fey ti domo feypieyew: —Chachay, eluen ta tüfeychi ko, femngechi tañi wiñome wüywüwenoael ka ñi küpawenoael rume ñi nentupayael ko tüfachi posoko mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Feymew Jesus feypifi ti domo: —Amutunge. Mütrümmetunge tami füta, fey mür küpatuaymu tüfa mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Feymew ti domo llowdungueyew: —Nielan ta füta. Jesus feypifi ti domo: —Küme pimi tati tami nienon ta füta. ");
INSERT INTO arnNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Welu eymi ta niekefuymi kechu füta, fey tüfa tami nieelchi wentru, eymi ta fütayelafimi. Feyngey tami piel tati. ");
INSERT INTO arnNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Fey allkütulu tüfa, tati domo feypieyew: —Chachay, dew kimün tami pelon wentrungen ta eymi. ");
INSERT INTO arnNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Iñchiñ taiñ kuyfi tuwünche, tati pu Samaria tuwünngelu, püramyekefuyngün ngillatun mew ta Ngünechen tüfachi wingkul mew. Welu eymün tamün pu judiungen feypikeymün ta Jerusalen waria mew müten müley ñi püramyeafiel ta Ngünechen ngillatun mew. ¿Chew anta doy kümeafuy ñi püramyengeael ta Ngünechen? ");
INSERT INTO arnNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Fey Jesus feypifi ti domo: —Feyentuen papay, ñi dew felen ti dungu, eymün tamün püramyeafiel ngillatun mew ta Chaw Ngünechen, ngewelayay tamün küpayael tüfachi wingkul mew kam tamün amuael Jerusalen mew no rume. ");
INSERT INTO arnNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Eymün kimlaymün iney müngell tamün püramyekefiel ngillatun mew, welu iñchiñ ta kimnieiñ iney taiñ püramyekefiel ngillatun mew, tati pu judiu tuwünche mew am küpayalu tati Montulchefe. ");
INSERT INTO arnNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Welu dew feley tati dungu, femngechi tati rüf dungu mew püramyefilu ngillatun mew ta Chaw Ngünechen, femayngün kiñe feyngechi dungu mew tati Lif Küme Püllü tañi kellun mew. Fey Chaw Ngünechen am ta ayükelu tañi femngechi femael tañi pu püramyekeetew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ngünechen ta Lif Küme Püllü, fey tañi püramyekeetew ngillatun mew, müley ñi femael kiñe feyngechi dungu mew tati Lif Küme Püllü ñi kellun mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Fey ti domo feypieyew: —Iñche kimnien ñi küpayael tati Mesia (tati Cristo ürke), fey küpale ta kisu, kom küme kimelpayaeiñmew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Feymew Jesus feypifi ti domo: —Fey iñche tati, eymi tami petu dunguetew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Feychi lelen mew akutuy kisu ñi pu disipulu, feymew müleduamkülewey engün Jesus ñi petu dungumeken kiñe domo engu. Welu kiñe no rume eluwlay ñi ramtuaetew chem dungu ñi nütramkameken ti domo engu. ");
INSERT INTO arnNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Feymew ti domo elkünuy ñi metawe, fey amutuy ta waria mew. Üyew nütramelputufi ti pu che: ");
INSERT INTO arnNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Küpamün tamün pepayafiel ta kiñe wentru. Kisu ta feypienew kom ñi chumkeel ta iñche. ¿Tüfapelleafel am tati Cristo? ");
INSERT INTO arnNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Feymew ti pu che tripapay engün ti waria mew, fey amuyngün chew ñi mülemum ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Feychi lelen mew, ñi pu disipulu llellipufeyew: —Kimeltufe, pichin rewall iyafuymi. ");
INSERT INTO arnNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Welu Jesus feypifi ñi pu disipulu: —Iñche nien tañi iyael eymün tamün kimnoel. ");
INSERT INTO arnNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Fey ti pu disipulu eluwingün welukonke ñi ramtuwael: —¿Küpalelngepemay ta iyael? ");
INSERT INTO arnNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Welu Jesus feypi: —Iñche tañi iyael reke feley tañi femael ñi Chaw ñi werküetewchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Eymün feypikeymün: ‘Petu mülewey meli küyen tañi akuael ta kosecha.’ Welu iñche feypiwayiñ tamün ngüneduamafiel tüfeychi pu che ñi petu küpalen ñi konael Ngünechen ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tati küdawkelu ta kosecha mew llowkey ñi kullitun, fey ti fün ketran tati kosechael fey ta rumel mongenngealu, femngechi tati nganlu ka ti kosechakelu ti fün ketran kiñentrür ayüway engün tati pu che mew eluwkülelu ñi konael Ngünechen ñi ülmen mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Fey tüfachi feypin am rüf feyngelu: ‘Kiñerke tati nganlu, fey kangelu tati kosechakelu ti fün ketran.’ ");
INSERT INTO arnNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Iñche werküwiyiñ ta eymün tamün kosechayafiel ti fün ketran, fey ta pichin no rume tamün küdawtunoel; kakelu may tañi küdawel mew, fey eymün ta kosechakefimün kisu engün ñi küdawel ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Fey rume fentren che tuwyelu ta Samaria trokiñ mapu mülechi waria mew, feyentuy engün ta Jesus mew, tañi küme feypietew mew engün tati domo: “Feypienew iñche kom tañi chumkefel.” ");
INSERT INTO arnNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Feymew, ti pu Samaria tuwchi che akuyelu, feypifingün ta Jesus fey ñi müleweael kisu engün mew. Fey kisu mülewey epu antü tüfeychi waria mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Feymew doy alün che feyentuy, kisu allküñmangelu ñi nütramkameken. ");
INSERT INTO arnNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Fey feypifingün ti domo: —Fewla feyentuiñ eymi tami feypimufiel mew müten no, welu may kisuke iñchiñ taiñ allküñmafiel mew, fey fente küme kimiyiñ ta Jesus ñi Montulchefengen. ");
INSERT INTO arnNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Rupalu tüfeychi epu antü, Jesus tripatuy ta Samaria trokiñ mapu mew, fey rüpütukünuwtuy amualu ta Galilea, ");
INSERT INTO arnNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesus am feypilu kiñe pelon wentru ta püramyengekelay kisu ñi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Fey puwlu ta Galilea, tüfeychi pu che rume küme lloweyew, tüfa engün am ka femngechi amulu tati Paskua kawiñ mew ta Jerusalen ka dew pefuyngün itrokom ñi femel ta kisu tüfeychi waria mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Fey Jesus wiñotuy ta Kana Galilea mew chew pulkukünutufi tati ko. Fey mülerkey tati longko ülmen ñi kiñe kapitan, fey nierkey kiñe kutrankülechi fotüm ta Kapernaum waria mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Feymew ti kapitan kimlu Jesus ñi puwtun ta Galilea, dew wiñomelu ta Judea, fey amuy ñi pemeafiel ka llellipumefi ñi amuael kisu ñi ruka mew, fey ñi tremolelngetuael kisu ñi fotüm, epe lalerkelu am. ");
INSERT INTO arnNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus llowdungueyew: —Eymün feyentukelaymün, penoyüm kiñe ngünel dungu ka kiñe afmatufal dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Welu ti kapitan feypifi ta Jesus: —Ñidol, pürüm küpange petu ñi lanon iñche ñi fotüm. ");
INSERT INTO arnNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Feymew Jesus feypieyew: —Wiñotunge tami ruka mew, tami fotüm dew mongetuy. Fey ti kapitan feyentuy Jesus ñi feypietewchi dungu, fey amutuy. ");
INSERT INTO arnNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Petu wiñotulu ñi ruka mew, kisu ñi pu kona trafyemetueyew ka feypieyew: —¡Tami fotüm ta mongetuy! ");
INSERT INTO arnNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kisu ramtufi ñi pu kona chem ora mew ñi doy kümelkatun ñi fotüm, fey llowdungungey: —Wiya ella rupan antü elkünutueyew ti aling kutran. ");
INSERT INTO arnNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Fey ti kapitan ngüneduami feychi ora mew Jesus ñi feypietew: “tami fotüm ta mongetuy”. Fey ti kapitan ñi reñmache kom feyentuy Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Fey tüfachi afmatufal dungu epu rupa dewma ñi femel ta Jesus femngechi ñi kimngeael ñi nien fütra pepiluwün feychi puwtulu ta Galilea dew wiñomelu ta Judea mew. ");
INSERT INTO arnNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Fey rupalu mufü antü, tati pu judiu niekerkeyngün kiñe kawiñ, fey Jesus ka wiñotuy ta Jerusalen. ");
INSERT INTO arnNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Fey Jerusalen mew inafül ti Ufisa pingechi wülngiñ, müley kiñe wampo ko Fetseta pingelu aramewdungun mew. Nierkey kechu konkemumchi wülngiñ. ");
INSERT INTO arnNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tüfey mew mülekerkey rume fentren kutran, trawma, küntro ka ti lañmalelu ñi kuerpu tranalelu ti pülli mew. ");
INSERT INTO arnNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kiñeke rupa am akukerkelu ti estanke ko mew kiñe werken püllü, fey meytrafkapakefi ti ko. Fey dew nengümkaelchi ko mew, tati wüne konpulu tremotukey chem kutran mew rume ñi nieel. ");
INSERT INTO arnNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mülerkey kisu engün mew kiñe wentru kutrankülelu küla mari pura tripantu. ");
INSERT INTO arnNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Feymew Jesus pefilu tüyechi wentru ñi kudulen, fey kimürkey ñi rume fentren tripantu ñi femngechi felen dewma, fey ramtufi: —¿Ayüfuymi tami mongetuael? ");
INSERT INTO arnNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Fey ti kutran llowdungueyew: —Ñidol, nielan iney no rume tañi kelluaetew tañi konael ko mew femngechi nengümkangeyüm ti ko. Mufü rupachi ayükefun ñi konael, welu kangelu kutran wüne konkey. ");
INSERT INTO arnNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Fey Jesus feypifi ti wentru: —Witrange, ka witrañpüramtunge tami ngütantu, fey trekatunge. ");
INSERT INTO arnNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Feymew müten ti wentru mongetuy, witrañpüramtuy ñi ngütantu, fey eluwi ñi trekatuael. Welu ürkütun antü mew am tremolngetulu, ");
INSERT INTO arnNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","fey ti pu judiu feypifi engün tati tremolngetulu: —Fachantü ta ürkütun antü, fey ngelay tami yetuael tami ngütantu. ");
INSERT INTO arnNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Fey ti wentru llowdungueyew: —Tüfeychi wentru tañi mongeltuetew tañi kümelkaletuael feypienew: ‘Witrañpüramnge tami ngütantu ka trekatunge’. ");
INSERT INTO arnNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Fey kisu engün ramtuy: —¿Iney am tüfey tami feypietew: ‘Witrañpüramnge tami ngütantu ka trekatunge’? ");
INSERT INTO arnNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Welu ti wentru kimlay iney ñi mongeltuetew, Jesus am pengewetunolu ti müleyechi fentren pu che mew. ");
INSERT INTO arnNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Fey wüla ka petueyew ta Jesus tati ngillatuwe ruka mew, fey feypieyew: —Allkütunge, dew mongeletuymi, fey wiñome yafkawekilnge, femngechi tami wesa kutranwenoael. ");
INSERT INTO arnNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Fey ti wentru amuy ñi kimelpuafiel ti pu judiu Jesus ürke tañi mongeltuetew. ");
INSERT INTO arnNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Feymew ti pu judiu longkolelu inantukuyawülürkefi engün ta Jesus ka kintukefuyngün chumngechi ñi langümafuel, ñi mongelkutranken mew ürkütun antü mew. ");
INSERT INTO arnNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Welu Jesus feypieyew: —Iñche ñi Chaw rumel küdawkülekey, fey iñche ka feley ñi küdawael. ");
INSERT INTO arnNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Feymew tati pu longkolechi judiu doy ayükefuy ñi langümaetew, tañi yamnofiel ti ürkütun antü ka femngechi ñi feypin mew Ngünechen ta iñche ñi Chaw ka femngechi ñi feypin mew iñche ta Ngünechen ka müten. ");
INSERT INTO arnNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus famngechi llowdungufi ti pu judiu: “Rüf dungu feypiwayiñ Ngünechen ñi Fotüm ta chem rume pepi femlayafuy, re kisu müten tañi adkünuel. Kisu ta femkey ñi Chaw ñi ayükeelchi dungu müten. Itrokom ñi chumken ta Chaw, ka femngechi femkey ta Fotüm. ");
INSERT INTO arnNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Fey Chaw am piwkeyelu ñi Fotüm fey pengelelkefi kom ñi femkeelchi dungu ta kisu. Ka femngechi pengelelaeymünmew doy fütrake dungu, tamün pekeel mew, feymew rume afmatuleweaymün. ");
INSERT INTO arnNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Fey chumngechi ta Chaw wiñomongeltukefi tati pu dew layelu ka elutukefi ta mongen, ka femngechi ta Fotüm elufi mongen iney rume ñi ayüel tañi eluafiel ta mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Fey Chaw ta iney no rume ramtukadungukelafi ñi chumken mew, welu may Ngünechen elufi pepiluwün kisu ñi Fotüm tañi ramtukadunguafiel ñi chumkeel mew ta che ");
INSERT INTO arnNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","femngechi itrokom che ñi püramyeafiel ta Fotüm chumngechi püramyekefi ta Chaw Ngünechen. Tati püramyenofilu ta Fotüm ka femngechi püramyekelafi ta Chaw, tañi werküetew. ");
INSERT INTO arnNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ka femngechi rüf dungu feypiwayiñ tati allkütukelu iñche tañi pielchi dungu ka feyentukelu iñche ñi Chaw mew ñi werküetew, niey ta rumel mongen, fey ta kondenangelayay rumel ñi layael, welu may dew feley ñi rumel mongeletuael. ");
INSERT INTO arnNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Rüf dungu feypiwayiñ tañi dew küpalen ka ñi dew akun ta antü, feymew tati dew lalu allküay Ngünechen tañi Fotüm ñi dungun, fey tati pu la wiñomongetuay. ");
INSERT INTO arnNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Fey chumngechi ta Chaw niey mongen fey elukefi mongen ta kakelu, ka femngechi femkünuy kisutu ñi nieael mongen ta Fotüm ka elukefi mongen ta kakelu, ");
INSERT INTO arnNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","feymew ka elufi pepiluwün tañi ramtukadunguafiel ta che ñi chumken mew, kisu am Ngünechen ñi Wentrukünuwpachi Fotüm. ");
INSERT INTO arnNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Afmatukefilmün ta tüfa, fey akule tati antü itrokom tati pu layelu allküay ta kisu ñi dungun, ");
INSERT INTO arnNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","fey tripapatuay engün ñi rüngan küfwe mew. Fey tati kümeke femün nielu wiñomongetuay tañi nietuael ta rumel mongen, welu tati wesa femün nielu, wiñomongetuay tañi kutrankawael. ");
INSERT INTO arnNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Iñche ta pepi femlayafun chem dungu no rume kisu duam. Iñche ta nor dungu mew ramtukadunguken chumngechi feypienew iñche tañi Chaw. Fey iñche ñi feypiel rüf dungungey, ka iñche femkelan ñi kisu ayüelchi dungu, welu may femken iñche ñi Chaw ñi ayüelchi dungu, fey kisu am werküetew. ");
INSERT INTO arnNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Fey iñche kisu nütramyewfuli ñi dunguñpewael, iñche ñi nütramyewün falilayafuy kiñe rüf dungu reke. ");
INSERT INTO arnNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Welu müley kangelu tañi nütramyekeetew ta iñche, fey kimniefiñ ñi feyngen ti nütram ka ñi rüf dungungen. ");
INSERT INTO arnNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Eymün werküymün ta che tañi ramtumengeael ta Juan, fey kisu ñi llowdunguel fey ta rüf dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Welu iñche ayükelan ta iney rume ñi nütramyeaetew, tüfachi dungu may feypiken, ta eymün tamün pepi montuael. ");
INSERT INTO arnNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan ta kiñe üykülechi küdetuwe reke felefuy ka pelontulekefuy reke, fey eymün eluwimün tamün ayüwael kisu ñi pelon mew pichiñma müten. ");
INSERT INTO arnNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Juan nütramyekeenew ñi werküetew ta Ngünechen, welu Ngünechen ñi werküetew ñi femaelchi dungu, fey ta doy küme nütramyenieenew ta Juan ñi feypiel mew. Fey iñche tañi femelchi dungu, tañi Chaw ñi werküetew tañi femael, feychi dungu ta femken. ");
INSERT INTO arnNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Welu ka femngechi doy faliy iñche ñi Chaw am werküetew ta iñche, ka kisu ñi dunguñpenieetew ta iñche, tunte eymün chumkawnorume allküñmakelafimün kisu ñi dungun ka pekelafimün rume. ");
INSERT INTO arnNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ka ñi werküelchi dungu no rume mülelay ta eymün mew, feyentunolu am eymün Chaw tañi werküelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Eymün chillkatukefimün tati wirin dungu rume kuñiwtun mew, fey eymün am rakiduamkelu tamün nieael rumel mongen tamün chillkatukefiel mew ti dungu. Welu ta tüfachi wirin dungu tamün chillkatukeel nütramyenieenew ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Welu eymün pilaymün tamün küpayael iñche mew, femngechi tamün eluwafiel ta rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Iñche ayükelan ta che ñi re wenche piwke ñi püramyeaetew. ");
INSERT INTO arnNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kimniewiyiñ ta eymün ka kimnien tamün piwkeyenofiel ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iñche küpan ñi Chaw tañi werküetew mew, fey eymün ta llowmulan, welu küpafule kangelu re kisu duam, feyke ta llowafuymün. ");
INSERT INTO arnNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Eymün ta welukonkechi küme trokituwkeymün, fey kintukelaymün ta kiñen Ngünechen tamün küme trokituaetew, ¿chumngechi am pepi feyentuafuymün iñche mew? ");
INSERT INTO arnNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Welu rakiduamkilmün iñche tamün dalluntukuwafiel iñche ñi Chaw mew. Fey tamün dalluntukukeetew fey ta Moyse ñi ley dungu tati, tüfey eymün tamün maneluwkemum. ");
INSERT INTO arnNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Fey eymün ta feyentufulmün ñi chem piel ta Moyse ka femngechi feyentuafuymün ta iñche mew, fey Moyse am ñi wirielchi dungu, tukulpaetew iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Welu feyentunolmün Moyse tañi wiriel mew, ¿chumngechi kay feyentuaymün tüfeychi dungu tamün feypiwpefiel?” pi. ");
INSERT INTO arnNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Dew rupalu tüfachi dungu, Jesus amuy Galilea nome lafken (tüfachi lafken ka femngechi Tiferia lafken pingekey). ");
INSERT INTO arnNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Rume fentren che inayawüleyew, pefilu engün am tati afmatufal dungu tañi femün, tremolnietufiel mew ti pu kutran. ");
INSERT INTO arnNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Feymew Jesus pürapuy ti wingkul mew, fey anüpuy ñi pu disipulu engün. ");
INSERT INTO arnNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Dew fülküleparkey tati pu judiu ñi kawiñ antü, Paskua pingelu. ");
INSERT INTO arnNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Feymew Jesus adkintulu, fey pefi rume fentren che ñi inaetew, fey Jesus feypifi ta Felipe: —¿Chew anta ngillameaiñ ta kofke kom tüfachi pu chengealu? ");
INSERT INTO arnNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Welu femngechi feypi ñi kimael chumngechi ñi llowdunguael ta Felipe, fey Jesus am dew küme kimniefulu ñi chumael. ");
INSERT INTO arnNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe llowdungueyew: —Rume fentren pülata mew may ngillangepeafuy kofke ñi pichiken elungeael kake kiñeke tüfachi pu che. ");
INSERT INTO arnNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Feymew Andre, tüfa ta kangelu kisu ñi disipulu Simon Pedro tañi peñi, feypieyew: ");
INSERT INTO arnNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Tüfa mew müley kiñe pichiwentru nielu ta kechu kawella kofke ka epu challwa, welu ¿puwafuy chey am fentren che mew? ");
INSERT INTO arnNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus llowdunguy: —Feypifimün kom ti pu che ñi anükünuwael engün. Rume mülerkey kachu tüyechi lelfün mew, fey anükünuwi engün. Kiñe kechu warangka wentru ürke. ");
INSERT INTO arnNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus nüy ñi kuwü mew tati kofke, fey dew mañumtufilu ta Ngünechen, fey wüdamkalelfi ti pu che anüleyelu, ka femngechi femi ti epu challwa mew, fey eluyefi kom ñi küpa iel engün. ");
INSERT INTO arnNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Fey dew küme wedalu engün, Jesus feypifi tañi pu disipulu: —Trawültufimün tati sofrayechi wükanke kofke, femngechi ñi ngünanoael pichin no rume. ");
INSERT INTO arnNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Fey kisu engün trawülyetuyngün ka apolyetuyngün mari epu kanasta tati wükanke kofke mew, tati sofralu ti kechu kawella kofke mew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Fey ti pu che, pefilu tüfachi afmatufal dungu ñi femel ta Jesus tañi kimngeael ñi ineyngen, feypi engün: —Rüfngey ta tüfa ñi pelon wentrungen tati felelu ñi küpayael ta mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Welu Jesus ngüneduami ñi ayüngefel ñi yengetuael aporia mew tañi longko ülmenkünungeael, fey ka wiñome püntütripatuy tati doy wechuntu wingkul mew, femngechi tañi kisuleael. ");
INSERT INTO arnNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Fey punlu dewma, Jesus ñi pu disipulu nagpuy engün lafken püle. ");
INSERT INTO arnNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Fey pürapuy kiñe farku mew ka eluwi engün ñi rumeael ti lafken mew femngechi ñi puwael ta Kapernaum waria. Dew küme dumiñürkey. Fey Jesus petu wiñomerkelay. ");
INSERT INTO arnNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Feymew ti lafken rume ingafpüramekey kiñe fütra kürüf tañi triparumen mew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Feymew dew amulelu engün kiñe kechu kam kayu kilometro, pefingün ta Jesus, petu fülpulu ti farku püle trekalelu wente ko, fey llükay engün. ");
INSERT INTO arnNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Fey Jesus feypifi ñi pu disipulu: —¡Iñche tati! ¡Llükakilmün! ");
INSERT INTO arnNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Fey ñi pu disipulu elueyew ñi konpuael ti farku mew, feymew ka pichin mew müten puwi engün inaltu ti ayliñ mew chew ñi puwael engün. ");
INSERT INTO arnNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Fey kangelu antü mew, ti mülenagchi pu che ngüneduamfi engün Jesus ñi pu disipulu ñi amun nome lafken ti kiñelechi pichi farku mew mülelu tüye mew, welu Jesus amulay. ");
INSERT INTO arnNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Feymew kakelu farku puwyey Tiferia waria mew fülpüle chew ifi engün ti kofke feychi mañumtulu ta Ñidol. ");
INSERT INTO arnNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Feymew ngüneduamngelu ñi mülenon ta Jesus ka ñi pu disipulu no rume, fey ti pu che pürapuyngün farku mew, fey amuyngün ta Kapernaum waria tañi kintumeafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Fey kisu engün puwlu nometu lafken mew, pefingün ta Jesus, fey ramtufi engün: —Kimeltufe, ¿chumül anta akuymi fawpüle? ");
INSERT INTO arnNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus feypieyew: —Rüf dungu feypiwayiñ ta eymün kintumupen tamün ifiel mew ti kofke ka tamün fente küme wedan mew, welu tamün peelchi afmatufal dungu mew no tañi kimngeael ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Poyekefilmün tati afkechi iyael, welu may tamün poyeafel tati rumel mülekechi iyael fey tamün eluafetew rumel mongen. Fey iñche tati Wentrukünuwpalu eluwayiñ tüfachi iyael, fey Chaw Ngünechen am adkünulu tüfachi dungu kisu ñi Fotüm mew ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Fey ramtueyew engün: —¿Chumaiñ am taiñ femael Ngünechen tañi ayükeelchi dungu? ");
INSERT INTO arnNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus llowdungueyew engün: —Ngünechen ayüley tamün femael tüfeychi dungu tamün feyentuael iñche mew kisu tañi werküetew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Feymew ramtuy engün: —¿Chem afmafal dungu am femaymi femngechi pefiliyiñ taiñ feyentuael? ¿Chem küme dungu am femaymi iñchiñ mew? ");
INSERT INTO arnNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Iñchiñ taiñ kuyfike tuwün em ifi engün tati mana kofke ti uwe mapu mew, chumngechi feypiley ti Wirin Chillka: ‘Ngünechen elueyew ñi iyael engün ti wenu mapu kofke.’ ");
INSERT INTO arnNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus llowdunguy: —Rüf dungu ta feypiwayiñ Moyse no tati tamün eluetew ta eymün tati wenu mapu kofke, welu may iñche ñi Chaw tüfey tamün elukeetew ti rüfngechi wenu mapu kofke. ");
INSERT INTO arnNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Fey ti kofke Ngünechen ñi wülkeel fey tüfa lle tati nagpalu wenu mapu, ka elukefilu rumel mongen ta kom mapu mew mülechi pu che. ");
INSERT INTO arnNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Fey kisu engün ngillatueyew: —Ñidol, rumel eluniemuaiñ üyechi kofke. ");
INSERT INTO arnNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Fey Jesus feypi: —Iñche ta kofke reke felen wülkelu ta rumel mongen. Kom ti llowetew iñche, chumkawnorume ngüñüwelayay reke, ka tati feyentulu iñche mew chumkawnorume wüywüwelayay reke. ");
INSERT INTO arnNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Iñche dew feypiwiyiñ, welu eymün feyentukelaymün iñche mew tunte pemuken rume. ");
INSERT INTO arnNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kom kakelu che iñche ñi Chaw ñi eluetew, llowenew ta iñche, fey kom tañi llowetewchi pu che, famentulayafiñ. ");
INSERT INTO arnNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Iñche am küpanolu ta wenu mapu tañi femael kisu iñche ñi ayüelchi dungu, welu may tañi femael iñche ñi Chaw ñi ayüelchi dungu, fey tañi werküetew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Welu feypiwayiñ tañi ayükeel iñche ñi Chaw, fey iñche ñi ñamümnoafiel kiñe no rume tañi eluetew, welu may tañi wiñomongeltuafiel ti afaelchi antü mew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Feyngey iñche ñi Chaw am ayülelu itrokom tati maneluwlu ta Ngünechen ñi Fotüm mew ka feyentulu ta kisu mew ñi nieael rumel mongen, fey iñche wiñomongeltuafiñ afaelchi antü mew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Feymew tati pu judiu eluwingün ñi fillpiafiel ta Jesus, tañi femngechi feypin mew: “Iñche tati kofke reke felen nagpalu ta wenu mapu.” ");
INSERT INTO arnNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Feymew feypi engün: —¿Fey tüfa no anta Jesus, Jose tañi fotüm? Iñchiñ kimnieñmafiyiñ kisu ñi chaw ka ñi ñuke, fey ¿chumngelu am feypipey ñi nagpan ta wenu mapu? ");
INSERT INTO arnNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Feymew Jesus feypi: —Fentekünumün tamün fillpikawmekeael. ");
INSERT INTO arnNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Iney rume pepi küpalayafuy ta iñche mew, iñche ñi Chaw ta küpalnoeliyew, iñche tañi werküetew. Fey iñche ta wiñomongeltuafiñ afaelchi antü mew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Chumngechi feypiley tati pu pelon wentru ñi chillka mew: ‘Ngünechen kimeltuafi ta itrokom che’. Femngechi itrokom tati allkütufilu ta Chaw Ngünechen, ka adümlu kisu ñi dungu, fey llowkeenew ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Feyngey iney no rume am pekenofilu ta Chaw Ngünechen, fey kiñeley müten tañi pekeetew, tüfey tati küpalu ta Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Rüf dungu feypiwayiñ tüfey tati feyentulu iñche mew, nieay ta rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iñche felen ta kofke reke wülkelu ta rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Eymün tamün kuyfike tuwün em ifi engün tati mana ti uwe mapu mew. Femfuy rume, layey engün. ");
INSERT INTO arnNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Welu iñche nütramyeken ti kofke nagpalu ta wenu mapu, fey iney rume ifile tüfachi kofke, lalayay. ");
INSERT INTO arnNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iñche ta tüyechi kofke wülkelu rumel mongen tati nagpalu ta wenu mapu, fey tati ifilu ta tüfachi kofke, rumel mongeleay. Feyti kofke iñche tañi wülkeel iñche tañi kuerpu. Iñche wülafiñ tañi nieael rumel mongen ta mapu mew mülechi pu che.” ");
INSERT INTO arnNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Fey ti pu judiu eluwingün ñi welukonkechi üyawtuwael: —¿Chumngechi am tüfachi wentru pepi eluaeiñmew kisu ñi kuerpu taiñ iñmayafiel? ");
INSERT INTO arnNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Fey Jesus feypi: —Rüf dungu feypiwayiñ eymün ta inofilmün tati Wentrukünuwpalu tañi kuerpu ilo reke ka putuñmanofilmün kisu ñi mollfüñ, nielayaymün ta rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Welu tati iñmaetew iñche ñi kuerpu ilo reke ka putule iñche ñi mollfüñ, nieay ta rumel mongen, fey iñche wiñomongeltuafiñ tati afaelchi antü mew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tüfa ta feyngeay iñche ñi kuerpu am ta rüfngechi iyael reke felelu ka iñche ñi mollfüñ rüfngechi pulku reke feley. ");
INSERT INTO arnNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tati iñmaetew iñche ñi kuerpu ilo reke ka putufile reke iñche ñi mollfüñ, iñche mew kiñewküley ñi mongen, ka iñche kiñewkülen tañi Chaw iñchiw. ");
INSERT INTO arnNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Iñche ñi Chaw, tañi werküetew, rumel mongelekey, fey iñche ka femngechi mongen nien. Fey ka femngechi: tati iñmaetew tañi kuerpu, iñche ñi mongen nieay. ");
INSERT INTO arnNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nütramyepefiñ ti kofke tati nagpalu ta wenu mapu. Tüfachi kofke ta mana reke femngelay tañi iel eymün tamün kuyfike tuwün em, fey ifuyngün rume, welu layey engün, welu may tati ifilu tüfachi kofke rumel mongeleay. ");
INSERT INTO arnNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus kimeltuy tüfachi dungu ta Kapernaum mülechi sinagoga mew ñi trawün che mew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Allkülu tüfachi kimeltun dungu, fentren che miyawkelu ta Jesus engün, feypi: —Fey tüfa tañi kimeltuel rume küdawngey tañi llowngeael. ¿Iney am müngeltuafeyew tatey? ");
INSERT INTO arnNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus ngüneduamlu ñi petu fillpimeken engün, ramtufi ti pu che: —¿Tüfachi dungu anta wesaduamelkaeymünmew? ");
INSERT INTO arnNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Chem chumaymün am, pefilmün tüfachi mapu mew tati Wentrukünuwpalu püratule chew ñi mülekefel wünelu mew? ");
INSERT INTO arnNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Feyti Küme Püllü wülkey ta rumel mongen; fey kuerpu ta falilay rumel mongenngealu. Iñche tañi feypipeelchi dungu, fey koneltuley tati Lif Küme Püllü tati wülkelu ta rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Welu petu müley kiñekentu eymün mew tati feyentulenolu. Fey Jesus am kimürkelu llituka mew müten iney engün tati feyentulenolu ka ineyngen tüfey tañi ngünen mew wültukukünuaetew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ka amul feypi: —Feymew ta feypiwkeyiñ ta iney no rume llowlayaenew ta iñche, fey ñi Chaw ta küpalnoeliyew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Feymew müten, rume fentren tañi inayawülkeetew ta Jesus, elkünutueyew, ka doy miyawelay engün ta kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Fey Jesus ramtufi tati mari epu disipulu: —¿Eymün ka ayüleymün am tamün amutuael? ");
INSERT INTO arnNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Pedro llowdungueyew: —Ñidol, ¿iney mew kay amuafuiñ? Eymi tami dungun ta rumel mongen dungun. ");
INSERT INTO arnNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Iñchiñ ta dew feyentuiñ ka kimiyiñ ta eymi Ngünechen ñi Lif Küme Mongenngelu. ");
INSERT INTO arnNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Fey Jesus feypi: —¿Iñche anta dulliwlayiñ tamün mari epungen? Welu kiñe ta eymün mew kontunieeyew ta weküfü. ");
INSERT INTO arnNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tüfa ñi feypin mew, ta Jesus dungurkey ta Juda mew, Simon Iskariote ñi fotüm, Juda am re ngünen mew wültukurkeafilu ta Jesus, tunte rakikonkülerkefuy rume tati mari epu disipulu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Dew rupalu tüfachi dungu, Jesus miyawürkey Galilea trokiñ mapu mew. Pirkelay ñi müleael ta Judea mew, fey üye mew am tati longkolechi pu judiu kintuyawülürkeetew ñi langümaetew. ");
INSERT INTO arnNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Welu ka petu fülpalu am tati küni ruka kawiñ, kiñe kawiñ ñi niekeel tati pu judiu, ");
INSERT INTO arnNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","kisu ñi pu peñi feypieyew lladkütudungun mew: —Mülekilnge tüfa mew. Amunge ta Judea mew, femngechi tami inayawülkeetewchi pu che tami nieel üyew ñi peael engün tami femkeelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Fey eymi ayülelmi tami kimngeael ka tami yamfal wentrungeael, ellkaniekilnge tami femkeelchi dungu. Dew eluwkülelu am eymi tami femael tüfeychi dungu, fey femnge may kom che ñi adkiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Fey kisu ñi pu peñi no rume feyenturkelay ta kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Feymew Jesus feypifi ñi pu peñi: —Petu puwlay iñche tañi medin antü, welu eymünngealu chem antü rume puwkülekey. ");
INSERT INTO arnNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tüfachi mapu mew mülechi che ngelay tamün üdeaetew ta eymün, welu ta iñche üdekeenew engün, fey iñche am küme feypikefilu nor dungun mew ñi femkeelchi dungu ñi kümenon. ");
INSERT INTO arnNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Amumün eymün tati kawiñ mew, welu iñche ta amulayan, petu puwnolu am iñche ñi medin antü ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Fey Jesus feypikünufilu tüfachi dungu kisu ñi pu peñi, fey kisu mülewey ta Galilea mew. ");
INSERT INTO arnNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Welu dew amulu wüla ñi pu peñi, feymew Jesus ka ayüwmay ñi amuael tati kawiñ mew, tunte kimlay chem che no rume, welu ellkankechi reke amuy. ");
INSERT INTO arnNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fey ti longkolechi pu judiu kintuyawüleyew ti kawiñ mew, fey feypiyawingün: —¿Chew chey müley tüfeychi wentru? ");
INSERT INTO arnNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Fey ti pu che mew, Jesus rume nütramyengey. Kiñekentu feypiyey engün: “Kiñe küme piwke wentrungey”. Welu kakelu feypiyey engün: “Küme piwkengelay, ngünenkachekey”. ");
INSERT INTO arnNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Welu iney no rume küme nor dungulay Jesus mew, llükaniefilu engün am tati pu judiu longkolelu. ");
INSERT INTO arnNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Dew rangiñ amulelu ti kawiñ, Jesus konpuy ti ngillatuwe ruka ñi lepün mew, fey eluwpuy ñi kimeltuael. ");
INSERT INTO arnNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Fey ti pu judiu feypi engün afmatulen mew: —¿Chumngechi am kimi tüfachi wentru fente alün dungu fey ñi papeltukenon ñi fütra kimeltufengeael? ");
INSERT INTO arnNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Fey Jesus llowdungufi ti pu judiu: —Tañi kimeltukeel iñche ñi dungu no, welu may tüye iñche ñi werküetew tañi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tüfa ta feyngey iney rume rüf dungu mew eluwkülele ñi femael Ngünechen ñi ayüelchi dungu, iñche ñi kimeltun kimfali tañi küpan ta Ngünechen mew ka ñi dunguelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tati dungukelu re kisu duam müten, dungukey kisu ñi püramyengeael tati pu che mew, welu iñche ayülen ñi püramyeafiel tüfey tañi werküetew, feymew ta feypimekeken ti feyngechi dungu, fey ta famngechi iñche mew ngelay chem koyla dungu no rume eymün may koyla ngünenngeymün. ");
INSERT INTO arnNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“¿Fey Moyse no anta elueymünmew tati ley dungu? Welu kiñe no rume eymün ta müngeltukelafimün tati ley dungu. Fey eymün, ¿chumngelu am ayüleymün tamün langümmuafiel?” pi. ");
INSERT INTO arnNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Feymew ti pu che llowdungufi ta Jesus: —¡Weküfü ta kontunieeymew! ¿Iney anta ayüley tami langümaetew? ");
INSERT INTO arnNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Feymew feypieyew ta Jesus: —Kom eymün wesa duamkeymün kiñe dungu müten tañi femel mew ta iñche tati ürkütun antü mew. ");
INSERT INTO arnNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Welu femngechi rakiduamkülelmün, eymün, sirkunsidakefimün kiñe pichiche tunte ürkütun antü mew ngeay rume. Femngechi femkeymün tamün mupiael chumngechi ta Moyse ñi ley dungu werküeymünmew tamün sirkunsidawael (tunte Moyse mew rume küpalafuy tüfachi dungu, welu may tüfachi dungu küpay eymün tamün kuyfike tuwün mew). ");
INSERT INTO arnNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Fey tamün yafkantukuwnoael Moyse ñi ley dungu mew, eymün sirkunsidakefimün kiñe pichiche tunte ürkütun antü mew ngeay rume, ¿chumngelu lladkütumuken iñche tañi mongeltufiel mew ta kiñe wentru ti ürkütun antü mew? ");
INSERT INTO arnNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Welu eymün küme duamtukelayafimün tamün küme trokituel müten. Welu may ngüneduamkeafimün nor küme rakiduam mew ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kiñeke tati tuwyelu ta Jerusalen eluwingün ñi ramtuael: “¿Tüfa no am tati kintuyawülel tañi langümngeael? pi. ");
INSERT INTO arnNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tüfey ñi mülen, kom che ñi adkiñ mew nütramkamekey, fey iney no rume chem pilaeyew. ¿Fey ti pu awtoridad may rüf feyentupey ta tüfachi wentru mew Ngünechen ñi Cristongen? ");
INSERT INTO arnNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Welu iñchiñ kimniefiyiñ chew ñi tuwün ta tüfachi wentru, welu feychi küpale tati Cristo, iney rume kimlayay chew ñi tuwün.” ");
INSERT INTO arnNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Feymew Jesus allkülu tüfachi dungu ñi feypin ti pu che, petu mekelu ñi kimeltun tati ngillatuwe ruka mew, feypi newentu dungun mew: —¡Felerkey tamün kimniemufiel chew ñi tuwün ta iñche! Welu iñche küpan kisu ngünewün mew no, welu may iñche küpan tañi Chaw tañi werküetew mew, fey ta manelfali, eymün tamün kimnoel. ");
INSERT INTO arnNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Iñche kimniefiñ küpalu am iñche ñi Chaw mew, fey kisu ta werküenew. ");
INSERT INTO arnNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Feymew ayüfuyngün ñi püresuafiel, welu iney no rume püresulaeyew, fey petu puwnolu am ta kisu ñi legtun medin antü. ");
INSERT INTO arnNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Rume fentren che feyentuy Jesus mew, ka feypi engün: “Feychi küpale tati Cristo, ¿fempelayay tati afmatufal dungu ta tüfachi wentru ñi femkeel?” ");
INSERT INTO arnNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fey ti pu farisew allküñmafingün ti pu che ñi nütramyemekefiel ta Jesus, fey kisu engün ka ti pu longkolelu ti pu saserdote mew werküfingün kiñeke tati llüwatulekelu ti ngillatuwe ruka mew, fey ñi püresungeael ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Feymew Jesus feypi: —Iñche ta mülean eymün iñchiñ pichiñma müten, fey wüla wiñotuan tüfey tañi werküetew mew. ");
INSERT INTO arnNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Eymün ta kintumuan, welu pemulayan, fey am pepi amunoalu eymün chew ñi amuael ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Fey ti longkolechi pu judiu eluwingün ñi welukonkechi ramtuwael: “¿Chew am amuay tüfa, taiñ pepi penoafiel? ¿Amupeay may ti kom püle mülechi pu judiu mew ti kake trokiñke mapu mülelu, kam ti pu judiu tuwünngenolu mew? ");
INSERT INTO arnNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Chem piafulu chey tañi feypiel mew, ‘Kintumuan, welu pemulayan, fey pepi amunoalu am eymün chew tañi müleputuael ta iñche’?” feypi engün. ");
INSERT INTO arnNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Fey puwlu ti kiñelewechi antü mew ka doy ayüfalchi kawiñ, Jesus witralen feypi fütra newentu dungun mew: —Iney rume wüywülele, küpape iñche mew, femngechi ñi pütokoael. ");
INSERT INTO arnNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Chumngechi feypiley ta Wirin Chillka, iñche mew feyentulelu, mülekayay reke kiñe wütrun mongen ko kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Fey tüfa mew, Jesus ayüfuy ñi feypiael tati pu feyentulu kisu mew ñi llowürkeael tati Lif Küme Püllü. Fey ti Lif Küme Püllü am petu küparkenolu, fey Jesus am petu yengeturkenolu ta wenu mapu. ");
INSERT INTO arnNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kiñeke ti pu che allküyelu tüfachi dungun, feypingün: “Fey rüfngey ta tüfachi pelon wentru tati küpayalu tüfachi mapu mew.” ");
INSERT INTO arnNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Fey kakelu feypingün: “Rüfngey ta tüfa ñi Cristongen tati küpayalu tüfachi mapu mew.” Welu kakelu feypi: “Fey no, fey ti Cristo ngelay ñi tuwael ta Galilea mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tati Wirin Chillka feypiley ti Cristo müley ta longko ülmen David ñi yomelchengeael, ka feychi Belen waria mew chew ñi tuwmum ta David, feychi tuwünchengeael.” ");
INSERT INTO arnNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Feymew ti pu che wichu püntülkawi engün Jesus ñi duam. ");
INSERT INTO arnNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kiñekentu ayüfuy ñi püresuyeafiel, welu iney no rume femlaeyew. ");
INSERT INTO arnNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Fey ti llüwatulekelu tati ngillatuwe ruka mew, wiñotuyngün chew ñi mülemum tati pu farisew ka ti pu longkolelu pu saserdote mew, fey ramtungey tati pu llüwatulekelu: —¿Chumngelu am püresu küpal-lafimün tüfachi wentru Jesus pingelu? ");
INSERT INTO arnNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Fey ti pu llüwatulekelu llowdunguy engün: —¡Chumkawnorume ka iney no rume dungukelay chumngechi dungukey ta kisu! ");
INSERT INTO arnNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Feymew ti pu farisew feypifi engün üyawtudungulen: —¿Eymün ka femngechi eluwimün tamün ngünenkangeael? ");
INSERT INTO arnNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Ngüneduamlaymün am ñi feyentunon kiñe no rume taiñ pu longkolelu, ka tati pu farisew no rume? ");
INSERT INTO arnNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Welu tüfeychi pu che kimnofilu tati ley dungu, rume welulkawküley engün ―pi engün. ");
INSERT INTO arnNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Feymew Nikodemo, tati farisew kiñe rupa amulu ñi pemeafiel ta Jesus, fey kisu feypifi ti kakelu pu che: ");
INSERT INTO arnNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Iñchiñ taiñ ley dungu feypilelay ñi püresungeael ta kiñe che, petu kimngenole ñi wesa femün. ");
INSERT INTO arnNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Feymew ti pu farisew llowdungufi ta Nikodemo: —¿Eymi am tuwimi kay ta Galilea? Papeltufinge ti Wirin Chillka, fey kimaymi tañi tripakenon kiñe pelon wentru no rume ta Galilea mapu mew ―pingey. ( ");
INSERT INTO arnNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Fey kake kiñeke ti pu che amutuy engün ñi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Fey Jesus amuy tati Olifu pingechi wingkul mew, ");
INSERT INTO arnNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","fey kangelu antü mew epe wünlu, wiñotuy tati ngillatuwe ruka mew. Fey ti pu che fülkontupueyew, fey kisu anükünuwi ka eluwi ñi kimeltuafiel ti pu che. ");
INSERT INTO arnNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Fey ti kimeltukelu ti ley dungu ka ti pu farisew fey yefingün kiñe domo fey tüfa perkefingün ñi petu ñiwan. Fey elkünupufi engün rangiñ mew chew ñi mülemum fentren che. ");
INSERT INTO arnNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Fey feypifingün ta Jesus: —Kimeltufe, tüfachi domo trenumafiyiñ petu ñiwalu kiñe wentru engu. ");
INSERT INTO arnNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Iñchiñ taiñ ley dungu mew, Moyse werküy ñi ütrüftukangeael kura mew, fey ñi langümngeael fey tüfa famngechi domo. ¿Eymi am, chem pimi kay? ");
INSERT INTO arnNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kisu engün ramtufi tüfachi dungu tañi re kintukaduamafiel femngechi tañi nieael engün chumngechi ñi feypintukuafiel. Welu Jesus potrongnagi ta mapu mew, fey eluwi ñi wiriael kisu ñi changüll kuwü mew. ");
INSERT INTO arnNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Feymew müten diküm ramtukalelu engün am, fey witrakünuwtuy ka feypi: —Kiñekentu eymün mew tati nienolu chem yafkan no rume, wüne ütrüftupe kiñe kura mew. ");
INSERT INTO arnNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ka wiñome potrongnagtuy fey eluwtuy ñi wiriael ta mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Allkülu engün tüfachi dungu, re kiñeke tripayetuy tati dalluntukupafilu ti domo, fey ti wüne tripatulu tati doy putremke wentru ürke. Feymew Jesus kisulewetulu tati domo engu, ");
INSERT INTO arnNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","küme witrakünuwtuy ka ramtufi ti domo: —Papay, ¿chew anta müley tami feypintukupeetew tami langümngeael? ");
INSERT INTO arnNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Fey ti domo llowdunguy: —Kom amutuy engün tatey, Ñidol ―pi. Fey Jesus feypifi ti domo: —Iñche no rume ‘langümngepe’ pilayaeyu, fey amutunge ka wiñome yafkawekilnge.) ");
INSERT INTO arnNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus ka wiñome eluwi ñi kimeltuafiel ti pu che, fey feypi: —Iñche ta pelon reke felelu ta mapu mew. Tüfey tañi müngeltulen inaetew chumkawnorume mülelayay ta dumiñ mew, welu may nieay ta pelon tañi elunieetew ta mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fey ti pu farisew feypifi ta Jesus: —Eymi kisu petu nütramyewimi tami kisutu nütramyewün, fey chem falilay rume. ");
INSERT INTO arnNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Fey llowdungueyew ta Jesus: —Iñche ñi dungupeel rüf dungu mew faliy tati, tunte iñche kisutu dunguñpewli rume. Iñche ta kimnien chew ñi tuwün ka chew ñi amuael, welu eymün ta rüf kimlaymün chew ñi küpan ka chew ñi amuael ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Eymün ramtukadungukefimün ta kiñe che chumngechi tamün ayüel, welu iñche ta femkelan. ");
INSERT INTO arnNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Welu iñche ramtukadungukefuli, kom tañi feypikeelchi dungu rüfngey. Iñche am kisungenolu ñi ramtukacheken, welu may Chaw Ngünechen tañi werküetew, fey ta adkünukey ti dungu iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Welu tüfa feley eymün tamün ley dungu tati wirilelu, femngechi epu che kiñewiyüm ñi dungu, kisu engu ñi dungu falikey. ");
INSERT INTO arnNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ka femngechi, iñche ka tañi Chaw iñchiw kiñewküleyu tayu dungu mew ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Feymew ramtungey: —¿Chew anta müley tami chaw? Fey Jesus llowdungueyew: —Eymün kimlaymün ñi ineyngen ta iñche, ka iñche ñi Chaw no rume, welu kimfulmün ñi ineyngen ta iñche, ka kimafuymün iñche tañi Chaw. ");
INSERT INTO arnNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus feypi tüfachi dungu petu kimeltulu ta ngillatuwe ruka ñi lepün mew chew ñi elngekemum ti ofrenda. Welu iney no rume püresulaeyew, petu puwnolu am tañi medin antü. ");
INSERT INTO arnNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus ka wiñome feypifi ti pu che: —Iñche ta amutuan, fey eymün ta kintumuan, welu layaymün tamün yafkan mew fey tamün pemunofiel. Chew ñi amuael ta iñche, eymün ta pepi amulayaymün. ");
INSERT INTO arnNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Feymew ti longkolechi pu judiu feypi: —¿Chumngelu am feypi taiñ pepi amunoael iñchiñ chew ñi amuael ta kisu? ¿Rakiduamkülepey may ñi kisu langümuwael? ");
INSERT INTO arnNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Feymew Jesus feypi: —Eymün ta nag mapu tuwimün, welu iñche wenu mapu küpan. Eymün ta tüfachi nag mapu mew tuwimün, welu iñche wenu mapu mew tuwün. ");
INSERT INTO arnNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Feymew feypiwpeyiñ tamün layael kisu tamün yafkan mew, eymün am ta feyentunolu tañi ineyngen ta iñche, feymew layaymün kisu tamün yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Feymew ti pu judiu ramtufi engün ta Jesus: —¿Iney anta eymi? Fey Jesus llowdunguy: —Ellaka mew tañi feypiel ñi chem chengen ta iñche, feymew ");
INSERT INTO arnNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","rume fentren dungu nien tamün feypiwafiel eymün am welulkawkülelu. Welu ñi Chaw tañi werküetew feypikey ta rüfngechi dungu, tañi feypikeetew ta kisu, feychi dungu ta feypiwkeyiñ ta eymün. ");
INSERT INTO arnNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Welu ti pu judiu engün ngüneduamlay tañi nütramelngeel engün ta Chaw Ngünechen ñi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Feymew Jesus feypifi ti pu che: —Feychi eymün wenuntu püramfilmün iñche tati Wentrukünuwpalu, fey wüla kimmuan ñi ineyngen ta iñche, ka femkelan chem dungu rume re kisu ngünewün. Iñche feypiken Chaw ñi kimeletewchi dungu müten. ");
INSERT INTO arnNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iñche ñi Chaw tañi werküetew müley iñche engu, iñche ñi Chaw ta kisukünukelaenew, fey iñche am rumel femkelu kisu ñi ayükeelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Feymew Jesus, feypilu tüfachi dungu, rume fentren che feyentuy kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesus feypiyefi kiñeke ti longkolechi pu judiu feyentulu ta kisu ñi feypielchi dungu mew: —Eymün ta müngeltufilmün iñche ñi dungu, rüf dungu mew eymün iñche ñi pu disipulungeymün. ");
INSERT INTO arnNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kimafimün tati rüf dungu, fey ti rüfngechi dungu lifrekünutuaeymünmew. ");
INSERT INTO arnNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Fey tati longkolechi pu judiu llowdunguy: —Iñchiñ ta Abraam ñi yomel pu che, fey chumkawnorume ka iney no rume ta püresukonaniekelaeiñmew. ¿Chumngelu am eymi feypimi taiñ lifrengetuael? ");
INSERT INTO arnNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Feymew Jesus feypi: —Rüf dungu feypiwayiñ itrokom tati yafkakelu püresulekey reke ta yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kiñe püresukona rumel koneltukelay ta kiñe reñmache mew, welu kiñe fotüm feyngey ñi rumel koneltuleael ñi reñmache mew. ");
INSERT INTO arnNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Fey femngechi, tati fotüm lifrekünutuelmünmew, eymün feyngeay tamün lifrengetun. ");
INSERT INTO arnNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Dew kimnien ta Abraam ñi yomel pu chengen ta eymün, welu ayüleymün tamün langümmuafiel llowmamunofiel am iñche tañi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iñche femken tañi Chaw mew ñi pekeelchi dungu, fey eymün kay femkeymün tamün kangelu chaw ñi femkeelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Feymew ti pu judiu feypi: —¡Kangelu no tatey! ¡Iñchiñ taiñ nieelchi chaw Abraam pingey! ―pi. Welu Jesus llowdunguy: —Eymün ta rüf mew Abraam ñi reñma pu chengefulmün, femafuymün kisu tañi femel. ");
INSERT INTO arnNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Welu may tunte dew feypiwfuyiñ ti rüfngechi dungu Ngünechen tañi kimeletew, fey eymün ayüleymün tamün langümmuafiel. ¡Abraam ta chumkawnorume femngechi femlay! ");
INSERT INTO arnNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Eymün ta femkeymün chumngechi ñi femkeel kangelu chaw tamün nieel. Feymew ti pu judiu feypi: —¡Iñchiñ ta kiñe yalltuku che no! Nieiñ kiñe chaw müten, Ngünechen llemay. ");
INSERT INTO arnNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Fey Jesus llowdunguy: —Rüf feyngefule tamün chawyefiel ta Ngünechen, eymün ta piwkeyemuafun, iñche am küpalu ta kisu mew, fey fewla tañi mülepan tatey. Iñche küpalan ta re kisu duam, welu Ngünechen ta werküenew. ");
INSERT INTO arnNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Chumngelu am eymün longkontukulaymün iñche ñi kimelelchi dungu? Eymün am rüf mew ayükenolu tamün allkütuafiel iñche ñi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Eymün tamün chaw ta weküfü, fey eymün ta kisu mew koneltuleymün, ka ayükeymün tamün femael kisu ñi ayükeelchi dungu. Weküfü ta kiñe langümchefe llituka mew müten. Chumkawnorume inakelafi ti rüfngechi dungu, ka chumkawnorume feypikelay ti rüfngechi dungu. Femngechi koyla dunguyüm, dungukey ñi chumngen ta kisu. Koylangelu am, fey kisu mew tripakey kom koyla dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Welu iñche am feypikelu ti rüfngechi dungu, eymün ta feyentumukelan. ");
INSERT INTO arnNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Iney am feypiafeymünmew iñche ñi nien ta yafkan? Fey iñche feypili ti rüfngechi dungu, ¿chumngelu am feyentumukelan? ");
INSERT INTO arnNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tati mülelu Ngünechen mew, allkütukey Ngünechen ñi dungu. Welu eymün am Ngünechen mew mülenolu, ayülaymün tamün allkütuael. ");
INSERT INTO arnNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Feymew tati longkolechi pu judiu feypieyew: —Rüfngey taiñ feypiken eymi kiñe Samaria tuwünchengen ka tami konweküfülen. ");
INSERT INTO arnNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus llowdunguy: —Konweküfülelan ta iñche. Tañi femkeelchi dungu mew püramyekefiñ tañi Chaw Ngünechen, welu eymün püramyemukelan. ");
INSERT INTO arnNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Iñche ayülan tañi re kisu püramyengeael, welu müley kiñe tati ayülelu iñche ñi püramyengeael, fey ñi Chaw kisu ta adniey kom dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ka femngechi rüf dungu feypiwayiñ ta iney rume müngeltufile iñche ñi dungu, chumkawnorume lalayay ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Feymew ti pu judiu llowdunguy: —Fewla ta küme kimiyiñ tami konweküfülen. Abraam ka ti pu pelon wentru layey engün, fey eymi feypimupeiñ: ‘Tati müngeltulu iñche ñi dungu, chumkawnorume lalayay.’ ");
INSERT INTO arnNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Eymi anta wünenngeymi taiñ chaw Abraam mew? Kisu ta lay, ka ti pu pelon wentru ka layey engün. ¿Chumngechi chengelu trokiwküleymi am? ");
INSERT INTO arnNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Feymew Jesus llowdunguy: —Iñche ta re feypipelan kisutu püramyewli, tañi püramyewün ta chem falilayafuy rume, welu ñi püramyekeetew iñche, fey ta iñche ñi Chaw tati, fey iñchiñ taiñ Ngünechen tamün pikeel. ");
INSERT INTO arnNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Welu eymün ta kimlafimün, fey iñcheke ta kimniefiñ. Fey kimlafiñ pifuli, iñche ta rume koylangeafun eymün reke. Welu rüfngey tañi kimniefiel, fey ka müngeltuñmakefiñ kisu ñi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Eymün tamün kuyfi tuwün em Abraam pingelu, ayüwi allkülu tati feypikünuelchi dungu iñche mew, feymew rume ayüwi, fey Abraam kimetew am ñi ineyngen ta iñche ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Fey ti pu judiu feypifi engün ta Jesus: —Petu nielaymi kechu mari tripantu no rume, ¿fey feypimi tami pefiel ta Abraam? Kiñe wedwed che reke ta feypimi. ");
INSERT INTO arnNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus llowdungueyew: —Rüf dungu feypiwayiñ iñche müleken Ngünechen iñchiw kuyfi mew petu ñi mülenon rume ta Abraam. ");
INSERT INTO arnNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Feymew kisu engün nüy kura tañi ütrüftukayafiel, welu Jesus ellkawi ka tripatuy ti ngillatuwe ruka. ");
INSERT INTO arnNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Amulelu Jerusalen ñi rüpü mew, Jesus pefi kiñe wentru trawmalelu. ");
INSERT INTO arnNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Fey Jesus ñi pu disipulu ramtueyew: —Kimeltufe, ¿chumngelu am tüfachi wentru choyüngelu müten trawmangey? ¿Kisu ñi fütakeche ñi yafkan mew pemay kam kisu ñi yafkan mew? ");
INSERT INTO arnNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus llowdunguy: —Kisu ñi yafkan mew no ka ñi chaw ñi yafkan mew no rume. Fey tüfa may kisu mew ñi pengelngeael ta Ngünechen ñi nien ta pepiluwün. ");
INSERT INTO arnNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Petu tañi mülen pelon antü, müley taiñ küdawael tüfey tañi werküngeelchi küdaw mew, fey pun ta küpalewiyey, fey iney rume ta pepi küdawlayay. ");
INSERT INTO arnNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Petu ñi mülen ta iñche tüfachi mapu mew, iñche ta pelon reke mülen ta mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Fey dew feypilu tüfa, Jesus tofkütuy mapu mew, fey ñi kowün mew dewmay pichin fotra, fey ilpuyelfi ñi nge mew ti trawma. ");
INSERT INTO arnNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ka pürüm feypifi: —Amunge tami küllumtuael Siloe pingechi estanke ko mew (tüfa feypin ürke: “tati werküel”). Fey ti trawma amuy ka küllumtumey, fey wiñometulu, dew peloletuy. ");
INSERT INTO arnNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Fey ti pu karukañma ta kuyfi ñi kimniekeetew ñi ngillatupülatakefel ramtuwingün: —¿Tüfa no am tati anükünuwkefulu ñi ngillatupülatayael? ");
INSERT INTO arnNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kiñekentu feypingün: —May, kisu tati. Kakelu feypingün: —Fey no, kisu no tati, tunte kisu femngekafuy rume. Welu kisu feypiley: —May, iñche tati. ");
INSERT INTO arnNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Feymew ramtungey: —¿Fey chumngechi am pepi pelotuymi? ");
INSERT INTO arnNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Fey ti wentru llowdunguy: —Üyechi wentru, ta Jesus pingelu, dewmay fotra, fey tüfey mew ilpuyüñmaenew ñi nge, fey feypienew: ‘Amunge ti Siloe pingechi estanke ko mew, fey küllumtumenge’. Iñche amun, feymew küllumtulu müten iñche, pepi pelotun. ");
INSERT INTO arnNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Feymew ramtueyew ti pu che: —¿Chew anta müley üyechi wentru? Fey kisu feypi: —Kimlan chew ñi mülen. ");
INSERT INTO arnNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Feychi antü Jesus dewmalu pichin fotra ka pelolfilu ti trawma, tati ürkütun antü ürke. Feymew yengey ti pu farisew mew tati trawmangekefulu. ");
INSERT INTO arnNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fey kisu engün ramtukafi ñi chumngechi ñi pelotun. Fey kisu llowdunguy: —Ilpuyelenew fotra ñi nge mew, fey küllumtutun, feymew pelotun. ");
INSERT INTO arnNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kiñekentu ti pu farisew feypieyew: —Tüfa tati femngechi dungu femlu mülelay ta Ngünechen mew, fey yamnofilu am tati ürkütun antü. Welu kakelu feypiyey engün: —¿Chumngechi kay pepi femafuy Ngünechen ñi afmatufalchi dungu, kiñe yafkafengele? Fey tüfa famngechi welukonke püntülkawi ta kisu engün. ");
INSERT INTO arnNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Fey wiñome ramtungey ti trawmalekefulu: —Fey elutuetew tami pelotuael, ¿chem pileymi kay eymi kisu mew? Kisu llowdunguy: —Iñche feypilen kay tañi kiñe pelon wentrungen. ");
INSERT INTO arnNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Welu ti longkolelu pu judiu mew pilayngün ñi feyentuael ñi trawmalekefel ti wentru, fey ñi peloletun, fey amul mütrümngey ti trawmalekelu ñi fütakeche. ");
INSERT INTO arnNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Fey ramtungey ti ngen fotüm: —¿Fey tüfa am tami fotüm? ¿Feyngey am tañi choyüngelu ñi trawmalen tüfachi wentru? ¿Chumngechi am fewla pepi peloletuy? ");
INSERT INTO arnNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kisu ñi chaw ka ñi ñuke llowdunguy: —Kimniefiyu. Tüfa ta iñche ñi fotüm, fey we pichichengelu ñi trawmalen, ");
INSERT INTO arnNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","welu kimlayu chumngechi ta tüfa ñi pepi peloletun, ka femngechi kimlayu rume iney ñi eluetew ñi pelotuael. Ramtufimün ta kisu, dew fütachelewey tati. Kisu feypiaeymünmew ti nor dungu ―pi engu. ");
INSERT INTO arnNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kisu ñi chaw famngechi feypi re llükan mew, tati longkolechi pu judiu kiñewlu engün am tañi wemünentuafiel ti sinagoga mew iney rume ta kimle ta Jesus ñi Cristongen Ngünechen ñi werküel. ");
INSERT INTO arnNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Feymew feypi ñi chaw ka ñi ñuke: “Ramtullefimün may ta kisu. Dew füta wentrulewey tati” ―pi engu. ");
INSERT INTO arnNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Feymew tati longkolelu pu judiu mew ka wiñome mütrümfingün tati trawmangekefulu, fey feypifi engün: —Feypimuiñ ti nor dungu Ngünechen mew. Iñchiñ küme kimnieiñ ta tüfeychi wentru ñi yafkafengen. Eymi kay ¿chem pileymi? ");
INSERT INTO arnNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tati trawmalekefulu llowdunguy: —Iñche kimlan ñi yafkafengen pemay kam ñi femngenon. Kiñe dungu müten kimnien ta iñche: trawmangekefun, welu fewla peloletun. ");
INSERT INTO arnNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ka wiñome ramtufi engün: —¿Chem chumeymew am fe? ¿Chem chumi tami peloltuaetew? ");
INSERT INTO arnNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Fey llowdunguy ti trawmalekefulu: —Dew feypiwiyiñ tati, welu duamkünumulan. ¿Chumngelu am ayüleymün tamün wiñome feypiwafiel? ¿Eymün anta ayüleymün kay tamün inayafiel? ");
INSERT INTO arnNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Feymew wesa pifingün, ka feypifingün: —Eymi inakefimi ta üyechi wentru, welu iñchiñ inakefiyiñ ta Moyse ñi ley dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Iñchiñ kimnieiñ Ngünechen ñi dungufiel ta Moyse. Welu tüfachi wentru kimlafiyiñ rume chew tañi tripan. ");
INSERT INTO arnNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Fey ti wentru llowdunguy: —¿Chem dungu am tüfa? Eymün kimlaymün chew ñi tripan, welu iñche elutuenew ñi pelotuael. ");
INSERT INTO arnNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Küme kimnieiñ Ngünechen tañi allkütukenofiel tati pu yafkafe. Allkütuñmakefi ñi ngillatun nor dungu mew püramyekeetew müten ka femkelu Ngünechen ñi ayükeelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Chumkawnorume nütramyengekelay ta iney rume tañi elutukefiel ñi pelotuael ñi nge ta kiñe che tati trawmalen choyüngelu. ");
INSERT INTO arnNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Fey tüfachi wentru küpanofule ta Ngünechen mew, pepi chumlayafuy rume. ");
INSERT INTO arnNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Feymew feypingey: —Eymi kay, choyüngelu müten trawmangelu tami yafkafengen mew, ¿ayüleymi am tami kimeltumuafiel Ngünechen ñi dungu? Fey wemünentungey ti sinagoga mew. ");
INSERT INTO arnNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus kimürkey ñi wemünentungen ñi illamtuaetew ti pu che tati trawmalekefulu, feymew pewlu Jesus engu, ramtufi: —¿Feyentuleymi anta eymi tati Wentrukünuwpalu mew? ");
INSERT INTO arnNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ti trawmalekefulu feypi: —Ñidol, feypien ñi ineyngen tati Wentrukünuwpalu, femngechi tañi feyentuael kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Fey Jesus llowdungueyew: —Dew peniefimi, tami petu dunguetew. ");
INSERT INTO arnNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Feymew ti wentru lukunagi Jesus ñi inafül ka feypi: —Feyentun tati, Ñidol. ");
INSERT INTO arnNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus ka pürüm feypieyew: —Iñche küpan tüfachi mapu mew tañi ramtukadunguafiel ñi chumngechilen ta che Ngünechen mew, femngechi tati trawmangelu ñi pelotuael, fey ka femngechi tati pelolelu trokiwkülelu ñi trawmangetuael reke. ");
INSERT INTO arnNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kiñekentu ti pu farisew mülelu kisu ñi fül mew, allkütulu tüfachi dungu, ramtueyew: —¿Iñchiñ anta ngenokimünngeiñ kiñe trawma reke? ");
INSERT INTO arnNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Fey Jesus llowdungueyew: —Eymün ta kiñe trawma reke ngenokimün chengefulmün, nielayafuymün ta yafkan, welu eymün am feypilu tamün kimchengen, küme kimfalküley tamün yafkafengen. ");
INSERT INTO arnNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Feymew Jesus feypi: “Rüf dungu feypiwayiñ tati konpunolu ti wülngiñ koral ufisa mew, welu may kañpüle ringkükonpulu, fey ta weñefe ka saltiachefe. ");
INSERT INTO arnNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Welu tati kamañ femkelay, konpukey may ti wülngiñ mew chew müley tati llüwatuniefilu ti pu ufisa. ");
INSERT INTO arnNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ti wülngiñ koral mew mülechi llüwatulelu nülalkeeyew ti puerta, fey ti kamañ mütrümkey kake kiñeke ñi pu ufisa kisuke ñi üy mew, fey ñi pu ufisa kimüñmakeeyew ñi dungun. Fey kisu nentukefi tati koral mew. ");
INSERT INTO arnNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Fey dew itrokom tripayüm engün, fey wüne trekalekey kisu engün mew, fey ñi pu ufisa inakeeyew kimüñmaetew am ñi dungun. ");
INSERT INTO arnNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Welu inakelafi engün ñi kimnienoel, fey ta lefmawkefingün, fey kimüñmakenofilu am ñi dungun.” ");
INSERT INTO arnNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus feypieyew tüfachi adkünu dungu, welu kisu engün longkontukulay kisu ñi ayülefel ñi femngechi feypifetew. ");
INSERT INTO arnNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kimüñmanofilu engün am ti adkünu dungu, feymew Jesus ka wiñome feypieyew engün: “Tüfa rüfngechi dungu feypiwayiñ: Iñche tati llüwatulekelu wülngiñ koral mew chew konpukey tati pu ufisa. ");
INSERT INTO arnNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Welu kuyfi kom tati wüne küpayelu iñche mew, fey tüfa engün ta weñefe ka saltiachefe, fey ti pu ufisa müngeltulaeyew. ");
INSERT INTO arnNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iñche tati llüwatulekelu ti wülngiñ koral mew chew konpukey ti pu ufisa, fey tati konpalu iñche mew, montuay. Kiñe ufisa reke feleay. Konputuay ka tripatuay, fey ka peay kachu. ");
INSERT INTO arnNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tati weñefe küpakey tañi weñeael ka langümael ka ñi apümkayael, welu iñche küpan tañi nieael engün ta rumel mongen, ka rume küme mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Iñche tati küme kamañkefilu ti ufisa. Tati kamañkefilu ti ufisa wülkey ñi mongen kütu ñi pu ufisa mew. ");
INSERT INTO arnNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Welu tati küdawtukelu ayükey ñi kullingeael müten, femngechi pefiyüm ñi küpan ti trapial, elkünukefi ti pu ufisa fey kisu lefmawkey, fey kisu ta kamañngenolu am ka kisu ngenngenolu am ti pu ufisa mew. Fey ti trapial lefkontukefi ti pu ufisa ka püntülkakefi wall püle. ");
INSERT INTO arnNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Üyechi wentru lefmawkey, fey kisu am ayülelu ñi kullingeael müten, welu falintukelafi ti pu ufisa. ");
INSERT INTO arnNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Welu iñche tati küme kamañkefilu ti pu ufisa. Chumngechi tañi Chaw kimnieenew, fey iñche kimniefiñ tañi Chaw, ka femngechi iñche kimniefiñ iñche tañi pu ufisa, fey kisu engün kay kimnieenew ta iñche. Iñche wülken ñi mongen kütu tañi pu ufisa mew. ");
INSERT INTO arnNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ka femngechi nien ti kakelu ufisa mülenolu tüfachi koral mew, fey kisu engün ka müley tañi küpalafiel. Kisu engün ka müngeltuaenew, fey müleay kiñe kechan müten ka kiñe kamañ müten. ");
INSERT INTO arnNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Fey iñche am wülkelu ñi mongen tati pu ufisa mew tañi ka wiñome mongetuael, feymew iñche ñi Chaw piwkeyeenew. ");
INSERT INTO arnNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Iney no rume pepi langümlayafenew, welu iñche kisu wülafiñ ñi mongen iñche ñi pin mew. Iñche konpalen tañi wülafiel ñi mongen ka ñi wiñome mongetuael. Fey tüfachi dungu werküenew iñche ñi Chaw” pi. ");
INSERT INTO arnNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Feymew ti longkolelu pu judiu mew allkülu engün tüfachi dungu, wiñome wichu püntülkawi engün. ");
INSERT INTO arnNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Rume fentren ta kisu engün feypiyey: —¿Chumael anta feyentukefimün, weküfü niele ka wedwedkülele? ");
INSERT INTO arnNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Welu kakelu feypingün: —Iney rume niele kiñe weküfü femngechi dungulayafuy. ¿Kiñe weküfü am elupeafuy ñi pelotuael tati pu trawma? ―pi engün. ");
INSERT INTO arnNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Dew pukemkülerkey, fey Jerusalen waria mew petu ayüwürkey ti pu che ti kawiñ antü mew tañi tukulpangekemum feychi wiñome küme elngetulu ti ngillatuwe ruka. ");
INSERT INTO arnNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus mülerkey ti ngillatuwe ruka mew, ka miyawürkey Salomon tañi lepün püle. ");
INSERT INTO arnNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Feymew ti longkolechi pu judiu ramtueyew: —¿Tuntepu mew anta fente epuduamelniemuaiñ taiñ feyentunoael? Eymi ta Cristongelmi kiñe rupa mew küme feypimuaiñ. ");
INSERT INTO arnNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus llowdungueyew: —Dew feypiwiyiñ ta eymün, welu feyentumulan. Feytichi dungu tañi femkeel, femken tañi Chaw ñi pepiluwün mew. Fey ta fente küme kimfali, ");
INSERT INTO arnNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","welu eymün ta feyentumulan, eymün am iñche ñi ufisa no. ");
INSERT INTO arnNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Iñche ñi pu ufisa kimüñmakeenew ñi dungun, ka iñche ta kimniefiñ, fey kisu engün inakeenew. ");
INSERT INTO arnNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Iñche ta eluafiñ rumel mongen, ka chumkawnorume aflayay engün ka iney no rume müntuñmalayaenew. ");
INSERT INTO arnNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Iñche ñi Chaw ñi eluetew doy wünenküley itrokom mew, fey iney no rume pepi müntulayafeyew tañi eluetew tañi Chaw. ");
INSERT INTO arnNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Fey iñche tañi dew feypiel iñche ñi Chaw iñchiw kiñengeyu müten ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Fey ti longkolelu pu judiu mew wiñome nüy engün ta kura tañi ütrüftukayaetew. ");
INSERT INTO arnNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Welu Jesus feypieyew: —Iñche ñi Chaw ñi pepiluwün mew rume fentren kümeke dungu femün eymün tamün adkiñ mew. ¿Chem dungu mew müngell anta ütrüftukamuan kura mew? ");
INSERT INTO arnNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Fey ti pu judiu llowdungueyew: —Ütrüftukawayiñ kura mew tati afmatufal dungu tami femel mew no, welu may tami dungun am fütra welulkawkülelu ta Ngünechen mew. Eymi ta kiñe wentru müten, welu kisutu eymi Ngünechen iñche pimi. ");
INSERT INTO arnNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus feypifi ti pu judiu: —Iñche ta wesa dungulan. Eymün tamün ley dungu mew wirintukuley: ‘Iñche feypin eymün ta pichike ngünechen.’ ");
INSERT INTO arnNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Iñchiñ kimnieiñ tañi feypilen tati Wirin Chillka, ngelay taiñ kimlan piafiel: Ngünechen ñi feypifiel pichike ngünechen ta tüyechi pu che tañi wirilelfiel kisu ñi werkün dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Welu doyelchi may iñche pichi ngünechen ta Ngünechen wichuentuenew ta iñche ka werküenew ta mapu mew, ¿chumngelu am feypimün eymün iñche ñi wesa pin iñche Ngünechen ñi Fotüm tañi pin mew? ");
INSERT INTO arnNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Fey iñche feypili fey ta famngechi, fey femnoli ti küdaw iñche ñi Chaw tañi femkeel, feyentumukeeli. ");
INSERT INTO arnNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Welu feyngelu am iñche ñi femken tüfachi dungu, tunte feyentunolmün rume iñche mew, feyentufimün ti küdaw iñche tañi femkeel, famngechi tamün küme kimael tañi Chaw ñi mülen iñche mew ka iñche ñi mülen ta Chaw mew. ");
INSERT INTO arnNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Feymew ka kiñe rupa ayüfuy ñi püresuafiel engün ta Jesus, welu Jesus kiñe püle tripay, fey amutuy. ");
INSERT INTO arnNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Feymew ta Jesus amuy Jordan ñi tripawe antü püle, fey üye mew mülewepuy, tati lelfün mew chew Juan wünelu mew mekefuy ñi fawtisachen. ");
INSERT INTO arnNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Rume fentren che amuy ñi pemeaetew, ka feypi engün: —Rüf feyngey, tunte Juan femlay kiñe afmatufal dungu no rume, kom tañi feypiel tüfachi wentru mew feyngey. ");
INSERT INTO arnNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Fey rume fentren che feyentuy Jesus mew tüyechi lelfün mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mülerkey kiñe kutrankülechi wentru Lasaru pingelu, Betania waria mew Maria ka Marta ñi lamngen. ");
INSERT INTO arnNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Fey tüfachi Maria, Lasaru ñi lamngen, tati domo ürke tukulelfilu perfume Ñidol tañi namun mew, ka piwümeltufilu kisu ñi tünay longko mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Femngechi tati epu lamngenwen feypifalfi engu ta Jesus: —Ñidol, eymi tami weni ta kutranküley. ");
INSERT INTO arnNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesus, kimlu tüfachi dungu, feypi: —Tüfachi kutran ta rumel langümlayaeyew, welu kümeay tañi pengelngeael Ngünechen ñi fütra pepiluwün, ka femngechi ta Ngünechen ñi Fotüm tañi fütra pepiluwünngen. ");
INSERT INTO arnNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus rume piwkeyeniefuy ta Marta ka Maria ñi domo lamngen ka Lasaru, ");
INSERT INTO arnNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","welu feypingelu ta Lasaru ñi kutrankülen ka mülewerkey epu antü chew ñi mülepuelchi lelfün mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Feymew wüla feypifi kisu ñi pu disipulu: —Ka kiñe rupa amuiñ ta Judea mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ti pu disipulu feypieyew: —Kimeltufe, newe chumül müten nga tati pu judiu mülelu üyechi trokiñ mapu mew, ayüfuy engün tami langümafetew re kura mew. ¿Ka wiñome küpa amuymi ta üyew? ");
INSERT INTO arnNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus feypi: —¿Feyngelay anta antü ñi nien ta mari epu ora? Fey kiñe che miyawiyüm ta antü ñi pelon mew, mutrurkelay, fey peniefilu am ta pelon ñi mülen ta tüfachi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Welu kiñe che miyawle ta pun, mutrurafuy, fey am nienolu ta pelon. ");
INSERT INTO arnNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ka amul feypiley: —Taiñ weni Lasaru ta dew umawtuy, fey amuan tañi trepelmetuafiel. ");
INSERT INTO arnNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Fey ti pu disipulu feypieyew: —Ñidol, fey kisu küme umawkülele, kisu mongetuay. ");
INSERT INTO arnNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Welu tüfey ñi feypiel ta Jesus fey ñi dew lan ta Lasaru, welu ti pu disipulu rakiduamingün ñi dungumeken re tati umawtun mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Feymew Jesus fente küme feypi wüla: —Lasaru ta dew lay. ");
INSERT INTO arnNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Fey iñche rume ayüwkülen tañi mülenon mew ta üyew, fey femngechi doy kümelu am ta eymünngealu tamün feyentuael. Welu amuiñ taiñ pemeafiel. ");
INSERT INTO arnNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Feymew Tomas, tati epuntun pingelu, feypifi ti kakelu pu disipulu: —Iñchiñ ka amuaiñ taiñ layael Jesus iñchiñ. ");
INSERT INTO arnNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Fey Jesus puwlu, kimpuy meli antü ñi dew rüngalngen ta Lasaru. ");
INSERT INTO arnNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania waria mülerkey Jerusalen ñi fülpüle kiñe küla kilometro, ");
INSERT INTO arnNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","fey rume fentren judiu longkolelu amurkey engün ñi witranngemeael ta Marta ka Maria mew, tañi yafüldungumeafiel ñi lan mew kisu engu ñi lamngen. ");
INSERT INTO arnNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Feymew Marta kimlu ta Jesus ñi fülpan, tripay ñi llowmeafiel, welu Maria mülewey ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Fey Marta feypifi ta Jesus: —Ñidol, eymi mülekefulmi tüfa mew, iñche ñi lamngen lalayafuy. ");
INSERT INTO arnNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Welu iñche kimnien fachantü Ngünechen ta eluafeymew tami ngillatufielchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus llowdungueyew: —Eymi tami lamngen ta wiñomongetuay. ");
INSERT INTO arnNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta feypi: —May, dew kimnien tañi wiñomongetuael, feychi tati pu la wiñomongetule ti afaelchi antü mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Feymew Jesus feypieyew: —Iñche mew müley ta wiñomongetun ka tati mongen. Tati feyentulu iñche mew, tunte lallefule rume, mongetuay. ");
INSERT INTO arnNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Fey kom tüfeychi petu mongelelu ka feyentulele iñche mew chumkawnorume lalayay. ¿Feyentuymi kay tüfachi dungu? ");
INSERT INTO arnNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta feypi: —May, Ñidol, iñche feyentun eymi tami Cristongen, Ngünechen tañi Fotüm, tati felelu ñi küpayael ta mapu mew ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Fey dew feypilu tüfachi dungu, Marta amuy ñi mütrümafiel ñi lamngen Maria, fey ellka feypifi: —Tati kimeltufe ta mülepay tüfa mew ka ‘küpape’ pieymew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Fey pürüm ka müten allkülu, Maria witrapüray ka amuy ñi pemeafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus petu konpurkelay tati waria mew, mülerkey ti lelfün mew chew ñi pewün ta Marta engu. ");
INSERT INTO arnNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Fey pengelu Maria ñi witrapüran ka ñi rume matu tripan, fey ti pu judiu mülepalu kisu ñi ruka mew, tañi yafülpapeetew, inaeyew, rakiduamlu engün am ñi amuael ta Maria ti küfwe mew ñi ngümameael. ");
INSERT INTO arnNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Feymew puwlu Maria chew ñi mülemum ta Jesus, lukunagpuy kisu ñi namun püle, fey feypi: —Ñidol, mülekefulmi tüfa mew, iñche ñi lamngen lalayafuy. ");
INSERT INTO arnNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesus, ka femngechi pefilu ti pu judiu ñi ngüman puwyelu Maria engün, rume fütra kutrantupiwkey ka weñangkünagi, ");
INSERT INTO arnNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","feymew ramtufi: —¿Chem eltun mew elmefimün? Fey feypingün: —Küpange, Ñidol, tami peafiel. ");
INSERT INTO arnNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Fey Jesus ngümay. ");
INSERT INTO arnNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Feymew ti pu judiu feypingün: —¡Leliwülfimün, müna piwkeyerkefuy tati! ");
INSERT INTO arnNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Welu kiñekentu ti pu judiu feypiyey: —Tüfa nga peloltufi tati pu trawma, fey ¿pepilpelayafuy may ñi lanoafel ta Lasaru? ");
INSERT INTO arnNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus, ka wiñome rume fütra müleweduamkülewey, fey fülkonpuy ti küfwe mew. Kiñe lolo ürke, fey ñi konwe takulerkey kiñe kura mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus feypi: —Kiñe püle nentufimün ti kura. Marta tati la ñi lamngen feypi: —Ñidol, dew wesa nümüpelay tati, meli antülu am ñi tukukünungeel küfwe mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus llowdunguy: —¿Feypipelaeyu ama, eymi feyentulmi, peaymi ta Ngünechen ñi fütra pepiluwün? ");
INSERT INTO arnNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Fey kiñe püle nentungey ti kura. Jesus lelipüray wenu mapu, fey feypi: —Chaw Ngünechen, mañumtueyu eymi am allkütuñmakefiel ñi ngillatun. ");
INSERT INTO arnNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iñche kimnien rumel tami allkütukefiel, welu feypieyu tañi küme nor duamam tüfachi pu che mülelu tüfa mew femngechi ñi feyentuael engün eymi tami werküfiel. ");
INSERT INTO arnNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Fey dew feypilu tüfa, wirari: —¡Lasaru, tripatunge tüfey mew! ");
INSERT INTO arnNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Fey ti dew lafulu tripapatuy, ñi epu kuwü ka ñi epu namun trariley kiñe pañu mew ka ñi ange munulküley kiñe safana mew, fey Jesus feypi: —Nentupürolfimün ka elufimün ñi amutuael. ");
INSERT INTO arnNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Fey Lasaru ñi wiñomongetun mew, feyentuy rume fentren pu judiu longkolelu tati amuyelu ñi yafülmeafiel ta Maria, fey pefilu engün am ñi femün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Welu kakelu pu judiu, tati feyentunolu, amuy engün ta Jerusalen ñi pemeafiel ti pu farisew, fey nütramelpufi engün ta Jesus tañi femün. ");
INSERT INTO arnNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Feymew ti pu farisew ka ti pu longkolelu tati pu saserdote mew, trawülfi engün tati longkolechi putrem fütake judiu, fey feypifingün: —¿Chem chumaiñ am? Tüfachi wentru ta femmekey rume fentren afmatufalchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Fey elukünufiliyiñ ñi femmekeael ti afmatufal dungu itrokom che feyentuay kisu mew, fey ti pu romache ñi awtoridad küpayay engün ka teyfükayafingün taiñ ngillatuwe ruka ka langümafi kom che mülelu taiñ trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Feymew ta kiñe kisu engün, Kayfas pingelu, fey tüfa wünen longkolerkey pu saserdote mew tüyechi tripantu, fey Kayfas feypieyew engün: —Eymün ta kimlaymün chem no rume. ");
INSERT INTO arnNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ka ngüneduamkelaymün rume tañi doy kümeael eymünngealu ñi layael kiñe wentru müten tati waria che mew, welu tañi lanoael kom che mülelu taiñ trokiñ mapu mew ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Welu Kayfas feypilay tüfa re kisu tañi ngünewün mew, fey kisu am longkolerkelu ti pu saserdote mew tüfeychi tripantu, famngechi feypi Ngünechen tañi femngechi rakiduameletew, Jesus tañi layael tati pu judiu ñi trokiñche mew. ");
INSERT INTO arnNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Fey tüfachi trokiñche mew müten ürke no, welu may ka femngechi tañi trawültuafiel itrokom ta Ngünechen ñi pu yall tati kom chüf mapu mülelu. ");
INSERT INTO arnNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Feymew tüyechi antü mew müten tati longkolelu pu judiu mew adkünuyngün ñi langümafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Feymew ta Jesus doy miyawelay ti longkolechi pu judiu ñi adkiñ mew. Tripatuy ta Judea trokiñ mapu mew, fey amutuy kiñe lelfün mülelu tati uwe mapu mew, kiñe waria mew Efrain pingelu. Üyew mülewepuy kisu ñi pu disipulu engün. ");
INSERT INTO arnNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pülleleparkey dewma ti pu judiu ñi Paskua kawiñ antü, fey rume fentren che müleyechi waria mew amuyey ta Jerusalen ñi müngeltuafiel femngechi ñi wüne femael tati wimtun liftuwün dungu petu ñi akunon ta Paskua kawiñ. ");
INSERT INTO arnNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Miyawürkey engün ñi kintuyawülfiel ta Jesus, fey welukonke ramtuwingün ti ngillatuwe ruka mew: —¿Chem pimün kay? ¿Küpapeay may tüfachi kawiñ mew kam femlayay chey? ");
INSERT INTO arnNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fey ti pu farisew ka ti pu longkolelu ti pu saserdote mew feypikünufi ti pu che femngechi tañi feypiael iney rume kimle chew ñi mülen ta Jesus, femngechi tañi püresuafiel engün. ");
INSERT INTO arnNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kayu antülewelu ñi akuael tati pu judiuche ñi Paskua kawiñ, Jesus amuy ta Betania waria mew, chew mülekefuy ta Lasaru, tüfey ta kisu ñi wiñomongeltuel. ");
INSERT INTO arnNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Üyew pepikalngey ti pun iyael Jesus tañi poyengeael. Marta mekerkey ñi poyechen, fey Lasaru ürke kiñe tati anülelu mesa mew, imekelu ta Jesus engün. ");
INSERT INTO arnNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria küpalüy kiñe küla pataka gramo perfume, re nardongelu, ka rume falilu, fey tukulelfi Jesus ñi namun mew ka pürüm piwümeltufi kisu ñi tünay longko mew. Fey ti ruka küme nümülewey ti perfume mew. ");
INSERT INTO arnNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Feymew Juda Iskariote, kiñe tati pu disipulu ürke ti wültukufilu ta Jesus, fey feypi: ");
INSERT INTO arnNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Chumngelu am fendengelay tüfachi perfume küla pataka denario mew, fey ñi elungeael ti pu pofre? ");
INSERT INTO arnNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Welu Juda feypilay tañi poyeniefiel mew tati pu pofre, fey kisu am weñefengefulu, ka femngechi kisu nierkey ti kütrüng pülata kom kisu engün ñi pülata, fey weñekerkefuy tati tukuel ti kütrüng pülata mew. ");
INSERT INTO arnNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Fey Jesus feypieyew: —Chem pikefilmün rume, tüfachi domo fempey tati feychi antü iñche tañi rüngalngeael. ");
INSERT INTO arnNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tati pu pofre rumel müleay ta eymün mew, welu iñche rumel mülelayan. ");
INSERT INTO arnNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Rume fentren pu judiu longkolelu kimtukuyngün ñi mülepun ta Jesus Betania mew, fey amuyngün ta üyew, fey Jesus müten ürke no tañi pemeafiel engün, welu ka femngechi ta Lasaru, tüfey tañi wiñomongeltuel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Feymew ti pu longkolelu tati pu saserdote mew rakiduamingün ñi ka femngechi langümafiel engün ta Lasaru. ");
INSERT INTO arnNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Fey kisu ñi duam am rume fentren pu judiu püntütripatulu kisu engün mew tañi feyentufiel mew ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Fentren che wüne amurkey ta Jerusalen kechu antülewelu ñi müleael tati Paskua kawiñ. Fey kangelu antü mew, dew rupalu ti ilelkawün Lasaru ñi ruka mew, fey ti pu che kimi engün Jesus ñi akuael Jerusalen waria mew. ");
INSERT INTO arnNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Feymew Jesus amulelu rüpü mew, ti pu che katrünentuyey tapül palmera ka tripay engün ñi llowmeafiel wirarkülen: “¡Osana, tüfa ta montulaeiñmew! ¡Küme felen nieay tati küpalu Ñidol ñi üy mew! ¡Küme felen nieay ta Israel ñi longko ülmen!” ");
INSERT INTO arnNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus perpuy kiñe furiku, fey pürakawelluy ti furiku mew, chumngechi ñi feypilen ta Wirin Chillka mew: ");
INSERT INTO arnNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Llükakilnge, iñche ta montuluwayiñ Sion waria che. Leliwülfinge, tami longko ülmen kawellutulen küpaley kiñe pichi furiku mew.” ");
INSERT INTO arnNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Feychi antü mew kisu ñi pu disipulu ngüneduamlafi engün chumngelu ñi feypilen tüfachi dungu. Welu Jesus feychi dew püratulu wenu mapu mew, kisu ñi pu disipulu ngüneduami wüla engün kom tüfachi dungu ñi wirilen femngechi dungu ñi femael ta Jesus, ka femngechi dungu mew ñi rupayael ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Fey ti pu che mülelu Jesus engün feychi wiñomongeltufilu ta Lasaru ti küfwe mew, nütramyeniey engün ñi peelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Feymew ti pu che tripay engün ñi llowafiel ta Jesus, kimniefilu engün am ti afmatufal dungu ñi femel. ");
INSERT INTO arnNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Welu ti pu farisew welukonkechi feypiwingün: —Fey fantepu mew petu pepi chumlafiyiñ rume. ¡Kom mapu mülechi pu che feyentuay kisu mew! ");
INSERT INTO arnNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Feytichi pu che amuyelu ñi ngillatuael ta Jerusalen ti Paskua kawiñ mew, mülerkey kiñeke kake tripanche kisu engün mew, ");
INSERT INTO arnNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","fey tüfa engün fülkonpurkey ta Felipe mew, tati Betsayda waria tuwlu ta Galilea mapu mülelu, fey llellipufi engün ta Felipe: —Chachay, ayüleiñ taiñ nütramkayafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fey Felipe wütufi ta Andre ñi feypiafiel tüfachi dungu, fey mür amuy engu ñi nütramelmeafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Feymew Jesus feypieyew: —Püllelepay dewma tañi wenu püramngetuam tati Wentrukünuwpalu. ");
INSERT INTO arnNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Rüf dungu mew feypiwayiñ, fey kiñe fün kachilla rüngalkonnole ta pülli mew ka lanole, amulekey ñi kiñe fünngen müten. Welu lale, wülay rume fentren fün kachilla. ");
INSERT INTO arnNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tati pu che doyümnielu ñi mongen iñche mew, fey ta pelayay montun ñi mongen mew, welu tati ütrüflu ñi mongen iñche ñi müngeltuetew mew tüfachi mapu mew, fey ta nieay rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Fey kiñe che ayülele ñi poyeaetew, inaechimew, fey chew müleli ta iñche, üyew müleay tañi poyekeetew. Fey iney rume poyeelimew yamün mew, iñche ñi Chaw ta ka femngechi poyeafi yamün mew ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Fey Jesus amuley ñi feypilen: ¡Fewla ta rume wesa kutrantupiwkelen! Kimlan ñi chem piael. ¿Feypian may: “Chaw, montulaen tüfachi wesa dungu mew”? ¡Welu feypilayan tüfachi dungu iñche am küpalu ñi rupayael tüfachi lan dungu mew! ");
INSERT INTO arnNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Chaw, kom che püramyepe tami üy. Feymew allkünngey kiñe dungun wenu mapu feypilu: “Kom che dew elufiñ ñi püramyeaetew ka wiñome eluafiñ tañi püramyeaetew engün eymi tami femel mew.” ");
INSERT INTO arnNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Fey ti pu che mülelu tüfey mew allküyey, fey feypi engün ñi kiñe tralkanngen, welu kiñekentu feypi engün: —Kiñe werken püllü ta dungueyew. ");
INSERT INTO arnNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus feypieyew: —Iñche ñi duam no tati tañi allküngen ti dungun, welu eymün tamün duam mayfe. ");
INSERT INTO arnNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Fantepu mew llituay tañi ramtukadungungeael ñi chumngen ta tüfachi mapu mew mülechi pu che, fey ka femngechi ramtukadungungeay tati ngenkawkülelu tüfachi mapu mew tañi niewenoael ta awtoridad. ");
INSERT INTO arnNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Welu iñche feychi witrañpüramngetuli ta mapu mew, kom che kisutu famküpalafiñ ta iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Fey tüfa famngechi feypilu ñi witrañpüramngeael kimelürkey chumngechi tañi layael. ");
INSERT INTO arnNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Fey ti pu che llowdunguy: —Fey ti ley dungu mew kimiyiñ tati Cristo ñi rumel mongeleael. ¿Chumngelu am eymi feypimi tati Wentrukünuwpalu müley ñi witrañpüramngetuael? ¿Iney am tati Wentrukünuwpalu? ");
INSERT INTO arnNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus feypieyew engün: —Iñche mülen eymün mew tati pelon reke, welu müte tunteñma mülewelayan. Miyawmün may, petu tamün niefiel ti pelon, femngechi tamün dumiñmanoael, fey am ti miyawlu ta dumiñ mew, kimkenolu chew ñi amulen. ");
INSERT INTO arnNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Feyentufimün ta pelon petu tamün niefiel femngechi ta koneltuleaymün ta pelon mew ―pi. Fey dew feypilu tüfachi dungu, Jesus tripatuy fey ellkawi tañi penoaetew ta tüfeychi pu che. ");
INSERT INTO arnNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kom tüfachi dungu tañi nütramyepeel Jesus tunte femfuy rume ti afmatufal dungu kisu engün ñi adkiñ mew, welu kisu engün feyentulay Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Fey felelu am ñi mupiael tañi wirielchi dungu tati pelon wentru Isaia: “Ñidol, ¿Iney anta feyentukey iñchiñ taiñ kimelelchi dungu? ¿Iney engün mew anta pewfaluwi Ñidol ñi pepiluwün?” ");
INSERT INTO arnNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Feymew pepi feyentulay engün, fey ka femngechi wirilu am ta Isaia: ");
INSERT INTO arnNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ngünechen umerkünuñmaeyew reke ñi nge engün ka elungelay ñi longkontukuafiel ti dungu, femngechi ñi pepi penoael ka ñi pepi kimnoael engün Ngünechen ñi femkeelchi dungu, ka ñi wiñotunoael engün Ngünechen mew, fey Ngünechen tañi mongelnoaetew.” ");
INSERT INTO arnNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tüfa famngechi feypi ta Isaia, pefilu Ñidol ñi fütra küme pepiluwün, fey nütramyemekefi ta kisu. ");
INSERT INTO arnNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Welu ka femngechi, rume fentren pu judiu feyentuy Jesus mew, ka femngechi kiñeke tati ülmenkülelu. Welu kom che ñi adkiñ mew feypilay engün ñi feyentufiel ta Jesus, llükaniefilu engün am ti pu farisew, femngechi tañi wemünentungenoael engün tati sinagoga mew. ");
INSERT INTO arnNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Doy ayüley engün ta che ñi sakiaetew, fey ñi ayüafel engün Ngünechen ñi sakiaetew. ");
INSERT INTO arnNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus newentu dungun mew feypi: “Tati pu che feyentulu iñche mew, ta iñche mew müten feyentulay, welu ka femngechi feyentuy iñche ñi Chaw mew, tañi werküetew. ");
INSERT INTO arnNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tañi pekeetew ta iñche ka femngechi pekefi tañi Chaw. ");
INSERT INTO arnNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iñche pelon reke ta felen, fey küpan ta mapu mew, fey tati pu che feyentulu iñche mew ñi mülenoael dumiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Welu ti pu che allkütulu iñche ñi dungu, welu müngeltunofile, iñche no tati ramtukadunguaetew engün, fey iñche am küpanolu tañi ramtukadunguafiel ta che, welu may tañi montulafiel. ");
INSERT INTO arnNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ka femngechi tañi illamtuetew ka müngeltunolu iñche tañi feypielchi dungu, dew ramtukadungungey, tañi feypielchi dungu am ta ramtukadunguaetew tati afachi antü mew. ");
INSERT INTO arnNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Iñche kisu ngünewün dungukelan, welu tañi Chaw may tañi werküetew, fey ñi dungu ta dunguken, chumngechi ñi feypiael ka ñi kimeltuael. ");
INSERT INTO arnNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ka kimnien iñche tañi Chaw ñi werkün dungu fey ta wülkey rumel mongen. Feymew, iñche tañi feypielchi dungu feypiken chumngechi ñi feypietew iñche ñi Chaw.” ");
INSERT INTO arnNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kiñe antülewelu ñi akuam tati pu judiu che ñi Paskua kawiñ, Jesus kimnierkey ñi püllelepan dewma kisu ñi medin antü, fey ñi amutuael ka ñi müleputuael ta kisu ñi Chaw engu. Kisu rumel piwkeyepafi tañi elungeel tati mülelu mapu mew, fey femngechi kisu kom piwke mew piwkeyefi ka rumel ñi piwkeyenieafiel. ");
INSERT INTO arnNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Fey weküfü dew konürkey Juda ñi piwke mew, Simon Iskariote tañi fotüm, tañi rakiduamkülen mew ñi ellka wültukuafiel ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus kimnierkey ñi küpan ta Ngünechen mew ka ñi wiñotuael ta Ngünechen mew ka femngechi ta Chaw ñi eluetew ta kom pepiluwün. ");
INSERT INTO arnNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Feymew petu imekelu engün, witratripay ti mesa mew, fey nentukünuy ñi wente tukunieelchi takuwün, fey püramkünuy kiñe toalla ñi topel mew. ");
INSERT INTO arnNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ka pürüm wütruntukuy ko kiñe lafatorio mew, fey eluwi ñi küchanamunafiel ñi pu disipulu ka angkümeltufi ti toalla mew. ");
INSERT INTO arnNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Fey küchanamunafilu ta Simon Pedro, fey Pedro feypieyew: —Ñidol, ¿chumngelu am küchanamunaen ta iñche? ");
INSERT INTO arnNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus llowdungufi ta Pedro: —Fewla eymi kimlaymi tañi chumpen ta iñche, welu ka antü wüla küme kimaymi. ");
INSERT INTO arnNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro feypieyew: —¡Chumkawnorume eluwlayan tami küchanamunafiel! Jesus llowdungufi ta Pedro: —Fey küchanamunnoeliyu, koneltulayaymi iñche mew ka iñche ñi trokiñche mew. ");
INSERT INTO arnNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Pedro feypieyew: —¡Femalmi Ñidol, namun müten küchañmalayaen, welu ñi kuwü ka ñi longko! ");
INSERT INTO arnNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Welu Jesus llowdungufi ta Pedro: —Tati we müñetulelu duamtukey ñi küchayael ñi namun müten fey am ñi kuerpu kom lifkülelu. Fey eymün dew lifküleymün, welu kom eymün no. ");
INSERT INTO arnNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus feypi: “Kom eymün lifkülelaymün”, kimnielu am iney tañi ellka wültukuaetew. ");
INSERT INTO arnNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Fey dew küchañmangelu ñi namun engün Jesus, wiñome tukutuy ñi wente tukukeelchi takuwün, fey ka wiñome anükünuwtuy ti mesa mew ka feypifi ñi pu disipulu: —¿Ngüneduamimün kay eymün iñche tañi fempeelchi dungu? ");
INSERT INTO arnNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Eymün ta kimeltufe ka Ñidol pimuken, fey küme feypikeymün feyngelu am. ");
INSERT INTO arnNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Fey iñche tamün kimeltufengeli ka Ñidolngeli, fey küchañmawiyiñ tamün namun, ka femngechi feley tamün welukonkechi küchañmawael tamün namun. ");
INSERT INTO arnNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iñche ta eluwiyiñ kiñe küme inayentufalchi dungu, fey eymün tamün ka femngechi piwkeyewael chumngechi femün ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Rüf dungu feypiwayiñ ta chem kona no rume doykülelay kisu ñi ñidol mew, ka chem werken rume doykülelay ñi werkükeetew mew, feymew eymün müley tamün femael iñche reke. ");
INSERT INTO arnNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Fewla longkontukufilmün tüfachi dungu, welukonke piwkeyewülmün, rume sakinngeaymün. ");
INSERT INTO arnNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Itrokom eymün ta feypiwpelayiñ: iñche kimnien iney engün tañi dulliel. Welu müley ñi mupiael tañi chem pilen tati Wirin Chillka: ‘Tati petu ilu iñche iñchiw, fey ta kayñetutuenew.’ ");
INSERT INTO arnNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tüfachi dungu wüne feypikünuwayiñ, fey feychi felele, eymün ta feyentuaymün ta iñche mew tañi Iñchengen. ");
INSERT INTO arnNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Rüf dungu feypiwayiñ tati llowfilu iñche ñi werküel, fey ta llowenew ta iñche, fey tañi llowetew ta iñche, llowkefi tüfey tañi werküetew.” ");
INSERT INTO arnNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Fey dew feypilu tüfachi dungu, Jesus rume weñangküy ñi piwke mew, feymew küme nor dungun mew feypi: —Rüf dungu mew feypiwayiñ kiñe ta eymün ellka wültukuaenew. ");
INSERT INTO arnNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Fey ti pu disipulu eluwingün welukonke ñi leliwüluwael fey ñi kimnon engün iney ñi feypipefiel. ");
INSERT INTO arnNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Fey kiñe ñi pu disipulu tati rume piwkeyenieel, mülerkey Jesus ñi inafül mew, fey Juan ürke. ");
INSERT INTO arnNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Fey Simon Pedro maychülfi ta Juan tañi ramtuafiel ta Jesus iney ñi feypipefiel. ");
INSERT INTO arnNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Fey Juan doy fülpuy Jesus mew, fey ramtufi: —Ñidol ¿iney anta wültukuaeymew? ");
INSERT INTO arnNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus llowdungueyew: —Küchukünuan kiñe wükan kofke, fey tüfey tañi eluael, fey tati. Fey pürümkachi küchumi kiñe wükan kofke, fey elufi ta Juda, Simon Iskariote ñi fotüm. ");
INSERT INTO arnNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Fey pürümka müten Juda, llowfilu ti kofke, weküfü konürkey kisu ñi piwke mew, fey Jesus feypieyew: —Tami femaelchi dungu, pürüm femnge. ");
INSERT INTO arnNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Welu kiñe no rume tati petu imekelu mesa mew kimüñmalaeyew chumngelu ñi feypingen ta Juda. ");
INSERT INTO arnNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Juda ürke tati niekefulu ti kütrüng pülata, fey kiñekentu rakiduamingün ta Jesus ñi werküetew tañi ngillameael tati duamtuel ti kawiñngealu kam tañi eluafiel chem rume tati pu pofre. ");
INSERT INTO arnNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Fey Juda, dew llowfilu ti kofke, tripay. Punürkey dewma. ");
INSERT INTO arnNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Fey dew tripalu Juda, Jesus feypi: —Puwi ñi püramyengeael tati Wentrukünuwpalu ka Ngünechen ñi püramyengeael ta kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Fey tati Wentrukünuwpalu pengelniey Ngünechen ñi fütra küme püramyengen, Ngünechen ka pengelay kisu mew ti fütra küme püramyengen, fey pürümka müten femay. ");
INSERT INTO arnNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Iñche ñi sakin pu weni, iñche mülewean eymün iñchiñ kiñe mufün ora müten tüfachi mapu mew. Eymün ta kintumuan, welu chumngechi tañi feypifiel tati pu judiu, fey fewla ka femngechi feypiwayiñ ta eymün: Pepi amulayaymün chew tañi amuael ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Feymew eluwayiñ ta tüfachi we werkün dungu: Tamün welukonke piwkeyewael chumngechi ta iñche piwkeyewiyiñ ta eymün. Femngechi feley tamün welukonkechi piwkeyewael. ");
INSERT INTO arnNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Fey welukonkechi piwkeyewülmün, kom mapu mew mülechi pu che kimayngün iñche tañi disipulungen ta eymün.” ");
INSERT INTO arnNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Fey Simon Pedro ramtufi ta Jesus: —Ñidol ¿chew anta amuaymi? Fey Jesus llowdunguy: —Chew ñi amuael ta iñche, pepi inalayaymi ta fewla. Ka antü wüla amuaymi. ");
INSERT INTO arnNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Feymew Pedro feypi: —Ñidol, ¿chumngelu am pepi inalayaeyu ta fewla? ¡Dew eluwkülen ñi lakonael rume ta eymi iñchiw! ");
INSERT INTO arnNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus llowdungueyew: —¿Rüfngey am tami layael iñche mew? Rüf dungu feypiaeyu petu ñi kakaranon ta alka, küla rupachi ta “kimlafiñ” piaymi. ");
INSERT INTO arnNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Weñangkülekilmün ta eymün tamün feypiwfielchi dungu mew. Feymew feley tamün maneluwael ta Ngünechen mew ka tamün maneluwael ta iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Iñche ñi Chaw ñi ruka mew rume fentreley ta mülewe chew tamün mülepuam. Fey femngechi mülenofule, iñche feypiwlayafuiñ, welu rüf dungu mew amuan tañi pepikameael kiñe küme mülewe. ");
INSERT INTO arnNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Fey dew amutuli ka küme elmetuli kiñe küme mülewe, ka wiñome küpatuan tamün yewpatuafiel ta eymün, femngechi ta eymün mülepuaymün chew ñi müleputuael ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Welu eymün dew kimniefimün chumngechi tamün puwael chew ñi amutuael ta iñche.” ");
INSERT INTO arnNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas feypifi ta Jesus: —Ñidol, kimlaiñ chew tami amuael. ¿Chumngechi anta puwaiñ chew tami mülemum? ");
INSERT INTO arnNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus llowdungueyew: —Iñche ta rüpü reke felen, ka rüfngechi dungu ka mongen, iñche mew pepi puwünngey ta Chaw mew. Iñche mew müten feyentulu amuay ta Chaw mew. ");
INSERT INTO arnNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Fey eymün kimniemuli iñche, ka femngechi kimafimün ta iñche ñi Chaw. Fey fantepu mew dew pekefimün ka dew kimniefimün. ");
INSERT INTO arnNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Feymew Felipe feypieyew: —Ñidol, elumuiñ taiñ peafiel ta Chaw, fey nor duamaiñ ta iñchiñ. ");
INSERT INTO arnNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus llowdunguy: —Felipe, dew pütrüñma müleken ta eymün mew, ¿fey petu kimlaen am? Tañi pekeetew ta iñche, pekefi ta Chaw. ¿Chumngelu anta feypipeen tamün pengeleluwafiel ta Chaw? ");
INSERT INTO arnNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Feyentulaymi anta iñche ñi mülen ta Chaw mew ka Chaw ñi mülen ta iñche mew? Feyti dungu tamün feypiwkefiel, feypipelan tati tañi kisu ngünewün mew, welu Chaw may ñi elukeetewchi dungu, fey may adkünukey kisu ñi ngenngeelchi küdaw mew. ");
INSERT INTO arnNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Feyentumuchi iñche tañi mülen ta Chaw mew, fey Chaw ñi mülen ta iñche mew: fey feyentunolmün tañi feypipeelchi dungu, feyentufimün rewall iñche tañi femkeelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Feymew rüf dungu mew feypiwayiñ tati feyentulelu iñche mew, ka femay iñche ñi femkeelchi dungu. Fey doyelchi may femay kakelu doy fütrake dungu, fey iñche am amutualu chew ñi mülemum ta Chaw. ");
INSERT INTO arnNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Fey kom tamün ngillatuel ta eymün iñche ñi üy mew chumngechi ñi adentuael ta iñche, iñche ta feman, femngechi ta Fotüm mew ñi pengelngeael Chaw ñi fütra pepiluwün. ");
INSERT INTO arnNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Femngechi feman chem dungu rume ngillatulmün iñche ñi üy mew. ");
INSERT INTO arnNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Iñche ka femngechi feypiwayiñ, fey eymün ta piwkeyemuli, müngeltuafimün iñche ñi werkün dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Fey iñche ngillatuafiñ ta Chaw tamün werkülelaetew tati Rüfngechi Küme Püllü tamün kellunieaetew, fey ta rumel müleay eymün mew. Tati mapu tuwünngelu werkülelayafi ka llowlayafi rume, fey pekenofilu am ka kimnofilu rume. Welu eymün ta kimniefimün, kisu am mülelu eymün mew fey ka rumel müleay eymün mew. ");
INSERT INTO arnNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Fey iñche amutuli rume, kisukünuwlayayiñ. Ka wiñometuan tañi mületuael eymün iñchiñ. ");
INSERT INTO arnNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pichiñma mew, tüfachi mapu mew mülechi che doy pewelayaenew engün, welu eymün ta peniemuan, ka mongeleaymün, iñche am rumel mongelealu. ");
INSERT INTO arnNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Feychi mew, eymün ta ngüneduamaymün iñche ñi mülen tañi Chaw mew, ka eymün tamün mülen iñche mew, ka femngechi iñche tañi mülen eymün mew, femngechi fente küme kiñewküleaiñ taiñ femngechi feleael. ");
INSERT INTO arnNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tati llowfilu iñche ñi werkün dungu ka müngeltufilu, fey ta kimfali rüf mew ñi piwkeyenieetew. Fey iñche ñi Chaw piwkeyeafi tüfey tañi piwkeyekeetew, fey iñche piwkeyeafiñ ka amul doy kimelelafiñ ñi chumngen ta iñche.” ");
INSERT INTO arnNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Fey Juda (fey tati Iskariote no) ramtueyew: —Ñidol ¿chumngelu iñchiñ mew pewfaluwtuaymi, fey ti pu kakelu che mew no? ");
INSERT INTO arnNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus llowdunguy: —Tüfey tañi piwkeyekeetew, fey ta müngeltukefi iñche ñi dungu, fey iñche ñi Chaw ta piwkeyeaeyew. Fey iñche ñi Chaw iñchiw küpayayu tayu mülepayael ta kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tüfey tañi piwkeyenoetew, fey ta müngeltuñmalaenew iñche ñi dungu. Fey tüfachi dungu eymün tamün allkütupeel iñche kisu ñi dungu no, welu Chaw may tañi dungu, tüfey tañi werküetew. ");
INSERT INTO arnNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Welu feypiwiyiñ kom tüfachi dungu petu ñi mülen ta eymün iñchiñ. ");
INSERT INTO arnNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Welu ti Lif Küme Püllü, tamün adnieaetew, ta Chaw ñi werküael ta iñche ñi üy mew, fey ta kimeltuaeymünmew kom ti dungu ka konümelpatuaeymünmew kom ti dungu iñche tamün feypiwkefiel. ");
INSERT INTO arnNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Fey amutuli, eleluwayiñ küme tüngün. Eleluwayiñ iñche ñi küme tüngün, welu eleluwlayayiñ chumngechi ñi wülken tüfey engün tati mülelu mapu mew. Weñangkülekilmün ka llükakilmün rume. ");
INSERT INTO arnNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Dew allkütuñmamun iñche tañi feypiel iñche tañi amutuael ka ñi küpatuael femngechi ta wiñome mületuaiñ ta eymün iñchiñ. Fey rüf dungu mew ta piwkeyemuli, rume ayüwafuymün kimülmün ta iñche ñi amutuael ta Chaw mew, kisu am doy wünenngelu iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Fey fewla feypikünuwayiñ tüfachi dungu, fey femle tüfa, femngechi tamün feyentuam. ");
INSERT INTO arnNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Doy kimeltuwelayaiñ ta eymün, fey küpalu am tati longkolelu tüfachi mapu mew, tunte kisu nielay pepiluwün rume ta iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Fey tüfachi dungu feley ñi rupayael femngechi tüfachi mapu mew mülechi pu che ñi kimael iñche ñi piwkeyefiel ta Chaw, ka iñche ñi femken tañi Chaw ñi werküetewchi dungu. “Fey fewla witrapüramün, fey amuaiñ kañpüle” pirkey ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Fey petu amulelu engün, Jesus amuley ñi feypilen: “Iñche tati rüfngechi anüm ofad reke felen, fey iñche ñi Chaw tati dapikefilu ti anüm ofad. ");
INSERT INTO arnNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Fey tati row wülnolu ofad, katrünentungeay. Welu ti row nielu fün ofad, fey küme liftungeay, femngechi ñi doy wülael ta fün. ");
INSERT INTO arnNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Eymün ta dew lifküleymün fey ti dungun mew tamün feypiwfiel. ");
INSERT INTO arnNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Amulemün tamün kiñewkülen iñche mew, chumngechi ta iñche amulen ñi kiñewkülen eymün mew. Kiñe row pepi wül-layafuy fün ofad re kisutu müten, kiñewkülenole tati anüm ofad mew. Ka femngechi, eymün ta pepi wül-layafuymün fün, kiñewkülenolmün ta iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Iñche tati anüm ofad, fey eymün tati row. Fey ti rumel kiñewkülelu iñche mew, ka iñche kiñewküleli kisu mew, fey ta wülay rume fentren fün. Fey iñche mülenoli eymün mew, ta pepi chumlayafuymün rume. ");
INSERT INTO arnNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tati rumel kiñewkülenolu iñche mew, fey ta katrünentungeay, fey angküay chumngechi ta kiñe row ñimitungekey ka lüpümngekey kütral mew. ");
INSERT INTO arnNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Fey eymün amulelmün tamün kiñewkülen iñche mew ka rüf dungu mew mülelmün iñche ñi kimeltun mew, ngillatuaymün chem rume tamün ayüel, fey iñche ñi Chaw eluaeymünmew tamün ngillatuel. ");
INSERT INTO arnNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Fey ta famngechi iñche ñi Chaw llowkey püramyen femngechi wülimün ta eymün fentren fün, fey ka femngechi ta rüf mew iñche ñi disipulungeaymün. ");
INSERT INTO arnNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Feymew feypiwayiñ iñche piwkeyewiyiñ ta eymün chumngechi iñche ñi Chaw piwkeyeenew ta iñche. Mülemün may tamün kiñewkülen iñche mew femngechi tamün rumel piwkeyewafiel. ");
INSERT INTO arnNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Fey müngeltufilmün iñche ñi werkün dungu, müleaymün iñche ñi piwkeyen mew, chumngechi ta iñche müngeltufiñ ta Chaw ñi werkün dungu ka mülen kisu ñi piwkeyen mew. ");
INSERT INTO arnNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Tüfa famngechi dunguwpeyiñ tamün ayüwküleael iñche mew, fey tamün ayüwün rumel ñi feleael. ");
INSERT INTO arnNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tüfa iñche ñi werkün dungu: Tamün welukonke piwkeyewael chumngechi ta iñche piwkeyewiyiñ ta eymün. ");
INSERT INTO arnNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tati doy fütra piwkeyen tañi nieafel ta kiñe che fey tañi wülael kisu ñi mongen kütu ñi weni mew. ");
INSERT INTO arnNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Eymün ta iñche ñi pu weni, fey femülmün iñche tamün werküwkefiel. ");
INSERT INTO arnNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Fey iñche kona piwlayayiñ, kiñe kona am kimkenolu ñi chumken tañi ñidol. Iñche ñi pu weni piwayiñ, fey iñche am kimelfilu ta eymün kom ñi chem pietew ta iñche ñi Chaw. ");
INSERT INTO arnNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Eymün dullimulan ta iñche, welu iñche may ta dulliwiyiñ ta eymün, feymew werküwiyiñ tamün müleael ti pu che mew ka tamün wülael reke rume fentren fün femngechi tamün tuteafiel ta Chaw, fey üyechi fün rumel müleay. Fey famngechi femülmün, ta Chaw eluaeymünmew kom tamün ngillatufiel iñche ñi üy mew. ");
INSERT INTO arnNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Fey wiñome feypiwayiñ tamün werküwfiel: tamün welukonke piwkeyewael. ");
INSERT INTO arnNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Fey ti feyentunochi pu che mülelu tüfachi mapu mew üdeelmünmew ta eymün, ngüneduamaymün iñche ñi wüne üdeetew engün. ");
INSERT INTO arnNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Eymün feyentunofulmün tati mapu tuwün pu che reke, tüfachi mapu tuwün pu che piwkeyeafeymünmew, tüfachi pu che piwkeyekefi kisu engün reke feyentunolu. Welu iñche dulliwiyiñ ta eymün rangi ti feyentunochi pu che mew, feymew ta mapu mew mülechi pu che üdekeeymünmew, fey eymün am feyentulu iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tukulpafimün tüfeychi dungu tamün dew feypiwfiel: ‘Kiñe kona no rume wünenkülekelay tañi ñidol mew.’ Fey iñche ta kayñetungeli, eymün ka femngechi kayñetungeaymün, welu feyti feyentunolu müngeltufule iñche ñi dungun, ka femngechi müngeltuafuy eymün tamün wewpielchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Welu tati feyentunolu iñche mew, üdeaeymünmew, kimnofilu engün am iñche ñi Chaw, tañi werküetew. ");
INSERT INTO arnNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Welu tati pu che feyentunolu iñche mew, ta nielayafuy kiñe yafkan no rume, fey iñche küpanofuli tañi kimeltuafiel Ngünechen ñi dungu. Welu fewla ngelay tañi kuñillngeael engün ñi yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Fey ti feyentunolu am üdekeetew ta iñche, ka üdekefi iñche ñi Chaw. ");
INSERT INTO arnNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Chumngechi feypipen, nielayafuy engün chem yafkan rume, fey iñche küpanofuli ñi femael ti afmanngechi dungu iney no rume ñi femkenoel, welu dew pefi engün ti afmanngechi dungu, fey ñi femelchi dungu mew, üdekeenew engün ka femngechi üdekefi engün iñche ñi Chaw. ");
INSERT INTO arnNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Welu tüfachi dungu ñi femael tati feyentunolu, femi engün tañi mupiael ti wirilechi dungu kisu engün ñi ley dungu mew: ‘Üdeenew engün, fey ñi yafkanon rume.’ ");
INSERT INTO arnNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Welu feychi küpale ti Lif Küme Püllü, tamün adnieaetew, fey ta iñche tañi werküael iñche ñi Chaw ñi piel mew, tati Lif Küme Püllü ta wiñome nütramyetuaenew ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Fey eymün ka feley tamün nütramyemuafiel, eymün am rumel mülekelu iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Feypiwayiñ tüfachi dungu rumel tamün müngeltuniemuafiel ta iñche tunte kutrankawaymün rume. ");
INSERT INTO arnNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wemünentungeaymün ta sinagoga mew tamün üdeetewchi pu che. Doyelchi may, akuay ta antü fey iney rume langümchele, rakiduamay ñi poyefiel ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Fey tüfachi dungu femay engün, feyentunolu engün am ta Chaw mew ka iñche mew no rume. ");
INSERT INTO arnNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Feypiwpeyiñ tüfachi dungu, fey dew rupalelmün tüfachi wesake dungu mew, konümpayaymün iñche tamün dew feypiwkefiel. “Feypiwlayiñ tüfachi dungu llituka mew müten, iñche am petu mülekelu eymün iñchiñ. ");
INSERT INTO arnNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Fewla amutuan tañi müleputuael ñi Chaw iñchiw, welu kiñe no rume eymün ‘¿chew amutuaymi am?’ pimulan. ");
INSERT INTO arnNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Welu eymün weñangkünagimün ‘amutuan’ pilu iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Welu feypiken ti rüfngechi dungu: doy kümey ta eymün mew, amutuli ta iñche. Fey amutunofuli, ti Lif Küme Püllü tamün kelluaetew küpalayafuy ñi mülepayael eymün mew. Welu rüf dungu mew amutualu am ta iñche, fey werküleluwayiñ ti Lif Küme Püllü. ");
INSERT INTO arnNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Fey tati Lif Küme Püllü kimelafi tati feyentunochi pu che ñi yafkalen engün ka iñche ñi nor piwkengen, fey Ngünechen tañi ramtukayafiel ta kom che ñi chumngen. ");
INSERT INTO arnNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Fey yafkaley engün kisu engün am feyentunolu ta iñche mew. ");
INSERT INTO arnNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kimaymün tañi nor piwkengen ta iñche, fey iñche am amutualu Chaw mew fey eymün ta doy pemuwelayan. ");
INSERT INTO arnNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Fey küme kimfali Ngünechen am ramtukadunguafilu kom che ka dew ramtukadungufilu am tati ngüneniefilu tüfachi mapu, fey ka kondenafi. ");
INSERT INTO arnNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Petu nien fentren dungu tamün feypiwafiel, welu fewla kom feypiwliyiñ küme kimlayafuymün. ");
INSERT INTO arnNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Welu feychi küpale wüla ti Rüfngechi Küme Püllü kisu ta kelluaeymünmew tamün adümafiel kom rüfngechi dungu, fey dungunoalu am kisu ñi ngünewün mew, welu may feypiay kom tañi allküel iñche mew, ka kimelaeymünmew kom ti dungu tati felerpualu. ");
INSERT INTO arnNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Fey ta famngechi tati Lif Küme Püllü püramyeaenew ta iñche, fey llowalu am kom ñi nieel ta iñche fey ka kelluaeymünmew tamün küme kimafiel iñche ñi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kom ñi nieel ta Chaw iñche ñi dungu tatey. Feymew ta feypipen tati Lif Küme Püllü inanieay iñche tañi dungu, fey kelluaeymünmew tamün kimafiel iñche ñi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ka wiñome feypiwayiñ pichiñma müten mülewean ta eymün mew, fey pemuwelayan, welu ka pichi alüñma mew ka wiñome pemutuan” pi ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Feymew ñi pu disipulu welukonke ramtuwi engün: “¿Chem dungu am feypiafulu tüfa famngechi ñi feypiel mew? Feypieiñmew ‘ka pichiñma mew taiñ doy pewenoafiel’, ka ‘pichi doy alüñma mew taiñ wiñome petuafiel, fey ñi amutuael chew ñi mülemum ta Chaw’. ");
INSERT INTO arnNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Chem piafulu am tüfachi dungun mew ‘ka pichiñma’ pilu? Kimüñmalafiyiñ chem dungu ñi feypipen” feypiwi welukonke ti pu disipulu. ");
INSERT INTO arnNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus ngüneduami tañi ayüfel engün ñi ramtuaetew, fey feypifi: —Iñche ta feypiwiyiñ tuntelewelay tamün doy pemuwenoafiel fey ka pichi alüñma mew ka tamün wiñome pemutuafiel. ¿Fey tüfachi dungu anta petu ramtumekewimün ta eymün? ");
INSERT INTO arnNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Rüf dungu feypiwayiñ eymün ta ngümayaymün ka weñangküleaymün, welu tati feyentunolu iñche mew rume ayüway engün. Welu femllefule rume engün ka eymün tunte weñangkülelmün rume, tamün weñangkün ayüwünngetuay. ");
INSERT INTO arnNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Fey tüfachi dungu feypiwayiñ: kiñe domo ta püñeñayüm, rume kutrankawkey fey am akulu ñi antü, welu dew nieyüm ñi püñeñ, ngüyünentutukey ñi kutrankawün fey ti ayüwünngechi dungu ñi duam, femngechi ñi choyün mew ta kiñe pichiche tüfachi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ka femngechi tati eymün ta weñangküleymün ta fewla, welu iñche wiñome pewtuayiñ, feymew wüla fentren ayüwün nietuay tamün piwke, fey iney no rume müntuñmalayaeymünmew tamün ayüwün. ");
INSERT INTO arnNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Tüyechi antü mew chem no rume doy ramtumuwelayan. Rüf dungu feypiwayiñ Chaw tamün eluaetew kom tamün ngillatufiel iñche ñi üy mew. ");
INSERT INTO arnNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Fey fantepu mew, eymün ta chem no rume petu ngillatukelaymün iñche ñi ayükeelchi dungu mew. Ngillatumün, fey llowaymün, femngechi ta rüf dungu mew feleay tamün ayüwkülen. ");
INSERT INTO arnNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Iñche dew kimeltuwkeyiñ ta adkünu dungu mew, welu pürümka reke doy kimeltuwewlayayiñ adkünu dungu mew, welu may re küme kimeltuwayiñ ta Chaw ñi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Feychi antü mew eymün ta ngillatuaymün chumngechi ñi ayükeel ta iñche, fey petu feypiwlayiñ tatey iñche ngelay ñi llellipuafiel ta Chaw femngechi tamün allkütuetew. ");
INSERT INTO arnNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Fey Chaw am piwkeyeetew ta eymün, piwkeyeeymünmew eymün am piwkeyemukefiel ta iñche, ka feyentulu am eymün iñche tañi küpan ta Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tripapan Chaw tañi ayfiñ mew tañi küpayael ta tüfachi mapu mew, fey fewla elkünutuafiñ tüfachi mapu tañi wiñotuael ta Chaw mew” pi. ");
INSERT INTO arnNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Feymew ti pu disipulu feypifi ta Jesus: —Fewlake ta küme nor dunguymi, fey tami kimeltuwenoael adkünu dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Fewla ngüneduamiyiñ tami küme kimnien kom dungu, fey ngelay chem dungu rume taiñ ramtuael. Fey tüfa famngechi feyentuiñ tami küpan ta Ngünechen mew ―pi engün. ");
INSERT INTO arnNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus llowdunguy: —¿Fewla anta küme feyentuymün? ");
INSERT INTO arnNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Fey dew akuy ta antü, fey ka fewla müten, eymün ta kake kiñeke püle püntütripayaymün, fey kisukünumutuan. Welu iñche kisulelan, Chaw iñchiw ta müleyu. ");
INSERT INTO arnNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Dew feypiwiyiñ kom tüfachi dungu femngechi tamün nieael küme tüngün kiñewkülelu am eymün iñche mew. Tüfachi mapu mew eymün müley tamün kutrankawael, welu yafüluwkülemün, iñche am dew wewfilu kom wesake dungu tunte kutrankawün rume ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Fey dew feypilu tüfachi dungu, Jesus lelipüray ta wenu mapu, fey feypi: “Chaw, dew puwi tati medin antü. Püramyefinge eymi tami Fotüm, femngechi ta kisu ñi püramyeaetew ta eymi. ");
INSERT INTO arnNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Fey elufilu am tami Fotüm kom pepiluwün femngechi ñi longkoleael itrokom che mew, ka femngechi tañi eluafiel ta rumel mongen kom tami elufiel. ");
INSERT INTO arnNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Fey tüfa lle tati rumel mongen: tami kimngeael eymi, tami kiñen rüfngechi Ngünechenngen ka Jesucristo, eymi tami werküelchi Fotüm. ");
INSERT INTO arnNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Iñche püramyekeeyu tüfachi mapu mew, fey iñche am kom dewmafilu tami werküfielchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Fewla may, Chaw püramyeen eymi tami ayfiñ mew chumngechi tayu niekefelchi fütra püramyen kuyfi petu ñi mülenon rume ta mapu. ");
INSERT INTO arnNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Fey ti pu che tami dulliel rangi ti kakelu pu che ta mapu mew tami eluafiel, dew kimelfiñ tami kimaetew ñi ineyngen ta eymi. Eymi ngenngeymi, fey iñche ta eluen, fey müngeltufi engün tami dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Fewla kimi engün kom tami elufielchi dungu ñi küpan ta eymi mew. ");
INSERT INTO arnNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Fey iñche elufiñ tami werküelchi küme dungu, fey kisu engün ta dew llowfi, ka dew ngüneduamingün ñi feyngen tañi küpan ta iñche eymi mew, ka dew feyentuy engün eymi tami werküfiel. ");
INSERT INTO arnNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Iñche llellipuaeyu ta kisu engün mew. Llellipulayan tati feyentunochi pu che mew, welu may tüfey engün mew tami elufiel, fey eymi ngenngelu am kisu engün mew. ");
INSERT INTO arnNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kom ñi nieel ta iñche, fey ta eymingey. Ka kom tati eymingelu, iñchengey tati. Fey iñche ñi fütra küme pepiluwün pewfaluwi ta kisu engün mew. ");
INSERT INTO arnNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Iñche rumel mülelayan ta mapu mew, welu kisu engün feyngey tañi pichiñma ñi müleweael ta mapu mew, fey iñche ta amutuan tañi müleputuael eymi iñchiw. Feymew Trürümfalnochi Chaw, ingkaniefinge ti fütra pepiluwün tami elufiel mew, femngechi tañi küme kiñewküleael ta kisu engün, eymi iñchiw reke. ");
INSERT INTO arnNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Iñche petu mülelu ta kisu engün iñchiñ tüfachi mapu mew, ingkaniekefuiñ ka montulniekefuiñ tami elufielchi pepiluwün mew. Fey kisu engün kiñe no rume ta ñamlay, welu may tati dew felelu ñi ñamküleael müten, femngechi tañi mupiael eymi chumngechi ñi feypiel tati Wirin Chillka. ");
INSERT INTO arnNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Welu fewla amutuan eymi mew, feymew feypipen tüfachi dungu petu ñi mülen ta mapu mew, femngechi tati feyentulu ñi nieael iñche tañi nieelchi küme ayüwün. ");
INSERT INTO arnNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Fey iñche ta kimelelfiñ tami dungu, welu ti feyentulenochi pu che üdekeeyew engün, fey kisu engün am koneltulenolu tüfachi mapu mew, chumngechi iñche mapu tuwünngelan. ");
INSERT INTO arnNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Llellipulayaeyu tami püntünentutuafiel tati wesake che mew, welu may tami montulnieafiel tati wesake dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Chumngechi ta iñche koneltulelan tati wesake che mew, kisu engün ka femngechi koneltulelay tati wesake che mew. ");
INSERT INTO arnNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Feymew liftuñmafinge engün ñi mongen eymi tami rüfngechi dungu mew. Eymi tami dungun ta feyngechi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Eymi am werküfiel iñche ñi mülepayael rangi ti wesake che mew, fey iñche werküafiñ ta kisu engün ñi müleael rangi ti wesake che mew. ");
INSERT INTO arnNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kisu engün ñi duam iñche wichulechi lif mongen nieken ka femngechi kisu engün feley ñi nieael wichulechi lif mongen ti rüfngechi dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Tüfa engün mew müten llellipupelaeyu, welu may ka femngechi llellipuaeyu tati feyentualu iñche mew, allküle engün ti we kimelün dungu tati dew feyentulu ñi wewpiael mew. ");
INSERT INTO arnNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Chaw, llellipuaeyu itrokom ta kisu engün mew ñi fente küme kiñewküleael ta kisu engün, chumngechi ta eymi müleymi iñche mew, fey iñche ka mülen eymi mew. Fente küme kiñewkülepe engün, femngechi tati mapu mew mülechi pu che ñi feyentuael engün eymi tami werküfiel. ");
INSERT INTO arnNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ka femngechi elufiñ tüfeychi fütra pepiluwün eymi tami elufiel, femngechi tañi kiñewküleael engün chumngechi kiñewküleyu iñchiw. ");
INSERT INTO arnNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iñche mülean kisu engün mew, fey eymi iñche mew, femngechi ta kisu engün fente küme kiñewküleael, fey tüfa famngechi tati mapu mew mülechi pu che ngüneduamay eymi tami werküfiel, ka tami piwkeyefiel engün chumngechi piwkeyeen ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Chaw, tüfeychi pu che tami elufiel ayülen kisu engün ñi müleputuael chew ñi müleael ta iñche, femngechi tañi peael engün tami elufielchi fütra pepiluwün, fey eymi am kuyfi mew piwkeyefiel petu ñi dewmangenon rume ta mapu. ");
INSERT INTO arnNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Nor mongen Chaw, tati mapu mew mülechi wesake che kimlaeymew, welu iñche kimnieeyu, fey tati feyentulechi pu che kimingün kafey eymi tami werküfiel. ");
INSERT INTO arnNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Fey ta famngechi kimingün iñche am kimeltufilu ñi ineyngen ta eymi, fey ka femngechi kimeltuniefiñ femngechi tati piwkeyen tami nielfiel müleay kisu engün mew ka femngechi iñche ñi müleael ta kisu engün mew” pi. ");
INSERT INTO arnNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Fey dew feypilu tüfachi dungu, Jesus tripay kisu ñi pu disipulu engün tañi amuael nometu ti Sedron wütrunko mew. Tüye mew mülerkey kiñe anümkawe, fey tüfey mew konpuy Jesus kisu ñi pu disipulu engün. ");
INSERT INTO arnNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ka femngechi Juda, tüfey tañi ellka ngünenmanieetew, kimnierkey ti anümkawe, fey fentren rupachi am trawüluwkerkelu Jesus ñi pu disipulu engün tüfeychi anümkawe mew. ");
INSERT INTO arnNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Feymew ta Juda akurkey kiñe trokiñ soltaw engün ka kiñeke llüwatulekelu ta ngillatuwe ruka mew, tüfeychi pu che werküeyew ti longkolelu pu saserdote mew ka tati pu farisew. Küme pepikawkülerkey engün wayki mew ka yenierkey engün pelontuwe. ");
INSERT INTO arnNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Welu Jesus am dew kimnierkelu kom feychi dungu mew ñi rupayael, wütueyew fey ramtueyew: —¿Iney anta kintupefimün? ");
INSERT INTO arnNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Fey ti pu che llowdunguy: —Jesus Nasaret tuwlu ta kintupefiyiñ. Fey Jesus feypieyew: —Iñche tati. Juda, tüfey tañi ellka wültukuaetew, mülepurkey tüfey mew kiñentrür ti pu che engün. ");
INSERT INTO arnNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Fey Jesus feypilu: “Iñche tati” kisu engün furi trekawi, fey ütrüfpuwi engün pülli mew. ");
INSERT INTO arnNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Fey Jesus wiñome feypieyew: —¿Iney anta kintupefimün? Fey ti pu che ka wiñome feypi: —Jesus, Nasaret tuwlu kintupefiyiñ. ");
INSERT INTO arnNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus ka wiñome feypieyew: —Dew feypiwiyiñ ñi iñchengen. Fey iñche kintumupeli, elufimün ñi amutuael ti pu che iñche ñi kompañkiyawületew. ");
INSERT INTO arnNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Fey tüfa famngechi rupay tañi feleael Jesus tañi feypiel, feychi ngillatulu: “Chaw, tüfey tami elufiel kiñe no rume ta ñamlay.” ");
INSERT INTO arnNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Feymew Simon Pedro, nierkey kiñe pichi wayki, nentupay fey katrünentuñmafi ñi man pilun kiñe tati Malku pingelu, ti Wünen Longko Saserdote ñi kona ürke. ");
INSERT INTO arnNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus feypifi ta Pedro: —Wiñome üchaftukutunge tami wayki chew tañi niekemum. Fey iñche feley ñi kutrankawael iñche ñi Chaw ñi piel mew chumngechi putungekey ti füre pulku. ¿Fey felerkelay am tañi putuafiel? ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Fey ti trokiñ soltaw ka ñi longko engün ka ti pu llüwatulekelu ti pu judiu tañi ngillatuwe ruka mew, püresufi engün ta Jesus ka furi trarifingün. ");
INSERT INTO arnNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Wünelu mew yefi engün Anas ñi ruka mew, Anas ta Kayfas ñi chedkuy ürke, longkoley ti pu saserdote mew tüyechi tripantu. ");
INSERT INTO arnNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Fey tüfachi Kayfas ürke ta wünetu feypifi tati pu judiu, “doy kümey kiñe wentru müten tañi layael ti trokiñche mew.” ");
INSERT INTO arnNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pedro ka ti kangelu disipulu Juan pingelu inaniefi engu ta Jesus. Fey ti kangelu disipulu kimnierkeeyew ti Wünen Longko Saserdote, feymew konpuy Jesus engu ti ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Welu Pedro mülewey wekuntu ti kalle mew. Feymew, ti disipulu kimnieetew ti Wünen Longko Saserdote, tripay ti kalle mew, fey dungufi ti kuydakelu wülngiñ mew, fey tukupufi ta Pedro. ");
INSERT INTO arnNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Fey ti kuydakelu wülngiñ mew ramtufi ta Pedro: —¿Eymi no anta Jesus ñi kiñe disipulu? Pedro llowdunguy: —Fey no. Iñche no tati. ");
INSERT INTO arnNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Fey wütrengelu am ti pu kona ka ti pu llüwatulekelu ti ngillatuwe ruka mew, kütralturkey engün, fey üye mew eluwi ñi eñumtuael engün. Pedro ka mülepurkey kisu engün mew ka femngechi eñumtuley kütral mew. ");
INSERT INTO arnNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Fey ti Wünen Longko Saserdote eluwi ñi ramtukayafiel ta Jesus chem dungu ñi femken kisu ñi pu disipulu ka chem dungu ñi kimeltukeel ta kisu. ");
INSERT INTO arnNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus feypieyew: —Iñche dunguken itrokom che ñi adkiñ mew ka kom püle rumel kimeltuken tati sinagoga mew ka ti ngillatuwe ruka mew, chew trawüluwkey itrokom ti pu judiu. Chem dungu rume ellka kimeltukelan. ");
INSERT INTO arnNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Chumngelu am ramtukapeen ta iñche ñi chumken? Ramtufinge tüfeychi pu che iñche tañi allkütukeetew, fey kisu engün feypiay chem dungu tañi kimelkefiel. Feyti pu che kimniey iñche ñi chem pikefiel. ");
INSERT INTO arnNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Feymew Jesus, feypilu tüfa, kiñe ti llüwatulekelu ta ngillatuwe ruka mew traloftukueyew ñi ange mew, feypilen mew: —¿Famngechi am llowdungufimi tati Wünen Longko Saserdote? ");
INSERT INTO arnNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus llowdungueyew: —Iñche wesa llowdunguli, feypien chem mew ñi welulkan, fey iñche küme llowdunguli, ¿chumngelu anta wülelpaen? ");
INSERT INTO arnNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Feymew Anas werküy ñi trarilen yengeael tati Wünen Longko Saserdote Kayfas mew. ");
INSERT INTO arnNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Fey Pedro kay mülepuy üye mew, eñumtuley inaltu kütral. Fey ramtungey: —¿Eymi no anta Jesus ñi kiñe disipulu? Fey Pedro llumumay feypilen mew: —No, iñche no tati. ");
INSERT INTO arnNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Fey pürüm ramtueyew ti Wünen Longko Saserdote ñi kona Malku ñi reñma, Pedro tañi katrüñmafetew ñi pilun: —¿Kisu eymu miyawpeymu tati anümkawe mew? ");
INSERT INTO arnNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Fey Pedro ka kiñe rupa “kimlafiñ” pi, feymew müten kakaray ti alka. ");
INSERT INTO arnNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jesus nentungetuy Kayfas ñi ruka mew, fey yengey ti Roma tuwchi gobernador ñi ülmen ruka mew. Petu eluwlu am ñi wünael dewma, ti pu judiu konpulay engün ti ülmen ruka mew, fey femle engün yafkaluwafuy ti wimtun dungu ñi nieel ti ley dungu fey ta famngechi femle engün, pepi irkelayafuy ti Paskua pun iyael. ");
INSERT INTO arnNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Feymew Pilato tripapay ñi dunguaetew, fey feypingey engün: —¿Chem dungu mew anta dalluntukupefimün ta tüfachi wentru? ");
INSERT INTO arnNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Fey ti pu judiu llowdungufi ta Pilato: —Fey tüfachi wentru kiñe wesa mongen nienofule, chalintukuleluwlayafuiñ ta eymi ―pi engün. ");
INSERT INTO arnNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Fey feypieyew ta Pilato: —Yetufimün ta eymün, fey ramtukadunguafimün kisu tamün ley dungu mew. Fey ti pu judiu llowdungufi ta Pilato: —Welu taiñ pu judiungen, ngelay taiñ langümafiel ta iney no rume. ");
INSERT INTO arnNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Famngechi mupiy ñi feypikünuel ta Jesus ñi chumngechi layael. ");
INSERT INTO arnNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato wiñome konputuy ñi ülmen ruka mew, fey mütrümfi ta Jesus ka ramtufi: —¿Eymi am tati pu judiu ñi longko ülmen? ");
INSERT INTO arnNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus feypieyew: —¿Fey ramtukapeen eymi kisu tami duam müten, kam kakelu tañi femngechi feypikeetew mew? ");
INSERT INTO arnNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato llowdunguy: —¿Iñche ta judiu tuwünngen? Eymi tami trokiñ tuwünche ka ti longkolelu pu saserdote mew, fey engün may ta wültukupaeymew ta iñche mew. ¿Chem dungu anta femürkeymi? ");
INSERT INTO arnNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus feypi: —Iñche ñi longko ülmenngen tuwlay tüfachi mapu mew. Felefule, iñche nieafun che tañi ingkayaetew iñche tañi wültukungenoafel ti pu judiu mew. Welu iñche ñi longko ülmenngemum tuwlay tüfachi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Feymew Pilato ramtuy: —¿Fey longko ülmen ürke anta eymi? Jesus feypi: —Eymi ta feypimi. Iñche ta longko ülmenngen chumngechi feypimi ta eymi. Iñche ta choyüngen ka küpan ta tüfachi mapu mew tañi feypiael rüfngechi dungu. Fey kom tati koneltulelu ti rüfngechi dungu mew, fey ta allkütukeenew. ");
INSERT INTO arnNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato feypi: —¿Fey chem am tati rüfngechi dungu? ―pi. Fey dew ramtukafilu tüfachi dungu, Pilato ka wiñome tripay ñi dunguafiel ti pu judiu, fey feypifi: —Iñche peñmalafiñ chem welulkan rume tüfachi wentru. ");
INSERT INTO arnNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Feymew lifrekünutuafiñ eymün am wimtulelu iñche ñi lifrenentutuael kiñe püresu tati Paskua kawiñ mew, fey ¿ayüleymün kay tañi lifre tripatuael tati pu judiu ñi longko ülmen? ");
INSERT INTO arnNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Itrokom wiñome wirari engün: —¡Lifrekünutufinge ta Barabas! Fey Barabas kiñe langümchefe ürke. ");
INSERT INTO arnNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Feymew Pilato werküy ñi nüngeael ta Jesus ka ñi wimakangeael. ");
INSERT INTO arnNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Fey ti pu soltaw dewmay engün kiñe wayngechi pülliñ korona, fey tukulelfi engün ta Jesus ñi longko mew, fey ka tukulelfingün kiñe kurü kelü takuwün. ");
INSERT INTO arnNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ka pürüm fülkontufingün, feypilen mew: —¡Mongelepe ti pu judiu ñi longko ülmen! Fey wülelmafi ñi ange engün. ");
INSERT INTO arnNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato wiñome tripapay, fey feypi: —Adkintumün, nentupatufiñ tamün ngüneduamael ñi peñmanoafiel ta Jesus chem yafkan no rume. ");
INSERT INTO arnNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Fey nentungepatuy Jesus fey ti wayngechi pülliñ korona tukuniey kisu ñi longko mew ka tukutuwküley tüyechi kurü kelü takuwün mew. Pilato feypi: —¡Tüfey tañi mülen tamün wültukupaelchi wentru! ");
INSERT INTO arnNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Feymew peetew ti pu longkolelu pu saserdote mew ka ti pu llüwatulekelu ti ngillatuwe ruka mew, eluwi engün ñi wirarael: —¡Langümngepe kürus mew! ¡Langümngepe kürus mew! Fey Pilato feypi: —Yefimün may ka langümfimün ta kürus mew, welu iñche peñmalafiñ chem yafkan no rume kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Feymew ti pu judiu llowdungueyew: —Tüfachi wentru feley ñi layael, iñchiñ am nielu kiñe ley dungu, fey ñi chem pilen taiñ ley dungu feley ñi layael, ‘iñche ta Ngünechen ñi Fotüm’ pikelu am ―pi engün. ");
INSERT INTO arnNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Fey allkülu tüfachi dungu, Pilato rume llükay. ");
INSERT INTO arnNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wiñome konputuy ñi ülmen ruka mew, fey ramtufi ta Jesus: —¿Chew anta tuwimi ta eymi? Welu Jesus llowdungulaeyew chem dungu rume. ");
INSERT INTO arnNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Fey Pilato feypifi ta Jesus: —¿Chumngelu am llowdungulaen? ¿Kimlaymi anta iñche ñi nien ta awtoridad tami langümafiel ta kürus mew ka femngechi tami lifrekünutuafiel? ");
INSERT INTO arnNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Feymew Jesus feypieyew: —Nielayafuymi chem awtoridad no rume ta iñche mew, fey Ngünechen elunofelmew, feymew tüfey tañi wültukuetew ta eymi mew doy fütra welulkay. ");
INSERT INTO arnNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Fey tüyechi lelen mew müten, Pilato rakiduamfuy chumngechi ñi lifrekünutuafiel ta Jesus, welu ti pu judiu wirareleyew: —¡Fey lifrekünutufilmi, weniyelafimi tati emperador! ¡Iney rume longko ülmenkünuwle, fey ta kayñeyefi tati emperador! ―pi engün. ");
INSERT INTO arnNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato allkülu tüfachi dungu, werküy ñi nentungeael ta Jesus, ka pürüm anükünuwi kiñe kues reke tati fütra wangku mew, (fey aramewdungun mew Gabata pingerkey), fey tüfa feypin ürke llüdümkülelu kura mew. ");
INSERT INTO arnNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Petu kiñelewechi antü ñi akuael ta Paskua, epe rangiantülu, fey Pilato feypifi ti pu judiu: —¡Tüfa ta eymün tamün nieelchi longko ülmen! ");
INSERT INTO arnNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Welu kisu engün wirari: —¡Langümngepe! ¡Langümngepe! ¡Langümngepe ta kürus mew! Fey Pilato ramtuy: —¿Iñche anta langümafun tamün longko ülmen? Fey ti pu longkolelu tati pu saserdote mew llowdungueyew: —¡Iñchiñ ta nielaiñ kangelu longko ülmen, tati emperador müten! ");
INSERT INTO arnNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Feymew Pilato wültukufi ta Jesus ñi langümngeael ta kürus mew, fey ti pu judiu yetufi engün ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesus nentungelu, yeniey ñi kürus tañi amuael tati Kalafera pingechi lelfün mew (fey aramewdungun mew Golgota pingey). ");
INSERT INTO arnNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tüye mew langümngepuy wente kürus ka epu weñefe engün, kiñe Jesus ñi man püle, kangelu kisu ñi wele püle elngey. ");
INSERT INTO arnNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato werküy ñi elkünulngeael kiñe letreru Jesus ñi longko püle ti kürus mew, feypilelu chem mew ñi langümngen: ");
INSERT INTO arnNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Rume fentren pu judiu pefi engün tüyechi letreru ñi wirin dungu, fey ti lelfün chew ñi langümngemum ta Jesus püllelerkey ti waria mew, fey tüyechi dungu wiriley ta külarume dungun mew: aramew, latin ka griegu. ");
INSERT INTO arnNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Feymew ti pu longkolelu pu saserdote chillkatulelu ti letreru mew, feypifingün ta Pilato: —‘Tati pu judiu ñi longko ülmen’ pintukukilnge, welu may ‘Tati pu judiu ñi longko ülmenngen pikelu’ pintukuafimi. ");
INSERT INTO arnNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Welu Pilato llowdungueyew: —Tañi wirintukuelchi dungu ta iñche, femngechi wirilepe müten. ");
INSERT INTO arnNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Feyti pu soltaw dew külafantukufilu kürus mew ta Jesus, ñimituñmafingün ñi takuwün, fey wüdamkañmafingün ñi meli takuwün, kake kiñeke soltawngealu. Ka nüfingün ñi puñumtukunieelchi takuwün, tüfa am ñüdüfkülenolu, kiñe wiftun mew müten dewkülelu. ");
INSERT INTO arnNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Feymew ti pu soltaw welukonkechi feypiwingün: —Wikürlayafiyiñ. Suertiayafiyiñ iñchiñ taiñ kimael ñi ineyngeael ti takuwün. Famngechi mupiy tati Wirin Chillka feypilelu: “Kisukengealu engün wüdamkañmaenew ñi takuwün, ka suertiañmaenew iñche ñi takuwün.” Fey tüfa ürke tañi femün tati pu soltaw. ");
INSERT INTO arnNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesus ñi inafül mew mülerkey kisu ñi ñuke, ka kisu ñi ñuke ñi lamngen, Maria, Kleofa tañi kure, ka Maria Magdalena. ");
INSERT INTO arnNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Feymew Jesus pefilu ñi ñuke, mülelu kisu ñi inafül mew, feypifi ñi ñuke: —Iñche ñi ñuke, tüfachi disipulu iñche tañi rume piwkeyenieel, eymi tami püñeñngeay tami piwkeyeaetew. ");
INSERT INTO arnNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ka pürüm feypifi ñi piwkeyenieelchi disipulu: —Tüfachi domo eymi tami ñukengeay. Feymew, üyechi disipulu llowfi kisu ñi ruka mew ta Maria. ");
INSERT INTO arnNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Fey dew rupalu tüfachi dungu, Jesus am dew kimnielu itrokom ñi dew mupin ti dungu, ka femngechi tañi mupin tati Wirin Chillka, feypi: —“Wüywün ta iñche.” ");
INSERT INTO arnNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mülerkey üye mew kiñe fasu apolelu ti füre pulku mew. Ifokünulfi engün kiñe esponja tati füre pulku mew ka trarintukufi engün kiñe pichirumechi mamüll mew, fey fülümelpufingün ñi wün mew. ");
INSERT INTO arnNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesus putufi ti füre pulku, fey feypi: —Itrokom dungu dew mupiy. Fey pürüm potrong nagümi ñi longko ta Jesus, fey ka müten lay. ");
INSERT INTO arnNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Fey umañngewelu ñi akuael tati Paskua kawiñ, fey ti pu judiu ayürkelay engün ti kuerpu ñi müleweael ti kürus mew tati ürkütun antü mew, fey tüyechi ürkütun antü am doy küme dullin antü ürke. Feymew feypifingün ta Pilato ñi werküael tañi trafoñmamengeael ñi chang tati langümel kürus mew ka ñi nentungetuael ti pu kuerpu tati kürus mew. ");
INSERT INTO arnNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Feymew ti pu soltaw amuy engün, fey trafoñmapufi ñi chang tati wüne pepuel, kangelu kafey tati langümel kürus mew Jesus ñi inafül mew. ");
INSERT INTO arnNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Welu fülpulu Jesus mew engün, pefingün ñi dew lan. Feymew trafoñmangelay ñi chang. ");
INSERT INTO arnNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Welu ka femngechi, kiñe ti pu soltaw nülañmafi kiñe püle ta Jesus ñi kadi kiñe wayki mew, feymew müten wütrutripay ko ka mollfüñ. ");
INSERT INTO arnNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Fey ti wirilu tüfachi chillka pefi ñi famngechi femngen ta Jesus, feymew kisu nütramyefi tüfachi dungu, fey feypi ti rüfngechi dungu. Kisu kimniey ñi feypin ti rüfngechi dungu, femngechi eymün tamün feyentuael tatey. ");
INSERT INTO arnNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Fey tüfachi dungu femngechi felerpuy tañi mupiael tati Wirin Chillka ta feypilelu: “Kiñe foro no rume ta trafoñmangelayay.” ");
INSERT INTO arnNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Fey kangelu püle tati Wirin Chillka feypi: “Leliwülafingün tüfey tañi rulmelelchi wayki kisu ñi kuerpu mew.” ");
INSERT INTO arnNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Fey dew rupalu tüfachi dungu, Jose Arimatea tuwlu, dungumefi ta Pilato ñi elutuaetew ta Jesus ñi kuerpu. Jose ta ka femngechi Jesus ñi kiñe disipulu ürke tunte ellkankechi rume tañi llükafiel mew tati longkolechi pu judiu. Pilato elueyew ñi femael, fey Jose yemetufi Jesus ñi kuerpu. ");
INSERT INTO arnNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo, tati amulu pun ñi nütramkameafiel ta Jesus, akulürkey kiñe küla mari kilu perfume, deyükalelu ta mira ka aloe engu tati tukulelngekeel ti dew lalu. ");
INSERT INTO arnNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Fey ta famngechi, Jose ka Nikodemo nüfi engu Jesus ñi kuerpu fey iwüdüfi engu kiñe safana mew küchulelu tati perfume mew, mira ka aloe pingelu, chumngechi ñi wimtun niekakeel tati pu judiu femngechi rüngalayüm engün ñi alwe. ");
INSERT INTO arnNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Feytichi lelfün mew chew ñi langümngemum ta Jesus kürus mew mülefuy kiñe eltun, fey ti eltun mew mülerkey kiñe we rüngan lolo chew iney rume petu rüngalngelay. ");
INSERT INTO arnNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tüye mew rüngalngey Jesus ñi kuerpu feytichi eltun am fülkülelu chew langümngey ta Jesus, fey ka femngechi kiñe umañkülewerkey ñi akuael tati pu judiu ñi ürkütun antü. ");
INSERT INTO arnNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Fey ti semana mew wüne llituelchi antü, Maria Magdalena epe wün amuy ti rüngan lolo mew. Petu dumdumkülerkey, fey pepufi ñi kiñe püle tripalen ti kura takuniefulu ti rüngan lolo ñi konwe. ");
INSERT INTO arnNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Feymew lefkülen amutuy chew ñi mülemum ta Simon Pedro ka ti kangelu disipulu Jesus ñi rume piwkeyefel, fey feypifi: —¡Nentungerkey ti rüngan lolo mew ta Ñidol ñi kuerpu, fey kimlaiñ chew ñi elkünungen! ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro ka ti kangelu disipulu tripay engu, fey amuyngu ti rüngan lolo mew. ");
INSERT INTO arnNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mür engu lefkülen amulerkey, welu kangelu doy matu lefkülen amuy ta Pedro mew, fey wüne puwi ti rüngan lolo mew. ");
INSERT INTO arnNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Potrong nagpuy ñi leliwülpuael, fey pepufi tüyechi iwüdkalechi safana müten, welu konpulay. ");
INSERT INTO arnNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Pedro inangechi puwi, fey konpuy ti rüngan lolo mew, kisu ka pefi ti safana ka ti katrün pañu. ");
INSERT INTO arnNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Fey ka femngechi pefi tati katrün pañu chew ñi munulkülekemum ñi longko ta Jesus ka mülerkey kiñe mew ti safana engu, welu kañpüle wichu iwüdkaleturkey. ");
INSERT INTO arnNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Feymew ka konpuy ti kangelu disipulu tati wüne puwlu ti rüngan lolo mew, fey ngüneduami ñi wiñomongetun ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Fey am petu longkontukurkenolu engün ñi chumngechi feypilen tati Wirin Chillka, fey Jesus felerkefulu am ñi wiñomongetuael. ");
INSERT INTO arnNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Fey ka pürüm tüyechi epu disipulu wiñotuy engu ñi ruka mew, ");
INSERT INTO arnNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","welu Maria Magdalena mülenagi wekuntu, inafül ti rüngan lolo mew, fey mekey ñi ngüman. Petu mekelu am ñi ngüman, fey potrong nagi ñi konkintupuael ti rüngan lolo mew, ");
INSERT INTO arnNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","feymew epu werken püllü lig takuwün mew tukutuwkülelu, anüley chew ñi mülekemum Jesus ñi kuerpu; kiñe metrültuwe püle müley, kangelu namun püle. ");
INSERT INTO arnNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Fey ti epu werken püllü ramtueyew: —Papay, ¿chumngelu anta ngümapapeymi? Fey Maria Magdalena feypi: —Nentungey tüfa mew iñche tañi Ñidol, fey kimlan chew ñi elkünungetun. ");
INSERT INTO arnNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Fey Maria Magdalena feypilu müten, wiñokintuy, fey pefi üye mew ta Jesus, welu kimlafi ñi ineyngen. ");
INSERT INTO arnNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Fey ramtueyew ta Jesus: —Papay, ¿chumngelu anta ngümapeymi? ¿Iney anta kintupefimi? Maria Magdalena rakiduamkülerkey ñi pefiel tati kuydaeltunkelu, fey feypifi: —Chachay, eymi nentufilmi, feypien chew tami elkünufiel, femngechi ta iñche amuan ñi yemetuafiel. ");
INSERT INTO arnNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Feymew Jesus feypi: ¡Maria! Fey Maria Magdalena fülpuy, fey feypifi aramewdungun mew: —¡Raboni! (tüfa “kimeltufe” pin ürke.) ");
INSERT INTO arnNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Fey Jesus feypieyew: —Nükenoeli, iñche am petu amutunolu ñi Chaw mew. Welu amunge ka feypimefinge iñche ñi pu disipulu iñche ñi amutuael ñi Chaw mew, ka femngechi eymün tamün Chaw, iñche ñi Ngünechen ka eymün tamün Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Feymew Maria Magdalena amutuy ñi nütramelmeafiel tati pu disipulu ñi pefiel ta Ñidol ka femngechi nütramelfi ñi chem pietew ta Jesus. ");
INSERT INTO arnNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Fey dew punlu, ti llituelchi antü semana mew, fey ti pu disipulu trawüluwürkey kiñe ruka mew, fente küme rakümniey engün ñi wülngiñ tañi llükaniefiel mew engün ti longkolechi pu judiu. Fey Jesus konpuy, fey ti pu disipulu ñi rangiñ mew witrakünuwpuy, fey chalipuy feypilen mew: —¡Küme tüngün mülepe eymün mew! ");
INSERT INTO arnNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Famngechi feypilu, pengelelfi ñi kuwü ka ñi kadi. Fey kisu engün rume ayüwi ñi pefiel ta Ñidol. ");
INSERT INTO arnNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Fey Jesus ka pürüm feypieyew ka kiñe rupachi: —¡Küme tüngün mülepe eymün mew! Chumngechi ta Chaw werküenew ta iñche ka femngechi iñche werküwayiñ ta eymün. ");
INSERT INTO arnNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Feymew pimu amuley kisu engün mew, fey feypifi: —Llowfimün tati Lif Küme Püllü. ");
INSERT INTO arnNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tüfey engün tamün wiñoduamatuel ta eymün tamün yafkan mew, fey engün ta wiñoduamangeay, tüfey engün tamün wiñoduamanoel, fey engün ta wiñoduamangelayay ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas kiñe tati mari epu disipulu, tüfey tati Epuntun pikeel, ngerkelay feychi konpulu ta Jesus rakümkülelu tati wülngiñ. ");
INSERT INTO arnNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Feymew kakelu ti pu disipulu feypieyew: —Pepefiyiñ ta Ñidol. Welu Tomas llowdunguy: —Iñche peñmanofili kisu ñi kuwü mew ti allfen ñi eleletew ti külafu, fey ka tukunoli ñi changüll kuwü ti allfen mew ka ñi kuwü kisu ñi kadi mew, iñche feyentulayan. ");
INSERT INTO arnNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pura antü rupalu mew ti pu disipulu wiñome trawüluwi engün kiñe ruka mew, fey mülerkey Tomas. Rakümnierkey engün ñi wülngiñ, welu Jesus konpuy, fey kisu engün ñi rangiñ mew witrakünuwpuy, fey ka chalipufi feypilen mew: —¡Tüngkülemün ta eymün! ");
INSERT INTO arnNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Fey pürüm feypifi ta Tomas: —Tukupange tüfa mew tami changüll kuwü, ka leliñmaen iñche ñi kuwü. Ka küpange faw püle fey tukupange tami kuwü iñche ñi kadi mew. Fey yafüwkilpe tami piwke. ¡Feyentunge! ");
INSERT INTO arnNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Feymew wirarüy: —¡Iñche ñi Ñidol ka Ngünechen! ");
INSERT INTO arnNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus feypieyew: —¿Tami pefiel mew wüla feyentuymi? ¡Welu sakinngeay tati feyentulu fey ñi penoetew rume! ");
INSERT INTO arnNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus femürkey rume fentren kakelu afmatufal dungu kisu ñi pu disipulu ñi adkiñ mew fey ñi kimaetew. Fey tüfeychi dungu wirikonkülelay tüfachi lifru mew. ");
INSERT INTO arnNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Welu kiñeke tüfachi dungu müten wiringey femngechi ta eymün tamün feyentuael ta Jesus ñi Cristongen, Ngünechen tañi Fotüm, ka femngechi kisu mew feyentulmün, nieaymün ta rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Dew rupalu tüfachi dungu, Jesus ka wiñome pewfaluwi kisu ñi pu disipulu mew, inafül ta Tiferias pingechi lafken mew. Fey ta famngechi pewfaluwi. ");
INSERT INTO arnNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Kiñentrür mülerkey tüfa engün Simon Pedro, Tomas, tati Epuntun pingekelu, Natanael, Kana waria Galilea trokiñ mapu mew tuwlu, Sefedew ñi fotüm, fey kangelu epu disipulu kafey. ");
INSERT INTO arnNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Fey Simon Pedro feypifi ñi pu kompañ: —Iñche challwayan. Kisu engün llowdunguy: —Iñchiñ ka amuaiñ eymi iñchiñ taiñ challwayael. Fey amuyngün, ka konpuyngün kiñe farku mew, welu tüyechi pun kiñe challwa rume entulay engün. ");
INSERT INTO arnNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Feymew petu eluwlu ñi wünael, Jesus pewfaluweyew ti inafül lafken, welu ti pu disipulu kimlafi engün ñi ineyngen. ");
INSERT INTO arnNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesus ramtueyew: —Pu peñi, ¿kiñe challwa rume nentulaymün am? Kisu engün llowdunguy: —Kiñe challwa no rume. ");
INSERT INTO arnNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Fey Jesus feypi: —Tukufimün ti challwawe tati farku ñi man ad püle, fey nentuaymün ta challwa. Femngechi femingün, feymew pepi nentuwetulay engün ñi challwawe rume fentren challwa ñi rakümtukuel mew engün. ");
INSERT INTO arnNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Feymew tüfeychi disipulu Jesus tañi rume piwkeyeel, feypifi ta Pedro: —¡Ñidol tatey! Allkülu müten Simon Pedro ta “Ñidol tatey”, tukutuwtuy, fey am tukunienofulu takuwün, fey ütrüftukuwi ti pu ko. ");
INSERT INTO arnNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Fey ti kakelu pu disipulu entupatuy engün ñi farku ayliñ mew, wingüdniey ñi challwawe apolelu challwa mew pataka metro mülewelu am ñi fülpuam ta ayliñ mew. ");
INSERT INTO arnNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Fey tripapatulu ti ayliñ mapu mew, pepay engün kiñe üykülechi kütral ka kiñe challwa kangkalelu, ka müley kofke. ");
INSERT INTO arnNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus feypieyew: —Küpalmün kiñe mufü challwa tamün we nentupeel. ");
INSERT INTO arnNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Pedro konpuy ti farku mew, fey wingüdentupay ayliñ mew ñi challwawe rume fentren fütrake challwa nielu pataka kechu mari küla ürke. Tunte pütrünfel rume ti pu challwa, welu ti challwawe wechodülay. ");
INSERT INTO arnNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus feypieyew: —Küpamün tamün ipayael. Kiñe no rume ti pu disipulu fütra piwkewlay ñi ramtuaetew ñi ineyngen ta kisu, kimfilu engün am ta Ñidolngen. ");
INSERT INTO arnNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus pürüm fülpay, nüfi kisu ñi kuwü mew ti kofke, fey kake kiñeke wükan kofke elungey ta kisu engün ka femngechi femi ti challwa mew. ");
INSERT INTO arnNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Fey tüfa ta küla rupachi dewma ta Jesus ñi pewfaluwün kisu ñi pu disipulu mew feychi dew wiñomongetulu. ");
INSERT INTO arnNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Dew ilu engün, Jesus ramtufi ta Simon Pedro: —Simon, Juan ñi fotüm, ¿doy piwkeyeen kay tüfa engün mew? Pedro llowdungueyew: —May, Ñidol. Eymi kimnieymi tami piwkeyefiel. Jesus feypi: —Kamañelen iñche ñi pu che ufisa reke. ");
INSERT INTO arnNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ka wiñome ramtuy: —Simon, Juan tañi fotüm, ¿rüf piwkeyeen am? Pedro llowdungueyew: —May, Ñidol. Eymi kimnieymi iñche piwkeyeeyu. Jesus feypi: —Kamañelen tañi pu che ufisa reke. ");
INSERT INTO arnNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Küla rupachi ramtuy: —Simon, Juan tañi fotüm, ¿piwkeyeen kay? Pedro, weñangkünagi ramtuetew am küla rupachi fey ñi piwkeyefiel, llowdungufi ta Jesus: —Ñidol, eymi kom kimnieymi. Eymi kimnieymi iñche ta piwkeyeeyu. Jesus feypi: —Kamañelen iñche tañi pu che ufisa reke. ");
INSERT INTO arnNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Rüf dungu mew feypiaeyu feychi mew doy wechengelu ta eymi tukutuwkefuymi tami amuael chew tami ayüel. Welu doy putremülmi, epuñpüle norümentuaymi tami lipang fey kangelu tukutuaeymew, ka yeaeymew chew tami ayünoel tami amuael. ");
INSERT INTO arnNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesus feypi tüfachi dungu ñi kimelafiel chumngechi ñi layael ta Pedro, fey ñi püramyeafiel kisu ñi lan mew ta Ngünechen. Fey wüla ka feypifi ta Pedro: —¡Inaen! ");
INSERT INTO arnNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Fey wiñokintulu, Pedro pefi furi püle ñi küpalen tati disipulu Jesus tañi rume piwkeyeel, fey ürke tati mülelu Jesus ñi afkadi mew feychi pun petu ilu engün, fey tati ramtufalngelu: “Ñidol, ¿iney anta wültukuaeymew?” ");
INSERT INTO arnNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Feymew Pedro peetew, ramtufi ta Jesus: —Ñidol, fey tüfachi disipulu kay ¿chumlerpuay? ");
INSERT INTO arnNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus llowdungueyew: —Fey iñche ayüfuli, kisu ta mongeleafuy wiñometuli wüla ta iñche. Eymi ta chumkonlaymi. Fey eymi ta inaen ―pi. ");
INSERT INTO arnNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Fey tüfachi dungu nütramyengey fey tüyechi disipulu ñi larkenoael, welu Jesus feypilay ñi lanoael. Tüfa ürke tañi feypiel: “Iñche ayüfuli, kisu ta mongeleafuy iñche wiñometuli wüla. Eymi ta chumkonlaymi” pingey ta Pedro. ");
INSERT INTO arnNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Fey tüfachi disipulu ürke tati pefilu tüfachi dungu, feymew wirintukufi tüfachi dungu tüfachi chillka mew. Fey küme kimnieiñ kisu tañi feypin tati rüfngechi dungu. ");
INSERT INTO arnNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesus ka femi rume fentren kakelu dungu. Rume fentren tati, fey wirikonfule chillka mew kake kiñeke ñi femelchi dungu ta Jesus, feyngey ta kom mapu mew ñi feynoafel tati wiriafelchi pu lifru. Felepe may.");
INSERT INTO arnNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Iñche tañi wüne wirielchi chillka mew, Teofilo, itrokom wirileleyu tañi chem chumel ta Jesus ka ñi kimeltuel feychi we llitulu müten ñi küdaw. ");
INSERT INTO arnNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Fey püratulu wüla Jesus wenu mapu, fentekünun. Welu petu ñi amutunon, küme kimeltukünufi ti Lif Küme Püllü mew ñi dullielchi pu apostol ñi chem chumael ta kisu engün. ");
INSERT INTO arnNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Rupan lalu am pewfaluwtulu ñi wiñomongetun femngechi ñi kimuwfaluwael rüf mew ñi mongeletun. Meli mari antü pewfaluwmeketuy kisu engün mew ka nütramelmekefi Ngünechen ñi longko ülmenngen. ");
INSERT INTO arnNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Feychi petu mülelu ñi apostol engün, Jesus fente küme kom ngülamkünufi ñi tripanoael engün Jerusalen mew. Fey feypifi: —Üngümaymün ñi mupituael iñche ñi Chaw tamün tukulpakünuletewchi dungu, iñche tamün dew nütrameluwkefiel. ");
INSERT INTO arnNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Feyngey ta Juan ñi fawtisachekefel ko mew, welu kiñe mufün antü rupale, eymün ta fawtisangeaymün reke tati Lif Küme Püllü mew. ");
INSERT INTO arnNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesus ñi walloñmanieetewchi pu che, fey ramtueyew engün: —Ñidol, ¿puwi anta ñi nietuael kiñe longko ülmen ta israel trokiñche? ");
INSERT INTO arnNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesus llowdungufi ti pu che: —Konpalelaymün tamün kimael chumül ka tuntepu ñi femael ta Chaw Ngünechen. Kisu müten ngüneniey ñi pepiluwün mew ñi femaelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Welu akule ti Lif Küme Püllü eymün mew, llowaymün newen ka tripayaymün tamün nütramyemuafiel ta iñche Jerusalen waria mew, kom ti lof mülelu Judea mapu mew, ka Samaria trokiñ mapu mew, ka fütra kamapu amuaymün tuntepu ñi mülen ta mapu. ");
INSERT INTO arnNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Dew feypifilu tüfachi dungu, petu ñi lelinieetew engün, Jesus yengetuy, fey kiñe tromü mew peñchuputuy, fey pewetulafingün. ");
INSERT INTO arnNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Fey petu ñi pürakintulen engün chumngechi ñi püratun ta Jesus wenu mapu, epu wentru fülangtukuluwkülelu pewfaluwi kisu engün mew. ");
INSERT INTO arnNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Fey werken püllü feypieyew: —Galilea tuwchi pu che, ¿chem mew am pürakintuleweymün ta wenu mapu? Tüfachi Jesus eymün tamün rangiñ mew mülepelu, püramngetulu ta wenu mapu, chumngechi pefimün tañi püratun, ka femngechi küpatuay. ");
INSERT INTO arnNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Feymew wiñotuy ti pu apostol tati Olifu pingechi wingkul mew, fey küpatuyngün Jerusalen waria mew. Pichi tripaley, fey pichin müten felerkey ñi trekayawael ta che ti ürkütun antü mew chumngechi ñi feypilen tati ley dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Puwtulu engün ti waria mew, pürapuyngün ti wenulechi pisu ruka mew chew ñi umañtulemum engün. Tüfa engün ürke Pedro, Juan, Santiaw, Andre, Felipe, Tomas, Bartolome, Matew, Santiaw Alfew ñi fotüm, Simon ti Selote, ka Juda Santiaw ñi fotüm. ");
INSERT INTO arnNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kom tüfa engün trawüluwkey ñi ngillatuael, Jesus ñi ñuke ka ñi pu peñi engün ka ti kakelu pu domo engün kafey. ");
INSERT INTO arnNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kiñeke mufü antü mew trawüluwkülerkey ti pu feyentulelu. Fantelerkey engün kiñe pataka epu mari che. Fey Pedro eluwi ñi dunguael, feymew feypi: ");
INSERT INTO arnNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Pu peñi ka pu lamngen, felerkelu am ñi mupiael ti wirikonkülechi dungu ta David ñi piel ti Lif Küme Püllü dungulu kisu mew, Juda ñi chalintukuafiel ta Jesus tati pu wesake che mew. ");
INSERT INTO arnNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Juda iñchiñ taiñ kompañ em, kiñe mew küdawkefuiñ.” ( ");
INSERT INTO arnNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Welu ngillangey mapu tañi kullingepeelchi pülata mew, tañi wesa femel mew ta Juda. Feymew itulnagümkünufi ñi longko, fey pawküy, fey kom ñi küllche püdtripay. ");
INSERT INTO arnNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Feymew kimlu kom ti pu che müleyelu Jerusalen waria mew, kiñe üy tukulelfi engün ti mapu Aseldama pingey, tüfachi dungu feypin ürke “Mollfüñ Lelfün”.) ");
INSERT INTO arnNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Fey ti chillka Salmo mew feypiley: ‘Fey kisu ñi ruka kiñe wellin rukangetupe. Iney no rume mülekilpe tüfey mew.’ Ka feypiley: ‘Kangelu nütupe kisu ñi küdaw.’ ");
INSERT INTO arnNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Fey müley tüfa mew kiñeke wentru taiñ kompañkiyawülkeetew, feychi petu mülelu Ñidol Jesus iñchiñ mew. Fey engün miyawi iñchiñ mew feychi Jesus ");
INSERT INTO arnNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","fawtisaetew ta Juan, fey püratulu wüla ta wenu mapu. Feymew rume kümeay tati kiñe kisu engün mew ñi dullingeael tañi rakintukungeael iñchiñ mew, feymew kiñentrür nütramyeafiyiñ ñi wiñomongetun ta Jesus.” ");
INSERT INTO arnNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Feymew legtungey epu wentru: Jose, Barsaba pingelu (ka Justo pingelu), ka Matia pingelu. ");
INSERT INTO arnNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Feymew famngechi ngillatuyngün: “Ñidol, eymi ta kimnieymi itrokom piwke. Pengelelmuiñ chuchi am ta kiñe tüfachi epu wentru ta dullimi, ");
INSERT INTO arnNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","fey ñi llowael tüfachi küdaw tañi apostolngeael Juda ñi elkünutuelchi küdaw tañi yafkan mew, fey ñi amutuael ti wesa kutrankawün lan mew.” ");
INSERT INTO arnNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Feymew eluwi engün ñi suertiayafiel ti epu wentru, fey legtutripay ta Matia ñi llowafiel ti küdaw. Feychi mew müten rakintukungey ti kakelu pu apostol mew. ");
INSERT INTO arnNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Feychi akulu ti kawiñ antü Pentekoste pingelu, kom ti pu feyentulelu trawüluwküley engün kiñe mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Feykachi müten, kiñe fütra wüwükün nagpay wenu kiñe fütra kürüf reke. Trününi kom ti ruka chew ñi mülemum engün. ");
INSERT INTO arnNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Feymew kake kiñeke che mew pewfaluwi kiñe üykülechi kütral, küde reke felelu. ");
INSERT INTO arnNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kom kisu engün ngünepaeyew ti Lif Küme Püllü, feymew dunguyngün kakerume dungun mew chumngechi ti Lif Küme Püllü ñi adkünuetew ñi dunguael engün. ");
INSERT INTO arnNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Feychi antü mew mülenkepi ta Jerusalen fentren judiuche lif piwke mew mupitulelu ñi wimtun dungu mew, küpalu kom trokiñke mapu. ");
INSERT INTO arnNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Fey ti pu che trawüluwi allkülu ti wüwükün. Kimlay ñi chem rakiduamael engün, kom ti feyentulechi pu che am dungumekelu ti kakerume dungun tañi dungukeel ti kake tripanche. ");
INSERT INTO arnNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Feymew rume ngünelütu afmatuleweyngün, fey welukonkechi feypiwingün: “¿Galilea tuwünche no anta tüfa engün kom tati dungudungungelu? ");
INSERT INTO arnNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Chumngechi anta allküñmafiyiñ engün tañi dungun iñchiñ taiñ dungun mew? ");
INSERT INTO arnNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tüfa mew ta mülenkepi fill mapu küpachi che re kakerume dungun nielu: Partia mapu tuwlu, Meda, ka Elam, Mesopotamia, Judea, ka Kapadosia mapu tuwlu, ka Ponto tuwlu ta Asia trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Tuwlu Frigia ka Panfilia, Egipto ka Libia trokiñ mapu tuwlu, Sirene ñi fülpüle mülelu. Ka kiñekeley Roma tuwlu. ");
INSERT INTO arnNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kiñekentu judiungey choyüngelu müten ka kiñekentu ayülu ñi judiungeael. Ka müley ti pu che tuwlu Kreta ka Arabia. ¡Kom tüfa engün allküñmafiyiñ ñi wewpin Ngünechen ñi afmanngechi dungu iñchiñ taiñ dungun mew!” ");
INSERT INTO arnNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kom ngünelküleweyngün, kimlayngün rume ñi chem rakiduamael, fey welukonkechi ramtuwingün: “¿Chem dungu am tüfa?” ");
INSERT INTO arnNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Welu kiñekentu ayentulen feypingün: “¡Kom ngollileyngün tati!” pingün. ");
INSERT INTO arnNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Feymew Pedro witrapüray kiñentrür ti mari kiñe apostol engün, fey newentu dungun mew feypi: “Pu judiu ka kom che müleyelu Jerusalen waria mew, kimaymün eymün tüfachi dungu, fey küme allkütumün tamün feypiwafiel. ");
INSERT INTO arnNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tüfa engün ta ngollilelay. Eymün ta ngollilelu trokiniefimün, welu we püralepay wüla ta antü, aylla oray wüla tati. ");
INSERT INTO arnNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tüfa mew may ta petu pewfaluwi tañi feypikünuel tati pelon wentru Joel pingelu, feychi feypilu: ");
INSERT INTO arnNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Felerpuay ta kiñe mufülewechi antü mew, pi ta Ngünechen, wülan tañi Küme Püllü kom che mew. Tamün fotüm ka tamün ñawe wewpiay ta iñche mew. Ti pu wecheke wentru pelonchengeay, fey ti putrem fütakeche pewmatuay engün. ");
INSERT INTO arnNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ka feman tañi pu poyepeetew mew. Eluafiñ tañi Küme Püllü tiyechi antü mew, fey wewpiyeaenew engün ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Wenu mapu pengelan fütrake pepiluwün, mollfüñ, ka kütral, ka pitrun tromü ta mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Antü dumiñnagtuay, ka küyen mollfüñ reke feletuay, petu tañi akunon Ñidol Ngünechen tañi dullin antü ka fütra afmatufal antü. ");
INSERT INTO arnNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Welu kom tati maneluwkülelu Ñidol Ngünechen ñi üy mew, fey montuay.’ ");
INSERT INTO arnNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Allkütumün may Israel tuwchi pu che, tañi feypiael ta iñche: Eymün fente küme kimnieymün, Jesus Nasaret tuwlu, Ngünechen tañi küme llowelchi wentrungen, eymün am pefilu ta Jesus ñi femün Ngünechen tañi pepiluwün mew. Pengeli fütrake afmatufal dungu, fey legtuniey Ngünechen ñi pepiluwün. ");
INSERT INTO arnNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Welu eymün, kisu chalintukufimün ti wesake piwke che mew, Ngünechen tañi piel felerpuy, kisu am feypikünurkelu ñi femngeael, eymün ta püresufimün ka langümfimün, kürus mew külafantufimün ti wesake yafkafe pu che engün. ");
INSERT INTO arnNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Welu Ngünechen wiñomongeltueyew, femngechi montulngey ti kutrankawün lan dungu mew, fey ti lan dungu am ngenolu ñi ngünenieaetew ta kisu. ");
INSERT INTO arnNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tati longko ülmen David, wewpiyefilu ta Jesus, feypi: ‘Iñche pekefiñ ta Ñidol Ngünechen iñche ñi fül mew. Kisu rumel mülele iñche ñi man püle, chem dungu no rume wewlayaenew. ");
INSERT INTO arnNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Feymew ayüwkey ñi piwke, fey püramyekefiñ ülkantun mew fentren ayüwün mew. Tuntepule ñi mongen, rumel maneluwkülean kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Rumel mülepe rüngan lolo mew pilayaenew. Elulayafi rume tañi wesañmawael ñi kuerpu tami poyekeetewchi lif piwke kona. ");
INSERT INTO arnNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pengelelen tati küme dungu tañi nieael ta mongen, ka fentren ayüwün eluaen eymi tami ayfiñ mew.’ ");
INSERT INTO arnNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Pu peñi ka lamngen, elumuchi tamün fente küme feypiwafiel: Taiñ kuyfi tuwünche em David lay, fey rüngalngey, welu iñchiñ taiñ mapu mew kisu ñi rüngan lolo petu müley fantepu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David pelon wentru em, ka kimniefuy Ngünechen ñi tukulpakünuletew kiñe kuyalltun mew ñi longko ülmenngeael kiñe ñi yomelche. ");
INSERT INTO arnNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Feymew kisu peniewiyekafuy reke, David ta nütramkay ñi wiñomongetuael ti Cristo, ka feypi tüfa ta rumel mülelayay rüngan mew, ñi kuerpu no rume ñi wesañmanoael. ");
INSERT INTO arnNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iñchiñ ta kimnieiñ Ngünechen tañi wiñomongeltuelchi Jesus. Feychi dungu mew iñchiñ kom küme kimnieiñ. ");
INSERT INTO arnNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Fey kisu ta yengetuy ñi müleputuael Ngünechen ñi man püle, fey llowi ta Chaw mew ti Lif Küme Püllü ñi dew tukulpakünulelngeel, fey tüfachi Küme Püllü kisu elueiñmew. Fey tüfachi dungu lle tamün petu peel ka tamün allküpeel. ");
INSERT INTO arnNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David no tati püralu ta wenu mapu, welu kisu feypi: ‘Fey ti Ñidol feypiñmaenew tañi Ñidol: Anüpange iñche tañi man püle, ");
INSERT INTO arnNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kom famnagümfili wüla tami pu kayñe miñche tami namun mew.’ ");
INSERT INTO arnNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Kimpe kom ti Israel trokiñche, ñi rüf feyngen tüfachi dungu: Jesus eymün tamün langümel kürus mew, Ngünechen ta Ñidolkünueyew ka Cristokünueyew.” ");
INSERT INTO arnNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Fey ti pu che trawüluwküleyelu fey mew, allkülu engün tüfachi dungu, rumeñma pellkey ñi piwke, feymew ramtufingün ta Pedro ka ti kakelu pu apostol: —Pu peñi ka pu lamngen, ¿chem chumaiñ anta iñchiñ? ");
INSERT INTO arnNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Feymew Pedro llowdungueyew engün: —Wiñorakiduamtumün ta Ngünechen mew ka fawtisangeaymün Jesucristo tañi üy mew. Femngechi Ngünechen liftutuaeymünmew tamün yafkan mew, ka femngechi kisu eluaeymünmew feytichi Lif Küme Püllü. ");
INSERT INTO arnNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tüfachi eldungu ta eymünngealu ka tamün pu yomelchengealu ka ti katripanchengealu, ka kom tunten taiñ Ñidol Ngünechen tañi küpa montulael. ");
INSERT INTO arnNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tüfachi nütramtun dungu mew Pedro dungueyew engün ka ngülameyew feypilen mew: —¡Famentuwmün tüfachi wesa mongenngechi pu che mew! ");
INSERT INTO arnNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Feymew ti feyentuñmaetew ñi wewpitun fawtisangey engün. Feychi antü deyükoningün ti mupiltulelu mew küla warangka che. ");
INSERT INTO arnNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kom yafüluwün mew amuleyngün ñi kimeltuetew mew ti pu apostol, kom deyüniey engün ñi chemkün, ka ngillatuleyngün ka trawüluwkeyngün ñi kiñentrür iyael engün ta kofke. ");
INSERT INTO arnNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Itrokom che ngüneduamküley ti afmanngechi dungu mew, fey ñi pengelnierpun Ngünechen ñi pepiluwün ti pu apostol mew. ");
INSERT INTO arnNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ti pu feyentulelu rumeñma kiñewküleyngün, fey ñi nieelchi chemkün kütu wüdamkaluwkeyngün. ");
INSERT INTO arnNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Kiñekentu fendey ñi nieelchi chemkün ka kom ñi nieel engün, feymew wüdamkakey engün ñi pülata fey ñi püneafiel chem ñi duamtuel mew kake kiñeke engün. ");
INSERT INTO arnNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Fill antü trawüluwkeyngün ngillatuwe ruka mew, fey ñi ruka mew kiñentrür ikefuy engün ta kofke, rume ayüwkülen, fey kiñe no rume mallmapiwkengelayngün. ");
INSERT INTO arnNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Püramyekefingün ta Ngünechen ka rume sakieyew engün kom che. Feymew Ngünechen femkünuy kake antü rume fentren che ñi montuael femngechi ñi deyükonael ti trokiñ feyentulelu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kiñe antü, Pedro ka Juan amuyngu ngillatuwe ruka mew küla ora nagchi rupan antü. Feychi ora trawüluwkerkey ñi ngillatuael engün. ");
INSERT INTO arnNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Fey tati ngillatuwe ruka ñi wülngiñ mew, mülepurkey kiñe küntro wentru, choyüngelu müten ñi felen. Fey tüfa yengekerkey fill antü, fey elkünungepukey inafül ti wülngiñ “Rume Adi” pingelu, fey tañi ngillatupülatayafiel tati pu che konkülepulu. ");
INSERT INTO arnNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Fey ti küntro wentru, pefilu ta Pedro ka Juan, epe konkülepulu ti ngillatuwe ruka mew: —Eluen ta pülata ―pifi. ");
INSERT INTO arnNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Fey kisu engu leliwüleyew, fey Pedro fepieyew: —Adkintumuyu. ");
INSERT INTO arnNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Feymew ti wentru fente küme eluwi ñi adkintuafiel. “¿Chem chey eluaenew?” pirkey ñi rakiduam. ");
INSERT INTO arnNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Welu Pedro feypieyew: —Nielan ta pülata oro no rume, welu tañi nieel fey ta eluaeyu: Jesucristo Nasaret tuwlu ñi üy mew, witrange ka trekatunge. ");
INSERT INTO arnNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Feypikünulu, Pedro nüñmaeyew ñi man kuwü, fey witrañpüramngey. Feymew ka müten newentuwtuy ñi namun ka ñi luku. ");
INSERT INTO arnNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Feymew ti küntro witratripay kiñe ringkün mew, fey ka müten trekatuy. Kompañkoni kisu engu mew, fey konpuy ti ngillatuwe ruka mew. Kisu ñi namun mew ringkükawkülen konpuy, fey püramyefi ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kom ñi peetew tañi trekatun ka ñi püramyefiel ta Ngünechen, ");
INSERT INTO arnNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","rume afmatuleweyngün ka pellkey engün femngechi dungu ñi pen mew, kimniefilu engün am ti wentru ka kimingün ñi anükünungeken ñi ngillatupülatayael ti ngillatuwe ruka ñi “Rume Adi” pingechi wülngiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Feytichi tremoltuelchi wentru, küntrongekefulu, pilay ñi püntütripayael Pedro ka Juan mew. Fey kom che afmatulen lefi Salomon ñi trekayawpeyümchi itrotripa wülngiñ ruka mew, chew ta kisu engün ñi trawüluwkülemum. ");
INSERT INTO arnNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro ngüneduamlu tüfa, feypieyew engün: “¿Chem mew anta afmatuleweymün pu israelche? ¿Chem mew anta lelituniemuyu iñchiw? ¿Kisu tayu pepiluwün mew tremolfilu tati wentru ka trekalfilu trokiniemuyu am kam ngillatuyngu Ngünechen mew pileymün? ");
INSERT INTO arnNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraam, Isaak ka Jakob tañi Ngünechen, ka taiñ kuyfikeche em tañi Ngünechen, fütra püramyefi ta Jesus, tañi poyekeetewchi kona, eymün tamün chalintukuel ti pu awtoridad mew. Pilato tañi küpa neykümtufel, welu eymün pilafimün. ");
INSERT INTO arnNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","‘Neykümngetupe tati lif mongen wentru’ tamün piafel, eymün ‘neykümngepe ti wesa langümchefe’ pimün. ");
INSERT INTO arnNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Femngechi langümfimün ta eymün, taiñ eluaetew ta mongen. Welu Ngünechen wiñomongeltueyew, fey iñchiñ feypikeiñ kisu ñi mongeletun. ");
INSERT INTO arnNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Fey tüfachi wentru tamün peel ka tamün kimniefiel, tremolngetuy mupiltun mew ta Jesus ñi üy mew. Tüfeychi mupiltun ta Jesus mew fey ta fente küme tremoltufi, fey kom eymün leliwülnietufimün tatey. ");
INSERT INTO arnNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Dew kimün, pu peñi ka lamngen, eymün ka tamün pu longko langümfilu ta Jesus, femimün fey tamün kimnon rume tamün chummeken. ");
INSERT INTO arnNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Welu Ngünechen femi fütra kuyfi mew tañi feypikünuel kom tañi pu pelonke wentru mew: kisu ñi dullin Cristo tañi lapayael. ");
INSERT INTO arnNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Feymew wiñotumün ta Ngünechen mew ka wiñorakiduamtumün, feymew Ngünechen wiñoduamatuaeymünmew tamün yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ka femngechi Ñidol Ngünechen elutuaeymünmew tamün montuael, ka wiñome werkülelngeaymün ta Jesus, tüfa ta llituka mew müten ta dullingey ñi Cristongeael eymünngealu. ");
INSERT INTO arnNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Welu fantepu mew feley ta Jesucristo ñi müleael ta wenu mapu, fey Ngünechen kom küme elkünule wüla ñi dungu, chumngechi tañi feypikünuel ñi lif mongen pu pelon wentru mew, wewpilu fütra kuyfi mew. ");
INSERT INTO arnNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moyse kimelfi taiñ kuyfike che em: Tamün Ñidol Ngünechen femkünuay tañi müleael eymün mew kiñe pelon wentru iñche reke. Feyentuafimün kom dungu mew tamün chem pietew, ");
INSERT INTO arnNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","kom iney rume feyentunofilu tiyechi pelon wentru, famentungeay ti trokiñche mew. ");
INSERT INTO arnNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Fey itrokom ti pu pelon wentru, Samuel mew llituy ka kom ti pelon wentru dunguyelu, tukulpay ta tüfachi küme antü. ");
INSERT INTO arnNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Eymün ta ka konpaleymün tañi feypikünuel mew ta Ngünechen tañi eldungu ti pu pelon wentru mew, ka konpaleymün tati eldungu mew Ngünechen tañi elkünuel taiñ kuyfi fütakeche em engün. Ngünechen feypifi ta Abraam: ‘Kom trokiñke che mülelu tüfachi mapu mew lloway küme felen eymi tami yomelche ñi duam.’ ");
INSERT INTO arnNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ngünechen wiñomongeltulu ñi poyekeetewchi kona, wüneltu werküfi eymün mew, tamün eluaetew küme fürenen dungu, femngechi ta kake kiñeke ta eymün tamün elkünutuael tamün femkeelchi wesake dungu.” ");
INSERT INTO arnNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro ka Juan petu nütramkamekefilu ti pu che, akurumey ti pu saserdote kompañniefi ti longkolelu ti pu llüwatulekelu ngillatuwe ruka mew ka ti pu sadusew engün. ");
INSERT INTO arnNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Lladkülerkey engün, Pedro ka Juan kimeltumekefilu am ti pu che ka feypingu ñi felen tañi wiñomongetuael tati pu lalu femngechi ta pengelkünungey ta Jesus mew wiñomongetulu am. ");
INSERT INTO arnNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Püresungeyngu, fey dew pu trafialu am, tukukünungey engu karsel mew ñi entungetuael ka antü mew wüla. ");
INSERT INTO arnNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Welu fentren che allkütuyelu tati wewpitun, feyentuyngün. Feytichi trokiñ feyentulu tati rakingelu re pu wentru müten, epe puwfuy kechu warangka che. ");
INSERT INTO arnNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kangelu antü mew trawüluwi tati longkoleyelu ti pu judiu mew, tati putrem fütakeche ka tati pu kimeltukelu ta ley dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ka fey mew mülepuy Anas tati Wünen Longko pu saserdote mew, Kayfas, Juan, Alejandro, ka kom tati konpalelu ti pu saserdote ñi tuwün mew. ");
INSERT INTO arnNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Werküyngün ñi yengeael ta Juan ka Pedro kisu engün mew, fey puwülelngelu ramtukafingün: —¿Iney am werküeymumew? ¿Ka chem pepiluwün mew femimu ta tüfachi dungu? ");
INSERT INTO arnNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Fey Pedro ngünenieetew Ngünechen ñi Lif Küme Püllü llowdunguy: —¡Longkolelu ka putrem fütakeche! ");
INSERT INTO arnNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Eymün ta ramtukamupeyu tayu tremoltufiel mew tati kutran, tamün kimam chumngechi tañi tremolngetun. ");
INSERT INTO arnNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Fachantü may kimaymün, ka kimpe kom ti trokiñche mülelu Israel trokiñche mew. Fey tüfachi wentru, mülelu tüfa mew, tremolngetuy Jesucristo Nasaret tuwlu ñi pepiluwün mew, fey tüfa ta eymün tamün langümel kürus mew ka femngechi tüfa ta Ngünechen tañi wiñomongeltuel. ");
INSERT INTO arnNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Fey tüfachi Jesus ‘tati kiñe kura reke felelu, fey eymün tati pu dewmarukakelu tamün illamel, welu ta tüfa doy poyefal kura reke femkünungetuy.’ ");
INSERT INTO arnNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Kom mapu mew ngelay kangelu Montulchefe, Ngünechen am üytunofilu kangelu. Jesus mew müten müley montun.” ");
INSERT INTO arnNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Feymew ti pu longko ngüneduamlu ñi rume kim dungun ta Pedro ka Juan, ka ngüneduamfilu engün ñi newe fütra kim papeltunon engu, afmatuleweyngün. Feymew küme kimfingün Jesus ñi disipulungen. ");
INSERT INTO arnNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Fey tati tremoltuel am mülelu fey mew, ngelay ñi chem piael engün. ");
INSERT INTO arnNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Feymew feypifingün ñi tripatuael engu ti trawün che mew, fey kisu engün welukonkechi üyawtumekewtuyngün. ");
INSERT INTO arnNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Fey feypi engün: “¿Chumafiyiñ chey tüfachi epu wentru? Kom ti pu che müleyelu Jerusalen waria mew kimingün ñi pengelel engu ti afmanngechi dungu. Ngelay taiñ chumngechi ellkañmayafiel tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Fey ñi nütramyemekewenoafiel engu tüfachi dungu, llükalkatuafiyiñ tañi nütramelnoafiel fey engu ta Jesus ñi üy ta iney no rume.” ");
INSERT INTO arnNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Feymew mütrümfingün ñi feypiafiel ñi kimeltuwenoael engu Jesus tañi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Welu Pedro engu Juan llowdunguy: —Rakiduamllemün may chuchi am doy kümey: eymün tamün müngeltungeael kam Ngünechen tañi müngeltungeael. ");
INSERT INTO arnNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Iñchiw ta ngelay tayu ellkakünuael tüfachi dungu tayu peel ka tayu allküel. ");
INSERT INTO arnNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Fey ti pu awtoridad llükalkatueyew, welu neykümkünungetuy engu. Peñmangelayngu chem mew ñi kutrankangeafel, kom ti pu che am püramyefilu ta Ngünechen feychi dungu ñi rupael mew. ");
INSERT INTO arnNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tati femngechi tremoltuelchi wentru, nierkey doy meli mari tripantu. ");
INSERT INTO arnNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro engu Juan, dew neykümngetulu, amutuyngu ñi trawüluwmetuael ñi pu kompañ engün, fey nütramelfi engu ñi chem pietew ti pu longkolechi saserdote ka ti putrem fütakeche. ");
INSERT INTO arnNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Rupan kom allkütuñmangelu engu ñi piel mew, kiñentrür ngillatuyngün Ngünechen mew feypilen: “Ñidol, eymi ta dewmafimi wenu mapu, ka nag mapu, lafken ka kom tati müleyelu ta mapu mew ka lafken mew. ");
INSERT INTO arnNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tami Lif Küme Püllü dunguy tami poyekeetewchi wentru David mew: ‘¿Chem mew anta wedwedküley tati trokiñche? ¿Chem mew am adkünumekeyngün tati falinochi dungu? ");
INSERT INTO arnNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ti pu longko ülmen ka ti pu awtoridadküleyelu ta mapu mew kiñewingün ñi kayñeltuafiel engün ta Ngünechen tañi dullin Cristongen mew.’ ");
INSERT INTO arnNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Femngechi femürkey ta Erode ka Ponsio Pilato, feychi trawüluwlu tüfachi waria mew tati kake trokiñke mapu tuwchi pu che engün ka ti pu israelche tañi kayñetuñmaetew tami sakin lif piwke kona Jesus, tami dullintuel tañi Cristongeael. ");
INSERT INTO arnNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Fey ta famngechi kisu engün kom femi eymi tami dew adkünuelchi dungu ñi femngechi dungu mew rupayael. ");
INSERT INTO arnNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Fachantü may Ñidol inaduamfinge taiñ kayñetudungumekeetew, kellufinge tami pu kona ñi kimeltuael engün tami dungu ngenollükan mew. ");
INSERT INTO arnNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Eymi tami pepiluwün mew tremolngepe ta kutran, pengelnge Ngünechen ñi femelchi dungu ka afmanngechi dungu eymi tami poyekeetewchi lif mongen kona Jesus tañi üy mew.” ");
INSERT INTO arnNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Fey rupan ngillatulu engün, tañi trawüluwkülemumchi ruka nengümkawi. Fey kom ngünenieeyew engün tati Lif Küme Püllü, fey kimeltuyngün Ngünechen ñi küme dungu. Fey katrütungewelay engün. ");
INSERT INTO arnNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kom tati pu feyentulelu poyewürkeyngün ka ñi rakiduam mew kiñewküley engün. Iney no rume “iñche tañi chemkün ta tüfa” pilay. Kom ngenngelerkeyngün ti chemkün mew. ");
INSERT INTO arnNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tati pu apostol fentren newen mew amulniey ñi nütramyeniefiel femngechi ñi wiñomongetun ta Ñidol Jesus. Ngünechen elueyew lliduamkülen kom kisu engün. ");
INSERT INTO arnNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kiñelelay rume tati fillaluwkülelu kisu engün mew, fey iney rume am nielu mapu kam ruka, fendey engün. Feytichi pülata ");
INSERT INTO arnNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","elukefingün ti pu apostol, fey engün ñi wüdamkalelafiel kom ti pu che tunten ñi duamtuel kake kiñeke engün. ");
INSERT INTO arnNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tüfa ñi femün kiñe wentru, Levi ñi tuwünche, Jose pingelu, trempüramelu ti Chipre pingechi wapi mapu mew. Fey tati pu apostol Bernabe pintukuleltueyew tañi üy (tüfa ta feypiley: yafüluwpemumchi fotüm). ");
INSERT INTO arnNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Fey Bernabe niekerkey mapu, fey fenderkefi, feymew ti pülata wülpafi ti pu apostol mew, kisu engün ñi püneafiel. ");
INSERT INTO arnNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Welu mülekerkey kiñe wentru Anania pingelu ñi üy, ka ñi kure Safira pingelu, fey fendey engu ñi mapu. ");
INSERT INTO arnNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tüfachi wentru kiñewkünurkey ñi kure engu ñi koylatuael, fey rangiñ elkünurkey engu, fey ka rangiñ ti pülata küpali engu ti pu apostol mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Welu Pedro feypieyew: —Anania, ¿chumngelu ngünenkaeymew ta weküfü tami koylatulafiel ta Lif Küme Püllü? Rangiñ elkünuymi tami pülata tami fendeelchi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Eymi tami pülata no anchi? Fenderkelu am tami mapu, fey ¿tami llowelchi pülata, eymi no am tati? ¿Chem mew am rakiduamrumeymi tami femngechi femael? Koylatulpelafimi ta che, welu may Ngünechen ta koylatulpefimi. ");
INSERT INTO arnNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Allkülu tüfa, Anania trananagi pülli mew, fey lay. Fey kom tüfeychi che, kimyelu feychi dungu, llükay. ");
INSERT INTO arnNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Feymew akuy kiñeke wecheke wentru, munulpafingün ti la ka entufingün ñi rüngalmeafiel. ");
INSERT INTO arnNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Küla ora rupalu mew, ka konpuy Anania ñi kure, fey ñi kimnon chem dungu rume. ");
INSERT INTO arnNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Fey Pedro ramtueyew: —Feypien, ¿fendeymu am tamu mapu fenten pülata mew tamu feypiel? Fey kisu llowdunguy: —May, fenten pülata mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro feypieyew: —¿Chem mew anta kiñewkünuymu tamu ngünenkayafiel ta Ñidol Ngünechen tañi Lif Küme Püllü? Tüfey tañi küpaletun tami rüngalmamepeetew tami füta, fey tüfa eymi ka yengeaymi. ");
INSERT INTO arnNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Feymew ka müten trananagi Safira, fey lay Pedro ñi inafül mew. Konpalu ti wecheke wentru, pengepay ñi dew lan, ka yengey ñi rüngalngeael inafül chew ñi rüngalmangemum ñi füta. ");
INSERT INTO arnNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kom ti feyentulelu, ka ti allküleyelu feychi dungu, rume llükayngün. ");
INSERT INTO arnNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Rume fentren afmafalchi pepiluwün ka ngünel dungu pengeli ti pu apostol tati pu che mew. Itrokom trawüluwkeyngün Salomon ñi itrotripa wülngiñ ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Fey iney no rume pilay ñi deyümiyawael ti pu apostol mew, welu ti pu che rumeñma sakinieeyew engün. ");
INSERT INTO arnNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Amuley ñi doy alünngen tati trokiñche, feyentulelu am ta Ñidol Jesus mew fentren wentru ka domo. ");
INSERT INTO arnNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Entukefuy ñi kutran engün ñi yeafiel rüpü mew, fey rupale ta Pedro, ñi llawfeñ rewall ñi rupayael wente kiñeke ti kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ka femngechi ti fülküleyechi waria che küpay engün ta Jerusalen. Küpalyeyngün ñi pu kutran ka ti pu che kutrankamekekeetew ti weküfü. Fey kom tremoltukefuyngün. ");
INSERT INTO arnNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Fey ti wünen longkolelu ti pu saserdote mew ka ti koneltulelu ti pu sadusew ñi trokiñche mew, rumeñma ütriri engün. ");
INSERT INTO arnNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Feymew püresungey ti pu apostol ka tukungey chew ñi karselangekemum chem che rume. ");
INSERT INTO arnNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Welu feychi pun, Ñidol ñi kiñe werken püllü nülapafi ti wülngiñ karsel, fey entungepatuyngün ka feypingeyngün: ");
INSERT INTO arnNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Amutumün, fey nütramelputuafimün ti pu che ngillatuwe ruka mew tüfachi mongen wülkechi werken dungu.” ");
INSERT INTO arnNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Femngechi tañi feypingen mew engün, kangelu antü mew puliwentu amuyngün inafül ngillatuwe ruka mew, fey llituy ñi kimeltuael engün. Fey ti Wünen Longko Saserdote kay ka ñi pu kompañ mütrümfingün kom ti putrem fütakeche ñi trawülafiel kom ti fütake longkolelu. Ka werküyngün ñi entumengeael ti pu apostol karsel mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Welu ti pu llüwatulekelu karsel mew puwlu engün, pengepulayngün. Fey wiñotuyngün ñi fepipatuael, ");
INSERT INTO arnNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","feypilen mew: —Pepuiñ ti karsel fente küme rakümkülelu ka ti pu soltaw llüwatulelu wülngiñ mew, welu nülapulu iñchiñ, iney rume pepulafiyiñ ponwitu. ");
INSERT INTO arnNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Allkülu tüfachi dungu, ti Wünen Longko Saserdote, ka ti longkolelu ti pu llüwatulekelu ti ngillatuwe ruka mew, ka ti longkoleyelu ti pu saserdote mew welukonkechi ramtuwingün ñi chumyawün ti pu wentru ti püresulekelu. ");
INSERT INTO arnNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Petu feypimekelu engün, akuy kiñe wentru, fey feypipay: —Tati pu wentru tamün püresukeel, mekey tañi kimeltuchen ngillatuwe ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ti longkolelu ti pu llüwatulekelu mew, kiñentrür ti pu soltaw engün, amuyngün ñi yemeafiel. Welu kutrankalafingün, llükalelu engün am ñi ütrüftukayaetew ti pu che kura mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Feymew küpalfilu engün, yefi chew ñi trawüluwkülemum ti pu longko, fey ti Wünen Longko Saserdote feypifi ta Juan engu Pedro: ");
INSERT INTO arnNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—¿Feypiwkelayiñ ama tamün kimeltuwenoael feychi wentru tañi üy mew? Welu eymün kom Jerusalen mew kimeltufimün tüfachi ngülam, ka küpa ngeñmalniemuiñ tañi lan mew ta tüfeychi wentru. ");
INSERT INTO arnNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Fey Pedro ka ti kakelu pu apostol engün llowdunguy: —Iñchiñ feley taiñ doy müngeltuafiel ta Ngünechen ta che mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Taiñ fütakeche em tañi Ngünechen wiñomongeltufi ta Jesus, eymün tamün langümel wente kürus. ");
INSERT INTO arnNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ngünechen püramtueyew wenu mapu, fey müleputuy kisu ñi man ad püle, fey adniealu ka montulchealu, femngechi tati fütra israel trokiñche tañi wiñorakiduamtuael Ngünechen mew femngechi ñi wiñoduamangetuam engün ñi yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Fey tüfachi dungu iñchiñ küme kimnieiñ, ka femngechi ti Lif Küme Püllü, Ngünechen ñi wülnieel tañi pu müngeltunieetew mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Allkülu engün tüfachi dungu, rume lladküyngün. “Langümafiyiñ” pifuyngün. ");
INSERT INTO arnNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Welu rangiñ ti pu soltaw mew, mülerkey kiñe farisew Gamaliel pingelu, kimeltukelu ta ley dungu ürke, rume manelnierkeeyew ti pu che. Fey tüfa witratriparkey ka werküy ñi nentungeael ti pu apostol wekun kiñe lelen. ");
INSERT INTO arnNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Feymew feypirkefi ti kakelu pu awtoridad: —Pu israelche, küme rakiduammün tamün chem chumafiel ta tüfachi pu wentru. ");
INSERT INTO arnNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tukulpamün müte kuyfi no witratriparumey Tewda. ‘Iñche ta yamfal wentru’ pirkey, fey meli pataka wentru inañmaeyew ñi ngülam, welu kisu langümngey. Fey ñi inañmakefetew ñi ngülam, kom püdtuy, feymew kom aftuy ñi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Feymew ka, feychi mülelu ti rakituchen, kiñe wentru Galilea tuwlu, Juda pingelu, eluwi ñi trapümcheael. Fey kiñekentu inaeyew, welu ka femngechi langümngey, fey ñi inafetew kom püdtuyngün. ");
INSERT INTO arnNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Feymew iñche ta ngülamuwpeyiñ tamün chummekenoafiel rume tüfachi pu wentru. Tüfa ta che tañi dungungele, afnagtuay. ");
INSERT INTO arnNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Welu Ngünechen tañi dungungele, ngelayay tamün katrütuafiel. Küme inaduammün tamün welulkawnoael, tamün kayñetumekenoafiel ta Ngünechen. Fey kisu engün feyentufingün ta Gamaliel ñi feypietew mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Feymew ka mütrümfingün ti pu apostol, fey wimakafingün ñi kimeltulwenoafiel ti pu che Jesus ñi üy mew. Fey wüla neykümtufingün. ");
INSERT INTO arnNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Feymew ti pu apostol tripapatuy rume ayüwkülen femngechi ñi elukünuetew Ngünechen ñi kutrankawael engün Jesus ñi üy mew. ");
INSERT INTO arnNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Fill antü kimeltuyngün ti küme dungu ñi küpalün ta Jesus ti Cristo, tati ngillatuwe ruka mew ka ti pu rukache mew. ");
INSERT INTO arnNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Feychi mew amulelu ñi doy alün chengen ti pu feyentulelu, tati pu judiu griegudungukelu eluwi ñi tutefaluwnoafiel tati pu judiu ebrewdungukelu, fey feypingün: —Taiñ lantuke pu domo küme poyeñmangekelaiñ tati fill antü wülkeelchi kellutun mew. ");
INSERT INTO arnNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Feymew ti mari epu apostol trawülfi kom ti pu feyentulelu, fey feypifingün: —Kümelay taiñ femkünuael taiñ kimeltuael Ngünechen tañi dungu, taiñ poyecheletuael iyael mew. ");
INSERT INTO arnNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Feymew, pu peñi ka lamngen, dulliaymün regle wentru doy kimyelu ka küme piwkengelu ka manelfal-lu, ka ngünenieetew ti Lif Küme Püllü, fey engün eluafiyiñ tüfachi küdaw. ");
INSERT INTO arnNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Iñchiñ ngillatuleaiñ ka wewpinieaiñ Ngünechen tañi werken dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kom engün adentufi feychi dungu, fey dullingey ta Esteban, kiñe wentru nielu ta mupiltun ka ngünenierkeeyew ti Lif Küme Püllü. Ka femngechi dullingey Felipe, Prokoro, Nikanor, Timon, Parmenas, ka Nikolas, tuwlu ta Antiokia ka kuyfi mew konfulu ti pu judiu ñi wimtun dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Feymew yengeyngün chew ñi mülemum ti pu apostol, fey kisu engün fampuwüli engün ñi kuwü tüfachi pu wentru mew, fey elungey tüfachi küdaw ka ngillatuñmafingün. ");
INSERT INTO arnNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ngünechen ñi dungu doy amuley ñi kimngen, fey ti pu feyentuyelu ka femngechi doy amuley ñi fentren chengen ta Jerusalen waria mew. Kenü kiñeke ti pu judiu tuwünngechi saserdote kütu müngeltufingün ti mupiltun dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban mew müley Ngünechen ñi pepiluwün ka ñi eluetewchi Küme Püllü, fey pengelürkey tati ngünel dungu ka afmatufalchi pepiluwün ti pu trokiñche mew. ");
INSERT INTO arnNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kiñeke ti trokiñche koneltulelu ta sinagoga mew tati pu püresukonangekefulu, ka kiñeke che Sirene tuwlu, ka kiñeke Alejandria tuwlu, ka Silisia ka Asia, fey eluwingün ñi notukadunguafiel ta Esteban. ");
INSERT INTO arnNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Welu pepi wewlafingün dungun mew, Esteban am ti Lif Küme Püllü ñi eluetewchi kimün mew dungumekelu. ");
INSERT INTO arnNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Feymew kullifingün kiñeke che ñi feypiael ñi rüfngen ñi allküñmafiel ñi feypin engün ñi notukadungufiel ta Moyse ñi ley dungu ka Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Fey tüfachi dungu mew lladkülkafingün kom ti pu che feyentulenolu, ti putrem fütakeche ka ti pu kimeltukelu ta Moyse ñi ley dungu. Feymew rültrekafi engün ta Esteban ka püresungey ka yengey chew ñi trawüluwkülemum ti putrem fütakeche. ");
INSERT INTO arnNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ka kintuyngün tati pu dalluntukupualu koyla dungun mew, fey feypipuyngün: “Fey tüfachi wentru fentekünulay ñi wesa pimekeafiel ti lif küme ngillatuwe ruka ka Moyse ñi ley dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Allküñmakefiyiñ ñi feypin tüyechi Jesus Nasaret tuwlu ñi teyfükayafielchi ngillatuwe ruka ka Moyse taiñ elkünuletewchi wimtun dungu ñi kakünungetuael.” ");
INSERT INTO arnNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tati pu awtoridad ka kom müleyelu fey mew adkintufilu engün ta Esteban, peñmafingün ñi ange ñi kiñe pepiluwünngechi werken püllü reke ñi femngetun. ");
INSERT INTO arnNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Fey ti Wünen Longko Saserdote ramtufi ta Esteban ñi rüf dungungepen may ti dungu tañi feypintumekengen mew ta kisu. ");
INSERT INTO arnNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Fey Esteban llowdunguy, fey feypi: “Pu peñi ka fütakeche, allkütumuchi. Taiñ fütra pepiluwünngechi Ngünechen pewfaluwfi taiñ kuyfi füta laku em Abraam pingelu, feychi mülelu ta Mesopotamia mapu mew. Fey petu ñi amunon ñi mülepuwael ta Aran, ");
INSERT INTO arnNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","fey Ngünechen feypieyew: ‘Elnge tami mapu ka tami reñmache, fey amunge tati mapu mew iñche ta pengelelaeyu.’ ");
INSERT INTO arnNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Feymew Abraam tripay ta Mesopotamia chew müley ti pu kaldeache, fey amuy ñi mülepuael Aran pingechi mapu mew. Fey rupalechi tripantu mew lay ñi chaw, fey Ngünechen küpalfi ta Abraam tüfachi mapu mew chew müleymün ta eymün fantepu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Fey Ngünechen elulafi kiñe pichin no rume ñi chem koneltuael tüfeychi mapu mew ñi nüafel ta Abraam. Welu feypikünufi kisu dew lale ñi eluafiel ti mapu kisu ñi pu yomelche. Feychi mew Abraam nierkelay kiñe fotüm no rume. ");
INSERT INTO arnNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ngünechen ka feypifi ta Abraam ñi pu yomelche ñi arimatuleael kiñe kimnoelchi mapu mew ka ñi konayengeael engün ka ñi kutrankawküleael engün meli pataka tripantu. ");
INSERT INTO arnNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Welu ka feypifi: ‘Iñche kutrankayafiñ tati fütra trokiñ mapu tamün konayeetew, fey wüla kisu engün tripatuay tüye mew, fey poyeaenew engün tüfachi mapu mew.’ ");
INSERT INTO arnNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kisu ñi eldungu mew, Ngünechen werküfi ta Abraam tañi llituael tati ngünel sirkunsidangen. Feymew, Abraam, pura antü rupan choyüngelu tañi fotüm Isaak pingelu, fey sirkunsidafi. Ka femngechi Isaak femfi tañi fotüm Jakob pingelu, Jakob ka femngechi femfi tañi mari epu fotüm, iñchiñ taiñ israelchengen taiñ fütake laku em. ");
INSERT INTO arnNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jakob tañi pu fotüm, taiñ kuyfikeche em, ütrirfingün tañi peñi Jose, ka fendefingün tañi yengeael ta Egipto. Welu Ngünechen am füreneniefilu ta Jose, ");
INSERT INTO arnNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","montulfi kom kutrankawün mew. Elufi kimün ka kellufi tañi küme piwketuaetew ta Faraon, ti longko ülmenkülelu Egipto mew, fey kisu dullifi ta Jose ñi longkokünuafiel tati fütra trokiñ mapu Egipto mew, ka ti fütra ülmen ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mülerkey ngüñün ka rume kutrankawün kom Egipto ka Kanaan mew, fey taiñ fütakeche em perkelayngün iyael. ");
INSERT INTO arnNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Welu Jakob kimlu tañi mülen kachilla Egipto mew, werküfi tañi pu fotüm üyew, tüfa engün iñchiñ taiñ fütakeche em ürke. Fewla tañi kiñechi amuael engün. ");
INSERT INTO arnNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Epuchi mew ñi amuael engün, Jose kimuwfaluwfi tañi pu peñi, femngechi kimi ta Faraon ñi feychi tuwünngen ta Jose. ");
INSERT INTO arnNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Feymew Jose yefalpafi tañi chaw Jakob ka kom tañi pu yall, regle mari kechu che ürke engün, ñi puwülngeael engün ta Egipto. ");
INSERT INTO arnNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Femngechi amuy Jakob ta Egipto, fey femngechi lapuy, ka femngechi lapuy taiñ fütakeche em. ");
INSERT INTO arnNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jakob tañi kuerpu yengetuy ta Sikem. Rüngalngey ti eltun mew Abraam tañi ngillael alün pülata mew. Ngillañmarkefi Amor tañi pu fotüm, Sikem mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Feymew dewma fülkülepalu ti medin tripantu Ngünechen ñi mupiael ñi feypikünufielchi dungu ta Abraam, fey Israel trokiñche rume fentren yallürkey engün ta Egipto mew. ");
INSERT INTO arnNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Feymew kangelu Faraon longko ülmenkületurkey ta Egipto fütra trokiñ mapu, fey tachi we longko ülmen kimürkelafi ta Jose. ");
INSERT INTO arnNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Feymew ngünenkañmaeiñmew taiñ trokiñche ka kutrankañmaeiñmew taiñ fütakeche em. Ka aporiafi ñi ütrüfentuafiel engün ñi pichike yall ñi eluafiel tañi layael müten kom tati we choyüngelu. ");
INSERT INTO arnNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Feychi mew choyüngey ta Moyse. Kiñe pichiwentrungey rume ayüeyew ta Ngünechen, fey ñi fütakeche tremümeyew ñi ruka mew küla küyen. ");
INSERT INTO arnNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Fey tukukünumengey pu lewfü. Faraon ñi ñawe ngünayeeyew ka tremümeyew kisu ñi püñeñ reke. ");
INSERT INTO arnNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Femngechi kimeltungey ta Moyse ti pu egiptoche tañi kimün. Fütra pepiluwün wentrungey kimün mew ka kom ñi femkeelchi dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Meli mari tripantu nielu, Moyse eluwi ñi witranngemeael tati pu israelche mew, kisu tañi kiñe ad tuwünche. ");
INSERT INTO arnNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Welu pefilu kiñe egiptoche ñi kutrankamekefiel kiñe israelche, Moyse ingkapufi, wülelkafi ti egiptoche ka langümfi. ");
INSERT INTO arnNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moyse langümfi ti egiptoche rakiduamkülefulu am ñi pu israelche peñi ñi ngüneduamael ta kisu mew tañi montulaetew ta Ngünechen, welu kisu engün ngüneduamlay. ");
INSERT INTO arnNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Ka antü mew, Moyse pefi epu israelche petu kewalu ka wülelkamekewlu engu. Fey kisu ayüfulu am ñi wüdamentuafiel, fey feypifi engu: ‘¿Chumael ta kewapeymu, peñiwenfel ta eymu? ¿Chumael ta wülelkamekewimu ta epuñpüle?’ ");
INSERT INTO arnNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Feymew tati wülelkamekelu tañi kompañ rültrefi ta Moyse, ka feypifi: ‘¿Iney anta kueskünueymew tami ngünekaleael iñchiñ mew? ");
INSERT INTO arnNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Langümafiñ pinieen am chumngechi langümfimi nga wiya tati egiptoche?’ ");
INSERT INTO arnNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Fey allkülu Moyse tüfachi dungun, lefmawi, amuy Madian pingechi mapu mew. Feymew mülepuy katripanche reke, fey tüfey mew niepuy epu fotüm. ");
INSERT INTO arnNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Welu meli mari tripantu rupalu, ti uwe mapu mew, fülpüle ti Sinay pingechi wingkul, kiñe werken püllü pewfaluweyew kiñe üykülechi kütral sarsa mew. ");
INSERT INTO arnNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moyse afmatulewey, pefilu feychi üykülechi kütral, fey fülpulu ñi doy küme peafiel, allküñmafi ñi dungun ta Ñidol Ngünechen, feypilelu: ");
INSERT INTO arnNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Iñche tami fütakeche em tañi Ngünechen. Iñche ta Abraam ka Isaak, ka Jakob tañi Ngünechen.’ Moyse müllmülli fente ñi llükan, fey pellketuy ñi adkintuael. ");
INSERT INTO arnNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Feymew fepieyew ta Ñidol Ngünechen: ‘Nentunge tami okota. Tami pünolemum ta rumeñma yamfali. ");
INSERT INTO arnNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Fente küme kimnien chumngechi ñi kutrankawkülepun tañi trokiñche mülepulu Egipto mew. Allküñmafiñ ñi etüngkümeken ñi ngüman, fey nagpan ñi montulafiel. Feymew tati, küpange, iñche werküaeyu ta Egipto.’ ");
INSERT INTO arnNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Tunte tati pu israelche dew illamtufuy engün rume ta Moyse, feypilu engün am: ‘¿Iney anta üytueymew tami longkoleael ka tami kuesngeael iñchiñ mew?’ Ngünechen ta werküfi ta Moyse tañi longkoleael, fey ñi montulcheael tati werken püllü ñi pewfaluwetew ti sarsa mew. ");
INSERT INTO arnNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Feychi mew Moyse ta nentupatufi taiñ fütakeche em ta Egipto, fey Moyse pengeli ti fütrake pepiluwün ñi peel engün, fey Ngünechen ñi femelchi ngünel dungu meli mari tripantu tiyechi mapu mew, tati Kelü Lafken mew ka ti fütra uwe mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ka tüfachi Moyse ta ka feypifi tati pu israelche: ‘Ngünechen ta werküay tañi tripayael kiñe pelon wentru iñche reke eymün tamün yomelche mew.’ ");
INSERT INTO arnNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ka feychi Moyse ta mülekey feychi trawüluwkülelu ti pu israelche tati fütra lelfün kurantu mapu mew, ka ti werken püllü ñi dunguetew ti Sinay pingechi wingkul mew, ka taiñ fütakeche em engün. Kisurke ta llowfilu tati mongen dungu taiñ nütrameltuaetew ta iñchiñ. ");
INSERT INTO arnNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Welu taiñ fütakeche em müngeltulayngün, ka wiñonentufingün fey ayüy ñi wiñotuael engün ta Egipto. ");
INSERT INTO arnNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Feypifingün ta Aaron ‘dewmalelmuiñ ta dewman ngünechen taiñ rüpütulnieaetew, kimnolu am iñchiñ tañi chumyawün ta Moyse taiñ nentumetuetew ta Egipto.’ ");
INSERT INTO arnNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Feymew dewmayngün kiñe waka kulliñ kechilelu, langümyeyngün ta kulliñ ñi chalintukulelafiel, fey niey engün kiñe fütra kawiñ tañi püramyeafiel ti adentun kisu engün tañi dewmael. ");
INSERT INTO arnNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Feymew ta Ngünechen kisukünutufi engün, fey femkünufi ñi poyeafiel tati wangülen ti mülelu kallfü wenu mew. Femngechi wirikonküley tati pu pelon wentru tañi chillka mew: ‘Pu israelche, meli mari tripantu mülelu eymün tati fütra uwe mapu mew, ¿langümelelmun ta kulliñ ka mañumtumun ama? ");
INSERT INTO arnNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tamün femafel, küpaltufimün tamün püramyeafiel Molok ngünechen ka Refan ngünechen tañi wangülen, dewman pichike ngünechen kisuke eymün tamün adentuel, püramyeafiel ngillatun mew. Feymew ta neykümentukünuwayiñ tati katripanche mapu mew Babilonia ñi doy üyew püle.’ ");
INSERT INTO arnNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Taiñ fütakeche em niekefuy tati uwe mapu mew Ngünechen ñi tolto ngillatuwe ruka chumngechi tañi feypikünungen ta Moyse feychi dewmayafimi pingelu, pefilu am kisu ñi chumngechilen. ");
INSERT INTO arnNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Taiñ fütakeche em llowi ta tüfachi tolto ngillatuwe ruka tañi konpalemum, tati küpayelu Josue engün küpalnierkefi engün ti pichi ruka wewmafilu ñi mapu ti kakelu trokiñche, Ngünechen tañi famentuel ti pu kananche tati pu israelche ñi adkiñ mew femngechi tati tolto ngillatuwe ruka petu mülerkey David mongelelu. ");
INSERT INTO arnNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Fey ti longko ülmen David füreneeyew ta Ngünechen, feymew ayüfuy ñi dewmayael kiñe ngillatuwe ruka Jakob ñi Ngünechenngealu, tañi poyekeel ti pu israelche. ");
INSERT INTO arnNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Welu Salomon ürke dewmay Ngünechen ñi ngillatuwe ruka. ");
INSERT INTO arnNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Welu taiñ Ngünechen mülekelay kuwü mew dewmaelchi ngillatuwe ruka mew. Fey ti pelon wentru feypi: ");
INSERT INTO arnNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Wenu mapu ta iñche ñi ruka reke feley. Mapu ta iñche ñi pünotuwe reke feley. ¿Chumngechi ruka chey dewmalmuan? pi ta Ñidol Ngünechen: Ngelay chem mülewe rume tañi kansatuam. ");
INSERT INTO arnNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ngüneduammün. Iñche ta dewmafiñ kom tati mülechi chemkün’ pi ta Ngünechen.” ");
INSERT INTO arnNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Fey amuley ñi feypilen ta Esteban: “Welu eymün rume wesa longkongeymün, yafüpiwkengeymün ka pikelaymün tamün allkütuael. Rumel katrülkadungukefimün tati Lif Küme Püllü. Tamün fütakeche em reke ta femngeymün. ");
INSERT INTO arnNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Chuchi am tati kiñeke pelon wentru tañi kutrankanoel eymün tamün fütakeche em? Kisu engün langümfi tati nütramkayefulu ñi küpalen ta tiyechi lif mongenngelu, fey tüfachi lif mongenngelu dew akufuy, eymün ta ellka ngünenmafimün ka langümfimün. ");
INSERT INTO arnNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Eymün, ta llowfuymün ta Moyse ñi ley dungu ti werken püllü ñi kimeltuel, fey müngeltulafimün.” ");
INSERT INTO arnNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Allkülu engün tüfachi dungu, fente ñi lladkün mew kütrüreli ñi foro engün ñi üyawtuafiel ta Esteban. ");
INSERT INTO arnNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Welu Esteban ngünenierkeeyew ti Lif Küme Püllü, pürakintuy wenu, fey pefi Ngünechen ñi fütra küme pepiluwün ka pefi ta Jesus ñi witralen Ngünechen ñi manpüle. ");
INSERT INTO arnNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Feymew feypi: “¡Adkintumün! Peniefiñ tañi nülatripalen ta wenu, tati Wentrukünuwpalu ñi nien Ngünechen tañi fütra pepiluwün.” ");
INSERT INTO arnNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Welu kisu engün ngüdikünuy ñi pilun, ka fütra wirarün mew kom lefkontufingün ta Esteban. ");
INSERT INTO arnNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nentupafingün wekuntu waria ka ütrüftukafingün kura mew. Tañi feypintukuetew nentuy engün ñi takuwün engün, fey elkünulelfi ñi penielaetew kiñe weche kona Sawlu pingelu. ");
INSERT INTO arnNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kisu engün mekefi ñi ütrüftukafiel kura mew. Fey Esteban ngillatuy, feypilen mew: “Ñidol Jesus, llowmatuen tañi püllü.” ");
INSERT INTO arnNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Feymew müten lukutukünuwi ka wirari newentu: “¡Ñidol lelituñmakefilnge tañi femmekeetew engün!” Feypikünulu kom tüfachi dungu, lay. ");
INSERT INTO arnNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawlu mülerkey tiye mew, feymew “lape müten” piniefi ta Esteban. Feychi mew müten llituy ñi rume kayñetuyawülngeael Ngünechen ñi trokiñche, feymew tripay engün Jerusalen waria mew. Kom püdyey engün Judea ñi trokiñ mapu püle ka Samaria püle, welu ti pu apostol femlay. ");
INSERT INTO arnNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kiñeke küme piwkengechi wentru rüngalfingün ta Esteban ka rumeñma ngümayngün kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Welu Sawlu, amuley ñi inantukuyawülfiel Ngünechen ñi trokiñche. Kom rukache mew konkiyawi ñi wingüdentumeafiel ti pu wentru ka ti pu domo ñi püresuntukuafiel karsel mew. ");
INSERT INTO arnNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Welu tati tripayelu ta Jerusalen mew nütramyeniefingün tati werken dungu chuchi püle rume tañi puwmum engün. ");
INSERT INTO arnNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe, ta kiñe ti wemüel, amuy ti trokiñ mapu Samaria ñi doy fütra waria mew, fey nütramyepufi ta Cristo. ");
INSERT INTO arnNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Fey ti pu che trawüluwkey ñi allkütuñmayafiel Felipe ñi nütram, fey peyngün ñi afmafalchi dungu ñi femel Ngünechen ñi pepiluwün ta Felipe. ");
INSERT INTO arnNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pütrün che konweküfülelu, tremoyetuy. Fey ti pu weküfü wirarkülen tripayetuy engün. Ka pütrün lañmalelu ñi kuerpu ka ti pu küntrolechi che tremoyetuy. ");
INSERT INTO arnNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Fey tüfachi dungu mew rumeñma ayüwün müley feychi trokiñche mew. ");
INSERT INTO arnNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Welu mülerkey tüye mew kiñe wentru Simon pingelu. Kuyfi inaniekerkey kalku dungu ka ngünenkakerkefi Samaria tuwchi pu che. Rume falintuwkülerkey ñi femngechi wentrungen mew. ");
INSERT INTO arnNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Itrokom fütakeche ka pichikeche allkütuñmakerkeeyew ñi dungu ka rume trüftun mew feypikefuyngün: “Fey tüfa tati feypikeel Ngünechen tañi fütra pepiluwün.” ");
INSERT INTO arnNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Rume feyentungerkefuy; kisu ñi kalku dungu mew rume fentreñma ngünenkachelerkey. ");
INSERT INTO arnNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Welu feyentulu ti küme dungu mew engün Felipe ñi kimeltuetew Ngünechen ñi longko ülmenngen ka Jesucristo, tati pu wentru ka fentren domo fawtisangey engün. ");
INSERT INTO arnNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ka femngechi ta Simon feyentuy ka fawtisangey, ka pürümkachi kompañkiyawülfi ta Felipe, afmatuniefi pefilu ti fütrake pepiluwün ka ti afmafal dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Fey ti pu apostol mülelu Jerusalen, kimlu engün ti pu samariache ñi feyentun engün Ngünechen ñi dungu, werküfingün ñi amuael ta Pedro ka Juan. ");
INSERT INTO arnNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Puwlu engu, ngillatuñmapufingu ti feyentulechi pu samariache, ñi llowafiel engün ti Lif Küme Püllü, ");
INSERT INTO arnNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","petu llownolu engün am kiñe no rume ti Lif Küme Püllü. Re fawtisangey engün Ñidol Jesus mew müten. ");
INSERT INTO arnNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Feymew Pedro engu Juan fampuwüli engu ñi kuwü kisu engün mew, fey femngechi llowi engün ti Lif Küme Püllü. ");
INSERT INTO arnNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon, pefilu ti Lif Küme Püllü ñi akuken ti pu apostol fampuwüliyüm ñi kuwü ti pu che mew, ayüfuy ñi kulliafiel ta pülata, ");
INSERT INTO arnNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ka feypifi: —Elumuchi kay iñche feychi pepiluwün, femngechi iney rume fampuwülelfili ñi kuwü lloway ti Lif Küme Püllü. ");
INSERT INTO arnNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Feymew Pedro llowdungueyew: —¡Kondenangeaymi tami pülata eymu, rakiduamlu am eymi tami ngillayafel pülata mew Ngünechen ñi re wülkeelchi pepiluwün! ");
INSERT INTO arnNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Eymi ta pichi konpalelaymi rume tami llowafiel taiñ femkeelchi dungu, Ngünechen ta pelotunieñmaeymew tami piwke tañi lifngenon kisu ñi adkiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Elkünutufinge ti wesa dungu tami femkeel, ka ngillatufinge ta Ngünechen femngechi tami wiñoduamatuaetew tami femngechi rakiduamfel mew. ");
INSERT INTO arnNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kangentueyu tami rume wesaduamkülen, tami yafkan ta püresunieeymew reke. ");
INSERT INTO arnNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Fey Simon llowdunguy: —Ngillatuñmamuchi eymu ta Ñidol mew, tañi akunoael tati wesa dungu tamu feypimufiel. ");
INSERT INTO arnNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Rupan nütramyelu ka kimeltulu Ngünechen ñi dungu, ti pu apostol kimeltuy ti ayüwünngechi küme dungu, fentren lof mapu mew mülelu Samaria püle, fey wiñotuyngün ta Jerusalen waria mew. ");
INSERT INTO arnNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Rupalu kom tüfachi dungu, Ñidol tañi kiñe werken püllü feypifi ta Felipe: “Witratripange. Amuaymi waywen püle Jerusalen ñi rüpü mew, amulelu ta Gasa.” ");
INSERT INTO arnNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Fey Felipe witrapüray ka amuy, fey pewürkey kiñe wentru Etiopia tuwlu. Kiñe ülmen funsionario ürke. Tesorero nieeyew Etiopia mew mülechi longko ülmen domo, wiñolemerkey Jerusalen püramyemepefilu ta Ngünechen ti ngillatuwe ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Amuleturkey kisu ñi trokiñ mapu mew. Anükonküley ñi karetela mew. Chillkatulen amuletuy ti pelon wentru Isaia ñi wirintukukünuelchi dungu ti Wirin Chillka mew. ");
INSERT INTO arnNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Fey ti Lif Küme Püllü feypifi ta Felipe: “Fülpunge ti amulechi karetela mew.” ");
INSERT INTO arnNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Feymew fülpulu ta Felipe, allküñmafi ti etiopiache ñi chillkatupen Isaia ñi wirielchi dungu ti Wirin Chillka mew, feymew ramtufi: —¿Ngüneduamfimi kay tami chillkatupeel? ");
INSERT INTO arnNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Fey ti Etiopiache llowdungueyew: —¿Chumngechi am kimafun, ngenolu iney rume ñi feypiafetew ñi chem pifel ta tüfachi dungu? Feymew feypifi ta Felipe: —Pürapange. Anüpange iñche ñi ina püle. ");
INSERT INTO arnNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Fey tüfa ürke tati troy dungu tañi chillkatunierpuel: “Kiñe ufisa reke yeniengey tañi langümngeael. Kiñe we pichi ufisa reke dungulay tati pu kediñkakelu mew, ka femngechi lle kisu ta dungulay. ");
INSERT INTO arnNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Illamtukangey, elungelay ñi ingkawael nor dungu mew. ¿Fey ñi wesa femel ti pu che kisu mew iney kay nütramyeafuy? Kisu am langümngelu tüfachi mapu mew.” ");
INSERT INTO arnNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Fey ti etiopiache ülmen wentru ramtufi ta Felipe: —Füreneen. Feypien, ¿iney anta nütramyeniefi tüfa mew tati pelon wentru? ¿Kisutu pemay nütramyeniewi kam kangelu ta nütramyeniefi? ");
INSERT INTO arnNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Feymew Felipe llituy ñi kimeltuafiel ñi chillkatunierpuelchi dungu tati etiopia wentru, fey kimelelfi tati troy dungu Jesus tañi tukulpaniefiel. ");
INSERT INTO arnNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Alüñma amulelu engu, rumerpuyngu chew ñi mülemum ta ko, fey ti etiopia wentru feypi: —Tüfa mew müley ta ko. ¿Kümepelaafuy may ñi fawtisangeael ta iñche? ");
INSERT INTO arnNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Fey Felipe feypi: —Rüf kom piwke mew feyentulmi, femafuymi. Fey llowdunguy ti etiopia wentru: —Feyentun ta Jesucristo ta Ngünechen ñi Fotümngen. ");
INSERT INTO arnNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Feymew werküy tañi witrakünuael tati karetela. Fey naglu, amuy engu ko mew, fey Felipe fawtisaeyew. ");
INSERT INTO arnNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Fey tripatulu engu ti ko mew, Ngünechen tañi Lif Küme Püllü kañpüle yetufi ta Felipe, fey ti etiopia ülmen wentru pewetulafi ta Felipe, welu rume ayüwkülen inatuy ñi rüpü ti etiopia wentru. ");
INSERT INTO arnNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe pewfaluwtuy ta Asoto waria mew. Rumerpuy kom waria mew ñi kimelkiyawael ti küme dungu, fey puwtuy wüla ta Sesarea mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Welu Sawlu fentekünulay tañi “langümaeyu” ñi piyeafiel tati pu feyentulelu ta Ñidol mew. Feymew amuy nütramkameafilu ti Wünen Longko Saserdote. ");
INSERT INTO arnNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Eluen kiñe wirin werkün dungu” pimefi, fey ñi amuael Damasku mülechi sinagoga mew ñi kintumeafiel tati inanielu ti we kimeltun, tati pu wentru ka ti pu domongeay rume, ñi püresuküpalafiel ta Jerusalen. ");
INSERT INTO arnNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Welu dewma fülpulu ta Damasku waria mew, kiñe pelon küpalu wenu mapu wilüfrumepay kisu ñi inafül. ");
INSERT INTO arnNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sawlu ütrüfnagi pülli mew, ka allküy kiñe dungun feypilelu: —Sawlu, Sawlu, ¿chem mew anta üyawtu inayawülen? ");
INSERT INTO arnNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Fey Sawlu ramtuy: —¿Iney am ta, eymi Ñidol? Fey ti dungun llowdungueyew: —Iñche ta Jesus, fey eymi tami üyawtu inayawülel. ");
INSERT INTO arnNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Rume kuñiwünngey tami famtukumekewün ti wechuñngechi wayki mew reke felelu. Fey Sawlu müllmüllkülen ka rume llükalen feypi: —Ñidol, ¿chuman am tüfa? Fey Ñidol feypieyew: —Witratripange. Konpunge ti waria mew, feymew feypingeaymi tami chumael. ");
INSERT INTO arnNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sawlu tañi pu kompañ rume llükay, allküfilu engün am ti dungun, welu fey ñi penofiel engün iney no rume. ");
INSERT INTO arnNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Feymew müten Sawlu witrapüratuy pülli mew, welu lelitulu, pelolay. Feymew küñatu yengey kuwü mew ta Damasku. ");
INSERT INTO arnNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Küla antü mülepuy fey ñi pelonon. Ilay ka pütokolay rume. ");
INSERT INTO arnNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasku waria mew mülerkey kiñe feyentulelu Anania pingelu. Amelürkefi ta Ñidol Jesus, feymew feypieyew: —¡Anania! Kisu llowdunguy: —Tüfa tañi mülen, Ñidol. ");
INSERT INTO arnNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ñidol ta feypieyew: —Witrapürange. Amunge Üngkü pingechi kalle mew, Juda tañi ruka mew. Ramtupuaymi kiñe wentru tuwlu Tarso, Sawlu pingelu. Mekey ñi ngillatun. ");
INSERT INTO arnNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Fey amelfi ñi konpun kiñe wentru Anania pingelu ka ñi fampuwülelpuetew ñi kuwü kisu mew ñi wiñome pelotuam. ");
INSERT INTO arnNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Fey tüfa allkülu, Anania feypi: —Ñidol rumeñma nütramkangeken may ñi chumngen tüfachi wentru ñi kom wesa femkefiel Jerusalen mew tami feyentukeetewchi trokiñche. ");
INSERT INTO arnNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Fey tüfa mew ka küpay tatey ñi werküetew ti longkolelu ti pu saserdote mew, ñi püresuyetuafiel kom tañi püramyekeetew ta eymi. ");
INSERT INTO arnNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Welu ta Ñidol feypieyew: —Amunge müten. Dullintufiñ ta tüfachi wentru tañi dunguael ta iñche mew ñi wewpiyeaetew kakelu fütrake lof mapu mew mülechi pu che mew, ka ñi pu awtoridad, ka ti pu israelche. ");
INSERT INTO arnNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kimelafiñ tunten tañi kutrankawael ta kisu iñche ñi duam. ");
INSERT INTO arnNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anania amuy ti ruka mew ñi mülemum ta Sawlu. Fey konpulu, fampuwüli ñi kuwü kisu mew ka feypifi: —Peñi Sawlu, tati Ñidol Jesus, tami pewfaluwetew rüpü mew tami küpalekemum, werküenew tami pelotuael ka tami ngünenieetew tati Lif Küme Püllü. ");
INSERT INTO arnNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Feymew müten Sawlu ñi epu nge mew llangkünagtuy trolüf trawa reke felelu, fey pelotuy. Feymew witratripay ka fawtisangey. ");
INSERT INTO arnNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Fey ka ituy, fey newenngetuy. Fey kiñe mufün antü mülewey ti feyentuleyelu engün tati mülelu Damasku waria mew. ");
INSERT INTO arnNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Feymew ka müten Sawlu sinagoga mew llituy ñi wewpiyeafiel ta Jesus Ngünechen ñi Fotümngen. ");
INSERT INTO arnNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kom ti allkütuñmaetew ñi wewpin rume afmatuleweyngün ka feypingün: “¿Tüfa no am tati inantukuyawülkefilu ta Jerusalen mew ñi püresuafiel tati pu nütramyekefilu ta Jesus? ¿Kisu no am chey tati küpalu tüfa mew tañi püresuafiel tati feyentulelu Jesus mew ka ñi chalintukulelafiel tati longkolelu ti pu saserdote mew?” ");
INSERT INTO arnNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Welu Sawlu doy yafüluwkülen dungumekey. Welulkawi ñi rakiduam ti pu judiu mülelu Damasku waria mew, kimeltulfilu am ta Jesus ñi rüf Cristongen. ");
INSERT INTO arnNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kiñe mufü antü rupalu, ti pu judiu kiñewingün ñi langümafiel ta Sawlu, ");
INSERT INTO arnNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","welu kisu kimürkey. Antü ka punngeay rume üngümniengefuy ti wülngiñ mew chew ñi tripakemum ti waria che, fey ñi langümngeafel, ");
INSERT INTO arnNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","welu ti pu feyentuyelu tukukünueyew kiñe fütra kanasta mew, fey pun pültrüentukünungetuy wekuntu ti fütrapüra kura malal mew walloñmaniefilu ti waria. Femngechi montuy. ");
INSERT INTO arnNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Puwlu Sawlu ta Jerusalen waria mew, ayüfuy ñi trawüluwael ti feyentulechi pu che engün, welu kom llükaeyew engün. Feyentungelay Sawlu tañi feyentulen kay ta Ñidol mew. ");
INSERT INTO arnNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Feymew, Bernabe yeeyew, fey chalintukupueyew ti pu apostol mew. Nütramelpufi Sawlu tañi pefiel ta Ñidol rüpü mew, ka femngechi Ñidol tañi dunguetew, ka Damasku mew Sawlu ñi nütramyefiel ta Jesus ngenollükan mew. ");
INSERT INTO arnNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Feymew Sawlu mülewenagi Jerusalen mew, fey kiñentrür miyawürkey ti pu feyentulelu engün mew. Nütramyefi ta Ñidol ngenollükan mew. ");
INSERT INTO arnNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nütramkaniefi ka üyawtuniefi ti pu judiu ka ti pu judiu griegudungukelu, welu tüfa engün küpa langümürkeeyew. ");
INSERT INTO arnNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Welu tati feyentulechi pu peñi kangentuy ti pu judiu ñi femngechi rakiduamkülen engün, fey Sawlu yengey Sesarea waria mew mülelu ina lafken. Fey tiye mew werküngey ñi amuael ta Tarso waria mew. ");
INSERT INTO arnNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Feymew ti feyentulechi trokiñche ka itrokom ti mülelu Judea ñi lof mapu mew, Galilea ka Samaria, nietuyngün ta küme tüngkülen ka doy amuley ñi kimün Ñidol ñi dungu mew. Kisu engün ñi mongen mew yamniefi ta Ñidol ka ti Lif Küme Püllü kellunieeyew engün, feymew amuley ñi doy alünngerpun ti pu feyentulelu. ");
INSERT INTO arnNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro witranngeyawi tañi feyentulechi pu che mew ka amurpuy Lida waria mew ñi pemeafiel tati pu feyentulelu. ");
INSERT INTO arnNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Üye mew pepuy kiñe wentru Enea pingelu, pura tripantu amulnierkey dewma ñi ngütantuluwküleken müten, lañmalelu am ñi kuerpu. ");
INSERT INTO arnNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro feypifi ta Enea: —Enea, Jesucristo ta tremoltueymew. Witratunge. Elkünutunge tami ngütantu. Feymew müten Enea witratuy. ");
INSERT INTO arnNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Fey kom ti pu che müleyelu Lida ka Saron waria mew pefingün ñi tremotun ka ñi witratun, feymew feyentuyngün ta Ñidol Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Feychi mew mülerkey Jope pingechi waria mew, kiñe feyentulechi domo, Tabita pingerkey ñi üy, griegudungun mew Dorka pin ürke. Fey tüfachi domo rumel küme piwketuchekerkey ka rume kellukerkefi kom ti pu pofrengelu. ");
INSERT INTO arnNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Feychi antü mew, Dorka kutranürkey, fey lay. Fey ñi kuerpu, rupan küchañmangelu, elkünungerkey kiñe katrüntuku ruka mew mülelu wenu ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope pichi tripalerkey Lida waria mew, fey mülepurkey üyew ta Pedro. Fey ti pu feyentulelu, kimlu Pedro ñi mülepun üye mew, werküyngün epu wentru ñi feypimengeael: —Küpayafuymi ta Jope pürümka müten. ");
INSERT INTO arnNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro amuy kiñentrür kompañuwkülen ti epu wentru engün. Fey puwlu, yengey ti katrüntuku ruka mew chew ñi mülemum ti la. Walloñmaeyew ti lantuke domo, fey ngümalen pengelyeyngün ñi pollera ka ñi ükülla Dorka ñi dewmakefel petu mongelelu. ");
INSERT INTO arnNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Feymew Pedro “kom tripamün wekun” pifi ti pu che, fey lukutuy ka ngillatuy. Feymew leliniewefi ti la, fey feypifi: —¡Tabita, witratunge! Fey ti la lelituy, fey pefilu ta Pedro, anüpüray. ");
INSERT INTO arnNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Feymew Pedro nükünufi ñi kuwü mew, fey witrañpüramfi. Fey mütrümyetufi ti pu feyentuleyelu ka ti lantuke domo pengeltufi ñi mongetun. ");
INSERT INTO arnNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Fey tüfachi dungu kimi kom ti pu che mülelu Jope, feymew pütrün che feyentuy ta Ñidol Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro kiñe mufün antü mülewey ti waria mew, kiñe wentru ñi ruka mew, Simon pingelu, kiñe lawümkelu trülke kulliñ ürke. ");
INSERT INTO arnNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mülerkey kiñe wentru Sesarea waria mew Korneliu pingelu, kapitankülelu ti trokiñ soltaw mew Italia tuwünche pingelu. ");
INSERT INTO arnNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Rume kutranduamyechenngerkey, ka kom tañi rukantukunieel ñi reñma engün ngillatukerkey ta Ngünechen mew. Ka wülkerkey rume fentren pülata ñi kellungeam ti pu judiu, ka rumel ngillatulekerkey Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kiñe antü küla ora nagchi antü mew, fey pewfaluwürkeeyew kiñe werken püllü. Fente küme pefi Ngünechen ñi werken püllü ñi konpun chew ñi mülemum kisu, fey feypieyew: —¡Korneliu! ");
INSERT INTO arnNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Fey Korneliu leliniewefi tati werken püllü, rume llükan mew ramtufi: —¿Chem anta duamimi, Ñidol? Fey ti werken püllü feypieyew: —Ngünechen allküñmaeymew tami ngillatun ka küme trokitueymew tami kellukefiel mew tati duamlu ñi fürenengeael. ");
INSERT INTO arnNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Werkünge kiñe che ñi amuael Jope waria mew tami yefalmeafiel ta Simon, Pedro ka pingekey ñi üy. ");
INSERT INTO arnNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Umañküley ta Simon tañi ruka mew kiñe lawümkelu trülke kulliñ inaltu lafken mülelu. ");
INSERT INTO arnNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Amutulu tati werken püllü tañi dungupaetew, Korneliu mütrümi epu tañi poyekeetewchi kona ka kiñe ñi soltaw rume yamniefilu ta Ngünechen ka tañi manelnieel. ");
INSERT INTO arnNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Feymew kom nütramelkünufilu, werküfi ñi amuael ta Jope. ");
INSERT INTO arnNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Fey ka antü mew, dewma rangiantülu, petu ñi amulen engün rüpü mew, dewma fülpulu Jope, Pedro püray ñi ngillatuael wenu ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Rume ngüñülerkey ka ayülerkey ñi iyael, fey petu dewmalelngelu iyael, pey kiñe afmanngechi dungu: ");
INSERT INTO arnNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Pefi ñi wengan kallfü wenu ka ñi nagkülepan mapu mew kiñe fütra katrün pañu kechilelu, trarilelu ñi meli wechuñ mew. ");
INSERT INTO arnNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Fey tati katrün pañu mew müley epe fill meli namunngechi kulliñ ka ti winolkiyawkelu mapu mew ka ti pu üñüm, kom tati pu judiu ñi ikenoel. ");
INSERT INTO arnNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ka allküy kiñe dungun ñi feypietew: —Witratripange, Pedro. Langümfinge ti pu kulliñ ka ifinge. ");
INSERT INTO arnNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro llowdunguy: —Femlayan, Ñidol. Chumkawnorume ikelafiñ tüfachi ikenoel ka ti ünunngechi kulliñ. ");
INSERT INTO arnNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Fey ka wiñome allküfi ti dungun ñi feypietew: —Ngünechen tañi liftuel tañi ingeael tati ikenoel ‘ünunngey’ pikefilnge ta eymi. ");
INSERT INTO arnNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tüfa küla rupachi feypingey, fey tati fütra katrün pañu ka püramngetuy wenu mapu. ");
INSERT INTO arnNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro küme duamwelay, fey rakiduamkülewetuy ñi chem pifel tiyechi dungu tañi peel. Feychi lelen mew müten akuy ti wülngiñ mew Korneliu ñi werküelchi pu wentru, fey ramtupuyngün chew ñi mülen ta Simon ñi ruka. ");
INSERT INTO arnNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Puwlu engün, ramtuyngün fütra newentu dungun mew: —¿Tüfa mew anta umañtuley tati Simon pingelu, ka kiñeke mew Pedro pingekelu? ");
INSERT INTO arnNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro petu rakiduamkülerkey tañi peel mew, feymew tati Lif Küme Püllü feypieyew: —Tüfey, küla wentru ta kintuyawüleymew. ");
INSERT INTO arnNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Witratripange, nagnge tami amuael kiñentrür tati pu wentru engün, fey ka rakiduamkilnge. Iñche werküfiñ engün tati. ");
INSERT INTO arnNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro nagpay ka feypifi tati pu wentru: —Iñche tati tamün kintuyawülel. ¿Chem dungu mew anta wütumupan? ");
INSERT INTO arnNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kisu engün llowdunguy: —Tati kapitan Korneliu ta werküeiñmew, kiñe nor mongen wentru, rume ngillatukey Ngünechen mew, ka kom ti pu judiu rume küme duamtukeeyew ka rume sakieyew. Ngünechen ñi werken püllü feypieyew tami mütrümfalaetew ta eymi, fey eymi tami amuael kisu tañi ruka mew, fey kisu tañi allkütuael eymi tami kimeltun. ");
INSERT INTO arnNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Feymew Pedro “konpamün” pifi ti pu werken, fey umañtuy engün tüyechi pun. Fey ka antü mew, Pedro amuy kiñentrür tüfachi pu wentru engün, feymew kompañeyew kiñeke feyentulechi pu che müleyelu ta Jope waria mew. ");
INSERT INTO arnNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Fey kangelu antü mew, puwingün ta Sesarea chew tañi üngümkülemum ta Korneliu ka trawülniey tañi pu reñma ka tañi pu weni kisu tañi mangelyeel. ");
INSERT INTO arnNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Feymew Pedro puwlu tati ruka mew, Korneliu llowpaeyew, fey lukutuy ñi llellipuafiel ta Pedro. ");
INSERT INTO arnNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Welu Pedro witrañpüramtufi, feypilen mew: —Witratunge, iñche ta ka femngechi wentru eymi reke. ");
INSERT INTO arnNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petu ñi femngechi nütramkalen, Pedro konpuy ti ruka mew, fey pepuy pütrün che trawüluwkülelu. ");
INSERT INTO arnNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedro feypipufi engün: —Eymün ta kimnieymün kiñe judiu ñi wimtun dungu elunielaeyew ñi nütramkawael kiñe katripanche engu ka ñi konnoael ñi ruka mew no rume. Welu Ngünechen kimeltuenew tañi illamnoafiel iney no rume ka ‘ünunngey’ ñi pinoafiel rume. ");
INSERT INTO arnNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Feymew, kimelngelu müten iñche, pürüm küpan. Chem ngünewlan rume. Küpa kimniefun may chem mew tami yefalmefiel. ");
INSERT INTO arnNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Feymew Korneliu llowdunguy: —Meli antüngetuy, fante pürapachi antü mew, tüfa mew mülen iñche tañi ruka mew. Ayunalelu iñche ka ngillatulelu pu trafia, feymew pewfaluwenew kiñe wentru fülangkülelu ka wilüflu ñi takuwün. ");
INSERT INTO arnNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Fey feypienew: ‘Korneliu, Ngünechen allküñmaeymew tami ngillatun ka tukulpay kom tami femkeelchi kümeke dungu tami kellukefiel mew kom tati duamtulu ñi fürenengeael. ");
INSERT INTO arnNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Werkünge tati Jope waria mew tami yefalmeafiel ta Simon, ka Pedro pingekelu. Umañtuley tati kangelu Simon tañi ruka mew, kiñe lawümtrülkekelu mülelu inaltu lafken.’ ");
INSERT INTO arnNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Feymew pürümkachi werkün tami yefalmeafiel ta eymi, fey eymi küme trokituymi tami küpayael. Tüfa ta müleiñ kom iñchiñ Ngünechen tañi adkiñ mew, ka küpa allkütuleiñ kom tami chem pietew ta Ñidol tami kimeltumuafiel. ");
INSERT INTO arnNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Feymew Pedro llituy ñi wewpiael, fey feypi: “Fewla fente küme kimün Ngünechen tañi dullitunienofiel kiñeke che müten ti pu kakelu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Chuchi tuwünchengeafuy rume, llowkefi kom tati feyentunieetew tati eluwkülelu ñi femael küme dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ngünechen dungufi Israel tañi pu tuwünche, kimelelfi tati küme tüngünngechi dungu Jesucristo mew, kisu ta Ñidolküley itrokom che mew. ");
INSERT INTO arnNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Eymün ta fente küme kimnieymün chem dungu ñi rupan tati pu judiu tañi mapu mew. Llituy ta Galilea mew, fey rupan ngülamtuchelu ta Juan feypi ñi kümefel tañi fawtisangeael engün. ");
INSERT INTO arnNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Eymün kimimün ta Ngünechen ñi elufiel kom pepiluwün ka ti Lif Küme Püllü ta Jesus Nasaret tuwlu, ka femngechi ñi miyawün ta Jesus ñi tremolafiel kom tati kutrankawkülelu weküfü tañi ngüneluwün mew. Kom tüfachi dungu femi, Ngünechen mülelu am kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Iñchiñ ta küme pefiyiñ kom ñi femel ta Jesus Judea trokiñ mapu mew ka Jerusalen waria mew. Fey wüla ta langümngey, pültrüñpüramngey kiñe kürus mew. ");
INSERT INTO arnNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Welu Ngünechen wiñomongeltueyew küla antülu mew, ka elufi ñi pewfaluwtuael iñchiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Welu kom ti trokiñche pewfaluwlafi, iñchiñ müten pefiyiñ, Ngünechen wüne dullikünuetew taiñ nütramyeafiel tüfachi dungu. Iñchiñ ta ituiñ ka putuiñ kisu iñchiñ rupan wiñomongetulu. ");
INSERT INTO arnNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ka kisu werküeiñmew taiñ kimelafiel tati trokiñche Ngünechen tañi elkünufiel ta Jesus kiñe kues reke tati pu mongelelu mew ka tati pu lalu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kom tati pu pelonke wentru dew dungurkefuyngün ñi tukulpafiel ta Jesus, fey feypifuyngün: ‘iney rume tati feyentulu kisu mew wiñoduamangetuay kom ñi yafkan mew.’ ” ");
INSERT INTO arnNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petu dungumekelu ta Pedro, tati Lif Küme Püllü akuy kom tati allkütuleyelu mew tati kimeltun dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tati pu feyentuleyelu konkülelu tati pu judiu ñi wimtun dungu mew tati akuyelu Pedro engün, afmatuleweyngün tañi llowün mew kafey tati Lif Küme Püllü tati pu judiu tuwünngenolu rume. ");
INSERT INTO arnNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Allküñmafingün ñi dungun kake rume dungun mew ñi püramyefiel engün ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Feymew Pedro feypi: “¿Iney am katrütuafeyew tüfa engün tañi fawtisangeael? Llowfi engün tati Lif Küme Püllü iñchiñ reke.” ");
INSERT INTO arnNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Feymew werküy ñi fawtisangeael Jesucristo ñi üy mew. Feymew ka llellipufingün ta Pedro tañi mülewenagael kisu engün mew kiñe mufün antü. ");
INSERT INTO arnNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tati pu apostol ka ti feyentulechi pu che müleyelu Judea mapu mew kimelngeyngün ti pu judiu tuwünngenolu ñi ka femngechi llowün Ngünechen ñi werken dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Welu Pedro, feychi wiñotulu ta Jerusalen, entuüñfileyew kiñeke tati feyentuleyelu mülekefulu tati pu judiu ñi wimtun dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Fey engün ramtueyew: —¿Chem mew anta witrankontufimi tati pu judiu tuwünngenolu ka kiñentrür ipuymi kisu engün mew? ");
INSERT INTO arnNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedro kom nütramkay chumngechi tañi llitun kom tüfachi dungu. Fey feypi: ");
INSERT INTO arnNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Iñche mülelu ta Jope waria mew, petu ngillatulu iñche, perumen kiñe afmanngechi dungu. Pefiñ kiñe fütra katrün pañu reke felelu. Trariley ñi meli wechuñ mew, nagpay wenu mapu, fey akuy chew ñi mülemum ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Fente küme inaduamfiñ chem ñi nien ponwitu. Pen epe fill kulliñ meli namunngelu, wapoke kulliñ, ka ti winolkiyawkelu ka ti pu üñüm. ");
INSERT INTO arnNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ka allkün kiñe dungun ñi feypietew: ‘Witrapürange, Pedro. Langümnge ka inge.’ ");
INSERT INTO arnNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Iñche llowdungun: ‘Femlayan Ñidol, chumkawnorume am ikenolu iñche tati ikenoel ka ti ünunngelu.’ ");
INSERT INTO arnNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Fey tati dungun wenu mapu ka wiñome feypienew: ‘Ngünechen tañi liftuel ñi ingeael ti ikenofel, fey ünunngey pikefilnge.’ ");
INSERT INTO arnNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tüfachi dungu küla rupachi feypienew, feymew müten ka wiñome püratuy wenu mapu. ");
INSERT INTO arnNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Feychi lelen mew müten, küla wentru werküngelu ta Sesarea ñi yepaaetew, akuyngün tati ruka mew chew tañi mülemum ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Fey ti Lif Küme Püllü werküenew ñi amuael müten kisu engün iñchiñ fey ñi ka rakiduamnoael. Ka kompañenew ta tüfachi kayu pu peñi, fey kom konpuiñ ti wentru tañi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nütramkaeiñmew tañi femngechi pen ta kiñe werken püllü tañi ruka mew. Witrañmaparkeeyew ñi feypiaetew: ‘Werkünge ta kiñeke che Jope waria mew tami yefalmeafiel ta Simon, tati Pedro pingekelu. ");
INSERT INTO arnNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kisu ta feypiaeymew chumngechi tami montuael, ka kom tami pu reñma nieel.’ ");
INSERT INTO arnNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Llitulu ta iñche tañi kimeltuafiel engün, tati Lif Küme Püllü akuy kisu engün mew. Chumngechi akuy iñchiñ mew kuyfi, ka femngechi akuy. ");
INSERT INTO arnNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Feymew tukulpan tañi feypikünuel ta Ñidol Jesus: ‘Rüfngey ta Juan ñi fawtisachen ta ko mew, welu eymün fawtisangeaymün reke tati Lif Küme Püllü mew.’ ");
INSERT INTO arnNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Feyngey Ngünechen tañi eluetew engün kay ti Lif Küme Püllü ka chumngechi ta iñchiñ elueiñmew taiñ feyentun mew Ñidol Jesucristo mew, ¿ineyfel anta iñche ‘kümelay tami femün’ ñi piafiel ta Ngünechen?” ");
INSERT INTO arnNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Feymew tati pu feyentulelu mülelu ta Jerusalen, allkülu engün tüfachi dungu, ñüküfnagi engün, fey püramyefingün ta Ngünechen, feypilen mew: —¡Ka femngechi tati pu judiu tuwünngenolu kütu Ngünechen elurkefi ñi wiñorakiduamtuael engün kisu mew ka ñi llowael ti rumel mongen! ");
INSERT INTO arnNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Dew rupan langümngelu ta Esteban, amuley ñi kintungen ñi püresungeael tati pu feyentuleyelu, feymew kiñekentu lefmawi engün ta Fenisia, Chipre ka Antiokia. Fey üyew kimelpufi engün ti pu judiu müten tati werken dungu, welu ti kakelu che kimelpulafi engün. ");
INSERT INTO arnNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Welu kiñeke feyentuleyelu tuwlu Chipre ka Sirene puwingün ta Antiokia waria mew, fey llituy ñi kimeltuafiel tati pu judiu tuwünngenolu kafey. Kimelfingün Jesus tati Ñidol ñi we kimelün dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Fey Ñidol tañi pepiluwün müley kisu engün mew, femngechi pütrün che elyetuyngün tañi kuyfike wesake wimtun dungu, fey feyentuyngün ta Ñidol Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tati feyentulechi trokiñche Jerusalen mew, allkülu engün tüfachi dungu, werküfi engün ta Bernabe ñi amuael ta Antiokia waria mew. ");
INSERT INTO arnNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Puwlu ta Bernabe, ngüneduampuy Ngünechen ñi fürenechelen, fey rumeñma ayüwpuy. Fey ngülampufi kom ti feyentulelu newen piwke mew fente küme ñi inayafiel ta Ñidol Jesus. ");
INSERT INTO arnNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabe rume küme piwke wentrungey ti Lif Küme Püllü am ngünenierkeetew ka nierkey fentren mupiltun. Femngechi pütrün che wiñorakiduamtuy ta Ñidol Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kom rupalu tüfachi dungu, Bernabe amuy ta Tarso waria mew, yemeafilu ta Sawlu. ");
INSERT INTO arnNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Fey pepufilu, küpaltufi ta Antiokia. Feymew mülepuyngu tati trokiñ feyentulelu engün mew. Kiñe tripantu kimeltumekepufi fentren che. Antiokia mew ürke wünelu mew “tati inakefilu Cristo” pingey tañi üytungen tati pu disipulo. ");
INSERT INTO arnNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Feychi mew, kiñeke pelon wentru tuwlu ta Jerusalen, amuy engün ta Antiokia. ");
INSERT INTO arnNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kiñeke tüfa engün, Agabo pingelu, witratripay fey ñi ngünenieetew tati Lif Küme Püllü, fey kimeli ñi müleael kiñe fütra filla antüngen kom trokiñke mapu mew. (Fey fente küme felerpuy, feychi mew Klawdio emperadorkülelu Roma waria mew.) ");
INSERT INTO arnNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Feymew tati feyentuleyelu kiñewi engün ñi kelluafiel chemkün mew Judea mülechi pu feyentulechi che, tunten ñi pepi wülael kake kiñeke engün. ");
INSERT INTO arnNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Femngechi femlu engün, Bernabe ka Sawlu yey tañi trapümelchi chemkün engün, fey yelelngey tati longkolelu ti pu feyentulelu mew mülelu ta Judea mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Feymew tati longko ülmen Erode eluwi ñi fill wesalkamekeafiel kiñeke tati pu feyentuleyechi trokiñche. ");
INSERT INTO arnNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Fey werküy ñi langümngeael kuchillu mew ta Santiaw, Juan tañi peñi. ");
INSERT INTO arnNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Fey Erode kimlu ta tüfachi dungu mew tañi tutefiel tati pu judiu, ka femngechi püresufalfi ta Pedro. Fey tüfachi dungu rupay feychi mülelu ti kawiñ antü tañi ingekemum ta lefawrangenochi kofke. ");
INSERT INTO arnNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Fey Erode rupan püresufalfilu ta Pedro, ka werküy ñi tukungeael ta karsel mew. Tüfey mew llüwatunieeyew meli trokiñ soltaw. Melikeley tati pu soltaw kiñeke trokiñ mew. Rakiduamkülefuy ñi ramtukadunguafiel tati pu judiu ñi adkiñ mew dew rupale tati Paskua pingechi kawiñ antü. ");
INSERT INTO arnNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Feymew Pedro mülerkey karsel mew, fente küme llüwatuniengey, welu tati feyentulechi trokiñche rume ngillatuley Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Feychi pun mew Pedro dew püresulelu, umawkülerkey epu soltaw mew. Trarintukuley epu kadena mew, fey kakelu ti pu soltaw llüwatulerkey ti wülngiñ karsel mew. Fey dew wünle, Erode pengelürkeafetew ti trokiñche mew, ");
INSERT INTO arnNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","welu petu ñi wünnon, pewfaluwrumey Ñidol Jesus tañi werken püllü, fey tati karsel mew kom alofürkey. Tati werken püllü lengkülengkütufi ta Pedro kadi püle, fey trepelfi, ka feypifi: —¡Pürüm witrapürange! Feymew müten, tati kadena kisutu llangkünagi Pedro tañi kuwü mew, ");
INSERT INTO arnNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","fey tati werken püllü feypifi ta Pedro: —Tukunge tami okota. Femngechi femi ta Pedro, fey ti werken püllü ka feypifi: —Tukunge tami makuñ ka inaen. ");
INSERT INTO arnNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Feymew Pedro tripay, inaniefi tati werken püllü, fey ñi kimnon tañi rüfngen kam ñi rüfngenon tañi petu rupaelchi dungu mew. Kisu petu pewmalu trokiwküley. ");
INSERT INTO arnNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Welu rumeyngu wüne llüwatulechi soltaw mew, ka rumey engu tati kangelu llüwatulelu mew, fey puwlu engu tati pañillwe wülngiñ mew, rüpü püle adkülelu, fey tati wülngiñ kisu nülay. Tripapayngu, fey kiñe kuadra alü tripa ti karsel mew, tati werken püllü kisukünutufi ta Pedro. ");
INSERT INTO arnNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Fey wüla küme ngüneduami ta Pedro, fey rakiduami: “Fewla kimün ta Ñidol Jesus ñi werkün tañi werken püllü tañi montuletew ta Erode mew ka kom tañi chumafetew mew tati pu judiu.” ");
INSERT INTO arnNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kom ngüneduamfilu tüfachi dungu, Pedro amuy Maria tañi ruka mew (Juan, tati Marku pingelu, tañi ñuke) chew trawüluwküley pütrün che tañi ngillatuael. ");
INSERT INTO arnNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mütrümtukupuy ti rüpü adkülechi wülngiñ mew, fey kiñe üllchadomo, Rode pingelu, tripay ñi adkintuael tañi ineyngen. ");
INSERT INTO arnNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Fey Rode kimüñmafilu ñi dungun ta Pedro, fey fente ñi ayüwün nülalafi rume ta wülngiñ, fey lefkülen konputuy pu ruka tañi kimelael Pedro tañi mülepatun ta wülngiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Fey feypingey: —¡Wedwedküleymi am! Welu Rode feypi tañi rüf feyngen. Fey kisu engün feypi. —¡Pedro no tati! ¿Kisu ñi werken püllü peno? ");
INSERT INTO arnNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Fey Pedro kay amuley ñi mütrümtukumeken wülngiñ mew. Fey nülafilu engün ti wülngiñ, fey pefilu engün, rume afmatuleweyngün. ");
INSERT INTO arnNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Welu Pedro kafkütudungufi ka nengümelfi ñi kuwü tañi dungunoael engün, fey nütramelfi chumngechi ñi entutuetew ta Ñidol karsel mew. Fey ka feypi: —Feypiafimün ta Santiaw tüfachi dungu ka kom ti pu che feyentulelu. Fey tripatuy ka amutuy kañpüle. ");
INSERT INTO arnNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Fey dew wünlu, tati pu soltaw wedwedingün ñi kintuafiel fill püle, kimnolu engün am ñi chumngechi ñi tripatun ta Pedro ti karsel mew. ");
INSERT INTO arnNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Feymew Erode werküy tañi kintungeael ta Pedro, welu pengenolu am, werküy ñi langümngeael ti pu soltaw llüwatuniekefulu ta Pedro. Fey femlu, Erode tripay Judea mapu mew, fey amuy ñi müleputuael ta Sesarea mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erode rumeñma lladkütuniefi kom tati pu che müleyelu ta Tiro ka Sidon waria mew, welu tüfachi che kom kiñewi tañi dungumeafiel ta Erode mew. Ti pu Tiro ka Sidon waria che wenikawi engün tati longko ülmen Erode ñi kiñe küdawelkeetewchi wentru, Blasto pingelu. Fey Blasto mew feypifali engün tati longko ülmen Erode tañi kümelkawtuael, tati pu che Tiro ka Sidon waria mew am ngillakefulu fill iyael ka chemkün engün Erode tañi trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Feymew kiñe antü Erode mütrümfalfi ti pu che tuwlu Tiro ka Sidon waria mew, fey Erode tukutuwküley tañi ülmen takuwün mew, anüpuy ñi tribunal mew, fey wewpipuy. ");
INSERT INTO arnNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Feymew tati pu che llituy engün tañi wirarael: “¡Tüfa tati wewpipelu re che no, kiñe ngünechen tatey!” ");
INSERT INTO arnNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Feymew ka müten, Ñidol tañi werken püllü kutranelfi ta Erode, tañi püramyenofiel mew ta Ngünechen, fey lalu, pirufemi. ");
INSERT INTO arnNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Fey Ngünechen tañi dungu kom püle amuley ñi kimeltungen. ");
INSERT INTO arnNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Fey Bernabe engu Sawlu dewmalu tañi küdaw, tripatuyngu ta Jerusalen, feymew amuyngu ta Antiokia, fey yeniefi engu ta Juan, kiñeke mew Marku pingekey ñi üytungen. ");
INSERT INTO arnNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Tati trokiñche feyentulelu mülelu Antiokia mew mülenkepirkey pelon wentru ka kimeltufe. Bernabe engu, Simon (tati kurü che pingekelu), Lusio mülelu ta Sirene, Manaen (Erode engu ta kiñentrür tremlu, tati longkolekelu Galilea mapu mew) ka Sawlu. ");
INSERT INTO arnNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kiñe antü, petu trawüluwkülelu engün tañi püramyeafiel ta Ñidol ka ayunaley engün, tati Lif Küme Püllü, feypi: “Wichunentulmuchi ta Bernabe ka Sawlu tañi küdawael engu ñi dullifiel mew.” ");
INSERT INTO arnNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Feymew rupan ngillatulu engün ka rupan ayunalu, fampuwülelngey engu kuwü, fey chalikünungey engu ñi tripayael kañpüle fey ñi kimeltuchemeael. ");
INSERT INTO arnNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bernabe engu Sawlu werküeyew tati Lif Küme Püllü, fey amuyngu tati ina lafken mülechi waria Selewsia. Tüfey mew pürapuy engu kiñe farku mew, amualu engu ta Chipre pingechi wapi mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Epe puwkülelu ta Salamina waria ñi ayliñ mew, llituy tañi kimelün engu Ngünechen tañi werken dungu, tati sinagoga mew ñi nieel tati pu judiu. Külangen amuley Juan engün tati Marku pikeel, fey Juan ta kelluyawürkey. ");
INSERT INTO arnNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kom püle miyawi engün tati fütra wapi mew, fey puwi engün ta Pafos waria mew. Feymew pepufi engün kiñe kalku judiu tuwünngelu Barjesus pingelu, ka rume koylangerkey, “Ngünechen ta ‘famngechi dunguaymi’ pienew” pikerkey. ");
INSERT INTO arnNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Fey tüfachi kalku mülekerkey tati gobernador engu Sergio Pawlu pingelu, rume kim wentrungerkey. Fey tüfachi gobernador mütrümfalürkefi ta Bernabe engu Sawlu. Küpa allküturkey Ngünechen tañi werken dungu, ");
INSERT INTO arnNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","welu tati kalku, griegudungun mew Elima pikeel, katrütudungufi tati gobernador tañi feyentunoael. ");
INSERT INTO arnNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Feymew Sawlu, ka Pablo pingelu, ngünenieetew tati Lif Küme Püllü leliniewefi, ");
INSERT INTO arnNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","fey feypifi: —¡Koylatufe, wesañmangelu ka weküfü ka müten ta eymi, kayñetukefilu kom kümeke dungu! ¿Chem mew anta fentekünulaymi tami kakünuñmayafiel Ñidol Ngünechen tañi nor küme dungu? ");
INSERT INTO arnNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tüfa ta Ñidol Ngünechen kutrankayaeymew: pelowelayaymi, fentreñma pewetulayafimi ta antü ñi pelon. Feymew ka müten Elima trawmay, fey dumiñmafemi, fey ayükerkey iney rume ñi küñatuaetew kuwü mew, trawmaletulu am. ");
INSERT INTO arnNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Fey ti gobernador pefilu ñi trawman ta Elima, feyentuy ka afmatuley ñi kimeltungen ta Ñidol Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Fey Pablo ka ñi pu kompañ Pafos ñi ayliñ mew püray engün kiñe farku mew, fey amuyngün ta Perge waria mew, Panfilia ñi trokiñ mapu mew. Welu Juan kisuelkünutufi ta Pablo engu Bernabe, fey wiñotuy ta Jerusalen. ");
INSERT INTO arnNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tripalu Perge, fey puwi engu ta Antiokia, pichi alü tripalelu ta Pisidia trokiñ mapu mew. Feychi ürkütun antü mew, konpuy engu ta sinagoga mew, fey anüpuy engu. ");
INSERT INTO arnNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Rupan chillkatufilu engün ti lifru nielu tati ley dungu ka tati pu pelon wentru ñi wirielchi dungu, ti pu longkolelu tati sinagoga mew feypifalfi ta Pablo engu Bernabe: —Epu peñi, nielmu dungu tamu feypiael tamu yafülafiel ta pu che, tüfa ta feypiaymu müten. ");
INSERT INTO arnNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Feymew Pablo witrapüray, ka nengümelfi ñi kuwü ñi feypiafiel tañi ñüküfküleael tati pu che, fey feypi: —Allkütumün eymün, pu israelche, ka eymün, pu kake tripanche yamniefilu ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel trokiñche tañi Ngünechen dullinturkefi taiñ fütakeche em. Kisu engün mew tripay kiñe fütra trokiñche feychi ta petu kake tripanche reke felelu engün ta Egipto mew. Fey wüla, Ngünechen tañi pepiluwün mew, nentupatuy kisu ñi trokiñche tüyechi mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Meli mari tripantu tati uwe mapu mew Ngünechen ñi ngenoafeluwün mew duamkünuñmalafi ñi yafkan engün. ");
INSERT INTO arnNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ngünechen apümfi regle fütrake trokiñche mülelu tati trokiñ mapu Kanaan mew, tañi eluafiel feychi mapu taiñ fütakeche em. ");
INSERT INTO arnNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kom tüfachi dungu feley ta kiñe meli pataka kechu mari tripantu. “Fey wüla elelfi kiñeke longko kueskülealu ñi kimeltunieaetew engün, fey fentepuy ñi mülen engün Samuel mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Feymew kisu engün feypi ñi elelngeael kiñe longko ülmen tañi ngünenieaetew engün, fey Ngünechen, elfi meli mari tripantu ta Saul ñi longko ülmenküleael, Sis tañi fotüm, Benjamin tañi tribu mew tripalu. ");
INSERT INTO arnNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Fey wüla nentutueyew Ngünechen ñi longko ülmenngewenoael ta Saul, feymew longko ülmenkünungetuy ta David, fey feypi ta kisu mew: ‘Penien ta David mew Isay tañi fotüm, fey tüfachi wentru ta ayüduamafiñ tañi femael kom iñche tañi ayünieelchi dungu.’ ");
INSERT INTO arnNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Fey tüfa lle ta tripalu kiñe ta David ñi tuwünche mew, fey tüfa ta Jesus Ngünechen tañi werküel ñi montulafiel ta pu israelche, femngechi tañi wüne tukulpakünuel. ");
INSERT INTO arnNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Fey petu tañi küpanon ta Jesus, Juan kimelelfi ti werken dungu tati Israel trokiñche. Feypifi tañi wiñorakiduamtuael ta Ngünechen mew ka tañi fawtisangeael engün. ");
INSERT INTO arnNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Fey fülpalu dewma tañi fentepuael Juan tañi mongen, Juan feypi: ‘Iñche no tati eymün tamün rakiduamküleel mew, welu iñche mew inalepay kiñe doy fütra pepiluwünngelu, fey iñche tañi yamniefiel mew nentupüroñmalayafuiñ rume tañi koriwen okota.’ ");
INSERT INTO arnNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Eymün pu peñi ka lamngen, Abraam tañi pu yomelche, ka eymün pu kake tripanche feyentulelu ta Ngünechen mew: fey tüfachi werken montuluwün dungu fey ta kom iñchiñngealu. ");
INSERT INTO arnNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Rüf dungu mew chumngechi ñi wiriel Chillka mew ti pu pelon wentru tati chillkatukeel ti ürkütun antü mew itrokom felefuy. Ngüneduamfimün tati pu che mülelu ta Jerusalen ka ti pu awtoridad kimlafingün ñi ineyngen ta Jesus, ka pilay ñi llowafiel, fey langümfingün ta kürus mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Tunte kisu nielafuy kiñe yafkan no rume tañi langümngeafel, feypifingün ta Pilato tañi langümafiel kürus mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Fey rupan femlu engün kom tañi feypilen ta Wirin Chillka Jesus mew, fey nagümngetuy ta kürus mew, fey rüngalngey. ");
INSERT INTO arnNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Welu ta Ngünechen wiñomongeltueyew rangi pu la mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Fey kiñe mufü rupalechi antü mew pewfaluwtuy ta Jesus ñi pu disipulu mew tüfa engün tati tripalu ta Galilea trokiñ mapu mew ñi küpayael ta Jerusalen. Fey tüfachi pu disipulu ta peeyew ñi mongeletun, fey nütramyenietufi engün ta Jesus ta kom pu che mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Femngechi tati iñchiñ petu nütrameluwiyiñ ta tüfachi küme dungu: Ngünechen tañi wüne feypikünufiel taiñ fütakeche em, ");
INSERT INTO arnNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","wiñomongeltufilu ta Jesus kom mupiy ti dungu, iñchiñ am kisu engün taiñ tuwünche. Fey iñchiñ llowfiyiñ tüfachi montun Jesus mew iñchiñ am ti kuyfi fütakeche em ñi yomelche chumngechi ñi feypilen tati epu konchi salmo mew: ‘Eymi ta iñche tañi fotüm. Iñche ta yalleyu fachantü.’ ");
INSERT INTO arnNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ngünechen dew feypikünufuy tañi wiñomongeltuafiel rangi ti pu la ka tañi funanoael Jesus tañi kuerpu, feypilerkey ta Wirin Chillka mew: ‘Kom mupituan tati nor dungu ka ñi tukulpakünulelfielchi dungu ta David.’ ");
INSERT INTO arnNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Feymew ka feypiley tati Salmo lifru mew: ‘Elulayafi tañi funayael tañi kuerpu ñi poyekeetewchi lif mongen kona.’ ");
INSERT INTO arnNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Fewla may, feyngey, ta David tañi poyefiel tañi kuyfike che em, Ngünechen ta femaymi ñi pietew mew, ‘welu ta kisu larpuy chew ñi rüngalkülemum tañi chaw rüngalngey ta kisu’, fey tañi kuerpu funay. ");
INSERT INTO arnNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Welu tüyechi Jesus Ngünechen tañi wiñomongeltuel, fey ñi kuerpu funalay. ");
INSERT INTO arnNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Fey fewla feypiwayiñ, pu peñi ka lamngen, eymün müley tamün kimael Jesus mew ñi mülen wiñoduamangetun ta kom yafkan mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Fey Moyse ñi ley dungu mew am iney rume wiñoduamangekenolu ñi yafkan mew, welu tati feyentulu Jesus mew niewetulay ta yafkan. ");
INSERT INTO arnNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kuñiwtukuymün may tamün apümkangeael ta eymün ñi feypilen mew kom tüfachi dungu tañi chillkantukukünuel tati pu pelon wentru: ");
INSERT INTO arnNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Allkütumün pu illamchefe, ka afmatulewemün, ka afnagtumün. Iñche ta feman kiñe dungu eymün tamün mongen mew, tüfeychi dungu eymün ta feyentulayafimün, iney rume ta nütramelelmünmew.’ ” ");
INSERT INTO arnNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Fey Pablo ka Bernabe petu tripapatulu engu tati pu judiu ñi sinagoga mew, tati pu judiu tuwünngenolu llellipuyngün ti kangelu ürkütun antü mew ñi nütramelngeael engün ka feychi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Dew rupan trawüluwlu engün tati sinagoga mew, pütrün pu judiu, fey ti kakelu ka femngechi konkülelu ti pu judiu ñi wimtun dungu mew, inaeyew. Fey kisu engu ngülamfi ti pu che tañi rumel newentuleael, femngechi tañi mütrümetew engün Ngünechen tañi piwkeyeetew mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Fey ka akulu ti kangelu ürkütun antü, epe kom tati waria che trawüluwi tañi allkütuael engün Ñidol Ngünechen tañi werken dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Feymew tati pu judiu pelu rume fentren che, rumeñma ütriri engün. Eluwi ñi fillpiafiel ta Pablo ka lukatukafi engün. ");
INSERT INTO arnNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Feymew Pablo ka Bernabe, llowdunguy engu rume newen piwke mew: —Iñchiw ta feley tayu dunguael wünelu mew Ngünechen ñi dungu eymün mew, fey eymün tamün judiungen. Dew llowlafimün ka duamlafimün tati rumel mongen, fey fewla feypiwayiñ taiñ kimelmeafiel tati pu judiu tuwünngenochi pu che. ");
INSERT INTO arnNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Femngechi werküeyumew ta Ñidol Ngünechen feypilen mew: ‘Kiñe küde reke ta niewiyiñ kom tati pu lof mapu mew, tamün yeafiel iñche tañi wülelchi montuluwün dungu, tuntepu ñi mülen ta mapu.’ ");
INSERT INTO arnNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Allkülu engün tüfachi dungu, tati pu judiu tuwünngenolu ayüwi, fey feypi engün ñi rume ayüfalün Ñidol Ngünechen tañi dungu. Feyentuyey engün kom tüfey ñi dulliel ta Ngünechen, fey tañi llowael ta rumel mongen. ");
INSERT INTO arnNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Feymew wewpingey Ñidol Jesus tañi dungu kom tiyechi lof mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Welu tati pu judiu dungufi kiñeke kümeke piwkengechi pu domo ka yamfalke domo, ka tati longkoleyechi pu wentru waria mew, fey ngüchalfi engün tañi kiñewael ñi wemüafiel ta Pablo engu Bernabe, femngechi tañi wemünentuafiel ti trokiñ mapu mew, kañpüle ñi amutuael engu. ");
INSERT INTO arnNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Feymew kisu engu mütrowi ti trufür ñi nieel tañi okota mew, fey femngechi pengeli engu ñi wesaduamtufiel kom tiyechi pu che, fey amuyngu ta Ikonio waria mew. ");
INSERT INTO arnNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Welu tati pu che feyentuyelu, rume ayüwküley engün ka ngünenieeyew ti Lif Küme Püllü. ");
INSERT INTO arnNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikonio mew Pablo engu Bernabe kiñentrür konpuy tati pu judiu tañi sinagoga mew chumngechi wimtuley engu, fey kimeltupuyngu, feymew rume fentren che feyentuy, fentren judiu ka judiu tuwünngenolu. ");
INSERT INTO arnNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Welu tati feyentuyenochi pu judiu ngüchalniefi ñi dungukonael ti pu judiu tuwünngenolu femngechi tañi wesaduamtungeael tati pu feyentulechi pu che. ");
INSERT INTO arnNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Fey tüfachi dungu mew, tati pu apostol mülewenagi engün rume fentreñma Ñidol mew maneluwküley engün, fey küme kimeltuchey engün. Nütramyekefi engün Ngünechen tañi rume piwkeyechenngen, fey Ñidol Ngünechen ta rume kellunieeyew engün tañi femael afmanngechi dungu. Kisu engün tañi femkeelchi afmatufal dungu mupilerpuy kisu tañi nütramyekeelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Welu tati pu trokiñche wichu püntülkawi engün, kiñekentu ingkaniefi tati pu judiu, kakelu kay ingkaniefi tati pu apostol. ");
INSERT INTO arnNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Feymew, tati pu judiu ka ti pu judiu tuwünngenolu kiñewi engün tati pu soltaw engün tañi wimakayafiel ka tañi ütrüftukayafiel kura mew. ");
INSERT INTO arnNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Welu Pablo engu Bernabe kimlu tüfachi dungu, lefmawi engu, fey amuy Likaonia trokiñ mapu mew, Listra waria mew ka Derbe waria ka fülküleyechi lof mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ka tüfey mew ka kimelpuy engu tati küme dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra waria mew mülerkey kiñe wentru pepi trekakenolu. Chumkawnorume trekakerkelay, küntrongey choyüngelu müten. Fey tüfachi wentru anülerkey, ");
INSERT INTO arnNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","allkütuley tañi nütramkameken ta Pablo, fey Pablo ngüneduameyew ka kimeyew tañi rume feyentulen tañi tremoltuael. ");
INSERT INTO arnNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Feymew Pablo feypifi ti wentru newentu dungun mew: —¡Witrapürange ka küme witrakünuwnge tami namun mew! Fey tati wentru witrapüray kiñe ringkün mew, fey eluwi ñi trekayael. ");
INSERT INTO arnNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pengelu ñi femün ta Pablo, wiraryey engün tati pu che likaoniadungun mew (fey Pablo kimlay ñi chem pimeken engün): —¡Pu ngünechen wentrukünuwpay iñchiñ mew! ");
INSERT INTO arnNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabe ta Seus ngünechen pifi engün, Pablo kay Ermes ngünechen pifi engün kisu am dungukerkelu. ");
INSERT INTO arnNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Seus tañi saserdote niey tañi ngillatuwe ruka ellakon waria, fey küpalürkey toro adelkalelu itrofill rayen mew. Ti saserdote ka ti pu che ayüfuy tañi langümelafiel ti pu toro, femngechi tañi püramyeafiel tati epu apostol. ");
INSERT INTO arnNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Welu Pablo engu Bernabe ngüneduamlu, wikürkay ñi takuwün engu ka konpuy wirarkülen rangi che: ");
INSERT INTO arnNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Pu weni, ¿chem mew anta femngechi femimün? Iñchiw ta ka femngechi wentru, eymün reke. Iñchiw ta küpaleluwiyiñ rume küme dungu femngechi tamün elkünutuafiel ti wesake dungu, chem mew no rume ta kümenolu, ka tamün wiñotuael ta mongelechi Ngünechen mew, tati dewmalu ta wenu mapu, ka nag mapu, ka lafken ka kom tati mülelu tüfa engün mew. ");
INSERT INTO arnNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tunte kuyfi mew ta Ngünechen elukünufuy ta che kisuke tañi inayael tañi rüpü, ");
INSERT INTO arnNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","welu chumkawnorume elkünulay ñi pengelael ti kümeke dungu ñi femken, kisu tati werkülkeeymünmew ta mawün ka küme ngelkaketranün ka elukeeymünmew tamün duamtuelchi iyael, femngechi tamün ayüwküleam. ");
INSERT INTO arnNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Fey feypingelu engün kom tüfachi dungu, ngellu katrütungey ñi langümnoafiel tati pu toro femngechi ta püramyelafingün ti langümelchi kulliñ mew tati epu apostol. ");
INSERT INTO arnNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Feymew akuyey kiñeke judiu tuwlu Antiokia ka Ikonio, fey ka wesa rakiduamelpatufi tati pu che. Feymew ütrüftukangey kura mew ta Pablo, fey langümfilu trokiwi engün ka wingüdentukünufi engün wekuntu waria. ");
INSERT INTO arnNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Welu tati pu feyentuleyelu trawüluwlu Pablo tañi inafül, kisu witrapüratuy, fey ka konputuy tati waria mew. Fey kangelu antü mew, amuy Derbe waria Bernabe engu. ");
INSERT INTO arnNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Rupan kimelpulu engu tati küme dungu ta Derbe waria mew, pütrün che feyentuy, fey wiñotuy engu ta Listra, Ikonio ka Antiokia waria mew Pisidia trokiñ mapu mülelu. ");
INSERT INTO arnNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Fey tüfachi lelfün püle ngülamkiyawülfi tañi newentuleael engün tañi feyentun mew. Feypingey engün ñi felerken ñi müleael kutrankawün taiñ puwael ta Ngünechen ñi mülewe mew. ");
INSERT INTO arnNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kake kiñeke tati trokiñ pu feyentulelu mew dullingey wünenke wentru longkolealu, fey rupan ayunalu ka ngillatulu engün, chalintukufi engün Ñidol Jesus mew, tañi feyentumum engün. ");
INSERT INTO arnNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Fey rupalu engu Pisidia trokiñ mapu mew, puwi engu Panfilia trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nütramkapuy engu tati küme dungu Perge waria mew, feymew ka amuy engu ta Atalia ñi ayliñ mew. ");
INSERT INTO arnNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Feymew konpuy engu farku mew ñi amutuael ta Antiokia, Siria trokiñ mapu mülelu. Tüfeychi waria mew mülechi pu peñi ka lamngen chalintukurkeeyew Ngünechen ñi piwkeyechen mew feychi tripayalu ñi wewpimeael ti werken dungu. Fey fewla puwturkey engün ka feychi trokiñ feyentulechi pu che mew. ");
INSERT INTO arnNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Fey wiñotulu engu ta Antiokia, ka llowtueyew ti trokiñ feyentulechi che. Feymew Pablo engu Bernabe trapümfi ti feyentulechi che tañi nütramelafiel ti dungu tañi femel ta Ngünechen kisu engu mew, ka chumngechi ta Ñidol ñi fürenefiel tati pu judiu tuwünngenolu tañi ka femngechi feyentuael engün. ");
INSERT INTO arnNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Feymew Pablo ka Bernabe rume fentreñma mülewenagi engu Antiokia waria mew tati pu feyentulelu engün. ");
INSERT INTO arnNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Feychi mew, kiñeke tati tuwyelu Judea amuy ta Antiokia, fey eluwpuy engün tañi kimeltuafiel tati feyentulechi pu che tañi pepi montunoael engün, eluwnole tañi sirkunsidangeael, Moyse tañi elkünurpuelchi wirin dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Feymew Pablo engu Bernabe fütra lelikadungufi tati pu judiu ñi femngechi kimeltun mew. Feymew wüla dullifi engün Pablo ka Bernabe ka kiñeke ti kakelu ñi amuael Jerusalen fey ñi nütramelpuafiel tüfachi dungu tati pu apostol ka tati pu fütakeche longkolelu tati feyentulechi trokiñche mew mülelu ta Jerusalen waria mew. ");
INSERT INTO arnNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tati werküelchi pu che Antiokia mülechi feyentulechi trokiñche mew, tüfachi pu peñi rumerpulu engün Fenisia ka Samaria tañi trokiñ mapu mew, nütramyeniey engün femngechi ñi elkünutun tañi kuyfike feyentun tati pu judiu tuwünngenolu femngechi tañi inayafiel Ngünechen tañi dungu. Fey kom ti pu peñi ka lamngen rume ayüwi engün feychi dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Feymew Pablo engu Bernabe puwlu ta Jerusalen, lloweyew tati feyentulechi trokiñche, ka tati pu apostol ka ti putrem fütakeche, fey nütramelpufi kom chumngechi ñi femün ta Ngünechen tati pu judiu tuwünngenolu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Welu kiñeke feyentuleyechi pu farisew witrapüray ka feypi engün: —Feley tañi sirkunsidangeael tati feyentulechi pu judiu tuwünngenolu, ka ñi werküngeael ñi mupituafiel Moyse tañi ley dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Feymew trawüluwi tati pu apostol ka tati fütakeche ñi ngüneduamafiel ta tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Rupan fentreñma nütramkawlu engün, Pedro witrapüray fey feypieyew: —Pu peñi, eymün ta kimnieymün kuyfi mew ta dullintuenew ta Ngünechen eymün tamün rangiñ mew ñi kimelael tati ayüwünngechi montun dungu tati pu judiu tuwünngenolu mew, ñi feyentuael kay ta kisu engün. ");
INSERT INTO arnNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ngünechen am, kom kimniefilu ta rakiduam, pengeli tañi duamyefiel. Elufi tañi Lif Küme Püllü ta kisu engün, chumngechi elueiñmew ta iñchiñ. ");
INSERT INTO arnNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ngünechen ta doyümnielafi iney no rume, iñchiñ no rume, ka kisu engün no rume, welu may ka femngechi tati pu judiu tuwünngenolu liftuñmangey tañi piwke tañi feyentun mew engün. ");
INSERT INTO arnNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Fey tüfa fentekünumün tamün notukamekeafiel ta Ngünechen. Kimeltumekefimün tati pu feyentuleyelu tati pepilfalnochi dungu iñchiñ no rume ka taiñ kuyfike che em no rume tañi pepi femnoel. ");
INSERT INTO arnNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Welu iñchiñ tati pu judiu, feyentuleiñ taiñ montun re taiñ füreneetew mew müten ta Ñidol Jesus, fey tati pu judiu tuwünngenolu ka femngechi montuy engün re tañi feyentun mew müten. ");
INSERT INTO arnNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kom ti trawüluwkülechi pu che ñüküfkülen allkütuy engün Bernabe engu Pablo ñi nütram, chumngechi ñi pengelün ta Ngünechen ti afmanngechi pepiluwün kisu engu mew, miyawlu engu tati pu judiu tuwünngenolu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Dew nütramkalu engu, Santiaw feypi: —Pu peñi, allkütumuchi: ");
INSERT INTO arnNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon ta nütramkaleiñmew chumngechi ta Ngünechen llituy ñi füreneafiel tati pu judiu tuwünngenolu, ka femngechi ñi dulliael tati pu judiu tuwünngenolu kiñe trokiñche kisungealu. ");
INSERT INTO arnNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tüfa ta ka femngechi feley chumngechi tañi wirintukukünuel tati pu pelon wentru, chumngechi feypiley ta Wirin Chillka mew: ");
INSERT INTO arnNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Dew rupale tüfa, wiñome ka dewmatuafiñ David tañi trananagkülechi ruka. Dewmatutuafiñ tati teyfükawkülelu ka we witrañpüramtuafiñ, ");
INSERT INTO arnNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","femngechi tati kakelu inaye tañi kintuafiel engün ta Ñidol kom kiñentrür kakelu fütrake trokiñche engün kom tati wiñoduamangetulu ñi yafkan mew iñche ñi üy mew.’ ");
INSERT INTO arnNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ñidol tati kimelkünulu kom tüfachi dungu fütra kuyfi mew, feypikünuy tañi dungun. ");
INSERT INTO arnNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Feymew iñche kay ngüneduamün, ñi kümenon aporia meñkukünulngeael reke tati pepilfalnochi dungu tati pu judiu tuwünngenolu ti elkünutulu tañi kuyfike feyentun femngechi ñi inayafiel ta Ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Yochikay müten tañi wirilelngeael kiñe karta tati pu judiu tuwünngenolu tañi inoael engün tati ilo kulliñ tati langümelngeel tati pu dewman pichike ngünechenngealu, ka fill domo ñi üñamyenoael engün ka tañi inoael engün kisu lachi kulliñ, ürfilu no rume tañi inoael engün, mollfüñ no rume tañi ingenoael. ");
INSERT INTO arnNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Fütra kuyfi mew am mülekelu kom waria mew tati kimeltukelu Moyse tañi ley dungu, tati chillkatungekeel ta sinagoga mew fill ürkütun antü mew.” ");
INSERT INTO arnNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tati pu apostol ka ti pu longkolelu, kom tati feyentuleyechi trokiñche engün, eluwi tañi kiñeke dullintuael engün tañi werküafiel ta Antiokia kiñentrür Pablo ka Bernabe engün. Dullingey ta Juda tati Barsaba pingekelu, ka Silas, tati yamfal wentrungelu ti pu feyentulechi che mew, ");
INSERT INTO arnNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","fey kisu engün mew yefaltukuy tüfachi karta: Iñchiñ taiñ pu apostolngen ka ti pu longko, lemoria piaiñ taiñ pu peñi ka lamngen, tati pu judiu tuwünngenolu müleyelu ta Antiokia, Siria ka Silisia waria mew: ");
INSERT INTO arnNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Iñchiñ kimiyiñ ñi amun kiñeke che Jerusalen mew mülelu. Iñchiñ werkülafiyiñ tüfachi pu che. Kisu ngünewün amuyngün, fey kimeltupuy engün kalechi kimeltun, fey engün welulkaleymünmew. ");
INSERT INTO arnNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Feymew, nütramkawlu iñchiñ, kom trüruwiyiñ taiñ dulliael kiñeke pu peñi, tamün pemeaetew ta eymün, fey tüfachi pu peñi ñi amuael kiñentrür taiñ sakin epu peñi Bernabe ka Pablo engün. ");
INSERT INTO arnNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Kisu engu ta kuñiwünngechi dungu mew rupay engün Ñidol Jesucristo tañi duam. ");
INSERT INTO arnNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Feymew tati werküleluwiyiñ ta Juda ka Silas. Femngechi kisu engu fente küme nütramkapuaeymünmew ka kimeltupuaeymünmew kom tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Femngechi ñi ayüel tati Lif Küme Küme Püllü, ka femngechi iñchiñ ayülaiñ tamün werküwafiel fentren dungu taiñ femkeel ti pu judiu, welu feypiwayiñ tüfachi pichin dungu müten tamün femael: ");
INSERT INTO arnNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Feley tamün inoael ti ilo kulliñ ti langümelngeel tati pu dewman pichike ngünechenngealu, ka tamün inoael mollfüñ, kisu lachi kulliñ no rume ñi ingenoael ka tamün ñiwaldomonoael. Kuñiwtuwkülelmün kom tüfachi dungu mew, rume küme dungu femaymün. Küme amulepe tamün dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Feymew kisu engün rupan chaliwlu, amuyngün ta Antiokia. Fey trapümpufilu tati feyentulechi pu che, wülpuy tañi yeelchi wirin karta engün. ");
INSERT INTO arnNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Feymew tati feyentulechi pu che chillkatufilu tati wirin karta, rume ayüwi engün ñi rume yafültukuetew mew tati wirin dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juda engu Silas am ka nielu feychi adümuwün ñi kimeltuael ti werken dungu ñi llowel Ngünechen mew, yafültukuniefi ka rume trepewelfi engu ñi nütram mew tati feyentulechi pu che. ");
INSERT INTO arnNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Fey kiñe mufü antü rupalu wüla, ti feyentulechi pu che chalitueyew engün ñi küpatuael engu küme tüngün mew, tañi wiñotuael ñi werküetewchi pu che mew. ");
INSERT INTO arnNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Welu Silas ayüfuy tañi müleweael ta tüye mew. ");
INSERT INTO arnNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Fey Pablo engu Bernabe mülewey ta Antiokia, ka fentren kakelu che engün, fey amuley ñi kimeltuchen ka ñi wewpilelafiel Ñidol tañi werken dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kiñe mufü antü rupalu, Pablo feypifi ta Bernabe: —Ka wiñome witranngemeayu tati feyentulechi pu che mew itrokom ti waria mew chew ta dew kimeltuyu Ñidol Jesus tañi werken dungu, femngechi tayu kimafiel tañi chumlen engün. ");
INSERT INTO arnNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabe ayüfuy ñi yeafiel ta Juan, ka Marku pingekelu, ");
INSERT INTO arnNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","welu Pablo adentulay tañi yeafiel, Marku am kisukünuetew kiñechi miyawlu Panfilia waria mew, ka pirkelay ñi inayaetew kisu engu ñi küdaw mew. ");
INSERT INTO arnNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Femngechi ta rume fütra welulkawi engu, fey wüda triparpuyngu. Bernabe yefi ta Marku, fey kiñe farku mew amuyngu ta Chipre wapi mew. ");
INSERT INTO arnNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Feymew, Pablo kay, dullifi ta Silas, fey chalintukueyew tati feyentulechi pu che ta Ñidol Jesus tañi poyeafiel, fey tripayngu tiye mew. ");
INSERT INTO arnNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Rumerpuy engu ta Siria ka Silisia, fey yafülkiyawülfi tati pu che feyentulelu. ");
INSERT INTO arnNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo puwi ta Derbe ka Listra, feymew pepuy kiñe weche wentru feyentulelu Timotew pingelu. Kiñe feyentulechi domo judiu tuwünngelu tañi püñeñ, fey ñi chaw griegu ürke. ");
INSERT INTO arnNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tati pu feyentulechi che mülelu Listra ka Ikonio rume küme tukulpaeyew ta kisu. ");
INSERT INTO arnNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo ayürkey ta Timotew ñi kompañaetew, welu wünelu mew elufi tañi sirkunsidangeael tañi wesa duamnoael tati pu judiu mülelu feytichi waria mew, kom kimnielu engün am Timotew tañi chaw tañi griegungen. ");
INSERT INTO arnNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kom tati waria mew tañi rupael engu, kimelelfi tati pu feyentulechi che tañi ngülamtuel tati pu apostol ka ti pu longkolelu ti trokiñche mülelu ta Jerusalen. ");
INSERT INTO arnNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Femngechi tati trokiñche feyentulelu doy küme inay engün ñi mupiltun mew ka femngechi kake antüngey doy alünngey engün. ");
INSERT INTO arnNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tati Lif Küme Püllü am elunoetew tañi wewpiael tati küme dungu ta Asia ñi trokiñ mapu mew, rumey engün Frigia tañi trokiñ mapu mew ka Galasia trokiñ mapu mew, ");
INSERT INTO arnNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","fey puwi engün tuntepan ta Misia trokiñ mapu. Fey rakiduami engün tañi konpuael Bitinia tañi trokiñ mapu mew, welu Jesus tañi Küme Püllü elulaeyew tañi konpuael. ");
INSERT INTO arnNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Feymew katrürumeyngün ta Misia, fey nagpuy engün Troa tañi ayliñ mew. ");
INSERT INTO arnNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Feymew Pablo pun mew pewfaluweyew kiñe che. Pefi kiñe wentru Masedonia trokiñ mapu mew tuwlu, witrakünuwi ñi llellipuaetew: “Konpunge ta Masedonia ka kellumuaiñ.” ");
INSERT INTO arnNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo, pefilu müten ñi pewfaluwetewchi wentru, pepikawi tañi konpuael ta Masedonia. “Fente küme kimiyiñ Ngünechen taiñ werküetew taiñ wewpiael Jesus ñi werken dungu tiye mew” pirkey ta Pablo. ");
INSERT INTO arnNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tuwlu iñchiñ ta Troa, püraiñ kiñe farku mew. Üngkükünu amuiñ Samotrasia pingechi wapi mew, fey kangelu antü mew puwiyiñ ta Neapolis waria mew. ");
INSERT INTO arnNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tüfey mew tripaiñ, fey trekalen amuiñ ta Filipo, fey tüfa Masedonia tañi doy küme fütra waria. Tüfey püle tati pu romache ka konpalerkey feychi mapu mew. Üyew müleweiñ kiñe mufün antü. ");
INSERT INTO arnNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Fey kiñe ürkütun antü mew tripaiñ wekuntu ti waria mew inaltu lewfü, rakiduamiyiñ tañi nien ti pu judiu kiñe ngillatuwe lelfün. Anükünuwiyiñ ka nütramelfiyiñ ti küme dungu tati pu domo tüfey mew trawüluwyelu. ");
INSERT INTO arnNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kiñe ti pu domo Lidia pingey, tuwlu Tiatira mülechi waria mew neosiakelu rume kümeke fütrake katrün pañu re purpurangelu. Tüfachi domo püramyekerkefi ta Ngünechen fey allkütulerkey, fey Ñidol Ngünechen kellueyew ñi küme allkütuñmayafiel ka ñi müngeltuafiel Pablo tañi nütramkameelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Fawtisangey kom tañi pu che engün, fey wüla ka llellipueiñmew: —Rüf feyentulmun iñche tañi feyentun ta Ñidol mew, küpamün iñche tañi ruka mew tamün umañtuael. Feymew aporiaeiñmew taiñ mülewenagael. ");
INSERT INTO arnNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Kiñe rupachi, amulelu iñchiñ tati ngillatuwe lelfün mew, trenumafiyiñ kiñe üllchadomo kontunierkeeyew weküfü pelotuchefengelu. Pütrüken pülata wewkerkey tati ngenngeelchi wentru kisu mew tañi pelotucheleken mew ta kisu. ");
INSERT INTO arnNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tüfachi üllchadomo eluwi taiñ inanieaetew taiñ wirartunieetew Pablo iñchiñ: —¡Tüfachi pu wentru ta poyekefilu wenu mapu mülechi Ngünechen, kimelpapeeymünmew ta eymün ti montun küme dungu! ―pirkey ñi dungun. ");
INSERT INTO arnNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tüfa ta feypimekekey fill antü reke, fey wüla ta Pablo wesa duami. Feymew wiñokintufi ñi feypiafiel ti weküfü tañi kontunieetew: —Jesucristo tañi pepiluwün mew, werküaeyu tami tripatuael tati üllchadomo mew. Fey üyechi lelen mew müten elkünutueyew tati weküfü. ");
INSERT INTO arnNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Welu tati ngenngelelu tati üllchadomo mew, ngüneduamlu tañi doy pepi wewpülatawenoael tati üllchadomo mew, nüfi ta Pablo ka Silas, fey yefi tati waria che ñi pu awtoridad mew ñi püresuntukuafiel. ");
INSERT INTO arnNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Puwülfi engu tati pu kues mew, feypilen mew: —Tüfachi epu judiu ta pofolkañmapaeiñmew taiñ pu trokiñche. ");
INSERT INTO arnNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kimeltuyawüli engu iñchiñ taiñ ayünoelchi wimtun taiñ adümafiel no rume. Iñchiñ ta Roma tuwünche. ");
INSERT INTO arnNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Feymew kom tati pu che lladkütueyew engu, ka tati pu kues kondenaeyew tañi müntuñmangeael tañi takuwün engu ka tañi wimakangeael engu alü rumechi farilla mew. ");
INSERT INTO arnNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Rupan wimakangelu engu, tukungey karsel mew ka werküngey tati longkolelu karsel mew tañi fente küme llüwatuleael. ");
INSERT INTO arnNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Femngechi werküngelu, tati longkolelu karsel mew tukufi Pablo engu Silas doy alü ponwitulechi katrüntuku mew, fey ñi epu namun ükaftukukünuñmangey epu düllolechi mamüll mew. ");
INSERT INTO arnNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Welu feychi rangi pun dewma, Pablo engu Silas mekey ñi ülkantulfiel ta Ngünechen, fey ti kakelu püresu allkütuley engün. ");
INSERT INTO arnNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ruparumey kiñe fütra nüyün. Nengümkawi kom tati karsel. Feymew nülankepi kom tati wülngiñ, ka kom tati pu püresu neyfiyey engün tañi kadena tañi trariel mew, welu lefmawlayngün. ");
INSERT INTO arnNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Feymew trepelu tati longkolelu karsel mew, pefi ti wülngiñ karsel ñi nülalen, nentupay tañi fütra wayki tañi langümuwafel. Kisu rakiduamürkey tati pu püresu ñi kom tripatun ka lefmawün. ");
INSERT INTO arnNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Welu Pablo wirareleyew: —¡Chem wesa femuwkilnge rume! ¡Kom mülekaiñ tatey! ");
INSERT INTO arnNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Feymew tati longkolelu karsel mew mütrümi ñi elungeael kiñe küdetuwe. Lefkülen konpuy ka yafyafi fente ñi llükalen, fey lukunagpuy Pablo ka Silas tañi namun püle. ");
INSERT INTO arnNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Feymew ka nentupatufi ka ramtungey engu: —Epu ñidol, ¿chuman am tañi montuam? ");
INSERT INTO arnNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Kisu engu llowdunguy: —Feyentuaymi ta Ñidol Jesus mew. Femngechi montuaymi ta eymi ka tami pu reñmache. ");
INSERT INTO arnNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Fey tüfeychi wentru longkolelu karsel mew nütramelngey ta Ñidol Jesus tañi küme dungu ka itrokom ñi reñma müleyelu ñi ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Feychi pun müten tati llüwatulekelu karsel mew küchañmatufi ñi allfen ka feymew müten ta kisu ka kom tañi pu che fawtisangey engün. ");
INSERT INTO arnNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Fey yetufi tañi ruka mew ka elufi iyael. Kisu ka tañi pu che rumeñma ayüwküley engün tañi feyentun ta Ngünechen mew. ");
INSERT INTO arnNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Puliwentu, kiñe mufü wardia werküngey ta karsel mew, yeniey kiñe werkün dungu tañi neykümngetuael ta Pablo engu Silas. ");
INSERT INTO arnNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Fey ti longkolelu karsel mew feypifi ta Pablo: —Tati pu kues ta feypienew iñche ñi neykümtuafiel ta eymu. Amukatuaymu müten. Chem mew rume llükalelayaymu. ");
INSERT INTO arnNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Welu Pablo feypifi tati longkolelu karsel mew: —Iñchiw, tayu romachengen wimakangeyu, fey tayu penieetew ta kom che, fey tayu küme ramtukangenon rume chem mew tayu welulkan, ka püresuntukungeyu karsel mew. ¿Fey tüfa am ellka neykümngetualu ta iñchiw? ¡Ngelay tayu femngeael iñchiw ta romache! Kisu engün ta küpape tayu neykümpatuaetew. ");
INSERT INTO arnNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Fey tati pu longkolelu karsel mew kimelfi tüfachi dungu tati pu kues, fey llükay engün allkülu tañi romachengen. ");
INSERT INTO arnNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Fey tati pu kues amuyngün tañi peafiel ta Pablo ka Silas. Fey nentutufilu engün, feypifi: —Wiñoduamamuiñ taiñ welulkan mew. Fewla tripatuaymu taiñ waria mew ―pingey Pablo engu Silas. ");
INSERT INTO arnNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tripatulu engu karsel mew, Pablo ka Silas amuy engu Lidia tañi ruka mew. Rupan pefilu ka yafülfilu tañi pu peñi ka lamngen, fey wüla tripatuy engu tiye mew. ");
INSERT INTO arnNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Amulelu, Pablo ka Silas rumerpuy ta Anfipolis ka Apolonia. Feymew ka puwi engu ta Tesalonika, chew ñi niemum kiñe sinagoga tati pu judiu. ");
INSERT INTO arnNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo am wimtulelu, amuy tati sinagoga mew, fill ürkütun antü küla semana notukadunguniewi tati pu judiu engün. Nütramkaley tati Wirin Chillka dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kimelelfi ti pu che tati Cristo felerkefuy ñi layael, fey ka rupan lale, felerkefuy tañi wiñomongetuael. Famngechi feypifi: “Fey iñche tamün nütrameluwpefielchi Jesus, fey tati Cristo lle.” ");
INSERT INTO arnNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Kiñeke ti pu judiu feyentuy, fey kiñewi ta Pablo Silas engün. Ka feyentuy fentren pu griegu judiu feyentun niefulu Ngünechen mew ka pütrün domo küme felen nielu. ");
INSERT INTO arnNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Welu fey tüfachi dungu mew tati feyentunochi pu judiu rume wesa lladküy engün ka trawülfi engün tati wesake piwke wentru küdawkenolu, re miyawentulu kalle mew ñi wesa duamelkayafiel ka ñi wesa femael ti trokiñche. Malokontufi engün Jason tañi ruka, kintuyawülfi engün ta Pablo tañi nentuafiel ka ñi wültukuafiel ti pu che mew, ");
INSERT INTO arnNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","welu penofilu engün am, wingüd küpalfi engün ta Jason ka kiñeke peñi yefi engün tati waria che tañi awtoridad mew, wirarküley engün: —¡Tüfachi pu wentru ta welurakiduamelfi kom mapu mülechi pu che, ka femngechi akuy engün ta tüfa mew, ");
INSERT INTO arnNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason ta llowfi tüfachi pu wentru kisu ñi ruka mew! ¡Kom kisu engün yamüñmalafi tañi ley dungu tati Roma tuwchi emperador! ¡Feypikey engün ñi mülen ta kangelu longko ülmen, Jesus pingelu! ");
INSERT INTO arnNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Allkülu engün tüfachi dungu, tati pu che ka tati pu awtoridad kümelewelay engün. ");
INSERT INTO arnNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Welu Jason ka tati kakelu pu che kofrangey engün pülata, femngechi kulliñmawi ñi neykümngetuael engün. ");
INSERT INTO arnNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Dewma punlu, tati pu feyentulelu feypifi engün Pablo engu Silas pürümkachi tañi amuael ta Berea. Puwlu müten engu, pürümkachi amuyngu tati pu judiu tañi sinagoga mew. ");
INSERT INTO arnNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Fey tüfachi pu judiu doy küme rakiduam niey tati pu tesalonikache mew, fey ayüwünngechi llowfi engün ti küme dungu. Fill antü chillkatukefuyngün ti wirin dungu femngechi tañi kimael ñi rüfngen tañi femngechi feypiken ta Pablo. ");
INSERT INTO arnNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Feymew tati pu judiu fentrenngey tañi feyentun, ka femngechi fentren pu grieguche feyentuy ka küme felen niechi pu domo ka ti pu wentru. ");
INSERT INTO arnNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Welu tati pu judiu mülelu ta Tesalonika, kimlu engün Pablo tañi kimelkiyawülün Ngünechen tañi dungu ta Berea mew, ka amuy engün ta üyew ka wesa lladkülkapufi ti pu che. ");
INSERT INTO arnNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Welu tati pu feyentulechi che pürümkachi elufingün tañi tripayael ta Pablo fey ñi amuael ina lafken, fey Silas engu Timotew mülewey ta Berea. ");
INSERT INTO arnNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pablo ka tañi kompañkiyawületew, kiñentrür amuy engün ta Atena waria mew. Feymew Pablo tañi kompañyeetew wiñotuy engün tañi kimelelpatuafiel ta Silas ka Timotew ñi trawüael pürümkachi ta Pablo engün. ");
INSERT INTO arnNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Feymew Pablo üngümniefi Silas engu Timotew Atena waria mew, fey rume wesa duameleyew ñi pefiel mew tati trokiñche rumeñma ñi püramyeniefiel engün tati pu dewman pichike ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Feychi dungu mew notukadunguniewi sinagoga mew tati pu judiu engün, ka ti kakelu che engün ngillatukelu Ngünechen mew, fey fill antü ka femngechi notukadunguwi ta pülasa mew tati trawüluwkechi pu che engün. ");
INSERT INTO arnNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ka femngechi kiñeke fütrake kim wentru Epikurew ka ti pu Estoyko pingelu eluwi engün tañi notukadunguafiel ta Pablo, fey kiñekentu feypi engün: —¿Chem pimekey anta tüfachi koyla wewpife? Fey kakelu feypi: —Wewpiyawülfilu trokifiñ kake tripanche ñi pu ngünechen. Fey tüfa ta feypi engün Pablo am kimelkiyawül-lu Jesus tañi küme dungu ka tañi wiñomongetun. ");
INSERT INTO arnNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Feymew yengey tati Areopago mew tañi wimtun trawüluwpemum engün tañi nütramkawam, fey ramtungey: —¿Feypimuafuiñ kay chem we kimeltun eymi tami küpalelmufiel? ");
INSERT INTO arnNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Fütra kalechi dungu ta feypimukeiñ ta eymi, fey ayüleiñ taiñ kimael ñi chem dungungen. ");
INSERT INTO arnNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Kom tati pu che Atena tuwlu, ka femngechi kom tati kake tripanche mülelu tüye mew tüfeychi dungu müten küpa allkütunietufi ka nütramyenietufi engün ti we rupayechi dungu.) ");
INSERT INTO arnNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Feymew Pablo witrapüray kisu engün ñi rangiñ mew ti Areopago mew, fey feypi: “Pu che Atena tuwlu, kom tañi peel mew, ngüneduamün eymün tamün rume küme inanien tamün wimtun dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Fey adkintufilu ta iñche tati ngillatuwe lelfün chew eymün tamün ngillatukemum, pefiñ kiñe ngillatuwe mew fey tüfachi wirin dungu: ‘Tati kimnoelchi Ngünechenngealu.’ Fey tüfa llemay, feychi Ngünechen eymün tamün ngillatukeel tamün kimnofiel rume, feychi Ngünechen ta nütrameluwkeyiñ ta iñche. ");
INSERT INTO arnNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Feychi Ngünechen ta dewmafilu ta kom mapu ka kom chemkün mülelu ta tüfa mew, kisu ta Ñidolküley ta wenu mapu ka tüfachi mapu mew. Kisu ta mülekelay che ñi dewmaelchi ngillatuwe ruka mew. ");
INSERT INTO arnNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kisu ta duamlay iney rume tañi kelluaetew chem mew no rume, kisu am elunieetew ta mongen ta itrokom iñchiñ fey ti kürüf ka kom ti kakelu chemkün. ");
INSERT INTO arnNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Kiñe wentru mew müten ta elkünuy kom che mapu mew, tañi müleael kom mapu mew. Kisu ta adkünufi ñi chumlerpuael ta tripantu ka chuchi lelfün mew tañi müleael engün. ");
INSERT INTO arnNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Fey ka femngechi ñi kintuafiel engün ta Ngünechen, tunte pengekellenofule rume, welu tañi kimafiel engün ta kisu, tunte feyngefuy rume ta Ngünechen ñi alü kamapulenon kake kiñeke iñchiñ mew. ");
INSERT INTO arnNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ngünechen mew ta mongeleiñ, ka nengümküleiñ ka müleiñ. Ka femngechi kiñeke eymün tamün poeta feypi: ‘Iñchiñ ta Ngünechen ñi tuwünchengeiñ.’ ");
INSERT INTO arnNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Fey Ngünechen ñi tuwünche ta iñchiñ, ngelay taiñ rakiduamael Ngünechen tañi oro widünngen ka pülata no rume ka kura no rume tati pu che tañi dewmakeel ka tañi adentukünuel engün. ");
INSERT INTO arnNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kuyfi mew ta Ngünechen ngüyünentuñmafi ñi welulkalekefel ñi rakiduam tati pu che, welu tüfa werküniefi kom che, itrokom püle mülelu tañi wiñorakiduamtuael ta kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ngünechen am elkünulu kiñe medin antü, feychi antü mew ramtukadunguafi ñi chumün ta kom che mülelu mapu mew kiñe nor dungu mew, Ngünechen tañi dullintuelchi wentru mew. Fey tüfa ta fente küme kimnieiñ ñi rüf dungungen, Ngünechen am wiñomongeltufilu ta Jesus.” ");
INSERT INTO arnNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Allkülu engün ñi wiñome wiñomongetuael tati lachi pu che, kiñekentu ayekawi engün, fey kakelu feypiyey engün: —Ka allkütuñmawayiñ tami feypipeel tüfachi dungu ka antü wüla. ");
INSERT INTO arnNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Feymew Pablo elkünutufi ti pu che. ");
INSERT INTO arnNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Welu kiñekentu inaeyew ka feyentuy engün. Fey kisu engün mew mülerkey Dionisio, kiñe ti Areopago trawün mew konkülelu, ka femngechi kiñe domo Damaris pingelu, ka fentren kakelu che. ");
INSERT INTO arnNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Dew rupalu tüfachi dungu, Pablo tripay ta Atena, fey amuy ta Korinto waria mew. ");
INSERT INTO arnNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Feymew pewi kiñe judiu engu Akila pingelu, Ponto ñi trokiñ mapu mew mülelu. We akuleturkey, tati epu kurewen Akila engu Prisila wiñomerkey ta Italia. Üyew küpaturkey engu, tati emperador Klawdio pingelu, werkülu am kom tati pu judiu ñi tripatuael engün ta Roma waria mew. Pablo amuy tañi witrankontumeaetew. ");
INSERT INTO arnNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ka femngechi kisu reke dewmakefuy karpa rukangealu, fey kiñe rumelu am ñi küdaw, ayürkey ñi kiñentrür küdawael engün. ");
INSERT INTO arnNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Fill ürkütun antü Pablo amukey ti sinagoga mew, nütramkapukefuy tañi wiñorakiduameltuafiel tati pu judiu ka tati pu griegu. ");
INSERT INTO arnNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Fey Silas engu Timotew wiñomelu ta Masedonia mapu mew, feychi mew Pablo eluwi ñi kiñe rume küdaw ñi inayael tañi kimeltuael ti werken dungu müten, ka ñi küme feypiafiel tati pu judiu Jesus tañi Cristongen. ");
INSERT INTO arnNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Welu kisu engün eluwi ñi notukadunguafiel ka ñi lukatuafiel, feymew ta Pablo mütrowkay tañi takuwün. Femngechi pengeli tañi wesa duamtufiel engün ka feypifi: —Kisu tamün wesa femuwün ka kisu eymün tamün montunoael, iñche ta dew kimeltun ti rüf dungu, feymew iñche yafkalelan ta eymün mew. Fachantü eluwan tañi kimeltuafiel tati pu judiu tuwünngenolu müten. ");
INSERT INTO arnNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tripatuy tati sinagoga mew, fey amutuy kiñe wentru, Tisio Justu pingelu, tañi ruka mew. Fey tüfachi wentru ngillatukerkey Ngünechen mew ka fülkülerkey tati sinagoga mew. ");
INSERT INTO arnNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Fey Krispu, kiñe ti longkolelu tati sinagoga mew, ka kom tañi pu reñma nieelchi pu che, feyentuy ta Ñidol mew. Ka pütrün tati pu che mülelu Korinto waria mew, allkütulu engün ti küme dungu, feyentuy ka fawtisangey engün. ");
INSERT INTO arnNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kiñe pun, Ñidol feypifi ta Pablo, kiñe pewma mew: “Llükakilnge. Amulnienge tami kimelün ti werken dungu ka femkünuwkilnge tami dunguleael. ");
INSERT INTO arnNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Iñche ta mülen eymi iñchiw. Iney rume ta elulayafiñ tami üñfituaetew, iñche am nielu rume fentren che tüfachi waria mew.” ");
INSERT INTO arnNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Feymew Pablo mülewenagi Korinto mew kiñe tripantu ka rangiñ, tañi kimeltuafiel ti pu che Ngünechen tañi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Feychi Akaya trokiñ mapu mew gobernadorkülelu ta Galion, tati pu judiu trawüluwi tañi üyawtudunguafiel engün ta Pablo. Yefi engün ta tribunal mew, ");
INSERT INTO arnNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","fey feypipufi engün tati gobernador: —Tüfachi wentru ta ngülamkiyawülfi tati pu che tañi püramyeafiel ta Ngünechen, welu tati ngülam welulkaley tati ley dungu mew ―pi engün. ");
INSERT INTO arnNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo llowdunguafulu, fey Galion feypifi tati pu judiu: —Tüfa yafkafule ka langümchefule, iñche felefuy tamün küme llowafiel ka tamün allkütuafiel eymün tamün judiungen. ");
INSERT INTO arnNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Welu re kimeltun dungu müten ka re üy che müten ka eymün tamün ley dungu mew müten, feley kisu eymün tamün adkünuafiel. Iñche pilan tañi keyükonael ta feytichi dungu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Fey wemünentungepatuy engün tati tribunal mew. ");
INSERT INTO arnNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Feymew nüfi engün ta Sostene, kiñe ti longkolelu ta sinagoga mew. Üye mew müten wülelkafi, petu ñi mülepun engün tati tribunal mew. Welu Galion duamnieñmalaeyew tañi femmeken engün. ");
INSERT INTO arnNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Fey Pablo mülewey fentren antü Korinto waria mew, fey wüla chalitufi tati pu feyentulechi che. Kiñentrür Prisila ka Akila engün püray ta farku mew, fey amuy Siria ñi trokiñ mapu mew. Welu Senkrea mew petu ñi püranon farku mew, fente küme kupilkünuy tañi longko tañi mupiael ñi feypikünuelchi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Puwlu engün ta Efeso, Pablo elkünufi ta Prisila engu Akila, fey amuy ta sinagoga mew, nütramkapufi tati pu judiu trawüluwkelu tüfey mew. ");
INSERT INTO arnNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Fey kisu engün llellipueyew tañi müleweafel doy alüñma, welu kisu pilay. ");
INSERT INTO arnNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Chalingetuy engün feypilen mew: “Feley tañi amuael Jerusalen femngechi tañi mülepuael tati püllelepachi kawiñ antü mew. Pile ta Ngünechen, ka wiñome witranngepayan.” Fey wüla Pablo tripatuy ta Efeso, püratuy kiñe farku mew, fey amuy Sesarea mew. ");
INSERT INTO arnNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Feymew puwlu ta Sesarea, amuy ta Jerusalen tañi chalimeafiel tati trokiñche feyentulelu, fey wüla ka amuy ta Antiokia. ");
INSERT INTO arnNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Fey kiñe mufün antü rulpalu, ka tripay wüla tañi peafiel re kiñeke tati trokiñke mapu Galasia ka Frigia, fey ñi yafültukuafiel kom tati feyentulechi pu che. ");
INSERT INTO arnNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Feychi mew akurkey ta Efeso waria mew kiñe judiu Apolu pingelu ñi üy, Alejandria waria mew tuwlu. Rume pepilürkey ñi wewpiael ka rume küme kimnierkey tati wirikonkülechi dungu Wirin Chillka mew. ");
INSERT INTO arnNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Fente küme kimeltungerkey Ñidol tañi küme dungu mew, fey rume ayüwünngechi dungukerkey ka küme kimeltukerkey Jesus tañi küme dungu, tunte Juan tañi fawtisangen müten ta küme kimniefuy. ");
INSERT INTO arnNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolu eluwi tañi dunguael tati sinagoga mew, welu allküñmaetew tañi wewpin ta Prisila engu Akila, fey engu wichu yetueyew ka doy küme kimelelngey Ngünechen tañi küme dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Fey Apolu ayülu ñi rumerpuael Akaya trokiñ mapu mew tati pu feyentulelu pürümkachi kellueyew, ka amulelfi kiñe wirin dungu feychi trokiñ mapu mew feyentuleyechi pu che tañi küme llowngeael ta Apolu. Puwlu ta Akaya trokiñ mapu mew, rume kellupufi tati pu che feyentulelu Ngünechen tañi küme fürenechen mew. ");
INSERT INTO arnNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Fey tañi penieetew kom che, nor dungu mew ngülamtuniefi tati pu judiu Wirin Chillka mew tripachi dungu mew müten femngechi ñi feypiafiel Jesus rüf mew ñi Cristongen. Fey kisu engün pepi llumumalay tüfachi dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Petu ñi mülepun ta Apolu Korinto mew, Pablo katrürumey fütra wingkulngechi trokiñ mapu, fey puwi ta Efeso waria mew. Fey tüfey mew pepuy fentren che feyentuleyelu. ");
INSERT INTO arnNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Fey ramtufi ti pu che: —¿Llowimün kay tati Lif Küme Püllü feychi we feyentulu eymün? Kisu engün llowdungueyew: —Allkükelaiñ rume tati dungun ñi llowngeafel ti Lif Küme Püllü pin. ");
INSERT INTO arnNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Fey Pablo ramtufi ti pu che: —Fey ¿iney ñi fawtisachen mew fawtisangeymün? Fey kisu engün llowdunguy: —Juan ñi fawtisachen mew ta fawtisangeiñ. ");
INSERT INTO arnNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo feypifi: —Fey Juan fawtisayefi tati wiñorakiduamtulu Ngünechen mew, welu feypiyefi tañi feyentuael engün tati inalepalu kisu mew, fey tüfa ta Jesus ürke. ");
INSERT INTO arnNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Allkülu engün fey tüfachi dungu, feyentuy engün ka fawtisangey Ñidol Jesus mew. ");
INSERT INTO arnNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Feymew Pablo fampuwül-lu tañi kuwü kisu engün mew, ka femngechi akuy kisu engün mew tati Lif Küme Püllü, fey dunguy engün kimpenoelchi dungun mew, ka kimeli engün Ngünechen tañi eluetewchi werken dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Itrokom ta kisu engün mew mülerkey mari epu wentru. ");
INSERT INTO arnNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kiñe küla küyen, Pablo amuamungey tati sinagoga Efeso waria mew. Kimeltumekepuy tati werken dungu chem llükan mew no rume. Dungumekefi tati pu che ñi feyentuael engün kay Ngünechen tañi longko ülmenngen. ");
INSERT INTO arnNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kiñekentu tañi feyentuafel yafükünuy tañi piwke, pilay ñi feyentuael, fey kom che ñi adkiñ mew wesa dunguyemekefi tati kangelu kiñen we küme mongen. Feymew Pablo wüdatripatuy kisu engün mew. Fey yetufi tati pu feyentulelu Tirano pingechi kimeltuwe ruka mew, fey tüyew nütramkapukey fill antü. ");
INSERT INTO arnNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Fey femngechi femmekey kiñe epu tripantu, feymew kom tati müleyelu ta Asia ñi trokiñ mapu mew, tati pu judiu ka tati pu griegu, allküy engün Ñidol tañi küme dungu. ");
INSERT INTO arnNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ngünechen pengeli rume fütrake pepiluwün ta Pablo mew. ");
INSERT INTO arnNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Pablo tañi idakünuelchi pañuelu ka takuwün kütu, yelelngetuy tati pu kutran, fey tüfa engün tremotukey tañi kutran mew ka ti pu weküfü tripatukey ti pu kutran mew. ");
INSERT INTO arnNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Welu ka femngechi kiñeke tati pu judiu miyawyelu rüpü mew wemünentukerkey engün ti pu weküfü ti pu kutran mew, fey tüfa engün ayürkefuy tañi wemünentuael ti pu weküfü Ñidol Jesus tañi üy mew. Feypikefi engün tati pu weküfü: —¡Jesus tañi pepiluwün mew, Pablo tañi wewpikeel, werküeyu tami tripayael! ");
INSERT INTO arnNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Fey femngechi femürkey kiñe judiu Esefa pingelu tañi regle pu fotüm, kiñe tati longkolelu tati pu saserdote mew. ");
INSERT INTO arnNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Welu kiñe rupachi tati weküfü llowdungueyew: —Kimfiñ ta Jesus, ka ñi ineyngen ta Pablo, welu eymün kay, ¿iney ñi pepiluwün mew femkeymün tüfa? ");
INSERT INTO arnNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Feymew müten, tati wentru kontunieetew tati weküfü, lefkontueyew engün, fütra newen mew fill chuchika ngünekangey engün, rume wülelkangey, fey lefmawkülen amutuy engün ñi ruka mew, triltrangküley ka allfükaley engün. ");
INSERT INTO arnNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kom tati müleyelu Efeso mew kimlu ñi rupan tüfachi dungu, tati pu judiu ka ti pu griegu rume llükay engün. Fey tüfa famngechi amuley ñi rume afmatuñmangen Ñidol Jesus ñi pepiluwün. ");
INSERT INTO arnNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ka femngechi kom tati feyentuyelu akuyey ka rangi che nentudungupay kom tañi wesa femkefel engün kuyfi mew, ");
INSERT INTO arnNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ka pütrün che tati adümkatukefulu ti kalku dungu küpalyey engün tañi chillka ka lüpümfingün, fey ñi penieetew kom che. Inaduamngeyelu tañi tunte faliyen tati pu chillka, kechu mari warangka moneda pülata faliyerkey. ");
INSERT INTO arnNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Femngechi Ñidol tañi werken dungu kom püle doy amuley ñi kimngen ka pengelmangey ñi pepiluwün. ");
INSERT INTO arnNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Dew rupalu tüfachi dungu, Pablo eluwi tañi amuael ta Masedonia ka Akaya trokiñ mapu, ka ñi yom amulerpuael fey ñi puwael ta Jerusalen waria mew. Ka femngechi feypilerkey: “Dew wiñomeli ta Jerusalen, ka felerkey ñi amuael ta Roma.” ");
INSERT INTO arnNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Feymew werküy epu tañi kellukeetew ñi amuael ta Masedonia, Timotew ka Erasto. Fey kisu mülewenagi ka kiñe doy mufün antü ta Efeso mew, Asia trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Fey üyechi antü mew müley ta Efeso rume fütra pofolkawün tati we küme mongen ñi duam. ");
INSERT INTO arnNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tüfachi dungu witrantuy kiñe wentru Demetrio pingelu, kiñe rütrafe ürke. Demetrio dewmakerkey pichike rütran adentun re pülatangelu, adentukünukefilu ti ngillatuwe ruka chew püramyengekey kiñe domo ngünechen Artemisa pingelu. Rumeñma wewkerkefuy engün ta pülata tati pu küdawkelu kisu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Trapümyefi, kom tüfa engün, kiñentrür kakelu engün tati küdawkelu ka femngechi rütran küdaw mew, fey feypifi: “Pu ülmen, eymün ta kimnieymün iñchiñ taiñ küme felen tripaley fey tüfachi küdaw mew. ");
INSERT INTO arnNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Welu eymün ta pefimün ka allkükefimün, fey ti Pablo pingelu feypiyawi che tañi dewmakeelchi ngünechen fey ta ngünechen no. Femngechi ta kakünurakiduamelfi pütrün che tüfa Efeso mew müten no ka femngechi femi epe kom Asia tañi trokiñ mapu mew. ");
INSERT INTO arnNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Fey tüfa ta rume kuñiwünngey, newe fendewelayafuiñ taiñ rütran adentun pichike ngünechen. Ka tati fütra Artemisa pingechi domo ngünechen tañi ngillatuwe ruka mew ayüduamangewelayafuy tañi afmatungeael. Femngechi ta illamngetuay ñi afmangekefel ta tüfachi domo ngünechen tati püramyekeel Asia trokiñ mapu mew mülechi pu che ka mülelu kom chüf mapu mew.” ");
INSERT INTO arnNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Allkülu engün fey tüfachi dungu, rume lladküy ka wiraringün: —¡Püramyengepe pu efesoche tañi domo ngünechen! ");
INSERT INTO arnNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Fey müley pofolkawün kom tati waria mew. Lefkontufi engün ta Gayo ka Aristarku, epu wentru Masedonia tuwlu kompañkiyawülfilu ta Pablo, ka wingüdyefi engün, fey puwülfi kiñe fütra pülasa mew. ");
INSERT INTO arnNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo ayüfuy ñi konpuael tati pülasa mew tañi dunguafiel ti pu che, welu pilaeyew tati pu feyentulelu. ");
INSERT INTO arnNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ka femngechi Asia mülechi pu awtoridad mew Pablo nierkey kiñeke weni, fey feypifaleyew tañi konpunoael ta tüye mew. ");
INSERT INTO arnNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Fey ti trawün mew kiñekentu wirari kiñe dungu, fey kakelu wirari kangelu dungu, tati pu che am lladküleyelu ka kimlay rume chem mew tañi trapümngen engün. ");
INSERT INTO arnNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Welu kiñekentu ta kisu engün küme nentudungulelfi ta Alejandro chem dungu ñi mülen, tati pu judiu tañi rültrentukupuel itrokom che ñi adkiñ mew. Alejandro witrañpürami tañi kuwü “ñüküfkülemün” tañi piafiel engün femngechi tañi dunguñpeafiel tati pu judiu rangi ti pu waria che. ");
INSERT INTO arnNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Welu ngüneduamngelu kisu tañi judiungen, kom wirari engün kiñe epu ora: “¡Püramyengepe pu efesoche tañi domo ngünechen!” ");
INSERT INTO arnNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tati sekretariolelu waria mew, küme dungun mew “ñüküfkülewemün” pifi tati pu che ka feypifi: “Efeso waria che, kom mapu mew ta kimniey tüfachi waria che ñi elfalngen tañi kuydanieael ti fütra Artemisa domo ngünechen tañi ngillatuwe ruka ka kisu tañi adentun, tati ütrüfnagpalu ta wenu mapu. ");
INSERT INTO arnNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Iney rume pepi llumumanoafulu, tüngnagmün ta eymün chem wesa femkelayaymün rume petu tamün küme rakiduamnon. ");
INSERT INTO arnNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tüfachi pu wentru eymün tamün küpalel illamkalafi engün tati ngillatuwe ruka ka wesa dunguyelafi rume taiñ domo ngünechen. ");
INSERT INTO arnNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Fey Demetrio ka tati pu küdawkelu kisu engün ka yafkaeliyew kiñeke che, müley ta kues ka müley ta kujaw. Reküluwpe engün tati pu awtoridad mew. Kake kiñeke ingkañpewpe tañi yafkangemum engün. ");
INSERT INTO arnNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Eymün ta ka dungu duamyenielmün, müley tamün nütramkawael fey ti ley dungu mew ñi küme elngeael ti welulkawün. ");
INSERT INTO arnNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Fey fachantü rupachi dungu mew kuñiwünngey taiñ feypintukungeael tati pu awtoridad mew taiñ pofolkachemeken mew. Ngelay chem dungu rume taiñ piael, ramtungeliyiñ chem mew tañi mülen tüfachi pofolkawün.” ");
INSERT INTO arnNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Fey feypikünulu tüfachi dungu, chaliyetufi tati pu che. ");
INSERT INTO arnNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Dew rupalu tati pofolkawün, Pablo mütrümfi tati feyentulelu tañi ngülamtuafiel, ka pürüm chaliyetufi, fey kisu amuy ta Masedonia trokiñ mapu. ");
INSERT INTO arnNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Witranngeyawi kom tiyechi trokiñke mapu mew. Rume yafülkiyawülfi kom küme dungun mew tati pu feyentulelu. Fey wüla ka puwi ta Gresia trokiñ mapu mew, ");
INSERT INTO arnNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","fey tüfey mew küla küyen mülewepuy. Dew epe puwlu tañi konpuael farku mew ñi amuael ta Siria mew, kimi ñi trürümkadunguleletew tati pu judiu ñi wesa femmekeaetew. Feymew rakiduamtuy ñi rüpütulen amuael, fey ka wiñome ñi rumetuael Masedonia püle. ");
INSERT INTO arnNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kompañeyew ta Sopater, Berea tuwlu, Piro tañi fotüm; Aristarku ka Segundo tati tuwlu Tesalonika, Gayo tuwlu Derbe, Timotew, Tikiko ka Trofimo, Asia tañi trokiñ mapu mew tuwyelu. ");
INSERT INTO arnNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Fey tüfachi pu peñi wüneluwi engün, fey üngümniepueiñmew ta Troa waria mew. ");
INSERT INTO arnNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Iñchiñ, dew rupalu tati kawiñ tañi ingekemum lefawrangenochi kofke, tripaiñ ta Filipo waria farku mew. Kechu antüpualu mew, dipufiyiñ engün ta Troa mew, feymew mülewepuiñ regle antü. ");
INSERT INTO arnNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Tati llituchi antü semana mew trawüluwiyiñ taiñ ngillatuael ka traf iyael ta kofke chumngechi femi Jesus tañi pu disipulu engün, Pablo nütramkaniefi tati pu feyentulelu. Kangelu antü mew am felerkelu ñi tripayael, rangi punmay ñi wewpimeken. ");
INSERT INTO arnNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Trawüluwküleiñ kiñe katrüntuku wenu ruka mew, fey tüfey mew rume fentren pelontuwe üyküley. ");
INSERT INTO arnNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kiñe weche wentru, Ewtiko pingelu, anüley ti alü rupachi fentana mew. Pablo am rume alüñma dungulu, añituy tati weche wentru, feymew ka fütra kon umawtuy, ütrüfnagpay küla pisu wenu ruka mew. Lalen witrañpüramngey. ");
INSERT INTO arnNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Feymew Pablo nagpay, winakünuwpay wente tati lalechi weche wentru mew ka mafülüfi. Ka feypifi tati pu feyentulechi che: —¡Llükakilmün! Mongelekay tati. ");
INSERT INTO arnNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Feymew Pablo ka püratuy ti wenu ruka mew, wükafi ti kofke chumngechi femi Ñidol Jesus, ka ifingün, ka amuley ñi dungun, fey wünmatripa wewpi. Feymew wüla amutuy. ");
INSERT INTO arnNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Fey tati weche wentru, mongelen yengetulu am, tati pu che mülelu Troa waria mew yafüluwi engün. ");
INSERT INTO arnNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Iñchiñ tati kompañkiyawlu wüneluwiyiñ ka püraiñ ta farku mew taiñ puwael ta Aso ka taiñ llowmeafiel ta Pablo, femngechi taiñ adkünuwün, kisu am ayülu ñi namuntu amuael. ");
INSERT INTO arnNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Feymew pewpulu ta iñchiñ Aso mew, kiñentrür püraiñ ta farku mew, fey amuiñ ta Mitilene. ");
INSERT INTO arnNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tripaiñ ta tüye mew, fey ka antü mew rumeiñ Kiyo ñi itrotripa, fey ka kiñe antü rupalu mew wüla puwiyiñ Samos tañi ayliñ mew. Ka rumeiñ Trogilio ñi ayliñ mew. Ka kiñe antü amulu iñchiñ, puwiyiñ ta Mileto ñi ayliñ mew. ");
INSERT INTO arnNT_vpl VALUES ("AC20_16","074_20_