﻿USE sofia;
DROP TABLE IF EXISTS sofia.arlNT_vpl;
CREATE TABLE arlNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES arlNT_vpl WRITE;
INSERT INTO arlNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristoori supuetana Abraham jiuhuacuajinio supueno quiquiaari, supuetana David niquiohuacuajinionio. Nioori Jesucristo supuetanaa sesaca. Naa quiquiaaritij: ");
INSERT INTO arlNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamri Isaac que quiquiaari. Isaacri Jacobo que quiquiaari. Jacoboori Judá que quiquiaari, tapueyocuaca quejuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judaari Fares que quiquiaari, Zara quejuhuaj. Cuno pojori nucuaari quiquiaari Tamar, Judá niquiocua. Faresri Esrom que quiquiaari. Esromri Aram que quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramri Aminadab que quiquiaari. Aminadabri Naasón que quiquiaari. Naasónri Salmón que quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmónri Booz que quiquiaari. Booz nucuaari quiquiaari Rahab. Boozri Obed que quiquiaari. Obed nucuaari quiquiaari Rut. Obedri Isaí que quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaiiri David que quiquiaari. Davidri Israel pueya jiyaniijia quiquiaari. Davidri Salomón que quiquiaari. Salomón nucuaari coteenu quiquiaari Urías niquiocua. ");
INSERT INTO arlNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónri Roboam que quiquiaari. Roboamri Abías que quiquiaari. Abíasri Asa que quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaari Josafat que quiquiaari. Josafatri Joram que quiquiaari. Joramri Uzías que quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasri Jotam que quiquiaari. Jotamri Acaz que quiquiaari. Acazri Ezequías que quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasri Manasés que quiquiaari. Manasésri Amón que quiquiaari. Amónri Josías que quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíasri Jeconías que quiquiaari, tapueyocuaca quejuhuaj. Jiyacaritij, Israel pueyapueeri quioosaaquiaari Babilonia jiyajiniara. ");
INSERT INTO arlNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilonia jiyajinia, Jeconíasri tii mueratequiaari Salatiel. Salatielri Zorobabel que quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelri Abiud que quiquiaari. Abiudri Eliaquim que quiquiaari. Eliaquimri Azor que quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorri Sadoc que quiquiaari. Sadocri Aquim que quiquiaari. Aquimri Eliud que quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudri Eleazar que quiquiaari. Eleazarri Matán que quiquiaari. Matánri Jacobo que quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacoboori José que quiquiaari. Joseeri María niyaca quiquiaari. Cuno Maríari Jesu nucua quiquiaari. Jesu sesa tarajanuuri quiquiaari Cristo. Nioori pueyano rupaajinia sequeya “Pueyaso jiyarosano Jiyaniijiarano”. ");
INSERT INTO arlNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Naacuajitij, Abrahamjiniji, catorce supuetanaari quiquiaari Davidta. David nuhuaji, socua catorce supuetanaari quiquiaari. Jiyacaritij, Israel pueyapueeri quioosaaquiaari Babilonia jiyajiniara. Babilonia jiyajiniara nojori quioosaanu nuhuaji, socua catorce supuetanaari quiquiaari Cristo jaara rasaaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Naa quiquiaariti Jesucristo rasacari: na nucuarano Maríari tari Joseeta camiriquiano quiquiaari. José numuetuqueyaquishacarijia María, Maríari tariucua manajaraca quiriquiaa. Pueyaso Sohuanucuajaari na manajetequiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Neyacarano José jaara niishiquiaari necorano tariucua manajaraca quiya, nojuajaari jiyanohua niishiriojoriquiaa na cartenura jiyasohuaja. Nojuajaari jiyaniquiaari tamonu jiyoteeri na manajoree. Joseeri maninia pueyano quiquiaari. Majaari María na cararonu paniniu quiquiaari pueya niquiara. ");
INSERT INTO arlNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Naa José niishiriojosacari na cartenura juucuatej, Pueyaso seruuri nocua muetaquiaari na maquenujinia. José sequereeri: —Supuetana jiyaniijia David niquiohuacuajinio supueno Joseenaa, María quia camiri naajaa. Maja quia puerenu. Pueyaso Sohuanucuajaari na manajorucuaa. ");
INSERT INTO arlNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maríari neyanu ranutaniya. Quiocua na sesojore “Jesu”. Sesa na pueya miijiosano tuujunutaniya nojori jiuujiajinijiiri. Naaratej, na sesaari quiniutianiya “Jesu”. ");
INSERT INTO arlNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jesu rasaanuuri naa quiquiaaritij, tariucuacaanu pueyara Pueyaso sequesano caminiujiunia pohuatasano tohuateenura. Pueyasoori naa na pohuataniquiaari jiyanohua tarijiatej: ");
INSERT INTO arlNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nia tojiri. Niyacoori manajenutaniya. Neyanu ranutaniyari. Na sesojonutaniyari ‘Emanuel’”. Nioori pueyano rupaajinia sequeya “Pueyaso pata quiyani”. ");
INSERT INTO arlNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José niucuasacari, nojuajaari naa miiquiaaritij taa Pueyaso seru sequequiaari nojuacuajani. María riquiaariiri na tiajiniara necocuara. ");
INSERT INTO arlNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nojoriiri maja na quiniu quiquiaari juhua seetanujuanaa camitioono, María jaara raquiaari neyanujuaatijia. Jaara na raquiaari, na sesojoreeri “Jesu”. ");
INSERT INTO arlNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesuuri rasaaquiaari Belén tiacajinia, Judea jiyajinia. Cuno quishacari, Herodesri jiyaniijia quiquiaari Judea jiyajinia. Jesu rasaanu nuhuaji, niishijiacaari tiuquiijioquiaari Jerusalén tiacajinia. Nojoriiri Jesu niquiniuria tiuquiijioquiaari jiya pajamaji. ");
INSERT INTO arlNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nojori tiuquiijiosacari, nojoriiri pueya nequesoreetaquiaari: —¿Tee Judiocuaca jiyaniijiarano rasaarucuaani? Canaari niishiyani nojuajaari tari rasaarucuaa. Canaari na rijia niquiquianu jiya pajamajini, canaa jiyajinia canaa quishacarijia. Canaari nocua niyareeni canaa shuquiritianura nojuaja, jiyaniijiarano na quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jiyaniijia Herodes tojishacari naa niishijiaca sequesanotej, jiyanohua tacaaquiaariiri. Puetunu Jerusalén tiacajinia quiniaajanaari tacaaquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nocuaji, Herodesri Judiocuacaacuara secojonaa sequequiaari nocua nojori nijionura, Moisés Rootasanojiniji niishitiojonaanio. Nojori tiuquiijiosacari nocua, Herodesri naa nequesoreetaquiaari nojori: —¿Tee Cristo rasaanutaniyani, Judiocuaca jiyaniijiaranotej? ");
INSERT INTO arlNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nojoriiri na riucuaquiaari: —Belén tiacajinia rasaanutaniyano, niya Judea jiyajiniani. Naa naajiotasano quiyacuajaari Pueyaso sequesano caminiujiunia sequesano. Cuno tariucuacaanu naajiotasanocuajaari naa sequeyatej: ");
INSERT INTO arlNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Belén tiacajinia quiniaanaa, nia tiacaari maja najuhuana shiitianiyojua tiaca Judea jiyajinia. Cuno nia tiacajiniani, Jiyaniijiajanaa cutaraari supuenutaniya. Nojuajaari socua cutara Jiyaniijiajanaa quiniutianiya tamasaca jiyaniijiacajiniji Judea jiyajinijinio. Cunoori maninia jiitianutaniya cua pueya, Israel pueya”. ");
INSERT INTO arlNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Naa pueya sequesano na tojiniu nuhuajitij, Herodesri cuno jiya pajamaji nijiono niishijiaca nequesoreetaquiaari jiyasohuaja: —¿Taacari rijia niquishaacanu seetanujuanaani? ");
INSERT INTO arlNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nojori riucuanu nuhuaji, Herodesri na sapojonuta nojori sequequiaari: —Nia quiaare Belén tiacajinia. Niocua jacaria nequesoreetasee cuno mueyajiniji. Niaa jaara na riuriatare, niocua cua numootecuhuaja. Janiyacua nocua quiaarejaaniuhuaj cua shuquiritianura nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Niishijiaca tojiniu nuhuaji naa jiyaniijia Herodes sequesanotej, nojoriiri quiojiyareecuhuaj. Jiya pajamaji na niquitiushano rijia niquitiuriiri nojori puetaano. Rijiaari pootia tiuushii tia caco, tee mueya quiriquiaacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nojori niquishacari rijia, niishijiacaari jiyanohua timitiuquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tiaco tiuquitiaseeri. Conaaja niquitiushii na nucua Maríataari. Conaajaacuara mojoquetacoquiaariiri. Na shuquiritiatureeri. Na nuhuaji, niishijiacaari na patootasano casaa riataquequiaari, nareya na niquitiosocoriquiano conaaja. Nojoriiri na niquitioquiaari oro, shanohua jaanutaja catijiasocoriquianojuhuaj, tamaatiuucua shanohua jaanutajanio. Na sesaari tahue rupaajinia “mirra”. ");
INSERT INTO arlNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na nuhuaji, Pueyasoori cuno niishijiaca sequequiaari na maquenujinia, maja Herodescua nojori tacatenuhuara Herodes nojori pohuatanuhuara conaajajiniji. Naacuajitij, niishijiacaari tamonu nucuacohua tacatequiaariuhua na jiyajiniohuara. ");
INSERT INTO arlNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Niishijiaca jaara quiaquiaariuhua, Pueyaso seruuri Joseecua muetaquiaari na maquenujinia. José sequereeri: —¡Quia sanere! ¡Conaaja quia mashitiare na nucuata Egipto jiyajiniara! Quiniqui nia quishii, janiya cuaara sequerohua quiajaniyajaatijia. Herodesri Belén tiacajinia na pueya pajetenutaniya conaaja, na motesocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseeri sanequiaari. Cuno niucuaja, conaaja mashitiaree na nucuatajaari Egipto jiyajiniara. ");
INSERT INTO arlNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nojori tiuquishacari Egipto jiyajinia, tii quishiiquiaariiri, Herodes cuaara cusoorajaatijia. Nojoriiri naa Egipto jiyajinia quiquiaaritij, tariucuacaanu Pueyaso sequesano tohuateenura maninia, Herodes cusonu nuhuaji. Pueyasoori naa pohuatequiaari na sequenu panishano caminiujiuniacuaja: “Cua niyanu piiriinijia, Egipto jiyajiniji na tacatenuhuara”. ");
INSERT INTO arlNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jiyaniijia Herodes jaara niishiquiaari cuno niishijiacaari na ruuretaquiaari saaja, Herodesri jiyanohua juaaquiaari. Na pueya jiyaroquiaari puetunu naatujoori canuuniyojuajanaa nojori puecoonura Belén tiacajinia, na shocuaqueya tiacajinia quiniaa muerasunio. Naa miiquiaariiri Jesu na monura juucua. Herodesri na pueya sequequiaari cuaara puecoosaaria puetunu shusha roosanojuanaa, mariyata canapuete caapiqui marijia shocoteo quiquiaarijiani. Herodesri naa sequequiaari niishijiaca pohuatanuucua nojuaja, Jesu rijiaari tarijia niquishaaquiaari. Juhuanojuajaari maja caapiqui marijia shocojonu quiquiaari rijia niquishaanujiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Naacuajitij, tariucuacaanu Pueyaso sequesano caminiujiunia Jeremías sequesanoori tohuateequiaari. Jeremías sequesanoori naa naajiotasaaquiaaritij: ");
INSERT INTO arlNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Sapuenuuri tojishiya Ramá tiacajinia. Jiyanohua taraatia. Raquelri necohuacua sariyacojiya. Majaari na paniniu na cumanijiasaanura. Necohuari tari puecoosaarucuaa”. ");
INSERT INTO arlNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na nuhuaji, Herodes jaara cusoquiaari, Pueyaso seruuri Joseecua muetaquiaariuhua na maquenujinia, Egipto jiyajinia nojori quishacarijia. ");
INSERT INTO arlNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Na sequereeri: —Quia sanere. Mueya quia tacaretaarohua Israel jiyajiniohua na nucuataja. Mueya monu panijiacaari tari cusonuurucuaa. ");
INSERT INTO arlNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Joseeri sanequiaari. Mueya tacaretaquiaariuhua Israel jiyajiniohuara na nucuatajaari. ");
INSERT INTO arlNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Israel jiyajinia na tiuquishacari, Joseeri numootesaaquiaari Herodes niyanu Arquelaori jiyaniijia quiriquiaa jiyacari, na que niti Judea jiyajinia. Nocuaji, Joseeri puerequiaari quiniqui na quiniuria. Jiyacarijiuhuaj, Pueyasoori na niishitioquiaari na maquenujinia, tamocora na quianura. Naaratej, Joseeri mueya nucua pacuquiaari Galilea jiyajiniara. ");
INSERT INTO arlNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea jiyajinia nojori tiuquiijiosacari, Nazaret tiacajinia quishiiri. Naacuajitij, tariucuacaanu Pueyaso sequesano caminiujiuniaa sequesanoori tohuateequiaari nojori jaara naa naajiotaquiaaritij: “Jiyaniquishaanutaniyari Nazaret tiacajinijinio pueyano”. ");
INSERT INTO arlNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na nuhuaji, tamonu pueyanoori cariiquia jiyajinia quiquiaari Judea jiyajinia, Jordán moo shuriucua. Nojuajaari sesojosaaquiaari Tiuquinijiona Juan. Nojuajaari Pueyaso sequenu panishano poojotaquiaari pueya niquiara. ");
INSERT INTO arlNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Naa pohuataquiaaritij: —¡Nioojia nia tacatore sesa nia miiniujiniji! Pueyasoori tari nia jiyanooniu paniya, na muerasu nia quiniuria seetanujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jiyanohua tarijia, Pueyasoori na pueyano Isaías pohuataniquiaari miriqui na sequenu panishano pueyara. Isaíasri naa na pohuataquiaaritij: “Pueyano rupaari tojishaaree cariiquia jiyajinia. Naa nacajoriquiaari: ‘Nia jeecanamitiri Jiyaniijia nuu, maja mojoquetunu na quiniuria’”. Tiuquinijiona Juanjanaacuajaari nio tariucuacaanu pohuatasano tohuateequiaari, pueya na niishitiojosacari nojori jeenucuanura nojori jiuujia Jesuucuaji. ");
INSERT INTO arlNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Cuno Juan toqueeri camello cajacajiniji shitiasano quiquiaari. Na cajiniocua camarucutequiaari shoque sacuanijiasanoori. Na miaquesanoori quiquiaari cariiquia jiyajinia na riuriatasano sequeru, samiyatunio. ");
INSERT INTO arlNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pueyari Juancua quiojoquiaari na tojitianura. Queraatia pueyari nocua quiojoquiaari Jerusalén tiacajinijinio, Judea jiyajinijiniojuhuaj, puetunu Jordán moo shocuaqueyajinijiniojuanaanio. ");
INSERT INTO arlNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pueya jaara pohuataquiaari Juan niquiara sesa nojori miijiosano, Juanri nojori tiuquinijioquiaari Jordán moojinia, Pueyaso tojijiara nojori quiniu panishacari. ");
INSERT INTO arlNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Na tiuquinijiosacari pueya, Juanri queraatia Fariseocuaca niquiquiaari nocua nijiyano, Saduceocuacanio. (Nojoriiri Moisés Rootasanojiniji niishitiojonaa quiquiaari.) Tiuquinijiona Juanri nojori sequequiaari: —¡Niaaquiiri sesa pueya, juhua sacocua! ¿Cante nia numooteree nia mashiniuria Pueyaso saniitionuucuaji niajaniyani? Nio pa quishacarini, quera Pueyaso saniitiosacari jiyanohua na ruuretajaca pueya. ");
INSERT INTO arlNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Niaa jaara seetanujuanaa nioojia tacatore sesa nia miiniujiniji, ¡saaja maninia nia miiri, maja sesa! ");
INSERT INTO arlNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Majaari nia jiyaniniu niaari Pueyaso muerasu, Abraham niquiohuacuajinio supueno nia quiniuucua. Cua tojiri, Pueyaso jaara paniri, nojuajaari na naata Abraham niquiohuara shipininiu nio saijinijijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nio miriqui sequesano nia tojirijiuhuaj pueyanaa. Naana jaara maninia jajau muetuyaquiri, na camaruuri na nuya na catijiasocoriquiano. Naajuhuaj, Pueyasoori quera saniitionutaniya niajaniya, na tojiyashijiaca nia quiniuucua. Tiuquinijiona Juanri pueya sequequiaari socua: ");
INSERT INTO arlNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","—Janiyari moojinia nia tiuquinijiyani, nioojia nia tacatosacari sesa nia miishanojiniji. Cua nuhuaji, tamonuuri niriquiano cutara. Nojuajaari jiyanohua socua jiyaniijiajanaa janiyajiniji. Janiya maara jiyanohua shuquiriaatia quirini, nojuaja jaara cua sequere na seru cua quiniuria quenaaja na sapatu cua jocuanura nera. ¡Nojuajaari jiyaniijiajanaa cutara! Nojuajaari Pueyaso Sohuanu tiuquinijionutaniya nioojiajinia, cumaacaraca nia quiniuria, seetanu Pueyaso muerasujuanaa nia quiniuria. Nia jeequenutaniyajaariuhua juhua manitia, sesa nia miishanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nia tojitiare miriqui cua sequesano. Trigo jaara rapijiosaare maninia, na camaruuri na queyaroojua, jiyocuacaanuji na totinijiasocoriquiano. Naa miiquiaari paratu cuaara paara na cocua, na sucuanio, na jajau na racatanura tiajiniaaco. Naajuhuaj, cua nuhuaji niniaari tariucua pueca, na tojitianaa na rijionura na quiquiojiniara, saniniuujia na tojiyashijiaca na quejoonura manijinia na saniitionura, tee mani maquesaaquiyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na nuhuaji, Jesuuri tiuquiquiaari Galilea jiyajiniji Tiuquinijiona Juancua, Jordán moojinia. Tiuquinijiona Juan sequeseeri: —Cua tiuquinirijia. ");
INSERT INTO arlNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juanri saaja na sequeree: —Maja Jiyaniijianaa. ¡Quiaa cutaraari maninia pueyano! ¿Casaara cucua quia nimiaa cua tiuquininiuria quiajaniya moojiniani? ¡Cua tiuquiniri juhuari cutara! ");
INSERT INTO arlNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesuuri saa sequereejaa: —Quiarijia quia miiri cua panishano. Cua tiuquiniri naajaa. Maniniaari pa miiniuria puetunu Pueyaso panishanojuanaa. Naacuajitij, Juanri na tiuquiniquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesu jaara tiuquinishaaquiaari, nojuajaari ritia tacaquiaari moojiniji. ¡Jiyacaritij, jiya cajiniocuaari riatequee! Jesuuri Pueyaso Sohuanu niquiquiaari nocua roseyano juhua mococoonu niquishano. Nocua tiuushiiri. ");
INSERT INTO arlNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jiyacaritij, jiyocuacaanuji Pueyaso rupaari tojishaaree naa sequeyano: —Nioori cua Niyanuniyojua. ¡Na shuquiritiaa jiyanohuanijia! ");
INSERT INTO arlNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na nuhuaji, Pueyaso Sohuanuuri Jesu jiyataquiaari cariiquia jiyajiniara, Sesaaca saniniujiushocoriquiano cuniqui. ");
INSERT INTO arlNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Majaari quenaaja Jesu miaquenu quiquiaari. Cuarenta juuca, cuarenta niucua na shoconujuquiaari na miaqueyaquishacari. Na nuhuaji miaajequiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sesaacaari jiyacari nocua niquiaari na saniniujiuniuria. Jesu sequeseeri: —Quiaa jaara seetanujuanaa Pueyaso Niyanu quiri, nio sai quia jataniri panra. Quiocua na sarohua. ");
INSERT INTO arlNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesuuri saaja na riucuaree: —Maja. Pueyaso Rupaajiniacuajaari naa naajiotasano quiyatej: “Pueyanoori maja na naatanu saa miaquesanoocuaja. Seetanujuanaa saminio quiya cutaraari na tojishacari puetunu Pueyaso Rupaajanaa”. ");
INSERT INTO arlNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Na nuhuaji, Sesaacaari Jesu jiyataquiaari Jerusalén tiacajinia. Na nujuatequiaari jiyocuacaanuuri, Pueyaso Secojojua tia cacojiria. ");
INSERT INTO arlNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Na sequereeri: —Quiaa jaara seetanujuanaa Pueyaso Niyanu quiri, niiquiji quia jaataare jiyocua. Pueyaso Rupaajiniacuajaari naa naajiotasano quiya: “Pueyasoori na seya sequenutaniya na cojuanura quiajaniya. Nojoriiri quia quianutaniya, maja quenaaja saajiaacua quia jiriataaquiniuucuaji”. ");
INSERT INTO arlNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesuuri na riucuaree: —¡Maja! Pueyaso Rupaajinia, naa naajiotasanoori quiyajuhuaj: “Maja quia saniniujiuniu quia Jiyaniijia Pueyaso”. ");
INSERT INTO arlNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Na nuhuaji, Sesaacaari Jesu tacaniquiaari socua jiyanohua jiyaconaja tuhuananuucua. Cuniquiji na niquitirii puetunu jiya jiyaniijiacajanaari. Jiyanohua cumaacaraca quijiaca. Jiyanohua queraatia casamiriaca quijiacajuhuaj. Jiyanohua maninia niquishano. ");
INSERT INTO arlNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jesu sequereeri: —Janiyacua quia jiyatere jiyaniijiajanaara nojori nitini, quiaa jaara cua cariquimiaji mojoquetare quia shuquiritianura janiya, quia jiyaniijia cua quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesuuri na sequeree: —¡Niiquiji quia quiaare Satanásnaa! Naa naajiotasano quiyacuajaari Pueyaso Rupaajinia: “Saaja quia Jiyaniijia Pueyaso quia shuquiritiare cutara. Saaja nojuaja quia tojiri”. ");
INSERT INTO arlNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na nuhuaji, Sesaacaari na tarinitiaquiaari. Jiyacaritij, Pueyaso seyari Jesuucua niquiaari na mianuutenura. ");
INSERT INTO arlNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesu niishishacari Tiuquinijiona Juan nujuatesaarucuaa nujuatejojuajinia, nojuajaari Galilea jiyajinia quiaquiaariuhua. ");
INSERT INTO arlNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jesuuri Nazaret tiacajiniji pacuquiaari Capernaum tiacajinia na quiniuria, caminia shuriucua. Cuno jiya quiquiaari Zabulón niquiohuacuajinio supueno pueya jiya, Neftalí niquiohuacuajinio supueno pueya jiyanio. Zabulón, Neftalínio, nojoriiri supuetana Jacobo niquiohua quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesu quishacari cuno jiyajinia, naa tohuateequiaariiri taa tariucuacaanu Pueyaso sequesano caminiujiunia Isaías pohuataquiaari cuno jiyajinijicuajani. Nojuajaari naa pohuataquiaari Pueyaso niishitiosano nojuaja taa na nuhuaji na sequesano tohuateenutaniyani: ");
INSERT INTO arlNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulón pueya jiya, Neftalí pueya jiyanio, cunoori caminia shuriuquiumia neteja nucuama quiya, mariyata Jordán moo tamajiria. Cunoori mariyata Galilea jiya, tee taucuaca quiyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Cuno jiyajinia quiniaari ninishiqui quijiaca quiquiaari. Quiarijia saniniuujia, nojoriiri jiuujia Cuhuatana niquiriucuaa. Nojoriiri cusonu pueretujuaca quiquiaari tarijia. Quiarijia cutara nojoriiri cuhuatasaaree nojori puereyaquiniuucuaji”. ");
INSERT INTO arlNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jiyacaritij, Jesuuri Pueyaso rupaa pohuatanu coteequiaari. Naa sequequiaariiri: —Nioojia nia tacatore sesa nia miiniujiniji. Pueyasoori nia paniya na pueya nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesuuri Galilea caminia shuriuquioco rucuanejoriquiaa. Jiyacaritij, Pedro niquiriiri, tarajanu Andrésnio. Pedro sesa quiquiaarijiuhuaj Simón. Nojoriiri sapitiaaja ritianaa quiquiaari shiyaruta. Nojoriiri jiyacari shiyaru jaquerootariquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesuuri nojori sequeree: —¡Miji! Cua tarajare. Cua pueyara nia quiri. Janiyacua nia jiyatere pueya quioojuara saniniunijia, juhua sapitiaaja quioonaa. ");
INSERT INTO arlNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nojoriiri na shiyaru tiujiaquiaari ritia. Jesuta quiojiyareeri. ");
INSERT INTO arlNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesuuri shiitianiyojua socua rucuanequiaari na tacoji. Socua caapiqui pueya riuriataseeri. Nojoriiri quiquiaari Santiago, tarajanu Juannio. Cuno pojori queeri quiquiaari Zebedeo. Nojoriiri na queta quiriquiaa botejinia. Na shiyaru cushipirijionuuriquiaari. Jesuuri Santiago sequeree Juannio, na pueyara nojori quiniuriajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nojoriiri ritia bote tiujiaquiaari na queta, Jesuta na quiojonura. ");
INSERT INTO arlNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesuuri puetunu Galilea jiyajiniajanaa rucuanejoquiaari na saquiriojosano pueyata. Pueyaso secojojua tiacajiniaqueya niishitiojoriquiaari. Pueyaso rupaa pohuatariquiaari taa Pueyaso jiitianu paniya maninia na pueyani. Puetunu tamaatia cusonuunu jiitiacojuajanaa naatanijioquiaariiri. Puetunu nootunejaca pueyajanaa shaataquiaarijiaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Naa maninia na miishanoori poojotasaaquiaari puetunu Siria jiyajiniajanaa. Naaratej, pueyari Jesuucua patootaquiaari puetunu cusosuhuajanaa, puetunu tamaatia cusonu jiitiajacajanaanio, cumatacuruhuana cusosuhuajuhuaj, nootunejacanio. Nocua jiyatasaaquiaarijiuhuaj samaruhuaraca quijiaca, canashiyaquiji cusojonuujuacanio. Jesuuri nojori naatanijioquiaari puetunujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jiyanohua queraatia pueyari Jesu nuhuajiquiaari Galilea jiyajiniji, Decápolis tiacajinijinio. Na nuhuajiquiaarijiuhua Jerusalén tiacajinijinio, Judea jiyajinijiniojuhuaj, mariyata Jordán moo taquijiria jiyajinijinionio. ");
INSERT INTO arlNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesu niquishacari jiyanohua queraatia pueya nocua niyano, nojuajaari tuhuananuucua tacaquiaari tiji na cajiniuria. Na saquiriojosano pueyari nocua catecanoquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesuuri nojori niishitiojonu coteequiaari. Naa na pueya sequereeri: ");
INSERT INTO arlNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Shuquiriaatia quijiaca cutaraari noo pojori, canapuete niishiyani noojia sesa quiya. Nojoriiri Pueyaso pueyara quiriquiano, pueyaracaanu na jiitianura nojori. ");
INSERT INTO arlNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Shuquiriaatia quijiaca cutaraari noo pojori canapuete taraatia quiyani sesa na miiniuucua. Pueyasoori nojori cumanijianutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Shuquiriaatia quijiaca cutaraari noo pojori, canapuete maja tama nerajaaja niishiriojojuacani. Nojoriiri nio jiya camaruhua quiniutianiya, taa Pueyaso sequequiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Shuquiriaatia quijiaca cutaraari noo pojori, canapuete maninia quiniuucua jiaatiaa jiyanohuani, taa pa jiaatiaacuaa miaquenuucuani. Pueyasoori maninia quijiacara nojori jiyatenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Shuquiriaatia quijiaca cutaraari noo pojori, canapuete naquiya miishanoocua taraajejani. Pueyasoori nojoriicua taraajenutaniyajaacuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Shuquiriaatia quijiaca cutaraari noo pojori canapuete maninia jiuujiaracani. Nojoriiri Pueyaso niquiniutianiya cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Shuquiriaatia quijiaca cutaraari noo pojori, canapuete pueya jiyanootiootejani. Nojoricuajaari Pueyaso muerasu quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Shuquiriaatia quijiaca cutaraari noo pojori, canapuete naquiya miishanoni, Pueyaso panishano nojori miiniuucua. Pueyasoori nojori jiitianutaniya pueyaracaanu shuquiriaatia, na muerasu nojori quishacari. ");
INSERT INTO arlNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Shuquiriaatia quijiaca niajaniya, tamasaca jaara nia macaatiri cua tojitiajaca nia quishacari, naajuhuaj, nojori jaara miya naquiya niajaniya. Naajuhuaj, niaari shuquiriaatia quijiaca, nojori jaara saquiriojotare niaacuara na sapojonuta, maninia nia tojiniuucua janiya. ");
INSERT INTO arlNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Niaa jaara naa miishaaretej, jiyanohua nia timiquiore. ¡Shuquiriaatia nia quirijiuhuaj! Pueyasoori cunora jiyanohua maninia nia miiniutianiya jiyocuacaanu nia quishacari nata. Tariucuacaanu Pueyaso sequesano caminiujiuniaacuajaari naa naquiya miishaaquiaarijiuhuaj, nia supueyaquishaacarijiyojua. ");
INSERT INTO arlNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Mijiria, niaari juhua shoni quiya, mijiria quiniaa mariqui socua seseyareeri. Shoni jaara na tiquiriiquia jatama, ¿maatucua taa tiquiriiquiara quiriohuani? Maja na naata. Shoni jaara naa quiritij, najuhuana quiyari, shaaca. Jiyano shoni cuaara jatasaaria nuujinia, pueya rapijiosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Naajuhuaj, niaari juhua ninishiqui cuhuatana mijiria quiniaara. Tiaca jaara tuhuananuucua quiri, majaari na naata na jamaaniu. ");
INSERT INTO arlNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Naajuhuaj, pueya jaara samaritiu noshitiri, jiyocuacaanu morotashiyari, tiaco na cuhuatanura maninia, pueya niquiniuria maninia nocuaji. Majaari samaritiu niatasaanu conatu cariquiaco. ");
INSERT INTO arlNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Naajuhuaj, niajaniya cuaara maninia miiria pueya niquiara. Maninia nia miishacari, niaari pueya cuhuataa juhua samaritiu. Naa maninia miijia nia quishacaritij, pueyari Jiyocuacaanu Quijia nia Que Pueyaso maniniuhuaqueetanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Majaari nia jiyaniniu janiyari niquiaarini Moisés Rootasano cua tarinitiniuria niajaniya, Pueyaso sequesano caminiujiuniaa rootasanonio. Maja. Niquiaari cutaranijia puetunu cuno rootasanojuanaa cua tojiniuria, cua tohuateenurajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pueyanaa, seetanujuanaa nia sequeyanijia. Nio jiya quishacarijia, jiya cajiniocuanio, majaari quenaaja niquiriyatu naashanoniyojua Pueyaso Rupaajiniji shaajetesaanu quiniutianiya. Majaari na shaajetesaanu quiniutianiya puetunu Pueyaso naajiotesanojuanaa cuaara tohuateerejaatijia. ");
INSERT INTO arlNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Naaratej, tamonu pueyano jaara jiyaniri tamonu rootasano tariucuacaanu Pueyaso Rupaajiniji najuhuana sequesano, nojuajaari cocuaatia miya. Nojuaja jaara cuno tariucuacaanu rootasano tojiyaquiri, cuno pueyanoori socua rerequetesano quiniutianiya narta Pueyaso muerasujinijinio. Naajuhuaj, nojuaja jaara pueya niishitiojore nojori tojiyaquiniuria cuno rootasano, cuno pueyanoori socua rerequetesano quiniutianiya puetunu narta Pueyaso muerasujinijijianaa. Saniniuujia, cante tariucuacaanu Pueyaso rootasano tojiquiaanijia, na niishitiojoquiaa tamasacajaariuhuaj, cuno pueyanoori socua tojishano pueyano quiniutianiya Pueyaso shuriucua jiyocuacaanu. ");
INSERT INTO arlNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nia numooteyanijia, niaa jaara quiyaquiri socua maninia quijiaca Fariseocuacajiniji, Moisés Rootasano niishitiojonaajinijinio, majaari Pueyaso muerasu nia quiniu quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Niaacuajaari tojiquiaari taa pa supuetanaa sequesaaquiaaricuajani: “Maja monu. Cante pueyano monani, nojuajaari nequesoreesaanutaniya”. ");
INSERT INTO arlNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Janiyari saniniuujia nia niishitiojiyani, cante narta pueyanota juaajiani, cunoori nequesoreesaanutaniya. Naajuhuaj, cante narta pueyano saarijiojuani, cunoori nequesoreesaanutaniya jiyaniijianucua niquiara. Naajuhuaj, cante narta pueyano sesacareeni, cunoori quera jatashiya mani quiquiojinia, pueyaracaanu saniitiosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Naacuajitij, nia niquitionu panishacari Pueyasora nia casaa, niaa jaara jiyacari niishiquii, quiaari quiarta pueyano juaatiriucuaa quiocuara, ritia quia tiujiare cuniqui quia niquitiosocoriquiano Pueyasora, catijiaja shuriucuani. ");
INSERT INTO arlNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Quiarta pueyanota quia jiyanootioocoocuara coteenu. Na nuhuaji cutara quia naata niquitionu quia casaa Pueyasora. ");
INSERT INTO arlNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Tamonu jaara quia jiyataa nequesoreenaacua, sesa quia miiniuucua nojuaja, maninia quia pohuatare ritia nojuaja, taa quia miiniutianiyani na jiyanooniuria quiajaniya. Ritia nia jeecatoore nucuaco nia quiasacarijia, quiaa mariqui nequesoreena niquitiosaareeri. Nequesoreena naasucuaari quia niquitionutaniya nujuatejojua camarnu saniniuujia. Nojuajaari quia nujuatenutaniya nujuatejojuajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Seetanujuanaa nia sequeyanijia, majaari quia tohuatanu quiniutianiya, quiaa cuaara niquitiorejaatijia puetunu na sequesano cumaneecajanaa quia cumaneecajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Niaacuajaari tari tojiquiaari nio tariucuacaanu rootasano: “Maja tamonu niquiocua numuetucunu”. ");
INSERT INTO arlNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Janiya cutaraari nia sequeyani, pueyano jaara na camishoo maaji niquiri nocua na jiaatianuta, cunoori juhua na numuetucuree tari noojiajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na nuhuaji, Jesuuri nio miriqui sequesano sequequiaari pueyara, jiyanohua na niishitiojonura nojori: —Naaratej, quia miaquetajara quia namijia jaara sesa miitiri quiajaniya, quia namijia quia jiatere. Tamocora quia jatare. Quiajaniyara socua maninia cutaraari namijiijiu quia quiniuria, maja quia jatasaanura mani quiquiojinia puetunu quia cuaqueyatajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Naajuhuaj, quia miaquetajara quia numatu jaara quia miitiri sesa, quia jiyatarenoj. Tucuacaanu quia jatare. Socua maninia cutaraari quiara quia jiyatanura quia numatu, maja puetunu quia cuaqueyatajanaa quia jatasaanura manijinia, pueyaracaanu quia miiniuria naquiya tii. Naa na pohuatasacaritij, Jesuuri pa niishitiojiya maja pa tojiniuria poojia panishano, sesa na miitiniuria pa cuaqueya. ");
INSERT INTO arlNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesuuri naa niishitiojoquiaarijiuhuaj: —Pa supuetanaari naa rootasaaquiaarijiuhuaj: “Pueyano jaara necocua cartere, maaji cuaara niquitiosaaria naajionee, pueya niishiniuria neyacaqui na carteree”. ");
INSERT INTO arlNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Janiyari saniniuujia nia sequeyanijia, pueyano jaara necocua cartere, sesa miya Pueyaso niquiaraari. Naacuajitij, na cartesano maajiiri tamonuta quiniutianiya na nuhuaji. Cunoori sesa Pueyaso niquiara. Pueyano jaara niishiri necocuaari tamonu caya numuetucujutequiaa, saa cunoraja cutara na naata na cartenu. Pueyanoori sesa miyajuhuaj, jaara cartesano maaji camiri. ");
INSERT INTO arlNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Niaari tarijia tojitiaquiaari taa pa supuetanaa rootasaaquiaarini. Naa rootasaaquiaariiri: “Majaari nia jatanu nia sequesano, niaa jaara sequere: ‘Seetanujuanaari cua sequesano. Pueyasocuajaari niishiya majaari cua sapojonu’”. ");
INSERT INTO arlNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Janiya cutaraari nia sequeyani, nia sequesano jaara seetanujuanaa sequesano quiri, saaja nia sequere “jaa”. Jaara seetanujuanaa quiyaquiri nia sequesano, saaja nia sequere “maja”. Majaari nia sequesano nia maatenu najuhuana naatej: “¿Janiyate sapojojuani? Cua rupaari juhua jiya cajiniocua. Maja na jatanu quiniutianiya”. Majaari naa sequenutej pueyanaa. ¿Majateeri nia niishiniu, jiya cajiniocuaari Pueyaso quiquio? ");
INSERT INTO arlNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Naajuhuaj, ¿casaara nia sequequiaa najuhuanani: “Cua sequesanoori juhua pa jiya? Majaari na shaajenu quiniutianiya”. Maja naa sequenutej. Pa jiya, cunoori Pueyaso niaja na niohuaca. Naajuhuaj, ¿casaara nia sequequiaani: “Cua sequesanoori juhua Jerusalén tiaca? Pueyaracaanu quiniutianiyari”. Maja naa sequenutej. Jerusalén tiacaari pa Jiyaniijia Pueyaso tiaca. ");
INSERT INTO arlNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Naajuhuaj, ¿casaara nia sequequiaa naa najuhuanani: “Quia naataari cua sequesanoocua tiuuniu, cua naca quishacarijia”? Majaari naa sequenutej pueyanaa. Niaa jaara naa sequeretej, nia niishiri, majaari nia naata quenaaja niquimi nia muesujinijinio nia jiyatenu taariuria, muerumuecaranio. ");
INSERT INTO arlNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Naaratej, pueyaracaanu saaja seetanujuanaa nia sequere “jaa”, “maja”. Cante na sequesano maatejani, cunoori Sesaaca niishitiojosano niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Niaacuajaari tari rootasaaquiaari: “Pueyano jaara tamonu pueyano namijia cocuartare, na namijia cuaara cocuartasaariajuhuaj, pueya nequesoreenaa niquiara. Naajuhuaj, pueyano jaara tamonu pueyano quiaja shaatare na pishacari, na quiaja cuaara shaatasaariajuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Janiyari saniniuujia nia sequeyani, pueyano jaara quia miiniu paniri sesa, quia cuaqueya quia tarinitiare nera. Majaari na nujuatanu. Naacuajitij, pueyano jaara quia maseca piri, majaari juaaniu. Quia jiyanoori. Nojuaja jaara socua quia piriohua, quia jiyanoori. Majaari na naminiu. ");
INSERT INTO arlNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pueyano jaara quia toque jaariutianu paniri, nera quia tarinitiare. Cuaara na paara. Mariyata quia cushishano shiniquiaacuaji quia niquitiore nareja. Majaari jamueja quia quiniu. ");
INSERT INTO arlNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tamonu camarnu jaara quia sequere na naacutanura na casami quia jatanura nuu cajiniocua, majaari na tarijionu. Saniniuujia, shuquiriaatia quia naacutare na casami jatanura socua tucuacaanu na sequesanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tamonu pueyano jaara quia casami masenu paniya nera, quia niquitiore nareja. Naajuhuaj, tamonu pueyano jaara quia casaa panu paniya nareja rupaquijiara, quia niquitiore. Majaari na ruuretanu. Capora quia quiri. ");
INSERT INTO arlNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Niaacuajaari nio tariucuacaanu sequesano tojitiaquiaarijiuhuaj: “Quia shuriucua quinia quia paniri. Saniniuujia, majaari quia paraca quia niquiniu”. ");
INSERT INTO arlNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Janiya cutaraari nia sequeyani, nia paraa nia paniri. Nia sesacaja pueya nia maniniuhuaqueetare pueya niquiara. Pueyano jaara niaacuara saquiriojotare na sapojonuta, nocuara nia secojore Pueyaso. Sesa nia miiniaacuara nia secojorejuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Naa maninia nia miishacaritij, niaari seetanujuanaa jiyocuacaanu Quijia nia Que Pueyaso muerasu quiniutianiya. Nia niishiri, Pueyasoori pananu muetaniquiaa sesa pueyara na janura, maninia pueyara na janurajuhuaj. Pueyasoori maru nitiquiaa maninia miijiaca pueyara, sesa miijiacarajuhuaj, maninia nojori nataacuaca moritianura. ");
INSERT INTO arlNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Niaa jaara saaja nia panijiaca pueya panijia quiriquia, ¿Pueyasoteeri cunora nia shuquiritianutaniya, socua na casaajiniji na niquitionura niajaniya? Maja. Sesa miijiaca pueyani, noo pojori canapuete cumaneeca masejoquiaa na sapojonutani, nojoriiri maninia miiquiaa na panishano pueyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Niaa jaara saaja nia panishano pueya saruhuataquiaa, ¿niaateeri cunora maninia miijiaca quiya Pueyaso niquiara? Maja. Pueyaso niishiyashijiaca pueyari naa maninia miiquiaa na panishano pueyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Naaratej, maninia miijiaca nia quiri juhua jiyocuacaanu Quijia nia Que Pueyaso. Nojuajaari seetanujuanaa maninia miijia. Rimiajata miyashijia cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Tama nia cuaqueyajaaja nia cojuare maja maninia nia miiniuria saaja pueya niquiara, pueya maniniuhuaqueetanura niajaniya. Pueya jaara nia maniniuhuaqueetare maninia nia miiniuucua, nia Que Pueyasoori maja na niquitionu quiniutianiya niajaniya socua, maninia nia miiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Naaratej, niaa jaara casamiijiuniucua pueya niquitionu paniri nareja nia casamijiniji, majaari juhua sesa jiuujiaraca pueya nia miiniu. Cuno pojoriiri pueya numootequiaa na niquitionu panishacari na casaa, puetunu pueyajanaa shootianura nojori. Cuno pojoriiri naa miiquiaaqui Pueyaso secojojua tiacajinia, tiacaacacojuhuaj, pueya maniniuhuaqueetanura nojori. Seetanujuanaa nia sequeyanijia, cuno pojoriiri tari maseree narta pueya maniniuhuaqueetanu. Majaari nojori masenu quiniutianiya socua Pueyasojiniji naa maninia nojori miiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Saniniuujia, niaa jaara nia casaajiniji casamiijiuniucua niquitionu paniri nareja, quia mueneca cuaara niishiyaquiiria quia niquitiosano quia miaquetajata. ");
INSERT INTO arlNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Naa miriqui sequeree niajaniyanijia cua niishitiojonura niajaniya, jiyasohuaja nia miiniuria puetunu maninia nia miiniu panishanojuanaa. Naacuajitij, saaja nia Que Pueyasoori jiyasohuaja maninia nia miishano niishiniutianiya. Naaratej, nojuacuajaari nia niquitionutaniya na casamijiniji, na shuquiritiasacari niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Nia secojosacari Pueyaso, majaari juhua sesa jiuujiaraca pueya nia miiniu. Cuno pojoriiri Pueyaso secojonu maniniucuaquiaa na nujuanuta pueya niquiara, saaja pueya shootianura nojori. Nojoriiri naa secojonuuquiaa Pueyaso secojojua tiacajiniatej, tiaca nuucuajiniajuhuaj, tee queraatia pueya quiyacuajani. Seetanujuanaa nia sequeyanijia, cuno pojoriiri tari maniniuhuaqueetasaareecuaja. Jiyano pueyatej, majaari nojori masenu quiniutianiya socua Pueyasojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Niajaniya saniniuujia, nia secojosacari Pueyaso, nia sohuacamara nia tiuquiri. Nia tiootiu nia tiore. Na nuhuaji, cuniqui nia Que Pueyaso nia secojore jiyasohuaja tamajaaja. Nia Que Pueyaso niquishacari naa jiyasohuaja nia miishanotej, nojuaja cutaraari nia niquitionutaniya na casamijiniji, na shuquiritiasacari niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Nia secojosacari Pueyaso, majaari nia sequesano pacutejojua nia quiniu puera, juhua Pueyaso niishiyashijiaca. Cuno pojoriiri jiyaniya Pueyasoori nojori tojiniutianiya pueyaracaanu na pacutejosacari tariucua na sequesano. ");
INSERT INTO arlNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Majaari juhua nojori nia miiniu. Pa secojiyaquishaacarijiyojua, pa Que Pueyasocuajaari tari niishiya casaa pa paniyani. ");
INSERT INTO arlNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Naaratej, naate nia secojore: “Canaa Quenaa, quiaa cutaraari jiyocuacaanu Quijia. Pueya cuaara niishiiria quiaari saaja maninia quijia. ");
INSERT INTO arlNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Quia quiri canaa Jiyaniijia, canaa quia jiitianura. Quia panishano cuaara miishaaria mijiria, taa jiyocuacaanu na miishaaquiaacuaani. ");
INSERT INTO arlNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Canaa quia niquitiore canaa miaquesocoriquiano quiarijiani. ");
INSERT INTO arlNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Canaa quia jiyanoori sesa canaa miishanojiniji, taa canaa jiyanooquiaa tamasacacuaani, sesa nojori miishacari canaa. ");
INSERT INTO arlNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Majaari canaa quia shanacunu canaa saniniujiushaanura sesa canaa miiniuria. Saaja canaa quia cojuare cutara Sesaacaacuaji. Saaja quiajaniya cutaraari seetanujuanaa Jiyaniijiajanaa. Quiaa cutaraari puetunu cumaacaracajanaa. Quiaari shanohua shacantuuca quijia cutara. Quiaari naa quijia pueyaracaanutej. Tariucuaja”. ");
INSERT INTO arlNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Naatej, niaa jaara jiyanoori tamasaca, sesa na miishacari niajaniya, nia Que Pueyasoori nia jiyanooniutianiyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Saniniuujia, niaa jaara tamasaca jiyanoyaquiri, nia Que Pueyasoori maja na jiyanooniu quiniutianiya niajaniyajuhuaj sesa nia miishanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Niaa jaara miaqueyaquiya Pueyaso nia secojonura, majaari macuhuajeconu pueya niquiara, taa sesa jiuujiaraca pueya miiquiaacuaani. Nojoriiri naa miiquiaatej, pueya niishishocoriquiano nojori miaajeya. Naa pueya shootiasacari nojoritij, seetanujuanaa nia sequeya cutaranijia, narta pueyari tari nojori maniniuhuaqueetareecuaja. Majaari Pueyasojiniji nojori masenu quiniutianiya socua. ");
INSERT INTO arlNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Niajaniya saniniuujia, nia miaqueyaquishacari Pueyaso nia secojonura, nia jiquioco nia jeequere. Nia canuure nia muesu, taa nia miiquiaa pueyaracaanucuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Naa nia miiri Pueyaso nia secojosacari, maja pueya niishiniuria cunoqui miaajeya. Saaja pa Que Pueyaso cutara cuaara niishiiria nia miishano. Naacuajitij, nojuajaari nia niquitionutaniya na casamijiniji na shuquiritianuucua niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Pueyanaa, maja mijiria nia racatanu nia casami najuhuanaj. Saaja capora nia quiri cutara. Mijiria pa racatasacari pa casami, surequeyari na miaquenutaniya. Tiyarashiniutianiyajaariuhuaj. Nohuasenuujuacaari nocua tiuquiniutianiya na nohuasenura. ");
INSERT INTO arlNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nia racatare cutara nia casami Pueyaso shuriucua jiyocuacaanu. Tii cutaraari shaaqui surequeya, shaaqui tiyara. Naajuhuaj, nohuasejojuaari maja na naata nocua tiuquiniu tii, jiyocuacaanuji nia casami na nohuasenura. ");
INSERT INTO arlNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Niaa jaara nia casami racatare mijiria, niaari nocua niishiriojonutaniya pueyaracaanu. Nia casami jaara racatasano quiri Pueyaso shuriucua saniniuujia, niaari Pueyasoocua niishiriojonutaniya. Majaari nia tacaaniu quiniutianiya mijiria casaacua tari. ");
INSERT INTO arlNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Pa namijiaari juhua poojia cuhuatana. Naacuajitij, paa jaara sesa casaacua jiaatiaashijia quirini, poojiaari juhua cuhuashiqui quiya maninia. ");
INSERT INTO arlNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Niaa jaara sesa casaacua jiaatiajaca quiri saniniuujia, nioojiaari juhua ninishiqui quiya. Nioojia jaara sesa casaacua jiaatiaja quiri, nioojiaari socua ninishiqui quiya cariyojuaru pueyanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Maja nia naata poonijionu maninia caapiqui camarnura. Niaa jaara caapiqui camarnuraca quiri, niaari tamonu paniniutianiya, niaari saniniuujia tamonu niquiniu paniyaquiniutianiyacujua. Naacuajitij, niaari shuquiriaatia poonijionutaniya nia panishano camarnura. Niaari tamonu soojotanutaniyacujua. Naajuhuaj pueyanaa, majaari nia naata Pueyasora poonijionu maninia, cumaneecaacua nia jiaatiasacarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Naaratej, nia sequeyanijia, maja puera nia niishiriojonu casaa nia miaquenutaniyani, casaa nia ratunutaniyani, casaa nia cushiniutianiyani. Pueyaso jaara pa shipiniquiaari pueyano pa quiniuria, ¿majateeri na niquitionu quiniutianiya pa miaquenu panishano, pa cushiniu panishanonio, maninia pa rishiniuria? Taaquiriirinij. ");
INSERT INTO arlNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jiyocuacaanu jaacuatujuaca nia niquiricuaa. Nojoriiri maja na natanu. Majaari na senoonu. Majaari nojori mishinijionu tiaco na miajajaura. Naajaa, pa Que Pueyasoori nojori niquitioquiaa na panishano. Nia niishiri. Niaa cutaraari socua Pueyaso panishano cuno jiyocuacaanu jaacuatujuacajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Nia naatate socua jiyaconajara maashiniu, jiyanohua nia tacaaniutia? Maja. ");
INSERT INTO arlNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Naajuhuaj, ¿casaara nia tacaaquiaarini nia niishiriojosacari casaa nia cushiniutianiyani? Naana shuucuaca nia niquiriquiacuaa. Nojoriiri maja na niishiniu poonijionu. Majaari na niishiniu na maniniushitiajara shitianujuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Seetanujuanaa nia sequeyanijia, pa supuetanaa jiyaniijia Salomónri jiyanohua shanohua toqueya cushijia quiquiaari. Naajaa, na toqueeri maja socua shanohua niquishano quiquiaari cuno naana shuucuacajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Naana shuuri saaja rupaquijia shanohua niquishano. Jaara sorere, namitiashiyari catijiasocoriquiano. Pueyasoori naana shuu shipiniquiaari saaja rupaquijia shanohua niquishocoriquiano, na nuhuaji catijiasocoriquianonio. Nojuaja jaara naa shanohua naana shuucuaca shipiniquiaari, ¿majateeri socua maninia na miiniu quiniutianiya niaara? ¿Casaara nia tiuyaquiya nia Que Pueyasoocuaarini? ");
INSERT INTO arlNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Naaratej pueyanaa, maja nia tacaaniu. Majaari nia sequenu: ¿casaa pa miaquenutaniyani?, ¿casaa pa ratunutaniyani?, ¿casaa pa cushiniutianiyani? ");
INSERT INTO arlNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pueyaso niishiyashijiacaari naa sequejacatej, puera nojori tacaashacari puetunu na panishano casaacuajanaa. Niaa cutaraari jiyocuacaanu quijia Queraca. Nojuacuajaari tari niishiya puetunu nia panishanojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Naaratej, coteenu nia niishiriojore Pueyaso tojijiara nia quiniuria cutara. Pueyasocua nia niquitiore puetunu nia panishanojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Naajuhuaj, majaari tariquiria nia tacaaniu. Saaja nia niishiriojore cutara, taa nia miiniutianiya maninia quiarijiani. Tariqui cutara niocua niishiriojore taa nia miiniutianiya maniniani. Tariucuaja quiarijia nia niishiriojosano nio juucara. Majaari socua tariquiria nia tacaaniu. Saaja nia Que Pueyasoocua nia tiuuri, juhuajaniya nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Maja niarta pueyano nia soquenu najuhuanaj, Pueyaso mariqui nia jiyanoyaquirijiaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Taa nia sesacaquiaa tamasacacuaani, niaari naa sesacasaanutaniyajuhuaj. Naatej, taa nia miiquiaa tamasacacuaani, Pueyasoori mariyata naa miiniutianiya niajaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nio miriqui cua sequesano nia tojiri. ¿Casaara nia niquiya rucucua nia tarajanu namijiajiniani, niaa jaara puereetuuca maca jiitiaa tama nia namijiajiniajaaja cutara? ");
INSERT INTO arlNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Maca nia jiitiasacari tama nia namijiajiniajaaja, ¿casaara nia sequeya niarta pueyanoni: “Cuno rucucua pa taquiri quia namijiajiniji”? ");
INSERT INTO arlNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sesa jiuujiaracanaa, coteenu nia pare cuno maca nia namijiajiniji cutara. Na nuhuaji niocua maninia niquiri cutara, nia tarajanu rucucua nia taquiniuria na namijiajiniji. Nio miriqui cua sequesanoori nio sequeya: nioojia seque nia jeecare coteenu, na nuhuaji cutara niocua maninia nacasure niarta pueyano. ");
INSERT INTO arlNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Majaari Pueyaso ruuretajaca nia niishitiojonu Pueyaso rupaa najuhuanaj. Cuno tojiyashijiacaari nia tojiyaquiniutianiya, naatej taa tamonu pueyano sare tojiyaquiquiaa niajaniyacuaani. Majaari Pueyaso soojeaca nia pohuatanu Pueyaso miishano shanohua niajaniyara. Nojoriiri saaja rerequetenutaniya Pueyasojiniji nia pohuatasano, naatej taa cushiya rapijioquiaa marajinia juhuajaniya na niishishoo maninia casaacuaani. ");
INSERT INTO arlNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Pueyaso nia secojore. Nojuajaari nia niquitionutaniya nia masesano. Niaa jaara pajere, niaari nia pajesano riuriatanutaniya. Tohuateyaji nia piquiri, niaacuajiiri riatasaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Cante Pueyaso maseya na panishanoni, seetanujuanaa na masenutaniyari. Naajuhuaj, cante pajejani, na panishano riuriatanutaniyari. Cante tohuateyaji piquijiani, nocuajiiri riatasaanutaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Mueya jaara na que nenecojore neecaruura, ¿na queteeri na niquitionutaniya saajia? ¡Maja! ");
INSERT INTO arlNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mueya jaara na que nenecojore sapitiaajara, ¿na queteeri na niquitionutaniya soconu? ¡Maja! ");
INSERT INTO arlNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Niajaniyari sesa miiniu niishijiaca. Naajaa, niaacuajaari maninia casaa niquitionu niishijia, nia mueya jaara nia nenecojore. Nia Que Pueyaso cutaraari jiyanohua socua maninia niquitionu niishijia, na muerasu secojosacari nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Pueyaracaanu maninia nia miiri tamasaca, taa nia paniquiaa pueya miiniuria niajaniyacuajani. Niaa jaara maninia miiriquia nio cua sequesano, niaari tari tojitiaa maninia puetunu tariucuacaanu Moisés Rootasanojuanaa, tariucuacaanu Pueyaso sequesano caminiujiuniaa rootasanonio. ");
INSERT INTO arlNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Pueyasoocua neteja nuu nia pajere, shiitianiyojua nuuri tuneya. Saniniuujia, puereetuuca nuuri neteya mani quiquiojiniara. Puereetuuca na tuneja. Puereetuucaari neteya, cariyanujuhuaj. Naaratej, queraatia pueyari juhuajaniya cuno nucuaco quiojiya saniitiosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Saniniuujia, shiitianiyojua nuuri maninia cutara. Cuno nucuaco quiojonaari pueyaracaanu quiniutianiya Pueyasota cutara. Jiyanohua shiitianiyojuaari cuno nuu tuneja. Secaja pueyari na riuriataa, cami na quiojonura. ");
INSERT INTO arlNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Tama nia cuaqueyajaaja nia cojuare sapojonuujuacaacuaji, noo pojoriicuaji canapuete najuhuana sequejacuajani: “Pueyaso Rupaa pohuatananijia”. Nojoriiri sapuenu juhua maninia pueya niquishano, nojori sapojonura niajaniya. Nojoriiri sapuenu juhua borregoniyojua niquishano, seetanujuanaa juhua puereeta sare nojori quishacari, sayoru. ");
INSERT INTO arlNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Niocua nojori niishiri, sesa nojori miiniuucua. Nojoriiri maja na naata miiniu maninia, naatej taa cohuatucuaani, majaari na naata muetunu marijiaca. ¿Shuuniateeri na naata muetunu cohuajaru? Maja. Naajuhuaj, cuno sesa jiuujiaraca pueyari maja na naata maninia miiniu. ");
INSERT INTO arlNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Maninia naanaari, maninia jajau muetujua cutara. Saniniuujia, sesa naanaari, sesa jajau muetujuaaja. ");
INSERT INTO arlNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Maninia naanaari maja na naata sesa jajau muetunu. Naajuhuaj, sesa naanaari maja na naata maninia jajau muetunu. ");
INSERT INTO arlNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Naana jaara sesa jajau muetujua quiri, nushiyari, manijinia catijiasocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Naacuajitij, niocua cuno sapojonuujuaca pueya niishiri nojori miishanojiniji sesa. ");
INSERT INTO arlNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Cuno pojori canapuete cua sequejacani: “Cua Jiyaniijianaa, cua Jiyaniijianaa”, noojiaqueya nojorijinijinioori maja nojori tiuquitianu quiniutianiya cua Que Pueyaso quiquiojinia. Saaja seetanujuanaa cua Que tojitiajaca cutaraari nocua tiuquitianutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cua nequesoreesacari pueya nio jiya puequesacari, queraatia pueyari cua sequenutaniya: “Cua Jiyaniijianaa, cua Jiyaniijianaa, canaacuajaari quia rupaa pohuataquiaari pueya niquiarani. Canaa sequesacari quia sesa, canaari samaruhua tohuatanijioquiaari quia cumaacatani. Naajuhuaj, canaari cusosuhua naatanijioquiaarini quia sesa canaa jiyaniquishacari”. ");
INSERT INTO arlNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Janiyari saniniuujia naa sequejaca riucuanutaniyani: “Maja cua niishiniu niajaniya. ¡Nia quiojorohua! Niaari saaja sesa miijiaca quiquiaari”. ");
INSERT INTO arlNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Naacuajitij, cante cua sequesano tojijiani, cuno pueyanoori shuquiriaatia quiniutianiya juhua niishijia pueyano. Niishijia pueyanoori tiaquiaari cumueeca jiyajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na nuhuaji, maruuri jiyanohua niquiaari. Moori pajaashiquiaari. Paratuuri jiyanohua piyarojoquiaari cuno tiaacuara. Naajaa, majaari na pojoretanu quiquiaari, cumueeca jiyajinia na nujuatasacari. ");
INSERT INTO arlNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Cante cua sequesano tojiyashijia saniniunijia, cunoori moseeca. Cua sequesano ruuretajaari taraatia quiniutianiya juhua moseeca pueyano. Moseeca pueyanoori jaaquiajinia tiaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Maruuri jiyanohua niquiaari. Moori pajaashiquiaari. Paratuuri jiyanohua piyarojoquiaari cuno tiaacuara. Cuno pueyano tiaari pojotaquiaari. Na camaruuri jiyanohua taraatia quiquiaari na tia pojotasacari. ");
INSERT INTO arlNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesu jaara niishitiojonu puecaquiaari, pueyari jiyanohua jiuujiateriquiaa na niishitiojosano nojori tojishacari. ");
INSERT INTO arlNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pueyari naa jiuujiatequiaari seetanu cumaacatajanaa Jesu niishitiojosacari juhua jiyaniijiajanaa, maja juhua Moisés Rootasanojiniji niishitiojonaa. Cuno pojoriiri nareja tariucuacaanu rootasano caminiujiuquiaari pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesu jaara tuhuananujiniji rosequiaariuhua na cojiniaata, jiyanohua queraatia pueyari na nuhuajiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tamonu pueyano cusosuuri jiyacari Jesuucua catecanoquiaari. Jiyanohua sesa cusonu jiitiaquiaariiri. Tahue rupaajinia, cuno cusonu sesaari quiquiaari “lepra”. Pueyano shuuri juhua miaquesano quijia na cuaqueyajinia cuno cusonu na jiitiasacari. Cusosuuri Jesu cariquimiaji mojoquetaquiaari Jesu na sequenura na panishano. Naa na sequereeri: —Jiyaniijianaa, quia jaara paniri, niishiyacuajanijia quia naata cua cusonu cushiriitiniu. ");
INSERT INTO arlNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesuuri nocua taraajequiaari. Nocua niaree na juaashiquiaari. Na sequereeri: —Jaa, paniyanijia. Cuaara cushiriiria quia cusonu. ¡Jiyacaritij, ritia cushiriiquiiri! Jeequerohuari. ");
INSERT INTO arlNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na nuhuaji, Jesuuri naa na rootaquiaari: —Cua tojiri. Maja tamasaca niquiara quia pohuatanu cua miishano quiajaniya. Saaja Pueyaso secojonaa jiyaniijia quia cuaqueya quia niquitiri, na cartenura quiajaniya, pueya tajinia quia rucuanejonuhuara juhuajaniya. Na nuhuaji, ritia quia niquitiore quia seru Pueyasoocuara catijiasocoriquiano. Naa quia miiritij taa Moisés niishitiojoquiaari tarijiacuajani, juhua jeequesano quia quiniuria Pueyasora. Naacuajitij, pueyari niishiniutianiya quiaari tari jeequerohua quia cusonujiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesu jaara tiuquiquiaariuhua na pueyata Capernaum tiacajiniohua, Romano soldadohua jiyaniijiaari Jesuucua niquiaari na secojonura Jesu. ");
INSERT INTO arlNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Naa na sequequiaariiri: —Jiyaniijianaa, cua seruuri cusosu mataa maquetujinia. Majaari na naata pooniniu quenaaja. Jiyanohua naquiya miya na noonutaari. ");
INSERT INTO arlNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesuuri na sequequiaari: —Janiyacuajaari nocua quianutaniyani na cusonu cua shaatanura. ");
INSERT INTO arlNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Soldadohua jiyaniijiaari na riucuaree: —¡Maja jiyaniijianaa! Janiyari maja pueyano maniniuni, cua tiajinia quia tiuquiniuria. Nareja quia sequere, cua seru cusonu cuaara shaateera tamajaaja. Niishiyacuajanijia, quiaari na shaatanutaniya saa quia rupaataja. ");
INSERT INTO arlNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Janiyari jiyaniijiaracajaniuhuaj. Na tojiquiaanijia. Naajuhuaj, cua soldadohuari cua tojitiaquiaajuhuaj cua sequesacari nojori. Naacuajitij, janiya jaara tamonu sequereni: “Quia quiaare”, cunoori ritia quiaquiaa. Naajuhuaj, janiya jaara tamonu sequereni cuaara niiria, cunoori ritia niya cucua. Janiya jaara cua pataaco seru sequereni cuaara miiria cua panishano, na miiquiaari. Cua sequesano jaara naa tojishaaquiaacuaa, quia sequesano cutaraari tojishaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesu jaara tojiquiaari naa cuno tahue sequesanotej, jiuujiatequiaariiri. Na cojiniaa sequereeri: —¡Seetanujuanaa nia sequeyanijia, majaari quenaaja parta Israel pueyajinijinio cua niquiniu quiquiaa Pueyasoocua tiuujia cutara, juhua nio tahue! ");
INSERT INTO arlNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Seetanujuanaa nia sequeyanijia, queraatia taucuacaari Pueyasoocua tiuujiaca quiniutianiya juhua nio tahue. Nojoriiri tucuacaanuji nijionutaniya pananu muetasamaji, pananu tiuquishocojijiuhuaj. Nojoriiri pa supuetanaata cajitiuniutianiya na miaquenuunura Pueyaso shuriucua. Tii quiniutianiya shuquiriaatiaari pa supuetanaata: Abrahamta, Isaactajuhuaj, Jacobotanio. ");
INSERT INTO arlNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Parta Israel pueya, canapuete Abraham jinianuucuajinio supuenoni, nojoriiri saniniuujia tamocora quejoosaanutaniya ninishiqui, nojori tojitiaaquiniuucua Pueyaso. Nojoriiri tii sariyocuatunutaniya naquiya na miishacari. Na quiaca miaquenuunutaniyari na noonuta. Nojoriiri juucua saquiriojosaaquiaari Pueyaso muerasu nojori quiniuria. Nojoriiri jiyaniya nojoriiri Pueyaso muerasu cutara Abraham jinianuucuajinio nojori quishacari. ");
INSERT INTO arlNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Na nuhuaji, Jesuuri cuno soldadohua camarnu sequequiaari: —Quia tiajinia quia quiaarohuaqui. Cuaara quiiriaqui taa quia sequereecuajani. Jiyacaritij, na seruuri ritia naataquiaariuhua. ");
INSERT INTO arlNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesuuri quiaaree Pedro tiajinia. Tii Pedro reyarucua niquishiiri cusosu mataano na maquetujinia. Naseeca matariquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesuuri na juaashiquia quiasee. Na naseeca cusonuuri ritia na tajiquiaari. Ritia sanequiaariiri Jesu na mianuutenura. ");
INSERT INTO arlNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Shusha ninishacari cuno juucaja, cuno tiacajinijinio pueyari queraatia samaruhuaraca pueya jaatucunuuquiaari Jesuucua. Jesuuri cuno samaruhua tohuatanijioquiaari saa na rupaataja. Puetunu cusosuhuajanaa naatanijioreejaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Naa tohuateequiaariti supuetana Isaías naajiotasano, Pueyaso niishitishacari nojuaja Jesujiniji. Naa naajiotasano quiyari: “Nojuajaari taraatia pa miiniu jaariutiaree pajaniyajiniji. Pa niti cusoyareeri puetunu pa cusonujuanaa na jatanura”. ");
INSERT INTO arlNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesu jaara jiyanohua queraatia pueya niquiquiaari na shocua maano, na pueya sequereeri: —Caminia taquijiria pa niuutiaare. ");
INSERT INTO arlNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jiyacaritij, Moisés Rootasanojiniji niishitiojona pueyanoori Jesu sequeree: —Niishitiojonanaa, janiyari quiata quianu paniyani. Janiyacua quia tarajareni puetunu tiquiyocuajanaa quia rucuanejosacari. ");
INSERT INTO arlNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesuuri na riucuaree: —Quioojuapue cutaraari na raa jiitiaa. Shuhuari na jesuhua jiitiaajuhuaj. Saniniuujia, pueyano cua quishacari mijiria, majaari cua maquejara cua jiitianu quenaaja, taa cuno casami jiitiaacuaa na maquetujuarani. ");
INSERT INTO arlNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tamonu Jesu pueyajinijinioori Jesu sequeree: —Cua jiyaniijianaa, cua tarinitiare, cua que niquirijiaara. Janiya jaara na shaajareni, janiyacua quia tarajare cutarani. ");
INSERT INTO arlNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesuuri na riucuaree: —Naajaa, cuata quia quiaare cutara. Quia tarinitiare nojuaja. Macunucua cuaara jamoora tama narta macujuaaja. Naatej, cante Pueyaso tojitiaashijiacani, nojoriiri tariucua juhua macunucua quiya Pueyasora. ");
INSERT INTO arlNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Na nuhuaji, Jesuuri botejinia tacaquiaari. Na saquiriojosano pueyari nata quiojoquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Paratuuri senota piyarojonu coteequiaari nojori niuutiasacari. Jiyanohua piyarojoriquiaari. Caminiaari jiyanohua queyocuariquiaa paratu piyarojosacari. Mohuacaari bote jiniacuma mishiriquiaa. Jesuuri jiyacari maqueriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na pueyari cunora na niucuajasee. Jesu sequetureeri: —¡Jiyaniijianaa, canaa quia naacutare! ¡Paa tari tiuquitiaareeni! ");
INSERT INTO arlNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nojori riucuareeri: —¿Casaara nia pueretiuyani? ¿Majateeri nia niishiniu Pueyasoocua tiuuniu? Jesuuri saneree. Paratu sequereeri, mohuacanio: —¡Niaaj, nia suraajere! Paratu, mohuacaari ritia suraajequiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jesu pueyari jiuujiatequee. Tama nojorijiaarijia sequequiaari: —¡Juhuej! ¿Taamueca pueyanotucuaanojoni? ¡Paratuuri na tojiya, mohuacajuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesuuri na saquiriojosano pueyata tiuquiijioquiaari caminia taquijiria Gadara jiyajinia. Jiyacaritij, caapiqui pueyanoori Jesuucua tohuareetaquiaari raacajiniji, macunucua nucuhua paaquiosaquiji. Nojoriiri samaruhuaraca quiquiaari. ¡Jiyanohua pueya pueresano! Cuno nucuaco, majaari pueya rucuanenu quijia, cuno pojori na puerenuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Samaruhuaraca caapiqui pueyanoori Jesuucua nacaturee: —¿Casaacua miji quia niyani, Pueyaso Niyanunaa? ¿Quiaate juhuacarijia niyaree canaa quia saniitionura Jesunaa? ");
INSERT INTO arlNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jiyacaritij, cushiyari cateca naataja miaquenuuriquiaa. Jiyanohua queraatia cushiyari quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Samaruhuari cuno caapiqui pueya pocuatequiaari. Naa Jesu secojoreeri: —¡Quiaa jaara canaa tohuatanijiore nio caapiqui pueyanojiniji, canaa quia jiyarore cuno cushiyacua canaa tiuquitianura! ");
INSERT INTO arlNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesuuri cuno samaruhua sequeree: —¡Nia quiaare! Samaruhuari cuno caapiqui pueyajiniji tohuareetaquiaari. Cushiyacua tiuquitiaseeri. ¡Cushiyari cocuatequee! Saaja caminiajinia totesee tacojinijiiri. Cushiyari tii shushiniuushii. ");
INSERT INTO arlNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Cushiya cojuanaari netecuatuquiaariuhua na shiriiquiniutia na tiacajiniara. Nojori tiuquiijiosacariuhua, pueya niquiara pohuatatuquiaari cushiyajinijiiri, samaruhuaraca pueyajinijinio. ");
INSERT INTO arlNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Naaratej puetunu pueyajanaari cuno tiacajiniji nijioquiaari Jesuucua. Nojori niquishacari Jesu, na sequetureeri nojori jiyajiniji na quianura tamaqui. ");
INSERT INTO arlNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Na nuhuaji, Jesuuri botejinia rosetaquiaari na saquiriojosano pueyata. Caminia taquijiria niuutiaquiaariuhuari tama na tiacajiniarajaaja. ");
INSERT INTO arlNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tii nojori tiuquiijiosacari, Jesuucua patasaaquiaariiri cumatacuruhuana cusosu pueyano. Patasaaquiaariiri na matujinia. Jesu niquishacari taa na patanaa tiuuquiaari jiyanohua nocuani, cusosu sequereeri: —¡Quia shuquiriri sanajanaa! Quiaacuajaari tari jiyanooshaaree sesa quia miishanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Noojiaqueya Moisés Rootasanojiniji niishitiojonaari Jesu sequesano tojitiariquiaa. Nojoriiri tama noojiajiniajaaja niishiriojonuuquiaari: “¡Nio pueyanoori tama na cuaqueyajaaja jiyateya juhua Pueyaso na quiniuria naa na sequesacari! ¡Cunoori jiyanohua sacuaraatia!”. ");
INSERT INTO arlNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesuuri cuno pueya niishiriojosano niishiquiaari. Nojori sequereeri: —¿Casaara sesa nia niishiriojiyani? ");
INSERT INTO arlNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Seetanujuanaa, pueyano maja na naata jiyanooniu pueya miishano sesa. Naajuhuaj, majaari na naata tamajaaja pueya na naataniniu. ");
INSERT INTO arlNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Naajaa, janiyari nia niishitiniutianiyani janiyari mijiria jiyarosaaquiaarini cua jiyanooniuria pueya, sesa nojori miishanojiniji. Jiyacaritij, Jesuuri cusosu sequequiaari cuno pueya niquiara: —¡Quia sanere! Quia matu quia pataarohua quia tiajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Cusosuuri sanequiaari. Na tiajinia quiaarohuari. ");
INSERT INTO arlNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Na niquitiushacari Jesu miishano, puetunu pueyajanaari shiriiquitiuquiaari. Nojoriiri Pueyaso maniniuhuaqueetaquiaari pueya na niquitionuucua na cumaaca, naa Jesu miiniuriatej. ");
INSERT INTO arlNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesu quiasacari cuno tiacajiniji, tamonu pueyano niquiquiaari cajiyanoori cumaneeca masejojuajinia Romano jiyaniijiara. Na sesa quiquiaari Mateo. Nojuacuajaari janiya; nio naajionani. Jesuuri cua sequequiaari: —Cua nuhuajiyare cua pueyano quia quiniuria. Janiyari ritia sanequiaarini. Janiyari nata quiaareeni. ");
INSERT INTO arlNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na nuhuaji, janiyari Jesu masuuquiaarini cua tiajinia na miaquenura, na pueyajuhuaj. Naacuajitij Jesuuri cua tiajinia tiuquitiaquiaari miaquenura. Queraatia cuarta cumaneeca masejonaari canaa cojiriquiaajuhuaj, queraatia noo pojorijiuhuaj, Fariseocuaca jiyaniquitiushano sesoriquia pueyatatej. Puetunu canaajanaari Jesuta miaquenuuriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseocuaca jaara Jesu niquiquiaari miaqueyano canaata, nojori soosano pueyani, nojoriiri naa Jesu saquiriojosano pueya nequesotaree: —¿Casaara nia niishitiojona miaqueya cuno sacuaraatia cumaneeca masejonaatani, sesoriquia pueyatanio? ");
INSERT INTO arlNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesuuri naa nojori sequesano tojirii. Nojori sequeree miriquiiri: —Cante na cuaqueya jiyaniyani maja cusosu na quiniu, nojuajaari maja naarajona na paniniu. Cusosuhua cutaraari naarajona panijia. Naajuhuaj, sesa miijiaca pueyari cua paniya nojori cua jiyanooniuria sesa nojori miijiosanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Niaa cuaara niishitiojosuhuara socua, maninia nia niishiniuria casaa tariucuacaanu Pueyaso sequesano niishitiojiyani naa na sequesacaritij: “Niaacuajaari nia seya catijiaquiaa cucuara. Maninia juhuari nia taraajenura tamasacaacua. Cuno cutaraari cua shuquiritiasano”. Naara niquiaarinijia nia sequesano sesa miijiaca cua jiyanooniuria sesa nojori miishanojiniji. Maja cutaraari mijiria cua niniu quiquiaari maninia pueyacua. ");
INSERT INTO arlNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tiuquinijiona Juan pueyari Jesuucua niquiaari naa na nequesotanura: —¿Casaara quia pueya tarinitiaaquiquiaa quenaaja miaquenuni, nojori secojonura Pueyasoni? Canaacuajaari miaquenu cartequiaani Pueyaso canaa secojonura taa Fariseocuaca miiquiaacuaani. ");
INSERT INTO arlNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesuuri nojori riucuaree miriqui: —Pueyano camishacari, ¿na masuusano pueyatucua taraatia quiriiri, camiriquiano pueyano jaara nojoritia quiyajaa? Maja. Tamacari cutara, camiriquiano pueyanoori nojori tajiniji rishaanutaniya. Jiyacari cutara maja cua pueya miaquenu quiniutianiya, janiya jaara nojori tajiniji rishaareni. ");
INSERT INTO arlNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Socua cua tojitiare pueyanaa. Pueyano jaara cushipirijionu paniri na toque mocua, maja na naata quiarinio toquerau ruposaanu toque mocua cuhuocojinia, jeequesoojua na quishacari. Quiarinio toquerau jaara ruposaare toque mocua cuhuocojinia, na jeequesacari, posequenutaniyari. Cunota, toque mocua cuhuocoori socua sutenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Naajuhuaj, majaari pa naata uva caaca racatanu shoque tariucuacojinia. Uva quiariniacu jaara racatasaare juucua shoque tariucuacojinia, jaara jerema vinora na quiniuria, shoque tariucuaco surtanutaniyari. Vinoori niitiasaanutaniya najuhuanaj. Shoque tariucuacoori maja na naata tooniu, uva caaca jaara jerema. Naaratej, uva caaca nia shuujiore shoque quiariquiojinia, maja najuhuana nia niitianura uva caaca. Naajuhuaj, majaari na naata cua niishitiojosano cojitishaanu tariucuacaanu niishitiojosanota. Cua niishitiojosano nia tojitiare cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesu pocuasacarijia, nocua niquiaariiri Pueyaso secojojua tia camarnu. Jesu cariquimiaji mojoquetaquiaariiri. Na sequereeri: —¡Quiyatuuri shusha cusoquee! Naajaa, miji, cuata quia quiaare. Niishiyanijia quiaa jaara niare nocua quia juaashiquia, samiitianutaniuhuari. ");
INSERT INTO arlNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesuuri saneree. Nata quiaareeri. Canaa, Jesu saquiriojosano pueyani, canaari nata quiaareejuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Canaa quiasacari, tamonu maaji cusosuuri Jesuucua catecanoquiaari jiyasohuaja na paramaji. Cuno maajiiri pueyaracaanu naatequiaari. Doce marijiaari tari na shoconujuquiaari pueyaracaanu na naatesacari. Tama niishiriojoriquiaajaarijia: “Janiya jaara Jesu toque quiareni, cua nanacaari curetanutaniya”. Cunora, maajiiri Jesu toque casaca quiasee jiyasohuaja. ");
INSERT INTO arlNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesuuri na nijiniara tacatequee. Cuno maaji niquiriiri. Na sequereeri: —Shuquiriaatia quia quiri, sanaunaa. Cucua quia tiuushacari, quia nanacaari tari curetaquee. Jiyacaritij, cuno maaji jiniacumaari ritia sacuantaquee. ");
INSERT INTO arlNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesuta canaa tiuquishacari Pueyaso secojojua tia camarnu tiajinia, canaari pueya niquishiini macura naajua joneneniuyano taraatia, sapiyoniuyanonio. ");
INSERT INTO arlNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesuuri cuno pojori sequeree: —¡Niiquiji nia tohuareetare! Nio maaji samiriuuri maja macu. Nareja maqueyano. Pueyari Jesu saroojotaree saaja, naa na sequesacaritij. ");
INSERT INTO arlNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesuuri cuno pojori tohuatanijioree saaja. Na nuhuaji, sohuacamara tiuquimiaari macuucua. Na juaashiquiajiniji na quiaseeri. ¡Maaji samiriuuri sanemaa! ");
INSERT INTO arlNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Naa Jesu miishanojinijiiri pohuatasaaquiaari puetunu cuno jiyajiniajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Canaa jaara tohuareetaquiaari cuno tiajinijini, caapiqui cariyojuaruuri Jesu nuhuajiquiaari. Canaa nuhuaji nacariquiaari nojori niishishacari Jesuuri seetanujuanaa Pueyaso Jiyarosano. Naaratej, Jesu sequeturiquiaari: —¡Supuetana David niquiohuacuajinio supueno pueyanonaa, canaacua quia taraajere quenaaja! ");
INSERT INTO arlNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Canaa tiuquishacariuhua canaa quijia tiajinia, cariyojuarujuriiri Jesuucua catecanoquiaari. Jesuuri nojori nequesotaree: —¿Niaate cucua tiuya nia namijiaa cua jeecanura? Jesu riucuatureeri: —Jaa, jiyaniijianaa. ¡Quia naatacuaaquiniatejaj! ");
INSERT INTO arlNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesuuri na juaashiquia niaree nojori namijiaacua. Jesuuri cariyojuarujuri sequeree: —Cucua nia tiuuniuucua, cuaara quiiria taa nia sequereecuajani, ");
INSERT INTO arlNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Cuno pojori namijiaari maniniujiaacara quiquiaariuhua. Jesuuri jiyanohua nojori rootaree: —¡Majaari tamasaca niquiara nia pohuatanu cua miishano! ");
INSERT INTO arlNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Na tohuareetasacari, cuno cariyojuarujuriiri ritia pohuatanu coteequiaari Jesu miishanojiniji. Naacuajitij, Jesujiniji niishishaaquiaariiri puetunu cuno jiyajiniajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cariyojuarujuri tohuareetanu nuhuaji, tamasaca pueyari Jesuucua jaatucuquiaari samaruraca pueyano. Cuno pueyanoori maja na naata pocuanu quijia. Tiquiatuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesuuri samaru tohuatanirii cuno pueyanojiniji. Na nuhuaji, cuno pueyanoori ritia pocuanu coteequiaari. Naa pueya niquishacaritij, nojoriiri jiyanohua jiuujiatequiaari. Sequetureeri: —¡Naa miishanoori maja na niquishaanu quiquiaari Israel jiyajinia! ");
INSERT INTO arlNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseocuacaari saaja Jesu macaatiquiaari pueya niquiara. Naa sequetureeri: —Cuno Jesuni, nojuajaari samaruhua jiyaniijia cumaacaraca. Naacuajitij, na naata samaruhua tohuatanijionu. ");
INSERT INTO arlNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesuuri puetunu tiacajiniajanaa rucuanejoquiaari Pueyaso rupaa na pohuatanura, puereetuuca tiacajinia, shiitianiyojua tiacajinianio. Maninia rupaa pohuataquiaariiri Pueyaso secojojua tiacajiniaqueya, pueya niishiniuria taa Pueyaso jiyanooniu paniya nojorini. Naajuhuaj, nojuajaari queraatia tamaatia cusonu naatanijioquiaari puetunujuanaa, nootunejacanio. ");
INSERT INTO arlNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesu shootiasacari pueya, nojoriicua taraajequiaari jiyanohuari. Pueyari taraatia niquishano quiquiaari, juhua tashuquioono pueya. Nojoriiri taraatia quijiaca quiquiaari juhua cojuasoo borregohua. Shaaqui na camaru. ");
INSERT INTO arlNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Cunora, Jesuuri canaa na saquiriojosano pueya sequequiaari: —¡Nia niquiri! Jiyanohua queraatia pueya. Cuno pojoriiri juhua puereetuuca sucohua. Saniniuujia, secajaari na senoonaa. ");
INSERT INTO arlNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nocuaji nia sequeyanijia, na Camaru nia secojore, nojuaja cuaara jiyaroora queraatia poonijionaa na senooriquiano nera. ");
INSERT INTO arlNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesuuri canaa na doce saquiriojosano pueya sequequiaari na rootasano canaa tojiniuria, canaa na jiyaramiquiyaquishacarijia. Jesuuri canaa niquitioquiaari na cumaaca, samaruhua canaa tohuatanijionura, cusosuhua canaa naatanijionura, puetunu noonujuanaa canaa shaatanurajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nioori canaa sesaca, na jiyaramiquishocoriquiano pueya sesacani: coteenuuri quiquiaari Simón. Pedroori na sesa quiquiaarijiuhuaj. Pedro tarajanu Andrésri quiquiaarijiuhuaj. Quiriquiaajaariuhua Santiago, tarajanu Juannio. Cuno pojoriiri Zebedeo niquiohua quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipeeri quiriquiaajuhuaj, Bartolomé, Tomásnio. Quiriquiaajaariuhua janiya Mateoni. Janiyari tarijia quiquiaarini cumaneeca masejojua Romano jiyaniijiara. Quiriquiaajaariuhua socua tamonu Santiago. Cuno Santiagoori Alfeo niyanu quiquiaari. Quiriquiaajaariuhua Lebeo. Na sesa tarajanuuri quiquiaari Tadeo. ");
INSERT INTO arlNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Quiriquiaajaariuhua Simón. Nojuajaari Cananeo pueya maanujinijinio quiquiaari. Judas Iscarioteeri quiriquiaajuhuaj. Nojuajaari Jesu quiateriquiano quiquiaari mosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesuuri nio na doce pueya jiyaramiquiquiaari Pueyaso rupaa canaa pohuatanura. Coteenu, canaa rootaquiaariiri, canaa na jiyaramiquiyaquishacarijia. Naa canaa sequequiaariiri: —Majaari taucuacaacua nia quiojonu. Naajuhuaj, majaari nia tiuquiniu Samaria pueya tiacajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Saaja parta Israel pueyacua nia quiaare cutara. Nojoriiri juhua borregohua tashuquioono quiya. ");
INSERT INTO arlNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nojori niquiara nia pohuatare puetunu tiacajiniajanaa. Nojori nia sequere: “Pueyasoori quiarijia nia jiitianu paniya, niaa jaara na rupaa tojitiajacara quiri”. ");
INSERT INTO arlNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cusosuhua nia naatanijiore. Macunucua nia samiitianijiore. Canapuete lepra cusonu jiitiaani, cuno cusonu nia shaajare pueya cuaqueyajiniji. Samaruhua nia tohuatanijiore pueyajiniji. Niaacuajaari nio cumaaca maseree nareja. Naaratej, nareja nia naatanijiorejuhuaj. Majaari cua cumaaca nia jamuenu. ");
INSERT INTO arlNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Majaari cumaneeca nia panu. ");
INSERT INTO arlNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Majaari nia caashoque nia panu. Majaari socua toqueya nia panu, sapatunio. Saa nia cushishanotaja nia quiaare. Majaari nia panu nia miojotu. Nia naacutasano pueya cuaara niquitioora saniniuujia nia panishano. ");
INSERT INTO arlNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Nia rucuanejosacari, niaa jaara tamonu tiacajinia tiuquishii, nia nequesotare tee maninia pueyano quiyani. Cuno pueyano tiajinia nia jiyojetare, niaa cuaara cuniquiji quiaarejaatijia. ");
INSERT INTO arlNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Niaa jaara tamonu tiajinia tiuquishiiquia, pueya nia sequere naatej: “Pueyaso cuaara nioojia cajitiiria”. ");
INSERT INTO arlNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Cuno tiajinia quiniaa jaara maninia pueya quiri, juhuajaniya quiniutianiyari taa nia sequereecuajani. Nojori jaara Pueyaso tojiyashijiaca quiri saniniuujia, nojori jiuujiacaari cajitiyaquishaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tamonu tia camaru jaara nia tiuquinitianu paniyaquiri na tiajinia, Pueyaso Rupaa ruuretajaca nojori quiniuucua, nojori niquiara nia niohuacaacuaji nia rapijiotare jiya joocua. Naacuajitij, cuno pueyari niishiniutianiya Pueyasoori nojori jiyanoyaquiniutianiya, nojori maseyaquiniuucua na rupaa pohuatanaa. Naa nia miirijiuhuaj cuno tiaca pueya niquiara, cuno pojori jaara Pueyaso rupaa tojiniu paniyaquiri nia pohuatasacari. ");
INSERT INTO arlNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Seetanujuanaa nia sequeyanijia, jiya puequesacari, cua nequesoreesacari pueya, cuno pueyari jiyanohua saniitiosaanutaniya socua Sodoma tiaca pueyajiniji, Gomorra tiaca pueyajinijinio. ");
INSERT INTO arlNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Socua cua tojitiare. Janiyari nia jiyaroya Pueyaso tojitiaashijiaca niquiara nia pohuatanura cua rupaani. Niaari nojori tajinia puereeta quiniutianiya, naatej, taa borregohua quiya sayoru tajiniacuaani. Nojoriiri sesa miiniutianiya niajaniya. Nocuaji jiyanohua niishijiaca nia quiri, tama nia cuaqueyajaaja nia cojuanura. Naajaa, majaari nojori naminiu. Saaja maninia nia quiri juhua noseja, pueyano porocua. ");
INSERT INTO arlNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tama nia cuaqueyajaaja nia cojuare tamasaca pueyacuaji. Cuno pojoriiri nia jiyatanutaniya tiaca jiyaniijianucuaacua nia saniitiosaanura, nojori tojiniu paniyaquishacari cua rupaa. Niaari Pueyaso secojojua tiacajinia piquishaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Cua rupaa nia pohuatanuucua, niaari quioosaanutaniya tiaca jiyaniijianucuaacuara, nojori nequesoreenura niajaniya. Niaari jiyaca jiyaniijianucua niquitiosaanutaniyajuhuaj. Naajaa, naacuajitij, niaari nojori niquiara pohuatanutaniya janiyajiniji, taucuaca jiyaniijianucua niquiaranio. ");
INSERT INTO arlNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Niaa jaara jiyaniijianucua tacoji nujuatesaare nequesoreesocoriquiano, majaari nia niishiriojonu taa nia riucuanutaniyani. Nia riucuanu panishacari, niaari jiyacari niishitiosaanutaniyacuaja maninia nia riucuanura. ");
INSERT INTO arlNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Naacuajitij, nia riucuasanoori maja tama niajaniyajinijijiaaja quiniutianiya. Pueyaso Sohuanu cutaraari nia pohuatenutaniya jiyaniijianucua niquiara. ");
INSERT INTO arlNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Pueyari tama tarajanujuaaja niquitionutaniya mosocoriquiano, tarajanu tiuushacari cucua. Pueyanoori neyanu niquitionutaniya mosocoriquiano, cucua neyanu tiuuniuucua. Mueraasapueeri tama na queya tacartanutaniyajaacujua na motenura, na queya tiuushacari cucua. ");
INSERT INTO arlNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Puetunu pueyajanaari nia niquiniu paniyaquiniutianiya, cucua nia tiuushacari. Naajaa, cante seetanujuanaa cucua tiuujia quiya pueyaracaanuni, nojuaja cutaraari jatanishaanutaniya pueyaracaanu shacantuuca quijia na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pueya jaara naquiya nia miiri Pueyaso rupaa nia pohuatasacari nojori tiacajinia, cuno tiacajiniji nia mashiri tamonu tiacajiniara tii nia pohuatanura. Seetanujuanaa nia sequeyanijia, juhuanojuaja nia tucuataaquishacarijia pohuatanu Pueyaso rupaa puetunu Israel pueya tiacajiniajanaa, janiyari jiyocuacaanuji tacatenutaniuhuani. ");
INSERT INTO arlNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Nio nia niishirijiuhuaj. Pueyanoori maja socua tojishano na niishitiojonajiniji. Naajuhuaj, seruuri maja socua tojishano na camarnujiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pueyano jaara maninia tojiriquia na niishitiojona, maniniacuajaari nojuaja jaara na nuhuaji juhua na niishitiojonara quirijiuhuaj. Maniniacuajaari, seru jaara juhua na camarnura quirijiuhuaj. Naaratej, nia Jiyaniijia jaara jiyaniquishiyacuaa “Sesaacata”, ¿taariquitijia socua na muerasu sesacasaanutaniyatej? ");
INSERT INTO arlNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Naaratej, majaari nia puerenu niarta pueya. Puetunu jiyasohuaja pueya miishanojuanaari niishishano quiniutianiya. Puetunu pueya seetasanojuanaari niishishaanutaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jiyasohuaja cua niishitiojosano niajaniyani, cuno nia pohuatare puetunu pueya niquiarajanaa. Cua sasacojosano nia numaa pajamani, cuno nia nacatare puetunu pueya niquiarajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Majaari nia puerenu pa puecoojuaca. Nojoriiri maja na naata pa sohuanu monu. Saaja nia puerere cutara nooj, cante cumaacaracacuajani mani quiquiojinia nia sohuanu na quejoonura, nia cuaqueyanio. ");
INSERT INTO arlNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Pa naata saaja niquiriyatu cumaneeniyojuata caapiqui shiyojuaniyojua masenu pa miaquesocoriquiano. Naajaa, pa Que Pueyasoori puetunu cuno shuhua niishiyajanaa. Naacuajitij, majaari quenaaja niquiriyatujua shiyojua cusonu Pueyaso paniyaquishacari. ");
INSERT INTO arlNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Naajuhuaj, Pueyasoori puetunu nia naca cajasu niishiyajanaa. Puetunujuanaari na serojosano quiya. ");
INSERT INTO arlNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Naacuajitij, maja nia puerenu. Niaari jiyanohua socua Pueyaso panishano queraatia shuhuajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Niaa jaara tamasaca pueya niquiara sequere niaari cucua tiuujiaca cutara, janiyacua jiyocuacaanu quijia cua Que niquiara sequerejaniuhuaj, niaari cua muerasu. ");
INSERT INTO arlNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Cante saniniuujia cucuaji seetaja tamasaca niquiarani, janiyari cua Que niquiara na tamacanutaniyajaacuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Majaari nia jiyaniniu janiya mijiria niquiaarini pueya quiniuria juhuajaniya. Maja. Mijiria cua niniuucua, pueyari juayonuujutanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Niquiaari cutaranijia pueya tiuuniuria cucua. Naacuajitij, pueya tiuushacari cucua, cucua tiuyashijiaca pueyari nojori niquiniu paniyaquiniutianiya. Naacuajitij, pueyanoori na que paracaaniutianiya, cucua tiuujia na que quiniuucua. Maajiiri na nucua paracaaniutianiyajuhuaj, na nucua tiuuniuucua cucua. Pueyano niquiocuaari na reyarucua paracaaniutianiyajuhuaj, cucua tiuujia na reyarucua quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Naacuajitij, tama pueya panishano pueyajaajaari na paracara quiniutianiya, cucua nojori tiuuniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Cante na queya panijia socua janiyajinijini, jiyano pueyanoori maja maninia cua pueyano na quiniuria. Cante necohua panijia socua janiyajinijini, jiyano pueyanoori maja maninia cua pueyano na quiniuriajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Cante tama na cuaqueyajaaja panitiaaquijia na tojiniuria janiyani, cunoori maja maninia quiria. ");
INSERT INTO arlNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Cante saaja tama na cuaqueyajaaja cojuanu paniya shuquiriaatia na quiniuria mijiriani, jiyano pueyanotej, nojuaja cutaraari shaajasaanutaniya, pueyaracaanu taraatia na miitiasaanura. Saniniuujia, cante tama na cuaqueyajaaja panitiaa naquiya na miishaanura cua tojijia na quiniuucuani, nojuaja cutaraari rishijiara jatanishaanutaniya. Seetanujuanaa cuata shuquiriaatia quiniutianiya pueyaracaanuuri. ");
INSERT INTO arlNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Cante na tiaco nia tiuquinitiaja cua rupaajiniji nia pohuatasano na tojiniuriani, cuno pueyanoori cua tojiyajuhuaj. Cuno, cante cua tojijiani, nojuajaari cua Jiyarona tojijiajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Naajuhuaj, cante Pueyaso rupaa pohuatana tiuquinitiaja na tiaconi, Pueyaso rupaa pohuatana na quiniuucuani, Pueyasoori cuno pueyano niquitionutaniya maninia na casaajiniji. Nojuajaari niquitiosaanutaniya mariyata taa Pueyaso rupaa pohuatana niquitiosaanutaniyacuaani, Pueyasojiniji na pohuatanu sami. Cante maninia miijia pueyano tiuquinitiaja na tiaconi, maninia pueyano na quiniuucua, na tiaco tiuquinitiaja pueyanoori maninia casaa niquitiosaanutaniya mariyata taa maninia miijia pueyano niquitiosaanutaniyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Naajuhuaj, cante quenaaja shiniitiuniacu mohuaca raateya tamonuni, cua mueyaniyojua na quiniuucua, Pueyasoori seetanujuanaa na jiitiasanojiniji na niquitionutaniya na raatenu sami. ");
INSERT INTO arlNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesu jaara canaa na doce saquiriojosano pueya rootanu tucuataquiaari tii, nojuajaari tiji quiaquiaari cuno jiya tiacajinia quiniaa na niishitiojonura Pueyaso rupaa. ");
INSERT INTO arlNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tiuquinijiona Juan quishacari nujuatejojuajinia, nojuajaari jiyacari niishiquiaari Jesucristo miishanojiniji. Cunora, nojuajaari na pueya jiyaroquiaari Jesuucua naa na nequesotanura: ");
INSERT INTO arlNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—¿Quiaate seetanujuanaa Cristo, tariucuacaanu Pueyaso sequesano canaacua niriquianotej? ¿Canaate tamonu sashiya soj? ");
INSERT INTO arlNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesuuri nojori riucuaree: —Nia quiaarohua. Tiuquinijiona Juan nia pohuatasuhua puetunu cua miishanojuanaa nia niquishano, nia tojishanojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Naa nia pohuatasuhua: “Cariyojuarujuriiri tari niquitiarohua. Shipiiniquiuniuujiacaari maninia rucoorohua. Shu miaqueja cusonu jiitiajacaari tari jeequerohua. Numueejunucuaari tari tojitiarohua maninia. Macunucuaari samiitiacorohua. Casamiijiuniucua pueyari Pueyaso rupaa pohuatasaaree, Pueyaso muerasura nojori quiniuria”. ");
INSERT INTO arlNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Shuquiriaatia quijia cutaraari noo pueyano, cante cucuaji taacanuyaquijiani. ");
INSERT INTO arlNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tiuquinijiona Juan pueya jaara quiojoquiaariuhua Juancua, Jesuuri Tiuquinijiona Juanjiniji naa pohuatanu coteequiaari pueya niquiaratej: —¿Casaa niquiniuucua nia quiojocanu cariiquia jiyajiniani? ¿Niaateeri paratu piyarojosano naajua niquiniuucua quiacanu? Maja. ¿Tiuquinijiona Juanteeri noojia niquijioteja? Maja. ");
INSERT INTO arlNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Cua sequeture, ¿casaa niquiniuucua nia quiojocanuni? ¿Niaateeri pueyano niquiquianu maniniuqui toque cushiyano? Maja. Cuno pojori cante maniniuqui toque cushijiani, nojoriiri jiyaniijianucua tiajinia quijiaca cutara, maja cariiquia jiyajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Taateerinitioj? ¿Casaacua nia quiojocanuurini? ¿Pueyaso sequenu panishano caminiujiunia niquiniuucuatee? Jaa. Seetanujuanaa nia sequeyanijia, Tiuquinijiona Juanri jiyanohua socua cutara pueyano tamasaca Pueyaso sequesano caminiujiuniaajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cuno Juanjinijicuajaari tariucuacaanu Pueyaso Rupaajinia pohuatasaaquiaari. Naa naajiotasaaquiaari miriquiiri Pueyaso sequesano janiya nojuajiniji: “Janiyari cua pueyano jiyaronutaniya quiocuajini. Nojuajaari quia puetanutaniya, quia nuu jeecariquiano quiocuaji”. Juanri naa maninia miiquiaari cucuaji, pueya tojiniuria janiya cua tiuquishacari. ");
INSERT INTO arlNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Seetanujuanaa nia sequeyanijia. Majaari tamonu pueyano quiniu quiquiaari socua cutara pueyano Tiuquinijiona Juanjiniji. Naajaa, cante Pueyaso muerasuniyojua quiya cucua na tiuushacarini, cunoori socua cutara pueyano Tiuquinijiona Juanjiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Tiuquinijiona Juan jaara coteequiaari Pueyaso rupaa pohuatanu, pueyari jiyanohua saniniujiuriquiaa Pueyaso muerasu nojori quiniuria. Pueyari naa saniniujiya quiarijiajuhuaj. Cante jiyanohua saniniujiya Pueyaso muerasu na quiniuriani, naa quiniutianiyari. ");
INSERT INTO arlNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Supuetana Moisés, mariyata puetunu Pueyaso sequesano caminiujiuniaajanaari tariucuacaanu pohuataquiaari taa Pueyaso jiitianutaniya pueyani. Naa poojotasaaquiaariiri Tiuquinijiona Juan jaara tiuquiquiaarijiaatijia. Quiarijiani, Tiuquinijiona Juanta, nojori pohuatasanoori tari tohuateenu coteya. ");
INSERT INTO arlNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Niaa jaara nio cua pohuatasanoocua tiuuniu paniri, nia tojiri nio: Tiuquinijiona Juancuajaari tariucuacaanu pueyara Pueyaso sequesano caminiujiunia Elíascuaja. Elíascuajaari sequesaaquiaari niriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Cante numaaracani, cuaara tojiiria cua sequesano. ");
INSERT INTO arlNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Nia pohuatareera taamuecate nio pa quishacari pueyani, quiarijiani paa na quiyani. Nio pueyari juhua naatujoori, canapuete carijiniacuma tacuarishijionu paniya juucuani. Nojoriiri narta naatujooriicua nacaa, nojori tacuarishijionu panishacari juucua. ");
INSERT INTO arlNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Naa nacaari: “Canaari juucua naajua jonenejiyani. Majaari nia nianujunu paniniu. Canaa jaaquequejosacari taraatia saniniuujia, majaari nia sapuenu”. ");
INSERT INTO arlNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Naajuhuaj pueyanaa, Tiuquinijiona Juan quishacari, nojuajaari mashaca ratuyashijia quiquiaari, sumatuu miaqueyashijiajuhuaj. Pueyari saaja na sequequiaari samaruraca pueyanota. ");
INSERT INTO arlNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na nuhuaji, janiyari tiuquiquiaarini. Janiya cutaraari sumatuucuaca miaquejani, mashaca ratujuajuhuaj. Pueyari cua sequequiaa: “Miaquejoru cuno, ratunu porocuanio. Sesa pueya cojijia, pa soosano Romano jiyaniijia seya cojijia sacuaraatiajuhuaj”. Naa nia soosacari janiya, Tiuquinijiona Juannio, niaari puetunu Pueyaso niishitiojosanojuanaa ruuretaa. Naajaa, pueyari na naata niishiniu maninia canaa miishanojiniji, janiya, Tiuquinijiona Juannio, canaari mariyata Pueyaso jiyaramiquishano cutarani. ");
INSERT INTO arlNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Corazín tiacajinia, mariyata Betsaida tiacajinia, Jesuuri tii socua pueya naatanijioquiaari tamasaca tiacajiniji. Jiyajeneta casaa miiquiaari tii Pueyaso cumaacataari. Pueyari saaja nocua tiuyaquiquiaari. Nojoriiri maja noojia na tacatonu quiquiaari sesa nojori miiniujiniji. Cunora, Jesuuri nojori piriyojoquiaari. Naa sequequiaari nio caapiqui tiacajinia quiniaa pueyari: ");
INSERT INTO arlNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Niaari taraatia saniitiosaanutaniya, nioojia nia tacatoyaquiniuucua sesa nia miishanojiniji! Janiya jaara Pueyaso cumaacata miiquiaari Tiro tiacajiniani, mariyata Sidón tiacajinianio, taa cua miiquiaari nia tiacajiniacuaani, cuno taucuaca maara Pueyasoocua tari noojia tacatocanu cutara. Nojori maara ritia cocuaque toqueya cushiyonuuquiaari nojori tacaaniu niishishaanura sesa nojori miishanojiniji. Naajuhuaj, nojori maara juaca quejooquiaari na nacaacua, noojia nojori tacatosacari Pueyasoocua, sesa nojori miiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Naaratej, janiyari nia numooteyani: jiya puequesacari, niaari socua jiyanohua saniitiosaanutaniya Tiro tiacajinia quiniaa pueyajiniji, Sidón tiaca pueyajinijinio. ");
INSERT INTO arlNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum tiacajinia quiniaanaa, ¿niaateeri jiyaniya niaari tamasaca tiaca shocotanutaniya nia jiyanishacari niaari socua maninia cutara? ¡Maja! Niaari mani quiquiojinia quejoosaanutaniya. Janiya jaara cua cumaacata cutara casaa miiquiaari Sodoma pueya tiacajiniani, taa cua miiquianu nia tajiniacuaani, Sodoma tiaca maara quiriquiajaj. ");
INSERT INTO arlNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nocuaji nia sequeya cutaranijia: jiya puequesacari, niaari socua jiyanohua saniitiosaanutaniya Sodoma tiaca pueyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jiyacaritij, Jesuuri na Que Pueyaso sequequiaari: —Quia shuquiritiaanijia cua Quenaa. Quiaari jiya camarnu, jiyocuacaanu camarnunio. ¡Quiaari maninia! Quiaari niishiyashijiaca pueya maninia casaa niishitirii, niishijiaca pueyacuaji quia jamosanoni. Niishijiaca pueyari saaja tama nojori niishishanoocuajaaja tiuujiaca. ");
INSERT INTO arlNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Naacuajitij cua Quenaa, quiaari maninia niishitirii niishiyashijiaca pueya, taa quia paniquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Cua tojitiare pueyanaa, cua Queeri cua niquitioquiaari puetunu casaajanaa cua jiitiasocoriquiano. Majaari seetanujuanaa tamasaca niishiniu janiya. Saa cua Queja cutaraari cua niishiya. Naajuhuaj, majaari seetanujuanaa tamasaca niishiniu cua Que. Saaja janiya, Neyanuni, na niishiya cutaranijia, naajuhuaj canapue cua niishitiniu paniya cua Quecuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Cucua nia nijiore, puetunu niajaniyajanaa, canapuete tacaaquioyani, canapuete puera niishiriojonuujuacani. Niaa jaara cucua nimia, janiyari nia samaraatanutaniyani. ");
INSERT INTO arlNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Cua niishitiojosano nia tojiri. Janiyajiniji nia niishiri taamuecatucuaa janiyani. Janiyari ritia juayashijiani. Janiyari pueya shocoteyaquijiani. Naacuajitij, nioojiaari maja na tacaaniu quiniutianiya nia rupuesacari janiya. ");
INSERT INTO arlNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nia tojishacari janiya, nioojiaari juhuajaniya quiniutianiya. Cua poonitijiosacari niajaniya, majaari jiyajeneta na quiniu quiniutianiya niaara, cua cumaquishacari niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jiyacaritij, Jesuuri canaa na saquiriojosano pueyata cuhuariquia jiuujiaaco tajiriquiaa samaatenu juuca. Canaari jiyacari miaajeriquiaani canaa quiasacari nucuaco. Canaari secaja trigo jajau carojotanu coteequiaarini. Canaari na miojonuuriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseocuaca jaara canaa niquiquiaari naa miyanotej, Jesu sequetureeri: —¡Quia niquiri! ¡Quia pueya trigo shuniitiaa! ¡Na shuquiuquiojoniuyari! ¡Naa nojori miishacaritij, poonijioniuyari! Cuno maja panishano samaatenu juuca miiniuria. ¡Pa supuetana Moiséscuajaari naa pa rootaquiaaritij! ");
INSERT INTO arlNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesuuri cuno pojori riucuaree: —¿Majateeri nia serojonu quiquiaari Pueyaso Rupaajinia taa pa supuetana David miiquiaari na miaajesacarini, na pueyanio? ");
INSERT INTO arlNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nojoriiri Pueyaso Secojojua tiajinia tiuquitiaquiaari. Pueyasora niquitiojosano pan satureeri. Cuno panri saaja pueyacuara secojonaa sasocoriquiano quiquiaari, maja socua tamonu pueyano sasocoriquiano. Naajaa, Davidri na saquiaari. Na miishanoori maninia quiquiaari Pueyaso niquiara. ");
INSERT INTO arlNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naajuhuaj, ¿majateeri nia serojonu quiquiaari tariucuacaanu Moisés naajiosanojinia, taa pueyacuara secojonaa pueyaracaanu poonijioquiaa Pueyaso Secojojua tiajiniani? Nojoriiri naa poonijionuuquiaa samaatenu juucajuhuaj. Naa nojori poonijiosacari Pueyaso Secojojua tiajinia samaatenu juucatej, cunoori maja sesa. ");
INSERT INTO arlNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Moiséscuajaari pa rootaquiaari maja pa poonijionura samaatenu juuca. Naajaa, cuno rootasanoori seetanujuanaa maja na quiniu Pueyaso Niyanura, jaara Pueyaso Secojojua tiajinia poonijionaara quiyaquirijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Maja naasucuaari nia niishiniu quiquiaari casaa nio tariucuacaanu naajiotasano niishitiojiya niajaniya juucuani. Naa sequeyari: “Janiya cutaraari socua nia panitiaani niarta pueyacua nia taraajenura, maja saaja nia niquitiojonura nia seya cucuara catijiasocoriquiano”. Niaa jaara nio naajiotasano niishijia quiriquia, niaa maara sesa miyashijia pueyacuara tonujiyaquiriquiaj. ");
INSERT INTO arlNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Cua tojitiare quiarijia. Janiyacuajaari Pueyaso Niyanuni. Naacuajitij, mijiria cua quishacari cua naata sequenu casaate samaatenu juuca miishiyani. ");
INSERT INTO arlNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na nuhuaji, canaari Jesuta quiojoquiaari quiniquijini. Canaari Pueyaso Secojojua tiajinia tiuquishiini. ");
INSERT INTO arlNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Pueyanoori tii quiriquiaa cuseetucojuara joojequetano na juaashiquia. Taa canaa Judiocuaca camarucua Jesuucuara saquiriojotanu paniriquiaa juucuacuajani, jiyacaritij, na sapojonuta Jesu nequesotaturee naari. —¿Maniniateeri samaatenu juuca cusosu naataniniuria? Paacuajaruhua niishitiojosaaquiaarini maja pa poonijionura samaatenu juuca. ");
INSERT INTO arlNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesuuri cuno pojori riucuaree: —Niaa jaara niquiriyatujua borregoniyojua jiitiare, cuno jaara tiyare raama samaatenu juuca, ¿majateeri nocua nia quianu, raamaji nia panura nia seruniyojua? ¡Taaquiriirinij! ");
INSERT INTO arlNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Majateeri pueyano socua jiyanohua panishano borregojiniji? Taaquiriirinij. Naaratej, maja pa tarinitianu maninia pa miiniuria pueyaracaanu, samaatenu juucajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Na nuhuaji, sesarucojua sequereeri: —Quia juaashiquia quia shiitiore. Na juaashiquia shiitioreeri. Ritia jeequequeeri juhua tanecaraja. ");
INSERT INTO arlNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Naa Fariseocuaca niquishacari Jesu miishanotej, tohuareetaqueeri. Tama nojorijiaarijia roojotooquiaari nojori motenura Jesu. ");
INSERT INTO arlNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesu jaara niishiquiaari Fariseocuaca miiniu panishano nojuaja, quiniquiji quiaqueeri. Queraatia pueyari na nuhuajiquiaari canaata. Jesuuri puetunu cusosuhuajanaa naatanijioquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesuuri na naatanijiosano pueya rootaquiaari maja tamasaca niquiara nojori pohuatanura cante nojuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Naacuajitij, tariucuacaanu Pueyaso sequesano caminiujiunia Isaías pohuatasanoori tohuateequiaari. Nojuajaari juhuacarijia naa pohuataquiaari Jesujiniji Pueyaso sequesano miriquitij: ");
INSERT INTO arlNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Niocuajaari cua seru, cua saquiriojosano. Na timitiaanijia. Nojuajaari jiyanohua cua panishano. Janiyari cua Sohuanu jiyaronutaniya nocuani. Nojuajaari tamasaca pueyapue pohuatanutaniya janiyajiniji, nojori quiniuria cua muerasura pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Majaari pueyata juaajia na quiniu quiniutianiya. Majaari nacojojua na quiniu quiniutianiya. Majaari na rupaa tojishano quiniutianiya tiacaacaco. ");
INSERT INTO arlNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Majaari quenaaja shuniitiasano naajua na shutianu quiniutianiya puetunujuanaa. Naajuhuaj, majaari na maquishajanu quiniutianiya jatarinitiaja nojiyano samaritiu. Nojuajaari naa sesa miijiaca jiyanooniutianiya, nojuaja jaara tiuquiriohuajaatijiaj, puetunu sesa miiniujianaa na puecanura, Jiyaniijiajanaa na quiniuhuara pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Puetunu tiquiyocuacajinijinio quijiaca pueyajanaari nocua tiuuniutianiya”. ");
INSERT INTO arlNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tiquiaari Jesuucua jaatucusaaquiaari. Cariyojuaru quiriquiaajaariuhuaj. Naa quiquiaariiri samaruraca na quiniuucua. Jesuuri na jeecaree. Naacuajitij, tiquiaari pocuajara quiquiaari, niquijiarajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Cunora, puetunu pueyajanaari nocuaji jiuujiatequiaari. Sequetureeri: —¡Nio jiyoteeri pa supuetana David niquiohuacuajinio supueno pueyano, tariucuacaanu sequesano pa jiyaniijiara quiriquianotej! ");
INSERT INTO arlNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseocuaca jaara tojiquiaari naa pueya sequesacari Jesujinijitij, nojoriiri na juaaniutia sequequiaari saaja: —¡Cuno pueyanoori samaruhua tohuatanijiya Satanás cumaacata! Satanásri samaruhua jiyaniijia. ");
INSERT INTO arlNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesuuri cuno pueya niishiriojosano niishiquiaari. Cunora, nojori sequereeri: —Jiya camarucua jaara juayonuujutare tama nojorijiaaja, majaari pueyaracaanu na naata quiniu camarnura. Ritia jatashiyari. Naajuhuaj, tiacajinia quiniaa jaara juayonuutare jiyareta tama nojorijiaaja, cuno pueyari maja na naata quiniu jatiqui. Naajaariuhuaj, pueyano jaara juayonuujutare tapueyocuacata tama na tiajiniajaaja, majaari nojori naata jatiqui quiniu. ");
INSERT INTO arlNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jaara naa quiritij, samaruhua jaara tohuatanijiosaare Sesaaca cumaacata, tama na cuaqueya paracayajaarijia. Naacuajitij, majaari na naata na cumaaca rishiniu. ");
INSERT INTO arlNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Janiya jaara samaruhua tohuatanijiya Satanás cumaacatani, taa nia sequeya janiyacuajani, cua sequeretoj, ¿cante nia niishitiojosano pueya cumaquiya samaruhua nojori tohuataniniuriani? ¿Satanástee? Majaruhua. Nojoricuajaari samaruhua tohuataniquiaa Pueyaso cumaacata. Naacuajitij, nojori tohuatanijiosacari samaruhua Pueyaso cumaacata, niaari jiyanohua jiyajeneya nia sequesacari janiya samaruhua tohuatanijiya Sesaaca cumaacatani. ");
INSERT INTO arlNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Seetanujuanaa Pueyaso Sohuanu cumaquishacari janiya, samaruhua cua tohuatanijionura, niaa cumaati cua sequesano tojirii. Naa cua tohuatanijiosacari samaruhuatej, niaacuajaari niishiya Pueyasoori tari poonijiya juhua Jiyaniijia, mijiria nia tajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Pueyanote na naata cumueeca pueyano tiajinia tiuquiniu na casami na jaariuutianura? Maja na naata na jaariuutianu, jaara coteenu na morojiyaquiri. Jaara na morojore coteenu, na nuhuaji cutara na naata na casami panu. Naajuhuaj, janiyari Pueyaso cumaacata jaariuutiaa Sesaaca jiitiasano pueyani. ");
INSERT INTO arlNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Cante cua jiyano quiyaquiyani, cunoori cua paraca. Cante cua naacutaaquiya pueya rerecojonura Pueyasorani, nojoriiri saaja pueya cocuataa Pueyasoocuaji. ");
INSERT INTO arlNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Naarate nia sequeyanijia: puetunu pueya miishano sesajanaari na naata jiyanooshaanu. Sesacojojua pueyanoori na naata jiyanooshaanujuhuaj. Saniniuujia, cante Pueyaso Sohuanu miishano sesacajani, cunoori maja na jiyanooshaanu quiniutianiya cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Cante Pueyaso Niyanu sesacajani, nojuajaari na naata jiyanooshaanujuhuaj. Saniniuujia, cante Pueyaso Sohuanu sesacajani, nojuaja cutaraari jiyanoyaquishaanutaniya pueyaracaanu. Na ruuretanuucua Pueyaso Sohuanu, majaari na jiyanooshaanu quiniutianiya mijiria, jiyocuacaanujuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Naana jaara maninia naana quiri, maninia jajau muetuyari. Naana jaara sesarunaja quiri, sesa jajau muetuyari. Naacuajitij, na jajaujiniji paari niishiyani taamueca naanatenojoni. ");
INSERT INTO arlNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Niaari juhua sacocua. ¿Niaatucua taa maninia pocuajaca quirini, niaa jaara pueyaracaanu sesa miijiaca quiyajaa? Paari poojiajiniji pa niishiriojosano pocuaquiaani. ");
INSERT INTO arlNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Naacuajitij, maninia jiuujiaraca pueyanoori saaja maninia casaa pocuaja. Sesa jiuujiaraca pueyano saniniuujia, sacuaraatia casaa pocuaari. ");
INSERT INTO arlNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nia sequeya cutaranijia, Pueyaso saniitionu juuca, pueyari puetunu najuhuana sesa na pocuasanojinijijianaa nequesoreesaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Cante maninia casaa pocuaja quiquiaarini, cunoori sequesaanutaniya “maninia pueyanota”. Naajuhuaj, cante sesa casaa pocuaja quiquiaarini, nojoriiri saniitiosaanutaniya saniniuujia. Naaratej, majaari nia niti nia taquiriocuatenu sacuaraatia casaa nia pocuanura. ");
INSERT INTO arlNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Noojiaqueya Moisés Rootasanojiniji niishitiojonaari tii quiriquiaa Fariseocuacata. Nojoriiri Jesu sequequiaari: —Niishitiojonanaa, jiyajeneta casaa quia miiri Pueyaso cumaacata canaa niquishocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesuuri nojori riucuaree: —Niaari sesoriquia pueya, Pueyaso tojiyashijiaca. Majaari nia niquiara casaa cua miiniu quiniutianiya Pueyaso cumaacata. Niaari saaja niquiriyatu cutara miishano niquiniutianiya taa supuetana Jonás miishaaquiaaricuaani. Cuno Jonásri Pueyaso sequesano caminiujiunia quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nojuajaari puereetuuca sapitiaaja seecojinia shocojotequiaari jiuujianaraca juuca, jiuujianaraca niucuanio. Naajuhuaj, janiyari raaco macu niojosaqui camueenujunutaniya jiuujianaraca juucani, jiuujianaraca niucuanio. ");
INSERT INTO arlNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jonás pohuatasacari Pueyaso rupaa Nínive tiacajinia, cuno tariucuacaanu taucuacaari noojia tacatoquiaari sesa nojori miishanojiniji. Cunora, Pueyaso nequesoreenu juuca quishacari, Nínive pueyari saneecuatunutaniya nojori tonujunura nio pa quishacari pueyacuara. Nojoriiri Pueyaso saquiriojotanutaniya nio pa quishacari pueyacuara, nojori ruuretanuucua tamonu Pueyaso sequesano caminiujiunia socua jiyaniijiajanaa cutara Jonásjiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Naajuhuaj, tariucuacaanu jiyaniijia maajiiri niquiaari tucuacaanuji pa supuetanaa jiyaniijia Salomón tojiniuucua. Cunoori quiquiaari jiyanohua niishijia Salomón quiniuucua. Cuno maajiiri pananu shuucuaji niquiaari Salomón na tojiniuria, jiyanohua tucuacaanu na jiyajiniji. Naaratej, Pueyaso nequesoreenu juuca quishacari, cuno maajiiri sanenutaniya na saquiriojotanura nio pa quishacari pueyacuara. Nojoriicuara saquiriojotanutaniyari nojori ruuretanuucua tamonu niishijia, socua niishijia Salomónjiniji cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Samaru jaara tohuatare pueyanojiniji, joojuashiquio rucuanejiyari na samaatejara na pajesacari. ");
INSERT INTO arlNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Jaara riuriataaquiri na samaatejara, naa niishiriojiyari: “Tacateyarohuaraqui tariucua cua quiquiojiniohua”. Jaara tacatemohua, cuno na pueyano riuriatasuhuari juhua camaruuju tia, netoosano, maninia jeenucuasano. ");
INSERT INTO arlNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Naaratej, samaruuri socua tamasaca narta samaruhua pajeya. Socua siete narta samaruhua riuriataari socua jiyanohua sesa nojuajiniji. Puetunu nojorijianaa jaara tiuquitiare cuno pueyanoocua tii na quiniuria, cuno pueyanoori na nuhuaji socua jiyanohua sesa quijiara jiyacateja. Naa quiniutianiyajaariuhua nio pa quishacari pueyara na tojitiaaquiniuucua janiya. Nojoriiri socua sesa quijiacara jiyacatenutaniuhua taa cua niyacarijia quijiaca nojori quiquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesu pohuatasacarijia pueya niquiara, na nucuaari tiuquiijioquiaari Jesu tapueyocuacata Jesuucua. Carijiniacuma quitiuriquiaari. Jesuta pocoojonu paniriquiaa juucuaari. ");
INSERT INTO arlNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tamonu pueyanoori Jesu sequeree: —¡Niishitiojonanaa! Quia nucuaqui quia tapueyocuacata carijiniacuma quiya. Quiata pocoojonu paniyaquiniaari. ");
INSERT INTO arlNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesuuri saaja na numootena pueyano riucuaree: —¿Cante cua nucuani? ¿Cante cua tapueyocuacani? ");
INSERT INTO arlNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jiyacaritij, Jesuuri canaa na tojitianaa pueya shishirii. Tii quiniaa pueya sequereeri: —Nio cua tojitianaani, nojori cutaraari juhua cua nucua, juhua cua tapueyocuaca cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Naacuajitij, cante cua Que Pueyaso panishano miiquiaa cutarani, nojuaja cutaraari cua tarajanu, cua rimiatu, cua nucuanio. ");
INSERT INTO arlNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Cuno juucaja, Jesuuri tohuataquiaari tiajiniji. Caminia casaqueyaji cajishiiri. Canaari nata quiriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jiyanohua queraatia pueyari nocua rerequeejoquiaari. Puera pueya quiniuucua, Jesuuri botejinia tacaquiaari. Tii cajishiiri. Puetunujuanaa pueyari jaaquiajinia jateequiaari, tiji na tojitianura Jesu canaata. ");
INSERT INTO arlNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesuuri queraatia casaa pueya maanu niishitiojoriquiaa miriqui. Naa pohuataquiaari puetunu canaajanaari: —Pueyanoori natoojonura quiaquiaari na cuhuariquiajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Na jacutasacari, secajaari nucuaco totequiaari. Shuhuari nocua rosetaquiaari. Puetunujuanaa nucuacoji na natau miojoquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tajaacaari totequiaari tamaqui sai tajiniaqueya. Majaari puera jiya quiniu quiquiaari tii. Naaratej, cuno natauri ritia moritiaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pananu jaara tacaquiaari, cuno natauri ritia sorequiaari maja puera nujuacaraca na quishacari. ");
INSERT INTO arlNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tajaacaari totequiaarijiuhua riyocuaca tajinia. Riyocuaca maashishacari, majaari cuno natau maashiniu quiquiaari maninia. Majaari na muetunu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Maninia jiyajinia totequiaariiri tajaaca saniniuujia. Tii moritiaquiaari maninia cutaraari. Maninia muetuquiaari cutaraari. Puetunu cuno jiyoneejinijijianaani, noojiaqueyari muetuquiaari cien jajau niquiriyatu jiyonaacua. Tamonu jiyoneeri muetuquiaari sesenta jajau niquiriyatu jiyonaacuajuhuaj. Socua tamonu jiyoneeri muetuquiaari treinta jajau. ");
INSERT INTO arlNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Niaa jaara numaaraca quiri, nia tojitiare cua pohuatasano. ");
INSERT INTO arlNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesuuri naa pohuataquiaari miriqui pueya niquiaratej. Na nuhuaji, canaa, Jesu saquiriojosano pueyani, canaari nocua catecanoquiaarini. Canaari na nequesotaquiaarini: —Jiyaniijianaa, ¿casaara pueya quia niishitiojoriquiaa miriquini? ");
INSERT INTO arlNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesuuri canaa riucuaree: —Pueyasoori nia saquiriojoquiaari, nia niishishoo casaa Pueyasojiniji nia niishiniuria, taa Pueyaso poonijiya pueya jiuujiajiniani, na muerasura nojori quiniuria shuquiriaatia. Tamasacara saniniuujia, majaari nio jiyasohuaja Pueyasojiniji niishishano nojori niishishocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Cante Pueyaso rupaa tojijia cutarani, nojuajaari socua niishitiojosaanutaniya, Pueyasojiniji jiyanohua na niishiniuria. Cante Pueyaso tojiyashijiani, shiitianiyojua Pueyasojiniji nojori niishishanoori puetunu jaariuutiasaanutaniyajanaa nojorijiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cunora, janiyari miriqui pohuatariquiaa nojori niquiarani. Naacuajitij, nojoriiri najuhuana niquiquiaa cua miishano na niishiyaquiniutia. Nojori tojishacari cua pohuatasano, na numaa shama tojitiuquiaa saajaari. Majaari quenaaja nojori niishiniu na tojishano. ");
INSERT INTO arlNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Naa nojori quiniuucuatej, tari tohuateereeri juhuacarijia supuetana Isaías sequesano nojorijiniji. Pueyara Pueyaso sequesano caminiujiunia na quiniuucua, nojuajaari naa sequequiaari pueyatej: “Niaari seetanujuanaa Pueyaso rupaa tojiniutianiya najuhuanaj. Majaari nia niishiniu quiniutianiya. Niaari Pueyaso miishano niquiniutianiya najuhuanaj. Majaari nia niishiniu quiniutianiya nia niquishano. ");
INSERT INTO arlNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nojoriiri cumajiuujiaaca quiya. Nojoriiri juhua numueeju, tojiyashijiaca. Nojoriiri juhua nimishitiu quiyajuhuaj. Naa juhua nimishitiu quitiuyari nojori niquiyaquiniuucuaji. Nojoriiri naa juhua numueejunucuajuhuaj, nojori tojitiaaquiniuucuaji noojiata. Naa quitiuyari nojori niishiyaquiniuucuaji noojiata, cucua nojori tacatenuhuara cua jeecanura nojori jiuujia seque”. ");
INSERT INTO arlNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Cua pueyanaa, niaari saniniuujia shuquiriaatia quiya maninia nia niishishacari cua miishano, nia tojishacari cua pohuatasanojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Seetanujuanaa nia sequeyanijia, queraatia tariucuacaanu pueyari quiarijia nia niquishano niquiniuucua jiaatiaquiaari juucua. Naa nio niquiniuucua jiaatiaquiaariiri tariucuacaanu Pueyaso sequesano caminiujiuniaa, queraatia maninia pueyanio. Majaari nojori niquiniu quiquiaari saaja. Nojoriiri nia tojishano tojiniuucua jiaatiaquiaari juucuajuhuaj. Majaari nojori tojiniu quiquiaari saaja. ");
INSERT INTO arlNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Nia pohuatareera nia niishiniuria cua pohuatasano natoojojuajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Canapuete Pueyasojiniji cua pohuatasano niishiyaquiyani, nojoriiri juhua nucuaco toteno jajau. Sesaacaari niquiaa. Pueyaso Rupaa jaariutiaa noojiajinijiiri. ");
INSERT INTO arlNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Noojiaqueya pueyari juhua sai tajiniaqueya jacutasano jajau quiquiaa. Naaratej, nojori jaara shuquiriaatia tojiri Pueyaso Rupaa, nojoriiri ritia shitimia nocua tiuuquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nojoriiri juhua nujuacaaju. Majaari cumaatia na nujuatunu. Naaratej, nojori jaara naquiya miishaare Pueyaso Rupaa tojijiaca nojori quiniuucua, nojoriiri ritia Pueyaso tojiniu tarinitiaquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Noojiaqueya pueyari juhua riyocuaca tajinia toteno jajau quiquiaa. Nojoriiri Pueyaso Rupaa tojirii. Na nuhuaji, nojoriiri saaja puera tacaaquiaa nio jiya casamiicua. Naajuhuaj, nojoriiri sapojosaaquiaa nojori jiyanishacari nojori jaara queraatia casamiriaca quiriquia, nojori maara shuquiriaatia quiriquiaj. Cunora, Pueyaso Rupaari maja na naata poonijionu nojori jiuujiajinia. Naacuajitij, cuno pueyari juhua natau muetuhuo quiquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Saniniuujia, cante maninia tojijia Pueyaso Rupaani, maninia na niishiyari. Cunoori juhua jiya maniniujinia jacutasano jajau. Naacuajitij, cuno pueyari juhua maninia natau, maninia muetuna cutara. Jiyanohua maninia pueyari quiquiaa na tojishacari Pueyaso Rupaa. Naaratej, tamonuuri juhua cien jajau muetujua. Tamonuuri juhua sesenta jajau muetujua. Tamonuuri juhua treinta jajau muetujuajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesuuri tamonu miriqui pohuatasano pohuataquiaari pueya niquiara, nojori na niishitiojonura taa Pueyaso tojitiaashijiaca pueya quiniutianiya Pueyaso muerasu tajiniani. Jesuuri naa pueya pohuataquiaari: —Tamonu pueyanoori maninia jajau nataquiaari na cuhuariquiajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Puetunu pueyajanaa jaara niucua maqueturiquiaa, na paracaari jiyacari niquiaari. Sesa jiyasocua jajau jaquerooquiaari trigo natasano cuhuariquiajiniaari. Na natanu nuhuaji, tacateyarohuari. ");
INSERT INTO arlNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo jajauri maashiquiaari. Na nuhuaji, na jajau mueratuusacari shusha, sesa jiyasocuaari mariyata niquishaaquiaari maashiyano. ");
INSERT INTO arlNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Cuhuariquia camaru seyari quiaquiaari na camarujuanaa nojori sequenura: “Jiyaniijianaa, ¿majateeri maninia saquiriojosano jajau quiquianucuaja quia natasano cuhuariquiajiniani? ¿Teje cuno sesa jiyasocua moritiarucuaa quia natau tajiniacuaraarini?” ");
INSERT INTO arlNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Cuhuariquia camaruuri nojori riucuaree: “Pa paracaari cunohuaj, naa pa miiriucuaani”. Na seyari na nequesotaree: “¿Quiaate paniya canaa quianura cuno jiyasocua jayotanura trigo tajiniaqueyajiniji?” ");
INSERT INTO arlNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Na seya sequeree saajaari: “Maja. Maja nia jayotanu jiyasocua, niaa mariqui trigo na cojiritiareeri. ");
INSERT INTO arlNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Naajaa, nia tarinitiare cuaara maashiiria, mariyata cuaara noshiiriajaara trigo jajau. Na nuhuaji cutara janiyari senoonaa jiyaronutaniyani, cuaara coteenu jiyasocua namirioora, nojori jiuniocojonura jiyasocua catijiasocoriquiano. Na nuhuaji cutara, cuaara trigo jajau racatatuura nataco”. ");
INSERT INTO arlNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesuuri socua miriqui pohuataquiaari pueya niquiara, na niishitiojonura taa Pueyaso poonijiya pueya jiuujiajiniani, nocua nojori tiuushacari. Naa sequereeri: —Tamonu pueyanoori mostaza jajau nataquiaari na cuhuariquiajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Seetanujuanaa mostaza jajauri socua jiyanohua shiitianiyojua puetunu tamonu jajaujinijijianaa. Naajaa, cuno mostaza jaara maashiri, socua puereetuucara maashijiaari narta nataacuacajiniji. Naacuajitij, shuhuari na cashacucuaacua jesuya. Naajuhuaj, pueyano tojishacari Pueyaso rupaa, seetanujuanaa maninia Pueyaso muerasura jatanishiyari. ");
INSERT INTO arlNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesuuri nio miriqui pohuatasano pohuatarohuacuhua pueya niquiara, taa Pueyaso Rupaa poonijiya mijiriani. Nojori sequereeri: —Pueyaso rupaari jiyanohua cumaacaraca na poonijionura juhua pan poreetaja. Maaji jaara pan poreetaja cojitiri jiuujianaraca shiitianiyojua tohuatashi mishaja trigo cashojuata, puetunujuanaa na poreeteyari. Pueyaso rupaari naa cumaacaracajuhuaj, pueya na jataniniuria quiariniora. ");
INSERT INTO arlNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Puetunu Jesu pohuatasanojuanaa pueya niquiarani, miriqui sequesanoori quiquiaari. Puetunu na pohuatasanojuanaari naa quiquiaaritij. ");
INSERT INTO arlNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Naacuajitij, maninia tohuateequiaariiri tariucuacaanu pueyara Pueyaso sequesano caminiujiunia sequesano, jaara nio naajiotaquiaari: “Pueyasoori naa sequeyaquij: ‘Janiyari pueya niishitiojonutaniyani saaja miriqui cua pohuatasanota. Naacuajitij, janiyari pueya pohuatanutaniya pueyaracaanu nojori niishishoo casaani, shusha jiya shipinishaanujiniji’”. ");
INSERT INTO arlNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Na nuhuaji, Jesuuri pueya maanu sequeree: —Tariucuaja pueyanaa. Nia quiojorohua. Na nuhuaji, nojuajaari na quijia tiajinia tacaarohua. Jiyacaritij, canaa, na saquiriojosano pueyani, canaari nocua catecanoquiaarini. Canaari Jesu sequereeni: —Canaa quia niishitirijia miriqui quia pohuatasano cuno sesa jiyasocuajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesuuri canaa sequeree: —Janiyacuajaari cunoni, maninia jajau natoojojuani. ");
INSERT INTO arlNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nio jiyari juhua cuno cuhuariquia. Pueyaso muerasuuri juhua cuno maninia jajau, cuhuariquiajinia natasanoni. Tamasacaari saniniuujia Sesaaca muerasu quiya. Nojoriiri juhua cuno sesa jiyasocua, cuhuariquiajinia natau tajinia maashinioni. ");
INSERT INTO arlNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sesaacaari juhua cuno cuhuariquia camaru paraca. Nojuajaari cuno sesa jiyasocua nataquiaari. Nio jiya puequesacariiri juhua cuhuariquia senoosacari quiniutianiya. Jiyocuacaanuji Pueyaso seyari juhua cuhuariquia senoonaa quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Naatej, taa sesa jiyasocua namitiashiya catijiasocoriquianocuaani, naa quiniutianiyajaariuhua nio jiya puequesacari. ");
INSERT INTO arlNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Janiyari cua seya jiyaronutaniya jiyocuacaanujini. Nojoriiri sesa miijiaca quioonutaniya, mariyata canapuete tamasaca miitiquiaa sesani. ");
INSERT INTO arlNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nojoriiri quejoosaanutaniya mani quiquiojinia. Nojoriiri tii sapuenutaniya pueyaracaanu. Naquiya na miishacari, na quiaca miaquenutaniyari. ");
INSERT INTO arlNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Na nuhuaji, Pueyaso tojitiajacaari jiyanohua shacantuucara quiniutianiya juhua pananu, na Que Pueyaso jiitiasacari nojori pueyaracaanu. Cante numaaracani, cuaara tojitiaara cua sequesano. ");
INSERT INTO arlNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesuuri canaa na pueya pohuataquiaari miriqui, Pueyaso muerasu pa quiniuni, cunoori jiyanohua panishano. Nojuajaari naa sequequiaaritij: —Tamonu pueyanoori tamasaca cuhuariquia tajiriquiaa juucua. Casaa riuriatamaari, jiyanohua panishano casaa. Tiijia na jamorohuari tee na quiriquiaacuajani. Jiyanohua na shuquiritiasacari na riuriatasano casaa, puetunujuanaa tama na casamijiaaja niquitiojoreeri queraatia cumaneeca na jiitianura. Na nuhuaji, puetunu na cumaneecajanaa pataareeri cuno cuhuariquia camaruucua, cuno cuhuariquia na masenura. Naacuajitij, cuno jiyanohua na panishano casaari tama na casaara quiquiaarijiaaja. Naajuhuaj, socua jiyanohua panishano cutaraari, Pueyaso pueyanora nia quiniuria. Cunoori jiyanohua socua panishano puetunu pa panishano casaajinijijianaa. ");
INSERT INTO arlNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Socua nia tojiri nio pohuatasano. Casami niquitiojonaari pueyaracaanu rucuanejoriquiaa shanohua cohuajaaca tiujiau na pajenura. Cunoori noturu shipinijiosano sai quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tamonu juuca, jiyanohua shanohua noturu saajia niquitishaaquiaariiri. Jiyanohua na panishano. Naaratej, puetunu na jiitiasanojuanaa niquitiojoquiaariiri, cumaneeca na jiitianura, cuno na panishano casaa na masetajara. Na nuhuaji, puetunujuanaa na casami samitia masequiaari cuno noturu saajiaari, jiyanohua na panishanoni. Naajuhuaj, nia tarinitiare puetunu nia panishano casaajanaa, Pueyaso pueyara nia quiniuria seetanujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Pueyaso Rupaari juhua puereetuuca shiyaru na camaru jartasano caminiajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jaara mishaja quiquiaari sapitiaajata, pueyari na jayotaquiaari jaaquiajiniara. Queraatia tamaatiuniucua sapitiaajaari tii quiriquiaa. Pueyari jaaquiajinia cajitiuquiaari saaja maninia sapitiaaja nojori saquiriojonura. Canaasatujinia na niojotureeri racatasocoriquiano. Sesa sapitiaajaari saniniuujia jacutasaaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Naa quiniutianiyajaariuhuaj jiya puequesacari. Naacuajitij, Pueyaso seyari rosetanutaniya, sesa miijiaca na saquiriojonura maninia pueya tajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na nuhuaji, sesa pueyari quejoosaanutaniya mani quiquiojinia, taa sesa sapitiaaja jacutasaaquiaaricuaani. Nojoriiri tii sapuenutaniya. Na quiaca miaquenutaniyajaariuhua naquiya na miiniutia. ");
INSERT INTO arlNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesu pohuatanu puecasacari, canaa na pueya nequesotaquiaariiri: —¿Niaate maninia niishirii puetunu cua pohuatasanojuanaacuaja? Canaari Jesu riucuareeni: —Taaquiriirinij Jiyaniijianaa. ");
INSERT INTO arlNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesuuri canaa sequeree: —Maniniacuajaqui. Tariucuacaanu Pueyaso Rupaajiniji niishitiojona jaara quiarinio cua niishitiojosano Pueyasojiniji niishirijiuhuaj, nojuaja cutaraari Pueyaso Rupaa niishijia seetanujuanaa. Nojuajaari juhua tia camaru, cante tariucuacaanu shanohua casamiriacacuajani, quiarinio casamiriacajuhuaj, na tiajiniaaco racatasano. Na panishacari, na camaruuri na racatasanojiniji na panishano rijia. ");
INSERT INTO arlNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesu jaara puecaquiaari miriqui pohuatanu, tiji quiaquiaariuhuari. Canaari na nuhuajiriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Canaari na maashijia tiacajinia tiuquiquiaariuhuani. Canaa tiuquiijiosacari, canaari Pueyaso secojojua tiajinia tiuquiquiaarini. Jesuuri tii pueya niishitiojonu coteequiaari. Pueyari jiuujiatequiaari na niishitiojosano nojori tojishacari. Nojoriiri tama sequequiaarijiaaja: —¿Taa nio pueyano niishiya puerajaarani? ¿Tejenotejaara na cumaacani, cusosuhua na naatanijionurani? ");
INSERT INTO arlNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Na shipininiocuajaari suruhuatujiniji casaa shipinijiona quijia. Na nucuacuajaari María. Na tapueyocuacaari Santiago, José, Simón, Judasnio. ");
INSERT INTO arlNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na rimiatuhuari mariyata niya pa tajinia quiya. ¿Taa na niishiya pueraarini? ");
INSERT INTO arlNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Naaratej, pueyari na ruuretaquiaari saaja. Naa na tiacajinijinio pueya tojitiaaquishacari nojuajatej, Jesuuri nojori sequequiaari: —Puetunu tiquiyocua pueyajanaari maninia tojitiaquiaa cutara Pueyaso sequenu panishano caminiujiunia. Saaja narta pueya tama na jiyajinijiniojuaarijia na tojitianu paniyaquiya, tama na tiajinijiniojuaaja pueyanio. ");
INSERT INTO arlNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Naa nojori ruuretanuucua Jesutej, majaari puera na cumaacata na miiniu quiquiaari tii, nojori tiuyaquiniuucua nocua. ");
INSERT INTO arlNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Cuno quishacari, Galilea jiya jiyaniijia Herodesri pohuatasaaquiaari Jesu miishanojiniji na cumaacata. ");
INSERT INTO arlNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodesri na seya sequequiaari Jesujiniji: —¡Nojuacuajaari cua mosano Tiuquinijiona Juan! ¡Samiitiarohuacuaaqui! Naacuajitij, jiyanohua cumaaca jiitiaari, jiyajeneta casaa na miiniuria Pueyaso cumaacata. ");
INSERT INTO arlNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodesri naa sequequiaariti na monuucua Tiuquinijiona Juan. Nojuajaari naa miiquiaari Juantej: coteenu na quiatequiaariiri. Na morojoquiaariiri cumayocua shipinishano jiyocuata. Na nuhuaji, na nujuatequiaari nujuatejojuajiniaari. Herodesri naa miiquiaari na juaaniutia Juantej, Juan nacasunuucua nojuaja, Herodes quiniuucua tarajanu Felipe niquiocuata. ");
INSERT INTO arlNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tiuquinijiona Juanri naa Herodes sequequiaari quiasano na quiyaquishacarijia: —¡Quiaari Pueyaso tojiyashijia! ¡Majaari maninia quia quiniuria Herodíasta! ¡Nojuacuajaari quia tarajanu Felipe niquiocua! ");
INSERT INTO arlNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodesri cunora Juan monu paniriquiaa juucua. Judiocuaca puereriquiaa saajaari. Judiocuacaari niishiquiaari cutara, Juanri seetanujuanaa Pueyaso sequenu panishano caminiujiunia quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tiuquinijiona Juan nujuasacarijia nujuatejojuajinia, Herodesri na rasaanu juucajinia queranacuquiaari na masuusano pueyata. Jiyacaritij, cuno maaji Herodías niyatuuri nianujuquiaari Herodes masuusano pueya niquiara. Jiyaniijia Herodesri jiyanohua na shuquiritiaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Naaratej, Herodesri necanuru sequequiaari puetunu pueya niquiarajanaa: —Sanaunaa, cua sequere casaa quia paniyani. Janiyacua quia niquitiore quia panishanoni. ¡Seetanujuanaa quia sequeyanijia! Majaari cua rupaa cua jatanu quiniutianiya. ¿Casaa quia paniniutianiyani? ");
INSERT INTO arlNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jiyacaritij, niyacoo nucua Herodíasri neyatu rootaquiaari jiyasohuaja, casaa na masenutaniyani. Naaratej, niyacoori jiyaniijia Herodes sequesee: —Cua quenunaa, cua niquitiore Tiuquinijiona Juan naca miacojuajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jiyaniijia Herodesri taraajequee niyacoo sequesano na tojishacari. Naajaa, majaari na naata na rupaa jatanu quiquiaari, seetanujuanaa na sequenuucua na masuusano pueya niquiara. Naacuajitij, Herodesri na seya sequequiaari cuaara niquitiosaarianoj. ");
INSERT INTO arlNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Naaratej, na pueyano jiyaroquiaari nujuatejojuajiniaari, Tiuquinijiona Juan na nacatanura. ");
INSERT INTO arlNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na nuhuaji, Juan nacaari patasaaquiaariuhua miacojuajinia. Niyacoo niquitiosaasuhuari. Niyacoori saniniuujia na nucuaacua na pataquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na nuhuaji, Tiuquinijiona Juan pueyari quiojoquiaari na quete na panura. Na jamotuquiaariiri. Na nuhuaji, nojoriiri nijioquiaari Jesu pohuatanuucua Tiuquinijiona Juanjiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesu tojishacari Tiuquinijiona Juan tari mosaarucuaa, nojuajaari canaa jiyataquiaari botejinia tamaquiria, pueya quiyaquishaquiria. Pueya jaara niishiquiaari tee Jesu quiaareeni, queraatia pueyari cuno jiya tiacajiniji quiojoquiaari tiriarajuhuaj. Nojoriiri na neteyotaquiaari nucuaco caminia shuriuquioco. Cuno pueyari canaacuaji cutesee. ");
INSERT INTO arlNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Naacuajitij, Jesu rosesacari botejiniji, jiyanohua queraatia pueya niquishii saajaari. Nojoriicua taraajereeri. Cuno pueya patootasano cusosuhua naatanijioreeri. ");
INSERT INTO arlNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tariucua tenacari, canaa, Jesu saquiriojosano pueyani, canaari nocua niquiaarini. Canaari na sequereeni: —Canaa Jiyaniijianaa, paa niya quiya pueya quiyaquishaquini. Paari nininiutianiyani. Juhuacarijia pueya quia sequere nojori cuaara quiojohuara tiacajinia, na miaquesocoriquiano nojori masenura. ");
INSERT INTO arlNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesuuri canaa sequeree saaja: —¿Maatucua casaara quiojiyarohuani? Niaa mariqui nojori mianuutere saniya. ");
INSERT INTO arlNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Canaari Jesu sequereeni: —Maja canaa jiitianu miaquesano. Niya quiya saajaari cinco pan, caapiqui sapitiaajanio. ");
INSERT INTO arlNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesuuri canaa sequeree: —Miji nia patare. ");
INSERT INTO arlNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesuuri sequeree pueya cuaara cajitiuuria jiyasocuajinia. Na nuhuaji, Jesuuri cuno pan pataree, sapitiaajanio. Jiyocuacaanu maureeri na Queecuara, miaquesanoocuara na secojonura. Na nuhuaji, Jesuuri pan neecasequiaari queraatiara. Canaa na niquitiojoreeri puetunu pueyajanaa canaa niquitiojosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Puetunu pueyajanaari miaquenuuquiaari. Maninia tooquioreeri. Nojori puecasacari miaquenu, canaari pan neeca reratequiaariuhuani, sapitiaaja raquiquianio. Doce canaasatuuri mishinijiosaaquiaari na raacuata. ");
INSERT INTO arlNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jiyanohua queraatia pueyari miaquenuuquiaari; cinco mil quiquiaari saa canuujua. Majaari maajipohua serojosaanu quiquiaari, naatujoorinio. ");
INSERT INTO arlNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Na nuhuaji, Jesuuri canaa na saquiriojosano pueya secootequiaari botejinia canaa tacatanura, canaa puetanuracuaa nojuaja caminia taquijiria. Jesuuri jiyacari pueya maanu sequeriquiaa nojori quiojonuhuara. ");
INSERT INTO arlNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pueya jaara tari quiojoquiaariuhua, Jesuuri tuhuananuucua tacaquiaari tamajaaja, na Que Pueyaso na secojonura. Jaara niniquiaari, Jesuuri tii quiriquiaa tamajaaja. ");
INSERT INTO arlNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Canaari saniniuujia caminia jiuujiajinia tari jaaretariquiaacuaani. Mohuacaari saaja canaacuara cajiniuucuariquiaa, paratu piyarojosacari canaacuara. ");
INSERT INTO arlNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Juhuaquenu panishacari, Jesuuri canaa rupuesee mohuaca caco na rucuanenuta. ");
INSERT INTO arlNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","¡Canaa niquishacari casaa mohuaca caco rucuaneyano, canaari jiyanohua shiriiquitiuriini! Canaari sariyocuatureeni. —¡Yae! ¡Samaruruhua! ");
INSERT INTO arlNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesuuri ritia pocuaree. Canaa sequereeri: —¡Nioojia nia cumaquiri! Janiyacuajanijia. Maja nia puerenu. ");
INSERT INTO arlNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Canaa tojishacari Jesu, Pedroori Jesu sequeree: —¡Jaara seetanujuanaa quiajaniya quiri Jiyaniijianaa, cua sequere quiocua cua quianura mohuaca caco! ");
INSERT INTO arlNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Pedro sequereeri: —Mijicuarajaj. Pedroori ritia rosequiaari botejiniji. Mohuaca caco rucuanenu coteequiaariiri Jesuucua na quianura. ");
INSERT INTO arlNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Na niquishacari paratu jiyanohua piyarojiyano, Pedroori puerequiaari. Na pueresacari, moo cariquimia tiuquiniu coteequiaariiri. Nacareeri: —¡Jiyaniijianaa cua quiare! ");
INSERT INTO arlNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesuuri ritia Pedro juaashiquiajiniji quiaree. Na sequereeri: —Pedronaa, majaqui puera quia tiuuniu cucua. ¿Casaara cua sequesanoocuaji quia taacanuureeni? ");
INSERT INTO arlNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","¡Nojori jaara botejinia tacataquiaariuhua, paratuuri jiyacari pueyajequee! ");
INSERT INTO arlNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Canaa niquishacari naa Jesu miishano na cumaacatatej, canaari Jesuucuara mojoquetacoquiaarini. Canaari na sequereeni: —¡Quiaaqui seetanujuanaa Pueyaso Niyanu! ");
INSERT INTO arlNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Canaa jaara caminia taquijiria niuutiaquiaarini, canaari Genesaret jiyajinia shiitiaseeni. ");
INSERT INTO arlNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Genesaret pueya jaara niishiquiaari Jesu tiuquirii, nojoriiri puetunu na jiyajiniajanaa pueya numootequiaari, cuaara patootasaaria cusosuhua Jesuucua. Naacuajitij, Jesuucua patootasaaquiaariiri puetunu cusosuhuajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pueyari Jesu sequetuquiaari: —Nareja quia shanacure cusosuhua quiocua, nojori cuaara quia tucuaque toque quiaara quenaaja, nojori naataconuhuara. Jesuuri naa miirii. Puetunu na toque quianaajanaari naatacoquiaariuhua na cusonujiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na nuhuaji, Jerusalén tiacajinijinio pueyari canaacua tiuquiijioquiaari Jesuta pocoojonura. Nojoriiri quiquiaari Fariseocuaca, Moisés Naajioneejiniji niishitiojonaanio. Jesu sequetureeri: ");
INSERT INTO arlNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Quia pueyari shuquitioojua miaquenuuquiaa. ¿Casaara nojori tojitiaaquiquiaa canaa niishitiojosano pa supuetanaajinijini? ¡Nojori cuaara miiria taa pa supuetanaa miiquiaaricuaani! ");
INSERT INTO arlNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesuuri nojori nequesotaree saniniuujia: —¿Niajaniyariuhuaj? ¿Casaara nia tojitiaaquiquiaa saniniuujia Pueyaso Rupaani, nia supuetanaa jiitishano miiniu nia miiniuriani? ");
INSERT INTO arlNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Pueyasocuajaari sequequiaari: “Quia que tojijia quia quiri, quia nucua tojijianio. Majaari nojori rerequetenu”. Naacuajitij, maninia pa cojuare pa queya. Pueyasoori sequequiaarijiuhuaj: “Cuaara mosaaria cante na que sesacajani, na nucua sesacajanio”. ");
INSERT INTO arlNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Niaari saniniuujia sequequiaacujua, maniniacuajaari pueyano jaara na queya sequere: “Cua quenaa, cua nucuanaa, janiyari Pueyasora niquitionutaniya cua casamini. Naacuajiti majaari cua naata nia naacunu cua jiitiasano casamitia”. ");
INSERT INTO arlNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Naa nia niishitiojosacari pueyatej, niaari pueya tarinitiya na queya nojori cartenura, naacusoo nojori quiniuria. Naa nia tojishacari tama nia niishitiojosanojuaaja juhua nia supuetanaa nia miiniuriatej, niaari Pueyaso Rupaa jiyateya najuhuanara. ");
INSERT INTO arlNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Sapuenu Pueyaso Rupaa tojitiajacanaa! Supuetana Isaíasquiiri maninia naajiotaquiaaricuaja niajaniyajiniji, na caminiujiushacari nio rupaa Pueyasojiniji: ");
INSERT INTO arlNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Nio pueyari saa na rupaataja cua maniniuhuaqueetaquiaa. Nojori jiuujiaari saniniuujia tucuacaanu quiya janiyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nojoriiri najuhuana rerejoquiaa na maniniuhuaqueetanura janiya. Nojori niishitiojosanoori tama nojori niishishanojuaaja, maja cua rupaa”. ");
INSERT INTO arlNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Na nuhuaji, Jesuuri puetunu pueyajanaa sequeree: —Miji, niya cua tojitiaseecuarajaj maninia nia niishiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Pa miasanoni, cunoori maja sesara na jiyatenu poojia. Pa rupaata pa pocuasano sesani, cuno cutaraari poojia sesojua. ");
INSERT INTO arlNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jiyacaritij, canaa, Jesu saquiriojosano pueyani, canaari nocua catecanoquiaarini naa canaa sequenura nojuaja: —Jiyaniijianaa, ¿quiaate niishiya Fariseocuacaari juaaquioree naa quia sequesacaritij? ");
INSERT INTO arlNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesuuri canaa riucuaree: —Naajaa. Cuaara juaaquioora. Cuno pojoriiri juhua sesa jiyasocua, Sesaaca natasano cua Que cuhuariquiajinia. Nojoriiri juhua sesa jiyasocua jayotasaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Seetanujuanaa Pueyaso niishiyashijiaca nojori quishacari, nojoriiri juhua cariyojuaru quiya. Narta cariyojuaru jaatucuyari. Cariyojuaru jaara narta cariyojuaru jaatucure juucua, nojoriiri mariyata raama totenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedroori Jesu sequeree: —Jiyaniijianaa, canaa quia niishitiojoreja casaa quia sequenu paniriquiaa quia pohuatasacari pa miasanojinijini. ");
INSERT INTO arlNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Pedro riucuareeri: —¿Niaateeri na niishiyaquiyajuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Majateeri nia niishiniu, pa miaquesano pa rupaataari pa seecojinia tiuquiya saaja? Na nuhuaji, pa marecuhuacuma tajimiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Saniniuujia, pa rupaata pa pocuasano sesani, cunoori poojiajiniji tohuataa cutara. Naacuajitij, pueyanoori sesa quiya Pueyaso niquiara, sesa casaa na pocuanuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pueyano jiuujiajinia coretaari puetunu sesa niishiriojosanojuanaa: monu paniniu; na camishoo maajipohua numuetucunu paniniu; saaja numuetucunuucua jiaatianu; nohuasejonu paniniu; sapojonuta saquiriojotanu paniniu; sacuaraatia coriaacojonu paniniu. ");
INSERT INTO arlNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Puetunu naa sesa pueya niishiriojosanojuanaa cutaraari pueyano sesojua. Saniniuujia, pueyano jaara miaquere shuquitioojua, naajaa. Cunoori maja na sesonu pueyano Pueyasora. ");
INSERT INTO arlNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesuuri Genesaret jiyajiniji quiaquiaari canaa na pueyata. Canaari quiojoquiaari tamonu taucuaca jiyajiniarani. Cuno jiyajinia quiquiaariiri Tiro tiaca, Sidón tiacajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Canaa rucuanejosacari tii, cuno jiyajinijinio taatuuri Jesuucua niquiaari. Nojuajaari Cananeo pueyajinijinio maaji quiquiaari. Jesu nuhuaji nacariquiaari: —¡Jiyaniijianaa, cucua quia taraajere! ¡Pueyaso Jiyarosanonaa, cucua quia taraajere quenaaja! Quiyatu samaru jiitiaa. Jiyanohua taraatia na miiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesuuri maja na riucuanu quiquiaari. Sanaa canujuriquiaa saajaari. Naaratej, canaari Jesu catecanoquiaarini canaa sequenura nojuaja: —¡Jiyaniijianaa, na panishano quia miiri cuaara quiohuara! ¡Taajeta nacaa pa nuhuajini! ");
INSERT INTO arlNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesuuri canaa riucuaree: —Janiyari saaja Israel pueyacua jiyarosaaquiaarini. Nojoriiri juhua borregohua tashuquioono. Nojoriicua taraajeyanijia. ");
INSERT INTO arlNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Cuno maajiiri Jesu sequesano tojirii. Naajaa, Jesu cariquimiaji mojoquetaseeri. Na sequereeri: —¡Jiyaniijianaa, cua naacutare! ");
INSERT INTO arlNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesuuri na riucuaree: —Majaari maninia pa jaariutianura pa niquiohua miaquesano, sare niquiohua niquitiosocoriquiano saniniuujia. ");
INSERT INTO arlNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Maajiiri saaja na sequeree: —Maniniacuaja quia sequesano Jiyaniijianaa. Naajaa, sareyaniyojuacuajaari miaquesano shiriya miaquenuuquiaa, na camaru totinijiosano na miaquejajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesuuri maaji sequeree: —Maniniacuaja quia sequesano maajiniaa. Quiaaqui jiyanohua cucua tiuya. Cuaara quiiriaqui taa quia paniyacuajani. Jiyacaritij, neyatuuri naataquiaariuhua. ");
INSERT INTO arlNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Canaari Jesuta cuniquiji quiaquiaariuhuani. Canaari Galilea caminia shuriuquioco tajimiaani. Canaari tuhuananuucua tacatamaani. Jesuuri tii cajishii. ");
INSERT INTO arlNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Queraatia pueyari nocua nijioquiaari. Nojoriiri queraatia cusosuhua niojotaquiaari Jesu shuriucua, nojori tiacajiniji nojori patootasano. Cusosuhuari quiquiaari shipiiniquiujiuniaa pueya, cariyojuarujurinio, tiquianucuajuhuaj, sesarunecatohuanio, socua queraatia tamaatia cusosuhuanio. Jesuuri nojori naatanijioquiaari puetunujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pueyari jiuujiatequiaari nojori niquishacari tiquianucua pocoyano, shipiiniquiujiuniaa rucuaneyano maninia, cariyojuarujuri niquishacari maniniajuhuaj. Naajuhuaj, sesarunecatohuari maninia numatucuaraca quiquiaariuhua. Naa pueya niquishacari Jesu miishanotej, nojoriiri Pueyaso maniniuhuaqueetaree. Sequetureeri: —¡Jiyanohua maninia Israel pueya Pueyaso! ");
INSERT INTO arlNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na nuhuaji, Jesuuri canaa na saquiriojosano pueya sequeree: —Miji pueyanaa. Nio pueyacua taraajeyanijia. Nojoriiri tari jiuujianaraca juuca camueenujiya niya pata. Majaari nojori jiitiatunu quenaaja casaa na miaquetusocoriquiano. Majaari cua jiyaronu paniniu miaqueyojua nojori, nojori mariqui na miaajenuta cusojoniuyarohua nucuacoori. ");
INSERT INTO arlNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Canaari Jesu nequesotareeni: —¿Canaatucua tee riuriatare queraatia miaquesano nio queraatia pueyarani? Niya, majaari pueya quiniu quenaaja. ");
INSERT INTO arlNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesuuri canaa nequesotaree: —¿Taa pan nia jiitiaani? Canaari na riucuareeni: —Canaa saaja siete pan jiitiaani, secaja sapitiaajaniyojuanio. ");
INSERT INTO arlNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesuuri pueya sequeree na cajitiuniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na nuhuaji, Jesuuri cuno siete pan pataree, sapitiaajanio. Jesu jaara na Que secojoquiaari coteenu miaquesanoocuara, na nuhuaji na neecasequiaariiri canaa niquitiojonura pueya. ");
INSERT INTO arlNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","¡Puetunu pueyajanaari maninia miaquenuuquiaari! Tooquioreeri. ¡Canaari miaquesano cureenota mishinijioquiaari siete canaasatuni! ");
INSERT INTO arlNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Queraatia pueyari na miaquenuuquiaari. ¡Saaja canuuri serojosaaquiaari cuatro mil pueya! Majaari maajipohua serojosaanu quiquiaari, naatujoorinio. ");
INSERT INTO arlNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Na nuhuaji, Jesuuri pueya sequequiaari nojori quiojonuhuara. Na nuhuaji, Jesuuri canaa jiyataquiaari botejinia Magdala jiyajiniara. ");
INSERT INTO arlNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseocuacaari Saduceocuacata Jesuucua nijioquiaari nojori saniniujiuniuria nojuaja. Nojoriiri Jesu sequequiaari: —Casaa quia miiri quia cumaacata canaa niquishocoriquiano, canaa niishiniuria quiaate seetanujuanaa Pueyaso jiyarosano. ");
INSERT INTO arlNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesuuri nojori sequeree saaja: —Jiya jaara naatuuca quiri pananu tiuquishacari, niaari sequequiaa: “Maninia juucaqui tariqui quiniutianiya”. ");
INSERT INTO arlNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Naajuhuaj, pananu jaara tariquiicuaji jama, niquitioocua jaara niquishaarejuhuaj, niaari sequequiaa: “Maruqui niniutianiya”. Niaari naa niishiquiaa taamueca juucate quiniutianiyani jiya nia niquishacari. ¡Mosanucuanaa! ¿Casaara saniniuujia nia niishiyaquiya casaa Pueyaso niishitiojiya juucua niajaniyani? Nojuacuajaari juucua na cumaacata na miishano miiquiaa nia niquiara najuhuanaj. ");
INSERT INTO arlNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jesuuri nojori niquiara sequereejuhuaj: —Nio sesoriquia pueya, Pueyaso tojitiaashijiacani, nojoriiri Pueyaso cumaacata cua miishano niquiniu paniya juucua. Majaari nojori niquitishaanu quiniutianiya socua. Nojoriiri saaja nio niquiriyatu Pueyaso cumaacata miishocoriquiano niquiniutianiya: janiyari miishaanutaniyani taa supuetana Jonás miishaaquiaaricuaani. Naa Jesu sequenu nuhuajitij, nojori tarinitiaqueeri. Canaari quiaqueeni. ");
INSERT INTO arlNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Canaa niuutiasacari caminia taquijiria, canaari canaa coseyaca panu niyajetaquiaari canaa sasocoriquianoni. ");
INSERT INTO arlNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jiyacaritij, Jesuuri canaa sequeree: —Niishijiaca nia quiri. Tama nia cuaqueyajaaja nia cojuare Fariseocuaca pan poreetajaacuaji, Saduceocuaca pan poreetajaacuajinio. ");
INSERT INTO arlNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Cunora, canaari tama sequetooreejaanijia: —¿Casaa na sequeyani? Pan pa paaquiniuucua naa pa sequeya jiyoteeri. ");
INSERT INTO arlNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesu niishishacari naa canaa sequesanotej, canaa sequereeri: —¿Majateeri juhuanojuaja cucua nia tiuuniu maninia? ¿Casaara tama nia pocoojiyajaaja panjinijini? ");
INSERT INTO arlNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Majateeri juhuanojuaja nia niishiniu tari cua miishanojiniji? ¿Niaateeri tari niyajetarucuaa taa canaasatu mishajate cureecanuni, cinco mil canuu jaara miaquenuucanu cinco panjinijitij? ");
INSERT INTO arlNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Niaa jiyoteeri niyajetarucuaajuhuaj taa canaasatu mishajate cureecanuni, cuatro mil canuu jaara miaquenuucanu siete panjinijitij. ");
INSERT INTO arlNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Casaara nia jiyaniriini janiya miaquesanojiniji sequeriquiaani? Maja cua sequenu panjiniji. Nia sequeriquiaanijia tama nia cuaqueyajaaja nia cojuare Fariseocuaca pan poreetajaacuaji, Saduceocuaca pan poreetajaacuajinio. ");
INSERT INTO arlNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Naa na sequesacaritij, canaari jiyacari niishiquiini majaari Jesu sequenu quiriquiaa pan poreetajajiniji. Canaari shusha niishiquiini Jesuuri miriqui canaa numooteriquiaa tama canaa cuaqueyajaaja canaa cojuanura Fariseocuaca niishitiojosanoocuaji, Saduceocuaca niishitiojosanoocuajinio. ");
INSERT INTO arlNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Canaa tiuquiijiosacari Cesareya Filipo tiaca jiyajinia, Jesuuri canaa nequesotaree: —¿Taa pueya sequequiaa janiyajinijini, cantena janiyani? ");
INSERT INTO arlNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Canaari Jesu riucuareeni: —Noojiaqueya pueyari sequequiaa, quiaanaari Tiuquinijiona Juan. Herodes motesano naasucuanaari samiitiarohuacuaa. Tamasacaari sequequiaacujua, quiaanaari Elías, tariucuacaanu pueyara Pueyaso sequesano caminiujiunia. Tamasacaari saniniuujia quia sequequiaacujua, quiaanaari supuetana Jeremías, pueyara Pueyaso sequesano caminiujiuniajuhuaj, tamonu Pueyaso sequesano caminiujiunia soj. ");
INSERT INTO arlNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesuuri canaa nequesotarohua socua: ¿Niajaniyariuhuaj? ¿Taa nia sequeyanijia? ¿Cante janiyani? ");
INSERT INTO arlNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedroori na riucuaree: —¡Quiaacuajaari Pueyaso Jiyarosano! Quiaari Cristo, Pueyaso Niyanu. ");
INSERT INTO arlNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesuuri Simón Pedro sequerohua: —Quiaacuajaari Pueyaso shuquiritiasano pueyano, Jonás niyanunaa. Jiyocuacaanu Quijia cua Quecuajaari quia niishitirii cante janiyani. Janiyajiniji quia niishishanoori maja pueya niishitishano quiajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Janiyari socua sequenu paniya quiajaniyani Pedronaa. Quia sesaari Pedro. Nioori pueyano rupaajinia sequeya “saajia”. Naatej, taa saajiacuaani jataniyaquishoo, quiaari cumaatia nujuataja quiniutianiya, seetanujuanaa cucua quia tiuushacari, quia niishishacari janiyari Pueyaso Niyanuni. Naajuhuaj, puetunu pueyajanaa cante cucua tiuuriini taa cucua quia tiuyacuaani, janiyari nojori jiyatenutaniya cua muerasurani. Puetunu cua saquiriojosano pueyajanaari cumaatia nujuatunutaniya, nojori niishishacari janiyari Pueyaso Niyanuni. Naacuajitij, nojoriiri juhua puereetuuca saajiaacua tiasano quiniutianiya. Puetunu cua muerasujuanaari juhua cua tia quiniutianiya, cua quiquio nojori quishacari. Sesaacaari maja na naata cua tia pojoretanu quiniutianiya. Majaari na naata na tarinitiniu quenaaja janiya, cua tiasacari cua quiquiora. ");
INSERT INTO arlNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Naajuhuaj Pedronaa, quiaari juhua cua quiquio tiootiu riatataja jiitiana quiniutianiya. Naacuajitij, quiaari coteenu pohuatanutaniya pueya niquiara janiyajiniji, nojori tiuuniuria cucua, juhua Pueyasoocua nojori tiuquiniuria na muerasura nojori quiniuria. Naajuhuaj, quiaa jaara rootare taate Pueyaso muerasu naata miiniu maniniani, Pueyasoori sequenutaniya cuaara naa quiiriatej. Naajuhuaj, quiaa jaara casaa tenujure, maja naa pueya miiniuriatej, Pueyasoori naa sequenutaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Na nuhuaji, Jesuuri canaa na pueya rootaree maja canaa pohuatanura tamasaca niquiara nojuacuajaari Pueyaso Niyanu. ");
INSERT INTO arlNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jiyacaritij, Jesuuri canaa pohuatanu coteequiaari taa nojuaja miishaanutaniyani. Canaa sequereeri: —Janiyari Jerusalén tiacajinia quiariquianoni. Parta Judiocuaca jiyaniijianucuaari tii cua miiniutianiya naquiya jiyanohua. Pueyacuara secojonaa jiyaniijianucuaari nojori rupuenutaniya naa cua paracaashaanurajuhuaj, mariyata tariucuacaanu Moisés Naajioneejiniji niishitiojonaanio. Naacuajitij janiyari mosaanutaniyani. Jiuujianaraca juucajinia, janiyari samiitianutaniuhuani. ");
INSERT INTO arlNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Naa Jesu sequesacaritij, Pedroori Jesu jaatucuree tamocora na nacasunura tamajaaja. Jiyanohua Jesu sequereeri: —¡Maja naa pocuanutej! ¡Pueyaso cuaara cojuaara quiajaniya maja naa quia miishaanuratej! ");
INSERT INTO arlNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesuuri saaja Pedro nijiniaquequee. Na sequereeri: —¡Niiquiji quia quiaare Satanásnaa! ¡Quia sanaajere! Sesaacaari naa quia pocuateree Pedronaa. Quia sequesanoori maja Pueyasojiniji. Quia niishiriojosanoori juhua mijiria pueya niishiriojosano saaja. Naa quia sequesacaritij, quiaari cua Que sequesanoocuaji cua tarinitiniu paniya juucua. ");
INSERT INTO arlNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Na nuhuaji, Jesuuri canaa na pueya sequequiaari: —Pueya jaara cua tojijiara quiniu paniya, nojori cuaara carteera tama nojori panishanojuaaja. Na nuhuaji cutara, cuaara miiria cua panishano, tama na cuaqueya na panitianutajaaja cucuara. ");
INSERT INTO arlNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Naatej, pueyano jaara tama na cuaqueyajaaja shuquiritiniu paniya mijiria, cuno pueyanoori na nuhuaji jiyanohua taraatia quiniutianiya. Saniniuujia, cante tama na cuaqueyajaaja panitiaa cucuara mijiriani, cuno pueyanoori na nuhuaji pueyaracaanu shuquiriaatia quiniutianiya cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Naajuhuaj, pueyano jaara masere puetunu nio jiya casamijianaa, na casamiiri najuhuana quiniutianiya nera, na camaru jaara jatasaare mani quiquiojinia na shaajesacari. Nojuajaari maja na naata Pueyaso jiyanootiniu tama na cuaqueyajaaja, naajaa, nojuaja jaara puetunu na casamijianaa niquitiore Pueyaso, Pueyaso samiitianiniuhuara nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","’Janiyacuajaari jiyanohua shacantuuca quijiara quiniutianiyani, cua Que jiyatesacari janiya Jiyaniijiarajanaa. Na nuhuaji, janiyari mijiria niniutianiuhua jiyocuacaanuji cua Que seyatani, puetunu pueyajanaa cua nequesoreenura. Jiyacaritij, pueyari maninia casaa niquitiosaanutaniya maninia nojori miiniuucua. Pueyaso tojitiaashijiacaari saniniuujia naquiya miishaanutaniya, sesa nojori miiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Seetanujuanaa nia sequeyanijia, noojiaqueya niajaniyajinijinio niya cuata quiyani, majaari nia shaajenu quiniutianiya juhuanojuaja, niaa cuaara niquirijiaatijia Pueyaso cumaaca cucua tiuquiyano, cucua tiuujiaca jiitiariquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis juuca nuhuaji, Jesuuri nio pojori jiyataquiaari jiyaconaja tuhuananuucua. Nojoriiri quiquiaari Pedro, Santiago, Santiago tarajanu Juannio. Jiyareta tama nojorijiaarijia quiaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jesuuri tii tamaatiara jataquiaari nojori niquiara. Na jiquiocoori jiyanohua shacantuucara jataquee, juhua pananu. Na toqueeri mariyata jiyanohua cohuajara jataquiaarijiuhuaj, juhua cuhuatana. ");
INSERT INTO arlNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jiyacaritij, nojoriiri caapiqui supuetanaa niquirii, Moisés, Elíasnio. Jesuta pocoojoriquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Cunora, Pedroori Jesu sequeree: —¡Jiyaniijianaa, canaaqui namitia niya quiyani! Quiaa jaara paniri, canaa quiocuaji suhuoronutaniyani, Moisésrajuhuaj, Elíasranio. ");
INSERT INTO arlNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro pocuasacarijia, shacantuuca najacaari nojori mishiquiomaa. Najacajiniji, rupaari tojishaaquiaari naa sequeyano: —¡Nioori cua Niyanuniyojua, cua shuquiritiasano! ¡Saaja nojuaja nia tojitiare! ");
INSERT INTO arlNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Naa nojori tojishacari Pueyaso pocuaanotej, nojoriiri jacamatuquiaari jiyanohua na puerenuta. ");
INSERT INTO arlNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesuuri nojoriicua nimiaa. Nojori quiaseeri na juaashiquiata. Nojori sequereeri: —Nia saneecuaturohua. Maja puerenu. ");
INSERT INTO arlNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nojori jaara niquinijionuuquiaari, majaari tari na niquitiuniu quiquiaari cuno supuetanaa. Saaja Jesuuri quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nojori rosetasacariuhua tuhuananujiniji, Jesuuri naa nojori rootaquiaari: —¡Majaari nia pohuatanu pueya niquiara tuhuananujiniji nia niquishano! Niocua na pohuatarohua cutara janiya jaara samiitiarohuani. ");
INSERT INTO arlNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na pueyari Jesu nequesotaree: —¿Casaara tariucuacaanu Pueyaso Rupaajiniji niishitiojonaa sequequiaacuaraarini, supuetana Elíasnaari quiocuaji mijiria niniutianiuhua coteenu, pueya na jiyanootiootenuhuara necohuata? ");
INSERT INTO arlNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesuuri riucuaree: —Elíasri seetanujuanaa coteenu niriquiano quiquiaari, puetunu pueya jiuujiaajanaa na jeenucuanura. ");
INSERT INTO arlNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Janiya cutaraari nia sequeyani, Elíascuajaari tari niquiaari. Majaari pueya niishiniu quiquiaari cante nojuajani. Naaratej, pueyari taraatia na miiquiaari taa nojori paniquiaaricuajani. Nojoriiri naa cua miiniutianiya naquiyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Naa Jesu pohuatasacari Elíasjinijitij, na pueyari niishiquii nojuajaari Tiuquinijiona Juanjiniji pohuatariquiaa miriqui. ");
INSERT INTO arlNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesu jaara tuhuananujiniji tiuquiijioquiaari canaacua, tamonu pueyanoori nocua catecanoquiaari canaata quiniaa maanujiniji. Jesuucuara mojoquetaseeri na sequenura neyanuucuara. ");
INSERT INTO arlNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Jesu sequereeri: —¡Jiyaniijianaa, cua niyanuucua quia taraajere quenaaja! ¡Nojuajaari pueyaracaanu cusojoquiaa! Na jiitiasano cusonuuri na taquiriocuatequiaa. Na cusojosacari miiquiaa naquiyari. Naacuajitij, sequeyarucua manijinia tiquiaari, moojinianio. ");
INSERT INTO arlNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Janiyari quia pueyacua na tiuquitiasee na naataniniuria juucuani. Nojoriiri maja na naata na naataniniu. ");
INSERT INTO arlNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesuuri cunora sequeree: —¡Niaaqui Pueyasoocua tiuyashijiaca, na tojiyashijiacanio! ¿Janiyateeri nia rejeretanutaniya pueyaracaanuni? ¿Taacari nia niishiniutianiya Pueyaso tamajaajaarini? Miji nia jaatucuma cuno mueya. ");
INSERT INTO arlNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mueya tiuquishacari nocua, Jesuuri samaru juaarii. ¡Na tohuatereeri! Jiyacaritij, caya samijiaari maninia quiquiuhua. ");
INSERT INTO arlNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na nuhuaji, tamajaaja canaa quishacari Jesuta, canaari na nequesotareeni: —Jiyaniijianaa, ¿casaara maja canaa naata cuno samaru tohuatenu quiriquiaani? ");
INSERT INTO arlNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesuuri canaa riucuaree: —Maja puera maninia nia tiuuniu juhuanojuaja Pueyasoocua. Seetanujuanaa nia sequeyanijia, nia tiuuniu Pueyasoocua jaara quiriquia shiitianiyojua juhua mostaza jajau quenaaja, jiyacari cutaraari nia naata miiniu puetunu nia panishanojuanaa. Naacuajitij, nio tuhuananu maara nia tojiri, niaa jaara na sequere: “Tuhuananunaa, niiquiji quia quiaare tamaqui”. ");
INSERT INTO arlNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Saniniuujia, jiyano samarutej, na naata tohuatanishano cutara saaja Pueyaso nia secojosacari nia miaqueyaquiniutia. ");
INSERT INTO arlNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tamonu juuca Jesu rucoojosacari canaa na pueyata Galilea jiyajinia, Jesuuri canaa sequeree: —Janiyari sapojonuta niquitiosaanutaniya taucuacani. ");
INSERT INTO arlNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nojoriiri cua monutaniya. Jiuujianaraca juucajinia, janiyari samiitianutaniuhuani. Naa Jesu sequesacari canaatej, canaari jiyanohua taraajequiaarini. ");
INSERT INTO arlNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Canaa jaara tiuquiijioquiaari Capernaum tiacajinia Jesutani, tamonu pueyanoori Pedroocua catecanoquiaari. Nojuajaari cumaneeca masejona quiquiaari Pueyaso Secojojua tiaacuara. Cuno pueyanoori Pedro nequesotaree: —¿Majate nia niishitiojona niquitionu na cumaneeca Pueyaso Secojojua tiaacuara, taa pa jiyaniijianucua sequequiaaricuajani? ");
INSERT INTO arlNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedroori na riucuaree: —Na niquitioquiaanocuaja. Na nuhuaji, Pedro tiuquishacariuhua na tiajinia, Jesuuri na nequesotaree: —¿Taa quia sequeyani Simónnaa? Mijiria jiyaniijianucua jaara cumaneeca paniri, ¿teyano pueyajiniji cumaneeca maseshiyani? ¿Tama na pueyajinijitii, taucuacajiniji soj? ");
INSERT INTO arlNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedroori Jesu riucuaree: —Taucuaca niquitiojoteshiyanocuaja nojori jiya jiitiana sequesano. Jesuuri na sequeree: —Naacuaaquiniatejaj. Naacuajitij, tama na pueyajaarijia maja na niquitionu. Pueyaso Secojojua tiacuajaari cua Que tia. Naaratej, maja cumaati Neyanu sequesaanu na niquitionura na cumaneeca. ");
INSERT INTO arlNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Naajaa, pa niquitiore juhuari nojori sequesano, paa mariqui nojori juaatiriiri. Nocuaji quia rioosee caminiajinia. Quiocua coteenu quia jatasano sapitiaaja rupaama niquiri. Quiaari tii cumanee riuriatanutaniya. Quiocua cuno cumanee niquitiosuhua nojori, quiria, quiarajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jiyacaritij, canaa, Jesu saquiriojosano pueyani, canaari Jesuucua catecanoquiaarini naa canaa nequesotanura nojuaja: —Jiyaniijianaa, canaa quia sequeretoj, puetunu quia pueyajinijiniojuanaani, ¿cante jiyaniijiajanaa cutarani? ");
INSERT INTO arlNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesuuri naatujua piirii. Canaa tajinia na nujuatereeri. ");
INSERT INTO arlNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Na nuhuaji, Jesuuri canaa sequeree: —Nia niyajetare socua tojishano pueyano nia quiniu paniniu tamasacajiniji. Seetanujuanaa nia sequeyanijia, nia jataniyaquishacari tama nia cuaqueyajaaja juhua nio naatujoori nia quiniuria, majaari Pueyaso muerasura nia quiniu quiniutianiya quenaaja. ");
INSERT INTO arlNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Naacuajitij, cante tama na cuaqueyajaaja jiyateya pueya shocoteyashijia na quiniuria juhua naatujuani, nojuajaari socua jiyaniijiajanaa quiniutianiya cutara narta Pueyaso muerasujinijinio. ");
INSERT INTO arlNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Naajuhuaj, cante naatujua maseja maninia na paniniuucua janiyani, nojuajaari cua maseyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Sesa cutaraari, sesa nia miitiniuria cucua tiuujia naatujua. Socua maninia cutaraari sesa miitiriquiano pueyanora, nojuaja jaara juhuacarijia caminia queronijinia jartasaare puereetujuajau saajia na riquiajiniji morotasano. ");
INSERT INTO arlNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Mijiria quiniaari jiyanohua cocuaatia miiquiaa sesa na miitishacari tamasaca! Mijiria, pueyari pueyaracaanu sesa miitishaaquiaajuhuanajaj. ¡Taraatia quiniutianiya cutaraari noo pueyanora, cante sesa miitirii tamonuni! ");
INSERT INTO arlNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Nio miriqui cua niishitiojosano nia tojiri: nia juaashiquia, nia niohuaca jaara sesa miitiya niajaniya, nia rashiquiarenoj, tucuacaanu jatasocoriquiano. Naa nia miiri niaa mariqui mani quiquiojinia jatasaareeri puetunu nia cuaqueyatajanaa. Socua maninia cutaraari juaashiquiaaju, niohuacaaju nia tiuquitianura Pueyaso quiquiojinia jiyocuacaanu. Niaari tii quiniutianiya shuquiriaatia pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Naajuhuaj, nia namijia jaara nia miitiri sesa, nia jiatere. Tucuacaanu nia jatarenoj. Jiyanohua socua maninia cutaraari niaara, jiyocuacaanu nia tiuquiniuria namijiijiu, maja nia jatasaanura mani quiquiojinia, saniitiosocoriquiano puetunu nia namijiaatajanaa. Naa Jesu niishitiojosacari miriquitij, nojuajaari canaa niishitiojoriquiaa canaa tarinitianura jiyanohua canaa miiniu panishano, cuno jaara sesa miijiara jiyateriquia canaa. ");
INSERT INTO arlNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesuuri naa canaa niishitiojorohua socua: —Tama nia cuaqueyajaaja nia cojuare nia soyaquiniuucuaji tamonu muerasuniyojua, juhua nio mueyaja. Cua tojitiare. Pueyasocuajaari na seya seerataquiaa nojori cojuanura muerasu. Cuno na seyari pueyaracaanu cua Que Pueyaso jiquioco shootiaquiaa. Naajuhuaj, Pueyasocuajaari na muerasuranoocua niishiriojoquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Naaratej, janiyari mijiria niquiaarini tashucuano pueya cua pajenura, nojori cua jaariuutianura Sesaaca. ");
INSERT INTO arlNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Taa nia sequeyani pueyanaa? Tamonu pueyano jaara cien borregohua jiitiare, niquiriyatujua jaara tashucuare tapueyocuacajiniji, ¿majateeri na camaru na borregohua cureeno tiujianu rupaquijia, tashucuano na pajenura? Taaquiriirinij. ");
INSERT INTO arlNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jaara na riuriatare, seetanujuanaa socua jiyanohua cuno borrego tashucuano shuquiritiaari tamasaca na borregohuajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Naajuhuaj, jiyocuacaanu quijia nia Queeri maja na paniniu quenaaja niquiriyatujua nio muerasujinijinio tashucuanura puetunurajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Quiarta Pueyaso pueyano jaara sesa miiri quiajaniya, nocua quia quiaare na nacasunura tamajaaja nia quishacari. Nojuaja jaara tojiri quiajaniya, maniniacuajaari. Niaari maninia rupuetoojuacara quiniutianiuhuacuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nojuaja jaara tojiyaquiri quiajaniya saniniuujia, nocua quia quiaare socua tamonu pueyanota, caapiqui pueyata soj. Nojori niquiara quia nacasure cuno sesa miinia. Niaa jaara naa miiritij, naa quiniutianiyari taa tariucuacaanu Pueyaso Rupaajinia niishitiojosaaquiaaricuajani: “Querajaa pueya jaara mariyata pohuatare na niquishano, na tojishanojuhuaj, cunoori maja sapojonu”. Naacuajitij, nojori saquiriojotasanoori seetanujuanaa quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Cuno sesa quia miinia jaara nia tojiniu paniyaquiya saaja, puetunu niarta Pueyaso pueya niquiarajanaa quia pohuatare sesa na miishano. Cuno pueyano jaara tojiniu paniyaquiri puetunu Pueyaso pueyajanaa, nojuaja cuaara quiiria juhua Pueyaso niishiyashijia niaara. Naacuajitij, majaari socua nia rupuenunoj. ");
INSERT INTO arlNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Seetanujuanaa nia sequeyanijia, cana nia jiyanoyaquirii mijiriani, na tojiniu paniyaquishacari niajaniya, cunoori jiyanoyaquishano quiniutianiya jiyocuacaanu cua Que Pueyasorajuhuaj. Naajuhuaj, cana nia jiyanoorii mijiria na tojishacari niajaniyani, cunoori jiyanooshano quiniutianiya jiyocuacaanu cua Que Pueyasorajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Naajuhuaj, janiyari seetanujuanaa sequeya niajaniyani. Caapiqui niajaniyajinijinio jaara mariyata niishiriojore nia panishanoocuara nia secojonura Pueyaso, cua Queeri nia tojiniutianiya. Nojuajaari jiyocuacaanuji naa maninia miiniutianiya niaara, taa nia secojosacari nia sequereecuajanoj. ");
INSERT INTO arlNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Querajaa niajaniyajinijinio jaara rerejore, cucua tiuujiaca nia quishacari, janiyari tii niaata quiyajaaniuhuaj. Naacuajitij, cua Queeri nia secojosano tojiniutianiya cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jiyacaritij, Pedroori Jesu nequesotasee: —Jiyaniijianaa, tamonu pueyano jaara sesa miiniu pacutejore janiya, ¿janiyatucua pueyaracaanu na jiyanoorini? ¿Majateeri tariucuaja, janiya jaara na jiyanoori siete sesa na miishanojiniji janiyani? ");
INSERT INTO arlNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesuuri Pedro riucuaree: —Maja naatej Pedronaa. Maja quia tarinitianu na jiyanooniu. Pueyaracaanu sesa na miishacari quiajaniya, pueyaracaanu quia jiyanoori quiarta pueyano. Majaari quia serojonu sesa na miishano quiajaniya. Pueyaracaanu quia jiyanoori saaja. ");
INSERT INTO arlNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Naaratej, cua tojiri pueyanaa. Nia pohuatareera nia niishiniuria taa Pueyaso paniya jiyanootioojuaca na muerasu nia quiniuriani. Tamonu jiya jiyaniijiaari nera poonijionaa pueya sequequiaari nojori cuaara tari niquitiojoora nojuaja na cumaneeca, nojori na niquitiojosanojiniji na casami. ");
INSERT INTO arlNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Noojiaqueya nera poonijionaa pueya jaara tari nojori pasano casamijiniji niquitiojoriquiacuaa tama nojori cumaneecajinijijiaaja, jiyacaritij, tamonuuri tiuquinishaareejuhuaj. Nojuajaari jiyanohua queraatia casami masejoquiaari na jiyaniijiajiniji, queraatia millón cumaneeca. ");
INSERT INTO arlNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nojuajaari maja na jiitianu quiquiaari na cumaneeca, na jiyaniijia na niquitionuhuara. Na jiyaniijiaari cunora na pueya sequeree: “Tamonu camarnu nia niquitiore nio cua seru, necocuataja, cua cumaneecara, necohuajuhuaj, puetunu na casamijianaanio. Naacuajitij, na cuentaari puequenutaniya”. ");
INSERT INTO arlNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Cuno na seru tojishacari naa na jiyaniijia sequesanotej, nocuara jacamaquiaariiri. Na jiyaniijia sequereeri: “¡Cua tarinitiare quenaaja cua jiyaniijianaa! ¡Rupaquijiara cua tarinitiarejaara! Janiyacuajaari quia cumaneeca niquitionutaniya puetunujuanaani”. ");
INSERT INTO arlNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na jiyaniijiaari nocua taraajeree. ¡Na carterohua puetunujuanaari! Naa na jiyanooriiri, nocua na taraajenuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Cuno seru tohuatasacari jiyaniijia tiajiniji, narta seruta naacuneetooreeri. Cuno narta seruuri tarijia masequiaari shiitianiyojua casami cuno jiyanooshano serujiniji. Secaja cumaneecaari quiquiaari na cuenta. Naajaa, cuno jiyanooshano seruuri narta seru quiaree. Cumaatia na riquiajinia na miniriiri. Na sequereeri: “¡Ritia cua niquitiore cumaneeca, tarijia quia masesano janiyajiniji!” ");
INSERT INTO arlNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Narta seruuri na riquiajinia mininia cariquimiaji mojoquetaree. Na sequereeri: “¡Cua tarinitiarecuaraja quenaaja! ¡Janiyacuajaari quia cumaneeca quia niquitionutaniyani!” ");
INSERT INTO arlNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Majaari na sashiniu paniniu quiquiaari. Saaja na nujuatequiaari nujuatejojuajiniaari cuaara na cumaneeca na niquitiorejaatijia. ");
INSERT INTO arlNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Narta seya niquishacari naa cuno jiyanooshano seru miishanotej, nojoriiri jiyanohua taraajequiaari. Nojoriiri jiyaniijiaacua quiojoquiaari puetunu sesa narta seru miishanojuanaa nojori pohuatanura. ");
INSERT INTO arlNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Naaratej, jiyaniijiaari tamonu na seru jiyaroree cuno jiyanooshano seru riniuucua. Na tiuquishacari, jiyaniijiaari na juaarii. Na sequereeri: “¡Quiaaqui jiyanohua sesajuhuanajaj! Quia sequesacari janiya, janiyari quia jiyanooriicuaani, maja quia naata niquitionu quishacari quia cumaneeca. ");
INSERT INTO arlNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Majateeri quia naata quiriquiaa taraajenu quiarta seruucua, taa cua taraajeree quiocuacuaani?” ");
INSERT INTO arlNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jiyaniijiaari jiyanohua juaarii. Cunora, cuno sesa miijia seru jiyarotareeri nujuatejojuajinia na nujuatesaanura. Sequereejaariuhuaj cuaara naquiya miishaaria tii, cuaara puetunujuanaa na cumaneeca niquitiorejaatijia, casami na pasanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Nia Que Pueyasoori naa miiniutianiya niajaniyajuhuaj, niaa jaara seetanujuanaa jiyanoyaquiri niarta Pueyaso muerasu. ");
INSERT INTO arlNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesu jaara naa pohuatanu puecaquiaaritij, canaa na pueyata quiaquiaari Galilea jiyajinijiiri. Canaari Judea jiya shuriucua tiuquishii Jordán moo taquijiriani. ");
INSERT INTO arlNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jiyanohua queraatia pueyari Jesu nuhuajiyaree. Quiniqui canaa quishacari, Jesuuri cusosuhua naatanijioree. ");
INSERT INTO arlNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jiyacaritij, noojiaqueya Fariseocuacajinijinioori Jesuucua nijioquiaari sesa na pocuatenura Jesu juucua nocuara nojori tonujunura. Naaratej, nojoriiri Jesu nequesotaree: —¿Maniniate pa cartenura pa niquiocua, jaara pa juaatiri? ");
INSERT INTO arlNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesuuri nojori riucuaree: —¿Majate nia serojonu quiquiaacuaja Pueyaso Rupaajinia? Coteenujuanaa Pueyaso shipinishacari pueyano, Pueyasoori shipiniquiaari caya, maajinio. ");
INSERT INTO arlNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Naaratej, nojori shipininiaari sequequiaari: “Caya cuaara tiujiaara na que, na nucuanio, necocuata na quiniuria. Nojoriiri juhua niquiriyatu pueyanora quiniutianiya na camitioosacari”. ");
INSERT INTO arlNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Naaratej, caya, maaji jaara camitioore, majaari tari na quiniu caapiqui pueyano. Juhua niquiriyatu pueyanojuaari quiquii. Naacuajitij, majaari maninia Pueyaso rupuetootesano rupartanura. ");
INSERT INTO arlNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nojoriiri Jesu sequeree: —Jaara naa quiritij, ¿casaara supuetana Moisés rootaquiaaricuaraarini caya cuaara naajionee niquitioora necocua, na cartenu panishacari? ");
INSERT INTO arlNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesuuri nojori riucuaree: —Moiséscuajaari niishiquiaari niaari puera cumajiuujiaaca. Naaratej Moisésri nia tarinitiaquiaari nia niquiocua nia cartenura. Coteenujuanaa, Pueyaso jaara shipiniquiaari caya, maajinio, majaari naa na quiniu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Cua tojitiare pueyanaa. Janiyari nia sequeya cutarani. Cante necocua carteree najuhuanani, tamonu maajitia na caminiuria, coteenu necocua jaara tamonu cayata quiyaquiri, neyacaari jiyanohua sesa miya Pueyaso niquiara. Jaara naa miiritij, Pueyasora, nojuajaari sesoriquia pueyano. Nojuacuajaari juhua pueyano, cante narta pueyano niquiocua numuetucujuani. Naajuhuaj, cante cartesano maaji camiyani, naa sesa miyajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Canaa, Jesu saquiriojosano pueyani, canaa tojishacari naa Jesu sequesanotej, canaari na sequereeni: —Jaara naa quiritij taa quia sequeriquiaacuajani, maninia naasucuaari maja mashaja caminiuria. ¿Naatejaaratej? ");
INSERT INTO arlNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesuuri canaa riucuaree: —Maja na naata puetunu pueyajanaa nio cua niishitiojosano tojiniu. Saaja noojiaqueya pueya cutaraari na tojiniutianiya, noo pojori canapuete jiyocuacaanuji cumaaca niquitiosaareeni na tojiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Naajuhuaj, noojiaqueya canuuri maja na naata caminiu, riyacajajaaju nojori quishacari. Nojoriiri naa rasanojuhuanajaj. Tamasaca canuuri maja na caminiu saniniuujia, jiatejosano nojori riyacajajau quishacari. Tamasacaari maja na caminiujiuhuaj tama nojori paniyaquishacarijiaaja, saaja Pueyasora nojori poonijionu panishacari. Cante na naata naa miiniuni, cuaara naa miiriatej. ");
INSERT INTO arlNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na nuhuaji, pueyari Jesuucua nitiaquiaari necohua juucua, Jesu nianura nojoriicua na juaashiquia, nocuara na secojonura Pueyaso. Canaa, Jesu saquiriojosano pueyani, canaari saaja nojori tenujuree canaa juaaniutiani. ");
INSERT INTO arlNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesuuri saniniuujia canaa sequeree: —¡Maja nojori tenujunu! Nia tarinitiare naatujoori cuaara cucua nijioora. Nia tojiri, canapuete seetanujuanaa juhua nio naatujoorini, nojoriiri Pueyaso muerasu quiriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Na nuhuaji, Jesuuri na juaashiquia niaquiaari naatujooriicua, nojoriicuara na secojonura, Pueyaso miiniuria maninia nojori. Na nuhuaji, Jesuuri quiniquiji quiaquiaariuhua. ");
INSERT INTO arlNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tamonu mashajaari Jesuucua niquiaari. Na nequesotaseeri: —Niishitiojonanaa. Quiaari maninia pueyano. Cua sequere, ¿taa cua miiniutianiyani maninia cua quiniuria Pueyaso niquiara, pueyaracaanu quijiara cua quiniuriani? ");
INSERT INTO arlNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesuuri na riucuaree: —¿Casaara quia sequeya janiya maninia pueyanotani? Saaja niquiriyatujuaari maninia quijia cutara. Nojuacuajaari Pueyaso. Naajaa, quiaa jaara maninia quiniuucua jiaatiaa Pueyaso pueyano quia quiniuria, quia tojiri tariucuacaanu Moisés Rootasano Pueyasojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jesu riucuareeri: —¿Teyano rootasanoteni? Jesuuri na sequeree: —Maja quia monu. Maja quiarta pueyano niquiocua quia numuetucunu. Maja quia nohuasenu. Maja quia saquiriojotanu tamonuucuara quia sapojonuta. ");
INSERT INTO arlNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Quia que, quia nucua tojijia quia quiriquia. Maja nojori quia rerequetenu. Mariyata quiarta pueyano quia paniri taa quia paniyacuaa tama quia cuaqueyajaajani. ");
INSERT INTO arlNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mashajaari Jesu sequeree: —Janiyacuajaari puetunujuanaa nio tojijia quiquiaari cua naatujuajinijini. ¿Casaa cua miiniutianiya socuani? ");
INSERT INTO arlNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesuuri na sequeree: —Quiaa jaara seetanujuanaa maninia quiniuucua jiaatiaa Pueyaso niquiara, quia quiaarohua quia tiajinia. Quia niquitiojore puetunu quia casamijianaa cumaneecara. Na nuhuaji, casamiijiuniucua quia niquitiojore nareja quia cumaneeca. Naacuajitij, quiaari queraatia casami jiitianutaniya jiyocuacaanu. Na nuhuaji, quiocua nimiohua cutara, cua tojijia quia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Na tojishacari naa Jesu sequesanotej, mashajaari taraatia quiaarohua jiyanohua casamiriaca na quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jiyacaritij, Jesuuri canaa sequeree: —Seetanujuanaa nia sequeyanijia, jiyanohua jiyajenetaari pueyano tojiniuria Pueyaso, na pueyano na quiniuria, cuno pueyano jaara puera jiyanohua casamiriaca quiri. ");
INSERT INTO arlNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Pueyanaa, ¿camelloteeri na naata cusupuetaja cuhuoco tamajiria tajiniu? Maja na naata. Cua tojitiare. ¡Socua jiyanohua jiyajenetaari casamiriaca pueyanora, Pueyaso pueyanora na jatanishaanura! ");
INSERT INTO arlNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Canaa tojishacari naa Jesu sequesanotej, canaari jiyanohua jiuujiatereeni. Canaari na nequesotareeni: —¿Canteeri Pueyaso pueyanora jiyatesaanutaniya socuanitioj? ");
INSERT INTO arlNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesuuri canaa shootiaree tacuriitia. Canaa sequereeri: —Pueyari maja na naata tama na cuaqueyajaaja jiyatenu Pueyaso muerasu nojori quiniuria. Pueyaso cutaraari na naata na miiniu. Nojuajaari cumaacaraca puetunu na panishanojuanaa na miiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedroori Jesu sequeree: —¿Canaarijiataj? Canaari puetunu canaa casamijianaa tiujiaquiaarini canaa rupuenura quiajaniya. ¿Casaa canaa masenutaniyarinijia? ");
INSERT INTO arlNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesuuri canaa riucuaree: —Seetanujuanaa nia sequeyanijia. Nio jiya maniniushitishacariuhua, janiyari cajiniutianiyani jiyaniijia cajitiujinia puetunu cua Quejiniji shanohua cua cumaacatajanaa. Jiyacaritij cua pueyanaa, niaari mariyata cajitijiosaanutaniya doce jiyaniijia cajitiucuajinia. Niaari pa supuetana Israel doce niquiohuacuajinio caneno pueya nequesoreenaa quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Cua pueya tojiniuria janiya, noojiaqueya nojorijinijinioori na tia tiujianutaniya, tapueyocuaca, na rimiatuhua, na que, na nucua, necohua, na cuhuariquianio. Canapuete naa tiujiaquiaa na tojiniuria janiyani, cuno pojoriiri Pueyasojiniji socua jiyanohua queraatia masenutaniya nojori tiujiasanojiniji. Nojoriiri pueyaracaanu shuquiriaatia quijiaca quiniutianiyajuhuaj, shaajeyashijiaca. ");
INSERT INTO arlNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Saniniuujia, queraatia tojishano pueyari Pueyaso shocotasano quiniutianiya na tojitiaashijiaca nojori quiniuucua. Naajuhuaj, mijiria, queraatia pueyari juhua shocotasano pueya quiya Pueyaso niishiyashijiaca pueyara. Cuno pojori jiyanishano najuhuana quijiacani, nojoriiri Pueyaso shuquiritiasano pueya quiniutianiya cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Socua cua tojiri taa Pueyaso miiquiaa na pueyani. Nojuajaari na pueya miiquiaa taa tamonu cuhuariquia camaru miiquiaari na poonitijiosano pueyacuaani. Cuno cuhuariquia camaruuri quiaquiaari tariquiicuaji pueya na pajenura na uva cuhuariquiajinia nojori poonijionura. ");
INSERT INTO arlNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Cuhuariquia camaruuri pueyata pocoojoquiaari taa cumaneeca na niquitionutaniya cuno juuca nojori poonijiosanojinijini. Poonijionaa pueyari na sequeree: “Maniniacuajaari taa quia sequereecuajani”. Na nuhuaji, cuno pueya jiyaroreeri uva cuhuariquiajinia nojori poonijionura. ");
INSERT INTO arlNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pananu tacasacari, cuhuariquia camaruuri tohuataquiaariuhua na tiajiniji. Jiyacaritij, socua tamasaca pueya niquishiiri juhuajaniya quiyano tiaca jiuujiajinia curotasano cajitiucuajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Cuhuariquia camaruuri nojori sequesee: “Nia quiaarejuhuaj, cua uva cuhuariquiajinia nia poonijionura. Janiyacua cumaneeca nia niquitiorohua nia poonijionu samini”. ");
INSERT INTO arlNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Naacuajitij, nojoriiri quiojoquiaari cuno cuhuariquiajinia poonijionurajuhuaj. Na camaruuri socua tohuataquiaariuhua panacari. Socua tamasaca pueya niquishiiri juhuajaniya quiyano tiaca jiuujiajinia curotasano cajitiucuajinia. Nojori sequereejaariuhuaj nera nojori poonijionura cuno juuca. Pananu mueecosacari, socua pueya riuriataquiaariiri. Nojori jiyaroree poonijionuucuajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tariucua pananu piriuushacari, na camaruuri socua tohuataquiaariuhua. Socua tamasaca pueya niquishiiri tiaca jiuujiajinia curotasano cajitiucuajinia najuhuana quiyano. Nojori sequereeri: “¿Casaara nia quiojiyaquiyaree poonijionuucuani? ¿Casaa nia miya niyani? Niaa mariqui poonijiore”. ");
INSERT INTO arlNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nojoriiri na riucuaree: “¿Canaatucua taa poonijioreni, canaa jaara pajeshiyaquiri poonijionurani?” Cuhuariquia camaruuri nojori sequeree: “Nia quiaarequi cua cuhuariquiajinia nia poonijionura. Janiyacua nia poonijionu sami cumaneeca nia niquitiorohuani”. ");
INSERT INTO arlNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Pananu tiuquishacari, cuhuariquia camaruuri na casami cojuana sequeree: “Cua poonitijiosano pueya quia piiri miji, nojori rerejonura. Na nuhuaji, cua sequesano cumaneeca quia niquitiojore puetunu nojorijianaa taa cua sequeree coteenujuanaa quiria poonijionaacuajani. Majaari rimiajata nojori niquitiojonu. Coteenu quia niquitiojore tariucua pananu piriuushacari cua jiyaramiquishano. Naa quia niquitiojore puetunujuanaa. Quiocua naa tucuatare niquitiojonu noo pojorijiuhuaj, canapuete tariquiicuaji coteeree poonijionucuajani”. ");
INSERT INTO arlNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","’Jiyacaritij, tariucua pananu piriuushacari poonitijiosano pueyari nijiomaa. Puetunu nojorijianaari cumaneeca niquitiosaaree taa cuhuariquia camaru coteenujuanaa tariquiicuaji poonijionaa pueya sequequiaaricuajani. Majaari rimiajata nojori niquitiosaanu quiquiaari cumaneeca, nojori poonijionu sami. ");
INSERT INTO arlNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na nuhuaji, coteenujuanaa poonijionaa pueyari sequesaaquiaari na cumaneeca nojori masenura. Nojoriiri jiyaniquiaari nojori naasucuaari socua cumaneeca niquitiosaanutaniya rupaquijia poonitijiosano pueyajiniji. Nojoriiri saaja niquitiosaaree taa cuhuariquia camaru sequeree nojori cuno juucacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nojori masesacari na cumaneeca, nojoriiri cuhuariquia camaruta juaaquioree. ");
INSERT INTO arlNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Na sequetureeri: “Cuno pueyari saaja rupaquijia poonijioree. Quiaari nojori niquitioree taa quia niquitioree canaacuaani. Canaari pananucari cateree cutarani, pueyaracaanu canaa poonijiosacari”. ");
INSERT INTO arlNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Cuhuariquia camaruuri tamonu nojorijinijinio sequeree saaja: “Sanajanaa, maja sesa cua miiniu quirii quiajaniya. ¿Majateeri quia niishiniu, paa jaara tariquiicuaji pocoojoriquiaatej, janiyari juhuacarijia quia sequereeni janiyari naa cumaneeca quia niquitionutaniyani? Quiaari cua riucuaree: ‘Maniniacuaja’. ");
INSERT INTO arlNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Naaratej, quia jiyataarohua quia cumaneeca quia tiajiniohua. Janiyacuajaari naa niquitionu paniriquiaa tariucua pananu piriuushacari cua poonitijiosano pueyani, taa cua niquitioree quiajaniyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Majateeri cua naata miiniu tama cua panishanojuaaja tama cua cumaneecatajaaja? ¿Quiaateeri socua cumaneecaacua jiaatiajara quiquii, capora cua quiniuucua?” ");
INSERT INTO arlNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Na nuhuaji, Jesuuri naa sequequiaarijiuhuaj, na pohuatasanojiniji na niishitiojonura: —Naa quiniutianiyari taa cua sequeriquiaacuajani: canapuete nuhuajishanaani, nojoriiri coteetanaa quiniutianiya. Naajuhuaj, cante coteetanaani, nojoriiri nuhuajishanaa quiniutianiya saniniuujia. Queraatia masuusano pueyari quiya. Saniniuujia, secajaari saquiriojosano quiya nojorijinijinio. ");
INSERT INTO arlNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tari Jesu quiasacari Jerusalén tiacajiniara, Jesuuri canaa na doce saquiriojosano pueya piirii tamocora nuu shuriuquiocora, tamajaaja canaata na pocoojonura. Canaa sequereeri: ");
INSERT INTO arlNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Cua tojiri. Niaacuajaari niquiya paa tari Jerusalén tiacajiniara tacataani. Janiyari tii niquitiosaanutaniya pueyacuara secojonaa jiyaniijianucuani, Moisés Naajioneejiniji niishitiojonaanio. Nojoriiri cucuara saquiriojotanutaniya nojori sapojonuta cua mosaanura. ");
INSERT INTO arlNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nojoriiri cua niquitionutaniya taucuaca. Cuno pojoriiri cua rerequetenutaniya. Cua majacutunutaniyari. Na nuhuaji, niyacutesanojinia cua teetetunutaniyari tii cua cusonura. Jiuujianaraca juucajinia janiyari macujiniji samiitianutaniuhuani. ");
INSERT INTO arlNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jiyacaritij, Zebedeo niquiocuaari Jesuucua catecanoquiaari necohuata. Jesuucuara mojoquetaseeri Jesu na sequenura nera na miiniuria na panishano. ");
INSERT INTO arlNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesuuri na sequeree: —¿Casaa quia paniyani? Jesu riucuareeri: —Quiaa jaara Jiyaniijiara jiyatesaare, quiocua cua niquiohua cajitijiore quia shuriucua, Santiago, Juannio. Tamonu cuaara cajiiria quia miaquetajara, tamonu quia muenecara, quia naacunaa nojori quiniuria, juhua jiyaniijianucuajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesuuri Santiago sequeree, Juannio: —Majaari nia niishiniu casaa nia maseyani. ¿Nia naatateeri rejeretanu naquiya miiniu taa cua miishaanutaniyacuaani? Nojoriiri saaja Jesu riucuaree: —Taaquiriirinij. Canaa naatacuaaquiniatejaj. ");
INSERT INTO arlNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesuuri nojori sequeree: —Seetanujuanaa, niaari naquiya miishaanutaniya taa cua miishaanutaniyacuaani. Janiya cutaraari maja cua naata sequenu niajaniya, cante cua miaquetajara cajiniutianiyani, cua muenecaranio, Jiyaniijia cua quishacari. Saaja cua Que cutaraari tari na saquiriojosano pueya sequenutaniya cua shuriucua nojori cajitiuniuria, teyano pojoriicuaji na jeenucuaquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Canaa, narta saquiriojosano pueyani, canaari Juan juaariini, Santiagonio, canaa tojishacari nojori masesano juucua. ");
INSERT INTO arlNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesuuri saniniuujia canaa sequeree: —Miji pueyanaa. Niya cua tojitiasee. Niaacuajaari niishiya, mijiria jiyaniijianucuaari na pueya poonitijioquiaa juhua tama na seyajaaja. Mijiria camarucuaari taraatia miiquiaa na pueya, nojori na miitishacari puetunu na panishanojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Niajaniya saniniuujia, majaari naa nia quiniu quiniutianiya. Naacuajitij, cante tojishano pueyano quiniu paniya niajaniyajinijinioni, cuno cuaara quiiria narta Pueyaso pueya cumaquinia. ");
INSERT INTO arlNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Cante nia jiyaniijia quiniu paniyani, cuno cuaara quiiria juhua nia seru, maninia na miiniuria niajaniya, naatej, taa cua miiquiaa niajaniyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Janiya cutaraari Jiyaniijiani. Naajaa, majaari mijiria cua niniu quiquiaari pueya cua poonitijionura quiria, shuquiriaatia cua quiniuria tamajaaja. Niquiaari cutaranijia pueya cua naacunura, tama janiyajaaja mosaanura pueya niti, queraatia pueyacuaji cua ritianura Sesaaca. ");
INSERT INTO arlNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesuta canaa quiasacari Jericó tiacajiniji, jiyanohua queraatia pueyari Jesu nuhuajiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jiyacaritij, caapiqui cariyojuaruuri nuu shuucuaji cajitiuriquiaa. Nojori niishishacari Jesuuri nojori tajiriquiaa, nojoriiri nacanu coteequiaari: —¡Jiyaniijianaa! ¡Canaacua quia taraajere! Quiaacuajaari Pueyaso Jiyarosano, Jiyaniijia quia quiniuria pa supuetanaa jiyaniijia David niti. ");
INSERT INTO arlNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pueyari nojori juaarii nojori sanaajetanura juucua. Nojoriiri saaja jiyacatequee nacanura: —¡Jiyaniijianaa, canaacua quia taraajere, Pueyaso Jiyarosanonaa! ");
INSERT INTO arlNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesuuri socua nujuasee. Nojori sequereeri: —¡Miji! ¿Casaa nia paniya cua miiniuria niajaniyarani? ");
INSERT INTO arlNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jesu riucuatureeri: —¡Jiyaniijianaa, canaa namijiaa quia jeecare! ");
INSERT INTO arlNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesuuri nojoriicua taraajeree. Nojori namijiaa quiareeri. ¡Nojoriiri niquijiacara quiquii! Na nuhuaji, Jesuucua sacuaaree canaataari. ");
INSERT INTO arlNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Canaa quiojosacari, canaari socua tiuquiijiosee Betfagé tiacajiniani, Olivo nacuhua tuhuananu shuriucua. Cuniquiji, majaari puera tucuacaanu quiquiaari Jerusalén tiacajiniara. Jiyacaritij, Jesuuri caapiqui canaa na pueyajinijinio sequequiaari: ");
INSERT INTO arlNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Cuno tiacajinia nia quiaare, nooj pocuaji niquishiyatej. Niaari tii riuriatanutaniya niquiojuaraca burro morotasano. Niocua na samaacartasee. Niocua miji na jaatucuyarohuanoj, necojuataja. ");
INSERT INTO arlNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pueya jaara nia tenujunu paniri nocuaji, niocua na sequere: “Jiyaniijia na paniya. Ritia na tacatonutaniuhuacuaja”. ");
INSERT INTO arlNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Naa tohuateequiaariiri tariucuacaanu Pueyaso sequesano caminiujiunia sequesano, nojuaja jaara naa naajiotaquiaari Jerusalén tiacajinia quiniaa pueyara: ");
INSERT INTO arlNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sión tiacajinia quiniaa pueya nia sequere: ‘¡Nia niquiri! Nia Jiyaniijiaari burrojinia niaacua niya. Maninia pueyanoori, juayashijia. Burro nijinia cajiyano, necojuaacuanio’”. ");
INSERT INTO arlNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jiyacaritij, cuarta Jesu pueyari quiaquiaari. Nojoriiri naa miiquiaari taa Jesu sequequiaari nojoricuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nocua jaatucutuquiaariuhua burroori, necojuataja. Na nuhuaji, Jesu cajijiara, canaari canaa tucuaque toqueya niojoquiaari burro nijiniani, necojua nijinianio. Na nuhuaji, Jesuuri na nijinia cajirii. ");
INSERT INTO arlNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jiyanohua queraatia pueyari tii quiriquiaa. Nojoriiri na tucuaque toqueya muejoquiaari nucuaco Jesuucuaji. Tamasacaari jaamasucua piyotaquiaari Jesuucuaji niojotasocoriquiano nucuaco, nuu niquishaanura shanohua, juhua cutara jiyaniijiaacuaji maniniushitishano. ");
INSERT INTO arlNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jesu puetanaa, mariyata na nuhuaji nijionaajuhuaj, nojoriiri naa coteequiaari nacoojonura: “¡Pueyanaa, nioori pocuaji Tacuna! ¡Nojuacuajaari pa Jiyaniijia, pa supuetanaa jiyaniijia David niti! ¡Cuaara quiiria shuquiriaatia pa Pueyaso jiyarosano! ¡Jiyanohua maniniaari pa Pueyaso! ¡Cuaara shuquiritiasano quiiria!” ");
INSERT INTO arlNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesu tiuquishacari Jerusalén tiacajinia, puetunu tii quiniaa pueyajanaari jiuujiatecoquiaari. Sequetureeri: —¿Cantejaara cunoni, tiuquiyani? ");
INSERT INTO arlNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jesuta tiuquiijionaari nojori riucuaree: —Nojuacuajaari Jesu, Pueyaso sequenu panishano caminiujiunia, Nazaret tiacajinijinio pueyano, Galilea jiyajinijinio. ");
INSERT INTO arlNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na nuhuaji, Jesuuri Pueyaso Secojojua tiacari matacajinia tiuquiquiaari. Tii pueya niquishiiri seya niquitiojiyano. Jesuuri puetunu nojorijianaa tohuatanijioree. Cumaneeca tacatojojuaca juhuacutucua caponeetareeri, tee pueya niquitiojoriquiaa taucuaca cumaneeca, Pueyaso Secojojua tiajinia niquitiojosocoriquiano cumaneecaracuajani. Mococoonu niquitiojonaa cajitiucua caponeetareejaariuhuaj, tee mococoonu niquitiojosaariquiaacuajani Pueyasoocuara catijiasocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesuuri nojori sequeree: —Pueyaso sequesanocuajaari naa naajiotasaaquiaari tarijia: “Cua quiquioori sesojosaanutaniya Pueyaso Secojojua tia”. ¡Niaari saniniuujia na jiyatecanu nohuasenuujuaca quiquiora! ");
INSERT INTO arlNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Secojojua tiajinia na quishacarijia, cariyojuarujuri pueya, mariyata shipiiniquiujiuniaa pueyari nocua nijioquiaari. Jesuuri nojori naatanijioree. ");
INSERT INTO arlNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pueyacuara secojonaa jiyaniijianucuaari Moisés Naajioneejiniji niishitiojonaata Jesu shootiariquiaa cusosuhua naatanijiyano. Jiyacaritij, naatujooriiri Secojojua tiajinia naa nacooriquiaa Jesujiniji: “¡Pa supuetanaa jiyaniijia David niquiohuacuajinio supueno pueyano! ¡Nojuajaari pa Jiyaniijia!” Canaa Judiocuaca jiyaniijianucua niquishacari naa Jesu miishanotej, mariyata nojori tojishacari naatujoori, nojoriiri juaaquioree. ");
INSERT INTO arlNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nojoriiri Jesu nequesotaree: —¿Quiaate naatujoori tojiya casaa nojori sequeyani? ¡Nojoriiri jiyaniya quiaari Pueyaso Jiyarosano! Jesuuri nojori riucuaree: —¡Taaquiriirinij! Na tojiyacuajanijia. Maniniacuajaari nojori sequesano. ¿Majateeri nia serojonu quiquiaacuaja tariucuacaanu Pueyaso Rupaajinia naa sequesanotej: “Quiaari naatujoori niishitirii conaajanio, seetanujuanaa nojori maniniuhuaqueetanura quia Jiyarosano”? ");
INSERT INTO arlNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Naa nojori na sequenu nuhuajitij, Jesuuri nojori tiujiaquee. Jerusalén tiacajiniji quiaqueeri canaata Betania tiacajinia. Canaari tii maqueseeni. ");
INSERT INTO arlNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tariquiicuaji, Jesuuri Jerusalén tiacajiniara tacateriquiohua canaa na saquiriojosano pueyata. Jesuuri miaajeriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Higo naana niquiriiri nuu shuriucua nujuaano. Nocua canujiyareeri. Shaanoori quiriquiaa, saa na jaamasucuaja. Cunora, Jesuuri naana sequeree: —Majaari socua quia jajau sanishaanu quiniutianiya. ¡Naanaari ritia sorequee! ");
INSERT INTO arlNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Naa canaa niquishacaritij, canaari jiuujiatereeni. Canaari Jesu nequesotareeni: —¿Taateni? ¿Casaara higo naana sorequee ritiani? ");
INSERT INTO arlNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesuuri canaa riucuaree: —Seetanujuanaa nia sequeyanijia, niaa jaara Pueyasoocua tiuujiaca quiri nioojia nia niquijioteyaquiniutia nocuaji, niaa maara socua cutara miishano miiri, socua jiyajeneta cua miishanojiniji. Naacuajitij, niaa maara nia sequesano niquiri niaa jaara nio tuhuananu sequere: “Quia jaataare shoniniacu caminiajinia”. ");
INSERT INTO arlNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Puetunujuanaa nia masesano nia secojosacari Pueyaso, niaa jaara seetanujuanaa nocua tiuuri, niaari nia masesano masenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesuuri Pueyaso Secojojua tiajinia tiuquiquiaari. Tii pueya niishitiojoriquiaari. Jiyacaritij, canaa Judiocuaca jiyaniijianucuaari nocua catecanoquiaari. Nojoriiri pueyacuara secojonaa jiyaniijianucua quiquiaari, canaa Judiocuaca camarucuanio. Nojoriiri Jesu nequesotaree: —¿Canteeri quiajaniyani, naa quia miiniuriatej? ¿Canteeri quia jiyatecanu juhua canaa jiyaniijia quia quiniuriani? ");
INSERT INTO arlNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesuuri nojori sequeree saniniuujia: —Janiyari nia nequesotanutaniya saniniunijia. Niaa jaara cua riucuare, janiyacua nia sequerohua saniniunijia cante cua jiyaroquiaari naa cua miiniuriani. ");
INSERT INTO arlNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Naacuajitij, cua riucuature coteenu. ¿Cante Tiuquinijiona Juan jiyaroquiaari pueya na tiuquinijionurani? ¿Pueyasotee? ¿Tama pueyajaaja soj? Jiyacaritij, tama nojorijiaarijia juayonuutanu coteequiaari jiyasohuaja. Tama sequetooreejaarijia: —Paa jaara na riucuareni: “Pueyaso na jiyaroquiaari”, pa sequerucua: “¿Naatee? ¿Casaara na niishitiojosanoocua nia tiuyaquiquianucuaraarini?” ");
INSERT INTO arlNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Saniniuujia, paa jaara sequereni: “Nojuajaari nareja pueya jiyarosano quiquiaari”, ¡puereeta quiniutianiyari pajaniyara! Paacuajaari niishiyani puetunu pueyajanaari sequequiaa Tiuquinijiona Juanna seetanujuanaa Pueyaso sequesano caminiujiunia quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Naaratej canaa Judiocuaca jiyaniijianucuaari Jesu riucuaree: —Maja canaa niishiniu canariquitijia na jiyaroquiaaritijiaj. Jesuuri nojori sequeree: —Janiyajuhuaj, majaari cua sequenu quiniutianiya niajaniya cante cua Jiyaronani, naa cua miiniuriatej. ");
INSERT INTO arlNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesuuri naa nojori sequerohuacuhuaj: —¡Cua tojitiare! Tamonu pueyanoori caapiqui niyanuraca quiquiaari. Nojuajaari jiyapueranu jiyaroree: “Quiyanunaa, quiria quia poonijiosee uva cuhuariquiajinia quiarijia”. ");
INSERT INTO arlNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Neyanuuri saaja na riucuaree: “Maja cua quianu paniniu”. Na nuhuaji, niishiriojorohuari. Quiaqueeri. Poonijioseeri. ");
INSERT INTO arlNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Na queeri naa na nuhuajishana sequereejuhuaj. Neyanuuri na riucuaree: “Maniniacuaja, cua quenaa. Janiya quianutaniyani”. Na nuhuaji, majaari na quianu quiquiaari saaja. ");
INSERT INTO arlNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Taa nia sequeyani pueyanaa? ¿Teyano cuno caapiqui necohuajinijiniote na que tojijia quiquiaarini? Nojoriiri Jesu riucuaree: —Na jiyapueranucuaja. Naaratej, Jesuuri nojori sequeree: —Seetanujuanaa nia sequeyanijia. Cumaneeca masejonaa pa pueyajiniji Roma tiacajinia quijia jiyaniijiarani, mariyata paanatujurinio, cuno nia soosano pueyari nia shocotanutaniya Pueyaso muerasura nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Cua tojitiare casaara naa cua sequeree niajaniyani. Tiuquinijiona Juanri niquiaari na niishitiojonura juucua niajaniya, maninia nia quiniuria Pueyaso niquiara. Majaari nia tiuuniu quiquianu nocua. Niaari saaja na tojiyaquiquianu. Cumaneeca masejonaa nia soosano pueya cutaraari nocua tiuuquianu, paanatujurinio. Nojoriiri na tojitiajara quiquianu. Niaacuajaari na niquiquianu taa cuno sesa miijiaca pueya maninia pueyara jatacanuni. ¡Niajaniyarijiataj, majaari nia tacatonu quiquianu nioojia sesa nia quiniujiniji! Niaari saaja Tiuquinijiona Juancua tiuyashijiaca quiquianu. ");
INSERT INTO arlNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Socua tamonu cua pohuatasano nia tojiri. Tamonu pueyanoori cuhuariquiajinia uva natooquiaari. Maninia matacoquiaari puetunu na shuriuquiocojuanaari maja casaa tiuquitianura nocua. Saajia quejaquiaarijiaariuhuaj uva rapijiojuara, na caaca reratesaanura. Jiyaconajara tiaquiaarijiaariuhuaj, cojuana niquijiara tiji nohuasejojuaacuaji. Na nuhuaji, na camaruuri tamasaca pueya niquitioquiaari na cuhuariquia, nera nojori cojuasocoriquiano. Na nuhuaji, na camaruuri tucuacaanu quiaquiaari pueyaracaanu camueenujunura. ");
INSERT INTO arlNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jaara tari quiquiaari uva carojotasacari, saniya cuhuariquia camarujuanaari na seya jiyaramiquiquiaari na cuhuariquia cojuanaa pueyacua. Nojori jiyaramiquiquiaariiri nojori masenura cuhuariquia cojuanaa carojotasanojiniji, taa nojori pocoojoquiaari taricuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Cuhuariquia cojuanaari cuhuariquia camarujuanaa jiyaramiquishano seya quiooree. Niquiriyatu majacutureeri. Tamonu moturee cutaraari. Tamonu jacuturee saitiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Na nuhuaji, na camaruuri socua queraatia seya jiyaramiquiquiaariuhuaj. Nojoriiri naquiya miishaaquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Na nuhuaji, na camarujuanaari tama sequereejaaja: “Jiyaroreera cua niyanu. Maja cutara nojori rerequetenu quiniutianiya cua niyanu”. ");
INSERT INTO arlNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Cuhuariquia cojuanaa jaara niquiquiaari camarnujuanaa niyanu nojoriicua niyano, nojoriiri tama sequetooreejaaja: “¡Cunocuajaqui cuhuariquia camaru quiriquiano na que niti, na que jaara shaajequee! ¡Pa morej! Naacuajitij, pocua nio cuhuariquia camaruhuara quiquiini”. ");
INSERT INTO arlNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Naaratej, camarnujuanaa niyanu tiuquishacari, cuhuariquia cojuanaari na quiaree. Na jaatucutureeri cuhuariquiajiniji tamama. ¡Cuniqui na motureeri! ");
INSERT INTO arlNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Naa Jesu pohuatanu nuhuajitij, nojuajaari cuno canaa Judiocuaca camarucua nequesotaree: —¿Taa nia sequeyani pueyanaa? Cuhuariquia camaru jaara tiuquiriohua na cuhuariquiajinia, ¿taa na miiniutianiya cuno cuhuariquia cojuanaani? ");
INSERT INTO arlNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jesu tojitianaari na riucuaturee: —¡Cuno cuhuariquia camaruuri nojori puecoonutaniya, nojoriicua na taraajeyaquiniutia! Na nuhuaji, tamasaca pueya sequenutaniya cutaraari, nojori cojuanura nera na cuhuariquia. Nojori cutaraari cuhuariquia camaru panishano niquitionutaniya nojori carojotasanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesuuri nojori sequeree: —Jaa, naa miiniutianiyari. ¿Majate nia serojonu quiquiaaricuaja nio, tariucuacaanu Pueyaso Rupaajiniani?: “Pueyari saitia tiariquiaa. Nojoriiri tamonu saajia jiyaniquiaari saajia sesarujuajau naasucua. Cuno saajiacuajaari socua panishano saajia quiquiaari. Jiyaniijiajanaari naa na jiyatequiaari. Cuno saajiata tiaree maninia cutaraari. Pueya niquishacari, jiuujiatecoreeri”. Naa naajiotasano quiyacuajaari. ");
INSERT INTO arlNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Camarucuanaa, nocuaji nia numooteyanijia, Pueyasoori nia ruuretanutaniya maja tari nia quiniuria na muerasu jiitianaa. Tamasaca pueyari nia niti jiyatesaanutaniya cutara, nojori jiitianura maninia Pueyaso muerasurano. Nojoriiri maninia Pueyaso tojitianaa quiniutianiya cutara, Pueyaso muerasu canenura jiyanohua nera, juhua cuhuariquiajiniji senoosano queraatia. ");
INSERT INTO arlNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Cuno saajiajiniji saniniuujia, pueyano jaara cuno saajiaacua tiyare, nojuajaari juhua rashiquijiniutianiya. Cuno saajia jaara tiyare pueyanoocua, jacanaura na miiniutianiyari. ");
INSERT INTO arlNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pueyacuara secojonaa jiyaniijianucua, mariyata Fariseocuaca tojitiasacari naa Jesu pohuatasanotej, nojoriiri niishiquii Jesuuri nojorijiniji pohuatariquiaa miriqui. ");
INSERT INTO arlNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Naaratej, nojoriiri Jesu quianu panirii juucua, nojori juaaniutia. Nojoriiri saaja puereriquiaa pueya. Pueyacuajaari sequeriquiaa Jesuuri seetanujuanaa Pueyaso sequenu panishano caminiujiunia quiquiaari. Naaratej, jiyaniijianucuaari jiyamitia puerecoriquiaa Jesu nojori quianura. ");
INSERT INTO arlNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na nuhuaji, Jesuuri socua niishitiojoquiaari miriqui pohuatasanota. Naa pohuataquiaaritij: ");
INSERT INTO arlNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Pueyasoori pueya masuya nojoritia na quiniuria shuquiriaatia, taa tamonu cutara jiyaniijia miiquiaari mijiriacuaani. Cuno jiyaniijiaari shuquiriaatia quiniu paniriquiaa queraatia pueyata, neyanu camishacari. Naaratej, jiyaniijiaari queraatia sumatutequiaari, queraatia pueya miaquesocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Na nuhuaji, na seya jiyaramiquiriiri na masuusano pueya numootenura nojori niniuria queranacunura. Masuusano pueyari maja na niniu paniniu quiquiaari saaja. ");
INSERT INTO arlNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jiyaniijiaari socua tamasaca na seya sequeree: “Cua masuusano pueya nia numootejocoo. Nia sequesee: ‘Jiyaniijia nia sashiya. Puetunujuanaari tari jeenucuasano nia queranacunura. Tari puecoosaaree na juyaca, na shiyoshitishano seyanio. Tariucua rariyosanoori quiya. Ritia nia nimia. Nia miaquenuusee’”. Naa na seya na rootanu nuhuajitij, jiyaniijiaari nojori jiyaramiquirii. ");
INSERT INTO arlNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Masuusano pueyari saaja tojitiaaquirii. Puetunujuanaari tama na panishanojuaaja miiriquiaa saaja. Tamonuuri na cuhuariquiajinia quiaaree. Tamonuuri na casami niquitiojosaqui quiaareecujua. ");
INSERT INTO arlNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tamasacaari saniniuujia jiyaniijia seya quiooree. Jiyanohua naquiya nojori miiriiri. Na nuhuaji, nojori puecootureeri. ");
INSERT INTO arlNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jiyaniijia niishishacari, jiyanohua juaariiri. Nocuaji na soldadohua jiyaramiquiriiri cuno monaa nojori naminiuria saniniuujia, nojori tiaca na catijiatanurajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Na nuhuaji, jiyaniijiaari na seya sequeree: “Puetunujuanaari tari jeenucuasano pa queranacunura cua niyanu camishacari. Cua masuusano pueyacuajaari saaja cua ruuretareeni. Namitia majaari nojori nijionu quimiaa, saaja cua rerequetejaca nojori quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Quiarijia cutara, nia quiaare nuu tuneequetajajinia, tee queraatia pueya tajiniuucuataquiaacuajani. Nia masuure puetunu nia niquishano pueyajanaa”. ");
INSERT INTO arlNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","’Na seyari quiojoquiaari tiaca nucuaco. Nojoriiri puetunu na riuriatasano pueyajanaa rerejoteree, maninia pueya, sesa pueyanio. Queranacunuusaquiiri mishiquiaari masuusano pueyata. Camarnu seyari puetunu pueyajanaa cushiyotequiaari camishacari cushiyosano toqueya, nojori tiuquitiasacari tiaco queranacunura. ");
INSERT INTO arlNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Na nuhuaji, jiyaniijiajanaari tiuquiquiaari masuusano pueya na niquiniuria. Tamonu pueyano niquishiiri camishacari cushiyosano toqueeju. ");
INSERT INTO arlNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jiyaniijiaari na sequeree: “Pueyanonaa, ¿taa quia tiuquimiaa camishacari cushishano toqueejuni?” Pueyanoori sanaa na tojiriquiaa. Majaari na riucuanu quirii. ");
INSERT INTO arlNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Cunora, jiyaniijiaari na seya sequeree: “¡Nia morojore na cashacucua, na numatucuanio! ¡Niocua na jartarohua carijiniacuma ninishiqui! Tii sapuenutaniyari. Na quiaca miaquenutaniyajaariuhua na noonuta, naquiya na miishacari”. ");
INSERT INTO arlNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","’Naajuhuaj pueyanaa, Pueyasoori queraatia pueya masuya quiarijia na muerasu nojori quiniuria. Saniniuujia, secajaari saquiriojosaanutaniya nojorijinijinio seetanujuanaa na muerasura nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na nuhuaji, Fariseocuacaari quiojoquiaari Jesu shuriucuaji tama nojori niishitiojotoonurajaaja. Nojoriiri Jesu pocuatenu paniquiaari sesa juucua, nocuara nojori saquiriojotanura. ");
INSERT INTO arlNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Na nuhuaji, Fariseocuacaari na niishitiojosano pueya jiyaramiquirii Jesuucua, jiyaniijia Herodes panijiaca pueyata. Herodesri jiyaniijia César jiyatesano quiquiaari Judea jiyajinia jiyaniijia na quiniuria. Fariseocuaca jiyaramiquishano pueyari Jesu sequesee: —Niishitiojonanaa, canaari niishiyani quiaari maninia pueyano. Majaari quia cuaracashijionu. Quiaari seetanujuanaa casaa niishitiojoquiaa cutara taate canaa naata maninia quiniu Pueyaso niquiarani. Majaari quia puerenu quiquiaa, pueya niquiara quia pohuatanura quia niishishano. Majaari rimiajata quia niquiniu pueya. ");
INSERT INTO arlNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Naaratej, canaa quia sequere taa canaa miiniutianiyani. Paari sequesaaquiaarini pa cumaneeca pa niquitiojonura jiyaniijiajanaa Césarra, taa cuno tahue César sequequiaaricuajani. Quiajaniyariuhuaj, ¿taa quia sequeya saniniunijia? ");
INSERT INTO arlNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesuuri ritia niishiquii, nojoriiri naa na nequesotariquiaa na sapojonuta. Nocuaji nojori sequereeri: —Sapuenu maninia quijiacanaa, ¿casaara nia saniniujiya naa janiyani? ");
INSERT INTO arlNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Cua niquitiri nia cumaneetoj, cuno, jiyaniijia César sequesano pa niquitiojonura nojuajani. Nojoriiri Jesu niquitirii cumanee. ");
INSERT INTO arlNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesu niquishacari cuno cumanee, nojori nequesotareeri: —¿Cana naaquiti nio nocuani? ¿Cana sesate nocua naajiotasanojaniuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nojoriiri na riucuaree: —Jiyaniijia César naaquicuaja, na sesajuhuaj. Jesuuri nojori sequeree: —Jaara naa quiritij, César nia niquitiojore tama na casaajaaja. Nojuacuajaari na camaru. Saniniuujia, Pueyaso nia niquitiojore nerano tama na casaajaaja. Nojuaja cutaraari pa camarnu. ");
INSERT INTO arlNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nojori tojishacari naa Jesu sequesanotej, jiuujiatecoreeri. Na tarinitiatureeri. Quiojiyarohuari. ");
INSERT INTO arlNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Cuno juucaja, Saduceocuacaari Jesuucua nijioquiaari. Nojoriiri jiyaniquiaari macunucua maja na samiitiaconu quiniutianiuhua. Naaratej, nojoriiri Jesu sequesee: ");
INSERT INTO arlNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Niishitiojonanaa, supuetana Moisésri pa sequequiaari na naajiotasanojinia, pueyano jaara cusoyare mueyaju, na tarajanu cuaara camiiria mashiquio, mueya na mueratenura tarajanu niti. ");
INSERT INTO arlNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tarijia, tamonu pueyanoori niya quiquiaari. Siete niquiohuaraca quiquiaariiri, saa canuujua. Jiyapueranuuri camiquiaari. Na nuhuaji, shaajequiaariiri muetuhuojua. Naaratej, na mashiquioori camitishaaquiaari neyaca tarajanuta. ");
INSERT INTO arlNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nojuajaari muetuhuojua shaajequiaarijiuhuaj. Naaratej, neyaca tarajanuuri mashiquio camiquiaarijiuhuaj. Nojuajaari mueyaju cusoquiaarijiuhuaj. Naa cusonuuquiaariiri puetunu cuno siete canuujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na nuhuaji, mashiquioori cusoquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Saniniuujia, macunucua jaara samiitiacorohua, ¿teyano cuno siete neyacaajinijiniote seetanu neyacajanaa quiniutianiyani, puetunu cuno pojorijianaa jaara neyacaa quiquiaari? ");
INSERT INTO arlNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesuuri nojori riucuaree: —¡Niaari jiyanohua jiyajeneya nia niishiyaquishacari Pueyaso Rupaajinia naajiotasano, Pueyaso cumaacanio! ");
INSERT INTO arlNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Macunucua samiitiacosacariuhua, majaari canuu camiyonu quiniutianiya maaji. Naajuhuaj, maajipohuari maja na camiyonu quiniutianiya neyacaara. Caya, maajinio, nojoriiri juhuajaniya quijiaca quiniutianiya juhua jiyocuacaanu quijiaca Pueyaso seya, maja camiyosano. ");
INSERT INTO arlNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Socua cua tojitiare. Macunucuaari seetanujuanaa samiitiacoriquianohua. ¿Majateeri nia serojonu quiquiaacuaja taa Pueyaso sequequiaari niajaniyacuajani? Naa sequequiaariiri: ");
INSERT INTO arlNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Janiyari nia supuetana Abraham Jiyaniijiani, nia supuetana Isaac Jiyaniijiajuhuaj, nia supuetana Jacobo Jiyaniijianio”. Naaratej, nia sequeyanijia, Pueyaso muerasu shaajecononi, nojoriiri maja macunucua na quiniu. Canapuete seetanujuanaa Pueyaso muerasuni, nojori cutaraari pueyaracaanu quijiaca. ");
INSERT INTO arlNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pueya tojishacari naa Jesu niishitiojosanotej, nojoriiri jiyanohua jiuujiateree. ");
INSERT INTO arlNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseocuaca jaara niishiquiaari Jesu Saduceocuaca sanaajaree, nojoriiri Jesuucua nijioquiaari nojori saniniujiuniuria nojuaja, nojori nequesoreenuta. ");
INSERT INTO arlNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nojoriiri jaarajaaja Jesu pocuatenu paniriquiaa sesa juucua. Tamonu nojorijinijinioori Moisés Rootasanojiniji niishitiojona quiquiaari. Na saniniujiuniuria, nojuajaari Jesu nequesotaree: ");
INSERT INTO arlNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Niishitiojonanaa, ¿Pueyaso rootasanojinijini, teyanote socua pa tojishocoriquianoni? ");
INSERT INTO arlNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesuuri na riucuaree: —Naa naajiosano quiyacuajaari: “Quia Jiyaniijia Pueyaso quia paniri puetunu quioojiatajanaa, puetunu quia sohuanutajanaa, puetunu quia niishitiajatajanaanio”. ");
INSERT INTO arlNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Niocuajaari socua na pueya tojishocoriquiano Pueyaso rootasano. ");
INSERT INTO arlNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tamonu na sequesanoori quera juhua niojuhuaj. Naa sequeyari: “Quiarta pueyano quia paniri taa quia paniyacuaa tama quia cuaqueyajaajani”. ");
INSERT INTO arlNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Puetunu Moisés rootasanojuanaa, mariyata puetunu tariucuacaanu Pueyaso sequesano caminiujiuniaa rootasanojuanaari nio caapiqui rootasanojinijicuaja. ");
INSERT INTO arlNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseocuaca quishacarijia cuniqui, Jesuuri nojori nequesotaree: ");
INSERT INTO arlNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Taa nia niishiriojiya Cristojinijini? ¿Cante na supuetanani? Nojoriiri Jesu riucuaree: —Pa jiyaniijiarano Cristoni, nojuajaari pa supuetana David niquiohuacuajinio supuenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesuuri nojori sequerohuacuhuaj: —Taaquiriirinij. Jaara naa quiritij, ¿niaateeri niishiyacuaja casaara David sequequiaari “cua Jiyaniijiata” Cristocuaraarini, Pueyaso Sohuanu jaara na pocuatequiaari? Naa sequequiaariiri: ");
INSERT INTO arlNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Jiyaniijia Pueyasoori cua Jiyaniijia Cristo sequequiaari: ‘Cua miaquetajara quia cajirijiaara, janiya cuaara quia paraa shocojotare quiocuajijiaatijia’”. ");
INSERT INTO arlNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Cristotucua taa David niquiohuacuaji supuereni, David jaara Cristo jiyaniquiya na jiyaniijiata? ");
INSERT INTO arlNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nojoriiri Jesu niquitiaree sanaa. Nojoriiri maja na naata na riucuanu quiquiaari. Cuno nuhuaji, pueyari maja socua na nequesoreenu paniniu quiquiaari Jesu. ");
INSERT INTO arlNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Na nuhuaji, Jesuuri tii quiniaa pueya sequeree, canaa na saquiriojosano pueyanio: ");
INSERT INTO arlNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisés Rootasanojiniji niishitiojonaa, mariyata Fariseocuacaari supuetana Moisés niti quiya, tariucuacaanu Pueyaso Rupaa nojori niishitiojonura. ");
INSERT INTO arlNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Naaratej, nia tojitiare puetunu nojori sequesanojuanaa niajaniya. Saniniuujia, maja cutaraari nia miiniu taa nojori miiquiaacuaani. Nojoriiri najuhuana niishitiojoquiaa taa pueya miiniutianiyani. Majaari saniniuujia nojori miiniu tama nojori niishitiojosanojuaaja. ");
INSERT INTO arlNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nojoriiri tama nojori niishishanojuaaja rootaquiaa, maja saaja tariucuacaanu Pueyaso niishitiojosano pa supuetanaa. Nojori rootasano pueya miishocoriquianoni, cunoori juhua jiyanohua niiquia casaa pueya nitiasocoriquiano. Nojoriiri maja quenaaja na naacutanu quiquiaa na juaashiquia sacasaruta. ");
INSERT INTO arlNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nojoriiri puetunu na miishanojuanaa miiquiaa saaja pueya niquishocoriquiano, pueya shuquiritianura nojori. Nojoriiri Pueyaso Rupaajiniji naajiotasano cushitiaquiaa na jiniji morotasano, na numatucuaacuanio. Nojoriiri naa miiquiaa taa pa supuetanaa miiquiaaricuaani. Saniniuujia, nojoriiri najuhuana socua puereetuucara na quiquiora cusupuequiaa pueya shootiasocoriquiano. Naajuhuaj, nojoriiri na toqueecuaji sohuatacojua tunujutaquiaa taa pa supuetanaa Pueyaso tojitiajaca miiquiaaricuaani. Saniniuujia, nojoriiri puera tucuacujuara na tunujutaquiaa saaja pueya niquishocoriquiano, pueya shootianura nojori. ");
INSERT INTO arlNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nojori jaara masuusaare tamonu tiajinia queranacunura, nojoriiri secooquiaa socua panishano cajitiujinia nojori cajitiuniuria tia camaru shuriucua. Naajuhuaj, Pueyaso secojojua tiacajinia pueya rerejosacari, nojoriiri cajitiuniu paniquiaa camarucua cajitiucuajinia pueya shootianura nojori. ");
INSERT INTO arlNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nojori rucuanejosacari tiacajinia, nojoriiri paniquiaa pueya saruhuatanura nojori. Panitiuquiaajaariuhua pueya jiyaniquiniuria nojori “niishitiojonaata”. ");
INSERT INTO arlNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Niajaniya saniniuujia cua pueyanaa, majaari pueya shanacunu niaacua, nojori jiyaniquiniuria niajaniya “niishitiojonaata”. Niajaniya cutaraari niquiriyatujua Niishitiojonaraca. Puetunu niajaniyajanaari niarta Pueyaso pueya tapueyocuaca. ");
INSERT INTO arlNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Naajuhuaj, majaari tamonu pueyano mijiria nia jiyaniquiniu “cua queta”. Niaacuajaari niquiriyatu Queraca. Nojuajaari jiyocuacaanu Quinia. ");
INSERT INTO arlNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Naajuhuaj, majaari pueya nia shanacunu niaacua, nojori jiyaniquiniuria niajaniya “cua jiyaniijiata”. Niaari niquiriyatujua Jiyaniijiaracacuaja. Nojuacuajaari Pueyaso jiyarosano nia Jiyaniijiaranoni. ");
INSERT INTO arlNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Cante jiyaniijiajanaa cutara niajaniyajinijinioni, cuno cuaara jiyateera tama na cuaqueyajaaja nia cumaquinia na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Cante tama na cuaqueyajaaja jiyateja pueya shocotaja na quiniuriani, narta pueya jiyaramiquijia na quiniuriajuhuaj, jiyano pueyano cutaraari cararosaanutaniya. Cante saniniuujia juhua narta pueya serura jiyateja tama na cuaqueyajaajani, cunoori jiyaniijiara jiyatesaanutaniya cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Cua tojitiare, Moisés Rootasanojiniji niishitiojonaanaa, niajaniya Fariseocuacajuhuaj, niaari cocuaatia miiquiaa! ¡Niaari sapuenu juhua maninia quijiaca niquishano! Niaari pueya tarinitiaaquiquiaa nojori rupuenura Pueyaso. Niaari maja nia tiuuniu Pueyasoocua. Naajuhuaj, majaari pueya nia tarinitianu nojori tiuuniuria Pueyasoocua, na muerasura nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Niaari taraatia miishaanutaniya, Moisés Rootasanojiniji niishitiojonaanaa, niajaniya Fariseocuacajuhuaj! Niaari sapuenu juhua maninia miijiaca niquishano. Niaari mashiquiopue tiaca masequiaa secaja nia cumaneecata, nia sapojonuta nojori. Naacuajitij, niaari nojori tiaca masequiaa tama niajaniyarajaaja. Naa nia miiniu nuhuajitij, niaari shitiarayocua secojoquiaa najuhuana Pueyaso, pueya niquiara, maninia pueya nia jiyanishaanura. Naaratej, niaari socua jiyanohua saniitiosaanutaniya tamasaca pueyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Niaari puereeta miishaanutaniya Moisés Rootasanojiniji niishitiojonaanaa, niajaniyajuhuaj Fariseocuacanaa! Niaari sapuenu juhua maninia miijiaca niquishano. Niaari tucuacaanu rucuanejoquiaa jiya caco, shoniniacu caminia taquijirianio, tamonu nia niishitiojonura najuhuana Pueyaso tojijiara na quiniuria juucua, juhua tama niajaniyajaaja. Nia niishitiojosano pueyano jaara nia tojijiara quiri, nojuajaari socua jiyanohua saniitiosocoriquiano quiya niajaniyajiniji, sesa nia rootasano tojijia na quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Niaari taraatia miishaanutaniya mosanucuanaa! Niajaniyari juhua cariyojuaru, cante tamonu pueyano jaatucuya juucuani, nuu nia niishiyaquishacari. Naacuajitij, niaari capa niishitiojoquiaa. Niaari rootaquiaa, pueyano panishacari tamonu tiuuniuria na sequesanoocua, nojuaja cuaara sequeera: “Taa oro Pueyaso Secojojua tiajinia pueyaracaanu quiyacuaani, naajuhuaj, cua sequesano quiajaniyari seetanujuanaa tohuateenutaniya quiara”. Saniniuujia, niaari sequequiaa, Pueyaso Secojojua tiajinia oro jaara sequeyaquishaare, majaari na sequesanoocua tiuushaanu. Naacuajitij, niaari sequequiaa, pueyano sequesanoori nareja sequesano, nojuaja jaara sequere: “Taa Pueyaso Secojojua tia pueyaracaanu quiyacuaani, naajuhuaj, cua sequesano quiajaniyari seetanujuanaa tohuateenutaniya quiara”. Niaari sequequiaa cuno sequesanoocuaari maja tiuushaanu. ");
INSERT INTO arlNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mosanucuanaa, niaari juhua cariyojuaru! ¿Teyanote socua pueresanoni, cuno orotee, Pueyaso Secojojua tia soj? Cuno oroori naa pueresanora jiyatesaaquiaari saaja Pueyaso Secojojua tiajinia na quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Niaari rootaquiaajuhuaj, pa sequesacari parta pueyano, casaa pa miiniutianiya nerani, pocua na tiuuniuria paa cuaara sequeera naatej: “Seetanujuanaa quia sequeyanijia. Naatej, taa casaa Pueyasoocuara catijiaja juhuacutuucua niasano jiyanohua maninia quiyacuaa Pueyasorani, naajuhuaj, cua sequesanoori saaja maniniajuhuaj. Majaari cua sapojonu”. Naacuajitij, niaari sequequiaa, paa jaara naa sequereni, paa cuaara miiria pa sequesano. Saniniuujia, niaari sequequiaa: “Pa sequesanoori najuhuana sequesano, paa jaara saaja Pueyasoocuara catijiaja juhuacutu sequereni. Majaari nocua tiuushaanu”. ");
INSERT INTO arlNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Cariyojuarujuriniaa! ¿Majateeri nia niishiniu? ¿Teyanote socua maniniani, Pueyasoocuara catijiasocoriquiano casaatee, Pueyasoocuara catijiaja juhuacutu soj? Catijiasocoriquiano casaari narejajuhuanajaj, jaara Pueyasoocuara catijiajaacua niasoo quiyaquiri. ");
INSERT INTO arlNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Naaratej, cante Pueyasoocuara catijiaja sequeree seetanujuanaani, nojuajaari maja saaja Pueyasoocuara catijiaja na sequenu quirii. Nojuaja cutaraari na caco niasano sequereejuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Naajuhuaj, cante Pueyaso Secojojua tia sequeree najuhuanani, cunoori maja saaja Pueyaso Secojojua tia na sequenu quirii. Nojuajaari Pueyaso sequereecuaja, Pueyaso Secojojua tia na sequesacari. ¡Pueyasocuajaari na Secojojua tiajinia quijia! ");
INSERT INTO arlNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Naajuhuaj, pueyano jaara sequere na sequesano seetanujuanaa juhua jiya cajiniocua, nocua tiuushaanura, cunoori maja saaja jiya cajiniocua na sequenu quirii. ¡Pueyaso cajishaqui sequereejaariuhuaj, Pueyasojuanaa sequereejaariuhuaj, jiyocuacaanu casaa na sequesacari! ");
INSERT INTO arlNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Niaari taraatia miishaanutaniya, Moisés Rootasanojiniji niishitiojonaanaa, niajaniyajuhuaj Fariseocuacanaa! Niaari sapuenu juhua maninia miijiaca niquishano. Niaari Pueyaso niquitiojoquiaa maninia puetunu nio nia nataujinijijianaa, shanohua jaanujua jaamasucua, miaquesanojinia jatasano casaa: menta, anis, cominonio. Niaari jacaria serojoquiaa diez casaa puetunu cuno cien casaajinijijianaa, Pueyasora nia niquitiosocoriquiano taa supuetana Moisés sequequiaaricuajani. ¡Niaari saniniuujia socua pa tojishocoriquiano Moisés rootasano tojitiaaquiquiaa! ¡Naacuajitij, majaari maninia pueyano nia quiniu taa Moisés rootaquiaaricuajani! ¡Majaari nia taraajenu quiquiaa niarta pueyanoocua! ¡Majaari nia tiuuniu Pueyasoocua! Niaari maninia niquitiojoquiaa nia nataacuacajiniji. Taa nia niquitiojoquiaa nia nataacuacajinijicuaani, ¡naa nia tojitiarejuhua socua pa tojishocoriquiano rootasano Moisés Naajiotasanojiniji! ");
INSERT INTO arlNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Pueya nia niishitiojosacari Moisés Rootasanojiniji juucua, niaari juhua cariyojuaru cante narta cariyojuaru jaatucuya juucuani. Niaari juhua tamonu pueyanojuhuaj. Na ratusacari, nujujua taquirii na mashacajinijiiri. Socua na ratusacariuhua, ¡saaja cuartia miataaree juhuajaniyari! ");
INSERT INTO arlNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Niaari cocuaatia miiquiaa, Moisés Rootasanojiniji niishitiojonaanaa, niajaniyajuhuaj Fariseocuacanaa! Niaari sapuenu juhua maninia miijiaca niquishano. Niaari juhua noo pueyajuhuaj, cante nareja na ratujua cuaqueya jeequejoquiaani, na miacojua cuaqueyanio. Na jiniacumaari saniniuujia jiyanohua curuutuuca quiyajaa. Nio miriqui cua sequesano nia niishiri. Nioojiaari naa quiyajuhuaj. Niaari nohuasenuujuaca, jamuejacanio. ");
INSERT INTO arlNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Cariyojuaru Fariseocuacanaa, nia ratujua jiniacuma nia jeequere coteenu, nia miacojua jiniacumanio! Naacuajitij, na cuaqueyari maninia jeequesano quiniutianiyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Niaari taraatia miishaanutaniya, Moisés Rootasanojiniji niishitiojonaanaa, niajaniyajuhuaj Fariseocuacanaa! Puetunu niajaniyajanaari sapuenu juhua maninia miijiaca niquishano, juhua macunucua quiquio shanohua niquishano, cohuajata noshijiosano. Saniniuujia na jiniacuma quiyari sacuaraatia jaanujua pueya nucuhua mocuaca. ");
INSERT INTO arlNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Niaari naajuhuaj. Niaari sapuenu juhua maninia pueya niquishano. Saniniuujia nioojiaari jiyanohua sesa, jiyanohua sapojonu niishijia. ");
INSERT INTO arlNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Niaari taraatia miishaanutaniya, Moisés Rootasanojiniji niishitiojonaanaa, niajaniyajuhuaj Fariseocuacanaa! Niaari sapuenu juhua maninia miijiaca niquishano. Niaari macunucua niojotajara shanohua niquishano shipinijioquiaa, tariucuacaanu pueyara Pueyaso sequesano caminiujiuniaa nucuhuacuaji. Naajuhuaj, niaari tariucuacaanu Pueyaso tojitiajaca puecoosano quiquio maniniushitijiaca. ");
INSERT INTO arlNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Naa nia miishacaritij, niaari juhua sequequiaaruhua: “Paa jaara shipinijiosaaquiaari pa supuetanaa quishacarijia tariucuacaanuni, paa maara nojori cojiyaquiquiaari cutarani, nojori puecoosacari Pueyaso sequesano caminiujiuniaa”. ");
INSERT INTO arlNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Saniniuujia, naa nia sequesacaritij, niaari tama niaacuara toreejaacujua. Niaaquiiri cuno tariucuacaanu Pueyaso sequesano caminiujiuniaa puecoonaacuajinio supuenocuaja. ");
INSERT INTO arlNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Naa Pueyaso sequesano caminiujiuniaa puecoonaacuajinio supueno nia quishacaritij, Pueyaso Jiyarosano nia morejuhuaj, nia tucuatanura nia supuetanaa coteesano. ");
INSERT INTO arlNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Sesa miijiaca pueyanaa, niaari noonacuraca, juhua sacocua! ¿Niaateeri jiyaniya niaari saniitioyaquishaanutaniya mani quiquiojinia nia supuetanaata? ");
INSERT INTO arlNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","¡Cua tojitiare! Janiyari Pueyaso rupaa caminiujiuniaa jiyaramiquiniutianiya niaacuani, Pueyaso Rupaa niishijiacajuhuaj, Pueyaso rupaa niishitiojonaanio. Nojoriiri nia pohuatanutaniya Pueyasojiniji. Niaari noojiaqueya nojorijinijinio puecoonutaniya. Niaari tamasaca teetejonutaniya niyacutesanojinia nojori nia monura. Niaari tamasaca majacunutaniya Pueyaso secojojua tiacajinia. Niaari tamasaca neteyojotanutaniya puetunu tiacajinijijianaa, naquiya nia miiniuria nojori. ");
INSERT INTO arlNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Niaacuajaari niishiya, coteenujuanaa mosaaquiaariiri Abel, maninia miijia pueyano. Naa puecoosaaquiaariiri queraatia Pueyaso tojitiajaca pueya. Na nuhuaji, socua jaatesaaquiaari monuuri Zacarías, Berequías niyanu. Cuno maninia pueyanoori mosaaquiaari Pueyaso Secojojua tiajinia, Pueyasoocuara catijiasaqui shuriucua. Monu porocua nia quiniuucua taa nia supuetanaa quiquiaaricuaani, niaari saniniuujia nocua namishaanutaniyacujua puetunu tariucuacaanu Pueyaso tojitianaa puecoosaanuucuajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Seetanujuanaa nia sequeyanijia, nio pa quishacari pueyani, nojoriiri saniitiosaanutaniya puetunu cuno pueya puecoosaanuucuajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Jerusalén tiacajinia quiniaa pueyanaa, jiyanohua taraajeya niaacuanijia! Niaari Pueyaso sequesano caminiujiuniaa pueya puecoojuaca. Niaari Pueyaso jiyaramiquishano pueya jacujuaca saitia nojori pohuatanuucua Pueyaso rupaa nia niquiara juucua. Janiyari cucua nia nijionura panijia juucuani taraatia nia miyaquishaanuucuaji cua tacunura niaacuaji, naate taa caacaraja rijioquiaacuaa necohua na nesu cariquiacorani, na cojuanura nojori. Niaari saaja cua paniyaquijia cua cojuanura niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Cua tojitiare. ¡Niaari nia quiquiojiniji sanaajasaanutaniya niiquiji! ");
INSERT INTO arlNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Seetanujuanaa nia sequeyanijia, majaari socua nia niquiniu quiniutianiya janiya, niaa cuaara cua tiuquishacariuhua sequerejaatijia: “Pueyaso cuaara shuquiritiiria pa Jiyaniijia quiriquiano na jiyarosano.” ");
INSERT INTO arlNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesuuri Pueyaso Secojojua tiajiniji tohuataarohua. Nata canaa quiojosacari nucuaco, canaa, na saquiriojosano pueyani, canaari nocua catecanoquiaarini. Canaari Jesu niquitiriquiaa Pueyaso Secojojua tiani, shanohua niquishano tia. ");
INSERT INTO arlNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesuuri saa canaa riucuareejaa: —Jaa, na niquiyacuajanijia. Niaa cumaati maninia na niquiyacujua. ¡Seetanujuanaa nia sequeyanijia, cuno tia niaa na niquiyani, cunoori niyartasaanutaniya puetunujuanaa! ¡Majaari quenaaja tamonu saajia manu quiniutianiya tamonu caco! ");
INSERT INTO arlNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na nuhuaji, canaari Olivo cuhuariquia tuhuananuucua quiojoquiaarini. Jesu cajishacari tii, canaa na saquiriojosano pueyani, canaari nocua catecanoquiaarini. Tama canaa quishacarijiaaja, canaari na nequesotareeni: —Canaa quia sequere ¿taacari Pueyaso Secojojua tia niyartasaanutaniyani? Naajuhuaj, ¿taa canaa niishiniutianiyarini taacari quia tacatenutaniuhua mijiriani? Canaa quia sequerejuhuaj, ¿taacari jiya puequenutaniyani? ");
INSERT INTO arlNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesuuri canaa riucuaree: —Tama nia cuaqueyajaaja nia cojuare tamasaca mariqui nia sapojoreeri. ");
INSERT INTO arlNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Queraatia sapojonuujuacaari supuenutaniya. Nojoriiri tama na cuaqueyajaaja sequenutaniya: “Janiyacuaja Cristoni, Pueyaso Jiyarosano”. Naa nojori sequesacaritij, queraatia pueya sapojonutaniyari. ");
INSERT INTO arlNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Naajuhuaj, niaari pueyapue miaquetoojonujiniji tojiniuuniutianiya, niya, tamonu jiyacajinianio. Niaari miaquetoojonura miananajotoonujiniji tojiniuuniutianiyajuhuaj. Niaa jaara naa tojiniuuritij, majaari puerenu. Naa quiniutianiyari mijiria. Naajaa, juhuanojuajaari maja jiya puequesacari quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tamonu pueyari tamasaca pueyata miaquetoojonutaniya. Tamonu jiyajiniji jiyaniijiaari tamonu jiyaniijiata miaquetoojonutaniyajuhuaj. Jiyacaritij, jiyanohua miaajenuuri quiniutianiya queraatia jiyacajinia, cusonuunujuhuaj. Rijiaari queraatia jiyacajinia jiuuquiujiutianutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Naa naquiya miishacari mijiriatej, cunoori juhua manajaraca coteesacari noonu. Na nuhuaji, socua jiyacatenutaniyari naquiya miishacari, mijiria cua tiuquiyaquishacarijia. ");
INSERT INTO arlNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Jiyacaritij, niaari jiya camarucua niquitiojosaanutaniya cua muerasu nia quiniuucua, naquiya nojori miitianura niajaniya. Niaari puecoosaanutaniya. Puetunu jiyacajinijinio pueyajanaari nia niquiniu paniyaquiniutianiya, cua muerasu nia quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jiyacaritij, queraatia cucua tiuuniaa pueyari cucua tiuuniu tarinitianutaniya nojori jaara naquiya miishaare. Nojoriiri narta Pueyaso muerasu tacartanutaniya. Majaari nojori niquiniu paniniu quiniutianiya tarijia narta Pueyaso muerasu. ");
INSERT INTO arlNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Queraatia sapojonuujuaca Pueyaso rupaa pohuatanaari supuenutaniya. Nojoriiri queraatia pueya sapojonutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jiyacaritij, sesa miiniuuri socua jiyanohua jiyacatenutaniya mijiria. Cunora, queraatia pueyari narta pueya paniniu tarinitianutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Saniniuujia, cucua tiuujia jaara rejeretare pueyaracaanu cuno naquiya miishacari jiya cuaara puequerejaatijia, nojuaja cutaraari shacantuuca quijiara jatanishaanutaniya, pueyaracaanu na rishiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pueyaso rupaa jaara pohuatasaare janiyajiniji pueyapue niquiara puetunu jiyacajiniajanaa, nojori niishiniuria taate nojori naata cua muerasura quiniuni, jiyacaritij, jiyari shusha puequenutaniya cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Pueyaso sequesano caminiujiunia Danielri tariucuacaanu pohuataquiaari sacuaraatia casaanaari supuenutaniya, puereeta niquishano. Cunoori Pueyaso pueya shaajariquiano. (Cante nio serojiyani, cuaara niishiiria casaa na sequeyani.) Niaa jaara cuno sacuaraatia casaa niquiri Pueyaso Secojojua tiajinia nujuatesano, niocua mashiri. ");
INSERT INTO arlNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jiyacaritij, canapuete Judea jiyajinia quiyani, nojori cuaara mashiiria tuhuananuhuacua. ");
INSERT INTO arlNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Canapuete na tia cacojiria quiyani, nojori cuaara tiuquiyaquiiria na tiajiniaaco maja na tarishiniuria na casamiicua. ");
INSERT INTO arlNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Canapuete cuhuariquiajinia quiyani, cuaara tacateyaquiuhuara na tiajiniohua na toqueyacua. ");
INSERT INTO arlNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jiyacaritij, jiyanohua taraatia quiniutianiyari maajipohuara, canapuete manajaatohua quiyani, mariyata canapuete supuejaca muerasu jiitiaani. ");
INSERT INTO arlNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Juhuacarijia Pueyaso nia secojoriquia nia mashiyocuatunu panishacari quiyaquiniuria shuniyara, samaatenu juucanio. ");
INSERT INTO arlNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Cuno quishacari, jiyanohua naquiya miiniuuri quiniutianiya seetanujuanaa. Jiya coteenujiniji, jiyano naquiya miiniuuri maja na niquishaanu quiquiaari tari. Naajuhuaj, naa naquiya pueya miiniu nuhuajitij, majaari socua na caminiu quiniutianiuhua juhua nio naquiya miiniu. ");
INSERT INTO arlNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Cuno naquiya miishacari jaara tajiyaquiri ritia, pueya maara cureyaquirij. Pueyaso cutaraari na tajitiniutianiya ritia, na saquiriojosano pueyacua na taraajesacari. ");
INSERT INTO arlNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Jiyacaritij, majaari nia tojiniu, tamonu jaara sequere niajaniya: “¡Cua tarajanunaa, Cristoqui tari tiuquiriohua! Niya quiyano”. Naajuhuaj, majaari nia tojiniu tamonu jaara nia sequere: “Nooj, jati quiyatej”. ");
INSERT INTO arlNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Queraatia sapojonuujuacaari supuenutaniya. Nojoriiri tama na cuaqueyajaaja jiyatenutaniya juhua Pueyaso jiyarosanora. Tamasacaari sequenutaniyacujua: “Janiyari Pueyaso sequenu panishano caminiujiuniani”. Nojoriiri pueya sapojonutaniya jiyajeneta nojori miishanota. Naa nojori miishacaritij, mijiria quiniaa pueyari jiyaniniutianiya nojoriqui seetanujuanaa Pueyaso jiyaramiquishano. Jaara na naata quiri, Pueyaso saquiriojosano pueya sapojonutaniyajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pueyanaa, naa cua sequesacari niajaniyatej, janiyacuajaari juhuacarijia nia numootereeni. ");
INSERT INTO arlNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Naaratej, majaari nia quianu cua pajenuucua, pueya jaara sequere niajaniya: “Cristo jati cariiquia jiyajinia quiya”. Naajuhuaj, majaari pueya nia tojiniu nojori jaara sequere niajaniya: “Miji, Cristo sohuacamara cajiya. Nia niquishiijia”. Majaari nia shanacunu naa nia sapojosaanuratej. ");
INSERT INTO arlNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mijiria cua tiuquishacariuhua, majaari jiyasohua cua tiuquiniu quiniutianiuhua. Naatej, taa pueya niquiquiaa miacana nunujiyano pananu muetasamajicuaani, pananu tiuquishocoranio, pueyari naa cua niquiniutianiya cua tiuquishacariuhua. ");
INSERT INTO arlNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tee casaa mocua quiyani, mohuari tii rerequeejonutaniya. Jesuuri naa niishitiojoriquiaa miriqui, mijiria quiniaa pueya jaara sesere puera, nojoriiri saniitiosaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesuuri naa canaa pohuataquiaari socuatej: —Ritia naquiya miishaanu nuhuajijia, pananuuri ninishiquiria quiniutianiya. Racaari maja na cuhuatanu quiniutianiya. Riyari totenutaniya. Jiya cajiniocua cumaaca jiitiajacaari tetecatunutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jiyacaritij, puereeta casaari jiya cajiniocua niquishaanutaniya, mijiria quiniaa niishiniuria janiyari quera roseyani. Puetunu nio jiyajinia pueyapuejanaari sapiyonuunutaniya, jiyanohua nojori taraajenuta. Na nuhuaji, cua niquitiuniutianiyari cohuaja najacajinia roseyano, jiyanohua cua cumaacata, jiyanohua shacantuuca. ");
INSERT INTO arlNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Janiyari jiyocuacaanuji cua seyata tiuquiniutianiuhuani, cua jiyaramiquiniuria nojori puetunu cua saquiriojosano pueyacuajanaa. Nojori tojitiasacari trompeta jonenenu jiyanohua, nojoriiri cua saquiriojosano pueya rerejotenutaniya cucua, puetunu nio jiyajinijijianaa. ");
INSERT INTO arlNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Nia pohuatareera higo naanajiniji, socua maninia nia niishiniuria taacari jiya puequenutaniyani. Higo naana cashacucua jaara macumaaca quiri, na jaamasucuaari mueratiuya. Naa nia niquishacaritij, niaari niishiya tacareejonuqui quera quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Naajuhuaj, niaa jaara puetunu cua sequesanojuanaa niquiri tari tohuateyano, niocua niishiri janiyari quera tiuquiuhuani. Tari jiya puequesacari quera. ");
INSERT INTO arlNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Seetanujuanaa nia sequeyanijia, nio pa quishacari pueyani, majaari nojori shaajenu quiniutianiya juhuanojuaja, nojori cuaara puetunujuanaa cua pohuatasano niquirijiaatijia. ");
INSERT INTO arlNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jiya, jiya cajiniocuanio, cunoori shaajenutaniya. Cua sequesano cutaraari tohuateenutaniyacujua. Cua rupaari pueyaracaanu seetanu rupaajanaa quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Maja cutaraari quenaaja tamonu pueyano niishiniu taacari jiya puequenutaniyani, mariyata taacari cua niniutianiuhuani. Jiyocuacaanu quiniaa Pueyaso seyari maja na niishiniujiuhuaj. Majaari quenaaja cua niishiniujiuhuaj. Saaja cua Queeri tamajaaja na niishiya cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Quera cua tiuquiniu panishacariuhua, mijiria pueyari juhuajaniya quiniutianiya taa Noé quishacari mijiria tariucuacaanu pueya quiquiaaricuaani. ");
INSERT INTO arlNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jiyacaritij, nio jiya pajaashitiaaquishacarijia, supuetanaari juhuajaniya miaquenuujua quiquiaari. Juhuajaniya queranacunuuriquiaajaariuhuaj. Juhuajaniya necohua camiyoteriquiaajaariuhuaj Noé jaara tiuquitiaquiaarijiaatijia na puereetuuca buquejiniacuma. ");
INSERT INTO arlNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nojoriiri saaja juhuajaniya quiriquiaa pajaa jaara nojori pajaashitiaquiaarijiaatijia. Puetunu pueyajanaari canashiyaquiji netasaaquiaari. Mariyata naa quiniutianiyari cua tiuquishacariuhua. ");
INSERT INTO arlNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jiyacaritij, caapiqui pueya quishacari cuhuariquiajinia, niquiriyatuuri rishaanutaniya, Pueyaso pueyano na quiniuucua. Tamonuuri jateenutaniya saniitiosocoriquiano saniniuujia. ");
INSERT INTO arlNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Naajuhuaj, caapiqui maajipohua riiquiniuushacari tunanajiniacuma, niquiriyatuuri rishaanutaniya. Tamonuuri jateenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nocuaji juhua sutejaca nia quiriquia. Majaari nia niishiniu taacari nia Jiyaniijia tiuquiniutianiuhuani. ");
INSERT INTO arlNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nio nia niishiri. Tia camaru jaara niishiriquia taacari nohuasejojua niniutianiya nocuani, nojuaja maara nocuaji sutere maja nohuasejojua tiuquiniuria na casami nohuasenura. ");
INSERT INTO arlNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Naaratej pueyanaa, niaa cumaati cua sashiya, janiya mariqui nia jiyajenetemohuarini. ");
INSERT INTO arlNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Socua cua pohuatasano nia tojitiare pueyanaa. Jiyanohua casamiriaca pueyanoori queraatia seyaraca quiquiaari. Cuno jiyaniijiaari tucuacaanu quianu paniquiaari tamonu jiyajinia. Naaratej, na nuhuajiria, nojuajaari niquiriyatu na seyajinijinio jiyatequiaari juhua na tia camarura, narta seya na mianuutenura maninia, puetunu juucajanaa. Cuno seruuri niishijia quiquiaari, na camarnu tojijiajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Cuno seruuri shuquiriaatia quiniutianiya na camarnu jaara na riuriatasuhua maninia poonijiyano taa na camarnu sequequiaari na nuhuajiriacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Naaratej, seetanujuanaa nia sequeyanijia, na camarnuuri na jiyatenutaniya puetunu na jiitiasanojuanaa cojuanara. ");
INSERT INTO arlNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Saniniuujia, cuno seru jaara sesa miijia quiri, nojuajaari tama sequenutaniyajaacujua: “Cua jiyaniijiaari jiyanohua tarishiniutianiya”. ");
INSERT INTO arlNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jaara naa niishiriojore, nojuajaari narta seya piquiniu coteenutaniya. Mashaasequenuujuaca cojiniutianiyajaariuhua queranacunuunura. ");
INSERT INTO arlNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Naa juhuajaniya na quishacaritij, na jiyaniijiaari jiyacari na jiyajenetenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Naa sesa na quiniuucuatej, na jiyaniijiaari jiyanohua na saniitionutaniya. Na nuhuaji, na jatanutaniyari na cojiritiasocoriquiano saniitionu sapuenu juhua maninia niquishano miijiaca pueyata. Nojoriiri tii nujuquetunutaniya. Na quiaca miaquenuunutaniyari, naquiya na miiquiosacari. ");
INSERT INTO arlNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Nia pohuatareera taa Pueyaso shuriucua tiuquitianu panijiaca quiniutianiya cua tiuquishacariuhuani. Nojoriiri juhua diez niyacoojori quiniutianiya, canapuete camiriquiano pueyano sashiriquiaacuajani. Cuno niyacoojoriiri quiojoquiaari camiriquiano pueyano sashiniuria, na tiuquishacari nojori tiuquitianura nata tiaco. Nojoriiri samaritiu patootaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco cuno niyacoojorijinijiiri mosanucua quiquiaari. Tamasacaari saniniuujia niishijiaca quiquiaari cutara. ");
INSERT INTO arlNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mosanucuaari saaja niquiriyatu samaritiu patootaquiaari. Majaari socua samaritiu nojori panu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Niishijiaca cutaraari socua samaritiu pooquiaari, nojori samaritiu puequesacari na noshitishocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Camiriquiano pueyano tarishishacari, puetunu nojorijianaari maquenuujuquiaari. Nojoriiri socua maquetuquee. ");
INSERT INTO arlNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Shiyaqueya, tamonu pueyanoori nacaquiaari: “¡Camiriquiano pueyano cumaji tari! ¡Nia naacusee!” ");
INSERT INTO arlNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Puetunu cuno niyacoojorijianaari ritia saneecuatuquiaari. Quera pueetacoyano na samaritiu nishiriiniuuriiri. Nocuaji niishijiaca niyacoojoriiri socua na pootusano samari noshitirii. ");
INSERT INTO arlNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jiyacaritij, mosanucua niyacoojoriiri narta niyacoojori sequeree: “Canaara nia rashiquiojoreja nia samaritiujiniji. Canaa samaritiu tari pueetaareeni”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Cuno cinco niishijiaca niyacoojoriiri nojori riucuaree: “Maja. Maja maninia canaa niquitionura niajaniya, puetunu pa samaritiujianaacua senota pueetama. Ritia nia quiaare juhuari na masejosaqui, socua nia masenura tiji”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Cuno mosanucua niyacoojori quiojosacari samari masenuucua, camiriquiano pueyanoori nojori niyacari tiuquishii. Cuno samaritiuriaca niyacoojori cutaraari camiriquiano pueyanota tiuquitiaquiaari camishaqui tiaco queranacunura. Tia tiootiuuri mishiquiosaaree. ");
INSERT INTO arlNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Na nuhuaji, mosanucua niyacoojoriiri tiuquiijioquiaariuhua. Tia tohuateyaji jiiquioonuusuhuari. Sequetureeri: “¡Jiyaniijianaa, jiyaniijianaa, canaacuaji quia riatareja tiootiu!” ");
INSERT INTO arlNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Jiyaniijiaari saa sequereejaa: “Seetanujuanaa nia sequeyanijia, maja cua niishiniu niajaniya”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Naa na pohuatanu nuhuajitij, Jesuuri canaa na saquiriojosano pueya sequeree: —Pueyanaa, nia quiri juhua sutejaca, nia niishiyaquishacari taacari cua tiuquiniutianiuhuani, casaa juucatej. ");
INSERT INTO arlNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Na nuhuaji, Jesuuri socua miriqui pohuataquiaari canaa na niishitiojonura taa Pueyaso muerasu miishaanutaniya jiya puequesacarini. Jesuuri naa canaa pohuataquiaaritij: —Tamonu jiyaniijiaari tucuacaanu quianu paniquiaari tamonu jiyajinia. Na nuhuajiria, na seya niquitiojoquiaari na racatasano cumaneecaari, nojori cuaara poonitijioora cuno cumaneeca na canijiasocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Naacuajitij, coteenu seru niquitioree cinco mil cumaneecaari. Tamonuuri niquitiosaaree dos mil. Tamonuuri niquitiosaaree mil cumaneeca. Na jiyaniijiaari naa nojori niquitiojoquiaari na niishishacari nojoriiri rimiajata niishijiaca quiquiaari, socua cuno cumaneeca nojori canijianura. Na nuhuaji, nojori jiyaniijiaari quiaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Cinco mil cumaneeca jiitianaari ritia coteequiaari casami masenura na niquitiojosocoriquiano socua cumaneecara, na reratenura na jiyaniijiara. Naacuajitij, cuno seruuri socua cinco mil cumaneeca reratequiaari coteenu na jiitiasanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Naajuhuaj, dos mil cumaneeca jiitianaari socua dos mil cumaneeca reratequiaari na jiitiasanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mil cumaneeca masenaari saniniuujia maja na poonitijionu quiquiaari na jiyaniijia niquitiosano cumaneeca. Nojuajaari saaja jiyajinia jiuutiaquiaari na jamojuara na jiyaniijia cumaneeca. ");
INSERT INTO arlNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Seya jiyaniijiaari camueenujuquiaari jiyanohua. Socua tiuquiquiaariuhuari na cumaneeca na masejonuhuara na seyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Coteenu nocua tiuquiquiaariiri cante cinco mil cumaneeca niquitiosaaquiaaricuajani. Nojuajaari na jiyaniijia sequeree: “Jiyaniijianaa, quiaari cua niquitiocanu cinco mil cumaneeca. Niya quiyari socua cinco mil cumaneeca quiara, cua poonijiosanojiniji cua reratesano”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Na jiyaniijiaari na sequeree: “Maniniacuaja. Quiaacuajaari maninia cua seru. Majaqui najuhuana cua tiuuniu quiquianu quiocua. Quiaacuajaqui maninia miiquianu secaja cua niquitiosanota quiajaniya. Janiyari quia jiyatenutaniya queraatia jiitianarani. Miji quia tiuquimia. Niya cuata quia quishii shuquiriaatia”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Na nuhuaji, tamonu seruuri na jiyaniijiaacua tiuquishiijiuhuaj, nooj, cante dos mil cumaneeca niquitiosaaquiaaricuajani. Na jiyaniijia sequereeri: “Jiyaniijianaa, quiaari cua niquitiocanu dos mil cumaneeca. Niya quiyari socua dos mil cumaneeca quiara, cua reratesano cua poonijiosanojiniji”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Na jiyaniijiaari na sequeree: “Maniniacuaja. Quiaacuajaari maninia cua seru. Majaqui najuhuana cua tiuuniu quiquianu quiocua. Quiaacuajaqui maninia miiquianu secaja cua niquitiosanota quiajaniya. Janiyari quia jiyatenutaniya queraatia jiitianarani. Miji quia tiuquimia. Shuquiriaatia niya quia quishii cuata”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Na nuhuaji, tamonu seruuri tiuquishiijiuhuaj cante mil cumaneeca niquitiosaaquiaaricuajani. Na jiyaniijia sequereeri: “Jiyaniijianaa, janiyari niishiyani quiaacuajaari quiarta pueyacua taraajeyashijia. Quiaari tamasaca natoosanojiniji senoojua. Quiaari tamasaca poonijiosanojiniji miajajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Naaratej, janiyari quia cumaneeca pueretacanu nohuasenuujuacani. Cunora janiyari quia cumaneeca jamocanu raamani. Quia niquiri. Niya quiyacuaja quia cumaneeca puetunujuanaa”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Na jiyaniijiaari na juaarii: “¡Quiaaqui sesoriquia pueyano! ¡Taajeca seque! ¿Quiaateeri niishiquianu janiyari tamasaca natoosanojiniji senoojuani, tamasaca poonijiosanojiniji miajajuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Quiaa jaara cua jiyaniquianu naa quijiatej, ¿casaara cua cumaneeca quia niquitioyaquiquianu cumaneeca cojuanaarini? Nojori jaara cua cumaneeca poonijiotecanu, nojori maara socua na canijiacanu quiria”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jiyacaritij, jiyaniijiaari tamasaca na seya sequeree: “Nio sesa cua serujiniji nia jaariuutiare cua mil cumaneeca. Nia niquitiore cutara cua maninia seru, cante diez mil jiitiaa tariucuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Naacuajitij, cante casaa jiitiaacuaani, nojuajaari socua niquitiosaanutaniya, queraatia jiitiaja na quiniuria. Saniniuujia, cante secaja jiitiaa najuhuanani, nojuajaari secaja na jiitiasano jaariutiasaanutaniya puetunujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nio najuhuana quijia seru saniniuujia, nia jatare carijiniacuma ninishiqui. Tii sapuenutaniyari. Na quiaca miaquenutaniyari na noonuta, naquiya na miishacari”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Puetunu cua seyajanaari jiyocuacaanuji cua cojiniutianiya janiya jaara tiuquiriohuani Pueyaso shacantuuca cumaacata, Jiyaniijiajanaa cua quiniuria mijiria. Janiyari shanohua puereeta jiyaniijia cajitiujinia cajiniutianiyani, pueya cua nequesoreesacari. ");
INSERT INTO arlNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Puetunu pueyapuejanaari cucua rerejotesaanutaniya puetunu nio jiyajinijiniojuanaa. Janiyari maninia pueya saquiriojonutaniya sesoriquia pueya tajinijini, taa borrego cojuana na borregohua saquiriojoquiaa cabraacuaca tajinijicuaani. ");
INSERT INTO arlNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Janiyari maninia pueya nujuatejonutaniya cua miaquetajarani. Saniniuujia, janiyari sesoriquia pueya nujuatejonutaniya cua muenecarani. ");
INSERT INTO arlNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na nuhuaji, janiyari cua miaquetajara nujuatiuyano sequenutaniyani: “Miji, cua Que shuquiritiasano pueyanaa. Shusha jiya shipinishacari niaarano cua Que riuriotaca nia masere. ");
INSERT INTO arlNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Cunoori niajaniyara, maninia miijiaca nia quiniuucua. Cua miaajesacari, niaari cua miaqueteja. Cua jiyamuesacari, niaari cua raateja. Tucuacaanu cua rucuanejosacari, niaari nia tiaco cua tiuquinijia. ");
INSERT INTO arlNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Toqueeju cua quishacari, niaari cua niquitioquiaari. Cusosu cua quishacari, niaari cua niquiniuucua quiaja. Nujuatejojuajinia cua quishacari taraatia, niaari cucua quiojojua cua cumanijianuucua”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Na nuhuaji, maninia pueyari cua nequesotanutaniya: “Jiyaniijianaa, ¿taacari canaa niquiquiaari quiajaniya miaajeyanoni? ¿Canaateeri quia miaquetequiaarini? Majaruhua. ¿Taacari canaa niquiquiaari quiajaniya jiyamueyanoni? ¿Canaateeri quia raatequiaarini? ");
INSERT INTO arlNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Taacari canaa niquiquiaari quiajaniya canaa jiyajinia rucuanejeyanoni? ¿Canaateeri canaa tiajinia quia tiuquiniquiaarini? Majaruhua naa canaa miiniu quiquiaari quiajaniya. ¿Naajuhuaj, taacari canaa niquiquiaari quiajaniya toqueejuni? ¿Canaateeri quia niquitioquiaari toqueni? Maja. ");
INSERT INTO arlNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Taacari canaa niquiquiaari quiajaniya cusosuni, nujuatejojuajinianio? ¿Canaateeri quiocua quiojoquiaari canaa niquiniuria quiajaniyani? Maja”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","’Janiyari cuno maninia pueya riucuanutaniyani: “Seetanujuanaa nia sequeyanijia. Niaa jaara naa maninia miiquiaari tamonu cua muerasuniyojuajinijinio, niaari maninia cua miiquiaarijiuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Na nuhuaji, janiyari cua muenecara nujuatiuyano sequenutaniyani: “¡Cua shuriucuaji niiquiji nia quiaare, sesoriquia pueyanaa! ¡Niaari cua Que sesacasano! Niaari mani quiquiojinia quejoosaanutaniya. Cuno mani quiquioori maquesaashijia. Shipinishaaquiaariiri samaruhua jiyaniijiaacuaji, na seya samaruhuacuajinio. ");
INSERT INTO arlNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Niaari naa miishaanutaniyaqui nia taraajeyaquiniuucua cucua. Cua miaajesacari, majaari nia miaquetenu quijia janiya. Cua jiyamuesacari, majaari quenaaja nia raatonu quijia janiya. ");
INSERT INTO arlNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Cua rucuanejosacari nia jiyajinia, majaari nia tiajinia nia tiuquininiu quijia janiya. Toqueeju cua quishacarijiuhuaj, majaari toque nia niquitionu quijia janiya. Nujuatejojuajinia cua quishacari, cusosu cua quishacarijiuhuaj, majaari nia quianu quijia cua niquiniuucua quenaaja”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’Jiyacaritij, cuno pueyari cua nequesotanutaniya: “Jiyaniijianaa, ¿taacari canaa niquiquiaari quiajaniya miaajeyanoni, jiyamueyanojuhuaj? Majaari canaa niquiniu quijia quiajaniya canaa jiyajinia rucuanejiyano tiaaju, toqueeju quiyano, cusosu quiyano, nujuatejojuajinia quiyanojuhuaj. Canaa jaara naa quiyano quia niquiquiaarini, canaa maara quiocua taraajequiaarini”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Janiyari nojori riucuanutaniyani: “Seetanujuanaa nia sequeyanijia, nia taraajeyaquiniuucua tamonu cua muerasuniyojuaacua, niaari seetanujuanaa cucua taraajeyaquiquiaari”. ");
INSERT INTO arlNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jiyacaritij, maninia miyashijia pueyari quejoosaanutaniya pueyaracaanu saniitiosocoriquiano. Saniniuujia maninia miijia pueyari Pueyaso shuriucua quianutaniya, pueyaracaanu shuquiriaatia nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesu jaara puetunu nio pohuatasanojuanaa pohuatanu puecaquiaari, canaa na saquiriojosano pueya sequereeri: ");
INSERT INTO arlNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Niaacuajaari niishiya, tama tariquiiri Pascua juucara queranacusacari. Janiyari jiyacari taucuaca niquitiosaanutaniyani, mosocoriquiano niyacutesanojinia teetesano. ");
INSERT INTO arlNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jiyacarijiuhuaj, canaa Judiocuaca camarucuaari rerejoquiaari Caifás tiajinia. Caifásri pueyacuara secojonaa jiyaniijiajanaa quiquiaari. Cuno pueya rerejoquiaarini, nojoriiri quiquiaari pueyacuara secojonaa camarucua, canaa Judiocuaca camarucuanio. ");
INSERT INTO arlNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nojoriiri cuno tiajinia pocoojoquiaari taa nojori sapojonutaniya Jesu na quiatusocoriquianoni, nojori mosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nojoriiri tama sequetooquiaarijiaaja: “Maja pa monu Pascuara queranacusacari, paa mariqui pueya juaatiriiri”. ");
INSERT INTO arlNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tamonu juuca, Jesuta canaa quishacari Betania tiacajinia, canaari Simón tiajinia miaquenuuriquiaani. Cuno Simónri tarijia lepra cusonujiniji Jesu naatanishano quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Miaquejajinia Jesu cajishacari, tamonu maajiiri nocua catecanoquiaari. Shiitianiyojua shucuariquiaja pataconiyojua cacatariquiaari, cohuaja saajiajiniji quejasano. Tii quiriquiaari shanohua jaanutaja. Cuno jaanutajaari jiyanohua queraatia cumaneecata masesano quiquiaari. Cuno maajiiri Jesu nacaacua na totaree puetunujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Canaa jaara niquiquiaari naa cuno maaji miishanotej, canaari juaaquioreeni. Noojiaqueya canaajinijinioori naa sequeturee: —¿Casaara cuno maaji niitiaree najuhuana shanohua jaanutajani? ");
INSERT INTO arlNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","¡Cuno jaanutaja maara queraatia cumaneecara niquitiosaare, casamiijiuniucua niquitiosocoriquiano! ");
INSERT INTO arlNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesu tojishacari taa canaa sequeriquiaa cuno maajini, canaa sequereeri: —¿Casaara nio maaji nia taroojiyani? ¡Na miishano janiyani, cunoori jiyanohua maninia quiria! ");
INSERT INTO arlNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Casamiijiuniucuaari niaata quiriquiano pueyaracaanu cutara. Janiya saniniuujia, majaari cua quiniu quiniutianiya pueyaracaanu niaata. ");
INSERT INTO arlNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nio maaji totasacari cucua na shanohua jaanutajani, juhuacarijia cua cuaqueya jeecaari, raaco cua niasaanura janiya jaara mosaareni. ");
INSERT INTO arlNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Seetanujuanaa nia sequeyanijia, pueyaracaanu pueya pohuatasacari Pueyaso rupaa janiyajiniji, nio maaji miishanoori pohuatasaanutaniyajuhua puetunu jiyacajiniajanaa. Naa na miishano janiyani, majaari na niyajetasaanu quiniutianiya pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jiyacaritij, Judasri pueyacuara secojonaa jiyaniijianucuaacua quiaquiaari. Nojuajaari niquiriyatu canaajinijinio Jesu doce saquiriojosano pueyano quiquiaari. Na sesaari quiquiaari Judas Iscariote. ");
INSERT INTO arlNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Secojonaa jiyaniijianucua sequeseeri: —¿Taa cumaneeca nia niquitionutaniya janiyani, janiya jaara nia quiatere Jesuni? Nojoriiri ritia treinta cumaneeca niquitioquiaari Judas. ");
INSERT INTO arlNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na nuhuaji, Judasri pueyaracaanu niishiriojoriquiaa maatucua taacari quiatere Jesuni. ");
INSERT INTO arlNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Puetunu marijiarajanaa, canaa Judiocuacani, canaari poreetesoo pan miaquenuuquiaari puetunu siete juucajanaani. Coteenu juucaari sesojosaaquiaari Pascua juuca. Naaratej, Pascua juuca, canaa, Jesu saquiriojosano pueyani, canaari nocua catecanoquiaarini naa canaa nequesotanura nojuaja: —Jiyaniijianaa, ¿tee quia paniya canaa majeetenura quiocuaji borregoni, pa miaquesocoriquiano quiarijia Pascuarani? ");
INSERT INTO arlNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesuuri canaa riucuaree: —Paacuajaari miaquenutaniyani tari cua sequesano pueyano tiajinia Jerusalén tiacajinia. Tii nia quiaare. Tia camaru nia sequesee: “Canaa niishitiojonaari naa quia sequeya: ‘Quera cua cusosacari. Janiyari cua nuhuajiria cua pueyata miaquenutaniya Pascua borrego quia tiajiniani’”. ");
INSERT INTO arlNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Canaari naa miiquiaarini taa Jesu sequequiaari canaacuajani. Canaari tii majeetequiaari borregoni, Pascua juuca miaquesocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jaara niniquiaari, Jesuuri canaa na doce pueyata miaquejajinia cajitiuriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Canaa miaquenuusacari, Jesuuri canaa sequeree: —Seetanujuanaa nia sequeyanijia, tamonu niajaniyajinijinioori cua tacartanutaniya, cua paraa na quiatenura janiya, nojori monura janiya. ");
INSERT INTO arlNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Canaari jiyanohua taraajequeeni naa Jesu sequesacaritij. Puetunu canaajanaari Jesu nequesotareeni: —¿Janiya jiyoteeri Jiyaniijianaa? ");
INSERT INTO arlNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesuuri canaa riucuaree: —Cante cuata tureneetaa pa miacojuajinijini, nojuacuajaari cua quiatenutaniya mosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Janiyacuajaari mosaanutaniyani taa janiyajiniji naajiotasaaquiaaricuajani tariucuacaanu Pueyaso Rupaajinia. Saniniuujia, jiyanohua taraatia miishaanutaniyari cua quiateriquiano pueyano. Maara socua maninia quiquiaari cuno pueyanora jaara raaquishaaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Na quiateriquiano Judasri socua Jesu nequesotareejuhuaj: —¿Janiya jiyoteeri Niishitiojonanaa? Judas riucuareeri: —Taaquiriirinij. Quiajaniyacuaaquiniatejaj. ");
INSERT INTO arlNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Canaa miaquesacari, Jesuuri pan ririi. Na Que Pueyaso secojoree nocuaraari. Na nuhuaji, na neecasereeri puetunu canaarajanaa, canaa miaquesocoriquiano. Canaa sequereeri: —Jajaa, nia masere. Nia miaquere. Nio panri cua cuaqueya. ");
INSERT INTO arlNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na nuhuaji, Jesuuri raatonuque pataree. Pueyaso na secojonu nuhuaji nocuara, Jesuuri canaa na niquitioree. Canaa sequereeri: —Niojiniji nia rature puetunu niajaniyajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nioori cua nanaca, Pueyaso jiyanooniuria niajaniya. Cua nanacaari queraatia pueyacuara shoonutaniya, nojori jiyanooshaanura sesa nojori miishanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Seetanujuanaa, majaari socua cua ratunu quiniutianiya niaata mijiria nio uva caacajiniji. Janiyari niaata na ratunutaniya cutarani janiya jaara tacatemohuani, pueyaracaanu Jiyaniijiajanaa cua quiniuria. Jiyacaritij, jiyanohua maninia quiniutianiyari cuno quishacari. Paari mariyata jiyanohua shuquiriaatia quiniutianiya pueyaracaanuni. ");
INSERT INTO arlNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Canaa jaara jaaquequejoquiaari supuetana David naajioneejinijini, na nuhuaji canaari quiojoquiaarini Olivo cuhuariquia tuhuananuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesuuri jiyacari canaa sequeree: —Puetunu niajaniyajanaari cucua tiuuniu tarinitianutaniya quiari niucuaja. Naa naajiotasano quiyacuajaari Pueyaso sequesano tarijia: “Janiyari borrego cojuana monutaniyani. Na borregohuari niyaquejonutaniya tamajaaja”. ");
INSERT INTO arlNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Naajaa, janiya jaara samiitiarohua macujinijini, janiyari nia puetanutaniya Galilea jiyajiniani. ");
INSERT INTO arlNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedroori Jesu sequeree: —Puetunu quia pueyajanaa jaara quiocua tiuuniu tarinitiare, janiya cutaraari maja cua catenu quiniutianiya quiocuaji. ");
INSERT INTO arlNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesuuri Pedro sequeree saaja: —Seetanujuanaa nio niucuajani, caacaraja niunijiyaquishacarijia, quiaari naa pacutejonutaniya seetanu cucuaji: “Maja cua niishiniu cuno pueyano”. ");
INSERT INTO arlNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedroori Jesu sequeree: —¡Pueya cuaara moora janiyaqui, naajaa, majaari cua seetanu quiniutianiya quiocuaji! Puetunu canaa Jesu pueyajanaari mariyata naa sequequiaaritij, taa Pedro sequeriquiaacuaani. ");
INSERT INTO arlNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na nuhuaji, Jesuuri tamonu cuhuariquiajinia tiuquiijioquiaari canaa na saquiriojosano pueyata. Cuno cuhuariquia sesaari quiquiaari Getsemaní. Jesuuri canaa sequeree: —Niyaja nia cajitiuri cua secojosacari cua Que jati socua nia tacoji. ");
INSERT INTO arlNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesuuri Pedro jiyataquiaari, caapiqui Zebedeo niquiohuanio. Jesuuri juhuacatecara taraajequiaari. Jiyanohua tacaariquiaajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jiyacaritij, Jesuuri nojori sequeree: —¡Coojia quera jiaqueya jiyanohua cua taraajenuta! ¡Quera cusoyanijia! Niyaja cua sashitiuri. Nia sutere nia tarajanura janiya quenaaja. ");
INSERT INTO arlNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesuuri nojori shuriucuaji canujiyaree tamajaaja socua nojori tacoji. Jiyocuara jacamaseeri Pueyaso na secojonura. Naa sequereeri: —¡Cua Quenaa, jaara na naata quiri, maja quenaaja cua cartenu naquiya cua miishaanura! Naajaa, janiya cuaara miishaariaqui taa quia paniyacuajani, maja juhua cua panishano. ");
INSERT INTO arlNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Na nuhuaji, Jesuuri na pueya niquishuhua. Nojoriiri saaja maqueturiquiaa. Pedro sequereeri: —Pedronaa, ¿majate nia naata cuata sutenu quenaaja rupaquijia? ");
INSERT INTO arlNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nia sutere Pueyaso nia secojonura, niaa mariqui sesa miiriiri niaa jaara saniniujiushaare. Seetanujuanaa, poojiaari maninia miiniu panijia. Pa cuaqueyari saniniuujia sasaca quiyacujua. Naacuajitij, majaari pa naata maninia miiniu Pueyaso cumaquiyaquishacari pajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesuuri socua tacatequiaariuhua tamajaaja Pueyaso secojonuhuara. Naa sequereeri: —Cua Quenaa, janiya jaara naquiya miishaareni, janiya cuaara miishaariaqui taa quia paniyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jesuuri na pueyacua tacateyarohuacuhuaj. Maquetiuyano nojori riuriatasuhuariuhuaj. Nojori namijiaari saaja seecutayariquiaa jiyanohua nojori maquenu paniniutia. ");
INSERT INTO arlNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesuuri nojori tarinitiaquiaari socua. Quiaquiaariuhuari na Que secojonuhuara. Secojonu pacutequiaariiri taa na secojoriquiaa coteenucuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na nuhuaji, na pueyacua nimiohuariuhuaj. Nojori sequesuhuari: —Quiarijia cutara nia maquetiuyare. Nia paniyatere cutara maquetunu. ¡Juaj! ¡Nia tojiri! ¡Janiyari tari quiatesaanutaniya sesa miijiaca pueyani! Nojoriiri cua miiniutianiya taa na panitiuyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Nia saneecuature! Pa quiaare. Cumaji tari cua quiateriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesu pocuasacarijia, Judasri jiyacari tiuquishii. Nio Judascuajaari niquiriyatu canaajinijinio Jesu doce saquiriojosano pueyajiniji quiquiaari. ¡Queraatia pueyari Judasta nijioquiaari! Nojoriiri secojonaa jiyaniijianucua jiyaramiquishano pueya quiquiaari, canaa Judiocuaca camarucua jiyaramiquishano pueyajuhuaj. Nojoriiri nijiniaquetucuaja mueruu pooriquiaa, macacanio. ");
INSERT INTO arlNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judasri tari niishitioquiaari Jesu quiaturiquiano pueya taa nojori niishiniutianiyani teyanote Jesuni. Nojuajaquiiri tari nojori sequequiaari: “Teyano pueyano cua nujiya pa tiuquishacarini, cunocuajaari nojuaja. Niocua na quiasee ritia”. ");
INSERT INTO arlNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Naacuajitij, Judas tiuquishacari Jesuucua, na sequeseeri: —Quiocua tiuquiyanijia Niishitiojonanaa. Jiyacarijia na nujuureeri. ");
INSERT INTO arlNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesuuri na sequeree: —Cua rupuenanaa, ¿casaacua quia niyareerini? Jiyacaritij, Judasta nijionaa pueyari Jesu quiatusee. ");
INSERT INTO arlNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jiyacaritij, tamonu canaajinijinio pueyanoori ritia shitiaree na nijiniaquetucuaja mueruu na shuucuaji. Nata jaateree secojonaa jiyaniijia seru numocoori. ");
INSERT INTO arlNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesuuri na sequeree: —¡Na co jiniacuma quia shiriohua quia mueruu! ¿Majate quia niishiniu, cante mueruuta miaqueja pueyanoni, mueruuta mosaanutaniyajaariuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Quiaate niishiyaquiyajuhuaj, janiya jaara cua Que sequereni cucua na jiyaramiquiniuria na seya jiyocuacaanuji na cojuanura janiya, cua Que maara ritia cucua jiyaramiquiri cincuenta mil na seyajinijinio? ");
INSERT INTO arlNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Naajuhuaj, janiya jaara naa cua Que sequere na cojuatenura janiyani, ¿tariucuacaanu Pueyaso Rupaajinia janiyajiniji naajiotasanotucua taa tohuateereni? ");
INSERT INTO arlNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jiyacaritij, Jesuuri na paraa sequeree: —¿Taateni? ¿Janiyateeri nohuasejojuani, naa nia tiuquitianura cua quianura mueruuta, macacatanio? Niaacuajaari juucua cua niquijia puetunu juucajanaa Pueyaso Secojojua tiajinia cajiyano, pueya cua niishitiojosacari. ¿Casaara tii nia quiaaquiquianu janiyani? ");
INSERT INTO arlNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Naajaa, naacuajitij puetunu nia miishanojuanaari tohuateenutaniya, taa tariucuacaanu Pueyaso Rupaajinia naajiotasaaquiaari janiyajinijicuajani. Jiyacaritij, canaa, na saquiriojosano pueyani, canaari Jesu tiujiaquiaari niquiriyatuni. Puetunu canaajanaari mashiyocuatureeni. ");
INSERT INTO arlNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesu quianaari na jaatucuquiaari jiyaniijia Caifáscua. Caifásri pueyacuara secojonaa jiyaniijia quiquiaari. Judiocuaca camarucuaari tari Jesuucuaji rerejoquiaari Caifás tiajinia. Nojoriiri quiquiaari Moisés Rootasanojiniji niishitiojonaa, canaa Judiocuaca camarucuanio. ");
INSERT INTO arlNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedroori Jesu nuhuajiquiaari tucuacaanuji secojonaa jiyaniijia tiajiniara. Cuno puereetuuca tia shocuaari mataca quiquiaari. Pedroori tii carijiniacuma tiuquiquiaarijiuhuaj. Jiyaniijia Caifás seya tajinia cajishiiri, na niquiniuria taa nojori miiniutianiya Jesuni. ");
INSERT INTO arlNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pueyacuara secojonaa jiyaniijianucuaari puetunu canaa Judiocuaca camarucuatajanaa pajeriquiaa pueya, nojori saquiriojotanura na sapojonuta Jesuucuara, na mosaanura. ");
INSERT INTO arlNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Queraatia pueyari najuhuana Jesuucuara saquiriojotaree juucua. Nojori sequesanoori rimiajata quiquiaari tamasaca sequesanojiniji. Na nuhuaji, socua caapiqui pueyari mariyata sesa saquiriojotaree Jesuucuara. ");
INSERT INTO arlNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nojoriiri naa sequeree: —Cuno pueyano naa sequecanutej: “Janiya jaara Pueyaso Secojojua tia niyartareni, janiyari na tianu tucuatanutaniuhua jiuujianaraca juucajiniani”. ");
INSERT INTO arlNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jesuuri sanaa nujuariquiaa saaja. Nocuaji, secojonaa jiyaniijiaari nujuaree. Jesu sequereeri: —¿Majate quenaaja quia riucuanuujua? ¿Quiaate pueya tojirii quiocuara saquiriojotaano? ¿Seetanutejanaa nojori sequesano? ");
INSERT INTO arlNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesuuri saaja sanaa na tojiriquiaa. Nocuaji secojonaa jiyaniijiaari Jesu sequeree: —¡Cua tojiri! Paa niya quiya Pueyaso niquiarani. ¡Cua riucuare! ¡Majaari sapojonu! ¿Quiaate Cristo, Pueyaso Niyanu? ");
INSERT INTO arlNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesuuri na riucuaree: —Jaa. Nojuacuajanijia taa quia sequereecuajani. Cua tojitiare. Na nuhuaji, niaari cua niquiniutianiya Pueyaso miaquetajara cajiyano. Niaari cua niquiniutianiyajuhuaj jiyocuacaanuji tacateyanohua cohuajajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pueyacuara secojonaa jiyaniijia jaara tojiquiaari naa Jesu sequesanotej, tama na toque sutareejaarijia na juaaniutia. Nata quiniaa sequereeri: —¡Juhuej! ¡Nia tojishuriucuara na sequesano! ¡Nojuajaari tama na cuaqueyajaaja jiyateya juhua Pueyaso na quiniuria! ¡Jiyanohua sacuaraatiaari na sequesano Pueyaso niquiara! ¿Paatucua casaara sashiri socua tamonu saquiriojotanura nocuaraarini? Niaacuaja shusha tojitiaree tama na sequesanojuaaja sacuaraatia Pueyaso niquiara. ");
INSERT INTO arlNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Taa pa miiniutianiyanoj? ¿Taa nia sequeyani? Nojoriiri pueyacuara secojonaa jiyaniijia riucuaree: —¡Cuaara mosaaria! ");
INSERT INTO arlNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jiyacaritij, tamasacaari Jesu jiquioco riocojoree. Na jiquioco na masetejotureejaariuhuaj. Tamasaca saniniuujia, Jesu namijia na morotunu nuhuaji, na mocoritia na piquitiuriiri. ");
INSERT INTO arlNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Na nuhuaji Jesu nequesotatureeri: —Quiaa jaara Cristo quiri, Pueyaso jiyarosano, quia niishiritioj, ¿cante quia piriini? ");
INSERT INTO arlNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedroori jiyacari tii cajiriquiaajaa carijiniacuma. Jiyacaritij, secojonaa jiyaniijia seruuri Pedro niquishii. Nojuajaari niyacoo quiquiaari. Pedro sequereeri: —¡Jaj, quiaacuaja cuno Jesuta rucuanejojua, cuno Galilea jiyajinijinio pueyanotani! ");
INSERT INTO arlNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedroori jiyacari seetaree puetunu pueya niquiarajanaa. Naa sapojoreeri: —¡Maja cua niishiniu casaa quia sequeyani! ");
INSERT INTO arlNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedroori tohuateyajiria canujiyaree. Jati, tamonu niyacoori na niquiriijiuhuaj. Cuno seruuri jiyacari tii quiniaa sequeree: —¡Nio pueyanoori cuno Jesuta quijiajuhuaj, cuno Jesu, Nazaret tiacajinijinio pueyanoni! ");
INSERT INTO arlNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedroori Jesujiniji socua seetanu camiriohuacuhuaj: —¡Maja cua niishiniu cuno pueyano! ¡Pueyasocuajaari niishiya, seetanujuanaa nia sequeyanijia! ");
INSERT INTO arlNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pasaja na tarishiniu nuhuaji, quiniqui quiniaari Pedro sequetusee: —¡Quiaaqui seetanujuanaa cuno Jesu pueyajinijinio! ¡Quiaari juhua nojori pocuaajuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jiyacaritij, Pedroori socua jiyacateree sapojonura. Naa cuno pueya sequereeri: —¡Pueyasocuajaari niishiya maja cua niishiniu cuno pueyano, niaa na sequeyani! ¡Pueyasocuajaari cua sequesano tojiya! ¡Majaari cua sapojonu niajaniya! Caacarajaari canashiyaquiji niunijioquee. ");
INSERT INTO arlNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jiyacaritij, Pedroori naa cuno niucuaja Jesu sequesano niishiquii: “Pedronaa, caacaraja niunijiyaquishacarijia, quiaari tari janiyajiniji seetanu pacutejonutaniya”. Pedroori tia shocua matacajiniji tohuataquiaari ritia. ¡Jiyanohua nujuquequeeri na taraajenuta! ");
INSERT INTO arlNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tariquiicuaji, puetunu pueyacuara secojonaa jiyaniijianucuajanaari rerejoree narta Judiocuaca camarucuata. Nojoriiri roojotooree taa na miitiuniutianiya Jesu na motenurani. ");
INSERT INTO arlNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Na nuhuaji, Jesu morotureeri na jaatucutunura jiyaniijia Pilatoocua. Pilatoori jiyaniijia Césarjanaa jiyatesano quiquiaari Judiocuaca jiyaniijia na quiniuria Judea jiyajinia. ");
INSERT INTO arlNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judasri jiyanohua macuhuajequiaari na niquishacari Jesuuri mosaanutaniya na quiatenuucua nojuaja. Na tacaaniutia, Judasri quiaquiaari secojonaa jiyaniijianucuaacua, canaa Judiocuaca camarucuaacuanio, nojori na niquitionuhuara cuno treinta cumaneeca. ");
INSERT INTO arlNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judasri nojori sequesee: —¡Janiyaqui sesa miiriucuaani, najuhuana cua quiatenuucua maninia pueyano niajaniya! Nojoriiri saa na riucuareejaa: —Naajaa. Maja canaa miishano. Cunocuajaari tama quia miishanojuaaja. ");
INSERT INTO arlNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judasri nojori cari cuno treinta cumaneeca jataree Pueyaso Secojojua tiajinia. Tiji quiacuhuari. Na riquiajiniji morotaquiaari sohuaneyocuaari. Naa cusoquiaariiri. Sohuaneyocuaacuaji jaasutaari. ");
INSERT INTO arlNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Secojonaa jiyaniijianucuaari Judas jatasano cumaneeca reratequiaari. Nojoriiri tama sequetooquiaarijiaaja: —Nio cumaneecaari maja na naata Pueyasora racatajajinia niasocoriquiano. Nio cumaneecaari pueyano monu sami. ");
INSERT INTO arlNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Puetunu nojorijianaa jaara niishiriojoquiaari taa na miitiuniutianiya cuno cumaneecani, nojoriiri marau paniyoru pueyano cuhuariquia masequiaari cuno cumaneecata. Cuno cuhuariquiaari jiyatesaaquiaari rucoonaa jamojuara, nojori jaara cusoyare Jerusalén tiacajinia nojori quishacari. ");
INSERT INTO arlNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pueyano monu samitia cuno cuhuariquia masesaanuucua, cuno cuhuariquiaari sesojosaaquiaari “Nanaca samitia masesano cuhuariquia”. Naa quiyajaari na sesa. ");
INSERT INTO arlNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Naacuajitij, Pueyaso sequenu panishano caminiujiunia supuetana Jeremías sequesanoori maninia tohuateequiaari. Nojuajaari naa sequequiaaritij: “Nojoriiri na treinta cumaneeca pataquiaari cuhuariquia masenura marau paniyoru pueyanojiniji, taa cua jiyaniijia Pueyaso sequequiaari janiyacuajani. Tarijia, cuno treinta cumaneecata, maninia pueyanoori nata masesaaquiaari. Israel pueyari naa sequequiaaritij: ‘Cuaara treinta cumaneecata masesaaria cuno pueyano’”. ");
INSERT INTO arlNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesuuri jaatucusaaquiaari jiyaniijia Pilatoocua. Pilatoori Jesu nequesotaree: —¿Quiaate Judiocuaca jiyaniijia? Jesuuri na riucuaree: —Jaa. Naacuaaquiniatejaj, taa quia sequereecuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Secojonaa jiyaniijianucua, canaa Judiocuaca camarucuanio, nojori jaara Jesuucuara saquiriojotariquiaa, Jesuuri sanaa tojiriquiaa nojori. ");
INSERT INTO arlNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Naaratej, jiyaniijia Pilatoori Jesu sequeree: —¿Majate quia tojiniu nojori, quiocuara tonujiyano queraatia? ");
INSERT INTO arlNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Majaari Jesu riucuanu quirii quenaaja. Pilatoori nocuaji jiuujiateree, casaara na riucuaaquiya quenaajani. ");
INSERT INTO arlNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Puetunu Pascua juucarajanaa, Pilatoori nujuatejojuajinia nujuatesano pueyano cartenu jiitiquiaari. Judiocuaca panishano pueyanoori cartesaaquiaari pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Cuno quishacari, tamonu pueyanoori nujuatejojuajinia nujuatesano quiriquiaa, Barrabás jiyanishano. Puetunu pueyajanaari na niishijia sesa na miiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pueya rerejosacari Jesu na nacoojotasacari Pilato niquiara, Pilatoori nojori nequesotaquiaari: —Judiocuacanaa, ¿teyano pueyano nia paniya cua cartenurani, Barrabástee, Jesu soj? Nojuajaari pueya sequesano, Pueyaso jiyarosanona. ");
INSERT INTO arlNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatoori naa nojori nequesotaree na niishishacari casaara canaa Judiocuaca camarucua monu paniriquiaa Jesuni. Puetunu pueyajanaari tari canaa camarucua tojitiaaquiriquiaa, nojori tojitianura Jesu. Cunora, camarucuaari Jesu monu paniriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato cajishacari na nequesoreesaqui, necocuaari nocua jiyaroquiaari tamonu na seru, naa na numootenuratej: “¡Narejatejataj, nareja! ¡Janiyari niucua maquiyojoree puereeta cuno pueyanoocuajini!” ");
INSERT INTO arlNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jiyacaritij, secojonaa jiyaniijianucuaari, canaa Judiocuaca camarucuata pueya niishitiojoriquiaa nojori sequenura, Barrabás cuaara cartesaaria, Jesu cuaara mosaaria saniniuujia. ");
INSERT INTO arlNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Naacuajitij, jiyaniijia Pilato jaara pueya nequesotaquiaariuhua teyano nojori paniya na cartenurani, nojoriiri na riucuaree: —¡Barrabás quia cartere! ");
INSERT INTO arlNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatoori nojori nequesotaree: —¿Naatee? ¿Taa cua miiniutianiya Jesuurinitioj, pueya sequesano “Pueyaso jiyarosanoni?” Puetunu pueyajanaari ritia na riucuaree: —¡Cuaara teetesaaria niyacutesanojinia! ");
INSERT INTO arlNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatoori nojori nequesotarohuacuhuaj: —¿Casaarateni? ¿Sesa miiriitijiaara? Pueyari saaja socua jiyanohua nacaree: —¡Cuaara mosaaria niyacutesanojinia teetesano! ");
INSERT INTO arlNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato cartenu saniniujiushacari Jesu juucua, pueyari saaja socua jiyanohua nacooriquiaa. ¡Socua jiyanohua juaaquioriquiaari! Pilato niishishacari maja na naata quiniutianiya Jesu cartenu, taa na paniriquiaa juucuacuajani, nojuajaari mohuaca maseree. Pueya niquiara shuquitiareeri. Na shuquitiasacari, Judiocuaca sequereeri: —¡Majaari cucua na tiuutiasaanu quiniutianiya nia mosacari nio maninia pueyano! Cunoori maja cua miishano quiniutianiya. ¡Cunoori tama nia miishanojuaaja! ");
INSERT INTO arlNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Puetunu pueyajanaari na riucuaree: —Naajaa. ¡Jaara mosaare, cuaara tiuutiasaaria canaacua, canaa niquiohuacuanio! ");
INSERT INTO arlNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Na nuhuaji, Pilatoori Barrabás tohuateree nujuatejojuajiniji. Saniniuujia Jesu majacutereeri. Na nuhuaji, na soldadohua na niquitioreeri niyacutesanojinia nojori teetesocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jiyaniijia Pilato soldadohuari jiyacari Jesu jaatucuree Pilato tiajiniaaco. Nojoriiri puetunu narta soldadohuajanaa rerejoteree Jesu shocuaqueya. ");
INSERT INTO arlNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na nuhuaji, nojoriiri Jesu toque jocuaturee. Tamonu tucuaque toque cushitishaareeri, shaaruque, juhua jiyaniijiajanaa cushishano. Naa na miitiuriiri na macaatiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nojoriiri juhuacontucua maaturee na nacaquerajuhuaj. Na nuhuaji, na cushititiurii Jesuuri. Naajua niquitiosaareejaariuhuaj, juhua na macara, na miaquetajata na muetunura juhua jiyaniijia. Na nuhuaji, soldadohuari Jesuucuara mojoquetacoquiaari. Nojoriiri naa na macaatirii: —¡Jejejee, Judiocuaca jiyaniijianaa! ");
INSERT INTO arlNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nojoriiri Jesu riocojoree. Na naajua na jaariutiatureeri. Nataja na naca piquitiuriiri. ");
INSERT INTO arlNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Naa nojori macaatiniu nuhuaji Jesutej, nojoriiri cuno tucuaque toque jocuaquiaariuhua nocuaji. Tama na toquejaaja cushitishaarohuari. Na nuhuaji, nojoriiri na jiyataquiaari na teetenura niyacutesanojinia. ");
INSERT INTO arlNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nojori tohuareetasacari tiacajiniji puecoosaquiria nojori quiojosacari, nojoriiri tamonu pueyano naacumaa. Nojuajaari Cirene jiyajinijinio pueyano quiquiaari. Simónri na sesa quijia. Soldadohuari cuno Simón pateree Jesu teetejara niyacutesano. ");
INSERT INTO arlNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nojoriiri tiuquiijiosee sesa miijiaca puecoosaqui. Pueya puecoosaquini, na sesa quiquiaari “Gólgota”. Nioori pueyano rupaajinia sequeya “Pueyano nacaco”. ");
INSERT INTO arlNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Quiniqui, soldadohuari Jesu raateree vino juucua, casaa piajata cojitishano. Jesu jaara na saniquiaari, majaari na ratunu quirii. ");
INSERT INTO arlNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jesu jaara niyacutesanojinia teetesaaquiaari tari, soldadohuari saitia tacuarishijioree nojori niishiniuria cante Jesu toque poonutaniya nerani. Naacuajitij, tama nojorijiaarijia Jesu toque seraatiaquiaari. Naa tohuateequiaariiri tariucuacaanu Pueyaso sequesano caminiujiunia sequesano, nojuaja jaara naa naajiotaquiaari: “Pueyari saitia tacuarishijioree cua toque nojori seraatianura”. ");
INSERT INTO arlNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na nuhuaji, cuno soldadohuari cajitiuquiaari Jesu na cojuanura. ");
INSERT INTO arlNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesu nacaacuma, naajioneeri rupotasaaquiaari. Tii naajiosano quiriquiaari casaara na teetesaareeni. Naa naajiosano quiriquiaari: “Nioori Jesu, Judiocuaca Jiyaniijia”. ");
INSERT INTO arlNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Caapiqui nohuasenuujuacaari Jesu shuriucua teetesaaquiaarijiuhuaj, socua tamonu caapiqui niyacutesanojinia; tamonu na miaquetajara, tamonu na muenecara. ");
INSERT INTO arlNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tamasaca pueya tajishacari nucuaco Jesu shuriuquioco, nojoriiri Jesu macaatiquiaari. Na maanuquenuta, nojoriiri Jesu sequetuquiaari: ");
INSERT INTO arlNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—¡Jaj! ¡Cumaacaraca quijia naatiijia! Quiaacuajaari sequeja quiaa jaara Pueyaso Secojojua tia niyartare, quia naata na tianu tucuatanuhua jiuujianaraca juucajinia. ¿Naatee? ¡Quiaa jaara naa cumaacaraca quiritij, canaa niquiara quia roserecuarajaj, quiaa jaara Pueyaso Niyanu quiri seetanujuanaa! ");
INSERT INTO arlNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Secojonaa jiyaniijianucuaari tii quiriquiaajuhua Moisés Rootasanojiniji niishitiojonaata, canaa Judiocuaca camarucuanio. Nojoriiri Jesu macaatiriquiaajuhuaj. Tama sequetooriquiaajaarijia: ");
INSERT INTO arlNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Saaja tamasaca naatanijiojuaquiiri. Maja cutaraari na naata tama nocuajijiaaja tacunu. Jaara seetanujuanaa pa Israel pueya jiyaniijia quiri, cuaara roseera quiarijia pa niquiara niyacutesanojiniji, nocua pa tiuuniuria. ");
INSERT INTO arlNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","¡Pueyasoocua tiuujia naatiijia! Jaara naa quiritij, Pueyaso cuaara na roshiniiria, nojuaja jaara seetanujuanaa Pueyaso panishano quiri. Nojuacuajaari pa sequeja: “Janiyari Pueyaso Niyanuni”. ");
INSERT INTO arlNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Cuno caapiqui nohuasenuujuaca Jesu shuriucua teetejosano quiriquiaani, nojoriiri Jesu macaatiriquiaajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","¡Panacari, mijiriaari ninishiquiria quiquii! Pananu mueecosacari cuhuatemohuari. ");
INSERT INTO arlNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jiyacaritij, Jesuuri jiyanohua nacaquiaari naatej: —¡Elí, Eliinaa! ¿lama sabactani? Nioori pueyano rupaajinia sequeya: “¡Cua Pueyasonaa, cua Pueyasonaa!, ¿casaara quia carteree janiyani?” ");
INSERT INTO arlNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tamasaca na shuriucua nujuatunaari na tojitiariquiaa. Nojoriiri sequeree: —¡Nia tojiri! ¡Supuetana Elías jiiquioonuyano! Noo Elías, tariucuacaanu pueyara Pueyaso sequesano caminiujiunia quiquiaaritij. ");
INSERT INTO arlNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tamonuuri ritia netequee namasu casaa na riniuria. Naajuaacua na morotanu nuhuaji, jereeca vinojinia na shiriiri. Na nuhuaji, Jesuucua na shiitioreeri na raatenura. ");
INSERT INTO arlNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tamasacaari sequeree: —¡Pa shanacure! ¡Elías jiyoteeri nocua niniutianiya na roshininiuria niyacutesanojiniji! ");
INSERT INTO arlNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","¡Jiyacaritij, Jesuuri jiyanohua nacarohua! ¡Na nuhuaji na sohuanu tohuataniriiri! ¡Cusoqueeri! ");
INSERT INTO arlNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pueyaso Secojojua tiajinia, shiquiaruque toquejiniji sohuacaari quiquiaari Pueyaso Quishaqui mishiquiotaja. ¡Jesu cusosacari, cuno toqueeri sutequee jiyocuacaanuji jiyocuara puetunujuanaa! ¡Rijiaari jiya jiuuquiutiaquiaari jiyanohua! ¡Sairi jiaquetacoquiaari noojiaacoji! ");
INSERT INTO arlNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","¡Macunucua raacaari riatequequiaari! ¡Queraatia tariucuacaanu Pueyasoocua tiuuniaari samiitiacoquee na raacajinia! ");
INSERT INTO arlNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesu jaara samiitiaquiaariuhua, cuno samiitiaconohua pueyari tohuareetaquiaari na raacajiniji. Nojoriiri Jerusalén tiacajinia tiuquitiaquiaari. Nojoriiri queraatia pueyacua muetaquiaari tii, Pueyaso panishano tiacajiniani. ");
INSERT INTO arlNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldadohua capitánri na pueyata Jesu cojuariquiaa, Jesu cuaara cusoyarejaatijia nojori niquiara. Nojori jaara jiya niquitiuquiaari jiuuquiutiaano, socua puetunu nojori niquishanojuanaanio, nojoriiri jiyanohua puereturee. Sequetureeri: —¡Nio pueyanoqui seetanujuanaa Pueyaso Niyanu quiquianu! ");
INSERT INTO arlNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Queraatia maajipohuari tii quiriquiaajuhuaj. Nojoriiri tucuacaanuji shootiaturiquiaa Jesu. Nojoriiri Jesu nuhuajiquiaari Galilea jiyajiniji, Jesura pueraquenuuriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Cuno maajipohua tajinia quiriquiaari María Magdalena, Santiago nucua Maríajuhuaj, José nucua Maríanio, mariyata Zebedeo niquiohua nucuanio. ");
INSERT INTO arlNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tamonu pueyanoori quiquiaari Arimatea tiacajinijinio. Jiyanohua casamiriaca quijiaari. Na sesa quiquiaari José. Nojuajaari tarijia Jesu tojijiara quiquiaari. Joseeri Jesu cusonu juucaja tiuquiquiaari cuno tenacari. ");
INSERT INTO arlNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Joseeri Pilatoocua quiaquiaari Jesu quete na masenura. Pilatoori na pueya sequeree cuaara na niquitiosaarianoj. ");
INSERT INTO arlNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joseeri Jesu quete paquiaari na jeenucuanura raaco na niasocoriquiano. Na jiuniocoreeri quenaaruque cohuajaque toquejinia. ");
INSERT INTO arlNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Na nuhuaji na niaquiaari tama na raacojaarijia. Quiarinio raa quiquiaariiri, José jiuutianishano saajiajinia. Na nuhuaji, Joseeri puereetuuca saajia saquitiniquiaari raa tiootiuria. Quiacuhuari. ");
INSERT INTO arlNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdalenaari na sesaanucuata cajitiuriquiaa raa caneja taquijiria. ");
INSERT INTO arlNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pascuara jeenucuanu juuca nuhuaji, secojonaa jiyaniijianucuaari Pilatoocua quiojoquiaari Fariseocuacata. ");
INSERT INTO arlNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Naa na sequetuseeri: —Jiyaniijianaa, canaari cuno sapojojua pueyano sequesano niishiquiini, na sequesano saminio na quishacarijia. Nojuajaari sequeja: “Janiyari jiuujianaraca juucajinia samiitianutaniuhuani”. ");
INSERT INTO arlNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nocuaji na raa quia cojuatere maninia tiosano, jiuujianaraca juuca cuaara shocorejaatijia, na pueya mariqui niucua macu nohuasequeeri. Nojori jaara na nohuasere, nojoriiri sequenutaniya Jesu samiitiarohuacuaa. Nojori jaara naa sapojore pueyatej, socua jiyacatenutaniyari Jesu sequesano, nojuaja jaara sequecanu: “Janiyari Pueyaso Jiyarosanoni”. ");
INSERT INTO arlNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatoori nojori sequeree: —Niya quiyacuaja cua soldadohua. Nojori nia cojuatere maninia cuno raa, taa nia paniyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nojoriiri soldadohua nujuatejoquiaari raa nojori cojuanura. Raa tiootiuuri rupanacusaaquiaarijiuhuaj jiyaniijia Pilato sesa naajiotajata. ");
INSERT INTO arlNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Samaatenu juuca jaara shocoquiaari, coteenu juuca semaanajinijinio juhuaquesacari, shusha cuhuatesacari, María Magdalenaari raa niquiniuucua quiariquiaa na sesaanucuata. ");
INSERT INTO arlNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","¡Canashiyaquiji, rijiaari jiyanohua jiuuquiutiaree! Cunoori quiquiaari Pueyaso seru rosenuucua jiyocuacaanuji raacua. Raa tiootiu saajia saquitinishiiri. Na nuhuaji, saajiaacua cajiriohuari. ");
INSERT INTO arlNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","¡Pueyaso seruuri niquishaaquiaari shacantuuca juhua miacana! Na toqueeri jiyanohua cohuajaque quiquiaari, juhua sohuanatuu. ");
INSERT INTO arlNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Raa cojuatunaari jiyanohua shiriiquitiuquiaari nojori niquishacari Pueyaso seru. Jiyanohua tetecatureeri. Na puerenuta socua cusojonuureeri. ");
INSERT INTO arlNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Maajipohua jaara tiuquiquiaari raajinia, Pueyaso seruuri nojori sequeree: —Maja nia shiriiquiniu. Janiyacuajaari niishiyani niaari Jesu pajeya, niyacutesanojinia mosanotej. ");
INSERT INTO arlNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Maja niya na quiniu. Tari samiitiarohuano, taa nojuaja sequequiaari niajaniyacuajani. Miji. Nia niquishushiiria na masaqui. Shaaqui. ");
INSERT INTO arlNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ritia nia quiaarohua. Na saquiriojosano pueya nia sequesuhua: “Jesu tari samiitiarohua. Nojuajaari nia puetanutaniya Galilea jiyajinia. Niaari jati na niquiniutianiya”. Janiyacuajaari tari nia sequereeni. Naa nia pohuatasuhua na pueya. ");
INSERT INTO arlNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Maajipohuari masaacujutanuuriquiohua raajiniji na puerenuta, na shuquiriniutiajuhuaj. Nojoriiri socua netecuatiuyarohuaquij, canaa na pohuatanuhuara Pueyaso seru sequesano nojori. ");
INSERT INTO arlNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","¡Jiyacaritij, Jesujuanaari canashiyaquiji nojoriicua muetaquee nuujinia! Nojori saruhuatareeri. Maajipohuari nocua catecanoree. Na cariquimiaji mojoquetacoreeri. Jesu niohuaca quiatureeri. Jesu shootiatureeri na jiuujiatenuta. ");
INSERT INTO arlNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesuuri nojori sequeree: —Maja nia puerenu. Nia quiaarohua. Cua pueya nia sequesuhua nojori cuaara quiojoora Galilea jiyajinia. Nojoriiri seetanujuanaa cua tapueyocuaca. Nojoriiri jati cua niquitiuniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Maajipohua quiojosacariuhua, noojiaqueya raa cojuanaajinijinioori tiacajinia quiojoquiaariuhua pueyacuara secojonaa jiyaniijianucua nojori pohuatanura nojori niquishano. ");
INSERT INTO arlNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pueyacuara secojonaa jiyaniijianucuaari canaa Judiocuaca camarucuata rerejoree na roojotoonura taa na miitiuniutianiyani. Na nuhuaji, nojoriiri queraatia cumaneeca niquitioquiaari raa cojuanaa, pueya niquiara nojori pohuatanura tamaatia nojori niquishanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Soldadohuari naa rootasaaquiaaritij: —Niocua naa sequere pueyatej: “Canaa maquesacari, Jesu pueyaquiiri niucua nohuasequee Jesu quete raajiniji”. Niocua naa sequeretej. ");
INSERT INTO arlNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jiyaniijia Pilato jaara niishiri naa nia pohuatasacaritij, majaari nia puerenu. Canaacuajaari na shiniajanutaniyani jaara juaari. Naacuajitij, majaari na juaaniu quiniutianiya niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jiyacaritij, soldadohuari cumaneeca maseree. Nojoriiri naa pohuatanu coteequiaari taa nojori rootasaareecuajani. Nojori cuaracashishanoori ritia caminiujiushaaquiaari canaa Judiocuacara. Naacuajitij, canaa Judiocuacaari naa sequeyajaa quiarijia. ");
INSERT INTO arlNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Canaa, Jesu once saquiriojosano pueyani, canaari Galilea jiyajinia quiojoquiaari tamonu tuhuananuucuani. Jesuuri canaa sequequiaari canaa quiojonura tiriara, tii canaa coquetoonura nata. ");
INSERT INTO arlNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Canaa niquishacari Jesu quiyano tii, canaari nocuara mojoquetacoquiaari canaa shuquiritianura nojuajani. Tamasaca canaajinijinioori jiyaniriquiaa maja naasucuaari Jesu. ");
INSERT INTO arlNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesuuri canaacua catecanoree. Canaa sequereeri: —Janiyari puetunu cumaacajanaa niquitiosaareeni, Jiyaniijiajanaa cua quiniuria jiyocuacaanu, mijirianio. ");
INSERT INTO arlNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","¡Naaratej, nia quiojore! ¡Puetunu pueyapuejanaa nia pohuatare cua rupaa, cua tojitiajacara nojori quiniuria! Moojinia nia tiuquinijiore cua tojitiajaca Pueyaso sesajinia, nojori rupuesacari pa Que Pueyaso, janiya, na Sohuanunio. ");
INSERT INTO arlNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nojori nia niishitiojore puetunu cua rootasanojuanaa niajaniya, nojori tojishocoriquiano. Nia niishiri nio: ¡janiyacuajaari niaata quiniutianiya pueyaracaanuni, jiya cuaara puequerejaatijia!");
INSERT INTO arlNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Pueyaso Niyanu Jesucristojinijiiri naa coteetasaaquiaari pohuatanutej. ");
INSERT INTO arlNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tariucuacaanu pueyara Pueyaso sequesano caminiujiunia Isaíasri Pueyaso Niyanu niyacari naajiotaquiaari. Naajiotaquiaariiri taa Tiuquinijiona Juan poojotanutaniya pueya jeenucuanura nojori jiuujiani, niriquiano Jesu tojijia nojori quiniuria. Isaíasri naa naajiotaquiaari Pueyaso sequesano miriqui Neyanutej: “Janiyari quiocuaji jiyaronutaniya tamonuni, quiocuaji quia nuu jeenucuariquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Na nacanuuri tojishaanutaniya cariiquia jiyajinia. Naa pueya sequeyari: ‘¡Nia jeenucuare Jiyaniijia nuu! ¡Nia nuunore maninia, maja shuutiuniu!’” ");
INSERT INTO arlNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Quiari naataja, Tiuquinijiona Juanri seetanujuanaa naa miiquiaari cariiquia jiyajiniatej. Nocua nijionaa pueya tiuquinijioriquiaa moojiniaari. Tiuquinijiona Juanri cuno pueya sequequiaari: —¡Nioojia nia tacatore sesa nia miiniujiniji, moojinia cua tiuquinijionura niajaniya! ¡Pueyasocua sesa nia miishanojiniji nia jiyanoori puetunujuanaa! ");
INSERT INTO arlNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Puetunu Judea jiyajinijinio pueyajanaari nocua nijioquiaari nojori tojitianura nojuaja, Jerusalén tiacajinijinio pueyanio. Cuno pueya jaara sesa na miishano pohuataquiaari Juan niquiara, Pueyaso niquiarajuhuaj, Juanri nojori tiuquinijioquiaari Jordán moojinia. ");
INSERT INTO arlNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tiuquinijiona Juan toqueeri camello cajacajiniji shitiasano quiquiaari. Na cajiniocua na camarucutesanoori quiquiaari shoque sacuanijiasano. Na miaquesanoori quiquiaari sequeru, samiyatunio, cariiquia jiyajinia na riuriatasano. ");
INSERT INTO arlNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juanri pueya niquiara pohuataquiaari naatej: —Tamonuuri cua nuhuaji niniutianiya. Nojuajaari socua cumaacaraca janiyajiniji. Janiya maara shuquiriaatia quirini, nojuaja jaara quenaaja cua sequere cua naacutanura nojuaja, juhua na seru, na sapatu neyocua cua samaacatanura. Nojuajaari Jiyaniijiajanaa cutara janiyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Janiyari nia tiuquinijiya moojiniani, juhua jeequejosano nia quiniuria sesa nia miishanojiniji. Cua nuhuaji ninia cutaraari Pueyaso Sohuanu tiuquinijionutaniya nioojiajinia, na cumaaca nia jiitianura, seetanujuanaa maninia miijiaca nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jesuuri jiyacari Nazaret tiacajiniji quiaquiaari Tiuquinijiona Juancua. Nazaret tiacaari Galilea jiyajinia quijia. Tiuquinijiona Juanri Jesu tiuquiniquiaari Jordán moojinia. ");
INSERT INTO arlNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesu tacasacari moojiniji na tiuquinishaanu nuhuaji, jiyacaritij, nojuajaari jiya cajiniocua niquiquiaari riateyano. Pueyaso Sohuanu niquiriiri nocua roseyano juhua mococoonu. Nocua tiuushiiri. ");
INSERT INTO arlNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jiyacaritij, jiyocuacaanuji tojishaaquiaariiri Pueyaso pocuaano. Naa Jesu sequequiaariiri: —¡Quiaari Quiyanuniyojua, cua panishano! ¡Jiyanohua quia timitiaanijia! ");
INSERT INTO arlNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na nuhuaji, Pueyaso Sohuanuuri Jesu jiyatequiaari ritia cariiquia jiyajiniara. ");
INSERT INTO arlNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesuuri cuarenta juuca shocojotequiaari tii tamajaaja, puereeta jiya camaruhua casami quishaqui. Tii na quishacari, Satanásri Jesu saniniujiuriquiaa na tojijiara Jesu quiniuria juucua. Na nuhuaji, Pueyaso seyari nocua nijioquiaari na naacunura, na mianuutenurajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jiyaniijia Herodes jaara Tiuquinijiona Juan nujuatequiaari nujuatejojuajinia, na nuhuaji, Jesuuri Galilea jiyajinia quiaquiaariuhua. Nojuajaari pueya niquiara poojotaquiaari tii, maninia pohuatasano Pueyasojiniji, taa Pueyaso jiitianutaniya na muerasuni. ");
INSERT INTO arlNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesuuri naa sequequiaari pueyatej: —Nia sequeyanijia, nio pa quishacarini, quiarijiaari Pueyaso jiyanooshacari pueya, na muerasura nia quiniuria. Cunora, Pueyasojiniji cua pohuatasanoocua nia tiuuri. Nioojia nia tacatore sesa nia miiniujiniji, Pueyaso tojitiajaca nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galilea caminia shuriuquioco Jesu rucuanejosacari, nojuajaari Pedro niquiquiaari, tarajanu Andrésnio. Nojoriiri shiyaru jaquerootanaa quiquiaari. Jiyacaritij, nojoriiri shiyaru jaquerootariquiaa caminiajinia. ");
INSERT INTO arlNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesuuri nojori sequesee: —¡Miji, cua nuhuajitiuyare! Janiyari nia jiyatenutaniya pueya quioojuara saniniunijia, juhua sapitiaaja. ");
INSERT INTO arlNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nojoriiri ritia na shiyaru tiujiaquiaari. Jesuta quiojiyareeri. ");
INSERT INTO arlNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Socua shiitianiyojua na tacoji Jesu canujusacari, Santiago niquishiiri, tarajanu Juannio. Nojoriiri na shiyaru cushipirijionuuriquiaa botejinia. Nojoriiri Zebedeo niquiohua quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesuuri jiyacari nojori sequequiaari nata nojori quianurajuhuaj. Nojoriiri na que Zebedeo tiujiaquiaari botejinia na naacunaata. Nojoriiri Jesuta quiojoquee. ");
INSERT INTO arlNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nojoriiri Capernaum tiacajinia tiuquishii. Samaatenu juuca, Jesuuri tiuquiquiaari Pueyaso secojojua tiajinia. Tii pueya niishitiojonu coteequiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pueyari jiyanohua jiuujiatequiaari na rootasano nojori tojishacari. Jesuuri juhua jiyaniijiajanaa niishitiojoriquiaa. Majaari na niishitiojonu quiquiaari taa Moisés Rootasanojiniji niishitiojonaa niishitiojoquiaaricuaani. Nojoriiri saaja Moisés pohuatasanojiniji caminiujiuquiaari, pueya niquiara nojori pohuatasacari Pueyaso Rupaa. ");
INSERT INTO arlNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Samaruraca pueyanoori Pueyaso secojojua tiajinia quiriquiaa tiijiuhuaj. Nojuajaari nacaquiaari: ");
INSERT INTO arlNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Nazaret tiacajinijinio Jesunaa!, ¿quiaateeri tari canaacua nimiaa, canaa quia shaajanura? Janiyari quia niishiyani. ¡Quiaacuajaari Pueyaso Niyanu! ");
INSERT INTO arlNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesuuri cuno samaru juaarii. Na sequereeri: —¡Quia sanaajere! ¡Quia tohuatare nio pueyanojiniji! ");
INSERT INTO arlNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jiyacaritij, samaruuri jiyanohua taraatia miirii cuno pueyano. Jiyanohua na sariyotequiaariiri na tohuatasacari nojuajiniji. Juhua macu tiujiaquee pueyanoori. ");
INSERT INTO arlNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Puetunu pueyajanaari shiriiquitiuquiaari. Tama nojorijiaarijia nequesoreetooquiaari: —¿Casaatucuaa nioni? ¡Nioruhua quiarinio niishitiojosano! ¡Nio pueyanoqui cumaacaraca! ¡Taa samaruhua tojitiaa nojori na jiyarosacariiri! ");
INSERT INTO arlNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pueyari ritia caminiujiuquiaari Jesujiniji puetunu Galilea jiyajiniajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jaara tohuareetaquiaariuhua Pueyaso secojojua tiajiniji, Jesuuri Simón, Andrés tiajiniara quiaquiaari Santiagota, Juantanio. ");
INSERT INTO arlNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simón reyarucuaari naseeca matariquiaa maquetujinia. Cusosutuhuaj. Tiajinia quiniaari Jesu sequeturee nojuaja cusosu mataa. ");
INSERT INTO arlNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesuuri nocua canujiyaree. Na juaashiquiajiniji cusosu sanaseeri. Na cusonuuri seetanujuanaa ritia tajiquiaari nocuaji. Naacuajitij, nojuajaari pueya mianuutenu coteequiaari ritia. ");
INSERT INTO arlNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Shusha ninishacari, Jesuucua patootasaaquiaariiri puetunu cusosuhuajanaa, samaruhuaraca cusosu pueyanio. ");
INSERT INTO arlNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Puetunu cuno tiacajiniji pueyajanaari tia tohuateyaji rerequeequiaari tee Jesu quiriquiaacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesuuri queraatia puetunu tamaatia cusonujuanaa naatanijioquiaari na rupaa cumaacata. Queraatia samaruhua tohuatanijioquiaari tamasaca pueyajinijijiaariuhuaj. Samaruhuari niishiquiaari cante Jesuni. Nocuaji, majaari Jesu shanacunu quiquiaari samaruhua pocuanura quenaaja. ");
INSERT INTO arlNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jesuuri jiyanohua tariquiicuaji sanequiaari, ninishiqui quishacarijia. Tiacajiniji quiaquiaari tamaquiriaari, tii Pueyaso na secojonura tamajaaja. ");
INSERT INTO arlNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na nuhuaji, Simónri Jesu pajenuucua quiojoquiaari, nata quiniaata. ");
INSERT INTO arlNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jaara na riuriatatuquiaari, na sequetuseeri: —¡Puetunu pueyajanaa quia juuretaa! ");
INSERT INTO arlNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesuuri saaja nojori sequeree: —Pa quiaare juhuari catecanaataja tiacajinia. Tii pa pohuatarejuhua Pueyaso rupaa pueya niquiara. Janiyacuajaari cunora jiyasohuaja tohuataareeni. ");
INSERT INTO arlNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Naacuajitij, Jesuuri puetunu Galilea jiyajiniajanaa rucuanejoquiaari. Pueyaso rupaa pohuataquiaariiri Pueyaso secojojua tiacajiniaqueya puetunu Galilea jiya tiacajiniajanaa. Nojuajaari samaruhua tohuatanijioquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lepraraca cusosu pueyanoori Jesuucua catecanoquiaari. Jesu cariquimiaji mojoquetaseeri. Na sequereeri: —Quiaa jaara paniri, quia naata cua naataniniu cua cusonujiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesuuri nocua taraajequiaari. Na juaashiquia niaree nocuaari. Na sequereeri: —Taaquiriirinij. Quia naataniniu paniyanijia. Quia cuaqueya cuaara jeequehuara. ");
INSERT INTO arlNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jesu jaara naa na sequequiaaritij, na lepraari ritia cushiriiquii. Na cuaqueyajiniji shaajequiaariiri na cusonu. Na cuaqueyari maniniara quiquiaariuhua. ");
INSERT INTO arlNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Na jiyaroyaquishacarijia na naatanishano pueyano, Jesuuri jiyanohua na rootaquiaari. Na sequereeri: ");
INSERT INTO arlNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—¡Cua tojiri, majaari pueya quia pohuatanu cua miishano! Saaja pueyacuara secojonaa jiyaniijia quia cuaqueya quia niquitishii, na cartenuhuara quiajaniya, pueya tajinia quia rucuanejonuhuara juhuajaniya. Mariyata ritia quia niquitiore quia seru Pueyasoocuara catijiasocoriquiano. Naa quia miiri taa Moisés niishitiojoquiaaricuajani, puetunu pueyajanaa niishiniuria quiaa tari naatarohua quia cusonujiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Cuno pueyano jaara quiaquiaari, juhuacatecara pohuataquiaari puetunu pueyajanaari taa na naatanishaarohuani. Naaratej, puetunu pueyajanaari Jesu niquiniu panijia. Cunora, Jesuuri maja tari na naata tiuquiniu quiquiaari juhuajaniya tamonu tiacajinia. Nocuaji Jesuuri pueya quiyaquishaqui rucuanejojua. Naajaa, puetunu cuno jiyajiniji pueyajanaari saaja nocua nijioquiaari na niquiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Na rucuanejonu nuhuaji, Jesuuri Capernaum tiacajinia tiuquiquiaariuhua na saquiriojosano pueyata. Pueya jaara niishiquiaari Jesu tari na quijia tiajinia tiuquiriohua, ");
INSERT INTO arlNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","queraatia pueyari nocua nijioquiaari cuno tiajiniara. Nojoriiri tiaco mishiquiaari, tohuateyajijiuhuaj. Jesuuri cuno pueya niquiara pohuataquiaari Pueyaso rupaa. ");
INSERT INTO arlNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jesu quishacari tii, nocua patasaaquiaariiri pueyano cusosu na matujinia. Cuatro pueyari na patamaa. Cuno cusosuuri pootia mataja quiquiaari pueyaracaanu, cumatacuruhuana na quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cusosu patanaari maja na naata tiaco tiuquitianu quiquiaari Jesuucua, puera pueya rerequeesacari tohuateyaji. Nocuaji nojoriiri tia cacojiria cusosu tacataquiaari tacatuhuoco. Nojoriiri tia nijinia cuhuataquiaari. Namitia Jesu nujuasaquijianaa cuhuataturee tiaari. Na nuhuaji, tia cuhuocojiniji, Jesuucua roshinitiasaareeri cusosu na matujinia. ");
INSERT INTO arlNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesuuri cusosu patanaa pueya niquirii seetanujuanaa nocua tiuyano. Naaratej, Jesuuri cusosu sequeree: —Quiyanunaa, sesa quia miishanojiniji quia jiyanoorii taricuajanijia. ");
INSERT INTO arlNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Moisés Rootasanojiniji niishitiojonaari tii cajitiuriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Nojori tojishacari Jesu jiyanoyano cuno pueyano, nojoriiri niishiriojonuuree: “¿Casaara nio pueyano pocuaa naani? Majaari quenaaja pueyano naata pa jiyanooniu sesa pa miishanojiniji. ¡Nojuajaari tama na cuaqueyajaaja jiyateya juhua Pueyaso na quiniuria! ¡Cunoori jiyanohua sacuaraatia! ¡Saaja Pueyaso cutaraari na naata pa jiyanooniu!” ");
INSERT INTO arlNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuuri tamajaaja ritia niishiquiaari noojiajinia naa cuno pueya niishiriojonuusano. Jesuuri cunora nojori sequeree: —¿Casaara naa nia niishiriojiyani? ");
INSERT INTO arlNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Casaate jiyajenetashiya sequenurani: “Sesa quia miishano tari jiyanooshaaree”? ¿Mariyata jiyajenetateeri sequenurajuhuaj: “Quia sanere. Quia matu quia pataarohua”? ");
INSERT INTO arlNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Seetanujuanaa nia sequeyanijia, janiyari quiarijia nia niishitiniutianiyani, pueyano cua quishacari mijiria, naajaa, janiyari Pueyaso cumaaca jiitiaa sesa miijiaca cua jiyanooniuriani. Jiyacaritij, Jesuuri cumatacuruhuana cusosu sequeree: ");
INSERT INTO arlNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Cua tojiri. ¡Quia sanere! Quia matu quia patare. Quia tiajinia quia quiaarohua. ");
INSERT INTO arlNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cusosuuri ritia sanequee. Pueya niquiara na matu pataarohuari. Naaratej, pueyari jiuujiatequiaari. Pueyaso maniniuhuaqueetatureeri. Cuno pueyari naa sequetuquiaaritij, na shuquiritiasacari Pueyaso: —¡Majaari quenaaja pa niquiniu quiquiaari naa miishanotej! ");
INSERT INTO arlNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na nuhuaji, Jesuuri na saquiriojosano pueyata tacatequiaariuhua caminia casaqueyajiria. Queraatia pueyari nocua nijioquiaari. Jesuuri cuniqui nojori niishitiojoquiaari Pueyaso rupaa. ");
INSERT INTO arlNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na nuhuaji, Jesu quiojosacari na saquiriojosano pueyata cuniquiji, Jesuuri Leví niquimiaa cajiyano Roma tiacajinia quijia jiyaniijiara cumaneeca masejojuajinia. Nojuajaari Alfeo niyanu quiquiaari. Jesuuri na sequeree: —Miji. Cua nuhuajiyare. Jiyacaritij, Leviiri sanequiaari. Jesu pueyanora quiaquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Cuno niucuaja, Jesuuri Leví tiajinia miaqueriquiaa. Leví tiajinia miaquenuuriquiaajaariuhua queraatia narta cumaneeca masejonaa. Queraatia tamasaca pueyari nojoritia miaquenuuriquiaajuhuaj, canapue Judiocuaca camarucua sequequiaari sesa pueyatacuajani. Nojoriiri Jesuta miaquenuuriquiaa, Jesu saquiriojosano pueyatanio. Jiyanohua queraatia pueyari Jesu rupuenaa quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Moisés Naajioneejiniji niishitiojonaa, mariyata Fariseocuaca jaara Jesu niquirii cuno pueyata miaqueyano, nojoriiri Jesu saquiriojosano pueya nequesotaquiaari: —¿Casaara nia niishitiojona miaqueya cuno cumaneeca masejonaatani, mariyata cuno sesa miijiacatani? ¿Casaara cuno pojoritia na ratuyajaaniuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesuuri cuno pueya sequesano tojirii. Nojori sequeree miriquiiri: —Jiyotuucaari maja na paniniu naarajona. Cante cusosuni, cuno cutaraari naarajona paniya. Majaari cua niniu quiquiaari maninia miijiacaacua. Niquiaari cutaranijia nia sequesano sesa miijiaca cua jiyanooniuria sesa nojori miijiosanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tamacari, Tiuquinijiona Juan tojitiajaca, mariyata Fariseocuaca miaqueyaquishacari, tamasaca pueyari Jesuucua nijioquiaari. Na sequetuseeri: —¿Casaara quia saquiriojosano pueya carteyaquiya miaquenu quenaajani? Tiuquinijiona Juan pueya cutaraari miaajecoquiaa Pueyaso nojori shuquiritiniuria. Fariseocuacaari naa miiquiaajuhuaj. ¿Casaara naa quia pueya miyaquiyajaaniuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesuuri nojori riucuaree miriqui: —¿Masuusano pueyateeri miaajenutaniya nojori jaara queranacusaqui quiya, pueyano camishacari maaji? Camiriquiano pueyano jaara nojoritia quiyajaa, maja na naata nojori miaajenu, shuquiriaatia nojori quishacari. ");
INSERT INTO arlNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tamacari cutara, cuno camiriquiano pueyanoori nojori tajiniji rishaanutaniya. Cua pueyari jiyacari miaqueyaquiniutianiya cutara. ");
INSERT INTO arlNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Seetanujuanaa nia sequeya cutaranijia, toque mocua cuhuocoori maja na naata cushipirijiosaanu quiariqui toquerauta. Jaara jeequesaare, quiarinio toquerauri posequeja. Naacuajitij, toque mocua cuhuocoori socua queraaquetaaree. ");
INSERT INTO arlNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Naajuhuaj, quiariniacu uva caacaari maja na naata racatasaanu shoque tariucuacojinia. Quiariniacu uva caaca jaara jerema, shoque tariucuaco pojuaretaari. Naacuajitij, paari najuhuana niitiaa uva caacani, shoquenio. Cunora, maninia cutaraari quiariniacu uva caaca shuujionu shoque quiariquiojinia, maja vino niitiasaanura najuhuanaj, shoquenio. Jesuuri naa pohuataquiaaritij, pueya na niishitiojonura quiarinio na niishitiojosanoori maja na naata cojitishaanu tariucuacaanu niishitiojosanota. ");
INSERT INTO arlNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jesuuri samaatenu juuca quiojoquiaari cuhuariquiajiniaaco na saquiriojosano pueyata. Na pueyari jiyacari trigo carojotanu coteequiaari na miaajenuta. ");
INSERT INTO arlNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseocuaca jaara na niquiquiaari, Jesu sequetureeri: —¡Quia niquiri! ¿Casaara quia saquiriojosano pueya poonijiya samaatenu juucani? ¡Pueyaso Rupaajinia, paari piriyojoshiyacuajani maja samaatenu juuca pa poonijionura! ");
INSERT INTO arlNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesuuri nojori sequeree: —¿Majateeri nia serojonu quiquiaari Pueyaso Rupaajinia pa supuetanaa jiyaniijia David miishanojiniji, nojuaja jaara miaajequiaari na cojiniaata, nojori jiitiaaquishacari na coseyaca? ");
INSERT INTO arlNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Cuno quishacari, supuetana Abiatar pueyacuara secojonaa jiyaniijia quiquiaari. Davidri tiuquiquiaari Pueyaso Secojojua tiajinia. Nojuajaari Pueyasora niquitiosano panjiniji saquiaari. Cuno panri saaja Pueyaso Secojojua tia cojuanaa sasocoriquiano quiquiaari. Naajaa, Davidri na saquiaari. Na neecasequiaarijiaariuhua nata quiniaa pueyara. ");
INSERT INTO arlNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesuuri nojori sequequiaarijiuhuaj: —Pueyasoori samaatenu juuca shipiniquiaari pueyara. Maja cutaraari Pueyaso shipininiu quiquiaari pueya, samaatenu juucara. ");
INSERT INTO arlNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Naaratej, pueyano cua quishacari mijiria, janiyari cumaacaraca cua Quejinijini cua sequenura casaa pa miiniutianiya samaatenu juucani. Janiyacuajaari samaatenu juuca camarnuni. ");
INSERT INTO arlNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesuuri Pueyaso secojojua tiajinia tiuquiquiaariuhua na saquiriojosano pueyata. Tii quiriquiaari pueyano, cuseetucojuara joojequetano juaashiquiaraca. ");
INSERT INTO arlNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Cuniqui quiniaa Fariseocuacaari shanacutariquiaa na niquiniuria taa Jesu miiniutianiyanoj. Nojoriiri tama sequetooreejaaja: —¿Jesuteeri sesarucojua pueyano juaashiquia jeecanutaniya samaatenu juucani? Nojoriiri Jesuucuara saquiriojotanu paniriquiaa, nojuaja jaara samaatenu juuca poonijiore. ");
INSERT INTO arlNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesuuri jiyacari sesarucojua pueyano sequeree: —Quia sanere. Niya quia nujuasee canaa tajinia pueya niquiara. ");
INSERT INTO arlNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Na nuhuaji, Jesuuri pueya nequesotaree: —¿Casaate samaatenu juuca miishiyani? ¿Paate maninia miyani, paate sesa miya soj? ¿Pueyanote naatanishiya, moshiyajanaa soj? Nojoriiri sanaa niquitiariquiaa saaja, Jesu sequesacari naatej. ");
INSERT INTO arlNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesuuri na shocuaqueya nujuatiuyano pueya niquinijioree na juaaniutia. Nojoriicua taraajeriquiaajaariuhuaj, cumajiuujiaaca nojori quiniuucua. Majaari nojori niishiniu paniniu quiquiaari taa Pueyaso paniya pueyacua taraajeja pa quiniuriani. Jesuuri sesarucojua pueyano sequeree: —¡Quia juaashiquia quia shiitiore! Na juaashiquia shiitioreeri. ¡Jiyacaritij, na juaashiquiaari ritia jeequequee! ");
INSERT INTO arlNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseocuaca niquishacari naa Jesu miishanotej, nojoriiri tohuareetaquee na juaaniutia. Nojoriiri Herodes panijiaca pueyata pocoojoquiaari ritia, taa nojori monutaniya Jesuni. ");
INSERT INTO arlNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Na nuhuaji, Jesuuri quiojoquiaari caminiajinia na saquiriojosano pueyata. Queraatia pueyari na nuhuajiquiaarijiuhua Galilea jiyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Pueya niishishacari puetunu Jesu maninia miishanojinijijianaa na cumaacata, queraatia pueyari nocua nijioquiaari na niquiniuria. Nojoriiri nocua nijioquiaari puetunu jiyacajinijiniojuanaa: Judea jiyajinijinio pueya, Jerusalén tiacajinijinio pueyajuhuaj, Idumea jiyajinijinio pueyanio. Nijioquiaarijiaariuhua Jordán moo taquijiriajiniji pananu muetasamaji pueya, Tiro tiacajinijinio pueyanio. Sidón tiacajinijinio pueyari nijioquiaarijiuhuaj na niquiniuria Jesu. ");
INSERT INTO arlNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nocuaji Jesuuri na saquiriojosano pueya sequequiaari: —Niocua juhuacarijia bote cojuare quiria, cua tacajara pueyacuaji, maja pueya tanuujunura janiya. ");
INSERT INTO arlNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesuuri jiyacari jiyanohua queraatia pueya naatanijioriquiaa. Nocuaji cusosuhuari Jesuucua riutioconeetariquiaa na quianura Jesu, nojori cusonujiniji nojori naataconuhuara. ");
INSERT INTO arlNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Samaruhuaraca pueya jaara Jesu niquitiuquiaari, nojoriiri nocuara mojoquetacoquiaari. Naa nacatuquiaariiri: —¡Quiaacuajaari Pueyaso Niyanu! ");
INSERT INTO arlNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nocuaji Jesuuri nojori sequequiaari na juaaniutia, maja nojori sequenura pueya niquiara cante nojuajani. ");
INSERT INTO arlNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Na nuhuaji, Jesuuri tacaquiaari tuhuananuucua. Nojuajaari tiji sequequiaari cana na paniquiaaricuajani. Nocua nijioquiaariiri na jiyaniquishano pueya. ");
INSERT INTO arlNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesuuri doce pueya saquiriojoquiaari nata nojori quiniuria. Nojori jiyatereeri na jiyaramiquishocoriquiano, Pueyaso rupaa nojori pohuatanura. ");
INSERT INTO arlNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nojori niquitioree na cumaacaari, cusosuhua nojori naatanijionura, samaruhua nojori tohuatejonurajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nioori na saquiriojosano doce pueya sesaca: Simón, Jesuuri na sesojoquiaari Pedro; Santiago, tarajanu Juannio. ");
INSERT INTO arlNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jesuuri nojori sesojoquiaari “Boanerges”. Naa sequenu paniyari nio, “Ritia juaajia, juhua miacana”. Nojoriiri Zebedeo niquiohua quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Socua quiquiaariiri Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiagonio. Nojuajaari Alfeo niyanu quiquiaari. Socua quiquiaari Tadeo, Simónnio. Nojuajaari Romano pueya jatanu panijiaca pueya maanujinijinio quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Quiquiaarijiaariuhua Judas Iscariote, Jesu quiatequiaari mosocoriquianoni. ");
INSERT INTO arlNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na nuhuaji, Jesuuri na saquiriojosano pueyata tamonu tiajinia tiuquitiaquiaari tamonu tiacajinia. Queraatia pueyari tiuquitiaquiaarijiuhua cuno tiajinia Jesuucua. Naacuajitij, majaari nojori naata miaquenu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesu tapueyocuaca jaara niishiquiaari naa nocuajitij, nojoriiri nocua nijioquiaari na riniuucua juucua. Tama sequetooriquiaajaarijia: —¡Jesuqui tari paatecara quiriijuhuanajaj! ");
INSERT INTO arlNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moisés Rootasanojiniji niishitiojonaa Jerusalén tiacajiniji nijiono pueyari saniniuujia naa sequetuquiaari Jesujiniji: —Samaruhua jiyaniijia Satanáscuajaari cumaaca niquitiorucuaa cuno pueyano. Cunora, samaruhua tohuatanijiya pueyajinijiiri. ");
INSERT INTO arlNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Naaratej, Jesuuri cuno pojori sequequiaari nojori na niishiriojotenura: —Miji, niya cua tojitiasee. ¿Pueyanoteeri na naata Satanás tohuatenu pueyanojiniji tama Satanás cumaacatajaaja? Maja na naata. ");
INSERT INTO arlNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Naajuhuaj, mijiria jiya jiyaniijia jaara juayonuutaa tama na pueyatajaaja, nojuajaari maja na naata nujuatanu na paraa, jaara nocua nijioma. Nojuajaari shocotasaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Naajaariuhuaj, pueyano jaara tapueyocuacata juayonuutare, majaari nojori naata jatiqui quiniu nojori tiajinia. ");
INSERT INTO arlNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Niaari saniniuujia cua sequeree, janiyana Satanás cumaacata tohuatanijioquiaa samaruhuani. Satanás jaara naa miiritij, cuno maara tari quiri na shaajasaanurajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Naajuhuaj, pueyano maja na naata tiuquiniu cumueeca pueyano casamiriaca tiajinia, na casami na jaariuutianura, jaara coteenu na camaru morojiyaquiri. Pueyano jaara coteenu na camaru morojorejaatijia, naa cutara na naata na casami jaariuutianu. ");
INSERT INTO arlNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Seetanujuanaa nia sequeya cutaranijia, pueyano sesa miishanoori na naata jiyanooshaanu. Janiyajiniji sesa na pocuasanoori jiyanooshiyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Saniniuujia, cante sesa rimiaaqueja Pueyaso Sohuanuucuarani, cuno cutaraari maja na jiyanooshaanu quiniutianiya quenaaja. Jiyano pueyanotej, nojuajaari pueyaracaanu saniitiosaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesuuri naa nojori sequequiaaritij, pueya sequesacari, nojuajana samaruraca quijia, Pueyaso Sohuanu cumaacata na tohuatejosacari samaruhua. ");
INSERT INTO arlNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jiyacaritij, Jesu nucuaari tiuquiijioquiaari, Jesu tapueyocuacanio. Majaari tiajiniaaco na tiuquitianu quiquiaari Jesuucua. Saaja carijiniacumaji tamonu pueyano sequetureeri na numootenura Jesu nojoriicuara. ");
INSERT INTO arlNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesu shocuaqueya cajitiuniaari Jesu sequeturee: —Quia nucuana quia tapueyocuacata jati carijiniacuma nujuatiuya. Quia pajenuyaquinia. ");
INSERT INTO arlNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesuuri saaja nojori sequeree: —¿Cante cua nucuani, cua tapueyocuacajuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Na nuhuaji, na shocuaqueya cajitiuniaa niquinijioreeri. Sequereeri: —Nio pueyari cua nucua, cua tapueyocuacanio. ");
INSERT INTO arlNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Cante cua Que panishano miijiani, nojuaja cutaraari cua tarajanu, cua rimiatu, cua nucuanio. ");
INSERT INTO arlNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesuuri socua Pueyaso rupaa niishitiojonu coteequiaariuhua caminia casaqueyaji. Jiyanohua queraatia pueyari rerequeejoquiaari nojori tojitianura nojuaja. Boteeri tii cuatariquiaa caminiajinia. Naacuajitij, Jesuuri botejinia tacaquiaari. Tii cajishiiri, caminia casaqueyaji rerequeejono pueya na niishitiojonura tiji. ");
INSERT INTO arlNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Cuno pueya niishitiojoreeri queraatia miriqui pohuatasanota. Na niishitiojosacari pueya, Jesuuri naa sequequiaaritij: ");
INSERT INTO arlNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Nia tojitiare nio sequesano. Tamonu juuca, pueyano na cuhuariquiajinia natoojonuucua quiaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na jacutasacari, nucuaco totequiaariiri tajaaca. Shuhuari na miojoree. Majaari na moritianu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tajaacaari totequiaari sai tajiniaqueyajuhuaj. Majaari cuniqui puera jiya quiniu quiquiaari na maashiniuria. Naacuajitij, najuhuana ritia moritiaquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pananu jaara jaquiaari, na catijiareeri. Maja puera nujuacaraca na quishacari, ritia sorequeeri. ");
INSERT INTO arlNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tajaacaari totequiaarijiuhua riyocuaca tajinia. Jiohuacacaari socua ritia maashiquiaari. Natauri tarinitiucuara quiquiaari saniniuujia. Naaratej, majaari na muetunu quirii. ");
INSERT INTO arlNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tajaacaari saniniuujia totequiaari maninia jiyajinia cutara. Cuno cutaraari maninia maashiquiaari cuno jiyajinia. Senoosaareeri queraatia. Niquiriyatu jiyonajiniji carojosaaquiaariiri treinta jajau. Tanajajiniji socua sesenta jajau, naajuhuaj socua cien jajau tanajajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesuuri nojori sequeree: —Cante numaaracani, cuaara cua sequesano tojitiaara. ");
INSERT INTO arlNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na nuhuaji, Jesu quishacari tamajaaja, na saquiriojosano doce pueyari na nequesotaquiaari, tamasaca pueyanio. Cuno pojoricuajaari Jesu shuriucua quiriquiaa. Nojoriiri Jesu sequeree: —¿Casaa miriqui quia pohuatasano sequenu paniyani? ");
INSERT INTO arlNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesuuri nojori sequeree: —Pueyasoori nia niishitiojiya jiyasohua na miiniu panishano, taa na muerasu na jiitianutaniya pueyaracaanu cutarani. Tamasacara saniniuujia, canapuete Pueyaso ruuretajacani, nojoririaari miriqui pohuatashiyacujua. ");
INSERT INTO arlNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Naacuajitij, nojoriiri cua cumaacata cua miishano niquitiuquiaa pueyaracaanu najuhuanaj. Majaari nojori niishiniu na niquishano. Naajuhuaj, nojori jaara Pueyaso Rupaa tojitiare, majaari na niishiniu na tojishano. Nojori jaara niishiri, nojori mariqui noojia tacatorohuari sesa nojori miishanojiniji nojori jiyanooshaanura. ");
INSERT INTO arlNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesuuri nojori sequequiaarijiuhuaj: —¿Majateeri nia niishiniu miriqui cua pohuatasano? ¿Niaatucua taa niishiriquia socua tamonu cua pohuatasanoni? ");
INSERT INTO arlNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Cua pohuatasano cuhuariquiajinia natoojonajinijini, nojuajaari juhua Pueyaso Rupaa pohuatana. ");
INSERT INTO arlNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Noojiaqueya pueyari juhua nucuaco toteno jajau. Najuhuana Pueyaso Rupaa tojiyari. Na tojiniu nuhuaji, Satanásri nimiaa. Nojuajaari puetunu Pueyaso Rupaajanaa noojiajinia natasano jaariutiaquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tamasaca pueyari juhua noo jajau saniniuujia, sai tajiniaqueya jacutasanotej. Nojori jaara Pueyaso Rupaa tojiri, jiyanohua na timitiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Cunoori juhua secaja nujuacaraca moritiano jajau, sai tajinia na moritianuucua. Majaari na rishiniu. Naajuhuaj, cuno pueya jaara saniniujiushaare taraatia, jaara naquiya miishaarejuhuaj Pueyaso Rupaa tojijiaca nojori quiniuucua, nojoriiri ritia Pueyasoocua tiuuniu tarinitiaja. ");
INSERT INTO arlNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Noojiaqueya pueyari juhua noo jajau, jiohuacaca tajiniaqueya jacutasanotej. Pueyaso Rupaa tojiyari. ");
INSERT INTO arlNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Na nuhuaji, nojoriiri puera niishiriojiya taa nojori quiniutianiya maninia mijiriani. Nojoriiri sapojosaaquiaa puera na shuquiritiasacari mijiria casami. Nio jiya casamiicua jiaatiaquiaajaariuhuaj. Puetunu cunorajanaa, nojoriiri Pueyaso rupaa tojitiaquiaa na numaa shama. Naacuajitij, nojoriiri juhua muetuhuo quiya. ");
INSERT INTO arlNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Noojiaqueya pueya saniniuujia, nojori cutaraari maninia tojitiaja Pueyaso Rupaa. Cuno pueyari juhua cuhuariquiajinia natau, queraatia muetujua, maninia jiyajinia natasano. Cuno maninia nataujinijinioni, noojiaqueyari maja puera na muetunu. Tarajanuuri maninia muetuna. Naajuhuaj, tarajanuuri jiyanohua queraatia muetujua. Naajuhuaj, cante Pueyaso Rupaa tojijia cutarani, nojuajaari juhua maninia muetujua natau. ");
INSERT INTO arlNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesuuri nojori sequereejuhuaj: —¿Samaritiutiiri noshitishano, conatu cariquiaco jamotasocoriquiano, maquetu cariquiacojuhuaj? Maja. Samaritiu jaara noshitishaare, morijiuucua morotashiyari, tiajiniaaco na cuhuatanura maninia. ");
INSERT INTO arlNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Naajuhuaj, jiyasohua nia miishanoori puetunujuanaa niishishaanutaniya. Cua pohuatasanoori juhua samaritiu, puetunu pueya jiuujiaajanaa na cuhuatanura. Naajuhuaj, Pueyaso Rupaa jaara nioojiajinia jamosaare, juhua muetunutaniyari puetunu pueya niquishocoriquianojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Niajaniya, canapuete numaa jiitiaani, nia tojitiare cua pohuatasano. ");
INSERT INTO arlNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesuuri naa nojori sequequiaarijiuhuaj: —Nia niishiri nia tojishano. Nia shanacutajataja, teyanota nia shanacujuquiaa nia niquitiosocoriquianocuajani, Pueyasoori cunotaja niaara shanacunutaniyajuhuaj. Naacuajitij, niaa jaara capora quiriquia tamasacata, Pueyasoori socua capora quiniutianiya niaarajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Cante na rupaa tojijiani, socua na niishitiojonutaniyari. Saniniuujia, canapuete na rupaa tojitiaaquiyani, secaja na niishishanoori puetunu jaariutiasaanutaniyajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesuuri nojori sequequiaarijiuhuaj: —Nia niishitiojonu saniriiria taa Pueyaso muerasu supuequiaani, Pueyaso jiitiasano nojori quiniuria. Tamonu pueyanoori na cuhuariquiajinia nataquiaari jajau. Na nuhuaji, majaari na tacatenu quiquiaariuhua pueyaracaanu na natasano na niquiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cuno pueyanoori na natanu nuhuaji camueenujuquiaari. Cuno jajauri moritiaquiaari juuca, niucuanio. Maashiquiaariiri na camaru maquesacari, na niquishacarijiuhuaj. Tamonu juuca, na camaru tacatesacariuhua na natasano na niquiniuria, tariucua puereetuucaari quiquiaari. Majaari na camaru niishiniu quiquiaari taa na moritiareeni. ");
INSERT INTO arlNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jiyari tamajaaja moritianijia natau. Coteenu moritiaari na jiyona. Na nuhuaji, na jajau coori supueya. Na nuhuaji, na jajauri querasapijiaacara quimiaa na noshiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na natau jaara noshimia, na senoonaari na senoojua na racatasocoriquiano. Pueyaso muerasuuri naa miishaanutaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesuuri socua sequequiaari: —¿Juhua casaa niquishanote Pueyaso cumaacani? ¿Casaatate pa naata na saniniujiuniuni, taa Pueyaso Rupaa poonijiya pueya jiuujiajiniani? Quiarijia nia pohuatareeraj. ");
INSERT INTO arlNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pueyaso Rupaari pueya jiuujiajinia quiya juhua mostaza jajau. Mostaza jajauri jiyanohua socua shiitianiyojua puetunu tamasaca jajaujinijijianaa, majaari puera maatia na niquishaanu. Pueyaso Rupaari naajuhua pueya jiuujiajinia, nocua nojori tiuushacari. ");
INSERT INTO arlNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mostaza jajau jaara natasaare, maashiyari socua puereetuucara tamasaca nataujiniji. Na cashacucuaari maashiya puereetucucuara. Shuhuari na cashacucua cariquiaco nujuatujua shinishiqui. Pueyaso Rupaari pueyano jiuujiajinia naa cumaacaracajuhuaj, na jataniniuria na tojijia, maninia miijia na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesuuri naa queraatia miriqui pohuatasanota niishitiojoquiaari Pueyaso rupaa saaja pueya niishishano casaata. Majaari socua jiyajeneta casaa na pohuatanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Naacuajitij, nojuaja jaara casaa niishitiojonu paniquiaari pueya niquiara, nojuajaari puetunujuanaa naa niishitiojoquiaari miriqui na pohuatasanota. Tamajaaja nojori quishacari saniniuujia, Jesuuri na saquiriojosano pueya niishitiojoquiaari maatia, casaa miriqui na pohuatasano sequenu paniriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Cuno juuca jaara niniquiaari, Jesuuri na saquiriojosano pueya sequequiaari: —Caminia taquijiria pa quiaare. ");
INSERT INTO arlNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Cuniquijia pueya tiujiatiuyareeri, nojori quianura caminia taquijiria. Na pueyari Jesuta quiojiyaree cuno botejiniaja, tee nojuaja quiriquiaacuajani. Jesu quiasacari caminia taquijiria, tamasaca boteeri nata jaatequetariquiaajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Maja puera na quenaacoyaquishacarijia, maruuri paratuta canashiyaquiji jiyanohua niquiaari nojoriicua nojori niuutiasacari. Paratuuri jiyanohua cajiniuucuatequiaari mohuaca nojori botejiniacumara. Nocuaji na boteeri tari quera tiuquitiariquiaa mohuacata. ");
INSERT INTO arlNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesuuri jiyacari bote pajamaji maqueriquiaa juhuajaniya. Na nacaacuaji mataja caco maqueriquiaari. Na pueya niucuajatusacari nojuaja, Jesu sequetureeri: —¡Niishitiojonanaa!, ¿majateeri quia puerenuujua paa tari tiuquitiaareeni? ");
INSERT INTO arlNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesuuri sanemaa. Paratu sequereeri, caminianio: —¡Quia suraajere! ¡Tariucuaja! Paratuuri tajimiohua. Caminiaari pootia maquee. ");
INSERT INTO arlNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesuuri na saquiriojosano pueya sequeree: —¿Casaara nia puereya puerani? ¿Niaateeri Pueyasoocua tiuyashijiaca quiyajaaruhuaj? ");
INSERT INTO arlNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nojoriiri jiyanohua shiriiquitiurii. Tama nojorijiaarijia sequetooquiaari: —¿Cantejaaranojoni? ¡Paratu, caminiaari na tojirii! ");
INSERT INTO arlNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na nuhuaji, nojoriiri caminia taquijiria tiuquiijioquiaari, Gerasa jiyajinia. ");
INSERT INTO arlNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesu tacasacari botejiniji, nocua niquiaariiri tamonu pueyano raacajiniji, macunucua nucuhua paaquiosaquiji. Cuno pueyanoori samaruraca quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Raacajinia quijia quiquiaariiri. Majaari na naata moronu quishaaquiaari quenaaja cumayocua shipinishano casaata. ");
INSERT INTO arlNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pueyari juucua na morojojua, na cashacucua, na juaashiquiacanio. Saaja na turojotajaari. Majaari quenaaja na nujuataja pueyano quiniu quijia. ");
INSERT INTO arlNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pueyaracaanu tuhuananuhuacua rucuanejoquiaariiri, raacajinianio. Na rucuanejosacari sariyacojojuaari, juuca, niucuanio. Tama na cuaqueyajaaja piquijia saitiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nojuaja jaara Jesu niquiquiaari tucuacaanuji, nocua netequiaariiri. Jesu cariquimiaji mojoquetaseeri. ");
INSERT INTO arlNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jesuucuara nacareeri: —¿Casaacua miji quia niyani, Jesunaa, jiyocuacaanu Quijia Pueyaso Niyanunaa? ¡Quia secojiyanijia maja naquiya quia miiniuria janiya! ");
INSERT INTO arlNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Samaruhuaraca pueyanoori naa sequeree Jesutej, tari Jesu sequenuucua samaru nojuajiniji na tohuatanura. ");
INSERT INTO arlNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesuuri na nequesotaree: —¿Taa sesanaacatequia? Na riucuareeri: —Canaa jiyanohua queraatiani, cunora cua sesa “Queraatia”. ");
INSERT INTO arlNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Cuno samaruuri jiyanohua Jesu secojoriquiaa maja nojori na taanuunura cuno jiyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Cushiyari jiyacari cateca naataja miaquenuuriquiaa tuhuananucari. Jiyanohua queraatia cushiyari quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Samaruhuari Jesu secojoree naatej: —¡Canaa quia jiyarore canaa tiuquitianura cuno cushiyacua! ");
INSERT INTO arlNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesuuri samaruhua jiyaroree. Samaruhuari pueyanojiniji tohuareetaquee. Cushiyacua tiuquitiaseeri. Dos mil cushiya naasucuaari quiriquiaa. Cuno cushiyari cocuatequiaari, samaruhuaraca nojori quiniuucua. Tacojiniji totesee caminiajiniaari. Puetunujuanaari tii shushiniuuquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Cushiya cojuanaari jiyacari netecuaturohua na shiriiquiniutia. Na tiacajinia pueya poojotanuusuhua nojori niquishanoori, cuhuariquiacajinia quiniaa pueyanio. Nocuaji pueyari nijioquiaari nojori niquiniuria casaate quiquiaarini. ");
INSERT INTO arlNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Cuno pueya jaara tiuquiijioquiaari Jesu quishaqui, cuno tarijia samaruhuaraca quijia pueyano niquitiushiiri panaatia cajiyano, toqueraca. Naa nojori niquishacari nojuajatej, pueyari pueretuquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jesu miishano niquitiuniaari cuno pueya pohuataquiaari taa samaruhuaraca pueyano miishaareeni, mariyata cushiyajinijinio. ");
INSERT INTO arlNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Cunora, cuno pueyari Jesu secooteree na quianuhuara cuniquiji, nojori jiyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesu jaara tacaquiaariuhua na botejinia, cuno tarijia samaruhuaraca quijia pueyanoori nata quianu paniquiaari juucua. ");
INSERT INTO arlNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Majaari Jesu paniniu quiquiaari. Na sequeree saajaari: —Quia quiaarohua quia tiajinia quia pueyacua. Quia pohuatasuhua nojori taa Pueyaso miirii quiajaniyani, quiocua na taraajenuucua. ");
INSERT INTO arlNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pueyanoori quiaarohua. Nojuajaari pohuatanu coteequiaari cuno na jiya diez tiacajinia taa Jesu miiquiaari maninia nojuajani. Puetunu pueyajanaari jiuujiatequiaari nojori tojishacari nojuaja. Cuno diez tiaca sesa quiquiaari “Decápolis”. ");
INSERT INTO arlNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu jaara niuutiaquiaariuhua botejinia caminia taquijiriohua, queraatia pueyari nocua tiuquiijioquiaari na quishaqui. ");
INSERT INTO arlNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jesu quishacarijia caminia casaqueyaji, nocua tiuquiquiaariiri tamonu pueyano, Pueyaso secojojua tia jiyaniijia. Na sesa quiquiaari Jairo. Jaara Jesu niquiquiaari, na cariquimiaji mojoquetaseeri. ");
INSERT INTO arlNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Naa Jesu secojoree jiyanohuari: —¡Quiyatu quera cusoya! ¡Miji, quia juaashiquia nocua quia niaquee na naatanuhuara! ");
INSERT INTO arlNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesuuri jiyacari nata quiaaree, na saquiriojosano pueyanio. Puera jiyanohua queraatia pueyari na nuhuajiriquiaa. Jesu tanuujuturiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Cuno pueya tajinia quiriquiaajaariuhua tamonu cusosu maaji. Doce marijiaari tari na shoconujuquiaari pueyaracaanu na naatesacari. ");
INSERT INTO arlNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Queraatia naarajonaari nareja naquiya na miiquiaari. Socua na jiyacatojoquiaari saajaari. Najuhuana na cumaneeca puecaquiaariiri na naarojosaanura juucua. ");
INSERT INTO arlNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Cuno maaji jaara Jesujiniji tojiquiaari, na nijiniji na nuhuajiquiaari jiyasohuari. Na tucuaque toque quiasee pueya tajiniaari. ");
INSERT INTO arlNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Cuno maajiiri tama sequequiaarijiaaja: “Janiya jaara quenaaja na toque quiareni, janiyari naatanutaniuhuani”. ");
INSERT INTO arlNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Naacuajitij, na quiasacari Jesu toque, na nanacaari ritia curetaquee. Jiyacari na niishiquiiri. Tama sequequiaarijiaarijia: “¡Cua cusonu tari tajiyatemaa!” ");
INSERT INTO arlNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesuuri jiyacari niishiquii nojuaja na cumaacata cusosu naatanirii. Cunora, nojuajaari tacareecuaree na niquiniuria pueya. Pueya nequesotareeri: —¿Cante cua toque quiareeni? ");
INSERT INTO arlNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Na saquiriojosano pueyari na sequeree: —Quiaacuajaari queraatia pueya niquiya quia tanuujiyano. Quiaari najuhuana nequesotaariquiohua saajuhuaj: “¿Cante cua quiareeni?” ");
INSERT INTO arlNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesuuri saaja na shocuaqueya niquinijioriquiaa, na niquiniuria cante na toque quiareeni. ");
INSERT INTO arlNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Maajiiri jiyacari tetecariquiaa na puerenuta. Jesu cariquimiaji mojoquetasee ritiaari. Nojuajaari niishiquiaari Jesu cumaaca na naataniriohua. Cunora, Jesu sequeree puetunu seetanujuanaari. ");
INSERT INTO arlNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Na nuhuaji, Jesuuri na sequeree: —Sanaunaa, cucua quia tiuuniuucua, quiaacuaja tari quia cusonujiniji naatarohua. Juhuajaniya quia quiaarohua. Quia cusonucuaja tari tajiyatemohua quiocuaji. ");
INSERT INTO arlNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesuuri cuno maajiicua pocuariquiaajaa pueya tiuquiijiosacari Jairo tiajiniji. Cuno pojoriiri maaji samiriu que sequetusee: —¡Quia niyatu tari cusoquee! Maja najuhuana Niishitiojona riniu quia tiajiniara. ");
INSERT INTO arlNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesuuri nojori sequesano tojirii. Naaratej, maaji samiriu que sequereeri: —¡Maja puerenu! ¡Cucua quia tiuuri saaja! ");
INSERT INTO arlNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Majaari Jesu paniniu quiquiaari tamasaca quiojonura nata. Saaja nata quiojoquiaari cutaraari Pedro, Santiago, Santiago tarajanu Juannio. ");
INSERT INTO arlNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nojori jaara tiuquiijioquiaari Jairo tiajinia, pueya niquishii nujuquetiuyanoori, sariyocuatiuyanonio. ");
INSERT INTO arlNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesu jaara tiajiniaaco tiuquiquiaari, cuno pojori sequereeri: —¿Casaara puera nia cojuatuneyani? ¿Casaara naa nia nujuqueyani? Maaji samiriu maja macu. Nareja maqueyano. ");
INSERT INTO arlNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pueyari saaja Jesu saroojotaquiaari nojuaja na rerequetenuta, naa nojori na sequenuucuatej. Jesuuri cunora nojori tohuatanijioree tiajiniaacoji. Jesuuri macuucua sohuacamara tiuquinitiaquiaari Jairo necocuata, tama na pueyajaajanio, cuniqui tii nata quitiuriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Macu juaashiquiajiniji quiaseeri. Na sequereeri: —Talita, cumi. Nioori pueyano rupaajinia sequeya: “¡Maaji samiriuniaa, quia sequeyanijia, quia sanere!” ");
INSERT INTO arlNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jiyacaritij, maaji samiriuuri ritia sanequee. Juhuacatecara rucuanereeri. Doce marijiaari tari cuno maaji samiriu shocojoquiaari na queyata na quishacari. Pueya niquishacari naa Jesu miishanotej, nojoriiri jiyanohua jiuujiatequiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesuuri jiyanohua nojori rootaree maja nojori pohuatanura pueya niquiara na miishano. Saaja sequeree cutaraari maaji samiriu cuaara mianuutesaaria. ");
INSERT INTO arlNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesuuri cuniquiji quiaquiaariuhua tama na jiyajiniohuajaaja. Na saquiriojosano pueyari nata quiojoquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jaara quiquiaari samaatenu juuca, Jesuuri tii niishitiojonu coteequiaari Pueyaso secojojua tiajinia. Queraatia pueyari na tojitiariquiaa. Nojoriiri jiuujiatequiaari. Tamajaaja sequetooquiaariiri: —¿Tee nio pueyano niishitiojosaaquiaari puetunu niojuanaani? ¿Teje na masecanu puetunu na niishishanojuanaani, cuno cumaacanio, jiyajeneta miishano na miiniuriani? ");
INSERT INTO arlNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nojuacuajaari suruhuatujiniji casaa shipinijiona tiajiniaacora, niya pa tiacajiniani. Nojuajaari pa tiacajinia quinia María niyanu. Niya quiyajaariuhua na tapueyocuaca: Santiago, José, Judas, Simónnio. Na rimiatuhuari niya quiyajuhuaj pa tiacajiniani. Cunora, majaari nojori tojitianu paniniu quiquiaari Jesu. ");
INSERT INTO arlNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Naaratej, Jesuuri nojori sequeree: —Pueyari tiquiyocua Pueyaso sequenu panishano caminiujiunia tojiniu paniquiaa cutara. Saaja tama na tiacajinijinio pueya cutaraari maja na tojitiuniu paniniu, na jiyasojinijinio supueno pueyajuhuaj, tama na tiajinia quiniaajaajanio. ");
INSERT INTO arlNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Naacuajitij, nocua nojori tiuyaquiniuucua, majaari na naata na cumaacata na miiniu quiquiaari. Saaja secaja cusosuhuacua niojoquiaari na juaashiquiaari, nojori na naatanijionura. ");
INSERT INTO arlNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesuuri jiuujiatequiaari nojori tiuyaquishacari nocua. Na nuhuaji, Jesuuri rucuanejoquiaari pueya na niishitiojonura, queraatia shiitianiyojua tiacajinia catecaja na tiaca shocua. ");
INSERT INTO arlNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na nuhuaji, Jesuuri na saquiriojosano doce pueya sequequiaari nocua nojori niniuria. Nojori jiyaramiquiniu coteereeri, nojori quiojonura caapiqui, caapiqui, Pueyaso rupaa nojori pohuatanura. Nojori niquitioree na cumaacaari samaruhua nojori tohuatanijionura pueyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nojori sequereeri maja nojori panura nojori panishano, saaja nojori miojotu cutara. Nojori sequereejaariuhuaj, maja nojori panura caashoque, coseyaca, cumaneecanio. ");
INSERT INTO arlNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nojori sequereeri saaja nojori cushiniuria na sapatu cutara, maja socua toque nojori panura na cushishocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nojori sequereejaariuhuaj: —Niaa jaara tiuquishiiquia tamonu tiajinia, cuniquijia nia jiyojetare, niaa jaara cuniquiji quiaarejaatijia. ");
INSERT INTO arlNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pueya jaara nia tiuquinitianu paniyaquiri na tiajinia, nia pohuatasano nojori tojiniu paniyaquishacarijiuhuaj, niocua cuniquiji quiaare. Niocua nia niohuacaacuaji jiya joocua piitiare nojori niquiara, nojori niishiniuria Pueyasoori nojori saniitionutaniya, na rupaa tojiyashijianucua nojori quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na nuhuaji, Jesu jiyaramiquishano pueyari quiojoquiaari. Nojoriiri Pueyaso rupaa pohuatanuuquiaari pueya tacatonuhuara nojori jiuujia Pueyasoocua. ");
INSERT INTO arlNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nojoriiri queraatia samaruhua tohuatanijioquiaari. Naajuhuaj, nojoriiri cusosuhuacua tarooquiaari naana jajau shiyocua, nojori naatanijiosacari queraatia pueya. ");
INSERT INTO arlNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesu miishanojinijiiri caminiujiushaaquiaari puetunu cuno jiyajiniajanaa. Naacuajitij, Galilea jiya jiyaniijia Herodesri Jesujiniji pohuatasaaquiaarijiuhuaj. Herodesri cunora sequequiaari: —¡Tiuquinijiona Juanqui samiitiarohuacuaa, cua mosano pueyanotej! Naaratej, cuno Jesuuri cuno cumaacaraca, jiyajeneta casaa na miiniuria na cumaacata. Nojuacuajaari cua mosano Juan samiitianohua. Jiyaniijia Herodesri na jiyajenetaquiaari jiyanohua cumaacaraca Jesu quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tamasaca pueyari Jesujiniji sequequiaari tamaatia saniniuujia, nojori jiyajenesacarijiuhuaj. Naa sequetuquiaariiri: —¡Nojuacuajaari tariucuacaanu pueyara Pueyaso sequesano caminiujiunia Elías! Tamasaca pueyari saniniuujia naa sequequiaari, nojori jiyajenesacarijiuhuaj: —Nojuacuajaari quiarijia nio pa quishacari Pueyaso sequesano caminiujiunia pajaniyara, juhua tariucuacaanu pueyara Pueyaso sequesano caminiujiuniaajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes jaara pueya sequesano tojiquiaari, nojuajaari saa sequequiaarijia: —Nojuacuaja Tiuquinijiona Juan, cana cua nacataniquianucuajani. Samiitiarohuacuaaquiiri. ");
INSERT INTO arlNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tiuquinijiona Juan moyaquishacarijia, nojuajaari Herodías rupaajinia nujuatesaaquiaari. Cuno maaji Herodíasni, nojuajaari Herodes tarajanu Felipe niquiocua quiquiaari coteenu. Herodesri tarajanu Felipe niquiocua jaariutiaquiaari necocuara. ");
INSERT INTO arlNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nocuaji, Tiuquinijiona Juanri Herodes nacasujujua. Naa na sequejaari: —¡Pueyasora, majaari maninia quia jiitianura quia tarajanu niquiocua! ");
INSERT INTO arlNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Cunora, cuno maaji Herodíasri maja na niquiniu paniniu quijia Tiuquinijiona Juan. Na monu panijiaari. Majaari na naata quiquiaari saaja. ");
INSERT INTO arlNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodesri Tiuquinijiona Juan puereja. Nojuajaari niishiquiaari Tiuquinijiona Juanri maninia pueyano, Pueyaso tojijia pueyano, maja sesa miijia. Naaratej, Herodesri maninia na cojuateja nujuatejojuajinia. Majaari na shanacunu quiquiaari sesa na miishaanura. Herodesri Tiuquinijiona Juan pohuatasano tojiniu maniniucuaja. Nojuajaari saaja noojia niquijioteja quiquiaari. Majaari na niishiniu quijia taa na miiniutianiyani. ");
INSERT INTO arlNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Saniniuujia, cuno maaji Herodíasri pueyaracaanu niishiriojoriquiaa, Tiuquinijiona Juan na motenura. Jiyacaritij, namitia nera, Herodes rasaanu juuca quiquiaari. Cuno juuca, jiyaniijia Herodesri queraatia pueyata queranacuree. Na queranacunura, nojuajaari Galilea jiyajinijinio jiyaniijianucua masuuquiaari, tama na soldadohua jiyaniijianucuajaajanio. ");
INSERT INTO arlNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jiyacaritij, Herodías niyatuuri tiuquiquiaari queranacusaqui, tii na nianujunura puetunu pueya niquiarajanaa. Herodesri niyacoo nianujunu shuquiritiaquiaari jiyanohua. Nata miaquenaa pueyari jiyanohua na shuquiritiaquiaarijiuhuaj. Naaratej, jiyaniijia Herodesri niyacoo sequeree: —Cua masere quia panishano. Janiyacua quia niquitioreni. ");
INSERT INTO arlNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herodesri socua puetunu pueya niquiarajanaa na sequerohuacuhuaj: —¡Seetanujuanaa quia sequeyanijia, maja cua sapojonu! Janiyari quia niquitionutaniya quia masesanoni. Quiaa jaara cua masere cua jiitiasano cajiniocua, naajaa, janiyari quia niquitionutaniyani. ");
INSERT INTO arlNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Niyacoori tohuataquee na nucua Herodías na nequesotanura. Na sequeseeri: —Cua nucuanaa, ¿casaa cua masenutaniya cua quenuni? Na nucuaari na sequeree: —¡Quia masere Tiuquinijiona Juan naca! ");
INSERT INTO arlNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Cuno niyacoori ritia tiuquiquiuhua jiyaniijia Herodes quishaqui. Na sequereeri: —¡Quiarijia cua niquitiore Tiuquinijiona Juan naca miacojuajinia! ");
INSERT INTO arlNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Naa jiyaniijia Herodes tojishacaritij, jiyanohua taraajequeeri. Naajaa, seetanujuanaa na sequenuucua na masuusano pueya niquiara, majaari tari na naata ruuretanu quiquiaari cuno niyacoo masesano. ");
INSERT INTO arlNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Naaratej, jiyaniijiaari ritia jiyaroree na soldado, Juan naca na niquitionura cuno niyacoo. ");
INSERT INTO arlNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Soldadoori quiaaree nujuatejojuajinia. Juan nacataseeri. Na naca patamohua miacojuajiniaari. Soldadoori niyacoo na niquitiosuhua. Nojuajaari na nucua na niquitiosee saniniuujia. ");
INSERT INTO arlNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tiuquinijiona Juan pueya jaara na niishiquiaari, na maanu patuquiaariiri, na jamotusocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesu jiyaramiquishano pueyari tiuquiijioquiaariuhua Jesuucua nojori rucuanejonu nuhuaji Pueyaso rupaa nojori pohuatanura. Nojoriiri Jesu pohuataquiaari puetunu nojori miitiushanojuanaa, nojori niishitiojosanojinijinio. ");
INSERT INTO arlNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na nuhuaji, Jesuuri nojori sequeree: —Miji, pueya quiyaquishaqui pa quiaare tamaqui, tii pa samaatenura rupaquijia quenaaja. Jiyanohua queraatia pueyari pueyaracaanu nojoriicua nijioriquiaa. Tamasacaari quiojoriquiohuacuaa. Tamasacaari saniniuujia shusha tiuquiijioriquiaacujua. Naaratej, majaari jeya nojori quiniu quiquiaari na miaquenura quenaaja. ");
INSERT INTO arlNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jiyacaritij, Jesuuri saaja na jiyaramiquishano pueyata quiaquiaari botejinia, pueya quiyaquishaqui. ");
INSERT INTO arlNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Queraatia pueyari saaja nojori niquitiurii quiaano. Cuno pojoriiri Jesu niishitiuquiaari. Naaratej, puetunu caminia shuriuquioco tiacajinijijianaa pueyari netecuatuquiaari. Nojoriiri Jesuucuaji cutesee. ");
INSERT INTO arlNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesu rosesacari botejiniji, saaja queraatia pueya niquiriiri. Nojori na niquishacari, cuno pojoriicua taraajequiaariiri. Nojoriiri juhua cojuanaaju borregohua quiriquiaa. Naaratej, Jesuuri nojori niishitiojonu coteeree queraatia casaa Pueyasojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jaara quiquiaari tari tenacari, na saquiriojosano pueyari nocua nijioquiaari. Na sequetuseeri: —Tari tenacari. Paa tiajiyaqui quiyani. ");
INSERT INTO arlNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pueya quia sequere, nojori cuaara quiojoora cateca naataja tiacajinia, na miaquesocoriquiano nojori masenura tii. ");
INSERT INTO arlNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesuuri nojori riucuaree saaja: —Niaa mariqui nojori miaquetereja saniya. Nojoriiri na sequeree: —¿Quiaateeri paniya queraatia pan masenuucua canaa quianura puetunu cuno pojoririajanaa? ¡Pa mianuutenura nojori, panishiyari dosciento cumaneeca! Majaari pa jiitianu. ");
INSERT INTO arlNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesuuri nojori nequesotaree: —¿Taa pan nia jiitiaani? Nia niquishiitioj. Nojori jaara niishiquiaari taa pante quiyani, na sequetusuhuari: —Cinco pan quiya, caapiqui sapitiaajanio. ");
INSERT INTO arlNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesuuri jiyacari na pueya sequeree nojori cajitijionura pueya jiyasocuajinia, na mianuutesocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pueyari cajitiurii cien, tamocora cincuenta, tamaqui socua cien, camiria cincuenta. Pueyari naa queraatia maapuera raquiriojotasaaree nojori mianuutesaanura. ");
INSERT INTO arlNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesuuri cuno pan pataree, sapitiaajanio. Na nuhuaji, jiyocuacaanu maureeri Pueyaso na secojonura nocuara. Na nuhuaji pan neecasequiaari na saquiriojosano pueyaraari, nojori serotasocoriquiano pueya. Cuno caapiqui sapitiaaja shiquioreereejaariuhua puetunu pueyarajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Puetunu pueyajanaari maninia miaquenuuquiaari. Maninia tooquioreejaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na nuhuaji, doce canaasatuuri mishinijiosaaquiaari pan raacuata, sapitiaaja raquiquiatanio. ");
INSERT INTO arlNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cinco mil pueyari cuno panjiniji miaquenuunaa quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nio nuhuaji, Jesuuri na saquiriojosano pueya tacanitiaquiaari botejinia, nojori puetanura nojuaja caminia taquijiria Betsaida tiacajiniara. Jiyacaritij, Jesuuri pueya sequeriquiaa nojori quiojonuhuara na tiacajiniohua. ");
INSERT INTO arlNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pueya jaara tari quiojoquiaariuhua, Jesuuri tuhuananuucua tacaquiaari tii na secojonura na Que Pueyaso. ");
INSERT INTO arlNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jaara niniquiaari, boteeri tari caminia jiuujiajinia jaaretariquiaa. Jesuuri juhuanojuaja na jateesaqui quiriquiaajaa. ");
INSERT INTO arlNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesuuri nojori niquiquiaari najuhuana juaarioconuyano. Majaari nojori naata jaaretanu quiriquiaa, puera paratu piyarojosacari nojoriicuara. Quera juhuaquenu panishacari, Jesuuri nojori rupuesee. Mohuaca caco canujuriquiaari. Quera nojori tajiriquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nojori jaara na niquitiuquiaari mohuaca caco canujiyano, nojoriiri na jiyanitiuquiaari samaru. Nocuaji sariyocuatureeri. ");
INSERT INTO arlNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Puetunu nojorijianaari na niquitiurii. Shiriiquitiuriiri. Jesuuri ritia pocuaree. Nojori sequereeri: —¿Casaara nia puereyani? ¡Nioojia nia cumaquiri! ¡Maja pueretunu! Janiyacuajanijia. ");
INSERT INTO arlNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Botejinia tacasee nojoriicuaari. Paratuuri jiyacari pueyajequee. Nojoriiri na shootiariquiaa tacuriitia, jiyanohua na jiuujiatenuta. ");
INSERT INTO arlNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nojoriiri juhuanojuaja maja na niishiniu quiquiaari Jesu miishano, queraatiara na jiyatesacari pan, pueya miaquesocoriquiano. Nojori jiuujiacaari juhua ninishiqui quiquiaarijia. ");
INSERT INTO arlNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesuuri na pueyata caminia niuutiaquiaari. Tiuquiijioseeri Genesaret jiyajinia. Nojoriiri tii morotasee na bote. ");
INSERT INTO arlNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nojori jaara tohuareetaquiaari botejiniji, cuniquijinio pueyari ritia Jesu niishiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pueyari jiyacari netecuatuquiaari, Jesujiniji nojori pohuatanura puetunu cuno jiyajiniajanaa. Cusosuhuari juhuacatecara patootasaaquiaari na matucuajinia tee Jesu quiriquiaa na rucuanejosacari nojori jiyajiniacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tiquiyocua Jesu rucuanejosacari, cusosuhuari nocuaji niojotasaaquiaari nucuaco, tuhuaqui tiacajinia, queraatia shiitianiyojua tiacajiniajuhuaj, cuhuariquiacajinianio. Pueyari Jesu secojoree cusosuhua na quiatenura quenaaja na toque casaca. Canapuete na toque quiaquiaarini, puetunu nojorijianaari na cusonujiniji naatacoquiaariuhua. ");
INSERT INTO arlNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jesuucua catecanoquiaariiri Fariseocuaca, Moisés Rootasanojiniji niishitiojonaanio, canapuete Jerusalén tiacajiniji nijioquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Cuno pojori quishacari tii, nojoriiri noojiaqueya Jesu pueyajinijinio niquiquiaari shuquitioojua miaqueyano. Nojoriiri jiyanijia, nojori rucuanejosacari sesa miijiaca pueya tajinia, sesa nojori quiniu na naata nojoriicua pacunu. Nojoriiri cunora shuquitianu jiitiquiaari, nojori jiyanishacari nojori jiuujia naasucua curuushiniutianiya, shuquitioojua nojori miaquesacari. Naaratej, cuno pueyari Jesu pueya pocuanu coteequiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Cuno Fariseocuaca, puetunu narta Judiocuacajanaanio, nojoriiri maja na cartenu quijia tariucuacaanu nojori supuetanaa niishitiojosano. Naaratej, majaari nojori miaquenu quijia shuquitioo. ");
INSERT INTO arlNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Naacuajitij, nojori jaara miaquesano niquitiojosaquiji tacatequiohua, majaari nojori miaquenu shuquitioojua. Socua queraatia quiyari cuno pojori niishishano. Naacuajitij, nojoriiri jiyaniquiaa, sesa nojori quiyaquiniuucuaji Pueyaso niquiara, nojori cuaara na ratujua jeequejoora, pataco, coshi, na maquetucuanio. ");
INSERT INTO arlNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Naaratej, Fariseocuaca, Moisés Rootasanojiniji niishitiojonaanio, nojoriiri Jesu nequesotaquiaari: —¿Casaara quia pueya tojitiaaquiya pa supuetanaa niishitiojosanoni? Nojoriiri maja na shuquitianu quiquiaa na miaquenuunura. ");
INSERT INTO arlNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesuuri cuno pojori riucuaree: —¡Niaari sapuenu juhua maninia pueya niquishano! ¡Niaacuajaari seetanujuanaa sesa miijiaca! Pueyaso sequesano caminiujiunia Isaíasri maninia sequequiaari niajaniyajinijicuaja, naa na naajiotasacari Pueyaso sequesano: “Nio pueyari saaja na rupaata shuquiritiaa janiya. Nojori jiuujiaari saniniuujia tucuacaanu quiya janiyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nojori miishano quiriani, cunoori najuhuanaj. Naa nojori miishanoni, majaari na shuquiritiniu janiya. Nojori niishitiojosanoni, cunoori tama pueya niishitiojosanojuaaja, maja cua sequesano”. ");
INSERT INTO arlNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Niaari cua pueya pocuariquiaa. ¿Niajaniyariuhuaj? ¿Casaara Pueyaso sequesano nia tojiyaquiquiaanijia? Niaacuajaari Pueyaso sequesano tojiyaquiya, tama nia supuetanaa niishishanojuaaja nia miiniuria najuhuanaj. ");
INSERT INTO arlNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesuuri socua naa sequequiaari cuno pojoritij: —Tama nia miiniu jiitishanoocua nia miiniuriajaaja, ¡niaari Pueyaso sequesano shocortaa saaja! ");
INSERT INTO arlNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moiséscuajaari naa rootaquiaari: “Maninia quia miiri quia que, quia nucuanio. Majaari nojori rerequetenu. Cante na que, na nucua sesacajani, cuno pueyano cuaara mosaaria”. ");
INSERT INTO arlNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Niaari sequeya saniniuujia, maniniacuaja, pueyano jaara na que, na nucua sequere: “Maja cua naata naacutanu niajaniya cua casamitia. Janiya tari Pueyasora jiyateree puetunu cua jiitiasanojuanaani”. ");
INSERT INTO arlNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Niaari sequequiaajuhuaj, pueyano jaara naa sequeretej, maniniacuaja maja na naacutanura na que, na nucuanio. ");
INSERT INTO arlNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Naacuajitij, niaari Pueyaso sequesano shocortaa saaja, tama nia niishishanojuaaja nia miiniuria najuhuanaj. Cuno nia niishishanocuajaari saaja nia supuetanaajiniji caminiujiushano. Niaari socua queraatia casaa miiquiaa juhua cunojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Naa na nacasunu nuhuaji cuno pojoritij, Jesuuri pueya rerejoterohua na shocua. Nojori sequereeri: —Cua tojitiare puetunu niajaniyajanaa, maninia nia niishiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Casaa pa miaqueyani, Pueyasora naajaa. Cunoori maja na naata pueyano jiyatenu sesa miijiara. Poojiajinia pa niishiriojosano cutaraari sesara pa jiyateya Pueyasora. ");
INSERT INTO arlNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Cante numaaracani, nojuaja cuaara tojitiaara cua sequesano. ");
INSERT INTO arlNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesu jaara tiujiaquiaari cuno pueya, tiajiniaaco tiuquiyarohuari. Na saquiriojosano pueyari tii na nequesotaree pueya na niishitiojosanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesuuri nojori sequeree: —¿Niaateeri cua sequesano niishiyaquiyajuhuaj? ¿Majateeri nia niishiniu? Puetunu pa jiniacuma tiuquijiajanaani, cunoori maja na jiyatenu sesa miijiara pajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pa miasanoni, majaari na tiuquiniu poojiajinia, saaja pa seecojinia mishiya cutaraari. Na nuhuaji pocoma tajiyari pa marecuhuacuma. Nio sequesanota, pueya niishitiojoriquiaari, puetunu miaquesanojuanaari maniniacuaja pa miaquesocoriquiano. Maja cutaraari na naata na jiyatenu pajaniya juhua curuutuucara Pueyasora. ");
INSERT INTO arlNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesuuri sequereejuhuaj: —Pueyano niishiriojosano sesa noojiajiniani, cuno cutaraari sesara na jiyatequiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pueyano jiuujiajiniji supueya cutaraari sesa niishiriojosano, sesa na miiniuria. Naacuajitij, pueyanoori na camishoo maajipohua numuetucujua, seya numuetucujuajuhuaj. Tamonu pueyano casami nohuasejoquiaari. Pueya moquiaajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Narta pueyano niquiocua numuetucuquiaari. Tamonu pueyano casamiicua jiaatiaquiaari. Jiyanohua sesa miiquiaari. Cuaracashijionu niishiyari. Tama na cuaqueyajaaja shuquiritiquiaari na miiniu jiitishanota. Narta pueyano miananajoquiaari. Tamonuucuara tonujuquiaari. Naajuhuaj, saaja tama na cuaqueyajaaja shuquiritiaja quiquiaari. Juhuajaniya sesa miiquiaajaariuhuaj, moseeca na quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Puetunu nio sesa miishanojuanaari pueya jiuujiajiniji supuequiaa. Cuno cutaraari sesa quijiara pueya jiyateja Pueyaso niquiara. ");
INSERT INTO arlNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesuuri cuniquiji quiaaree Tiro tiaca shocua jiyajiniara. Tii tiuquishii tamonu tiajiniaari. Majaari na paniniu quiquiaari pueya niishiniuria nojuajiniji, tee na quiyani. Naajaa, majaari na naata jamaaniu quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tamonu maajiiri ritia Jesujiniji niishiquiaari. Neyatuuri samaruraca quiriquiaa. Naaratej, maajiiri Jesuucua niquiaari. Na cariquimiaji mojoquetaseeri. ");
INSERT INTO arlNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Cuno maajiiri Sirofenicia jiyajinijinio taatu quijia. Jesu secojoseeri samaru na tohuataniniuria neyatujiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesuuri maaji sequeree miriqui: —Quia tarinitiare, muerasu cuaara coteenu miaquenuura. Majaari maninia muerasu pa jaariutianura na miaquesano, sareyacari jatasocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Maajiiri Jesu riucuaree: —Jaa, Jiyaniijianaa. Naajaa, sareyacuajaari miaqueja cariquiacoji tatucuaja, muerasu totinijiosano miaquesano shiriya. ");
INSERT INTO arlNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesuuri na sequeree: —¡Quiaacuaja maninia cua riucuaree! Quia tacateyarohua. Samarucuajaari tari tohuataree quia niyatujiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Maaji tiuquishacariuhua na tiajiniohua, neyatu riuriatasuhuari na maquetujinia mataano. Samaruuri tari tohuatano quiriquiaa nocuaji. ");
INSERT INTO arlNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesuuri tacatequiaariuhua Tiro tiaca shocua jiyajiniji. Na tacatesacariuhua, Sidón tiaca shocojoquiaariuhuari, Decápolis jiya tiacanio. Galilea caminiajinia tiuquishuhuari. ");
INSERT INTO arlNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tii na quishacari, nocua jaatucusaaquiaariiri numueeju, tiquia pueyano. Na jaatucunaari Jesu secojotuquiaari na juaashiquia na nianura nocua, na jeecanura cuno pueyano. ");
INSERT INTO arlNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesuuri pueyano numueeju jaatucuree tamocora pueyacuaji. Na numaama shirii na juaashiquiaari. Na nuhuaji, tama na juaashiquiajiniajaaja riocoreeri. Na riacau cojuata pocuaashijia niti quiareeri. ");
INSERT INTO arlNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jiyacaritij, jiyocuacaanu maureeri. Noojia niareeri. Na nuhuaji, cusosu numaa sequereeri: —¡Efata! Nioori pueyano rupaajinia sequeya: “¡Quia riatere!” ");
INSERT INTO arlNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jiyacaritij, numueeju numaari riatequequee. Na nitiiri jeequequeejuhuaj. Ritia pocuaquee maniniaari. ");
INSERT INTO arlNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesuuri cuno pojori rootaree maja nojori pohuatanura na jeecasano pueyanojiniji tamasaca niquiara. Nojoriiri saaja tiquiyocua pohuatanuuquiaari. Naa Jesu rootasacari na naatanijiosano pueyatej, maja nojori pohuatanura na miishanojiniji, nojoriiri saaja socua jiyacatequiaari pohuatanura. ");
INSERT INTO arlNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pueyari jiyanohua jiuujiatequiaari Jesu miishano na niquitiushacari. Tama nojorijiaarijia sequetooquiaari: —¡Puetunujuanaa miya maniniaari! Numueejunucua jiyateya tojitiajacaraari. Tiquianucua pohuateyajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jiyacaritij, jiyanohua queraatia pueyari rerejoquiaari Jesu na tojitianura. Majaari nojori jiitianu quiquiaari casaa quenaaja na miaquetusocoriquiano. Jesuuri na saquiriojosano pueya piirii. Nojori sequereeri: ");
INSERT INTO arlNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nio pueyacua taraajeyanijia. Nojori tari jiuujianaraca juuca quiya niya cuata. Majaari quenaaja nojori jiitiatunu miaquesano. ");
INSERT INTO arlNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Janiya jaara nojori jiyaramiquiriohua na tiajinia miaqueyojuani, nucuaco cusojoniuyarohuacua. Noojiaqueya nojorijinijinioori niyara nijiorucuaa tucuacaanuji. ");
INSERT INTO arlNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na saquiriojosano pueyari na riucuaree: —¿Paatucua taa miaquetere nojori niyani, pueya quiyaquishaquini? ");
INSERT INTO arlNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesuuri nojori nequesotaree: —¿Taa pan nia jiitiaani? Nojoriiri na sequeree: —Nareja siete. ");
INSERT INTO arlNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesuuri na pueya sequeree, nojori cuaara sequeera puetunu pueyajanaa nojori cajitiuniuria. Na nuhuaji, Jesuuri cuno siete pan pataree. Pueyaso secojoree nocuaraari. Na nuhuaji, na saquiriojosano pueyara na neecasereeri. Nojoriiri saniniuujia pueya na serotaree puetunujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Secaja sapitiaaja jiitiaturiquiaajaariuhuaj. Jesuuri socua nocuara secojorohuacuhuaj. Na nuhuaji, na pueya sequereeri nojori niquitiojonura pueya. ");
INSERT INTO arlNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Puetunu pueyajanaari maninia miaquenuuree. Tooquioreejaariuhuaj. Miaquesano cureenota mishinijiosaaquiaariiri siete canaasatu. ");
INSERT INTO arlNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na miaquenaa pueyari quiquiaari cuatro mil pueya. Na nuhuaji, Jesuuri nojori sequeree nojori quiojonuhuara. ");
INSERT INTO arlNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Na nuhuaji, Jesuuri botejinia tacataquiaari na saquiriojosano pueyata. Quiaareeri Dalmanuta jiyajiniara. ");
INSERT INTO arlNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseocuacaari Jesuucua tiuquiijiosee. Nata juayonuutaseeri. Nojori saniniujiuniuria Jesu, nojoriiri na sequeree juucua cuaara nojori niquishocoriquiano casaa miiria Pueyaso cumaacata. Nojoriiri naa na sequeturee, nojori niishiniuria Jesute seetanujuanaa Pueyaso Jiyarosano. ");
INSERT INTO arlNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesuuri noojia niaree na taraajenuta. Sequereeri: —¿Casaara nio pueya niquiniu paniya Pueyaso cumaacata miishanoni? Seetanujuanaa nia sequeyanijia, majaari cua niquitiniu quiniutianiya niajaniya cua cumaacata cua miishano. ");
INSERT INTO arlNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jiyacaritij, cuno pojori tiujiaqueeri. Na pueyata botejinia tacataarohuari. Caminia taquijiria niuutiaareeri. ");
INSERT INTO arlNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesu pueyari na coseyaca niyajetatuquiaari. Nareja niquiriyatujua panniyojua jiitiaturiquiaa botejiniaari. ");
INSERT INTO arlNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jiyacaritij, Jesuuri nojori sequeriquiaa miriqui: —Cua tojitiare. Niocua tama nia cuaqueyajaaja cojuariquia Fariseocuaca pan poreetajaacuaji, Herodes pan poreetajaacuajijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Majaari na pueya niishiniu quiriquiaa naa Jesu sequesacaritij. Nojoriiri cunora tama sequetooriquiaajaaja: —Pa jiyaniijia jiyoteeri naa pa sequeya, coseyaca pa paaquiniuucua pa sasocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesuuri na saquiriojosano pueya niishiriojosano niishiquii. Nojori sequereeri: —¿Casaara naa nia niishiriojiya pan nia jiitiaaquishacarini? ¿Majateeri juhuanojuaja nia niishiniu tamonu juuca cua miishanojiniji? ¿Niaateeri cumajiuujiaacato, maja nia niishiniuria? ");
INSERT INTO arlNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Majateeri cua miishano nia niquiniu quiquiaacuaja nia namijiata? ¿Majateeri nia tojiniu quiquiaa nia numaatajuhuaj? ¿Niaateeri ritia niyajetarucuaa cua miishano? ");
INSERT INTO arlNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Janiya jaara cinco pan neecasecanu cinco mil pueyaratej, ¿taa canaasatu nia mishinijiocanu miaquesano cureenotani? Nojoriiri na riucuaree: —Doce. ");
INSERT INTO arlNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Naajuhuaj, janiya jaara siete pan neecaserucuaa cuatro mil pueyaratej, ¿taa canaasatu nia mishinijiorucuaani? Nojoriiri na riucuaree: —Siete. ");
INSERT INTO arlNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Naaratej, Jesuuri nojori sequeree: —¿Majateeri juhuanojuaja nia niishiniu naa cua miishanojinijitij? Jiyacariti nojoriiri Jesu sequesano niishiquii. ");
INSERT INTO arlNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na nuhuaji, Jesuuri Betsaida tiacajinia tiuquiijioquiaari na pueyata. Tii na quishacari, Jesuucua jaatucusaaquiaariiri cariyojuaru pueyano. Pueyari Jesu secojotuquiaari cuno cariyojuaru namijia na quianura quenaaja. ");
INSERT INTO arlNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesuuri cariyojuaru quiaree na juaashiquiajiniji. Tiaca jiyaquiria na jaatucuyareeri. Cariyojuaru namijia piquiojoree na riacautaari. Na nuhuaji, na juaashiquia niaree nocuaari. Na nequesotareeri: —¿Quia naatate niquiniu shiitianiyojua quenaaja? ");
INSERT INTO arlNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Cariyojuaruuri niquiniu sanirii. Jesu sequereeri: —¡Jaa! ¡Pueya niquiyanijia, juhua nacuhua rucoyano! ");
INSERT INTO arlNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesuuri socua pacuterohua na juaashiquia nianu cariyojuaru namijiaacua. Cariyojuaruuri niquiniu saniriohuacuhuaj. Jiyacaritij, tojetaarucuajanaa maninia niquijiara quiquiiri. ");
INSERT INTO arlNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesuuri na tiajinia na jiyarorohua. Cariyojuaru rootaree naari: —Majaari tiacajinia quia quianuhua pueya quia pohuatanura cua miishanojiniji quiajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na nuhuaji, Jesuuri quiojoquiaari na saquiriojosano pueyata tucuaqui tiacajiniara Cesareya Filipo tiaca shocuaqueya. Na quiasacari nucuaco, na pueya nequesotareeri: —¿Taa pueya sequequiaa janiyani, cantena janiyani? ");
INSERT INTO arlNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nojoriiri na riucuaree: —Noojiaqueya pueyari quia sequequiaa, quiaanaari Tiuquinijiona Juan. Tamasacaari saniniuujia quia sequequiaacujua quiaanaari supuetana Elías. Naajuhuaj, tamasacaari quia sequequiaa, quiaa naasucuanaari tariucuacaanu pueyara Pueyaso sequesano caminiujiunia, samiitianohuatuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na nuhuaji, Jesuuri nojori nequesotaree: —¿Niajaniyarijiataj, taa nia sequeyani, cante janiyani? Pedroori na sequeree: —Quiajaniyacuaja Cristo, Pueyaso Jiyarosano. ");
INSERT INTO arlNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesuuri nojori rootaree maja nojori pohuatanura tamasaca niquiara nojuajiniji Pedro niishishano. ");
INSERT INTO arlNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jiyacaritij, Jesuuri na pueya niishitiojonu coteequiaari tama nojuajinijijiaaja, taa Pueyaso Niyanu miishaanutaniya jiyanohua naquiya taraatiani. Naa na pueya sequereeri: —Parta Israel pueya jiyaniijianucuaari cua tojitiaaquiniutianiya, pueyacuara Pueyaso secojonaa jiyaniijianucuajuhuaj. Naajuhuaj, Moisés Rootasanojiniji niishitiojonaari cua rerequetejaca quiniutianiya. Janiyari mosaanutaniyani. Na nuhuaji, janiyari jiuujianaraca juucajinia samiitianutaniuhuani. ");
INSERT INTO arlNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesuuri naa seetanujuanaa nojori sequequiaari. Na pohuatasanoori maja miriqui na quiniu quiquiaari. Jesu jaara naa sequequiaari, Pedroori tamocora na jaatucuree. Cuniqui na nacasureeri maja naa na pocuanuratej. ");
INSERT INTO arlNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesuuri na nijiniara tacatequee saaja. Na saquiriojosano pueya na niquiniutia, Pedro sequereeri: —¡Cua shuriucuaji quia quiaare, Satanásnaa! Quia niishiriojosanoori maja Pueyasojiniji. Majaari quia niishiriojonu juhua Pueyaso panishano. Quiaari saaja juhua nio jiyajinijinio pueya niishiriojiya. ");
INSERT INTO arlNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Naa na sequenu nuhuajitij, Jesuuri na saquiriojosano pueya piirii, puetunu cuniqui quiniaa pueyajanaanio. Nojori sequereeri: —Pueyano jaara cua tojijiara quiniu paniri, nojuaja cuaara niiria cucua, seetanujuanaa noojiata na panishacari janiya. Nojuaja cuaara niyajetaara tama na cuaqueya na cojuanurajaaja. Cuaara cucuara panitiaara tama na cuaqueyajaaja. ");
INSERT INTO arlNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Saniniuujia, cante tama na cuaqueyajaaja shuquiritiniu panijiani, na nuhuaji, nojuajaari jiyanohua taraatia quiniutianiya pueyaracaanu. Saniniuujia, cante tama na cuaqueya panitiaa cua panishano na miiniuriani, na pohuatanura janiyajinijijiuhuaj, cuno pueyano cutaraari pueyaracaanu quiniutianiya shuquiriaatia. ");
INSERT INTO arlNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Niaarate maninia, pueyano jaara puetunu nio jiya casamijianaa jiitiare, na nuhuaji na sohuanu jaara jatasaare mani quiquiojinia pueyaracaanura? ");
INSERT INTO arlNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Pueyanote na naata Pueyaso niquitionu queraatia na casamijinijinio, Pueyaso jiyatenuhuara nojuaja pueyaracaanu rishijia na quiniuria nata? Maja na naata. ");
INSERT INTO arlNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Cante cua rupaa pohuatanu caririquiya sesa miijiaca pueya niquiara nio jiyajiniani, janiyari nojori caririquiniutianiyajaacuhuaj. Naajuhuaj, cante caririquiya mijiria quiniaa niquiara sequenurani, janiya nojori jiyaniijiani, janiyari cua tacatesacariuhua nojori caririquiniutianiyajuhuaj. Janiyari jiyacari cua Que cumaacata jiyocuacaanuji tacatenutaniuhuani, maninia miijiaca cua Que seyatajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesuuri nojori sequequiaarijiuhuaj: —Seetanujuanaa nia sequeyanijia pueyanaa. Noojiaqueya niya quiniaajinijinio quiarijiani, majaari nojori cusonuunu quiniutianiya juhuanojuaja, nojori cuaara niquirijiaatijia Pueyaso cumaaca tiuquiyano cucua, na muerasu jiitiariquianoni. ");
INSERT INTO arlNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis juuca nuhuaji, Jesuuri jiyaconaja tuhuananuucua tacaquiaari. Saaja nata quiojoquiaariiri Pedro, Santiago, Juannio. Jesu quishacari tuhuananujiniji, na cuaqueyari tamaatiuucuara jataquiaari nojori niquiara. ");
INSERT INTO arlNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na toqueeri shacantuquera jataquiaari, socua jiyanohua cohuajara sohuanatuujiniji. Nio jiyajinia toqueya jeequejonaari maja na naata jiyanohua cohuajaquera toque na jiyatenu, taa Jesu toque jataquiaaricuaani. ");
INSERT INTO arlNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jiyacaritij, nojoriiri supuetana Elías niquitiuquiaari, supuetana Moisésjuhuaj, Jesuta pocoojiyano tii. ");
INSERT INTO arlNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jiyacaritij, Pedroori Jesu sequeree: —Niishitiojonanaa, ¡canaa namitia niya quiyani! ¡Canaacua niaacuaji suhuorojoreni: quiara, Moisésra, Elíasranio! ");
INSERT INTO arlNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jesu pueyari shiriiquitiuriquiaa. Nocuaji Pedroori naa juhuajaniya pocuariquiaa. Majaari na niishiniu quiriquiaa casaa na pocuariquiaani. ");
INSERT INTO arlNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jiyacaritij, jiyocuacaanuji cohuaja najacaari nojoriicua rosequiaari. Cohuajaari nojori mishiquiomaa. Cohuaja najacajiniji, Pueyasoori tojishaaree pocuaano. Naa sequequiaaritij: —¡Niocuaja cua Niyanuniyojua, cua shuquiritiasano! ¡Saaja nojuaja nia tojiri! ");
INSERT INTO arlNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jiyacaritij, nojori jaara ritia niquinijionuuquiaari na shocuaqueya, majaari quenaaja tamonu na niquitiuniu quiquiaari socua. Saaja Jesuuri tamajaaja quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nojori rosetasacariuhua tuhuananuucocoji, Jesuuri nojori rootaquiaari maja nojori pohuatanuhuara tamasaca niquiara nojori niquishano. Jesuuri nojori sequequiaari cuaara noojiajinia racatatuura, nojuaja jaara samiitiarohuajaatijia. ");
INSERT INTO arlNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Cunora, tama nojorijiaarijia maninia racataquiaari noojiajinia nojori niquitiushano. Maja cutaraari nojori niishitiuniu quiquiaari, casaara naa Jesu sequeree nojorini “cua samiitiasacariuhua”. ");
INSERT INTO arlNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Cunora, nojoriiri Jesu nequesotaquiaari: —¿Casaara Moisés Rootasanojiniji niishitiojonaa sequequiaacuaraarini, Elíasna coteenu tiuquiniutianiuhua Pueyaso Jiyarosocoriquianoocuaji? ");
INSERT INTO arlNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesuuri nojori riucuaree: —Seetanujuanaacuaaquiniatejaj, Elíasri coteenu tiuquiriquiano quiquiaari, puetunu cucuaji jeenucuariquianojuanaa. ¿Niaate niishiya casaara tariucuacaanu Pueyaso Rupaajinia naa naajiotasaaquiaari janiyajinijini: “Pueyaso Jiyarosanoori naquiya miishaanutaniya? Pueyari na soonutaniyajuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Janiyari seetanujuanaa nia sequeyani, Elíascuajaari tari niquiaari. Pueyari naquiya na miiquiaari taa nojori paniquiaaricuajani. Pueyaso Rupaajiniacuajaari naajiotasaaquiaari nojuajaari naa miishaanutaniyaquij. Seetanujuanaa tari naa miishaaquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na nuhuaji, Jesu jaara tacatequiaariuhua na saquiriojosano pueya quishaqui, queraatia pueya niquishuhuari nojori shocua maano. Tii quitiuriquiaajaariuhua Moisés Rootasanojiniji niishitiojonaa. Nojoriiri Jesu pueyata juayonuutariquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pueya jaara Jesu niquitiuquiaari, puetunu pueyajanaari nocuaji jiuujiatequiaari. Nojoriiri nocua netecuatuquiaari na saruhuatanura. ");
INSERT INTO arlNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesuuri na saquiriojosano pueya nequesotaree: —¿Casaajiniji nia juayonuutariquiaa cuno pojoritiani? ");
INSERT INTO arlNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tamonu cuno pueyajinijinioori Jesu riucuaree: —¡Niishitiojonanaa, quiocua nitiaaree quiyanunijia! ¡Samaru jiitiaano! ¡Samaruuri na jiyatequiaari tiquiara! ");
INSERT INTO arlNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tiquiyocua na quishaqui, samaruuri na pojotequiaa. Naa na cusojosacaritij, cushau jataquiaa na rupaamajiiri. Na quiaca miaquequiaajaariuhuaj. Na nuhuaji, pootia maquiaari juhua macu. Quiyanuuri cunora sasacara quiyaree. ¡Socua piriuquiuniutianiyari! Janiyacuajaari tari sequeree quia pueyani, nojori tohuatenura cuno samaru nojuajiniji. Nojoriiri maja na naata na tohuatenu quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jiyacaritij, Jesuuri naa sequeree: —¡Niaaqui Pueyasoocua tiuyashijiacaja! ¿Janiyatucua pueyaracaanu nia jiitiariquiani? ¿Janiyateeri pueyaracaanu nia rejeretanutaniyajaaniuhuaj? ¡Miji nia jaatucure cuno caya samijia! ");
INSERT INTO arlNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nocua jaatucusaareeri caya samijia. Samaru niquishacari Jesu, caya samijia miirii taraatiaari. Caya samijiaari pojoquee Jesu niquiara. Tii taquiriocuariquiaari. Na rupaamajiiri cushaariquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesuuri caya samijia que nequesotaree: —¿Taacari na coteecanu naa na quiniuria juhuacatecarani? Na queeri Jesu riucuaree: —Na naatujuajiniji naa quijiajuhuanajaj. ");
INSERT INTO arlNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na cusojuanura juucua, cuno samaruuri sequeyarucua na pojotequiaa manijinia, moojiniajuhuaj. Naaratej, ¡jaara quia naata quiri, canaacua quia taraajere quenaaja! ¡Canaa quia naacure! ");
INSERT INTO arlNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesuuri na sequeree: —¿Casaara naa quia sequeree janiyani, “jaara quia naata quiri”? Cante Pueyasoocua tiuya noojiata seetanujuanaani, nera miishiyari puetunu na panishanojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jiyacaritij, caya samijia queeri nacaree: —¡Jaa, quiocua tiuyanijia! ¡Cua naacure socua cua tiuuniuria quiocua! ");
INSERT INTO arlNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu niquishacari queraatia pueya nocua rerequeejiyano, ritia samaru sequereeri: —¡Tojiyashijia, tiquia samarunaa, janiya quia sequeyani, quia tohuatare nio caya samijiajiniji! ¡Puetunu quia tohuatarejanaa! ¡Majaari socua quia tacatenuhua, nocua quia tiuquiniuhuara! ");
INSERT INTO arlNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Samaruuri sariyocuaquee. Caya samijia taquiriocuaterohuariuhuaj. Na tohuatesacari caya samijiajiniji, juhua macu na tiujiaqueeri. Nocuaji, queraatia na niquitianaa pueyari sequequiaari: —¡Juaj! ¡Tari cusoquee cutaratej! ");
INSERT INTO arlNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesuuri na juaashiquiajiniji na quiaree. Na sanareeri. Caya samijiaari juhuajaniya nujuaquiaariuhua. ");
INSERT INTO arlNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na nuhuaji, Jesuuri tiaco tiuquitiaquiaari na pueyataja. Tamajaaja nojori quishacari tii, na saquiriojosano pueyari na nequesotaree: —¿Casaara maja canaa naata cuno samaru tohuatenu quiriquiaani? ");
INSERT INTO arlNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesuuri nojori riucuaree: —Jiyano samaruuri na naata tohuatanishaanu cutara saaja jiyanohua Pueyaso nia secojonuta nia miaqueyaquiniutia. ");
INSERT INTO arlNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nojori jaara quiojoquiaariuhua tiji, Galilea jiya tajimiaari. Majaari Jesu paniniu quiquiaari pueya niishiniuria tee na quiyani. ");
INSERT INTO arlNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jesuuri jiyacari saaja na saquiriojosano pueyata quiniu paniriquiaa. Jiyacari, nojori niishitiojoriquiaari. Naa nojori sequereeri: —Janiyari pueya niquitiosaanutaniyani, nojori miiniuria janiya taa nojori paniyacuajani. Nojoriiri cua monutaniya. Jiuujianaraca juucajinia, janiyari samiitianutaniuhuani. ");
INSERT INTO arlNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Majaari quenaaja na pueya niishiniu quiriquiaa Jesu sequesano. Nojoriiri saaja puereriquiaa maninia na nequesoreenura casaa naa na sequenu paniriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nojoriiri Capernaum tiacajinia tiuquiijiosee. Tari nojori quishacari tiajinia, Jesuuri nojori nequesotaree: —¿Casaajiniji nia juayonuutariquiaa nucuamajini? ");
INSERT INTO arlNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nojoriiri saaja sanaajetaquee. Na juayonuutanujiniji niishitiuriquiaacuajaari. Nucuamaji, nojoriiri riutioconeetariquiaa teyano nojorijinijiniote socua tojishano pueyanoni. ");
INSERT INTO arlNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesuuri jiyacari cajirii nojori na rootanura. Na doce pueya piiriiri. Nojori sequereeri: —Cante socua tojishano pueyanora quiniu paniyani, nojuaja cuaara quiiria juhua serura, narta pueya na naacunura puetunujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na nuhuaji, Jesuuri mueya nujuatequiaari nojori tajinia. Cuno mueya paree nojori niquiaraari. Na pueya sequereeri: ");
INSERT INTO arlNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Cante jiyano mueya maseja na paniniutia janiyani, nojuajaari cua maseyajaacuhuaj. Cante cua maseyani, majaari saaja na masenu janiya. Jiyocuacaanu Quijia cua Jiyarona maseyajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tamacari, Juanri Jesu sequeree: —¡Niishitiojonanaa, canaari tamonu pueyano niquiriini quia sesa jiyaniquiyano samaruhua na tohuatanijionura pueyajiniji! Nojuajaari maja pajaniyajinijinio. Nocuaji, ¡canaari na tenujureeni maja socua naa na miiniuriatej! ");
INSERT INTO arlNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesuuri nojori sequeree: —¿Casaara nia tenujureeni? Pueyano jaara maninia miishano miiri cua sesa cumaacata, na nuhuaji, nojuaja maja na naata sesa pocuanu janiyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nia niishiri, cante maja pa paracani, nojuajaari pa jiyano. ");
INSERT INTO arlNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nia rucuanejosacari, cante nia raateya mohuacaniyojua na paniniutia janiyani, cua pueya nia quiniuucuajuhuaj, Pueyasoori saniniuujia maninia casaa na niquitionutaniya na jiitiasanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Nio mueyari cucua tiuujia. Cante jiyano mueya miitirii sesani, nera maara socua maninia quiri, puereetujuajau saajia jaara morotasaare na riquiajiniji, caminia queronijinia jartasocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Nio miriqui cua niishitiojosano nia tojiri: tama nia juaashiquiajaaja jaara nia jiyatere sesa miijiara, nia juaashiquia nia rashiquiare juhuari niaa mariqui mani quiquiojinia jatasaareeri, sesa miijia nia quiniuucua. Cuno mani quiquiojiniani, majaari mani maquesanu. ¿Niaateeri paniya tii nia jatasaanura caapiquiquiojuata? Jiyanohua socua maninia cutaraari niaara, juaashiquiaaju nia tiuquinishaanura Pueyaso shuriucua, pueyaracaanu shuquiriaatia nia quiniuria nata. ");
INSERT INTO arlNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Naajuhuaj, nia niohuaca jaara nia jiyatere sesa miijiara, nia rashiquiarenoj maja nia jatasaanura mani quiquiojinia. ¿Niaateeri paniya tii nia jatasaanura caapiquiniocuata, pueyaracaanu tii nia saniitiosaanura? Jiyanohua socua maniniaari niquiniocuata Pueyasoocua nia tiuquiniuria, pueyaracaanu nata nia quiniuria shuquiriaatia. ");
INSERT INTO arlNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Naajuhuaj, nia namijia jaara sesa miitiriquia niajaniya, nia jiaterenoj. Naa nia tarinitiare sesa nia miiniu, maja nia jatasaanura caapiqui namijiata pueyaracaanu mani noshishaqui. Sesa miijiacaari cuno mani quiquiojinia quejoosaanutaniya, pueyaracaanu nojori saniitiosaanura. Cuno manijinia, majaari porohua cusonuunu. Maniiri tii pueyaracaanu noshiya. Majaari na maquesanu. Jiyanohua socua maniniaari nia tiuquiniuria Pueyasoocua niquiriyatujua namijiata pueyaracaanu shuquiriaatia nia shootianura nojuaja. Naa Jesu niishitiojosacari miriquitij, nojuajaari pueya niishitiojoriquiaa nojori tarinitianura jiyanohua na miiniu panishano, cuno jaara sesa miijiara jiyateriquia nojori. ");
INSERT INTO arlNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jesuuri socua niishitiojorohua: —Puetunu Pueyaso muerasujuanaari saniniujiushaanutaniya juhua manitia, taa shu caquishiyacuaani na moqueyaquiniuucuaji. ");
INSERT INTO arlNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Naajuhuaj, shoniiri jiyanohua maninia, shu moqueyaquiniuucuaji. Saniniuujia, shoni jaara shaacara quiri, ¿maatucua taa tiquiriiquiara quiriohua saajaniuhuaj? Maja na naata. Naajuhuaj, Pueyaso cumaaca nia jiitiare nioojiajinia, niaa mariqui najuhuana quijia quiriiri juhua Pueyaso niishiyashijia pueya. Naajuhuaj, jiyanoojiaca nia quiri, jatiqui nia quiniuria shuquiriaatia. ");
INSERT INTO arlNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Na nuhuaji, Jesuuri Capernaum tiacajiniji quiaquiaari na saquiriojosano pueyata. Judea jiyajinia quiojiyareeri, Jordán moo taquijiriajuhuaj, pananu muetasamaji jiyajinia. Pueyari jati nocua rerejoquiaariuhua Jesu quishaqui. Jesuuri nojori niishitiojonu coteeree socua, taa na niishitiojoquiaari tarijiacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jiyacaritij, noojiaqueya Fariseocuacaari Jesuucua nijioquiaari na saniniujiuniuria nojori nequesotanuta, nocuara nojori saquiriojotanura juucua. Cunora, cuno pojoriiri Jesu nequesotaree: —¿Maniniate pueyano cartenura necocua? ");
INSERT INTO arlNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesuuri nojori nequesotaree saniniuujia: —Cua sequeretoj, ¿taa Moisés sequequiaari niajaniyani? ");
INSERT INTO arlNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Cuno pueyari Jesu riucuaree: —Moisésri pa sequequiaaricuaja, pueyanoori na naata necocua cartenu. Neyaca cuaara coteenu na niquitioora na cartetaja naajionee, necocua na cartenura. Moiséscuajaari naa pa sequequiaaritij. ");
INSERT INTO arlNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesuuri cuno pojori sequeree: —Moisésri naa sequequiaari niajaniyatej, pueyaracaanu cumajiuujiaaca nia quiniuucua, nia niquiocuaacua taraajeyashijiaca nia quiniuucuajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Saniniuujia, Moisésri naa naajiotaquiaari pueyajiniji: “Pueyaso jaara puetunu casaajanaa shipiniquiaari, nojuajaari niquiriyatu caya shipiniquiaari, niquiriyatu maajinio”. ");
INSERT INTO arlNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Naaratej, pueyanoori na queya tiujianutaniya necocuara na caminiuria. ");
INSERT INTO arlNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nojori jaara camitioore, nojoriiri juhua niquiriyatujua pueyanora quiquii. Naacuajitij, nojoriiri maja juhua caapiqui pueya na quiniu tari. Saaja juhua niquiriyatujua pueyano quiyari. ");
INSERT INTO arlNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cunora, pueyano cuaara necocua carteyaquiiria, Pueyaso rupuetootesano nojori quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Majaari Jesu saquiriojosano pueya niishitiuniu quiquiaari naa Jesu sequesano. Na nuhuaji, tiajinia nojori quishacariuhua, na saquiriojosano pueyari Jesu nequesotaquiaari casaa na sequenu paniriquiaa naani. ");
INSERT INTO arlNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesuuri nojori sequeree: —Cante necocua carteya tamonu maajitia na caminiuriani, cuno pueyanoori jiyanohua sesa miya coteenu necocua. Pueyasora, naa na miishacaritij, nojuajaari juhua narta pueyano niquiocuata quijia. ");
INSERT INTO arlNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Naajuhuaj, maaji jaara cartere neyaca tamonuta na caminiuria, cuno maajiiri sesa miya Pueyaso niquiarajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na nuhuaji, Jesuucua jaatucunuusaaquiaariiri naatujoori, Jesu nianura na juaashiquia nojori nacaacua. Na saquiriojosano pueyari naatujoori jaatucunaa tenujuriquiaa saaja. ");
INSERT INTO arlNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesu jaara na niquiquiaari, juaaquiiri. Nojori sequereeri: —¡Nia tarinitiare naatujoori cuaara niiria cucua! ¡Maja na tenujunu! Canapuete Pueyaso muerasura quiniu paniyani, nojori cuaara juhua nio naatujooriria jataara. ");
INSERT INTO arlNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Seetanujuanaa nia sequeyanijia, Pueyasoocua nia tiuuri seetanujuanaa, taa naatujoori tiuya cucuacuaani na taacanuyaquiniutia. Saaja naacuajiti niaari Pueyaso pueyara jiyatesaanutaniya cutara, pueyaracaanu Pueyaso jiitiasano nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesuuri jiyacari cuno naatujooriniyojua pooree. Nojori nacaacua niojoree na juaashiquiaari Pueyaso na secojonuta, Pueyaso miiniuria maninia nojori. ");
INSERT INTO arlNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Quera Jesu quianu panishacari quiniquiji, nocua netequiaariiri tamonu pueyano. Jesu cariquimiaji mojoquetaseeri. Na nequesotareeri: —Maninia niishitiojonanaa, ¿taa cua miiniutianiyani, seetanujuanaa Pueyaso pueyanora cua quiniuriani? ");
INSERT INTO arlNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesuuri na sequeree: —¿Casaara quia sequeya janiya maninia pueyanotani, quia niishiyaquishacari janiyani? Saaja Pueyaso cutaraari seetanujuanaa maninia. ");
INSERT INTO arlNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Quiaacuajaari Pueyaso niishitiojosano niishiya. Moiséscuajaari naa na naajiotaquiaari: “Maja quia camishoo maaji quia numuetucunu. Maja monu. Maja nohuasenu. Maja tamonuucuara tonujunu sapojonuta. Maja cuaracashijionu. Quia queya tojijia quia quiriquia”. ");
INSERT INTO arlNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Pueyanoori Jesu riucuaree: —Niishitiojonanaa, janiyacuajaari puetunu cuno rootasanojuanaa tojijia pueyaracaanu cua naatujuajinijini. ");
INSERT INTO arlNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesuuri na paniniutia na niquirii. Na sequereeri: —Juhuanojuaja niquiriyatu casaari quiyajaa quia miishoo. Quia quiaarohua. Puetunu quia casamijianaa quia niquitiojocoo. Na nuhuaji, casamiijiuniucua nareja quia niquitiore quia masesano cumaneeca quia casami sami. Naacuajitij, quiaari quia casami jiitianutaniya jiyocuacaanu Pueyaso shuriucua. Na nuhuaji cutara, quiocua nimiohua cua nuhuajiriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cuno pueyano jaara tojiquiaari naa Jesu sequesanotej, jiyanohua taraajequeeri. Na taraajenuta quiacuhua na tiajiniaari. Nojuajaari jiyanohua casamiriaca pueyano quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na nuhuaji, Jesuuri na shocuaqueya niquinijioree. Na saquiriojosano pueya sequereeri: —¡Jiyanohua jiyajeneta cutaraari casamiriaca pueyano quiniuria Pueyaso pueyanora! ");
INSERT INTO arlNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na saquiriojosano pueyari shiriiquitiuquiaari naa na sequesacaritij. Na nuhuaji, Jesuuri nojori sequenu pacutequiaari: —Sanajooriniaa, seetanujuanaa nia sequeyanijia. Jiyanohua jiyajenetaari casamiriaca pueyano quiniuria Pueyaso pueyanora. ");
INSERT INTO arlNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Taa camello maja na naata cusupuetaja cuhuoco tamajiria tajiniucuaani, naajuhuaj, casamiriaca pueyanoori maja na naata tama na cuaqueyajaaja jiyatenu Pueyaso pueyano na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na saquiriojosano pueya jaara na tojitiaquiaari, nojoriiri socua jiyanohua jiuujiateree. Naaratej, tama nojorijiaarijia nequesoreetooquiaari: —¿Canteeri Pueyaso pueyanora jiyatesaanutaniya socuanitioj? ");
INSERT INTO arlNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesuuri nojori niquirii. Naa sequereeri: —Pueyano maja na naata tamajaaja Pueyaso pueyanora quiniu. Pueyaso cutaraari na naata na jiyatenu na muerasura. Pueyasora, maja jiyajeneta casaa quiniu. ");
INSERT INTO arlNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedroori Jesu sequeree: —Jiyaniijianaa, canaari puetunu canaa jiitiasanojuanaa tiujiaquiaarini quia pueya canaa quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jesuuri nojori riucuaree: —Seetanujuanaa nia sequeyanijia, shuquiriaatia quijia quiniutianiya cutaraari noo pueyano cante na jiitiasano tiujiaja cua tojijia na quiniuucuani, janiyajiniji pohuatana na quiniuucuajuhuaj. Cante na tia tiujiajani, tapueyocuaca, na rimiatuhua, na queya, necohua, na cuhuariquianio, nojuajaari maninia miishaanutaniya quiarijia mijiria na quishacarijia. Nojuajaari socua jiyanohua queraatia niquitiosaanutaniuhua na tiujiasanojiniji. Niquitiosaanutaniyari tiaca, tapueyocuaca, na rimiatuhua, na nucua, necohua, cuhuariquianio. Naajuhuaj, naquiya miishano quiniutianiyari cua tojijia na quiniuucua. Naajaa, na nuhuaji, pueyaracaanu Pueyasota shuquiriaatia quiniutianiyari quiarinio jiyajinia. ");
INSERT INTO arlNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Saniniuujia, queraatia tojishano pueyari najuhuana quijiaca quiniutianiya Pueyasora, nojori tojiyaquiniuucua nojuaja. Saniniuujia, Pueyaso ruuretajacara, queraatia Pueyaso pueyari quiarijia juhua najuhuana quijiaca niquishano quiquiaa. Naajaa, nojoriiri na nuhuaji seetanujuanaa juhua jiyaniijianucua quiniutianiya Pueyasora, na tojitiajaca nojori quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalén tiacajiniara nucuamaji nojori quiasacari, Jesuuri na saquiriojosano pueya puetariquiaa. Nojoriiri na nuhuaji sacuariquiaa na puerenuta. Socua pueyari na nuhuajitiuriquiaa nojori puerenutajuhuaj. Nuu cajiniocua, Jesuuri na doce saquiriojosano pueya jaatiaree tamocora tamajaaja. Tii nojori sequeriquiaari taa nojuaja miishaanutaniyani, nojori tiuquishacari Jerusalén tiacajinia. ");
INSERT INTO arlNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nojori sequereeri: —Niaacuajaari niishiya, paa tari Jerusalén tiacajinia quiaani, tee cuniqui Pueyaso Niyanu niquitiosaanutaniya pueyacuara secojonaa jiyaniijianucuani, Moisés Rootasanojiniji niishitiojonaanio. Cuno pojoriiri cucuara tonujunutaniya jiyaniijianucua na sapojonuta, cua mosaanura. Janiyari taucuaca niquitiosaanutaniyani. Janiyari jiyanohua naquiya miishaanutaniyani. ");
INSERT INTO arlNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nojoriiri cua rerequetenutaniya. Cua riocojotunutaniyari. Cua piquitiuniutianiyajaariuhuaj. Naa cua miishaanu nuhuajitij, nojoriiri socua cua monutaniya. Naajaa, jiuujianaraca juucajinia, janiyari seetanujuanaa samiitianutaniuhuani. ");
INSERT INTO arlNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na nuhuaji, Santiagoori, tarajanu Juanta Jesuucua catecanoquiaari. Nojoriiri Zebedeo niquiohua quiquiaari. Jesu sequetuseeri: —Niishitiojonanaa, canaara quia miiri canaa masenu panishano quiajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesuuri nojori nequesotaree: —¿Casaa nia paniya cua miiniuria niaarani? ");
INSERT INTO arlNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nojoriiri Jesu riucuaree: —Pueyaso jaara quia jiyatere pueya jiyaniijiara, quiocua canaa cajitijiore quia shuriucua, tamonu quia miaquetajara, tamonu quia muenecara, quia naacunaa canaa quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesuuri nojori sequeree: —Majaari nia niishiniu nia masesano. ¿Nia naatateeri rejeretanu naquiya miiniu taa cua miishaanutaniyacuaani? Naquiya cua miiniuuri jiyanohua noonu quiniutianiya juhua pueyano jaara mani noshiyanojinia tiuquinishaare. ");
INSERT INTO arlNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nojoriiri na riucuaree: —Taaquiriirinij, canaa naatacuaaquiniateja naquiya miiniu rejeretanu juhua quiajaniya. Jesuuri nojori sequeree: —Seetanujuanaa, niaari na nuhuaji cua ratusano raturiquianojuhuaj. Niaari juhua manijinia tiuquinishaariquianojuhuaj, taa cua tiuquinishaanutaniyacuaani. Jesuuri naa nojori sequeriquiaa miriqui, taa jiyanohua naquiya na miishaanutaniyani, na cusosacari pueyacuara. Jesuuri naa nojori sequeree socuatej: ");
INSERT INTO arlNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","—Maja cutara cua naata niquitionu niajaniya nia masesano, cua cajitiniuria niajaniya cua miaquetajara, cua muenecaranio. Cunoori noo pojori niquitiosaanutaniya cutara, canra tari na jeenucuasaaquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Narta saquiriojosano pueya jaara tojiquiaari nojori masesano Jesu juucua, nojoriiri juaaquioquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesuuri nojori piirii. Nojori sequereeri: —Niaacuajaari niishiya, mijiria jiya jiyaniijianucuaari na pueya jiitiaquiaa juhua na seya, tama nojori panishano na miiniuriajaaja nojoritia. Naajuhuaj, pueya jiyaniijianucuaari na jiitiasano pueyacua paaretaquiaa na cumaaca, tojishano pueya nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Niajaniya saniniuujia, majaari naa nia quiniu quiniutianiya. Cante tojishano pueyanora quiniu paniya niajaniyajinijinioni, cuno cuaara jiyateera tama na cuaqueyajaaja juhua narta Pueyaso pueya serura na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Cante nia jiyaniijia quiniu paniyani, nojuaja cuaara quiiria narta Pueyaso muerasu cumaquinia. ");
INSERT INTO arlNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Janiyajuhuaj, majaari mijiria cua niniu quiquiaari pueya cua poonijiotenura quiria, tama cua cuaqueya cua shuquiritiniuriajaaja. Janiya cutaraari niquiaarini pueya cua naacutanura, tama janiyajaaja mosaanura pueya niti, queraatia pueyacuaji cua ritianura Sesaaca. ");
INSERT INTO arlNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nojoriiri jiyacari tiuquiijioquiaari Jericó tiacajinia. Jesuuri cuno tiacajiniji quiariquiaa na saquiriojosano pueyata. Queraatia pueyari nata quiariquiaajuhuaj. Jiyacaritij, tamonu cariyojuaru pueyanoori tii cajiriquiaa nuu shuucuara. Na sesa quiquiaari Bartimeo, Timeo niyanu. Nojuajaari cumaneeca mashiniquijiona quiquiaari, cariyojuaru na quiniuucua. Nojuajaari maja na naata poonijionu quijia tamajaaja. ");
INSERT INTO arlNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nojuaja jaara tojiquiaari cuno tajiyano pueyano quiquiaari Jesu, Nazaret tiacajinijinio, nojuajaari naa nacanu coteeree: —¡Jesunaa, Pueyaso Jiyarosanonaa, cucua quenaaja quia taraajereja! ");
INSERT INTO arlNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Queraatia pueyari na tenujuriquiaa na sanaajanura juucua. Saaja socua nacaree jiyanohuari: —¡Pueyaso Jiyarosanonaa, cucua quia taraajere! ");
INSERT INTO arlNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jiyacaritij, Jesuuri socua nujuasee. Pueya sequereeri: —Miji nia sequere cuno nacaani. Cariyojuaruuri naa sequesaaree: —¡Quia sanere! ¡Quia shuquiriri! ¡Quia sequeyacuaja! ¡Nocua quia canujiyare! ");
INSERT INTO arlNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Naa na tojishacaritij, cariyojuaruuri na tucuaque toque jataquee. Ritia jaaqueeri Jesuucua na catecanonura. ");
INSERT INTO arlNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesuuri na nequesotaree: —¿Casaa quia paniya cua miiniuria quiajaniyani? Cariyojuaruuri na riucuaree: —¡Niishitiojonanaa, niquijiara quiniu paniuhuanijia! ¡Cua namijia quia jeecarohua quiria! ");
INSERT INTO arlNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesuuri na sequeree: —Quia quiaarohua. Quia namijiaacuaja tari jeequerohua cucua quia tiuuniuucua. Jiyacaritij, cariyojuaruuri tari na naata niquiniu quiriquiaa. Nucuaco Jesu nuhuajiyareeri. ");
INSERT INTO arlNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nojoriiri tari catecanoriquiaa Jerusalén tiacaacua. Jiyacaritij, nojoriiri tiuquiijiosee Olivo cuhuariquia tuhuananuucua. Cunoori Betfagé tiaca shuriucua, Betania tiaca shuriucuanio. Jesuuri caapiqui na saquiriojosano pueya jiyaroree tiji. ");
INSERT INTO arlNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nojori sequereeri: —Cuno tiacajinia nia quiaare, pa tacoji niquishiyani. Niaa jaara tiuquishii tii, niaari burro riuriatanutaniya morotasano, pueyano cajishoojua na nijinia. Niaa jaara niquishiinioj, niocua na samaacartasee. Niocua na jaatucumohua miji. ");
INSERT INTO arlNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pueya jaara naa nequesotare niajaniya: “¿Casaara nia samaacartaanoj?”, niocua na sequere: “Jiyaniijia na paniya rupaquijia. Ritia na niquitionutaniuhuacuaja”. ");
INSERT INTO arlNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nojoriiri quiojoquiaari. Burro riuriatatuseeri morotasano nuujinia, tamonu tia tohuateya shuriucua. Nojoriiri na samaacartasee. ");
INSERT INTO arlNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tamasaca tii quiniaari nojori sequeree: —¿Casaa nia miyani? ¿Casaara nia samaacartaa cuno burroni? ");
INSERT INTO arlNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nojoriiri na riucuaquiaari taa Jesu rootaquiaari nojoricuajani. Naaratej, cuno pueyari nojoriria na tarinitiaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na nuhuaji, Jesuucua jaatucutumohua cuno burroori. Pueyari na toqueya niojoquiaari burro nijinia, Jesu cajijiara. Na nuhuaji, Jesuuri nocua cajirii. ");
INSERT INTO arlNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Queraatia pueyari na toqueya muejoquiaari nucuaco, Jesuucuaji nojori maniniushitiniuria nuu. Tamasacaari jaamasucua piyotaquiaari cuhuariquiacajiniji, Jesuucuaji nojori niojotasocoriquiano na nucuacojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jesu puetanaa, mariyata na nuhuaji nijionaari jiyanohua nacoojonu coteequiaari nojori shuquiriniutia. Naa sequeturiquiaari: —¡Pa shuquiritiare pa Jiyaniijia Pueyaso! ¡Jiyanohua maniniacuaja pa Jiyaniijia, cuno, Pueyaso cumaacata tiuquiyani! ");
INSERT INTO arlNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Pueyaso cuaara na jiyateera maninia Jiyaniijia na quiniuria pajaniyara! ¡Nojuajaari pa supuetanaa jiyaniijia David niti pa jiitianutaniya maninia cutara! ¡Jiyocuacaanu Quijia pa Pueyasocuajaari pa shuquiritiasano! ");
INSERT INTO arlNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesuuri naa tiuquiquiaari Jerusalén tiacajiniatej. Pueyaso Secojojua tiajinia tiuquishiiri. Na niquinijionu nuhuaji puetunu casaajanaa, Betania tiacajiniara quiaquiaari ritiaari na doce saquiriojosano pueyata. Jiyacaritij, tari tenacariiri quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tariqui, nojori quiojosacari Betania tiacajiniji, Jesuuri miaajeriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tucuacaanuji niquirii higo naanaari queraatia jaamasucuaraca. Nocua canujiyareeri na niquiniuria seetanujuanaa jajauracate quiriquiaa. Saaja queraatia jaamasucuaari quiriquiaa. Maja higo muetusacari quiquiaari jiyacari. ");
INSERT INTO arlNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesuuri naa sesacaree higo naana: —Maja quiocuaji socua quia jajau miasaanu quiniutianiya. Na saquiriojosano pueyari na tojitiariquiaa naa na sequesacaritij. ");
INSERT INTO arlNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nojori jaara tiuquiijioquiaari Jerusalén tiacajinia, Jesuuri tiuquiquiaari Pueyaso Secojojua tiajinia. Tiji pueya tohuatanijionu coteereeri, cuno pojori, canapuete Pueyasoocuara puecoosocoriquiano seya niquitiojoriquiaa cumaneecaracuajani. Na masejonaa tohuatanijioreejaariuhuaj. Cumaneeca tacatojojuaca juhuacutucua caponeetareeri, tee pueya tacatojoriquiaa taucuaca cumaneecacuajani, Pueyaso Secojojua tiajinia niquitiojosocoriquiano cumaneecaracuajani. Naajuhuaj, Jesuuri mococoonu niquitiojonaa cajitiucua caponeetaree. ");
INSERT INTO arlNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Naajuhuaj, majaari na shanacunu quiquiaari pueya niyacunura najuhuana Pueyaso Secojojua tia, na nitiootasano casamitia. ");
INSERT INTO arlNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na nuhuaji, pueya niquiara niishitiojonu coteereeri. Naa sequereeri: —Tariucuacaanu Pueyaso Rupaajinia naa naajiotasanocuajaari quiya: “Cua tia sesaari quiniutianiya, Pueyaso Secojojua tia. Puetunu jiyacajinijiniojuanaa pueya secojonuujuara quiniutianiyari”. Niaari saniniuujia na jiyatequiaari nohuasenuujuaca quiquiora. ");
INSERT INTO arlNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pueyacuara secojonaa jiyaniijianucua, mariyata Moisés Rootasanojiniji niishitiojonaari niishiquiaari naa Jesu miishanojiniji. Cunora, nojoriiri roojotooquiaari taa na motunutaniya Jesuni. Saniniuujia, puetunu pueyajanaari jiuujiateriquiaa Jesu niishitiojosano nojori tojishacari. Cunora, Judiocuaca jiyaniijianucuaari Jesu puereturiquiaa, puetunu pueyajanaa tojishacari na niishitiojosano. ");
INSERT INTO arlNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jaara niniquiaari, Jesuuri Jerusalén tiacajiniji quiacuhua na saquiriojosano pueyata. ");
INSERT INTO arlNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tariquiicuaji, nojori shocosacari higo naana, na niquitiuquiaariiri tariucua soreno, puetunu na nujuacatajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedroori jiyacari Jesu sequesano niishiquii. Jesu sequereeri: —Niishitiojonanaa, ¡quia niquiri! ¡Quia sesacasano higo naanaqui tari soreree! ");
INSERT INTO arlNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesuuri nojori riucuaree: —Pueyasoocua nia tiuuri. ");
INSERT INTO arlNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Seetanujuanaa nia sequeyanijia, niaa jaara Pueyasoocua tiuuriquia nia taacanuyaquiniutia, nia naata nio tuhuananu sequenu: “Shiiquia niiquiji. Quia jaataare shoniniacu caminiajinia”. Niaa jaara naa sequere seetanujuanaa Pueyasoocua nia tiuuniutia, niaari nia sequesano niquiniutianiya. Naacuajitij, Pueyasoocuaji nia taacanuyaquishacari, nia sequesanocuajaari tohuateenutaniya taa nia sequereecuajani. ");
INSERT INTO arlNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Janiyari cunora nia sequeyani, puetunujuanaa nia masesano nia secojosacari Pueyasoni, nia niishiri niaa na jiitiaa tari. Na nuhuaji, niaari seetanujuanaa na masenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nia secojosacari, niaa jaara niishiquii niaa sesa quiya tamonu pueyanota, sesa na miiniuucua niajaniya, nojuaja nia jiyanoori. Naacuajitij, jiyocuacaanu Quijia nia Queeri nia jiyanooniutianiya sesa nia miishanojinijijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Niaa jaara jiyanoyashijia quiriquia, jiyocuacaanu Quinia nia Queeri nia jiyanoyaquiniutianiya, sesa nia miishanojinijijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na nuhuaji, nojoriiri quiaquiaariuhua Jerusalén tiacajiniohua. Jesu rucuanejosacari Pueyaso Secojojua tiajinia, nocua catecanoquiaariiri pueyacuara secojonaa jiyaniijianucua, Moisés Rootasanojiniji niishitiojonaajuhuaj, narta Judiocuaca camarucuanio. ");
INSERT INTO arlNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nojoriiri Jesu nequesotaree: —¿Cante quia sequecanu naa quia miiniuriani? ¿Cante quia jiyatecanu Pueyaso Secojojua tia jiyaniijia quia quiniuriani? ");
INSERT INTO arlNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesuuri nojori riucuaree: —Janiya nia nequesotanutaniya saniniunijia. Niaa jaara cua nequesotasano riucuare coteenucuaa, janiyari nia sequenutaniyajuhuaj cante cua jiyaroquiaari naa cua miiniuriani. ");
INSERT INTO arlNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Cua riucuaturetoj, ¿cante Tiuquinijiona Juan jiyaroquiaari pueya na tiuquinijionura moojiniani? ¿Narejaca pueyatee, Pueyaso soj? Cua riucuature. ");
INSERT INTO arlNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jiyacaritij, cuno pueyari jiyasohuaja tama juayonuutanu coteequiaarijiaaja. Naa sequetooquiaariiri: —Paa jaara na sequereni Pueyaso na jiyaroquiaari, pa riucuarucua: “¿Casaara nocua nia tiuyaquiquianucuaraarini?” ");
INSERT INTO arlNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Paatucua taa sequereeri, nojuaja nareja pueya jiyarosano quiquiaari? Cuno pojoriiri narta Israel pueya puereturiquiaa sequenura, Tiuquinijiona Juanri nareja pueya jiyarosano quiquiaari. Nojoricuajaari niishiriquiaa puetunu pueyajanaari niishiquiaari Tiuquinijiona Juanri seetanujuanaa Pueyaso sequesano caminiujiunia quiquiaari. Cunora, nojoriiri Tiuquinijiona Juan rerequetenu pueretuquiaari, pueya quishacari tii. ");
INSERT INTO arlNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Naacuajitij, maja na naata na riucuatunu quishacari, Jesu sequetureeri: —Maja canaa niishiniu. Jesuuri nojori sequeree: —Janiyajuhuaj, maja cua sequenu quiniutianiya niajaniya, cante cua jiyaroquiaari naa cua miiniuriani. ");
INSERT INTO arlNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jiyacaritij, Jesuuri miriqui pohuatanu coteequiaari cuno pojori niquiara. Cuno camarucua sequereeri: —Tamonu pueyanoori cuhuariquiajinia uva natooquiaari. Na nuhuaji, na shuriuquioco matacoreeri. Naajuhuaj, saajia quejaquiaariiri uva rapijiojuara, na caaca reratesaanura. Jiyaconajara tiareejaariuhuaj, tiji na cuhuariquia na cojuajara nohuasejojuaacuaji. ’Na nuhuaji, tamasaca poonijionaa pueya na niquitioreeri nojori cojuasocoriquiano nera. Naacuajitij, uva carojotasacari, nojoriiri nojuaja niquitionutaniya tijijiuhuaj, na camarujuanaa na quiniuucua. Na nuhuaji, nojuajaari tucuacaanu quiaquiaari, tii marijia na shocotejonura. ");
INSERT INTO arlNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jaara tari quiquiaari uva carojotasacari, saniya cuhuariquia camarujuanaari na seru jiyaroquiaari cuhuariquia cojuanaa pueyacua. Na jiyaroquiaariiri cuhuariquia cojuanaa niquitionura nojori carojotasanojiniji, taa na camarujuanaa pocoojoquiaaricuaja nojoritia tarijiani. ");
INSERT INTO arlNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Cuhuariquia cojuanaa pueyari saaja jiyarosano seru quiaturee. Na piquitiuriiri. Na nuhuaji, juhuasu na jiyaroturohua na camarnuucuaari. ");
INSERT INTO arlNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Na camaruuri socua jiyaroquiaari tamonu na seru. Cuno seruuri jacusaaree saitia. Na nacaari surtasaaree saajiata jasano. Na sesacatureejaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na camaruuri socua jiyaroquiaari tamonu na seru. Cuno na seru cutaraari mosaaquiaari. Na nuhuaji, socua jiyaramiquiquiaari queraatia na seyari. Puetunu nojorijinijiniojuanaani, tamasacaari piquishaaquiaari. Tamasacaari puecoosaaquiaari cutara. ");
INSERT INTO arlNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Cuhuariquia camaruuri saaja niquiriyatujua niyanuniyojua jiitiaquiaari, jiyanohua na panishano. Cunora, nojuajaari socua cuno neyanuniyojua jiyaroquiaari. Na queeri tama sequequiaarijiaaja: “Cuno pueya jaara niquiri cua niyanu, nojoriiri na tojiniutianiya cutara”. ");
INSERT INTO arlNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Cuno cuhuariquiajinia poonijionaa niquishacari nojori camarnu niyanu nojoriicua niyano, nojoriiri saaja tamajaaja niishitiojotooquiaari: —¡Nioori pa camarnu niyanu! Nio cuhuariquiaari tama nerajaaja quiniutianiya, na que jaara cusoyare. ¡Pa morej! ¡Pocua nio cuhuariquia camaruhuara quiquii tamajaajani! ");
INSERT INTO arlNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","’Cunora, na quiatureeri. Na motureeri. Na motunu nuhuaji, nojoriiri macu jataree cuhuariquiajiniji tamama. ");
INSERT INTO arlNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jiyacaritij, Jesuuri cuno pojori nequesotaree: —¿Taa cuhuariquia camaru miiniutianiya socuani? Nia sequereera pueyanaa. Nojuajaari cuhuariquia cojuanaa puecoonutaniya. Na nuhuaji, tamasaca pueya niquitionutaniya cuno cuhuariquiaari, nera nojori cojuanura. ");
INSERT INTO arlNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Majateeri tariucuacaanu Pueyaso Rupaajinia nia serojonu quiquianucuaja nio? Naa sequeyari: “Tiajonaa pueyari tamaatiujiajau saajia jataree nojori tiasacari saijiniji tia. Na nuhuaji, cuno jatasano saajiaari socua cutara saajiara jiyatesaarohua tamasaca saijiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Cunoori pa Jiyaniijia miishano. Pajaniyara, na miishanoori jiyanohua maninia. Nocuaji jiuujiatesano”. ");
INSERT INTO arlNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jiyacaritij, cuno Judiocuaca camarucuaari niishiriicuaja miriqui Jesu pohuatasanoori tama nojorijinijijiaaja quiriquiaa. Naaratej, nojoriiri Jesu quiatunu panirii juucua, nojori nujuatesocoriquiano. Nojoriiri pueya puereriquiaa saaja, naa nojori miiniuria Jesutej. Naacuajitij, nojoriiri nareja quiojoquiaariuhua. Naa Jesu pohuatasacari miriqui cuno saajiajinijitij, nojuajaari tama na cuaqueyajinijijiaaja pohuatariquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na nuhuaji, Jesuucua jiyaramiquishaaquiaariiri noojiaqueya Fariseocuacajinijinio, Herodes panijiaca pueyajinijiniojuhuaj. Cuno pojoriiri Jesu pocuatenu paniquiaari sesa juucua, jiyaniijia nojori saquiriojotanura nocuara. ");
INSERT INTO arlNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Naaratej, cuno pojoriiri Jesuucua nijioquiaari. Na sequetuseeri: —Niishitiojonanaa, canaari niishiyani quiaa cutaraari sapojiyashijia. Quiaari seetanujuanaa sequeja. Majaari rimiajata quia niquiniu pueyajuhuaj. Majaari pueya naata sapojonu quiajaniya. Quiaari seetanujuanaa pueya jiuujia niquijia. Quiaa cutaraari seetanujuanaa Pueyasojiniji niishitiojojua, taate pa naata maninia quiniu Pueyaso niquiarani. Naaratej, canaa quia sequere, ¿maniniate pa niquitiojonura pa cumaneecajiniji jiyaniijia Césarra, taa cuno tahue sequequiaari pajaniyacuajani? ¿Taa quia sequeyani, niquitiojoshiyatee, maja soj? ");
INSERT INTO arlNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesuuri ritia niishiquii, naa nojori nequesotasacari nojuajatej, cuno pojoriiri na saniniujiuriquiaa sesa na pohuatenura najuhuanaj. Naaratej, Jesuuri nojori sequeree: —¿Casaara nia saniniujiya janiyani? Miji nia riri cumanee cua niquishocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nera rishaareeri cumanee. Jaara na niquiquiaari, Jesuuri nojori nequesotaree: —¿Cana naaquiti nocuani? ¿Cana sesateeri nocua naajiotasanojaniuhuaj? Nojoriiri na riucuaree: —Jiyaniijia César naaquicuaja, na sesajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesuuri jiyacari nojori sequeree: —Jaara tama César casaajaaja quiri, tama na casaajaaja nia niquitiore na camaru. Saniniuujia, Pueyaso nia niquitiore nerano tama na casaajaaja. Jesu jaara naa nojori riucuaquiaaritij, nojoriiri jiyanohua jiuujiatequiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Fariseocuaca nuhuaji, noojiaqueya Saduceocuacajinijinioori Jesuucua nijioquiaari. Saduceocuacaari jiyaniya macunucua maja na samiitiaconu quiniutianiuhua. Naaratej, nojoriiri Jesu nequesotasee nojori niishiniuria taa na sequenutaniya macunucuajinijini. Na sequetuseeri: ");
INSERT INTO arlNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Niishitiojonanaa, supuetana Moiséscuajaari pa rootaa na naajioneejinia, pueyano jaara cusoyare mueyaju, tarajanu cuaara camiiria mashiquio, mueya na mueratenura tarajanu niti. ");
INSERT INTO arlNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tarijia, tamonu pueyanoori niya quiquiaari. Siete niquiohuaraca quiquiaariiri, saa canuujua. Jiyapueranuuri camiquiaari. Na nuhuaji, shaajequiaariiri muetuhuojua. ");
INSERT INTO arlNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Naaratej, na nuhuajishanaari tarajanu mashiquio camiquiaari. Nojuajaari muetuhuojua cusoquiaarijiuhuaj. Naajuhuaj, jiyareta na nuhuajishanaari na camiquiaari. Nojuajaari juhua tapueyocuaca cusoquiaari mueyajujuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Cuno siete canuuri naa camiyoquiaari cuno maaji. Puetunu nojorijianaari cusonuuquiaari. Majaari quenaaja niquiriyatujua mueya nojori mueratenu quiquiaari. Na nuhuaji, cuno maajiiri cusoquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naacuajitij, macunucua jaara samiitiacorohua, ¿teyano cuno siete neyacaajinijiniote seetanu neyacajanaa quiniutianiyani, puetunu cuno pojorijianaa jaara neyacaa quiquiaari? ");
INSERT INTO arlNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesuuri nojori riucuaree: —Niaari jiyanohua jiyajeneya Pueyaso Rupaajinia naajiotasano nia niishiyaquishacari, Pueyaso cumaacanio. ");
INSERT INTO arlNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Macunucua samiitiacosacariuhua, majaari canuu camiyonu quiniutianiya maaji. Naajuhuaj, maajipohuari maja na camiyonu quiniutianiya neyacaara. Canuu, maajipohua, nojoriiri mariyata quiniutianiya juhua jiyocuacaanu quijiaca Pueyaso seya, maja camiyosano. ");
INSERT INTO arlNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Niaa macunucua samiitianijionujiniji nequesoreetaate. ¿Majateeri nia serojonu quiquiaacuaja supuetana Moisés naajioneejinia, taa Pueyaso sequequiaari Moiséscuaja nequeru casaja noshiyanojinijini? Pueyasoori naa sequequiaari Moisés: “Janiyari quia supuetana Abraham Jiyaniijiani, quia supuetana Isaac Jiyaniijiajuhuaj, quia supuetana Jacobo Jiyaniijianio”. ");
INSERT INTO arlNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Naacuajitij, paari niishiyani Pueyaso pueya shaajeconoori saminiucua quiya Pueyasora cutara. Pueyasoori maja macunucua Jiyaniijia, saaja saminiucua pueya Jiyaniijia cutaraari. Janiyari cunora nia sequeyani, niaari jiyanohua jiyajeneya nia niishiyaquiniuucua Pueyaso Rupaa. ");
INSERT INTO arlNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tamonu pueyanoori Jesu tojiriquiaa Saduceocuaca riuhuaneyano maninia saaja. Cuno pueyanoori Moisés Rootasanojiniji niishitiojona quiquiaari. Nojuajaari Jesuucua catecanoquiaari. Jesu nequesotareeri: —¿Teyano tariucuacaanu Pueyaso Rootasanojinijiniote socua pa tojishocoriquianoni? ");
INSERT INTO arlNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesuuri na riucuaree: —Pueyaso sequesano socua na pueya tojishocoriquianoori nio: “Nia tojitiare Israel pueyanaa, pa Jiyaniijia Pueyasoni, nojuacuajaari pa Jiyaniijiajanaa. Majaari tamonu quiniu socua. ");
INSERT INTO arlNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nia Jiyaniijia Pueyaso nia paniri puetunu nioojiatajanaa, puetunu nia sohuanutajanaa, puetunujuanaa nia niishitiajata, puetunu nia cumaacatajanaanio”. Nio rootasanoori socua pa tojishocoriquiano puetunu Pueyaso rootasanojinijijianaa. ");
INSERT INTO arlNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Socua tarajanu na rootasano pa tojishocoriquianoori quera juhua coteenu na rootasanojuhuaj. Naa sequeyari: “Quiarta pueyano quia paniri taa quia paniyacuaa tama quia cuaqueyajaajani”. Puetunu Pueyaso rootasanojinijijianaani, majaari socua tamonu rootasano quiniu socua tojishocoriquiano nio caapiqui na rootasanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jiyacaritij, cuno Moisés Rootasanojiniji niishitiojonaari na sequeree: —Quiaacuaja maninia sequeree, niishitiojonanaa. Seetanujuanaari quia sequesano: quiyacuaaquiniateja niquiriyatujua Pueyaso. Majaari socua tamonu quiniu juhua nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Seetanujuanaa jiyanohua maninia cutaraari Pueyaso pa paniniuria puetunu poojiatajanaa, puetunujuanaa pa niishitiajata, puetunu pa sohuanutajanaa, puetunujuanaa pa cumaacatanio. Naajuhuaj, jiyanohua maniniaari parta pueyano pa paniniu, juhua tama pa cuaqueyajaaja. Paa jaara nio sequesano tojijiaca quirini, cunoori jiyanohua socua maninia Pueyasora, puetunu seya catijiasanojinijijianaa nocuara, mariyata puetunu pueya niquitiojosano na casamijinijijianaa nera. ");
INSERT INTO arlNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesu jaara tojiquiaari naa cuno pueyano riucuasano maniniatej, na sequereeri: —Quiaaqui quera Pueyaso pueyanora quiya. Na nuhuaji, majaari socua pueya nequesoreetanu paniniu quiriquiaa Jesu. ");
INSERT INTO arlNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesuuri Pueyaso Secojojua tiajinia niishitiojoriquiaa pueya. Jiyacaritij, nojuajaari na tojitianaa pueya nequesotaree: —¿Casaara Moisés Rootasanojiniji niishitiojonaa sequequiaacuaraarini: “Cristonaari supuetana David niquiohuacuajinio supuenutaniya”? ");
INSERT INTO arlNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pueyaso Sohuanu pohuatesacari supuetana David, nojuacuajaari sequequiaari: “Jiyaniijia Pueyasoori cua Jiyaniijia Cristo sequeree: ‘Quia cajirijiaara cua miaquetajara, janiya cuaara quia paraa shocojotare quiocuajijiaatijia, Jiyaniijiajanaa quia quiniuria pueyaracaanu cutara’”. ");
INSERT INTO arlNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Supuetana David jiyaniijiacasacari Cristo, ¿Cristotucua taa supuetana David niquiohuacuajinio supueno quirini? Davidcuajaari na jiyaniquiya “cua Jiyaniijiata”. Queraatia pueyari shanohua tojitiariquiaa Jesu pohuatasano. ");
INSERT INTO arlNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesuuri nojori na niishitiojosacari sequeriquiaa: —Tama nia cuaqueyajaaja nia cojuare Moisés Rootasano niishitiojonaacuaji. Cuno pojoriiri puera tucuaque toque cushiyonu maniniucuaja nojori rucuanejotajara, pueya shootianura nojori. Nojoriiri timiquiaa pueya saruhuatasacari nojori, nojori quishacari tiaca jiuujiajinia curotasano cajitiucuajinia. ");
INSERT INTO arlNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nojori jaara masuusaare tamonu tiajinia queranacunura, nojoriiri ritia secooquiaa socua panishano cajitiujinia nojori cajitiuniuria tia camaru shuriucua. Naajuhuaj, Pueyaso secojojua tiacajiniaqueya pueya rerejosacari, nojoriiri camarucua cajitiucuajinia cajitiuniu paniquiaa, pueya shootianura nojori. ");
INSERT INTO arlNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nojoriiri mashiquiopue tiaca masequiaa secaja cumaneecata nojori na sapojonuta. Naa nojori miiniu nuhuajitij, nojoriiri Pueyaso secojoquiaa shitiarayocua pueya niquiara, maninia pueya nojori jiyanishaanura. Naaratej, Pueyaso saniitiosacari maninia miyashijiaca pueya, nojoriiri socua jiyanohua naquiya miishaanutaniya tamasacajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tamacari, Jesuuri cajiriquiaa Pueyaso Secojojua tiajinia cumaneeca niquitiojojua tacoji, tee pueya niojoriquiaa na cumaneeca Pueyasoracuajani. Jesuuri tiji pueya shootiariquiaa na cumaneeca niquitiojiyano. Queraatia casamiriaca pueyari queraatia cumaneeca niquitiojoriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jiyacari tiuquishiijiaariuhua casamiijiu mashiquio. Caapiqui cumaneeniyojua niasee cumaneeca niojojuajiniaari. Cuno cumaneeca na niasanoori maja puera cumaneeca na quiniu quiriquiaa. Saaja cobrejiniji shipinishano quiquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesuuri jiyacari na saquiriojosano pueya piirii. Nojori sequereeri: —Seetanujuanaa nia sequeyanijia, nio casamiijiu mashiquio cutaraari socua queraatia niquitioree puetunu tamasacajinijijianaa. ");
INSERT INTO arlNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Puetunu pueyajanaari na cumaneeca cureenojiniji niquitiojoriquiaa. Saniniuujia, nio maajiiri puetunujuanaa na miaquesocoriquiano na masetajarano niquitioree cutara. ");
INSERT INTO arlNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesu tohuareetasacari Pueyaso Secojojua tiajiniji, tamonu na saquiriojosano pueyajinijinioori na sequeree: —Niishitiojonanaa, quia niquiri Pueyaso Secojojua tia, puereetujuaaca saitia tiasano. ¡Jiyanohua shanohua tia! ");
INSERT INTO arlNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesuuri na riucuaree: —¿Quiaateeri cuno shanohua tia niquiya, saijiniji tiasano jiyaconajani? Cuniqui, majaari saajia cureenu quiniutianiya tamonu caco maano quenaaja. Puetunu niyartasanojuanaa quiniutianiyari. ");
INSERT INTO arlNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na nuhuaji, nojoriiri quiojoquiaari olivo cuhuariquia tuhuananuucua. Cuniquiji, maja puera tucuacaanu quiquiaari Pueyaso Secojojua tia. Na taquijiriaja quiquiaariiri. Jesu cajishacari tii, nocua catecanoquiaariiri Pedro, Santiago, Juan, Andrésnio. Nojoriiri na sequetuquiaari jiyasohuaja: ");
INSERT INTO arlNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Canaa quia sequere taacari Pueyaso Secojojua tia niyartasaanutaniyani. ¿Casaa Pueyaso miiniutianiyani canaa niishiniuria quia sequesano quera tohuateya? ");
INSERT INTO arlNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesuuri nojori riucuaree: —Tama nia cuaqueyajaaja nia cojuare tamasaca sapojiyaquiniuucuaji niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nia numooteyacuajanijia, queraatia sapojonuujuacaari nijionutaniya nojori sequenura niajaniya: “Janiya Cristoni”. Naa sapojotunutaniya queraatia pueyari. ");
INSERT INTO arlNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Niaa jaara tojiniuuri miaquetoojonujiniji niya, tucuacaanujuhuaj, majaari najuhuana nia shiriiquitiuniu. Seetanujuanaa naa quiniutianiyari. Naajaa, jiyacari, majaari jiya puequesacari quiniutianiya juhuanojuaja. ");
INSERT INTO arlNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tamonu rupaa pocuajacaari miaquetoojonutaniya tamaatiuucua rupaa pocuajacata. Pueyari tamonu jiyajiniji miaquetoojonutaniya tamonu jiyajinijinio pueyata. Naajuhuaj, rijiaari jiuuquiujiutianutaniya queraatia tiquiyocua tiacajinia. Jiyanohua miaajesacariiri quiniutianiya jiyacari. Naajaa, puetunu niojuanaari saaja shusha naquiya miiniu coteesacari quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Tama nia cuaqueyajaaja nia cojuare. Niaari tama nia tiacajinia jiyaniijianucuajaaja niquitiosaanutaniya saniitiosocoriquiano. Naajuhuaj, niaari Pueyaso Secojojua tiacajiniajanaa majacusaanutaniya. Niaari jiyatasaanutaniyajuhua tiaca jiyaniijiaacua, jiya jiyaniijianucuaacuanio, nojori nequesoreenura niajaniya, janiyajiniji pohuatanaa nia quiniuucua. Naacuajitij, niocua janiyajiniji pohuatare nojori niquiarajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Jiya puequeyaquishacarijia, Pueyaso rupaari tari pohuatasano quiniutianiya puetunu jiyacajiniajanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Cua tojiri, niaa jaara jiyatashiyare jiyaniijianucuaacua nequesoreesocoriquiano, majaari nia tacaaniu taa nia sequenutaniyani, taa nia pocuanutaniyani. Majaari quenaaja nia niishiriojonu naatej. Saaja nia sequere nojori niquiara jiyacari Pueyaso Sohuanu niishitiojosano niajaniya. Nia pocuasanoori maja niajaniyajiniji quiniutianiya, nia pocuasacari nojori niquiara. Cunocuajaari Pueyaso Sohuanu niishitishano quiniutianiya, na pocuatesacari niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jiyacarijiuhuaj, pueyanoori sesa miiniutianiya tama tarajanujuaaja, cua tojijia tarajanu quiniuucua. Tama tarajanujuaarijia na niquitionutaniya mosocoriquiano. Jiyacaritij, pueyari tama necohuajaaja miiniutianiya sesa, cucua tiuujiaca necohua quiniuucua. Naajuhuaj, necohuari tama na queya tacartanutaniya monujuaaja, na queya tojiniuucua Pueyaso rupaa. ");
INSERT INTO arlNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Puetunu nio jiyajinijinio pueyajanaari maja na niquiniu paniniu quiniutianiya niajaniya, cua tojitiajaca nia quishacari. Naajaa, cante seetanujuanaa pueyaracaanu cucua tiuyajaani nio jiya jaara puequerejaatijia, nojuaja cutaraari shacantuuca quijiara jatanishaanutaniya, pueyaracaanu cuata na quiniuria shuquiriaatia. ");
INSERT INTO arlNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Niaa jaara cuno jiyanohua sacuaraatia casaa niquiri Pueyaso Secojojua tiajinia nujuatesano, taa supuetana Daniel sequeya na naajioneejiniacuajani, niocua ritia mashiri. (Cante nio serojiyani, nojuaja cuaara niishiiria casaa na sequeyani.) Judea jiyajinia quiniaa cuaara mashiiria ritia tuhuananuhuacua, cuno sacuaraatia casaa jaara nujuatesaare Pueyaso Secojojua tiajinia. ");
INSERT INTO arlNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Canapuete jiyacari quiya na tia cacojiriani, nojori cuaara tiuquitiaaquiiria tiajiniaaco na casaa na riniuria juucua. ");
INSERT INTO arlNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Canapuete jiyacari quiya na cuhuariquiajiniani, nojori cuaara tacateyaquiuhuara na toqueya na poonuhuara. ");
INSERT INTO arlNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jiyacaritij, jiyanohua taraatia quiniutianiyari maajipohuara, nojori jaara manajaatohua quiya, jaara jiyacari jiitiare supuejaca conaajajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nia secojosacari, Pueyaso nia maseriquia juhuacarijia, nia mashiyocuatusacari cuaara quiyaquiiria shiniquia quishacari. ");
INSERT INTO arlNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Cuno quishacari, jiyanohua naquiya miiniuuri quiniutianiya. Tariucuacaanu, majaari naa naquiya miiniu quiquiaari Pueyaso shipininiu nuhuaji nio jiya. Naajuhuaj, cuno naquiya miiniu nuhuaji, majaari jiyano naquiya miiniu quiniutianiuhua socua, juhua nio. ");
INSERT INTO arlNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pueyaso jaara ritia tajitiyaquiri cuno naquiya miiquiosacari, pueya maara mijiria cureyaquirij. Pueyasocuajaari ritia tajitiniutianiya cuno naquiya miiniu, na saquiriojosano pueyacua na taraajenuucua. ");
INSERT INTO arlNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Jiyacaritij, tamasaca jaara nia sequere: “Nia niquiri, Cristo tari niya quiya”, jaara sequerejuhuaj: “Nooj, jati quiyatej”, majaari na tojitianunoj. ");
INSERT INTO arlNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jiyacaritij, queraatia sapojonuujuacaari supuenutaniya. Nojoriiri sequenutaniya: “Janiyacuaja Cristoni”. Tamasacaari sequenutaniyajuhuaj: “Janiya Pueyaso sequenu panishano caminiujiuniani”. Nojoriiri pueya niquishoo casaa miiniutianiya na cumaacata, Pueyaso saquiriojosano pueya na sapojonura juucua. Jiyacaritij, queraatia pueya cutaraari sapojosaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Cunora pueyanaa, tama nia cuaqueyajaaja nia cojuare. Janiyacuajaari tari juhuacarijia nia numooteyani. Majaari cua sequesano nia niyajetanu. ");
INSERT INTO arlNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Naa naquiya pueya miiniu nuhuajitij, pananuuri ninishiquiria quiniutianiya. Naajuhuaj, racaari maja na cuhuatanu quiniutianiya mijiria. ");
INSERT INTO arlNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Riyari totenutaniya. Jiyocuacaanu cumaacaraca quijiacaari tetecatunutaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jiyacari, janiya Pueyaso Niyanuuri niquishaanutaniya jiyocuacaanuji roseyano cohuajajiniani, jiyanohua shacantuuca cua cumaacata. ");
INSERT INTO arlNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jiyacaritij, janiyari cua seya jiyaramiquiniutianiyani nojori rerejotenura puetunu cua saquiriojosano pueyajanaa. Nojoriiri puetunu nio jiyajinijiniojuanaa rerejotesaanutaniya, socua jiyanohua tucuacaanu jiya cajiniocua puequeetujinijinio. ");
INSERT INTO arlNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Quiarijia cutara nia niishiri higo naanajiniji. Shuniyara, na jaamasucuaari totequiaa jaranacujua na quiniuria. Na nuhuaji, na cashacucua jaara macumaaca quiri, quiarinio jaamasucuaari mueratuumohua. Niaa jaara naa niquiritij, niaari niishiquiaa tacareejonuqui quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Quiarijia saniniuujia, naatej taa nia niishiquiaa higo naanacuaani, niocua naa niishirijiuhuaj janiya quera tiuquiuhuani, niaa jaara puetunu cua pohuatasanojuanaa niquiri tohuateyano. ");
INSERT INTO arlNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Seetanujuanaa nia sequeyanijia, puetunu cua pohuatasanojuanaari niquishaanutaniya nio pa quishacari quiniaa pueya cusonuyaquishacarijia. ");
INSERT INTO arlNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Jiya cajiniocuaari shaajenutaniya, nio jiyajuhuaj. Cua Rupaa cutaraari maja na jatanu quiniutianiya. Cua sequesanoori puetunujuanaa tohuateenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Maja cutaraari nia niishiniu taacari cua tiuquiniutianiuhuani, casaa juucatej. Majaari jiyocuacaanu quijiaca Pueyaso seya niishiniujiuhuaj. Janiyajanaari maja cua niishiniu. Saaja cua que Pueyaso cutaraari tamajaaja na niishiya. ");
INSERT INTO arlNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Cunora, janiyari nia sequeya cutarani, maja juhua maquenuujujuaca nia quiniu. Pueyaracaanu nia niquitiare cucuaji, juhua sutejaca. Tamajaaja nia soquere. Saaja pueyaracaanu nia secojoriquia Pueyaso. Majacuajaari nia niishiniu taacari cua tiuquiniutianiuhuani. ");
INSERT INTO arlNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Cunoori quiniutianiya juhua tamonu pueyano quianu panishacari tamonu jiyajiniara tucuacaanu. Na quianura, nojuajaari na seya seerataaree maninia nojori cojuanura na tia. Tamasaca niquitioyaree na poonijiosanoori, nojori poonijiosocoriquiano. Tamonu sequereeri, tohuateyaji na cojuanura pueyaracaanu, nojuaja cuaara tiuquiuhuarajaatijia. ");
INSERT INTO arlNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Naaratej, nia sutere. Maja maquenuujunu. Majaari nia niishiniucuaja taacari tia camaru tiuquiniutianiuhuani, shusha ninishacari, shiyaqueya, caacaraja niunijiosacari, tariquiicuaji soj. ¿Taacari cua tiuquiniutianiuhuani? Johuaj, maja pa niishiniu. ");
INSERT INTO arlNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Cunora, juhua sutejaca nia quiriquia, janiya mariqui nia jiyajenetesuhuari, canashiyaquiji cua tiuquishacariuhua niaacua. ");
INSERT INTO arlNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Cua sequesano niajaniyani, cunoori puetunu pueyarajanaa: “¡Nia sutereja! ¡Maja maquenu!” ");
INSERT INTO arlNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jiyacari, juhuanojuaja querajaa juuca quiriquiaajaari Pascua juucara queranacunura. Pascua juucajuhuaj, poreetajaaju shipinishano pan miaquenu coteesaaquiaari siete juucara. Pueyacuara secojonaa jiyaniijianucuaari jiyacari Moisés Rootasanojiniji niishitiojonaata roojotooriquiaa Jesuucuara. Nojoriiri roojotooriquiaa taa nojori sapojonuta nojori quiatunutaniya Jesu jiyasohuajani, na motusocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nojoriiri naa sequetooriquiaa: —Maja queranacusacari naa pa miiniutij, paa mariqui puetunu pueyajanaa juaatiriiri. ");
INSERT INTO arlNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesuuri Betania tiacajinia quiriquiaa Simón tiajinia na saquiriojosano pueyataja. Cuno Simónri tarijia lepra cusotaja quiquiaari. Jesu cajishacari tii miaquejajinia, tamonu maajiiri tiuquiquiaari. Shiitianiyojua shucuariquiaja pataconiyojua cacatariquiaari, shanohua cohuaja saajiajiniji quejasano. Mishaja quiriquiaari shanohua jaanutajata, nardo jaamasucuajiniji shipinishano. Jiyanohua queraatia cumaneecata masesano quiquiaariiri. Jiyacaritij, cuno maajiiri na shucuariquiaja pataconiyojua cocuataree, na totanura Jesu nacaacua. ");
INSERT INTO arlNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tamasaca tii quiniaa pueyari juaarii naa cuno shanohua jaanutaja niitiasaanuucua. Tama nojorijiaarijia sequetooriquiaa: —¿Casaara cuno shanohua jaanutaja niitiasaaree najuhuanani? ");
INSERT INTO arlNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","¡Cuno jaanutaja maara niquitiosaacanu queraatia cumaneecara, casamiijiuniucua niquitiosocoriquiano! Nojoriiri juhuacatecara cuno maaji juaarii. ");
INSERT INTO arlNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesuuri nojori sequeree saaja: —¡Nia tarinitiare! ¿Casaara nia rimiaaqueya nio maajiicuarani? Naa na miishano janiyani, cunoori jiyanohua maninia quiria. ");
INSERT INTO arlNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Casamiijiuniucua pueyacuajaari pueyaracaanu quiriquiano niaata. Nia naatacuajaari maninia miiniu nojori nia panishacari. Janiya saniniuujia, maja cutaraari cua quiniu quiniutianiya pueyaracaanu niaata. ");
INSERT INTO arlNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nio maajiiri maninia miirii. Majaari na naata miiniu quiriquiaa socua maninia nio na miishanojiniji. Na totasacari cucua na shanohua jaanutajani, nojuajaari juhuacarijia cua cuaqueya jeenucuaa, raaco cua niasaanura janiya jaara mosaareni. ");
INSERT INTO arlNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Seetanujuanaa nia sequeyanijia, puetunu jiyacajiniajanaa tee Pueyaso rupaa pohuatasaanutaniyani, nio maaji miishanoori pueyaracaanu pohuatasaanutaniyajuhuaj. Naa na miishano janiyatej, majaari na niyajetasaanu quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jiyacaritij, Judas Iscarioteeri quiaquiaari pueyacuara secojonaa jiyaniijianucuata roojotoonura taa nojori na quiatenutaniya Jesuni. Nojuajaari Jesu saquiriojosano pueyajinijinio quiquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jiyaniijianucua jaara tojiquiaari, Judas nojori quiatenu paniya Jesu, nojoriiri jiyanohua shuquiririi. Nojoriiri Judas sequeree: —Canaa quia niquitionutaniya cumaneecani, canaa quia quiatenu sami Jesu. Cunora, Judasri niishiriojonu coteequiaari taacari nojori na quiatenutaniya Jesuni. ");
INSERT INTO arlNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Puetunu marijiarajanaa, Judiocuacaari Jerusalén tiacajinia rerejoquiaari poreetesoo pan nojori miaquenuunura siete juuca. Coteenu juuca sesaari quiquiaari “Pascua”. Cuno juuca puecoosaaquiaariiri Pascuara riuriotaca borregohua, Pueyaso niquiara miaquenuusocoriquiano. Naaratej, Pascua juuca quishacari, Jesu saquiriojosano pueyari Jesu nequesotaree: —Jiyaniijianaa, ¿tee quia paniya canaa majeetenura quiocuaji borregoni, pa miaquesocoriquiano quiarijia Pascuarani? ");
INSERT INTO arlNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jiyacaritij, Jesuuri caapiqui na saquiriojosano pueyajinijinio sequeree: —Nia quiaare Jerusalén tiacajinia. Niaari tii riuriatanutaniya tamonu pueyano, na mohuaca pataano na patacojinia. Niaa jaara na riuriatasee, niocua na nuhuajimia. ");
INSERT INTO arlNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jaara tiuquishii tiajinia, niocua cuno tia camaru sequesee: “Niishitiojona naa quia sequeya: ‘¿Tee cuniqui cua miaquenutaniya cua saquiriojosano pueyata quiarijia Pascua niucuani?’” ");
INSERT INTO arlNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jiyacaritij, nojuajaari nia niquitiniutianiya puereetuuca sohuaca, jiyocuacaanu nataco, tariucua maninia jeenucuasano. Niocua cuniqui borrego majeetesee, niucua pa miaquesocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na saquiriojosano pueyari quiojoquiaari. Tiacajinia tiuquiijioseeri. Nojori tiuquiijiosacari, nojoriiri puetunujuanaa riuriatasee taa Jesu sequeree nojoricuajani. Nojoriiri tii majeetesee borrego, Pascuara miaquesocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jaara niniquiaari, Jesuuri tiuquiijiosee na saquiriojosano doce pueyata. ");
INSERT INTO arlNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nojori miaquenuusacari, Jesuuri nojori sequeree: —Seetanujuanaa nia sequeyanijia, tamonu niajaniyajinijinio niya cuata miaqueyani, nojuajaari cua tacartanutaniya na quiatenura janiya, naquiya cua miishaanura. ");
INSERT INTO arlNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jesu sequesacari naatej, nojoriiri jiyanohua taraajequee. Jiyacaritij, tama nojorijiaarijia na nequesoreetanu coteeree: —¿Janiya jiyoteeri quia quiatenutaniyani Jiyaniijianaa? Puetunu nojorijianaari naa na nequesotaree. ");
INSERT INTO arlNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesuuri nojori riucuaree: —Niquiriyatujua doce niajaniyajinijiniocuaja, nojuacuajaari nio, shusha pan shiya miacojuajiniani, nojuajaari cua quiatenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Janiyacuajaari maninia tohuateenutaniya puetunujuanaani, taa tariucuacaanu Pueyaso Rupaajinia janiyajiniji naajiotasaaquiaaricuajani. Saniniuujia, jiyanohua taraatia quiniutianiyari cuno pueyanora, cantucuaja cua quiatenutaniya mosocoriquianoni. Maara socua maninia quiquiaari cuno pueyanora, nojuaja jaara raaquishaaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nojori miaquenuusacari, Jesuuri pan ririi. Na Que Pueyaso secojoree nocuaraari. Na neecasenu nuhuaji, nojori niquitiojoreeri. Na niquitiojosacari, naa miriqui sequequiaariiri: —Jajaa. Nia miaquere. Nioori cua cuaqueya. ");
INSERT INTO arlNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na nuhuaji, Jesuuri ratujua pataree. Na Que Pueyaso secojoreeri nojori ratusocoriquianoocuara. Na secojonu nuhuaji, na saquiriojosano pueya niquitioreeri nojori ratunura tiji. Puetunu nojorijianaari ratujuajiniji raturee. ");
INSERT INTO arlNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nojori sequeree miriquiiri: —Nioori cua nanaca. Cua nanacaari queraatia pueyacuara shoonutaniya. Naacuajitij, Pueyasoori seetanujuanaa jiyanooniutianiya pueya, saaja nojori tiuuniuucua cucua, taa Pueyaso sequequiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Seetanujuanaa nia sequeyanijia, maja socua cua ratunu quiniutianiuhua uva caacajiniji, janiya cuaara tacatemohuajaatijia pueyaracaanu Jiyaniijiajanaa cua quiniuria. Jiyacaritij, janiyari shusha niaata na ratunutaniuhuani. ");
INSERT INTO arlNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pueyasora na jaaquequenuunu nuhuaji, nojoriiri quiojoquiaari olivo cuhuariquia tuhuananuucua. ");
INSERT INTO arlNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Na quiojosacari, Jesuuri nojori sequeree: —Nio niucuajani, puetunu niajaniyajanaari cucua tiuuniu tarinitianutaniya. Naa naajiotasano quiyacuajaari niajaniyajiniji tariucuacaanu Pueyaso Rupaajinia. Naa sequeyari: “Janiyari borrego Cojuana monutaniyani. Na borregohuari na camaru nuhuaji niyaquejonutaniya tamajaaja”. ");
INSERT INTO arlNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Na nuhuaji, janiya jaara samiitiarohua macujinijini, janiyari nia puetanutaniya Galilea jiyajiniani. ");
INSERT INTO arlNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedroori jiyacari Jesu sequeree: —Niya cuata quiniaa naasucua quiocuaji carajenutaniya. ¡Janiya cutara maja cua catenu quiniutianiya quiocuaji! ");
INSERT INTO arlNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesuuri saaja na sequeree: —Pedronaa, janiya seetanujuanaa quia sequeyani, nio niucuajani, quiaari janiyajiniji naa seetanutaniya pueya niquiara: “¡Maja cua niishiniu Jesu!” Quiaari naa pacutejonutaniya sequenutej, caacaraja caminiujiyaquishacarijia niunijionu. ");
INSERT INTO arlNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedroori saaja na pataariquiaa naa Jesu sequesacari nojuajatej. Socua sequerohuari: —¡Janiya cuaara mosaaria quiataqui, naajaa, majaari cua seetanu quiniutianiya quiocuaji! Narta saquiriojosano pueyari naa sequetureejuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nojoriiri jiyacari tiuquiijioquiaari tamonu cuhuariquiajinia. Cuno cuhuariquia sesa quiquiaari Getsemaní. Jesuuri na saquiriojosano pueya sequeree: —Niyaja nia cajitiuri, cua secojosacari cua Que socua nia tacoji. ");
INSERT INTO arlNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nojuajaari saaja nocua rupojiyaree jiuujianaraca na pueya: Pedro, Santiago, Juannio. Jesuuri juhuacatecara shiriiquiriquiaa. Tacaariquiaajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nojori sequereeri: —¡Coojiajinia taraajeya jiyanohuanijia, quera cusoyanijia! Niyaja nia jiyojetare. ¡Niocua niquitiareja! ¡Majaari maquenu! ");
INSERT INTO arlNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesuuri socua shiitianiyojua quiaaree nojori tacoji. Na secojonura Pueyaso, mojoquetaseeri. Jiyocuara jacamaquiaariiri. Pueyaso masereeri, maja naquiya na miishaanura juucua. ");
INSERT INTO arlNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na secojosacari, nojuajaari naa sequequiaaritij: —Cua Quenaa, quiara maja jiyajeneta quia panishano quia miiniuria. Naaratej, janiya quia secojiyani, nio raatonuque cucuaji quia tajitiri. Naajaa, cuaara quiyaquiiria juhua cua panishano. Saaja cuaara quiiria cutara taa quia paniyacuajani. “Nio raatonuque” na sequesacari, Jesuuri miriqui sequeriquiaa naquiya na miishocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na secojonu nuhuaji, na saquiriojosano pueyacua tacateyarohuari. Nojori riuriatasuhua maquetiuyanoori. Jesuuri Pedro sequeree: —Simónnaa, ¿quiaate maqueya? ¿Majateeri quenaaja quia naata rejeretanu rupaquijia quia maquenu? ");
INSERT INTO arlNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nia sutere. Maja maquenu. Pueyaso nia secojore niaa mariqui sesa miitishaareeri. Seetanujuanaa, poojiaari maninia miiniu panijia. Pa cuaqueyari saniniuujia sasaca quiyacujua. Majaari pa naata maninia miiniu pa panishano tamajaaja. Cunora, Pueyaso nia secojore na cumaquiniuria niajaniya maninia nia miiniuria. ");
INSERT INTO arlNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesuuri quiaquiaariuhua socua secojonuhuara. Na secojosacari, socua sequenu pacutequiaariiri juhua coteenu na sequesano. ");
INSERT INTO arlNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na nuhuaji, socua tacatequiaariuhua na saquiriojosano pueyacuaari. Nojori riuriatasuhuariuhua maquetiuyano. Nojori namijiaari saaja seecutayariquiaa na maquenuujunuta. Jiyacaritij, nojoriiri maja na niishiniu quiriquiaa taa na riucuatunutaniyanoj. ");
INSERT INTO arlNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesuuri socua quiaquiaariuhua na Que secojonura. Na tacatesacariuhua secojonujiniji, nojori sequesuhuari: —¿Niaate maquetiuyajaa? ¿Niaate samaateyajaa? ¡Tariucuaja! ¡Quiarijia cutara janiyari sesa miijiaca pueya quiatesaanutaniyani, nojori miiniuria janiya taa nojori panitiuyacuajani! ");
INSERT INTO arlNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nia saneecuature. Pa quiaare. Cua quiateriquiano tari cumaji. ");
INSERT INTO arlNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesuuri pocuariquiaajaa Judas tiuquishacari nojoriicua. Cuno Judasri, Jesu saquiriojosano doce pueyajinijinio quiquiaarijiuhuaj. Queraatia pueyari Judasta nijioquiaari. Cuno pueyari nijiniaquetucuaja mueruu pooriquiaa, macacanio. Cuno pojoriiri pueyacuara secojonaa jiyaniijianucua jiyaramiquishano pueya quiquiaari, Moisés Rootasanojiniji niishitiojonaa jiyaniijianucua jiyaramiquishanojuhuaj, Judiocuaca camarucua jiyaramiquishanonio. ");
INSERT INTO arlNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, Jesu quiateriquianoni, nojuajaari juhuacarijia nata quiniaa pueya rootaquiaari, nojori niishiniuria teyanote Jesuni. Naa nojori sequequiaariiri: —Teyano pueyano cua nujuya pa tiuquishacarini, cunocuajaari nojuaja. Niocua na quiasee. ¡Niaari maninia morojosano jaatucutaarohuaquinioj! ");
INSERT INTO arlNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Naacuajitij, Judas jaara tiuquiquiaari Jesuucua, nocua catecanoquiaariiri. Na sequereeri: —¡Niishitiojonanaa! Jiyacari na nujuureeri. ");
INSERT INTO arlNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Judasta nijionaa pueyari jiyacari Jesu quiasee. Morojosanoori jaatucutashiyarohua. ");
INSERT INTO arlNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Cuniqui Jesuta quiniaa pueyajinijinioni, niquiriyatu nojorijinijinioori na shuucuaji shitiaquiaari nijiniaquetucuaja mueruu. Nata jaateree pueyacuara secojonaa jiyaniijia seru numocoori. ");
INSERT INTO arlNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesuuri nocua nijionaa pueya sequeree: —¿Casaara cucua nia nijioree nijiniaquetucuaja mueruutani, macacatanio, morojosano nia riniuria janiya juhua nohuasejojuani? ");
INSERT INTO arlNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Janiyacuajaari puetunu juucajanaa nia tajinia quiquiaani, Pueyaso Secojojua tiajinia cua niishitiojosacari pueya niquiara. Majaari tii cua quishacari nia quianu quiquianu janiya. Naajaa, naa nia miiriqui, tariucuacaanu janiyajiniji Pueyaso Rupaajinia naajiotasano tohuateenura. ");
INSERT INTO arlNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jiyacaritij, puetunu Jesu saquiriojosano pueyajanaari na shuriucuaji mashiyocuatuquiaari. Tamajaaja Jesu tiujiatuqueeri. ");
INSERT INTO arlNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Saaja tamonu mashajaari Jesu nuhuaji sacuariquiaa cutara. Cuno mashaja sesaari Marco. Nojuajaari saaja puereetuque lino toquerauta cuhuajaatiariquiaa. Jesu quiatunaa niquishacari nojuaja, na quiatureejaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nojuajaari saaja na toque tiujiaquee nojori juaashiquiajinia. Juhuasuuri ritia netequee. Mashimiaari. Janiyacuajaari cuno pueyano quiquiaarini, nio naajionajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesu quiatunaari Jesu jaatucuquiaari pueyacuara secojonaa jiyaniijia tiajinia. Puetunu nio pojorijianaari tii rerejoquiaari: pueyacuara secojonaa jiyaniijianucua, Judiocuaca camarucuajuhuaj, Moisés Rootasanojiniji niishitiojonaanio. ");
INSERT INTO arlNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedroori Jesu nuhuajiquiaari tucuacaanuji. Jateeseeri pueyacuara secojonaa jiyaniijia tia carijiniacuma. Cuno jiyaniijiajanaa seya tajinia cajishiiri. Mani jitiuriquiaa nojoritia cuniquiiri. ");
INSERT INTO arlNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pueyacuara secojonaa jiyaniijianucua, puetunu Judiocuaca camarucuajanaari niishiriojonuuriquiaa nojori saquiriojotanura Jesuucuara. Jesuucuara tonujuriquianoori pajesaaquiaari juucua, na motenura. Saaja shaaqui quiquiaariiri sesa casaa, nocuara tonujusocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Queraatia pueyari nocuara tonujuriquiaa juucua, nojori sapojonuta. Nojori saquiriojotasanoori saaja rimiajata quiriquiaa puetunujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na nuhuaji, tamasacaari sanetaquiaari nocuara nojori tonujunura na sapojonutajuhuaj. Nojoriiri naa sequetuquiaaritij: ");
INSERT INTO arlNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Canaa na tojiquianu sesa sequeyanoni. Naa sequecanuuri: “Janiya nio Pueyaso Secojojua tia niyartanutaniyani, pueya tiasanoni. Jiuujianaraca juucajinia, janiyari tamajaaja na tianu tucuatanutaniuhuani. Cunoori maja pueyata tiasano na quiniu quiniutianiya”. ");
INSERT INTO arlNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nojori saquiriojotasanoori saaja rimiajata quiquiaari jiyaniijianucua niquiara. ");
INSERT INTO arlNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jiyacaritij, pueyacuara secojonaa jiyaniijiaari nujuaree pocuanura. Jesu nequesotareeri: —¿Majate quenaaja quia riucuanuujua? ¡Quia tojiri, pueyaruhua quiocuara tonujiya! ");
INSERT INTO arlNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesuuri saaja sanaa nujuariquiaa. Majaari na riucuanu quiriquiaa quenaaja. Pueyacuara secojonaa jiyaniijiaari socua na nequesotaquiaariuhua: —¿Quiaate Cristo, jiyocuacaanuji Pueyaso Jiyarosano? ");
INSERT INTO arlNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesuuri na riucuaree: —Jaa, nojuacuajanijia. Niaari cua niquiniutianiya jiyocuacaanu cumaaca Jiitiana miaquetajara cajiyano. Na nuhuaji, niaari cua niquiniutianiya tacatehuano cohuajajinia jiyocuacaanuji. ");
INSERT INTO arlNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pueyacuara secojonaa jiyaniijia jaara tojiquiaari naa Jesu sequesanotej, tama na toquejaaja sutaree na juaaniutiaari. Sequereeri: —¿Casaara pa sashiya tamasaca saquiriojotanura saa nocuarajaaraniuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Niaacuaja shusha tojirii Pueyasoocuara na sequesano sacuaraatia. ¿Niajaniyarijiataj, taa nia niishiriojiyani? Puetunu pueyajanaari sequequiaari: —¡Cuaara mosaaria! ");
INSERT INTO arlNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jiyacaritij, tamasacaari Jesu riocojonu coteequiaari. Na jiquioco morotureejaariuhua maja na niquiniuria. Na nuhuaji, pueyari na piquiniu coteequiaari. Na piniu nuhuaji, na nequesotaturiquiohuari: —Quia niishiritioj, ¿cante quia piriini? Secojojua tia cojuanaa pueyari na jiquioco piquitiuriijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedroori jiyaniijia tia carijiniacuma quiriquiaa. Jiyacaritij, tamonu niyacoori rucuanejoriquiaa carijiniacuma. Nojuajaari pueyacuara secojonaa jiyaniijia seru quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro niquishii cajiyanoori, mani jitiuyano. Tacuriitia na shootiariquiaari. Na nuhuaji na sequereeri: —Jaj, quiaacuajaruhua Jesuta rucuanejojuajuhuaj, cuno Nazaret tiacajinijinio pueyanotani. ");
INSERT INTO arlNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedroori na seetaree. Na sequereeri: —¡Cuno pueyano maja cua niishishano! ¡Majaari quenaaja cua niishiniu casaa quia sequeyani! Pedroori canujiyaree. Mataca tohuateyaji nujuaseeri. Caacarajaari jiyacari niunijioree. ");
INSERT INTO arlNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Cuno niyacoo jaara Pedro niquiquiaariuhua socua, juhuacatecara nata quiniaa sequereeri: —¡Nio pueyanoori cuno Jesu pueyajinijiniojuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedroori socua na seetaquiaari. Pasaja na tarishishacari, cuniqui nata quiniaari Pedro sequeree socua: —Seetanujuanaa, quiaari cuno pueyajinijinio. Quiaacuajaari Galilea jiyajinijinio pueyano. Canaa tojishacari quiajaniya, quia pocuanuuri juhua nojori pocuanujua. ");
INSERT INTO arlNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedroori socua jiyanohua sapojonu coteequiaari. Naa sequereeri: —¡Pueyaso cuaara saniitioora janiyaqui, janiya jaara sapojiyani! ¡Seetanujuanaa, maja cua niishiniu cuno pueyano, canajiniji nia nequesoreetaacuajani! ");
INSERT INTO arlNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jiyacaritij, caacarajaari niunijionu pacuterohuacuhuaj. Pedroori jiyacari niishiquii naa Jesu sequesano nojuajatej: “Juhuanojuaja caacaraja niunijionu pacutejiyaquishacarijia juhuaquenu panishacari, quiaari janiyajiniji tari seetanu pacutejonutaniya”. Pedro jaara niishiquii naa Jesu sequesano nojuajatej, jiyanohua nujuquequeeri. ");
INSERT INTO arlNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tariquiicuaji, pueyacuara secojonaa jiyaniijianucuaari rerejoquiaari Judiocuaca camarucuata, Moisés Rootasanojiniji niishitiojonaatajuhuaj, Sanedrín maanutanio. Nojoriiri moronucua Jesu jaatucutaquiaari Pilatoocua. Cuno Pilatocuajaari Judea jiya jiyaniijia quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatoori Jesu nequesotaree: —¿Quiaate Judiocuaca jiyaniijia? Jesuuri na riucuaree: —Jaa. Naacuaaquiniatejaj, taa quia sequereecuajani. ");
INSERT INTO arlNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pueyacuara secojonaa jiyaniijianucuaari Jesuucuara tonujuriquiaa queraatia sesa casaa. ");
INSERT INTO arlNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatoori Jesu nequesotarohuacuhuaj: —¿Majateeri quenaaja quia riucuanuujua? Quia tojiri taa cuno pojori saquiriojotaa quiocuarani. ");
INSERT INTO arlNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesuuri maja na riucuanu quiriquiaa quenaaja. Cunora, Pilatoori jiyanohua jiuujiatequiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Puetunu marijiarajanaa, Pascuara queranacunu juuca, Pilatoori nujuatesano pueyano tohuataniniu jiitiquiaari nujuatejojuajiniji, cana pueya paniquiaari na cartesaanuracuajani. ");
INSERT INTO arlNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jiyacaritij, tamonu pueyanoori nujuatejojuajinia nujuariquiaa. Na sesa quiquiaari Barrabás. Nojuajaari tamasaca pueyata pueyano moquiaari. Cunoori quiquiaari nojori juaashacari, Romano taucuaca jiyaniijia jiitianuucua Judiocuaca. ");
INSERT INTO arlNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pilato nequesoreesacari Jesu, jiyacaritij, queraatia pueyari Pilatoocua nijioquiaari naa nojori secojonura nojuaja: —Pueyano quia carterohua nujuatejojuajiniji, taa quia miiquiaacuaja puetunu marijiarajanaani. ");
INSERT INTO arlNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatoori nojori riucuaree: —¿Cana nia paniya cua cartenurani? ¿Niaate niarta Judiocuaca jiyaniijia paniya cua cartenura? ");
INSERT INTO arlNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nojuajaari tama niishiquiaarijiaaja, pueyacuara secojonaa jiyaniijianucuaari Jesu niquiniu paniyaquiquiaari pueya shocotenuucua nojori saniniuujia Jesuucuara. ");
INSERT INTO arlNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pilato nequesotasacari nojori, pueyacuara secojonaa jiyaniijianucuaari jiyacari pueya shiniujiuquiaari nojori sequenura Pilato, nojuaja cuaara carteera Barrabás. ");
INSERT INTO arlNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Naarate Pilatoori nojori nequesotarohua socua: —¿Taa nia paniya cua miiniuria nio pueyanoni, nia sequesano niarta Judiocuaca jiyaniijiani? ");
INSERT INTO arlNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nojoriiri naa nacaree jiyanohua: —¡Cuaara mosaaria niyacutesanojinia teetesano! ");
INSERT INTO arlNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatoori nojori riucuaree: —¿Casaarateni? ¿Casaa na miiquianu sesajaarani? Nojoriiri saaja jiyanohua nacaree: —¡Niyacutesanojinia quia teetere! ");
INSERT INTO arlNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatoori socua tariniquiaari. Nojuajaari maninia quiniu paniquiaari Judiocuacata. Cunora, Barrabás cartereeri. Saniniuujia, Jesu majacuteree cutaraari. Na nuhuaji, na soldadohua na niquitioreeri, niyacutesanojinia na teetesaanura. ");
INSERT INTO arlNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jiyacaritij, soldadohuari Jesu jaatucuquiaari jiyaniijia Pilato tiajiniaaco. Nojoriiri puetunu narta soldadohuajanaa rerejoteree Jesu shocua. ");
INSERT INTO arlNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Soldadohuari Jesu cushitiquiaari shaaruque toque, juhua jiyaniijiajanaa cushishano. Juhuacontucua maatusano cushitishaareejaariuhua na nacaquera. ");
INSERT INTO arlNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na nuhuaji, nojoriiri na rupaa paaretanu coteequiaari Jesu na macaatiniuria: —¡Jejejee, Judiocuaca camarnuna nooj! ");
INSERT INTO arlNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nojoriiri na naca piquirii naajuata. Na riocojotureejaariuhuaj. Nocuara mojoquetacoreeri juhua jiyaniijiajanaa cariquimiaji, nojori sapojonuta na macaatiniuria nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Naa na rerequetesaanu nuhuajitij, toque naatuqueeri nocuaji jocuasaaquiaari. Tama na toquejaaja cushitishaarohuari. Na nuhuaji, soldadohuari na tohuataniquiaari. Na jiyatatuquiaariiri niyacutesanojinia na teetesaanura. ");
INSERT INTO arlNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Soldadohua jiyatasacari Jesu, tamonu pueyanoori jiyacari tacateriquiohua na cuhuariquiajiniji. Cuno pueyano sesa quiquiaari Simón. Soldadohuari Jesu teetejarano niyacutesano patanirii nojuaja. Nojuacuajaari Alejandro que, Rufo quenio. ");
INSERT INTO arlNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesuuri shiitianiyojua tuhuananuucua jiyatasaaquiaari. Cuno tuhuananu sesa quiquiaari Gólgota. Nioori pueyano rupaajinia sequeya, “Pueyano nacaco”. ");
INSERT INTO arlNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Soldadohuari Jesu raatequiaari vino juucua, mirrata cojitishano. Saaja na ratuyaquiriiri. ");
INSERT INTO arlNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jiyacaritij, nojoriiri Jesu teetequiaari niyacutesanojinia. Na nuhuaji, soldadohuari saitia tacuarishijioquiaari, nojori niishiniuria cantucua Jesu toque poore nerani. Naacuajitij, nojoriiri Jesu toqueya seraatiaquiaari tama nojoririajaaja. ");
INSERT INTO arlNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jiyacaritij, niyacutesanojinia na teetesacari, shusha pananu tacasacariiri quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Naajioneeri na nacaacuma rupotasano quiquiaarijiuhuaj. Tii sequequiaariiri casaara na mosaareeni. Naa naajiosano quiquiaariiri cuno rupotasanojinia: “Nioori Judiocuaca jiyaniijia”. ");
INSERT INTO arlNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jiyacaritij, caapiqui nohuasenuujuacaari Jesu shuriucua teetejosaaquiaarijiuhuaj, socua tamonu caapiqui niyacutesanojinia; tamonu na miaquetajara, tamonu na muenecara. ");
INSERT INTO arlNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Naa tohuateequiaariiri taa tariucuacaanu Pueyaso Rupaajinia na naajiotasaaquiaaricuajani. Naa sequeyari: “Na sesaari sesa miijiaca pueya sesacata cojiritiasaaquiaari naajiotasaanujuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pueya tajishacari nucuaco Jesu shuriuquioco, nojoriiri na macaatiquiaari. Na maanuquenuta naa na sequetuquiaariiri: —¡Jaj! ¿Majateeri quiajaniya cumaacaracacuaja? ¿Quiaateeri jiyaniriquiaa, quiaa jaara Pueyaso Secojojua tia niyartare, quia naata na tianu tucuatanuhua jiuujianaraca juucajinia? ");
INSERT INTO arlNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Quiaa jaara naa cumaacaraca quiritij, niyacutesanojiniji quia roserecuarajaj. ");
INSERT INTO arlNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pueyacuara secojonaa jiyaniijianucua, Moisés Rootasanojiniji niishitiojonaari na macaatiquiaarijiuhuaj. Tama nojorijiaarijia naa sequetooquiaari: —¿Maatucua saa tamasaca naatanijioriquiajaari? Tama nojuaja cutaraari maja na naata niyacutesanojiniji rosenu. ");
INSERT INTO arlNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jaara seetanujuanaa quiri Pueyaso Jiyarosano, pa jiyaniijia na quiniuria, cuaara roseera niyacutesanojiniji pa niquiara. Pocua jiyacari nocua tiuuri cutarani. Cuno nohuasenuujuaca Jesu shuriucua teetejosano quiriquiaani, nojoriiri na sesacariquiaajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Panacari, jiyari ninishiquiria quiquiaari puetunujuanaa. Tarishiquiaariiri. Shusha tenacariishacari cuhuatemohuari. ");
INSERT INTO arlNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jiyacaritij, Jesuuri jiyanohua na rupaa paaretaquiaari: —Eloi, Eloi, ¿lama sabactani? Nioori sequeya: “Cua Pueyasonaa, cua Pueyasonaa, ¿casaara quia carteree janiyani?” ");
INSERT INTO arlNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Na shuriucua nujuatunaa tojitiasacari naa Jesu paaretasacari na rupaatej, nojoriiri sequeturee: —¡Nia tojiri, supuetana Elías jiiquioonuyano, nocua na niniuria! ");
INSERT INTO arlNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tamonu pueyanoori ritia netequiaari namasu casaa na shiniuria jereeca vinojinia. Na nuhuaji, na morotaree naajuaacuaari, na shitiasocoriquiano Jesu rupaama. Na raatereeri. Na nuhuaji, nojuajaari sequequiaari: —¡Pa shanacure! ¡Supuetana Elías jiyoteeri nocua niniutianiya na roshininiuria niyacutesanojiniji! ");
INSERT INTO arlNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jiyacaritij, Jesuuri jiyanohua na rupaa paaretarohuacuhuaj. Cusoqueeri. ");
INSERT INTO arlNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jiyacaritij, Pueyaso Secojojua tiajiniacuma, shiquiiquia toquejiniji sohuacaari sutequee tamajaaja, jiyocuacaanuji jiyocuara. Cunoori pueya pueresano quiquio mishiquiotaja quiquiaari, pueya mariqui cusoqueeri Pueyasoocua nojori tiuquishacari juucua, jiyanooshoojua nojori quishacari. ");
INSERT INTO arlNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Cuno Romano soldadohua jiyaniijiaari Jesu tacoji nujuariquiaa. Na niquishacari taa Jesu nacaquiaarini, naajuhuaj, taa Jesu cusoquiaari na rupaa na paaretanutani, jiyacariti nojuajaari naa sequeree: —¡Nio pueyanoqui seetanujuanaa Pueyaso niyanu! ");
INSERT INTO arlNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Maajipohuari tii quiriquiaajuhuaj. Tucuacaanuji Jesu shootiaturiquiaari. María Magdalenaari nojoritia quiriquiaajuhuaj, socua narta maajipohuanio. Cuno maajipohuani, nojoriiri quiquiaari Salomé, Maríanio, cante Santiago, José nucua quiquiaaricuajani. Nio Santiagoni, nojuajaari socua naatujua na sesaanucua Santiagojiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Puetunu nio maajipohuajanaari Jesu nuhuajiniaa quiquiaari. Nojoriiri nera pueraquenuunaa quiquiaari, Galilea jiyajinia na quishacari. Socua queraatia maajipohuari tii quiriquiaajuhuaj, canapuete Jerusalén tiacajiniara nijioquiaari Jesutacuajani. ");
INSERT INTO arlNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jesu cusonu juucani, cuno juuca sesa quiquiaari “Jeenucuanu juuca”, maja samaatenu juuca poonijionura. Saniniuujia, tariqui quiquiaariiri samaatenu juuca. Cunora, pueyari juhuacarijia jeenucuaquiaari puetunujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Cuno juucajani, jeenucuanu juuca ninishacari quera, tamonu pueyanoori Pilatoocua quiaquiaari. Nojuajaari José, Arimatea tiacajinijinio pueyano. Cuno Joseeri tojishano pueyano quiquiaari narta Sanedrín pueyara. Joseeri mijiria Pueyaso Jiyarosocoriquiano niquiniuucua jiaatiaja quiquiaarijiuhuaj, canaa Jiyaniijiajanaa na quiniuria. Nojuajaari maja na puerenu quiquiaari Pilatoocua na tiuquiniuria, Jesu quete na masenura. ");
INSERT INTO arlNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatoori jiyanohua jiuujiatequiaari na tojishacari Jesu tari cusoquee. Pilatoori soldadohua jiyaniijia sequeree nocua na niniuria. Nocua na tiuquishacari, na nequesotareeri: —¿Taacari Jesu cusoqueeni? ");
INSERT INTO arlNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Soldadohua jiyaniijia jaara na riucuaquiaari taacari na cusoqueeni, Pilatoori jiyamitia José sequeree Jesu quete na panura. ");
INSERT INTO arlNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseeri jiyacari shanohua quenaaruque toque masequiaari tama na cumaneecatajaaja. Na nuhuaji, macu roshiniriiri niyacutesanojiniji. Cuno toquejinia na jiuniocoreeri. Na nuhuaji, na niaquiaari raacoori. Cuno raari jiuutiasano quiquiaari saajiajinia. Joseeri raa tioree jiyanohua puereetuuca quejasano saajiata. ");
INSERT INTO arlNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, José nucua Maríanio, nojoriiri na niquitiariquiaa tee na niasaareeni. ");
INSERT INTO arlNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Samaatenu juuca jaara shocoquiaari, María Magdalena, Santiago nucua Maríajuhuaj, Salomeenio, nojoriiri shanohua jaanutaja masequiaari macuucua na tuujutasocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jiyanohua tariquiicuaji Domingo juuca, shusha pananu muetasacari, nojoriiri raajinia quiojoquiaari. ");
INSERT INTO arlNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nucuaco na quiojosacari, tama nojorijiaarijia sequetooriquiaa: —¿Canteeri pocuaji shuuquitiniutianiya tamocora raa tiootiuni? ");
INSERT INTO arlNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nojori jaara niquiquiaari raa, saajia niquitiuriiri tariucua tamocora shuuquitishano. Puereetuuca saajiaari quiquiaari raa tiootiu. ");
INSERT INTO arlNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nojoriiri raaco tiuquitiamaa. Mashaja niquitiushiiri tii cajiyano nojori miaquetajara, cohuaja tucuaque toque cajitiaano. Nojoriiri jiyanohua shiriiquitiuquiaari na niquitiushacari nojuaja. Cuno mashajaari Pueyaso seru quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Maajipohua sequereeri: —¡Maja nia shiriiquiniu! Janiyari niishiyacuajani, niaari Jesu pajeya, Nazaret tiacajinijinio pueyano, niyacutesanojinia teetesaarucuaani. ¡Nojuacuaja tari samiitiarohua! Maja niya na quiniu. Nia niquishuriiria na maja, tee na niasaarucuaacuajani, shaaqui. ");
INSERT INTO arlNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na saquiriojosano pueya nia sequesuhua, Pedrojaajanio: “Nojuajaari nia puetanutaniya Galilea jiyajiniara. Niaari tii na niquiniutianiya, taa na sequecanu niajaniyacuajani”. ");
INSERT INTO arlNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Maajipohuari netecuatuquiaariuhua raajiniji. Nojoriiri tetecaturiquiaa na shiriiquiniutia. Majaari quenaaja tamasaca pueya na sequetunu quiquiaari na puerenuta. ");
INSERT INTO arlNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesu samiitianu nuhuaji, cuno Domingo juucaja, shusha semaana coteenu juucani, Jesuuri coteenujuanaa muetaquiaari María Magdalenaacua. Jesucuajaari tarijia siete samaruhua tohuatanijioquiaari cuno Maríajiniji. ");
INSERT INTO arlNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María Magdalena niquiniu nuhuaji Jesu, nojuajaari quiaquiaari Jesu cojiniaa na numootenura. Cuno pojoriiri jiyacari taraajecoriquiaa. Nujuqueturiquiaari Jesu mosaanuucua. ");
INSERT INTO arlNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","María Magdalenaari nojori sequesee: —Pueyanaa, ¡Jesu tari samiitiarohua! ¡Janiya na niquiriini! Nojoriiri María sequesano cuaracashitirii saaja. ");
INSERT INTO arlNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Na nuhuaji, Jesuuri socua caapiqui na pueyacua muetaquiaari nojori quiojosacari tamocora. Nojuajaari tamaatia niquishano quiriquiaa nojoriria. ");
INSERT INTO arlNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nojori niishishacari nojuacuaja Jesu quiquiaari, nojoriiri ritia riujiuuquiaariuhua tamasaca nojorijinijinio nojori numootenuhuara. Naajuhuaj, Jesu saquiriojosano pueyari nojori pohuatasano cuaracashitiriijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tamacari, Jesuuri na once saquiriojosano pueyacua muetaquiaari. Nojoriiri miaquejajinia cajitiuriquiaa jiyacari. Jesuuri jiyacari nojori juaarii cumajiuujiaaca nojori quiniuucuaja. Majaari quenaaja nojori tiuuniu quiquiaari nojorijinijinio pueyacua, nojori sequesacari: “Canaa Jesu niquiriini, samiitiarohuacuaaqui”. ");
INSERT INTO arlNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na nuhuaji, Jesuuri nojori sequeree: —Nia quiaare puetunu jiyacajiniajanaa, janiyajiniji Pueyaso rupaa nia pohuatanura, puetunu nia pohuatasanoocua tiuujiaca pueyapuejanaa jiyanooshaanura. ");
INSERT INTO arlNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Cante moojinia tiuquinishiya Pueyaso rupaacua na tiuuniuucuani, Pueyasoori na jiyatenutaniya na pueyanora. Saniniuujia, cante Pueyaso rupaacua tiuyaquiyani, nojuajaari saniitiosano quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Cucua tiuujiacaari nocuaji pueya jiuujiatesano casaa miiniutianiya cua cumaacata, pueya niishiniuria Pueyaso rupaaqui seetanu rupaajanaa. Naacuajitij, cucua tiuuniaa pueya nia quiniuucua, niaari samaruhua tohuatanijionutaniya cua cumaacata, nia jiyaniquishacari cua sesa. Niaari nia niishiyaquishoo rupaaca pocuajaca quiniutianiyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Naajuhuaj, niaa jaara soconu sajitishaare, niaa jaara casaa raatesaarejuhuaj nia cusojuasaanura juucua, majaari nia cusonu quiniutianiya. Naajuhuaj, cusosuhuacua nia niasacari nia juaashiquia, cusosuhuari naataconutaniuhua. ");
INSERT INTO arlNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Na pocuanu nuhuaji, Jiyaniijia Jesuuri tacanishaaquiaariuhua jiyocuacaanu. Nojuajaari Pueyaso miaquetajara cajiquiaariuhua. ");
INSERT INTO arlNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na nuhuaji, na saquiriojosano pueyari quiojoquiaari Pueyaso rupaa nojori pohuatanura puetunu jiyacajiniajanaa. Jiyaniijia Jesuuri pueyaracaanu nojori cumaquiriquiaa. Pueya niquitiriijiaariuhua na cumaacata na pueya miijiosano, pueya niishiniuria maatia, Jesu jiyaramiquishano pueya pohuatasanoori seetanu rupaajanaa.");
INSERT INTO arlNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Queraatia pueyari suraatia naajionu saniniujiuquiaari puetunu canaa tajinia miishanojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nojoriiri naajioquiaari taa Jesu jiyaramiquishano pueya pohuataquiaari Jesujiniji pajaniyani. Cuno pojoriiri Jesu niquiniaa quiquiaari, shusha poonijionu na coteesacari. Nojoriiri na nuhuaji na rupaa pohuatanaara jiyatesaaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Janiyari niishiriojoriquiaani, maniniaruhua quiocuara cua naajionurajuhuaj cua panishano Teófilonaa. Naaratej, janiyari pueyaracaanu jacaria nequesoreeriquiaa puetunu Jesu miishanojuanaani, na coteejajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Naacuajitij, quiocuara naajiyanijia na coteenujiniji, seetanujuanaa quia niishiniuria puetunujuanaa, taa quia niishitiojosaacanucuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes jaara jiyaniijia quiquiaari Judea jiyajinia, Zacaríasri jiyacari pueyacuara secojona quiquiaari. Nojuajaari supuetana Abías niquiohuacuajinio supueno quiquiaari. Necocua sesa quiquiaari Isabel. Cuno maajiiri supuetana Aarón niquiohuacuajinio supueno quiquiaari. Nojori supuetanaari mariyata tariucuacaanu pueyacuara secojonaa quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacaríasri necocua Isabelta maninia miijiaca quiquiaari Pueyaso niquiara. Nojoriiri puetunu Pueyaso rootasanojuanaa tojitiajaca quiquiaari, taa Pueyasojiniji caminiujiuniaa naajionuutaquiaaricuajani. Nojoriicuara maja na naata sesa casaa tonujusaanu quiquiaari, saaja maninia miijiaca nojori quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nojoriiri maja na muetunu quijia, niyajaru Isabel quiniuucua. Naajuhuaj, nojoriiri maja tari na naata muetunu quiquiaari, saaquiapue nojori quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tamacari, Zacaríasri narta pueyacuara secojonaata poonijioriquiaa Pueyaso Secojojua tiajinia Pueyaso niquiara Jerusalén tiacajinia. Jiyacari saniniuujia nojori poonijiosacariiri quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Shanohua jaanutajaari catijiasaaquiaari puetunu juucajanaa Pueyaso Shuriucua Quiquiojinia, Secojojua tiajinia. Pueyacuara secojo naari jiitiquiaari saajia naajiosano jacutanura juhua tacuarishijiosacari, nojori niishiniuria teyano nojorijinijiniote Pueyaso Shuriucua Quiquio tiuquiniutianiyani, shanohua jaanutaja na catijianura tii. Cuno juuca saniniuujia, saajiaari Zacaríascuara tacatequiaari. Naacuajitij Zacaríasri seeratasaaquiaari tii na tiuquiniuria shanohua jaanutaja na catijianura. ");
INSERT INTO arlNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na catijiasacari, puetunu pueyajanaari Pueyaso secojonuuriquiaa Secojojua tia carijiniacuma. ");
INSERT INTO arlNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jiyacaritij, Pueyaso seruuri Zacaríascua muetaquiaari. Nujuariquiaari shanohua jaanutaja catijiasaqui miaquetajara. ");
INSERT INTO arlNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacaríasri shiriiquirii na niquishacari Pueyaso seru. Jiyanohua na puerereeri. ");
INSERT INTO arlNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pueyaso seruuri na sequeree: —Maja puerenu Zacaríasnaa. Pueyasocuajaari quia secojosano tojiquiaari. Quia niquiocua Isabelri quiara muetunutaniya. Quiocua na sesojore “Juan”. ");
INSERT INTO arlNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Quiaari shuquiriaatia quiniutianiya. Quiaari quia mueya timitianutaniya. Queraatia pueyari na shuquiritianutaniya na rasacari. ");
INSERT INTO arlNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Quia niyanuuri cutara pueyano quiniutianiya Pueyaso niquiara. Nojuajaari vino ratuyashijia quiniutianiya, najatunacunio. Pueyaso Sohuanuraca pueyano quiniutianiyari na rasaacarijiyojua. ");
INSERT INTO arlNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nojuajaari queraatia Israel pueya tacatonutaniuhua nojori Jiyaniijia Pueyasoocua. ");
INSERT INTO arlNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nio Juanri pa Jiyaniijia puetana quiniutianiya. Nojuajaari pueyara Pueyaso sequesano caminiujiunia supuetana Elías sohuanu jiitianutaniya, na cumaacanio. Naacuajitij, pueya jiuujia taraajonutaniyari, nojori jiyanooniuria necohua. Naajuhuaj, nojuajaari tojitiaashijiaca pueya rootanutaniya maninia, Pueyaso tojitiajaca nojori quiniuria. Naacuajitij, pueya jiuujiacaari jeenucuasano quiniutianiya pa Jiyaniijiaacuaji. ");
INSERT INTO arlNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacaríasri Pueyaso seru nequesotaree: —¿Taa cua niishiniutianiyarini quia sequesano seetanujuanaa tohuateenutaniya quiria? Janiyari tari saaquianoni. Cua niquiocuaari motajajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Pueyaso seruuri na riucuaree: —Janiyacuajaari Gabrielni, Pueyaso tacoji nujuana, na sequesano cua miiniuria. Nojuajaari cua jiyaroree cua pohuatanura quiajaniya nio maninia casaa Pueyasojiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Quiarijia saniniuujia, cua sequesanoocua quia tiuyaquiniuucua, quiaari tiquia quiniutianiya. Majaari quia pocuanu quiniutianiya cuaara rasaarejaatijia quia niyanu. Naajaa, puetunu cua sequesanojuanaari naa quiniutianiya taa Pueyaso paniyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jiyacaritij, pueyari Pueyaso quiquio carijiniacuma sashiriquiaa, Zacarías cuaara tohuatohuara. Nojoriiri shiriiquitiurii pueyaracaanu Zacarías tarishishacari Pueyaso Shuriucua Quiquiojinia. ");
INSERT INTO arlNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacaríasri socua tohuatamohua. Majaari na naata pocuanu quiriquiaa. Nareja shishiniojoriquiaari. Naacuajitij, pueyari niishirii Pueyasoqui casaa niquitirii Zacarías, Pueyaso Shuriucua Quiquiojinia na quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zacarías jaara puecaquiaari puetunu na poonijionu juucajanaa taa na sequesaaquiaaricuajani, na tiajinia quiaarohuari. ");
INSERT INTO arlNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na nuhuaji, necocua Isabelri manajeree. Na manaja jamaatiaquiaariiri. Majaari na muetanu quiquiaari na tiajiniji cuaara na shocojoquiaarijiaatijia cinco raca. Nojuajaari tama sequequiaarijiaaja: ");
INSERT INTO arlNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Quiarijiani, cua Jiyaniijiaari maninia miirii janiya. Majaari socua pueya rerequetenu quiniutianiya janiya, muetujua cua quishacari tari”. ");
INSERT INTO arlNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Seis raca jaara shocojoquiaari Isabel manajesacaricuaa, Pueyasoori na seru Gabriel jiyaroree Nazaret tiacajinia, Galilea jiyajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tamonu niyacoocua na jiyaroreeri, cante tari sequesaaquiaaricuajani José jiyanishano pueyanota na caminiuria. Na camiriquianoori supuetana jiyaniijia David niquiohuacuajinio supueno pueyano quiquiaari. Niyacoo sesa quiquiaari María. ");
INSERT INTO arlNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pueyaso seruuri nocua tiuquimiaa. Na sequereeri: —Janiyari quiocua jiyarosaareeni, Pueyaso shuquiritiasano niyacoonaa. Jiyaniijia Pueyasoori quiata quiya, socua shuquiriaatia quia quiniuria tamasaca maajipohuajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maríari jiyanohua tacaaquiaari naa Pueyaso seru sequesacari nojuaja. Nojuajaari tamajaaja niishiriojoriquiaa: “¿Casaara naa na sequeree janiyani?” ");
INSERT INTO arlNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na nuhuaji, Pueyaso seruuri na sequeree: —Maríanaa, maja puerenu. Pueyasoori quia shuquiritiniutianiya. Quiaacuajaari na timitiasano. ");
INSERT INTO arlNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Quiarijiani, quiaari manajenutaniya. Quiaari cayaniyojua ranutaniya. Quiocua na sesojore “Jesu”. ");
INSERT INTO arlNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nojuajaari cutara pueyano quiniutianiya. Sesojosaanutaniyari “Pueyaso Niyanu”, jiyocuacaanu Quijia Niyanu. Pa Jiyaniijia Pueyasoori na jiyatenutaniya Jiyaniijiarajanaa na quiniuria na supuetana David niti. ");
INSERT INTO arlNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israel pueya jiyaniijia quiniutianiyari. Pueyaracaanu jiitianutaniya na pueyari. Majaari na shaajenu quiniutianiya Jiyaniijia na quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maríari Pueyaso seru nequesotaree: —¿Taa cua manajenutaniyari, niyacaaju cua quishacari? ");
INSERT INTO arlNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Pueyaso seruuri na sequeree: —Pueyaso Sohuanuuri quiocua niniutianiya. Na cumaaca naaquiiri quiocua pacunutaniya. Naacuajitij, quia niyanuranoni, cunoori Pueyaso Niyanu quiniutianiya. Nojuajaari seetanujuanaa Pueyaso tojijia quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Naajuhuaj, quia supuetanajinijinio motaja Isabelri neyanu ranutaniyajuhuaj. Cuno maajiiri sequesaaquiaari “niyajaru maajitia”. Naajaa, seis racaari tari na shocojiya na manajesacari. ");
INSERT INTO arlNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pueyasora, majaari jiyajeneta casaa quiniu. Nojuajaari cumaacaraca na miiniuria puetunu na panishanojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maríari sequeree: —Maniniacuajaqui. Janiyacuajaari cua Jiyaniijia Pueyaso seruni. Pueyaso cuaara miiria janiya taa quia sequereecuajani. Na nuhuaji, Pueyaso seruuri quiacuhua. ");
INSERT INTO arlNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maríari jiyacari quiaquiaari na secoonuta Judea jiyajinia, Zacarías tiajiniara tamonu tiacajinia. Cuno jiyari tuhuananuhuaraca. ");
INSERT INTO arlNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacarías tiajinia María tiuquishacari, Isabel sequereeri. ");
INSERT INTO arlNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Isabel tojishacari María sequesano nojuaja, ¡conaajaari na jiniacuma nujuanequequee! Pueyaso Sohuanuuri Isabelcua tiuquiquii na cumaaca na jiitianura. ");
INSERT INTO arlNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Naacuajitij, Isabelri jiyacari na rupaa paaretaree. Naa María sequereeri: —¡Pueyasocuajaari socua maninia miiriucuaa quiajaniya tamasaca maajipohuajiniji! ¡Maninia miiniutianiya quia niyanujaariuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Janiyateeri pueya tojishano maajini, cua Jiyaniijia nucua tiuquiniuria cua tiajinia, na niquiniuria janiya? ¡Maja! Naajaa, ¡jiyanohua timiyanijia! ");
INSERT INTO arlNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Shusha cua tojishacari quiajaniya cua sequeyano, cua mueyari cua jiniacuma nujuanequequee na shuquiriniutia. ");
INSERT INTO arlNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Shuquiriaatia quia quiri, quia tiuuniuucua Pueyaso sequesanoocua quiajaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maríari sequeree: —¡Coojia jiyanohua shuquiritiaa cua Jiyaniijia Pueyaso! ");
INSERT INTO arlNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","¡Cua sohuanuuri cua Jiyanoonia Pueyaso timitiaani! ");
INSERT INTO arlNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Juhua najuhuana quijianijia. Naajaa, Pueyasoori cua jiyanoorii. Cua saquiriojorucuaari na tojijia cua quishacari. Quiarijiani, pueyari pueyaracaanu cua sequenutaniya: “Pueyaso shuquiritiasano María”. ");
INSERT INTO arlNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","¡Pueyasoori jiyanohua maninia miirii janiya! Nojuajaari puetunu cumaacaracajanaa. Nojuajaari tojetaarucuajanaa maninia quijia. ");
INSERT INTO arlNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nojuajaari pueyaracaanu jiyanooquiaa na tojitianaa, canapuete na rerequeteyaquijiacacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","¡Nojuajaari jiyanohua maninia miiquiaa na cumaacata! Nojuajaari niishijiaca pueya shocotequiaari, canapuete tama na cuaqueyajaaja jiyatequiaari juhua niishijiacaracuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nojuajaari cutara jiyaniijianucua jataree, cuno pojori jiyanishano niishiyashijiaca pueya jiyatesaanura jiyaniijiara nojori niti saniniuujia. ");
INSERT INTO arlNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Miaajeejunucua tootijioreeri maninia sumatuuta. Puera casamiriaca pueya taanuuquiaariiri, casaaju nojori quiojonura. ");
INSERT INTO arlNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Na pueya Israel naacureeri. Majaari na niyajetanu quiquiaari nojoriicua na taraajenu. ");
INSERT INTO arlNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Naa miiquiaariiri taa na sequequiaari pa supuetanaacuajani. Pueyasoori naa pa supuetana Abraham sequequiaari: “Seetanujuanaa quiocua taraajenutaniyanijia, quiocuajinio supueriquiano pueyacuanio”. ");
INSERT INTO arlNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na nuhuaji, Maríari queraatia tarishiquiaari Isabel tiajinia. Jiuujianaraca raca nuhuaji, Maríari tacatequiaariuhua na tiajiniohua. ");
INSERT INTO arlNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na nuhuaji, Isabel rasacari quiquiaari. Jiyapueratereeri. ");
INSERT INTO arlNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na shuriucua quiniaa, mariyata na jiyasoocuajinio supueno pueyajuhuaj, nojoriiri jiyanohua shuquiriquiaari nojori tojishacari taa Pueyaso jiyanohua taraajequiaari Isabelcuani, na shuquiritiniuria neyanuta. Nojoriiri Isabelta shuquiriquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nojoriiri Zacarías tiajinia rerejoquiaari conaaja jiitiasacari ocho juuca, na cararaatiuuquia co miatesaanura, taa Moisés rootaquiaaricuajani. Nojoriiri na sesojonu paniriquiaa juucua Zacarías, na que sesaanucua na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Na nucuaari saaja sequeree: —¡Maja! Sesojosaanutaniyano “Juan”. ");
INSERT INTO arlNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pueyari saaja sequeree: —¿Casaarateni? ¡Majaari quenaaja tamonu quia pueyajinijinio cuno sesaraca na quiniu quiquiaari! ¿Casaara naa quia sesojonu paniyarini? ");
INSERT INTO arlNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Cunora, pueyari na que Zacarías shishinioree na nequesotanura taa na sesojonu paniriquiaa neyanuni. ");
INSERT INTO arlNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacaríasri naajiooju casaa maseree na naajionura tii neyanu sesarano. Naajioreeri: “Na sesa, Juan”. ¡Pueyari jiuujiatequee! ");
INSERT INTO arlNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jiyacaritij, Zacarías nitiiri sasaquitiacuhua. Juhuacatecara pocuarohuari. Pueyaso miishano pohuataree pueya niquiaraari, na shuquiritiasacari Pueyaso. ");
INSERT INTO arlNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Cunora, na tia shuriucua quiniaa pueyari jiuujiateree. Puetunu niojuanaari caminiujiushaaquiaari puetunujuanaa cuno Judea tuhuananuhuacua quijiaca pueyara. ");
INSERT INTO arlNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Puetunu nio tojitianaa pueyajanaari niishiriojonuuquiaari. Tama nojorijiaarijia nequesoreetooquiaari: —¿Casaaquitijia cuno mueya quiniutianiya na nuhuajitijiaj? Pueyari niishiquiaari Pueyasoori seetanujuanaa cuno mueyata quiriquiaa, na cumaquiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na que Zacarías jiuujiaari jiyanohua mishaja quiriquiaa Pueyaso Sohuanuta. Pueyaso Sohuanuuri na pohuateree. Naaratej, Zacaríasri naa sequequiaari: ");
INSERT INTO arlNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—¡Jiyanohua maninia pa Jiyaniijia Pueyaso, pa supuetana Israel Jiyaniijia! ¡Cuaara jiyanohua shuquiritiasaaria mijiria na niniuucua na pueyacua, pocuaji na tacunura! ");
INSERT INTO arlNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pocua jiyaroree cumaacaraca pocuaji Tacuriquianoori. Pa Jiyaniijiaranoori Pueyaso seru David niquiohuacuajinio rasaanutaniya, taa Pueyaso sequequiaari tariucuacaanucuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Tariucuacaanu na sequenu panishano caminiujiuniaacuajaari naa pohuataquiaari pa supuetanaa niquiaratej, taa pa paraa na ritianutaniya pocuajini, pa niquiniu paniyaquijia pueyanio. ");
INSERT INTO arlNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nojuajaari sequequiaarijiuhuaj, majaari na niyajetanu quiniutianiya na sequesano pa supuetanaa, pocua na taraajenura. ");
INSERT INTO arlNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Pueyasoori pa supuetana Abraham sequequiaari seetanujuanaa, nojuajanaari pocuaji ritianutaniya pa paraa, pa puereyaquiniutia nera pa poonijionura shitimia. ");
INSERT INTO arlNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nojuajaari Abraham sequequiaarijiuhuaj maninia quijiara pa jataniniutianiyaquiniaari, saaja nera pa quiniuria pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Quiajaniya saniniuujia, quiyanuniyojuanaa, quiaari sesojosaanutaniya Jiyocuacaanu Quinia sequenu panishano caminiujiunia. ¡Quiaari pa Jiyaniijiaranojuanaa puetanutaniya, juhua na nuu jeenucuariquiano! ");
INSERT INTO arlNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Quiocua Pueyaso saquiriojosano pueya niishitiojore, nojoriiri na naata jiyanooshano quiniu sesa nojori miishanojiniji Pueyaso pueya nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","¡Pa Pueyasoori jiyanohua jiyanoojia! Pocua taraajeja. Na jiyarosacari poojia Cuhuatariquiano, nojuajaari pa cuhuatanutaniya, maja ninishiqui pa quiniuria socua. ");
INSERT INTO arlNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Maninia pa cuhuatanutaniyari, maninia pa rucuanejonura Pueyaso niquiara, panaatia poojiacata. Naacuajitij, majaari socua pa cajitiuniu quiniutianiya taraatia ninishiqui, juhua pa jamaca shuriucua. ");
INSERT INTO arlNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Conaajaari maashiquiaari. Nojuajaari tama na cuaqueyajaaja cumaquiquiaari socua seetanujuanaa Pueyasoocua tiuujia na quiniuria. Nojuajaari pueyaracaanu cariiquia jiyajinia quijia quiquiaari nojuaja jaara Pueyaso sequenu panishano caminiujiuniu coteequiaarijiaatijia narta Israel pueya niquiara. ");
INSERT INTO arlNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tiuquinijiona Juan rasaanu nuhuaji, jiyaca jiyaniijiajanaa César Augustoori Roma tiacajiniji sequequiaari puetunu na jiitiasano pueyapuejanaa cuaara serojosaaria puetunu nojori jiyacajiniajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Pueya jaara coteenujuanaa serojosaaquiaari, Cirenio jiyanishano pueyanoori jiyacari Siria jiyajinia jiyaniijia quiquiaari. Nojuajaari jiyaniijiara César Augusto jiyatesano quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Puetunu pueyajanaari sequesaaquiaari nojori cuaara quiojohuara na raja tiacajinia, na sesaca naajiotasaanura tii. ");
INSERT INTO arlNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseeri jiyacari Nazaret tiacajinia quiriquiaa, Galilea jiyajinia. Na raja cutaraari quiquiaari Belén tiacajinia, Judea jiyajinia, tee na supuetana David rasaaquiaaricuaani. Naaratej, Joseeri Belén tiacajinia quiaquiaariuhua. ");
INSERT INTO arlNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Maríari tari sequesaaquiaari nojuaja Joseeta caminiutianiya. Naaratej, Maríari nata quiaquiaarijiuhua Belén tiacajinia, nojori sesaca naajiotasaanura tii. José niquiocuaranoori tariucua manajaraca quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belén tiacajinia nojori quishacari, jiyacari tari quiquiaari María ranu juuca. ");
INSERT INTO arlNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tii jiyapueratereeri. Conaaja jiuniocoquiaari toqueraacuacajiniaari. Na nucuaari na niaquiaari juyaca miaquejajinia. Maríari naa raquiaari cuniqui maja quiquio quishacari nojoriria rucoonaa tiuquijia tiajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén tiaca shuriucua cuno niucuaja, borregohua cojuanaari suteriquiaa cuhuariquiajinia, na seya nojori cojuasacari. ");
INSERT INTO arlNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Canashiyaquiji Pueyaso seruuri nojoriicua muetaquiaari. Jiyaniijia Pueyaso shacantuuca cumaacaari nojori cuhuataquiaari. ¡Nojoriiri jiyanohua shiriiquitiurii! ");
INSERT INTO arlNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pueyaso seruuri nojori sequeree: —¡Maja nia puerenu! Niaacua nimiaanijia, jiyanohua maninia casaa cua pohuatanura niajaniya. Cunora, puetunu pueyajanaari shuquiriniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","¡Niaacuaji Tacunaari tari rasaaree supuetana David tiacajinia! Nojuajaari Pueyaso Jiyarosano, pa Jiyaniijia Cristotuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Niaa jaara nocua quiaare, niaari conaaja riuriatanutaniya toqueraacuacajinia jiuniocosano, juyaca miaquejajinia maano. Naacuajitij, niaari niishiniutianiya, seetanujuanaari cua pohuatasano niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jiyacaritij, narta Pueyaso seyari na cojishii. Jiyanohua queraatia quiriquiaari. Nojoriiri naa maniniuhuaqueetariquiaa Pueyaso: ");
INSERT INTO arlNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—¡Jiyanohua maninia pa Pueyaso, jiyocuacaanu Quijia! ¡Nojuajaari jiyanohua pa shuquiritiasano, na jiyaronuucua jiyacua quiniaa Jiyanoonia! Naacuajitij, cana Pueyaso shuquiritiaani, nojoriiri jiyanootioonutaniya narta pueyata. ");
INSERT INTO arlNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pueyaso seya jaara tacataquiaariuhua jiyocuacaanu na quiquiojiniohua, borregohua cojuanaari tama sequetooquiaarijiaaja: —¡Belén tiacajinia pa quiaarequij! ¡Pa niquishii cuno, casaajiniji pa Jiyaniijia numooteree pajaniyacuajani! ");
INSERT INTO arlNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nojoriiri ritia quiojoquiaari. Conaaja riuriatatuseeri, María, Josénio. Conaajaari juyaca miaquejajinia niasano mariquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nojori niquishacari conaaja, nojoriiri ritia tii quiniaa pueya caminiujiurii conaajajiniji Pueyaso seru pohuatasano nojori. ");
INSERT INTO arlNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Puetunu pueyajanaa, cante nojori pohuatasano tojiriquiaani, nojoriiri jiuujiateree. ");
INSERT INTO arlNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Majaari María niyajetanu quiquiaari puetunu nojori pohuatasanojuanaa. Noojiajinia na niishiriojoriquiaa pueyaracaanuuri. ");
INSERT INTO arlNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Borregohua cojuanaari quiojoquiaariuhua. Nojoriiri Pueyaso maniniuhuaqueetariquiaa nojori tojishanojiniji, nojori niquishanojinijinio. Puetunujuanaari naa quiquiaari taa cuno niucua Pueyaso seru pohuataree nojoricuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","María conaaja jaara ocho juuca jiitiaquiaari, na cararaatiuuquia coori miatesaaquiaari, taa Moisés rootaquiaaricuajani. Na miatesaanu nuhuaji, nojuajaari sesojosaaquiaari “Jesu”, taa Pueyaso seru sequequiaari Maríacuajani, na manajeyaquishacarijia. ");
INSERT INTO arlNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na nuhuaji, Moisés sequesano juucaari quiquiaari na nucua neyacata cuaara juhua tuteera, jeequesano nojori quiniuria Pueyaso niquiara, mueya rasaanu nuhuaji. Naaratej, nojoriiri conaaja Jesu paquiaari Jerusalén tiacajinia, Pueyasora na jiyatesaanura, Pueyasora na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Na queyari naa miiquiaaritij, tariucuacaanu Pueyaso Rupaajinia naajiotasano tojitiajaca nojori quiniuucua. Naajiotasanoori naa quiyatej: “Puetunu nia jiyapueranuhuajanaa cuaara Pueyasora jiyatesaaria”. ");
INSERT INTO arlNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Naaratej nojoriiri quiaaree na seru mosaanura nojoriicuara Pueyaso Secojojua tiajinia, juhua jeequesano nojori quiniuria Pueyaso niquiara, taa pueya rootasaaquiaari Moisés naajiotasanojinijicuajani. Pueyasoori naa sequequiaari Moisés tarijiatej: “Cuaara puecoosaaria caapiqui mococoonu. Mococoonu jaara quiyaquiri, cuaara puecoosaaria caapiqui shinijia”. ");
INSERT INTO arlNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jiyacaritij, tamonu pueyanoori Jerusalén tiacajinia quijia quiriquiaa. Na sesa quiquiaari Simeón. Nojuajaari maninia miijia quiquiaari Pueyaso niquiara. Pueyaracaanu Pueyaso shuquiritiaja quiquiaariiri. Nojuajaari pueyaracaanu sashijia Pueyaso cuaara jiyaroora Israel pueyacuaji Tacuriquiano. Nojuajaari Pueyaso Sohuanu jiitiaja. ");
INSERT INTO arlNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pueyaso Sohuanuuri na niishitiquiaari majaari na shaajenu quiniutianiya nojuaja cuaara niquiri Cristojaatijia, Pueyaso jiyarosaariquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pueyaso Sohuanuuri na jiyatequiaari namitia cuno juuca Pueyaso Secojojua tiajiniara. Naacuajitij, Jesu jaara pasaaquiaari Secojojua tiajinia, nera na miishaanura puetunu tariucuacaanu rootasanojuanaa, Simeónri jiyacari tii na niquirii. ");
INSERT INTO arlNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeónri Jesu paree. Na cacanuureeri. Naa Pueyaso sequeree jiyanohua na shuquiriniutiaari: ");
INSERT INTO arlNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—¡Cua Jiyaniijianaa, tariucuaja! ¡Quiarijia cutara cua naata cusonu juhuajaniya, shuquiriaatia cua quishacari! Quiaacuajaari tari cua niquitirii tarijia quia sequesano janiya, quia seru cua quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tari niquirii quia Jiyarosanocuajanijia, canaacuaji Tacuriquianoni. ");
INSERT INTO arlNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nojuajaari quia niquitiosano puetunu jiyacajinia quiniaa pueyapueecuarajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nojuajaari puetunu taucuaca jiuujiajanaa cuhuatanutaniya, maninia nojori niishiniuria quiajaniya. Naajuhuaj, quia pueya Israelni, nojoriiri tamasaca pueya shuquiritiasano quiniutianiya na seera. ");
INSERT INTO arlNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jesu que, na nucuajuhuaj, nojoriiri jiuujiateree naa Simeón sequesacari conaajajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Na nuhuaji, Simeónri nojoriicua niaree na juaashiquia. Naa sequereeri: —Pueyaso cuaara jiitiaara maninia niajaniya. Jesu nucua María sequereejaariuhuaj: —¡Cua tojiri! ¡Nio conaajaari cutara pueyano quiniutianiya! Queraatia Israel pueyari juhua tiuriiniutianiya nojori ruuretasacari nojuaja. Saniniuujia, queraatia Israel pueyari cumaatia nujuatujuaca quiniutianiya, nocua nojori tiuushacari. Na cumaacata na miiniuucua, pueyari na naata Pueyaso niishiniu maninia. Naajaa, queraatia pueyari na ruuretanutaniya saaja. ");
INSERT INTO arlNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Naacuajitij, tama pueya niishiriojosano noojiacajiniajaarijia niishishaanutaniya. Quiara saniniuujia, jiyanohua taraatiaari quiniutianiya. Quioojiaari juhua mueruuta tohuariquiitishaanutaniya quia mueyacua quia miishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Cuniquijia, Pueyaso Secojojua tiajiniani, tamonu motajaari tii quiriquiaajuhuaj. Cuno motajaari Pueyaso sequesano caminiujiunia quiquiaari. Na sesa quiquiaari Ana, Fanuel niyatu. Nojuajaari supuetana Israel niyanu Aser niquiohuacuajinio supueno maaji quiquiaari. Jiyanohua motaja quiquiaariiri. Shusha niyacoo na quishacari, nojuajaari camiquiaari. Na nuhuaji, siete marijiaari na shocojoquiaari neyacata na quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Neyaca cusonu nuhuaji, socua ochenta y cuatro marijia na shocojoquiaari mashiquio na quishacari. Nojuajaari pueyaracaanu quiquiaari Pueyaso Secojojua tiajinia, Pueyaso na shuquiritiasacari juuca, niucuanio. Nojuajaari sequeyarucua miaqueyaquiquiaari Pueyaso na secojosacari pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón pocuasacarijia, jiyacaritij, Anaari nocua nimiaa. Na niquishacari conaaja Jesu, Anaari noojiajinia niishiquiaari cante nojuajani. Cunora, Pueyaso sequeree na shuquiriniutiaari: “¡Paacarasho!” Na nuhuaji, nojuajaari juhuacatecara Jesujiniji pohuataree Pueyaso Jiyarosocoriquiano sashijiaca pueya niquiara. Nojori sequereeri: —¡Niocuajaari pa sashishano pa pueyacuaji Tacuriquiano! ");
INSERT INTO arlNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jesu queyari puetunu Moisés naajioneejinia Pueyaso rootasanojuanaa tucuataquiaari na conaajara. Na nuhuaji, nojoriiri Galilea jiyajiniara tacatequiaariuhua tama nojori tiacajiniohuajaaja, Nazaret tiacajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naatujua Jesuuri maashiquiaari. Socua cumueecara quiquiaariiri, maninia niishijiaranio. Pueyasoori jiyanohua na naacujua. ");
INSERT INTO arlNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Puetunu marijiarajanaa, Jesu queyari quiojoquiaari Nazaret tiacajiniji, Jerusalén tiacajiniara, Pascua juucajinia nojori queranacunura. ");
INSERT INTO arlNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Doce marijia jaara Jesu shocojoquiaari tari, Jesuuri nojoritia jiyacari quiaquiaari shushajanaa, taa nojori quianu jiitiquiaaricuajani puetunu marijiarajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Queranacunuunu jaara puequequiaari, Jesu queyari quiojoriquiohua juhuajaniya. Jesuuri jiyacari Jerusalén tiacajinia jiyojequiaari. Majaari na queya niishiniu quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nojoriiri jiyaniquiaari Jesu naasucua narta quiojonaa tajinia quiariquiohuajuhuaj. Naacuajitij, nojoriiri juhuajaniya rucuaneree puetunu cuno juucajanaa. Cuno niucuaja, nojoriiri Jesu pajequiaari nojori pueya tajinia, nojori niishishano pueya tajinianio. ");
INSERT INTO arlNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Shaaqui quiriquiaari. Cunora, nojoriiri Jerusalén tiacajinia tacatequiaariuhua, tii na pajenuhuara. ");
INSERT INTO arlNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jiuujianaraca juuca nuhuaji, nojoriiri socua Jesu riuriataquiaari Pueyaso Secojojua tiajinia, Moisés Rootasanojiniji niishitiojonaa pueya tajinia cajiyano. Nojori tojiriquiaari. Nojori nequesoreetariquiaajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Puetunu pueyajanaa, canapuete na tojitiariquiaani, nojoriiri jiuujiatequiaari niishijia Jesu quishacari. Jesuuri maninia nojori riuhuaneriquiaa saaja, nojori jaara na nequesoreeriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na queya jaara na niquiquiaari, nojoriiri shiriiquitiuquiaari. Na nucuaari na sequeree: —Quiyanunaa, ¿casaara naa quia miirii canaani? ¡Janiyari quia queta quia pajeriquiaani jiyanohua canaa tacaaniutia quiocua! ");
INSERT INTO arlNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesuuri na riucuaree: —¿Casaara nia pajeriquiaa janiyani? ¿Majateeri nia niishiniu, janiyari cua Que Secojojua tiajinia quiniuucua jiaatiaani? ");
INSERT INTO arlNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Majaari nojori niishiniu quiquiaari Jesu sequesano. ");
INSERT INTO arlNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesuuri na queyata quiaarohua nojori tiajiniohua Nazaret tiacajinia. Na queya tojijia quiquiaariiri. Na nucuaari pueyaracaanu noojiajinia racataja puetunu na niishishanojuanaa neyanu Jesujiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesuuri socua maashiquiaari, socua niishijiara quiquiaarijiaariuhuaj. Pueyaso shuquiritiasano quiquiaariiri. Puetunu pueyajanaari na shuquiritiaquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Na nuhuaji, Tiuquinijiona Juanri Pueyaso rupaa pohuatanu coteequiaari. Jiyacaritij, quince marijiaari tari shocojoquiaari César Tiberio, jiyaniijiajanaa na quishacari Roma tiacajinia, puetunu jiyaca pueyapuejanaa camarnu na quishacari. Jiyacaritij, Poncio Pilatoori jiyaniijia quiriquiaa Judea jiyajinia. Herodesri saniniuujia jiyaniijia quiriquiaa Galilea jiyajinia. Tarajanu Felipeeri jiyaniijia quiriquiaajuhua Iturea jiyajinia, Traconite jiyajinianio. Lisaniasri jiyaniijia quiriquiaa Abilinia jiyajinia. Puetunu cuno jiyaniijianucuajanaani, nojoriiri jiyaniijianucuara César Tiberio jiyatesano quiquiaari cuno jiyacajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jiyacaritij, Anásri Caifásta Judiocuacaacuara secojonaa jiyaniijianucua quiriquiaa. Jiyacaritij, Zacarías niyanu Juanri cariiquia jiyajinia quiriquiaa. Tii na quishacari, Pueyasoori na rupaa na niishitiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Naaratej, Juanri puetunu Jordán moo shuriuquioco jiyacajanaa tajiquiaari na poojotasacari Pueyaso rupaa pueya niquiara. Nojuajaari naa pohuataquiaaritij: —¡Nioojia nia tacatore maja socua sesa nia miiniuria, moojinia cua tiuquinijionura niajaniya, Pueyaso jiyanooniuria niajaniya sesa nia miishanojiniji! ");
INSERT INTO arlNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Naacuajitij, supuetana Isaías naajiotasanoori tohuateequiaari. Pueyaso sequenu panishano caminiujiunia na quiniuucua, nojuajaari naa miriqui naajiotaquiaari supueriquiano Juanjiniji: “Pueyano rupaari tojishiya cariiquia jiyajinia nacaano. Sequeyari: ‘¡Jiyaniijia nuura nia jeenucuare! ¡Puetunu maniniajanaa nia nuunure, maja shuutiuniu na quiniuria! ");
INSERT INTO arlNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","¡Puetunu tacocuajanaa cuaara mishiquiojosaaria maninia jamatunu na nuu quiniuria! ¡Puetunu tuhuananuhuajanaa cuaara jiuurioosaaria jacananu na nuu quiniuria! ¡Shuyorocotunu nuu cuaara poocuareesaaria! ¡Puetunu surocoshiquiajanaa cuaara mishiquiojosaaria jacananu na nuu quiniuria! ");
INSERT INTO arlNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Naacuajitij, puetunu jiyacajinia pueyajanaari Pueyaso Jiyarosano niishiniutianiya, Pueyaso jiyanootiriquiano pueyani’”. Naa miriqui Isaías naajiotasanoni, cunoori pueya numooteriquiaa juhuacarijia nojori jeenucuanura noojiaca, Jiyaniijia Jesu tojitiajaca nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pueya jaara quiojoquiaari na tiacajiniji Tiuquinijiona Juancua, Juan tiuquinijionura nojori, Juanri naa nojori juaaquiaari: —¡Niaacuajaari juhua sacocua! ¿Cante nia numooteree nia mashiniuria jiyanohua Pueyaso saniitionu panishacari niajaniyani? ");
INSERT INTO arlNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","¡Maninia miijiara nia quiri, canaa niishiniuria niaari seetanujuanaa nioojiaca tacatoree sesa nia miiniujiniji! ¡Majaari najuhuana tama nia cuaqueyajaaja nia sequenu: “Pueyaso pueyanonijia, supuetana Abrahamjinijinio cua supuenuucua”! ¡Nia niishiri, Pueyaso jaara paniri, nojuajaari na naata nio saijiniji shipininiu Abraham niquiohuarajuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","¡Pueyaso cajiiri tari mataa naana pajama, sesa naana nuujutajara! Naana jaara sesa jajau muetujua quiri, nushiyari catijiasocoriquiano. Naajuhuaj, niajaniyari juhua sesa muetuna naana, maninia miyashijia nia quishacari. ¡Niaari quera saniitioshiyacuaja! ");
INSERT INTO arlNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Naaratej, pueyari Tiuquinijiona Juan nequesotaree: —¿Taa canaa miyarinitioj? ");
INSERT INTO arlNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juanri nojori riucuaree: —Cante querajaqueya toqueracani, nojuaja cuaara niquitioora taque cante toqueejuni. Naajuhuaj, cante miaquesanoracani, nojuaja cuaara niquitioora miaquesanoojunucua. ");
INSERT INTO arlNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Roma tiacajinia quijia jiyaniijiajanaa Césarra cumaneeca masejonaari Tiuquinijiona Juancua nijioquiaarijiuhuaj. Nojoriiri tiuquinijiosano quiniu paniriquiaajuhuaj. Naaratej, nojoriiri Juan nequesotaree: —Niishitiojonanaa, ¿canaarijiataj, casaa canaa miyarinijia? ");
INSERT INTO arlNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juanri nojori riucuaree: —Maja puera cumaneeca nia masenu pueyajiniji. Saaja nia jiyaniijia sequesano nia masejore. ");
INSERT INTO arlNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Naajuhuaj, soldadohuari Tiuquinijiona Juan nequesotaree: —¿Canaarijiataj? ¿Casaa canaa miiniutianiyarinijia? Juanri nojori riucuaree: —Niaacuajaari puecootajaraca. Naajaa, majaari pueya casami nia jaariuutianu, nojori nia miananajonuta, nojoriicuara nia tonujusacarijiuhua nia sapojonuta. Juhuajaniya nia quiri saaja nia jiyaniijia niquitiosano cumaneecata. ");
INSERT INTO arlNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pueyari jiyanohua niishiriojoriquiaa Tiuquinijiona Juanjiniji. Nojoriiri Pueyaso sequesano na Jiyarosocoriquiano niquiniuucua jiaatiaja. Naaratej, nojoriiri jiyaniriquiaa Tiuquinijiona Juan naasucua Cristo, tariucuacaanu Pueyaso sequesano na Jiyarosocoriquianotej. ");
INSERT INTO arlNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nocuaji, Tiuquinijiona Juanri puetunu pueyajanaa sequeree: —Janiya nareja nia tiuquinijiya moojiniani, juhua jeequejosano nia quiniuria sesa nia miishanojiniji. Tamonu cutaraari cua nuhuaji niniutianiya. ¡Nojuajaari Pueyaso Sohuanu tiuquinijionutaniya nioojiajinia, na cumaaca nia jiitianura, seetanujuanaa maninia miijia nia quiniuria! ¡Nojuajaari juhua manitia nia saniniujiuniutianiyajuhuaj, maninia jiuujiaraca nia quiniuria! ¡Nojuajaari socua jiyanohua cumaacaraca janiyajiniji! Janiya maara shuquiriaatia quirini, nojuaja jaara cua sequere cua naacutanura nojuaja juhua na seru, quenaaja na sapatu neyocua cua saacatanura. ");
INSERT INTO arlNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Niaari niishiyacuaja taa pueyano miiquiaa na trigoni paratu panura na cocua, na sucuanio, saniniuujia na jajau na racatasocoriquiano tiajiniaaco. Naajuhuaj, cuno pueyanoori tari niya quiya na pueya na saquiriojonura na tojiyashijiaca pueya tajiniji, na rijiosocoriquiano nata nojori quiniuria. ¡Sesa pueyari juhua trigo sucua catijiasaanutaniya saniniuujia! ¡Nojoriiri jatasaanutaniya manijinia! ¡Cuno maniiri maja na maquesanu quiniutianiya! ");
INSERT INTO arlNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tiuquinijiona Juanri naa pohuataquiaari Pueyaso rupaa pueya niquiara. Maninia rupaari, na tojitiajaca pueya quiniuria shuquiriaatia. Socua queraatia quiquiaariiri na pohuatasano na numootenura pueya. ");
INSERT INTO arlNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jiyaniijia Herodesri jiyacari tarajanu Felipe niquiocua jiitiariquiaa necocuara. Cuno maaji sesa quiquiaari Herodías. Tiuquinijiona Juanri jiyaniijia Herodes piriyojoquiaari sesa na miishanojiniji. Herodesri maja na tojiniu quiquiaari saaja. Jiyaniijia Herodesri socua queraatia sesa casaa miijia quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Na nuhuaji, jiyaniijia Herodesri socua sesa miiquiaari: Tiuquinijiona Juan nujuatequiaari nujuatejojuajiniaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tiuquinijiona Juan jaara puetunu pueyajanaa tiuquinijioriquiaajaa, nojuajaari Jesu tiuquiniquiaarijiuhuaj. Jesu tohuatasacari moojiniji, na que Pueyaso secojoriquiaari. Jiyacaritij, jiya cajiniocuaari riatequee. ");
INSERT INTO arlNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pueyaso Sohuanuuri Jesuucua roseyaree juhua mococoonu niquishano. Jiyocuacaanuji, Pueyaso rupaari tojishaaree sequeyano: —¡Quiaacuajaari cua panishano quiyanuniyojua! ¡Jiyanohua quia shuquiritiaanijia! ");
INSERT INTO arlNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Treinta marijia jaara na shoconujuquiaari, Jesuuri na Que Pueyasora poonijionu coteequiaari. Pueyari jiyaniquiaari José naasucua seetanujuanaa na que quiquiaari. Joseeri Elí niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eliiri Matat niyanu quiquiaari. Matatri Leví niyanu quiquiaari. Leviiri Melqui niyanu quiquiaari. Melquiiri Jana niyanu quiquiaari. Janaari José niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseeri Matatías niyanu quiquiaari. Matatíasri Amós niyanu quiquiaari. Amósri Nahúm niyanu quiquiaari. Nahúmri Esli niyanu quiquiaari. Esliiri Nagai niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagairi Maat niyanu quiquiaari. Maatri Matatías niyanu quiquiaari. Matatíasri Semei niyanu quiquiaari. Semeiri Josec niyanu quiquiaari. Josecri Judá niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judaari Joanán niyanu quiquiaari. Joanánri Resa niyanu quiquiaari. Resaari Zorobabel niyanu quiquiaari. Zorobabelri Salatiel niyanu quiquiaari. Salatielri Neri niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriiri Melqui niyanu quiquiaari. Melquiiri Adi niyanu quiquiaari. Adiiri Cosam niyanu quiquiaari. Cosamri Elmadam niyanu quiquiaari. Elmadamri Er niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erri Jesús niyanu quiquiaari. Jesúsri Eliezer niyanu quiquiaari. Eliezerri Jorim niyanu quiquiaari. Jorimri Matat niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatri Leví niyanu quiquiaari. Leviiri Simeón niyanu quiquiaari. Simeónri Judá niyanu quiquiaari. Judaari José niyanu quiquiaari. Joseeri Jonam niyanu quiquiaari. Jonamri Eliaquim niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimri Melea niyanu quiquiaari. Meleari Mena niyanu quiquiaari. Menaari Matata niyanu quiquiaari. Matataari Natán niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natánri David niyanu quiquiaari. Davidri Isaí niyanu quiquiaari. Isaiiri Obed niyanu quiquiaari. Obedri Booz niyanu quiquiaari. Boozri Sala niyanu quiquiaari. Salaari Naasón niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasónri Aminadab niyanu quiquiaari. Aminadabri Admin niyanu quiquiaari. Adminri Arni niyanu quiquiaari. Arniiri Esrom niyanu quiquiaari. Esromri Fares niyanu quiquiaari. Faresri Judá niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judaari Jacobo niyanu quiquiaari. Jacoboori Isaac niyanu quiquiaari. Isaacri Abraham niyanu quiquiaari. Abrahamri Taré niyanu quiquiaari. Tareeri Nacor niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorri Serug niyanu quiquiaari. Serugri Ragau niyanu quiquiaari. Ragauri Peleg niyanu quiquiaari. Pelegri Heber niyanu quiquiaari. Heberri Sala niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salaari Cainán niyanu quiquiaari. Cainánri Arfaxad niyanu quiquiaari. Arfaxadri Sem niyanu quiquiaari. Semri Noé niyanu quiquiaari. Noeeri Lamec niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecri Matusalén niyanu quiquiaari. Matusalénri Enoc niyanu quiquiaari. Enocri Jared niyanu quiquiaari. Jaredri Mahalaleel niyanu quiquiaari. Mahalaleelri Cainán niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainánri Enós niyanu quiquiaari. Enósri Set niyanu quiquiaari. Setri Adán niyanu quiquiaari. Adánri Pueyaso niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu quiasacariuhua Jordán moojiniji, Pueyaso Sohuanuuri noojiajinia quiriquiaa puetunu na cumaacajanaa na jiitianura. Pueyaso Sohuanuuri na jiyatequiaari pueya jiyaqui cariiquia jiyajiniara. ");
INSERT INTO arlNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tii camueenujuquiaariiri cuarenta juuca. Sesaacaari tii na saniniujiuriquiaa. Majaari quenaaja casaa na miaquenu quiquiaari tii na quishacari. Na nuhuaji miaajequiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jiyacaritij, Sesaacaari na sequeree: —Quiaa jaara seetanujuanaa Pueyaso Niyanu quiri, nio saajia quia jataniri neecaruura na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesuuri saaja na riucuaree: —Pueyaso Rupaajiniacuajaari naa naajiotasano quiya: “Pueyanoori maja saminio na quiniu saa miaquesanotaja. Seetanujuanaa saminio quiyari na tojishacari puetunu Pueyaso Rupaajanaa”. ");
INSERT INTO arlNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na nuhuaji, Sesaacaari Jesu jiyataaree jiyanohua jiyaconaja tuhuananuucua. Sesaacaari ritia niquitirii Jesu puetunu mijiria jiyacajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jesu sequereeri: —Janiya quia niquitionutaniya puetunu nio jiyaca jiyaniijianucua cumaacajanaani, maninia jiyaniijiajanaa quia quiniuria mijiria. Janiyari puetunu nio jiyacajanaa niquitiosaaquiaarini. Naacuajitij, janiyari cumaaca niquitioquiaani cana cua niquitionu paniyacuajani, jiyaniijiara na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Puetunujuanaari quiara quiniutianiya, quiaa jaara cucuara mojoquetare quia shuquiritianura janiya. ");
INSERT INTO arlNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesuuri saaja na sequeree: —Pueyaso Rupaajiniacuajaari naa naajiotasano quiya: “¡Quia Jiyaniijia Pueyaso quia shuquiritiare! ¡Saaja nojuaja quia tojiri!” ");
INSERT INTO arlNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Na nuhuaji, Sesaacaari Jesu jiyataaree Jerusalén tiacajinia. Na tacaniriiri Pueyaso Secojojua tia cacojiria, jiyocuacaanu. Jesu sequereeri: —Niiquiji quia jaataare jiyocua, quiaa jaara seetanujuanaa Pueyaso Niyanu quiri. ");
INSERT INTO arlNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pueyaso Rupaajiniacuajaari naa naajiotasano quiya: “Pueyasoori na seya sequenutaniya na cojuanura quiajaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nojoriiri quia quianutaniya, saajiaacua quia jiriataaquiniuucuaji”. ");
INSERT INTO arlNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesuuri na riucuaree saaja: —Naa naajiotasano quiyajaariuhua Pueyaso Rupaajinia: “Maja quia Jiyaniijia Pueyaso quia saniniujiuniu”. ");
INSERT INTO arlNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sesaacaari naa Jesu saniniujiuniu puecaquiaari puetunujuanaa. Majaari quenaaja na naata quiriquiaa sesa na miitiniuria. Naaratej, rupaquijia na tarinitiaquiaari tamacaririaari. ");
INSERT INTO arlNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na nuhuaji, Jesuuri tacatequiaariuhua Galilea jiyajinia puetunu Pueyaso Sohuanu cumaacatajanaa. Puetunu cuno jiyajiniajanaa pueyari Jesujiniji caminiujiutiooquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesuuri Pueyaso secojojua tiajiniaqueya niishitiojoquiaari puetunu tiacajiniajanaa cuno jiyajinia. Puetunu pueyajanaari na timitiaja. ");
INSERT INTO arlNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jiyacaritij, Jesuuri quiaquiaari Nazaret tiacajinia, tee na canashitishaaquiaaricuajani. Samaatenu juuca, Jesuuri Pueyaso secojojua tiajinia tiuquiquiaari taa na jiitiquiaari miiniucuajani. Nojuajaari nujuaquiaari Pueyaso Rupaa serojonura pueya niquiara. ");
INSERT INTO arlNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pueyari na niquitioree tariucuacaanu Pueyaso sequesano caminiujiunia Isaías naajionee jiuniocosano, pueya niquiara na serojosocoriquiano. Jesuuri na saacartaree. Serojonu coteereeri tee nio naajiotasano quiyacuajani: ");
INSERT INTO arlNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Pueyaso Sohuanuuri coojiajinia quiyani, na cumaaca cua jiitianura. Naacuajitij, Pueyasoori cua seeratarucuaa maninia rupaa cua pohuatanura casamiijiuniucua pueya niquiara. Cua jiyaroreejaariuhua Sesaaca quioosano pueya cua pohuatanura maninia rupaa Pueyasojiniji. Naacuajitij, nojoriiri cartesano quiriohua Sesaaca sapojosanojiniji. Cua jiyaroreejaariuhua cariyojuarujuri pueya namijiaa cua jeecanura, maninia niquijiara nojori quiniuhuara. Cua jiyaroreejaariuhua taraatia miitiasusano pueya cua jiyatenura shuquiriaatia quijiacara. ");
INSERT INTO arlNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Cua jiyaroreejaariuhua cua pohuatanura pueya niquiara, quiarijiaari Jiyaniijia Pueyaso jiyanooshacari pueya”. ");
INSERT INTO arlNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Na serojonu nuhuaji, Jesuuri naajionee jiuniocorohua. Na niquitiorohua na cojuanaari. Jesuuri cajiriohua. Puetunu pueyajanaari tacuriitia na shootiaturiquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesuuri juhuacatecara pocuarohua. Naa sequereeri: —Quiarijiani, Pueyaso Rupaajinia nio naajiotasanoori tari tohuateeree nia niquiara. ");
INSERT INTO arlNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Puetunu pueyajanaari jiuujiateree shanohua Jesu pohuatasano nojori tojishacari. Naaratej, nojoriiri maninia pocoojoriquiaa Jesujiniji. Tama nojorijiaarijia nequesoreetooriquiaa: —¿Majate nio pueyano José niyanucuaja, niya pa tiacajinia maashiniotej? ");
INSERT INTO arlNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesuuri nojori sequeree: —Niaa jiyoteeri cua sequenu paniya nio tariucuacaanu sequesano: “Naarajonanaa, tama quia cuaqueyajaaja quia naarajore”. Niaari naa cua sequenu paniya jiyajeneta casaa cua miiniuria cua cumaacata niya tama cua tiacajiniajaajani, taa nia tojiquianucuaja cua miishanojiniji Capernaum tiacajiniacuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesuuri socua sequeree: —Seetanujuanaa nia sequeyanijia, puetunu Pueyaso sequenu panishano caminiujiuniaajanaari tojishoo quijia, tama nojori tiacajiniajaaja. ");
INSERT INTO arlNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Supuetana Elías quishacari, queraatia mashiquiopueeri quiquiaari Israel jiyajinia. Jiyanohua miaajesacari quiquiaariiri maru niyaquishacari pueyaracaanu. Jiuujianaraca marijiaari shocojoquiaari socua seis racanio, maru niyaquishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Naajaa, majaari Pueyaso jiyaronu quiquiaari Elías narta Israel jiyajinia quiniaa mashiquioocua. Pueyaso cutaraari na jiyaroquiaari taatu mashiquioocua Sarepta tiacajinia, Sidón tiaca shuriucua. Naacuajitij, cuno taatu mashiquioori miaquesano jiitiaquiaari pueyaracaanu cutara, Elías na mianuutesacari miaajenu quishacari pueyaracaanu. Elías quiniuucua Pueyasoocua tiuujia, cuno taatu miaquesanoori maja na pueetanu quiquiaari nojoriria. ");
INSERT INTO arlNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Naajuhuaj, supuetana Eliseo quishacari, queraatia leprata cusosuhuari quiquiaari Israel jiyajinia. Majaari quenaaja tamonu nojorijinijinio naatanishaanu quiquiaari Eliseo jiitiasano Pueyaso cumaacata. Saaja cuno tahue Naamánri naatanishaaquiaari cutara, Siria jiyajinijinio pueyanoni. ");
INSERT INTO arlNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pueyaso secojojua tiajinia quiniaa pueya tojishacari naa Jesu pohuatasanotej, puetunu nojorijianaari jiyanohua juaaquioree. ");
INSERT INTO arlNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nojoriiri saneecuatuquee. Jesu caponeeturee nojori tiacajinijiiri. Nojoriiri Jesu jaatucuquiaari socua jiyocuacaanu nojori quijia tuhuananujinijiria, teyanoocua nojori tiaca tiasano quiquiaaricuajani. Nojoriiri na capotunu paniriquiaa juucua tacojiyaji naa na monura. ");
INSERT INTO arlNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesuuri saaja nojori tajiniaaco canujuquiaari juhuajaniya. Quiniquiji tamocora quiaareeri. ");
INSERT INTO arlNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesuuri Capernaum tiacajinia quiaquiaari, Galilea jiyajinia tiaca. Samaatenu juuca, Jesuuri pueya niishitiojoriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nojoriiri jiuujiateree na niishitiojosano nojori tojishacari. Na niishitiojosanoori seetanujuanaa cumaacaraca quiquiaari juhua jiyaniijia niishitiojosano, maja juhua nareja rootasano caminiujiunia. ");
INSERT INTO arlNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pueyaso secojojua tiajinia, samaruraca pueyanoori jiyacari tii quiriquiaa. Na niquishacari Jesu, naa jiyanohua nacareeri: ");
INSERT INTO arlNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Nazaret tiacajinijinio Jesunaa! ¿Taa quia miiniu paniya canaani? ¡Canaa quia niquiri nareja! ¿Quiaate tari niyaree canaa saniitionuucua? ¡Quia niishiyacuajanijia, cante quiajaniyani! ¡Quiaacuajaari sesa miyashijia Pueyaso Niyanu! ");
INSERT INTO arlNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesuuri samaru sequeree: —¡Quia sanaajere! ¡Quia tohuatare nio pueyanojiniji! Samaruuri pueyano pojotequee puetunu pueya niquiarajanaa. Pueyanojiniji tohuataqueeri. Majaari na nuhuajiria sesa na miiniu quirii pueyano. ");
INSERT INTO arlNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Puetunu pueyajanaari shiriiquitiurii. Tama Jesujiniji sequetooreejaarijia: —¡Nia tojiri! ¿Taamueca rupaatucuaanojoni? ¡Nio pueyanoori samaruhua jiyaronu niishiya juhua jiyaniijia! ¡Na rupaari jiyanohua cumaacaraca! ¡Cunora samaruhua tohuataniriiri! ");
INSERT INTO arlNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Puetunu cuno jiyajiniajanaa, Jesu miishanojinijiiri caminiujiushaaquiaari pueya niquiara. ");
INSERT INTO arlNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesuuri Pueyaso secojojua tiajiniji tohuareetaquiaari na pueyata. Quiojiyareeri. Simón tiajinia tiuquitiushiiri. Simón reyarucuaari jiyacari jiyanohua naseeca matariquiaa. Pueyari Jesu sequeree na naataniniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesuuri cusosu caco nujuasee. Jesuuri na naseeca cusonu jiyaroree. ¡Na naseecaari ritia shinitiaquee! Tariucua jiyotuucaari jiyacari sanemaa, na tiajinia quiniaa pueya na mianuutenura. ");
INSERT INTO arlNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pananu tiuquishacari, puetunu pueyajanaa, cante cusosuhua jiitiaquiaarini, nojoriiri na jiyataquiaari Jesuucua. Jesuuri na juaashiquia niaquiaari puetunu cusosuhuacuajanaa. Nojoriiri queraatia tamaatia cusonu jiitiaquiaari. Jiyacari na naatanijioree puetunujuanaari. ");
INSERT INTO arlNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Naajuhuaj, queraatia samaruhuari tohuareetaquiaari cusosuhuajiniji. Samaruhuari naa nacaquiaari Jesuucua: —¡Quiaacuaja Pueyaso Niyanu! Jesuuri nojori juaarii. Majaari na shanacunu quirii nojori pocuanura, nojori mariqui pueya niquiara pohuatareeri, nojuajaari Pueyaso Jiyarosano. ");
INSERT INTO arlNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tariquiicuaji, Jesuuri tiacajiniji quiaquiaari tamaquiicua tamajaaja. Pueyari na pajequiaari. Nojoriiri socua nocua tiuquiijioquiaari na pajenuusacari. Majaari nojori cartenu paniniu quiquiaari Jesu quianura cuniquiji. ");
INSERT INTO arlNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesuuri nojori sequeree saaja: —Janiyari jiyarosaaquiaarini pueyapue niquiara cua pohuatanura quiarinio Pueyaso Rupaa. Quiarijiani, Pueyasoori pueya jiyanooniu paniya, nojori quiniuria na pueya, nojori tiuushacari nocua. Naaratej, janiyari na rupaa pohuatanura quianu paniya tamonu tiacajiniajaniuhuaj. Janiyacuajaari cunora jiyarosaaquiaarini. ");
INSERT INTO arlNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naacuajitij, Jesuuri puetunu Judiocuaca jiyajiniajanaa rucuanejoquiaari Pueyaso rupaa pohuatanura puetunu Pueyaso secojonuujua tiajiniaqueyajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tamacari, Jesuuri caminia casaqueyaji quiriquiaa na pueyata. Jesuuri Pueyaso rupaa pohuatariquiaa. Puera jiyanohua pueyari nocua catecanoquiaari catecaji na tojitianura nojuaja. Nojoriiri Jesu tanuujuriquiaa puera. ");
INSERT INTO arlNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesuuri caapiqui bote niquirii caminia casaqueyaji. Shaama quiriquiaari. Na camaruhuari na shuriucua jeequejonuuriquiaa na shiyaruhua. ");
INSERT INTO arlNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesuuri Simón botejinia tacaquiaari. Simón sequereeri cuaara bote juaariocotaara caminia jiuujiajinia naata. Na nuhuaji, Jesuuri cajirii. Quiniquiji pueya niishitiojonu coteequiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jesu jaara niishitiojonu puecaquiaari, Simón sequereeri: —Queronijinia pa jaaretaare. Niocua tii jartasee nia shiyaruhua sapitiaajara. ");
INSERT INTO arlNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simónri na riucuaree: —Niishitiojonanaa, canaacuajaari tari jaquerootariquiaa najuhuanani. Canaari naajaa nocua juhuaquemaani. ¡Saa shaa quiriquiaanojua! Naajaa, quiaacuaja na sequeya, socua canaa jaquerootarohuacuaraquij. ");
INSERT INTO arlNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nojori jaara socua na shiyaruhua jartaquiaariuhua, ¡jiyanohua queraatia sapitiaaja ritiatureeri! Shiyaruhuari sureequetanu coteequiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nojoriiri jatiqui nata poonijionaa piinioree bote tarajanujinia quiyano, nojori niniuria na naacutanura. Nojoriiri ritia nimiaa. Cuno caapiqui bote mishinijioturee sapitiaajataari. ¡Quera tiuquitiariquiaari queraatia sapitiaajata! ");
INSERT INTO arlNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón Pedro niquishacari naa Jesu miishano nojoririatej, Jesuucuara mojoquetareeri. Jesu sequereeri: —¡Jiyaniijianaa, maja cua rupuenu socua! Janiya puera sesa pueyanoni quia rupuena cua quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simónri shiriiquirii, jiyanohua queraatia sapitiaaja nojori quiasacari. Nata quiniaa pueyari shiriiquitiuriijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Cuno pojoritia quiriquiaajaariuhua Zebedeo niquiohua, Santiago, Juannio. Nojoriiri Simón cojiniaa quiquiaari. Jesuuri Simón sequeree miriqui: —Maja puerenu. Quiaari saniniuujia pueya quioojua quiniutianiya juhua sapitiaaja. ");
INSERT INTO arlNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nojori shiitiasacari, nojoriiri puetunu na casaajanaa tiujiaquiaari Jesuta nojori quiojonura. ");
INSERT INTO arlNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tamonu tiacajinia Jesu quishacari, lepraraca cusosu pueyanoori tii quiquiaari. Na niquishacari Jesu, nocuara jacamareeri. Jesu sequereeri: —Jiyaniijianaa, quiaa jaara paniri, quia naata cua naataniniu cua cusonujiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesuuri na quiaree. Na sequereeri: —Taaquiriirinij. Quia naataniniu paniyanijia. Quia cuaqueya cuaara jeequehuara. Naa na sequesacaritij, na lepraari shaajequee na cuaqueyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesuuri na rootaree maja na pohuatanura na miishano tamasaca niquiara. Na sequereeri: —Saaja pueyacuara secojonaa jiyaniijia quia niquitishii quia cuaqueya, na cartenuhuara quiajaniya, pueya tajinia quia rucuanejonuhuara juhuajaniya. Naajuhuaj, quia seru quia niquitiosee Pueyasoocuara catijiasocoriquiano. Naa quia miiri taa Moisés rootaquiaaricuajani, puetunu pueyajanaa niishiniuria quiaa tari jeequerohua quia cusonujiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Maninia Jesu miishanojinijiiri jiyanohua socua tamaquiicua caminiujiushaaquiaari pueya niquiara. Naaratej, jiyanohua queraatia pueyari nocua nijioquiaari na tojiniuria, mariyata Jesu naatanijionura nojori, nojori cusonujiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesuuri saaja pueya quiyaquishaqui quiaquiaari na Que Pueyaso na secojonura. Nojuajaari naa pueyaracaanu miiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tamonu juuca, Jesuuri pueya niquiara niishitiojoriquiaa. Na tojitianaa tajinia cajitiuriquiaajaariuhua Fariseocuaca, Moisés Rootasanojiniji niishitiojonaanio. Nojoriiri nijioquiaari puetunu Galilea jiya tiacajinijijianaa, Judea jiya tiacajiniji, Jerusalén tiacajinijinio. Jesuuri jiyanohua Pueyaso cumaaca jiitiariquiaa cusosuhua na naatanijionura. ");
INSERT INTO arlNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jiyacaritij, socua pueyari tiuquiijioquiaari. Nojoriiri cumatacuruhuana cusosu patariquiaa na matujinia. Nojoriiri juucua na tiuquitianu paniriquiaa tiajiniaaco Jesuucua. ");
INSERT INTO arlNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Puera queraatia pueya rerejosacari tohuateyaji, majaari na naata cusosu tiuquinitiasaanu quiquiaari. Nocuaji, nojoriiri tia cacojiria tacanitiaquiaari cusosu. Cuno pueya tiaca tucuruuri quiquiaari marauneeca majeetejosano. Nojoriiri tia nijinia papataquiaari. Na nuhuaji, nojoriiri cusosu roshinitiaree cuhuocojiniji na matujinia, Jesu nujuasaqui pueya tajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesu niquishacari taa nojori tiuuriquiaa nocuani, cunora Jesuuri cusosu sequeree: —Pueyanonaa, quiaacuaja tari jiyanooshaaree sesa quia miishanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Naa Jesu sequesacaritij, Moisés Rootasanojiniji niishitiojonaa, mariyata Fariseocuacaari naa niishiriojonuuriquiaa: “¿Cantejaara cuno pueyanoni? ¡Nojuajaari tama na cuaqueyajaaja jiyateya juhua Pueyaso na quiniuria! ¡Pueyanoori maja na naata tamonu pueyano jiyanooniu sesa na miishanojiniji! ¡Saaja Pueyaso cutaraari na naata pa jiyanooniu!” ");
INSERT INTO arlNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesuuri naa nojori niishiriojosano niishiriquiaa. Cunora, nojori sequereeri: —¿Casaara naa nia niishiriojiyani? ¿Niaateeri cucuaji taacanuyajaa? ");
INSERT INTO arlNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Janiyara, maja jiyajeneta cua sequenura: “Quiaari tari jiyanooshaaree sesa quia miishanojiniji”. ¿Jiyajenetatejaariuhua sequenura: “Quia sanere. Quia rucuanere”? ");
INSERT INTO arlNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Cunora, janiyari quiarijia nia niishitiniutianiyani, janiyari mijiria jiyarosaaquiaarini pueya cua jiyanooniuria sesa nojori miishanojiniji. Naacuajitij, Jesuuri cumatacuruhuana pueyano sequeree: —Cua tojiri. ¡Quia sanere! ¡Quia matu quia pataarohua quia tiajinia! ");
INSERT INTO arlNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jiyacaritij, pueyanoori sanequee nojori niquiara. Na tiajinia pataarohua na matuuri. Shuquiriaatia quiariquiohua na tiajiniohuari Pueyaso na maniniuhuaqueetanuta. ");
INSERT INTO arlNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Puetunu pueyajanaari shiriiquitiurii. Nojoriiri Pueyaso maniniuhuaqueetariquiaa cuno maninia casaa nojori niquiniuucua. Nojoriiri na puerenuta naa sequetuquiaarijiuhuaj: —¡Paari quiarijia jiyanohua maninia miishano niquiriini! ¡Nocuaji jiuujiatesano! ");
INSERT INTO arlNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nio nuhuaji, Jesuuri tohuataquiaari. Tamonu pueyano niquiriiri jiyaniijiajanaa Césarra cumaneeca masejosaqui cajiyano. Na sesa quiquiaari Leví. Jesuuri na sequeree: —¡Cua nuhuajiri, cua pueyano quia quiniuria! ");
INSERT INTO arlNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jiyacaritij, Leviiri ritia sanequiaari. Puetunu na jiitiasanojuanaa tiujiaqueeri. Jesuta quiaqueeri. ");
INSERT INTO arlNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na nuhuaji, Leviiri jiyanohua queraatia sumatuquiaari na tiajinia, Jesu na queranacutanura. Queraatia narta cumaneeca masejonaari tii quiriquiaajaacuhuaj. Nojoritia miaquejajinia cajitiuriquiaari, socua tamasaca pueyanio. ");
INSERT INTO arlNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Moisés Rootasanojiniji niishitiojonaa, mariyata narta Fariseocuacaari juhuacatecara Jesu pueyacuara rimiaaquenu coteequiaari. Nojoriiri naa Jesu pueya sequeturee: —¿Casaara cuno sesa pueyata nia miaqueyani, nia ratuyani, tama parta pueya tacartajacatajaajanio? Nojoriiri pa paraa sequera cumaneeca masejonaa. ");
INSERT INTO arlNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesuuri nojori riucuaree: —Cante na cuaqueya jiyaniyani nojuaja maja cusosu na quiniu, nojuajaari maja naarajona na paniniu. Cusosuhua cutaraari naarajona paniya. ");
INSERT INTO arlNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Naajuhuaj, majaari mijiria cua niniu quiquiaari maninia miijia pueyacua. Niquiaari cutaranijia sesa miijiaca cua tacatonuhuara Pueyasoocua, maninia miijia nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pueyari Jesu sequeree: —Tiuquinijiona Juan pueya cutaraari sequeyarucua miaqueyaquiquiaa. Nojoriiri naa Pueyaso secojoquiaa pueyaracaanu. Fariseocuacaari naa miiquiaajuhuaj. Quia pueya saniniuujia, saaja miaquequiaari, ratuquiaari. ¿Casaarateni? ");
INSERT INTO arlNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesuuri nojori riucuaree: —Pueyano camishacari maaji, majaari masuusano pueya miaajenu, camiriquiano pueyano jaara nojoritia quiyajaa. ");
INSERT INTO arlNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tamacari, camiriquiano pueyano jaara jaariutiasaare nojori tajiniji, jiyacariti nojori cutaraari miaqueyaquiniutianiya. Naajuhuaj, janiyari cua pueya tajiniji jaariutiasaanutaniyani. Jiyacariti nojori cutaraari miaqueyaquiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesuuri socua nojori niquiara pohuataquiaari nio miriqui sequesano: —Majaari pueyano miatenu quijia na toque quiariquijiniji, na toque mocua cuhuoco na cushipirijiotajara. Saniniuujia, jaara naa miiritij, na toque quiariqui sesoyari. Quiarinio toquerauri sesoshiyajuhuaj, toque mocuajinia na posequesacari. Cua rupaari naajuhuaj, juhua quiarinio toque. ");
INSERT INTO arlNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Naajuhuaj, majaari na naata quiariniacu uva caaca mishinishaanu shoque tariucuacojinia, tariucuaco shoque mariqui pojuaretareeri, uva caaca jaara jerema vino na quiniuria. Jaara naa miishaaretej, vinoori najuhuana niitiashiya. Shoqueeri najuhuana sesoshiyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Naaratej, maninia cutaraari quiariniacu uva caaca shuujionu shoque quiariquiojinia, maja vino niitiasaanuucuaji, na quiquio shoquenio. Naajuhuaj, nia niishitiojosanoori juhua tariucuaco shoque. ");
INSERT INTO arlNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Naajuhuaj, pueyano jaara vino tariucuanacu ratujua quiri, majaari na paniniu quiariniacu vino. Sequeyari: “Tariucuanacuuri maniniacuaja”. Naajuhuaj, majaari cua niishitiojosano nia paniniu, quiarinio na quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tamonu samaatenu juuca, Jesuuri trigo cuhuariquiajiniaaco quiojoriquiaa na pueyata. Na pueyari trigo carojotariquiaa. Nojoriiri na juaashiquiajinia na shuuquiojoriquiaa na corequetanura. Na nuhuaji, na jajau miojonuuriquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fariseocuacaari na niquitiariquiaa. Nojoriiri Jesu pueya juaarii: —¿Casaara nia tojitiaaquiya Moisés Rootasanoni, taa na sequequiaaricuajani maja pa poonijionura samaatenu juuca? ");
INSERT INTO arlNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesuuri nojori riucuaree: —¿Majateeri nia serojonu quiquiaacuaja casaa supuetana David miiquiaari na miaajesacarini, mariyata na cojiniaa miaajesacarijiuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nojuajaari Pueyaso Secojojua tiajinia tiuquiquiaari. Pueyasora niojosano pan pooquiaariiri. Na sareeri. Mariyata nata quiniaa niquitiojoreeri nojori sanurajuhuaj. Cuno panri sequesaaquiaari saaja pueyacuara secojonaa sasocoriquiano. Naajaa, Davidri na saquiaari. Majaari Pueyaso juaaniu quiquiaari naa David miiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesuuri socua cuno Fariseocuaca sequequiaari: —Janiyacuajaari Pueyaso Jiyarosanoni. Jiyaniijiara jiyatesaaquiaarinijia cua sequenura casaate samaatenu juuca miishiyani, Pueyaso pa shuquiritiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tamonu samaatenu juuca, Jesuuri Pueyaso Secojojua tiajinia tiuquiquiaari. Tii niishitiojoriquiaari. Quiniqui quiriquiaari pueyano, cuseetucojuara joojequetano na juaashiquia miaquetajara. ");
INSERT INTO arlNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Moisés Rootasanojiniji niishitiojonaa, mariyata Fariseocuacaari Jesu shanacutariquiaa. Nocuara tonujunu paniriquiaari Jesu jaara cuseetucojuara joojequetano juaashiquiaraca pueyano jeecare samaatenu juuca. ");
INSERT INTO arlNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesuuri tari niishiriquiaa taa nojori niishiriojoriquiaani. Jesuuri cuno rimiajatucojua pueyano sequeree: —¡Quia sanere! ¡Niya quia nujuasee pueya tajinia! Pueyanoori sanequee. Nujuaseeri tee Jesu sequequiaari na nujuanuracuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesuuri nocuara tonujunu panijiaca pueya sequeree: —Nia nequesotareeraj. Cua sequere, ¿taa pa niishitiojosaaquiaari Moisés Rootasanojinijini? ¿Paate maninia miya samaatenu juucani? ¿Paate sesa miya soj? ¿Cusosuhuate naatanijioshiya, puetushiyajanaa monu soj? ¿Taa nia sequeyani? ");
INSERT INTO arlNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesuuri puetunu na shocuaqueya quiniaajanaa niquinijioree. Na nuhuaji cusosu sequereeri: —¡Quia juaashiquia quia shiitiore! Pueyanoori na juaashiquia shiitioree. ¡Na juaashiquiaari ritia jeequequee! ");
INSERT INTO arlNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Cuno pueyari jiyanohua juaaquioree naa Jesu miishacaritij. Nojoriiri naa pocoojoquiaari tamajaaja: “¿Taa pa miiniutianiya socua cuno Jesuurini?” ");
INSERT INTO arlNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jiyacaritij, Jesuuri tamonu tuhuananuucua quiaquiaari, Pueyaso na secojonura. Puetunu niucuajanaa secojoriquiaa Pueyasoori. ");
INSERT INTO arlNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Jaara juhuaquequiaari, Jesuuri na tojitiajaca pueya sequequiaari nocua nojori nijionura. Puetunu nojorijinijiniojuanaa, Jesuuri nareja doce pueya saquiriojoquiaari. Nojori sesojoreeri, “cua jiyaramiquishocoriquiano pueya”. ");
INSERT INTO arlNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Nioori Jesu saquiriojosano pueya sesaca: Simón. Jesuuri na sesojoquiaarijiuhua “Pedro”. Simón tarajanu Andrésri saquiriojosaaquiaarijiuhuaj, mariyata Santiago, Juan, Felipe, Bartolomé, Mateo, Tomás, Alfeo niyanu Santiago, socua tamonu Simónnio. Nojuajaari Celote maanujiniji pueyano quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiago niyanu Judasri saquiriojosaaquiaarijiuhuaj, Judas Iscariotenio. Nojuajaari quiquiaari Jesu quiateriquiano mosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na nuhuaji, Jesuuri tuhuananujiniji rosetaquiaariuhua na saquiriojosano pueyata, jamatujiniara. Cuno jamatujinia, queraatia na nuhuajiniaa pueyari tari nocuaji quiriquiaa. Mariyata jiyanohua queraatia pueyari tii quiriquiaa puetunu Judea jiyajinijinio, Jerusalén tiacajinijiniojuhuaj, shoniniacu caminia shuriuquiumia quijiacajinijinio pueyanio. Saaja nio pojoriiri quiquiaari Tiro tiacajinijinio, mariyata Sidón tiacajiniji pueyanio. Puetunu cuno pueyajanaari cuniquiria nijioquiaari nojori tojiniuria Jesu, na cusonujiniji nojori naatanijiosaanurajuhuaj. Jesuuri nojori naatanijioree. ");
INSERT INTO arlNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Naajuhuaj, taraatia samaruhua miishano pueyari naatanijiosaaquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Puetunu cusosuhuajanaari Jesu quianu paniriquiaa, naatanijiosano nojori quiniuria. Jesu cumaacaari jiyanohua poonijioriquiaa. Naaratej, puetunu pueyajanaari naatanijiosaariquiaa, saaja nojori quiasacari nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na nuhuaji, Jesuuri na pueya niquirii na pocuanura. Naa sequereeri: —Niaari Pueyaso shuquiritiasano, niaa jaara niishiriquia nioojia saaja sesa miijia. Niaa jaara niishiri nioojia naa quiyatej, niaari Pueyaso jiitiasano pueya quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Niaari Pueyaso shuquiritiasano, niaa jaara maninia miijia quiniuucua jiaatiaa, taa miaajeyano pueyano miaquesanoocua jiaatiaacuaani. Niaa jaara naa quiniuucua jiaatiaa, Pueyasocuajaari nia jataniniutianiya maninia quijiara nia quiniuria. ’Niaari Pueyaso shuquiritiasano, niaa jaara sesa nia miiniu nuhuaji taraajequiaa. Niaari na nuhuaji saroojonutaniya nia shuquiriniutia, niaa jaara jiyanooshaarohua. ");
INSERT INTO arlNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Niaari Pueyaso shuquiritiasano, pueya jaara nia niquiniu paniyaquiri, pueya jaara nia taanuure, pueya jaara nia macaatiri, pueya jaara nia soore cua tojijiaca nia quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Niaa jaara naa miishaaretej, jiyanohua nia timiri. Nia jaacuatare nia shuquiriniutia. Niaa jaara naa nia miishacari rejeretajaca quiri, Pueyasoori nia niishishoo casaa racatasano jiitiaa jiyocuacaanu, na niquitiosocoriquiano niajaniya. Nia paraa supuetanaari naa taraatia miiquiaari tariucuacaanu Pueyaso sequenu panishano caminiujiuniaa pueyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Niaari saniniuujia taraatia quijiaca quiniutianiya, jamuejaca casamiriaca pueyanaa. Niaacuajaari tari shuquiriaatia quiquianu, puetunu nia panishanojuanaa nia jiitiasacari. ");
INSERT INTO arlNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Taraatia quijiacaari niajaniya, cante sequejani: “Janiyacuaja maninia pueyanoni. ¿Janiyatucua casaara paniri Pueyaso jiyanooniuria janiyani?” Naa sequejaca pueyanaa, na nuhuaji, niaari niishiniutianiya niaari saaja sesoriquia pueya seque. ’Taraatia quijiacaari niajaniyajuhuaj, jeya nia quiyaquishacari Pueyasora, saaja tamajaaja shuquiriaatia nia quiniuria nia cojesacari pueyaracaanu. Niaari na nuhuaji sapuenutaniya Pueyasooju nia quishacari pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Taraatia quijiacaari niajaniya, puetunu pueyajanaa jaara maninia pohuataquiaa niajaniyajiniji, maninia nia cojiniuucua cuno pueya, Pueyaso tojiyashijiaca pueyani. Cuno pojori supuetanaacuajaari naa shuquiritiaquiaari cuno sapojonuujuaca, canapuete maja seetanujuanaa Pueyaso sequesano caminiujiuniaa quiquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Niajaniya, cante niya cua tojitiaacuajani, cua tojitiuri. ¡Nia paraa nia paniri! Maninia nia miiri nia niquiniu paniyashijia pueya. ");
INSERT INTO arlNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Saaja maninia nia riucuare nia juayano pueyano. Sesa nia miijiaca pueyacuara nia secojore Pueyaso. ");
INSERT INTO arlNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pueyano jaara quia maseca piri, quia jiyanoori nojuaja. Jaara taquijiria pirijiuhuaj, socua quia jiyanoori. Majaari na naminiu. Pueyano jaara shiniquiaacuaji quia cushishano toque jaariutiare, quia cacojoqui quia niquitiorejuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pueyano jaara quia sequere quia casamijiniji quia niquitionura nojuaja, quia niquitiore nareja. Pueyano jaara quia casaa jaariutiare, majaari na sequenu: “Cua niquitiorohua”. ");
INSERT INTO arlNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Maninia nia miiri tamasaca, taa nia paniquiaa tamasaca miiniuria niajaniyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Niaa jaara saaja nia panijiaca paniriquia, majaari nia jiyaniniu Pueyasoori nia shuquiritiaa naa nia miishacari. Sesa miijiaca pueyari naa paniquiaa nojori panijiacajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Maja puera maninia miijia niajaniya, niaa jaara maninia miiquiaa saaja noo pojori, canapuete maninia miiquiaa niajaniyacuaani. Sesa miijiaca pueyari naa maninia miiniu niishiquiaajuhuaj, noo pojori canapuete maninia miiquiaa nojoricuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Maja puera maninia miijia niajaniya, niaa jaara nia masena niquitioquiaa na panishano, nia niishishacari nojuaja ritia niquitionutaniuhua niajaniyajiniji na masesano casaa. Sesa miijiaca pueyari na casaa rupaquijiara niquitioquiaa narta sesa miijia pueyajuhuaj, na niishishacari nojori ritia niquitionutaniuhua nojori masesano casaa rupaquijiara. ");
INSERT INTO arlNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nia paniri nia paraa. Maninia nia miiri nojori. Nia casami nia niquitiore nareja, pueya jaara na paniya rupaquijiara. Majaari nia taraajenu cuno pueyano jaara nia niquitioyaquiriohua nia casaa. Naa nia miishacaritij, niaari seetanujuanaa Jiyocuacaanu Quijia muerasu. Pueyasoori socua jiyanohua queraatia nia niquitionutaniya tamasaca nia niquitiosanojiniji. Naaratej, capora nia quiri, taa nia Que Pueyasocuaani. Nojuajaari nareja niquitiojoquiaa sesa miijiaca pueya, mariyata canapuete na sequeyashijiacani “paacarasho”. ");
INSERT INTO arlNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Naaratej, jiyanootio nia quiri, taa nia Que Pueyasocuaani, jiyanoojia. ");
INSERT INTO arlNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Maja nia rimiaaquenu tamasacaacuara, Pueyaso mariqui saniniuujia nia jiyanoyaquiriiri. Niaa jaara tamasacaacuara tonujiyashijia quiri, naajuhuaj, Pueyasoori maja na saneenu quiniutianiya sesa nia miishanojuhuaj. Niaa jaara jiyanootio quiri, Pueyasoori nia jiyanooniutianiyajaacuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Niaa jaara tamasaca niquitioquiaa na panishano, Pueyasoori naa nia niquitionutaniya nia panishanojuhuaj, maninia shanacusano, jiuuquiutiasano, maninia quianujusano, mishaja quera niitiyano. Pueyasoori mariyata juhua nia shanacutajajiniaja niquitionutaniya niajaniya, taamueca shanacutajajinia nia niquitioquiaa pueyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesuuri socua niishitiojoquiaari pueya, nio miriqui sequesanota: —¿Cariyojuarute na naata narta cariyojuaru jaatucunu? Naa na jaatucusacari narta cariyojuarutej, nojoriiri mariyata totenutaniya raama. ");
INSERT INTO arlNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Pueyanoori maja socua niishijia na niishitiojonajiniji. Jaara puetunu maninia niishitiojosaarejanaa, saaja jiyacariti niishijia quiniutianiyajaariuhuaj, juhua na niishitiojonaja. ");
INSERT INTO arlNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Casaara nia niquiya rucucua maano quia tarajanu namijiajiniani, niaa jaara puereetuuca maca jiitiaa tama nia namijiajiniajaaja? ");
INSERT INTO arlNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Niaa jaara puereetuuca maca shanacuya tama nia namijiajiniajaaja, ¿niaatucua casaara sequere quiarta pueyanoni: “Cua tarajanunaa, cuno rucucua pa taquiri quia namijiajiniji”? Sesa jiuujiaracanaa, tama nia namijiajinijijiaaja nia pare coteenu cuno maca. Na nuhuaji cutara nia naata maninia niquiniu, cuno rucucua nia taquiniuria nia tarajanu namijiajiniji. Naaratej, majaari nia rimiaaquenu niarta pueyanoocuara. ");
INSERT INTO arlNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Maninia naanaari maja na naata piiquia jajau muetunu. Saniniuujia, sesa naanaari maja na naata shoqueeca jajau muetunu. ");
INSERT INTO arlNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Puetunu naanajanaari maninia niishishano na muetusanojiniji. Majaari pa naata satuna carojonu shuuniajiniji. Naajuhuaj, majaari pa naata tuhuaracona carojotanu saarianajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Naajuhuaj, maninia pueyanoori maninia pocuaa cutara, maninia jiuujiaraca na quishacari. Sesa pueyanoori saniniuujia sacuaraatia rimiaaqueja, sesa jiuujiaraca na quishacari. Casaa pa niishiriojoquiaa poojiajiniani, paari cuno pocuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Casaara nia sequequiaa janiyani, “Cua jiyaniijianaa, cua jiyaniijianaa”, niaa jaara cua rootasano tojitiaaquiquiaa? ");
INSERT INTO arlNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Cua tojiri. Cante cua rupuenara quirii cua rootasano tojijia na quiniuriani, nojuajaari juhua tamonu pueyano cante maninia tiaquiaarini. Cuno pueyanoori coteenu tucuaara jiuutiaquiaari cumueeca jiyajinia na morijiuucuaji. Na nuhuaji, moo jaara pajaashiquiaari, pajaacaari jiyanohua cajiquiaari cuno tiaacua. Naajaa, majaari na mueecurujutanu quiquiaari, maninia nujuatejosano na morijiucua quishacari cumueeca jiyajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Saniniuujia, cante najuhuana cua niishitiojosano tojiyaquiquiaani, na miyaquishacari cua sequesano, cuno pueyanoori juhua tianu niishiyashijia. Cuno pueyanoori sesa tiaquiaari sasaca jiyajinia. Na nuhuaji, moo pajaashishacari, pajaacaari jiyanohua cajiquiaari cuno tiaacua. Cuno tia pojoretaquiaariiri. Pajaari cuno tia niyartaquiaari puetunujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesu jaara pueya niishitiojonu puecaquiaari, na pueyata quiaaree Capernaum tiacajiniaari. ");
INSERT INTO arlNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Romano soldadohua capitánri quiniqui quijia quiquiaari. Jiyanohua na panishano seruuri cusosu matariquiaa. Quera cusoriquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Capitán jaara tojiquiaari Jesujiniji, nojuajaari Judiocuaca camarucua jiyaramiquiquiaari Jesuucua, nojori sequenura Jesu cuaara niiria nocua na seru na naataniniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Judiocuaca camarucuaari Jesuucua quiojoquiaari. Nojoriiri juhuacatecara Jesu secojonu coteequiaari jiyanohua, nojoritia na quianura. Nojoriiri Jesu sequeree: —Cuno Romano capitánri canaa jiyaroreeni, ¡nojuajaari jiyanohua maninia pueyano! ¡Quenaaja quia miiri na panishano! ");
INSERT INTO arlNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nojuajaari parta Judiocuaca panijia. ¡Nojuacuajaari Pueyaso secojojua tiatequiaari canaara tama na cumaneecatajaaja! ");
INSERT INTO arlNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Naacuajitij, Jesuuri nojoritia quiaquiaari capitán tiajiniara. Tari Jesu quishacari cateca na tiaacuara, capitánri na rupuenaa pueya jiyaroquiaari Jesuucua, nojori caminiujiuniuria na sequesano Jesura. Naaratej, nojoriiri naa Jesu caminiujiushii capitán sequesano: —Jiyaniijianaa, capitán naa sequeya: “Cua Jiyaniijianaa, majaari cua taajetenu paniniu quiajaniya. Janiyari maja maninia pueyanoni cucua quia tiuquiniuria cua tiajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nocuaji, majaari cua quianu quiyaree janiyajanaa, cua pajenura quiajaniya. Nareja cuniquiji quia sequere cua seru naatanura. Janiyari niishiyani, quiaa jaara naa sequere, cua seruuri naatanutaniuhua. ");
INSERT INTO arlNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Janiyari niishiyajaaniuhuaj, cuno cusonuuri quia tojiniutianiya taa cua tojiquiaa cua jiyaniijianucuacuaani. Janiyari cua jiyaramiquishano soldadohua jiitiaajuhuaj. Janiya jaara tamonu sequereni, ‘Quia quiaare’, nojuajaari quiaqueequiaa. Janiya jaara tamonu sequereni, ‘Miji’, ritia nimiaquiaari. Janiya jaara cua seru sequereni casaa na miiniuria, ritia na miyari. Niishiyanijia quiaari jiyano cumaacaracajuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesu tojishacari cuno pojori caminiujiushano capitán sequesano, Jesuuri jiuujiateree. Jesuuri na nuhuajiniaa pueya niquinijioree. Nojori sequereeri: —Seetanujuanaa nia sequeyanijia, puetunu parta Israel pueyajinijiniojuanaani, ¡majaari quenaaja cua niquiniu quiquianu Pueyasoocua tiuujia pueyano juhua nio tahue! ");
INSERT INTO arlNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Capitán jiyaramiquishano pueya tiuquiijiosacariuhua capitán tiajiniohua, nojoriiri Capitán seru niquishuhua tariucua naatanohua. ");
INSERT INTO arlNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na nuhuaji, Jesuuri tamonu tiacajinia quiaquiaari. Cuno tiaca sesa quiquiaari Naín. Na pueyari nata quiojoriquiaajuhuaj, socua queraatia tamasaca pueyanio. ");
INSERT INTO arlNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nojori catecanosacari Naín tiacaacua, Jesuuri pueya niquiquiaari macu pataano jamosocoriquiano. Macuuri jiyacunojuanaa na nucua niyanu quiquiaari. Na nucuaari mashiquio quitiasuquiaari. Queraatia pueyari na nucuata macu nuhuaji sacuariquiaa, jamajiniara nojori quiojosacari. ");
INSERT INTO arlNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesu niquishacari mashiquio, nocua taraajereeri. Na sequereeri: —Maja nujuquenu. ");
INSERT INTO arlNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesuuri macuucua catecanoree. Macu quiquio quiatareeri. Na patanaari pootia na nujuataquee. Jesuuri macu sequeree: —Mashajanaa, janiya quia sequeyani: “¡Quia sanere!” ");
INSERT INTO arlNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","¡Macuuri cajiquii! Juhuacatecara pocuareeri. Jesuuri na nucuaacua na jaatucuree. ");
INSERT INTO arlNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Puetunu pueyajanaa jaara naa Jesu miishano niquiquiaari, jiyanohua pueretureeri. Nojoriiri Pueyaso shuquiritiaree jiyanohua. Na puerenuta sequetureeri: —¡Pueyaso sequenu panishano caminiujiuniaqui niya supueree pa tajinia! ¡Jiyanohua cumaacaraca! Nojoriiri naa sequetureejuhuaj: —¡Pueyasoori shusha quiarijia na saquiriojosano Israel pueya niishiriohuacuhuaj, na cumaquiniuria pajaniya! ");
INSERT INTO arlNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jesujiniji pueya pohuatasanoori caminiujiushaaquiaari puetunu Judiocuaca jiyajiniajanaa, mariyata puetunu na shocuaqueya jiyacajiniajanaanio. ");
INSERT INTO arlNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tiuquinijiona Juan pueyari puetunu Jesu miishanojuanaa pohuataquiaari Tiuquinijiona Juan. Na nuhuaji, Tiuquinijiona Juanri caapiqui na pueya sequequiaari: ");
INSERT INTO arlNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","—Jesuucua nia quiaare. Niocua na sequesee: “¿Quiaate seetanujuanaa Pueyaso Jiyarosano, tariucuacaanu sequesano niriquianotej, tamonute sashishiyajaara soj?” ");
INSERT INTO arlNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Naaratej, Tiuquinijiona Juan jiyarosano pueyari Jesuucua quiojoquiaari. Na sequetuseeri: —Tiuquinijiona Juanri canaa jiyaroree quiocuani, canaa nequesotanura quiajaniya: “¿Quiaatena Cristo, Pueyasojiniji niriquianotej, canaate tamonu sashiyajaara soj?” ");
INSERT INTO arlNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nojori tiuquiijiosacari Jesuucua, jiyacaritij, Jesuuri queraatia pueya naatanijioree nojori niquiara; cusosuhua, pueyaracaanu nootunejaca, samaruhuaraca pueyanio. Mariyata queraatia cariyojuarujuri jiyaterohua niquijiacaraari. ");
INSERT INTO arlNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Na nuhuaji, Jesuuri naa Tiuquinijiona Juan pueya sequeree: —Nia quiaarohua. Tiuquinijiona Juan nia pohuatasuhua taa nia niquiriicuajani, nia tojishanonio. Nia sequesuhuanoj: “Cariyojuarujuriiri niquijiacara quiriohua. Shipiiniuquiujiuniaari maninia rucoorohua. Lepra cusotajacaari cushiriitishaarohua juhua juhuanaraja nojori quiniuhuara. Numueejunucuaari tojijiacara quiriohua. Macunucuaari samiitianijiosaarohua. Casamiijiuniucua pueyari Pueyaso rupaa pohuatasaaree, Pueyaso pueyara nojori jiyatesaanura. ");
INSERT INTO arlNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Shuquiriaatia quijia cutaraari nooj, cante cucua tiuuniu tarinitiaaquiyani”. ");
INSERT INTO arlNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tiuquinijiona Juan jiyarosano pueya jaara quiojoquiaariuhua, Jesuuri juhuacatecara pueya pohuataree Tiuquinijiona Juanjiniji. Jesuuri naa nojori nequesotaree: —¿Casaa niquiniuucua nia quiojocanu cariiquia jiyajiniani? ¿Niaate noojia niquijioteja niquiniuucua quiojocanu? ¿Tiuquinijiona Juante juhua paratu piyarojosano naajua jiyareta na tacarojosano? Majaruhua. ");
INSERT INTO arlNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Casaa niquiniuucua nia quiojocanunitioj? ¿Niaate maniniuqui toque cushijia niquiniuucua quiojocanu? Niaacuajaari niishiya, shanohua toqueya cushiyonuujuacaari saaja jiyaniijianucua tiajinia quiyano niquishano. Nojoriiri tama na panishanojuaaja miijiaca. ");
INSERT INTO arlNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Taateerinitioj? ¿Casaa niquiniuucua nia quiojocanuurini? ¿Pueyaso sequenu panishano caminiujiuniate quiquianu? Taaquiriirinij. Nia niquishano pueyanoori seetanujuanaa socua tojishano pueyano puetunu Pueyaso sequenu panishano caminiujiuniajinijijianaa. ");
INSERT INTO arlNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Cuno Juanjinijicuajaari tariucuacaanu Pueyaso Rupaajinia naajiotasano quiquiaari. Pueyaso sequesano nojuajinijiiri naa naajiotasaaquiaaritij: “Cua sequenu panishano caminiujiuriquiano jiyaroyanijia, na puetanura quiajaniya, nuu jeenucuariquiano quiocuaji”. ");
INSERT INTO arlNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Seetanujuanaa nia sequeyanijia, puetunu Pueyaso sequenu panishano caminiujiuniaajinijiniojuanaani, majaari tamonu socua cutara pueyano quiniu quiquiaari Tiuquinijiona Juanjiniji. Naajaa, cante Pueyaso muerasuniyojua quiya cucua na tiuushacarini, Pueyasora, nojuajaari socua cutara pueyano Tiuquinijiona Juanjiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Puetunu pueyajanaa, mariyata cumaneeca masejonaa Roma tiacajinia quijia jiyaniijiarani, nojoriiri niishiquianu Tiuquinijiona Juan pohuatasano Pueyasojinijiiri seetanu rupaajanaa quiquianu. Naaratej, nojori tacatosacari nojori jiuujia sesa nojori miishanojiniji, nojoriiri moojinia tiuquinijiosaacanu. ");
INSERT INTO arlNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","’Saniniuujia, Fariseocuaca, mariyata Moisés Rootasanojiniji niishitiojonaani, nojoriiri Tiuquinijiona Juan pohuatasano ruuretacanu saaja. Naacuajitij, majaari nojori tiuquinijiosaanu quiquianu, nojori seetanuucua nojoriiri sesa miijiacajuhuaj. Nojoriiri Pueyaso miiniu panishano nojoriria soocanu saaja. Naacuajitij, majaari nojori jiyanooshaanu quiquianu. ");
INSERT INTO arlNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesuuri socua sequeree: —¿Quiarijia nio pa quishacari pueyarijiataj? ");
INSERT INTO arlNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nojoriiri juhua naatujoori, na tacuarishijionu panishacari, na cajitiushacari tiaca jiuujiajinia cajitiucuara curotasanojinia. Nojoriiri narta naatujooriicua nacaa: “Canaari juucua naajua jonenejiyani. Majaari nia nianujunu paniniu. Canaari taraatia jaaquequejosano jaaquequejiyani. Majaari nia sapuenu paniniujiuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Naajuhuaj pueyanaa, niaari Tiuquinijiona Juan tojiyaquiquianu Pueyaso rupaa na pohuatasacari nia niquiara. Nojuaja cutaraari miaquesano miaqueyashijia quijia, vino ratuyashijianio. Naaratej, niaari na sequeja, “samaruraca”. ");
INSERT INTO arlNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Na nuhuaji, janiyari niquianuni. Janiyari saniniuujia miaquesano miaquejojuani, vino ratujuajuhuaj. Cunora niaari cua sequequiaa: “Cunoori sacuaraatia miaquejoru, ratunu porocuanio, sesa miijiaca rupueja sacuaraatia, mariyata pa soosano cumaneeca masejonaa rupuenanio”. Naa nia sequesacaritij, niaari cua tojitiaaquiyajaacuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Naajaa, pueya jaara canaa pohuatasano tojijiaca quiri, jiyacari cutara nia naata niishiniu canaa niishitiojosanoori seetanujuanaa Pueyasojiniji, cua tojijiaca jatasacari maninia quijiacara. ");
INSERT INTO arlNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tamonu Fariseo pueyanoori Jesu masuuquiaari na tiajinia na miaquenura. Jesuuri na tiajinia quiaaree. Miaquenuujua shuriuquiumia roshishiiri. ");
INSERT INTO arlNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Paanatuuri cuno tiacajinia quijia quiquiaari. Na niishishacari Jesuuri cuno Fariseo tiajinia tiuquirii miaquenura, nojuajaari cuno tiajinia quiaquiaarijiuhuaj. Shiitianiyojua seesariquiaja pataconiyojua cacatariquiaari, cohuaja saajiajiniji quejasano. Mishaja quiriquiaari shanohua jaanutajata. ");
INSERT INTO arlNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Maajiiri Jesu cashacuucuma mojoquetasee. Nujuqueriquiaari. Na namijiaacaari Jesu niohuacaacua totejoriquiaa. Naa Jesu niohuaca piquiojoreeri. Na nuhuaji, na muecacata na sacuanijiarohuari. Na niohuaca nujuureeri. Na shanohua jaanutaja totaree Jesu niohuacaacuaari. ");
INSERT INTO arlNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Cuno Fariseo pueyano niquishacari naa cuno maaji miishanotej, noojiajinia niishiriojoriquiaari: “Jesu jaara seetanujuanaa Pueyaso sequenu panishano caminiujiunia quiri, mariqui niishiri cante na coyani, taamueca maajitijianojoni”. ");
INSERT INTO arlNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesuuri cuno Fariseo pueyano niishiriojosano niishiriquiaa. Cunora na sequereeri: —Simónnaa. Quia sequenu paniyanijia. Fariseo pueyanoori Jesu riucuaree: —Cua sequere, Niishitiojonanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesuuri na sequeree: —Caapiqui pueyanoori cumaneeca masequiaari rupaquijiara tamonu cumaneeca niquitiojonajiniji. Niquiriyatu pueyanoori queraatia cumaneeca masequiaari, juhua quiniento juuca poonijiosanojiniji masesano. Tamonu pueyanoori masequiaari nareja juhua cincuenta juuca poonijiosanojiniji masesano. ");
INSERT INTO arlNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na nuhuaji, nojori sequesano juuca jaara tari quiquiaari na camaru nojori niquitionuhuara na cumaneeca, majaari nojori jiitianu quiquiaari cumaneeca. Naaratej, cumaneeca niquitiojonaari nojori sequeree: “Naajaa, maja socua nia niishiriojonu nia niquitionuhuara tarijia cua niquitiosano cumaneeca niajaniya”. Cumaneeca niquitiojonaari naa cuno caapiqui pueya jiyanooquiaari. Simónnaa, cua sequeretoj, ¿teyano cuno caapiqui pueyanojinijiniote socua cuno cumaneeca niquitiojona panijiara quiniutianiyani? ");
INSERT INTO arlNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simónri Jesu riucuaree: —Cunocuajani, cante socua queraatia cumaneeca niquitiosaaquiaaricuajani. Jesuuri na sequeree: —Taaquiriirinij. ");
INSERT INTO arlNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jiyacaritij, Jesuuri cuno maajiicua tacateree. Simón sequereeri: —¿Quiaate nio maaji niquiya? Cua tiuquishacari quia tiajinia, majaari quenaaja quia niquitionu quirii mohuaca janiya, cua niohuaca cua jeequetajara. Nio maaji cutaraari cua niohuaca jeequeree na namijiaacata. Na sacuanijiarohua na muecacataari. ");
INSERT INTO arlNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Majaari quenaaja quia nujuunu quirii janiya, quia saruhuatasacari janiya. Nio maaji cutaraari cua niohuaca nujuunequejoriquiaa pueyaracaanu, niya cua cajishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Naajuhuaj, majaari quia totanu quirii muesu nunacu cua nacaacua. Nio maaji cutaraari cua niohuacaacua totaree shanohua jaanutaja. ");
INSERT INTO arlNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Naaratej cua tojiri. Nio maajiiri jiyanohua sesa miijia quiriquiaa. Naaratej, jiyanohua cua paniyari puetunu sesa na miishanojinijijianaa cua jiyanooniuucua nojuaja. Saniniuujia, cante secaja sesa na miishanojiniji jiyanooshaareeni, naajuhuaj, nojuajaari secaja panijia na jiyanoonia. ");
INSERT INTO arlNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Na nuhuaji, Jesuuri cuno maaji sequeree: —Quiaacuajaari tari jiyanooshaaree sesa quia miishanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Narta masuusano pueya nata cajitiuyanoori juhuacatecara tama sequetooreejaaja: —¿Cantucuaa nio pueyanoni, sesa miijia jiyanooriquianoni? ");
INSERT INTO arlNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesuuri maaji sequeree saaja: —Cucua quia tiuushacari, quiaacuajaari tari jiyanooshaaree. Juhuajaniya quia quiaarohua. ");
INSERT INTO arlNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Na nuhuaji, Jesuuri rucuanejoquiaari queraatia tiacajinia, shiitianiyojua tiacajiniajuhuaj. Nojuajaari tii Pueyaso rupaa pohuatariquiaa, taa Pueyaso jiitianu paniya na muerasuni. Na doce saquiriojosano pueyari na cojiriquiaajaacuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Noojiaqueya maajipohuari na tarajariquiaajuhuaj. Cuno maajipohuari tamaatia cusonujiniji Jesu naatanijiosano quiquiaari. Tii quiriquiaajaariuhua noo maajipohua, Jesu nojorijiniji tohuatanijioquiaari samaruhuatej. Nojorijinijinioori quiquiaari María Magdalena. Jesuuri cuno Maríajiniji tohuatanijioquiaari siete samaruhua. ");
INSERT INTO arlNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Quiriquiaajaariuhua Juana, Cuza niquiocuani. Cuzaari jiyaniijia Herodes jiitiasano casami cojuana quiquiaari. Susaanaari nojorijinijinio quiquiaarijiuhuaj. Socua queraatia maajipohuari quiriquiaa. Puetunu cuno maajipohuajanaari Jesu naacutaquiaari tama nojori jiitiasano casaatajaaja. Nojoriiri nera pueraquenuunaa quiquiaarijiuhuaj, tiquiyocua nojori rucuanejosacari Jesuta. ");
INSERT INTO arlNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Queraatia cuno jiya tiacajinijinio pueyari nijioquiaari nojori niquiniuria Jesu. Jaara nocua rerequeejoquiaari queraatia pueya, Jesuuri nojori niishitiojoquiaari miriqui, nio pohuatasanota. Nojori sequereeri: ");
INSERT INTO arlNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Tamonu pueyanoori na cuhuariquiajinia quiaquiaari natoojonuucua. Na jacutasacari, secajaari totequiaari nucuaco. Tii rapijiosaaquiaariiri. Shuhuari na miojoquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tajaacaari toteree sai tajinia. Cuno jajau jaara moritiaquiaari, ritia sorereeri puera joojuashiqui na quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tajaacaari toteree riyocuaca tajinia. Riyocuacaari socua ritia maashiquiaari. Na natasanoori tarinitiucuara quirii. ");
INSERT INTO arlNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Socua tajaacaari maninia jiyajinia toteree. Tii maashiquiaari maniniaari. Queraatia mueturee cutaraari. Noojiaqueya cuno nataujinijiiri cien jajau quiquiaari niquiriyatu jiyonajiniji. Nio pohuatasano na puecasacari, Jesuuri na rupaa paaretaree. Naa sequereeri: —¡Niaa jaara numaaraca quiri, nia tojitiare cua pohuatasano! ");
INSERT INTO arlNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na nuhuaji, Jesu pueyari na nequesotaree casaa na miriqui pohuatasano niishitiojonu paniyani. ");
INSERT INTO arlNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesuuri nojori riucuaree: —Niaari saquiriojosaaquiaari nia niishiniuria taa Pueyaso poonijiya pueya jiuujiajiniani, na muerasura nojori quiniuria. Cunoori tariucuacaanu pueya niishishoo. Janiyari tamasaca pueya niquiara pohuataquiaa miriqui cutarani. Naacuajitij, nojoriiri cua pohuatasano niishiyaquiquiaa na tojitiasacari. Naajuhuaj, cua cumaacata cua miishano cariyoshitiuquiaari, nojori niquiara cua miishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Nia niishitiojoreera miriqui cua pohuatasano natoojonajiniji. Pueyano natoojosano jajauri juhua Pueyaso rupaa. ");
INSERT INTO arlNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pueyano jaara Pueyaso rupaa tojiri najuhuanaj, nojuajaari juhua nucuaco toteno jajau. Sesaacaari nimiaa. Pueyaso rupaa na tojishano jaariutiarohua noojiajinijiiri, maja nocua na tiuuniuria, nojuaja mariqui jiyanooshaareeri. ");
INSERT INTO arlNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sai tajinia toteno jajauri juhua noo pueya, canapuete Pueyaso rupaa tojiriini. Na nuhuaji, rupaquijia Pueyasoocua tiuuquiaa shuquiriaatiaari. Naa miijiacaari juhua puera shiitianiyojua nujuacaraca. Naacuajitij, nojori jaara saniniujiushaare, nojoriiri ritia Pueyasoocuaji rupatequiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Riyocuaca tajinia toteno jajauri juhua noo pueya, canapuete maninia tojirii Pueyaso rupaani. Na nuhuaji, nojoriiri puera tacaaquiaa mijiria casaacua, casamiriaca nojori quiniuria, tama na cuaqueyajaaja nojori shuquiritiniuriajuhuaj. Naaratej, nojoriiri juhua muetuhuo natau quiya, tarinitiucuara riyocuaca tariyoshitishano. ");
INSERT INTO arlNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Maninia jiyajinia toteno jajauri saniniuujia juhua noo pueya, canapuete maninia tojitiareecuaja Pueyaso rupaani. Na racataa maninia noojiajiniaari. Pueyaracaanu na tojitiaquiaari. Majaari na pishiniu Pueyasoocuaji. Naacuajitij, nojoriiri juhua queraatia muetujua natau. ");
INSERT INTO arlNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Majaari pueya noshitiniu quiquiaa samaritiu, na jamotasocoriquiano conatu cariquiaco, maquetu cariquiaconio. Samaritiu jaara noshitishaare, morijiuucua morotashiyari na cuhuatanura, pueya tiuquitiasacari tiajiniaaco. Naajuhuaj, Pueyaso Rupaari pueya jiuujia cuhuataja. Cunora, Pueyaso Rupaa cuaara maatia pohuatasaaria puetunu pueya niquiarajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Puetunu jamojosano casaajanaari riuriatasaanutaniya. Puetunu jiyasohuaja nia miijiosanojuanaari niishishaanutaniyajuhuaj. Cuhuatasaanutaniyari maninia niquishocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Cunora, cua sequesano tojitiajaca nia quiri maninia. Cante maninia jiitiaa cua rupaani, nojuajaari socua na niishijiara jiyatesaanutaniya. Saniniuujia, cante cua rupaa tojiyashijiani, secaja najuhuana na niishishanoori jaariutiasaanutaniya, puetunu shaaquiriajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jiyacaritij, Jesu nucua Jesu tapueyocuacata tiuquiijioquiaari Jesu quishaqui. Majaari nojori naata tiuquitianu quiriquiaa Jesuucua. Jiyanohua queraatia pueyari nocuara ritiariquiaa saaja tia tohuateyaji. ");
INSERT INTO arlNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tamonuuri Jesu numooteree: —Quia nucua quia tarajanuhuata jati carijiniacuma quiya. Quia niquitiuniu paniyaquinia. ");
INSERT INTO arlNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesuuri tii quiniaa niquiara sequeree saaja: —Canapuete seetanujuanaa Pueyaso Rupaa tojitiajacani, nojoriiri cua nucua cutara, cua tarajanuhuanio. ");
INSERT INTO arlNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tamonu juuca, Jesuuri botejinia tacataquiaari na saquiriojosano pueyata. Nojori sequereeri: —Pa niuutiaare caminia taquijiria. Naaratej, nojoriiri niuutiariquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nojori niuutiasacari, Jesuuri maqueriquiaa. Canashiyaquiji paratuuri juhuacatecara piyarojonu coteeree jiyanohua. Mohuaca queyaqueteriquiaa bote jiniacumaraari. Boteeri quera tiuquitiariquiaa tari. ");
INSERT INTO arlNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jiyacaritij, na pueyari Jesu niucuajasee ritia. Na sequetuseeri: —¡Niishitiojonanaa! ¡Niishitiojonanaa! ¡Paa tari tiuquitiaani! Jesuuri sanemaa. Paratu sequereeri, mohuacanio: —¡Tariucuaja! ¡Nia suraajere! Paratu, mohuacaari ritia suraajequee. Paratu piyarojonuuri tajimiaa, caminia queyocuaanonio. ");
INSERT INTO arlNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesuuri na pueya sequerohua: —Niaacuaja juucua Pueyasoocua tiuujiaca. ¿Casaa nia tojetareerini? Nojoriiri Jesuucuaji jiuujiatecoree. Shiriiquitiuriquiaari Jesu miishano nojori niquishacari. Tama nojorijiaarijia nequesoreetooriquiaa: —¿Cantucuaanojoni? ¡Paratu, mohuacaari na tojirii na sequesacari! ");
INSERT INTO arlNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na nuhuaji, nojoriiri shiitiaseequiaari Gerasa jiyajinia, Galilea jiya taquijiria. ");
INSERT INTO arlNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesu jaara rosequiaari botejiniji, jiyacaritij, samaruhuaraca pueyanoori nocua niquiaari, cuno jiya tiacajinijinio pueyano. Cuno pueyanoori pueyaracaanu samaruhuaraca quiquiaari. Majaari toque na cushiniu quijia. Naajuhuaj, majaari tiajinia na quiniu quijia. Saaja raacajinia quijiaari, macunucua nucuhua paaquiosaqui. ");
INSERT INTO arlNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na niquishacari Jesu, na cariquimiaji mojoquetaseeri. Jesuucua nacareeri: —¿Casaara quia niyaree miji canaa quia cushitionurani Jesunaa? ¡Quia niishiyanijia! ¡Quiaacuajaari Jiyaniijiajanaa Pueyaso Niyanu! ¡Cua tarinitiare quenaaja! ¡Maja naquiya cua miiniu! ");
INSERT INTO arlNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Samaruhuaraca pueyanoori naa sequeriquiaa Jesutej, Jesu sequesacari tari nojuaja, cuaara tohuataara cuno pueyanojiniji. Samaruuri sequeyarucua cuno pueyano miitiquiaari sesa. Narta pueyari juucua na cashacucua, na numatucua morojoquiaari cumayocua jiyocua shipinishanota, na cojuasaanura maninia. Samaruhuaraca pueyanoori saaja na turojotaquiaari. Samaruuri na mashiquijia tiquiyocua, pueya quiyaquishaqui na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jiyacaritij, Jesuuri na nequesotaree: —¿Taateja quia sesani? Samaruuri na riucuaree: —Cua sesa “Queraatia”. Naa Jesu sequequiaariiri jiyanohua queraatia samaruhua na jiitiasacari. ");
INSERT INTO arlNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Samaruhuari jiyanohua secojoree Jesu, maja nojori na jiyaronura puequeetuuju raama saniitiosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jiyacaritij, queraatia cushiyari miaquenuuriquiaa cateca naataja, tuhuananujinia quiniqui. Samaruhuari cunora Jesu secojoree nojori na tiuquitianiniuria cushiyajinia. Jesuuri nojori tarinitiaree. ");
INSERT INTO arlNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Cunora, samaruhuari pueyanojiniji tohuareetaquee. Cushiyajinia tiuquitiaseeri. Puetunu cushiyajanaari cocuateree. Tacojiniji totesee caminiajiniaari. Tii shushiniuuriiri. ");
INSERT INTO arlNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cushiya cojuanaa jaara niquiquiaari naa miishanotej, nojoriiri netecuatuquiaari na shiriiquiniutia, Jesu miishano nojori pohuatanura tiacajinia, cuhuariquiacajiniajuhuaj, tee pueya quiriquiaacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Puetunu pueyajanaari Jesuucua nijioquiaari na tiacajiniji, pueya pohuatanuusanojiniji nojori niquiniuria. Nojori tiuquiijiosacari Jesuucua, nojoriiri cuno pueyano niquishii, canajiniji samaruhua tohuareetareecuajani. Nojuajaari Jesu shuriucua cajiriquiaa toqueraca, panaatia na quishacariuhua. Naa pueya niquishacari nojuajatej, pueretuquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jiyacaritij, Jesu miishano niquitiuniaari shusha nijiono pueya pohuataree taa samaruhuaraca pueyano naatanishaarohuani. ");
INSERT INTO arlNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Cunora, puetunu Gerasa jiyajinijinio pueyajanaari jiyanohua puereturiquiaa. Naaratej, ¡Jesu secojotureeri na quianura nojori jiyajiniji! Naaratej, Jesuuri botejinia tacataquiaariuhua na pueyata na quianuhuara. ");
INSERT INTO arlNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Cuno pueyano, canajiniji samaruhua tohuareetareecuajani, nojuajaari Jesu secojoree juucua nata na quianura. Jesuuri saaja naa na sequeree: ");
INSERT INTO arlNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Quia tiajinia quia quiaarohua. Quia pueya niquiara quia pohuatasuhua taa Pueyaso miirii maninia quiajaniyani. Pueyanoori quiaarohua. Puetunu na tiacajiniajanaa pohuatasuhuari taa Jesu miiriucuaa maninia nojuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesu jaara niuutiaquiaariuhua caminia taquijiria na pueyata, pueyari na timitiarohua na tiuquishacariuhua. Puetunu nojorijianaari na sashiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jiyacaritij, tamonu pueyanoori Jesuucua tiuquishii. Na sesaari quijia Jairo. Nojuajaari Pueyaso secojojua tia jiyaniijia quiquiaari cuno tiacajinia. Jesu cariquimiaji mojoquetaseeri na secojonura na tiajinia Jesu quianura. ");
INSERT INTO arlNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Neyatuniyojuaari quera cusoriquiaa jiyacari. Majaari socua niquiohuaraca na quiniu quijia. Doce marijiaari tari shocojoquiaari cuno neyatu. Jesu quiasacari Jairota, jiyanohua queraatia pueyari nata quiojoriquiaajuhuaj. Pueyari jiyanohua na tanuujuriquiaa, nata nojori quiojosacari nucuaco. ");
INSERT INTO arlNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tamonu maaji cusosuuri cuno pueya tajinia quiriquiaajuhuaj. Doce marijiaari tari na shocojoquiaari pueyaracaanu na naatesacari. Cuno maajiiri puetunu na cumaneeca puecaquiaarijianaa najuhuanaj, na naarajosaanura juucua. Naarajonaari maja na naata na naataniniu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Maaji cusosuuri Jesu nijiniji catecanoquiaari nocua. Na tucuaque toque casaca quiasee jiyasohuari. ¡Na nanacaari ritia curetaquee! ");
INSERT INTO arlNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jiyacaritij, Jesuuri pueya nequesotaree: —¿Cante cua quiareeni? Puetunu na shocuaqueya pueyajanaari sequeree: —Maja canaa quianu quirii quiajaniya. Pedroori Jesu sequeree: —Niishitiojonanaa, ¿majateeri quia niquiniucuaja? Queraatia pueyacuajaari quia tanuujiya. ");
INSERT INTO arlNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesuuri saaja sequeree: —Maja. Cusosu cua quiareeni. Niishiyanijia cua cumaacaari tari na naatanirii. ");
INSERT INTO arlNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Maaji niishishacari na miishano jiyasohuaja tari niishishaaree, Jesuucua nimiaari. Na puerenuta tetecariquiaari. Jesu cariquimiaji mojoquetaseeri. Puetunu pueya niquiarajanaa pohuatareeri casaara Jesu na quiareeni. Pohuatareejaariuhuaj taa na naataquee ritiani, Jesu na quiasacari. ");
INSERT INTO arlNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesuuri na sequeree: —Sanaunaa, cucua quia tiuuniuucua, quiaari naatarohua. Quioojia quia cajitiriohua. Juhuajaniya quia quiaarohua. ");
INSERT INTO arlNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesu pocoojosacarijia cuno maajitia, tamonu pueyanoori tiuquiquiaari Jairo tiajiniji. Jairo sequeseeri: —¡Quia niyatu tari cusoquee! Maja najuhuana riniu paniniu Niishitiojona quia tiajiniara. ");
INSERT INTO arlNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesu tojishacari cuno pueyano sequesano, Jairo sequereeri: —Maja puerenu. Cucua quia tiuuri saaja. Quia niyatucuaja naatanutaniuhua. ");
INSERT INTO arlNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesu tiuquishacari Jairo tiajinia, nojuajaari maja na shanacunu quirii quenaaja tamonu pueyano tiuquiniuria macuucua. Saaja nata tiuquitiamaa cutaraari Pedro, Santiago, Juan, maaji samiriu que, na nucuanio. ");
INSERT INTO arlNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Puetunu tii quiniaa pueyajanaari maaji samiriuucua nujuqueturiquiaa. Sapiyonuuriquiaajaariuhuaj. Jesuuri nojori sequeree: —Maja najuhuana nia nujuquenu. Maaji samiriu maja macu, nareja maqueyano. ");
INSERT INTO arlNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Naa Jesu sequesacaritij, pueyari na saroojotaree saaja. Nojoricuajaari niishiriquiaa maaji samiriuuri seetanujuanaa macu quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jiyacaritij, Jesuuri macuucua tiuquiquii. Na juaashiquiajiniji na quiaseeri. Jiyanohua na sequereeri: —Maaji samiriuniaa, ¡quia sanere! ");
INSERT INTO arlNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na sohuanuuri nocua tacatemohua jiyacari. Samiitiamohuari. Ritia sanequeeri. Jesuuri na nucua sequeree na mianuutenura. ");
INSERT INTO arlNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na queyari jiyanohua jiuujiateree. Jesuuri nojori sequeree, maja nojori pohuatanura tamasaca niquiara na miishano. ");
INSERT INTO arlNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesuuri na doce saquiriojosano pueya rerejotequiaari na jiyaramiquishocoriquiano. Nojori niquitioree cumaacaari, puetunu tamaatia sesa samaruhuajanaa nojori tohuatejonura, cusosuhua nojori naatanijionurajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nojori jiyaramiquiriiri Pueyaso rupaa nojori pohuatanura pueya niquiara, pueya niishiniuria taa Pueyaso jiyanooniu paniya nojorini, na muerasu nojori quiniuria. Nojori jiyaramiquiriijiaariuhua cusosuhua nojori naatanijionura. ");
INSERT INTO arlNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesuuri nojori sequeree: —Maja nia panu nia rucuanejotajara nia panishano. Majaari nia miojotu nia panu, nia caashoque, nia coseyaca, nia cumaneecanio. Saa nia cushishano toquetaja nia quiaare cutara. Maja socua toque nia panu nia cushishocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Niaa jaara tamonu tiajinia tiuquishiiquia, niocua cuniqui jiyojetaseequiaja, niaa jaara cuno tiacajiniji quiaarejaatijia. ");
INSERT INTO arlNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Niaa jaara tamonu tiacajinia tojiniu paniyaquishaare, cuno tiacajiniji nia quiaare. Nia nuhuajiria, cuno pueya niquiara niocua nia niohuacajiniji cuno tiaca jaaquia nuutare. Naacuajitij, cuno pueyari niishiniutianiya, Pueyasoori nojori jiyanoyaquiniutianiya, nojori tojitianu paniyaquiniuucua Pueyaso rupaa pohuatanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na nuhuaji, Jesu pueyari quiojoquee puetunu cuno jiyajinia shiitianiyojua tiacajiniajanaa, Pueyaso rupaa nojori pohuatanura tii. Nojoriiri Pueyaso rupaa pohuatanuuquiaari pueya jiyanooshaanura, Pueyaso pueya nojori quiniuria. Naajuhuaj, cusosuhua naatanijiotuquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jiyaniijia Herodesri pohuatasaaquiaari puetunu Jesu miishanojinijijianaa. Herodesri saaja jiyajenequiaari cante Jesuni. Jiyacaritij, noojiaqueya pueyari sequeriquiaa: “Jesucuajaari jiyaniijia Herodes nacatanishano Tiuquinijiona Juan samiitianohua”. ");
INSERT INTO arlNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tamasaca pueyari Jesujiniji sequeriquiaajuhuaj: “Supuetana Elíascuaja tari tiuquiriohua”. Nojuacuajaari tariucuacaanu Pueyaso sequenu panishano caminiujiunia quijia. Saniniuujia, tamasaca pueyari sequeriquiaajuhuaj: “Jesucuajaari tamonu tariucuacaanu Pueyaso sequenu panishano caminiujiunia samiitianohua”. ");
INSERT INTO arlNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodesri saniniuujia sequeree: —Janiyacuajaari cua pueyano jiyarocanu Tiuquinijiona Juan na nacatanurani. ¿Cantejaara cuno Jesuni? Janiyari queraatia nocuaji tojiniuyani. Cunora, Herodesri jiyanohua Jesu niquiniu paniriquiaa juucua. ");
INSERT INTO arlNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesu jiyaramiquishano pueya tacatesacariuhua, nojoriiri Jesu pohuataquiaari puetunu nojori miishanojuanaa. Na nuhuaji, Jesuuri nojori jiyataaree tamaquiria, Betsaida tiaca shuriucua, tii tamajaaja nojoritia na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pueya niishishacari tee Jesu quiriquiaani, nojoriiri saaja nocua quiojoquiaari. Naajaa, Jesuuri maninia nojori maseree saaja. Cuno pueya pohuatareeri taa Pueyaso quiniu paniya nojori jiyaniijiarani. Jesuuri nojori cusosuhua naatanijioreejuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tenacariishacari, Jesu doce pueyari nocua catecanoquiaari. Na sequetureeri: —Pueya quia jiyaramiquiri cateca tiacajinia, nojori cuaara cuniqui pajenuura na miaquenuusocoriquiano, na maquetujuarajuhuaj. Nojori panishanoori shaaqui niya pa quishaquini. ");
INSERT INTO arlNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesuuri nojori sequeree saaja: —Niaa mariqui nojori mianuutere saniya. Nojoriiri Jesu sequeturee: —¿Canaateeri miaquesanoracajaarani? Canaa saaja cinco panniyojua jiitiaani, caapiquiriyatu sapitiaajanio. ¿Canaateeri secaja pa cumaneecata masenutaniya queraatia miaquesano puetunu nio pueyarajanaani? ");
INSERT INTO arlNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Cuniqui nojoritia quiriquiaa naasucuaari cinco mil pueya. Jesuuri na pueya sequeree: —Pueya nia raquiriojotare maninia. Cuaara cajitiuuria cincuenta jatiqui, socua cincuenta tamaqui. Mianuutesocoriquiano puetunu pueyajanaa, cuaara naa cajitiuuriatej. ");
INSERT INTO arlNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nojoriiri Jesu sequesano miirii. Puetunu pueyajanaari cajitiurii. ");
INSERT INTO arlNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Na nuhuaji, Jesuuri cuno cinco pan pataree, caapiqui sapitiaajanio. Jiyocuacaanu maureeri na Que Pueyaso na secojonura miaquesanoocuara. Na nuhuaji na neecasereeri. Na pueya na niquitioreeri puetunu pueyajanaa nojori serotasocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Puetunu pueyajanaari na miaquenuuree. Maninia tooquioreeri. Na nuhuaji, doce canaasatuuri mishinijiosaaquiaari pan raacuata, sapitiaaja raquiquiatanio. ");
INSERT INTO arlNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tamacari, Jesuuri Pueyaso secojoriquiaa tamajaaja. Na saquiriojosano pueyari nata quiriquiaa. Jiyacaritij, Jesuuri nojori nequesotaree: —¿Taa pueya sequequiaa janiyani, cantena janiyani? ");
INSERT INTO arlNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nojoriiri na riucuaree: —Noojiaqueya pueyari quia sequequiaa, quiaana nacatasano samiitianohua Tiuquinijiona Juan. Tamasacaari quia sequequiaajuhuaj, quiaana Elías, tariucuacaanu Pueyaso sequenu panishano caminiujiunia. Tamasacaari saniniuujia quia sequequiaa, quiaa naasucuana tamonu tariucuacaanu Pueyaso sequenu panishano caminiujiunia samiitianohua. ");
INSERT INTO arlNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesuuri saniniuujia nojori nequesotaree: —¿Niajaniyariuhuaj? ¿Taa nia sequeyani, cante janiyani? Pedroori na sequeree: —Quiajaniyacuajaari Cristo, Pueyaso Jiyarosano. ");
INSERT INTO arlNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesuuri jiyanohua nojori rootaree maja nojori pohuatanura tamasaca niquiara cante nojuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesuuri naa nojori sequerohuacuhuaj: —Janiyari jiyanohua naquiya miishaanutaniyani. Pa Judiocuaca camarucuaari cua niquiniu paniyaquiniutianiya, na tojitianu paniyaquishacari janiya. Naajuhuaj, pa pueyacuara secojonaa jiyaniijianucuaari cua niquiniu paniyaquiniutianiya, Moisés Rootasanojiniji niishitiojonaanio. Nojoriiri cua monutaniya. Naajaa, jiuujianaraca juucajinia, janiyari samiitianutaniuhuani. ");
INSERT INTO arlNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na nuhuaji, Jesuuri puetunu pueyajanaa sequeree: —Cante cua nuhuajiniu paniyani, cua pueyano na quiniuria, nojuaja cuaara niyajetaara tama na miiniu panishanojuaaja. Cuaara panitiaara tama na cuaqueyajaaja puetunu juucajanaa, cua tojijia na quiniuria seetanujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Saniniuujia, cante tama na cuaqueyajaaja shuquiritiniuria niishiriojoquiaani, nojuajaari jiyanohua taraatia quiniutianiya na nuhuaji. Saniniuujia, cante tama na cuaqueyajaaja panitiaquiaa cua panishano na miiniuriani, nojuaja cutaraari Pueyaso pueyanora jiyatesaanutaniya, pueyaracaanu shuquiriaatia na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pueyano jaara puetunu nio jiya casamijianaa jiitiana quiri, cuno maara najuhuana quiri, nojuaja jaara na shaajesacari jatasaare mani quiquiojinia Pueyasooju. ");
INSERT INTO arlNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Cante cua seera caririquiya mijiria quiniaa pueya niquiara sequenurani, janiyari nojori jiyaniijiani, naajuhuaj janiyari nojori seera caririquiniutianiyani cua tiuquishacariuhua Jiyaniijia cua quiniuria. Janiyari shanohua niquishano quiniutianiya cua tiuquishacariuhua cua Que shacantuuca cumaacatani, na seya cumaacatajuhuaj. Naajuhuaj, cante cua rupaa pohuatanu caririquiya sesa miijiaca pueya niquiarani, janiyari nojori seera caririquiniutianiyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Seetanujuanaa nia sequeyanijia, noojiaqueya niajaniyajinijinioori maja nia cusonuunu quiniutianiya juhuanojuaja, niaa cuaara niquirijiaatijia Pueyaso cumaaca tiuquiyano cucua, na muerasu jiitiariquianoni. ");
INSERT INTO arlNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Naa Jesu sequenu nuhuajitij, ocho juuca nuhuaji, nojuajaari tuhuananuucua tacaquiaari na Que Pueyaso na secojonura. Nata quiaareeri Pedro, Santiago, Juannio. ");
INSERT INTO arlNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesu secojosacari Pueyaso, na jiquiocoori tamaatiara jataquiaari. Na toqueeri jiyanohua cohuajara jataquiaarijiuhuaj, shacantuquera. ");
INSERT INTO arlNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jiyacaritij, caapiqui pueyari nocua muetaquiaari. Jesuta pocoojoriquiaari. Nojoriiri quiriquiaa supuetana Moisés, supuetana Elíasnio. ");
INSERT INTO arlNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nojori nujuatusaquiiri shacantuuca quiriquiaa puetunu nojori shocuajanaa. Nojoriiri pocoojoriquiaa taa Jesu mosaanutaniya Jerusalén tiacajiniani. ");
INSERT INTO arlNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Jiyacaritij, Pedroori jiyanohua maquenuujuriquiaa, nata quiniaajuhuaj. Naajaa, majaari nojori maquenu quiriquiaa. Naacuajitij, nojoriiri Jesu shacantuuca niquiquiaari. Cuno caapiqui supuetanaa niquitiuriijiaariuhuaj, Jesuta pocoojiyano. ");
INSERT INTO arlNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cuno caapiqui pueya quiojonu panishacariuhua Jesu shuriucuaji, Pedroori Jesu sequeree najuhuanaj: —¡Niishitiojonanaa, canaa namitia niya quiyani! ¡Canaa suhuororeera jiuujianaraca suhuorotucua; quiara, Moisésra, Elíasranio! Pedroori naa najuhuana pocuariquiaa. Majaari na niishiniu quiquiaari casaa na sequeriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro pocuasacarijia, cohuaja najacaari nojori mishiquiomaa. Nojoriiri puereturiquiaa cohuaja najacajinia nojori quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na nuhuaji, nojoriiri Pueyaso tojirii pocuaano cuno cohuaja najacajiniji. Naa sequereeri: —¡Nioori cua Niyanu, cua saquiriojosano nia Jiyaniijia na quiniuria! ¡Nojuaja nia tojitiare! ");
INSERT INTO arlNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Naa nojori tojiniu nuhuaji cuno rupaatej, nojoriiri Jesu niquiriohua. Tari tamajaaja nujuariquiaari. Nojoriiri sanaa na niquitiariquiaa. Na nuhuaji, majaari quenaaja tamonu nojori pohuatanu quiquiaari nojori niquishano, Jesu jaara samiitiaquiaariuhuajaatijiaj. ");
INSERT INTO arlNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tariqui, nojori jaara rosetaquiaariuhua tuhuananujiniji, queraatia pueyari Jesuucua nijioquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Cuno pueya tajiniji, tamonu pueyanoori naa nacaquiaari: —¡Niishitiojonanaa, cucua quia taraajere quenaaja! ¡Cua niyanuniyojua quia niquiri! ¡Jiyaniojuanaari quiyanuniyojua! ");
INSERT INTO arlNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","¡Samaruuri na miiquiaa taraatia! ¡Na sariyotequiaari! ¡Na taquiriocuatequiaajaariuhuaj! ¡Na rupaamajiiri cushaaquiaa! ¡Na cuaqueya miiquiaa moquitiuriuriaari! Majaari ritia na cartenu paniniu quiquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Janiyari juucua quia pueya sequereeni, cuno samaru nojori tohuatenura. Majaari nojori naata quiriquiaa na tohuatenura. ");
INSERT INTO arlNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesuuri sequeree: —Pueyaso tojitiaashijiacanaa, niaaqui Pueyasoocua tiuyashijiacajuhuanajaj. ¿Janiyateeri pueyaracaanu rejeretanutaniya niajaniyani? Miji quia niyanu quia jaatucure. ");
INSERT INTO arlNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Caya samijia catecanosacari Jesuucua, samaruuri na pojotequee. Na taquiriocuatereeri. Jesuuri samaru sequeree na tohuatanura. Caya samijia naataniriiri. Na niquitiorohua na queeri. ");
INSERT INTO arlNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Puetunu pueyajanaari jiyanohua jiuujiateree nojori niquishacari Jesu miishano Pueyaso cumaacata. Pueya jiuujiatesacarijia puetunu Jesu miishanojinijijianaa, Jesuuri na pueya sequeree: ");
INSERT INTO arlNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Maninia nia tojiri casaa cua sequenutaniya niajaniyani. Majaari na niyajetanu. Janiyari niquitiosaanutaniyani pueya miiniuria janiya taa nojori paniyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Majaari na pueya niishiniu quiriquiaa Jesu sequesano. Juhua miriqui sequesanoori quiriquiaa nojoriria. Naacuajitij, majaari nojori naata niishiniu quiquiaari. Nojoriiri Jesu nequesotanu puereturiquiaajuhuaj, casaa nojori na pohuatasano sequenu paniriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesu pueyari juhuacatecara juayonuutariquiaa teyano nojorijinijiniote jiyaniijiajanaa quiniutianiyani. ");
INSERT INTO arlNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesuuri nojori niishiriojosano niishirii. Naaratej, Jesuuri naatujua nujuateree na shuriucua. ");
INSERT INTO arlNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Na pueya sequereeri: —Cante nio mueya rupueya na cumaquiniuria cucua tiuujia cuno mueya quiniuucuani, nojuajaari cua rupueyajuhuaj. Cante cua rupueyani, cua Jiyarona rupueyajaariuhuaj. Naacuajitij, cante tama na cuaqueyajaaja jiyateya pueya shocoteyashijia na quiniuria juhua naatujuani, nojuajaari jiyaniijiajanaa quiniutianiya puetunu narta Pueyaso muerasujinijiniojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juanri Jesu sequeree: —Niishitiojonanaa, canaari pueyano niquiriucuaani samaruhua tohuatanijiyano quia cumaacata. Canaari na tenujurucuaani nojuaja quiyaquiniuucua pajaniyajinijinio. ");
INSERT INTO arlNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesuuri na riucuaree: —¿Casaara nia tenujurucuaarinioj? ¿Niaateeri niishiyaquiya, cante pa paraca quiyaquiyani, nojuajaari pa jiyano? ");
INSERT INTO arlNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Quera Jesu tacanu panishacari jiyocuacaanu, nojuajaari juhuacatecara Jerusalén tiacajiniara quiaaree, juhua jiuujiaaju na puereyaquiniutia. ");
INSERT INTO arlNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jerusalén tiacaacuara nuu cajiniocua Samaria jiyajinia Jesu quishacari na pueyata, noojiaqueya na pueyajinijinio puerateree tamonu tiacajinia nojori masenura tia nojoriicuajiiri. Naacuajitij, na pueyari Samaria jiyajinia quijia shiitianiyojua tiacajinia quiojoquiaari tii Jesu maquejara nojori pajenura. ");
INSERT INTO arlNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Cuno Samaria pueya jaara niishiquiaari Jesuuri Jerusalén tiacajiniara quiariquiaa, majaari nojori paniniu quirii Jesu maquenura nojori tiacajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Santiago, Juan niishishacari cuno Samaria pueyari nojori sooriquiaa, nojoriiri cunora Jesu nequesotaree: —Jiyaniijianaa, ¿quiaate paniya canaa tininiuria mani jiyocuacaanuji, cuno pojori na catijianura, taa tariucuacaanu Pueyaso sequenu panishano caminiujiunia Elías miiquiaaricuaani? ");
INSERT INTO arlNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesuuri nojoriicua tacateree. Nojori nacasureeri naa nojori saniitionu panishacari cuno Samaria pueya. Naa nojori sequereeri: —Majaari nia niishiniu cana sohuanute naa nia niishiriojoteyani. Nia niishiri, majaari cua niniu quiquiaari mijiria cua puecoonura pueya. Saaja niquiaari cutaranijia, pueyacuaji cua tacunura. ");
INSERT INTO arlNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na nuhuaji, nojoriiri tamonu shiitianiyojua tiacajinia quiojiyaree tii maquenura. ");
INSERT INTO arlNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nojori quiojosacari nucuaco, tamonu pueyanoori Jesu sequequiaari: —Jiyaniijianaa, quia pueyanora quiniu paniyanijia. Janiyacua quia tarajareni puetunu tiquiyocua quia rucuanejosacarijianaa. ");
INSERT INTO arlNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesuuri na riucuaree: —Quioojuapueeri na raaca jiitiaa cutara. Shuhuari na jesuhua jiitiaajuhuaj. ¿Saniniuujia Pueyaso Niyanuurijiataj? Majaari cua jiitianu tama cua maquejarajaaja. ");
INSERT INTO arlNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesuuri tamonu pueyano sequeree: —Cua nuhuajiniara quia quiri. Nojuajaari saa sequereeja: —Cuaara Jiyaniijianaa. Cua que cuaara cua niquiara shaajeerajaara. Janiya jaara na jamoreni, janiyacua na nuhuaji quiata rucuanejore cutarani. ");
INSERT INTO arlNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesuuri na riucuaree: —Naajaa, quia tarinitiare. Cua tojitiaashijiacaari juhua macunucua. Naaratej, cuno macunucua cuaara jamoora tama narta macujuaaja. Quia rucuanejore cutara Pueyaso rupaa quia pohuatanura. ");
INSERT INTO arlNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na nuhuaji, tamonu pueyanoori Jesu sequeree: —Jiyaniijianaa, janiya cutara quiata quianu paniyani. Coteenu cua tiajinia quiquiooraj, cua pueya cua niquiniuria cua nuhuajiria. ");
INSERT INTO arlNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesuuri miriqui na riucuaree: —Pueyano jaara na juyaca poonitijiya, jiya jiacataja na jayotanura na cuhuariquia na jeenucuanura, maja cumaati na nijiniara na niquiniu. Na camaru jaara na nijiniara niquiri, sesa naaniutianiyari shuyorocotiuyocuara. Naajuhuaj, cua pueyano jaara na quiquiojinia tacatenu panijiohua quiri, nojuajaari maja maninia Pueyasora poonijiona. ");
INSERT INTO arlNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nio nuhuaji, Jesuuri socua setenta y dos pueya saquiriojoquiaari, nojori puetanura nojuaja, puetunu Israel pueya tiacajiniajanaa Pueyaso rupaa nojori pohuatanura. Jesuuri nojori nuhuaji tii quianu paniriquiaajuhuaj. Puetunu nojorijianaa jiyaramiquiriiri caapiqui, caapiqui. ");
INSERT INTO arlNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nojori nuhuajiria, Jesuuri nojori rootaree nio miriqui sequesano: —Queraatia Pueyaso muerasuranoori quiya, juhua senoosocoriquiano. Saniniuujia, secaja na senoonaari quiya. Cunora, cuhuariquia camaru nia secojore, socua senoonaa na jiyaramiquiniuria puetunujuanaa na senoosaanura. ");
INSERT INTO arlNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nia quiojiyare pueyanaa. Nia niishiri, janiyari nia jiyaramiquiya juhua borrego niquiohuani puereeta sareya tajinia. Pueyaso paraari juhua puereeta sareya. ");
INSERT INTO arlNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nia quiojosacari, majaari nia caashoque nia patanu, nia cumaneeca quiquiojuhuaj, nia sapatunio. Majaari nucuaco nia tarishiniu pueya nia saruhuatasacari. ");
INSERT INTO arlNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tamonu tiajinia nia tiuquishacari, coteenu nia saruhuatare na camaru nio sequesanota: “Juhuajaniya nia quiri, nio tiajinia quiniaanaa”. ");
INSERT INTO arlNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Cuno tiajinia quiniaa pueya jaara jiyanoojiaca quiri, naa nia sequesacaritij, Pueyasoori nojori miiniutianiya maninia. Nojori jaara juaajiaca quiri saniniuujia, Pueyasoori nojori shuquiritiyaquiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tee nia masesaareni, cuno tiajinia nia jiyojere. Nia miaquere, nia rature nojori niquitiosano niajaniya. Nia pohuatanuucua Pueyaso rupaa nojori niquiara, niajaniya cuaara niquitiosaaria nia panishano. Majaari tamasaca tiajinia nia pacunujunu tii nia miaquenura. ");
INSERT INTO arlNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nia tiuquiijiosacari tamonu tiacajinia, pueyano jaara nia masuure na tiajinia nia quiniuria, niocua niaara nojori rupojosano miaquere. Majaari na soonu. ");
INSERT INTO arlNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Cusosuhua nia naatanijiore cuno tiacajinia. Pueya niquiara nia sequere: “Pueyasoori quiarijia nia jiyatenu paniya na muerasu nia quiniuria”. ");
INSERT INTO arlNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nia tiuquishacari tamonu tiacajinia, pueya jaara tii nia tojiniu paniyaquiri, niocua cuno tiaca nuucuajinia naa nacare pueya niquiara: ");
INSERT INTO arlNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Nia tiacajinijinio jaaquiani, canaari canaa niohuacaacuaji na majiriuutiaani. Cunoori nia niishiniuria, Pueyaso jaara nia saniitiore, majaari canaacua na tiuutiasaanu quiniutianiya. Pueyasocuajaari nia jiyanooniu paniriquiaa juucua, na muerasu nia quiniuria”. ");
INSERT INTO arlNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Seetanujuanaa nia sequeyanijia pueyanaa, Pueyaso saniitionu juuca jaara quiri, cuno tiacajinia quiniaari socua jiyanohua saniitiosaanutaniya Sodoma tiacajinia quiniaa pueyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Corazín tiacajinia quiniaa pueyanaa, mariyata Betsaida tiacajinia quiniaa pueyanaa! Cua tojiri. ¡Niaari jiyanohua saniitiosaanutaniya! ¡Niaari socua Pueyaso tojiyashijiaca quiya cuno tariucuacaanu Tiro tiacajinia quiniaa pueyajiniji, Sidón tiacajinia quiniaa pueyajinijinio! Cuno pueya jaara Pueyaso cumaacata miishano niquiquiaari, taa cua miiquianu nia tiacajiniacuaani, nojori maara ritia noojia tacatoquiaari cutara, sesa nojori miishanojiniji. Cuno tiacajinijinio pueya maara cocuaque toqueya cushiyonuuquiaari, nojori taraajesacari sesa nojori miiniuucua. Naajuhuaj, nojori maara juaca niojoquiaari nojori nacaacua quera nojori macaashacari, sesa miijiaca nojori quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Niaa cutaraari cua cumaacata cua miijiosano niquijiaca. Naajaa, majaari nioojia nia tacatonu quiquianu Pueyasoocua. Naaratej, Pueyaso saniitionu juucajinia, ¡niaari socua jiyanohua saniitiosaanutaniya Tiro tiaca pueyajiniji, Sidón tiaca pueyajinijinio! ");
INSERT INTO arlNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Niajaniyarijiataj, Capernaum tiacajinia quiniaa pueyanaa, ¿niaateeri jiyaniya niaari jiyocuacaanu quiniaara jiyatesaanutaniya? ¡Maja! ¡Niaari puequeetuuju raama quejoosaanutaniya saniya! ");
INSERT INTO arlNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Cua pueyanaa, cante nia tojitiajacani, nojoriiri cua tojitiajacajuhuaj. Naajuhuaj, cante nia ruuretaa cua rupaa nia pohuatasacarini, nojoriiri cua ruuretaajuhuaj. Cante cua ruuretaani, nojoriiri cua Jiyarona ruuretaajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesu jiyaramiquishano setenta y dos pueyari Jesuucua tiuquiijioquiaariuhua. Nojoriiri jiyanohua shuquiriaatia quiriquiaa. Jesu sequetureeri: —¡Jiyaniijianaa, samaruhuari canaa tojitiacanuni canaa tohuatanijiosacari nojori, canaa jiyaniquishacari quia sesa! ");
INSERT INTO arlNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesuuri nojori sequeree: —Taaquiriirinij. Janiyari Sesaaca niquiquianuni juhua niaco tiyano jiyocuacaanuji. ");
INSERT INTO arlNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Janiyacuajaari cua cumaaca nia niquitiocanuni, juhuajaniya nia rucuanenura sacocua caco, turucuaniiniu caconio. Cua cumaacata, niaari puetunu Sesaaca cumaacajanaa shocotanutaniya, juhuajaniya panaatia nia rucuanejonura, cua rupaa nia pohuatanura. Majaari quenaaja tamonu casaa miiniu quiniutianiya naquiya niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Naajaa, majaari saaja shuquiriaatia nia quiniu samaruhua tojitianuucua niajaniya. Shuquiriaatia nia quiri cutara nia sesaca naajiotasano quishacari jiyocuacaanu, Pueyaso muerasu sesaca naajiotasaqui. ");
INSERT INTO arlNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jiyacaritij, Pueyaso Sohuanuuri Jesu shuquiritirii jiyanohua. Cunora, Jesuuri na Que Pueyaso sequeree: —¡Quia shuquiritiaanijia cua Quenaa! ¡Quiaacuajaari Jiyaniijiajanaa quiya jiyocuacaanu, mijirianio! ¡Quiaari maninia miirii! Cua pueyari juhua naatujoori, maja puera niishijiaca. Naajaa, quiaari quiarijia nojori niishitirii quia niishishano, quia jamosano mijiria niishijiacaacuaji. Jaa, cua Quenaa, quiaacuajaari naa nojori panitiaja. ");
INSERT INTO arlNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Cua Queeri tari cua niquitioquiaari puetunu na jiitiasanojuanaa, Jiyaniijiarano cua quishacari. Majaari tamonu niishiniu quenaaja cante Pueyaso Niyanuni, saaja cua Que cutaraari cua niishiya. Naajuhuaj, majaari tamonu niishiniu cutara cante cua Queni. Saaja janiya cutaraari na niishiyani. Naajuhuaj, noo pueyari na niishiya, canapue cua niishitiniu paniya cua Quecuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na nuhuaji, Jesuuri na pueyacua tacateree. Saaja nojori sequereeri: —Shuquiriaatia quijiaca cutaraari niajaniya, nia niquiniuucua puetunu nia niquishanojuanaa nia rupuenuucua janiya. ");
INSERT INTO arlNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Seetanujuanaa nia sequeyanijia, queraatia tariucuacaanu Pueyaso sequesano caminiujiuniaa pueya, mariyata jiyaca jiyaniijianucuanio, nojoriiri nia niquishano niquiniuucua jiaatiaquiaari juucua. Majaari na niquitiuniu quiquiaari. Nojoriiri cuata nia quishacari nia tojishano tojitianuucua jiaatiaquiaari juucuajuhuaj. Majaari na tojitiuniu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na nuhuaji, Moisés Rootasanojiniji niishitiojona pueyanoori Jesuucua niquiaari nata na pocoojonura. Jesu na pocuatenura sesa juucua, naa na nequesotareeri: —Niishitiojonanaa, ¿taa cua miiniutianiya pueyaracaanu rishijia cua quiniuriani? ");
INSERT INTO arlNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesuuri na riucuaree: —¿Taate Moisés Rootasanojinia naajiotasanoni? ¿Taa quia niishiriojoquiaani, quiaa jaara na serojoquiaa? ");
INSERT INTO arlNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Moisés Rootasanojiniji niishitiojonaari Jesu riucuaree: —Naa sequeyano: “Quia Jiyaniijia Pueyaso quia paniri puetunu quioojiatajanaa, puetunu quia sohuanutajanaa, puetunu quia cumaacatajanaa, puetunu quia niishitiajatajanaanio. Naajuhuaj, quiarta pueyano quia paniri taa quia paniyacuaa tama quia cuaqueyajaajani”. ");
INSERT INTO arlNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesuuri na sequeree: —Quiaacuajaari maninia riucuaree. Naa quia miishacaritij, quiaari pueyaracaanu rishijia quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Moisés Rootasanojiniji niishitiojonaari tama nocuaji tacunu paniriquiaajaaja, maninia quijia na quiniuria Pueyaso niquiara. Naaratej, naa nequesotarohua Jesuuri: —¿Canteeri cuarta pueyanoni? ");
INSERT INTO arlNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesuuri nio pohuatasano na pohuataree na niishitiojonura nojuaja. Naa coteereeri: —Tamonu parta Judio pueyanoori Jericó tiacajiniara quiariquiaa juucua, Jerusalén tiacajiniji. Nohuasenuujuaca pueyari na quiaree. Puetunu na jiitiasanojuanaa na jaariuutiatureeri, na cushishano toquenio. Na piquitiuriiri. Quera macu na tiujiatuqueeri. ");
INSERT INTO arlNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na nuhuaji, pueyacuara secojonaari cuno nucuaco quiariquiaajaacuhuaj. Na niquishacari piquishano narta Judio pueyano mataano nuu shuriuquiocora, na shocortamaa saajaari. ");
INSERT INTO arlNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na nuhuaji, Levita pueyanoori cuno nucuaco quiariquiaajuhuaj. Na niquishacari narta Judio piquishano pueyano, nojuajaari saaja na shocortamaajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Na nuhuaji, Samaria jiyajinijinio tahueri cuno nucuaco quiariquiaajuhuaj. Na niquishacari parta Judio pueyano mataano, Samaria jiyajinijinio tahueri nocua taraajeree. ");
INSERT INTO arlNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Na cacataseeri. Nohuasenuujuaca piquiyashiquia matejoree shiyocuataari, vinotanio. Na nuhuaji, na piquiyashiquia morojoreeri. Na nuhuaji, na niataree tama na seru nijiniajaarijia. Ritia na jiyataaree rucoojojuaca tiuquiijiojua tiajiniaraari. Cuniqui na cojuatareeri. ");
INSERT INTO arlNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tariqui, cuno tahue quianu panishacariuhua, nojuajaari caapiqui cumaneeca pueraree. Rucoonaa tia camaru na niquitioreeri. Na sequereeri: “Cucua quia jiyanoori. Nio pueyano quia cojuatare quiria. Quiaa jaara socua quia cumaneeca nocua puecare, janiyacua saniniuujia quia niquitiorohuanijia cua tacatesacariuhua”. ");
INSERT INTO arlNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nio pohuatanu nuhuaji, Jesuuri cuno pueyano nequesotaree: —Quiarijiani, ¿taa quia sequeyani? Cuno jiuujianaraca rucoonaa pueyajinijinioni, ¿teyano cuno pojorijinijiniote narta pueyanoocua taraajeja cutarani? ");
INSERT INTO arlNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Moisés Rootasanojiniji niishitiojona pueyanoori Jesu riucuaree: —Cuno Samaria jiyajinijinio tahuecuajani, nocua taraajequiaarini. Jesuuri na sequeree: —Taaquiriirinij. Quia quiaarohua. Naa pueyacua taraajeja quia quirijiuhuaj, taa cuno tahue taraajequiaaricuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Socua na rucuanesacari, Jesuuri tamonu tiacajinia tiuquiquiaari na pueyata. Cuno tiacajinia na quishacari, tamonu maajiiri na masuuquiaari. Naaratej, na tiajinia na tiuquinitiareeri. Cuno maaji sesa quiquiaari Marta. ");
INSERT INTO arlNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martaari tarajanu jiitiaja. Na sesaari quiquiaari María. Maríari Jesu niohuaca shuriuquiumia cajiriquiaa, na tojiniuria Jesu pohuatasano. ");
INSERT INTO arlNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta cutaraari poonijioriquiaa queraatia na miishocoriquiano na jiitiasacari. Cunora, Martaari Jesuucua catecanoree. Na sequereeri: —Jiyaniijianaa, ¿majate cucua quia taraajenu? Cua tarajanuuri cua tarinitiaquee niquiriyatujua, puetunu nio poonijiosanotajanaa. ¡Quia sequere na naacutanura janiya! ");
INSERT INTO arlNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesuuri saaja na sequeree: —Martanaa, quioojia quia cajitiri sanaunaa. Quiaari puera quia miishano tacaatiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Saaja niquiriyatu casaa cutaraari jiyanohua panishano. María cutaraari cuno socua panishano casaa saquiriojoree. Tamonuuri maja na naata na tojishano jaariutianu noojiajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tamacari, Jesuuri Pueyaso secojoriquiaa tamaqui. Na puecasacari secojonu, tamonu na pueyajinijinioori na sequeree: —Jiyaniijianaa, canaa quia niishitiojore canaa secojonura Pueyaso, taa Tiuquinijiona Juan niishitiojoquiaari na pueyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesuuri nojori sequeree: —Pueyaso nia secojosacari, naa nia sequere: “Jiyocuacaanu quijia canaa Quenaa, puetunu pueyajanaa cuaara niishiiria quiaari tojetaarucuajanaa sesa miyashijia. Pueya cuaara seetanujuanaa quia jiyateera nojori jiyaniijia quia quiniuria. Quia panishano cuaara miishiiria mijiria, taa jiyocuacaanu miishiyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Canaa quia niquitioriquia canaa miaquesocoriquiano canaa panishano puetunu juucajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Canaa quia jiyanoori sesa canaa miishanojiniji, taa canaa jiyanooquiaacuaa sesa canaa miiniaani. Naajuhuaj, canaa quia cojuare, maja sesa canaa miitishaanura”. ");
INSERT INTO arlNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesuuri naa sequereejuhuaj, socua nojori na niishitiojonura: —Niaa jaara nia rupuenaacua quiaare shiyaqueya, casaa nia masenura nojuajiniji, ¿nojuajatucua taa quia sequereni?, quiaa jaara na sequere: “Cua rupuenanaa, cua niquitiore jiuujianaraca pan. ");
INSERT INTO arlNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tamonu cua cojiniaari shusha tiuquiriohua tucuacaanuji, miaajeyari. Shaaquiiri cua sumatuu cua miaquetesocoriquiano nojuaja”. ");
INSERT INTO arlNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","¿Quiaatucua taa miirini quia rupuena jaara na tiajiniacumaji quia riucuare?: “Maja cua taajetenu. Cua tia tiootiu tioree tarinijia. Tari cua mueya mataa maquetujinianijia. Maja cua naata sanenu cua niquitionura quia panishano”. ");
INSERT INTO arlNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jaara naa sequeretej, niaa jaara na tia tiootiu piquiniu tarinitiaaquiri, janiyari seetanujuanaa nia sequeyani, nojuajaari sanenutaniya na niquitionura niajaniya puetunu nia panishanojuanaa. Majaari na sanenu quiniutianiya saaja nia rupuena na quiniuucua. Sanenutaniyari pueyaracaanu taajeta nia piquishacari na tia tiootiu. ");
INSERT INTO arlNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Naajuhuaj, maja nia tarinitianu Pueyaso nia secojonu. Nojuajaari nia panishano nia niquitionutaniya. Cunora, nia panishano nia pajeriquia. Niocua na riuriatare. Tiootiu nia piquiriquia. Niaara riatasaanutaniyari. ");
INSERT INTO arlNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Naaratej, cante Pueyaso secojoquiaani, nojuajaari na panishano masenutaniya. Cante na pajejani, na panishano riuriatanutaniyari. Cante tiootiu piquiquiaani, nera riatasaanutaniyari. ");
INSERT INTO arlNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Niaatucua nia niyanu niquitiore saajia, neecaruu na masesacari niajaniya? Maja. ¿Niaatucua soconu niquitiore nia niyanu, sapitiaaja na masesacari niajaniya? Maja. ");
INSERT INTO arlNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Niaatucua turucuaniiniu niquitiore nia niyanu, caacaraja riuriuquiu na masesacari niajaniya? Maja. ");
INSERT INTO arlNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Puetunu niajaniyajanaari sesa miiniu niishijiaca. Naajaa, niaari maninia casaa niquitionu niishiya nia niquiohua. ¿Taatucuaa socua jiyocuacaanu Quijia nia Que Pueyasoni, tojetaarucuajanaa sesa miyashijiani? Seetanujuanaa capora na quishacari, nojuacuajaari na Sohuanu niquitionu niishijia na muerasu, canapuete na masequiaacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tamacari, Jesuuri samaru tohuataniriquiaa tamonu pueyanojiniji. Cuno pueyanoori tiquia quiquiaari samaru na jiitiasacari. Samaru jaara tohuataquiaari cuno pueyanojiniji, pocuajara quiriohuari. Pueya niquishacari naatej, nocuaji jiuujiatereeri. ");
INSERT INTO arlNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tamasaca pueyari saa sequequiaarijia: —Cuno pueyanoori samaruhua tohuatanijiya samaruhua jiyaniijia Satanás cumaacata. ");
INSERT INTO arlNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tamasaca pueyari Jesu saniniujiuniu paniriquiaa. Naaratej, nojoriiri na sequeturee na cumaacata na miiniuria casaa, na niquitiniuria nojori, nojori niishiniuria nojuajaari seetanujuanaa Pueyasojinijinio. ");
INSERT INTO arlNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesuuri nojori niishiriojosano niishiriquiaa. Nocuaji nojori sequereeri: —Tamonu jiyajinia, cuno pueya jaara miaquetoojiya tama nojori pueyatajaaja, nojoriiri maja na naata na paraa nujuatanu, na paraa jaara nocua tiuquitiare raquiritiano nojori quishacari. Naajuhuaj, niquiriyatu tiajinia quiniaa jaara tama nojorijiaaja juayonuujutaquiaa, nojoriiri maja na naata jatiqui quiniu. ");
INSERT INTO arlNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Naajuhuaj, niaari cua sequeriquiaa, janiyana samaruhua tohuatanijiya Satanás cumaacatani. Jaara naa quiritij, ¿Satanástucua taa pueyaracaanu quiri jiyaniijiani, nojuaja jaara tama na samaruhuajaaja tohuatanijiya tama na cumaacatajaaja? ");
INSERT INTO arlNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Naajuhuaj, janiya jaara samaruhua tohuatanijiya Satanás cumaacatani, taa nia sequeyacuajani, ¿nia niishitiojosano pueyariuhuaj, cana cumaacata nojori tohuatanijioquiaa samaruhuani? ¿Taa nia sequeyani? ¿Satanás cumaacatatee? Majaruhua. Naacuajitij, tama niajaniyajaaja nia niishiri, niaari jiyajeneya. ");
INSERT INTO arlNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Naa Pueyaso cumaacata cua tohuatanijiosacari samaruhuatej, naacuajiti nia niishiri, Pueyasoori tari nia masuya seetanujuanaa na muerasu nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Niojinia nia niishiriojorejuhuaj: cumueeca pueyano jaara na tia cojuaa queraatia na miaquejotaja casaata, majaari tamonu naata na jiitiasano casami jaariuutianu. ");
INSERT INTO arlNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Saniniuujia, socua cumueeca pueyano jaara nocua tiuquiri, na miaquejotaja casaa jaariuutiaari, cuno, nocua na tiuushano juucuani. Na nuhuaji, na jaariuutiasano casami paari, na pueya na serotasocoriquiano. Naajuhuaj, janiyari Satanás jiitiasano jaariuutiajani. ");
INSERT INTO arlNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Cante cua jiyano quiyaquiyani, nojuajaari cua paraca. Cante cua naacutaaquiya pueya rerecojonura Pueyasorani, nojoriiri saaja pueya cocuataa Pueyasoocuaji. Naaratej, jacaria nia niishiriojore casaa nia niishiriojiya janiyajinijini. ");
INSERT INTO arlNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Samaru jaara tohuatare pueyanojiniji, joojuashiquio rucuanejiyari na samaatejara na pajenura. Jaara na riuriataaquiri, niishiriojiyari: “Cua quiquiojinia riujiuyarohuaraqui teje cua tohuatacanucuajani”. ");
INSERT INTO arlNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Samaru tiuquishacariuhua cuno pueyanoocua, na riuriatasuhuari shaaco, juhua maninia netoonujusano tia, maninia jeenucuasanojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Naaratej, cuno samaruuri socua sesa miijiaca nojuajiniji siete narta samaruhua riquiohua nata na quiniuria. Puetunu nojorijianaari cuno pueyanojinia tiuquitiasuhua. Naacuajitij, cuno pueyanoori socua sesara jiyacateja, tarijia na quiniujiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesu pohuatasacari nio, tamonu maajiiri jiyacari pueya tajiniji naa nacaree: —¡Shuquiriaatia quijia cutaraari cuno maaji cante quia raquiaarini, cante quia canashitiquiaarini! ");
INSERT INTO arlNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesuuri saaja na riucuaree: —Socua shuquiriaatia quijia saniya sajara cante Pueyaso rupaa tojijiani, cante Pueyaso panishano miiquiaajaaniuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Socua queraatia pueyari Jesuucua rerejoriquiaa puetunu na shocuaqueyajanaa. Jesuuri juhuacatecara naa pohuataree nojori niquiara: —Nio pa quishacari pueyari sesa miijiaca. Nojoriiri cua sequequiaa, jiyajeneta casaa cua miiniuria Pueyaso cumaacata, nojori niishiniuria janiyari Pueyaso Jiyarosanoni. Seetanujuanaa majaari socua cua niquitiniu quiniutianiya nojori, cua cumaacata cua miishano. Nojoriiri saaja niquiniutianiya cutara taa cua miishaanutaniyani, naatej taa supuetana Jonás miishaaquiaaricuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonás miishaanuuri nocuaji jiuujiatesano quiquiaari cutara. Naacuajitij, Nínive tiacajinia quiniaa pueyari niishiquiaari Jonásri Pueyaso jiyarosano quiquiaari. Janiyari naa miishaanutaniyajaaniuhuaj, nio pa quishacari pueya niishiniuria janiyari Pueyaso Jiyarosanoni. ");
INSERT INTO arlNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Cua supuetana Salomón jaara Israel pueya jiyaniijia quiquiaari, jiyacari tamonu maajiiri pananu shuucuaji jiyajinia jiyaniijia quiquiaari. Nojuajaari jiyanohua tucuacaanuji niquiaari narta jiyaniijia Salomón tojiniuucua, jiyanohua niishijia Salomón quishacari. Jiya puequesacari Pueyaso saniniujiushacari pueya, cuno maajiiri jiyacari sanenutaniya nio pa quishacari pueyacuara na tonujunura, nojori ruuretanuucua socua Niishijiajanaa cutara Salomónjiniji. Cuno Niishijiaari niya nia tajinia quiyacuaja. Janiyacuajaari nojuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Naajuhuaj, cuno tariucuacaanu Nínive tiacajinia quiniaa pueyari saneecuatunutaniya Pueyaso nequesoreesacari nio pa quishacari pueya. Nojoriiri nio pa quishacari pueyacuara tonujunutaniyajuhuaj, nojori tacatoyaquiniuucua nojori jiuujia sesa nojori miishanojiniji, Pueyaso rupaa nojori tojiyaquiniuucua. Nínive pueya cutaraari noojia tacatoquiaari sesa nojori miishanojiniji, Pueyaso sequenu panishano caminiujiunia Jonás jaara Pueyaso rupaa pohuataquiaari nojori niquiara. Pueyaso sequenu panishano caminiujiunia quiarijia nia tajinia quiyani, nojuajaari socua cutara Jonásjiniji. Janiyacuajaari nojuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Pueya jaara samaritiu noshitiri, majaari na jamotanu. Majaari na niatanu conatu cariquiaco. Maninia cutaraari jiyocuacaanu na morotanu, tiaco tiuquitianaa cuhuatariquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Pa namijiaari juhua pa cuaqueya cuhuatanajuhuaj. Naacuajitij, paa jaara Pueyaso casaacua jiaatiaja quirini, paari cuhuashiqui quiya puetunujuanaani. Saniniuujia, pa namijia jaara sesa casaa niquiniuucua jiaatiaja quiri, paari ninishiqui quiya puetunujuanaani. ");
INSERT INTO arlNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tama nia cuaqueyajaaja nia cojuare, niaa mariqui nioojia cuhuatana maquishajareeri. ");
INSERT INTO arlNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Niaa jaara puetunujuanaa juhua cuhuashiqui quiya, sesa casaacua jiaatiaashijia nia quishacari, niocua maninia niquijiara quiri puetunujuanaa, juhua samaritiu cuhuatasacari niajaniya. Naacuajitij, niocua niishijia quiri, maninia miijia nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesu puecasacari pocuanu, tamonu Fariseo pueyanoori na masuuquiaari na tiajinia na miaquenura. Jesuuri na tiajinia quiaquiaari. Na tiuquishacari, miaquejajinia cajishiijianaari. ");
INSERT INTO arlNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseo pueyanoori jiuujiatequiaari na niquishacari Jesuuri shuquitioo tari cajiriquiaa miaquenura. Judiocuacaari jiyanijia, nojori rucoojosacari tamasaca pueya tajinia, tamasaca sesa miishanoori na naata nojoriicua pacunu. Nocuaji nojoriiri shuquitianu niishijia, tiajinia nojori tiuquishacariuhua. ");
INSERT INTO arlNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Naa cuno Fariseo pueyano niishiriojosacaritij, Jesuuri saa na sequereejaa: —Niajaniya Fariseocuacanaa, niaari juhua noo pueya, canapuete saaja na ratujua cuaqueya jeequejoquiaacuajani, saaja na miacojua cuaqueyanio. Majaari na jiniacuma na jeequenu. Niaari naajuhuaj. Niaari sapuenu maninia pueya niquishano. Saniniuujia nioojiacaari jiyanohua sesa quiya, casami nia masejonuucua nia nohuasejonuta, puetunu sesa nia miiniutiajanaajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mosanucuanaa, ¿niaateeri niishiyaquiya, pa cuaqueya Shipininiaari poojia shipiniquiaarijiuhuaj? Naaratej, nioojia nia jeequere cutara, maja saaja nia cuaqueya. ");
INSERT INTO arlNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Niaa jaara puetunu nioojiajinia nia jiitiasanojuanaa jiyatere Pueyasora na quiniuria, niaa maara juhua jeequesano quiri puetunujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Niaari taraatia miishaariquiano, Fariseocuacanaa! Niaari miaquesano jaamasucua serojoquiaa jacaria diez jaamasucua, puetunu cien jaamasucuajinijiniojuanaa, Pueyasora nia niquitiosocoriquiano. Cuno jaamasucuaari culantro, menta, socua tamonu jaamasucuaniyojuanio. Niaari naa maninia miiquiaa taa Moisés niishitiojoquiaaricuajani. Naajaa, Moisésri niishitiojoquiaarijiuhua maninia pa miiniuria parta pueya, Pueyaso pa paniniuriajuhuaj. Majaari cuno na sequesano nia miiniu quiquiaa. Puetunu na sequesanojuanaa tojijiaca nia quiri. Majaari saaja jaamasucua niquitiojojuaca nia quiniu. ");
INSERT INTO arlNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Niaari taraatia miishaariquiano, Fariseocuacanaa! Niaari jiyaniijianucua shuriucua cajiniuucua jiaatiaquiaa, Pueyaso secojojua tiajinia nia quishacari, juhua cutara pueya nia quiniuria pueya niquiara. Naajuhuaj, niaari pueya paniquiaa nojori saruhuatanura niajaniya juhua jiyaniijianucua, nia rucuanejosacari tiacajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Niaari taraatia miishaariquiano! Niaacuajaari juhua niquishoo jamaca. Pueyari juhuajaniya na caco rucooquiaa na niishiyaquishacari. Naajuhuaj, pueyari juhuajaniya nia rupuequiaa, nojori niishiyaquishacari nioojiaari jiyanohua sesa, juhua pueyano mocua jamajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jiyacaritij, tamonu Moisés Rootasanojiniji niishitiojonaari Jesu sequeree: —¡Niishitiojonanaa, naa quia sequesacari Fariseocuacatej, quiaari canaa sequeyajuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesuuri na riucuaree: —Taaquiriirinij. ¡Niaari taraatia miishaariquianojuhuaj, Moisés Rootasanojiniji niishitiojonaanaa! Puetunu nia rootasanojuanaari juhua jiyanohua niiquia casaa nitiasocoriquiano. Majaari nia tojitiajaca pueya nia naacunu quiquiaa quenaaja nia juaashiquia sacasaruta, cuno niiquia casaa nitiasaanura. Naacuajitij, pueyari maja na naata rejeretanu nia niishitiojosano. ");
INSERT INTO arlNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Niaari taraatia miishaariquiano! Niaari macunucua niojotajara shipinijioquiaa shanohuara, tariucuacaanu pueyara Pueyaso sequesano caminiujiuniaa nucuhuacuaji, teyano nia supuetanaa puecooquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Naacuajitij, canaari niishiyani, niaari nia supuetanaa miishano shuquiritiaa, nia cojuasacari nojori puecoosano nucuhua. ");
INSERT INTO arlNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Naacuajitij, Pueyasoori na niishiniutia sequequiaari: “Janiyari cua sequenu panishano caminiujiuniaa jiyaramiquiniutianiya Israel pueyacuani, cua rupaa niishitiojonaanio. Israel pueyari noojiaqueya puecoonutaniya. Tamasacaari naquiya miishaanutaniyajuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Cunora, Pueyasoori nio pa quishacari pueya naminiutianiya puetunu na sequenu panishano caminiujiuniaa nanacaacuajanaa, canapuete nio jiya coteejajiniji puecoosaaquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Coteenujuanaa mosaaquiaariiri Abel. Na nuhuaji, queraatia Pueyaso sequesano caminiujiuniaari puecoosaaquiaari. Na nuhuaji, Zacaríasri socua jaatesaaquiaari monujuhuaj. Nia supuetanaari na moquiaari Pueyaso Secojojua tiajinia, Pueyaso Shuriucua Quiquio tacoji, Pueyasoocuara catijiasaqui shuriucua. Seetanujuanaa nia sequeyanijia, nio pa quishacari pueyari namishaanutaniya puetunu nojori puecoosaanuucuajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Niaari taraatia miishaariquiano, Moisés Rootasanojiniji niishitiojonaanaa! Niaari najuhuana Pueyaso Rupaa jiitiaa. Majaari nia tojiniu paniniu, Pueyaso jiyanooshano pueya nia quiniuria. Saniniuujia, tamasaca jaara Pueyaso Rupaa niishiniu paniri, Pueyaso muerasu nojori quiniuria, majaari nojori nia niishitiojonu paniniu quiquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesu jaara nio sequequiaari, Moisés Rootasanojiniji niishitiojonaa, mariyata Fariseocuacaari jiyanohua juaaquioree. Jiyanohua nojori juaaquiosacari, nojoriiri Jesu nequesoreenu coteeree queraatia. Nojoriiri Jesu pocuatenu paniriquiaa sesa juucua. ");
INSERT INTO arlNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nojoriiri nocuara tonujunu paniriquiaa juucua, jaara sesa quiri na sequesano. ");
INSERT INTO arlNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jiyacaritij, jiyanohua jiyanohua queraatia pueyari Jesuucua rerejoree. Tama nojorijiaarijia rapijiotooriquiaa puera nojori rerequeejosacari. Jiyacaritij, Jesuuri saa na pueyaja sequenu coteeree. Naa nojori sequereeri: —Tama nia cuaqueyajaaja nia cojuare Fariseocuaca pan poreetajaacuaji. Nojori niishitiojosanoori juhua pan poreetaja. Majaari na jataniniu pueya, sesa nojori miiniujiniji. Nojoriiri sapuenu maninia miijiaca pueya niquishano tamasaca niquiara. Saniniuujia, nojori jiuujiaari saa sesaja pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nia niishiri, puetunu jiyasohuaja miishanojuanaari niishishaanutaniya. Puetunu jamosano casaajanaari niquishaanutaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Puetunu nia sequesanojuanaa ninishiquini, cuhuashiqui caminiujiushaanutaniyari. Naajuhuaj, nia sasacojosano tama nia sohuacamarajaajani, cunoori jiyocuacaanu tia nijiniji nacatasaanutaniya puetunu pueya tojishocoriquianojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Cua rupuenaanaa, majaari nia puerenu canapuete nareja pa cuaqueya mojuani. Nojoriiri maja na naata socua sesa na miiniu pajaniya, paa jaara tariucua macu quiyani. ");
INSERT INTO arlNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Seetanujuanaa nia sequereeraj, cante puereshiya cutarani. Noo nia puerere cutara, cante cumaacaraca cutara na jatanura niajaniya mani quiquiojiniani, na cusojuanu nuhuaji niajaniya. Saaja nojuaja nia puerere cutara. ");
INSERT INTO arlNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Cinco shuhuari saaja caapiqui cumaneecaniyojuata masesano. Pueyara, cunoori najuhuanaj. Naajaa, majaari Pueyaso niyajetanu cuno shuhua jaara puecoosaare. Nojuajaari na niishiya cutara. ");
INSERT INTO arlNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Naajuhuaj, nia muesuuri puetunu serojosanojuanaa. Pueyasoori na niishiya. Naaratej, maja nia puerenu. Niaari socua jiyanohua Pueyaso panishano cutara queraatia na cojuasano shuhuajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Cua tojitiare. Cante tamasaca niquiara sequejani: “Janiya Jesucristo pueyanoni”, naajuhuaj, janiyari cua Que Pueyaso seya niquiara sequenutaniyani: “Nojuaja cua pueyano”. ");
INSERT INTO arlNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Cante saniniuujia tamasaca pueya niquiara seetaa janiyajinijini, cua pueyano na quishacarini, janiyari cua Que Pueyaso seya niquiara na tamacanutaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Cante cua sesacareeni, nojuaja na naata jiyanooshaanu. Saniniuujia, maja cutaraari na naata jiyanooshaanu cante Pueyaso Sohuanu sesacareeni. ");
INSERT INTO arlNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Cua muerasu nia quiniuucua, niaari Pueyaso secojojua tiajiniaqueya jiyatasaanutaniya, nequesoreenaa niquiara, mijiria jiyaniijianucua niquiaranio. Nojori nequesoreesacari niajaniya, majaari nia niishiriojonu taa nia riucuanutaniyanoj, casaa nia sequenutaniyajaaniuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nia riucuanu panishacari, Pueyaso Sohuanuuri jiyacari nia niishitiojonutaniya taa nojori nia riucuanutaniyani. ");
INSERT INTO arlNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tamonu pueyanoori pueya tajiniji naa Jesu sequequiaari: —Niishitiojonanaa, cua tarajanu quia sequere na niquitionura janiya canaa shipininio jiitiasanojiniji, taa canaa shipininio sequequiaari canaacuajani, saminio na quishacarijia. ");
INSERT INTO arlNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesuuri saaja na riucuaree: —Pueyanonaa, ¿janiyateeri pueya nequesoreenara jiyatesaaquiaarini, cua serotanura niajaniya nia shipininio casamini? ");
INSERT INTO arlNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jesuuri naa nojori sequequiaarijiuhuaj: —Jiyanohua nia cojuare tama nia cuaqueyajaaja, maja casamiicua jiaatiajaca nia quiniuria. Pa naata shuquiriaatia quiniu casamiijiu. Queraatia casamiiri maja na naata seetanujuanaa shuquiriaatia quijiacara na jiyatenu pajaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na nuhuaji, Jesuuri pueya niishitioree nio miriqui pohuatasanota. Naa sequereeri: —Tamonu pueyanoori quiquiaari, jiyanohua casamiriaca. Na cuhuariquiajinia na natoosanoori jiyanohua muetuquiaari. Naacuajitij, queraatia miaquesocoriquiano jiitiaquiaariiri na cuhuariquiajiniji na carojotasano. ");
INSERT INTO arlNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tama sequereejaarijia: “¿Taa cua miiniutianiyani? Cua tiajosano cua racatajara cua carojotasanoori puetunujuanaa tari mishaja quiya. ¿Tee cua racatanutaniya shusha cua carojotasanoorinitioj? ");
INSERT INTO arlNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","¡Jaj, niishiquiinijia! Coteenu cua tiajosano cua casamiicuaji niyaroorohuaraquij. Janiyari socua puereetucocuara tiajonutaniyani. Janiyari cuniqui mishinijionutaniya puetunu cua carojotasano cua cuhuariquiajinijiniojuanaani, puetunu cua jiitiasano casamijianaanio. ");
INSERT INTO arlNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na nuhuaji, janiyari tama cua cuaqueyajaaja sequenutaniyani: ‘Pueyanonaa, quiarijia cutara juhuajaniya quia quiri. Quiaari queraatia casamiriacacuaja, queraatia marijiara. Quiaari queraatia quia miaquesocoriquiano jiitiaacuaja. Quiarijia cutara quia samaatere. Quia miaquere. Quia rature. Tama quia cuaqueyajaaja quia shuquiritiri’”. ");
INSERT INTO arlNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Cuno niucuaja, Pueyasoori na sequequiaari: “Moseecanaa, quiaari quiarijia macu juhuaquenutaniya. ¿Canteeri puetunu quia jamuesano casamijianaa jiitianutaniya quia nuhuajini? ¿Canra na quiniutianiyarini?” ");
INSERT INTO arlNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Naa miishaanutaniyari puetunu pueyajanaa, cante saaja tama nerajaaja reratequiaa casamini. Cuno, jamuejaca casamiriaca pueyani, nojoriiri seetanujuanaa casamiijiuniucua Pueyasora. ");
INSERT INTO arlNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na nuhuaji, Jesuuri na saquiriojosano pueya sequequiaari: —Naaratej nia sequeyanijia pueyanaa, majaari nia tacaaniu casaa nia miaquenutaniyani, casaa nia cushiniutianiyani. ");
INSERT INTO arlNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pueyaso jaara pa shipiniquiaari saminio pa quiniuria, majaari jiyajeneta nera na rishitiniuria pajaniyajuhuaj. Naajaariuhuaj, nojuaja jaara pa cuaqueya shipiniquiaari, majaari jiyajeneta na cushitiniuria pajaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Riquiacujua nia niquiriquia. Majaari nojori natoojonu. Majaari nojori carojotanu na racatasocoriquiano, na nuhuaji na miojosocoriquiano. Naajuhuaj, majaari nojori jiitianu na miojosano na racataja. Majaari tiaca nojori jiitianu na carojotasano nojori racatajarajuhuaj. Naajaa, Pueyasoori nojori miojotequiaa. Niaa cutaraari socua jiyanohua Pueyaso panishano cuno riquiacuhuajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Naajuhuaj, nia nequesotaanijia, niaa jaara socua tamonu juucara rishiniu paniriquia quera nia shaajenu panishacari, ¿nia naatateeri socua rishiniu, jiyanohua nia tacaaniutia? Maja nia naata. ");
INSERT INTO arlNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Naaratej, nia tacaaniu jaara najuhuana quiya socua shiitianiyojua nia rishiniuria, ¿niaatucua casaara tacaari tamonu casaacuani? ");
INSERT INTO arlNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Natau shuucuaca nia niquishurij, taa nojori corequetaani. Majaari nojori poonijionu. Majaari na cusupuenuunujuhuaj. Supuetana jiyaniijia Salomónri jiyanohua shanohua toqueyaraca quiquiaari. Cuno jiyanohua shanohua niquishano na cushishano toqueni, naajaa, majaari na shocotanu cuno natau shuucuaca. ");
INSERT INTO arlNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pueyasoori cuno natau shuucuaca shipiniquiaari rupaquijia naa shanohua niquishocoriquianotej. Jaara sorere, tariqui catijiashiya saniniuurijia pan majeetetajara. Pueyaso jaara naa maniniushitiyacuaa shuucuacatej, ¿majateeri na naata cushitiniu niajaniyajuhuaj, jatarinitiaja Pueyasoocua tiuujiacanaa? ");
INSERT INTO arlNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Naaratej, nia sequeyanijia, maja nia tacaaniutia nia pajenu casaa nia miaquenutaniyani, casaa nia ratunutaniyani. ");
INSERT INTO arlNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pueyaso niishiyashijiaca pueyari pueyaracaanu na panishano casaacua tacaaquiaa. Niajaniya cutaraari Queraca. Nojuacuajaari tari niishiya puetunu nia panishanojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Naaratej, nia niishiriojore Pueyaso panishano nia miiniuria. Nojuajaari saniniuujia nia niquitionutaniya puetunu nia panishanojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Maja nia puerenu, cua muerasuniyojuanaa. Niaari secajaniyojua. Naajaa, cua Queeri nia panijia. Capora na quiniuucua, ¡nia niquitionutaniya puetunu na jiitiasanojuanaari! ");
INSERT INTO arlNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nia casami nia niquitiojore cumaneecara. Na nuhuaji, cuno cumaneeca nia niquitiojore nareja casamiijiuniucua pueya. Naa nia miishacaritij, niaari jiyocuacaanu racataa nia jiitiasano. Tee Pueyaso racataa nareja nera nia niquitiosanocuajani, cuniqui, nia cumaneeca quiquioori maja na piquiniu. Niaari tii nia racatasano jiitianutaniya pueyaracaanu. Majaari nohuasejojua na naata nocua tiuquiniu na nohuasenura. Naajuhuaj, surequeyari maja na naata miaquenu nia casami tii. ");
INSERT INTO arlNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nia casami jaara naa racatasano quiya jiyocuacaanu Pueyaso shuriucuatej, niaari saaja Pueyasoocua niishiriojonutaniya, tee nia casami racatasano quiyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Juhuata jeenucuasano nia quiri pueyaracaanu, nia sashishacari nia Jiyaniijia, taa tiajiniaaco maninia seyacuaani. Nojori sashishacari na jiyaniijia, nojoriiri na toqueya cushiyono quiya tari, na samaritiu noshitishanojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Naa jeenucuasano nia quirijiuhuaj, juhua cuno seyaja. Nojoriiri na jiyaniijia sashiya na caminiujiniji na tiuquishacariuhua. Nojuaja jaara tohuateya piquishuhua, nojoriiri ritia nocuaji riatanutaniya tia tohuateya. ");
INSERT INTO arlNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Shuquiriaatia quijiaca cutaraari cuno seya, canapuete na jiyaniijiaacuaji suteyajaani, na jiyaniijia cuaara tiuquiriohuajaatijia. Seetanujuanaa nia sequeyanijia, nojori jiyaniijiaari nojori cajitijionutaniya miaquejajinia. Na toque maniniuqui jocuanutaniyari na mianuutenura nojori. ");
INSERT INTO arlNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nojori jiyaniijia jaara tiuquiriohua shiyaqueya, juhuaquenu panishacari, naajaa, shuquiriaatia quijiaca quiniutianiyari cuno seya, nojori jaara suteyajaa tia tohuateya riatariquiano nojori jiyaniijiaacuaji. ");
INSERT INTO arlNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nio nia niishirijiuhuaj, tia camaru jaara niishiri taacari nohuasejojua niniutianiyani, nojuaja maara sutere na tia cojuanura, maja nohuasejojua tiuquiniuria na casami na nohuasenura. ");
INSERT INTO arlNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Naajuhuaj, jeenucuasano nia quiri pueyanaa, juhua cuno sutejaca seyaja. Niaa jaara jiyaniya juhuanojuaja maja cua tiuquiniu quiniutianiuhua, janiyari jiyacari nia jiyajenetenutaniyani. ");
INSERT INTO arlNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jiyacaritij, Pedroori Jesu nequesotaree: —Jiyaniijianaa, ¿quiaate nio pohuataree saa canaaraja, puetunu pueyarajanaa soj? ");
INSERT INTO arlNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jiyaniijiaari na riucuaree: —Tamonu seru jaara maninia seru quiri, nocua tiuushano, niishijiajuhuaj, na jiyaniijiaari cuno na seru jiyatenutaniya narta seya jiitiariquiano na niti na niyacari. Nojori jiyaniijia niyacari, cuno seeratasano seruuri narta seya mianuutenutaniya maninia, taa nojori jiyaniijiajanaa mianuutequiaa nojoricuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Cuno seruuri shuquiriaatia quiniutianiya na jiyaniijia jaara na riuriatasuhua naa maninia miyanojua, taa na sequesaaquiaari na miiniuriacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Seetanujuanaa nia sequeyanijia, na jiyaniijiaari cuno maninia seru jiyatenutaniya puetunu na jiitiasano casamijianaa cojuana na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Saniniuujia, cuno seru jaara sesa miiniuria niishiriojore, na jiyanishacari na jiyaniijiaari jiyanohua tarishiniutianiya, nojuajaari niishiriojonutaniya nojuaja na naata miiniu na panishano. Cunora, nojuajaari narta seya majoonu coteenutaniya, seya maajipohuanio. Naajuhuaj nojuajaari saaja miaquejonutaniya. Pueyaracaanu rarujunutaniyari. Mashaasequejonutaniyajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na jiyanishacari na jiyaniijia juhuanojuaja maja na tiuquiniu quiniutianiuhua, jiyacaritij, cuno juucaja, na jiyaniijiaari tiuquiniutianiuhua canashiyaquiji. Naa cuno seru miiniuucua sesatej, na jiyaniijiaari jiyanohua na saniitionutaniya. Na jatanutaniyari Pueyaso tojiyashijiaca pueyata na saniitiosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Tamonu jiyaniijia jaara na seru rootare maninia, taa nojuaja miiniutianiyani, cuno seru jaara jeenucuaaquiri na jiyaniijiaacuaji, mariyata jaara miyaquiri taa na jiyaniijia sequequiaari na nuhuajiriacuajani, nojuajaari jiyanohua majacusaanutaniya cutara. ");
INSERT INTO arlNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Saniniuujia, tamonu seru jaara sesa miiri na niishiyaquiniuucua na jiyaniijia panishano na miiniuria, nojuajaari saaja secaja majacusaanutaniya. Naajuhuaj, cante queraatia niquitiosaareeni, cuno serujinijiiri queraatia masenu panishaanutaniya. Naajuhuaj, cante jiyatesaaree queraatia jiitiana na quiniuriani, na jiyaniijiaari nocua tiuuniutianiya socua jiyanohua maninia miijia na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Mijiria niquiaarinijia, juhua mani cua noshitiniuria pueya tajinia. ¡Seetanujuanaa na noshitiriquia tarinij! Cua rupaari juhua mani quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Coteenu, janiyari jiyanohua saniniujiushaanutaniya juhua manitiani. Nocuaji coojiaari tacaya janiya jaara naa miishaarejaatijia. Seetanujuanaa na jiyateriquia tariucua tucuateenonij. ");
INSERT INTO arlNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Niaateeri jiyaniya janiyari niquiaarini mijiria quiniaa quiniuria juhuajaniya? ¡Maja! Seetanujuanaa nia sequeyanijia, janiyari niquiaarini pueya cua raquiriojotanura. ");
INSERT INTO arlNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Naaratej, pueyari quiarijia juayonuutanu coteenutaniya. Pueyano jaara necocuata jiitiare jiuujianaraca niquiohua na tiajinia, jiuujianaraca nojorijinijinio jaara cucua tiuuri, cuno caapiqui cucua tiuyashijiacaari saniniuujia nojori juaajiaca quiniutianiya. Naa noojiaqueya pueyajinijinio tiuuniuucua cucuatej, queraatia pueyari naa tama tacaresetanutaniyajaacujua. Naacuajitij, tamonu tiajinia, querajaa pueyari caapiquiriyatu cucua tiuujiaca juaajiaca quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pueyari necohua paracaajia quiniutianiya, necohua tiuushacari cucua. Naajuhuaj, necohuari na que paracaajia quiniutianiya na que tiuushacari cucua. Naajuhuaj, maajipohuari necojori paracaajia quiniutianiya necojori tiuushacari cucua. Naajuhuaj, necojoriiri na nucua paracaajia quiniutianiya na nucua tiuushacari cucua. Naajuhuaj, maajipohuari necohua niquiocohua paracaajia quiniutianiya, necohua niquiocohua quiniuucua cucua tiuujiaca. Naajuhuaj, pueya niquiocohuari na quinia paracaajia quiniutianiyajuhuaj, cucua tiuujiaca na quinia quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesuuri naa sequequiaari pueyajuhuaj: —Niaa jaara niquitioocua niquiquiaa pananu tiuquishocora, niaari sequequiaa: “Maruqui niniutianiya”. Seetanujuanaa naa quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Naajuhuaj, paratu jaara piyarojoquiaa pananu shuucuaji, niaari sequequiaa: “Tacareejonuqui quiniutianiya”. Naa quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pueyanaa, ¿niaateeri seetanujuanaa niishijiaca? Niaari maninia niishiquiaa jiya cajiniocua nia niquishano, nio jiyajinia nia niquishanonio. Saniniuujia, nia niquishacari quiarijia Pueyaso miishano nia niquiara, majaari cuno nia niishiniu, casaa na sequenu paniyani. Naaratej, majaari seetanujuanaa niishijiaca niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Niaacuajaari niishiya, sesa miijiacaari saniitiosaanutaniya. Naaratej, tama niajaniyajaaja nia niishiriojore, casaate maninia nia miiniuriani. ");
INSERT INTO arlNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tamonu pueyano jaara quiocuara tonujure quia sesonuucua na casaa, quia saniri juhuata nata pocoojonu maninia, na jaatucusacari quiajaniya nequesoreena pueyanoocua. Quia sequerenoj casaa quia miiniutianiya nerani, na jiyanooniuria quiajaniya. Quiaa jaara jeecatoyaquiri nata, nojuajaari quiocuara saquiriojotanutaniya nequesoreena pueyano. Jaara quiocuara saquiriojotare nequesoreena pueyano, nequesoreenaari saniniuujia quia niquitionutaniya na pueya, quia nujuatesaanura nujuatejojuajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Seetanujuanaa nia sequeyanijia, majaari nia tohuatanu quiniutianiya nujuatejojuajiniji, niaa jaara puetunu nequesoreena sequesano cumaneecajanaa niquitiorejaatijia niaacuara tonujuna pueyano. ");
INSERT INTO arlNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jiyacari, tamasaca pueyari Jesuucua tiuquiijioquiaari. Cuno pueyari naa Jesu pohuataquiaari: —¡Jiyaniijia Pilatoori Galilea jiyajinijinio pueya puecoorucuaa! ¡Na nuhuaji, nojori nanaca cojitiriiri Pueyasoocuara nojori puecoosano seya nanacata! ");
INSERT INTO arlNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesuuri nojori sequeree: —¿Niaateeri jiyaniya cuno Galilea pueyari naa miishaarucuaa socua jiyanohua sesa miijiaca nojori quiniuucua narta Galilea pueyajiniji? ");
INSERT INTO arlNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Seetanujuanaa nia sequeya cutaranijia, nojoriiri maja socua sesa miijiaca quiquianu niajaniyajiniji. Niajaniyajuhuaj, niaa jaara tama nioojiajaaja tacatoyaquiri sesa nia miiniujiniji, niaari taraatia puecoosaariquianojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Cuno dieciocho pueyariuhuaj, canapuete cusonuucanu cuno jiyaconaja tia jaara nojori shiniacacanu Siloé cuari shuriucuatej? ¿Niaateeri jiyaniya nojori socua sesa miijiaca quiquianu narta Jerusalén tiacajinia quiniaa pueyajiniji? ");
INSERT INTO arlNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Seetanujuanaa nia sequeyanijia, nojoriiri maja socua sesa miijiaca quiquianu niajaniyajiniji. Janiyari quiarijia nia numooteyani, niaa jaara tacatoyaquiri nioojia sesa nia miiniujiniji, niaari taraatia puecoosaanutaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesuuri na nuhuaji pueya niishitiojoquiaari nio miriqui pohuatasanota: —Tamonu pueyanoori higo naana jiitiaquiaari na uva cuhuariquiajinia. Tamacari, na camaruuri nocua quiaquiaari na niquiniuria. Na jajau mianu paniriquiaa juucuaari. Shaanoori quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Cunora, na cuhuariquia cojuana sequereeri: “Quia niquiri nio naana. Janiyari pueyaracaanu najuhuana niquiaani na jajau pajenura. Pueyaracaanu muetuyaquiyari. Tari na shocojorucuaari jiuujianaraca marijia. ¡Quia nure! Tamonu cuaara na nujuasaqui natasaaria, na muetunura cutara”. ");
INSERT INTO arlNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Cuhuariquia cojuanaari na riucuaree: “Jiyaniijianaa, quia tarinitiarejaara tamonu marijiara. Janiya na pajama jiya tacarojotanutaniyani na sasetanura. Na nuhuaji, janiyari juunu cueaca na pajama paatiniutianiyani. ");
INSERT INTO arlNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Janiya jaara naa na miirini, muetunutaniya naasucua. Jaara muetuyaquiri, pocua socua na nureni”. Naajuhuaj pueyanaa, Pueyasoori sashiya, maninia miijiaca nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tamonu samaatenu juuca, Jesuuri tamonu tiacajinia niishitiojoriquiaa Pueyaso secojojua tiajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tamonu maaji cusosuuri tii quiriquiaajuhuaj. Dieciocho marijiaari na shoconujuquiaari porocuatu na quishacari. Samaruuri naa na jiyatequiaari. Majaari quenaaja na naata maninia nujuanu quijia. ");
INSERT INTO arlNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesu jaara na niquiquiaari, na sequereeri: —¡Maajiniaa miji! ¡Quia nijiniacuaja tari jeequerohua! ");
INSERT INTO arlNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesuuri na juaashiquia niaree maajiicua. Jiyacaritij, maajiiri maninia jeequequee. Nojuajaari Pueyaso maniniuhuaqueetanu coteeree naa na miishaanuucuatej. ");
INSERT INTO arlNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pueyaso secojojua tiajinia jiyaniijiaari juaarii naa Jesu miiniuucua samaatenu juuca. Naaratej, tii quiniaa pueya sequeree Jesu niquiaraari: —¡Seis juucacuajaari quiya puetunu semaanajiniajanaa pa poonijionura! ¡Niocua cuno juuca nijioriquia nia naatanijiosaanura, maja samaatenu juuca! ");
INSERT INTO arlNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jiyaniijia Jesuuri sequeree: —¡Sapuenu juhua maninia miijiaca niquishano pueyanaa, puetunu niajaniyajanaari nia juunu, nia burro samaacartaquiaa samaatenu juuca, nia jaatucusocoriquiano mohuaca na raatenura! ");
INSERT INTO arlNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Nio maajiiriuhuaj? Nojuaja cutaraari supuetana Abraham niquiohuacuajinio supueno. ¿Majateeri maniniajuhua samaatenu juuca pa samaacatanura Satanás morojosano? Dieciocho marijiaari tari nio maaji shoconujurucuaa pueyaracaanu porocuatu na quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Naa Jesu sequesacaritij, puetunu na paraajanaari caririquitiurii. Saniniuujia, puetunu pueyajanaari shuquiriaatia quiriquiaa nojori niquishacari queraatia maninia Jesu miishano na cumaacata. ");
INSERT INTO arlNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesuuri sequequiaari: —¿Taate cua naata niishitiojonu niajaniyani, nia niishiniuria taa Pueyaso poonijiya pueya jiuujiajinia na rupaatani? ");
INSERT INTO arlNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Na rupaari juhua mostaza jajauniyojua, pueyano natasano na cuhuariquiajinia. Cuno jajau jaara moritiare, puereetuucara caneyari. Naacuajitij, shuhuari na cashacucuaacua jesuya. Naajuhuaj, Pueyaso rupaari caneya pueya jiuujiacajinia puetunu nio jiyajiniajanaa maninia miijiaca nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesuuri nio pohuataquiaari socua: —¿Casaa cua pohuatanutaniya nia niishiniuria taa Pueyaso poonijiya mijiria na rupaatani? ");
INSERT INTO arlNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pueyaso rupaari juhua pan poreetaja maaji cojitishano trigo cashojuata, shanacusano jiuujianaraca shiitianiyojua tohuatashijinia. Pan poreetajaari puetunu cuno cashojua miniquiootasanojuanaa poreeteja. Pueyaso rupaari naa poonijiojuajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesuuri Jerusalén tiacajiniara quiariquiaa na pueyata. Nucuaco na quiasacari, pueya niishitiojoriquiaa tiacajiniaari, shiitianiyojua tiacajinianio. ");
INSERT INTO arlNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jiyacaritij, tamonu pueyanoori na nequesotaree: —Jiyaniijianaa, ¿saaja quenaaraqui pueyateeri Pueyaso pueyara jiyatesaanutaniya? Jesuuri nojori riucuaree miriqui: ");
INSERT INTO arlNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Jiyanohua nia saniniujiuri shiitianiyojua tohuateyaco nia tiuquiniuria, Pueyaso nia rupuenura. Juhuacarijia nia numooteyanijia, queraatia pueyari nocua tiuquitianu paniniutianiya juucua. Majaari nojori naata quiniutianiya saaja. ");
INSERT INTO arlNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Cua tojitiare. Tia camaru jaara sanere, tohuateya tionutaniyari. Niajaniya, cante na tia carijiniacuma quiyajaani, niaari tohuateya piquiniuuniutianiya najuhuanaj. Niaa jaara naa nacare: “¡Jiyaniijianaa, canaacuaji quia riatare tohuateya!”, nojuajaari nia riucuanutaniya: “Maja cua niishiniu tejenote niajaniyani”. ");
INSERT INTO arlNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jiyacaritij, niaari juhuacatecara sequenutaniya: “¿Majateeri canaa quia niishiniu? Canaacuajaari quiata miaquenuujuani. Canaari quiata ratujua mariyatani. Quiaacuajaari canaa tiaca nuucuacajinia niishitiojojua”. ");
INSERT INTO arlNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tia camaruuri nia riucuanutaniya: “Janiyacuajaari tari nia sequereeni, maja cua niishiniu tejenote niajaniyani. Nia quiojorohua niiquiji, puetunu niajaniyajanaa sesa miijiacanaa”. ");
INSERT INTO arlNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Naa na taanuusacari niajaniyatej, niaari nujuquetunutaniya. Niaari nia quiaca miaquenutaniya jiyanohua nia taraajenuta, nia niquishacari Abraham, Isaac, Jacobo, puetunu pueyara Pueyaso sequesano caminiujiuniaa Pueyaso shuriucua quiyanocuaa. ");
INSERT INTO arlNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Queraatia tamasaca pueyapueeri nijionutaniya puetunu jiyacajinijiniojuanaa Pueyaso shuriucua cajitiuniuria, nojori miaquenuunura nata. Nijionutaniyari pananu muetasamaji, pananu tiuquishacojinio, pananu shuucuaji jiyacajinijinio, pananu muetasamaji miaquetajara jiyacajinijiniojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Quiarijiani, queraatia pueyari juhua tojishoo quiya narta pueyara. Cuno quishacari saniniuujia, nojori cutaraari seetanujuanaa tojishano pueya quiniutianiya Pueyasora, Pueyaso tojitiajaca nojori quiniuucua mijiria. Naajuhuaj, quiarijiani, queraatia pueyari juhua tojishano pueya quiya narta pueyara. Saniniuujia, jiya puequesacari, nojoriiri najuhuana quijiaca quiniutianiya Pueyasora, nojori tojitiaaquiniuucua nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jiyacari noojiaqueya Fariseocuacaari Jesuucua tiuquiijioquiaari. Nojoriiri Jesu numooteree: —¡Niiquiji quia mashiri! ¡Jiyaniijia Herodes quia monu paniya! ");
INSERT INTO arlNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesuuri nojori sequeree saaja: —Cuno pueyanoori niishijia juhua jaami. Naa nia caminiujiushuhua cua sequesano cuno jaamiria: “Janiyari samaruhua tohuatanijiyani. Janiyari cusosuhua naatanijiyajaaniuhuaj. Janiyari naa miya quiarijiani, tariquijiuhuaj. Janiyari tama tariqui tucuatanutaniya puetunu cua miiniu panishanojuanaani”. Naa nia sequesuhua cuno pueyano. ");
INSERT INTO arlNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Cuaara rupaquijia cua sashiiria. Janiya quiarijia rucuanenutaniyajaarani, tariqui, tama tariquinio. Janiya cuaara mosaaria cutara Jerusalén tiacajinia, tee cuniqui puetunu pueyara Pueyaso sequesano caminiujiuniaajanaa puecoosaaquiaaricuaani. Majaari tamaqui cua monu quishaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Jerusalén tiacajinia quiniaa pueyanaa, niaacuajaari Pueyaso sequesano caminiujiuniaa puecoojuaca. Niaari Pueyaso jiyaramiquishano pueya jacujuaca saitia. Janiyari juucua pueyaracaanu nia rerejonuucua jiaatiajani, taa caacaraja necohua rijioquiaacuaa na nesu cariquiaconi. Niaari saaja paniyaquiquiaa cua cojuanura niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","¡Cunora, cua tojitiare! Nia quiquioori tojetaarucuajanaa shaaqui quiniutianiya. Naajuhuaj, majaari socua nia niquiniu quiniutianiya janiya, niaa jaara nia timitiasacari janiya sequerejaatijia: “¡Cuaara shuquiriaatia quiiria pa Jiyaniijia, Pueyasojiniji tiuquiuhuano!” ");
INSERT INTO arlNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tamonu samaatenu juuca, Jesuuri tamonu Fariseocuaca jiyaniijia tiajinia quiaquiaari miaquenura, socua tamasaca Fariseocuacatanio. Nojoriiri Jesu shootiaturiquiaa nojori niishiniuria casaa na miiniutianiya samaatenu juucani. ");
INSERT INTO arlNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jiyacaritij, tamonu pueyanoori Jesu tacoji nujuariquiaa, poreeno cusotaano. ");
INSERT INTO arlNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesuuri Moisés Rootasanojiniji niishitiojonaa nequesotaree, Fariseocuacanio: —¿Taa nia serojoquiaa Moisés Rootasanojiniani? ¿Maniniate cusosu pa naataniniu samaatenu juuca? ");
INSERT INTO arlNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nojoriiri saaja sanaa na tojitiariquiaa. Jesuuri cusosu quiaree jiyacari. Na naataniriiri. Na jiyarorohua na tiajiniaari. ");
INSERT INTO arlNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na nuhuaji, Jesuuri cuno Fariseocuaca sequeree: —Nia burro, nia juunu jaara raama tiyare samaatenu juuca, ¿niaatucua samaatenu juuca shocoterejaara, raamaji nia jaaniuhuara nia seru? ");
INSERT INTO arlNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Majaari nojori riucuanu quirii quenaaja. ");
INSERT INTO arlNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesuuri shootiariquiaa taa masuusano pueya socua panishano cajitiucuajinia nojori cajitiuniuria riutioconeetariquiaani. Jesuuri cunora nojori niquiara pohuataree nio pohuatasano. Naa sequereeri: ");
INSERT INTO arlNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Quiaa jaara masuusaariquia camishacari queranacunura, maja cumaati quia cajiniu socua tojishano pueyano cajijiaranojinia, tamonu pueyano mariqui tiuquiriiri socua tojishano pueyano quiajaniyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Socua tojishano pueyano jaara tiuquishii, nia masuuna pueyano naasucuaari quiocua niniutianiya na sequenura quiajaniya: “Shiiquia. Quia sanere nio pueyanoocuaji”. Naacuajitij, quiaari cajitishaanutaniya quia caririquiniutia pueya paniyaquishano cajitiujinia, miaqueja puequeetujinia. ");
INSERT INTO arlNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nocuaji nia sequeyanijia, niaa jaara masuusaariquia miaquenura tamonu tiajinia, niocua cajishiiquia socua paniyaquishano cajitiujinia. Naacuajitij, quia masuuna jaara niquiri quiajaniya, nojuajaari quia sequenutaniya: “Cua rupuenanaa, ¡niya quia cajishii socua panishano cajitiujiniani!” Naacuajitij, cuniqui quiata quiniaari niishiniutianiya, quiajaniyaqui nia masuuna panishano pueyano. ");
INSERT INTO arlNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Naajuhua Pueyasora, cante tama na cuaqueyajaaja jiyateya juhua tojishano pueyano na quiniuriani, nojuajaari cararosaanutaniya. Saniniuujia, cante tama na cuaqueyajaaja jiyateya juhua panishoo pueyanoni, nojuajaari maninia jiyatesaanutaniya juhua tojishano pueyanora. ");
INSERT INTO arlNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesuuri na masuuna pueyano sequereejuhuaj: —Quiaa jaara queranacunu paniya, majaari quia masuunu saaja quia rupuenaa, quia tapueyocuaca, quia panishano pueyanio. Naajuhuaj, majaari quia masuunu quia shuriucua quiniaa casamiriaca pueya. Quiaa jaara nojori masuure, nojoriiri quia masuunutaniya saniniuujia. Naacuajitij, quiaari tari namishaarohuacuaja. Cunora, majaari socua quia masenu quiniutianiya Pueyasojiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Naaratej, quiaa jaara queranacunu paniya, quia masuure casamiijiuniucua pueya, sesaruneca pueya, sesacujuanucua pueya, cariyojuarujurinio. ");
INSERT INTO arlNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Naacuajitij, quiaa jaara naa miiri, quiaari shuquiriaatia quijia quiniutianiya cutara. Majaari nojori naata masuunu quiajaniya saniniuujia. Naaratej, Pueyaso cutaraari maninia miiniutianiya quiajaniya saniniuujia, na samiitianijiosacariuhua maninia miijiaca pueya. ");
INSERT INTO arlNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesuta cajiyano pueyano tojishacari naa Jesu pohuatasanotej, Jesu sequereeri: —¡Shuquiriaatia quijia cutaraari cuno, cante Pueyaso shuriucua miaquenutaniya jiyocuacaanuni! ");
INSERT INTO arlNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesuuri na sequeree: —Tamonu pueyanoori queraatia sumatuquiaari pueyata na queranacunura. Nojuajaari coteenu queraatia pueya masuuquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Quera miaquenuusacari, na seru jiyaroreeri na masuusano pueya na sequenura: “Miji, puetunujuanaa tari jeenucuasaaree niaacuaji. Nia miaquesee”. ");
INSERT INTO arlNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","’Puetunu masuusano pueyajanaari juhuacatecara sequequiaari maja na naata quianu miaquenuucua. Coteenu masuusano pueyanoori cuno seru sequeree: “Janiyari shusha maseree tamonu cuhuariquiani. Janiyari nocua quiaa na niquiniuucuani. Cua jiyanoori quenaaja. Maja cua naata quianu quiata queranacunuucua”. ");
INSERT INTO arlNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tamonu masuusano pueyanoori sequeree: “Janiyari diez poonijiojuaca juyaca masereeni. Na saniniuucua quiaanijia. Quiocua cua jiyanoori cua quiaaquishacari queranacunujinia”. ");
INSERT INTO arlNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tamonu masuusano pueyanoori sequereejuhuaj: “Shusha camiriinijia. Cunora, maja cua naata quianu”. ");
INSERT INTO arlNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Seruuri tamajaaja tacateyarohua na camarnu tiajiniohua. Na jiyaniijia pohuatasuhua na masuusano pueya sequesanoori. Na jiyaniijiaari juaaquii. Na seru sequereeri: “Ritia quia quiaare tamasaca pueya masuunuucua tiaca nucuaacaco. Miji quia rijiocoo casamiijiuniucua pueya, sesaruneca pueya, sesacujua pueya, cariyojuarujuri pueyanio”. ");
INSERT INTO arlNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Seru tiuquishacariuhua, na jiyaniijia sequesuhuari: “Jiyaniijianaa, janiyari tari miiriini taa quia sequeree janiyacuajani. Juhuanojuaja maja tia mishiniu”. ");
INSERT INTO arlNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Na jiyaniijiaari na sequeree: “Socua pueya quia pajecoo tiaca nucuaacaco, tamasaca tiacajiniara nucuaacaconio. ¡Socua pueya quia nenecojocoo nojori niniuria, cua tia mishiniuria! ");
INSERT INTO arlNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Seetanujuanaa nia sequeyanijia, coteenu cua masuusano pueyajinijinioni, majaari quenaaja niquiriyatu nojorijinijinio saniniu quiniutianiya cua sumatusano”. ");
INSERT INTO arlNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jiyanohua queraatia pueyari Jesuta quiojoriquiaa. Jesuuri nojoriicua tacateree. Nojori sequereeri: ");
INSERT INTO arlNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Cante cucua niya cua pueyano na quiniuriani, nojuaja cuaara niishiiria nio. ¡Maja nia naata cua pueyano nia quiniu nia paniyaquishacari janiya socua nia quejiniji, nia nucuajinijinio! Nia niquiocua, nia niquiohua, nia tapueyocuaca, nia rimiatuhuajuhuaj, nia panishacari nojori socua janiyajiniji, ¡majaari nia naata cua pueyara nia quiniu! Naajuhuaj, ¡majaari quenaaja nia naata tama nia cuaqueyajaaja panijia nia quiniu socua janiyajiniji! ");
INSERT INTO arlNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Cante tama na cuaqueyajaaja panitiaaquijia cucuarani, majaari na naata cua pueyanora na quiniu. ");
INSERT INTO arlNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Niaa jaara jiyaconaja tia tianu paniri, ¿majate coteenu nia cajiniu nia niishiriojonura taa cumaneecate panishaanutaniyani, na tucuatanura puetunujuanaa? Naajuhuaj, niaari niishiriojiya, queraatia quiyacuajate nia cumaneeca. ");
INSERT INTO arlNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Niaa jaara coteenu naa miyaquiri, niaari najuhuana morijiucua nujuatejonutaniya, na nuhuaji majaari socua nia cumaneeca quiniu nia tucuatanura nia tia. Puetunu nia tia niquiniaajanaari juhuacatecara nia macaatiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nojoriiri sequenutaniya: “Cuno pueyanoori tianu coteecanu najuhuanaj. Majaari na naata na tucuatanu quiarijia”. ");
INSERT INTO arlNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Naajuhuaj, jiya jiyaniijia jaara quianu paniri narta jiyaniijiata miaquetoonura, ¿majate coteenu na cajiniu na niishiriojonura, na naatate diez mil na pueyata shocotanu cuno tamonu jiyaniijia, nocua niyano veinte mil na pueyatani? ");
INSERT INTO arlNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Cuno jiyaniijia jaara niishiri, maja na naata na shocotanu quiniutianiya narta jiyaniijia nocua niyano, majaari na miaquetoonu quiniutianiya. Saniniuujia, tucuacaanu narta jiyaniijia quishacarijia, nocua jiyaramiquiniutianiya na pueyari, nata nojori pocoojonura maninia, nojori jiyanootioonura. ");
INSERT INTO arlNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Naajuhuaj, niaa jaara carteyaquiri puetunu nia jiitiasanojuanaa, majaari nia naata cua pueyanora nia quiniu. ");
INSERT INTO arlNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Shoni jaara tiquiriiquia quiya, maniniaari, pa panishano. Jaara shaacara quiquii, ¿taate na naata tiquiriiquiara na quiniuhuani? Maja na naata. ");
INSERT INTO arlNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Najuhuana quiyari. Majaari quenaaja maninia na quiniu cuhuariquiajinia jatasocoriquiano maninia na moritianiniuria nataacuaca. Majaari quenaaja maniniajuhuaj, na paatishaanura na moquijianura, natau pajama niojosocoriquiano. Jaara naa maninia quiyaquiritij, nareja jatashiyari. Cante numaaracani, cuaara tojitiaara miriqui cua pohuatasano. Cuaara na niishiiriajuhuaj. Seetanujuanaa cua tojitiajaca pueyani, nojoriiri juhua shoni mijiria. ");
INSERT INTO arlNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Roma tiacajinia quijia jiyaniijiara cumaneeca masejonaa, mariyata sesa miijiaca pueyari Jesuucua nijioriquiaa na pohuatasano nojori tojitianura. ");
INSERT INTO arlNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Cuno pojoriiri Fariseocuaca soosano pueya quiriquiaa, Moisés Rootasanojiniji niishitiojonaa soosano pueyanio. Cunora, Fariseocuacaari, mariyata Moisés Rootasanojiniji niishitiojonaari tama rimiaaqueturiquiaajaaja Jesuucuara. Naa pocuaturiquiaa Jesuuri: —Cuno pueyanoori sesa miijiaca pueya shanacuquiaa nocua nojori nijionura. ¡Juhuajaniya nojoritia miaquequiaajaariuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Naaratej, Jesuuri nojori niquiara pohuataree nio miriqui pohuatasano: ");
INSERT INTO arlNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Niaa jaara cien borregohua jiitiariquia, nojorijinijinio niquiriyatuniyojua jaara tashucuare, ¿taa nia miiquiaani? ¿Niaatucua nia noventa y nueve borregohua cureeno tiujiaaquiri rupaquijia cuhuariquiajinia, tashucuano borrego nia pajenura, niaa cuaara na riuriatarohuajaatijia? Taaquiriirinij. Niaacuajaari naa miiquiaaquij. ");
INSERT INTO arlNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Niaa jaara na riuriatasee, niaari nia shuquiriniutia na paquiohua nia numueecuaji. ");
INSERT INTO arlNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Niaa jaara na tiuquitiarohua nia tiajiniohua, niaari nia rupuenaa, mariyata nia shuriucua quiniaa rerejotenutaniya nia sequenura nojori: “¡Cuata nia shuquiriri quiarijia! ¡Tari riuriatarohua cua borregoniyojua tashucuanonijia!” ");
INSERT INTO arlNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Seetanujuanaa nia sequeyanijia, naajaariuhuaj, jiyocuacaanu quiniaari jiyanohua shuquiritiuquiaa niquiriyatu sesa miijia jaara noojia tacatore sesa na miiniujiniji. Cuno pueyanoori socua jiyanohua shuquiritiasano tamasaca noventa y nueve pueyajiniji, canapuetucuaja tari maninia pueyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Naajuhuaj, tamonu maaji jaara diez cumaneecaraca quiri, jaara niquiriyatu juurequetere tiajiniaaco, ¿maatucua taa miirini? Na samaritiu noshitiniutianiyari, na tia na netoonujunura. Pueyaracaanu jacaria na pajenutaniyari cuaara na riuriatarejaatijia. ");
INSERT INTO arlNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na riuriatasacari na juurequetesano cumanee, maajiiri na rupuenaa, mariyata na shuriucua quiniaa maajipohua rerejotenutaniya na sequenura nojori: “¡Miji nia nimia! ¡Cuata nia shuquiriri! ¡Tari riuriatarohua cua juurequetesano cumaneenijia!” ");
INSERT INTO arlNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Seetanujuanaa nia sequeyanijia, jiyocuacaanu Pueyaso seyari naa shuquiriquiaajuhuaj sesa miijia jaara noojia tacatore sesa na miiniujiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na nuhuaji, Jesuuri nio pohuatareejuhuaj: —Tamonu pueyanoori caapiqui niyanuraca quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Socua naatujuaari na que sequeree: “Cua quenaa, quiarijia cua niquitiore quia jiitiasanojiniji, quiria quiriquiano quiaa jaara shaajeyare”. Naacuajitij, na queeri puetunu na jiitiasanojuanaa niquitiojoree necohua. ");
INSERT INTO arlNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Socua naatujuaari rupaquijia camueenujuquiaari na que tiajinia. Na nuhuaji, puetunu na que niquitiosanojuanaa nojuajani, nojuajaari saniniuujia tamasaca na niquitiojoree na cumaneecara. Na nuhuaji, na cumaneecata quiaquiaari tucuacaanuuri, tamonu jiyajinia. Cuniqui, puetunu na cumaneecajanaa puecaquiaariiri sesa na miiniutia. ");
INSERT INTO arlNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nojuaja jaara puetunu na cumaneeca puecaquiaarijianaa, cuno jiyajiniaari jiyanohua miaajesacari quiquiaari. Mashajaari juhuacatecara miaajequiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Cunora quiaaree tamonu tahuecua cuno jiyajiniaari, nera na poonijionura. Cuno tahueri na jiyaroree na cuhuariquiajinia na cushiya na cojuanura. ");
INSERT INTO arlNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mashajaari cushiya miaquesano miaquenu paniriquiaa juucua na miaajenuta. Cunoori tamaatia purootu cocua quiquiaari. Majaari tamonu pueyano niquitionu quijia quenaaja na miaquesocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Na nuhuaji, tama sequereejaarijia: “Cua queeri queraatia na tiajiniaaco seyaraca. Nojoriiri maninia miaquenuuquiaa taquiya. Nojori sumatuuri cureequiaajuhuaj. ¿Janiyarijiataj? ¡Janiyari niya quera cusoya cua miaajenutani! ");
INSERT INTO arlNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","¡Cua queecua tacateyarohuaraquij! Janiyacua na sequesuhuani: ‘Cua quenaa, janiyari Pueyaso miiquianu sesani. Janiyari sesa miiquianu quiajaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Majaari socua cua sequenu quia niyanuta. Janiyari puera sesa miijiani. Cua jiyatere juhuari juhua quia seru cua quiniuria, quiara cua poonijionura’”. ");
INSERT INTO arlNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Naa na niishiriojonu nuhuajitij, mashajaari quiaquiaariuhua na queecua. ’Tucuacaanu na quishacarijia na que tiajiniji, na queeri na niquirii. Nocua taraajereeri. Nocua neteyareeri na naacunura. Na cacaseeri. Na nujuunequereejaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Neyanuuri na que sequeree: “Cua quenaa, janiyari sesa miiquianu Pueyasoni, quiajaniyanio. Majaari cua sequenu quia niyanuta”. ");
INSERT INTO arlNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Na queeri saaja na tiaco seya sequeree: “¡Ritia! ¡Socua maniniuqui toque miji nia riquioo! ¡Niocua quiyanu cushitirinioj! ¡Jaaniisho nia cushitiri! ¡Sapatu nia cushitirijiuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pa riuutianishano juunu niquiojua nia quiacoo mosocoriquiano. Quiarijia pa queranacure. Pocua miaquenuureni, quiyanu pa shuquiritiasacari. ");
INSERT INTO arlNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nio quiyanuniyojuaari juhua macu quiriquiaa. Quiarijia samiitiarohuari. Nojuajaari shaajequiaari. ¡Tari pocua muetarohuari!” Naacuajitij, nojoriiri juhuacatecara queranacuquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Jiyacaritij, jiyapueranuuri cuhuariquiajinia quiriquiaa. Na tacatesacariuhua tiajiniohuara, jaara tari cateca quiriquiaa, saaja pueya tojirii jaaquequenuyanoori, nianujuniuyanonio. ");
INSERT INTO arlNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Naaratej, na que tiaco seru piiriiri: “Miji, cua sequere, ¿casaara tiajinia cojuatuneshiyani?” ");
INSERT INTO arlNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Seruuri na riucuaree: “Quia nuhuajishanacuaja tari tiuquiriohuano. Quia queeri shuquiriaatia quiya maninia na tiuquishacariuhua, maja cusosu. Naaratej, canaa sequereeri querasapiquia juunu niquiojua canaa monura”. ");
INSERT INTO arlNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jiyacaritij, jiyapueranuuri jiyanohua juaaquii. Majaari tiajinia na tiuquiniu paniniu quiriquiaa. Nocuaji na queeri nocua tohuatamaa carijiniacuma, na nenecojonura tiajinia na tiuquiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Na que sequeree saajaari: “Quiaacuajaari niishiya, janiyari pueyaracaanu poonijioquiaa quiarani. Majaari quenaaja cua tarijionu quiquiaa quiajaniya. Naa maninia tojijia cua quishacari quiajaniyatej, ¡majaari quia niquitionu quiquiaari janiya quenaaja niquiriyatu cabraniyojua, cua queranacunura cua rupuenaata! ");
INSERT INTO arlNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Quiarijia saniniuujia, quia niyanu seque tiuquishacariuhua, ¡quiaari querasapiquia juunu niquiojua moree nera! ¡Nojuajaari quia cumaneeca puecacanu paanatujuriicua!” ");
INSERT INTO arlNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Na queeri na sequeree: “Sanajanaa, quiaari pueyaracaanu cuata quiya. Puetunu cua jiitiasanojuanaari quia casaa. ");
INSERT INTO arlNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Naajaa, quiarijiani, maninia pa queranacure. Shuquiriaatia pa quirij. Quia tarajanuuri juhua macu quiriquiaa tari. Quiarijia samiitiarohua pajaniyaraari. Nojuajaari juhua tashucuacanu pocuaji. Quiarijia pocua muetarohuari”. ");
INSERT INTO arlNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesuuri na pueya pohuataquiaari nio miriqui pohuatasanojuhuaj, nojori na niishitiojonura: —Tamonu casamiriaca pueyanoori tamonu pueyano jiitiaja na casami cojuariquiano, na cumaneecanio. Tamasaca pueyari cuno camarnu pohuataree na seruna na cumaneeca riutiocoriquiaa jiyasohuaja, tama nerajaaja. ");
INSERT INTO arlNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Cunora, jiyaniijiaari cuno na seru sequeree: “¿Taa quia miiquiaa janiyani? ¡Quiaana sesa miiquiaa! Quiarijia cua niquitiore quia naajiotasano puetunu quia miishanojinijijianaa. Majaari socua quia quiniu quiniutianiya cua casami cojuana”. ");
INSERT INTO arlNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Cunora, cumaneeca cojuanaari niishiriojoquee. Tama sequereejaarijia: “¿Taa cua miiniutianiyarini cua jiyaniijia jaara cua jatare cua poonijiosanojiniji? Janiyari maja cumueecani, cuhuariquiajinia cua poonijionura. Naajuhuaj, jiyanohua cararaatiaari quiria, pueyajiniji nareja cua mashiniquijionura cua panishano. ");
INSERT INTO arlNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Jaj! Tari niishiquiinijia taa cua miiniutianiyani tamasaca taraajenura cucua, nojori masuunura janiya nojori tiajinia cua quiniuria, janiya jaara nio poonijiosanojiniji jatasaareni”. ");
INSERT INTO arlNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Naaratej, nojuajaari naa miiquiaari. Juhuacatecara sequequiaari pueyari, nojori nijionura nocua, canapue na jiyaniijia niquitiojoquiaari casamicuajani. Coteenu tiuquinia pueyano nequesotareeri: “¿Casaa cua jiyaniijia niquitiojocanu quiajaniyani?” ");
INSERT INTO arlNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Pueyanoori na riucuaree: “Cua niquitiocanu cien patacocua mishaja shiyocuani”. Cumaneeca cojuanaari na sequeree: “Ritia quia cajiri. Niya quiya quia masesano casamijiniji naajiotasano. Tamonu quiarinio quia miiri. Quia naajiotare saaja cincuenta patacocua mishaja shiyocua”. ");
INSERT INTO arlNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Na nuhuaji, tamonu pueyano nequesotareeri: “¿Quiajaniyariuhuaj? ¿Casaa cua jiyaniijia niquitiojocanu quiajaniyani?” Na riucuareeri: “Cua niquitiocanu cien canaasatu mishaja trigoni”. Cumaneeca cojuanaari na sequeree: “Niya quiya quia masesano casamijiniji naajiotasano. Tamonu quiarinio quia naajiotare saaja ochenta canaasatu mishaja trigo”. ");
INSERT INTO arlNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na jiyaniijia jaara niishiquiaari sesa na seru miishano, na sequereeri: “¡Quiaaqui jiyanohua niishijia tama quia cuaqueyajaaja quia cojuanura!” ’Seetanujuanaa pueyanaa, Pueyaso niishiyashijiaca pueyari socua jiyanohua niishijiaca cuhuashiqui quijiaca pueyajiniji. Nojori cutaraari niishijia maninia nojori miiniuria narta pueya, pueya paniniuria saniniuujia nojori. ");
INSERT INTO arlNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Naarate nia nacasuyanijia, naa capora nia quirijiuhuaj, maninia nia miiniuria pueya. Maja nia casami nia jamuenu. Cunocuajaari nareja Pueyaso niquitiosano niajaniya. Naacuajitij, capora nia quishacari mijiria jaara puequema, nia Jiyaniijiaari nia tiuquinitianutaniya pueyaracaanu quishaqui jiyocuacaanu, jiyanohua na shuquiritiasacari niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Pueyano jaara jiyatesaare secaja casami cojuana na quiniuria, nojuaja jaara maninia cojuaquiaa cuno secaja casami, na camarnuuri nocua tiuuniutianiya. Naaratej, na camarnuuri queraatia casami cojuanara na jiyatenutaniya. Saniniuujia, cante jiyatesaaree secaja casaa cojuana na quiniuriani, cuno pueyano jaara secaja na cojuasanojiniji nohuasejoquiaa jiyasohuaja, majaari tari nocua tiuushaanu. Nojuaja jaara jiyatesaare queraatia casami cojuanara, naa nohuasejonutaniyajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Naajuhuaj, niaa jaara maninia jiitiaaquiquiaa mijiria casami, Pueyasoori niaacua tiuyaquiniutianiya seetanujuanaa maninia jiyocuacaanuji casami nia jiitianura. ");
INSERT INTO arlNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Naacuajitij, niaa jaara tamonu pueyano casami cojuaaquiquiaa maninia, ¿Pueyasotucua taa niquitiore niaarano na riuriotacani? Maja cutaraari nia niquitiosaanu quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Poonitijiosano pueyanoori maja na naata caapiqui jiyaniijiara poonijionu. Jaara caapiqui jiyaniijiaraca quiri, tamonu samiritiaari, na panishacari tamonu. Naajuhuaj, niquiriyatu jiyaniijia tojijia quiniutianiya maniniaari, na soosacari tamonu. Naajuhuaj pueyanaa, majaari nia naata Pueyasoocua jiaatianu, cumaneecaacuanio. Niaa jaara cumaneeca panijia quiri, niaari cumaneecara poonijiotesaanutaniya saaja. Naacuajitij, Pueyasoori maja na naata nia poonitijionu nera. ");
INSERT INTO arlNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseocuacaari jiyanohua cumaneeca panijiaca quijia. Naaratej, nojori tojishacari Jesu sequesano, nojoriiri saaja na rerequeteree. ");
INSERT INTO arlNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesuuri nojori sequeree: —Niaacuajaari tama nia cuaqueyajaaja jiyatequiaa sapuenu pueyano maniniu nia niquishaanura. Pueyasocuajaari nioojia niishiya. Niaari pueya jiyajenetequiaa nojori jiyanishacari niaari Pueyaso panishano cutara, queraatia casami nia jiitiasacari. Saniniuujia, casaa pueya jiyatequiaa socua jiyanohua na panishanorani, Pueyasoori cuno soya cutara. ");
INSERT INTO arlNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Moisés Rootasano, mariyata puetunu tariucuacaanu Pueyaso sequenu panishano caminiujiuniaa pohuatasanojuanaari pueya tojitiasocoriquiano quiquiaari, Tiuquinijiona Juan pohuatasanojuhuaj. Quiarijia saniniuujia, maninia rupaa Pueyasojinijiiri pohuatasaaquiaa, taa Pueyaso jiyanooniu paniya pueyani, na muerasu nojori quiniuria. Quiarijiani, puetunu pueyajanaari jiyanohua saniniujiya Pueyaso muerasu nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Nio jiyari shaajeriquiano, jiya cajiniocuanio. Saniniuujia, tariucuacaanu pueyara Pueyaso sequesano caminiujiuniaa pohuatasano cutaraari maja na shaajenu quiniutianiya quenaaja. ");
INSERT INTO arlNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Pueyano jaara necocua cartere tamonu maajitia na caminiuria, cuno pueyanoori jiyanohua sesa miya Pueyaso niquiara. Naajuhuaj, cante cartesano maajitia camiyani, cunoori sesa miyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Casamiriaca pueyanoori quiquiaari. Jiyanohua maniniuqui toqueya cushiyojojuaari, juhua jiyaniijianucua toqueya. Jiyanohua na shuquiriniutia, puetunu juucajanaa queranacujujuaari. ");
INSERT INTO arlNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jiyacaritij, casamiijiu pueyanoori quijiajuhuaj. Jiyanohua sapueyaraca. Nojuajaari cuno casamiriaca pueyano tia tohuateyaji niojotasano puetunu juucajanaa. Na sesaari quijia Lázaro. ");
INSERT INTO arlNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nojuajaari casamiriaca miaquejajiniji totinijiosano raacua miaquenu panijia juucua. Saaja sareyari na sapueya rimianacunuujua. ");
INSERT INTO arlNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Na nuhuaji, cuno casamiijiu pueyanoori cusoquiaari. Pueyaso seyari na riquiaari supuetana Abrahamta na quiniuria, Pueyaso muerasurano shanohua quiquiojinia. Cuno casamiriaca pueyanoori cusoquiaarijiuhuaj. Jamosaaquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Sesa miijiacarano quiquiojinia na quishacari, naquiya na miishacari tii, nojuajaari mauquiaari. Cuniquiji tucuacaanu niquirii Lázaroori, shuquiriaatia quiyano supuetana Abrahamta. ");
INSERT INTO arlNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Casamiriaca pueyanoori nacaree: “¡Cua supuetana Abrahamnaa, cucua quia taraajere quenaaja! ¡Lázaro quia jiyarore cucua! ¡Cuaara na juaashiquia nacatu shiiria mohuacajinia! ¡Cua niti shiniajaquee quenaajacua! ¡Janiyari puera jiyanohua naquiya miya nio manijiniani!” ");
INSERT INTO arlNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamri saaja na riucuaree: “Sanajanaa, quia niishiri taa jiyanohua maninia quia quiquiaarini, pueyaracaanu jiyocua quia quishacari. Lázaroori saniniuujia jiyanohua taraatia quiquiaari pueyaracaanu, jiyocua na quishacari. Lázaroori quiarijia niya cumanijiashiya. Quiaari saniniuujia naquiya miishiyacujua. ");
INSERT INTO arlNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Naajuhuaj, jiyanohua tucuaa tacoori pa tajinia quiya. Cunora, cante niiquiji niuuniu paniya cuniquijiria quiocuani, majaari na naata. Naajuhuaj, cante quia quiquiojiniji niuuniu paniya niiquijiriani, majaari na naatajuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Casamiriaca pueyanoori supuetana Abraham sequerohuacuhuaj: “Naa naasucuaj cua supuetana Abrahamnaa. Naajaa, quia secojiyanijia, Lázaro quia jiyarorohua cua que tiajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tii quiyajaari cua tapueyocuaca. Cinco tarajanuhuaracanijia. Lázaro cuaara nojori numooteera, maja nojori quejoosaanurajuhua nio saniitiosaqui quiquiojinia”. ");
INSERT INTO arlNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamri na riucuaree: “Nojoricuajaari Moisés Rootasano jiitiaa, puetunu Pueyaso sequesano caminiujiuniaa naajiotasanojuanaanio. Quia tapueyocuaca cuaara tojitiaara cuno”. ");
INSERT INTO arlNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Casamiriaca pueyanoori riucuaree: “Naa naasucuatuhuaj, cua supuetana Abrahamnaa. Naajaa, tamonu pueyano macunucuajinijinio jaara muetarohua nojoriicua, nojoriiri noojia tacatonutaniya sesa nojori miiniujiniji”. ");
INSERT INTO arlNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abrahamri saaja na riucuaree: “Nojori jaara Moisés Rootasano tojitianu paniyaquiquiaa, Pueyaso sequesano caminiujiuniaa naajionuutasanonio, majaari nojori tojitianu quiniutianiyajuhuaj, macu pueyano jaara samiitiarohua”. ");
INSERT INTO arlNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na nuhuaji, Jesuuri na pueya sequequiaari: —Mijiria, pueyari pueyaracaanu sesa miitishaaquiaa. Jiyanohua taraatia quijiaari cuno, cante sesa miitirii tamonuni. ");
INSERT INTO arlNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Jiyano pueyanoratej, maara socua maninia quiri nera, puereetuuca saajia jaara na riquiajiniji morotasaare, shoniniacu caminia jiuujiajinia jartasocoriquiano. Jaara naa miishaaretej, maara maninia quiri, maja sesa miijiara na jiyatenura niquiriyatu nio muerasuniyojuajinijinio. ");
INSERT INTO arlNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cunora, tama nia cuaqueyajaaja nia cojuare maja quenaaja sesa nia miitiniuria pueya. ’Quia tarajanu jaara sesa miiri, quia nacasurenoj. Nojuaja jaara taraajerohua sesa na miiniuucua quiajaniya, quia jiyanoorinioj. ");
INSERT INTO arlNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nojuaja jaara sequeyarucua sesa miya quiajaniya niquiriyatu juuca, naajaa, quia jiyanooriquia, nojuaja jaara quia sequere: “Sesa miirii quiajaniyanijia. Cua jiyanoori quenaaja”. Nojuaja jaara quia pacutejore sesa miiniu siete cuno juucaja, naajaa, majaari na tarinitianu jiyanooniu. ");
INSERT INTO arlNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesu saquiriojosano pueyari Jesu sequequiaari: —Jiyaniijianaa, socua jiyanohua canaa quia tiuutiri Pueyasoocua, socua cumaaca canaa jiitianura. ");
INSERT INTO arlNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jiyaniijia Jesuuri nojori riucuaree: —Pueyasoocua nia tiuuniu jaara quiri quenaaja juhua mostaza jajauniyojua, jiyanohua shiitianiyojua, niaa jaara nio satuna jiyona sequere: “Niiquiji quia pacure. Moojinia quia nujuasee”, maara nia sequesano tojiri. ");
INSERT INTO arlNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Niaa jaara seruraca quiriquia, nojuaja jaara tiajinia tiuquiriohua quia cuhuariquiajiniji tee na namitiariquiaacuajani, quia seya cojuanujiniji soj, ¿niaatucua na sequere: “Miji, quia miaquesuhuaja”? ");
INSERT INTO arlNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Majaruhua. Niaari saaja na sequenutaniya: “¡Quiria quia sumature! Cua mianuutere coteenu. Cua raaterejuhuaj. Cua miaquenu nuhuaji, quiocua saniniuujia miaquerohua. Quiocua raturohuajuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na nuhuaji, nia seru jaara puetunu nia sequesanojuanaa miiri, ¿niaateeri na sequequiaa “paacarasho”? ¡Maja! ");
INSERT INTO arlNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Naajuhuaj, niaa jaara puetunu Pueyaso sequesanojuanaa miiri, tama nia sequerejaaja: “Janiyari maja maninia seruni. Majaari tama cua niishitiajajinijijiaaja cua miiniu quiquiaa cua Jiyaniijiara. Janiyari saaja pueyaracaanu paniquiaa cucua na tequejonura juhua naatujuaacuani”. ");
INSERT INTO arlNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesuuri Jerusalén tiacajiniara na pueyata quiariquiaacuhuaj. Jiyacari, Galilea jiya, Samaria jiya tajiniaaco quiariquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Quera na tiuquishacari shiitianiyojua tiacajinia, diez pueya lepraraca cusosuhuari na naacuquiaari. Nojoriiri tucuacaanujijia Jesuucuaji nujuatusee. ");
INSERT INTO arlNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nojoriiri Jesuucua nacaree: —¡Niishitiojona Jesunaa, canaacua quia taraajere! ");
INSERT INTO arlNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesu niquishacari nojori, nojori sequereeri: —Nia cuaqueya nia niquitishii pueyacuara secojonaa, taa supuetana Moisés sequequiaaricuajani. Nojori canujuucuatusacarijia, nojori cusonuuri shaajequee. ");
INSERT INTO arlNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tamonu nojorijinijinio niquishacari na cuaqueya tari cushiriiquii, nojuajaari Jesuucua tacateyarohua. Nojuajaari na rupaa paaretariquiaa na maniniuhuaqueetasacari Pueyaso. ");
INSERT INTO arlNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesu cariquimiaji mojoquetaseeri. Jiyocuara naniriiri. Jesu sequereeri: “¡Paacarasho Jesunaa!” Cuno pueyanoori Samaria jiyajinijinio tahue quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesuuri na pueya niquiara naa sequeree: —¿Majateeri diez cusosuhua naatanijiosaanu quirii? ¿Teeteeri narta naataconohua nueve pueyani? ");
INSERT INTO arlNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Saaja nio tahueteeri tacaterohua Pueyaso na maniniuhuaqueetanura? ");
INSERT INTO arlNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na nuhuaji, Jesuuri cuno tahue sequeree: —Quia sanere. Quia quiaarohua. Quiaacuaja naatarohua cucua quia tiuuniuucua. ");
INSERT INTO arlNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseocuacaari Jesu nequesotaquiaari taacari Pueyaso Jiyarosocoriquiano niniutianiya jiyaniijiara na quiniuria mijiriani. Jesuuri nojori riucuaree saaja: —Pueyaso Jiyarosano jiitiasacari na muerasu, majaari namijiata niquishano. ");
INSERT INTO arlNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Majaari na naata sequesaanu: “Niya quiya pa Jiyaniijia quiquio”, “Jati quiyaruhua”. Pueyasocuajaari tari niya jiitiaa na muerasu nia tajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Na nuhuaji, Jesuuri tama na pueyajaaja sequequiaari: —Na nuhuaji, taraatia quishacariiri quiniutianiya. Niaari cua niquiniuucua jiaatianutaniya niaata cua quiniuria rupaquijia, taa niaata cua quiya quiarijiacuaani. Majaari nia niquiniu quiniutianiya janiya. ");
INSERT INTO arlNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tamasacaari nia sequenutaniya: “¡Niya quiyacuaja nia Jiyaniijia!” Tamasacaari saniniuujia sequenutaniyacujua: “¡Nooj, jati quiyatej!” Majaari nia tojiniu jiyano pueyatej, nojori jaara naa nia sequeriquia. Majaari nojori neteyotanu najuhuanaj. ");
INSERT INTO arlNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mijiria cua tacatesacariuhua, cuno juuca, janiyari niquishaanutaniyani, naatej, taa miacana puetunu jiya cajiniocuajanaa niquishaaquiaacuaani na nunujusacari. ");
INSERT INTO arlNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Saniniuujia, mijiria cua quishacarijia, janiyari coteenu jiyanohua naquiya miishaanutaniyani. Nio pa quishacari pueyari cua paniyaquiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Quera cua tiuquiniu panishacariuhua mijiria, naa quiniutianiyari taa mijiria quiniaa pueya quiquiaaricuaa supuetana Noé quishacarini. ");
INSERT INTO arlNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Naa quiquiaariiri cuno quishacari. Mijiria quiniaa pueyari juhuajaniya miaquenuujua. Raruujuaari. Juhuajaniya maaji camiyojuaari. Pueyari necojori camiyoteja. Pueyari naa juhuajaniya miijioriquiaa Noé jaara tiuquitiaquiaari na puereetuuca buquejinia. Canashiyaquiji, maruuri jiyanohua niquiaari. Puetunu mijiria quiniaajanaari cusonuuquiaari pajaacajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Naa quiquiaarijiuhua supuetana Lot quishacari Sodoma tiacajinia. Cuno pueyari juhuajaniya miaquenuujua. Raruujuaari. Casami masejojuaari. Juhuajaniya na casami niquitiojojuaari. Na cuhuariquiaca natoojuaari. Na tiacara tiajojuajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Naa juhuajaniya nojori quishacaritij, Lotri tohuataquiaari Sodoma tiacajiniji. Jiyacaritij, maniiri asufreta cojitishano juhua maru niquiaari jiyocuacaanuji. Puetunu cuno sesa miijiacajanaari manijinia catequiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Naa quiniutianiyajaariuhua quera jiya puequesacari. Pueyari juhuajaniya quiniutianiya. Janiyari jiyacari canashiyaquiji tiuquiniutianiuhuani. ");
INSERT INTO arlNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Cuno juuca, pueyano jaara na tia cacojiria quiya, cuaara roseyaquiiria na casamiicua tiajiniaaco. Naajuhuaj, pueyano jaara na cuhuariquiajinia quiya, nojuaja cuaara tacateyaquiuhuara na tiajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nia niishiriquia supuetana Lot niquiocua. Na mashishacari, nojuajaari ritia cusoquiaari na nijiniara na niquiniuucua, na casamiicua na taraajesacari. ");
INSERT INTO arlNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Cante saaja shuquiriaatia mijiria na quiniuria niishiriojojuani, nojuajaari na nuhuaji jiyanohua taraatia quiniutianiya Pueyasooju. Saniniuujia, cante tama na cuaqueyajaaja panitiaja cua tojijiara na quiniuriani, nojuajaari pueyaracaanu shuquiriaatia quijiara jiyatesaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Cua tojiri. Cuno niucuajuhuaj, caapiqui pueya jiuriatoosacari juucua na maquetujinia, niquiriyatujuaari rishaanutaniya jiyocuacaanura, Pueyaso pueyano na quiniuucua. Tamonuuri tiujiasaanutaniya saniitiosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cuno juucajuhuaj, caapiqui maajipohua riiquiniuushacari jatiqui juucua, cucua tiuujiaari tarajanu shuriucuaji rishaanutaniya. Tamonuuri tiujiasaanutaniya saniitiosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Caapiqui pueya quishacari cuhuariquiajinia, cua pueyanoori rishaanutaniya. Tamonuuri tiujiasaanutaniya saniitiosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesu pueya tojishacari naa Jesu sequesanotej, nojoriiri na nequesotaree: —¿Tee nio quia pohuatasano niquishaanutaniyarini? Jesuuri nojori riucuaree miriqui: —Tee casaa moqueyani, mohuari tii rerejiya. Naajuhuaj, majaari quenaaja niquiriyatu Pueyaso tojiyashijia cureenu quiniutianiya saniitiosoo. ");
INSERT INTO arlNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesuuri na pueya pohuataquiaari nio miriqui pohuatasano nojori na niishitiojonura, nojori cuaara Pueyaso secojoora pueyaracaanu, nojori taacanuyaquiniutia. ");
INSERT INTO arlNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Naa nojori sequereeri: —Tamonu tiacajinia, pueya nequesoreena pueyanoori quijia. Pueyaso puereyashijia quijiaari, pueya rerequetejanio. ");
INSERT INTO arlNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Cuno tiacajiniaja tamonu mashiquioori quiquiaarijiuhuaj. Mashiquioori cuno nequesoreenaacua rucuanejojua pueyaracaanu. Na secojojuaari sesa na miinia pueyano cuaara na niquitiohuara na casaa saniniuujia, sesa na miishanojiniji nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Majaari nequesoreena tojiniu paniniu quijia pueyaracaanu cuno mashiquio. Naajaa, pueyaracaanu nocua na rucuanejosacari, cuno nequesoreenaari socua tama sequequiaarijiaaja: “Janiyari maja Pueyaso puerejani. Janiyari pueya tojiyashijia cutarani. ");
INSERT INTO arlNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Naajaa, naa nio mashiquio taajetesacari janiya pueyaracaanutej, janiyari quiarijia na panishano miiniutianiya nerani, mariqui cua juaatijiore pueyaracaanuuri na nenecojosacari janiya”. ");
INSERT INTO arlNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Maninia na pueya niishiniuria na pohuatasano, Jiyaniijia Jesuuri naa nojori sequerohuacuhuaj: —Naa miiquiaariiri, cuno pueya nequesoreena seque. Jiyanohua pueya rerequeteja quiquiaariiri, naajaa, nojuajaari maninia miiquiaari cuno mashiquiora. ");
INSERT INTO arlNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Nia que Pueyasoorijiataj? ¿Niaateeri jiyaniya maja nojuaja tojiniu quiniutianiya na muerasu, canapuete na secojoquiaani juuca, niucuanio? ¿Pueyasoteeri nia sashitiniutianiyajaara? ¡Maja! ");
INSERT INTO arlNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nojuajaari maja na tarishiniu quiniutianiya. Ritia nia naacunutaniyari sesa nia miijiaca pueyacuaji. Sesa nia miijiacaari namishaanutaniya niaacua. Naaratej, majaari secojonu nia tarinitianu. Mijiria cua tiuquishacariuhua, ¿janiyate Pueyasoocua tiuujiaca riuriatanutaniya naa pueyaracaanu secojonuujuacani? ");
INSERT INTO arlNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesuuri socua nio miriqui pohuatasano pohuataquiaari noo pueya niquiara, canapuete tama na cuaqueyajaaja jiyanijiani nojoriiri maninia pueyano. Naacuajitij, nojoriiri tamasaca pueya soojea, nojori jiyanishacari cuno pueyari socua sesa miijiaca nojorijiniji. Cunora, Jesuuri nojori niquiara naa pohuataquiaari: ");
INSERT INTO arlNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Fariseo pueyanoori quiaquiaari Pueyaso Secojojua tiajinia na secojonura Pueyaso. Jiyacaritij, Romano jiyaniijiara cumaneeca masejojua pueyanoori quiaquiaari Pueyaso na secojonura tiijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo pueyanoori nujuariquiaa Pueyaso na secojosacari. Naa sequeriquiaari: “Pueyasonaa, paacarasho janiyari maja juhua tamasaca pueyani. Tamasaca cutaraari nohuasenuujuaca, sesa miijiaca, maaji porocuajuhuaj. Naajuhuaj, shuquiriaatia quiyanijia, janiyari maja sesa miijiani juhua nio pueyanojua niya cuata secojiyani, cumaneeca masejona pueyanoni. ");
INSERT INTO arlNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Janiyari caapiqui juuca miaqueyaquiquiaani puetunu semaanajanaa cua shuquiritiniuria quiajaniya. Naajuhuaj, janiyari pueyaracaanu puetunu cua masesanojinijijianaa niquitioquiaa quiarani, taa Moisés rootaquiaaricuajani”. ");
INSERT INTO arlNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Cumaneeca masejonaari saniniuujia tucuacaanuji nujuasee. Na secojosacari, majaari quenaaja na maunu quiriquiaa jiyocuacaanu. Tama nojuajaari na jiriquia piquiriquiaa na taraajenuta sesa na miishanojiniji. Naa sequereeri: “Pueyasonaa, cucua quia taraajere. ¡Cua jiyanoori! ¡Sesa miijianijia!” Naa secojoquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Seetanujuanaa nia sequeyanijia, cumaneeca masejonaari Pueyaso jiyanooshano tacateyarohua cutara. Fariseo pueyanoori saniniuujia jiyanoyaquishoo tacateyarohuacujua. Naacuajitij, cante tama na cuaqueyajaaja jiyateya juhua maninia pueyano na quiniuria tamajaajani, nojuajaari cararosaanutaniya. Saniniuujia, cante sesa na miishano seetaaquijiani Pueyaso jiyanooniuria nojuajani, Pueyasoori cuno pueyano jiyatenutaniya seetanujuanaa sesa miyaquijia na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jiyacaritij, conaajaari poosaariquiaa Jesuucua, Jesu nianura nojoriicua na juaashiquia, Pueyaso jiitianura maninia nojori. Jesu saquiriojosano pueya jaara niquiquiaari conaaja pooshiyano Jesuucua, nojoriiri na poonaa juaarii. ");
INSERT INTO arlNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesuuri saaja conaaja poonaa sequeree, conaaja cuaara nocua poosaaria. Na nuhuaji, na pueya sequereeri: —Naatujoori cuaara poosaaria cucua. Maja na poonaa tenujunu. Cante Pueyaso muerasura quiniu paniyani, nojori cuaara jiyateera tama na cuaqueyajaaja juhua nio naatujooriria. ");
INSERT INTO arlNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Seetanujuanaa nia sequeyanijia, cante tama na cuaqueyajaaja jiyateyaquiya juhua naatujooriria Pueyaso rupaacua na tiuuniuriani, cuno pueyanoori maja na naata Pueyaso muerasura na quiniu. ");
INSERT INTO arlNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tamonu Judiocuaca camarnuuri Jesu nequesotaquiaari: —Maninia niishitiojonanaa, ¿taa cua miiniutianiyani, jiya puequesacari cua samiitianishaanura, pueyaracaanu quijiara cua quiniuria Pueyasotani? ");
INSERT INTO arlNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesuuri na riucuaree: —¿Casaara quia sequeya janiya maninia pueyanotani? Saaja Pueyaso cutaraari seetanujuanaa maninia. Majaari socua tamonu quiniu. ");
INSERT INTO arlNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pueyanonaa, quiaacuajaari Moisés Rootasano niishijia. Naa naajiotasanocuajaari quiya: “Maja quia camishoo maaji numuetucunu. Maja monu. Maja nohuasenu. Maja tamonuucuara saquiriojotanu quia sapojonuta. Quia que, quia nucua tojijia quia quiri”. ");
INSERT INTO arlNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Pueyanoori Jesu riucuaree: —Janiyacuajaari cua naatujuajiniji puetunu cuno tojijiajanaani. ");
INSERT INTO arlNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Naa na sequesacaritij, Jesuuri na sequeree: —Quiyajaari niquiriyatu casaa quia miishoojua. Nio quia miiri: puetunu quia jiitiasanojuanaa quia niquitiojore cumaneecara. Na nuhuaji, casamiijiuniucua pueya cuno cumaneeca quia niquitiojore nareja. Naacuajitij, quiaari jiyanohua casamiriaca quiniutianiya cutara jiyocuacaanu. Na nuhuaji, quiocua nimiohua cutara, cua pueyano quia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Na tojishacari Jesu sequesano, nojuajaari jiyanohua taraajequee, jiyanohua queraatia casamiriaca na quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesu niquishacari nojuaja taraajeyano, Jesuuri na pueya sequeree: —Casamiriaca pueyara, jiyanohua jiyajenetaari Pueyaso muerasu nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","¿Camelloteeri na naata cusupuetaja cuhuoco tamajiria tajiniu? Maja na naata. Naajuhuaj, casamiriaca pueyanora, socua jiyanohua jiyajenetaari Pueyaso muerasu na jatanishaanura. ");
INSERT INTO arlNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Pueya tojishacari naa Jesu sequesanotej, nojoriiri naa na nequesotaree: —¿Canteeri Pueyaso muerasura quiniutianiyanitioj? ");
INSERT INTO arlNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesuuri nojori riucuaree: —Maja pueya na naata tama na cuaqueyajaaja jiyatenu Pueyaso muerasu nojori quiniuria. Naajaa, Pueyaso cutaraari na naata. ");
INSERT INTO arlNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedroori Jesu sequeree: —Jiyaniijianaa, ¿canaarijiataj? Canaari puetunu canaa jiitiasanojuanaa tiujiaquiaarini canaa nuhuajiniuria quiajaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesuuri na riucuaree: —Seetanujuanaa nia sequeyanijia, cante na panishano casaa tiujiaquiaari Pueyasora na poonijionurani: na tia, na que, na nucua, tapueyocuaca, necocua, necohua, nojuajaari socua jiyanohua queraatia masenutaniya mijiria na quishacarijia. ");
INSERT INTO arlNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Na nuhuaji, samiitianishano quiniutianiyari pueyaracaanu shuquiriaatia na quiniuria Pueyaso shipinishocoriquiano quiarinio jiyajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesuuri saaja na doce saquiriojosano pueya jiyataaree tamocora. Naa nojori sequereeri: —Paari quiarijia Jerusalén tiacajinia quiaani. Janiyari quiniqui puetunujuanaa miishaanutaniyani taa tariucuacaanu pueyara Pueyaso sequesano caminiujiuniaa sequequiaaricuaja janiyajinijini. ");
INSERT INTO arlNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Naacuajitij, janiyari tahua niquitiosaanutaniyani. Nojoriiri cua macaatiniutianiya. Taraatia cua miitiuniutianiyari. Cua riocojotunutaniyari. ");
INSERT INTO arlNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Cua piquitiuniutianiyajaariuhuaj. Na nuhuaji, cua motunutaniyari. Naajaa, jiuujianaraca juucajinia, janiyari samiitianutaniuhuani. ");
INSERT INTO arlNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Majaari Jesu pueya niishiniu quiriquiaa quenaaja na sequesano. Majaari nojori niishiniu quiriquiaa casaa Jesu sequeriquiaani. Juhua miriqui sequesanoori quiriquiaa nojoriria. ");
INSERT INTO arlNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Na pueyata Jesu quishacari tari cateca Jericó tiacaacuara, cariyojuaru pueyanoori nuu shuucuaji cajiriquiaa, cumaneeca na masejonura pueya tajishacari nucuaco. ");
INSERT INTO arlNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cariyojuaru tojishacari queraatia pueya tajiyano, pueya nequesotareeri: —¿Casaatejanojoni? ");
INSERT INTO arlNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pueyari na sequeree: —Nazaret tiacajinijinio Jesucuaja tajiya. ");
INSERT INTO arlNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Cariyojuaruuri nacaquee: —¡Jesunaa! ¡Supuetana David niquiohuacuajinio supueno pueyanonaa! ¡Cucua quia taraajere quenaaja! ");
INSERT INTO arlNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jesu puetanaa pueyari na juaarii na sanaajanura juucua. Nojuajaari saaja socua jiyanohua nacaree: —¡Supuetana David niquiohuacuajinio supueno pueyanonaa! ¡Cucua quia taraajere! ");
INSERT INTO arlNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesu tojishacari nojuaja, nujuaseeri. Jesuuri pueya sequeree cariyojuaru cuaara jaatucusaaria nocua. Cariyojuaru tiuquishacari nocua, Jesuuri na nequesotaree: ");
INSERT INTO arlNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Casaa quia paniya cua miiniuria quiajaniyani? Cariyojuaruuri Jesu riucuaree: —¡Jiyaniijianaa, niquijiara quiniu paniuhuanijia! ");
INSERT INTO arlNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesuuri na sequeree: —¡Niquijiara quia quiriohua! Quia namijiacuaja tari jeequerohua cucua quia tiuushacari. ");
INSERT INTO arlNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jiyacaritij, cariyojuaruuri maninia niquijiara quiquii. Jesu nuhuaji sacuaareeri na shuquiritianuta Pueyaso. Puetunu Jesu miishano niquiniaajanaari Pueyaso maniniuhuaqueetariquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesuuri Jericó tiacajinia tiuquiijioquiaari na pueyata. Tiaca jiuujiaaco quiariquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Cuno tiacajinia quiquiaariiri casamiriaca pueyano. Na sesa quiquiaari Zaqueo. Zaqueori Roma tiacajinia quijia jiyaniijiara cumaneeca masejonaa camarnu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nojuajaari Jesu niishiniu panijia juucua. Majaari na naata niquiniu quiriquiaa Jesu, puera jiyanohua pueya quiniuucua Jesu shocua. Naajuhuaj, Zaqueori puera posucuashi quijia. ");
INSERT INTO arlNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Cunora, Zaqueori netequiaari Jesu tacoji. Nuu shuucuaji sicómoro naanaacua macaseeri, maninia na niquiniuria tiji Jesu, jaara cunoco tajimia. ");
INSERT INTO arlNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesu tajishacari Zaqueo cariquiaco, Jesuuri nocua mauree. Na sequereeri: —Zaqueonaa, ¡ritia quia rosemohua! Janiya quiarijia quia tiajinia maquenutaniyani. ");
INSERT INTO arlNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueori ritia rosemohua. Jesu tiuquinitiaree na tiajiniaari jiyanohua na shuquiriniutia. ");
INSERT INTO arlNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tamasaca pueya jaara Jesu niquiquiaari Zaqueo tiajinia tiuquiyano, puetunu nojorijianaari Jesu sesacanu coteequiaari. Tama sequeturiquiaajaarijia: “Cuno pueyanoori sesa miijia pueyano tiajinia tiuquishii”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na nuhuaji, Zaqueori nujuaree. Jesu sequereeri: —Seetanujuanaa quia sequeyanijia, Jiyaniijianaa, janiyari quiarijia quiocua tiuuriini. Naacuajitij, janiyari casamiijiuniucua nareja niquitiojonutaniya puetunu cua jiitiasano cajiniocuajinijijianaani. Naajuhuaj, janiya jaara puera cumaneeca masecanu tamasaca pueyajiniji cua sapojonutani, janiyari nojori niquitionutaniuhua socua jiyanohua queraatia cumaneecani cua nohuasesanojiniji nojori. ");
INSERT INTO arlNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesuuri na sequeree pueya niquiara: —¡Quiarijiani, nio tiajinia quiniaa pueyari tari jiyanooshaaree! Nio pueyanocuajaari supuetana Abraham niquiohuacuajinio supuenojuhuaj. Nojuajaari cucua tiuurii taa Abraham tiuuquiaari Pueyasoocuacuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Janiyacuajaari cunora mijiria niquiaarini, tashucuano pueya cua pajenura, nojori cua jaariutianura Sesaaca. ");
INSERT INTO arlNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tii quiniaa pueyari Jesu pohuatasano tojitiariquiaa. Jesuuri tari cateca quiriquiaa Jerusalén tiacajiniji. Pueyari jiyaniriquiaa Jesuuri Israel pueya jiyaniijiara quiniutianiya tari, Pueyaso muerasu na jiitianura mijiria. Nocuaji, Jesuuri nojori pohuataree nio miriqui pohuatasano, nojori na niishitiojonura. ");
INSERT INTO arlNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naa nojori niquiara pohuatareeri: —Tamonu jiyaniijia niyanuuri quiquiaari. Nojuajaari tucuacaanu tamonu jiyajinia quiaquiaari jiyaniijiara na jiyatesaanura. Jiyaniijiara na jiyatesaanu nuhuaji, nojuajaari tacateriquianohua quiriquiaa, narta pueya jiyaniijia na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na nuhuajiria, nojuajaari diez na seya sequeree nocua nojori nijionura. Nojuajaari puetunu nojorijianaa niquitiojoree niquiriyatu cumanee, orojiniji shipinishano. Nojori sequereeri: “Nio cumanee nia poonitijiore, janiya cuaara tiuquiriohuajaatiinijiaj”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Na nuhuaji quiaqueeri. Na jiyajinijinio pueyari maja na niquiniu paniniu quijia cuno pueyano. Cunora, nojoriiri pueya jiyaramiquirii na nuhuaji, jiyaniijiajanaa nojori sequenura: “Maja canaa paniniu cuno pueyano, canaa jiyaniijia na quiniuria”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Naajaa, nojuajaari saaja jiyatesaaree jiyaniijia na quiniuria. Na nuhuaji, na jiyajinia tacateyarohuari. Jaara tiuquishuhua, na cumaneeca na niquitiojosano seya sequereeri, nocua nojori nijionura. Nojuajaari niishiniu paniriquiaa taa cumaneeca socua nojori reratequiaarini, nojori poonitijiosacari na niquitiojosano cumaneeca. ");
INSERT INTO arlNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Coteenu seruuri nocua nimiaa. Na jiyaniijia sequeseeri: “Cua jiyaniijianaa, cua poonitijiosacari quia niquitiosano cumanee janiya, janiyari socua diez cumaneeca reratecanuni”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Na jiyaniijiaari na sequeree: “¡Maniniacuaja! ¡Quiaacuajaari maninia cua seru! Quiaari secaja cua niquitiosano quiajaniya poonitijioriquiaa shitimia quiria. Naaratej, janiyari quia jiyatenutaniya diez tiaca jiyaniijiara quia quiniuriani”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na nuhuaji, tamonu na seruuri nocua nimiaajuhuaj. Nojuajaari na jiyaniijia sequeree: “Cua jiyaniijianaa, cua poonitijiosacari quia niquitiosano cumanee janiya, janiyari socua cinco cumaneeca reratecanuni”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Na jiyaniijiaari na sequereejuhuaj: “Quiaari cinco tiaca jiyaniijiara quiniutianiya”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Na nuhuaji, tamonu na seruuri nocua nimiaajuhuaj. Na jiyaniijia sequeseeri: “Jiyaniijianaa, niya quiya quia cumanee quia niquitiosano janiya. Janiyari na cojuacanu maniniani, toqueraujinia jiuniocosano. ");
INSERT INTO arlNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Janiyari naa miiquianuni cua pueresacari quiajaniya. Janiyari niishiyani, quiaari quiarta pueyacua taraajeyashijia. Quiaari tamasaca racatasanojiniji poojua. Quiaari tamasaca natoosanojiniji senoojuajuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Na jiyaniijiaari na juaarii: “Sesaacanaa, tama quia sequesanotajaaja janiyari quia nequesoreenutaniyani. ¿Naatee? ¿Quiaateeri niishiquianu janiyari pueyacua taraajeyashijiani? ¿Janiyateeri tamasaca racatasanojiniji poojuani? ¿Janiyateeri tamasaca natoosanojiniji senoojuajuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Quiaa jaara jiyaniquianu janiya naa miijiani, ¿casaara cua cumanee quia niquitioyaquiquianu cumaneeca cojuanaarini? Nojori jaara cua cumanee poonitijiocanu, janiya maara socua queraatia na riuriatasuhuani, cua tiajinia cua tiuquishacariuhua”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Cunora, na jiyaniijiaari tii quiniaa pueya sequeree: “¡Cua cumanee nia jaariutiare cuno! Nia niquitiore cua maninia seru, cante diez cumaneeca jiitiaacuajani”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nojoriiri na sequeree: “Jiyaniijianaa, ¿casaarateni? Nojuacuaja tari diez cumaneeca jiitiaa”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jiyaniijiaari saaja nojori riucuaree: “Seetanujuanaa nia sequeyanijia, cante tari jiitiaani, nojuajaari socua niquitiosaanutaniya. Cante na jiitiaaquiyani, secaja na jiitiasanoori puetunujuanaa jaariutiasaanutaniya, cucua tiuyashijia na quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Quiarijia, cua paraa saniniuujia, cuno pojori canapuete cua paniyaquiquianu nojori jiyaniijia cua quiniuriani, miji nia jayore nojori. Niya cua niquiara nia puecoore cua ruuretajaca seque”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nio na pohuatanu nuhuaji, Jesuuri na pueya puetaareecuhuaj Jerusalén tiacajiniara. ");
INSERT INTO arlNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jaara cateca quiriquiaa tari Betfagé tiaca, Betania tiacanio, Olivo cuhuariquia tuhuananujuhuaj, Jesuuri caapiqui na pueya sequeree: ");
INSERT INTO arlNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Cuno shiitianiyojua tiacajinia nia quiaare, pa tacoji niquishiyani. Niaa jaara tiuquishii, niaari burro riuriatanutaniya morotasano, pueyano cajishoojua na nijinia. Niaa jaara na niquishii, niocua na samaacartasee. Niaari na jaatucumohua miji. ");
INSERT INTO arlNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pueya jaara nequesotare niajaniya casaara nia samaacartaanoj, niocua na riucuare: “Jiyaniijia na paniya”. ");
INSERT INTO arlNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jesu pueyari quiaaree. Nojoriiri na riuriatasee taa Jesu sequequiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nojori samaacartasacari burro, na camaruhuari nojori nequesotaree: —¿Casaara nia samaacartaa canaa burroni? ");
INSERT INTO arlNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nojoriiri na riucuaree: —Jiyaniijia na paniya. ");
INSERT INTO arlNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na nuhuaji, nojoriiri na jaatucuyarohua Jesuucua. Jesu pueyari na toqueya niojoree burro nijinia Jesu cajijiara. Na nuhuaji, nojoriiri Jesu cajitirii na nijinia. ");
INSERT INTO arlNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na quiasacari Jerusalén tiacajiniara, pueyari na toqueya muejoquiaari nucuaco Jesuucuaji. ");
INSERT INTO arlNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nojori rosetanu panishacari Olivo cuhuariquia tuhuananujiniji, puetunu Jesu pueyajanaari juhuacatecara nacooquiaari nojori shuquiriniutia. Nojoriiri Jesu maniniuhuaqueetariquiaa puetunu na cumaacata na miishanojuanaa nojori niquiniuucua. Nojoriiri cunora jiyanohua shuquiritiariquiaa Pueyaso. ");
INSERT INTO arlNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nojoriiri naa nacooriquiaa: —¡Pueyaso cuaara shuquiritiiria pa Jiyaniijia, Pueyaso Jiyarosano na quiniuucua! Pueyaso pocua taraajerohuani. Pa jiyanooriohuani. ¡Nojuajaari jiyanohua maninia! ¡Pa shuquiritiarenoj! ");
INSERT INTO arlNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Cuniqui pueya tajinia quiniaa Fariseocuaca tojishacari naa nojori sequesanotej, nojoriiri Jesu sequeree: —¡Niishitiojonanaa, quia pueya quia sanaajare, maja naa nojori sequenura! ");
INSERT INTO arlNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesuuri saa sequereejaa: —Seetanujuanaa nia sequeyanijia, nio pojori jaara sanaajetare, ¡sairi saniniuujia nacoonutaniyacujua! ");
INSERT INTO arlNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tari Jesu quishacari Jerusalén tiaca shuriucua, na niquishacari cuno tiaca, Jesuuri cuno tiacajinia quiniaacua nujuqueree. ");
INSERT INTO arlNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Cunora, juhua pueyano sequeree Jerusalén tiacaari: —Jerusalén tiacanaa, quia niishitiriquia quiarijiani, casaa quia paniya jiyanooshano quia quiniuriani, shuquiriaatia quia quiniuriajuhuaj. Taraatia quijianaa, quia Jiyanooriquianoori juucua niya quiya. Majaari quia niishiniu nojuaja, juhua nimishitiu quia quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Cunora, na nuhuajiiri jiyanohua taraatia quiniutianiya quiara. Quia paraari quia mataconutaniya quia shocuaqueya, na cosenura maninia quiajaniya quia mashiyaquiniuucuaji. Naacuajitij, quia paraari quiocua juhuacunutaniya na miaquejonura quiajaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Quiaari jiyareta sureesaanutaniya. Quia tiacajinia quiniaari puecoosaanutaniya. Quia tiacaari puetunu niyartasaanutaniyajanaa. Majaari tamonu saajia cureenu quiniutianiya quenaaja tamonu saajia caco maano. Quiaari naa miishaanutaniyatej quia niishiyaquiniuucua, Pueyasoori quiocua niquiaari najuhuanaj, quiocuaji na tacunura juucua. Quiaari saaja na ruuretacanu. ");
INSERT INTO arlNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na nuhuaji, Jesuuri Pueyaso Secojojua tiajinia tiuquiquiaari na pueyata. Nojuajaari juhuacatecara pueya tohuatanijioree, canapuete na seya niquitiojoriquiaacuajani Pueyasoocuara puecoosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesuuri nojori sequeree: —Tariucuacaanu Pueyaso Rupaajinia naa naajiotasaaquiaariti Pueyaso sequesano: “Cua tiaari pueya secojonuujua janiya”. ¡Niaari saniniuujia na jiyatecanu nohuasenuujuaca quiquiora! ");
INSERT INTO arlNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Puetunu juucajanaa, Jesuuri jiyacari pueya niishitiojoriquiaa Pueyaso Secojojua tiajinia. Narta Judiocuaca jiyaniijianucuaari saaja na monu paniriquiaa. Pueyacuara secojonaa jiyaniijianucua, Moisés Rootasanojiniji niishitiojonaa, mariyata narta Judiocuaca jiyaniijianucuanio, puetunu nojorijianaari tari roojotooriquiaa juucua taa na motunutaniya Jesuni. ");
INSERT INTO arlNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Puetunu pueyajanaari saaja shamaatia tojitiariquiaa puetunu Jesu sequesanojuanaa. Cunora, majaari cuno jiyaniijianucua naata monu quiriquiaa Jesu. ");
INSERT INTO arlNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tamonu juuca, Jesuuri Pueyaso Secojojua tiajinia niishitiojoriquiaa. Pueya niquiara pohuatariquiaari taate nojori naata Pueyaso muerasura quiniuni. Jiyacaritij, pueyacuara secojonaa jiyaniijianucuaari Jesuucua nijiomaa. Moisés Rootasanojiniji niishitiojonaari nojoritia nijiomaajuhuaj, narta Judiocuaca camarucuanio. ");
INSERT INTO arlNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nojoriiri Jesu nequesotaree: —¿Cante quia jiyatecanu Pueyaso Secojojua tia jiyaniijia quia quiniuriani? ¡Canaa quia riucuare! ¿Cante quia jiyaronani? ");
INSERT INTO arlNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesuuri nojori sequeree saniniuujia: —Janiya nia nequesotanu paniyajuhuaj. Cua riucuature. ");
INSERT INTO arlNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Cante Juan jiyaroquiaari na tiuquinijionura pueyani? ¿Pueyasote na jiyaroquiaari, tama narta pueyajaaja soj? ");
INSERT INTO arlNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nojoriiri juhuacatecara tamajaaja pocoojoquiaari. Tama sequetooriquiaajaarijia: —¿Taa pa riucuanutaniyani? Paa jaara sequereni: “Pueyaso na jiyaroquiaari”, nojuajaari pa sequenutaniya: “¿Casaara nocua nia tiuyaquiquiaariirini?” ");
INSERT INTO arlNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Saniniuujia, paa jaara na sequereni: “Juancuaja nareja pueya jiyarosano quiquiaari”, puetunu pueyajanaari pa jacunutaniya saitia na puecoonura pajaniya. Nojoricuajaari sequequiaa: “Juanna seetanujuanaa Pueyaso sequenu panishano caminiujiunia quiquiaari”. ");
INSERT INTO arlNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nojoriiri cunora Jesu riucuaree: —Johuaj. Maja canaa niishiniu canaquitijia Juan jiyaroquiaari na tiuquinijionura pueyatej. ");
INSERT INTO arlNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Naaratej, Jesuuri nojori sequeree: —Janiyajuhuaj, majaari cua sequenu quiniutianiya niajaniya, cante cua jiyaroquiaarini naa cua miiniuriatej. ");
INSERT INTO arlNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na nuhuaji, Jesuuri pueya niishitiojonu coteerohuacuhuaj nio miriqui pohuatasanota. Sequereeri: —Tamonu pueyanoori cuhuariquiajinia uva natooquiaari. Na nuhuaji, na niquitioquiaari tamasaca pueyari, nojori cojuanura nera. Na camaruuri tucuacaanu quiaaree, tii na shocotejonura marijia. ");
INSERT INTO arlNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uva quishacari noshuriujua, saniya cuhuariquia camarujuanaari na seru jiyaroree cuhuariquia cojuanaa pueyacua. Jiyarosaareeri tiji na masenura na camarurajanaa, uva carojotasanojiniji. Na camarujuanaacuajaari tarijia pocoojoquiaari cuhuariquia cojuanaa pueyata, taa nojori niquitionutaniya na carojotasanojinijini. Cuhuariquia camaru seru tiuquishacari, ¡cuhuariquia cojuanaari na piquitiurii saaja! Na jiyaroturohua juhuasuuri. ");
INSERT INTO arlNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Cunora, cuhuariquia camarujuanaari tamonu na seru jiyaroree. Cuhuariquia cojuanaari na miitiurii sesajuhuaj. Na saarijiotureeri. Na piquitiuriiri. Na jiyaroturohua juhuasujaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Cuhuariquia camarujuanaari socua tamonu na seru jiyaroree nojoriicua. Nojoriiri sesa miitiurii nojuajuhuaj. Na nuhuaji, nojoriiri na caponeeree cuhuariquiajiniji tariucua naatishano. ");
INSERT INTO arlNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Naaratej, cuhuariquia camaruuri tama sequereejaaja: “¿Taa cua miiniutianiyarini? Quiyanuniyojua jiyaroreeraquij. Cuno pojori jaara cua panishano niyanu niquitiuri, maja naasucua nojori rerequetenu quiniutianiya nojuaja”. ");
INSERT INTO arlNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Saniniuujia, cuhuariquia cojuanaa jaara cuhuariquia camaru niyanujuanaa niquirii nojoriicua niyano, tama nojorijiaarijia sequetooree: “Nojuacuaja cuhuariquia camarura quiniutianiya na que niti, na que jaara shaajeyariquia. ¡Pa morej! Paari nio cuhuariquia camarura quiniutianiya saniniunijia”. ");
INSERT INTO arlNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Naacuajitij, cuno cuhuariquia cojuanaa pueyari cuhuariquia camaru niyanu jaatiurii cuhuariquiajiniji. ¡Cuniqui na motureeri! Naa nojori na pohuatanu nuhuajitij, Jesuuri pueya nequesotaree: —Naa nojori miiniuucua neyanutej, ¿taa na que miiniutianiya cuno sesa pueyarini? ");
INSERT INTO arlNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Seetanujuanaa nia sequeyanijia, nojuajaari nocua quianutaniya nojori na puecoonura. Na nuhuaji, na cuhuariquia niquitionutaniya tamasaca pueyari, nera nojori cojuanura cutara. Pueya tojishacari nio, nojoriiri sequequiaari: —¡Juhuej! ¡Pueyaso cuaara naa miyaquiiriatej! ");
INSERT INTO arlNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesuuri nojori niquinijioree. Nojori sequereeri: —¿Naatee? ¿Nio naajiotasanooriuhuaj, tariucuacaanu Pueyaso Rupaajiniani? ¿Niaate niishiya casaa na sequeyani? Naa sequeyariquij: “Saitia tianaa pueyari tamonu saajia soojotanutaniya, nojori jiyanishacari cuno saajia sesarujuajau. Na nuhuaji, cuno saajiaari socua panishano saajiara jiyatesaanutaniuhua”. ");
INSERT INTO arlNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Cante cuno saajiaacua tiuriyani, nojuajaari juhua rashiquijiniutianiya. Cuno saajia jaara pueyanoocua tiyare, cuno pueyano jacanajonutaniyari. Shahuej. ");
INSERT INTO arlNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jiyacaritij, pueyacuara secojonaa jiyaniijianucua, mariyata Moisés Rootasanojiniji niishitiojonaari Jesu quianu panirii juucua. Nojoricuajaari niishirii, Pueyaso saquiriojosano Israel pueya jiitianaa nojori quiniuucua, Jesuuri miriqui pohuatariquiaa nojorijiniji, tianaajiniji na pohuatasacari. Naajaa, jiyacaritij, majaari nojori quiatunu quiquiaari Jesu, nojori pueresacari Jesu panijiaca pueya. ");
INSERT INTO arlNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Naaratej, nojoriiri tamasaca pueya jiyaramiquiquiaari Jesuucua, sapuenu juhua maninia pueya niquishano. Cuno pueyari jiyaramiquishaaquiaari Jesu nojori pocuatenura sesa juucua, nocuara tonujusaanura. Jesu jaara nojori riucuaquiaari sesa, maara Romano jiyaniijia niquitiosaaquiaari saniitiosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Naacuajitij, cuno pueyari Jesu nequesotaquiaari: —Niishitiojonanaa, canaari niishiyani, quiaari maninia niishitiojona. Majaari sesa quia sequesano. Naajuhuaj, majaari rimiajata quia niquiniu pueya. Quiaacuajaari seetanujuanaa niishitiojoquiaa, taa Pueyaso paniya canaa miiniuriacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Cunora, canaa quia sequere taa canaa miiniutianiyani. Roma tiacajinia quijia jiyaniijiaari pa sequequiaari Judiocuaca cuaara cumaneeca niquitiojoora nera, na jiitiasano pueya pa quishacari. Naaratej, ¿maniniateeri pa miiniuria na sequesano? ");
INSERT INTO arlNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesuuri niishiquii nojoriiri nojuaja nequesotariquiaa najuhuanaj, nojori sapojonuta. Cunora, nojori sequereeri: ");
INSERT INTO arlNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Cua niquitiri quia cumanee. ¿Niooriuhuaj? ¿Cana naaquiti nocuani? ¿Cana sesate nocua naajiotasanoni? Jesu riucuatureeri: —Cunocuaja canaa sequesano Roma tiacajinia quijia jiyaniijia César naaqui, na sesajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesuuri nojori sequeree: —Jiyaniijia César cuaara tama na casaajaaja niquitiosaaria. Nojuacuajaari na camaru. Saniniuujia, Pueyaso nia niquitiore cutara nerano tama na casaajaaja. Nojuajaari pa camarnu. ");
INSERT INTO arlNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Saaja maninia Jesu riucuasacari pueya niquiara nojori, majaari nojori naata nocuara tonujunu quirii. Nojoriiri saniya jiuujiateree Jesu riucuasacari saaja maninia nojori. Naacuajitij, nojoriiri socua sanaajetaree. ");
INSERT INTO arlNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na nuhuaji, noojiaqueya Saduceocuacajinijinioori Jesuucua niquiaari. Saduceocuacaari jiyanijia macunucua pueya maja na samiitiaconu quiniutianiuhua. Naaratej, nojoriiri Jesu sequeree: ");
INSERT INTO arlNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Niishitiojonanaa, supuetana Moiséscuajaari pa rootaa na naajioneejinia, pueyano jaara cusoyare mueyaju, tarajanu cuaara camiiria mashiquio, mueya na mueratenura tarajanu niti. ");
INSERT INTO arlNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tamonu mashajaari seis tapueyocuacaraca quiquiaari. Nojuajaari jiyapueranu quiquiaari. Coteenu camiquiaariiri. Nojuajaari cusoquiaari muetuhuojua. ");
INSERT INTO arlNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Cunora, na nuhuajishanaari na mashiquio camirii. Nojuajaari muetuhuojua cusoquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Naaratej, neyaca tarajanuuri mashiquio camiquiaarijiuhuaj. Nojuajaari muetuhuojua cusoquiaarijiuhuaj. Puetunu cuno mashiquiorijianaari naa camiyoquiaari cuno maajitia. Puetunu nojorijianaari cusonuuquiaari muetuhuojua. ");
INSERT INTO arlNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na nuhuaji, pueya mashiquioori shaajequiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Naacuajitij, macunucua jaara samiitiacorohua, ¿teyano cuno siete neyacaajinijiniote seetanu neyacajanaa quiniutianiyani? Cuno mashiquiocuajaari puetunu cuno siete pueya niquiocua quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesuuri nojori riucuaree: —Mijiria pa quishacarijia, canuu, maajipohuari camiyoquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Saniniuujia, majaari noo pojori camiyonu quiniutianiya canapuete samiitianijiosaanutaniuhuacuajani, maninia quijiaca nojori quiniuucua Pueyaso niquiara mijiria. ");
INSERT INTO arlNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Majaari nojori shaajenu quiniutianiuhua. Nojoriiri shaajeyashijiaca quiniutianiya juhua Pueyaso seya. Nojori samiitiaconuucua macujiniji, cunora, nojoriiri Pueyaso muerasujuanaa quiniutianiya cutara. ");
INSERT INTO arlNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Supuetana Moiséscuajaari pa niishitiquiaari, macunucuaari samiitianijiosaanutaniuhua. Moisésri naa naajiotaquiaari Pueyaso sequesano nojuaja nequeru casaja noshiyanojinijitij. Pueyasoori naa sequequiaari Moisés: “Janiyari quia supuetana Abraham Jiyaniijiani, quia supuetana Isaac Jiyaniijianio, quia supuetana Jacobo Jiyaniijiajuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Naacuajitij, paari niishiyani, puetunu Pueyasoocua tiuujiaca shaajecono pueyajanaani, nojoricuajaari saminiucua quiya Pueyasora. Pueyasoori maja macunucua Jiyaniijia. Na pueya shaajeconocuajaari saminiucua quiya nera cutara. ");
INSERT INTO arlNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Noojiaqueya Moisés Rootasanojiniji niishitiojonaa pueya tojishacari naa Jesu sequesanotej, nojoriiri Jesu sequeree: —Maniniacuajaari quia sequesano, Niishitiojonanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Naa Jesu riuhuanesacari saaja maninia nojoritij, majaari socua pueya nequesoreenu paniniu quiriquiaa nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesuuri naa nojori nequesotaree saniniuujia: —¿Casaara na sequesaaquiaacuaraarini, Pueyaso Jiyarosanonaari supuetana David niquiohuacuajinio supuenutaniya? ");
INSERT INTO arlNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Supuetana Davidjanaacuajaari naa naajiotaquiaari na jaaquequejoneejinia: “Jiyaniijia Pueyasoori cua Jiyaniijia Cristo sequequiaari: ‘Cua miaquetajara quia cajirijiaara, janiya cuaara quia paraa shocotare puetunujuanaajaatijia’”. ");
INSERT INTO arlNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Cristotucua taa David niquiohuacuajinio supuereni? Davidcuajaari na sequeya “cua Jiyaniijiata”. Cuno pueyari maja na naata na riucuanu quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Puetunu pueyajanaa tojitiasacarijia Jesu, Jesuuri naa na saquiriojosano pueya sequeree: ");
INSERT INTO arlNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Tama nia cuaqueyajaaja nia cojuare Moisés Rootasanojiniji niishitiojonaa pueyacuaji, nia miyaquiniuucuaji taa nojori miiquiaacuaani. Nojoriiri tucuaque toqueya cushiniu maniniucuaquiaa na rucuanejotajara pueya niquiara, pueya shootianura nojori. Nojoriiri paniquiaa pueya saruhuatanura nojori juhua tojishano pueya, nojori rucuanejosacari tiaca jiuujiajinia curotasano cajitiucuajinia. Nojoriiri socua panishano cajitiucuajinia cajiniu maniniucuaquiaa Pueyaso Secojojua tiajinia, tamasaca tiajiniajuhuaj, nojori jaara masuusaare queranacunura. ");
INSERT INTO arlNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Naajuhuaj, nojoriiri mashiquiopue tiaca masequiaa secaja cumaneecata nojori sapojonuta. Naa jiyasohuaja nojori miiniu nuhuajitij, pueya niquiara, nojoriiri najuhuana tucuayocua secojoquiaa Pueyaso, pueya jiyaniniuria nojori maninia pueya cutara. Naa nojori miiniuucuatej, nojoriiri jiyanohua saniitiosano quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pueyaso Secojojua tiajinia, Jesuuri casamiriaca pueya shootiariquiaa na cumaneeca niojiyano cumaneeca racataja quiquiojinia, nojori niquitiosano Pueyasora. ");
INSERT INTO arlNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jesuuri tamonu casamiijiu mashiquio niquiriijiuhua caapiqui cumaneeniyojua niaano tiijiuhuaj. Na niasanoori nareja cobrejiniji shipinishano cumaneeca quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesuuri na pueya sequeree: —Seetanujuanaa nia sequeyanijia, cuno casamiijiu mashiquioori socua queraatia niquitioree Pueyaso, cuno casamiriaca pueyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Puetunu cuno pojorijianaari saaja na cureeno cumaneecajiniji niquitiojiya puetunu nojori panishanojuanaa nojori masejonu nuhuaji. Cuno mashiquio cutaraari puetunu na miaajaara na masetajara cumaneecajanaa niquitioree. ");
INSERT INTO arlNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Noojiaqueya tii quiniaa pueyari pocoojoriquiaa Pueyaso Secojojua tiajiniji. Jiyanohua shanohua saitia shipinishano quiriquiaari. Nojoriiri na shootiariquiaa, naajuhuaj taa na maniniushitishaaquiaari nareja pueya niquitiojosano casamitiani. Jesuuri nojori sequeree: ");
INSERT INTO arlNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Puetunu cunojuanaa niaa na niquiyani, tamacari niyartasaanutaniyari. Majaari quenaaja tamonu saajia cureenu quiniutianiya tamonu caco maano. Puetunu niyartasaanutaniyajanaari. ");
INSERT INTO arlNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na pueyari Jesu nequesotaquiaari: —Niishitiojonanaa, ¿taacari nio tia niyartasaanutaniyarini? ¿Casaa canaa niquiniutianiyarini, canaa niishiniuria quia sequesanoori quera tohuateya? ");
INSERT INTO arlNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesuuri nojori riucuaree: —Tama nia cuaqueyajaaja nia cojuare niaa mariqui sapojosaareeri. Queraatia sapojonuujuaca pueyari supuenutaniya. Nojoriiri sequenutaniya: “¡Janiya Cristoni, Pueyaso Jiyarosano! ¡Nio jiya quera puequeya!” Niaa jaara naa sequesaaretej, majaari nia tojiniu cuno sapojonuujuaca. ");
INSERT INTO arlNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Naajuhuaj, majaari nia puerenu niaa jaara tojiri tamonu jiyajinijinio pueyari tamasaca jiyacajiniji pueyata miaquetoojiya, naajuhuaj, pueya jaara juaatiooquiaa tama nojori jiyaniijia nojori jatanurajaaja. Naa quiniutianiyari coteenu. Naajaa, juhuanojuaja maja nio jiya puequesacari. ");
INSERT INTO arlNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesuuri naa nojori pohuatariquiaa socua: —Tamonu rupaa pocuajacaari miaquetoojonutaniya tamaatia rupaa pocuajacata. Naajuhuaj, tamonu jiyajinijinio jiyaniijiaari miaquetoojonutaniya tamonu jiyajinijinio narta jiyaniijiata. Naa queraatia miaquetoojonuuri quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Rijiaari jiyanohua jiuuquiujiutianutaniya queraatia jiyacajinia. Jiyanohua miaajenuuri quiniutianiya queraatia tamonu jiyacajiniajuhuaj. Paaqueja cusonuuri quiniutianiya niya, tamaquiicuajuhuaj. Naajuhuaj, jiyanohua puereeta casaari niquishaanutaniya jiyocuacaanu, mijiria quiniaa niishiniuria jiya puequenuraari tari catecanoya. ");
INSERT INTO arlNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Cuno puereeta quiyaquishacarijia, niaari quioosaanutaniya naquiya nia miishaanura, cua pueya nia quiniuucua. Niaari jaatucusaanutaniya Pueyaso secojonuujua tiajiniaqueya nequesoreesocoriquiano. Niaari nujuatejojuacajinia nujuatejosaanutaniya. Niaari nia pueya camarucuaacua, mariyata jiyaca jiyaniijianucuaacua jaatucusaanutaniya nequesoreesocoriquiano. Niaari naa miishaanutaniya nia pohuatanuucua janiyajiniji pueya niquiara. ");
INSERT INTO arlNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Naacuajitij, nia naata cuno jiyaniijianucua niquiara pohuatanu janiyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nioojiaca nia cajitiri, maja juhuacarijia nia niishiriojonura taa nia riucuanutaniya nojorini. ");
INSERT INTO arlNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Janiyacuajaari jiyacari nia niishitiojonutaniyani taa nia riucuanutaniyanoj, mariyata casaa nia pohuatanutaniya jiyanohua cua niishitiajatani. Niaari nojori sanaajanutaniya maninia nia riuhuanesacari saaja. Nia paraari maja na naata nia sequesano rerequetenu quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jiyacarijiuhuaj, tama nia queyajaarijia nia tacartanutaniya, cua pueya nia quiniuucua. Nia tapueyocuacaari nia tacartanutaniyajuhuaj, nia jiyasoocuajinio supueno pueyajuhuaj, nia rupuenaanio. Nojoriiri noojiaqueya niajaniyajinijinio puecoonutaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Puetunu mijiria quiniaa pueyajanaari nia niquiniu paniyaquiniutianiya cua pueya nia quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Naajaa, majaari nia puerenu. Majaari quenaaja niquiriyatu muesu shaajenu quiniutianiya nia nacajiniji, Pueyaso jaara paniyaquiri. Pueyaso jaara naa nia muesu cojuaacuaa, ¿maatucua casaara cojuaaquiri saniya niajaniyani? ");
INSERT INTO arlNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Naaratej, rejeretajaca nia quiri. Niaa cutaraari shacantuuca quijiacara jatanishaanutaniya pueyaracaanu nia rishiniuria, niaa jaara cumaatia nujuatare pueya miishacari sesa niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Niocua niishiri Jerusalén tiaca tari niyartasaanutaniya, niaa jaara na paraa niquiri puetunu na shocuaqueyajanaa maano. ");
INSERT INTO arlNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jiyacaritij, canapuete Judea jiyajinia quiyani, cuno pojori cuaara mashiiria tuhuananuhuacua. Canapuete Jerusalén tiacajinia quiyani, nojori cuaara ritia mashiiria tiji. Canapuete na cuhuariquiajinia quiyani, nojori cuaara tacateyaquiuhuara Jerusalén tiacajiniohua. ");
INSERT INTO arlNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Cuno quishacari, jiyanohua saniitiosacariiri quiniutianiya. Jiyacaritij, puetunu Pueyaso Rupaajinia naajiotasanojuanaari tohuateenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jiyanohua taraatia quiniutianiyari noo maajipohuara, canapuete manajaatohua quiya jiyacarini, mariyata canapuete conaaja supueja jiitiaani. Jiyanohua naquiya quiniutianiyari cuno quishacari nio jiyajinia. Nio jiya pueyari jiyanohua saniitiosaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Noojiaqueya nojorijinijinioori puecoosaanutaniya tahua miaquetoosacari nojoritia. Tamasaca nojorijinijinioori quioosaanutaniya. Nojoriiri puetunu jiyacajiniarajanaa rijiosaanutaniya poonitijiosocoriquiano. Taucuacaari Jerusalén tiaca jiitianutaniya tama nojoririajaaja, Jerusalén tiaca nojori jiitianu cuaara puequerejaatijia, taa Pueyaso sequequiaari tamajacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Mijiria quiniaa niishiniuria jiya quera puequeya, nojoriiri puereeta casaa niquiniutianiya pananujinia, racajinia, riyajiniajuhuaj. Shoniniacu caminiaacuaji shiriiquitiuniutianiyajaariuhuaj, jiyanohua na queyocuasacari. Nojoriiri cushitiiniutianiya na pueretunutajuhuaj, jiyanohua cojuata shoniniacu caminia cajiniuucuasacari. ");
INSERT INTO arlNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mijiria quiniaari cusojonuunutaniya na puerenuta, nojori niishiriojosacari taa nio jiya miishaanutaniyani. Puetunu jiya cajiniocua Pueyaso shipinishano casaajanaari jiuuquiutiasaanutaniya jiyanohua. ");
INSERT INTO arlNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jiyacaritij, mijiria quiniaari cua niquitiuniutianiya cohuaja najacajinia niyano, jiyanohua shacantuuca cua cumaacata. ");
INSERT INTO arlNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Naaratej, niaa jaara nio cua pohuatasano niquiri tari coteyano, niocua tama cumaquitioorejaaja. ¡Niocua timiri! ¡Niaacuajaari quera rijiosaanutaniya niiquiji, pueyaracaanu cuata nia quiniuria! ");
INSERT INTO arlNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesuuri nojori pohuataree nio miriqui pohuatasanojuhuaj: —Higo naana nia niquiri, tamonu jaranacujua naananio. ");
INSERT INTO arlNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Na jaamasucua jaara mueratuure, niaari niishiya, tacareejonuqui quera quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Naajuhuaj, niaa jaara puetunu cua pohuatasanojuanaa niquiri tari tohuateyano, niocua jiyacari niishiri, janiyari quera tiuquiuhuani, Jiyaniijiajanaa cua quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Seetanujuanaa nia sequeyanijia, puetunu cua sequesanojuanaari tohuateenutaniya Pueyaso tojitiaashijiaca pueya puequeyaquishacarijia. ");
INSERT INTO arlNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Jiya cajiniocua, mariyata nio jiyari shaajenutaniya. Cua sequesanoori saniniuujia puetunu tohuateenutaniyajanaa cutara, taa cua sequeyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Tama nia cuaqueyajaaja nia cojuare niaa mariqui cua tojiyashijiacara quiriohuari. Naaratej, majaari shuquiriaatia nia quiniu paniniu juucua nia queranacunuunuta, nia mashaasequejonuta, mijiria casaacua nia niishiriojonutanio. Maja naa nia quiniu, janiya mariqui nia cariyatureeri, jeenucuasoo nia quishacari, canashiyaquiji cua tiuquishacariuhua. ");
INSERT INTO arlNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Cua tiuquishacariuhua, juhua norijiotaja quiniutianiyari puetunu mijiria quiniaa pueyarajanaa, taa norijiotaja canashiyaquiji majaacuaani. ");
INSERT INTO arlNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Cunora, cucuaji jeenucuasano nia quiri juhuacarijia. Pueyaso nia secojore pueyaracaanu, maja naquiya nia miishaanura cuno taraatia quishacari, taa cua sequeyacuajani, mariyata juhuajaniya nia nujuatunura cua tacoji, cua nequesoreesacari puetunu pueyajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesuuri puetunu juucajanaa niishitiojojua Pueyaso Secojojua tiajinia. Saniniuujia, niucua quiojojuaari Olivo cuhuariquia tuhuananujinia tii na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Puetunu pueyajanaari tariquiicuaji quiojojua Pueyaso Secojojua tiajinia, nojori tojiniuria Jesu pohuatasano. ");
INSERT INTO arlNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Quera Pascuara queranacunuusacari quiquiaari, pueya miaquesacari pan na poreetajaaju shipinishano. ");
INSERT INTO arlNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jiyacari, pueyacuara secojonaa jiyaniijianucua, mariyata Moisés Rootasanojiniji niishitiojonaari roojotooriquiaa juucua taa nojori motunutaniya Jesuni, nojori juaatiyaquiniutia pueya. Nojoriiri narta pueya pueretujuaca, jiyanohua queraatia pueya paniniuucua Jesu. ");
INSERT INTO arlNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jiyacaritij, Satanásri Jesu pueyano Judas Iscariote jiuujiajinia tiuquiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nojuajaari pueyacuara secojonaa jiyaniijianucuaacua quiaquiaari, Pueyaso Secojojua tia cojuanaa jiyaniijianucuaacuajuhuaj. Judasri cuno pojoritia pocoojoquiaari. Nojori sequereeri nojuaja na naata nojori quiatenu Jesu. ");
INSERT INTO arlNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nojoriiri shuquiririi. Cunora, Judas sequetureeri taa cumaneeca nojori niquitionutaniya nojuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judasri jaarajaaja nojori sequesano tojirii. Jiyacaritij, Judasri juhuacatecara niishiriojoquiaari taa na quiatenutaniya Jesu jiyasohuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Poreetajaaju pan miaquenu juucaari tari quiquiaari. Cuno juucajuhuaj, borregoori mosano quijia, Pueyaso niquiara miaquesocoriquiano Pascuara queranacusacari. ");
INSERT INTO arlNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Cunora, Jesuuri Pedro jiyaroree Juannio, nojori miaquesocoriquiano nojori majeetenura. Nojori sequereeri: —Nia quiaare. Borrego nia majeeteseecuaa pocuaji, pa miaquesocoriquiano quiarijia Pascuara. ");
INSERT INTO arlNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nojoriiri na nequesotaree: —¿Tee quia paniya canaa majeetenurani? ");
INSERT INTO arlNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesuuri nojori riucuaree: —Niaa jaara Jerusalén tiacajinia tiuquishii, niaari tamonu pueyano riuriatanutaniya mohuaca taquitiaano patacojinia. Niocua na nuhuaji rupaamia na tiajiniara. ");
INSERT INTO arlNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Cuno tiajinia na tiuquishacari, niocua cuno tia camaru sequesee: “Canaa niishitiojona naa quia sequeya: ‘¿Teete sohuacani, cua pueyata cua miaquejara quiarijia Pascua niucuani?’” ");
INSERT INTO arlNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nojuajaari nia niquitiniutianiya puereetuuca sohuaca, nataco na tiajinia, tariucua jeenucuasano. Niocua cuniqui miishii puetunujuanaa pa miaquesocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jesu pueyari quiaaree. Nojoriiri puetunujuanaa riuriataquiaari taa Jesu sequequiaari nojoricuajani. Nojoriiri tii miishii puetunujuanaa, Pascua niucua nojori miaquesocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jaara tari quiquiaari Pascuara miaquesacari niucua, Jesuuri na saquiriojosano pueyata cajitiushii miaquejajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesuuri nojori sequeree: —Janiyari jiyanohua niaata miaquenu paniriquiaa nio Pascua niucuani, pueya moyaquishacarijia janiya. ");
INSERT INTO arlNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Seetanujuanaa nia sequeyanijia, majaari socua cua miaquenu quiniutianiya Pascuara, janiya jaara tiuquiriohuajaatijia puetunu Pueyaso muerasuranotajanaa. Jiyacari cutara, paari jatiqui miaquenutaniyani, Jiyaniijiajanaa cua quishacari. ");
INSERT INTO arlNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Na nuhuaji, Jesuuri ratujua pataree. Pueyaso sequereeri: —Paacarasho nio mashacara. Na pueya sequereeri: —Jajaa, nio nia masetare. Nia rature puetunu niajaniyajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Seetanujuanaa nia sequeyanijia, majaari socua cua ratunu quiniutianiya uva caacajiniji, janiya jaara tiuquiriohuajaatijia, Jiyaniijiajanaa cua quiniuria puetunu Pueyaso muerasurajanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Na nuhuaji, Jesuuri pan ririi. Pueyaso secojoree nocuaraari. Na neecasereeri. Na pueya na niquitiojoreeri. Nojori sequereeri: —Nioori cua cuaqueya niaacuara mosocoriquiano. Niocua naa miiriquia pueyaracaanutej, nia niishiriojonura janiya. ");
INSERT INTO arlNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nojori miaquenu nuhuaji, Jesuuri ratujua patareejuhuaj. Naa sequereeri: —Cua nanacaari niaacuara shoonutaniya nia jiyanooshaanura seetanujuanaa. Majaari socua seya nanaca panishaanu quiniutianiya. Quiarijiani, saaja cua nanaca shoonuucua, Pueyasoori pueya jiyanooniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Cua tojitiare. Quiarijiani, cante cua tacartanutaniya pueya na motenura janiyani, nojuajaari cuata miaqueya. ");
INSERT INTO arlNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Janiyari naa miishaanutaniyani taa janiyajiniji juhuacarijia pohuatasaaquiaaricuajani tariucuacaanu Pueyaso Rupaajinia. Saniniuujia, cua tacartanaari jiyanohua taraatia quiniutianiya naa na miiniuucua janiya. ");
INSERT INTO arlNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesu pueyari jiyacari juhuacatecara nequesoreetooree tama nojorijiaaja: —¿Canteeri na tacartanutaniyani? ");
INSERT INTO arlNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jesu pueyari tama juayonuutariquiaajaacujua, teyano nojorijinijiniote jiyaniijiajanaani. ");
INSERT INTO arlNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesuuri nojori sequeree saaja: —Mijiria, jiya jiyaniijianucuaari jiyanohua jiyaramiquiniu niishijia nojori jiitiasano pueya, juhua nojori poonitijiosano pueya. Nojoriiri tama nojorijinijijiaaja sequeja: “Canaari maninia miiquiaa canaa pueyani”. ");
INSERT INTO arlNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Niajaniya saniniuujia, majaari naa nia quiniu juhua nojorijia. Cante socua tojishano pueyano quiya niajaniyajinijinioni, nojuaja cuaara tama na cuaqueyajaaja jiyateyaquiiria na cumaaca paaretaja pueyacua. Cuaara quiiria jacaria pocuaja. Naajuhuaj, cante jiyaniijiajanaa quiya niajaniyajinijinioni, nojuaja cuaara jiyateera tama na cuaqueyajaaja juhua nia serura. ");
INSERT INTO arlNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Taa nia sequeyani? ¿Cante jiyaniijiajanaani? ¿Miaqueyano pueyanotee? ¿Na mianuutena soj? ¡Miaqueyano pueyanocuaja! Naajaa, janiyari juhua nia seru quiquiaa niaarani, maninia cua miiniuria niajaniya. Naajuhuaj, naa maninia miijiaca nia quiriquia. ");
INSERT INTO arlNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Niaacuajaari pueyaracaanu cua cojiriquiaa janiya jaara saniniujiushaariquiaani. ");
INSERT INTO arlNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Naaratej, janiyari nia jiyatenutaniya jiyaniijianucua nia quiniuriani, taa cua Que jiyatequiaari janiyacuaani, Jiyaniijia cua quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Naacuajitij, niaari cua miaquejajinia cajitiuniutianiya cuata nia miaquejonura, cuata nia raruujunurajuhuaj, Jiyaniijiajanaa cua quishacari. Niaari mariyata jiyaniijianucua quiniutianiya, supuetana Israel doce niquiohuacuajinio supueno pueyapue nequesoreenaa nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jiyaniijia Jesuuri Pedro sequequiaari: —Simónnaa, cua tojiri. Satanásri niaacuara sequerucuaa Pueyaso, jiyanohua na saniniujiuniuria niajaniya. Naacuajitij, niaari jiyanohua saniniujiushaanutaniya, naatej, taa trigo quejooshiya jiyocuacaanucuaani, paratu panura na cocua. ");
INSERT INTO arlNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Janiyari saniniuujia Pueyaso secojoree quiocuara cutarani Simónnaa, cucua tiuuniu quia tarinitiaaquiniuucuaji. Naacuajitij, quiaa jaara quioojia tacatorohua cucua, quiocua quiarta pueya cumaquiriohuajuhuaj, nojori tiuuniuria seetanujuanaa pueyaracaanu cucua. ");
INSERT INTO arlNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simónri Jesu sequeree: —¡Cua Jiyaniijianaa, quiaa jaara nujuatejojuajinia nujuatesaare, janiya cuaara nujuatesaaria quiatajuhuaj! ¡Quiaa jaara mosaare, naajaa, janiya cuaara cojiritiasaaria quiajaniyajuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesuuri na sequeree: —Pedronaa, seetanujuanaa quia sequeyanijia, caacaraja niunijiyaquishacarijia quiarijia, quiaari tari naa cucuaji seetanu caminiujiuniutianiya pueya niquiara: “¡Maja cua niishiniu Jesu!” ");
INSERT INTO arlNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesuuri na pueya nequesotaree: —Janiya jaara nia jiyaramiquiquiaari Pueyaso rupaa nia pohuatanura caashoqueejuni, cumaneeca quiquiooju, sapatuujunio, ¿niaateeri nia panishano casaa niquitioyaquishaaquiaari? Nojoriiri Jesu riucuaree: —Maja. Canaacuajaari puetunu canaa panishanojuanaa niquitiojosaaquiaarini. ");
INSERT INTO arlNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesuuri nojori sequeree: —Quiarijia saniniuujia, cante caashoqueracani, cuaara na pataara. Cante cumaneeca quiquioracani, cuaara na pataarajuhuaj. Cante nijiniaquetucuaja mueruu jiitiaaquiyani, cuno cuaara niquitioora na shiniquiaacuaji toque, nijiniaquetucuaja mueruu na masenura na toque samitia. ");
INSERT INTO arlNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Seetanujuanaa nia sequeyanijia, tariucuacaanu Pueyaso Rupaajinia janiyajiniji naajiotasanoori tohuateenutaniya. Janiyajiniji naajiotasanoori naa sequeyatej: “Nojuajaari jiyanishaaree sesa miijia, sesa miijiacata na teetesacari”. Puetunu janiyajiniji naajiotasanojuanaari tari tohuateya taa na naajiotasaaquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nojoriiri Jesu sequeree: —Jiyaniijianaa, niya quiya caapiqui nijiniaquetucuaja mueruu. Nojori riucuareeri: —Tariucuaja. ");
INSERT INTO arlNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na nuhuaji, Jesuuri tohuataquiaari tiajiniji. Olivo cuhuariquia tuhuananujiniara quiaareeri. Nojuajaari cuniqui quianura jiitiquiaari. Na saquiriojosano pueyari na nuhuajiyaree. ");
INSERT INTO arlNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Na tiuquishacari tii, Jesuuri nojori sequeree: —Pueyaso nia secojore, niaa mariqui sesa miiriiri niaa jaara saniniujiushaare. ");
INSERT INTO arlNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na nuhuaji, Jesuuri tamajaaja quiaaree socua nojori tacoji, juhua saajia tishaqui, pueyano jasacari. Tii mojoquetasee Pueyaso secojonuraari. ");
INSERT INTO arlNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Naa secojoreeri: —¡Cua Quenaa, maja cua miiniu paniniu naquiya! Naajaa, janiya cuaara miyaquishaaria taa cua paniyani. Janiya cuaara miishaaria cutara taa quia paniyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jiyacaritij, Pueyaso seruuri jiyocuacaanuji nocua nimiaa na cumaquiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesuuri jiyanohua naquiya miiriquiaa. Noojiaari quera jiaqueriquiaa na tacaaniutia. ¡Jiyanohua, jiyanohua secojoriquiaa Pueyasoori! Cunora, na paneyacaari puereetujuaaca juhua nanaca quiriquiaa, na caatesacari jiyocua. ");
INSERT INTO arlNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Na secojonu nuhuaji, Jesuuri sanerohua. Na pueyacua tacateyarohuari. Nojori niquishuhua maquetiuyano saajaari, puera nojori taraajenuucua. ");
INSERT INTO arlNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesuuri nojori sequeree: —¿Casaara nia maquetiuyani? Nia saneecuature. Pueyaso nia secojore na cojuanura niajaniya, maja sesa nia miiniuria niaa jaara saniniujiushaare. ");
INSERT INTO arlNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesu pocuasacarijia na pueyata, queraatia pueyari jiyacari nocua tiuquishii. Judasri cuno pojori puetariquiaa. Nojuajaari Jesu doce saquiriojosano pueyajinijinio quiquiaari. Judasri Jesuucua nimiaajanaa. Na saruhuataseeri na nujuunuta. ");
INSERT INTO arlNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesuuri na sequeree: —Judasnaa, ¿quiaate tama cua tacartaajaaja, quia nujuunuta sapojonu janiya? ");
INSERT INTO arlNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesu pueya niquishacari casaa cuno pueya miiniu paniriquiaani, nojoriiri Jesu nequesotaree: —Jiyaniijianaa, ¿canaate nojori miaqueyani? ");
INSERT INTO arlNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tamonu nojorijinijinioori pueyacuara secojonaa jiyaniijia seru pirii na mueruuta. Saaja na miaquetajara numoco jaatereeri. ");
INSERT INTO arlNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesuuri na sequeree: —¡Tariucuaja! Maja naa miiniu. Jesuuri numoco ririi. Na ruporohuari. ");
INSERT INTO arlNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Judasta quiriquiaari pueyacuara secojonaa jiyaniijianucua, Pueyaso Secojojua tia cojuanaa jiyaniijianucuajuhuaj, Judiocuaca camarucuanio. Nojoriiri Jesuucua nijioquiaari na quianura. Jesuuri cuno pojori sequeree: —¿Casaara cucua nia nijioree nijiniaquetucuaja mueruutani, macacatanio nia quianura janiyani? ¿Janiyateeri nohuasejojuani, naa nia nijionura cucuatej? ");
INSERT INTO arlNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pueyaracaanu cua quishacari niaata Pueyaso Secojojua tiajinia, majaari nia quianu quijia janiya. Naajaa, quiarijia cutaraari niajaniyara, nia panishano nia miiniuria janiya. Quiarijiani, Sesaacaari cumaacaraca na panishano na miiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jiyacaritij, nojoriiri Jesu quiaree. Na jaatucutiuyareeri pueyacuara secojonaa jiyaniijia tiajiniara. Pedroori tucuacaanuji na nuhuajiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jiyacaritij, pueyari jiyaniijia tia carijiniacuma mani noshitirii. Na shocua cajitiuriohuari. Pedroori nojori tajinia cajishiijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Cuno jiyaniijia serujinijinioni, niyacoori Pedro niquirii mani jitiuyano. Nojuajaari Pedro shootiariquiaa. Na nuhuaji, niyacoori Pedro shishirii. Sequereeri: —Noo pueyanoori cuno quiasano pueyanota quijiajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedroori seetaree. Naa sequereeri: —Niyacoonaa, ¡majaari quenaaja cua niishishano cuno pueyano! ");
INSERT INTO arlNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na nuhuaji, tamonu pueyanoori Pedro niquiriijiuhuaj. Nojuajaari cuno jiyaniijia seru quiriquiaajuhuaj. Pedro sequereeri: —¡Quiaaqui cuno pojorijinijinio pueyanojuhuaj! Pedroori saa sequereejaa: —¡Maja, pueyanonaa! ¡Janiya maja nojorijinijinioni! ");
INSERT INTO arlNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pasaja na tarishiniu nuhuaji, tamonu pueyanoori sequenu pacuterohua: —Nio pueyanocuajaari cuno pueyanota quijia. Nojuajaari Galilea jiyajinijiniojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedroori saa sequereejaa: —¡Pueyanonaa, maja cua niishiniu quenaaja casaa quia sequeyani! Pedro pocuasacarijia, jiyacaritij, caacarajaari niunijioree. ");
INSERT INTO arlNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jiyaniijia Jesuuri tacatequee. Na nijiniara niquirii Pedroori. Pedroori jiyacari Jiyaniijia sequesano nojuaja niishiquii, naa na sequesanotej: “Quiaari tari seetanu caminiujiuniutianiya janiyajiniji pueya niquiara, caacaraja niunijiyaquishacarijia”. ");
INSERT INTO arlNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedroori cuniquiji tohuataquee. Jiyanohua nujuquereeri na taraajenuta, sacuaraatia na seetanuucua. ");
INSERT INTO arlNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesu cojuanaa pueyari Jesu macaatiriquiaa. Nojoriiri na piquitiuriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nojoriiri Jesu namijia morotuquiaari coteenu. Na jiquioco piquitiuriohuari. Na nuhuaji, na sequetureeri: —¡Quia niishiritioj! ¿Cante quia piriini? ");
INSERT INTO arlNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nojoriiri socua queraatia sesa casaa sequeturiquiaa na macaatiniuria Jesu. ");
INSERT INTO arlNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jaara juhuaquequiaari, Judiocuaca camarucuaari rerejoree pueyacuara secojonaa jiyaniijianucuata, mariyata Moisés Rootasanojiniji niishitiojonaatajuhuaj. Nojoriiri Jesu jiyataquiaari Judiocuaca jiyaniijianucua rerejosaquiria. Nojoriiri na nujuatesee jiyaniijianucua tacoji, nojori nequesoreenura tii nojuaja. Nojoriiri naa Jesu nequesoreeree: ");
INSERT INTO arlNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Canaa quia sequere, ¿quiaate Cristo, Pueyaso Jiyarosano? Jesuuri nojori riucuaree: —Janiya jaara nia sequereni: “Taaquiriirinij”, niaari saaja cua sequenutaniya: “Quiaa sapojiya”. ");
INSERT INTO arlNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Saniniuujia, janiya jaara nia nequesoreere Pueyaso Jiyarosanojinijini, majaari nia riucuanu quiniutianiya janiya. ");
INSERT INTO arlNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Naajaa, quiarijiani, janiyari puetunu cumaacaraca Quijiajanaa miaquetajara cajiniutianiya jiyocuacaanuni. ");
INSERT INTO arlNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Naa Jesu sequesacaritij, puetunu nojorijianaari na sequeree: —¿Quiaateeri tama sequeyajaaja quiaari Pueyaso Niyanu? Jesuuri nojori riucuaree: —Taaquiriirinij. Naacuaaquiniatejaj, taa nia sequeyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nojoriiri tama sequetooreejaaja: —¿Paatucua casaara socua tamonu pueyano pajere nocuara tonujuriquianoni? Paacuajaari tari tama pa numaatajaaja sesa na sequesano tojitiareeni. ");
INSERT INTO arlNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Cuno nuhuaji, puetunu nojorijianaari sanetaree. Jesu jiyatatiuyareeri jiyaniijia Pilatoocua. ");
INSERT INTO arlNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Cuniqui, nojoriiri juhuacatecara Jesuucuara saquiriojotaree na sapojonuta. Pilato sequetureeri: —Canaari nio pueyano niishiyani. Nojuajaari canaa Israel pueya nasojoquiaa pocuara. Nojuajaari niishitiojoquiaajuhuaj, maja canaa Israel pueya niquitiojonura canaa cumaneeca pa jiyaniijiajanaa Césarra, taa César sequequiaaricuajani. Naajuhuaj, tama nojuajaari naa sequequiaa: “Janiya Cristoni, Pueyaso Jiyarosano, nia jiyaniijia cua quiniuria”. ");
INSERT INTO arlNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatoori Jesu nequesotaree: —¿Quiaate Judiocuaca jiyaniijia? Jesuuri na riucuaree: —Taaquiriirinij. Naacuaj, taa quia sequereecuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jiyacaritij, Pilatoori pueyacuara secojonaa jiyaniijianucua sequeree, pueya maanunio: —Nio pueyano nequesoreeree tarinijia. Nojuajaari maja sesa miijia. ");
INSERT INTO arlNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nojoriiri saaja socua jiyacateree Jesuucuara tonujunu. Naa sequetureeri: —¡Nojuajaari puetunu canaa Judiocuacajanaa sesoya na niishitiojosanota! Nojuajaari Galilea jiyajinia niishitiojonu coteequiaari. Quiarijia, niya niishitiojiyajaariuhua Judea jiyajiniani. ");
INSERT INTO arlNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato tojishacari naa nojori sequesanotej, nojori nequesotareeri: —¿Nio pueyanote Galilea jiyajinijinio? ");
INSERT INTO arlNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nojoriiri na riucuaree: —Jaa. Cunora, Pilatoori pueya jiyarotaree Jesu, Galilea jiya jiyaniijia Herodescua. Herodesri namitia tii Jerusalén tiacajinia quiriquiaa jiyacari. ");
INSERT INTO arlNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nojuajaari pueyaracaanu Jesu niquiniuucua jiaatiaja juucua. Herodesri tari pohuatasaaquiaari Jesujiniji. Naaratej, Herodesri Jesu miishacari na cumaacata niquiniu panijia juucua. Naacuajitij, na niquishacari Jesu, nojuajaari timirii. ");
INSERT INTO arlNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodesri queraatia nequesoreeree Jesu. Majaari quenaaja Jesu riucuanu quiquiaari nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pueyacuara secojonaa jiyaniijianucuaari tii quiriquiaajuhuaj, Moisés Rootasanojiniji niishitiojonaanio. Cuno pojoriiri jiyanohua Jesuucuara saquiriojotariquiaa queraatia sesa casaa. ");
INSERT INTO arlNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodesri na soldadohuata Jesu rerequeteriquiaa. Na macaatiriiri. Na cushitirii jiyanohua shanohua toqueeri juhua jiyaniijia cushishano. Na nuhuaji, Herodesri pueya jiyarotarohua Jesu Pilatoocua. ");
INSERT INTO arlNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodesri cuno juuca Pilato rupuenara quiquiaari. Coteenu, majaari nojori niquitioonu paniniu quijia. Nojoriiri saaja shocotetoojua. ");
INSERT INTO arlNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na nuhuaji, Pilatoori pueyacuara secojonaa jiyaniijianucua rerejotequiaari na tacoji, Judiocuaca camarucuajuhuaj, tii quiniaa pueyanio. ");
INSERT INTO arlNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nojori sequereeri: —Niaari nio pueyano jaatucuree cucua najuhuanaj. Niaari cua sequeturee, nojuajaari niarta pueya nasojoquiaa. Janiyacuajaari na nequesoreeriquiaa nia niquiarani. Niaacuajaari cua tojitiariquiaa cua nequesoreesacari nojuaja. Quiarijia niishiya cutaranijia, puetunu nocuara nia tonujusanojuanaari maja seetanujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jiyaniijia Herodesquiiri tari niishiyajuhuaj, majaari seetanujuanaa nocuara nia saquiriojotasano. Cunora, Herodesri pocua na jiyarorohua. Seetanujuanaa, majaari sesa na miiniu quiquianu na mosaanura. ");
INSERT INTO arlNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Janiyari na majacutenutaniya narejani, cartesaarohuari. ");
INSERT INTO arlNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pascua juucara queranacusacari, Pilatoori nujuatesano pueyano cartenu jiitiquiaari nujuatejojuajiniji. Nojuajaari naa miiquiaari pueyaracaanutej, pueya na shuquiritiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jiyacaritij, puetunu pueyajanaari juhuacatecara jiyanohua nacaree jatiqui: —¡Jesu quia more! ¡Barrabás quia cartere saniniuujia! ");
INSERT INTO arlNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tarijia cuno Barrabásri narta nasojosano Judiocuacata Romano pueya taanuuquiaari juucua Jerusalén tiacajiniji. Nojuajaari jiyacari pueyano moquiaarijiuhuaj. Cunora, nojuajaari nujuatejojuajinia nujuatesano quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatoori Jesu cartenu panijia juucua. Naaratej, Pilatoori pueyata pocoojorohua socua. ");
INSERT INTO arlNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pueyari saaja jiyacateree jiyanohua nacoonura jatiqui: —¡Cuaara mosaaria niyacutesanojinia teetesano! ¡Cuaara mosaaria! ");
INSERT INTO arlNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatoori pueya sequenu pacuterohuacuhuaj: —¿Maatucua casaara mosaarejaarani? ¿Sesa miiriitijiaaraj? Janiyacuajaari tari na nequesoreereeni. Majaari sesa na miiniu quirii na mosaanura. Janiyari na majacutenutaniya narejani. Na nuhuaji cartesaarohuari. ");
INSERT INTO arlNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pueyari saaja socua jiyanohua nacooree niyacutesanojinia na mosaanura. Pueyacuara secojonaa jiyaniijianucuaari mariyata pueyata jiyanohua nacooriquiaa. Puera jiyanohua nojori nacoosacari, nojoriiri Pilato shocotaree. Cunora, Pilatoori maja na naata cartenu quirii Jesu, taa na paniriquiaacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Naaratej, Pilatoori socua tariniriohua. Pueya panishano miiriiri. ");
INSERT INTO arlNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pueya sequesano pueyano cartereeri, cante nujuatesaaquiaari nujuatejojuajiniacuajani na taanuunu paniniuucua Romano pueya, na monuucua pueyanojuhuaj. Na nuhuaji, Pilatoori Jesu tarinitiaree socua, nojori mosocoriquiano, taa nojori paniriquiaacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pueya jiyatasacari Jesu puecoosaquiria, nojoriiri tamonu pueyano quiaree Jerusalén tiacajiniara riujiuyano juucua. Nojuajaari Cirene jiyajinijinio pueyano quiquiaari. Na sesa quiquiaari Simón. Nojuajaari niyacutesano patesaaree Jesu nuhuaji. ");
INSERT INTO arlNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Queraatia pueyari Jesu nuhuajiriquiaa, queraatia maajipohuanio. Maajipohuari Jesuucua nujuqueturiquiaa, na nuhuaji nojori sacuasacari. Nocua sapiyonuuriquiaari, nocua nojori taraajenuta. ");
INSERT INTO arlNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jiyacaritij, Jesuuri cuno maajipohuacua tacateree. Nojori sequereeri: —Jerusalén tiacajiniji maajipohuanaa, maja cucua nujuquetunu. Tama niaacuajaaja nia nujuqueture, nia niquiohuacuanio. ");
INSERT INTO arlNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Na nuhuaji, jiyanohua taraatia quishacariiri quiniutianiya niaara, jiyanohua taraatia. Jiyacaritij, pueyari sequenutaniya: “Socua shuquiriaatia quijiaca cutaraari noo maajipohua cante muetuyashijiani, cante manajeyashijianucuani, mariyata cante mueya supueteyashijianucuajaniuhuaj”. Mueyaraca maajipohuari jiyacari jiyanohua taraajenutaniya, nojori niquishacari necohua miishacari naquiya. ");
INSERT INTO arlNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Naquiya miishacari, jiyacaritij, pueyari tuhuananuhua sequenutaniya: “¡Canaacua quia jiyaretaare!” Naajuhuaj, shiitianiyojua tuhuananuhua sequenutaniyari: “¡Canaacua nia tiyare canaa nia jamonura!” ");
INSERT INTO arlNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jiyacariiri jiyanohua naquiya miishacari quiniutianiya. Quiarijia, janiya jaara naa naquiya miishiyacuaani, ¿taaquitijia Pueyaso tojitiaashijiaca miishaanutaniyatejaj? ");
INSERT INTO arlNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Caapiqui sesa miijiacaari jaatucunuusaariquiaajuhuaj, mariyata teetejosocoriquiano Jesuta. ");
INSERT INTO arlNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nojoriiri puecoosaqui tiuquiijiosee. Cuniqui pueya puecoosaquini, na sesa quiquiaari “Pueyano Nacaco”. Nojoriiri tii Jesu teeteree maca niyacutesanojinia. Cuno caapiqui sesa miijiacaari teetejosaareejuhuaj, niquiriyatu na miaquetajara, tamonu na muenecara. ");
INSERT INTO arlNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesu jaara tari pijiosaariquiaa maca niyacutesanoocua, nojuajaari na Que Pueyaso sequeree: —¡Cua Quenaa, quia jiyanoori nio pojori! Majaari nojori niishiniu casaa na miitiuyani. Na nuhuaji, soldadohuari saitia tacuarishijioree, nojori niishiniuria taa nojori seraatianutaniya Jesu toqueni. ");
INSERT INTO arlNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pueyari Jesu shootiariquiaa. Judiocuaca jiyaniijianucuaari jaarajaaja Jesujiniji naa tama sequetooriquiaajaaja: —Nojuajaari saaja tamonu pueya naatanijiojua. Quiarijia, nojuaja jaara seetanujuanaa Pueyaso Jiyarosano Cristo quiri, cuaara roseera niyacutesanojiniji pa niquiara. ");
INSERT INTO arlNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldadohuari Jesu macaatiriquiaajuhuaj. Nojoriiri Jesu raateree piiquia vino juucua. ");
INSERT INTO arlNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jesu sequetureeri: —Quiaa jaara Judiocuaca jiyaniijia quiri, ¡niyacutesanojiniji quia roserecuarajaj! ");
INSERT INTO arlNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesu nacaacuma, suruhuatuneeri rupotasaaquiaari naajiosano Griego rupaajinia, Romano pueya rupaajinia, Hebreo rupaajinianio. Tii naajiotasano quiriquiaari naa nocuara pueya saquiriojotasano: “Nio pueyanoori Judiocuaca jiyaniijia”. ");
INSERT INTO arlNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tamonu cuno sesa miijiacajinijinio Jesu shuriucua teetesano quiriquiaani, nojuajaari Jesu rerequeteriquiaajuhuaj. Naa Jesu sequeriquiaari: —Quiaa jaara Pueyaso jiyarosano Cristo quiri, tama quia roserejaaja cuniquiji. ¡Canaa quia roshinijiorejuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Narta sesa miijiaari na juaarii: —¿Quiaateeri Pueyaso puereyashijia? Quiaari mosaanutaniyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pajaniya cutaraari sesa pa miiniuucua naquiya miishiyani. Paacuajaari maninia saniitioshiyani sesa pa miiniuucua. Saniniuujia, nio pueyano pa tajinia nujuataani, ¡nojuajaari sesa miyashijia cutara! ");
INSERT INTO arlNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na nuhuaji, narta sesa miijia juaaniaari Jesu sequeree: —Jesunaa, majaari cua niyajetanuujua, Pueyaso jaara quia jiyatere Jiyaniijiajanaa quia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesuuri na riucuaree: —Seetanujuanaa quia sequeyanijia, quiarijiani, nio juucaja, quiaari cuata quiniutianiya shuquiriaatia quishaqui cutara. ");
INSERT INTO arlNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Panacari, ¡jiyari ninishiquiria quiquiaari puetunujuanaa, juhua niucua! Pananu piriuushacari, cuhuatemohuari. ");
INSERT INTO arlNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jiya quishacarijia ninishiqui, jiyacaritij, Jerusalén tiacajinia Pueyaso Secojojua tiajinia, ¡jiyanohua shiquiiquia toquejiniji sohuacaari noojiaacoji sutequiaari puetunujuanaa querajaquera! ");
INSERT INTO arlNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jiyacarijiuhuaj, Jesuuri nacaree: —¡Cua Quenaa, cua sohuanu quia cojuare! Naa na sequenu nuhuajitij, Jesuuri cusoquee. ");
INSERT INTO arlNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Romano soldadohua jiyaniijia niquishacari puetunu niojuanaa, nojuajaari maninia sequeree: —¡Seetanujuanaa, nio pueyanoqui sesa miyashijia quiquianu! Naa na sequesanoori Pueyaso shuquiritirii. ");
INSERT INTO arlNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Puetunu pueyajanaa, canapuete Jesu shootiariquiaa cusoyanoni, nojoriiri taraatia na tiajinia quiojoquiaariuhua. Nojoriiri tama na jiriquiajaaja piquiniuuquiaariuhua, jiyanohua nojori tacaaniutia naa nojori monuucua Jesu. ");
INSERT INTO arlNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Saniniuujia, puetunu Jesu niishishano pueyajanaari tii jiyojetarohuajaa, maajipohuajuhuaj, canapuete Jesu nuhuajiquiaari Galilea jiyajinijicuajani. Puetunu nojorijianaari tucuacaanuji niquitiariquiaa Jesu. ");
INSERT INTO arlNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tamonu maninia pueyanoori quiquiaari. Nojuajaari Pueyaso tojijia pueyano quiquiaari Arimatea tiacajinijinio. Cuno tiacaari Judea jiyajiniajuhuaj. Cuno pueyano sesa quiquiaari José. Nojuajaari Judiocuaca jiyaniijianucuajinijinio quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Cuno Joseeri Pueyasoocua tiuujia quiquiaari. Nojuajaari pueyaracaanu sashijia, Pueyaso Jiyarosocoriquiano cuaara Jiyaniijiara jiyatesaaria cutara. Cunora, majaari José paniniu quiquiaari cutara, narta jiyaniijianucua sequesacari Jesu cuaara mosaaria. ");
INSERT INTO arlNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Naacuajitij, Jesu cusosacari, Joseeri Pilatoocua quiaquiaari, Jesu quete na masenura. ");
INSERT INTO arlNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na nuhuaji, Jesu quete roshinirii niyacutesanojinijiiri. Na jiuniocoreeri cohuajaque quenaaruque toquejinia. Jesu quete niaree tarijia na jiuutianishano saajiajiniaari. Cuno raajinia, juhuanojuaja maja macu niasaanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Cuno juucaari quiquiaari Judiocuaca jeenucuasacari juhuacarijia samaatenu juucaacuara. Nojori samaatenu juucaari quera coteeriquiaa tari. Judiocuacaara, pananu tiuquishacari, tamonu juucaari tari coteequiaari nojoriria. ");
INSERT INTO arlNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Cuno maajipohua, cante Jesuta nijioquiaari Galilea jiyajinijicuajani, cuno pojoriiri José nuhuajiquiaari raajiniara. Nojoriiri raaco niquishii, taa Jesu quete niasaareeni. ");
INSERT INTO arlNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nojori riujiuushacariuhua na tiajiniohua, nojoriiri juhuataja shanohua jaanutaja cojitijiosuhua, macuucua nojori niojosocoriquiano. Na nuhuaji, nojoriiri pootia quiriohua samaatenu juuca, taa Moisés rootaquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Coteenu semaana juucajinia, cuno maajipohuari tariquiicuaji raajiniara quiaquiaari. Nojori cojitijiosano shanohua jaanutaja patootaareeri. ");
INSERT INTO arlNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nojori tiuquiijiosacari raajinia, saajiajiniji quejasano raa tiootiu niquitiushiiri tariucua tamocora shuuquitishano. ");
INSERT INTO arlNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Naaratej, nojoriiri raaco tiuquitiamaa. Shaaqui quiriquiaari Jiyaniijia Jesu quete. ");
INSERT INTO arlNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nojoriiri shiriiquirii. Majaari nojori niishiniu quiriquiaa taa nojori miiniutianiyani. Canashiyaquiji caapiqui pueyari nojori shuriucua nujuatuquee. Nojori toqueeri shacantuque quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Maajipohuari na puerenuta jiyocuara naniquioree. Cuno canuuri nojori sequeree: —¿Casaara nia pajeya saminio pueyano macu niojosaquini? ");
INSERT INTO arlNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maja tari niya na quiniu. ¡Tari samiitiarohuano! ¿Niaateeri tari niyajetaree na sequesano niajaniya, Galilea jiyajinia na quishacarijia? ");
INSERT INTO arlNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nojuajaari tari nia sequecanucuaja, nojuaja sesa miijiaca niquitiosaanutaniya. Nojoriiri na monutaniya niyacutesanojinia. Na nuhuaji, nojuajaari samiitianutaniuhua jiuujianaraca juucajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jiyacaritij, maajipohuari shusha niishiquii tarijia Jesu sequesano nojori. ");
INSERT INTO arlNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nojori tacatesacariuhua jamajiniji, nojoriiri Jesu once saquiriojosano pueya caminiujiushuhua puetunu niojuanaa, puetunu Jesuucua tiuuniaa pueyajanaanio. ");
INSERT INTO arlNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Cuno maajipohua, Jesu saquiriojosano pueya pohuataquiaariuhuani, nojoriiri nio maajipohua quiquiaari: María Magdalena, Juana, Santiago nucua Maríajuhuaj, socua tamasaca maajipohuanio. ");
INSERT INTO arlNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jesu once pueyara, maajipohua pohuatasanoori juhua paateca sequesano quiquiaari saaja. Nojoriiri saa cuaracashitiriijiaa maajipohua pohuatanuusano. ");
INSERT INTO arlNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Naajaa, Pedroori tiajiniji netequiaari raajiniara. Raaco na cuuquesacari, saaja Jesu jiuniocotaja cohuajaque toque niquiquiaari maanoori. Pedroori juhua jiuujiaaju tacateyarohua na shiriiquiniutia, na niquishanojiniji, maajipohua pohuatasanojinijinio. ");
INSERT INTO arlNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Cuno domingo juucaja, caapiqui Jesu pueyari Emaús tiacajiniara quiojoriquiaa. Emaús tiacaari querajaa hora quiquiaari Jerusalén tiacajiniji, niohuacata quiasacari tiriara. ");
INSERT INTO arlNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nojori quiojosacari nucuaco, nojoriiri Jesujiniji pocoojoriquiaa, mariyata shusha naataja pueya miishanojiniji Jesu. ");
INSERT INTO arlNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Naa nojori pocoojosacari nucuacotej, Jesujuanaari jiyacari nojori rupuesee. Juhuajaniya nojoritia pacutaareeri. ");
INSERT INTO arlNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Majaari nojori niishiniu quiquiaari cana pueyanote cuno quiquiaarini. Nojori namijiaari tojequiaari, maja nojori niishiniuria Jesu. ");
INSERT INTO arlNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesuuri nojori nequesotaree: —¿Casaa nia pocoojotaacuaani? Nojoriiri nujuatuquee. Taraajecoyano niquishaariquiaari. ");
INSERT INTO arlNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cuno caapiqui pueyanojinijini, tamonu sesa quiquiaari Cleofas. Nojuajaari Jesu riucuaree: —Puetunu pueyajanaacuajaari niishiya casaate Jerusalén tiacajinia miishaarucuaa taraatiani. Quiaacuajaari Jerusalén tiacajinia quiquianujuhuaj. ¿Quiaatucua casaara niishiyaquirini casaate miishaarucuaani? ");
INSERT INTO arlNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesuuri nojori nequesotaree: —¿Casaate tii miishaarucuaajaarani? Jesu sequereeri: —¡Nazaret tiacajinijinio Jesuuri mosaarucuaajaj! Nojuajaari Pueyaso sequesano caminiujiunia quiquianu. ¡Jiyanohua maninia quijiaari na cumaacata na miijiosano, na niishitiojosanojuhuaj! Pueyaso timitiasano quijiaari, puetunu pueya panishanojuanaanio. ");
INSERT INTO arlNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pueyacuara secojonaa jiyaniijianucua, mariyata pa camarucuaari na niquitiorucuaa Romano jiyaniijia na motesocoriquiano. Niyacutesanojinia mosaarucuaari. ");
INSERT INTO arlNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Canaari juucua jiyaniquianuni, nojuajaari Romano pueya taanuunutaniya, pa Israel pueya quiniuria juhuajaniya tama pajaniyajaaja. Quiarijiani, jiuujianaraca juucaari tari na shoconujiya na mosaanujiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tamasaca maajipohua canaa maanujinijinioori canaa shirioree nojori pohuatasanota. Nojoriiri quiarijia tariquiicuaji quiojomaa Jesu raajinia. ");
INSERT INTO arlNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Nojoriiri maja na riuriatanu quishii na quete. Nojori tacatesacariuhua, nojoriiri canaa pohuatasuhua, nojorinia Pueyaso seya niquirii juhua na maquenujinia. ¡Cuno Pueyaso seyanaari nojori sequeree, Jesu tari samiitiarohua! ");
INSERT INTO arlNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na nuhuaji, tamasaca canaajinijinioori raajinia quiojiyareejuhuaj. Seetanujuanaa naa quiriquiaari, taa maajipohua sequeree canaacuajani. Maja cutaraari nojori niquiniu quirii Jesu. ");
INSERT INTO arlNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jiyacaritij, Jesuuri nojori sequeree: —Pueyanaa, majaquiiri juhuanojuaja nia niishiniu. Niaari taacanuyajaa puetunu tariucuacaanu Pueyaso sequesano caminiujiuniaa naajiotasanoocuajanaa nia tiuuniuria. ");
INSERT INTO arlNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Majateeri naa na pohuatasaanu quiquiaaricuaja: “Cristoori coteenu naa mosaanutaniyaquij. Na nuhuaji cutara, jiyanohua cumaacaracara quijiara jiyatesaanutaniuhuari Jiyaniijiajanaa na quiniuria”? ");
INSERT INTO arlNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesuuri juhuacatecara nojori niishitiojoree puetunu tariucuacaanu Pueyaso Rupaajinijijianaa, tee nojuajiniji naajiotasano quiyacuajani. Moisés naajiotasanojiniji pohuatanu coteereeri, na nuhuaji, puetunu Pueyaso sequesano caminiujiuniaa naajiotasanojinijijianaanio. ");
INSERT INTO arlNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nojori tiuquishacari cuno tiacajinia, terara nojori quiojoriquiaacuajani, Jesuuri juhua shocoriquiano canujuriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nojoriiri nojoritia na jiyojetenu paniriquiaa jiyanohua. Nojoriiri na sequeree: —¡Niyaja canaata quia jiyojere! Paa tari niniyareeni. Naaratej, Jesuuri nojoritia jiyojesee cuniqui. ");
INSERT INTO arlNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jesu jaara nojoritia cajiriquiaa tari miaquejajinia, nojuajaari pan ririi. Nocuara Pueyaso secojoreeri. Nojoriria na neecasereeri. Na nuhuaji, nojori serotareeri. ");
INSERT INTO arlNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jiyacaritij, nojori namijiaari juhua riatequequee. Jiyacariqui na niishitiuquiiri. Jesuuri saaja shaajequee cuniquijia nojori tajiniji. ");
INSERT INTO arlNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nojoriiri sequetooree: —¡Jesucuajaquiiri quiriquiaa! ¡Cunora poojiaqui jiyamitia timiriquiaa na pocoojosacari pajaniyata nucuamaji, nojuaja jaara niishitiojoriquiaa pajaniya Pueyaso Rupaajinia naajiotasanotej! ");
INSERT INTO arlNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jiyacaritij, nojori shuquiriniutia, nojoriiri ritia sanetaquee. Cuniquiji Jerusalén tiacajiniara tacaretaarohuari. Nojori tiuquishacariuhua, nojoriiri puetunu Jesu once saquiriojosano pueyajanaa riuriatasuhua tii tariucua rerejono, mariyata socua narta Jesu pueyata. ");
INSERT INTO arlNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tariucua tiajinia quiniaari Emaús tiacajiniji tiuquiijionaa sequeree: —¡Pa Jiyaniijiaqui seetanujuanaa samiitiarohua! ¡Simónri na niquirii! ");
INSERT INTO arlNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na nuhuaji, shusha tiuquiijionaari nojori pohuatareejuhuaj, taa Jesu pocoojoriquiaa nojoritiani, nucuaco nojori quiasacari, mariyata taa nojori niishirii nojuajani, pan na neecasesacari nojoriria. ");
INSERT INTO arlNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nojori pocoojosacarijia nojori niquishanojiniji Jesu, jiyacaritij, Jesujuanaari canashiyaquiji nojori tajinia nujuaquee. Naa nojori sequereeri: —¿Niaate quiyajaa? Nioojia nia cajitiri. ");
INSERT INTO arlNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nojoriiri shiriiquitiuquii. Jiyanohua puereturiquiaari. Nojoriiri Jesu jiyaniriquiaa naaqui. ");
INSERT INTO arlNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesuuri nojori sequeree: —¿Casaara nia pueretiuyani? ¿Casaara nia jiyajenetaa janiyani? ");
INSERT INTO arlNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cua juaashiquia nia niquiri, cua niohuacanio, nia niishiniuria janiyacuajaari quiyani. ¡Cua cootiuri! ¡Cua niquitiuri! Naaquiiri maja cuaqueyaraca, maja nucuhuaraca taa nia niquiya janiyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Naa nojori na sequesacaritij, Jesuuri nojori niquitijioree na juaashiquia, na niohuacanio. ");
INSERT INTO arlNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Puera nojori jiuujiatesacari, puera nojori shuquirishacarijiuhuaj, nojoriiri taacanuuriquiaajaa, maja naasucua Jesu. Cunora, Jesuuri nojori sequeree: —¿Niaate miaquesocoriquiano jiitiaacuaa? ");
INSERT INTO arlNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nojoriiri Jesu niquitioree sapitiaaja raqui caquishano. ");
INSERT INTO arlNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesuuri na maseree. Nojori niquiara na miaquereeri. ");
INSERT INTO arlNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na nuhuaji, nojori sequereeri: —Janiyari naa miishaarucuaani taa cua pohuataquiaari niajaniyacuajani, pueyaracaanu niaata cua quishacari tarijia. Nia sequequiaaricuajanijia, janiyari naa miishaanutaniyani, taa Moisés naajiotaquiaari janiyajinijicuajani. Puetunu Pueyaso sequesano caminiujiuniaajanaari janiyajiniji naajionuutaquiaarijiuhuaj. Supuetana Davidri janiyajiniji naajiotaquiaarijiuhua na jaaquequejoneejinia. Quiarijia tari tohuateerucuaari puetunu janiyajiniji cuno naajionuutasanojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jiyacaritij, Jesuuri nojori niishitirii tariucuacaanu Pueyaso Rupaa naajiotasano. ");
INSERT INTO arlNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nojori sequereeri: —Tariucuacaanu naa naajiotasanoori quiya: “Pueyaso Jiyarosocoriquianoori mosaariquiano, na nuhuaji, jiuujianaraca juucajinia samiitianutaniuhuari”. ");
INSERT INTO arlNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Naa naajiotasaaquiaarijiuhuaj, Jerusalén tiacajinia, janiyajinijiiri pohuatasaanutaniya pueya niquiara, na nuhuaji puetunu jiyacajiniajanaanio. Pueya tiuushacari cucua, nojori jaara noojiaca tacatorohua sesa nojori miiniujiniji, sesa nojori miishanoori tuujusaanutaniya, Pueyaso jiyanooshacari nojori. ");
INSERT INTO arlNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Niaacuajaari puetunu cua miishanojuanaa niquijiaca. ");
INSERT INTO arlNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Cua tojitiare. Janiya jaara jiyocuacaanu quiaarohua cua Queecuani, janiyari Pueyaso Sohuanu jiyaronutaniya niaacuani, taa cua Que sequequiaaricuajani. Niyaja pootia nia quiri Jerusalén tiacajiniani, niaa jaara jiyocuacaanuji niriquiano cumaaca maserejaatijia. ");
INSERT INTO arlNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na nuhuaji, Jesuuri nojori jiyataquiaari Jerusalén tiacajiniji, Betania tiacajiniara. Cuniqui nojori quishacarijia, Jesuuri na juaashiquia shiitioquiaari nojoriicuara na secojosacari Pueyaso, Pueyaso jiitianura maninia pueyaracaanu nojori. ");
INSERT INTO arlNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nojoriicuara na secojosacarijia, Jesuuri nojori shuriucuaji tacanishaaquiaari jiyocuacaanu. ");
INSERT INTO arlNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nojoriiri na shuquiritiaree. Na nuhuaji, nojoriiri Jerusalén tiacajinia panaatia tacateyarohua. Nojoriiri jiyanohua shuquiriaatia quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nojoriiri pueyaracaanu quijia Pueyaso Secojojua tiajinia. Tii Pueyaso maniniuhuaqueetatujua pueyaracaanuuri. Tariucuaja.");
INSERT INTO arlNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Paari Jesucristojiniji niishiyani taamuecateja na Que Pueyasoni. Naaratej, Jesucristoori sesojosaaquiaari “Pueyaso Rupaa”. Nojuajaari tari pueyaracaanu quijia, jiya quiyaquishacarijia. Na Que Pueyasota quijiaari. Pueyaso quijiajaariuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jiya coteesacari, nojuajaari na Que Pueyasota quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Na Queeri na shipinitiquiaari puetunu casaajanaa. Puetunu casaajanaari na shipinishano. Maja tamonu shipininia quiniu socua. ");
INSERT INTO arlNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nojuajaari quijiajuhuanajaj. Naaratej, nojuajaari na naata pueya jiuujia cuhuatanu, pueyaracaanu rishijia nojori quiniuriajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jesucristoori cuhuashiqui quijia. Naaratej, na rupaata poojia cuhuataari. Saniniuujia, Sesaacaari ninishiqui quijia. Naajaa, majaari na naata Pueyaso Rupaa na shocotanu. ");
INSERT INTO arlNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pueyasoori quiari naataja tamonu pueyano jiyaroquiaari, Neyanujiniji pohuatariquiano. Na sesa quiquiaari Tiuquinijiona Juan. ");
INSERT INTO arlNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pueyasoori na jiyaroquiaari pueya na niishitiniuria cante Jesucristoni, pueya tiuuniuria Jesuucua, nojori jiuujia na cuhuatanura. ");
INSERT INTO arlNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanri maja pueya jiuujia cuhuatana. Nojuajaari Jesucristojiniji pohuataquiaari pueya niishiniuria cante saniya poojia cuhuatana cutarani. ");
INSERT INTO arlNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","“Pueyaso Rupaari” seetanu poojia cuhuatanajanaa. Nojuajaari Jesucristo. Jiyocua niquiaariiri puetunu pueyajanaa niishiniuria cante Pueyasoni. ");
INSERT INTO arlNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","“Pueyaso Rupaari” mijiria rucuanejojua quiquiaari. Pueyari tama nojori Shipininiajaaja niishiyaquiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tama na saquiriojosano Israel pueyacua niquiaariiri. Nojoriiri na tamacaquiaari saaja. ");
INSERT INTO arlNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Saaja noojiaqueya pueyari nocua tiuuquiaari. “Pueyaso Rupaari” cuno pueya jiyatequiaari Pueyaso muerasura nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nojoriiri Pueyaso jatanishano, seetanujuanaa na muerasu nojori quiniuria. Pueyaso saquiriojosano pueyajiniji pueyano supuesacari, cunoori maja na naata na jiyatenu Pueyaso pueyano na quiniuria. Pueyari maja na naata muetunu tariucua Pueyaso pueya. Naajuhuaj, pueyanoori maja na naata tama na cuaqueyajaaja jiyatenu Pueyaso pueyano na quiniuria. Pueya cutaraari Pueyaso muerasura jataquiaa Neyanuucua nojori tiuushacari saaja. ");
INSERT INTO arlNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","“Pueyaso Rupaari” seetanujuanaa pueyanora jataquiaari mijiria na quiniuria. Nojuajaari Jesucristo. Canaata quiquiaariiri. Canaari na cumaacata na miijiosano niquiquiaarini. Jiyanohua maninia quiquiaariiri. Na Que Pueyasoori na cumaquijia jiyanohua maninia na miiniuria, Neyanuniyojua na quishacari. Nojuajaari saaja seetanu rupaajanaa sequeja Pueyasojiniji. Jiyanoojia quijiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Tiuquinijiona Juanri Jesucristojiniji pohuataquiaari pueya niquiara. Jiyanohua na rupaa paaretaquiaariiri pueya tojitianura nojuaja. Naa sequejaari: —Janiyacuajaari nojuajiniji nia pohuatajani, janiya jaara nia sequejani: “Tamonu pueyano cua nuhuaji niniutianiya”. Nojuajaari jiyaniijiajanaa cutara janiyajiniji. Nojuajaari tari quijia cua quiyaquishacarijia. Juanri naa pohuataquiaari Jesucristojiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jiyaniijiajanaa Jesucristo quiniuucua, puetunu pajaniyajanaari na jiitiasanojiniji masequiaani. Jiyanohua capora na quiniuucua, nojuajaari pueyaracaanu pa cumaquiquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pueyasoori supuetana Moisés naajiotequiaari na rootasano pajaniyara. Cunoori maja na cumaquiniu quiquiaari pajaniya. Quiarijia saniniuujia, pa panijia Pueyaso quiniuucua, nojuajaari Neyanujuanaa jiyaroquiaari pocua, pa jiyanooshaanura, naajuhuaj, seetanu rupaajanaa pa niishiniuria nojuajiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Majaari quenaaja tamonu pueyano niquiniu quijia Pueyaso. Neyanu, cante na Que shuriucua quijiacuajani, nojuajaari na Que pa niishitioquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalén tiacajinijinio canaa Judiocuaca camarucuaari na pueya jiyaramiquiquiaari Tiuquinijiona Juancua, nojori nequesoreenura Juan cante nojuajani. Nojori jiyaramiquishano pueyari quiquiaari supuetana Leví niquiohuacuajinio supueno pueya. Noojiaqueya cuno pojorijinijinioori quiquiaarijiuhua pueyacuara secojonaa pueya. ");
INSERT INTO arlNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nojori nequesotasacari Tiuquinijiona Juan, nojuajaari maja quenaaja na seetanu quiquiaari cante nojuajani. Seetanujuanaa naa nojori sequequiaariiri: —Janiyari maja Pueyaso Jiyarosano Cristoni. ");
INSERT INTO arlNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Cuno pueyari socua na nequesotarohua: —¿Canteeri quiajaniyani? ¿Quiaa jiyoteeri Pueyaso sequesano caminiujiunia Elías soj? ¿Quiaa jiyoteeri samiitiarohuacuaa? Tiuquinijiona Juanri saaja nojori riucuaree: —Maja. Janiya maja supuetana Elíasni. Cuno pueyari socua na nequesotarohuacuhuaj: —¿Quiaa jiyoteeri Pueyaso sequesano caminiujiunia, nooj tariucuacaanu sequesaaquiaari niriquianotej? Juanri saaja nojori riucuaree: —Maja. ");
INSERT INTO arlNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Cuno pueyari socua na sequeree: —Canaa quia pohuatareja, ¿cante quiajaniyani? Canaacua saniniuujia canaa camarucua pohuatasuhuanijia. ");
INSERT INTO arlNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juanri saaja naa nojori riucuaree: —Janiyacuajaari nooni, cariiquia jiyajinia nacajatej, taa supuetana Isaías juhuacarijia naajiotaquiaari janiyajinijicuajani: “¡Jiyaniijiaacuaji nia nuunore maninia! ¡Maja shuutiuniu!” ");
INSERT INTO arlNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jiyacaritij, Fariseocuaca camarucua jiyaramiquishano pueyari Tiuquinijiona Juan nequesotaree: ");
INSERT INTO arlNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Quiaa jaara quiyaquiri Cristo, Elíasjuhuaj, cuno tariucuacaanu sequesaaquiaari niriquiano Pueyaso sequenu panishano caminiujiuniatej, ¿casaara pueya quia tiuquinijiya moojiniacuaraarini? ");
INSERT INTO arlNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juanri nojori riucuaree: —Janiyari nareja moojinia tiuquinijiya pueyani. Saniniuujia, tamonuuri niya quiya, nia niishiyaquishoojua. ");
INSERT INTO arlNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nojuajaari cua nuhuaji niniutianiya. Nojuajaari Jiyaniijiajanaa cutara. Majaari quenaaja cua naata na seru quiniu na sapatu neyocua cua saacatanura nera. ");
INSERT INTO arlNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Naa cuno pojori nequesoreesacari Tiuquinijiona Juantej, cunoori quiriquiaa Betania jiyanishano tiacajinia, Jordán moo taquijiria, tee cuniqui Juan tiuquinijioriquiaa moojinia pueyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tariqui saniniuujia, Tiuquinijiona Juanri Jesu niquirii nocua niyano. Juanri naa sequeree canaa niquiara: —Paari pueyaracaanu mooquiaa borregohuani Pueyaso jiyanooniuria pajaniya. ¡Nia niquiri! ¡Cuno cumaji canujiyani, cunoori Pueyaso Jiyarosano, juhua borrego puetunu pueyacuara mosocoriquiano, seetanujuanaa sesa pa miishanojiniji pa jiyanooshaanura! ");
INSERT INTO arlNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Janiyacuajaari nojuajiniji nia pohuatajani janiya jaara nia sequejani: “Cua nuhuaji niniutianiyari Jiyaniijiajanaa cutara. Nojuajaari tari rishijia cucuaji cua quiyaquishacarijia”. ");
INSERT INTO arlNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Janiyari na niishiyaquijiajuhuaj, cante nojuajani. Naajaa, janiyari parta Israel pueya tiuquinijioquiaa moojiniani, noojia nojori jeenucuanura, Pueyaso Jiyarosano nojori niishiniuria cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tiuquinijiona Juanri pueya sequereejuhuaj: —Janiyari Pueyaso Sohuanu niquiriucuaani jiyocuacaanuji roseyano nocua juhua mococoonu. Nocua tiuushiiri. ");
INSERT INTO arlNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Cuno, cua jiyaroquiaari pueya cua tiuquinijionura moojiniani, nojuajaari cua sequequiaari: “Quiaa jaara cua Sohuanu niquiri pueyanoocua roseyano, nocua na tiuuniuria, quiocua niishiri, cunocuajaari cua sequesano quiajaniya. Nojuajaari cua Sohuanu tiuquinijionutaniya pueya jiuujiajinia cutara, seetanujuanaa cua muerasu nojori quiniuria”. Nojuaja jaara naa cua sequeyaquiquiaari, janiya maara na niishiyaquiquianuni. ");
INSERT INTO arlNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Janiyacuajaari tari na niquiquianuni. Naaratej, janiyari saniniuujia nia pohuataani pueyanaa, ¡nojuajaari seetanujuanaa Cristo, Pueyaso Niyanu! ");
INSERT INTO arlNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tariqui, Tiuquinijiona Juanri tii quishiiquiuhua caapiqui na pueyata. Janiyari niquiriyatu cuno caapiqui pueyanojinijinio quiriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tiuquinijiona Juan jaara Jesu niquiquiaari shocoyano, jiyacari canaa sequereeri: —¡Nia niquiri! Cunoori cua sequesano niajaniya, Pueyaso Jiyarosano pocuara mosocoriquiano juhua borrego, sesa poojia seque jeequesaanura. ");
INSERT INTO arlNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Naa canaa tojishacari Juan sequesanotej, canaari Jesu nuhuajiquiaarini. ");
INSERT INTO arlNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesuuri canaacua tacateree. Canaa na niquishacari na nuhuaji sacuaano, canaa sequereeri: —¿Casaa nia paniyani? Canaari na sequereeni: —Niishitiojonanaa, ¿tee quia maquequiaacuaani? ");
INSERT INTO arlNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesuuri canaa riucuaree: —Miji. Nia niquiquii. Canaari nata quiaareeni. Canaari na quijia niquitiushiini. Tari pananu piriuushacariiri quiriquiaa jiyacari. Cunora, canaari tii maquetusee Jesutani. ");
INSERT INTO arlNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tiuquinijiona Juan niquitiniuucua Jesu canaa, canaari Jesu nuhuajiquiaarini. Andrésri cua cojiriquiaa. Andrésri tarajanu jiitiaja. Na sesaari quijia Simón Pedro. ");
INSERT INTO arlNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tariquiicuaji, Andrésri ritia tarajanu Simón pajenuucua quiaquiaari. Na riuriatasacari, na sequereeri: —¡Cua tarajanunaa, canaari Cristo niquiriquiacuaani, tariucuacaanu Pueyaso sequesano na jiyarosocoriquianotej! ");
INSERT INTO arlNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Na nuhuaji, Andrésri tarajanu Simón jiyataaree Jesuucua. Jesu niquishacari Simón, na sequereeri: —Quiaacuajaari Simón, Juan niyanu. Quiarijia saniniuujia, quia sesaari quiniutianiya Cefas. Griego rupaajinia, nioori sequeya Pedro. Pedroori saniniuujia pueyano rupaajinia sequeya “Saajia”. ");
INSERT INTO arlNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tariqui, Jesuuri Galilea jiyajiniara quiariquiaa. Felipe riuriatamaari. Na sequereeri: —Cua tarajare cua pueyano quia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipeeri nata quiaaree. Nojuajaari Betsaida tiacajinijinio quiquiaari. Andrésri tarajanu Pedrota cuno tiacajinijinio quiquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na nuhuaji, Felipeeri Natanael pajeree. Na riuriatasacari, na sequereeri: —¡Canaa noo pueyano niquiriini, Moisés nojuajiniji naajiotaquiaari tariucuacaanutej! Tariucuacaanu Pueyaso sequesano caminiujiuniaa pueyari nojuajiniji naajionuutaquiaarijiuhuaj. ¡Nojuajaari Nazaret tiacajinijinio Jesu, José niyanu! ");
INSERT INTO arlNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelri saa riucuareejaa: —¡Jaj! ¿Na naatate maninia miijia pueyano supuenujuaara cuno sesa miijiaca Nazaret tiacajiniji? Felipeeri na sequeree saaja: —¡Miji! ¡Pa niquishii! ");
INSERT INTO arlNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesuuri Natanael niquirii nocua niyano. Na sequereeri: —Nio pueyanoori seetanu pa supuetana Israel niquiohuacuajinio supuenojuanaa cutara. Majaari na niishiniu sapojonu. ");
INSERT INTO arlNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelri na sequeree: —¿Taa quia niishiya janiyarini? Jesuuri na riucuaree: —Felipe sequeyaquishacarijia quiajaniya cucua quia niniuria, janiyari tari quia niquirii coojiatani, higo naana pajama tateyano. ");
INSERT INTO arlNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaelri shiriiquirii. Jesu sequereeri: —Niishitiojonanaa, ¡quiaacuajaqui Pueyaso Niyanu! ¡Quiaari parta Israel pueya jiyaniijiaranojuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesuuri na sequeree: —¿Quiaateeri cucua tiuuquii shusha saaja cua sequesacari quiajaniya: “Quia niquirii higo naana pajama tateyanonijia”? Seetanujuanaa quia sequeyanijia, quiaari na nuhuaji cua cumaacata cua miijiosano niquiniutianiya cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesuuri cuniqui quiniaa pueya sequereejuhuaj: —Seetanujuanaa nia sequeyanijia, niaari jiya cajiniocua niquiniutianiya riateno. Pueyano cua quishacari, niaari Pueyaso seya niquiniutianiya cucua roseetaano, cucuaji taqueetaanojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jiuujianaraca juuca nuhuaji, tamonu pueyanoori camiquiaari Caná tiacajinia, Galilea jiyajinia. Masuusano pueyari queranacuriquiaa. Jesu nucuaari tii quiriquiaajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesuuri na saquiriojosano pueyata masuusaaquiaarijiuhuaj, camishacari queranacunura. Janiyari na saquiriojosano pueyano quiriquiaa jiyacari tarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jiyacaritij, mashacaari ritia puequemaa. Na nucuaari Jesu sequeree: —Sanaa, mashaca tari puequemaa. Mashacaari quiquiaari uva caaca, vinotuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesuuri na nucua riucuaree saaja: —Maajiniaa, ¿casaara quia sequeya janiyani? Juhuanojuaja maja cua poonijiosacari Pueyaso cumaacata. ");
INSERT INTO arlNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Na nucuaari pueya raatojonaa sequeree: —¡Niocua Jesu tojirijia! Jaara nia sequere, niocua puetunu na sequesanojuanaa miiri. ");
INSERT INTO arlNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tii cajitiuriquiaari seis conatu, saajiajiniji quejasano. Canaa Judiocuacaari sequeyarucua shuquirioojua tiajinia nojori tiuquishacariuhua, juhua jeequesano nojori quiniuria Pueyaso niquiara. Nojori mohuaca cajitiacojua quiquiaariiri cuno conaa. Jiyanohua puereetucocua quijiaari. Cuno conatuuri setenta tumococua mishaja mohuacata mishinishano quijia. ");
INSERT INTO arlNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesuuri pueya raatojonaa sequeree: —Mohuaca nia taquirioore. Niocua nio conaa mishinijiore. Pueya raatojonaari conaa mishinijioree. Mohuacaari conaa rupaacuma puecacosee. ");
INSERT INTO arlNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesuuri nojori sequeree: —Quiarijiani, tiji nia shuuri. Queranacunu camaru nia sanitiore coteenu. Raatojonaari na raatesee. ");
INSERT INTO arlNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Queranacunu camaruuri vinora jatano mohuaca sanirii. Majaari na niishiniu quiquiaari cuno na ratusanoori mohuacajiniji jatanishaaree vinora. Saaja pueya raatojonaa cutaraari na niishiriquiaa. Nojoricuajaari mohuaca mishinijioree cuno conaajinia. Queranacunu camaru saniniu nuhuaji cuno ratusano, camiyano pueyano piiriiri. ");
INSERT INTO arlNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Na sequereeri: —Pueyaruhuatijia coteenu raateja shocuanacu vinote. Puetunu masuusano pueya jaara tari raruure queraatia, na nuhuaji raatesano cutaraari shaarunacu vino. ¡Quiarijia saniniuujia, nio cua ratusanoni, cunoori socua maniniuniacu vino coteenu quia raatojotesanojiniji! ");
INSERT INTO arlNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Naa Jesu jatanishacari mohuaca vinoratej, cunoori coteenujuanaa na cumaacata na miishano quiquiaari Caná tiacajinia, Galilea jiyajinia. Nojuajaari naa niquitiquiaari Pueyasojiniji na cumaaca. Naacuajitij, canaa na saquiriojosano pueyani, canaari niishiquiaarini Jesuuri seetanujuanaa Pueyaso Jiyarosano. ");
INSERT INTO arlNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Na nuhuaji, Jesuuri Capernaum tiacajinia quiaaree na nucuata, tapueyocuacatajuhuaj, canaa na saquiriojosano pueyanio. Canaari tii camueenujuquiaari pasajani. ");
INSERT INTO arlNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Quera canaa Judiocuaca queranacusacari Pascua juucara Jerusalén tiacajinia, Jesuuri tii canaa jiyataareejuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na tiuquishacari, Pueyaso Secojojua tiajinia quiamaari. Tii niquishii pueyari juyaca niquitiojiyano Pueyasoocuara puecoosocoriquiano, borregohua, noseyanio. Pueyari tii na juhuacutucuajinia cajitiuriquiaajuhuaj, pueya na tacatojonura taucuaca cumaneeca, Pueyaso Secojojua tiajinia niquitiojosocoriquiano cumaneecara. ");
INSERT INTO arlNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Naa na niquishacari pueya miyano Pueyaso Secojojua tiajiniatej, Jesuuri seya morojotaja jiyocua tatucuaree. Na majacutajara na shitiareeri. Cunota, puetunu nojorijianaa jaacaree Pueyaso Secojojua tiajinijiiri, puetunu nojori borregohuatajanaa, mariyata puetunu nojori juyacatajanaanio. Cumaneeca rerecojoree jiyocuara juhuacutucuajinijiiri. Naajuhuaj, cumaneeca juhuacutucua caponeetareeri. Pojotaariquiaacuaari. ");
INSERT INTO arlNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Noseya niquitiojonaa pueya sequereeri: —¡Niiquiji nia patootare nio noseya! ¿Casaara nia jiyatecanu juhua casami niquitiojosaquiria cua Que tiani? ");
INSERT INTO arlNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jiyacaritij, canaa, Jesu saquiriojosano pueyani, canaari niishiquiini, seetanujuanaa tariucuacaanu Pueyaso Rupaajinia naa naajiotasanoori quiya: “Quia tiaacua juaatishaaree jiyanohuanijia, jiyanohua cua panishacari quia tia”. ");
INSERT INTO arlNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Naa Jesu miiniuucuatej, narta Judiocuaca camarucuaari Jesu nequesotaturee: —¿Cante quia sequerucuaa naa quia miiniuriani? ¡Canaa quia niquitiricuaraja Pueyaso cumaacata quia miishano, canaa niishiniuria quiaari seetanujuanaa Pueyaso Jiyarosano! ");
INSERT INTO arlNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesuuri nojori riucuaree miriqui: —Pueyaso tia nia niyartare, janiyacua saaja jiuujianaraca juucajinia na tucuatarohua tianu tamajaajani. ");
INSERT INTO arlNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Narta Judiocuaca camarucuaari na riucuaree: —¡Cuarenta y seis marijiaari shoconujuquiaari pueya tucuatanura nio secojojua tia! ¿Quiaateeri jiyaniya quia naata na tianuhua ritia, saaja jiuujianaraca juucajinia? ¡Maja quia naata! ");
INSERT INTO arlNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesuuri tama na cuaqueyajaaja pohuatariquiaa, Pueyaso tia na sequesacari. ");
INSERT INTO arlNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Naacuajitij, Jesu jaara samiitiaquiaariuhua, canaa na pueyari jiyacari shusha niishiquiaari naa Jesu sequesano miriquini. Naaratej, canaari tariucuacaanu Pueyaso Rupaajinia naajiotasanoocua tiuuquiaarini, Jesu sequesanoocuanio. ");
INSERT INTO arlNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Canaari ocho juuca camueenujuquiaari Jesuta Jerusalén tiacajiniani, Pascuara queranacunuusacari. Tii canaa quishacari, tii quiniaa pueyari Jesu cumaacata na miijiosano niquiquiaari. Naaratej, queraatia pueyari nocua tiuuquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Naajaa, majaari Jesu tiuuniu quiriquiaa seetanujuanaa nojoriicua. Nojuajaari nojori niishiriquiaa, taamueca pueyate nojorini. ");
INSERT INTO arlNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tamonu pohuataaquishacarijia nojuaja, nojuajaari tari niishiya taamueca jiuujiaracate pueyani. ");
INSERT INTO arlNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Niucua, tamonu pueyanoori niquiaari Jesuucua. Na sesa quiquiaari Nicodemo. Nojuajaari canaa Judiocuaca camarucuajinijinio quijia, Fariseocuaca maanujinijiniojuhuaj. Tojishano pueyano. ");
INSERT INTO arlNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jesuucua na tiuquishacari, naa na sequeseeri: —Niishitiojonanaa, quia cumaacata quia miiniuucua canaa niquiara, canaari cunora niishiyani quiaari Pueyaso jiyarosano, canaa niishitiojoriquiano. Seetanujuanaa, Pueyaso jaara pueyano naacuyaquiri na cumaacata, nojuajaari maja na naata cusosuhua naatanijionu taa quia miiquiaacuaani. ");
INSERT INTO arlNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesuuri Nicodemo sequeree: —Seetanujuanaa quia sequeyanijia, pueyano jaara juhua conaaja raaquishaarohua, majaari na naata Pueyaso pueyanora na quiniu, Pueyaso jiitianura nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemoori Jesu nequesotaree: —¿Pueyanotucua taa rasaarohuani, nojuaja jaara tari cumantumaca quiya? Majaari na naata na nucua saracajinia tiuquiniuhua na rasaanuhuara. ");
INSERT INTO arlNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesuuri na riucuaree: —Seetanujuanaari cua sequesano. Cua tojiri. Paari coteenu rasaaquiaari pueyano pa quiniuriani. Saniniuujia, cante quiarinio pueyanora jataniyaquishano Pueyaso Sohuanutani, nojuajaari maja Pueyaso jiitiasanoniyojua na quiniu quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mijiria pueya muetusanoori saaja pueyano. Saniniuujia, cante Pueyaso Sohuanu jatanishano quiarinio pueyano na quiniuriani, nojuajaari Pueyaso pueyano cutara, pueyaracaanu rishiriquiano. ");
INSERT INTO arlNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Naaratej, majaari quia shiriiquiniu puera, naa cua sequenuucua quiajaniyatej, quiaa cuaara rasuhuara, seetanujuanaa quiarinio pueyano quia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mijiria, paratuuri piyarojoquiaa taa na paniyacuajani. Paari nareja na cojuatunenu tojiquiaani. Majaari pa niishiniu teje na piyarojiyani, tee cunocora na quiaajaaniuhuaj. Naajaariuhuaj, majaari quia niishiniu taa Pueyaso Sohuanu jataniquiaa pueyanoni, quiarinio pueyano na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemoori Jesu nequesotarohuacuhuaj: —¿Pueyanotucua taa quiarinio pueyanora jatanishaarejaarani? ");
INSERT INTO arlNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesuuri na riucuaree: —¿Majateeri quia niishiniu cua sequesano quiajaniya? Quiaari Pueyaso Rupaa niishitiojonacuaja Israel pueyara. ");
INSERT INTO arlNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Canaari seetanujuanaa pohuataquiaa canaa niishishanoni, canaa niquishanojuhuaj. Niaari saniniuujia saaja na cuaracashitiquiaa, canaa pohuatasacari niajaniya seetanu rupaajanaa. ");
INSERT INTO arlNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Niaa jaara saaja cuaracashitiquiaa cua pohuatasano mijiria casaajiniji, ¿niaatucua taa niishiriquiani, janiya jaara nia pohuatare jiyocuacaanuji casaani? ");
INSERT INTO arlNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Janiyari jiyocuacaanu quijiani. Majaari quenaaja tamonu pueyano tacanu quiquiaari jiyocuacaanu, saaja tijinio roseno cutara. Nojuacuajaari janiya. ");
INSERT INTO arlNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Cariiquia jiyajinia pa supuetanaa Israel pueya rucuanejosacari, Moisésri na shipinishano soconu nujuaretaquiaari macaacua, soconu sasuhua niquishocoriquiano. Na niquiniaa pueyari naatacoquiaariuhua. Naajuhuaj, janiyari macaacua nujuaretasocoriquianoni. ");
INSERT INTO arlNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Naacuajitij, puetunu cucua tiuuniaajanaari pueyaracaanu quijiaca quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Jiyanohua cua Que Pueyaso paniniuucua puetunu mijiria quiniaa pueyajanaa, nojuajaari Neyanujuanaa jiyaroquiaari puetunu pueyapueecuarajanaa mosocoriquiano. Puetunu cucua tiuuniaa pueyajanaari saniitioyaquishaanutaniya cutara. Nojori cutaraari pueyaracaanu rishijiaca quiniutianiya Pueyaso shuriucua. ");
INSERT INTO arlNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pueyasoori maja na jiyaronu quiquiaari janiya pueya cua saniitionura. Seetanujuanaa cua jiyaroquiaari cutaraari pueyacuaji Tacuna cua quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Cante cucua tiuujiani, majaari na saniitiosaanu quiniutianiya. Saniniuujia, cante cucua tiuyashijiani, nojuajaari tari pueyaracaanu saniitiosocoriquiano jiyatesano quiya. ");
INSERT INTO arlNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Janiyari mijiria niquiaarini pueya jiuujia cua cuhuatanura Pueyaso Rupaata. Pueyari saaja na ruuretaquiaa, ninishiqui nojori jiuujia quiniuucua. Sesa miijiaca nojori quiniuucua, majaari nojori paniniu cuhuatasano nojori quiniuria. Naaratej, nojoriiri saniitiosaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Puetunu sesa miijiacajanaari cua niquiniu paniyashijia, pueya jiuujia cuhuatana cua quishacari. Majaari nojori niniu paniniu cucua, sesa nojori miishano mariqui niishishaareeri. ");
INSERT INTO arlNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Saniniuujia, cante maninia miiquiaani taa Pueyaso sequeya na Rupaajiniacuajani, nojoriiri cuhuashiqui quiniu panijiaca cutara. Nojoriiri cucua nijioquiaa na niishishaanura nojori miishano cutaraari puetunu maniniajanaa, taa Pueyaso paniyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Na nuhuaji, Jesuuri quiojoquiaari canaata Judea jiyajinia, canaa na saquiriojosano pueyatani. Tii canaa quishacari Jesuta, canaari pueya tiuquinijioriquiaa moojiniani, pueya tacatosacari noojia sesa nojori miishanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tiuquinijiona Juanri jiyacari pueya tiuquinijioriquiaajuhua Enón tiacajinia, Salím tiaca shuriucua. Juanri tii tiuquinijioriquiaa pueya, queraatia mohuaca quishacari tii. Pueyari nocua quiojoquiaarijiuhuaj tiuquinijiosano nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Juanri jiyacari nujuatejojuajinia nujuatesoo quiriquiaajaa. ");
INSERT INTO arlNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Cuno quishacari, Tiuquinijiona Juan pueyari tamonu narta Judio pueyanota pocoojoriquiaa taate pueya naata juhua jeequesano quiniu Pueyaso niquiarani. ");
INSERT INTO arlNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nocuaji nojoriiri Tiuquinijiona Juan sequetusee Jesujiniji: —Niishitiojonanaa, noo pueyano, quiaa nojuajiniji canaa pohuatacanutej, noo quiata quiquianu Jordán moo taquijiriatej, nojuajana pueya tiuquinijiyajuhuaj. Puetunu pueyajanaana nocua quiojiya tiuquinijiosano nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tiuquinijiona Juanri nojori riucuaree saaja: —Saaja Pueyaso cumaquishacari pueyano, pueyano na naata maninia miiniu Pueyasora. ");
INSERT INTO arlNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Niajaniyacuajaari cua tojiquianu sequeyano: “Janiyari maja Pueyaso Jiyarosano Cristoni. Janiyari nareja nocuaji jeenucuariquiano jiyarosaaquiaarini”. ");
INSERT INTO arlNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pueyano rupuena jaara camiya necocuara, quiarijia cutara necocuaari seetanujuanaa saaja nerano. Naajaa, na rupuena quishacari na shuriucua, na timitiaari na tojishacari necota pocoojiyano shuquiriaatia. Naajuhuaj, janiyari cunora shuquiriaatia quiarijia quiyani pueya rupuesacari Jesucristo. ");
INSERT INTO arlNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Janiyari cunora jiyarosaaquiaaricuajani, pueya cua tojitiniuria nojuaja. Naaratej, pueya cuaara carteera janiya, Cristoocua nojori pacunura saniniuujia, nojori tojiniuria nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Cante jiyocuacaanuji niquiaaricuajani, nojuajaari Jiyaniijiajanaa cutara. Janiyari saaja mijiria quiniani. Cunora, cua pohuatasanoori saaja mijiria cua tojishano. Jesucristo saniniuujia, nojuajaari jiyocuacaanuji ninio cutara. Nojuajaari Jiyaniijiajanaa. ");
INSERT INTO arlNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Naacuajitij, na pohuatasanoori tama na niquishanojuaaja jiyocuacaanu, na tojishanonio. Pueyari na pohuatasano cuaracashitiquiaa saaja. ");
INSERT INTO arlNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Canapuete Jesucristo pohuatasanoocua tiuujiacani, nojoriiri sequeya, seetanujuanaaqui Pueyaso sequesano Neyanujiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pueyasoori jiyanohua queraatia na Sohuanu niquitioquiaari na Jiyarosano. Naacuajitij, seetanu Pueyaso rupaajanaa pohuataari. ");
INSERT INTO arlNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pueyasoori jiyanohua panijia Neyanu. Naaratej, nojuajaari na jiyatequiaari puetunu casaa jiitianarajanaa na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Canapuete Neyanuucua tiuujiacani, nojoriiri tari jatanishano pueyaracaanu rishijia nojori quiniuria Pueyasota. Saniniuujia, canapuete Neyanuucua tiuyashijiacani, nojoriiri tariucua Pueyaso juaashano quiya. Nojoriiri saniitiosaanutaniya Pueyasooju nojori quiniuria pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseocuacaari pohuatasaaquiaari, jiyanohua queraatia pueya Jesuucua quiojiya na tojitianaa nojori quiniuria. Nojoriiri pohuatasaaquiaarijiuhuaj, Jesuuri socua queraatia pueya tiuquinijiya Tiuquinijiona Juanjiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Seetanujuanaa majaari Jesujuanaa tiuquinijionu quiriquiaa pueya. Saaja canaa cutaraari pueya tiuquinijioriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesu jaara niishiquiaari Fariseocuaca naa pohuatasaarucuaa nojuajinijitij, nojuajaari Judea jiyajiniji jiyataquiaariuhua canaa Galilea jiyajiniara. ");
INSERT INTO arlNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Canaa quiasacari nucuaco, canaari Samaria jiyacuma tajiriquiano quiriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Naa canaa quiasacari nucuacotej, canaari Sicar tiacajinia tiuquishiini, Samaria jiyajinia. Cuniquiji, cateca quiriquiaari supuetana José cuhuariquia, na que Jacobo niquitiosano nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Cuno cuhuariquiajinia quiriquiaari cuari, supuetana Jacobo jiuutiasano tariucuacaanu. Pueyaracaanu Jesu rucuanenuucua nucuamaji, nojuajaari cuno cuari shuriucua cajishii na samareenuta. Panacariiri quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jiyacaritij, canaari tiacajinia quiamaani canaa miaquesocoriquiano canaa masenura casaa. Canaa niyacari, cuno Samaria tiacajinijinio maajiiri cuarimia quiaquiaari mohuaca taquitianura. Jesuuri na sequeree: —Cua raatere. ");
INSERT INTO arlNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Cuno maajiiri Jesu sequeree: —Pueyanonaa, ¿casaara quia sequeya Samaria jiyajinijinio maaji raatenura quiajaniyani? Quiaacuajaari Judio. Cuno maajiiri naa sequeree Jesutej, na niishiniuucua Judiocuacacuajaari maja na niquiniu paniniu quijia Samaria jiyajinijinio pueya. ");
INSERT INTO arlNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesuuri saaja na sequeree: —Majaari quia niishiniu cante quia sequereeni: “Cua raatere”. Quiaa jaara niishiriquia casaa Pueyaso jiitiaa quiarani, quiaa maara cua sequere cua raatenura quiajaniya. Quiaa jaara cua masere, janiya maara quia raatere pueya samiitianijia mohuacani. ");
INSERT INTO arlNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Maajiiri na sequeree: —Jiyaniijianaa, majaari quenaaja quia jiitianu casaa, mohuaca quia taquiriatajara. Nio cuariiri jiyanohua tucuaa. ¿Quiaatucua teje taquitiare cuno mohuacani, pueya samiitianijiani? ");
INSERT INTO arlNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Quiaateeri jiyaniijiajanaa cutara, socua pa supuetana Jacobojiniji? Nojuajaari nio cuari tiujiaquiaari canaara. Nojuajaari niiquiji ratujua quiquiaari necohuata, na seesano seyanio. ");
INSERT INTO arlNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesuuri na riucuaree miriqui: —Puetunu nio cuarijiniji ratujuacajanaari saaja jiyamuecoquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Saniniuujia, cante cua mohuaca ratunutaniyani, majaari socua na jiyamuenu quiniutianiuhua. Cua mohuacaari juhua samo naca pacartanutaniya pueyaracaanu noojiajinia, shuquiriaatia na rishiniuria pueyaracaanu. ");
INSERT INTO arlNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Cuno maajiiri Jesu sequeree: —¡Pueyanonaa, cuno mohuaca cua niquitiore cua ratusocoriquiano, maja socua cua jiyamuenura, naajuhuaj, maja pueyaracaanu cua taquirioojonura nio cuarijiniji! ");
INSERT INTO arlNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesuuri na sequeree: —Miji quia niyaca quia sequecoo coteenu. ");
INSERT INTO arlNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Maajiiri na riucuaree: —¿Janiyate niyacaracajaarani, quiaa jaara naa cua sequere? Jesuuri na sequeree: —Quiaacuajaari seetanujuanaa cua sequeree: “Niyacaajunijia”. ");
INSERT INTO arlNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Seetanujuanaari. Quiaari tari cinco niyacaaraca quiquiaari. Mariyata cuno, quiarijia quiata quiyani, majaari quia niyacajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Naa cuno maaji tojishacari Jesu sequesanotej, Jesu sequereeri: —Jiyaniijianaa, ¡quiaaqui Pueyaso sequenu panishano caminiujiunia! ");
INSERT INTO arlNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Canaa supuetanaa pueyari niya nio tuhuananuucua Pueyaso secojonuujua tarijia. Niajaniya saniniuujia, Judiocuacani, niaari sequequiaa Pueyaso cuaara secojosaaria saaja Jerusalén tiacajinia. ");
INSERT INTO arlNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesuuri na riucuaree: —Seetanujuanaa quia sequereera maajiniaa. Cua sequesanoocua quia tiuurii. Quera quiniutianiyari Pueyaso nia secojosacari puetunu tiquiyocua nia quishacarijianaa. Majaari tari Pueyaso secojosaanu quiniutianiya saaja Jerusalén tiacajinia, nio tuhuananuucuajuhuaj, taa quia sequereecuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Niajaniyari maja nia niishiniu cana nia secojoquiaani. Canaa Judiocuacani, canaa cutaraari niishiyani cana canaa secojoquiaani. Pueyasocuajaari canaa Judiocuaca supuetanaa niishitioquiaari pueyacuaji Tacunaari supuenutaniya tama canaa Judiocuacajinijiniojuaaja. ");
INSERT INTO arlNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Quiarijia cutara, cante seetanujuanaa Pueyaso shuquiritiajacani, nojoriiri na Que Pueyaso secojonutaniya puetunu noojiatajanaa, seetanujuanaa na tojijiaca nojori quishacari. Pueyasoori naa paniya pueya secojonura nojuaja, cante na secojonuujuacacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pueyasoori sohuanu. Naaratej, cante Pueyaso shuquiritiniu panijiacani, nojori cuaara secojoora Pueyaso puetunu noojiatajanaa, Pueyaso Sohuanu tojijiaca nojori quishacari. ");
INSERT INTO arlNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Cuno maajiiri Jesu sequeree: —Janiyacuajaari niishiyani Pueyaso sequesano Cristo mijiria na jiyarosocoriquianoori niniutianiya. Nojuaja jaara tiuquiri, nojuajaari puetunu maninia pa pohuatanutaniyajanaa. ");
INSERT INTO arlNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jiyacaritij, Jesuuri maatia na sequeree: —Janiyacuajaari cunoni, quiata pocoojiyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jiyacaritij, canaari Jesuucua tiuquiijiorohuani. Canaari jiuujiatequiaarini canaa niquishacari Jesu pocoojiyano cuno maajitia. Majaari quenaaja canaa nequesotanu quirii Jesu, casaa cuno maaji paniriquiaani, mariyata casaajiniji nojori pocoojoriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Cuno maajiiri cuniquijia na pataco tiujiaquee. Na tiacajinia quiaarohuari. Na tiuquishacari, na tiacajinia quiniaa pueya sequesuhuari: ");
INSERT INTO arlNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—¡Miji pueyanaa, nia niquiquii pueyano! ¡Nojuajaari cua sequeree puetunu cua miishanojuanaa! ¿Majate Cristoni, tariucuacaanu Pueyaso sequesano pocua na jiyarosocoriquianotej? ");
INSERT INTO arlNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pueyari cuno tiacajiniji Jesuucua nijioquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cuno maaji quiasacari na tiacajiniohua, jiyacaritij, canaari Jesu mianuutenu paniriquiaa juucuani. Canaari na sequeriquiaani: —¡Niishitiojonanaa, quia miaquere! ");
INSERT INTO arlNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesuuri saaja canaa sequeree: —Janiyacuaja miaquesanoracani, cuno miaquesanoori nia niishishoo. ");
INSERT INTO arlNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Canaa, Jesu saquiriojosano pueyani, canaari naa tama nequesoreetooreejaanijia: —Pa niyacari miaquetesaaquee jiyotucuaajaari. ");
INSERT INTO arlNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesuuri miriqui canaa sequeree: —Cua miishacari cua Jiyarona panishano, cunoori cua miaquesano, naajuhuaj, cua tucuatasacari na panishano. ");
INSERT INTO arlNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Niaari sequequiaa: “Cuaara shocojoorajaara cuatro raca. Pueyari jiyacari shusha coteenutaniya na nataacuaca carojotanu”. Janiyara, maja naatej. Seetanujuanaa nia sequeya cutaranijia, nia namijia nia riatare maninia nia niquiniuria. Nataacuacacuaja tari noshiquia, carojotasocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na carojotanaari na poonijionu sami niquitioshiya. Na carojotasanoori pueyaracaanu quiriquiano. Naacuajitij, cuhuariquia natoonaari jatiqui shuquiriniutianiya nataacuaca carojotanaata. ");
INSERT INTO arlNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Naaratej, seetanujuanaari nio tariucuacaanu sequesano. Naa sequeyari: “Tamonuuri saaja nareja nataja. Na nuhuaji, tamonuuri saniniuujia na carojotaja”. ");
INSERT INTO arlNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Janiyari saniniuujia nia jiyaramiquiquianuni nataacuaca nia carojotanura quenaaja nia poonijiyaquishoo cuhuariquiajinia. Cunoori tamasaca poonijiosano quiquiaari. Niaari juhuajaniya tamasaca poonijiosanojiniji carojotaquiaa shuquiriaatia. ");
INSERT INTO arlNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Queraatia pueya cuno Samaria tiacajinijinioori Jesuucua tiuuquiaari, nojori tojishacari naa cuno maaji sequesanotej: “Cua sequeree puetunu cua miishanojuanaani”. ");
INSERT INTO arlNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Naaratej, cuno pueya jaara Jesuucua tiuquiijioquiaari, nojoriiri na masuuquiaari tii na camueenujunura nojori tiacajinia quenaaja. Naaratej, canaari Jesuta tii camueequiaari caapiqui juucani. ");
INSERT INTO arlNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Socua queraatia cuno pueyajinijinioori Jesuucua tiuuquiaari, nojorijianaa jaara Jesu tojiquiaari Pueyaso rupaa pohuataano. ");
INSERT INTO arlNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Naaratej, nojoriiri cuno maaji sequeturee: —Quiarijiani, majaari canaa tiuuniu Jesuucua, saaja canaa quia pohuatanuucua nojuajiniji. Quiarijia cutara, canaacuajaari tama canaa numaatajaaja tojirii na pohuatasanoni. Naaratej, canaari quiarijia niishiyani, Jesuuri seetanujuanaa Pueyaso jiyanootiriquiano pajaniya, puetunu mijiria quiniaa pueyajanaanio. ");
INSERT INTO arlNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Caapiqui juuca Jesu camueetanu nuhuaji canaa, Samaria pueya tiacajinia, nojuajaari cuniquiji canaa na pueya jiyataaree Galilea jiyajiniara. ");
INSERT INTO arlNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesuuri tarijia sequequiaari: “Nio tariucuacaanu sequesanoori seetanujuanaa sequesano. Naa sequeyari: ‘Pueyaso sequenu panishano caminiujiuniaari maja tojishano quijia tama na jiyajiniajaaja’”. ");
INSERT INTO arlNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Naajaa, Jesu jaara canaa tiuquitiaseequiaari jiyacari Galilea jiyajinia, cuniquijinio pueyari maninia na tiuquitiquiaari saaja. Nojoriiri naa maninia na tiuquitiquiaari tari nojori niquiniuucua Jesu miishano na cumaacata Jerusalén tiacajinia, Pascuara nojori queranacusacari tii. ");
INSERT INTO arlNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Galilea jiyajinia canaa quishacari, Jesuuri canaa jiyataaree Caná tiacajinia, tee na jataniquiaari mohuaca vinoracuajani. Jiyacaritij, Capernaum tiacajinia quiquiaariiri tamonu pueyano, Galilea jiya jiyaniijia jiyatesano camarnura. Cuno pueyano niyanuuri jiyanohua cusosu matariquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Cuno camarnu jaara niishiquiaari Jesu tari tiuquiriohua Judea jiyajiniji, nojuajaari jiyacari niquiaari Capernaum tiacajiniji Jesuucua, Caná tiacajinia. Na tiuquishacari Jesuucua, na sequeseeri: —¡Jiyaniijianaa, cucua quia taraajere! ¡Cua niyanu quia naataniquii, quera cusoyano! ");
INSERT INTO arlNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesuuri na riucuaree: —Niaa jaara cua cumaacata cua miishano niquiyaquiri, niaari cucua tiuyaquiquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Cuno camarnuuri saaja Jesu sequeree: —¡Jiyaniijianaa, mijiijiaj, jati pa quiaare cua tiajinia, quiyanu cusoyaquishacarijia! ");
INSERT INTO arlNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesuuri na sequeree: —Quia quiaarohua. Quia niyanucuaja tari naatarohua. Cuno camarnuuri Jesu sequesanoocua tiuurii. Quiaarohuari. ");
INSERT INTO arlNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jiyacari na tiajinia, na seyari niquiquiaari camarnu niyanuuri seetanujuanaa maninia naatarohua. Naaratej, nojoriiri quiojoquiaari na camarnu numootenuucua. Nojori quiojosacari, na camarnu naacuturee saaja nuu cajiniocuaari. Nojoriiri na sequeree: —¡Quia niyanu tari naatarohua! ");
INSERT INTO arlNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nojori camarnuuri nojori nequesotaree: —¿Taacari na cusonu tajiyatemohuacuaani? Nojoriiri na riucuaree: —Naseeca nocuaji tajimiohuacuaa shusha pananu mueecosacari nio niniriquiacuaani. ");
INSERT INTO arlNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Cusosu queeri niishiquii, Jesucuajaari jiyacari na sequeriquiacuaa: “Quia niyanu tari naatarohua”. Naaratej, camarnuuri necocuataja Jesuucua tiuurii, puetunu necohuatajanaanio. ");
INSERT INTO arlNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judea jiyajiniji Jesu tiuquishacariuhuaj, naa na naatanishacari cuno cusosutej, cunota tari caapiqui quiquiaariiri na cumaacata na miishano Galilea jiyajinia. ");
INSERT INTO arlNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tamacariuhua, socua canaa Judiocuaca queranacusacari quiquiaari Jerusalén tiacajinia. Naaratej, canaari Jesuta nocua quiojoquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén tiacaari puetunujuanaa puereetuuca sohuacajiniacuma quiya. Tohuateyacaari quiya tiuquitiajara. Tamonu tohuateya sesa quiquiaari “Borregohua tiuquitiaja”. Na shuriucua quiyari cuari. Canaa Judiocuaca rupaajiniani, cuno cuariiri sesojosaaquiaari “Betzata”. Cinco suhuorotucuaari quijia cuno cuari shuriuquioco. ");
INSERT INTO arlNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Queraatia cusosuhuari tii matacojua cuno cuari shuriuquioco. Cuno cusosuhuari quiquiaari cariyojuarujuri, shipiiniquiujiuniaa, cumatacuruhuana cusosuhuanio. Nojoriiri mohuaca sashijia cuaara queyaquetesaaria. ");
INSERT INTO arlNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Pueyaso seruuri noojiaqueya rosequiaari mohuaca na queyaquetenura. Cuari queyaquesacari, cante coteenujuanaa rosequiaari tiini, nojuajaari naataquiaariuhua na cusonujiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tamonu cusosuuri tii narta cusosuhua tajinia matariquiaajuhuaj. Tari na shoconujuquiaariiri treinta y ocho marijia, pueyaracaanu na matasacari. ");
INSERT INTO arlNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesuuri na niquiquiaari mataano. Noojiajinia niishiriijiaariuhuaj cuno pueyano tari shocotejoquiaari queraatia marijia, naa pueyaracaanu na matasacari. Nocuaji Jesuuri na sequeree: —¿Quiaate naatanu paniya? ");
INSERT INTO arlNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Cusosuuri na riucuaree: —¿Cantucua cua naacure cuarijinia cua rosenurani, mohuaca jaara queyaquetesaarecuaa? Janiya jaara rosenu paniquiaa juucuani, cuarta cusosuuri saaja cua shocotaquiaani. ");
INSERT INTO arlNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesuuri na sequeree: —¡Quia sanere! Quia matu quia pataarohua. ");
INSERT INTO arlNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jiyacaritij, cusosuuri ritia jeequequee. Na matu pataarohuari. Cuno juucaari Sábado quiriquiaa, canaa Judiocuaca samaatenu juuca Pueyaso niquiara. ");
INSERT INTO arlNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Canaa Judiocuaca camarucua jaara cusosu niquiquiaari na matu pataano, na juaatiuriiri. Naa na sequetureeri: —¿Majateeri quia niishiniu, quiarijiaari Sábado? ¡Maja quia matu quia patanujuaj! ");
INSERT INTO arlNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Cusosu naatanohuari nojori riucuaree: —Cua naataniniacuaja cua sequereeno: “Quia matu quia pataarohua”. Janiyari cunora na pataani. ");
INSERT INTO arlNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Narta Judiocuaca camarucuaari na nequesotaree: —¿Cantejaara naa quia sequereeni? ");
INSERT INTO arlNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nojori riucuareeri: —Johuaj. Maja cua niishiniu canaquitijia cua naataniriitij. Jesu naatanishacari cuno pueyano, queraatia pueyari namitia tii quiriquiaa. Naacuajitij, Jesuuri ritia tajiniocuareequiaari pueya tajinia, na naatanishano pueyanoocuaji. ");
INSERT INTO arlNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Na nuhuaji, Jesuuri na riuriataquiaari cuno juucaja Pueyaso Secojojua tiajinia. Jiyacari na sequereeri: —Quiaacuajaari tari naatanishaarohua. Quiarijia cutara tama quia cuaqueyajaaja quia cojuare maja sesa quia miiniuhuara socua, quiaa mariqui socua taraatia miiriiri. ");
INSERT INTO arlNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Naacuajitij, cuno pueyanoori Jesu niishirii. Cunora, canaa Judiocuaca camarucuaacua quiaareeri. Nojori sequeseeri: —Jesuqui cunocuaja cua naataniriini. ");
INSERT INTO arlNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Naa Jesu miiniuucua samaatenu juucatej, narta Judiocuaca camarucuaari na quiatunu panijia juucua. ");
INSERT INTO arlNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesuuri saaja nojori sequeree: —Cua Queeri pueyaracaanu poonijiya. Janiyari cunora poonijiyajaacuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Naa Jesu sequesacari nojoritij, narta Judiocuaca camarucuaari jiyanohua na monu paniriquiaa. Nojoriiri maja na monu paniniu quiriquiaa saaja samaatenu juuca na poonijionuucua. Socua jiyanohua na motunu paniriquiaari Jesu jiyatenuucua tama na cuaqueyajaaja juhua Pueyaso, Pueyaso na jiyaniquishacari na Queta. ");
INSERT INTO arlNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nocuaji Jesuuri narta Judiocuaca camarucua sequeree: —Seetanujuanaa nia sequeyanijia, Pueyaso Niyanu cua quishacari, maja cua naata casaa miiniu tamajaaja. Janiyari saaja miiquiaani taa cua Que cua niquiquiaa miyanocuaani. Casaa cua Que miiquiaacuaani, janiyari naa miiquiaajaacuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Cua Queeri cua panijia. Cunora, nojuajaari puetunu na miishanojuanaa cua niishitiojoquiaa. Naajuhuaj, cua niishitiojonutaniyari socua jiyajeneta casaa tariucua cua miishanojinijicuaa. Niaari nocuaji shiriiquitiuniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Cua Queeri macunucua samiitianijioquiaa, pueyaracaanu rishijia nojori quiniuria. Naajuhuaj, janiyari pueya samiitianijioquiaani, cana cua samiitianiniu paniyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Cua Queeri maja na nequesoreenu quiniutianiya pueya. Nojuacuajaari tari cua niquitiocanu na cumaaca, puetunu pueyajanaa cua nequesoreenura. ");
INSERT INTO arlNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nojuajaari naa miiquianu puetunu pueyajanaa quiniuria cua tojitiajaca, naatej, taa cua Que na tojitiatuquiaacuaani. Cante cua ruuretajani, cunoori cua Que ruuretajajuhuaj, nooj, cante mijiria cua jiyaroquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Seetanujuanaa nia sequeyanijia, cante cua sequesano tojijiani, mariyata cante cua Jiyaronaacua tiuyajaaniuhuaj, nojuajaari pueyaracaanu Pueyasota rishiriquiano cutara. Nojuajaari maja na saniitiosaanu quiniutianiya. Nojuacuajaari tari samiitianishaarohua juhua macu na quiniujiniji Pueyasooju na quishacari. ");
INSERT INTO arlNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Seetanujuanaa nia sequeyanijia, quera quiniutianiyari juhua macunucua quijiaca samiitiacosacari. Seetanujuanaa quiarijiaari, juhua macunucua quijiacaari cua rupaa tojitianutaniya. Cua rupaa tojitiajacaari samiitiaconutaniya, pueyaracaanu rishijiaca nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Cua Queeri quijiajuhuanajaj. Majaari na naata shaajenu. Nojuajaari naa quijiara cua jiyatequiaarijiuhuaj, juhua nojuarajuhuaj. Naacuajitij, cua naata pueya jiyatenu naa quijiarajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pueyanora cua quiniuucua, na cumaaca cua niquitioreeri cuarta pueya cua nequesoreenura, nojori cua saniitionurajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Cua tojitiare. Majaari nio sequesanoocuaji nia shiriiquiniu. Tamacari, puetunu macunucuajanaari cua rupaa tojitiuniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Macunucua tojitiushacari cua rupaa, nojoriiri samiitiaconutaniya, na jamacajiniji nojori tohuareetanura. Cante maninia miijiaca quiquiaarini, samiitiaconutaniuhuari pueyaracaanu shuquiriaatia quijiaca nojori quiniuria Pueyasota. Saniniuujia, cante sesa miijiaca quiquiaarini, puetunu nojorijianaari quejoosaanutaniya pueyaracaanu saniitiosocoriquiano. ");
INSERT INTO arlNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Pueyaso Niyanu cua quishacari, naajaa, majaari cua miiniu tama cua panishanojuaaja. Janiyari sesa miijiaca juaaquiaacuajani, saaja cua Que niishitishacari janiya, nojori miishanoori sesa. Tama cua panishanojuaaja miyashijia cua quiniuucua, janiyari namitiajanaa nojori juaaquiaani. Janiyari pueyaracaanu miiquiaa saaja cua Jiyarona panishanoni. ");
INSERT INTO arlNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Pueyano jaara tama nojuajinijijiaaja pohuataa narta pueyano, na pohuatasanoocua maja tiuushano. Naaratej, janiya jaara tama janiyajiniji pohuatariquia nia niquiarani, tama cua pohuatasanojuaaja maara najuhuana quiriquiaj. ");
INSERT INTO arlNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Naajaa, quiarijia cutara nia naata niishiniu cua pohuatasanoori seetanujuanaa. Tamonucuajaari janiyajiniji pohuataa seetanujuanaa. Nojuajaari cua Que. Cunora, niishiyanijia na pohuatasano janiyajinijiiri maja najuhuanaj. ");
INSERT INTO arlNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","’Niaari nia pueya jiyarocanu Tiuquinijiona Juancua, nojori nequesotanura janiyajiniji. Nojuajaari saaja seetanujuanaa nia pohuatacanu janiyajiniji. Majaari na seetanu quiquianu janiyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nojuaja jaara seetacanu janiyajiniji niajaniya, quiria, naajaa. Janiyacuajaari niishiyani seetanujuanaari cua pohuatasano niajaniya tama janiyajinijijiaaja. Tiuquinijiona Juanri seetanujuanaa pohuatacanu janiyajiniji niajaniya. Niaa cuaara na pohuatasanoocua tiuuria, Pueyaso jiyanooniuria niajaniya. Janiyari saaja cunora nia pohuataa Tiuquinijiona Juanjinijini. ");
INSERT INTO arlNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nojuajaari juhua samaritiu noshitishano nia tajinia na quishacari. Niaari rupaquijia na timitiacanu, juhua na cuhuatasacari niajaniya. Niaari najuhuana tojiquianu na pohuatasano. ");
INSERT INTO arlNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tiuquinijiona Juan pohuatasano janiyajinijiiri seetanujuanaa. Niaa jaara na pohuatasanoocua tiuuniu paniyashijiaca quiyajaa, naajaa. Cua cumaacata cua miishacari, cunora seetanujuanaa nia niishiri, cua Que Pueyasoori cua jiyaroquiaari. Nojuacuajaari cua sequequiaari naa cua miiniuriatej. ");
INSERT INTO arlNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Cua Quejanaari cua jiyaroquiaari. Nojuajaari janiyajiniji niishitioquiaari pueya. Naajaa, majaari quenaaja nia tojiniu quiquiaari na pocuanu. Nojuajaari nia niquishoojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Majaari quenaaja na rupaa quiniu nioojiajinia, nia tiuyaquishacari na Jiyarosanoocua. ");
INSERT INTO arlNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Niaari suraatia serojoquiaa tariucuacaanu naajiosano Pueyaso Rupaa. Niaari jiyaniya niaa jaara Pueyaso Rupaa niishijiaca quiri, niaari naa pueyaracaanu quijiara quiniutianiya. Seetanujuanaa majaari naatej. Cuno Naajioneejinia, tiiri janiyajiniji naajiotasano quiyacuaja. ");
INSERT INTO arlNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Niaari saaja cucua niniu paniyaquiquiaa cua jiyatenura niajaniya pueyaracaanu quijiacara cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Maninia cua miishanoori maja pueya sequenura janiya: “Quiaari maninia pueyano”. Janiyari saaja cua Que shuquiritiquiaa cutarani. ");
INSERT INTO arlNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Janiyari seetanujuanaa nia niishiyani. Niaari Pueyaso shuquiritiaashijiaca, nia paniyaquishacari nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Cua Quecuajaari cua jiyaroquiaari cua niishitiojonura niajaniya nojuajiniji. Quiarijiani, majaari nia tojiniu paniniu janiya. Saniniuujia, tamonu jaara tama na cuaqueyajaaja jiyateya juhua Pueyaso Jiyarosanora na quiniuria, niaa maara cuno tojiri cutara, nojuaja jaara niaacua nimia na niishitiojonura niajaniya tama na niishishanojuaaja. ");
INSERT INTO arlNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Majaari nia naata cua pohuatasanoocua tiuuniu, niaa jaara saaja niarta pueya shuquiritiasano quiniu paniquiaa, maja Pueyaso shuquiritiasano. ");
INSERT INTO arlNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Majaari nia jiyaniniu janiya niaacuara tonujunutaniya cua Queni. Tama Moiséscuajaari niaacuara tonujunutaniya, cua tojitiaashijiaca nia quiniuucua. Niaari jiyaniya niaa Pueyaso muerasu, juhua Moisés tojijiaca nia quishacari. ¿Niaateeri seetanujuanaa Moisés tojijiaca? ¡Maja! ");
INSERT INTO arlNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nojuacuajaari janiyajiniji naajiotaquiaari. Naacuajitij, niaa jaara seetanujuanaa na naajiotasanoocua tiuuriquia, niaa maara cucua tiuurijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nocuaji, niaa jaara Moisés naajiotasanoocua tiuyaquiquiaa, ¿niaatucua taa tiuuri quiarijia cua pohuatasanoocuani? ");
INSERT INTO arlNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Na nuhuaji, canaari Jesuta niuutiaquiaari Galilea caminia taquijiriani. Galilea caminia sesa quiquiaarijiuhua Tiberias caminia. ");
INSERT INTO arlNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jiyanohua queraatia pueyari Jesu niquiquiaari tari, cusosuhua na naatanijiosacari. Naaratej, nojoriiri Jesu neteyotariquiaa caminia shuriuquioco. ");
INSERT INTO arlNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Canaa shiitiasacari caminia taquijiria, Jesuuri canaa tacatamaa tuhuananuucua. Tii cajitiasee canaari. ");
INSERT INTO arlNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jiyacaritij, quera Pascuara queranacusacariiri quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesu niquishacari jiyanohua queraatia pueya nocua niyano, canaa cojinia Felipe sequereeri: —¿Tee pa masenutaniya queraatia pan nio pueyaraarini? ");
INSERT INTO arlNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Naa Felipe nequesotareeri nareja na saniniuria. Jesuuri tari niishiriquiaa taa nojuajanaa mianuutenutaniya cuno pueyani. ");
INSERT INTO arlNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipeeri na riucuaree: —¡Paa jaara cumaneeca jiitiare doscientos juuca pa poonijiosanojiniji pan pa masetajarani, cuno maara najuhuana secaja quiri puetunu nojoririajanaa! ");
INSERT INTO arlNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jiyacaritij, canaa cojinia Andrésri Jesuucua nimiaa. Andrésri Simón Pedro tarajanu. Nojuajaari Jesu saquiriojosano pueyanojuhuaj. Jesu sequeseeri: ");
INSERT INTO arlNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Jiyaniijianaa, caya samijia niya cinco pan jiitiaa cebada cashojuajiniji shipinishano, caapiqui sapitiaajanio. Naajaa, cunoori najuhuana puetunu cuno pueyarajanaa. ");
INSERT INTO arlNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesuuri saaja canaa na saquiriojosano pueya sequeree: —Puetunu pueyajanaa nia sequere cuaara cajitiuuria. Cuniqui, canaa tii quiriquiaani, shanohua jiyasocuaari quiriquiaa, maninia cajitiujia. Naaratej, pueyari cajitiurii. Puetunu cuno pueya maanujinijiniojuanaani, saaja canuuri quiquiaari cinco mil pueya. ");
INSERT INTO arlNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jiyacaritij, Jesuuri cuno pan pataree. Pueyaso secojoree nocuaraari. Na nuhuaji, canaa na serotaniriiri. Canaari cajitiuyano pueya puetunu na panishanojuanaa niquitiojoreeni nojori miaquenuusocoriquiano. Jesuuri naa miirii sapitiaajajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Puetunu pueyajanaa jaara tooquioquiaari, Jesuuri canaa na saquiriojosano pueya sequereeni: —Puetunu miaquesano raquiquiajanaa nia reraterohua, maja najuhuana na niitiasaanura. ");
INSERT INTO arlNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Canaari cuno cinco panjiniji pueya miaquesano raacua reratereeni. Canaa reratesacari, canaari doce canaasatu mishinijioreeni. ");
INSERT INTO arlNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pueya niquishacari naa Jesu miishano na cumaacatatej, nojoriiri sequeturiquiaa: —¡Nio pueyanoqui seetanujuanaa Pueyaso sequenu panishano caminiujiunia, nooj, tariucuacaanu sequesaaquiaari pocua niriquianotej! ");
INSERT INTO arlNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesuuri niishirii cuno pueyari na quianu paniriquiaa, nojori jiyatenura nojuaja puetunu Israel pueyajanaa jiyaniijia na quiniuria. Nocuaji, Jesuuri tamajaaja tacaquee socua jiyaconaja tuhuananuucua. ");
INSERT INTO arlNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tariucua pananu tiuquishacari, canaa, Jesu saquiriojosano pueyani, canaari rosetaarohua caminiajiniarani. ");
INSERT INTO arlNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Canaari botejinia tacataseeni, cuniquiji Capernaum tiacajiniara canaa niuutianura caminia taquijiria. Tariucua ninishiquiiri quiriquiaa. Majaari Jesu tiuquiniu quiriquiohua juhuanojuaja canaacua. ");
INSERT INTO arlNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tari canaa niuutiasacari, paratuuri jiyanohua piyarojoriquiaa. Caminiaari cunora jiyanohua cajiniuucuariquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Canaari tari caminia jiuujiajinia quiriquiaani, seis kilómetroruhua canaa ruparetasaquiji. ¡Canaari jiyacari casaa niquirii canaacua catecanoyanoni! ¡Mohuaca caco canujuriquiaari! ¡Canaari nocuaji shiriiquitiurii jiyanohuani! ");
INSERT INTO arlNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jiyacaritij Jesuuri canaa sequereeni: —¡Maja pueretunu! ¡Janiyacuajanijia! ");
INSERT INTO arlNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Na rupaa canaa tojishacari, canaari shuquiriaatia na tacanitiurii botejiniani. Canashiyaquiji boteeri ritia shiitiasee terara canaa quiariquiaacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jaara juhuaquequiaari, Jesu mianuutesano pueyari na pajenuunu coteequiaari tee canaa quiriquiaa caminia taquijiriacuajani. Nojoricuajaari tenacari niquiquiaari saaja niquiriyatu boteeri shiitiariquiaa. Saaja canaa, Jesu saquiriojosano pueyani, canaari cuno botejinia quiaquiaariuhua nojori niquiarani. Majaari Jesu quianu quiriquiaa cutara canaata. ");
INSERT INTO arlNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Jiyacaritij, Tiberias tiacajiniji boteeri tiuquiijioquiaari catecaja nojorijiniji, tee Jesu mianuutequiaari nojoricuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Cuno pojori niishishacari maja Jesu quiniu quiriquiaa tari tii, canaa na saquiriojosano pueyajuhuaj, nojoriiri cuno boteyajinia tacataquiaari. Nojoriiri Capernaum tiacajinia nijioquiaari cuno boteyajinia, tii nojori pajenura Jesu. ");
INSERT INTO arlNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cuno pojori tiuquiijiosacari caminia taquijiria, Jesu riuriatatuseeri. Na nequesotatureeri: —Niishitiojonanaa, ¿taacari quia niyarohuacuaarini? ");
INSERT INTO arlNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesuuri saaja nojori sequeree: —Janiyari seetanujuanaa nia sequeyani, majaari nia pajenu janiya nia niquiniuucua cua cumaacata cua miishano. Niaari cua pajenuya saaja cua mianuutenuucua niajaniya, taa nia tooquiorucuaacuajani, cua mianuutesacari niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Maja saaja miaquesanoocua nia tacaaniu, nia cuaqueya nia cumaquitiajara. Cunoori maja na jiyatenu quiniutianiya niajaniya pueyaracaanu rishijiara. Saaja nia tacaari cutara nioojia samiitianijia miaquesanoocua, pueyaracaanu rishijia nia quiniuria. Janiyacuajaari cuno nia niquitioriquianoni, pueyano cua quiniuucua. Cua Quecuajaari cunora cua jiyaroquiaari. Cunora, cua Queeri cua miitiquiaa cua miishano na cumaacata, nia niishiniuria janiyari na jiyarosanoni. ");
INSERT INTO arlNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Cuno pueyari Jesu nequesotaree: —¿Casaa canaa miiniutianiyani Pueyaso panishano canaa miiniuria, Pueyaso shuquiritiasano canaa quiniuriajuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesuuri nojori riucuaree: —Pueyaso Jiyarosanoocua nia tiuuri. Saaja naa nia miishacaritij, Pueyasoori nia shuquiritianutaniya. ");
INSERT INTO arlNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Cuno pueyari Jesu sequeturee: —Canaa niquiara quia cumaacata casaa quia miiricuarajaj, canaa niishiniuria quiaari seetanujuanaa Pueyaso Jiyarosano. ¿Casaa canaa quia niquitiniutianiya canaa tiuuniuria quiocuani? ");
INSERT INTO arlNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Canaa quia niquitiricuaraja quia cumaacata quia miishano, taa Moisés niquitiquiaari canaa supuetanaacuaani. Nojuajaari jiyocuacaanuji pan tiniquiaari pueyaracaanu nojoriria, cariiquia jiyajinia nojori rucuanejosacari. Naa naajiotasano quiyacuajaari tariucuacaanu Pueyaso Rupaajinia: “Nojuajaari nojori mianuutequiaari jiyocuacaanuji tinio pan”. Naacuajitij, canaari niishiyani Moiséscuajaari Pueyaso jiyarosano quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesuuri nojori riucuaree: —Seetanujuanaa nia sequeyanijia, cuno jiyocuacaanuji panni, cunoori maja Moisés tinishano quiquiaari. Majaari seetanujuanaa jiyocuacaanuji pan na quiniu quiquiaarijiuhuaj. Quiarijia cutara, cua Queeri niaacua jiyarorucuaa seetanujuanaa jiyocuacaanuji panjanaa cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Cuno, Pueyaso niquitiosano pan jiyocuacaanuji rosenoni, cunoori puetunu mijiria quiniaa pueyajanaa samiitianijiojua cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Naaratej, cuno pueyari Jesu sequeree: —¡Jiyaniijianaa, quiocua pueyaracaanu canaa niquitioriquia cuno pan! ");
INSERT INTO arlNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesuuri nojori sequeree: —Janiyacuajaari cuno panni, pueya samiitianijiojuani. Cante cucua niyani, majaari na miaajenu quiniutianiya socua. Cante cucua tiuuriijiaaniuhuaj, majaari na jiyamuenu quiniutianiyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Taa cua sequeree tari niajaniyacuajani, niaari juucua cua niquiya. Majaari quenaaja cucua nia tiuuniu. ");
INSERT INTO arlNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Naajaa, puetunu cua Que niquitiosanojuanaa janiyani, nojoriiri cucua niya. Cuno pojori, cante cucua nijiyani, majaari cua ruuretanu nojori. ");
INSERT INTO arlNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Majaari jiyocuacaanuji cua rosenu quiquiaari cua miiniuria tama cua miiniu panishanojuaaja. Mijiria niquiaarinijia saaja cua Que panishano cua miiniuria, cante cua jiyaroquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Majaari cua Jiyarona paniniu cua juurequetenura quenaaja niquiriyatujua na niquitiosanojiniji janiya. Nojuajaari paniya cutara, nojori cua samiitianijionura jiya puequesacari. ");
INSERT INTO arlNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Canapuete cucua tiuujiacani, nojori niishishacari janiya Pueyaso Niyanuni, cua Queeri puetunu cuno pojorijianaa paniya pueyaracaanu rishijiaca nojori quiniuria. Naacuajitij, janiyari nojori samiitianijionutaniya jiya puequesacarini. ");
INSERT INTO arlNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jesu sequenuucua, “Janiya jiyocuacaanuji roseno panni”, tii quiniaa narta Judiocuacaari cunora juaaquioree. ");
INSERT INTO arlNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Sequetureeri: —¿Majate nio pueyano Jesucuaja, José niyanutej? ¡Paacuajaari na queya niishiyani! ¿Casaara quiarijia na sequeyari: “Jiyocuacaanuji rosenonijia”? ");
INSERT INTO arlNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesuuri nojori sequeree: —¡Tariucuaja! ¡Maja nia juaaquionu! ");
INSERT INTO arlNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Pueyanoori maja na naata tiuuniu cucua tamajaaja, cua Que jaara noojiajinia poonijiyaquiri. Janiyari puetunu cucua tiuuniaajanaa samiitianijionutaniya jiya puequesacarini. ");
INSERT INTO arlNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tariucuacaanu pueyara Pueyaso sequesano caminiujiunia naajiotasanocuajaari naa sequeya: “Pueyasocuajaari puetunu nojorijianaa niishitiojonutaniya”. Naacuajitij, cante cua Que niishitiojosano tojijia seetanujuanaani, nojuajaari cucua tiuya. ");
INSERT INTO arlNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Cua Queeri maja pueya niquishano quenaaja. Saaja na niquinia cutaraari janiya cante Pueyasojiniji niquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Seetanujuanaa nia sequeyanijia, cante cucua tiuujiani, nojuajaari tari pueyaracaanu rishijiara jatanishaaree. ");
INSERT INTO arlNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Janiyacuajaari pueya samiitianijia panni. ");
INSERT INTO arlNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Cariiquia jiyajinia nia supuetanaa camarucuneejotasacari, nojoriiri cuno jiyocuacaanuji tinio pan miaquenuuquiaari juucua. Naajaa, saaja cusonuuquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Saniniuujia, cante quiarijia seetanujuanaa jiyocuacaanuji roseno pan miaqueyani, majaari Pueyaso shaajanu quiniutianiya nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Janiyacuajaari cuno samiitianijia panni, jiyocuacaanuji rosenoni. Cante nio panjiniji miaquejani, nojuajaari pueyaracaanu quijia quiniutianiya. Nio pan, janiya na niquitionutaniya puetunu mijiria quiniaa pueyacuarajanaani, cunoori tama cua cuaqueyajaaja. ");
INSERT INTO arlNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jiyacaritij, tii quiniaa narta Judiocuacaari naa sequetooree tamajaaja na juaaniutia: —¿Nio pueyanotucua taa miaquetere tama na cuaqueyajaaja pajaniyani? ");
INSERT INTO arlNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesuuri jiyacari nojori sequeree miriqui: —Seetanujuanaa nia sequeyanijia, niaa jaara miaqueyaquiri cua shu, niaa jaara ratuyaquiri cua nanacajuhuaj, majaari samiitianijiosano nia quiniu quiniutianiya, pueyaracaanu quijiaca nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Cante cua shu miaquereeni, cante cua nanaca ratureejaaniuhuaj, nojuajaari tari naatarohua shuquiriaatia na quiniuria pueyaracaanu. Jaara cusoyare, naajaa, janiyari na samiitianiniutianiuhua jiya puequesacarini. ");
INSERT INTO arlNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Cua shuuri seetanujuanaa miaquesano cutara. Naajuhuaj, cua nanacaari seetanujuanaa ratusano cutara. Cunoori maja juhua mijiria nia miaquesano. ");
INSERT INTO arlNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Cante cua shu miaquenani, cante cua nanaca ratunajaniuhuaj, nojuajaari coojia rupueja. Janiyari noojia rupuejajuhuaj, pueyaracaanu rupuetootesano canaa quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Cua Jiyarona cua Queeri seetanujuanaa quijia cutara. Cua Que rupueja cua quishacari, janiyari cunora shaajeyashijiani. Naaratej, cante cua miaquenani, nojuajaari pueyaracaanu quijia quiniutianiyajuhuaj, na rupuesacari janiya. ");
INSERT INTO arlNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Janiyari maja juhua nia supuetanaa miaquesano panni. Nia supuetanaari cuno pan miaquenuuquiaari najuhuanaj. Naajaa, saaja cusonuuquiaariiri. Janiyari seetanujuanaa jiyocuacaanuji roseno pan cutarani, nia miaquesocoriquiano. Cante cua miaquejani, jaara cusoyare, naajaa, samiitianutaniuhuari pueyaracaanu quijia na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesuuri puetunu niojuanaa pohuataquiaari pueya niquiara Pueyaso secojojua tiajinia Capernaum tiacajinia. ");
INSERT INTO arlNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Naa pueya tojishacari Jesu niishitiojosanotej, queraatia na nuhuajiniaa pueyari naa sequetooquiaari tamajaaja: —Cuno na sequesanoori jiyanohua jiyajeneta pa miiniuria puetunujuanaa. Maja pa naata. ¿Cantucua na tojirijaarajaaranijia? ");
INSERT INTO arlNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesuuri naa nojori sequesano niishirii noojiajinia. Nocuaji nojori sequereeri: —¿Niaateeri naa cua sequenuucua juaya? ");
INSERT INTO arlNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Niaatucua taa sequere socuani, niaa jaara cua niquiri tacaano jiyocuacaanuhua, teje cua niquiaaricuajani? ");
INSERT INTO arlNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Cua shu maja cumaacaraca pueya na samiitianiniuria. Saaja cua Sohuanu cutaraari pueya samiitianijia, pueyaracaanu rishijiaca nojori quiniuria. Niaa jaara cua sequesanoocua tiuuri, cunoori cumaacaraca cutara na samiitianiniuria niajaniya. ");
INSERT INTO arlNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Noojiaqueya niajaniyajinijinioori cucuaji taacanuyajaa. Jesuuri tarijia niishijia cante nocua tiuyashijiacani, mariyata cante na paraa na quiatenutaniyani. ");
INSERT INTO arlNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Naa sequeree socua cuno pojoriiri: —Janiyacuajaari cunora nia sequereeni: “Maja pueyano naata cucua tiuuniu, cua Que jaara noojiajinia poonijiyaquiri”. ");
INSERT INTO arlNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jiyacaritij, queraatia Jesu nuhuajiniaa pueyari na cartequiaari. Nojoriiri maja tari Jesuta na rucoojonu quijia. ");
INSERT INTO arlNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nocuaji, Jesuuri jiyacari canaa na saquiriojosano pueya nequesotaree: —¿Niajaniyariuhuaj, niaateeri cua cartenutaniyajaacuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedroori Jesu riucuaree: —¡Maja Jiyaniijiajanaa! ¿Canaatucua tamonu jiyaniijiaacua pacureni? Canaa quia pohuatasanocuajaari na naata canaa jataniniu pueyaracaanu rishijia canaa quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Canaacuajaari tari quiocua tiuuquianuni, canaa niishishacari quiaari Pueyaso Niyanu, saa maninia miijiaja. ");
INSERT INTO arlNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesuuri canaa sequeree: —Niaacuajaari tama cua saquiriojosano doce pueyajaaja. Saniniuujia, niquiriyatu niajaniyajinijinioori sesaaca. ");
INSERT INTO arlNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Naa Jesu sequesacaritij, Judasjiniji sequeriquiaari, Simón Iscariote niyanuni. Nojuajaari seetanujuanaa niquiriyatu canaajinijinio Jesu doce saquiriojosano pueyajinijinio quiquiaari. Naajaa, tama na Jiyaniijiajaaja tacartariquiano quiriquiaaquiiri. ");
INSERT INTO arlNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Na nuhuaji, Jesuuri Galilea jiyajinia rucuanejoriquiaa. Canaari na cojiriquiaani. Majaari na quiniu paniniu quiriquiaa Judea jiyajinia, tii quiniaa Judiocuaca monu panishacari nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jiyacaritij, quera socua canaa Judiocuaca queranacusacariiri quiquiaari Jerusalén tiacajinia. Cuno queranacusacariria pueyari ocho juuca shocotejoquiaari suhuorotucuajinia nojori quishacari. Naa miitiuquiaariiri puetunu marijiarajanaa canaa niishiriojonura, canaa supuetanaa Israel pueyari saaja suhuorotucuajinia quijiaca quiquiaari, pueyaracaanu nojori camarucuneejotasacari cariiquia jiyajinia nojori quishacari. ");
INSERT INTO arlNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jiyacaritij, tama Jesu tapueyocuacajaarijia naa Jesu sequeturee nojori macaatiniuria nojuaja: —¡Majaari niyaja quia jateenu! Quiocua queranacunuucua Judea jiyajinia quiaarejuhuaj. Quiocua tii miijiosee quia cumaacata, quia jiyopue niquiniuria puetunu quia miishanojuanaa. ");
INSERT INTO arlNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pueyano jaara puetunu pueyajanaa tojiniu panishano pueyano quiniu paniri, ¿maatucua casaara jiyasohuaja miijiore na cumaacatani? Naatej, taa niya quia miijioquiaa quia cumaacatacuaani, naa quia miijiosee puetunu pueya niquiarajanaa Jerusalén tiacajiniajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Majaari quenaaja tapueyocuaca tiuuniu quijia Jesuucua. Cunora naa na sequetureeri. ");
INSERT INTO arlNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesuuri saaja nojori riucuaree: —Juhuanojuaja maja cua quiasacari cua miiniuria taa nia sequeyacuajani. Niaa jaara quianu paniri, niama juhuajaniya quiaaretej. ");
INSERT INTO arlNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Niarta mijiria quijiaca pueyari maja na naata juaaniu niajaniya. Janiya cutaraari nojori niquiniu paniyaquishooni. Cua niquitiuniu paniyaquiquiaari, nojori cua niishitishacari nojori miishanoori sesa. ");
INSERT INTO arlNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nia quiojiyare queranacunuucua. Janiya cutaraari maja cua quianu quiniutianiya juhuanojuaja. Quiarijiani, puera juhuacarijiaari cua miiniuria taa nia sequeree janiyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Naa nojori na sequenu nuhuajitij, Jesuuri cuniquijia jiyojeree Galilea jiyajinia. ");
INSERT INTO arlNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Na tapueyocuaca jaara quiojoquiaaricuaa Jerusalén tiacajiniara tii queranacunuunura, Jesuuri jiyasohuaja quiaaree nojori nuhuajijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Queranacunuusacari, narta Judiocuaca camarucuaari Jesu pajenuuriquiaa. Nojoriiri naa sequeturiquiaa: —¿Tee cuno pueyano quiyarini? ");
INSERT INTO arlNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Puetunu pueyajanaari Jesujiniji sasacojotooriquiaa. Noojiaqueyari sequeriquiaa: —Jesuuri maninia pueyano. Tamasacaari saniniuujia sequeriquiaacujua: —¡Maja maninia pueyano! ¡Pueya sapojojua najuhuanaj! ");
INSERT INTO arlNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Puetunu pueyajanaari naa sasacojotooriquiaa jiyasohuaja, nojori pueresacari narta Judiocuaca camarucua. ");
INSERT INTO arlNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jiuujianaraca juuca jaara tari shocojoquiaari nojori queranacunuusacari, Jesuuri jiyacari shusha tiuquiquiaari Pueyaso Secojojua tiajinia. Tii coteeree pueya niishitiojonuuri. ");
INSERT INTO arlNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Canaa Judiocuaca camarucuaari jiuujiatequiaari nojori tojishacari Jesu niishitiojosano. Naa sequetureeri: —¡Cuno pueyanoori maja quenaaja na serojonu quiquiaari! ¿Taa na niishiya pueraarini? ");
INSERT INTO arlNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesuuri nojori sequeree: —Cua niishitiojosanoori maja tama cua niishishanojuaaja. Cunoori cua Jiyarona niishitishano janiya. ");
INSERT INTO arlNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Cante Pueyaso panishano miiniu paniyani, nojuaja cuaara miiria taa cua niishitiojiyacuaani. Naacuajitij, nojuajaari jiyacari niishiniutianiya, cua niishitiojosanocuajaari Pueyasojiniji seetanujuanaa, maja tama cua niishishanojuaaja. ");
INSERT INTO arlNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Cante tama na niishiriojosanojuaaja pohuatajani, nojuajaari saaja naa miiquiaa juhua tojishano pueyano na quiniuria. Jiyano pueyano cuaara tojiyaquishaaria. Saniniuujia, cante na jiyarona niishitiojosano pohuataa pueyani, pueya tojiniuria na jiyarona, cuno pueyano pohuatasano cutaraari seetanujuanaa. Cuno pueyanoori maja pueya sapojojua. ");
INSERT INTO arlNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Niaateeri seetanujuanaa supuetana Moisés Rootasano tojitiajaca? Majaruhua. Majaari quenaaja niquiriyatu niajaniyajinijinio na rootasano tojijia. ¿Casaara nia monu paniya janiyani? ¿Supuetana Moiséste naa nia niishitiojiya na naajioneejinia? ");
INSERT INTO arlNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nojoriiri Jesu riucuaturee na juaaniutia: —¡Quiaaqui samaruraca! ¿Cante quia monu paniyani? ¡Canaa quia sequeretoj! ");
INSERT INTO arlNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesuuri nojori sequeree: —Puetunu niajaniyajanaari shiriiquitiuquianu samaatenu juuca cua miishacari niquiriyatu casaaniyojua cua cumaacata. ");
INSERT INTO arlNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Supuetana Moiséscuajaari nia rootaquiaari nia mueya cararaatiuuquia co nia miatenura, ocho juuca jaara na shocojore na rasaanujiniji. Seetanujuanaa, nio niishishanoori maja tama Moisés niishishanojuaaja. Cunoori tariucuacaanu pa supuetanaa niishishano Moisés niyacarijia. Pueyari naa rootasaaquiaari naa nojori miiniuria necohua, seetanujuanaa Pueyaso saquiriojosano Israel pueya nojori quiniuriajuhuaj. Naaratej, jaara quiri samaatenu juuca, naajaa, niaari naa nia niquiohua cararaatiuuquia co miatejoquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Naa nia miishacari samaatenu juucatej Moisés Rootasano nia tojiniuria, ¿casaara nia juaya janiyani, cua naataniniuucua cusosu samaatenu juucani? Niaari saaja shiitianiyojua miatejiya, maninia nia niquiohua quiniuria Pueyaso niquiara. Janiya cutaraari puetunu cuno cusosu cuaqueyajanaa jeecacanuni. ");
INSERT INTO arlNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Naaratej, maja ritia pueya juaajia nia quiniu, nia niishiyaquishacari maninia. Jacaria niishiriojojua nia quiri, niaa mariqui najuhuana pueya juaariiri na miishano jaara sesa quiyaquiri. ");
INSERT INTO arlNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jiyacaritij, noojiaqueya Jerusalén tiacajinijinio pueyari tama sequetooreejaaja: —¿Majate nio pueyano pa camarucua pajesanocuaja na mosocoriquianotej? ");
INSERT INTO arlNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¿Taateni? Noocuajaruhua juhuajaniya pohuataa pueya niquiaratej. Majaari quenaaja pa camarucua tenujununoj. ¿Pa camarucuate jiyaniya soj, nojuaja seetanujuanaa Cristo, tariucuacaanu sequesano pocua jiyarosaariquianotej? ");
INSERT INTO arlNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Paacuajaari nio pueyano niishiyani, tejenote nojuajani. Saniniuujia, Cristojuanaa jaara tiuquiri, majaari quenaaja na niishishaanu quiniutianiya cutara tejenote nojuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesuuri jiyacari niishitiojoriquiaa Pueyaso Secojojuajinia. Naa na tojishacari pueya sequesanotej, naa na rupaa paaretareeri: —¿Naatee? ¿Niaateeri cua niishiya? ¿Niaateeri niishiyajuhuaj, tejenote janiyani? Naajaa, majaari cua niniu quiquiaari tama cua panishacarijiaaja. Janiyari jiyarosanoni. Cua Jiyaronaari seetanujuanaa quijiajuhuanajaj. Nojuajaari nia niishishoo. ");
INSERT INTO arlNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Janiyari na niishiya cutarani. Janiyacuajaari tiji ninioni. Nojuajaari cua jiyaroquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nojoriiri jiyacari Jesu quiatunu panirii. Naajaa, majaari quenaaja tamonu naata quiriquiaa na quianura. Majaari na naata quianu quishaaquiaari, juhuanojuaja na monu juuca quiyaquishacarijia. ");
INSERT INTO arlNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Saniniuujia, queraatia cuniqui quiniaa pueyari Jesuucua tiuuquiaari. Nocua tiuuniaari naa sequetuquiaari: —¿Cristojuanaa jaara tiuquiri, nojuajatucua socua jiyajeneta casaa miiri na cumaacata nio pueyano miishanojiniji? ");
INSERT INTO arlNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseocuacaari cuno pueya tojiquiaari naa nojori maniniuhuaqueetaano Jesu. Naaratej, cuno Fariseocuaca, pueyacuara secojonaa camarucuanio, puetunu nojorijianaari Jesuucuara roojotooquiaari. Na nuhuaji, nojoriiri Pueyaso Secojojua tia cojuanaa pueya jiyaramiquiquiaari Pueyaso Secojojua tiajiniara, tii nojori quianura Jesu. ");
INSERT INTO arlNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesuuri jiyacari nojori sequeree: —Janiyari saaja rupaquijia niaata quiniutianiyani. Na nuhuaji, janiyari cua Jiyaronaacua riujiuuniutianiuhuani. ");
INSERT INTO arlNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Niaari cua pajenuunutaniya najuhuanaj. Majaari nia riuriatanu quiniutianiya janiya. Majaari nia naata quianu quiniutianiya tee cua quiniutianiyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nocuaji, cuno Judiocuacaari tama sequetooreejaaja: —¿Tee na quianutaniyajanojoni naa pocuaaniquitij, na riuriataaquishaanurajuhuaj? ¿Parta Judiocuacaacua quianutaniya soj, noo pojoriicua Griegohua tajinia niyaquejoquiaaritij? ¿Tii niishitiojonutaniya cuno taucuaca soj? ");
INSERT INTO arlNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Casaa na sequenu paniya pajaniyarini na sequesacari: “Niaari cua pajenutaniya najuhuanaj. Majaari nia riuriatanu quiniutianiya janiya”, na sequesacarijiuhuaj: “Maja nia naata quianu quiniutianiya tee cua quiniutianiyacuaani”? ");
INSERT INTO arlNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Siete juuca jaara tari shocojoquiaari, queranacunuunu puequesacari juucajanaari juhuaquequiaari. Cuno juucaari quiquiaari socua Pueyaso timitiasaanu juuca. Jiyacaritij, Jesuuri nujuaquiaari pueya niquiara. Jiyanohua na rupaa paaretareeri. Naa sequereeri: —¡Cante jiyamueyani, nojuaja cuaara niiria cucua, na ratunura janiyajiniji! ");
INSERT INTO arlNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Cucua na tiuushacari, nera quiniutianiyari taa na naajiotasaaquiaari tariucuacaanu Pueyaso Rupaajiniacuajani. Naa sequeyari: “Cante cucua tiuyani, pueyano samiitianijiojua mohuacaari noojiajiniji jaatenutaniya”. ");
INSERT INTO arlNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Naa Jesu sequesacaritij, nojuajaari Pueyaso Sohuanujiniji pohuatariquiaa miriqui. Jiyacaritij, Pueyaso Sohuanuuri juhuanojuaja maja na quiniu quiriquiaa mijiria, Jesu tacaaquishacarijia Jiyaniijiajanaa na quiniuria. Naaratej, tii quiniaa pueya sequeriquiaari, cante quiarijia nocua tiuyani, nojoriiri Pueyaso Sohuanu masenutaniya na nuhuaji, nojuaja jaara na jiyarosee jiyocuacaanuji. ");
INSERT INTO arlNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesu jaara pohuatanu puecaquiaari, tii quiniaa pueyari tama pocoojoriquiaajaaja. Noojiaqueya nojorijinijinioori sequeree: —¡Nio pueyanoqui seetanujuanaa Pueyaso sequenu panishano caminiujiunia, nooj, tarijia sequesaaquiaari pocua niriquianotej! ");
INSERT INTO arlNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tamasacaari saniniuujia naa sequeriquiaacujua: —¡Nojuacuajaari Cristo, Pueyaso Jiyarosano pocua! Tamasacaari saaja nojori riucuaree: —¿Cristoteeri Galilea jiyajiniji supuenutaniya? ¡Maja! ");
INSERT INTO arlNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tariucuacaanu Pueyaso Rupaajinia naajiotasanojiniji, paari niishiyani, Cristoori pa supuetanaa jiyaniijia David niquiohuajiniji supuenutaniya. Belén tiacajinia rasaanutaniyari, supuetana David tiacajinia. ");
INSERT INTO arlNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Naacuajitij, puetunu pueyajanaari Jesuucua juayonuutaquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tamasacaari saniniuujia Jesu quianu paniriquiaa juucua. Naajaa, majaari na quiatunu quirii. ");
INSERT INTO arlNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pueyaso Secojojua tia cojuanaa pueyari Jesu tojitiariquiaa juhuajaniya. Na nuhuaji, socua quiojiyarohuari na jiyaramiquiniaa pueyacua. Nojori jiyaramiquiniaa pueyari quiquiaari Fariseocuaca, pueyacuara secojonaa camarucuanio. Nojori jiyaramiquiniaari nojori sequeree: —¿Casaara Jesu nia jaatucuyaquimiohuani? ");
INSERT INTO arlNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nojori jiyaramiquishano pueyari saaja nojori riucuaree: —¡Majaari quenaaja tamonu pueyano pocuanu juhua cuno pueyanojua, seetanu rupaajanaa pohuataja cutara! ");
INSERT INTO arlNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseocuacaari cunora nojori juaarii: —¿Niaateeri niaacua na shanacuree na sapojonura niajaniyajuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Tamonu pa camarucuajinijiniote nocua tiuurii, canaa Fariseocuacajinijiniojuhuaj? ¡Maja! ");
INSERT INTO arlNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Cuno pojori Jesuucua tiuujiacani, nojoriiri Moisés Rootasano niishiyashijiaca! ¡Nojoriiri sesoriquia seque! ");
INSERT INTO arlNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemoori narta Fariseocuacata tii quiriquiaa. Nojuajaari noo Nicodemo quiriquiaa Jesuucua niquiaari niucuatej. Nojuajaari narta Fariseocuaca sequeree: ");
INSERT INTO arlNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Pueyanaa, supuetana Moiséscuajaari pa rootaquiaari maja najuhuana pa sesacanura pueyano, paa jaara coteenu na nequesoreyaquirini casaa na miiriini. ");
INSERT INTO arlNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Narta Fariseocuacaari Nicodemo juaarii saaja: —¿Quiaateeri narta Galilea jiyajinijinio pueyanojuhuaj? ¡Jacaria quia pajere tariucuacaanu Pueyaso Rupaajinia! ¡Quiocua jiyacari niishiri majaari quenaaja niquiriyatu Pueyaso sequesano caminiujiunia pueyano supuenu quiniutianiya Galilea jiyajinia! ");
INSERT INTO arlNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Na nuhuaji, puetunu cuno pojorijianaari na tiajinia quiojiyarohua. ");
INSERT INTO arlNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesuuri saniniuujia Olivo cuhuariquiajinia quiaaree. ");
INSERT INTO arlNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jesuuri tariquiicuaji tiuquiriohua Pueyaso Secojojua tiajinia. Canaari nata quiriquiaajuhuaj. Pueyari nocua rerejoquiaari. Nojuajaari cajirii pueya na niishitiojonura juucua. ");
INSERT INTO arlNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Moisés Rootasanojiniji niishitiojonaa, mariyata Fariseocuacanio, cuno pojoriiri jiyacari maaji jaatucumaa Jesuucua. Cuno maajiiri riuriatasaaquiaari numuetucushiyano. Nojoriiri cuno maaji nujuateree pueya tacoji. ");
INSERT INTO arlNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jiyacari Jesu sequetureeri: —Niishitiojonanaa, nio maajiiri quiasaaree numuetucushiyano. ");
INSERT INTO arlNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés Rootasanojiniji paari niishiyani, jiyano maaji cuaara mosaaria saitia jacusano. ¿Quiajaniyarijiataj, taa quia sequeyanijia? ");
INSERT INTO arlNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Judiocuaca camarucuaari naa Jesu nequesotaree najuhuanaj, nojori tojiniuria casaa na sequenutaniyani. Jesu jaara nojori sequere maja nojori miiniuria Moisés Rootasano, nojori maara nocuara saquiriojotare nojori jiyaniijianucua. Jesu cutaraari maja quenaaja nojori na riucuanu quirii. Nojuajaari saaja jojoree, jiyajinia na naajionura na juaashiquiata. ");
INSERT INTO arlNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pueyaracaanu nojori nequesoreesacari nojuaja, Jesuuri socua sanerohua. Nojori sequereeri: —Teyano niajaniyajinijiniote sesa miyashijiani, nojuaja cuaara na coteetaara janu. ");
INSERT INTO arlNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jesuuri jojorohuacuhua socua na naajionura jiyacua. ");
INSERT INTO arlNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Cuno pojori tojishacari naa Jesu sequesanotej, puetunujuanaari sanaa quiojorohua. Juhuacatecara quiojonu coteequiaariiri socua saaquiapue, na nuhuaji, socua naatujoori nojorijiniji. Nojoriiri naa quiojoquiaariuhua puetunujuanaa. Saaja Jesuuri jateequee cuno maajitia. ");
INSERT INTO arlNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jiyacaritij, Jesuuri sanerohua. Maaji sequereeri: —¿Teete quiocuara saquiriojotanaani? ¿Majate quenaaja tamonu cureenu quirii na jacunura quiajaniya saitia? ");
INSERT INTO arlNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Maajiiri Jesu riucuaree: —Shaaqui puetunujuanaa, Jiyaniijianaa. Jesuuri maaji sequeree: —Janiyari quia jiyanoya cutarani. Juhuajaniya quia quiaarohua. Majaari sesa quia miiniu socua. ");
INSERT INTO arlNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nojori nuhuaji, Jesuuri pueya niishitiojonu coteerohua. Nojori sequereeri: —Janiyari pueya jiuujia cuhuatanani. Cante cucua tiuuriini, majaari tari ninishiqui quijia na quiniu quiniutianiya. Pueyaracaanu cuhuashiqui quijia quiniutianiya cutaraari. ");
INSERT INTO arlNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tii quiniaa Fariseocuacaari naa Jesu juaarii: —¡Quiaacuajaari tama quia cuaqueyajiniji pohuataa! ¡Puetunu quia pohuatasanojuanaari maja tojishano! ");
INSERT INTO arlNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesuuri nojori riucuaree: —Tama cua cuaqueyajinijijiaaja cua pohuatasacari, cunoori maja najuhuana pohuatasano. Cua pohuatasanoori seetanujuanaa cutara. Janiyacuajaari niishiyani teje cua niquiaarini, tee cua quianutaniuhuani. Niaari saniniuujia niishiyaquiyacujua teje cua niquiaarini, tee cua quianutaniuhuani. ");
INSERT INTO arlNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Niaari pueyacuara saquiriojotaquiaa saaja nia niquishanojiniji, nia tojishanojinijijiuhuaj. Janiya cutaraari maja cua saquiriojotanu pueyacuara. ");
INSERT INTO arlNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Janiya jaara juaari sesa miijia cutarani, cua sequesano cutaraari seetanujuanaa, niquiriyatujua cua quiyaquishacari. Cua Jiyarona cua Quecuajaari cua cojiquiaa cuata na juaaniuria sesa miijiaca. ");
INSERT INTO arlNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Niaacuajaari Moisés Rootasanojiniji niishitiojoquiaa: “Caapiqui pueyano pohuatasano jaara juhua tarajanu pohuatasano quirijiuhuaj, cuno cutaraari seetanujuanaa”. ");
INSERT INTO arlNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Naajuhuaj, canaari caapiquini. Tama cua cuaqueyajaaja cua pohuatasacari, cunoori seetanujuanaa, cua Jiyarona cojishacari janiya. Nojuajaari cua Que. ");
INSERT INTO arlNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Fariseocuacaari na nequesotaree: —¿Teeteeri quia queni? Jesuuri nojori riucuaree: —Majaari nia niishiniu janiya, cua Quejuhuaj. Niaa jaara cua niishiriquia, niaa maara cua Que niishirijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesuuri puetunu nio pohuatariquiaajanaa Pueyasora niquitiojosano cumaneeca racataja shuriucuaji, Pueyaso Secojojua tiajinia. Naajaa, majaari pueya quianu quiriiquinioj, juhuanojuaja na monu juuca quiyaquishacarijia. ");
INSERT INTO arlNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesuuri cuno Fariseocuaca sequerohuacuhuaj: —Janiyari quianutaniyani. Niaari cua pajenuunutaniya juucua. Niaari cusonuunutaniya sesa miijiacaja, jiyanooshoo nia quishacarijia, cucua nia tiuyaquiniuucua. Naaratej, majaari nia naata quianu quiniutianiya tee cua quianutaniyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Naa Jesu sequesacaritij, cuno narta Judiocuacaari tama sequetooreejaaja: —¿Casaara na sequereecuaraarini: “Maja nia naata quianu quiniutianiya tee cua quianutaniyacuaani”? Tama na cuaqueyajaaja miaquenutaniya jiyoteeri. ");
INSERT INTO arlNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesuuri nojori sequeree: —Niaari ninishiqui quiquiojinijinio. Janiya cutaraari jiyocuacaanujinijinioni. Niaari saaja mijiria quijiaca. Janiya cutaraari maja niiquijinioni. ");
INSERT INTO arlNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Janiyacuajaari cunora nia sequereeni, niaari jiyanooshoojua cusonuunutaniya nia cuaracashitiniuucua janiyari maja Pueyaso Niyanuni, taa cua sequequiaa niajaniyacuajani. Cunora niaari jiyanooshoo quiniutianiya, pueyaracaanu saniitiosano nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nojoriiri Jesu nequesotaree: —¿Canteeri quiajaniyani? Jesuuri nojori riucuaree: —Janiyari najuhuana niaata pocoojiyani. Majaari nia tojiniu janiya. Janiyacuajaari tari nia sequereeni cante janiyani. ");
INSERT INTO arlNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Janiyari queraatia jiitiaajaa cua sequesocoriquiano niajaniyani. Niaa jaara nocua tiuyaquiri, niaari pueyaracaanu saniitiosaanutaniya. Puetunu cua sequesanojuanaa niajaniyani, cunoori seetanujuanaa. Cua pohuatasano mijiria, cunoori cua Jiyarona sequesano janiya. Na sequesanoori seetanujuanaa cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Majaari nojori niishiniu quiriquiaa Jesuuri na Que Pueyasojiniji pohuatariquiaa na sequesacari “cua Jiyarona”. ");
INSERT INTO arlNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesuuri cunora nojori sequeree: —Niaa jaara cua teetere, niaari shusha jiyacari niishiniutianiya, janiyari Pueyaso Niyanuni. Niaari niishiniutianiyajuhuaj, majaari tama cua niishiriojosanojuaaja cua miiniu quijia. Janiyari saaja cua Que niishitiojosano pohuatajani. ");
INSERT INTO arlNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cua Jiyaronacuajaari cuata quiya. Majaari cua Que cartenu janiya, pueyaracaanu cua miiniuucua na panishano. ");
INSERT INTO arlNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Naa Jesu pohuatasacari pueya niquiaratej, queraatia pueyari jiyacari nocua tiuurii. ");
INSERT INTO arlNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesuuri shusha nocua tiuuniaa narta Judiocuaca sequeree: —Niaa jaara seetanujuanaa cua pohuatasano tojijiaca quiri pueyaracaanu, niaari cua pueya quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Niaa jaara naa miiritij, niaari seetanu rupaajanaa niishijiaca quiniutianiya. Naacuajitij, niaari seetanujuanaa juhua cartesano pueya quiniutianiya, juhuajaniya quijiaca nia quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Narta Judiocuacaari Jesu riucuaree: —Canaacuajaruhua supuetana Abraham jiuhuacuajinio supueno pueyani. Majaari quenaaja canaa quiniu quijia tamasaca poonijiotesano pueya. ¿Casaara naa quia sequeya canaarini, canaa quiniuria cartesano pueyani? ");
INSERT INTO arlNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesuuri nojori sequeree: —Seetanujuanaa nia sequeyanijia, cante sesa miijiacani, nojoriiri juhua poonijiotesano pueya quiya. Majaari na naata maninia miijia na quiniu. ");
INSERT INTO arlNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Poonijiotesano pueyanoori maja seetanujuanaa na quiniu juhua na camarnu niyanu. Maja na naata sequenu: “Janiya pueyaracaanu quiniutianiya cua camarnutani”. Na camarnu jaara na paniyaquiri, na naata na jatanu na panishacari. Camarnu niyanu cutara, na queeri maja na jatanu quijia, neyanu na quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Naajuhuaj, janiya jaara nia jaariuutiare nia poonijiotenajinijini, niaari seetanujuanaa cartesano pueya quiniutianiya, Pueyaso muerasura nia quiniuria cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Janiyacuajaari niishiyani, niaari seetanujuanaa pa supuetana Abraham jiuhuacuajinio supueno pueya. Naajaa, niaari cua tojiniu paniyaquiya. Niaari cunora cua monu paniya. ");
INSERT INTO arlNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Janiyari nia pohuatariquiaa cua Quejiniji cua niquishanoni. Niaari saniniuujia nia que sequesano miiquiaacujua. ");
INSERT INTO arlNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nojoriiri Jesu sequeree: —¡Abrahamcuajaari canaa shipininio! Jesuuri nojori riucuaree saaja: —Abraham jaara seetanujuanaa nia shipininio quiri, niaa mariqui maninia miijiaca quiricuara, taa Abraham quiquiaaricuaani. ");
INSERT INTO arlNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Saniniuujia, niaari cua monu paniya saaja cua pohuatanuucua seetanu rupaajanaa, cua tojishano Pueyasojiniji. Abrahamri maja naa na miiniu quijia cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Niaari saaja sesa miijiaca taa nia que miiquiaacuaani. Nojoriiri Jesu juaarii: —¿Casaa quia sequeyani? ¡Canaari maja saa maaji rasanojuani! ¡Pueyasocuajaari canaa Que, maja tamonu! ");
INSERT INTO arlNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesuuri nojori sequeree: —Pueyaso jaara nia Que quiri seetanujuanaa, niaa mariqui cua paniricuara, Pueyasojiniji ninio cua quishacari. Majaari tamajaaja cua niniu quiquiaari. Cua Que Pueyasocuajaari cua jiyaroquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Cua rupaa nia tojiniu paniyaquishacari, niaari cunora cua pohuatasano niishiyaquiya. ");
INSERT INTO arlNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Seetanujuanaa, nia quecuajaari Sesaaca, samaruhua jiyaniijia. Niaari cunora miiniu paniquiaa na panishano. Nojuaja jaara shushajanaa coteequiaari sesa miiniuria, nojuajaari naajuhuanajaj, mona. Nojuajaari maja na niishiniu sequenu seetanujuanaa. Pueyaracaanu sapojojuaari. Na sapojosacari, naa miyari sapojojua na quiniuucua. Sapojonu niishiniuni, cunoori nojuajiniji supuequiaari. Niaari cuno nia que tojijiaca. Nocuaji niaari naa sapojonuujuacajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Saniniuujia, cua pohuatasacari seetanu rupaajanaa niajaniya, majaari cucua nia tiuuniu quiquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Casaa cua miiquianu sesani? Cante na niishiyani cuaara sequeera. Saniniuujia, janiya jaara sesa miyashijia quirini, ¿casaara cucua nia tiuyaquiyacuaraarini, seetanu rupaajanaa cua pohuatasacari niajaniyani? ");
INSERT INTO arlNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Cante Pueyaso pueyani, nojoriiri Pueyaso rupaa tojiquiaa cutara. Niajaniya saniniuujia, niaari na rupaa tojiyaquiya, na muerasu nia quiyaquishacari. ");
INSERT INTO arlNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Narta Judiocuacaari naa Jesu juaarii: —¡Canaacuajaquiiri maninia sequeriquiaa quiajaniyajinijini, quiaari Samaria jiyajinijinio tahue, samaruraca pueyanotuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesuuri nojori riucuaree: —Majaari janiya samaruracani. Janiya cutaraari saaja cua Que tojiquiaani. Niaari saniniuujia cua rerequetequiaacujua. ");
INSERT INTO arlNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Naajaa, majaari cua tacaaniu naa nia sesacasacari janiya. Tamonu cutaraari quiya, nojuajaari paniya pueya tojiniuria janiya. Nojuajaari cua rerequetejaca saniitioriquiano. ");
INSERT INTO arlNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Seetanujuanaa nia sequeyanijia, cante cua rupaa tojijiani, nojoriiri maja na shaajenu quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Narta Judiocuacaari na sequeree: —¡Quiarijia cutara canaari niishiyani quiaari seetanujuanaa samaruraca! Canaa supuetana Abrahamri cusoquiaari, mariyata puetunu Pueyaso sequenu panishano caminiujiuniaajanaanio. Quiaari saniniuujia quiarijia sequeyacujua: “Cante cua rupaa tojijiani, majaari na shaajenu quiniutianiya”. ");
INSERT INTO arlNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Quiaateeri jiyaniya quiaa socua cutara pueyano canaa supuetana Abrahamjiniji? ¡Maja! Nojuajaari shaajequiaari. Mariyata puetunu Pueyaso sequesano caminiujiuniaa pueyajanaari shaajequiaarijiuhuaj. ¿Canteeri quiajaniyani naa quia sequenuratej? ");
INSERT INTO arlNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesuuri nojori riucuaree: —Janiya jaara tama cua cuaqueyajaaja jiyatenu paniri juhua jiyaniijiarani, cunoori najuhuanaj. Seetanujuanaa, cua Quecuajaari cua jiyatequiaari Jiyaniijiarajanaa. Nojuajaari nia sequesano nia Pueyasota. ");
INSERT INTO arlNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Niaari seetanujuanaa na niishiyashijiaca. Janiya cutaraari cua Que Pueyaso niishiyani. Janiya jaara nia sequereni, maja cua niishiniu nojuaja, janiya maara sapojojua quirini taa nia quiyacuaani. Janiya cutaraari na niishiyani. Janiyari cunora na rupaa tojijiani. ");
INSERT INTO arlNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nia supuetana Abrahamri timiquiaari na niishishacari janiya mijiria supuenutaniyani. Nojuaja jaara cua niquiquiaari mijiria quiyano tari, jiyanohua timiquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Narta Judiocuacaari Jesu juaarii. Naa na sequetureeri: —¡Jaj! Majaruhua juhuanojuaja cincuenta marijia shocojonu quiajaniya. ¿Taa quia sequeyarini quiaa canaa supuetana Abraham niquiquiaari? ");
INSERT INTO arlNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesuuri nojori riucuaree: —Janiya nia sequeya seetanujuanaani, Abraham raaquishacarijia, janiyari tari quijiani. ");
INSERT INTO arlNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Naa nojori tojishacari Jesu sequesanotej, narta Judiocuacaari sai pajenuuree Jesu na jacutajara juucua. Jesuuri nojoriicuaji jamaarii saaja. Pueyaso Secojojua tiajiniji tohuatamaari. ");
INSERT INTO arlNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tamacari Jesu rucuanejosacari canaata, canaari cariyojuaru pueyano niquiriini, naa rasanojuhuanajaj. ");
INSERT INTO arlNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Canaari cunora Jesu nequesotareeni: —Niishitiojonanaa, ¿casaara naa cuno pueyano rasaaquiaari cariyojuaruni, na queya miiniuucua sesatee, tama sesa na miiniuucuajaaja soj? ");
INSERT INTO arlNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesuuri canaa riucuaree: —Maja. Maja cunora naa na rasaanu quiquiaari. Naa rasaaquiaariiri Pueyaso cumaaca niishishaanura, na namijia jaara jeecasaare niquijiara na quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Juuca quishacarijia, pa tucuatare miiniu cua Jiyarona sequesano cua miiniuria. Paa quera niniyani. Jaara niniquii, majaari pa naata poonijionu quiniutianiya tari. ");
INSERT INTO arlNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mijiria cua quishacarijia, janiyari pueya jiuujia cuhuatanani. Jesu sequesacari: “Paa quera niniyani”, nojuajaari pa shaajenujiniji sequeriquiaa miriqui. ");
INSERT INTO arlNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Naa Jesu sequenu nuhuajitij, nojuajaari jiyocua riocoree. Na riacauta coniquioreeri. Coriyacau mara ruporohua cariyojuaru namijiaacuaari. ");
INSERT INTO arlNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Cariyojuaru sequerohuari: —Siloé cuarimia quia jeequesee quia namijia. Hebreo rupaajinia, Siloé cuariiri sequeya “Pueyaso Jiyarosano cuari”. Cariyojuaruuri cuarimia quiaaree. Tii na namijia jeequeseeri. Tariucua niquijiaari na tiajinia tiuquiriohua. ");
INSERT INTO arlNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Cariyojuaru na quishacarijia, nojuajaari na miajajau na masetajara cumaneeca mashiniquijiojua quiquiaari. Puetunu pueyajanaari na niquitiujia naa na mashiniquijiosacari. Naacuajitij, nojuaja jaara niquijiara quiquiaari, tarijia na niquiniaa pueyari, mariyata na shuriucua quiniaa pueyanio, nojoriiri tama sequetooquiaarijiaaja: —¿Cante cuno pueyanojaarani? ¿Majate noocuaja tarijia cumaneeca mashiniquijiojuatej? ");
INSERT INTO arlNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Noojiaqueya pueyari sequeree: —¡Taaquiriirinij, nojuajacuaj! Tamasacaari saniniuujia sequereecujua: —Nojuajaquinio naasucua. Juhua nojuaja niquishiyacuaj, majaari seetanujuanaa nojuaja. Tarijia quijia cariyojuaruuri saa sequereejaa: —Taaquiriirinij, janiyacuaaquiniatejaj. ");
INSERT INTO arlNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Naaratej, pueyari na nequesotaree: —¡Quiaacuaja cariyojuaru quijiaruhua! ¿Taa niquijiara quia quiriohuarini? ");
INSERT INTO arlNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nojuajaari pueya riucuaree: —Cuno, Jesu jiyanishano pueyanoni, nojuajaari mara coniquioree cucuara. Cua namijiaacua na ruporohuari. Na nuhuaji, cua jiyaroreeri Siloé cuarimia cua jeequenura cua namijia. Janiyari quiaareeni. Cua namijia cua jeequesacari, ¡janiyari niquijiara quiquiini! ");
INSERT INTO arlNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pueyari na nequesotaree: —¿Teeteeri quia namijia jeecana pueyanoni? Nojori riucuareeri: —Johuaj. Maja cua niishiniu. ");
INSERT INTO arlNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pueyari Fariseocuacaacua jiyataaree Jesu jeecasano cariyojuaru pueyano. ");
INSERT INTO arlNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesu jaara mara coniquioquiaari na jeecanura cuno pueyano namijia, cuno juucaari Judiocuaca samaatenu juuca quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nocuaji Fariseocuacaari tarijia cariyojuaru quijia nequesotaree taa niquijiara na quiriini. Nojuajaari nojori riucuaree: —Jesu cua namijiaacua rupojorucuaa marani. Na nuhuaji, janiyari cua namijia jeequeseeni. Naacuajitij, janiyari quiarijia niquijia quiyani. ");
INSERT INTO arlNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Noojiaqueya cuno Fariseocuacajinijinioori saa sequereejaa: —Cuno pueyano, nio pueyano namijia jeecarucuaani, nojuaja maja Pueyaso Jiyarosano. ¡Nojuajaari Moisés Rootasano tojiyashijia, naa na miiniuucua samaatenu juuca! Tamasacaari saniniuujia sequeriquiaacujua: —Jaara sesa miijia quiri, ¿maatucua casaara poonijiore Pueyaso cumaacatacuaraarini? Naa nojori juayonuutanuucuatej, nojoriiri juhua raquitiirii. ");
INSERT INTO arlNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nocuaji tarijia quijia cariyojuaru nequesotaturohuariuhuaj: —Niquijia quia quishacari quiarijia, ¿taa quia sequeya Jesuni? ¿Maninia miijiatee? Nojuajaari saaja Fariseocuaca riucuaree: —Janiyara, nojuajaari Pueyaso sequesano caminiujiunia. ");
INSERT INTO arlNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tii quiniaa Judiocuacaari na cuaracashitirii saaja. Nojoriiri jiyaniquiaari maja naasucua seetanujuanaa cariyojuaru cuno pueyano quiniu quijia. Nocuaji nojoriiri na queya sequeturee nojoriicua na niniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nojori tiuquishacari, cuno Judiocuacaari nojori nequesotaree: —Canaa nia sequere, ¿nio pueyanote seetanujuanaa nia niyanu, nia sequesano cariyojuaru rasanojuhuanani? ¿Taa quiarijia niquijiara na quiriohuarini? ");
INSERT INTO arlNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Na queyari cuno pojori riucuaree: —Taaquiriirinij, nojuacuaaquiniateja canaa niyanujuaj. Naa cariyojuaru rasaaquiaariiri. ");
INSERT INTO arlNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Majaari canaa niishiniu cutara taa na quiriohua niquijiarani. Majaari canaa niishiniujiuhuaj, cante na namijia jeecarucuaani. Nojuaja nia nequesotare, tari cumantumacacuaja. Nojuajanaa cuaara nia pohuataara cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Na queyari naa riucuaquiaari narta Judiocuaca camarucuatej, na pueretusacari nojori. Judiocuaca camarucuaari tari sequetuquiaari: “Cante Jesu sequeyani nojuaja seetanujuanaa Pueyaso Jiyarosano, naa sequejaca pueya cuaara tenujusaaria maja Pueyaso secojojua tiajinia na tiuquiniuria socua”. ");
INSERT INTO arlNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Naaratej, na queyari naa narta Judiocuaca riucuaquiaari: “Nojuaja nia nequesotare, cumantumacacuaja”. ");
INSERT INTO arlNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Cunora cuno Judiocuacaari socua piiriohua na namijia jeecasano pueyano. Nojoriicua na nishacari, na sequetureeri: —¡Paacuajaari Pueyaso niquiara niya quiyani! Naaratej, ¡seetanujuanaa canaa quia pohuatare cuno pueyanojiniji! ¡Canaa cutaraari niishiyani cuno pueyanoori sesa miijia! ");
INSERT INTO arlNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na namijia jeecasano pueyanoori nojori riucuaree: —Naajaa, jaara sesa miijia quiri, jaara maninia miijia quirijiuhuaj, maja cua niishiniu cuno. Janiya cutaraari niishiyani, ¡janiyari tarijia niquiyashijia quiquiaarini! ¡Janiyari saniniuujia quiarijia niquijia quiya cutarani! ");
INSERT INTO arlNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nojoriiri na nequesotarohuacuhuaj: —¿Taa na miiriucuaa quiajaniyajaarani, niquijia quia quiniuriani? ");
INSERT INTO arlNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Narta Judiocuaca camarucua sequeree saajaari: —Janiyacuaja tari nia pohuatareeni. Majaari nia tojiniu paniniu janiya. ¿Casaara nia paniya socua cua pacutenura sequenu niajaniyani? ¿Niaate na pueyara quiniu paniya soj? ");
INSERT INTO arlNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Naa na sequesacari nojoritij, cuno Judiocuaca camarucuaari na sesacaturee. Naa na sequetureeri: —¡Quiaari cuno pueyano tojijiacuaja! ¡Canaa cutaraari supuetana Moisés Rootasano tojitiajacani! ");
INSERT INTO arlNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","¡Canaa cutaraari niishiyani Pueyasojuanaari Moiséscua muetaquiaari na rootanura nojuaja! ¡Saniniuujia cuno pueyanoorijiataj, majaari quenaaja pa niishiniu teje na supuequiaarini! ");
INSERT INTO arlNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na namijia jeecasano pueyanoori nojori riucuaree: —¡Niaaquiiri mosanucua seetanujuanaa! ¿Majateeri nia niishiniu teje na supuequiaarini? ¡Nojuajaari cua namijia jeecarucuaa! ");
INSERT INTO arlNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","¡Paacuajaari niishiyani Pueyaso maja na tojiniu quijia sesa miijiaca secojosano! ¡Saaja na timitiajaca secojosano tojiya cutaraari, cante na panishano miiquiaacuajani! ");
INSERT INTO arlNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","¡Majaari quenaaja pa tojiniu quijia tamonu pueyanojiniji, cante cariyojuaru namijia jeecajani, naa cariyojuaru rasanojuhuanaj! ");
INSERT INTO arlNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Cuno pueyano jaara Pueyaso Jiyarosano quiyaquiri, ¿taa cua namijia na jeecarucuaacuaraarini? ");
INSERT INTO arlNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Cuno pojoriiri na juaaniutia na sequeturee: —¡Quiaari sesa miijia rasaaquiaari! ¿Quiaateeri jiyanojuaa canaa niishitiojonu paniyaruhua? Naaratej, narta Judiocuaca camarucuaari na tenujuturee maja socua na tiuquiniuria Pueyaso secojojua tiajinia. Naacuajitij, cuno pueyanoori juhua taanuusano pueyano quiquiaari narta Pueyaso timitiajaca pueyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesuuri niishiquiaari cuno pueyanoori tenujusaarucuaa. Jaara na riuriataquiaari, Jesuuri na sequeree: —¿Quiaate Pueyaso Niyanuucua tiuujia? ");
INSERT INTO arlNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jesu sequereeri: —Jiyaniijianaa, cua sequere canteeri nojuajani, nojuaja cua niishiniuria nocua cua tiuuniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesuuri na sequeree: —Quiaacuaja na niquiyaruhua. Nojuajaari cunocuaja, quiata pocoojiyani. ");
INSERT INTO arlNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jiyacaritij, pueyanoori Jesu cariquimiaji mojoquetaree. Na sequereeri: —¡Quiocua tiuyanijia, cua Jiyaniijianaa! ");
INSERT INTO arlNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Na nuhuaji, Jesuuri cuniqui quiniaa pueya niquiara sequeree: —Janiyari mijiria niquiaarini juhua cua raquiriojotanura mijiria quiniaa. Naacuajitij, cante niishiyani nojuaja juhua cariyojuaru quiya, nojuajaari juhua namijiaraca quiniutianiya cucua na tiuushacari. Saniniuujia, cante jiyaniyani nojuaja niquijia cutara, nojuajaari juhua cariyojuarura tari jiyatesaaree, cucua na tiuyaquiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tii quiniaa Fariseocuaca jaara tojiquiaari naa Jesu sequesanotej, nojoriiri Jesu sequeree: —Naa quia sequesacaritij, ¿quiaateeri sequeya canaari cariyojuarujurijiuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesuuri nojori riucuaree: —Niaa jaara tama nia cuaqueyajaaja jiyatere juhua cariyojuarura cucua nia tiuuniuria, Pueyaso maara nia jiyanoori. Quiarijiani, tama nia sequenuucuajaaja, “Canaa niquijia cutarani”, niaari jiyanooshoojua nioojia nia tacatoyaquiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesuuri socua pohuatarohua pueya niquiara. Naa sequereeri: —Seetanujuanaa nia sequeyanijia, cante borrego mataca tohuateyaco tiuquiyaquijiani, nojuaja jaara tamocoji tiuquimia, cunoori nohuasejojua. ");
INSERT INTO arlNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Saniniuujia, cante tohuateyaco tiuquijia cutarani, cunoori borregohua camarujuanaa cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tohuateya cojuanaari tiootiu riataquiaa nocuaji. Borregohua camaruuri puetunu na seya sesacajanaa jiyaniquijia. Na borregohuari na rupaa niishijia. Na camaruuri naa na tohuatanijiojua puetunujuanaa na matacajiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Puetunu na borregohuajanaa jaara tohuareetama, na camaruuri na puetaja. Na seyari na nuhuaji sacuaja, na camaru rupaa nojori niishishacari. ");
INSERT INTO arlNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Saniniuujia, borregohuari maja na nuhuajiniu quijia na niishiyaquishoo pueyano. Saaja nocuaji cocuatejaari na niishishacari cunoori maja na camaru rupaa. ");
INSERT INTO arlNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesuuri naa pohuataquiaari miriqui nojori niquiara. Nojoriiri saaja niishiyaquiquiaari casaa na niishitiojonu paniriquiaa nojorini. ");
INSERT INTO arlNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nocuaji Jesuuri naa nojori sequerohua maatia: —Seetanujuanaa nia sequeyanijia, janiyari juhua tohuateyani, cua borregohua tiuquitianura cua Que Pueyasoocua. ");
INSERT INTO arlNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Cante cua niyacarijia nijioquiaari coteenuni, nojoriiri sesa miijiaca quiquiaari, nohuasenuujuaca. Cua borregohuari namitia nojori numueejushiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Janiyari juhua tohuateyani. Cante janiyajiniji tiuquiya cua Queecuani, nojuajaari Pueyaso pueyanora jiyatesaanutaniya cutara. Cuno pueyanoori maninia cojuasano juhua borrego. Janiyari na tiuquininiutianiyani, tii na quiniuria maninia cojuasano. Janiyari juuca na tohuatenutaniyani, jiyasocua cua miaquetenura carijiniacuma. ");
INSERT INTO arlNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Nohuasejojuaari saaja tiuquijia borregohuacua na nohuasenura, na puecoonurajuhuaj. Naa na shaajaaja puetunujuanaari. Janiyari saniniuujia niquiaarini cua borregohua cua jiyatenura pueyaracaanu quijiacara, seetanujuanaa jiyanohua shuquiriaatia quijiaca nojori quiniuria. ");
INSERT INTO arlNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Janiyari maninia cojuanani, maja tamonu. Pueyano jaara maninia na seya cojuana maniniu quiri, tama na cuaqueyajaaja panitiaja na seyacuaari. ");
INSERT INTO arlNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Saniniuujia, borregohua camarujuanaa jaara tamonu cojuateya na seya, cuno pueyano jaara niquiri sare nocua canujiyano, nojuajaari na puerenuta neteja. Borregohua tiujiaqueeri. Naa miijiaari cuno borregohua quiyaquiniuucua na seyajanaa. Naacuajitij, sareeri borregohua soojua. Naa na cocuatajaari. ");
INSERT INTO arlNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cuno borregohua cojuanaari naa neteja sareecuaji na tacayaquishacari seetanujuanaa cuno borregohuacua. Nojuajaari saaja paniya na poonijiosano sami na niquitiosaanura. ");
INSERT INTO arlNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Janiya cutaraari maninia cojuaja borregohuani, na camarujuanaa cua quishacari. Janiyari puetunu cua seyajanaa niishijiani. ");
INSERT INTO arlNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nojoriiri cua niishiyajuhuaj, taa cua Que niishiya janiyacuaani, mariyata taa cua niishiya cua Quejaniuhuaj. Janiyari tama cua cuaqueyajaaja panitiaja cua borregohuacuarani. ");
INSERT INTO arlNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Janiyari socua borregohua jiitiaani. Nojoriiri maja nio cua borregohua maanujinijinio. Janiyari nojori rijionutaniya niyarajuhuaj. Nojoriiri cua tojitiariquiano. Naacuajitij, puetunu cua borregohuajanaari jatiqui quiriquiano, niquiriyatu cojuanaracajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Cua Queeri cua paniya naa cua panitiasacari tama cua cuaqueyajaaja cuno borregohuacuara. Janiyari tama cua panishacarijiaaja mosaanutaniyani, na nuhuaji cua samiitianuhuara, pueyaracaanu quijia cua quiniuhuara. ");
INSERT INTO arlNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Majaari quenaaja tamonu naata monu janiya cua paniyaquishacari. Janiyari cua panishacari cusonutaniya cua borregohuacuarani. Janiyari cumaacaracani nojoriicuara cua cusonura. Janiyari cumaacaracajuhuaj cua samiitianuhuara. Cua Quecuajaari naa cua miiniuria cua jiyaroquiaari mijiria. ");
INSERT INTO arlNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Narta Judiocuaca jaara tojiquiaari naa Jesu sequesanotej, nojoriiri socua tama juayonuutaquiaarijiaaja Jesuucua. ");
INSERT INTO arlNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Queraatia pueyari jiyacari sequeree: —¡Cuno pueyanoori samaruraca! ¡Maja na tojiniu, pueyanaa! ¡Najuhuana pocuaano! ");
INSERT INTO arlNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tamasacaari saniniuujia sequeriquiaacujua: —¿Samaruraca pueyanoteeri maninia casaa pohuatajajaara juhua nio pueyanojua? ¡Maja! ¿Pueyanoteeri na naata samaru cumaacata jeecanu cariyojuaru namijiajaara? ¡Maja na naata! ");
INSERT INTO arlNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tamacari, Jerusalén tiacajiniaari queranacusaariquiaa. Cunoori quiriquiaa pueya niishiriojonura nojori juhua cuno juucajinia Pueyaso Secojojua tia jiyatequiaariuhua seetanujuanaa juhua Pueyaso quiquiora na quiniuhuara. Jiyacariiri shuniya quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesuuri tii quiriquiaajuhuaj. Pueyaso Secojojua tiajinia quiriquiaari. Nojuajaari pueya jiyaniquishano tariucuacaanu jiyaniijia Salomón canujuucojojuajinia riujiuuniuquiojoriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jiyacaritij, canaa Judiocuaca camarucuaari tii na cosesee. Naa na nequesotatureeri: —¿Taacari canaa quia sequenutaniya socuaari cante quiajaniyani? ¡Quiaa jaara seetanujuanaa Pueyaso Jiyarosano quiri, quiarijia canaa quia sequere! ");
INSERT INTO arlNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesuuri nojori riucuaree: —Janiyacuaja tari nia sequecanuni. Niaari saaja na cuaracashitiquianu. Niaa cuaara niishiiria cante janiyani, nia niquishacari cua miishano cua Que sequesano janiya. ");
INSERT INTO arlNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Niaari saaja cucua tiuyaquiquiaa cua borregohua maanujinijinio nia quiyaquishacari. ");
INSERT INTO arlNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Cua borregohuari cua rupaa tojijia cutara. Janiyari nojori niishiyajaaniuhuaj. Nojoriiri cunora cua nuhuajiquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Janiyari pueyaracaanu quijiara nojori jiyatequiaani. Majaari nojori juurequenu quiniutianiya. Majaari quenaaja tamonu naata jaariuutianu quiniutianiya nojori janiyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Cua Queeri cua borregohua cua niquitioquiaari. Nojuajaari socua jiyanohua cumaacaraca tamasaca cumaacaraca quijiacajiniji. Naacuajitij, maja quenaaja tamonu naata cua borregohua jaariuutianu cua Quejiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Janiya cua Queta, canaari juhua niquiriyatuni. ");
INSERT INTO arlNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jiyacaritij, canaa Judiocuaca camarucuaari sai rijiorohuacuhuaj, Jesu na jacutajara juucua. ");
INSERT INTO arlNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesuuri saaja nojori sequeree: —Janiyari queraatia maninia casaa miiquianu saaja cua Que cumaacata nia niquiarani. ¿Teyanoocua nia jacunu paniya janiyani? ");
INSERT INTO arlNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nojoriiri Jesu riucuaree: —Majaari canaa jacunu quiniutianiya quiajaniya maninia quia miiniuucua. ¡Canaari quia jacunutaniyani sacuaraatia quia pocuanuucua Pueyaso niquiara! ¡Quiaari tama quia cuaqueyajaaja jiyateya juhua Pueyasora! ¡Cunoori jiyanohua sesa! ¡Quiaacuajaari pueyano, juhua canaajuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesuuri nojori sequeree: —Niaacuajaari tariucuacaanu naajiosano Pueyaso Rupaa jiitiaa. Pueyaso sequesanoori naa naajiotasano quiya tii: “Janiyacuajaari nia sequequiaarini, niaari pueyasohua”. ");
INSERT INTO arlNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","’Paacuajaari niishiyani, Pueyaso Rupaajinia naajiotasanoori maja na naata cuaracashitishaanu. Pueyasojuanaari pueya jiyaniquiquiaari “pueyasohuata”, noo pojori, teyano nojuaja jiyatequiaari Israel pueya jiitianaaracuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Naajuhuaj, Pueyasocuajaari cua saquiriojoquiaari mijiria na jiyarosocoriquiano. Naa Pueyasojuanaa Jiyarosano cua quishacaritij, ¿niaatucua casaara sequereni janiya Pueyaso niquiara pocuaree sesani, cua sequesacari janiya Pueyaso Niyanuni? ");
INSERT INTO arlNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Janiya jaara cua Que panishano miyaquiri na cumaacatani, janiya maara nia juayaquirini cucua nia tiuyaquiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Niaacuajaari cua Que cumaacata cua miishano niquiquiaa. Niaa jaara cua pohuatasanoocua tiuuniu paniyaquiri, naajaa, cua Que cumaacata cua miishanoocua nia tiuuri quenaaja. Niaa jaara niishiri puetunu cua miishanojuanaari cua Que Pueyaso cumaacata miishano, niaa maara niishiri Pueyasoori coojia rupueja, janiyari noojia rupueyajaaniuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jiyacaritij, nojoriiri socua Jesu quiatunu paniriohuacuhuaj. Jesuuri saaja nojoriicuaji mashiquii. ");
INSERT INTO arlNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesuuri canaa jiyataarohua Jordán moo taquijiria tee Juan tiuquinijioquiaari tarijia pueyacuajani. Canaari tii quishiini. ");
INSERT INTO arlNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Queraatia pueyari Jesuucua nijioquiaari tee canaa quiriquiaacuajani. Nojoriiri tama sequequiaarijiaaja Jesujiniji: —Tiuquinijiona Juanri maja quenaaja na miiniu quijia casaa Pueyaso cumaacata. Naajaa, puetunu nio pueyanojiniji na sequesanojuanaaquiiri seetanujuanaa quijia. ");
INSERT INTO arlNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Naacuajitij, queraatia pueyari Jesuucua tiuuquiaari tii, tee canaa quiriquiaacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jiyacaritij, tamonu pueyanoori cusosu matariquiaa. Na sesa quiquiaari Lázaro. Nojuajaari Betania tiacajinijiniojuanaa quiquiaari, Judea jiyajinia. Na rimiatuhua quiquiaari María, Martanio. Nojoriiri cuno Betania tiacajinijinio quiquiaarijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lázaro rimiatu Maríani, nojuajaari noo maajicuaja Jesu niohuaca sacuanijiaquiaari na muecacatatej, nocua na totanu nuhuaji na shanohua jaanutaja. ");
INSERT INTO arlNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázaro matasacari cusosu, na rimiatuhuari pueyano jiyarotuquiaari Jesu numootenuucua. Naaratej, cuno pueyano tiuquishacari Jesuucua, nojuajaari naa caminiujiuquiaari Lázaro rimiatuhua sequesano nojuaja: —Jiyaniijianaa, quia panishano pueyanona cusosu mataa. ");
INSERT INTO arlNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesu tojishacari naa cuno pueyano sequesanotej, tii quiniaa pueya sequereeri, canaajuhuaj: —Nojuajaari maja na cusonu quiniutianiya na shaajenura puetunujuanaa. Cuno cusonu na jiitiasanojinijini, pueyari Pueyaso cumaacata miishano niquiniutianiya. Pueyari cunora Pueyaso Niyanu maniniuhuaqueetanutaniya, cua Que Pueyasojuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Marta, María, Lázaronio, nojoriiri Jesu panishano pueya quijia. ");
INSERT INTO arlNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Naajaa, Jesu jaara numootesaaquiaari Lázarojiniji, majaari nocua na quianu quiquiaari ritia. Caapiqui juuca camueeree cuniquijiaaraari, tee canaa quiriquiaacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Na nuhuaji, canaa na saquiriojosano pueya sequereeri: —Judea jiyajinia pa quiaarohuacuara socua. ");
INSERT INTO arlNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Canaari Jesu sequereeni: —Niishitiojonanaa, cuniquijinio Judiocuacacuajaari shusha naataja tii quia jacunu paniquianu. ¿Casaara socua tii quia quianu paniuhuariniuhuaj? ");
INSERT INTO arlNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesuuri canaa riucuaree miriqui: —Janiyara, juuca juhuanojuaja. Juucaari maninia seetanujuanaa pa rucuanejonura. Paa jaara pananu tiuquiyaquishacarijia rucuanejoreni, paari maninia niquiya pocuajini. Majaari pa tiuriiniu. ");
INSERT INTO arlNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Paa jaara ninishiqui rucuanejore saniniunijia, paari tiuriijiani cuhuashiqui na quiyaquishacari. Jesuuri naa sequeriquiaa miriquitij, nera, maja puereeta na quiniu quiriquiaa Judiocuaca niquiara na rucuanejonura, na mosaanu juuca quiyaquishacarijia. ");
INSERT INTO arlNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Na nuhuaji, Jesuuri naa canaa sequeree socua: —Pa rupuena Lázaroori tari maquequee. Janiyari na niucuajanuucua quianutaniyani. ");
INSERT INTO arlNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Canaari Jesu sequereeni: —Jiyaniijianaa, nojuaja jaara maqueya, maniniacuajaqui. Naacuajiti paari niishiyani naatanutaniuhuacuajaaqui. ¿Paatucua casaara najuhuana nocua quiaareni? ");
INSERT INTO arlNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Naa Jesu pohuatasacari canaa Lázarojinijitij, canaa sequeriquiaa juucuaari Lázaro tari macu quiriquiaa. Canaari saniniuujia jiyaniriquiaani Jesu naasucuaari canaa pohuatariquiaa Lázaro nareja maqueriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nocuaji Jesuuri maatia canaa sequeree: —Lázaro tari cusoyarucuaa. ");
INSERT INTO arlNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Janiyari timiyani tii cua quiyaquiniuucua Lázaro quishacarijia saminio. Naa quiarijia macu na quishacaritij, niaari socua jiyajeneta casaa cua miishano niquiniutianiya, seetanujuanaa cucua nia tiuuniuria cutara. Quiarijia cutara, nocua pa quiaare. ");
INSERT INTO arlNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jiyacaritij, Tomásri canaa narta saquiriojosano pueya sequeree: —Pa Jiyaniijiata pa quiaarejuhuaj, nata pa cojiritiasaanura puecoonu. Cuno Tomásri pueya sesojosano quiquiaari “Caapueya muetusano”. ");
INSERT INTO arlNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Canaa jaara tiuquiijioseequiaarini, Jesuuri pohuatasaaquiaari Lázaro tari cuatro juuca shocotejoriquiaa raaco na niasaanujiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania tiacaari catecaja Jerusalén tiacajiniji. (Nareja media hora paa jaara ritia rucuaneyareni). ");
INSERT INTO arlNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Naaratej, queraatia narta Judiocuacaari quiojoquiaari Marta, María tiajinia, nojori na cumanijianura na nanu nuhuaji. ");
INSERT INTO arlNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta jaara niishiquiaari Jesu shusha tiuquiriquiaa, nojuajaari nocua tohuataquiaari canaa na naacunura. Majaari María niniu quiriquiaa cutara. Tiajiniaja quiriiri. ");
INSERT INTO arlNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Canaacua Marta tiuquishacari, nojuajaari Jesu sequesee: —Jiyaniijianaa, ¡quiaa jaara niya quiquianu, cua nanu maara shaajeyaquiquianu! ");
INSERT INTO arlNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Naajaa, janiyari niishiyani quiaa jaara Pueyaso secojore, Pueyasoori quia secojosano tojiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesuuri Marta sequeree: —Quia nanucuaja samiitianutaniuhua. ");
INSERT INTO arlNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martaari na riucuaree: —Taaquiriirinij, janiyacuaja niishiyani nojuajaari samiitianutaniuhua macunucua samiitiacosacariuhua jiya puequesacari. ");
INSERT INTO arlNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesuuri na sequeree: —Janiyacuajaari macunucua samiitianijiojuani. Cante cucua tiuujiani, jaara cusoyare, naajaa, samiitianutaniuhuari. ");
INSERT INTO arlNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Cante cucua tiuurii saminio na quishacarijiani, nojuaja jaara cusoyare, naajaa, majaari na shaajenu quiniutianiya seetanujuanaa. ¿Quiaate cua sequesanoocua tiuya Martanaa? ");
INSERT INTO arlNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nojuajaari Jesu riucuaree: —Jaa, Jiyaniijianaa. Janiyacuaja niishiyani quiaari Cristo, Pueyaso Niyanu, nooj tariucuacaanu sequesaaquiaari mijiria niriquianotej. ");
INSERT INTO arlNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Naa Marta riucuanu nuhuaji Jesutej, na tiajinia quiaarohuari. Naa María numaama sasacasuhuari: —Niishitiojona jati quiya. Quia sequeyano nocua quia quianura. ");
INSERT INTO arlNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Naa María tojishacari Marta sequesanotej, ritia sanequeeri. Jesuucua nimiaari tee canaa quiriquiaacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesuuri juhuanojuaja maja na tiuquitianu quiquiaari canaa cuno tiacajinia. Canaari tiaca shuriucua quiriquiaajaani tee Marta naacuquiaari canaacuajani, Jesuucua na nishacari. ");
INSERT INTO arlNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nojori cumanijianaa pueya jaara María niquiquiaari ritia tohuataano tiajiniji, nojoriiri na jiyaniquiaari na nanu raajinia nujuquenuucua quiaa naasucua. Naaratej, nojoriiri na nuhuaji quiaaree. ");
INSERT INTO arlNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María tiuquishacari canaacua, Jesu cariquimiaji mojoquetaseeri. Naa na sequereeri: —Quiaa jaara niya quiquianu, cua nanu maara shaajeyaquiquianu. ");
INSERT INTO arlNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesu niquishacari María nujuqueyano, mariyata nata quiniaa nujuqueyanojuhuaj, Jesuuri nojori taraajetaree. ");
INSERT INTO arlNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jesuuri pueya nequesotaree: —¿Tee na niasaarucuaani? Pueyari Jesu sequeree: —Miji, Jiyaniijianaa. Quia niquiquii. Niya niasaarucuaano. ");
INSERT INTO arlNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesuuri nujuquesee. ");
INSERT INTO arlNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tii quiniaa Judiocuaca niquishacari Jesu nujuqueyano, tama sequetooreejaarijia: —¡Nia niquiri! Jiyanohua Lázaro panijiaquiiri. ");
INSERT INTO arlNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Noojiaqueya cuno pojorijinijinioori sequeriquiaajuhuaj: —Jesu jaara cariyojuaru namijia jeecacanucuaa, maara Lázaro naataniquianujuhuaj maja na shaajenura. ");
INSERT INTO arlNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesuuri jiyanohua na taraajenuta raa jiyajiria catecanoquiaari, canaajuhuaj. Raari puereetuuca saajiata mishiquiosano quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesuuri pueya sequeree: —¡Saajia nia ruutiniri tamocora! Martaari Jesu sequeree: —¡Jiyaniijianaa, cuatro juuca tari na shoconujiya! ¡Tari mocuaatia jaaniuya naasucua! ");
INSERT INTO arlNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesuuri Marta sequeree: —Janiyacuaja tari quia sequereeni, quiaa jaara cua sequesanoocua tiuuri, quiaari Pueyaso cumaacata cua miishano niquiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jiyacaritij, pueyari saajia ruutinirii tamocora. Jesuuri jiyocuacaanu mauree. Naa Pueyaso sequereeri: —Cua Quenaa, quia timitiaanijia. Quiaari tari cua sequesano tojiriucuaacuaja. ");
INSERT INTO arlNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Janiyari niishiyani quiaari pueyaracaanu cua tojiquiaa. Janiyari naa quia sequereeni, niya quiniaa pueya niishiniuria quiaari mijiria cua jiyaroquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Naa Jesu sequenu nuhuajitij, jiyanohua na rupaa paaretareeri. Naa sequereeri: —¡Lázaronaa, quia tohuatama! ");
INSERT INTO arlNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Macuuri tariucua saminio tohuatamaa. Na juaashiquiaca, na niohuacaari jiuniocosano quiriquiaajaa. Na nacaari puetunu na jiquiocotajanaa mishiquiosano quiriquiaajuhuaj, toquerauta morosano. Jesuuri pueya sequeree: —Nia saacatare, cuaara rucuaneera. ");
INSERT INTO arlNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Naa Jesu samiitianishacari Lázarotej, queraatia narta Judiocuacaari nocua tiuuquiaari, noo pojori canapuete Maríacua nijioquiaari na cumanijianuracuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Noojiaqueya cuno Judiocuacajinijinioori Fariseocuacaacua quiojoquiaari nojori pohuatanura Jesu miishano. ");
INSERT INTO arlNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Naaratej, Fariseocuaca, pueyacuara secojonaa jiyaniijianucuanio, nojoriiri rerejoquiaari puetunu Judiocuaca camarucuatajanaa. Nojoriiri sequetuquiaari: —¿Taa pa miiniutianiyani? Cuno pueyanoori queraatia casaa miiquiaa na cumaacata pueya niquiara. ");
INSERT INTO arlNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Paa jaara nareja na shanacure naa na miiniuriatej, ¡puetunu pueyajanaari na pueyara quiniutianiya, nocua nojori tiuushacari! Nojoriiri na jiyaniijiara socua na jiyatenutaniya. Naaratej, pa jiitianaa Romano pueyari pocua nijionutaniya Pueyaso Secojojua tia nojori niyartanura, pa pueya na puecoonurajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Caifásri tii quiriquiaajuhuaj. Nojuajaari canaa pueyacuara secojonaa jiyaniijiajanaa quiriquiaa cuno marijiara. Jiyacaritij, nojuajaari narta camarucua sequeree: —¡Niaaquiiri niishiyashijiaca seetanujuanaa! ");
INSERT INTO arlNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Majateeri nia niishiniu? Maninia cutaraari niquiriyatu pueyano cusonura pa niti, maja najuhuana puetunu pa pueyajanaa puecoosaanura. ");
INSERT INTO arlNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás sequesanoori maja tama na sequesanojuaaja quiquiaari. Pueyacuara secojonaa jiyaniijiajanaa na quishacari, Pueyasoori naa na pohuateree taa Jesu cusonutaniya puetunu Judiocuacaacuarajanaani. ");
INSERT INTO arlNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Seetanujuanaari. Jesuuri maja cusoriquiano quiquiaari saaja Judiocuacaacuara. Nojuajaari cusoriquiano quiquiaari puetunu tariucua Pueyaso saquiriojosano pueyapueecuarajanaajuhuaj, tee tiquiyocua niyaquejonu na muerasurano quiyacuajani. Nojuajaari cusoriquiano puetunu cuno pojorijianaa na rerejotenura, jatiqui na quitiuniuria juhua niquiriyatu maanu. ");
INSERT INTO arlNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Naacuajitij, cuno juucajiniji, cuno Judiocuaca camarucuaari roojotooriquiaa taa nojori monutaniya Jesuni. ");
INSERT INTO arlNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nocuaji, Jesuuri maja tari na rucuanejonu quijia narta Judiocuaca niquiara. Cunora tamaquiria canaa jiyataquiaariiri. Canaari nata quishii cariiquia jiya shuriucua tamonu tiacajiniani. Cuno tiaca sesa quiquiaari Efraín. ");
INSERT INTO arlNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jaara quera quiquiaari tari canaa queranacusacari Pascua juucara, queraatia pueyari quiojoriquiaa Jerusalén tiacajiniara tama na tiacajinijijiaaja. Nojoriiri quiojoquiaari juhuacarijia nojori jeenucuanura na cuaqueya nojori puecoosacari tama na seyajaaja nojoriicuara. Nojoriiri naa miiquiaari jiyanooshano nojori quiniuria Pueyaso niquiara, taa supuetana Moisés rootaquiaaricuajani. Nojoriiri naa miiquiaari juhuajaniya nojori queranacunura Pueyaso niquiara Pascua juuca. ");
INSERT INTO arlNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pueyari tii Jesu pajenuuriquiaa. Pueyaso Secojojua tiajinia nojori quishacari, nojoriiri tama nequesoreetooriquiaajaaja: —¿Taa nia sequeyani? ¿Pa queranacunujinia niniutianiyatenojotij, maja soj? ");
INSERT INTO arlNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pueyacuara secojonaa jiyaniijianucua, Fariseocuacanio, nojoriiri tari pueya rootaquiaari, tamonu pueyano jaara niishiri tee Jesu quiyani, cuaara nojori numooteera nojori quiatenura Jesu. ");
INSERT INTO arlNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis juuca jaara cureeriquiaajaa Pascua juucara, canaari jiyacari Jesuta Betania tiacajinia quiaareeni, Lázaro quijia tiacajinia, teyano Jesu samiitianiquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Cuno tiacajinijinio Jesu rupuenaa pueya timitiasacari Jesu, nojoriiri sumatunuuquiaari nojori miaquenuunura cuno niucua Jesuta. Martaari miaquesano patootariquiaa pueyara. Lázaroori Jesuta miaquenuuriquiaa narta masuusano pueyata, canaatanio. ");
INSERT INTO arlNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jiyacaritij, Maríari Jesuucuara pataree na shanohua jaanutaja. Cunoori “nardo” jiyanishano nataujiniji shipinishano quiquiaari. Jiyanohua queraatia cumaneecata masesano. Puereetuuca motiiquio cajiniocua puecariquiaari cuno shanohua jaanutaja. Maríari Jesu niohuacaacua na totaree. Na nuhuaji, na sacuanijiarohua na muecacataari. Puetunu tiacojuanaari shanohua jaanuriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Naa María miishacaritij, niquiriyatu canaajinijinio Jesu saquiriojosano pueyanoori juaarii. Nojuajaari Judas Iscariote quiriquiaa, na nuhuaji Jesu quiatequiaari na paraani. Nojuajaari naa sequeree: ");
INSERT INTO arlNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Casaara cuno shanohua jaanutaja niquitioyaquishaaree queraatia cumaneecarani, casamiijiuniucua pueya niquitiojosocoriquianoni? ¡Jaara masenu panishaare, maara niquitiosaare juhua niquiriyatu marijiara pueyano poonijionu sami! ");
INSERT INTO arlNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Naa Judas sequesacaritij, majaari seetanujuanaa na taraajenu quiriquiaa casamiijiuniucua pueyacua. Naa sequereeri saaja cumaneecaacua jiaatiaja na quiniuucua, nohuasejojua na quishacari. Judasri cumaneeca quiquio cojuatana quijia puetunu canaarajanaa. Naacuajitij, nojuajaari tiji nohuasejojua, pueya niquitiojosanojiniji canaara. ");
INSERT INTO arlNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesuuri saaja Judas sequeree: —Nareja quia niquiri. Nojuajaari nio shanohua jaanutaja cojuataja pueyaracaanu, juhuacarijia na jeenucuatajara cua cuaqueya, pueya niaaquishacarijia janiya raajinia, janiya jaara mosaareni. ");
INSERT INTO arlNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Casamiijiuniucua pueyari pueyaracaanu niaata quiriquiano cutara. Saniniuujia, janiyari maja pueyaracaanu niaata quiriquianoni. ");
INSERT INTO arlNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Queraatia canaa Judiocuacaari niishiquiaari Jesu Betania tiacajinia quiriquiaa. Cunora, nojoriiri nocua quiojoquiaari na niquiniuucua, Lázaro niquiniuucuajuhuaj, teyano Jesu samiitianiquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Jesu samiitianiniuucua Lázaro, queraatia canaa Judiocuacaari Jesuucua tiuuquiaari, na pueya nojori quiniuria. Cunora, canaa pueyacuara secojonaa jiyaniijianucuaari roojotooquiaari Lázaro na motunurajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Cuno queraatia pueya, tari Jerusalén tiacajinia quiriquiaacuaa Pascua juucara queranacunurani, nojoriiri niishiquiaari Jesu tariqui tiuquiniutianiyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nocuaji, nojoriiri tucuru piyotaree. Na nuhuaji, nijiyareeri Jesu naacunuucua, na tucuru shiiniotanuuriquiaari. Naa nacooriquiaajaariuhua nojori shuquiritiasacari Jesu: —¡Pocuaji Tacuna! ¡Pocuaji Tacuna! ¡Cuaara shuquiriaatia quiiria pa Jiyaniijia, teyano Pueyaso jiyaroquiaari pocuacuajani! ¡Nojuacuajaari Israel pueya Jiyaniijiajanaa! ");
INSERT INTO arlNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesuquiiri jiyacari burro niquiojua riuriatamaa. Tari na nijinia cajiriquiaari, taa tariucuacaanu Pueyaso Rupaajinia naajiotasano quiyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Naa sequeyari: “¡Sión tuhuananuucua quiniaa pueyanaa, maja puerenu! ¡Nia niquiri! ¡Nia Jiyaniijia cumaji niya niaacua! ¡Burro niquiojua nijinia cajiyari!” ");
INSERT INTO arlNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jiyacaritij, majaari canaa niishiniu quiriquiaa naa canaa tiuquitishacari canaa Jiyaniijia Jesutej, canaari nio tariucuacaanu Pueyaso Rupaajinia naajiotasano tohuateeriquiaani. Pueyaso jaara Jesu samiitianiquiaariuhua, canaari jiyacari shusha niishiquiaarini cuno naajiotasanoquiiri Jesujiniji quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Cuno pueya, Jesu samiitianishacari Lázaro niquiquiaarini, nojoriiri pueya pohuatariquiaa taa Jesu jiiquiooquiaari Lázaro na raacoji na tohuatanurani. ");
INSERT INTO arlNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Queraatia pueya niishishacari naa Jesu miishano na cumaacatatej, nojoriiri Jesu naacunuucua nijiyaree. ");
INSERT INTO arlNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nocuaji, Fariseocuacaari tama sequetooriquiaajaaja: —¡Canaacuajaari cunora nia sequequiaani pa morejanaa! ¿Niaate na niquiya? ¡Puetunu pueyajanaari cuno pueyanoocua pacuree, na pueya nojori quiniuria! ");
INSERT INTO arlNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Grecia jiyajinijinio taucuacaari Jerusalén tiacajiniara nijioquiaarijiuhuaj Pueyaso niquiara nojori queranacunuunura Pascuara. ");
INSERT INTO arlNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Cuno pojoriiri canaa cojinia Felipeecua catecanoquiaari. Felipeeri Betsaida tiacajinijinio quiquiaari. Cunoori Galilea jiyajinia tiaca. Cuno Griegohuari Felipe sequeturee: —Pueyanonaa, canaa quia Jiyaniijia Jesuta pocoojonu paniyani. ");
INSERT INTO arlNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jiyacaritij, Felipeeri Andrés sequesee cuno pojori sequesano nojuaja. Na nuhuaji, Andrésri Felipeta quiaaree Jesuucua. Nojoriiri Jesu pohuataseejuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesuuri naa nojori riucuaree: —Quiarijiani, tama janiyajaarijia mosaanutaniya pueya nitini. ");
INSERT INTO arlNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Seetanujuanaa nia sequeyanijia, sohuajajau jaara raama jataaquishaare, pueyaracaanu niquijiajau quiniutianiyari. Saniniuujia, jaara natasaare juhua na moquenura, saaja moritianutaniyari queraatia na muetunura. ");
INSERT INTO arlNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Naajuhuaj, cante tama na cuaqueyajaaja panijia puerani, nojuajaari puetunu shaajenutaniyajanaa. Saniniuujia, cante tama na cuaqueyajaaja panitiaja na tojiniuria janiya mijiriani, nojuajaari pueyaracaanu shuquiriaatia rishijiara jiyatesaanutaniya. ");
INSERT INTO arlNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Cante quiria poonijionu paniyani, cuaara seetanujuanaa cua tojijia quiiria. Tee cua quiniutianiyacuaani, cua tojitiajacaari tii quiniutianiyajuhuaj. Cua Queeri cua tojijiaca timitianutaniya. ¡Jiyanohua maninia nojori miiniutianiyajaariuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Quiarijiani, janiyari jiyanohua tacayani. ¿Casaa cua sequeyarini? ¿Janiyate sequeya soj: “Cua Quenaa, maja naquiya cua miitiniu”? Maja. Maja naa cua sequenu quiniutianiya. Janiyacuajaari cunora niquiaari mijiriani. ");
INSERT INTO arlNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","¡Cua Quenaa, janiya cuaara miishiiriaqui taa quia paniyacuajani, pueya niishiniuria quiaari jiyanohua maninia! Jiyacaritij, Pueyasoori tojishaaree pocuaano jiyocuacaanuji. Naa Neyanu sequereeri: —Janiyacuajaari naa niishitirii pueyani, pueyaracaanu quia miishacari cua panishano. Janiyari socua pacutenutaniuhua pueya niishitiniuni, quiaa jaara nojoriicuara mosaare. ");
INSERT INTO arlNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Cuno pueya, canaata tii quiriquiaa Jesutani, nojori tojishacari Pueyaso pocuaano, nojoriiri sequeturee: —¡Miacanacuaja cuno tojishaareeni! Tamasacaari saniniuujia sequereecujua: —¡Pueyaso serucuaja nocua pocuareeno! ");
INSERT INTO arlNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Saniniuujia, Jesuuri canaa sequeree: —Cuno rupaa niaa na tojiriini, majaari quiria na quiniu quiriquiaa. Cunoori nia tojishocoriquiano quiriquiaa, nia niishiniuria cua Queeri cua tojiquiaa cua secojosacari nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Quiarijiani, mijiria quiniaa miishacari naquiya janiya, nojoriiri saniniuujia saniitiosocoriquiano jiyatesaaree tari. Naajuhuaj, mijiria jiyaniijia Sesaacaari jatasaanutaniyajuhuaj, maja cumaacaraca na quiniuria socua. ");
INSERT INTO arlNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Janiya jaara nujuaretasaareni, janiyari puetunu pueyapuejanaa nijiotenutaniya cucuani. Nojoriiri juhua jaatiasaanutaniya cucua, cucua nojori tiuuniuria, nojori ruuretanura janiya soj. ");
INSERT INTO arlNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Naa Jesu sequesacaritij, canaa niishitiriiri taa pueya monutaniya nojuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tii quiniaa pueyari na riucuaree: —Canaacuajaari tariucuacaanu Pueyaso Rupaajiniji niishiyani, Pueyaso Jiyarosocoriquiano Cristoori pueyaracaanu rishiriquiano cutara. Quiajaniyarijiataj, ¿casaara quia sequeyarinijia, Pueyaso Jiyarosanoori nujuaretasaanutaniya tii na cusonura? ¿Canteeri cuno pueyanoni, quiaa na sequeya Pueyaso Jiyarosanoni? ");
INSERT INTO arlNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesuuri nojori sequeree saaja: —Janiya, nioojia cuhuatanani, janiyari niaata quiniutianiyajaara rupaquijiani. Nocua nia tiuuri juhuacarijia, ninishiqui quiyaquishacarijia. Cante ninishiqui rucuanejojuani, nojuajaari maja na niishiniu tee na quiaani. ");
INSERT INTO arlNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nioojia cuhuatanaacua nia tiuuri, niaata cua quishacarijia, seetanujuanaa cuhuashiqui quijiaca nia quiniuria. Naa Jesu sequenu nuhuaji cuno pojoritij, quiacuhuari. Nojoriicuaji jamaashiiri. ");
INSERT INTO arlNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesuuri jiyanohua queraatia jiyajeneta na cumaacata miishano miiquiaari pueya niquiara. Nojoriiri saaja nocua tiuyaquiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Naacuajitij, tariucuacaanu Pueyaso sequenu panishano caminiujiunia Isaías pohuatasanoori tohuateequiaari, nojuaja jaara naa sequequiaari: “Jiyaniijianaa, ¿cante canaa pohuatasanoocua tiuuriini, canaa pohuatasacari quia Jiyarosocoriquianojinijini? ¡Shaaqui! ¿Cante niishiriijiaaniuhuaj, jiyajeneta casaa nojori niquishanoori seetanujuanaa quia cumaacata miishano quiriquiaa? ¡Shaaqui!” ");
INSERT INTO arlNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Naacuajitij, majaari nojori naata tiuuniu quiquiaari Jesuucua. Isaíasri naa naajiotaquiaarijiuhuaj: ");
INSERT INTO arlNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pueyasoori nojori jiyateree juhua nimishitiuria, maja nojori niquiniuria na namijiata. Nojori niishitiaja cushitioreejaariuhuaj, maja nojori niishiniuria nojori jiuujiata. Naa nojori miiriiri maja nojori tacatonura nojori jiuujia, cua jiyanooniuria nojori, quiarinio pueyara cua jataniyaquiniuria nojorijiuhuaj”. ");
INSERT INTO arlNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Supuetana Isaíasri naa caminiujiuquiaari Pueyaso niishitishano nojuajatej, Jesu na niquiniuucua na shacantuuca cumaacajinia quiyano. Naa na pohuatasacaritij, nojuajaari juhuacarijia Jesujiniji pohuatariquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Naajaa, queraatia narta Judiocuacaari Jesuucua tiuuquiaari. Queraatia canaa jiyaniijianucuaari nocua tiuuquiaarijiuhuaj. Cuno jiyaniijianucuaari maja na pohuatanu quijia pueya niquiara, Jesuucua tiuujiaca nojori quishacari. Nojoriiri na pohuataaquijia, Fariseocuaca na pueretusacari, Fariseocuaca mariqui nojori tenujureeri maja socua nojori tiuquitianura Pueyaso secojojua tiacajinia. ");
INSERT INTO arlNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nojoriiri saaja narta pueya shuquiritiasano pueya quiniu panijia, maja Pueyaso shuquiritiasano cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesuuri jiyanohua na rupaa paaretaree. Naa sequereeri: —¡Cante cucua tiuuriini, majaari saaja na tiuuniu cucua! ¡Cua Queecua tiuuriijiaariuhuaj, cante cua jiyaroquiaaricuajani! ");
INSERT INTO arlNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","¡Cante cua niquiriini, nojuajaari cua Jiyarona niquiriijiuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Janiyari mijiria niquiaarini cua cuhuatanura niajaniya. Naacuajitij, cante cucua tiuuriini, majaari tari na quiniu ninishiqui. ");
INSERT INTO arlNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pueyano jaara cua rupaa tojiriquia najuhuanaj, janiyajanaari maja nocuara cua saquiriojotanu quiniutianiya na saniitiosaanura. Majaari cua niniu quiquiaari mijiria, pueya cua saniitionura. Janiya cutaraari niquiaarini nojoriicuaji cua tacunura. ");
INSERT INTO arlNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Cante cua ruuretaja saajani, cua sequesano tojiyaquiyajaariuhuaj, nojuajaari tari nocuara saquiriojotana jiitiaa na saniitiosaanura. Nojoriria cua sequesano cutaraari tama nojoriicuara saquiriojotariquianojuaaja nio jiya puequesacari. ");
INSERT INTO arlNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Cua pohuatasanoori maja tama cua niishishanojuaaja. Cua Jiyarona cua Quecuajaari cua niishitiquiaa casaa cua sequenutaniyani, mariyata casaa cua niishitiojonutaniyani. ");
INSERT INTO arlNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Janiyari niishiyani cante cua Que rupaa tojijiani, nojuajaari pueyaracaanu quijia quiniutianiya cutara. Naaratej, janiyari seetanujuanaa saaja na sequesano caminiujiuquiaani, taa na niishitiquiaa janiyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Jesuuri canaa na saquiriojosano pueyata rerejoquiaari Pascuaacuara juucajinia. Jesuuri jiyacari niishiquiaari tari quiquiaariiri quera na tiujiasacari canaa mijiria, na Queecua na tacanuhuara. Nojuajaari canaa paniriquiaajaa, taa canaa na paniquiaari pueyaracaanucuajani, mijiria na quishacari canaata. ");
INSERT INTO arlNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Cuno niucuaja, Jesuuri canaa na saquiriojosano pueyata miaqueriquiaa. Sesaacaari tari Judas Iscariote niishitirii noojiajinia, nojuaja cuaara Jesu quiateera na paraa, na mosaanura. Cuno Judasri tamonu Simón jiyanishano pueyano niyanu quiquiaari. ");
INSERT INTO arlNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesuuri niishijia nojuaja seetanujuanaa Pueyasojiniji niquiaari. Naajuhuaj, nojuajaari niishiquiaari, na Que Pueyasoori na jiyatequiaari Jiyaniijiarajanaa, puetunu casaa jiitianajanaa na quiniuria. Niishiriquiaajaariuhua nojuajaari quera na Queecua tacanutaniuhua. ");
INSERT INTO arlNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jiyaniijiajanaa na quishacari, naajaa, nojuajaari miaquejajiniji sanequiaari. Na tucuaque toque jocuareeri. Na nuhuaji na cajiniocua camarucuteree cuaqueya tuujutajaari. ");
INSERT INTO arlNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Na nuhuaji, mohuaca shuurii tohuatashijiniaari. Canaa niohuaca jeequejoriquiaari juhua tiaco seru. Na nuhuaji, na sacuanijiariquiaajaariuhuaj na cajiniocua na camarucutesano cuaqueya tuujutajata. ");
INSERT INTO arlNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na jeequenu panishacari Simón Pedro niohuaca, Pedroori saaja Jesu sequeree: —Jiyaniijianaa, ¿taa quia miyani? ¿Quiaateeri cua niohuaca jeequenutaniya? ");
INSERT INTO arlNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesuuri Pedro riucuaree: —Quiarijiani, majaari quia niishiniu casaara naa cua miyani. Naajaa, quiaacuaja na nuhuaji niishiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedroori Jesu sequeree: —¡Cua Jiyaniijianaa, janiya cutaraari maja quenaaja cua shanacunu quiniutianiya cucua quiajaniya, cua niohuaca quia jeequenura! Jesuuri na riucuaree: —Janiya jaara quia niohuaca jeequejiyaquirini, majaari cua pueyano quia quiniu quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedroori na sequeree: —¡Jaara naa quiritij Jiyaniijianaa, maja saaja cua niohuaca jeequenucuarajaj! ¡Quia jeequerejuhua cua juaashiquiaca, cua nacanio! ");
INSERT INTO arlNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesuuri na sequeree: —Cante shusha nanajani, saaja na niohuacaari jeequeshiya cutara. Na cuaqueyacuajaari tariucua jeequesano quiya. Puetunu niajaniyajanaari tari jeequejosano quiyacuaja. Saa niquiriyatujuaari jeequesoo quiya saniniuujia. ");
INSERT INTO arlNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesuuri tari niishiquiaari cante na quiatenutaniya na paraani. Nocuaji sequeriquiaari: “Niquiriyatu pueyanoori jeequesoo quiya cutara”. ");
INSERT INTO arlNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Canaa niohuaca na jeequejonu nuhuaji, Jesuuri na toque cushiriohua. Miaquejajinia cajiriohuari. Canaa nequesotareeri: —¿Niaate niishiya casaara naa cua jeequejoree nia niohuacani? ");
INSERT INTO arlNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Niaacuajaari cua sequequiaa “Niishitiojonata”, nia “Jiyaniijiatanio”. Seetanujuanaa nojuacuajanijia, taa nia jiyaniquiquiaa janiyacuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Naaratej, janiya jaara jeequejoree nia niohuacacuaani, nia Jiyaniijia cua quishacari, nia Niishitiojonajuhuaj, naa nia miiriquia niarta Pueyaso muerasujuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Janiyari naa miiriini, cua niishitiojonura niajaniya, naa nia miitioonurajuhuaj taa cua miirii niajaniyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Seetanujuanaa nia sequeyanijia, seruuri maja socua tojishano quijia na camarnujiniji. Naajuhuaj, jiyarosano pueyanoori maja socua tojishano quijia na jiyaronajiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Niaa jaara cua rootasano niishiri, niaari shuquiriaatia quijiaca quiniutianiya niaa jaara na tojijiaca quiri. ");
INSERT INTO arlNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Shusha cua sequesano niajaniyani, cunoori maja puetunu niajaniyaranojuanaa. Janiyacuajaari niishiyani canapue cua saquiriojoquiaarini, taamueca pueyate niajaniyani. Naacuajitij, tariucuacaanu Pueyaso Rupaajinia janiyajiniji naajiotasanoori tohuateenutaniya. Naa sequeyari: “Tama cuata miaquenajaarijia cua paracara quirii”. ");
INSERT INTO arlNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Janiyari juhuacarijia nia toyani. Naacuajitij, cua pohuatasano jaara tohuateere, niaari niishiniutianiya janiyari seetanujuanaa Pueyaso Niyanuni. ");
INSERT INTO arlNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Seetanujuanaa nia sequeyanijia, cante cua jiyaramiquishano pueya tojijiani, nojuajaari cua tojiyajuhuaj. Cante cua tojijiara quiriini, nojuajaari cua Jiyarona tojijiara quiriijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Naa Jesu sequenu nuhuaji canaatej, jiyanohua na taraajenuta naa canaa sequereeri: —Seetanujuanaa nia sequeyanijia, niquiriyatu niajaniyajinijinioori cua paraa cua quiatenutaniya. ");
INSERT INTO arlNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Canaari jiyacari tama niquitiooreejaanijia. Majaari canaa niishiniu quiriquiaa canajiniji naa Jesu sequeriquiaani. ");
INSERT INTO arlNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jiyacaritij, janiyari na shuriucuaji cajiriquiaa miaquenuujuajiniani, na panishano pueyano cua quiniuucua. ");
INSERT INTO arlNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Naaratej, Simón Pedroori cua mashiniquirii sanaa cua nequesotanura Jesu, canajiniji naa na sequereeni. ");
INSERT INTO arlNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Naarate janiyari Jesuucua tatereeni, jiyasohuaja cua nequesotanura nojuaja. Janiyari naa na sasacareeni: —Jiyaniijianaa, ¿canteeri naa quia miiniutianiyani? ");
INSERT INTO arlNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesuuri cua riucuaree: —Janiyari pan rau piquiojonutaniya caacajiniani. Cana cua niquitionutaniyani, nojuajaari cuno. Jesuuri jiyacari pan rau piquiojoree. Judas Iscariote na niquitioreeri. Nojuajaari tamonu Simón jiyanishano niyanu. ");
INSERT INTO arlNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas masesacari cuno pan rau, Satanásri noojiajinia tiuquiquii. Jesuuri jiyacari Judas sequeree: —Cuno, quiaa na niishiriojiya miiniuni, quiocua ritia miirinioj. ");
INSERT INTO arlNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Canaa na saquiriojosano pueya nata miaquenuuriquiaani, majaari quenaaja canaa niishiniu quiriquiaa casaara naa Jesu sequeree Judasni. ");
INSERT INTO arlNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judasri canaa cumaneeca cojuatana quijia. Naaratej, noojiaqueya canaajinijinioori jiyaniriquiaani Jesu naasucua na jiyaroriquiaa socua casaa na masenura canaa queranacunuutajara, casamiijiuniucua na niquitiojonura cumaneeca soj. ");
INSERT INTO arlNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas jaara masequiaari Jesu niquitiosano pan, jiyacari tohuataqueeri. Tariucua niucuaari quiriquiaa. ");
INSERT INTO arlNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas tohuatanu nuhuaji, Jesuuri canaa sequeree: —Quiarijia cua miishanojiniji, janiyari maniniuhuaqueetasaanutaniyani. Pueyasoori jiyanohua maniniuhuaqueetasaanutaniyajuhuaj, naa cua miishanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Pueyaso jaara maniniuhuaqueetasaare naa maninia cua miiniuucuatej, nojuajaari cua jiyatenutaniya cumaacaraca quijia cua quiniuria na shuriucua. Quera naa cua miiniutianiyari. ");
INSERT INTO arlNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Quiquiohuaniyojuanaa, janiya rupaquijia niaata quiniutianiyajaarani. Taa cua sequecanu parta Judiocuacacuaani, janiyari naa nia sequeyajaaniuhuaj. Niaari cua pajenuunutaniya juucua. Majaari nia naata quianu quiniutianiya cucua, tee cua quianutaniyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Quiarijia nia niishitiriiria nio quiarinio rootasano. Nia tojiri. ¡Panitioojuaca nia quiri! Naatej, taa cua paniquiaacuaa niajaniyani, naa nia panitioorejuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Niaa jaara naa panitioojuaca quiri, puetunu Pueyaso niishiyashijiaca pueyajanaari naacuaji niishiniutianiya, niaari cua tojitiajaca pueya. ");
INSERT INTO arlNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedroori jiyacari Jesu nequesotaree: —Jiyaniijianaa, ¿tee quia quianutaniyani? Jesuuri na riucuaree: —Tee cua quianutaniyacuaani, majaari quia naata nuhuajiniu janiya. Naajaa, quiaari na nuhuaji quiariquiano. ");
INSERT INTO arlNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedroori na sequeree: —Jiyaniijianaa, ¿casaara quia sequeyarini, quiarijia cutara maja cua naata quianu quiata? Janiyacuaja tama cua cuaqueyajaaja tarinijiotaaree quiocuarani. ");
INSERT INTO arlNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesuuri na riucuaree: —¿Naatee? ¿Quiaate tama quia cuaqueyajaaja tarinijiotaaree cucuara? Janiyari seetanujuanaa quia sequeyani: juhuaquenu panishacari caacaraja niunijiyaquishacarijia, quiaari jiyacari cucuaji seetanu pacutejonutaniya tari. ");
INSERT INTO arlNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesuuri naa canaa sequeree socua: —Maja nia tacaaniu, pueyanaa. Nioojia nia cajitiri. Saaja Pueyasoocua nia tiuuri. Cucua nia tiuurijiuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cua Que tiaari puereetuuca. Queraatia quiquioori tii quiya. Cunora, janiyari coteenu nia puetanutaniyani, niaacuaji cua jeenucuanura nia quijiara. Jaara naa quiyaquiritij, janiya maara nia sequeyaquirini janiya nia puetanutaniyani, niaacuaji cua jeenucuanura. ");
INSERT INTO arlNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Cua jeenucuanu nuhuaji nia quiquiora, janiyari niaacua tacatenutaniuhuani, cua rijionuhuara niajaniya, cuata nia quiniuriajuhuaj tee cua quiniutianiyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Niaacuajaari cua quiquiojiniara neteja nuu niishiya, tee cua quianutaniyacuaani. ");
INSERT INTO arlNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomásri Jesu sequeree: —Jiyaniijianaa, ¡maja canaa niishiniu quenaaja tee quia quiaani! ¿Canaatucua taa cuno nuu niishirini, quiaa na sequeyani? ");
INSERT INTO arlNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesuuri na riucuaree: —Janiyacuajaari cuno nuuni, Pueyasoocua nia quianura. Janiyacuajaari seetanujuanaa Pueyaso Rupaani. Janiyari pueya samiitianijiajuhuaj. Majaari pueya naata Pueyaso rupuenu tamajaaja. Saaja janiya cutaraari pueya rupueteja Pueyasoni, nojori tiuushacari cucua. ");
INSERT INTO arlNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Niaa jaara seetanujuanaa cua niishiquiaaricuaa, niaa maara cua Que niishirijiuhuaj. Seetanujuanaa, niaari tari na niishiyacuaja. Niaari na niquiquiaajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipeeri na sequeree: —Jiyaniijianaa, quiaa jaara canaa niquitiri quia Que Pueyaso, canaacua panaatia quiriohuani. ");
INSERT INTO arlNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesuuri Felipe riucuaree: —Felipenaa, janiyacuajaruhua pueyaracaanu niaata quiquiaa juucuani. ¿Majateeri juhuanojuaja quia niishiniu janiya? Cante cua niquiquiaani, cua Que niquiquiaajaariuhuaj. ¿Casaara quia sequeya cua niquitiniuria cua Que niajaniyarini? ");
INSERT INTO arlNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Majateeri quia tiuuniu cucua cua sequesacari quiajaniya, janiyari cua Que jiuujiajinia quiyani, cua Queeri saniniuujia coojiajinia quiyacujua? Canaari maja rimiajatani. Nio, cua sequesano niajaniyani, cunoori maja tama cua niishishanojuaaja. Cua Que, coojiajinia quiyani, nojuajaari na panishano miitiquiaa janiya. ");
INSERT INTO arlNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Cucua nia tiuuri cua sequesacari niajaniya, janiyari cua Que jiuujiajinia quiyani, cua Queeri saniniuujia coojiajinia quiyacujua. Niaa jaara cua sequesanoocua tiuuniu paniyaquiri, cucua nia tiuuriqui na cumaacata cua miiniuucua nia niquiara. ");
INSERT INTO arlNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Seetanujuanaa nia sequeyanijia, cante cucua tiuujiani, nojuajaari puetunu cua miishanojuanaa miiniutianiyajuhuaj. Cua tacasacariuhua cua Que shuriucua cua quiniuhuara, cucua tiuujiacaari cua cumaacata seetanujuanaa socua jiyajeneta casaa miiniutianiya cua miishanojiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Seetanujuanaa nioojiajinia cua quishacari, janiyari niaara miiniutianiyani puetunu nia masesanojuanaa nia secojosacari cua Que. Naacuajitij, pueyari cua Que timitianutaniya, nojori niishishacari cua Queeri jiyanohua maninia miijia. ");
INSERT INTO arlNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nioojia rupuetoosacari coojiata, janiyari puetunu nia masesanojuanaa miiniutianiya niaarani. ");
INSERT INTO arlNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Niaa jaara seetanujuanaa cua panijiaca quiri, niaari cua rootasano tojitiajaca quiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Naajuhuaj janiyari cua Que secojonutaniyani, niaacua na jiyaronura tamonu cua niti mijiria, nia cumaquiriquiano. Nojuajaari pueyaracaanu niaata quiriquiano. ");
INSERT INTO arlNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nojuajaari Pueyaso Sohuanu, seetanu rupaa jiitianajanaa. Pueyaso tojiyashijiaca pueyari maja na naata cuno Sohuanu na jiitianu, nojori niquiyaquiniuucua nojuaja, na niishitiuyaquiniuucua nojuajuhuaj. Niaa cutaraari na niishijiaca. Nojuajaari niaata quiyacuaja. ¡Pueyaracaanu nioojiajinia quiriquianojaariuhuaj! ");
INSERT INTO arlNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Majaari seetanujuanaa cua tiujianu quiniutianiya niajaniya juhua japueyojuaca nia quiniuria. Janiyacuajaari tacatenutaniuhuani niaata cua quiniuhuara. ");
INSERT INTO arlNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pueyaso tojitiaashijiaca pueyari quiari naataja cua niquiyaquiniutianiya socua. Niaa cutaraari cua niquijiaca quiniutianiya. Samiitianijiojua cua quiniuucua, niaari pueyaracaanu quijiaca quiniutianiyajuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jiyacaritij, niaari niishiniutianiya janiyari cua Que jiuujia rupuejani, niaari coojia rupuejacajuhuaj. Janiyari saniniuujia nioojiajinia quijiani. ");
INSERT INTO arlNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Cante cua rootasano niishijiani, nojuaja jaara na tojijia quirijiuhuaj, nojuajaari cua panijia cutara. Cante cua panijiani, cua Queeri na panijia quiniutianiyajuhuaj. Janiyari na panijia quiniutianiyajuhuaj. Janiyari cua panijiaacua niniutianiyani, seetanujuanaa na niishiniuria janiyari nata quiyani. ");
INSERT INTO arlNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Canaa cojinia Judasni, nooj, Judas Iscariote sesaanucuatej, nojuajaari Jesu nequesotaree: —Jiyaniijianaa, ¿casaara saaja canaacua quia niniutianiyarini, maja puetunu mijiria quiniaa pueyacuajanaa? ");
INSERT INTO arlNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesuuri na riucuaree: —Cante cua panijiani, cua rootasano tojijiajaariuhuaj. Cua Queeri jiyano pueyano panijia. Naaratej, canaari nocua niniutianiyani, noojiajinia canaa quiniuria, canaa quiquiora canaa jiyatenura nojuaja. ");
INSERT INTO arlNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Saniniuujia, cante cua paniyaquijiani, jiyano pueyari cua rootasano tojiyashijiacajuhuaj. Puetunu cua rootasanojuanaa, niaa na tojiquiaani, cunoori maja tama cua niishishanojuaaja. Cunoori cua Que niishitishano janiya, cante mijiria cua jiyaroquiaaricuajani. ");
INSERT INTO arlNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Janiyari puetunu niojuanaa nia pohuataani, niaata cua quishacarijia mijiria. ");
INSERT INTO arlNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Cua Que jiyarosocoriquiano na Sohuanuuri nia cumaquiriquiano. Nojuajaari nia niishitiojonutaniya puetunu cua niishitionu panishanojuanaa niajaniya. Naajuhuaj, nojuajaari nia niishitiniutianiuhua puetunu tari cua pohuatasano niajaniyajanaa. ");
INSERT INTO arlNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Janiyari nioojia cajitiniutianiyani. Janiyari coojia nianutaniya nioojiajiniani, juhuajaniya quijiaca nia quiniuria taa cua quiyacuaani. Naacuajitij, niaari seetanujuanaa juhuajaniya quiniutianiya. Mijiria quiniaa pueyari maja na niishiniu cumanijianu juhua janiya. Naaratej, maja nia tacaaniu. Majaari puerenujuhuaj. ");
INSERT INTO arlNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tari nia sequereecuajanijia: “Janiya quera quiohuani. Janiyari na nuhuaji tacatenutaniuhuani niaata cua quiniuria”. Niaa jaara seetanujuanaa cua panijiaca quiriquia, niaa maara shuquiriri nia niishishacari janiyari cua Queecua quiohuani. Nojuajaari seetanu Jiyaniijiajanaa cutara janiyajiniji. ");
INSERT INTO arlNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Janiyacuajaari juhuacarijia nio nia sequeyani. Naacuajitij, niaa jaara niquiri tohuateyano cua sequesano niajaniya, niaari niishiniutianiya puetunu cua pohuatasanojuanaari seetanujuanaa. ");
INSERT INTO arlNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Majaari puera cua pocoojonu quiniutianiya niaata tari. Cua Paraca cucua quenaacoya tarini, na miiniuria janiya taa na paniyacuajani. Nojuajaari Pueyaso tojitiaashijiaca jiyaniijia. Pueyaracaanu cua Que Pueyaso tojijia cua quiniuucua, cua Paraca maara naquiya cua miyaquiri janiya jaara cucua na shanacuyaquirini. Na cumaacaari maja na shocotanu cua cumaaca cutara. ");
INSERT INTO arlNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Naajaa, na miishanojiniji janiya, puetunu pueyajanaari niishiniutianiya, janiyari puetunu cua Que sequesanojuanaa tojijiani, na panijia cua quiniuucua. ’Nia sanetare. Niiquiji pa quiaare. ");
INSERT INTO arlNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesuuri naa pohuataquiaari socua canaa niquiara: —Janiyari juhua uva jiyonani, cua Que natau. ");
INSERT INTO arlNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Cua pueyari juhua cua cashacucua. Tamonu cua cashacucuajinijinio jaara muetuyashijia quiri, cua Queeri na piyotaja. Teyano cua cashacucuajinijiniote muetujua saniniunijia, cua Queeri na nacareetaja, socua queraatia na muetunura. ");
INSERT INTO arlNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nia tojiniuucua cua rootasano, niaari tari juhua nacareetasano quiya. ");
INSERT INTO arlNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pueyaracaanu coojia nia rupuere, taa cua rupueya nioojiacuaani, niaa mariqui juhua uva cashacucua piyotasaareeri. Jaara neyonaacuaji piyotasaare, majaari na naata muetunu tari. Naajuhuaj, majaari nia naata muetujua quiniu, niaa jaara coojia rupueyashijiaca quiri. ");
INSERT INTO arlNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Janiyari juhua nia jiyonani. Niaari juhua cua cashacucua. Cante coojia rupuejani, taa cua rupueya niajaniyacuaani, naacuajitij, niaari juhua queraatia muetujuaca quiniutianiya. Cucuaji rupatejacaari maja na naata casaa miiniu janiyaju. ");
INSERT INTO arlNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Cante cua rupueyashijiani, nojuajaari taraatia miishaanutaniya juhua uva cashacucua piyotasano neyonajiniji, tamocora jaquerootasano. Jaara sorere, tatucuasaarohuari manijinia quejoosocoriquiano. Tii cateyari. ");
INSERT INTO arlNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Niaa jaara coojia rupuejaca quiri, niaa jaara cua rootasano tojijiaca quirijiuhuaj, puetunu nia panishanoocuarajanaa nia secojore Pueyaso. Nojuacuajaari nia masesano miiniutianiya. ");
INSERT INTO arlNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Naa cua Que miishacari nia panishanotej, niaari juhua queraatia muetujuaca quiniutianiya. Naacuajitij, cua Queeri jiyanohua timitiasaanutaniya. Naacuajitij, niishishaanutaniyajaariuhua niaari cua tojitiajaca pueyaniyojua. ");
INSERT INTO arlNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Janiyari nia panijiani, taa cua Que paniya janiyacuaani. Coojia rupuejaca nia quiri pueyaracaanu, cua panishano pueya nia quiniuria. ");
INSERT IN