﻿USE sofia;
DROP TABLE IF EXISTS sofia.are_vpl;
CREATE TABLE are_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES are_vpl WRITE;
INSERT INTO are_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesua Kristanha David-aka 'lira naka, Abraham-aka 'lira turta. Nhanhantama yia nama Jesua Kristaka ramaramiperra. ");
INSERT INTO are_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham-anha Isaac-aka kaarta naka. Isaac-anha Jacob-aka kaarta naka. Jacob-anha Judah-aka kaarta naka, Judah-aka kanhanganhanga ntjarraka turta. ");
INSERT INTO are_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah-anha Perez, Zerah tharraka kaarta naka. Perez tharraka mia kunha Tamar-anha naka. Perez-anha Hezron-aka kaarta naka. Hezron-anha Ram-aka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram-anha Amminadab-aka kaarta naka. Amminadab-anha Nahshon-aka kaarta naka. Nahshon-anha Salmon-aka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon-anha Boaz-aka kaarta naka. Boaz-aka mia kunha Rahab-anha naka. Boaz-anha Obed-aka kaarta naka. Obed-aka mia kunha Ruth-anha naka. Obed-anha Jesse-aka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse-anha king David-aka kaarta naka. King David-anha Solomon-aka kaarta naka. Solomon-aka mia kunha arrkutja nhangala naka, Uriah-alakimparra tnyinakala. ");
INSERT INTO are_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon-anha Rehoboam-aka kaarta naka. Rehoboam-anha Abijah-aka kaarta naka. Abijah-anha Asa-aka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa-anha Jehoshaphat-aka kaarta naka. Jehoshaphat-anha Jehoram-aka kaarta naka. Jehoram-anha Uzziah-aka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah-anha Jotham-aka kaarta naka. Jotham-anha Ahaz-aka kaarta naka. Ahaz-anha Hezekiah-aka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah-anha Manasseh-aka kaarta naka. Manasseh-anha Amon-aka kaarta naka. Amon-anha Josiah-aka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah-anha Jeconiah-aka kaarta naka, Jeconiah-aka tjia ntjarraka turta. Kanhanganhanga nhanha etna etatha nakala, leltjala relha Israel-arinya ntjarranha Babylon-urna naamalhelamalanga. ");
INSERT INTO are_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Israel-arinya ntjarra Babylon-anga pitjalpumaliperra, Shealtiel-anha katjia intaka. Kaarta ekura naka Jeconiah-anha. Shealtiel-anhantama Zerubbabel-aka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel-anha Abiud-aka kaarta naka. Abiud-anha Eliakim-aka kaarta naka. Eliakim-anha Azor-aka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor-anha Zadok-aka kaarta naka. Zadok-anha Akim-aka kaarta naka. Akim-anha Eliud-aka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud-anha Eleazar-aka kaarta naka. Eleazar-anha Matthan-aka kaarta naka. Matthan-anha Jacob-aka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob-anhantama Joseph-aka kaarta naka. Joseph nhanha era Mary-aka noa naka, Mary nhanga Jesuaka miakwia. Jesua nhanha erinha etna ilaka era Krista namanga. ");
INSERT INTO are_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham-anga David-akurtitja ramarama 14 naka. Kurunga David-angatjina, relha Babylon-arinya ntjarrala etnanha naamalhelitjinalakurtitja, ramarama 14 arrpunha naka. Kurunga Babylon ekuranga pitjalpumaliperra, Kristanha alkngerritjinalakurtitja, wotha ramarama 14 arrpunhantama naka. ");
INSERT INTO are_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nhanha yia nama Jesua Kristiperra. Nthakinhama era alkngerraka? Ngunhama kaarta pa mia ekuranha naka? Arai, Mary-aka kaartala, Mary-anha Joseph-aka lhelakala. Joseph eratharra pula itjantema noa inarrakalanga, Mary-anha katjiakarterraka. Erataka katjiakarterrakala, Enka Alkngaltara era ekururna irrpukalanga. ");
INSERT INTO are_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph-anha artwa kangkintja naka. Erantama itja antja naka noa ekuranha, Mary-anha, relha ntjarranga alkngatharra unputjika. Lakinhanga era eterraka erinha kala imputjikanta wara. ");
INSERT INTO are_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Era pula lakinha eterramalangantema, Altjirraka angel ekura rumerraka, era altjirraramalanga. Angel-ala erinha ilaka, “Joseph, David-aka 'lirai. Mary-anha kunpala inai noa ungkwanga nitjika. Erataka Enka Alkngaltaranga katjiakarterrakala. ");
INSERT INTO are_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Anma ekura worra katjia intitjina. Unta turtantama erinha rretnya Jesua ilitjika, era relha ekuranha ntjarranha tangkalhelitjinanga warta, korna etnakanha iwumala.” ");
INSERT INTO are_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lakinha Ingkartaka lhelintja nthurrperraka. Era nhanga relha ntjarranha imanka lhelakala, urrpia ekuranharlarlanga. ");
INSERT INTO are_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Arai, wonka katjiakarterritjina, ekura turta worra katjia intitjina. Etna turta erinha rretnya Immanuel ilitjina, nhanhatitja ‘Altjirra nurnakalela nama.’ ");
INSERT INTO are_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kaarrerramala, Joseph-anha kala angel ekura kangkwerraka. Era Mary-anha inaka noa ekura nitjika. ");
INSERT INTO are_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Era pula itja ekuralela intaka, katjia arrkurlinya ekuranha alkngerritjinalpula. Worra katjia ekura intamalangantama, era erinha rretnya Jesua ilaka. ");
INSERT INTO are_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesua era Bethlehem-ala, pmara Judea-ala alkngerraka Herod-anha king namalanga. Artwa inangkarla ntjarrantama ekngarranga pitjika Jerusalem-urna. ");
INSERT INTO are_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Etna Jerusalem-arinya ntjarranha pmarraka, “Nthanhama katjia ngurruka alkngerrakala era, erala relha Judah-arinya ntjarraka king nitjinala? Nurnataka ntheilpura ekuranha arakala ekngarrala, nurnantama pitjika ekura urrkurrkintja nitjika.” ");
INSERT INTO are_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Herod-ala nhanhiperra wumalanga era rwampia inthorrerraka, relha Jerusalem-ala namala ntjarra etna turta. ");
INSERT INTO are_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herod-anhantama priest-aka itornka ntjarraka, artwa Intarrangaltha ntjarraka turta ntangkalhaka. Era etnanha pmarraka, “Nthanhalama Krista era alkngerritjina?” ");
INSERT INTO are_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Etna erinha alpmelaka, “Bethlehem-ala kunha, pmara Judea-ala. Lakinha kunha Altjirraka urrpia imankinya arrpunhala intalhelakala, ");
INSERT INTO are_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Bethlehem-ai, pmara Judea-ala, unta town tjiparra nama Judea-ala. Ungkwanganga kunha artwa ilinpinya era pitjitjina. Erantama relha nukanha ntjarranha, Israel-arinya ntjarranha, tnairnitjina.’” ");
INSERT INTO are_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kurunga Herod-anha artwa inangkarla ntjarraka nyilknganyilknga ntangkalhaka. Erantama etnanha montjala pmarraka ilangara inthorra ntheilpura era rumerrakala. ");
INSERT INTO are_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kurunga era etnanha Bethlehem-urna yairnaka, angkatja nhanhakarta, “Arai, rrangkarra Bethlehem-akerramalanga, rrangkarra katjia ekura montjala yontharrirrai. Kurunga rrangkarra katjia erinha arltaramalanga, rrangkarra pitjalpumala yinganha ilai, yinga turta lhitjinanga ekura urrkurrkintja nitjika.” ");
INSERT INTO are_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","King ekuralela angkarramaliperra, artwa inangkarla etna wotha tjaiyakerraka. Ntheilpura nhanga etnala ekngarralakimparra arakala, erantama wotha rumerraka. ");
INSERT INTO are_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ntheilpura erinha aramala, etna arrkana inthorra naka. Ntheilpura erantama etnakanga arrkurlerramala iltha lenhanga kartninyala itnatjalhaka, ekurala katjia era intamanga. ");
INSERT INTO are_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Iltha ekururna pitjimalantama, etna irrpunhamala Mary-anha araka, katjia ekurakarta namanga. Etnantama mparalela arrarnalhamala, katjia ekura urrkurrkintja naka. Thauwa etnakanhantama altjurilamala, etna erinha tjauwerrilya nthaka, gold, frankincense, myrrh turta. ");
INSERT INTO are_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Altjirralantama etnanha parraka, etna altjirraramalanga, etna itja Herod-urna yiakarta alputjika. Etnantama tjaiya arrpunhala pmara etnakanhurna alpuka. ");
INSERT INTO are_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Artwa inangkarla etna kala alpukalangantama, Ingkartaka angel Joseph-aka rumerraka era altjirraramalanga. Angel-ala erinha ilaka, “Kamerrai! Manhanga ekuratharrakarta unta parrpa pmara Egypt-urna lhai, unta turta tanhala kuterrai atha nganha ilitjinalpula. Herod erakwia katjia ekura yonthitjina, erinha errilknga tutjika.” ");
INSERT INTO are_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph-anha kamerraka. Erantama ingulantema manhanga ekuratharrakarta parrpa tjaiyakerraka Egypt-urna. ");
INSERT INTO are_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egypt-akerramalantama, etna kala pmara ekuralantama kuterraka Herod era ilutjinalpula. Angkatja nhanhantama nthurrperraka, Altjirralala imanka relha ekuranha ntjarranha ilakala, urrpia ekuranharlarlanga, “Atha 'lira nukanha Egypt-anga ntangkaka.” ");
INSERT INTO are_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Artwa inangkarla ntjarraka yarna kaaralhamala, Herod-ala lhangkarakantama etna erinha orrtjapepilakala. Erantama aa kngarrerraka. Era tjapartia ekuranha ntjarranha Bethlehem-urna yairnaka. Era etnanha turnaka etna worra katjia ingkarraka errilknga tutjika, Bethlehem-ala, Bethlehem-anga etinya turta, etnala 2 years ingkwia namanga, kurrkalkura paka. Era tjapartia etnanha katjia ntjarriperra turnaka, arlta erinha etarlaramala, artwa inangkarla ntjarrala ntheilpura erinha arrkurla arakala. ");
INSERT INTO are_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Lakinha angkatja nhanga Altjirraka urrpiala, Jeremiah-ala, relha ntjarranha imanka ilakala, nthurrperraka, ");
INSERT INTO are_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Etna Ramah-ala ilkintja wuma, itnintja, nthorrkngerrintja kngarra turta. Rachel-anha katjia ekuranhaka itnima. Etna turta erinha yarna alkngolkngilama, katjia ekuranha yirrakalanga warta.” ");
INSERT INTO are_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod-anha ilukantama. Joseph era Egypt-alantema namalanga, Ingkartaka angel Joseph ekura rumerraka era altjirraramalanga. ");
INSERT INTO are_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Era erinha ilaka, “Kamerrai! Unta kala manhanga ekuratharrakarta pmara Israel-urna alpai. Relha lenha ntjarra etnala antjerrakala katjia erinha errilknga tutjika, etnataka kala itja wotha.” ");
INSERT INTO are_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kamerramala, Joseph-anha katjia ekurakarta mia ekuranhakarta turta tjaiyakerraka pmara Israel-urna alputjika. ");
INSERT INTO are_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pmara Israel-akerramala, Joseph-ala wuka Archelaus era kaarta ekuranha Herod-aka kathala king namanga Judea-ala. Erantama trerraka pmara Judea-urna lhitjika. Altjirrantama ekururna wotha angkaka era altjirraramalanga. Era erinha ilaka era pmara Galilee-urnatitja lhitjika. ");
INSERT INTO are_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilee-urnantama anpara lhamala, era pmara Nazareth-ala kuterraka. Lakinha Ingkartaka lhelintja nthurrperraka. Era nhanga relha ntjarranha imanka lhelakala, urrpia ekuranharlarlanga, “Etna erinha rretnya Nazarene ilitjina.” ");
INSERT INTO are_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","John Kaltjirrpulhelanhelanha erantama worritjurna lhaka, pmara Judea-ala. Tanhala era relha ntjarranha kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Era relha ntjarranha ilaka, “Altjirrurna toperrai! Altjirranha kala relha ingkarrakaka ntelalhitjikerrama, era Ingkarta etnaka namanga.” ");
INSERT INTO are_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","John nhanha era kunha artwa era naka, ekuriperrala Altjirraka urrpia Isaiah-ala imanka relha ntjarranha ilakala, “Artwa nyinta worritjala ilkama, ‘Rrangkarra Ingkartaka tjaiya mpaarai, tjaiya ekuranha arratja inthorrilamala.’” ");
INSERT INTO are_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Mantarra nhanga John-anhala ekarralhakala, nhanha relha arrpunhala camel ponganga mpaarakala. Era turta mantarra ekuranha yinpa belt-ala yirnakala. Era intaltja, ngkwarla urltampa turta ilkutjata. ");
INSERT INTO are_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Relha ntjarra inthorrantama John-urna pitjika. Jerusalem town-anga, pmara Judea ntjaparanga, Jordan Lhira ekuranga kutanga turta. ");
INSERT INTO are_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Etna John-aka ilalhaka etna relha kornarintja namanga. Era turta etnanha Jordan Lhirala kaltjirrpulhelaka. ");
INSERT INTO are_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","John-alantama araka artwa Pharisee ntjarra, artwa Sadducee ntjarra turta pitjimanga, era etnanha kaltjirrpulhelitjika. John-ala pula etnanha ilaka, “Apma ngerra ntjarrai. Ngunhalama rrangkarranha ilaka rrangkarra kula Altjirraka aa kngarranga erruntarerritjinala? ");
INSERT INTO are_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Arrkurla rrangkarra ntelalharrirrai rrangkarra nthurrpa toperrakala, arratja turtantama namanga. ");
INSERT INTO are_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Rrangkarra turta itja tnakalhitjika Altjirrala kula rrangkarranha makaritjinala, rrangkarra Abraham-aka ramarama namanga. Atha rrangkarranha ilama, Altjirrala Abraham-aka ramarama arrpunha parta nhanha ntjarranga irrpalthala arrpmarnamara. ");
INSERT INTO are_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Arai, inguntha wara Altjirrala relha lenha ntjarranha kala rrarrathala tutjina, etnala itja korna etnakanhanga toperramanga, arratja turtantama ntelalhamanga. ");
INSERT INTO are_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Atha rrangkarranha kwatjalanta wara kaltjirrpulhelama, arrpunha ntjarra kaltja nitjinanga rrangkarra kornanga toperrakala. Artwa arrpunha pula nukanga ingkarna pitjima, erala nukanga ekarltalkura nama. Yinga turta itja yalknga nama sandal ekuranha kngarnitjika. Artwa nhanha era rrangkarranha Enka Alkngaltarala, urala turta kaltjirrpulhelitjina. ");
INSERT INTO are_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Era relha ingkarrakanha ilkngakitjina, relhalala annga marra ntjarra irrtnya kornanga ilkngakamala ngerra. Relha marra ntjarranha era pmara ekuranhaka arrarnitjina, kanha relha korna ntjarranha era ura ngampakalurnala iwutjina.” ");
INSERT INTO are_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kurunga Jesuanha Jordan Lhirurna lhaka pmara Galilee-angatjina, John-ala erinha kaltjirrpulhelitjika. ");
INSERT INTO are_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","John-anha pula porerramala angkaka, “Untatitja yinganha kaltjirrpulheleikanha. Nthakinhala unta nukurna ingkama, atha nganha kaltjirrpulhelitjika?” ");
INSERT INTO are_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesuala erinha ilaka, “Arai, nhanha kala ungkwangathaka nama, unta yinganha lyarta kaltjirrpulhelitjika. Lakinha ilirna tharrantema Altjirraka arratja kangkwerritjina.” John-alantama erinha kaltjirrpulhelaka. ");
INSERT INTO are_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","John-ala erinha kaltjirrpulhelamaliperra, Jesuanha kala kwatjanga rrataka. Jesualantama araka alkira era altjurerramanga, Altjirraka Enka turta nturrurta ngerra tnanpentjimanga, ekurakarlaka arrarnalhamanga turta. ");
INSERT INTO are_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Relha etna turta wuka Altjirranha alkiranga etnakurna angkamanga, “Nhanha 'Lira nuka nama. Yinga ekura kngarra inthorra kangkama.” ");
INSERT INTO are_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kurunga Enka Alkngaltarala Jesuanha worritjurna rretjingaka, errintjala erinha arrkarnitjika. ");
INSERT INTO are_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesuanhantama worritja ekurala arlta 40, ingwa 40 turta naka, marnakunya. ");
INSERT INTO are_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Erantama ngaiyala inthorra namalanga, errintja era ekururna pitjimala angkitjalhaka, “Unta Altjirraka 'Lira namanga warta, unta parta nhanha etnanha turnai marnerritjika.” ");
INSERT INTO are_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesuala pula erinha ilaka, “Altjirraka Angkatja Imankinyala ilama, ‘Relha yarna marnanganta etatha nama. Angkatja nhanga Altjirralala relhanha ilama, etnakanganta relha etatha nama.’” ");
INSERT INTO are_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kurunga errintjala Jesuanha Jerusalem-urna kngaka, erinha temple kartna inthorraka arrarnaka turta. ");
INSERT INTO are_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Errintja erantama ekururna angkaka, “Unta Altjirraka 'Lira namanga warta, iwulhamala tnanpai. Altjirraka Angkatja Imankinyala ilama, ‘Altjirrala angel ekuranha ntjarranha turnitjina nganha ntarntaritjika. Etnantama nganha iltja etnakanhala errkutjina, unta ntjilpartilalhakitja, ingka ungkwanganha partakarlaka tjalpalhelamala.’” ");
INSERT INTO are_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesuala pula erinha ilaka, “Altjirraka Angkatja Imankinya arrpunhala pula ilama, ‘Unta itja Ingkarta Altjirra ungkwanganha arrkarnitjika.’” ");
INSERT INTO are_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kurunga errintjala Jesuanha parta tjenya inthorrurna kngaka, erinha kartninyaka ingkairnaka turta. Erantama pmara twetakatweta etnanha ekura imarnaka, yultha kngarra etnakanhakarta. ");
INSERT INTO are_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Erantama ekururna angkaka, “Arai, atha nganha nhanha ingkarraka nthitjina, ungkwangantama nitjika, unta paka nuka urrkurrkintja namanga.” ");
INSERT INTO are_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kurunga Jesuala erinha ilaka, “Satan-ai, kala nukanga lhai! Altjirraka Angkatja Imankinya arrpunhala ilama, ‘Unta Ingkarta Altjirra ungkwanganhakanta wara urrkurrkintja nitjika, unta turta ekuranta wara kangkwerritjika.’” ");
INSERT INTO are_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kurunga errintjala Jesuanha impurlalhakantama. Angel ntjarrantama pitjika, ekura tangitjala naka turta. ");
INSERT INTO are_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesuala wumalanga etna John-anha jail-aka kurnakala, era pmara Galilee-urna alpuka. ");
INSERT INTO are_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Era pula itja Nazareth town-ala kuterraka. Era Capernaum town-urnatitja lhaka. Capernaum erataka Galilee ntjanganga kutala naka, Zebulun Naphtali tharraka pmarala. ");
INSERT INTO are_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Lakinha Altjirraka lhelintja nthurrperraka. Era nhanga relha ekuranha ntjarranha lhelakala, urrpia ekuranha Isaiah-arlarlanga, ");
INSERT INTO are_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Relha pmara Zebulun-arinya, pmara Naphtali-arinya turta, Jordan-anga altorlala nama, kwatja ntjanganga kuta. Relha Galilee-arinya nhanha etna, Relha Lorinya ngerra nama. ");
INSERT INTO are_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Relha nhanha etna pmara thapathapala ngerra naka. Etna pula parrtja kngarrantama araka. Relha nhanha etna ilukala ngerra naka. Altjirranhantama pitjika etnanha etathilitjika.” ");
INSERT INTO are_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kurunga Jesuanha tjontakantama relha ntjarranha kaltjinthitjika. Era etnanha ilaka, “Kala Altjirrurna toperrai. Altjirranha kala relha ingkarrakaka ntelalhitjikerrama, era Ingkarta etnaka namanga.” ");
INSERT INTO are_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesuanha Galilee ntjangaka ankerrala nthulapumalanga, era kanhanga tharra araka, Simon-anha, erinhala etna Peter ilama, tjia ekuranha Andrew-anha turta. Era araka eratharra net kwatjurna iwumanga. Eratharra kunha irrpannga errkunherrkunha naka. ");
INSERT INTO are_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Erantama erinhatharra ntangkaka, “Nukanga tnaartangala pitjai. Atha kala mpalanha kaltjinthitjina relhanhatitjantama errkutjika.” ");
INSERT INTO are_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kanhanga eratharra kala net ekuratharra ipmintja impurlalhaka, Jesuanga tnaartangala lhaka turta. ");
INSERT INTO are_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Anpara lhamala, Jesuala kanhanga tharra arrpunhantama araka, James-anha, tjia ekuranha John-anha turta. Eratharra Zebedee-aka worra naka. Eratharra boat-ala naka, kaarta ekuratharra Zebedee-alela. Etna nhanga net tjepakalhakala thanthalanaka. Jesualantama James tharranha ntangkaka. ");
INSERT INTO are_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Eratharra kala boat etnakanha, kaarta ekuratharra turta impurlalhaka, Jesuanga tnaartangala lhaka turta. ");
INSERT INTO are_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesuanhantama pmara Galilee ntjaparala nthulapuka. Era synagogue etnakanhala relha ntjarranha Yia Marra erinha kaltjinthaka. Era etnanha ilaka Altjirranha kala relha ingkarrakaka ntelalhitjikerramanga, era Ingkarta etnaka namanga. Era turta relha mentakarta, ilkaartakarta ingkarrakanha turta marrilaka. ");
INSERT INTO are_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yia ekuriperra pmara Syria ntjaparurna turtantama ntakerranhaka. Relha Syria-arinya ntjarralantama menta etnakanha Jesuurna kngitjika. Etna arrangkulthiperra menterrakala ntjarranha, enka kornakarta ntjarranha, rirta ntjarranha, thaarra ntjarranha turta ekururna kngitjika. Erantama etnanha ingkarraka marrilaka. ");
INSERT INTO are_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Relha worla kngarrantama ekuranga tnaartangala lhaka. Relha Galilee-arinya, relha Decapolis town-arinya, relha Jerusalem-arinya, relha pmara Judea-arinya, relha nhanga pmara Jordan-anga urntwarranga pitjikala ntjarra turta. ");
INSERT INTO are_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesuala relha worla kngarra erinha aramala, era partaka ntjika, arrarnalhaka turta. Kurtungurla ekuranha ntjarra ekuralela arrarnalhakantema. ");
INSERT INTO are_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kurunga era etnanha kaltjinthakantama. ");
INSERT INTO are_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Relha lenha ntjarra arrkana nama, etnala kaltja namanga etna relha kornarintja namanga, Altjirranha kala Ingkarta etnaka namanga warta. ");
INSERT INTO are_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Relha lenha ntjarra arrkana nama, etnala lyarta nthorrkngerramanga, Altjirrala etnanha alkngolkngilitjinanga warta. ");
INSERT INTO are_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Relha lenha ntjarra arrkana nama, etnala itja Altjirranga tjurnalhamanga, Altjirrala etnanha pmaralka nthitjinanga warta. ");
INSERT INTO are_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Relha lenha ntjarra arrkana nama, etnala kngarralkura thakerramanga Altjirraka tjina nitjika, Altjirrala etnanha nthurrpa tjinilitjinanga warta. ");
INSERT INTO are_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Relha lenha ntjarra arrkana nama, etnala relha arrpunha ntjarraka montjamontja ntelalhamanga, Altjirranha etnaka montjamontja ntelalhitjinanga warta. ");
INSERT INTO are_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Relha lenha ntjarra arrkana nama, etnala Altjirriperra arratja eterramanga, etna Altjirranha aritjinanga warta. ");
INSERT INTO are_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Relha lenha ntjarra arrkana nama, etnala relha arrpunha ntjarranha rilherilamanga, Altjirrala etnanha anparnitjinanga warta, ‘Rrangkarra 'lira nuka nama’. ");
INSERT INTO are_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Relha lenha ntjarra arrkana nama, relha arrpunha ntjarrala etnanha Altjirranga arrkngala nakapakarlilamanga, Altjirranha kala Ingkarta etnaka namanga warta. ");
INSERT INTO are_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Rrangkarra arrkana nama, relha arrpunha ntjarrala rrangkarranha tutjika lurnamanga, rrangkarranha arrampowumanga, rrakangkarriperra kngarra orrtjerramanga turta, nukanga arrkngala. ");
INSERT INTO are_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kala arrkana kngarranta narrirrai, Altjirrala rrangkarranha anma alkirala kngarra kwartiwutjinanga warta. Arai, lakinha ngerra etna imanka Altjirraka urrpia ntjarranha tutjika lurnitjatantema.” ");
INSERT INTO are_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Rrangkarrataka peinta ngerra nama relha ingkarrakaka. Peinta era pula kornerrakalanga, relhala erinha yarna wotha marrilama. Era kala ipmintja nama. Relhalantama erinha tjaiyakarlakanta iwuma, erinha ingkala rrothitjika. ");
INSERT INTO are_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Rrangkarrataka parrtja ngerra nama relha ingkarrakaka alhala. Town paka parta kartninyala italhamanga, relhala erinha yarna lauwuma. ");
INSERT INTO are_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Relhala irna alknganthakanha etamanga, era erinha itja korltama. Era pula alkngantha erinha table-akatitja arrarnama, alkngantha era relha ingkarrakanha iltha kwanala parrtjilhelitjinanga. ");
INSERT INTO are_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lakinha rrangkarra turta alknganthala ngerra relha ntjarranha parrtjilhelitjika, etna aritjinanga rrangkarra arratja marra namanga. Etna turtantama Kaarta Alkirarinya rrakangkarranha tnantjitjinanga.” ");
INSERT INTO are_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Thunga rrangkarra etarlarama yinga pitjikala Altjirraka turnintja ntjarra ipmintja iwutjika. Thunga rrangkarra etarlarama yinga pitjikala Altjirraka urrpia imankinya ntjarraka angkatja ipmintja iwutjika. Itja inthorra. Yinga pitjika Altjirraka turnintja ingkarraka inthorraka arratja kangkwerritjika, Altjirraka urrpia imankinya ntjarraka angkatja turta mangkilitjika. ");
INSERT INTO are_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Atha kunha rrangkarranha nthurrpa ilama. Alkira nhanha, alha nhanha turta namalangantema, turnintja nyinta itja ipmintjerritjina. ");
INSERT INTO are_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Lakinhanga, relha erala Altjirraka turnintja nyintaka itja kangkwerramanga, era turta arrpunha ntjarranha turnamanga itja kangkwerritjika, era Altjirranga urlarra relha korna nitjina. Relha era pula, erala Altjirraka turnintjaka kangkwerramanga, era turtala arrpunha ntjarranha turnamanga kangkwerritjika, era Altjirranga urlarra relha tjiparrala nitjina. ");
INSERT INTO are_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Atha kunha rrangkarranha ilama, rrangkarra artwa Intarrangaltha ntjarrangatjina, artwa Pharisee ntjarrangatjina turta arratjalkura nitjika. Itjanga paka, rrangkarra itja kuta Altjirraka pmara ngampakalurna irrputjina.” ");
INSERT INTO are_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Rrangkarra kala wuka Moses-ala errilkngipata ntjarranha ilakala, ‘Unta itja relha arrpunhanha errilknga tutjika’. Nhanha turta, ‘Relha erala relha arrpunhanha errilknga tumanga, etna erinha kala imilitjika’. ");
INSERT INTO are_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Atha pula rrangkarranha ilama, relha erala tjina tnakanhakanha ekuranhaka yirrkngerramanga, Altjirrala erinha kala imilitjina. Relha erala tjina tnakanhakanha ekuranha ilamanga, ‘Unta rirta nama,’ etna erinha kala Sanhedrin Council-urna kngitjika. Relha erala tjina tnakanhakanha ekuranha ilparnamanga, ‘Unta relha korna,’ Altjirrala erinha tatharraka uraka iwutjina. ");
INSERT INTO are_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Thunga unta Altjirraka ilthurna lhama, Altjirranha tjauwerrilya nthitjika. Thunga turta unta ilpangkama tjina tnakanhakanha itja ungkwangalela rilhera nama. ");
INSERT INTO are_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Kala tjauwerrilya ungkwanganha altar-anga kutaka impurlalhai. Arrkurla lhai tjina tnakanhakanha ungkwanganhalela rilhererritjika. Kurunga pitjalpumala Altjirranha tjauwerrilya ungkwanganha nthai. ");
INSERT INTO are_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Thunga arrpunhala nganha court-urna kngama. Ekuralela rilhererrai mpala tharrantema court-urna lhamalanga. Itjanga, era nganha tjiperrawunhawunhanga urlarra ilparnitjina. Tjiperrawunhawunhalantama errkuntjanha turnitjina nganha jail-aka kurnitjika. ");
INSERT INTO are_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Arai, atha nganha nthurrpa ilama, unta itja tanhanga rratitjina unta fine ungkwanganha ingkarraka inthorra pay-emilakalalpula.” ");
INSERT INTO are_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Rrangkarra kala wuka Moses-ala errilkngipata ntjarranha ilakala, ‘Unta itja relha arrpunhaka noalela intitjika.’ ");
INSERT INTO are_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Atha pula rrangkarranha ilama, relha erala arrkutja ararlanama, ekura lherramala, erataka kala ekuralela intaka ngerra. ");
INSERT INTO are_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Thunga alknga akwa ungkwanganhala nganha korna ntelalhitjika arrtjilhelama. Kala alknga erinha urlpuntjimala iwai. Nhanha marralkura nama unta alknga nyintakarta Altjirraka pmara ngampakalurna irrputjika, nhanhangatjina, Altjirrala mpurrka ntjapara ungkwanganha tatharrurna iwutjika. ");
INSERT INTO are_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Thunga iltja akwa ungkwanganhala nganha korna ntelalhitjika arrtjilhelama. Iltja erinha inturnamala iwai. Nhanha marralkura nama unta iltja nyintakarta Altjirraka pmara ngampakalurna irrputjika, nhanhangatjina, Altjirrala mpurrka ntjapara ungkwanganha tatharrurna iwutjika. ");
INSERT INTO are_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nhanha turta Moses-ala errilkngipata ntjarranha ilakala. ‘Artwa erala arrkutja noa ekuranha impumanga, era erinha pepa nthitjika. Pepa ekurakarlaka era intalhelakala era erinha kala impukalangantama.’ ");
INSERT INTO are_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Atha pula rrangkarranha ilama, artwa erala arrkutja noa ekuranha impumanga, era itja artwa arrpunhalela korna mpaarakalangatanya, erataka arrkutja erinha ilkarrtjilama. Artwa era turta, erala noa inama arrkutja artwa arrpunhala impukala, era turta korna mpaarama. ");
INSERT INTO are_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Rrangkarra kala wuka Moses-ala errilkngipata ntjarranha nhanha turta ilakala, ‘Unta itja Altjirranha orrtja lhelitjika. Nhanha untala erinha lhelakala kala mangkilai.’ ");
INSERT INTO are_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Atha pula rrangkarranha ilama, rrangkarra itja inthorra Altjirraka rretnya ilamala relha arrpunhanha lhelitjika. Rrangkarra turta itja alkira ilamala arrpunhanha lhelitjika. Alkira era Altjirraka pmara namanga warta. ");
INSERT INTO are_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Rrangkarra turta itja alha nhanha ilamala arrpunhanha lhelitjika. Altjirrala ingka ekuranha alha nhanhaka arrarnamanga warta, iltjerritjika. Rrangkarra turta itja Jerusalem ilamala arrpunhanha lhelitjika. Jerusalem era Altjirraka, king kngarra ekura town namanga warta. ");
INSERT INTO are_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Rrangkarra turta itja kapurta rrakangkarranha ilamala arrpunhanha lhelitjika. Rrangkarra yarna warta kapurta ponga nyinta tjulkurilamanga paka, arrpunha urrpurlilamanga paka. ");
INSERT INTO are_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Rrangkarra kala arratjanta angkitjika. Kala awa, itjanta paka. Rrangkarra paka urntwarra angkamanga, nhanha errintjangala nama.” ");
INSERT INTO are_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Rrangkarra kala wuka Moses-ala errilkngipata ntjarranha ilakala, ‘Relha nyintala paka relha arrpunhaka alknga kornilamanga, etna alknga ekuranha kornilitjikantema. Relha nyintala paka relha arrpunhaka itetja urltakamanga, etna itetja ekuranha urltakitjikantema.’ ");
INSERT INTO are_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Atha pula rrangkarranha ilama rrangkarra itja kapanha tutjika. Nyintala paka ilkaiya akwa ungkwanganha tumanga, ilkaiya arrpunha ungkwanganha turta ekura imarnai, era tutjika. ");
INSERT INTO are_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Thunga arrpunhala nganha court-urna kngama, shirt ungkwanganha initjika. Erinha kala coat ungkwanganha turta nthalenai. ");
INSERT INTO are_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Thunga tjapartiala nganha turnama, ‘Yultha nukanha 1 kilometre kngarlathanai!’ Unta kala yultha ekuranha 2 kilometres kngai, tjapartia era paka antja namanga. ");
INSERT INTO are_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Thunga arrpunha ungkwanga yulthaka enkama. Erinha kala nthai. Thunga arrpunha yultha ungkwanganhaka enkama, lyartaka wara. Erinha kala lyartaka wara nthai.” ");
INSERT INTO are_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Rrangkarra kala wuka Moses-ala errilkngipata ntjarranha ilakala, ‘Unta tjina ungkwanganhaka kangkintja ntelalhitjika. Unta pula leltja ungkwanganhaka yirrknga kuta nitjika.’ ");
INSERT INTO are_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Atha pula rrangkarranha ilama, rrangkarra leltja rrakangkarranhaka kangkintja ntelalhitjika. Rrangkarra turta Altjirrurna ingkitjika, relha lenha ntjarraka, etnala rrangkarranha palkala wara tutjika lurnamanga. ");
INSERT INTO are_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Rrangkarra angkatja nukanhaka kangkwerramanga, rrangkarra Kaarta Alkirarinyaka 'lira nitjina. Era kunha relha korna ntjarranha, relha marra ntjarranha turta lirnngala parrtjilhelama, loala kuta. Era turta kwatja ilpantha relha marra ntjarranha nthama, relha korna ntjarranha turta, loala kuta. ");
INSERT INTO are_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Iwunhangantama Altjirrala rrangkarranha kwartiwutjika, rrangkarra tjina rrakangkarranhakanta kangkamanga? Tax money kotjinha ntjarra pula tjina etnakanhaka kangkamantemala. ");
INSERT INTO are_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Rrangkarra paka tjina rrakangkarranhalelanta yia angkarramanga, rrangkarra itja Altjirra ngerra kangkintja ntelalhama. Relha Lorinya ntjarra turta tjina etnakanhalela yia angkarramantema. ");
INSERT INTO are_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Rrangkarra pula arratja inthorra ntelalhitjika, Kaarta Alkirarinya rrakangkarranha ngerra.” ");
INSERT INTO are_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Rrangkarra aralhitjika. Rrangkarra itja tnakalhitjika, rrangkarra kula arratja ntelalhamanga. Rrangkarra paka arratja ntelalhamanga relhala rrangkarranha tnantjitjikanta, kurunga Kaarta Alkirarinyala rrangkarranha itja kwartiwutjina. ");
INSERT INTO are_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Unta paka relha ilkngaranha yultha nthitjika antja namanga, unta itja artwa arrpunhanha turnitjika relha ntjarranha worlilitjikarrka, nganha aritjika. Relha pmatha ntjarra lakinha ntelalhama, synagogue kwanala, town mpopala turta. Etna wara antja nama relha ntjarrala etnanha tnantjitjika, etna ilkngara ntjarranha yultha nthamanga. Atha rrangkarranha nthurrpa ilama, Altjirrala etnanha itja kwartiwutjina. ");
INSERT INTO are_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Unta pula relha ilkngaranha yultha nthamanga, erinha nyilknganyilkngala nthai, arrpunha ntjarra kotna kuta nitjinanga. ");
INSERT INTO are_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kala mpalanta kaltja nitjinanga. Kaarta Alkirarinyala pula nhanha aritjina. Erantama nganha kwartiwutjina.” ");
INSERT INTO are_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Rrangkarra Altjirrurna ingkamanga, rrangkarra itja pmatha ntjarra ngerra ingkitjika. Etnataka kngarralkura antja nama synagogue kwanala ingkitjika, itnamala, relhanga alkngatharra turta, ntjarrala etnanha aritjinanga. Atha rrangkarranha nthurrpa ilama, Altjirrala etnanha itja kwartiwutjina.” ");
INSERT INTO are_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Unta pula Altjirrurna ingkitjinala, untarrpa lhai nyintarinya nitjika. Kurunga unta Kaarta Alkirarinya ungkwanganhurna ingkai. Kaarta Alkirarinya era kala aritjina unta ekururna ingkamanga, era turta nganha kwartiwutjina.” ");
INSERT INTO are_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Rrangkarra ingkamalanga, rrangkarra itja angkatjanta kngarrilitjika, Relha Lorinya ntjarrala ngerra. Etna etarlarama altjirra etnakanhala kula etnanha wutjinala etna kngarra angkamanga. ");
INSERT INTO are_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Rrangkarra itja etna ngerra nitjika. Iwunhakama rrangkarra antja? Kaarta Alkirarinya rrakangkarra erataka nhanhaka kala kaltja, rrangkarra ekururna itjantema ingkakalanga. ");
INSERT INTO are_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Rrangkarrataka lakinhatitja ekururna ingkitjika, ‘Kaarta nurnaka, untala alkirala namanga, Relha ingkarrakanha kaltjinthai, rretnya ungkwanganha arratjanta ilitjika. ");
INSERT INTO are_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pitjai, relha ingkarrakaka ntelalhitjika, unta Ingkarta namanga. Relha ingkarrakanha kaltjinthai ungkwanga kangkwerritjika, alkirarinya etnala ungkwanga kangkwerramanga ngerra. ");
INSERT INTO are_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Marna nurnakanha nurnanha arltamarlta nthai. ");
INSERT INTO are_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Korna nurnakanha iwai, nurnala relha arrpunhaka korna iwukala ngerra. ");
INSERT INTO are_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nurna arrkarnintjurnerramalanga, nurnanha tnyinai. Errintja era nurnaka irrpaltherramalanga, nurnanha ntarntarai.’” ");
INSERT INTO are_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Rrangkarra paka relha arrpunhaka korna iwumanga, etna rrangkarranha kornilakalanga, kurunga Kaarta Alkirarinyala korna rrakangkarranha iwutjinantema. ");
INSERT INTO are_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Rrangkarra pula relha arrpunhaka korna itja iwumanga, etna rrangkarranha kornilakalanga, kurunga Kaarta Alkirarinyala korna rrakangkarranha itjantema iwutjina.” ");
INSERT INTO are_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Rrangkarra Altjirranha etarlaramala marnakunya namanga, rrangkarra itja unpaarta narlanitjika pmatha ntjarra ngerra. Etnataka anngerra unpaarta narlanama, ntjarrala aritjinanga etna Altjirrakakwia marnakunya namanga. Atha rrangkarranha nthurrpa ilama, Altjirrala etnanha itja kwartiwutjina. ");
INSERT INTO are_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Unta pula Altjirranha etarlaramala marnakunya namanga, unta tjipatjipa kutala ntelalhitjika. ");
INSERT INTO are_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kurunga relha arrpunha ntjarra itja kaltja nitjina unta Altjirrakakwia marnakunya namanga. Kaarta Alkirarinya era pula kala kaltjala nitjina. Kaarta Alkirarinya erantama, erala arama unta ekura kangkamanga, era kala nganha kwartiwutjina.” ");
INSERT INTO are_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Rrangkarra itja alhala yultha kngarra patilitjika. Nhanhala kunha intarrkala, rust-alalka yultha kornilama, nyilkngampa turta ilthaka irrpumala yultha nyilkngala kngama. ");
INSERT INTO are_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Rrangkarrataka yultha arrpunhatitja patilitjika, alkirala. Pmara tanhala intarrka, rust-alka itja nama yultha kornilitjika. Nyilkngampa turta itja nama, yultha nyilkngala initjika. ");
INSERT INTO are_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Arai, pmara nthanhala yultha rrakangkarra intamanga, pmara lenhaka kunha rrangkarra kngarralkura kangkitjina.” ");
INSERT INTO are_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Unta paka kangkamanga relha arratja ntelalhamanga, kurunga unta turta arratja eterritjina.” ");
INSERT INTO are_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Unta pula kangkamanga relha korna ntelalhamanga, kurunga unta turta kornaka lherritjina. Kurunga unta turta korna kuta ntelalhitjina. ");
INSERT INTO are_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Relha yarna itornka tharraka kangkwerrama. Era paka nyintaka kangkamanga, era kala arrpunhaka antjakunyerritjina. Era paka nyintaka kangkwerramanga, era kala arrpunhanga unpulhitjina. Arai, rrangkarra yarna Altjirraka kangkama, yulthaka turta, loala kuta. ");
INSERT INTO are_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Lakinhangataka atha rrangkarranha ilama, rrangkarra itja kngarra inthorra etarlaritjika, ‘Iwunhama nurna ilkutjina? Iwunhama nurna ntjutjina? Iwunhakama nurna ekarralhitjina?’ Arai, Altjirrala nurnanha arrpmarnaka, itja marnakanta thakerritjika, mantarrakanta turta. ");
INSERT INTO are_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Thepa alkirarinya ntjarranha arai. Etna itja marna annga ingkairnama. Etna turta itja marna annga kotjima, iltha etnakanhala patilitjika. Kanha Kaarta Alkirarinya rrakangkarranhala etnanha kalantemala ntuthilama. Rrangkarra kala etnakanga tjiparralkurala nama. ");
INSERT INTO are_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Rrakangkarranga arrpunha paka kutalkura etatha nitjinama, kngarra etarlaramala? Itja kunha! ");
INSERT INTO are_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Iwunhanga turtantama rrangkarra mantarriperra kngarra etarlarama? Antatha etnanha kathala mangkamanga arai. Etna itja urrkapuma, mantarra paka etnakiltja thanthama. ");
INSERT INTO are_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Atha pula rrangkarranha nthurrpa ilama, King Solomon, erala mantarra ntjatjintja inthorraka ekarralhitjata, era pula antatha nhanha ntjarranga urlarra alkumpa wara naka. ");
INSERT INTO are_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Altjirrala antatha etnanha lantjalantja inthorra arrpmarnaka. Antatha etna pula kurrka wara namala kala ntjirrkerrama. Kurunga relhala etnanha uraka iwuma. Rrangkarrataka Altjirranha kurrka wararrpa tnakama. Altjirranga urlarra rrangkarra tjiparralkura nama antathangatjina. Era kala rrangkarranha mantarra nthitjina, ekarralhitjika. ");
INSERT INTO are_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Rrangkarrantama itja kngarra etarlaritjika, ‘Iwunhama nurna ilkutjina? Iwunhama nurna ntjutjina? Mantarra nthanhiakama nurna ekarralhitjina?’ ");
INSERT INTO are_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Relha Lorinya ntjarralataka marnakalka kuta yonthama. Kaarta Alkirarinya rrakangkarra pula kala kaltja rrangkarra yarna marnakunya, kwatjakunya, mantarrakunya paka nama. ");
INSERT INTO are_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Rrangkarra pula arrkurlakimparra Altjirrurna ingkitjika era relha ingkarrakaka ntelalhitjika, era Ingkarta namanga, era rrangkarranha kaltjinthitjika turta ekura kangkwerritjika. Era kala rrangkarranha marnalka mantarralka nthitjinantema. ");
INSERT INTO are_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Rrangkarrantama kala kunpa narrirrai, itja ingunthiperra kngarra etarlaramala. Inguntha kala imampurla ekuranhakarta nitjina. Rrangkarrantama itja imampurla lyartakanha kngarrilitjika ingunthakanha lhangamala. ");
INSERT INTO are_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Rrangkarra itja relha arrpunhanha ilitjika, ‘Untataka relha korna nama.’ Unta erinha lakinha ilamanga, Altjirrala nganha turta ilitjina unta relha korna namanga. ");
INSERT INTO are_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Rrangkarra paka relha arrpunhiperra korna angkamanga, Altjirranha rrakangkarriperra kornantema angkitjina, era rrangkarranha tjiperrawumalanga. Rrangkarra pula relha arrpunhiperra marra angkamanga, Altjirranha rrakangkarriperra marrantema angkitjina, era rrangkarranha tjiperrawumalanga. ");
INSERT INTO are_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nthakinhala unta lyaka kurrka erinhanta katha arama, erala tjina tnakanhakanha ungkwanganhaka alkngala intamanga? Kanha irna thaaka erala alknga ungkwanganhala intamanga, unta itjala arama? ");
INSERT INTO are_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Arai, unta yarna lyaka kurrka erinha urlpuntjima, irna thaaka era alknga ungkwanganhala intamangantema. ");
INSERT INTO are_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Relha pmathai, unta irna thaaka erinharrka alknga ungkwanganhanga urlpuntjai. Kurunga unta lyaka kurrka erinha, erala tjina ungkwanganhaka alkngala intamanga, katha aritjina, erinha irrpalthala urlpuntjitjina turta. ");
INSERT INTO are_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Rrangkarra itja Altjirraka yultha alkngaltara kngulya ntjarraka iwutjika. Rrangkarra turta itja Altjirraka yultha tjiparra pig ntjarranha nthitjika. Etna yultha etnanha kornilakitja, rrangkarranha turtantama utnhukitja.” ");
INSERT INTO are_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Altjirrurna ingkai, kurunga era rrangkarranha kala wutjina. Altjirraka yonthai, kurunga rrangkarra erinha kala arltaritjina. Altjirraka reoa iltaratwai, kurunga era rrakangkarra kala altjurilitjina. ");
INSERT INTO are_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Arai, relha nyintaminyinta erala Altjirrurna ingkamanga, erinha Altjirrala wutjina. Relha nyintaminyinta erala Altjirraka yonthamanga, era erinha kala arltaritjina. Relha nyintaminyinta erala Altjirraka reoa iltaratumanga, Altjirrala ekura kala altjurilitjina. ");
INSERT INTO are_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kaartala kunha itja 'lira ekuranha parta nthama, era ekura marnaka enkamanga. ");
INSERT INTO are_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Era turta erinha itja apma nthama, era ekura irrpanngaka enkamanga. ");
INSERT INTO are_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Relha kornarintja rrangkarra kala kaltja nama 'lira rrakangkarranha yultha marra nthitjika. Wothalkura Kaarta Alkirarinya rrakangkarranhala etnanha yultha marra nthitjina, etnala ekura enkamanga.” ");
INSERT INTO are_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Rrangkarrala antja nama relha arrpunha ntjarra rrakangkarra ntelalhitjika, lakinha ngerra rrangkarrakimparra etnaka ntelalhai. Lakinha kunha Moses-ala, Altjirraka urrpia imankinya arrpunha ntjarrala turta, kaltjinthaka.” ");
INSERT INTO are_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Rrangkarra reoa urlpma ekuranga irrpai. Arai, relha ntjarra tjaiya ntakala lhama, reoa ntakanga turta irrpunhama. Altjirrala relha nhanha ntjarranha yirralhelitjina. ");
INSERT INTO are_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kanha relha urrputja wara tjaiya urlpmala lhama, reoa urlpmanga turta irrpunhama. Relha nhanha ntjarra ngampakala etatha nitjina.” ");
INSERT INTO are_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Rrangkarra urrpia orrtjaltha ntjarranga aralhai. Etna rrakangkarra ntelalhitjina sheep ngerra, ngwanga inthorra. Etnarrpa pula korna nama, kngulya itnura utnhunhutnhunha ngerra. ");
INSERT INTO are_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Urrpia orrtjaltha etna irna korna ngerra nama. Etna annga korna lhalhelama. Arai, relhala itja marna lalitja kotjima ilakwanga, marna katjirra paka lyakanga. ");
INSERT INTO are_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Irna marrala annga marra lhalhelama. Kanha irna kornala, annga kornala. ");
INSERT INTO are_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Irna marrala yarna annga korna lhalhelama, irna kornala turta yarna annga marra lhalhelama. ");
INSERT INTO are_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lakinhanga irna nyintaminyinta, erala itja annga marra lhalhelama, etna erinha kala inturnamala uraka iwuma. ");
INSERT INTO are_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Rrangkarrantama orrtja urrpia etnanha lhangkaritjina, etna irna kornala ngerra, annga korna lhalhelamanga.” ");
INSERT INTO are_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Relha arrpunha ntjarra etnala yinganha ‘Ingkarta’ anparnama, etna itja Altjirraka pmara kutathurna irrputjina. Relha lenha ntjarra wara irrputjina, etnala Kaarta Alkirarinya nukanhaka kangkwerramanga. ");
INSERT INTO are_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yinga tjiperrawutjika pitjimalanga, relha ntjarra nukurna angkitjina, ‘Ingkartai, Ingkartai, nurna kunha relha arrpunha ntjarranha rretnya ungkwanganhala kaltjinthakala. Nurna kunha rretnya ungkwanganha ilamala enka korna ntjarra unpurlenakala. Nurna turta rretnya ungkwanganha ilamala tjatjikarta ntjarra urrkapukala.’ ");
INSERT INTO are_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yinga pula etnakurna angkitjina, ‘Yinga itjama rrakangkarra kaltja. Kala nukanga lhai! Rrangkarrataka relha kornanta ntjarra.’” ");
INSERT INTO are_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Lakinhanga relha erala angkatja nukanha wumanga, angkatja ekura kangkwerramanga turta, era kala artwa inangkarla ngerra nama. Era iltha ekuranha parta theintakarlaka itakala. ");
INSERT INTO are_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kwatja ilpanthalantama nhamanga, kwatja roala, wurinya ekarltala turta iltha erinha twentjimalanga, iltha era itja taakalhitjina. Erinha parta theintakarlaka warta itakalanga. ");
INSERT INTO are_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Relha erala angkatja nukanha wumanga, era pula angkatja ekura itja kangkwerramanga, era kala artwa rirta ngerrala nama. Era iltha ekuranha arna urlpaiyakarlaka itakala. ");
INSERT INTO are_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kwatja ilpanthalantama nhamanga, kwatja roala, wurinya ekarltala turta iltha erinha twentjimalanga, iltha era ntjapara kuta taakalhitjina.” ");
INSERT INTO are_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesuala relha ntjarranha lakinha kaltjinthaka. Relha ntjarra angkatja ekuranhaka tnolkaka. ");
INSERT INTO are_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Erataka etnanha angkatja ekarltala kaltjinthaka, itja artwa Intarrangaltha ntjarrala ngerra. ");
INSERT INTO are_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesuanha partanga tnanpentjikantama. Relha worla kngarra turta ekuranga tnaartangala pitjika. ");
INSERT INTO are_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Artwa leprosy-akartantama Jesuurna pitjika, ekuranga urlarra turta mparalela arrarnalhaka. Era Jesuanha ilaka, “Ingkartai, unta paka antja namanga, unta yinganha kala irrpalthala marrilamara.” ");
INSERT INTO are_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesuala erinha iltjala anpumala ilaka, “Yinga antjakwia. Atha nganha kala marrilama.” Erantama kala marrerraka. Leprosy ekura kala yirraka. ");
INSERT INTO are_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesualantama erinha ilaka, “Arai, unta itja relha arrpunhanha nhanhiperra ilitjika. Kala priest-akanta ntelalhai. Unta turta Altjirranha tjauwerrilya nthai, Moses-ala relha ntjarranha turnakala ngerra. Unta lakinhilitjika, relha ntjarra kaltja nitjinanga unta kala marrerrakalangantama.” ");
INSERT INTO are_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesuanha Capernaum-urna irrpumalanga, Rome-arinya itornka nyinta pitjimala, ekururna ingkaka, ");
INSERT INTO are_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ingkartai, urrkapunhapunha nukanhataka thaarrerraka. Erantama ilkaarta kngarrakarta intarlanama, iltha nukanhala.” ");
INSERT INTO are_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesuala erinha ilaka, “Yinga kala ungkwangalela lhitjina erinha marrilitjika.” ");
INSERT INTO are_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Rome-arinya itornka era pula erinha ilaka, “Ingkartai, iwunhangala unta iltha kornakorna nukanhurna lhitjika eterrama? Unta kala angkai, kurunga urrkapunhapunha nukanha kala marrerritjina. ");
INSERT INTO are_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Arai, yinga kunha itornkakartantema nama. Nukathaka turta nama tjapartia nukanha ntjarranha turnitjika. Atha paka nyintanha ilamanga, ‘Lhai!’ era kala lhama. Atha paka arrpunhanha ilamanga, ‘Pitjai!’ era kala pitjima. Atha paka urrkapunhapunha nukanha turnamanga, ‘Lakinhilai’, era kala lakinhilama.” ");
INSERT INTO are_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nhanha wumala, Jesuanha tnolkaka. Erantama relha ekuranga tnaartangala pitjimala ntjarranha ilaka, “Arai, atha rrangkarranha nthurrpa ilama. Pmara Israel ntjaparala atha itja relha nyintanha paka araka, erala yinganha tnakamanga, artwa nhanhala ngerra. ");
INSERT INTO are_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Atha rrangkarranha nhanha turta ilama. Relha Lorinya ntjarra inthorra ekngarranga, altorlanga turta pitjitjina Abraham-alela, Isaac-alela, Jacob-alela turta tjinkarra ilkutjika Altjirraka pmara kutathala. ");
INSERT INTO are_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kanha pmarakurtwia ntjarranha Altjirrala unputjinala, pmara thapathapurna turta yairnitjina. Tanhala etna itnitjina, yarna thakerritjina turta.” ");
INSERT INTO are_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesualantama Rome-arinya itornka erinha ilaka, “Kala alpai. Untataka yinganha nthurrpa tnakama. Lakinhanga atha urrkapunhapunha ungkwanganha marrilama.” Itornka ekuranhaka urrkapunhapunhantama marrerraka Jesuanha angkamalangantema. ");
INSERT INTO are_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesuanha Peter-aka ilthurnantama lhaka. Erantama Peter-aka mara aritjalhaka, menta intamanga, wumpia inthorra. ");
INSERT INTO are_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Era iltja ekuranha anpuka. Peter-aka mara kala marrerrakantama. Kamerramala, era Jesuaka marna etaka. ");
INSERT INTO are_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kala ngurrangurrerrakalangantama pmararinya ntjarrala relha enka kornakarta ntjarranha Jesuurna kngitjika. Jesualantama enka korna etnanha unpurlenaka, angkatjalanta wara. Era turta mentakarta arrpunha ntjarranha marrilakantema. ");
INSERT INTO are_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Altjirrala imanka relha ekuranha ntjarranha lhelakala, urrpia Isaiah-arlarlanga, “Era nurnanha, relha menta ilkaartakarta ntjarranha, marrilaka.” Lhelintja nhanhantama nthurrperraka. ");
INSERT INTO are_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesuala araka relha worla kngarra ekuranga kaarntakaarntala itnamanga. Erantama kurtungurla ekuranha ntjarranha turnaka, Galilee ntjanganga urntwarra mpinyurna tjananhitjika. ");
INSERT INTO are_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Artwa Intarrangaltha nyintantama ekururna pitjimala angkaka, “Kaltjinthanhinthanhai, pmara ekururnala unta lhama, yinga kala ungkwanganga tnaartangala lhitjina.” ");
INSERT INTO are_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesuala pula erinha ilaka, “Kngulya itnuraka lhunga intama, thepaka turta antjwa. Kanha Relhaka 'Lira ilthakunyala nama.” ");
INSERT INTO are_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kurtungurla arrpunhala Jesuanha pmarraka, “Ingkartai, yinganha impurlarrarnai kaarta nukanharrka tintjiwutjika.” ");
INSERT INTO are_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesuala pula erinha ilaka, “Kala nukanga tnaartangala pitjai. Relha errilknga ntjarranha impai, errilknga etnakanha tintjiwutjika.” ");
INSERT INTO are_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nhanhiperra Jesuanha boat-aka ntjika, kurtungurla ekuranha ntjarrakarta, ntjanganga tjananhitjika. ");
INSERT INTO are_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Etna lhapalhamanga, wurinya ekarlta inthorrala etnanha twentjika. Kwatja kngarrantama boat ekura thalalhaka, inmarra kngarritja inthorranga warta. Kanha Jesuanha ankwentarlanakala. ");
INSERT INTO are_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kurtungurla ntjarralantama erinha kamalhelaka. Etna ekururna ingkaka, “Ingkartai, nurnanha tangkalhelai. Nurnataka ilutjikerrama.” ");
INSERT INTO are_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesuala pula etnanha pmarraka, “Iwunhangala rrangkarra trerrama? Rrangkarra yinganha itjala tnakama?” Erantama kamerramala wurinya erinha, inmarra etnanha turta parraka. Kala wurinya era, inmarra etna turta yirraka. ");
INSERT INTO are_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Artwa etna, etnala boat-ala naka, etna tnolkamala angkaka, “Artwa ngunhama nhanha? Wurinya, kwatjalka kunha ekura kangkwerrama.” ");
INSERT INTO are_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ntjanganga tjananhamalantama, etna pmara Gadara-urna pitjika. Artwa enka kornakarta tharrantama ekururna pitjika. Artwa eratharrataka wolknganga mpopala nitjata. Eratharra turta aa kngarra inthorra nitjata. Lakinhanga relha itja kuta pmara ekuratharrakanhurna etinyerritjata. ");
INSERT INTO are_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesuanha aramala ngerra, artwa eratharra ilkarlalhaka, “Jesuai, Altjirraka 'Lirai, iwukala unta ilirnakurna pitjika? Unta ilirnanha kalama rrarrathala tutjina? Antala nhanga Altjirralala relhanha rrarrathala tutjinala, antala nhanha kunha lyartathakantema.” ");
INSERT INTO are_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Katha nhanga etnala angkarritjama, ekuranga etinya wara pig worla kngarra naka. ");
INSERT INTO are_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Enka korna etnantama Jesuurna ingkaka, “Unta nurnanha artwa nhanha tharranga unputjika eterramanga, nurnanha pig tanha ntjarrurna yairnai.” ");
INSERT INTO are_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesuala etnanha ilaka, “Kala lhai.” Etnantama pig ntjarrurna irrpuka. Pig etnantama rirterramala parta irnkurna arrtjanamala, kwatja ntjangurna tnyinhaka, alkngontingkaka turta. ");
INSERT INTO are_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Relha etnala pig etnanha ntarntaritjata, etna pula town-urnala arrtjanaka. Etnantama town-arinya ntjarranha yia artwa nhanga tharriperra alpmelaka, eratharrala enka kornakarta nakala. ");
INSERT INTO are_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Relha ingkarraka inthorrantama town-anga rratamala pitjika, Jesuanha aritjika. Erinha aramala, etna erinha thakalhelaka pmara etnakanhanga rratamala lhitjika. ");
INSERT INTO are_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kurunga Jesuanha boat-aka ntjika. Erantama ntjanganga tjananhamala town ekuranhurna pitjika. ");
INSERT INTO are_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Town-arinya etnantama artwa thaarra nyintanha ekururna kngitjika. Artwa era ntjama ekuranhala intaka. Jesuala aramalanga etna erinha ekarlta tnakamanga, era artwa thaarra erinha ilaka, “'Lira nukai, arrkana nai. Atha kala korna ungkwanganha iwuka.” ");
INSERT INTO are_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nhanha wumala, artwa Intarrangaltha urrputja lakinhala eterraka, “Artwa nhanhalataka Altjirranha arrampowuma.” ");
INSERT INTO are_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesuala kala lhangkaraka etnala eterramalaka. Erantama etnanha pmarraka, “Iwunhangala rrangkarra nukiperra korna eterrama? ");
INSERT INTO are_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yinganha ilai, iwunhama rukaralkura nama? Artwa thaarra nhanha erinha ilitjika, ‘Atha korna ungkwanganha iwuma.’ Erinha paka ilitjika, ‘Kala kamerrai, nthulapai turta.’ ");
INSERT INTO are_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Relhaka 'Lira era nthurrpa relhaka korna irrpalthala iwuma. Atha rrangkarranha nhanha ntelitjina.” Jesualantama artwa thaarra erinha ilaka, “Kamerrai! Ntjama ungkwanganha tjurnamala, kala alpai.” ");
INSERT INTO are_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Artwa era kala kamerraka, alpuka turta. ");
INSERT INTO are_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nhanha aramala, relha etna trerraka. Etna Altjirranha tnantjaka turta, era relhanha ekarltilakalanga tjatjikarta lakinha ngerra urrkaputjika. ");
INSERT INTO are_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Anparerramalantama, Jesuala Matthew-anha araka iltha ekuranhanga kathala narlanamanga. Matthew-alataka tax money kotjitjata. Jesuala erinha ntangkaka, “Nukanga tnaartangala pitjai.” Matthew-anha kamerraka, Jesuanga tnaartangala lhaka. ");
INSERT INTO are_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Anma, Jesuanha, kurtungurla ekuranha ntjarra turta, Matthew-aka ilthala worlerraka, marna ilkutjika. Relha kornarintja ntjarra arrpunha, tax money kotjinha ntjarra arrpunha turta etnakalela marna ilkurlanaka. ");
INSERT INTO are_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Artwa Pharisee ntjarrala nhanha aramala, etna Jesuaka kurtungurla ntjarranha pmarraka, “Iwunhangala kaltjinthanhinthanha rrakangkarranhala relha kornarintja ntjarralela, tax money kotjinha ntjarralela turta marna ilkuma?” ");
INSERT INTO are_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesuala etnanha wuka. Erantama etnanha ilaka, “Relha ltarrkngalataka itja ngangkaraka yonthama. Relha mentalanta. ");
INSERT INTO are_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Altjirrala nhanga relha ntjarranha ilaka, ‘Yinga antja rrangkarra relha arrpunhaka montjamontja ntelalhitjika, itja yinganha tnontha tjauwerrilya nthalanitjika.’ Angkatja nhanhaka eterrai. Arai, yingataka pitjika relha kornarintja ntjarranha Altjirrurna rretjingitjika, itja relha arratja ntjarranha.” ");
INSERT INTO are_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kurunga John Kaltjirrpulhelanhelanhaka kurtungurla ntjarra Jesuurna etinyerraka. Etna erinha pmarraka, “Iwunhangala nurnanta, artwa Pharisee ntjarranta turta arrpunharanga marnakunya nama, kanha kurtungurla ungkwanganha ntjarra itja kutala marnakunya nama?” ");
INSERT INTO are_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesuala etnanha ilaka, “Artwala noa inamanga era tjinkarra urrkapuma. Kurunga era tjina ekuranha ntjarranha ntangkama, marna ilkutjika. Tjina etna yarna marnanga unpulhama, artwa noa inakala era etnakalela namangantema. Anma pula relha arrpunha ntjarrala artwa erinha errkumala kngitjina. Kurunga artwa ekura tjina ntjarra, etna arlta arrpunhala kala marnakunyantama nitjina. ");
INSERT INTO are_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Arai, thunga mantarra ingkwia tjepakalhama. Relhala itja mantarra lyartinyanga mantarra kurrka kama, nhanha mantarra ingkwiakarlaka turta thanthama. Mantarra lyartinya era urlpmerramala, mantarra ingkwia erinha wothantema tjepakakitja. ");
INSERT INTO are_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Relhala turta itja wine lyartinya yinpa ingkwiaka thalama, wine lyartinya era yinpa ingkwia etnanha talhelakitja. Kurunga wine lyartinya era, yinpa ingkwia etna turta, tharrantema ipmintjerrama. Relhala pula wine lyartinya, yinpa lyartinyaka thalama. Kurunga tharrantema marra kuta nama.” ");
INSERT INTO are_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesuanha angkamangantema, itornka nyinta ekururna pitjika, mparalela turta arrarnalhaka. Era Jesuanha ilaka, “Kwarra nuka kunha lyarta nhanha iluka. Nukalela pitjai iltja ungkwanganha ekurakarlaka arrarnitjika, era wotha etatherritjinanga.” ");
INSERT INTO are_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesuanhantama kamerraka, kurtungurla ekuranha ntjarra turta. Etnantama itornka ekuranga tnaartangala lhaka. ");
INSERT INTO are_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Etna lhapalhamanga, arrkutja nyinta, erala 12 years menta kngarrakarta nakala, era ingkarnanga pitjimala Jesuaka mantarra anpuka. ");
INSERT INTO are_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Erataka lakinha eterrakala, “Atha paka mantarra ekuranhanta anpumanga, yinga kala marrerritjina.” ");
INSERT INTO are_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesuanha ilkngaralhaka. Arrkutja erinha aramala, era erinha ilaka, “Kwarra nukai, unta yinganha tnakakalanga, Altjirrala nganha marrilaka.” Arrkutja erantama kala lenhantaparra marrerraka. ");
INSERT INTO are_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Itornka ekuranhaka ilthurna irrpunhamalantama, Jesuala relha ntjarranha araka nthorrkngerramanga, ltarrpaka music turta angkalhelamanga. ");
INSERT INTO are_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Erantama etnanha ilaka, “Kala rratantai! Kwarra era itjama errilknga. Era wara ankwentama.” Etna pula ekura tharrakala. ");
INSERT INTO are_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Relha nhanha etna kala rratakalangantama, Jesuanha irrpunhamala kwarra erinha iltjanga errkuka, erinha kamalhelaka turta. ");
INSERT INTO are_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yia nhanha kala pmara ntjaparurnantama ntakerranhaka. ");
INSERT INTO are_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesuanha anpara lhamalanga, artwa panga tharra ekuranga ingkarnanga ilkarlapuka, “David-aka 'Lirai, ilirnaka montjamontja ntelalhai.” ");
INSERT INTO are_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesuanha kala ilthaka irrpunhakalangantama, artwa panga eratharra ekururna etinyerraka. Jesualantama erinhatharra pmarraka, “Mpala tnakamama atha mpalanha irrpalthala marrilamara?” Eratharra angkaka, “Awa, Ingkartai.” ");
INSERT INTO are_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesualantama alknga ekuratharra anpumala, erinhatharra ilaka, “Mpala yinganha tnakakalanga, atha alknga mpalaka marrilama.” ");
INSERT INTO are_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Eratharrantama kala araka. Jesualantama erinhatharra angkatja ekarltala ilaka, eratharra itja inthorra yia nhanhiperra ilitjika. ");
INSERT INTO are_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Eratharra pula yia nhanha pmara ntjaparala ilarlapuka. ");
INSERT INTO are_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Artwa panga nakala nhanga tharra kala ilthanga rratamala lhaka. Relha arrpunha ntjarralantama artwa pmarna nyintanha Jesuurna kngitjika. Artwa erataka enka kornakarta naka. ");
INSERT INTO are_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesuala enka korna erinha kala unpukalangantama, artwa era angkaka. Relha etna pula tnolkaka nhanha aramala. Etna angkaka, “Lakinha ngerra itja arrkurla pmara Israel-ala naka paka.” ");
INSERT INTO are_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Artwa Pharisee ntjarra pula lakinhala angkaka, “Errintjaka itornkala erinha ekarltilakalanga, era enka korna ntjarranha unpuma.” ");
INSERT INTO are_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesuanhantama town kurrka ntjarrurna, town kngarritja ntjarrurna turta lhaka. Erantama relha etnanha synagogue etnakanhala kaltjinthaka. Era relha ntjarranha ilaka Altjirranha kala relha ingkarrakaka Ingkarta namanga. Era relha menta ntjarranha, thaltja ntjarranha turta marrilaka. ");
INSERT INTO are_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Relha worla etnanha aramala, Jesuanha etnaka konyerraka. Etna kunha sheep errarnperrakala ngerra naka, tnairnarintjakunya, nakapakarla turta. ");
INSERT INTO are_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesualantama kurtungurla ekuranha ntjarranha ilaka, “Arai, relha ntjarra inthorrala Altjirraka Angkatja wutjika antja. Altjirranha turta antja nama etna angkatja ekuranha wutjika. Urrpia etna pula urrputja inthorrarrpala. ");
INSERT INTO are_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Lakinhanga rrangkarra Altjirrurna ingkitjika, era urrpia ntjarra urraritjika, etnanha turta relha ntjarrurna yairnitjika, relha etnanha angkatja ekuranha ilitjika.” ");
INSERT INTO are_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesuala kurtungurla 12 ekuranha ntangkamala worlilaka. Erantama etnanha ekarltilaka enka korna ntjarranha relhanga unpurlenitjika. Relha arrangkulthanga menterrakala ntjarranha marrilitjika. Relha menta arrpunha ntjarranha turta marrilitjikantema. ");
INSERT INTO are_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nhanha Apostle 12 etnaka rretnya naka. Arrkurla Simon, rretnya arrpunha ekura Peter, tjia ekura Andrew turta. James, tjia ekura John turta, Zebedee-aka worra tharra. ");
INSERT INTO are_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip, Bartholomew tharra. Thomas, Matthew tharra. Matthew erataka tax money kotjinha nakala. James arrpunha nhanga, Alphaeus-aka worra, Thaddaeus turta. ");
INSERT INTO are_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, pmara Canaan-arinya. Judas Iscariot turta, erala Jesuanha anma leltjaka lanthakala. ");
INSERT INTO are_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Artwa 12 nhanha etnanha Jesuala urrpia yairnaka, lakinha turnamala. “Rrangkarra itja Relha Lorinya ntjarrurna lhitjika. Rrangkarra turta itja relha Samaria-arinya ntjarraka town-urna irrputjika. ");
INSERT INTO are_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Rrangkarra pula relha Israel-arinya ntjarrurnatitja lhitjika. Etna sheep pairlperrakala ntjarra ngerra nama. ");
INSERT INTO are_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Rrangkarra tjaiyala lhapalhamala, relha ntjarranha ilai Altjirranha kala relha ingkarrakaka ntelalhitjikerrama, era Ingkarta etnaka namanga. ");
INSERT INTO are_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Relha menta ntjarranha marrilai. Relha errilknga ntjarranha etathilai. Relha leprosy-akarta ntjarranha marrilai. Relha enka kornakarta paka namanga, enka korna erinha unpai. Arai, Altjirrala rrangkarranha kapanhanta ekarltilaka relha mentanha marrilitjika. Rrangkarrantama relha mentanha kapanhantantema marrilai. ");
INSERT INTO are_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Rrangkarra pula itja money-alka kngitjika. ");
INSERT INTO are_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Rrangkarra turta itja thauwakarta, shirt arrpunhakarta, sandal-akarta, erratitjakarta paka lhitjika. Arai, urrkapunhapunhakathaka nama etna erinha marnala wantitjika. ");
INSERT INTO are_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Rrangkarrantama town kngarritjurna irrpumanga, town kurrkurna paka, relha ilporathaka yonthai. Kurunga ekuralela kuterrai, rrangkarra anparerritjinalpula. ");
INSERT INTO are_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Rrangkarra relha ilporatha ekuranhaka ilthurna irrputjinala, rrangkarra ilthala namala etnanha ilitjika, “Altjirranha rrakangkarra rilhera ntelalhama.” ");
INSERT INTO are_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ilthala namala etna paka nthurrpa ilporatha namanga, Altjirranha etnaka rilhera kuta ntelalhitjina. Itjanga paka, itja kutala. ");
INSERT INTO are_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Thunga relha arrpunha ntjarra rrakangkarra antjakunya. Thunga etna rrakangkarra itja kangkwerrama. Kala iltha etnakanhanga, town etnakanhanga turta, rratai. Pmara lenhaka urlpmurra turta ingka rrakangkarranhanga ilarnai. ");
INSERT INTO are_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Atha rrangkarranha nthurrpa ilama, yinga pitjalpumanga relha ingkarrakanha tjiperrawutjika, atha pmara lenha ntjarranha kngarralkura rrarrathala tutjina, pmara Sodom Gomorrah tharrangatjina.” ");
INSERT INTO are_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Atha rrangkarranha sheep ngwanga ntjarra ngerra yairnama, kngulya itnura ntjarranga mpopurna ngerra. Rrangkarrantama aralhitjika inthorra. Rrangkarra pula itja pmatha ntelalhitjika. ");
INSERT INTO are_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Arai, artwa arrpunha ntjarrala rrangkarranha Sanhedrin court-urna kngitjina. Etna turta rrangkarranha synagogue kwanala whip-ala tutjina. ");
INSERT INTO are_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Etna turta rrangkarranha itornka kngarra ntjarranga urlarra ilparnitjina, king ntjarranga urlarra turta, nukanga arrkngala. Nhanha pula lakinherritjina rrangkarra itornka kngarra etnanha, Relha Lorinya ntjarranha turta nukiperra ilitjinanga. ");
INSERT INTO are_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Arai, etna paka rrangkarranha errkumanga, rrangkarra itja thakerramala eterritjika, ‘Nthakinhama nurna angkitjika? Iwunhama nurna etnanha ilitjika?’ Arai, angkatja rrangkarrala angkitjika, angkatja nhanha Kaartaka Enkala rrangkarranha kala ilitjina. ");
INSERT INTO are_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Enka era rrakangkarrarlarlanga angkitjina, itja rrangkarrarrpa. ");
INSERT INTO are_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Artwalantama kalya ekuranha, tjia ekuranha paka relha arrpunha ntjarraka lanthitjina, etna erinha errilknga tutjika. Kaartala turta katjia ekuranha relha arrpunha ntjarraka lanthitjina, etna erinha errilknga tutjika, katjiala turta kaarta pa mia ekuranha. ");
INSERT INTO are_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Relha ingkarraka rrakangkarra antjakunya nitjina. Altjirrala pula rrangkarranha tangkalhelitjina, rrangkarra yinganha talwalpula tnakamanga. ");
INSERT INTO are_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Relhala paka rrangkarranha town nyintala tutjika lurnamanga, kala town arrpunhurna arrtjanai. Atha rrangkarranha nthurrpa ilama, rrangkarra town ntjarra arrpunhurna itjantema lhakalanga, Relhaka 'Lira kala pitjalputjina. ");
INSERT INTO are_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Relha erala kaltjerrama, era itja kaltjinthanhinthanha ekuranhanga kaltjalkura nama. Urrkapunhapunha turta itja itornka ekuranhaka tjitjarta nama. ");
INSERT INTO are_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Relha erala kaltjerrama, ekurathaka nama kaltjinthanhinthanha ekuranha ngerra kaltjerritjika. Urrkapunhapunha ekurathaka turta nama, itornka ekuranha ngerra erritjika. Etna paka yinganha rretnya Beelzebub ilamanga, etna kala rrangkarranha turta rretnya nhanha ilitjinantema. ");
INSERT INTO are_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Rrangkarra itja relhanga trerritjika. Yia nhanga relhalala lyarta korltama, nhanha Altjirrala anma kathilitjina. Yia nhanga relhalala lyarta lauwuma, nhanha Altjirrala kala relha ingkarrakanha alpmelitjina. ");
INSERT INTO are_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yia athala rrangkarranha ingwala ilamanga, rrangkarra relha ntjarranha arltala ilitjika. Yia athala rrangkarranhanta ilama, rrangkarra kala relha ingkarrakanhala ilitjika. ");
INSERT INTO are_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Itja relhanga trerrai. Etna kala mpurrkanta irrpalthala errilknga tuma. Rrangkarra pula Altjirrangatitja trerrai. Era mpurrka pa kurruna irrpalthala yirralhelama, tatharrala. ");
INSERT INTO are_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Relhala kunha nyenka tharra yirrinthama money kurrka inthorraka. Kanha Altjirranha kalantemala kaltja nyenka nyinta paka ilumanga. ");
INSERT INTO are_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kapurta ponga nthakintja paka kapurta rrakangkarranhala nama? Altjirranha kala kaltja. ");
INSERT INTO are_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Lakinhanga rrangkarra itja trerritjika. Altjirranga urlarra rrangkarra tjiparralkura nama nyenka ntjarrangatjina.” ");
INSERT INTO are_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Relha erala relha ntjarranga urlarra ilalhamanga era tjina nuka namanga, atha turta Kaarta nukanha alkirala ilitjina era tjina nuka namanga. ");
INSERT INTO are_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Relha era pula, erala ilalhamanga era nuka antjakunya, atha Kaarta nukanha alkirala ilitjinantema, yinga ekura antjakunya namanga.” ");
INSERT INTO are_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Thunga rrangkarra etarlarama yinga kula alha nhanhurna pitjikala, relha ntjarranha rilherilitjika. Itja inthorra. Relha etna pula kngarralkura turritjinatitja, nukanga arrkngala. ");
INSERT INTO are_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","'Lira kaarta ekuranhaka irrpaltherritjina. Kwarra mia ekuranhaka irrpaltherritjina. Nharra turta mara ekuranhaka irrpaltherritjina. ");
INSERT INTO are_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Arai, relhaka leltja kala ramarama ekuranha inthorra nitjina. ");
INSERT INTO are_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Katjia paka kaarta ekuranhaka, mia ekuranhaka kngarralkura kangkamanga nukangatjina, era yarna kurtungurla nuka nama. Kaarta paka, mia paka katjia ekuranhaka kngarralkura kangkamanga nukangatjina, era turta yarna kurtungurla nuka nama. ");
INSERT INTO are_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Relha erala kurtungurla nuka nitjika antja, era kala ntolka ekuranha kngarnitjika, nukanga tnaartangala pitjitjika turta. ");
INSERT INTO are_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Arai, relha erala etatha nitjikanta thakerrama, era kala ilutjina. Kanha relha era, erala relha arrpunha ntjarranha impurlarrarnama erinha errilknga tutjika, nukanga arrkngala, era kala ngampakalala etatha nitjina.” ");
INSERT INTO are_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Relha erala rrakangkarra kangkintja ntelalhama, era nuka kangkintja ntelalhama. Relha erala nuka kangkintja ntelalhama, era turta ekura kangkintja ntelalhama, erala yinganha yairnakala. ");
INSERT INTO are_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Relha erala Altjirraka urrpiaka kangkintja ntelalhama, erinha Altjirrala kwartiwutjina, erala urrpia erinha kwartiwutjinala ngerra. Relha erala relha arratjaka kangkintja ntelalhama, erinha Altjirrala kwartiwutjina, erala relha arratja erinha kwartiwutjinala ngerra. ");
INSERT INTO are_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Relha erala kurtungurla kornakorna nyinta nukanha kwatja karnta ntjutjika nthamanga, era kurtungurla nuka namanga, Altjirrala erinha kala kwartiwutjina.” ");
INSERT INTO are_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kurtungurla 12 ekuranha kaltjinthamaliperra, Jesuanha kala anpara lhaka town arrpunha ntjarrurnantama. Tanhala era relha ntjarranha kaltjinthaka, etnanha Yia Marra erinha turta ilaka. ");
INSERT INTO are_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","John-anha jail-ala naka. Erantama yia wuka Kristala relha ntjarranha kaltjinthamanga, era turta tjatjikarta urrkapumanga. John-alantama kurtungurla urrputja ekuranha Kristurna yairnaka erinha lakinha pmarritjika, ");
INSERT INTO are_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Unta paka nthurrpa Tangkalhelanha era nama, Altjirralala imanka relha ekuranha ntjarranha lhelakala, yairnitjika? Nurna paka arrpunhaka kaaralhitjika?” ");
INSERT INTO are_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesuala etnanha ilaka, “Alpumala John-anha ilai nhanga rrangkarrala wumanga, aramanga turta. ");
INSERT INTO are_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Relha panga ntjarrala wotha arama. Relha inurra ntjarra wotha ingka lhama. Relha leprosy-akarta ntjarra wotha marrerrakala nama. Relha ilpa rirta ntjarrala wotha wuma. Relha ilukala ntjarra wotha etatherrakala nama. Atha, kurtungurla nukanha ntjarrala turta, relha kornarintja ntjarranha Yia Marra erinha ilama. ");
INSERT INTO are_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Arai, relha lenha ntjarra arrkana nitjina, etnala yinganha kuta tnakamanga, itja ilpoiwumanga turta.” ");
INSERT INTO are_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","John-aka kurtungurla urrputja etna kala alpumangantama, Jesuanha relha ntjarrurnantama angkaka, John-iperra. Era etnanha pmarraka, “Artwa iwunha ngerranhama rrangkarra nhanga worritjurna aritjika lhaka? Artwa tjakatjakanha, pmoltatja ngerra ngalhamanga wurinyala warnamanga? Itja kunha. ");
INSERT INTO are_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Artwa iwunha ngerranhantama rrangkarra aritjika lhaka? Artwa mantarra marra inthorraka ekarralhakalaka? Itja kunha. Relha etnala mantarra marra inthorraka ekarralhakala, etna kunha king-akanha pmarala nama. ");
INSERT INTO are_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Artwa iwunha ngerra inthorranhantama rrangkarra aritjika, lhaka? Altjirraka urrpia? Era nthurrpa Altjirraka urrpia naka. Era pula Altjirraka urrpia ingkarrakanga kngarralkura naka. ");
INSERT INTO are_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ekuriperra kunha Altjirraka Angkatja Imankinyala ilaka, ‘Atha urrpia nukanha ungkwanganga arrkurla yairnama. Era kala ungkwanga tjaiya urrkaputjina.’ ");
INSERT INTO are_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Atha rrangkarranha nhanha nthurrpa ilama. John Kaltjirrpulhelanhelanha era kunha Altjirraka urrpia tjiparralkura era naka. Nhanha turta pula nthurrpantema nama. Relha tnakanhakanha kornakorna inthorra, era kala Altjirranga urlarra tjiparralkura nama, John ekurangatjina. ");
INSERT INTO are_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Arai, John Kaltjirrpulhelanhelanha era relha ntjarranha kaltjinthitjikerramangatjina, lyartalpula, relha korna ntjarra Altjirraka irrpaltherrama. Etna Altjirraka urrpia ntjarranha tuma turta. Iwunhanga? Urrpia etna, etnanha kaltjinthamanga Altjirranha relha ingkarrakaka Ingkarta namanga. ");
INSERT INTO are_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Imanka Altjirranha relha ekuranha ntjarrurna angkaka Moses-arlarlanga, urrpia ekuranha arrpunha ntjarrarlarlanga turta. Lyarta era itja wotha relha ekuranha ntjarrurna angkama etnakarlarlanga, John-anha kala pitjikalangantama. ");
INSERT INTO are_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Lyarta rrangkarra paka angkatja nukanha arratja wumanga, rrangkarra kaltja nitjina John-anha Elijah era namanga, urrpia nhanga Altjirrala yairnitjika lhelakala. ");
INSERT INTO are_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ungkwanga ilpa paka intamanga, yinganha wurlathanai.” ");
INSERT INTO are_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jesuala etnanha pmarraka, “Relha ngunha ngerrama rrangkarra? Atha rrangkarranha iliai? Rrangkarra kunha katjia ntjarra ngerra nama, etnala kathala arrkanerrama. Katjia arrpunha ntjarrala rrangkarranha ntangkama, ");
INSERT INTO are_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nurna arrkanerriai, nthaperramala.’ Kanha rrangkarra antjakunyala. Kurunga etna rrangkarranha wotha ntangkama, ‘Nurna arrkanerriai, relha ilukalaka nthorrkngerramala.’ Kanha rrangkarra itja kutala antja arrkanerritjika. ");
INSERT INTO are_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Arai, John-ala itja marna marra ilkutjata, wine paka ntjutjata. Rrangkarrantama angkaka era kula artwa rirta namanga, enka kornakarta. ");
INSERT INTO are_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kurunga Relhaka 'Lira pitjika. Era marna marralka ilkuma, wine turta ntjuma. Rrangkarrantama angkama era kula artwa kwapakwapa ilkunhilkunha namanga, drunk-erranha turta. Rrangkarra turta erinha arrampowumala ilama, era tax money kotjinha ntjarraka, kornarintja arrpunha ntjarraka turta tjina namanga. Altjirranha pula inangkarla kuta urrkapuma. Nhanha kala ingkarna katherritjina.” ");
INSERT INTO are_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Town arrpunhala Jesuala tjatjikarta ntjarra urrkapuka. Relha town nhanharinya etna pula itja Altjirrurna toperraka. Jesuanhantama relha nhanha etnaka aalerraka, etnanha ilaka turta. ");
INSERT INTO are_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Relha Chorazin town-arinya ntjarrai, rrangkarra nakapakarla inthorra nitjina. Relha Bethsaida town-arinya ntjarrai, rrangkarra turta nakapakarla inthorra nitjina. Atha rrakangkarranga alkngatharra tjatjikarta ntjarra urrkapuka. Atha paka tjatjikarta nhanha etnanha relha Tyre town-arinya, relha Sidon town-arinya ntjarranga turta alkngatharra urrkapukalanga, etna pmara imanka Altjirrurna toperramara. Etna kala ltarrpakanha mantarraka ekarralhamara, ilpminya turta kapurtaka arrarnamara. ");
INSERT INTO are_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lakinhanga atha rrangkarranha ilama, Altjirranha pitjimalanga relha ntjarranha tjiperrawutjika, nhanha rukaralkura nitjina relha Tyre-arinya ntjarraka, relha Sidon-arinya ntjarraka turta, nhanhala rrakangkarra nitjinangatjina. ");
INSERT INTO are_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Relha Capernaum town-arinya ntjarrai, rrangkarra etarlarama Altjirrala kula rrangkarranha alkirurna kngitjina. Itjanga lhai. Rrangkarranha pula Altjirrala tatharrurnatitja naamalhelitjina. Atha tjatjikarta ntjarra rrakangkarranga alkngatharra urrkapuka. Altjirrala paka tjatjikarta nhanha etnanha Sodom-ala urrkapukalanga, town era kuta namarantema. ");
INSERT INTO are_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lakinhanga atha rrangkarranha ilama, Altjirranha pitjimalanga relha ntjarranha tjiperrawutjika, nhanha rukaralkura nitjina relha Sodom-arinya ntjarraka, nhanhala rrakangkarra nitjinangatjina.” ");
INSERT INTO are_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesuanha lakinhantama angkaka, “Kaartai, unta Ingkarta nama alkiraka alhaka turta. Athantama nganha dangkilama, unta angkatja ungkwanganha relha kornakorna ntjarraka nentilakalanga, itja pula relha kaltja ntjarraka, inangkarla ntjarraka turta. ");
INSERT INTO are_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kaartai, untarrpa kunha lakinha ntelalhitjika antja naka. ");
INSERT INTO are_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Arai, Kaartala yinganha ingkairnaka relha ingkarrakaka Ingkarta nitjika. Relha nyinta itja 'Liraka kaltja, Kaarta eranta wara. Relha nyinta turta itja Kaartaka kaltja, 'Lira eranta wara. 'Lira era turta Kaarta erinha relha ekura imarnama, ekurala era antja nama Kaarta erinha imarnitjika. ");
INSERT INTO are_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Relha rrangkarrala nakapakarlerrama, yarna turta eterritjikerrama, nukurna pitjarrirrai. Atha kala rrangkarranha rukarilitjina. ");
INSERT INTO are_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kala nukanta kangkwerrai. Kaltjerrai turta yinga ngerra nitjika. Yinga kunha artwa ngwanga nama. Yinga turta itja tjurnalhama. Rrangkarra paka nukanga tnaartangala pitjimanga, nukanga kaltjerramanga turta, rrangkarra kala rukara nitjina. ");
INSERT INTO are_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Arai, atha rrangkarranha itja nakapakarlilama, inporilama paka.” ");
INSERT INTO are_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabbath arlta arrpunhala Jesuanha, kurtungurla ekuranha ntjarra turta, tnukulpanga tjananhaka. Tnukulpa nhanha ekurala marna wheat urnma itnaka. Jesuaka kurtungurla ntjarra ngaiyala namala, etna marna mpakamala ilkuka. ");
INSERT INTO are_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Artwa Pharisee urrputjala nhanha araka. Etnantama Jesuanha ilaka, “Kurtungurla ungkwanganha ntjarrataka paala ntelalhama. Nhanha itjama arratja nama Sabbath arltala marna mpakitjika.” ");
INSERT INTO are_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesuala etnanha pmarraka, “Rrangkarra itjala David-iperra kaltja? Era nhanga ngaiyala naka, artwa ekuralela namala ntjarra turta. ");
INSERT INTO are_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David-anhantama Altjirraka ilthurna irrpunhaka. Iltha ekurala marna intaka, relha ntjarrala Altjirranha tjauwerrilya nthakala. Nhanha priest-akanta naka ilkutjika. David-ala pula marna nhanha ilkukala, ngaiyalala warta. Era turta marna nhanha artwa ekuralela namala ntjarranha nthaka, ilkutjika. Lakinha David-anha Altjirraka mpaarangarangaka itja kangkwerraka. ");
INSERT INTO are_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Rrangkarra turta itjala read-erraka Altjirraka Angkatja Imankinyala, Altjirrala priest ntjarranha impurlarrarnakala temple-ala urrkaputjika Sabbath arltala? Altjirrala pula etnanha itja imilaka. ");
INSERT INTO are_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Athantama rrangkarranha ilama, nyinta lyarta kala nhanhala nama, erala temple-aka mpaarangarangaka turta Ingkarta nama. ");
INSERT INTO are_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Angkatja nhanha wurlathanai. ‘Yinga antja rrangkarra montjamontja ntelalhitjika, itja yinganha tnontha tjauwerrilya nthitjika.’ Rrangkarra angkatja nhanha lhangkaramama? Itja kunha, rrangkarra kurtungurla nukanha ntjarranha palkala ilparnamanga warta. ");
INSERT INTO are_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Arai, Relhaka 'Lira era Sabbath arlta ekura turta Ingkarta nama. ");
INSERT INTO are_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Anparantama lhamala, Jesuanha synagogue etnakanhurnantama irrpuka. ");
INSERT INTO are_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kwanala artwa nyinta naka, iltja ntjirrkakarta. Etnantama Jesuanha pmarraka, “Nhanha arratjama nama relhanha Sabbath arltala marrilitjika?” Etnataka erinha ilparnitjinala pmarraka. ");
INSERT INTO are_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesuala pula etnanha pmarraka, “Thunga artwaka sheep nyinta nama. Sheep era turtantama ipartaka tnyima, Sabbath arltala. Nthakinhantama? Artwa era kunha sheep erinha Sabbath arltalantema ipartanga urlpuntjitjina. ");
INSERT INTO are_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Relhantama sheep-anga tjiparralkura nama. Lakinhanga nhanha kala arratja nama Sabbath arltala relha mentanha marrilitjika.” ");
INSERT INTO are_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesualantama artwa iltja ntjirrkakarta erinha ilaka, “Iltja ungkwanganha imarnai.” Erantama iltja ekuranha imarnaka. Iltja ekuranha turta kala marrerraka. Iltja era turtantama iltja arrpunha ekuranha ngerra naka. ");
INSERT INTO are_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Artwa Pharisee ntjarra kala synagogue ekuranga rratamala lhaka. Etnantama angkarraka Jesuanha errilknga tutjika. ");
INSERT INTO are_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Eterrintja etnakanhaka kaltja namala, Jesuanha anpara lhaka. Worla kngarra pula ekuranga tnaartangala kuta lhaka. Relha ntjarra arrpunha menta aramala, Jesuala etnanha marrilaka. ");
INSERT INTO are_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Era pula etnanha ilaka, etna itja relha arrpunha ntjarranha nhanhiperra ilitjika. ");
INSERT INTO are_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nhanga Altjirralala Isaiah-arlarlanga lhelakala nthurrperrakantama, ");
INSERT INTO are_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Arai, artwa nhanha era kunha urrkapunhapunha nukanha nama. Atharrpa erinha urraraka. Yinga turta ekura kngarra kangkama. Atha Enka nukanha ekururna yairnitjina. Erantama Relha Lorinya ntjarranha ilitjina atha Ingkartala etnanha tangkalhelitjinala. ");
INSERT INTO are_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Era itja relha ntjarralela iwurritjina. Era itja ilkarlaputjina. Etna turta erinha itja wutjina, tjaiyala intarra angkamanga. ");
INSERT INTO are_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Era relha thaltja ntjarraka tangitjala nitjina. Era itja relha imampurlerrakala ntjarranha ipmintja imputjina. Era etnakalela kuterritjina, Altjirrala etnanha tangkalhelitjinalpula. ");
INSERT INTO are_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ekura Relha Lorinya ntjarra kaaralhitjina, era etnanha tangkalhelitjika.” ");
INSERT INTO are_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Relha urrputjalantama artwa nyintanha Jesuurna kngitjika. Artwa era enka kornakarta naka. Lakinhanga era alknga panga naka, era turta yarna angkaka. Jesuala erinha marrilaka. Artwa erantama angkaka, araka turta. ");
INSERT INTO are_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nhanha aramala relha worla etna tnolkaka, ilarraka turta, “Yai, nhanha eralama David-aka 'lira nama.” ");
INSERT INTO are_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nhanha wumala, artwa Pharisee ntjarra angkaka, “Artwa nhanhalataka enka korna ntjarranha unpurlenama, Beelzebub-ala erinha ekarltilakalanga. Beelzebub era kunha errintja ntjarraka itornka nama.” ");
INSERT INTO are_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesuanha kala kaltja naka etnala eterramalaka. Erantama etnanha ilaka, “Relha pmararinya ntjarra leltjakaleltjerramanga, pmara etnaka kala ipmintjerritjina. Ramarama turta. Etna leltjakaleltjerramanga, etna kala yirritjinantema. ");
INSERT INTO are_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satan-alantama enka korna ntjarranha unpurlenamanga, Satan-aka worla turta kala leltjakaleltjerraka. Etna turtantama ipmintjerritjina. ");
INSERT INTO are_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Arai, rrangkarra yinganha ilama atha kula enka korna ntjarranha unpurlenama, Beelzebub-ala yinganha ekarltilakalanga. Ngunhalantama kurtungurla rrakangkarranha ekarltilama, enka korna etnanha unpurlenitjika? ");
INSERT INTO are_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Atha pula enka korna etnanha unpurlenamanga Altjirraka Enkala yinganha ekarltilakalanga, rrangkarra kaltja nitjika Altjirranha kala ntelalhamanga era relha ingkarrakaka Ingkarta namanga. ");
INSERT INTO are_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Arai, thunga relha antja nama, artwa ekarltaka ilthurna irrputjika, yultha ekuranha turta nyilkngala initjika. Era kunha artwa ekarlta erinha errkumala yirnitjikarrka. Kurunga era yultha ekuranha irrpalthala nyilkngala kngama. ");
INSERT INTO are_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Relha erala itja tjina nuka nama, era kala leltja nuka nama. Relha erala itja nukalela porta urrkapuma relhanha Altjirrurna rretjingitjika, era etnanha kala Altjirranga parrama. ");
INSERT INTO are_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Atha rrangkarranha nhanha ilama. Thunga relha korna inthorra ntelalhama, Altjirranha arrampowuma turta. Altjirrala kala korna ekuranha iwutjina, era paka ekururna toperramanga. Kanha relha erala Enka Alkngaltara erinha arrampowuma, korna ekuranha Altjirrala itjala iwutjina. ");
INSERT INTO are_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Relha erala Relhaka 'Liriperra korna angkamanga, Altjirrala kala korna ekuranha iwutjina, era paka Altjirrurna toperramanga. Kanha relha erala Enka Alkngaltariperra korna angkama, Altjirrala korna ekuranha itja kutala iwutjina, lyarta anma paka.” ");
INSERT INTO are_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Irna paka marra namanga, annga ekuranha marrantema nitjina. Irna era paka korna namanga, annga ekuranha kornantema nitjina. Annga ekuranhanga kunha relhala lhangkarama irna era paka marra namanga, korna paka. ");
INSERT INTO are_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Apma ngerra ntjarrai. Relha korna warta, rrangkarra yarna angkatja marra angkama. Arai, relhala eterramanga ngerra, lakinha era kala angkama. ");
INSERT INTO are_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Relha marra, era marra eterramanga warta, era kala marra angkama, marra turta ntelalhama. Kanha relha korna, era korna eterramanga warta, era kala korna angkama, korna turta ntelalhama. ");
INSERT INTO are_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Arai, atha rrangkarranha nhanha ilama. Yinga pitjalpumanga relhanha tjiperrawutjika, atha relha nyintaminyintanha pmarritjina erala angkakalaka. ");
INSERT INTO are_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Athantama lenha ntjarranha tangkalhelitjina, etnala arratja angkakala. Atha turta lenha ntjarranha imilitjina, etnala korna angkakala.” ");
INSERT INTO are_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Artwa Pharisee urrputjala, artwa Intarrangaltha urrputjala turtantama Jesuanha pmarraka, “Kaltjinthanhinthanhai, nurnanha tjatjikarta alkirarinya ntelai.” ");
INSERT INTO are_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesuala pula etnanha ilaka, “Rrangkarrataka relha korna nama, Altjirranha ilpoiwunha turta. Lakinhanga rrangkarra antja nama atha rrangkarranha tjatjikarta alkirarinya ntelitjika. Atha pula rrangkarranha tjatjikarta nhanganta ntelitjina, Altjirralala Jonah-anha ntelakala. Itja arrpunha. ");
INSERT INTO are_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonah era irrpannga kngarritjaka tnartala intaka arlta tharraminyinta, ingwa tharraminyinta turta. Lakinha ngerra Relhaka 'Lira era turta alhaka tnartala intitjina arlta tharraminyinta, ingwa tharraminyinta turta. ");
INSERT INTO are_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Arai, Altjirranha pitjimalanga relha ingkarrakanha tjiperrawutjika, relha Nineveh-arinya ntjarrala rrangkarranha ilparnitjina. Etna kunha Altjirrurna toperraka Jonah-ala etnanha tjatjatumalanga. Lyarta pula artwa nyinta nhanhala nama, erala rrangkarranha angkatja ekarltalkurala tjatjatuma. ");
INSERT INTO are_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Relha Sheba-arinya ntjarraka queen, era turta rrangkarranha ilparnitjinantema. Era kunha pmara ilanga inthorranga pitjikala Solomon-anha wutjika, Solomon-anha inangkarla inthorra namanga. Lyarta pula artwa nyinta rrakangkarrurna angkama, erala Solomon-anga inangkarlalkura nama.” ");
INSERT INTO are_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Arai, enka korna paka relhanga rratamanga, era worritjala nthulapuma, pmaraka yonthamala. Pmaraka yarna yonthamala, ");
INSERT INTO are_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","era lakinha angkama, “Yinga alputjina, pmara yingala rratakala ekururna.” Pitjalpumala era pmarangkinya arama. Era turta arama relha era pmara erinha ilkngikala, intortilakala turta. ");
INSERT INTO are_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Erantama lhamala enka kornalkura 7 inarlalhama. Etnantama porta pmara intortilakala ekururna irrpuma, kuterrama turta. Relha erantama imampurlalkura nama arrkurlangatjina. Lakinha relha korna rrakangkarralela turta nitjina.” ");
INSERT INTO are_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesuanha nhanga worlurna angkamalangantema, Jesuaka mia pa tjia ntjarra pitjika ekuralela angkitjika. Etnantama ekura kathala kaaralhaka. ");
INSERT INTO are_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Relha arrpunhala Jesuanha ilaka, “Arai, mia ungkwanga, tjia ungkwanga ntjarra turta kathala kaaralhama ungkwangalela angkitjika.” ");
INSERT INTO are_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesuala pula relha erinha pmarraka, “Ngunhama mia nuka? Ngunha ntjarrama tjia nuka?” ");
INSERT INTO are_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kurtungurla ekuranha ntjarranhantama iltjala ntelamala, era etnanha ilaka, “Rrangkarra mia pa tjia nuka ntjarra nama. ");
INSERT INTO are_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Relha etnala Kaarta alkirarinya nukanhaka kangkwerramanga, etna kunha tjia nuka nama, mia nuka turta.” ");
INSERT INTO are_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Arlta nyinta ekuralantema, Jesuanha ilthanga rratamala lhaka, kwatja ntjangurna. Erantama ankerraka arrarnalhaka. ");
INSERT INTO are_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Relha ntjarra inthorrantama ekururna worlerrentjalpuka. Lakinhanga era boat-aka ntjika, boat-ala arrarnalhaka turta. Kanha relha etna ankerralala itnaka. ");
INSERT INTO are_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesualantama etnanha kngarra kaltjinthaka, etnanha yia alpmelamala. Erantama etnanha yia nhanha ilaka. “Artwa nyinta tnukulpa ekuranhurna lhaka annga ingkairnitjika. ");
INSERT INTO are_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Erantama annga etnanha alpantiwumalanga, annga arrpunha ntjarra tjaiyakarlaka tnyika. Thepa ntjarrantama pitjika, annga etnanha ilkuka turta. ");
INSERT INTO are_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Annga arrpunha ntjarra arna partapapathakarlaka tnyika. Etna parrpa lyapuka, arna era tarratha wara warta namanga. ");
INSERT INTO are_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lirnnga era pula rratamalanga, lirnngala marna kurrka etnanha ntjirrkilamala mpuka, takarra etnaka yarna warta arna kwanurna irrpukalanga. ");
INSERT INTO are_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kala annga arrpunha ntjarra lyakanga mpopakarlakala tnyika. Lyaka etnantama mangkamala marna kurrka etnanha ulpulatuka. ");
INSERT INTO are_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kala annga arrpunha ntjarra arna marrakarlakala tnyika. Arrpunhala 100 annga lhalhelaka, arrpunhala 60, kala arrpunhala 30.” ");
INSERT INTO are_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ungkwanga ilpa paka intamanga, yinganha wurlathanai.” ");
INSERT INTO are_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesuaka kurtungurla ntjarrantama ekururna pitjimala, erinha pmarraka, “Iwunhangama unta relha ntjarranha kaltjinthama, etnanha yia alpmelamala?” ");
INSERT INTO are_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesuala etnanha ilaka. “Yinga antja nama rrangkarra kaltja nitjika Altjirranha kala pitjikala relha ingkarrakaka ntelalhitjika era Ingkarta namanga. Yinga pula itja antja arrpunha ntjarra nhanhaka kaltja nitjika. ");
INSERT INTO are_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Relha erala Altjirraka Angkatjaka kangkama, urntwarra kaltjerritjika turta antja nama, erinha Altjirrala wothalkura kaltjinthitjina. Kanha relha erala Altjirraka Angkatjaka antjakunya, erinha Altjirrala itja kutala kaltjinthitjina. ");
INSERT INTO are_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Lakinhanga atha etnanha yiala alpmelama. Etnaka alknga intama, etna pula itja arama. Etnaka ilpa intama, etna pula itja wuma. ");
INSERT INTO are_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Arai, Isaiah-anhataka relha nhanha ntjarriperra angkaka. Angkatja ekuranhantama nthurrperraka. Era etnakiperra lakinha angkaka, ‘Rrangkarra kala wurlanitjina, rrangkarra pula itja lhangkaritjina. Rrangkarra kala ararlanitjina, rrangkarra pula itja lhangkaritjina. ");
INSERT INTO are_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Arai, atha relha nhanha ntjarraka eterrintja parrpartilaka, atha ilpa etnakanha marntilaka, alknga etnakanha turta pangilaka. Atha etnanha lakinhilaka etna alkngala arakitja, etna ilpala wukitja, etna turta eterrintja etnakanhala lhangkarakitja. Etna turtantama toperrakitja, atha turtantama etnanha tangkalhelakitja.’ ");
INSERT INTO are_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Rrangkarra arrkana nama, Altjirrala rrangkarranha marrilakalanga. Lakinhanga alknga rrakangkarranhala arratja arama, ilpa rrakangkarranhala turta arratja wuma. ");
INSERT INTO are_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Atha rrangkarranha nhanha turta nthurrpa ilama. Altjirraka urrpia imankinya ntjarra, relha errilkngipata arratja ntjarra turta antja naka aritjika, nhanha rrangkarrala lyarta arama. Etna pula nhanha itja araka. Etna turta antja naka angkatja nukanha wutjika, angkatja nhanga rrangkarrala wuma. Etna pula nhanha itja wuka. ");
INSERT INTO are_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Wurrirraintama, atha yia nhanga annga alpantiwunhiperra nentilamanga. ");
INSERT INTO are_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Thunga relhala Altjirraka angkatja wuma, angkatja nhanga Altjirranha relha ingkarrakaka Ingkarta namanga. Thunga pula era angkatja nhanhiperra itja arratja etarlarama. Nthakinhantama erritjina? Errintja era pitjitjina, angkatja erinha rakitjina turta. Nhanha kala annga etna ngerra nama, etnala tjaiyaka tnyikala. ");
INSERT INTO are_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Annga nhanga arna partapapathakarlaka tnyikala, nhanha kala relha nhanha ngerrala nama. Era kngarra kangkama era Altjirraka angkatja wumalanga. ");
INSERT INTO are_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Era pula angkatja ekura parrpa kngwerrama. Lakinhanga era Altjirranha itja ekarlta tnakama. Erantama imampurlerramanga, relha arrpunhala paka erinha arrampowumanga Altjirraka angkatjanga arrkngala, era kala Altjirranha impumanta. ");
INSERT INTO are_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Annga nhanga lyaka mpopakarlaka tnyikala, nhanha kala relha nhanha ngerrala nama. Era Altjirraka angkatja wuma, era pula yulthiperralka, arrkaniperralka kngarra kuta eterramala Altjirraka angkatja parrpartilama. Altjirraka angkatjantama itja kuta anngakarta ngerrerrama. ");
INSERT INTO are_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Annga nhanga arna marrakarlaka tnyikala, nhanha kala relha nhanha ngerrala nama. Era Altjirraka angkatja wuma, ekura kuta antja nama turta. Erantama annga marra lhalhelama ngerra. Arrpunhala 100, arrpunhala 60, arrpunhala 30.” ");
INSERT INTO are_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesuala etnanha yia arrpunhantama alpmelaka. “Altjirranha relha ingkarrakaka Ingkarta namanga, kala lakinha ngerra nama. Artwala wheat annga alpantiwuka. ");
INSERT INTO are_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Anma era ankwentamangantama, urrkapunhapunha ekuranha ntjarra turta, leltja pitjika annga korna turta wheat-anga mpopaka alpantiwuka. Leltja erantama nyilknganyilknga kuta alpuka. ");
INSERT INTO are_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Kurunga wheat annga etna, annga korna etna turta tharrantema lyapumala, mangkaka. Anma etna porta anngakarterramanga, urrkapunhapunha ntjarrala araka tharrka korna wheat-anga mpopala mangkamanga. ");
INSERT INTO are_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Urrkapunhapunha etnantama itornka etnakanhurna lhamala, erinha pmarraka, ‘Unta kunha wheat annganta alpantiwuka, nhangai? Nthakinhantama tharrka korna turta mangkaka?’ ");
INSERT INTO are_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Era angkaka, ‘Leltjala kunha annga korna alpantiwuka.’ “Urrkapunhapunha etnantama erinha pmarraka, ‘Unta antja nama nurna tharrka korna etnanha urlpuntjitjika?’ ");
INSERT INTO are_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Era pula etnanha ilaka, ‘Impai! Tharrka korna etnanha urlpuntjimala, rrangkarra marna wheat marra erinha turta urlpuntjakitja. ");
INSERT INTO are_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Marralkura tharranhantema mangkitjika impai, kotjintjaka arltaka. Kurunga atha marna kotjinha ntjarranha turnitjina, etna tharrka korna ntjarrakimparra kotjimala worlilitjika, etitjika turta. Kurunga marna wheat etnanha kotjimala, etna marna etnanha marnaka iltha nukanhaka arrarnitjika.’” ");
INSERT INTO are_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesuala etnanha yia arrpunhantama alpmelaka. “Altjirranha relha ingkarrakaka Ingkarta namanga, kala lakinha ngerra nama. Artwala tjurrka annga tnukulpa ekuranhaka ingkairnama. ");
INSERT INTO are_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Annga era kala kurrka inthorra nama. Kanha irna tjurrka, erala annga kurrka ekuranga mangkama, era kngarritja inthorrala nama. Thepa etna turtantama pitjima, antjwa etnakanha turta etintjala mpaarama.” ");
INSERT INTO are_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesuala etnanha yia arrpunhantama alpmelaka. “Altjirranha relha ingkarrakaka Ingkarta namanga, lakinha ngerra nama. Arrkutjala marna ltorlpilanha kurrka wara marna kngarraka lhangama. Marna ltorlpilanha kurrka erantama marna urrknga kngarra erinha ltorlpilama, ntjapara kuta.” ");
INSERT INTO are_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesuanha relha ntjarrurna angkaka, etnanha yia alpmelamala. Yiakunya era etnakurna itja kuta angkaka. ");
INSERT INTO are_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Lakinha angkatja arrpunha Altjirranhala urrpia ekuranharlarlanga angkakala, nthurrperraka, “Yinga etnakurna yiarlarlanga angkitjina. Atha etnanha yiala alpmelitjina, angkatja nhanga athala itja relhanha arrkurla ilakala.” ");
INSERT INTO are_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesuaka kurtungurla ntjarrantama ekururna pitjimala erinha pmarraka, “Nurnaka nentilai yia nhanga tharrka korniperra, etnala marna wheat-anga mpopala mangkakala.” ");
INSERT INTO are_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesuala etnanha ilaka, “Relhaka 'Lira era artwa era ngerra nama, erala annga marra etnanha alpantiwukala. ");
INSERT INTO are_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Relha alharinya ingkarraka tnukulpa era ngerra nama, ekurakarlaka artwa era annga etnanha alpantiwukala. Relha lenha ntjarra, etnala Altjirraka kangkwerrama, etna marna marra ngerra nama. Kanha relha lenha ntjarra, etnala errintjaka kangkwerrama, etna tharrka korna ngerrala nama. ");
INSERT INTO are_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Errintja era, leltja era ngerra nama, erala annga korna alpantiwukala. Tjiperrawuntjaka arlta, era kotjintjaka arlta ngerra nama. Angel etna, marna kotjinha ntjarra ngerra nama. ");
INSERT INTO are_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Relhalala nhanga tharrka korna kotjimala urala etama, lakinha ngerra arlta ingkarnala nitjinantema. ");
INSERT INTO are_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Relhaka 'Lirala angel ekuranha ntjarranha yairnitjina relha korna ntelalhakala ntjarranha ilkngakitjika. Relha lenha ntjarranha turta, etnala relha arrpunha ntjarranha arrtjilhelakala errintjaka kangkwerritjika. ");
INSERT INTO are_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kurunga era angel etnanha turnitjina relha korna nhanha ntjarranha worlilamala ura urtaapa kngarritjaka iwutjika turta. Tanhala etna kngarra nthorrkngerritjina, itnitjina turta. ");
INSERT INTO are_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kurunga Altjirraka tjina ingkarraka arrkana tnoatnoantama nitjina, Altjirraka pmara kutathala. Ungkwanga ilpa paka intamanga, yinganha wurlathanai.” ");
INSERT INTO are_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Altjirranha relha ingkarrakaka Ingkarta namanga, kala lakinha ngerra nama. Artwala paka yultha tjiparra arltaramanga, relha arrpunhaka tnukulpala, era kala yultha tjiparra erinha wotha lauwuma. Kurunga alpumala era yultha ekuranha ingkarraka yirrinthama, tnukulpa arrpunha erinha buy-ilitjika.” ");
INSERT INTO are_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Altjirranha relha ingkarrakaka Ingkarta namanga, kala lakinha ngerra nama. Artwala parta tjiparra inthorraka yonthama. ");
INSERT INTO are_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Erantama parta tjiparra inthorra nyinta arltarama. Era kala yultha arrpunha ekuranha ingkarraka yirrinthama, parta tjiparra inthorra erinha buy-emilitjika.” ");
INSERT INTO are_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Altjirranha relha ingkarrakaka Ingkarta namanga, kala lakinha ngerra nama. Artwa irrpannga errkunherrkunha ntjarrala net etnakanha ntjangaka iwuma, irrpannga errkutjika. ");
INSERT INTO are_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Etnantama net erinha ankerrurna tjarrinama, irrpannga twetakatwetakarta. Kurunga irrpannga errkunherrkunha ntjarrala irrpannga etnanha ilkngakamantama. Marra ntjarranha etna tnyinama, kanha korna ntjarranha etna ipmintjala iwuma. ");
INSERT INTO are_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Lakinha ngerra arlta ingkarnala nitjinantema. Angel ntjarra pitjitjina relha korna ntjarranha, marra ntjarranga ilkngakitjika. ");
INSERT INTO are_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Etnantama relha korna ntjarranha worlilamala ura urtaapa kngarritjaka iwutjina. Tanhala etna kngarra nthorrkngerritjina, itnitjina turta.” ");
INSERT INTO are_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesualantama kurtungurla ekuranha ntjarranha pmarraka, “Rrangkarra paka yia nhanha ntjarra lhangkarakama?” Etna angkaka, “Awa, nurna lhangkarakakwia.” ");
INSERT INTO are_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kurunga era etnanha ilaka, “Relha nyintaminyinta, erala Altjirraka Angkatja Imankinyaka kaltja, era turtala kaltja Altjirranha relha ingkarrakaka Ingkarta namanga, era kala relha netaneta ngerra nama. Ekura yultha lyartinya, yultha ingkwia turta intama. Era turta nhanha relha arrpunhaka irrpalthala imarnama.” ");
INSERT INTO are_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Relha ntjarranha yia nhanha ingkarraka ilamaliperra, Jesuanha kala anparerraka. ");
INSERT INTO are_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Era pmara ekuranhurna alpuka. Erantama relha ntjarranha synagogue etnakanhala kaltjinthaka. Angkatja ekuranha wumala etna tnolkaka, pmarrarraka turta. “Nthakinhala artwa nhanha kaltja inthorrerraka? Ngunhala turtama erinha ekarltilaka tjatjikarta urrkaputjika? ");
INSERT INTO are_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Era kunha artwa rurlaka urrkapunhapunha nhangaka worra. Mia ekura Mary turta pmara nhanhala nama. Tjia ekuranha ntjarra James, Joseph, Simon, Judas turta nhanhala nurnakalela nama. ");
INSERT INTO are_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Arrumpa ekuranha ntjarra turta pmara nhanhala namantema, nurnakalela. Nthakinhantama era nurnanha marra inthorra kaltjinthama, tjatjikarta turta urrkapuma?” ");
INSERT INTO are_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Relha etnantama Jesuaka antjakunyerraka. Jesualantama etnanha ilaka, “Relha arrpunha ntjarralanta kunha kaltjinthanhinthanha kngarranha tnantjama. Kanha relha pmararinyala, tjina ekuranhala turta, erinha itja kutala tnantjama.” ");
INSERT INTO are_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Relha etna erinha itja ngerra tnakakalanga, Jesuala tjatjikarta urrputja wara pmara lenhala urrkapuka. ");
INSERT INTO are_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kurunga King Herod era turtantama yia wuka Jesuiperra. ");
INSERT INTO are_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Erantama urrkapunhapunha ekuranha ntjarranha ilaka, “Nhanha kunha John Kaltjirrpulhelanhelanha era nama. Erataka wotha etatherrakala. Lakinhanga era tjatjikarta ntjarrantama urrkapuma.” ");
INSERT INTO are_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","King Herod-alataka Herodias-anha, tjia ekuranha Philip-aka noa, noa inakala. John-alantama erinha tjatjatukala, “Nhanha itja arratja nama unta tjia ungkwanganhaka noa tnyinitjika.” Angkatja nhanhakakwiantama King Herod-ala tjapartia ekuranha ntjarranha turnaka John-anha errkutjika, erinha chain-ala yirnamala jail-aka turta kurnitjika. ");
INSERT INTO are_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod-anha kala antja naka John-anha errilknga tutjika, era pula relha ntjarranga trerraka, etna John-anha tnakamanga, era Altjirraka urrpia namanga. ");
INSERT INTO are_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Anma Herod-ala tjinkarrantama urrkapuka, alkngerrintjaka arlta ekuranhaka ilpangkitjika. Relha etna kala tjinkarraka worlerrakalangantama, Herodias-aka kwarra etnaka nthaperraka. Era turta King Herod-anha kngarra arrkanilaka. ");
INSERT INTO are_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herod erantama kwarra erinha ilaka, “Iwunhakama unta antja? Nuka kala enkai.” ");
INSERT INTO are_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mia ekuranhala erinha turnakalanga warta, kwarra era erinha ilaka, “Yinga antja nama unta yinganha John Kaltjirrpulhelanhelanhaka kapurta nthitjika, kapurta erinha taarnaka arrarnamala.” ");
INSERT INTO are_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nhanha wumala, Herod-anha porerraka. Era pula kwarra ekura kangkwerraka, era erinha relha itornka ntjarranga alkngatharra lhelakalanga. ");
INSERT INTO are_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Erantama tjapartia urrputja jail-urna yairnaka, John-aka kapurta inturnitjika. ");
INSERT INTO are_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Etnantama kapurta erinha taarnaka arrarnamala kngitjalpuka, nhanha kwarra erinha nthaka turta. Kwarra erantama nhanha mia ekuranha nthaka. ");
INSERT INTO are_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","John-aka kurtungurla ntjarrala nhanhiperra wumalanga, etna lhamala John-aka mpurrka inarlalpuka, tintjiwuka turta. Kurunga etna Jesuurna lhaka, erinha ilaka turta Herod-ala John-anha errilknga tukala. ");
INSERT INTO are_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yia nhanha wumala, Jesuanha boat-aka ntjimala kwatjanga tjananhaka, pmara worritjurna, nyintarinya nitjika. Relha ntjarrala pula wumalanga Jesuanha worritjurna lhakala, etna town etnakanhanga rratamala erinha ingkala lurnaka. Etnakimparra turta pmara worritja ekura erritjalhaka. ");
INSERT INTO are_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesuanhantama boat-anga tnanpumalanga, worla kngarra etna kala ekura kaaralhaka. Etnanha aramala, era etnaka konyerraka, era turta menta ntjarranha marrilaka. ");
INSERT INTO are_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kala ngurrangurrerrakalangantama, kurtungurla ekuranha ntjarra Jesuurna pitjimala erinha ilaka, “Arai, pmara nhanhataka worritja ngerra nama, relhakunya. Lakinhanga unta relha ntjarranha kala yairnarlenai, etna town kurrka ntjarrurna lhitjika, marna initjika.” ");
INSERT INTO are_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesuala pula etnanha pmarraka, “Iwunhangala atha etnanha yairnarlenitjika? Kala rrangkarra etnanha marna ilkutjika ntharrirrai.” ");
INSERT INTO are_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Etna pula angkaka, “Nurnaka pula itja intama, marna kurrka 5-anta wara, irrpannga tharra turta.” ");
INSERT INTO are_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesuala etnanha ilaka, “Kala marna pa kara irrpannga etnanha nukurna kngitjai.” ");
INSERT INTO are_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kurunga era relha etnanha turnaka etna tharrkaka arrarnalhitjika. Erantama marna 5 etnanha, irrpannga tharra turta inaka. Alkirurnathaka inaramala, era Altjirranha dangkilaka. Kurunga era marna etnanha urltakaka. Erantama ungkwaltja etnanha kurtungurla ntjarranha nthetnaka relha ntjarraka errarnpalhelitjika. ");
INSERT INTO are_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kala relha ingkarraka inthorrala ilkuka. Itja nyinta paka ngaiyala naka. Ingkarna etna 12 basket-ntama lyulpalyulpilaka marna ungkwaltja etnanha kotjimala. ");
INSERT INTO are_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Arlta lenhala artwa 5,000-ala marna ilkuka. Arrkutja ntjarrala, katjia ntjarrala turta ilkukantema. ");
INSERT INTO are_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesualantama kurtungurla ekuranha ntjarranha turnaka etnakimparra boat-aka ntjitjika, ntjanganga tjananhitjika turta. Era pula kuterraka relha etnanha pmarurnarrka yairnitjika. ");
INSERT INTO are_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Relha etnanha yairnamaliperra, era partaka ntjika, Altjirrurna ingkitjika. Kala ngurrangurrerrakalangantama, Jesuanha nyintarinya naka partala. ");
INSERT INTO are_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kanha boat nhanga ntjanga mpopala ngerrala naka. Kurtungurla etna turta nakapakarlerraka, wurinya ekarltala etnanha twentjimanga. ");
INSERT INTO are_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kala ingutnhalantama, itjantema parrtjerrakalanga pula, Jesuanha etnakurna pitjika kwatja kartninyala ingka lhamala. ");
INSERT INTO are_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kurtungurla ntjarrala erinha aramalanga kwatja kartninyala urlarrathaka ingka pitjimanga, etna enkakunyerraka. Yarna thakerramala etna ilkaka, “Lthananga palai!” ");
INSERT INTO are_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesuanha parrpa etnakurna angkaka, “Yingiai! Palkala trerritjala!” ");
INSERT INTO are_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peter-alantama erinha pmarraka, “Ingkartai, untama lanha? Nthurrpanga paka, yinganha ntangkai ungkwangurna pitjitjika, kwatja kartninyala ingka lhamala.” ");
INSERT INTO are_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesuala erinha ntangkaka, “Pitjai!” Boat-anga tnanpumala, Peter-anhantama Jesuurna ingka lhaka, kwatja kartninyala. ");
INSERT INTO are_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wurinya ekarlta ekuriperrantama eterramala, era trerrakarrpa. Kurunga era uralhitjikerraka. Ingka ekuranha warta kwatjaka irrpuka, kanha era ilkarlalhaka, “Ingkartai, yinganha tangkalhelai.” ");
INSERT INTO are_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesuala erinha parrpa iltjanga errkuka. “Iwunhangala unta yinganha itja tnakaka?” era erinha pmarraka. “Untataka ilpoiwukarrpa.” ");
INSERT INTO are_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kurunga eratharra tharrantema boat-aka ntjika. Wurinya era turtantama yirraka. ");
INSERT INTO are_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kurtungurla etnantama Jesuaka urrkurrkintja naka, erinha ilaka turta, “Nthurrpathoa unta Altjirraka 'Lira nama.” ");
INSERT INTO are_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ntjanga ekuranga tjananhamalantama, Jesuanha, kurtungurla ekuranha ntjarra turta pmara Gennesaret-aka erritjalhaka. ");
INSERT INTO are_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pmararinya ntjarrala Jesuanha aramala, etna angkatja yairnaka relha arrpunha ntjarrurna, etnala pmara etnakanhanga etinya namanga. Etnantama relha menta ntjarranha Jesuurna kngitjika. ");
INSERT INTO are_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Menta etnantama Jesuurna ingkaka, “Nurnanha impurlarrarnai, kala mantarra ungkwanganhanta paka anputjika.” Menta etnala mantarra ekuranha anpuka, etna kala marrerraka. ");
INSERT INTO are_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kurunga artwa Pharisee urrputja, artwa Intarrangaltha urrputja turta Jesuurna pitjika, Jerusalem-anga. ");
INSERT INTO are_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Etna Jesuanha pmarraka, “Iwunhangala kurtungurla ungkwanganha ntjarra itja kngarripata ntjarraka mpaarangarangaka kangkwerrama? Etna kunha itja iltja ilkngilhama, marna ilkutjinala.” ");
INSERT INTO are_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesuala pula etnanha ilaka, “Iwunhangala rrangkarra itja Altjirraka turnintjaka kangkwerrama? Rrangkarra kunha mpaarangaranga rrakangkarranhaka kangkwerramala Altjirraka turnintja ipmintja impuma. ");
INSERT INTO are_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Arai, Altjirrala nhanga turnaka, ‘Unta kaarta pa mia ungkwanganhaka kangkwerritjika’. Nhanha turta, ‘Relha erala kaarta ekuranha, mia ekuranha paka arrampowumanga, erinha rrangkarra errilknga tutjika.’ ");
INSERT INTO are_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kanha rrangkarra relha ntjarranha lakinhala ilama. Relha paka kaarta pa mia ekuranhurna angkamanga, ‘Arai, marna, yulthalka nhanhataka atha Altjirranha lhelakala.’ Kurunga rrangkarra erinha ilama, ekurathaka itja wotha nama kaarta ekuranha nthitjika. ");
INSERT INTO are_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Lakinha rrangkarra Altjirraka turnintja ipmintja impuma, mpaarangaranga rrakangkarranhaka kangkwerritjinala. ");
INSERT INTO are_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pmatha ntjarrai, rrakangkarriperra inthorrataka Altjirranha nhanga Isaiah-arlarlanga angkaka, ");
INSERT INTO are_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Relha nhanha ntjarrala yinganha tnantjama angkatja etnakanhala, etna pula nuka itja arratja eterrama. ");
INSERT INTO are_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Etna nuka palkala urrkurrkintja nama. Etna kunha relha ntjarranha, relhaka mpaarangaranganta kaltjinthama, itja turnintja nukanha.” ");
INSERT INTO are_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesualantama relha ntjarranha worlilamala ilaka, “Nhanha wai, nhanhaka kaltja nai turta. ");
INSERT INTO are_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Marna, karalka nhanhala relhala rrakartala ilkuma, nhanhala itja relhanha Altjirranga urlarra kornilama. Angkatja korna etnala relhaka rrakartanga rratama, etna pula relhanha Altjirranga urlarra kornilamala.” ");
INSERT INTO are_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kurtungurla ekuranha ntjarrantama Jesuurna pitjimala erinha pmarraka, “Unta kaltja? Artwa Pharisee ntjarra kunha angkatja ungkwanganhanga mukanherraka.” ");
INSERT INTO are_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesuanha pula angkaka, “Arai, irna ingkarraka Kaarta nukanhalala itja ingkairnakala, etnanha era takarrakarta kuta urlpuntjitjina. ");
INSERT INTO are_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kala artwa Pharisee ntjarranga tjanantalhai. Etnataka relha panga ngerra nama. Arai, relha pangala paka relha panga arrpunhanha rretjingama, eratharra, tharrantema kala ipartaka tnyitjina.” ");
INSERT INTO are_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter-alantama Jesuanha pmarraka, “Nurnaka nentilai angkatja untala lyarta relha ntjarranha ilakala.” ");
INSERT INTO are_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Erantama etnanha ilaka, “Yai, rrangkarra turtama marntilparla? ");
INSERT INTO are_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Rrangkarra itjala kaltja? Marnalka nhanga relhalala rrakartaka kurnama, nhanha kunha tnarturna irrpunhama, mpurrkanga turta wotha rratanhama. ");
INSERT INTO are_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kanha angkatja etnala rrakartanga rratama, etnataka relhaka eterrintjangala pitjima. Etnantama relhanha Altjirranga urlarra kornilama. ");
INSERT INTO are_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Arai, relha kunha paala eterrama. Paala eterramalantama era errilknga tuma, relha arrpunhaka noalela intama, ntaiyawuma, nyilkngala inama, orrtjerrama, Altjirranha arrampowuma turta. ");
INSERT INTO are_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nhanhala kunha relhanha Altjirranga urlarra kornilama. Relhala pula marna ilkumanga, itja iltja ilkngilhakala, nhanhala erinha itjala Altjirranga urlarra kornilama.” ");
INSERT INTO are_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pmara lenhanga Jesuanha pmara Tyre Sidon tharranga kuturnantama lhaka. ");
INSERT INTO are_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Arrkutja nyinta pmara lenharinya, arrkutja Canaan-arinya purrama, erantama ekururna pitjika. Era Jesuurna ingkaka, intarra angkamala, “Ingkartai, David-aka 'Lirai, nuka montjamontja ntelalhai. Kwarra nukataka enka kornakarta kngarra mpangkama.” ");
INSERT INTO are_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesuanha pula ekururna itja kuta angkaka. Jesuaka kurtungurla ntjarralantama Jesuanha ilaka, “Arrkutja erinha kala yairnarlenantai! Erataka nurnanha itnimala lurnarlapuma.” ");
INSERT INTO are_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesuanha pula angkaka, “Altjirrala yinganha yairnaka, relha Israel-arinya pairlperrakala ntjarrurnanta.” ");
INSERT INTO are_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Arrkutja era pula etinyerramala Jesuanga urlarra mparalela arrarnalhaka. Era wotha ekururna ingkaka, “Ingkartai, nuka montjamontja ntelalhai.” ");
INSERT INTO are_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesuala pula erinha ilaka, “Nhanha itja arratja namara katjiaka marna kngulya ntjarranha nthitjika.” ");
INSERT INTO are_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Arrkutja era pula Jesuanha ilaka, “Ingkartai, unta kala arratja angkama. Kngulya etna pula ungkwaltja etnanha ilkumala, ungkwaltja nhanga katjialala ipmintja iwuma.” ");
INSERT INTO are_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesuala erinha ilaka, “Arrkutjai, unta kunha yinganha ekarlta kuta tnakaka. Unta nukurna ingkaka atha kwarra ungkwanganha marrilitjika. Arai, era kala marrerraka.” Kwarra ekurantama marrerraka Jesuanha angkamalangantema. ");
INSERT INTO are_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesuala pmara lenha impurlalhakantama. Era Galilee ntjangurnantama pitjika, anpara kuta pula lhaka. Erantama partaka ntjinhamala, arrarnalhaka. ");
INSERT INTO are_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Relha ntjarra inthorrantama ekururna worlerrentjalpuka. Etna turta relha menta ntjarranha ekururna kngitjika, nhanga relha inurra, panga, angkatjakunyalka. Etnantama relha nhanha etnanha Jesuanga urlarra arrarnaka. Jesualantama etnanha ingkarraka inthorra marrilaka. ");
INSERT INTO are_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Relha rrakarta marnta ntjarrantama angkaka, relha inurra ntjarrantama nthulapuka, relha panga ntjarrala turtantama wotha araka. Nhanha aramala, relha etna tnolkaka. Etna Israel-aka Altjirranha tnantjaka turta. ");
INSERT INTO are_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesuanha kurtungurla ekuranha ntjarrakantama ntangkalhaka. Era etnanha ilaka, “Arai, yingataka relha nhanha ntjarraka konyerrama. Etna kala arlta tharraminyintantama nukalela nakala, marnakunya. Yingantama itja antja nama etnanha ngaiyala pmarurna yairnarlalputjika, etna tjaiyala nakapakarlerrakitja.” ");
INSERT INTO are_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kurtungurla ekuranha ntjarrala pula erinha ilaka, “Nthanhangantama nurna worla kngarra lakinhaka marna inamara? Nurna kunha nhanha worritjala nama.” ");
INSERT INTO are_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesualantama etnanha pmarraka, “Marna nthakintjama rrakangkarra intama?” Etna angkaka, “Kala marna kurrka 7, irrpannga urrputja turta.” ");
INSERT INTO are_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesualantama relha worla etnanha turnaka arnaka arrarnalhitjika. ");
INSERT INTO are_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kurunga era marna 7 etnanha, irrpannga etnanha turta inamala Altjirranha dangkilaka. Kurunga marna etnanha urltakamala, era ungkwaltja etnanha kurtungurla ntjarranha nthaka, worla etnaka errarnpalhelitjika. ");
INSERT INTO are_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Relha ingkarrakalantama marna pa irrpannga ilkuka, nhalkerraka turta. Ingkarna etna 7 basket lyulpalyulpilaka, marna ipmintjerrakala kotjimala. ");
INSERT INTO are_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Relha etnala marna ilkukala, etna artwa 4,000 naka. Arrkutja ntjarrala, katjia ntjarrala turta marna ilkukantema. ");
INSERT INTO are_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Relha worla etnanha pmarurna yairnamala, Jesuanha boat-aka ntjika. Ntjanga ekuranga tjananhamala, era kala pmara Magadan-aka erritjalhaka. ");
INSERT INTO are_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Artwa Pharisee ntjarra, artwa Sadducee ntjarra turtantama Jesuurna pitjika. Etna erinha arrkarnamala ilaka, “Tjatjikarta alkirarinya nurnanha ntelai.” ");
INSERT INTO are_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Era pula etnanha ilaka, “Ngurrangurra, rrangkarra paka aramanga alkira era thathamanga, rrangkarra angkama, ‘Inguntha kwatjala itja nhitjina.’ ");
INSERT INTO are_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ingutnhala, rrangkarra paka aramanga alkira era thathamanga, matara turta intamanga, rrangkarra angkama, ‘Lyarta kwatjala nhitjina.’ Alkira erinha aramala rrangkarra kala lhangkarama kwatjala nhitjinala, itja paka. Arai, atha kala tjatjikarta ntjarra rrakangkarra urrkapuka. Rrangkarra pula etnanha itjala lhangkaraka. ");
INSERT INTO are_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Rrangkarrataka relha korna nama, Altjirranha ilpoiwunha turta. Lakinhanga rrangkarra antja nama atha rrakangkarra tjatjikarta arrpunha ntelitjika. Atha pula rrangkarranha tjatjikarta nhanganta ntelitjina, Altjirralala Jonah-anha ntelakala. Itja arrpunha.” Etnanha impurlalhamala, Jesuanha kala lhakantama. ");
INSERT INTO are_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesuanha, kurtungurla ekuranha ntjarra turta ntjanga ekuranga tjananhakantama, boat-ala. Etna pula marnaka kngwerrakarrpa. ");
INSERT INTO are_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesualantama etnanha ilaka, “Rrangkarra artwa Pharisee ntjarraka, artwa Sadducee ntjarraka marna ltorlpilanhanga aralhitjika.” ");
INSERT INTO are_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kurtungurla ntjarrantama nhanhiperra angkarraka, lakinha ilarramala, “Erataka nurnanha lakinha ilaka, nurna marna arrpunhaka kngwerrakalanga.” ");
INSERT INTO are_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesuanha kala kaltja naka angkatja etnala angkarramalaka. Erantama etnanha pmarraka, “Iwunhangala rrangkarra marniperra angkarrama? Rrangkarra yinganha itjantema tnakama? ");
INSERT INTO are_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Rrangkarra marntilparla kutakwia? Rrangkarra kala kngwerraka atha artwa 5,000 ntuthilakala marna 5-ala, rrangkarra turtantama ungkwaltja kngarra inthorra kotjikala. ");
INSERT INTO are_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Rrangkarra turta kala kngwerraka atha nhanga artwa 4,000 ntuthilakala marna 7-ala, rrangkarra turtantama ungkwaltja kngarra inthorra kotjikala? ");
INSERT INTO are_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Atha rrangkarranha nhanga ilaka, rrangkarra artwa Pharisee ntjarraka, artwa Sadducee ntjarraka marna ltorlpilanhanga aralhitjika. Rrangkarrataka lhangkareikanha yinga itja rrakangkarrurna marniperra angkamanga.” ");
INSERT INTO are_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kurtungurla ntjarrala lhangkarakantama era itja marna ltorlpilanhiperra angkamanga. Era pula angkatja ekuriperra angkamanga, angkatja nhanga artwa Pharisee ntjarrala, artwa Sadducee ntjarra turtala, relha ntjarranha kaltjinthamanga. ");
INSERT INTO are_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Anpara lhamala, Jesuanha Caesarea Philippi town-urna pitjika. Town ekuralantama Jesuala kurtungurla ekuranha ntjarranha pmarraka, “Nthakinhama relha ntjarra Relhaka 'Liriperra angkama?” ");
INSERT INTO are_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Etna erinha alpmelaka, “Arrpunha ntjarra angkama unta kula John Kaltjirrpulhelanhelanha era namanga. Arrpunha ntjarra unta Elijah-anha namanga. Arrpunha ntjarra unta Jeremiah-anha namanga. Kala arrpunha ntjarra angkama unta kula urrpia arrpunha namanga.” ");
INSERT INTO are_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesuala etnanha wotha pmarraka, “Kanha rrangkarraloa? Rrangkarra nukiperra nthakinhala angkama? Ngunhama yinga?” ");
INSERT INTO are_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter-ala erinha alpmelaka, “Unta nama Krista era, Altjirra kngaanintjaka 'Lira.” ");
INSERT INTO are_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesuala erinha ilaka, “Simon, Jonah-aka 'lirai, unta nhanhaka kaltja namanga, unta kuta arrkana nitjina. Relhala nganha itja nhanha kaltjinthaka, Kaarta Alkirarinya nukanhala pula. ");
INSERT INTO are_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Atha nganha nhanha turta ilama, unta kunha nama rretnya Peter, nhanhatitja parta theinta. Parta theinta nhanhakarlaka atha worlamparinya nukanha parnitjina ngerra. Errintja era turtantama worlamparinya nukanha yarna yirralhelitjina. ");
INSERT INTO are_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Atha nganha ekarltilama relhaka korna iwutjika. Relha ekurala unta korna iwuma, Altjirrala kala korna ekuranha iwutjinantema. Kanha relha ekurala unta korna itja iwuma, Altjirrala korna ekuranha itjantema iwutjina.” ");
INSERT INTO are_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesualantama kurtungurla ekuranha ntjarranha ilaka, etna itja inthorra relha ntjarranha ilitjika era Krista era namanga. ");
INSERT INTO are_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nhanha ekuriperra Jesuala kurtungurla ekuranha ntjarranha kaltjinthaka nhanha ekurathaka namanga nyingalauwutjika. Era etnanha kaltjinthaka ekurathaka namanga Jerusalem-urna lhitjika. Era etnanha kaltjinthaka kngarripata ntjarra, priest itornka ntjarra, artwa Intarrangaltha ntjarra turta ekura antjakunyerritjinala, etna erinha errilknga tutjinala turta. Era etnanha kaltjinthaka turta, era arlta tharraminyinta errilknga intamaliperra, Altjirrala erinha wotha etatha kamalhelitjinala. ");
INSERT INTO are_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jesuanha etapurna kngamala, Peter-ala erinha rralthaka, “Itja lakinha Ingkartai. Altjirrala etnanha parreikanha.” ");
INSERT INTO are_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesuala pula Peter-anha ilaka, “Nukanga lhai, Satan-ai! Nukathaka nama Altjirraka kangkwerritjika. Unta pula yinganha parritjikala antja nama. Unta itja Altjirra ngerra eterrama, relha ngerra pula.” ");
INSERT INTO are_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kurunga Jesuala kurtungurla ekuranha ntjarranha ilaka, “Thunga relha antja nama nukanga tnaartangala pitjitjika. Nthakinhantama era ntelalhitjika? Era itja wotha eterrintja ekuranhaka kangkwerritjika. Era pula ntolka ekuranha parlapaka tjurnamala kngitjika, athala ntolka nukanha kngamanga ngerra. Kurunga era nukanga tnaartangala pitjitjika. ");
INSERT INTO are_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Arai, relha erala etatha nitjikanta thakerrama, era kala ilutjina. Kanha relha erala relha arrpunha ntjarranha impurlarrarnama erinha errilknga tutjika, nukanga arrkngala, era kala ngampakalala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Thunga relha Altjirraka itja eterrama. Erantama alha nhanhaka yultha ingkarraka inthorra patilama. Arai, era itja ngampakala etatha nitjina. Relha era turta yarna Altjirranha money nthama, Altjirrala erinha pmara ekuranhurna irrpulhelitjika, era pmara ekuranhalantama ngampakala nitjinanga. ");
INSERT INTO are_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Arai, Relhaka 'Lira pitjalputjina, makalaria inthorra ntelalhamala, Kaarta ekura ngerra. Era turta Kaarta ekuranhaka angel ntjarrakarta pitjitjina. Kurunga era nyintaminyintanha kwartiwutjina, erala ntelalhakala ngerra. ");
INSERT INTO are_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Atha rrangkarranha nhanha turta nthurrpa ilama. Relha arrpunha ntjarra, etnala lyarta nhanhala nama, etna katha aritjina Relhaka 'Lira pitjalpumanga, ntelalhamanga turta, era relha ingkarraka Ingkarta namanga.” ");
INSERT INTO are_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Etna kala arlta 6 nakalangantama, Jesuala Peter-anha, James-anha, tjia ekuranha John-anha turta ntangkaka. Erantama etnakakarta parta kartninyaka ntjika. ");
INSERT INTO are_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Altjirralantama Jesuanha etnakanga alkngatharra kngartiwuka. Jesuaka anngerrantama lirnnga ngerra parrtjika, mantarra ekuranha turta kwatja lharrkintja ngerra tjulkuka. ");
INSERT INTO are_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moses Elijah tharrantama rumerraka, Jesualela angkarraka turta. ");
INSERT INTO are_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter-alantama Jesuanha ilaka, “Ingkartai, nurnataka kangkama pmara nhanhala nitjika. Unta paka antja namanga, atha kala lyuntja tharraminyinta ititjina, ungkwanga nyinta, Moses-aka nyinta, Elijah-aka nyinta.” ");
INSERT INTO are_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kurunga era angkamangantema, matara parrtja kngarrakarta pitjika, etnanha korltaka turta. Matara ekurangantama etna Altjirranha angkamanga wuka, “Nhanha kunha 'Lira nuka inthorra era. Yinga ekura kngarra kangkama. Rrangkarra ekura kangkwerritjika.” ");
INSERT INTO are_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Altjirranha angkamalanga wumala, kurtungurla etna enkakunya inthorrerraka. Etnantama arnakarlaka iwulhamala, urlparra intaka, anngerra kwanakarla kuta. ");
INSERT INTO are_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesuanha pula etnakurna pitjika. Era etnanha anpuka, angkamala, “Kamerrai! Itja trerritjika!” ");
INSERT INTO are_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Anngerra kartninyerramala, etna Jesua erinhantantama araka, itnamanga. ");
INSERT INTO are_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Etna partanga tnanpentjimanga, Jesuala etnanha turnaka, “Rrangkarra itja inthorra relha arrpunhaka alpmelitjika, rrangkarrala arakala. Anma, Relhaka 'Lira errilknga ntjarranga kamerrakalanganta, rrangkarra yia nhanha relha arrpunha ntjarranha ilitjika.” ");
INSERT INTO are_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kurtungurla ntjarralantama Jesuanha pmarraka, “Iwunhangama artwa Intarrangaltha ntjarrala ilama Elijah-anhakimparra pitjitjika, kurunganta Kristanha?” ");
INSERT INTO are_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesuala etnanha ilaka, “Nthurrpa Altjirraka Angkatja Imankinyala ilaka Elijah-anharrka pitjitjika, relha ingkarrakanha arratjilitjika. ");
INSERT INTO are_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Atha pula rrangkarranha ilama, Elijah-anhataka kala pitjika. Relha ntjarrala pula erinha itja lhangkaraka. Etna ekura irrpaltherraka. Lakinha ngerra etna Relhaka 'Lira ekura turta irrpaltherritjinantema.” ");
INSERT INTO are_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kurtungurla ntjarralantama lhangkaraka era John Kaltjirrpulhelanhelanhiperra angkamanga. ");
INSERT INTO are_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesuanha, kurtungurla urrputja nhanga turta worlurna pitjalpukantama. Artwa nyintantama Jesuurna etinyerramala ekuranga urlarra mparalela arrarnalhaka. ");
INSERT INTO are_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Era angkaka, “Ingkartai, worra nukanhaka konyerrai. Erataka menta nama, iwurlpiwulhama turta. Arrpunharanga era ururna tnyinhaka, arrpunharanga kwatjurna. ");
INSERT INTO are_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Athantama erinha kurtungurla ungkwanganha ntjarrurna kngitjika, etna erinha marrilitjika. Etna pula erinha yarna marrilaka.” ");
INSERT INTO are_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesuala etnanha ilaka, “Rrangkarrataka relha arrthata nama. Rrangkarra turta Altjirranha itja tnakama. Kuta inthorrama yinga rrakangkarralela nitjika, rrangkarranha kaltjinthitjika turta? Rrangkarrataka yinganha porrkaporrkilama.” ");
INSERT INTO are_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesualantama enka korna erinha unpurlenaka. Enka korna era turta worra ekuranga rrataka. Worra era turtantama kala marrerraka. ");
INSERT INTO are_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kala etnarrpantama namalanga, kurtungurla ntjarrala Jesuanha pmarraka, “Iwunhangama nurna enka korna erinha yarna unpurlenaka?” ");
INSERT INTO are_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jesuala etnanha ilaka, “Rrangkarra Altjirranha tnakitjikanhanga warta. Arai, atha rrangkarranha nhanha nthurrpa ilama. Rrangkarra Altjirranha kurrka waranta paka tnakamanga, rrangkarra parta kngarritja tanha irrpalthala naamalhelamara. Rrangkarra turta tjatjikarta arrpunha urrkapumara.” ");
INSERT INTO are_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesuanha, kurtungurla ekuranha ntjarra turta Galilee-ala worlerraka. Erantama etnanha ilaka, “Arai, etnataka Relhaka 'Lira erinha leltjaka lanthitjina. ");
INSERT INTO are_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Etnantama erinha errilknga tutjina. Arlta tharraminyintiperra pula Altjirrala erinha wotha kamalhelitjina.” Angkatja nhanha wumala kurtungurla etna ltarrpa inthorrerraka. ");
INSERT INTO are_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesuanha, kurtungurla ekuranha ntjarra turtantama Capernaum-urna pitjika. Artwa etnala temple-aka tax money kotjitjata, etnantama Peter-urna pitjimala erinha pmarraka, “Kaltjinthanhinthanha rrakangkarranhala temple-aka tax money nthamama?” ");
INSERT INTO are_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Awa, era nthamakwia,” Peter-ala etnanha ilaka. Etna kala iltha kwanalantama namalanga, Jesuala Peter-anha pmarraka, “Simon-ai, nthakinhama unta etarlarama? Relha ngunha ntjarrangama alhaka king-ala tax money kotjima? Tjina etnakanhanga paka? Relha epinya ntjarranga paka?” ");
INSERT INTO are_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Relha epinya ntjarrangakwia,” Peter-ala erinha alpmelaka. “Lakinhanga,” Jesuala erinha ilaka, “Nurnakathaka itja nama temple-aka tax money nthitjika, nurna Altjirraka katjia namanga warta. ");
INSERT INTO are_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nurna pula itja antja nama etnanha palkala rrangkalhelitjika. Lakinhanga unta kwatja ntjangurna lhai, irrpannga errkutjika. Irrpannga errkumala, rrakarta ekuranha altjurilai. Rrakarta kwanala unta money intamanga aritjina. Money erinha inamala, kala temple tax nukanha, ungkwanganha turta tax money kotjinha ntjarranha nthai.” ");
INSERT INTO are_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kurtungurla etnantama Jesuurna pitjimala erinha pmarraka, “Altjirranha relha ingkarrakaka ntelalhamanga era Ingkarta namanga, nurnakanga ngunhama itornka kngarra nitjina?” ");
INSERT INTO are_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesuala katjia kurrka nyintanha ntangkaka ekururna pitjitjika. Erantama katjia erinha etnakanga mpopaka ingkairnaka. ");
INSERT INTO are_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Era etnanha ilaka, “Atha rrangkarranha nthurrpa ilama, rrangkarrataka paala kutarrpa eterrama. Rrangkarra kala katjia nhanha ngerranta eterritjika. Itjanga, rrangkarra itja kuta Altjirraka pmara kutathurna irrputjina. ");
INSERT INTO are_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Relha eranta, erala katjia nhanha ngerra itja tjurnalhama, era itornka rrakangkarra nitjina Altjirranha relha ingkarrakaka ntelalhamanga era Ingkarta namanga. ");
INSERT INTO are_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Relha erala katjiaka kangkintja ntelalhama, yinganha etarlaramala, era nuka kangkintja ntelalhama.” ");
INSERT INTO are_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Arai, relha erala tnakanhakanha nyintanha arrtjilhelamanga korna ntelalhitjika, erinha Altjirrala nakapakarlilitjina. Ekura kala marralkura namara, arrpunhala paka tnyana kngarritja turrkura ekuranhaka ilparanakalanga, erinha kwatja iparta inthorraka iwukalanga turta. ");
INSERT INTO are_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Apu, relha korna ntjarrai. Relha kornala kunha relha arrpunhanha arrtjilhelitjina. Nhanha kala lakinha nitjina. Relha korna ekura pula imampurla inthorra nitjina, era relha arrpunhanha arrtjilhelakalanga korna ntelalhitjika. ");
INSERT INTO are_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Thunga iltja ungkwanganhala, ingka ungkwanganhala paka nganha arrtjilhelama, korna ntelalhitjika. Iltja ungkwanganha, ingka ungkwanganha paka inturnamala iwai. Nhanha marralkura nama unta Altjirraka pmarurna irrputjika iltja nyintakarta, ingka nyintakarta paka, nhanhangatjina, Altjirrala nganha ura ngampakalurna iwutjika iltja tharrakarta, ingka tharrakarta paka. ");
INSERT INTO are_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Thunga alknga ungkwanganhala nganha arrtjilhelama, korna ntelalhitjika. Alknga erinha urlpuntjimala iwai. Nhanha marralkura nama unta alknga nyintakarta Altjirraka pmarurna irrputjika, nhanhangatjina, Altjirrala nganha ura ngampakalurna iwutjika, alknga tharrakarta.” ");
INSERT INTO are_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Rrangkarra itja tnakanhakanha nyintanha lolowutjika. Arai, angel etnakanha Kaarta nukanhalela nama, alkirala. ");
INSERT INTO are_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Arai, thunga artwa nyintaka 100 sheep nama. Sheep nyinta turtantama paala lhamala pairlperrama. Artwa era kunha 99 sheep arrpunha etnanha partaka impurlalhamala, sheep nyinta ekura yonthitjika lhama. ");
INSERT INTO are_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Era paka sheep erinha arltaramanga, era kala arrkanalkura nama sheep nyinta ekuriperra, 99 arrpunhangatjina, etnala itja paala lhamala pairlperrakala. ");
INSERT INTO are_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lakinha ngerra Kaarta Alkirarinya era turta ntelalhama. Era itja antja nama tnakanhakanha nyinta paka imerritjika.” ");
INSERT INTO are_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Thunga tjina tnakanhakanha ungkwanganha ungkwanga korna ntelalhama. Ekuralela angkarritjika lhai. Era paka ungkwanga kangkwerramanga, kala marra. ");
INSERT INTO are_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Itjanga paka, relha nyinta arrpunhakarta lhai, tharra arrpunhakarta paka, ekuralela angkarritjika. Relha tharrala, urrputjala paka angkatja ungkwanganha wutjika, angkatja erinha ingkarna yarna ilpoiwutjinanga. ");
INSERT INTO are_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tjina tnakanhakanha era itja kuta kangkwerramanga, nhanha kala worlamparinyakantantama ilai. Era paka worlamparinyaka turta itja kangkwerramanga, era kala ungkwanganga urlarra Relha Lorinya ngerra nitjika, relha tax money kotjinha ngerra turta. ");
INSERT INTO are_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Arai, atha rrangkarranha nhanha nthurrpa ilama. Rrangkarra paka alha nhanhala relhaka korna itja iwumanga, Altjirrala korna ekuranha itjantema iwutjina. Rrangkarra pula alha nhanhala relhaka korna iwumanga, Altjirrala relha ekuranha korna iwutjinantema. ");
INSERT INTO are_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nhanha turta atha rrangkarranha ilama. Rrakangkarranga tharrala paka Kaarta alkirarinyurna nyintaka ingkamanga, era kala rrakangkarra kangkwerritjina. ");
INSERT INTO are_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Arai, relha tharrala, tharraminyintala palka yinganha rretnyala ntangkamala worlerramanga, yinga kala etuakanga mpopala nama. ");
INSERT INTO are_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jesuurna etinyerramala, Peter-ala erinha pmarraka, “Ingkartai, thunga tjina tnakanhakanha nuka wothamawotha korna ntelalhama. Nthakintjarangama atha korna ekuranha iwutjika? 7-aranga paka?” ");
INSERT INTO are_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesuala erinha ilaka, “Peter-ai, atha nganha ilama, itja 7-aranga, 77-aranga pula, nhanhatitja kutatha. ");
INSERT INTO are_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Arai, Altjirranha relha ingkarrakaka Ingkarta namanga, kala lakinha ngerra nama. King nyinta naka, erala antja naka urrkapunhapunha ekuranha ntjarraka booking arratjilitjika. ");
INSERT INTO are_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Erantama booking etnaka arratjilitjikerramanga, etna urrkapunhapunha nyinta ekururna kngitjika, erala $10,000,000 ngerra ekuranga nyilkngala inakala. ");
INSERT INTO are_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Urrkapunhapunha ekura turta money itja intaka nyilkngiperra erinha urrparitjika paka. Lakinhanga king-ala turnaka etna erinha, noa ekuranha, katjia ekuranha, yultha ingkarraka ekuranha turta yirrinthitjika, nyilkngiperra erinha urrparitjika. ");
INSERT INTO are_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Urrkapunhapunha erantama mparalela arrarnalhaka. Erantama anngerra kwaninyerramala ingkaka, ‘Ingkartai, nuka montjamontja ntelalhai. Atha nganha kala anma money ingkarraka nthitjalputjina.’ ");
INSERT INTO are_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","King erantama ekura konyerraka. Nyilkngiperra ingkarraka ekuranha urrparamala, era erinha kala yairnarlenaka turta. ");
INSERT INTO are_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“King-aka ilthanga rratanhamala, artwa urrkapunhapunha era artwa urrkapunhapunha nyinta arrpunha araka. Era erinha $10 ngerra lhelakala. Erantama erinha antja errkuka angkamala, ‘Lhelintja nhanga kala nthitjalpantai.’ ");
INSERT INTO are_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Urrkapunhapunha arrpunha erantama mparalela arrarnalhamala ingkaka, ‘Nuka montjamontja ntelalhai. Atha nganha kala anma money ingkarraka nthitjalputjina.’ ");
INSERT INTO are_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Era pula unpaarta kuta itnaka. Kurunga era ekurakarta jail-urna lhaka, era turta erinha jail-aka kurnaka, era lhelintja ekuranha nthitjalputjinalpula. ");
INSERT INTO are_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“King-aka urrkapunhapunha arrpunha ntjarrala nhanha aramala, etna ltarrpa kngarrerraka. King-urna lhamala etna erinha yia ingkarraka alpmelaka. ");
INSERT INTO are_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Erantama artwa urrkapunhapunha nhangaka ntangkalhaka. Era erinha ilaka, ‘Untataka artwa korna inthorra. Atha nyilkngiperra ingkarraka inthorra ungkwanganha urrparaka, unta nukurna ingkakalanga warta. ");
INSERT INTO are_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Untantama urrkapunhapunha arrpunha nhanhaka montjamontja ntelalheikanhantema, yingala ungkwanga montjamontja ntelalhakala ngerra.’ ");
INSERT INTO are_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","King era yirrknga inthorra namala, era kala artwa erinha jail-aka kurnaka era money ingkarraka inthorra nthitjalputjinalpula. ");
INSERT INTO are_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Kaarta Alkirarinya nukanha king nhanha era ngerra ntelalhama. Era antja nama rrangkarra tjina tnakanhakanha rrakangkarranhaka korna iwutjika. Itjanga, era korna rrakangkarranha itjantema iwutjina.” ");
INSERT INTO are_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Etnanha kaltjinthamaliperra, Jesuanha pmara Galilee-anga pmara Judea-urnantama lhaka, Jordan Lhiranga urntwarra mpinyurna. ");
INSERT INTO are_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Relha ntjarra inthorrala erinha lurnaka. Etnakanga ntjarra arrpunha menta naka. Etnanha Jesuala marrilaka. ");
INSERT INTO are_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Artwa Pharisee urrputjantama ekururna pitjika, erinha arrkarnitjika. Etna erinha pmarraka. “Nhanha arratjama nama artwala noa ekuranha imputjika, era paka ekura antjakunyanga?” ");
INSERT INTO are_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesuala etnanha ilaka, “Rrangkarra itjala Altjirraka Angkatja Imankinyala read-erraka? Altjirrala relhanha arrpmarnamalanga, era ‘etnanha orrea marla turta arrpmarnaka.’ ");
INSERT INTO are_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Altjirrala turtantama ilaka, ‘Lakinhanga artwala kaarta pa mia ekuranha impurlalhama, noa ekuranhalela turtantama kuterrama. Noarta eratharra turtantama mpurrka nyinterritjina.’ ");
INSERT INTO are_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Lakinhanga eratharra itja wotha tweta nama, nyinta pula. Relhala turta itja ilkngakitjika nhanha Altjirralala nyintalhelakala.” ");
INSERT INTO are_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Artwa Pharisee etnantama Jesuanha wotha pmarraka, “Iwunhangantama Moses-ala relha ntjarranha ilaka, artwala kala noa ekuranha imputjika, era paka ekura itja antjanga. Era erinha pepanta nthitjika, angkatja nhanhakarta, ‘Yinga kala ungkwanganga unpulhakantama’.” ");
INSERT INTO are_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesuala etnanha ilaka, “Moses-ala rrangkarranha impurlarrarnaka noa rrakangkarranhanga unpulhitjika, rrangkarra arrthata namanga warta. Tjontintjanga pula, nhanha itja kuta Altjirraka eterrintja naka. ");
INSERT INTO are_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Athantama rrangkarranha ilama, artwa erala noa ekuranha impuma, arrkutja era itja artwa arrpunhalela korna mpaarakalangatanya, era turtantama arrkutja arrpunha noa inama, era kala korna mpaarama.” ");
INSERT INTO are_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kurtungurla etnantama Jesuanha ilaka, “Lakinhanga, nhanha marralkura namara noakunya nitjika.” ");
INSERT INTO are_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesuala pula etnanha ilaka, “Nhanha pula itja relha ingkarrakakathaka nama noakunya nitjika. ");
INSERT INTO are_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kala artwa etnakanta, etnala itja orrea inthorra alkngerrakala. Etnaka turta, etnanhala artwala kornilakala. Urrputja arrpunhaka turta, etnala noakunya nitjika antja, etna kala Altjirrakanta urrkaputjinanga. Arai, relha erala noakunya nitjika antja, eranta kala noakunya nitjika.” ");
INSERT INTO are_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Relha arrpunha ntjarralantama katjia etnakanha Jesuurna kngitjika, era iltja ekuranha kapurta etnakanhaka arrarnitjika, etnakakwia Altjirrurna ingkitjika turta. Jesuaka kurtungurla ntjarrala pula relha etnanha unpurlenaka. ");
INSERT INTO are_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesuala pula etnanha ilaka, “Katjia etnanha impai. Yinga antja etna nukurna pitjitjika, Altjirranha antja namanga ntelalhitjika era Ingkarta etnaka namanga.” ");
INSERT INTO are_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesualantama iltja ekuranha kapurta etnakanhaka arrarnaka. Kurunga era wotha anpara lhaka. ");
INSERT INTO are_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Artwa nyintantama Jesuurna pitjimala erinha pmarraka, “Kaltjinthanhinthanhai, nthakinhama yinga marra ntelalhamara, yinga Altjirraka pmarala ngampakala etatha nitjinanga?” ");
INSERT INTO are_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesuala erinha ilaka, “Iwunhangama unta yinganha nhanhiperra pmarrama? Altjirra nyintanta marra nama. Unta paka antja namanga ngampakala etatha nitjika, Altjirraka turnintjaka kangkwerrai.” ");
INSERT INTO are_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Artwa era pula Jesuanha wotha pmarraka, “Turnintja nthanha ntjarrakantama yinga kangkwerritjika?” Jesuala erinha ilaka, “‘Unta itja relha arrpunhanha errilknga tutjika’. ‘Unta itja relha arrpunhaka noalela intitjika.’ ‘Unta itja relha arrpunhaka yultha nyilkngala initjika.’ ‘Unta itja relha arrpunhiperra orrtjerritjika.’ ");
INSERT INTO are_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘Unta kaarta pa mia ungkwanganhaka kangkwerritjika.’ ‘Unta turta relha arrpunhaka kangkitjika, untala ungkwangararrpa kangkamanga ngerra.’” ");
INSERT INTO are_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nthitja era Jesuanha alpmelaka, “Yinga pula turnintja nhanha ingkarrakaka kala kangkwerraka. Turnintja arrpunha paka namama?” ");
INSERT INTO are_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesuala erinha ilaka, “Unta paka antja namanga Altjirraka arratja inthorra kangkwerritjika, yultha ingkarraka ungkwanganha yirrinthai, money ingkarraka turtantama relha ilkngara ntjarranha nthai. Kurunga ungkwanga yultha ngerra kngarra alkirala intitjina. Unta turtantama nukanga tnaartangala pitjai.” ");
INSERT INTO are_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nhanha wumala nthitja era ltarrperraka, alpuka turta. Erataka netaneta inthorra naka. ");
INSERT INTO are_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesualantama kurtungurla ekuranha ntjarranha ilaka, “Atha rrangkarranha nhanha nthurrpa ilama. Relha netanetaka kunha inpora inthorra nama Altjirraka pmarurna irrputjika. ");
INSERT INTO are_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Atha rrangkarranha nhanha turta ilama, nhanha rukaralkura nama camel needle-aka altjuranga tjananhitjika, nhanhangatjina, relha netaneta Altjirraka pmarurna irrputjika.” ");
INSERT INTO are_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nhanha wumala kurtungurla ntjarra tnolkaka inthorra. Etnantama Jesuanha pmarraka, “Ngunhantama Altjirraka pmarurna irrputjina?” ");
INSERT INTO are_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Etnanha intarra aramala, Jesuala etnanha ilaka, “Relha yarna Altjirraka pmarurna irrpuma, erarrpa antja namanga. Altjirrala pula relhanha irrpalthala irrpulhelama, era antja namanga.” ");
INSERT INTO are_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peter-alantama Jesuanha pmarraka, “Ingkartai, nurna kunha yulthalka, ramaramalka ingkarraka impurlalhaka ungkwanganga tnaartangala lhitjinala. Iwunhantama nurnaka ingkarna intitjina?” ");
INSERT INTO are_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesuala erinha alpmelaka, “Atha rrangkarranha nhanha nthurrpa ilama. Anma Altjirranha ntelalhamalanga era relha ingkarrakaka Ingkarta namanga, Relhaka 'Lira era chair makalaria ekuranhaka arrarnalhitjina. Kurunga rrangkarra turta, kurtungurla nukanha ntjarra, chair 12 arrpunhaka arrarnalhitjina. Rrangkarra turtantama Israel-aka ramarama 12 etnanha tjiperrawutjina. ");
INSERT INTO are_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Relha arrpunha ntjarra turta, etnala pmara paka, kalya paka, kwaiya paka, tjia paka, kaarta paka, mia paka impurlalhakala, nukanga tnaartangala lhitjinala, Altjirrala etnanha turta kngarra inthorra kwartiwutjina. Etna turtantama Altjirraka pmarala ngampakala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Relha etnala lyarta arrkurlerrama, etna ingkarnerritjina. Kanha relha etnala lyarta ingkarnerrama, etna arrkurlerritjina. ");
INSERT INTO are_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Altjirranha relha ingkarrakaka Ingkarta namanga, kala lakinha ngerra nama. Artwa marna grapes-akurtwia ingutnhala inthorra lhaka artwa ntjarranha initjika, tnukulpa ekuranhala urrkaputjika. ");
INSERT INTO are_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Era turta artwa etnanha lhelaka $50 wages nthitjika. Etnakanga urlarra nhanha marra naka. Erantama etnanha tnukulpurna yairnaka, urrkaputjika. ");
INSERT INTO are_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kala ingutnhalantama era wotha town-urna lhaka. Erantama artwa urrputja arrpunha araka kunpa itnarlanamanga. ");
INSERT INTO are_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Era etnanha ilaka, ‘Rrangkarra turta tnukulpurna lhai, urrkaputjika. Atha kala rrangkarranha arratja kwartiwutjina.’ Etna turtantama lhaka, urrkaputjika. ");
INSERT INTO are_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kurunga ngkinyala, ngkinyiperra turta, era wotha town-urna lhaka, artwa arrpunha ntjarranha initjika, tnukulpala urrkaputjika. ");
INSERT INTO are_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kala ngurrangurra inthorrantama era wothantema town-urna lhaka. Era artwa urrputja arrpunha araka kunpa itnarlanamanga. Erantama etnanha pmarraka, ‘Iwunhangala rrangkarra arlta ntjapara kunpa itnarlanaka?’ ");
INSERT INTO are_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Etna erinha ilaka, ‘Artwa nyintala kunha nurnanha itja urrkaputjika inaka paka.’ Tnukulpakurtwia erantama etnanha ilaka, ‘Kala rrangkarra turta tnukulpa nukanhurna lhai, urrkaputjika.’ ");
INSERT INTO are_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kala alkngaralantama, tnukulpakurtwia era urrkapunhapunha ntjarraka itornkaka ntangkalhaka. Era erinha ilaka, ‘Urrkapunhapunha ntjarranha ntangkamala, etnanha kala kwartiwai. Artwa ngurrangurranta urrkaputjika tjontakala ntjarranhakimparra kwartiwai. Kurunga artwa arrpunha ingkarrakanhantama, artwa ingutnhala inthorra tjontakala ntjarrakurtitja.’ ");
INSERT INTO are_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Artwa ngurrangurra inthorranta urrkaputjika tjontakala ntjarra, etna pitjimala $50 inaka. ");
INSERT INTO are_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nhanha aramala artwa lenha ntjarra etnala ingutnhala inthorra urrkaputjika tjontakala, etna etarlaraka etna kula kwartiwuntja kngarralkura initjinala. Etna turta pula $50-ntema inaka. ");
INSERT INTO are_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kwartiwuntja etnaka inamala, etna tnukulpakurtwia ekururna wannga angkaka. ");
INSERT INTO are_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Artwa ingkarna inthorra urrkaputjika tjontakala ntjarra, etna kunha kurrka wara urrkapuka. Nurna pula arlta ntjapara urrkapuka, mpalha kngarrala turta. Kanha unta nurnanha loala kutala kwartiwuka.’ ");
INSERT INTO are_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Tnukulpakurtwia erantama artwa wannga angkakala nyintanha ilaka, ‘Artwai, atha nganha arratja kwartiwuka. Ilirna nhanga arrkurlantema angkarraka unta $50-aka urrkaputjinala. ");
INSERT INTO are_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kala kwartiwuntja ungkwanganha inamala, alpai. Yingarrpa antja naka artwa ingkarna inthorra urrkaputjika tjontakala ntjarranha kwartiwutjika, athala nganha kwartiwukala ngerra. ");
INSERT INTO are_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nhanha kala nukathaka nama, money nukanha errarnpalhelitjika yingala antja namala ngerra. Unta nuka antjakunyama errama, atha relha arrpunhanha kangkintjala wara nthamanga?’ ");
INSERT INTO are_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Lakinha ngerra relha etnala lyarta ingkarnerrama, etna arrkurlerritjina. Kanha relha etnala lyarta arrkurlerrama, etna ingkarnerritjinala.” ");
INSERT INTO are_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Etna Jerusalem-urna lhapalhaka. Jesualantama kurtungurla ekuranha ntjarranha ntangkamala, ilaka. ");
INSERT INTO are_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Arai, nurna nhanha Jerusalem-urna lhama. Jerusalem ekuralantama arrpunhala Relhaka 'Lira erinha priest itornka ntjarraka lanthitjina, artwa Intarrangaltha ntjarraka turta. Etnantama erinha imilitjina. ");
INSERT INTO are_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kurunga etna erinha Relha Lorinya ntjarraka lanthitjina, etna erinha arrampowutjika, whip-ala tutjika, ntolkaka turtantama kanthatutjika. Arlta tharraminyinta errilknga intamaliperra pula, Altjirrala erinha wotha kamalhelitjina.” ");
INSERT INTO are_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kurunga Zebedee-aka noa, worra ekuranha tharrakarta pitjika, Jesuanha pmarritjika. Erantama Jesuanga urlarra mparalela arrarnalhaka. ");
INSERT INTO are_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesualantama erinha pmarraka, “Iwunhakama unta antja?” Era angkaka, “Unta Ingkarta kngarrantama namanga, yinga antja worra nukanha nyinta ungkwanganga akwala nitjika, arrpunha ungkwanganga kwanginyala.” ");
INSERT INTO are_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesuala pula artwa erinhatharra ilaka, “Mpalataka marntilparla inthorra pmarrama. Mpala paka nukalela nyingalauwumarama, yingala nyingalauwutjinala ngerra?” Eratharra angkaka, “Awakwia.” ");
INSERT INTO are_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesuala erinhatharra ilaka, “Mpala nthurrpa anma nyingalauwutjina, yingala nyingalauwutjinala ngerra. Relha ngunha pula nukanga akwala nitjina? Relha ngunha turtama nukanga kwanginyala nitjina? Nhanha itja nukathaka nama. Nhanha Kaarta nukanhakanta nama.” ");
INSERT INTO are_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kurtungurla 10 arrpunhala nhanhiperra wumalanga, etna kanhanga ekura tharra yirrkngerraka. ");
INSERT INTO are_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesuala pula kurtungurla etnanha worlilamala ilaka. “Rrangkarra kala kaltja Relha Lorinya ntjarraka itornka, etna relha etnakanhaka tjitjarterrama. Relha kngarra ntjarra turta relha kornakorna ntjarraka. ");
INSERT INTO are_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Worla nukanhala pula itja lakinha ngerra nitjika. Relha erala worla nukanhaka itornka nitjika antja, era kala arrpunha ntjarraka tangitjala nitjika. ");
INSERT INTO are_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Relha erala worla nukanhaka itornka kngarra nitjika antja, era kala arrpunha ntjarraka kngarra tangitjala nitjika. ");
INSERT INTO are_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Arai, Relhaka 'Lira pitjika relha ntjarraka tangitjala nitjika, itja etna ekura tangitjala nitjika. Era pitjika relha ntjarrakakwia ilutjika, etnanha tangkalhelitjika turta.” ");
INSERT INTO are_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesuanha, kurtungurla ekuranha ntjarra turta Jericho-anga rratamanga, worla kngarra Jesuanga tnaartangala lhakantema. ");
INSERT INTO are_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Artwa panga tharra tjaiyanga kutala narlanaka. Panga eratharra wumalanga Jesuanha tjaiyala pitjimanga, eratharra ekura ilkaka, “Ingkartai, David-aka 'Lirai, ilirnaka montjamontja ntelalhai.” ");
INSERT INTO are_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Relha ntjarrala pula erinhatharra turnaka, “Tjukunyerrai!” Eratharra pula kuta intarra ilkaka, “Ingkartai, David-aka 'Lirai, ilirnaka montjamontja ntelalhai.” ");
INSERT INTO are_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Itnatjalhamala, Jesuala erinhatharra ntangkaka. Erantama erinhatharra pmarraka, “Iwunhangama mpala nuka ilkaka?” ");
INSERT INTO are_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Eratharra angkaka, “Ingkartai, alknga ilirnaka marrilai.” ");
INSERT INTO are_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesuanha ekuratharra ltarrperraka. Erantama alknga ekuratharra anpuka. Alknga ekuratharrantama marrerraka. Eratharra turtantama ekuranga tnaartangala lhaka. ");
INSERT INTO are_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesuanha, kurtungurla ekuranha ntjarra turta kala Jerusalem-aka etinyerrakantama. Etnantama town kurrka nyinturna pitjika, rretnya ekura Bethphage. Bethphage erataka Olive Partanga kuta italhaka. ");
INSERT INTO are_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jesualantama kurtungurla tharra ekuranha yairnaka. Era erinhatharra ilaka. “Pmara kurrka arrpunha tanhurna lharrai. Pmaraka irrpunhamala ngerra mpala donkey marla aritjina rope-ala yirnakala, kurrka ekuranhakarta itnarlanamanga. Rope erinha ilumala, donkey tharranhantema nukurna kngitjai. ");
INSERT INTO are_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Arrpunhala paka mpalanha pmarramanga, ‘Iwunhangama mpala donkey erinhatharra kngama?’ Mpala lakinhanta angkai, ‘Ingkartanha kunha ekuratharra antja.’ Erantama donkey erinhatharra kala impurlenitjina.” ");
INSERT INTO are_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Lakinha Altjirraka lhelintja nthurrperraka. Altjirraka urrpia arrpunhala imanka relha ntjarranha ilaka, ");
INSERT INTO are_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Relha Zion-arinya ntjarranha ilai. Arai, king rrakangkarra, kala rrakangkarrurna pitjimantama. Era itja tjurnalhama. Era donkey-ala nanhama, donkey marlaka kurrkala purrama.” ");
INSERT INTO are_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kurtungurla eratharra pmara kurrka ekururna lhaka, Jesuala erinhatharra turnakala ngerra. ");
INSERT INTO are_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kurtungurla eratharrantama donkey erinhatharra kngitjalpurraka. Kurunga eratharra mantarra ekuratharra donkey manhangaka arrarnaka. Jesuanha turtantama donkey-aka ntjika. ");
INSERT INTO are_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jesuanha tjaiyakerramalanga worla kngarrala mantarra etnakanha tjaiyaka ntjamiwuka. Kanha worla kngarra arrpunhala walyala kaka, walya nhanha turta tjaiyaka ntjamiwuka. ");
INSERT INTO are_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Relha ntjarra Jesuanga arrkurla lhaka. Relha ntjarra arrpunha turta ekuranga tnaartangala pitjika. Etna ingkarraka intarra ilkarlanaka, “Nurna David-aka 'Liranha lyarta tnantjama. Altjirrai, urrpia ungkwanganha lyarta nurnakurna pitjima. Unta erinha lyekarrilai. Nurna Altjirranha turta lyarta kngarra inthorra tnantjama.” ");
INSERT INTO are_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesuanha Jerusalem-aka irrpunhakantama. Relha Jerusalem-arinya ntjarra tnolkamala pmarrarraka, “Ngunhama artwa nhanha?” ");
INSERT INTO are_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Relha ntjarrala etnanha alpmelaka, “Nhanha kunha Jesuanha, Altjirraka urrpia. Era Nazareth-arinya nama, pmara Galilee-arinya.” ");
INSERT INTO are_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesuanha Altjirraka temple-urna irrpuka. Temple kwanala artwa ntjarra nitjata, etnala nturrurta yirrinthitjata, relha epinyaka money turta ekngarrpunhilitjata. Jesuala etnanha unpurlenaka. Era table etnakanha, chair etnakanha turta ankartiwuka. ");
INSERT INTO are_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Era etnanha ilaka. “Altjirraka Angkatja Imankinyala ilama, ‘Iltha nuka relha ingkarrakaka pmara nitjika, pmara nhanga ekururnala etna pitjima nukurna ingkitjika. Kanha rrangkarra iltha nukanha nyilkngampaka pmaratitjala mpaaraka.’” ");
INSERT INTO are_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Relha panga ntjarra, inurra ntjarra turtantama Jesuurna pitjika era temple-ala namalanga. Era etnanha marrilaka turta. ");
INSERT INTO are_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Priest itornka ntjarrala, artwa Intarrangaltha ntjarrala araka Jesuala tjatjikarta ntjarra urrkapumanga. Etna turta wuka katjia ntjarra lakinha lyilhamanga, “Nurna David-aka 'Liranha lyarta tnantjama.” Etnantama Jesuaka yirrkngerraka. ");
INSERT INTO are_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Artwa nhanha etnantama Jesuanha pmarraka, “Unta katjia nhanha ntjarraka angkatja wumama?” Jesuala etnanha ilaka, “Awa, atha wumakwia. Rrangkarra itjala ilpangkama? Altjirraka Angkatja Imankinyala ilama, “Altjirrai, unta kunha katjia kurrka ntjarranha, ipatja ntjunha ntjarranha turta kaltjinthaka nganha tnantjitjika.” ");
INSERT INTO are_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesuala etnanha impurlalhakantama. Kurunga Jerusalem-anga rratamala, era Bethany-urna lhaka, intitjika. ");
INSERT INTO are_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ingutnhala Jerusalem-urna alpumala, Jesuanha ngaiyala wulhaka. ");
INSERT INTO are_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Irna tjurrka nyinta aramala, era irna ekururna lhaka, tjurrkaka. Era pula ilpalhanta araka, tjurrka annga itjala. Erantama irna erinha ilaka, “Unta itja wotha marnakarterritjina, itja kuta.” Irna tjurrka erantama kala ntjirrkerraka. ");
INSERT INTO are_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nhanha aramala kurtungurla etna tnolkamala angkaka, “Yai, irna nhanha pula warangala inthorra ntjirrkerralalhaka.” ");
INSERT INTO are_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesuala pula etnanha ilaka, “Rrangkarra paka Altjirranha kurrka waranta tnakamanga, Altjirranha turta itja ilpoiwumanga, rrangkarra turta tjatjikarta urrkaputjina. Rrangkarra parta kngarritja nhanha turnamanga laiyaka iwulhitjika, era kala laiyaka iwulhitjina. ");
INSERT INTO are_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Rrangkarra paka Altjirranha tnakamanga rrangkarra ekururna ingkamalanga, era kala rrangkarranha wutjina.” ");
INSERT INTO are_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesuala relha ntjarranha temple kwanala kaltjinthamalanga, priest itornka ntjarra, kngarripata ntjarra turta ekururna pitjika. Etna erinha pmarraka, “Ngunhalama nganha turnaka relha ntjarranha kaltjinthitjika? Nhanha ungkwangathaka namama?” ");
INSERT INTO are_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesuala etnanha alpmelaka, “Atha turta rrangkarranha pmarritjina. Rrangkarra paka yinganha alpmelamanga, atha turta rrangkarranha alpmelitjinantema. ");
INSERT INTO are_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yinganha ilai, Ngunhalama John-anha turnaka relha ntjarranha kaltjirrpulhelitjika? Thunga Altjirrala? Thunga relhala paka?” Nhanhiperra eterramala, etna lakinha ilarraka. “Nurna paka erinha ilamanga Altjirrala erinha turnakala, era nurnanha ilitjina, ‘Iwunhangantama rrangkarra erinha itja tnakaka?’ ");
INSERT INTO are_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nurna paka erinha ilamanga relhala erinha turnakala, relha ntjarrala nurnaka yirrkngerritjina.” Relha ntjarranga urlarra John-anhataka Altjirraka urrpia naka. ");
INSERT INTO are_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Etnantama Jesuanha ilaka, “Nurna itja kaltja.” Jesualantama etnanha ilaka, “Lakinhanga atha turta rrangkarranha itjantema alpmelitjina.” ");
INSERT INTO are_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesualantama etnanha pmarraka, “Nthakinhama rrangkarra nhanhiperra etarlarama? Wurlathanai. Artwa nyintaka 'lira tharra naka. Arlta arrpunhala era worra arrkurlinya ekuranha ilaka, ‘'Lirai, grapes tnukulpala urrkaputjika lhai.’ ");
INSERT INTO are_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Era pula angkaka, ‘Kngarripatai, yinga itja lhitjina.’ Anma pula era porerraka, lhaka turta. ");
INSERT INTO are_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kaarta erantama tjia ekuranha ilaka, ‘'Lirai, grapes tnukulpala urrkaputjika lhai.’ Era kaarta ekuranha alpmelaka, ‘Yinga kala lhitjina.’ Era pula itjala lhaka. ");
INSERT INTO are_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Rrangkarrantama yinganha ilai. Worra ngunhama kaarta ekuranhaka kangkwerraka?” Etna erinha ilaka, “Worra arrkurlinya erakwia.” Jesualantama etnanha ilaka, “Atha rrangkarranha nhanha nthurrpa ilama. Artwa tax money kotjinha ntjarra, arrkutja tnapurta ntjarra turta Altjirraka pmarurna irrputjina. Kanha rrangkarra itjala. ");
INSERT INTO are_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","John-anha nhanga pitjika, era turta rrangkarranha tjaiya arratja erinha ntelaka. Rrangkarra pula erinha itja tnakaka. Artwa tax money kotjinha ntjarrala, arrkutja tnapurta ntjarrala turta pula erinha tnakakala. Kanha rrangkarra itjala Altjirrurna toperraka, erinha tnakaka paka.” ");
INSERT INTO are_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Rrangkarra yinganha wurlathanai, atha rrangkarranha yia arrpunha alpmelamanga. Pmarakurtwia nyintala marna grapes ingkairnaka tnukulpa ekuranhala. Erantama parta inamala, tnukulpa ekuranga fence itaka. Era iparta turta tnyaka, nhanga marna grapes etnanha anma nharrkutjika. Era iltha tjenya turta itaka, artwala kartninyanga tnukulpa erinha kartaritjinanga. Kurunga era tnukulpa erinha artwa arrpunha ntjarraka rent-emilaka. Kurtwia erantama pmara arrpunhurna lhaka. ");
INSERT INTO are_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Marnaka kotjintjaka antalalantama, kurtwia era urrkapunhapunha ekuranha ntjarranha yairnaka, rent money ekuranhaka. ");
INSERT INTO are_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Artwa etna pula urrkapunhapunha etnanha errkuka. Arrpunhanha etna whip-ala tuka. Arrpunhanha etna errilknga tuka. Arrpunhanha etna partala waka. ");
INSERT INTO are_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kurtwia erantama urrkapunhapunha arrpunha ntjarra etnakurna yairnaka, ntjarralkura arrkurlangatjina. Etna pula etnanha turta tukantema. ");
INSERT INTO are_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Anma kurtwia era 'lira ekuranhantama etnakurna yairnaka. Era eterraka, “Etna ekura kangkwerritjina.” ");
INSERT INTO are_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Artwa etna pula 'lira erinha aramala, lakinhala angkarraka. “Nhanha kunha 'lira era. Anma kunha tnukulpa nhanha ekurantama nitjina. Mpa, nurna erinha errilknga twiai, tnukulpa nhanha kala nurnakantama nitjinanga.” ");
INSERT INTO are_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Etnantama erinha errkuka, tnukulpanga kathurna iwuka, errilknga tuka turta. ");
INSERT INTO are_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesualantama etnanha pmarraka, “Nthakinhama rrangkarra etarlarama? Kurtwia era pitjalpumalanga, era paka etnaka kangkitjinama?” ");
INSERT INTO are_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Etna erinha ilaka. “Itja. Etna artwa korna warta namanga, era etnaka kngarra alkngarnterritjina, etnanha errilknga tutjina turta. Kurunga era tnukulpa ekuranha artwa arrpunha ntjarranhantama nthitjina, ekura ntarntaritjika. Artwa arrpunha etnanha purrama, etnala erinha rent money ekuranha arratja nthitjinala.” ");
INSERT INTO are_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesuala etnanha ilaka, “Rrangkarra kala Altjirraka Angkatja Imankinya nhanhaka kaltja, ‘Parta nhanga iltha itanha ntjarrala ipmintja iwukala, erantama lyarta parta tjiparra inthorra era nama. Ingkarta erarrpa ilaka era tjiparra inthorra namanga. Nurna kala tnolkamanta, nhanha aramala.’ ");
INSERT INTO are_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Lakinhanga atha rrangkarranha ilama Altjirrala rrangkarranha unputjina. Erantama relha arrpunha ntjarranha initjina worla ekura nitjika. Relha arrpunha ntjarranha purrama, etnala ekura kangkwerritjinala. ");
INSERT INTO are_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Arai, relha erala parta lenhakarlaka tnyimanga, erinha Altjirrala ungkwaltjilitjina. Kanha relha ekurakarlakala parta era tnyimanga, erinha parta erala urrpmaltjitjina.” ");
INSERT INTO are_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Priest itornka ntjarrala, artwa Pharisee ntjarrala turta yia nhanha wumalanga, etna lhangkaraka era etnakiperra angkamanga. ");
INSERT INTO are_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Etnantama antja naka erinha errkutjika, etna pula relha ntjarranga trerraka. Relha etnataka etarlaraka Jesuanha Altjirraka urrpia namanga. ");
INSERT INTO are_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesualantama etnanha wotha kaltjinthaka, etnaka yia alpmelamala. ");
INSERT INTO are_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Era etnanha ilaka, “Altjirranha relha ingkarrakaka Ingkarta namanga, kala lakinha ngerra nama. King nyinta naka, erala 'lira ekuranhaka mpanyaka tjinkarra urrkapukala. ");
INSERT INTO are_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Era turta relha arrpunha ntjarranha arrkurla kuta ilaka, era etnanha tjinkarraka ntangkitjinala. Anma era urrkapunhapunha ntjarranha yairnaka relha etnanha ilitjika, ‘Pitjai, marnalka ingkarraka kala namanga.’ Relha etna pula itja antja naka pitjitjika. ");
INSERT INTO are_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","King erantama urrkapunhapunha arrpunha ntjarranha yairnaka, relha etnanha wothantema ntangkitjika. King era urrkapunhapunha etnanha turnaka relha etnanha lakinha ilitjika. “Arai, atha kala tjinkarra nukanha urrkapuka. Kara ntira ingkarraka atha kala tuka, etaka turta. Marnalka ingkarraka kala intama. Kala tjinkarraka pitjai.” ");
INSERT INTO are_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Relha etna pula itja kuta antja naka pitjitjika. Arrpunha tnukulpa ekuranhurna lhaka. Arrpunha yulthaka urrkaputjika lhaka. ");
INSERT INTO are_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Arrpunha ntjarrala king-aka urrkapunhapunha ntjarranha errkuka, etnaka alkngarnterraka, etnanha errilknga tuka turta. ");
INSERT INTO are_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","King erantama yirrkngerraka. Era tjapartia ekuranha ntjarranha yairnaka relha nhanha etnanha yirralhelitjika, pmara etnakanha turta urala etitjika. ");
INSERT INTO are_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Erantama urrkapunhapunha ekuranha ntjarranha ilaka, “Atha tjinkarra nukanha kala urrkapuka. Relha athala arrkurla ntangkakala, etnaka pula yinga itja wotha antja. ");
INSERT INTO are_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lakinhanga rrangkarra relha arrpunha ntjarrurna lharrirrai. Etnanha ntangkai turta tjinkarra nukanhaka pitjitjika.” ");
INSERT INTO are_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Urrkapunhapunha etna lhaka. Etna relha ntjarra arltaraka, relha marra pa relha korna. Etna etnanha worlilaka. Kala relha kngarrantama iltha ekurala naka. ");
INSERT INTO are_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","King erantama iltha ekururna irrpentjika. Era relha etnanha tjoraraka. Erantama artwa arrpunha araka, erala itja mantarra marraka ekarralhakala. ");
INSERT INTO are_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","King-alantama erinha pmarraka, “Tjinai, nthakinhala unta nhanhurna irrpentjika mantarra kornakarta?” Era pula pmarna kuta naka. ");
INSERT INTO are_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","King erantama urrkapunhapunha ntjarranha turnaka, “Iltja ekuranha, ingka ekuranha turta yirnai. Kurunga rrangkarra erinha iltha nukanhanga kathurna iwai, pmara thapathapurna. Tanhala relha itnima, itetja turta kakulhama. ");
INSERT INTO are_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Arai, Altjirrala relha ntjarranha ntangkama. Era pula urrputjanha wara urrarama.” ");
INSERT INTO are_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Artwa Pharisee ntjarrala Jesuanha arrkarnitjika antja naka. Etnantama worlerraka nhanhiperra angkarritjika. ");
INSERT INTO are_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kurunga etna kurtungurla urrputja etnakanha Jesuurna yairnaka, King Herod-aka urrkapunhapunha urrputja turta. Etnantama Jesuanha pmarraka, “Kaltjinthanhinthanhai, nurna kaltja unta artwa ilporatha namanga. Nurna turta kaltja unta relha ntjarranha kaltjinthama Altjirranga urlarra arratja ntelalhitjika. Nurna turta kaltja unta itja relhanga trerramanga. ");
INSERT INTO are_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nurnanha ilai, Altjirrala nurnanha turnamama Caesar-anha tax money nthitjika?” ");
INSERT INTO are_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesuanha pula kaltja naka etna korna eterramanga. Erantama etnanha pmarraka, “Artwa pmatha ntjarrai, iwukama rrangkarra yinganha arrkarnama? ");
INSERT INTO are_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yinganha tax money ntelai.” Etnantama erinha tax money ungkwaltja nthaka. ");
INSERT INTO are_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Erantama etnanha pmarraka, “Ngunhaka ntolyama money ekurala nama? Ngunhaka rretnya turtama money ekurala nama?” ");
INSERT INTO are_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Etna erinha alpmelaka, “Caesar-akakwia.” Jesualantama etnanha ilaka, “Money nhanha Caesar-aka namanga, rrangkarra nhanha kala Caesar erinha ntharrirrai. Rrangkarra turta Altjirraka kangkwerrai, erala rrangkarranha turnakala ngerra.” ");
INSERT INTO are_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Angkatja nhanha wumala etna tnolkaka. Etnantama erinha impurlalhaka, alpuka turta. ");
INSERT INTO are_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Artwa Sadducee ntjarrantama Jesuurna pitjika. Sadducee etnataka relha ntjarranha ilitjata, relha errilknga ntjarra itja kamerritjinala. Sadducee etnantama Jesuanha pmarraka, ");
INSERT INTO are_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Kaltjinthanhinthanhai, Moses-ala nurnanha lakinha turnaka. Artwa paka katjiakunya ilumanga, tjia ekuranhala warlukurta erinha noa initjika, kalya ekuranhaka katjia intitjinanga paka. ");
INSERT INTO are_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Arai, pmara nhanhala kanhanganhanga 7 naka. Kalya kngarrala noa inaka, era pula katjiakunya iluka. Tjia ekuranhalantama arrkutja erinha noa inaka. ");
INSERT INTO are_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tjia nhanha era pula katjiakunyantema iluka. Kurunga tjia arrpunhala arrkutja erinha noa inaka. Era turta pula katjiakunyantema iluka. Lakinha kanhanganhanga ingkarrakala arrkutja nyinta erinha noa tnyinaka. Ingkarraka kala ilukantama. ");
INSERT INTO are_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kurunga ingkarna arrkutja era turtantama iluka. ");
INSERT INTO are_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Altjirrala relha errilknga ingkarrakanha kamalhelamanga, artwa ngunhaka noantama arrkutja nhanha era nitjina? Era kunha kanhanganhanga 7-akantema noa nakala.” ");
INSERT INTO are_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesuala pula etnanha ilaka, “Rrangkarrataka paalakarla pmarrama. Rrangkarrataka Altjirraka Angkatja Imankinyaka kotna. Rrangkarra turta kngwerraka Altjirranha ekarlta inthorra namanga. ");
INSERT INTO are_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Anma, Altjirrala relha errilknga ntjarranha kamalhelamalanga, etna itja noa inarritjina. Etna kala angel ntjarra ngerra nitjina. ");
INSERT INTO are_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Rrangkarra kunha ilpoiwuma Altjirrala relha errilknga ntjarranha kamalhelitjinala. Altjirrala kunha rrangkarranha ilama, ");
INSERT INTO are_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yinga Abraham-aka Altjirra nama, Isaac-aka Altjirra, Jacob-aka Altjirra turta.’ Arai, Altjirranha relha etathaka Altjirra nama, itja relha errilknga ntjarraka.” ");
INSERT INTO are_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Relha worla etna tnolkaka, etna Jesuanha wumalanga era etnanha kaltjinthamanga. ");
INSERT INTO are_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Artwa Pharisee ntjarrala wuka Jesuala artwa Sadducee ntjarranha tjukunyilakala. Etnantama worlerraka erinha pmarritjika. ");
INSERT INTO are_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Etnakanga arrpunhala, artwa Intarrangalthalantama, Jesuanha pmarraka, ");
INSERT INTO are_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kaltjinthanhinthanhai, yinganha Altjirraka turnintja kngarra erinha ilai?” ");
INSERT INTO are_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesuala erinha ilaka, “Unta Ingkarta Altjirra ungkwanganhaka kngarra inthorra kangkitjika. Unta ekura kuta eterritjika. Unta erinhanta tnakitjika. ");
INSERT INTO are_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nhanha turnintja kngarra era nama. ");
INSERT INTO are_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Turnintja arrpunha nhanha turta kngarra nama. Unta relha arrpunha ntjarraka kangkitjika, untala ungkwangararrpa kangkamanga ngerra. ");
INSERT INTO are_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kala nhanhanta Moses-ala, Altjirraka urrpia imankinya arrpunha ntjarrala turta relha ntjarranha kaltjinthaka.” ");
INSERT INTO are_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Artwa Pharisee etna ekuralela namalangantema, Jesuala etnanhantama pmarraka. ");
INSERT INTO are_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nthakinhama rrangkarra Kristiperra etarlarama? Ngunhaka 'lirama era?” Etna erinha ilaka, “David-akakwia.” ");
INSERT INTO are_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Erantama etnanha pmarraka, “Nthakinhantama Enka Alkngaltarala David-anha turnaka erinha Ingkarta kitjika? David era nhanga ilaka, ");
INSERT INTO are_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ingkarta era ingkarta nukanha ilaka: akwa nukanhanga arrarnalhai, atha leltja ungkwanganha ntjarranharrka pmakwinitjinanga.’ ");
INSERT INTO are_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David-ala paka Kristanha Ingkarta kakalanga, nthakinhantama Kristanha David-aka 'lira nama?” ");
INSERT INTO are_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nyintala Jesuanha nhanha yarna alpmelaka. Nhanha ekuriperra relha nyinta itja wotha ekura irrpaltherraka, erinha pmarritjika. ");
INSERT INTO are_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesuanhantama relha ntjarrurna, kurtungurla ekuranha ntjarrurna turta angkaka. Era etnanha ilaka, ");
INSERT INTO are_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Artwa Intarrangaltha ntjarrala, artwa Pharisee ntjarrala turta rrangkarranha Altjirraka Angkatja Imankinya kaltjinthama, Moses-ala ngerra. ");
INSERT INTO are_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Lakinhanga rrangkarra angkatja ingkarraka etnakanhaka kangkwerritjika. Rrangkarra pula itja ntelalhitjika, etnala ntelalhamanga ngerra. Arai, etnarrpa kunha itja angkatja ekura kangkwerrama, angkatja nhanga etnala rrangkarranha kangkwerritjika turnama. ");
INSERT INTO are_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Etna relha ntjarranha kaltjinthamala rrothama inthorra ngerra. Etna turta etnaka itja kurrka rukarilama paka. ");
INSERT INTO are_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Etna relhanga urlarra kaiyaka inthorra ntelalhama, relhala etnanha tnantjitjinanga. Etna irna tjilara ngerrakalka ekarralhama, tjilara nhanga Altjirraka Angkatjakartaka, relhala etnanha aritjinanga. ");
INSERT INTO are_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Arrpunhala etnanha tjinkarraka ntangkamalanga, etna katha marra inthorraka arrarnalhama. Etna synagogue-urna pepaka lhamalanga, etna arrkurla inthorraka arrarnalhama. ");
INSERT INTO are_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Etna shopping-aka lhamanga, etna antja nama relha ntjarrala etnanha ‘Kaltjinthanhinthanha’ anparnitjika. ");
INSERT INTO are_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Arrpunhala pula rrangkarranha itjala ‘Kaltjinthanhinthanha’ anparnitjika. Yinga nyintanta kaltjinthanhinthanha rrakangkarra nama. Rrangkarra ingkarraka turta tjia ntjarra nama. ");
INSERT INTO are_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Rrangkarra turta itja artwa arrpunhanha ‘kaarta’ anparnitjika, rrakangkarra ingkarrakaka Kaarta nyinta namanga, alkirala. ");
INSERT INTO are_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Rrangkarra turta itja nyintanha ‘itornka’ anparnitjika, rrakangkarra kala itornka nyinta namanga, Kristanha. ");
INSERT INTO are_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Relha erala tjitjarta rrakangkarra namanga, era kala arrpunha ntjarraka tangitjala nitjika. ");
INSERT INTO are_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Relha erala Altjirranga urlarra tnakalhama, erinha Altjirrala ipmintja iwutjina. Kanha relha erala Altjirranga urlarra porapora ntelalhama, erinha Altjirrala tnyinitjina kuta. ");
INSERT INTO are_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Artwa Intarrangaltha ntjarrai, artwa Pharisee ntjarrai turta, rrangkarrataka imampurla kngarra nitjina. Pmatha ntjarrai, rrangkarra kunha tjaiya erinha marntilaka, erala Altjirraka Pmarurna intanhama. Rrangkarra itja tjaiya nhanhala lhama. Rrangkarra turta relha lenha etnanha parrama, etnala tjaiya nhanhala lhitjika antja. ");
INSERT INTO are_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Artwa Intarrangaltha ntjarrai, artwa Pharisee ntjarrai turta, rrangkarrataka imampurla kngarra nitjina. Pmatha ntjarrai, rrangkarra kunha kwatja laiyanga tjananhama, pmararrpaninhurna turta lhama, relha nyintanha Altjirrurna topalhelitjika. Relha era kala toperrakalangantama, rrangkarra eterrintja ekuranha parrpartilama. Kurunga era rrakangkarranga korna inthorralkura nama. ");
INSERT INTO are_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Rretjinganhanganha panga ntjarrai. Rrangkarrataka imampurla kngarra nitjina. Rrangkarra lakinha angkama. Relhala paka relha arrpunhanha temple-anga urlarra lhelamanga, era lhelintja ekuranhaka irrpalthala kngwerrama. Era pula relha arrpunhanha lhelamanga, gold ekuranga urlarra, erala temple kwanala intamanga, era kala lhelintja ekuranha mangkilitjikala. ");
INSERT INTO are_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Rirta ntjarrai, panga ntjarrai turta. Iwunhama tjiparralkura nama? Gold erala temple kwanala intamanga? Temple era paka, erala Altjirraka iltha namanga? ");
INSERT INTO are_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Rrangkarra turta lakinha angkama. Relhala paka relha arrpunhanha altar-anga urlarra lhelamanga, era lhelintja ekuranhaka irrpalthala kngwerrama. Era pula relha arrpunhanha lhelama, tjauwerrilyanga urlarra, erala altar kartninyala intamanga, era kala lhelintja ekuranha mangkilitjikala. ");
INSERT INTO are_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Panga ntjarrai. Iwunhama tjiparralkura nama? Tjauwerrilya erala altar kartninyala intamanga? Altar era paka, erala Altjirraka namanga? ");
INSERT INTO are_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Arai, relha erala relha arrpunhanha lhelama altar-anga urlarra, era kala tjauwerrilyanga urlarra turta lhelama, tjauwerrilya nhanga erala altar kartninyala intamanga. ");
INSERT INTO are_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Relha erala relha arrpunhanha lhelama temple-anga urlarra, era kala erinha Altjirranga urlarra turta lhelama, Altjirra erala temple kwanala namanga. ");
INSERT INTO are_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Relha erala relha arrpunhanha lhelama alkiranga urlarra, era kala erinha Altjirraka chair kngarritjanga urlarra turta lhelama. Altjirra ekuranga urlarra turta, erala chair kngarritja ekuranhala namanga. ");
INSERT INTO are_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Artwa Intarrangaltha ntjarrai, artwa Pharisee ntjarrai turta, rrangkarrataka imampurla kngarra nitjina. Pmatha ntjarrai, rrangkarra kunha ngkulpalka, paraltjalka Altjirranha tjauwerrilya nthama. Kanha Altjirraka turnintja tjiparra inthorra etnaka, rrangkarra kngwerramala. Rrangkarra itja relha arrpunhanha arratja tjiperrawuma. Rrangkarra itja relha arrpunhaka montjamontja ntelalhama. Rrangkarra turta Altjirranha itja arratja tnakama. Turnintja nhanha ntjarrakakimparra rrangkarra kangkwerreikanha. Kurunga tjauwerrilya turtantama rrangkarra arratja ntheikanha. ");
INSERT INTO are_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Rretjinganhanganha panga ntjarrai, rrangkarrataka thakerrama kngarripata ntjarraka mpaarangarangaka kangkwerritjika. Kanha Altjirraka turnintja tjiparraka rrangkarra kngwerramala. ");
INSERT INTO are_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Artwa Intarrangaltha ntjarrai, artwa Pharisee ntjarrai turta, rrangkarrataka imampurla kngarra nitjina. Pmatha ntjarrai, rrangkarrataka dish itopanta ilkngima. Kanha dish kwana mpinya rrangkarra ulpurta kutala impuma. Lakinha ngerra rrangkarra mpurrkanta ilkngilhama. Kanha eterrintja rrakangkarra korna kutala. ");
INSERT INTO are_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Artwa Pharisee ntjarrai, rrangkarrataka panga. Rrangkarra eterrintjarrka kngartiwulhai. Kurunga rrangkarra Altjirranga urlarra arratja ntelalhitjina. ");
INSERT INTO are_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Artwa Intarrangaltha ntjarrai, artwa Pharisee ntjarrai turta, rrangkarrataka imampurla kngarra nitjina. Pmatha ntjarrai, rrangkarra kunha wolknga intortilakala ngerra nama. Relhala arama wolknga etna marra inthorra tjulkamanga. Kanha kwanala wolknga etna ulpurta inthorrala nama, relha errilkngaka ngkwarnakartalka. ");
INSERT INTO are_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lakinha ngerra rrangkarra turta nama. Relhala rrangkarranha arama, rrangkarra relha arratja marra kula namanga. Kanha eterrintja rrakangkarra korna kutala. ");
INSERT INTO are_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Artwa Intarrangaltha ntjarrai, artwa Pharisee ntjarrai turta, rrangkarrataka imampurla kngarra nitjina. Altjirraka urrpia ilukala ntjarra, errilkngipata arratja ntjarra turta wolkngala intama. Rrangkarrantama ilpangkintjaka iltha kurrka wolknga etakanhaka itama, iltha kurrka etnanha intortilama turta. ");
INSERT INTO are_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Rrangkarra turta angkama, ‘Nurna paka imanka nhanga etatha nakalanga, nurna itjala Altjirraka urrpia ntjarranha tangitjala errilknga tumara.’ ");
INSERT INTO are_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pmatha ntjarrai, lakinha angkamala, rrangkarra ilalhama rrangkarra nthurrpa katjia etnaka namanga, relha etnaka purrama, etnala Altjirraka urrpia ntjarranha errilknga tukala. ");
INSERT INTO are_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Etna ngerra, arrthatalkura kuta ntelalhai. ");
INSERT INTO are_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Rrangkarrataka apma ntjarra ngerra nama, apmaka katjia ngerra turta. Altjirrala kala rrangkarranha tatharrurna yairnitjina. ");
INSERT INTO are_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Arai, atha rrakangkarrurna urrpia ntjarra yairnitjina, artwa kaltja ntjarra, kaltjinthanhinthanha ntjarra turta. Rrangkarra pula etnanha errilknga tutjina, ntolkaka kanthatutjina, whip-ala tutjina synagogue rrakangkarranha kwanala, etnanha pmara nyintanga pmara arrpunhurna turta lurnitjina. ");
INSERT INTO are_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lakinhanga Altjirrala rrangkarranhantama rrarrathala tutjina relha palkinya ingkarrakakakwia, etnala ilukala Abel-angatjina, Barachiah-akurtitja. Rrangkarra kunha Barachiah-anha, Zechariah-aka worra nhanganha errilknga tuka, altar-anga kutaka. ");
INSERT INTO are_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Atha rrangkarranha nhanha nthurrpa ilama, Altjirrala kala rrangkarranhantama rrarrathala tutjina, rrangkarranha, ramarama rrakangkarranha turta.” ");
INSERT INTO are_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Relha Jerusalem-arinya ntjarrai, relha Jerusalem-arinya ntjarrai. Rrangkarra kunha Altjirraka urrpia ntjarranha errilknga tukala. Rrangkarra turta partala waka urrpia arrpunha ntjarranha, Altjirralala rrakangkarrurna yairnakala. Ntjarraranga atha rrangkarranha worlilitjika antja naka, lukaluka marlalala kurrka ekuranha worlilamanga ngerra. Rrangkarra pula antjakunyala naka. ");
INSERT INTO are_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Altjirrala kala temple ekuranha impurlalhitjinantama. ");
INSERT INTO are_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rrangkarra yinganha turta itja wotha aritjina, anmanta rrangkarra angkamalanga, “Nurna erinha tnantjama, erala Ingkartaka rretnyala pitjimanga.” ");
INSERT INTO are_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesuanha temple-anga rratamala kala ntjumantama lhamanga, kurtungurla ekuranha ntjarra ekururna etinyerraka. Etna ekura temple erinha imarnaka, iltha arrpunha ntjarra turta etnala temple-anga kutala italhamanga. ");
INSERT INTO are_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesuanhantama etnakurna angkaka, “Rrangkarra iltha lenha ingkarraka arama, rrangkarrala nuka imarnakala? Atha rrangkarranha nhanha nthurrpa ilama. Leltjala iltha etnanha ungkwaltjilitjina. Parta kngarritja nyintantama itja parta kngarritja arrpunhanga kartninyala intitjina. Ingkarraka arnala intitjina, leltjala errarnpalhelakala.” ");
INSERT INTO are_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesuanha Olive Partala naka. Kurtungurla ekuranha ntjarrantama ekururna pitjika, erinha pmarraka turta, “Nurnanha ilai, ilangarama lakinherritjina? Nthakinha turtama nurna kaltja nitjina unta kala pitjalputjikerramangantama, alha nhanha turta kala yirritjikerramangantama?” ");
INSERT INTO are_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesuala etnanha alpmelaka, “Rrangkarrataka aralhitjika arrpunhala rrangkarranha orrtjapepilakitja. ");
INSERT INTO are_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ntjarra kunha anma pitjimala angkitjina, ‘Jesuala yinganha yairnaka. Yinga nama Krista era.’ Orrtja krista nhanha ntjarralantama relha ntjarranha orrtjapepilitjina. ");
INSERT INTO are_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Anma rrangkarra wumalanga relha arrpunha ntjarra turramanga, relha arrpunha ntjarra turta kula turritjikerramanga, rrangkarra itja trerritjika. Nhanha kunha kala lakinha nitjika. Alha era pula itjantema yirritjina. ");
INSERT INTO are_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pmararinya ntjarra, pmararinya arrpunha ntjarralela turritjina. King nyinta turta, king arrpunhaka irrpaltherritjina. Pmara arrpunhala relha marnaka paalerritjina. Pmara arrpunhala alha era errowutjina. ");
INSERT INTO are_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nhanha lakinherramanga, rrangkarra kaltja nitjika anma relha ingkarrakantama imampurlerritjina. ");
INSERT INTO are_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kurunga arrpunha ntjarrala rrangkarranha errkumala tutjina, errilknga tutjina turta. Relha nuka antjakunya namala ntjarra, etna rrakangkarra turtantama antjakunya erritjina, rrangkarra yinganha tnakamanga. ");
INSERT INTO are_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tjina urrputjala yinganha imputjina. Tjina arrpunhala, tjina nukanha leltjaka lanthitjina. Tjina arrpunha, tjina nukanhaka yirrkngerritjina. ");
INSERT INTO are_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Relha ntjarra arrpunhantama ilalhitjina etna kula Altjirraka urrpia namanga. Etnantama relha ntjarranha orrtjapepilitjina, etnanha paala kaltjinthamala. ");
INSERT INTO are_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Relha ingkarraka kornamakorna ntelalhitjina. Relha ntjarra arrpunha turta itja wotha Altjirraka kangkitjina. ");
INSERT INTO are_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Altjirrala pula rrangkarranha tangkalhelitjina, rrangkarra yinganha talwalpula tnakamanga. ");
INSERT INTO are_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yia Marra nhanga Altjirranhala relha ingkarrakaka Ingkarta namanga, yia nhanharrka kunha rrangkarra relha ingkarrakanha ilitjika, alha panpala. Kurunga relha ingkarrakala nhanha wukalanga, Altjirrala alha nhanha yirralhelitjina.” ");
INSERT INTO are_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Anma rrangkarra aritjina etna orrtja altjirra, Altjirraka temple-aka ingkairnamanga, Altjirranha arrampowutjika. Altjirraka urrpia Daniel-ala imankantema relha ntjarranha lakinha ilaka. (Relha erala pepa nhanhaka read-erramanga era etarlariau.) ");
INSERT INTO are_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kurunga relha pmara Judea-arinya kala parturnanta naamerranhitjika. ");
INSERT INTO are_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Relha erala iltha kaputhala namanga, era turta kala naamerranhitjikanta. Era itja iltha ekuranhurnarrka irrputjika, yulthaka. ");
INSERT INTO are_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Relha erala tnukulpa ekuranhala urrkapumanga, era turta kala naamerranhitjikanta. Era itja iltha ekuranhurnarrka alputjika, mantarra ekuranhaka. ");
INSERT INTO are_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Arai, arrkutja inpora ntjarraka imampurla inthorra nitjina, arrkutja katjia kurrka ipatja ntjunhintjunha ntjarrakartaka turta. ");
INSERT INTO are_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Altjirrurna ingkarrirrai rrangkarra itja lhurrpala naamerritjika, Sabbath arltala paka. ");
INSERT INTO are_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Arai, antala lenhala relha kngarra inthorra nyingalauwutjina. Imanka relha itja lakinha ngerra nyingalauwuka paka. Anma turta relha itja wotha lakinha ngerra nyingalauwutjina. ");
INSERT INTO are_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Altjirranha pula relha ekuranha ntjarrakakwia montjamontja ntelalhitjina. Lakinhanga era itja relha ntjarranha kuta inthorra nakapakarlilitjina, etna ingkarraka ilukitja, kngarra nyingalauwumala. ");
INSERT INTO are_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Arai, relhala paka rrangkarranha ilamanga, ‘Krista era nhanhiai.’ Arrpunhala paka rrangkarranha ilamanga, ‘Itja. Era tanha nama.’ Rrangkarra angkatja etnakanha itja tnakitjika. ");
INSERT INTO are_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Orrtja krista ntjarra, orrtja urrpia ntjarra turta pitjitjina. Etna turta tjatjikarta kngarra urrkaputjina. Etna arrkarnitjina Altjirraka tjina ntjarranha orrtjapepilitjika. ");
INSERT INTO are_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Arai, atha rrangkarranha mparrama ilama, rrangkarra kaltja nitjinanga.” ");
INSERT INTO are_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Etna paka rrangkarranha ilamanga, ‘Arai Kristanha worritjala nama.’ Rrangkarra itja lhitjika. Etna paka angkamanga, ‘Era iltha tanhala nama, lauwulhakala.’ Rrangkarra angkatja etnakanha itja tnakitjika. ");
INSERT INTO are_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwatja paka ekngarrala lharrkamanga, relhala parrtja erinha altorlalalka katha arama. Lakinha ngerra nitjina Relhaka 'Lira pitjalpumalanga. Relha ingkarrakala erinha katha aritjina. ");
INSERT INTO are_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Errowulya paka intamanga, erritja etna kala tanhala worlerritjina. ");
INSERT INTO are_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kurunga relha etna kala lakinha ngerra imampurlerrakalanga, ‘Altjirrala lirnnga erinha ilurnitjina, taiya erinha turta. Era ntheilpura etnanha ngarlpangalhelitjina, etnanha alkiranga tnyilhelitjina turta.’” ");
INSERT INTO are_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Kurunga Relhaka 'Lira era alkirala rumerritjina. Relha ingkarraka inthorrantama kngarra itnitjina. Kurunga relha ingkarrakala aritjina Relhaka 'Lira matarala pitjimanga. Era ekarlta inthorra, makalaria inthorra turta ntelalhitjina. ");
INSERT INTO are_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Erantama angel ekuranha ntjarranha alhurna yairnitjina. Pitjimala etna trumpet etnakanha angkalhelitjina. Etnantama relha ekuranha ntjarranha pmararrpaninhanga worlilitjina.” ");
INSERT INTO are_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Irna tjurrka ekuranga kaltjerrai. Etintja ekura pulyerramanga, ilpalha turta rratamanga, rrangkarra kaltja kala inguntha wara wumpierritjina. ");
INSERT INTO are_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lakinhanga rrangkarra aramalanga angkatja nukanha nthurrperramangantama, rrangkarra kaltja nitjika Relhaka 'Lira era kala pitjalputjikerramanga. ");
INSERT INTO are_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Atha rrangkarranha nthurrpa ilama, angkatja nukanha kala nthurrperritjina, ramarama nhanha namangantema. ");
INSERT INTO are_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Alkira nhanha kala yirritjina. Alha nhanha kala yirritjinantema. Angkatja nuka pula itja kuta yirritjina.” ");
INSERT INTO are_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ilangara inthorrama Relhaka 'Lira era pitjalputjina? Nhanhaka relha nyinta itja kaltja. Angel alkirarinya etna itja kaltja. Relhaka 'Lira era itja kaltja. Kaarta eranta kaltja. ");
INSERT INTO are_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Relhaka 'Lira era pitjalpumalanga, nhanha kala artwa Noah-aka antalala ngerra nitjina. ");
INSERT INTO are_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Roampengkanga arrkurla, relha ntjarrala kunpala ilkurlanaka, ntjulanaka, noa inarralanaka turta. ");
INSERT INTO are_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Artwa Noah-anha ship-aka irrpukalangantantama, kwatjala turta etnanha twentjimangantantama, etna alkngampuka. Lakinha ngerrathoa nitjina Relhaka 'Lira pitjimalanga. ");
INSERT INTO are_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Artwa tharra tnukulpala urrkapurlanitjina. Altjirrala nyintanha initjina, arrpunhanha impurlalhitjina. ");
INSERT INTO are_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Arrkutja tharrala tnyanala annga thalanitjina. Altjirrala nyintanha initjina, arrpunhanha impurlalhitjina. ");
INSERT INTO are_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Lakinhangataka rrangkarra kaarra nitjika, rrangkarra itja kaltjanga warta ilangara inthorra Ingkarta rrakangkarra pitjalputjina. ");
INSERT INTO are_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Etarlarai, ilthakurtwia era paka kaltja nakalanga ilangara inthorra nyilkngampa era pitjitjinala, era ekura kaaralhamara, erinha parritjika. ");
INSERT INTO are_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Rrangkarrantama kaarra nitjika, rrangkarra itja kaltjanga warta ilangara inthorra Relhaka 'Lira era pitjitjina.” ");
INSERT INTO are_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ngunhama urrkapunhapunha ilporatha pa inangkarla era nama, erinhala itornka ekuranhala ingkairnitjinala, urrkapunhapunha arrpunha ntjarranha marna etnakanha arratja kuta nthetnitjika? ");
INSERT INTO are_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Urrkapunhapunha era kunha, erinhala itornka ekuranhala arama arratja urrkapumanga, era pitjalpumalanga. Era ekura kangkitjina. ");
INSERT INTO are_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Era turta erinha ingkairnitjina yultha ingkarraka ekuranha ntarntaritjika. ");
INSERT INTO are_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Thunga pula urrkapunhapunha arrpunha eterrama, ‘Itornka nuka anmanta pitjalputjina.’ ");
INSERT INTO are_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Erantama urrkapunhapunha arrpunha ntjarranha tuma. Era turtantama drunk ntjarralela ilkuma pa ntjuma. ");
INSERT INTO are_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Arlta arrpunhala itornka ekuranha kala pitjalputjina, urrkapunhapunha era eterramanga itornka ekuranha kutantema yirritjinala. ");
INSERT INTO are_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Itornka ekuranhalantama erinha tutjina, erinha naamalhelitjina turta, relha pmatha ntjarralela nitjika. Pmara nhanha ekurala etna ingkarraka itnitjina, itetja turta kakulhitjina.” ");
INSERT INTO are_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesuala etnanha ilaka, “Altjirranha relha ingkarrakaka Ingkarta namanga, kala lakinha ngerra nama. Wonka 10 alknganthakarta lhaka artwa nyintaka kaaralhitjika erala pitjitjika nakala noa initjika. ");
INSERT INTO are_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wonka nhanha etnakanga, 5 eterrintja marntilparla naka, 5 arrpunha pula eterrintja marrakartala naka. ");
INSERT INTO are_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Wonka eterrintja marntilparla ntjarrala alkngantha etnakanhanta kngaka. Etna pula oil arrpunha itjala kngaka. ");
INSERT INTO are_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kanha wonka eterrintja marrakarta ntjarrala oil arrpunha turta kngakantema, alkngantha etnakanhaka. ");
INSERT INTO are_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Artwa erala noa initjika pitjitjika nakala era kuta yirramanga, wonka etna ingkarraka porrkerraka, kala ankwentaka turta. ");
INSERT INTO are_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kala anma ingwa mpopalantama, wonka etna wuka arrpunha ilkamanga, ‘Artwa era kala pitjimantama. Kala ekururna urlarrakurlarra lhai!’ ");
INSERT INTO are_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Wonka etna kaarrerramala kamerraka. Etnantama alkngantha etnakanha wotha parrtja kngarrilaka. ");
INSERT INTO are_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Wonka eterrintja marntilparla ntjarrantama, wonka eterrintja marrakarta ntjarraka enkaka, ‘Ngka. Oil tangilamala nthai, alkngantha nurnakanha ilurnalhitjikerramanga.’ ");
INSERT INTO are_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Wonka eterrintja marrakarta ntjarrala pula etnanha ilaka, ‘Impa. Alkngantha nurnaka turta ilurnalhakitja. Rrangkarratitja lharrirrai oil rrakangkarra buy-emilitjika.’ ");
INSERT INTO are_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Wonka eterrintja marntilparla ntjarra kala lhakantama, oil initjika. Etna pula oil erinha buy-emilamalangantema, artwa era kala itnatjalhakala. Kurunga wonka eterrintja marrakarta ntjarra ekuralela mpanyaka tjinkarrurna irrpunhaka. Arrpunhala ilthaka reoa twantakantama. ");
INSERT INTO are_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kala ingkarnantama wonka eterrintja marntilparla ntjarra pitjika. Reoa iltaratumala, etna ilkaka, ‘Ingkartai, Ingkartai! Nurnaka altjurilai!’ ");
INSERT INTO are_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Era pula etnanha ilaka, ‘Yinga nthurrpa angkama, yingataka rrakangkarra kotna.’” ");
INSERT INTO are_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesualantama etnanha ilaka, “Lakinhanga rrangkarrataka kaaralhitjika, nuka eterramala, rrangkarra kotnanga warta ilangara inthorra yinga pitjalputjina.” ");
INSERT INTO are_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Altjirranha relha ingkarrakaka Ingkarta namanga, kala lakinha ngerra nama. Artwa itornka pmara arrpunhurna lhitjika naka. Erantama artwa urrkapunhapunha ekuranhaka ntangkalhaka. Erantama etnaka yultha ekuranha errarnpalhelaka, ntarntaritjika. ");
INSERT INTO are_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Urrkapunhapunha inangkarla kngarrakartanha era $5,000 ngerra nthalalhaka. Urrkapunhapunha arrpunha inangkarla kngarrakngarrakarta, $2,000 ngerra. Kala urrkapunhapunha arrpunha inangkarla kurrkakarta, $1,000 ngerra. Kurunga itornka era lhaka. ");
INSERT INTO are_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Artwa urrkapunhapunha nhanga, erinhala itornka ekuranhala $5,000 nthalalhakala, era kala urrkapuka money lenhala yultha buy-emilitjika, yultha etnanha wotha money kngarralkuraka yirrinthitjika turta. Lakinha urrkapumala era $5,000 arrpunha patilaka. ");
INSERT INTO are_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Artwa urrkapunhapunha arrpunha nhanga, erinhala itornka ekuranhala $2,000 nthalalhakala, era lakinhantema urrkapuka. Erantama $2,000 arrpunha patilaka. ");
INSERT INTO are_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Artwa urrkapunhapunha arrpunha nhanga pula, erinhala itornka ekuranhala $1,000 nthalalhakala, era iparta tnyamala itornka ekuranhaka money tintjiwumala lauwuka. ");
INSERT INTO are_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kala anma inthorrantama itornka era pitjalpuka. Artwa urrkapunhapunha etnaka ntangkalhamala, era etnanha nyintaminyintanha pmarraka, “Nthakinhama unta money nukanha ntarntaraka?” ");
INSERT INTO are_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Artwa urrkapunhapunha nhanga, erinhala itornka ekuranhala $5,000 ngerra nthalalhakala, era $5,000 arrpunhakarta pitjika. Era angkaka, ‘Itornkai, unta kunha yinganha $5,000 nthalalhaka. Arai, nhanha $5,000 arrpunha atha ungkwanga patilakala.’ ");
INSERT INTO are_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Itornka ekuranhala erinha ilaka, ‘Marra inthorra. Urrkapunhapunhai, unta kunha artwa arratja ilporatha turta nama. Unta yultha kurrka marra ntarntarakalanga, atha nganha arrarnitjina yultha kngarrantama ntarntaritjika. Kala pitjai nukalelantama nitjika, pmara marra nukanhala.’ ");
INSERT INTO are_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Kurunga urrkapunhapunha nhanga, erinhala itornka ekuranhala $2,000 ngerra nthalalhakala, erantama pitjika. Era angkaka, ‘Unta yinganha $2,000 nthalalhaka. Arai, nhanha $2,000 arrpunha atha ungkwanga patilakala.’ ");
INSERT INTO are_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Itornka ekuranhala erinha ilaka, ‘Marra inthorra. Urrkapunhapunhai, unta kunha artwa arratja ilporatha turta nama. Unta yultha kurrka marra ntarntarakalanga, atha nganha arrarnitjina yultha kngarrantama ntarntaritjika. Kala pitjai nukalelantama nitjika, pmara marra nukanhala.’ ");
INSERT INTO are_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kurunga urrkapunhapunha nhanga, erinhala itornka ekuranhala $1,000 nthalalhakala, erantama pitjika. Era angkaka, ‘Itornkai, yinga kaltja naka unta artwa arrthata namanga. Unta marna wheat kotjima, unta annga itja ingkairnakalangatanya. Unta marna arrpunha turta kotjima, unta etnaka itja urrkapukalangatanya. ");
INSERT INTO are_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yingantama ungkwanganga trerraka. Lakinhanga atha money ungkwanganha tintjiwumala lauwuka. Arai, nhanha atha nganha money ungkwanganha wotha nthitjalpuma.’ ");
INSERT INTO are_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Itornka ekuranhala erinha ilaka, ‘Urrkapunhapunhai. Untataka artwa korna, kaningka turta. Unta kaltja naka atha marna wheat kotjimanga, atha annga itja ingkairnakalangatanya. Atha marna arrpunha turta kotjimanga, yinga etnaka itja urrkapukalangatanya. ");
INSERT INTO are_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Untantama money nukanha bank-aka arrarneikanha. Unta paka lakinhilakalanga, pitjalpumala atha money nukanha initjalpumara, patilakala.’ ");
INSERT INTO are_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Itornka erantama arrpunha ntjarranha turnaka, ‘$1,000 lenha ekuranga inai, nhanha turta artwa erinha nthai, erala kala $10,000 tnyinamanga. ");
INSERT INTO are_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Arai, relha arrpunhanha atha yultha kngarra nthama ntarntaritjika. Era paka yultha nhanha arratja ntarntaramanga, atha erinha yultha kngarralkura nthitjina ntarntaritjika. Relha arrpunhanha atha yultha kurrka nthama ntarntaritjika. Era paka yultha kurrka nhanha itja arratja ntarntaramanga, atha yultha kurrka nhanha turta ekuranga wotha inetnitjina. ");
INSERT INTO are_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kalantama rrangkarra urrkapunhapunha korna nhanha erinha kathurna iwai, pmara thapathapurna. Pmara nhanhala relha kngarra itnima, itetja kakulhama turta.’” ");
INSERT INTO are_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Anma Relhaka 'Lira era pitjalputjina angel ekuranha ntjarrakarta. Era turta chair kngarritja ekuranhaka arrarnalhitjina, makalaria inthorra turta ntelalhitjina. ");
INSERT INTO are_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Relha ingkarraka inthorrantama ekururna worlerrentjitjina. Erantama relha etnanha ilkngakitjina, tnairnarintjala sheep ntjarra, goat ntjarranga ilkngakamanga ngerra. ");
INSERT INTO are_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Erantama sheep etnanha ekuranga akwampinyaka arrarnitjina, kanha goat etnanha kwanginyakala. ");
INSERT INTO are_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Kurunga King era relha akwampinyala namala ntjarranha ilitjina, ‘Kaarta nuka rrakangkarra kngarra kangkama. Imanka, era alha nhanha arrpmarnamalanga, era rrakangkarra pmara alkirala arrpmarnakantema. Kalantama rrangkarra pmara erinha inarrirrai. ");
INSERT INTO are_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Rrangkarra yinganha ntuthilakalanga warta, yinga ngaiyala namalanga. Rrangkarra yinganha kwatja ntjutjika nthakalanga warta, yinga angkathala namalanga. Rrangkarra yinganha pmarurna ntangkakalanga warta, yinga epinya pitjimalanga. ");
INSERT INTO are_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Rrangkarra yinganha mantarra nthakalanga warta, yinga ilkngara namalanga. Rrangkarra nuka montjamontja ntelalhakalanga warta, yinga menta intamalanga. Rrangkarra nukurna yatjarra pitjikalanga warta, yinga jail-ala namalanga. ");
INSERT INTO are_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Kurunga relha arratja etna erinha alpmelitjina, ‘Ingkartai, nurna nganha itjama ngaiyala araka, ntuthilaka paka. Nurna itjama nganha angkathala araka, kwatja nthaka paka. ");
INSERT INTO are_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nurna itjama nganha epinya pitjimanga araka, nganha pmarurna ntangkaka paka. Nurna itjama nganha ilkngara araka, nganha mantarra nthaka paka. Nurna itjama nganha menta araka, ungkwanga montjamontja ntelalhaka paka. ");
INSERT INTO are_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nurna itjama nganha jail-ala araka, ungkwangurna yatjarra lhaka paka.’ ");
INSERT INTO are_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“King era pula etnanha ilitjina, ‘Atha rrangkarranha nhanha nthurrpa ilama. Rrangkarra kala nuka kangkintja ntelalhaka, rrangkarra nhanga tjia kornakorna nukanha ntjarraka kangkintja ntelalhamalanga.’ ");
INSERT INTO are_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kurunga era relha kwanginyala namala ntjarranhantama ilitjina, ‘Altjirrala kunha rrangkarranha imilaka. Kalantama rrangkarra nukanga lhalathanai ura ngampakalurna, ura nhangurna Altjirralala arrkurlantema urrkapukala errintjaka, errintjaka angel ntjarraka turta. ");
INSERT INTO are_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Rrangkarra yinganha itja ntuthilakalanga warta, yinga ngaiyala namalanga. Rrangkarra yinganha itja kwatja ntjutjika nthakalanga warta, yinga angkathala namalanga. ");
INSERT INTO are_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Rrangkarra yinganha itja pmarurna ntangkakalanga warta, yinga epinya pitjimalanga. Rrangkarra yinganha mantarra itja nthakalanga warta, yinga ilkngara namalanga. Rrangkarra nuka itja montjamontja ntelalhakalanga warta, yinga menta intamalanga. Rrangkarra nukurna itja yatjarra pitjikalanga warta, yinga jail-ala namalanga.’ ");
INSERT INTO are_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kurunga etna turta angkitjinantema, ‘Ingkartai, nurna itjama nganha ngaiyala paka araka, angkathala paka, epinya paka, ilkngara paka, menta paka, jail-ala paka. Nurna paka nganha arakalanga, nurna kala ungkwanga montjamontja ntelalhamara.’ ");
INSERT INTO are_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Era pula etnanha ilitjina, ‘Atha rrangkarranha nthurrpa ilama. Rrangkarra nuka itja kangkintja ntelalhaka, rrangkarra nhanga tjia kornakorna nukanha ntjarraka itja kangkintja ntelalhakalanga.’ ");
INSERT INTO are_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kurunga era relha kwanginyala itnamala ntjarranha unputjina. Etnantama ngampakala nyingalauwutjina. Kanha relha arratja ntjarra ngampakala etatha nitjina.” ");
INSERT INTO are_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kurtungurla ekuranha ntjarranha kaltjinthamaliperra, Jesuala etnanha ilaka. ");
INSERT INTO are_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Rrangkarra kalakwia kaltja, arlta tharriperra nurna Passover tjinkarra erinha ilkutjina. Arlta lenha ekuralantama etna Relhaka 'Lira erinha nthalenitjina arrpunha ntjarrala erinha ntolkaka kanthatutjika.” ");
INSERT INTO are_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kurunga Priest-aka itornka ntjarra, kngarripata itornka ntjarra turta High Priest Caiaphas-aka ilthala worlerraka. ");
INSERT INTO are_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Etna antja naka Jesuanha nyilknganyilkngala errkumala errilknga tutjika. ");
INSERT INTO are_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Relha ntjarra kunha Jesuaka kngarra kangkaka. Lakinhanga Priest-aka itornka ntjarra ilarraka, “Nurna erinha itja Passover-aka arltala errkutjika, relha ingkarraka kekarta lhakitja.” ");
INSERT INTO are_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pmara Bethany-ala artwa nyinta naka, rretnya ekura Simon. Era leprosy-akarta nakala. Jesuanha iltha ekuranhala naka, marna ilkurlanamala. ");
INSERT INTO are_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Arrkutja nyinta irrpentjika bottle kurrka ntira unpa marra inthorrakarta. Ntira unpa marra inthorra lakinha ngerra relhala money kngarralanta buy-emilitjata. Arrkutja erantama ntira unpa marra inthorra erinha Jesuaka kapurtaka thalaka. ");
INSERT INTO are_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nhanha aramala, Jesuaka kurtungurla ntjarra arrkutja ekura unpaarterraka. Etna ilarraka, “Iwunhangala era ntira unpa marra nhanha palkala thalaka? ");
INSERT INTO are_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ntira unpa marra inthorra nhanha kunha money kngarraka yirrinthamara, money erinha turtantama relha ilkngara ntjarranha nthamara.” ");
INSERT INTO are_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesuanha kaltja naka etna lakinha angkamanga. Erantama etnanha pmarraka, “Iwunhangala rrangkarra ekura unpaarterrama? Erataka nuka kangkintja kngarra ntelalhaka. ");
INSERT INTO are_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Relha ilkngara kunha kutatha rrakangkarralela nitjina. Yinga pula itjala rrakangkarralela kuta nitjina. ");
INSERT INTO are_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Arrkutja erataka mpurrka nukanha mparrama ntirala parnaka. Inguntha wara etna yinganha tintjiwutjina. ");
INSERT INTO are_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Atha rrangkarranha nthurrpa ilama. Pmara nthanhala paka etna relha ntjarranha Yia Marra erinha anma kaltjinthitjina, etna yia nhanha turta ilitjinantema, arrkutja ekura ilpangkamala.” ");
INSERT INTO are_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kurunga kurtungurla 12 etnakanga nyinta, rretnya ekura Judas Iscariot, era priest-aka itornka ntjarrurna lhaka. ");
INSERT INTO are_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Era etnanha pmarraka, “Atha paka Jesuanha rrakangkarra lanthamanga, money nthakintjama rrangkarra yinganha nthitjina?” Ekuralela angkarramaliperra, etna erinha 30 ungkwaltja silver nthaka. ");
INSERT INTO are_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Judas-anha kala nhanhakantantama kngarra inthorra eterraka, “Nthakinhama atha Jesuanha etnaka lanthamara?” ");
INSERT INTO are_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Marna Ekalhaka ilpangkintjaka arlta arrkurlinyala, Jesuaka kurtungurla ntjarra ekururna pitjimala, erinha pmarraka, “Nthanhalama unta antja nama nurna Passover tjinkarra erinha ungkwanga urrkaputjika, unta erinha ilkutjinanga?” ");
INSERT INTO are_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Era etnanha ilaka, “Town-urna lharrirrai, artwa nhangurna. Rrangkarrantama erinha ilai, ‘Kaltjinthanhinthanha era angkama, nukathaka kala nama iltha ungkwanganhala Passover tjinkarra erinha ilkutjika, kurtungurla nukanha ntjarralela.’” ");
INSERT INTO are_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kurtungurla etna lhaka, Passover tjinkarra erinha urrkapuka turta, Jesuala etnanha turnakala ngerra. ");
INSERT INTO are_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kala ngurrangurrantama, Jesuanha 12 etnakalela worlerraka, etnakalela arrarnalhaka turta marna ilkutjika. ");
INSERT INTO are_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Etna kala marna ilkumalangantama, Jesuala etnanha ilaka, “Atha rrangkarranha nhanha nthurrpa ilama. Rrakangkarranga nyintalataka yinganha lyarta leltjaka lanthitjina.” ");
INSERT INTO are_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nhanha wumala etna ingkarraka ltarrpa kngarrerraka. Nyintaminyintalantama erinha pmarraka, “Ingkartai, yinganhama unta ilama?” ");
INSERT INTO are_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesuala etnanha ilaka, “Artwa erala nukalela dish nhanhanga marna ilkumanga, era yinganha leltjaka lanthitjina. ");
INSERT INTO are_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Relhaka 'Lirakathaka nama ilutjika, Altjirraka Angkatja Imankinyala ilamala ngerra. Artwa erala Relhaka 'Lira erinha leltjaka lanthamanga, ekura pula imampurla kngarra inthorra nitjina. Ekura marralkura namara era itja kuta alkngerrakalanga paka.” ");
INSERT INTO are_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kurunga Judas, erala erinha leltjaka lanthitjinala, erantama erinha pmarraka, “Kaltjinthanhinthanhai, yinganhama unta ilama?” Jesuanha ekururna angkaka, “Kala untanta kuta.” ");
INSERT INTO are_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Etna marna ilkumalanga, Jesuala marna inaka, Altjirranha dangkilaka turta. Kurunga era marna erinha urltakamala kurtungurla ntjarranha nthaka lakinha angkamala, “Inarrirrai, ilkurrirrai. Nhanha mpurrka nuka nama.” ");
INSERT INTO are_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kurunga era cup wine-akartantama inaka. Altjirranha dangkilamala era etnanha cup erinha nthaka. Era etnanha ilaka, “Rrangkarra ingkarrakala nhanhiperra ntjurrirrai. ");
INSERT INTO are_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nhanha alhwa nuka nama. Nhanha atha thalitjina ntjarranha Altjirraka tjinilitjika, korna etnaka iwutjika turta. ");
INSERT INTO are_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Atha rrangkarranha nhanha turta ilama. Lyartanga atha itja wotha wine rrakangkarralela ntjutjina. Anmanta Kaarta nukanha relha ingkarrakaka Ingkarta ntelalhamanga, atha wine arrpunhantama rrakangkarralela ntjutjina.” ");
INSERT INTO are_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kurunga nyintaranga lyilhamala, etna rratamala Olive Parturna lhaka. ");
INSERT INTO are_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesualantama kurtungurla ekuranha ntjarranha ilaka, “Ingula lyarta rrangkarra ingkarraka nukanga mpakalhitjina. Altjirraka Angkatja Imankinyala nhanga ilama, ‘Atha tnairnarintja erinha tutjina, kurunga sheep worla etna errarnperritjina.’ ");
INSERT INTO are_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Altjirrala pula yinganha errilknga ntjarranga wotha kamalhelakalanga, yinga rrakangkarranga arrkurla lhitjina pmara Galilee-urna.” ");
INSERT INTO are_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter-anha pula angkaka, “Etna ingkarraka inthorra paka ungkwanganga mpakalhamanga, ungkwanga antjakunyerramala, yinga pula itja kutala ungkwanganga mpakalhitjina.” ");
INSERT INTO are_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesuala pula erinha ilaka, “Atha nganha nthurrpa ilama. Ingula lyarta, lukaluka orrea era ilkitjikanhangantema, unta yinganha kala tharraminyintaranga yiparrarnitjina.” ");
INSERT INTO are_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter-anha pula angkaka, “Arrpunha ntjarra turta paka antjerramanga yinganha errilknga tutjika, ungkwanganga arrkngala, yinga itja kuta ungkwanganga mpakalhitjina.” Kurtungurla arrpunha ntjarra turta lakinhantema ekarlterramala angkaka. ");
INSERT INTO are_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesuanhantama katha nhangurna lhaka, kurtungurla ekuranha ntjarrakarta. Katha ekura rretnya naka Gethsemane. Erantama etnanha ilaka, “Nhanhala narrirrai, yinga tanharrka lhamanga Altjirrurna ingkitjika.” ");
INSERT INTO are_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kurunga era Peter-anha, Zebedee-aka 'lira tharranha turta ntangkamala, etnakakarta kurrka urntwarra lhaka. Erantama ltarrpa inthorra mpangkaka. ");
INSERT INTO are_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Era etnanha ilaka, “Yingataka ltarrpa inthorra wulhama, ingkwa ilutjikerrama turta. Nhanhala nukalela ilkwatharra kaaralhai, kaarra turta narrirrai.” ");
INSERT INTO are_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kurrka urntwarrantama lhamala, Jesuanha urlparra iwulhaka. Erantama Altjirrurna ingkaka, “Kaarta nukai, yinga itja antja nama nyingalauwutjika, ilutjika turta. Unta pula antja namanga yinga nyingalauwutjika, ilutjika turta, yinga kala ungkwanga kangkwerramala.” ");
INSERT INTO are_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kurtungurla etnakurna pitjalpumala, era etnanha ankwentamanga aritjalhaka. Erantama Peter-anha pmarraka, “Rrangkarra yarnala kurrka wara nukalela ilkwatharra kaarra nama? ");
INSERT INTO are_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Rrangkarrataka kaarra nitjika, Altjirrurna ingkitjika turta, errintja era rrakangkarra irrpaltherramanga warta. Arai, enka rrakangkarra nthurrpa Altjirraka kangkwerritjika antja nama, kanha lherrintja korna kuta namantemala.” ");
INSERT INTO are_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Erantama wotha lhaka, Altjirrurna ingkitjika. “Kaarta nukai,” era ingkaka, “unta paka antja namanga yinga nyingalauwutjika, ilutjika turta, yinga kala ungkwanga kangkwerrama.” ");
INSERT INTO are_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kurtungurla etnakurna pitjalpumala, era etnanha ankwentamanga aritjalhaka. Etnataka porrka inthorra naka. ");
INSERT INTO are_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Etnanha impurlalhamala, era wotha lhaka Altjirrurna ingkitjika. Nhanha era kala tharraminyintarangantama lhaka. ");
INSERT INTO are_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kurunga kurtungurla ekuranha ntjarrurna pitjalpumala, era angkaka, “Yakai, rrangkarra kutantema ankwentama, iltjerrama turta? Arai, antala era kala namantama, arrpunhala Relhaka 'Lira erinha leltjaka lanthitjika. ");
INSERT INTO are_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mpa, kala kamerrai. Artwa erala yinganha leltjaka lanthitjinala, erataka kala pitjikantama.” ");
INSERT INTO are_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesuanha kurtungurla ekuranha ntjarrurna angkamalangantema, Judas-anha, kurtungurla 12 etnakanga nyinta, era worla kngarrakarta pitjika. Artwa worla nhanhataka priest-aka itornka ntjarrala, kngarripata itornka ntjarrala turta Judas-alela yairnakala, Jesuanha errkutjika. Worla etnantama Jesuaka pitjika knife tjenyakarta, tnamakarta turta. ");
INSERT INTO are_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas-ala artwa nhanha etnanha arrkurlantema ilakala, “Arai, artwa erinhala atha rrontjitjina, erinha errkwai.” ");
INSERT INTO are_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas-anha Jesuurna arratja kuta lhaka. “Kaltjinthanhinthanhai,” era erinha anparnaka. Kurunga era erinha rrontjaka. ");
INSERT INTO are_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesualantama Judas-anha pmarraka, “Tjinai, iwukama unta pitjika?” Kurunga artwa arrpunha ntjarra etinyerramala Jesuanha errkuka. ");
INSERT INTO are_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nhanha aramala, artwa arrpunha erala Jesualela nakala, era knife tjenya ekuranhala High Priest-aka urrkapunhapunhaka ilpa inturnaka. ");
INSERT INTO are_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesuala pula erinha ilaka, “Knife tjenya ungkwanganha impai. Relha erala knife tjenyakarta turrama, etna erinha knife tjenyalantema errilknga tutjina. ");
INSERT INTO are_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Unta etarlareikanha, yinga paka Kaarta nukanhaka enkamanga, era kala angel ntjarra inthorra yairnamara yinganha ntarntaritjika. ");
INSERT INTO are_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yinga pula ekururna itja enkama, Altjirraka Angkatja Imankinya era nthurrperritjinanga.” ");
INSERT INTO are_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kurunga Jesuanha worla etnakurnantama angkaka, “Artwa nyilkngampa tunhatunhaka ngerrama rrangkarra knife tjenyakarta, tnamakarta turta nuka pitjika? Atha pula rrangkarranha arltamarlta temple-ala kaltjinthaka. Rrangkarra yinganha itja errkuka. ");
INSERT INTO are_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lyarta pula rrangkarra yinganha errkuka, Altjirraka Angkatja Imankinya nthurrperritjinanga.” Kurunga Jesuaka kurtungurla ntjarrala erinha impurlalhaka, tira turta arrtjanaka. ");
INSERT INTO are_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Artwa Intarrangaltha ntjarra, kngarripata itornka ntjarra turta Caiaphas-aka ilthala worlerraka. Caiaphas erataka High Priest naka. Artwa lenha ntjarra, etnala Jesuanha errkukala, etna erinha Caiaphas-urnantama rretjingaka. ");
INSERT INTO are_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peter-ala etnanha ingkarnangala lurnaka. Etnantama High Priest-aka ilthurna irrpunhamanga, Peter-anha High Priest-aka yard-urnala irrpunhaka. Erantama High Priest-aka urrkapunhapunha ntjarralela arrarnalhaka, eterramala, “Nthakinhama erritjina?” ");
INSERT INTO are_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Priest-aka itornka ntjarra, relha Jew ingkarrakaka council kngarra era turta antja naka Jesuanha imilitjika. Council nhanha etnanha, etna Sanhedrin ilitjata. Etnantama artwaka yonthalhaka, Jesuanha ilparnitjika. ");
INSERT INTO are_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Artwa orrtjaltha ntjarrantama kamerramala angkaka. Etna pula erinha yarna kuta ilparnaka. Kurunga ingkarna inthorrantama artwa tharra arrpunha kamerramala ");
INSERT INTO are_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","angkaka, “Artwa nhanhala ilaka, ‘Atha Altjirraka temple irrpalthala urltakama, arlta tharraminyintiperra wotha itama turta.’” ");
INSERT INTO are_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","High Priest erantama kamerramala Jesuanha pmarraka, “Unta itjala angkama artwa nhanha ntjarrala nganha ilparnamanga?” ");
INSERT INTO are_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesuanha pula tjukunya kuta itnaka. Kurunga High Priest-ala erinha lakinhantama pmarraka, “Altjirra Etatha era nganha aramalanga, wumalanga turta, nurnanha arratja inthorra ilai. Unta Altjirraka 'Lira, Krista era namama?” ");
INSERT INTO are_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesuala erinha ilaka, “Untarrpa kala ilaka. Nhanhantama atha rrangkarranha ilama. Anmantama rrangkarra Relhaka 'Lira erinha aritjina Altjirra Ekarlta inthorraka akwampinyala namanga. Rrangkarra erinha aritjina turta matarala alhurna pitjalpumanga.” ");
INSERT INTO are_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nhanha wumala High Priest-ala mantarra ekuranha tjepakamala etnanha ilaka, “Era Altjirranha arrampowuka. Iwunhangantama nurna artwaka kuta yonthitjika, erinha ilparnitjika? Rrangkarrarrpa wuka era Altjirranha arrampowumanga. ");
INSERT INTO are_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nthakinhantama rrangkarra etarlarama?” Etna angkaka, “Era kala ilutjikanta.” ");
INSERT INTO are_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kurunga arrpunha ntjarrala anngerra ekuranhaka palhiwuka, arrpunha ntjarrala erinha tuka turta. Kala urrputja arrpunhala erinha ilkaiya tumala ");
INSERT INTO are_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","pmarraka, “Kristai, nurnanha ilakwia, ngunhalama nganha tuka?” ");
INSERT INTO are_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peter-anha nhanga High Priest-aka yard-ala narlanaka. High Priest-aka marla urrkapunhapunha nyintantama ekururna pitjika. Era angkaka, “Unta kunha Jesua Galilee-arinyalela nakantema?” ");
INSERT INTO are_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Era pula etnaka ingkarrakanga urlarra yiparrarnalhaka, “Yukwa, yinga pula artwa ekura kotnala.” ");
INSERT INTO are_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Peter-anha tjanalhakantama reowurna etinyerramala. Marla urrkapunhapunha arrpunhalantama erinha araka. Erantama artwa Peter-anga kutala itnamala ntjarranha ilaka, “Era kunha Jesua Nazareth-arinyalela nakantema.” ");
INSERT INTO are_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peter-anha pula wotha yiparrarnalhaka, “Altjirrala arama. Yingataka artwa ekura itja kaltja.” ");
INSERT INTO are_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kala kurrka anmantama, artwa urrputja arrpunha Peter-urna etinyerramala erinha ilaka, “Awa, unta kunha nthurrpa worla ekuranhala nakantema. Nurna kaltja, unta artwa Galilee-arinya ngerra angkamanga warta.” ");
INSERT INTO are_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Peter-ala pula etnanha ilaka, “Altjirrala arama yinga nthurrpa inthorra angkamanga. Yinga paka orrtjerramanga, Altjirrala yinganha errilknga tweikanha. Yingataka artwa lenhaka kotnanta kuta.” Peter-anha angkamangantema, lukaluka orreantama ilkaka. ");
INSERT INTO are_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kurunga Peter-anha Jesuaka angkatjaka ilpangkaka, “Lukaluka orrea era angkitjikanhangantema, unta yinganha kala tharraminyintaranga yiparrarnitjina.” Peter-anhantama yard-anga rratamala kngarra inthorra itnika. ");
INSERT INTO are_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kala ingutnhalantama priest-aka itornka ntjarra, kngarripata itornka ntjarra turta angkarraka Jesuanha kala errilknganta tutjika. ");
INSERT INTO are_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Etnantama Jesuaka iltja yirnamala, erinha Pilate-urna rretjingaka, Roman tjitjarta kngarra ekururna. Etna erinha Pilate-aka lanthaka turta. ");
INSERT INTO are_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kurunga Judas, erala Jesuanha leltjaka lanthakala, era aramalanga priest-aka itornka ntjarrala, kngarripata itornka ntjarrala turta Jesuanha imilakala, era porerraka. Erantama etnakurna lhaka. Era antja naka ungkwaltja silver 30 nhanga etnanha nthitjalputjika. ");
INSERT INTO are_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Erantama etnanha ilaka, “Arai athataka relha palkinyanha rrakangkarra lanthakala.” Etna pula angkaka, “Lanha itjama nurnakalka. Nhanha ungkwangathaka nama.” ");
INSERT INTO are_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kurunga etnakanga rratamala Judas-ala money erinha temple kwanaka iwuka. Rope inamala, era rope erinha antja ekuranhaka yirnaka. Kurunga rope erinha irnaka yirnamala, era errilknga tulhaka. ");
INSERT INTO are_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Priest-aka itornka ntjarralantama money erinha temple-anga kotjika. Etna angkaka, “Nhanha itja arratja namara money nhanha Altjirraka tjauwerrilya money arrpunhaka lhangitjika. Nurnataka money nhanha artwa nyintanha nthakala artwa arrpunhanha imilitjika.” ");
INSERT INTO are_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Angkarramaliperra etna paddock-ntama buy-emilaka, Relha Lorinya ntjarranha tintjiwutjika. Paddock nhanha ekuranga etna imanka urrknga tnyatjata, kwatjakanha jar-alka mpaaritjika. ");
INSERT INTO are_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Money lenhanga arrkngala pula etna paddock lenha erinha lyartalpula “Alhwaka Paddock” ilama. ");
INSERT INTO are_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lakinhantama nthurrperraka angkatja arrpunha Altjirraka urrpia Jeremiah-ala imanka ilakala, “Etna ungkwaltja silver 30 erinha inaka, money nhanga etnala Israel-aka 'lira nyintaka nthakala. ");
INSERT INTO are_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kurunga etna money lenhala arna urrkngaka urrkapunhapunhaka paddock buy-emilaka, Ingkartala yinganha turnakala ngerra.” ");
INSERT INTO are_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesuanha Pilate-anga urlarra itnaka. Pilate-ala erinha pmarraka, “Nthurrpama unta relha Jew ntjarraka king?” Jesuala erinha ilaka, “Lakinha unta angkama.” ");
INSERT INTO are_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kurunga priest-aka itornka ntjarrala, kngarripata itornka ntjarrala turta Jesuanha ilparnaka. Jesuala pula etnanha tjukunya kuta wurlanaka. ");
INSERT INTO are_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilate-alantama Jesuanha pmarraka, “Unta tjukunya kuta wurlanama etna nganha ilparnamanga?” ");
INSERT INTO are_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesuanha pula pmarna kuta itnarlanaka. Nhanha aramala Pilate-anha kngarra tnolkaka. ");
INSERT INTO are_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tjitjarta kngarra ekura mpaarangaranga naka, Passover-aka arltala artwa jail-arinya nyintanha rratalhelitjika, ekurala relha ntjarra antja namanga. ");
INSERT INTO are_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Artwa tunhatunha nyinta, Barabbas-anha, jail-ala naka. Relha ingkarraka ekura kaltja naka. ");
INSERT INTO are_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Relha ingkarraka kala worlantama namanga, Pilate-ala etnanha pmarraka, “Ngunhakama rrangkarra antja? Rrangkarra antja atha Barabbas-anha jail-anga rratalhelitjika? Jesuanha paka althakalthilitjika?” ");
INSERT INTO are_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilate-anha kaltja naka etna Jesuanha ekura lanthakala, etna ekura antjakunya namanga. Itja Jesuanha paala ntelalhakalanga. ");
INSERT INTO are_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilate-ala Jesuanha tjiperrawumalanga, noa ekuranhala ekururna angkatja yairnaka, “Artwa palkinya lenha imilitjala. Yinga ekuriperra kngarra inthorra mpangkakalanga, altjirraramala.” ");
INSERT INTO are_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Priest itornka etna pula, kngarripata itornka etna turta, etna relha worla etnanha turnaka Pilate-anha ilitjika era Barabbas-anha jail-anga rratalhelitjika. Jesuanha pula era errilkngala tutjika. ");
INSERT INTO are_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilate-alantama relha worla etnanha wotha pmarraka, “Artwa ngunhakama rrangkarra antja?” Etna angkaka, “Barabbas-akakwia.” ");
INSERT INTO are_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate-alantama etnanha pmarraka, “Kanha Jesuanhaloa, erinhala rrangkarra Krista alpmelama? Erinha atha nthakinhilitjikala?” Etna erinha ilkaka, “Erinha kala ntolkakanta kanthatwai.” ");
INSERT INTO are_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilate-ala pula etnanha kuta pmarraka, “Iwunhakakwia? Era itjama paala ntelalhaka paka.” Etna pula intarralkura ilkaka, “Erinha kala ntolkakanta kanthatwai.” ");
INSERT INTO are_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilate-ala lhangkarakantama relha etna rirterrakala, ingkwa turritjerramanga turta. Erantama kwatjaka ntangkalhamala, etnakanga urlarra iltja ilkngilhaka. Era etnanha ilaka, “Yinga itja ilkarrtja nitjina artwa nhanha lyarta ntolkala ilumanga. Nhanha rrakangkarrathaka nitjina.” ");
INSERT INTO are_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Relha ingkarraka pula angkaka, “Nurna kala ilkaartja nitjina, katjia nurnakanha turta.” ");
INSERT INTO are_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilate-alantama Barabbas-anha jail-anga rratalhelaka. Era turta tjapartia ntjarranha turnaka Jesuanha whip-ala tumaliperra, ntolkaka kanthatutjika. ");
INSERT INTO are_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kurunga tjapartia ntjarrala Jesuanha iltha kwanurna kngaka. Etna tjapartia arrpunha ntjarranha turta ntangkaka. ");
INSERT INTO are_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mantarra tjenya ekuranha ilumala, etna mantarra thathakantama ekura ekarraka. ");
INSERT INTO are_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kurunga etna kaarntakaarnta ilakwiperra mpaaramala, nhanha kapurta ekuranhaka arrarnaka. Etna wilpawilpa turtantama erinha nthaka iltja akwala errkutjika. Kurunga mparalela arrarnalhamala etna erinha arrampowumala ilaka, “Wortai, Jew ntjarraka king-ai.” ");
INSERT INTO are_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Lakinha angkamala etna ekura palha iwuka, etna wilpawilpa nhanga turta iltja ekuranhanga rakamala, erinha kapurta tuka. ");
INSERT INTO are_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Etna erinha kala arrampowukalangantama, etna mantarra nhanga wotha iluka, mantarra ekuranha turta wotha ekura ekarraka. Kurunga etna erinha kathurna rretjingaka, erinha kala ntolkaka kanthatutjinala. ");
INSERT INTO are_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lhapalhamala, tjapartia etna artwa pmara Cyrene-arinya araka, rretnya Simon. Etnantama erinha turnaka Jesuaka ntolka kngitjika. ");
INSERT INTO are_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Etnantama pmara Golgotha-urna pitjika. Nhanhatitja ‘Kaalkngaka Pmarurna.’ ");
INSERT INTO are_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Etnantama Jesuanha wine tjalangka ntjutjika nthaka. Jesuala pula nhanha arrkarnamala, impuka. ");
INSERT INTO are_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tjapartia etnantama Jesuanha ntolkaka kanthatuka. Kurunga etna mantarra ekuranha errarnpalhelaka, gamble-erramala. ");
INSERT INTO are_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Etnantama arrarnalhaka erinha kaaritjika. ");
INSERT INTO are_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Etna angkatja nhanha turta pepaka intalhelaka. “Nhanha kunha Jesua, relha Jew ntjarraka King.” Kurunga etna pepa nhanha ntolkaka kanthatuka, Jesuanga kartninyaka. ");
INSERT INTO are_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tjapartia etna artwa korna tharra turta ntolkaka kanthatukantema. Nyinta Jesuaka akwampinyaka, arrpunha ekuranga kwanginyaka. ");
INSERT INTO are_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Relha anpara lhamala ntjarra, etna Jesuanha kngarra arrampowuka. Kapurta ngalhamala, ");
INSERT INTO are_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","etna erinha ilaka, “Untama Altjirraka temple urltakitjika nakala, erinha arlta tharraminyintala wotha ititjika nakala turta. Unta paka nthurrpa Altjirraka 'Lira namanga, ntolkanga tnanpai, tangkalhelalhamala.” ");
INSERT INTO are_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Lakinha ngerra priest-aka itornka ntjarrala, artwa Intarrangaltha ntjarrala, kngarripata itornka ntjarrala turta erinha arrampowuka. ");
INSERT INTO are_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Etna angkaka, “Era arrpunha ntjarranha tangkalhelaka, erarrpa pula yarnala tangkalhelalhama. Era paka nthurrpa Israel-aka king namanga, era ntolkanga tnanpeikanha, nurna erinha tnakitjinanga. ");
INSERT INTO are_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Era Altjirranha tnakama. Era turta ilalhaka era kula Altjirraka 'Lira namanga. Altjirranha paka ekura kangkamanga, era erinha tangkalheleikanha.” ");
INSERT INTO are_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Artwa korna nhanga tharra, eratharrala ntolkala ilparanamangantema, eratharra turta Jesuanha arrampowukantema. ");
INSERT INTO are_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kala ngkinyalantama, alkira era thapathaperraka. Pmara ntjapara turta thapathapa naka 3 o'clock-akurtitja. ");
INSERT INTO are_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jesuanhantama ilkarlalhaka, “Eli, Eli, lama sabachthani?” nhanhatitja, “Altjirra nukai, Altjirra nukai, iwunhangama unta yinganha ipmintja impuka?” ");
INSERT INTO are_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Relha urrputja arrpunha, etnala ntolkanga kuta itnarlanaka, etna Jesuanha ilkamanga wuka. Etnantama angkaka, “Arai, artwa nhanhataka Elijah-aka ntangkalhama.” ");
INSERT INTO are_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Artwa arrpunhantama parrpa irna alkumpaka arrtjanaka, nhanha wine tjalangkaka turta thankuka. Kurunga alkumpa erinha irna tjenyaka arrarnamala, era nhanha Jesuaka imarnaka, ntjutjika. ");
INSERT INTO are_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Arrpunha ntjarra pula angkaka, “Impai, nurna aritjinanga Elijah-anha paka nthurrpa pitjitjina erinha tangkalhelitjika.” ");
INSERT INTO are_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesuanhantama nyintaranga wotha ilkarlalhaka. Kurunga era kala ilukantama. ");
INSERT INTO are_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesuanha warta iluka, kanha mantarra kngarritja nhanga, erala temple kwanala ilparanakala, era kartninyangatjina kwaninyakurtitja tjepakalhalalhaka. Alha era errowuka. Parta kngarritja ntjarra tjepakalhaka. ");
INSERT INTO are_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Wolknga ntjarra altjurerraka, relha arratja ntjarra turtantama etatherraka. ");
INSERT INTO are_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Anma Jesuanha turtantama errilknga ntjarranga kamerrakalanga, etna wolknganga rratamala Jerusalem-urna lhaka. Ntjarralantama etnanha town-aka araka. ");
INSERT INTO are_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Rome-arinya tjapartia ntjarrala, itornka etnakanhala turta nhanha ingkarraka araka. Etna turta wulhaka alha era errowumanga. Trerramala etna angkaka, “Nhanhataka nthurrpa Altjirraka 'Lira naka.” ");
INSERT INTO are_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Arrkutja ntjarrala turta nhanha ingkarraka ararlanaka, tjathanga. Arrkutja nhanha etnataka Galilee-angatjina Jesuanga tnaartangala pitjikala, Jesuaka tangitjala namala. ");
INSERT INTO are_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Arrkutja nhanha etnakanga arrpunha naka Mary Magdalene, Mary nhanga James, Joseph tharraka mia, Zebedee-aka worra tharraka mia turta. ");
INSERT INTO are_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kala ngurrangurrerrakalangantama, artwa netaneta pmara Arimathea-arinya, rretnya ekura Joseph, era Jerusalem-urna pitjika. Era Jesuaka kurtungurla nakantema. ");
INSERT INTO are_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Erantama Pilate-urna lhaka, Jesuaka mpurrkaka enkitjika. Pilate-alantama tjapartia ekuranha ntjarranha turnaka etna Joseph-anha Jesuaka mpurrka nthitjika. ");
INSERT INTO are_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mpurrka erinha inamala, Joseph-ala mpurrka erinha mantarra tjulkura marra inthorrala ilinyiwuka. ");
INSERT INTO are_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Erantama mpurrka erinha wolknga intia ekuranhaka arrarnaka. Wolknga intia nhanhataka Joseph-aka urrkapunhapunhala ngurruka wara tnyakala, relha errilknga arrpunha turta itja arrkurla wolknga ekurala intakala paka. Kurunga era wolknga erinha marntilaka, parta kngarritja reoaka arrarnamala. Joseph era alpukantama. ");
INSERT INTO are_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalene, Mary arrpunha nhanga turta wolkngurnathaka narlanaka. ");
INSERT INTO are_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sabbath arltalantama, priest-aka itornka ntjarra, artwa Pharisee ntjarra turta Pilate-urna lhaka. ");
INSERT INTO are_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Etna erinha ilaka, “Tjitjartai, nurnataka ilpangkaka artwa orrtjaltha nhanga etathantema namalanga, era lakinha angkakala, ‘Arlta tharraminyintiperra yinga wotha etatha kamerritjina.’ ");
INSERT INTO are_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Lakinhanga unta tjapartia ungkwanganha ntjarranha turnai wolknga erinha ingunthakurtitja ntarntaritjika, kurtungurla ekuranha ntjarra pitjakitja, mpurrka ekuranha nyilkngala inakitja turta. Kurunga etna relha ntjarranha ilakitja era kula errilknga ntjarranga kamerrakala. Etna paka lakinha angkamanga, etna kngarralkura orrtjerritjina arrkurlangatjina.” ");
INSERT INTO are_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate-ala etnanha ilaka, “Kala tjapartia urrputja nukanhakarta lharrirrai wolknga erinha arratja ntarntaritjika.” Tjapartia urrputjantama inarlalhamala, etna wolknga ekururna lhaka. ");
INSERT INTO are_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wolknga erinha marnta inthorrilamala, etna tjapartia etnanha impurlalhakantama wolknga erinha arratja ntarntaritjika. ");
INSERT INTO are_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabbath arltiperra, kala Sunday ingutnhala inthorrantama, Mary Magdalene, Mary arrpunha nhanga turta, Jesuaka wolkngurna lhaka. ");
INSERT INTO are_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Arna erantama kngarra errowuka, Altjirraka angel alkiranga pitjikalanga. Angel erantama parta nhanga ankartiwuka, parta ekurakarlaka arrarnalhaka turta. ");
INSERT INTO are_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Angel ekura anngerra kwatjaka lharrkintja ngerra parrtjaka, mantarra ekura turta karnta ngerra tjulkuka. ");
INSERT INTO are_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tjapartia ntarntarintja ntjarra etna kngarra inthorra trerraka. Arnaka tnyimala, etna kala relha errilknga ngerrantama intaka. ");
INSERT INTO are_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angel erantama arrkutja ekuratharrurna angkaka, “Mpala itja trerritjika. Yinga kaltja mpala pitjikala Jesuanha aritjika, Jesua erinhala etna ntolkaka kanthatukala. ");
INSERT INTO are_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Era pula itja nhanhala nama. Era relha errilknga ntjarranga kamerrakala, era nhanga angkakala ngerra. Pitjai, katha erinha aritjika, erala intakala. ");
INSERT INTO are_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kurunga mpala parrpa kurtungurla ekuranha ntjarrurna lhai, etnanha ilai turta, ‘Era relha errilknga ntjarranga kamerrakala. Arai, erantama rrakangkarranga arrkurla lhama Galilee-urna. Tanhaka rrangkarra erinha aritjina’. Arai, atha mpalanha kala ilaka.” ");
INSERT INTO are_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Arrkutja eratharrantama wolknga ekuranga arrtjanaka kurtungurla ekuranha ntjarranha ilitjika. Eratharra nthurrpa tira kuta wulhaka, eratharra pula arrkana kngarra turta naka. ");
INSERT INTO are_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Eratharrantama tjaiyala lhamalangantema Jesuanha ekuratharranga urlarra itnatjalhaka. “Wortai,” era angkaka. Ekururna etinyerramala, eratharra mparalela arrarnalhamala ingka ekuranha errkuka, ekura urrkurrkintja naka turta. ");
INSERT INTO are_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesualantama erinhatharra ilaka, “Mpala itja trerritjika. Kala lharrai tjia nukanha ntjarranha ilitjika etna Galilee-urna arrkurla lhitjika. Tanhakantama etna yinganha aritjina.” ");
INSERT INTO are_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Arrkutja eratharra tjaiyala lhamalangantema, tjapartia ntarntarintja etna Jerusalem-urna alpuka. Etna turtantama priest-aka itornka ntjarraka yia ingkarraka alpmelaka. ");
INSERT INTO are_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Priest-aka itornka etnantama kngarripata itornka ntjarralela angkarraka. Kurunga etna tjapartia etnanha money kngarra nthaka, etnanha ilaka turta. ");
INSERT INTO are_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Arai, rrangkarra relha ntjarranha ilai, ‘Kurtungurla ekuranha ntjarra kunha ingula pitjimala mpurrka ekuranha nyilkngala inaka, nurna ankwentamanga.’ ");
INSERT INTO are_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pilate-ala paka nhanhiperra wumanga, rrangkarrala kula ankwentakala, nurna kala ekuralela angkitjina era rrangkarranha itja tutjika.” ");
INSERT INTO are_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tjapartia etnantama money erinha inamala relha ntjarranha yia nhanha alpmelaka. Lyartalpula relha Jew ntjarra yia nhanha ilarramantema. ");
INSERT INTO are_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kurunga kurtungurla 11 etna Galilee-urna lhaka, parta nhanga ekururna Jesualala etnanha ilakala, lhitjika. ");
INSERT INTO are_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesua erinha aramala, etna ekura urrkurrkintja naka. Urrputja arrpunhala pula erinha ilpoiwukantema. ");
INSERT INTO are_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesuanhantama etnakurna etinyerramala angkaka, “Altjirra Kaartala yinganha ingkairnaka alkirala Ingkarta kngarra nitjika, relha ingkarrakaka turta alhala. ");
INSERT INTO are_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lakinhangantama rrangkarra lharrirrai relha ingkarrakanha ilitjika yinga antja namanga etna ingkarraka kurtungurla nukantama nitjika. Rrangkarra etnanha kaltjirrpulhelitjika rretnyala Altjirra Kaartaka, Aliraka, Enka Alkngaltaraka turta. ");
INSERT INTO are_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Rrangkarra etnanha kaltjinthitjika turta turnintja ingkarraka nukanhaka kangkwerritjika. Arai, yingantama rrakangkarralela kuta nitjina, alha nhanha yirritjinalpula.” ");
INSERT INTO are_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nhanha Yia Marra Jesua Kristiperra nama, Altjirraka ‘Liriperra. ");
INSERT INTO are_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Altjirraka urrpia Isaiah erakimparra nhanga ilaka, “Atha urrpia nukanha ungkwanganga arrkurla yairnama. Era kala ungkwanga tjaiya urrkaputjina. ");
INSERT INTO are_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Artwa nyinta worritjala ilkama, ‘Rrangkarra Ingkartaka tjaiya mpaarai, ekura tjaiya arratja inthorra urrkapai.’” ");
INSERT INTO are_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","John Kaltjirrpulhelanhelanha era worritjala naka. Era relha ntjarranha ilaka, “Altjirrurna toperrai. Kurunga pitjai atha rrangkarranha kaltjirrpulhelitjinanga, Altjirrala turta korna rrakangkarranha iwutjinanga.” ");
INSERT INTO are_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Relha Judea-arinya ingkarraka, relha Jerusalem-arinya ingkarraka turtantama John-urna lhaka. Etna John-aka ilalhaka etna relha kornarintja namanga. Era turta etnanha Jordan lhirala kaltjirrpulhelaka. ");
INSERT INTO are_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Mantarra nhanga John-anhala ekarralhakala, nhanha camel ponganga mpaarakala. Era turta mantarra ekuranha yinpa belt-ala yirnitjata. Era intaltja, ngkwarla urltampa turta ilkutjata. ");
INSERT INTO are_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","John-ala relha ntjarranha ilaka, “Artwa arrpunha nukanga ingkarna pitjima. Era nukanga ekarltalkura nama. Yinga itja yalknga nama, topanamala sandal ekuranha paka ilutjika. ");
INSERT INTO are_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Arai, atha rrangkarranha kwatjala kaltjirrpulhelaka. Era pula rrangkarranha Enka Alkngaltarala kaltjirrpulhelitjina.” ");
INSERT INTO are_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Anma Jesuanha John-urna lhaka, pmara Galilee-angatjina, Nazareth town-anga. John-alantama erinha Jordan Lhirala kaltjirrpulhelaka. ");
INSERT INTO are_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesuanha warta kwatjanga rrataka, kanha era araka alkira era altjurerramanga, Enka Alkngaltara turta nturrurta ngerra ekurakarlaka tnanpentjimanga. ");
INSERT INTO are_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Era turta Altjirranha wuka alkiranga ekururna angkamanga, “Unta ‘Lira nuka nama. Yinga ungkwanga kngarra inthorra kangkama.” ");
INSERT INTO are_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nhanhiperra Enka Alkngaltarala Jesuanha worritjurna yairnarlenaka. ");
INSERT INTO are_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesuanhantama arlta 40 worritjala naka. Satan-ala turta erinha arrkarnaka. Jesuanha tnontha itnura ntjarralela naka. Angel ntjarrala turta erinha ntarntaraka. ");
INSERT INTO are_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Etna John-anha kala errkukalangantama, Jesuanha Galilee-urna lhaka. Erantama relha ntjarranha Altjirraka Yia Marra ilaka. ");
INSERT INTO are_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Era etnanha ilaka, “Antala nhanga Altjirrala arrkurla kuta ingkairnakala relhanha tangkalhelitjika, kala namantama. Altjirranha kala relha ingkarrakaka ntelalhitjikerrama, era Ingkarta etnaka namanga. Lakinhanga rrangkarra korna kuta ntelalhitjalai, kala Altjirrurna toperrai, Yia Marra erinha turta tnakai.” ");
INSERT INTO are_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesuanha nhanga Galilee ntjanganga ankerrala lhapalhamalanga, era Simon-anha, tjia ekuranha Andrew-anha turta araka, eratharra net kwatjurna iwumanga, irrpannga errkutjika. Eratharra kunha irrpannga errkunherrkunha naka. ");
INSERT INTO are_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesualantama erinhatharra ntangkaka, “Nukanga tnaartangala pitjai. Atha kala mpalanha kaltjinthitjina relhanhatitjantama errkutjika.” ");
INSERT INTO are_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kanhanga eratharra kala net ekuratharrakanha ipmintja impurlalhaka, Jesuanga tnaartangala lhaka turta. ");
INSERT INTO are_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Anpara lhamala, Jesuala Zebedee-aka worra tharra araka, James-anha, John-anha turta. Eratharra boat-ala narlanaka, net nhanga tjepakalhakala, thanthalanamala. ");
INSERT INTO are_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Erinhatharra aramala, Jesuala erinhatharra turtantama ntangkaka. Kaarta ekuratharrakanha, urrkapunhapunha ntjarranha turta boat-aka impurlalhamala, eratharra kala Jesuanga tnaartangala lhaka. ");
INSERT INTO are_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Etna Capernaum town-urnantama lhaka. Kurunga Sabbath arltala Jesuanha Synagogue-urnantama irrpuka, era relha ntjarranha kaltjinthaka turta. ");
INSERT INTO are_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Etna angkatja ekuranhaka tnolkaka. Erataka etnanha angkatja ekarltala kaltjinthaka, itja Intarrangaltha ntjarrala ngerra. ");
INSERT INTO are_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jesuala etnanha kaltjinthamalangantema, artwa enka kornakarta synagogue-urna irrpentjika. ");
INSERT INTO are_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Artwa erantama intarra ilkaka, “Jesua Nazareth-arinyai, iwukama unta pitjika? Nurnanha yirralhelitjikama unta pitjika? Yinga ungkwanga kaltja. Unta kunha Altjirraka Urrpia Alkngaltara Era.” ");
INSERT INTO are_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesualantama enka korna erinha rralthamala ilaka, “Tjukunyerrai! Artwa ekuranga rratai!” ");
INSERT INTO are_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Enka korna erantama artwa erinha arnaka ilatuka. Ilkarlalhamalantama, enka korna era artwa ekuranga rratarlalhaka. ");
INSERT INTO are_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nhanha aramala relha ingkarraka tnolkaka. Etnantama pmarrarraka, “Iwunhama lakinha? Erataka nurnanha angkatja arrpunha inthorra kaltjinthama, angkatja ekarltala turta. Era enka korna ntjarranha turta turnamalanga, etna ekura kala kangkwanterrama.” ");
INSERT INTO are_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yia Jesuiperra kala Galilee ntjaparurnantama ntakerranhaka. ");
INSERT INTO are_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kala synagogue-anga rratamala ngerra, Jesuanha James John tharrakarta, Simon Andrew tharraka ilthurna lhaka. ");
INSERT INTO are_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon-aka marataka menta intaka, wumpia inthorra. Etnantama Jesuanha nhanha ilaka, era irrpentjimanga ngerra. ");
INSERT INTO are_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesuanhantama arrkutja ekururna lhaka. Erinha iltjanga errkumala, era erinha kamalhelaka. Simon-aka mara kala marrerrakantama. Erantama etnaka marna etaka. ");
INSERT INTO are_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kala ngurrangurrerrakalangantama, lirnnga turta kala irrpukalanga, pmararinya ntjarrala relha menta, relha enka kornakarta turta Jesuurna kngitjika. ");
INSERT INTO are_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kala pmararinya ingkarrakantama Simon tharraka ilthala worlerraka. ");
INSERT INTO are_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesualantama relha menta arrpunhakarrpunhakarta etnanha marrilaka. Era enka korna ntjarranha turta unpurlenaka. Enka korna etna kala Jesuaka kaltja naka. Jesuala pula etnanha parraka, etna itja ekuriperra angkitjika. ");
INSERT INTO are_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ingutnhala inthorra Jesuanha kamerraka. Erantama pmaranga rratamala lhaka, nyintarinya nitjika, Kaarta ekuranhurna ingkitjika. ");
INSERT INTO are_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon ntjarralantama ekura yonthaka. ");
INSERT INTO are_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Erinha arltaramala, etna erinha ilaka, “Arai, relha ingkarrakalataka ungkwanga yonthama.” ");
INSERT INTO are_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesuala pula etnanha ilaka, “Mpa, nurna pmara arrpunha ntjarrurna turta lhiai. Nukathaka nama relha etnanha turta Yia Marra erinha kaltjinthitjika. Nhanhakakwia kunha yinga pitjikala.” ");
INSERT INTO are_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesuanhantama pmararrpaninhurna lhaka Galilee-ala. Synagogue nyintaminyintala era relha ntjarranha Yia Marra erinha kaltjinthaka, era enka korna ntjarranha turta unpurlenaka. ");
INSERT INTO are_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Artwa nyinta leprosy-akarta Jesuurna pitjika, ekuranga urlarra mparalela turta arrarnalhaka. Ngkangkawulhamala, era Jesuanha ilaka, “Unta paka antja namanga, unta yinganha kala irrpalthala marrilamara.” ");
INSERT INTO are_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesuanha ekura konyerraka. Erinha iltjala anpumala, era erinha ilaka, “Yinga antjakwia. Atha nganha kala marrilama.” ");
INSERT INTO are_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Artwa ekura leprosy-ntama kala yirralalhaka. Artwa era turta kala marrerraka. ");
INSERT INTO are_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Erinha yairnarlenitjinala, Jesuala erinha ilaka, ");
INSERT INTO are_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Arai, unta itja relha arrpunhanha nhanhiperra ilitjika. Kala priest-akanta ntelalhai. Unta turta Altjirranha tjauwerrilya nthai Moses-ala relha ntjarranha turnakala ngerra. Unta lakinhilitjika, relha ntjarra kaltja nitjinanga unta kala marrerrakalantama.” ");
INSERT INTO are_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jesuanha impurlalhamala ngerra pula, artwa era kala relha ingkarrakanha Jesuiperra ilakantala, nhanga Jesuala erinha marrilakala. Lakinhanga Jesuanha yarnantama town arrpunha ntjarrurna alkngatharra lhaka. Era kala kathalantama naka. Relha etna pula kalantema ekururna worlerraka. ");
INSERT INTO are_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jesuanha wotha Capernaum-urna alpuka. Era kala arlta urrputja town ekurala nakalangantama, relha ntjarrala wuka era pmarala namanga. ");
INSERT INTO are_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Relha ntjarra inthorrantama iltha ekuranhurna irrpuka. Relha arrpunha ntjarra turta reoala itnaka, yarna irrpumala. Jesualantama etnanha kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Artwa 4 arrpunhalantama artwa thaarranha Jesuurna kngitjika. Artwa erataka ntjamala intaka. ");
INSERT INTO are_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Etna pula yarna Jesuurna etinyerraka, worla kngarrala tjaiya parramanga. Etnantama iltha kartninyaka ntjika. Jesuanga kartna, etna roof erinha altjurilaka. Kurunga etna artwa thaarra erinha tnanpulhelaka, era ntjama ekuranhala intamanga kuta. ");
INSERT INTO are_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesuala aramalanga etna erinha kngarra tnakamanga, era artwa thaarra erinha ilaka, “'Lira nukai, atha korna ungkwanganha iwuka.” ");
INSERT INTO are_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Artwa Intarrangaltha urrputja tanhala naka. Angkatja nhanha wumala etna eterraka, ");
INSERT INTO are_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Iwunhangala era lakinha angkama? Erataka Altjirranha arrampowuma. Altjirralanta kunha relhaka korna irrpalthala iwuma.” ");
INSERT INTO are_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuala kala lhangkaraka etnala eterramalaka. Erantama etnanha pmarraka, “Iwunhangala rrangkarra lakinha eterrama? Yinganha nhanha ilai. ");
INSERT INTO are_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Iwunhama rukaralkura nama? Artwa thaarra nhanha erinha ilitjika, ‘Atha korna ungkwanganha iwuka?’ Erinha ilitjika paka, ‘Kala kamerrai, ntjama ungkwanganha tjurnai, nthulapai turta’? ");
INSERT INTO are_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Relhaka ‘Lira era nthurrpa relha ingkarrakaka korna irrpalthala iwuma. Atha rrangkarranha nhanha kala ntelitjina.” Jesualantama artwa thaarra erinha ilaka, ");
INSERT INTO are_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kamerrai! Ntjama ungkwanganha tjurnamala, kala alpai.” ");
INSERT INTO are_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Artwa era kala kamerrakanta. Era ntjama ekuranha tjurnamala, rratanhaka, relha ingkarrakanga alkngatharra. Relha etna pula tnolkaka. Etnantama Altjirranha tnantjaka, lakinha angkamala, “Nurna itja lakinha ngerra arrkurla araka paka.” ");
INSERT INTO are_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesuanhantama wotha Galilee ntjangurna alpuka. Relha ntjarra ekururna worlerrentjalpuka. Era etnanha kaltjinthaka turta. ");
INSERT INTO are_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kurunga ankerralantama lhapalhamala, Jesuala Levi-anha araka iltha ekuranhanga kathala narlanamanga. Levi era Alphaeus-aka worra naka. Era turta tax money kotjitjata. Erinha aramala, Jesuala erinha ntangkaka, “Nukanga tnaartangala pitjai.” Kamerramala Levi-anha kala Jesuanga tnaartangala lhaka. ");
INSERT INTO are_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Anma, Jesuanha, kurtungurla ekuranha ntjarra turta Levi-aka ilthala worlerraka, marna ilkutjika. Relha kornarintja ntjarra arrpunha, tax money kotjinha arrpunha ntjarra turta, etnala Jesuanga tnaartangala lhamanga, etna turta etnakalela marna ilkurlanakantema. ");
INSERT INTO are_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Artwa Intarrangaltha urrputja, etnala Pharisee turta namanga, etna tanhala nakantema. Etna Jesuanha aramalanga relha kornarintja ntjarralela marna ilkumanga, relha tax money kotjinha ntjarralela turta, etna Jesuaka kurtungurla ntjarranha pmarraka, “Iwunhangala era relha tax money kotjinha ntjarralela marna ilkuma, relha kornarintja ntjarralela turta?” ");
INSERT INTO are_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesuala etnanha wuka. Erantama etnanha ilaka, “Relha ltarrkngalataka itja ngangkaraka yonthama. Relha mentalanta. Yinga pitjika relha kornarintja ntjarranha Altjirrurna rretjingitjika, itja relha arratja ntjarranha.” ");
INSERT INTO are_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Arrpunharanga John Kaltjirrpulhelanhelanhaka kurtungurla ntjarra, artwa Pharisee ntjarra turta marnakunya naka. Relha arrpunha ntjarrantama Jesuurna pitjimala erinha pmarraka, “Iwunhangala John Kaltjirrpulhelanhelanhaka kurtungurla ntjarra, artwa Pharisee ntjarra turta marnakunya nama, kanha kurtungurla ungkwanganha ntjarra itjala marnakunya nama?” ");
INSERT INTO are_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesuala etnanha ilaka, “Artwala noa inamanga, era tjinkarra urrkapuma. Kurunga era tjina ekuranha ntjarranha ntangkama marna ilkutjika. Tjina etnantama yarna marnanga unpulhama, artwa noa inakala, era etnakalela namangantema. ");
INSERT INTO are_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Anma pula relha arrpunha ntjarrala artwa erinha errkumala kngitjina. Kurunga artwa ekura tjina ntjarra arlta arrpunhala marnakunyantama nitjina. ");
INSERT INTO are_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Arai, thunga mantarra ingkwia tjepakalhama. Relhala itja mantarra lyartinyanga mantarra kurrka kamala nhanha mantarra ingkwiakarlaka thanthama. Mantarra lyartinya era urlpmerramala, mantarra ingkwia erinha wothantema tjepakakitja. ");
INSERT INTO are_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Relhala turta itja wine lyartinya yinpa ingkwiaka thalama, wine lyartinyala yinpa ingkwia etnanha talhelakitja. Kurunga wine lyartinya era, yinpa ingkwia etna turta, tharrantema ipmintjerrama. Lakinhanga kunha relhala wine lyartinya kala yinpa lyartinyakanta thalama.” ");
INSERT INTO are_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabbath arlta arrpunhala Jesuanha, kurtungurla ekuranha ntjarra turta, tnukulpanga tjananhaka. Tnukulpa ekurala marna wheat urnma itnaka. Jesuaka kurtungurla ntjarralantama marna mpakaka. ");
INSERT INTO are_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Artwa Pharisee urrputjalantama Jesuanha pmarraka, “Iwunhangala kurtungurla ungkwanganhala marna wheat mpakama, Sabbath arltala? Nhanha kunha itja arratja nama.” ");
INSERT INTO are_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesuala etnanha ilaka, “Rrangkarra itjala David-aka kaltja? Era nhanga ngaiyala naka, artwa ekuralela namala ntjarra turta. ");
INSERT INTO are_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David-anhantama Altjirraka ilthurna irrpuka. Iltha ekurala marna intaka, marna nhanga Altjirranha tjauwerrilya nthakala. Nhanha priest-akanta naka ilkutjika. David-ala pula marna nhanha ilkukala, ngaiyalala warta. Era turta marna nhanha artwa ekuralela namala ntjarranha nthaka, ilkutjika. Lakinha David-anha Altjirraka mpaarangarangaka itja kangkwerraka. Nhanga lakinherraka, Abiathar-anha high priest namalanga.” ");
INSERT INTO are_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesualantama etnanha ilaka, “Altjirralataka Sabbath arlta erinha ingkairnaka relhaka marrakakwia. Era itja relhanha arrpmarnaka, Sabbath arltakakwia. ");
INSERT INTO are_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Arai, Relhaka ‘Lira era Sabbath arlta ekura turta Ingkarta nama.” ");
INSERT INTO are_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Anma, Jesuanha wotha synagogue-aka irrpuka. Artwa iltja ntjirrkakarta synagogue ekurala naka. ");
INSERT INTO are_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Relha arrpunha ntjarrantama eterraka, “Era paka artwa nhanhaka iltja marrilamanga, nurna erinha kala ilparnitjinanta kuta.” ");
INSERT INTO are_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesualantama artwa iltja ntjirrkakarta erinha ntangkaka, “Pitjai!” ");
INSERT INTO are_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kurunga era etnanha pmarraka, “Nhanha arratjama nama Sabbath arltala relhaka tangitjala nitjika, relhanha marrilitjika turta? Nhanha arratjama nama Sabbath arltala relhanha nakapakarlilitjika, kornilitjika paka?” Etna pula pmarna kuta naka. ");
INSERT INTO are_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesuanha etnaka aalerrakantama, ltarrperraka turta etna arrthata inthorra namanga. Erantama etnanha ingkarraka tjoraraka. Kurunga era artwa erinha ilaka, “Iltja ungkwanganha imarnai.” Artwa erantama iltja ekuranha imarnaka. Iltja ekuranha kala marrerraka. ");
INSERT INTO are_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Artwa Pharisee etnantama synagogue ekuranga rratamala lhaka. Etna turtantama Herod-aka kurtungurla ntjarralela angkarraka, Jesuanha errilknga tutjika. ");
INSERT INTO are_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesuanha, kurtungurla ekuranha ntjarra turta Galilee ntjangurnantama lhaka. Relha Galilee-arinya ntjarrantama ekururna worlerrentjalpuka. ");
INSERT INTO are_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Relha arrpunha ntjarrala turta Jesuiperra wuka. Etnantama Judea-anga pitjika, Idumea-anga, Jerusalem-anga, Jordan urntwarrampinyanga, pmara Tyre Sidon tharranga turta. ");
INSERT INTO are_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Relha etna ntjarra inthorra naka. Lakinhanga Jesuala kurtungurla ekuranha ntjarranha turnaka, etna boat nyinta ekura kngitjitjika. Erantama boat ekura ntjika, worla kngarrala erinha rrothakitja. ");
INSERT INTO are_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesualantama relha ntjarra inthorranha marrilaka. Lakinhanga relha menta arrpunha ntjarra turta ekururna etinyerraka, erinha anputjika. ");
INSERT INTO are_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Relha enka kornakarta ntjarrala erinha aramalanga, etna arnaka iwulhitjata. Enka korna etnantama ilkitjata, “Unta kunha Altjirraka ‘Lira nama.” ");
INSERT INTO are_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesuala pula enka korna etnanha rralthamala turnitjata, etna relha ntjarranha nhanha itja ilitjika. ");
INSERT INTO are_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Partaka ntjimala, Jesuanha artwa etnaka ntangkalhaka, etnakala era antja nakala. Etna ekururna pitjika turta. ");
INSERT INTO are_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kurunga era artwa 12 urraraka. Era etnanha ilaka, “Arai, atha rrangkarranha urraraka nukalela nitjika, atha turtantama rrangkarranha yairnitjina Yia Marra erinha kaltjinthitjika. ");
INSERT INTO are_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Atha turta rrangkarranha ekarltilama rrangkarra enka korna ntjarranha relhanga irrpalthala unputjinanga.” ");
INSERT INTO are_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Artwa nhanha etna naka Simon. Erinha Jesuala rretnya Peter turta alpmelaka. ");
INSERT INTO are_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedee-aka worra tharra, James-anha, tjia ekura John-anha turta. Artwa nhanha tharranha Jesuala rretnya arrpunha turta alpmelaka, “Boanerges,” nhanhatitja “Kwatja Angkatjaka ‘liranhanga.” ");
INSERT INTO are_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James arrpunha nhanga, Alphaeus-aka worra, Thaddaeus, Simon turta. Simon nhanha era thakerritjata Altjirraka mpaarangarangaka kangkwerritjika. ");
INSERT INTO are_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariot turta. Judas nhanha era Jesuanha anma leltjaka lanthaka. ");
INSERT INTO are_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesuanha iltha ekuranhurnantama alpuka. Relha ntjarra inthorrantama ekururna wothantema worlerrentjalpuka. Jesuala, kurtungurla ekuranha ntjarrala turtantama yarna marna ilkuka, relha ntjarranga. ");
INSERT INTO are_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesuaka tjinala nhanhiperra wumalanga, etna pitjika erinha errkutjika. Etna etarlaraka era kula rirterrakala. ");
INSERT INTO are_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Artwa Intarrangaltha urrputjantama Jerusalem-anga pitjika. Etna relha ntjarranha lakinha ilaka, Jesuiperra. “Artwa nhanha Beelzebub-aka kangkwerrama, errintja ntjarraka itornkaka. Beelzebub-ala erinha ekarltilama, era enka korna ntjarranha relhanga irrpalthala unpurlenitjinanga.” ");
INSERT INTO are_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesuanhantama artwa Intarrangaltha ntjarraka ntangkalhaka. Era etnanha ilaka, etnaka yia alpmelamala, “Satan-ala yarna Satan-anha unpurlenama. ");
INSERT INTO are_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Etarlarai, relha pmararinya ntjarra leltjakaleltjerramanga, pmara etnaka kala ipmintjerritjina. ");
INSERT INTO are_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ramarama turta, etna leltjakaleltjerramanga, etna kala yirritjinantema. ");
INSERT INTO are_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Lakinhanga, Satan-anha paka Satan-aka leltja namanga, era kala yirritjina. ");
INSERT INTO are_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Arai, thunga artwa, artwa ekarltaka ilthurna irrputjika antja, yultha ekuranha nyilkngala initjika. Era artwa ekarlta erinha errkumala yirnitjikarrka. Kurunganta era yultha ekuranha irrpalthala nyilkngala kngama. ");
INSERT INTO are_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Athantama rrangkarranha nhanha nthurrpa ilama. Thunga relha korna inthorra ntelalhama, Altjirranha arrampowuma turta. Altjirrala kala korna ekuranha iwutjina, era ekururna toperramanga. ");
INSERT INTO are_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Relhala pula Enka Alkngaltara erinha arrampowumanga, Altjirrala korna ekuranha itja kutala iwutjina. Korna ekuranha kala kuta intitjina.” ");
INSERT INTO are_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesuala etnanha nhanha ilaka, arrpunhala ilakalanga era kula enka kornakarta namanga. ");
INSERT INTO are_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesuaka mia, tjia ekuranha ntjarra turtantama pitjika, kathala turta kaaralhaka. Etnantama Jesuurna angkatja yairnaka era etnakurna rratitjika. ");
INSERT INTO are_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Relha etnala Jesualela namanga, etnantama erinha ilaka, “Arai, mia ungkwanga, tjia ungkwanganha ntjarra turta ungkwanga kathala kaaralhama.” ");
INSERT INTO are_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesuala pula etnanha pmarraka, “Ngunhama mia nuka, tjia nuka turta nama?” ");
INSERT INTO are_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Relha ekuranga kaarntakaarntala namala ntjarranhantama era ntelamala ilaka, “Rrangkarra mia pa tjia nuka ntjarra nama. ");
INSERT INTO are_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Relha etnala Altjirraka kangkwerrama, etna kunha tjia nukanha nama, mia nukanha turta.” ");
INSERT INTO are_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesuala wothantema relha ntjarranha kaltjinthaka, Galilee ntjanganga kutala. Relha ntjarra inthorrantama ekururna worlerrentjalpuka. Lakinhanga era boat-aka ntjimala, kwatjala naka. Kanha relha ntjarra ankerralala itnaka. ");
INSERT INTO are_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesualantama etnanha kaltjinthaka, etnaka yia alpmelamala. Nhanga lakinha ngerra era etnanha kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Wurrirrai. Artwa nyinta tnukulpa ekuranhurna lhaka marna annga ingkairnitjika. ");
INSERT INTO are_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Erantama annga etnanha alpantiwumanga, annga arrpunha ntjarra tjaiyakarlaka tnyika. Thepa ntjarrantama pitjika, annga etnanha ilkuka turta. ");
INSERT INTO are_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Annga arrpunha ntjarra arna partapapathakarlaka tnyika. Etna parrpa lyapuka, arna era tarratha wara warta namanga. ");
INSERT INTO are_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lirnnga era pula rratamalanga, lirnngala marna kurrka etnanha ntjirrkilamala mpuka. Takarra etnaka yarna warta arna kwanurna irrpukalanga. ");
INSERT INTO are_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kala annga arrpunha ntjarra lyakanga mpopakarlaka tnyika. Lyaka etnantama mangkamala marna kurrka etnanha ulpulatuka. Etnantama itja kuta marnakarterraka. ");
INSERT INTO are_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kala annga arrpunha ntjarra pula arna marrakarlakala tnyika. Etna mangkaka, marnakarterraka turta. Arrpunhala annga 30 lhalhelaka. Arrpunhala 60. Arrpunhala 100.” ");
INSERT INTO are_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesualantama etnanha ilaka, “Ungkwanga paka ilpa intamanga, kala wurlathanai.” ");
INSERT INTO are_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesuanha kala nyintarinyantama namalanga, kurtungurla ekuranha 12, relha urrputja arrpunha turta ekururna pitjika, erinha yia etnakiperra pmarritjika. ");
INSERT INTO are_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesuala etnanha ilaka, “Yinga antja nama rrangkarra lhangkaritjika Altjirranha kala pitjikala relha ingkarrakaka ntelalhitjika era Ingkarta namanga. Kanha relha arrpunha ntjarra, etnala itja worla nukanhala namanga, etnanha atha yiala alpmelama. ");
INSERT INTO are_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Atha etnanha yiala alpmelama, ‘etna yia nukanha wutjinanga, angkatja arrpunha nukanha turta, etna pula etnanha itja lhangkaritjinanga. Arai, etna paka angkatja nukanha nthurrpa lhangkaramanga, etna Altjirrurna toperrakitja, Altjirrala turtantama korna etnakanha iwukitja.’” ");
INSERT INTO are_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesualantama etnanha pmarraka, “Thunga rrangkarra yia artwa nhangiperra yarna lhangkarama, artwa erala marna annga ingkairnakala. Nthakinhantama rrangkarra yia arrpunha ntjarra lhangkaritjina? ");
INSERT INTO are_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Arai, artwa erala marna annga alpantiwuma, erataka relha lenha ngerra nama, erala Altjirraka angkatja relha ntjarranha kaltjinthama. ");
INSERT INTO are_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Annga nhanga tjaiyakarlaka tnyikala, nhanha kala relha etna ngerra nama, etnala Altjirraka angkatja wuma. Etna pula angkatja erinha wumanga ngerra, Satan-ala angkatja erinha rakama. ");
INSERT INTO are_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Annga nhanga arna partapapathakarlaka tnyikala, nhanha kala relha etna ngerra nama, etnala kngarra kangkama etna Altjirraka angkatja wumalanga. ");
INSERT INTO are_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Etna pula angkatja ekura parrpa kngwerrama. Lakinhanga etna Altjirranha itja ekarlta tnakama. Etnantama imampurlerramanga, relha arrpunhala paka etnanha arrampowumanga Altjirraka angkatjakakwia, etna kala Altjirranha impumanta. ");
INSERT INTO are_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Annga nhanga lyaka mpopakarlaka tnyikala, nhanha kala relha lenha ntjarra ngerra nama, etnala Altjirraka angkatja wuma. ");
INSERT INTO are_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Etna pula yulthiperralka, arrkaniperralka money-iperralka kngarra kuta eterramala Altjirraka angkatja parrpartilama. Altjirraka angkatjantama itja kuta anngakarterrama ngerra. ");
INSERT INTO are_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Annga nhanga arna marrakarlaka tnyikala, nhanha kala relha lenha ntjarra ngerra nama, etnala Altjirraka angkatja wuma, ekura kuta antja nama turta. Etnantama annga marra lhalhelama ngerra, arrpunhala 30, arrpunhala 60, arrpunhala 100.” ");
INSERT INTO are_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesuala etnanha ilaka, “Relhala kunha itja alkngantha iltha kwanurna kngamala taarnala korltama, bed-anga kwaninyaka paka arrarnama. Era pula alkngantha erinha table-akatitja arrarnama. ");
INSERT INTO are_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Arai, lyarta relha ntjarrala Altjirraka angkatja itja lhangkaritjina, angkatja nhanga athala etnanha ilamanga. Anma pula Altjirrala angkatja nhanha etnaka nentilitjina. ");
INSERT INTO are_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ungkwanga ilpa paka intamanga, yinganha wurlathanai.” ");
INSERT INTO are_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Era turta etnanha ilaka, “Rrangkarra itja Altjirraka angkatja wara wurlanitjika. Rrangkarra relha arrpunha ntjarranha Altjirraka angkatja kaltjinthamanga, Altjirrala rrangkarranha turta kngarralkura kaltjinthitjina. ");
INSERT INTO are_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Relha erala Altjirraka angkatjaka kangkama, Altjirraka angkatjaka turta kngarralkura kaltjerritjika antja nama, erinha Altjirrala wothalkura kaltjinthitjina. Kanha relha erala Altjirraka angkatjaka antjakunya, erinha Altjirrala itja kutala kaltjinthitjina.” ");
INSERT INTO are_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesuala etnanha ilaka, “Altjirranha relha ingkarrakaka Ingkarta namanga, lakinha ngerra nama. Artwala marna annga arnaka alpantiwuma. ");
INSERT INTO are_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Annga etnanha alpantiwumaliperra, artwa era kunpa ingula ankwentama, kunpa arltala nthulapuma. Annga etna pula lyapuma, mangkama turta. Nthakinhama annga etna mangkama? Artwa era itja kaltja. ");
INSERT INTO are_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kala arna erarrpa annga etnanha mangkalhelama. Arrkurla annga etna lyapuma. Kurunga etna mangkama. Kurunga etna anngakarterrama. ");
INSERT INTO are_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Anma, annga etna kala urnmerrakalangantama, artwa era marna etnanha kotjima.” ");
INSERT INTO are_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesuala etnanha pmarraka, “Nthakinhama relhala lhangkaramara ‘Altjirranha relha ingkarrakaka Ingkarta namanga?’ Nthakinha turtama atha nhanha rrakangkarra nentilamara? Arai, atha rrakangkarra yia alpmelitjina. ");
INSERT INTO are_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nhanha kala nama relhala tjurrka annga arnaka ingkairnamanga ngerra. Tjurrka annga era kala kurrka inthorra nama. ");
INSERT INTO are_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tjurrka annga erinha pula ingkairnamalanga, era kala mangkamala kngarritja inthorrerrama, etintjakarta. Thepa etnantama pitjima, antjwa etnakanha turta etintjala mpaarama.” ");
INSERT INTO are_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesuala relha ntjarranha Altjirraka angkatja kaltjinthaka, etnanha yia arrpunhakarrpunha alpmelamala. Era pula etnanha lenhakurtitjanta kaltjinthaka, etnala irrpalthala kaltjerraka. ");
INSERT INTO are_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Era kala etnanha yia alpmelamalanta wara kaltjinthaka. Yiakunya era etnanha itja kuta kaltjinthaka paka. Kanha era kurtungurla ekuranha ntjarralela namalanga, nhanga etnanta, era etnaka Altjirraka angkatja ingkarraka nentilakala. ");
INSERT INTO are_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kala ngurrangurrerrakalangantama, arlta nyinta ekurala, Jesuala etnanha ilaka, “Mpa, nurna kala ntjanganga tjananhiai, etapa arrpunhurnantama.” ");
INSERT INTO are_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jesua era kala boat-ala naka. Relha worla etnanha impurlalhamalantama, kurtungurla ntjarrala Jesuanha kala kngaka. Boat arrpunha ntjarra turta etnakalela lhakantema. ");
INSERT INTO are_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Etna kunpa lhapalhamanga, wurinya ekarlta inthorrala etnanha twentjika. Kwatja kngarrantama boat ekura thalalhaka, inmarra kngarritja inthorranga. ");
INSERT INTO are_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesuanha pula boat ingkarna mpinyala ankwentarlanakala, kartamalala intamala. Kurtungurla ntjarralantama erinha kamalhelamala pmarraka, “Kaltjinthanhinthanhai, unta kunpala ankwentama nurna ilutjikerramangatanya?” ");
INSERT INTO are_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kamerramala, Jesuala wurinya erinha, inmarra etnanha turta parraka, “Kala yirrai!” Kala wurinya era, inmarra etna turta yirrakanta. ");
INSERT INTO are_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesualantama kurtungurla ekuranha ntjarranha pmarraka, “Iwunhangala rrangkarra trerraka? Rrangkarra yinganha itjala tnakama?” ");
INSERT INTO are_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Etna pula kala kngarralkuratitja trerraka arrkurlangatjina. Etna pmarrarraka, “Ngunhama artwa nhanha? Wurinya, kwatja inmarralka kunha ekura kangkwerrama.” ");
INSERT INTO are_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ntjanganga tjananhamalantama etna pmara Gerasa-urna pitjika. ");
INSERT INTO are_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesuanha warta boat-anga tnanpuka, kanha artwa enka kornakarta ekururna arrtjanentjika, wolknga mpopanga. ");
INSERT INTO are_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Artwa nhanha erataka pmara ekuranha mpaarakala, relha errilkngaka wolknganga mpopala. Relhala turta erinha yarna kuta yirnitjata, chain-alalka paka. ");
INSERT INTO are_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Relha ntjarrala paka iltja pa ingka ekuranha chain-ala yirnamanga, era chain etnanha kala urltakitjatanta. Relhalantama erinha yarna kuta parraka, era ekarlta inthorra namanga. ");
INSERT INTO are_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ingula pa arltala era relha errilkngaka wolkngala ilkarlaputjata, iltjetala turta kalhitjata. ");
INSERT INTO are_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Artwa nhanha era Jesuanha ilangakantema araka. Erantama ekururna arrtjanentjika, ekuranga urlarra mparalela turta arrarnalhaka. ");
INSERT INTO are_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Erantama intarra ilkaka, “Jesuai, Altjirra Kngarra ekura ‘Lirai, iwukama unta nukurna pitjika? Yinganha Altjirranga urlarra lhelai, unta yinganha itja rrukunthakunthilitjinala.” ");
INSERT INTO are_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Era lakinha angkaka, Jesuala kala enka korna erinha turnakalanga ekuranga rratitjika. ");
INSERT INTO are_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesualantama erinha pmarraka, “Rretnya ngunhama unta?” ");
INSERT INTO are_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Artwa era erinha ilaka, “Yinga nama rretnya ‘Ntjarra’, yinga enka korna ntjarrakarta warta namanga.” Erantama Jesuaka kuta ngkangkawulhaka, era itja enka korna etnanha pmara lenhanga unpurlenitjika. ");
INSERT INTO are_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Etinya wara, parta ingkala, pig ntjarrala marna ilkurlanaka. ");
INSERT INTO are_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Enka korna etnantama Jesuaka ngkangkawulhaka, “Nurnanha pig ntjarrurna yairnai, nurna etnakurna irrputjinanga.” ");
INSERT INTO are_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesuala kala etnanha impurlarrarnaka. Enka korna etnantama artwa ekuranga rratamala, pig ntjarrurna irrpuka. Pig worla etnataka 2,000 ngerra naka. Pig etnantama rirterramala parta irnkurna arrtjanamala, kwatja ntjangurna tnyinhaka, alkngontingkaka turta. ");
INSERT INTO are_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Artwa pig ntarntarintja ntjarrantama town-urna arrtjanaka, tnukulpa ntjarrurna turta, yia erinha ilarlaputjika. Pmararinya ntjarrantama pitjika, aritjika. ");
INSERT INTO are_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesuurna etinyerramala, etna artwa nhanganha araka. Era eterrintja marrakartantama naka, mantarraka ekarralhakala turta. Etnantama trerraka. ");
INSERT INTO are_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kurunga relha etnala nhanha arakala, etna relha pitjikala etnanha yia nhanha ingkarraka alpmelaka. ");
INSERT INTO are_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Relha nhanha etnantama Jesuanha ilaka, “Nurna antja nama unta pmara nurnakanhanga kala rratitjikanta.” ");
INSERT INTO are_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesuanha kala boat-aka ntjimalangantama, artwa marrerrakala era Jesuanha ilaka, “Yingataka ungkwangalela lhitjika antja.” ");
INSERT INTO are_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesuala pula erinha parraka. Era erinha ilaka, “Tjina ungkwanganha ntjarrurna alpai. Etnanha turta ilai Ingkartala nganha marrilakala, ungkwanga kangkintja ntelalhakala turta.” ");
INSERT INTO are_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Artwa era kala pmara Decapolis-urna lhaka. Era turta relha ingkarrakanha ilaka Jesuala erinha marrilakala. Relha ntjarrala yia nhanha wumalanga, etna ingkarraka tnolkaka. ");
INSERT INTO are_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesuanhantama wotha ntjanganga tjananhaka, boat-ala. Ntjanga altorlampinyakerramala, relha ntjarra inthorrantama ekururna worlerrentjalpuka. ");
INSERT INTO are_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jairus, synagogue lenharinyaka itornka, era turta pitjikantema. Jesuanha aramala, era ekuranga urlarra mparalela arrarnalhaka. ");
INSERT INTO are_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Erantama ingkaka, “Jesuai, kwarra nukataka kala ilutjikerrama. Nukalela pitjai iltja ungkwanganha ekurakarlaka arrarnitjika era wotha marrerritjinanga.” ");
INSERT INTO are_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesuanha kala Jairus-alela lhaka. Worla kngarra turta ekuralela lhakantema. Etna lhapalhamalanga, relha ntjarrala erinha parlpapauwurlapuka, ekururna etinyerritjikerramala. ");
INSERT INTO are_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Arrkutja nyinta worla lenhala nakantema, erala 12 years menta kngarrakarta nakala. ");
INSERT INTO are_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Era kala ngangkara ntjarrurna lhakala, etna pula erinha yarna marrilaka. Erantama kala money-akunya naka, money ekuranha ingkarraka ngangkara ntjarranha nthakala. Erarrpa pula mentalkurala naka. ");
INSERT INTO are_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Arrkutja nhanhala kala arrkurlantema wukala Jesuala menta ntjarranha marrilamanga. Erantama Jesuurna etinyerraka, mantarra tjenya ekuranha anpuka turta. ");
INSERT INTO are_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Erataka lakinha eterraka, “Atha paka mantarra ekuranhanta anpumanga, yinga kala marrerritjina.” ");
INSERT INTO are_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Erantama mantarra tjenya ekuranha anpumanga ngerra, era marrerralalhaka. Era turta wulhaka mpurrka ekura kala marrantama namanga. ");
INSERT INTO are_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Era warta Jesuaka mantarra anpuka, kanha Jesuanha wulhalalhaka era kurrka thaltjerramanga. Erantama relha ntjarranha pmarraka, “Ngunhalama mantarra nukanha anpuka?” ");
INSERT INTO are_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kurtungurla ekuranha ntjarrala pula erinha ilaka, “Iwunhangala unta pmarrama, ‘Ngunhalama mantarra nukanha anpuka?’ Unta yarnala arama relha ntjarra ungkwanganga etinya itnamanga, nganha parlpapauwumanga turta?” ");
INSERT INTO are_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesuanha pula ilkngaralhamala relha ekura kuta yonthaka. ");
INSERT INTO are_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Arrkutja nhanga kaltja naka era marrerrakala, era nhanga wulhalalhakanga warta. Erantama ekururna pitjika, kngarra trerramala. Mparalela arrarnalhamala, era ilalhaka. ");
INSERT INTO are_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesuala erinha ilaka, “Kwarra nukai, unta yinganha tnakakalanga Altjirrala nganha kala marrilaka. Kala tnoatnoa alpai.” ");
INSERT INTO are_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesuanha arrkutja ekururna angkamalangantema, urrpia Jairus-aka pmaranga pitjika. Etna Jairus-anha ilaka, “Kwarra ungkwanga kunha kala itja wotha. Itornka erinha kala impai erarrpa lhitjika.” ");
INSERT INTO are_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesuanha pula angkatja nhanhaka itja kangkwerraka. Era Jairus-anha ilaka, “Itja trerrai. Kala yinganha tnakantai.” ");
INSERT INTO are_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Relha arrpunha ntjarranha parramalantama, era Peter-anha, James-anha, tjia ekura John-anha turta urraramala, etnakakartantantama Jairus-aka ilthurna anparerraka. ");
INSERT INTO are_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairus-aka ilthakerramala, Jesuala araka relha ntjarra itnimanga, nthorrkngerramanga turta. ");
INSERT INTO are_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Irrpunhamala era etnanha pmarraka, “Iwunhangala rrangkarra itnima, nthorrkngerrama turta? Katjia nhanha itjama errilknga. Era wara ankwentama.” ");
INSERT INTO are_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Etna pula ekura tharrakala. Jesualantama etnanha ingkarraka ilthanga unpurlenaka. Kurunga katjia ekura kaarta pa miakarta, kurtungurla tharraminyinta ekuranhakarta turta, era room ekururna irrpunhaka, ekuralala katjia era intamanga. ");
INSERT INTO are_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Katjia erinhantama iltjanga errkumala, era erinha ilaka, “Talitha koum!” Nhanhatitja, “Kwarra kurrkai, atha nganha ilama, kamerrai!” ");
INSERT INTO are_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kwarra era kala kamerrakanta, ingka nthulapuka turta. Kwarra era 12 years ingkwia naka. Nhanha aramala etna ingkarraka tnolkakanta, yarna inthorra etarlaritjikerramala. ");
INSERT INTO are_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesuala pula etnanha angkatja ekarltala tjatjatuka, etna itja relha arrpunhanha nhanhiperra ilitjika. Erantama kaarta pa mianha ilaka eratharra kwarra erinha marna ilkutjika nthitjika. ");
INSERT INTO are_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pmara lenha impurlalhamalantama, Jesuanha pmara ekuranhurna alpuka. Kurtungurla ekuranha ntjarra ekuranga tnaartangala lhakantema. ");
INSERT INTO are_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabbath arltalantama, era relha ntjarranha synagogue-ala kaltjinthaka. Etna erinha wumalanga etna tnolkaka, pmarrarraka turta. “Nthanhalama era angkatja nhanha arrkurla wuka? Nthakinhama era kaltja inthorrerraka? Ngunhala turtama erinha ekarltilaka tjatjikarta urrkaputjika? ");
INSERT INTO are_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Arai, Jesua nhanha era kunha rurlaka urrkapunhapunha. Nurna Mary-aka, mia ekuranhaka kaltja, tjia ekuranha ntjarraka turta, James-aka, Joses-aka, Judas-aka, Simon-aka turta. Arrumpa ekuranha ntjarra turta pmara nhanhala namantema, nurnakalela.” Relha etnantama Jesuaka antjakunyerraka. ");
INSERT INTO are_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesualantama etnanha ilaka, “Relha arrpunha ntjarralanta kunha kaltjinthanhinthanha kngarranha tnantjama. Kanha relha pmararinyala, ramarama ekuranhala, tjina ekuranhala turta, erinha itja kutala tnantjama.” ");
INSERT INTO are_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Erantama pmara lenhala yarna tjatjikarta kngarra urrkapuka. Era kala relha urrputjanhanta wara marrilaka, iltja ekuranha kapurta etnakanhaka arrarnamala. ");
INSERT INTO are_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesuanhataka tnolkaka etna erinha itja kuta tnakamanga. Jesuanha town kurrka nyintaminyinturnantama lhaka, era turta relha town-arinya etnanha kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kurunga 12 etnanha ntangkamala, era etnanha urrpia yairnaka, tharra pmara nhanhurna, tharra pmara arrpunhurna, tharramatharra eknga. Era etnanha ekarltilaka turta enka korna ntjarranha relhanga unputjika. ");
INSERT INTO are_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Era etnanha lakinha turta tjatjatuka. “Rrangkarra kala erratitjakartanta lhitjika. Rrangkarra turta itja marna kngitjika, thauwa paka, money paka. ");
INSERT INTO are_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Rrangkarra kala sandal-aka ekarralhitjika. Rrangkarra pula itja coat tharra kngitjika. ");
INSERT INTO are_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Rrangkarra town-urna irrpumalanga, relha etna turta rrakangkarra antja namanga, kala iltha nyintala kuterrai rrangkarra anparerritjinalpula. ");
INSERT INTO are_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Thunga pula rrangkarra town-urna irrpuma. Relha etna rrakangkarra antjakunya nama. Etna turta itja antja nama rrangkarranha wutjika. Kala town lenhanga rratai, urlpmurra ingka rrakangkarranhanga ilarnamala. Lakinha rrangkarra etnanha lhalaritjina, Altjirrurna toperritjika.” ");
INSERT INTO are_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kurtungurla etnantama lhaka, relha ntjarranha ilaka turta etna Altjirrurna toperritjika. ");
INSERT INTO are_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Etna enka korna ntjarranha relhanga unpuka. Etna turta relha menta ntjarranha ntirala parnamala, marrilaka turta. ");
INSERT INTO are_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kala relha ntjarra inthorralantama Jesuiperra wuka. King Herod era turtantama ekuriperra wukantema. Relha arrpunha ntjarra lakinha Jesuiperra angkaka, “John Kaltjirrpulhelanhelanha wotha etatherrakau. Altjirrala turta erinha ekarltilaka tjatjikarta urrkaputjika.” ");
INSERT INTO are_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Arrpunha ntjarra pula angkaka, Elijah-anha kula wotha etatherrakala. Kanha arrpunha ntjarra angkaka Jesuanha kula Altjirraka urrpia imankinya arrpunhala namanga. ");
INSERT INTO are_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herod-ala pula Jesuiperra wumala, lakinhala angkaka, “Nhanha John-anhanta kuta nama. Atha nhanga tjapartia nyintanha turnaka kapurta ekuranha inturnitjika. Erantama lyarta wotha etatherrakala nama.” ");
INSERT INTO are_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","King Herod-alataka Herodias-anha, tjia ekuranha Philip-aka noa, noa inakala. John-alantama erinha tjatjatukala, “Nhanha itja arratja nama unta tjia ungkwanganhaka noa tnyinitjika.” Angkatja nhanhakakwiantama King Herod-ala tjapartia ekuranha ntjarranha turnaka John-anha errkutjika, erinha chain-ala yirnitjika, jail-aka turta kurnitjika. ");
INSERT INTO are_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias erataka John-aka yirrknga inthorra naka. Era turta antja naka erinha errilknga tutjika. Era pula erinha yarna errilknga tuka, Herod-ala erinha ntarntaramanga. ");
INSERT INTO are_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod-anhataka John-anga trerraka, era kaltja nakalanga John-anha artwa arratja, marra turta namanga. Herod-anha John-aka wothamawotha ntangkalhitjata erinha wutjika. John-aka angkatjala erinha rwampiilitjata, era pula kalantema ekura wotha ntangkalhitjata, erinha wutjika. ");
INSERT INTO are_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodias era pula kuta antja naka John-anha errilknga tutjika. Kurunga lakinhantama naka. Herod-ala tjinkarra urrkapuka, alkngerrintjaka arlta ekuranhaka ilpangkitjika. Era turta pmara Galilee-aka itornka ntjarra ntangkaka ekuralela tjinkarra ilkutjika. ");
INSERT INTO are_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Etna tjinkarra ilkumalanga, Herodias-aka kwarra pitjimala etnaka nthaperraka. Era etnanha kngarra arrkanilaka turta. Lakinhanga Herod-ala erinha pmarraka, “Iwunhakama unta antja? Kala nuka enkai.” ");
INSERT INTO are_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Altjirraka rretnyala era erinha lhelaka, “Unta paka pmara nukanhaka karta arrpunhaka antja namanga, atha nganha nhanha kala nthitjina.” ");
INSERT INTO are_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kwarra erantama rratamala mia ekuranhurna lhaka, erinha pmarraka turta, “Iwunhakama yinga Herod-aka enkitjika?” Mia ekurala erinha ilaka, “Herod-aka enkai John Kaltjirrpulhelanhelanhaka kapurtaka.” ");
INSERT INTO are_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kwarra era parrpa Herod-urna alpuka, erinha ilaka turta, “Yinga antja nama unta yinganha lyarta nhanha John Kaltjirrpulhelanhelanhaka kapurta nthitjika, taarnaka arrarnakala.” ");
INSERT INTO are_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nhanha wumala, Herod-anha porerraka. Era pula kwarra ekura kangkwerraka, era erinha itornka ntjarranga alkngatharra lhelakalanga. ");
INSERT INTO are_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lakinhanga era kala tjapartia nyinta yairnaka John Kaltjirrpulhelanhelanhaka kapurta inturnamala, kngitjalputjika. Artwa nhanha era jail-urna lhamala, era kala John Kaltjirrpulhelanhelanhaka kapurta inturnaka. ");
INSERT INTO are_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Erantama kapurta erinha taarnaka arrarnamala kngitjalpuka, nhanha kwarra erinha turta nthaka. Kwarra erantama nhanha mia ekuranha nthaka. ");
INSERT INTO are_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","John-aka kurtungurla ntjarrala nhanhiperra wumalanga, etna lhamala John-aka mpurrka inarlalpuka, nhanha wolkngaka turta kurnaka. ");
INSERT INTO are_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostle etna Jesuurna pitjalpukantama. Kurunga etna erinha ilaka, “Nurna kunha relha ntjarranha kaltjinthaka, nurna turta tjatjikarta urrkapuka untala nurnanha turnakala ngerra.” ");
INSERT INTO are_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Relha ntjarrala pula Jesuanha, kurtungurla ekuranha ntjarranha turta, porrkaporrka inthorrilaka. Jesua etnantama marnalka yarna ilkuka. Lakinhanga Jesuala kurtungurla ekuranha ntjarranha ilaka, “Mpa nurna worritjurna lhiai, kurrka iltjerramala nitjika.” ");
INSERT INTO are_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Boat-aka ntjimala, etna kala kwatjanga tjananhaka worritjurna. Etna itja relha nyintanha ilaka etna worritjurna lhamanga. ");
INSERT INTO are_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Relha lenha ntjarra pula, etnala etnanha lhamanga arakala, etna kala pmara erinha etarlaraka. Etnantama pmara ekururna arerraka. Etnakimparra turta pmara ekura erritjalhaka. ");
INSERT INTO are_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Boat-anga tnanpumala Jesuala worla kngarra etnanha araka. Etna sheep ntjarra ngerra naka, tnairnarintjakunya. Erantama etnaka konyerraka, etnanha kaltjinthaka turta. ");
INSERT INTO are_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kala ngurrangurrerrakalangantama, kurtungurla ekuranha ntjarra Jesuurna pitjimala erinha ilaka, “Arai, pmara nhanhataka worritja, relhakunya. ");
INSERT INTO are_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Lakinhanga unta relha ntjarranha kala yairnarlenai, town kurrka ntjarrurna lhitjika, marna initjika.” ");
INSERT INTO are_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesuala pula kurtungurla etnanha ilaka, “Rrangkarratitja etnanha marna ilkutjika nthai.” Etnantama erinha pmarraka, “Unta antja nama nurna marna kngarra inthorra buy-emilitjika, relha nhanha ntjarranha ntuthilitjika? Nurnaka pula money kurrka inthorranta.” ");
INSERT INTO are_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesuala etnanhantama pmarraka, “Marna nthakintjama rrakangkarra intama? Aritjika lhai.” Aramaliperra etna erinha ilaka, “Marna 5, irrpannga tharra turta.” ");
INSERT INTO are_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesualantama kurtungurla ekuranha ntjarranha ilaka, “Relha etnanha turnai worlamaworla tharrkakarlaka arrarnalhitjika. ");
INSERT INTO are_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Relha etnantama worlamaworla arrarnalhaka. Worla arrpunha ntjarra relha 100-akarta naka, kanha worla arrpunha ntjarra relha 50-akarta. ");
INSERT INTO are_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesualantama marna 5 etnanha, irrpannga tharranha turta inaka. Alkirurnathaka irnaramala, era Altjirranha dangkilaka. Kurunga era marna etnanha urltakaka. Erantama ungkwaltja etnanha kurtungurla ntjarranha nthetnaka relha ntjarraka errarnpalhelitjika. Irrpannga tharranha turta era urltakamala errarnpalhelaka. ");
INSERT INTO are_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kala relha ingkarraka inthorrala ilkuka. Itja nyinta paka ngaiyala naka. ");
INSERT INTO are_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ingkarna etna 12 basket lyulpalyulpilaka, marna pa irrpannga ungkwaltja etnanha kotjimala. ");
INSERT INTO are_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Arlta lenha ekurala artwa 5,000-ala marna ilkuka. ");
INSERT INTO are_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesualantama kurtungurla ekuranha ntjarranha turnaka etnakimparra boat-aka ntjitjika, ntjanganga tjananhitjika turta, pmara Bethsaida-urna. Era pula kuterraka, relha etnanha pmarurnarrka yairnarlenitjika. ");
INSERT INTO are_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Era relha etnanha kala yairnarlenakalangantama, Jesuanha partaka ntjika, Altjirrurna ingkitjika. ");
INSERT INTO are_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kala ngurrangurrerrakalangantama, Jesuanha nyintarinya naka partala, kanha kurtungurla ntjarra boat-alala naka, ntjanga mpopala. ");
INSERT INTO are_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesuala araka etna nakapakarlerramanga, wurinya ekarltala etnanha urlarranga twentjimanga. Kala ingutnhalantama, itjantema parrtjerrakalanga pula, Jesuanha etnakurna lhaka, kwatja kartninyala ingka lhamala. Era turta kala anpara lhitjikerraka. ");
INSERT INTO are_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kurtungurla ntjarrala erinha aramalanga, kwatja kartninyala urlarrathaka ingka pitjimanga, etna etarlaraka lthana kula pitjimanga. Etnantama ilkarlalhaka. ");
INSERT INTO are_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Etna ingkarrakala erinha araka. Etna ingkarraka trerraka turta. Jesuanha parrpa etnakurna angkaka, “Palkala thakerritjala. Yingiai.” ");
INSERT INTO are_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jesuanhantama boat-aka ntjika, etnakalela nitjika. Wurinya ekarlta era turtantama yirraka. Kurtungurla ntjarra pula tnolkaka, yarna turta eterritjikerraka. ");
INSERT INTO are_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Etnataka marntilparla wara naka, etna nhanga tjatjikarta marniperra itja lhangkarakalanga warta. ");
INSERT INTO are_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ntjanga ekuranga tjananhamala, Jesuanha, kurtungurla ekuranha ntjarra turta, pmara Gennesaret-aka erritjalhaka. Etnantama boat erinha irnakarlaka yirnaka. ");
INSERT INTO are_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Etna boat ekuranga tnanpumalanga, relha ntjarrala Jesuanha lhangkaraka. ");
INSERT INTO are_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Relha nhanha etnantama parrpa pmara etnakanhurna arrtjanaka, relha menta ntjarranha turta Jesuurna kngitjika. Etna menta etnanha ntjamala intamala kuta kngitjika. Jesuanha paka pmara arrpunhurna lhamanga, etna kala menta etnanha pmara lenhurnantama kngaka. ");
INSERT INTO are_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesuanha paka town kurrkurna, town kngarrakngarrurna, town-anga kathurna paka lhamanga, relha ntjarrala relha menta etnakanha ekururna kngitjikantema. Menta etnantama Jesuurna ingkaka, “Nurnanha impurlarrarnai mantarra ungkwanganha anputjika.” Relha menta etnala mantarra ekuranha anpuka, etna kala marrerraka. ");
INSERT INTO are_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kurunga artwa Pharisee urrputja, artwa Intarrangaltha urrputja turta Jesuurna pitjika, Jerusalem-anga. ");
INSERT INTO are_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Etna araka Jesuaka kurtungurla arrpunha ntjarrala marna ilkumanga. Etna turta araka etna itja iltja ilkngilhakalarrka, Moses-ala turnakala ngerra. ");
INSERT INTO are_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Arai, artwa Pharisee ntjarrala, relha Jew ingkarrakala turta, iltja etnakanha ilkngilhamalanta marna ilkutjata. Nhanha kunha kngarripata etnakanhaka mpaarangaranga naka. ");
INSERT INTO are_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Etna marna shop-anga buy-emilakalanga, etna ilkngilhitjatantema, marna erinha ilkutjinala. Etna turta tjampitalka etnakanha kutatha ilkngitjatantema. ");
INSERT INTO are_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Artwa Pharisee ntjarrala, artwa Intarrangaltha ntjarrala turtantama Jesuanha pmarraka, “Iwunhangala kurtungurla ungkwanganha ntjarrala marna ilkuma, iltja ilkngilhitjikanha? Iwunhanga turtama etna kngarripata ntjarraka mpaarangarangaka itja kangkwerrama?” ");
INSERT INTO are_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesuala etnanha ilaka, “Pmatha ntjarrai, rrakangkarriperra inthorrataka Altjirranha nhanga Isaiah-arlarlanga angkaka, ‘Relha nhanha ntjarrala yinganha tnantjama angkatja etnakanhala, etna pula nuka itja kangkwerrama. ");
INSERT INTO are_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Etna nuka urrkurrkintja namalanga, etna orrtjerrama wara. Etna itja relha arrpunha ntjarranha turnintja nukanha kaltjinthama, relhaka mpaarangaranganta wara pula.’ ");
INSERT INTO are_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Rrangkarra Altjirraka turnintjaka itja kangkwerrama. Relhaka mpaarangarangaka pula rrangkarra kangkwerramala.” ");
INSERT INTO are_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesuala etnanha nhanha turta ilaka. “Rrangkarra kunha Altjirraka turnintja ipmintja impuma, relhaka mpaarangarangaka kangkwerritjinala. ");
INSERT INTO are_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Arai, Moses-arlarlanga Altjirrala rrangkarranha turnaka, ‘Unta kaarta pa mia ungkwanganhaka kangkwerritjika’. Nhanha turta, ‘Relha erala kaarta ekuranha, mia ekuranha paka arrampowumanga, erinha rrangkarra errilknga tutjika.’ ");
INSERT INTO are_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kanha rrangkarra relha ntjarranha lakinhala ilama. Thunga relhala kaarta pa mia ekuranha ilama, ‘Arai, marna, yulthalka nhanha ‘Corban’ nama. Nhanhatitja, atha nhanha Altjirranha lhelakala. ");
INSERT INTO are_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kurunga rrangkarra relha erinha ilama nhanha kala marra namanga. Lakinha rrangkarra erinha parrama kaarta pa mia ekuranhaka tangitjala nitjika. ");
INSERT INTO are_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lakinha rrangkarra Altjirraka turnintja ipmintja impuma, relhaka mpaarangarangaka kangkwerritjinala. Altjirraka turnintja arrpunha ntjarra turta rrangkarra lakinhantema ipmintja impuma.” ");
INSERT INTO are_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesualantama relha ntjarranha wotha worlilaka. Era etnanha ilaka, “Nhanha wai, lhangkarai turta. ");
INSERT INTO are_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Relhala marnalka rrakartala ilkuma. Marnalalka pula relhanha yarna Altjirranga urlarra kornilama. Angkatja korna etnala relhaka rrakartanga rratama, etnataka relhanha Altjirranga urlarra kornilama.” ");
INSERT INTO are_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesuanha, kurtungurla ekuranha ntjarra turta kala ilthakantama irrpukalanga, relha worla etnanha impurlalhamala, kurtungurla ntjarrala Jesuanha pmarraka, “Nurnaka nentilai yia untala lyarta ilakala.” ");
INSERT INTO are_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Erantama etnanha pmarraka, “Yai, rrangkarrenpama marntilparla? Etarlarai, marna rrangkarrala ilkuma, marna nhanhala rrangkarranha yarna Altjirranga urlarra kornilama. ");
INSERT INTO are_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Marna nhanha itja etarlingetarlurna irrpuma, tnarturna pula. Kurunga nhanha kala mpurrkanga rratanhamantama.” Lakinha angkamala Jesuala antja naka etnanha ilitjika marna ingkarraka marra namanga ilkutjika. ");
INSERT INTO are_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Arai,” Jesuala etnanha ilaka, “Angkatja pula relhaka eterrintjangala rratama. Angkatja korna etnantama relhanha Altjirranga urlarra kornilama. ");
INSERT INTO are_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Relha kunha paala eterrama. Paala eterramalantama era ntaiyawuma, nyilkngala inama, errilknga tuma, ");
INSERT INTO are_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","arrpunhaka noalela intama, yulthaka kngarra lherrama, ekuriltja eterrama, orrtjerrama, kerrintjakunya nama, iltama, arrampowuma, tjurnalhama, rirtarirta turta ntelalhama. ");
INSERT INTO are_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lherrintja korna ingkarrakataka relhaka eterrintjanga rratama. Etnantama relhanha Altjirranga urlarra kornilama.” ");
INSERT INTO are_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pmara lenhanga, Jesuanha pmara Tyre-anga kuturnantama lhaka. Erantama iltha nyintaka irrpuka, relha ntjarranga lauwulhamala. Era pula yarna kuta lauwulhaka. ");
INSERT INTO are_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Arrkutja nyinta, kwarra ekurala enka kornakarta nakala, era wuka Jesuanha pitjikala. Era parrpa inthorra Jesuurna lhaka, ekuranga urlarra mparalela arrarnalhaka turta. ");
INSERT INTO are_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Arrkutja nhanha era Greece-arinya naka, pmara Phoenicia-ala alkngerrakala. Phoenicia erataka pmara Syria-ala naka. Arrkutja erantama Jesuurna ingkaka era enka korna erinha kwarra ekuranhanga unputjika. ");
INSERT INTO are_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesuala pula erinha ilaka, “Nukathaka nama katjia ntjarranhakimparra marnala ntuthilitjika. Nhanha itjama arratja namara katjiaka marna kngulya ntjarranha nthitjika.” ");
INSERT INTO are_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Arrkutja era pula erinha ilaka, “Ingkartai, unta kala arratja angkama. Kngulya etna pula ungkwaltja etnanha ilkumantemala, ungkwaltja nhanga katjialala ipmintja impuka.” ");
INSERT INTO are_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesualantama erinha ilaka, “Unta kunha arratja angkaka. Kala alpai. Enka korna era kala kwarra ungkwanganhanga rrataka.” ");
INSERT INTO are_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Alpumala, era kwarra ekuranha aritjalhaka kunpa ntjamala intamanga. Enka korna era kala ekuranga lhakala. ");
INSERT INTO are_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesuanha Tyre ekuranga wotha anparerraka. Erantama Sidon-anga, pmara Decapolis-anga turta tjananhamala, Galilee-urna pitjika. ");
INSERT INTO are_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pmararinya ntjarralantama artwa nyinta ekururna kngitjika. Artwa era rirta naka, yarna turta angkaka. Etnantama Jesuurna ingkaka era iltja ekuranha ekurakarlaka arrarnitjika. ");
INSERT INTO are_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesualantama artwa erinha worlanga rratalhelaka, eratharrarrpa nitjinanga. Kurunga era iltja kantja ekuranha ilpa ekuranhaka kurnaka. Era palha turta iwumala, nhanha artwa ekura linyaka arrarnaka. ");
INSERT INTO are_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Alkirurnathaka irnaramalantama, Jesuala artwa erinha mpangkamala ilaka, “Ephphatha,” nhanhatitja, “Altjurerrai.” ");
INSERT INTO are_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Artwa erantama kala irrpalthala wuka, angkaka turta. ");
INSERT INTO are_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesualantama relha ntjarranha turnaka, etna itja inthorra relha arrpunha ntjarranha nhanhiperra alpmelitjika. Etna pula ekura itja kuta kangkwerraka. Era warta etnanha parralanaka, kanha etna yia erinha arrpunha ntjarranha wothamawotha alpmelaka. ");
INSERT INTO are_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Relha etnataka Jesuiperra kngarra tnolkaka. Etnantama ilarraka, “Era kunha tjatjikarta urrkapumala, relhaka tangitjala nama. Era relha rirtanha, relha angkitjikanhanha turta marrilama.” ");
INSERT INTO are_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Arrpunharanga, relha ntjarra wothantema Jesuurna worlerrentjalpuka. Marna etnaka kala yirrakalangantama, Jesuanha kurtungurla ekuranha ntjarraka ntangkalhaka, etnanha ilaka turta. ");
INSERT INTO are_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Arai, yingataka relha nhanha ntjarraka konyerrama. Etna kala arlta tharraminyintantama nukalela nakala, marnakunya. ");
INSERT INTO are_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Atha paka etnanha lyarta ngaiyala pmarurna yairnarlalpumanga, etna tjaiyala nakapakarlerritjina. Arrpunha ntjarra kunha pmara ilanganga pitjikala.” ");
INSERT INTO are_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kurtungurla ekuranha ntjarrala pula erinha ilaka, “Pmara nhanhataka worritja. Nthanhalama nurna marna arltaramara relha nhanha ntjarranha ntuthilitjika?” ");
INSERT INTO are_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Erantama etnanha pmarraka, “Marna nthakintjama rrakangkarra intama?” Etna angkaka, “Marna kurrka 7.” ");
INSERT INTO are_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesualantama relha worla etnanha turnaka arnaka arrarnalhitjika. Kurunga era marna 7 etnanha inamala, Altjirranha dangkilaka. Kurunga marna etnanha urltakamala, era marna ungkwaltja etnanha kurtungurla ntjarranha nthaka, relha ntjarraka errarnpalhelitjika. ");
INSERT INTO are_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Etnaka irrpannga urrputja turta intaka. Erantama Altjirranha irrpannga etnaka dangkilaka, etnanha turta kurtungurla ntjarranha nthaka errarnpalhelitjika. ");
INSERT INTO are_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Relha ntjarralantama marna pa irrpannga ilkuka, nhalkerraka turta. Ingkarna etna 7 basket lyulpalyulpilaka, marna nhanga ipmintjerrakala kotjimala. ");
INSERT INTO are_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Relha etnala marna ilkukala etna kala 4,000 ngerra naka. Jesuala relha etnanha kala pmarurnantama yairnarlenaka. ");
INSERT INTO are_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kurunga era boat-aka kala ntjilalhakanta, kurtungurla ekuranha ntjarrakarta. Ntjanga ekuranga tjananhamala, era kala pmara Dalmanutha-aka erritjalhaka. ");
INSERT INTO are_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Artwa Pharisee ntjarrantama pitjika Jesualela iwurritjika. Etnantama erinha arrkarnamala ilaka, “Tjatjikarta alkirarinya nurnaka ntelai.” ");
INSERT INTO are_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesuanha mpangkaka. Erantama etnanha pmarraka, “Iwunhangama rrangkarra yinganha kutatha ilama rrangkarranha tjatjikarta ntelitjika? Atha rrangkarranha nhanha nthurrpa ilama, atha rrangkarranha itja kuta tjatjikarta ntelitjina.” ");
INSERT INTO are_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Erantama etnanha impurlalhaka. Wotha boat-aka ntjimala, era ntjanganga tjananhaka turta. ");
INSERT INTO are_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Boat-aka ntjitjinala, kurtungurla ntjarrataka marna arrpunhaka kngwerralalhaka. Lakinhanga etna marna nyintakartanta boat-aka ntjilalhaka. ");
INSERT INTO are_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Etna lhapalhamalangantama, Jesuala etnanha lhalaramala ilaka, “Rrangkarrataka artwa Pharisee ntjarraka, Herod-aka marna ltorlpilanhanga turta aralhitjika.” ");
INSERT INTO are_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kurtungurla ntjarrantama nhanhiperra angkarraka, lakinha ilarramala, “Erataka nurnanha lakinha ilaka, nurna marna arrpunhaka kngwerrakalanga.” ");
INSERT INTO are_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesuanha kala kaltja naka angkatja etnala angkarramalaka. Erantama etnanha pmarraka, “Iwunhangala rrangkarra marniperra angkarrama? Rrangkarra itjantema angkatja nukanha lhangkarama? Rrangkarra marntilparla kutakwia? ");
INSERT INTO are_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Rrangkarra kunha alkngakarta. Iwunhangantama rrangkarra yarna arama? Rrangkarra kunha ilpakarta? Iwunhangantama rrangkarra yarna wuma? Rrangkarra marna nhangiperra kngwerrakama? ");
INSERT INTO are_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Basket nthakintjama rrangkarra marna ungkwaltjakarta lyulpalyulpilaka, atha nhanga artwa 5,000 ntuthilamanga marna 5-ala?” Etna erinha ilaka, “12 kunha.” ");
INSERT INTO are_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesuala etnanha wotha pmarraka, “Basket nthakintjama rrangkarra marna ungkwaltjakarta lyulpalyulpilaka, atha nhanga relha 4,000 ntuthilamanga marna 7-ala?” Etna erinha ilaka, “7 kunha.” ");
INSERT INTO are_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Erantama etnanha pmarraka, “Iwunhiperrama yinga angkama? Rrangkarra itjantema angkatja nukanha marna ltorlpilanhiperra lhangkarama?” ");
INSERT INTO are_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesuanha, kurtungurla ekuranha ntjarra turtantama Bethsaida-urna pitjika. Pmararinya ntjarralantama artwa panga nyintanha Jesuurna kngitjika. Etna Jesuurna ingkaka turta era artwa panga erinha anputjika. ");
INSERT INTO are_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Artwa erinha iltjanga errkumala, Jesuala erinha town-anga kathurna rretjingaka. Erantama alknga ekuranhaka palha iwuka. Iltja ekuranhantama ekurakarlaka arrarnamala, era artwa panga erinha pmarraka, “Unta paka aramama?” ");
INSERT INTO are_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kapurta kartnerramala artwa era angkaka, “Atha relha ntjarranha arama, errkaiyerrkaiya wara pula.” ");
INSERT INTO are_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesualantama wothantema iltja ekuranha alknga ekuranhaka arrarnaka. Alknga ekuranha kala marrerrakantama, era turta kala kathantama araka. ");
INSERT INTO are_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesualantama erinha ilaka, “Kala iltha ungkwanganhurna alpai. Unta pula itja town-urna lhitjika.” ");
INSERT INTO are_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesuanha, kurtungurla ekuranha ntjarra turtantama town kurrka ntjarrurna anpara lhaka, town nhanga etnala pmara Caesarea Philippi-anga etinya namanga. Etna nhanga lhapalhamanga Jesuala kurtungurla ekuranha ntjarranha pmarraka, “Ngunhama relha ntjarrala ilama yinga kula namanga?” ");
INSERT INTO are_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kurtungurla etna erinha alpmelaka, “Arrpunha ntjarrala ilama unta kula John Kaltjirrpulhelanhelanha namanga. Arrpunha ntjarrala ilama Elijah. Kanha arrpunha ntjarrala ilama Altjirraka urrpia arrpunhala.” ");
INSERT INTO are_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesuala etnanha wotha pmarraka, “Kanha rrangkarraloa? Rrangkarra nukiperra nthakinhala etarlarama? Ngunha inthorrama yinga nama?” Peter-ala erinha alpmelaka, “Unta nama Krista era.” ");
INSERT INTO are_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesualantama etnanha tjatjatuka, etna itja inthorra relha arrpunhanha ilitjika era Krista era namanga. ");
INSERT INTO are_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kurunga Jesuala kurtungurla ekuranha ntjarranha kaltjinthaka, nhanha Relhaka ‘Lirakathaka namanga nyingalauwutjika. Era etnanha kaltjinthaka kngarripata ntjarra, priest-aka itornka ntjarra, artwa Intarrangaltha ntjarra turta ekura antjakunyerritjinala, etna turta erinha errilknga tutjinala. Era etnanha kaltjinthaka turta era arlta tharraminyinta errilknga intamaliperra, wotha etatha kamerritjinala. ");
INSERT INTO are_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Era etnanha nhanha ingkarraka katha inthorra kaltjinthaka. Peter-alantama Jesuanha etapurna rretjingamala, rralthaka. ");
INSERT INTO are_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ilkngaralhamala, kurtungurla arrpunha ntjarrala turta erinha wutjinanga, Jesuala Peter-anhatitjantama rralthaka. Era erinha ilaka, “Nukanga lhai, Satan-ai. Unta kunha itja Altjirra ngerra eterrama, relha ngerra pula.” ");
INSERT INTO are_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kurunga Jesuala relha worla etnanha, kurtungurla ekuranha ntjarranha turta ntangkaka, ekururna etinyerritjika. Erantama etnanha ilaka, “Thunga relha antja nama nukanga tnaartangala pitjitjika. Nthakinhantama era ntelalhitjika? Era itja wotha eterrintja ekuranhaka kangkwerritjika. Era pula ntolka ekuranha tjurnamala kngitjika, athala ntolka nukanha kngamanga ngerra. Kurunga era nukanga tnaartangala pitjitjika. ");
INSERT INTO are_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Arai, relha erala thakerrama kala etatha nitjikanta, era kala ilutjina. Kanha relha erala relha arrpunha ntjarranha impurlarrarnamanga erinha errilknga tutjika nukakwia, Yia Marrakakwia turta, era kala ngampakalala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Thunga relhala alha nhanhaka yultha ingkarraka inthorra patilama, Altjirranha etarlaritjikanha. Erantama anma iluma. Nthakinhantama era nitjina? Era itja ngampakala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Relhala turta yarna Altjirranha money nthama, Altjirrala erinha pmara ekuranhaka irrpulhelitjika, era Altjirraka pmaralantama ngampakala nitjinanga. ");
INSERT INTO are_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Arai, relha arrpunha ntjarra lyarta Altjirraka itja kangkama. Etna relha korna nama. Lakinhanga thunga relha arrpunha errakarrerrama nukiperra alkngatharra angkitjika, relha korna etnanha angkatja nukanha alpmelitjika paka. Relha erala nuka errakarrerrama, era anma nthakinherritjina? Relhaka ‘Lira era pitjalpumanga, era relha ekura errakarrerritjinantema. Relhaka ‘Lira era kunha anma pitjalputjina Kaartala erinha ekarltilakangantama. Era turta angel alkngaltara ntjarrakarta pitjitjina. ");
INSERT INTO are_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesuanha angkaka, “Atha rrangkarranha nhanha nthurrpa ilama. Relha arrpunha ntjarra etnala lyarta nhanhala nama, etna katha aritjina Altjirranha relha ingkarrakaka Ingkarta namanga, etna ilutjikanhangantema.” ");
INSERT INTO are_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Etna kala arlta 6 nakalangantama, Jesuala Peter-anha, James-anha John-anha turta ntangkaka. Erantama etnakakarta parta kartninyaka ntjika, etnarrpa nitjika. Altjirralantama Jesuanha etnakanga alkngatharra kngartiwuka. ");
INSERT INTO are_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jesuaka mantarrantama tjulkuka inthorra. Relhala yarna mantarra tjulkura lakinha ngerra mpaaramara. ");
INSERT INTO are_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kurunga Moses Elijah tharrantama rumerraka, Jesualela angkarraka turta. ");
INSERT INTO are_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter-alantama Jesuanha ilaka, “Kaltjinthanhinthanhai, nurnataka kangkama pmara nhanhala nitjika. Unta paka antja namanga, nurna kala lyuntja tharraminyinta itamara, ungkwanga nyinta, Moses-aka nyinta, Elijah-aka nyinta.” ");
INSERT INTO are_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kurtungurla etnataka trerraka inthorra. Lakinhanga Peter-anha marntilparla wara angkaka. ");
INSERT INTO are_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mataralantama etnanha korltanhaka. Matara ekurangantama etna Altjirranha angkamanga wuka, “Nhanha kunha ‘Lira nuka. Yinga ekura kangkama. Rrangkarra kala ekura kangkwerritjika.” ");
INSERT INTO are_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ilkngaralhamalantama etna araka Jesua eranta itnamanga. ");
INSERT INTO are_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Etna partanga tnanpentjimangantama, Jesuala etnanha tjatjatuka etna itja inthorra relha arrpunhaka ilitjika, nhanga etnala arakala. Anmanta wara etna yia nhanha ilitjika, Relhaka ‘Lira era kala errilknga ntjarranga kamerrakalangantama. ");
INSERT INTO are_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Etna kala Jesuaka kangkwerraka. Etna pula pmarrarraka, “Iwunhama nhanha erala ilakala era kula errilknga ntjarranga kamerritjinala?” ");
INSERT INTO are_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kurtungurla etnantama Jesuanha pmarraka, “Iwunhangama artwa Intarrangaltha ntjarrala ilama Elijah-anhakimparra pitjitjika, kurunganta Kristanha?” ");
INSERT INTO are_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesuala etnanha ilaka, “Nthurrpa Elijah-anhakimparra pitjitjika, relha ingkarrakanha arratjilitjika. Iwunhanga pula Altjirraka Angkatja Imankinyala ilama Relhaka ‘Lira era kngarra nyingalauwutjika, relha ntjarra turta ekura antjakunyerritjika? ");
INSERT INTO are_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Arai, atha rrangkarranha nthurrpa ilama, Elijah-anha kala pitjika. Relha ntjarra turta ekura irrpaltherraka, Altjirraka Angkatja Imankinyala ilakala ngerra.” ");
INSERT INTO are_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesuanha, kurtungurla tharraminyinta nhanga turtantama kurtungurla arrpunha ntjarrurna pitjalpuka. Etnantama araka relha worla kngarra kurtungurla arrpunha etnakalela itnamanga, kurtungurla etna turta artwa Intarrangaltha ntjarralela iwurramanga. ");
INSERT INTO are_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Relha ntjarrala Jesuanha aramalanga, etna tnolkarlalhaka. Etnantama ekururna parrpa arrtjanaka. ");
INSERT INTO are_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Erantama etnanha pmarraka, “Iwunhiperrama rrangkarra angkatjala iwurrama?” ");
INSERT INTO are_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Relha nyintalantama Jesuanha ilaka, “Kaltjinthanhinthanhai, athataka worra nukanha ungkwangurna kngitjika, era enka kornakarta namanga, yarna turta angkamanga. ");
INSERT INTO are_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Enka korna nhanha era worra nukanha errkumalanga, era erinha arnaka ilatuma. Rrakarta ekurantama alkurrpalpurrkerrama, era itetja kakulhama, era errirterrama turta. Yingantama kurtungurla ungkwanganha ntjarrurna ingkaka etna enka korna erinha worra nukanhanga unputjika. Etna pula enka korna erinha yarna kuta unpuka.” ");
INSERT INTO are_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesuala etnanha ilaka, “Rrangkarrataka arrthata, rrangkarra turta Altjirranha itja tnakama. Kuta inthorrama yinga rrakangkarralela nitjika, rrangkarranha kaltjinthitjika turta? Rrangkarrataka yinganha porrkaporrkilama. Worra erinha nukurna kngitjai.” ");
INSERT INTO are_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Etna worra erinha Jesuurna kngitjika. Enka korna era warta Jesuanha araka, kanha era worra erinha arnakarlakala ilatuka. Worra erantama arnala iwulhalapuka, rrakarta ekura turta alkurrpalkurrperraka. ");
INSERT INTO are_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesualantama worraka kaarta erinha pmarraka, “Ilangara inthorrama worra era lakinherraka?” Artwa era angkaka, “Katjia kurrkangatjina kunha era lakinha nentjika. ");
INSERT INTO are_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ntjarraranga enka korna era worra erinha errilknga tutjika antja naka, erinha uraka iwumala, kwatjaka turta. Ilirnaka konyerrai, ilirnaka tangitjala nai turta. Unta paka enka korna erinha irrpalthala unpumarama?” ");
INSERT INTO are_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesuala pula erinha pmarraka, “Iwunhangala unta yinganha ilpoiwumala pmarrama, ‘Unta paka enka korna erinha irrpalthala unpumarama?’ Relha erala Altjirranha tnakama, Altjirrala erinha ekarltilama enka korna turta unputjika.” ");
INSERT INTO are_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Worraka kaartalantama Jesuanha angkatja intarrala ilaka, “Atha Altjirranha yarna ngerrantema tnakama. Nuka tangitjala nai atha erinha ekarltalkura tnakitjinanga.” ");
INSERT INTO are_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesuala arakantama relha ntjarra worlerrentjimanga. Erantama enka korna erinha rralthamala unpuka. “Enka kornai, untala worra nhanha erinha rirtilama, erinha angkitjika turta parrama, atha nganha ilama ekuranga rratai! Atha turta nganha parrama unta itja wotha worra ekururna irrputjika.” ");
INSERT INTO are_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ilkarlalhamala, worra erinha turta arnaka ilaturlalhamala, enka korna era kala worra ekuranga rrataka. Worra erantama errilknga ngerra intaka. Ntjarra arrpunhantama angkaka, “Era kunha kala iluka.” ");
INSERT INTO are_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesuala pula worra erinha iltjanga errkumala, erinha wotha ingkaka ingkairnaka. ");
INSERT INTO are_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Anma, Jesuanha kala ilthaka irrpukalangantama, etnanta turtantama namalanga, kurtungurla ntjarrala erinha pmarraka, “Iwunhangama nurna enka korna erinha yarna unpuka?” ");
INSERT INTO are_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesuala etnanha ilaka, “Relhala enka korna lakinha ngerra yarna unpuma, Altjirrurna ingkamalanta wara.” ");
INSERT INTO are_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Anparerramala, Jesuanha, kurtungurla ekuranha ntjarrakarta Galilee-anga tjananhaka. Jesuanha pula itja antja naka relha arrpunha ntjarra kaltja nitjika pmara erala namalaka. ");
INSERT INTO are_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Erataka kurtungurla ekuranha ntjarranha kaltjinthalanaka. Era etnanha ilaka. “Arai, etnataka Relhaka ‘Lira erinha leltjaka lanthitjina. Etna erinha errilknga tutjina. Arlta tharraminyinta errilknga intamaliperra pula, era wotha kamerritjina.” ");
INSERT INTO are_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kurtungurla ntjarrala pula Jesuaka angkatja itja lhangkaraka. Etna pula trerraka erinha kuta pmarritjika. ");
INSERT INTO are_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesuanha, kurtungurla ekuranha ntjarra turtantama Capernaum-akerritjalhaka. Iltha ekuranhurna irrpunhamala, Jesuala kurtungurla ekuranha ntjarranha pmarraka, “Iwunhiperrama rrangkarra tjaiyala iwurraka?” ");
INSERT INTO are_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Etna pula tjukunya naka. Etna itja antja naka erinha ilitjika etna nhanga pmarrarrakala, “Nurnakanga ngunhama arrpunha ntjarraka itornka nitjina?” ");
INSERT INTO are_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Arrarnalhamala, Jesuanha 12 etnaka ntangkalhaka. Erantama etnanha ilaka, “Relha erala relha arrpunha ntjarraka itornka nitjika antja, era itja tjurnalhitjika, era turta arrpunha ntjarraka kngarralkura tangitjala nitjika.” ");
INSERT INTO are_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesuala katjia nyintantama inaka. Katjia erinha etnakanga mpopaka ingkairnamala, era katjia erinha kwakitjakaka. Kurunga era etnanha ilaka, ");
INSERT INTO are_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Relha erala katjiaka kangkintja ntelalhama, yinganha etarlaramala, era nuka kangkintja ntelalhama. Relha erala nuka kangkintja ntelalhama, era kala ekura kangkintja ntelalhama, erala yinganha yairnakala.” ");
INSERT INTO are_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John-ala Jesuanha ilaka, “Kaltjinthanhinthanhai, nurna artwa nyintanha araka enka korna ntjarra relha ntjarranga unpumanga, rretnya ungkwanganhala. Nurnantama erinha parraka, era itja worla nurnakanhanga nakalanga warta.” ");
INSERT INTO are_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesuala pula etnanha ilaka, “Rrangkarra erinha itja parritjika. Arai, relha erala rretnya nukanhala tjatjikarta urrkapuma, era itja nukiperra parrpa korna angkitjina. ");
INSERT INTO are_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Arai, relha erala nurnaka irrpaltherritjikanha, era kala nurnaka tjina nama. ");
INSERT INTO are_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Relha erala rrangkarranha kwatja ntjutjika nthama, yinganha etarlaramala, rrangkarra turta kurtungurla nuka namanga warta, Altjirrala erinha kala kwartiwutjina.” ");
INSERT INTO are_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Arai, relha erala tnakanhakanha nyintanha arrtjilhelamanga korna ntelalhitjika, erinha Altjirrala nakapakarlilitjina. Ekura kala marralkura namara, arrpunhala paka tnyana kngarritja turrkura ekuranhaka ilparanakalanga, erinha kwatja iparta inthorraka iwukalanga turta. ");
INSERT INTO are_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Thunga iltja ungkwanganhala nganha korna ntelalhitjika arrtjilhelama. Iltja erinha inturnai. Nhanha marralkura nama unta Altjirraka pmarurna irrputjika iltja nyintakartanta, nhanhangatjina, Altjirrala nganha iltja tharrakarta tatharrurna iwutjika. Tatharra ekurala kunha ura era itja kuta ilurnalhama. ");
INSERT INTO are_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Thunga ingka ungkwanganhala nganha korna ntelalhitjika arrtjilhelama. Ingka erinha inturnai. Nhanha marralkura nama unta Altjirraka pmarurna irrputjika ingka nyintakarta, nhanhangatjina, Altjirrala nganha ingka tharrakarta tatharrurna iwutjika. ");
INSERT INTO are_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Thunga alknga ungkwanganhala nganha korna ntelalhitjika arrtjilhelama. Alknga erinha urlpuntjai. Nhanha marralkura nama unta Altjirraka pmarurna irrputjika alknga nyintakarta, nhanhangatjina, Altjirrala nganha alknga tharrakarta tatharrurna iwutjika. ");
INSERT INTO are_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tatharra ekurala mpaara etna itja iluma, ura era turta itja ilurnalhama. ");
INSERT INTO are_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Priest-ala peinta kara tjauwerrilyaka arrarnama, Altjirranha tjauwerrilyaka kangkitjinanga. Nurna Altjirranga urlarra arratja ntelalhamanga, nurna peinta nhanha ngerra nama. ");
INSERT INTO are_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Peinta kunha marra nama. Thunga pula peinta era kornerraka. Relhala erinha yarna wotha marrilama. “Peintala kunha karalka kumiilama. Rrangkarra peinta ngerra ntelalhitjika. Nhanhatitja rrangkarra kangkintja urlarrakurlarra ntelalhitjika, rilhera turta.” ");
INSERT INTO are_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Anparerramala, Jesuanha pmara Judea-urnantama lhaka, Jordan Lhiranga urntwarrampinyurna. Relha ntjarra ekururna wothantema worlerrentjalpuka. Erantama etnanha kaltjinthaka, erala relha ntjarranha kaltjinthitjata ngerra. ");
INSERT INTO are_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Artwa Pharisee urrputjantama ekururna pitjika, erinha arrkarnitjika. Etna erinha pmarraka, “Nhanha arratjama nama mpanya ilutjika?” ");
INSERT INTO are_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesuala etnanha pmarraka, “Iwunhama Moses-ala rrangkarranha turnaka?” ");
INSERT INTO are_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Etna erinha ilaka, “Moses-ala artwanha impurlarrarnaka noa ekuranha imputjika erinha kala pepanta nthamala angkatja nhanhakarta, ‘Yinga kala ungkwanganga unpulhakantama.’” ");
INSERT INTO are_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesuala pula etnanha ilaka, “Moses-ala rrangkarranha impurlarrarnaka noa rrakangkarranha imputjika, rrangkarra arrthata warta namanga. ");
INSERT INTO are_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Altjirrala pula relhanha arrpmarnamalanga, era etnanha orrea marla turta arrpmarnaka. ");
INSERT INTO are_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Lakinhanga artwala kaarta pa mia ekuranha impurlalhamala noa ekuranhalelantama kuterrama. ");
INSERT INTO are_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Noarta eratharra turtantama kala mpurrka nyinterritjina. Lakinhanga eratharra itja wotha tweta nama, nyinta pula. ");
INSERT INTO are_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Relhalantama itja ilkngakitjika nhanga Altjirralala nyintalhelakala.” ");
INSERT INTO are_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jesuanha, kurtungurla ekuranha ntjarra turta wotha ilthala namalanga, kurtungurla ntjarrala erinha nhanhiperra pmarraka. ");
INSERT INTO are_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesuala etnanha ilaka, “Artwa erala noa ekuranha unpuma, arrkutja arrpunha turtantama noa inama, era kala korna mpaarama. ");
INSERT INTO are_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Arrkutja erala noa ekuranha impuma, artwa arrpunha turtantama noa inama, era kala korna mpaaramantema.” ");
INSERT INTO are_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Relha ntjarrala katjia etnakanha Jesuurna kngitjika, Jesuala iltja ekuranha kapurta etnakanhaka arrarnitjika. Jesuaka kurtungurla ntjarrala pula etnanha unpurlenaka. ");
INSERT INTO are_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nhanha aramala, Jesuanha kurtungurla ekuranha ntjarraka yirrkngerraka, etnanha ilaka turta, “Katjia etnanha parritjala impai. Yinga antja etna nukurna pitjitjika, Altjirranha antja namanga ntelalhitjika era Ingkarta etnaka namanga. ");
INSERT INTO are_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Arai, atha rrangkarranha nhanha nthurrpa ilama. Rrangkarra Altjirranha itja tnakamanga katjiala ngerra, Altjirranha itja kuta rrakangkarra ntelalhitjina era Ingkarta rrakangkarra namanga.” ");
INSERT INTO are_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Erantama katjia nyintaminyintanha nortaka tjurnaka, era iltja ekuranha kapurta etnakanhaka arrarnaka, nyintaminyintanha lyekarrilaka turta.” ");
INSERT INTO are_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesuanha wotha anparerraka. Artwa nyintantama ekururna arrtjanentjika, ekuranga urlarra mparalela arrarnalhaka turta. Erantama Jesuanha pmarraka, “Kaltjinthanhinthanha unta kunha artwa marra. Untantama yinganha ilai, Nthakinhama yinga ntelalhitjika, yinga Altjirraka pmarala ngampakala etatha nitjinanga?” ");
INSERT INTO are_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesuala erinha pmarraka, “Iwunhangala unta ilama yinga kula artwa marra namanga? Altjirra nyintanta kunha marra. ");
INSERT INTO are_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Arai, unta kala Altjirraka turnintjaka kaltja. ‘Unta itja relha arrpunhanha errilknga tutjika.’ ‘Unta itja relha arrpunhaka noalela intitjika.’ ‘Unta itja relha arrpunhaka yultha nyilkngala initjika.’ ‘Unta itja relha arrpunhiperra orrtjerritjika.’ ‘Unta itja relha arrpunhanha orrtjapepilitjika.’ ‘Unta kaarta pa mia ungkwanganhaka kangkwerritjika.’” ");
INSERT INTO are_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Era Jesuanha ilaka, “Kaltjinthanhinthanhai, yinga pula turnintja nhanha ingkarrakaka kangkwerraka kurrkangatjina.” ");
INSERT INTO are_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesuala erinha intarra araka, ekura kangkaka turta. Erantama erinha ilaka, “Nyintantantama ungkwangathaka nama. Yultha ingkarraka ungkwanganha yirrinthai, money erinha turtantama relha ilkngara ntjarranha nthai. Kurunga ungkwanga yultha kngarra alkirala intitjina. Unta turtantama nukanga tnaartangala pitjai.” ");
INSERT INTO are_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nhanha wumala artwa era ltarrperraka, alpuka turta. Erataka netaneta inthorra naka. ");
INSERT INTO are_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesuala kurtungurla ekuranha ntjarranhantama tjoraramala ilaka, “Arai, relha netanetaka kunha inpora inthorra nama Altjirraka pmarurna irrputjika.” ");
INSERT INTO are_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Angkatja nhanhala kurtungurla ntjarranha tnolkalhelaka. Jesualantama etnanha wothantema ilaka, “Katjia nukanha ntjarrai, nhanhataka nthurrpa inpora inthorra nama Altjirraka pmarurna irrputjika. ");
INSERT INTO are_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Arai, nhanha rukaralkura nama camel needle-aka altjuranga tjananhitjika, nhanhangatjina, relha netaneta Altjirraka pmarurna irrputjika.” ");
INSERT INTO are_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Angkatja nhanha wumala, kurtungurla ntjarra kngarralkura tnolkaka. Etnantama erinha pmarraka, “Relha ngunhanhantama Altjirrala irrpalthala tangkalhelamara?” ");
INSERT INTO are_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kurtungurla ekuranha ntjarranha tjoraramala, Jesuala etnanha ilaka, “Thunga relhala etarlarama Altjirrala relhanha yarna tangkalhelama. Altjirrala pula relha ingkarrakanha irrpalthala tangkalhelamala, era antja namanga warta.” ");
INSERT INTO are_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peter-alantama Jesuanha ilaka, “Arai, nurna kunha yulthalka, ramaramalka impurlalhaka ungkwanganga tnaartangala lhitjinala.” ");
INSERT INTO are_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesuala erinha ilaka, “Relha etnala nukakwia, Yia Marrakakwia turta iltha paka, kalya paka, kwaiya paka, tjia paka, kaarta paka, mia paka, katjia paka, pmara paka impurlalhamanga, ");
INSERT INTO are_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","etnanha Altjirrala kngarra inthorra kwartiwutjina. Etna alha nhanhalantema namalanga, Altjirrala etnanha iltha, kalya, kwaiya, tjia, mia, katjia, pmara turta nthitjina. Nhanha turta, arrpunha ntjarrala etnanha kornilitjika lurnitjina. Anma, Altjirraka pmarala pula etna ngampakala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Relha etnala lyarta arrkurlerramanga, etna ingkarnerritjina. Kanha relha etnala lyarta ingkarnerrama, etna arrkurlerritjinala.” ");
INSERT INTO are_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesuanha Jerusalem-urna lhapalhaka. Kurtungurla ekuranha ntjarra, relha ntjarra arrpunha turta Jerusalem-urna lhapalhakantema. Jesuanha etnakanga arrkurla lhaka. Kurtungurla ntjarra ekuranga tnaartangala pitjika. Etna angkatja ekuranha tnakaka. Kanha relha arrpunha ntjarra etnala Jesualela lhapalhaka, etna trerrakala. Jesualantama kurtungurla 12 etnanha ntangkamala wotha ilaka era anma nyingalauwutjinala. ");
INSERT INTO are_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Era etnanha ilaka, “Arai, nurnataka nhanha Jerusalem-urna lhama. Jerusalem ekuralantama arrpunhala Relhaka ‘Lira erinha priest itornka ntjarraka lanthitjina, artwa Intarrangaltha ntjarraka turta. Etnantama erinha imilitjina. Kurunga priest itornka etna, artwa Intarrangaltha etna turta erinha Relha Lorinya ntjarraka lanthitjina. ");
INSERT INTO are_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Relha Lorinya etna erinha arrampowutjina, ekura palha iwutjina, erinha whip-ala tutjina, erinha errilknga tutjina turta. Arlta tharraminyinta errilknga intamaliperra pula, era wotha etatha kamerritjina.” ");
INSERT INTO are_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedee-aka ‘lira tharra, James John tharra, Jesuurna etinyerraka. Eratharrantama erinha pmarraka, “Kaltjinthanhinthanhai, ilirna nganha lyarta nyintaka pmarritjina. Ilirna turta antja unta ilirnaka kala kangkwerritjikanta.” ");
INSERT INTO are_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesuala erinhatharra pmarraka, “Iwunhakantama mpala antja?” ");
INSERT INTO are_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Eratharra erinha ilaka, “Unta anma Ingkartantama namanga, ilirna antja nama nyinta ungkwanganga akwala nitjika, arrpunha ungkwanganga kwanginyala.” ");
INSERT INTO are_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesuala pula erinhatharra ilaka, “Mpalataka marntilparla wara pmarrama. Mpala paka nukalela nyingalauwumarama? Mpala paka nukalela ilumarama, yingala ilutjinala ngerra?” ");
INSERT INTO are_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eratharra angkaka, “Awakwia.” Jesuala pula erinhatharra ilaka, “Mpala nthurrpa anma nyingalauwutjina, yingala nyingalauwutjina ngerra. Mpala turta anma ilutjina, yingala ilutjina ngerra. ");
INSERT INTO are_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Relha ngunha pula nukanga akwala nitjina, relha ngunha turtama nukanga kwanginyala nitjina? Nhanha itja nukathaka nama. Nhanha Altjirrakathakanta nama. Era turta kala relha erinhatharra urrarakala.” ");
INSERT INTO are_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kurtungurla 10 arrpunhala James John tharranha wumalanga, etna ekuratharra yirrkngerraka. ");
INSERT INTO are_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesuala pula kurtungurla etnanha worlilamala etnanha ilaka. “Rrangkarra kala kaltja Relha Lorinya ntjarraka itornka, etna relha etnakanhaka tjitjarterrama. Relha kngarra ntjarra turta relha kornakorna ntjarraka tjitjarterrama. ");
INSERT INTO are_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Worla nukanhala pula itja lakinha ngerra nitjika. Relha erala worla nukanhala itornka nitjika antja nama, era kala arrpunha ntjarraka tangitjala nitjika. ");
INSERT INTO are_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Relha erala worla nukanhala itornka kngarra nitjika antja nama, era kala arrpunha ntjarraka kngarra tangitjala nitjika. ");
INSERT INTO are_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Arai, Relhaka ‘Lira pitjika relha ntjarraka tangitjala nitjika, itja etna ekura tangitjala nitjika. Era pitjika relha ntjarrakakwia ilutjika, etnanha tangkalhelitjika turta.” ");
INSERT INTO are_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesuanha, kurtungurla ekuranha ntjarra turta Jericho-urna lhaka. Etna wotha Jericho-anga anparerramalanga, worla kngarra etnakanga tnaartangala lhaka. Artwa panga nyinta, Bartimaeus, Timaeus-aka worra, tjaiyanga kutala narlanaka, marnaka enkamala. ");
INSERT INTO are_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Era wumalanga Jesuanha, pmara Nazareth-arinya, anpara lhamanga, era ekura ilkaka, “Jesuai, David-aka ‘Lirai, nuka montjamontja ntelalhai!” ");
INSERT INTO are_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ntjarrala erinha turnaka, “Tjukunyerrai!” Era pula intarra kuta ilkaka, “David-aka ‘Lirai, nuka montjamontja ntelalhai!” ");
INSERT INTO are_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Itnatjalhamala Jesuala etnanha turnaka, “Erinha ntangkai.” Etnantama artwa panga erinha ntangkaka, erinha ilaka turta, “Kala arrkana nai. Kamerrai turta, era ungkwanga ntangkalhamanga.” ");
INSERT INTO are_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mantarra coat ekuranha ilumala, era kamerramala Jesuurna arerraka. ");
INSERT INTO are_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesualantama erinha pmarraka, “Iwunhangala unta nuka ilkaka?” Artwa panga era angkaka, “Itornkai, alknga nukanha marrilai.” ");
INSERT INTO are_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesuala erinha ilaka, “Kala lhai. Unta yinganha tnakakalanga, atha alknga ungkwanganha marrilaka.” Artwa era kala arakantama. Erantama Jesuanga tnaartangala lhaka. ");
INSERT INTO are_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesuanha, kurtungurla ekuranha ntjarra turta kala Jerusalem-aka etinyerramangantama, etna pmara Bethphage, Bethany tharrurna pitjika. Pmara nhanha tharrataka Olive Partanga kutala italhaka. Jesualantama kurtungurla tharra ekuranha arrkurla yairnaka. ");
INSERT INTO are_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Era erinhatharra ilaka, “Pmara kurrka arrpunha tanhurna lharrai. Pmaraka irrpunhamala ngerra mpala donkey kurrka aritjina, rope-ala yirnakala. Donkey nhanhaka relha itja arrkurla ntjikala paka. Rope erinha ilumala, donkey erinha nukurna kngitjai. ");
INSERT INTO are_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Thunga arrpunhala mpalanha pmarritjina, ‘Iwunhangala mpala donkey erinha kngama?’ Mpala erinha ilai, ‘Ingkartanha kunha ekura antja. Ingkartala turta erinha parrpa yairnitjalputjina.’” ");
INSERT INTO are_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kurtungurla eratharra lharraka. Eratharra turta donkey erinha araka rope-ala yirnakala, iltha nyintaka reoanga kutala itnamanga, street-ala. Eratharrantama rope erinha iluka. ");
INSERT INTO are_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Relha urrputja ntjarra ngerra lenhala itnarlanaka. Etnakanga urrputja arrpunhala pmarraka, “Iwunhangala mpala donkey erinha kngama?” ");
INSERT INTO are_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Eratharrantama etnanha ilaka, Jesualala erinhatharra turnakala ngerra. Etnantama erinhatharra impurlarrarnaka donkey erinha kngitjika. ");
INSERT INTO are_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kurtungurla eratharrantama donkey kurrka erinha Jesuurna rretjingaka. Kurtungurla etnantama mantarra coat etnakanha donkey ekura arrarnaka. Jesuanha turtantama donkey ekura ntjika. ");
INSERT INTO are_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Relha ntjarralantama mantarra coat etnakanha tjaiyaka ntjamiwuka. Kanha relha arrpunha ntjarrala tnukulpala walya kamala, walyala tjaiyaka ntjamiwuka. ");
INSERT INTO are_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Relha ntjarra Jesuanga arrkurla lhaka. Relha ntjarra arrpunha turta ekuranga tnaartangala pitjika. Etna ingkarraka intarra ilkarlanaka, “Nurna Altjirranha tnantjama. Altjirrai, urrpia ungkwanganha lyekarrilai, erala lyarta nurnakurna pitjima. ");
INSERT INTO are_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Altjirrai, erinha lyekarrilai, erala kaarta nurnaka David-aka kathala tjitjarterritjinala. Nurna Altjirranha kngarra inthorra tnantjama.” ");
INSERT INTO are_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalem-urna irrpumala, Jesuanha temple-urna lhaka, temple erinha turta tjoraraka. Kala ngurrangurrerrakalangantama, era Bethany-urna alpuka, kurtungurla 12 ekuranhakarta. ");
INSERT INTO are_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ingutnhala, Jesuanha kurtungurla ekuranha ntjarrakarta Bethany-anga rratamala lhaka. Tjaiyakerramala Jesuanha ngaiyala wulhaka. ");
INSERT INTO are_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Erantama irna tjurrka urntwarraka araka, kala ilpalhakarterrakala. Jesuanhantama irna tjurrka ekururna lhaka marnaka yonthitjika. Etinyerramala pula era ilpalhanta araka, marna tjurrkaka antala lyartathakanga warta. ");
INSERT INTO are_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesualantama irna tjurrka erinha ilaka, “Lyartanga relhala itja wotha ungkwanganga marna ilkutjina!” Kurtungurla ekuranha ntjarrala erinha wuka era lakinha angkamanga. ");
INSERT INTO are_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalem-urna irrpunhamaliperra, Jesuanha temple-urna lhaka. Temple kwanala artwa ntjarra nitjata, etnala nturrurta yirrinthitjata, relha epinyaka money turta ekngarrpunhilitjata. Jesualantama etnanha unpurlenaka, table etnakanha, chair etnakanhalka turta ankartiwuka. ");
INSERT INTO are_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Era turta relha lenha ntjarranha parraka, etnala temple-anga wara tjananhitjata, yultha etnakanhakarta. ");
INSERT INTO are_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Erantama etnanha kaltjinthamala ilaka, “Altjirraka Angkatja Imankinyala ilama, ‘Iltha nuka relha ingkarrakaka pmara nitjika, pmara nhanga ekururnala etna pitjima nukurna ingkitjika.’ Kanha rrangkarra iltha nukanha nyilkngampaka pmaratitjala mpaaraka.” ");
INSERT INTO are_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Priest-aka itornka ntjarrala, artwa Intarrangaltha ntjarrala turta Jesuanha wukantema era lakinha angkamanga. Etnantama antja naka erinha errilknga tutjika. Etna pula Jesuanga trerraka, relha ntjarra angkatja ekuranhaka antja inthorra namanga. ");
INSERT INTO are_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kala ngurrangurrerrakalangantama, Jesuanha kurtungurla ekuranha ntjarrakarta Jerusalem-anga wotha rrataka. ");
INSERT INTO are_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ingutnhalantama, etna wotha tjaiya nhangala Jerusalem-urna lhapalhaka. Kurtungurla ntjarrala araka irna tjurrka nhanga kala ntjirrkerrakala, takarrangatjina kartnakurtitja, ntjapara kuta. ");
INSERT INTO are_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter-anhantama ilpangkamala angkaka, “Kaltjinthanhinthanhai, irna tjurrka nhanga untala kornilakala arai. Era kala ntjirrkerrakantama.” ");
INSERT INTO are_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesualantama etnanha ilaka, “Altjirranha tnakai. ");
INSERT INTO are_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Atha rrangkarranha nthurrpa ilama. Thunga rrangkarra parta nhanhurna angkitjina, ‘Katha nhanhanga naamerrai, kwatja laiyaka turta iwulhai!’ Rrangkarrantama Altjirranha tnakamanga, itja inthorra turta ilpoiwumanga, parta era kala naamerritjina. ");
INSERT INTO are_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lakinhanga atha rrangkarranha ilama. Rrangkarra Altjirrurna ingkamanga, rrangkarra erinha tnakitjika era rrangkarranha kala wumanga. ");
INSERT INTO are_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","“Thunga rrangkarra Altjirrurna ingkama. Thunga turta rrangkarra ilpangkama relha arrpunhala rrangkarranha kornilakala. Kala relha lenhaka korna iwai. Kurunga Altjirrala korna rrakangkarranha iwutjinantema.” ");
INSERT INTO are_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesuanha, kurtungurla ekuranha ntjarra turta wotha Jerusalem-urna irrpuka. Jesuanhantama temple-ala nthulapumalanga, priest itornka ntjarra, kngarripata ntarntarintja ntjarra, artwa Intarrangaltha ntjarra turta ekururna pitjika. ");
INSERT INTO are_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Etna erinha pmarraka, “Ngunhalama nganha ingkairnaka artwa ntjarranha temple-anga unputjika? Nhanha ungkwangathaka namama? Ngunhala turtama nganha turnaka relha ntjarranha kaltjinthitjika?” ");
INSERT INTO are_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesuala etnanha ilaka, “Atha turta rrangkarranha pmarritjina. Rrangkarra paka yinganha ilamanga, atha turta rrangkarranha alpmelitjinantema. ");
INSERT INTO are_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Rrangkarra yinganha ilai, “Ngunhalama John-anha turnaka relha ntjarranha kaltjirrpulhelitjika? Thunga Altjirrala? Thunga relhala paka?” ");
INSERT INTO are_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nhanhiperra eterramala, etna lakinha ilarraka. “Nurna paka erinha ilamanga, Altjirrala erinha turnakala, era nurnanha ilitjina, ‘Iwunhangantama rrangkarra erinha itja tnakaka?’ ");
INSERT INTO are_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","33","Nurna paka erinha ilamanga, relhala erinha turnakala, relha ntjarrala nurnaka yirrkngerritjina.” Relha ntjarranga urlarra John-anha Altjirraka urrpia naka. Lakinhanga, relha ntjarranga trerramala, etna Jesuanha ilaka, “Nurna itja kaltja.” Jesualantama etnanha ilaka, “Lakinhanga atha turta rrangkarranha itjantema alpmelitjina.” ");
INSERT INTO are_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesualantama etnanha yia arrpunha nhanha ilaka. “Artwa nyintala marna grapes ingkairnaka tnukulpa ekuranhala. Erantama parta inamala, tnukulpa ekuranga fence itaka. Era iparta turta tnyaka, nhanga marna grapes etnanha anma nharrkutjika. Era iltha tjenya turta itaka, artwala kartninyanga tnukulpa erinha kartaritjinanga. Kurunga era tnukulpa erinha artwa arrpunha ntjarraka rent-emilaka. Artwa erantama pmara arrpunhurna lhaka. ");
INSERT INTO are_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Marnaka kotjintjaka antalalantama, artwa era urrkapunhapunha nyinta yairnaka rent money ekuranhaka. ");
INSERT INTO are_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Artwa etna pula urrkapunhapunha erinha errkuka. Erinha tumala, etna erinha rapa kuta yairnarlenaka. ");
INSERT INTO are_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Kurtwia erantama urrkapunhapunha arrpunha artwa etnakurna yairnaka. Urrkapunhapunha nhanha erinha etna kapurtala tuka, arrampowuka turta. ");
INSERT INTO are_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kurunga kurtwia era urrkapunhapunha arrpunha yairnaka. Nhanha erinha etna errilknga tuka. Kurunga era urrkapunhapunha arrpunha ntjarra turtantama yairnaka. Artwa etnantama urrkapunhapunha nhanha etnakanga arrpunha ntjarranha tuka, arrpunha ntjarranha errilknga tuka turta. ");
INSERT INTO are_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Kurtwia ekura urrkapunhapunha arrpunha itja naka yairnitjika, kala ‘lira ekurantantama. ‘Lira nhanha ekura era kngarra kangkaka. Erinha yairnamala, era lakinha eterraka, ‘Etna ekura kangkwerritjina.’ ");
INSERT INTO are_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Artwa etna pula lakinhala angkarraka. ‘Nhanha kunha ‘lira era. Anma tnukulpa nhanha ekurantama nitjina. Mpa, nurna erinha errilknga twiai, tnukulpa nhanha kala nurnakantama nitjinanga.’ ");
INSERT INTO are_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Etnantama ‘lira erinha errkumala errilknga tuka, erinha tnukulpanga kathurna iwuka turta.” ");
INSERT INTO are_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesualantama etnanha pmarraka, “Nthakinhama rrangkarra etarlarama? Tnukulpakurtwia era kunha yirrknga inthorra nitjina. Erantama pitjimala artwa nhanha etnanha errilknga tutjina. Kurunga era tnukulpa erinha arrpunha ntjarranhantama nthitjina ekura ntarntaritjika. ");
INSERT INTO are_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Rrangkarra kala Altjirraka Angkatja Imankinya nhanhaka kaltja, ‘Parta nhanga iltha itanha ntjarrala ipmintja iwukala, erantama lyarta parta tjiparralkura era nama. ");
INSERT INTO are_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ingkarta erarrpa ilaka era tjiparralkura namanga. Nurna kala tnolkamanta, nhanha aramala.’” ");
INSERT INTO are_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Itornka ntjarra kaltja naka era yia nhanha etnakiperra ilamanga. Etnantama antja naka erinha errkutjika. Etna pula relha ntjarranga trerraka. Lakinhanga etna erinha impurlalhamala, kala alpukantama. ");
INSERT INTO are_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Itornka ntjarrala artwa Pharisee urrputja, Herod-aka urrkapunhapunha urrputja turta Jesuurna yairnaka, erinha arrkarnitjika. ");
INSERT INTO are_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ekururna pitjimala, etna erinha ilaka, “Kaltjinthanhinthanhai, nurna kaltja unta artwa ilporatha namanga. Nurna turta kaltja unta itja relhanga trerrama. Unta turta relha ntjarranha kaltjinthama Altjirranga urlarra arratja ntelalhitjika. Nurnanha ilai, Altjirrala nurnanha turnamama, nurna Caesar-anha tax money nthitjika? ");
INSERT INTO are_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nhanha turtama arratja nama nurna tax money nthitjika?” Jesuanha kaltja naka etna erinha pmathala wara pmarramanga. Erantama etnanha pmarraka, “Iwunhangama rrangkarra yinganha arrkarnama? Yinganha tax money ungkwaltja nthai.” ");
INSERT INTO are_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Etnantama erinha money ungkwaltja nyinta nthaka. Erantama etnanha pmarraka, “Ngunhaka ntolyama money ekurala nama? Ngunhaka rretnya turtama money ekurala nama?” Etna erinha alpmelaka, “Caesar-akakwia.” ");
INSERT INTO are_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesualantama etnanha ilaka, “Money nhanha Caesar-aka namanga, rrangkarra nhanha kala Caesar erinha ntharrirrai. Rrangkarra turta Altjirraka kangkwerrai, erala rrangkarranha turnakala ngerra.” Angkatja nhanha wumala, etna tnolkakanta. ");
INSERT INTO are_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Artwa Sadducee ntjarrantama Jesuurna pitjika. Artwa Sadducee etnataka ilitjata relha errilknga ntjarra itja kamerritjinala. Etnantama Jesuanha pmarraka, ");
INSERT INTO are_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kaltjinthanhinthanhai, Moses-ala nurnanha lakinha turnaka. Thunga artwa nyinta katjiakunya iluma. Kurunga tjia ekuranhala warlukurta erinha noa initjika, nhanga kalya ekuranhaka katjia intitjinanga paka. ");
INSERT INTO are_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Arrpunharanga kanhanganhanga 7 naka. Kalya kngarralakimparra noa inaka. Era pula katjiakunya iluka. ");
INSERT INTO are_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Lakinhanga kalya arrpunhala warlukurta erinha noa inaka. Era turtantama iluka, katjiakunya. Kurunga kalya arrpunhala warlukurta erinha noa inaka. Era turta katjiakunyantema iluka. ");
INSERT INTO are_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kala kanhanganhanga 7-ala arrkutja nyinta erinha noa tnyinaka. Kanhanganhanga etna ingkarraka katjiakunya iluka. Ingkarna arrkutja era turtantama iluka. ");
INSERT INTO are_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Anma Altjirrala relha ingkarrakanha kamalhelamanga, ngunhaka noantama arrkutja era nitjina? Kanhanganhanga 7-ala kunha erinha noa tnyinakala.” ");
INSERT INTO are_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesuala etnanha ilaka, “Rrangkarrataka paalakarla pmarrama. Rrangkarra kunha Altjirraka Angkatja Imankinyaka kotna. Rrangkarra turta kngwerraka Altjirranha ekarlta inthorra namanga. ");
INSERT INTO are_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Anma, Altjirrala relha errilknga ntjarranha kamalhelamanga, etna itja noa inarritjina. Etna kala angel ntjarra ngerra nitjina. ");
INSERT INTO are_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Altjirrala kala relha errilknga ntjarranha kamalhelitjina. Rrangkarra itjala Moses-aka pepala read-erraka? Iwunhama Altjirrala Moses-anha ilaka irna mpumala kwananga? Era kunha erinha ilaka, ‘Yinga Abraham-aka Altjirra nama, Isaac-aka Altjirra, Jacob-aka Altjirra turta.’ ");
INSERT INTO are_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Arai, Altjirranha relha etatha ntjarraka Altjirra nama, itja relha errilknga ntjarraka. Artwa Sadducee ntjarrai, rrangkarrataka paala kuta eterrama.” ");
INSERT INTO are_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesuanha artwa Sadducee ntjarralela iwurramalangantema, artwa Intarrangaltha nyinta Jesuurna pitjika. Era wuka Jesuala artwa Sadducee etnanha arratja kuta ilamanga. Erantama Jesuanha pmarraka, “Yinganha Altjirraka turnintja kngarra erinha ilai.” ");
INSERT INTO are_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesuala erinha ilaka, “Nhanha turnintja kngarra era. ‘Relha Israel-arinya ntjarrai, wurrirrai. Altjirra nyinta wara nama. Altjirra era Ingkarta nama. Era turta Altjirra nurnaka nama. ");
INSERT INTO are_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Untantama Ingkarta Altjirra ungkwanganhaka kngarra inthorra kangkitjika. Unta ekura kuta eterritjika. Unta erinhanta tnakitjika. Unta ekuranta kangkwerritjika turta.’ ");
INSERT INTO are_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Turnintja arrpunha nhanha turta kngarra namantema. ‘Unta relha arrpunha ntjarraka kangkitjika, untala ungkwangararrpa kangkamanga ngerra.’ Turnintja nhanha tharranga turnintja arrpunha itja kngarralkura nama.” ");
INSERT INTO are_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Artwa Intarrangaltha era angkaka, “Kaltjinthanhinthanhai, unta nurnanha kala arratja kuta ilaka. Altjirra nyinta wara nama. Eranta Altjirra nurnaka nama. ");
INSERT INTO are_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nurnantama ekuranta kngarra inthorra kangkitjika. Nurna ekura kuta eterritjika. Nurna ekuranta kangkwerritjika. Nurna turta relha arrpunha ntjarraka kangkitjika, nurnala nurnakararrpa kangkamanga ngerra. Turnintja nhanha tharraka kangkwerritjika, nhanha kunha tjiparralkura nama temple-aka tjauwerrilya ingkarrakangatjina.” ");
INSERT INTO are_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesuala wumalanga era arratja kuta angkamanga, era erinha ilaka, “Unta ingkwa inthorra Ingkartaka tjinerraka.” Nhanhiperra, relha arrpunha itja wotha irrpaltherraka erinha pmarritjika. ");
INSERT INTO are_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesuala relha ntjarranha temple-ala kaltjinthamalanga, era etnanha ilaka, “Artwa Intarrangaltha ntjarrala ilama Kristanha David-aka ‘lira namanga. Nthakinha inthorrantama era David-aka ‘lira nama? ");
INSERT INTO are_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Enka Alkngaltara era kunha David-anha turnaka lakinha angkitjika, ‘Ingkarta era Ingkarta nukanha ilaka: akwa nukanhanga arrarnalhai, atha leltja ungkwanganha ntjarranharrka pmakwinitjinanga.’ ");
INSERT INTO are_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David-ala paka Kristanha Ingkarta kakalanga, nthakinhantama Kristanha David-aka ‘lira nama?” Relha worla kngarra etna kangkaka Jesuala etnanha kaltjinthamanga. ");
INSERT INTO are_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesuala relha ntjarranha kaltjinthamalanga, era etnanha nhanha turta ilaka, “Rrangkarrataka artwa Intarrangaltha ntjarranga aralhitjika. Etna kangkama mantarra tjenyakarta nthulaputjika. Etna antja nama relha ntjarrala etnanha anparnitjika etna shop-ala namalanga. ");
INSERT INTO are_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Etna synagogue-urna lhamalanga, etna antja nama arrkurlala nitjika, relha ntjarrala etnanha aritjinanga. Arrpunhala etnanha marna ilkutjika ntangkakalanga, etna antja nama itornka ntjarranga kuta nitjika. ");
INSERT INTO are_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Etna pula warlukurta ntjarraka iltha pmathala rakama. Etna turta Altjirrurna tjarrilpmintja ingkarlanama, relhala etnanha tnantjitjinanga. Altjirrala etnanha kngarra inthorra rrarrathala tutjina.” ");
INSERT INTO are_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesuanha temple-ala narlanaka. Erantama araka relha ntjarrala tjauwerrilya iwetnamanga, tjauwerrilyakanha box-aka. Era araka turta artwa netaneta arrpunha ntjarrala tjauwerrilya kngarra kuta iwetnamanga. ");
INSERT INTO are_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kurunga era araka arrkutja warlukurta ilkngarala money kurrka iwumanga, nhanga money relhalala nthama marna nyinta buy-emilitjika. ");
INSERT INTO are_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kurtungurla ekuranha ntjarraka ntangkalhamala, era etnanha ilaka. “Atha rrangkarranha nthurrpa ilama. Warlukurta ilkngara nhanhala kngarralkura nthaka, relha arrpunha ingkarrakangatjina. ");
INSERT INTO are_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Relha netaneta ntjarrala tjauwerrilya nthamaliperra, etnaka money kngarra kuta intaka. Kanha warlukurta era money ingkarraka ekuranhala nthaka. Ekura itja wotha intaka marna nyintalka paka buy-emilitjika.” ");
INSERT INTO are_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesuanha temple-anga rratanhamangantama, kurtungurla ekuranha nyinta ekururna angkaka. “Kaltjinthanhinthanhai, parta nhanha ntjarra arai, iltha nhanha ntjarra turta. Etna kunha intorta inthorra.” ");
INSERT INTO are_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesuala pula erinha ilaka, “Unta iltha kngarritja nhanha ntjarranha arama? Leltjala iltha etnanha ungkwaltjilitjina. Parta kngarritja nyintantama itja parta kngarritja arrpunhanga kartninyala intitjina. Ingkarraka arnala intitjina, leltjala errarnpalhelakala.” ");
INSERT INTO are_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Anma, Jesuanha Olive Partala-ntama namalanga, temple-urnathaka, Peter-anha, James-anha, John-anha, Andrew-anha turta ekururna etinyerraka. Etnantama erinha pmarraka, ");
INSERT INTO are_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nurnanha ilai, ilangarama lakinherritjina? Nthakinha turtama nurna kaltja nitjina leltja etna pitjitjikerramanga, iltha nhanha etnanha ungkwaltjilitjika?” ");
INSERT INTO are_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesuala etnanha ilaka, “Rrangkarrataka aralhitjika arrpunhala rrangkarranha orrtjapepilakitja. ");
INSERT INTO are_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ntjarra kunha anma pitjimala angkitjina, ‘Jesuala yinganha yairnaka. Yinga nama Krista era.’ Orrtja krista nhanha ntjarralantama relha ntjarranha orrtjapepilitjina. ");
INSERT INTO are_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Anma rrangkarra wumalanga relha arrpunha ntjarra turramanga, relha arrpunha ntjarra turta turritjikerramanga kula, rrangkarra itja trerritjika. Nhanha kunha kala lakinha nitjikarrpa. Alha era pula itjantema yirritjina. ");
INSERT INTO are_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pmararinya ntjarra, pmararinya arrpunha ntjarralela turritjina. King nyinta turta, king arrpunhaka irrpaltherritjina. Katha arrpunhala alha era errowutjina. Katha arrpunhala marnaka paalerrintja nitjina. Nhanha lakinherramalanga rrangkarra kaltja nitjika relha ntjarra imampurlerritjinantama. ");
INSERT INTO are_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Rrangkarrataka aralhitjika. Etna kunha rrangkarranha errkumala court-urna kngitjina. Etna turta rrangkarranha synagogue kwanala whip-ala tutjina. Etna turta rrangkarranha itornka kngarra ntjarranga urlarra ilparnitjina, king ntjarranga urlarra turta, rrangkarra yinganha tnakamanga. Nhanha kala lakinha nitjika, rrangkarra etnanha nukiperra ilitjinanga. ");
INSERT INTO are_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Arai, rrangkarra kunha Yia Marra erinharrka relha ingkarrakanha ilitjika alha panpala. ");
INSERT INTO are_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Thunga etna rrangkarranha errkuma, court-urna turta kngama. Rrangkarra itja arrkurlantema thakerritjika, lakinha eterramala, ‘Nthakinhantama nurna angkitjika?’ Arai, etna rrangkarranha pmarramalanga, kala angkatja lenhanta angkai, Enka Alkngaltaralala rrangkarranha ilitjinala. Era kunha rrangkarranha ilitjina angkatja rrangkarrala angkitjika. ");
INSERT INTO are_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Artwalantama tjia ekuranha lanthitjina arrpunhala errilknga tutjika, kaartala turta katjia ekuranha, katjiala turta kaarta pa mia ekuranha. ");
INSERT INTO are_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Relha ingkarraka rrakangkarra antjakunya nitjina. Altjirrala pula rrangkarranha tangkalhelitjina, rrangkarra yinganha talwalpula tnakamanga.” ");
INSERT INTO are_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Anma rrangkarra aritjina etna irna orrtja altjirra Altjirraka temple-aka ingkairnamanga, Altjirranha arrampowutjika. (Relha erala pepa nhanhaka read-erramanga, era etarlariau!) Kurunga relha Judea-arinya kala parturnanta naamerritjika. ");
INSERT INTO are_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Relha erala iltha kaputhala namanga, era turta kala naamerritjikanta. Era itja iltha ekuranhurnarrka irrputjika, yulthaka. ");
INSERT INTO are_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Relha erala tnukulpa ekuranhala urrkapumanga, era turta kala naamerritjikanta. Era itja iltha ekuranhurnarrka alputjika, mantarra ekuranhaka. ");
INSERT INTO are_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Arai, arrkutja inpora ntjarraka imampurla inthorra nitjina, arrkutja katjia kurrka ipatja ntjunhintjunha ntjarrakartaka turta. ");
INSERT INTO are_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ingkarrirrai turta rrangkarra itja lhurrpala naamerritjika. ");
INSERT INTO are_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Arai, antala lenhala relha ntjarra kngarra inthorra nyingalauwutjina. Relha itja arrkurla lakinha ngerra nyingalauwuka paka. Anma turta relha itja wotha lakinha ngerra nyingalauwutjina. ");
INSERT INTO are_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Altjirranha pula relha ekuranha ntjarraka montjamontja ntelalhitjina. Lakinhanga era itja relha ingkarrakanha kuta inthorra nakapakarlilitjina, etna ingkarraka ilukitja, kngarra nyingalauwumala. ");
INSERT INTO are_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Arai, relhala paka rraangkarranha ilamanga, ‘Krista era nhanhiai.’ Arrpunhala pula rrangkarranha ilamanga, ‘Itja. Era tanha nama.’ Rrangkarra angkatja etnakanha itja tnakitjika. ");
INSERT INTO are_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Orrtja krista ntjarra, orrtja urrpia ntjarra turta pitjitjina. Etna tjatjikarta kngarra turta urrkaputjina. Etna arrkarnitjina Altjirraka tjina ntjarranha orrtjapepilitjika. ");
INSERT INTO are_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Rrangkarrataka aralhitjika. Arai, atha rrangkarranha mparrama ilama, rrangkarra kaltja nitjinanga.” ");
INSERT INTO are_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Kurunga imampurla nhanhiperrantama, ‘Altjirrala lirnnga erinha ilurnitjina, taiya erinha turta. ");
INSERT INTO are_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Era ntheilpura etnanha ngarlpangalhelitjina, etnanha alkiranga tnyilhelitjina turta.’ ");
INSERT INTO are_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Kurunga relha ingkarrakala aritjina Relhaka ‘Lira era matarala pitjimanga. Era ekarlta inthorra, makalaria inthorra turta ntelalhitjina. ");
INSERT INTO are_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Erantama angel ekuranha ntjarranha yairnitjina relha ekuranha ntjarranha pmararrpaninhanga worlilitjika.” ");
INSERT INTO are_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Irna tjurrka ekuranga kaltjerrai. Etintja ekura pulyerramalanga, ilpalha turta rratamalanga, rrangkarra kaltja inguntha wara kala wumpierritjina. ");
INSERT INTO are_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lakinhanga rrangkarra aramalanga angkatja nukanha nthurrperramangantama, rrangkarra kaltja nitjika Relhaka ‘Lira era kala pitjalputjikerramanga. ");
INSERT INTO are_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Atha rrangkarranha nthurrpa ilama. Angkatja nukanha kala nthurrperritjina ramarama nhanha namalangantema. ");
INSERT INTO are_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Alkira nhanha kala yirritjina, alha nhanha kala yirritjinantema. Angkatja nuka pula itja kuta yirritjina.” ");
INSERT INTO are_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ilangara inthorra pula Relhaka ‘Lira era pitjalputjina, nhanhaka relha nyinta itja kaltja. Angel alkirarinya etna itja kaltja. ‘Lira era itja kaltja. Kaarta eranta kaltja. ");
INSERT INTO are_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lakinhanga rrangkarra aralhitjika, kaarra turta nitjika, rrangkarra kotnanga warta ilangara inthorra era pitjalputjina. ");
INSERT INTO are_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Arai, lakinha ngerrataka nama. Pmarakurtwia era pmara arrpunhurna lhitjika antja naka. Era urrkapunhapunha ekuranha ntjarranha turnaka arratja kuta urrkaputjika. Era iltha ntarntarintja erinha turta turnaka iltha erinha arratja kuta kaaritjika. Kurunga era lhaka. ");
INSERT INTO are_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Lakinha ngerra rrangkarra turta kuta kaarra nitjika. Rrangkarra itja kaltja ilangara pmarakurtwia era pitjalputjina. Thunga era ngurrangurra pitjalputjina. Thunga ingwa mpopala. Thunga lirnnga rratitjikerramanga. Thunga ingutnhala. ");
INSERT INTO are_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Rrangkarrataka kaarra nitjika, era nhanga itnatjalhamalanga, era rrangkarranha ankwentamanga arakitja. ");
INSERT INTO are_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Angkatja athala rrangkarranha nhanha ilama, atha kala relha ingkarrakanha ilama. Kaarra narrirrai.” ");
INSERT INTO are_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kala arlta tharrantantama naka relha ingkarrakala Passover tjinkarra erinha ilkutjinala, Marna Ekalha erinha turta. Priest-aka itornka ntjarra, artwa Intarrangaltha ntjarra turtantama angkarraka. Etna antja naka Jesuanha nyilknganyilkngala errkumala, errilknga tutjika. ");
INSERT INTO are_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Relha ntjarra pula Jesuaka kngarra kangkamanga, etna ilarraka, “Nurna erinha itja Passover-aka arltala errkutjika, relha ingkarraka kekarta lhakitja.” ");
INSERT INTO are_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Bethany town-ala artwa nyinta naka, rretnya ekura Simon. Era leprosy-akarta nitjata. Jesuala iltha ekuranhala marna ilkurlanaka. Arrkutja nyintantama irrpentjika bottle kurrka ntira unpa marra inthorrakarta. Ntira unpa marra lakinha relhala money kngarra inthorralanta buy-emilitjata. Bottle erinha altjurilamala, arrkutja era ntira unpa marra inthorra erinha Jesuaka kapurtaka thalaka. ");
INSERT INTO are_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nhanha aramala, relha urrputja arrpunha arrkutja ekura unpaarterraka. Etna lakinha ilarraka, “Iwunhangala era ntira unpa marra inthorra nhanha palkala wara thalaka? ");
INSERT INTO are_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ntira unpa marra inthorra nhanha erinha kunha money kngarra inthorraka yirrinthamara. Money erinha turtantama relha ilkngara ntjarranha nthamara.” Etnantama arrkutja erinha iltaka. ");
INSERT INTO are_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesuala pula etnanha ilaka, “Erinha impai. Iwunhangala rrangkarra ekura unpaarterrama? Erataka nuka kangkintja kngarra ntelalhaka. ");
INSERT INTO are_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Relha ilkngara kunha kutatha rrakangkarralela nitjina, rrangkarra paka etnaka kangkintja ntelalhitjika antja namanga. Yinga pula itjala rrakangkarralela kuta nitjina. ");
INSERT INTO are_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Arrkutja erataka mpurrka nukanha mparrama ntirala parnaka, yinganha tintjiwutjinalakatjila. ");
INSERT INTO are_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Atha rrangkarranha nthurrpa ilama. Pmara nthanhala paka etna relha ntjarranha Yia Marra erinha anma kaltjinthitjina, etna yia nhanha turta ilitjinantema, arrkutja ekura ilpangkamala.” ");
INSERT INTO are_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kurunga Judas Iscariot, kurtungurla 12 etnakanga nyinta, priest-aka itornka ntjarrurna lhaka. Era antja naka Jesuanha etnaka lanthitjika. ");
INSERT INTO are_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Angkatja nhanha wumala etna kangkaka. Etna Judas-anha money turta nthitjika lhelaka. Judas-anha kala nhanhakantantama kngarra inthorra eterraka, “Nthakinhama atha Jesuanha etnaka lanthamara?” ");
INSERT INTO are_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Marna Ekalhaka ilpangkintjaka arlta arrkurlinyala, etna Passover lamb etnanha tuka. Jesuaka kurtungurla ntjarralantama erinha pmarraka, “Nthanhalama unta antja nama nurna Passover tjinkarra erinha ungkwanga urrkaputjika, unta erinha ilkutjinanga?” ");
INSERT INTO are_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesuala kurtungurla tharra ekuranha ilaka, “Town-urna lharrai. Town ekurala artwa nyinta mpalakurna urlarra pitjitjina. Mpala aritjina era jar kwatjakarta kngetnamanga. Ekuranga tnaartangala lhai. ");
INSERT INTO are_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Iltha ekururnala era irrpunhama, mpala irrpunhaintema, ilthakurtwia ekururna turta lakinha angkai, ‘Kaltjinthanhinthanhala nganha pmarrama, Nthanhama room nuka, ekuralala atha Passover erinha ilkumara, kurtungurla nukanha ntjarralela?’ ");
INSERT INTO are_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Artwa erantama mpalanha room kngarritja ntelitjina, iltha kaputhala. Room nhanha era kala ilkngikala, ekura ntjama turta iwukala. Room ekuralantama mpala nurnaka tjinkarra erinha urrkapai.” ");
INSERT INTO are_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kurtungurla eratharra town ekururna irrpuka. Jesuaka angkatja ingkarrakantama nthurrperraka. Eratharrantama Passover tjinkarra erinha urrkapuka. ");
INSERT INTO are_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kala ngurrangurrantama, Jesuanha 12 etnakalela iltha ekururna lhaka. ");
INSERT INTO are_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Etna marna ilkurlanamangantama, Jesuala kurtungurla etnanha ilaka, “Atha rrangkarranha nhanha nthurrpa ilama. Rrakangkarranga nyinta, erala lyarta nukalela marna ilkuma, era yinganha leltjaka lanthitjina.” ");
INSERT INTO are_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nhanha wumala, kurtungurla etna ltarrperraka. Nyintaminyintalantama Jesuanha pmarraka, “Yinganhama unta ilama?” ");
INSERT INTO are_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Era etnanha ilaka, “12 rrakangkarranga nyinta, erala nukalela dish nhanhanga marna ilkuma, era yinganha leltjaka lanthitjina. ");
INSERT INTO are_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Relhaka ‘Lirakathaka nama ilutjika, Altjirraka Angkatja Imankinyala ilamala ngerra. Artwa erala Relhaka ‘Lira erinha leltjaka lanthamanga, ekura pula imampurla kngarra inthorra nitjina. Ekura marralkura namara era itja kuta alkngerrakalanga paka.” ");
INSERT INTO are_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Etna marna ilkumalanga, Jesuala marna inaka, Altjirranha dangkilaka turta. Kurunga era marna erinha urltakamala etnanha nthaka, lakinha angkamala, “Inarrirrai, nhanha mpurrka nuka nama.” ");
INSERT INTO are_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kurunga era cup wine-akarta inaka. Altjirranha dangkilamala, era etnanha cup erinha nthaka. Etna ingkarrakala ekuriperra ntjuka. ");
INSERT INTO are_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Erantama etnanha ilaka, “Nhanha alhwa nuka nama, lheloalhelintja lyartinyakanha. Atha alhwa nukanha thalama ntjarranha Altjirraka tjinilitjika.” ");
INSERT INTO are_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Atha rrangkarranha nhanha turta nthurrpa ilama. Lyartanga atha itja wotha wine rrakangkarralela ntjutjina. Anmanta Altjirranha relha ingkarrakaka Ingkarta ntelalhamanga, atha wine arrpunhantama ntjutjina.” ");
INSERT INTO are_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kurunga nyintaranga lyilhamala, etna rratamala Olive Parturna lhaka. ");
INSERT INTO are_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesualantama kurtungurla ekuranha ntjarranha ilaka, “Rrangkarra ingkarraka nukanga mpakalhitjina. Altjirraka Angkatja Imankinyala nhanga ilama, ‘Atha tnairnarintja erinha tutjina, kurunga sheep etna errarnperritjina.’ ");
INSERT INTO are_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Altjirrala pula yinganha errilknga ntjarranga wotha kamalhelakalanga, yinga rrakangkarranga arrkurla lhitjina pmara Galilee-urna.” ");
INSERT INTO are_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter-anha pula angkaka, “Etna ingkarraka inthorra paka ungkwanganga mpakalhamanga, yinga pula itja kutala ungkwanganga mpakalhitjina.” ");
INSERT INTO are_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesuala pula erinha ilaka, “Atha nganha nhanha nthurrpa ilama. Ingula lyarta, lukaluka orrea era itjantema tharraranga ilkakalanga, unta yinganha kala tharraminyintaranga yiparrarnitjina.” ");
INSERT INTO are_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter-anha pula ekarlterramala angkaka, “Thunga arrpunha ntjarra antjerritjina yinganha ungkwangakwia errilknga tutjika. Yinga pula itja kuta ungkwanganga mpakalhitjina.” Kurtungurla arrpunha ntjarra turta lakinhantema ekarlterramala angkaka. ");
INSERT INTO are_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesuanha, kurtungurla ekuranha ntjarra turtantama katha nhangurna lhaka, rretnya ekura Gethsemane. Jesualantama etnanha ilaka, “Nhanhala narrirrai. Yinga Altjirrurna ingkamalanga.” ");
INSERT INTO are_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kurunga Jesuanha Peter, James, John ntjarrakarta kurrka urntwarra lhaka. Jesua erantama yarna eterritjikerraka, mpangkaka turta. ");
INSERT INTO are_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Erantama etnanha ilaka, “Yingataka ltarrpa inthorra wulhamala, ingkwa ilutjikerrama turta. Nhanhala kaaralhai, kaarra turta narrirrai.” ");
INSERT INTO are_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kurrka urntwarrantama lhamala, Jesuanha urlparra iwulhaka. Erantama Altjirrurna ingkaka, “Unta nthurrpama antja nama yinga lyarta nyingalauwutjika, ilutjika turta?” ");
INSERT INTO are_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Era lakinha turta ingkaka, “Kaarta nukai, yinga itja antja nama nyingalauwutjika, ilutjika turta. Unta pula antja namanga yinga nyingalauwutjika, ilutjika turta, yinga kala ungkwanga kangkwerramala.” ");
INSERT INTO are_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kurtungurla etnakurna pitjalpumala, era etnanha ankwentamanga aritjalhaka. Erantama Peter-anha pmarraka, “Unta ankwentamama? Unta yarnala kurrka wara ilkwatharra kaarra nama? ");
INSERT INTO are_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Rrangkarrataka kaarra nitjika, Altjirrurna ingkitjika turta, errintja era rrakangkarra irrpaltherramanga warta. Arai, enka rrakangkarra nthurrpa Altjirraka kangkwerritjika antja nama. Lherrintja korna pula kuta namantemala.” ");
INSERT INTO are_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Erantama wotha lhaka Altjirrurna ingkitjika. ");
INSERT INTO are_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kurunga kurtungurla etnakurna pitjalpumala, era aritjalhaka etna wothantema ankwerrakala. Etnataka porrka inthorra naka. Etnantama yarna etarlaraka erinha alpmelitjika. ");
INSERT INTO are_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kala tharraminyintarangantama etnakurna pitjalpumala, era etnanha pmarraka, “Yakai, rrangkarra kutantema ankwentama, iltjerrama turta? Kala kunha. Arai, antala era kala namantama, arrpunhala Relhaka ‘Lira erinha leltjaka lanthitjika. ");
INSERT INTO are_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mpa, kala kamerrai. Artwa erala yinganha leltjaka lanthitjinala, erataka kala pitjikantama.” ");
INSERT INTO are_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesuanha kurtungurla ekuranha ntjarrurna angkamalangantema, Judas-anha, kurtungurla 12 etnakanga nyinta, era kala pitjikantama, worla kngarrakarta. Artwa worla nhanhataka priest-aka itornka ntjarrala, artwa Intarrangaltha ntjarrala, kngarripata itornka ntjarrala turta Judas-alela yairnakala, Jesuanha errkutjika. Worla etna Jesuaka pitjika knife tjenyakarta, tnamakarta turta. ");
INSERT INTO are_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas-ala artwa nhanha etnanha arrkurlantema ilakala, “Arai, artwa erinhala atha rrontjitjina, erinha errkwai, montjala kngetnai turta.” ");
INSERT INTO are_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas-anhantama Jesuurna arratja kuta lhaka. “Kaltjinthanhinthanhai,” era erinha anparnaka. Kurunga era erinha rrontjaka. ");
INSERT INTO are_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Artwa etnantama Jesuanha errkuka. ");
INSERT INTO are_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Artwa nyinta arrpunha erala lenhala itnarlanaka, era knife tjenya ekuranhala High Priest-aka urrkapunhapunhanha tuka, ilpa ekuranha inturnaka turta. ");
INSERT INTO are_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesualantama artwa worla etnanha pmarraka, “Artwa nyilkngampa tunhatunhaka ngerrama rrangkarra knife tjenyakarta, tnamakarta turta nuka pitjika? ");
INSERT INTO are_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Atha pula rrangkarranha arltamarlta temple-ala kaltjinthitjata. Rrangkarra turta yinganha itja errkuka. Lyarta pula rrangkarra yinganha errkuka Altjirraka Angkatja Imankinya nthurrperritjinanga.” ");
INSERT INTO are_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kurunga Jesuaka kurtungurla ntjarrala erinha impurlalhamala, tira arrtjanaka. ");
INSERT INTO are_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Artwa nthitja nyinta pula itjala tira arrtjanaka. Era Jesuanga tnaartangala kuta lhaka. Etna erinha turtantama errkuka, mantarra ekuranha errkumala. ");
INSERT INTO are_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Etna pula mantarra ekuranha errkumalanga, era mantarra erinha impurlalhamala, kala ilkngarantama arrtjanaka. ");
INSERT INTO are_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kurunga priest itornka ntjarra, kngarripata itornka ntjarra, artwa Intarrangaltha ntjarra turta High Priest-aka ilthala worlerraka. Artwa lenha ntjarra, etnala Jesuanha errkukala, etna erinha High Priest-urnantama rretjingaka. ");
INSERT INTO are_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter-ala etnanha ingkarnangala lurnaka. Etnantama High Priest-aka ilthurna irrpunhamalanga, Peter-anha High Priest-aka yard-urnala irrpunhaka. Erantama High Priest-aka urrkapunhapunha ntjarralela arrarnalhaka, urala arrtjitjinala. ");
INSERT INTO are_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Priest itornka ntjarra, relha Jew ingkarrakaka council kngarra era turta antja naka Jesuanha imilitjika. Council nhanha etnanha etna Sanhedrin alpmelitjata. Etnantama artwaka yonthaka, Jesuanha ilparnitjika. ");
INSERT INTO are_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nthurrpa ntjarrala Jesuanha orrtjerramala ilparnaka. Angkatja etnaka pula itja loala naka. ");
INSERT INTO are_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kurunga urrputja arrpunhantama orrtjerramala angkaka. ");
INSERT INTO are_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Etna angkaka, “Nurna wuka era lakinha angkamanga, ‘Temple nhanha relhalala itakala, atha urltakitjina. Arlta tharraminyintiperra atha temple arrpunhantama ititjina. Atha pula erinha itja iltjala ititjina.’” ");
INSERT INTO are_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Angkatja etnaka turta pula itjantema loala naka. ");
INSERT INTO are_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","High Priest erantama kamerramala Jesuanha pmarraka, arrpunha ntjarranga alkngatharra. “Unta itjala angkama, artwa nhanha ntjarrala nganha ilparnamanga?” ");
INSERT INTO are_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesuanha pula tjukunya kuta itnaka. Era itja angkaka paka. High Priest-alantama erinha wotha pmarraka, “Unta Krista erama nama, Altjirra makalaria ekura ‘Lira?” ");
INSERT INTO are_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesuala erinha ilaka, “Yinga kala namakwia. Anmantama rrangkarra Relhaka ‘Lira erinha aritjina, Altjirra Ekarlta Inthorraka akwampinyala namanga. Rrangkarra erinha aritjina turta matarala alhurna pitjalpumanga.” ");
INSERT INTO are_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nhanha wumala, High Priest era mantarra ekuranha tjepakamala, etnanha ilaka, “Iwunhangantama nurna artwaka kuta yonthitjika, erinha ilparnitjika? ");
INSERT INTO are_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Rrangkarrarrpa wuka era Altjirranha arrampowumanga. Nthakinhantama rrangkarra etarlarama?” Etna ingkarrakala erinha imilaka. ");
INSERT INTO are_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Arrpunha ntjarralantama ekurakarlaka palha iwuka. Etna turta anngerra ekuranha korltamala, erinha tuka. Etnantama erinha pmarraka, “Nurnanha ilai, ngunhalama nganha tuka?” High Priest-aka urrkapunhapunha ntjarrala turtantama erinha errkumala tuka. ");
INSERT INTO are_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter-anha nhanga High Priest-aka yard-ala narlanaka. High Priest-aka marla urrkapunhapunha nyintantama ekururna pitjika. ");
INSERT INTO are_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Era Peter-anha araka urala arrtjimanga. Erantama Peter-anha ilaka, “Unta kunha Jesua Nazareth-arinyalela nakantema.” ");
INSERT INTO are_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Era pula yiparrarnalhaka. “Yinga itjama ekura kaltja. Yinga turta itja kaltja nhanha untala angkamalaka.” Erantama reoanga kuturna lhaka. Lukaluka orreantama ilkaka. ");
INSERT INTO are_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Marla urrkapunhapunha erantama Peter-anha wotha araka. Peter erataka artwa ntjarranga kuta itnaka. Era artwa etnanha ilaka, “Era kunha Jesua Nazareth-arinyalela nakantema.” ");
INSERT INTO are_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peter-anha pula wotha yiparrarnalhaka. Kurrka anma, artwa etnantama Peter-anha ilaka, “Untataka nthurrpa etnakanga nyinta namantema, unta artwa Galilee-arinya warta namanga.” ");
INSERT INTO are_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peter-anha pula angkaka, “Altjirrala arama yinga nthurrpa inthorra angkamanga. Yinga paka orrtjerramanga, era yinganha kala errilknga tweikanhanta. Yingataka artwa ekura itja kaltja, artwa nhanga ekuriperrala rrangkarra angkamanga.” ");
INSERT INTO are_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lukaluka orrea erantama wotha ilkaka. Peter-anha ilpangkakantama Jesualala erinha nhanga ilakala, “Lukaluka orrea era tharraranga ilkitjikanhangantema, unta yinganha kala tharraminyintaranga yiparrarnitjina.” Peter-anha kala itnikantantama. ");
INSERT INTO are_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kala ingutnhalantama priest-aka itornka ntjarra kngarripata itornka ntjarralela angkarraka, artwa Intarrangaltha ntjarralela, Sanhedrin Council etnakalela turta. Kurunga Jesuaka iltja yirnamala, etna erinha Pilate-urna rretjingaka, erinha Pilate ekura lanthaka turta. ");
INSERT INTO are_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate-alantama Jesuanha pmarraka, “Nthurrpama unta relha Jew ntjarraka king?” Jesuala erinha ilaka, “Lakinha unta angkama.” ");
INSERT INTO are_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Priest-aka itornka ntjarralantama Jesuanha kngarra ilparnaka. ");
INSERT INTO are_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilate-alantama erinha wotha pmarraka, “Unta etnanha tjukunyalama wurlanama? Etna pula nganha kngarra inthorra ilparnama.” ");
INSERT INTO are_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesuanha pula pmarna kuta itnaka. Nhanha aramala Pilate-anha kngarra tnolkaka. ");
INSERT INTO are_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Passover-aka arltala, Pilate-ala kutatha artwa nyintanha jail-anga rratalhelitjata. Artwa nhanha erinha relha ntjarrala urraritjata. ");
INSERT INTO are_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Artwa nyinta jail-ala naka, rretnya ekura Barabbas. Era artwa urrarna naka. Era nhanga artwa arrpunha ntjarralela government-aka irrpaltherrakala. Barabbas etnantama ingkarraka jail-ala naka. ");
INSERT INTO are_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Relha ntjarralantama Pilate-anha ilpangkalhelaka era artwa nyintanha jail-anga rratalhelitjika. ");
INSERT INTO are_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilate-alantama etnanha pmarraka, “Rrangkarra antja nama atha relha Jew ntjarraka king althakalthilitjika?” ");
INSERT INTO are_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilate-anhataka kaltja naka Priest-aka itornka ntjarrala Jesuanha ekura lanthakala, etna Jesuaka antjakunya namanga, itja Jesuanha paala ntelalhakalanga. ");
INSERT INTO are_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Priest-aka itornka ntjarrala pula relha ntjarranha turnaka etna Pilate-anha ilitjika era Barabbas-anha jail-anga rratalhelitjika. ");
INSERT INTO are_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate-alantama etnanha wotha pmarraka, “Jesuanhaloa? Erinhala rrangkarra ilama era relha Jew ntjarraka king namanga. Atha erinha nthakinhilitjikala?” ");
INSERT INTO are_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Etna ilkaka, “Erinha kala ntolkakanta kanthatwai.” ");
INSERT INTO are_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate-ala pula etnanha wotha pmarraka, “Iwunhakakwia? Era itjama paala ntelalhaka paka.” Etna pula intarralkura ilkaka, “Erinha kala ntolkakanta kanthatwai.” ");
INSERT INTO are_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate-anha antja naka relha ntjarraka kangkwerritjika. Lakinhanga era Barabbas-anha jail-anga rratalhelaka. Era turta tjapartia ntjarranha turnaka Jesuanha whip-ala tumala ntolkaka kanthatutjika. ");
INSERT INTO are_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kurunga tjapartia ntjarrala Jesuanha iltha kwanurna kngaka. Etna tjapartia arrpunha ntjarranha turtantama worlilaka. ");
INSERT INTO are_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kurunga etna Jesuaka mantarra thathaka ekarraka. Kaarntakaarnta ilakwiperra turtantama mpaaramala, etna nhanha kapurta ekuranhaka arrarnaka. ");
INSERT INTO are_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kurunga etna erinha arrampowumala ilaka, “Wortai, relha Jew ntjarraka king-ai.” ");
INSERT INTO are_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kurunga etna kapurta ekuranha wilpawilpala tuka, ekura palha iwuka, ekuranga urlarra mparalela turta arrarnalhaka, urrkurrkintja namala ngerra. ");
INSERT INTO are_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Etna erinha kala arrampowukalangantama, etna mantarra thathaka nhanga wotha iluka, mantarra ekuranha turta wotha ekura ekarraka. Kurunga etna erinha kathurna rretjingaka, erinha ntolkaka kanthatutjinala. ");
INSERT INTO are_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tjapartia ntjarrala artwa nyintanhantama araka anpara lhamanga. Etnantama erinha turnaka, era Jesuaka ntolka kngitjika. Artwa nhanha ekura rretnya naka Simon, pmara Cyrene-arinya. Era Alexander Rufus tharraka kaarta naka. ");
INSERT INTO are_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Etnantama Jesuanha pmara Golgotha-urna rretjingaka, nhanhatitja ‘Kaalkngaka Pmarurna’. ");
INSERT INTO are_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nhanhala etna erinha wine ntjutjika nthaka, wine nhanga myrrh-akartakwia. Era pula itja antja naka. ");
INSERT INTO are_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Etnantama Jesuanha ntolkaka kanthatuka. Kurunga etna mantarra ekuranha errarnpalhelaka, gamble-erramala. ");
INSERT INTO are_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Arai, nhanha kala 9 o'clock ingutnhala naka, etna nhanga Jesuanha ntolkaka kanthatumalanga. ");
INSERT INTO are_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pepakarlaka, ntolka kartninyala, etna angkatja nhanha intalhelaka, “Relha Jew ntjarraka King era.” ");
INSERT INTO are_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Tjapartia etna artwa korna tharra turta ntolkaka kanthatukantema. Nyinta Jesuaka akwampinyala, arrpunha ekuranga kwanginyala. ");
INSERT INTO are_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Relha anpara lhamala ntjarra, etnantama Jesuanha kngarra arrampowuka. Kapurta ngalhamala etna erinha ilaka, “Untama Altjirraka temple urltakitjika nakala, erinha arlta tharraminyintala wotha ititjika turta? ");
INSERT INTO are_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tangkalhelalhai, ntolkanga tnanpumala.” ");
INSERT INTO are_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Priest-aka itornka ntjarrala, artwa Intarrangaltha ntjarrala turta erinha arrampowukantema. Etna angkaka, “Era kunha arrpunha ntjarranha tangkalhelaka. Erarrpa pula yarnala tangkalhelalhama. ");
INSERT INTO are_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Arai, unta paka Krista era namanga, Israel-aka king, kala ntolkanga tnanpai. Nurna nhanha aramalanga nurna nganha tnakitjina.” Artwa nhanga tharra, erinhatharrala tjapartiala Jesuanga kutaka ntolkaka kanthatukala, eratharra turta Jesuanha arrampowukantema. ");
INSERT INTO are_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kala ngkinyalantama, alkira era thapathaperraka, pmara ntjapara turta thapathapa naka 3 o'clock-akurtitja. ");
INSERT INTO are_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jesuanhantama ilkarlalhaka, “Eloi, Eloi, lama sabachthani,” nhanhatitja, “Altjirra nukai, Altjirra nukai, iwunhangala unta yinganha ipmintja impuka?” ");
INSERT INTO are_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Relha urrputja arrpunha, etnala ntolkanga kuta itnarlanakala, etna Jesuanha ilkamanga wuka. Etnantama ilarraka, “Arai, erataka Elijah-aka ntangkalhama.” ");
INSERT INTO are_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Artwa nyintantama parrpa irna alkumpaka arrtjanaka, nhanha turta wine tjalangkaka thankuka. Kurunga alkumpa erinha irna tjenyaka arrarnamala, era nhanha Jesuaka imarnaka, ntjutjika, lakinha angkamala, “Nurna kaaralhiai aritjika. Thunga paka Elijah-anha pitjitjina erinha ntolkanga tnanpulhelitjika, thunga itja.” ");
INSERT INTO are_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesuanha pula intarra ilkarlalhamala, kala ilukantala. ");
INSERT INTO are_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jesuanha warta iluka, kanha mantarra kngarritja nhanga, erala temple kwanala ilparanakala, era kartninyangatjina kwaninyakurtitja tjepakalhalalhaka. ");
INSERT INTO are_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Rome-arinya itornka nyinta Jesuanga urlarra itnarlanaka. Era Jesuanha aramalanga lakinha ngerra ilumanga, era angkaka, “Nthurrpathoa artwa nhanha Altjirraka ‘lira naka.” ");
INSERT INTO are_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Arrkutja ntjarrala turta nhanha ingkarraka ararlanaka, tjathanga. Arrkutja nhanha etnakanga arrpunha naka Mary Magdalene, arrpunha naka Mary nhanga James kurrkaka, Joses tharraka mia, Salome-anha turta. ");
INSERT INTO are_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Arrkutja nhanha etnataka Jesuanga tnaartangala pitjikala, Jesuaka tangitjala nakala turta, era Galilee-alantema namalanga. Arrkutja nhanha etnantama Jesualela pitjikala, Jerusalem-angatjina. ");
INSERT INTO are_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kala ngurrangurrantama naka, Friday arlta ekurala. Friday arltalataka relha Jew ntjarra ilkngilhitjatalka mpaarangaranga etnakanhamalkura, Sabbath arlta ekurakatjila. ");
INSERT INTO are_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph, artwa pmara Arimathea-arinya, era kunpa Pilate-urna lhaka, Jesuaka mpurrkaka enkitjika. Joseph nhanha erataka Sanhedrin council naka, artwa ilporatha pula. Era turta kaaralhaka Altjirranha ntelalhitjika era relha ingkarrakaka Ingkarta namanga. ");
INSERT INTO are_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate-anha pula eterraka, “Jesuanha yarna parrpa inthorra iluma.” Lakinhanga era tjapartia itornka nhangaka ntangkalhaka, era erinha pmarraka turta, “Jesuanha kalama iluka?” ");
INSERT INTO are_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Itornka era erinha ilaka, “Awa, era kala ilukakwia.” Pilate-alantama Joseph-anha ilaka era kala Jesuaka mpurrka initjika. ");
INSERT INTO are_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mantarra tjulkura marra buy-emilamala, Joseph-ala Jesuaka mpurrka ntolkanga ilulhelaka, mantarra tjulkura ekurala ilinyiwuka turta. Kurunga era mpurrka erinha wolkngaka kurnaka. Wolknga nhanhataka etna intia ngerra tnyakala. Kurunga era wolknga erinha marntilaka, parta kngarritja reoaka arrarnamala. ");
INSERT INTO are_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene, Mary nhanga Joses-aka mia, eratharra ararlanaka etna Jesuanha wolkngaka kurnamanga. ");
INSERT INTO are_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabbath arltiperra, Mary Magdalene-ala, Mary nhanga James-aka miala, Salome-ala turta, ntira unpa marra buy-emilaka, Jesuaka mpurrka parnitjinala. ");
INSERT INTO are_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kurunga Sunday ingutnhala inthorra, nhanga lirnnga rratitjikerramanga, etna wolkngurna lhaka. ");
INSERT INTO are_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tjaiyala lhapalhamala etna lakinha pmarrarraka, “Ngunhalantama nurnaka parta kngarritja nhanga wolkngaka reoanga ankartiwutjina?” ");
INSERT INTO are_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Etinyerramala pula etna araka parta erinha kala ankartiwukala. Parta erataka kngarritja inthorra naka. ");
INSERT INTO are_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wolknga ekururna irrpunhamala, etna artwa nthitja nyinta araka, mantarra tjulkura inthorrakarta, akwampinyala narlanamanga. Etnantama tnolkaka. ");
INSERT INTO are_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Artwa nthitja era pula etnanha ilaka, “Rrangkarra itja tnolkitjika. Rrangkarra kunha Jesuaka yonthama, artwa Nazareth-arinya nhangaka, erinhala etna ntolkaka kanthatukala. Arai, era errilknga ntjarranga kamerrakala. Era itja nhanhala nama. Katha etnala erinha nhanga arrarnakala, arai. ");
INSERT INTO are_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Rrangkarra kala lharrirrai kurtungurla ekuranha ntjarranha ilitjika, Peter-anha turta, era rrakangkarranga arrkurla lhamanga Galilee-urna. Pmara ekurakantama rrangkarra erinha aritjina. Era nhanga rrangkarranha ilaka.” ");
INSERT INTO are_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wolknga ekuranga rratamala, arrkutja etna tira arrtjanaka. Etna errurlperrowuka, yarna turta etarlaritjikerraka. Etna pula yia nhanga Jesuanha errilknga ntjarranga kamerrakala itja relha nyintanha ilaka, etna trerrakalanga warta. ");
INSERT INTO are_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sunday ingutnhala inthorra, errilknga ntjarranga kamerramaliperra, Jesuanha Mary Magdalene-aka ntelalhaka. Mary nhanha ekurangataka Jesuala nhanga errintja 7 unpurlenakala. ");
INSERT INTO are_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mary erantama lhamala yia nhanha Jesuaka tjina ltarrpa ntjarraka ilaka. ");
INSERT INTO are_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Etna pula erinha itja tnakaka, era ilamanga Jesuanha etatherrakala, era turtala erinha arakala. ");
INSERT INTO are_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Anma Jesuanha kurtungurla tharra arrpunhaka turtantama ntelalhaka, eratharra Jerusalem-anga kathurna lhamanga. Kamerramaliperra Jesuaka mpurrka kala arrpunha ngerrantama naka. ");
INSERT INTO are_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kurtungurla nhanha tharrala turta arrpunha ntjarranha ilaka eratharrala Jesuanha arakala. Etna pula angkatja ekuratharra itja tnakaka. ");
INSERT INTO are_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Anmalkura Jesuanha kurtungurla 11-akantama ntelalhaka, etna marna ilkumalanga. Erantama etnanha rralthaka etna arrthata namanga. Era turta etnanha rralthaka etna turta arrpunha ntjarranha itja tnakakalanga, etna etnanha ilamalanga era kamerrakala, etna turtala erinha arakala. ");
INSERT INTO are_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kurunga Jesuala etnanha ilaka, “Rrangkarra pmara ingkarrakurna lhitjika, alha nhanhala, relha ingkarrakanha turta Yia Marra erinha ilitjika. ");
INSERT INTO are_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Relha etnala Yia Marra erinha tnakama, etnanha turtala rrangkarra kaltjirrpulhelama, etnanha Altjirrala tangkalhelitjina. Etna pula, etnala Yia Marra erinha itja tnakama, etnanha Altjirrala imilitjina. ");
INSERT INTO are_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Relha etnala yinganha tnakama, etna tjatjikarta ntjarra urrkaputjina. Etna rretnya nukanhala errintja ntjarra unpurlenitjina. Etna angkatja arrpunhakalka angkitjina. ");
INSERT INTO are_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Apma arrangkulthala, arrangkultha arrpunhala turta etnanha yarna errilknga tutjina. Etna turta iltja etnakanha relha menta ntjarraka arrarnamala, etnanha marrilitjina.” ");
INSERT INTO are_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kurtungurla ekuranha ntjarranha nhanha ingkarraka ilamala, Altjirrala Jesuanha wotha alkirurna inetnaka. Jesua erantama Altjirraka akwampinyaka arrarnalhaka. ");
INSERT INTO are_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kurtungurla etna pula errarnperramala pmararrpaninhurna lhaka Yia Marra erinha ilitjika. Ingkartanha etnakalela naka, era turta angkatja etnaka ekarltilaka tjatjikartala. ");
INSERT INTO are_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ngurruka Altjirrala lhelintja imankinya ekuranha mangkilaka. Artwa arrpunha ntjarrala turtantama nhanhiperra yia intalhelaka, itja pula yia ingkarraka. ");
INSERT INTO are_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kurtungurla ntjarrala alknga etnakanhala araka Altjirrala lhelintja ekuranha mangkilamanga. Etnantama nurnanha nhanhiperra kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yinga turta artwa nhanha etnakanga montja kaltjerrakalanga, yinga eterraka yia etnanha ungkwangurna arratja inthorra intalhelitjika, Theophilus, tjina nukai. ");
INSERT INTO are_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kurunga unta turta kaltja nitjina yia nhanga etnala nganha kaltjinthakala, era yia arratja inthorra namanga. ");
INSERT INTO are_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Antala ekurala Herod-anhala pmara Judea-aka king namanga, priest nyinta Judea-ala naka, rretnya ekura Zechariah. Noa ekuranha Elizabeth-aka kaarta priest-ntema nakala. Zechariah era Abijah-aka ramarama naka. ");
INSERT INTO are_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zechariah Elizabeth tharra Altjirranga urlarra arratja kuta ntelalhaka. Eratharra Altjirraka turnintja ingkarrakaka arratja kangkwerraka, Altjirraka mpaarangaranga ingkarrakaka turta. ");
INSERT INTO are_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Eratharra pula katjiakunya naka, Elizabeth-anha lheaka namanga. Eratharra kala kngarripatanta tharrantama narraka. ");
INSERT INTO are_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kala arlta arrpunhalantama lakinherraka. Zechariah-akathakantama naka temple kwanala irna unpa marra altar kurrkala etitjika. Erinha urrkapuntja nhanhaka arrkurlantema urrarakala priest ntjarraka mpaarangarangamalkura. ");
INSERT INTO are_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Zechariah erantama temple kwanurna irrpuka irna unpa marra erinha etitjika. ");
INSERT INTO are_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kanha relha ntjarra etnala temple-urna pitjikala, Altjirrurna ingkitjika, etna kathalala kaaralhaka. ");
INSERT INTO are_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zechariah-ala irna unpa marra erinha etamalanga, Altjirraka angel ekururna rumerraka irna unpa marraka altar-anga akwampinyala itnatjalhamala. ");
INSERT INTO are_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Angel erinha aramala, Zechariah-anha yarna eterritjikerraka, era trerraka turta. ");
INSERT INTO are_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Angel era pula ekururna angkaka, “Unta trerritjala nai, Zechariah-ai. Altjirrala nganha wuka unta ekururna katjiaka ingkamalanga. Noa ungkwanganha Elizabeth-anha katjiakartantamerritjina, ekura turta worra katjia intitjina. Katjia era alkngerramalanga, unta erinha rretnya John alpmelitjika. ");
INSERT INTO are_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Unta arrkana inthorra nitjina era alkngerramalanga. Relha arrpunha ntjarra turta arrkana nitjinantema. ");
INSERT INTO are_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Altjirranga urlarra era artwa tjiparra inthorra nitjina. Erantama itja wine ntjutjika, ngkwarla arrpunha paka. Era kala Enka Alkngaltarakarta nitjina era itjantema alkngerrakalanga. ");
INSERT INTO are_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Erantama Israel-arinya ntjarranha Ingkarturna topalhelitjina, Altjirra etnakanhurna. ");
INSERT INTO are_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Era turta Ingkartnga arrkurla lhitjina. Lakinha era relha ntjarranha alkngampulhelitjina, etna Ingkartaka ilporatha kaaralhitjika. Elijah-ala ngerra turta, era relha korna ntjarranha angkatja ekarltala tjatjatutjina arratja ntelalhitjika.” ");
INSERT INTO are_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah-alantama angel erinha pmarraka, “Nthakinhantama atha angkatja ungkwanganha tnakamara? Yinga kala kngarripatakwia nama, noa nuka, era turta ingkwiantema nama.” ");
INSERT INTO are_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angel erantama erinha ilaka, “Yinga Gabriel nama. Yingataka Altjirralela nanhananha. Altjirra erarrpa turta yinganha ungkwangurna yairnaka, nganha yia marra nhanha ilitjika. ");
INSERT INTO are_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yingala angkakala nhanha kala nthurrperritjina. Unta pula angkatja nukanha itja tnakakalanga, unta itja irrpalthala angkitjina nhanha nthurrperrakalalpula.” ");
INSERT INTO are_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Relha ntjarra, etnala kathala itnarlanakala Zechariah-aka kaaralhamala, etna yarna eterritjikerraka, Zechariah era kuta yirramanga. ");
INSERT INTO are_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kurunga Zechariah era nthurrpantama temple-anga rrataka, era pula etnakurna yarna angkaka. Nhanha aramala, relha ntjarrala lhangkaraka era altjirrarakala. Zechariah-anha etnaka kwerraka. Era pula etnakurna yarna angkaka. ");
INSERT INTO are_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Arlta ekuranha ntjarra temple-ala urrkaputjika mangkilamaliperra, Zechariah-anha kala pmara ekuranhurna alpukantama. ");
INSERT INTO are_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kala anmantama noa ekura Elizabeth-anha katjiakarterraka. Elizabeth-anhantama 5 months iltha ekuranhala lauwulhaka. Era eterraka. ");
INSERT INTO are_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Nthurrpathoa Altjirranha nukurna tangitjala pitjika. Lyartanga relha arrpunha ntjarrala yinganha yarna wotha arrampowutjina, etnala yinganha lyartalpula arrampowukala ngerra, yinga katjiakunya nakalanga.” ");
INSERT INTO are_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth, Zechariah-aka noa era kala 6 months-ntama katjiakarta namanga, Altjirrala angel Gabriel-anha Nazareth-urna yairnaka. Nazareth erataka town naka pmara Galilee-ala. ");
INSERT INTO are_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Altjirrala Gabriel-anha urrpia yairnaka kwarra wonkurna, rretnya ekura Mary. Mary-anhataka Joseph-aka lhelakala, eratharra pula itjantema noa inarrakala. Joseph era David-aka ramarama naka. ");
INSERT INTO are_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angel erantama Mary-aka ilthurna irrpumala, erinha ilaka, “Arrkana nai! Ingkartanha ungkwanga kangkama, era turta ungkwangalela nama.” ");
INSERT INTO are_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Angkatja nhanha wumala, Mary-ala yarna etarlaraka, “Iwunhama angel era yinganha ilama?” ");
INSERT INTO are_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angel erantama ekururna wotha angkaka, “Mary-ai, unta itja trerritjika. Altjirranhataka ungkwanga kngarra kangkama. ");
INSERT INTO are_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Arai, untataka katjiakarterritjina, worra katjia turta ungkwanga intitjina. Untantama erinha rretnya Jesua alpmelitjika. ");
INSERT INTO are_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Era Altjirranga urlarra tjiparra inthorra nitjina, Altjirra Kngarra ekura 'Lira turta. Ingkarta Altjirrala erinha ingkairnitjina king nitjika, David-aka kathala. ");
INSERT INTO are_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Erantama Jacob-aka ramaramaka tjitjarterritjina ngampakala. Erarrpa turta ngampakala Ingkartakngarra nitjina.” ");
INSERT INTO are_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary-alantama angel erinha pmarraka, “Nthakinhantama nuka katjia intitjina? Yingataka artwaka kotna.” ");
INSERT INTO are_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angel era pula erinha ilaka, “Enka Alkngaltara era ungkwangurna irrputjina. Altjirra Kngarra era turta ungkwanga ntelalhitjina era ekarlta inthorra namanga. Lakinhanga katjia ungkwanga alkngaltara nitjina, Altjirraka 'Lira. ");
INSERT INTO are_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Unta tjina ungkwanganha Elizabeth-anha etarlarama, arrkutja ingkwia nhanganha? Relha ingkarraka angkaka era lheaka namanga. Lyarta pula era kala 6 months inpora nama, worra katjiakarta. ");
INSERT INTO are_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Arai, nhanha kala Altjirrakathaka nama. Era kala arrkutja lheakalka katjia nthama. ");
INSERT INTO are_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary-anhantama angkaka, “Yinga Altjirraka kangkwerrama. Angkatja ungkwanganha kala nthurrperriai.” Angel erantama alpuka. ");
INSERT INTO are_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kala arlta arrpunhalantama, Mary-anha tjaiyakerraka Zechariah Elizabeth tharraka pmarurna lhitjika. Zechariah tharraka ilthataka pmara Judea-aka naka, parta mpinyala. ");
INSERT INTO are_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mary-anhantama Zechariah-aka ilthakerraka. Ilthaka irrpunhamala, era Elizabeth-anha anparnaka, “Tjina nukai.” ");
INSERT INTO are_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mary-aka angkatja wumala, Elizabeth-aka katjia ngalhalalhaka, tnarta ekuranhala. Enka Alkngaltara era turtantama Elizabeth-urna irrpuka. ");
INSERT INTO are_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elizabeth erantama kangkamala angkaka, “Mary-ai, Altjirranha kunha ungkwanga kngarralkura kangkaka arrkutja ingkarraka arrpunhangatjina. Era turta katjia ungkwanganhaka kngarra kangkitjina. ");
INSERT INTO are_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yingantama arrkana inthorra nama Ingkarta nukanhaka mia nukurna yatjarra pitjikalanga. ");
INSERT INTO are_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nganha wumala ngerra, katjia nukanha arrkanerramala ngalhalalhaka. ");
INSERT INTO are_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Arai, unta arrkana kngarra nitjina, unta Altjirraka angkatja tnakakalanga, angkatja nhanga angel-alala nganha ilakala.” ");
INSERT INTO are_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary erantama angkaka, ");
INSERT INTO are_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","“Atha Ingkartanha kngarra tnantjama, Yinga turta arrkana nama Altjirrala yinganha tangkalhelakalanga. ");
INSERT INTO are_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Arai, era nuka, relha kornakornaka ilpangkaka. Lyartanga relha ingkarraka angkitjina, ‘Altjirra kunha ekuranta kngarralkura kangkaka.’ ");
INSERT INTO are_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Altjirra ekarlta era nuka kngarra tangitjala naka. Altjirra era alkngaltara kuta nama. ");
INSERT INTO are_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Relha etnala Altjirriperra arratja etarlaramanga, etnaka era montjamontja ntelalhitjina ngampakala. ");
INSERT INTO are_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Era ntelalhaka era ekarlta namanga, relha irrpaltherramala ntjarranha ekngekngilamala. ");
INSERT INTO are_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tjitjarta kngarra ntjarranha era unpurlenaka, relha kornakorna ntjarranhatitjantama era ingkairnaka tjitjarterritjika. ");
INSERT INTO are_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Relha ngaiyala ntjarranha era marna ilkutjika nthaka, kanha relha netaneta ntjarranha era rapala yairnarlenaka. ");
INSERT INTO are_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Erala errilkngipata nurnakanha ntjarranha lhelakala ngerra, era Israel-aka ramaramaka tangitjala pitjika. ");
INSERT INTO are_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Era ilpangkaka Abraham-aka, Abraham-aka ramaramaka turta kutatha montjamontja ntelalhitjika.” ");
INSERT INTO are_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary-anhantama Elizabeth-alela 3 months kuterraka. Kurunga era wotha pmara ekuranhurna alpuka. ");
INSERT INTO are_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Anma Elizabeth-aka worra katjia alkngerrakantama. ");
INSERT INTO are_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Relha pmararinya ntjarrala nhanhiperra wuka, Elizabeth-aka tjina ntjarrala turta. Etnantama arrkana kngarra naka Altjirranha Elizabeth-aka ilpangkakalanga erinha worra katjia nthamala. ");
INSERT INTO are_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Worra era arlta 8 ingkwia namalangantama, tjina ntjarra pitjika Zechariah tharralela nitjika etna worra erinha artwilamanga. Tjina etnantama antja naka worra erinha rretnya Zechariah alpmelitjika, kaarta ekuranha ngerra. ");
INSERT INTO are_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mia ekuranha pula angkaka, “Itja! Erinha rretnya John alpmelitjika.” ");
INSERT INTO are_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Etna pula erinha ilaka, “Tjina ungkwanganha arrpunha itjama rretnya lenhakarta nama.” ");
INSERT INTO are_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Etnantama Zechariah-aka kwerraka, erinha pmarraka turta, “Rretnya ngunhama unta antja nama worra erinha alpmelitjika?” ");
INSERT INTO are_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kwerramala Zechariah-anha enkaka, etna erinha irna intalhelanhakanha nthitjika. Irna ekurakarlakantama era intalhelaka, “Era nama rretnya John.” Nhanha aramala etna ingkarraka tnolkaka. ");
INSERT INTO are_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kurunga Zechariah-aka linya wotha ilulhaka. Erantama angkaka, Altjirranha tnantjaka turta. ");
INSERT INTO are_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Relha ekuralela namala ntjarra etna kngarra tnolkaka, etna turta yia nhanha relha ingkarrakanha ilaka, etnala Judea-aka partala namanga. ");
INSERT INTO are_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Relha nhanha etnantama yia nhanhiperra kuta eterralanaka. Etna turta pmarrarraka, “Katjia nhanha nthakinhama erritjina?” Etna lhangkarakakwia Ingkartala erinha kaaramanga. ");
INSERT INTO are_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Enka Alkngaltara erantama Zechariah-urna irrpuka. Erantama etnanha Altjirraka angkatja ilaka, ");
INSERT INTO are_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nurna Ingkartanha tnantjitjika, relha Israel-arinya ntjarraka Altjirranha. Era nurnakurna, relha ekuranha ntjarrurna tangitjala pitjika, nurnanha tangkalhelaka turta. ");
INSERT INTO are_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Era artwa tangkalhelanha ekarlta nurnakurna yairnaka. Era David-aka ramarama nama. ");
INSERT INTO are_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Imankantema, urrpia ekuranha ntjarrarlarlanga era nurnanha lhelaka, ");
INSERT INTO are_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","era nurnanha leltja nurnakanhanga tangkalhelitjinala, relha lenha ntjarranga turta, etnala nurnaka yirrkngerramanga. ");
INSERT INTO are_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Era nhanga errilkngipata nurnakanha ntjarranha ilaka, era etnaka montjamontja ntelalhitjinala, era turta lhelintja ekuranhaka ilpangkitjinala. ");
INSERT INTO are_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Angkatja ekarltala era Abraham-anha lhelaka, ");
INSERT INTO are_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","era nurnanha leltja nurnakanhanga tangkalhelitjinala. Nurnantama ekura tnoatnoa urrkurrkintja nitjinanga. ");
INSERT INTO are_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nurna turta kutatha arratja ntelalhitjinanga, ekura arltamarlta eterramala. ");
INSERT INTO are_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Worra nukai, unta pula Altjirra Kngarra ekura urrpiala nitjina. Untantama Ingkartnga arrkurla lhitjina, ekura tjaiya urrkaputjika. ");
INSERT INTO are_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Unta relha ekuranha ntjarranha ilitjina Altjirrala etnanha tangkalhelitjinala, korna etnakanha iwumala, ");
INSERT INTO are_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","era kangkintja montjamontja namanga warta. “Altjirrala Tangkalhelanha erinha nurnakurna alkiranga yairnitjina. ");
INSERT INTO are_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Arai, nurna relha errilknga ngerra nama, pmara thapathapala turta. Altjirraka Tangkalhelanhala nurnanha parrtjilitjina, lirnngala ngerra. Era turta nurnanha kaltjinthitjina, urlarrakurlarra rilhera ntelalhitjika.” ");
INSERT INTO are_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","John era mangkakantama, eterrintja ekuranha turta arratja kuta ekarlterranhaka. Erantama worritjala kuterraka arlta lenhalpula era urrkapuntja ekuranha tjontitjinala. ");
INSERT INTO are_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kala lakinherrakantama. Caesar Augustus-ala turnaka relha ekuranha ingkarraka inthorra count-emilitjika. ");
INSERT INTO are_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Etnantama relha ingkarrakanha count-emilaka Quirinius era pmara Syria-ala itornka namalanga. Etna itja relha etnanha arrkurla count-emilakala paka. ");
INSERT INTO are_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Relha ingkarrakantama kaarta etnakanhaka pmarurna alpuka, government-ala rretnya etnakanha intalhelitjinanga, etnanha count-emilitjinanga turta. ");
INSERT INTO are_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Lakinhanga Joseph-anha Nazareth-anga Bethlehem-urna lhaka. Nazareth erataka pmara Galilee-ala naka, kanha Bethlehem-anha pmara Judea-alala. Joseph erataka Bethlehem-urna lhaka, King David-anha imanka Bethlehem-ala alkngerrakalanga, era turta David-aka ramarama namanga. ");
INSERT INTO are_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Era Mary, arrkutja lhelintja ekuranhakarta lhaka, government-ala rretnya ekuratharra intalhelitjika. Mary era katjiakarta inpora naka. ");
INSERT INTO are_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Eratharrantama Bethlehem-ala namalanga, Mary era wulhaka. ");
INSERT INTO are_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Worra arrkurlinya ekuranhantama alkngerraka. Erantama erinha mantarrala ilinyiwuka, erinha tharrkakanha box-aka turta thanaka. Eratharrataka tnonthaka ilthala intaka, iltha nhanga relha epinya intanhintanha era lyulpalyulpa namanga. ");
INSERT INTO are_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bethlehem-anga etinya sheep tnairnarintja urrputja kathala naka, sheep etnakanha ingula ntarntaramala. ");
INSERT INTO are_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Altjirraka angel-ntama etnaka rumerraka, Altjirraka parrtjala turta etnanha parrtjilhelaka. Etnantama yarna thakerraka. ");
INSERT INTO are_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angel era pula etnanha ilaka, “Rrangkarra itja trerritjika. Yingataka yia marrakarta pitjika. Rrangkarra yia nhanha wumalanga, rrangkarra arrkana nitjina, relha arrpunha ingkarraka turta. ");
INSERT INTO are_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Arai, lyarta David-aka town-ala Tangkalhelanha rrakangkarra alkngerraka, Krista Ingkarta era. ");
INSERT INTO are_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kala lharrirrai. Rrangkarra katjia kurrka aritjina tharrkakanha box-ala intamanga. Mia ekuranhalataka erinha mantarrala ilinyiwukala. Katjia erinha aramala rrangkarra kaltja nitjina atha rrangkarranha angkatja nthurrpa ilakala.” ");
INSERT INTO are_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kurunga angel ntjarra inthorrantama angel nyinta ekuralela alkirala itnatjalhaka. Etna Altjirranha tnantjaka lakinha lyilhamala, ");
INSERT INTO are_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Alkirala, Altjirranha makalaria inthorra nama. Alhala era rilhera ntelalhama, relha etnaka, etnakala era kangkama.” ");
INSERT INTO are_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angel etna kala alkirurna alpukalangantama, tnairnarintja etna lakinha angkarraka, “Mpa, nurna Bethlehem-urna lharrirriai, katjia kurrka erinha aritjika, ekuriperrala Altjirrala nurnanha ilakala angel-aka angkatjarlarlanga.” ");
INSERT INTO are_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Etnantama parrpa Bethlehem-urna lhaka. Etna nthurrpa Mary-anha, Joseph-anha turta arltaraka, katjia kurrka erinha turta tharrkakanha box-ala intamanga. ");
INSERT INTO are_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Katjia kurrka erinha aramala, etna Mary Joseph tharranha angel-aka angkatja alpmelaka. Etna pmararinya ntjarranha turta angkatja nhanha alpmelaka. ");
INSERT INTO are_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Relha ntjarrala yia nhanha wumalanga, etna tnolkaka. ");
INSERT INTO are_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary-anha pula angkatja nhanhaka kuta eterralanaka turta. ");
INSERT INTO are_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Alpumalantama tnairnarintja etna Altjirranha kngarra tnantjaka. Etna arrkana turta naka, angel-aka angkatja arratja inthorra nakalanga. ");
INSERT INTO are_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Worra era kala arlta 8 ingkwiantama namalanga, etna erinha artwilaka. Angel-ala nhanga Mary-anha turnakalanga warta, etna erinha rretnya Jesua alpmelaka. ");
INSERT INTO are_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Anma, antala arratjala, Joseph Mary tharra Jerusalem-urnantama lharraka, Moses-aka turnintja arrpunhaka kangkwerritjika. Eratharra Jesuanha turta kngaka, worra erinha Altjirranga buy-emilitjika ngerra. ");
INSERT INTO are_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Altjirraka Angkatja Imankinyala lakinhakwia ilaka, “Orrea arrkurla alkngerramala ingkarraka tweta Altjirraka nama.” ");
INSERT INTO are_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Altjirraka Angkatja Imankinya arrpunhala turta ilaka, kaarta pa miala worra arrkurlinya ekuratharrakanha Altjirranga buy-emilitjika ngerra, Altjirranha tjauwerrilya nthamala. Eratharra Altjirranha palkara mpangarra, nturrurta kurrka tharra paka nthitjika. Joseph Mary tharra kala angkatja nhanhaka kangkwerraka. ");
INSERT INTO are_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Artwa arrpunha Jerusalem-ala naka, rretnya ekura Simeon. Erataka artwa arratja, ilporatha turta naka. Era turta kaaralhalanaka Altjirraka Tangkalhelanha pitjitjika. Simeon era Enka Alkngaltarakarta naka. ");
INSERT INTO are_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Enka Alkngaltarala erinha arrkurlantema lhelakala era itja ilutjinala era Ingkartaka Krista aritjinalpula. ");
INSERT INTO are_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Enka Alkngaltaralantama Simeon-anha ilaka, temple-urna lhitjika. Simeon-anha kala temple-ala namalangantama, Joseph Mary tharra Jesuakarta temple-urna irrpentjika. Eratharra pitjika Moses-aka mpaarangaranga nhangaka kangkwerritjika. ");
INSERT INTO are_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon-ala katjia erinha aramala, era erinha malthala inaka, era turta Altjirranha tnantjaka, ");
INSERT INTO are_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Lyarta Ingkartai yinga kala arrkana ilumara. Arai, untala yinganha lhelakala ngerra, ");
INSERT INTO are_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","atha Tangkalhelanha erinha kala arakantama. ");
INSERT INTO are_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Unta erinha relha ingkarrakanga alkngatharra ingkairnaka. ");
INSERT INTO are_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Erantama Relha Lorinya ntjarranha alkngampulhelitjina. Era turta relha ungkwanganha ntjarranha, Israel-arinya ntjarranha, tnantjitjina.” ");
INSERT INTO are_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Katjia ekura kaarta pa mia, eratharra tnolkaka Simeon-aka angkatja wumala. ");
INSERT INTO are_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon-alantama erinhatharra lyekarrilaka. Era turta Mary-anha lakinha ilaka, “Arai, katjia nhanhalataka Israel-arinya ntjarranha nakapakarlilitjina. Relha etnala ekura antjakunya namanga, etna kornilalhitjina. Kanha relha etnala ekura kangkamanga, etnanha era tangkalhelitjinala. Lakinha relha ingkarrakaka eterrintja katherritjinantama. ");
INSERT INTO are_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Arai, unta pula anma ltarrpa kngarra nitjina.” ");
INSERT INTO are_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Altjirraka urrpia arrpunha turta temple-ala nakantema, arrkutja ingkwia inthorra nyinta, rretnya Anna. Era Phanuel-aka kwarra naka, Asher-aka ramarama. Era warlukurta naka. Era 7 years wara noa tnyinakala. ");
INSERT INTO are_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Era kala 84 years ingkwiantama naka. Era temple-ala kuterraka, Altjirraka urrkurrkintja nitjata turta, ekururna ingkamala. Arrpunharanga Altjirranha etarlaramala, era marna turta imputjata. ");
INSERT INTO are_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Anna erantama Joseph Mary tharrurna etinyerraka. Era Altjirranha dangkilaka. Relha arrpunha ntjarra turta Tangkalhelanha ekura kaaralhakantema. Erantama etnanha turta yia marra katjia ekuriperra ilaka. ");
INSERT INTO are_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joseph Mary tharrala kala Altjirraka mpaarangaranga ingkarraka mangkilakalangantama, eratharra Jesuakarta Nazareth town-urna alpuka. Nazareth erataka pmara Galilee-ala naka. ");
INSERT INTO are_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pmara nhanhala katjia era mangkaka, ekarlterraka turta. Kurrkangatjinantema era eterrintja marrakarta naka. Altjirrala erinha kaaraka, ntarntaraka turta. ");
INSERT INTO are_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesuaka kaarta pa mia, Altjirraka turnintjaka kangkwerramala, kutatha Jerusalem-urna lhitjata Passover arlta kngarraka. ");
INSERT INTO are_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesuanha kala 12 years ingkwiantama namalanga, eratharra Jesuakarta turtantama lhaka. ");
INSERT INTO are_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Relha etna Passover arlta kngarra erinha kala mangkilakantama. Kurunga Joseph Mary tharra kala alpurrakantama, worla nhanga etnala pitjikalalela porta kuta. Kanha Jesua-anha Jerusalem-alala kuterramala naka. Joseph tharra pula nhanhaka kotnala naka. ");
INSERT INTO are_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Eratharra tjaiyala lhapalhamanga, eratharra etarlaraka Jesua era kula worlalela namanga. Kanha Jesua era Jerusalem-alala kuterramala naka. Eratharrantama kunpa kuta arlta ntjapara lhapalharraka. Ngurrangurrantantama eratharra Jesuaka yonthaka tjina ntjarranga. ");
INSERT INTO are_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yonthamala, yonthamala, ekura pula yarna kuta yonthamala, eratharra kala Jerusalem-urnantama alpurraka tanhala ekura kuta yonthitjika. ");
INSERT INTO are_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Arlta arrpunhalantama eratharra erinha nthurrpa arltaraka temple kwanala. Era kaltjinthanhinthanha ntjarranga mpopala naka, etnanha wurlanamala, pmarralanamala turta. ");
INSERT INTO are_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Relha ingkarraka ekura tnolkaka, era kaltja inthorra namanga. ");
INSERT INTO are_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Erinha temple kwanaka aritjalhamala, kaltjinthanhinthanha ntjarranga mpopala, Joseph tharra tnolkaka. Mia ekuranhalantama erinha pmarraka, “Worra nukai, iwunhangama unta ilirnanha lakinhilaka? Ilirnataka enkakunya inthorrerramala ungkwanga yonthalapuka.” ");
INSERT INTO are_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Era pula erinhatharra ilaka, “Iwukala mpala nuka yonthaka? Mpala kaltja neikanha yinga Kaarta nukanhaka ilthala namanga.” ");
INSERT INTO are_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Eratharra pula angkatja ekuranha itja lhangkaraka. ");
INSERT INTO are_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesuantama ekuratharralela Nazareth-urna alpuka, era ekuratharra kangkwerramala turta naka. Mia ekuranha pula nhanhiperra kuta eterralanaka. ");
INSERT INTO are_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesua erantama mangkaka, kuta inangkarlerramala. Altjirranha, relha ingkarraka turta ekura kangkaka. ");
INSERT INTO are_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberius Caesar-anha kala 15 years tjitjarta kngarra nakalanga, Pontius Pilate-anha pmara Judea-ala tjitjarta naka. Herod-anha pmara Galilee-ala tjitjarta naka, kanha tjia ekura Philip-anha pmara Iturea-ala, pmara Traconitis-ala turta tjitjarta naka. Lysanias-anha pmara Abilene-ala tjitjarta naka. ");
INSERT INTO are_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas Caiaphas tharra Altjirraka high priest naka, Jerusalem-ala. Antala nhanha ekurala John-anha, Zechariah-aka worra nhanga, worritjala naka. Altjirranhantama ekururna angkaka. ");
INSERT INTO are_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kurunga John-ala relha ntjarranha kaltjinthaka, Jordan Lhiranga kutala. Era etnanha ilaka, “Altjirrurna toperrai. Kurunga pitjai atha rrangkarranha kaltjirrpulhelitjinanga, Altjirrala turta korna rrakangkarranha iwutjinanga.” ");
INSERT INTO are_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaiah, Altjirraka urrpia imankinyala, yia nhanha John-iperra intalhelakala, “Artwa nyinta worritjala ilkama, Ingkartaka tjaiya mpaarai, tjaiya ekuranha arratjilai. ");
INSERT INTO are_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ilirrtja etnanha taakai. Parta tjenya etnanha urltakamala, kurrkilai. Tjaiya ingkurtingkurta etnanha arratjilai. Tjaiya ipartiparta etnanha turta yilkilai. ");
INSERT INTO are_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kurunga relha ingkarrakala aritjina Altjirrala etnanha tangkalhelamanga.” ");
INSERT INTO are_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Relha ntjarrantama John-urna pitjika, era etnanha kaltjirrpulhelitjika. Era pula etnanha ilaka, “Apma ngerra ntjarrai! Ngunhalama rrangkarranha ilaka rrangkarra kula Altjirraka aa kngarranga erruntarerritjinala? ");
INSERT INTO are_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Arrkurla rrangkarra ntelarrirrai rrangkarra nthurrpa Altjirrurna toperrakala, arratja turtantama namanga. Rrangkarra turta itja tnakalhitjika Altjirrala kula rrangkarranha makaritjina, rrangkarra Abraham-aka ramarama namanga. Atha rrangkarranha ilama, Altjirrala Abraham-aka ramarama arrpunha parta nhanha ntjarranga irrpalthala arrpmarnamara. ");
INSERT INTO are_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Arai, inguntha wara Altjirrala relha lenha ntjarranha kala rrarrathala tutjina, etnala itja korna etnakanhanga toperramanga, arratja turtantama ntelalhamanga.” ");
INSERT INTO are_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Relha etnantama John-anha pmarraka, “Nthakinhantama nurna urlarrakurlarra ntelalhitjika?” ");
INSERT INTO are_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Era etnanha ilaka, “Relha ekurala mantarra tharra intamanga, era nyinta ntheikanha relha ekururna, erala mantarrakunya namanga. Relha ekurala marna intamanga, era marna ekuranha tangilamala ntheikanha relha erinha, erala marnakunya namanga.” ");
INSERT INTO are_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Artwa tax money kotjinha turta ekururna pitjika, era etnanha kaltjirrpulhelitjika. Etna erinha pmarraka, “Kaltjinthanhinthanhai, nurna paka nthakinha ntelalhitjika?” ");
INSERT INTO are_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Era etnanha ilaka, “Money nthakintjama arratja nama rrangkarra kotjitjika? Kala money lakintjanta wara rrangkarra kotjitjika, itja wothalkura.” ");
INSERT INTO are_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tjapartia ntjarrala erinha pmarrakantema, “Nurnaloa? Nurna nthakinhala ntelalhitjika?” Era etnanha ilaka, “Rrangkarra itja errauwia ntelamala relhanga money rakitjika, etnanha orrtjerramala ilparnitjika paka. Wages nhanga itornka rrakangkarranhala rrangkarranha nthama, kala lenhakarta kunpa narrirrai.” ");
INSERT INTO are_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Relha etnantama thakerraka, John-iperra lakinha turta pmarrarraka, “Artwa nhanhama Krista era, ekurala nurna kaaralhama?” ");
INSERT INTO are_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John-ala pula etnanha ilaka, “Athataka rrangkarranha kwatjalanta wara kaltjirrpulhelama. Arai, artwa arrpunha pula nukanga ingkarna pitjima, erala nukanga ekarltalkura nama. Yinga itja yalknga nama topanamala sandal ekuranha ilutjika. Era pula rrangkarranha Enka Alkngaltarala, urala turta kaltjirrpulhelitjina. ");
INSERT INTO are_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Era relha ingkarrakanha ilkngakitjina, relhalala annga marra ntjarra irrtnya kornanga ilkngakamanga ngerra. Relha marra ntjarranha era pmara ekuranhaka arrarnitjina, kanha relha korna ntjarranha era ura ngampakalurnala iwutjina.” ");
INSERT INTO are_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Lakinha John-ala relha ntjarranha kngarra kaltjinthaka, etnanha Yia Marra erinha turta ilaka. ");
INSERT INTO are_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herod-anha pula, artwa tjitjarta nhanganha, era lakinhala tjatjatuka, “Untataka korna ntelalhaka, Herodias-anha, tjia ungkwanganhaka arrkara, noa ekngumala. Unta turta Altjirraka, relha arrpunha ntjarraka turta, kutatha korna ntelalhaka.” ");
INSERT INTO are_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Angkatja nhanhakakwia Herod-anha John-aka yirrkngerraka. Angkatja nhanhanga arrkngala turta era John-anha anma jail-aka kurnaka. ");
INSERT INTO are_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","John-ala nhanga relha ntjarranha kaltjirrpulhelamalanga, era Jesuanha turta kaltjirrpulhelaka. Kurunga Jesuanha Altjirrurna ingkamalanga, alkira era altjurerraka. ");
INSERT INTO are_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Enka Alkngaltara era turtantama nturrurtaka mpurrkakarta Jesuakarlaka tnanpentjilhaka. Relha ntjarralantama Altjirranha wuka Jesuurna angkamanga, alkiranga, “Unta 'lira nuka nama. Yinga ungkwanga kngarra inthorra kangkama.” ");
INSERT INTO are_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesuanha 30 years ingkwia namalanga, era tjontaka relha ntjarranha kaltjinthitjika. Etna ilaka Jesua era kula Joseph-aka 'lira namanga. Joseph era Heli-aka 'lira naka. ");
INSERT INTO are_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli era Matthat-aka 'lira. Matthat era Levi-aka 'lira. Levi era Melki-aka 'lira. Melki era Jannai-aka 'lira. Jannai era Joseph-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph era Mattathias-aka 'lira. Mattathias era Amos-aka 'lira. Amos era Nahum-aka 'lira. Nahum era Esli-aka 'lira. Esli era Naggai-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai era Maath-aka 'lira. Maath era Mattathias-aka 'lira. Mattathias era Semein-aka 'lira. Semein era Josech-aka 'lira. Josech era Joda-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda era Joanan-aka 'lira. Joanan era Rhesa-aka 'lira. Rhesa era Zerubbabel-aka 'lira. Zerubbabel era Shealtiel-aka 'lira. Shealtiel era Neri-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri era Melki-aka 'lira. Melki era Addi-aka 'lira. Addi era Cosam-aka 'lira. Cosam era Elmadam-aka 'lira. Elmadam era Er-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er era Joshua-aka 'lira. Joshua era Eliezer-aka 'lira. Eliezer era Jorim-aka 'lira. Jorim era Matthat-aka 'lira. Matthat era Levi-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi era Simeon-aka 'lira. Simeon era Judah-aka 'lira. Judah era Joseph-aka 'lira. Joseph era Jonam-aka 'lira. Jonam era Eliakim-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim era Melea-aka 'lira. Melea era Menna-aka 'lira. Menna era Mattatha-aka 'lira. Mattatha era Nathan-aka 'lira. Nathan era David-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David era Jesse-aka 'lira. Jesse era Obed-aka 'lira. Obed era Boaz-aka 'lira. Boaz era Salmon-aka 'lira. Salmon era Nahshon-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon era Amminadab-aka 'lira. Amminadab era Ram-aka 'lira. Ram era Hezron-aka 'lira. Hezron era Perez-aka 'lira. Perez era Judah-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah era Jacob-aka 'lira. Jacob era Isaac-aka 'lira. Isaac era Abraham-aka 'lira. Abraham era Terah-aka 'lira. Terah era Nahor-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor era Serug-aka 'lira. Serug era Reu-aka 'lira. Reu era Peleg-aka 'lira. Peleg era Eber-aka 'lira. Eber era Shelah-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah era Cainan-aka 'lira. Cainan era Arphaxad-aka 'lira. Arphaxad era Shem-aka 'lira. Shem era Noah-aka 'lira. Noah era Lamech-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech era Methuselah-aka 'lira. Methuselah era Enoch-aka 'lira. Enoch era Jared-aka 'lira. Jared era Mahalalel-aka 'lira. Mahalalel era Kenan-aka 'lira. ");
INSERT INTO are_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan era Enosh-aka 'lira. Enosh era Seth-aka 'lira. Seth era Adam-aka 'lira. Adam era Altjirraka 'lira. ");
INSERT INTO are_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesuanha Jordan Lhira ekuranga pitjalpukantama. Era Enka Alkngaltarakarta naka. Enka erantama erinha worritjurna rretjingaka. ");
INSERT INTO are_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Errintja erantama erinha arlta 40 arrkarnaka. Arlta 40 nhanha ekurala Jesuala itja marna ilkuka paka. Erantama ngaiyala naka. ");
INSERT INTO are_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Errintja erantama erinha ilaka, “Unta Altjirraka 'Lira namanga warta, unta parta nhanha etnanha turnai marnerritjika.” ");
INSERT INTO are_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesuala pula erinha ilaka, “Altjirraka Angkatja Imankinya arrpunhala ilama, ‘Relha yarna marniperranta etatha nama.’” ");
INSERT INTO are_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kurunga errintjala Jesuanha kartninya inthorra kngaka. Warangala inthorrantama era ekura pmara twetakatweta etnanha imarnaka. ");
INSERT INTO are_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Erantama erinha ilaka, “Atha nganha pmara nhanha ingkarraka nthitjina, unta ekarlta inthorra, netaneta inthorra turta nitjinanga. Arai, nhanha ingkarraka nuka nama. Nukathaka turta nama nhanha relhanha nthitjika, yinga paka antja namanga. ");
INSERT INTO are_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kala nukanta urrkurrkintja nai, kurunga nhanha ingkarraka ungkwangantama nitjina.” ");
INSERT INTO are_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesuala pula erinha ilaka, “Altjirraka Angkatja Imankinya arrpunhala ilama, ‘Unta Ingkarta Altjirra ungkwanganhakanta wara urrkurrkintja nitjika, unta turta ekuranta wara kangkwerritjika.’” ");
INSERT INTO are_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kurunga errintjala Jesuanha Jerusalem-urnantama kngaka, erinha temple kartna inthorraka arrarnaka turta. Errintja erantama ekururna angkaka, “Unta Altjirraka 'Lira namanga warta, iwulhamala tnanpai. ");
INSERT INTO are_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Altjirraka Angkatja Imankinya ilama, ‘Altjirrala angel ekuranha ntjarranha turnitjina nganha ntarntaritjika. ");
INSERT INTO are_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Etnantama nganha iltja etnakanhala errkutjina, unta ntjilpartilalhakitja, ingka ungkwanganha partakarlaka tjalpalhelamala.’” ");
INSERT INTO are_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesuala pula erinha ilaka, “Altjirraka Angkatja Imankinya arrpunhala ilama, ‘Unta itja Ingkarta Altjirra ungkwanganha arrkarnitjika.’” ");
INSERT INTO are_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Errintjala Jesuanha arrkarnamaliperra, era erinha kala impukarrkantama, erinha anma wotha arrkarnitjinala. ");
INSERT INTO are_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesuanha Galilee-urnantama alpuka. Enka Alkngaltara era ekuralela naka, erinha ekarltilaka turta. Yia ekuriperrantama parrpa ntakerraka relha ntjarrurna. ");
INSERT INTO are_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Erantama relha ntjarranha synagogue-ala kaltjinthitjata. Etna turta erinha kngarra tnantjitjata. ");
INSERT INTO are_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kurunga Jesuanha Nazareth-urna alpuka, town nhanga erala mangkakala ekururna. Era kutatha Sabbath arltala synagogue-urna lhitjata. Lakinhanga era Nazareth-ala Sabbath arltala namanga, era kala synagogue-urna lhakantema. Erantama kamerramala read-erritjika itnaka. ");
INSERT INTO are_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Artwa nyintalantama erinha pepa nthaka Altjirraka urrpia Isaiah-aka angkatjakarta. Pepa erinha altjurilamala, era angkatja nhanhaka read-erraka, ");
INSERT INTO are_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ingkartala Enka ekuranha nukurna yairnaka. Era yinganha urraraka Yia Marra erinha relha kornarintja ntjarranha ilitjika. Era yinganha urrpia yairnaka, relha errintjala errkukala ntjarranha ilitjika, ‘Ingkartala kunha rrangkarranha althakalthilitjina.’ Atha relha panga ntjarranha ilitjika, ‘Ingkartala kunha alknga rrakangkarranha wotha marrilitjina.’ Atha relha nakapakarlerrakala ntjarranha ilitjika, ‘Ingkartala kunha rrangkarranha tangkalhelitjina’. ");
INSERT INTO are_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Atha turta relha ingkarrakanha ilitjika, ‘Antala era kala namantama, antala nhanga ekuralala Altjirranha relha ingkarrakaka montjamontja ntelalhitjika nakala.’” ");
INSERT INTO are_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesualantama pepa erinha wotha marntilamala artwa nhanganhantema nthitjalpuka. Kurunga era arrarnalhaka, relha ntjarranha kaltjinthitjika. Relha synagogue-ala namala ntjarralantama erinha intarra araka. ");
INSERT INTO are_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Erantama etnanha ilaka, “Lyarta Altjirraka Angkatja Imankinya nhanha nthurrperrakantama, rrangkarra erinha wumalangantema.” ");
INSERT INTO are_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Relha ingkarraka angkatja ekuranhaka tnolkaka, era angkatja marra inthorra namanga. Etna pula erinha ilpoiwuka turta, lakinha angkamala, “Yai, nhanha pula Joseph-aka worra nhanga.” ");
INSERT INTO are_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesualantama etnanha ilaka, “Rrangkarrataka yinganha lyarta angkatja imankinya nhangalama ilitjina, ‘Artwa ngangkarai, marrilalhai!’ Rrangkarra yinganha ilitjina, ‘Nurna wuka unta Capernaum-ala tjatjikarta ntjarra urrkapukala. Untantama town untala mangkakalala, tjatjikarta ntjarra lakinha ngerrantema urrkapai.’ ");
INSERT INTO are_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Atha rrangkarranha nhanha nthurrpa ilama, pmararinya ntjarrala itja Altjirraka urrpia tnakama, erala pmara etnakanhala mangkakala. ");
INSERT INTO are_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Yinganha wurlathanai! Altjirraka urrpia Elijah-aka antalala, kwatjala itja inthorra nhaka 3 1/2 years. Marnaka paalerrintja kngarrantama naka pmara ntjaparala. Arlta lenhala warlukurta ilkngara ntjarra Israel-ala naka. ");
INSERT INTO are_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Altjirrala pula Elijah-anha warlukurta nyinturnanta tangitjala yairnaka, erala Zarephath-ala namanga, pmara Sidon-ala, itja warlukurta Israel-ala namala ntjarrurna. ");
INSERT INTO are_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Arrpunha nhanha turta etarlarai. Altjirraka urrpia Elisha-aka antalala relha ntjarra inthorra pmara Israel-ala leprosy-akarta naka. Elisha-ala pula Naaman-anhanta, artwa pmara Syria-arinya nhanganhanta marrilaka, itja Israel-arinya leprosy-akarta nyintanha.” ");
INSERT INTO are_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Angkatja nhanha wumala, relha synagogue-ala namala ntjarra Jesuaka yirrknga inthorrerraka. ");
INSERT INTO are_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kamerramala, etna erinha errkumala town-anga kathurna rretjingaka. Nazareth-ataka parta kartninyala italhaka. Etnantama Jesuanha parta irnkurna kngaka, erinha pauwurlenitjinala. ");
INSERT INTO are_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesuanha pula etnakanga mpopala tjananhaka, era etnakanga ntjuma kuta alpuka turta. ");
INSERT INTO are_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesuanha Capernaum-urnantama lhaka. Town nhanhataka pmara Galilee-ala naka. Kurunga Sabbath arltala era etnanha kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Etna angkatja ekuranhaka tnolkaka, era etnanha angkatja ekarltala kaltjinthamanga. ");
INSERT INTO are_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Artwa enka kornakarta Synagogue-ala naka. Era Jesuaka intarra ilkaka, ");
INSERT INTO are_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yai, Jesua Nazareth-arinyai, iwukama unta pitjika? Nurnanha yirralhelitjikama unta pitjika? Yinga ungkwanga kaltja. Unta kunha Altjirraka urrpia Alkngaltara Era.” ");
INSERT INTO are_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesualantama enka korna erinha rralthamala ilaka, “Tjukunyerrai! Artwa ekuranga rratai!” Enka korna erantama artwa erinha relha etnakanga urlarra ilaturlalhamala, rrataka. Era pula artwa erinha itja kornilaka. ");
INSERT INTO are_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nhanha aramala, relha ingkarraka tnolkaka, ilarraka turta, “Angkatja ekuranha kunha ekarlta inthorra. Era enka korna ntjarranha relhanga unpurlenamanga, etna kala rratamanta.” ");
INSERT INTO are_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yia ekuriperrantama pmara ingkarrakurna ntakerranhaka. ");
INSERT INTO are_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Synagogue ekuranga rratamala, Jesuanha Simon-aka ilthurna lhaka. Iltha ekurala Simon-aka mara menta intaka, wumpia inthorra. Etnantama Jesuurna ingkaka, ekurakwia. ");
INSERT INTO are_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Arrkutja ekururna etinyerramala, Jesuala erinha marrilaka. Kamerramalantama, era Jesuaka marna etaka. ");
INSERT INTO are_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Relha ntjarra arrpunha tjina mentakarta naka. Lirnnga kala irrputjikerramalangantama, etna tjina etnakanha Jesuurna kngitjika. Relha nhanha etnataka menta arrpunhakarrpunhakarta naka. Jesuala iltja ekuranha nyintaminyintaka arrarnaka, ingkarrakanha marrilaka turta. ");
INSERT INTO are_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Era enka korna ntjarranha turta relha arrpunha ntjarranga unpuka. Enka korna etna relhanga rratamala, etna ilkaka, “Unta kunha Altjirraka 'Lira nama.” Jesuala pula errintja etnanha parraka, etna kaltja nakalanga warta era Krista era namanga. ");
INSERT INTO are_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kala arlterramalangantama, Jesuanha kathurna lhaka erarrpa nitjika. Relha ntjarrala pula ekura kuta yonthaka. Erinha arltaramala, etna erinha parraka itja lhitjika, etnakalela pula kuterritjika. ");
INSERT INTO are_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesuala pula etnanha ilaka, “Nukathaka nama relha arrpunha ntjarranha turta Yia Marra erinha kaltjinthitjika. Etnanha ilitjika turta Altjirranha kala relha ingkarrakaka ntelalhitjikerramanga, era Ingkarta etnaka namanga. Nhanhakakwia kunha Altjirrala yinganha yairnakala.” ");
INSERT INTO are_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Erantama pmara Judea-ala synagogue ntjarrurna irrpuka, relha ntjarranha Yia Marra erinha kaltjinthaka turta. ");
INSERT INTO are_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jesuanha Gennesaret ntjanganga ankerrala itnamalanga, relha ntjarra ekururna pitjika Altjirraka Angkatja wutjika. Relha etnantama erinha rrothitjikerraka, ekururna etinyametinyerramala. ");
INSERT INTO are_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesualantama boat tharra araka ankerrala intamanga. Artwa irrpannga errkunherrkunha, etnala boat ekuratharrakurtwia namanga, etnataka boat erinhatharra ankerraka impurlalhakala. Etnantama net etnakanha ilkngirlanaka. ");
INSERT INTO are_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesuanhantama boat nyintaka ntjika. Nhanha Simon-aka boat naka. Jesualantama Simon-anha ilaka era boat erinha kwatjurna pauwutjika. Itja ilanga, ankerranga etinya wara pula. Boat ekurala arrarnalhamalantama, Jesuala relha ntjarranha kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Etnanha kaltjinthamaliperra, era Simon-anha ilaka, “Boat ungkwanganhaka ntjimala, kwatja iparturna lhai. Kurunga unta, tjina ungkwanganha ntjarra turta, rrangkarra net kngarritja rrakangkarranha kwatjaka iwai irrpannga errkutjika.” ");
INSERT INTO are_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon-ala Jesuanha ilaka, “Kaltjinthanhinthanhai, nurnataka ingwa ntjapara urrkapukala, irrpannga errkutjika, palkala wara. Unta pula yinganha turnakalanga, atha kala net etnanha wotha kwatjaka iwutjina.” ");
INSERT INTO are_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Etnantama boat-ala kwatja iparturna tjananhamala, net etnanha kwatjaka iwuka. Etnantama irrpannga ntjarra inthorra errkuka, net etna kala ingkwa tjepakalhitjikerraka. ");
INSERT INTO are_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lakinhanga etna tjina etnakanhaka kwerraka, etnala boat arrpunhala namanga, etna pitjitjika, net etnanha tangitjala errkutjika. Pitjimala, etna boat tharranhantema tangitjala lyulpalyulpilaka irrpanngakarta. Kala boat tharrantema ingkwa uralhitjikerrakantama. ");
INSERT INTO are_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nhanha aramala, Simon Peter-anha Jesuanga urlarra mparalela arrarnalhaka. Erantama erinha ilaka, “Ingkartai, nukanga lhai, yinga relha kornarintja namanga warta.” ");
INSERT INTO are_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Peter era, artwa arrpunha ntjarra turta etnala ekuralela namanga, etnataka ingkarraka tnolkaka irrpannga etnala errkukaliperra. ");
INSERT INTO are_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Lakinha Simon-aka tjina urrkapunhapunha tharra arrpunha turta, James John tharra, Zebedee-aka 'lira tharra, eratharra turta tnolkakantema. Jesualantama Simon-anha ilaka, “Unta itja trerritjika. Arai, lyartanga unta urrkaputjina relha ntjarranhatitjantama errkutjika, etnanha nukurna kngitjimala.” ");
INSERT INTO are_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ankerrakerramala, etnantama boat etnakanha ankerrakarlaka tjarrinaka. Etnantama yultha ingkarraka etnakanha impurlalhamala, Jesuanga tnaartangala lhaka. ");
INSERT INTO are_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesuanha town arrpunhurnantama lhaka. Town ekuralala artwa arrpunha leprosy-akarta naka. Artwa era Jesuanha aramalanga, era ekuranga urlarra mparalela arrarnalhaka, ekururna ingkaka turta, “Ingkartai, unta paka antja namanga, unta yinganha irrpalthala marrilamara.” ");
INSERT INTO are_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesuala erinha iltjala anpumala ilaka, “Yinga antjakwia. Atha nganha kala marrilama.” Artwa ekura leprosy kala yirrakanta. ");
INSERT INTO are_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesualantama erinha tjatjatumala ilaka, “Unta itja relha arrpunhanha nhanhiperra ilitjika. Kala priest-akanta ntelai. Unta turta Altjirranha tjauwerrilya nthai, Moses-ala relha ntjarranha turnakala ngerra. Unta lakinhilitjika relha ntjarra kaltja nitjinanga unta kala marrerrakalantama.” ");
INSERT INTO are_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yia pula Jesuiperra kuta ntakerretnanhaka. Worla kngarrantama pitjika erinha wutjika, era turta menta etnakanha marrilitjinanga. ");
INSERT INTO are_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesuanha pula naamerraka, erarrpa nitjika, Altjirrurna ingkitjika turta. ");
INSERT INTO are_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Arlta arrpunhala, Jesuala relha ntjarranha kaltjinthamalanga, artwa Pharisee ntjarrala, artwa Intarrangaltha ntjarrala turta erinha wurlanaka. Artwa Pharisee nhanha ntjarra, artwa Intarrangaltha nhanha ntjarra turtataka pmara Galilee-anga ntjaparanga pitjikala, Judea-anga, Jerusalem-anga turta. Ingkartala kala Jesuanha arrkurlantema ekarltilakala relha mentanha marrilitjika. ");
INSERT INTO are_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Arai, artwa urrputjalantama artwa thaarranha ntjamala kngitjika. Etna antja naka erinha iltha kwanurna kngitjika, erinha Jesuanga urlarra arrarnitjika turta. ");
INSERT INTO are_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Relha worla kngarrala pula tjaiya etnaka parraka. Lakinhanga etna iltha kartninyaka ntjika, roof erinha turta altjurilaka. Etnantama artwa erinha room mpopaka tnanpulhelaka, ntjamala kuta intamala. Artwa thaarra erantama Jesuanga urlarra intaka. ");
INSERT INTO are_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesuala aramalanga etna erinha kngarra tnakamanga, era artwa thaarra erinha ilaka, “Artwai, atha kala korna ungkwanganha iwuka.” ");
INSERT INTO are_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Artwa Intarrangaltha etna, artwa Pharisee etna turta pula lakinhala eterraka, “Ngunhama artwa nhanha? Era Altjirranha arrampowuma. Altjirralanta kunha relhaka korna irrpalthala iwuma.” ");
INSERT INTO are_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesuanha kala kaltja naka etnala eterramalaka. Erantama etnanha pmarraka, “Iwunhangala rrangkarra lakinha eterrama? ");
INSERT INTO are_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yinganha ilai paka, iwunhama rukaralkura nama? Atha paka artwa nhanha erinha ilitjika, ‘Atha korna ungkwanganha iwuka?’ Atha paka erinha ilitjika, ‘Kamerrai, nthulapai turta?’ ");
INSERT INTO are_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Arai, Relhaka 'Lira era nthurrpa relha ingkarrakaka korna irrpalthala iwuma. Atha rrangkarranha nhanha ntelitjina.” Jesualantama artwa thaarra erinha ilaka, “Kamerrai! Ntjama ungkwanganha tjurnamala, kala alpai!” ");
INSERT INTO are_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Etnakanga alkngatharrantama artwa era kala kamerrakanta. Ntjama ekuranha inamala, era kala iltha ekuranhurna alpuka, Altjirranha tnantjamala. ");
INSERT INTO are_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Relha etna pula ingkarraka tnolkaka. Etna Altjirranha tnantjaka. Etna turta tiratira wara ilarraka, “Nurna kunha lyarta tjatjikarta arrpunha inthorra araka.” ");
INSERT INTO are_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nhanhiperra, ilthanga rratamala, Jesuala artwa Levi-anha araka. Levi erataka tax money kotjitjata. Era iltha ekuranhanga kathala narlanaka. Jesualantama erinha ntangkaka, “Nukanga tnaartangala pitjai.” ");
INSERT INTO are_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kamerramala, Levi-ala kala yultha ingkarraka ekuranha impurlalhaka, era Jesuanga tnaartangala lhaka turta. ");
INSERT INTO are_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kurunga Levi-ala tjinkarra kngarra urrkapuka, iltha ekuranhala, Jesuaka kangkintja ntelalhitjika. Erantama artwa tax money kotjinha ntjarra, relha ntjarra arrpunha turta ntangkaka, tjinkarra ilkutjika. ");
INSERT INTO are_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Artwa Pharisee urrputja, artwa Intarrangaltha urrputja turtantama Jesuaka kurtungurla ntjarrurna wannga angkaka, “Iwunhangala rrangkarra tax money kotjinha ntjarralela, kornarintja arrpunha ntjarralela turta tjinkarra ilkuma?” ");
INSERT INTO are_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesuala etnanha ilaka, “Relha ltarrkngalataka itja ngangkaraka yonthama. Relha mentalanta. ");
INSERT INTO are_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Arai, yinga pitjika relha kornarintja ntjarranha ntangkitjika, Altjirrurna toperritjika, itja arratja ntjarranha.” ");
INSERT INTO are_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Relha urrputjala Jesuanha pmarraka. “John-aka kurtungurla ntjarra kutatha ngerra marnakunya nama, Altjirrurna ingkama turta. Artwa Pharisee-aka kurtungurla ntjarrala lakinhilamantema. Kanha kurtungurla ungkwanganha ntjarra itja kutala marnakunya nama. Iwunhangala?” ");
INSERT INTO are_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesuala etnanha ilaka, “Artwala noa inamanga, era tjinkarra urrkapuma. Kurunga era tjina ekuranha ntjarranha ntangkama marna ilkutjika. Tjina etnantama yarna marnanga unpulhama, artwa noa inakala era etnakalela namangantema. ");
INSERT INTO are_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Anma pula, relha arrpunha ntjarrala artwa erinha errkumala kngitjina. Kurunga artwa ekura tjina ntjarra arlta arrpunhala marnakunyantama nitjina.” ");
INSERT INTO are_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesuala etnanha yia nhanha turtantama ilaka. “Arai, relhala itja mantarra lyartinyanga mantarra kurrka kamala nhanha mantarra ingkwiakarlakantama thanthama. Era paka lakinha mpaaramanga era kala mantarra tharranhantema kornilitjina. ");
INSERT INTO are_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Relhala turta itja wine lyartinya yinpa ingkwiaka thalama, wine lyartinyala yinpa ingkwia etnanha talhelakitja. Kurunga wine lyartinya era, yinpa ingkwia etna turta porta kuta ipmintjerrama. ");
INSERT INTO are_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lakinhanga kunha relhala wine lyartinya erinha kala yinpa lyartinyakanta thalama. ");
INSERT INTO are_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Relha erala wine ingkwia ntjukala, era itja wine lyartinyaka antja. Era angkama, ‘Wine ingkwia era kunha marralkura.’” ");
INSERT INTO are_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabbath arlta arrpunhala, Jesuanha, kurtungurla ekuranha ntjarra turta, tnukulpanga tjananhaka. Tnukulpa ekurala marna wheat urnma itnaka. Jesuaka kurtungurla ntjarralantama marna mpakaka, iltjala thurrumala ilkuka turta. ");
INSERT INTO are_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Artwa Pharisee urrputjalantama etnanha pmarraka, “Iwunhangala rrangkarra Sabbath arltala marna wheat mpakama, iltjala thurruma turta? Nhanha kunha itja arratja nama.” ");
INSERT INTO are_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesuala etnanha pmarraka, “Rrangkarra itjala David-iperra kaltja? Era ngaiyala naka, artwa ekuralela namala ntjarra turta. ");
INSERT INTO are_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David-anhantama Altjirraka ilthurna irrpunhaka. Iltha ekurala marna intaka, Altjirranha tjauwerrilya nthakala. Nhanha priest-akanta naka ilkutjika. David-ala pula marna nhanha ilkukala, ngaiyalala warta. Era turta marna nhanha artwa ekuralela namala ntjarranha nthaka, ilkutjika. Lakinha David-anha Altjirraka mpaarangarangaka itja kangkwerraka.” ");
INSERT INTO are_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kurunga Jesuala etnanha nhanha ilaka, “Arai, Relhaka 'Lira era Sabbath arlta ekura turta Ingkarta nama.” ");
INSERT INTO are_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabbath arlta arrpunhalantama, Jesuanha synagogue-urna irrpuka, relha ntjarranha kaltjinthitjika. Artwa arrpunha synagogue ekurala naka, iltja akwa ntjirrkakarta. ");
INSERT INTO are_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Artwa Intarrangaltha ntjarrala, artwa Pharisee ntjarrala turtantama Jesuanha montjala ararlanaka. Etna eterraka, “Era paka artwa nhanhaka iltja marrilamanga, nurna erinha ilparnitjina.” ");
INSERT INTO are_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesuanha pula eterrintja etnakanhaka kaltjala naka. Erantama artwa iltja ntjirrkakarta erinha ilaka, “Pitjai, nukanga kuta itnatjika.” Artwa era kamerramala Jesuanga kuta itnaka. ");
INSERT INTO are_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesualantama relha etnanha pmarraka, “Nhanha arratjama nama Sabbath arltala relhaka tangitjala nitjika, relhanha marrilitjika turta? Nhanha arratjama nama relhanha Sabbath arltala nakapakarlilitjika, kornilitjika turta?” ");
INSERT INTO are_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Erantama etnanha ingkarraka tjoraraka. Kurunga era artwa erinha ilaka, “Iltja ungkwanganha imarnai!” Erantama iltja ekuranha imarnaka. Iltja ekura kala marrerrakantama. ");
INSERT INTO are_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Artwa Intarrangaltha ntjarra, artwa Pharisee ntjarra turtantama Jesuaka antjakunya inthorrerraka. Etna lakinha pmarrarraka, “Artwa nhanha erinha nurna nthakinhilamarama?” ");
INSERT INTO are_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kala arlta arrpunhalantama Jesuanha partaka ntjika Altjirrurna ingkitjika. Erantama ingwa ntjapara Altjirrurna ingkaka. ");
INSERT INTO are_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kala arlterrakalangantama, era kurtungurla ekuranha ntjarraka ntangkalhaka, etnakanga artwa 12 turta urraraka Apostle ekuranha nitjika. ");
INSERT INTO are_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Artwa nhanha etna naka Simon, erinhala Jesuala rretnya Peter turta alpmelakala. Tjia ekuranha Andrew-anha turta. James-anha John-anha turta. Philip-anha Bartholomew-anha turta. ");
INSERT INTO are_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew-anha Thomas-anha turta. James arrpunha nhanga, Alphaeus-aka worra. Simon-anha, artwa nhanga erala Roman Government-aka irrpaltherritjata. ");
INSERT INTO are_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas-anha, James-aka worra. Judas Iscariot-anha turta, erala Jesuanha anma leltjaka lanthakala. ");
INSERT INTO are_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kurunga Jesuanha apostle ekuranha ntjarrakarta partanga tnanpuka, arna karrurna. Kurtungurla ekuranha ntjarra arrpunha, relha ntjarra arrpunha turta ekura kala kaaralhaka, katha lenha ekurala. Relha nhanha etnataka Judea ntjaparanga pitjikala, Jerusalem-anga, Tyre-anga, Sidon-anga turta. Pmara Tyre Sidon tharrataka kwatja laiyanga kutala naka. ");
INSERT INTO are_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Relha nhanha etnataka pitjika Jesuanha wutjika, Jesuala turta tjina menta etnakanha marrilitjika. Jesualantama relha menta etnanha marrilaka, relha enka kornakarta ntjarranha turta. ");
INSERT INTO are_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Relha ingkarraka inthorrala Jesuanha anputjika antja naka. Etna kaltja naka era ekarlta inthorra namanga, relha menta arrpunha ntjarra marrerrakalanga warta, erinha anpumala. ");
INSERT INTO are_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kurtungurla ekuranha ntjarranha tjoraramalantama, Jesuala etnanha ilaka, “Rrangkarra arrkana nama, rrangkarra ilkngara namanga, Altjirranha kala Ingkarta rrakangkarra namanga warta. ");
INSERT INTO are_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Rrangkarra arrkana nama, rrangkarra lyarta ngaiyala namanga, Altjirrala rrangkarranha ntuthilitjinanga warta. “Rrangkarra arrkana nama, rrangkarra lyarta nthorrkngerramanga, Altjirrala rrangkarranha alkngolkngilitjinanga warta. ");
INSERT INTO are_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Thunga relha arrpunha ntjarra rrakangkarra yirrkngerritjina. Thunga etna rrangkarranha synagogue etnakanhanga unputjina, arrampowutjina turta. Thunga etna rrangkarranha lolowutjina, iltha etnakanhanga turta unputjina. Etna paka rrakangkarra lakinha ntelalhamanga Relhaka 'Lirakakwia, rrangkarra arrkana nitjika. ");
INSERT INTO are_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Awa, rrangkarra kala arrkana kngarranta nitjika, Altjirrala rrangkarranha anma alkirala kngarra kwartiwutjinanga warta. Arai, relha etnala rrangkarranha kornilitjina, kaarta etnakanhala kunha Altjirraka urrpia imankinya ntjarranha lakinhantema kornilakala. ");
INSERT INTO are_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Relha netaneta rrangkarra kala ltarrperritjikantala. Altjirrala kunha rrangkarranha itja wotha kwartiwutjina. ");
INSERT INTO are_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Relha rrangkarrala lyarta marna kngarra ilkurlanama, rrangkarra turta kala ltarrperritjikanta. Rrangkarra kunha anma ngaiyala nitjina. “Relha rrangkarrala lyarta arrkana kngarra nama, rrangkarra turta kala ltarrperritjikanta. Rrangkarra kunha anma itnitjina, nthorrkngerritjina turta. ");
INSERT INTO are_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Relha ingkarrakala paka rrangkarranha tnantjamanga, rrangkarra kala ltarrperritjikanta. Lakinha kunha kaarta rrakangkarranhala urrpia orrtjaltha ntjarranha tnantjakantema.” ");
INSERT INTO are_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Rrangkarranha pula, rrangkarrala nuka kangkwerrama, atha lakinhala ilama. Rrangkarra leltja rrakangkarranhaka kangkintja ntelalhitjika. Relha rrakangkarra antjakunya namala ntjarraka, rrangkarra tangitjala nitjika. ");
INSERT INTO are_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Relha etnala rrangkarranha kornilamanga, rrangkarra etnaka kangkintja ntelalhitjika. Relha etnala rrangkarranha iltamanga, etnakakwia rrangkarra Altjirrurna ingkitjika. ");
INSERT INTO are_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Thunga arrpunhala ilkaiya ungkwanganha tuma. Ilkaiya arrpunha ungkwanganha turta ekura imarnai, era tutjika. Thunga arrpunhala coat ungkwanganha inama. Erinha impurlarrarnai shirt ungkwanganha turta initjika. ");
INSERT INTO are_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Thunga arrpunha ungkwanga yulthaka enkama. Erinha kala nthai. Thunga nyintala yultha ungkwanganha nyilkngala kngaka. Unta erinha itja pmarritjika yultha etnanha wotha nthitjalputjika. ");
INSERT INTO are_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Rrangkarrala antja namanga ngerra relha arrpunha ntjarra rrakangkarra ntelalhitjika, lakinha ngerra rrangkarrakimparra etnaka ntelalhai. ");
INSERT INTO are_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Iwunhangama Altjirrala rrangkarranha kwartiwutjika, rrangkarra paka tjina rrakangkarranhakanta kangkamanga? Relha kornarintja ntjarra pula tjina etnakanhaka kangkamantemala. ");
INSERT INTO are_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Iwunhangama Altjirrala rrangkarranha kwartiwutjika, rrangkarra paka relha etnakanta tangitjala namanga, etnala rrakangkarra turta tangitjala namanga? Relha kornarintja ntjarra pula tjina etnakanhaka tangitjalantema namala. ");
INSERT INTO are_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Iwunhangama Altjirrala rrangkarranha kwartiwutjika, rrangkarra paka etnanhanta yultha lyartaka wara nthamanga, etnala rrangkarranha yultha nthitjalputjinala? Relha kornarintja ntjarrala pula tjina etnakanha yultha lyartaka wara nthamantema, etnakanga yultha wotha initjinala warta. ");
INSERT INTO are_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Rrangkarra pula leltja rrakangkarranhaka kangkitjika, etnaka tangitjala nitjika, etnanha yultha lyartaka wara turta kapanhanta nthitjika. Altjirralantama rrangkarranha kngarra kwartiwutjina. Rrangkarra turtantama Altjirra Kngarra ekura 'lira nitjina. Era kunha relha korna ntjarraka kangkintja ntelalhama. Era turta relha etnaka kangkintja ntelalhama, etnala erinha itja dangkilama. ");
INSERT INTO are_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Rrangkarrataka relha arrpunhaka montjamontja ntelalhitjika, Kaarta rrakangkarrala montjamontja ntelalhamanga ngerra.” ");
INSERT INTO are_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Rrangkarra itja relha arrpunhanha ilitjika, ‘Unta relha korna nama.’ Unta erinha lakinha ilamanga, Altjirrala ilitjina unta relha kornantema namanga. Rrangkarra itja relha arrpunhanha imilitjika, kurunga Altjirrala rrangkarranha itjantema imilitjina. Rrangkarra relha arrpunhaka korna iwutjika, kurunga Altjirrala korna rrakangkarranha iwutjinantema. ");
INSERT INTO are_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Rrangkarra relha ilkngara ntjarranha ntuthilitjika. Kurunga Altjirrala rrangkarranha ntuthilitjina. Rrangkarra paka etnanha marnalka kngarra kuta nthamanga, Altjirrala rrangkarranha kngarra kutantema nthitjina. Rrangkarra paka etnanha yulthalka nthamanga, Altjirrala rrangkarranha yulthalka nthitjinantema. Rrangkarra paka relha arrpunhaka montjamontja ntelalhamanga, Altjirranha rrakangkarra montjamontja ntelalhitjinantema.” ");
INSERT INTO are_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesuala etnanha yia nhanha turta ilaka, “Relha pangala kunha relha panga arrpunhanha yarna arratja rretjingama. Eratharra kala tharrantema ipartaka tnyitjina. ");
INSERT INTO are_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Relha erala kaltjerrama, era itja kaltjinthanhinthanha ekuranhanga kaltjalkura nama. Anma turta, era kala ekuranga ingkarraka kaltjerrakalanga, era kala kaltjinthanhinthanha ekuranha ngerranta wara nitjina. ");
INSERT INTO are_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nthakinhala unta lyaka kurrka erinhanta katha arama, erala tjina tnakanhakanha ungkwanganhaka alkngala intamanga? Kanha irna thaaka erala alknga ungkwanganhala intamanga, unta itjala arama? ");
INSERT INTO are_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nthakinha turtama unta tjina ungkwanganhurna angkama, ‘Tjinai, yinganha impurlarrarnai lyaka kurrka erinha alknga ungkwanganhanga urlpuntjitjika?’ Arai, unta irna thaaka erinha alknga ungkwanganhala itja arama. Nthakinhantama unta lyaka kurrka erinha tjina ungkwanganhaka alkngala arama? Relha pmathai, unta irna thaaka erinha alknga ungkwanganhangarrka urlpuntjai. Kurunga unta lyaka kurrka erinha, erala tjina ungkwanganhaka alkngala intamanga, katha aritjina, erinha irrpalthala urlpuntjitjina turta.” ");
INSERT INTO are_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Irna marrala yarna annga korna lhalhelama. Irna kornala turta yarna annga marra lhalhelama. ");
INSERT INTO are_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Relhala irna marra lhangkarama, era annga marrakarta namanga. Relhala turta irna korna lhangkarama, era annga kornakarta namanga. Arai, relhala itja tjurrka lyakanga kotjima, marna lalitja paka irna ilakwanga. ");
INSERT INTO are_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Relha marra era kunha marra ntelalhama, eterrintja ekuranha marra namanga warta. Kanha relha korna, era kornala ntelalhama, eterrintja ekuranha korna namanga warta. Arai, relha erala eterramanga ngerra, lakinha era kala angkama.” ");
INSERT INTO are_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Iwunhangala rrangkarra yinganha ‘Ingkartai, Ingkartai’ anparnama? Rrangkarra itjama nuka kangkwerrama. ");
INSERT INTO are_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Arai, thunga relha nukurna pitjima, angkatja nukanha wuma, angkatja nukanhaka kangkwerrama turta. Relha ngunha ngerrama era nama? Era relha nhanha ngerra nama. ");
INSERT INTO are_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iltha ekuranha ititjinala, era arrkurla arna erinha tnyamala foundation arrarnama, parta theintakarlaka. Kurunga roa kngarra pitjimalanga, kwatjala turta iltha erinha twentjimanga, iltha era itja ngalhama paka, erinha parta theintakarlaka itakalanga warta. ");
INSERT INTO are_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Relha era pula, erala angkatja nukanha wuma, itja pula angkatja ekura kangkwerrama, era kala artwa arrpunha nhanha ngerrala nama. Era kala iltha ekuranha arna urlpaiyakarlakala itama, foundation-akunya. Kwatjalantama iltha erinha twentjimalanga, iltha era kala taakalhama, ungkwaltja turta intama, ipmintjerrakala.” ");
INSERT INTO are_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Lakinha Jesuala relha ntjarranha kaltjinthaka, etna turta erinha wurlanaka. Ekuriperra era Capernaum-urna lhaka, town ekururna irrpunhaka turta. ");
INSERT INTO are_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Town nhanha ekurala Rome-arinya itornkaka urrkapunhapunha arrpunha menta intaka. Urrkapunhapunha era turta kala ilutjikerraka. Itornka erataka artwa urrkapunhapunha nhanha ekura kngarra kangkaka. ");
INSERT INTO are_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Erantama wumalanga Jesuanha pitjikala, era Jew ntjarraka kngarripata itornka urrputja Jesuurna urrpia yairnaka, Jesuanha ntangkitjika urrkapunhapunha ekuranha marrilitjika. ");
INSERT INTO are_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kngarripata itornka etna Jesuurna pitjimala, etna ekururna ekarlta inthorra ingkaka era Rome-arinya itornka ekura konyerritjika. Etna Jesuanha ilaka, “Erataka artwa ilporatha nama. ");
INSERT INTO are_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Era relha Jew nurnaka kangkama. Era turta synagogue nurnakanha, nurnaka itaka.” ");
INSERT INTO are_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesuanhantama etnakalela lhaka. Etna kala Rome-arinya itornka ekuranhaka ilthaka etinyerrakantama. Kurunga itornka era tjina urrputja ekuranha Jesuurna yairnaka. Era etnanha turnaka Jesuanha lakinha ilitjika, “Ingkartai, kuta pitjitjala. Iwunhangama unta iltha kornakorna nukanhurna irrputjika eterrama? ");
INSERT INTO are_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yinga turta artwa kornakorna namantema. Lakinhanga yingarrpa itja ungkwangurna lhaka. Unta pula kala angkai, kurunga urrkapunhapunha nukanha marrerritjina. ");
INSERT INTO are_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Arai, yinga kunha itornkakartantema nama. Nukathaka turta nama tjapartia nukanha ntjarranha turnitjika. Atha paka nyintanha ilamanga, ‘Lhai!’ era kala lhama. Atha paka arrpunhanha ntangkamanga, ‘Pitjai!’ era kala pitjima. Atha paka urrkapunhapunha nukanha turnamanga, ‘Lakinhilai!’ era kala lakinhilama.” ");
INSERT INTO are_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nhanha wumala Jesuanha tnolkaka. Ilkngaralhamalantama, era worla ekuranga tnaartangala pitjimala ntjarranha ilaka, “Atha rrangkarranha ilama. Pmara Israel ntjaparala atha itja relha nyintanha paka araka, erala artwa nhanhala ngerra yinganha tnakamanga.” ");
INSERT INTO are_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Urrpia etna wotha ilthakerritjalpuka. Etna urrkapunhapunha erinha araka marrerrakala. ");
INSERT INTO are_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ekuriperra, arlta arrpunhalantama Jesuanha Nain-urna lhaka. Kurtungurla ekuranha ntjarra ekuralela lhakantema, relha worla kngarra turta. ");
INSERT INTO are_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Etnantama town ekura reoaka etinyerramalanga, etna pmararinya ntjarranha araka town-anga rratamanga. Pmararinya nhanha etna artwa errilknga nyintanha wolkngurna kngaka, erinha tintjiwutjika. Errilknga ekura mia, era arrkutja warlukurta naka. Ekura turta worra arrpunha itja naka paka. Relha ntjarra inthorra turta arrkutja warlukurta ekuralela wolkngurna lhaka. ");
INSERT INTO are_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ingkartala arrkutja erinha aramalanga, era ekura konyerraka. Erantama erinha ilaka, “Itja itnitjika.” ");
INSERT INTO are_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kurunga era irna erinha iltjala anpuka, irna erinha purrama ekuralala artwa errilknga era intamanga. Artwa etnala ilukala erinha kngamanga, etna itnakantama. Jesualantama artwa ilukala erinha ilaka, “Artwai, atha nganha ilama, kamerrai!” ");
INSERT INTO are_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Artwa era etatherramala kala kamerraka, angkaka turta. Jesualantama artwa erinha mia ekuranhurna rretjingaka. ");
INSERT INTO are_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nhanha aramala, relha etna kngarra trerraka. Etna Altjirranha tnantjaka turta, lakinha angkamala, “Altjirrala urrpia tjiparra inthorra nurnakurna yairnaka.” Etna lakinha turta angkaka, “Altjirranha kunha nurnakurna, relha ekuranha ntjarrurna yatjarra pitjika, nurnanha tangkalhelitjika.” ");
INSERT INTO are_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Relha ntjarralantama yia nhanha pmara Judea ntjaparala ilarlapuka, pmara arrpunha ntjarrala turta, etnala Judea-anga etinya namanga. ");
INSERT INTO are_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John-aka kurtungurla ntjarralantama John-anha yia ingkarraka alpmelaka, Jesuiperra. John-anhantama kurtungurla tharra ekuranhaka ntangkalhaka. ");
INSERT INTO are_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Era erinhatharra Jesuurna yairnaka turta, Jesuanha pmarritjika, “Unta paka nthurrpa Tangkalhelanha era nama Altjirralala imanka yairnitjika lhelakala? Thunga nurna arrpunhaka kaaralhitjika.” ");
INSERT INTO are_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kurtungurla eratharra Jesuurna pitjimala, eratharra erinha ilaka, “John Kaltjirrpulhelanhelanhala kunha ilirnanha ungkwangurna yairnaka, nganha lakinha pmarritjika, ‘Unta paka nthurrpa Tangkalhelanha era nama Altjirralala imanka yairnitjika lhelakala? Thunga nurna arrpunhaka kaaralhitjika.’” ");
INSERT INTO are_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","John-aka kurtungurla tharrataka pitjalhaka Jesuala relha menta arrpunhakarrpunhakarta ntjarranha marrilamanga. Nhanga relha enka kornakarta ntjarranha turta. Relha panga ntjarranhalka. ");
INSERT INTO are_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesualantama urrpia erinhatharra ilaka, “John-urna alpumala erinha ilai nhanga mpalala arakala, wukala turta. Relha panga ntjarrala wotha arama. Relha inurra ntjarra wotha ingka lhama. Relha leprosy-akarta ntjarra wotha marrerrakala nama. Relha ilpa rirta ntjarrala wotha wuma. Relha errilknga ntjarra wotha etatherrakala nama. Atha, kurtungurla nukanha ntjarrala turta Yia Marra erinha relha kornarintja ntjarranha ilama. ");
INSERT INTO are_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Arai, relha lenha era arrkana nitjina, erala yinganha kuta tnakamanga, itja ilpoiwumanga turta.” ");
INSERT INTO are_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","John-aka kurtungurla tharra kala alpurrakalangantama, Jesuanha relha ntjarrurnantama angkaka, John-iperra. Era etnanha pmarraka, “Artwa ngunha ngerranhama rrangkarra nhanga worritjurna lhaka, aritjika? Artwa tjakatjaka, pmoltatja ngerra ngalhamanga wurinyala warnamanga? Itja kunha. ");
INSERT INTO are_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Artwa ngunha ngerranhantama rrangkarra lhaka, aritjika? Artwa mantarra marra inthorraka ekarralhakalaka? Itja kunha. Relha etnala mantarra marra inthorraka ekarralhakala, etna kunha king-akanha pmarala nama, arltamarlta tulhama turta. ");
INSERT INTO are_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Artwa ngunha ngerra inthorranhantama rrangkarra lhaka, aritjika? Altjirraka urrpia? Era nthurrpa Altjirraka urrpia naka. Era pula Altjirraka urrpia ingkarrakanga kngarralkura naka. ");
INSERT INTO are_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ekuriperra kunha Altjirraka Angkatja Imankinyala ilaka, ‘Atha urrpia nukanha ungkwanganga arrkurla yairnama. Era kala ungkwanga tjaiya mpaaritjina.” ");
INSERT INTO are_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Atha rrangkarranha ilama. John Kaltjirrpulhelanhelanha era kunha Altjirraka urrpia tjiparralkura era naka. Nhanha turta pula nthurrpantema nama. Relha tnakanhakanha kornakornalka pula Altjirranga urlarra tjiparralkura nama John ekurangatjina.” ");
INSERT INTO are_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jesuanha wumala, relha ntjarra, tax money kotjinha ntjarra turta angkaka, “Altjirranha arratja kuta ntelalhaka.” Lakinhanga etna arrkurla nhangantema John-urna lhakala, era etnanha kaltjirrpulhelitjika. ");
INSERT INTO are_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Artwa Pharisee ntjarra pula, artwa Intarrangaltha ntjarra turta pula, Altjirraka itjala kangkwerraka. Etna itja John-urna lhaka, era etnanha kaltjirrpulhelitjika. ");
INSERT INTO are_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesualantama etnanha pmarraka, “Relha ngunha ngerrama rrangkarra? ");
INSERT INTO are_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Rrangkarra kunha katjia ntjarra ngerra nama, etnala kathala arrkanerrama. Katjia arrpunha ntjarrala ntangkama, ‘Nurna arrkanerriai, nthaperramala.’ Kanha katjia arrpunha ntjarra antjakunyala. Kurunga etna wotha ntangkama, ‘Nurna arrkanerriai, relha ilukalaka ngerra nthorrkngerramala.’ Kanha katjia arrpunha etna itja kutala arrkanerritjika antja. ");
INSERT INTO are_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Arai, John Kaltjirrpulhelanhelanhala itja marna marra ilkutjata, wine paka ntjutjata. Rrangkarrantama ilaka era kula rirta namanga, errintjakarta. ");
INSERT INTO are_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kurunga Relhaka 'Lirantama pitjika. Era marna marralka ilkuma, wine turta ntjuma. Rrangkarrantama angkama era kula artwa kwapakwapa ilkunha, drunk-erranha turta kula namanga. Rrangkarra turta erinha arrampowumala ilama era tax money kotjinha ntjarraka, kornarintja arrpunha ntjarraka turta tjina namanga. ");
INSERT INTO are_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Altjirranha pula inangkarla kuta urrkapuma. Nhanha kala ingkarna katherritjina, relhala Altjirraka katjia ntjarranha aramalanga.” ");
INSERT INTO are_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Artwa Pharisee nyintalantama Jesuanha ntangkaka ekuralela marna ilkutjika. Jesuanhantama iltha ekuranhurna irrpunhaka, era turta table marnakartanga kutaka iwulhaka. ");
INSERT INTO are_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Town lenha ekurala, arrkutja kornarintja nyinta naka. Era wuka Jesuala marna ilkumanga artwa Pharisee nhangaka ilthala. Erantama bottle kurrka ntira unpa marrakarta inarlalhaka. ");
INSERT INTO are_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Artwa Pharisee ekura ilthaka irrpunhamalantama, era Jesuaka ingkampinyala itnarlanaka, itnimala. Alkngoltja ekuranha Jesuaka ingkakarlaka tnyika turta. Erantama ingka ekuranha wotha rirrtjilaka kapurta korla ekuranhala. Kurunga era Jesuaka ingka rrontjaka, ntira unpa marrala turta parnaka. ");
INSERT INTO are_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Artwa Pharisee era nhanha aramalanga, era eterraka, “Artwa nhanha itjama Altjirraka urrpia nama. Era paka Altjirraka urrpia nakalanga, era kala kaltja namara nhanha arrkutja kornarintja namanga, era turtantama erinha unpurlenamara.” ");
INSERT INTO are_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesuanhantama artwa Pharisee ekururna angkaka, “Simon, atha nganha kurrka ilitjika antja.” Simon-anha angkaka, “Kaltjinthanhinthanhai, kala ilakwia.” ");
INSERT INTO are_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesuanha angkaka, “Artwa tharra naka, eratharrala artwa arrpunhanga yultha book-emilakala. Nyintala $5000 book-emilakala, arrpunhala $500. ");
INSERT INTO are_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Eratharra, tharralantema erinha yarna money nthitjalpumanga, era kala artwa ekuratharraka lhelintja urrparakanta. Simon untantama yinganha ilai, ekuratharranga ngunha paka ekura kngarralkura kangkitjina?” ");
INSERT INTO are_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon-ala erinha ilaka, “Era kunha, ekurala era booking kngarralkura urrparakala.” Jesuanha angkaka, “Unta kala arratja ilaka.” ");
INSERT INTO are_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Arrkutja erinhantama tjoraramala, Jesuala Simon-anha ilaka, “Unta arrkutja nhanha arama? Yinga iltha ungkwanganhurna irrpentjimalanga, unta yinganha itja kwatja nthaka ingka ilkngilhitjika. Era pula ingka nukanha alkngoltja ekuranhala ilkngika, kapurta korla ekuranhala turta rirrtjilaka. ");
INSERT INTO are_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Unta yinganha itja rrontjaka, yinganha anparnamala. Era pula ingka nukanhala kuta rrontjalanaka. ");
INSERT INTO are_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Unta itja kapurta nukanha ntirala parnaka, era pula ingka nukanhala ntira unpa marrala parnaka. ");
INSERT INTO are_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Atha nganha arratja ilama. Arrkutja nhanha korna kngarra naka. Athantama korna ingkarraka ekuranha iwukalanga, era nuka kngarra kangkaka. Kanha relha ekurala atha korna kurrka iwukala, era kala kurrka warantema nuka kangkitjina.” ");
INSERT INTO are_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesualantama arrkutja erinha ilaka, “Atha korna ingkarraka ungkwanganha iwukala.” ");
INSERT INTO are_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Relha arrpunha ntjarra pula, etnala marnaka pitjikalantema, etna lakinhala pmarrarraka, “Ngunhama artwa nhanha, erala relhaka korna kala iwumanta?” ");
INSERT INTO are_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesuala pula arrkutja erinha ilaka, “Unta yinganha tnakakalanga, Altjirrala nganha tangkalhelaka. Kala Altjirralela rilhererrakalantama alpai!” ");
INSERT INTO are_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nhanha ekuriperra, Jesuanha panpalantama nthulapuka, town kurrkurna, town kngarritjurna turta lhamala. Era relha ntjarranha kaltjinthaka. Era etnanha Yia Marra erinha turta ilaka, yia nhanga Altjirranha kala relha ingkarrakaka Ingkartanamanga. Kurtungurla 12 etna ekuralela nthulapukantema, ");
INSERT INTO are_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","arrkutja urrputja turta. Arrkutja nhanha etnakanga, era urrputja arrpunha mentanga marrilakala. Urrputja arrpunhanga era enka kornala unpurlenakala. Arrkutja nhanha etnakanga nyinta naka Mary Magdalene, ekurangala era enka korna 7 unpurlenakala. ");
INSERT INTO are_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Arrpunha naka Joanna, Cuza-aka noa. Cuza erataka Herod-aka urrkapunhapunha ntjarraka itornka naka. Arrpunha naka Susanna. Arrkutja nhanha etna, ntjarra arrpunhala turta money etnakanhala marnalka buy-emilitjata, Jesuanha, kurtungurla ekuranha ntjarranha turta ntarntaritjika. ");
INSERT INTO are_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Relha ntjarrantama ekururna worlerrentjalpuka, town-arrpaninhanga pitjimala. Erantama etnanha yia nhanha alpmelaka. ");
INSERT INTO are_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Artwa nyinta tnukulpa ekuranhurna lhaka annga ingkairnitjika. Erantama annga etnanha alpantiwumalanga, annga arrpunha ntjarra tjaiyakarlaka tnyika. Relhalantama etnanha ingkala rrothaka. Thepa ntjarrantama pitjika, annga etnanha ilkuka turta. ");
INSERT INTO are_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Annga arrpunha ntjarra partakarlaka tnyika. Annga nhanha etna mangkaka, etna pula parrpa wara ntjirrkerraka, arna pulya itjanga. ");
INSERT INTO are_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Annga arrpunha ntjarra lyakanga mpopakarlaka tnyika. Lyakalela porta mangkamala, lyakala etnanha ulpulatuka. ");
INSERT INTO are_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Annga arrpunha ntjarra arna marrakarlakala tnyika. Etna mangkaka, annga 100 turta lhalhelaka.” Lakinha angkamaliperra, Jesuala etnanha angkatja intarrala ilaka, “Ungkwanga paka ilpa intamanga, kala wurlathanai.” ");
INSERT INTO are_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesuaka kurtungurla ntjarralantama Jesuanha pmarraka, “Iwunhama yia nhanha annga alpantiwunhiperra?” ");
INSERT INTO are_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesuala etnanha ilaka, “Yinga antja nama rrangkarra lhangkaritjika Altjirranha kala pitjikala relha ingkarrakaka ntelalhitjika era Ingkartanamanga. Arrpunha ntjarranha pula atha yiala alpmelama, ‘etna aritjinanga, etna pula itja lhangkaritjinanga, etna turta wutjinanga, etna pula itja lhangkaritjinanga.’ ");
INSERT INTO are_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Atha yia erinha rrakangkarra nentilitjinantama. Annga etna Altjirraka Angkatja nama. ");
INSERT INTO are_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Annga arrpunha ntjarra tjaiyakarlaka tnyika. Nhanha relha etna nama, etnala Altjirraka Angkatja wuma. Errintja era pula pitjimala angkatja erinha rakamala, etna Altjirranha tnakakitja, Altjirrala etnanha tangkalhelakitja turta. ");
INSERT INTO are_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Annga arrpunha ntjarra partakarlakala tnyika. Nhanha relha etna nama, etnala Altjirraka Angkatja arrkanala wuma, angkatja ekura pula parrpa kngwerrama. Lakinhanga etna Altjirranha itja ekarlta tnakama. Arrpunhala etnanha arrampowumangalka, etna Altjirranha kala impumanta. ");
INSERT INTO are_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Annga arrpunha lyakanga mpopakarlakala tnyika. Nhanha relha etna nama, etnala Altjirraka Angkatja wuma, etna pula yulthiperralka, money-iperralka, arrkaniperralka kngarra eterramala Altjirraka Angkatja parrpartilama. Altjirraka Angkatjantama itja kuta anngakarterrama. ");
INSERT INTO are_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Annga arrpunha ntjarra arna marrakarlakala tnyika. Nhanha relha etna nama, etnala Altjirraka Angkatja wuma, ekura kuta antja nama, ekura kangkwerrama turta. Etna kala annga 100 lhalhelama.” ");
INSERT INTO are_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesuala etnanha ilaka, “Relhala alkngantha etamala, era itja alkngantha erinha taarnalantama korltama, bed-anga kwaninyala paka lauwuma. Relhala pula alkngantha erinha table-akatitja arrarnama, relha nhanga ilthurna irrpentjimalanga, etna parrtja erinha aritjinanga. ");
INSERT INTO are_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Arai, lyarta relha ntjarrala Altjirraka Angkatja itja lhangkaritjina, angkatja nhanga athala rrangkarranha ilamanga. Anma Altjirrala angkatja nhanha etnaka nentilitjina. ");
INSERT INTO are_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Rrangkarra itja Altjirraka Angkatja wara wurlanitjika. Relha erala Altjirraka Angkatjaka kangkama, kngarra wotha turta kaltjerritjika antja nama, erinha Altjirrala kngarralkura kaltjinthitjina. Kanha relha erala Altjirraka Angkatjaka antjakunya, erinha Altjirrala itja kutala kaltjinthitjina.” ");
INSERT INTO are_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesuaka mia, tjia ekuranha ntjarra turtantama pitjika erinha aritjika. Etna pula erinha yarna araka, relha worla kngarra inthorranga. ");
INSERT INTO are_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Arrpunhalantama Jesuanha ilaka, “Arai, mia ungkwanga, tjia ungkwanganha ntjarra turtataka ungkwanga kathala kaaralhama, nganha aritjika.” ");
INSERT INTO are_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesuala pula relha worla etnanha ilaka, “Relha lenha ntjarra, etnala Altjirraka Angkatja wuma, angkatja ekura kangkwerrama turta, etna kunha mia nuka pa tjia nuka ntjarra nama.” ");
INSERT INTO are_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Arlta arrpunhala Jesuanha, kurtungurla ekuranha ntjarra turta boat-aka ntjika. Jesualantama etnanha ilaka, “Mpa nurna tjananhiai, urntwarrampinyurna.” Etnantama latha lhaka. ");
INSERT INTO are_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Etna lhapalhamalanga, Jesuanha ankwerraka, porrka warta. Wurinya ekarltalantama etnanha twentjalhaka, kwatja kngarra turtantama boat ekura thalalhaka. Etnantama kala ilutjikerraka. ");
INSERT INTO are_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kurtungurla ntjarralantama Jesuanha kamalhelaka. Etna erinha ilaka, “Ingkartai, Ingkartai, nurnataka ilutjikerrama.” Kaarrerramala, Jesuala wurinya erinha, inmarra etnanha turta parraka. Wurinya era, inmarra etna turtantama kala yirrakanta. ");
INSERT INTO are_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesualantama kurtungurla etnanha pmarraka, “Iwunhangala rrangkarra yinganha itja tnakama?” Etna pula trerraka, tnolkaka turta. Etnantama pmarrarraka, “Ngunhama artwa nhanha? Wurinya, inmarra turta ekura kangkwerrama.” ");
INSERT INTO are_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesuanha, kurtungurla ekuranha ntjarra turtantama pmara Gerasa-akerritjalhaka, nhanga Galilee-angatjina tjananhamala. ");
INSERT INTO are_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ankerraka tnanpumala, artwa nyinta Jesuurna pitjika, town-angatjina. Artwa nhanha era enka korna ntjarrakarta naka. Era kala imankangatjina mantarrakunya nthulapukala. Era turta itja ilthala nitjata, wolknganga mpopala pula. ");
INSERT INTO are_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesuanha aramala, artwa era ilkarlalhaka, Jesuanga urlarra mparalela turta arrarnalhaka. Erantama intarra ilkaka, “Jesuai, Altjirra Kngarra ekura 'Lirai, iwunhangama unta nukurna pitjika? Yinga ungkwangurna ingkama, unta yinganha itja rrukunthakunthilitjika.” ");
INSERT INTO are_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Erataka lakinha angkaka, Jesuala enka korna erinha kala turnakalanga ekuranga rratitjika. Arai, enka korna erataka artwa nhanha ekururna kutatha irrputjata. Relha ntjarralantama iltja pa ingka ekuranha chain-ala yirnamalanga, era chain etnanha kala urltakitjatanta. Kurunga enka kornala erinha worritjurna tnalhitjata. ");
INSERT INTO are_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesualantama artwa erinha pmarraka, “Rretnya ngunhama unta?” Era angkaka, “Yinga nama rretnya ‘Ntjarra’.” Era lakinha ilalhaka, enka korna ntjarra warta ekuranga kwanala namanga. ");
INSERT INTO are_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Enka korna etnantama Jesuurna ingkaka era etnanha itja tatharrurna naamalhelitjika. ");
INSERT INTO are_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Etinya wara, parta ingkala, pig ntjarrala marna ilkurlanaka. Enka korna etnantama Jesuurna ingkaka era etnanha impurlarrarnitjika pig ntjarrurna irrputjika. Jesuala etnanha impurlarrarnaka. ");
INSERT INTO are_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Enka korna etnantama artwa ekuranga rratamala, pig etnakurnantama irrpuka. Pig etnantama rirterramala parta irnkurna arrtjanamala, kwatja ntjangurna tnyinhaka, alkngontingkaka turta. ");
INSERT INTO are_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Artwa pig ntarntarintja ntjarrala nhanha aramalanga, etna town-urna arrtjanaka, tnukulpa ntjarrurna turta, yia erinha ilarlaputjika. ");
INSERT INTO are_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pmararinya ntjarrantama pitjika aritjika. Jesuurna etinyerramala, etna artwa nhanganha araka. Era eterrintja marrakartantama naka, mantarraka ekarralhakala turta. Etnantama trerraka. ");
INSERT INTO are_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Relha etnantama, etnala artwa marrerrakala erinha arakala, etna nhanha relha arrpunha ntjarranha turta ilaka. ");
INSERT INTO are_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kurunga relha pmara Gerasa-arinya ingkarraka Jesuurna pitjika. Etna ekururna ingkaka turta era pmara etnakanhanga lhitjika. Etnataka ekuranga kngarra inthorra trerraka. Jesuanhantama boat-aka ntjimala, kala lhaka. ");
INSERT INTO are_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jesuanha pula boat-aka ntjilanamangantema, artwa marrerrakala era Jesuanha ilaka, “Yinga ungkwangalela lhitjika antja.” Jesuala pula erinha ilaka, ");
INSERT INTO are_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Tjina ungkwanganha ntjarrurna alpai. Etnanha turta ilai Altjirrala nganha marrilakala.” Artwa erantama lhaka, era turta town-arinya ingkarrakanha alpmelaka Jesuala erinha marrilakala. ");
INSERT INTO are_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesuanha pitjalpumalangantama, relha ingkarraka kangkaka, etna ekura kaaralhakalanga warta. ");
INSERT INTO are_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Arai, artwa nyintantama Jesuurna pitjika, ekuranga urlarra mparalela turta arrarnalhaka. Artwa ekura rretnya naka Jairus. Era synagogue-aka itornka naka. Erantama Jesuurna ingkaka era iltha ekuranhurna pitjitjika. ");
INSERT INTO are_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kwarra nyintanta ekuranhataka ilutjikerraka. Kwarra erataka 12 years ingkwia ngerra naka. Etna kala lhapalhamanga, relha worla etna Jesuanha parlpapauwurlapuka, ekururna etinyerritjikerramala. ");
INSERT INTO are_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Arrkutja nyinta worla nhanha ekurala naka, erala kala 12 years menta kngarrakarta nakala. Ngangkarala turta erinha yarna kuta marrilakala. ");
INSERT INTO are_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ingkarnanga pitjimala, era Jesuaka mantarra anpuka, kantja inthorra. Erantama marrerralalhaka. ");
INSERT INTO are_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesualantama relha ntjarranha pmarraka, “Ngulama yinganha anpuka?” Relha ingkarraka yiparrarnalhaka. Peter-anhantama angkaka, “Ingkartai, relha worla kngarralataka nganha parlpapauwuma.” ");
INSERT INTO are_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesuala pula etnanha ilaka, “Nyintala kunha yinganha anpuka. Yingataka wulhalalhaka, yinga kurrka thaltjerramanga ngerra.” ");
INSERT INTO are_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Arrkutja erantama lhangkaraka era yarna Jesuanga lauwulhamanga. Errowumala era Jesuurna pitjika, ekuranga urlarra turta mparalela arrarnalhaka. Erantama erinha relha ntjarranga alkngatharra ilaka, “Atha nganha anpuka yinga menta namanga. Arai, yinga turta nhanha kala marrerrakalantama nama.” ");
INSERT INTO are_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesualantama erinha ilaka, “Kwarra nukai, unta yinganha tnakakalanga, Altjirrala nganha kala marrilaka. Kala tnoatnoa alpai!” ");
INSERT INTO are_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesuanha angkamangantema, urrpia Jairus-aka pmaranga pitjika. Etna Jairus-anha ilaka, “Kwarra ungkwanganha kunha kala itja wotha. Itornka erinha kala impai erarrpa lhitjika.” ");
INSERT INTO are_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Angkatja nhanha wumala, Jesuala Jairus-anha ilaka, “Itja trerrai. Yinganha tnakantai, kurunga kwarra ungkwanga kala marrerritjina.” ");
INSERT INTO are_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesuanha Jairus-aka ilthakerrakantama. Erantama relha arrpunha ntjarranha parraka itja ekuralela ilthurna irrputjika. Era kala Peter, John, James ntjarrakartanta irrpunhaka, kwarra errilknga ekuranhaka kaarta miakarta turta. ");
INSERT INTO are_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Relha ingkarraka kwarra ekura itnirlanaka, nthorrkngerraka turta. Jesuala pula etnanha ilaka, “Rrangkarra itja itnitjika. Era itja iluka, ankwentama wara.” ");
INSERT INTO are_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Relha etna pula ekura tharraka. Etna kaltja naka kwarra era ilukala. ");
INSERT INTO are_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kwarra erinha iltjangantama errkumala, Jesuala erinha ilaka, “Kwarrai, kamerrai!” ");
INSERT INTO are_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kwarra ekura enkantama ekururna pitjalpuka, era turta kala kamerraka. Jesualantama etnanha turnaka, etna kwarra erinha marna ilkutjika nthitjika. ");
INSERT INTO are_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kaarta mia ekuranha kala tnolkakanta. Jesuala pula erinhatharra turnaka, eratharra itja relha arrpunhanha nhanhiperra alpmelitjika. ");
INSERT INTO are_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesuanha 12 etnaka ntangkalhaka. Erantama etnanha ekarltilaka enka korna ntjarranha relhanga unpurlenitjika, relha menta arrpunhakarta ntjarranha turta marrilitjika. ");
INSERT INTO are_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kurunga era etnanha yairnaka relha ntjarranha ilitjika Altjirranha kala relha ingkarrakaka ntelalhitjikerramanga era Ingkarta etnaka namanga. Era etnanha ilaka turta etna relha menta ntjarranha marrilitjika. ");
INSERT INTO are_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Era etnanha lakinha turta ilaka, “Rrangkarra itja erratitja, thauwa, marna, money, shirt arrpunha turta paka tjaiyaka kngitjika. ");
INSERT INTO are_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Relhala paka rrangkarranha ntangkamanga etnakalela kuterritjika, kala etnakalela kuterrai, rrangkarra anpara lhitjinalpula. ");
INSERT INTO are_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Thunga relha arrpunha ntjarra rrakangkarra antjakunya. Town lenhanga kala rratamala lhai. Town lenhaka urlpmurra turta ingka rrakangkarranhanga ilarnai, etnanha lhalaramala.” ");
INSERT INTO are_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Etna kala lhaka. Etnantama town-arrpaninhurna lhamala Yia Marra erinha ilarlapuka, relha menta ntjarranha turta marrilaka. ");
INSERT INTO are_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","King Herod-alantama nhanha ingkarrakiperra wuka. Erantama yarna etarlaritjikerraka. Arrpunha ntjarrala ilaka Altjirrala kula John-anha errilknga ntjarranga kamalhelakala. ");
INSERT INTO are_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Arrpunha ntjarrala ilaka Elijah-anha kula pitjalpukala. Kala arrpunha ntjarrala ilaka Altjirraka urrpia imankinya arrpunha kula kamerrakala. ");
INSERT INTO are_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod-anha pula angkaka, “Atha nhanga arrpunha ntjarranha turnaka John-aka kapurta inturnitjika. Ngunhantama artwa arrpunha nhanha, ekuriperrala atha yia kngarra inthorra wuma?” Erantama antja inthorra naka Jesuanha aritjika. ");
INSERT INTO are_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apostle etnantama Jesuanha yia ilitjalpuka. Jesuanhantama etnakakarta Bethsaida town-urna lhaka, etnarrpa nitjika. ");
INSERT INTO are_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Relha worla etna pula wumalanga Jesuanha pmara arrpunhurna lhakala, etna erinha lurnaka. Etnanha aramala, Jesuanha etnaka kangkaka. Erantama etnanha kaltjinthaka Altjirranha kala relha ingkarrakaka Ingkartanamanga. Era menta ntjarranha turta marrilaka. ");
INSERT INTO are_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kala ngurrangurra ngerrantama errakalanga, 12 apostle etna Jesuurna pitjimala erinha ilaka, “Relha etnanha kala pmara kurrka ntjarrurna yairnai, town kurrka ntjarrurna turta, marnaka. Nurna kunha pmara worritjala nama.” ");
INSERT INTO are_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesuala pula etnanha ilaka, “Rrangkarratitja etnanha marna ilkutjika nthai.” Etna pula angkaka, “Nurnaka kunha marna kurrka 5-anta intama, irrpannga tharra turta. Unta antja nurna lhamala worla kngarra nhanhaka marna buy-emilitjika?” ");
INSERT INTO are_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Artwa 5,000 ngerrataka naka. Jesualantama kurtungurla ekuranha ntjarranha ilaka, “Relha etnanha worlamaworla arrarnalhitjika ilai, nhanga relha 50 ngerra worla nyintaminyintala.” ");
INSERT INTO are_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kurtungurla etna kala relha etnanha arrarnalhitjika turnaka. Relha etna turta worlamaworla arrarnalhaka. ");
INSERT INTO are_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesualantama marna 5, irrpannga tharra etnanha turta inaka. Alkirurnathaka irnaramala, era Altjirranha dangkilaka. Kurunga era marna pa irrpannga etnanha urltakaka. Erantama ungkwaltja etnanha kurtungurla ntjarranha nthaka relha ntjarraka errarnpalhelitjika. ");
INSERT INTO are_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Relha ingkarrakala kala ilkukantama. Etna turta nhalkerraka. Kurtungurla etnantama 12 basket lyulpalyulpilaka marna ungkwaltja ipmintjerrakalakarta. ");
INSERT INTO are_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Arrpunharanga, Jesuanha Kaarta ekuranhurna ingkaka. Kurtungurla ekuranha ntjarra ekuralela nakantema. Kurunga Jesuala etnanha pmarraka, “Ngunhama relha ntjarrala ilama yinga namanga?” ");
INSERT INTO are_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Etna erinha alpmelaka, “Arrpunha ntjarrala ilama unta kula John Kaltjirrpulhelanhelanha era namanga. Arrpunha ntjarrala ilama, Elijah-anha. Arrpunha ntjarrala ilama Altjirrala kula urrpia imankinya arrpunha wotha etathilakala.” ");
INSERT INTO are_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesualantama etnanha wotha pmarraka, “Kanha rrangkarraloa? Rrangkarra nukiperra nthakinhala etarlarama? Ngunha inthorrama yinga?” Peter-ala erinha alpmelaka, “Unta nama Altjirraka Krista era, Tangkalhelanha Altjirralala nurnakurna yairnakala.” ");
INSERT INTO are_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesualantama etnanha tjatjatuka etna itja inthorra relha arrpunhaka ilitjika, era Krista era namanga. ");
INSERT INTO are_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesuanhantama kuta angkaka, “Arai, Relhaka 'Lirakathaka nama kngarra nyingalauwutjika. Kngarripata ntarntarintja ntjarra, priest itornka ntjarra, artwa Intarrangaltha ntjarra turta ekura antjakunyerritjina. Etnantama erinha arrpunha ntjarraka lanthitjina erinha errilknga tutjika. Arlta tharraminyintala pula Altjirrala erinha wotha kamalhelitjina.” ");
INSERT INTO are_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesualantama relha ingkarrakanha ilaka, “Thunga relha antja nama nukanga tnaartangala pitjitjika. Era itja wotha eterrintja ekuranhaka kangkwerritjika. Era pula arltamarlta ntolka ekuranha parlapaka tjurnamala kngitjika, athala ntolka nukanha kngamanga ngerra. Kurunga era nukanga tnaartangala pitjitjika. ");
INSERT INTO are_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Arai, relha erala thakerrama etatha nitjikanta, era kala ilutjina. Kanha relha erala relha arrpunha ntjarranha impurlarrarnama erinha errilknga tutjika nukakwia, era kala ngampakalala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Thunga relhala Altjirranha etarlaritjikanha yultha ingkarraka inthorra patilama. Erantama anma iluma. Nthakinhantama era nitjina? Era itja ngampakala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Arai, relha arrpunha ntjarra lyarta Altjirraka itja kangkama. Lakinhanga relha arrpunha errakarrerrama nukiperra alkngatharra angkitjika, angkatja nukanha paka etnanha alpmelitjika. Relha lenhantama anma nthakinherritjina? Relhaka 'Lira era pitjalpumalanga, era relha ekura errakarrantema erritjina. Relhaka 'Lira era kunha anma pitjalputjina Kaartala erinha ekarltilakalangantama. Era turta angel alkngaltara ntjarrakarta pitjitjina. ");
INSERT INTO are_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Atha pula rrangkarranha nhanha nthurrpa ilama. Relha arrpunha ntjarra etnala lyarta nhanhala nama, etna katha aritjina Altjirranha relha ingkarrakaka Ingkartanamanga, etna ilutjikanhangantema.” ");
INSERT INTO are_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nhanga lakinha angkamaliperra, arlta 8 ngerra kala yirrakantama. Kurunga Jesuala Peter-anha, John-anha, James-anha turta ntangkaka. Erantama etnakakarta parta kartninyurna ntjika, Altjirrurna ingkitjika. ");
INSERT INTO are_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesuanhantama Altjirrurna ingkamalanga, Altjirrala Jesuaka anngerra kngartiwuka, mantarra ekuranha turtantama tjulkuka inthorra. ");
INSERT INTO are_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Artwa tharrantama, Moses Elijah tharra rumerraka, Jesualela angkarraka turta. ");
INSERT INTO are_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Moses eratharra makalaria inthorrantema naka. Eratharrantama Jesuiperra angkaka, nhanga erala Jerusalem-ala anma ilutjinala turta. ");
INSERT INTO are_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter ntjarrataka ankwerrakala. Kaarrerramala etna Jesuanha araka, makalaria inthorra, artwa erinhatharra turta, eratharrala Jesualela itnamanga. ");
INSERT INTO are_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moses Elijah tharra kala lhitjikerramalanga, Peter-ala Jesuanha ilaka, “Kaltjinthanhinthanhai, nurnataka kangkama pmara nhala nitjika. Unta paka antja namanga, nurna kala lyuntja tharraminyinta itamara, ungkwanga nyinta, Moses-aka nyinta, Elijah-aka nyinta.” Peter-anhataka marntilparla wara angkaka. ");
INSERT INTO are_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peter-anha lakinha angkamalangantema, matarala etnanha korltaka. Kurtungurla etnantama trerraka. ");
INSERT INTO are_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Matara ekuranga Altjirranha angkakantama, “Nhanha kunha 'Lira nuka. Atharrpa erinha urraraka. Rrangkarra kala ekura kangkwerritjika.” ");
INSERT INTO are_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Altjirranha kala angkakalangantama, kurtungurla ntjarrala Jesua erinhanta araka. Etna pula itja relha arrpunhanha ilaka nhanga etnala arakala. Etna nhanha anmanta ilaka. ");
INSERT INTO are_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kala arlta arrpunhalantama, Jesuanha, kurtungurla tharraminyinta nhanga turta, partanga tnanpuka. Relha worla kngarrantama Jesuurna urlarrakurlarra pitjika. ");
INSERT INTO are_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Artwa nyintantama worla ekuranga Jesuaka ilkarlalhaka, “Kaltjinthanhinthanhai, worra nukanhaka montjamontja ntelalhai. Era kunha worra nyintanta nukanha. ");
INSERT INTO are_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Arai, arrpunharanga enka korna ekururna irrpumalanga, worra era ilkarlalhama. Kurunga enka kornala erinha arnaka ilatuma. Rrakarta ekuranha turtantama alkurrpalkurrperrama. Kurunga erinha porrkaporrka inthorrilamalanta, enka korna era ekuranga wotha rratama. ");
INSERT INTO are_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yinga kurtungurla ungkwanganha ntjarrurna ingkaka etna enka korna erinha unputjika, etna pula erinha yarna unpuka.” ");
INSERT INTO are_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesualantama etnanha ilaka, “Rrangkarrataka arrthata, rrangkarra turta Altjirranha itja tnakama. Kuta inthorrama yinga rrakangkarralela nitjika, rrangkarranha kaltjinthitjika turta? Rrangkarrataka yinganha porrkaporrkilama.” Erantama kaarta ekuranha ilaka, “Worra erinha nukurna kngitjai.” ");
INSERT INTO are_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Etna worra erinha ekururna kngitjimalangantema, enka kornala worra erinha mpurlpampakaka, erinha arnaka ilatuka turta. Jesuala pula enka korna erinha parraka, worra erinha marrilaka turta. Kurunga era erinha kaarta ekuranhurna nthitjalpuka. ");
INSERT INTO are_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Relha etna pula tnolkaka, Altjirranha ekarlta inthorra ntelalhakalanga. Relha etna nhanhiperra angkarramalangantema, Jesuala kurtungurla ekuranha ntjarranha ilaka. ");
INSERT INTO are_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Montja inthorrala wurrirrai, angkatja athala rrangkarranha ilitjinala. Arai, etnataka Relhaka 'Lira erinha leltjaka lanthitjina.” ");
INSERT INTO are_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kurtungurla etna pula angkatja nhanha itja lhangkaraka, Altjirrala nhanha etnakanga lauwukalanga. Etna pula trerraka turta Jesuanha angkatja ekuriperra pmarritjika. ");
INSERT INTO are_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesuaka kurtungurla ntjarra iwurrakantama, lakinha pmarrarramala, “Nurnakanga ngunhama arrpunha ntjarraka itornka nama?” ");
INSERT INTO are_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesuanha kala eterrintja etnakanhaka kaltja naka. Erantama katjia nyinta inamala, katjia erinha ekuranga kutaka ingkairnaka. ");
INSERT INTO are_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Erantama etnanha ilaka, “Relha erala katjia nhanhaka kangkintja ntelalhama, yinganha etarlaramala, era nuka kangkintja ntelalhama. Relha erala nuka kangkintja ntelalhama, era kala ekura kangkintja ntelalhama, erala yinganha yairnakala. Arai, rrakangkarranga artwa erala tjurnalhitjikanha, erataka itornka nama.” ");
INSERT INTO are_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John-ala Jesuanha ilaka, “Kaltjinthanhinthanhai, nurna artwa nyintanha araka enka korna ntjarranha relha ntjarranga unpumanga, rretnya ungkwanganha ilamala. Nurnantama erinha parraka, era itja worla nurnakanhanga namanga.” ");
INSERT INTO are_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesuala pula erinha ilaka, “Rrangkarra erinha itja parritjika. Arai, relha erala rrakangkarra irrpaltherritjikanha, era kala rrakangkarra tjina nama.” ");
INSERT INTO are_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Antala nhanga Jesuanha wotha alkirurna alputjika kala etinyerrakalangantama, Jesuanha eterraka kala Jerusalem-urna lhitjikantaparra. ");
INSERT INTO are_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Erantama urrpia yairnaka town kurrka nyinturna Samaria-ala, ekura pmara arltaritjika, nhanga intitjikalkakwia. Urrpia etna lhaka. Town kurrka ekuraka erritjalhamala, etna pmaraka yonthaka. ");
INSERT INTO are_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pmararinya ntjarra pula Jesuaka antjakunya naka, era Jerusalem-urna lhamanga. ");
INSERT INTO are_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nhanha aramala, kurtungurla tharrala, James John tharrala Jesuanha pmarraka, “Ingkartai, unta antjama nama nurna Altjirrurna ingkitjika era ura alkiranga yairnitjika, town kurrka nhanha yirralhelitjika?” ");
INSERT INTO are_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesuala pula erinhatharra alkngatharra rralthaka. ");
INSERT INTO are_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Etnantama pmara kurrka arrpunhurna lhaka. ");
INSERT INTO are_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Etna tjaiyala lhapalhamalanga, artwa nyintala Jesuanha ilaka, “Pmara ekururnala unta lhamanga, yinga kala ungkwanganga tnaartangala lhitjina.” ");
INSERT INTO are_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesuala erinha ilaka, “Kngulya itnuraka lhunga intama, thepaka turta antjwa. Kanha Relhaka 'Lira ilthakunyala nama.” ");
INSERT INTO are_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesualantama artwa arrpunhanha ntangkaka, “Nukanga tnaartangala pitjai.” Artwa era pula angkaka, “Yinganha impurlarrarnai kaarta nukanharrka tintjiwutjika.” ");
INSERT INTO are_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesuala pula erinha ilaka, “Relha errilknga ntjarranha impai errilknga etnakanha tintjiwutjika. Unta pula lhai relha arrpunha ntjarranha ilitjika Altjirranha kala relha ingkarrakaka Ingkarta nama.” ");
INSERT INTO are_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kurunga artwa arrpunhantama Jesuurna angkaka, “Ingkartai, yinga kala ungkwanganga tnaartangala lhitjina. Unta pula yinganha impurlarrarnai tjina nukanha ntjarranharrka ararlalputjika.” ");
INSERT INTO are_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesuala erinha ilaka, “Relha erala nukanga tnaartangala pitjitjika antja, era itja wotha ilkngaralhitjika. Relha erala ilkngaralhama, era Altjirraka pmara kutathurna itja irrputjina.” ");
INSERT INTO are_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nhanhiperra Ingkartala artwa 72 arrpunha urraraka, etnanha turta urrpia yairnaka town kurrka ntjarrurna, town kngarritja ntjarrurna turta. Era etnanha tharramatharra kuta yairnaka, ekuranga arrkurla lhitjika. ");
INSERT INTO are_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Era etnanha ilaka, “Arai, relha ntjarra inthorrala Altjirraka Angkatja wutjika antja. Altjirranha turta antja nama etna angkatja ekuranha wutjika. Urrpia etna pula urrputja inthorrarrpala. Lakinhanga rrangkarra Altjirrurna ingkitjika, era urrpia ntjarra urraritjika, etnanha turta relha ntjarrurna yairnitjika, relha etnanha angkatja ekuranha ilitjika. ");
INSERT INTO are_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kalantama rrangkarra lharrirrai. Atha rrangkarranha sheep ngwanga ntjarra ngerra yairnama, kngulya itnura ntjarranga mpopurna. ");
INSERT INTO are_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Rrangkarra itja money paka, thauwa paka, sandal paka kngitjika. Rrangkarra turta itja relha arrpunha ntjarranha anparnitjika, rrangkarra tjaiyala lhamanga. ");
INSERT INTO are_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Rrangkarra ilthaka irrpumalanga, rrangkarra arrkurla ilthala namala ntjarranha lakinha ilitjika, ‘Altjirranha rrakangkarra rilhera ntelalhama.’ ");
INSERT INTO are_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Relha etna paka Altjirraka kangkamanga, Altjirranha etnaka nthurrpa rilhera ntelalhitjina. Itjanga paka, itja kutala. ");
INSERT INTO are_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kala iltha nyintalanta kuterrai. Kunpala turta marnalka ilkwai, etnala rrangkarranha ilkutjika nthamanga. Nhanha kunha urrkapunhapunhakathaka nama, arrpunhala erinha kwartiwutjika. Rrangkarra pula itja iltha nyintalarrka nitjika, kurunga arrpunhurnantama lhitjika. Kala iltha nyintalanta kuterrai. ");
INSERT INTO are_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Rrangkarra town-urna irrpumalanga, relha etna turta rrakangkarra kangkamanga, kala kunpala ilkwai marna etnala rrangkarranha nthamanga. ");
INSERT INTO are_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Relha arrpunha ntjarra paka menta namanga, etnanha marrilai. Relha ingkarrakanha ilai Altjirranha ntelalhitjina era relha ingkarrakaka Ingkartanamanga. ");
INSERT INTO are_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Rrangkarra pula town-urna irrpumanga, relha etna turta rrakangkarra antjakunya namanga, rrangkarra relha etnanha alkngatharra ilitjika, ");
INSERT INTO are_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Arai, nurna pmara rrakangkarranhaka urlpmurra turta ingkanga ilarnama, rrangkarranha lhalaramala. Rrangkarra pula kaltja nitjika Altjirranha ntelalhitjina era relha ingkarrakaka Ingkartanamanga’. ");
INSERT INTO are_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Atha rrangkarranha nhanha turta ilama. Altjirranha anma pitjimalanga relha ingkarrakanha tjiperrawutjika, era relha Sodom-arinya ntjarranha kurrkalkura rrarrathala tutjina. Kanha relha town lenharinya ntjarranha era kngarralkurala rrarrathala tutjina.” ");
INSERT INTO are_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Relha Chorazin-arinya ntjarrai, rrangkarra nakapakarla inthorra nitjina. Relha Bethsaida-arinya ntjarrai, rrangkarra turta nakapakarla inthorra nitjina. Atha rrakangkarranga alkngatharra tjatjikarta ntjarra urrkapuka. Atha paka tjatjikarta nhanha etnanha relha Tyre-arinya urlarra urrkapukalanga, relha Sidon-arinya ntjarranga urlarra turta, etna pmara imanka Altjirrurna toperramara. Etna kala ltarrpaka mantarraka ekarralhamara, ilpminya turta kapurtaka arrarnamara. ");
INSERT INTO are_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Altjirranha pitjimalanga relhanha tjiperrawutjika, nhanha rukaralkura nitjina relha Tyre-arinya ntjarraka, relha Sidon-arinya ntjarraka turta, nhanhala rrakangkarra nitjinangatjina. ");
INSERT INTO are_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Relha Capernaum-arinya ntjarrai, rrangkarra etarlarama Altjirrala kula rrangkarranha alkirurna kngitjinala. Itjanga lhai! Rrangkarranha pula Altjirrala tatharrurnatitja naamalhelitjina. ");
INSERT INTO are_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Arai, relha erala rrakangkarra kangkwerrama, era nuka kangkwerrama. Relha erala rrakangkarra antjakunya nama, era nuka antjakunya nama. Relha erala nuka antjakunya nama, erataka ekura antjakunya nama, erala yinganha yairnakala.” ");
INSERT INTO are_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Urrpia 72 nhanga ntjarra arrkana inthorra pitjalpuka, lakinha angkamala, “Ingkartai, enka korna etna turta nurnaka kangkwerrakau, nurna etnanha rretnya ungkwanganhala unpumanga.” ");
INSERT INTO are_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesuala etnanha ilaka, “Atha Satan-anha araka alkiranga tnyimanga, kwatjala lharrkamanga ngerra. ");
INSERT INTO are_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Arai, atha rrangkarranha ekarltilaka, rrangkarra errintja ntjarranha, Satan-anha turta nakapakarlilitjika. Etna turta rrangkarranha yarna kapanha kornilitjina. ");
INSERT INTO are_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Arai, rrangkarra kunha kangkama, rrangkarra errintja ntjarranha pmakwinamanga. Atha pula rrangkarranha ilama, rrangkarra nhanhakanta kangkitjika, Altjirrala rretnya rrakangkarranha pepa ekuranhaka intalhelakalanga, alkirala.” ");
INSERT INTO are_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jesuanha nhanga lakinha angkamalanga, Enka Alkngaltarala erinha arrkanilaka. Erantama Altjirranha ilaka, “Kaartai, untala Ingkarta nama alkirala alhala turta. Atha nganha dangkilama, unta yia nhanha ingkarraka relha kornakorna ntjarraka nentilakalanga, itja relha kaltja ntjarraka, inangkarla ntjarraka turta. Kaartai, untarrpa kunha lakinha ntelalhitjika antja naka. ");
INSERT INTO are_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Arai, Kaartala yinganha ingkairnaka relha ingkarrakaka Ingkarta nitjika. Era turta yinganha ilaka erala eterramala ingkarrakaka. Relha nyinta itja 'Liraka kaltja, Kaarta eranta wara. Relha nyinta itja Kaartaka kaltja, 'Lira eranta wara. 'Lira era turta Kaarta erinha relha ekura imarnama, ekurala 'Lira era antja nama erinha imarnitjika.” ");
INSERT INTO are_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kala etnarrpantama namalanga, Jesuala kurtungurla ekuranha ntjarranha ilaka, “Relha etnala nhanha ingkarraka arama, nhanga rrangkarrala arama, etna arrkana nama. ");
INSERT INTO are_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Altjirraka urrpia imankinya ntjarra, king imankinya ntjarra turta, etna antja naka nhanha aritjika rrangkarrala lyarta aramanga, etna pula nhanha itja araka. Etna turta antja naka angkatja nukanha wutjika, angkatja nhanga rrangkarrala lyarta wuma, etna pula nhanha itja wuka.” ");
INSERT INTO are_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Arai, artwa Intarrangaltha nyintantama kamerramala Jesuanha arrkarnamala pmarraka, “Kaltjinthanhinthanhai, nthakinhama yinga ntelalhitjika yinga Altjirraka pmarala ngampakala etatha nitjinanga?” ");
INSERT INTO are_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesuala erinha pmarraka, “Iwunhama Altjirraka Angkatjala ilama? Nthakinha unta ekurala read-erraka?” ");
INSERT INTO are_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Era angkaka, “Unta Ingkarta Altjirra ungkwanganhaka kngarra inthorra kangkitjika. Unta erinhanta tnakitjika. Unta ekuranta kangkwerritjika. Unta ekura kuta eterritjika. Unta turta relha arrpunha ntjarraka kangkitjika, untala ungkwangararrpa kangkamanga ngerra.” ");
INSERT INTO are_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesuala erinha ilaka, “Unta kala yinganha arratja alpmelaka. Turnintja nhanha tharraka kangkwerrai, kurunga unta Altjirraka pmarala ngampakala etatha nitjina.” ");
INSERT INTO are_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Artwa Intarrangaltha era etarlaraka era kula turnintja nhanha tharraka kala arratja kangkwerramanga. Lakinhanga era Jesuanha wotha pmarraka, “Relha Lorinyaka turtama yinga kangkintja ntelalhitjika?” ");
INSERT INTO are_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesuala erinha yia nhanha alpmelaka. “Artwa nyinta Jerusalem-anga Jericho town-urna lhaka. Era tjaiyala lhapalhamanga, artwa nyilkngampa ntjarrala erinha errkuka. Mantarra ekuranhalka inamala, etna erinha tumala kala ilutjikanta impurlalhaka. ");
INSERT INTO are_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Artwa priest nyintantama tjaiya lenhala pitjika. Era artwa erinha araka, maamakarta ilkaarta intamanga. Era pula parrpa anparerraka. ");
INSERT INTO are_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Artwa Levite-ntama pitjika. Era turta artwa erinha arakantema, maamakarta ilkaarta intamanga. Era turta pula parrpa anparerrakantema. ");
INSERT INTO are_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Kurunga artwa Samaria-arinya nyintantama pitjika. Era artwa erinha araka, maamakarta ilkaarta intamanga. Era pula ekura konyerrakala. ");
INSERT INTO are_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Era artwa ekura maama ntirala, wine-ala turta parnaka, maama etnanha mantarrala turta yirnaka. Kurunga artwa Samaria-arinya era artwa maamakarta erinha donkey ekuranhaka tjurnaka. Era erinha relha epinya intanhintanhaka ilthurna turta kngaka. Era erinha ntarntaraka turta. ");
INSERT INTO are_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kala ingutnhalantama, anpara lhitjinala, era ilthakurtwia erinha money nthaka. Era erinha ilaka, “Artwa maamakarta erinha ntarntarau! Era paka kuta ngerra ilkaarta intamanga, anma yinga pitjalpumalanga, atha nganha money wotha nthitjina.” ");
INSERT INTO are_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesualantama artwa Intarrangaltha erinha pmarraka, “Nthakinhantama unta etarlarama? Artwa tharraminyinta nhanha etnakanga, etnala artwa maamakarta erinha tjaiyaka arakala, ngunha paka ekura kangkintja ntelalhaka?” ");
INSERT INTO are_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Artwa Intarrangaltha era angkaka, “Lenha era kunha, erala ekura montjamontja ntelalhakala.” Jesualantama erinha ilaka, “Unta turtantama kangkintja ntelalhai, artwa Samaria-arinya erala kangkintja ntelalhakala ngerra.” ");
INSERT INTO are_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Urntwarra lhamala, Jesuanha town kurrka nyinturnantama irrpunhaka. Arrkutja nyinta town ekurala naka, rretnya ekura Martha. Era Jesuanha iltha ekuranhurna ntangkaka, yatjarra narlalputjika. ");
INSERT INTO are_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martha-aka tjia, rretnya ekura Mary, era ilthala nakantema. Relha ntjarra pitjika Jesuanha wutjika. Jesuala etnanha kaltjinthamalanga, Mary-anha Jesuanga etinya arrarnalhaka, erinha wurlanitjika. ");
INSERT INTO are_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kanha Martha-anha parrpartilalhakala marnaka kngarra urrkapumala. Jesuanga itnatjalhamalantama, Martha-ala erinha ilaka, “Ingkartai, unta kunpalala ararlanama yinga nyintanta kngarra urrkapumanga? Unta Mary-anha ilai ilirna tangitjala marnaka urrkaputjika!” ");
INSERT INTO are_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ingkartala pula erinha ilaka, “Martha, tjina nukai, untataka marniperra kngarra eterramala parrpartilalhamarrpa. ");
INSERT INTO are_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nyintanta kunha tjiparra nama, yinganha wurlanitjika. Mary-ala yinganha wurlanama. Athantama erinha itja parritjina.” ");
INSERT INTO are_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Arrpunharanga Jesuanha Kaarta ekuranhurna ingkamalanga, kurtungurla ekuranha ntjarra ekuralela nakantema. Era kala ingkakalangantama, kurtungurla ekuranha arrpunhala erinha pmarraka, “Ingkartai, nurnanha kaltjinthai Altjirrurna ingkitjika, nhanga John-alala kurtungurla ekuranha ntjarra kaltjinthakala ngerra.” ");
INSERT INTO are_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesualantama etnanha ilaka, “Rrangkarra Altjirrurna ingkamalanga, rrangkarra lakinha angkitjika, ‘Kaartai, relha ingkarrakanha kaltjinthai rretnya ungkwanganha arratjanta ilitjika. Pitjai, relha ingkarrakaka ntelalhitjika unta Ingkartanamanga. ");
INSERT INTO are_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Marna nurnakanha nurnanha arltamarlta nthai. ");
INSERT INTO are_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Korna nurnakanha iwai, nurnala relha arrpunhaka korna iwumanga ngerra. Nurna arrkarnintjurnerramalanga, nurnanha tnyinai.’ ");
INSERT INTO are_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesualantama etnanha ilaka, “Thunga ungkwanga tjina intama. Untantama ekururna ingwa mpopala lhama, ekura enkama turta, ‘Tjinai, yinganha marna urrputja nthai. ");
INSERT INTO are_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tjina nukanha arrpunha lyarta nhanha nukurna pitjika. Nuka turta marna itja intama erinha ilkutjika nthitjika.’ ");
INSERT INTO are_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Thunga turta tjina ungkwanganha, ungkwangurna lakinha angkitjina, ‘Yinganha porrkaporrkilitjalai. Arai, atha kala reoa nukanha twantaka, katjia nukanha ntjarra turta kala nukalela ntjamala ankwentama. Yinga yarna wotha kamerrama nganha marna nthitjika.’ ");
INSERT INTO are_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Atha rrangkarranha iliai,” Jesuanha kuta angkaka, “tjina ungkwanganhala nganha itja marna nthitjina unta tjina ekuranha namanga. Era pula kamerramala nganha marna nthitjina, unta erinha kuta pmarralanamanga warta. ");
INSERT INTO are_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Lakinhanga atha rrangkarranha ilama, Altjirrurna ingkai, kurunga era rrangkarranha kala wutjina. Altjirraka yonthai, kurunga rrangkarra erinha kala arltaritjina. Altjirraka reoa iltaratwai, kurunga era rrakangkarra kala altjurilitjina. ");
INSERT INTO are_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Arai, relha nyintaminyinta erala Altjirrurna ingkama, ekura Altjirranha kangkwerritjina. Relha nyintaminyinta erala Altjirraka yonthama, era erinha kala arltaritjina. Relha nyintaminyinta erala Altjirraka reoa iltaratuma, ekura Altjirrala kala altjurilitjina. ");
INSERT INTO are_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Unta paka kaarta namanga, 'lira ungkwanga turta kara irrpanngaka enkamanga, unta erinha apma nthitjina? ");
INSERT INTO are_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Era paka kara kwartaka enkamanga, unta erinha tnatatha nthitjina? Itja kunha. ");
INSERT INTO are_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Relha korna rrangkarra, rrangkarra kaltja 'lira rrakangkarranha yultha marra nthitjika. Wothalkura Kaarta Alkirarinyala Enka Alkngaltara erinha rrakangkarrurna yairnitjina, rrangkarra ekururna ingkamanga.” ");
INSERT INTO are_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesuala enka korna artwa nyintanga unpurlenaka. Enka korna nhanha erataka artwa erinha angkatjakunyilakala. Jesuala warta enka korna erinha unpurlenaka, kanha artwa era angkakala. Nhanha aramala, relha worla etna tnolkaka. ");
INSERT INTO are_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Arrpunha ntjarrala pula ilaka, “Artwa nhanhalataka enka korna ntjarranha unpurlenama Beelzebul-ala erinha ekarltilamanga.” Beelzebul erataka errintja ntjarraka itornka naka. ");
INSERT INTO are_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Arrpunha ntjarra pula antja naka Jesuala etnaka tjatjikarta ntelitjika, etna kaltja nitjinanga Altjirrala erinha nthurrpa yairnakala. ");
INSERT INTO are_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesuanha kala kaltja naka etnala eterramalaka. Erantama etnanha ilaka, “Relha pmararinya ntjarra leltjakaleltjerramanga, pmara etnaka kala ipmintjerritjina. Ramarama turta. Etna leltjakaleltjerramanga, etna kala yirritjina. ");
INSERT INTO are_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satan-ala paka enka korna ntjarranha unpurlenamanga, Satan-aka worla turta kala leltjakaleltjerrakala nama. Etna turtantama yirritjinantema. Nthakinhantama rrangkarra angkama atha kula errintja ntjarranha unpurlenamanga, Beelzebul-ala yinganha ekarltilakalanga? ");
INSERT INTO are_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Arai, rrangkarra angkama atha kula enka korna ntjarranha unpurlenama, Beelzebul-ala yinganha ekarltilakalanga. Ngunhalantama rrangkarranha ekarltilama enka korna etnanha unpurlenitjika? ");
INSERT INTO are_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Atha pula enka korna etnanha unpurlenamanga Altjirrala yinganha ekarltilakalanga, rrangkarra kaltja nitjika Altjirranha relha ingkarrakaka ntelalhamanga era Ingkartanamanga. ");
INSERT INTO are_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Arai, artwa ekarltala paka yultha ekuranha ntarntaramanga, errauwiala, yultha etna marra kuta iltha ekuranhala intitjina. ");
INSERT INTO are_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Thunga pula artwa ekarltalkura pitjima. Era erinha pmakwinama turta. Kurunga artwa ekarltalkura era kala errauwia ekuranha rakama, errauwia nhanga ekurakartala era tnakalhakala, era turta yultha ekuranha errarnpalhelama. ");
INSERT INTO are_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Relha erala itja tjina nuka nama, era kala leltja nuka nama. Relha erala itja nukalela porta urrkapuma, relhanha Altjirrurna rretjingitjika, era kala relha etnanha unpumala.” ");
INSERT INTO are_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Arai, enka korna paka relhanga rratamanga, era worritjala nthulapuma, pmaraka yonthamala. Pmaraka yarna yonthamala, enka korna era lakinha angkama, ‘Yinga alputjina, pmara yingala rratakala ekururna.’ ");
INSERT INTO are_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pmara ekururna pitjalpumala era arama relha era pmara erinha ilkngikala, intortilakala turta. ");
INSERT INTO are_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Erantama lhamala enka kornalkura 7 inarlalhama. Etnantama porta pmara intortilakala ekururna irrpuma, kuterrama turta. Relha erantama imampurlalkura nama arrkurlangatjina.” ");
INSERT INTO are_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesuanha nhanga angkamangantema, arrkutja nyinta, erala worla lenhala nakala, era ilkamala angkaka, “Altjirranha kunha mia ungkwanganhaka kangkintja kngarra ntelalhaka.” ");
INSERT INTO are_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesuanha pula angkaka, “Nthurrpa. Altjirranha pula relha lenha ntjarraka kngarralkura kangkintja ntelalhama, etnala Altjirraka Angkatja wumanga, ekura kangkwerramanga turta.” ");
INSERT INTO are_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Relha worla etna kngarrerramanga, Jesuala etnanha ilaka, “Relha lyartala namala ntjarrataka korna. Etna antja nama atha etnaka tjatjikarta alkirarinya ntelitjika. Atha pula etnanha itja kuta tjatjikarta ntelitjina, tjatjikarta nhanga Altjirralala Jonah-anha ntelakalanta wara. ");
INSERT INTO are_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonah-ala kunha relha Nineveh-arinya ntjarranha tjatjatuka. Lakinha ngerra Relhaka 'Lirala relha ntjarranha tjatjatumantema. ");
INSERT INTO are_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Altjirranha pitjimalanga relha ingkarrakanha tjiperrawutjika, relha Sheba-arinya ntjarraka queen-ala rrangkarranha ilparnitjina. Era kunha pmara ilanganga pitjikala King Solomon-anha wutjika, era inangkarla inthorra angkamanga. Lyarta pula artwa nyintala rrangkarranha kaltjinthama, erala Solomon-anga inangkarlalkura nama. ");
INSERT INTO are_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Relha Nineveh-arinya ntjarrala turta rrangkarranha ilparnitjina. Etna kunha toperraka Jonah-ala etnanha tjatjatumalanga. Lyarta pula artwa nyinta nhanhala nama erala rrangkarranha angkatja ekarltalkurala tjatjatuma.” ");
INSERT INTO are_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Relhala irna alknganthakanha etamanga, era erinha itja korltama. Era pula alkngantha erinha table-akatitja arrarnama, relha nhanga ilthaka irrpentjimalanga etna parrtja erinha aritjinanga. ");
INSERT INTO are_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Unta paka kangkamanga relha arratja ntelalhamanga, kurunga unta turta arratja eterritjina. Unta pula kangkamanga relha korna ntelalhamanga, kurunga unta turta kornaka lherritjina. Kurunga unta turtantama korna kuta ntelalhitjina. ");
INSERT INTO are_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Untantama aralhai, unta thakerrakitja relhanha aritjika era korna ntelalhamanga. ");
INSERT INTO are_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Unta pula thakerramanga relhanha aritjika era arratja ntelalhamanga, kurunga unta turta arratja eterritjina, arratja ntelalhitjina.” ");
INSERT INTO are_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesuanha angkamalangantema, artwa Pharisee-ala erinha iltha ekuranhurna ntangkaka, marnaka. Ilthaka irrpunhamala, Jesuanha kala marnaka arrarnalhakanta. ");
INSERT INTO are_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nhanha aramala artwa Pharisee era tnolkaka, Jesuanha itja iltja ilkngilhakalangarrka, marna ilkutjinala. ");
INSERT INTO are_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ingkartalantama erinha ilaka, “Artwa Pharisee rrangkarrataka mpurrka rrakangkarranhanta ilkngima, nhanga relhalala tjampita, plate ekuranha turta ilkngima. Kanha eterrintja rrakangkarranha korna kutala nama. Rrangkarra yulthalka nyilkngala initjika kuta lherrama. ");
INSERT INTO are_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Rirta ntjarrai. Altjirrala kunha relhaka eterrintja turta arrpmarnaka, itja mpurrkanta. ");
INSERT INTO are_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Rrangkarra relha ilkngara ntjarraka kangkintja ntelalhai, kurunga rrangkarra kala Altjirranga urlarra arratja ntelalhitjina. ");
INSERT INTO are_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Artwa Pharisee ntjarrai, rrangkarrataka imampurla kngarra nitjina. Rrangkarra kunha ngkulpalka, paraltjalka Altjirranha tjauwerrilya nthama. Kanha relhaka arratja ntelalhitjika, Altjirraka kangkitjika turta, itjala. Arai, rrakangkarrathaka nama relhaka arratja ntelalhitjika, Altjirraka kangkitjika, tjauwerrilya turta kuta arratjantema nthitjika. ");
INSERT INTO are_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Artwa Pharisee ntjarrai, rrangkarrataka imampurla kngarra nitjina. Rrangkarra synagogue-urna lhamanga, rrangkarra antja nama arrkurla inthorrala arrarnalhitjika. Rrangkarra paka shopping-aka lhamanga, rrangkarra antja nama relha ntjarrala rrangkarranha ‘Rabbi’ anparnitjika. ");
INSERT INTO are_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Arai, rrangkarrataka imampurla kngarra nitjina. Rrangkarra kunha wolknga ntjarra ngerra nama, wolknga nhanga relhala lauwukala ngerrakwia. Relha arrpunha ntjarrantama wolknga etnakanga kartnala ingka lhama, kotna warta.” ");
INSERT INTO are_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Artwa Intarrangaltha nyintalantama Jesuanha ilaka, “Kaltjinthanhinthanhai, lakinha angkamalataka unta nurnanha arrampowuma.” ");
INSERT INTO are_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesuala pula erinha ilaka, “Artwa Intarrangaltha ntjarrai, rrangkarra turta imampurla kngarra nitjina. Rrangkarra kunha relha ntjarranha rrothama inthorra. Rrangkarra turta etnaka itja kurrka rukarilama paka. ");
INSERT INTO are_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Rrakangkarra nthurrpa imampurla nitjina. Errilkngipata rrakangkarranhala Altjirraka urrpia ntjarranha errilknga tuka. Rrangkarrantama urrpia etnaka ilpangkintjaka parta ingkairnama, wolknga etnakanhaka. ");
INSERT INTO are_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ilpangkintjaka parta etnanha ingkairnamala, rrangkarra ntelama rrangkarra turta kangkamanga errilkngipata rrakangkarranhala urrpia etnanha imanka errilknga tukala. ");
INSERT INTO are_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Altjirra kaltja era angkama, ‘Atha urrpia pa apostle arrpunha ntjarra etnakurna yairnitjina. Urrpia nhanha etnakanga, rrangkarra arrpunha ntjarranha errilknga tutjina, arrpunha ntjarranha kornilitjika lurnitjina.’ ");
INSERT INTO are_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Lakinhanga, relha lyarta namala ntjarrai, rrangkarrantama ilkarrtjerritjina urrpia ingkarrakaka, etnanhala errilkngipata ntjarrala errilknga tukala. Altjirrala rrangkarranhantama rrarrathala tutjina ingkarraka etnakakwia. ");
INSERT INTO are_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Urrpia ingkarraka etnaka purrama, etnala Abel-angatjina Zechariah-aka arltalpula ilukala. Zechariah erinha kunha etna altar-anga, temple-anga mpopaka errilknga tukala. Athantama rrangkarranha nhanha arratja ilama, Altjirrala rrangkarranhantama rrarrathala tutjina ingkarraka etnakakwia. ");
INSERT INTO are_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Artwa Intarrangaltha ntjarrai, rrangkarra imampurla kngarra nitjina. Rrangkarra kala Altjirraka Angkatja wuma, rrangkarra pula Altjirraka Angkatja paala nentilama. Lakinhanga rrangkarrarrpa itja lhangkarama Altjirranha kala pitjikala relha ingkarrakaka Ingkarta nitjika. Rrangkarra turta relha ntjarranha parrpartilama. Etna turtantama nhanha itja lhangkarama.” ");
INSERT INTO are_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Artwa Intarrangaltha ntjarra, artwa Pharisee ntjarra turtantama Jesuaka yirrknga inthorrerraka. Etnantama Jesuanha kngarra inthorra pmarraka. ");
INSERT INTO are_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kurunga etna erinha montjala wurlanaka, era paka paala angkitjinanga. ");
INSERT INTO are_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Relha ntjarra inthorrantama Jesuurna worlerrentjalpuka. Etna turtantama ingka rrotherraka, Jesuurna etinyerritjikerramala. Jesualantama kurtungurla ekuranha ntjarranha ilaka, worla kngarra etna erinha wurlanamalanga, “Rrangkarrataka artwa Pharisee ntjarranga aralhitjika. Etnataka paala kaltjinthama. ");
INSERT INTO are_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Arai, yia nhanga relhalala korltakala, nhanha anma kathilitjina. Yia nhanga relhalala lauwukala, nhanha kala relha ingkarrakanha alpmelitjina. ");
INSERT INTO are_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yia nhanga rrangkarrala ingwala ilarrakala, nhanha arrpunha ntjarrala arltalala wutjina. Angkatja nhanga rrangkarrala nyilknganyilkngala angkarrakala, nhanha arrpunha ntjarranha katha inthorra wutjina.” ");
INSERT INTO are_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Tjina nukanha ntjarrai, atha rrangkarranha ilama rrangkarra itja relhanga trerritjika. Relhala kunha mpurrkanta irrpalthala errilknga tuma. ");
INSERT INTO are_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Rrangkarra Altjirrangatitja trerritjika. Era kunha relhanha tatharrurna turta irrpalthala iwuma, itja errilknganta tuma. Nthurrpa, rrangkarrataka Altjirranga trerritjika. ");
INSERT INTO are_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Relhala kunha nyenka 5 yirrinthama money kurrka tharraka. Altjirranha pula itja nyenka nyintaka kngwerrama. ");
INSERT INTO are_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kapurta ponga nthakintja paka rrakangkarra nama? Altjirranha kala kaltja. Lakinhanga rrangkarra itja trerritjika. Altjirranga urlarra rrangkarra tjiparralkura nama nyenka ntjarrangatjina.” ");
INSERT INTO are_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Atha rrangkarranha ilama, relha erala relha ntjarranga urlarra angkama era tjina nukanha namanga, Relhaka 'Lirala Altjirraka angel ntjarranha alkngatharra ilitjina, era tjina ekuranha namanga. ");
INSERT INTO are_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Relha era pula, erala relha ntjarranga urlarra angkama era nuka antjakunya, Relhaka 'Lirala Altjirraka angel ntjarranha ilitjina era ekura antjakunya namanga. ");
INSERT INTO are_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Relha erala Relhaka 'Liriperra korna angkama, Altjirrala kala korna ekuranha iwutjina, era Altjirrurna toperramanga. Relhala pula Enka Alkngaltaranha arrampowumanga, Altjirrala korna ekuranha itja kutala iwutjina. ");
INSERT INTO are_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Thunga etna rrangkarranha synagogue-urna kngitjina, tjitjarturna paka, itornkurna paka, rrangkarranha ilparnitjika. Rrangkarra itja thakerramala eterritjika, ‘Nthakinhama, iwunha turtama nurna angkitjina?’ ");
INSERT INTO are_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Arai, etna rrangkarranha ilparnamalangantema, Enka Alkngaltarala kala rrangkarranha ilitjina angkatja nhanga rrangkarrala etnanha ilitjika.” ");
INSERT INTO are_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Relha worla kngarra naka. Artwa arrpunhantama Jesuurna angkaka, “Kaltjinthanhinthanhai, kalya nukanhalataka kaarta ilirnakanhaka yultha ingkarraka tnyinama. Erinha ilai era yinganha karta arrpunha nthitjika.” ");
INSERT INTO are_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesuala pula erinha ilaka, “Artwai, etna yinganha itjama ingkairnaka yultha errarnpalhelitjika.” ");
INSERT INTO are_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jesualantama relha ntjarranha ilaka, “Rrangkarrataka aralhitjika, ntarntaralhitjika turta rrangkarra yulthaka lherrakitja. Relha itjama ngampakala etatha nitjina, ekura yultha kngarra intamanga.” ");
INSERT INTO are_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jesualantama etnaka yia nhanha alpmelaka. “Artwa netaneta naka. Tnukulpa ekuranhala marna kngarra inthorra mangkaka. ");
INSERT INTO are_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Artwa erantama eterraka, ‘Nuka kunha marna kngarra inthorra. Kanha marnakanha iltha nukanha urrputja inthorrarrpala.’ ");
INSERT INTO are_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Kuta eterramala, era kala lakinhantama angkaka, ‘Atha marnakanha iltha nukanha taakitjina, marnakanha iltha kngarritjalkura ntjarra turtantama ititjina. Athantama marna pa yultha nukanha ingkarraka iltha kngarritja etnaka arrarnitjina. ");
INSERT INTO are_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kurunga yinga ilalhitjina, “Artwai, ungkwanga kunha marnalka kngarra inthorra intama. Kala iltjerrai, ilkwai, ntjwai, arrkana turta nai.’” ");
INSERT INTO are_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Altjirrala pula erinha ilaka, ‘Artwai untataka rirta. Arai, ingwa lyartantema unta ilutjina. Nthakinhantama marnalka, yulthalka ungkwanganhala nganha tangkalhelitjina?’ ");
INSERT INTO are_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Lakinha kunha relha nyintaminyinta nitjina, erala yulthanta kngarra patilamanga, era pula Altjirranha itja etarlarama.” ");
INSERT INTO are_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesualantama kurtungurla ekuranha ntjarranha ilaka, “Lakinhanga atha rrangkarranha ilama, rrangkarra itja kngarra inthorra etarlaritjika, Iwunhama nurna ilkutjina? Iwunhakama nurna ekarralhitjina? ");
INSERT INTO are_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Arai, Altjirrala nurnanha arrpmarnaka itja marnakanta thakerritjika, mantarrakanta turta. ");
INSERT INTO are_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ngapa ntjarranha rrangkarra etarlarama? Etna itjama annga ingkairnama. Etna turta itja marna annga kotjima. Etna itja marna ilthaka patilama. Kanha Altjirrala etnanha kalantemala ntuthilama. Rrangkarra kunha thepa etnakanga tjiparralkura nama. ");
INSERT INTO are_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Rrakangkarranga nyinta paka kutalkura etatha nitjina, kngarra etarlaramala? Itja kunha. ");
INSERT INTO are_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Rrangkarrataka yarna kurrka wara wotha etatha nama, thakerramala. Iwunhangantama rrangkarra marnakalka, mantarrakalka kngarra thakerrama? ");
INSERT INTO are_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Antatha etnanha kathala mangkamanga arai. Etna itja urrkapuma, mantarra paka etnakiltja thanthama. Atha pula rrangkarranha nthurrpa ilama, King Solomon erala mantarra ntjatjintja inthorraka ekarralhakala, era antatha nhanha ntjarranga urlarra alkumpa wara naka. ");
INSERT INTO are_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Altjirrala antatha etnanha lantjalantja inthorra arrpmarnaka. Antatha etna pula kurrka wara namala, kala ntjirrkerramantama. Kurunga relhala etnanha uraka iwuma. Rrangkarrataka Altjirranha kurrka wararrpa tnakama. Altjirranga urlarra rrangkarra tjiparralkura nama antathangatjina. Era kala rrangkarranha mantarra marra nthitjina, ekarralhitjika. ");
INSERT INTO are_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Rrangkarrantama itja kngarra etarlaritjika, Iwunhama nurna ilkutjina? Iwunhama nurna ntjutjina? Rrangkarra turta itja marnakalka thakerritjika. ");
INSERT INTO are_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Arai, relha ingkarrakalataka marnakalka kuta yonthama. Kaarta rrakangkarra pula kala kaltja rrangkarra yarna marnakunya, kwatjakunya, mantarrakunya paka nama. ");
INSERT INTO are_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Rrangkarra pula Altjirrurna ingkitjika era relha ingkarrakaka ntelalhitjika era Ingkartanamanga. Erantama marnalka, mantarralka rrangkarranha nthitjinantema.” ");
INSERT INTO are_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Tjina nukanha ntjarrai, rrangkarra kunha urrputja wara nama. Rrangkarra pula itja trerritjika, Kaarta rrakangkarranha antja namanga warta rrangkarranha pmara ngampakala ekuranhurna rretjingitjika. ");
INSERT INTO are_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yultha rrakangkarranha yirrintharrirrai, kurunga money erinha relha ilkngara ntjarranha ntharrirrai. Thauwa arrpunha ngerra rrakangkarra mpaararrirrai, nhanhatitja, alkiralatitja rrakangkarra yultha patilarrirrai. Alkirala kunha nyilkngampa itja nama yultha nyilkngala initjika. Intarrka turta itja nama yultha kornilitjika. ");
INSERT INTO are_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Arai, pmara nthanhala yultha rrakangkarra intamanga, pmara lenhaka kunha rrangkarra kngarralkura kangkitjina.” ");
INSERT INTO are_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Urrkapunhapunha ilporatha ntjarra kunha kaarra kuta kaaralhama, alknganthakarta, itornka etnakanha mpanyaka arrkananga pitjalputjika. Itornka etnakanhalantama reoa iltaratumanga, etna ekura kala reoa altjurilamanta. Rrangkarrataka etna ngerra nitjika. ");
INSERT INTO are_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Urrkapunhapunha lenha ntjarra kunha arrkana nitjina, itornka etnakanha pitjalpumala, etnanha kaarra kuta aritjalhamanga. Atha rrangkarranha nhanha nthurrpa inthorra ilama. Itornka era etnanha turnitjina, arrarnalhitjika. Kurunga erarrpa marnaka urrkaputjina, etnanha marna ilkutjika nthitjina turta. ");
INSERT INTO are_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nthurrpa urrkapunhapunha lenha ntjarra arrkana nitjina, itornka etnakanhala etnanha kaarra kuta aritjalhamanga, era ingwa mpopalalka pitjalpumanga, kala arlterritjikerramanga paka. ");
INSERT INTO are_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Etarlarai, ilthakurtwia era paka kaltja nakalanga ilangara inthorra nyilkngampa era pitjitjinala, era kala ekura kaaralhamara, erinha parritjika. ");
INSERT INTO are_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Rrangkarrantama kaarra nitjika, rrangkarra itja kaltjanga warta ilangara inthorra Relhaka 'Lira era pitjalputjinala.” ");
INSERT INTO are_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter-alantama Jesuanha pmarraka, “Unta yia nhanha nurnanhanta alpmelama? Relha ingkarrakanha paka?” ");
INSERT INTO are_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ingkartala erinha ilaka, “Ngunhama urrkapunhapunha ilporatha pa inangkarla era, erinhala itornka ekuranhala ingkairnitjinala urrkapunhapunha arrpunha ntjarranha marna etnakanha arratja kuta nthetnitjika? ");
INSERT INTO are_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pitjalpumala itornka era paka aramanga urrkapunhapunha era arratja urrkapumanga, era ekura kangkitjina. ");
INSERT INTO are_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Itornka ekuranhalantama erinha ingkairnitjina yultha ingkarraka ekuranha ntarntaritjika. ");
INSERT INTO are_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Thunga pula urrkapunhapunha era eterrama, ‘Itornka nukanhataka kuta inthorra yirrama.’ Erantama urrkapunhapunha arrpunha ntjarranha, artwa pa arrkutja, tuma. Erarrpa turta kngarra ilkuma pa ntjuma. Era drunk-errama turta. ");
INSERT INTO are_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kurunga arlta arrpunhala itornka ekuranha kala pitjalpitjinantama, urrkapunhapunha era eterramanga era kutantema yirritjinala. Itornka ekuranhala erinha kala tutjina, erinha iwutjina turta relha arrpunha ntjarralela nitjika, etnala Altjirranha itja tnakama. ");
INSERT INTO are_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Thunga itornkala urrkapunhapunha ekuranha urrkaputjika turnama. Urrkapunhapunha erantama itja kangkwerrama. Itornka ekuranhala erinha kngarra tutjina. ");
INSERT INTO are_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kanha urrkapunhapunha era, erala itja kaltja naka era urrkaputjika, era turtantama itja urrkapuka, erinha itornka ekuranhala kurrka warala tutjina. Thunga artwa netanetala artwa arrpunhanha money-alka waraka nthama. Anma era kala antja nitjina artwa arrpunha era erinha money-alka kngarralkura nthitjalputjika.” ");
INSERT INTO are_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Yinga pitjika alha nhanha urala etitjika ngerra. Ura erantama kala mpeikanhanta. ");
INSERT INTO are_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Arrkurla pula nukathaka nama kngarra nyingalauwutjika. Yingantama nhanha rwampia wulhama nyingalauwutjika kaaralhamala. ");
INSERT INTO are_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Thunga rrangkarra etarlarama yinga kula alha nhanhurna pitjikala relha ingkarrakanha rilherilitjika? Itja inthorra! Yinga pitjika relhanha tjalpalhelitjikatitja. ");
INSERT INTO are_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Thunga relha 5 iltha nyintala nama. Lyartanga tharraminyinta, tharra arrpunhaka leltja nitjina. Tharra eratharra turta tharraminyinta arrpunhaka leltja nitjina. ");
INSERT INTO are_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kaarta 'lira ekuranhaka leltja nitjina, 'lira era turta kaarta ekuranhaka. Mia era kwarra ekuranhaka leltja nitjina, kwarra era turta mia ekuranhaka. Mara era nharra ekuranhaka leltja nitjina, nharra era turta mara ekuranhaka.” ");
INSERT INTO are_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesuala relha worla kngarra etnanha turtantama ilaka, “Rrangkarra paka matara aramanga altorlala kamerramanga, rrangkarra angkama, ‘Kwatja ngkarla pitjimau!’ Kala lakinherrama turta. ");
INSERT INTO are_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wurinyala paka ntakarranga warnamanga, rrangkarra angkama, ‘Wumpierritjinau!’ Kala lakinherrama turta. ");
INSERT INTO are_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Relha marntilparla ntjarrai. Mataralka aramala rrangkarra kala lhangkarama kwatjala paka nhitjinala. Arai, atha kala tjatjikarta rrakangkarra urrkapuka. Rrangkarra pula etnanha itjala lhangkaraka. ");
INSERT INTO are_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Rrangkarra rirta ntjarrama? Rrangkarra itjala kaltja arratja ntelalhitjika? ");
INSERT INTO are_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Arai, thunga arrpunhala nganha court-urna kngama. Unta ekuralela rilhererrai mpala tharrantema court-urna lhamanga. Itjanga era nganha tjiperrawunhawunhanga urlarra ilparnitjina. Tjiperrawunhawunhalantama errkuntjanha turnitjina nganha jail-aka kurnitjika. ");
INSERT INTO are_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Arai, atha nganha ilama unta itja tanhanga rratitjina unta fine ingkarraka inthorra ungkwanganha pay-emilakalalpula.” ");
INSERT INTO are_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Artwa urrputjantama Jesuurna pitjika. Etna erinha ilaka Pilate-aka tjapartiala artwa Galilee-arinya urrputja arrpunha errilknga tukala, etna Altjirranha tjauwerrilya nthamalanga. ");
INSERT INTO are_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesualantama etnanha ilaka, “Thunga rrangkarra etarlarama artwa Galilee-arinya nhanha ntjarra kula kornalkura nakala, relha Galilee-arinya arrpunha ntjarrangatjina, tjapartiala etnanha errilknga tukalanga. ");
INSERT INTO are_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Itja inthorra! Rrangkarra pula nhanhaka kaltja nitjika. Rrangkarra paka itja Altjirrurna toperramanga, rrangkarra turta ilutjinantema. ");
INSERT INTO are_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Rrangkarra ilpangkamama relha 18 nhangaka, etnala Siloam-ala ilukala, irna kwatjakanha etnakarlaka tnyimalanga? Thunga rrangkarra etarlarama etna kula kornalkura nakala relha Jerusalem-arinya arrpunha ntjarrangatjina. ");
INSERT INTO are_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Itja inthorra! Rrangkarra pula nhanhaka kaltja nitjika. Rrangkarra itja Altjirrurna toperramanga, rrangkarra turta ilutjinantema.” ");
INSERT INTO are_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesuala etnanha yia nhanhantama alpmelaka. “Artwa nyintaka irna tjurrka mangkaka, grapes tnukulpa ekuranhala. Artwa erantama pitjika marna tjurrka kotjitjika. Irna era pula marnakunya naka. ");
INSERT INTO are_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Artwa erantama urrkapunhapunha ekuranha ilaka, ‘Arai, yinga kala 3 years-ntama marnaka pitjikala. Atha turta marnaka yarna kuta yonthaka. Kala irna tjurrka erinha inturnai, era palkala wara mangkamanga.’ ");
INSERT INTO are_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Urrkapunhapunha era pula angkaka, ‘Itornkai, irna erinha kala year nyinta wothakarrka impai. Atha arna urlpelamala kaarntakaarnta tnyatjinanga, erinha kwatja kngarralkura turta nthitjinanga. ");
INSERT INTO are_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Era paka tjurrka lhalhelamangantama, kala marra. Itjanga paka, atha erinha kala inturnitjikantama, untala yinganha turnakala ngerra.’” ");
INSERT INTO are_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabbath arlta arrpunhala Jesuala relha ntjarranha kaltjinthaka, synagogue-ala. ");
INSERT INTO are_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Synagogue ekurala arrkutja arrpunha naka, erala 18 years topa kornakarta nakala. Era yarna arratja itnaka. ");
INSERT INTO are_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Arrkutja erinha aramala, Jesuala erinha ntangkaka, erinha ilaka turta, “Arrkutjai, topa ungkwangataka kala marrerraka.” ");
INSERT INTO are_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesualantama iltja ekuranha ekurakarlaka arrarnaka. Arrkutja era kala arratjantama itnaka. Era Altjirranha tnantjaka turta. ");
INSERT INTO are_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Synagogue-aka itornka era pula yirrkngerraka Jesuala arrkutja erinha Sabbath arltala marrilakalanga. Erantama relha ntjarranha ilaka, “Arlta 6 kala nama relha urrkaputjika. Rrangkarra paka antja namanga Jesuala rrangkarranha marrilitjika, kala arlta 6 nhanha etnakanga pitjai, itja Sabbath arltala.” ");
INSERT INTO are_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ingkartala pula erinha ilaka, “Pmathai. Ungkwanga bullock paka namanga, donkey paka, unta kunha erinha Sabbath-ala turta ilumala kwatjurna rretjingama. ");
INSERT INTO are_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Arrkutja nhanha kunha Abraham-aka ramaramantema nama. Erinha Satan-ala 18 years-aka yirnakala. Nhanha kala arratja nama erinha Sabbath arltala turta kala marrilitjika.” ");
INSERT INTO are_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Angkatja nhanha wumala, relha Jesuaka antjakunya ntjarra errakarrerraka. Kanha relha arrpunha ntjarra arrkanala naka, Jesuanha makalaria inthorra ntelalhakalanga. ");
INSERT INTO are_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesuala etnanha pmarraka, “Nthakinhama relhala lhangkaramara Altjirranha kala relha ingkarrakaka Ingkarta nama? Nthakinha turtama atha nhanha rrakangkarra nentilamara? ");
INSERT INTO are_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nhanha kala lakinha ngerra nama. Artwala tjurrka annga tnukulpa ekuranhaka ingkairnama. Annga era mangkamala irna tjurrka kngarritja inthorrerrama. Thepa etna turtantama pitjima, antjwa etnakanha turta etintjala mpaarama.” ");
INSERT INTO are_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesuala etnanha wotha pmarraka, “Nthakinhama relhala lhangkaramara Altjirranha kala relha ingkarrakaka Ingkartanamanga? Nthakinha turtama atha nhanha rrakangkarra nentilamara? ");
INSERT INTO are_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nhanha kala lakinha ngerra nama. Arrkutjala marna ltorlpilanha kurrka wara marna kngarra inthorraka lhangama. Marna ltorlpilanha kurrka erantama marna urrknga kngarra erinha ltorlpilama, ntjapara kuta.” ");
INSERT INTO are_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesuanha Jerusalem-urna lhapalhamalanga, era relha ntjarranha town kurrka ntjarrala, town kngarra ntjarrala turta kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Relha nyintalantama erinha pmarraka, “Ingkartai, Altjirrala relha urrputja warama tangkalhelitjina?” Jesuala etnanha ilaka, ");
INSERT INTO are_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Rrangkarrataka thakerritjika reoa urlpma ekuranga irrputjika. Relha ntjarra thakerritjina reoa urlpma ekuranga irrputjika, etna pula yarna irrputjina. ");
INSERT INTO are_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Anma ilthakurtwia era kamerramala reoa erinha kala twantitjinantama. Rrangkarrantama kathalantema itnamanga, rrangkarra kathala kuta itnatjina. Rrangkarrantama reoa iltaratumala angkitjina, ‘Ingkartai, nurnaka altjurilai.’ “Era pula rrangkarranha ilitjina, ‘Yinga itjama rrakangkarra kaltja.’ ");
INSERT INTO are_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Kurunga rrangkarra angkitjina, ‘Nurna kunha ungkwangalela marnalka ilkuka, kwatjalka ntjuka. Unta turta nurnanha pmara nurnakanhala kaltjinthaka.’ ");
INSERT INTO are_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Era pula rrangkarranha ilitjina, ‘Yinga itja inthorrama rrakangkarra kaltja. Kala nukanga lhai! Rrangkarrataka relha kornanta ntjarra.’ ");
INSERT INTO are_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Altjirrala rrangkarranha kala kathurnantama yairnitjina. Rrangkarrantama Abraham-anha, Isaac-anha, Jacob-anha, Altjirraka urrpia ntjarranha turta aritjina Altjirraka pmara kutathala namanga. Kurunga rrangkarra itnitjina, mpangkitjina turta. ");
INSERT INTO are_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Relha kala ekngarranga, altorlanga, yirraranga, ntakarranga turta pitjitjina Altjirraka pmara kutathala tjinkarra ilkutjika. ");
INSERT INTO are_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Arai, relha ntjarra arrpunha etnala lyarta ingkarnerrama, etna anma arrkurlerritjina. Kanha relha ntjarra arrpunha etnala lyarta arrkurlerrama, etna anma ingkarnerritjinala.” ");
INSERT INTO are_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Artwa Pharisee urrputjantama Jesuurna pitjika. Etna erinha ilaka, “Kala pmara arrpunhurnanta lhai. Herod-anhataka antja nama nganha errilknga tutjika.” ");
INSERT INTO are_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesuala pula etnanha ilaka, “Rrangkarra artwa kngulya itnura ngerra nhanganha ilai, ‘Lyarta, inguntha turta, atha enka korna ntjarranha unpuma, relha ntjarranha marrilama turta. Kurunga arlta arrpunhala atha kala urrkapuntja nukanha mangkilitjinantama.’ ");
INSERT INTO are_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Lyartaka, ingunthaka, arlta arrpunhaka turta pula nukathaka nama latha lhitjikala. Etarlarai, Jerusalem-alanta kunha etna Altjirraka urrpia ntjarranha kutatha errilknga tuma.” ");
INSERT INTO are_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Relha Jerusalem-arinya ntjarrai, relha Jerusalem-arinya ntjarrai. Rrangkarra kunha Altjirraka urrpia ntjarranha errilknga tukala. Rrangkarra turta partala wakala arrpunha ntjarranha Altjirralala rrakangkarrurna yairnakala. Ntjarraranga yinga antja naka rrangkarranha worlilitjika, tjukatjuka marlalala kurrka ekuranha worlilamanga ngerra. Rrangkarra pula antjakunyala naka. ");
INSERT INTO are_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lyarta Altjirrala temple ekuranha impurlalhitjinantama. Yinganha turta rrangkarra itja wotha aritjina, anmanta rrangkarra angkamalanga, ‘Nurna erinha tnantjama, erala Ingkartaka rretnyala pitjimanga.’” ");
INSERT INTO are_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabbath arlta arrpunhala Jesuanha artwa Pharisee itornkaka ilthurna lhaka, marnaka. Relha ntjarralantama erinha montjala ararlanaka. ");
INSERT INTO are_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Artwa menta inthorrataka Jesuanga urlarra itnaka. ");
INSERT INTO are_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesualantama artwa Intarrangaltha ntjarranha, artwa Pharisee ntjarranha turta pmarraka, “Nhanha arratjama nama Sabbath arltala relha mentanha marrilitjika? Itjakwia?” ");
INSERT INTO are_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Etna pula pmarna kuta naka. Jesualantama artwa menta erinha anpumala marrilaka, yairnarlenaka turta. ");
INSERT INTO are_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kurunga era etnanha pmarraka, “Thunga worra ungkwanga paka, bullock ungkwanga paka ipartaka tnyima, Sabbath arltala. Unta kunha erinha Sabbath arltalantema parrpa urlpuntjima.” ");
INSERT INTO are_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Etnantama yarna angkitjikerraka. ");
INSERT INTO are_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesuala araka relha marnaka ntangkakala ntjarra katha marralkuraka arrarnalhamanga. Erantama etnanha yia nhanha alpmelaka. ");
INSERT INTO are_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Arai, thunga artwala nganha mpanyaka tjinkarraka ntangkama. Unta itja katha marralkuraka arrarnalhitjika. Itornka kngarra turta paka pitjakitja. ");
INSERT INTO are_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kurunga artwa erala nganha tjinkarraka ntangkakala, era ungkwangurna pitjimala, nganha ilakitja, ‘Katha nhanhanga lhai, itornka nhanha arrarnalhitjinanga.’ Kurunga unta errakarrerramala katha kornakornakantama arrarnalhakitja. ");
INSERT INTO are_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Lakinhatitja. Unta tjinkarraka pitjimalanga, katha kornakornaka arrarnalhai. Kurunga artwa erala nganha ntangkakala, era nganha ilitjinanga, ‘Tjinai, katha marralkurala nitjika pitjai.’ Arrpunha ntjarrala nhanha aramala, etna nganha kala tnantjitjina. ");
INSERT INTO are_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Arai, relha erala Altjirranga urlarra tnakalhama, erinha Altjirrala ipmintja iwutjina. Kanha relha erala Altjirranga urlarra porapora ntelalhama, erinha Altjirrala tnyinitjina kuta.” ");
INSERT INTO are_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesuanhantama artwa Pharisee ekururna angkaka, erala erinha nhanga marnaka ntangkakala, “Arai, unta paka tjinkarra urrkapumanga, unta itja tjina ungkwanganha ntjarranha, tjia ungkwanganha ntjarranha, tjina netaneta ungkwanganha ntjarranha turta marnaka ntangkitjika. Unta etnanha ntangkamanga, etna nganha kapanha marnaka ntangkitjinantema. ");
INSERT INTO are_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Unta pula tjinkarra urrkapumanga, relha ilkngara ntjarranha, iltja korna ntjarranha, inurra ntjarranha, panga ntjarranha turta ntangkai. ");
INSERT INTO are_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Etnaka itja intama nganha kapanha marnaka ntangkitjika. Altjirrala pula nganha kwartiwutjina era anma relha arratja ntjarranha kamalhelamanga.” ");
INSERT INTO are_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesuanha kala tjukunyerrakalangantama, artwa arrpunhantama angkaka. Artwa erataka marnakantema pitjikala. Era lakinha angkaka, “Nthurrpa relha era arrkana nama, erala anma Altjirraka pmara kutathala marna ilkutjina.” ");
INSERT INTO are_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesuala erinha ilaka, “Artwa nyintala tjinkarra kngarra urrkapuka, era turta relha arrpunha ntjarranha mparrama kuta ilaka era etnanha tjinkarraka ntangkitjinala. ");
INSERT INTO are_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Marnalka, karalka ingkarraka kala etakalangantama, era urrkapunhapunha ekuranha yairnaka relha nhanha etnanha ilitjika, ‘Pitjai, marnalka ingkarraka kala nama.’ ");
INSERT INTO are_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Relha etna pula itja antja naka pitjitjika. Nyinta angkaka, ‘Arai, athataka tnukulpa buy-emilaka. Yinga nhanha lhama tnukulpa erinha aritjika. Yinganha anmakarrka impai.’ ");
INSERT INTO are_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Arrpunha angkaka, ‘Atha kunha bullock errkurrintja 5 buy-emilaka. Yingantama nhanha lhama etnanha arrkarnitjika. Yinganha anmakarrka impai.’ ");
INSERT INTO are_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Kanha arrpunha lakinhala angkaka, ‘Atha kunha lyarta noa eknguka. Yingantama yarna lhama.’ ");
INSERT INTO are_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Urrkapunhapunha era nhanha itornka ekuranhaka ilitjalpuka. Aalerramala, itornka era urrkapunhapunha ekuranha ilaka, ‘Parrpa tjaiya kngarra ntjarrurna, tjaiya kurrka ntjarrurna turta lhai, town kngarritja nhanhala. Untantama relha ilkngara ntjarranha, iltja korna ntjarranha, panga ntjarranha, inurra ntjarranha turta nhanhurna kngitjai.’ ");
INSERT INTO are_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Urrkapunhapunha era lhaka. Pitjalpumala era itornka ekuranha ilaka, ‘Atha kala relha nhanha etnanha kngitjika, untala yinganha turnakala ngerra. Katha pula iltha ungkwanganhala namantema.’ ");
INSERT INTO are_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Itornka ekuranhalantama erinha ilaka, ‘Town-anga rratamala, kathurna lhai. Relha ntjarraka yonthai, etnanha turta kala iltha nukanhurna kngitjantai, kala relha kngarra iltha nukanhala nitjinanga. ");
INSERT INTO are_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Atha nganha arratja ilama. Relha athala arrkurla nganha ntangkakala, etnakanga itja nyintala tjinkarra nukanhanga marna kurrka paka ilkutjina.’” ");
INSERT INTO are_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Relha worla kngarra kuta Jesuanga tnaartangala lhaka, era nhanga Jerusalem-urna lhamalanga. Erantama etnanha ilaka, ");
INSERT INTO are_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Relha erala kurtungurla nuka nitjika antja, era kala nuka kngarralkura kangkitjika. Era nuka kngarralkura kangkitjika, kaarta ekuranhangatjina, mia ekuranhangatjina, noa ekuranhangatjina, katjia ekuranhangatjina, kalya ekuranhangatjina, kwaiya ekuranhangatjina, tjia ekuranhangatjina. ");
INSERT INTO are_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Relha erala kurtungurla nuka nitjika antja, era kala ntolka ekuranha kngarnitjika, nukanga tnaartangala pitjitjika turta. ");
INSERT INTO are_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Thunga rrakangkarranga arrpunhala iltha kngarritja ititjika antja nama. Era kunha arrkurla pmarralhama ekura paka money intamanga iltha erinha ititjika, itja tjontitjikanta. ");
INSERT INTO are_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Itjanga paka, era iltha erinha itarlanamangantema money ekura yirrakitja. Kurunga arrpunha ntjarrala nhanha aramala erinha arrampowukitja, ");
INSERT INTO are_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","lakinha angkamala, ‘Era iltha kngarritja ititjika tjontaka, era pula nhanha yarna mangkilaka.’ ");
INSERT INTO are_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Thunga king nyinta king arrpunhalela turritjika antja. Ekura pula tjapartia 10,000 wara nama. Kanha king arrpunha ekura tjapartia 20,000-ala nama. King tjapartia 10,000-akarta era arrkurla pmarralhitjika era paka king tjapartia 20,000-akartanha irrpalthala pmakwinamara. ");
INSERT INTO are_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Itjanga paka, era itja ekuralela turritjina. Era urrpiatitja ekururna yairnitjina, ekuralela rilhererritjina turta.” ");
INSERT INTO are_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jesuala etnanha ilaka, “Relha erala antja nama kurtungurla nuka nitjika, era kala yultha ingkarraka ekuranha ipmintja imputjika.” ");
INSERT INTO are_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Peinta kunha marra. Peinta era pula kornerrakalanga, relhala erinha yarna wotha marrilama. ");
INSERT INTO are_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Era kala ipmintja nama. Relhala erinha kala iwumanta. Ungkwanga ilpa paka intamanga, yinganha wurlathanai.” ");
INSERT INTO are_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Arrpunharanga artwa tax money kotjinha ntjarra, relha kornarintja arrpunha ntjarra turta Jesuurna pitjika, erinha wutjika. ");
INSERT INTO are_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Artwa Pharisee ntjarra, artwa Intarrangaltha ntjarra turta pula kngarra wannga angkaka. “Artwa nhanhataka relha kornarintja ntjarrakarrpa tjina kngarra ntelalhama, era turta etnakalela marna ilkuma.” ");
INSERT INTO are_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesualantama etnanha yia nhanha alpmelaka. ");
INSERT INTO are_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Arai, thunga ungkwanga 100 sheep intama. Sheep nyinta turtantama pairlperrama. Unta kunha 99 etnanha kathaka impurlalhama. Untantama sheep nyinta ekura yonthama unta erinha arltaritjinalpula. ");
INSERT INTO are_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sheep erinha arltaramala, unta kangkama inthorra. Untantama erinha parlapaka tjurnamala ");
INSERT INTO are_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","wotha worlurna kngetnama. Kurunga pmarurna alpumala, unta tjina ungkwanganha ntjarranha, relha pmararinya arrpunha ntjarranha turta worlilamala ilama, ‘Atha sheep pairlperrakala nukanha arltaraka. Nurna arrkana niai.’ ");
INSERT INTO are_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jesuala etnanha ilaka, “Lakinha ngerra alkirarinya ntjarra arrkanalkura nama relha nyintaka, erala Altjirrurna toperramanga, 99 arrpunhangatjina, etnakathaka itja namanga Altjirrurna toperritjika, etna kala Altjirranga urlarra arratja namanga.” ");
INSERT INTO are_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Yia arrpunha nhanha turta wai. Thunga arrkutjaka money tjiparra 10 intama. Erantama money nyinta pairlpilama. Era kunha irna alknganthakanha ekuranha etama. Erantama iltha ekuranha ilkngima. Era turta money ekura montjala yonthama, era erinha arltaritjinalpula. ");
INSERT INTO are_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Erantama money erinha arltarakalanga, era arrkutja tjina ekuranha ntjarranha, arrkutja pmararinya arrpunha ntjarranha turta ntangkama. Era etnanha ilama, ‘Yinga arrkana inthorra nama. Money nhanga athala pairlpilakala, atha wotha arltaraka. Nukalela arrkana nai!’ ");
INSERT INTO are_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jesuala etnanha ilaka, “Lakinha ngerra Altjirraka angel ntjarra arrkana nama relha kornarintja nyintaka, erala Altjirrurna toperramanga.” ");
INSERT INTO are_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesuala yia nhanha turtantama etnanha alpmelaka, “Artwa arrpunhaka worra tharra naka. ");
INSERT INTO are_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Worra ingkarninya erantama kaarta ekuranhaka enkaka, ‘Kaartai, yultha athala initjinala unta ilumanga, yultha lenha yinganha kala lyarta nthalathanai.’ Artwa erantama yultha ekuranha, worra ekuranha tharraka errarnpalhelaka. ");
INSERT INTO are_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Kala arlta arrpunhalantama, worra ingkarninya era yultha ekuranhakarta tjaiyakerraka. Erantama ilanga lhaka, pmara arrpunhurna. Tanhala era yultha ekuranha parrpa yirralhelaka, ngkwarla kngarra ntjumala, kwarra ntjarranhalka lurnamala. ");
INSERT INTO are_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Era yultha ekuranha kala yirralhelakalangantama, marnaka paalerrintja pmara tanhala naka. Era turtantama marnaka paalerraka. ");
INSERT INTO are_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","“Artwa arrpunhaka pig ntjarra naka. Worra erantama ekururna lhamala ingkaka, ‘Yinga antja nama pig ungkwanganha ntarntaritjika.’ Artwa erantama erinha yairnaka pig ekuranha ntjarranha ntarntaritjika. ");
INSERT INTO are_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ngaiyala inthorra namala, era kala pig ntjarraka marna ilkutjika antja naka. Relha nyintala pula erinha itja marna ilkutjika nthaka. ");
INSERT INTO are_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Alkngampumalantama era eterraka, ‘Kaarta nukanhaka urrkapunhapunha ntjarrala pula marna rontha kuta ilkurlanama, kanha yinga nhanha ilutjikerrama, marna itjanga. ");
INSERT INTO are_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yinga kala kamerramala kaarta nukanhurna alputjinanta. Yinga ekura ilalhitjina, “Kaartai, yinga Altjirranga urlarra korna ntelalhaka, ungkwanganga urlarra turta. ");
INSERT INTO are_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yinga itja worra ungkwanganha ngerra ntelalhaka. Lakinhanga unta yinganha itja wotha 'lira anparnitjika. Yinga kala urrkapunhapunha ungkwangantantama niai.’” ");
INSERT INTO are_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Erantama kamerramala, kala kaarta ekuranhurna alpuka. Era pula tjathantema namalanga, kaarta ekuranhala erinha araka. Erantama ekururna arrtjanaka, era ekura kngarra kuta kangkamanga warta. Era erinha kwakitjakaka, erinha rrontjaka turta. ");
INSERT INTO are_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Worra erantama angkaka, ‘Kaartai, yinga Altjirranga urlarra korna ntelalhaka, ungkwanganga urlarra turta. Yinga itja worra ungkwanganha ngerra ntelalhaka. Lakinhanga unta yinganha itja wotha 'lira anparnitjika.’ ");
INSERT INTO are_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Kaarta era pula urrkapunhapunha ekuranha ntjarraka ntangkalhamala, etnanha turnaka, ‘Parrpa, mantarra marra inthorra inarlalhai, ekura ekarrai turta. Ring turta iltja ekuranhaka kngitjai, sandal turta ingka ekuranhaka. ");
INSERT INTO are_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kurunga rrangkarra bullock ntira kngarra nhanga turlalpai, nurna tjinkarra ilkutjinanga, arrkanerritjinanga turta. ");
INSERT INTO are_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Arai, worra nuka, erala errilknga ngerra nakala, era lyarta wotha etatha nama. Worra nuka, erala pairlperrakala, era wotha nurnakurna pitjalpuka.’ Tjinkarra erinha urrkapumala, etna kala arrkanerraka. ");
INSERT INTO are_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kalya ekura tnukulpala urrkapumala naka. Ngurrangurra ilthurna pitjalpumalantama, era etinyerramala etnanha wuka lyilhamanga, nthaperramanga turta. ");
INSERT INTO are_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Erantama urrkapunhapunha nyintaka ntangkalhaka, erinha pmarraka turta, ‘Nthakinherramai?’ ");
INSERT INTO are_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Urrkapunhapunha era erinha ilaka, ‘Tjia ungkwanga kunha pitjalpuka. Kaarta ungkwanganhalantama bullock ntira kngarra nhanga tuka, tjinkarra turta urrkapuka, era erinha etatha initjalpukalanga.’ ");
INSERT INTO are_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nhanha wumala kalya era yirrknga inthorrerraka. Erantama itja kuta ilthurna irrpuka, kathala pula narlanaka. “Kaarta ekuranhantama ekururna rrataka. Era ekururna intarra inthorra ingkaka era kwana irrpentjitjika. ");
INSERT INTO are_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Era pula kaarta ekuranha ilaka, ‘Arai, yinga ungkwanga kuta urrkapuka, ungkwanga arratja kangkwerraka turta. Unta pula yinganha itja billy goat kurrka nyinta paka nthaka, yinga tjina nukanha ntjarralela arrkanerritjika, tjinkarra ilkumala. ");
INSERT INTO are_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kanha worra arrpunha nhanhala yultha ungkwanganha yirralhelakala kwarra ntjarranha lurnamala. Erantama pitjalpuka. Ekurantama unta bullock ntira kngarra erinha tuka.’ ");
INSERT INTO are_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Kaarta ekuranhala pula erinha ilaka, ‘Worra nukai, unta kunha kutatha nukalela nama. Yultha ingkarraka nukanha turta kala ungkwanga nama. ");
INSERT INTO are_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nurnakathaka pula nama tjia ungkwanganhaka kangkintja ntelalhitjika, ekuralela arrkanerritjika turta. Era errilknga ngerra nakalangakwia, lyarta pula era wotha nurnakalela nama. Era nhanga pairlperrakalakwia, lyarta pula era wotha nurnakurna pitjalpukala.’” ");
INSERT INTO are_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesuala kurtungurla ekuranha ntjarranha yia nhanha turta alpmelaka. “Artwa netanetala urrkapunhapunha arrpunha urrarakala yultha ekuranha ingkarraka ntarntaritjika. Anma, relha arrpunha ntjarrala artwa netaneta erinha alpmelaka urrkapunhapunha nhanha era yultha ekuranha itja arratja ntarntaramanga. ");
INSERT INTO are_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Artwa netaneta erantama urrkapunhapunha nhanha ekura ntangkalhaka. Era erinha ilaka, ‘Athataka yia korna ungkwangiperra wuma. Yultha nukanha unta nthakinhamilaka? Kala nhanha ingkarraka pepaka intalhelai. Lyarta atha nganha kala unputjinantama.’ ");
INSERT INTO are_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Urrkapunhapunha nhanha erantama eterraka. ‘Yinga nthakinhamerritjina? Itornka nukanhala kunha yinganha unputjina. Atha yarna iparta tnyama, yinga relha thaltjanga warta. Yinga turta errakarrerrama marnaka enkitjika. ");
INSERT INTO are_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yinga antja nama relha arrpunhalantama yinganha ntarntaritjika, itornka nukanhala yinganha unpumalanga.’ ");
INSERT INTO are_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Urrkapunhapunha erantama artwa lenha ntjarraka ntangkalhaka, etnala itornka ekuranha yulthalka owe-emilamanga. Erantama artwa nyintanha pmarraka, ‘Nthakintjama unta itornka nukanha owe-emilama?’ ");
INSERT INTO are_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Artwa era erinha alpmelaka, ‘100 jar oil-akarta.’ “Urrkapunhapunha era erinha ilaka, ‘Pepa ungkwanganha inamala parrpa intalhelai 50.’ ");
INSERT INTO are_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kurunga urrkapunhapunha era artwa arrpunhanhantama pmarraka, ‘Untaloa? Unta itornka nukanha nthakintjala owe-emilama?’ “Era erinha alpmelaka, ‘100 bag wheat-akarta.’ “Urrkapunhapunha era erinha ilaka, ‘Pepa ungkwanganha inamala parrpa intalhelai 80.’ ");
INSERT INTO are_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Itornka erantama urrkapunhapunha korna erinha tnantjaka, era inangkarla ntelalhakalanga. Arai, relha etnala Altjirraka itja eterrama, etnataka urrkapuma tjinalka, yulthalka etnaka anmaka intitjinanga. Kanha relha etnala Altjirraka eterrama, etnakanga arrpunha ntjarra itjala urrkapuma tjinalka, yulthalka etnaka anmaka intitjinanga, alkirala. ");
INSERT INTO are_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Atha rrangkarranha nhanha turta ilama. Thunga rrakangkarra money intama. Kala relha arrpunha ntjarraka tangitjala nai, etnanha tjinilamala. Kurunga money era yirrakalanga, rrangkarra turta ilukalanga, Altjirrala rrangkarranha pmara kutatha ekuranhurna irrpulhelitjinanga. ");
INSERT INTO are_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Arai, relha erala yultha urrputja irrpalthala arratja ntarntarama, era kala yultha kngarra turta irrpalthala arratja ntarntaritjina. Kanha relha erala yultha urrputja yarna arratja ntarntarama, era turta yultha kngarra yarna arratja ntarntaritjina. ");
INSERT INTO are_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Rrangkarra paka relhaka yultha yarna arratja ntarntaramanga, rrangkarra Altjirraka yultha turta yarna arratja ntarntaritjina. ");
INSERT INTO are_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Altjirrala rrangkarranha itja yultha ekuranha nthitjina, rrangkarra ntarntaritjika, rrangkarra relha arrpunhaka yultha itja arratja ntarntarakalanga. ");
INSERT INTO are_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Relha urrkapunhapunha yarna itornka tharraka kangkwerrama. Era paka nyintaka kangkamanga, era kala arrpunhaka antjakunyerritjina. Era paka nyintaka kangkwerramanga, era kala arrpunhanga unpulhitjina. Arai, rrangkarra yarna Altjirraka kangkama, yulthaka turta loala kuta.” ");
INSERT INTO are_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Artwa Pharisee ntjarrataka money-aka kngarra kangkaka. Etna Jesuaka angkatja wumalanga, etna erinha arrampowuka. ");
INSERT INTO are_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesuala pula etnanha ilaka, “Rrangkarra kunha etarlarama rrangkarra kula arratja inthorra ntelalhamanga. Altjirranha pula eterrintja rrakangkarranhaka kaltja kuta. Arai, relhala etarlarama rrangkarra kula arratja inthorra ntelalhamanga. Altjirranha pula kaltja rrangkarra paala ntelalhamanga, eterrintja rrakangkarra korna kutanga warta.” ");
INSERT INTO are_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Imanka Altjirranha relha ntjarrurna angkaka turnintja ekuranharlarlanga, urrpia ekuranhaka angkatjarlarlanga turta. John-angatjina pula atha kala Yia Marra erinhantama kaltjinthama, yia nhanga Altjirranha kala pitjikalantama, relha ingkarrakaka ntelalhitjika era Ingkartanamanga. Relha ingkarrakantama thakerrama Altjirranha ilitjika era Ingkarta etnaka turta namanga. ");
INSERT INTO are_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Alkira nhanha, alha nhanha turta yirritjina. Altjirraka turnintja etna pula itja kuta yirritjina. ");
INSERT INTO are_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Artwa erala noa ekuranha impuma, arrkutja arrpunha turtantama noaka inama, era korna mpaarama. Artwa era turta, erala noaka inama arrkutja artwa arrpunhala impukala, era turta korna mpaarama.” ");
INSERT INTO are_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesuala etnanha yia nhanha turta alpmelaka. “Artwa netaneta naka, erala mantarra marra inthorraka ekarralhitjata, arltamarlta tulhitjata turta, marnalka kngarra ilkumala. ");
INSERT INTO are_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Artwa ilkngara maamapapatha nyinta turta naka, rretnya ekura Lazarus. Etnantama Lazarus erinha artwa netanetaka ilthurna ankea kngitjata. Etna erinha reoanga kutaka turta arrarnitjata. ");
INSERT INTO are_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Era antja naka marna ungkwaltja etnanha ilkutjika, etnala artwa netanetaka table-anga tnyimanga. Kngulyala turta maama ekuranha wantjitjata. ");
INSERT INTO are_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Artwa ilkngara era kala ilukantama. Angel ntjarrantama pitjika, erinha Altjirraka pmara kutathurna turta kngaka, Abraham ntjarralela nitjika. “Artwa netaneta era ilukantema, etna turta erinha tintjiwuka. ");
INSERT INTO are_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tatharralantama kngarra nyingalauwumala, era inaramala Abraham-anha araka, tjatha ilanga namanga, Lazarus-anha turta ekuranga kuta. ");
INSERT INTO are_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Erantama Abraham-aka ilkaka, ‘Kaarta Abraham-ai! Nuka montjamontja ntelalhai! Lazarus-anha yairnai iltjakantja ekuranha kwatjaka kurnamala linya nukanha ngurlilitjika. Yingataka uralkngantha nhanhala kngarra nyingalauwuma.’ ");
INSERT INTO are_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Abraham-ala pula erinha ilaka, ‘Worra nukai, ilpangkai. Unta alhala namalanga, ungkwanga marna kngarra, mantarra kngarra, iltha marra turta naka. Kanha Lazarus-anha imampurlala naka. Lyarta pula Altjirrala erinha pmara nhanhala ntarntaramantama, kanha unta nyingalauwumala. ");
INSERT INTO are_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nhanha turta etarlarai. Nurnakanga mpopala twatja kngarritja nama. Lakinhanga, relha erala antja nama nhanhanga rrakangkarrurna lhitjika, era yarna tjananhama. Rrakangkarranga turta nyinta yarna nurnakurna tjanentjima.’ ");
INSERT INTO are_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Artwa erantama angkaka, ‘Lakinhanga paka kaarta Abraham-ai, Lazarus-anha urrpia yairnai kaarta nukanhaka pmarurna. ");
INSERT INTO are_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nuka tjia 5 etathantema nama. Era etnanha tjatjatutjika, etna turta pmara nhanhurna pitjakitja, nyingalauwukitja turta.’ ");
INSERT INTO are_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham-ala pula erinha ilaka, ‘Etna kala pepa nhanga Moses-ala intalhelakala, tnyinama. Etna turta pepa nhanga tnyinama, Altjirraka urrpia imankinya ntjarrala intalhelakala. Etna kala pepa nhanha ntjarraka read-erritjika, etnaka turta kangkwerritjika.’ ");
INSERT INTO are_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Artwa era pula angkaka, ‘Kaarta Abraham-ai, etna Altjirraka Angkatjakanta itja kangkwerritjina. Artwa nyinta pula errilknga ntjarranga kamerramala etnakurna lhamanga, etna Altjirrurna toperritjina.’ ");
INSERT INTO are_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abraham-ala pula erinha ilaka, ‘Etna itja Moses-aka kangkwerritjika antja namanga, Altjirraka urrpia imankinya ntjarraka turta, etna itja relha errilknga ntjarranga kamerrakalaka kangkwerritjina.’” ");
INSERT INTO are_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesuala kurtungurla ekuranha ntjarranha ilaka, “Relha kornala kunha relha arrpunhanha arrtjilhelitjina. Nhanha kala lakinha nitjina. Relha korna ekura pula imampurla inthorra nitjina, era relha arrpunhanha arrtjilhelakalanga, korna ntelalhitjika. ");
INSERT INTO are_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Arai, relha erala tnakanhakanha nyintanha arrtjilhelamanga korna ntelalhitjika, erinha Altjirrala nakapakarlilitjina. Ekura kala marralkura namara, arrpunhala paka tnyana kngarritja turrkura ekuranhaka ilparanakalanga, erinha kwatja iparta inthorraka turta arrkurlantema iwukalanga. ");
INSERT INTO are_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Arai, rrangkarrataka ingkarraka aralhitjika. Thunga tjia tnakanhakanhala nganha kornilama. Unta erinha kala tjatjatwai. Era paka ungkwanga ilalhamanga, ‘Yinga porerrama. Atha nganha nthurrpa kornilaka.’ Unta kala korna ekuranha iwutjika. ");
INSERT INTO are_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Thunga tjina tnakanhakanhala nganha 7-aranga kornilama, arlta nyintala. Erantama ungkwanga 7-arangantema ilalhama, ‘Yinga porerrama. Atha nganha nthurrpa kornilaka.’ Kurunga unta kala korna ekuranha 7-arangantema iwutjika.” ");
INSERT INTO are_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostle etnantama ekururna ingkaka, “Ingkartai, nurnaka tangitjala nai nganha ekarltalkura tnakitjika.” ");
INSERT INTO are_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ingkartala etnanha ilaka, “Rrangkarra paka yinganha kala kurrka inthorranta tnakamanga, rrangkarra irna tjuwanpa ngerra nhanha erinha ilamara, ‘Katha nhanhanga naamerrai, kwatja laiyaka turta ingkairnalhai.’ Kurunga irna era kala rrakangkarra kangkwerramara. ");
INSERT INTO are_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Thunga urrkapunhapunha ungkwanganha arlta ntjapara tnukulpala urrkapuma, arna urlpelamala, sheep paka tnairnamala. Kurunga era ilthurna pitjalpuma. Unta paka erinha ilitjina, ‘Kala iltjerramala arrarnalhai.’ ");
INSERT INTO are_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Itja kunha. Unta erinha lakinhatitja ilitjina, ‘Nukarrka marna urrkapumala kngitjai. Kurunga atha kala ilkukalanga, ntjukalanga turta, untantama ilkwai, ntjwai turta.’ ");
INSERT INTO are_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Unta itja urrkapunhapunha ungkwanganha dangkilama era ungkwangakimparra marna urrkapukalanga. Nhanha kala ekurathaka namanga warta. ");
INSERT INTO are_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Rrangkarra urrkapunhapunha era ngerra ntelalhitjika. Rrangkarra urrkapuntja ingkarraka rrakangkarranha kala arratja mangkilakalanga, rrangkarra kala lakinhanta angkitjika, ‘Nurna kunha urrkapunhapunha wara nama. Nurna kala itornka nurnakanhaka kangkwerrakanta.’” ");
INSERT INTO are_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesuanha Jerusalem-urna lhamalanga, era pmara Samaria Galilee tharranga mpopala tjananhaka. ");
INSERT INTO are_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Erantama town kurrka nyinturna irrputjikerramalanga, artwa leprosy-akarta 10 ekururna pitjika. Etna itja etinyerraka. ");
INSERT INTO are_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Etna pula ekura ilangangantema ilkaka, “Jesuai, itornkai, nurnaka konyerrai!” ");
INSERT INTO are_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Etnanha aramala Jesuala etnanha ilaka, “Lharrirrai, priest-aka turta ntelalhai!” Artwa menta etna priest-urna lhapalhamalangantema, etna kala marrerraka. ");
INSERT INTO are_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Artwa nyintala aramalanga era marrerrakala, era kala toperrakanta, Altjirranha intarra tnantjamala. ");
INSERT INTO are_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesuaka etinyerramala, era mparalela arrarnalhaka, urla ekuranhala turta arna mpaaraka. Era Jesuanha dangkilaka turta. Artwa nhanha era artwa Samaria-arinya naka. ");
INSERT INTO are_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesuanhantama angkaka, “Atha nhanga artwa 10 marrilaka. Artwa 9 arrpunha etnaloa? ");
INSERT INTO are_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kala Relha Lorinya nyinta nhanhantakwia pitjalpuka Altjirranha tnantjitjika?” ");
INSERT INTO are_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesualantama artwa Samaria-arinya erinha ilaka, “Kamerramala, kala alpai. Unta yinganha tnakakalanga, atha nganha marrilaka.” ");
INSERT INTO are_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Artwa Pharisee urrputjalantama Jesuanha pmarraka, “Ilangarama Altjirranha pitjitjina relha ingkarrakaka ntelalhitjika era Ingkartanamanga?” Jesuala etnanha ilaka, “Rrangkarra nhanha yarna alkngala arama, Altjirranha pitjimanga relha ingkarrakaka ntelalhitjika era Ingkartanamanga. ");
INSERT INTO are_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Thunga relha nyintala rrangkarranha ilitjina, ‘Arai, erataka nhanhala tjitjarterrama.’ Thunga relha arrpunhala ilitjina, ‘Itja, erataka tanhala tjitjarterrama.’ Rrangkarra erinha itja tnakitjika. Arai, rrangkarra Altjirraka kangkwerramalanga, nhanhala ntelama Altjirranha kala Ingkartanamanga.” ");
INSERT INTO are_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesualantama kurtungurla ekuranha ntjarranha ilaka, “Anma, rrangkarra antja inthorra nitjina Relhaka 'Lira erinha aritjika, pitjalpumanga. Rrangkarra pula erinha itja aritjina. ");
INSERT INTO are_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Arrpunha ntjarrala turta rrangkarranha ilitjina, ‘Arai, erataka kala tanhala nama.’ Kanha arrpunha ntjarrala ilitjina, ‘Itja, erataka nhanhala nama.’ Rrangkarra pula etnanha itja tnakitjika, etnaka kangkwerritjika paka. ");
INSERT INTO are_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Arai, Relhaka 'Lira era pitjalpumalanga, relha ingkarrakala erinha kala aritjina, etnala lharrkintja aramanga ngerra. ");
INSERT INTO are_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Arrkurla pula Relhaka 'Lirakathaka nama kngarra nyingalauwutjika. Relha ntjarra turta ekura antjakunya ntelalhitjika. ");
INSERT INTO are_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Relhaka 'Lira era pitjalpumalanga, nhanha kala artwa Noah-aka antalala ngerra nitjina. ");
INSERT INTO are_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Relha ntjarrala kunpala ilkurlanaka, ntjulanaka, noa inarralanaka turta. Artwa Noah-anha ship-aka irrpukalangantantama, kwatjampengkala etnanha ingkarraka yirralhelaka. ");
INSERT INTO are_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lot-aka antalala lakinha ngerrantema naka. Relha etna kunpala ilkurlanaka, ntjulanaka turta. Etna yultha buy-emilarlanaka, yirrinthalanaka, marna annga alpantiwurlanaka, iltha turta itarlanaka. ");
INSERT INTO are_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot-anha warta Sodom-anga rrataka, kanha Altjirrala urala alkiranga Sodom-akarlaka ilarnaka, relha ingkarrakanha turta yirralhelaka. ");
INSERT INTO are_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lakinha ngerrantema nitjina Relhaka 'Lira era alhurna pitjalpumalanga relha ingkarrakaka ntelalhitjika. ");
INSERT INTO are_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Arlta lenha ekurala, relha erala iltha kartninyala namanga, era itja iltha ekuranhakarrka irrputjika, yulthaka. Relha era turta, erala tnukulpala namanga, era turta itja iltha ekuranhurnarrka alputjika, yulthaka. ");
INSERT INTO are_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot-aka ilpangkai. ");
INSERT INTO are_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Arai, relha erala thakerrama etatha nitjikanta, era kala ilutjina. Kanha relha erala relha arrpunha ntjarranha impurlarrarnama erinha errilknga tutjika nukakwia, era kala ngampakalala etatha nitjina.” ");
INSERT INTO are_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Atha rrangkarranha nhanha turta ilama, “Ingwa lenha ekurala artwa tharra pmara nyintala ankwentitjina. Altjirrala nyintanha initjina, arrpunhanha impurlalhitjina. ");
INSERT INTO are_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Arrkutja tharrala tnyanala annga thalanitjina. Altjirrala nyintanha initjina, arrpunhanha impurlalhitjina.” ");
INSERT INTO are_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesuaka kurtungurla ntjarralantama erinha pmarraka, “Ingkartai, nthanhalama lakinherritjina?” Era etnanha ilaka, “Pmara errowulya erala intama, ekurala erritja etna worlerrama.” ");
INSERT INTO are_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesuala etnanha yia nhanhantama alpmelaka, etna itja porrkerritjinanga, Altjirrurna pula kuta ingkitjinanga. ");
INSERT INTO are_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Pmara arrpunhala tjiperrawunhawunha naka. Tjiperrawunhawunha era itja Altjirranga trerraka, relhanga paka. ");
INSERT INTO are_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pmara nhanha ekurala arrkutja warlukurta turta nakantema. Era tjiperrawunhawunha ekururna wothamawotha ingkaka, ‘Nuka tangitjala nai. Relha arrpunhalataka yinganha nakapakarlilama.’ ");
INSERT INTO are_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Tjiperrawunhawunha era pula ekura itja kuta kangkwerraka. Anma pula era lakinhantama eterraka. ‘Nthurrpa yinga itja Altjirranga trerrama, relhanga paka. ");
INSERT INTO are_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Warlukurta nhanhala pula yinganha porrkaporrkilama. Yingantama ekura tangitjala nitjina, era yinganha rirtilakitja.’” ");
INSERT INTO are_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ingkartalantama etnanha ilaka, “Rrangkarra kala tjiperrawunhawunha paala ekuranha angkatja wuka. ");
INSERT INTO are_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Altjirranhaloa? Era paka relha ntjarraka tangitjala nitjinama, relha nhanga erarrpa urrarakala ntjarraka, etna ekururna arltala pa ingwala ingkamanga? Era paka etnaka parrpa kangkwerritjinama? ");
INSERT INTO are_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Atha rrangkarranha ilama, era etnaka parrpa tangitjala nitjina. Relhaka 'Lira era pula pitjalpumalanga, era paka relha ntjarranha aritjalhitjinama, etna erinha kuta tnakamanga?” ");
INSERT INTO are_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesuanha kaltja naka relha arrpunha ntjarra tnakalhamanga, etna kula Altjirranga urlarra arratja namanga. Etna turtantama relha arrpunha ntjarranha lolowumanga. Erantama etnanha yia nhanha alpmelaka. ");
INSERT INTO are_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Artwa tharra temple-urna lharraka Altjirrurna ingkitjika. Nyinta artwa Pharisee naka, arrpunha artwa tax money kotjinha. ");
INSERT INTO are_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Itnamala, artwa Pharisee era lakinha angkaka, tjukunya wara. ‘Altjirrai, atha nganha dangkilama yinga itja relha arrpunha ntjarra ngerra namanga, nyilkngampa paka, kornarintja paka, ntaiyawunha paka, artwa tax money kotjinha tanha ngerra paka. ");
INSERT INTO are_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tharraranga week-ala yinga arlta ntjapara marnakunya nama. Yultha nukanha ingkarrakanga, atha nganha karta arrpunha arratja kuta nthetnama.’ ");
INSERT INTO are_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Artwa tax money kotjinha era pula ingkarnalala itnaka. Era turta porerraka alkirurnathaka inaritjika. Erantama inarnka tulhamala angkaka. ‘Altjirrai, nuka relha kornarintjaka montjamontja ntelalhai.’” ");
INSERT INTO are_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesualantama etnanha ilaka, “Arai, artwa tax money kotjinha erataka Altjirranga urlarra arratjerrakala alpuka. Kanha artwa Pharisee era itjala. Relha erala Altjirranga urlarra tnakalhama, erinha Altjirrala ipmintja iwutjina. Kanha relha erala Altjirranga urlarra porapora ntelalhama, erinha Altjirrala tnyinitjina kuta.” ");
INSERT INTO are_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Relha ntjarrala katjia kurrka etnakanha Jesuurna kngitjika, Jesuala iltja ekuranha kapurta etnakanhaka arrarnitjika. Nhanha aramala, kurtungurla ntjarrala etnanha unpurlenaka. ");
INSERT INTO are_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesuala pula katjia etnanha ntangkaka. Erantama kurtungurla ekuranha ntjarranha ilaka, “Katjia etnanha parritjala impai. Yinga antja etna nukurna pitjitjika. Altjirranha antja nama ntelalhitjika era Ingkarta etnaka namanga. ");
INSERT INTO are_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Arai, atha rrangkarranha nhanha nthurrpa inthorra ilama. Rrangkarra Altjirranha katjiala ngerranta tnakamanga, era rrakangkarra ntelalhitjina era Ingkartanamanga.” ");
INSERT INTO are_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Artwa itornkala Jesuanha pmarraka, “Kaltjinthanhinthanhai, unta kunha artwa marra. Untantama yinganha ilai, nthakinhama yinga ntelalhitjika, yinga Altjirraka pmarala ngampakala etatha nitjinanga?” ");
INSERT INTO are_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesuala erinha pmarraka, “Iwunhangama unta yinganha ilama yinga kula artwa marra namanga? Altjirra nyintanta kunha marra. ");
INSERT INTO are_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Unta kala Altjirraka turnintjaka kaltja. ‘Unta itja relha arrpunhaka noalela intitjika.’ ‘Unta itja relha arrpunhanha errilknga tutjika.’ ‘Unta itja relha arrpunhaka yultha nyilkngala initjika.’ ‘Unta itja relha arrpunhiperra orrtjerramala angkitjika.’ ‘Unta kaarta pa mia ungkwanganhaka kangkwerritjika.’” ");
INSERT INTO are_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Era Jesuanha ilaka, “Yinga pula turnintja nhanha ingkarrakaka kangkwerraka kurrkangatjina.” ");
INSERT INTO are_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nhanha wumala Jesuala erinha ilaka, “Nyintantantama ungkwangathaka nama. Yultha ingkarraka ungkwanganha yirrinthai, money erinha turtantama relha ilkngara ntjarranha nthai. Kurunga ungkwanga yultha kngarra alkirala intitjina. Unta turtantama nukanga tnaartangala pitjai.” ");
INSERT INTO are_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Angkatja nhanha wumala artwa era kngarra ltarrperraka, era artwa netaneta inthorra namanga. ");
INSERT INTO are_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesuala artwa erinha tjoraraka. Erantama erinha ilaka, “Arai, relha netanetaka kunha inpora inthorra nama Altjirraka pmarurna irrputjika. ");
INSERT INTO are_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nhanha rukaralkura nama camel needle-aka altjuranga tjananhitjika, nhanhangatjina, relha netaneta Altjirraka pmarurna irrputjika.” ");
INSERT INTO are_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Angkatja nhanha wumala, relha ntjarra lakinha pmarrarraka, “Relha ngunhanhantama Altjirrala irrpalthala tangkalhelamara?” ");
INSERT INTO are_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesuala etnanha ilaka, “Thunga relhala etarlarama Altjirrala relhanha yarna tangkalhelama. Altjirrala pula relha ingkarrakanha irrpalthala tangkalhelamala.” ");
INSERT INTO are_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peter-alantama Jesuanha ilaka, “Arai, nurna kunha ramarama nurnakanha impurlalhaka, ungkwanganga tnaartangala lhitjinala.” ");
INSERT INTO are_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesualantama etnanha ilaka, “Atha rrangkarranha nhanha nthurrpa ilama. Relha erala Ingkartakakwia pmara paka, noa paka, tjia paka, kaarta paka, mia paka, katjia paka impurlalhakalanga, ");
INSERT INTO are_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Altjirrala erinha kngarra kuta kapanha nthitjina, era alha nhanhalantema namalanga. Era turta anma Altjirraka pmarala ngampakala etatha nitjina.” ");
INSERT INTO are_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesuala kurtungurla 12 etnanhantama alpmelaka, “Arai, nurna kunha nhanha Jerusalem-urna lhama. Jerusalem ekuralantama Relhaka 'Lira era nyingalauwutjina Altjirraka urrpia imankinya ntjarrala ilakala ngerra. ");
INSERT INTO are_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Etna erinha Relha Lorinya ntjarrurna lanthitjina. Relha Lorinya etnantama erinha arrampowutjina. Etna ekura alkngarnterritjina. Etna ekura palha iwutjina. ");
INSERT INTO are_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Etna erinha whip-ala tutjina, errilknga tutjina turta. Arlta tharraminyinta errilknga intamaliperra pula, era wotha etatha kamerritjina.” ");
INSERT INTO are_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kurtungurla etna pula angkatja nhanha itja lhangkaraka Altjirrala etarlingetarla etnaka marntilakalanga. ");
INSERT INTO are_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesuanhantama Jericho-aka etinyerraka. Artwa panga tjaiyanga kutala narlanaka, marnaka enkamala. ");
INSERT INTO are_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Artwa panga era wuka relha ntjarra anpara lhamanga. Erantama relha etnanha pmarraka, “Nthakinherramai?” ");
INSERT INTO are_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Etna erinha alpmelaka, “Jesuanha, pmara Nazareth-arinya, era kunha nhanha anpara lhama.” ");
INSERT INTO are_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Panga erantama Jesuaka ilkaka, “Jesuai, David-aka 'Lirai, nuka montjamontja ntelalhai!” ");
INSERT INTO are_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Relha etnantama erinha rralthamala ilaka, “Tjukunyerrai!” Era pula intarra kuta ilkaka, “David-aka 'Lirai, nuka montjamontja ntelalhai!” ");
INSERT INTO are_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Itnatjalhamala, Jesuala etnanha turnaka artwa panga erinha ekururna kngitjitjika. Artwa era kala Jesuanga urlarra itnamalangantama, Jesuala erinha pmarraka, ");
INSERT INTO are_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Iwunhangama unta nuka ilkaka?” Artwa era erinha alpmelaka, “Ingkartai, alknga nukanha marrilai.” ");
INSERT INTO are_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesuala erinha ilaka, “Unta kala wotha arama. Unta yinganha tnakakalanga, atha alknga ungkwanganha marrilaka.” ");
INSERT INTO are_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Artwa ekura alknga kala marrerraka. Erantama Jesuanga tnaartangala lhaka, Altjirranha tnantjaka turta. Relha etnala nhanha arakala, etna turta Altjirranha tnantjakantema. ");
INSERT INTO are_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesuanha Jericho-akantama irrpunhaka, anpara kuta lhitjinala. ");
INSERT INTO are_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jericho ekurala artwa nyinta naka, rretnya ekura Zacchaeus. Era artwa tax money kotjinha ntjarraka itornka naka. Era turta artwa netaneta naka. ");
INSERT INTO are_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Erantama antja naka Jesuanha aritjika era anpara lhamalanga. Era pula erinha yarna araka, era artwa tungka namanga, relha worla kngarrala turta tjaiya ekura parramanga. ");
INSERT INTO are_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Lakinhanga era arrkurla arerramala irnaka ntjika. Irna erataka tjaiyanga kuta mangkalanaka, tjaiya nhanga Jesuanhala lhitjinala. ");
INSERT INTO are_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesuanha irna ekururna etinyerramalanga, era Zacchaeus-anha araka. Erinha inaramala era erinha ilaka, “Zacchaeus-ai, parrpa tnanpai. Nukathaka nama lyarta ungkwangalela yatjarra narlalputjika.” ");
INSERT INTO are_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacchaeus-anha parrpa tnanpuka. Jesuaka kngarra kangkamala, era erinha iltha ekuranhurna kngetnaka. ");
INSERT INTO are_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Relha ntjarrala pula nhanha aramalanga, etna ingkarraka wannga angkaka, “Erataka lhaka artwa kornarintjalela yatjarra narlalputjika.” ");
INSERT INTO are_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Etna marna ilkumalanga Zacchaeus-anha kamerramala angkaka, “Arai, Ingkartai, yultha nukanha kartatharrilamala, atha kala karta arrpunha relha ilkngara ntjarranha nthitjina. Atha paka relha arrpunhanga yultha nyilkngala inakalanga, atha erinha kala yultha kngarralkura nthitjalputjina.” ");
INSERT INTO are_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesuala Zacchaeus-anha ilaka, “Lyarta Altjirrala nganha, noa, katjia ungkwanganha turta tangkalhelaka.” Erantama relha ntjarranha ilaka, “Zacchaeus ntjarra turta kunha Abraham-aka ramarama namantema. ");
INSERT INTO are_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Arai, Relhaka 'Lira pitjika relha kornarintja ntjarraka yonthitjika, etnanha tangkalhelitjika turta.” ");
INSERT INTO are_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Relha ntjarrala erinha wurlanamalangantema, Jesuala etnanha yia nhanha turta alpmelaka. Arai, etnataka kala Jerusalem-anga etinyantama naka, relha etna turta etarlaraka Altjirranha kala relha ingkarrakaka alkngatharrantama tjitjarterritjinala. ");
INSERT INTO are_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jesuala etnanha lakinha alpmelaka. “Artwa nyinta ilanga lhaka, pmara arrpunhurna, itornka kngarrala erinha ingkairnitjinanga king-ntama nitjika pmara ekuranhala. Nhanhiperra era kala pitjalputjika naka. ");
INSERT INTO are_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Lhitjinala pula, era urrkapunhapunha 10-aka ntangkalhaka, etnanha nyintaminyintanha turta $1,000 ngerra nthaka. Erantama etnanha ilaka, ‘Yinga pitjalputjinalpula money nukanha kngarrilai, yulthalka yirrinthamala.’ ");
INSERT INTO are_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Pmararinya ntjarra pula artwa nhanha ekura itja antja naka. Etnantama itornka kngarra ekururna urrpia yairnaka, erinha lakinha ilitjika, ‘Nurna itja antja nama artwa nhanga king nurnaka nitjika.’ ");
INSERT INTO are_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Artwa era kala king-ntama namalanga, era pmara ekuranhurna pitjalpuka, urrkapunhapunha 10 nhangaka turta ntangkalhaka. Erantama etnanha pmarraka, ‘Rrangkarra money nukanha kngarrilakama?’ ");
INSERT INTO are_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Urrkapunhapunha nyintala erinha ilaka, ‘Ingkartai, yulthalka yirrinthamala atha money ungkwanganha kngarrilaka. Arai, nhanha $10,000 arrpunha nama.’ ");
INSERT INTO are_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“King-ala erinha ilaka, ‘Unta kunha urrkapunhapunha marra. Unta money kurrka arratja ntarntarakalanga, atha nganha ingkairnitjina 10 town-aka tjitjarterritjika.’ ");
INSERT INTO are_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Urrkapunhapunha arrpunhalantama erinha ilaka, ‘Ingkartai, yulthalka yirrinthamala atha money ungkwanganha kngarrilaka. Arai, nhanha $5,000 arrpunha nama.’ ");
INSERT INTO are_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“King-ala erinha ilaka, ‘Atha nganha ingkairnitjina 5 town-aka tjitjarterritjika.’ ");
INSERT INTO are_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Urrkapunhapunha arrpunhalantama erinha ilaka, ‘Ingkartai, nhanhiai $1,000 ungkwanganha nhanga. Athataka erinha mantarrala ilinyatumala lauwukala. ");
INSERT INTO are_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yingataka ungkwanganga trerraka, unta artwa arrthata warta namanga. Unta marna wheat kotjima, unta annga itja ingkairnakalangatanya. Unta marna arrpunha turta kotjima, unta etnaka itja urrkapukalangatanya.’ ");
INSERT INTO are_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“King era pula erinha ilaka, ‘Urrkapunhapunha kaningkai. Angkatja ungkwanganha inthorrala nganha imilama. Unta kaltja naka yinga artwa arrthata namanga. Atha turta marna wheat kotjimanga, atha annga itja ingkairnakalangatanya. Atha turta marna arrpunha kotjimanga, yinga etnaka itja urrkapukalangatanya. ");
INSERT INTO are_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Untantama money nukanha bank-aka arrarneikanha. Unta paka lakinhilakalanga, pitjalpumala atha money nukanha initjalpumara, kngarrerrakala.’ ");
INSERT INTO are_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Urrkapunhapunha urrputja arrpunha lenhala nakantema. King erantama etnanha ilaka, ‘Artwa ekuranga $1,000 nhanga inama. Rrangkarrantama $1,000 nhanha artwa erinha nthai, erala $10,000 arrpunha kngarrilakala.’ ");
INSERT INTO are_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Urrkapunhapunha etna pula king erinha ilaka, ‘Ekura pula kala kngarra inthorrala intama.’ ");
INSERT INTO are_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“King era pula etnanha ilaka, ‘Arai, relha arrpunhanha atha yultha kngarra nthama, ntarntaritjika. Era paka yultha nhanha arratja ntarntaramanga, atha erinha yultha kngarralkura nthitjina, ntarntaritjika. Relha arrpunhanha atha yultha kurrka nthama, ntarntaritjika. Era paka yultha kurrka nhanha itja arratja ntarntaramanga, atha yultha kurrka nhanha ekuranga wotha inetnitjinantema. ");
INSERT INTO are_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kalantama rrangkarra relha lenha ntjarranha nukurna kngitjai, etnala itja antja naka yinga king etnaka nitjika. Kurunga rrangkarra etnanha nukanga alkngatharra errilknga twai.’” ");
INSERT INTO are_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Angkatja nhanha ilamala, Jesuanha wotha Jerusalem-urna anparerraka. ");
INSERT INTO are_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Etnantama Bethphage, Bethany tharraka etinyerraka. Town nhanha tharrataka Olive Parta ingkala italhaka. Jesualantama kurtungurla tharra ekuranha yairnaka. Era erinhatharra ilaka. ");
INSERT INTO are_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Pmara kurrka arrpunha tanhurna lharrai. Pmaraka irrpumala ngerra, mpala donkey kurrka aritjina, rope-ala yirnakala. Donkey nhanhaka relha itja arrkurla ntjikala paka. Rope erinha ilumala, donkey erinha nukurna kngitjai. ");
INSERT INTO are_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Arrpunhala paka mpalanha pmarramanga, ‘Iwunhangama mpala donkey erinha kngama?’ Mpala erinha alpmelai, ‘Ingkartanha kunha ekura antja.’” ");
INSERT INTO are_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kurtungurla eratharra lhaka, donkey erinha araka turta, Ingkartala erinhatharra ilakala ngerra. ");
INSERT INTO are_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Eratharra rope erinha ilumalanga, donkey-akakurtwiala erinhatharra pmarraka, “Iwunhangala mpala rope erinha iluma?” ");
INSERT INTO are_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Eratharra erinha alpmelaka, “Ingkartanha donkey ekura antjanga.” ");
INSERT INTO are_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Eratharrantama donkey erinha Jesuurna rretjingaka. Kurunga eratharra mantarra donkey-aka arrarnaka, eratharra Jesuanha turta donkey ekura ntjilhelaka. ");
INSERT INTO are_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesuanha kala lhapalhamalangantama, relha ntjarrala mantarra etnakanha tjaiyaka ntjamiwetnaka, ekuranga arrkurla. ");
INSERT INTO are_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kurunga Jesuanha kala Olive Partanga tnanpanhamangantama, kurtungurla ingkarraka ekuranha kngarra kangkaka. Etna Altjirranha tnantjaka turta, etna nhanga tjatjikarta ntjarra arakalanga. ");
INSERT INTO are_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Altjirranha tnantjamala, etna ilkaka, “Ingkartala king ekuranha lyekarrilama. King era kala lyarta nurnakurna pitjima. Altjirranha nurnaka rilhera ntelalhama. Nurna erinha tnantjitjika.” ");
INSERT INTO are_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Artwa Pharisee urrputja relha worla lenhalela nakantema. Etnantama Jesuanha ilaka, “Kaltjinthanhinthanhai, kurtungurla ungkwanganha ntjarra ilai tjukunyerritjika.” ");
INSERT INTO are_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesuala pula etnanha ilaka, “Etna paka tjukunyerramanga, parta nhanha ntjarrala kala ilkitjina.” ");
INSERT INTO are_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesuanha kala Jerusalem-aka etinyerrakantama. Town erinha kartaramala, era town-arinya ntjarraka itnika. ");
INSERT INTO are_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Relha Jerusalem-arinya ntjarrai. Rrangkarra lyartantema paka leltja rrakangkarranhaka rilhera ntelalheikanha. Rrangkarra pula kotnarrpala relha arrpunhaka rilhera ntelalhitjika. ");
INSERT INTO are_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Lakinhanga, anma leltja rrakangkarranha pitjitjina. Etnantama pmara Jerusalem-anha marntilitjina, relha yarna irrputjinanga, rratitjinanga paka. ");
INSERT INTO are_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Etna rrangkarranha, katjia rrakangkarranha turtantama errilknga tutjina. Etna iltha rrakangkarranha urltakitjina. Ingkarna parta nyinta itja parta arrpunhanga kartninyala intitjina. Nhanha ingkarraka lakinherritjina relha Jerusalem-arinyai, rrangkarra itja Altjirranha lhangkarakalanga era rrakangkarrurna yatjarra pitjimalanga.” ");
INSERT INTO are_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesuanha temple-aka irrpunhaka. Era turta yirrinthanhinthanha ntjarranha unpurlenaka. ");
INSERT INTO are_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Era etnanha ilaka, “Altjirraka Angkatja Imankinyala ilama, ‘Iltha nuka relha ingkarrakaka pmara nitjika, pmara nhanga ekururnala etna pitjima, nukurna ingkitjika. Kanha rrangkarra iltha nukanha nyilkngampaka pmaratitjala mpaaraka.” ");
INSERT INTO are_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesualantama relha ntjarranha arltamarlta temple-ala kaltjinthaka. Priest-aka itornka ntjarra, artwa Intarrangaltha ntjarra, kngarripata ntjarra turtantama antja naka erinha errilknga tutjika. ");
INSERT INTO are_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Etna pula erinha yarna errilknga tuka, relha etna angkatja ekuranhaka kangkamanga inthorra. ");
INSERT INTO are_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Arlta arrpunhala Jesuala relha ntjarranha temple-ala kaltjinthaka. Era turta etnanha Yia Marra erinha ilaka. Priest itornka ntjarra, artwa Intarrangaltha ntjarra, kngarripata ntarntarintja ntjarra turtantama ekururna pitjika. ");
INSERT INTO are_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Etna erinha pmarraka, “Ngunhalama nganha turnaka relha ntjarranha kaltjinthitjika? Ngunhala turtama nganha turnaka relha ntjarranha Yia Marra erinha ilitjika?” ");
INSERT INTO are_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesuala etnanha ilaka, “Atha turta rrangkarranha pmarritjina. ");
INSERT INTO are_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ngunhalama John-anha turnakala relha ntjarranha kaltjirrpulhelitjika? Thunga Altjirrala? Thunga relhala paka?” ");
INSERT INTO are_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Etnantama angkarraka. “Nurna paka ilamanga, ‘Altjirrala erinha turnakala,’ era nurnanha pmarritjina, ‘Iwunhangantama rrangkarra erinha itja tnakaka?’ ");
INSERT INTO are_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nurna paka ilamanga, ‘Relhala erinha turnakala,’ relha ntjarralala nurnanha partala watjina, etnakanga urlarra John-anha Altjirraka urrpia nakalanga. ");
INSERT INTO are_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Lakinhanga etna Jesuanha ilaka, “Nurna kotna. Nurna nganha yarna alpmelama.” ");
INSERT INTO are_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesualantama etnanha ilaka, “Lakinhanga atha turta rrangkarranha itjantema alpmelitjina.” ");
INSERT INTO are_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesuala etnanha yia nhanhantama alpmelaka. “Artwa nyintala marna grapes ingkairnaka tnukulpa ekuranhala. Erantama tnukulpa erinha artwa arrpunha ntjarraka rent-emilaka. Erantama pmara arrpunhurna lhaka, ekuralantama kuterraka. ");
INSERT INTO are_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Marnaka kotjintjaka antalalantama, artwa era urrkapunhapunha nyinta yairnaka rent money ekuranhaka. Etna pula urrkapunhapunha erinha tumala, rapa yairnarlalpuka. ");
INSERT INTO are_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kurtwia erantama urrkapunhapunha arrpunha yairnaka. Etna pula erinha tukantema. Erinha arrampowumala, etna erinha turta rapa yairnarlalpukantema. ");
INSERT INTO are_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kurunga kurtwia era wotha urrkapunhapunha yairnaka. Urrkapunhapunha nhanha erinha pula etna alhwakantala tuka, tnukulpanga kathurna iwuka turta. ");
INSERT INTO are_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kurtwia erantama lakinha eterraka, “Atha kala worra nukanha etnakurna yairnitjina, worra nhanga ekurala yinga kngarra kangkama. Etna kala ekura kangkwerritjina.” ");
INSERT INTO are_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Artwa etna pula 'lira erinha aramalanga, etna lakinhala angkarraka. “Nhanha kunha 'lira era. Anma kunha tnukulpa nhanha ekurantama nitjika. Mpa, nurna erinha errilknga twiai, tnukulpa nhanha kala nurnakantama nitjinanga.” ");
INSERT INTO are_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Etnantama erinha errkuka, tnukulpanga kathurna iwuka, errilknga tuka turta. Jesualantama etnanha pmarraka, “Nthakinhantama tnukulpakakurtwia era ntelalhitjina? Atha rrangkarranha iliai? Era kunha yirrknga inthorra nitjina. ");
INSERT INTO are_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Erantama pitjitjina, artwa nhanha etnanha errilknga tutjina turta. Kurunga era tnukulpa erinha arrpunha ntjarranha nthitjina ekura ntarntaritjika.” Relha ntjarrala pula erinha ilaka, “Itja lakinha.” ");
INSERT INTO are_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesuala pula etnanha intarra aramala ilaka, “Rrangkarra kunha kala kaltja Altjirraka Angkatja Imankinyalala ilama, ‘Parta nhanga iltha itanha ntjarrala ipmintja iwukala, erantama lyarta parta tjiparralkura era nama?’ ");
INSERT INTO are_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Arai, relha erala parta lenhanga tnyinhamanga, erinha Altjirrala ungkwaltjilitjina. Kanha relha ekurakarlakala parta era tnyimanga, erinha parta erala urrpmaltjitjina. ");
INSERT INTO are_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Artwa Intarrangaltha ntjarra, priest itornka ntjarra turta kaltja naka Jesuala yia nhanha etnakiperra ilamanga. Etnantama antja naka erinha errkutjika. Etna pula relha ntjarranga trerraka. ");
INSERT INTO are_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Artwa Intarrangaltha ntjarrala, priest itornka ntjarrala artwa arrpunha ntjarranhantama yairnaka Jesuanha montjala ararlanitjika. Artwa nhanha etna relha marra ngerra ntelalhaka. Etna pula kaaralhaka Jesuanha paala angkitjika, etna erinha government itornka kngarranga urlarra ilparnitjinanga. ");
INSERT INTO are_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Artwa nhanha etnantama Jesuanha pmarraka, “Kaltjinthanhinthanhai, nurna kaltja unta artwa ilporatha namanga, unta turta itja relhanga trerramanga. Nurna turta kaltja unta relha ntjarranha kaltjinthamanga Altjirranga urlarra arratja ntelalhitjika. ");
INSERT INTO are_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nurnanha ilai, Altjirrala nurnanha turnamama nurna Caesar-anha tax money nthitjika?” ");
INSERT INTO are_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesuala lhangkaraka etna erinha pmathala wara pmarramanga. Erantama etnanha ilaka, ");
INSERT INTO are_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Yinganha tax money ungkwaltja ntelai. Ngunhaka ntolyama money ekurala nama? Ngunhaka rretnya turtama money ekurala nama?” Etna erinha alpmelaka, “Caesar-akakwia.” ");
INSERT INTO are_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesualantama etnanha ilaka, “Money nhanha Caesar-aka namanga, rrangkarra nhanha kala Caesar erinha ntharrirrai. Rrangkarra turta Altjirraka kangkwerrai, erala rrangkarranha turnakala ngerra.” ");
INSERT INTO are_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Artwa etnantama itja kuta wuka Jesuanha relha ntjarranga urlarra paala paka angkamanga. Jesuaka angkatjala turta etnanha tnolkalhelaka. Etnantama erinha itja wotha pmarraka. ");
INSERT INTO are_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Artwa Sadducee urrputjantama Jesuurna pitjika. Sadducee etnataka ilitjata relha errilknga ntjarra itja kamerritjinala. ");
INSERT INTO are_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Etnantama Jesuanha pmarraka, “Kaltjinthanhinthanhai, Moses-ala nurnanha lakinha turnaka. Thunga artwa paka katjiakunya iluma. Kurunga tjia ekuranhala warlukurta erinha noa initjika, nhanga kalya ekuranhaka katjia intitjinanga paka. ");
INSERT INTO are_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Arrpunharanga kanhanganhanga 7 naka. Kalya kngarralakimparra noa inaka. Era pula katjiakunya iluka. ");
INSERT INTO are_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tjia ekuranhalantama warlukurta erinha noa inaka. Era turta pula katjiakunyantema iluka. ");
INSERT INTO are_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kurunga tjia arrpunhala warlukurta erinha noa inaka. Era turta pula katjiakunya iluka. Lakinha ngerra kanhanganhanga 7-ala arrkutja erinha noa tnyinaka. Ingkarraka pula katjiakunya iluka. ");
INSERT INTO are_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ingkarna arrkutja era turtantama iluka. ");
INSERT INTO are_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Anma Altjirrala relha errilknga ingkarrakanha kamalhelamanga, ngunhaka noantama arrkutja era nitjina? Kanhanganhanga 7-ala kunha erinha noa tnyinakala.” ");
INSERT INTO are_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesuala etnanha ilaka, “Lyarta, alha nhanhala artwala noa inama, kwarra etnakanha turta noa nthama. ");
INSERT INTO are_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Anma, relha yalknga ntjarra Altjirraka pmarala nitjina, kala kamerrakala. Relha nhanha etna itja wotha noakarta nitjina. ");
INSERT INTO are_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Etna turta itja wotha ilutjina. Etna kala angel ntjarra ngerra nitjina. Etna kamerrakalanga warta, etna kala Altjirraka 'lirantama nitjina. ");
INSERT INTO are_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Relha ilukala ntjarra wotha kamerritjina. Moses-aka pepala kunha rrangkarra lakinha read-errama. Irna mpumala kwananga Altjirranha angkaka, ‘Yinga Abraham-aka Altjirra nama. Yinga Isaac-aka Altjirra nama. Yinga Jacob-aka Altjirra nama.’ ");
INSERT INTO are_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Altjirranha relha etatha ntjarraka Altjirra nama, itja relha errilknga ntjarraka. Altjirranga urlarra kunha relha ekuranha ntjarra kuta etatha nama.” ");
INSERT INTO are_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nhanha wumala artwa Intarrangaltha arrpunha ntjarrala Jesuanha ilaka, “Kaltjinthanhinthanhai, untataka marra angkaka.” ");
INSERT INTO are_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ekuriperra nyintala erinha itja wotha pmarraka paka. ");
INSERT INTO are_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesuala etnanhantama pmarraka, “Etna ilama Kristanha David-aka 'lira namanga. Nthakinha inthorrama era David-aka 'lira nama? ");
INSERT INTO are_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David erarrpa kunha psalm-ala ilama, ‘Ingkarta era Ingkarta nukanha ilaka: akwa nukanhanga arrarnalhai, ");
INSERT INTO are_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","atha leltja ungkwanganha ntjarranharrka pmakwinitjinanga.’ ");
INSERT INTO are_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David-ala paka Kristanha Ingkartakakalanga, nthakinhantama Kristanha David-aka 'lira nama?” ");
INSERT INTO are_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jesualantama kurtungurla ekuranha ntjarranha lakinha ilaka, relha ntjarrala wurlanamalanga. ");
INSERT INTO are_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Rrangkarrataka artwa Intarrangaltha ntjarranga aralhitjika. Etnataka kangkama mantarra tjenyakarta nthulaputjika. Etna antja nama relha ntjarrala etnanha anparnitjika etna shop-ala namanga. Etna synagogue-urna lhamanga, etna antja nama arrkurlala nitjika, relha ntjarrala etnanha aritjinanga. Arrpunhala etnanha marna ilkutjika ntangkamanga, etna antja nama itornka ntjarranga kuta nitjika. ");
INSERT INTO are_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Etna pula warlukurta ntjarraka iltha pmathala rakama. Etna turta tjarrilpmintja Altjirrurna ingkarlanama, relhala etnanha tnantjitjinanga. Altjirrala etnanha kala kngarra inthorra rrarrathala tutjina.” ");
INSERT INTO are_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesuala araka relha netaneta ntjarrala tjauwerrilya iwetnamanga, tjauwerrilyakanha box-aka. ");
INSERT INTO are_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Era warlukurta ilkngara nyintanha turta araka, tjauwerrilya kurrka iwumanga, money nhanga relhalala nthamara marna nyinta buy-emilitjika. ");
INSERT INTO are_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Erantama relha ntjarranha ilaka, “Atha rrangkarranha nthurrpa ilama. Warlukurta ilkngara nhanhala kngarralkura nthaka relha arrpunha ingkarrakangatjina. ");
INSERT INTO are_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Relha netaneta ntjarrala tjauwerrilya nthamaliperra, etnaka money kngarra kuta intaka. Kanha warlukurta era money ingkarraka ekuranhala nthaka. Ekura itja wotha intaka marna nyinta paka buy-emilitjika.” ");
INSERT INTO are_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Arrpunha ntjarra ilarraka. “Arai, etna temple erinha parta marra inthorrala itakala, yultha marra inthorrala turta intortilakala.” Etnanha wumala, Jesuala etnanha ilaka. ");
INSERT INTO are_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Temple ntjatjintja inthorra nhanha erinha leltjala anma ungkwaltjilitjina. Parta kngarritja nyintantama itja parta kngarritja arrpunhanga kartninyala intitjina. Etna ingkarraka arnala intitjina, leltjala errarnpalhelakala.” ");
INSERT INTO are_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Arrpunha ntjarralantama Jesuanha pmarraka, “Kaltjinthanhinthanhai, ilangarama lakinherritjina? Nthakinha turtama nurna kaltja nitjina leltja etna pitjitjikerramanga, iltha nhanha etnanha ungkwaltjilitjika?” ");
INSERT INTO are_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesuala etnanha ilaka, “Rrangkarrataka aralhitjika, arrpunhala rrangkarranha orrtjapepilakitja. Ntjarra kunha anma pitjimala angkitjina, ‘Yinga nama Krista era. Yinga nhanha kala pitjalpukantama.’ Rrangkarra pula etnaka itja kangkwerritjika. ");
INSERT INTO are_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Anma rrangkarra wumalanga relha arrpunha ntjarra turramanga, relha arrpunha ntjarra turta turritjikerramanga kula, rrangkarra itja trerritjika. Nhanha kunha kala lakinha nitjikarrpa. Alha era pula itjantema yirritjina.” ");
INSERT INTO are_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Erantama etnanha ilaka, “Pmararinya ntjarra, pmararinya arrpunha ntjarralela turritjina. King nyinta turta king arrpunhaka irrpaltherritjina. ");
INSERT INTO are_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Katha arrpunhala alha era kngarra errowutjina. Katha arrpunhala marnaka paalerrintja nitjina. Relha arrpunha ntjarranha menta kngarrala tutjina. Relha etna turta trerritjina, etna aramanga Altjirrala lirnnga, taiya, ntheilpura etnanha turta ngalhelamanga. ");
INSERT INTO are_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nhanha ingkarraka lyartathakangantema pula, etna rrangkarranha errkutjina. Etnantama rrangkarranha tutjika lurnitjina. Etna rrangkarranha synagogue-aka itornka ntjarraka lanthitjina. Etna rrangkarranha jail-aka kurnitjina. Etna rrangkarranha king ntjarranga urlarra ilparnitjina, tjitjarta kngarra ntjarranga urlarra turta. Etna rrangkarranha lakinha nakapakarlilitjina, rrangkarra yinganha tnakamanga. ");
INSERT INTO are_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nhanha kala lakinha nitjika, rrangkarra etnanha nukiperra ilitjinanga. ");
INSERT INTO are_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Rrangkarra itja arrkurlantema thakerritjika, lakinha eterramala, ‘Nthakinhama nurna angkitjika?’ ");
INSERT INTO are_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Atha kala rrangkarranha alpmelitjina angkatja rrangkarrala etnanha ilitjika. Etnantama angkatja rrakangkarranha yarna kuta inatutjina, ilpoiwutjina paka. ");
INSERT INTO are_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Rrangkarranha pula kaarta pa mia rrakangkarranhala, tjia rrakangkarranhala, tjina rrakangkarranhalalka leltjaka lanthitjina. Etna turta rrakangkarranga arrpunha ntjarranha errilknga tutjina. ");
INSERT INTO are_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Relha ingkarraka turta rrakangkarra yirrkngerritjina, rrangkarra yinganha tnakamanga. ");
INSERT INTO are_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Rrangkarra pula itja thakerritjika, Altjirrala rrangkarranha ntarntaramanga warta. ");
INSERT INTO are_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Rrangkarra yinganha ekarlta kuta tnakamanga, rrangkarra kala ngampakala etatha nitjina.” ");
INSERT INTO are_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Rrangkarra aramalanga leltja ntjarrala pmara etnakanha Jerusalem-anga kaarntakaarntala mpaaramanga, rrangkarra kaltja nitjika leltjala Jerusalem-anha kala ilpatutjinala. ");
INSERT INTO are_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kurunga relha Judea-arinya kala parturnanta naamerranhitjika. Relha etnala Jerusalem-ala namanga, etna kala kathurnanta arerritjika. Relha etna turta, etnala kathala namanga, etna itja Jerusalem-urna irrputjika. ");
INSERT INTO are_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nhanha kunha Altjirraka antala nama relha Jerusalem-arinya ntjarranha kapanha tutjika. Lakinha Altjirraka Angkatja Imankinya nthurrperritjina. ");
INSERT INTO are_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Arai, imampurla inthorra nitjina arrkutja inpora ntjarraka, arrkutja katjia kurrka ipatja ntjunhintjunha ntjarrakartaka turta. Kala relha ingkarraka inthorra nyingalauwutjina. Ingkartala turta relha Jerusalem-arinya ntjarranha rrarrathala tutjina. ");
INSERT INTO are_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Arrpunha ntjarranha leltjala knife tjenyala errilknga tutjina. Arrpunha ntjarranha leltjala pmara lorinyurna naamalhelitjina. Jerusalem ekurala turta Relha Lorinya ntjarra tjitjarterritjina, Altjirrala Relha Lorinya etnanha parritjinalpula.” ");
INSERT INTO are_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Lirnnga era, taiya era, ntheilpura etna turtantama arrpunha inthorrerritjina. Kwatja laiya era kngarra yurrangkitjina. Inmarra etna kngarrerritjina. Alhala turtantama relha ingkarraka yarna thakerritjina. ");
INSERT INTO are_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Etna turta enkakunyerritjina, trerramala. Etna turta yarna etarlaritjina, ntheilpuralka ngarlpangalhamanga. ");
INSERT INTO are_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kurunga relha ingkarrakala aritjina Relhaka 'Lira era matarala pitjimanga. Era ekarlta inthorra, makalaria inthorra turta ntelalhitjina. ");
INSERT INTO are_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Arai, nhanha ingkarraka lakinherramalanga, rrangkarra tnoatnoa nitjika Altjirranha kala pitjimangantama rrangkarranha tangkalhelitjika.” ");
INSERT INTO are_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesuala etnanha yiantama alpmelaka. “Rrangkarra irna tjurrka etnanha arama, irna arrpunha ntjarranha turta? ");
INSERT INTO are_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Etna ilpalhakarterramalanga, rrangkarra kaltja inguntha wara kala wumpierritjina. ");
INSERT INTO are_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Lakinhanga rrangkarra aramalanga angkatja nuka nthurrperramangantama, rrangkarra kaltja nitjika Altjirranha kala alkngatharra ntelalhitjikerrama era relha ingkarrakaka Ingkartanamanga. ");
INSERT INTO are_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Atha rrangkarranha nthurrpa ilama. Angkatja nukanha nthurrperritjina, ramarama nhanha namangantema. ");
INSERT INTO are_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Alkira nhanha kala yirritjina. Alha nhanha kala yirritjinantema. Angkatja nuka pula itja kutala yirritjina.” ");
INSERT INTO are_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Rrangkarra aralhitjika, rrangkarra marniperra, ngkwarliperra, yulthiperranta turta kngarra inthorra eterralanakitja. Kurunga yinga pitjalpumalanga, atha rrangkarranha turta tnolkalhelakitja. ");
INSERT INTO are_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kurunga rrangkarra turtantama imerrakitja. Arai, relha ingkarraka tnolkitjina yinga pitjalpumanga, etna arlta ekura kotnanga warta. ");
INSERT INTO are_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Rrangkarra pula kuta kaarra nitjika. Rrangkarra turta Altjirrurna ingkitjika, era rrakangkarra tangitjala nitjika rrangkarra erinha ekarlta kuta tnakitjika. Relhaka 'Lira era pitjalpumalangantama, era rrangkarranha aritjalhitjina rrangkarra ekura kaaralhamanga.” ");
INSERT INTO are_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesuala relha ntjarranha arltamarlta temple-ala kaltjinthaka. Ngurrangurra pula era Olive Parturnala alpuka, intitjika. ");
INSERT INTO are_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kurunga ingutnhala relha ingkarraka wotha temple-urna pitjitjata, erinha wutjika. ");
INSERT INTO are_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Relha etna kala Marna Ekalha ekura urrkapukantama, nhanhatitja Passover tjinkarra ekura. ");
INSERT INTO are_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Priest-aka itornka ntjarra, artwa Intarrangaltha ntjarra turta antja naka Jesuanha errkumala errilknga tutjika. Etna pula trerraka erinha alkngatharra errkutjika, relha ntjarra kekarta lhakitja. ");
INSERT INTO are_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satan-anhantama Judas Iscariot-urna irrpuka. Judas erataka 12 etnakanga nyinta naka. ");
INSERT INTO are_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas erantama priest itornka ntjarrurna lhaka, temple-aka tjapartia ntjarraka itornkurna turta. Erantama etnanha ilaka era antja namanga Jesuanha etnaka lanthitjika. ");
INSERT INTO are_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Judas-aka angkatja wumala etna kangkaka, erinha money nthitjika turta lhelaka. ");
INSERT INTO are_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Money-iperra arratjerramala, Judas-anha kala nhanhakantantama kngarralkura eterraka, “Nthakinhama atha Jesuanha nyilknganyilkngala etnaka lanthamara?” ");
INSERT INTO are_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Marna Ekalhaka ilpangkintjaka arltala, relha Jew ntjarrakathaka naka Passover Lamb etnanha tutjika. ");
INSERT INTO are_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesualantama Peter John tharranha yairnamala ilaka, “Kala lharrai Passover tjinkarra erinha nurnaka urrkaputjika, nurna erinha ilkutjinanga.” ");
INSERT INTO are_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eratharra pula erinha pmarraka, “Nthanhakama unta antja nama ilirna Passover tjinkarra erinha urrkaputjika?” ");
INSERT INTO are_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesuala erinhatharra ilaka, “Arai, mpala town-urna irrpumanga ngerra, mpala artwa nyintanha aritjina jar kngarritja kwatjakarta kngetnamanga. Ekuranga tnaartangala lhai, iltha ekuranhurna. ");
INSERT INTO are_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kurunga mpala ilthakakurtwia erinha ilitjika, ‘Kaltjinthanhinthanhala nganha pmarrama, “Nhanhama room era, ekurala atha Passover tjinkarra erinha ilkumara, kurtungurla nukanha ntjarralela?’” ");
INSERT INTO are_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Artwa erantama mpalanha room kngarritja ntelitjina, iltha kaputhala. Room nhanha erinha era kala ilkngikala, ekura ntjama turta iwukala. Room ekuralantama mpala tjinkarra erinha urrkapai.” ");
INSERT INTO are_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Peter John tharra lharraka. Jesuaka angkatja ingkarrakantama nthurrperraka. Eratharrantama Passover tjinkarra erinha urrkapuka. ");
INSERT INTO are_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ngurrangurra Jesuanha kala apostle ntjarralela arrarnalhaka marna ilkutjika. ");
INSERT INTO are_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Erantama etnanha ilaka, “Nyingalauwutjinala, yinga kngarra inthorra antja naka Passover tjinkarra erinharrka rrakangkarralela ilkutjika. ");
INSERT INTO are_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Atha kunha Passover tjinkarra erinha itja wotha ilkutjina, anmanta, Altjirranha relha ingkarrakaka Ingkarta ntelalhamanga.” ");
INSERT INTO are_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesuala cup wine-akartantama inaka. Altjirranha dangkilamala era etnanha ilaka, “Cup nhanhanga rrangkarra ingkarrakala tangilamala ntjurrirrai. ");
INSERT INTO are_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Arai, atha rrangkarranha ilama, atha itja wotha wine ntjutjina. Anmanta, Altjirranha relha ingkarrakaka Ingkarta ntelalhamanga.” ");
INSERT INTO are_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jesuala marnantama inaka. Altjirranha dangkilamala, era marna erinha urltakaka. Erantama etnanha marna erinha nthamala, ilaka, “Nhanha mpurrka nuka nama. Atha mpurrka nukanha lanthitjina, tjauwerrilya ngerra, rrakangkarrakwia. Lakinha ilkumala, nuka ilpangkai.” ");
INSERT INTO are_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Etna kala ilkukalangantama, era cup wine-akarta inaka. Nhanga ngerra era Altjirranha dangkilaka, era etnanha nthaka turta. Era etnanha ilaka, “Nhanha alhwa nuka nama. Atha alhwa nukanha thalitjina rrangkarranha Altjirralela tjinilitjika. ");
INSERT INTO are_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Arai, artwa erala yinganha leltjaka lanthitjinala, era nukalela nhanhala nama, table-ala. ");
INSERT INTO are_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Relhaka 'Lirakathaka nama ilutjika, Altjirrala ilakala ngerra. Artwa erala erinha leltjaka lanthamanga, ekura pula imampurla kngarra inthorra nitjina.” ");
INSERT INTO are_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kurtungurla etnantama pmarrarraka, “Nurnakanga ngunhalama erinha leltjaka lanthamara?” ");
INSERT INTO are_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kurunga kurtungurla etna iwurraka. Nyinta angkaka, “Yinga itornka rrakangkarra.” Kanha arrpunha angkaka, “Itja, yinga itornka rrakangkarra.” ");
INSERT INTO are_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesualantama etnanha ilaka, “Relha Lorinyaka king ntjarra, etna kunha relha etnakanhaka tjitjarterrama. King nhanha etna turta antja nama relha etnakanha, etnaka kangkitjika, etnanha tnantjitjika turta. ");
INSERT INTO are_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Rrangkarra pula itja king nhanha ntjarra ngerra nitjika. Artwa erala itornka rrakangkarra namanga, era kala tjia rrakangkarra ngerra ntelalhitjika. Artwa era turta, erala tjitjarta rrakangkarra namanga, era kala urrkapunhapunha rrakangkarranha ngerra ntelalhitjika. ");
INSERT INTO are_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Thunga artwa tharra nama. Nyinta kala kunpa arrarnalhama marna ilkutjika. Kanha arrpunha urrkapuma, artwa ekura marna thitjikala. Artwa nhanha tharranga, Ngunha paka artwa arrpunhaka itornka nama? Artwa era kunha, erala kunpa arrarnalhamala marna ilkumanta. Arai, yinga kunha rrakangkarra ntelalhama artwa urrkapunhapunha era ngerra. ");
INSERT INTO are_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yinga nyingalauwumalanga rrangkarra nukalela kuterraka. ");
INSERT INTO are_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Lakinhanga atha rrangkarranha ingkairnitjina king ngerra tjitjarterritjika, Kaartalala yinganha ingkairnakala ngerra. ");
INSERT INTO are_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yinga kala pmara nukanhalantama namanga, rrangkarra nukalela marna ilkutjina. Rrangkarra turta nyintaminyinta king-akanha chair-ala nitjina, Israel-aka ramarama 12 turta tjiperrawutjina.” ");
INSERT INTO are_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon-ai, Simon-ai, yinganharrka wurlathanai. Satan-anhataka Altjirrurna ingkaka rrangkarranha arrkarnitjika. Era antja nama aritjika rrangkarra paka yinganha nthurrpa tnakamanga. ");
INSERT INTO are_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yinga pula Altjirrurna ingkaka unta yinganha ekarlta kuta tnakitjika. Anma, unta Altjirrurna wotha toperrakalanga, unta tjia ungkwanganha ntjarraka turta tangitjala nai, yinganha ekarlta tnakitjika.” ");
INSERT INTO are_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peter-ala pula Jesuanha ilaka, “Ingkartai, yingataka ungkwangalela irrpalthala jail-urna lhama, iluma turta.” ");
INSERT INTO are_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesuala erinha ilaka, “Peter-ai, atha nganha nhanha ilama. Lyarta ingutnhala unta yinganha tharraminyintaranga yiparrarnitjina, lukaluka orrea era ilkitjikanhangantema.” ");
INSERT INTO are_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesualantama kurtungurla ekuranha ntjarranha pmarraka, “Rrangkarra paka nakapakarlerrakama atha nhanga rrangkarranha money-akunya, thauwakunya, sandal-akunya turta urrpia yairnamalanga?” Etna angkaka, “Itjama.” ");
INSERT INTO are_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Erantama etnanha ilaka, “Lyarta pula, ungkwanga money paka intamanga, thauwa paka, nhanha kala ungkwangalela kngai. Ungkwanga paka knife tjenya itja intamanga, mantarra arrpunha ungkwanganha yirrinthai, knife tjenya turta buy-emilai. ");
INSERT INTO are_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yinga lakinha angkama Altjirraka Angkatja Imankinyala ilamanga, ‘Erinha kunha artwa kornarintja ngerra imilitjina.’ Nhanha kunha etna nukiperra intalhelakala. Nhanha turta lyarta nthurrperritjina.” ");
INSERT INTO are_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kurtungurla etnantama erinha ilaka, “Ingkartai, nurnaka kunha knife tjenya tharra intama.” Jesuala etnanha ilaka, “Kala kunha.” ");
INSERT INTO are_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesuanha Olive Parturnantama lhaka, erala nhanga lhitjata ngerra. Kurtungurla ekuranha ntjarra ekuranga tnaartangala lhaka. ");
INSERT INTO are_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Olive Parta ekurerritjalhamala, Jesuala etnanha ilaka, “Altjirrurna ingkarrirrai era rrangkarranha ntarntaritjika, errintjala rrangkarranha arrkarnakitja.” ");
INSERT INTO are_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kurrka urntwarra lhamala, Jesuanha mparalela arrarnalhamala Altjirrurna ingkaka. ");
INSERT INTO are_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Kaarta nukai, yinga itja antja nama nyingalauwutjika, ilutjika turta. Unta pula antja namanga yinga nyingalauwutjika, ilutjika turta, yinga kala ungkwanga kangkwerrama.” ");
INSERT INTO are_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Angel-ntama ekururna pitjika alkiranga, erinha ekarltilaka turta. ");
INSERT INTO are_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kngarra mpangkamala, era wothamawotha Altjirrurna ingkaka. Ntjia ekurantama arnaka tnyika alhwa ulthunta ngerra. ");
INSERT INTO are_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kamerramalantama, era kurtungurla ntjarrurna lhaka. Era etnanha ankwentamanga araka. Etnataka ltarrpa inthorra naka. ");
INSERT INTO are_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Erantama etnanha pmarraka, “Iwunhangala rrangkarra ankwentama? Kamerramala Altjirrurna ingkarrirrai, era rrangkarranha ntarntaritjika, errintjala rrangkarranha arrkarnakitja.” ");
INSERT INTO are_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesuanha kurtungurla ekuranha ntjarrurna angkamalangantema, worla kngarra pitjika. Judas, 12 etnakanga nyinta, era worla etnanha rretjingaka. Jesuurna etinyerramala, era erinha rrontjaka. ");
INSERT INTO are_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesualantama Judas-anha pmarraka, “Judas-ai, rrontjamalama unta Relhaka 'Lira erinha leltjaka lanthama?” ");
INSERT INTO are_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kurtungurla ntjarrala aramalanga etna Jesuanha errkutjikerramanga, etna erinha pmarraka, “Ingkartai, nurna etnanha knife tjenyala twiai?” ");
INSERT INTO are_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kurtungurla nyintalantama High Priest-aka urrkapunhapunha knife tjenyala tuka, ilpa akwa ekuranha inturnamala. ");
INSERT INTO are_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesuala pula erinha ilaka, “Kala impai!” Erantama urrkapunhapunha ekuranhaka ilpa anpumala, erinha marrilaka. ");
INSERT INTO are_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kurunga Jesuanha priest itornka ntjarrurna, temple tjapartia ntjarrurna, kngarripata ntarntarintja ntjarrurna turta angkaka. Etna ingkarraka kunha pitjikala erinha errkutjika. “Knife tjenyakarta, tnamakarta turtama rrangkarra nuka pitjika, relha nyilkngampa tunhatunhaka ngerra? ");
INSERT INTO are_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yinga pula arltamarlta temple-ala nitjata. Rrangkarra pula yinganha itja errkuka. Lyarta pula Altjirrala rrangkarranha impurlarrarnama yinganha errkutjika. Era errintja erinha turta impurlarrarnama nuka irrpaltherritjika.” ");
INSERT INTO are_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesuanha errkumala, etna erinha High Priest-aka ilthurna rretjingaka, erinha kwanurna turtantama kngaka. Peter-ala pula etnanha ingkarnangala lurnaka. ");
INSERT INTO are_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Etna urantama etaka High Priest-aka yard mpopala. Pitjimala, Peter-anha etnakalela arrarnalhaka. ");
INSERT INTO are_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Marla urrkapunhapunha nyintala erinha araka urala namanga. Peter-anha yapmamala, era angkaka, “Artwa nhanhataka Jesualela nakantema.” ");
INSERT INTO are_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Peter-ala pula erinha ilaka, “Arrkutjai, yingataka ekura kotna.” ");
INSERT INTO are_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kurrka anma, arrpunhalantama Peter-anha aramala, erinha ilaka, “Unta kunha etnakanga nyinta namantema.” Peter-anha pula erinha ilaka, “Artwai, itjiai.” ");
INSERT INTO are_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Anma, artwa arrpunhantama angkaka, “Artwa nhanhataka nthurrpa Jesualela nakalantema. Era turta artwa Galilee-arinya namanga warta.” ");
INSERT INTO are_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peter-ala pula erinha ilaka, “Artwai, untataka marntilparla angkama. Yingataka ekura kotna.” Peter-anha angkamalangantema, lukaluka orrea ilkarlalhaka. ");
INSERT INTO are_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ilkngaralhamala, Ingkartala Peter-anha tjoraraka. Peter-anha ilpangkakantama, Ingkartalala erinha ilakala, “Lukaluka orrea era ilkitjikanhangantema, unta yinganha kala tharraminyintaranga yiparrarnitjina.” ");
INSERT INTO are_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peter-anhantama yard-anga rratamala kngarra inthorra itnika. ");
INSERT INTO are_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Artwa etnala Jesuanha errkurlanaka, etna erinha arrampowuka, erinha tuka turta. ");
INSERT INTO are_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Etnantama alknga ekuranha korltamala erinha pangilaka. Kurunga etna erinha pmarraka, “Nurnanha ilakwia, ngunhalama nganha tuka?” ");
INSERT INTO are_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Etnantama erinha kuta arrampowurlanaka. ");
INSERT INTO are_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kala arlterramalangantama, kngarripata itornka ntjarrala, priest-aka itornka ntjarrala, artwa Intarrangaltha ntjarrala turta Jesuanha Sanhedrin council-urna rretjingaka. Etna erinha pmarraka, ");
INSERT INTO are_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nurnanha ilai, unta paka Krista era namama?” Jesuala etnanha ilaka, “Atha paka rrangkarranha alpmelamanga, rrangkarra angkatja nukanha itja tnakitjina. ");
INSERT INTO are_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Atha turta paka rrangkarranha pmarramanga, rrangkarra yinganha itja alpmelitjina. ");
INSERT INTO are_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lyartanga pula Relhaka 'Lira era Altjirra Ekarlta Inthorraka akwampinyala nitjina.” ");
INSERT INTO are_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Etnantama erinha pmarraka, “Unta Altjirraka 'Lira namama?” Jesuala etnanha alpmelaka, “Lakinha kunha rrangkarra angkama.” ");
INSERT INTO are_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Etnantama pmarrarraka, “Iwunhangama nurna artwaka kuta yonthama erinha ilparnitjika? Nurna kala angkatja ekuranha wuka.” ");
INSERT INTO are_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kamerramalantama, Sanhedrin council etna Jesuanha Pilate-urna rretjingaka. ");
INSERT INTO are_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Etnantama erinha ilparnaka, “Nurnarrpa artwa nhanha erinha araka pa wuka. Era relha nurnakanha ntjarranha ilaka etna itja wotha Roman government-aka kangkwerritjika, Caesar-anha tax money paka nthitjika. Erarrpa turta ilalhaka era kula Krista era namanga, king nurnaka.” ");
INSERT INTO are_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate-alantama Jesuanha pmarraka, “Nthurrpama unta relha Jew ntjarraka king?” Jesuala erinha ilaka, “Lakinha unta angkama.” ");
INSERT INTO are_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilate-alantama priest-aka itornka ntjarranha, worla kngarra ingkarna pitjikala etnanha turta ilaka, “Nukanga urlarra artwa nhanha itja ilkarrtja nama.” ");
INSERT INTO are_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Etna pula ekarlterraka, “Erataka nthurrpa relha ntjarranha ilaka itja government-aka kangkwerritjika. Era kala pmara Judea ntjaparala relha ntjarranha lakinha kaltjinthaka. Era nhanga pmara Galilee-anga tjontamala, era pmara nhanhakurtitja relha ntjarranha lakinha kuta kaltjinthentjika.” ");
INSERT INTO are_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nhanha wumala, Pilate-ala etnanha pmarraka, “Pmara Galilee-arinyama artwa nhanha?” ");
INSERT INTO are_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Etna erinha ilaka era nthurrpa artwa Galilee-arinya namanga, King Herod-aka pmararinya. Pilate-alantama erinha Herod-urna yairnaka. Herod-anha arlta lenhala Jerusalem-ala naka, yatjarra pitjikala. ");
INSERT INTO are_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod-alataka arrkurlantema Jesuiperra yia wentjikala, erantama antja inthorra naka erinha aritjika. Era turta antja naka Jesuala ekura tjatjikarta urrkaputjika. Lakinhanga era kngarra kangkaka Pilate-ala Jesuanha ekururna yairnamalanga. ");
INSERT INTO are_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Erantama Jesuanha kngarra pmarraka. Jesuanha pula ekururna itja kutala angkaka. ");
INSERT INTO are_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Priest-aka itornka ntjarrala, artwa Intarrangaltha ntjarrala turta pula Jesuanha kngarra kuta ilparnaka. ");
INSERT INTO are_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kurunga Herod-ala, tjapartia ekuranha ntjarrala turta, Jesuanha iltaka, arrampowuka turta. King-akanha mantarra marra inthorrantama ekura ekarramala, Herod-ala erinha wotha Pilate-urna yairnarlalpuka. ");
INSERT INTO are_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Arlta lenha ekuralantama Herod Pilate tharra tjinerraka. Arrkurla eratharra leltjarrka narrakala. ");
INSERT INTO are_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kurunga Pilate-ala priest-aka itornka ntjarranha worlilaka, kngarripata itornka ntjarranha turta. ");
INSERT INTO are_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Era etnanha ilaka, “Rrangkarra artwa nhanhanha nukurna kngitjika. Rrangkarra yinganha ilaka era kula relha ntjarranha turnamanga government-aka itja kangkwerritjika. Athantama erinha nhanhiperra montjala pmarraka rrakangkarranga alkngatharra. Arai, era pula artwa kornakorna wara. Era itjama ilkarrtja. ");
INSERT INTO are_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod-ala turta yinganha lakinhantema ilaka, erinha nurnakurna yairnarlalpumala. ");
INSERT INTO are_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Lakinhanga atha tjapartia ntjarranha turnitjina erinha whip-ala tutjika. Kurunga atha erinha althakalthilitjina.” ");
INSERT INTO are_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Etna ingkarraka pula ilkaka, “Erinha kala errilknganta twai. Barabbas-anhatitja nurnaka jail-anga rratalhelai.” ");
INSERT INTO are_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabbas erataka Jerusalem jail-ala naka, era nhanga relha ntjarranha turnakalanga itja Roman government-aka kangkwerritjika. Era turta relha arrpunha ntjarranha errilknga tukalanga. ");
INSERT INTO are_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate-anha pula kuta antja naka Jesuanha althakalthilitjika. Lakinhanga era relha worla kngarra etnanha wothantema ilaka, “Nhanha pula artwa palkinya.” ");
INSERT INTO are_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Etna pula ilkaka, “Erinha kala ntolkakanta kanthatwai. Erinha kala ntolkakanta kanthatwai.” ");
INSERT INTO are_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilate-ala pula etnanha wothantema, kala tharraminyintarangantama pmarraka, “Nthakinhama era paala ntelalhaka? Atha erinha yarna imilama era artwa palkinya namanga. Lakinhanga atha tjapartia ntjarranha turnitjina erinha whip-ala tutjika. Kurunga atha erinha kala althakalthilitjina.” ");
INSERT INTO are_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Etna pula kuta intarramintarra ilkaka era Jesuanha kala ntolkakanta kanthatutjika. Pilate-ala etnanha yarna kuta tjukunyilaka. ");
INSERT INTO are_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Erantama etnaka kala kangkwerrakanta. ");
INSERT INTO are_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Artwa urrarna nhanganha, erala relha ntjarranha turnakala itja government-aka kangkwerritjika, erinha era kala jail-anga rratalhelaka. Jesuanha pula era tjapartia ntjarraka lanthaka, etna erinha ntolkaka kanthatutjika, relha ntjarra antja nakala ngerra. ");
INSERT INTO are_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tjapartia ntjarrala Jesuanha Jerusalem-anga kathurna rretjingamalanga ntolkaka kanthatutjika, etna artwa nyintanha araka urlarra pitjimanga, rretnya ekura Simon. Era artwa pmara Cyrene-arinya naka. Tjapartia ntjarrala erinha errkuka. Etnantama Jesuaka ntolka ekurakarlaka tjurnaka, erinha turnaka turta ntolka erinha Jesuanga tnaartangala kngitjika. ");
INSERT INTO are_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Worla kngarra turta Jesuanga tnaartangala lhakantema. Worla nhanha ekurala arrkutja urrputja ntjarra ngerra turta lhapalhaka. Etna Jesuaka kngarra nthorrkngerraka, itnika turta. ");
INSERT INTO are_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Etnaka ilkngaralhamala, Jesuala etnanha ilaka, “Arrkutja Jerusalem-arinya ntjarrai, nuka nthorrkngerritjala nai. Marralkura rrangkarra rrakangkarrarrpa nthorrkngerritjika, katjia rrakangkarranhaka turta. ");
INSERT INTO are_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Anma relha Jerusalem-arinya ntjarra angkitjina, ‘Arrkutja katjiakunya ntjarra, arrkutja etnala itja katjiakarterrakala paka, etnala itja ipatja nthakala paka, etna kunha arrkana nama.’ ");
INSERT INTO are_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Etna turta lakinha angkitjina, ‘Parta kngarra ntjarrataka nurnakarlaka tnyeikanha, parta urrtha ntjarrala turtataka nurnanha korlteikanha.’ ");
INSERT INTO are_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Arai, lyarta etna yinganha, relha palkinyanha rrukunthakunthilamala tuma. Inguntha etna rrangkarranha, relha ilkarrtja ntjarranha, kngarralkura rrukunthakunthilamala tutjina.” ");
INSERT INTO are_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Artwa tharra arrpunha, artwa korna tharra purrama, etna Jesualela rretjingaka, erinhatharra turta ntolkaka kanthatutjinala. ");
INSERT INTO are_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Etnantama pmara ekura erritjalhaka, erinhala etna ilama, ‘Kaalkngaka Pmara.’ Etnantama Jesuanha ntolkaka kanthatuka. Kurunga artwa korna nhanga tharranha etna ntolkaka kanthatukantema. Nyintaka ntolka Jesuaka akwala itnaka. Kanha arrpunhaka ntolka Jesuaka kwanginyalala itnaka. ");
INSERT INTO are_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesuanhantama angkaka, “Kaartai, korna etnakanha iwai. Etna kunha itja kaltja etna 'Lira ungkwanganha errilknga tumanga.” Tjapartia etnantama Jesuaka mantarra errarnpalhelaka, gamble-erramala. ");
INSERT INTO are_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Worla pitjikala nhangala erinha ararlanaka. Priest-aka itornka ntjarrala, kngarripata itornka ntjarrala turta erinha arrampowuka. Etna lakinha angkaka, “Era kunha arrpunha ntjarranha tangkalhelaka. Era paka Krista era namanga, erinhala Altjirrala urrarakala, era kala tangkalhelalheikanha.” ");
INSERT INTO are_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Etinyerramala, tjapartia ntjarrala erinha arrampowukantema. Etna erinha wine tjalangka nthaka. ");
INSERT INTO are_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Etnantama erinha ilaka, “Unta nthurrpa relha Jew ntjarraka king namanga, kala tangkalhelalhai.” ");
INSERT INTO are_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Etnantama angkatja nhanha pepaka intalhelaka, “Nhanha era kunha relha Jew ntjarraka king.” Kurunga etna pepa nhanha ntolkaka kanthatuka, Jesuanga kartninyaka. ");
INSERT INTO are_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Artwa korna nyinta, erala ntolkalantema ilparanamanga, era Jesuanha arrampowuka, “Unta kulama Krista era. Iwunhangantama unta itja tangkalhelalhama, ilirnanha turta tangkalhelama?” ");
INSERT INTO are_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Artwa korna arrpunhala pula erinha parrakala, “Unta itjala Altjirraka aa kngarranga trerrama? Etna nurnanha tharraminyinta imilaka. Nurna nhanha kala ilutjikerrama. ");
INSERT INTO are_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nhanha kala arratja nama ilirna ilutjika, ilirna korna ntelalhakalanga. Kanha artwa nhanha, artwa palkinyala.” ");
INSERT INTO are_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jesuwurnantama era angkaka, “Jesuai, nuka ilpangkau, unta anma relha ingkarrakaka Ingkartantama namanga.” ");
INSERT INTO are_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesuala erinha ilaka, “Atha nganha nthurrpa ilama. Lyartantema unta nukalela nitjina Paradise-ala.” ");
INSERT INTO are_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kala ngkinyalantama alkira era thapathaperraka, pmara ntjapara turta thapathapa naka 3 o'clock-akurtitja, ");
INSERT INTO are_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","lirnngaka parrtja yirraka. Mantarra kngarritja nhanga turta, erala temple kwanala ilparanakala, era mpopa inthorrantama tjepakalhalalhaka. ");
INSERT INTO are_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesuanhantama intarra ilkaka, “Kaartai, atha nganha enka nukanha lanthama, ntarntaritjika.” Lakinha angkamala, era kala ilukantama. ");
INSERT INTO are_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Roman tjapartia ntjarraka itornkala nhanha aramalanga, era Altjirranha tnantjaka, lakinha angkamala, “Nthurrpathoa artwa nhanha, artwa arratja naka.” ");
INSERT INTO are_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Relha arrpunha ntjarra, etnala wara aritjika pitjikala, etna nhanha aramalanga, etna porerraka. Etnantama inarnka tulhaka, alpuka turta. ");
INSERT INTO are_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesuaka tjina ntjarra, arrkutja nhanga ntjarra turta, etnala Galilee-angatjina ekuranga tnaartangala pitjikala, etna nhanha ingkarraka tjathangala ararlanaka. ");
INSERT INTO are_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Arai, artwa nyinta, rretnya ekura Joseph. Era Arimathea town-arinya naka, pmara Judea-ala. Joseph nhanha era artwa marra, arratja turta naka. Era Sanhedrin council naka. ");
INSERT INTO are_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Era pula itja antja naka Council etna Jesuanha imilitjika. Era turta kaaralhaka Altjirranha ntelalhitjika era relha ingkarrakaka Ingkartanamanga. ");
INSERT INTO are_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Joseph nhanha erantama Pilate-urna lhaka, Jesuaka mpurrkaka turta enkaka. ");
INSERT INTO are_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jesuaka mpurrka ntolkanga tnanpulhelamala, era mpurrka erinha mantarra tjulkurala ilinyiwuka, intia wolkngaka turta arrarnaka. Relha errilknga itja arrkurla wolknga nhanha ekurala intakala paka. ");
INSERT INTO are_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nhanha kala Friday ngurrangurra naka. Kala ingkwa Sabbath arlta turta. ");
INSERT INTO are_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Arrkutja nhanga ntjarra, etnala Jesuanga tnaartangala pitjikala Galilee-angatjina, etna Joseph-anga tnaartangala lhakantema. Etnantama araka era Jesuaka mpurrka inamala, wolkngaka turta arrarnamanga. ");
INSERT INTO are_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kurunga etna pmarurna alpuka. Kurunga etna ntira unpa marrakarta inaka, Jesuaka mpurrka anma parnitjinala. Etna pula itja Sabbath arltala lhaka Jesuaka mpurrka parnitjika, Altjirraka Angkatja Imankinyala parrakalanga, itja Sabbath arltala urrkaputjika. ");
INSERT INTO are_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sunday ingutnhala inthorrantama, arrkutja etna wolknga nhanga ekururna lhaka, ntira unpa marrakarta. ");
INSERT INTO are_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Etnantama wolknga ekururna etinyerramalanga, etna araka parta kngarritja nhanga kala ankartiwukala. ");
INSERT INTO are_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Etnantama wolknga ekururna irrpunhaka. Ingkarta Jesuaka mpurrka pula etna itjala araka. ");
INSERT INTO are_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Etnantama yarna eterraka. Kurunga artwa tharra mantarra tjulkura inthorrakarta, etnakanga kuta itnatjalhaka. ");
INSERT INTO are_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Etnantama kngarra trerraka. Twakalhamala, etna anngerra kwaninyerraka. Artwa eratharra pula etnanha pmarraka, “Iwunhangala rrangkarra relha etathaka yonthama relha errilkngaka pmarala? ");
INSERT INTO are_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesuanha itja nhanhala nama. Era relha errilknga ntjarranga kamerraka. Rrangkarra paka ilpangkamama, erala nhanga rrangkarranha Galilee-alantema ilakala? ");
INSERT INTO are_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Relhaka 'Lira erinha kunha etna artwa korna ntjarraka lanthitjina, etna turta erinha ntolkaka kanthatutjina. Arlta tharraminyintiperra pula era wotha kamerritjina.’” ");
INSERT INTO are_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Arrkutja etna Jesuaka angkatjaka ilpangkakantama. ");
INSERT INTO are_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wolknganga alpumala, etna yia nhanha 11 etnaka alpmelitjalpuka, kurtungurla arrpunha ntjarraka turta. ");
INSERT INTO are_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Arrkutja etnala nhanga wolkngurna lhakala, etna naka Mary Magdalene, Joanna, Mary nhanga James-aka mia, arrkutja arrpunha ntjarra turta. Etnantama yia nhanha apostle etnaka ilitjalpuka. ");
INSERT INTO are_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Apostle etna pula etarlaraka angkatja etnaka yia kornakorna wara namanga. Etnantama angkatja etnakanha itja tnakaka. ");
INSERT INTO are_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peter-anha pula wolknga ekururna arrtjanakala. Twakalhamala, era kwana tjilaraka. Era pula mantarranta araka intamanga. Erantama alpumala yarna eterralanaka, “Nthakinherrakai?” ");
INSERT INTO are_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sunday ekurala Jesuaka kurtungurla tharra arrpunha Emmaus-urna lharraka. Emmaus erataka town kurrka naka, Jerusalem-anga altorla, 12 kilometers ngerra. ");
INSERT INTO are_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tjaiyala lhapalhamala, kurtungurla eratharra Jesuiperra angkarralanaka, nhanga arrpunha ntjarrala erinha errilknga tukala. ");
INSERT INTO are_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Eratharrantama angkarramalangantema, Jesuanha ingkarnanga pitjimala ekuratharraka lhangalhaka, ekuratharralela turta lhapalhakantama. ");
INSERT INTO are_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Eratharra erinha kala araka, eratharra pula erinha itja lhangkaraka, Altjirrala etarlingetarla ekuratharra marntilakalanga warta. ");
INSERT INTO are_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesualantama erinhatharra pmarraka, “Iwunhama mpala ilarraka tjaiyala lhapalhamala?” Eratharrantama itnatjalhaka, ltarrpa inthorra. ");
INSERT INTO are_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ekuratharranga arrpunha, rretnya ekura Cleopas, erantama erinha pmarraka, “Relha Jerusalem-arinya nyinta untantama kotna nhanga ngurruka nakalaka?” ");
INSERT INTO are_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Era pula erinhatharra kuta pmarraka, “Iwunhiperrama mpala angkarraka?” Eratharra erinha ilaka, “Jesua Nazareth-arinyiperrakwia. Era Altjirraka urrpia naka. Era relha ntjarranha kngarra kaltjinthaka. Era tjatjikarta kngarra turta urrkapuka. Altjirranha ekura kangkaka, relha ingkarraka turta. ");
INSERT INTO are_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Itornka nurnaka ntjarrala pula, priest pa kngarripata itornka etna, etna erinha Pilate-akala lanthaka, Pilate-ala erinha imilitjika. Pilate-alantama erinha tjapartia ntjarraka lanthaka, etna erinha ntolkaka kanthatutjika. ");
INSERT INTO are_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nurna pula eterraka, era kula relha Israel-arinya nurnanha tangkalhelitjinala. Itjarrpantama. Nhanha kala arlta tharraminyintantama nama, arlta erala ilukaliperra. ");
INSERT INTO are_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Lyarta ingutnhala, arrkutja urrputja worla nurnakanhanga, etna nurnanha tnolkalhelaka. Ingutnhala etna wolkngurna lhakala. ");
INSERT INTO are_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Etna pula Jesuaka mpurrka ywaraka. Pitjalpumala, etna nurnanha ilaka etna kula angel ntjarranha arakala. Angel etna turta kula etnanha ilakala Jesuanha etatha namanga. ");
INSERT INTO are_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nurnakanga urrputjantama wolkngurna lhaka. Etna kala araka wolknga era urlta namanga, arrkutja etnala ilakala ngerra. Jesua erinha pula etna itjala araka.” ");
INSERT INTO are_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesuantama ekuratharrurna angkaka, “Yakai, mpalataka marntilparla inthorra. Mpala Altjirraka urrpia imankinya ntjarraka angkatja tnakeikanha? ");
INSERT INTO are_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mpala paka angkatja etnakanha tnakakalanga, mpala kaltja namara nhanha kala Kristakathaka nakala nyingalauwutjika. Ekuriperrantantama Altjirrala erinha ingkairnitjika Ingkartakngarra nitjika.” ");
INSERT INTO are_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kurunga Jesuala ekuratharra nentilaka Moses-aka pepa, Altjirraka urrpia imankinya ntjarraka pepa turta. Era erinhatharra ilaka Altjirraka Angkatja Imankinya ingkarraka ekuriperra angkamanga. ");
INSERT INTO are_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Etna kala Emmaus ekura etinyerrakalangantama, Jesuanha anpara lhitjikerraka. ");
INSERT INTO are_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kurtungurla eratharra pula erinha parraka, “Ilirnakalela kuterrai, kala ngurrangurrerrakalangantama.” Erantama ilthurna irrpunhaka, ekuratharralela kuterraka turta. ");
INSERT INTO are_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Etna kala marna ilkutjikerramangantama, Jesuala marna inaka, Altjirranha dangkilaka turta. Kurunga era marna erinha urltakamala, erinhatharra nthaka. ");
INSERT INTO are_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Eratharra erinha lhangkarakantama, Altjirrala alknga ekuratharra alkngampulhelakalanga warta. Jesua erantama yirralalhaka. ");
INSERT INTO are_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Eratharrantama pmarrarraka, “Yai, nhanga tjaiyala pitjimala, era kunha ilirnanha tjipatjipa inthorrilaka, ilirnaka Altjirraka Angkatja Imankinya erinha nentilamala?” ");
INSERT INTO are_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Eratharrantama kala kamerralalhakanta, Jerusalem-urna turta alpuka. Jerusalem-alantama eratharra kurtungurla 11 etnanha aritjalhaka, Jesuaka tjina arrpunha ntjarranha turta. ");
INSERT INTO are_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Relha nhanha etnantama erinhatharra ilaka, “Ingkartanha nthurrpa errilknga ntjarranga kamerraka, era turta Simon-aka ntelalhaka.” ");
INSERT INTO are_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Eratharrantama etnanha alpmelaka Jesuanha ekuratharralela Emmaus-urna lhakala. Eratharra etnanha alpmelaka turta, eratharra erinha ingkarnanta lhangkarakala era marna urltakamalanga. ");
INSERT INTO are_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Etna nhanga angkarramalangantema, Jesua erarrpantama etnakanga mpopala itnatjalhaka. Era etnanha ilaka, “Altjirranha rrakangkarra rilhera ntelalhama.” ");
INSERT INTO are_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lthana kula aramalakathana, etna yarna thakerraka, enkakunya inthorrerraka turta. ");
INSERT INTO are_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Era pula etnanha pmarraka, “Iwunhangama rrangkarra trerrama? Iwunhangama rrangkarra pmarralhama, ‘Ngunhama nhanha?’ ");
INSERT INTO are_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Iltja nukanha arai. Ingka nukanha arai. Yinga Jesua kunha nhanha. Yinganha iltjala mpaarai, rrangkarra lhangkaritjinanga nhanha yinga namanga, itja lthana. Lthana kunha itja yinga ngerra mpurrkakarta, tjalkakarta turta.” ");
INSERT INTO are_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Erantama etnaka iltja ekuranha, ingka ekuranha turta imarnaka. ");
INSERT INTO are_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Etna pula erinha yarna ngerrantema tnakaka, arrkana inthorra wulhamala, yarna etarlaramala turta. Lakinhanga era etnanha pmarraka, “Rrakangkarra paka ilkutjika intamama?” ");
INSERT INTO are_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Etnantama erinha kara irrpannga urnma nthaka. ");
INSERT INTO are_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Erantama nhanha etnakanga alkngatharra ilkuka. ");
INSERT INTO are_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jesuala etnanha ilaka, “Yinga nhanga rrakangkarralela namalangantema, atha rrangkarranha alpmelaka, angkatja Moses-alala nukiperra alpmelakala, angkatja Altjirraka urrpia ntjarralala nukiperra alpmelakala, psalm-ala turtala nukiperra alpmelakala, angkatja nhanha ingkarrakataka nthurrperritjika.” ");
INSERT INTO are_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kurunga era Altjirraka Angkatja Imankinya erinha etnaka nentilaka, etna nhanha arratja lhangkaritjinanga. ");
INSERT INTO are_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Era etnanha ilaka, “Arai, Altjirraka Angkatja Imankinyala ilama, Kristakathaka nakala nyingalauwutjika, arlta tharraminyintala turta errilknga ntjarranga kamerritjika. ");
INSERT INTO are_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Altjirraka Angkatja Imankinyala turta ilama, relha ingkarrakanha ilitjika, etna Altjirrurna toperritjika, Altjirrala korna etnakanha iwutjinanga. Lakinhanga Jerusalem-anga tjontamala, ");
INSERT INTO are_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","rrangkarra relha ingkarrakanha nhanha ilitjika, rretnya nukanhala. ");
INSERT INTO are_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Arai, Kaarta nukanhala kunha rrangkarranha Enka Alkngaltara erinha lhelakala. Atha erinha kala rrakangkarrurna yairnitjinantama. Rrangkarrantama Jerusalem-ala kaaralhitjika, Enka erarrka alkiranga pitjitjinanga rrangkarranha ekarltilitjinanga.” ");
INSERT INTO are_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesuala kurtungurla ekuranha ntjarranha Bethany-urnantama rretjingaka. Kurunga iltja ekuranha kartninyilamala, era etnanha lyekarrilaka. ");
INSERT INTO are_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kurunga era etnanha lyekarrilamangantema, era alkirakerraka. ");
INSERT INTO are_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Erinha tnantjamala, kurtungurla etna kala Jerusalem-urna alpuka, arrkana inthorra. ");
INSERT INTO are_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Etnantama arltamarlta temple-urna lhaka, Altjirranha tnantjaka turta. ");
INSERT INTO are_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tjontintjala Angkatja era naka. Angkatja era Altjirralela naka. Angkatja era Altjirra naka. ");
INSERT INTO are_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tjontintjala Angkatja era Altjirralela naka. ");
INSERT INTO are_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Angkatja nhanharlarlanganta Altjirrala relhalka, alhalka, alkiralka ingkarraka arrpmarnaka. ");
INSERT INTO are_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Angkatja era etatha naka. Angkatja etatha era turta relhaka parrtja ngerra naka. ");
INSERT INTO are_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Parrtja nhanha erantama pmara thapathapala parrtjaka. Relha etnala pmara thapathapala nakala, etna parrtja erinha yarna ilurnaka. ");
INSERT INTO are_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Altjirrala artwa nyintanha relha ntjarrurna yairnaka. Artwa nhanha ekura rretnya naka John. ");
INSERT INTO are_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Erantama relha ntjarrurna pitjika, etnanha parrtja nhanha ekuriperra alpmelitjika. Kurunga etna parrtja ekuriperra wumalanga, etna Altjirranha tnakitjinanga. ");
INSERT INTO are_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","John-anha itja parrtja nhanha era naka. Era relha ntjarranha parrtja ekuriperra alpmelakanta. ");
INSERT INTO are_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Era etnanha lakinha alpmelaka. “Parrtja inthorra era, erala relha ingkarrakanha parrtjilhelama, era alhurna pitjitjina.” ");
INSERT INTO are_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Arai, Angkatja era alhala naka, relha alharinya ntjarralela, etnanhala era arrpmarnakala. Relha alharinya ntjarrala pula erinha itja lhangkaraka. ");
INSERT INTO are_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Era relha ekuranha ntjarrurna pitjika. Etna pula ekura antjakunyala naka. ");
INSERT INTO are_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kanha relha etnala erinha tnakaka, etnanha era ilaka, “Rrangkarra Altjirraka katjiantama nama.” ");
INSERT INTO are_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Relha nhanha etna Altjirraka katjierraka, Altjirra erarrpa antja nakalanga etna katjia ekuranha nitjika. Itja relha antja nakalanga. ");
INSERT INTO are_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Angkatja erantama mpurrkakarterraka, nurnakalela narlalpuka turta. Nurna araka era makalaria inthorra namanga, nhanga Kaartaka 'Lira nyintantala makalaria inthorra namanga ngerra. Era ngwanga inthorra, arratja inthorra turta naka. ");
INSERT INTO are_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John-ala relha ntjarranha ekuriperra ilaka, “Nhanha kunha artwa era, ekuriperrala atha nhanga rrangkarranha ilakala. ‘Artwa erala nukanga ingkarna pitjima, era kunha nukanga kngarralkura nama. Era naka yinga itjantema namanga.’” ");
INSERT INTO are_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Era ngwanga inthorra namanga, era nurnaka ingkarrakaka arltamarlta ngwanga ntelalhama. ");
INSERT INTO are_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Altjirrala nhanga relha ntjarranha turnintja ekuranha ilaka Moses-arlarlanga. Era pula nurnaka ngwanga ntelalhaka, nurnanha angkatja nthurrpa erinha turta ilaka, Jesua Kristarlarlanga. ");
INSERT INTO are_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Arai, relha nyintala itja kuta Altjirranha araka paka. Kala 'Lira nyintanta ekuranhala, erala ekuralela kuta namanga, eranta Altjirranha araka. Erantama Altjirranha nurnaka imarnaka. ");
INSERT INTO are_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Relha Jew-aka itornka ntjarra, etnala Jerusalem-ala nakala, etna priest ntjarranha, Temple-aka urrkapunhapunha ntjarranha turta John-urna yairnaka erinha pmarritjika, “Ngunhama unta?” John-ala etnanha lakinha ilaka. ");
INSERT INTO are_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Era itja orrtjerraka. Era etnanha kala arratja inthorra ilaka, “Yinga itja Krista era nama.” ");
INSERT INTO are_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Etnantama erinha pmarraka, “Ngunhantama unta? Elijah-anha?” Era etnanha alpmelaka, “Itja.” Etna erinha wotha pmarraka, “Unta Altjirraka urrpia nhangama nama?” Era etnanha alpmelaka, “Itja.” ");
INSERT INTO are_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Etna erinha wotha pmarraka, “Ngunhantama unta? Nurnanha ilai, nurna artwa nhanga ntjarranha ilitjinanga, etnala nurnanha ungkwangurna yairnakala. Ngunhama unta?” ");
INSERT INTO are_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John-ala etnanha Isaiah-aka angkatjala ilaka, “Yinga nama relha erala worritjala ilkama, ‘Ingkartaka tjaiya arratja urrkapai.’” ");
INSERT INTO are_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Artwa Pharisee urrputja turta pitjikala. ");
INSERT INTO are_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Etnantama erinha pmarraka, “Iwunhangantama unta relha ntjarranha kaltjirrpulhelama? Unta itja Krista era nama, Elijah-anha paka, Altjirraka urrpia arrpunha nhanga paka.” ");
INSERT INTO are_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John-ala etnanha ilaka, “Atha relhanha kwatjalanta kaltjirrpulhelama. Artwa nyinta kala nhanhala nama. Rrangkarra pula ekura kotnala. ");
INSERT INTO are_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Era kunha nukanga ingkarna pitjima. Yinga turta itja yalknga nama sandal ekuranha paka ilutjika.” ");
INSERT INTO are_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","John-anha lakinha angkaka Bethany-ala, era Jordan Lhiranga ekngarrampinyala relha ntjarranha kaltjirrpulhelamalanga. ");
INSERT INTO are_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Arlta arrpunhala John-ala Jesuanha araka urlarra pitjimanga. Erantama relha ntjarranha ilaka, “Arai, artwa nhanha kunha Altjirraka Lamb. Era relha ingkarrakaka korna iwuma. ");
INSERT INTO are_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Artwa nhanha ekuriperra kunha atha nhanga rrangkarranha ilakala, ‘Artwa erala nukanga ingkarna pitjima, era kunha nukanga kngarralkura nama. Era naka yinga itjantema namanga.’ ");
INSERT INTO are_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Atha pula erinha itjarrka lhangkaraka. Nukathaka naka erinha Israel-arinya ntjarraka imarnitjika. Nhanga erinha imarnitjika kunha yinga pitjikala. Nhanhakakwia turta atha relha ntjarranha kwatjala kaltjirrpulhelaka.” ");
INSERT INTO are_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","John-ala etnanha nhanha turtantama alpmelaka, “Arai, atha Enka erinha araka ekururna pitjimanga, nturrurta ngerra, ekuralela kuterramanga turta. ");
INSERT INTO are_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Atha erinha itjarrka lhangkaraka. Altjirrala yinganha yairnaka relha ntjarranha kwatjala kaltjirrpulhelitjika. Era yinganha lakinha ilaka, ‘Unta aritjina Enka era artwa nyinturna pitjimanga, ekuralela kuterramanga turta. Artwa nhanhala relha ntjarranha Enka Alkngaltarala kaltjirrpulhelitjina.’ ");
INSERT INTO are_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Athantama erinha araka. Yinga turtantama kaltja artwa nhanha era Altjirraka 'Lira namanga.” ");
INSERT INTO are_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Arlta arrpunhala John-anha Bethany-ala nakantema, Jordan Lhiranga ekngarrampinyala. Kurtungurla tharra ekuranha, ekuralela nakantema. ");
INSERT INTO are_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","John-alantama Jesuanha anpara lhamanga araka. Erinha aramala era angkaka, “Arai, artwa nhanha kunha Altjirraka Lamb.” ");
INSERT INTO are_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kurtungurla eratharra John-anha wuka era lakinha angkamanga. Eratharrantama Jesuanga tnaartangala lhaka. ");
INSERT INTO are_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ilkngaralhamala, Jesuala erinhatharra araka ekuranga tnaartangala pitjimanga. Erantama erinhatharra pmarraka, “Iwunhakama mpala antja?” Eratharra angkaka, “Rabbi,” (nhanhatitja “Kaltjinthanhinthanhai”), “pmara nthanhalama unta intama?” ");
INSERT INTO are_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Era erinhatharra ilaka, “Aritjika pitjai.” Eratharrantama ekuralela lhaka, pmara ekuranhurna. Eratharrantama ekuralela kuterraka, kala ngurrangurrerrakalanga warta. ");
INSERT INTO are_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kurtungurla eratharrala John-anha wukala, Jesuanga tnaartangala lhakala turta, ekuratharranga nyinta naka Andrew, Simon Peter-aka tjia. ");
INSERT INTO are_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ingutnhalantama Andrew-anha parrpa lhaka kalya ekuranha Simon-aka yonthitjika. Erinha arltaramala era erinha ilaka, “Arai, nurnataka Messiah erinha araka.” (Nhanhatitja Krista erinha.) ");
INSERT INTO are_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Erantama Simon-anha Jesuurna rretjingaka. Simon-anha intarra aramala, Jesuala erinha ilaka, “Unta kunha rretnya Simon. Unta John-aka 'lira nama. Atha pula nganha rretnya Cephas-ala alpmelama.” (Nhanhatitja Peter.) ");
INSERT INTO are_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Arlta arrpunhala Jesuanha antja naka Galilee-urna lhitjika. Lhapalhamala era Philip-anha araka, erinha ntangkaka turta, “Nukanga tnaartangala pitjai!” ");
INSERT INTO are_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip era pmara Bethsaida-arinya naka. Andrew, Peter tharra turta town lenharinya nakantema. ");
INSERT INTO are_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip-alantama Nathanael-aka yonthaka. Erinha arltaramala era erinha pmarraka, “Unta ilpangkamama artwa ekuriperra Moses-ala intalhelakala, Altjirraka urrpia imankinya ntjarrala turta? Era nama Jesua, Joseph-aka 'lira, pmara Nazareth-arinya.” ");
INSERT INTO are_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael-ala pula erinha pmarraka, “Artwa marra Nazareth-anga pitjimarama?” Philip-ala erinha ilaka, “Kala aritjikanta pitjai.” ");
INSERT INTO are_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesuala Nathanael-anha aramalanga urlarra pitjimanga, era ekuriperra angkaka, “Artwa nhanha kunha Israel-arinya ilporatha nama, pmathakunya turta.” ");
INSERT INTO are_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael-ala erinha pmarraka, “Nthakinhala unta nuka kaltja naka?” Jesuala erinha ilaka, “Atha nganha arrkurlantema araka unta tjurrkaka ntolyala namanga, Philip-ala nganha ntangkitjikanhangantema.” ");
INSERT INTO are_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael-alantama erinha alpmelaka, “Kaltjinthanhinthanhai, unta Altjirraka 'Lira nama, Israel-aka king turta.” ");
INSERT INTO are_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesuala erinha ilaka, “Unta kunha yinganha lyarta tnakama atha nganha ilakalanga, atha nganha arakala tjurrkaka ntolyala namanga. Arai, anma unta aritjina atha tjatjikarta kngarra urrkapumanga.” ");
INSERT INTO are_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Erantama erinha ilaka, “Atha nganha nthurrpa inthorra ilama. Rrangkarra alkira erinha aritjina, Altjirrala altjurilakala, angel etnanha turta Relhaka 'Liranga ntjinhamanga, ekururna tnanpentjimanga turta.” ");
INSERT INTO are_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Arlta tharriperrantama, relha ntjarra Cana-ala, pmara Galilee-ala worlerraka mpanyakanha tjinkarraka. Jesuaka mia etnakalela nakantema. ");
INSERT INTO are_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesuanha, kurtungurla ekuranha ntjarra turta nakantema, tjinkarraka itornkala etnanha ntangkakalanga warta. ");
INSERT INTO are_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wine etnaka yirraka. Jesuaka mialantama Jesuanha ilaka, “Arai, wine etnaka yirrakau!” ");
INSERT INTO are_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesuala pula erinha ilaka, “Arrkutjai, nhanha itjama ungkwangathaka nama. Anma yinga kala ntelalhitjina yinga Altjirraka 'Lira namanga.” ");
INSERT INTO are_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesuaka miala pula urrkapunhapunha ntjarranha ilaka, “Arai, era paka rrangkarranha turnamanga, rrangkarra kala ekura kangkwanterrai.” ");
INSERT INTO are_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Relha Jew ntjarra kutatha ilkngilhitjata mpaarangaranga etnakanhamalkura. Nhanga relha ilkngilhitjinanga, iltha lenhala irna kwatjakanha kngarritja 6 itnaka. Nyintaminyintaka relhala 100 litres ngerra kwatja thalamara, irna erinha lyulpalyulpilitjika. ");
INSERT INTO are_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesualantama urrkapunhapunha ntjarranha turnaka, “Irna kwatjakanha nhanha ntjarra kwatjakarta lyulpalyulpilarrirrai.” Etnantama irna etnanha kwatjakarta lyulpalyulpa inthorrilaka. ");
INSERT INTO are_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kurunga era etnanha ilaka, “Kwatja kurrka thankumala rrangkarra nhanha itornka rrakangkarrurna kngai, arrkarnitjika.” Etnantama kwatja kurrka itornka etnakanhurna kngaka. ");
INSERT INTO are_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Itornka erantama kwatja wine-errakala erinha arrkarnaka. Urrkapunhapunha etnanta kaltja naka etna wine erinha irna kwatjakanhanga inakala. Itornka era pula nhanhaka itjala kaltja naka. Erantama artwa noa inakala ekura ntangkalhaka. ");
INSERT INTO are_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Era erinha ilaka, “Arai, relhala kunha wine marralkuranhakimparra ntjutjika nthama. Kurunga relha ingkarrakala kala wine kngarra ngerra ntjukalanga, wine kornakornalkura erinhantama. Kanha unta, unta wine marra inthorra erinha lauwukala.” ");
INSERT INTO are_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesuala tjatjikarta arrkurlinya nhanha ekuranha urrkapuka, Cana-ala, pmara Galilee-ala. Lakinha era ntelalhaka, era makalaria namanga. Kurtungurla ekuranha ntjarrala turtantama erinha tnakaka. ");
INSERT INTO are_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ekuriperra Jesuanha Capernaum-urna lhaka. Mia ekuranha, kanhanganhanga ekuranha, kurtungurla ekuranha ntjarra turta, ekuralela lhakantema. Etnantama Capernaum ekurala arlta urrputja kuterraka. ");
INSERT INTO are_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Relha Jew ntjarraka Passover-aka ilpangkintjaka arlta lyartathakantema naka. Jesuanha pula mparrama Jerusalem-urna lhaka, Passover erinha anma ilkutjinala. ");
INSERT INTO are_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Erantama araka relha ntjarra temple yard-ala bullock, sheep, nturrurta turta yirrinthamanga. Arrpunha ntjarrala turta money twetakatweta ekngarrpunhilamanga. ");
INSERT INTO are_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesualantama whip mpaaraka rope-anga. Kurunga era artwa etnanha temple yard-anga tnalhaka, sheep etnakanhakarta, bullock etnakanhakarta turta. Artwa money ekngarrpunhilanha ntjarraka table era ankartiwuka, money etnakanha turta iwurlenaka. ");
INSERT INTO are_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Erantama nturrurta yirrinthanhinthanha ntjarranha ilaka, “Nturrurta nhanha ntjarra kathurna kngai. Rrangkarra itja Kaarta nukanhaka ilthala relha ntjarraka yultha yirrinthitjika.” ");
INSERT INTO are_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kurtungurla ekuranha ntjarrantama ilpangkaka Altjirraka Angkatja Imankinya nhangaka, “Altjirrai, yinga iltha ungkwanganhanga mukunherrama.” ");
INSERT INTO are_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Relha Jew ntjarralantama Jesuanha ilaka, “Tjatjikarta nurnaka urrkapai, nurna kaltja nitjina ungkwangathaka namanga yirrinthanhinthanha ntjarranhalka temple-anga unputjika.” ");
INSERT INTO are_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesuala etnanha alpmelaka, “Temple nhanha erinha urltakai, kurunga atha erinha arlta tharraminyintala wotha ititjina.” ");
INSERT INTO are_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Relha Jew etna pula erinha ilaka, “Etnataka 46 years urrkapuka temple nhanha ititjika. Kanha unta erinha arlta tharraminyintalala ititjina? Itjanga lhai.” ");
INSERT INTO are_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesuanha pula temple arrpunhiperrala angkaka, nhanga mpurrka ekuranhiperra. ");
INSERT INTO are_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Anma, Altjirrala erinha errilknga ntjarranga kamalhelakalanga, kurtungurla ekuranha ntjarra angkatja ekuranhaka ilpangkakantama. Kurunga etna Altjirraka Angkatja Imankinya tnakaka, Jesuaka angkatja turta. ");
INSERT INTO are_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesuanha Jerusalem-ala namalanga Passover-aka, era tjatjikarta kngarra urrkapuka. Nhanhakakwia relha ntjarrala erinha tnakaka. ");
INSERT INTO are_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesuala pula lhangkaraka etna erinha tjatjikartakakwia wara tnakamanga. Lakinhanga era etnanha ilpoiwuka. ");
INSERT INTO are_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jesuanha kunha relha ingkarrakaka kaltja naka, eterrintja etnakanhaka turta. ");
INSERT INTO are_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Relha Jew ntjarraka itornka arrpunha naka rretnya Nicodemus. Era Pharisee turta naka. ");
INSERT INTO are_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Era Jesuurna ingula pitjika. Era erinha ilaka, “Kaltjinthanhinthanhai, nurna kaltja Altjirrala nganha nurnakurna yairnakala, nurnanha kaltjinthitjika. Nurna turta kaltja Altjirralanta relhanha ekarltilama tjatjikarta urrkaputjika.” ");
INSERT INTO are_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesuala Nicodemus-anha ilaka, “Arai, atha nganha nthurrpa inthorra ilama. Relha paka antja namanga Altjirraka tjina nitjika, era wotha alkngerritjikarrka.” ");
INSERT INTO are_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus-ala pula erinha ilaka, “Relha yarna tharraranga alkngerrama. Relha kalala mangkakala, era yarna wotha katjia intama.” ");
INSERT INTO are_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesualantama erinha ilaka, “Arai, atha nganha nthurrpa inthorra ilama. Relha era wotha alkngerritjikarrka Enka Alkngaltararlarlanga, kwatjarlarlanga turta. Kurunga era Altjirraka tjina nitjina. Kurunga Altjirranha Ingkarta ekura turta nitjina. ");
INSERT INTO are_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Etarlarai, relha kaarta miangala alkngerrakala, era relha alharinya wara nama. Kanha relha erala Enka Alkngaltararlarlanga alkngerrakala, era enka lyartinyakartantama nama. Enka nhanha Altjirraka kangkama. ");
INSERT INTO are_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Lakinhanga unta itja tnolkitjika atha nganha ilakalanga, “Rrangkarra wotha alkngerritjika.” ");
INSERT INTO are_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Etarlarai, wurinyala warnamalanga, unta wurinya erinha yarna arama. Unta irnalka ngalhamanganta arama. Unta wurinya erinha yarnantema turnama, ‘Ekngarranga pitjai, altorlanga paka.’ Lakinha ngerra relhala Altjirraka Enka erinha yarna arama, Enkala relhanha lyartinyilamalanga.” ");
INSERT INTO are_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus-ala pula erinha pmarraka, “Nthakinha inthorrantama Enkala relhanha lyartinyilama?” ");
INSERT INTO are_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesuala erinha ilaka, “Unta nhanhaka itjala kaltja, unta relha Israel-arinya ntjarraka kaltjinthanhinthanha kngarra namangatanya? ");
INSERT INTO are_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Atha nganha nthurrpa inthorra ilama. Nurna kunha rrangkarranha alpmelama nurnala kaltja namalaka. Nurna turta rrangkarranha alpmelama nurnala arakala. Iwunhangantama rrangkarra angkatja nurnakanha itja tnakama? ");
INSERT INTO are_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Atha rrangkarranha wurinyiperralka alpmelaka. Rrangkarra pula yinganha itja tnakaka. Thunga atha rrangkarranha Enkiperrantama kaltjinthama. Rrangkarra paka yinganha tnakitjina? Itja kunha. ");
INSERT INTO are_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Arai, relha nyinta itja alkirala naka paka, Relhaka 'Lira eranta. Erantama alkiranga alhurna pitjika. ");
INSERT INTO are_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses-anha worritjala namalanga era apma nhanga irna tjenyaka arrarnamala, tjurnaka, Altjirrala erinha turnakalanga. Lakinha ngerra etna Relhaka 'Lira erinha turta irnaka arrarnamala, tjurnitjinantema. ");
INSERT INTO are_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kurunga relha etnala erinha tnakamanga, etna Altjirralela ngampakala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Altjirranha kunha relha alharinya ntjarraka kngarra inthorra kangkaka. Lakinhanga era 'Lira nyintanta ekuranha alhurna yairnaka, etna erinha errilknga tutjika. Kurunga relha etnala 'Lira erinha tnakama, etna itja kutantaka ilutjina. Etna pula Altjirralela ngampakala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Altjirrala kunha 'Lira ekuranha relha alharinya ntjarrurna yairnaka, etnanha tangkalhelitjika, itja etnanha imilitjika. ");
INSERT INTO are_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Lakinhanga relha erala Altjirraka 'Liranha tnakamanga, Altjirrala erinha itja imilitjina. Kanha relha era, erala erinha itja tnakamanga, Altjirrala erinha kala imilakala. Altjirrala erinha imilaka, era Altjirraka 'Lira nyintanta erinha itja tnakakalanga. ");
INSERT INTO are_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Altjirraka Parrtja era relha alharinya ntjarrurna pitjika. Relha etna pula Parrtja nhanhaka antjakunyala naka. Relha etna antja naka korna kuta ntelalhitjika, etnarrpa korna namanga warta. ");
INSERT INTO are_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Arai, relha erala korna kuta ntelalhama, era kunha Altjirraka Parrtjaka antjakunya. Era itja Parrtja nhanhaka kangkama, Parrtjala kathilamanga era relha kornarintja namanga. ");
INSERT INTO are_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Relha era pula, erala arratja ntelalhama, era Altjirraka Parrtjaka kangkamala, Parrtjala kathilamanga era Altjirranga urlarra relha arratja namanga.” ");
INSERT INTO are_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Anma, Jesuanha, kurtungurla ekuranha ntjarra turta pmara Judea-urna lhaka. Jesuanhantama pmara ekurala kuterraka, kurtungurla ekuranha ntjarralela. Etna relha ntjarranha kaltjirrpulhelaka turta. ");
INSERT INTO are_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","John-ala turta relha ntjarranha kuta kaltjirrpulhelakantema pmara Aenon-ala, pmara Salim-anga etinya. Erataka pmara nhanhala relha ntjarranha kuta kaltjirrpulhelaka, kwatja kngarra pmara ekurala namanga. Relha ntjarra John-urna pitjitjata, era etnanha kaltjirrpulhelitjika. ");
INSERT INTO are_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Herod-alataka John-anha itjantema jail-aka kurnakala.) ");
INSERT INTO are_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","John-aka kurtungurla ntjarrantama artwa Jew nyintalela iwurraka, ilkngilhintjiperra. ");
INSERT INTO are_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Etnantama John-urna lhamala erinha ilaka, “Kaltjinthanhinthanhai, unta artwa nhanganha etarlaramama? Era nhanga ungkwangalela nakala Jordan-anga urntwarrampinyala. Unta turta relha ntjarranha ekuriperra kaltjinthakala. Erataka relha ntjarranha lyarta kaltjirrpulhelamantama, relha ntjarra turta ekururna lhama.” ");
INSERT INTO are_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John-ala etnanha ilaka, “Relha etna ekururna lhama, Altjirrala etnanha ekururna yairnakalanganta wara. ");
INSERT INTO are_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Rrangkarra kala kaltja. Atha nhanga rrangkarranha ilaka. Yinga itja Krista era nama. Yinga artwa era nama Altjirralala Kristanga arrkurla yairnakala. ");
INSERT INTO are_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Arai, artwa erinhala ampa ekuranhala kwarra ekuranha lhelakala, artwa eranta kunha kwarra erinha noa inama. Itja tjina ekuranhalalka. Tjina ekura pula kala kangkamantala, era aramalanga tjina ekuranhala noa inamanga. Lakinha ngerra yinga turta Jesuaka kangkama. ");
INSERT INTO are_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Relha ntjarralataka Jesuanha kngarralkura tnantjitjika, nukangatjina.” ");
INSERT INTO are_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Relha erala alkiranga pitjima, era kala relha ingkarrakaka Ingkarta nama. Relha erinhala Altjirrala arnanga mpaarakala, era arnarinya wara nama. Era marniperranta, yulthiperranta turta eterrama. Relha erala alkiranga pitjima, era kala relha ingkarrakaka Ingkarta nama. ");
INSERT INTO are_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Relha erala alkiranga pitjima, era Altjirraka kaltja. Era turta relha ntjarranha Altjirriperra kaltjinthama. Relha ntjarrala pula angkatja ekuranha itjala tnakama. ");
INSERT INTO are_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Relha era pula, erala angkatja ekuranha tnakama, era relha arrpunha ntjarranha ilama, “Altjirraka angkatja nthurrpa arratja nama.” ");
INSERT INTO are_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Arai, relha erinhala Altjirrala yairnakala, era kala relha ntjarranha Altjirraka angkatja ilama, era Altjirraka Enkakarta namanga. ");
INSERT INTO are_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kaarta era kunha 'Lira ekuranhaka kangkama. Era turta 'Lira erinha ingkairnaka relhaka, alhaka, alkirakalka Ingkarta nitjika. ");
INSERT INTO are_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Relha erala 'Liranha tnakama, era ngampakala etatha nitjina. Kanha relha erala 'Lira erinha itja tnakama, era itjala ngampakala etatha nitjina. Altjirrala erinha kala imilaka. ");
INSERT INTO are_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesuanha kaltja naka artwa Pharisee ntjarrala wukala relha ntjarralkura ekururnantama pitjimanga, John-angatjina, era turta kula relha ntjarralkura kaltjirrpulhelamanga, John-angatjina. ");
INSERT INTO are_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jesua erarrpataka itja relha ntjarranha kaltjirrpulhelaka. Kurtungurla ekuranha ntjarralatitja relha etnanha kaltjirrpulhelaka. ");
INSERT INTO are_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Lakinhanga Jesuanha wotha pmara Galilee-urna alpuka, pmara Judea-angatjina. ");
INSERT INTO are_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Judea-anga Galilee-urna alpumala, Jesuanha pmara Samaria-anga tjananhaka. ");
INSERT INTO are_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Erantama town nyinturna pitjika, rretnya ekura Sychar. Sychar ekuranga etinya wara tnukulpa nyinta naka, Jacob-alala worra ekuranha Joseph-anha nthakala. ");
INSERT INTO are_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob-aka ngarroa turta pmara ekurala nakantema. Jesuanhantama ngarroa ekuranga kutaka arrarnalhaka, porrka inthorra, tjaiya ilanga pitjikala. Kala ngkinya naka. ");
INSERT INTO are_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Arrkutja Samaria-arinya nyintantama pitjika ngarroanga kwatja thankutjika. Jesuanha ekura enkaka, “Yinganha kwatja ntjutjika nthai.” ");
INSERT INTO are_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kurtungurla ekuranha ntjarrataka itja ekuralela naka, era arrkutja ekura enkamalanga. Etnataka town-urna lhakala marna initjika. ");
INSERT INTO are_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Arrkutja era pula erinha ilaka, “Unta kunha artwa Jew, kanha yinga arrkutja Samaria-arinyala. Nthakinhantama unta nuka kwatjaka enkama?” (Relha Jew ntjarralataka itja inthorra marna ilkutjata relha Samaria-arinya ntjarralela, yia paka etnakalela angkarritjata.) ");
INSERT INTO are_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesuala erinha alpmelaka, “Unta itja kaltja Altjirranha ungkwanga kangkintja ntelalhitjika antja. Unta turta artwa ekura itja kaltja, erala ungkwangurna angkamanga. Unta paka kaltja nakalanga, unta ekuratitja kwatjaka enkamara. Erantama nganha kwatja etatha nthamara.” ");
INSERT INTO are_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Arrkutja era pula erinha ilaka, “Itornkai, ungkwanga pula irna kwatja thankutjika itjala, ngarroa nhanha turta iparta inthorra. Nthanhangantama unta kwatja etatha erinha initjina? ");
INSERT INTO are_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Arai, errilkngipata nurnakanhala, Jacob-ala, ngarroa nhanha nurnaka tnyaka. Era, worra ekuranha ntjarrala, tnontha ekuranha ntjarrala turta, ngarroa nhanhanga kwatja ntjutjata. Nthakinhantama? Unta Jacob-anga kngarralkurama nama?” ");
INSERT INTO are_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesuala erinha alpmelaka, “Relha erala ngarroa nhanhanga kwatja ntjuma, era wotha angkathalerritjinantema. ");
INSERT INTO are_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Relha era pula, erala kwatja lenha ntjumanga athala erinha nthitjina, era itja wothala angkathalerritjina. Kwatja lenha athala erinha nthitjina, erataka ekura kwanala pentja ngerra nitjina. Kwatja nhanha itja yirritjina. Relha erala kwatja nhanha ntjuma, era ngampakala etatha nitjina.” ");
INSERT INTO are_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Arrkutja era erinha ilaka, “Itornkai, yinganha kwatja lenha erinha nthai. Yingantama itja wotha angkathala nitjinanga. Yinga turta itja wotha arltamarlta nhanhurna pitjitjinanga, kwatjaka.” ");
INSERT INTO are_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesuala erinha alpmelaka, “Artwa noa ungkwanganha ntangkai, ekurakarta turta pitjalpai.” ");
INSERT INTO are_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Era pula erinha ilaka, “Yinga itjama noakarta.” Jesuala erinha alpmelaka, “Unta kala arratja ilalhaka unta noakunya namanga. ");
INSERT INTO are_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Unta kala noa 5 tnyinakala. Artwa lenha, ekuralelala unta lyarta nama, era itja noa ungkwanga nama. Unta kala arratja kuta ilalhaka unta noakunya namanga.” ");
INSERT INTO are_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Arrkutja era erinha ilaka, “Itornkai, yinga kala kaltjantama unta Altjirraka urrpia namanga. ");
INSERT INTO are_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Relha Samaria-arinya errilkngipata nurnakanha ntjarra, etna Altjirraka urrkurrkintja nitjata parta kngarra nhanhala. Relha Jew rrangkarra pula angkama Jerusalem-alanta kula relha Altjirraka urrkurrkintja nitjika.” ");
INSERT INTO are_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesuala erinha alpmelaka, “Arrkutjai, yinga nhanha arratja angkama. Anma relha itja Kaartaka urrkurrkintja nitjina parta nhanhala, Jerusalem-ala paka. ");
INSERT INTO are_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria-arinya rrangkarra, rrangkarra marntilparla wara urrkurrkintja nama. Kanha relha Jew nurna, nurna Altjirra ekura kaltjala, ekurala nurna urrkurrkintja namanga. Relha Jew nurnakanga kunha Altjirraka tangkalhelanha era pitjitjina. ");
INSERT INTO are_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Arai, lyartanga Enka Alkngaltarala relha ntjarranha lyartinyilitjina, etnanha arratja Altjirriperra kaltjinthitjina turta. Kurunga etna Kaartaka arratja urrkurrkintja nitjina, Kaartanhala antja namanga ngerra. ");
INSERT INTO are_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Altjirra erataka Enka nama. Relha ekuranha ntjarrakathakantama nama ekura arratja urrkurrkintja nitjika, Enkala etnanha kaltjinthakala ngerra.” ");
INSERT INTO are_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Arrkutja era erinha ilaka, “Yinga kaltja Messiah era pitjitjina, erinhala nurna Krista ilama. Era turta nurnanha Altjirriperra arratja kaltjinthitjina.” ");
INSERT INTO are_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesuala erinha alpmelaka, “Yingala nhanha ungkwangurna angkama, yinga kunha era.” ");
INSERT INTO are_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jesuanha arrkutja ekururna angkamalangantema, kurtungurla ekuranha ntjarra pitjalpuka. Etna aramalanga era arrkutja Samaria-arinyalela angkarramanga, etna kngarra inthorra tnolkaka. Etna pula Jesuanha itja pmarraka, “Iwunhama unta erinha pmarrama? Iwunhanga turtama unta arrkutja nhanhalela angkarrama?” ");
INSERT INTO are_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Arrkutja erantama kwatjakanha jar ekuranha impurlalhamala, town-urna alpuka. Erantama pmararinya ntjarranha ilaka. ");
INSERT INTO are_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Artwa nyintanha aritjika pitjai. Erataka nuka kaltja. Era turta yinganha noa nukanha ntjarriperra alpmelaka. Artwa nhanha erama Krista era?” ");
INSERT INTO are_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Relha etnantama town-anga Jesuurna lhaka. ");
INSERT INTO are_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Relha town-arinya etna tjaiyala pitjimalangantema, Jesuaka kurtungurla ntjarrala erinha thakalhelaka, “Kaltjinthanhinthanhai, marna ilkwai.” ");
INSERT INTO are_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Era pula etnanha ilaka, “Nuka kunha marna intama ekuriperrala rrangkarra kotna.” ");
INSERT INTO are_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kurtungurla ntjarrantama pmarrarraka, “Arrpunhalakwia erinha marna ilkutjika nthaka?” ");
INSERT INTO are_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesuala pula etnanha ilaka, “Kaarta nuka urrkapentjaka relha ntjarranha tangkalhelitjika. Erantama yinganha yairnaka urrkapuntja nhanha mangkilitjika. Yinga ekura kangkwerramalanga, nhanha kala nuka marna ngerra nama. ");
INSERT INTO are_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Rrangkarra nhanga marna annga ingkairnamalanga ilama, ‘Kala 4 months kaaralhamala, nurna marna erinha kotjitjinantama.’ Atha rrangkarranha ilama, Relha ingkarraka marna ngerra nama Altjirraka tnukulpala. Altjirraka tnukulpa erinhantama arai. Marna ingkarraka kala urnma inthorra, rrangkarra kala kotjitjikanta. ");
INSERT INTO are_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","“Lyarta artwala kala marna kotjima, Altjirraka tnukulpala. Nhanhatitja, era relha lenha ntjarranha worlilama Altjirrala urrarakala ekuralela ngampakala etatha nitjika. Altjirrala erinha kwartiwuma turta. Lakinhanga artwa erala marna annga etnanha ingkairnakala Altjirraka tnukulpala, artwa era turta, erala marna etnanha kotjikala Altjirraka tnukulpala, eratharra tharrantema arrkana nitjina. ");
INSERT INTO are_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Angkatja nhanha kunha arratja nama, ‘Artwa nyintala marna annga ingkairnama, artwa arrpunhala marna kotjima.’ ");
INSERT INTO are_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Atha rrangkarranha Altjirraka tnukulpurna yairnaka, marna kotjitjika. Rrangkarra pula Altjirraka tnukulpa ekurala itja arrkurla urrkapuka. Arrpunha ntjarra Altjirraka tnukulpa ekurala urrkapuka, rrangkarrantama urrkapuntja etnakanhiperra marna kotjima.” ");
INSERT INTO are_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Town ekurala, relha Samaria-arinya ntjarrala Jesuanha tnakaka arrkutja nhangala etnanha ilakalanga, “Erataka nuka kaltja nama. Era turta yinganha noa nukanha ntjarriperra alpmelaka.” ");
INSERT INTO are_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Lakinhanga etna Jesuurna pitjimaliperra, etna erinha yakalhelaka etnakalela kuterritjika. Jesuanhantama arlta tharra etnakalela kuterraka. ");
INSERT INTO are_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pmararinya etnarrpantama Jesuaka angkatja wuka. Etna erinha tnakaka turta. ");
INSERT INTO are_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Etnantama arrkutja erinha ilaka, “Nurna erinha tnakakarrka angkatja ungkwanganhakakwia. Lyarta pula nurna erinha tnakama nurnarrpa angkatja ekuranha wukalanga. Nurna turta kaltja era relha alharinya ntjarraka tangkalhelanha namanga.” ");
INSERT INTO are_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Arlta tharra relha Samaria-arinya ntjarralela namaliperra, Jesuanha pmara Galilee-urna anparerraka. ");
INSERT INTO are_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesuala arrpunharanga relha ntjarranha ilakala, “Relha arrpunha ntjarralanta kunha Altjirraka urrpia tnantjama. Kanha pmararinya ntjarrala erinha itja kutala tnantjama.” ");
INSERT INTO are_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilee-akerritjalhamala, pmararinya ntjarra ekura kangkaka. Galilee-arinya nhanha etnataka nhanga Jerusalem-urna lhakala, Passover-aka. Passover ekuralantama etna Jesuanha arakala tjatjikarta urrkapumanga. Lakinhanga etna ekura kangkaka. ");
INSERT INTO are_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesuanhantama Cana town-urna wotha alpuka. Town nhanhala kunha era nhanga kwatja turnakala wine-erritjika. Itornka nyinta Capernaum town-ala naka, worra mentakarta. Itornka nhanha erataka King Herod-aka urrkaputjata. ");
INSERT INTO are_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Artwa nhanha era wumalanga Jesuanha pmara Judea-anga pitjikala, era ekururna lhamala ingkaka, “Nukalela pitjai, worra nukanha marrilitjika. Erataka kala ilutjikerrama.” ");
INSERT INTO are_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesuala erinha ilaka, “Rrangkarra kunha yinganha tnakama, rrangkarra tjatjikartalka aramalanganta.” ");
INSERT INTO are_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Itornka era pula erinha alpmelaka, “Ingkartai, kala pitjantai, worra nuka ilukitjanga.” ");
INSERT INTO are_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesualantama erinha ilaka, “Kala alpai. Worra ungkwanga kunha kala marrerraka.” Artwa era Jesuaka angkatja tnakaka, era turta alpuka. ");
INSERT INTO are_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Era tjaiyala alpumalangantema, artwa urrkapunhapunha urrputja urlarra pitjika. Etna itornka etnakanha ilaka, “Worra ungkwanga marrerrakau.” ");
INSERT INTO are_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Erantama etnanha pmarraka, “Ilangara inthorrama era marrerraka?” Etna erinha alpmelaka, “Ngurruka kunha, ngkinyala.” ");
INSERT INTO are_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kaarta erantama ilpangkaka, ngkinya inthorrala Jesuala erinha ilakala, “Worra ungkwanga kala marrerrakau.” Artwa era, ramarama ekuranhala, urrkapunhapunha ekuranhala turtantama Jesuanha tnakaka. ");
INSERT INTO are_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nhanha kala tjatjikarta arrpunha era naka, Jesualala urrkapukala era nhanga pmara Judea-anga, pmara Galilee-urna pitjalpumaliperra. ");
INSERT INTO are_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kala anmantama, Jesuanha Jerusalem-urna lhaka, relha Jew ntjarraka ilpangkintjaka arlta kngarraka. ");
INSERT INTO are_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem-aka reoa arrpunha naka, ekurangala etna sheep ntjarra town-urna irrpulhelitjata. Reoa nhanha ekuranga kuta, ntjanga naka relhalala mpaarakala. Hebrew angkatjala etna ntjanga erinha rretnya ‘Bethesda’ alpmelitjata. Ntjanga ekuranga kaarntakaarntala lyuntja kngarritja 5 italhaka. ");
INSERT INTO are_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Lyuntja 5 nhanhala relha menta ntjarra inthorra intitjata, panga etna, inurra etna, thaarra etna turta. ");
INSERT INTO are_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Relha nhanha etnakanga, artwa arrpunha kala 38 years menta nakala. ");
INSERT INTO are_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesuala erinha intamanga araka, era turta wuka era kuta inthorra menta intakala. Erantama erinha pmarraka, “Unta paka marrerritjika antjama?” ");
INSERT INTO are_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Artwa menta era erinha alpmelaka, “Itornkai, nukataka tjina itja nama yinganha kwatjaka kurnitjika, kwatja erinha ngalhelakaliperra. Yinga nhanga kwatjaka irrputjikerramalangantema, relha arrpunha irrpuma.” ");
INSERT INTO are_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesuala erinha turnaka, “Kamerrai! Ntjama ungkwanganha inamala, kala ingka nthulapai!” ");
INSERT INTO are_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jesuanha angkamalangantema, artwa era kala marrerraka. Ntjama ekuranha inamala, era kala nthulapuka. Arlta ekuralala Jesuala artwa erinha marrilakala, erataka Sabbath arlta naka. ");
INSERT INTO are_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Lakinhanga relha Jew ntjarraka itornka ntjarrala, artwa marrerrakala erinha ilaka, “Lyarta kunha Sabbath arlta nama. Nhanhantama itja arratja nama unta ntjama ungkwanganha kngarlaputjika.” ");
INSERT INTO are_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Artwa era pula etnanha alpmelaka, “Artwa erala yinganha marrilakala, erataka yinganha turnaka, ‘Ntjama ungkwanganha inamala kala ingka nthulapai.’” ");
INSERT INTO are_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Etnantama erinha pmarraka, “Ngunhantama artwa nhanha era, erala nganha turnakala, ‘Ntjama ungkwanganha inamala kala ingka nthulapai?’” ");
INSERT INTO are_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Artwa marrerrakala era pula Jesuaka itja kaltja naka. Jesua erataka naamerralalhakala. ");
INSERT INTO are_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Anma, Jesuala artwa erinha temple-aka araka. Era erinha ilaka, “Arai, unta kala marrantama nama. Lyartanga itja wotha korna ntelalhai, menta kngarralkurala nganha tukitja.” ");
INSERT INTO are_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Artwa erantama relha Jew ntjarraka itornka ntjarrurna lhaka, etnanha ilaka turta, “Jesuala kunha yinganha marrilakala.” ");
INSERT INTO are_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Relha Jew ntjarraka itornkalantama Jesuanha errilknga tutjika antja naka, era relha ntjarranha Sabbath arltala marrilamanga. ");
INSERT INTO are_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesuala pula etnanha ilaka, “Kaarta nuka kuta urrkapuma, lyartalpula. Lakinhanga yinga turta urrkapumantema.” ");
INSERT INTO are_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Relha Jew ntjarraka itornka ntjarra, etnantama antja inthorra naka erinha errilknga tutjika. Iwunhanga? Era Sabbath arltala urrkapukalanga. Era turta angkakalanga Altjirranha Kaarta ekura namanga, era turta Altjirralela loala namanga. ");
INSERT INTO are_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesualantama etnanha ilaka, “Arai, atha rrangkarranha nhanha nthurrpa inthorra ilama. 'Lira era yarna nyinta urrkapuma. 'Lira era Kaarta ekuranha urrkapumanga arama. Kurunga era turta lakinhantema urrkapuma. Nhanga Kaarta erala urrkapumanga ngerra, lakinha 'Lira era turta urrkapumantema. ");
INSERT INTO are_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Arai, Kaarta era kunha 'Lira ekuranhaka kangkama. Lakinhanga era 'Lira ekuranha urrkapuntja ingkarraka ekuranha ntelama. Kaarta era turta 'Lira ekuranha urrkapuntja kngarralkura ntelitjina. Rrangkarrantama tnolkitjina. ");
INSERT INTO are_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kaartala relha errilknga ntjarranha kamalhelama, ngampakala etathilama turta. Lakinha ngerra 'Lira era turta relha lenha ntjarranha ngampakala etathilama, erala antja nama. ");
INSERT INTO are_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Arai, Kaarta era relhanha itja wotha tjiperrawuma, nhanhatitja, tangkalhelama, imilama paka. Era nhanha kala 'Lirakantama impuma. ");
INSERT INTO are_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Era antja nama relha ingkarrakala 'Liranha tnantjitjika, etnala erinha tnantjamanga ngerra. Kaarta era kunha 'Lira erinha alhurna yairnaka. Lakinhanga relha etnala 'Lira erinha itja tnantjama, etnataka Kaarta erinha turta itja tnantjama. ");
INSERT INTO are_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Atha rrangkarranha nhanha nthurrpa inthorra ilama. Thunga relhala angkatja nukanha wuma. Thunga turta era Kaarta erinha tnakama, erala yinganha yairnakala. Kaartala erinha itja imilitjina. Relha era itja wotha ilutjina. Era pula ngampakala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Atha rrangkarranha nhanha nthurrpa inthorra ilama. Lyartanga relha errilknga ntjarrala Altjirraka 'Liraka angkatja wutjina. Relha etnala angkatja nhanhaka kangkwerrama, etna kala ngampakala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kaarta erarrpa ngampakala etatha nama. Era turta 'Lira ekuranha ngampakala etathilaka. Kaarta era turta relhanha irrpalthala etathilama. Kaarta era turtantama 'Lira ekuranha ekarltilaka, era relhanha irrpalthala ngampakala etathilitjinanga. ");
INSERT INTO are_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kaarta era turta Relhaka 'Lira erinha ingkairnaka, era relha ingkarrakanha tjiperrawutjika, etnanha tangkalhelamala, imilamala paka. ");
INSERT INTO are_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Rrangkarra itja tnolkitjika. Anma relha wolkngala intamala ntjarrala 'Lira erinha wutjina, era etnanha ntangkamalanga. ");
INSERT INTO are_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Etnantama wolknga etnakanhanga rratitjina. Lenha ntjarra etnala arratja ntelalhakala, etna ngampakala etatha nitjina. Kanha arrpunha ntjarra etnala korna ntelalhakala, etnanha Altjirrala imilitjinala. ");
INSERT INTO are_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kaartala kunha yinganha alhurna yairnaka. Yinga yarna nyinta urrkapuma. Athantama relha ntjarranha tjiperrawuma, erala yinganha turnakala ngerra. Lakinhanga atha relhanha arratja tjiperrawuma, yinga ekuranta kangkwerramanga.” ");
INSERT INTO are_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Athanta paka rrangkarranha ilamanga yinga Altjirra Kaartaka 'lira namanga, rrangkarra angkatja nukanha itja tnakitjika. ");
INSERT INTO are_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kaartala turta pula rrangkarranha ilamanga yinga 'Lira ekura namanga, rrangkarra angkatja nukanha tnakitjikala. ");
INSERT INTO are_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Rrangkarra nhanga John-urna urrpia yairnaka. John erantama urrpia etnanha angkatja nthurrpa alpmelaka, nukiperra. ");
INSERT INTO are_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Atha itja John-aka angkatjiperra kngarra etarlarama. Atha pula rrangkarranha John-aka angkatjiperra ilpangkalhelama, rrangkarra yinganha tnakitjinanga, Altjirrala turtantama rrangkarranha tangkalhelitjinanga. ");
INSERT INTO are_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Altjirrala nhanga John-anha ingkairnaka lamp ngerra mpurlanamala relha ntjarranha parrtjilhelitjika. Rrangkarra turta kangkakarrka angkatja ekuranha wurlanitjika. ");
INSERT INTO are_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Kala yinganhantantama ararrirrai. Kaartala yinganha yairnakala urrkapuntja ekuranha mangkilitjika, nhanhatitja relha ingkarrakanha tangkalhelitjika. Yinga ekura kangkwerrama. Lakinhanga rrangkarra kaltja neikanha Kaartala yinganha yairnakala. ");
INSERT INTO are_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Kaarta era yinganha yairnaka. Angkatja erala nukiperra ilakala, era angkatja nthurrpa nama. Rrangkarra pula Kaarta erinha itja wuka paka, rrangkarra turta erinha itja alkngala araka paka. ");
INSERT INTO are_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Era yinganha rrakangkarrurna yairnaka. Rrangkarra pula yinganha itja tnakaka. Lakinhanga angkatja ekuranha itja rrakangkarralela kuterrama. ");
INSERT INTO are_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Rrangkarra Altjirraka Angkatja Imankinyaka ilporatha kaltjerrama. Rrangkarra eterrama angkatja etna kula rrangkarranha ngampakala etathilitjinala. Angkatja etna pula nukiperratitja angkama. ");
INSERT INTO are_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Rrangkarra pula itja antja nukurna pitjitjika. Rrangkarra turta itja antja nama atha rrangkarranha ngampakala etathilitjika. ");
INSERT INTO are_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Yinga itja antja nama relhala yinganha tnantjitjika. ");
INSERT INTO are_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yinga pula rrakangkarra kaltja. Rrangkarra itjama Altjirraka kangkama. ");
INSERT INTO are_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yinga rrakangkarrurna pitjika Kaarta erarrpa yinganha yairnakalanga. Rrangkarra pula yinganha itja tjinilaka. Kanha relha arrpunha pitjimanga, ilalhamanga turta, era kula messiah namanga, rrangkarra erinha kala tjinilamantala. ");
INSERT INTO are_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Rrangkarra kunha Altjirranha yarna tnakama, rrangkarra kuta antja namanga relhala rrangkarranha tnantjitjika. Rrangkarra turta itja antja nama Altjirrala rrangkarranha tnantjitjika. ");
INSERT INTO are_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Rrangkarra itja etarlaritjika atha rrangkarranha Kaartanga urlarra ilparnitjina. Rrangkarra kunha Moses-akarta tnakalhama. Moses era inthorrataka rrangkarranha Altjirranga urlarra ilparnitjina. ");
INSERT INTO are_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Arai, Moses era kunha nukiperra angkatja intalhelakala. Rrangkarra paka erinha tnakakalanga, rrangkarra yinganha kala tnakamarantema. ");
INSERT INTO are_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Rrangkarra pula Moses-aka angkatja itja tnakaka. Nthakinhantama rrangkarra angkatja nukanha tnakitjina?” ");
INSERT INTO are_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Anma Jesuanha Galilee ntjanganga tjananhaka. Ntjanga nhanha erinha etna rretnya Tiberias turta alpmelitjata. ");
INSERT INTO are_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Relha ntjarrantama ekuranga tnaartangala lhaka, etna tjatjikarta ekuranha arakalanga, era relha menta ntjarranha marrilamalanga. ");
INSERT INTO are_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesuanha partakantama ntjika, kurtungurla ekuranha ntjarralela turta arrarnalhaka. ");
INSERT INTO are_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Passover, relha Jew ntjarraka ilpangkintjaka arlta kngarra, era lyartathakantema naka. ");
INSERT INTO are_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesuala araka relha worla kngarra urlarra pitjimanga. Erantama Philip-anha pmarraka, “Nthanhangama nurna marna buy-emilamara worla kngarra lakinha ntuthilitjika?” ");
INSERT INTO are_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesualataka Philip-anha arrkarnamala wara pmarraka. Era kala kaltja naka, era relha ntjarranha ntuthilitjinala. ");
INSERT INTO are_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip-ala erinha alpmelaka, “Nurnaka money kurrka inthorra. Nthakinhantama nurna worla kngarra lakintjaka marna buy-emilitjina?” ");
INSERT INTO are_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrew, Simon Peter-aka tjia, kurtungurla etnakanga nyinta, erantama angkaka. ");
INSERT INTO are_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Worra nyinta nhanhala nama, ekura marna barley 5 intama, irrpannga kurrka tharra turta. Marna kurrka lakinhala pula worla kngarra inthorra yarna ntuthilama.” ");
INSERT INTO are_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tharrka kngarra pmara lenhala naka. Jesualantama kurtungurla ekuranha ntjarranha ilaka, “Relha ntjarranha arrarnalhitjika turnai.” Kala artwa 5,000 ngerra worla ekurala naka. ");
INSERT INTO are_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesualantama marna etnanha inaka, Altjirranha dangkilaka turta. Kurunga era marna etnanha errarnpalhelaka, irrpannga etnanha turta, relha etna antja namanga ngerra. ");
INSERT INTO are_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Relha ingkarraka kala nhalkerrakalangantama, Jesuala kurtungurla ekuranha ntjarranha turnaka ungkwaltja ingkarraka kotjitjika, marna arrpunha ipmintjerrakitja. ");
INSERT INTO are_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Marna barley 5 etnakangantama, kurtungurla etna 12 basket lyulpalyulpilaka, ungkwaltjakarta. ");
INSERT INTO are_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tjatjikarta nhanha aramala relha etna lakinha angkaka, “Nhanhathoa urrpia era, erinhala Altjirrala alhurna yairnitjika nakala.” ");
INSERT INTO are_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesuanha kaltja naka etna eterramanga erinha errkutjika, erinha ingkairnitjika turta king etnaka nitjika. Lakinhanga era parturna naamerraka, nyintarinya nitjika. ");
INSERT INTO are_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kala ngurrangurrantama, Jesuaka kurtungurla ntjarra ntjangurna lhaka. ");
INSERT INTO are_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Etnantama boat-aka ntjika Capernaum town-urna tjananhitjika. Kala ingwerrakantama. Jesuanha pula itjantema etnakurna pitjikala. ");
INSERT INTO are_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wurinya ekarltala turtantama warnaka, kwatja inmarra etna turta kngarrerraka. ");
INSERT INTO are_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kurtungurla etna kala 5 kilometres ngerra kwatjala lhakalanga, etna Jesuanha araka kwatja kartninyala ingka pitjimanga. Era etnaka etinyerramalanga, etna enkakunya inthorrerraka. ");
INSERT INTO are_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Era pula etnaka ilkaka, “Yingiai! Itja trerritjika!” ");
INSERT INTO are_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Etna antja naka erinha boat-aka ntjilhelitjika. Boat era pula kala ankerra iterakerritjalhaka. ");
INSERT INTO are_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Arlta arrpunhala, relha etnala ntjanganga urntwarra mpinyala kuterrakala, etna ilpangkakantama boat nyintanta nakala. Etna turta ilpangkaka Jesuanha itja kurtungurla ekuranha ntjarralela boat-aka ntjikala, ntjanganga tjananhitjika. ");
INSERT INTO are_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Boat urrputjantama Tiberias town-anga pitjika. Katha nhanga ekuralala relha ntjarrala marna ilkukala, Jesuala Altjirranha marnaka dangkilamaliperra, era etinya wara naka. ");
INSERT INTO are_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Worla etnantama araka Jesuanha, kurtungurla ekuranha ntjarra turta lhakala. Arrpunha ntjarrantama boat etnaka ntjimala Capernaum town-urna tjananhaka, Jesuaka yonthitjika. ");
INSERT INTO are_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jesuanha aramala, etna erinha pmarraka, “Kaltjinthanhinthanhai, ilangarama unta nhanhurna pitjika?” ");
INSERT INTO are_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesuala etnanha pmarraka, “Iwunhangama rrangkarra nuka yonthaka? Rrangkarra tjatjikarta nhangiperra arratja etarlarakalanga? Itja inthorra. Arai, atha rrangkarranha nthurrpa inthorra ilama. Rrangkarrataka nuka yonthaka rrangkarra marna kngarra ilkukalanganta wara, nhalkerrakalanga turta. ");
INSERT INTO are_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Rrangkarrataka arltamarlta marnaka yonthama, ngaiyalala ilkutjika. Rrangkarra pula itja marna nhanhakanta thakerritjika. Rrangkarra marna lenhakatitja yonthitjika, erala relhanha ngampakala etathilama. Altjirra Kaartala yinganha urraraka rrangkarranha marna lenha nthitjika.” ");
INSERT INTO are_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Etnantama erinha pmarraka, “Nthakinhama Altjirrala nurnanha turnama, nurna ntelalhitjika?” ");
INSERT INTO are_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesuala etnanha ilaka, “Altjirrala rrangkarranha turnama rrangkarra yinganha tnakitjika, urrpia erala yairnakala.” ");
INSERT INTO are_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Etna pula erinha pmarraka, “Tjatjikarta iwunhantama unta urrkaputjina, nurna kaltja nitjinanga unta nthurrpa arratja angkamanga? Nurna turtantama nganha tnakitjinanga. ");
INSERT INTO are_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Errilkngipata nurnakanha ntjarra worritjala namalanga, etna marna alkiranga tnyikala ilkutjata. Altjirraka Angkatja Imankinyala ilama, ‘Era etnanha marna alkiranga nthaka ilkutjika.’” ");
INSERT INTO are_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesuala etnanha ilaka, “Arai, atha rrangkarranha nthurrpa inthorra ilama. Moses-ala itjama rrangkarranha marna alkirarinya inthorra erinha nthaka. Kaarta Alkirarinya nukanhalanta rrangkarranha marna alkirarinya inthorra erinha nthama. ");
INSERT INTO are_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Marna Altjirralala relhanha nthama etnanha ngampakala etathilitjika, marna nhanha erataka relha era nama, erala alkiranga pitjikala.” ");
INSERT INTO are_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Relha etnantama Jesuaka enkaka, “Itornkai, marna nhanha erinha nurnanha kutatha nthalathanai!” ");
INSERT INTO are_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesuala etnanha ilaka, “Yinga nama marna era, erala relhanha ngampakala etathilama. Relha erala nuka marnaka enkama, era itja wotha ngaiyalerritjina. Relha erala yinganha tnakama, era itja wotha angkathalerritjina. ");
INSERT INTO are_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Atha rrangkarranha kala ilaka. Rrangkarra yinganha kala araka, rrangkarra pula yinganha itjantema tnakama. ");
INSERT INTO are_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Relha etna, etnanhala Kaarta nukanhala urrarama, etna kala nukurna pitjima. Relha nhanha etnanha turta atha itja inthorra unputjina. ");
INSERT INTO are_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Kaarta nukanhala yinganha alkiranga yairnaka, rrakangkarrurna. Yingantama antja nama ekuranta kangkwerritjika. ");
INSERT INTO are_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nthakinhantama yinga ekura kangkwerrama? Atha relha erala urrarakala ingkarrakanha arratja ntarntaramanga. Atha turta etnanha arlta ingkarnala kamalhelitjina. ");
INSERT INTO are_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kaarta nuka antja nama, relha ingkarraka 'Lira ekuranhurna pitjitjika, erinha tnakitjika turta. Relha etnala 'Lira ekuranha tnakama, etnanha Kaartala ilama, ‘Rrangkarra ngampakala etatha nitjina.’ Atha turtantama etnanha arlta ingkarnala kamalhelitjina.” ");
INSERT INTO are_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Relha Jew ntjarrantama ekura wanngerraka, era angkakalanga, “Yinga nama marna era, erala alkiranga pitjikala.” ");
INSERT INTO are_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Etna angkaka, “Nhanha pula Jesua, Joseph-aka worra. Nurna kaarta pa mia ekuranhaka kaltja. Nthakinhantama era angkama era kula alkiranga pitjikala?” ");
INSERT INTO are_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesuala etnanha ilaka, “Wannga angkarritjalai! ");
INSERT INTO are_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kaarta era, erala yinganha yairnakala, eranta kunha relha nukurna rretjingama. Relha erarrpa yarna nukurna pitjima. Relha erala nukurna pitjima, erinha atha arlta ingkarnala kamalhelitjina. ");
INSERT INTO are_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Altjirraka urrpia imankinya arrpunhala ilaka, ‘Altjirrala relha ingkarrakanha kaltjinthitjina.’ Lakinhanga relha erala Kaartanha wumanga, ekura kangkwerramanga turta, era kala nukurna pitjima. ");
INSERT INTO are_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Relha nyintala itja Kaartanha araka paka. Artwa erala Kaartanga pitjikala, eranta Kaartanha araka. ");
INSERT INTO are_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Arai, atha rrangkarranha nthurrpa inthorra ilama, relha erala yinganha tnakama, era kala ngampakala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Yinga nama marna era, erala relhanha ngampakala etathilama. ");
INSERT INTO are_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Worritjala, errilkngipata rrakangkarranhala marna alkiranga tnyikala nhanga ilkuka. Etna pula ingkarraka iluka. ");
INSERT INTO are_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kanha marna arrpunha nhanha, erala alkiranga pitjikala, relhala erinha ilkumanga, era itjala ilutjina. ");
INSERT INTO are_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","“Yinga nama marna era, erala relhanha ngampakala etathilama. Yinga alkiranga pitjikala. Relha erala marna nhanha ilkumanga, era ngampakala etatha nitjina. Marna nhanha mpurrka nuka nama. Atha mpurrka nukanha tjauwerrilya ngerra ntjama, relha alharinya ingkarrakakakwia.” ");
INSERT INTO are_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Angkatja nhanha wumala, relha Jew ntjarra iwurraka, lakinha angkamala, “Nthakinhama artwa nhanhala nurnanha mpurrka ekuranha ilkutjika nthitjina?” ");
INSERT INTO are_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesuala etnanha ilaka, “Arai, atha rrangkarranha nthurrpa inthorra ilama. Rrangkarra Relhaka 'Liraka mpurrka itja ilkumanga, alhwa ekuranha turta itja ntjumanga, rrangkarra itja ngampakala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Relha erala mpurrka nukanha ilkumanga, alhwa nukanha turta ntjumanga, eranta ngampakala etatha nitjina. Atha turta erinha arlta ingkarnala kamalhelitjina. ");
INSERT INTO are_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mpurrka nuka kunha marna inthorra era nama, alhwa nuka turta ntjuntja inthorra era nama. ");
INSERT INTO are_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Relha erala mpurrka nukanha ilkumanga, alhwa nukanha turta ntjumanga, era nukalela nyinterrakala nama, yinga turta ekuralela nyinterrakala nama. ");
INSERT INTO are_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Kaarta erala yinganha yairnakala, erataka nthurrpa etatha nama. Erantama yinganha turta etathilaka. Lakinha ngerra relha erala mpurrka nukanha ilkumanga, atha erinha etathilitjinantema. ");
INSERT INTO are_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nhanhathoa marna era nama, erala alkiranga pitjikala. Era itja nama marna lenha ngerra errilkngipata rrakangkarranhala worritjala ilkukala. Marna lenha ilkumala kunha etna ilukantema. Relha erala marna nhanha ilkumanga, nhanhatitja mpurrka nukanha, era pula ngampakalala etatha nitjina.” ");
INSERT INTO are_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesuala relha ntjarranha lakinha kaltjinthaka synagogue-ala Capernaum-ala. ");
INSERT INTO are_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kurtungurla ntjarra ekuranga tnaartangala pitjikala. Etnakanga arrpunha ntjarrala angkatja nhanha wumalanga, etna angkaka, “Angkatja nhanha kunha inpora inthorra. Relha ekura yarna kangkwerrama.” ");
INSERT INTO are_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesuanha kaltja naka kurtungurla ekuranha arrpunha ntjarra wannga angkamanga. Erantama etnanha pmarraka, “Angkatja nukanhangama rrangkarra mukunherrama? ");
INSERT INTO are_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Anma rrangkarra aritjina Relhaka 'Lira era alkirurna alpumanga. ");
INSERT INTO are_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Arai, Altjirraka Enkala kunha relhanha etathilama, itja relhaka mpurrkala. Angkatja nukanha Altjirraka Enka nama. Altjirraka Enkalanta turta relhanha etathilama. ");
INSERT INTO are_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Rrakangkarranga arrpunha ntjarrala pula yinganha itja tnakama.” Jesuanha kunha arrkurlantema kaltja naka relha etnaka, etnala erinha itja tnakitjinala. Era turta artwa ekura kaltja naka, erala erinha leltjaka lanthitjinala. ");
INSERT INTO are_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Erantama wotha angkaka, “Lakinhanga atha nhanga rrangkarranha ilaka, Kaartalanta relha nukurna rretjingama.” ");
INSERT INTO are_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kurtungurla ntjarra arrpunha kala Jesuanga mpakalhakantama. Etna itja wotha ekuranga tnaartangala lhaka. ");
INSERT INTO are_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Lakinhanga Jesuala kurtungurla 12 etnanhantama pmarraka, “Rrangkarraloa? Rrangkarra nukanga mpakalhitjinantema?” ");
INSERT INTO are_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter-ala erinha alpmelaka, “Ingkartai, relha ngunhurnama nurna lhamara? Angkatja ungkwanganhalanta kunha relhanha ngampakala etathilama. ");
INSERT INTO are_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nurna kala kaltja, nurna tnakama turta unta, Altjirraka urrpia alkngaltara era namanga.” ");
INSERT INTO are_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesuala erinha ilaka, “Atha kunha artwa 12 urraraka. Kanha rrakangkarranga nyinta errintjala nama.” ");
INSERT INTO are_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Erataka Judas-iperra angkaka, Simon Iscariot-aka worriperra. Judas era kurtungurla 12 etnakanga nyinta naka. Era pula Jesuanha anma leltjaka lanthaka. ");
INSERT INTO are_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nhanhiperra Jesuanha pmara Galilee-alantama nthulapuka. Era itja antja naka pmara Judea-ala kuterritjika, relha Jew ntjarraka itornka ntjarra antja nakala erinha errilknga tutjika. ");
INSERT INTO are_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kwentjaka ilpangkintjaka arlta lyartathakantema naka. ");
INSERT INTO are_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesuaka tjia ntjarrala pula erinha ilaka, “Untataka mparrama Judea-urna lheikanha, kurtungurla ungkwanganha ntjarrala nganha aritjinanga unta tjatjikarta urrkapumanga. ");
INSERT INTO are_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Arai, relha itja lauwulhama era paka antja namanga relha arrpunha ntjarrala erinha aritjika. Kala relha ntjarranga alkngatharra tjatjikarta urrkapai.” ");
INSERT INTO are_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesuaka tjia ntjarralataka erinha itja tnakaka. ");
INSERT INTO are_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesuala pula etnanha ilaka, “Nukathaka itja nama lyarta tjatjikarta urrkaputjika. Rrangkarra pula nhanhaka itja kaltja. ");
INSERT INTO are_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Arai, relha alharinya ntjarra itja rrakangkarra yirrkngerrama. Nuka pula etna yirrkngerramala, atha etnanha ilamanga etna korna kuta ntelalhamanga. ");
INSERT INTO are_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kala rrangkarra Kwentjaka ilpangkintjaka arltaka lharrirrai. Yinga itja lyarta ilpangkintjaka arltaka lhama, anmanta.” ");
INSERT INTO are_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Lakinhanga Jesuanha Galilee-ala kuterraka. ");
INSERT INTO are_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jesuaka tjia ntjarra kala Kwentjaka ilpangkintjaka arltaka lhakantama. Kurunga Jesua era turtantama lhaka, itja pula alkngatharra. ");
INSERT INTO are_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Relha ntjarra Kwentjaka ilpangkintja arltaka Jerusalem-ala worlerraka. Relha Jew ntjarraka itornka ntjarralantama Jesuaka yonthaka, relha ntjarranha pmarralapumala, “Nthanhama artwa nhanga?” ");
INSERT INTO are_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Relha etna turtantama ekuriperra angkarraka, rritjintja wara pula. Arrpunha ntjarra angkaka, “Era artwa marra nama.” Kanha arrpunha ntjarra angkaka, “Era relha ntjarranha orrtjapepilama.” ");
INSERT INTO are_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Relha etna pula itja ekuriperra alkngatharra angkarraka, relha Jew ntjarraka itornka ntjarranga trerramala. ");
INSERT INTO are_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Etna ilpangkintjaka arlta arrpunha ntjarra kala mangkilakalangantama, Jesuanha temple-urna lhaka. Era turta relha ntjarranha kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Relha Jew ntjarrala erinha wumalanga, etna tnolkaka. Etna lakinha pmarrarraka, “Nthakinhala artwa nhanha kaltja inthorra? Ngunhala pakama erinha kaltjinthaka?” ");
INSERT INTO are_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesuala etnanha ilaka, “Atha rrangkarranha itja angkatja nukanha alpmelama. Altjirralataka yinganha yairnaka. Athantama rrangkarranha angkatja ekuranha alpmelama. ");
INSERT INTO are_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Relha erala Altjirraka angkatjaka kangkwerrama, era kala kaltja nitjina yinga arratja angkamanga. Era turta kaltja nitjina atha Altjirraka angkatja kaltjinthamanga, itja angkatja nukanha. ");
INSERT INTO are_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Relha erala relha ntjarranha angkatja ekuranha ilama, era antja nama etna erinha tnantjitjika. Kanha relha erala angkatja arrpunhaka relha ntjarranha ilama, urrpiala ngerra, era itjala orrtjerrama. ");
INSERT INTO are_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Arai, Moses-ala kunha rrangkarranha Altjirraka turnintja etnanha ilaka. Rrangkarra pula turnintja etnaka itja kangkwerrama. Iwunhangantama rrangkarra antja nama yinganha errilknga tutjika?” ");
INSERT INTO are_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Relha etna erinha alpmelaka, “Untataka rirta. Ngunhama antja nama nganha errilknga tutjika?” ");
INSERT INTO are_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesuala etnanha alpmelaka, “Sabbath arltala yinga tjatjikarta nyintaka urrkapuka. Rrangkarra ingkarrakantama nuka antjakunyerraka. ");
INSERT INTO are_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses-ala nhanga rrangkarranha turnaka worra rrakangkarranha artwilitjika, etna arlta 8 ingkwia namalanga. (Itja Moses inthorrala rrangkarranha turnakala, errilkngipata rrakangkarranhalatitja.) Rrangkarrantama Sabbath arltala turta worra artwilama. ");
INSERT INTO are_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Rrangkarra etnanha artwilama Moses-ala rrangkarranha turnakalanga. Atha artwa nyintanha Sabbath arltala marrilaka. Iwunhangantama rrangkarra yinganha ilama nhanha itja arratja namanga? ");
INSERT INTO are_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Rrangkarra itja relha arrpunhanha palkala ilparnitjika. Kala relhiperra arratjanta angkai.” ");
INSERT INTO are_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Relha Jerusalem-arinya urrputjantama pmarrarraka, “Artwa nhanhama etna errilknga tutjika antja nama? ");
INSERT INTO are_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Era pula relha ntjarranha alkngatharra kaltjinthama. Etna turta erinha itja parrama. Thunga itornka nurnakanha ntjarra kaltja era Krista era namanga. ");
INSERT INTO are_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nurna pula kaltja era itja Krista era namanga, nurna pmara ekuranhaka kaltjanga warta. Kristaka pmaraka kunha relha itja kaltja.” ");
INSERT INTO are_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesuala etnanha wuka lakinha angkamanga, era relha ntjarranha temple-ala kaltjinthamanga. Erantama etnanha angkatja intarrala ilaka, “Rrangkarra nthurrpa nuka kaltja. Pmara nukanhaka turta rrangkarra kaltjantema. Yinga nhanhala nama Altjirrala yinganha yairnakalanga. Altjirra era arratja nama. Rrangkarra pula ekura kotnala. ");
INSERT INTO are_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yinga pula ekura kaltjala, era warta yinganha yairnakalanga, yinga turta ekuranga pitjikalanga.” ");
INSERT INTO are_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Relha etnantama Jesuanha kala errkutjikanta antja naka. Etna pula erinha itja errkuka, nhanha itjantema ekurathaka namanga ilutjika. ");
INSERT INTO are_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Relha ntjarra arrpunhala pula erinha tnakakala. Etna lakinha pmarrarraka, “Krista era pitjimalanga, era paka tjatjikarta ntjarralkura urrkapumarama artwa nhanhangatjina? Itja kunha.” ");
INSERT INTO are_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Artwa Pharisee ntjarrala relha ntjarranha wuka Jesuiperra rritjintja angkarramanga. Etna, priest-aka itornka ntjarrala turtantama tjapartia etnakanha yairnaka Jesuanha errkutjika. ");
INSERT INTO are_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesualantama etnanha ilaka, “Yinga kurrka wara wotha rrakangkarralela nitjina. Kurunga yinga ekururna alputjina, erala yinganha yairnakala. ");
INSERT INTO are_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Rrangkarrantama nuka yonthitjina, rrangkarra pula yinganha itja arltaritjina. Pmara ekururnala yinga lhama, ekururna rrangkarra yarna lhama.” ");
INSERT INTO are_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Relha Jew etnantama pmarrarraka, “Nthanhurnama artwa nhanha lhitjika angkama? Iwunhanga turtama nurna ekura yarna yonthitjina? Tjina nurnaka ntjarrurnama era lhitjina, etnala pmara Greece-ala namanga? Etnanhama era kaltjinthitjinantama? ");
INSERT INTO are_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Iwunha turtama era nurnanha ilaka, ‘Rrangkarra nuka yonthitjina, rrangkarra pula yinganha itja arltaritjina. Pmara ekururnala yinga lhama, ekururna rrangkarra yarna lhama.’” ");
INSERT INTO are_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kwentjaka ilpangkintjaka arlta ingkarninyalantama, arlta kngarra ekurala, Jesuanha kamerramala relha ntjarraka ilkaka, “Relha erala angkathala nama, era nukurna pitjeikanha, ntjutjika. ");
INSERT INTO are_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Relha erala yinganha tnakama, Altjirraka Angkatja Imankinyala ekuriperra lakinha ilama. ‘Ekuranga kwatja etatha era roa lhitjina.’” ");
INSERT INTO are_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Arai, kwatja etatha erataka Enka Alkngaltara era nama. Enka erinhataka Altjirrala relha tnakanhakanha ntjarrurna yairnitjika nakala. Era pula Enka erinha itjantema yairnakala, Jesuanha itjantema pmara makalaria ekuranhurna alpukalanga. ");
INSERT INTO are_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Relha arrpunha ntjarrala nhanha wumalanga, etna lakinha angkaka, “Artwa nhanhataka nthurrpa Altjirraka urrpia era nama.” ");
INSERT INTO are_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Arrpunha ntjarra turta angkaka, “Nhanha kunha nthurrpa Krista era nama.” Kanha arrpunha ntjarrala ilaka, “Kristanha itjama pmara Galilee-arinya nitjina. ");
INSERT INTO are_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Altjirraka Angkatja Imankinyala ilama era David-aka ramarama nitjina, pmara Bethlehem-arinya. Bethlehem kunha David-aka pmara naka.” ");
INSERT INTO are_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Relha etna kala iwurrakantama, Jesuiperra. ");
INSERT INTO are_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Arrpunha ntjarrala erinha kala errkutjika antja naka. Etna pula erinha itja errkuka. ");
INSERT INTO are_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tjapartia nhanga ntjarra alpukantama. Artwa Pharisee ntjarrala, Priest-aka itornka ntjarrala turtantama etnanha pmarraka, “Iwunhangala rrangkarra Jesuanha itja errkuka, nurnakurna kngitjika turta?” ");
INSERT INTO are_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tjapartia etna etnanha alpmelaka, “Era kunha relha ntjarranha marra inthorra kaltjinthaka. Nurna itja angkatja lakinha ngerra arrkurla wuka paka.” ");
INSERT INTO are_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Artwa Pharisee ntjarralantama etnanha ilaka, “Era rrangkarranha turtama parrpartilaka? ");
INSERT INTO are_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Artwa Pharisee nurnakanga itja nyintala erinha tnakama. Itornka arrpunha ntjarrala turta erinha itjantema tnakama. ");
INSERT INTO are_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Relha nhanha ntjarralanta erinha tnakama, etna Altjirraka turnintjaka kotna namanga. Altjirrala etnanha kala imilaka.” ");
INSERT INTO are_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemus, artwa Pharisee nhanga, erala Jesuurna ingwala lhakala, era etnanha wuka lakinha angkamanga. ");
INSERT INTO are_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Erantama etnanha ilaka, “Arai, mpaarangaranga nurnakanhala kunha nurnanha parrama itja relha arrpunhanha kala imilitjikanta. Nurna erinha wutjikarrka.” ");
INSERT INTO are_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Artwa Pharisee arrpunha ntjarrala pula Nicodemus-anha ilaka, “Unta turtama artwa Galilee-arinya? Altjirraka angkatjaka read-errai. Untantama kaltja nitjina Altjirraka urrpia itja inthorra pmara Galilee-anga paka pitjitjina.” ");
INSERT INTO are_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Etna ingkarraka kala pmarurnantama alpuka. ");
INSERT INTO are_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesuanha Olive Parturnantama lhaka. ");
INSERT INTO are_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ingutnhala era wotha temple-urna pitjalpuka. Relha ntjarra turta ekururna pitjika. Erantama arrarnalhamala etnanha kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Artwa Intarrangaltha ntjarrala, artwa Pharisee ntjarrala turtantama arrkutja nyinta Jesuurna rretjingaka. Arrkutja nhanha erinhataka arrpunha ntjarrala arakala artwalela intamanga. Artwa Intarrangaltha ntjarrala, artwa Pharisee ntjarrala turtantama arrkutja erinha relha ntjarranga urlarra ilparnaka. ");
INSERT INTO are_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Etnantama Jesuanha pmarraka, “Kaltjinthanhinthanhai, etnataka arrkutja nhanha araka korna mpaaramanga. ");
INSERT INTO are_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses-ala nurnanha turnaka nurna arrkutja lakinha ngerra partala wamala errilknga tutjika. Nthakinha paka unta etarlarama, nhanha paka arratjama nama?” ");
INSERT INTO are_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Etnataka Jesuanha arrkarnamala pmarraka. Etna antja naka erinha ilparnitjika. Jesuanha pula etnakurna itjala angkaka. Toparrarnalhamala, era arnaka angkatjatitja intalhelaka, iltja kantjala. ");
INSERT INTO are_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Etna pula erinha kuta inthorra pmarraka. Arratjerramalantama, era etnanha ilaka, “Relha erala korna rapa namanga, erakimparra erinha partala watjika.” ");
INSERT INTO are_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kurunga era wothantema toparrarnalhamala, arnaka angkatja intalhelaka. ");
INSERT INTO are_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Relha ntjarrala angkatja ekuranha wumalanga, etna ingkarraka lhaka. Kngarripata ntjarrarrka, kurunga arrpunha ntjarra turta. Kala Jesuantantama naka, arrkutja era turta. ");
INSERT INTO are_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Arratjerramala, Jesuala arrkutja erinha pmarraka, “Arrkutjai, nthanhama relha etna, etnala nganha ilparnakala? Nyintala paka nganha imilakama?” ");
INSERT INTO are_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Arrkutja era angkaka, “Itornkai, itjau.” Jesualantama erinha ilaka, “Atha turta nganha itja imilama. Kala alpai. Itja wotha korna mpaarai.” ");
INSERT INTO are_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesualantama etnanha wotha ilaka, “Yinga nama relha alharinya ingkarrakaka parrtja. Relha erala nukanga tnaartangala pitjima, era itja thapathapala nthulaputjina. Era pula parrtjala nthulaputjina. Era turta ngampakala etatha nitjina.” ");
INSERT INTO are_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Artwa Pharisee etna pula erinha ilaka, “Unta kunha nyinta angkarlanama. Arrpunhala turta itja angkatja ungkwanganha tjanamala, ekarltilama. Lakinhanga angkatja ungkwanganha itja nthurrpa nama.” ");
INSERT INTO are_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesuala pula etnanha alpmelaka, “Yinga nyintanta paka angkamanga yinga Kaartaka 'Lira namanga, rrangkarra kalantema angkatja nukanha tnakitjika. Iwunhanga? Yinga kaltjanga warta pmara ekurangala yinga pitjikala, pmara ekururna turtala yinga lhamanga. Kanha rrangkarra itjala kaltja pmara ekurangala yinga pitjikala, ekururna turtala yinga lhamanga. ");
INSERT INTO are_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Rrangkarra nuka itja kaltja. Lakinhanga rrangkarra nukiperra paala etarlarama. Atha pula itjala relhiperra paala etarlarama. ");
INSERT INTO are_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Arai, atha rrangkarranha ilamanga yinga Kaartaka 'Lira namanga, yinga nthurrpa angkama, arrpunhala angkatja nukanha tjanamanga. Kaarta era angkatja nukanha ekarltilama. ");
INSERT INTO are_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mpaarangaranga rrakangkarranhala kunha ilama relha tharra paka angkatja nyinta kuta angkamanga, relha arrpunhala angkatja ekuratharra kala tnakitjika. ");
INSERT INTO are_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yinga angkama yinga Altjirraka 'Lira namanga. Kaarta erala yinganha yairnakala, era turta angkamantema yinga 'Lira ekura namanga.” ");
INSERT INTO are_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","“Nthanhantama Kaarta ungkwanga?” etna Jesuanha pmarraka. Jesuala etnanha ilaka, “Rrangkarra itja nuka kaltja, Kaarta nukanhaka paka. Rrangkarra paka nuka kaltja nakalanga, rrangkarra Kaarta nukanhaka turta kaltja namarantema.” ");
INSERT INTO are_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesuanha lakinha angkaka, era relha ntjarranha temple-ala kaltjinthamalanga. Era tjauwerrilyaka box-anga kutala narlanaka. Nyintala pula erinha itja errkuka. Ekurathaka itjantema naka ilutjika. ");
INSERT INTO are_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesuala relha Jew ntjarranha wotha ilaka, “Yinga lhama. Pmara yingala lhama, rrangkarra yarna lhama. Rrangkarra turtantama nuka yonthitjina. Rrangkarra pula nuka yarna yonthitjina. Rrangkarra turta kornakarta kuta ilutjina.” ");
INSERT INTO are_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nhanha wumala relha Jew ntjarra pmarrarraka, “Era errilkngama tulhitjina? Era nhanga angkakalanga warta, ‘Pmara ekururnala yinga lhama, rrangkarra yarna lhama.’” ");
INSERT INTO are_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesuala pula etnanha ilaka, “Rrangkarra kunha arna nhanharinya, kanha yinga alkirarinyala. Rrangkarra relha alharinya nama, kanha yinga itja kutala relha alharinya nama. ");
INSERT INTO are_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Arai, atha nhanga rrangkarranha ilaka, rrangkarra kornakarta kuta ilutjinala. Rrangkarra itja tnakama yinga Kaartaka 'Lira namanga. Lakinhanga rrangkarra kornakarta kuta ilutjina.” ");
INSERT INTO are_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Relha Jew etnantama Jesuanha pmarraka, “Ngunhantama unta?” Jesuala etnanha alpmelaka, “Atha rrangkarranha arrkurla nhanga alpmelaka. ");
INSERT INTO are_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Atha turta rrangkarranha kngarra wotha alpmelitjina, rrangkarranha ilparnamala. Arai, erala yinganha yairnakala, angkatja ekura nthurrpa nama. Atha angkatja ekuranha wuka. Athantama relha alharinya ingkarrakanha angkatja nhanha ilama.” ");
INSERT INTO are_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Era etnanha Kaartiperra alpmelaka. Etna pula angkatja ekuranha itja lhangkaraka. ");
INSERT INTO are_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesualantama etnanha wotha ilaka. “Anma rrangkarra Relhaka 'Lira erinha ntolkaka kanthatutjina. Kurunga rrangkarra kaltja nitjina, yinga Kaartaka 'Lira namanga, yinga ilalhakala ngerra. Yinga turta angkama Kaartala yinganha kaltjinthakala ngerra. ");
INSERT INTO are_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kaarta erala yinganha yairnakala, era nukalela nama. Era yinganha itja ipmintja impuka, yinga ekura kuta kangkwerramanga.” ");
INSERT INTO are_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Angkatja nhanha wumala ntjarrala Jesuanha tnakaka. ");
INSERT INTO are_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesuala relha Jew etnanha ilaka, etnala erinha tnakakala, “Rrangkarra nthurrpa kurtungurla nukanha nitjina, rrangkarra paka angkatja nukanhaka kangkwerramanga. ");
INSERT INTO are_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Rrangkarra turtantama angkatja nthurrpa nukanhaka kaltjerritjina. Kurunga arrpunha rrakangkarra itja wotha tjitjarterritjina.” ");
INSERT INTO are_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Relha Jew ntjarrala erinha ilaka, “Nurna pula Abraham-aka ramarama nama. Relha arrpunha turta nurnaka itja kutama tjitjarterraka paka. Iwunhangantama unta nurnanha ilama? ‘Arrpunhantama rrakangkarra itja wotha tjitjarterritjina.’” ");
INSERT INTO are_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesuala etnanha alpmelaka, “Atha rrangkarranha nthurrpa inthorra ilama. Thunga relha lherrintja korna ekuranhaka kangkwerrama. Lherrintja korna etna kala tjitjarta ekura nama. Relha era turta lherrintja korna etnaka urrkapunhapunha ngerra nama. ");
INSERT INTO are_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","(Arai, urrkapunhapunha itja kurtwia nama. 'Liranta kurtwia nama. Ekurathakanta nama pmarala kuterritjika.) ");
INSERT INTO are_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Thunga pula Altjirraka 'Lirala rrangkarranha ekarltilama, rrangkarra itja wotha lherrintja korna rrakangkarranhaka kangkwerritjinanga, kurunga lherrintja korna etna itja wotha tjitjarta rrakangkarra nama. Rrangkarra kala althakaltha nama. ");
INSERT INTO are_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yinga kala kaltja rrangkarra Abraham-aka ramarama namanga. Rrangkarra pula yinganha errilknga tutjika antja nama, rrangkarra angkatja nukanhaka antjakunya namanga. ");
INSERT INTO are_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yinga Kaartalela naka. Athantama rrangkarranha angkatja ekuranha alpmelama. Rrangkarra pula angkatja arrpunhakala kangkwerrama. Angkatja nhanga rrangkarrala kaarta rrakangkarranhanga wukala.” ");
INSERT INTO are_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Etna pula Jesuanha ilaka, “Abraham-anhama kaarta nurnaka.” Jesuala etnanha ilaka, “Abraham-anha paka nthurrpa kaarta rrakangkarra namanga, rrangkarra Abraham ngerra ntelalhamara. ");
INSERT INTO are_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kanha rrangkarra antja nama yinganha errilkngala tutjika. Iwunhanga? Atha rrangkarranha angkatja nthurrpa alpmelakalanga. Angkatja nyinta erinha athala Altjirranga wukala. Abraham-anha itja rrangkarra ngerra ntelalhaka. ");
INSERT INTO are_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Arai, rrangkarrataka kaarta rrakangkarranha ngerra ntelalhama.” Etna Jesuanha alpmelaka, “Nurna itjama katjia kotjintja nama. Altjirra erarrpa Kaarta nurnaka nama.” ");
INSERT INTO are_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesuala pula etnanha ilaka, “Rrangkarra nuka itja kangkama. Lakinhanga Altjirranha itja Kaarta rrakangkarra nama. Yinga kunha Kaartanga pitjika. Erarrpa yinganha rrakangkarrurna yairnaka. ");
INSERT INTO are_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Iwunhangantama rrangkarra angkatja nukanha itja wuma? Atha iliai? Marntilparla warta, rrangkarra yinganha yarna wuma. ");
INSERT INTO are_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Errintja era kunha kaarta rrakangkarra nama. Rrangkarra turta antja nama ekura kangkwerritjika. Era urrarna kuta nentjika, orrtjaltha turta. Era itja arratja nama. Era paka orrtjerramanga, nhanha kala ekurathaka nama. Erarrpa orrtjaltha nama, relha orrtjerranhaka kaarta turta. ");
INSERT INTO are_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Rrangkarra yinganha itja tnakama, atha rrangkarranha angkatja nthurrpa alpmelamangatanya. ");
INSERT INTO are_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Rrangkarra yinganha yarna inthorra ilparnama. Yinga angkatja nthurrpa angkama. Iwunhangantama rrangkarra yinganha itja tnakama? ");
INSERT INTO are_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Relha erala Altjirraka tjina nama, era kala wuma Altjirranha ekururna angkamanga. Rrangkarra Altjirraka angkatja itja wuma rrangkarra itja Altjirraka tjina namanga.” ");
INSERT INTO are_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Relha Jew ntjarrala Jesuanha ilaka, “Nurna kunha nganha arratja inthorra alpmelaka unta Samaria-arinya namanga, artwa errintjakarta turta.” ");
INSERT INTO are_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesuala pula etnanha ilaka, “Yinga itjama errintjakarta. Atha Kaarta nukanhanta tnantjama. Rrangkarra pula yinganha arrampowumala. ");
INSERT INTO are_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yinga itja tnakalhama. Kaarta era pula nuka kaltja. Erantama antja nama relhala yinganha tnantjitjika. ");
INSERT INTO are_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Atha rrangkarranha nhanha nthurrpa inthorra ilama. Relha erala angkatja nukanhaka kangkwerrama, era itja ilutjina.” ");
INSERT INTO are_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Relha Jew etnantama erinha ilaka, “Nurna kala kaltjantama unta nthurrpa errintjakarta namanga. Abraham-anha iluka, Altjirraka urrpia imankinya ntjarra turta ilukantema. Kanha unta ilama relha erala angkatja ungkwanganhaka kangkwerramanga, era kula itja kutala ilutjina. ");
INSERT INTO are_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Unta Kaarta nurnakanha Abraham-anga kngarralkurama nama, Altjirraka urrpia imankinya ntjarranga turta? Etna kunha ingkarraka iluka. Ngunhantama unta ilalhama unta kula namanga?” ");
INSERT INTO are_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesuala etnanha ilaka, “Yinga paka tnakalhamanga, angkatja nukanha palkinya wara namara. Kaarta erataka yinganha tnantjama. Rrangkarrantama angkama era kula Altjirra rrakangkarra namanga. ");
INSERT INTO are_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Rrangkarra pula ekura kotna. Kanha yinga ekura kaltjala. Yinga paka angkamanga yinga ekura kotna, kurunga yingala orrtjerramara, rrangkarrala orrtjerramanga ngerra. Yinga pula ekura kaltjala. Yinga turta angkatja ekuranhaka kangkwerrama. ");
INSERT INTO are_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kaarta rrakangkarra Abraham-anha kaltja naka yinga alhurna pitjitjinala. Erantama arrkana inthorra naka.” ");
INSERT INTO are_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jew etnantama Jesuanha ilaka, “Apai! Unta itjama kngarripata. Unta itjama Abraham-anha araka.” ");
INSERT INTO are_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesuala etnanha ilaka, “Atha rrangkarranha nthurrpa inthorra ilama, Abraham-anha alkngerritjikanhangantema, yinga kala naka.” ");
INSERT INTO are_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Relha Jew ntjarralantama parta kotjika, Jesuanha errilknga tutjika. Jesuanha pula etnakanga lauwulhamala temple-anga rratanhaka. ");
INSERT INTO are_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesuanha tjaiyala lhapalhamalanga, era artwa panganha araka. Artwa era alknga panga kuta katjia intakala. ");
INSERT INTO are_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kurtungurla ekuranha ntjarralantama Jesuanha pmarraka, “Kaltjinthanhinthanhai, ngunhama korna ntelalhaka? Thunga artwa nhanha, thunga kaarta pa mia ekuranha paka, era alknga panga kuta warta katjia intakalanga.” ");
INSERT INTO are_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesuala etnanha alpmelaka, “Itjama. Artwa nhanha itja korna ntelalhaka, kaarta pa mia ekuranha turta itjantema korna ntelalhaka. Era pula alknga panga alkngerraka, atha erinha marrilitjinanga. Kurunga relha ingkarrakala aritjina Altjirranha ekarlta inthorra namanga. ");
INSERT INTO are_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Altjirrala kunha yinganha alhurna yairnaka. Lakinhanga nurnakathaka nama urrkaputjika erala yinganha turnakala ngerra. Lyarta arltantema nama. Anma, ingwerramalanga, relha yarna wotha urrkapuma. ");
INSERT INTO are_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yinga relha alharinya ntjarralela namalanga, yinga parrtja etnaka nama.” ");
INSERT INTO are_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ekuriperra Jesuala arnaka palhiwuka, palhala turta arna urrknga mpaaraka. Kurunga era artwa panga ekura alknga urrkngala parnaka. ");
INSERT INTO are_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Erantama erinha ilaka, “Lhai, alknga ilkngilhitjika, Siloam ntjangala.” (Angkatja Siloam-ataka Arrarnturna kngartiwuma: ‘Yairnakala’.) Artwa era kala lhaka, alknga ilkngilhaka turta. Kurunga era katha araka, alpuka turta. ");
INSERT INTO are_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Relha pmararinya ntjarra, etnala erinha aritjata marnaka enkamanga, etnantama pmarrarraka, “Artwa panga nhangama nhanha, erala marnaka enkitjata?” ");
INSERT INTO are_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Arrpunha ntjarra angkaka, “Kala eranta kuta.” Kanha arrpunha ntjarra angkaka, “Itjiai! Artwa arrpunha, anngerranta era ngerra.” Artwa erantama ilalhaka, “Yinga kunha era.” ");
INSERT INTO are_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Etnantama erinha pmarraka, “Nthakinhantama alknga ungkwanganha marrerraka?” ");
INSERT INTO are_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Era etnanha alpmelaka, “Artwa nhanga, rretnya ekura Jesua, erataka arna urrknga mpaaramala alknga nukanha parnaka. Kurunga era yinganha Siloam kwatjurna yairnaka, alknga ilkngilhitjika. Yingantama lhaka. Yinga ilkngilhaka. Athantama katha arama.” ");
INSERT INTO are_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Etnantama erinha pmarraka, “Nthanhantama artwa era?” Artwa panga nakala era angkaka, “Yukwa.” ");
INSERT INTO are_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kurunga etna artwa panga nakala erinha artwa Pharisee ntjarrurna kngaka. ");
INSERT INTO are_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Arlta ekuralala Jesuala arna urrknga mpaarakala, artwa pangaka alknga marrilakala turta, erataka Sabbath arlta naka. ");
INSERT INTO are_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Artwa Pharisee ntjarralantama artwa panga nakala erinha pmarraka, “Nthakinhama alknga ungkwanganha marrerraka?” Era etnanha ilaka, “Era alknga nukanha arna urrkngala parnaka. Yinga alknga ilkngilhaka. Atha kala katha aramantama.” ");
INSERT INTO are_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Artwa Pharisee urrputjantama angkaka, “Artwa era itja Altjirraka urrpia nama. Erataka Sabbath arltala urrkapuka. Nhanha itja arratja nama.” Kanha artwa Pharisee urrputja arrpunha lakinhala angkaka, “Artwa kornala yarna tjatjikarta lakinha urrkapumara.” Artwa Pharisee etnantama Jesuiperra iwurraka. ");
INSERT INTO are_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lakinhanga etna artwa panga nakala erinha wothantema pmarraka, “Nthakinha paka unta etarlarama? Nurnanha ilai, artwa erala nganha alknga marrilakala, ngunhama era?” Era etnanha ilaka, “Era Altjirraka urrpia nama.” ");
INSERT INTO are_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Relha Jew ntjarrala pula artwa erinha ilpoiwuka. Etna erinha itja tnakaka era ilalhamanga era panga nakala. Etnantama kaarta mia ekuranhaka ntangkalhaka. ");
INSERT INTO are_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Etnantama erinhatharra pmarraka, “Worra mpalakanhama artwa nhanha? Mpala angkama era kula alknga panga kuta katjia intakala. Nthakinhantama era aramantama?” ");
INSERT INTO are_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Eratharra etnanha alpmelaka, “Ilirna kaltja era worra ilirnakanha namanga. Ilirna turta kaltja era alknga panga kuta katjia intakala. ");
INSERT INTO are_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nthakinhantama era irrpalthala arama? Ngunhala turtama erinha alknga marrilaka? Nhanhaka pula ilirna kotnala. Kala erinhanta pmarrai. Era itja katjia nama. Era kala irrpalthala ilalhama.” ");
INSERT INTO are_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kaarta pa mia ekuranhataka lakinha angkaka relha Jew ntjarranga trerramala. Relha Jew ntjarrataka arrkurlantema angkaka relha erinha synagogue-anga unpurlenitjika, erala tnakamanga Jesuanha Krista era namanga. ");
INSERT INTO are_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Lakinhanga eratharra angkaka, “Era itja katjia nama. Kala erinhanta pmarrai.” ");
INSERT INTO are_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Etnantama artwa panga nakala ekura wothantema ntangkalhaka. Etna erinha pmarraka, “Altjirrala nganha aramanga, arratja inthorrantama ilalhai. Nurna kunha kaltja, artwa erala nganha marrilakala, erataka artwa korna nama.” ");
INSERT INTO are_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Artwa panga nakala era pula etnanha ilaka, “Yinga itja kaltja artwa era paka korna namanga, marra paka. Yinga nhanhakanta kaltja. Yinga panga nakala, lyarta atha kala aramantama.” ");
INSERT INTO are_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Etna pula erinha kuta pmarraka, “Nthakinha inthorrama era nganha alknga marrilaka?” ");
INSERT INTO are_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Era etnanha ilaka, “Atha rrangkarranha kalama alpmelaka. Rrangkarra pula angkatja nukanhaka itja kangkwerrama. Iwunhangama rrangkarra yinganha kuta inthorra pmarrama? Rrangkarra turtama kurtungurla ekuranha nitjika antja?” ");
INSERT INTO are_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Etna pula erinha arrampowuka. “Unta kala kurtungurla ekuranha nama. Nurna pula Moses-aka kurtungurlala nama. ");
INSERT INTO are_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nurna kaltja Altjirranha nurnakurna angkakala Moses-arlarlanga. Kanha artwa arrpunha nhanha, nurna pmara ekuranhakalka kotnala.” ");
INSERT INTO are_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Artwa era pula etnanha pmarraka, “Nthakinhala? Artwa era yinganha alknga marrilaka. Kanha rrangkarra pmara ekuranhakalka kotnala. ");
INSERT INTO are_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nurna kala kaltja Altjirranha itja relha kornaka kangkwerrama. Era relha lenhakanta kangkwerrama, erala ekura kangkwerramanga. ");
INSERT INTO are_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Imankangatjina turta nurna itja kuta wentjika relhala, relha alknga panga alkngerrakalaka alknga wotha marrilakala. ");
INSERT INTO are_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Artwa nhanha paka itja Altjirranga pitjikalanga, nthakinhantama era tjatjikarta urrkapuma?” ");
INSERT INTO are_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Etnantama erinha ilaka, “Unta pula katjiangatjina korna kuta ntelalhaka. Untantama eterrama unta kula nurnanha kaltjinthitjinala? Lhai!” Etnantama erinha synagogue-anga unpurlenaka. ");
INSERT INTO are_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesuala wumalanga etna artwa erinha synagogue-anga unpurlenakala, era ekura yonthaka. Erinha aramala, era erinha pmarraka, “Unta Relhaka 'Lira erinha tnakamama?” ");
INSERT INTO are_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Artwa era erinha alpmelaka, “Ngunhama era? Itornkai, yinganha ilai, atha erinha tnakitjinanga.” ");
INSERT INTO are_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesuala erinha ilaka, “Unta erinha kala araka. Erathoa nhanha ungkwangurna angkama.” ");
INSERT INTO are_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Artwa erantama Jesuanha alpmelaka, “Ingkartai, atha nganha tnakama.” Erantama mparalela arrarnalhamala erinha tnantjaka. ");
INSERT INTO are_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesuanhantama angkaka, “Yinga alha nhanhurna pitjika relha ntjarranha tjiperrawutjika. Relha panga ntjarrala aritjinantama. Kanha relha alknga marrakarta ntjarra pangerritjinala.” ");
INSERT INTO are_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Artwa Pharisee urrputja, etnala ekuranga etinya itnaka, etna erinha wuka lakinha angkamanga. Etnantama erinha pmarraka, “Nurnanhalkama unta ilama nurna kula panga namanga?” ");
INSERT INTO are_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesuala etnanha ilaka, “Rrangkarra panga nakalanga, rrangkarra itja kornakarta namara. Rrangkarra pula ilalhama rrangkarra aramanga. Lakinhanga rrangkarra kornakarta kuta nama.” ");
INSERT INTO are_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesuanha angkaka, “Arai, atha rrangkarranha nthurrpa inthorra ilama. Thunga artwa sheep ntjarraka yard-aka nyilknganyilknga irrpuma, itja reoanga. Artwa era kala nyilkngampa tunhatunha turta nama. ");
INSERT INTO are_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Artwa era pula, erala reoanga irrpunhama, era sheep ntjarraka tnairnarintjala nama. ");
INSERT INTO are_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Artwa erala yard erinha ntarntarama, era turta tnairnarintja ekura reoa altjurilama. Sheep ntjarrala tnairnarintja etnakanha kala wuma. Tnairnarintja erantama sheep ekuranha ntjarranha rretnya ntangkamala, yard-anga rratalhelama. ");
INSERT INTO are_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kurunga sheep ingkarraka kathala namalangantama, era etnakanga arrkurlerrama. Etna turta ekuranga tnaartangala lhama, etna angkatja ekuranhaka kaltjanga warta. ");
INSERT INTO are_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Etna pula itja relha lorinyanga tnaartangala lhama. Relha lorinyanga pula etna kala tirantala lhama, etna angkatja ekuranhaka kotnanga warta.” ");
INSERT INTO are_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesuala etnanha yia nhanha alpmelaka, etna pula yia erinha marntilparla wara wurlanaka. ");
INSERT INTO are_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Lakinhanga Jesuanha wotha etnakurna angkaka. “Arai, atha rrangkarranha nthurrpa inthorra ilama. Yinga nama sheep ntjarraka reoa era. ");
INSERT INTO are_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tnairnarintja etnala lyartalpula nakala, etna ingkarraka nyilkngampa tunhatunhanta turta naka. Sheep ntjarra pula etnaka itja kangkwerraka. ");
INSERT INTO are_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yinga nama reoa era. Relha erala yard-aka irrpunhamanga nukarlarlanga, era ngampakala etatha nitjina. Erantama irrpurlanitjina, era turta rratarlanitjina, era turta marna kuta arltaritjina. ");
INSERT INTO are_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nyilkngampa kunha pitjima sheep etnanha nyilkngala initjika, errilknga tutjika, yirralhelitjikanta turta. Yinga pula pitjika sheep etnanha tangkalhelitjika, etna lyarta, ngampakala turta etatha nitjinanga.” ");
INSERT INTO are_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Yinga nama tnairnarintja marra era. Tnairnarintja marra era kala sheep ekuranhakakwia iluma. ");
INSERT INTO are_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tnairnarintja arrpunhala sheep ntjarra money-akakwia wara ntarntarama. Era turta itja sheep-akurtwia nama. Era kngulya itnura aa kngarra aramanga, era tira arrtjanama, sheep etnanha impurlalhamala. Itnura erantama sheep etnanha utnhuma, errarnpalhelama turta. ");
INSERT INTO are_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Artwa erataka tira arrtjanama era sheep etnanha money-akakwia wara ntarntaramanga. Era itja sheep etnakiperra kngarra etarlarama paka. ");
INSERT INTO are_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Yinga nama tnairnarintja marra era. Yinga sheep nukanha ntjarraka kaltja nama, etna turta nuka kaltjantema. ");
INSERT INTO are_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Yinga etnaka kaltja, Kaarta erala nuka kaltja namanga ngerra, yinga turtala Kaarta ekura kaltja namanga ngerra. Yinga kala sheep etnakakwia ilutjina. ");
INSERT INTO are_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sheep arrpunha ntjarra nuka namantema. Etna pula itja worla nhanhala nama. Etnanha turta atha Altjirrurna kngitjika. Etna kala yinganha wutjina. Kurunga worla nyinta nitjina, tnairnarintja nyinta turta. ");
INSERT INTO are_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kaarta era nuka kangkama, yinga ekura kangkwerramala ilutjinanga warta. Yinga turtantama relha errilknga ntjarranga wotha kamerritjina. ");
INSERT INTO are_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Arrpunhala yinganha yarna errilknga tuma. Yingarrpa Kaartaka kangkwerramala ilutjina. Nukathaka nama ilutjika, kamerritjika turta. Kaarta erarrpa yinganha lakinha turnaka.” ");
INSERT INTO are_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Angkatja nhanha wumala, relha Jew etna wotha iwurraka. ");
INSERT INTO are_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Arrpunha ntjarra angkaka, “Erataka errintjakarta. Artwa rirta. Relhataka ekura itja kangkwerritjika.” ");
INSERT INTO are_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Arrpunha ntjarra pula lakinhala angkaka, “Artwa errintjakarta yarna lakinha angkama. Artwa errintjakartala turta yarna relha pangaka alknga marrilama.” ");
INSERT INTO are_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kala lhurrpantama naka. Lhurrpala relha Jew ntjarra kutatha Jerusalem-ala worlerritjata temple-aka ingkairnintjaka arltaka ilpangkitjika. ");
INSERT INTO are_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Arlta arrpunhala Jesuanha temple lyuntja nyintala nthulapuka, lyuntja erinhala etna Solomon-aka Lyuntja ilitjata. ");
INSERT INTO are_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Relha Jew ntjarralantama erinha pmarraka. “Nurnataka ungkwangiperra yarna eterrama. Nurnanha kala arratja alpmelai, unta paka Krista era namama?” ");
INSERT INTO are_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesuala etnanha ilaka, “Atha rrangkarranha kalama alpmelaka. Rrangkarra pula yinganha itjala tnakaka. Tjatjikarta athala urrkapuma, yinga urrkapuma Kaartala yinganha turnakalanga. Lakinhanga rrangkarra kaltja neikanha yinga Krista era namanga. ");
INSERT INTO are_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Rrangkarra pula yinganha itjala tnakama, rrangkarra itja sheep nukanha namanga. ");
INSERT INTO are_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sheep nukanha ntjarrala yinganha wuma. Yinga etnaka kaltja. Etna turta nukanga tnaartangala pitjima. ");
INSERT INTO are_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Atha etnanha etathilitjina. Etnantama ngampakala etatha nitjina. Etna itja imerritjina. Arrpunhala turta etnanha itja kuta nukanga rakitjina. ");
INSERT INTO are_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kaarta nukanhala yinganha sheep nukanha ntjarranha nthaka. Era errintjangalka ekarltalkura nama. Arrpunhalantama etnanha yarna kuta Kaarta nukanhanga rakitjina. ");
INSERT INTO are_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kaarta ilaaka nyinta kuta nama.” ");
INSERT INTO are_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Relha Jew ntjarralantama wothantema parta kotjika, erinha errilknga tutjika. ");
INSERT INTO are_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesuala pula etnanha ilaka, “Kaartala yinganha turnakalanga warta, atha rrakangkarra tjatjikarta marra ntjarra ntelaka. Tjatjikarta nhanha ntjarrakakwiama rrangkarra yinganha partala watjika antja nama?” ");
INSERT INTO are_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Etna erinha alpmelaka, “Nurna nganha itja tjatjikarta marra ntjarrakakwia partala watjina. Nurna nganha partala watjina unta Altjirranha arrampowukalanga. Unta kunha relha wara. Kanha unta lyarta ilalhaka unta kula Altjirra namanga.” ");
INSERT INTO are_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesuala etnanha alpmelaka, “Altjirraka Angkatja Imankinyala ilama, ‘Atha Altjirrala rrangkarranha ilama, rrangkarra altjirra nama.’ ");
INSERT INTO are_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Lakinha Altjirranha errilkngipata rrakangkarranhurna angkaka. Era etnanha alpmelaka etna altjirra namanga. Altjirranha turta itja orrtjerrama. ");
INSERT INTO are_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Atha rrangkarranha ilaka yinga Altjirraka 'Lira namanga. Kaarta erarrpa angkaka yinga 'Lira ekura nitjika. Erarrpa turta yinganha relha alharinya ingkarrakurna yairnaka. Iwunhangantama rrangkarra yinganha ilparnama atha kula Altjirranha arrampowumanga? ");
INSERT INTO are_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yinga paka Kaarta nukanhaka itja kangkwerramanga, rrangkarra yinganha itja tnakitjika. ");
INSERT INTO are_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yinga pula Kaarta nukanhaka kangkwerramanga, rrangkarra yinganha tnakeikanha. Arai, yinga kaltja rrangkarra yinganha itja tnakamanga. Rrangkarra pula Kaarta erinha tnakai, era yinganha ekarltilakalanga tjatjikarta ntjarra urrkaputjika. Kurunga rrangkarra kaltja nitjina Kaarta era nukalela kuta namanga, yinga turta Kaartalela kuta namanga.” ");
INSERT INTO are_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Etnantama wotha antja naka erinha errkutjika. Era pula etnakanga urerranhaka. ");
INSERT INTO are_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kurunga Jesuanha wotha Jordan Lhiranga tjananhaka. Erantama katha nhanga ekururna lhaka, ekuralala John-ala relha ntjarranha kaltjirrpulhelakala. Pmara ekuralantama era kuterraka. ");
INSERT INTO are_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Relha ntjarrantama ekururna pitjika. Etna angkaka, “John-ala itja tjatjikarta urrkapuka. Yia nhanga John-ala nurnanha Jesuiperra ilakala, yia nhanha pula nthurrpala naka.” ");
INSERT INTO are_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Relha pmararinya ntjarra arrpunhalantama Jesuanha tnakaka. ");
INSERT INTO are_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Artwa Lazarus-anha menterraka. Era Bethany town-arinya naka. Kwaiya ekura Mary, Martha-anha turta town lenhala naka. ");
INSERT INTO are_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mary nhanhalataka Jesuaka ingka ntira unpa marrakartala parnakala, wotha kapurta korla ekuranhala rirrtjilakala turta. ");
INSERT INTO are_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mary, Martha tharralantama Jesuurna angkatja yairnaka, “Ingkartai, tjina ungkwanga nhanga menterrakau.” ");
INSERT INTO are_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yia nhanha wumala Jesuanha angkaka, “Lazarus-anha menterraka, itja pula kutanta ilutjika. Era menterraka relha ntjarrala Altjirranha tnantjitjinanga, 'Lira ekuranha turta.” ");
INSERT INTO are_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesuanha Martha-aka, tjia ekuranha Mary-aka, Lazarus-aka turta kngarra kangkaka. ");
INSERT INTO are_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Era pula wumalanga Lazarus-anha menta intamanga, era arlta tharra wotharrka kuterraka. ");
INSERT INTO are_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ekuriperrantantama era kurtungurla ntjarranha ilaka, “Mpa, nurna kala pmara Judea-urna wotha alpurrirriai.” ");
INSERT INTO are_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kurtungurla etna pula erinha alpmelaka, “Kaltjinthanhinthanhai, ngurruka wara relha Jew ntjarrala ungkwanga yonthaka, nganha partala wamala errilknga tutjika. Kanha unta alputjikala angkama?” ");
INSERT INTO are_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesuanha angkaka, “Arltala parrtja nama, 12 hours. Relha paka arltala nthulapumanga, era marra arama. Era itja irnangalka tnyinhitjina. ");
INSERT INTO are_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Relha pula ingula nthulapumanga, era yarna arama. Erantama kala irnangalka tnyinhitjina.” ");
INSERT INTO are_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kurunga Jesuala etnanha ilaka, “Lazarus, tjina nurnaka kunha ankwerraka. Yingantama nhanha lhama erinha kamalhelitjika.” ");
INSERT INTO are_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kurtungurla ntjarralantama erinha ilaka, “Ingkartai, era paka ankwentamanga, era kala marrerritjina.” ");
INSERT INTO are_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kurtungurla etnataka etarlaraka Jesuala etnanha ilamanga Lazarus-anha kula ankwentamanga. Kanha Jesuala etnanha ilaka Lazarus-anha errilkngala intamanga. ");
INSERT INTO are_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Lakinhanga Jesuala etnanha alkngatharrantama ilaka, “Lazarus-anha kunha iluka. ");
INSERT INTO are_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yinga pula kangkama yinga itja tanhala nakala era ilumanga. Inguntha rrangkarra yinganha tnakitjina. Mpa, nurna kala ekururna lhiaintama.” ");
INSERT INTO are_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas, rretnya arrpunha ekuranha ‘Tjoa’, erantama kurtungurla arrpunha ntjarranha ilaka, “Awa, nurna kala ekuralela lhiai, ilutjinala warta.” ");
INSERT INTO are_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesuanha kala Bethany-aka etinyerrakantama. Pmararinya ntjarralantama erinha ilaka Lazarus-anha kala arlta 4 wolkngala intamanga. ");
INSERT INTO are_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany era Jerusalem-anga etinya wara naka. ");
INSERT INTO are_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lakinhanga relha Jew ntjarra inthorra Martha Mary tharrurna pitjikala, erinhatharra alkngolkngilitjika. ");
INSERT INTO are_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Arrpunha ntjarralantama Martha-anha ilaka Jesuanha town-anga etinya namanga. Martha-anhantama ekururna lhaka. ");
INSERT INTO are_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mary-anha pula ilthalala kuterraka. Martha-ala Jesuanha ilaka, “Ingkartai, untataka parrpa pitjeikanha. Unta paka nhanhala nakalanga, tjia nuka itja ilumara. ");
INSERT INTO are_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yinga pula kaltja unta lyarta Altjirrurna ingkamanga Lazarus-aka, era nganha kala wutjina.” ");
INSERT INTO are_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesuala erinha ilaka, “Tjia ungkwanga wotha etatherramala kamerritjina.” ");
INSERT INTO are_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha-ala erinha alpmelaka, “Yinga kala kaltja era arlta ingkarnala kamerritjinala.” ");
INSERT INTO are_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesuala pula erinha ilaka, “Atharrpa relha errilknganha kamalhelama, etathilama turta. Relha ingkarraka kala ilutjina. Relha erala yinganha tnakama, era pula anma ngampakala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Relha tnakanhakanha athala etathilakala, era itja ngampakala errilknga intitjina. Unta angkatja nhanha tnakamama?” ");
INSERT INTO are_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha-ala erinha ilaka, “Awa, Ingkartai. Atha nganha tnakama. Unta Krista era nama, Altjirraka 'Lira. Altjirrala errilkngipata nurnakanha lhelakala era 'Lira ekuranha relha alharinya ingkarrakurna yairnitjinala.” ");
INSERT INTO are_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Lakinha angkamala, Martha-anha iltha ekuranhurna alpuka. Erantama Mary-anha tjukunya wara ilaka, “Kaltjinthanhinthanha era kunha kala pitjika. Era ungkwanga ntangkalhaka.” ");
INSERT INTO are_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nhanha wumala, Mary-anha parrpa kamerraka, Jesuurna lhaka turta. ");
INSERT INTO are_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesua era itjantema town-aka irrpukala. Era pula katha nhangalantema naka, ekuralala era Martha-alela angkarrakala. ");
INSERT INTO are_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Relha Jew ntjarra Mary-aka ilthala naka erinha alkngolkngilitjika. Etna aramalanga era parrpa kamerramala kathurna lhamanga, etna ekuranga tnaartangala lhaka. Etna eterraka era kula wolkngurna lhamanga, itnitjika. ");
INSERT INTO are_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mary-ntama Jesuurna pitjika. Ekuranga urlarra mparalela arrarnalhamala, era erinha ilaka, “Ingkartai, unta paka nhanhala nakalanga, tjia nuka itja ilumara.” ");
INSERT INTO are_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesuala erinha itnimanga araka. Relha Jew etna turta itnimanga. Erantama rwampia inthorrerraka, mpangkaka turta. ");
INSERT INTO are_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Erantama etnanha pmarraka, “Nthanhakama rrangkarra erinha arrarnaka?” Etna erinha ilaka, “Ingkartai, pitjai aritjika.” ");
INSERT INTO are_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesuanhantama itnika. ");
INSERT INTO are_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nhanha aramala relha Jew ntjarra ilarraka, “Arai, era kunha Lazarus-aka nthurrpa kngarra kangkaka.” ");
INSERT INTO are_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Urrputja arrpunha pula lakinhala ilarraka. “Era kunha artwa panga nhangaka alknga marrilakala. Era paka artwa nhanha erinha turta marrileikanha.” ");
INSERT INTO are_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ltarrpa kuta wulhamala, Jesuanha wolkngurna lhaka. Wolknga erataka intia naka, parta kngarritjala marntilakala. ");
INSERT INTO are_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesuala etnanha ilaka, “Parta erinha ankartiwai!” Martha, errilknga ekura kwaiya, era pula erinha ilaka, “Ingkartai, era kala nwarrintjama. Era kunha kala arlta 4 errilknga intakala.” ");
INSERT INTO are_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesuala pula erinha ilaka, “Atha nganha nhanga ilaka. Unta yinganha tnakamanga, unta aritjina Altjirranha makalaria inthorra namanga.” ");
INSERT INTO are_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Etna parta kngarritja erinha ankartiwukantama. Alkirurna inaramala, Jesuanha angkaka, “Kaartai, unta yinganha wuka. Lakinhanga atha nganha dangkilama. ");
INSERT INTO are_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yinga kala kaltja unta yinganha kutatha wuma. Yinga pula ungkwangurna alkngatharra angkaka, relha nhanha ntjarra kaltja nitjinanga unta yinganha yairnakala.” ");
INSERT INTO are_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kurunga Jesuanha intarra ilkaka, “Lazarus-ai, rratai!” ");
INSERT INTO are_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lazarus erantama rrataka, wolkngakanha mantarrakarta. Etna nhanga mantarra nhanhala iltja pa ingka ekuranha ilinyiwukala. Etna anngerra ekuranha turta mantarra arrpunhala korltakala. Lakinhanga Jesuala etnanha ilaka, “Mantarra etnanha ekuranga ilwai, era nthulaputjinanga.” ");
INSERT INTO are_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Arai, relha Jew ntjarra nhanga Mary-alela naka erinha alkngolkngilitjika. Relha nhanha etna araka Jesuala Lazarus-anha etathilamanga. Etnakanga ntjarra arrpunhalantama Jesuanha tnakaka. ");
INSERT INTO are_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kanha urrputja arrpunha artwa Pharisee ntjarrurnala lhaka, yiakarta. ");
INSERT INTO are_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kurunga priest-aka itornka ntjarrala, artwa Pharisee ntjarrala turtantama Sanhedrin council etnanha worlilaka. Sanhedrin council etnantama lakinha angkarraka, “Artwa nhanhala tjatjikarta ntjarra urrkapuma. Nurnataka erinha parritjika. ");
INSERT INTO are_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nurna paka erinha itja parramanga, relha ingkarrakala erinha tnakitjina. Nurnantama nthakinherritjina? Rome-arinya ntjarra pitjitjina. Etna pmara nurnakanha rakitjina, nurnanha turta ingkarraka yirralhelitjina.” ");
INSERT INTO are_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Caiaphas erataka High Priest naka, year lenhala. Erantama etnanha ilaka, “Rrangkarrataka marntilparla ntjarra. ");
INSERT INTO are_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Arai, nhanha marralkura nama artwa nyinta relha ntjarrakakwia ilutjika, nhanhangatjina, Rome-arinya ntjarrala relha ingkarrakanha errilknga tutjika.” ");
INSERT INTO are_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Era lakinha angkaka era High Priest namanga. Altjirraka Enkalataka erinha ilakala Jesuanha relha Jew ingkarrakaka ilutjinala. ");
INSERT INTO are_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Itja pula etnakanta. Altjirraka tjina pmararrpaninhala namala ntjarraka turta, era etnanha ingkarraka worlilitjinanga. ");
INSERT INTO are_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sanhedrin council etnantama antja naka Jesuanha errilknga tutjika. ");
INSERT INTO are_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lakinhanga Jesuanha relha Jew ntjarraka itornkanga lauwulhaka. Era Ephraim town-urnantama lhaka. Town nhanha erataka worritjanga kuta naka. Town ekuralantama Jesuanha kuterraka kurtungurla ekuranha ntjarralela. ");
INSERT INTO are_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Relha Jew ntjarraka Passover tjinkarra lyartathakantema naka. Relha ntjarra pula pmararrpaninhanga mparrama Jerusalem-ala worlerraka, mpaarangarangamalkura ilkngilhitjika, tjinkarrakatjila. ");
INSERT INTO are_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Etnantama Jesuaka yonthaka. Temple-ala itnarlapumala, etna pmarrarraka, “Nthakinha etarlaramai? Era paka tjinkarraka pitjitjinama?” ");
INSERT INTO are_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Priest-aka itornka ntjarrala, artwa Pharisee ntjarrala turtataka relha ntjarranha turnakala, “Rrangkarra Jesuanha aramanga, nurnanha ilau, nurna erinha errkutjinanga.”");
INSERT INTO are_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Arlta 6-iperra etna Passover tjinkarra erinha ilkutjika naka. Jesuanhantama Bethany-urna pitjika. Town nhanhala Lazarus-anha naka, artwa nhanga Jesualala errilknga ntjarranga kamalhelakala. ");
INSERT INTO are_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mary Martha tharralantama Jesuaka, tjina ekuranha ntjarraka turta, tjinkarra urrkapuka. Etnantama arrarnalhaka marna ilkutjika. Lazarus-anha turta arrarnalhakantema. Kurunga Martha-ala etnaka marna errarnpalhelaka. ");
INSERT INTO are_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mary-alantama jar ntira unpa marrakarta inarlalhaka. Ntira tjiparra inthorra erinha pulai. Erantama nhanha Jesuaka ingkaka thalaka. Kurunga era Jesuaka ingka wotha rirrtjilaka, kapurta korla ekuranhala. Iltha ekuralantama etna unpa marra erinhanta ntjarnaka. ");
INSERT INTO are_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iscariot Jesuaka kurtungurla naka. Era Jesuanha anma leltjaka lanthitjika nakala. Erantama angkaka, ");
INSERT INTO are_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Iwunhangama era ntira unpa marrakarta nhanha itja yirrinthaka? Ntira erinha kunha money kngarra inthorraka yirrinthamara. Era turtantama money erinha relha ilkngara ntjarranha nthamara.” ");
INSERT INTO are_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas era itja relha ilkngara ntjarraka konyerraka. Era wara lakinha angkaka era nyilkngampa namanga. Relha ntjarrala Jesuanha, kurtungurla ekuranha ntjarranha turta money nthitjata. Money nhanhantama etna Judas-anha nthitjata etnaka ntarntaritjika. Era pula money arrpunha nyilkngala initjata. ");
INSERT INTO are_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesuala pula etnanha ilaka, “Erinha impai! Erataka yinganha mparrama ntirala parnakala. Anma etna yinganha wolkngaka kurnitjina. ");
INSERT INTO are_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Arai, relha ilkngara ntjarra kunha rrakangkarralela kutatha nitjina rrangkarra paka etnanha pelitjika antja namanga. Yinga pula itjala rrakangkarralela kuta nitjina.” ");
INSERT INTO are_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Relha Jew ntjarrala wumalanga Jesuanha Bethany-ala namanga, etna pitjika erinha aritjika, Lazarus-anha turta. Lazarus erinhataka Jesuala nhanga errilknga ntjarranga kamalhelakala. ");
INSERT INTO are_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Priest itornka ntjarralantama Lazarus-anha turta errilknga tutjika antja naka, itja Jesuanhanta. ");
INSERT INTO are_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Relha Jew arrpunha ntjarralataka Jesuanha tnakaka, etna Lazarus-anha etatha arakalanga. ");
INSERT INTO are_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Relha ntjarra Jerusalem-urna pitjikala Passover tjinkarra ilkutjika. Relha etnantama wuka Jesuanha turta tjinkarraka pitjimanga. ");
INSERT INTO are_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Etnantama rrangkia walya kamala, walyakarta ekururna urlarrakurlarra lhaka. Etna kuta ilkaka, Nurna Altjirranha tnantjama. Altjirrai, urrpia ungkwanganha lyekarrilai, erala lyarta nurnakurna pitjima. Altjirrai, Israel-arinya ntjarraka king lyekarrilai.” ");
INSERT INTO are_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesuala donkey kurrka aramala, donkey ekura ntjika. Nhanga Altjirraka Angkatja Imankinyala ilama, ");
INSERT INTO are_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Relha Jerusalem-arinya ntjarrai, rrangkarra itja trerritjika. Arai, king rrakangkarra, rrakangkarrurna pitjima donkey kurrkala nanhamala.” ");
INSERT INTO are_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kurtungurla ntjarrala Jesuanha aramalanga donkey-ala nanhamanga, etna Altjirraka Angkatja Imankinya nhanhaka itja ilpangkaka. Anmanta, Jesuanha kala alkirurna alpukalangantama, etna angkatja ekura ilpangkaka. Etna turta lhangkaraka angkatja era ilakala Jesuanha lakinha Jerusalem-urna irrputjinala. ");
INSERT INTO are_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Arai, relha ntjarrala Jesuanha nhanga araka era Lazarus-anha errilknga ntjarranga kamalhelamanga. Etnantama nhanhiperra kuta angkarlanaka, Jerusalem-ala. ");
INSERT INTO are_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Relha arrpunha ntjarrala turtantama tjatjikarta nhanhiperra wuka. Etna turtantama Jesuurna lhaka. ");
INSERT INTO are_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Artwa Pharisee ntjarrantama ilarraka, “Nurna kunha erinha yarna parraka. Lyarta relha ingkarrakantama ekuranga tnaartangala lhama.” ");
INSERT INTO are_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Relha Greece-arinya urrputja turta Jerusalem-ala naka. Etna nhanga pitjikala Altjirraka urrkurrkintja nitjika, Passover-aka arltala. ");
INSERT INTO are_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Etna Philip-urna pitjika, artwa Bethsaida-arinya nhangurna. Bethsaida town kunha pmara Galilee-ala naka. Etnantama Philip-anha ilaka, “Itornkai, nurnataka Jesuanha aritjika antja.” ");
INSERT INTO are_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip-anhantama Andrew-urnakimparra lhaka, erinha nhanha alpmelaka turta. Kurunga eratharra tharrantema Jesuurna lhaka. Eratharra erinha alpmelaka, artwa Greece-arinya urrputjala erinha aritjika antja namanga. ");
INSERT INTO are_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesualantama etnanha ilaka, “Lyarta Kaarta nukanhakathaka nama, relha ingkarrakanha ntelitjika Relhaka 'Lira era makalaria namanga. ");
INSERT INTO are_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Atha rrangkarranha nhanha nthurrpa inthorra ilama. Relhala kunha wheat annga arnaka kurnama. Kurunga annga era iluma ngerra, irna turtantama annga ekuranga mangkama. Kurunga irna era anngakarterramantama. Annga era paka itja ilumangarrka, era yarna annga ntjarrakarterrama. ");
INSERT INTO are_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Arai, relha erala thakerrama alhala kuta etatha nitjika, era ngampakala ilutjina. Kanha relha erala itja thakerrama alha nhanhala kuta etatha nitjika, era ngampakalala etatha nitjina. ");
INSERT INTO are_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Relha erala antja nama nuka kangkwerritjika, era kala nukanga tnaartangala pitjitjika. Kurunga era nukalela kuta nitjina. Arai, relha erala nuka kangkwerrama, Kaarta nukanhala erinha tnantjitjina. ");
INSERT INTO are_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Yingataka lyarta ltarrpa wulhama. Yinga pula yarna Kaarturna angkama, ‘Kaartai, yinga itja antja nama nyingalauwutjika’. Nhanhakakwia kunha yinga alhurna pitjika. ");
INSERT INTO are_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kaartai, untantama relha ingkarrakaka ntelalhai unta makalaria namanga.” Altjirranhantama alkiranga angkaka, “Yinga kala ntelalhaka yinga makalaria namanga. Yinga turta wotha ntelalhitjina yinga makalaria namanga.” ");
INSERT INTO are_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Relha etna wuka arrpunha angkamanga ngerra. Arrpunha ntjarrantama angkaka, “Kwatja angkamanga wai.” Kanha arrpunha ntjarrala etnanha ilaka, “Angel-ataka ekururna angkaka.” ");
INSERT INTO are_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","31","Jesuala pula etnanha ilaka, “Altjirranha itja nukakwia angkaka, rrakangkarrakwia pula. Lyarta Altjirrala relha alharinya ingkarrakanha kala tjiperrawuma. Lyarta era relha alharinya ingkarrakaka itornka erinha pmakwinama. ");
INSERT INTO are_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Anma etna yinganha ntolkaka kanthatumanga, atha relha ingkarrakanha ntangkitjina yinganha tnakitjika.” ");
INSERT INTO are_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Erataka lakinha angkaka etna kaltja nitjinanga era ntolkala ilutjinala. ");
INSERT INTO are_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Relha etna pula erinha ilaka, “Altjirraka Angkatja Imankinyala ilama Kristanha kuta etatha nitjinala. Nthakinhantama unta ilama Relhaka 'Lirakathaka namanga ntolkala ilutjika? Ngunhama Relhaka 'Lira nhanha era nama?” ");
INSERT INTO are_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesuala etnanha ilaka, “Kurrka warantantama parrtja era rrakangkarralela nitjina. Parrtjantema namalanga nthulapai, ingwerrakitjangathatha. Relha erala ingula nthulapuma, era paalapaala wara nthulapuma. ");
INSERT INTO are_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Rrangkarra pula erinha tnakitjika, erala rrakangkarra parrtja namanga. Kurunga rrangkarra parrtja ekura katjia nitjina.” Lakinha angkamala Jesuanha lhaka, relha ntjarranga lauwulhaka turta. ");
INSERT INTO are_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesuala kunha tjatjikarta ntjarra inthorra relha ntjarranga alkngatharra urrkapukala, etna pula erinha itja kuta tnakaka. ");
INSERT INTO are_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Altjirraka urrpia Isaiah-aka angkatjantama nthurrperraka. “Ingkartai, ngunhalama angkatja nurnakanha tnakaka? Ngunhala turtama araka Ingkartanha ekarlta inthorra namanga?” ");
INSERT INTO are_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Relha etna Jesuanha yarna tnakaka. Isaiah-ala nhanga ilaka, ");
INSERT INTO are_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Altjirrala alknga etnakanha pangilaka, etna alknga etnakanhala arakitja. Era eterrintja etnakanha parrpartilaka turta, etna arratja eterrakitja. Kurunga etna toperrakitja, Altjirrala turtantama etnanha tangkalhelakitja.” ");
INSERT INTO are_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah-ala araka Jesuanha makalaria namanga. Lakinhanga era nhanha Jesuiperra ilakala. ");
INSERT INTO are_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Relha Jew-aka itornka arrpunha ntjarrala Jesuanha tnakaka. Etna pula itja ilalhaka etna erinha tnakamanga, artwa Pharisee ntjarrala etnanha synagogue-anga unpurlenakitja. ");
INSERT INTO are_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Itornka nhanha etnataka kngarralkura antja naka relha ntjarrala etnanha tnantjitjika, nhanhangatjina, Altjirrala etnanha tnantjitjika. ");
INSERT INTO are_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesuala etnanha angkatja intarrala ilaka, “Relha erala yinganha tnakama, era erinha turta tnakama, erala yinganha yairnakala. ");
INSERT INTO are_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Relha erala yinganha arama pa lhangkarama, era erinha turta arama pa lhangkarama, erala yinganha yairnakala. ");
INSERT INTO are_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yingataka alhurna pitjika relha ingkarrakaka parrtja nitjika. Lakinhanga relha erala yinganha tnakama, era itja wotha thapathapala ngerra nama. ");
INSERT INTO are_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Relha erala angkatja nukanha wumanga, ekura pula itja kangkwerramanga, atha erinha itja tjiperrawutjina. Yingataka pitjika relha alharinya ntjarranha tangkalhelitjika, itja etnanha imilitjika. ");
INSERT INTO are_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Thunga relha nuka antjakunya nama, angkatja nukanha turta itja tnakama. Erinhataka angkatja nukanhala imilitjina, Altjirrala anma relha ingkarrakanha tjiperrawumanga. ");
INSERT INTO are_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Arai, angkatja athala rrangkarranha ilama, etna itja angkatja nukanha nama. Kaarta erala yinganha rrakangkarrurna yairnakala, era yinganha turnaka angkatja nhanha etnanha rrangkarranha ilitjika. ");
INSERT INTO are_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yinga turta kaltja angkatja ekuranhala relhanha ngampakala etathilama. Lakinhanga atha rrangkarranha angkatja ekuranhanta ilama.” ");
INSERT INTO are_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Relha ntjarra Passover tjinkarra erinha kala ilkutjika naka. Jesuanha turta kaltja naka nhanha kala ekurathaka namangantama, alha nhanhanga Kaarturna alputjika. Era nhanga tjina ekuranha ntjarraka kangkaka. Erantama etnaka kuta kangkaka era ilutjinalpula. ");
INSERT INTO are_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Etnantama ngurrula marna ilkurlanaka. Errintjalataka Judas-anha, Simon Iscariot-aka worra nhanga, kala turnakala Jesuanha leltjaka lanthitjika. ");
INSERT INTO are_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesuanha kaltja naka Kaartala erinha ekarlta inthorrilakala. Era turta kaltja naka era Altjirranga pitjikala, Altjirrurna turta alputjinala. ");
INSERT INTO are_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Erantama kamerramala mantarra tjenya ekuranha iluka. Towel-ntama inamala, era towel-ala yirnalhaka. ");
INSERT INTO are_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kurunga kwatja taarnaka thalamala, era kurtungurla ekuranha ntjarraka ingka ilkngika, towel-ala wotha rirrtjilaka turta. ");
INSERT INTO are_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Era Simon Peter-aka ingkantama ilkngitjikerramalanga, Peter-ala erinha pmarraka, “Ingkartai, untama ingka nukanha ilkngitjina?” ");
INSERT INTO are_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesuala erinha alpmelaka, “Iwunhangama atha ingka ungkwanganha ilkngima? Arai, unta nhanha lyarta itja lhangkarama. Anma pula unta nhanha lhangkaritjinantama.” ");
INSERT INTO are_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter-ala erinha ilaka, “Unta itja inthorra ingka nukanha ilkngitjika.” Jesuala pula erinha alpmelaka, “Atha paka nganha itja ilkngimanga, unta itja inthorra tjina nukanha nitjina.” ");
INSERT INTO are_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Peter-alantama erinha ilaka, “Lakinhanga paka Ingkartai, itja ingka nukanhanta ilkngai. Iltja pa anngerra nukanha turta.” ");
INSERT INTO are_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesuala pula erinha ilaka, “Relha erala walhakala, era kala mpurrka ekuranha ilkngika. Kala ingka ekuranhanta wotha ulpurterrama. Atha kunha rrangkarranha kala ilkngika. Rrangkarrantama ulpurtakunya turta nama, artwa nyintanta itja.” ");
INSERT INTO are_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesuanha kala kaltjakwia naka artwa ekura, erala erinha leltjaka lanthitjinala. Lakinhanga era ilaka, “Artwa nyintanta itja.” ");
INSERT INTO are_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Era kala ingka etnakanha ilkngikalangantama, Jesuanha wotha mantarra tjenya ekuranhaka ekarralhaka, katha ekuranhaka turta arrarnalhaka. Erantama etnanha pmarraka, “Nthakinhama yinga ntelalhaka ingka rrakangkarranha ilkngimala? ");
INSERT INTO are_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Rrangkarra angkama yinga ‘Kaltjinthanhinthanha’ namanga, ‘Ingkarta’ turta. Rrangkarra kala arratja kuta angkama, yinga nhanha namanga warta. ");
INSERT INTO are_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Arai, atha, Kaltjinthanhinthanha era pa Ingkarta rrakangkarranhala ingka rrakangkarranha ilkngika. Lakinha rrangkarra turta nyintaminyintala arrpunhaka ingka ilkngitjikantema. ");
INSERT INTO are_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yingala rrakangkarra ntelalhakala ngerra, lakinha rrangkarra turta ntelalhitjika. ");
INSERT INTO are_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Atha rrangkarranha nhanha nthurrpa inthorra ilama. Urrkapunhapunha era itja itornka ekuranhanga kngarralkura nama. Urrpia era turta itja kngarralkura nama relha ekurangatjina, erala erinha yairnakala. ");
INSERT INTO are_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Rrangkarra angkatja nukanha kala wuka. Rrangkarrantama angkatja nukanhaka kangkwerramanga, rrangkarra arrkana inthorra nitjina. ");
INSERT INTO are_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Yinga pula itja rrakangkarra ingkarrakiperra angkama. Yinga kala kaltja, artwa nhanga athala urrarakala ntjarranga, nyintala yinganha leltjaka lanthitjina. Era yinganha leltjaka lanthamalanga, Altjirraka Angkatja Imankinya nhanha nthurrperritjina, ‘Artwa erala nukalela marna ilkuma, era kunha yinganha lolowuka.’ ");
INSERT INTO are_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Athataka rrangkarranha nhanha mparrama alpmelaka. Kurunga nhanha nthurrperramalanga, rrangkarra kaltja nitjina Altjirraka Angkatja Imankinya nukiperra angkamanga. ");
INSERT INTO are_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Atha rrangkarranha nhanha nthurrpa inthorra ilama. Relha era, erala urrpia nukanhaka kangkintja ntelalhama, era nuka kangkintja ntelalhama. Relha erala nuka kangkintja ntelalhama, erataka ekura kangkintja ntelalhama, erala yinganha yairnakala.” ");
INSERT INTO are_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Lakinha angkamaliperra, Jesuanha rwampia inthorra wulhaka. Erantama etnanha ilaka, “Atha rrangkarranha nhanha nthurrpa inthorra ilama. Rrakangkarranga nyintalataka yinganha leltjaka lanthitjina.” ");
INSERT INTO are_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kurtungurla etna pula yarna eterramala ararraka. Etnantama pmarrarraka, “Ngunhiperrama era angkama?” ");
INSERT INTO are_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kurtungurla arrpunha, ekurala Jesuanha kangkaka, era Jesuanga kuta naka. ");
INSERT INTO are_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Peter-anhantama kurtungurla ekura kwerraka, era Jesuanha pmarritjika, “Ngunhiperrama unta angkama?” ");
INSERT INTO are_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kurtungurla erantama Jesuanha pmarraka, “Ingkartai, ngunhiperrama unta angkama?” ");
INSERT INTO are_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesuala erinha ilaka, “Artwa ekuriperrakwia, erinhala atha marna ungkwaltja nhanha nthitjina, ungkwaltja erinha karakwatjaka thankumala.” Kurunga Jesuala marna ungkwaltja erinha thankumala Judas-anha nthaka, Simon Iscariot-aka worra nhanganha. ");
INSERT INTO are_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas-ala warta marna erinha inaka, kanha Satan-anhala ekururna irrpuka. Jesualantama Judas-anha ilaka, “Unta antja naka yinganha leltjaka lanthitjika. Kala yinganha parrpa etnaka lanthai.” ");
INSERT INTO are_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kurtungurla ntjarrala pula Jesuaka angkatja itja lhangkaraka. ");
INSERT INTO are_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas-ala nhanga money etnakanha tnyinitjata. Arrpunha ntjarralantama etarlaraka Jesuala kula erinha ilamanga Passover tjinkarraka yultha initjika. Arrpunha ntjarrala pula etarlaraka era kula Judas-anha yairnakalanga relha ilkngara ntjarranha pelitjika. ");
INSERT INTO are_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Marna ungkwaltja erinha inamala ngerra, Judas-anha kathurna lhaka. Kala ingwa naka. ");
INSERT INTO are_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas-anha kala lhakalangantama, Jesuala etnanha ilaka, “Lyarta Altjirrala kathilaka Relhaka 'Lira era makalaria namanga. Relhaka 'Lirarlarlanga Altjirranha turta ntelalhaka erarrpa makalaria namanga. ");
INSERT INTO are_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Relhaka 'Lirala relha ntjarranha ntelaka Altjirranha makalaria namanga. Altjirrala turtantama relha ntjarranha ntelitjina Relhaka 'Lira era makalaria namanga. Itja anma, kala lyartantema. ");
INSERT INTO are_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Katjia kurrka nukanha ntjarrai. Yinga kunha kurrka warantantama rrakangkarralela nitjina. Kurunga rrangkarra nuka yonthitjina, rrangkarra pula yinganha itja arltaritjina. Atha nhanga relha Jew ntjarranha ilakala ngerra, atha nhanha rrangkarranha turtantama ilama, ‘Pmara ekururna yingala lhitjina, ekururna rrangkarra yarna lhama.’ ");
INSERT INTO are_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Atha pula rrangkarranha turnintja lyartinyantama ilama. Rrangkarra urlarrakurlarra kangkintja ntelalhitjika. Yingala rrakangkarra kangkakala ngerra, lakinha rrangkarra turta urlarrakurlarra kangkintja ntelalhitjika. ");
INSERT INTO are_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Rrangkarra urlarrakurlarra kangkintja ntelalhamanga, relha ingkarrakala lhangkaritjina rrangkarra kurtungurla nukanha namanga.” ");
INSERT INTO are_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter-alantama Jesuanha pmarraka, “Ingkartai, nthanhurnama unta lhitjina?” Jesuala erinha ilaka, “Pmara ekururna yingala lhitjina, unta lyarta yarna nukanga tnaartangala pitjima. Anma pula unta nukanga tnaartangala pitjitjina.” ");
INSERT INTO are_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Simon Peter-ala pula erinha wotha pmarraka, “Ingkartai, iwunhangala yinga lyarta ungkwanganga yarna tnaartangala lhama? Yinga kala ungkwangakwia ilumara.” ");
INSERT INTO are_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesualantama Peter-anha pmarraka, “Nthurrpama unta nukakwia ilumara? Peter-ai, atha nganha nthurrpa inthorra ilama. Lukaluka orrea era angkitjikanhangantema, unta yinganha kala tharraminyintaranga yiparrarnitjinatitja.” ");
INSERT INTO are_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Rrangkarra itja rwampia wulhitjika. Altjirranha tnakai. Yinganha turta tnakai. ");
INSERT INTO are_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yinga itja orrtjerrama. Arai, Kaarta nukanhaka pmara kngarritja inthorra nama. Yingantama lhitjina rrakangkarra pmara mpaaritjika. ");
INSERT INTO are_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ekuriperra yinga pitjalputjina rrangkarranha inarlalhitjika, rrangkarra nukalela nitjinanga Kaarta nukanhaka pmarala. ");
INSERT INTO are_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tjaiya erala Kaartaka pmarurna intanhama, ekura rrangkarra kala kaltja.” ");
INSERT INTO are_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas-ala pula erinha ilaka, “Ingkartai, nurna pula pmara ekura kotnala. Nthakinhantama nurna tjaiya ekura yonthitjina?” ");
INSERT INTO are_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesuala erinha ilaka, “Yingarrpa tjaiya era nama. Athanta relhanha Altjirriperra arratja kaltjinthama. Atharrpa relhanha etathilama. Arai, nukakunya relha yarna kuta Kaarturna lhama. ");
INSERT INTO are_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Rrangkarra paka yinganha arratja lhangkarakalanga, rrangkarra Kaarta nukanha turta arratja lhangkaramarantema. Lyarta rrangkarra ekura kala kaltjantama, rrangkarra erinha kala arakala turta.” ");
INSERT INTO are_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip-ala pula erinha ilaka, “Ingkartai, kala Kaarta erinhanta nurnaka imarnai.” ");
INSERT INTO are_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesuala erinha ilaka, “Philip-ai, yinga kunha rrakangkarralela kuta inthorra nakala. Kanha unta yinganha itjantemala lhangkarama? Arai, relha erala yinganha arakala, erataka Kaarta erinha arakantema. Nthakinhantama unta yinganha pmarrama, ‘Kaarta erinha nurnaka imarnai?’ ");
INSERT INTO are_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Iwunhangama unta angkatja nukanha itja tnakama? Yinga Kaartalela kuta nama. Kaarta era turta nukalela kuta nama. Angkatja nukanha, angkatja ekuranha nama. Kaarta era nukarlarlanga angkama, era nukarlarlanga urrkapuma turta. ");
INSERT INTO are_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Rrangkarrataka yinganha tnakitjika, yinga angkamalanga yinga Kaartalela kuta namanga, Kaarta era turta nukalela kuta namanga. Itjanga paka rrangkarra yinganha tnakai, tjatjikarta nukanhakakwia. ");
INSERT INTO are_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Atha rrangkarranha nhanha nthurrpa inthorra ilama. Relha erala yinganha tnakama, era tjatjikarta urrkaputjina, athala tjatjikarta urrkapukala ngerra. Era turta tjatjikarta kngarralkura urrkaputjina, yinga Kaarturna alpumanga warta. ");
INSERT INTO are_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Rrangkarra tjina nukanha nama. Rrangkarra Kaarturna ingkamanga, atha rrangkarranha kala nthitjina. Lakinha atha relha ingkarrakanha ntelitjina Kaarta era makalaria namanga. ");
INSERT INTO are_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Rrangkarra paka nukurna ingkamanga, atha rrangkarranha kala wutjina, rrangkarra tjina nukanha namanga warta.” ");
INSERT INTO are_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Rrangkarra paka nuka kangkamanga, rrangkarra nuka kangkwerritjina. ");
INSERT INTO are_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yingantama Kaarturna ingkitjina era Enka erinha rrakangkarrurna yairnitjika, rrakangkarra tangitjala nitjika. Era turtantama rrakangkarralela nitjina alha nhanhaka talwalpula. ");
INSERT INTO are_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Enka nhanha era itja kuta orrtjerrama. Relha alharinya etna pula Enka ekura antjakunyala. Etna erinha itja arama. Etna turta ekura kotna nama. Rrangkarra pula ekura kaltjala, era rrakangkarranga mpopala namanga, rrakangkarralela kuta namanga turta. ");
INSERT INTO are_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Yinga lhitjina. Atha pula rrangkarranha itja lhompa ngerra impurlalhitjina. Yinga wotha rrakangkarrurna pitjalputjina. ");
INSERT INTO are_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Inguntha wara relha alharinya ntjarrala yinganha itja wotha aritjina. Rrangkarra pula yinganha wotha aritjina. Yinga etatha namanga, rrangkarra turtantama etatha nitjinantema. ");
INSERT INTO are_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kurunga arlta lenha ekurala rrangkarra kaltja nitjina yinga Kaartalela kuta namanga, rrangkarra nukalela kuta namanga, yinga turta rrakangkarralela kuta namanga. ");
INSERT INTO are_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Relha erala angkatja nukanhaka kangkwerramanga, era kunha nuka kangkama. Relha erala nuka kangkama, ekura Kaarta nuka kangkitjinantema. Yinga turta ekura kangkitjinantema. Yinga turta ekura ntelalhitjina.” ");
INSERT INTO are_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas arrpunhala, itja Iscariot-ala, Jesuanha pmarraka, “Ingkartai, nthakinhala unta nurnakanta ntelalhitjina, kanha relha alharinya ntjarraka itjala?” ");
INSERT INTO are_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesuala erinha ilaka, “Relha erala nuka kangkama, era angkatja nukanhaka kangkwerritjina. Kaarta nukanha turtantama ekura kangkitjina. Kurunga Kaarta ilaaka ekururna pitjitjina, ekuralela kuterritjina turta. ");
INSERT INTO are_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kanha relha erala nuka itja kangkama, era turta angkatja nukanhaka itja kangkwerrama. Angkatja rrangkarrala wuma, etna itja angkatja nukanha nama. Etnataka Kaartaka angkatja nama, Kaarta erala yinganha yairnakala. ");
INSERT INTO are_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Atha rrangkarranha nhanha ingkarraka alpmelaka yinga rrakangkarralela namalangantema. ");
INSERT INTO are_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kaartala Enka Alkngaltara erinhantama rrakangkarrurna yairnitjina, rrakangkarra tangitjala nitjika. Erantama rrangkarranha kaltjinthitjina, rrangkarranha ilpangkalhelamala angkatja ingkarrakaka, athala rrangkarranha kala ilakala. ");
INSERT INTO are_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Arai, atharrpa rrangkarranha kala Altjirralela rilherilaka. Nhanha kutantaka nama. Relhala nhanha yarna urltakama. Lakinhanga rrangkarra itja rwampia wulhitjika, rrangkarra turta itja trerritjika. ");
INSERT INTO are_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Atha nhanga rrangkarranha ilaka. ‘Yinga lhitjina, yinga turta wotha pitjalputjina.’ Rrangkarra paka nuka nthurrpa kangkamanga, rrangkarra arrkana namara yinga Kaarturna lhitjinanga. Kaarta era kunha nukanga kngarralkura nama. ");
INSERT INTO are_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Atha rrangkarranha nhanha mparrama alpmelaka, rrangkarra yinganha tnakitjinanga, nhanha ingkarraka nthurrperramanga. ");
INSERT INTO are_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yinga itja rrakangkarralela kngarra wotha angkitjina. Arai, relha alharinya ntjarraka itornka, errintja era purrama, era kunha pitjima. Era pula nuka yarna tjitjarterrama. ");
INSERT INTO are_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yinga pula Kaarta nukanhaka kangkwerrama, relha alharinya ntjarra kaltja nitjinanga yinga Kaartaka kangkamanga. Mpa, nurna kala nhanhanga lhiaintama.” ");
INSERT INTO are_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Yinga nama irna grapes inthorra era. Kanha Kaarta nukanha grapes-aka ntarntarintja erala. ");
INSERT INTO are_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Etintja nukanha arrpunha ntjarra marnakunya namanga, Kaartala etnanha kala inturnama. Kanha etintja arrpunha ntjarra marnakarta namanga, era etnanha kurrka warala kama, etintja etna marna kngarralkura lhalhelitjinanga. ");
INSERT INTO are_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lakinha ngerra Kaartala rrangkarranha kala kurrka wara kaka, angkatja nukanharlarlanga. ");
INSERT INTO are_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","“Rrangkarra nukalela kuta nitjika, yingala rrakangkarralela kuta namanga ngerra. Etintja etna yarna marnakarterrama, etnanha irnanga inturnakalanga. Lakinha ngerra rrangkarra turta yarna marnakarterrama, rrangkarra paka itja nukalela kuta namanga. ");
INSERT INTO are_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yinga nama irna grapes era, kanha rrangkarra etintja etnala. Relha erala nukalela kuta nama, yinga turta ekuralela kuta nama, era marna kngarra lhalhelama. Arai, nukakunya rrangkarra yarna marna lhalhelama. ");
INSERT INTO are_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Thunga relha itja nukalela kuta nama. Kaartala erinha inturnamala iwutjina, etintja marnakunya ngerra. Era ntjirrkerritjina. Kurunga etna etintja ntjirrka nhanha erinha, etintja ntjirrka arrpunha ntjarranha turta, kotjimala uraka iwuma. ");
INSERT INTO are_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Rrangkarra nukalela kuta nitjika. Rrangkarra turta angkatja nukanhaka kuta ilpangkitjika. Kurunga rrangkarra nukurna ingkamanga, atha rrangkarranha kala wutjina. ");
INSERT INTO are_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Marna kngarra lhalhelamala rrangkarra arrpunha ntjarranha ntelitjina rrangkarra kurtungurla nukanha namanga. Rrangkarra turta etnanha ntelitjina Kaarta era makalaria namanga. ");
INSERT INTO are_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yinga kunha rrakangkarra kangkaka, Kaarta erala nuka kangkakala ngerra. Itja nukanga ntjumerritjika. ");
INSERT INTO are_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kaarta era nuka kuta kangkama yinga turnintja ekuranhaka kangkwerramanga. Lakinha ngerra yinga rrakangkarra turta kuta kangkitjina, rrangkarra turnintja nukanhaka kangkwerramanga. ");
INSERT INTO are_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Atha rrangkarranha nhanha ingkarraka alpmelaka, rrangkarra arrkana inthorra nitjinanga, yingala arrkana inthorra namanga ngerra. ");
INSERT INTO are_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Atha rrangkarranha turnama, rrangkarra urlarrakurlarra kangkintja ntelalhitjika, yingala rrakangkarra kangkintja ntelalhakala ngerra. ");
INSERT INTO are_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Relha paka relha arrpunhakakwia ilumanga, relha era kala ntelalhama, era relha arrpunha ekura kngarra inthorra kangkamanga. ");
INSERT INTO are_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Rrangkarra turnintja nukanhaka kangkwerramanga, rrangkarra kala tjina nukanha nama. ");
INSERT INTO are_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Atha itja wotha rrangkarranha ilama rrangkarra urrkapunhapunha nukanha namanga. Itornkala kunha itja urrkapunhapunha ekuranha yia ingkarraka alpmelama. Atha pula rrangkarranha tjinatitjala anparnama. Atha kunha rrangkarranha yia ingkarraka alpmelaka, athala Kaartanga wukala. ");
INSERT INTO are_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Itja rrangkarrakimparra nuka antja naka. Yingatitja rrakangkarra antja naka. Athantama rrangkarranha urraraka, marna kngarra lhalhelitjika, marna nhanga etnala itja yirritjina. Kurunga rrangkarra Kaarta ekururna ingkamanga rretnya nukanhala, era rrangkarranha kala wutjina. ");
INSERT INTO are_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Atha rrangkarranha turnama, rrangkarra urlarrakurlarra kangkintja ntelalhitjika.” ");
INSERT INTO are_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Thunga relha alharinya ntjarra rrakangkarra yirrkngerrama. Ilpangkai etna nukakimparra yirrkngerrakala. ");
INSERT INTO are_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Rrangkarra paka tjina etnaka namanga, etna kala rrakangkarra kangkamara. Rrangkarra pula itja tjina etnaka nama, atha rrangkarranha urrarakalanga tjina nuka nitjika. Lakinhanga etna rrakangkarra yirrkngerrama. ");
INSERT INTO are_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Rrangkarra ilpangkamama? Atha nhanga rrangkarranha ilaka, ‘Urrkapunhapunha era itja itornka ekuranhanga kngarralkura nama.’ Etna paka yinganha tutjika lurnamanga, etna kala rrangkarranha tutjika lurnitjinantema. Etna paka nuka kangkwerramanga, etna rrakangkarra kangkwerritjinantema. ");
INSERT INTO are_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","“Rrangkarra tjina nukanha namanga, etna rrakangkarra ntelalhitjina, etnala nuka ntelalhakala ngerra. Etna rrakangkarra lakinha ntelalhitjina, etna ekura kotna namanga warta, erala yinganha yairnakala. ");
INSERT INTO are_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yinga paka itja pitjikalanga, etnakurna angkakalanga turta, etna itja ilkarrtja namara. Lyarta pula etna ilkarrtja nama. ");
INSERT INTO are_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","“Relha erala nuka yirrkngerrama, erataka Kaarta nukanhaka turta yirrkngerrama. ");
INSERT INTO are_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Arai, atha tjatjikarta kngarralkura urrkapuka relha arrpunhangatjina. Relha etna turta nhanha araka. Lakinhanga etna ilkarrtja nama. Etna turta nhanha arakalangatanya, etna nuka, Kaarta nukanhaka turta yirrknga kuta nama. ");
INSERT INTO are_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lakinha Altjirraka Angkatja Imankinya nhanha nthurrperrakantama, ‘Etna nuka palkala wara yirrkngerraka.’ ");
INSERT INTO are_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Atha Enka erinha rrakangkarrurna yairnitjina. Era rrakangkarra tangitjala nitjina. Enka nhanha itja orrtjerrama. Era Kaartanga pitjima. Era rrangkarranha nukiperra arratja inthorra ilitjina. ");
INSERT INTO are_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Rrangkarra turtantama relha ntjarranha nukiperra ilitjika, rrangkarra nukalela kuta nakalanga. ");
INSERT INTO are_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Athataka rrangkarranha nhanha alpmelaka, rrangkarra nukanga mpakalhakitja. ");
INSERT INTO are_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Arai, etna rrangkarranha synagogue-anga unputjina. Inguntha wara arrpunha ntjarrala turta etarlaritjina etna kula Altjirraka kangkwerramanga, etna rrangkarranha errilknga tumanga. ");
INSERT INTO are_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Etnataka rrangkarranha errilknga tutjina turta, etna Kaartaka, nuka turta kotna nakalanga. ");
INSERT INTO are_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Atha rrangkarranha nhanha mparrama ilama. Anma lakinherramalanga, rrangkarra ilpangkitjinanga atha rrangkarranha ilakala. Atha rrangkarranha nhanha itjarrka alpmelaka, yinga rrakangkarralela namanga warta.” ");
INSERT INTO are_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Yinga pula kala ekururnantama alputjina, erala yinganha alhurna yairnakala. Rrangkarra pula yinganha itjala pmarrama, ‘Nthanhurnama unta lhitjina?’ ");
INSERT INTO are_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yinga pula alputjika angkakalanga, rrangkarra ltarrpala wulhama. ");
INSERT INTO are_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Atha pula rrangkarranha nhanha arratja inthorra ilama. Nhanhataka rrakangkarra marra nama yinga alpumanga. Arai, yinga paka itja alpumanga, Enka era itja pitjitjina rrakangkarra tangitjala nitjika. Yinga pula alpumanga, atha erinha rrakangkarrurna yairnitjina. ");
INSERT INTO are_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Enka era pitjimalanga, era relha alharinya ntjarranha ilitjina, etna korna ntelalhamanga. Era turta etnanha ilitjina, yinga arratja namanga. Era turta etnanha ilitjina, atha relha alharinya ntjarraka itornka kala pmakwinakala. ");
INSERT INTO are_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Enka era etnanha ilitjina etna korna ntelalhamanga, etna yinganha itja tnakamanga. ");
INSERT INTO are_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Enka era etnanha ilitjina yinga arratja namanga, yinga Kaarturna alpumanga warta, rrangkarra turta yinganha yarna wotha aramanga. ");
INSERT INTO are_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Enka era etnanha ilitjina atha relha alharinya ntjarraka itornka kala pmakwinakala, Altjirrala erinha kala imilakalanga. ");
INSERT INTO are_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Angkatja arrpunha nuka intamantema rrangkarranha ilitjika. Atha pula rrangkarranha angkatja etnanha lyarta itja ilama, rrangkarra etnanha yarna warta arratja lhangkaramanga. ");
INSERT INTO are_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Enka era itja orrtjerrama. Era pitjimalanga, era rrangkarranha angkatja nukanha ilitjina. Angkatja nhanha etna nthurrpa nama. Arai, Enka era itja rrangkarranha angkatja ekuranha ilitjina. Angkatja lenhanta pula erala nukanga wukala. Era turta rrangkarranha ilitjina nhanga anmala nitjinala. ");
INSERT INTO are_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Enka nhanha era turta rrangkarranha ntelitjina yinga makalaria namanga, rrangkarranha angkatja nukanha ilamala. ");
INSERT INTO are_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nhanga Kaartaka angkatja ingkarraka kunha angkatja nukanha turta nama. Lakinhanga atha nhanga rrangkarranha ilaka, ‘Enka era rrangkarranha angkatja nukanha ilitjina.’” ");
INSERT INTO are_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Arlta urrputjiperra rrangkarra yinganha itja wotha aritjina. Kurunga arlta urrputjiperra rrangkarra yinganha wotha aritjina.” ");
INSERT INTO are_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nhanha wumala kurtungurla etna lakinha pmarrarraka, “Iwunhama era nurnanha nhanha ilama? ‘Arlta urrputjiperra rrangkarra yinganha itja wotha aritjina. Kurunga arlta urrputjiperra rrangkarra yinganha wotha aritjina.’ Nhanha turta, ‘Yinga nhanga Kaarturna alputjinanga warta.’ ");
INSERT INTO are_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Etnantama kuta pmarrarraka, ‘Iwunhama arlta urrputja nhanha etna?’ Nurna nhanha itja lhangkarama.” ");
INSERT INTO are_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesuanha kaltja naka etna erinha pmarritjika antja namanga. Lakinhanga era etnanha ilaka, “Rrangkarra kunha pmarrarrama angkatja nhanga yingala angkakaliperra, ‘Arlta urrputjiperra rrangkarra yinganha itja wotha aritjina. Kurunga arlta urrputjiperra rrangkarra yinganha wotha aritjina.’ ");
INSERT INTO are_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Atha rrangkarranha nhanha nthurrpa inthorra ilama. Rrangkarra itnitjina, nthorrkngerritjina turta, kanha relha alharinya ntjarra kangkitjinala. Rrangkarra nthurrpa ltarrpa nitjina. Altjirrala pula rrangkarranha wotha arrkanilitjina. ");
INSERT INTO are_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Arai, katjia intitjikerramalanga, arrkutja era ilkaartantjima. Anma, katjia ekuranha kala intamangantama, era ilkaarta ekuranhaka kngwerrama. Era arrkana turta nama, ekura katjia intamanga warta. ");
INSERT INTO are_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lakinha ngerra rrangkarra lyarta ltarrpa nama. Anma pula atha rrangkarranha wotha aritjina. Kurunga rrangkarra arrkana nitjina, arrpunhala turta itja inthorra arrkana rrakangkarranha urltakitjina. ");
INSERT INTO are_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Arlta lenha ekurala rrangkarra yinganha itja wotha pmarritjina. Atha rrangkarranha nthurrpa inthorra ilama. Rrangkarra paka Kaarturna ingkamanga, era kala rrangkarranha wutjina, rrangkarra rretnya nukanhala ingkamanga. ");
INSERT INTO are_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Lyartalpula rrangkarra itja Kaarturna ingkaka rretnya nukanhala. Kala ekururna ingkai, kurunga era rrangkarranha kala wutjina. Rrangkarra turtantama arrkana inthorra nitjina. ");
INSERT INTO are_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Yinga kunha rrakangkarrurna Kaartiperra angkaka, rrangkarranha yia ngerra ilamala. Anma pula atha rrangkarranha itja wotha Kaartiperra yiala ngerra alpmelitjina, alkngatharra pula. ");
INSERT INTO are_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Arlta lenha ekurala rrangkarra Kaarturna ingkitjina, rretnya nukanhala. Nukathaka turta itja nitjina ekururna ingkitjika, rrakangkarrakwia. ");
INSERT INTO are_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kaarta erarrpa warta rrakangkarra kangkamanga. Arai, era rrakangkarra kangkama, rrangkarra nuka kangkakalanga. Era turta rrakangkarra kangkama, rrangkarra yinganha tnakakalanga, atha rrangkarranha ilamalanga yinga ekuranga pitjikala. ");
INSERT INTO are_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yinga nhanga Kaartangatjina alha nhanhurna pitjika. Lyarta atha alha nhanha kala impurlalhitjinantama, yinga turta Kaarturna alputjina.” ");
INSERT INTO are_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kurtungurla etnantama erinha ilaka, “Unta kala alkngatharrantama angkama. Unta itja wotha nurnanha yiala ngerra ilama. ");
INSERT INTO are_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Arai, nurna nganha nhanga pmarritjika antja naka. Unta pula nurnanha nhanha ingkarraka kala alpmelaka, nurna nganha pmarritjikerramangantema. Nurnakantama angkatja arrpunha itja intama nganha pmarritjika. Lakinhanga nurna nganha tnakama, unta angkamalanga unta Altjirranga pitjikala.” ");
INSERT INTO are_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesuala etnanha ilaka, “Nthurrpama rrangkarra yinganha tnakama? ");
INSERT INTO are_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Arai, inguntha wara rrangkarra ingkarraka nukanga tira arrtjanitjina, nyintaminyinta pmara ekuranhurna. Rrangkarrantama yinganha nyintarinya impurlalhitjina. Yinga pula itja nyintarinya nitjina, Kaarta era warta nukalela namanga. ");
INSERT INTO are_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Atha rrangkarranha nhanha alpmelaka, rrangkarra nukanga arrkngala arrkana kuta nitjinanga. Relha alharinya ntjarrala rrangkarranha rrukunthakunthilitjina. Rrangkarra pula tnoatnoa nitjika, atha relha alharinya etnanha kala pmakwinakalanga.” ");
INSERT INTO are_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kurtungurla ntjarrurna angkamaliperra, Jesuala alkirurnathakantama inaraka. Erantama Altjirrurna ingkaka. “Kaartai, lyarta nukathaka kala nama nyingalauwutjika. Untantama relha ingkarrakanha ntelai 'Lira ungkwanganha makalaria namanga. Kurunga 'Lira ungkwanganhala turta relha ingkarrakanha ntelitjina unta makalaria namanga. ");
INSERT INTO are_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Unta kunha 'Lira ungkwanganha ekarltilaka relha ingkarrakaka tjitjarta nitjika. Era turtantama relha untala urrarakala ntjarranha ngampakala etatha tnyinitjinanga. ");
INSERT INTO are_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Relha etna kunha ngampakala etatha nitjina, etnala ungkwanga, Altjirra nthurrpa nyinta ekura kaltja namanga. Etnala Jesua Kristaka turta kaltja namanga, erinhala unta alhurna yairnakala. ");
INSERT INTO are_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yinga kala urrkapuka untala yinganha turnakala ngerra. Lakinha atha relha ingkarrakanha ntelaka unta makalaria namanga. ");
INSERT INTO are_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kaartai, untantama relha ntjarranha ntelai yinga turta makalaria kuta nentjikala. Ilaaka kunha makalaria naka, alha nhanha nitjikanhangantema. ");
INSERT INTO are_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Relha alharinya ntjarranga unta relha arrpunha ntjarranha urraraka kurtungurla nuka nitjika. Relha nhanha etna ungkwanga inthorra naka. Unta pula etnanha yinganhantama nthaka, ntarntaritjika. Athantama nganha etnaka imarnaka. Etna turtantama angkatja ungkwanganhaka kuta kangkwerrama. ");
INSERT INTO are_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Etna kala angkatja nukanhaka kaltja. Etna turta kaltja angkatja nukanha, angkatja ungkwanganha namanga. ");
INSERT INTO are_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Atha etnanha angkatja ungkwanganha kaltjinthaka. Etna turta angkatja ungkwanganha tnakaka. Etna turtantama kala kaltja yinga ungkwanganga pitjikala, unta turta yinganha alhurna yairnakala. ");
INSERT INTO are_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Yingantama etnakakwia ungkwangurna ingkama. Itja relha alharinya ntjarrakakwia. Kurtungurla etnakakwia pula, untala yinganha nthakala ntarntaritjika. Etna kunha ungkwanga kuta nama. ");
INSERT INTO are_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Relha nuka ntjarra ungkwanga nama. Relha ungkwanga ntjarra turta nuka nama. Relha nhanha etna kunha relha arrpunha ntjarranha ntelaka, yinga makalaria namanga. ");
INSERT INTO are_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Kaarta Alkngaltarai, yinga kala ungkwangurnantama alputjina. Yinga itja wotha alhala nitjina. Etna pula alhala kuterramala. Untarrpantama etnanha ntarntarai. Unta yinganha ntelaka unta ekarlta inthorra namanga. Unta etnanha ntarntaramanga, etna kala nyinta nitjina, ilaakala nyinta namanga ngerra. ");
INSERT INTO are_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yinga etnakalela namalangantema, atha etnanha ntarntaraka, unta warta yinganha ekarltilakalanga. Atha etnanha ntarntarakalanga, itja nyinta pairlperraka. Artwa nhanganta pairlperraka, ekurathaka nakala imerritjika. Lakinha Altjirraka Angkatja Imankinya nhanga nthurrperraka. ");
INSERT INTO are_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Kaartai, yinga nhanha kala ungkwangurna alputjinantama. Yinga pula nhanha kurtungurla nukanhurna angkama yinga alhala namangantema. Yinga etnakurna angkama etna arrkana inthorra nitjinanga, yingala arrkana inthorra namanga ngerra. ");
INSERT INTO are_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Atha etnanha angkatja ungkwanganha ilaka. Relha alharinya ntjarra pula etnaka yirrknga nama, etna itja etnakalela worla namanga. Yinga turta itja relha alharinya ntjarralela worla nama. ");
INSERT INTO are_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Kaartai, yinga ungkwangurna ingkama kurtungurla nukanhaka. Unta etnanha errintjanga ntarntaritjika, itja etnanha alha nhanhanga inarlalhitjika. ");
INSERT INTO are_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yinga ngerra, etna itja relha alharinya ntjarraka worla nama. ");
INSERT INTO are_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Angkatja ungkwanga kunha nthurrpa nama. Untantama etnanha alkngaltarilai, etnanha angkatja nthurrpa ungkwanganha kaltjinthamala. ");
INSERT INTO are_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Untala yinganha relha alharinya ntjarrurna yairnakala ngerra, lakinha atha etnanha turta relha alharinya ntjarrurna yairnamantema. ");
INSERT INTO are_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yinga ungkwanga kuta eterramala, ungkwanganta kangkwerrama. Untantama etnanha kaltjinthai ungkwanga kuta eterritjika, ungkwanganta turta kangkwerritjika. ");
INSERT INTO are_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kaartai, yinga itja kurtungurla nhanha ntjarrakakwianta ingkama. Yinga pula kurtungurla lenha ntjarrakakwia turta ingkama, etnala yinganha anma tnakitjinala angkatja etnakanha wumala. ");
INSERT INTO are_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Yingantama antja etna ingkarraka nyinta nitjika, unta nukalela kuta namanga ngerra, yinga turta ungkwangalela kuta namanga ngerra. Yinga turta antja etna ilaakalela kuta nitjika. Kurunga relha alharinya ntjarrala lhangkaritjina unta yinganha alhurna yairnakala. ");
INSERT INTO are_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Unta yinganha ilaka yinga makalaria namanga. Atha turta etnanha ilaka etna makalaria namanga, etna nyinta nitjinanga, ilaakala nyinta namanga ngerra. ");
INSERT INTO are_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kaartai, yinga etnakalela kuta nama, unta turta nukalela kuta nama. Lakinha etna ingkarraka nyinta nitjina. Kurunga relha alharinya ntjarra kaltja nitjina unta yinganha alhurna yairnakala. Etna turta kaltja nitjina unta etnaka kangkamanga, untala nuka kangkamanga ngerra. ");
INSERT INTO are_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Kaartai, unta yinganha kurtungurla nukanha ntjarranha nthaka, ntarntaritjika. Yinga antja nama etna ingkarraka nukalela nitjika, pmara yingala nitjinala, etna aritjinanga yinga makalaria namanga. Kaartai, unta kunha nuka kangkaka alha nhanha nitjikanhangantema. Imanka nhangantema untarrpa yinganha ilaka yinga makalaria namanga. ");
INSERT INTO are_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kaarta tjiparra inthorrai, relha alharinya ntjarra kunha ungkwanga itja kaltja naka. Yinga pula ungkwanga kaltja naka, kurtungurla nhanha ntjarra turta kaltja unta yinganha alhurna yairnakala. ");
INSERT INTO are_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Atha etnanha kala ungkwangiperra kaltjinthaka, atha turta etnanha wotha kaltjinthitjinantema. Kurunga etna kangkintja ntelalhitjina, untala nuka kangkintja ntelalhakala ngerra. Yinga turtantama etnakalela kuta nitjina.” ");
INSERT INTO are_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Lakinha Altjirrurna ingkamaliperra, Jesuanha kurtungurla ekuranha ntjarrakarta lhaka. Kidron Urtupanga tjananhamala, etna tnukulpurna irrpunhaka. ");
INSERT INTO are_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, erala erinha leltjaka lanthitjika nakala, era turta tnukulpa nhanhaka kaltja nakantema. Jesuanhataka tnukulpa nhanhurna lhitjata, kurtungurla ekuranha ntjarrakarta. ");
INSERT INTO are_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas-anhantama tnukulpa nhanha ekururna pitjika, Rome-arinya tjapartia ntjarrakarta, errkuntja ntjarrakarta turta. Errkuntja nhanha etnataka Priest itornka ntjarraka urrkapunhapunha naka, artwa Pharisee ntjarraka urrkapunhapunha turta. Etna Jesuaka pitjika irna alknganthakanhakarta, errauwiakarta turta. ");
INSERT INTO are_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesuanha kala kaltja naka etna erinha errkutjinala, anma errilknga tutjinalalka. Erantama etnakurna etinyerramala, etnanha pmarraka, “Ngunhakama rrangkarra yonthama?” ");
INSERT INTO are_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Etna erinha alpmelaka, “Jesua Nazareth-arinyakakwia.” Jesuala etnanha ilaka, “Yinga kunha era.” Judas, erala Jesuanha leltjaka lanthakala, era etnakalela nakantema. ");
INSERT INTO are_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesuala etnanha ilamalanga, era Jesua namanga, etna ingkarraka paarterraka, arnaka tnyilalhaka turta. ");
INSERT INTO are_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesualantama etnanha wotha pmarraka, “Ngunhakama rrangkarra yonthama?” Etna erinha alpmelaka, “Jesua Nazareth-arinyakakwia.” ");
INSERT INTO are_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesuala etnanha ilaka, “Atha nhanga rrangkarranha kala ilaka, yinga kunha era. Rrangkarra nuka warta yonthamanga, arrpunha nhanha ntjarranha kala impurlenai.” ");
INSERT INTO are_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Lakinha angkatja erala angkaka nthurrperraka. “Relha untala yinganha nthakala ntarntaritjika, etnakanga atha itja nyinta pairlpilaka.” ");
INSERT INTO are_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Peter-aka knife tjenya intaka. Knife tjenya erinha urlpuntjimala, era High Priest-aka urrkapunhapunha tuka, ilpa akwa ekuranha inturnamala. Urrkapunhapunha ekura rretnya naka Malchus. ");
INSERT INTO are_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesuala pula Peter-anha turnaka, “Knife tjenya ungkwanganha wotha kurnai. Nukathaka kala nama nyingalauwutjika, ilutjika turta Kaartala yinganha turnakala ngerra.” ");
INSERT INTO are_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kurunga Rome-arinya tjapartia ntjarraka itornkala, tjapartia ekuranha ntjarrala, relha Jew-aka urrkapunhapunha nhanga ntjarrala turta, Jesuanha errkuka, rope-ala yirnaka turta. ");
INSERT INTO are_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Etnantama Jesuanha Annas-urnakimparra rretjingaka. Annas erataka Caiaphas-aka ntoiya naka. Era turta year nhanha ekurala High Priest naka. ");
INSERT INTO are_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caiaphas nhanha erataka relha Jew ntjarranha ilakala, “Nhanha marralkura nama artwa nyinta relha ntjarrakakwia ilutjika.” ");
INSERT INTO are_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter, kurtungurla nyinta arrpunha turta, Jesuanga ingkarna pitjika. High Priest era kurtungurla arrpunha nhanha ekura kaltja naka. Kurtungurla nhanha erantama Jesualela High Priest-aka ilthurna irrpunhaka. ");
INSERT INTO are_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peter-anha pula reoanga kuta, itnarlanaka, yard-anga kathala. Kurtungurla arrpunha nhanga, ekurala High Priest kaltja nakala, erantama wotha rrataka Peter-anha kwanurna kngitjitjika. Erantama marla ekururna angkaka, erala reoa erinha ntarntaramanga. Kurunga era Peter-anha yard kwanurna kngitjika. ");
INSERT INTO are_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Marla erantama Peter-anha ilaka, “Unta turta kunha artwa nhanhaka kurtungurla nama.” Peter-ala pula erinha alpmelaka, “Yinga itjama.” ");
INSERT INTO are_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yard kwanala ura mpurlanaka, karntanga warta. Urrkapunhapunha etna, errkuntja etna turtantama, ura ekuranga arrtjilanaka. Peter era turtantama pitjimala arrtjika, wumpiilalhamala. ");
INSERT INTO are_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","High Priest erantama Jesuanha pmarraka kurtungurla ekuranha ntjarriperra. Era turta erinha pmarraka, “Iwunhama unta relha ntjarranha kaltjinthaka?” ");
INSERT INTO are_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesuala erinha ilaka, “Atha kunha relha ntjarranha alkngatharra kaltjinthaka. Atha kutatha synagogue-ala, temple-ala turta relha ntjarranha kaltjinthaka, katha nhanga relha Jew ntjarrala worlerrama. Atha itja kuta relha ntjarranha nyilknganyilkngala paka kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Iwunhangantama unta yinganha pmarrama, ‘Iwunhama unta relha ntjarranha kaltjinthaka?’ Relha etnanhatitja pmarrai, etnala yinganha wukala, atha etnanha kaltjinthamanga. Etna kala angkatja nukanhaka kaltja.” ");
INSERT INTO are_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Errkuntja nyinta Jesuanga kuta itnaka. Jesuanhantama lakinha angkamalanga, era erinha ilkaiya tuka. “Unta itja High Priest-urna lakinha angkitjika,” era Jesuanha ilaka. ");
INSERT INTO are_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesuala pula erinha ilaka, “Yinga paka paala angkakalanga, yinganha ilai. Yinga paka arratja angkakalanga, iwunhangala unta yinganha tuka?” ");
INSERT INTO are_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annas-alantama Jesuanha High Priest Caiaphas-urna yairnaka. Etna itja rope nhanga ekuranga iluka. ");
INSERT INTO are_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Peter-anha kuta arrtjilanaka, wumpiilalhamala. Arrpunha ntjarrala turtantama erinha ilaka, “Unta kunha kurtungurla ekuranha namantema.” Yiparrarnalhamala, Peter-ala etnanha ilaka, “Yinga itjama.” ");
INSERT INTO are_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kurunga High Priest-aka urrkapunhapunha nyintantama angkaka, artwa nhangaka tjina, ilpa ekuranhala Peter-ala inturnakala. “Atha pula nganha ekuralela arakala, tnukulpala.” ");
INSERT INTO are_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter-anhantama wothantema yiparrarnalhaka. Kala lukaluka orreantama angkarlpunhaka. ");
INSERT INTO are_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kala arlterrakalangantama, etna Jesuanha Caiaphas-aka ilthanga rretjingaka, Rome-arinya tjitjartaka iltha kngarrurna. Etnarrpa pula itja iltha kngarra ekururna irrpuka, etna Passover tjinkarra erinha yarna ilkukitja. ");
INSERT INTO are_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Lakinhanga Pilate-anha etnakurna rrataka, etnanha pmarraka turta, “Iwunhangama rrangkarra artwa nhanhanha ilparnama?” ");
INSERT INTO are_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Etna erinha alpmelaka, “Era kunha artwa korna. Era paka artwa marra nakalanga, nurna erinha itja ungkwangurna kngitjimara.” ");
INSERT INTO are_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate-ala etnanha ilaka, “Kala rrangkarrarrpa erinha tjiperrawurrirrai, mpaarangaranga rrakangkarranhamalkura.” Relha Jew ntjarrala pula erinha alpmelaka, “Nurnakathaka itja nama relhanha imilamala errilknga tutjika.” ");
INSERT INTO are_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesuala arrkurla nhangantema kurtungurla ekuranha ntjarranha ilakala era ntolkala ilutjinala. Lakinha Jesuaka angkatja nthurrperraka. ");
INSERT INTO are_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate-anha wotha iltha kngarra ekuranhurna irrpunhaka. Jesuaka ntangkalhamala, era erinha pmarraka, “Nthurrpama unta relha Jew ntjarraka king?” ");
INSERT INTO are_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesuala pula erinhatitja pmarraka, “Untarrpama lakinha eterraka? Arrpunhalama nganha lakinha nukiperra alpmelaka?” ");
INSERT INTO are_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate-ala erinha alpmelaka, “Yinga itjama relha Jew. Relha ungkwanganha ntjarrala, priest itornka ntjarrala turta, nganha nuka lanthakala. Iwunhangama etna nganha ilparnama?” ");
INSERT INTO are_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesuala erinha ilaka, “Yinga itja alha nhanhala king nama. Yinga paka alha nhanhala king nakalanga, tjapartia nukanha ntjarra nukakwia turramara. Relha Jew ntjarrala turtantama yinganha yarna ungkwanga lanthamara. Yinga pula pmara arrpunhala king nama.” ");
INSERT INTO are_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“Nthurrpama unta king nama?” Pilate-ala erinha pmarraka. Jesuala erinha alpmelaka, “Unta angkama yinga king namanga. Yingataka alha nhanhala katjia intaka, atha relha ingkarrakanha Altjirraka angkatja nthurrpa erinha ilitjika. Relha erala antja nama Altjirraka angkatja nthurrpa erinha wutjika, era nuka kangkwerrama.” ");
INSERT INTO are_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate-alantama Jesuanha pmarraka, “Iwunhantama Altjirraka angkatja nthurrpa era?” Pilate-anhantama wotha iltha kngarra ekuranhanga rrataka. Erantama relha Jew ntjarranha ilaka. “Atha artwa nhanha erinha pmarraka. Era pula itja ilkarrtja nama. ");
INSERT INTO are_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Arai, Passover-aka arltala atha kutatha artwa jail-arinya nyintanha rrakangkarra althakalthilama. Nthakinhantama? Rrangkarra antja nama atha relha Jew ntjarraka king rrakangkarra althakalthilitjika?” ");
INSERT INTO are_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Etna pula ingkarraka ilkaka, “Itja erinha, Barabbas-anhatitja.” Barabbas erataka artwa nyilkngampa naka, tunhatunha turta. ");
INSERT INTO are_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilate-alantama tjapartia ekuranha ntjarra turnaka etna Jesuanha whip-ala tutjika. ");
INSERT INTO are_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tjapartia ntjarralantama irna kaarntakaarnta turta mpaaraka, ilakwanga. Etna turta nhanha Jesuaka kapurtaka arrarnaka. Etna mantarra thathaka tjenya turta ekura ekarraka. ");
INSERT INTO are_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kurunga ekururna etinyerramala, etna ilkarlanaka, “Wortai, relha Jew ntjarraka king.” Etna erinha ilkaiya turtantama turlanaka. ");
INSERT INTO are_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate-anhantama wotha iltha kngarra ekuranhanga rratamala Jew ntjarrurna angkaka. “Arai, atha erinha wotha rrakangkarra imarnitjina, rrangkarra kaltja nitjinanga era nukanga urlarra itja ilkarrtja namanga.” ");
INSERT INTO are_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesuanhantama kathurna rrataka, kaarntakaarnta ilakwakarta, mantarra thathaka tjenya nhangakarta turta. Pilate-alantama etnanha ilaka, “Artwa erinha arai.” ");
INSERT INTO are_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Priest itornka ntjarrala, urrkapunhapunha etnakanhala turta erinha aramalanga, etna ilkaka, “Erinha ntolkaka kanthatwai! Erinha ntolkaka kanthatwai!” Pilate-ala etnanha ilaka, “Kala rrangkarrarrpa erinha ntolkaka kanthatwai. Nukanga urlarra era itja ilkarrtja nama.” ");
INSERT INTO are_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Relha Jew ntjarrala pula erinha ilaka, “Era ilalhaka era kula Altjirraka 'Lira namanga. Lakinha angkamala era Altjirranha arrampowuka. Mpaarangaranga nurnakanhamalkura erinha kala errilknganta tutjika.” ");
INSERT INTO are_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nhanha wumala Pilate-anha kngarralkura trerraka. ");
INSERT INTO are_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wotha iltha kngarra ekuranhurna irrpunhamala, era Jesuanha pmarraka, “Pmara nthanharinyama unta?” Jesuala pula erinha itja alpmelaka. ");
INSERT INTO are_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilate-alantama erinha wotha pmarraka, “Iwunhangala unta yinganha itja alpmelama? Unta itjala kaltja? Nukathaka nama nganha althakalthilitjika paka, nganha ntolkaka kanthatutjika paka.” ");
INSERT INTO are_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesuala pula erinha ilaka, “Nhanha ungkwangathaka nama, Altjirrala nganha ingkairnakalanga nhanhala tjitjarta nitjika. Relha erala yinganha ungkwanga lanthakala, era Altjirranga urlarra ilkarrtjalkura nama ungkwangangatjina.” ");
INSERT INTO are_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nhanha wumala, Pilate-anha antja inthorra naka Jesuanha kala althakalthilitjika. Relha Jew ntjarra pula kuta ilkarlanaka, “Unta paka artwa nhanhanha althakalthilamanga, unta itja Caesar-aka tjina nama. Artwa erala ilalhama era kula king namanga, era kala Caesar-aka leltja nama.” ");
INSERT INTO are_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nhanha wumala Pilate-ala Jesuanha wotha iltha kngarra ekuranhanga rratalhelaka. Kurunga era tjiperrawunhawunhaka chair-aka arrarnalhaka. Chair ekuranga kaarntakaarntalataka etna arna ingkarraka partala korltakala. Hebrew angkatjala etna katha nhanha erinha rretnya “Gabbatha” alpmelaka. ");
INSERT INTO are_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nhanha kunha arlta era naka, ekuralala relha Jew ntjarra Passover tjinkarraka urrkaputjata. Kala ngkinyantama naka. Pilate-alantama relha Jew ntjarranha ilaka, “King rrakangkarranha arai.” ");
INSERT INTO are_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Etna pula ilkaka, “Erinha kngai! Erinha kngai! Erinha kala ntolkaka kanthatwai!” “Yai,” Pilate-anha angkaka, “Rrangkarra antja nama atha king rrakangkarranha ntolkaka kanthatutjika?” Priest itornka ntjarrala erinha ilaka, “Caesar nyintanta king nurnaka nama.” ");
INSERT INTO are_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kurunga Pilate-ala Jesuanha etnaka lanthaka, tjapartia ntjarrala erinha ntolkaka kanthatutjika. Tjapartia etnantama Jesuanha inarlalhaka. ");
INSERT INTO are_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesua erarrpantama ntolka ekuranha “Kaalkngaka Pmara” ekururna kngaka. Hebrew angkatjala etna pmara nhanha erinha rretnya “Golgotha” alpmelama. ");
INSERT INTO are_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nhanhaka tjapartia ntjarrala erinha ntolkaka kanthatuka. Etna artwa tharra arrpunha turta ntolkaka kanthatukantema, Jesuanga etapaka. Kanha Jesuanha mpopalala. ");
INSERT INTO are_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","20","Pilate-alataka artwa arrpunhanha arrkurlantema ilakala era angkatja nhanha irnaka intalhelitjika, JESUA NAZARETH-ARINYA, RELHA JEW NTJARRAKA KING ERA. Angkatja erinha artwa era Hebrew angkatjala, Latin angkatjala, Greek angkatjala turta intalhelaka. Pilate-alantama tjapartia ntjarranha turnaka etna irna angkatja nhanhakarta Jesuaka ntolka kartninyaka arrarnitjika. Golgotha erataka Jerusalem-anga kathala naka, etinya wara pula. Relha Jew ntjarrantama angkatja nhanhaka read-erraka. ");
INSERT INTO are_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Lakinhanga priest itornka ntjarra Pilate-urna lhamala erinha ilaka, “Iwunhangala unta intalhelaka: Relha Jew ntjarraka king era? Unta intalheleikanha: ‘Era ilalhaka era kula relha Jew ntjarraka king namanga.’” ");
INSERT INTO are_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate-ala pula etnanha ilaka, “Angkatja athala intalhelakala, nhanha atha itja wotha ekngarrpunhilama.” ");
INSERT INTO are_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tjapartia 4-ala Jesuanha ntolkaka kanthatuka. Erinha kanthatumaliperra, etna mantarra ekuranha tjepakamala errarnpalhelakantama, nyintaminyintaka ungkwaltja nyinta. Mantarra coat ekuranha pula marra inthorrala naka. ");
INSERT INTO are_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Lakinhanga etna angkarraka, “Nurna itja coat erinha tjepakitjika, era marra inthorranga. Nurna ekura kala gamble-anterriai.” Tjapartia etnantama coat ekura gamble-erraka. Altjirraka Angkatja Imankinyantama nthurrperraka. “Etna mantarra nukanha errarnpalhelaka, mantarra coat nukanhaka turta etna gamble-erraka.” ");
INSERT INTO are_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesuaka ntolkanga etinya wara, mia ekura itnarlanaka, mia ekuranhaka tjia, Mary arrpunha Clopas-aka noa, Mary Magdalene turta. ");
INSERT INTO are_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesuala mia ekuranha araka. Era kurtungurla arrpunha nhanganha turta araka, ekurala era kngarra kangkaka. Erantama mia ekuranha ilaka, “Arrkutjai, artwa nhanhantama kala worra ungkwanga niai.” ");
INSERT INTO are_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kurtungurla erinhantama era ilaka, “Artwai, arrkutja nhanhantama kala mia ungkwanga niai.” Kurtungurla erantama arrkutja erinha iltha ekuranhurna kngetnaka, erinha mia ekuranha ngerra ntarntaraka turta. ");
INSERT INTO are_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesuanha kaltja naka, urrkapuntja nhanga Kaarta ekuranhalala erinha turnakala, era urrkapuntja nhanha kala mangkilakalantama. Erantama angkaka, “Yinga angkathala nama.” Lakinha Altjirraka Angkatja Imankinya nhanha nthurrperraka. ");
INSERT INTO are_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wine kornakorna lenhala intaka, tjampitala. Etnantama irna alkumpa wine ekura thankuka. Kurunga alkumpa erinha irna tjenyaka arrarnamala, etna erinha ntjutjika nthaka. ");
INSERT INTO are_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wine erinha ntjumala, Jesuanha angkaka, “Atha kala urrkapuntja nukanha mangkilakantama.” Kurunga kapurta kwaninyerramala, era iluka. ");
INSERT INTO are_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nhanha kala arlta era naka, ekurala relha Jew ntjarrakathaka naka, Passover tjinkarraka urrkaputjika. Relha Jew etnantama ilarraka, “Inguntha Sabbath arlta nitjina. Nhanha turta itja arratja nama artwa etnaka mpurrka Sabbath arltala ntolkala kuta ilparanitjika.” Lakinhanga relha Jew ntjarrala Pilate-anha ilaka, “Artwa nhanga ntjarraka tjorra urltakai. Mpurrka etnakanha turta ntolkanga tnanpulhelai.” Pilate-anha etnaka kangkwerraka. ");
INSERT INTO are_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kurunga tjapartia etnantama artwa arrpunha nhanga tharraka tjorra urltakaka. ");
INSERT INTO are_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kurunga Jesuwurnantama pitjimala, etna araka era kala ilukala. Lakinhanga etna tjorra ekuranha itjala urltakaka. ");
INSERT INTO are_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tjapartia nyintala pula tjarta ekuranhala Jesuaka ulta thanthaka. Kala alhwa kwatja turtantama thalalhaka. ");
INSERT INTO are_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Artwa nyintala nhanha araka. Artwa erantama yia nhanha arrpunha ntjarranha ilaka. Yia nhanha nthurrpa nama. Artwa nhanha kaltja yia era nthurrpa namanga. Era turta nhanha rrangkarranha ilama, rrangkarra turta Jesuanha tnakitjinanga. ");
INSERT INTO are_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Altjirraka Angkatja Imankinyala ilama, “Etna itja ngkwarna nyinta ekuranha urltakitjina.” Angkatja nhanha nthurrperraka. ");
INSERT INTO are_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Altjirraka Angkatja Imankinya arrpunhala ilama, “Relha ntjarrala erinha ararlanitjina, erinhala thanthakala.” Angkatja nhanha turta nthurrperraka. ");
INSERT INTO are_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Joseph, pmara Arimathea-arinya, era Jesuaka kurtungurla nakantema. Era pula itja arrkurla ilalhakala era kurtungurla ekuranha namanga, relha Jew ntjarranga trerramala. Erantama Pilate-aka enkaka, Jesuaka mpurrkaka. Pilate-ala erinha kala impurlarrarnaka, Jesuaka mpurrka initjika. Erantama Jesuaka mpurrka inaka. ");
INSERT INTO are_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemus, erala arrkurla nhanga Jesuurna ingula pitjikala, era turta Joseph-alela pitjika. Era ntira unpa marra kngarrakarta pitjika. ");
INSERT INTO are_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Joseph eratharrantama Jesuaka mpurrka ntira unpa marrakartala parnaka, mantarra tjulkurala turta ilinyiwuka. Nhanha relha Jew ntjarraka mpaarangaranga naka. ");
INSERT INTO are_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Katha nhanga Jesuala ilukala, ekuranga etinya wara tnukulpa naka. Tnukulpa ekurala turta wolknga intia lyartinya naka. Wolknga nhanhala relha errilknga arrpunha itja paka intakala. ");
INSERT INTO are_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Wolknga nhanha era etinya namanga, kala ingkwa Sabbath arlta turta namanga, etna Jesuanha wolknga nhanhaka arrarnaka. ");
INSERT INTO are_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sunday ingutnhala inthorra, nhanga arlterritjikanhangantema, Mary Magdalene-anha Jesuaka wolkngurna lhaka. Era aritjalhaka parta erinha wolknganga ankartiwukala. ");
INSERT INTO are_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Erantama Simon Peter-urna arrtjanaka, kurtungurla arrpunha nhangurna turta, ekurala Jesuanha kangkakala. Erantama erinhatharra ilaka, “Arai, etna kunha Ingkartaka mpurrka wolknganga kngaka. Nurna turta itja kaltja, pmara ekura etnala erinha arrarnakala.” ");
INSERT INTO are_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peter tharrantama wolkngurna arrtjanaka. ");
INSERT INTO are_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kurtungurla arrpunha nhanga pula parrpalkurala arrtjanaka. Erantama Peter-anga arrkurlerraka. Erakimparra turtantama wolkngaka erritjalhaka. ");
INSERT INTO are_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Twakalhamala, era wolknga kwana tjilaraka. Era mantarra tjulkura etnanha intamanga araka. Era pula itja wolkngurna irrpunhaka. ");
INSERT INTO are_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kurunga Peter-anha turtantama wolkngaka erritjalhaka. Era kala wolkngurna irrpunhakala, mantarra tjulkura etnanha turta intamanga araka. ");
INSERT INTO are_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Mantarra arrpunha kapurtakanha, era araka tweta intamanga, arrpunhala erinha ilinyatukala. ");
INSERT INTO are_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kurtungurla arrpunha nhanga turtantama wolknga ekururna irrpunhaka. Era araka wolknga era urlta namanga. ");
INSERT INTO are_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Arai, kurtungurla ntjarrala itjantema lhangkaraka Altjirraka Angkatja Imankinyala ilakala Jesuakathaka namanga errilknga ntjarranga etatha kamerritjika. ");
INSERT INTO are_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kurtungurla eratharrantama kurtungurla arrpunha ntjarrurna alpurraka. ");
INSERT INTO are_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary-anha pula wolknganga kathala itnarlanaka, era turta itnirlanaka. Itnirlanamalantema, era twakalhamala wolknga kwana tjilaraka. ");
INSERT INTO are_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Erantama angel tharra araka, mantarra tjulkurakarta. Nyinta katha ekurala narlanaka, Jesuaka kapurtala intakala. Kanha arrpunha narlanaka Jesuaka ingkala intakala. ");
INSERT INTO are_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Eratharrantama erinha pmarraka, “Arrkutjai, iwunhanga unta itnima?” Era erinhatharra alpmelaka, “Etna kunha Ingkarta nukanhaka mpurrka kngaka. Yinga turta itja pmara ekura kaltja, pmara nhanga etnala mpurrka erinha arrarnakala.” ");
INSERT INTO are_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Lakinha angkamala, era ilkngaralhaka. Erantama Jesuanha itnamanga araka. Era pula itja kaltja naka artwa era Jesua namanga. ");
INSERT INTO are_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesualantama erinha pmarraka, “Arrkutjai, iwunhangama unta itnima? Ngunhakama unta yonthama?” Mary era etarlaraka Jesuanha kula tnukulpaka ntarntarintja era namanga. Erantama erinha ilaka, “Itornkai, unta paka mpurrka ekuranha katha arrpunhaka arrarnakalanga, yinganha ilai, atha erinha inarlalhitjinanga.” ");
INSERT INTO are_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesuanhantama ekururna angkaka, “Mary-ai.” Mary-anhantama ekuranga urlarra itnamala Hebrew angkatjala angkaka, “Rabboni,” nhanhatitja “Kaltjinthanhinthanhai.” ");
INSERT INTO are_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesualantama erinha ilaka, “Unta yinganha itja anputjika. Yingataka itjantema Kaarturna alpukala. Unta pula tjia nukanha ntjarrurna alpai, etnanha ilai turta, Yinga Kaarta nukanhurna alputjina, Kaarta rrakangkarranhurna turta. Altjirra nukanhurna, Altjirra rrakangkarranhurna turta.” ");
INSERT INTO are_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kurunga Mary Magdalene-anha kurtungurla ntjarrurna alpuka, etnanha ilaka turta, “Atha Ingkartanha arakau.” Kurunga era etnanha Jesuaka angkatja turta alpmelaka. ");
INSERT INTO are_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sunday ngurralantama, nhanga relha Jew ntjarranga trerramala, kurtungurla etna iltha nyintala naka, reoa ingkarraka marntilakala. Jesuanhantama etnakanga mpopala itnatjalhaka. Era etnanha ilaka, “Altjirranha rrakangkarra rilhera ntelalhama.” ");
INSERT INTO are_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Lakinha angkamaliperra, era etnanha iltja ekuranha, ulta ekuranha turta ntelaka. Ingkarta erinha aramala, kurtungurla etna kangkaka inthorra. ");
INSERT INTO are_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesuala etnanha wothantema ilaka, “Altjirranha rrakangkarra rilhera ntelalhama. Kaarta erala yinganha relha alharinya ntjarrurna yairnakala ngerra, atha rrangkarranha turta etnakurna yairnama.” ");
INSERT INTO are_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kurunga era etnanha poiyilamala ilaka, “Enka Alkngaltara era kala rrakangkarralela namantama. ");
INSERT INTO are_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Rrangkarra relhaka korna iwumanga, Altjirrala turta korna etnakanha iwuma. Rrangkarra paka relhaka korna itja iwumanga, Altjirrala turta korna etnakanha itja iwuma.” ");
INSERT INTO are_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Thomas, 12 etnakanga nyinta, rretnya arrpunha ekuranha Didymus, era itja kurtungurla arrpunha ntjarralela naka, nhanga Jesuanha etnaka ntelalhamanga. ");
INSERT INTO are_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Anmantama etna erinha ilaka, “Nurna Ingkartanha arakau.” Era pula etnanha ilaka, “Atha nail imparlknga etnanha aramanganta, atha turta imparlknga etnanha iltjala mpaaramanganta, atha turta iltja nukanha ulta ekuranhaka kurnamanganta, atha tnakitjina era errilknga ntjarranga kamerrakala.” ");
INSERT INTO are_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kala Sunday ngurrangurra arrpunhalantama, kurtungurla etna wotha katha nyinta ekurala naka. Thomas era turtantama etnakalela nakantema. Etna kwanala narlanaka, reoa ingkarraka marntilakala. Jesuanhantama wotha etnakanga mpopala itnatjalhaka. Era etnanha ilaka, “Altjirranha rrakangkarra rilhera ntelalhama.” ");
INSERT INTO are_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Erantama Thomas-anha ilaka, “Iltjakantja ungkwanganhala iltja nukanha mpaarai. Iltjakantja ungkwanganhala turta ulta nukanha mpaarai. Untantama yinganha kuta ilpoiwutjala nai. Yinganha kala tnakantai.” ");
INSERT INTO are_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas-alantama erinha alpmelaka, “Unta Ingkarta nuka nama, Altjirra nuka turta.” ");
INSERT INTO are_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesualantama erinha ilaka, “Unta kunha yinganha tnakaka, unta yinganha arakalanga. Arai, relha etnala yinganha tnakama, etna yinganha itja arakalangatanya, etna arrkana inthorra nama.” ");
INSERT INTO are_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesuala tjatjikarta ntjarra arrpunha turta urrkapuka, kurtungurla ekuranha ntjarranga alkngatharra. Atha pula etnanha itja pepa nhanhaka intalhelakala. ");
INSERT INTO are_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nhanha ntjarra pula atha intalhelakala, rrangkarra tnakitjinanga Jesuanha Krista era namanga, Altjirraka 'Lira. Rrangkarra turta ngampakala etatha nitjinanga erinha tnakamala. ");
INSERT INTO are_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Anma Jesuanha wotha kurtungurla ekuranha ntjarraka ntelalhaka, Tiberias Ntjangala. Nhanga lakinha. ");
INSERT INTO are_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas (erinhala etna Didymus ilitjata), Nathanael, Cana town-arinya. (Cana town erataka pmara Galilee-ala naka.) Zebedee-aka 'lira tharra, kurtungurla tharra arrpunha turta porta narlanaka. ");
INSERT INTO are_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter-alantama etnanha ilaka, “Yinga lhama irrpannga errkutjika.” Arrpunha ntjarrala erinha ilaka, “Nurna turta ungkwangalela lhitjinantema.” Etnantama boat-aka ntjimala irrpannga errkutjika lhaka. Etnantama ingwa ntjapara urrkapuka. Etna pula itja irrpannga nyinta paka errkuka. ");
INSERT INTO are_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lirnnga kala rratakalangantama, Jesuanha ankerrala itnaka. Kurtungurla etna pula erinha itja lhangkaraka. ");
INSERT INTO are_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesuanhantama etnaka ilkaka, “Tjina ntjarrai, rrangkarra paka irrpannga errkukama?” Etna erinha alpmelaka, “Itjau.” ");
INSERT INTO are_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesualantama etnanha ilaka, “Boat-anga akwampinyaka net rrakangkarra kwatjaka iwurrirrai. Rrangkarra kala irrpannga errkutjinantama.” Kangkwerramala etna net erinha kwatjaka iwuka. Yarnantama etna net erinha wotha boat-urna tjarrinaka, irrpannga ntjarra inthorranga. ");
INSERT INTO are_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kurtungurla arrpunha nhangantama, ekurala Jesuanha kangkaka, era Peter-anha ilaka, “Ingkartanha yai.” Nhanha wumala, Peter-anha mantarra tjenya ekuranhaka wotha ekarralhaka, kwatjaka turta irrpuka. ");
INSERT INTO are_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kurtungurla arrpunha ntjarra pula boat-alala kuta pitjika, net irrpannga ntjarrakarta tjarrinamala. Etna itja ankerranga ilanga naka, kala etinya wara. ");
INSERT INTO are_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Boat ekuranga tnanpumaliperra, kurtungurla etna ura mpumanga araka. Etna turta araka kara irrpannga parrkala intamanga, marna turta. ");
INSERT INTO are_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesualantama etnanha ilaka, “Irrpannga urrputja rrangkarrala lyarta errkukala kngitjai.” ");
INSERT INTO are_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter-anhantama wotha boat-aka ntjika. Net erinha errkumala, era erinha ankerrurna tjarrinaka. Net era kala lyulpalyulpa inthorra naka, 153 irrpannga kngarritjakarta. Net era pula itja tjepakalhaka. ");
INSERT INTO are_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesuala etnanha ntangkakantama, “Pitjarrirrai ilkutjika.” Kurtungurla etna porerraka erinha pmarritjika, ‘Ngunhama unta?’ Etna kala kaltjakwia naka, nhanha Ingkartanha namanga. ");
INSERT INTO are_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesualantama etnanha marna nthaka, kara irrpannga turta. ");
INSERT INTO are_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nhanha kala tharraminyintarangantama naka Jesuanhala kurtungurla ekuranha ntjarraka ntelalhakala, era errilknga ntjarranga kamerramaliperra. ");
INSERT INTO are_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Etna kala ilkukalangantama, Jesuala Simon Peter-anha pmarraka, “Simon, John-aka 'lirai, unta nuka kngarralkura kangkama, kurtungurla arrpunha nhanha ntjarrangatjina?” Era erinha alpmelaka, “Awa, Ingkartai, unta kala kaltja yinga ungkwanga kangkamanga.” Jesuala erinha ilaka, “Lamb nukanha ntjarra ntuthilai.” ");
INSERT INTO are_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesualantama Peter-anha wotha pmarraka, “Simon, John-aka 'lirai, unta nuka kangkamama?” Era erinha alpmelaka, “Awa, Ingkartai, unta kala kaltja yinga ungkwanga kangkamanga.” Jesuala erinha ilaka, “Sheep nukanha ntjarra tnairnai.” ");
INSERT INTO are_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kala tharraminyintarangantama Jesuala Peter-anha pmarraka, “Simon, John-aka 'lirai, unta nuka kangkamama?” Jesuaka angkatjala Peter-anha tjalka tuka, Jesuala erinha tharraminyintarangantama pmarrakalanga, ‘Unta nuka kangkamama?’ Erantama Jesuanha alpmelaka, “Ingkartai, untataka kaltja inthorra nama. Unta turta nhanhaka kaltja nama, yinga ungkwanga kangkamanga.” Jesuala erinha ilaka, “Sheep nukanha ntjarra ntuthilai. ");
INSERT INTO are_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Peter-ai, atha nganha nhanha turta nthurrpa inthorra ilama. Unta nhanga artwa nthitjarrka namalanga, untarrpa mantarraka ekarralhitjata. Unta turta nthulaputjata unta antja namanga ngerra. Aiwerramala pula unta etintja ungkwanganha kartninyilitjina, arrpunhala turtantama mantarra ungkwanganha ekarritjina. Era turtantama nganha katha arrpunhurna rretjingitjina, ekururnala unta itja lhitjika antja nama.” ");
INSERT INTO are_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesuala Peter-anha nhanha ilaka, era kaltja nitjinanga arrpunha ntjarrala erinha anma errilknga tutjinala. Peter era turtantama Altjirranha tnantjitjinala era ilumalanga. Kurunga Jesuala Peter-anha ilaka, “Nukanga tnaartangala pitjai.” ");
INSERT INTO are_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ilkngaralhamala, Peter-ala araka kurtungurla nhanga, ekurala Jesuanha kangkaka, ekuratharranga tnaartangala pitjimanga. (Kurtungurla nhanha erataka nhanga Jesuanga kuta nakala, etna nhanga marna ilkumanga, era turtala nhanga Jesuanha pmarrakala, “Ingkartai, ngunhalama nganha leltjaka lanthitjina?”) ");
INSERT INTO are_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Erinha aramala, Peter-ala Jesuanha pmarraka, “Ingkartai, eraloa?” ");
INSERT INTO are_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesuala Peter-anha alpmelaka, “Yinga paka antja namanga era etatha nitjika yinga pitjalputjinalpula, nhanha itja ungkwangathakalka nama. Ungkwangathaka nama nukanga tnaartangala pitjitjika.” ");
INSERT INTO are_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Angkatja nhanhanga arrkngalantama tnakanhakanha ntjarrala etarlaraka kurtungurla era kula itja ilutjinala. Jesuanha pula itja angkaka era kula itja ilutjinala. Era wara Peter-anha ilaka, “Yinga paka antja namanga era etatha nitjika yinga pitjalputjinalpula, nhanha itja ungkwangathakalka nama.” ");
INSERT INTO are_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Kurtungurla nhanha era kunha angkatja nhanha ingkarraka intalhelakala. Nurna turta kaltja angkatja ekuranha nthurrpa namanga. ");
INSERT INTO are_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesuanha kngarra wotha urrkapuka, angkaka turta. Arrpunhala paka yia nhanha ingkarraka intalhelamanga, pepa etna ntjarra inthorra namara. ");
INSERT INTO are_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Theophilus-ai. Pepa arrpunha nhangala atha kala yia ingkarraka Jesuiperra intalhelakala. Yia nhanga erala katjia intakala, erala urrkapukala, erala relha ntjarranha kaltjinthakala, erala ilukala, erala kamerrakala, ");
INSERT INTO are_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","erala alkirurna alpuka turta. Alputjinala, era apostle erala urrarakala ntjarranha kaltjinthakarrka, Enka Alkngaltararlarlanga. ");
INSERT INTO are_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Arlta 40-aka, errilknga ntjarranga kamerramaliperra, Jesuanha apostle etnaka ntjarraranga ntelalhaka, etna nthurrpa kaltja nitjinanga era etatha namanga. Era turta etnanha kaltjinthaka Altjirranha relha ingkarrakaka Ingkarta namanga. ");
INSERT INTO are_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Era turta etnanha ilaka, “Rrangkarra Jerusalem-alarrka kuterrai, Enka Alkngaltara ekura kaaralhamala, erinhala Kaartala rrangkarranha lhelakala. Atha nhanga rrangkarranha nhanhiperra kala ilaka. ");
INSERT INTO are_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John-ala kunha relha ntjarranha nhanga kwatjala kaltjirrpulhelaka. Inguntha wara pula Altjirrala rrangkarranha Enka Alkngaltaralantama kaltjirrpulhelitjina.” ");
INSERT INTO are_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Apostle etna worla namalanga, etna Jesuanha pmarraka, “Ingkartai, unta arlta lenhala Rome-arinya ntjarranha pmara Israel-anga wotha unputjina? Unta turtantama artwa Israel-arinyanha wotha ingkairnitjina king nurnanka nitjika?” ");
INSERT INTO are_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesuala etnanha alpmelaka, “Nhanha kunha Kaartakathakanta nama. Eranta kaltja. ");
INSERT INTO are_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Arai, Enka Alkngaltara era pula rrakangkarrurna pitjitjina, rrakangkarralela kuta nitjika. Era rrangkarranha ekarltilitjina. Kurunga rrangkarra relha Jerusalem-arinya ntjarranharrka nukiperra ilitjika. Kurunga relha pmara Judea-arinya ntjarranha, pmara Samaria-arinya ntjarranha turta. Kurunga rrangkarra alha panpalurnantama lhitjika, relha ingkarraka inthorranha nukiperra ilitjika.” ");
INSERT INTO are_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Lakinha angkamaliperra, Jesuanha alkirakerraka, etnakanga alkngatharra. Kurunga matarala erinha etnakanga lauwuka. ");
INSERT INTO are_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Etna pula kuta alkirurnathaka inaraka. Artwa tharra mantarra tjulkurakartantama etnakanga kuta itnatjalhaka. ");
INSERT INTO are_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Eratharra etnanha pmarraka, “Artwa pmara Galilee-arinya ntjarrai, iwukama rrangkarra alkirurnathaka inarama? Jesua nhanha era, erala lyarta rrakangkarranga alkirurna alpukala, era lakinha ngerra wotha alkiranga pitjalputjinantema.” ");
INSERT INTO are_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kurunga apostle etna Jerusalem-urna alpuka, Olive Parta ekuranga. Parta nhanha erataka Jerusalem-anga etinya wara naka. ");
INSERT INTO are_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalem-akerritjalhamalantama, etna room nhangurna alpuka, kaaralhitjika. Apostle nhanha etnaka rretnya naka Peter, John, James, Andrew, Philip, Thomas, Bartholomew, Matthew, James, nhanga Alphaeus-aka worra, Simon, erala Roman Government-aka irrpaltherritjata, Judas-anha turta, James-aka worra. ");
INSERT INTO are_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Apostle nhanha etna porta kuta Altjirrurna ingkitjata. Mary, Jesuaka mia, arrkutja urrputja arrpunha, Jesuaka kanhanganhanga turta etnakalela ingkitjatantema. ");
INSERT INTO are_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Arlta arrpunhala, tnakanhakanha 120 ngerra angkarritjika worlerraka. Peter-anhantama kamerramala etnanha ilaka. ");
INSERT INTO are_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Tjina ntjarrai, imanka David-anha Enka Alkngaltararlarlanga Judas-iperra angkaka. Judas-ala kunha Jesuanha nhanga leltjaka lanthakala. Altjirraka Angkatja Imankinya nhanga David-alala ilakala, nthurrperrakantama. ");
INSERT INTO are_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Arai, Judas era worla nurnakanhanga naka, Jesuala erinha urrarakalanga warta nurnakalela porta urrkaputjika. ");
INSERT INTO are_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Priest itornka ntjarrala Judas-anha nhanga money nthaka, era Jesuanha etnaka lanthakalanga. Money nhanhala Judas-ala tnukulpa buy-emilaka. Tnukulpa ekurala era tnyinhaka. Tnarta ekurantama taka, iltjarrknga ekuranha turta arnaka thalalhaka. ");
INSERT INTO are_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Relha Jerusalem-arinya ingkarrakala nhanhiperra wuka. Etnantama angkatja etnakanhala tnukulpa erinha ‘Akeldama’ alpmelaka, nhanhatitja ‘Tnukulpa Alhwakarta.’ ");
INSERT INTO are_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Altjirraka Angkatja Imankinyala, Psalm arrpunhala ilama, ‘Iltha ekuranha kala urlta kuta neikanha, relha itja wotha ekurala nitjika paka.’ Kala Psalm arrpunhala turta ilama, ‘Relha arrpunhantama katha ekuranhala urrkaputjika.’ ");
INSERT INTO are_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Lakinhanga nurnakathaka nama artwa nyintanha urraritjika Judas-aka kathala nitjika. Nurna pula artwa erinhanta urraritjika, erala Jesualela kuta nakala. ");
INSERT INTO are_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Era turtala nurnakalela nakala John-ala Jesuanha kaltjirrpulhelamaliperra, Jesuanha turtantama alkirurna alputjinalpula. Nurna, artwa nhanha era turtantama, relha ntjarranha porta kuta ilitjika, Jesuanha nthurrpa errilknga ntjarranga kamerrakala.” ");
INSERT INTO are_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Apostle etnantama artwa tharra urraraka. Rretnya ekuratharra naka Joseph Barsabbas-anha, Matthias-anha turta. Joseph erinhataka etna Justus turta alpmelitjata. ");
INSERT INTO are_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kurunga etna Altjirrurna ingkaka, “Ingkartai, unta kunha relha ingkarrakaka eterrintjaka kaltja. Untantama nurnanha ilai, ");
INSERT INTO are_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","‘Artwa ngunhakama unta antja Judas-aka kathala apostle nitjika, ungkwanga urrkaputjika turta?’ Judas era kunha kala pmara nhanga ekururna lhakala, ekuralala relha unta imilakala ntjarra namanga.” ");
INSERT INTO are_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Etnantama rretnya ekuratharra parta tharraka intalhelaka. Rretnya nyinta parta nyintaka. Rretnya arrpunha parta arrpunhaka. Kurunga etna parta erinhatharra alkiraka iwuka. Parta eratharra arnaka tnyimanga, etna Matthias-aka rretnya araka, Joseph-aka pula itjala. Etnantama Matthias erinha apostle 11 etnaka lhangaka. ");
INSERT INTO are_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kala Pentecost arltantama naka. Jesuaka kurtungurla ntjarra turta iltha nyintala worlerrakala naka. ");
INSERT INTO are_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Etna ingkarraka kwanala namalanga, wurinya ekarltaka yurrangkintja ngerrantama iltha ekururna irrpuka. Wurinya era alkiranga pitjika. ");
INSERT INTO are_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Alkngantha ura ngerra turta iltha ekururna irrpentjikantema. Alkngantha erantama errarnperramala etnaka nyintaminyinturna tjananhaka. Etnantama araka ura alkngantha kurrka ngerra etnaka nyintaminyintaka kapurtakarlaka arrarnalhamanga. ");
INSERT INTO are_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Enka Alkngaltara erantama etnaka nyintaminyinturna irrpuka. Etnantama relha arrpunhaka angkatjala angkaka, Enka era etnanha ilamanga ngerra. ");
INSERT INTO are_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Arlta lenha ekurala relha Jew epinya ntjarra turta Jerusalem-ala naka, pmara arrpunhanga yatjarra pitjikala. Etna relha ilporatha naka. ");
INSERT INTO are_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yurrangkintja nhanga wumala, etnakanga ntjarra arrpunha worlerraka. Etna pula yarna etarlaritjikerraka. Etna kurtungurla etnanha wuka angkatja etnakanha inthorra angkamanga. ");
INSERT INTO are_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tnolkamalantama etna pmarrarraka, “Yai, artwa nhanha ntjarra kunha pmara Galilee-arinya? ");
INSERT INTO are_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nthakinhantama nurna nyintaminyintala etnanha wuma angkatja nurnaka inthorra angkamanga? ");
INSERT INTO are_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nurna kunha pmara twetakatwetanga pitjikala. Nurna Parthia-arinya, Media-arinya, Elam-arinya, Mesopotamia-arinya, Judea-arinya, Cappadocia-arinya, Pontus-arinya, Asia-arinya, ");
INSERT INTO are_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia-arinya, Pamphylia-arinya, Egypt-arinya, Libya-arinya, nhanga Cyrene town-anga etinya, relha Rome town-arinya yatjarra pitjikala, ");
INSERT INTO are_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(relha Jew ntjarra, relha Jew-errakala ntjarra turta), Crete-arinya, Arabia-arinya turta. Nurna angkatja nurnaka inthorra wuma, Altjirrala tjatjikarta ntjarra urrkapukala.” ");
INSERT INTO are_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kapurta etnakanha kuta ngalhelamala, yarna warta eterramala, etna wothamawotha pmarrarraka, “Iwunhama nhanha?” ");
INSERT INTO are_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Urrputja arrpunhala pula kurtungurla etnanha arrampowukala, lakinha angkamala, “Artwa lenha ntjarra pula drunk angkarlanama.” ");
INSERT INTO are_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Peter-anhantama, kurtungurla 11 etna turta kamerraka. Peter-alantama worla etnanha angkatja intarrala ilaka. “Artwa Jew ntjarrai, artwa Jerusalem-arinya arrpunha ntjarrai turta. Nukarrka rrangkarra arratja kangkwerrai. ");
INSERT INTO are_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Arai, artwa nhanha ntjarra itja drunk nama rrangkarrala etarlaramanga ngerra. Nhanha kunha 9 o'clock wara, ingutnhala. ");
INSERT INTO are_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nhanga rrangkarrala lyarta arakala pa wukala, nhanhiperrataka Altjirraka urrpia Joel-ala imanka ilakala. ");
INSERT INTO are_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Arlta ingkarnalantama, Altjirra era nhanha angkama, atha Enka nukanha relha ingkarrakurnantama yairnitjina. Kurunga worra rrakangkarranhala, kwarra rrakangkarranhala turta angkatja nukanha relha arrpunha ntjarranha ilitjina. Yinga nthitja rrakangkarranhurna, kngarripata rrakangkarranhurna turta rumerritjina etna altjirraramalanga. ");
INSERT INTO are_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","‘Arai, atha artwa urrkapunhapunha nukanha ntjarrurna, arrkutja urrkapunhapunha nukanha ntjarrurna turta Enka nukanha yairnitjina. Etna turtantama angkatja nukanha relha arrpunha ntjarranha ilitjina. ");
INSERT INTO are_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","‘Athantama relha ingkarrakaka tjatjikarta imarnitjina, alkirala, arnala turta. Etnantama alhwa, ura, urakwarta turta aritjina. ");
INSERT INTO are_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lirnnga era thapathaperritjina, taiya era turta alhwa ngerra thathitjina. Kurunga Ingkarta makalaria inthorra era pitjitjinantama. ");
INSERT INTO are_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Arlta lenha ekuralantama, relha erala Altjirrurna ingkama erinha tangkalhelitjika, erinha Altjirrala tangkalhelitjina.’ ");
INSERT INTO are_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Artwa Israel-arinya ntjarrai, angkatja nhanha turtantama rrangkarra wurrirrai. Altjirra erarrpa kunha Jesua Nazareth-arinyanha urrarakala relhanha tangkalhelitjika. Era turta ntelaka era Jesua ekura kangkamanga, erinha ekarltilamala tjatjikarta urrkaputjika. Rrangkarrarrpa turta tjatjikarta nhanha etnanha arakala. ");
INSERT INTO are_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Altjirranha kunha arrkurla kuta antja nakala Jesuanha rrakangkarra lanthitjika. Erantama erinha rrakangkarra lanthaka. Rrangkarrantama erinha Relha Lorinya ntjarralela tangitjala errilknga tuka, erinha ntolkaka kanthatumala. ");
INSERT INTO are_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Altjirrala pula erinha relha errilknga ntjarranga kamalhelaka. Arai, relha errilknga ntjarra wolkngala nama. Etnarrpa yarna rratama. Jesuanha turta wolkngala naka. Era pula rratakala, Altjirrala erinha kamalhelakalanga. ");
INSERT INTO are_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“David-anha kunha lakinha Jesuiperra angkaka, ‘Ingkarta era nukanga etinya kuta nama. Era nukanga etinya namanga, relha arrpunhala yinganha yarna kornilitjina. ");
INSERT INTO are_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Lakinhanga yinga arrkana nama. Atha Altjirranha tnantjama. Yinga turta tnoatnoa inthorra nama. ");
INSERT INTO are_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Altjirrai, unta yinganha itja wolkngaka impurlalhitjina. Unta yinganha itja impurlarrarnitjina ltholtherritjika, unta nuka kangkamanga. ");
INSERT INTO are_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Unta yinganha kaltjinthaka arratja ntelalhitjika, yinga ngampakala etatha nitjinanga. Unta turta yinganha arrkanilama, nukalela kuta namala.’ ");
INSERT INTO are_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Tjia ntjarrai, yinga nhanha rrakangkarrurna arratja inthorra angkama, errilkngipata nurnakanha David-iperra. Era iluka, etna erinha tintjiwuka, wolknga ekuranha turta nhanhala kuta nama. ");
INSERT INTO are_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David era Altjirraka urrpia naka. Era itja kngwerraka Altjirrala erinha nhanga lhelakala, ramarama ekuranha, ekuranga ingkarna king nitjinala. ");
INSERT INTO are_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","“David-anha nhanhaka kaltja naka. David erantama angkaka Altjirrala Kristanha errilknga ntjarranga kamalhelitjinala. Era turta angkaka Altjirrala Kristanha itja wolkngaka impurlalhitjinala, mpurrka ekuranha turta itja ltholtherritjinala. ");
INSERT INTO are_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Altjirralantama Jesua nhanha erinha nthurrpa errilknga ntjarranga kamalhelaka. Nurna nhanhaka kaltja, nurna erinha etatha arakalanga warta. ");
INSERT INTO are_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","“Jesua nhanha era kala alkirurnantama alpuka, era turtantama Altjirraka akwala nama. Kaartala erinha nhanga Enka Alkngaltara erinha lhelakala. Lyartantama Jesuala Enka nhanha erinha nurnakurna yairnaka. Rrangkarrarrpa nhanha arama pa wuma. ");
INSERT INTO are_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“David erarrpa itja alkirurna lhaka. Era angkatja nhanha angkamalanga, era itja ekurarinya angkaka, ‘Ingkarta era Ingkarta nukanha ilaka, “Akwa nukanhanga arrarnalhai, ");
INSERT INTO are_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","atha leltja ungkwanganha ntjarranharrka pmakwinitjinanga.” ’ ");
INSERT INTO are_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Relha Israel-arinya ntjarrai, rrangkarrataka nhanhaka kaltja nitjika. Jesua nhanha erinha rrangkarrala ntolkaka kanthatukala, erinha kunha Altjirrala ingkairnaka Ingkarta, Krista turta nitjika.” ");
INSERT INTO are_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Angkatja nhanhala relha etnanha tjalka tuka inthorra. Etnantama Peter-anha, apostle arrpunha ntjarranha turta pmarraka, “Tjia ntjarrai, nthakinhantama nurna ntelalhitjika?” ");
INSERT INTO are_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter-ala etnanha ilaka, “Rrangkarra Altjirrurna toperritjika. Rrangkarra turta nurnakurna pitjitjika, nurna rrangkarranha Jesua Kristaka rretnyala kaltjirrpulhelitjinanga. Altjirrala turtantama korna rrakangkarranha iwutjinanga. Kurunga Enka Alkngaltara era rrakangkarrurna pitjitjina, rrakangkarralela kuta nitjina turta. ");
INSERT INTO are_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Arai, Altjirralataka rrangkarranha, katjia rrakangkarranha turta Enka erinha lhelakala. Era turta Enka erinha Relha Lorinya ntjarranha lhelakala. Nhanhatitja, era relha erala urrarakala ingkarrakanha Enka ekuranha lhelaka.” ");
INSERT INTO are_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peter-ala etnanha kngarra wotha kaltjinthaka, era etnanha tjatjatuka turta. “Rrangkarrataka relha korna ntjarranga tjanalhitjika.” ");
INSERT INTO are_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Relha ntjarrantama Peter-aka angkatjaka kangkwerraka. Etna turta Peter ntjarrurna pitjika, etna, etnanha kaltjirrpulhelitjika. Arlta lenhalantama Altjirrala relha 3,000 ngerra kurtungurla ntjarraka lhangaka. ");
INSERT INTO are_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kurtungurla etnantama apostle ntjarranga kuta kaltjerraka. Etna tjina tnakanhakanha etnakanhaka kangkintja ntelalhaka. Etna turta kutatha worlerraka marna urltakitjika, ilkutjika turta. Kurunga Altjirrurna ingkitjika turta. ");
INSERT INTO are_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apostle ntjarrala tjatjikartalka urrkapuka. Lakinha Altjirrala wothamawotha ntelaka era ekarlta inthorra namanga. Relha ntjarrala tjatjikarta nhanha etnanha aramalanga, etna trerraka. ");
INSERT INTO are_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Relha tnakanhakanha etna kutatha worlerritjata. Etna ingkarraka tjina naka. Etna marnalka ingkarraka mpopaka arrarnaka. ");
INSERT INTO are_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Etna yulthalka ingkarraka etnakanha yirrinthaka, money-akatjila. Kurunga etna money nhanha tnakanhakanha ilkngara ntjarranha nthitjata. ");
INSERT INTO are_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Arltamarlta etna temple-ala worlerritjata. Kurunga etna iltha nyintalarrka, kurunga iltha arrpunhala turtantama arrkana worlerritjata marna urltakitjika, ilkutjika turta. Etna ingkarraka arrkana naka. ");
INSERT INTO are_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Etna Altjirranha turta kngarra tnantjaka. Relha arrpunha ntjarra turta etnaka kangkakantema, etna relha ilporatha namanga warta. Ingkartala turta arltamarlta relha arrpunha ntjarranha tangkalhelaka. Erantama relha nhanha etnanha worla etnakanhaka lhangaka. ");
INSERT INTO are_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Arrpunharanga, 3 o'clock-anga, Peter John tharra temple-urna lharraka, Altjirrurna ingkitjika. ");
INSERT INTO are_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Irrpunhitjinala, eratharra artwa inurra araka, reoanga kutala intamanga. Artwa nhanha erataka inurra kuta katjia intakala. Tjina ekuranha ntjarralantama erinha arltamarlta reoa nhanha ekururna kngitjata, money-aka ngkangkawulhitjika. Reoa nhanha erinhataka etna Reoa Lantjalantja ilitjata. ");
INSERT INTO are_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Artwa nhanha erantama Peter John tharranha aramalanga temple yard-urna irrpunhitjikerramanga, era ekuratharra money-aka ngkangkawulhaka. ");
INSERT INTO are_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peter John tharrala erinha intarra araka. Peter-alantama erinha ilaka, “Ilirnanha arai!” ");
INSERT INTO are_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Artwa erantama erinhatharra intarra araka. Era eterraka eratharra erinha money kula nthitjinala. ");
INSERT INTO are_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Peter-anha pula angkaka, “Money kunha nuka itja. Nhanhanta nuka intama. Atha nganha ilama Jesua Krista Nazareth-arinyaka rretnyala, nthulapai!” ");
INSERT INTO are_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peter-alantama erinha iltja akwanga errkumala, ingkaka ingkairnaka. Artwa inurra ekuranha ingka pa nururrka kala lenhantaparra ekarlterraka. ");
INSERT INTO are_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Era kala tnanpumala itnaka, nthulapuka turtantama. Kurunga era Peter tharralela temple yard-urna irrpunhaka, ingka lhamala, tnanpurlapumala, Altjirranha tnantjamala turta. ");
INSERT INTO are_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Relha ntjarrala erinha araka nthulapumanga, Altjirranha tnantjamanga turta. ");
INSERT INTO are_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Etna lhangkaraka turta era artwa nhanga namanga, erala Reoa Lantjalantjanga kutala intitjata, money-aka turta ngkangkawulhitjata. Etnantama pmarrarraka, “Artwa nhanha nthakinherrakai?” ");
INSERT INTO are_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Artwa era Peter John tharranha kuta errkurlanaka. Etna kala katha ekurala itnarlanaka, relha ntjarralala ilitjata Solomon-aka Lyuntja. Kngarra tnolkamala, relha ntjarrantama etnakurna arerraka. ");
INSERT INTO are_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Relha etnanha aramala, Peter-ala etnanha pmarraka, “Artwa Israel-arinya ntjarrai, iwunhangala rrangkarra tnolkama artwa nhanha ingkantama nthulapumanga? Iwunhanga turtama rrangkarra ilirnanha intarra inthorra yapmama? Thunga rrangkarra etarlarama ilirna kula alkngaltara inthorra namanga, ekarlta inthorra turta kula. Arai, ilirna itjama Altjirra nama. Ilirna turta itja artwa nhanhanha marrilaka. ");
INSERT INTO are_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isaac, Jacob ntjarraka Altjirra, nhanga errilkngipata nurnakanha ntjarraka Altjirra era purrama, era 'Lira ekuranha Jesuaka kangkaka inthorra. Rrangkarra pula Jesua nhanha erinha Pilate-aka lanthakala. Pilate-anhantama antja naka erinha althakalthilitjika. Rrangkarra pula Jesua erinha Pilate-anga urlarra ilparnaka kutala. ");
INSERT INTO are_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesuanha alkngaltara pa arratja naka. Rrangkarra pula ekura antjakunyala naka. Rrangkarra antja naka Pilate-ala artwa urrarna nhanganhatitja althakalthilitjika. ");
INSERT INTO are_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Artwa erala relhanha irrpalthala etathilama, erinha rrangkarra errilkngala tuka. Altjirrala pula erinha wotha relha errilknga ntjarranga kamalhelaka. Nurnarrpa nhanhaka kaltja nama, nurna erinha etatha arakalanga. ");
INSERT INTO are_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Artwa inurra erataka tnakaka Jesuanha ekarlta inthorra namanga. Lakinhanga Altjirrala erinha marrilaka Jesuaka rretnyala. Rrangkarrarrpa kala araka Altjirrala erinha marrilakala Jesuaka rretnyala, artwa era Jesuanha tnakakalanga. ");
INSERT INTO are_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Tjia ntjarrai, yingataka kaltja, rrangkarra, itornka rrakangkarranhala turta, Jesuanha errilknga tukala, ekura kotna namala. ");
INSERT INTO are_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Altjirrala imanka nhangantema ilaka, urrpia ekuranharlarlanga, Krista ekuranha nyingalauwutjinala. Altjirralantama angkatja ekuranha nthurrpilaka. ");
INSERT INTO are_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Lakinhanga korna kuta ntelalhitjala. Kala Altjirrurnanta toperrai, era korna rrakangkarranha urrparitjinanga. Kurunga erarrpa rrangkarranha wotha tjipatjipilitjina. ");
INSERT INTO are_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Anma turta era Krista Jesuanha rrakangkarrurna yairnitjina. Jesua era kunha tangkalhelanha rrakangkarra nama, tangkalhelanha Altjirra erarrpa urrarakala. ");
INSERT INTO are_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesuakathaka pula nama alkirala kuterritjika, Altjirrala alkira alhalka ingkarraka lyartinyilitjinangarrka. Altjirranha kunha nhanhiperra turta arrkurla nhangantema angkakala, urrpia ekuranharlarlanga. ");
INSERT INTO are_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Era nhanga Moses-arlarlanga relha ntjarranha ilaka, ‘Arai, atha urrpia arrpunhantama rrakangkarrurna yairnitjina. Era Moses ngerra nitjina. Rrangkarra kala ekurantama kangkwerritjika. ");
INSERT INTO are_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Relha erala urrpia nhanha ekura itja kangkwerrama, era itja wotha tjina nuka nitjina. Atha turta erinha kala yirralhelitjinanta.’ ");
INSERT INTO are_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Samuel-ala, Altjirraka urrpia arrpunha ntjarrala turta, relha ntjarranha Kristiperra kaltjinthakantema. Urrpia nhanha etnataka relha ntjarranha kaltjinthakala, Moses-anga ingkarna. ");
INSERT INTO are_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yia etnakanhantama rrakangkarra inthorra nama. Altjirrala nhanga Abraham-anha lhelaka, ‘Annga ungkwanganharlarlanga atha relha ingkarrakanha marrilitjina.’ Lhelintja nhanha turta rrakangkarra inthorrantema nama. ");
INSERT INTO are_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Altjirralantama 'Lira ekuranha rrakangkarrurnakimparra yairnaka. Era antja naka rrangkarra kornanga toperritjika, era rrangkarranha lyekarrilitjinanga.” ");
INSERT INTO are_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peter John tharra relha ntjarrurna angkamalangantema, priest ntjarra, temple tjapartia ntjarraka itornka, artwa Sadducee ntjarra turta ekuratharrurna pitjika. ");
INSERT INTO are_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Etna ekuratharra aala pitjika, eratharra relha ntjarranha kaltjinthamanga Jesuanha errilknga ntjarranga kamerrakala. Eratharra turta relha ntjarranha ilamanga relha ingkarraka anma kamerritjinala, Jesuanha kamerrakalanga. ");
INSERT INTO are_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kala ngurrangurrerrakalangantama, etna erinhatharra errkumala temple jail-aka kurnaka, ekuratharralela ingutnhala angkarritjinala. ");
INSERT INTO are_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Relha ntjarra arrpunha, etnala Peter tharranha wukala relha ntjarranha kaltjinthamanga, etna Jesuanha tnakaka. Worla tnakanhakanha etnantama wotha kngarrerraka. Etna kala artwa 5,000 ngerrantama naka. ");
INSERT INTO are_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kala ingutnhalantama relha Jew ntjarraka itornka etna, kngarripata itornka etna, artwa Intarrangaltha etna turta, Jerusalem-ala worlerraka. ");
INSERT INTO are_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas, High Priest era, Caiaphas, John, Alexander turta, etna ingkarraka kala worla lenhala nakantema, Annas-aka tjina arrpunha ntjarra turta. ");
INSERT INTO are_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Peter John tharraka ntangkalhamalantama, etna erinhatharra etnakanga mpopaka ingkairnaka. Etna erinhatharra pmarrakantama, “Ngunhalama mpalanha ekarltilaka artwa inurra nhanhanha marrilitjika? Ngunhaka rretnyala turtama mpala erinha marrilaka?” ");
INSERT INTO are_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Peter-anhantama, Enka Alkngaltarakarta namala, etnakurna angkaka. ");
INSERT INTO are_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“Itornka ntjarrai, kngarripata itornka ntjarrai turta. Rrangkarra kunha ilirnanha pmarrama, ‘Iwunhangala mpala artwa inurra nhangaka konyerraka? Nthakinha turtama mpala erinha marrilaka?’ ");
INSERT INTO are_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ilirna rrangkarranha kala nhanhanta ilama, relha Israel-arinya ingkarrakanha turta. Ilirna kunha artwa inurra erinha marrilaka Jesua Krista Nazareth-arinyaka rretnyala. Jesua nhanha erinha rrangkarra nhanga ntolkaka kanthatukala. Altjirrala pula erinha wotha errilknga ntjarranga kamalhelakala. ");
INSERT INTO are_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesua, ‘Parta nhanga iltha itanha rrangkarrala ipmintja iwukala, erantama lyarta parta tjiparralkura era nama.’ ");
INSERT INTO are_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Eranta kunha relhanha irrpalthala tangkalhelama. Lakinhanga relha erala antja nama Altjirrala erinha tangkalhelitjika, era kala Jesuanhanta tnakitjika.” ");
INSERT INTO are_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Artwa itornka etna Peter John tharranha aramalanga tnoatnoa inthorra angkamanga, etna tnolkaka. Etna kaltjakwia naka eratharra artwa kornakorna tharra namanga, itja arrkurla kngarra kaltjerrakala. Etnantama lhangkaraka eratharra Jesualela nakala. ");
INSERT INTO are_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Etna pula trerraka erinhatharra ilparnitjika, artwa marrerrakala era ekuratharralela namangantema. ");
INSERT INTO are_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Lakinhanga Sanhedrin council etna Peter tharranha turnaka kathalarrka kaaralhitjika. Kurunga etnarrpa angkarraka. ");
INSERT INTO are_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Artwa nhanha tharranha nurna nthakinhilamarama?” etna pmarrarraka. “Relha Jerusalem-arinya ingkarraka kala kaltja eratharra tjatjikarta kngarra urrkapukala. Nurna nhanha yarna ilpoiwuma. ");
INSERT INTO are_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Arai, relha arrpunha ntjarrala turtantama nhanhiperra wukitja, nurna erinhatharra angkatja ekarltala parritjika, eratharra itja wotha relha ntjarranha Jesuiperra kaltjinthitjika.” ");
INSERT INTO are_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ekuratharra wotha ntangkalhamalantama, etna erinhatharra turnaka, “Mpala itja wotha relha ntjarranha Jesuiperra kaltjinthitjika.” ");
INSERT INTO are_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Peter John tharrala pula etnanha ilaka, “Rrangkarrarrpa etarlarai, iwunha paka Altjirranga urlarra arratja nama? Ilirna rrakangkarra kangkwerritjika, Altjirraka paka? ");
INSERT INTO are_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Arai, ilirna yarna pmarna nama. Nhanga ilirnala arakala pa wukala, nhanha kala ilirnakathaka nama relha ntjarranha ilitjika.” ");
INSERT INTO are_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Etnantama erinhatharra lhalaramala, kala yairnarlenaka. Etnataka trerraka erinhatharra tutjika, relha ingkarrakala Altjirranha tnantjamanga, etna tjatjikarta kngarra arakalanga. ");
INSERT INTO are_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Artwa nhanga, erinhala Peter tharrala marrilakala, tjatjikarta urrkapumala, erataka 40 years-anga ingkwialkura naka. ");
INSERT INTO are_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Etna erinhatharra tnauwukantama. Kurunga eratharra tnakanhakanha ntjarrurna alpuka. Eratharrantama etnanha angkatja ingkarraka alpmelaka, priest itornka ntjarrala, kngarripata itornka ntjarrala turta, erinhatharra ilakala. ");
INSERT INTO are_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nhanha wumala, tnakanhakanha etna ingkarraka Altjirrurna ingkaka. “Tjitjartai, unta kunha alkira, alha, laiya turta arrpmarnakala, ntheilpuralka, relhalka, irrpanngalka ingkarraka turta. ");
INSERT INTO are_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Unta kunha errilkngipata nurnakanha David-arlarlanga lakinha angkakala, ‘Iwunhangama Relha Lorinya ntjarra yirrknga inthorrerrama? Iwunhanga turtama etna turritjika antjerrama? ");
INSERT INTO are_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","King alharinya ntjarra tjurnalhama, itornka etna turta worlerrama, Ingkarta-aka, Krista ekuranhaka turta irrpaltherritjika.’ David era kunha Enka Alkngaltarakarta naka, era lakinha angkamalanga. ");
INSERT INTO are_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Arai, nhanhala, Jerusalem-ala, Herod-anha, Pontius Pilate-anha turta, nyinterraka Relha Lorinya ntjarralela, relha ungkwanganha ntjarralela turta. Etnantama Jesuaka irrpaltherraka, 'Lira ungkwanganhaka, artwa nhanga untarrpa urrarakalaka. ");
INSERT INTO are_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Etnantama Jesuanha rrukunthakunthilaka, errilknga tuka turta, untala arrkurla kuta antja nakala ngerra. ");
INSERT INTO are_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ingkartai, unta kala arama etna nurnaka turtantama irrpaltherramanga. Lakinhanga nurna ungkwangurna ingkama unta nurnanha ekarltilitjika, nurna angkatja ungkwanganha relha ntjarranha tnoatnoa kuta kaltjinthitjinanga. ");
INSERT INTO are_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Unta relha menta ntjarranha kuta marrilai. Unta 'Lira alkngaltara ungkwanganha Jesuaka rretnyala kuta tjatjikarta urrkapai.” ");
INSERT INTO are_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Altjirrurna ingkamaliperra, iltha ekuralala etnala worlerrakala, era errarlperrowuka. Enka erantama etnakurna irrpuka. Etna turtantama relha ntjarranha Altjirraka angkatja tnoatnoa kuta kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Relha tnakanhakanha ntjarra kala tjinanta ingkarraka naka. Itja nyinta paka angkaka, “Yultha nuka, nukanta nama.” Ingkarrakala pula yultha etnakanha mpopaka ngerra arrarnaka, ingkarrakaka. ");
INSERT INTO are_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apostle etna relha ntjarranha angkatja ekarltala kaltjinthalanaka, “Ingkarta Jesuanha relha errilknga ntjarranga kamerrakala.” Altjirranha turta relha tnakanhakanha ingkarrakaka ngwanga inthorra ntelalhaka. ");
INSERT INTO are_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tnakanhakanha nyinta itja paka ngaiyala naka, mantarrakunya paka. Lenha ntjarra, etnakala tnukulpa namanga, iltha arrpunha paka, etna nhanha yirrinthaka, money-akatjila. ");
INSERT INTO are_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Kurunga etna money nhanha Apostle ntjarranha nthaka. Apostle etnantama tnakanhakanha ilkngara ntjarranha marnala, mantarrala turta ntarntaraka. ");
INSERT INTO are_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Joseph-ala turta tnukulpa ekuranha money-akatjila yirrinthaka. Erantama money ingkarraka Apostle ntjarranha nthaka. Joseph nhanha erataka pmara Cyprus-ala alkngerrakala. Era turta Levi-aka ramarama naka. Apostle ntjarralantama Joseph nhanha erinha rretnya Barnabas turta alpmelaka. Rretnya Barnabas nhanha nama, ‘Era, erala relha arrpunha ntjarranha tjipatjipilama.’ ");
INSERT INTO are_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Noarta tharrala, Ananias Sapphira tharrala, tnukulpa nyinta yirrinthakantema, money-akatjila. ");
INSERT INTO are_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananias-anha antja naka money arrpunha tnyinitjika, money arrpunhanta Apostle ntjarranha nthitjika. Erantama noa ekuranha nhanha alpmelaka. Ananias erantama money arrpunha ekurakarta Apostle ntjarrurna lhaka, etnanha money erinha nthaka turta. ");
INSERT INTO are_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Peter-alantama erinha pmarraka, “Ananias-ai, iwunhangala unta Satan-aka kangkwerraka? Iwunhanga turtama unta Enka Alkngaltaraka orrtjerraka? Yinga kaltja unta money arrpunha tnyinakala. ");
INSERT INTO are_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tnukulpa era kunha ungkwanga naka. Tnukulpa erinha yirrinthamaliperra turta, money era ungkwangantema naka. Lakinhanga nhanha ungkwangathaka naka money erinha tnyinitjika, erinha errarnpalhelitjika paka, unta antjerramala ngerra. Iwunhangantama unta orrtjerraka? Arai, unta itja relhaka orrtjerraka, Altjirraka pula.” ");
INSERT INTO are_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nhanha wumala, Ananias-anha errilknga tnyilalhaka. Relha ntjarrala Ananias-iperra wumalanga, etna ingkarraka trerraka. ");
INSERT INTO are_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Artwa nthitja ntjarrantama pitjika. Etna Ananias-aka mpurrka mantarrala ilinyiwumala kathurna kngaka, tintjiwuka turta. ");
INSERT INTO are_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kala anma Sapphira-anhantama irrpentjika. Sapphira era itja kaltja naka noa ekuranha ilukala. ");
INSERT INTO are_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter-alantama erinha pmarraka, “Yinganha ilai, Ananias-ala money ingkarrakama kngitjika?” “Awa,” era angkaka, “Era money ingkarrakakwia kngitjika. Lakintjaka kunha era tnukulpa erinha yirrinthakala.” ");
INSERT INTO are_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peter-alantama erinha pmarraka, “Iwunhangala mpala nyinterraka Ingkartaka Enka orrtjapepilitjika? Arai, artwa nthitja etnala noa ungkwanganha tintjiwukala, etna kunha reoala itnarlanama. Etna nganha turta tintjiwutjika kngitjina.” ");
INSERT INTO are_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sapphira-anhantama kala Peter-aka ingkanga kutaka tnyilalhaka, iluka turta. Nthitja etnantama irrpentjika. Etna araka era kala ilukala. Etnantama erinha kathurna kngaka, erinha noa ekuranhanga kutaka turta tintjiwuka. ");
INSERT INTO are_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Worlamparinya etnantama trerraka nhanhiperra wumala. Relha arrpunha ntjarra turta trerrakantema. ");
INSERT INTO are_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Altjirrala tjatjikarta ntjarra urrkapuka, relha ntjarranha marrilamala, apostle ntjarrarlarlanga. Tnakanhakanha etna turta kutatha Solomon-aka Lyuntjala worlerritjata. ");
INSERT INTO are_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Relha ntjarrala tnakanhakanha etnanha kngarra tnantjaka. Etna pula trerraka etnakalela nyinterritjika. ");
INSERT INTO are_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Artwa pa arrkutja arrpunha ntjarrala turtantama Ingkartanha tnakaka. ");
INSERT INTO are_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kurunga relha arrpunha ntjarrala menta ntjarranha turtantama tjaiyaka arrarnitjata, ntjama etnakanhala intamala kuta. Etna alkurnaka Peter-anha paka anpara lhamanga, ntolya ekuranhala etnanha korltanhamala marrilitjinanga. ");
INSERT INTO are_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Relha ntjarra arrpunha etnala Jerusalem-anga kathala namanga, etna turta relha menta etnakanha, relha enka kornakarta etnakanha turta, Apostle ntjarrurna kngitjika. Etna, etnanha ingkarraka marrilaka. ");
INSERT INTO are_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","High Priest erantama, artwa Sadducee arrpunha ntjarra turta, apostle etnaka yirrknga inthorrerraka. ");
INSERT INTO are_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Etnantama apostle etnanha errkumala jail-aka kurnaka. ");
INSERT INTO are_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ingkartaka angel pula ingula pitjika. Jail-aka reoa altjurilamala, angel era etnanha kathurna rretjingaka. Era etnanha ilaka, ");
INSERT INTO are_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kala temple-urna lharrirrai. Rrangkarra turtantama relha ntjarranha ilai, yia ingkarraka Jesuiperra.” ");
INSERT INTO are_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Lirnnga kala rratitjikerramalangantama, etna temple yard-urna irrpunhaka, relha ntjarranha kaltjinthaka turta. High Priest era, artwa ekuranha ntjarrala turtantama, Sanhedrin council etnanha worlilaka, angkarritjika. Sanhedrin council etnataka relha Israel-arinya ingkarrakaka itornka naka. Etnantama apostle etnaka ntangkalhaka. ");
INSERT INTO are_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Artwa urrkapunhapunha etnakanhantama jail-urna lhaka. Etna pula apostle etnanha itja arltaraka. Pitjalpumala etna itornka etnanha ilaka, ");
INSERT INTO are_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Arai, jail-urna lhamala nurna reoa ingkarraka marnta kuta aritjalhaka. Nurna tjapartia etnanha turta araka reoa ingkarraka arratja ntarntaramanga. Nurna pula reoa etnanha altjurilamalanga, nurna room etnanha urltala araka.” ");
INSERT INTO are_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Angkatja nhanha wumala, tjapartia ntjarraka itornka, priest itornka ntjarra turta yarna eterraka. ");
INSERT INTO are_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Artwa nyintantama pitjika, etnanha ilaka turta, “Arai, artwa nhanga ntjarra rrangkarrala jail-aka kurnakala, etnataka temple yard-ala relha ntjarranha kaltjinthalanama.” ");
INSERT INTO are_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tjapartiaka itornka erantama lhaka, tjapartia urrputjakarta, apostle etnanha inarlalhaka turta. Tjapartia etna pula itja apostle etnaka alkngarnterraka. Etnataka relha ntjarranga trerraka, etna, etnanha partala wakitja. ");
INSERT INTO are_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Apostle etna kala Sanhedrin council etnakanga mpopala itnamalangantama, High Priest era etnanha ilaka. ");
INSERT INTO are_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Arai, nurna kunha rrangkarranha angkatja ekarltala parrakala itja wotha relha ntjarranha Jesuiperra kaltjinthitjika. Kanha rrangkarra itjala nurnaka kangkwerraka. Rrangkarra relha Jerusalem-arinya ingkarrakanha kaltjinthakatitja. Rrangkarra turta nurnanha ilparnaka, nurnala kula Jesuanha errilknga tukala.” ");
INSERT INTO are_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter-ala, apostle arrpunha ntjarrala turtantama etnanha ilaka. “Nurnakathaka nama Altjirraka kangkwerritjika, itja relhaka. ");
INSERT INTO are_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Rrangkarra Jesuanha errilknga tuka, erinha irnaka ilpararrarnamala. Errilkngipata nurnakanhaka Altjirrala pula erinha errilknga ntjarranga wotha kamalhelaka. ");
INSERT INTO are_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Altjirrala turtantama erinha ekuranga akwaka arrarnaka, Tjitjarta pa Tangkalhelanha nitjika, era relha Israel-arinya ntjarranha ntangkitjinanga toperritjika. Relha etnala toperrama, era korna etnakanha iwutjina. ");
INSERT INTO are_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nurna, Enka Alkngaltarala turta, rrangkarranha nhanha kaltjala ilama. Relha arrpunha ntjarra, etnala Altjirraka kangkwerrama, etna kala Enka Alkngaltarakarta nama.” ");
INSERT INTO are_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sanhedrin council etna nhanha wumalanga, etna yirrknga inthorrerraka. Etna turtantama antja naka apostle etnanha kala errilknganta tutjika. ");
INSERT INTO are_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sanhedrin council etnakanga artwa nyintantama kamerraka. Era naka artwa Pharisee, rretnya Gamaliel. Era kaltjinthanhinthanha kngarra turta naka. Relha ntjarra turta ekura kngarra kangkaka. Erantama tjapartia ntjarranha turnaka apostle etnanha kathurnarrka kngitjika. ");
INSERT INTO are_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kurunga era Sanhedrin council etnanha ilaka. “Artwa Israel-arinya ntjarrai, rrangkarra itja artwa nhanha ntjarranha parrpa imilitjika. ");
INSERT INTO are_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ngurrukalkura wara, artwa Theudas-anha ilalhaka era kula artwa kngarra namanga. Artwa 400 ngerra turtantama ekura lhangalhaka. Artwa arrpunhala pula erinha errilknga tumalanga, worla ekuranha kala errarnperrakanta. ");
INSERT INTO are_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Kurunga Judas, artwa pmara Galilee-arinya nhanga, erantama ekurarinya tjurnalhaka, government-ala nurnanha nhanga count-emilamanga. Ntjarra ekura lhangalhaka. Artwa arrpunhala pula erinha errilknga tumalanga, worla ekuranha turta errarnperrakantema. ");
INSERT INTO are_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Lakinhanga atha rrangkarranha ilama artwa nhanha ntjarranha kala impai, etnarrpa nitjika. Arai, yia nhanha etnala relha ntjarranha kaltjinthama, nhanha paka relhaka yia namanga, nhanha kala ipmintjerritjina. ");
INSERT INTO are_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nhanha pula Altjirraka yia namanga, rrangkarra nhanha yarna kuta parritjina. Rrangkarra kala Altjirrakanta irrpaltherritjina.” ");
INSERT INTO are_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Sanhedrin council etnantama Gamaliel-aka kangkwerraka. Apostle ntjarraka wotha ntangkalhamala, etna tjapartia ntjarranha turnaka etnanha whip-ala tutjika. Etnantama etnanha parraka inthorra. “Rrangkarra itja wotha relha ntjarranha Jesuiperra kaltjinthitjika.” Kurunga etna, etnanha kala tnauwuka. ");
INSERT INTO are_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Sanhedrin council etnakanga rratamala, apostle etna arrkana inthorra alpuka. Etnataka kangkaka etnakathaka namanga Jesuaka rretnyakakwia nyingalauwutjika. ");
INSERT INTO are_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Etnantama arltamarlta temple-ala, relhaka ilthala turta relha ntjarranha kaltjinthaka. Etna, etnanha ilaka Jesuanha Krista era namanga. ");
INSERT INTO are_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Altjirralantama arltamarlta relha ntjarra arrpunha turta kurtungurla ntjarraka lhangaka. Kurtungurla etnakanga, relha ntjarra arrpunha Greek angkitjata. Kanha arrpunha ntjarra Hebrew-ala angkitjata. Kurunga relha Greek angkanhangkanha ntjarra, relha Hebrew angkanhangkanha ntjarraka wannga angkaka, etna warlukurta etnakanha itja arratja marnala ntarntaramanga. ");
INSERT INTO are_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Apostle 12 etnantama kurtungurla ingkarrakanha worlilaka. Kurunga etna, etnanha ilaka, “Arai, nhanha itja marra namara nurna Altjirraka Angkatja ipmintja imputjika, marna errarnpalhelitjika. ");
INSERT INTO are_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Lakinhanga tjina ntjarrai, rrangkarrataka artwa ilporatha 7 urraritjika, artwa nhanga Enka Alkngaltarakarta, eterrintja marrakarta turta. Nurnantama etnanha ingkairnitjinanga marna errarnpalhelitjika. ");
INSERT INTO are_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nurnarrpa pula Altjirrurnala kuta ingkitjina, relha ntjarranha Altjirraka angkatja turta kuta kaltjinthitjina.” ");
INSERT INTO are_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Worla etna angkatja nhanhaka kangkaka. Etnantama Stephen-anha urraraka, artwa Enka Alkngaltarakarta, tnakanhakanha ilporatha turta. Kurunga etna Philip-anha, Procorus-anha, Nicanor-anha, Timon-anha, Parmenas-anha, Nicolas-anha turta urraraka. Nicolas nhanha erataka Antioch town-arinya naka. Era turta itja relha Jew alkngerrakala. ");
INSERT INTO are_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Artwa nhanha etnanhantama etna apostle ntjarrurna kngitjika. Apostle etnantama etnakakwia Altjirrurna ingkaka, iltja etnakanha turtantama kapurtaka etnakanhaka arrarnaka. ");
INSERT INTO are_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kurunga tnakanhakanha ntjarrala relha arrpunha ntjarranha turta kaltjinthaka. Altjirrala turtantama relha arrpunha ntjarranha worla etnakanhaka lhangaka. Priest arrpunha ntjarrala turtantama Jesuanha tnakaka. ");
INSERT INTO are_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Altjirranha Stephen-aka ngwanga inthorra ntelalhaka, era erinha ekarltilaka turta. Stephen erantama tjatjikarta ntjarra urrkapuka. ");
INSERT INTO are_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nhanhakakwia artwa arrpunha ntjarra ekura antjakunyerraka. Artwa nhanha etna relha Jew naka Cyrene town-anga, Alexandria town-anga turta pitjikala. Etna ingkarraka synagogue iltha nyintaka irrputjata. Synagogue ekura rretnya naka ‘Artwa Althakaltha Ntjarraka Synagogue’. Artwa nhanha etnantama, artwa urrputja arrpunha turta, etnala pmara Cilicia-anga, pmara Asia-anga turta pitjikala, etna Stephen-alela angkatja iwurraka. ");
INSERT INTO are_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Stephen-ala pula etnanha impuka kuta, Enka Alkngaltarala warta erinha inangkarla inthorrilakalanga. ");
INSERT INTO are_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kurunga artwa nhanha etna artwa korna ntjarranhantama nyilknganyilkngala turnaka Stephen-anha ilparnitjika, “Nurna Stephen-anha wuka Moses-anha, Altjirranha turta arrampowumanga.” ");
INSERT INTO are_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Angkatja nhanhala relha ntjarranha, kngarripata itornka ntjarranha, artwa Intarrangaltha ntjarranha turta rwampia inthorrilaka. Etnantama Stephen-anha errkumala Sanhedrin council-urna rretjingaka. ");
INSERT INTO are_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Etna artwa orrtjerranha ntjarranha turta turnaka erinha Sanhedrin council-anga urlarra ilparnitjika, “Artwa nhanhala kunha Altjirraka iltha, Altjirraka turnintja turta kutatha arrampowuka. ");
INSERT INTO are_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nurna erinha wuka era relha ntjarranha ilamanga Jesua Nazareth-arinyala kula Altjirraka iltha urltakitjinala. Jesua era turta kula mpaarangaranga nurnakanha ekngarrpunhilitjinala, mpaarangaranga nhanga Moses-ala errilkngipata nurnakanha ilakala.” ");
INSERT INTO are_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Sanhedrin council etnantama Stephen-anha intarra araka. Etna araka anngerra ekuranha angel-aka anngerra ngerra namanga. ");
INSERT INTO are_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","High Priest erantama Stephen-anha pmarraka, “Nthakinha unta etarlarama? Angkatja arratjama etna ungkwangiperra angkaka?” ");
INSERT INTO are_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen-alantama etnanha ilaka, “Tjina ntjarrai, kaarta ntjarrai turta, yinganharrkantama wurrirrai. Altjirra nurnakanha, erala makalaria nama, era kunha kaarta nurnakanha Abraham-aka rumerraka, era nhanga pmara Mesopotamia-alantema namalanga, nhanga itjantema pmara Haran-urna pitjikala. ");
INSERT INTO are_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Altjirrala erinha ilaka, ‘Pmara ungkwanganha, tjina ungkwanganha turta impurlalhai. Untantama pmara arrpunhurna lhalathanai, pmara athala nganha ntelitjina.’ ");
INSERT INTO are_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kala pmara Chaldea-anha impurlalhamala, era pmara Haran-urna lhaka, ekurala turtantama kuterraka. “Kaarta ekura kala ilukantama. Kurunga Altjirrala Abraham-anha pmara nhanhurna yairnaka, pmara nhanga nurnala lyarta nama. ");
INSERT INTO are_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Altjirrala pula erinha itja pmara erinha nthaka. Era erinha, ramarama ekuranha turta, pmara erinha nthitjika lhelakanta. Altjirrala Abraham-anha pmara nhanha lhelamalanga, Abraham-aka katjia itjantema intaka. ");
INSERT INTO are_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Altjirrala Abraham-anha nhanha turta ilaka, ‘Arai, ramarama ungkwanganha pmara lorinyalarrka nitjina 400 years-aka. Etna turta relha lorinya ntjarraka kngarra inthorra urrkaputjina. Relha lorinya etna turta etnanha nakapakarla inthorrilitjina. ");
INSERT INTO are_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Atha pula relha lorinya nhanha etnanha rrarrathala tutjina. Kurunga ramarama ungkwanganha pmara lorinya ekuranga naamerritjina, nhanhurna turta pitjitjina, nuka turta urrkurrkintja nitjina.’ ");
INSERT INTO are_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Altjirralantama Abraham-anha turnaka era erinha kapanha lhelitjika. Era erinha ilaka, ‘Unta, ramarama ungkwanganhala turta, rrangkarra worra ingkarraka rrakangkarranha artwilitjika etna arlta 8 ingkwia namalanga.’ Lakinhanga, Abraham-ala worra ekuranha Isaac-anha artwilaka era arlta 8 ingkwia namalanga. Isaac-ala worra ekuranha Jacob-anha artwilakantema. Jacob-ala turta worra 12 ekuranha artwilaka. Worra 12 nhanha etnakanga Israel-aka ramarama ingkarraka rrataka. ");
INSERT INTO are_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Joseph-aka kalya ntjarra ekura antjakunyerraka. Etnantama erinha artwa lorinya ntjarraka yirrinthaka. Artwa lorinya ntjarrala turtantama erinha pmara Egypt-urna kngaka. Altjirranha pula Joseph-alela naka. ");
INSERT INTO are_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Era imampurlerramanga, era erinha ntarntaraka. Era erinha inangkarla inthorrilaka turta. Pharaoh, Egypt-aka king, erantama Joseph-aka kngarra kangkaka. Era turtantama erinha ingkairnaka pmara Egypt ntjaparaka tjitjarterritjika, yultha ekuranha ingkarraka ntarntaritjika turta. ");
INSERT INTO are_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Marnaka paalerrintja kngarrantama naka Egypt-ala, pmara Canaan-ala turta. Relha ingkarraka, tnonthalkantama nyingalauwuka. Kaarta nurnakanha ntjarra turtantama ngaiyala naka. ");
INSERT INTO are_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jacob-alantama wumalanga marna kula Egypt-ala namanga, era kaarta nurnakanha ntjarranha Egypt-urna yairnaka. ");
INSERT INTO are_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kurunga etna arrpunharangantama marnaka lhamanga, Joseph-anha etnaka ilalhakantama, era tjia etnaka namanga. Pharaoh-ala turtantama Joseph-aka ramaramiperra wuka. ");
INSERT INTO are_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Joseph-anhantama kaarta ekuranhaka, ramarama ekuranha ingkarrakaka turta ntangkalhaka, etna Egypt-urna pitjitjika. Ramarama etnataka relha 75 naka. ");
INSERT INTO are_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jacob-anha Egypt-urna lhaka, pmara ekurala turtantama iluka. Kaarta nurnakanha arrpunha ntjarra turta Egypt-ala ilukantema. ");
INSERT INTO are_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Anma etna Jacob ntjarraka mpurrka Shechem town-urna kngetnaka. Etnantama mpurrka etnakanha intia nhangaka arrarnaka, intia nhanga Abraham-alala Hamor-aka ramaramanga buy-emilakala. ");
INSERT INTO are_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Anma, Israel-aka ramarama kala ntjarra inthorrantama namalanga, Altjirranha eterraka etnanha kala pmara ekururna kngetnitjika, erala Abraham-anha lhelakala. ");
INSERT INTO are_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kurunga king arrpunhantama Egypt-ala naka. Era itja Joseph-iperra kaltja naka. ");
INSERT INTO are_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Erantama relha nurnakanha ntjarranha orrtjapepilaka, etnaka alkngarnterraka turta. Era etnanha turnaka katjia etnakanha kathaka ipmintja imputjika, etna ilutjinanga. ");
INSERT INTO are_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Moses-anhantama katjia intaka. Era worra intorta inthorra naka. Kaarta pa mia ekuranhala erinha ilthalarrka ntarntaraka, 3 month-aka. ");
INSERT INTO are_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kurunga etna erinha kathaka ipmintja impuka. Pharaoh-aka kwarralantama erinha arltaraka, erinha pmara ekuranhurna kngetnaka, erinha mangkalhelaka turta. ");
INSERT INTO are_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Egypt-arinya ntjarralantama Moses-anha kngarra inthorra kaltjinthaka. Era turtantama inangkarla inthorrerraka. Era itornka kngarra turtantama naka. ");
INSERT INTO are_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses-anha kala 40 years ingkwiantama namalanga, era eterraka relha Israel-arinya ntjarrurna yatjarra lhitjika, etnanha aritjika. ");
INSERT INTO are_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Etnakurna lhamala, era araka artwa Egypt-arinyala artwa Israel-arinya nyintanha kngarra tumanga. Erantama artwa Egypt-arinya erinha tangitjala tumala, errilknga tuka. ");
INSERT INTO are_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses-alantama etarlaraka, ‘Relha nukanha ntjarrala lyarta lhangkaritjina Altjirrala yinganha yairnakala, etnanha tangkalhelitjika.’ Etna pula nhanha itja lhangkaraka. ");
INSERT INTO are_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Arlta arrpunhala era araka artwa Israel-arinya tharra turramanga. Erantama erinhatharra arrkngantiwuka. Era erinhatharra ilaka, ‘Mpala kunha kanhanga ngerra. Iwunhangantama mpala turrama? ");
INSERT INTO are_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Artwa erala artwa arrpunhaka alkngarnterrakala, era pula erinha pauwurlenaka. Era erinha pmarraka, ‘Ngunhalama nganha ingkairnaka nurnaka tjitjarterritjika, nurnanha tjiperrawutjika turta? ");
INSERT INTO are_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Unta antja nama yinganha turta errilknga tutjika, untala artwa Egypt-arinya nhanganha ngurruka errilknga tukala ngerra?’ ");
INSERT INTO are_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nhanha wumala Moses-anha tira arrtjanaka pmara Midian-urna, tanhala turtantama kuterraka. Worra ekuranha tharra turta Midian-ala alkngerraka. ");
INSERT INTO are_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Era kala 40 years-ntama Midian-ala naka. Kurunga angel nyinta ekura rumerraka worritjala, nhanga Sinai Partanga kuta. Angel erataka irna mpumalala rumerraka. ");
INSERT INTO are_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses-ala irna mpumala erinha aramala, era tnolkaka. Erantama irna ekura etinyerraka, aritjika. Ingkartanhantama ekururna angkaka, ");
INSERT INTO are_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yinga kaarta ungkwanganha Abraham-aka, Isaac-aka, Jacob-aka Altjirra nama.’ Moses-anhantama tira errowuka. Era turta alknga kwaninyerraka. ");
INSERT INTO are_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ingkartalantama erinha ilaka, ‘Sandal ingka ungkwanganhanga ilwai. Katha untala itnama, erataka makamaka nama. ");
INSERT INTO are_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Arai, atharrpa araka relha Egypt-arinya ntjarrala relha nukanha ntjarranha rrukunthakunthilamanga. Atha turta etnanha mpangkamanga wuka. Yingantama nhanha pitjika etnanha tangkalhelitjika. Arai, lakinhanga atha nganha pmara Egypt-urna yairnama.’ ");
INSERT INTO are_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Nhanha kunha Moses nyinta era naka, ekurala relha ekuranha ntjarra itja antja nakala. Etna erinha nhanga ilakala, ‘Ngunhalama nganha ingkairnaka nurnaka tjitjarterritjika, nurnanha tjiperrawutjika turta?’ Moses nhanha erinhantama Altjirra erarrpa yairnaka relha ekuranha ntjarraka tjitjarterritjika, etnanha tangkalhelitjika turta. Altjirranhataka Moses-urna angkaka angel ekuranharlarlanga, angel erala nhanga Moses-urna rumerrakala irna mpumalala. ");
INSERT INTO are_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","“Moses-ala relha ntjarranha 40 years rretjingaka, tjatjikartalka urrkapumala, Egypt-alarrka, Laiya Thathakalantama, kurunga worritjala turtantama. ");
INSERT INTO are_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses nyinta nhanha erantema Israel-aka ramarama ilakala, ‘Anma Altjirrala urrpia arrpunhantama rrakangkarrurna yairnitjina. Era yinga ngerra inthorra nitjina. Era turta artwa Israel-arinya nitjina.’ ");
INSERT INTO are_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses nhanha era kunha worlamparinyalela naka worritjala. Moses nhanha ekururna, kaarta nurnakanhurna turta, angel nhanga angkaka Sinai Partala. Moses nhanha erinha kunha angel-ala Altjirraka angkatja ilaka, Moses-ala angkatja nhanha nurnakurna anparilitjika. ");
INSERT INTO are_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kaarta nurnakanha ntjarra pula Moses-aka itja kangkwerraka. Ekura antjakunyerramala, etna antja naka Egypt-urna alputjika. ");
INSERT INTO are_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“Etnantama Aaron-anha ilaka, ‘Altjirra nurnaka mpaarai, nurnanha rretjingitjika. Moses-ala kunha nurnanha Egypt-anga nhanhurna rretjingakala. Moses erantama nthakinherraka? Nurna itja kaltja.’ ");
INSERT INTO are_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Etnantama orrtja altjirra mpaaraka, calf ngerra. Kurunga etna orrtja altjirra nhanha ekura urrkurrkintja naka, erinha tjauwerrilya nthamala. Etna orrtja altjirra nhanha ekura kngarra kangkaka, altjirra nhanga etnala iltjala mpaarakala. ");
INSERT INTO are_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Altjirranha pula etnakanga ntjumerraka. Era turta etnanha impuka ntheilpurakalkantama urrkurrkintja nitjika. Nhanga Altjirraka urrpia imankinya ntjarrala ilaka, ‘Israel-aka ramaramai, rrangkarra itjama yinganha tnontha tjauwerrilya lanthakala, rrangkarra 40 years worritjala namalanga. ");
INSERT INTO are_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Rrangkarra pula altjirra Molech-aka tent-atitja kngarnarlapuka, altjirra Rephan-aka ntheilpura turta. Rrangkarra ekuratharraka ntolya mpaaramaliperra, rrangkarra ntolya nhanha ekuratharrakantama urrkurrkintja naka. Lakinhanga atha rrangkarranha pmara Babylon-urna naamalhelitjina.’ ");
INSERT INTO are_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Altjirralataka Moses-anha tent ekuranhaka ntolyarrka ntelaka. Kurunga era Moses-anha turnaka etna tent erinha mpaaritjika ntolya nhanga erala erinha ntelakala ngerra inthorra. Altjirraka yultha turta tent nhanhala intaka. Tent nhanha turta kaarta nurnakanhalela naka worritjala. ");
INSERT INTO are_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Anma Altjirrala pmararinya ntjarranha unpuka. Joshua-alantama kaarta nurnakanha ntjarranha pmara ekururna rretjingaka. Etna Altjirraka tent turta etnakalela kngaka. Tent era turta pmara ekurala naka, David-anha king erritjinalpula. ");
INSERT INTO are_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Altjirranha David-aka kangkaka. David-anhantama Altjirrurna ingkaka ekura iltha ititjika. ");
INSERT INTO are_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kanha Solomon-alala Altjirraka iltha itaka. ");
INSERT INTO are_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Altjirra Kngarra Era pula itja ilthala nanhananha, iltha nhanga relhalala itakalala. Altjirraka urrpia imankinyala nhanga ilama, ");
INSERT INTO are_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Alkira era chair kngarritja nukanha nama, atha turta ingka nukanha alhaka arrarnama, Ingkartanha angkama. Iltha iwunha ngerrantama rrangkarra nuka itamara, yinga paka iltjerritjika?’ ");
INSERT INTO are_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Arai, atharrpa kunha alkiralka, alhalka ingkarraka arrpmarnakala.’ ");
INSERT INTO are_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Rrangkarrataka relha arrthatanta ingkarraka. Rrangkarra ilpa marnta, kangkwerrintja marnta turta nama. Rrangkarra kunha Enka Alkngaltaranga kekarta kuta lhama, kaarta rrakangkarranhala kekarta lhakala ngerra. ");
INSERT INTO are_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kaarta rrakangkarranha kunha Altjirraka urrpia imankinya ingkarrakaka antjakunya ntelalhaka. Etna turta Altjirraka urrpia lenha ntjarranha errilknga tuka, etnala relha ntjarranha ilakala Artwa Arratja Era pitjitjinala. Kurunga ngurrukalkura rrangkarrantama Artwa Arratja erinha leltjaka lanthamala errilknga tuka. ");
INSERT INTO are_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Rrangkarra kunha lakinha ntelalhaka, rrangkarra Altjirraka turnintja tnyinamangatanya. Turnintja nhanha etnanha kunha, Altjirrala Moses-anha ilakala, angel ntjarrarlarlanga. Rrangkarra pula turnintja etnaka itjarrpala kangkwerraka.” ");
INSERT INTO are_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stephen-aka angkatjala etnanha tjalka tuka inthorra. Sanhedrin council etnantama ekura yirrknga inthorrerraka. ");
INSERT INTO are_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stephen-anha Enka Alkngaltarakarta naka. Stephen-alantama alkirurnathaka inaramalanga, era Altjirra makalaria erinha araka, Jesuanha turta akwampinya ekuranhala itnamanga. ");
INSERT INTO are_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stephen-alantama etnanha ilaka, “Arai, atha alkira erinha altjurerrakala arama, Relhaka 'Lira erinha turta Altjirraka akwampinyala itnamanga.” ");
INSERT INTO are_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nhanha wumala etna ingkarraka ilkaka, ilpa etnakanha turta marntilaka. Kurunga Stephen-urna arrtjanamala, etna erinha errkuka, ");
INSERT INTO are_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","erinha Jerusalem-anga kathurna turta tjarrakngaka. Kurunga etna erinha partala waka. Artwa lenha ntjarra, etnala Stephen-anha ilparnakala, etna mantarra tjenya etnakanha ilumala, artwa nthitja nyintanha nthaka, ntarntaritjika. Nthitja ekura rretnya naka Saul. ");
INSERT INTO are_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Etna Stephen-anha partala wamalanga, Stephen-anha Altjirrurnala ingkaka. Era ingkaka, “Ingkarta Jesuai, yinga ilumanga unta enka nukanha inai.” ");
INSERT INTO are_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mparalelantama arrarnalhamala, era ilkaka, “Ingkartai, unta etnanha itja nhanhakakwia ilparnitjika.” Lakinha angkamala, era kala iluka. ");
INSERT INTO are_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul-ala araka etna Stephen-anha errilknga tumanga. Era turta nhanhaka kangkaka. Stephen-anha errilknga tumaliperra, etna worlamparinyaka turtantama antjakunyerraka, etnanha tutjika lurnaka turta. Lakinhanga tnakanhakanha ntjarra Jerusalem-anga tira lhaka pmara Judea-urna, pmara Samaria-urna turta. Apostle ntjarrantantama Jerusalem-ala kuterraka. ");
INSERT INTO are_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Artwa ilporatha urrputjalantama Stephen-aka mpurrka inarlalhamala, erinha arratja tintjiwuka. Etna turta ekura kngarra nthorrkngerraka. ");
INSERT INTO are_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saul-anha antja naka worlamparinya etnanha yirralhelitjika. Erantama iltha nyintanga, iltha arrpunhurna lhaka. Era relha tnakanhakanha arltaramanga, artwa paka, arrkutja paka, era etnanha kala jail-akanta kurnaka. ");
INSERT INTO are_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tnakanhakanha etnantama Jerusalem-anga tira lhaka, pmara arrpunhurna. Pmara nhanhalantama etna pmararinya ntjarranha kaltjinthaka, yia Jesuiperra. ");
INSERT INTO are_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip-anha town nyinturna lhaka, pmara Samaria-ala. Erantama relha lenha ntjarranha kaltjinthaka Jesuanha Altjirraka Krista namanga. ");
INSERT INTO are_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Relha town-arinya etna Philip-aka angkatja wuka. Etna tjatjikarta etnanha turta araka, Philip-alala urrkapukala. Etnantama angkatja ekuranhaka kangkwerraka. ");
INSERT INTO are_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Etna araka era relha enka kornakarta ntjarranha marrilamanga. Etna araka enka korna etna turta relha menta etnakanga rratamanga, ilkintja kngarrakarta. Etna araka era relha thaarra ntjarranha, inurra ntjarranha turta marrilamanga. ");
INSERT INTO are_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Lakinhanga town-arinya etna arrkana inthorra naka. ");
INSERT INTO are_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Town nhanhala artwa arrpunha naka, rretnya ekura Simon. Era relha Samaria-arinya ingkarrakanha tnolkalhelitjata, ngangkara iwumala. Erantama tnakalhaka inthorra. ");
INSERT INTO are_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Relha ingkarrakala erinha tnakitjatantema, relha kornakorna ntjarrala, itornka ntjarrala turta. Etna angkitjata, “Erarrpa altjirra ngerra nama, ekarlta inthorra turta.” ");
INSERT INTO are_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Etna Simon-anha tnakitjata, era etnanha kuta inthorra tnolkalhelakalanga, ngangkara iwumala. ");
INSERT INTO are_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Philip-alantama town-arinya ntjarranha Yia Marra erinha kaltjinthaka. Era turta etnanha kaltjinthaka Altjirranha relha ingkarrakaka Ingkarta namanga. Era etnanha Jesua Kristiperra turta ilaka. Artwa pa arrkutja turtantama Philip-urna pitjika, era etnanha kaltjirrpulhelitjika. ");
INSERT INTO are_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon era turta Altjirranha tnakakantema. Era turtantama pitjika Philip-ala erinha kaltjirrpulhelitjika. Kurunga era Philip-alela porta nthulaputjata. Era kngarra tnolkaka era Philip-anha aramalanga tjatjikarta urrkapumanga. ");
INSERT INTO are_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusalem-ala, apostle ntjarrala wuka relha Samaria-arinya ntjarrala Altjirraka angkatja tnakamanga. Lakinhanga etna Peter John tharranha etnakurna yairnaka. ");
INSERT INTO are_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Samaria-akerritjalhamala, eratharra Altjirrurna ingkaka era Enka Alkngaltara erinha tnakanhakanha ntjarrurna yairnitjika. ");
INSERT INTO are_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Enka Alkngaltara erataka itjantema tnakanhakanha etnakurna irrpukala. Philip-alataka tnakanhakanha ntjarranha kaltjirrpulhelakalanta, Ingkarta Jesuaka rretnyala. ");
INSERT INTO are_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Peter tharralantama iltja kapurta etnakanhaka arrarnaka. Enka Alkngaltara era turtantama etnakurna irrpuka. ");
INSERT INTO are_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon-ala araka apostle eratharra iltja relha ntjarraka kapurtaka arrarnamanga. Enka era turtantama relha etnakurna irrpumanga. Erantama Peter tharranha money nthitjika antja naka. ");
INSERT INTO are_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Era lakinha angkaka, “Yinganha ekarltilai, atha turta iltja nukanha relhaka arrarnamanga, Enka Alkngaltara era relha etnakurna irrputjinanga.” ");
INSERT INTO are_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Peter-ala pula erinha ilaka, “Unta etarlarama unta Altjirraka yearriperra money-ala buy-emilitjinala. Itjanga lhai! Altjirrala nganha imileikanha, money ungkwanganha turta. ");
INSERT INTO are_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Untataka Altjirriperra paalakarla kuta eterrama. Lakinhanga unta yarna nurnakalela porta Altjirraka urrkapuma. ");
INSERT INTO are_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kala kornanga topanterrai. Ingkarturna turta ingkai eterrintja korna ungkwanganha arratjilitjika, korna ungkwanganha iwutjika turta. ");
INSERT INTO are_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yingataka kaltja unta tjaiya paalala kuta lhamanga, kornaka kuta lherramanga turta.” ");
INSERT INTO are_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon-alantama Peter tharranha ilaka, “Nukakwia Ingkarturna ingkai, era yinganha nthurrpa imilakitja, mpala yinganha ilakala ngerra.” ");
INSERT INTO are_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Peter tharrala relha ntjarranha Ingkartaka angkatja wotha kaltjinthaka. Kurunga eratharra Jerusalem-urna alpurraka. Pmara Samaria ekuranga tjananhamala, eratharra town kurrka ntjarrurna lhaka, relha ntjarranha Yia Marra erinha kaltjinthaka turta. ");
INSERT INTO are_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Altjirraka angel-alantama Philip-anha ilaka, “Ntakarra lhai, tjaiya nhangurna, erala worritjala intanhama Jerusalem-anga Gaza-urna.” ");
INSERT INTO are_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Philip-anha kala lhaka. Erantama artwa orrea Ethiopia-arinya araka, chariot ekuranhala nanhamanga. Artwa nhanha erataka Ethiopia-arinya queen Candace-aka urrkapunhapunha naka. Era turta queen ekuranha money ingkarraka ntarntaritjata. Artwa nhanha erataka Jerusalem-urna lhakala, Altjirraka urrkurrkintja nitjika. ");
INSERT INTO are_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Erantama nhanha wotha pmarurna alpupalpuka. Chariot ekuranhala nanhamala era Altjirraka urrpia Isaiah-aka pepaka read-erralanaka. ");
INSERT INTO are_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Altjirraka Enkalantama Philip-anha ilaka, “Etinyerramala, chariot ekuranga kuta lhapalhai.” ");
INSERT INTO are_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Chariot ekururna arrtjanamala, Philip-ala artwa erinha wuka Altjirraka urrpia Isaiah-aka pepanga read-erramanga. Erantama erinha pmarraka, “Unta angkatja nhanha lhangkaramama?” ");
INSERT INTO are_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Artwa Ethiopia-arinya era pula erinha ilaka, “Nthakinhantama atha angkatja nhanha lhangkaramara? Relha arrpunhala itja angkatja nhanha nuka nentilaka.” Erantama Philip-anha ntangkaka, “Ntjentjai, nukalela nitjika.” ");
INSERT INTO are_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Artwa orrea erataka angkatja nhanhaka read-erralanaka, “Relhalala sheep errilknga tutjika kngamanga ngerra, lakinha ngerra etna erinha turta tutjika kngaka. Sheep kurrka pmarna intamanga ngerra etna ponga ekuranha kamanga, lakinha ngerra era turta itja angkaka, ilkaka paka. ");
INSERT INTO are_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Etna erinha ilparnamalanga, itja nyinta ekurakwia angkaka. Ekura ramarama itja nitjina, etna erinha errilknga tukalanga.” ");
INSERT INTO are_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Artwa orrea erantama Philip-anha pmarraka, “Yinganha ilai, relha ngunhiperrama Altjirraka urrpia era angkama? Ekurarinya? Relha arrpunhiperra paka?” ");
INSERT INTO are_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kurunga Philip-ala Altjirraka urrpia Isaiah-aka angkatja nhanharrka ekura nentilaka. Kurunga era erinha Yia Marra Jesuiperra turta kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Etna tjaiyala lhapalhamalangantema, etna kwatja araka. Artwa orrea erantama Philip-anha pmarraka, “Arai, nhanha kwatja intama. Unta paka yinganha kaltjirrpulhelamarama?” ");
INSERT INTO are_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Artwa erantama chariot driver ekuranha turnaka, “Chariot erinha ingkairnai!” Kurunga Philip eratharra kwatja ekururna tnanpuka. Philip-ala turtantama erinha kaltjirrpulhelaka. ");
INSERT INTO are_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Eratharra warta kwatjanga rrataka, kanha Ingkartaka Enkala Philip-anha naamalhelakala. Artwa orrea-ala turta erinha itja wotha araka. Era pula pmara ekuranhurna arrkana inthorra alpupalpuka. ");
INSERT INTO are_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Relha ntjarrala pula Philip-anha pmara Azotus-akantama araka. Philip erantama town nyintanga town arrpunhurna lhaka, Caesarea-akurtitja. Era relha ntjarranha Yia Marra erinha kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saul-anha kuta thakerraka Ingkartaka kurtungurla ntjarranha yirralhelitjika. Erantama High Priest-urna lhaka. ");
INSERT INTO are_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Era erinha ilaka, “Nuka pepa intalhelai, synagogue itornka ntjarraka, Damascus town-ala.” Erataka antja naka Damascus-urna lhitjika, synagogue nyintaminyinturna turta irrputjika, relha Jesuanha tnakamala ntjarraka yonthitjika, artwaka, arrkutjaka turta. Kurunga era antja naka tnakanhakanha etnanha errkumala Jerusalem-urna kngetnitjika. ");
INSERT INTO are_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Era kala Damascus-aka etinyerrakalangantama, parrtja kngarrala erinha alkiranga parrtjilhelaka. ");
INSERT INTO are_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saul-anhantama arnakarlaka tnyika. Erantama wuka erinha ntangkamanga, “Saul-ai, Saul-ai, iwunhangama unta yinganha tutjika lurnama?” ");
INSERT INTO are_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nhanha wumala Saul-anha angkaka, “Ingkartai, ngunhama unta?” Era erinha alpmelaka, “Yinga kunha Jesua, relha untala tutjika lurnama. ");
INSERT INTO are_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kala kamerrai, town-urna turta lhai. Artwa nyintalantama nganha angkatja arrpunha nukanha ilitjina.” ");
INSERT INTO are_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Artwa etnala Saul-alela ilkwatharra lhakala, etna pula angkatjakunyala itnarlanaka. Etna kala wuka arrpunha angkamanga, etna pula relha itja araka. ");
INSERT INTO are_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul-anhantama kamerraka. Era alknga ekuranha altjurilaka, era pula panga naka. Artwa etnantama erinha Damascus-urna rretjingaka. ");
INSERT INTO are_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Arlta tharraminyintantama era alknga panga naka. Era itja marna ilkuka, kwatja paka ntjuka. ");
INSERT INTO are_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascus ekurala Jesuaka kurtungurla arrpunha naka, rretnya ekura Ananias. Ingkartalantama erinha ntangkaka era altjirraramalanga, “Ananias-ai.” Ananias era angkaka, “Iwunha Ingkartai?” ");
INSERT INTO are_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ingkartalantama erinha ilaka, “Tjaiya nhangurna lhai, rretnya ekura Tjaiya Arratja. Kurunga Judas-aka ilthakerramala, unta Judas-anha Saul-aka pmarrai, artwa Tarsus-arinyaka. Saul erataka nukurna ingkarlanama. ");
INSERT INTO are_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Era lyarta altjirraraka. Era artwa araka ekururna pitjimanga, rretnya Ananias. Era turta araka Ananias-ala iltja ekuranha kapurta ekuranhaka arrarnamanga, alknga ekuranha turta wotha marrerramanga.” ");
INSERT INTO are_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias-ala pula erinha alpmelaka, “Ingkartai, athataka yia kngarra inthorra artwa nhanhiperra wukala. Erataka Jerusalem-ala relha alkngaltara ungkwanganha ntjarranha lurnamala tuka. ");
INSERT INTO are_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Era turta nhanhurna pitjikala priest itornka ntjarraka pepakarta, relha nganha tnakamala ntjarranha errkutjika.” ");
INSERT INTO are_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ingkartala pula erinha ilaka, “Kala lhalathanai. Atharrpataka artwa nhanha erinha urrarakala. Atha erinha yairnitjina Relha Lorinya ntjarrurna, king ntjarrurna, relha Israel-arinya ntjarrurna turta, era etnanha nukiperra kaltjinthitjika. ");
INSERT INTO are_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Era turtantama nuka kngarra nyingalauwutjina.” ");
INSERT INTO are_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananias-anha kala lhaka. Judas-aka ilthakerramala, era irrpunhaka. Iltja ekuranha Saul-aka kapurtaka arrarnamala, era erinha ilaka, “Saul, tjina nukai, Ingkarta Jesua, erala ungkwangurna rumerrakala unta tjaiyala pitjimanga, era yinganha ungkwangurna yairnaka. Era nukarlarlanga alknga ungkwanganha marrilitjina, Enka Alkngaltara erinha turta ungkwangurna yairnitjina.” ");
INSERT INTO are_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kurunga Saul-aka alknganga irrtnya ngerrantama tnyika, era turta wotha araka. Era kala kamerraka. Kurunga Ananias-ala erinha kaltjirrpulhelaka. ");
INSERT INTO are_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kurunga Saul-ala wotha marna ilkuka, ekarlterraka turta. Saul-anhantama arlta urrputja kurtungurla ntjarralelarrka kuterraka, Damascus-ala. ");
INSERT INTO are_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kurunga era synagogue ntjarrurna lhaka, relha Jew ntjarranha turta ilaka Jesua era nthurrpa Altjirraka 'Lira namanga. ");
INSERT INTO are_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Relha etna angkatja ekuranha wumalanga, etna tnolkaka. Etna ilarraka, “Artwa nhanhala kunha Jesuaka tnakanhakanha ntjarranha Jerusalem-ala lurnamala tuka. Era turta nhanhurna pitjikala tnakanhakanha ntjarranha errkutjika. Era turta etnanha priest-aka itornka ntjarrurna kngetnitjika nakala.” ");
INSERT INTO are_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Enka Alkngaltarala pula Saul-aka angkatja ekarltilakala. Jew Damascus-arinya ntjarralantama erinha yarna kuta ilpoiwuka, era etnanha ilamanga Jesuanha nthurrpa Altjirraka Krista era namanga. ");
INSERT INTO are_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Anmantama, relha Jew ntjarra angkarraka erinha errilknga tutjika. ");
INSERT INTO are_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saul-ala turta nhanhiperra wukantema. Relha Jew ntjarralantama town-aka reoa etnanha arltala pa ingwala kaaraka. Etna antja naka erinha errkumala errilknga tutjika. ");
INSERT INTO are_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kurunga ingwa arrpunhala Saul-aka tjina ntjarrala erinha basket-aka arrarnamala, erinha rope-ala wall-anga kathaka tnanpulhelaka. ");
INSERT INTO are_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul-anhantama Jerusalem-urna lhaka. Era antja naka kurtungurla ntjarraka lhangalhitjika. Etna pula ekuranga trerraka. Etna erinha ilpoiwuka era ilalhamanga, era Jesuaka kurtungurlantama namanga. ");
INSERT INTO are_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas-alantama erinha apostle ntjarrurna kngaka. Erantama apostle etnaka alpmelaka, Saul-ala Ingkartanha arakala, era Damascus-urna lhamalanga. Ingkartanha turta Saul-urna angkakala. Era etnanha ilaka turta Saul-ala relha ntjarranha Jesuiperra tnoatnoa kaltjinthakala, Damascus-ala. ");
INSERT INTO are_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saul-anha kala kurtungurla ntjarralelantama kuterraka. Era kunpa Jerusalem-ala nthulapuka, relha ntjarranha turta tnoatnoa Ingkarta Jesuiperra kaltjinthaka. ");
INSERT INTO are_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Era relha Jew epinya ntjarralela turta iwurrakantema, Jew nhanga pmara Greece-ala alkngerrakala ntjarralela. Etna pula antja naka erinha errilknga tutjika. ");
INSERT INTO are_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tjina tnakanhakanha ntjarrala nhanhiperra wumalanga, etna erinha Caesarea town-urna kngamala, Tarsus town-urna yairnaka. ");
INSERT INTO are_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nhanhiperra relha Jew ntjarra kala worlamparinya etnaka rilherantama ntelalhaka. Worlamparinya etnaka purrama, etnala pmara Judea-ala namanga, pmara Galilee-ala namanga, pmara Samaria-ala namanga turta. Enka Alkngaltarala worlamparinya etnanha ekarltilaka, tnoatnoilaka turta. Altjirrala turta worlamparinya etnaka relha arrpunha lhangaka. Worlamparinya etna turta Ingkartanha kuta arratja etarlaramala naka. ");
INSERT INTO are_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Anma Peter-anhantama town ntjarrurna lhaka, relha ntjarralela yatjarra nitjika. Erantama Lydda town-urna turta pitjika, relha alkngaltara ntjarralela yatjarra narlalputjika. ");
INSERT INTO are_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Town nhanhala artwa thaarra naka, rretnya ekura Aeneas. Era kala 8 years ntjama ekuranhala intakala. ");
INSERT INTO are_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Erinha aramala, Peter-ala erinha ilaka, “Aeneas-ai, Jesua Kristala nganha marrilama. Kala kamerrai, ntjama ungkwanganha turta ilinyatwai.” Aeneas-anha kala kamerrakanta. ");
INSERT INTO are_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Relha Lydda town-arinya ntjarrala, pmara Sharon-arinya ntjarrala turta nhanha aramalanga, etna Ingkartanha tnakaka. ");
INSERT INTO are_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa town-ala kurtungurla marla naka, rretnya Tabitha. (Greek angkatjala etna erinha Dorcas-ala alpmelitjata.) Arrkutja nhanha erataka relha ingkarrakaka kangkintja ntelalhitjata, era turta relha ilkngara ntjarranha marnala, mantarrala turta wantitjata. ");
INSERT INTO are_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tabitha erantama menterramala iluka. Tjina ekuranhalantama mpurrka ekuranha ilkngika, mpurrka ekuranha room-aka arrarnaka turta. Room nhanha iltha kartninyala italhaka. ");
INSERT INTO are_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lydda-anhataka Joppa-anga etinya wara naka. Kurtungurla ntjarrala wumalanga Peter-anha Lydda-ala namanga, etna artwa tharra urrpia yairnaka Peter-anha ntangkitjika, “Parrpa pitjai!” ");
INSERT INTO are_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Peter-anha kala urrpia ekuratharralela lhakanta. Joppa-akerritjalhamala, urrpia etna Peter-anha room nhangurna kngaka, ekuralala errilknga era intamanga. Warlukurta ntjarra room ekurala naka. Kngarra itnimala, etna Peter-anha ntelaka mantarralka Dorcas-alala thanthakala, era nhanga etathantema namalanga. ");
INSERT INTO are_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter-alantama relha ingkarraka room-anga tnauwuka. Mparalelantama arrarnalhamala, era Altjirrurna ingkaka. Kurunga era arrkutja errilknga erinha ilaka, “Tabitha, kala kamerrai!” Tabitha erantama alkngampuka. Peter-anha aramala, era kamerramala, ntjamala naka. ");
INSERT INTO are_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peter-alantama erinha iltjanga errkumala, ingkaka ingkairnaka. Kurunga Peter-anha relha alkngaltara ntjarraka, warlukurta ntjarraka turta ntangkalhaka. Etna araka Tabitha era etathantama namanga. ");
INSERT INTO are_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Relha Joppa-arinya ingkarrakala nhanhiperra wuka. Ntjarrala turtantama Ingkartanha tnakaka. ");
INSERT INTO are_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter-anha Joppa-alarrkantama kuterraka, artwa Simon-alela. Simon nhanha era leather mpaaritjata. ");
INSERT INTO are_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Caesarea town-ala artwa arrpunha naka, rretnya ekura Cornelius. Era tjapartia 100-aka itornka naka. Tjapartia etna rretnya ‘Italy-arinya’ naka. ");
INSERT INTO are_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelius era artwa ilporatha naka. Era Altjirriperra arratja etarlaritjata. Era relha ilkngaranha ntarntaritjata, kutatha Altjirrurna ingkitjata turta. Noa ekuranha, katjia ekuranha, urrkapunhapunha ekuranha ntjarra turta, etna relha ilporathantema naka. Etna turta Altjirriperra arratja etarlaritjata. Etna pula itja relha Jew naka. ");
INSERT INTO are_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Arlta arrpunhalantama, 3 o'clock-ala ngerra, Cornelius-ala altjirraraka. Era katha inthorra Altjirraka angel araka. Angel era etinyerramala erinha ntangkaka, “Cornelius-ai.” ");
INSERT INTO are_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Enkakunyerramala, Cornelius-ala erinha yapmakarrka. Kurunga era angel erinha pmarraka, “Iwunha itornkai?” Angel erantama erinha ilaka, “Arai, Altjirrala araka unta relha ilkngara ntjarranha pelamanga, era turta nganha wuka unta ekururna ingkamanga. ");
INSERT INTO are_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Untantama lyartantema urrpia yairnai Joppa-urna, Simon-anha ntangkitjika. Simon nhanha ekurataka rretnya arrpunha nama Peter. ");
INSERT INTO are_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Era lyarta kala Joppa-ala nama artwa Simon arrpunhalela. Simon nhanha leather mpaaranhampaaranha nama. Simon arrpunha nhanha ekura iltha turta kwatja laiyanga kutala italhama.” ");
INSERT INTO are_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Lakinha angkamala, angel era kala alpuka. Cornelius-anhantama urrkapunhapunha tharraka ntangkalhaka, tjapartia nyintaka turta. Tjapartia nhanha era Cornelius-aka mantarra, errauwialka ntarntaritjata, erarrpa turta artwa ilporatha naka. ");
INSERT INTO are_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Cornelius-alantama artwa nhanha etnaka angel-aka angkatja ingkarraka alpmelaka. Kurunga era etnanha Joppa-urna yairnaka. ");
INSERT INTO are_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Arlta arrpunhala, ngkinyala, Cornelius-aka urrpia etna kala Joppa-aka etinyerrakantama. Etna pula pitjimalangantema, Peter-anha iltha kaputhaka ntjika, Altjirrurna ingkitjika. ");
INSERT INTO are_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Erantama ngaiyalerraka, era marna ilkutjika turta antja naka. Etna pula ekura marna mpaaramalangantema, era altjirraraka. ");
INSERT INTO are_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Era araka alkira era altjura namanga, angel 4-ala turta irna blanket ngerra alkiranga arnurna ilulhelamanga. ");
INSERT INTO are_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Irna ekurala tnontha twetakatweta etna naka, lhungkultja itnirrakalapunha, thepa etnalka. ");
INSERT INTO are_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Erantama wuka erinha turnamanga, “Peter-ai, kamerrai, kara tumala ilkwai!” ");
INSERT INTO are_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peter-ala pula erinha alpmelaka, “Itja lakinha Ingkartai. Atha itja arrkurla kara untala parrakala ilkuka paka.” ");
INSERT INTO are_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Erantama wotha wuka erinha ilamanga, “Arai, Altjirrala paka nganha ilamanga nhanha kala marrantama namanga, unta itja angkitjika nhanha korna kuta namanga.” ");
INSERT INTO are_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tharraminyintaranga lakinherraka. Kurunga angel etna irna erinha wotha alkirurna kngetnaka. ");
INSERT INTO are_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peter-anha nhanhiperra yarna eterraka. Era yarna eterramalangantema artwa nhanga ntjarra, etnanhala Cornelius-ala yairnakala, etna Simon-aka ilthaka yonthaka. Iltha erinha arltaramala, etna reoala itnaka. ");
INSERT INTO are_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Etnantama ilkaka, “Simon, rretnya arrpunha ekura Peter, era paka iltha nhanhala namama?” ");
INSERT INTO are_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter-anha pula yarna kuta eterraka, nhanga erala arakala ekuriperra. Enka Alkngaltaralantama erinha ilaka, “Arai, artwa urrputjalataka ungkwanga yonthama. ");
INSERT INTO are_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kamerramala etnakurna tnanpai, etnakalela turta lhai. Atha kunha etnanha ungkwangurna yairnakala.” ");
INSERT INTO are_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Artwa etnakurna tnanpumala, Peter-ala etnanha ilaka, “Arai, yinga kunha artwa era, ekurala rrangkarra yonthama. Iwukama rrangkarra pitjika?” ");
INSERT INTO are_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Artwa etna erinha alpmelaka, “Cornelius, erala itornka nama tjapartia ntjarraka, era nurnanha yairnaka. Relha Jew ingkarraka kaltja era artwa ilporatha namanga. Era turta Altjirriperra arratja etarlarama. Ngurruka Altjirraka angel ekururna pitjika, erinha turnaka turta ungkwanga ntangkalhitjika, nganha wutjika turta.” ");
INSERT INTO are_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peter-alantama etnanha ilaka ingwa nyintarrka intitjika. Ingutnhalantama Peter-anha artwa etnakalela tjaiyakerraka. Artwa tnakanhakanha urrputja Joppa-arinya turta etnakalela ilkwatharra lhakantema. ");
INSERT INTO are_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kala arlta arrpunhalantama etna Caesarea town-akerritjalhaka. Nhanhala Cornelius-anha kala etnaka kaaralhaka, tjina ekuranha ingkarrakakarta. ");
INSERT INTO are_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peter-anha warta Cornelius-aka ilthaka irrpunhaka, kanha Cornelius-anha mparalelala arrarnalhaka, ekura urrkurrkintja nitjika. ");
INSERT INTO are_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Peter-ala pula erinha ilaka, “Itja lakinha. Kamerrai! Arai, yinga kunha relha unta ngerrantema.” ");
INSERT INTO are_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Cornelius ekuralela kuta angkarramala, Peter-anha iltha kwanurnantama irrpunhaka. Era worla kngarra araka. ");
INSERT INTO are_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Era etnanha ilaka, “Rrangkarra kala kaltja relha Jew kunha yarna Relha Lorinyalela ilkwatharra nama, yatjarra paka. Altjirrala pula yinganha ngurruka wara ilaka yinga itja Relha Lorinyanga mukunherritjika. ");
INSERT INTO are_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Lakinhanga yinga kala pitjikanta Cornelius-ala yinganha ntangkamalanga. Kalantama yinganha ilai, Iwukama rrangkarra yinganha ntangkaka?” ");
INSERT INTO are_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius-a