﻿USE sofia;
DROP TABLE IF EXISTS sofia.arbwbtc_vpl;
CREATE TABLE arbwbtc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES arbwbtc_vpl WRITE;
INSERT INTO arbwbtc_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","فِي البَدءِ خَلَقَ اللهُ السَّماواتِ وَالأرْضَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","كانَتِ الأرْضُ قاحِلَةً وَفارِغَةً. وَكانَ الظَّلامُ يَلُفُّ المُحِيطَ، وَرُوحُ اللهِ تُحَوِّمُ فَوقَ المِياهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","فِي ذَلِكَ الوَقتِ، قالَ اللهُ: «لِيَكُنْ نُورٌ.» فَصَارَ نُورٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","وَرَأى اللهُ أنَّ النُّورَ حَسَنٌ. ثُمَّ فَصَلَ اللهُ النُّورَ عَنِ الظَّلامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","وَسَمَّى النُّورَ «نَهاراً» وَسَمَّى الظَّلامَ «لَيلاً.» وَكانَ مَساءٌ، ثُمَّ صَباحٌ. فَكانَ هَذا اليَوْمَ الأوَّلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ثُمَّ قالَ اللهُ: «لِتَكُنْ قُبَّةٌ بَينَ المِياهِ لِتَقسِمَ المِياهَ إلَى قِسْمَينِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","فَخَلَقَ اللهُ قُبَّةَ السَّماءِ. وَفَصَلَ المِياهَ الَّتِي تَحْتَ القُبَّةِ عَنِ المِياهِ الَّتِي فَوقَها. وَهَكَذا كانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","وَسَمَّى اللهُ القُبَّةَ «سَماءً.» وَكانَ مَساءٌ، ثُمَّ صَباحٌ. فَكانَ هَذا اليَوْمَ الثّانِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ثُمَّ قالَ اللهُ: «لِتُجْمَعِ المِياهُ اللَّتِي تَحْتَ السَّماءِ مَعاً فِي مَكانٍ واحِدٍ، لِكَي تَظْهَرَ اليابِسَةُ.» وَهَكَذا كانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","وَسَمَّى اللهُ اليابِسَةَ «أرْضاً،» وَسَمَّى مَكانَ تَجَمُّعِ المِياهِ «بِحاراً.» وَرَأى اللهُ أنَّ ما خَلَقَهُ حَسَنٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ثُمَّ قالَ اللهُ: «لِتَخْضَرَّ الأرْضُ بِالعُشْبِ وَالنَّباتاتِ ذاتِ البُذُورِ. وَلْتَكُنْ أشْجارٌ مُثْمِرَةٌ تَحمِلُ ثِماراً ذاتَ بُذُورٍ مِنْ نَوْعِها عَلَى الأرْضِ.» وَهَكَذا كانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","فَأخْرَجَتِ الأرْضُ عُشْباً وَنَباتاتٍ تَحْمِلُ ثِماراً ذاتَ بُذُورٍ مِنْ نَوْعِها. وَأخْرَجَتْ أشْجاراً تَحْمِلُ ثِماراً ذاتَ بُذُورٍ مِنْ نَوْعِها. وَرَأى اللهُ أنَّ ما خَلَقَهُ حَسَنٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","وَكانَ مَساءٌ، ثُمَّ كانَ صَباحٌ. فَكانَ هَذا اليَوْمَ الثّالِثَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ثُمَّ قالَ اللهُ: «لِتَكُنْ أنْوارٌ فِي قُبَّةِ السَّماءِ، لِكَي تُمَيِّزَ النَّهارَ مِنَ اللَّيلِ وَتَكُونَ عَلاماتٍ لِتَحْدِيدِ المَواسِمِ وَالأيّامِ وَالسِّنِينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","وَتَكُونَ أنْواراً فِي قُبَّةِ السَّماءِ لِتُضِيءَ عَلَى الأرْضِ.» وَهَكَذا كانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","فَخَلَقَ اللهُ النُّورَينِ العَظِيمَينْ. خَلَقَ النُّورَ الأكْبَرَ لِيَضْبُطَ النَّهارَ، وَخَلَقَ النُّورَ الأصْغَرَ لِيَضْبُطَ الَّليلَ. وَخَلَقَ اللهُ النُّجُومَ أيضاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","وَوَضَعَ اللهُ هَذِهِ الأنْوارَ فِي قُبَّةِ السَّماءِ لِتُضِيءَ عَلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","كَما قَصَدَ لَها اللهُ أنْ تَضْبُطَ النَّهارَ وَالَّليلَ، وَأنْ تُمَيِّزَ النُّورَ مِنَ الظَّلامِ. وَرَأى اللهُ أنَّ ما خَلَقَهُ حَسَنٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","فَكانَ مَساءٌ، ثُمَّ كانَ صَباحٌ. فَكانَ هَذا اليَوْمَ الرّابِعَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ثُمَّ قالَ اللهُ: «لِتَمْتَلِئِ المِياهُ بِمَخلُوقاتٍ حَيَّةٍ كَثِيرَةٍ. وَلْتَكُنْ هُناكَ طُيُورٌ تَطِيرُ فَوْقَ الأرْضِ عَبْرَ السَّماءِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","فَخَلَقَ اللهُ وُحُوشَ البَحْرِ الضَّخْمَةِ. كّمّا خَلَقَ جَمِيعَ المَخلُوقاتِ الحَيَّةِ الَّتِي تَفِيضُ بِها المِياهُ. خَلَقَها مِنْ كُلِّ نَوْعٍ. كَما خَلَقَ كُلَّ طائِرٍ مُجَنَّحٍ مِنْ كُلِّ نَوْعٍ. وَنَظَرَ اللهُ إلَى ذَلِكَ بِرِضىً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","وَبارَكَها اللهُ فَقالَ: «أثْمِرِي وَتَكاثَرْي وَاملأي مِياهَ البَحْرِ بِالمَخلُوقاتِ. وَلِتَتَكاثَرِ الطُّيُورُ عَلَى الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","فَكانَ مَساءٌ، ثُمَّ كانَ صَباحٌ. فَكانَ هَذا اليَوْمَ الخامِسَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ثُمَّ قالَ اللهُ: «لِتُخْرِجِ الأرْضُ مَخلُوقاتٍ حَيَّةً مِنْ كُلِّ نَوْعٍ: مَواشِيَ وَزَواحِفَ وَحَيواناتٍ بَرِّيَّةً مِنْ كُلِّ نَوْعٍ.» وَهَكَذا كانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","فَخَلَقَ اللهُ الحَيواناتِ البَرِّيَةَ مِنْ كُلِّ نَوْعٍ، وَالمَواشِيَ مِنْ كُلِّ نَوْعٍ، وَكُلَّ حَيوانٍ زاحِفٍ عَلَى الأرْضِ مِنْ كُلِّ نَوْعٍ. وَرَأى اللهُ أنَّ كُلَّ ما خَلَقَهُ حَسَنٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ثُمَّ قالَ اللهُ: «لِنَخلِقِ النّاسَ عَلَى صُورَتِنا وَكَمِثالِنا. وَلْيَسُودوا عَلَى سَمَكِ البَحْرِ وَطُيُورِ السَّماءِ وَالمَواشِي وَالحَيَواناتِ البَرِّيَّةِ عَلَى الأرْضِ وَعَلَى كُلِّ زاحِفٍ يَزْحَفُ عَلَى الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","فَخَلَقَ اللهُ النّاسَ عَلَى صُورَتِهِ. عَلَى صُورَتِهِ خَلَقَهُمْ ذَكَراً وَأُنْثَى. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","وَبارَكَهُمُ اللهُ فَقالَ: «أثْمِرُوا وَتَكاثَرُوا. املأُوا الأرْضَ وَأخضِعُوها. سُودُوا عَلَى سَمَكِ البَحْرِ وَطُيُورِ السَّماءِ وَكُلِّ ما يَتَحَرَّكُ عَلَى الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","وَقالَ اللهُ: «ها قَدْ أعطَيتُكُمْ كُلَّ نَباتٍ عَلَى وَجْهِ الأرْضِ يَحْمِلُ بُذُوراً. وَأعْطَيتُكُمْ كُلَّ شَجَرَةٍ مُثْمِرَةٍ ذاتَ بُذُورٍ لِتَكُونَ لَكُمْ طَعاماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","أمّا جَمِيعُ حَيواناتِ الأرْضِ، وَجَمِيعُ طُيُورِ السَّماءِ، وَجَمِيعُ الحَيواناتِ الصَّغِيرَةِ الزّاحِفَةِ الَّتِي فِيها حَياةٌ، فَيَكُونُ النَّباتُ الأخْضَرُ طَعامَها.» وَهَكَذا كانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","وَرَأى اللهُ أنَّ كُلَّ ما خَلَقَهُ حَسَنٌ جِدّاً. وَكانَ مَساءٌ ثُمَّ كانَ صَباحٌ. فَكانَ هَذا اليَوْمَ السّادِسَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","وَهَكَذا أُكْمِلَتِ السَّماواتُ وَالأرْضُ وَكُلُّ ما فِيهِا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","وَفِي اليَوْمِ السّابِعِ، فَرَغَ اللهُ مِنْ عَمَلِهِ الَّذِي أنجَزَهُ. وَفِي اليَوْمِ السّابِعِ اسْتَراحَ مِنْ كُلِّ عَمَلِهِ الَّذِي أنجَزَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","وبارَكَ اللهُ اليَوْمَ السّابِعَ. وَأعلَنَ أنَّهُ مُخَصَّصٌ لَهُ، لِأنَّهُ اسْتَراحَ فِيهِ مِنْ خَلْقِ العَالَمِ وَما فيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","هَذِهِ هِيَ قِصَّةُ السَّماواتِ وَالأرْضِ عِنْدَما خُلِقَتا، يَوْمَ صَنَعَ اللهُ الأرْضَ وَالسَّماواتِ: ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","لَمْ يَكُنْ أيُّ عُشْبٍ مِنْ أعْشابِ الحُقُولِ قَدْ نَما بَعْدُ عَلَى الأرْضِ، وَلَمْ يَكُنْ نَباتُ الحَقلِ قَدْ بَرْعَمَ، لأنَّ اللهَ لَمْ يَكُنْ قَدْ أرْسَلَ مَطَراً عَلَى الأرْضِ بَعْدُ، وَلَمْ يَكُنْ هُناكَ إنْسانٌ يَفلَحُ التُّرْبَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","لَكِنْ كانَ يَخْرُجُ مِنَ الأرْضِ جَدْوَلٌ يَسْقِي كُلَّ سَطْحِ التُّرْبَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ثُمَّ شَكَّلَ اللهُ الرَّجُلَ مِنْ تُرابِ الأرْضِ، وَنَفَخَ فِي أنفِهِ نَفَسَ الحَياةِ، فَصارَ الرَّجُلُ نَفْساً حَيَّةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ثُمَّ زَرَعَ اللهُ حَدِيقَةً فِي عَدَنٍ، فِي المَشْرِقِ. وَهُناكَ وَضَعَ الرَّجُلَ الَّذِي شَكَّلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","وَأنْبَتَ اللهُ مِنَ الأرْضِ كُلَّ شَجَرَةٍ جَمِيلَةٍ وَصالِحَةٍ لِلأكلِ. وَكانَتْ فِي وَسَطِ الحَدِيقَةِ شَجَرَةُ الحَياةِ، وَأيضاً الشَّجَرَةُ الَّتِي تُعْطِي التَّميِيزَ بَينَ الخَيرِ وَالشَّرِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","وَكانَ نَهْرٌ يَجْرِي عَبْرَ عَدَنٍ لِيَسْقِيَ الحَدِيقَةَ. وَكانَ النَّهْرُ يَنْقَسِمُ إلَى أرْبَعَةِ فُرُوعٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","اسْمُ الأوَّلِ فِيشُونُ. وَهُوَ الَّذِي يَجْرِي حَولَ أرْضِ الحَوِيلَةِ كُلِّها، حَيثُ الذَّهَبُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","وَالذَّهَبُ هُناكَ مِنْ نَوْعِيَّةٍ جَيِّدَةٍ. وَهُناكَ أفْخَرُ العُطُورِ وَأحْجارُ العَقيقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","وَاسْمُ الثّانِي جِيحُونُ. وَهُوَ الَّذِي يَجْرِي حَولَ أرْضِ كُوشٍ كُلِّها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","وَاسْمُ الثّالِثِ دِجلَةَ. وَهُوَ يَجْرِي شَرقِيَّ أشُّورَ. وَالرّابِعُ الفُراتُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","وَأخَذَ اللهُ الرَّجُلَ وَوَضَعَهُ فِي حَدِيقَةِ عَدَنٍ لِيَفلَحَها وَيَعْتَنِيَ بِها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","وَأوْصَى اللهُ الرَّجُلَ فَقالَ: «لَكَ أنْ تَأْكُلَ ما تَشاءُ مِنْ كُلِّ أشْجارِ الحَدِيقَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","أمّا الشَّجَرَةُ الَّتِي تُعْطِي التَّمْيِيزَ بَينَ الخَيرِ وَالشَّرِّ، فَلا تَأْكُلْ مِنْها. لأنَّكَ حِينَ تَأْكُلُ مِنْها، مَوتاً تَمُوتُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ثُمَّ قالَ اللهُ: «لَيسَ حَسَناً أنْ يَكُونَ الرَّجُلُ وَحِيداً. لِهَذا سَأصْنَعُ لَهُ مُعِيناً مِثلَهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","فَشَكَّلَ اللهُ مِنَ التُّرابِ كُلَّ حَيوانٍ فِي الحُقُولِ وَكُلَّ طَيرٍ فِي الهَواءِ. ثُمَّ أحضَرَها كُلَّها إلَى الرَّجُلِ لِيَرَى ماذا سَيُسَمِّي كُلَّ واحِدٍ مِنْها. وَمَهْما كانَ الاسْمُ الَّذِي أطلَقَهُ عَلَى كُلِّ كائِنٍ حَيٍّ، فَذاكَ صارَ اسْمَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","فَسَمَّى الرَّجُلُ كُلَّ المَواشِيَ، وَطُيُورَ السَّماءِ، وَكُلَّ الحَيواناتِ البَرِّيَّةِ. لَكِنْ لَمْ يَجِدْ بَينَها مَنْ هُوَ مِثلُهُ مُعيناً لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","فَأغْرَقَ اللهُ الرَّجُلَ فِي نَوْمٍ عَمِيقٍ. وَبَينَما هُوَ نائِمٌ، أخَذَ اللهُ ضِلْعاً مِنْ أضلاعِهِ، وَأغلَقَ الجِلْدَ مَكانَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ثُمَّ صَنَعَ اللهُ مِنَ الضِّلْعِ الَّتِي أخَذَها مِنَ الرَّجُلِ امْرأةً. وَقَدَّمَها لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","فَقالَ الرَّجُلُ: «أخيراً! هَذِهِ عَظْمٌ مِنْ عِظامِي وَلَحْمٌ مِنْ لَحْمِي! سَأُسَمِّي هَذِهِ ‹امْرأةً› لِأنَّها أُخِذَتْ مِنِ امْرِئٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","لِذَلِكَ يَتْرُكُ الرَّجُلُ أباهُ وَأُمَّهُ، وَيَلتَصِقُ بِزَوْجَتِهِ، فَيَصِيرانِ جَسَداً واحِداً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","وَكانَ الرَّجُلُ وَزَوْجَتُهُ كِلاهُما عُرْيانَينِ. وَلَكِنَّهُما لَمْ يَكُونا يَخجَلانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","وَكانَتِ الحَيَّةُ أمْكَرَ الحَيواناتِ البَرِّيَّةِ الَّتِي خَلَقَها اللهُ. فَقالَتْ لِلمَرأةِ: «أحَقّاً قالَ اللهُ لَكُما: ‹لا تَأْكُلا مِنْ أشْجارِ الحَدِيقَةِ كُلِّها؟›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","فَقالَتِ المَرْأةُ لِلحَيَّةِ: «بَلْ نَأْكُلُ مِنْ ثَمَرِ جَمِيعِ الأشْجارِ فِي الحَديقَةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","أمّا الشَّجَرَةُ الَّتي فِي وَسَطِ الحَدِيقَةِ، فَقَدْ قالَ اللهُ: ‹لا تأكُلا مِنْها وَلا تَلْمَساها وَإلّا فَسَتَمُوتان!›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","فَقالَتِ الحَيَّةُ لِلمَرْأةِ: «لَنْ تَمُوتا! ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","لَكِنَّ اللهَ يَعْرِفُ أنَّكُما حِينَ تَأْكُلانِ مِنْها، تَنْفَتِحُ أعْيُنُكُما، وَتُصبِحانِ مِثلَ اللهِ فِي التَّمْيِيزِ بَينَ الخَيرِ وَالشَّرِّ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","وَرَأتِ المَرْأةُ أنَّ الشَّجَرَةَ شَهِيَّةٌ لِلأكلِ وَجَذّابَةٌ لِلعَينِ، وَمَرغُوبٌ فِيها بِسَبَبِ ما تُعْطِيهِ مِنَ الحِكْمَةِ لِلآكِلِ مِنْها. فَأخَذَتْ مِنْ ثَمَرِها، وَأكَلَتْ. ثُمَّ أعطَتْ لِزَوْجِها الَّذِي كانَ مَعَها، فَأكَلَ هُوَ أيضاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","فانفَتَحَتْ أعيُنُهُما، وَأدرَكا أنَّهُما عُرْيانَينِ. فَخاطا أوْراقَ تِينٍ، وَصَنَعا لَهُما ثَوبَينِ يُخفِيانِ عَوْرَتَيهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ثُمَّ سَمِعا صَوْتَ اللهِ ماشِياً فِي الحَدِيقَةِ مَعَ هُبُوبِ الرِيحِ. فاختَبَأ الرَّجُلُ وَزَوْجَتُهُ بَينَ أشْجارِ الحَدِيقَةِ مِنْ حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","فَنادَى اللهُ الرَّجُلَ وَقالَ لَهُ: «أينَ أنتَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","فَقالَ: «سَمِعْتُ صَوْتَكَ فِي الحَدِيقَةِ، فَخِفْتُ لِأنِّي عُرْيانٌ، فاختَبَأْتُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","فَقالَ اللهُ: «مَنْ قالَ لَكَ إنَّكَ عُرْيانٌ؟ هَلْ أكَلْتَ مِنَ الشَّجَرَةِ الَّتِي نَهَيتُكَ عَنِ الأكلِ مِنْها؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","فَقالَ الرَّجُلُ: «المَرْأةُ الَّتِي أعطَيتَنِي إيّاها لِتَكُونَ مَعِي أعطَتْنِي مِنْ ثَمَرِ الشَّجَرَةِ، فَأكَلْتُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","حِينَئِذٍ قالَ اللهُ لِلمَرأةِ: «ما هَذا الَّذِي فَعَلْتِهِ؟» فَقالَتِ المَرْأةُ: «الحَيَّةُ احتالَتْ عَلَيَّ، فَأكَلْتُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","فَقالَ اللهُ لِلحَيَّةِ: «لِأنَّكِ فَعَلْتِ ذَلِكَ، تَكُونِينَ مَلعُونَةً أكثَرَ مِنْ كُلِّ البَهائِمِ وَمِنْ كُلِّ الحَيواناتِ البَرِّيَّةِ. وَكُلَّ أيّامِ حَياتِكِ، سَتَزحَفِينَ عَلَى بَطنِكِ، وَسَتَتَعَفَّرِينَ بِالتُّرابِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","وَسَأجعَلُ عَداوَةً بَينَكِ وَبَينَ المَرْأةِ، وَبَيْنَ نَسلِكِ وَنَسلِها. سَيَسْحَقُ نَسلُها رَأْسَكِ، وَأنْتِ سَتَلْدَغِينَ عَقِبَهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ثُمَّ قالَ اللهُ لِلمَرْأةِ: «سَأُكَثِّرُ آلامَ حَبَلِكِ، وَبِالوَجَعِ تَلِدِينَ أبْناءَكِ. أنتِ تَشْتاقينَ إلَى زَوْجِكِ، وَهُوَ يَسُودُ عَلَيكِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ثُمَّ قالَ اللهُ لِآدَمَ: «قَدِ اسْتَمَعْتَ لِمَشُورَةِ امْرَأتِكَ، فَأكَلْتَ مِنَ الشَّجَرَةِ الَّتِي نَهَيتُكَ عَنِ الأكلِ مِنْها. لِهَذا سَألعَنُ الأرْضَ، فَلا تَعُودُ تَأْكُلُ مِنْها إلّا بِالكَدِّ وَالتَّعَبِ كُلَّ أيّامِ حَياتِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","سَتُنْبِتُ لَكَ شَوْكاً وَحَسَكاً. وَسَتُضطَرُّ إلَى الأكلِ مِنْ نَباتاتِ الحُقُولِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","تَأْكُلُ خُبْزَكَ بِعَرَقِ جَبِينِكَ، إلَى أنْ تَعُودَ إلَى الأرْضِ الَّتِي مِنْها أُخِذْتَ. مِنَ التُّرابِ خُلِقْتَ، وَإلَى التُّرابِ سَتَعُودُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","وَدَعا آدَمُ زَوْجَتَهُ «حَوّاءَ» لِأنَّها سَتُصْبِحُ أُمَّ كُلِّ إنْسانٍ حَيٍّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","وَصَنَعَ اللهُ مَلابِسَ مِنَ الجِلْدِ لِآدَمَ وَلِزَوْجَتِهِ، وَألْبَسَهُما. ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ثُمَّ قالَ اللهُ: «ها قَدْ صارَ الإنْسانُ كَواحِدٍ مِنّا فِي التَّمْيِيزِ بَينَ الخَيرِ وَالشَّرِّ. وَالآنَ يُمْكِنُهُ أنْ يَمُدَّ يَدَهُ وَيَأْخُذَ مِنْ ثَمَرِ شَجَرَةِ الحَياةِ، وَيأكُلُ مِنْها، فَيَعيِشَ إلَى الأبَدِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","فَطَرَدَهُ اللهُ مِنْ حَدِيقَةِ عَدَنٍ لِيَفلَحَ الأرْضَ الَّتِي مِنْها خُلِقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","وَبَعدَ أنْ طَرَدَ الإنْسانَ، وَضَعَ مَلائِكَةَ الكَرُوبِيمَ، وَسيْفاً مُلْتَهِباً مُتَقَلِّباً لِحِراسَةِ الطَّرِيقِ إلَى شَجَرَةِ الحَياةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","وَعاشَرَ آدَمُ امرَأتَهُ حَوّاءُ. فَحَمَلَتْ وَوَلَدَتْ قايِينَ إذْ قالَتْ: «اقْتَنَيتُ رَجُلاً بِمَعُونَةِ اللهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","وَكَذَلِكَ أنجَبَتْ أخاهُ هابِيلَ. وَعَمِلَ هابِيلُ راعِياً، وَأمّا قايِينُ فَعَمِلَ فَلّاحاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","وَحِينَ جاءَ وَقْتُ الحَصادِ، أحضَرَ قايِينُ بَعضَ ثِمارِ الأرْضِ، وَقَدَّمَها قُرْباناً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","كَما قَدَّمَ هابِيلُ قُرْباناً مِنْ أبْكارِ غَنَمِهِ وَأسْمَنِها. فَنَظَرَ اللهُ بِرِضَىً إلَى هابِيلَ وَقُرْبانِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","لَكِنَّهُ لَمْ يَنْظُرْ بِرِضَىً إلَى قايِينَ وَقُرْبانِهِ. فاغتاظَ قايِينُ وَأُحبِطَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","فَقالَ اللهُ لِقايِينَ: «ما الَّذِي أغضَبَكَ، وَما الَّذِي أحبَطَكَ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","إنْ كُنْتَ فَعَلْتَ الصَّوابَ، أفَلا أقْبَلُكَ؟ وَإنْ لَمْ تَفْعَلْ، فَإنَّ الخَطِيَّةَ مُتَرَبِّصَةٌ بِكَ عَلَى البابِ. هِيَ تُرِيدُ أنْ تَسُودَ عَلَيكَ، لَكِنْ يَنبَغِي أنْ تَسُودَ عَلَيها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","وَقالَ قايِينُ لِهابِيلَ أخِيهِ: «هَيّا بِنا إلَى الحَقلِ.» وَبَينَما هُما فِي الحَقلِ، هَجَمَ قايِينُ عَلَى أخِيهِ هابِيلَ وَقَتَلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","فَقالَ اللهُ لِقايِينَ: «أينَ أخُوكَ؟» أجابَ قايِينُ: «وَما أدْرانِي؟ أأنا حَارِسٌ لِأخِي؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","فَقالَ: «ما الَّذِي فَعَلْتَهُ؟ دَمُ أخِيكَ يَصْرخُ إلَيَّ مِنَ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","فَالآنَ أنْتَ مَلْعُونٌ وَمَنْفِيٌّ مِنَ الأرْضِ الَّتِي فَتَحَتْ فَمَها لِتَشْرَبَ دَمَ أخِيكَ مِنْ يَدَيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","فَحِينَ تَفلَحُ الأرْضَ، لَنْ تُعطِيَكَ أفْضَلَ مَحاصِيلِها. وَسَتَكُونُ فِي الأرْضِ طَرِيداً وَهائِماً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","فَقالَ قايِينُ للهِ: «عِقابِي أعظَمُ مِنْ أنْ أحتَمِلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ها أنْتَ قَدْ طَرَدتَنِي اليَوْمَ مِنَ الأرْضِ، وَحَجَبْتَ عَنِّي وَجهَكَ. سَأكُونُ طَرِيداً وَهائِماً فِي الأرْضِ. فَمَنْ يَجِدُنِي سَيَقْتُلُنِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","فَقالَ اللهُ لِقايِينَ: «بَلْ سَأنتَقِمُ سَبْعَةَ أضْعافٍ مِنْ أيِّ إنْسانٍ يَقْتُلُ قايِينَ.» ثُمَّ وَضَعَ اللهُ عَلامَةً عَلَى قايِينَ لِئَلّا يَقْتُلَهُ مَنْ يَجِدُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","وَهَكَذا خَرَجَ قايِينُ مِنْ حَضْرَةِ اللهِ، وَسَكَنَ فِي أرْضِ نُودٍ شَرْقِيَّ عَدَنٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","فَعاشَرَ قايِينُ زَوْجَتَهُ فَحَمَلَتْ وَأنجَبَتْ حَنُوكَ. وَبَنَى قايِينُ مَدِينَةً، وَسَمّاها عَلَى اسْمِ ابْنِهِ حَنُوكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","وَأنجَبَ حَنُوكُ ابْناً سَمّاهُ عِيرادِ. وَأنجَبَ عِيرادُ ابْناً سَمّاهُ مَحُويائِيلَ. وَأنجَبَ مَحُويائِيلُ ابْناً سَمّاهُ مَتُوشائِيلَ. وَأنجَبَ مَتُوشائِيلُ ابْناً سَمّاهُ لامَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","وَتَزَوَّجَ لامِكُ امْرَأتَينِ. اسْمُ إحْداهِما عادَةَ، وَالثَّانِيَةُ صِلَّةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","وَأنجَبَتْ عادَةُ يابالَ وَكانَ أباً لِلَّذِينَ يَسْكُنُونَ الخِيامَ وَيُرَبُّونَ الماشِيَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","وَكانَ لَهُ أخٌ اسْمُهُ يُوبالُ. وَكانَ أباً لِلَّذِينَ يَعزِفُونَ عَلَى القِيثارِ وَالنّايِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","وَوَلَدَتْ صِلَّةُ تُوبالَ قايِينَ. وَكانَ أباً لِلَّذِينَ يَطرُقُونَ البُرونْزَ وَالحَدِيدَ. وَكانَتْ لِتُوبالَ قايِينَ أختٌ اسْمُها نِعْمَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","وَقالَ لامَكُ لِزَوْجَتَيهِ: «يا زَوْجَتَيَّ، يا عادَةُ وَيا صِلَّةُ، أصغِيا إلَيَّ جَيِّداً، وَانتَبِها لِما أقُولُ. إنِّي قَتَلْتُ رَجُلاً آذانِي. قَتَلْتُ فَتَىً لِأنَّهُ ضَرَبَنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","فَإذا كانَ يُنْتَقَمُ سَبْعَ مَرّاتٍ لِقايِينَ، فَإنَّهُ يُنْتَقَمُ لِلامَكَ سَبْعاً وَسَبْعِينَ مَرَّةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","وَعاشَرَ آدَمُ زَوجَتَهُ حَوّاءَ ثانِيَةً، فَأنجَبَتِ ابْناً أسْمَتْهُ شِيثاً إذْ قالَتْ: «أعطانِيَ اللهُ ابْناً آخَرَ عِوَضاً عَنْ هابِيلَ، لأنَّ قايِينَ قَتَلَهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","وَأنجَبَ شِيثٌ أيضاً ابْناً سَمّاهُ أنُوشَ. وَفِي ذَلِكَ الوَقتِ، بَدَأ النّاسُ يَنْطِقُونَ بِاسْمِ يهوه. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","وَهَذا هُوَ سِجِلُّ نَسلِ آدَمَ. عِنْدَما خَلَقَ اللهُ آدَمَ، شَكَّلَهُ كَمِثالِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","وَخَلَقَ اللهُ النَّاسَ ذَكَراً وَأُنْثَى. وَسَمّاهُمْ أُناساً يَوْمَ خَلَقَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","وَبَعْدَ أنْ صارَ لِآدَمَ مِئَةٌ وَثَلاثُونَ سَنَةً مِنَ العُمْرِ، أنجَبَ ابْناً آخَرَ كَمِثالِهِ وَصُورَتِهِ، سَمّاهُ شِيثاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","وَعاشَ آدَمُ ثَمانِي مِئَةِ سَنَةٍ بَعْدَ وِلادَةِ شِيثٍ. وَفِي هَذِهِ الفَتْرَةِ أنجَبَ أبْناءً وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","فَكانَ مَجمُوعُ السَّنَواتِ الَّتِي عاشَها آدَمُ تِسْعَ مِئَةٍ وَثَلاثِينَ سَنَةً، وَبَعْدَها ماتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","وَعاشَ شِيثٌ مِئَةً وَخَمْسَ سِنِينٍ، وَأنجَبَ أنُوشَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","وَعاشَ شِيثٌ ثَمانِي مِئَةٍ وَسَبْعَ سِنِينَ بَعْدَ وِلادَةِ أنُوشَ. وَفِي هَذِهِ الفَتْرَةِ أنجَبَ أبْناءً وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","فَكانَ مَجمُوعُ السَّنَواتِ الَّتِي عاشَها شِيثٌ تِسْعَ مِئَةٍ وَاثْنَتَي عَشْرَةَ سَنَةً، وَبَعْدَ ذَلِكَ ماتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","وَعاشَ أنُوشُ تِسْعِينَ سَنَةً، وَأنجَبَ ابْناً سَمَّاهُ قِينانُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","وَبَعدَ وِلادَةِ قِينانَ عاشَ أنُوشُ ثَمانِي مِئَةٍ وَخَمْسَ عَشْرَةَ سَنَةً. وَفِي هَذِهِ الفَتْرَةِ أنجَبَ أبْناءً وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","فَكانَ مَجمُوعُ السَّنَواتِ الَّتِي عاشَها أنُوشُ تِسْعَ مِئَةٍ وَخَمْسَ سَنَواتٍ، وَبَعدَ ذَلِكَ ماتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","وَعاشَ قِينانُ سَبْعِينَ سَنَةً، ثُمَّ أنجَبَ مَهلَلْئِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","وَبَعْدَ وِلادَةِ مَهلَلْئِيلَ عاشَ قِينانُ ثَمانِي مِئَةٍ وَأربَعِينَ سَنَةً. وَفِي هَذِهِ الفَتْرَةِ أنجَبَ أبْناءً وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","فَكانَ مَجمُوعُ السَّنَواتِ الَّتِي عاشَها قِينانُ تِسْعَ مِئَةٍ وَعَشْرَ سِنِينَ، وَبَعدَ ذَلِكَ ماتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","وَعاشَ مَهلَلْئِيلُ خَمْساً وَسِتِّينَ سَنَةً، ثُمَّ أنجَبَ ابْناً أسْماهُ يارَدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","وَبَعدَ وِلادَةِ يارَدَ عاشَ مَهلَلْئِيلُ ثَمانِي مِئَةٍ وَثَلاثِينَ سَنَةً. وَفِي هَذِهِ الفَتْرَةِ أنجَبَ أبْناءً وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","فَكانَ مَجمُوعُ السَّنَواتِ الَّتِي عاشَها مَهلَلْئِيلُ ثَمانِي مِئَةٍ وَخَمْساً وَتِسْعِينَ سَنَةً، وَبَعْدَ ذَلِكَ ماتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","وَعاشَ يارَدُ مِئَةً وَاثْنَتَينِ وِسِتِّينَ سَنَةً، ثُمَّ أنجَبَ ابْناً أسْماهُ أخنُوخَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","وَبَعْدَ وِلادَةِ أخنُوخَ عاشَ يارَدُ ثَمانِي مِئَةِ سَنَةٍ. وَفِي هَذِهِ الفَتْرَةِ أنجَبَ أبْناءً وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","فَكانَ مَجمُوعُ السَّنَواتِ الَّتِي عاشَها يارَدُ تِسْعَ مِئَةٍ وَاثْنَتَينِ وَسِتِّينَ سَنَةً، وَبَعدَ ذَلِكَ ماتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","وَعاشَ أخنُوخُ خَمْساً وَسِتِّينَ سَنَةً، ثُمَّ أنجَبَ ابْناً أسْماهُ مَتُوشالَحَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","وَبَعْدَ وِلادَةِ مَتُوشالَحَ سارَ أخنُوخُ فِي طَرِيقِ اللهِ ثَلاثَ مِئَةِ سَنَةٍ. وَفِي هَذِهِ الأثْناءِ أنجَبَ أبْناءً وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","فَكانَ مَجْمُوعُ السَّنَواتِ الَّتِي عاشَها أخنُوخُ ثَلاثَ مِئَةٍ وَخَمْساً وَسِتِّينَ سَنَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","وَسارَ أخنُوخُ مَعَ اللهِ، ثُمَّ اختَفَى، لأنَّ اللهَ رَفَعَهُ إلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","وَعاشَ مَتُوشالَحُ مِئَةً وَسَبْعاً وَثَمانِينَ سَنَةً، ثُمَّ أنجَبَ ابْناً أسْماهُ لامَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","وَبَعْدَ وِلادَةِ لامَكَ، عاشَ مَتُوشالَحُ سَبْعَ مِئَةٍ وَاثْنَتَينِ وَثَمانِينَ سَنَةً. وَفِي هَذِهِ الفَتْرَةِ أنجَبَ أبْناءً وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","فَكانَ مَجْمُوعُ السَّنَواتِ الَّتِي عاشَها مَتُوشالَحُ تِسْعَ مِئَةٍ وَتِسْعاً وَسِتِّينَ سَنَةً، ثُمَّ ماتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","وَعاشَ لامَكُ مِئَةً وَاثْنَتَينِ وَثَمانِينَ سَنَةً، ثُمَّ أنجَبَ ابْناً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","وَسَمَّى لامَكُ ابْنَهُ نُوحَ وَقالَ: «لَيتَ ابْنِي هَذا يُرِيحُنا مِنْ كُلِّ عَمَلِنا وَمِنْ كُلِّ تَعَبٍ أيضاً بِسَبَبِ اللَّعْنَةِ الَّتِي وَضَعَها اللهُ عَلَى الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","وَبَعْدَ وِلادَةِ نُوحَ عاشَ لامَكُ خَمْسَ مِئَةٍ وَخَمْساً وَتِسْعِينَ سَنَةً. وَفِي هَذِهِ الفَتْرَةِ أنجَبَ أبْناءً وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","فَكانَ مَجمُوعُ السَّنَواتِ الَّتِي عاشَها لامَكُ سَبْعَ مِئَةٍ وَسَبْعاً وَسَبْعِينَ سَنَةً، ثُمَّ ماتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","وَعاشَ نُوحُ خَمْسَ مِئَةِ سَنَةٍ، وَأنجَبَ سامَ وَحامَ وَيافَثَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","وَبَدَأ النّاسُ يَتَكاثَرُونَ عَلَى وَجهِ الأرْضِ. وَوُلِدَتْ لَهُمْ بَناتٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","فَلَمّا رَأى بَنُو اللهِ أنَّ بَناتَ النّاسِ جَميلاتٌ، عاشَرُوا مِنْهُنَّ مَنْ يُرِيدُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","فَقالَ اللهُ: «لَنْ يَدُومَ رُوحِي فِي النّاسِ إلَى الأبَدِ، لِأنَّهُمْ لَحْمٌ وَدَمٌ. وَلَنْ يَعِيشُوا أكثَرَ مِنْ مِئَةٍ وَعِشْرِينَ سَنةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","فِي ذَلِكَ الوَقتِ وَبَعْدَهُ – أي بَعْدَ أنْ عاشَرَ بَنُو اللهِ بَناتِ النَّاسِ وَأنْجَبْنَ لَهُمْ أولاداً – عَاشَتْ جَماعَةُ الجَبابِرَةِ عَلَى الأرْضِ. وَكانُوا مُحارِبينَ مَشْهُورينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","وَرَأى اللهُ أنَّ النّاسَ فِي الأرْضِ أشْرارٌ جِدّاً. وَأنَّ أفكارَهُمْ وَخُطَطَهُمْ شِرِّيرَةٌ عَلَى الدَّوامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","فَأسِفَ اللهُ عَلَى خَلقِ الإنْسانِ عَلَى الأرْضِ. وَحَزِنَ فِي قَلْبِهِ كَثِيراً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","فَقالَ اللهُ: «سَأمْحُو النّاسَ الَّذِينَ خَلَقْتُهُمْ مِنْ تُرابِ الأرْضِ: النّاسَ وَالمَواشِي وَالزَّواحِفَ وَطُيُورَ السَّماءِ. فَقَدْ أسِفْتُ عَلَى خَلقِها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","لَكِنَّ نُوحَ حَظِيَ بِرِضَى اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","هَذا سِجِلُّ مَوالِيدِ عائِلَةِ نُوحَ. كانَ نُوحُ رَجُلاً بارّاً. وَكانَ وَحدَهُ بِلا عَيبٍ بَينَ مُعاصِرِيهِ. وَسارَ نُوحُ مَعَ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","وَأنجَبَ نُوحُ ثَلاثَةَ بَنِينَ هُمْ سامُ وَحامٌ وَيافَثُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","وَرَأى اللهُ الأرْضَ فاسِدَةً، إذِ امْتَلأتْ بِالعُنْفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","وَنَظَرَ اللهُ إلَى الأرْضِ، فَكانَتْ فاسِدَةً حَقّاً، لأنَّ جَمِيعَ النّاسِ أفسَدُوا طُرُقَهُمْ عَلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","فَقالَ اللهُ لِنُوحَ: «ها قَدِ اقتَرَبَتْ نِهايَةُ كُلِّ الكائِناتِ الحَيَّةِ، لأنَّ النّاسَ قَدْ مَلأُوا الأرْضَ عُنْفاً. فَها أنا سَأُدَمِّرُهُمْ سَرِيعاً مَعَ أرْضِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","فاصْنَعْ سَفِينَةً مِنْ خَشَبِ السَّرْوِ، وَابْنِ فِيها غُرَفاً. وَاطلِ السَّفِينَةَ مِنَ الخارِجِ بِالقارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","«اصْنَعِ السَّفِينَةَ حَسَبَ القِياساتِ التّالِيَةِ: الطُّولُ ثَلاثُ مِئِةِ ذِراعٍ، وَالعَرْضُ خَمْسُونَ ذِراعاً، وَالارتِفاعُ ثَلاثُونَ ذِراعاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","وَاجْعَلْ فِي أحَدِ جَوانِبِ السَّفِينَةِ نافِذَةً تَحْتَ السَّقْفِ بِذِراعٍ واحِدَةٍ. وَاجعَلْ باباً فِي جانِبِ السَّفِينَةِ. وَابنِ السَّفِينَةَ ثَلاثَ طَبَقاتٍ: سُفلِيَّةً وَوُسْطَى وَعُليا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","فَها أنا أُوشِكُ أنْ أجلِبَ طُوفاناً هائِلاً عَلَى الأرْضِ، لأُبيدَ كُلَّ كائِنٍ يَتَنَفَّسُ تَحتَ السَّماءِ. كُلُّ ما عَلَى الأرضِ سَيَفنَى! ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","«أمّا أنتَ فَسَأقطَعُ مَعَكَ عَهداً، فَتَدخُلَ السَّفِينَةَ أنْتَ وَأبْناؤكَ وَزَوْجَتُكَ وَنِساءُ أبْنائِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","أدْخِلْ إلَى السَّفِينَةِ أيضاً زَوْجينِ، ذَكَراً وَأُنْثَى، مِنْ كُلِّ نَوْعٍ مِنَ الكائِناتِ الحَيَّةِ، لِكَي تَنجُوَ مَعَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","وَسَيَنْضَمُّ إلَيكَ زَوْجانِ مِنْ كُلِّ نَوْعٍ مِنَ الطُّيُورِ، وَكُلِّ نَوْعٍ مِنَ الحَيواناتِ، وَكُلِّ نَوعٍ مِنَ الحَيَواناتِ الزّاحِفَةِ عَلَى الأرْضِ، لِكَي تُحافِظَ عَلَى حَياتِها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","وَخُذْ بَعضاً مِنْ كُلِّ نَوْعٍ مِنَ الطَّعامِ الَّذِي يُمْكِنُ أنْ يُؤْكَلَ، وَاخْزِنْهُ. وَلْيَكُنْ هَذا طَعاماً لَكَ وَلِعائِلَتِكَ وَلِلحَيواناتِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","فَفَعَلَ نُوحُ كُلَّ ما أمَرَهُ بِهِ اللهُ تَماماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ثُمَّ قالَ اللهُ لِنُوحَ: «ادخُلْ وَكُلُّ عائِلَتِكَ السَّفِينَةَ، لِأنِّي وَجَدْتُ أنَّكَ وَحدَكَ صالِحٌ أمامِي مِنْ بَينِ كُلِّ الأحياءِ فِي هَذا الجِيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","فَخُذْ مَعَكَ سَبْعَةَ ذُكُورٍ وَسَبعَ إناثٍ مِنْ كُلِّ حَيوانٍ طاهِرٍ. وَخُذْ أيضاً ذَكَراً واحِداُ وَأُنْثَى واحِدَةً مِنْ كُلِّ حَيوانٍ غَيرِ طاهِرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","وَخُذْ سَبْعَةَ ذُكُورٍ وَسَبعَ إناثٍ مِنْ كُلِّ نَوْعٍ مِنْ طُيُورِ السَّماءِ، لِكَي تُحافِظَ عَلَى بَقاءِ أنواعِها عَبْرَ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","فَبَعْدَ سَبْعَةِ أيّامٍ، سَأُرْسِلُ مَطَراً مُدَّةَ أرْبَعِينَ يَوْماً وَأربَعِينَ لَيلَةً. وَسَأمحُو كُلَّ كائِنٍ حَيٍّ خَلَقْتُهُ عَنْ وَجهِ الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","فَفَعَلَ نُوحُ كُلَّ ما أمَرَهُ بِهِ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","وَكانَ لِنُوحَ سِتُّ مِئَةِ سَنَةٍ حِينَ غَمَرَتْ مِياهُ الطُّوفانِ الأرْضَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ثُمَّ دَخَلَ نُوحُ السَّفِينَةَ مَعَ بَنِيهِ وَزَوْجَتِهِ وَكَنّاتِهِ لِلنَّجاةِ مِنْ مِياهِ الطُّوفانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","وَدَخَلَتْ حَيواناتٌ طاهِرَةٌ وَغَيرُ طاهِرَةٍ وَطُيُورٌ وَزَواحِفُ وَغيرُها مِنْ حَيَواناتِ الأرْضِ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","إلَى نُوحَ فِي السَّفينَةِ زَوجَينِ زَوجَينِ: ذَكَراً وَأُنْثَىً، حَسَبَ ما أمَرَ اللهُ نُوحَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","وَبَعْدَ سَبْعَةِ أيّامٍ، بَدأ الطُّوفانُ عَلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","فَفِي السَّنَةِ السِّتِّ مِئَةٍ مِنْ عُمْرِ نُوحَ، فِي اليَوْمِ السّابِعَ عَشَرَ مِنَ الشَّهْرِ الثّانِي، انفَجَرَتْ كُلُّ يَنابِيعِ المُحِيطِ العَظِيمِ الَّتِي تَحْتَ الأرْضِ، وَانْفَتَحَتْ نَوافِذُ السَّماءِ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","فَهَطَلَ مَطَرٌ غَزِيرٌ جِدّاً عَلَى الأرْضِ مُدَّةَ أربَعِينَ يَوْماً وَأربَعِينَ لَيلَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","وَفِي ذَلِكَ اليَوْمِ نَفْسِهِ، دَخَلَ نُوحُ السَّفِينَةَ مَعَ أبْنائِهِ سامَ وَحامَ وَيافَثَ، وَزَوْجَتِهِ، وَزَوجَاتِ أبْنائِهِ الثَّلاثِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","دَخَلَ هَؤُلاءِ مَعَ كُلِّ نَوْعٍ مِنَ الحَيواناتِ البَرِّيَّةِ، وَكُلِّ نَوْعٍ مِنَ المَواشِيَ، وَكُلِّ نَوْعٍ مِنَ الحَيَواناتِ الزّاحِفَةِ عَلَى التُّرابِ، وَكُلِّ نَوْعٍ مِنَ الطُّيُورِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","جاءَتْ إلَى نُوحَ فِي السَّفِينَةِ أزواجاً مِنْ كُلِّ نَوْعٍ مِنَ الحَيواناتِ الحَيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","وَكانَتْ هَذِهِ الحَيواناتُ الدّاخِلَةُ، ذَكَراً وَأُنثَى، مِنْ كُلِّ نَوْعٍ كَما أمَرَهُ اللهُ. ثُمَّ أغلَقَ اللهُ البابَ خَلْفَ نُوحَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","وَبَقِيَ الطُّوفانُ عَلَى الأرْضِ أربَعِينَ يَوْماً. وَارتَفَعَتِ المِياهُ كَثيراً جِدّاً فَوْقَ الأرْضِ، فَحَمَلَتِ السَّفينَةَ فَارتَفَعَتْ فَوقَ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","وَاسْتَمَرَّ الماءُ يَرْتَفِعُ وَيَتَكاثَرُ جِدّاً فَوْقَ الأرْضِ. وَطَافَتِ السَّفِينَةُ عَلَى وَجْهِ المِياهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","وَارتَفَعَتِ المِياهُ أكثَرَ فَأكثَرَ فَوْقَ الأرْضِ حَتَّى غَطَّتْ كُلَّ الجِبالِ العالِيَةِ تَحْتَ السَّماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","تَعالَتِ المِياهُ حَتَّى غَطَّتْ قِمَمَ الجِبالِ بِأكْثَرَ مِنْ خَمْسَ عَشْرَةَ ذِراعاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","فَماتَ كُلُّ مَخلُوقٍ يَتَحَرَّكُ عَلَى الأرْضِ. ماتَتِ الطُّيُورُ وَالمَواشِي وَالحَيواناتُ البَرِّيَّةُ وَكُلُّ أسْرابِ الكائناتِ الَّتِي كانَتْ تَحْتَشِدُ عَلَى الأرْضِ وَجَمِيعُ البَشَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ماتَ كُلُّ مَخلُوقٍ حَيٍّ يَتَنَفَّسُ عَلَى اليابِسَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","وَهَكَذا مَحا اللهُ كُلَّ شَيءٍ حَيٍّ عَنْ وَجهِ الأرْضِ، بَشَراً وَحَيواناتٍ وَزَواحِفَ وَطُيُوراً. مُحِيَتْ كُلُّها عَنْ وَجْهِ الأرْضِ. وَلَمْ يَنْجُ إلّا نُوحُ وَمَنْ مَعَهُ فِي السَّفِينَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","وَغَمَرَتِ المِياهُ الأرْضَ مُدَّةَ مِئَةٍ وَخَمْسِينَ يَوْماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ثُمَّ تَذَكَّرَ اللهُ نُوحَ وَكُلَّ الحَيواناتِ البَرِّيَّةِ وَكُلَّ المَواشِيَ الَّتِي كانَتْ مَعَهُ فِي السَّفِينَةِ. فَجَعَلَ اللهُ رِيحاً تَهُبُّ عَلَى الأرْضِ. فَبَدَأ المِاءُ يَنخَفِضُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","وَتَوَقَّفَ تَدَفُّقُ الماءِ مِنْ تَحْتِ الأرْضِ. وَسَدَّتِ السَّماءُ نَوافِذَها، فَلَمْ يَعُدِ المَطَرُ يَنْزِلُ مِنَ السَّماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ثُمَّ بَدَأ الماءُ يَنْسَحِبُ شَيئاً فَشَيئاً مِنَ الأرْضِ. فَبَدَأ الماءُ يَنحَسِرُ فِي نِهايَةِ المِئَةِ وَالخَمْسِينَ يَوْماً، ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","إلَى أنِ اسْتَقَرَّتِ السَّفِينَةُ عَلَى جِبالِ أراراطَ فِي اليَوْمِ السّابِعَ عَشَرَ مِنَ الشَّهْرِ السّابِعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","وَاسْتَمَرَّ انخِفاضُ الماءِ حَتَّى الشَّهْرِ العاشِرِ. وَفِي اليَوْمِ الخامِسِ مِنَ الشَّهْرِ العاشِرِ ظَهَرَتْ قِمَمُ الجِبالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","وَبَعْدَ أربَعِينَ يَوْماً، فَتَحَ نُوحُ نافِذَةَ السَّفِينَةِ الَّتِي صَنَعَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","وَأرْسَلَ غُراباً. فَطارَ الغُرابُ مِنْ مَكانٍ إلَى آخَرَ إلَى أنْ نَشِفَتِ المِياهُ عَنِ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ثُمَّ أرْسَلَ نُوحُ يَمامَةً مِنْ عِنْدِهِ لِيَرَى إنْ كانَ الماءُ قَدِ انْحَسَرَ مِنْ سَطحِ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","وَلَكِنَّ اليَمامَةَ لَمْ تَجِدْ مَكاناً تَحُطُّ عَلَيهِ لأنَّ الأرْضَ كانَتْ ما تَزالُ مُغَطّاةً بِالماءِ. فَعادَتْ إلَى نُوحَ فِي السَّفِينَةِ. فَأخرَجَ نُوحُ ذِراعَهُ وَأمْسَكَ بِاليَمامَةِ، وَأدخَلَها إلَى السَّفِينَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","وَانتَظَرَ نُوحُ سَبْعَةَ أيّامٍ أُيضاً. ثُمَّ أرسَلَ اليَمامَةَ مِنَ السَّفِينَةِ ثانِيَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","فَعادَتِ اليَمامَةُ إلَيهِ فِي ذَلِكَ المَساءِ، تَحْمِلُ فِي مِنْقارِها وَرَقَةَ زَيتُونٍ خَضْراءَ. فَعَرَفَ نُوحُ أنَّ المياهَ قَدِ انخَفَضَتْ عَنِ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","فَانتَظَرَ نُوحُ سَبْعَةَ أيّامٍ أُيضاً، وَأرْسَلَ اليَمامَةَ. فَلَمْ تَعُدِ إلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","وَفِي اليَوْمِ الأوَّلِ مِنَ الشَّهْرِ الأوَّلِ، فِي السَّنَةِ الواحِدَةِ وَالسِّتِّ مِئَةٍ مِنْ عُمْرِ نَوْحٍ، جَفَّتِ المِياهُ عَنِ الأرْضِ. فَفَتَحَ نُوحُ بابَ السَّفِينَةِ وَنَظَرَ، فَرَأى أنَّ سَطحَ الأرْضِ قَدْ جَفَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","وَفِي اليَوْمِ السّابِعِ وَالعِشْرِينَ مِنَ الشَّهْرِ الثّانِي، جَفَّتِ الأرْضُ تَماماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","فَقالَ اللهُ لِنُوحَ: ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«اخرُجْ مِنَ السَّفِينَةِ أنتَ وَزَوْجَتُكَ وَأبناؤكَ وَزَوْجاتُهُمْ مَعَكَ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","وَأخرِجْ كُلَّ كائِنٍ حَيٍّ مَعَكَ، مِنْ كُلِّ نَوْعٍ مِنَ الحَيوانِ وَالطَّيرِ وَالماشِيَةِ وَالزَّواحِفِ عَلَى التَّرابِ، لِكَي تَتَكاثَرَ وَتَتَناسَلَ وَتَزْدادَ عَلَى الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","فَخَرَجَ نُوحُ وَأبناؤهُ وَزَوْجَتُهُ وَزَوجَاتُ أبنائِهِ مِنَ السَّفِينَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","وَخَرَجَ مِنَ السَّفِينَةِ كُلُّ حَيوانٍ، وَكُلُّ زاحِفٍ، وَكُلُّ طَيرٍ، وَكُلُّ ما يَتَحَرَّكُ عَلَى الأرْضِ، كُلٌّ حَسَبَ جِنْسِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ثُمَّ بَنَى نُوحُ مَذْبَحاً للهِ. وَأخَذَ مِنْ جَمِيعِ أنْواعِ الحَيواناتِ الطّاهِرَةِ وَالطُّيُورِ الطّاهِرَةِ، وَقَدَّمَها قَرابِينَ عَلَى المَذْبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","وَرَضِيَ اللهُ عَنْ هَذِهِ الذَّبائِحِ وَقالَ: «لَنْ ألْعَنَ الأرْضَ ثانِيَةً بِسَبَبِ النّاسِ، لأنَّ قَلْبَ الإنسانِ مَيّالٌ إلَى الشَّرِّ مُنْذُ صِغَرِهِ. فَلَنْ أعُودَ إلَى إهلاكِ كُلِّ مَخلُوقٍ حَيِّ كَما فَعَلْتُ الآنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","فَما دامَتْ هُناكَ أرْضٌ، سَيَظَلُّ هُناكَ زَرْعٌ وَحَصادٌ، بَرْدٌ وَحَرٌّ، صَيفٌ وَشِتاءٌ، وَلَيلٌ وَنَهارٌ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","وَبارَكَ اللهُ نُوحَ وَبَنِيهِ. وَقالَ لَهُمْ: «أنجِبُوا أبْناءً كَثِيرِينَ، وَاملأُوا الأرْضَ بِنَسلِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","سَتَرْهَبُكُمْ وَسَتَفْزَعُ مِنكُمْ جَمِيعُ الحَيَواناتِ وَالطُّيُورِ وَالزَّواحِفِ وَالأسْماكِ، وَسَتَخْضَعُ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","فَاصطادُوا مِنْ كُلِّ شَيءٍ حَيٍّ يَتَحَرَّكُ طَعاماً لَكُمْ. فَكَما أعطَيتُكُمِ النَّباتاتِ الخَضْراءَ طَعاماً، فَها أنا أُعطِيكُمْ جَمِيعَ الحَيَواناتِ طَعاماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","لَكِنْ لا تَأْكُلُوا لَحْماً ما زالَتْ حَياتُهُ – أي دَمُهُ – فِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","وَأنا سَأُطالِبُ بِالدَّمِ مُقابِلَ الحَياةِ. سَأُطالِبُ بِحَياةِ كُلِّ حَيوانٍ يَقْتُلُ إنْساناً، وَبِحَياةِ كُلِّ إنْسانٍ يَقْتُلُ إنْساناً مِثلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","«مَنْ يَسْفُكُ دَمَ إنْسانٍ، فَلْيَسْفُكْ إنْسانٌ دَمَهُ، لأنَّ اللهَ خَلَقَ الإنْسانَ عَلَى صُورَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","«وَأنْتُمْ، أثمِرُوا وَتَضاعَفُوا فِي الأرْضِ، وَاكثُرُوا فِيها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ثُمَّ قالَ اللهُ لِنُوحَ وَلِبَنْيهِ مَعَهُ: ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«ها أنا أقطَعُ عَهْدِي مَعَكَ وَمَعَ أبْنائِكَ مِنْ بَعْدِكَ، وَمَعَ كُلِّ مَخلُوقٍ حَيِّ مَعَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","وَأقْطَعُهُ مَعَ كُلِّ الطُّيُورِ وَالمَواشِي وَكُلِّ حَيواناتِ الأرْضِ مَعَكَ، كُلِّ الَّتِي خَرَجَتْ مِنَ السَّفِينَةِ، كُلِّ حَيواناتِ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","«وَالآنَ، ها هُوَ العَهْدُ الَّذِي سَأقْطَعُهُ مَعَكَ: لا يُقْضَى عَلَى كُلِّ الخَليقَةِ بِمِياهِ الطُّوفانِ ثانِيَةً، وَلا تُدَمِّرُ الأرْضُ بِالطُّوفانِ ثانِيَةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","وَقالَ اللهُ: «وَهَذِهِ هِيَ عَلامَةُ العَهْدِ الَّذِي أقْطَعُهُ مَعَكَ وَمَعَ كُلِّ كائِنٍ حَيٍّ عَلَى مَدَى الأجْيالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","سَأضَعُ قَوْسي فِي السَّحابِ، لِتَكُونَ عَلامَةً عَلَى العَهْدِ بَينِي وَبَينَ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","فَكُلّما ظَهَرَتِ السُّحُبُ فَوْقَ الأرْضِ، وَظَهَرَتِ القَوْسُ فِيها، ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","أتَذَكَّرُ العَهْدَ الَّذِي بَينِي وَبَينَكُمْ وَبَينَ كُلِّ كائِنٍ حَيٍّ. وَلَنْ يَصِيرَ الماءُ بَعْدُ طُوفاناً يُهلِكُ كُلَّ حَياةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","فَكُلَّما ظَهَرَتِ القَوْسُ فِي السَّحابِ، أراها وَأذْكُرُ العَهْدَ الأبَدِيَّ بَينَ اللهِ وَبَينَ كُلِّ كائِنٍ حَيٍّ عَلَى الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","وَقالَ اللهُ لِنُوحَ: «هَذِهِ هِيَ عَلامَةُ العَهْدِ بَينِي وَبَينَ كُلِّ حَياةٍ عَلَى الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","وَكانَ بَنُو نُوحَ الَّذِينَ خَرَجُوا مِنَ السَّفِينَةِ سامَ وَحاماً وَيافَثَ. وَحامٌ هُوَ أبُو كَنْعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","كانَ هَؤُلاءِ الثَّلاثَةُ أبْناءَ نُوحَ. وَامْتَلاتِ الأرْضُ بِالنّاسِ مِنْ نَسلِ هَؤُلاءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","وَصارَ نُوحُ فَلّاحاً، فَكانَ أوَّلَ مَنْ غَرَسَ كَرْماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","وَفِي أحَدِ الأيّامِ، صَنَعَ خَمْراً وَشَرِبَ فَسَكِرَ، وَتَعَرَّى فِي خَيمَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","فَرَأى حامُ أبو كَنْعانَ أباهُ عارِياً، فَخَرَجَ وَأخبَرَ أخَوَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","فَأخَذَ سامُ وَيافَثُ رِداءً، وَوَضَعاهُ عَلَى أكتافِهِما. ثُمَّ سارا إلَى الوَراءِ وَسَتَرا أباهُما العارِيَ. وَقَدْ جَعَلا ظَهْريهُما إلَيهِ، فَلَمْ يَرَيا وَالِدَهُما عارِياً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","وَلَمّا أفاقَ نُوحُ مِنْ سُكْرِهِ، عَلِمَ ما فَعَلَهُ ابْنُهُ الأصْغَرُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","فَقالَ: «لِيَكُنْ كَنْعانُ مَلْعُوناً! سَيَكُونُ لِأخَوَيهِ كَأدْنَى عَبْدٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ثُمَّ قالَ: «مُبارَكٌ إلَهُ سامَ. وَلْيَكُنْ كَنْعانُ عَبْداً لِسامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","لَيتَ اللهَ يُوَسِّعُ عَلَى يافَثَ، وَلَيتَهُ يَسْكُنُ فِي خِيامِ سامَ. وَلَيتَ كَنْعانَ يَكُونُ عَبْداً لِيافَثَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","وَعاشَ نُوحُ بَعْدَ الطُّوفانِ ثَلاثَ مِئَةٍ وَخَمْسِينَ سَنَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","فَكانَ عُمْرُهُ تِسْعَ مِئَةٍ وَخَمْسِينَ سَنَةً عِنْدَما ماتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","وَهَذِهِ هِيَ شَجَرَةُ عائِلَةِ أبْناءِ نُوحَ، سامَ وَحامَ وَيافَثَ. وَقَدْ وُلِدَ لَهُمْ أبْناءٌ بَعْدَ الطُّوفانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","أبْناءُ يافَثَ هُمْ جُومَرُ وَماجُوجُ وَمادايُ وَياوانُ وَتُوبالُ وَماشِكُ وَتِيراسُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","وَأبْناءُ جُومَرَ هُمْ أشْكَنازُ وَرِيفاثُ وَتُوجَرْمَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","وَأبْناءُ ياوانَ هُمْ ألِيشَةُ وَتَرْشِيشُ وَكِتِّيمُ وَدُودانِيمُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","وَمِنْ بَنِي يافَثَ هَؤُلاءِ انْتَشَرَتِ الشُّعُوبُ عَلَى طُولِ سَواحِلِ البَحْرِ، وَكَوَّنَتْ بُلْداناً لَها لُغاتُها، حَسَبَ عَشائِرِها وَشُعُوبِها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","وَأبْناءُ حامَ هُمْ كُوشُ وَمِصْرايمُ وَفُوطُ وَكَنْعانُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","وَأبْناءُ كُوشَ هُمْ سَبا وَحَوِيلَةُ وَسَبْتا وَرَعْما وَسَبَتْكا. وَابْنا رَعْمَةَ هُما شَبا وَدَدانُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","وَأنجَبَ كُوشُ نِمْرُودَ. وَكانَ نِمْرُودُ أوَّلَ مُحارِبٍ جَبَّارٍ عَلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","وَكانَ صَيّاداً جَبّاراً فِي حَضرَةِ اللهِ. وَلِهَذا يُضْرَبُ فِيهِ المَثَلُ فَيُقالُ: «هَذا كَنِمْرُودَ، صَيّادٌ جَبّارٌ فِي حَضرَةِ اللهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","بَدَأ نِمْرُودُ مَملَكَتَهُ فِي بابِلَ وَأرَكَ وَأكَّدَ وَكَلْنَةَ فِي أرْضِ شِنْعارَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","وَمِنْ تِلْكَ الأرْضِ دَخَلَ إلَى أشُّورَ. وَهُناكَ بَنَى نِينَوَى، وَرَحُوبُوتَ عِيرَ، وَكالَحَ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","وَرَسَنَ بَينَ نِينَوَى وَكالَحَ. وَكالَحُ هِيَ المَدِينَةُ الكَبِيرَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","وَأنْجَبَ مِصْرايْمُ بَنِي لُودَ وَبَنِي عَنامَ وَبَنِي لَهابَ وَبَنِي نَفْتُوحَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","وَبَنِي فَتْرُوسَ وَبَنِي كَسلُوحَ، الَّذِينَ خَرَجَ مِنْهُمُ الفِلِسْطِيُّونَ، وَبَنِي كَفْتُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","وَأنجَبَ كَنْعانُ ابْنَهُ البِكْرَ صِيدُونَ. وَهُوَ أبُو الحِثِّيِّينَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","وَاليَبُوسِيِّينَ وَالأمُورِيِّينَ وَالجِرْجاشِيِّينَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","وَالحِوِّيِّينَ وَالعَرْقِيِّينَ وَالسِّينِيِّينَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","وَالأرْوادِيِّينَ وَالصَّمّارِيِّينَ وَالحَماثِيِّينَ. وَانتَشَرَتْ فِيما بَعْدُ عَشائِرُ الكَنْعانِيِّينَ فِي بِلادٍ كَثيرَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","وَامتَدَّتْ أرْضُ الكَنْعانِيِّينَ مِنْ صَيدُونَ، فِي اتِّجاهِ جَرارَ، حَتَّى غَزَّةَ، فِي اتِّجاهِ سَدُومَ وَعَمُورَةَ وَأدْمَةَ وَصَبُويِيمَ حَتَّى لاشَعَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","كانَتْ هَذِهِ العَشائِرُ مِنْ نَسلِ حامَ. وَكانَتْ لَها لُغاتُها وَأراضِيها وَشُعُوبُها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","سامُ هُوَ الأخُ الأكْبَرُ لِيافَثَ. وَقَدْ أنْجَبَ سامُ أيضاً، وَمِنْ نَسلِهِ جاءَ عابِرُ أبو جَمِيعِ العِبْرانيينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","فَأبْناءُ سامَ هُمْ عِيلامُ وَأشُّورُ وَأرْفَكْشادُ وَلُودُ وَآرامُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","وَأبْناءُ أرامَ هُمْ عُوصُ وَحُولُ وَجاثَرُ وَماشِكُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","وَأنْجَبَ أرْفَكْشادُ شالَحَ. وَأنْجَبَ شالَحُ عابِرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","وَوُلِدَ لِعابِرَ ابْنانِ: كانَ اسْمُ أوَّلِهِما فالَجُ لأنَّ الأرْضَ قُسِمَتْ فِي أيّامِهِ. وَكانَ لِفالَجَ أخٌ اسْمُهُ يَقْطانُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","وَأنْجَبَ يَقْطانُ ألْمُودادَ وَشالَفَ وَحَضْرَمَوْتَ وَيارَحَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","وَهَدُورامَ وَأُوزالَ وَدِقلَةَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","وَعُوبالَ وَأبِيمايِلَ وَشَبا ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","وَأُوفِيرَ وَحَوِيلَةَ وَيُوبابَ. كانَ هَؤُلاءِ كُلُّهُمْ نَسلَ يَقْطانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","وَسَكَنُوا فِي الرِّيفِ الشَّرْقِيِّ الجَبَلِيِّ، مِنْ مِيشا فِي اتِّجاهِ سَفارَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","هَؤُلاءِ هُمْ نَسلُ سامَ، بِعَشائِرِهِمْ وَلُغاتِهِمْ وَأراضِيهِمْ وَأُمَمِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","هَذِهِ هِيَ أنْسابُ عَشائِرِ بَنِي نُوحَ بِحَسَبِ الأُمَمِ الّتِي كَوَّنُوها. وَمِنْ هَذِهِ العَشائِرِ انتَشَرَ البَشَرُ فِي الأرْضِ بَعْدَ الطُّوفانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","وَلَمْ يَكُنْ فِي الأرْضِ إلّا لُغَةٌ واحِدَةٌ لَها مُفْرَداتٌ مَحْدُودَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","وَمَعَ ارتِحالِ النّاسِ مِنَ الشَّرْقِ، وَجَدُوا سَهلاً فِي أرْضِ شِنْعارَ. فَاسْتَقَرُّوا هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","فاتَّفَقُوا وَقالُوا: «لِنَصْنَعْ لِبْناً وَنَشْوِيهِ جَيِّداً حَتَّى نُقَسِّيهِ.» فَاسْتَخدَمُوا بَدَلَ الحِجارَةِ لِبْناً، وَبَدَلَ الطِّينِ قاراً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ثُمَّ قالُوا: «لِنَبْنِ لَنا مَدِينَةً، وَبُرْجاً تَصِلُ قِمَّتُهُ إلَى السَّماءِ. وَهَكَذا نَكْتَسِبُ شُهْرَةً. وَإلّا، فَإنَّنا سَنَتَشَتَّتُ عَلَى وَجْهِ الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","وَنَزَلَ اللهُ لِيَرَى المَدِينَةَ وَالبُرْجَ اللَّذَينِ بَناهُما النّاسُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","وَقالَ اللهُ: «ها إنَّهُمْ شَعبٌ وَاحِدٌ يَتَكَلَّمُونَ لُغَةً واحِدَةً. وَما هَذِهِ إلّا البِدايَةُ. لا يَصْعُبُ عَلَيهِمْ شَيءٌ يَنْوُونَ عَمَلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","فَهَيّا نَنْزِلْ وَنُبَلْبِلْ لُغَتَهُمْ، فَلا يَعُودُ بَعْضُهُمْ يَفْهَمُ لُغَةَ بَعْضٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","فَشَتَّتَهُمُ اللهُ مِنْ هُناكَ عَلَى سَطْحِ الأرْضِ كُلِّها. فَتَوَقَّفَ بِناءُ المَدِينَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","وَلِهَذا سُمِّيَتِ المَدِينَةُ بابِلَ، لأنَّ اللهَ بَلْبَلَ هُناكَ لُغَةَ الأرْضِ كُلِّها. وَمِنْ هُناكَ، شَتَّتَهُمُ اللهُ عَلَى وَجهِ الأرْضِ كُلِّها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","هَذا سِجِلُّ مَوالِيدِ سامَ. عِنْدَما كانَ عُمْرُ سامَ مِئَةَ سَنَةٍ، أنْجَبَ أرْفَكْشادَ. وَكانَ هَذا بَعْدَ سَنَتَينِ مِنَ الطُّوفانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","وَعاشَ سامُ خَمْسَ مِئَةِ سَنَةٍ بَعْدَ وِلادَةِ أرْفَكْشادَ. وَقَدْ أنجَبَ بَنِينَ آخَرِينَ وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","وَلَمّا بَلَغَ أرْفَكْشادُ خَمْساً وَثَلاثِينَ سَنَةً أنجَبَ شالَحَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","وَعاشَ أرْفَكْشادُ بَعْدَ وِلادَةِ شالَحَ أرْبَعَ مِئَةٍ وَثَلاثَ سِنِينَ أنجَبَ خِلالَها بَنِينَ آخَرِينَ وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","وَلَمّا بَلَغَ شالَحُ ثَلاثِينَ سَنَةً، أنْجَبَ عابِرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","وَعاشَ شالَحُ بَعْدَ مَولِدِ عابِرَ أرْبَعَ مِئَةٍ وَثَلاثَ سِنِينَ أنجَبَ خِلالَها بَنِينَ آخَرِينَ وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","وَلَمّا بَلَغَ عابِرُ أرْبَعاً وَثَلاثِينَ سَنَةً، أنْجَبَ فالَجَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","وَعاشَ عابِرُ بَعْدَ مَولِدِ فالَجَ أرْبَعَ مِئَةٍ وَثَلاثِينَ سَنَةً أنْجَبَ خِلالَها بَنِينَ آخَرِينَ وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","وَلَمّا بَلَغَ فالَجُ ثَلاثِينَ سَنَةً، أنْجَبَ رَعُواً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","وَعاشَ فالَجُ بَعْدَ مَولِدِ رَعُوٍ مِئَتَينِ وَتِسْعَ سِنِينَ أنجَبَ خِلالَها بَنِينَ آخَرِينَ وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","وَلَمّا بَلَغَ رَعُوٌ اثْنَتَينِ وَثَلاثِينَ سَنَةً، أنْجَبَ سَرُوجَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","وَعاشَ رَعُوٌ بَعْدَ مَولِدِ سَرُوجَ مِئَتَينِ وَسَبْعَ سِنِينَ أنْجَبَ خِلالَها بَنِينَ آخَرِينَ وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","وَلَمّا بَلَغَ سَرُوجُ ثَلاثِينَ سَنَةً، أنْجَبَ ناحُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","وَعاشَ سَرُوجُ بَعْدَ مَولِدِ ناحُورَ مِئَتَي سَنَةٍ أنْجَبَ خِلالَها بَنِينَ آخَرِينَ وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","وَلَمّا بَلَغَ ناحُورُ تِسْعاً وَعِشْرِينَ سَنَةً، أنْجَبَ تارَحَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","وَعاشَ ناحُورُ بَعْدَ مَولِدِ تارَحَ مِئَةً وَتِسْعَ عَشْرَةَ سَنَةً، أنجَبَ خِلالَها بَنِينَ آخَرِينَ وَبَناتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","وَلَمّا بَلَغَ تارَحُ سَبْعِينَ سَنَةً، أنْجَبَ أبْرامَ وَناحُورَ وَهارانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","هَذا سِجِلُّ مَوالِيدِ عائِلَةِ تارَحَ. أنْجَبَ تارَحُ أبْرامَ وَناحُورَ وَهارانَ. وَأنْجَبَ هارانُ لُوطَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","وَماتَ هارانُ قَبلَ أبِيهِ تارَحَ فِي أرْضِ مَولِدِهِ – فِي أُورِ الكِلْدانِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","وَتَزَوَّجَ كُلٌّ مِنْ أبْرامَ وَناحُورَ. وَكانَ اسْمُ زَوْجَةِ أبْرامَ سارايَ. وَكانَ اسْمُ زَوْجَةِ ناحُورَ مِلْكَةَ. وَكانَتْ مِلْكَةُ ابْنَةَ هارانَ. وَكانَ هارانُ قَدْ أنْجَبَ مِلْكَةَ وَيِسْكَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","وَكانَتْ سارايُ عاقِراً وَلَيسَ لَها ابْنٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","وَأخَذَ تارَحُ ابْنَهُ أبْرامَ، وَحَفِيدَهُ لُوطَ، ابْنَ ابْنِهِ هارانَ، وَكَنَّتَهُ سارايَ، زَوْجَةَ ابْنِهِ أبْرامَ، وَتَرَكُوا أُورَ الكِلْدانِيِّينَ لِيَتَّجِهُوا إلَى أرْضِ كَنْعانَ. لَكِنَّهُمْ لَمّا وَصَلُوا حارانَ، اسْتَقَرُّوا هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","وَعاشَ تارَحُ مِئَتَينِ وَخَمْسَ سَنَواتٍ. ثُمَّ ماتَ فِي حارانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","وَقالَ اللهُ لِأبْرامَ: «اتْرُكْ بَلَدَكَ وَشَعبَكَ وَعائِلَةَ أبِيكَ، وَاذْهَبْ إلَى الأرْضِ الَّتِي سَأُرِيها أنا لَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","وَأنا سَأجْعَلُ مِنْ نَسلِكَ أُمَّةً عَظِيمَةً. وَسَأُبارِكُكَ، وَسَأجْعَلُ لَكَ اسْماً شَهِيراً، فَتَكُونَ بَرَكَةً لِلآخَرِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","سَأُبارِكُ مَنْ يُبارِكُونَكَ، وَسَألْعَنُ مَنْ يَحتَقِرُونَكَ. وَبِكَ تَتَبارَكُ كُلُّ عَشَائِرِ الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","فَذَهَبَ أبْرامُ كَما أمَرَهُ اللهُ. وَرافَقَهُ لُوطُ. وَكانَ أبْرامُ فِي الخامِسَةِ وَالسَّبْعِينَ مِنْ عُمْرِهِ عِنْدَما تَرَكَ حارانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","وَأخَذَ أبْرامُ مَعَهُ زَوْجَتَهُ سارايَ وَابْنَ أخِيهِ لُوطَ، وَكُلَّ المُقْتَنَياتِ الَّتِي جَمَعُوها. كَما أخَذَ مَعَهُ كُلَّ خَدَمِهِمْ فِي حارانَ، وَغادَرُوا المَكانَ إلَى أرْضِ كَنْعانَ. فَوَصَلُوا إلَى أرْضِ كَنْعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","وَاجتازَ أبْرامُ عَبْرَ الأرْضِ حَتَّى وَصَلَ إلَى شَكِيمَ، أوْ بَلُّوطَةِ مُورَةَ. وَكانَ الكَنْعانِيُّونَ يَسْكُنُونَ تِلْكَ الأرْضَ فِي ذَلِكَ الحِينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","وَظَهَرَ اللهُ لِأبْرامَ وَقالَ لَهُ: «سَأُعطِي هَذِهِ الأرْضَ لِنَسلِكَ.» فَبَنَى أبْرامُ هُناكَ مَذْبَحاً للهِ الَّذِي ظَهَرَ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ثُمَّ انْتَقَلَ أبْرامُ مِنْ هُناكَ إلَى الجِبالِ شَرْقِيِّ بَيتَ إيلَ. وَنَصَبَ هُناكَ خَيمَتَهُ. وَكانَتْ بَيتُ إيلَ إلَى الغَرْبِ، وَعايُ إلَى الشَّرْقِ. فَبَنَى أبْرامُ هُناكَ مَذْبَحاً للهِ، وَصَلَّى بِاسمِ اللهَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ثُمَّ ارْتَحَلَ أبْرامُ عَلَى مَراحِلَ نَحْوَ صَحْراءِ النَّقَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ثُمَّ حَدَثْتْ مَجاعَةٌ فِي الأرْضِ. فَنَزَلَ أبْرامُ إلَى مِصْرَ لِيَسْكُنَ هُناكَ بَعْضَ الوَقْتِ، لأنَّ المَجاعَةَ كانَتْ شَدِيدَةً فِي البِلادِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","وَقُبَيلَ دُخُولِ أبْرامَ إلَى مِصْرَ، قالَ لِزَوْجَتِهِ سارايَ: «اسْمَعِي، أنا أعلَمُ أنَّكِ امْرأةٌ جَمِيلَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","فَحِينَ يَراكِ المِصْرِيُّونَ سَيَقُولُونَ: ‹هَذِهِ المَرأةُ هِيَ زَوْجَتُهُ، فَيَقْتُلُونَنِي، وَيُبْقُونَ عَلَى حَياتِكِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","قُولِي إنَّكِ أُخْتِي، فَيُعامِلُونِي مُعامَلَةً حَسَنَةً بِسَبَبِكِ، وَأنْجُ مِنَ المَوْتِ بِفَضلِكِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","فَلَمّا دَخَلَ أبْرامُ مِصْرَ، رَأى المِصْرِيُّونَ أنَّها جَمِيلَةٌ جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","وَعِنْدَما رَآها بَعْضُ المَسْؤُولِينَ لَدَى فِرعَوْنَ، أخْبَرُوهُ عَنْ مَدَى جَمالِها. فَأمَرَ فِرعَوْنُ بِإحضارِها إلَى بَيتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","وَأحْسَنَ فِرعَوْنُ مُعامَلَةَ أبْرامَ بِسَبَبِها. إذْ أعطاهُ غَنَماً وَبَقَراً وَحَمِيراً وَأُتُناً وَجِمالاً، وَخَدَماً وَخادِماتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","لَكِنَّ اللهَ ضَرَبَ فِرعَوْنَ وَأهلَ بَيتِهِ بِأمْراضٍ شَدِيدَةٍ بَسَبَبِ سارايَ، زَوْجَةِ أبْرامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","فَاسْتَدْعَى فِرعَوْنُ أبْرامَ، وَقالَ لَهُ: «ما هَذا الَّذِي فَعَلْتَهُ لِماذا لَمْ تَقُلْ إنَّها زَوْجَتُكَ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","لِماذا قُلْتَ إنَّها أُخْتُكَ، فَأخَذْتُها أنا لِتَكُونَ لِي زَوْجَةً؟ ها هِيَ زَوْجَتُكَ. خُذْها وَانصَرِفْ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","وَأمَرَ فِرعَوْنُ رِجالَهُ بِحِمايَةِ أبْرامَ، فَرافَقُوهُ فِي طَرِيقِهِ مَعَ زَوْجَتِهِ وَكُلِّ ما كانَ لَدَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","فَخَرَجَ أبْرامُ مِنْ مِصْرَ إلَى النَّقَبِ مَعَ زَوْجَتِهِ وَكُلِّ ما كانَ لَدَيهِ، وَمَعَ لُوطَ أيضاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","وَكانَ أبْرامُ غَنِيّاً جِدّاً بِالماشِيَةِ وَالفِضَّةِ وَالذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","وَارْتَحَلَ عَلَى مَراحِلَ مِنَ النَّقَبِ إلَى بَيتَ إيلَ. وَوَصَلَ إلَى المَكانِ الَّذِي كانَتْ فِيهِ خَيمَتُهُ فِي البِدايَةِ، أي بَينَ بَيتَ إيلَ وَعايَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","وَهُوَ المَكانُ الَّذِي كانَ قَدْ بَنَى فِيهِ المَذْبَحَ. وَدَعا أبْرامُ بِاسمِ اللهَ هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","وَكانَ لِلُوطَ الَّذِي يَصْحَبُ أبْرامَ فِي تَرْحالِهِ غَنَمٌ وَبَقَرٌ وَخِيامٌ كَأبْرامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","فَلَمْ تَقْدِرِ الأرْضُ أنْ تَعُولَهُما وَهُما يَسْكُنانِ مَعاً، لأنَّ مُقْتَنَياتِهِما كانَتْ كَثِيرَةً جِدّاً. فَلَمْ يَعُودا قادِرَينَ عَلَى السَّكَنِ مَعاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","وَقامَتْ مُنازَعاتٌ بَينَ رُعاةِ أبْرامَ وَرُعاةِ لُوطَ. وَكانَ الكَنْعانِيُّونَ وَالفَرِزِّيُّونَ يَسْكُنُونَ فِي البِلادِ أيضاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","فَقالَ أبْرامُ لِلُوطَ: «لا داعِيَ لأنْ تَقُومَ مُنازَعاتٌ بَينِي وَبَينَكَ، أوْ بَينَ رُعاتِي وَرُعاتِكَ، فَنَحْنُ قَرِيبانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","فَها هِيَ الأرْضُ كُلُّها أمامَكَ لِتَخْتارَ مِنْها. وَلْيَنفَصِلْ أحَدُنا عَنِ الآخَرِ. إنْ اتَّجَهْتَ شِمالاً، فَسَأتَّجِهُ يَمِيناً. وَإنْ اتَّجَهْتَ يَمِيناً، فَإنِّي سَأتَّجِهُ شِمالاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","فَنَظَرَ لُوطُ حَولَهُ، وَرَأى أنَّ وادِيَ الأُرْدُنِّ كُلَّهُ حَتَّى صُوغَرَ حَسَنُ السِّقايَةِ كَحَدِيقَةِ اللهِ، أوْ كَأرْضِ مِصْرَ – كانَ هَذا قَبلَ أنْ يُدَمِّرَ اللهُ مَدِينَتِي سَدُومَ وَعَمُورَةَ – ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","وَاختارَ لُوطُ لِنَفْسِهِ كُلَّ وادِي الأُرْدُنِّ. فارْتَحَلَ لُوطُ شَرْقاً، وَانفَصَلَ أحَدُهُما عَنِ الآخَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","وَسَكَنَ أبْرامُ فِي أرْضِ كَنْعانَ. وَأمّا لُوطُ فَسَكَنَ فِي مُدُنِ وادِي الأُرْدُنِّ، وَقَرَّبَ خَيمَتَهُ مِنْ مَدِينَةِ سَدُومَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","وَكانَ أهلُ سَدُومَ أشْراراً وَخُطاةً جِدّاً أمامَ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","وَقالَ اللهُ لِأبْرامَ بَعْدَ أنِ انْفَصَلَ لُوطُ عَنْهُ: «انْظُرْ حَولَكَ، وَتَطَلَّعْ مِنَ المَكانِ الَّذِي أنْتَ فِيهِ شَمالاً وَجَنُوباً وَشَرْقاً وَغَرْباً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","أتَرَى كُلَّ هَذِهِ الأرْضِ؟ سَأُعْطِيها لَكَ وَلِأحفادِكَ مُلْكاً إلَى الأبَدِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","وَسَأجْعَلُ أحفادَكَ بِعَدَدِ حَبّاتِ تُرابِ الأرْضِ. فَإنِ استَطاعَ إنسانٌ أنْ يُحصِيَ حَبّاتِ تُرابِ الأرْضِ، يَستَطِيعُ عِندَ ذَلِكَ أنْ يُحصِيَ أفرادَ نَسلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","اذْهَبْ وَتَجَوَّلْ فِي هَذِهِ الأرْضِ كُلِّها طُولاً وَعَرْضاً، لِأنِّي سَأُعطِيها لَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","فَحَلَّ أبْرامُ خِيامَهُ وَذَهَبَ لِيَسْتَقِرَّ عِنْدَ بَلُّوطاتِ مَمْرا فِي مَدِينَةِ حَبْرُونَ. وَهُناكَ بَنَى مَذْبَحاً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","وَفِي أيّامِ أمْرافَلَ مَلِكِ شِنْعارَ، وَأرْيُوكَ مَلِكِ ألّاسارَ، وَكَدَرلَعَومَرَ مَلِكِ عِيلامَ، وَتِدْعالَ مَلِكِ جُويِيمَ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","شَنَّ هَؤُلاءِ المُلُوكُ حَرْباً عَلَى بارَعَ مَلِكِ سَدُومَ، وَبِرْشاعَ مَلِكِ عَمُورَةَ، وَشِنْآبَ مَلِكِ أدْمَةَ، وَشِمْئِيبَرَ مَلِكِ صَبُويِيمَ، وَمَلِكِ بالَعَ الَّتِي تُدْعَى أيضاً صُوغَرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","تَحالَفَ هَؤُلاءِ المُلُوكُ وَاجتَمَعُوا فِي وادِي السَّدِيمِ. وَهُوَ يُدْعَى الآنَ بَحرُ المِلحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","خَضَعُوا لِكَدَرلَعُومَرَ اثْنَتَي عَشْرَةَ سَنَةً. لَكِنَّهُمْ تَمَرَّدُوا عَلَيهِ فِي السَّنَةِ الثّالِثَةَ عَشْرَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","وَفِي السَّنَةِ الرّابِعَةَ عَشْرَةَ جاءَ كَدَرلَعُومَرُ وَالمُلُوكُ مَعَهُ، وَهَزَمُوا الرِّفائِيِّينَ فِي عَشْتارُوثَ قَرْنايِيمَ. كَما هَزَمُوا الزُّوزِيِّينَ فِي هامَ. وَهَزَمُوا الإيمِيِّينَ فِي شَوَى قِرْياتايِمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","وَهَزَمُوا الحُورِيِّينَ فِي جِبالِ سَعِيرَ وَحَتَّى فارانَ. وَتَقَعُ فارانُ عَلَى حافَّةِ الصَّحْراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ثُمَّ رَجِعَ كَدَرلَعُومَرُ وَالمُلُوكُ الَّذِينَ مَعَهُ، وَوَصَلُوا إلَى عَينِ مِشْفاطَ، أي قادِشَ. وَأخضَعُوا كُلَّ بِلادِ العَمالِقَةِ وَأيضاً الأمُورِيِّينَ الَّذِينَ يَسْكُنُونَ فِي حَصُّونَ ثامارَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ثُمَّ خَرَجَ مُلُوكُ سَدُومَ وَعَمُورَةَ وَأدْمَةَ وَصَبُويِيمَ وَبالَعَ، وَحَشَدُوا قُوّاتِهِمْ لِلمَعْرَكَةِ فِي وادِي السِّدِّيمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","وَحارَبُوا كَدَرلَعُومَرَ مَلِكَ عِيلامَ، وَتِدْعالَ مَلِكَ جُويِيمَ، وَأمْرافَلَ مَلِكَ شِنْعارَ، وَأرْيُوكَ مَلِكَ ألّاسارَ. فَكانَ هُناكَ أرْبَعَةُ مُلُوكٍ ضِدَّ خَمْسَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","وَكانَ وادِي السِّدِّيمِ مَلِيئاً بِحُفَرِ القارِ. فَلَمّا هَرَبَ مَلِكا سَدُومَ وَعَمُورَةَ وَجُيُوشُهُما، وَقَعَ بَعْضُهُمْ فِيها. أمّا الآخَرُونَ فَهَرَبُوا إلَى الجِبالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","فَغَنِمَ كَدَرلَعُومَرُ وَحُلَفاؤُهُ كُلَّ مُقْتَنَياتِ سَدُومَ وَعَمُورَةَ وَكُلَّ ما فِيها مِنْ طَعامٍ، ثُمَّ مَضُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","وَبِما أنْ لُوطَ ابْنَ أخِي أبْرامَ كانَ يَسْكُنُ فِي سَدُومَ، أخَذُوهُ أيضاً وَكُلَّ مُقْتَنَياتِهِ وَمَضُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","فَهَرَبَ أحَدُهُمْ وَجاءَ إلَى إبْراهِيمَ العِبْرانِيِّ وَأخْبَرَهُ بِما جَرَى. وَكانَ أبْرامُ ساكِناً قُرْبَ بَلُّوطاتِ مَمْرا الأمُورِيِّ، أخِي أشْكُولَ وَعانِرَ. وَكانَ هَؤُلاءِ مُرْتَبِطِينَ بِعَهْدٍ مَعَ أبْرامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","فَلَمّا سَمِعَ أبْرامُ أنَّ قَرِيبَهُ أُسِرَ، جَمَعَ رِجالَهُ المُدَرَّبِينَ الَّذينَ وُلِدُوا فِي بَيتِهِ – وَعَدَدُهُمْ ثَلاثُ مِئَةٍ وَثَمانِيَةَ عَشْرَةَ رَجُلاً – وَلَحِقَ بِالعَدُوِّ حَتَّى دانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","وَفِي اللَّيلِ قَسَمَ خَدَمَهُ إلَى قِسْمَينِ. فَهَجَمُوا عَلَى الأعْداءِ وَهَزَمُوهُمْ. وَطارَدُوهُمْ حَتَّى حُوبَةَ شَمالَ دِمْشْقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","وَتَمَكَّنَ مِنَ اسْتِرْجاعِ كُلِّ المُقْتَنَياتِ. كَما اسْتَرْجَعَ لُوطَ وَمُمْتَلَكاتِهِ. وِاسْتَرَدَّ أيضاً النِّساءَ وَبَقِيَّةَ الأسْرَى. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","وَبَعْدَ عَوْدَةِ أبْرامَ مِنَ المَعْرَكَةِ الَّتِي هَزَمَ فِيها كَدَرلَعُومَرَ وَالمُلُوكَ الَّذِينَ مَعَهُ، خَرَجَ مَلِكُ سَدُومَ لِمُلاقاتِهِ فِي وادِي شَوَى، أي وادِي المَلِكِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","وَكانَ مَلْكِيصادَقُ مَلِكاً عَلَى سالِيمَ. وَقَدْ أخَذَ خُبْزاً وَنَبيذاً – إذْ كانَ كاهِناً للهِ العَلِيِّ – ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","وَبارَكَ أبْرامَ وَقالَ: «مُبارَكٌ أبْرامُ مِنَ اللهِ العَلِيِّ الَّذِي صَنَعَ السَّماءَ وَالأرْضَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","وَمُبارَكٌ اللهُ العَلِيُّ الَّذِي نَصَرَكَ عَلَى أعْدائِكَ.» وَأعطَى أبْرامُ مَلْكِيصادَقَ عُشْراً مِنْ كُلِّ ما غَنِمَهُ مِنَ الحَرْبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ثُمَّ قالَ مَلِكُ سَدُومَ لِأبْرامَ: «رُدَّ لِي أسْرايَ، وَاحتَفِظْ لِنَفْسِكَ بِمُقْتَنَياتِنا الَّتِي غَنِمْتَها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","فَقالَ أبْرامُ لِمَلِكِ سَدُومَ: «رَفَعْتُ يَدِي إلَى اللهِ العَلِيِّ الَّذِي صَنَعَ السَّماءَ وَالأرْضَ، وَعاهَدْتُهُ ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","أنْ لا آخُذَ مِنْكَ وَلَوْ خَيطاً أوْ رِباطَ حِذاءٍ. حَتَّى لا تَقُولَ: ‹أغْنَيتُ أبْرامَ.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","سَأعْتَبِرُ أنَّ نَصيبي هُوَ ما أكَلَهُ هَؤُلاءِ الفِتْيانُ. أمّا الرِّجالُ الَّذِينَ جاءُوا مَعِي: عانِرُ وَأشْكُولُ وَمَمْرا، فَلْيَأْخُذُوا نَصِيبَهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","بَعْدَ هَذِهِ الأحْداثِ كَلَّمَ اللهُ أبْرامَ فِي رُؤْيا: «لا تَخَفْ، يا أبْرَامُ. فَأنا تُرْسُكَ وَمُكافأتُكَ العَظِيمَةُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","فَقالَ أبْرَامُ: «يا اللهُ، ما الَّذِي سَتُعْطِينِي إيّاهُ، وَأنا باقٍ عَلَى هَذا الحالِ بِلا ابْنٍ. وَوَرِيثُ بَيتِي إلَى الآنَ هُوَ ألِيعازَرُ الدِّمَشْقِيُّ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","وَقالَ أبْرامُ: «فَها أنْتَ لَمْ تُعْطِنِي أبْناءً. وَلِهَذا فَإنَّ عَبْداً وُلِدَ فِي بَيتِي سَيَرِثُنِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","فَجاءَتْ كَلِمَةُ اللهُ لَهُ: «لَنْ يَكُونَ ألِيعازَرُ هَذا وَرِيثَكَ، بَلِ ابْنُكَ أنْتَ هُوَ الَّذِي سَيَرِثُكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ثُمَّ أخْرَجَهُ خارِجاً وَقالَ لَهُ: «انْظُرْ إلَى السَّماءِ، وَعُدَّ النُّجُومَ إنِ اسْتَطَعْتَ.» ثمَ قالَ لَهُ: «هَكَذا سَيَكُونُ نَسلُكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","فَآمَنَ بِاللهِ، فاعْتَبَرَ اللهُ إيمانَهُ بِرّاً لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","وَقالَ لَهُ: «أنا هُوَ اللهُ الَّذِي أخْرَجَكَ مِنْ أُورِ الكِلْدانِيِّينَ لِيُعْطِيكَ هَذِهِ الأرْضَ مُلْكاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","فَقالَ أبْرامُ: «يا اللهُ، أيَّةَ عَلامَةٍ تُعْطِينِي لِأعْرِفَ أنِّي سَأمْتَلِكُها؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","فَقالَ اللهُ لِأبْرامَ: «خُذْ لِي عِجلاً عُمْرُهُ ثَلاثُ سِنِينٍ، وَعَنْزَةً عُمْرُها ثَلاثُ سِنِينٍ، وَكَبْشاً عُمْرُهُ ثَلاثُ سِنِينٍ، وَيَمامَةً واحِدَةً وَحَمامَةً صَغِيرَةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","فَأخَذَ أبْرامُ كُلَّ هَذِهِ، وَشَقَّها مِنَ الوَسَطِ. ثُمَّ وَضَعَ كُلَّ نِصْفٍ مُقابِلَ الآخَرِ. لَكِنْ لَمْ يَشُقَّ الطَّيرَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","وَفِيما بَعْدُ نَزَلَتْ طُيُورٌ كاسِرَةٌ عَلَى الجُثَثِ لِتَأكُلَها. فَطَرَدَها أبْرامُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","وَلَمّا أخَذَتِ الشَّمْسُ فِي المَغِيبِ، وَقَعَ عَلَى أبْرامَ نَوْمٌ عَمِيقٌ، كَما وَقَعَتْ عَلَيهِ ظُلْمَةٌ مُرْعِبَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","فَقالَ الله لأبرامَ: «اعلَمْ أنْ نَسلَكَ سَيَكُونُونَ غُرَباءَ فِي بَلَدٍ غَيرِ بَلَدِهِمْ. وَسَيُسْتَعْبَدُونَ لِأهلِ ذَلِكَ البَلَدِ، حَيثُ سَيُضَّهَدونَ مُدَّةَ أرْبَعِ مِئَةِ سَنَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","لَكِنِّي سأُعاقِبُ الأُمَّةَ الَّتِي سَتَسْتَعْبِدُهُمْ. وَبَعْدَ ذَلِكَ سَيَخْرُجُونَ مِنْ تِلكَ الأرْضِ وَمَعَهُمْ مُقْتَنَياتٌ كَثيرَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","«أمّا أنتَ فَسَتَعِيشُ إلَى شَيخُوخَةٍ صالِحَةٍ. ثُمَّ تَمُوتُ فِي سَلامٍ، وَتُدفَنُ مَعَ آبائِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ثًمَّ سَيَعُودُ نَسلُكَ إلَى هُنا بَعْدَ أرْبَعَةِ أجيالٍ. فَقَبلَ ذَلِكَ الوَقتِ، لَنْ تَكُونَ آثامُ الأمُّورِيِّينَ قَدْ بَلَغَتْ حّدَّها لِعِقابِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","وَهَكَذا إذْ غَرَبَتِ الشَّمْسُ وَسادَ الظَّلامُ، ظَهَرَ إناءُ جَمْرٍ يُخْرِجُ دُخاناً، وَاجْتازَتْ شُعلَةٌ مُلْتَهِبَةٌ بَينَ أجْزاءِ الحَيواناتِ المُقَطَّعَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","فِي ذَلِكَ اليَوْمِ قَطَعَ اللهُ عَهْداً مَعَ أبْرامَ فَقالَ: «لِنَسلِكَ سَأُعْطِي هَذِهِ الأرْضِ، مِنْ نَهْرِ مِصْرَ إلَى النَّهْرِ العَظِيمِ، نَهْرِ الفُراتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","وَسَأُعطِيهِمْ أرْضَ القِينِيِّينَ وَالقَنِزِّيِّينَ وَالقَدْمُونِيِّينَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","وَالحِثِّيِّينَ وَالفَرِزِّيِّينَ وَالرَّفائِيِّينَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","وَالأمُورِيِّينَ وَالكَنْعانِيِّينَ وَالجَرْجاشِيِّينَ وَاليَبُوسِيِّينَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","وَأمّا سارايُ، زَوْجَةُ أبْرامَ، فَلَمْ تَكُنْ قَدْ أنْجَبَتْ لَهُ أبْناءً. وَكانَ لَها جارِيَةٌ مِصْرِيَّةٌ اسْمُها هاجَرُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","فَقالَتْ سارايُ لِأبْرامَ: «ها أنْتَ تَرَى أنَّ اللهَ حَرَمَنِي مِنَ القُدْرَةِ عَلَى الإنْجابِ، فَعاشِرْ جارِيَتِي. وَسَأبْنِي عائِلَتِي مِنْ أولادِها.» فَوافَقَ أبْرامُ امْرَأتَهُ عَلَى رَأيِها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","فَبَعْدَ أنْ مَضَتْ عَشْرُ سَنَواتٍ عَلَى سَكَنِ أبْرامَ فِي أرْضِ كَنْعانَ، قَدَّمَتْ سارايُ، زَوْجَةُ أبْرامَ، جارِيَتَها المِصْرِيَّةَ هاجَرَ زَوْجَةً لِزَوْجِها أبْرامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","فَعاشَرَ أبْرامُ هاجَرَ فَحَبِلَتْ. وَلَمّا رَأتْ هَاجَرُ أنَّها حَبِلَتْ، صَغُرَتْ سَيِّدَتُها سارايُ فِي عَينَيها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","فَقالَتْ سارايُ لِأبْرامَ: «أنتَ المَلُومُ فِي ما أُسِيئَ بِهِ إلَيَّ. أنا نَفْسِي الَّتِي وَضَعْتُها بَينَ يَدَيكَ، فَلَمّا حَبِلَتْ، صارَتْ تَحتَقِرُنِي. لِيَحْكُمِ اللهُ بَينِي وَبَينَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","فَقالَ أبْرامَ لِسارايَ: «ما هِيَ إلّا خادِمَةٌ عِنْدَكِ، وَهِيَ تَحْتَ سُلطَتِكِ. فافْعَلِي بِها كَما يَحلُو لَكِ.» فَأساءَتْ سارايُ مُعامَلَةَ هاجَرَ، فَهَرَبَتْ مِنْها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","وَجَلَسَتْ هاجَرُ عِنْدَ نَبْعٍ فِي الصَّحْراءِ عَلَى الطَّرِيقِ إلَى شُورَ. فَجاءَها مَلاكُ اللهِ إلَى هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","وَقالَ لَها: «يا هاجَرُ، يا جارِيَةَ سارايَ، مِنْ أينَ جِئْتِ؟ وَإلَى أينَ تَمْضِينَ؟» فَقالَتْ: «أنا هارِبَةٌ مِنْ سَيِّدَتِي سارايَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","فَقالَ لَها مَلاكُ اللهِ: «عُودِي إلَى سَيِّدَتِكِ، وَاخضَعِي لَها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","وَأضافَ مَلاكُ اللهِ: «سَأُكَثِّرُ نَسلَكِ تَكْثِيراً، فَلا يُعَدُّونَ لِكَثْرَتِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","«وَقالَ لَها مَلاكُ اللهِ: «ها أنْتِ حُبلَى، وَسَتَلِدِينَ ابْناً، وَسَيَكُونُ اسْمُهُ إسْماعِيلَ. فَاللهُ قَدْ سَمِعَ مِحْنَتَكِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","سَيَهِيمُ ابْنُكِ كَحِمارٍ وَحشِيٍّ. وَسَتَكُونُ يَدُهُ عَلَى جَميعِ المُحيطينَ بِهِ، وَيَدُ المُحيطينَ بِهِ عَلَيهِ. وَسَيَنْصُبُ خِيامَهُ فِي مُواجَهَةِ إخْوَتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","وَنادَتْ هاجَرُ اللهَ الَّذِي كَلَّمَها وَقالَتْ: «أنتَ الإلَهُ البَصِيرُ.» إذْ قالَتْ: «أحَقّاً أبصَرْتُ ذاكَ الَّذِي أبصَرَنِي؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","فَسُمِّيَتْ تِلْكَ البِئْرُ «بِئْرَ لَحَي رُئِي.» وَهِيَ تَقَعُ بَينَ قادِشَ وَبارَدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","وَأنْجَبَتْ هاجَرُ ابْناً لأبْرامَ. فَسَمّاهُ أبْرَامُ إسْماعِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","وَكانَ أبْرامُ فِي السّادِسَةِ وَالثَّمانِينَ مِنْ عُمْرِهِ عِنْدَما أنْجَبَتْ هاجَرُ إسْماعِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","وَلَمّا بَلَغَ أبْرامُ التّاسِعَةَ وَالتِّسْعِينَ مِنْ عُمْرِهِ، ظَهَرَ لَهُ اللهُ. وَقالَ لَهُ: «أنا اللهُ الجَبّارُ. أطِعْنِي وَعِشْ حَياةً خالِيَةً مِنْ كُلِّ شائِبَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","فَإنْ فَعَلْتَ هَذا، سَأقْطَعُ عَهْداً بَينِي وَبَينَكَ. وَسَأُعطِيكَ نَسلاً كَثِيراً جِدّاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","فَسَجَدَ أبْرامُ. فَقالَ لَهُ اللهُ: ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«أمّا أنا، فَهَذا هُوَ عَهْدِي مَعَكَ: سَتَكُونُ أصلَ شُعُوبٍ كَثِيرَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","وَلَنْ يَكُونَ اسْمُكَ فِيما بَعْدُ أبْرامَ، بَلْ إبْراهِيمَ. فَقَدْ جَعَلْتُكَ أباً لِشُعُوبٍ كَثِيرَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","سَأُكَثِّرُ نَسلَكَ، حَتِّى إنِّي سَأجْعَلُ شُعُوباً كَثِيرَةً تَخرُجُ مِنْكَ. وَسَيَخرُجُ مِنْكَ مُلُوكٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","وَسَأقْطَعُ عَهْداً أبَدِيّاً بَينِي وَبَينَكَ وَبَينَ نَسلِكَ مِنْ بَعْدِكَ عَلَى مَدَى الأجْيالِ. فَأنا أتَعَهَّدُ بِأنْ أكُونَ إلَهاً لَكَ وَلِنَسلِكَ مِنْ بَعْدِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","وَسَأُعْطِيكَ وَنَسلَكَ مِنْ بَعْدِكَ الأرْضَ الَّتِي تَتَغَرَّبُ فِيها الآنَ، أرْضَ كَنْعانَ كُلَّها. سَأُعْطِيها لَكَ وَلَهُمْ مَقْتَنَىً أبَدِيّاً. وَسَأكُونُ لَهُمْ إلَهاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ثُمَّ قالَ اللهُ لإبْراهِيمَ: «أمّا أنْتَ فاحفَظْ عَهْدِي، أنْتَ وَكُلُّ نَسلِكَ عَلَى مَدَى الأجْيالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","وَهَذا هُوَ عَهْدِي الَّذِي يَنْبَغِي أنْ تَحفَظُوهُ. هَذا هُوَ العَهْدُ بَينِي وَبَينَكَ وَبَينَ نَسلِكَ مِنْ بَعْدِكَ: عَلَى كُلِّ ذَكَرٍ بَينَكُمْ أنْ يُختَنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","اختِنُوا لَحْمَ غُرلَتِكُمْ. هَذِهِ هِيَ العَلامَةُ الَّتِي تَقْبَلُونَها لِلعَهْدِ بَينِي وَبَينَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","عَلَى كُلِّ ذَكَرٍ ابْنِ ثَمانِيَةِ أيّامٍ أنْ يُخْتَتَنَ عَلَى مَدَى أجْيالِكُمْ. كَما يَنْبَغِي أنْ يُخْتَتَنَ الخَدَمُ الَّذِينَ يُولَدُونَ فِي بَيتِكَ. كَذَلِكَ لِيُخْتَتَنْ كُلُّ مَنِ اشْتَرَيتُمُوهُ بِالمالِ عَبْداً مِنْ أيِّ أجْنَبِيٍّ، حَتَّى وَإنْ لَمْ يَكُنْ مِنْ نَسلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","فَلْيُخْتَتَنْ حَتَّى العَبْدُ المَولُودُ فِي بَيتِكَ أوِ العَبْدُ الَّذِي اشْتَرَيتَهُ بِمالِكَ. وَهَكَذا يَحْمِلُ جَسَدُكَ عَلامَةَ عَهْدِيَ الأبَدِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","أمّا الَّذِي يَرْفُضُ أنْ يَخْتِنَ غُرلَتَهُ، فَسَيُقْطَعُ مِنْ شَعبِهِ. فَهَذا قَدْ كَسَرَ عَهْدِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","وَقالَ اللهُ لإبْراهِيمَ: «وَأمّا زَوْجَتُكَ سارايُ، فَلَنْ تُدْعَى سارايُ فِيما بَعْدُ، إذْ سَيَكُونُ اسْمُها سارَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","وَأنا سَأُبارِكُها. وَسَأُعِطِيكَ ابْناً مِنْها. وَسَأُبارِكُها، وَسَتُصْبِحُ أُمّاً لِشُعُوبٍ كَثِيرَةٍ. وَسَيَخرُجُ مُلُوكٌ مِنْها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","فأنْكَبَّ إبْراهِيمُ عَلَى وَجْهِهِ، وَضَحِكَ، وَقالَ فِي نَفْسِهِ: «أيُولَدُ ابْنٌ لِرَجُلٍ فِي المِئَةِ مِنْ عُمْرِهِ؟ أمْ يُمْكِنُ لِسارَةَ ذاتِ التِّسْعِينَ سَنَةً أنْ تُنْجِبَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ثُمَّ قالَ إبْراهِيمُ للهِ: «أرْجُو أنْ تُنْعِمَ عَلَى إسْماعِيلَ بِرِضاكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","فَقالَ اللهُ: «لا بَلْ سارَةُ سَتُنْجِبُ لَكَ وَلَداً، وَأنْتَ سَتُسَمِّيهِ إسْحاقَ. وَسَأحفَظُ عَهْدِي مَعَهُ وَمَعَ نَسلِهِ مِنْ بَعْدِهِ عَهْداً أبَدِيّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","«أمّا دُعاؤكَ مِنْ أجلِ إسْماعِيلَ، فَقَدْ سَمِعْتُهُ. فَسَأُبارِكُهُ، وَسَأُعْطِيهِ أبْناءً كَثِيرِينَ. وَسَيَكُونُ أباً لاثْنَي عَشَرَ رَئِيساً. وَسَأجْعَلُهُ شَعباً عَظِيماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","أمّا عَهْدِي فَسَأقْطَعُهُ مَعَ إسْحاقَ الَّذِي سَتُنْجِبُهُ سارَةُ لَكَ فِي مِثلِ هَذا الوَقْتِ مِنَ السَّنَةِ القادِمَةِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","وَبَعْدَ أنْ أنْهَى اللهُ كَلامَهُ مَعَ إبْراهِيمَ، اختَفَى عَنْ نَظَرِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ثُمَّ أخَذَ إبْراهِيمُ ابْنَهُ إسْماعِيلَ وَكُلَّ العَبِيدِ المَولُودِينَ فِي بَيتِهِ وَالَّذِينَ اشْتَراهُمْ بِمالِهِ – أخَذَ كُلَّ ذَكَرٍ فِي بَيتِهِ، وَخَتَنَهُمْ جَميعاً فِي ذَلِكَ اليَوْمِ نَفْسِهِ، كَما أمَرَهُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","وَكانَ إبْراهِيمُ فِي التّاسِعَةِ وَالتِّسْعِينَ مِنْ عُمْرِهِ عِندَما خُتِنَ فِي لَحْمِ غُرلَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","وَكانَ ابْنُهُ إسْماعِيلُ فِي الثّالِثَةَ عَشْرَةَ مِنْ عُمْرِهِ عِندَما خُتِنَ فِي لَحمِ غُرلَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","فِي ذَلِكَ اليَوْمِ نَفْسِهِ خُتِنَ إبْراهِيمُ وَابْنُهُ إسْماعِيلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","وَخُتِنَ مَعَهُ جَميعُ الذُّكُورِ الَّذِينَ فِي بَيتِهِ، سَواءٌ الَّذِينَ وُلِدُوا عَبِيداً فِي بَيتِهِ، أمِ الَّذِينَ اشْتَراهُمْ بِمالٍ مِنْ أجنَبِيٍّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","وَظَهَرَ اللهُ لإبْراهِيمَ عِنْدَ بَلُّوطاتِ مَمْرا، وَهُوَ جالِسٌ عِنْدَ مَدخَلِ خَيمَتِهِ فِي عِزِّ الظَّهِيرَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","فَرَفَعَ إبْراهِيمُ عَينَيهِ، فَرَأى ثَلاثَةَ رِجالٍ واقِفِينَ هُناكَ أمامَهُ. فَلَمّا رَآهُمْ، رَكَضَ مِنْ مَدْخَلِ خَيمَتِهِ لِلِقائِهِمْ، وَانحَنَى لَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","وَقالَ: «يا سادَتِي، أرْجُو أنْ تَتَكَرَّمُوا عَلَيَّ بِالبَقاءِ عِنْدِي قَلِيلاً، أنا خادِمَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","فَاسْمَحُوا لِي بِأنْ أُحضِرَ بَعْضَ الماءِ، فَتَغْسِلُوا أقْدامَكُمْ وَتَرْتاحُوا عِنْدَ الشَّجَرَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","وَسَأُحضِرُ بَعْضَ الخُبْزِ فَتُنَشَطَ أنفُسَكُمْ، وَتُواصِلُوا طَرِيقَكُمْ. اسْمَحُوا لِي بِهَذا بِما أنَّكُمْ جَئْتُمْ إلَيَّ، أنا خادِمَكُمْ.» فَقالُوا: «كَما قُلْتَ فافْعَلْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","فَأسْرَعَ إبْراهِيمُ إلَى سارَةَ فِي خَيمَتِهِ وَقالَ لَها: «عَجِّلِي، اعجِنِي ثَلاثَةَ أكيالٍ مِنَ الدَّقِيقِ، وَاصْنَعِي لَنا بَعضَ الفَطائِرِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ثُمَّ رَكَضَ إبْراهِيمُ إلَى القَطِيعِ وَأخَذَ عِجلاً جَيِّداُ صَغِيراً، وَأعطاهُ لِخادِمِهِ الَّذِي أسْرَعَ لِيَطبُخَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ثُمَّ أخَذَ إبْراهِيمُ زُبْداً وَحَلِيباً وَالعِجلَ الَّذِي طَبَخَهُ، وَوَضَعَ هَذا كُلَّهُ أمامَهُمْ، وَوَقَفَ قُرْبَهُمْ تَحْتَ الشَّجَرَةِ بَينَما هُمْ يَأْكُلُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","فَقالُوا لَهُ: «أينَ زَوْجَتُكَ سارَةُ؟» فَقالَ إبْراهِيمُ: «هُناكَ، فِي الخَيمَةِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","فَقالَ: «سأعُودُ إلَيكَ فِي الرَّبيعِ القَادِمِ، وَسَيَكُونُ لِزَوْجَتِكَ سارَةَ وَلَدٌ.» وَكانَتْ سارَةُ تَسْتَمِعُ عِنْدَ مَدْخَلِ الخَيمَةِ وَراءَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","وَكانا قَدْ شاخا. وَانقَطَعَتِ العادَةُ الشَّهْرِيَّةُ عِنْدَ سارَةَ مُنْذُ مُدَّةٍ طَوِيلَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","فَضَحِكَتْ سارَةُ فِي نَفْسِها وَقالَتْ: «أبَعْدَ أنْ كادَ يَفنَى جَسَدي، وَشاخَ زَوجِيَ، أهْنأُ بِهَذَ الأمْرِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","فَقالَ اللهُ لإبْراهِيمَ: «لِماذا ضَحِكَتْ سارَةُ وَقالَتْ: ‹هَلْ أُرْزَقُ بِطِفلٍ حَقّاً وَأنا قَدْ شِخْتُ؟› ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","هَلْ يَسْتَحيلُ أمْرٌ عَلَى اللهُ؟ فِي الوَقْتِ المُحَدَّدِ سأعُودُ إلَيكَ – فِي الرَّبيعِ القَادِمِ – وَسَيَكُونُ لِسارَةَ وَلَدٌ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","فَخافَتْ سارَةُ، فَأنْكَرَتْ وَقالَتْ: «لَمْ أضْحَكْ!» فَقالَ: «بَلْ ضَحِكْتِ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ثُمَّ انطَلَقَ الرِّجالُ مِنْ هُناكَ وَأشْرَفُوا عَلَى سَدُومَ وَعَمُورَةَ. وَكانَ إبْراهِيمُ يَمْشِي مَعَهُمْ لِيُوَدِّعَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","فَقالَ اللهُ: «كَيفَ أُخفِيَ عَنْ إبْراهِيمَ ما أُوشِكُ أنْ أفْعَلَهُ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","فَهُوَ سَيُصبِحُ أُمَّةً عَظِيمَةً وَقَوِيَّةً. وَبِهِ سَتَتَبارَكُ كُلُّ أُمَمِ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","وَقَدِ اختَرْتُهُ لأنَّهُ سَيَأْمُرُ أبْناءَهُ وَبَيتَهُ مِنْ بَعْدِهِ أنْ يَحيَوْا كَما يُرِيدُهُمُ اللهُ. فَيَعمَلُوا أعْمالَ البَرِّ وَالإنْصافِ، وَأُحَقِّقُ، أنا اللهَ، لإبْراهِيمَ ما وَعَدْتُهُ بِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ثُمَّ قالَ اللهُ: «الشَّكاوَى كَثِيرَةٌ جِدّاً عَلَى سَدُومَ وَعَمُورَةَ. وَخَطِيَّتُهُمْ عَظِيمَةٌ جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","سَأنْزِلُ، وَسَأرَى إنْ كانُوا قَدْ فَعَلُوا كُلَّ ما سَمِعْتُهُ مِنْ شَكْوَى أمْ لَمْ يَفْعَلُوا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","فانصَرَفَ الرِّجالُ مِنْ هُناكَ وَسارُوا نَحوَ سَدُومَ. أمّا إبْراهِيمُ فَظَلَّ واقِفاً فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","وَدَنا إبْراهِيمُ مِنَ اللهِ وَقالَ: «أحَقّاً سَتَسْحَقُ الصّالِحِينَ مَعَ الأشْرارِ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","فَماذا إذا كانَ هُناكَ خَمْسُونَ صالِحاً فِي المَدِينَةِ؟ فَهَلْ سَتَسْحَقُ المَدِينَةَ؟ أفَلا تَعفُو عَنِ المَدِينَةِ مِنْ أجلِ الخَمْسِينَ الصّالِحِينَ السّاكِنِينَ فِي المَدِينَةِ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","لَنْ تَفْعَلَ هَذا بِكُلِّ تأكِيدٍ: لَنْ تَقْتُلَ الصّالِحَ مَعَ الشِّرِّيرِ. فَتُساوِيَ بَينَ الصّالِحِ وَالشِّرِّيرِ. لا يُمكِنُ أنْ لا يَكُونَ قاضِي الأرْضِ كُلِّها عادِلاً؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","فَقالَ اللهُ: «إنْ وَجَدْتُ فِي سَدُومَ خَمسِينَ صالِحِينَ، سَأعْفُو عَنِ المَدِينَةِ كُلِّها بِسَبَبِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","فَأجابَ إبْراهِيمُ: «قَدْ تَجَرَّأْتُ فِي مًخاطَبَةِ الرَّبِّ، وَأنا لَسْتُ سِوَى تُرابٍ وَرَمادٍ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","لَكِنْ ماذا إنْ وُجِدَ خَمْسةٌ وَأرْبَعُونَ فَقَطْ صالِحُونَ؟ هَلْ سَتُدَمِّرِ المَدِينَةَ كُلَّها مِنْ أجلِ الخَمْسَةِ؟» فَقالَ: «لَنْ أُدَمِّرَ المَدِينَةَ إنْ وُجِدَ فِيها خَمْسَةٌ وَأرْبَعُونَ صالِحُونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ثُمَّ تَكَلَّمَ إبْراهِيمُ إلَيهِ ثانِيَةً وَقالَ: «فَماذا إنْ وُجِدَ أرْبَعُونَ صالِحُونَ؟» فَقالَ: «لَنْ أُدَمِّرَ المَدِينَةَ مِنْ أجلِ الأرْبَعِينَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","فَقالَ إبْراهِيمُ: «يا رَبِّي، لا تَغضَبْ مِنِّي إنْ تَكَلَّمْتُ هَذِهِ المَرَّةِ. فَماذا إنْ وُجِدَ ثَلاثَونَ صالِحُونَ؟» فَقالَ: «لَنْ أُدَمِّرَها إنْ وَجَدْتُ ثَلاثِينَ صالِحينَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","فَقالَ إبْراهِيمُ: «ها قَدْ تَجاسَرْتُ كَثِيراً فِي الحَدِيثِ مَعَ رَبِّي، لَكِنْ ماذا إنْ وُجِدَ عِشْرُونَ صالِحُونَ؟» فَقالَ: «لَنْ أُدَمِّرَها مِنْ أجلِ العِشْرِينَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","فَقالَ إبْراهِيمُ: «يا رَبُّ، لا تَغضَبْ مِنِّي فَأتَكَلَّمْ لِلْمَرَّةِ الأخِيرَةِ. ماذا إنْ وُجِدَ فِيها عَشْرَةٌ صالِحُونَ؟» فَقالَ: «لَنْ أُدَمِّرَها مِنْ أجلِ العَشْرَةِ الصّالِحِينَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ثُمَّ ذَهَبَ اللهُ بَعْدَ أنْ أنهَى حَدِيثَهُ مَعَ إبْراهِيمَ. أمّا إبْراهِيمُ فَعادَ إلَى بَيتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","وَوَصَلَ المَلاكانِ إلَى مَدِينَةِ سَدُومَ فِي المَساءِ. وَكانَ لُوطُ جالِساً عِنْدَ بَوّابَةِ سَدُومَ. فَلَمَّا رآهُما، قامَ لُوطُ وَخَرَجَ لِيَسْتَقْبِلٌهُما. ثُمَّ انحَنَى لَهُما وَوَجهُهُ إلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","وَقالَ: «يا سَيِّدَيَّ، أرجُو أنْ تَتَفَضَّلا إلَى بَيتِ خادِمِكُما. بِيتا اللَّيلَة عِنْدِي وَاغْسِلا أقدامَكُما. وَبَعْدَ ذَلِكَ تُبَكِّرا وَتَمْضِيا فِي طَرِيقِكُما.» فَقالا: «لا، بَلْ سَنَبِيتُ اللَيلَةَ فِي ساحَةِ المَدِينَةِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","لَكِنَّ لُوطَ ألَحَّ عَلَيهِما كَثِيراً، فَقَبِلا دَعْوَتَهُ وَذَهَبا إلَى بَيتِهِ. وَأعَدَّ لَهُما لُوطُ طَعاماً، وَخَبَزَ لَهُما فَطيراً فَأكَلا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","وَقَبلَ أنْ يَناما، جاءَ رِجالُ مَدِينَةِ سَدُومَ، شُبّاناً وَكِباراً. جاءُوا جَمِيعاً وَحاصَرُوا البَيتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","وَنادَوْا عَلَى لُوطَ وَقالُوا: «أينَ الرَّجُلانِ اللَّذانِ جاءا إلَيكَ لَيلاً؟ أخْرِجْهُما إلَينا لِكَي نُعَاشِرَهُما.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","فَخَرَجَ لُوطُ إلَيْهِمْ، وَأغلَقَ البابَ خَلْفَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ثُمَّ قالَ: «أرْجُوكُمْ، أيُّها الأصْدِقاءُ، أنْ لا تَفعَلُوا هَذا الشَّرَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ها إنَّ لَدَيَّ ابْنَتَينِ عَذْراوَينِ. أنا مُسْتَعِدٌّ أنْ أُحضِرَهُما لَكُمْ لِتَفْعَلُوا بِهِما ما تُريدُونَ. أمّا هَذانِ الرَّجُلانِ، فَلا تَمَسُّوهُما، لِأنَّهُما صارا فِي حِمايَةِ بَيتِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","فَقالُوا: «لا تَقِفْ فِي طَرِيقِنا.» وَقالُوا: «جاءَ هَذا الرَّجُلُ إلَى مَدِينَتِنا غَرِيباً. فَهَلْ نَتْرُكُهُ الآنَ يَتَحَكَّمُ بِنا؟ لِهَذا سَنَفعَلُ بِكَ أسْوَأ مِمّا سَنَفْعَلُ بِهِما!» ثُمَّ تَزاحَمُوا عَلَى لُوطَ. وَأوشَكُوا أنْ يُحَطِّمُوا البابَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","فَفَتَحَ الرَّجُلانِ البابَ، وَمَدّا أيدِيهِما، وَجَذَبا لُوطَ إلَى داخِلِ البَيتِ، وَأغلَقا البابَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ثًمَّ ضَرَبا جَميعَ الرِّجالِ الَّذِينَ خارِجَ بابِ البَيت، شُبّاناً وَكِباراً، بِالعَمَى. فَلَمْ يَقْدِرُوا أنْ يَجِدُوا البابَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","فَقالَ الرَّجُلانِ لِلُوطَ: «ألَكَ أقرِباءُ هُنا؟ هَيّا أخْرِجْ مِنْ هَذا المَكانِ أصْهارَكَ وَأبْناءَكَ وَبَناتِكَ، وَجَمِيعَ أقرِبائِكَ فِي هَذِهِ المَدِينَةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","لِأنَّنا سَنُدَمِّرُ هَذا المَكانَ. فَاللهُ قَدْ سَمِعَ بِعِظَمِ شَرِّ هَذِهِ المَدِينَةِ، فَأرْسَلَنا اللهُ لِنُدَمِّرَها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","فَخَرَجَ لُوطُ وَقالَ لأصْهارِهِ: «هَيّا غادِرُوا هَذا المَكانَ، لِأنَّ اللهَ سَيُدَمِّرُ المَدِينَةَ قَرِيباً.» فَظَنُّوا أنَّهُ يُمازِحُهُمْ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","وَلَمّا طَلَعَ الفَجْرُ، اسْتَعْجَلَ المَلاكانِ لُوطَ وَقالُوا لَهُ: «هَيّا خُذْ زَوْجَتَكَ وَابْنَتَيكَ اللَّواتِي مَعَكَ، وَإلا قُتِلْتُمْ فِي المَدِينَةِ الَّتِي سَتُدَمَّرُ عِقاباً لَها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","وَإذْ تَباطَأَ لُوطُ، أمسَكَ المَلاكانِ بِهِ وَبِامْرَأتِهِ وَابْنَتَيهِ مِنْ أيدِيهِمْ، لِأنَّ اللهَ كانَ رَحِيماً بِهِ. فَأخرَجاهُ، وَتَرَكاهُ خارِجَ المَدِينَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","فَلَمّا أخرَجا لُوطَ وَعائِلَتَهُ، قالَ أحَدُ المَلاكَينِ: «انجُ بِنَفْسِكَ! وَلا تَلْتَفِتْ وَراءَكَ. لا تَتَوَقَّفْ فِي أيِّ مَكانٍ فِي هَذا السَّهلِ. بَلِ اهْرُبْ إلَى الجِبالِ وَإلّا هَلِكْتَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","فَقالَ لُوطُ لَهُما: «لا يا سَيِّدَيَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","قَدْ رَضَيتُما عَنِّي، أنا خادِمَكُما، وَأظْهَرْتُما لُطفاً كَثِيراً فِي إنقاذِ حَياتِي. أنا لا اقْدِرُ عَلَى الهَرَبِ إلَى الجِبالِ. وَأخشَى أنْ يُدْرِكَنِي الدَّمارُ، فَأمُوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","هُناكَ بَلْدَةُ قَرِيبَةٌ لِلهَرَبِ إلَيها. وَهِيَ صَغِيرَةٌ. أهرُبُ إلَى هُناكَ. ألَيسَتْ صَغِيرَةً؟ فَسَتَكونُ حَياتِي فِي أمانٍ هُناكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","فَقالَ لَهُ المَلاكُ: «طَلَبُكَ مَقْبُولٌ. سَأعمَلُ هَذا مِنْ أجلِكَ أيضاً، وَلَنْ أُدَمِّرَ تِلْكَ البَلْدَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","فَأسْرِعِ! اهرُبْ إلَى هُناكَ! فَلَنْ أقدِرَ أنْ أفعَلَ شَيئاً حَتَّى تَصِلَ إلَى هُناكَ.» مِنْ أجلِ هَذا سُمِّيَتِ البَلْدَةُ صُوغَرَ، لِأنَّها صَغِيرَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","وَمَعَ شُرُوقِ الشَّمْسِ، دَخَلَ لُوطُ إلَى صُوغَرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ثُمَّ أمطَرَ اللهُ عَلَى سَدُومَ وَعَمُورَةَ كِبْرِيتاً مُلْتَهِباً وَناراً مِنْ عِندِ اللهِ مِنَ السَّماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","فَدَمَّرَهُما مَعَ الوادِي كُلِّهِ، وَكُلِّ السّاكِنِينَ هُناكَ، وَكُلِّ ما نَما فِي الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","وَنَظَرَتْ زَوجَةُ لُوطَ وَراءَها، فَصارَتْ عَمُودَ مِلْحٍ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","فَبَكَّرَ إبْراهِيمُ إلَى المَكانِ الَّذِي وَقَفَ فِيهِ فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","وَأطَلَّ عَلَى سَدُومَ وَعَمُورَةَ وَكُلِّ أرْضِ الوادِي، فَرَأى الدُّخانَ صاعِداً مِنَ الأرْضِ كَدُخانِ فُرْنٍ كَبيرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","فَلَمّا دَمَّرَ اللهُ مُدُنَ الوادِي، تَذَكَّرَ صَلاةَ إبْراهِيمَ، وَأخرَجَ لُوطَ مِنْ وَسْطِ الدَّمارِ، قَبلَ أنْ يُدَمِّرَ المُدُنَ الَّتِي كانَ لُوطُ يٌقِيمُ فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","وَخَرَجَ لُوطُ مِنْ صُوغَرَ وَسَكَنَ فِي الجِبالِ مَعَ ابْنَتَيهِ. فَقَدْ خَشِيَ لُوطُ مِنَ السُّكنَى فِي صُوغَرَ. فَسَكَنَ مَعَ ابْنَتَيهِ فِي كَهفٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","فَقالَتِ البِكْرُ لِأُختِها الصُّغْرَى: «لَقَدْ شاخَ أبوْنا، وَلَيسَ فِي الأرْضِ رَجُلٌ يُعاشِرُنا كَما يَفعَلُ النّاسُ فِي كُلِّ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","فَهَيّا نُسكِرْ أبانا بِالخَمْرِ، ثُمَّ نُعَاشِرُهُ. وَبِهَذا نُبقِي عَلَى عائِلَتِنا مِنْ خِلالِ أبِينا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","فَأسْكَرَتِ الأُختانِ أباهُما بِالخَمْرِ فِي تِلكَ اللَّيلَةِ. ثُمَّ قامَتْ الأُختُ البِكْرُ وَعَاشَرَتْ أبِيها. أمّا لُوطُ فَلَمْ يَدرِ مَتَى جَاءَتْ إلَيهِ وَمَتَى قامَتْ مِنَ الفِراشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","وَفِي اليَوْمِ التّالِي، قالَتِ الأُختُ الكُبْرَى لِلصُّغرَى: «ها قَدْ عَاشَرْتُ أبِي لَيلَةَ أمْسِ، فَلْنُسْكِرْهُ اللَّيلَةَ أيضاً بِالخَمْرِ. ثُمَّ أنتِ اذهَبِي وَعَاشِرِيهِ. وَبِهَذا نُبقِي عَلَى عائِلَتِنا مِنْ خِلالِ أبِينا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","فَأسْكَرَتِ الأُختانِ أباهُما بِالخَمْرِ فِي تِلْكَ اللَّيلَةِ أيضاً. ثُمَّ قامَتِ الأُختُ الصُّغرَى وَعَاشَرَتْ أبِيها. أمّا لُوطُ فَلَمْ يَدْرِ مَتَى جَاءَتْ إلَيهِ وَمَتَى قامَتْ مِنَ الفِراشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","وَهَكَذا حَبِلَتِ ابْنَتا لُوطَ مِنْ أبِيهِما! ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","فَأنجَبَتِ البِكرُ وَلَداً أسْمَتْهُ «مُوآبَ،» وَهُوَ أبو جَمِيعِ المُوآبِيِّينَ إلَى هَذا اليَوْمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","وَأنجَبَتِ الصُّغرَى وَلَداً أسْمَتْهُ «بِنْ عَمِّي،» وَهُوَ أبو جَمِيعِ العَمُّونِيِّينَ إلَى هَذا اليَوْمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","وَارتَحَلَ إبْراهِيمُ مِنْ هُناكَ إلَى أرْضِ النَّقَبِ، وَاسْتَقَرَّ بَينَ قادِشَ وَشُورَ. فَأقامَ فِي جَرارَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","وَقالَ إبْراهِيمُ لِلنّاسِ هُناكَ عَنْ زَوْجَتِهِ سارَةَ: «هَذِهِ أختِي.» فَسَمِعَ أبِيمالِكُ مَلِكُ جَرارَ عَنْ سارَةَ، فَأرْسَلَ فِي طَلَبِها، وَأخَذَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","فَجاءَ اللهُ إلَى أبِيمالِكَ لَيلاً فِي حُلْمٍ. وَقالَ لَهُ: «ها أنتَ سَتَمُوتُ بِسَبَبِ المَرأةِ الَّتِي أخَذْتَها. فَهِيَ زَوجَةٌ لِرَجُلٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","وَلَمْ يَكُنْ أبِيمالِكُ قَدْ نامَ مَعَها. فَقالَ: «يا رَبُّ، أتَقتُلُ إنْساناً بَرِيئاً؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ألَمْ يَقُلْ لِي: ‹هَذِهِ أُختِي›؟ وَسارَةُ نَفْسُها قالَتْ عَنْهُ: ‹هَذا أخِي.› أنا فَعَلْتُ هَذا بِنِيَّةٍ سَلِيمَةٍ وَقَصدٍ طاهِرٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","فَقالَ لَهُ اللهُ فِي الحُلْمِ: «أنا أيضاً أعرِفُ أنَّكَ فَعَلْتَ هّذا بِنِيَّةٍ سَلِيمَةٍ، فَمَنَعْتُكَ مِنْ أنْ تَلْمَسَها وَتُخطِئَ إلَيَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","فَالآنَ رُدَّ الزَّوْجَةَ لِزَوْجِها. فَهُوَ نَبِيٌّ. وَهُوَ سَيُصَلِّي مِنْ أجلِكَ فَتَحيا. وَإنْ لَمْ تَرُدَّها، فاعلَمْ أنَّكَ وَعائِلَتَكَ لا بُدَّ أنْ تَمُوتُوا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","فَبَكَّرَ أبِيمالِكُ فِي الصَّباحِ وَدَعا كُلَّ خُدّامِهِ، وَأخبَرَهُمْ بِكُلِّ ما سَمِعَ فِي الحُلْمِ. فَخافَ الرِّجالُ كَثِيراً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ثُمَّ اسْتَدْعَى أبِيمالِكُ إبْراهِيمَ، وَقالَ لَهُ: «لِمَ فَعَلْتَ بِنا هَذا؟ هَلْ أسَأْتُ إلَيكَ لِكَي تُسيئَ إساءَةً عَظِيمَةً إلَيَّ وَإلَى مَملَكَتِي. قَدْ فَعَلْتَ بِي ما لا يَلِيقُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","وَأضافَ أبِيمالِكُ: «ما الَّذِي وَاجَهْتَهُ هُنا حَتَّى اضطَرَّكَ إلَى فِعلِ ما فَعَلْتَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","فَقالَ إبْراهِيمُ: «قُلْتُ فِي نَفْسِي: ‹لا بُدَّ أنَّهُ لَيسَ هُناكَ فِي هَذا المَكانِ مَنْ يَتَّقِي اللهَ. وَلِهَذا فَإنَّهُمْ سَيَقْتُلُونَنِي لِأجلِ زَوْجَتِي.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","كَما أنَّ سارَةَ هِيَ أُختِي حَقّاً، فَهِيَ ابْنَةُ أبِي، غَيرَ أنَّها لَيسَتِ ابْنَةَ أُمِّي. وَصارَتْ زَوْجَتِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","وَعِنْدَما أخرَجَنِي اللهُ لِأرْحَلَ مِنْ بَيتِ أبِي، قُلْتُ لَها: ‹اصْنَعِي مَعِي هَذا المَعرُوفَ: حَيثُما ذَهَبْنا، قُولِي عَنِّي: هَذا أخِي.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","فَأخَذَ أبِيمالِكُ غَنَماً وَبَقَراً وَخَدَماً وَخادِماتٍ وَأعطاها لإبْراهِيمَ. كَما أعادَ إلَيهِ زَوْجَتَهُ سارَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","وَقالَ أبِيمالِكُ: «ها أرْضِي مَفتُوحَةٌ لَكَ. فاسْكُنْ حَيثُ تُرِيدُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ثُمَّ قالَ أبِيمالِكُ لِسارَةَ: «ها قَدْ أعطَيتُ أخاكِ ألفَ قِطْعَةٍ فِضِّيَّةٍ. فَهِيَ شَهادَةٌ عَلَى بَراءَتِكِ أمامَ كُلِّ الَّذِينَ مَعَكِ. فَأنْتِ بَرِيئَةٌ تَماماً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ثُمَّ صَلَّى إبْراهِيمُ إلَى اللهِ. فَشَفَى اللهُ أبِيمالِكَ وَزَوْجَتَهُ وَجَوارِيهِ، فَأنْجَبا أطْفالاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","فَقَدْ كانَ اللهُ قَدْ مَنَعَ كُلَّ النِّساءِ فِي بَيتِ أبِيمالِكَ مِنَ الإنْجابِ بِسَبَبِ سارَةَ، زَوْجَةِ إبْراهِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","وَأظهَرَ اللهُ نِعمَةً لِسارَةَ كَما وَعَدَ. وَعَمِلَ اللهُ مَعَها كَما سَبَقَ أنْ أعلَنَ لِزَوْجِها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","فَحَبِلَتْ سارَةُ وَأنجَبَتْ وَلَداً لإبْراهِيمَ فِي شَيخُوخَتِهِ. وَفِي المَوْعِدِ الَّذِي سَبَقَ أنْ حَدَّدَهُ اللهُ لَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","وَسَمَّى إبْراهِيمُ ابْنَهُ الَّذِي وَلَدَتْهُ لَهُ سارَةُ إسْحاقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","وَخَتَنَ إبْراهِيمُ ابْنَهُ إسْحاقَ عِنْدَما بَلَغَ ثَمانِيَةَ أيّامٍ مِنْ عُمْرِهِ، كَما أوْصاهُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","وَكانَ عُمْرُ إبْراهِيمَ مِئَةَ سَنَةٍ عِنْدَما رُزِقَ بِابْنِهِ إسْحاقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","فَقالَتْ سارَةُ: «لَقَدْ أضحَكَنِي اللهُ. وَكُلُّ مَنْ يَسْمَعُ عَنْ هَذا سَيَضْحَكُ مَعِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","وَقالَتْ أيضاً: «مَنْ كانَ يَتَخَيَّلُ أنْ يُقالَ لإبْراهِيمَ: ‹سَتُرْضِعُ سارَةُ أطفالاً›؟ لَكِنِّي أنجَبْتُ وَلَداً لَهُ فِي شَيخُوخَتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","وَكَبِرَ الطِّفلُ وَفُطِمَ. فَأقامَ إبْراهِيمُ حَفلَةً كَبِيرَةً يَوْمَ فُطِمَ إسْحاقُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","وَرَأتْ سارَةُ ابْنَ هاجَرَ المِصْرِيَّةَ الَّذِي وَلَدَتْهُ لإبْراهِيمَ يُضايِقُ إسْحاقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","فَقالَتْ لإبْراهِيمَ: «اطرُدْ هَذِهِ الجارِيَةَ وَابْنَها بَعِيداً، لأنَّ ابْنَ هَذِهِ الجارِيَةِ لَنْ يَرِثَ مَعَ ابْنِي إسْحاقَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","فَساءَ هَذا الأمْرُ إبْراهِيمَ كَثِيراً بِسَبَبِ ابْنِهِ إسْماعِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","فَقالَ اللهُ لإبْراهِيمَ: «لا تَتَضايَقْ بِسَبَبِ ابْنِكَ وَجارِيَتِكَ، بَلِ افْعَلْ كُلَّ ما قالَتْهُ لَكَ سارَةُ. وَسَيَكُونُ لَكَ نَسلٌ بِواسِطَةِ إسْحَاقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","وَسَأجعَلُ ابْنَ الجارِيَةِ أيضاً أُمَّةً، لِأنَّهُ ابْنُكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","فَقامَ إبْراهِيمُ فِي الصَّباحِ الباكِرِ، وَأخَذَ طَعاماً وَقِرْبَةَ ماءٍ وَوَضَعَهُما عَلَى كَتِفِ هاجَرَ، ثُمَّ أعطاها الوَلَدَ وَأرْسَلَهُما فِي طَرِيقِهِما. فَغادَرَتْ هاجَرُ ذَلِكَ المَكانِ، وَارْتَحَلَتْ فِي صَحْراءِ بِئْرِ السَّبْعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","فَلَمّا نَفِذَ الماءُ مِنَ القِرْبَةِ، وَضَعَتِ الوَلَدَ تَحْتَ إحدَى الأشْجارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","وَذَهَبَتْ لِتَجلِسَ بَعِيداً عَنْهُ، عَلَى بُعْدِ رَمْيَةِ قَوْسٍ. إذْ قالَتْ: «لا أُرِيدُ أنْ يَمُوتَ ابْنِي تَحْتَ نَظَرِي.» فَجَلَسَتْ عَلَى مَسافَةٍ، وَأخَذَتْ تَبْكِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","فَسَمِعَ اللهُ صَوْتَ الوَلَدِ. فَنادَى مَلاكُ اللهِ هاجَرَ مِنَ السَّماءِ وَقالَ لَها: «ما لَكِ، يا هاجَرُ؟ لا تَخافِي، فَاللهُ قَدْ سَمِعَ الوَلَدَ يَبْكِي هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","فَقُومِي! أنْهِضِي الوَلَدَ، وَأمْسِكِيهِ جَيِّداً مِنْ يَدِهِ. فَأنا سَأجعَلُهُ أُمَّةً عَظِيمَةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ثُمَّ أراها اللهُ بِئْرَ ماءٍ. فَذَهَبَتْ وَمَلأتِ القِرْبَةَ ماءً. ثُمَّ سَقَتِ الوَلَدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","وَكانَ اللهُ مَعَ الوَلَدِ حَتَّى كَبِرَ. وَسَكَنَ إسْماعِيلُ فِي الصَّحْراءِ. وَصارَ رامِيَ سِهامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","وَعاشَ فِي بَرِّيَّةِ فارانَ. وَاختارَتْ لَهُ أُمُّهُ زَوْجَةً مِنْ أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","فِي ذَلِكَ اليَومِ، قالَ أبِيمالِكُ وَمَعْهُ فِيكُولُ قائِدُ جَيشِهِ لإبْراهِيمَ: «إنَّ اللهَ مَعَكَ فِي كُلِّ ما تَفعَلُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","فاحلِفْ لِي بِاللهِ أنَّكَ لَنْ تَلْجَأ يَوْماً إلَى الغَدْرِ فِي تَعامُلِكَ مَعِي أوْ مَعَ أبْنائِي أوْ مَعَ نَسلِي. فَكَما كُنْتُ كَرِيماً مَعَكَ، احلِفْ أنْ تَكُونَ كَرِيماً مَعِي وَمَعَ هَذِهِ الأرْضِ الَّتِي تَغَرَّبْتَ فِيها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","فَقالَ إبْراهِيمُ: «أحلِفُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ثُمَّ اشْتَكَى إبْراهِيمُ لِأبِيمالِكَ مِنْ أنَّ عَبِيدَهُ اسْتَولُوا عَلَى بِئْرِ ماءٍ يَخُصُّهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","فَقالَ أبِيمالِكُ: «لا أعلَمُ مَنِ الَّذِي فَعَلَ هَذا. فَأنتَ لَمْ تُخبِرْنِي فِيما مَضَى، وَلَمْ أسْمَعْ بِهَذا الأمْرِ إلّا اليَوْمَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","فَأخَذَ إبْراهِيمُ غَنَماً وَبَقَراً وَأعطاها لِأبِيمالِكَ. وَقَطَعَ الاثْنانِ بَينَهُما عَهداً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","وَفَرَزَ إبْراهِيمُ سَبْعَ نِعاجٍ مِنَ القَطِيعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","فَسَألَ أبِيمالِكُ إبْراهِيمَ: «لِماذا فِرَزْتَ هَذِهِ النِّعاجَ السَّبْعَ وَحْدَها؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","فَقالَ إبْراهِيمُ: «سَتَأْخُذُ هَذِهِ النِّعاجَ السَّبْعَ مِنِّي شَهادَةً عَلَى أنِّي حَفَرْتُ هَذَهِ البِئْرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","فَبَعْدَ ذَلِكَ سُمِّيَتْ تِلْكَ البِئْرُ بِئْرَ سَبْعٍ، لِأنَّهُما قَطَعا عَهداً وَأقْسَما هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","فَقَطَعا عَهْداً فِي بِئْرِ السَّبْعِ. وَبَعْدَ ذَلِكَ عادَ أبِيمالِكُ وَفِيكُولُ رَئِيسُ جَيشِهِ إلَى أرْضِ الفِلِسْطِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","وَزَرَعَ إبْراهِيمُ شَجَرَةَ أثلٍ فِي بِئْرِ السَّبْعِ. وَهُناكَ صَلَّى بِاسمِ يهوه، الإلَهِ السَّرْمَدِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","وَتَغَرَّبَ إبْراهِيمُ فِي أرْضِ الفِلِسْطِيِّينَ مُدَّةً طَوِيلَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","وَبَعْدَ هَذِهِ الأُمُورِ أرادَ اللهُ أنْ يَمْتَحِنَ إبْراهِيمَ. فَقالَ لَهُ: «إبْراهِيمُ!» فَقالَ إبْراهِيمُ: «سَمْعاً وَطاعَةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","فَقالَ اللهُ: «خُذْ إسْحاقَ ابْنَكَ وَحِيدَكَ الَّذِي تُحِبُّهُ. وَاذْهَبْ إلَى أرْضِ المُرِيّا. وَهُناكَ قَدِّمْهُ لِي ذَبِيحَةً عَلَى جَبَلٍ سَأُرِيهِ لَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","فَقامَ إبْراهِيمُ فِي الصَّباحِ الباكِرِ، وَأسْرَجَ حِمارَهُ. وَأخَذَ مَعَهُ اثْنَينِ مِنْ خَدَمِهِ وَإسْحاقَ ابْنَهُ. وَقَطَّعَ حَطَباً لِلذَّبِيحَةِ. وَمَضَى مَعَهُمْ إلَى المَكانِ الَّذِي أراهُ إيّاهُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","وَفِي اليَوْمِ الثّالِثِ رَفَعَ إبْراهِيمُ نَظَرَهُ، فَرَأى المَكانَ مِنْ بَعِيدٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ثُمَّ قالَ إبْراهِيمُ لِخادِمَيهِ: «ابْقَيا هُنا مَعَ الحِمارِ. سَنَذْهَبُ أنا وَالصَّبِيُّ إلَى ذَلِكَ المَكانِ لِنَسجُدَ، ثُمَّ سَنَعُودُ إلَيكُما.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","وَأخَذَ إبْراهِيمُ الحَطَبَّ المُعَدَّ لِلذَّبِيحَةِ، وَوَضَعَهُ عَلَى كَتِفِ ابْنِهِ إسْحاقَ. وَأخَذَ فِي يَدِهِ إناءَ الجَمْرِ وَالسِّكِّينَ. وَمَشَى كِلاهُما مَعاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ثُمَّ قالَ إسْحاقُ لإبْراهِيمَ أبِيهِ: «يا أبِي!» فَقالَ إبْراهِيمُ: «نَعَمْ يا بُنَيَّ.» فَقالَ إسْحاقُ: «النَّارُ وَالحَطَبُ مَعَنا، لَكِنْ أينَ الحَمَلُ لِلذَبِيحَةِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","فَقالَ إبْراهِيمُ: «اللهُ يُدَبِّرُ لِنَفْسِهِ الذَّبِيحَةَ يا بُنَيَّ.» ثُمَّ تابَعَ الاثْنانِ سَيرَهُما. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","وَوَصَلا إلَى المَكانِ الَّذِي حَدَّدَهُ اللهُ لإبْراهِيمَ. وَهُناكَ بَنَى إبْراهِيمُ مَذْبَحاً، وَرَتَّبَ الحَطَبَ عَلَيهِ. ثُمَّ رَبَطَ ابْنَهُ إسْحاقَ، وَوَضَعَهُ عَلَى المَذْبَحِ فَوْقَ الحَطَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","وَمَدَّ إبْراهِيمُ يَدَهُ وَأخَذَ السِّكِّينَ لِيَذْبَحَ ابْنَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","لَكِنَّ مَلاكَ اللهِ ناداهُ مِنَ السَّماءِ، وَقالَ لَهُ: «إبْراهِيمُ! إبْراهِيمُ!» فَقالَ إبْراهِيمُ: «سَمْعاً وَطاعَةً!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","فَقالَ: «تَوَقَّفْ! لا تُؤْذِ الصَّبِيَّ، وَلا تَفْعَلْ بِهِ شَيئاً. الآنَ عَرَفْتُ أنَّكَ تَخافُني، حَتَّى إنَّكَ لَمْ تَمنَعْ عَنِّي ابْنَكَ الوَحِيدَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ثُمَّ رَفَعَ إبْراهِيمُ نَظَرَهُ، فَرَأى كَبْشاً عالِقاً مِنْ قَرْنَيهِ بِشُجَيرَةٍ. فَذَهَبَ إبْراهِيمُ وَأخَذَ الكَبْشَ، ثُمَّ قَدَّمَهُ ذَبِيحَةً عِوَضاً عَنِ ابْنِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","وَسَمَّى إبْراهِيمُ ذَلِكَ المَكانَ «يهوه يُدَبِّرُ.» فَيَقُولُ النّاسُ حَتَّى هَذا اليَوْمِ: «فِي الجَبَلِ، يهوه يُدّبِّرُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ثُمَّ نادَى مَلاكُ اللهِ إبْراهِيمَ ثَانِيَةً مِنَ السَّماءِ ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","وَقالَ: «أُقْسِمُ بِذاتِي، يَقُولُ اللهُ: ‹لِأنَّكَ فَعَلْتَ هَذا الأمْرَ، وَلَمْ تَبْخَلْ عَلَيَّ بِابْنِكَ الوَحِيدِ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","إنِّي سَأُبارِكُكَ بِكُلِّ بَرَكَةٍ. وَسَأُعطِيكَ أحفاداً بِعَدَدِ نُجُومِ السَّماءِ وَحَبّاتِ رَملِ الشَّواطِئِ. وَسَيَسْتَولِي أحفادُكَ عَلَى مُدُنِ أعْدائِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","وَبِنَسلِكَ سَتَنالُ كُلُّ أُمَمِ الأرْضِ بَرَكَةً، لِأنَّكَ أطَعْتَنِي.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ثُمَّ عادَ إبْراهِيمُ إلَى خادِمَيهِ. وَقامُوا وَذَهَبُوا مَعاً إلَى بِئْرِ السَّبْعِ. وَاسْتَقَرَّ إبْراهِيمُ فِي بِئْرِ السَّبْعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","بَعْدَ كُلِّ هَذِهِ الأحداثِ قِيلَ لإبْراهِيمَ: «أنجَبَتْ مِلْكَةُ أولاداً لِأخِيكَ ناحُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","عُوصاً البِكْرَ، وَبُوزَ أخاهُ، وَقَمُوئِيلُ أبا أرامَ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","وَكاسَدَ وَحَزْوَ وَفِلْداشَ وَيِدلافَ وَبَتُوئِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","وَأنجَبَ بَتُوئِيلُ رِفْقَةَ. أنجَبَتْ مِلْكَةُ هَؤُلاءِ الأبْناءَ الثَّمانِيَةَ لِناحُورَ، أخِي إبْراهِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","كَما أنجَبَتْ لَهُ جارِيَتُهُ وَزَوجَتُهُ رَؤُومَةُ طابَحَ وَجاحَمَ وَتاحَشَ وَمَعْكَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","وَامْتَدَّ العُمْرُ بِسارَةَ مِئَةً وَسَبعاً وَعِشْرِينَ سَنَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ثُمَّ ماتَتْ فِي قَرْيَةِ أرْبَعَ، أي حَبْرُونَ الَّتِي فِي أرْضِ كَنعانَ. وَذَهَبَ إبْراهِيمُ لِيَنْدُبَ سارَةَ وَيَبْكِيَ عَلَيها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ثُمَّ قامَ إبْراهِيمُ مِنْ جانِبِ زَوْجَتِهِ المُتَوَفّاةِ، وَقالَ لِلحِثِّيِّينَ: ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«أنا غَرِيبٌ وَنَزِيلٌ بَينَكُمْ. فَأعطُونِي أرْضاً أجعَلُها مَدفِناً وَأدفِنَ فِيها فَقِيدَتِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","فَأجابَ الحِثِّيُّونَ إبْراهِيمَ: ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«اسْتَمِعْ إلَينا يا سَيِّدُ. أنتَ رَئِيسٌ عَظِيمٌ بَينَنا مِنَ اللهِ. فادفِنْ فَقِيدَتَكَ فِي أحسَنِ مَدافِنِنا. فَلنْ يَبخَلَ عَلَيكَ أحَدٌ بِقَبْرِهِ، أوْ يَمنَعَكَ مِنْ دَفْنِ فَقِيدَتِكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","فَقامَ إبْراهِيمُ وَانحَنَى احتِراماً لِسُكّانِ تِلْكَ الأرْضِ مِنَ الحِثِّيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","وَقالَ لَهُمْ: «إنْ كُنْتُمْ راغِبِينَ حقّاً فِي مُساعَدَتِي فِي دَفنِ فَقِيدَتِي، فَاسْتَمِعُوا إلَيَّ. أُرِيدُكُمْ أنْ تُكَلِّمُوا عِفْرُونَ بْنِ صُوحَرَ عَنِّي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","وَاطلُبُوا مِنْهُ أنْ يُعطِيَنِي مَغارَةَ المَكْفِيلَةِ الَّتِي يَملِكُها، وَالَّتِي تَقَعُ فِي طَرَفِ حَقلِهِ. وَلْيُعطِنِي إيّاها بِسِعْرٍ كامِلٍ بِحُضُورِكُمْ، فَتَكُونَ مَدْفَناً مُلْكاً لِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","وَكانَ عِفْرُونُ الحِثِّيُّ جالِساً هُناكَ بَينَ الحِثِّيِّينَ. فَرَدَّ عَلَى إبْراهِيمَ عَلَى مَسْمَعٍ مِنَ الحِثِّيِّينَ الَّذِينَ دَخَلُوا لِيَشْتَرِكُوا فِي المَجلِسِ عِنْدَ بابِ المَدِينَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","قالَ: «لا يا سَيِّدِي. اسْتَمِعْ إلَيَّ. الحَقلُ وَالمَغارَةً الَّتِي فِيهِ عَطِيَّةٌ مِنِّي إلَيكَ. وَأنا أُعطِيكَ إيّاهُما بِشَهادَةِ شَعبِيَ الحاضِرِ. فادفِنْ فَقِيدَتَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","فانْحَنَى إبْراهِيمُ أمامَ شَعبِ تِلْكَ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","وَقالَ لِعِفْرُونَ عَلَى مَسْمَعٍ مِنْ كُلِّ شَعبِ تِلْكَ الأرْضِ: «لَيتَكَ تَسْتَمِعُ إلَيَّ! دَعْنِي أدفَعْ ثَمَنَ الحَقلِ. اقْبَلْهُ مِنِّي، فَأدفِنَ فَقِيدَتِي هُناكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","فَرَدَّ عِفْرُونُ عَلَى إبْراهِيمَ: ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«يا سَيِّدِي، اسْتَمِعْ إلَيَّ. لا يُساوِي هَذا الحَقلُ أكثَرَ مِنْ أرْبَعِ مِئَةِ مِثْقالٍ مِنَ الفِضَّةِ. وَهُوَ مَبلَغٌ زَهيدٌ لَكَ وَلِي. فادْفِنْ فَقِيدَتَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","فَفَهِمَ إبْراهِيمُ أنَّ عِفْرُونَ يُريدُهُ أنْ يَسْمَعَ ثَمَنَ الأرْضِ. فَوَزَنَ لِعِفْرُونَ الفِضَّةَ الَّتِي حَدَّدَها عَلَى مَسْمَعٍ مِنْ رُؤَساءِ الحِثِّيِّينَ، أي أرْبَعَ مِئَةِ مِثْقالٍ مِنَ الفِضَّةِ حَسَبَ الأوْزانِ المُتَعارَفِ عَلَيها عِنْدَ التُّجّارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","وَهَكَذا انتَقَلَتْ مُلْكِيَّةُ حَقلِ عِفْرُونَ فِي المَكْفِيلَةِ، شَرْقِيَّ مَمْرا، إلَى إبْراهِيمَ. وَقَدْ شَمَلَ ذَلِكَ المَغارَةَ وَالأشْجارَ الَّتِي فِي الحَقلِ وَفِي المِنطَقَةِ المُحِيطَةِ بِها كُلِّها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","تَمَّ هَذا فِي حُضُورِ رُؤَساءِ الحِثِّيِّينَ، وَكُلِّ الَّذِينَ انضَمُّوا إلَى المَجلِسِ عِنْدَ بابِ المَدِينَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","فَدَفَنَ إبْراهِيمُ زَوجَتَهُ سارَةَ فِي مَغارَةِ حَقلِ المَكْفِيلَةِ، شَرْقِيَّ مَمْرا – أي حَبْرُونَ – فِي أرْضِ كَنْعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","وَهَكَذا صارَ الحَقلُ وَالمَغارَةُ الَّتِي فِيهِ مُلْكاً لإبْراهِيمَ مَدْفَناً، بِشِرائِهِما مِنَ الحِثِّيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","وَشاخَ إبْراهِيمُ، وَتَقَدَّمَ بِهِ العُمرُ. وَبارَكَهُ اللهُ فِي كُلِّ شَيْءٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","وَقالَ إبْراهِيمُ لِكَبيرِ خَدَمِ بَيتِهِ، المُشرِفِ عَلَى كُلِّ أملاكِهِ: «ضَعْ يَدَكَ تَحْتَ فَخْذِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","احلِفْ لِي بِإلَهِ السَّماءِ وَالأرْضِ، أنَّكَ لَنْ تَأْخُذَ لابْنِي زَوْجَةً مِنْ بَناتِ الكَنْعانِيِّينَ الَّذِينَ أسْكُنُ بَينَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","عِدْنِي بِأنَّكَ سَتَذْهَبُ إلَى أرْضِي وَأقرِبائِي، وَأنَّكَ سَتَأْخُذُ مِنْ هُناكَ زَوْجَةً لابْنِي إسْحاقَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","فَقالَ لَهُ الخادِمُ: «فَماذا إذا لَمْ تَرْضَ المَرْأةُ بِأنْ تَأْتِيَ مَعِي إلَى هَذِهِ الأرْضِ؟ فَهَلْ آخُذُ ابْنَكَ إلَى الأرْضِ الَّتِي تَرَكْتَها؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","فَقالَ لَهُ إبْراهِيمُ: «إيّاكَ أنْ تُعِيدَ ابْنِي إلَى هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","فَإلَهُ السَّماءِ، أخرَجَنِي مِنْ بَيتِ أبِي وَأرْضِ أقْرِبائِي. وَقَدْ كَلَّمَنِي وَقَطَعَ لِي عَهْداً فَقالَ: ‹سَأُعطِي هَذِهِ الأرْضَ لِنَسلِكَ.› وَهُوَ الَّذِي سَيُرْسِلُ مَلاكَهُ أمامَكَ لِيُعِينَكَ عَلَى أنْ تَأْخُذَ زَوْجَةً لابْنِي مِنْ هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","أمّا إذا لَمْ تَرْضَ المَرأةُ بِأنْ تَأْتِيَ مَعَكَ، فَأنْتَ فِي حِلٍّ مِنْ وَعْدِكَ هَذا لِي. لَكِنْ إيّاكَ أنْ تُعِيدَ ابْنِيَ إلَى هُناكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","فَوَضَعَ الخادِمُ يَدَهُ تَحْتَ فَخذِ إبْراهِيمَ وَحَلَفَ لَهُ فِي هَذا الأمْرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ثُمَّ أخَذَ الخادِمُ عَشْرَةً مِنْ جِمالِ سَيِّدِهِ، وَغادَرَ المَكانَ مُحَمَّلاً بِكُلِّ أنواعِ الهَدايا مِنْ سَيِّدِهِ. ثُمَّ سارَ إلَى أراضِي ما بَينَ النَّهْرَينِ، إلَى مَدِينَةِ ناحُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","وَأناخَ الجِمالَ خارِجَ المَدِينَةِ عِنْدَ النَّبْعِ. وَكانَ الوَقْتُ مَساءً عِنْدَما خَرَجَتِ النِّساءُ لِيَسْتَقِينَ ماءً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","فَقالَ الخادِمُ: «يا إلَهَ سَيِّدِي إبْراهِيمَ، وَفِّقْنِي اليَوْمَ فِي مَسْعايَ. وَأَظْهِرْ لُطْفَكَ لِسَيِّدِي إبْراهِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ها أنا واقِفٌ عِنْدَ عَينِ الماءِ. وَها فَتَياتُ أهلِ البَلدَةِ خارِجاتٌ لِيَسْتَقِينَ ماءً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","فَأعطِنِي هَذِهِ العَلامَةَ: إنْ قُلْتُ لِفَتاةٍ: ‹هاتِ جَرَّتَكِ لِأشْرَبَ،› فَأجابَتْ: ‹اشْرَبْ، وَسَأسْقِي جِمالَكَ أيضاً!› أعلَمُ أنَّها هِيَ الَّتِي اختَرْتَها أنتَ زَوْجَةً لِخادِمِكَ إسْحاقَ. وَبِهَذا أعرِفُ أنَّكَ أظهَرْتَ لُطفَكَ لِسَيِّدِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","وَقَبلَ أنْ يُنهِيَ الخادِمُ صَلاتَهُ، إذا بِرِفْقَةَ تُقبِلُ وَجَرَّتُها عَلَى كَتِفِها. وَهِيَ ابْنَةُ بَتُوئِيلَ ابْنِ مِلْكَةَ، زَوْجَةِ ناحُورَ، أخِي إبْراهِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","كانَتْ رِفْقَةُ جَمِيلَةً جِدّاً، وَعَذْراءَ لَمْ يَمَسَّها رَجُلٌ. فَنَزَلَتْ إلَى النَّبْعِ وَمَلأتْ جَرَّتَها، ثُمَّ صَعِدَتْ ثانِيَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","فَرَكَضَ الخادِمُ لِمُلاقاتِها وَقالَ لَها: «اسْقِينِي قَلِيلاً مِنَ الماءِ مِنْ جَرَّتِكِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","فَقالَتْ رِفْقَةُ: «اشْرَبْ يا سَيِّدِي.» وَأسْرَعَتْ فَأنزَلَتِ الجَرَّةَ عَنْ يَدِها وَسَقَتْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","وَبَعدَ أنْ سَقَتْهُ قالَتْ: «سأسْتَقِي لِجِمالِكَ أيضاً حَتَّى تَرْتَوَيَ جَمِيعاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","وَأسْرَعَتْ رِفْقَةُ فَأفْرَغَتْ جَرَّتَها فِي الحَوْضِ. وَرَكَضَتْ ثانِيَةً إلَى النَّبْعِ وَاسْتَقَتِ المَزِيدَ مِنَ الماءِ. فَأحضَرَتْ ماءً لِكُلِّ جِمالِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","وَكانَ الرَّجُلُ يُراقِبُها بِصَمْتٍ لِيَعْرِفَ إنْ كانَ اللهُ قَدْ أنجَحَ مَسْعاهُ أمْ لا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","فَبَعْدَ أنْ شَرِبَتِ الجِمالُ، أخرَجَ الرَّجُلُ حَلَقاً مِنَ الذَّهَبِ لِأنْفِها يَزِنُ نِصْفَ مِثْقالٍ، وَسِوارَينِ مِنَ الذَّهَبِ لِيَدَيها يَزِنانِ عَشْرَةَ مَثاقِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","وَقالَ لَها: «أرجُو أنْ تُخبِرِينِي ابْنَةَ مَنْ تَكُونِينَ. وَهَلْ لَنا مُتَّسَعٌ فِي بَيتِ أبِيكِ لِلمَبِيتِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","فَقالَتْ لَهُ رِفْقَةُ: «أنا ابْنَةُ بَتُوئِيلَ بْنِ مِلْكَةَ وَناحُورَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ثُمَّ قالَتْ: «لَدَينا تِبْنٌ وَعَلَفٌ كَثِيرٌ، وَيُوجَدُ لَكُمْ مُتَّسَعٌ لِلمَبِيتِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ثُمَّ حَنَى الرَّجُلُ رَأْسَهُ وَحَمَدَ اللهَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","قالَ: «تَبارَكَ إلَهُ سَيِّدِي إبْراهِيمَ. إذْ أظهَرَ وَفاءَهُ وَإخلاصَهُ لِسَيِّدِي. فَقَدْ قادَنِي اللهُ فِي طَرِيقِي إلَى بَيتِ أقارِبِ سَيِّدِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","فَرَكَضَتِ الفَتاةُ وَأخبَرَتْ بَيتَ أُمِّها بِهَذِهِ الأُمُورِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","وَكانَ لِرِفْقَةَ أخٌ اسْمُهُ لابانُ. فَخَرَجَ لابانُ إلَى النَّبْعِ بِاتِّجاهِ الرَّجُلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","فَرَأى الحَلَقَ، وَرَأى السِّوارَينِ حَولَ مِعصَمَيِّ أُختِهِ. فَلَّما رَوَتْ لَهُ أُختُهُ رِفْقَةُ ما قالَهُ لَها الرَّجُلُ، جَاءَ لابانُ إلَي الرَّجُلِ حَيثُ كانَ واقِفاً مَعَ الجِمالِ عِنْدَ النَّبْعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","فَقالَ لَهُ: «ادخُلْ إلَى بَيتِنا يا مَنْ بارَكَكَ اللهُ. لِماذا تَقِفُ خارِجاً؟ هَا البَيتُ مُعَدٌّ لاسْتِقبالِكَ، وَسَنُعِدُّ مَكاناً لِلجِمالِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ثُمَّ أنزَلَ لابانُ حُمُولَةَ الجِمالِ وَقَدَّمَ لَها تِبْناً وَعَلَفاً. وَأعطَى ماءً لِلرَّجُلِ وَلِلرِّجالِ الَّذِينَ مَعَهُ لِيَغسِلُوا أقْدامَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ثُمَّ وُضِعَ الطَّعامُ أمامَ خادِمِ إبْراهِيمَ لِيَأْكُلَ. لَكِنَّهُ قالَ: «لَنْ آكُلَ قَبلَ أنْ أقُولَ ما لَدَيَّ.» فَقالَ لَهُ لابانُ: «فَقُلْ ما عِنْدَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","فَقالَ: «أنا خادِمُ إبْراهِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","وَقَدْ بارَكَ اللهُ سَيِّدِي كَثِيراً فَصارَ غَنِيّاً جِدّاً. إذْ أعطاهُ اللهُ غَنَماً وَبَقَراً وَفِضَّةً وَذَهَباً وَخَدَماً وَخادِماتٍ وَجِمالاً وَحَمِيراً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","وَأنجَبَتْ سارَةُ، زَوْجَةُ سَيِّدِي، لَهُ ابْناً فِي شَيخُوخَتِهِ. وَأعطَى إبْراهِيمُ ابْنَهُ كُلَّ ما يَملِكُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","وَقَدِ اسْتَحلَفَنِي سَيِّدِي فَقالَ: ‹لا تَأْخُذْ لابْنِي زَوْجَةً مِنْ بَناتِ الكَنْعانِيِّينَ الَّذِينَ أسْكُنُ بَينَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","بَلِ اذْهَبْ إلَى بَيتِ أبِي وَأقارِبِي، وَخُذْ مِنْ هُناكَ زَوْجَةً لابْنِي.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","فَقُلْتُ لِسَيِّدِي: ‹رُبَّما تَرفُضُ الفَتاةُ أنْ تَأْتِيَ مَعِي.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","فَقالَ لِي: ‹لَقَدْ عِشْتُ فِي حَضْرَةِ اللهِ، وَأنا أعرِفُ أنَّهُ سَيُرْسِلُ مَلاكَهُ مَعَكَ، وَسَيُوَفِّقُكَ فِي رِحلَتِكَ. وَسَتَأْخُذُ زَوْجَةً لابْنِي مِنْ بَناتِ أقارِبِي وَبَيتِ أبِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","وَعِنْدَما تَذْهَبُ إلَى أقارِبِي تَكُونُ حُرّاً مِنْ هَذا القَسَمِ. سَتَكُونُ حُرّاً مِنْهُ حَتَّى لَوْ لَمْ يُعْطُوكَ زَوْجَةً لابْنِي.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«وَعِنْدَما جِئْتُ إلَى النَّبْعِ اليَوْمَ قُلْتُ: ‹يا إلَهَ سَيِّدِي إبْراهِيمَ، أنجِحْ رِحلَتِي وَمَسْعايَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ها أنا واقِفٌ عِنْدَ النَّبْعِ. فَأعطِنِي عَلامَةً. إنْ قُلْتُ لِفَتاةٍ تَأْتِي لِتَسْتَقِي: أعطِنِي قَلِيلاً مِنَ الماءِ مِنْ جَرَّتِكِ لِأشْرَبَ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","فَأجابَتْ: اشْرَبْ، وَسَأسْتَقِي ماءً لِجِمالِكَ أيضاً. لِتَكُنْ هِيَ الفَتاةَ الَّتِي اختارَها اللهُ لابْنِ سَيِّدِي.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","«وَقَبلَ أنْ أُنهِيَ صَلاتِيَ فِي قَلبِي، أتَتْ رِفْقَةُ وَجَرَّتُها عَلَى كَتِفِها. فَنَزَلَتْ إلَى النَّبْعِ وَاسْتَقَتْ ماءً. فَقُلْتُ لَها: ‹اسْقِينِي مِنْ فَضلِكِ.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","فَأسْرَعَتْ وَأنزَلَتِ الجَرَّةَ عَنْ كَتِفِها وَقالَتْ: ‹اشْرَبْ، وَسَأسْتَقِي ماءً لِجِمالِكَ أيضاً.› فَشَرِبْتُ، وَسَقَتِ الجِمالَ أيضاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ثُمَّ سَألْتُها: ‹ابْنَةُ مَنْ تَكُونِينَ؟› فَقالَتْ: ‹أنا ابْنَةُ بَتُوئِيلَ بْنِ ناحُورَ وَمِلْكَةَ.› فَوَضَعْتُ حَلَقاً فِي أنفِها، وَسِوارَينِ حَولَ مِعْصَمَيها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ثُمَّ حَنَيتُ رَأْسِي وَشَكَرْتُ اللهَ، وَبارَكْتُ إلَهَ سَيِّدِي إبْراهِيمَ. فَقَدْ هَدانِي فِي طَرِيقٍ صَحِيحٍ لِآخُذَ ابْنَةَ أخِي سَيِّدِي إبْراهِيمَ زَوْجَةً لابْنِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","وَالآنَ، إنْ كُنْتُمْ سَتَتَعامَلُونَ بِالإخلاصِ وَالوَفاءِ مَعَ سَيِّدِي، فَأخبِرُونِي. وَإلّا، فَأخبِرُونِي أيضاً، فَأعرِفَ ماذا أفْعَلُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","فَأجابَ لابانُ وَبَتُوئِيلُ: «هَذا الأمْرُ مِنْ عِنْدِ اللهِ، فَلَيْسَ لَنا أنْ نُغَيِّرَ ذَلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ها هِيَ رِفْقَةُ، فَخُذْها زَوْجَةً لابْنِ سَيِّدِكَ كَما قَضَى اللهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","فَلَمّا سَمِعَ خادِمُ إبْراهِيمَ كَلامَهُما، سَجَدَ للهِ عَلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ثُمَّ أخرَجَ الخادِمُ كُلَّ الفِضَّةِ وَالذَّهَبِ وَالثِّيابِ، وَأعطاها لِرِفْقَةَ. كَما قَدَّمَ هَدايا ثَمِينَةً لِأخِيها وَأُمِّها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","فَأكَلَ وَشَرِبَ مَعَ الَّذِينَ مَعَهُ، وَباتُوا هُناكَ. وَلَمّا نَهَضُوا فِي الصَّباحِ قالَ الخادِمُ: «اسمَحُوا لِي بِالذَّهابِ إلَى سَيِّدِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","لَكِنَّ أخا رِفْقَةَ وَأُمَّها قالا: «لِتَبْقَ الفَتاةُ مَعَنا عَشْرَةَ أيّامٍ عَلَى الأقَلِّ، وَبَعْدَ ذَلِكَ تَذْهَبُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","لَكِنَّ الخادِمَ قالَ: «لا تُؤَخِّرانِي، فَقَدْ وَفَّقَ اللهُ رِحلَتِي وَمَسْعايَ. أطلِقُونِي فَأعُودَ إلَى سَيِّدِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","فَقالوا: «نَدعُو الفَتاةَ وَنَسألُها أمامَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","فَدَعَوْا رِفْقَةَ وَسَألاها: «هَلْ تُرِيدِينَ الذَّهابَ مَعَ الرَّجُلِ الآنَ؟» فَقالَتْ رِفْقَةُ: «نَعَمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","فَصَرَفا رِفْقَةَ وَمُرَبِّيَتَها مَعَ خادِمِ إبْراهِيمَ وَرِجالِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","وَبارَكُوا أُختَهُمْ رِفْقَةَ وَقالُوا: «لَيتَكِ تَصِيرِينَ، يا أُختَنا، أُمّاً لِمَلايِينَ مِنَ النّاسِ. وَلَيتَ أحفادَكِ يَسْتَولُونَ عَلَى مُدُنِ أعدائِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","فَقامَتْ رِفْقَةُ وَخادِمَتُها وَرَكِبْنَ عَلَى الجِمالِ، وَتَبِعْنَ الرَّجُلَ. وَهَكَذا أخَذَ الخادِمُ رِفْقَةَ وَمَضَى فِي طَرِيقِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","وَكانَ إسْحاقُ قَدْ تَرَكَ مُخَيَّمَهُ قُرْبَ مَدْخَلِ بِئْرِ لَحْيَ رُئِي وَسَكَنَ فِي النَّقَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","فَخَرَجَ لِيَتَفَكَّرَ قَبلَ المَساءِ فِي الحَقلِ. وَرَفَعَ نَظَرَهُ، فَإذا بِهِ يَرَى جِمالاً قادِمَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","وَرَفَعَتْ رِفقَةُ نَظَرَها فَرَأتْ إسْحاقَ. فَتَرَجَّلَتْ عَنِ الجَمَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ثُمَّ سَألَتِ الخادِمَ: «مَنْ هُوَ هَذا الرَّجُلُ الماشِي فِي الحَقلِ لِمُلاقاتِنا؟» فَقالَ الخادِمُ: «إنَّهُ سَيِّدِي!» فَأخَذَتْ رِفقَةُ الخِمارَ وَغَطَّتْ وَجهَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ثُمَّ رَوَى الخادِمُ لإسْحاقَ كُلَّ ما فَعَلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","وَبَعْدَ ذَلِكَ أدخَلَ إسْحاقُ رِفْقَةَ إلَى خَيمَةِ أُمِّهِ سارَةَ لِيَتَزَوَّجَها. وَأحَبَّها كَثِيراً. فَتَعَزَّى إسْحاقُ بَعْدَ مَوْتِ أُمِّهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","وَتَزَوَّجَ إبْراهِيمُ امْرأةً أُخْرَى اسْمُها قَطُورَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","وَأنْجَبَتْ زِمْرانَ وَيَقْشانَ وَمَدانَ وَمِدْيانَ وَيِشْباقَ وَشُوحَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","وَأنجَبَ يَقْشانُ شَبا وَدَدانَ. وَنَسلُ دَدانَ هُمْ شَعبُ أشُّورِيمَ وَلَطُوشِيمَ وَلأُمِّيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","أمّا أولادُ مِدْيانَ فَهُمْ عَيفَةُ وَعِفْرُ وَحَنُوكُ وَأبِيداعُ وَألْدَعَةُ. كانَ هَؤُلاءِ جَمِيعاً أبْناءَ قَطُورَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","وَمَلَّكَ إبْراهِيمُ إسْحاقَ كُلَّ ما كانَ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","لَكِنَّهُ قَدَّمَ هِباتٍ لِأبْناءِ جَوارِيهِ. وَأثْناءَ حَياتِهِ، صَرَفَهُمْ شَرْقاً بَعِيداً عَنِ ابْنِهِ إسْحاقَ إلَى أرْضِ المَشْرِقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","وَعاشَ إبْراهِيمُ مِئَةً وَخَمْساً وَسَبْعِينَ سَنَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","وَأسلَمَ رُوحَهُ فِي سِنِّ الشَّيخُوخَةِ، بَعْدَ حَياةٍ طَوِيلَةٍ مُرْضِيَةٍ، وَضُمَّ إلَى جَماعَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","وَدَفَنَهُ ابْناهُ إسْحاقُ وَإسْماعِيلُ فِي كَهفِ المَكْفِيلَةِ فِي حَقلِ عِفْرُونَ بْنِ صُوحَرَ الحِثِّيِّ، الَّذِي يَقَعُ شَرْقِيَّ مَمْرا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","وَهُوَ الكَهْفُ الَّذِي اشْتَراهُ إبْراهِيمُ مِنَ الحِثِّيِّينَ. وَدُفِنَ هُناكَ إبْراهِيمُ وَامْرَأتُهُ سارَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","وَبَعْدَ مَوْتِ إبْراهِيمَ، بارَكَ اللهُ ابْنَهُ إسْحاقَ. وَاسْتَقَرَّ إسْحاقُ عِنْدَ بِئْرِ لَحَي رُئِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","هَذِهِ أسْماءُ أبناءِ إسْماعِيلَ الَّذِي أنْجَبَهُ إبْراهِيمُ مِنَ الجارِيَةِ المِصْرِيَّةِ هاجَرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","هَذِهِ أسْماءُ أولادِ إسْماعِيلَ حَسَبَ تَسَلْسُلِ وِلادَتِهِمْ: نَبايُوتُ، وَهُوَ بِكْرُ إسْماعِيلَ، وَقِيدارُ وَأدَبْئِيلُ وَمِبْسامُ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","وَمِشْماعُ وَدُومَةُ وَمَسّا ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","وَحَدارُ وَتَيماء وَيَطُورُ وَنافِيشُ وَقِدْمَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","هَؤُلاءِ هُمْ أولادُ إسْماعِيلَ. وَهَذِهِ أسْماؤُهُمُ الَّتِي سُمِّيَتْ عَلَيها قُراهُمْ وَمُخَيَّماتُهُمْ. وَكانُوا اثْنَي عَشَرَ شَيخَ عَشِيرَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","وَعاشَ إسْماعِيلُ مِئَةً وَسَبْعاً وَثَلاثِينَ سَنَةً. وَلَفَظَ أنفاسَهُ الأخِيرَةَ وَماتَ. وَضُمَّ إلَى جَماعَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","وَنَصَبُوا خِيامَهُمْ مِنْ حَوِيلَةَ إلَى سُورِ مِصْرَ، امْتِداداً إلَى أشُّورَ فِي مُواجَهَةِ إخْوَتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","وَهَذِهِ هِيَ قِصَّةُ عائِلَةِ إسْحَاقَ بْنِ إبْراهِيمَ. وَلَدَ إبْراهِيمُ إسْحَاقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","وَكانَ إسحَاقُ فِي الأرْبَعِينَ مِنْ عُمْرِهِ حِينَ تَزَوَّجَ رِفْقَةَ بِنتَ بَتُوئِيلَ الأرامِيِّ، الّذِي مِنْ فَدَّانَ أرامَ، وَهِيَ أُخْتُ لابانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","وَصَلَّى إسْحَاقُ إلَى اللهِ لأجلِ زَوْجَتِهِ لأنَّها كانَتْ عاقِراً. وَاسْتَجابَ لَهُ اللهُ، فَحَبِلَتْ رِفْقَةُ زَوْجَتُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","وَتَرافَسَ الوَلَدانِ داخِلَها. فَقالَتْ رِفْقَةُ: «إنْ كانَ الأمْرُ هَكَذا، فَلِماذا أنا حُبلَى؟» فَذَهَبَتْ لِتَسألَ اللهَ عَمّا يَحدُثُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","فَقالَ لَها اللهُ: «فِي داخِلِكِ أُمَّتانِ، وَمِنْ بَطْنِكِ يَنْقَسِمُ شَعْبانِ. وَيَكُونُ أحَدُهُما أقْوَى مِنَ الآخَرِ، وَأكْبَرُهُما سَيَخْدِمُ أصْغَرَهُما.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","وَلَمّا حانَ وَقْتُ الوِلادَةِ، أنجَبَتْ تَوْأميْنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","كانَ الأوَّلُ أحمَرَ البَشَرَةِ، وَجِلْدُهُ أشْبَهُ بِرِداءٍ كَثِيفٍ مِنَ الشَّعْرِ. فَسُمِّيَ عِيسُو. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ثُمَّ خَرَجَ أخُوهُ وَيَدُهُ مُمْسِكَةٌ بِعَقِبِ عِيسُو، فَسُمِّيَ يَعْقُوبُ. وَكانَ إسْحاقُ فِي السِّتِّينَ مِنْ عُمْرِهِ عِنْدَما وُلِدا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","وَكَبِرَ الوَلَدانِ. وَصارَ عِيسُو صَيّاداً ماهِراً مُحِبّاً لِلبَقاءِ فِي الخَلاءِ. أمّا يَعْقُوبُ فَكانَ رَجُلاً هادِئاً يَلْزَمُ المُخَيَّمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","وَكانَ إسْحاقُ يُفَضِّلُ عِيسُو، لِأنَّهُ يُحِبُّ ما يَصْطادُهُ لَهُ. أمّا رِفْقَةُ فَكانَتْ تُفَضِّلُ يَعقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","وَذاتَ يَوْمٍ، كانَ يَعقُوبُ يَطبُخُ حَساءً. فَجاءَ عِيسُو مِنَ الحَقلِ، وَكانَ قَدْ أعْياهُ الجُوعُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","فَقالَ عِيسُو لِيَعْقُوبَ: «أطْعِمْنِي مِنْ ذَلِكَ الحَساءِ الأحْمَرِ، فَأنا جائِعٌ جِدّاً.» وَلِهَذا صارَ عِيسُو يُدْعَى أيضاً أدُومَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","فَقالَ لَهُ يَعْقُوبُ: «بِعْنِي أوَّلاً حُقُوقَكَ كابنٍ بِكْرٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","فَقالَ عِيسُو: «ها أنا أمُوتُ مِنَ الجُوعِ، فَما نَفْعُ حُقُوقِي كَبِكْرٍ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","فَقالَ يَعقُوبُ: «احلِفْ بِذَلِكَ أوَّلاً!» فَحَلَفَ لَهُ عِيسُو، وَباعَ حُقُوقَ بُكُورِيَّتِهِ لِيَعْقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","وَأعطَى يَعْقُوبُ عِيسُو خُبْزاً وَعَدَساً مَطْبُوخاً فَأكَلَ عِيسُو وَشَرِبَ وَقامَ وَمَضَى مُسْتَهيناً بِحُقُوقِهِ كابنٍ بِكْرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","وَحَدَثَتْ فِي البِلادِ مَجاعَةٌ غَيرُ المَجاعَةِ الأُولَى الَّتِي حَدَثَتْ فِي زَمَنِ إبْراهِيمَ. فَذَهَبَ إسْحاقُ إلَى مَدِينَةِ جَرارَ، إلَى أبِيمالِكَ مَلِكِ الفِلِسْطِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","فَظَهَرَ اللهُ لإسْحاقَ وَقالَ لَهُ: «لا تَنْزِلْ إلَى مِصْرَ. بَلِ امْكُثْ فِي الأرْضِ الَّتِي سَأقُولُ لَكَ عَنْها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","عِشْ فِي هَذِهِ الأرْضِ غَرِيباً، وَسَأكُونُ مَعَكَ وَسَأُبارِكُكَ. إذْ سَأُعطِيكَ وَنَسلَكَ كُلَّ هَذِهِ الأراضِي. وَسَأفِي بِقَسَمِي الَّذِي أقْسَمْتُهُ لإبْراهِيمَ أبِيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","سَأُضاعِفُ نَسلَكَ لِيَكُونُوا بِعَدَدِ نُجُومِ السَّماءِ. وَسَأُعطِي نَسلَكَ كُلَّ هَذِهِ الأراضِي، وَسَتنالُ كُلُّ اًمَمِ الأرْضِ بَرَكَةً بِنَسلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","لِأنَّ إبْراهِيمَ أطاعَ كَلامِيَ، وَعَمِلَ بِوَصايايَ وَأحكامِي وَشَرائِعِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","فَاسْتَقَرَّ إسْحاقُ فِي جَرارَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","فَسَألَهُ أهلُ تِلْكَ المَنْطَقَةِ عَنْ زَوْجَتِهِ. فَقالَ: «إنَّها أُختِي.» فَقَدْ خافَ أنْ يَقُولَ: «إنَّها زَوْجَتِي.» إذْ قالَ فِي نَفسِهِ: «سَأقُولُ إنَّها أُختِي لِئَلّا يَقْتُلُونِي طَمَعاً فِي رِفْقَةَ، لِأنَّها جَمِيلَةٌ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","وَبَعْدَ أنْ طالَتْ بِهِ الأيّامُ هُناكَ، نَظَرَ أبِيمالِكُ مَلِكُ الفِلِسْطِيِّينَ مِنْ نافِذَةٍ، وَرَأى إسْحاقَ يُلاطِفُ زَوْجَتَهُ رِفْقَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","فَدَعا أبِيمالِكُ إسْحاقَ وَقالَ: «هِيَ امْرَأتُكَ إذاً! فَلِماذا قُلْتَ إنَّها أُخْتُكَ؟» فَقالَ إسْحاقُ لِأبِيمالِكَ: «خِفْتُ أنْ أمُوتَ بِسَبَبِها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","فَقالَ أبِيمالِكُ: «ما هَذا الَّذِي فَعَلْتَهُ بِنا؟ كانَ مُمْكِناً أنْ يُعاشِرَ واحِدٌ مِنْ جَماعَتِنا امْرَأتَكَ. لَوْ حَدَثَ هَذا، لَكُنْتَ قَدْ جَلَبْتَ عَلَينا ذَنْباً عَظِيماً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","حِينَئِذٍ، أمَرَ أبِيمالِكُ كُلَّ قَوْمِهِ وَقالَ: «مَنْ يُؤذِي هَذا الرَّجُلَ أوْ زَوْجَتَهُ يُقْتَلُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","وَزَرَعَ إسْحاقُ بُذُوراً فِي تِلْكَ الأرْضِ. وَفِي السَّنَةِ نَفْسِها حَصَدَ مِئَةَ ضِعْفٍ. وَبارَكَ اللهُ إسْحاقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","فَصارَ غَنِيّاً. ثُمَّ ازْدادَ غِنَىً أكثَرَ فَأكْثَرَ حَتَّى صارَ ثَرِيّاً جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","فَكانَتْ لَهُ قُطْعانٌ كَثِيرَةٌ مِنَ المَواشِي وَالبَقَرِ وَخُدّامٌ كَثِيرُونَ. فَحَسَدَهُ الفِلِسْطِيُّونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","وَكانَ الفِلِسْطِيُّونَ قَدْ طَمُّوا كُلَّ الآبارِ الَّتِي سَبَقَ أنْ حَفَرَها خُدّامُ أبِيهِ إبْراهِيمَ فِي زَمَنِهِ وَمَلأُوها تُراباً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","فَقالَ أبِيمالِكُ لإسْحاقَ: «فارِقْنا، فَقَدْ أصْبَحتَ أقْوَى مِنّا بِكَثِيرٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","فانصَرَفَ إسْحاقُ مِنْ هُناكَ، وَخَيَّمَ فِي وادِي جَرارَ، وَاسْتَقَرَّ هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","وَحَفَرَ إسْحاقُ آبارَ الماءِ الَّتِي حُفِرَتْ فِي أيّامِ أبِيهِ إبْراهِيمَ مِنْ جَدِيدٍ. إذْ كانَ الفِلِسْطِيُّونَ قَدْ طَمَرُوها بَعْدَ مَوْتِ إبْراهِيمَ. وَدَعاها إسْحاقُ بِالأسْماءَ نَفْسِها الَّتِي دَعاها بِها أبوْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","فَحَفَرَ خُدّامُ إسْحاقَ فِي الوادِي، وَوَجَدُوا نَبْعاً ذا مِياهٍ عَذْبَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","لَكِنَّ رُعاةَ جَرارَ تَنازَعُوا مَعَ رُعاةِ إسْحاقَ وَقالُوا: «الماءُ ماؤُنا.» فَسَمَّى إسْحاقُ المَكانَ عِسِقَ، لِأنَّهُمْ تَنازَعُوا مَعَهُ عَلَيها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ثُمَّ حَفَرَ خُدّامُ إسْحاقَ بِئْراً أُخْرَى. فَنازَعَهُ أهلُ جَرارَ عَلَيها أيضاً. فَسَمّاها إسْحاقُ سِطْنَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","فانْتَقَلَ إسْحاقُ مِنْ هُناكَ وَحَفَرَ بِئْراً أُخْرَى. فَلَمْ يُنازِعُوهُ عَلَيها. فَسَمّاها رَحُوبُوتَ، وَقالَ: «الآنَ وَسَّعَ اللهُ لَنا، وَسَنَصِيرُ أكثَرَ عَدَداً فِي الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","وَانْتَقَلَ إسْحاقُ مِنْ هُناكَ إلَى بِئْرِ السَّبْعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","وَظَهَرَ لَهُ اللهُ فِي تِلْكَ اللَّيلَةِ وَقالَ: «أنا إلَهُ إبِيكَ إبْراهِيمَ، فَلا تَخَفْ، لِأنِّي مَعَكَ، وَسَأُبارِكُكَ. وَسَأُكَثِّرُ نَسلَكَ مِنْ أجلِ إبْراهِيمَ عَبْدِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","فَبَنَى إسْحاقُ مَذبَحاً هُناكَ، وَدَعا بِاسمِ اللهِ. وَنَصَبَ هُناكَ خَيمَتَهُ. وَحَفَرَ خُدّامُ إسْحاقَ بِئْراً هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","وَجاءَ إلَيهِ أبِيمالِكُ مِنْ جَرارَ مَعَ صاحِبِهِ أحُزّاتَ وَفِيكُولَ آمِرِ جَيشِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","فَقالَ لَهُمْ إسْحاقُ: «لِماذا جِئْتُمْ إلَيَّ؟ فَأنْتُمْ تُبْغِضُونَنِي، وَقَدْ صَرَفْتُمُونِي مِنْ أرْضِكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","فَقالُوا لَهُ: «الآنَ تَأكَّدْنا أنَّ اللهَ مَعَكَ. فَقُلْنا: ‹لِيَحلِفْ أحَدُنا لِلآخَرِ عَلَى الوَفاءِ، وَلْنَقطَعْ مَعَكَ عَهْداً.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","عِدْ بِأنَّكَ لَنْ تُؤْذِيَنا. فَنَحْنُ لَمْ نُؤْذِكَ. بَلْ لَمْ نَصنَعْ مَعَكَ إلّا خَيراً. وَقَدْ صَرَفْناكَ فِي سَلامٍ. وَأنتَ الآنَ مُبارَكٌ مِنَ اللهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","فَأعَدَّ لَهُمْ وَلِيمَةً، فَأكَلُوا وَشَرِبُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","وَبَكَّرُوا فِي الصَّباحِ وَتَعاهَدُوا. ثُمَّ وَدَّعَهُمْ إسْحاقُ، فَمَضُوا فِي سَلامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","وَفِي ذَلِكَ اليَوْمِ جاءَ خُدّامُ إسْحاقَ وَأخبَرُوهُ عَنِ البِئْرِ الَّتِي حَفَرُوها. قالُوا لَهُ: «لَقَدْ وَجَدْنا ماءً!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","فَسَمّاها شِبْعَةَ. وَلِهَذا فَإنَّ اسْمَ المَدِينَةِ هُوَ بِئْرُ السَّبْعِ حَتَّى يَومِنا هَذا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","وَلَمّا بَلَغَ عِيسُو الأربَعِينَ مِنَ العُمْرِ، تَزَوَّجَ يَهُودِيتَ ابْنَةَ بِيرِيَ الحِثِّيِّ، وَبَسْمَةَ ابْنَةَ إيلُونَ الحِثِّيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","فَكانَتا مَصْدَرَ حُزْنٍ لإسْحاقَ وَرِفْقَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","وَشاخَ إسْحاقُ، وَضَعُفَتْ عَيناهُ فَلَمْ يَعُدْ يَقْدِرُ أنْ يُبصِرَ. فَدَعا بِكْرَهُ عِيسُو وَقالَ لَهُ: «تَعالَ يا ابْنِي.» فَقالَ عِيسُو: «سَمْعاً وَطاعَةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","فَقالَ إسْحاقُ: «ها أنا قَدْ شِخْتُ. وَلا أدرِي مَتَى سَأمُوتُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","فَالآنَ خُذْ عُدَّةَ صَيدِكَ: جُعبَةَ سِهامِكَ وَقَوْسَكَ. وَاخرُجْ إلَى الحَقلِ، وَاصْطَدْ لِي حَيواناً آكُلُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","أعِدَّ لِي طَعاماً طَيِّباً مِمّا أُحِبُّ، وَأحضِرْهُ لِي لآكُلَهُ، لِكَي أُبارِكَكَ قَبلَ أنْ أمُوتَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","فَخَرَجَ عِيسُو إلَى الحَقلِ لِيصْطادَ. أمّا رِفْقَةُ فَكانَتْ تُصْغِي لِحَدِيثِ إسْحاقَ وَعِيسُو ابْنِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","فَقالَتْ رِفْقَةُ لِيَعقُوبَ ابْنِها: «اسْمَعْ، سَمِعْتُ أباكَ يَقُولُ لِأخِيكَ عِيسُو: ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹اجلِبْ لِي صَيداً وَأعِدَّ لِي طَعاماً طَيِّباً لِآكُلَ، فَأُبارِكَكَ فِي حَضْرَةِ اللهِ قَبلَ أنْ أمُوتَ.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","وَالآنَ، أطِعْنِي، يا ابْنِي، وَافْعَلْ ما أقُولُهُ لَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","اذْهَبْ إلَى قَطِيعِ الغَنَمِ، وَأحْضِرْ جَديَينِ مِنْ خِيارِ القَطِيعِ. سَأُعِدُّ مِنْهُما لِأبِيكَ طَعاماً طَيِّباً مِمّا يُحِبُّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","فَخُذِ الطَّعامَ لِأبِيكَ لِيَأْكُلَهُ، لِكَي يُبارِكَكَ قَبلَ مَوْتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","فَقالَ يَعقُوبُ لِأُمِّهِ رِفْقَةَ: «أخِي كَثِيرُ الشَّعْرِ، وَأمّا أنا فَأملَسُ الجِلْدِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","فَإذا لَمَسَنِي، اكتَشَفَ أنِّي أُحاوِلُ خِداعَهُ. وَبِهَذا سَأجلِبُ عَلَى نَفْسِي لَعْنَةَ وَالِدِي بَدَلاً مِنْ بَرَكَتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","فَقالَتْ لَهُ أُمُّهُ: «لِتَأْتِ عَلَيَّ أيَّةُ لَعْنَةٍ تُطلَقُ عَلَيكَ. فافْعَلْ ما أقُولُهُ لَكَ. اذْهَبْ وَأحضِرِ الجَدْيَينِ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","فَمَضَى وَأمسَكَ الجَدْيَينِ وَأحضَرَهُما لِأُمِّهِ. فَأعَدَّتْ طَعاماً طَيِّباً مِمّا يُحِبُّ أبوْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ثُمَّ أخَذَتْ رِفْقَةُ أفضَلَ مَلابِسِ بِكْرِها عِيسُو الَّتِي كانَتْ عِندَها فِي البَيتِ، وَألبَسَتْها لابْنِها الأصْغَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","وَوَضَعَتْ جُلُودَ جَدْيِ المِعزَى عَلَى يَدَيهِ وَعَلَى عُنْقِهِ الأملَسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","وَأعطَتِ ابْنَها يَعقُوبَ الطَّعامَ الطَّيِّبَ وَالخُبْزَ الَّذِي أعَدَّتْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","فَذَهَبَ يَعقُوبُ إلَى أبِيهِ وَقالَ: «يا أبِي.» فَقالَ إسْحاقُ: «نَعَمْ، يا ابْنِي. أيُّ وَلَدَيَّ أنتَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","فَقالَ يَعقُوبُ لِأبِيهِ: «أنا عِيسُو بِكْرُكَ. وَقَدْ فَعَلْتُ كَما طَلَبْتَ مِنِّي. فَتَعالَ وَاجلِسْ وَكُلْ مِمّا اصْطَدْتُ، لِكَي تُبارِكَنِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","فَقالَ إسْحاقُ لِيَعقُوبَ: «كَيفَ وَجَدْتَ صَيداً بِهَذِهِ السُّرْعَةِ يا بُنَيَ؟» فَقالَ: «لِأنَّ إلَهَكَ وَضَعَهُ فِي طَرِيقِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","فَقالَ إسْحاقُ لِيَعقُوبَ: «اقْتَرِبْ لِألمَسَكَ يا بُنَيَ، فَأعرِفَ إنْ كُنتَ حَقّاً ابْنِي عِيسُو.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","فَاقتَرَبَ يَعقُوبُ مِنْ إسْحاقَ أبِيهِ، فَلَمَسَهُ إسْحاقُ. ثُمَّ قالَ إسْحاقُ: «صَوْتُكَ كَصَوْتِ يَعقُوبَ، أمّا مَلْمَسُ يَدَيكَ فَكَمَلْمَسِ يَدَي عِيسُو.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","لَمْ يَسْتَطِعْ إسْحاقُ أنْ يُمَيِّزَ يَعقُوبَ، لِأنَّ يَدَي يَعْقُوبَ كانَتا غَزيرَتَيِ الشَّعْرِ كَيَدَي أخِيهِ عِيسُو. فَبارَكَهُ إسْحاقُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","وَقالَ لَهُ: «أأنْتَ حَقّاً عِيسُو ابْنِي؟» فَقالَ يَعقُوبُ: «نَعَمْ أنا هُوَ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","فَقالَ إسْحاقُ: «أعطِنِي بَعضاً مِنَ اللَّحْمِ لِآكُلَ يا بُنَيَّ، لِكَي أُبارِكَكَ.» فَأعطاهُ يَعقُوبُ لَحماً، فَأكَلَهُ. وَأحضَرَ أيضاً نَبيذاً فَشَرِبَهُ إسْحاقُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ثُمَّ قالَ لَهُ أبوْهُ إسْحاقُ: «اقْتَرِبْ وَقَبِّلْنِي، يا بُنِيَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","فَاقتَرَبَ يَعقُوبُ وَقَبَّلَهُ. فَشَمَّ إسْحاقُ رائِحَةَ مَلابِسِهِ، فَبارَكَهُ. وَقالَ: «ها رائِحَةُ ابْنِي كَرائِحَةِ حَقلٍ بارَكَهُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","لِيُعطِكَ اللهُ مِنَ السَّماءِ نَدَىً، وَحُقُولاً خَصِيبَةً، وَوَفْرَةً فِي القَمْحِ وَالنَّبيذِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","لِتَخْدِمْكَ شُعُوبٌ، وَلْتَنْحَنِ أُمَمٌ أمامَكَ. وَلْتَكُنْ سَيِّدَ إخْوَتِكَ، وَلْيَنحَنِ لَكَ أولادُ أُمِّكَ. «فَلِيُلْعَنْ لاعِنُوكَ، وَليُبارَكْ مُبارِكُوكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","وَلَمّا انتَهَى إسْحاقُ مِنْ مُبارَكَةِ يَعقُوبَ، انصَرَفَ يَعقُوبُ مِنْ مَحضَرِهِ. وَعادَ أخُوهُ عِيسُو مِنْ صَيدِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","وَأعَدَّ عِيسُو طَعاماً طَيِّباً وَأحضَرَهُ لِأبِيهِ. وَقالَ لِأبِيهِ: «يا أبِي، قُمْ وَكُلْ مِنَ اللَّحمِ الَّذِي أحضَرْتُ لَكَ لِكَي تُبارِكَنِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","فَقالَ إسْحاقُ أبوْهُ لَهُ: «مَنْ أنتَ؟» فَقالَ عِيسُو: «أنا ابْنُكَ، بِكْرُكَ عِيسُو.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","فارْتَجَفَ إسْحاقُ ارتِجافاً عَظِيماً وَقالَ: «فَمَنِ الَّذِي اصطادَ حَيواناً وَأحضَرَهُ إلَيَّ إذاً؟ لَقَدْ أكَلْتُهُ كُلَّهُ وَبارَكْتُهُ قَبلَ أنْ تَأْتِيَ. وَسَيَكُونُ مَنْ بارَكْتُهُ مُبارَكاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","فَلَمّا سَمِعَ عِيسُو كَلامَ أبِيهِ، صَرَخَ صُراخاً عالِياً وَمُرّاً جِدّاً. وَقالَ لِأبِيهِ: «بارِكْنِي، أنا أيضاً يا أبِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","فَقالَ إسْحاقُ: «جاءَ أخُوكَ وَاحتالَ عَلَيَّ وَأخَذَ بَرَكَتَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","فَقالَ عِيسُو: «لَمْ يُخطِئْ مَنْ سَمّاهُ يَعْقُوبَ! هَذِهِ هِيَ المَرَّةُ الثّانِيَةُ الَّتِي يَحتالُ فِيها عَلَيَّ. سَبَقَ أنْ أخَذَ حُقُوقِي كابنٍ بِكْرٍ، وَالآنَ أخَذَ بَرَكَتِي.» ثُمَّ قالَ عِيسُو: «أما احتَفَظْتَ لِي بِبَرَكَةٍ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","فَقالَ إسْحاقُ لِعِيسُو: «جَعَلْتُهُ عَلَيكَ سَيِّداً، وَجَعَلْتُ كُلَّ إخْوَتِهِ لَهُ خُدّاماً. وَأعطَيتُهُ قَمْحاً وَنَبيذاً أيضاً. فَما الَّذِي تَبَقَّى؟ وَماذا يُمْكِنُنِي أنْ أفْعَلَ لَكَ، يا ابْنِي؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","فَقالَ عِيسُو لِأبِيهِ: «أما عِندَكَ وَلا بَرَكَةٌ واحِدَةٌ يا أبِي؟ بارِكْنِي أنا أيضاً، يا أبِي!» ثُمَّ بَدَأ عِيسُو يَنُوحُ بِصَوْتٍ عالٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","فَقالَ لَهُ أبوْهُ: «ها مَسْكَنُكَ يَكُونُ بَعِيداً عَنِ الأراضِي الخَصِيبَةِ، وَبِلا نَدَى السَّماءِ مِنْ فَوْقُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","بِسَيفِكَ تَعِيشُ، وَخادِماً لِأخِيكَ تَكُونُ. لَكِنْ حِينَ تُجاهِدُ لِتُحَرِّرَ نَفْسَكَ، تُفلِتُ مِنْ سَيطَرَتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","فَأبغَضَ عِيسُو يَعقُوبَ بِسَبَبِ مُبارَكَةِ أبِيهِ إيّاهُ، وَقالَ فِي قَلْبِهِ: «قَرُبَ وَقْتُ البُكاءِ وَالنَّوْحِ عَلَى أبِي، ثًمَّ سَأقتُلُ يَعقُوبَ أخِي!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","فَوَصَلَ إلَى مَسامِعِ رِفْقَةَ خَبَرُ تَخطِيطِ عِيسُو لِقَتلِ يَعقُوبَ. فَأرسَلَتْ فِي طَلَبِ ابْنِها الأصغَرِ وَقالَتْ لَهُ: «اسْمَعْ. إنَّ أخاكَ عِيسُو يُفَكِّرُ بِقَتلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","فاسْمَعِ الآنَ ما أقُولُهُ، يا ابْنِي. اذْهَبْ حالاً إلَى بَيتِ أخِي لابانَ فِي حارانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","وَابْقَ عِندَهُ بَعضَ الوَقْتِ إلَى أنْ يَهدَأ غَضَبُ أخِيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","امكُثْ لَدَيهِ إلَى أنْ يَرتَدَّ عَنْكَ غَضَبُهُ. وَيَنسَى ما فَعَلْتَهُ بِهِ. حِينَئِذٍ، سَأُرْسِلُ خادِماً يَسْتَدْعِيَكَ مِنْ هُناكَ. فَأنا لا أُرِيدُ أنْ أخسَرَكُما الاثْنَينِ فِي نَفْسِ اليَوْمِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","وَقالَتْ رِفقَةُ لإسْحاقَ: «لَقَدْ سَئِمْتُ حَياتِي مِنَ المَرأتَينِ الحِثِّيَّتَينِ. فَإذا تَزَوَّجَ يَعقُوبُ فَتاةً حِثِّيَّةً أيضاً مِنْ هَذِهِ الأرْضِ، فَإنِّي أُفَضِّلُ المَوْتَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ثُمَّ دَعا إسْحاقُ يَعقُوبَ وَبارَكَهُ، وَأوصاهُ: «لا تَتَزَوَّجْ مِنَ امْرأةٍ كَنْعانِيَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","بَلِ اذْهَبْ فَوراً إلَى فَدَّانَ أرامَ. إلَى بَيتِ بَتُوئِيلَ، أبِي أُمِّكَ. وَتَزَوَّجِ امْرأةً مِنْ هُناكَ، مِنْ بَناتِ خالِكَ لابانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","لْيُبارِكْكَ اللهُ الجَبّارُ. وَلْيُعطِكَ أبْناءً كَثِيرِينَ فَتُصْبِحَ أباً لِمَجمُوعَةٍ مِنَ الشُّعُوبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","لِيُبارِكْكَ اللهُ كَما بارَكَ إبْراهِيمَ، أنتَ وَنَسلَكَ مَعاً. لِيُبارِكْكَ هَكَذا فَتَمْتَلِكَ الأرْضَ الَّتِي تَعِيشُ فِيها غَرِيباً، الأرْضَ الَّتِي أعطاها اللهُ لإبْراهِيمَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","فَأرْسَلَ إسْحاقُ يَعقُوبَ. فَمَضَى يَعقُوبُ إلَى فَدَّانَ أرامَ، إلَى لابانَ بْنِ بَتُوئِيلَ الأرامِيِّ الَّذِي كانَ أخا رِفْقَةَ، أُمِّ يَعقُوبَ وَعِيسُو. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","عَلِمَ عِيسُو أنَّ إسْحاقَ بارَكَ يَعقُوبَ وَأرسَلَهُ إلَى فَدَّانَ أرامَ لِيَتَزَوَّجَ مِنِ امْرأةٍ مِنْ هُناكَ. وَعَلِمَ أيضاً أنَّ إسْحاقَ لَمّا بارَكَهُ أوصاهُ: «لا تَتَزَوَّجْ مِنَ امْرأةٍ كَنْعانِيَّةٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","وَعَلِمَ أنَّ يَعقُوبَ أطاعَ أباهُ وَأُمَّهُ وَذَهَبَ إلَى فَدَّانَ أرامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","فَفَهِمَ عِيسُو أنَّ أباهُ إسْحاقَ لَمْ يَكُنْ راضِياً عَنِ الكَنْعانِيّاتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","فَذَهَبَ عِيسُو إلَى إسْماعِيلَ وَتَزَوَّجَ مِنْ مَحلَةَ بِنْتِ إسْماعِيلَ بْنِ إبْراهِيمَ، أُختِ نَبايُوتَ، عَلَى زَوجَتَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","وَغادَرَ يَعقُوبُ بِئْرَ السَّبْعِ مُتَّجِهاً إلَى حارانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","وَوَصَلَ إلَى مَكانٍ حَيثُ باتَ لَيلَتَهُ هُناكَ، لِأنَّ الشَّمْسَ قَدْ غَرُبَتْ. فَأخَذَ أحَدَ الحِجارَةِ فِي ذَلِكَ المَكانِ وَوَضَعَهُ تَحتَ رَأْسِهِ، وَاسْتَلْقَى فِي ذَلِكَ المَكانِ لِيَنامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","وَرَأى فِي حُلْمٍ سُلَّماً قائِمَةً عَلَى الأرْضِ. وَقِمَّتُها تَصِلُ السَّماءَ. وَكانَتْ مَلائِكَةُ اللهِ تَصعَدُ وَتَنْزِلُ عَلَيها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","وَكانَ اللهُ واقِفاً فَوْقَها. فَقالَ اللهُ: «أنا إلَهُ أبِيكَ إبْراهِيمَ، وَإلَهُ إسْحاقَ. سَأُعطِيكَ وَنَسلَكَ الأرْضَ الَّتِي أنتَ مُضطَجِعٌ عَلَيها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","وَسَيَكُونُ نَسلُكَ بِعَدَدِ ذَرّاتِ تُرابِ الأرْضِ. وَسَيَنتَشِرُونَ غَرْباً وَشَرقاً وَشَمالاً وَجَنُوباً. وَسَتأْتِي عَلَى كُلِّ شُعُوبِ الأرْضِ بَرَكَةٌ مِنْ خِلالِكَ وَخِلالِ نَسلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","«وَها أنا مَعَكَ. سَأحمِيكَ حَيثُما تَذهَبُ. وَسَأُعِيدُكَ إلَى هَذِهِ الأرْضِ. وَسَتَعلَمُ أنِّي لَمْ أترُكْكَ حِينَ أفِي بِوَعدِيَ لَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","فَأفاقَ يَعقُوبُ مِنْ نَومِهِ وَقالَ: «إنَّ اللهَ فِي هَذا المَكانِ حَقّاً وَأنا لا أعلمُ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","فَخافَ وَقالَ: «ما أرْهَبَ هَذا المَكانَ! ما هَذا سِوَى بَيْتِ اللهِ! وَما هَذِهِ سِوَى بَوّابَةِ السَّماءِ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","فَبَكَّرَ يَعقُوبُ فِي الصَّباحِ، وَأخَذَ الحَجَرَ الَّذِي وَضَعَهُ تَحْتَ رَأِسِهِ، وَأقامَهُ نَصَباً تَذْكاريّاً، وَسَكَبَ فَوقَهُ زَيتاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","وَسَمَّى ذَلِكَ المَكانَ بَيتَ إيلَ. وَكانَ اسْمُ المَدِينَةِ لُوزَ قَبلَ ذَلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","وَنَذَرَ يَعقُوبُ نَذْراً فَقالَ: «إنْ كانَ اللهُ مَعِي، وَإنْ حَمانِي فِي رِحلَتِي هَذِهِ، وَأعطانِي طَعاماً لِآكُلَ وَثِياباً لِألبَسَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","وَإنْ أرجَعَنِي بِأمانٍ إلَى أهلِي، فَإنَّ يهوه سَيَكُونُ هُوَ إلَهِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","وَسَأجعَلُ هَذا الحَجَرَ الَّذِي أقَمْتُهُ نَصَباً تَذْكاريّاً يَكُونُ بَيتَ اللهِ. وَسَأُعطِي اللهَ عُشْرَ كُلِّ شَيءٍ يُعطِينِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ثُمَّ وَاصَلَ يَعقُوبُ رِحلَتَهُ، وَوَصَلَ إلَى أرْضِ أهلِ المَشْرِقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","فَتَطَلَّعَ حَولَهُ، فَرَأى بِئْراً فِي الحَقلِ. وَرَأى ثَلاثَةَ قُطْعانٍ مِنَ الماشِيَةِ رابِضَةً عِنْدَها، تَنتَظِرُ أنْ تُسْقَى مِنَ الماءِ. فَقَدْ كانَ هُناكَ حَجَرٌ ضَخْمٌ عَلَى فُتْحَةِ البِئْرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","وَلَمّا كانَتْ تُجمَعُ كُلُّ القُطْعانِ هُناكَ، كانَ يُدَحرَجُ الحَجَرُ عَنْ فُتْحَةِ البِئْرِ، فَتُسْقَى الأغنامُ. وَبَعدَ ذَلِكَ كانُوا يُعِيدُونَ الحَجَرَ إلَى مَكانِهِ فَوْقَ فُتْحَةِ البِئْرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","فَقالَ لَهُمْ يَعْقُوبُ: «مِنْ أينَ أنتُمْ، أيُّها الإخوَةُ؟» أجابُوا: «نَحنُ مِنْ حارانَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","فَقالَ لَهُمْ يَعقُوبُ: «هَلْ تَعرِفُونَ لابانَ بْنَ ناحُورَ؟» فَقالُوا: «نَعَمْ، نَعرِفُهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","فَقالَ لَهُمْ: «أهُوَ بِخَيرٍ؟» فَقالُوا: «نَعَمْ، بِخَيرٍ. وَها هِيَ ابْنَتُهُ راحِيلُ قادِمَةٌ مَعَ الغَنَمِ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ثُمَّ قالَ: «انظُرُوا، ما زالَ الوَقْتُ نَهاراً. وَلَمْ يَحِنْ بَعدُ وَقْتُ جَمْعِ الماشِيَةِ لِلْمَبِيتِ. فاسْقُوا الغَنَمَ. وَعُودُوا بِها إلَى المَرْعَى.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","فَقالُوا: «لا نَقدِرُ أنْ نَفْعَلَ هَذا حَتَّى تُجمَعَ كُلُّ القُطعانِ. وَبَعْدَ ذَلِكَ سَنُدَحرِجُ الحَجَرَ عَنْ فُتْحَةِ البِئْرِ وَنَسْقِي الغَنَمَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","وَبَينَما كانَ ما يَزالُ يَتَحَدَّثُ مَعَهُمْ، وَصَلَتْ راحِيلُ مَعَ غَنَمِ أبِيها، فَقَدْ كانَتْ تَرعَى الغَنَمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","رَأى يَعْقُوبُ راحِيلَ بِنْتَ لابانِ خالِهِ، وَقَطِيعَ لابانَ. فَاقتَرَبَ يَعقُوبُ وَدَحرَجَ الحَجَرَ عَنْ فَمِ البِئْرِ وَسَقَى قَطِيعَ خالِهِ لابانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ثُمَّ قَبَّلَ يَعقُوبُ راحِيلَ، وَأخَذَ يَبكِي بِصَوْتٍ عالٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ثُمَّ أخبَرَ يَعقُوبُ راحِيلَ بِأنَّ أباها قَرِيبٌ لَهُ. وَأخبَرَها بِأنَّهُ ابْنُ رِفْقَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","فَلَمّا سَمِعَ لابانُ عَنْ ابْنِ أُختِهِ يَعقُوبَ، رَكَضَ لِمُلاقاتِهِ، وَعانَقَهُ وَقَبَّلَهُ، وَأتَى بِهِ إلَى بَيتِهِ. ثُمَّ أخبَرَ يَعقُوبُ لابانَ عَنْ كُلِّ ما حَصَلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","فَقالَ لَهُ لابانُ: «أنتَ مِنْ دَمِي وَلَحْمِي حَقّاً!» وَبَقِيَ يَعقُوبُ عِندَهُ شَهْراً كامِلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ثُمَّ قالَ لابانُ لِيَعْقُوبَ: «لا يُعقَلُ أنْ تَخدِمَنِي مَجّاناً لِأنَّكَ قَرِيبِي. فَأخبِرْنِي ماذا تُرِيدُ أنْ يَكُونَ أجرُكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","وَكانَ لِلابانَ ابْنَتانِ، اسْمُ الكُبْرَى لَيئَةُ، وَاسْمُ الصُّغرَى راحِيلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","وَكانَتْ عَينا لَيئَةَ رَقيقَتَينِ، أمّا راحِيلُ فَكانَتْ رائِعَةَ القَوامِ وَجَميلَةَ الشَّكلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","وَكانَ يَعقُوبُ يُحِبُّ راحِيلَ، فَقالَ: «سَأخدِمُكَ سَبْعَ سَنَواتٍ مُقابِلَ أنْ تُزَوِّجَنِي مِنِ ابْنَتِكَ راحِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","فَقالَ لابانُ: «أنْ أُعطِيَها لَكَ أفضَلُ لِي مِنْ أنْ أُعطِيَها لِرَجُلٍ آخَرَ. فابْقَ مَعِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","فَخَدَمَ يَعقُوبُ سَبْعَ سَنَواتٍ مِنْ أجلِ راحِيلَ. لَكِنَّها بَدَتْ فِي عَينَيهِ أيّاماً قَلِيلَةً بِسَبَبِ حُبِّهِ لَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","فَقالَ يَعقُوبُ لِلابانَ: «لَقَدْ أنهَيتُ سَنَواتِ خِدْمَتِي الَّتِي طَلَبْتَها مِنِّي، فَأعطِنِي زَوجَتِي فَأُعاشِرَها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","فَجَمَعَ لابانُ كُلَّ أهلِ المَنطَقَةِ، وَأقامَ وَلِيمَةَ عُرْسٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","وَفِي المَساءِ أخَذَ لابانُ ابْنَتَهُ لَيئَةَ وَأحضَرَها لِيَعقُوبَ، فَعاشَرَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","وَأعطَى لابانُ خادِمَتَهُ زِلْفَةَ لابْنَتِهِ لَيئَةَ لِتَكُونَ خادِمَةً لَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","وَفِي الصَّباحِ اكتَشَفَ يَعقُوبُ أنَّ المَرأةَ الَّتِي عاشَرَها هِيَ لَيئَةُ. فَقالَ لِلابانَ: «ما هَذا الَّذِي فَعَلْتَهُ بِي؟ أما خَدَمْتُكَ سَبْعَ سَنَواتٍ مِنْ أجلِ راحِيلَ؟ فَلِماذا خَدَعْتَنِي؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","فَقالَ لابانُ: «لَيسَ مِنْ عادَتِنا فِي هَذِهِ البِلادِ أنْ نُزَوِّجَ البِنْتَ الصُّغْرَى قَبلَ الكُبْرَى. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","فَأكْمِلْ أُسْبُوعَ احتِفالاتِ الزَّواجِ مَعَ الكُبْرَى. وَأنا أعِدُ بِأنْ أُزَوِّجَكَ الصُّغرَى أيضاً إذا خَدَمْتَنِي سَبْعَ سَنَواتٍ أُخْرَى.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","وَهَكَذا فَعَلَ يَعقُوبُ. إذْ أكمَلَ أُسْبُوعَ احتِفالاتِ الزَّواجِ مَعَ الكُبْرَى. وَبَعدَ هَذا زَوَّجَهُ لابانُ مِنِ ابْنَتِهِ راحِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","وَأعطَى لابانُ خادِمَتَهُ بِلْهَةَ لابْنَتِهِ راحِيلَ لِتَكُونَ خادِمَةً لَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","فَعاشَرَ يَعقُوبُ راحِيلَ أيضاً. وَأحَبَّ راحِيلَ أكثَرَ مِنْ لَيئَةَ. وَاشْتَغَلَ عِندَ لابانَ سَبْعَ سَنَواتٍ أُخْرَى. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","وَرَأى اللهُ أنَّ لَيئَةَ كانَتْ مَكْرُوهَةً، فَمَكَّنَها مِنَ الإنجابِ. أمّا راحِيلُ فَكانَتْ عاقِراً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","وَحَبِلَتْ لَيئَةُ وَأنجَبَتْ وَلَداً وَسَمَّتْهُ رَأُوبَيْنَ، فَقَدْ قالَتْ: «رَأى اللهُ مَذَلَّتِي. وَالآنَ لا بُدَّ أنْ يُحِبَّنِي زَوجِي!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ثُمَّ حَبِلَتْ لَيئَةُ مَرَّةً أُخْرَى وَوَلَدَتْ وَلَداً. وَقالَتْ: «لَقَدْ أعطانِي اللهُ هَذا الوَلَدَ لِأنَّهُ سَمِعَ أنِّي مَكْرُوهَةً.» فَسَمَّتْهُ شَمْعُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","وَحَبِلَتْ لَيئَةُ مَرَّةً أُخْرَى وَوَلَدَتْ وَلَداً. فَقالَتْ: «لا بُدَّ أنَّ زَوْجِي سَيَتَعَلَّقُ بِي هَذِهِ المَرَّةَ، لِأنِّي أنجَبْتُ لَهُ ثَلاثَةَ أولادٍ.» وَلِهَذا سَمَّتْهُ لاوِيَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","وَحَبِلَتْ لَيئَةُ مَرَّةً أُخْرَى وَوَلَدَتْ وَلَداً. فَقالَتْ: «هَذِهِ المَرَّةَ سَأُسَبِّحُ اللهَ.» وَسَمَّتْهُ يَهُوذا. ثُمَّ تَوَقَّفَتْ عَنِ الإنْجابِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","وَلَمّا رَأتْ راحِيلُ أنَّها لا تُنجِبُ أبْناءً لِيَعقُوبَ، غارَتْ مِنْ أُختِها. فَقالَتْ لِيَعقُوبَ: «أعطِنِي أبناءَ، وَإلّا مِتُّ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","فَغَضِبَ يَعقُوبُ مِنْ راحِيلَ. وَقالَ لَها: «أأنا اللهُ الَّذِي مَنَعَ عَنْكِ الأبْناءَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","فَقالَتْ راحِيلُ: «ها خادِمَتِي بِلْهَةُ أمامَكَ. فَعاشِرْها لِكَي تَلِدَ لِي ابْناً، فَيَكُونُ لِي أبْناءٌ مِنْها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","فَزَوَّجَتْهُ راحِيلُ مِنْ خادِمَتِها بِلْهَةَ، فَعاشَرَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","فَحَبِلَتْ بِلْهَةُ وَوَلَدَتْ لِيَعقُوبَ وَلَداً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","فَقالَتْ راحِيلُ: «لَقَدْ سَمِعَ اللهُ صَلاتِي وَأنصَفَنِي إذْ رَزَقَنِي بِوَلَدٍ.» وَلِهَذا سَمَّتْهُ راحِيلُ دانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","وَحَبِلَتْ بِلْهَةُ، خادِمَةُ راحِيلَ، مَرَّةً أُخْرَى وَوَلَدَتْ وَلَداً ثانِياً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","فَقالَتْ راحِيلُ: «جاهَدْتُ ضِدَّ أُختِي جِهاداً عَظِيماً، وَفُزْتُ.» فَسَمَّتْهُ راحِيلُ نَفْتالِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","وَرَأتْ لَيئَةُ أنَّها لَمْ تَعُدْ تُنجِبُ. فَأخَذَتْ خادِمَتَها زِلْفَةَ وَزَوَّجَتْها مِنْ يَعقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","فَأنجَبَتْ زِلْفَةُ، خادِمَةُ لَيئَةَ، لِيَعقُوبَ وَلَداً، ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","فَقالَتْ لَيئَةُ: «يا لَسَعْدِيَ!» فَسَمَّتْهُ جادَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ثُمَّ أنجَبَتْ خادِمَةُ لَيئَةَ وَلَداً ثانِياً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","وَقالَتْ لَيئَةُ: «هَنِيئاً لِي، لِأنَّ الفَتَياتِ ستُبارِكُ لِي.» فَأسْمَتْهُ أشِيرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","وَفِي أيّامِ حَصادِ القَمْحِ، خَرَجَ رَأُوبَيْنُ فَوَجَدَ بَعضَ اللُّفّاحِ فِي الحَقلِ. فَأحْضَرَهُ إلَى أُمِّهِ لَيئَةَ. فَقالَتْ راحِيلُ لِلَيئَةَ: «أعطِنِي مِنْ فَضلِكِ بَعضاً مِنَ اللُّفّاحِ الَّذِي جَلَبَهُ ابْنُكِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","لَكِنَّ لَيئَةَ قالَتْ لَها: «ألَمْ يَكفِكِ أنَّكِ أخَذْتِ زَوْجِي مِنِّي؟ فَهَلْ تُرِيدِينَ أنْ تَأْخُذِي لُفّاحَ ابْنِي أيضاً؟» فَقالَتْ راحِيلُ: «إذاً لِيُعاشِرْكِ يَعقُوبُ هَذِهِ اللَّيلَةَ مُقابِلَ لُفّاحِ ابْنِكِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","وَلَمّا رَجِعَ يَعقُوبُ مِنَ الحَقلِ فِي المَساءِ، خَرَجَتْ لَيئَةُ لِلِقائِهِ. وَقالَتْ: «سَتَنامُ عِندِي اللَّيلَةَ، لِأنِّي دَفَعْتُ مُقابِلَ ذَلِكَ لُفّاحَ ابْنِي.» فَنامَ مَعَها يَعقُوبُ فِي تِلْكَ اللَّيلَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","وَاسْتَجابَ اللهُ لِصَلاةِ لَيئَةَ، فَحَبِلَتْ وَأنجَبَتْ وَلَداً خامِساً لِيَعقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","فَقالَتْ لَيئَةُ: «أعطانِي اللهُ مُكافَأتِي، لِأنِّي أعطَيتُ خادِمَتِي زَوْجَةً لِزَوجِيَ.» فَسَمَّتْهُ يَسّاكَرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","وَحَبِلَتْ لَيئَةُ مَرَّةً أُخْرَى وَأنجَبَتْ وَلَداً سادِساً لِيَعقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","وَقالَتْ لَيئَةُ: «أعطانِي اللهُ عَطِيَّةً رائِعَةً. وَالآنَ سَيُكرِمُنِي زَوجِي، لِأنِّي أنجَبْتُ لَهُ ابْناً سادِساً.» فَسَمَّتْهُ زَبُولُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","وَأنجَبَتْ لَيئَةُ فِيما بَعْدُ بِنْتاً أسْمَتْها دِينَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ثُمَّ تَذَكَّرَ اللهُ راحِيلَ وَاسْتَجابَ لِصَلاتِها. وَمَكَّنَها مِنَ الإنجابِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","فَحَبِلَتْ راحِيلُ وَوَلَدَتِ ابْناً. فَقالَتْ: «لَقَدْ نَزَعَ اللهُ عَنِّي عارِيَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","وَسَمَّتْهُ يُوسُفَ. وَقالَتْ: «لَيتَ اللهَ يَزِيدُنِي ابْناً آخَرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","وَلَمّا وَلَدَتْ راحِيلُ يُوسُفَ، قالَ يَعقُوبُ لِلابانَ: «اسْمَحْ لِي بِأنْ أعُودَ إلَى بَيتِي وَأرْضِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","وَاسْمَحْ لِي بِأنْ آخُذَ مَعِي زَوْجاتِي وَأبْنائِي. لَقَدْ خَدَمْتُكَ مُقابِلَهُمْ. ائْذَنْ لِي وَسَأنطَلِقُ. فَأنتَ تَعلَمُ كَيفَ خَدَمْتُكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","فَقالَ لَهُ لابانُ: «لَيتَكَ تَرْضَى عَنِّي. قَدْ تَفاءَلْتُ بِالبَرَكَةِ، فَبارَكَنِي اللهُ بِسَبَبِكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ثُمَّ قالَ: «قُلْ كَمْ لَكَ عَلَيَّ، وَأنا سَأدفَعُ لَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","فَقالَ لَهُ يَعقُوبُ: «أنتَ تَعلَمُ كَيفَ خَدَمْتُكَ وَكَيفَ اعتَنَيتُ بِماشِيَتِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","فَما كانَ عِندَكَ قَبلَ أنْ آتِيَ كانَ قَلِيلاً، وَأمّا الآنَ فَلَدَيكَ كَثِيرٌ. وَقَدْ بارَكَكَ اللهُ فِي كُلِّ ما صَنَعَتَ. لَكِنْ مَتَى سَأعمَلُ مِنْ أجلِ عائِلَتِي أنا أيضاً؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","فَقالَ لابانُ: «ماذا تُرِيدُنِي أنْ أُعطِيَكَ؟» فَقالَ يَعقُوبُ: «لا أُرِيدُ أنْ تُعطِيَنِي شَيئاً. لَكِنْ إنْ قَبِلْتَ أنْ تَفْعَلَ هَذا الأمْرَ مِنْ أجلِيَ، فَسَأرْعَى وَأحرُسُ مَواشِيَكَ مَرَّةً أُخْرَى. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","سَأمُرُّ اليَوْمَ بَينَ كُلِّ ماشِيَتِكَ. وَسَأنتَقِي كُلَّ شاةٍ مُرَقَّطَةٍ وَمُخَطَّطَةٍ، وَكُلَّ حَمَلٍ أسْوَدَ بَينَ الحِملانِ. وَكُلَّ مِعزاةٍ مُرَقَّطَةٍ وَمُخَطَّطَةٍ. وَهَذا يَكُونُ أجرِيَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","وَسَتَشْهَدُ نَزاهَتِي عَنِّي فِيما بَعْدُ عِندَما تَتَفَقَّدُ أجرِيَ. فَكُلُّ ما لَيسَ مُخَطَّطاً وَمُرَقَّطاً بَينَ المِعزَى، وَكُلُّ ما لَيسَ أسْوَدَ بَينَ الخِرافِ تَجِدُهُ عِندِي، فَهُوَ يُعتَبَرُ مَسْرُوقاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","فَقالَ لابانُ: «اتَّفَقْنا! لِيَتِمَّ الأمْرُ حَسَبَ ما قُلْتَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","لَكِنَّ لابانَ قامَ فِي ذَلِكَ اليَوْمِ بِعَزلِ كُلِّ التُّيُوسِ المُخَطَّطَةِ وَالمُرَقَّطَةِ، وَكُلِّ المَاعِزِ المُخَطَّطَةِ وَالمُرَقَّطَةِ، وَكُلِّ ما عَلَيهِ بَياضٌ، وَكُلِّ الحِملانِ السَّوْداءِ. وَأعْطاها لِبَنِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ثُمَّ أخَذَ هَذِهِ الحَيواناتِ إلَى مَكانٍ يَبْعُدُ مَسِيرَةَ ثَلاثَةِ أيّامٍ عَنْ يَعقُوبَ. أمّا يَعقُوبُ فَبَقِيَ وَرَعَى ما تَبَقَّى مِنْ مَواشِي لابانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","فَأخَذَ يَعقُوبُ أغصاناً طَرِيَّةً مِنْ أشْجارِ الحَوْرِ وَاللَّوْزِ وَالدُّلْبِ. وَقَشَّرَها لِتَظْهَرَ عَلَيها خُطُوطٌ بَيضاءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ثُمَّ وَضَعَ الأغصانَ الَّتِي قَشَّرَها أمامَ القُطْعانِ عِنْدَ الأحواضِ حَيثُ تَشْرَبُ الماشِيَةُ. وَكانَتِ القُطْعانُ تَتَزاوَجُ عِندَما تَأْتِي لِتَشْرَبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","فَلَمّا تَزاوَجَتِ القُطْعانُ أمامَ الأغصانِ، وَلَدَتْ مَواشِيَ مُخَطَّطَةً وَمُنَقَّطَةً وَمُرَقَّطَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","وَهَكَذا زاوَجَ يَعقُوبُ الأغنامَ، ثُمَّ فَصَلَ الأغنامَ المُخَطَّطَةَ مِنَ القَطِيعِ، فَكَثَّرَ بِذَلِكَ قَطِيعَهُ. وَلَمْ يَضَعْ غَنَمَ لابانَ مَعَ قَطِيعِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","فَلَمّا كانَتِ الأغنامُ القَوِيَّةُ تَتَزاوَجُ، كانَ يَعقُوبُ يَضَعُ الأغصانَ أمامَها فِي أحواضِ السِّقايَةِ، لِكَي تَتَزاوَجَ أمامَ الأغصانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","لَكِنَّهُ لَمْ يَكُنْ يَضَعُ الأغصانَ أمامَ الأغنامِ الضَّعيفَةِ فِي القَطِيعِ، فَصارَتِ مَوالِيدُ الضَّعيفَةِ مِنْ نَصِيبِ لابانَ، وَمَوالِيدُ القَوِيَّةِ مِنْ نَصِيبِ يَعقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","فَصارَ يَعقُوبُ غَنِيّاً جِدّاً. إذْ كانَتْ لَدَيهِ مَواشٍ كَثِيرَةٌ، وَخُدّامٌ وَخادِماتٌ، وَجِمالٌ وَحَمِيرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","وَسَمِعَ يَعقُوبُ ما قالَهُ أبْناءُ لابانَ: «لَقَدِ اسْتَولَى يَعقُوبُ عَلَى كُلِّ ما كانَ لِأبِينا. وَجَمَعَ كُلَّ ثَرْوَتِهِ مِمّا كانَ لِأبِينا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","وَلاحَظَ يَعقُوبُ أنَّ نَظْرَةَ لابانَ إلَيهِ لَمْ تَعُدْ كَما كانَتْ فِي السّابِقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","فَقالَ اللهُ لِيَعقُوبَ: «عُدْ إلَى أرْضِ آبائِكَ وَأهلِكَ. وَسَأكُونُ مَعَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","فَأرْسَلَ يَعقُوبُ فِي طَلَبِ راحِيلَ وَلَيئَةَ وَدَعاهُما إلَى الحَقلِ حَيثُ قُطْعانُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","وَقالَ لَهُما: «لاحَظْتُ أنَّ نَظْرَةَ أبِيكُما إلَيَّ لَمْ تَعُدْ كَما فِي السّابِقِ. وَلَكِنَّ إلَهَ أبِي كانَ وَما يَزالُ مَعِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","أنتُما تَعْرِفانِ أنِّي خَدَمْتُ أباكُما بِكُلِّ قُوَّتِي، ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","وَهُوَ غَشَّنِي وَغَيَّرَ أجرِيَ عَشَرَ مَرّاتٍ. لَكِنَّ اللهَ لَمْ يَسمَحْ لَهُ بِأنْ يُؤْذِيَنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","«فَإنْ قالَ لابانُ: ‹المَواشِي المُرَقَّطَةُ سَتَكُونُ أجرَكَ،› حِينَئِذٍ، كانَتْ كُلُّ القُطْعانِ تَلِدُ صِغاراً مُرَقَّطَةً. وَإنْ قالَ: ‹المَواشِي المُخَطَّطَةُ سَتَكُونُ أجرَكَ.› حِينَئِذٍ، كانَتْ كُلُّ القُطْعانِ تَلِدُ صِغاراً مُخَطَّطَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","فَنَزَعَ اللهُ مَواشِيَ أبِيكُما وَأعطاها لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«وَفِي وَقْتِ تَزاوُجِ القَطِيعِ، رَفَعْتُ نَظَرِي وَرَأيتُ حُلْماً. رَأيتُ أنَّ التُّيُوسَ الَّتِي كانَتْ تَتَزاوَجُ مُخَطَّطَةٌ وَمُنَقَّطَةٌ وَمُرَقَّطَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ثُمَّ جاءَ إلَيَّ مَلاكُ اللهِ فِي حُلْمٍ وَقالَ: ‹يا يَعْقُوبُ!› «فَقُلْتُ: ‹سَمْعاً وَطاعَةً.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","«فَقالَ المَلاكُ: ‹ارْفَعْ عَينَيكَ وَانظُرْ كَيفَ أنَّ كُلَّ التُّيُوسِ المُتَزاوِجَةِ مُخَطَّطَةٌ وَمُنَقَّطَةٌ وَمُرَقَّطَةٌ. فَقَدْ رَأيتُ كُلَّ ما فَعَلَهُ لابانُ بِكَ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","أنا إلَهُ بَيتِ إيلَ حَيثُ كَرَّسْتَ عَمُوداً وَنَذَرْتَ لِي نَذْراً. فَالآنَ قُمْ وَاتْرُكْ هَذا المَكانَ وَعُدْ إلَى أرْضِ أهلِكَ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","فَأجابَتْهُ راحِيلُ وَلَيئَةُ: «ألَعَلَّ لَنا نَصِيباً أوْ مِيراثاً فِي بَيتِ أبِينا؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ألا يَعتَبِرُنا غَرِيبَتَينِ؟ فقَدْ باعَنا وَاسْتَولَى عَلَى المَهْرِ الَّذِي دُفِعَ فِينا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","فَكُلُّ الثَّرْوَةِ الَّتِي اسْتَعادَها اللهُ مِنْ أبِينا هِيَ لَنا وَلِأبْنائِنا. فَالآنَ اعْمَلْ كَما قالَ لَكَ اللهُ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","فَاسْتَعَدَّ يَعقُوبُ وَأركَبَ أبْناءَهُ وَزَوْجاتِهِ الجِمالَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","وَساقَ كُلَّ مَواشِيهِ وَكُلَّ مُقتَنَياتِهِ. ساقَ كُلَّ شَيءٍ اقْتَناهُ، وَالماشِيَةَ الَّتِي حَصَلَ عَلَيها فِي فَدَّانَ أرامَ، لِيَذْهَبَ إلَى أبِيهِ إسْحاقَ فِي أرْضِ كَنْعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","وَكانَ لابانُ قَدْ ذَهَبَ لِيَجِزَّ الصُّوفَ عَنْ غَنَمِهِ. فَسَرَقَتْ راحِيلُ تَماثِيلَ أبِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","وَخَدَعَ يَعْقُوبُ لابانَ الأرامِيَّ إذْ لَمْ يُخْبِرْهُ بِرَحيلِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","بَلْ هَرَبَ بِكُلِّ ما كانَ لَهُ. وَانطَلَقَ يَعْقُوبُ وَعَبَرَ نَهْرَ الفُراتِ، قاصِداً أرْضَ جِلْعادَ الجَبَلِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","وَفِي اليَوْمِ الثّالِثِ أُخْبِرَ لابانُ بِأنَّ يَعْقُوبَ قَدْ هَرَبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","فَأخَذَ لابانُ أقْرِباءَهُ مَعَهُ وَلاحَقَهُ مُدَّةَ سَبْعَةِ أيّامٍ، إلَى أنْ أدرَكَهُ فِي جِلْعادَ الجَبَلِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","وَجاءَ اللهُ إلَى لابانَ الأرامِيَّ فِي حُلْمٍ فِي تِلْكَ اللَّيلَةِ. وَقالَ اللهُ لِلابانَ: «احتَرِسْ مِنْ أنْ تُهَدِّدَ يَعْقُوبَ بِأيَّةِ كَلِمَةٍ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","فَأدرَكَ لابانُ يَعقُوبَ. وَنَصَبَ يَعقُوبُ خَيمَتَهُ عَلَى الجَبَلِ. وَنَصَبَ لابانُ خَيمَتَهُ فِي جِلْعادَ الجَبَلِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","فَقالَ لابانُ لِيَعقُوبَ: «ما هَذا الَّذِي فَعَلْتَهُ؟ خَدَعْتَنِي وَأخَذْتَ ابْنَتَيَّ كَما لَوْ أنَّهُما أسِيرَتا حَربٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","فَلِماذا هَرَبْتَ سِرّاً وَخَدَعْتَنِي وَلَمْ تُخبِرْنِي؟ لَوْ أخبَرْتَنِي لَوَدَّعْتُكَ بِفَرَحٍ وَأغانٍ وَدُفُوفٍ وَقَياثيرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","لَمْ تَسْمَحْ لِي حَتَّى بِتَقْبِيلِ أحفادِيَ وَبِنْتَيَّ قُبلَةَ الوَداعِ، وَكانَ هَذا حُمْقاً مِنْكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","أُقْسِمُ أنِّي كُنْتُ أنوِي إيذاءَكَ. لَكِنْ ظَهَرَ لِي لَيلَةَ أمْسٍ إلَهُ أبِيكَ، وَقالَ لِي: ‹احتَرِسْ مِنْ أنْ تُهَدِّدَ يَعْقُوبَ بِأيَّةِ كَلِمَةٍ!› ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","وَالآنَ أنتَ غادَرْتَ لِأنَّكَ اشْتَقْتَ إلَى بَيتِ أبِيكَ، لَكِنْ لِماذا سَرَقْتَ أوْثانَ بَيتِي؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","فَرَدَّ يَعقُوبُ عَلَى لابانَ وَقالَ: «غادَرْتُ دُونَ أنْ أُخْبِرَكَ لِأنِّي خِفْتُ أنْ تَأْخُذَ ابْنَتَيكَ مِنِّي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","لَكِنْ إنْ وَجَدْتَ أوْثانَكَ مَعَ أحَدٍ، فَسَيُقْتَلُ، أيّاً كانَ. وَأنا أقُولُ لَكَ عَلَى مَسْمَعٍ مِنْ أقْرِبائِنا: أشِرْ إلَى أيِّ شَيءٍ مَعِي وَقُلْ إنَّهُ لَكَ، حِينَئِذٍ، يَرْجِعُ إلَيكَ.» لَكِنَّ يَعقُوبَ لَمْ يَكُنْ يَعلَمُ أنَّ راحِيلَ هِيَ الَّتِي سَرَقَتِ الأوثانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","فَدَخَلَ لابانُ إلَى خَيمَةِ يَعقُوبَ وَخَيمَةِ لَيئَةَ وَخَيمَةِ الخادِمَتَينِ، لَكِنَّهُ لَمْ يَجِدِ الأوْثانَ. ثُمَّ دَخَلَ إلَى خَيمَةِ راحِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","وَكانَتْ راحِيلُ قَدْ أخَذَتْ أوْثانَ البَيتِ وَوَضَعَتْها فِي سَرْجِ الجَمَلِ الَّذِي كانَتْ تَجلِسُ عَلَيهِ. وَفَتَّشَ لابانُ الخَيمَةَ كُلَّها فَلَمْ يَجِدِ الأوْثانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","فَقالَتْ راحِيلُ لِأبِيها: «لا تَغضَبْ مِنِّي يا سَيِّدِي، فَأنا لا أسْتَطِيعُ الوُقُوفَ أمامَكَ. إذْ عَلَيَّ العادَةُ الشَّهْرِيَّةُ.» فَفَتَّشَ لابانُ، لَكِنَّهُ لَمْ يَجِدْ أوْثانَ بَيتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","فَغَضِبَ يَعقُوبُ وَوَبَّخَ لابانَ. وَقالَ لِلابانَ: «أيَّةَ جَرِيمَةٍ ارتَكَبْتُ؟ وَما هِيَ الإساءَةُ الَّتِي أسَأْتُ بِها إلَيكَ، حَتَّى جِئْتَ تُطارِدُنِي؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","لَقَدْ فَتَّشْتَ كُلَّ أغراضِي. فَهَلْ وَجَدْتَ بَينَها شَيئاً مِنْ مُقتَنَياتِ بَيتِكَ؟ إنْ وَجَدْتَهُ، فَضَعْهُ هُنا أمامَ أقْرِبائِي وَأقْرِبائِكَ. وَلْيَحكُمُوا بَينَنا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","كُنْتُ مَعَكَ عِشْرِينَ عاماً وَلَمْ تُجهِضْ فِيها نِعاجُكَ وَمِعازُكَ. وَلَمْ آكُلْ يَوْماً مِنْ كِباشِ قُطْعانِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","وَلَمْ أُحضِرْ لَكَ يَوْماً رَأْساً مِنْ ماشِيَتِكَ افتَرَسَتْهُ الوُحُوشُ، بَلْ كُنْتُ أُعَوِّضُ لَكَ الخَسارَةَ مِنِّي عِندَما كُنْتَ تَطلُبُها. وَقَدْ تَعَرَّضْتُ لِلسَّلْبِ لَيلاً وَنَهاراً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","عِشْتُ هَكَذا: كانَتْ قُوَّتِي تُمْتَصُّ مِنَ الحَرِّ نَهاراً، وَمِنَ البَرْدِ لَيلاً. وَلَمْ أذُقْ طَعْمَ النَّوْمِ حِرْصاً عَلَى مَواشِيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","كُنْتُ فِي بَيتِكَ طَوالَ هَذِهِ السَّنَواتِ العِشْرِينَ أعمَلُ كَعَبْدٍ، أرْبَعَ عَشْرَةَ سَنَةً مُقابِلَ ابْنَتَيكَ وَسِتَّ سَنَواتٍ مُقابِلَ غَنَمِكَ. وَغَيَّرْتَ أجرِيَ عَشَرَ مَرّاتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","لَكِنَّ إلَهَ أبِي، إلَهَ إبْراهِيمَ، وَمَهابَةُ إسْحاقَ، كانَ مَعِي. وَلَولا ذَلِكَ لأرْسَلْتَنِي فارِغَ اليَدَينِ. رَأى اللهُ ضِيقِي وَتَعَبِي. وَلِهَذا وَبَّخَكَ اللهُ لَيلَةَ أمْسِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","فَأجابَ لابانُ: «هاتانِ ابْنَتايَ، وَهُؤلاءِ الغِلمانُ لِي، وَالغَنَمُ غَنَمِي، وَكُلُّ ما تَراهُ هُوَ لِي. لَكِنْ ماذا عَسانِي أفْعَلُ اليَوْمَ بِابْنَتَيَّ وَأولادِهِنَّ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","فَتَعالَ وَلْنَقْطَعْ أنا وَأنْتَ عَهْداً. وَلْيَكُنْ هَذا العَهْدُ شاهِداً بَينِي وَبَينَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","فَأخَذَ يَعقُوبُ حَجَراً، وَنَصَبَهُ عَمُوداً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ثُمَّ قالَ يَعقُوبُ لِأقْرِبائِهِ: «اجْمَعُوا حِجارَةً!» فَأخَذُوا حِجارَةً وَجَعَلُوا مِنْها كَوْمَةً. ثُمَّ أكَلُوا مَعَاً بِجانِبِ كَوْمَةِ الحِجارَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","وَسَمَّى لابانُ ذَلِكَ المَكانَ يَجَرْ سَهْدُوثا. وَسَمّاهُ يَعقُوبُ جَلْعِيدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","فَقَدْ قالَ لابانُ لِيَعْقُوبَ: «كَوْمَةُ الحِجارَةِ هَذِهِ تَشْهَدُ اليَوْمَ بَينِي وَبَينَكَ.» لِذَلِكَ دُعِيَ المَوضِعُ جَلْعِيدُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","وَدُعِيَ المَكانُ أيضاً مِصْفاةَ، لِأنَّ لابانَ قالَ: «لِيُراقِبِ اللهُ كِلَينا عِندَما يَفْتَرِقُ أحَدُنا عَنِ الآخَرِ، وَيَحكُمْ بَينَنا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","فَلا تُؤذِ بَناتِي، وَلا تَتَزَوَّجْ عَلَيْهِنَّ. فَاللهُ شاهِدٌ بَينِي وَبَينَكَ، حَتَّى لَوْ لَمْ يَكُنْ مَعَنا أحَدٌ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","وَقالَ لابانُ لِيَعقُوبَ: «ها كَوْمَةُ الحِجارَةِ وَالعَمُودُ بَينَنا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","هَذِهِ الكَوْمَةُ شاهِدَةٌ وَهَذا العَمُودُ شاهِدٌ عَلَى أنِّي لَنْ أتَخَطَّى هَذِهِ الكَوْمَةَ إلَيكَ لإيذائِكَ، وَأنَّكَ لَنْ تَتَخَطَّى هَذِهِ الكَوْمَةَ وَهَذا العَمُودَ إلَيَّ لإيذائِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","وَلْيَحكُمْ بَينَنا إلَهُ إبْراهِيمَ وَإلَهُ ناحُورَ إلَهُ أبِيهِما.» ثُمَّ حَلَفَ يَعقُوبُ بِمَهابَةِ إسْحاقَ أبيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","وَقَدَّمَ ذَبِيحَةً عَلَى الجَبَلِ. وَدَعا أقْرِباءَهُ إلَى الطَّعامِ. فَأكَلُوا وَباتُوا لَيلَتَهُمْ عَلَى الجَبَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","وَفي الصَّباحِ الباكِرِ، اسْتَيقَظَ لابانُ وَقَبَّلَ أحْفادَهُ وَبَناتِهِ وَبارَكَهُمْ، ثُمَّ عَادَ إلَى بَيتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","أمّا يَعقُوبُ فَواصَلَ طَرِيقَهُ وَلاقَتْهُ مَلائِكَةُ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","فَلَمّا رَآهُمْ يَعقُوبُ قالَ: «هَذا مُعَسْكَرُ اللهِ!» فَسَمَّى ذَلِكَ المَكانَ مَحَنايِمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ثُمَّ أرْسَلَ يَعقُوبُ أمامَهُ رُسُلاً إلَى أخِيهِ عِيسُو فِي أرْضِ سَعِيرَ، فِي حُقُولِ أدُومَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","وَأوْصاهُمْ: «قُولُوا لِسَيِّدِي عِيسُو: ‹هَذا هُوَ ما يَقُولُهُ يَعْقُوبُ، خادِمُكَ: تَغَرَّبْتُ عِنْدَ لابانَ، وَبَقِيتُ هُناكَ إلَى الآنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","وَعِنْدِي بَقَرٌ وَحَمِيرٌ وَغَنَمٌ، وَخُدّامٌ وَخادِماتٌ. وَقَدْ أرْسَلْتُ لِأُخْبِرَكَ هَذا، لَعَلِّي أحظَى بِرِضاكَ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","وَعادَ الرُّسُلُ إلَى يَعقُوبَ وَقالُوا: «لَقَدْ ذَهَبْنا إلَى أخِيكَ عِيسُو. وَهُوَ أيضاً قادِمٌ لِلِقائِكَ، وَمَعَهُ أرْبَعُ مِئَةِ رَجُلٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","فَخافَ يَعقُوبُ وَتَضايَقَ جِدّاً. وَقَسَّمَ جَماعَتَهُ الَّذِينَ مَعَهُ وَالغَنَمَ وَالبَقَرَ وَالجِمالَ إلَى مَجمُوعَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","إذْ قالَ فِي نَفْسِهِ: «إذا هَجَمَ عِيسُو عَلَى المَجمُوعَةِ الأُولَى وَأهلَكَها، سَتَنجُو الثّانِيَةُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ثُمَّ صَلَّى يَعقُوبُ: «يا إلَهَ أبِي إبْراهِيمَ! وَيا إلَهَ إسْحاقَ أبِي! أنتَ قُلْتَ لِي، يا اللهُ: ‹عُدْ إلَى أهلِكَ وَإلَى عائِلَتِكَ، وَأنا سَأصْنَعُ مَعَكَ خَيراً.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","أنا لَسْتُ جَدِيراً بِكُلِّ أعمالِ لُطفِكَ وَوَفائِكَ الَّتِي صَنَعْتَها مَعِي أنا، عَبْدَكَ. عِندَما عَبَرْتُ نَهْرَ الأُرْدُنِّ لِأوَّلِ مَرَّةٍ، لَمْ تَكُنْ لَدَيَّ إلّا عَصايَ، وَها أنا أعُودُ بِمُعَسْكَرَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","فَخَلِّصْنِي مِنْ يَدِ أخِي عِيسُو. فَأنا أخشَى أنْ يَأْتِيَ وَيَقْتُلَنِي، وَأنْ يَقْتُلَ حَتَّى الأُمَّهاتِ مَعَ الأبْناءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","أنْتَ قُلْتَ: ‹سَأصْنَعُ مَعَكَ خَيراً، وَسَأجعَلُ نَسلَكَ بِعَدَدِ رَملِ البَحْرِ، الَّذِي لا يُحصَى لِكَثْرَتِهِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","وَباتَ يَعقُوبُ تِلْكَ اللَّيلَةَ هُناكَ. ثُمَّ انتَقَى مِمّا حَصَلَ عَلَيهِ هَدِيَّةً لِأخِيهِ عِيسُو: ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","مِئَتَي عَنْزَةٍ، وَعِشْرِينَ تَيساً، وَمِئَتَي نَعجَةٍ، وَعِشْرِينَ كَبْشاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ثَلاثِينَ ناقَةً مَعَ أولادِها، وَأرْبَعِينَ بَقَرَةً وَأرْبَعِينَ ثَوْراً، وَعِشْرِينَ أتاناً وَعَشْرَةَ حَمِيرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","وَوَضَعَ كُلَّ قَطِيعٍ وَحْدَهُ فِي عُهْدَةِ أحَدِ خُدّامِهِ. ثُمَّ قالَ لِخُدّامِهِ: «اسْبِقُونِي، وَاتْرُكُوا مَسافَةً بَينَ قَطِيعٍ وَقَطِيعٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","وَأوْصَى يَعقُوبُ خادِمَهُ الأوَّلَ وَقالَ لَهُ: «عِندَما يُلاقِيكَ أخِي عِيسُو، وَيَسْألُكَ: ‹مَنْ سَيِّدُكَ! وَإلَى أينَ أنتَ ذاهِبٌ؟ وَلِمَنْ هَذِهِ الحَيواناتُ الَّتِي أمامَكَ؟› ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","فَقُلْ لَهُ: ‹إنَّها لِعَبْدِكَ يَعقُوبَ، وَهِيَ هَدِيَّةٌ مُرْسَلَةٌ إلَيكَ، يا سَيِّدِي عِيسُو. وَها هُوَ آتٍ خَلْفِي.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ثُمَّ أوْصَى يَعقُوبُ خادِمَهُ الثّانِي ثُمَّ الثّالِثَ وَجَمِيعَ الخُدّامِ الَّذِينَ كانُوا يَتبَعُونَ القُطعانَ وَقالَ لَهُمْ: «قُولُوا الكَلامَ نَفْسَهُ لِعِيسُو عِندَما تَجِدُونَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","وَقُولُوا لَهُ: ‹ها هُوَ خادِمُكَ يَعقُوبُ آتٍ خَلْفَنا.›» فَقَدْ قالَ يَعقُوبُ فِي نَفْسِهِ: «سَأسْتَرْضِيهِ بِالهَدِيَّةِ الَّتِي تَسْبِقُنِي. وَسَأراهُ فِيما بَعْدُ وَجْهاً لِوَجهٍ. فَحِينَئِذٍ، رُبَّما أحظَى بِرِضاهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","فَمَضَتِ الهَدِيَّةُ أمامَ يَعقُوبَ. أمّا يَعْقُوبُ فَأمضَى تِلْكَ اللَّيلَةَ فِي المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","وَفِي تِلْكَ اللَّيلَةِ قامَ وَأخَذَ زَوْجَتَيهِ وَخُدّامَهُ وَخادِماتِهِ وَعَبَرَ نُهَيرَ يَبُّوقَ، عِنْدَ المَعبَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","أخَذَهُمْ وَأرْسَلَهُمْ عَبْرَ الوادِي، وَأرْسَلَ أيضاً كُلَّ ما كانَ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","أمّا يَعقُوبُ فَبَقِيَ وَحدَهُ. وَتَصارَعَ إنْسانٌ مَعَهُ هُناكَ حَتَّى طُلُوعِ الفَجْرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","فَلَمّا رَأى الإنْسانُ أنَّهُ لا يَقْدِرُ عَلَى يَعْقُوبَ، ضَرَبَ مِفْصَلَ فَخذِ يَعقُوبَ فانخَلَعَ وَهُوَ يُصارِعُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ثُمَّ قالَ لِيَعْقُوبَ: «أطلِقْنِي، فَها الفَجْرُ يَبْزُغُ.» فَقالَ يَعقُوبُ: «لَنْ أُطلِقَكَ حَتَّى تُبارِكَنِي!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","فَقالَ لِيَعقُوبَ: «ما اسْمُكَ؟» فَقالَ: «اسْمِي يَعقُوبُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","فَقالَ لَهُ: «لَنْ تُدعَى يَعقُوبَ فِيما بَعْدُ، بَلْ إسْرائِيلَ. فَأنتَ جاهَدْتَ مَعَ اللهِ وَمَعَ النّاسِ، وَفُزْتَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","فَسَألَهُ يَعقُوبُ: «أخبِرْنِي بِاسْمِكَ.» فَقالَ: «لِماذا تَسألُ عَنِ اسْمِي؟» ثُمَّ بارَكَهُ هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","وَسَمَّى يَعقُوبُ المَكانَ فَنِيئِيلَ. إذْ قالَ: «لَقَدْ رَأيتُ اللهَ وَجهاً لِوَجهٍ، لَكِنَّهُ أبقَى عَلَى حَياتِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","وَأشْرَقَتِ الشَّمْسُ عَلَيهِ وَهُوَ مارٌّ بِفَنِيئِيلَ. وَكانَ يَعرُجُ بِسَبَبِ فَخذِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","وَلِهَذا فَإنَّ بَنِي إسْرائِيلَ لا يَأْكُلُونَ العَضَلَةَ الَّتي عَلَى مِفْصَلِ الفَخذِ إلَى هَذا اليَوْمِ، لِأنَّ يَعقُوبَ ضُرِبَ عَلَى عَضَلَةِ مِفصَلِ فَخذِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","وَرَفَعَ يَعقُوبُ نَظَرَهُ، فَإذا بِعِيسُو قادِمٌ مَعَ أرْبَعِ مِئَةِ رَجُلٍ. فَقَسَّمَ الأطفالَ بَينَ لَيئَةَ وَراحِيلَ وَالخادِمَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","فَوَضَعَ الخادِمَتَينِ وَأبْناءَهُنَّ أوَّلاً، ثُمَّ لَيئَةَ وَأبْناءَها، ثُمَّ راحِيلَ وَيُوسُفَ آخِرَ الكُلِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","لَكِنَّهُ بَعدَ ذَلِكَ تَقَدَّمَهُمْ بِنَفْسِهِ، وَانحَنَى إلَى الأرْضِ سَبْعَ مَرّاتٍ بَينَما كانَ يَقْتَرِبُ مِنْ أخِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","لَكِنَّ عِيسُو رَكَضَ لِمُلاقاتِهِ، وَعانَقَهُ، وَطَوَّقَهُ بِذِراعَيهِ، وَقَبَّلَهُ، فَبَكَيا مَعاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ثُمَّ رَفَعَ عِيسُو نَظَرَهُ. فَرَأى النِّساءَ وَالأطفالَ. فَقالَ: «مَنْ هَؤُلاءِ الَّذِينَ مَعَكَ؟» فَقالَ يَعقُوبُ: «هَؤُلاءِ هُمُ الأبْناءُ الَّذِينَ أعطاهُمُ اللهُ لِي، أنا خادِمَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ثُمَّ اقتَرَبَتِ الخادِمَتانِ وَأبْناؤُهُما مِنْ عِيسُو وَانحَنُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ثُمَّ اقْتَرَبَتْ لَيئَةُ وَأبْناؤُها وَانحَنُوا. ثُمَّ اقتَرَبَ يُوسُفُ وَراحِيلُ وَانحَنَيا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","فَقالَ عِيسُو: «ماذا قَصَدْتَ بِإرْسالِكَ كُلَّ هَذِهِ الجَماعَةِ الَّتِي قابَلْتُها؟» فَقالَ يَعقُوبُ: «أرَدْتُ أنْ أحْظى بِرِضاكَ، يا سَيِّدِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","فَقالَ عِيسُو: «عِندِي ما يَكفِي، يا أخِي! فابْقِ ما لَكَ عِندَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","فَقالَ يَعقُوبُ: «لا! إنْ كُنْتَ راضِياً عَنِّي، فاقْبَلْ هَذِهِ الهَدِيَّةَ مِنْ يَدَيَّ. بَعدَ أنْ رَضِيتَ عَنِّي صارَ النَّظَرُ إلَى وَجهِكَ عِندِي أشْبَهَ بِالنَّظَرِ إلَى وَجهِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","فاقْبَلِ الهَدِيَّةَ الَّتِي جَلَبْتُها لَكَ. فَقَدْ كانَ اللهُ كَرِيماً مَعِي، وَأعطانِي كُلَّ ما أُرِيدُ.» وَألَحَّ يَعقُوبُ عَلَى عِيسُو، فَقَبِلَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","وَقالَ عِيسُو: «هَيّا نَمضِ فِي طَريقِنا، وَسَأذْهَبُ مَعَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","لَكِنَّ يَعقُوبَ قالَ لَهُ: «أنتَ تَعلَمُ يا سَيِّدِي أنَّ الأطفالَ تَعِبُونَ، وَأنَّ المَواشِيَ المُرْضِعَةَ مَصْدَرُ قَلَقٍ لِي. فَإذا أرهَقْتُها كَثِيراً فِي يَوْمٍ واحِدٍ، فَسَتَمُوتُ كُلُّها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","فاسْبِقْ يا سَيِّدِي خادِمَكَ. أمّا أنا فَسَأسِيرُ بِبُطءٍ عَلَى سُرْعَةِ البَقَرِ الَّتِي أمامِي، وَسُرْعَةِ الأطفالِ، إلَى أنْ أصِلَ إلَيكَ يا سَيِّدِي فِي سَعِيرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","فَقالَ عِيسُو: «اسْمَحْ لِي إذاً أنْ أتْرُكَ عِندَكَ بَعْضَ الَّذِينَ مَعِي.» فَقالَ يَعقُوبُ: «هَذَا لُطْفٌ لا أسْتَحِقُّهُ يا سَيِّدي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","فَعادَ عِيسُو فِي ذَلِكَ اليَوْمِ مُتَّجِهاً إلَى سَعِيرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","أمّا يَعقُوبُ فَذَهَبَ إلَى بَلْدَةِ سُكُّوتَ وَبَنَى لِنَفْسِهِ بَيتاً هُناكَ. وَصَنَعَ أيضاً خِياماً لِحِمايَةِ مَواشِيهِ. فَدُعِيَ ذَلِكَ المَكانُ سُكُّوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","وَوَصَلَ يَعقُوبُ بِالسَّلامَةِ إلَى مَدِينَةِ شَكِيمَ فِي أرْضِ كَنْعانَ لَمّا جاءَ مِنْ فَدَّانَ أرامَ. وَخَيَّمَ يَعْقُوبُ أمامَ المَدِينَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","وَاشْتَرَى يَعقُوبُ جُزءاً مِنَ الحَقلِ الَّذِي نَصَبَ فِيهِ خَيمَتَهُ مِنْ أولادِ حَمُورَ وَالِدِ شَكِيمَ، بِمِئَةِ قِطعَةٍ مِنَ الفِضَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","وَبَنَى مَذبَحاً هُناكَ وَسَمّاهُ إيلَ، إلَهَ إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","وَخَرَجَتْ دِينَةُ ابْنَةُ لَيئَةَ وَيَعقُوبَ لِتَرَى بَناتِ تِلْكَ المَنطَقَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","فَرَآها شَكِيمُ بْنِ حَمُورَ، رَئِيسَ تِلْكَ المَنطَقَةِ، فَأمْسَكَ بِها وَاغتَصَبَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","لَكِنَّهُ تَعَلَّقَ بِدِينَةَ ابْنَةِ يَعقُوبَ. أحَبَّ الفَتاةَ وَكانَ رَقِيقاً مَعَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","فَقالَ شَكِيمُ لِأبِيهِ حَمُورَ: «زَوِّجْنِي مِنْ هَذِهِ البِنْتِ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","وَسَمِعَ يَعقُوبُ أنَّ شَكِيمَ اعتَدَى عَلَى ابْنَتِهِ دِينَةَ. وَكانَ أولادُهُ مَعَ الماشِيَةِ فِي الحَقلِ، فانتَظَرَ إلَى أنْ يَأْتُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","وَخَرَجَ حَمُورُ، أبو شَكِيمَ، إلَى يَعقُوبَ لِيَتَكَلَّمَ مَعَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","وَفِي هَذا الوَقْتِ، رَجِعَ أولادُ يَعقُوبَ مِنَ الحَقلِ. فَلَمّا سَمِعُوا بِما حَدَثَ، اشْتَدَّ غَضَبُهُمْ وَسَخَطُهُمْ، إذْ فَعَلَ شَكِيمُ أمراً مُشِيناً فِي إسْرائِيلَ بِاغْتِصابِ ابْنَةِ يَعقُوبَ. فَما كانَ يَنبَغِي لِمِثلِ هَذا أنْ يَحْدُثَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","فَقالَ حَمُورُ لَهُمْ: «قَدْ تَعَلَّقَ قَلبُ ابْنِي شَكِيمُ بِابْنَتِكُمْ، فَزَوِّجُوها لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","صاهِرُونا. زَوِّجُونا مِنْ بَناتِكُمْ، وَتَزَوَّجُوا مِنْ بَناتِنا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","وَاسْتَقِرُّوا بَينَنا. فَالأرْضُ مَفْتُوحَةٌ أمامَكُمْ. اسْتَقِرُّوا وَتاجِرُوا وَتَمَلَّكُوا أراضِيَ فِيها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","وَقالَ شَكِيمُ لِأبِيها وَإخوَتِها: «اقْبَلُونِي، وَسَأُعطِيكُمْ ما تَطلُبُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ارفَعُوا قِيمَةَ المَهْرِ وَالهَدايا بِقَدْرِ ما شِئْتُمْ، وَسَأُعطِيكُمْ كُلَّ ما تَأْمُرُونَنِي بِهِ، لَكِنْ زَوِّجُونِي مِنَ البِنتِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","فَأجابَ أولادُ يَعقُوبَ شَكِيمَ وَأباهُ حَمُورَ بِطَرِيقَةٍ ماكِرَةٍ، لِأنَّهُ اعتَدَى عَلَى أُختِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","قالُوا لَهُمْ: «لا نَقْدِرُ أنْ نَفعَلَ هَذا الأمْرَ. لا يُمكِنُنا أنْ نُزَوِّجَ أُختَنا مِنْ رَجُلٍ غَيرِ مَختُونٍ، فَهَذا عارٌ لَنا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","فَلا نُوافِقَكُمْ عَلَى طَلَبِكُمْ إلّا بِشَرطٍ، وَهُوَ أنْ تُصبِحُوا مِثلَنا بِأنْ تَختِنُوا كُلَّ ذَكَرٍ بَينَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","حِينَئِذٍ، سَنُزَوِّجُكُمْ مِنْ بَناتِنا، وَسَنَتَزَوَّجُ مِنْ بَناتِكُمْ، وَسَنَسْتَقِرُّ بَينَكُمْ، وَنُصْبِحُ شَعباً واحِداً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","لَكِنْ إذا لَمْ تَستَمِعُوا لَنا وَتَختَتِنُوا، فَسَنَأْخُذُ ابْنَتَنا وَنَرْحَلُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","فَاسْتَحْسَنَ حَمُورُ وَشَكِيمُ هَذا الكَلامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","وَلَمْ يَتَرَدَّدِ الشّابُّ فِي فِعلِ ما طُلِبَ مِنْهُ، لِأنَّهُ فُتِنَ بِابْنَةِ يَعقُوبَ. وَكانَ شَكِيمُ ذا شأنٍ كَبيرٍ فِي بَيتِ أبِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","فَذَهَبَ حَمُورُ وَابْنُهُ شَكِيمُ إلَى بَوّابَةِ مَدِينَتِهِما. وَقالا لِرِجالِ المَدِينَةِ: ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«هَؤُلاءِ الرِّجالُ طَيِّبُونَ مَعَنا. فَلْنَدَعْهُمْ يَسْتَقِرُّونَ فِي الأرْضِ وَيُتاجِرُونَ فِيها. فَها الأرْضُ تَتَّسِعُ لَهُمْ وَلَنا. وَلْنَتَزَوَّجْ مِنْ بَناتِهِمْ، وَلْنُزَوِّجهُمْ مِنْ بَناتِنا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","غَيرَ أنَّ لِهَؤُلاءِ القَوْمِ شَرْطاً لِكَي يَسْتَقِرُّوا بَينَنا، وَيَكُونُوا شَعباً واحِداً مَعَنا. وَهُوَ أنْ يُختَتَنَ كُلُّ ذَكَرٍ مِنّا مِثلَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","سَتَكُونُ قُطْعانُهُمْ وَأملاكُهُمْ وَجَمِيعُ حَيواناتِهِمْ لَنا. لَكِنْ يَنبَغِي أنْ نُوافِقَ عَلَى شَرْطِهِمْ لِيَسْتَقِرُّوا بَينَنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","فَوافَقَ جَمِيعُ أهلُ المَدِينَةِ حَمُورَ وَابْنَهُ شَكِيمَ عَلَى رَأْيِهِما. وَاختَتَنَ كُلُّ ذَكَرٍ مِنْ أهلِ المَدِينَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","وَفِي اليَوْمِ الثّالِثِ كانَ رِجالُ المَدِينَةِ فِي ألَمٍ شَدِيدٍ. فَأخَذَ ابْنا يَعقُوبَ، شَمْعُونَ وَلاوِي، أخَوا دِينَةَ سَيفَيهِما، وَهاجَما أهلَ المَدِينَةِ السُّقَماءَ بِجَسارَةٍ. وَذَبَحا كُلَّ ذَكَرٍ فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","وَقَتَلا حَمُورَ وَابْنَهُ شَكِيمَ أيضاً. وَأخَذا دِينَةَ مِنْ بَيتِ شَكِيمَ، وَمَضَيا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","وَأتَى أبناءُ يَعقُوبَ الآخَرُونَ عَلَى جُثَثِ القَتلِى، وَنَهَبُوا المَدِينَةَ، لِأنَّ شَكِيمَ اعتَدَى عَلَى أُختِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","وَأخَذُوا ماشِيَتَهُمْ وَبَقَرَهُمْ وَحَمِيرَهُمْ وَكُلَّ ما كانَ فِي المَدِينَةِ وَفِي الحُقُولِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","سَبَوا وَأخَذُوا كُلَّ ثَرْوَتِهِمْ وَنِسائِهِمْ وَأبْنائِهِمْ، وَكُلَّ ما فِي بُيُوتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","فَقالَ يَعقُوبُ لِشَمْعُونَ وَلاوِي: «لَقَدْ أزْعَجْتُمانِي إذْ صِرْتُ مَكرُوهاً بَينَ قاطِنِي هَذِهِ البِلادِ مِنَ الكَنعانِيِّينَ وَالفِرِزِّيِّينَ. أنا وَعائِلَتِي قِلَّةٌ. لِهَذا أخشَى أنْ يَجتَمِعُوا عَلَينا، وَأنْ يُهاجِمُونا، فَيُدَمِّرُونا أنا وَأهلَ بَيتِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","فَقالا لَهُ: «أكانَ يُفْتَرَضُ فِينا أنْ نَرضَى أنْ تُعامَلَ أُختُنا كَساقِطَةٍ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ثُمَّ قالَ اللهُ لِيَعقُوبَ: «قُمْ وَاذْهَبْ إلَى بَيتِ إيلَ وَاسْكُنْ هُناكَ. وَابْنِ مَذْبَحاً هُناكَ للهِ الَّذِي ظَهَرَ لَكَ وَأنتَ هارِبٌ مِنْ وَجهِ أخِيكَ عِيسُو.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","فَقالَ يَعقُوبُ لِأهلِ بَيتِهِ وَلِكُلِّ الَّذِينَ كانُوا مَعْهُ: «تَخَلَّصُوا مِنَ الآلِهَةِ الغَرِيبَةِ الَّتِي لَدَيكُمْ. وَطَهِّرُوا أنفُسَكُمْ، وَغَيِّرُوا ثِيابَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","فَلْنُغادِرْ هَذا المَكانَ وَنَذْهَبْ إلَى بَيتِ إيلَ، فَأبنِيَ هُناكَ مَذبَحاً للهِ الَّذِي استَجابَ لِي فِي وَقتِ ضِيقِي، وَرافَقَنِي فِي الطَّرِيقِ الَّذِي مَضَيتُ فِيهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","فَأعطُوا لِيَعقُوبَ كُلَّ الأوثانِ الغَريبَةِ الَّتِي كانَتْ لَدَيهِمْ، وَالأقْراطِ الَّتِي كانَتْ فِي آذانِهِمْ. فَدَفَنَها يَعقُوبُ تَحْتَ شَجَرَةِ البُطْمِ قُرْبَ شَكِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ثُمَّ انطَلَقُوا. وَجَعَلَ اللهُ أهلَ المُدُنِ حَولَهُمْ يَهابُونَ عائِلَةَ يَعقُوبَ. فَلَمْ يُلاحِقُوا أبْناءَ يَعقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","فَجاءَ يَعقُوبُ وَكُلُّ الَّذِينَ مَعَهُ إلَى لُوزَ، أي بَيتِ إيلَ فِي أرْضِ كَنْعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","وَبَنَى مَذبَحاً هُناكَ. وَدَعا المَكانَ «إلَهَ بَيتَ إيلَ.» لِأنَّ اللهَ أعلَنَ لَهُ نَفْسَهُ وَهُوَ هارِبٌ مِنْ أخِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","وَماتَتْ دَبُّورَةُ، مُرضِعَةُ رِفْقَةَ هُناكَ. وَدُفِنَتْ تَحتَ البَلُّوطَةِ قُرْبَ بَيتِ إيلَ. وَسَمَّى يَعقُوبُ ذَلِكَ المَكانَ «بَلُّوطَةَ الحُزنِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","وَفِي طَرِيقِ عَوْدَتِهِ مِنْ فَدَّانَ أرامَ، ظَهَرَ اللهُ لِيَعقُوبَ وَبارَكَهُ ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","وَقالَ لَهُ: «اسْمُكَ يَعقُوبُ. لَكِنَّكَ لَنْ تُدعَى يَعقُوبَ فِيما بَعْدُ، بَلْ إسْرائِيلَ.» فَسَمّاهُ اللهُ «إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","وَقالَ لَهُ: «أنا اللهُ الجَبّارُ. لِيَكُنْ لَكَ أبناءٌ كَثِيرُونَ، وَلْتَزْدَدْ عَدَداً. سَتَخرُجُ مِنْكَ أُمَّةٌ، بَلْ جَماعَةٌ مِنَ الأُمَمِ. وَسَيَنحَدِرُ مُلُوكٌ مِنْكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","وَسَأُعطِيكَ الأرْضَ الَّتِي أعطَيتُها لإبْراهِيمَ وَإسْحاقَ. وَسَأُعطِيها لِنَسلِكَ مِنْ بَعدِكَ أيضاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ثُمَّ مَضَى عَنْهُ اللهُ فِي المَكانِ الَّذِي كَلَّمَهُ فِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","فَأقامَ يَعقُوبُ نَصَباً تَذْكاريّاً حَجَرِيّاً فِي المَكانِ الَّذِي كَلَّمَهُ اللهُ فِيهِ، وَكَرَّسَهُ للهِ بِسَكِيبٍ مِنَ النَّبِيذِ وَزَيتِ الزَّيتُونِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","وَسَمَّى يَعقُوبُ المَكانَ الَّذِي كَلَّمَهُ اللهُ فِيهِ بَيتَ إيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ثُمَّ انطَلَقُوا مِنْ بَيتِ إيلَ. وَقَبلَ أنْ يَصِلُوا إلَى أفْراتَةَ بَدَأتْ راحِيلُ تَلِدُ. وَكانَتْ أوجاعُ الوِلادَةِ شَدِيدَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","فَقالَتْ لَها القابِلَةُ أثْناءَ وِلادَتِها العَسِرَةِ: «لا تَخافِي، فَهَذا ابْنٌ آخَرُ لَكِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","وَأثناءَ نِزاعِها، وَقُبَيلَ مَوْتِها، سَمَّتِ ابْنَها «بَنْ أُونِي،» لَكِنَّ أباهُ سَمّاهُ «بَنْيامِيْنَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","وَماتَتْ راحِيلُ وَدُفِنَتْ فِي الطَّرِيقِ إلَى أفراتَةَ، أي بَيتَ لَحْمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","فَأقامَ يَعقُوبُ عَمُوداً فَوقَ قَبْرِها وَهُوَ مَعرُوفٌ حَتَّى هَذا اليَوْمِ بِاسْمِ عَمُودِ قَبْرِ راحِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ثُمَّ تابَعَ إسْرائِيلُ ارتِحالَهُ. وَخَيَّمَ جَنُوبَ بُرجِ عِدْرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","وَبَينَما كانَ إسْرائِيلُ ساكِناً فِي تِلكَ المَنْطِقَةِ، ذَهَبَ رَأُوبَيْنُ وَنامَ مَعَ بِلْهَةَ، خادِمَةِ أبِيهِ. فَعَلِمَ إسْرائِيلُ بِالأمْرِ. وَكانَ لِيَعقُوبَ اثْنا عَشَرَ ابْناً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","أبْناؤُهُ مِنْ لَيئَةَ هُمْ رَأُوبَيْنُ بِكْرُ يَعقُوبَ، وَشِمْعُونُ وَلاوِي وَيَهُوذا وَيَسّاكَرُ وَزَبُولُونُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","وَابْناهُ مِنْ راحِيلَ هُما يُوسُفُ وَبَنْيامِيْنُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","وَابْناهُ مِنْ بِلْهَةَ، خادِمَةِ راحِيلَ، هُما دانُ وَنَفْتالِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","وَابْناهُ مِنْ زِلْفَةَ، خادِمَةِ لَيئَةَ، هُما جادُ وَأشِيرُ. هَؤُلاءِ هُمْ أولادُ يَعقُوبَ الَّذِينَ أنجَبَهُمْ فِي فَدَّانَ أرامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","وَجاءَ يَعقُوبُ إلَى أبِيهِ إسْحاقَ فِي مَمْرا، قَرْيَةِ أرْبَعَ، أي حَبْرُونَ، حَيثُ كانَ إبْراهِيمُ وَإسْحاقُ قَدْ عاشا هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","وَعاشَ إسْحاقُ مِئَةً وَثَمانِينَ عاماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ثُمَّ لَفَظَ أنفاسَهُ الأخِيرَةَ وَماتَ. وَانْضَمَّ إلَى جَماعَتِهِ عَجُوزاً شَبِعَ مِنَ الحَياةِ. وَدَفَنَهُ ابْناهُ عِيسُو وَيَعْقُوبُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","هَذا سِجِلُّ نَسلِ عِيسُو الَّذِي هُوَ أدُومُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","تَزَوَّجَ عِيسُو أوَّلَ امْرَأتَينِ وَكانَتا كَنْعانِيَّتَينِ. وَهُما عَدَا بِنتُ إيلُونَ الحِثِّيِّ، وَأُهُولِيبامَةُ بِنتُ عَنَى بِنتِ صِبْعُونَ الحِوِّيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ثُمَّ تَزَوَّجَ بَسْمَةَ بِنتَ إسْماعِيلَ، وَأُختَ نَبايُوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","وَكانَ لِعَدا وَعِيسُو ابْنٌ اسْمُهُ ألِيفازُ. وَأنجَبَتْ بَسْمَةُ رَعُوئِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","وَأنجَبَتْ أهُولِيبامَةُ يَعُوشَ وَيَعلامَ وَقُورَحَ. هَؤُلاءِ هُمْ أولادُ عِيسُو الَّذِينَ وُلِدُوا فِي أرْضِ كَنْعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ثُمَّ أخَذَ عِيسُو زَوْجاتِهِ وَبَنِيهِ وَبَناتِهِ وَكُلَّ أهلِ بَيتِهِ وَمَواشِيَهُ وَكُلَّ حَيواناتِهِ وَكُلَّ أملاكِهِ الَّتِي اقْتَناها فِي أرْضِ كَنْعانَ، وَانتَقَلَ إلَى أرْضٍ أُخْرَى بَعِيداً عَنْ يَعقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","إذْ كانَتْ مُمتَلَكاتُهُما أوْسَعَ مِنْ أنْ يَسْكُنا مَعاً. وَلَمْ تَتَّسِعِ الأرْضُ الَّتِي كانا يَسْكُنانِ فِيها لَهُما مَعاً، لِأنَّ مَواشِيَهُما كانَتْ كَثِيرَةً جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","فَاسْتَقَرَّ عِيسُو فِي بِلادِ سَعِيرَ. وَعِيسُو هُوَ أدُومُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","هَذا سِجِلُّ نَسلِ عِيسُو، أصلِ شَعبِ أدُومَ الَّذِينَ يَعِيشُونَ فِي بِلادِ سَعِيرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","هَذِهِ أسْماءُ أولادِ عِيسُو: ألِيفازُ، وَهُوَ ابْنُ عِيسُو مِنْ زَوْجَتِهِ عَدَا، وَرَعُوئِيلُ، وَهُوَ ابْنُ عِيسُو مِنْ زَوجَتِهِ بَسْمَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","وَأولادُ ألِيفازَ هُمْ تَيمانُ وَأوْمارُ وَصَفْو وَجَعْثامُ وَقَنازُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","وَكانَتْ تِمْناعُ، جارِيَةً لِألِيفازَ بْنِ عِيسُو. وَأنجَبَتْ لِألِيفازَ ابْناً اسْمُهُ عَمالِيقُ. هَذِهِ أسْماءُ أولادِ عَدَا زَوجَةِ عِيسُو. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","وَأولادُ رَعُوئِيلَ هُمْ نَحَثُ وَزارَحُ وَشَمَّةُ وَمِزَّةُ. هَذِهِ أسْماءُ أولادِ بَسْمَةَ زَوجَةِ عِيسُو. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","وَأولادُ أهُولِيبامَةَ ابْنَةِ عَنَى بْنِ صِبْعُونَ زَوْجَةِ عِيسُو. فَقَدْ أنجَبَتْ لِعِيسُو يَعُوشَ وَيَعلامَ وَقُورَحَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","وَهَؤُلاءِ هُمْ رُؤَساءُ العَشائِرِ الَّذِينَ انحَدَرُوا مِنْ عِيسُو: أولادُ ألِيفازَ، بِكْرِ عِيسُو، رُؤَساءُ تَيمانَ وَأوْمارَن وَصَفْوا وَقَنازَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","وَجَعْثامَ وَعَمالِيقَ. كانَ هَؤُلاءِ رُؤَساءَ العَشائِرِ المُنحَدِرِينَ مِنْ ألِيفازَ فِي أرْضِ أدُومَ. وَهُمْ أولادُ عَدا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","وَهَؤُلاءِ هُمْ أولادُ رَعُوئِيلَ بْنِ عِيسُو: رُؤَساءُ عَشائِرِ نَحَثٍ وَزارَحَ وَشَمَّةَ وَمِزَّةَ. هَؤُلاءِ هُمْ رُؤَساءُ العَشائِرِ الَّذِينَ انحَدَرُوا مِنْ رَعُوئِيلَ فِي أرْضِ أدُومَ. هَؤُلاءِ أولادُ بَسْمَةَ زَوجَةِ عِيسُو. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","وَهَؤُلاءِ هُمْ أولادُ أُهُولِيبامَةَ زَوْجَةِ عِيسُو: رُؤَساءُ عَشائِرِ يَعُوشَ وَيَعلامَ وَقُورَحَ. هَؤُلاءِ هُمْ رُؤَساءُ العَشائِرِ الَّذِينَ أنْجَبَتْهُمْ زَوجَةُ عِيسُو أُهُولِيبامَةُ، ابْنَةُ عَنَى. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","كانَ هَؤُلاءِ مِنْ نَسلِ عِيسُو، أي أدُومَ، وَكانَ هَؤُلاءِ رُؤَساءَ عَشائِرِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","وَهَؤُلاءِ هُمْ أولادُ سَعِيرَ الحُورِيِّ الَّذِينَ كانُوا يَسْكُنُونَ فِي تِلْكَ الأرْضِ: لُوطانُ وَشُوبالُ وَصِبْعُونُ وَعَنَىً ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","وَدِيشُونُ وَإيصَرُ وَدِيشانُ. هَؤُلاءِ هُمْ رُؤَساءُ العَشائِرِ الحُورِيِّونَ، أبْناءُ سَعِيرَ فِي أرْضِ أدُومَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","وَكانَ ابْنا لُوطانَ هُما حُورِيَ وَهَيمامَ. وَكانَتْ تِمْناعُ أُختَ لُوطانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","وَهَؤُلاءِ هُمْ أبْناءُ شُوبالَ: عَلْوانُ وَمَناحَةُ وَعَيبالُ وَشَفْوٌ وَأُونامُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","وَابْنا صِبْعُونَ هُما أيَّةُ وَعَنَىً. وَعَنَىً هُوَ الَّذِي وَجَدَ اليَنابِيعَ الحارَّةَ فِي الصَّحْراءِ بينَما كانَ يَرْعَى حَمِيرَ أبِيهِ صِبْعُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","وَكانَ لِعَنَى ابْنٌ اسْمُهُ دِيشُونَ، وَابْنَةٌ اسْمُها أُهُولِيبامَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","وَأبْناءُ دِيشُونَ هُمْ حَمْدانُ وَأشْبانُ ويِثْرانُ وَكَرانُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","وَأبْناءُ إيصَرَ هُمْ بِلْهانُ وَزَعْوانُ وَعَقانُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","وَابْنا دِيشانَ هُما عُوصٌ وَأرانُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","وَهَؤُلاءِ هُمْ رُؤَساءُ عَشائِرِ الحُورِيِّينَ: رُؤَساءُ لُوطانَ وَشُوبالَ وَصِبْعُونَ وَعَنَى ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","وَدِيشُونَ وَإيصَرَ وَدِيشانَ. هَؤُلاءِ هُمْ رُؤَساءُ عَشائِرِ الحُورِيِّينَ فِي أرْضِ سَعِيرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","هَذِهِ أسْماءُ المُلُوكِ الَّذِينَ حَكَمُوا فِي أرْضِ أدُومَ قَبلَ أنْ يَملُكَ أحَدٌ عَلَى بَنِي إسْرائِيلَ: ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","بالَعُ بْنُ بَعُورَ صارَ مَلِكاً فِي أدُومَ. وَكانَ اسْمُ مَدِينَتِهِ دِنْهابَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","وَماتَ بالَعُ، فَخَلَفَهُ يُوبابُ بْنُ زارَحَ مِنْ بُصْرَةَ مَلِكاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","وَماتَ يُوبابُ، فَخَلَفَهُ حُوشامُ مِنْ أرْضِ التَّيمانِيِّينَ مَلِكاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","وَماتَ حُوشامُ، فَخَلَفَهُ هَدادُ بْنُ بَدادَ مَلِكاً. وَهَدادَ هُوَ الَّذِي هَزَمَ مِدْيانَ فِي بِلادِ مُوآبَ. وَكانَ اسْمُ مَدِينَتِهِ عَوِيتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","وَماتَ هَدادُ، فَخَلَفَهُ سَملَةُ مِنْ مَسْرِيقَةَ مَلِكاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","وَماتَ سَملَةُ، فَخَلَفَهُ شَاوُلُ مِنْ رَحُوبُوتَ الواقِعَةِ عَلَى نَهْرِ الفُراتِ مَلِكاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","وَماتَ شَاوُلُ، فَخَلَفَهُ بَعلُ حانانَ بْنُ عَكْبُورَ مَلِكاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","وَماتَ بَعلُ حانانَ، فَخَلَفَهُ هَدادُ مَلِكاً بَدَلاً مِنْهُ. وَكانَ اسْمُ مَدِينَتِهِ فاعُو. وَكانَ اسْمُ زَوجَتِهِ مَهِيطَبْئِيلَ ابْنَةَ مَطْرِدَ ابْنَةِ ماءِ الذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","وَهَذِهِ أسْماءُ قَبائلِ عِيسُو حَسَبَ عائِلاتِهِمْ وَمَناطِقِهِمْ: تِمْناعَ وَعَلْوَةَ وَيَتِيتَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","وَأُهُولِيبامَةَ وَإيلَةَ وَفِينُونَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","وَقَنازَ وَتِيمانَ وَمِبْصارَ ");
INSERT INTO arbwbtc_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","وَمَجْدِيئِيلَ وَعِيرامَ. هَذِهِ قَبائلُ أدُومَ حَسَبَ تَوزِيعِهِمْ فِي الأرْضِ الَّتِي امتَلَكُوها. وَعِيسُو هُوَ أصلُ أهلِ أدُومَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","وَاسْتَقَرَّ يَعقُوبُ فِي الأرْضِ الَّتِي كانَ قَدِ اسْتَقَرَّ فِيها أبوْهُ، أي أرْضِ كَنْعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","وَهَذِهِ هِيَ قِصَّةُ عائِلَةِ يَعقُوبَ: كانَ يُوسُفُ فِي السّابِعَةَ عَشْرَةَ مِنْ عُمْرِهِ، وَكانَ يَرْعَى الماشِيَةَ مَعَ إخْوَتِهِ. وَعَمِلَ مُساعِداً لِأولادِ بِلْهَةَ وَزِلْفَةَ، زَوْجَتَي أبِيهِ. وَنَقَلَ يُوسُفُ أخبارَهُمُ السَّيِّئَةَ لِأبِيهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","وَأحَبَّ إسْرائِيلُ يُوسُفَ أكثَرَ مِنْ كُلِّ أبْنائِهِ الآخَرِينَ، لِأنَّهُ وُلِدَ وَهُوَ شَيخٌ. وَصَنَعَ إسْرائِيلُ لِيُوسُفَ ثَوباً مُلَوَّناً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","وَرَأى إخْوَتُهُ أنَّ أباهُمْ يُحِبُّهُ أكْثَرَ مِنْهُمْ جَمِيعاً. فَأبغَضُوا يُوسُفَ، وَلَمْ يَكُونُوا يَقْدِرُونَ أنْ يَتَكَلَّمُوا مَعَهُ بِلُطْفٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","وَرَأى يُوسُفُ حُلْماً. وَأخبَرَ إخْوَتَهُ بِهِ، فَزادَ بُغْضُهُمْ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","قالَ لَهُمْ: «اسْتَمِعُوا إلَى هَذا الحُلْمِ الَّذِي رَأيتُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","كُنّا فِي وَسَطِ الحَقلِ نَحزِمُ حُزَماً مِنَ القَمْحِ، فَقامَتْ حُزمَتِي وَانتَصَبَتْ. ثُمَّ أحاطَتْ حُزَمُكُمْ بِحُزْمَتِي وَانحَنَتْ لَها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","فَقالَ لَهُ إخْوَتُهُ: «ألَعَلَّكَ تَظُنُّ بِأنَّكَ سَتَكُونُ مَلِكاً عَلَينا وَتَحْكُمُنا؟» فَزادَ بُغضُهُمْ لَهُ بِسَبَبِ أحلامِهِ وَكَلامِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","وَرَأى يُوسُفُ حُلْماً آخَرَ أيضاً. وَأبلَغَ إخْوَتَهُ بِحُلْمِهِ فَقالَ: «اسْمَعُوا هَذا الحُلْمَ الجَدِيدَ الَّذِي رَأيتُهُ. رَأيتُ الشَّمْسَ وَالقَمَرَ وَأحَدَ عَشَرَ نَجماً تَنحَنِي لِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","فَلَمّا أخبَرَ أباهُ وَإخوَتَهُ بِذَلِكَ، وَبَّخَهُ أبوْهُ، وَقالَ لَهُ: «ما هَذا الحُلْمُ الَّذِي رَأيتَهُ؟ هَلْ آتِي أنا وَأُمُّكَ وَإخوَتُكَ وَنَنحَنِي أمامَكَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","وَغارَ مِنْهُ إخْوَتُهُ، لَكِنَّ أباهُ تَفَكَّرَ فِي هَذا الأمْرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","وَذاتَ يَومٍ كانَ إخْوَةُ يُوسُفَ قَدْ ذَهَبُوا لِيَرعُوا ماشِيَةَ أبِيهِمْ فِي شَكِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","فَقالَ إسْرائِيلُ لِيُوسُفَ: «إخْوَتُكَ يَرعُونَ الماشِيَةَ فِي شَكِيمَ. جَهِّزْ نَفْسَكَ لِكَي أُرسِلَكَ إلَيْهِمْ.» فَقالَ لَهُ يُوسُفُ: «ها أنا مُسْتَعِدٌّ لِلذَّهابِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","فَقالَ لَهُ إسْرائِيلُ: «اذْهَبِ الآنَ لِتَرَى إنْ كانَ إخْوَتُكَ وَالماشِيَةُ بِخَيرٍ. ثُمَّ ارْجِعْ وَأخبِرْنِي.» فَأرسَلَهُ إسْرائِيلُ مِنْ وادِي حَبْرُونَ إلَى شَكِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","وَتاهَ يُوسُفُ فِي الصَّحْراءِ. فَلاقاهُ رَجُلٌ، فَسَألَهُ: «ما الَّذِي تَبْحَثُ عَنْهُ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","فَقالَ يُوسُفُ: «إنَّنِي أبْحَثُ عَنْ إخْوَتِي. فَأرجُو أنْ تُخبِرَنِي أينَ يَرْعُونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","فَقالَ الرَّجُلُ: «غادَرُوا هَذا المَكانَ، فَقَدْ سَمِعْتُهُمْ يَقُولُونَ: ‹لِنَذْهَبْ إلَى دُوثانَ.›» فَلَحِقَ يُوسُفُ بِإخوَتِهِ وَوَجَدَهُمْ فِي دُوثانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","وَرَآهُ إخْوَتُهُ آتِياً مِنْ بَعِيدٍ. وَقَبلَ أنْ يَقْتَرِبَ مِنْهُمْ، تَآمَرُوا لِقَتلِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","فَقالَ أحَدُهُمْ لِلآخَرِ: «انظُرُوا، ها هُوَ الحالِمُ آتٍ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","فَلنَقتُلْهُ وَنُلْقِ بِهِ فِي إحدَى الآبارِ الجافَّةِ. وَلنَقُلْ إنَّ حَيواناً مُفْتَرِساً افْتَرَسَهُ. وَلْنَرَ بَعْدَ هَذا مَصِيرَ أحلامِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","فَلَمّا سَمِعَ رَأُوبَيْنُ هَذا، حاوَلَ أنْ يُخَلِّصَهُ مِنْهُمْ. فَقالَ: «لا داعِيَ لِقَتلِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","وَقالَ أيْضاً: «لا تَسْفِكُوا دَماً! ألقُوهُ فِي هَذِهِ البِئْرِ فِي الصَّحْراءِ وَلا تُؤْذُوهُ.» قالَ رَأُوبَيْنُ هَذا لِكَي يُخَلِّصَهُ مِنْهُمْ، وَيُعِيدَهُ إلَى أبِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","فَلَمّا جاءَ يُوسُفُ إلَى إخْوَتِهِ، نَزَعُوا عَنْهُ ثَوبَهُ الطَويلَ المُلَوَّنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","وَأمْسَكُوهُ وَألقُوا بِهِ فِي البِئْرِ. وَكانَتِ البِئْرُ فارِغَةً بِلا ماءٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ثُمَّ جَلَسُوا لِيَأْكُلُوا. بَعْدَ ذَلِكَ، رَأَوْا قافِلَةً مِنَ التُّجّارِ آتِيَةً مِنْ جِلْعادَ، جِمالُهُمْ مُحَمَّلَةٌ بِصَمْغِ القَتاد وَالمُرِّ وَالبَلْسَمِ. وَكانُوا نازِلِينَ فِي طَرِيقِهِمْ إلَى مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","فَقالَ يَهُوذا لإخْوَتِهِ: «ماذا نَكْسِبُ إنْ قَتَلْنا أخانا وَأخفَينا جُثَّتَهُ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","فَلْنَبِعْهُ لِلتُّجّارِ ولا نُؤْذِهِ، فَهُوَ أخُونا مِنْ لَحْمِنا.» فَوافَقَ إخْوَتُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","وَلَمّا مَرَّ بَعضُ التُّجّارِ المِدْيانِيِّينَ، سَحَبُوا يُوسُفَ وَرَفَعُوهُ مِنَ البِئْرِ. وَباعُوهُ لِلتُّجّارِ بِعِشْرِينَ قِطعَةً مِنَ الفِضَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","فَأتَى التُّجّارُ بِيُوسُفَ إلَى مِصْرَ. وَلَمّا عادَ رَأُوبَيْنُ إلَى البِئْرِ. رَأى أنَّ يُوسُفَ لَمْ يَكُنْ فِيها. فَمَزَّقَ مَلابِسَهُ حُزْناً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ثُمَّ عادَ رَأُوبَيْنُ إلَى إخْوَتِهِ وَقالَ: «لَيسَ الفَتَى هُناكَ! فَماذا عَسانِي أفعَلُ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","فَأخَذُوا ثَوْبَ يُوسُفَ، وَذَبَحُوا تَيساً وَغَمَّسُوا مِعْطَفَهُ بِالدَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ثُمَّ أخَذُوا الثَّوبَ الطَّوِيلَ ذا الكُمَّينِ إلَى أبِيهِمْ. وَقالُوا: «وَجَدْنا هَذا الثَّوبَ. أهُوَ لابْنِكَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","فَمَيَّزَ يَعقُوبُ المِعطَفَ، وَقالَ: «هَذا ثَوبُ ابْنِي. التَهَمَهُ حَيوانٌ مُفْتَرِسٌ. وَلا بُدَّ أنَّهُ مَزَّقَ يُوسُفَ تَمْزيقاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","فَمَزَّقَ يَعقُوبُ ثِيابَهُ، وَلَبِسَ الخَيشَ حُزناُ، وَناحَ عَلَى ابْنِهِ مُدَّةً طَوِيلَةً جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ثُمَّ جاءَ كُلُّ أولادِ يَعقُوبَ لِيُعَزُّوهُ، فَأبَى أنْ يَتَعَزَّى. وَقالَ: «بَلْ أنزِلُ إلَى الهاوِيَةِ حُزْناً عَلَى ابْنِي!» فَناحَ أبو يُوسُفَ عَلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","أمّا يُوسُفُ، فَقَدْ باعَهُ المِدْيانِيُّونَ فِي مِصْرَ إلَى فُوطِيفارَ، وَهُوَ رَئِيسُ حَرَسِ القَصْرِ عِنْدَ فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","فِي ذَلِكَ الوَقتِ، تَرَكَ يَهُوذا إخْوَتَهُ وَنَزَلَ وَاسْتَقَرَّ عِندَ رَجُلٍ عَدُّلامِيٍّ اسْمُهُ حِيرَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","وَرَأى هُناكَ ابْنَةَ رَجُلٍ كَنْعانِيٍّ اسْمُهُ شُوعُ. فَتَزَوَّجَها وَعاشَرَها، ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","فَحَبِلَتْ وَأنجَبَتْ وَلَداً سَمَّتْهُ عِيرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ثُمَّ حَبِلَتْ مَرَّةً أُخْرَى وَأنجَبَتْ وَلَداً سَمَّتْهُ أُونانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ثُمَّ أنجَبَتْ وَلَداً آخَرَ وَسَمَّتْهُ شِيلَةَ. وَكانَ يَهُوذا ساكِناً فِي كَزِيبَ عِندَما أنجَبَتْ لَهُ شِيلَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","وَوَجَدَ يَهُوذا زَوجَةً لِبِكْرِهِ عِيرَ اسْمُها ثامارُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","لَكِنَّ اللهَ لَمْ يَكُنْ راضِياً عَنْ بِكْرِ يَهُوذا عِيرَ، فَأماتَهُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","فَقالَ يَهُوذا لِأُونانَ: «تَزَوَّجِ امْرأةَ أخِيكَ المُتَوَفَّى، فَتَصْنَعَ بِذَلِكَ وَاجِبَ أخِي الزَّوْجِ مَعَها، وَتُنجِبُ أولاداً يَحمِلُونَ اسْمَ أخِيكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","وَإذْ عَرَفَ أُونانُ أنَّ الطِّفلَ لَنْ يُنسَبَ إلَيهِ، كانَ إذا عاشَرَ امْرأةَ أخِيهِ يَقذِفُ عَلَى الأرْضِ لِئَلّا يُعطِي أخاهُ نَسلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","فَاسْتَاءَ اللهُ مِمّا فَعَلَهُ أُونانُ، فَأماتَهُ أيضاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","فَقالَ يَهُوذا لِكِنَّتِهِ ثامارَ: «ارجِعِي إلَى بَيتِ أبِيكِ وَلا تَتَزَوَّجِي إلَى أنْ يَكبُرَ شِيلَةُ.» فَقَدْ خافَ يَهُوذا أنْ يَموتَ شِيلَةُ أيضاً كَأخَوَيهِ. فَذَهَبَتْ ثامارُ وَعاشَتْ فِي بَيتِ أبِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","وَبَعدَ وَقْتٍ طَوِيلٍ، ماتَتِ ابْنَةُ شُوعَ، زَوْجَةُ يَهُوذا. وَبَعْدَ انتِهاءِ الحِدادِ، ذَهَبَ يَهُوذا مَعَ صَدِيقِهِ حِيرَةَ العَدُلّامِيِّ إلَى تِمْنَةَ، إلَى الرِّجالِ الَّذِينَ كانُوا يَجُزُّونَ صُوفَ غَنَمِه. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","فَقالَ أحَدُهُمْ لِثامارَ: «ها هُوَ حَمُوكِ فِي طَريقِهِ إلَى تِمْنَةَ لِيَجُزَّ صُوفَ غَنَمِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","فَخَلَعَتْ ثِيابَ تَرَمُّلِها، وَغَطَّتْ وَجْهَها بِحِجابٍ، وَلَفَّتْ نَفْسَها. ثُمَّ جَلَسَتْ عِندَ مَدْخَلِ عَينايِمَ الَّتِي كانَتْ عَلَى طَرِيقِ تِمْنَةَ، فَقَدْ رَأتْ أنَّ شِيلَةَ قَدْ كَبِرَ، وَأنَّها لَمْ تُزَوَّجْ مِنْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","فَلَمّا رَآها يَهُوذا ظَنَّ أنَّها امْرأةٌ ساقِطَةٌ، لِأنَّها كانَتْ تُغَطِّي وَجهَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","فَذَهَبَ إلَيها إلَى جانِبِ الطَّرِيقِ. وَقالَ لَها: «أُرِيدُ أنْ أُعاشِرَكِ.» إذْ لَمْ يَعرِفْ أنَّها كانَتْ زَوجَةَ ابْنِهِ. فَقالَتْ لَهُ ثامارُ: «وَماذا سَتُعطِينِي مُقابِلَ ذَلِكْ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","فَقالَ: «سَأُرْسِلُ إلَيكِ جَدْياً مِنْ قَطِيعِي.» فَقالَتْ: «لا أرْضَى إلّا إذا أبْقَيتَ عِندِي رَهناً إلَى أنْ تُرْسِلَهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","فَقالَ: «وَما هُوَ الرَّهْنُ الَّذِي تُرِيدِينَنِي أنْ أُبْقِيَهُ عِندَكِ إلَى أنْ آتِيَ؟» فَقالَتْ: «أعطِنِي خاتِمَكَ وَخَيطَهُ، وَعَصاكَ الَّتِي فِي يَدِكَ.» فَأعطاها لَها. ثُمَّ عاشَرَها فَحَبِلَتْ مِنْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ثُمَّ قامَتْ وَذَهَبَتْ إلَى بَيتِها. وَنَزَعَتْ حِجابَها، وَلَبِسَتْ ثِيابَ تَرَمُّلِها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","وَفِيما بَعْدُ، أرْسَلَ يَهُوذا صَدِيقَهُ حِيرَةَ مَعَ الجَدْيِ لِيَسْتَرِدَّ الرَّهْنَ مِنَ المَرأةِ. لَكِنَّ حِيرَةَ لَمْ يَجِدْها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","وَسَألَ حِيرَةُ أهلَ تِلْكَ المِنطَقَةِ: «أينَ عاهِرَةُ الهَيكَلِ الَّتِي كانَتْ عِنْدَ عَينايِمَ عَلَى جانِبِ الطَّرِيقِ؟» فَقالُوا: «لَمْ تَكُنْ هُنا أيَّةُ عاهِرَةِ هَيكَلٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","فَعادَ حِيرَةُ إلَى يَهُوذا، وَقالَ: «لَمْ أجِدْها. وَقالَ لِي أهلُ المَكانِ: ‹لَمْ تَكُنْ هُنا أيَّةُ عاهِرَةِ هَيكَلٍ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","فَقالَ يَهُوذا: «فَلتَحتَفِظْ بِالرَّهْنِ، وَإلّا صِرْنا أُضْحُوكَةً. ها قَدْ أرْسَلْتُ الجَدْيَ بِالفِعلِ، لَكِنَّكَ لَمْ تَجِدْها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","وَبَعْدَ ثَلاثَةِ أشْهُرٍ، قالَ أحَدُهُمْ لِيَهُوذا: «لَقَدْ زَنَتْ كِنَّتُكَ ثامارُ.» فَقالَ يَهُوذا: «أخرِجُوها، وَلْتُحْرَقْ حَتَّى المَوْتِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","وَأثْناءَ إخراجِها، أرْسَلَتْ رِسالَةً إلَى حَمِيها يَهُوذا تَقُولُ: «لَقَدْ حَبِلْتُ مِنَ صاحِبِ هَذِهِ الأشْياءِ.» وَقالَتِ: «انظُرْ إلَيها! فَلِمَنْ هَذا الخاتِمُ وَالخَيطُ وَالعَصا؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","فَمَيَّزَ يَهُوذا أشْياءَهُ. وَقالَ: «إنَّها أفْضَلُ مِنِّي، لِأنِّي لَمْ أُزَوِّجْها مِنَ ابْنِي شِيلَةَ.» وَلَمْ يُعاشِرْها يَهُوذا مَرَّةً أُخْرَى. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","وَلَمّا حانَ وَقْتُ وِلادَتِها، كانَ فِي بَطنِها تَوْأمانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","وَعِندَما وَلَدَتْ، أخرَجَ أحَدُهُما يَدَهُ، فَأخَذَتِ القابِلَةُ خَيطاً قُرْمُزِيّاً وَرَبَطَتْهُ عَلَى يَدِهِ. وَقالَتْ: «خَرَجَ هَذا أوَّلاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","وَلَكِنْ حالَما سَحَبَ يَدَهُ، خَرَجَ أخُوهُ. فَقالَتِ القابِلَةُ: «يا لَهَذا الاختِراقُ الَّذِي اختَرَقْتَهُ لِنَفْسِكَ!» فَسُمِّيَ فارَصَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ثُمَّ خَرَجَ أخُوهُ بَعْدَهُ. وَكانَ الخَيطُ القُرْمُزِيُّ عَلَى يَدِهِ. فَسُمِّيَ زارَحُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","أمّا يُوسُفُ فَأُخِذَ إلَى مِصْرَ. وَاشْتَراهُ مَسْؤُولٌ عِندَ فِرعَوْنِ مِصْرَ، رَئِيسٌ لِحَرَسِ القَصْرِ، وَهُوَ مِصْرِيٌّ. اشْتَراهُ مِنَ الإسْماعِيلِيِّينَ الَّذِينَ جَلَبُوهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","فَكانَ اللهُ مَعَ يُوسُفَ، فَكانَ رَجُلاً ناجِحاً. وَسَكَنَ فِي بَيتِ سَيِّدِهِ المِصْرِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","وَرَأى سَيِّدُهُ أنَّ اللهَ مَعَهُ. وَأنَّ اللهَ يُوَفِّقُ كُلَّ عَمَلِ يَدَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","فَحَظِيَ يُوسُفُ بِرِضاهُ، وَخَدَمَهُ بِأمانَةٍ. فَجَعَلَهُ مُشْرِفاً عَلَى بيتِهِ، وَمَسؤولاً عَنْ جَمِيعِ شُؤونِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","وَبارَكَ اللهُ بَيتَ المِصْرِيِّ بِسَبَبِ يُوسُفَ مُنذُ الوَقْتِ الَّذِي أوكَلَهُ عَلَى بَيتِهِ وَكُلِّ ما عِندَهُ. وَظَهَرَتْ بَرَكَةُ اللهِ فِي كُلِّ أملاكِ فُوطِيفارَ، فِي البَيتِ وَفِي الحَقلٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","فَتَرَكَ فُوطِيفارُ كُلَّ شَيءٍ تَحتَ رِعايَةِ يُوسُفَ. وَفِي وُجُودِ يُوسُفَ، لَمْ يَكُنْ فُوطِيفارُ يَهْتَمُّ بِأيِّ شَيءٍ، ما عَدا الطَّعامِ الَّذِي يَأكُلُهُ. وَكانَ يُوسُفُ جَمِيلَ القِوامِ وَالوَجهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","وَفِي وَقتٍ لاحِقٍ، بَدَأتْ زَوجَةُ سَيِّدِهِ تَشْتَهِيهِ. وَقالَتْ لَهُ: «تَعالَ وَعَاشِرْنِي!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","فَرَفَضَ. وَقالَ لِزَوجَةِ سَيِّدِهِ: «ها إنَّ سَيِّدِي فِي وُجُودِي غَيرُ قَلِقٍ عَلَى شَيءٍ فِي البَيتِ. وَقَدْ وَضَعَ بَينَ يَدَيَّ كُلَّ ما لَدَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","فَلا يُوجَدُ فِي هَذا البَيتِ مَنْ هُوَ أهَمُّ مِنِّي. وَلَمْ يَمنَعْ عَنِّي سَيِّدِي شَيئاً إلّا أنتِ لِأنَّكِ زَوجَتُهُ. فَكَيفَ أقتَرِفُ مِثلَ هَذا الإثْمِ العَظِيمِ وَأُخطِئُ إلَى اللهِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","فَكانَتْ تُكَلِّمُهُ يَوماً بَعدَ يَوْمٍ، وَهُوَ يَرفُضُ أنْ يُعَاشِرَها أوْ يَكُونَ مَعَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","وَذاتَ يَومٍ جاءَ يُوسُفُ إلَى البَيتِ لِيَقُومَ بِعَمَلِهِ. وَلَمْ يَكُنْ أحَدٌ مِنَ الخَدَمِ داخِلَ المَنزِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","فَأمسَكَتْهُ مِنْ ثَوْبِهِ وَقالَتْ: «تَعالَ وَعَاشِرْنِي!» فَتَرَكَ ثَوْبَهُ فِي يَدِها وَهَرَبَ خَارِجاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","فَلَمّا رَأتْ أنَّهُ تَرَكَ ثَوْبَهُ فِي يَدِها وَهَرَبَ خارِجاً، ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","نادَتْ خَدَمَ بَيتِها وَقالَتْ لَهُمْ: «انظُرُوا! ها قَدْ وَضَعَ زَوجِي بَينَنا رَجُلاً عِبْرانِيّاً لِيُهِينَنا. جاءَ إلَيَّ وَحاوَلَ أنْ يُعاشِرَنِي، فَصَرَخْتُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","فَلَمّا سَمِعَنِي أرفَعُ صَوْتِي وَأصْرُخُ، تَرَكَ ثَوبَهُ بِجانِبِي، وَهَرَبَ خارِجاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","وَاحتَفَظَتْ بِثَوْبِهِ بِجانِبِها إلَى أنْ جاءَ سَيِّدُهُ إلَى البَيتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ثُمَّ قَصَّتِ عَلَيهِ قِصَّتَها: «جاءَ إلَيَّ الخادِمُ العِبْرانِيُّ الَّذِي وَضَعْتَهُ بَينَنا لِكَي يُهِينَنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","لَكِنِّي رَفَعْتُ صَوْتِي وَصَرَخْتُ. فَتَرَكَ ثَوْبَهُ بِجانِبِي وَهَرَبَ خارِجاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","سَمِعَ سَيِّدُهُ رِوايَةَ زَوْجَتِهِ الَّتِي قالَتْ لَهُ: «هَذا هُوَ ما فَعَلَهُ خادِمُكَ بِي،» فَغَضِبَ غَضَباً شَدِيداً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","وَألقَى القَبْضَ عَلَى يُوسُفَ وَوَضَعَهُ فِي السِّجْنِ، حَيثُ كانَ يُعتَقَلُ سُجَناءُ فِرعَوْنَ. فَبَقِيَ يُوسُفُ هُناكَ فِي السِّجْنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","لَكِنَّ اللهَ كانَ مَعَ يُوسُفَ، وَأظهَرَ لَهُ لُطفاً. وَجَعَلَ يُوسُفَ يَحظَى بِرِضَى حارِسِ السِّجْنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","فَأوكَلَ حارِسُ السِّجْنِ يُوسُفَ عَلَى كُلِّ الرِّجالِ الآخَرِينَ المَوضُوعِينَ فِي السِّجْنِ. وَكانَ مُشْرِفاً عَلَى كُلِّ العَمَلِ الجارِي هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","وَكانَ حارِسُ السِّجْنِ مُرْتاحَ البالِ مِنْ جِهَةِ أيِّ أمْرٍ تَحتَ مَسْؤُولِيَّةِ يُوسُفَ. لِأنَّ اللهَ كانَ مَعَهُ. وَكانَ اللهُ يُنْجِحُ كُلَّ ما يَعْمَلُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","وَبَعْدَ هَذا أساءَ ساقِي فِرعَوْنَ وَالخَبّازُ إلَى سَيِّدِهِما، فِرعَوْنِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","فَغَضِبَ فِرعَوْنُ مِنْ رَئِيسِ سُقاتِهِ وَرَئِيسِ خَبّازِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","فَحَبَسَهُما فِرعَوْنُ فِي سِجنِ رَئِيسِ الحَرَسِ حَيثُ كانَ يُوسُفُ مَحبُوساً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","وَجَعَلَ رَئِيسُ الحَرَسِ يُوسُفَ مُشْرِفاً عَلَيهِما، فَخَدَمَهُما. وَبَقِيا فِي السِّجْنِ مُدَّةً مِنَ الزَّمَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","وَفِي إحْدَى اللَّيالِي رَأى ساقِي فِرعَوْنَ وَخَبّازُهُ المَحبُوسانِ فِي السِّجْنِ حُلْمَينِ مَعاً. وَكانَ لِكُلٍّ مِنْهُما حُلْمُهُ. وَكانَ لِكُلِّ حُلْمٍ مَعْناهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","أتَى إلَيهِما يُوسُفُ فِي الصَّباحِ. وَرَأى أنَّهُما كانا مُنزَعِجَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","فَسَألَ يُوسُفُ مَوَظَّفَي فِرعَوْنَ اللَّذَينِ كانا مَحبُوسَينِ مَعَهُ فِي بَيتِ سَيِّدِهِ: «لِماذا أرَى الحُزْنَ عَلَى وَجهَيكُما؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","فَقالا: «رَأينا حُلْمَينِ. لَكِنْ لا يُوجَدُ مَنْ يَقدِرُ أنْ يُفَسِّرَهُما لَنا.» فَقالَ يُوسُفُ لَهُما: «وَهَلْ يُفَسِّرُ الأحلامَ غَيرُ اللهِ؟ فَأخبِرانِي بِحُلْمَيكُما.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","فَقَصَّ ساقِي فِرعَوْنَ عَلَى يُوسُفَ حُلْمَهُ وَقالَ: «رَأيتُ فِي الحُلْمِ كَرْمَةً، ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","وَرَأيتُ عَلَى الكَرْمَةِ ثَلاثَةَ أغصانٍ. وَما إنْ أوْرَقَتِ الكَرْمَةُ، حَتَّى ظَهَرَتْ بَراعِمُها وَنَضِجَتْ عَناقِيدُها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","وَكانَتْ كَأْسُ فِرعَوْنَ فِي يَدِي. فَأخَذْتُ العِنَبَ وَعَصَرْتُهُ فِي كَأْسِ فِرعَوْنَ، وَوَضَعْتُ الكَأْسَ فِي يَدِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","فَقالَ لَهُ يُوسُفُ: «مَعْنَى حُلْمِكَ هُوَ أنَّ الأغصانَ الثَّلاثَةَ هِيَ ثَلاثَةُ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","فَخِلالَ ثَلاثَةِ أيّامٍ يَرْفَعُ المَلِكُ رَأسَكَ، وَيُعِيدُكَ إلَى وَظِيفَتِكَ. وَسَتُقَدِّمُ لِفِرْعَوْنَ كَأْسَهُ كَما كُنْتَ تَفْعَلُ مِنْ قَبلُ عِنْدَما كُنْتَ ساقِياً لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","لَكِنْ أرجُو أنْ تَتَذَكَّرَنِي عِندَما يُطلِقُ سَراحَكَ. وَاصْنَعْ مَعِي مَعرُوفاً بِأنْ تَذْكُرَنِي لِفِرْعَوْنَ، وَتُخرِجَنِي مِنْ هَذا السِّجْنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","فَقَدِ اختُطِفْتُ مِنْ أرْضِ العِبْرانِيِّينَ. وَأنا لَمْ أرتَكِبْ هُنا جُرْماً يَسْتَوجِبُ السِّجْنَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","فَلَمّا أعجَبَ التَّفْسِيرُ رَئِيسَ الخَبّازِينَ، قالَ لِيُوسُفَ: «أنا أيضاً رَأيتُ حُلْماً: كانَتْ هُناكَ ثَلاثُ سِلالٍ مِنَ الخُبْزِ الأبْيَضِ عَلَى رَأْسِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","وَكانَ فِي السَّلَّةِ العُلْيا كُلُّ أنْواعِ الأطعِمَةِ المَخبُوزَةِ لِفِرْعَوْنَ. لَكِنَّ طُيُوراً كانَتْ تَأْكُلُها مِنَ السَّلَّةِ الَّتِي فَوْقَ رَأْسِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","فَأجابَ يُوسُفُ: «مَعْنَى حُلْمِكَ هُوَ أنَّ السِّلالَ الثَّلاثَ هِيَ ثَلاثَةُ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","فَخِلالَ ثَلاثَةِ أيّامٍ سَيَرفَعُ فِرعَوْنُ رَأْسَكَ عَنْ جَسَدِكَ، وَسَيُعَلِّقُكَ عَلَى عَمُودٍ، فَتَأْكُلَ الطُّيُورُ لَحمَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","وَبَعدَ ثَلاثَةِ أيّامٍ كانَ عِيدُ مِيلادِ فِرعَوْنَ. فَأقامَ وَلِيمَةً لِكُلِّ مَسْؤُولِيهِ. وَأطلَقَ رَئِيسَ السُّقاةِ وَرَئِيسَ الخَبّازِينَ مِنَ السِّجْنِ فِي حُضُورِ مَسْؤُولِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","وَأعادَ لِرَئِيسِ السُّقاةِ وَظِيفَتَهُ، فَوَضَعَ الكَأسَ فِي يَدِ فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","لَكِنَّهُ قَطَعَ رَأسَ رَئِيسَ الخَبّازِينَ وَعَلَّقَ جَسَدَهُ، تَماماً كَما فَسَّرَ يُوسُفُ الحُلْمَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","غَيرَ أنَّ رَئِيسَ السُّقاةِ لَمْ يَتَذَكَّرْ يُوسُفَ، بَلْ نَسِيَهُ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","وَبَعْدَ سَنَتَينِ رَأى فِرعَوْنُ حُلْماً: كانَ واقِفاً عِندَ نَهْرِ النِّيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","وَرَأى سَبْعَ بَقَراتٍ خارِجاتٍ مِنَ النَّهْرِ. وَكانَتِ البَقَراتُ صَحِيحَةً وَسَمِينَةً. فَرَعَتْ وَأكَلَتْ بَينَ القَصَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ثُمَّ خَرَجَتْ سَبْعُ بَقَراتٍ أُخْرَى مِنْ نَهْرِ النِّيلِ، فَكانَتْ هَزِيلَةً وَبَدَتْ مَرِيضَةً. وَوَقَفَتْ إلَى جانِبِ البَقَراتِ الأُولَى عَلَى ضِفَّةِ النَّهْرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","فَأكَلَتِ البَقَراتُ الهَزِيلَةُ البَقَراتِ الصَّحِيحَةَ السَّمِينَةِ السَّبْعِ. ثُمَّ أفاقَ فِرعَوْنُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ثُمَّ عادَ إلَى النَّوْمِ مَرَّةً أُخْرَى. وَرَأى حُلْماً آخَرَ. رَأى سَبْعَ سَنابِلَ مِنَ القَمْحِ مَلِيئَةٍ وَجَيِّدَةٍ تَنمُو عَلَى ساقٍ واحِدَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ثُمَّ نَبَتَتْ بَعدَها سَبْعُ سَنابِلَ رَفِيعَةٍ وَمَلْفُوحَةٍ بِالرِّيحِ الشَّرْقِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","وَابْتَلَعَتِ السَّنابِلُ الرَّفِيعَةُ السَّنابِلَ المَلِيئَةَ الجَيِّدَةَ. ثُمَّ أفاقَ فِرعَوْنُ، وَإذا هُوَ حُلْمٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","وَفِي الصَّباحِ كانَ فِرعَوْنُ مُنزَعِجَ البالِ. فَأرْسَلَ وَاسْتَدعَى كُلَّ سَحَرَةِ مِصْرَ وَكُلَّ حُكَمائِها. وَأخبَرَهُمْ بِالحُلْمَينِ اللَّذَينِ رَآهُما. لَكِنْ لَمْ يَجِدْ مَنْ يُفَسِّرُهُما لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","لَكِنَّ رَئِيسَ السُّقاةِ كَلَّمَ فِرعَوْنَ بَعدَ ذَلِكَ وَقالَ: «أتَذَكَّرُ اليَوْمَ أخطائِي، ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","وَأتَذَكَّرُ ما حَدَثَ عِندَما غَضِبَ سَيِّدِي فِرعَوْنَ مِنْ خادِمِهِ وَوَضَعَنِي فِي الحَبْسِ، فِي بَيتِ رَئِيسِ الحَرَسِ، أنا وَرَئِيسَ الخَبّازِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","فَفِي تِلْكَ اللَّيلَةِ رَأينا نَحْنُ الاثْنَينِ حُلْمَينِ. وَكانَ لِكُلِّ حُلُمٍ مِنها مَعناهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","وَكانَ مَعَنا شابٌّ عِبْرانِيٌّ، يَعْمَلُ لَدَى رَئِيسِ الحَرَسِ. فَأخبَرْناهُ بِحُلْمَينا، فَفَسَّرَهُما. فَسَّرَ لِكُلِّ واحِدٍ مِنّا مَعْنَى حُلُمِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","وَقَدْ حَدَثَ مَعَنا تَماماً كَما فَسَّرَ لَنا: أنا أُعِدْتُ إلَى وَظِيفَتِي، أمّا الخَبّازُ فَقُطِعَتْ رَأسُهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","فَاسْتَدْعَى فِرعَوْنُ يُوسُفَ، فَأحضَرُوهُ مِنَ السِّجْنِ سَريعاً، وَحَلَقُوا لَهُ، وَبَدَّلُوا ثِيابَهُ، وَأحضَرُوهُ إلَى فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","فَقالَ فِرعَوْنُ لِيُوسُفَ: «رَأيتُ حُلْماً، لَكِنْ لَيسَ مَنْ يَسْتَطِيعُ تَفْسِيرَهُ لِي. غَيرَ أنِّي سَمِعْتُ أنَّكَ تَسْمَعُ الأحلامَ فَتُفَسِّرَها عَلَى الفَورِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","فَقالَ يُوسُفُ: «اللهُ، لا أنا، هُوَ الَّذِي سَيُعطِي فِرعَوْنَ جَواباً شافِياً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","فَقالَ فِرعَوْنُ لِيُوسُفَ: «كُنْتُ فِي حُلْمِي واقِفاً عَلَى ضِفَّةِ نَهْرِ النِّيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","وَفَجأةً خَرَجَتْ سَبْعُ بَقَراتٍ سَميناتٍ وَصَحِيحاتٍ مِنَ النِّيلِ. وَراحَتْ تَرْعَى فِي مَرعَى القَصَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ثُمَّ ظَهَرَتْ سَبْعُ بَقَراتٍ أُخْرَى بَعدَها، كانَتْ ضَعِيفَةً وَرَفِيعَةً. لَمْ أرَ قَطُّ بَقَراتٍ أكْثَرَ قُبْحاً مِنْها فِي أرْضِ مِصْرَ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","فَالتَهَمَتِ البَقَراتُ الهزِيلاتُ القَبِيحَاتُ البَقَراتِ السَّبْعَ السَّمِينَاتِ الَّتِي رَأيتُها أوَّلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","وَبَعدَ أنْ أكَلَتْها، لَمْ يَظهَرْ عَلَيها ما يُشِيرُ إلَى أنَّها أكَلَتْها، بَلْ بَقِيَتْ قَبِيحَةً كَما كانَتْ فِي البِدايَةِ. ثُمَّ اسْتَيقَظْتُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","«ثُمَّ رَأيتُ فِي حُلْمٍ آخَرَ سَبْعَ سَنابِلَ مِنَ القَمْحِ تَنمُو عَلَى ساقٍ واحِدَةٍ. وَكانَتْ مَلِيئَةً وَجَيِّدَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ثُمَّ نَبَتَتْ بَعدَها سَبْعُ سَنابِلَ أُخْرَى ذاوِيَةٍ وَرَفِيعَةٍ كأنَّ ريحاً شَرقِيَّةً قَدْ لَفَحَتْها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ثُمَّ ابتَلَعَتِ السَّنابِلُ السَّبْعُ الرَّفِيعَةُ السَّنابِلَ السَّبْعَ الجَيِّدَةَ. وَقَدْ أخبَرْتُ سَحَرَتِي بِحُلْمَيَّ، فَلَمْ يَسْتَطِعْ أحَدٌ مِنْهُمْ أنْ يُخبِرَنِي بِمَعْناهِما.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","فَقالَ يُوسُفُ لِفِرْعَوْنَ: «إنَّ الحُلْمَينِ اللَّذينِ رَآهُما فِرعَوْنُ هُما صُورَتانِ لِحُلْمٍ واحِدٍ، وَلَهُما مَعنَىً واحِدٌ. فَقَدْ أعلَنَ اللهُ لِفِرْعَوْنَ ما سَيَفْعَلُهُ قَرِيباً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","فَالبَقَراتُ السَّبْعُ الجَيِّدَةُ هِيَ سَبْعُ سَنَواتٍ. وَالسَّنابِلُ السَّبْعُ الجَيِّدَةُ هِيَ سَبْعُ سَنَواتٍ. فَلِلحُلْمَينِ مَعنَىً واحِدٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","وَالبَقَراتُ السَّبْعُ القَبِيحَةُ الَّتِي خَرَجَتْ بَعدَها هِيَ سَبْعُ سَنَواتٍ. وَالسَّنابِلُ السَّبْعُ الرَّفِيعَةُ المَلْفُوحَةُ بِالرِّيحِ الشَّرْقِيَّةِ هِيَ سَبْعُ سَنَواتٍ مِنَ الجُوعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","هَذِهِ هِيَ الرِّسالَةُ الَّتِي نَقَلْتُها إلَيكَ: لَقَدْ أعلَنَ اللهُ لِفِرْعَوْنَ ما سَيَفْعَلُهُ قَرِيباً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","فَها تَأْتِي سَبْعُ سَنَواتٍ يَكُونُ فِيها طَعامٌ وَفِيرٌ فِي أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ثُمَّ تَأْتِي بَعْدَها سَبْعُ سَنَواتٍ مِنَ المَجاعَةِ. وَسَيَنْسَى النّاسُ كُلَّ وَفْرَةِ الطَّعامِ فِي أرْضِ مِصْرَ. وَسَيَقْضِي الجُوعُ عَلَى البِلادِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","وَسَيُنْسَى زَمَنُ الوَفْرَةِ بِسَبَبِ المَجاعَةِ الَّتِي تَلِيهِ، لِأنَّها سَتَكُونُ قاسِيَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","«وَأمّا القَصْدُ مِنْ تِكْرارِ حُلْمِ فِرعَوْنَ مَرَّتَينِ فَهُوَ هَذا: لَقَدْ قَضَى اللهُ بِهَذا الأمْرِ، وَهُوَ سَيُعَجِّلُ بِحُدُوثِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","وَالآنَ لِيَبْحَثْ فِرعَوْنُ عَنْ رَجُلٍ ذَكِيٍّ وَحَكِيمٍ وَلْيَجعَلْهُ مُشْرِفاً عَلَى أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","وَلْيُعَيِّنْ فِرعَوْنُ مُشْرِفِينَ عَلَى الأرْضِ. وَلْيَأْخُذُوا خُمْسَ مَحْصُولِ الأرْضِ فِي سَنَواتِ الوَفْرَةِ السَّبْعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","وَلْيَجمَعُوا كُلَّ طَعامِ هَذِهِ السَّنَواتِ الخَيِّرَةِ القادِمَةِ، وَيُخَزِّنُوا القَمْحَ تَحتَ سُلْطَةِ المَلِكِ وَيَحرُسُوهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","وَلْيَكُنْ هَذا الطَّعامُ ذَخِيرَةً لِلبِلادِ طَوالَ سَنَواتِ المَجاعَةِ السَّبْعِ الَّتِي سَتَأْتِي عَلَى أرْضِ مِصْرَ. حِينَئِذٍ، لَنْ تَقضِيَ المَجاعَةُ عَلَى البِلادِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","فَوافَقَ فِرعَوْنُ وَكُلُّ وُزَرائِهِ عَلَى اقْتِراحِ يُوسُفَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ثُمَّ قالَ فِرعَوْنُ لِوُزَرائِهِ: «أينَ لَنا أنْ نَجِدَ رَجُلاً كَهَذا فِيهِ رُوحُ اللهِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","فَقالَ فِرعَوْنُ لِيُوسُفَ: «بِما أنَّ اللهَ بَيَّنَ لَكَ كُلَّ هَذا، فَإنَّهُ لا يُوجَدُ مَنْ هُوَ بِذَكائِكَ وَحِكْمَتِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","لِهَذا سَتَكُونُ أنتَ مُشْرِفاً عَلَى كُلِّ بَيتِي. وَكُلُّ شَعبِي سَيُطِيعُونَ أمْرَكَ. وَلا يَعلُو عَلَيكَ أحَدٌ غَيرِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ثُمَّ قالَ فِرعَوْنُ لِيُوسُفَ: «ها قَدْ جَعَلْتُكَ مَسْؤُولاً عَنْ كُلِّ أرْضِ مِصْرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","وَخَلَعَ فِرعَوْنُ خاتَمَ النَّقْشِ مِنْ يَدِهِ وَأعْطاهُ لِيُوسُفَ. وَألْبَسَهُ ثِياباً كِتّانِيَّةً مُمتازَةً. وَوَضَعَ قِلادَةً كَبِيرَةً مِنَ الذَّهَبِ حَولَ رَقَبَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ثُمَّ أرْكَبَهُ فِي عَرَبَتِهِ المَلَكِيَّةِ الثّانِيَةِ. وَصاحَ الجُنُودُ أمامَهُ: «أفْسِحُوا الطَّرِيقَ.» وَجَعَلَهُ مَسْؤُولاً عَنْ كُلِّ أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","وَقالَ فِرعَوْنُ لِيُوسُفَ: «أنا فِرعَوْنَ أمَرْتُ بِألّا يَفْعَلَ أحَدٌ فِي مِصْرَ شَيئاً دُونَ إذْنِكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","وَأطلَقَ فِرعَوْنُ عَلَيهِ اسْمَ صَفْناتَ فَعْنِيحَ، وَزَوَّجَهُ أسْناتَ ابْنَةَ فُوطِي فارَعَ كاهِنِ مَدِينَةِ أُونَ. فَصارَ يُوسُفُ مَسْؤُولاً عَنْ أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","وَكانَ يُوسُفُ فِي الثَّلاثِينَ مِنْ عُمْرِهِ عِندَما بَدَأ يَخدِمُ فِرعَوْنَ، مَلِكَ مِصْرَ. خَرَجَ يُوسُفُ مِنْ عِندِ فِرعَوْنَ، وَسافَرَ فِي كُلِّ أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","وَأنتَجَتِ الأرْضُ غَلَّةً وَفِيرَةً أثْناءَ سَنَواتِ الخَيرِ السَّبْعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","فَجَمَعَ كُلَّ طَعامِ السَّنَواتِ السَّبْعِ فِي فَتْرَةِ الوَفْرَةِ فِي أرْضِ مِصْرَ. وَقامَ بِخَزْنِ الطَّعامِ فِي المُدُنِ. خَزَنَ يُوسُفُ فِي كُلِّ مَدِينَةٍ الطَّعامَ المَأخُوذَ مِنَ الحُقُولِ الَّتِي حَولَها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","فَخَزَنَ يُوسُفُ قَمْحاً كَثِيراً مِثلَ رَملِ شَواطِئِ البَحْرِ. كانَ القَمْحُ وَفِيراً جِدّاً حَتَّى إنَّهُ تَوَقَّفَ عَنْ حِسابِ كَمِّياتِهِ، لِأنَّهُ لَمْ يَعُدْ مُمكِناً أنْ تُحسَبَ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","وَقَبلَ أنْ تَأْتِيَ سَنَواتُ المَجاعَةِ، رُزِقَ يُوسُفُ بِوَلَدَينِ. وَلَدَتْهُما لَهُ زَوجَتُهُ أسْناتُ، ابْنَةُ فُوطِي فارَعَ كاهِنِ مَدِينَةِ أُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","وَسَمَّى يُوسُفُ بِكْرَهُ مَنَسَّى. إذْ قالَ يُوسُفُ: «لَقَدْ أنسانِي اللهُ كُلَّ ضِيقِي هُنا وَكُلَّ بَيتِ أبِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","وَسَمَّى ابْنَهُ الثّانِيَ أفْرايِمَ. فَقَدْ قالَ: «أعطانِي اللهُ أبْناءً فِي أرْضِ ضِيقاتِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ثُمَّ انتَهَتْ سَنَواتُ الوَفْرَةِ السَّبعُ فِي أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","وَبَدَأتْ سَنَواتُ المَجاعَةِ، تَماماً كَما قالَ يُوسُفُ. كانَتِ المَجاعَةُ فِي كُلِّ الأقْطارِ. أمّا فِي أرْضِ مِصْرَ فَكانَ هُناكَ طَعامٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","وَصارَ الطَّعامُ شَحيحاً فِي أرْضِ مِصْرَ كُلِّها. وَبَدَأ النَّاسُ يَصْرُخُونَ لِفِرْعَوْنَ طالِبِينَ طَعاماً. فَكانَ فِرعَوْنُ يَقُولُ لَهُمْ: «اذْهَبُوا إلَى يُوسُفَ. وَافعَلُوا ما يَقُولُهُ لَكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","وَلَمّا سَادَتِ المَجاعَةُ فِي مِصْرَ كُلِّها، فَتَحَ يُوسُفُ مَخازِنَ القَمْحِ. وَباعَ القَمْحَ لِلمِصْرِيِّينَ. إذْ كانَتِ المَجاعَةُ قاسِيَةً فِي أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","وَجاءَ النّاسُ مِنْ جَمِيعِ أطْرافِ الأرْضِ إلَى يُوسُفَ فِي مِصْرَ لِيَشْتَرُوا قَمْحاً. فَقَدْ كانَتِ المَجاعَةُ قاسِيَةً فِي كُلِّ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","وَعَلِمَ يَعقُوبُ أنَّ فِي مِصْرَ قَمْحاً، فَقالَ لِأولادِهِ: «لِماذا يَنظُرُ بَعْضُكُمْ إلَى بَعضٍ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","وَقالَ: «قَدْ سَمِعْتُ أنَّ فِي مِصْرَ قَمحاً، فانْزِلُوا إلَى هُناكَ وَاشْتَرُوا لَنا قَمحاً، فَنَحيا وَلا نَمُوتُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","فَنَزَلَ إخْوَةُ يُوسُفَ العَشْرَةُ إلَى مِصْرَ لِيَشْتَرُوا قَمْحاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","لَكِنَّ يَعقُوبَ لَمْ يُرْسِلْ بَنْيامِيْنَ شَقِيقَ يُوسُفَ مَعَ بَقِيَّةِ إخْوَتِهِ. إذْ خَشِيَ أنْ يُصِيبَهُ أذَىً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","فَذَهَبَ أولادُ إسْرائِيلَ مَعَ كَثِيرِينَ إلَى مِصْرَ لِشِراءِ القَمحِ، لِأنَّ المَجاعَةَ وَصَلَتْ إلَى أرْضِ كَنْعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","وَكانَ يُوسُفُ حاكِماً عَلَى أرْضِ مِصْرَ كُلِّها. وَكانَ هُوَ الَّذِي يَتَوَلَّى عَمَلِيَّةَ بَيعِ القَمْحِ لِكُلِّ أهلِ الأرْضِ. فَجاءَ إخْوَةُ يُوسُفَ وَانحَنُوا أمامَهُ وَوُجُوهُهُمْ إلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","فَلَمّا رَأى يُوسُفُ إخْوَتَهُ، عَرَفَهُمْ، لَكِنَّهُ تَظاهَرَ بِأنَّهُ لَمْ يَعْرِفْهُمْ. وَتَكَلَّمَ مَعْهُمْ بِفَظاظَةٍ وَقالَ لَهُمْ: «مِنْ أينَ جِئْتُمْ؟» فَقالُوا: «جِئْنا مِنْ أرْضِ كَنْعانَ لِنَشْتَرِيَ طَعاماً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","فَمَيَّزَ يُوسُفُ إخْوَتَهُ. أمّا هُمْ فَلَمْ يُمَيِّزُوهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","وَتَذَكَّرَ يُوسُفُ أيضاً الأحلامَ الَّتِي رَآها عَنْهُمْ. فَقالَ لَهُمْ: «ما أنتُمْ إلّا جَواسِيسُ، جِئْتُمْ لِتَكْتَشِفوا نِقاطَ ضَعْفِ أرْضِنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","فَقالُوا لَهُ: «لا يا سَيِّدِي! نَحنُ خُدّامَكَ جِئْنا لِنَشْتَرِيَ طَعاماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","وَكُلُّنا أبْناءُ رَجُلٍ واحِدٍ. وَنَحنُ رِجالٌ صادِقُونَ. نَحنُ خُدّامَكَ لَسْنا جَواسِيسَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","لَكِنَّهُ قالَ: «بَلْ جِئْتُمْ لِتَعرِفُوا نِقاطَ ضَعْفِنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","فَقالُوا: «نَحْنُ، خُدّامَكَ، اثْنا عَشَرَ أخاً، أبْناءُ رَجُلٍ واحِدٍ فِي كَنْعانَ. وَأصْغَرُنا عِنْدَ أبِينا الآنَ. وَواحِدٌ ماتَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","فَقالَ لَهُمْ يُوسُفُ: «كَما سَبَقَ أنْ قُلْتُ لَكُمْ. ما أنتُمْ إلّا جَواسِيسُ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","لَكِنِّي سَأمتَحِنُكُمْ بِهَذِهِ الطَّرِيقَةِ: أقْسِمُ بِحَياةِ فِرعَوْنَ أنَّكُمْ لَنْ تُغادِرُوا هَذا المَكانَ حَتَّى يَأْتِيَ أخُوكُمُ الأصْغَرُ إلَى هُنا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","فَأرْسِلُوا أحَدَكُمْ لِيَجلِبَ أخاكُمْ. وَسَتَظَلُّ بَقِيَّتُكُمْ حَتَّى ذَلِكَ الحِينِ فِي السِّجْنِ. وَبِهَذا أعرِفُ إنْ كُنتُمْ صادِقِينَ، وَإلّا، فَإنِّي أُقْسِمُ بِحَياةِ فِرعَوْنَ أنَّكُمْ حَقّاً جَواسِيسُ!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ثُمَّ وَضَعَهُمْ يُوسُفُ فِي السِّجْنِ ثَلاثَةَ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ثُمَّ قالَ لَهُمْ يُوسُفُ فِي اليَوْمِ الثّالِثِ: «افْعَلُوا ما أقُولُهُ لَكُمْ فَتَحْيُوا. فَأنا أخافُ اللهَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","إنْ كُنْتُمْ صادِقِينَ، فَلْيَبقَ أحَدُ إخْوَتِكُمْ فِي السِّجْنِ حَيثُ هُنا. وَأمّا أنتُمْ فَخُذُوا قَمْحاً يَسُدُّ جُوعَ بُيُوتِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ثُمَّ أحْضِرُوا لِي أخاكُمُ الأصْغَرَ فَيَثبُتَ صِدْقُ كَلامِكُمْ، فَلا أقتُلُكُمْ.» فَوافَقُوا عَلَى ذَلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","وَقالَ أحَدُهُمْ لِلآخَرِ: «لا شَكَّ فِي أنَّ اللهَ يُعاقِبُنا بِسَبَبِ ما فَعَلْناهُ بِأخِينا. فَقَدْ رَأينا ضِيقَتَهُ عِندَما تَوَسَّلَ إلَينا أنْ نَرحَمَهُ. لَكِنَّنا لَمْ نُصْغِ إلَيهِ. لِهَذا جاءَتْ عَلَينا هَذِهِ الضِّيقَةُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","فَقالَ لَهُمْ رَأُوبَيْنُ: «ألَمْ أقُلْ لَكُمْ لا تُؤْذُوا الفَتَى! لَكِنَّكُمْ لَمْ تُصْغُوا إلَيَّ. وَها نَحْنُ سَنَدْفَعُ ثَمَنَ دَمِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","وَلَمْ يَعرِفُوا أنَّ يُوسُفَ كانَ يَفْهَمُ ما يَقُولُونَ، لِأنَّهُ كانَ هُناكَ مُتَرْجِمٌ بَينَهُمْ وَبَينَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ثُمَّ ابْتَعَدَ يُوسُفُ عَنهُمْ وَبَكَى. ثُمَّ عادَ إلَيْهِمْ وَكَلَّمَهُمْ. ثُمَّ أخَذَ شَمْعُونَ مِنْ بَينِهِمْ، وَأمَرَ بِأنْ يُوثَقَ أمامَ عُيُونِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ثُمَّ أمَرَ يُوسُفُ خُدّامَهُ بِأنْ يَملأُوا أكياسَ إخْوَتِهِ بِالقَمحِ. وَأمَرَهُمْ أيضاً أنْ يُعِيدُوا مالَ كُلِّ واحِدٍ مِنْهُمْ إلَى كِيسِهِ، وَأنْ يُعطُوهُمْ طَعاماً لِلرِّحلَةِ. فَفَعَلَ الخُدّامُ هَذا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","وَهَكَذا حَمَّلُوا قَمحَهُمْ عَلَى حَمِيرِهِمْ وَانطَلَقُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","وَعِندَما تَوَقَّفُوا لِيَبِيتُوا لَيلَتَهُمْ، فَتَحَ أحَدُهُمْ كِيسَ القَمحِ لِيُطعِمَ حِمارَهُ، فَرَأى مالَهُ فِي كِيسٍ فَوْقَ القَمحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","فَقالَ لإخوَتِهِ: «قَدْ رُدَّ مالِي إلَيَّ. وَها هُوَ فِي كِيسِي!» فَتَحَيَّرُوا كَثِيراً وَارتَعَدُوا خَوفاً وَقالُوا: «ما هَذا الَّذِي فَعَلَهُ اللهُ بِنا؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","وَلَمّا جاءُوا إلَى أبِيهِمْ يَعقُوبَ فِي أرْضِ كَنْعانَ، أخْبَرُوهُ بِكُلِّ ما حَدَثَ لَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","قالُوا: «كَلَّمَنا الرَّجُلُ الَّذِي يَحكُمُ فِي مِصْرَ بِفَظاظَةٍ، وَوَضَعَنا فِي السِّجنِ كَما لَوْ أنَّنا كُنّا نَتَجَسَّسُ عَلَى أرْضِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","فَقُلْنا لَهُ: ‹نَحنُ رِجالٌ صادِقُونَ. وَلَسْنا بِجَواسِيسَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","نَحنُ اثْنا عَشَرَ أخاً لأبينا. واحِدٌ ماتَ، وَالأصْغَرُ مَعَ أبِينا فِي أرْضِ كَنْعانَ.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","«فَقالَ لَنا الرَّجُلُ الَّذِي يَحكُمُ مِصْرَ: ‹بِهَذا أعلَمُ أنَّكُمْ صادِقُونَ. اتْرُكُوا أحَدَ إخْوَتِكُمْ عِنْدِي. وَخُذُوا قَمحاً يَسُدُّ جُوعَ بُيُوتِكُمْ وَامضُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ثُمَّ أحضِرُوا إلَيَّ أخاكُمُ الأصْغَرَ. حِينَئِذٍ، سَأتَأكَّدُ مِنْ أنَّكُمْ لَسْتُمْ جَواسِيسَ، بَلْ صادِقِينَ، وَسَأُطلِقُ سَراحَ أخِيكُمْ، وَسَأسْمَحُ لَكُمْ بِأنْ تُتاجِرُوا فِي أرْضِ مِصْرَ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","وَلَمّا أفرَغُوا أكياسَهُمْ، وَجَدَ كُلُّ واحِدٍ مِنْهُمْ صُرَّةَ مالِهِ فِي كِيسِهِ. وَلَمّا رَأَوْا وَأبوْهُمْ صُرَرَ مالِهِمْ خافُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","وَقالَ لَهُمْ أبوهُمْ يَعقُوبُ: «جَرَّدْتُمُونِي مِنْ أولادِي! فَقَدْتُ يُوسُفَ وَفَقَدْتُ شَمْعُونُ، وَها أنتُمْ تَأْخُذُونَ بَنْيامِيْنَ أيضاً. فَكَيفَ أحتَمِلُ هَذا كُلَّهُ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","فَقالَ رَأُوبَيْنُ لِأبِيهِ: «اقْتُلْ وَلَدَيَّ إذا لَمْ أُرجِعْ بَنْيامِيْنَ إلَيكَ. ضَعْهُ فِي عُهدَتِي، وَسَأُرجِعُهُ إلَيكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","لَكِنَّ يَعقُوبَ قالَ: «لَنْ يَنزِلَ ابْنِي مَعَكُمْ. فَشَقيقُهُ قَدْ ماتَ. وَهُوَ الوَحِيدُ الَّذِي تَبَقَّى لِي مِنْ زَوجَتِي راحِيلَ. فَإنْ أصابَهُ أذَىً فِي الطَّريقِ، سَأنْزِلُ إلَى الهاوِيَةِ عَجُوزاً حَزِيناً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","وَكانَتِ المَجاعَةُ قاسِيَةً فِي الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","فَلَمّا اسْتَهلَكُوا القَمْحَ الَّذِي اشْتَرُوهُ مِنْ مِصْرَ، قالَ لَهُمْ أبوْهُمْ: «عُودُوا وَاشْتَرُوا لَنا طَعاماً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","لَكِنَّ يَهُوذا قالَ لَهُ: «لَقَدْ حَذَّرَنا الحاكِمُ فَقالَ: ‹لَنْ تَرَوْا وَجهِي إلّا إذا كانَ أخُوكُمْ مَعَكُمْ.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","فَإنْ كُنْتَ سَتُرْسِلُ أخانا مَعَنا، فَإنَّنا سَنَنزِلُ وَنَشْتَرِي لَكَ طَعاماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","لَكِنْ إنْ كُنتَ لَنْ تُرْسِلَهُ مَعَنا، فَلَنْ نَنزِلَ. فَقَدْ قالَ لَنا الرَّجُلُ: ‹لَنْ تَرُوا وَجهِي إلّا إذا كانَ أخُوكُمْ مَعَكُمْ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","فَقالَ إسْرائِيلُ: «لِماذا أسَأْتُمْ إلَيَّ وَأخْبَرْتُمُ الرَّجُلَ أنَّ لَكُمْ أخاً آخَرَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","فَقالُوا: «دَقَّقَ الرَّجُلُ فِي التَّحقِيقِ مَعَنا، وَسَألَ عَنّا وَعَنْ عائِلَتِنا: ‹هَلْ مايَزالُ أبُوكُمْ حَيّاً؟ أعِندَكُمْ أخٌ آخَرُ؟› فَأجَبْناهُ. فَما الَّذِي أدْرانا بِأنَّهُ سَيَقُولُ لَنا: ‹أحضِرُوا أخاكُمْ›؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","وَقالَ يَهُوذا لِأبِيهِ إسْرائِيلَ: «أرْسِلِ الفَتَى مَعِي. وَاسْمَحْ لَنا أنْ نَنطَلِقَ فَوراً، لِكَي نَحيا وَلا نَمُوتَ، نَحْنُ وَأنتَ وَصِغارُنا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","وَأنا بِنَفْسِي أضْمَنُ سَلامَتَهُ. اعتَبِرْنِي مَسؤُولاً عَنْهُ. فَإذا لَمْ أُرجِعْهُ إلَيكَ وَأضَعْهُ أمامَكَ، حَمِّلْنِي ذَنبَ ذَلِكَ كُلَّ أيّامِ حَياتِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","لِأنَّكَ لَوْ لَمْ تُؤَخِّرْنا، لَكُنّا سافَرْنا وَرَجِعْنا مَرَّتَينِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","فَقالَ إسْرائِيلُ لَهُمُ: «إنْ كانَ لا بُدَّ أنْ يَكُونَ الأمْرُ كَذَلِكَ، فافْعَلُوا ما يَلِي: خُذُوا بَعضاً مِنْ أفضَلِ نِتاجِ الأرْضِ فِي أكياسِكُمْ، وَانزِلُوا بِها إلَى الرَّجُلِ هَدِيَّةً. خُذُوا بَعضَ البَلْسَمِ وَبَعْضَ العَسَلِ وَصَمْغِ القَتادِ وَالمُرِّ وَالفَسْتُقِ وَاللَّوْزِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","وَخُذُوا ضِعفَي المالِ مَعَكُمْ. وَأَرْجِعُوا المالَ الَّذِي أُعِيدَ إلَيكُمْ فِي أكياسِكُمْ. فَرُبَّما حَدَثَ هَذا بِالخَطَأِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","وَخُذُوا أخاكُمْ وَعُودُوا إلَى الرَّجُلِ فَوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","وَلْيُحَنِّنِ اللهُ الجَبّارُ هَذا الرَّجُلَ عَلَيكُمْ. وَلَيتَهُ يُعِيدُ مَعَكُمْ أخاكُمُ الآخَرَ وَبَنْيامِيْنَ. أمّا أنا، فَإذا حُرِمْتُ مِنْ أبْنائِي، فَإنِّي أقْبَلُ مَصِيرِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","فَأخَذَ الرِّجالُ هَذِهِ الهَدِيَّةَ. وَأخَذَوا أيضاً ضِعفَيِّ المالِ وَبَنْيامِيْنَ. وَانطَلَقُوا وَنَزَلُوا إلَى مِصْرَ. فَوَصَلُوا وَوَقَفُوا أمامَ يُوسُفَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","فَلَمّا رَأى يُوسُفُ بَنْيامِيْنَ مَعَهُمْ، قالَ لِمُدَبِّرِ بَيتِهِ: «أحضِرْ هَؤُلاءِ الرِّجالَ إلَى بَيتِي. وَاذْبَحْ ذَبيحَةً، وَجَهِّزْ مَأدُبَةً. إذْ سَيَأْكُلُ الرِّجالُ مَعِي عِندَ الظُّهْرِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","فَفَعَلَ الرَّجُلُ كَما أمَرَهُ يُوسُفَ. وَأحضَرَ الرِّجالَ إلَى بَيتِ يُوسُفَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","وَعِندَما أُحضِرَ الرِّجالُ إلَى بَيتِ يُوسُفَ خافُوا. وَقالُوا: «لَقَدْ جِيءَ بِنا إلَى هُنا بِسَبَبِ المالِ الَّذِي أُعِيدَ إلَينا فِي أكْياسِنا فِي المَرَّةِ الأُولَى. لا شَكَّ أنَّهُ يُرِيدُ أنْ يَهجُمَ عَلَينا وَيَقْبِضَ عَلَينا، وَيَجْعَلَنا عَبِيداً عِندَهُ وَيَأْخُذَ حَمِيرَنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","فَاقتَرَبُوا مِنَ الخادِمِ المَسْؤُولِ عَنْ بَيتِ يُوسُفَ وَكَلَّمُوهُ عِندَ بابِ البَيتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","قالُوا: «يا سَيِّدِي، نَزَلْنا أوَّلَ مَرَّةٍ لِنَشْتَرِيَ طَعاماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","لَكِنْ حِينَ وَصَلْنا إلَى مَكانِ مَبِيتِنا، فَتَحْنا أكياسَنا، وَوَجَدَ كُلُّ واحِدٍ مِنّا عَلَى رَأْسِ كِيسِهِ كامِلَ المَبلَغِ الَّذِي دَفَعَهُ. وَها نَحنُ قَدْ أرْجَعْنا المالَ مَعَنا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","وَأحضَرْنا مَعَنا أيضاً مالاً لِشِراءِ طَعامٍ. وَنَحنُ لا نَعرِفُ مَنْ وَضَعَ المالَ فِي أكياسِنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","فَقالَ الخادِمُ: «اطمَئِنُّوا، وَلا تَخافُوا. لا بُدَّ أنَّ إلَهَكُمْ، إلَهَ أبِيكُمْ، هُوَ الَّذِي وَضَعَ كَنزاً فِي أكياسِكُمْ. فَقَدِ اسْتَلَمْتُ أنا مالَكُمْ.» ثُمَّ أحضَرَ لَهُمْ شَمْعُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","وَبَعدَ هَذا دَخَلَ بِهِمِ الرَّجُلُ إلَى بَيتِ يُوسُفَ. وَقَدَّمَ لَهُمْ ماءً، فَغَسَلُوا أرجُلَهُمْ. ثُمَّ قَدَّمَ طَعاماً لِحَمِيرِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ثُمَّ أعَدُّوا الهَدِيَّةَ لِتَقْدِيمِها لِيُوسُفَ عِندَ حُضُورِهِ ظُهْراً، لِأنَّهُمْ سَمِعُوا أنَّهُمْ سَيَتَناوَلُونَ الغَذاءَ مَعَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","فَلَمّا جاءَ يُوسُفُ إلَى البَيتِ، قَدَّمُوا لَهُ الهَدِيَّةَ الَّتِي أحضَرُوها إلَى بَيتِهِ. وَانحَنُوا لَهُ وَوُجُوهُهُمْ إلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ثُمَّ سَألَهُمْ عَنْ حالِهِمْ. وَقالَ: «كَيفَ حالُ أبِيكُمِ العَجُوزِ الَّذِي أخبَرْتُمُونِي عَنْهُ؟ أما زالَ حَيّاً؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","فَقالُوا: «خادِمُكَ، أبوْنا، فِي صِحَّةٍ جَيِّدَةٍ. وَهُوَ ما يَزالُ حَيّاً.» ثُمَّ انحَنُوا عَلَى وُجُوهِهِمْ أمامَهُ احتِراماً لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","فَتَطَلَّعَ يُوسُفُ فَرَأى بَنْيامِيْنَ أخاهُ، ابْنَ أُمِّهِ. فَقالَ: «أهَذا هُوَ أخُوكُمُ الأصْغَرُ الَّذِي حَدَّثْتُمُونِي عَنْهُ؟» ثُمَّ قالَ لَهُ: «لِيُنْعِمْ عَلَيكَ اللهُ، يا ابْنِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ثُمَّ اندَفَعَ خارِجاً مِنَ الغُرْفَةِ لِأنَّ مَشاعِرَهُ نَحْوَ أخِيهِ كانَتْ قَوِيَّةً. أرادَ أنْ يَبْكِيَ. فَذَهَبَ إلَى غُرْفَتِهِ وَبَكَى هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ثُمَّ غَسَلَ وَجهَهُ وَخَرَجَ. وَضَبَطَ نَفْسَهُ وَقالَ: «قَدِّمُوا الطَّعامَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","فَقَدَّمَ لَهُ الخُدّامُ الطَّعامَ عَلَى طاوِلَةٍ لِوَحدِهِ، وَلِلإخْوَةِ عَلَى طاوِلَةٍ أُخْرَى. وَقَدَّمُوا الطَّعامَ لِلمِصْرِيِّينَ الَّذِينَ يَأْكُلُونَ مَعَهُ عَلَى طاوِلَةٍ ثالِثَةٍ لِوَحدِهِمْ، لِأنَّ المِصْرِيِّينَ لا يَأْكُلُونَ مَعَ العِبْرانِيِّينَ، بَلْ يُبغِضُونَ ذَلِكَ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","وَأُجلِسَ الإخوَةُ حَسَبَ تَرْتِيبِ وِلادَتِهِمْ، مِنَ الأكْبَرِ إلَى الأصْغَرِ. وَكانَ الإخوَةُ يَنْظُرُونَ أحَدُهُمْ إلَى الآخَرِ فِي دَهشَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ثُمَّ أمَرَ يُوسُفُ الخُدّامَ بِأنْ يَأْخُذُوا حِصَصاً مِنَ الطَّعامِ مِنْ طاوِلَتِهِ وَيُقَدِّمُوها لَهُمْ. غَيرَ أنَّ حِصَّةَ بَنْيامِيْنَ كانَتْ خَمْسَةَ أضْعافِ حِصَصِ الآخَرِينَ. فَأكَلُوا وَشَرِبُوا مَعَهُ حَتِّى شَبِعُوا وَارْتَوُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ثُمَّ أمَرَ يُوسُفُ الخادِمَ المَسْؤُولَ عَنْ بَيتِهِ وَقالَ لَهُ: «املأْ أكْياسَ الرِّجالِ مِنَ الطَّعامِ بِقَدْرِ ما يَسْتَطِيعُونَ أنْ يَحمِلُوا. ثُمَّ ضَعْ مالَ كُلِّ رَجُلٍ فِي كِيسِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","وَضَعْ كَأْسِيَ الفِضِّيَّةَ عَلَى رَأْسِ كِيسِ الأخِ الأصْغَرِ مَعَ مالِهِ.» فَفَعَلَ الخادِمُ كَما أمَرَهُ يُوسُفُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","فَلَمّا بَزَغَ الفَجْرُ أُرْسِلَ الرِّجالُ مَعَ حَمِيرِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","وَقَبلَ أنْ يَبْتَعِدُوا كَثِيراً عَنِ المَدِينَةِ، قالَ لِلخادِمِ المَسْؤُولِ عَنِ بَيتِهِ: «الحَقْ بِهِمْ فَوراً، وَأدرِكْهُمْ. وَقُلْ لَهُمْ: ‹لِماذا قابَلْتُمُ الخَيرَ بِالشَّرِّ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ألَيسَتْ هَذِهِ كَأْسُ سَيِّدِي الَّتِي يَسْتَخدِمُها لِكَشْفِ الأُمورِ الخَفِيَّةِ؟ فَلِماذا سَرَقْتُمُوها؟ قَدْ أسَأتُمْ بِفِعلَتِكُمْ هَذِهِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","فَلَمّا أدرَكَهُمُ الخادِمُ، كَرَّرَ عَلَى مَسامِعِهِمْ كُلَّ هَذا الكَلامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","فَقالَ لَهُ الإخْوَةُ: «لِماذا يَقُولُ سَيِّدِي كُلَّ هَذا الكَلامِ؟ لَيسَ مِنْ أخلاقِنا أنْ نَفْعَلَ مِثلَ هَذا الأمْرِ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ها قَدْ عُدنا إلَيكَ مِنْ أرْضِ كَنْعانَ بِالمالِ الَّذِي وَجَدْناهُ عَلَى رَأْسِ أكياسِنا. فَلِماذا نَسْرِقُ فِضَّةً أوْ ذَهَباً مِنْ بَيتِ سَيِّدِكَ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","إذا عَثَرْتَ عَلَى الكَأْسِ مَعَ أيِّ واحِدٍ مِنّا، نَحنُ خُدّامَكَ، فَلْيَكُنِ المَوْتُ مَصِيرَهُ. وَلْتُصْبِحْ بَقِيَّتُنا عَبِيداً لَدَى سَيِّدِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","فَقالَ الخادِمُ: «حَسَناً، لِيَكُنِ الأمْرُ كَما قُلْتُمْ. فَإنْ وَجَدْتُ الكَأْسَ مَعَ أيٍّ مِنْكُمْ، فَإنَّهُ سَيَصِيرُ عَبْداً لِي. أمّا بَقِيَّتُكُمْ فَتَكُونُونَ أحْراراً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","فَأسْرَعَ كُلُّ واحِدٍ بِإنْزالِ كِيسِهِ إلَى الأرْضِ وَفَتَحَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","وَفَتَّشَ الخادِمُ الجَمِيعَ، بَدْءاً بِالأكْبَرِ وَانتِهاءً بِالأصْغَرِ. وَوَجَدَ الكَأْسَ فِي كِيسِ بَنْيامِيْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","فَمَزَّقَ الإخوَةُ ثِيابَهُمْ حُزْناً. وَقامَ كُلُّ واحِدٍ بِتَحمِيلِ حِمارِهِ وَالعَوْدَةِ إلَى المَدِينَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","فَلَمّا جاءَ يَهُوذا وَإخوَتُهُ إلَى بَيتِ يُوسُفَ، كانَ يُوسُفُ ما يَزالُ هُناكَ. فَألْقُوا بِأنفُسِهِمْ عَلَى الأرْضِ أمامَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","فَقالَ لَهُمْ يُوسُفُ: «ما هَذا الَّذِي فَعَلْتُمُوهُ؟ ألا تَعرِفُونَ أنَّ الأسرارَ تُكشَفُ لِرَجُلٍ مِثلِي؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","فَقالَ يَهُوذا: «ماذا عَسانا نَقُولُ يا سَيِّدِي؟ ماذا عَسانا نَقُولُ؟ وَكَيفَ نُبَرِّئُ أنفُسَنا؟ فَقَدْ كَشَفَ اللهُ جَرِيمَةَ خُدّامِكَ. فَها نَحْنُ بَينَ يَدَيكَ يا سَيِّدِي، نَحْنُ وَمَنْ وُجِدَتِ الكَأْسُ فِي حَوْزَتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","فَقالَ يُوسُفُ: «لَيسَ مِنْ شِيمِي أنْ أفْعَلَ هَذا! فَالرَّجُلُ الَّذِي وُجِدَتِ الكَأْسُ فِي حَوْزَتِهِ هُوَ فَقَطْ يَكُونُ عَبْداً لِي. أمّا بَقِيَّتُكُمْ، فَيُمْكِنُكُمْ أنْ تَذْهَبُوا بِسَلامٍ إلَى أبِيكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","غَيرَ أنَّ يَهُوذا اقْتَرَبَ مِنْ يُوسُفَ وَقالَ: «يا سَيِّدِي، اسْمَحْ لِي، أنا عَبْدَكَ، بِأنْ أقُولَ شَيئاً لَكَ، يا سَيِّدِي. وَلا تَغْضَبْ مِنِّي، أنا عَبْدَكَ. فَأنتَ فِي مَقامِ فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","أنتَ سَألْتَنا، نَحنُ خُدّامَكَ: ‹ألَدَيكُمْ أبٌ أوْ أخٌ؟› ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","فَقُلْنا لَكَ، يا سَيِّدِي: ‹لَدَينا أبٌ عَجُوزٌ، وَأخٌ أصْغَرُ وُلِدَ لِأبِينا فِي شَيخُوخَتِهِ. وَأخُوهُ مِنْ أُمِّهِ مَيتٌ. وَهَذا الأخُ الأصْغَرُ هُوَ الَّذِي بَقِيَ وَحدَهُ مِنْ أبْناءِ أُمِّهِ. وَلِهَذا فَإنَّ أباهُ يُحِبُّهُ كَثِيراً.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ثُمَّ طَلَبْتَ مِنّا، نَحنُ خُدّامَكَ، وَقُلْتَ: ‹أحضِرُوهُ إلَيَّ لِكَي أراهُ› ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","لَكِنَّنا قُلْنا لَكَ، يا سَيِّدِي لا يَقْدِرُ الفَتَى أنْ يَتْرُكَ أباهُ. فَإنْ تَرَكَ أباهُ، ماتَ أبوْهُ مِنْ بَعدِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ثُمَّ قُلْتَ لَنا نَحنُ خُدّامَكَ: ‹إنْ لَمْ يَنزِلْ أخُوكُمُ الأصْغَرُ مَعَكُمْ، فَلَنْ تَرُوا وَجهِي مَرَّةً أُخْرَى.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","وَعِندَما صَعِدْنا إلَى خادِمِكَ، أبِينا، أخبَرْناهُ بِكُلِّ ما أخْبَرْتَنا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","«ثُمَّ قالَ أبوْنا: ‹عُودُوا وَاشْتَرُوا طَعاماً لَنا.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","فَقُلْنا لَهُ: ‹لا نَقْدِرُ أنْ نَنزِلَ إلَى هُناكَ. أمّا إذا كانَ أخُونا مَعَنا، فَسَنَنْزِلُ. إذْ لا نَسْتَطِيعُ رُؤْيَةَ وَجهِ الحاكِمِ، ما لَمْ يَكُنْ أخُونا الأصْغَرُ مَعَنا.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","فَقالَ لَنا أبوْنا خادِمُكَ: ‹أنتُمْ تَعلَمُونَ أنَّ زَوجَتِي راحِيلَ أنجَبَتْ لِي ابْنَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","تَرَكَنِي أحَدُهُما، فَقُلْتُ: لا بُدَّ أنَّ حَيواناً مُفْتَرِساً مَزَّقَهُ تَمْزيقاً. وَلَمْ أرَهُ مُنذُ ذَلِكَ الحِينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","فَإذا أخَذْتُمْ هَذا أيضاً مِنِّي وَحَصَلَ لَهُ أذَىً، فَسَأمُوتُ رَجُلاً عَجُوزاً حَزِيناً.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","وَالآنَ، إنْ ذَهَبْتُ، أنا خادِمَكَ، إلَى أبِي، دُونَ أنْ يَكُونَ الفَتَى مَعِي، وَنَفْسُهُ شَدِيدَةُ التَّعَلُّقِ بِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","سَيَمُوتُ وَالِدِي إذا رَأى أنَّ الفَتَى لَيسَ مَعَنا. وَسَنَكُونُ، نَحنُ خُدّامَكَ، قَدْ أرْسَلْنا أبانا، خادِمَكَ، إلَى القَبْرِ رَجُلاً عَجُوزاً حَزِيناً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","«فَأنا تَعَهَّدْتُ بِإرْجَاعِ الفَتَى لِأبِي، وَقُلْتُ لَهُ: ‹إنْ لَمْ أُرجِعْهُ إلَيكَ، حَمِّلْنِي ذَنْبَ ذَلِكَ كُلَّ أيّامِ حَياتِي.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","فَالآنَ اسْمَحْ لِي، أنا خادِمَكَ، بِأنْ أبقَى هُنا عَبْداً لَكَ، يا سَيِّدِي، مَكانَ أخِي. وَدَعِ الفَتَى يَذْهَبْ مَعَ إخْوَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","وَإلّا فَكَيفَ يُمْكِنُنِي أنْ أذْهَبَ إلَى أبِي، دُونَ أنْ يَكُونَ أخِي مَعِي؟ وَكَيفَ يُمكِنُنِي أنْ أرَى المِحنَةَ الَّتِي سَتُصِيبُ أبِي؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","فَلَمْ يَقدِرْ يُوسُفُ أنْ يَضْبُطَ نَفْسَهُ أمامَ خُدّامِهِ. فَصَرَخَ: «لِيَنصَرِفِ الجَمِيعُ مِنْ هُنا!» فَلَمْ يَبْقَ أحَدٌ مَعَ يُوسُفَ عِندَما كَشَفَ لَهُمْ هُوِيَّتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","لَكِنَّهُ بَكَى بِصَوتٍ مُرتَفِعٍ حَتَّى سَمِعَهُ المِصْرِيُّونَ وَجَميعُ بَيتِ فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","فَقالَ يُوسُفُ لإخوَتِهِ: «أنا يُوسُفُ، فَهَلْ أبِي حَيٌّ؟» لَمْ يَسْتَطِعْ إخْوَتُهُ أنْ يُجِيبُوهُ. فَقَدْ كانُوا خائِفِينَ مِنْهُ فِي حَضْرَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","وَقالَ يُوسُفُ لإخوَتِهِ: «تَعالُوا وَاقْتَرِبُوا مِنِّي.» فَاقتَرَبُوا، فَقالَ لَهُمْ: «أنا يُوسُفُ أخُوكُمُ الَّذي بِعْتُمُوهُ عَبداً لِمِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","لَكِنْ لا تَنزَعِجُوا، وَلا تَغضَبُوا مِنْ أنفُسِكُمْ لِأنَّكُمْ بِعْتُمُونِي لِهَذا المَكانِ، فَقَدْ أرْسَلَنِي اللهُ قَبلَكُمْ لِكَي أُنقِذَ حَياةَ كَثِيرِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ها قَدْ مَضَتْ سَنَتانِ عَلَى المَجاعَةِ. وَما زالَتْ هُناكَ خَمْسُ سَنَواتٍ دُونَ حِراثَةٍ أوْ حَصادٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","لَكِنَّ اللهَ أرْسَلَنِي قَبلَكُمْ لِكَي يَضْمَنَ بَقاءَ بَقِيَّةٍ مِنْ شَعبِكُمْ، وَلِكَي يُبقِيَكُمْ أحياءَ بِطَرِيقَةٍ مُدهِشَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","فَلَسْتُمْ أنتُمْ مَنْ أرسَلَنِي إلَى هُناكَ، بَلِ اللهُ. وَهُوَ الَّذِي جَعَلَنِي كَأبٍ لِفِرْعَوْنَ، وَسَيِّداً عَلَى أرْضِ مِصْرَ كُلِّها.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","وَقالَ لَهُمْ: «أسْرِعُوا وَاذهَبُوا إلَى أبِيكُمْ. وَقُولُوا لَهُ هَذِهِ رِسالَةٌ مِنَ ابْنِكَ يُوسُفَ: ‹قَدْ جَعَلَنِي اللهُ سَيِّداً عَلَى مِصْرَ كُلِّها. فانزِلْ إلَيَّ، وَلا تَتَأخَّرْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","سَتَسْكُنُ فِي أرْضِ جاسانَ. وَسَتَكُونُ قَرِيباً مِنِّي، أنتَ وَأبْناؤُكَ وَأحفادُكَ وَقُطعانُ غَنَمِكَ وَبَقَرِكَ وَكُلُّ ما لَدَيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","وَسَأعُولُكَ هُناكَ، فَلا تَحتاجَ لا أنتَ وَلا عائِلَتُكَ وَلا الَّذِينَ مَعَكَ إلَى شَيءٍ. فَمازالَتْ هُناكَ خَمْسُ سَنَواتٍ أُخْرَى مِنَ المَجاعَةِ.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","«وَها أنتُمْ وَأخِي بَنْيامِيْنَ تَرَوْنَ بِأنفُسِكُمْ أنِّي أنا يُوسُفُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","فَأخبِرُوا أبِي عَنِ المَكانَةِ الرَّفِيعَةِ الَّتِي نِلْتُها فِي مِصْرَ. وَاحكُوا لَهُ عَنْ كُلِّ ما رَأيتُمْ. ثُمَّ عَجِّلُوا بِإحضارِ أبِي إلَى هُنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ثُمَّ عانَقَ يُوسُفُ أخاهُ بَنْيامِيْنَ وَبَكَى. وَبَكَى بَنْيامِيْنُ أيضاً وَهُوَ يُعانِقُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","وَبَعدَ ذَلِكَ قَبَّلَ يُوسُفُ كُلَّ إخْوَتِهِ وَبَكَى وَهُوَ يُعانِقُهُمْ. حِينَئِذٍ، بَدَأُوا يَتَحَدَّثُونَ مَعَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","وَوَصَلَتِ الأخبارُ إلَى قَصْرِ فِرعَوْنَ. وَعَلِمَ أنَّ إخْوَةَ يُوسُفَ قَدْ جاءُوا. فَفَرِحَ فِرعَوْنُ وَوُزَراؤُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","وَقالَ فِرعَوْنُ لِيُوسُفَ: «قُلْ لإخوَتِكَ: ‹افعَلُوا هَذا: حَمِّلُوا حَمِيرَكُمْ بِالطَّعامِ وَاذْهَبُوا إلَى أرْضِ كَنْعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ثُمَّ أحضِرُوا أباكُمْ وَعائِلاتِكُمْ وَتَعالَوا عِندِي. وَسَأُعطِيكُمْ أفضَلَ أرْضٍ فِي مِصْرَ. وَسَتَأْكُلُونَ أجوَدَ طَعامٍ فِي البِلادِ.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","وَمُرْهُمْ: ‹افعَلُوا هَذا: خُذُوا عَرَباتٍ لَكُمْ مِنْ أرْضِ مِصْرَ لِأبْنائِكُمْ وَلِزَوْجاتِكُمْ وَأحضِرُوا أباكُمْ وَارجِعُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","وَلا تَأسَفُوا عَلَى تَرْكِ حاجِياتِكُمْ خَلْفَكُمْ. إذْ سَيَكُونُ أفضَلَ ما فِي أرْضِ مِصْرَ لَكُمْ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","وَهَكَذا فَعَلَ أولادُ إسْرائِيلَ. وَأعطاهُمْ يُوسُفُ عَرَباتٍ كَما أمَرَ فِرعَوْنُ. وَأعطاهُمْ طَعاماً لِلطَّرِيقِ أيضاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","وَأعطَى لِكُلِّ واحِدٍ مِنْهُمْ ثَوْباً جَدِيداً. وَأمّا بَنْيامِيْنُ فَأعطاهُ ثَلاثَ مِئَةِ قِطعَةٍ مِنَ الفِضَّةِ وَخَمْسَةَ أثْوابٍ جَدِيدَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","وَأرْسَلَ لِأبِيهِ ما يَلِي: عَشْرَةَ حَمِيرٍ مُحَمَّلَةً بِخَيراتِ مِصْرَ، وَعَشَرَ أُتُنٍ مُحَمَّلَةً بِالقَمْحِ وَالخُبْزِ وَالطَّعامِ لِرِحلَةِ أبِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","فَوَدَّعَ يُوسُفُ إخْوَتَهُ، فانطَلَقُوا. وَقالَ لَهُمْ يُوسُفُ: «لا تَتَشاجَرُوا فِي الطَّرِيقِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","فَصَعِدُوا مِنْ مِصْرَ، وَذَهَبُوا إلَى بَيتِ أبِيهِمْ يَعقُوبَ فِي أرْضِ كَنْعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","وَقالُوا لَهُ: «ما زالَ يُوسُفُ حَيّاً، وَهُوَ يَحكُمُ أرْضَ مِصْرَ كُلَّها.» فَصُعِقَ أبوهُمْ، إذْ لَمْ يُصَدِّقْهُمْ! ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","فَأخبَرُوهُ كُلَّ ما قالَهُ لَهُمْ يُوسُفُ. ثُمَّ رَأى يَعقُوبُ العَرَباتِ الَّتِي أرْسَلَها يُوسُفُ لِتَحمِلَهُ إلَى مِصْرَ. فانتَعَشَ يَعقُوبُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ثُمَّ قالَ إسْرائِيلُ: «يَكفِي ما قُلْتُمْ. أنا أُصَدِّقُ الآنَ أنَّ ابْنِي يُوسُفَ مازالَ حَيّاً. سَأذْهَبُ وَأراهُ قَبلَ أنْ أمُوتَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","فَشَرَعَ إسْرائِيلُ فِي رِحلَتِهِ آخِذاً مَعَهُ كُلَّ ما لَهُ. وَوَصَلَ إلَى بِئْرِ السَّبْعِ. وَهُناكَ قَدَّمَ ذَبائِحَ لإلَهِ أبِيهِ إسْحاقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","وَفِي تِلْكَ اللَّيلَةِ كَلَّمَ اللهُ إسْرائِيلَ فِي حُلْمٍ فَقالَ لَهُ: «يَعقُوبُ، يَعْقُوبُ.» فَقالَ يَعقُوبُ: «سَمْعاً وَطاعَةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","فَقالَ: «أنا اللهُ، إلَهُ أبِيكَ. لا تَخْشَ النُّزُولَ إلَى مِصْرَ، فَأنا سَأجعَلُكَ أُمَّةً عَظِيمَةً هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","سَأنزِلُ إلَى مِصْرَ مَعَكَ. وَسَأُعِيدُكَ مِنْ هُناكَ. وَسَيُغلِقُ ابْنُكَ يُوسُفُ عَينَيكَ حَينَ تَمُوتُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","فَغادَرَ يَعقُوبُ بِئْرَ السَّبْعِ. وَحَمَلَ أولادُ إسْرائِيلَ أباهُمْ يَعقُوبَ وَأبْناءَهُمْ وَزَوْجاتِهِمْ عَلَى العَرَباتِ الَّتِي كانَ فِرعَوْنُ قَدْ أرسَلَها لِتَحمِلَهُم. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","فَأخَذُوا مَواشِيَهُمْ وَكُلَّ مُقْتَنَياتِهِمِ الَّتِي اقتَنُوها فِي أرْضِ كَنْعانَ. وَذَهَبَ يَعْقُوبُ وَكُلُّ نَسلِهِ مَعَهُ إلَى مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","أخَذَ يَعقُوبُ مَعَهُ إلَى مِصْرَ أولادَهُ وَأحفادَهُ، وَبَناتِهِ وَحَفِيداتِهِ، وَكُلَّ نَسلِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","هَذِهِ هِيَ أسْماءُ أبناءِ إسْرائِيلَ الَّذِينَ دَخَلُوا مِصْرَ، يَعقُوبُ وَبَنُوهُ: رَأُوبَيْنُ، وَكانَ بِكْرَ يَعقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","أمّا أبْناءُ رَأُوبَيْنَ فَهُمْ حَنُوكُ وَفَلُّو وَحَصْرُونُ وَكَرْمِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","وَأبْناءُ شِمْعُونَ هُمْ يَمُوئِيلُ وَيامِينُ وَأُوهَدُ وَياكِينُ وَصُوحَرُ وَشَاوُلُ ابْنُ الكَنعانِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","وَأبْناءُ لاوِي هُمْ جَرْشُونُ وَقَهاتُ وَمَرارِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","وَأبْناءُ يَهُوذا هُمْ: عِيرُ وَأُونانُ وَشِيلَةُ وَفارَصُ وَزارِحُ. وَماتَ عِيرُ وَأُونانُ فِي أرْضِ كِنْعانَ. وَأبْناءُ فارَصَ هُمْ حَصْرُونُ وَحامُولُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","وَأبْناءُ يَسّاكَرَ هُمْ تُولاعُ وَفَوَّةُ وَيُوبُ وَشِمْرُونُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","وَأبْناءُ زَبُولُونَ هُمْ سادَرُ وَإيلُونُ وَياحَلْئِيلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","هَؤُلاءِ هُمْ أبْناءُ لَيئَةَ الَّذِينَ أنجَبَتْهُمْ لِيَعقُوبَ فِي فَدَّانَ أرامَ. بِالإضافَةِ إلَى دِينَةَ، ابْنَةِ يَعقُوبَ. وَكانَ عَدَدُ هَذا الجُزْءِ مِنَ العائِلَةِ ثَلاثَةً وَثَلاثِينَ فَرداً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","وَأبْناءُ جادَ فَهُمْ صِفْيُونُ وَحَجِّي وَشُونِي وَأصْبُونُ وَعِيرِي وَأرُودِي وَأرْئِيلِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","وَأبْناءُ أشِيرَ هُمْ يَمْنَةُ وَيَشْوَةُ وَيِشْوِي وَبَرِيعَةُ، وَأُختُهُمْ سارَحُ. وَابْنا بَرِيعَةَ هُما حابِرُ وَمَلْكِيئِيلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","هَؤُلاءِ هُمْ أولادُ زِلْفَةَ. وَكانَ لابانُ قَدْ أعطاها لِلَيئَةَ. فَأنجَبَتْ زِلْفَةُ هَؤُلاءِ الأبْناءَ لِيَعقُوبَ. وَكانَ مَجمُوعُ هَذا الجُزْءِ مِنَ العائِلَةِ سِتَّةَ عَشَرَ فَرداً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","وَأمّا ابْنا راحِيلَ فَهُما يُوسُفُ وَبَنْيامِيْنُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","وَوُلِدَ مَنَسَّى وَأفْرايِمُ لِيُوسُفَ فِي أرْضِ مِصْرَ مِنْ زَوجَتِهِ أسْناتَ بِنتِ فِوْطِي فارَعَ كاهِنِ مَدِينَةِ أُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","وَأبناءُ بَنْيامِيْنَ هُمْ بالَعُ وَباكَرُ وَأشْبِيلُ وَجِيرا وَنُعمانُ وَإيحِي وَرُوشُ وَمُفِّيمُ وَحُفِّيمُ وَأرْدٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","هَؤُلاءِ هُمْ أولادُ راحِيلَ الَّذِينَ أنجَبَتْهُمْ لِيَعقُوبَ. وَكانَ عَدَدُ هَذا الجُزْءِ مِنَ العائِلَةِ أرْبَعَةَ عَشَرَ فَرداً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","وَابْنُ دانَ هُوَ حُوشِيمُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","وَأمّا أبْناءُ نَفْتالِي هُمْ ياحَصْئِيلُ وَجُونِي وَبِصْرُ وَشِلِّيمُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","هَؤُلاءِ هُمْ أولادُ بِلْهَةَ. وَكانَ لابانُ قَدْ أعطَى بِلْهَةَ لابْنَتِهِ راحِيلَ. فَوَلَدَتْ بِلْهَةُ هَؤُلاءِ الأبْناءَ لِيَعْقُوبَ. فَمَجمُوعُ هَذا الجُزْءِ مِنَ العائِلَةِ سَبْعَةَ أفْرادٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","فَكانَ مَجمُوعُ الَّذِينَ ذَهَبُوا إلَى مِصْرَ مَعَ يَعْقُوبَ مِنْ نَسلِهِ سِتَّةً وَسِتِّينَ فَرداً. وَلا يَشْمُلُ هَذا العَدَدُ زَوْجاتِ أولادِ يَعْقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","وَهُناكَ أيضاً ابْنا يُوسُفَ اللَّذانِ أنجَبَهُما فِي مِصْرَ. فَكانَ مَجمُوعُ الأفْرادِ فِي بَيتِ يَعقُوبَ الَّذِينَ ذَهَبُوا إلَى مِصْرَ سَبْعِينَ فَرداً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","وَأرْسَلَ يَعقُوبُ يَهُوذا قَبلَهُ إلَى يُوسُفَ لِكَي يَدُلَّهُ عَلَى الطَّرِيقِ إلَى جاسانَ. فَوَصَلُوا إلَى أرْضِ جاسانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","فَجَهَّزَ يُوسُفُ عَرَبَتَهُ وَصَعِدَ إلَى جاسانَ لِمُلاقاةِ أبِيهِ إسْرائِيلَ. وَعانَقَهُ وَبَكَى عَلَى كَتِفِهِ مُدَّةً طَوِيلَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ثُمَّ قالَ يَعقُوبُ لِيُوسُفَ: «أنا الآنَ مُسْتَعِدٌّ أنْ أمُوتَ، حَيثُ إنِّي رَأيتُكَ بِنَفسِي وَتَأكَّدْتُ مِنْ أنَّكَ ما زِلْتَ حَيّاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","فَقالَ يُوسُفُ لإخْوَتِهِ وَلِكُلِّ بَيتِ أبِيهِ: «سَأصْعَدُ لِأُكَلِّمَ فِرعَوْنَ. وَسَأقُولُ لَهُ: ‹لَقَدْ جاءَ إلَيَّ إخْوَتِي وَبَيتُ أبِي مِنْ أرْضِ كَنْعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","وَرِجالُهُمْ رُعاةٌ، فَهُمْ يُرَبُّونَ مَواشِيَ. وَقَدْ جَلَبُوا مَعَهُمْ قُطعانَ غَنَمِهِمْ وَبَقَرِهِمْ وَكُلِّ ما يَملِكُونَ.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","فَحِينَ يَسْتَدْعِيكُمْ فِرعَوْنُ وَيَسْألُكُمْ: ‹ما هُوَ عَمَلُكُمْ؟› ");
INSERT INTO arbwbtc_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","قُولُوا لَهُ: ‹كُنّا، نَحْنُ خُدّامَكَ، نُرَبِّي المَواشِيَ مُنذُ صِغَرِنا إلَى الآنَ، أباً عَنْ جَدٍّ.› قُولُوا هَذا لِكَي تَسْكُنُوا فِي أرْضِ جاسانَ. فَكُلُّ راعٍ مَكرُوهٌ فِي مِصْرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","فَذَهَبَ يُوسُفُ وَكَلَّمَ فِرعَوْنَ فَقالَ لَهُ: «جاءَ أبِي وَإخوَتِي مَعَ كُلِّ غَنَمِهِمْ وَبَقَرِهِمْ وَكُلِّ ما يَملِكُونَ مِنْ أرْضِ كَنعانَ. وَهُمُ الآنَ فِي أرْضِ جاسانَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","وَأخَذَ يُوسُفُ مَعَهُ خَمْسَةً مِنْ إخْوَتِهِ وَقَدَّمَهُمْ إلَى فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","فَقالَ فِرعَوْنُ لإخْوَةِ يُوسُفَ: «ما هُوَ عَمَلُكُمْ؟» فَقالُوا لِفِرْعَوْنَ: «نَحنُ خُدّامَكَ رُعاةٌ، أباً عَنْ جَدٍّ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ثُمَّ قالُوا لِفِرْعَوْنَ: «جِئْنا لِنَقِيمَ كَغُرَباءَ فِي الأرْضِ. إذْ لا يُوجَدُ مَرعَىً لِمَواشِي خُدّامِكَ، لِأنَّ المَجاعَةَ قاسِيَةٌ فِي أرْضِ كَنْعانَ. فاسْمَحْ لَنا، نَحنُ خُدّامَكَ، بِأنْ نَسْتَقِرَّ فِي أرْضِ جاسانَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","فَقالَ فِرعَوْنُ لِيُوسُفَ: «جاءَ أبوْكَ وَإخوَتُكَ إلَيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","وَها هِيَ أرْضُ مِصْرَ مَفْتُوحَةٌ أمامَكَ. فَأسْكِنْ أباكَ وَإخوَتَكَ فِي أفضَلِ بُقعَةٍ فِي الأرْضِ. لِيَسْكُنُوا فِي أرْضِ جاسانَ. وَإنْ كُنتَ تَعرِفُ أنَّ بَينَهُمْ رِجالاً مُقْتَدِرِينَ، فَعَيِّنْهُمْ رُؤَساءَ رُعاةٍ مُشْرِفِينَ عَلَى مَواشِيَّ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ثُمَّ أحضَرَ يُوسُفُ أباهُ يَعقُوبَ وَقَدَّمَهُ لِفِرْعَوْنَ. وَبارَكَ يَعقُوبُ فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","فَقالَ فِرعَوْنُ لِيَعقُوبَ: «كَمْ عُمْرُكَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","فَقالَ يَعقُوبُ لِفِرْعَوْنَ: «سَنَواتُ اغتِرابِي هِيَ مِئَةٌ وَثَلاثُونَ سَنَةً. وَسَنَواتُ حَياتِي قَلِيلَةٌ وَصَعْبَةٌ. وَلَمْ أبلُغْ عُمْرَ آبائِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","وَبارَكَ يَعقُوبُ فِرعَوْنَ، ثُمَّ خَرَجَ مِنْ عِندِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","وَهَكَذا أسْكَنَ يُوسُفُ أباهُ وَإخوَتَهُ وَأعطاهُمْ أملاكاً فِي أرْضِ مِصْرَ، فِي أفضَلِ بُقْعَةٍ مِنْها، فِي أرْضِ رَعَمْسِيسَ، كَما أمَرَ فِرعَوْنُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","وَكانَ يُوسُفُ يَعُولُ أباهُ وَإخوَتَهُ وَكُلَّ بَيتِ أبِيهِ بِالطَّعامِ، مِنَ الكَبِيرِ إلَى الصَّغِيرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","وَلَمْ يَكُنْ فِي البِلادِ طَعامٌ، إذْ كانَتِ المَجاعَةُ قاسِيَةً جِدّاً. وَافتَقَرَتْ أرْضُ مِصْرَ وَأرْضُ كَنْعانَ كَثِيراً بِسَبَبِ المَجاعَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","فَجَمَعَ يُوسُفُ كُلَّ الفِضَّةِ الَّتِي فِي أرْضِ مِصْرَ وَفِي أرْضِ كَنْعانَ مُقابِلَ القَمحِ الَّذِي اشْتَرُوهُ. وَجَلَبَ يُوسُفُ الفِضَّةَ إلَى بَيتِ فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","وَلَمّا لَمْ تَعُدْ هُناكَ فِضَّةٌ فِي أرْضِ مِصْرَ وَأرْضِ كَنْعانَ، جاءَ كُلُّ شَعبِ مِصْرَ إلَى يُوسُفَ وَقالُوا لَهُ: «أعطِنا طَعاماً، وَإلّا مُتْنا أمامَكَ. فَقَدْ نَفَذَتْ فِضَّتُنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","فَقالَ يُوسُفُ: «أعطُونِي مَواشِيكُمْ. وَسَأُعطِيكُمْ طَعاماً مُقابِلَ مَواشِيكُمْ إنْ كانَتْ فِضَّتُكُمْ قَدْ نَفَذَتْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","فَأتَوا بِمَواشِيهِمْ إلَى يُوسُفَ. فَأعطاهُمْ طَعاماً مُقابِلَ خَيلِهِمْ وَغَنَمِهِمْ وَبَقَرِهِمْ وَحَمِيرِهِمْ. وَفِي تِلْكَ السَّنَةِ زَوَّدَهُمْ يُوسُفُ بِالطَّعامِ مُقابِلَ كُلِّ مَواشِيهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","فانقَضَتْ تِلْكَ السَّنَةُ. فَجاءُوا إلَيهِ فِي السَّنَةِ التّالِيَةِ وَقالُوا: «نَعلَمُ يا سَيِّدِي أنَّ فِضَّتَنا قَدْ نَفَذَتْ، وَقُطْعانَ مَواشِينا صارَتْ عِندَكَ يا سَيِّدِي. وَلَمْ يَبْقَ لَدَينا إلّا أجسادُنا وَأراضِينا. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","فَإذا لَمْ تُرِدْ، يا سَيِّدِي، أنْ نَمُوتَ نَحنُ وَأراضِينا، فاشْتَرِنا نَحنُ وَأراضِينا مُقابِلَ الطَّعامِ. وَسَنَكُونُ عَبِيداً مَعَ أرْضِنا لِفِرْعَوْنَ. فَأعطِنا بِذاراً لِنَزْرَعَ، فَنَحْيا وَلا نَمُوتَ، وَلا تُصْبِحَ الأرْضُ قاحِلَةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","فاشْتَرَى يُوسُفُ كُلَّ أرْضِ مِصْرَ لِفِرْعَوْنَ. فَقَدْ باعَ كُلُّ مِصْرِيٍّ حُقُولَهُ، لِأنَّهُمْ جاعُوا كَثِيراً. فَصارَتِ الأرْضُ لِفِرْعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","وَاسْتَعبَدَ النّاسَ مِنْ أقصَى حُدُودِ مِصْرَ إلَى أقْصاها. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","أمّا الأرْضُ الوَحِيدَةُ الَّتِي لَمْ يَشْتَرِها يُوسُفُ فَكانَتْ أرْضَ الكَهَنَةِ. إذْ كانَ الكَهَنَةُ يَتَلَقُّونَ دَخلاً ثابِتاً مِنْ فِرعَوْنَ. وَلِهَذا لَمْ يُضْطَرُّوا لِبَيعِ أراضِيهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","وَقالَ يُوسُفُ لِلشَّعْبِ: «ها قَدِ اشْتَرَيتُكُمُ اليَوْمَ مَعَ أرْضِكُمْ لِفِرْعَوْنَ. فَخُذُوا بِذاراً، وَابْذُرُوها فِي الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","لَكِنْ حِينَ يَجِيءُ الحَصادُ، يَنْبَغِي أنْ تُعطُوا خُمْسَ مَحاصِيلِكُمْ لِفِرْعَوْنَ. وَاحتَفِظوا لِأنفُسِكُمْ بِأربَعَةِ أخماسٍ. أبقُوها بِذاراً لِلحَقلِ، وَطَعاماً لَكُمْ وَلِبُيُوتِكُمْ، وَطَعاماً لِصِغارِكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","فَقالُوا: «لَقَدْ أنقَذْتَ حَياتَنا! وَإنْ كانَ يُرْضِيكَ يا سَيِّدِي، سَنَكُونُ عَبِيداً لِفِرْعَوْنَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","وَهَكَذا سَنَّ يُوسُفُ قانُوناً لِأرْضِ مِصْرَ. وَهُوَ قانُونٌ سارٍ إلَى هَذا اليَوْمِ. وَيَنُصُّ القانُونُ عَلَى أنَّ خُمْسَ المَحصُولِ هُوَ مِنْ نَصِيبِ فِرعَوْنَ. وَأرْضُ الكَهَنَةِ هِيَ وَحدَها الَّتِي لَمْ تَصِرْ لِفِرْعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","فَاسْتَقَرَّ بَنُو إسْرائِيلَ فِي أرْضِ جاسانَ مِنْ بِلادِ مِصْرَ، وَاقتَنُوا مُمتَلَكاتٍ هُناكَ. وَأنجَبُوا أبْناءً كَثِيرِينَ، فَصارَ عَدَدُهُمْ كَبِيراً جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","وَعاشَ يَعقُوبُ فِي أرْضِ مِصْرَ سَبْعَ عَشْرَةَ سَنَةً. وَعاشَ مِئَةً وَسَبْعاً وَأرْبَعِينَ سَنَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","وَلَمّا اقْتَرَبَ يَعقُوبُ مِنَ المَوْتِ، اسْتَدعَى ابْنَهُ يُوسُفَ، وَقالَ لَهُ: «إنْ كُنْتَ تُحِبُّنِي حَقّاً، فَضَعْ يَدَكَ تَحتَ فَخذِي، وَاحلِفْ لِي بِأنَّكَ سَتَكُونُ صادِقاً مَعْي. لا تَدفِنِّي فِي مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","فَعِندَما أمُوتُ، أخرِجْنِي مِنْ مِصْرَ، وَادفِنِّي فِي مَقْبَرَةِ آبائِيَ.» فَقالَ يُوسُفُ: «سَأفْعَلُ كَما قُلْتَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","فَقالَ: «احلِفْ لِي.» فَحَلَفَ يُوسُفُ لَهُ. فَسَجَدَ إسْرائيلُ للهِ مُستَنِداً عَلَى حَافَّةِ سَريرهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","وَفِيما بَعْدُ، قالَ أحَدُهُمْ لِيُوسُفَ: «ها أبوْكَ مَرِيضٌ.» فَأخَذَ يُوسُفُ وَلَدَيهِ مَنَسَّى وَأفْرايِمَ مَعَهُ لِرُؤْيَةِ يَعقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","فَقالَ أحَدُهُمْ لِيَعقُوبَ: «ها قَدْ جاءَ ابْنُكَ يُوسُفُ لِرُؤْيَتِكَ.» فَاسْتَجمَعَ يَعقُوبُ قِواهُ وَاعتَدَلَ فِي جِلْسَتِهِ عَلَى السَّرِيرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ثُمَّ قالَ يَعقُوبُ لِيُوسُفَ: «لَقَدْ ظهَرَ لِيَ اللهُ الجَبّارُ فِي لُوزَ، فِي أرْضِ كَنْعانَ وَبارَكَنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","وَقالَ لِي: ‹ها أنا أُعطِيكَ أبْناءَ كَثِيرِينَ، وَأُكَثِّرَكَ وَعائِلَتَكَ عَدَداً. وَسَأجعَلُكَ وَنَسلَكَ مَجمُوعَةَ شُعُوبٍ. وَسَأُعطِي هَذِهِ الأرْضَ لِنَسلِكَ مِنْ بَعدِكَ مُلْكاً أبَدِيّاً.› ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","وَالآنَ سَيَكُونُ وَلَداكَ اللَّذانِ أنجَبْتَهُما فِي مِصْرَ قَبلَ أنْ آتِيَ إلَيكَ وَلَدَيَّ أنا. إذْ سَيَكُونُ أفْرايِمُ وَمَنَسَّى كَرَأُوبَيْنَ وَشِمْعُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","أمّا الأبْناءُ الَّذِينَ تُنجِبُهُمْ بَعْدَهُما فَيَكُونُونَ لَكَ، وَيَأْخُذُونَ جُزءاً مِنَ الأرْضِ المُخَصَّصَةِ لِأفْرايِمَ وَمَنَسَّى. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","وَحِينَ كُنتُ قادِماً مِنْ فَدَّانَ أرامَ، ماتَتْ راحِيلُ فِي الطَّرِيقِ إلَى أرْضِ كَنْعانَ، فَحَزِنْتُ. ماتَتْ قَبلَ مَسافَةٍ قَصِيرَةٍ مِنْ وُصُولِنا إلَى أفْراتَةَ. فَدَفَنْتُها عَلَى طَرِيقِ أفْراتَةَ الَّتِي هِيَ بَيتُ لَحْمِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","وَلَمّا رَأى إسْرائِيلُ ابْنَي يُوسُفَ سَألَ: «مَنْ هَذانِ الوَلَدانِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","فَقالَ يُوسُفُ لِأبِيهِ: «هَذانِ وَلَدايَ اللَّذانِ أعطانِي إيّاهُما اللهُ.» فَقالَ يَعقُوبُ: «قَرِّبْهُما إلَيَّ، وَسَأُبارِكْهُما.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","وَكانَتْ عَينا إسْرائِيلَ ضَعِيفَتَينِ مِنَ الشَّيخُوخَةِ. فَلَمْ يَكُنْ يَرَى جَيِّداً. فَلَمّا قَرَّبَ يُوسُفُ ابْنَيهِ مِنْهُ، قَبَّلَهُما يَعقُوبُ وَعانَقَهُما. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ثُمَّ قالَ إسْرائِيلُ لِيُوسُفَ: «ما تَوَقَّعْتُ أنْ أراكَ ثانِيَةً. لَكِنْ ها قَدْ أكرَمَنِي اللهُ بِرُؤْيَةِ وَلَدَيكَ أيضاً!» ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ثُمَّ رَفَعَهُما يُوسُفُ مِنْ حِضْنِ يَعقُوبَ، وَانحَنَى إلَى الأرْضِ أمامَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","وَحَمَلَهُما كِلَيهِما، وَوَضَعَ أفْرايِمَ إلَى يَمِينِهِ، أي إلَى يَسارِ إسْرائِيلَ. وَوَضَعَ مَنَسَّى إلَى يَسارِهِ، أي إلَى يَمِينِ إسْرائِيلَ. ثُمَّ قَرَّبَهُما إلَيهِ ثانِيَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","فَمَدَّ إسْرائِيلُ يَدَهُ اليُمْنَى وَوَضَعَها عَلَى رَأْسِ أفْرايِمَ، وَاليُسْرَى عَلَى رَأْسِ مَنَسَّى، وَذِراعاهُ مُتَصالِبَتانِ. وَكانَ مَنَسَّى هُوَ البِكْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ثُمَّ بارَكَ إسْرائِيلُ يُوسُفَ وَقالَ: «أدعُو اللهَ الَّذِي عَبَدَهُ أبَوايَ إبْراهِيمُ وَإسْحاقُ، اللهَ الَّذِي كانَ راعِيَّ كُلَّ حَياتِي إلَى هَذا اليَوْمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","مَلاكَ اللهِ الَّذِي خَلَّصَنِي مِنْ كُلِّ أذَىً، أنْ يُبارِكَ هَذَينِ الوَلَدينِ. وَأنْ يَجعَلَ اسْمِيَ، وَاسْم أبَوَيَّ إبْراهِيمَ وَإسْحاقَ يَعِيشُ فِيهِما. وَأنْ يُكَثِّرَ نَسلَهُما فِي الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","وَانتَبَهَ يُوسُفُ إلَى أنَّ أباهُ يَضَعُ يَدَهُ اليُمْنَى عَلَى رَأْسِ أفْرايِمَ، فَاسْتَاءَ مِنْ ذَلِكَ. فَأخَذَ يَدَ أبِيهِ وَحاوَلَ إزاحَتَها عَنْ رَأْسِ أفْرايِمَ إلَى رَأْسِ مَنَسَّى، ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","وَهُوَ يَقُولُ لِأبِيهِ: «لَيسَ هَكَذا، يا أبِي! فَهَذا هُوَ البِكْرُ. فَضَعْ يَدَكَ اليُمْنَى عَلَى رَأْسِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","فَرَفَضَ أبوهُ وَقالَ: «أعلَمُ ذَلِكَ، يا ابْنِي، أعلَمُ. وَهُوَ أيضاً سَيَصِيرُ شَعباً. وَهُوَ أيضاً سَيَصِيرُ عَظِيماً. لَكِنَّ أخاهُ الأصْغَرَ سَيَصِيرُ أعظَمَ مِنْهُ. وَسَيَكُونُ نَسلُهُ مَجمُوعَةً مِنَ الشُّعُوبِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","فَبارَكَهُما إسْرائِيلُ فِي ذَلِكَ اليَوْمِ وَقالَ: «حَينُ يُرِيدُ بَنو إسْرائِيلَ أنْ يُبارِكُوا أحَداً سَيَقُولُونَ: ‹لَيتَ اللهَ يَجعَلُكَ كَأفْرايِمَ وَكَمَنَسَّى.›» فَقَدَّمَ اسْمَ أفْرايِمَ عَلى اسْمِ مَنَسَّى! ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ثُمَّ قالَ إسْرائِيلُ لِيُوسُفَ: «ها أنا أحتَضِرُ. لَكِنَّ اللهَ سَيَكُونُ مَعَكَ، وَسَيَرُدُّكَ إلَى أرْضِ آبائِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","وَسَأُعطِيكَ حِصَّةً زِيادَةً عَلَى حِصَصِ إخْوَتِكَ مِنَ الأرْضِ الَّتِي أخَذْتُها مِنَ الأمُورِيِّينَ بِسَيفِي وَقَوْسِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ثُمَّ دَعا يَعقُوبُ كُلَّ أولادِهِ إلَيهِ. وَقالَ: «تَجَمَّعُوا حَولِيَ فَأتَنبَّأَ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«تَعالَوْا وَاسْتَمِعُوا، يا أولادَ يَعقُوبَ. اسْتَمِعُوا إلَى إسْرائِيلَ أبِيكُمْ: ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«رَأُوبَيْنُ، أنتَ بِكْرِي. أنتَ قُوَّتِي وَأوَّلُ دَلِيلٍ لِي عَلَى رُجُولَتِي. امتَزْتَ كَرامَةً وَقُوَّةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","لَكِنَّكَ كَالماءِ لا تُضْبَطُ. وَلِهَذا لَنْ تَمتازَ بَعْدُ، لِأنَّكَ عاشَرْتَ خادِمَةَ أبِيكَ، فَدَنَّسْتَ سَرِيرِي عِندَما نِمْتَ عَلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«شِمْعُونُ وَلاوِي أخَوانِ. سَيفاهُما سِلاحا عُنفٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","لا أُحِبُّ مَجلِسَهُما، وَلا أرتاحُ فِي اجتِماعِهِما. فَقَدْ قَتَلا رَجُلاً فِي غَضَبِهِما، وَشَلّا ثِيراناً لِمُجَرَّدِ التَّسلِيَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","مَلْعُونٌ غَضَبُهُما، فَهُوَ عَنِيفٌ جِدّاً. وَمَلْعُونٌ هِياجُهُما فَهُوَ لا يَرحَمُ. سَأُفَرِّقُهُما بَينَ قَبائِلَ يَعقُوبَ. سَأُبَعْثِرُهُما فِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«أمّا أنتَ يا يَهُوذا، فَسَيَمدَحُكَ إخْوَتُكَ. وَسَتَهزِمُ أعداءَكَ. وَسَيَنحَنِي لَكَ أولادُ أبِيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","وَيَهُوذا مِثلُ شِبلٍ. يا ابْنِي، عُدْتَّ بَعْدَ أنِ اصْطَدْتَ فَريسَتَكَ. أنتَ كَأسَدٍ تَجثُمُ وَتَرْبِضُ. فَمَنْ يَجرُؤُ أنْ يُزعِجَكَ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","لَنْ يُفارِقَ صَولَجانُ المُلْكِ يَهُوذا، وَلا عَصا الحاكِمِ مِنْ بَينِ قَدَمَيهِ، إلَى أنْ يَجِيءَ المَلُكُ الحَقِيقِيُّ، وَتُطِيعَهُ الشُّعُوبُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","بِالكَرمَةِ يَرْبِطُ جَحْشَهُ. وَبِالدَّوالِي يَربِطُ حِمارَهُ الصَّغِيرَ. بِالنَّبيذِ يَغْسِلُ مَلابِسَهُ، وَبِعَصِيرِ العِنَبِ ثَوْبَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","عَيناهُ أشَدُّ حُمْرَةً مِنَ النَّبيذِ. وَأسْنانُهُ أشَدُّ بَياضاً مِنَ الحَلِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«أمّا زَبُولُونَ، فَيَسْتَقِرُّ عِندَ شاطِئِ البَحرِ. وَمَرْفَأً لِلسُّفُنِ سَيَكُونُ. وَسَتَمتَدُّ إلَى صَيدُونَ حُدُودُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«أمّا يَسّاكَرُ فَكَحِمارٍ قَوِيٍّ رابِضٍ تَحتَ ثِقَلِ السُّرُوجِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","اسْتَطابَ الرّاحَةَ، وَأحَبَّ الجُلُوسَ فِي أرْضِ الكَسَلِ. فَحَنَى ظَهْرَهُ لِيَحمِلَ حِملاً. وَأُجْبِرَ عَلَى العُبُودِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«أمّا دانُ فَبِالعَدلِ يَحْكُمُ شَعبَهُ كَما يَلِيقُ بِعَشيرَةٍ مِنْ إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","«كَثُعْبانٍ عَلَى جانِبِ الطَّرِيقِ يَكُونُ دانُ. كَأفْعَى سامَّةٍ قُرْبَ المَمَرِّ. تَهْجُمُ فَتَلْدَغُ كَعْبَيِّ الحِصانِ، فَيَسْقُطُ راكِبُهُ إلَى الوَراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","«أنتَظِرُ خَلاصَكَ، يا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«أمّا جادُ فَيَغزُوهُ الغُزاةُ، وَهُوَ يَرُدُّهُمْ عَلَى أعقابِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«أمّا أشِيرُ، فَيَكُونُ غَنِيّاً، وَيُقَدِّمُ طَعاماً يَلِيقُ بِمُلُوكٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«نَفْتالِي كَظَبْيَةٍ مُطلَقَةٍ لَها وَلَدانِ جَمِيلانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«أمّا يُوسُفُ فَكَرْمَةٌ مُثْمِرَةٌ، كَرْمَةٌ مُثْمِرَةٌ عِندَ نَبْعٍ. أغصانُهُ تَتَسَلَّقُ السِّياجَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","حَقَدَ عَلَيهِ رُماةُ سِهامٍ وَأطلَقُوا عَلَيهِ وَعادُوهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","لَكِنَّ قُوَّتَهُ بَقِيَتْ ثابِتَةً، وَذِراعاهُ ظَلَّتا مَرِنَتَينِ. صارَ هَذا بِيَدَي إلَهِ يَعقُوبَ القَوِيِّ، بِاسْمِ الرّاعِي، صَخْرَةِ إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","صارَ هَذا بِفَضلِ إلَهِ أبِيكَ. لَيتَهُ يَكُونُ عَوناً لَكَ. صارَ هَذا بِقُوَّةِ اللهِ القَدِيرِ. لَيتَهُ يُبارِكُكَ بِبَرَكاتٍ مِنَ السَّماءِ مِنْ فَوْقُ، وَبِبَرَكاتٍ مُخَبَّأةٍ لَكَ فِي أعماقِ المُحِيطِ. لَيتَهُ يُبارِكُكَ بِبَرَكاتِ الثَّدْيَينِ وْالرَّحِمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","وَها قَدْ عَلَتْ بَرَكاتُ أبِيكَ فَوْقَ الجِبالِ القَدِيمَةِ، فاقَتْ خَيراتُ التِّلالِ الأبَدِيَّةِ. لَيتَها كُلَّها تَأْتِي عَلَى رَأْسِ يُوسُفَ. لَيتَها تَعلُو جَبِينَ ذاكَ الَّذِي أفْرَزَهُ اللهُ لِعَمَلٍ خاصٍّ بَينَ إخْوَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«بَنْيامِيْنُ كَذِئْبٍ جائِعٍ. فِي المَساءِ يَأْكُلُ فَرِيسَتَهُ. وَفِي المَساءِ يَأْخُذُ مِنَ الغَنِيمَةِ حِصَّةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","هَذِهِ هِيَ قَبائِلُ إسْرائِيلَ الاثْنَتا عَشْرَةَ. وَهَذا هُوَ ما قالَهُ لَهُمْ أبوْهُمْ عِندَما بارَكَهُمْ واحِداً واحِداً بِبَرَكَةٍ خاصَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ثُمَّ أوصاهُمْ وَقالَ لَهُمْ: «أنا أحْتَضِرُ. فادْفِنُونِي مَعَ آبائِيَ فِي الكَهْفِ الَّذِيِ فِي حَقلِ عِفْرُونَ الحِثِّيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ادفِنُونِي فِي الكَهْفِ الَّذِيِ فِي حَقلِ المَكْفِيلَةِ. قُرْبَ مَمْرا فِي أرْضِ كَنْعانَ.» فَقَدِ اشْتَرَى إبْراهِيمُ ذَلِكَ الحَقلَ مِنْ عِفْرُونَ الحِثِّيِّ لِيَكُونَ مَقْبَرَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","وَدُفِنَ إبْراهِيمُ وَزَوْجَتُهُ سارَةُ هُناكَ. وَدُفِنَ أيضاً إسْحاقُ وَزَوْجَتُهُ رِفْقَةُ هُناكَ. وَهُناكَ دُفِنَتْ لَيئَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","اشْتُرِيَ الحَقلُ وَالكَهفُ الَّذِي فِيهِ مِنَ الحِثِّيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","وَلَمّا انتَهَى يَعقُوبُ مِنْ تَوْصِيَةِ أولادِهِ، سَحَبَ قَدَمَيهِ إلَى السَّرِيرِ. ثُمَّ لَفَظَ أنفاسَهُ الأخِيرَةَ. وَضُمَّ إلَى جَماعَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ثُمَّ انحَنَى يُوسُفُ فَوْقَ أبِيهِ، وَبَكَى عَلَيهِ، وَقَبَّلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","وَأمَرَ يُوسُفُ أطِبّاءَهُ الخاصِّينَ بِأنْ يُحَنِّطُوا أباهُ. فَحَنَّطَ الأطِبّاءُ إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","وَأمضُوا أيّامَ التَّحنِيطِ الأرْبَعِينَ. وَبَكَى عَلَيهِ المِصْرِيُّونَ سَبْعِينَ يَوماً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","وَلَمّا انتَهَتْ فَتْرَةُ الحِدادِ، تَحَدَّثَ يُوسُفُ إلَى بَيتِ فِرعَوْنَ وَقالَ: «إنْ كُنْتُمْ تُحِبُّونَنِي وَرَضِيتُمْ عَنِّي حَقّاً، فَتَكَلَّمُوا مَعَ فِرعَوْنَ وَقُولُوا لَهُ ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","إنَّ أبِي اسْتَحلَفَنِي وَقالَ لِي: ‹ها أنا أحتَضِرُ. فادْفِنِّي فِي القَبْرِ الَّذِي حَفَرْتُهُ لِنَفْسِي فِي أرْضِ كَنْعانَ.› فَأرجُو الآنَ أنْ تَسْمَحَ لِي بِأنْ أذْهَبَ وَأدفِنَ أبِي، وَبَعْدَ ذَلِكَ سَأعُودُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","فَقالَ لَهُ فِرعَوْنُ: «اذْهَبْ وَادفِنْ أباكَ كَما اسْتَحلَفَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","فَذَهَبَ يُوسُفُ لِيَدفِنَ أباهُ. وَذَهَبَ مَعَهُ كُلُّ وُزَراءِ فِرعَوْنَ وَشُيُوخِ بَيتِهِ وَكُلُّ وُجَهاءِ أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","وَذَهَبَ أيضاً كُلُّ بَيتِ يُوسُفَ وَإخوَتِهِ وَبُيُوتِهِمْ، وَلَمْ يَترُكُوا خَلْفَهُمْ فِي أرْضِ جاسانَ إلّا أطفالَهُمْ وَغَنَمَهُمْ وَبَقَرَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","وَخَرَجَتْ عَرَباتٌ وَفُرْسانٌ أيضاً مَعَهُ. فَكانَ جُمهُوراً عَظِيماً جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","وَوَصَلُوا إلَى بَيدَرِ أطادَ عَلَى الضِّفَّةِ الشَّرْقِيَّةِ لِنَهْرِ الأُردُنِّ. وَهُناكَ بَكُوا عَلَى يَعقُوبَ بُكاءً عالِياً مُرّاً. وَعَمِلَ يُوسُفُ هُناكَ مَناحَةً لِسَبْعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","وَرَأى سُكّانُ تِلْكَ المِنطَقَةِ مِنَ الكَنْعانِيِّينَ المَناحَةَ المُقامَةَ عَلَى بَيدَرِ أطادَ. فَقالُوا: «المِصْرِيُّونَ يَنُوحُونَ بِمَرارَةٍ.» فَسَمُّوا ذَلِكَ المَكانَ آبِلَ مِصْرايِمَ، وَهُوَ شَرْقُ نَهْرِ الأُردُنِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","وَهَكَذا فَعَلَ أولادُ يَعقُوبَ كَما أوصاهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","إذْ حَمَلُوهُ إلَى أرْضِ كَنْعانَ. ثُمَّ دَفَنُوهُ فِي الحَقلِ الَّذِيِ فِي حَقلِ المَكفِيلَةِ قُرْبَ مَمْرا. وَهُوَ الحَقلُ الَّذِي اشْتَراهُ إبْراهِيمُ مِنْ عِفْرُونَ الحِثِّيِّ لِيَكُونَ مَقْبَرَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ثُمَّ عادَ يُوسُفُ وَإخوَتُهُ وَكُلُّ الَّذِينَ جاءُوا مَعَهُ لِدَفْنِ أبِيهِ إلَى مِصْرَ، بَعْدَ أنْ دَفَنَ أباهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ثُمَّ أحَسَّ إخْوَةُ يُوسُفَ بِالخَوفِ، لِأنَّ أباهُمْ ماتَ. فَقالُوا: «رُبَّما يَحمِلُ يُوسُفُ ضَغِينَةً عَلَينا. وَرُبَّما يَجعَلُنا نَدفَعُ ثَمَنَ إساءَتِنا لَهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","فَأرْسَلُوا رِسالَةً إلَى يُوسُفَ تَقُولُ: أوصانا أبوكَ بِهَذا قَبلَ مَوْتِهِ فَقالَ لَنا: ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«قُولُوا لِيُوسُفَ: لَقَدْ أساءَ إلَيكَ إخْوَتُكَ حَقّاً. لَكِنْ أرجُو أنْ تُسامِحَهُمْ عَلَى جَرِيمَتِهِمْ وَخَطِيَّتِهِمْ.» فَالآنَ أرجُو أنْ تَغْفِرَ جَرِيمَةَ خُدّامِ إلَهِ أبِيكَ. فَبَكَى يُوسُفُ بِسَبَبِ رِسالَتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","وَذَهَبَ إلَيهِ إخْوَتُهُ أيضاً. وَألقُوا بِأنفُسِهِمْ أمامَهُ وَقالُوا: «ها نَحنُ عَبِيدٌ لَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","لَكِنَّ يُوسُفَ قالَ لَهُمْ: «لا تَخافُوا، فَهَلْ أنا اللهُ لِأُدِينَكُمْ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","أنتُمْ نَوَيتُمْ بِي شَرّاً، لَكِنَّ اللهَ نَوَى بِهِ خَيراً. فَقَدْ قَصَدَ اللهُ أنْ يُحَقِّقَ النَّتائِجَ الحالِيَّةَ: أنْ يُبْقِيَ عَلَى حَياةِ كَثِيرِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","فَلا تَخافُوا. وَأنا سَأعُولُكُمْ وَأعُولُ أطفالَكُمْ.» وَهَكَذا طَمْأنَهُمْ وَطَيَّبَ قُلُوبَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","فَبَقِيَ يُوسُفُ وَبَيتُ أبِيهِ فِي مِصْرَ. وَعاشَ يُوسُفُ مِئَةً وَعَشْرَ سِنِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","وَعاشَ يُوسُفَ لِيَرَى أبْناءَ أفْرايِمَ وَأحفادَهُ. وَنُسِبَ أبْناءُ ماكِيرَ بْنِ مَنَسَّى إلَى يُوسُفَ. ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","وَقالَ يُوسُفُ لإخوَتِهِ: «أنا أحتَضِرُ، لَكِنَّ اللهَ سَيَهْتَمُّ بِكُمْ وَسَيُخْرِجُكُمْ مِنْ هَذَهِ الأرْضِ إلَى الأرْضِ الَّتِي وَعَدَ بِها إبْراهِيمَ وَإسْحاقَ وَيَعقُوبَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","وَاسْتَحلَفَ يُوسُفُ أبْناءَ إسْرائِيلَ وَقالَ: «عِندَما يَأْتِي اللهُ إلَيكُمْ وَيُخْرِجُكُمْ، احمِلُوا عِظامِي مِنْ هُنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","وَماتَ يُوسُفُ بَعْدَ أنْ عاشَ مِئَةً وَعَشَرَ سَنَواتٍ. فَحَنَّطُوهُ وَوَضَعُوهُ فِي تابُوتٍ فِي مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","هَذِهِ هِيَ أسْماءُ أبْناءِ إسْرائِيلَ الَّذِينَ ذَهَبُوا إلَى مِصرَ مَعَ يَعقُوبَ وَمَعَ عائِلاتِهِمْ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","رَأُوبَيْنُ وَشِمْعُونُ وَلاوِي وَيَهُوذا ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","وَيَسّاكَرُ وَزَبُولُونُ وَبَنْيامِيْنُ ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","وَدانٌ وَنَفتالِي وَجادٌ وَأشِيرُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","وَكانَ مَجمُوعُ أفْرَادِ نَسلِ يَعقُوبَ سَبعِينَ. وَعاشَ يُوسُفُ فِي مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","وَماتَ يُوسُفُ وَإخوَتُهُ وَكُلُّ ذَلِكَ الجِيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","وَأمّا بَنُو إسْرائِيلَ فَقَدْ أثْمَرُوا وَازدادَ عَدَدُهُمْ. فَكَثُرُوا جِدّاً وَصارُوا أقْوِياءَ حَتَّى إنَّ الأرْضَ امْتَلأتْ مِنْهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","وَوَصَلَ مَلِكٌ جَدِيدٌ إلَى السُّلطَةِ فِي مِصرَ. وَلَمْ يَكُنْ هَذا المَلِكُ قَدْ عَرَفَ يُوسُفَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","فَقالَ مَلِكُ مِصرَ لِشَعبِهِ: «بَنُو إسْرائِيلَ أكثَرُ عَدَداً وَقُوَّةً مِنّا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","فَلْنَضَعْ خُطَّةً لِمَنعِهِمْ مِنَ التَّزايُدِ فِي العَدَدِ وَالقُوَّةِ. فَإنْ لَمْ نَفعَلْ ذَلِكَ، سَيَنْضَمُّونَ إلَى أعدائِنا وَيُحارِبُونَنا، ثُمَّ يَهرُبُونَ مِنَ الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","فَعَيَّنَ المِصرِيُّونَ مُشْرِفِينَ لِيُضَيِّقُوا عَلَيهِمْ بِأعْمالٍ شاقَّةٍ. وَبَنَى بَنُو إسْرائِيلَ مَدينَتَيْ مَخازِنَ لِفِرْعَوْنَ هُما فِيثُومُ وَرَعَمْسِيسُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","وَبِالرُّغْمِ مِنْ مُضايِقَةِ المِصرِيِّينَ لَهُمْ كانُوا يَتَكاثَرُونَ وَيَزدادُونَ. فَصارَ المِصرِيُّونَ يَخافُونَ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","وَاستَعبَدُوا بَنِي إسْرائِيلَ وَأجبَرُوهُمْ عَلَى القِيامِ بِأعمالٍ شاقَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","وَجَعَلَ المِصرِيُّونَ حَياةَ بَنِي إسْرائِيلَ مُرَّةً. أجبَرُوهُمْ عَلَى العَمَلِ فِي الطِّينِ وَالطُّوبِ وَكُلِّ أعمالِ الحُقُولِ. وَقَدْ قَسَوْا عَلَيهِمْ فِي جَميعِ الأعمالِ الَّتِي أجبَرُوهُمْ عَلَيها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","وَكانَتْ هُناكَ قابِلَتانِ عِبرانِيَّتانِ تُدْعَيانِ شِفْرَةَ وَفُوعَةَ. فَقالَ مَلِكُ مِصرَ لَهُما: ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«حِينَ تُساعِدانِ النِّساءَ العِبْرانِيّاتِ فِي الوِلادَةِ وَهُنَّ عَلَى سَرِيرِ الوِلادَةِ، انْظُرا إلَى المَولودِ، فَإذا كانَ وَلَداً فاقتُلاهُ، وَإنْ بِنتاً فاترُكاها لِتَعِيشَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","لَكِنَّ القابِلَتَيْنِ كانَتا تَخافانِ اللهَ، فَلَمْ تَفعَلا كَما طَلَبَ مِنهُما مَلِكُ مِصرَ، بَلْ تَرَكَتا الأولادَ لِيَعِيشُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","فَدَعا مَلِكُ مِصْرَ القابِلَتَيْنِ وَقالَ لَهُما: «لِماذا عَمِلْتُما هَذِا وَتَرَكْتُما الأولادَ يَعِيشُونَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","فَقالَتِ القابِلَتانِ لِفِرْعَونَ: «النِّساءُ العِبرانِيّاتُ لَسْنَ كَالمِصرِيّاتِ، فَهُنَّ قَوِيّاتٌ، فَيَلِدْنَ سَرِيعاً قَبلَ وُصُولِ القابِلاتِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","وَبارَكَ اللهُ القابِلَتَيْنِ. وَكَثُرَ بَنُو إسْرائِيلَ وَصارُوا أقوِياءَ جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","وَأعطَى اللهُ عائِلاتٍ لِلقابِلَتَيْنِ لِأنَّهُما خافَتاهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ثُمَّ أصدَرَ فِرعَوْنُ أمراً لِشَعبِهِ وَقالَ: «كُلُّ وَلَدٍ يُولَدُ لِلعِبْرانِيِّينَ، ألقُوهُ فِي نَهرِ النِّيلِ، وَاسْتَبقُوا حَياةَ البَناتِ فَقَطْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","وَتَزَوَّجَ رَجُلٌ مِنْ قَبِيلَةِ لاوِي مِنِ امْرأةٍ مِنْ قَبِيلَةِ لاوِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","فَحَبِلَتِ المَرأةُ وَوَلَدَتْ وَلَداً. وَحِينَ رَأتْ أنَّهُ طِفلٌ جَمِيلٌ خَبَّأتْهُ لِمُدَّةِ ثَلاثَةِ أشهُرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","لَكِنَّها لَمْ تَسْتَطِعْ الاستِمرارَ فِي إخفائِهِ، فَأحْضَرَتْ سَلَّةً مَصنُوعَةً مِنَ القَصَبِ، وَسَدَّتْ ثُقُوبَها بِالزِّفتِ وَالقارِ، وَوَضَعَتِ الوَلَدَ فِيها. ثُمَّ وَضَعَتْها بَينَ القَصَبِ عَلَى ضِفَّةِ نِهْرِ النِّيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","وَكانَتْ أُختُهُ تُراقِبُ مِنْ بَعِيدٍ لِتَرَى ما سَيَحدُثُ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","وَنَزَلَتِ ابْنَةُ فِرعَوْنَ لِتَسْتَحِمَّ فِي نَهرِ النِّيلِ، بَينَما كانَتْ خادِماتُها مَعَها عَلَى ضِفَّةِ النَّهرِ. وَرَأتِ ابْنَةُ فِرعَوْنَ السَّلَّةَ بَينَ القَصَبِ، فَأرسَلَتْ خادِماتِها لإحضارِها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","وَلَمَّا فَتَحَتِ ابْنَةُ فِرعَوْنَ السَّلَّةَ، رَأتِ الطِّفلَ. وَكانَ الطِّفلُ يَبكِي، فَأشفَقَتْ عَلَيهِ، وَقالَتْ فِي نَفسِها: «هَذا مِنْ أولادِ العِبْرانِيِّينَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","فَقالَتْ أُختُ الطِّفلِ لابْنَةِ فِرعَوْنَ: «هَلْ تَرغَبِينَ فِي أنْ أذهَبَ وَأُحضِرَ لَكِ مُرضِعَةً مِنَ النِّساءِ العِبرانِيّاتِ لِتُرضِعَهُ لَكِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","فَقالَتِ ابْنَةُ فِرعَوْنَ: «اذهَبِي!» فَذَهَبَتِ الفَتاةُ وَدَعَتْ أُمَّ الطِّفلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","وَقالَتِ ابْنَةُ فِرعَوْنَ لَها: «خُذِي هَذا الطِّفلَ وَأرْضِعِيهِ لِي، وَسَأدفَعُ لَكِ أُجرَتَكِ.» فَأخَذَتِ المَرأةُ الطِّفلَ وَأرْضَعَتْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","وَحِينَ كَبِرَ الوَلَدُ بِما يَكفِي لِيُفطَمَ، أحضَرَتهُ إلَى ابْنَةِ فِرعَوْنَ، فَتَبَنَّتْهُ. وَدَعَتِ ابْنَةُ فِرعَوْنَ الطِّفلَ مُوسَى لِأنَّها قالَتْ: «قَدْ نَشَلْتُهُ مِنَ الماءِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","وَحِينَ كَبِرَ مُوسَى خَرَجَ إلَى شَعبِهِ لِيَرَى ما يُعانُونَهُ مِنْ مَشَقّاتٍ. وَحِينَ رَأى رَجُلاً مِصرِيّاً يَضْرِبُ رَجُلاً عِبرانِيّاً مِنْ إخْوَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","تَلَفَّتَ مُوسَى حَولَهُ، وَإذْ لَمْ يَرَ أحَداً، قَتَلَ المِصرِيَّ وَدَفَنَهُ فِي الرِّمالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","وَحِينَ خَرَجَ مُوسَى فِي اليَومِ التّالِي، كانَ هُناكَ رَجُلانِ عِبْرانِيّانِ يَتَشاجَرانِ، فَقالَ لِلمُعتَدِي: «لِماذا تَضرِبُ رَفِيقَكَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","فَقالَ لَهُ المُعتَدِي: «مَنْ نَصَّبَكَ حاكِماً وَقاضِياً عَلَينا؟ أتَنْوِي أنْ تَقتُلَنِي كَما قَتَلتَ المِصرِيَّ؟» حِينَئِذٍ، خافَ مُوسَى وَانتَبَهَ إلَى أنَّ الأمرَ قَدِ انْكَشَفَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","وَحِينَ سَمِعَ فِرعَوْنُ بِالأمرِ، أصْدَرَ حُكْماً بِإعْدامِ مُوسَى. فَهَرَبَ مُوسَى مِنْ فِرعَوْنَ وَسَكَنَ فِي أرْضِ مِدْيانَ. وَكَانَ مُوسَى قَدْ جَلَسَ عِنْدَ بِئْرٍ فِي مِدْيانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","وَكانَ لِكاهِنِ مِدْيانَ سَبعُ بَناتٍ. وَكُنَّ قَدْ أتَينَ لِيَستَقِينَ ماءً لِيَملأْنَ الأحواضَ لِسِقايَةِ أغنامِ أبِيهِنَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","لَكِنَّ الرُّعاةَ أتَوْا وَطَرَدُوهُنَّ. فَقامَ مُوسَى وَأنقَذَهُنَّ وَسَقَى أغنامَهُنَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","وَحِينَ أتَيْنَ إلَى رَعُوئِيلَ أبِيهِنَّ، سَألَهُنَّ رَعُوئِيلُ: «لِماذا رَجِعتُنَّ سَرِيعاً اليَومَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","فَأجَبْنَهُ: «رَجُلٌ مِصرِيٌّ أنقَذَنا مِنَ الرُّعاةِ. ثُمَّ نَشَلَ الماءَ لَنا وَسَقَى الغَنَمَ!» ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","فَقالَ رَعُوئِيلُ لِبَناتِهِ: «وَأينَ هُوَ؟ لِماذا تَرَكْتُنَّ الرَّجُلَ فِي الخارِجِ؟ ادْعُونَهُ لِيَأْكُلَ مَعَنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","فَوافَقَ مُوسَى أنْ يَعِيشَ مَعَهُ. وَأعطَى رَعُوئِيلُ ابْنَتَهُ صَفُّورَةَ زَوجَةً لِمُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","فَحَبِلَتْ وَوَلَدَتْ وَلَداً. وَقالَ مُوسَى: «كُنتُ غَرِيباً فِي أرْضٍ غَرِيبَةٍ.» فَدَعا اسْمَ الطِّفلِ جِرْشُومَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","وَبَعدَ سِنِينَ كَثِيرَةٍ، ماتَ مَلِكُ مِصرَ. وَكانَ بَنُو إسْرائِيلَ يَئِنُّونَ بِسَبَبِ العُبُودِيَّةِ، وَقَدْ صَرَخُوا إلَى اللهِ طَلَباً لِلعَونِ. فَسَمِعَ اللهُ صُراخُهُمْ لِلخَلاصِ مِنَ العُبُودِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","سَمِعَ اللهُ أنِينَهُمْ، وَتَذَكَّرَ عَهدَهُ مَعَ إبراهِيمَ وَإسْحاقَ وَيَعقُوبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","نَظَرَ اللهُ إلَى بَنِي إسْرائِيلَ وَهَوَ يَعلَمُ ماذا سَيَفعَلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","وَذاتَ مَرَّةٍ، كانَ مُوسَى يَرعَى غَنَمَ يَثْرُونَ حَميهِ وَكاهِنِ مِدْيانَ. فَقادَ الغَنَمَ إلَى الجِهَةِ الأُخرَى مِنَ البَرِّيَّةِ، وَجاءَ إلَى جَبَلِ حُورِيبَ، الجَبَلِ الَّذِي ظَهَرَ فِيهِ اللهُ! ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","وَهُناكَ ظَهَرَ لَهُ مَلاكُ اللهِ فِي لَهيبِ نارٍ يأتِي مِنْ شُجَيْرَةٍ. وَنَظَرَ مُوسَى إلَيها فَرَأى الشُّجَيْرَةَ مُشتَعِلَةً، لَكِنَّها لَمْ تَكُنْ تَحتَرِقُ! ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","فَقالَ مُوسَى: «لأذْهَبْ إلَى هُناكَ وَأرَ هَذا المَشهَدَ العَجِيبَ، وَأعْرِفْ لِماذا لا تَحتَرِقُ الشُّجَيْرَةُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","فَلَمّا رَأى اللهُ مُوسَى يَقتَرِبُ لِيُلقِيَ نَظرَةً عَنْ قُرْبٍ، ناداهُ اللهُ مِنْ وَسَطِ الشُّجَيْرَةِ وَقالَ لَهُ: «مُوسَى! مُوسَى!» فَأجابَ مُوسَى: «ها أنا!» ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","فَقالَ لَهُ: «لا تَقتَرِبْ أكثَرَ! اخلَعْ حِذاءَكَ مِنْ قَدَمَيكَ، فَالمَكانُ الَّذِي تَقِفُ عَلَيهِ أرْضٌ مُقَدَّسَةٌ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ثُمَّ قالَ: «أنا إلَهُ أبِيكَ، إلَهُ إبْراهِيمَ وَإلَهُ إسْحاقَ وَإلَهُ يَعقُوبَ.» فَغَطَّى مُوسَى وَجهَهُ لِأنَّهُ خافَ أنْ يَنْظُرَ إلَى اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ثُمَّ قالَ اللهُ: «قَدْ رَأيتُ ضِيقَ شَعبِيَ الَّذِينَ فِي مِصرَ، وَسَمِعْتُ صُراخَهُمْ بِسَبَبِ مُضُايِقِيهِمْ. فأنا أعلَمُ آلامَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","وَنَزَلْتُ لِكَي أُحَرِّرَهُمْ مِنَ المِصْريّينِ، وَلِأُخرِجَهُمْ مِنْ تِلكَ الأرْضِ إلَى أرْضٍ خَصْبَةٍ وَواسِعَةٍ، أرْضٍ تَفِيضُ لَبَناً وَعَسَلاً. هِيَ أرْضُ الكَنعانِيِّينَ وَالحِثِّيِّينَ وَالأمُورِيِّينَ وَالفَرِزِّيِّينَ وَالحِوِّيِّينَ وَاليَبُوسِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","«وَالآنَ قَدْ وَصَلَ صُراخُ بَني إسْرائِيلَ إلَيَّ، وَقَدْ رَأيتُ الضِّيقَ الَّذِي يُسَبِّبُهُ المِصرِيُّونَ لَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","فَاذْهَبْ إلَى هُناكَ. ها أنا أُرسِلُكَ إلَى فِرعَوْنَ لِتُخرِجَ شَعبِيَ، بَنِي إسْرائِيلَ، مِنْ مِصرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","فَقالَ مُوسَى: «مَنْ أنا حَتَّى أذهَبَ إلَى فِرعَوْنَ وَأُخرِجَ بَنِي إسْرائِيلَ مِنْ مِصرَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","فَقالَ: «اذْهَبْ وَأنا سَأكُونُ مَعَكَ. أمّا العَلامَةُ عَلَى أنَّني أرْسَلْتُكَ، فَهِيَ أنَّكَ حِينَ تُخرِجُ شَعبِي مِنْ مِصرَ، سَتَعبُدُونَني عَلَى هَذا الجَبَلِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","وَقالَ مُوسَى: «حِينَ أذهَبُ إلَى بَني إسْرائِيلَ وَأقُولُ لَهُمْ: ‹إلَهُ آبائِكُمْ أرسَلَنِي إلَيكُمْ.› سَيَقُولُونَ لِي: ‹ما اسْمُهُ؟› فَماذا أقُولُ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","فَقالَ اللهُ لِمُوسَى: «إهْيِهْ أشِرْ إهْيِهْ. قُلْ لِبَني إسْرائِيلَ: ‹إهْيِهْ أرسَلَنِي إلَيكُمْ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","وَقالَ أيضاً لِمُوسَى: «قُلْ لِبَنِي إسْرائِيلَ: ‹يهوه إلَهُ آبائِكُمْ، إلَهُ إبراهِيمَ وَإلَهُ إسحَاقَ وَإلَهُ يَعقُوبَ أرسَلَنِي إلَيكُمْ. هَذا اسْمِي إلَى الأبَدِ، وَلَقَبِي فِي كُلِّ جِيلٍ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","«اذْهَبْ وَاجمَعْ شُيُوخَ إسْرائِيلَ، وَقُلْ لَهُمْ: يهوه إلَهُ آبائِكُمْ، إلَهُ إبراهِيمَ وَإلَهُ إسحَاقَ وَإلَهُ يَعقُوبَ ظَهَرَ لِي وَقالَ: ‹راقَبْتُكُمْ وَرَأيتُ ما عَمِلَهُ المِصرِيُّونَ مَعَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","وَقَرَّرْتُ أنْ أُخرِجَكُمْ مِنْ ضِيقِكُمْ مِنْ مِصرَ إلَى أرْضِ الكَنعانِيِّينَ وَالحِثِّيِّينَ وَالأمُورِيِّينَ وَالفِرِزِّيِّينَ وَالحِوِّيِّينَ وَاليَبُوسِيِّينَ، إلَى أرْضٍ تَفيضُ لَبناً وَعَسَلاً.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«سَيَسْتَمِعُ الشُّيُوخُ إلَيكَ. حِينَئِذٍ، تَذْهَبُ أنتَ وَشُيُوخُ إسْرائِيلَ إلَى مَلِكِ مِصرَ وَتَقُولُونَ لَهُ: ‹يهوه إلَهُ العِبرانِيِّينَ تَجَلَّى لَنا، فَدَعْنا الآنَ نَذهَبْ فِي رِحلَةٍ ثَلاثَةَ أيّامٍ فِي البَرِّيَّةِ كَي نُقَدِّمَ ذَبائِحَ لِيهوه إلَهِنا.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","«لَكِنَّ مَلِكَ مِصرَ لَنْ يَسمَحَ لَكُمْ بِالذَّهابِ إلّا مُجْبَراً بِالقُوَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","حِينَئِذٍ، سَأمُدُّ يَدِي لِأضْرِبَ مِصرَ بِكُلِّ العَجائِبِ الَّتِي سَأعمَلُها. بَعْدَ ذَلِكَ، سَيُطلِقُكُمْ فِرعَوْنُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","سَأجعَلُ المِصرِيِّينَ كُرَماءَ مَعَكُمْ، فَلا تَخرُجُونَ فارِغِي الأيدِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","وَسَتَطلُبُ كُلُّ امْرأةٍ مِنْ جارَتِها أوْ مِمَّنْ تُقِيمُ فِي بَيتِها فِضَّةً وَذَهَباً وَثِياباً، وَسَتَضَعُونَها عَلَى أولادِكُمْ وَبَناتِكُمْ. وَهَكَذا سَتَأْخُذُونَ ثَروَةً مِنْ مِصرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","فَأجابَ مُوسَى: «وَماذا إنْ لَمْ يُصَدِّقُونِي أوْ يَستَمِعُوا إلَيَّ؟ فَسَيَقُولُونَ: ‹لَمْ يَظهَرْ لَكَ يهوه حَقّاً.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","فَقالَ لَهُ اللهُ: «ماذا فِي يَدِكَ؟» فَقالَ مُوسَى: «عَصاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","فَقالَ: «ألقِ بِها إلَى الأرْضِ.» فَألْقاها، فَصارَتْ ثُعْباناً! فَهَرَبَ مُوسَى مِنهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","وَقالَ اللهُ لِمُوسَى: «مُدَّ يَدَكَ وَامسِكْهُ مِنْ ذَيلِهِ.» فَحِينَ مَدَّ يَدَهُ وَأمسَكَهُ تَحَوَّلَ ثانِيَةً إلَى عَصاً فِي يَدِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","فَقالَ اللهُ: «هَذا لِكَي يُصَدِّقُوا أنَّ اللهَ إلَهَ آبائِهِمْ، إلَهَ إبْراهِيمَ وَإلَهَ إسْحاقَ وَإلَهَ يَعقُوبَ، قَدْ ظَهَرَ لَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","وَقالَ اللهُ لَهُ ثانِيَةً: «أدخِلْ يَدَكَ إلَى صَدْرِكَ.» فَأدخَلَ مُوسَى يَدَهُ إلَى صَدرِهِ. وَحِينَ أخرَجَها كانَتْ بَرْصاءَ كَلَونِ الثَّلجِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","فَقالَ اللهُ لَهُ: «أدخِلْ يَدَكَ ثانِيَةً إلَى صَدرِكَ.» فَأدخَلَ يَدَهُ إلَى صَدرِهِ ثانِيَةً. وَحِينَ أخرَجَها مِنْ صَدرِهِ عادَتْ كَباقِي جَسَدِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","فَقالَ اللهُ: «إنْ لَمْ يُصَدِّقُوكَ أوْ يَنتَبِهُوا لِلمُعجِزَةِ الأُولِى، فَسَيُصَدِّقُونَ المُعجِزَةَ الثّانِيَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","وَإنْ لَمْ يُصَدِّقُوا هاتَينِ المُعجِزَتَينِ وَلَمْ يَستَمِعُوا لَكَ، فَحِينَئِذٍ، خُذْ مِنْ ماءِ نَهرِ النِّيلِ وَاسكُبْهُ عَلَى اليابِسَةِ، فَيَصيرَ الماءُ دَماً عَلَى الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","وَقالَ مُوسَى للهِ: «اسْمَعْنِي أيُّها الرَّبُّ، أنا خادِمَكَ لا أُحسِنُ الكَلامَ، لا فِي الماضِي وَلا مُنذُ تَكَلَّمْتَ إلَيَّ. فَأنا بَطِيءُ الكَلامِ وَثَقِيلُ اللِّسانِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","فَقالَ اللهُ لَهُ: «مَنِ الَّذِي يُعطِي لِلإنسانِ فَهْماً، أوْ يَجعَلُ الإنسانَ أخرَسَ أوْ أصَمَّ أوْ أعرَجَ أوْ أعمَى؟ ألَيسَ أنا، اللهَ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","وَالآنَ اذْهَبْ. سَأكُونُ مَعَ فَمِكَ وَسَأُعَلِّمُكَ ماذا تَقُولُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","وَلَكِنَّ مُوسَى قالَ: «أرجُوكَ يا رَبُّ أنْ تُرْسِلَ شَخصاً آخَرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","حِينَئِذٍ، غَضِبَ اللهُ مِنْ مُوسَى، وَقالَ لَهُ: «ألَيسَ هارُونُ الَّلاوِيُّ أخاكَ؟ أعلَمُ أنَّهُ يُحْسِنُ الكَلامَ، وَهُوَ سَيَأتِي لِلِقائِكَ، وَحِينَ يَراكَ سَيَفرَحُ مِنْ كُلِّ قَلبِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","تَستَطِيعُ أنْ تَتَكَلَّمَ إلَيهِ بِكُلِّ ما تُرِيدُهُ أنْ يَقُولَ. سَأكُونُ مَعَ فَمِكَ وَفَمِهِ، وَسَأُعَلِّمُكَ ماذا تَفعَلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","هُوَ سَيَتَكَلَّمُ إلَى النّاسِ نِيابَةً عَنْكَ. فَكَأنَّهُ فَمُكَ، وَكَأنَّكَ إلَهُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","وَخُذْ هَذِهِ العَصا فِي يَدِكَ، فَبِواسِطَتِها سَتَصنَعُ المُعجِزاتِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","وَرَجِعَ مُوسَى إلَى يَثْرُونَ حَمِيهِ، وَقالَ لَهُ: «اسْمَحْ لِي بِالرُّجُوعِ إلَى إخْوَتِي فِي مِصرَ لِأرَى إنْ كانُوا ما يَزالُونَ أحياءَ.» فَقالَ يَثْرُونُ لِمُوسَى: «اذْهَبْ بِسَلامٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","فَقالَ اللهُ لِمُوسَى فِي مِدْيانَ: «ارجِعْ إلَى مِصرَ لِأنَّ كُلَّ الَّذِينَ كانُوا يُرِيدُونَ قَتلَكَ ماتُوا.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","فَأخَذَ مُوسَى زَوجَتَهُ وَأولادَهُ وَأركَبَهُمْ عَلَى دَوَابٍ، وَرَجِعَ إلَى أرْضِ مِصرَ. وَأخَذَ عَصا اللهِ فِي يَدِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","وَقالَ اللهُ لِمُوسَى: «حِينَ تَرجِعُ إلَى مِصرَ، تَذَكَّرِ المُعجِزاتِ الَّتِي وَضَعْتُها فِي يَدِكَ، وَاصْنَعْها أمامَ فِرعَوْنَ. لَكِنِّي سَأجعَلُهُ يُعانِدُ حَتَّى لا يُطلِقَ الشَّعبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","قُلْ لِفِرْعَونَ: ‹يَقُولُ اللهُ: إسْرائِيلُ ابْنِي البِكْرُ،› ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","وَأنا أقُولُ لَكَ: ‹أطلِقِ ابْنِيَ لِيَعبُدَنِي. وَإلّا فَإنّي سَأقتُلُ ابْنَكَ البِكْرَ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","وَتَوَقَّفُوا لِلاسْتِراحَةِ فِي الطَّرِيقِ. فَالتَقَى اللهُ بِمُوسَى لِكَي يَقتُلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","وَلَكِنَّ زَوجَتَهُ صَفُّورَةَ أخَذَتْ قِطْعَةَ صُوّانٍ حادَّةً وَخَتَنَتِ ابْنَها. ثُمَّ أخَذَتْ غُلفَةَ ابْنِها وَمَسَّتْ بِها قَدَمَيَّ مُوسَى، وَقالَتْ لَهُ: «أنْتَ زَوْجُ دَمٍ لِيَ!» ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","فَشُفِيَ. وَكانَتْ صَفُّورَةُ قَدْ دَعَتْ مُوسَى «زَوْجَ دَمٍ» بِسَبَبِ الخِتانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","وَفِي هَذِهِ الأثناءِ، تَكَلَّمَ اللهُ إلَى هارُونَ فَقالَ: «اذْهَبْ وَالتَقِ بِمُوسَى فِي الصَّحْراءِ.» فَذَهَبَ وَالتَقَى بِهِ فِي جَبَلِ اللهِ وَقَبَّلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","وَأخبَرَ مُوسَى هارُونَ بِكُلِّ ما قالَهُ اللهُ لَهُ وَبِكُلِّ المُعجِزاتِ الَّتِي أمَرَهُ بِعَمَلِها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","فَذَهَبَ مُوسَى وَهارُونُ وَجَمَعا كُلَّ شُيُوخِ إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","وَأخبَرَ هارُونُ الشَّعبَ بِكُلِّ الأُمُورِ الَّتِي قالَها اللهُ لِمُوسَى، وَعَمِلَ المُعجِزاتِ أمامَ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","فَآمَنَ الشَّعبُ. وَحِينَ سَمِعُوا أنَّ اللهَ مُهْتَمٌّ بِبَنِي إسْرائِيلَ، وَأنَّهُ رَأى الذُّلَّ الَّذِي هُمْ فِيهِ، انحَنَوْا وَسَجَدُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","وَبَعدَ ذَلِكَ، ذَهَبَ مُوسَى وَهارُونُ وَتَكَلَّما إلَى فِرعَوْنَ وَقالُوا لَهُ: «هَكَذا يَقُولُ يهوه إلَهُ إسْرائِيلَ: ‹أطلِقْ شَعبِي لِيَحتَفِلُوا بِعِيدٍ لِي فِي الصَّحْراءِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","وَلَكِنَّ فِرعَوْنَ قالَ: «مَنْ هُوَ يهوه هَذا حَتَّى أُطِيعَهُ وَأُطلِقَ الشَّعبَ؟ أنا لا أعرِفُ يهوه هَذا، وَلَنْ أُطلِقَهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","فَقالا لَهُ: «إلَهُ العِبْرانِيِّينَ تَجَلَّى لَنا، فَدَعْنا نَذهَبْ فِي رِحلَةٍ ثَلاثَةَ أيّامٍ فِي البَرِّيَّةِ كَي نُقَدِّمَ ذَبائِحَ لِيهوه إلَهِنا، كَي لا يَقْتُلَنا بِالأمْراضِ وَالحُرُوبِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","وَلَكِنَّ مَلِكَ مِصرَ قالَ لَهُمْ: «لِماذا، يا مُوسَى وَهارُونُ، تُعَطِّلانِ الشَّعبَ عَنِ القِيامِ بِعَمَلِهِ؟ ارْجِعا إلَى العَمَلِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","وَقالَ فِرعَوْنُ: «شَعبُ الأرْضِ كَثِيرُونَ، وَأنتُما تَعُوقانِهِمْ عَنِ القِيامِ بِأعمالِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","وَفِي ذَلِكَ اليَومِ، أعطَى فِرعَوْنُ هَذا الأمرَ لِمُذَلِّلي الشَّعبِ وَالمُشْرِفِينَ عَلَيهِ، فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«لا تُعطُوا قَشّاً لِلشَّعبِ لِصُنعِ الطُّوبِ فِيما بَعْدُ كَما فِي السّابِقِ، بَلْ لِيَجُولُوا وَيَجمَعُوا القَشَّ بِأنفُسِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","بَلِ افرِضُوا عَلَيهِمْ تَقدِيمَ كَمِّيَّةِ الطُّوبِ ذاتِها الَّتِي كانُوا يَصنَعُونَها سابِقاً. لا تُقَلِّلُوا الكَمِّيَّةَ، لِأنَّهُمْ كَسالَى، لِذَلِكَ فَهُمْ يَتَذَمَّرُونَ وَيَقُولُونَ: ‹اسْمَحْ لَنا أنْ نَذهَبَ وَنُقَدِّمَ ذَبائِحَ لإلَهِنا.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","كَثِّرُوا العَمَلَ عَلَى الشَّعبِ فَيَنشَغِلُوا عَنِ الاسْتِماعِ إلَى الكَلامِ الفارِغِ وَالخادِعِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","فَخَرَجَ مُذَلِّلو الشَّعبِ وَالمُشرِفُونَ عَلَيهِ وَقالُوا لِلشَّعبِ: «هَكَذا يَقُولُ فِرعَوْنُ: ‹لَنْ أُعطِيَكُمْ قَشّاً.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","فاذهَبُوا وَاجْمَعُوا القَشَّ مِنْ أيِّ مَكانٍ تَجِدُونَهُ. لَكِنَّ كَمِّيَّةَ الطُّوبِ المَطلُوبَةَ لَنْ تَنقُصَ أبَداً.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","فانتَشَرَ الشَّعبُ فِي أنحاءِ مِصرَ لِيَجمَعُوا القَشَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","وَكانَ المُذَلِّلونَ يَستَعجِلُونَهُمْ وَيَقُولُونَ: «أنْجِزُوا العَمَلَ اليَومِيَّ المَطلُوبَ، كَما كُنتُمْ حِينَ كانَ القَشُّ يُعطَى لَكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","لَكِنَّ المُشرِفِينَ عَلَى بَنِي إسْرائِيلَ الَّذِينَ عَيَّنَهُمْ رِجالُ فِرعَوْنَ عَلَى الشَّعبِ، تَعَرَّضُوا للضَّرْبِ، وَسُئِلوا: «لِماذا لَمْ تُكمِلُوا حِصَّتَكُمْ مِنَ الطُّوبِ كَما كُنتُمْ تَعمَلُونَ فِي الماضِي؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","فَذَهَبَ المُشرِفُونَ إلَى فِرعَوْنَ وَاشتَكُوا أمامَهُ وَقالُوا: «لِماذا تُعامِلُ عَبِيدَكَ هَكَذا؟ ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","فَمَعْ أنَّ القَشَّ لا يُعطَى لِخُدّامِكَ، إلّا أنَّ المُذَلِّلينَ يَستَمِرُّونَ فِي طَلَبِ المِقدارِ ذاتِهِ مِنَ الطُّوبِ. ها نَحنُ خُدّامَكَ نُضْرَبُ، وَأنتَ تَظلِمُ شَعبَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","فَأجابَ فِرعَوْنُ: «إنَّكُمْ كَسالَى، وَلِهَذا قُلْتُمْ: ‹لِنَذهَبْ وَنُقَدِّمْ ذَبائِحَ للهِ.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","وَالآنَ عُودُوا إلَى العَمَلِ. القَشُّ لَنْ يُعطَى لَكُمْ، وَيَنبَغِي أنْ تُنْتِجُوا المِقدارَ ذاتَهُ مِنَ الطُّوبِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","وَرَأى المُشرِفُونَ عَلَى بَنِي إسْرائِيلَ أنَّهُمْ فِي مُشكِلَةٍ وَضِيقٍ حِينَ قِيلَ لَهُمْ: «لا تُقَلِّلُوا مِنْ مِقدارِ الطُّوبِ، بَلْ تُنتِجُونَ كُلَّ يَومٍ ما كُنتُمْ تُنتِجُونَهُ قَبلاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","وَوَجَدَ المُشرِفُونَ مُوسَى وَهارُونَ فِي انتِظارِهِمْ حِينَ خَرَجُوا مِنْ عِندِ فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","فَقالُوا لَهُما: «فَلْيَنظُرِ اللهُ إلَيكُما وَيُعاقِبْكُما لِأنَّكُما جَعَلْتُمانا مَبْغُوضِينَ لَدَى فِرعَوْنَ وَخُدّامِهِ، وَقَدْ وَضَعتُما سَيفاً فِي يَدِهِمْ لِيَقتُلُونا.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","وَعادَ مُوسَى إلَى اللهِ، وَقالَ: «يا رَبُّ، لِماذا سَبَّبْتَ هَذِهِ الكارِثَةَ لِهَذا الشَّعبِ؟ لِماذا أرسَلْتَنِي؟ ");
INSERT INTO arbwbtc_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","فَمُنذُ أتَيتُ إلَى فِرعَوْنَ لِأتَكَلَّمَ بِاسْمِكَ، ساءَتْ أُمُورُ هَذا الشَّعبِ. كَما أنَّكَ لَمْ تُنقِذْ شَعبَكَ!» ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","فَقالَ اللهُ لِمُوسَى: «سَتَرَى ما سَأفعَلُهُ بِفِرْعَونَ، فَيُرسِلَهُمْ بِقُوَّتِهِ وَيُخْرِجَهُمْ مِنْ مِصرَ، مِنْ أرْضِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","وَكَلَّمَ اللهُ مُوسَى وَقالَ لَهُ: «أنا يهوه ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ظَهَرْتُ لإبراهِيمَ وَإسْحاقَ وَيَعقُوبَ بِصِفَتِي اللهَ الجَبّارُ، لَكِنَّهُم لَمْ يَعْرِفُونِي بِاسْمِي يهوه. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","وَقَدْ قَطَعْتُ عَهدِي مَعَهُمْ وَوَعَدْتُ بِأنْ أُعطِيَهُمْ أرْضَ كَنعانَ الَّتِي كانُوا يَعِيشُونَ بِها كَغُرَباءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","«كَما سَمِعْتُ أنِينَ بَنِي إسْرائِيلَ الَّذِينَ يُجبِرُهُمُ المِصرِيُّونَ عَلَى العَمَلِ، وَتَذَكَّرْتُ عَهدِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","لِذَلِكَ قُلْ لِبَني إسْرائِيلَ: ‹أنا يهوه، وَسَأُخْرِجُكُمْ مِنْ تَحتِ أحمالِ مِصرَ. سَأُنقِذُكُمْ مِنَ اسْتِعبادِهِمْ لَكُمْ، وَسَأفدِيكُمْ بِذِراعٍ مَمدُودَةٍ وَبِأحكامٍ عَظِيمَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","سَأتَّخِذُكُمْ شَعباً لِي، وَسَأكُونُ إلَهَكُمْ. وَسَتَعرِفُونَ أنِّي أنا يهوه إلَهُكُمْ، وَسَتَرَونَ إنِّي سَأُحَرِّرَكُمْ مِنْ تَحْتِ أحْمالِ المِصْرِيِّنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","سَآتِي بِكُمْ إلَى الأرْضِ الَّتِي أقسَمْتُ بِأنْ أُعطِيَها لإبراهِيمَ وَإسْحاقَ وَيَعقُوبَ. أنا يهوه، وَسَأُعطِيها مُلكاً لَكُمْ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","فَتَكَلَّمَ مُوسَى بِهَذا الكَلامِ لِبَنِي إسْرائِيلَ، لَكِنَّهُمْ لَمْ يَسْتَمِعُوا لِمُوسَى بِسَبَبِ نَفادِ صَبرِهِمْ، وَبِسَبَبِ الإحْباطِ وَالعُبُودِيَّةِ القاسِيَةِ الَّتِي كانُوا فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","وَتَكَلَّمَ اللهُ إلَى مُوسَى، فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«اذْهَبْ وَقُلْ لِفِرعَونَ مَلِكِ مِصرَ بِأنْ يُطلِقَ بَني إسْرائِيلَ مِنْ أرْضِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","لَكِنَّ مُوسَى قالَ للهِ: «ها إنَّ بَنِي إسْرائِيلَ لا يَستَمِعُونَ إلَيَّ، فَكَيفَ سَيَستَمِعُ فِرعَوْنُ؟ كَما أنِّي لا أُحسِنُ الكَلامَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","وَتَكَلَّمَ اللهُ لِمُوسَى وَهارُونَ وَأمَرَهُما بِأنْ يَذهَبا إلَى بَنِي إسْرائِيلَ وَفِرعَونَ، لِيُخرِجا بَنِي إسْرائِيلَ مِنْ أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","هَؤُلاءِ هُمْ رُؤَساءُ بُيُوتِ الآباءِ. أبناءُ رَأُوبَيْنَ، بِكرِ إسْرائِيلَ، هُمْ حَنُوكُ وَفَلُّو وَحَصرُونُ وَكَرمِي. هَذِهِ هِيَ عَشائِرُ رَأُوبَيْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","وَأبناءُ شِمعُونَ هُمْ يَمُوئِيلُ وَيامِينُ وَأُوهَدُ وَياكِينُ وَصُوحَرُ وَشَاوُلُ ابْنُ المَرأةِ الكَنعانِيَّةِ. هَذِهِ هِيَ عَشائِرُ شِمعُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","وَهَذِهِ هِيَ أسْماءُ أبناءِ لاوِي بِحَسَبِ أجيالِهِمْ: جَرْشُونُ وَقَهاتُ وَمَرارِي. وَعاشَ لاوِي مِئَةً وَسَبْعاً وَثَلاثِينَ سَنَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","وَابْنا جَرْشُونَ هُما لِبْنِي وَشِمْعِي مَعَ عَشائِرِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","وَأبناءُ قَهاتَ هُمْ عَمْرامُ وَيِصْهارُ وَحَبْرُونُ وَعُزِّيئِيلَ. وَعاشَ قَهاتُ مِئَةً وَثَلاثاً وَثَلاثِينَ سَنَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","وَابْنا مَرارِي هُما مَحلِي وَمُوشِي. هَذِهِ هِيَ عَشائِرُ الَّلاوِيِّينَ حَسَبَ أجيالِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","وَاتَّخَذَ عَمْرامُ عَمَّتَهُ يُوكابَدَ زَوجَةً لَهُ، فَوَلَدَتْ لَهُ هارُونَ وَمُوسَى. وَعاشَ عَمْرامُ مِئَةً وَسَبْعاً وَثَلاثِينَ سَنَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","وَأبناءُ يِصْهارَ هُمْ قُورَحُ وَنافَجُ وَزِكْرِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","وَأبْناءُ عُزِّيئِيلَ هُمْ مِيشائِيلُ وَألْصافانُ وَسِتْرِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","وَتَزَوَّجَ هارُونُ مِنْ ألِيشابَعَ ابْنَةِ عَمِّينادابَ أختِ نَحشُونَ، وَوَلَدَتْ لَهُ نادابَ وَأبِيهُو وَألِعازارَ وَإيثامارَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","وَأبناءُ قُورَحَ هُمْ أسِّيرُ وَألْقانَةُ وَأبِيأسافُ. وَهَذِهِ هِيَ عَشائِرُ القُورَحِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","وَاتَّخَذَ ألِيعازارُ بْنُ هارُونَ إحدَى بَناتِ فُوطِيئِيلَ زَوجَةً لَهُ، فَوَلَدَتْ لَهُ فِينْحاسَ. هَؤُلاءِ هُمْ رُؤَساءُ بُيُوتِ آباءِ الَّلاوِيِّينَ بِحَسَبِ عَشائِرِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","هَذانِ هُما هارُونُ وَمُوسَى اللَّذانِ قالَ اللهُ لَهُما: «أخرِجا بَني إسْرائِيلَ مِنْ أرْضِ مِصرَ بِحَسَبِ صُفُوفِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","وَهُما اللَّذانِ تَكَلَّما إلَى فِرعَوْنَ مَلِكِ مِصرَ لإخراجِ بَني إسْرائِيلَ مِنْ مِصرَ. هَذانِ هُما مُوسَى وَهارُونُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","حِينَ كَلَّمَ اللهُ مُوسَى فِي أرْضِ مِصرَ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","قالَ لَهُ: «أنا اللهُ. قُلْ لِفِرعَونَ مَلِكِ مِصرَ كُلَّ ما أقُولُهُ لَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","فَقالَ مُوسَى فِي حَضرَةِ اللهِ: «أنا لا أُجِيدُ الكَلامَ، فَكَيفَ سَيَستَمِعُ فِرعَوْنُ لِي؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","فَقالَ اللهُ لِمُوسَى: «ها قَدْ جَعَلْتُكَ كَإلَهٍ لِفِرعَونَ، وَأخُوكَ هارُونُ سَيَكُونُ كَنَبِيٍّ لَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","تَكَلَّمْ أنْتَ بِكُلِّ ما آمُرُكَ بِهِ. وَهارُونُ أخُوكَ سَيَقُولُ لِفِرعَونَ بِأنْ يُطلِقَ بَنِي إسْرائِيلَ مِنْ أرْضِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","لَكِنِّي سَأُقَسِّي قَلْبَ فِرعَوْنَ لِأُكَثِّرَ مُعجِزاتِي وَعَجائِبِي فِي أرْضِ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","لَكِنَّ فِرعَوْنَ لَنْ يَستَمِعَ لَكُما، وَلِذا سَأمُدُّ يَدِي لِضَرْبِ مِصرَ، وَسَأُخرِجُ فِرَقِي، شَعبِي، بَنِي إسْرائِيلَ، مِنْ أرْضِ مِصرَ بِأحكامٍ عَظِيمَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","حِينَئِذٍ، سَيَعرِفُ المِصرِيُّونَ أنِّي أنا اللهُ حِينَ أمُدُّ يَدِي ضِدَّ إسْرائِيلَ وَأُخرِجُ بَنِي إسْرائِيلَ مِنْ بَينِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","فَعَمِلَ مُوسَى وَهارُونُ بِحَسَبِ أمرِ اللهِ لَهُما. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","وَكانَ مُوسَى فِي الثَّمانِينَ مِنْ عُمْرِهِ، وَهارُونُ فِي الثّالِثَةِ وَالثَّمانِينَ، حِينَ كَلَّما فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","وَقالَ اللهُ لِمُوسَى وَهارُونَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«حِينَ يَقُولُ فِرعَوْنُ لَكُما: ‹اصنَعا مُعجِزَةً،› قُلْ يا مُوسَى لِهارُونَ: ‹خُذْ عَصاكَ وَارْمِها أمامَ فِرعَوْنَ فَتَصِيرَ ثُعْباناً.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","فَدَخَلَ مُوسَى وَهارُونُ إلَى فِرعَوْنَ وَفَعَلا كَما أمَرَهُما اللهُ. وَلَمّا رَمَى هارُونُ عَصاهُ أمامَ فِرعَوْنَ وَحاشِيَتِهِ، صارَتْ ثُعْباناً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","لَكِنَّ فِرعَوْنَ دَعا حُكَماءَهُ وَسَحَرَتَهُ. فَفَعَلَ سَحَرَةُ مِصرَ الأمرَ ذاتَهُ بِسِحرِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","رَمَى كُلُّ واحِدٍ مِنهُمْ عَصاهُ فَصارَتِ العِصِيُّ ثَعابينَ. لَكِنَّ عَصا هارُونَ ابتَلَعَتْ عِصِيَّهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","أمَّا قَلْبُ فِرعَوْنَ فَتَقَسَّى، وَلَمْ يَستَمِعْ إلَيهِما، تَماماً كَما قالَ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","وَقالَ اللهُ لِمُوسَى: «قَلْبُ فِرعَوْنَ قاسٍ، فَقَدْ رَفَضَ إطلاقَ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","اذْهَبْ إلَى فِرعَوْنَ فِي الصَّباحِ حِينَ يَنزِلُ إلَى الماءِ. قَابِلْهُ عَلَى ضِفَّةِ النَّهرِ، وَالعَصا الَّتِي تَحَوَّلَتْ إلَى ثُعْبانٍ فِي يَدِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","وَقُلْ لَهُ: ‹إنَّ يهوه إلَهَ العِبرانِيِّينَ أرسَلَنِي إلَيكَ. وَهُوَ يَقُولُ لَكَ أطلِقْ شَعبِي لِيَعبُدَنِي فِي البَرِّيَّةِ. لَكِنَّكَ حَتَّى الآنَ تَرفُضُ الاسْتِماعَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","فَهَذا هُوَ ما يَقُولُهُ اللهُ، وَبِهَذا سَتَعرِفُ أنِّي أنا اللهُ: سَأضرِبُ بِالعَصا الَّتِي فِي يَدِي ماءَ نَهْرِ النِّيلِ فَيَتَحَوَّلُ إلَى دَمٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","سَيَمُوتُ السَّمَكُ، وَتَصيرُ رائِحَةُ النَّهرِ كَرِيهَةً، فَلا يَستَطِيعُ المِصرِيُّونَ أنْ يَشْرَبُوا ماءً مِنَ النِّيلِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","وَقالَ اللهُ لِمُوسَى: «قُلْ لِهارُونَ: ‹خُذْ عَصاكَ وَمُدَّ يَدَكَ فَوقَ مِياهِ مِصرَ: أنهارِهِا وَجَداوِلِها وَبِرَكِها، وَفَوقَ كُلِّ تَجَمُّعاتِ المِياهِ حَتَّى تَصِيرَ دَماً.› سَيَصِيرُ الماءُ دَماً فِي كُلِّ أرْضِ مِصرَ، حَتَّى الماءُ المُخَزَّنُ فِي أوْعِيَةِ الخَشَبِ وَالحَجَرِ!» ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","فَفَعَلَ مُوسَى وَهارُونُ كَما أمَرَهُما اللهُ. فَرَفَعَ هارُونُ العَصا وَضَرَبَ بِها الماءَ الَّذِي فِي نَهرِ النِّيلِ أمامَ فِرعَوْنَ وَخُدّامِهِ، فَتَحَوَّلَتْ مِياهُ النِّيلِ إلَى دَمٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","وَماتَ السَّمَكُ، وَصارَتْ رائِحَةُ النِّيلِ كَرِيهَةً، حَتَّى إنَّ المِصرِيِّينَ لَمْ يَستَطِيعُوا أنْ يَشرَبُوا مِنهُ. وَكانَ الدَّمُ فِي كُلِّ أرْضِ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","لَكِنَّ سَحَرَةَ مِصرَ عَمِلُوا الأمرَ نَفسَهُ بِسِحرِهِمْ، فَتَقَسَّى قَلبُ فِرعَوْنَ وَلَمْ يَستَمِعْ إلَيهِما، كَما سَبَقَ أنْ قالَ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","وَعادَ فِرعَوْنُ إلَى بَيتِهِ وَلَمْ يَأبَهْ لِلأمْرِ مُطلَقاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","وَحَفَرَ كُلُّ المِصرِيِّينَ آباراً حَولَ نَهرِ النِّيلِ لِيَشرَبُوا، لِأنَّهُمْ لَمْ يَكُونُوا يَستَطِيعُونَ الشُّربَ مِنْ ماءِ النَّهرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","وَمَرَّتْ سَبعَةُ أيّامٍ بَعدَ أنْ ضَرَبَ اللهُ نَهرَ النِّيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","فَقالَ اللهُ لِمُوسَى: «اذْهَبْ إلَى فِرعَوْنَ وَقُلْ لَهُ: ‹هَذا هُوَ ما يَقُولُهُ اللهُ: أطلِقْ شَعبِي كَي يَعبُدَنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","فَإنْ رَفَضْتَ أنْ تُطلِقَهُمْ، سَأضرِبُ كُلَّ أرْضِكَ بِالضَّفادِعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","سَيَمتَلِئُ النِّيلُ بِالضَّفادِعِ. وَسَتَصعَدُ الضَّفادِعُ إلَى بَيتِكَ وَغُرفَةِ نَومِكَ وَعَلَى سَرِيرِكَ وَإلَى بُيُوتِ خُدّامِكَ، وَعَلَى شَعبِكَ وَإلَى أفرانِكَ وَآنِيَتِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","فَتَأْتِي الضَّفادِعُ عَلَيكَ وَعَلَى شَعبِكَ وَعَلَى كُلِّ خُدّامِكَ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","وَقالَ اللهُ لِمُوسَى: «قُلْ لِهارُونَ: ‹مُدَّ يَدَكَ بِعَصاكَ عَلَى الأنهارِ وَالجَداوِلِ وَالبِرَكِ، وَأخرِجْ ضَفادِعَ لِتَنتَشِرَ عَلَى أرْضِ مِصرَ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","فَمَدَّ هارُونُ يَدَهُ عَلَى مِياهِ مِصرَ، فَخَرَجَتِ الضَّفادِعُ وَغَطَّتْ أرْضَ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","وَلَكِنَّ السَّحَرَةَ عَمِلُوا الأمرَ ذاتَهُ بِسِحرِهِمْ، وَأخرَجُوا ضَفادِعَ عَلَى أرْضِ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","فَاسْتَدعَى فِرعَوْنُ مُوسَى وَهارُونَ وَقالَ لَهُما: «صَلِّيا إلَى اللهِ أنْ يُزِيلَ الضَّفادِعَ عَنِّي وَعَنْ شَعبِي، حِينَئِذٍ، سَأُطلِقُ الشَّعبَ لِيُقَدِّمُوا ذَبائِحَ للهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","فَقالَ مُوسَى لِفِرعَونَ: «أنتَ تُقَرِّرُ مَتَى أُصَلِّي لِأجلِكَ وَلِأجلِ خُدّامِكَ وَشَعبِكَ لإزالَةِ الضَّفادِعِ عَنكَ وَعَنْ بُيُوتِكَ. لَكِنْ سَتَبْقَى الضَّفادِعُ فِي النِّيلِ فَقَطْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","فَقالَ فِرعَوْنُ: «غَداً.» فَأجابَ مُوسَى: «كَما تَقُولُ، كَي تَعرِفَ أنَّهُ لَيسَ مِثلَ يهوه إلَهِنا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","سَتَزُولُ الضَّفادِعُ عَنكَ وَعَنْ بُيُوتِكَ وَعَنْ خُدّامِكَ وَعَنْ شَعبِكَ، وَسَتَبقَى فِي النِّيلِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","فَخَرَجَ مُوسَى وَهارُونُ مِنْ عِنْدِ فِرعَوْنَ. وَصَرَخَ مُوسَى إلَى اللهِ بِشَأْنِ الضَّفادِعِ الَّتِي أرْسَلَها اللهُ عَلَى فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","فَاسْتَجابَ اللهُ لِمُوسَى. وَماتَتِ الضَّفادِعُ فِي البُيُوتِ وَالسّاحاتِ وَالحُقُولِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","فَجُمِعَتْ فِي أكوامٍ كَثِيرَةٍ حَتَّى صارَتْ رائِحَةُ الأرْضِ كَريهَةً جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","لَكِنْ حِينَ رَأى فِرعَوْنُ أنَّهُ صارَ هُناكَ فَرَجٌ، قَسَّى قَلبَهُ، وَلَمْ يَستَمِعْ إلَيهِما كَما قَالَ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","وَقالَ اللهُ لِمُوسَى: «قُلْ لِهارُونَ: ‹مُدَّ عَصاكَ وَاضْرِبْ تُرابَ الأرْضِ فَيَصِيرَ قَملاً فِي كُلِّ أرْضِ مِصرَ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","فَعَمِلا بِحَسَبِ قَولِهِ. مَدَّ هارُونُ عَصاهُ بِيَدِهِ، وَضَرَبَ تُرابَ الأرْضِ الَّذِي صارَ قَملاً عَلَى النّاسِ وَالحَيواناتِ. كُلُّ تُرابِ الأرْضِ صارَ قَملاً فِي كُلِّ أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","وَحاوَلَ السَّحَرَةُ أنْ يُخْرِجُوا القَملَ بِسِحْرِهِمْ، فَلَمْ يَقْدِرُوا، بَلِ انتَشَرَ القَملُ عَلَى النّاسِ وَالحَيَواناتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","وَقالَ السَّحَرَةُ: «هَذا إصْبِعُ اللهِ.» لَكِنَّ فِرعَوْنَ تَقَسَّى قَلبُهُ وَلَمْ يَستَمِعْ لَهُمْ كَما قالَ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","وَقالَ اللهُ لِمُوسَى: «اذْهَبْ وَقِفْ أمامَ فِرعَوْنَ فِي الصَّباحِ حِينَ يَخرُجُ إلَى الماءِ، وَقُلْ لَهُ: ‹يَقُولُ اللهُ لَكَ أطلِقْ شَعبِيَ لِيَعبُدَنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","فَإنْ لَمْ تُطلِقْ شَعبِي، سَأُرسِلُ أسراباً مِنَ الذُّبابِ عَلَيكَ وَعَلَى خُدّامِكَ وَعَلَى شَعبِكَ وَعَلَى بَيتِكَ. سَتَمتَلِئُ بُيُوتُ مِصرَ بِأسرابِ الذُّبابِ، وَكَذَلِكَ الأرْضُ الَّتِي تَسكُنُها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","لَكِنْ فِي ذَلِكَ الوَقتِ، سَأُمَيِّزُ أرْضَ جاسانَ حَيثُ يُقِيمُ شَعبِي، فَلَنْ تَأْتِيَ أسرابُ الذُّبابِ هُناكَ، كَي تَعرِفَ أنِّي أنا اللهُ المُتَسَيِّدُ فِي وَسَطِ هَذِهِ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","سَأُمَيِّزُ بَينَ شَعبِي وَشَعبِكَ، وَسَيحدُثُ هَذا غَداً بُرهاناً لَكَ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","وَاسْتَجابَ اللهُ لِقَولِهِ، فَأتَتْ أسرابٌ مِنَ الذُّبابِ عَلَى بَيتِ فِرعَوْنَ وَبُيُوتِ خُدّامِهِ وَعَلَى كُلِّ أرْضِ مِصرَ. وَخَرِبَتِ الأرْضُ بِسَبَبِ أسرابِ الذُّبابِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","حِينَئِذٍ، استَدعَى فِرعَوْنُ مُوسَى وَهارُونَ، وَقالَ لَهُما: «قَدِّمُوا ذَبائِحَ لإلَهِكُمْ هُنا فِي هَذِهِ الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","لَكِنَّ مُوسَى قالَ: «لا يَصلُحُ أنْ نَفعَلَ هَذا. لأنَّنا سَنَذْبَحُ لإلَهِنا ما يُحَرِّمُهُ المِصرِيُونَ. إنْ ذَبَحْنا أمامَ عُيُونِهِم ما يُحَرِّمُونَ ذَبْحَهُ، سَيَرْجُمُونَنا! ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","لا بُدَّ أنْ نَسِيرَ فِي رِحلَةٍ لِثَلاثَةِ أيّامٍ، وَنُقَدِّمُ هُناكَ الذَّبائِحَ لإلَهِنا كَما أمَرَنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","فَقالَ فِرعَوْنُ: «سَأُطلِقُكُمْ لِتُقَدِّمُوا ذَبائِحَ ليهوه إلَهِكُمْ فِي البَرِّيَّةِ، لَكِنْ لا تَبتَعِدُوا! وَصَلِّيا لِأجلِيَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","فَقالَ مُوسَى: «فَوْرَ خُرُوجِي مِنْ عِنْدِكَ سَأُصَلِّي إلَى اللهِ، فَتَزُولُ أسرابُ الذُّبابِ عَنْ فِرعَوْنَ وَخُدّامِهِ وَشَعبِهِ غَداً. لَكِنْ أرجُو مِنْ فِرعَوْنَ أنْ لا يَخدَعَنا ثانيَةً بِعَدَمِ إطلاقِهِ لِلشَّعبِ لِيُقَدِّمُوا ذَبائِحَ للهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","وَخَرَجَ مُوسَى مِنْ مَحضَرِ فِرعَوْنَ وَصَلَّى إلَى اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","وَاستَجابَ اللهُ لِمُوسَى، فَأزالَ أسرابَ الذُّبابِ عَنْ فِرعَوْنَ وَخُدّامِهِ وَشَعبِهِ، حَتَّى لَمْ تَبْقَ ذُبابَةٌ واحِدَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","لَكِنَّ فِرعَوْنَ قَسَّى قَلْبَهُ هَذِهِ المَرَّةَ أيضاً، وَلَمْ يُطلِقِ الشَّعبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","وَقالَ اللهُ لِمُوسَى: «اذْهَبْ إلَى فِرعَوْنَ وَقُلْ لَهُ: هَذا هُوَ ما يَقُولُهُ يهوه إلَهُ العِبرانِيِّينَ: ‹أطلِقْ شَعبِي لِيَعبُدَنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","فَإنْ رَفَضْتَ أنْ تُطلِقَهُمْ وَأطَلْتَ احتِجازَهُمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","فَإنَّ يَدَ اللهِ سَتَكُونُ ضِدَّ مَواشِيَكَ الَّتِي فِي الحَقلِ، ضِدَّ الخَيلِ وَالحَمِيرِ وَالجِمالِ وَالبَقَرِ وَالغَنَمِ، إذْ سَأضْرِبُها بِمَرَضٍ شَدِيدٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","لَكِنَّ اللهَ سَيُمَيِّزُ بَينَ مَواشِيَ بَنِي إسْرائِيلَ وَمَواشِيَ مِصْرَ، إذْ لَنْ يَمُوتَ رَأْسٌ مِنْ مَواشِي بَنِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","قَدْ حَدَّدَ اللهُ وَقتاً فَقالَ: غَداً سَأفعَلُ هَذا الأمرَ فِي الأرْضِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","وَقَدْ صَنَعَ اللهُ هَذا الأمرَ فِي اليَومِ التّالِي، فَماتَتْ كُلُّ مَواشِي مِصرَ، لَكِنْ لَمْ يَمُتْ رَأْسٌ مِنْ مَواشِي بَنِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","لَكِنْ لَمّا استَخبَرَ فِرعَوْنُ عَمَّا حَدَثَ، وَوَجَدَ أنَّهُ لَمْ يَمُتْ رَأْسٌ واحِدٌ مِنْ مَواشِي بَنِي إسْرائِيلَ، تَقَسَّى قَلْبُهُ وَلَمْ يَسمَحْ بِإطلاقِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","وَقالَ اللهُ لِمُوسَى وَهارُونَ: «خُذا حَفْنَةً مِنْ رَمادِ الفُرنِ، وَلْيَرمِها مُوسَى بِاتِّجاهِ السَّماءِ أمامَ فِرعَوْنَ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","فَيَصِيرَ الرَّمادُ غُباراً عَلَى كُلِّ أرْضِ مِصرَ، وَيُسَبِّبُ دَمامِلَ مُتَقَيِّحَةً عَلَى النّاسِ وَالحَيواناتِ فِي كُلِّ أرْضِ مِصرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","فَأخَذا رَماداً مِنَ الفُرنِ وَوَقَفا أمامَ فِرعَوْنَ. وَرَماهُ مُوسَى نَحوَ السَّماءِ، فَصارَ دَمامِلَ مُتَقَيِّحَةً عَلَى النّاسِ وَالحَيواناتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","وَبِسَبَبِ الدَّمامِلِ، لَمْ يَستَطِعِ السَّحَرَةُ أنْ يَقِفُوا أمامَ مُوسَى لِيَتَحَدُّوهُ. لِأنَّ الدَّمامِلَ كانَتْ عَلَى السَّحَرَةِ وَعَلَى كُلِّ المِصرِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","لَكِنَّ اللهَ قَسَّى قَلبَ فِرعَوْنَ، وَلَمْ يَستَمِعْ إلَيهِما كَما قالَ اللهُ لِمُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","وَقالَ اللهُ لِمُوسَى: «اذْهَبْ وَقِفْ أمامَ فِرعَوْنَ فِي الصَّباحِ الباكِرِ وَقُلْ لَهُ: هَذا هُوَ ما يَقُولُهُ يهوه إلَهُ العِبرانِيِّينَ: ‹أطلِقْ شَعبِي لِيَعْبُدَنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","فَفِي هَذِهِ المَرَّةِ، سَأُرسِلُ كُلَّ أوبائِيَ الَّتِي سَتَكُونُ عِبئاً عَلَى قَلبِكَ وَعَلَى وُزَرائِكَ وَشَعبِكَ، كَي تَعرِفَ أنَّهُ لَيسَ هُناكَ مِثلِي فِي الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","لِأنِّي كُنتُ أستَطِيعُ أنْ أمُدَّ يَدِي وَأضرِبَكَ وَأضرِبَ شَعبَكَ بِالوَباءِ، فَتُقطَعُونَ مِنَ أرْضِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","لَكِنَّنِي أبقَيتُكَ لِأُظهِرَ لَكَ قُوَّتِي، وَلِكَي أجعَلَ اسْمِي مَعرُوفاً فِي كُلِّ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","وَما زِلْتَ تُضايِقُ شَعبِيَ وَلَمْ تُطلِقْهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","فِي الغَدِ، فِي مِثلِ هَذا الوَقتِ، سَآتِي بِبَرَدٍ ضَخمٍ لَمْ يَأْتِ مِثلُهُ عَلَى مِصرَ مِنْ وَقتِ تَأْسِيسِها وَحَتَّى الآنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","فَضَعُوا مَواشِيَكُمْ وَكُلَّ ما لَكُمْ فِي الحَقلِ فِي حَظائِرَ مَسقُوفَةٍ. كُلُّ إنسانٍ أوْ حَيوانٍ فِي الحَقلِ لا يُؤتَى بِهِ إلَى الدّاخِلِ سَيَمُوتُ حِينَ يَسقُطُ البَرَدُ عَلَيهِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","وَكُلُّ خادِمٍ مِنْ خُدّامِ فِرعَوْنَ، خافَ كَلِمَةَ اللهِ، أدخَلَ خُدّامَهُ وَمَواشِيَهُ إلَى الدّاخِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","لَكِنَّ الَّذِي تَجاهَلَ كَلِمَةَ اللهِ تَرَكَ خُدّامَهُ وَمَواشِيَهُ فِي الحَقلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","وَقالَ اللهُ لِمُوسَى: «مُدَّ يَدَكَ نَحوَ السَّماءِ، لِيَأْتِيَ البَرَدُ عَلَى كُلِّ أرْضِ مِصرَ، وَعَلَى النّاسِ وَالحَيواناتِ وَكُلِّ نَباتاتِ الحَقلِ فِي أرْضِ مِصرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","فَمَدَّ مُوسَى عَصاهُ نَحوَ السَّماءِ، فَأرسَلَ اللهُ رَعداً وَبَرقاً وَبَرَداً. أمطَرَ اللهُ بَرَداً عَلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","كانَ هُناكَ بَرَدٌ مَعَ بَرْقٍ بِشَكلٍ مُستَمِرٍّ. كانَ شَدِيداً جِدّاً وَلَمْ يَأْتِ مِثلُهُ فِي كُلِّ أرْضِ مِصرَ مُنذُ أنْ سَكَنَها البَشَرُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","وَضَرَبَ البَرَدُ كُلَّ ما فِي الحَقلِ مِنَ النّاسِ وَالحَيواناتِ فِي كُلِّ أرْضِ مِصرَ. وَضَرَبَ البَرَدُ كُلَّ النَّباتاتِ الَّتِي فِي الحَقلِ وَحَطَّمَ كُلَّ أشجارِ الحَقلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","لَكِنْ عَلَى أرْضِ جاسانَ، لَمْ يَأْتِ بَرَدٌ. وَهِيَ الأرْضُ الَّتِي سَكَنَها بَنُو إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","وَاستَدعَى فِرعَوْنُ مُوسَى وَهارُونَ وَقالَ لَهُما: «قَدْ أخطَأْتُ هَذِهِ المَرَّةَ. اللهُ هُوَ المُحِقُّ، وَأنا وَشَعبِي عَلَى خَطَأِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","صَلِّيا للهِ، يَكفِي ما نِلْناهُ مِنْ رَعدٍ وَبَرَدٍ. سَأُطلِقُكُمْ، وَلَنْ تَضْطَرُّوا لِلبَقاءِ أكثَرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","فَقالَ مُوسَى لَهُ: «حِينَ أخرُجُ مِنَ المَدِينَةِ سأرْفَعُ يَدِيَّ للهِ، فَيَتَوَقَّفُ الرَّعدُ وَلا يَبقَى بَرَدٌ، كَي تَعرِفَ أنَّ الأرْضَ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","أمّا أنتَ وَخُدّامُكَ، فَأنا أعْرِفُ أنَّكُمْ لا تَخافُونَ اللهَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","وَكانَ قَدْ تَلِفَ الكِتّانُ وَالشَّعِيرُ. لِأنَّ الكِتّانَ كانَ قَدِ اخْضَرَّ، وَالشَّعِيرَ أنبَتَ سَنابِلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","أمّا حُبُوبُ القَمْحِ وَالعَلَسِ فَلَمْ تَتلَفْ، لِأنَّها تنْضِجُ فِي وَقتٍ مُتَأخِّرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","وَخَرَجَ مُوسَى مِنْ عِنْدِ فِرعَوْنَ وَمِنَ المَدِينَةِ وَرَفَعَ يَدَهُ إلَى اللهِ وَصَلَّى، فَتَوَقَّفَ الرَّعدُ وَالبَرقُ، وَلَمْ يَعُدِ المَطَرُ يَنسَكِبُ عَلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","وَحِينَ رَأى فِرعَوْنُ أنَّ المَطَرَ وَالبَرَدَ وَالرَّعدَ قَدْ تَوَقَّفَتْ، أخطَأ ثانِيَةً، وَقَسَّى هُوَ وَخُدّامُهُ قُلُوبَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","فَتَقَسَّى قَلبُ فِرعَوْنَ وَلَمْ يُطلِقْ بَني إسْرائِيلَ، كَما سَبَقَ أنْ قالَ اللهُ عَلَى فَمِ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","وَقالَ اللهُ لِمُوسَى: «اذهَبْ إلَى فِرعَوْنَ لِأنِّي قَسَّيتُ قَلبَهُ وَقُلُوبَ خُدّامِهِ كَي أُظهِرَ مُعجِزاتِي فِي وَسَطِهِمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","وَلِكَيْ تُخبِرَ أولادَكَ وَأحفادَكَ بِما عَمِلْتُهُ بِالمِصْرِيِّينَ، وَتُخبِرَهُمْ بِالمُعجِزاتِ الَّتِي عَمِلْتُها، فَتَعلَمُونَ أنِّي أنا اللهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","فَأتَى مُوسَى وَهارُونُ إلَى فِرعَوْنَ وَقالا لَهُ: «هَذا هُوَ ما يَقُولُهُ يهوه إلَهُ العِبرانِيِّينَ: ‹حَتَّى مَتَى تَرفُضُ أنْ تَتَواضَعَ أمامِي؟ أطلِقْ شَعبِي لِيَعبُدَنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","فَإنْ رَفَضْتَ، سَآتِي بِالجَرادِ عَلَى بَلَدِكَ وَأرْضِكَ فِي الغَدِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","فَيُغَطِّي سَطحَ الأرْضِ حَتَّى لا يَستَطِيعَ أحَدٌ أنْ يَرَى الأرْضَ. وَسَيَأْكُلُ الجَرادُ ما تَبَقَّى لَكُمْ بَعدَ ضَربَةِ البَرَدِ. سَيَأْكُلُ كُلَّ أشجارِكُمُ النّابِتَةِ فِي الحَقلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","بَلْ سَتَمتَلِئُ بِها بُيُوتُكَ وَبُيُوتُ خُدّامِكَ وَبَيَوتُ كُلِّ المِصرِيِّينَ. وَسَتَرَى أنْتَ ما لَمْ يَرَهُ آباؤُكَ وَأجدادُكَ مُنذُ أنْ وُجِدُوا عَلَى الأرْضِ إلَى اليَومِ!›» ثُمَّ اسْتَدارَ وَخَرَجَ مِنْ عِنْدِ فِرعَوْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","فَقالَ خُدّامُ فِرعَوْنَ لَهُ: «إلَى مَتَى سَيَبقَى هَذا الرَّجُلُ فَخّاً لَنا؟ أطلِقِ الرِّجالَ لِيَعبُدُوا إلَهَهُمْ. ألا تَرَى أنَّ مِصرَ قَدْ خَرِبَتْ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","فاسْتُدْعِيَ مُوسَى وَهارُونُ إلَى فِرعَوْنَ، فَقالَ لَهُما: «اذْهَبُوا وَاعْبُدُوا إلَهَكُمْ. لَكِنْ، مَنِ الَّذينَ سَيَذْهَبُونَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","فَقالَ مُوسَى: «سَنَذْهَبُ جَمِيعاً مَعَ شُبّانِنا وَشُيُوخِنا وَأبْنائِنا وَبَناتِنا وَغَنَمِنا وَبَقَرِنا، لِأنَّ لَدَينا عِيداً للهِ لِنَحتَفِلَ بِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","فَقالَ فِرعَوْنُ ساخِراً: «يَكُونُ اللهُ مَعَكُمْ بِالفِعلِ إذا أطلَقْتُ أولادَكُمْ مَعَكُمْ! أنْتُما تُخْفِيانِ خُطَّةً شِرِّيرَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","يُمكِنُ لِلرِّجالِ فَقَطْ أنْ يَذهَبُوا وَيَعْبُدُوا اللهَ، لِأنَّ هَذا ما تُرِيدانِهِ.» ثُمَّ طَرَدَهُما فِرعَوْنُ مِنْ أمامِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","فَقالَ اللهُ لِمُوسَى: «مُدَّ يَدَكَ عَلَى أرْضِ مِصرَ لَيأتِيَ الجَرادُ عَلَى أرْضِ مِصرَ وَيَأْكُلَ كُلَّ عُشْبٍ أخضَرَ فِي الأرْضِ تَرَكَهُ البَرَدُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","فَمَدَّ مُوسَى عَصاهُ عَلَى أرْضِ مِصرَ، فَساقَ اللهُ رِيحاً شَرقِيَّةً عَلَى الأرْضِ طِيلَةَ النَّهارِ وَاللَّيلِ. وَحِينَ جاءَ الصَّباحُ، ساقَتِ الرِّيحُ الشَّرْقِيَّةُ الجَرادَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","أتَى الجَرادُ عَلَى كُلِّ أرْضِ مِصْرَ وَاستَقَرَّ فِيها. كانَتِ المأساةُ عَظيمَةً، إذْ لَمْ يَأْتِ جَرادٌ كَهَذا مِنْ قَبلُ، وَلَنْ يَأْتِيَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","فَقَدْ غَطَّى الجَرادُ سَطحَ الأرْضِ، حَتَّى سَادَتِ الظُّلْمَةُ. وَأكَلَ كُلَّ نَباتٍ فِي الأرْضِ وَكُلَّ ثِمارِ الأشْجارِ الَّتِي بَقِيَتْ بَعدَ ضَرْبَةِ البَرَدِ. لَمْ يَتَبَقَّ شَيءٌ أخضَرُ بَينَ الأشْجارِ وَالنَّباتاتِ فِي أرْضِ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","فَأسرَعَ فِرعَوْنُ بِاستِدعاءِ مُوسَى وَهارُونَ، وَقالَ: «أخطَأْتُ إلَى يهوه إلَهِكُما وَإلَيكُما. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","وَالآنَ، اغفِرا خَطِيَّتِي هَذِهِ المَرَّةَ، وَصَلِّيا إلَى يهوه إلَهِكُما أنْ يُزِيلَ عَنِّيَ هَذا المَوتَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","فَخَرَجَ مُوسَى مِنْ عِنْدِ فِرعَوْنَ وَصَلَّى إلَى اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","فَأرْسَلَ اللهُ رِيحاً غَربِيَّةً قَوِيَّةً حَمَلَتِ الجَرادَ وَألقَتْهُ فِي البَحرِ الأحمَرِ، حَتَّى لَمْ تَبْقَ جَرادَةٌ واحِدَةٌ فِي أرْضِ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","لَكِنَّ اللهَ قَسَّى قَلْبَ فِرعَوْنَ كَي لا يُطلِقَ بَنِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","وَقالَ اللهُ لِمُوسَى: «مُدَّ يَدَكَ نَحوَ السَّماءِ لِيَأْتِيَ ظَلامٌ عَلَى أرْضِ مِصرَ، حَتَّى إنَّهُ يَكادُ أنْ يُلمَسَ لِشِدَّتِهِ!» ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","فَمَدَّ مُوسَى يَدَهُ نَحْوَ السَّماءِ، فَحلَّ ظَلامٌ شَدِيدٌ عَلَى أرْضِ مِصرَ لِمُدَّةِ ثَلاثَةِ أيّامٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","حَتَّى لَمْ يَعُدِ أحَدٌ يَقدِرُ أنْ يَرَى الآخَرَ. وَلَمْ يَقُمْ أحَدٌ مِنْ مَكانِهِ لِثَلاثَةِ أيّامٍ. وَأمّا بَنُو إسْرائِيلَ فَكانَ لَدَيهِمْ نُورٌ فِي بُيُوتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","فَاسْتَدعَى فِرعَوْنُ مُوسَى وَقالَ لَهُ: «اذهَبُوا وَاخْدِمُوا اللهَ، لكِنْ تَبقَى غَنَمُكُمْ وَبَقَرُكُمْ. وَيُمكِنُ لِأولادِكُمْ أيضاً أنْ يَذهَبُوا مَعَكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","فَقالَ مُوسَى: «بَلْ أنتَ أيضاً سَتُعطِيَنا قَرابينَ وَذَبائِحَ لِنَذْبَحَ لإلَهِنا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","وَمَواشِينا تَذهَبُ مَعَنا، فَلا يَبقَى مِنها رَأْسٌ واحِدٌ، لِأنَّنا سَنَذْبَحُ منْها أثَناءَ عِبادَةِ إلَهِنا. وَلا نَعرِفُ ماذا سَنَذْبَحُ للهِ بِالتَّحْدِيدِ حَتَّى نَصِلَ إلَى هُناكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","لَكِنَّ اللهَ قَسَّى قَلبَ فِرعَوْنَ، وَلَمْ يُرِدْ أنْ يُطلِقَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","وَقالَ فِرعَوْنُ لِمُوسَى: «ابْتَعِدْ عَنِّي! احذَرْ! لا تَرَنِي ثانِيَةً، فَحِينَ تَرانِي سَتَمُوتُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","وَقالَ مُوسَى: «كَما قُلْتَ بِالفِعلِ، لَنْ أراكَ ثانِيَةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","وَقالَ اللهُ لِمُوسَى: «سَآتِي بِضَرْبَةٍ واحِدَةٍ أُخْرَى عَلَى فِرعَوْنَ وَعَلَى مِصرَ. وَبَعدَ ذَلِكَ سَيُطلِقُكُمْ مِنْ هُنا. وَحِينَ يُطلِقُكُمْ، فَإنَّهُ سَيَطرُدُكُمْ طَرْداً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","«قُلْ لِلشَّعبِ أنْ يَطلُبَ كُلُّ رَجُلٍ مِنْ جارِهِ، وَكُلُّ امْرأةٍ مِنْ جارَتِها، أدَواتٍ مِنْ ذَهَبٍ وَفِضَّةٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","وَجَعَلَ اللهُ المِصرِيِّينَ كُرَماءَ مَعَ بَنِي إسْرائِيلَ. وَكانَ الرَّجُلُ مُوسَى عَظِيماً جِدّاً فِي أرْضِ مِصْرَ، فِي عُيُونِ خُدّامِ فِرعَوْنَ وَالشَّعْبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","وَقالَ مُوسَى: «هَذا هُوَ ما يَقُولُهُ اللهُ: ‹قُرْبَ مُنتَصَفِ اللَّيلِ، سَأخرُجُ إلَى وَسَطِ مِصرَ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","فَيَمُوتُ كُلُّ بِكْرٍ فِي أرْضِ مِصرَ، ابْتِداءً بِابْنِ فِرعَوْنَ الجالِسِ عَلَى عَرشِهِ، حَتَّى بِكْرِ الجارِيَةِ الجالِسَةِ خَلفَ حَجَرِ الرَّحَى، وَكُلِّ بِكرٍ مِنَ الحَيواناتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","سَيَكُونُ هُناكَ نُواحٌ عَظِيمٌ فِي كُلِّ أرْضِ مِصرَ لَمْ يَأْتِ مِثلُهُ مِنْ قَبلُ، وَلَنْ يَأْتِيَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","أمّا وَسَطَ بَنِي إسْرائِيلَ، فَلَنْ يَكُونَ هُناكَ وَلا حَتَّى كَلبٌ لِيَنبَحَ وَسَطَ النّاسِ أوِ الحَيواناتِ، لِيَعرِفُوا أنَّ اللهَ يُمَيِّزُ بَينَ المِصرِيِّينَ وَالإسْرائِيلييّن. ");
INSERT INTO arbwbtc_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","كُلُّ خُدّامِكَ هَؤُلاءِ سَيَأتُونَ إلَيَّ وَسَيَرْكَعُونَ لِي وَيَقُولُونَ: اخْرُجْ أنْتَ وَكُلُّ الشَّعبِ الَّذِي يَتبَعُكَ. حِينَئِذٍ، سَأخرُجُ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","وَقالَ اللهُ لِمُوسَى: «لَنْ يَستَمِعَ فِرعَوْنُ لَكَ كَي أزِيدَ مُعجِزاتِي فِي أرْضِ مِصرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","فَعَمِلَ مُوسَى وَهارُونُ كُلَّ هَذِهِ المُعجِزاتِ أمامَ فِرعَوْنَ. لَكِنَّ اللهَ قَسَّى قَلْبَهُ كَي لا يُطلِقَ بَني إسْرائِيلَ مِنْ أرْضِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","وَقالَ اللهُ لِمُوسَى وَهارُونَ فِي أرْضِ مِصرَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«سَيَكُونُ هَذا الشَّهرُ أوَّلَ شَهرٍ لَكُمْ. وَسَيَكُونُ الشَّهرَ الأوَّلَ مِنَ السَّنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","كَلِّما كُلَّ جَماعَةِ إسْرائِيلَ وَقُولا لَهُمْ: فِي اليَومِ العاشِرِ مِنْ هَذا الشَّهرِ، عَلَى كُلِّ رَجُلٍ أنْ يُخَصِّصَ حَمَلاً لِعائِلَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","وَإنْ كانَتِ العائِلَةُ صَغِيرَةً، فَلْيَشْتَرِكْ هُوَ وَجارُهُ بِحَمَلٍ وَاحِدٍ لِعائِلَتَيهِما، بِحَسَبِ عَدَدِ أفرادِ العائِلَتَينِ. احسِبُوا عَدَدَ الآكِلِينَ مِنَ الحَمَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","«يَنْبَغِي أنْ يَكُونَ الحَمَلُ ذَكَراً سَليماً مِنَ العُيُوبِ، عُمْرُهُ سَنَةٌ. وَيُمْكِنُ أنْ يَكُونَ مِنَ الغَنَمِ أوِ الماعِزِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","احتَفِظُوا بِهِ إلَى اليَومِ الرّابِعَ عَشَرَ مِنْ هَذا الشَّهرِ. حِينَئِذٍ، عَلَى جَماعَةِ بَني إسْرائِيلَ أنْ يَذبَحُوهُ فِي المَساءِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ثُمَّ يَأْخُذُوا مِنَ الدَّمِ وَيَضَعُوهُ عَلَى قائِمَتَيِّ البابِ، وَعَلَى عَتَبَتِهِ العُليا، فِي البُيُوتِ الَّتِي سَيَأكُلُونَ فِيها الحَمَلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","«وَيَأكُلُونَ اللَّحمَ فِي تِلكَ اللَّيلَةِ مَشوِيّاً عَلَى النّارِ مَعَ خُبزٍ غَيرِ مُختَمِرٍ وَأعشابٍ مُرَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","لا تَأكُلُوا مِنهُ نَيِّئاً أوْ مَسلُوقاً فِي الماءِ، بَلْ مَشوِيّاً عَلَى النّارِ مَعَ رَأسِهِ وِسِيقانِهِ وَأحشائِهِ الدّاخِلِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","وَلا تُبقُوا شَيئاً مِنهُ حَتَّى الصَّباحِ. كُلُّ ما يَتَبَقَّى مِنهُ تُحرِقُونَهُ بالنّارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","«هَكَذا تَأكُلُونَهُ: تَكُونُ أوساطُكُمْ مَشدُودَةً، وَتَرتَدُونَ أحذِيَتَكُمْ فِي أرجُلِكُمْ، وَتَحْمِلُونَ عِصِيَّكُمْ فِي أيدِيكُمْ. تَأكُلُونَهُ بِسُرعَةٍ، فَهُوَ فِصحٌ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«وَأنا سَأجْتازُ فِي هَذِهِ اللَّيلَةِ عَبرَ أرْضِ مِصرَ وَأقتُلُ كُلَّ الأبْكارِ فِي أرْضِ مِصرَ مِنَ النّاسِ وَالبَهائِمِ. سَأحكُمُ عَلَى آلِهَةِ مِصرَ، أنا الإلَهَ الحَقِيقِيَّ، يهوه. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","«سَيَكُونُ الدَّمُ عَلامَةً لَكُمْ عَلَى البُيُوتِ الَّتِي أنتُمْ فِيها. فَأرَى الدَّمَ وَأعْبُرُ عَنْكُمْ. لَنْ تَأتِيَ عَلَيكُمْ ضَربَةٌ حِينَ أضرِبُ أرْضَ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","سَيَكُونُ هَذا اليَومُ ذِكْرَى لَكُمْ تَحتَفِلُونَ بِهِ عِيداً للهِ. احْفَظُوا هَذا العِيدَ جِيلاً بَعْدَ جِيلٍ كَعادَةٍ دائِمَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","لِمُدَّةِ سَبعَةِ أيّامٍ، تَأكُلُونَ خَبْزاً غَيرَ مُخْتَمِرٍ. فِي اليَومِ الأوَّلِ، تُخرِجُونَ الخَمِيرَةَ مِنْ بُيُوتِكُمْ، لِأنَّ كُلَّ مَنْ يَأكُلُ خُبْزاً مُخْتَمِراً مِنَ اليَومِ الأوَّلِ وَحَتَّى السّابِعِ، يُقطَعُ مِنْ إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","«فِي اليَومِ الأوَّلِ، تَعقِدُونَ تَجَمُّعاً مَهِيباً. وَفِي اليَومِ السَّابِعِ، تَعقِدُونَ تَجَمُّعاً مَهِيباً آخَرَ. لا يَنبَغِي أنْ تَنْشَغِلُوا بِأيِّ عَمَلٍ فِي هَذَينِ اليَومَينِ، عَدَا ما يَعْمَلُهُ كُلُّ واحِدٍ لإعْدادِ طَعامِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«احْفَظُوا عِيدَ الخُبْزِ غَيرِ المُخْتَمِرِ، لِأنِّي فِي هَذا اليَومِ سَأُخرِجُ صُفُوفَ إسْرائِيلَ مِنْ أرْضِ مِصْرَ. احْفَظُوا هَذا العِيدَ جِيلاً بَعْدَ جِيلٍ كَعادَةٍ دائِمَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","مِنَ اليَومِ الرّابِعَ عَشَرَ مِنَ الشَّهرِ الأوَّلِ وَحَتَّى مَساءِ اليَومِ الحادِي وَالعِشْرِينَ مِنَ الشَّهرِ، تَأكُلُونَ خُبزاً غَيرَ مُخْتَمِرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","لا تُبقُوا خَمِيراً فِي بُيُوتِكُمْ لِسَبعَةِ أيّامٍ. فَأيُّ إنسانٍ، سَواءٌ أكانَ غَرِيباً أمْ مِنْ مَوالِيدِ الأرْضِ، يَأكُلُ شَيئاً فِيهِ خَمِيرٌ، يُقطَعُ مِنْ شَعبِ إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","فَلا تَأكُلُوا أيَّ شَيءٍ فِيهِ خَمِيرٌ، بَلْ كُلُوا خُبزاً غَيرَ مُخْتَمِرٍ فِي كُلِّ مَساكِنِكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","وَاستَدعَى مُوسَى كُلَّ شُيُوخِ إسْرائِيلَ وَقالَ لَهُمْ: «اختارُوا حَمَلاً لِعائِلاتِكُمْ وَاذبَحُوهُ كَحَمَلٍ لِلفِصحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","وَخُذُوا باقَةً مِنْ نَباتِ الزُّوفا وَاغمِسُوها فِي حَوضِ الدَّمِ، ثُمَّ اصبِغُوا بِالدَّمِ العَتَبَةَ العُليا وَالعارِضَتَينِ اليُمنى وَاليُسرَى لأبْوابِ بُيُوتِكُمْ. وَلا تَخرُجُوا مِنْ أبْوابِ بُيُوتِكُمْ حَتَّى الصَّباحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","حِينَ يَعبُرُ اللهُ لِيَضرِبَ أرْضَ مِصرَ، فَإنَّهُ سَيَرَى الدَّمَ عَلَى العَتَبَةِ العُليا وَالقائِمَتَينِ، فَيَتَجاوَزُ اللهُ ذَلِكَ البابَ وَلا يَسمَحُ لِلمَلاكِ المُهلِكِ بِالدُّخُولِ إلَى بُيُوتِكُمْ لِيَقتُلَ أولادَكَمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","«احْفَظُوا هَذا الأمرَ كَعادَةٍ دائِمَةٍ لَكُمْ وَلِأولادِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","وَحِينَ تَأتُونَ إلَى الأرْضِ الَّتِي سَيُعطِيها اللهُ لَكُمْ كَما وَعَدَ، تَحفَظُونَ هَذِهِ الفَرِيضَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","«وَحِينَ يَسْألُ أولادُكُمْ: ‹ما مَعنَى هَذِا العِيدِ؟› ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","قُولُوا: ‹إنَّها ذَبِيحَةُ فِصحِ اللهِ الَّذِي تَجاوَزَ بُيُوتَ بَنِي إسْرائِيلَ حِينَ ضَرَبَ مِصرَ، لَكِنَّهُ أنقَذَ بُيُوتَنا.›» حِينَئِذٍ، رَكَعَ الشَّعبُ وَعَبَدُوا اللهَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","وَذَهَبَ بَنُو إسْرائِيلَ وَعَمِلُوا كَما أمَرَ اللهُ مُوسَى وَهارُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","وَعِندَ مُنتَصَفِ اللَّيلِ، ضَرَبَ اللهُ الأبْكارَ فِي أرْضِ مِصرَ، مِنْ بِكرِ فِرعَوْنَ الجالِسِ عَلَى عَرشِهِ إلَى بِكرِ السُّجَناءِ إلَى أبْكارِ الحَيواناتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","وَسَهِرَ فِرعَوْنُ وَخُدّامُهُ وَكُلُّ مِصرَ فِي تِلكَ اللَّيلَةِ. وَكانَ هُناكَ نُواحٌ شَدِيدٌ فِي مِصرَ، لِأنَّهُ لَمْ يَكُنْ هُناكَ بَيتٌ لَمْ يَكُنْ فِيهِ مَيِّتٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","فَاسْتَدعَى فِرعَوْنُ مُوسَى وَهارُونَ تِلكَ اللَّيلَةَ وَقالَ لَهُما: «قُومُوا وَاخرُجُوا مِنْ وَسْطِ شَعبِي، أنتُما وَبَنو إسْرائِيلَ. اذهَبُوا وَاخْدِموا اللهَ كَما قُلْتُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","خُذُوا غَنَمَكُمْ وَبَقَرَكُمْ كَما قُلْتُمْ. اذهَبُوا، وَبارِكُونِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","وَحَثَّ المِصرِيُّونَ بَنِي إسْرائِيلَ عَلَى الإسراعِ فِي الخُرُوجِ مِنَ الأرْضِ، لِأنَّهُمْ قالُوا: «سَنَمُوتُ جَمِيعاً!» ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","وَأخَذَ الشَّعبُ عَجِينَهُمْ قَبلَ أنْ يَختَمِرَ. وَهُمْ يَصُرُّونَ أوعِيَةَ العَجِينِ فِي ثِيابِهِمْ، وَيَحْمِلُونَها عَلَى أكتافِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","وَفَعَلَ بَنو إسْرائِيلَ ما قالَهُ مُوسَى لَهُمْ، فَطَلَبُوا فِضَّةً وَذَهَباً وَثِياباً مِنَ المِصرِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","وَجَعَلَ اللهُ المِصرِيِّينَ كُرَماءَ مَعَ بَنِي إسْرائِيلَ. فَأعطاهُمُ المِصرِيُّونَ ما طَلَبُوهُ. وَبِهَذا أخَذَ بَنُو إسْرائِيلَ ثَرْوَةً مِنَ المِصرِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","وَرَحَلَ بَنُو إسْرائِيلَ مِنْ مَدِينَةِ رَعَمْسِيسَ إلَى مَدِينَةِ سُكُّوتَ. كانَ هُناكَ نَحْوُ سِتِّ مِئَةِ ألفِ رَجُلٍ عَدا الأطفالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","وَخَرَجَتْ مَعَهُمْ جَماعَةٌ كَبِيرَةٌ مِنْ غَيرِ بَنِي إسْرائِيلَ، وَكَذَلِكَ الكَثِيرُ مِنَ الغَنَمْ وَالبَقَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","وَخَبَزُوا العَجِينَ الَّذِي أخرَجُوهُ مِنْ مِصرَ وَعَمِلُوا مِنهُ خُبزاً غَيرَ مُخْتَمِرٍ لِأنَّهُمْ طُرِدُوا مِنْ مِصرَ، وَلَمْ يَستَطِيعُوا أنْ يَتَأخَّرُوا لإعدادِ الطَّعامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","وَسَكَنَ بَنو إسْرائِيلَ فِي أرْضِ مِصْرَ أربَعَ مِئَةٍ وَثَلاثِينَ سَنَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","وَبَعدَ أربَعِ مِئَةٍ وَثَلاثِينَ سَنَةً، خَرَجَتْ كُلُّ صُفُوفِ شَعبِ اللهِ مِنْ أرْضِ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","كانَتْ لَيلَةً سَهِرَ اللهُ فِيها عَلَى بَنِي إسْرائِيلَ لِيُخرِجَهُمْ مِنْ أرْضِ مِصرَ، وَلِذا عَلَى بَنِي إسْرائِيلَ أنْ يُخَصِّصُوا «لَيلَةَ سَهَرٍ» للهِ، لِيَتَذَكَّرُوا إلَى الأبَدِ ما عَمِلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","وَقالَ اللهُ لِمُوسَى وَهارُونَ: «هَذِهِ هِيَ شَرِيعَةُ عِيدِ الفِصحِ: لا يَجُوزُ لأجنَبِيٍّ أنْ يَأكُلَ مِنْ ذَبِيحَةِ الفِصحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","أمّا العَبدُ المُشْتَرَى بِالمالِ، فَبَعدَ خِتانِهِ يُمكِنُ أنْ يَأكُلَ مِنهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","وَلا يَجُوزُ لِلزّائِرِ أوْ لِلأجيرِ أنْ يَأكُلَ مِنهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","«يَنبَغي أنْ يُؤكَلَ الفِصْحُ فِي بَيتٍ واحِدٍ، فَلا يَجُوزُ إخراجُ أيِّ شَيءٍ مِنَ اللَّحمِ إلَى خارِجِ البَيتِ. وَلا تَكسِرُوا عَظماً واحِداً مِنْ عِظامِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","عَلَى كُلِّ بَنِي إسْرائِيلَ أنْ يَعمَلُوا هَذا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","وَإنْ أرادَ غَرِيبٌ يَسكُنُ مَعَكُمْ أنْ يَحفَظَ عِيدَ الفِصحِ للهِ، ينبَغِي خِتانُ كُلِّ ذُكُورِهِ، حِينَئِذٍ، يُمكِنُهُ أنْ يَشْتَرِكَ فِي احتِفالِ الفِصْحِ هُوَ وَعائِلَتِهِ. فَيَكُونُ الغَرِيبُ حِينَئِذٍ كَالمُولُودِ فِي الأرْضِ. وَلا يَجُوزُ لِأحَدٍ غَيرِ مَختُونٍ أنْ يَأكُلَ مِنهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","هَذِهِ شَرِيعَةٌ واحِدَةٌ لِلمُواطِنِ المَولُودِ فِي الأرْضِ، وَلِلغَرِيبِ المُقِيمِ بَينَكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","وَعَمِلَ بَنو إسْرائِيلَ بِحَسَبِ أمرِ اللهِ لِمُوسَى وَهارُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","وَفِي ذَلِكَ اليَومِ، أخرَجَ اللهُ بَنِي إسْرائِيلَ مِنْ أرْضِ مِصرَ بِحَسَبِ صُفُوفِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«خَصِّصُوا لِي كُلَّ بِكرٍ. كُلُّ أوَّلِ مَولُودٍ فِي بَني إسْرائِيلَ مِنَ النّاسِ وَالبَهائِمِ هُوَ لِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","وَقالَ مُوسَى لِلشَّعبِ: «تَذَكَّرُوا هَذا اليَومَ حِينَ خَرَجتُمْ مِنْ مِصرَ، مِنْ بَيتِ العُبُودِيَّةِ. لِأنَّ اللهَ أخرَجَكُمْ بِقُوَّةِ يَدِهِ مِنْ هُناكَ. فَلا تَأكُلُوا أيَّ شَيءٍ فِيهِ خَمِيرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","أنتُمْ تَخرُجُونَ اليَومَ فِي شَهرِ أبِيبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","حِينَ يُحضِرُكُمُ اللهُ إلَى أرْضِ الكَنعانِيِّينَ وَالحِثِّيِّينَ وَالأمُورِيِّينَ وَالحِوِّيِّينَ وَاليَبُوسِيِّينَ، الَّتِي أقسَمَ اللهُ لِآبائِكُمْ بِأنْ يُعطِيَها لَكُمْ، أرْضاً تَفِيضُ لَبَناً وَعَسَلاً، جَهِّزُوا خِدمَةَ الخُبزِ غَيرِ المُخْتَمِرِ فِي ذَلِكَ الشَّهرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","«تاكلُونَ خُبزاً غَيرَ مُخْتَمِرٍ لِسَبعَةِ أيّامٍ، وَفِي اليَومِ السّابِعِ يَكُونُ هُناكَ احتِفالٌ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","لا تَأكُلُوا خُبزاً بِخَمِيرٍ خِلالَ هَذِهِ الأيّامِ السَّبعَةِ. وَلا يَكُنْ فِي بَيتِكَ وَلا فِي كُلِّ أرْضِكَ طَعامٌ فِيهِ خَمِيرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","وَتَقُولُ لابْنِكَ فِي ذَلِكَ الوَقتِ: ‹هَذا العِيدُ تِذْكارٌ لِما صَنَعَهُ اللهُ لَنا حِينَ خَرَجْنا مِنْ مِصرَ.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","«سَيَكُونُ هَذا العيدُ كَعَلامَةٍ عَلَى يَدِكَ، وَكَعُصابَةٍ تَعْقُدُها بَيْنَ عَيْنَيكَ. فَتَكُونُ شَرِيعَةُ اللهِ فِي فَمِكَ، لأنِّي أخرَجْتُكَ مِنْ مِصرَ بِقُوَّةِ يَدِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","فَحَافِظْ عَلَى هَذِا العِيدِ فِي مَوْعِدِهِ المُحَدَّدِ كُلَّ سَنَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«وَحِينَ يُحضِرُكَ اللهُ إلَى أرْضِ الكَنعانِيِّينَ الَّتِي أقسَمَ بِأنْ يُعطِيَها لَكَ وَلآبائِكَ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","خَصِّصْ للهِ كُلَّ بِكْرٍ، كُلَّ أوَّلِ مَولُودٍ. جَمِيعُ أوائِلِ المَواليدِ الذُّكُورِ مِنْ حَيواناتِكَ تَكُونُ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","تَفدِيَ كُلَّ بِكرِ حِمارٍ بِخَرُوفٍ. وَإنْ لَمْ تَفتَدِهِ تَكسِرْ عُنْقَهُ. يَنبَغِي أنْ تَفدِيَ كُلَّ أبْكارِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","«وَحِينَ يَسألُكَ ابْنُكَ فِي المُستَقبَلِ: ‹ما هَذا؟› قُلْ لَهُ: ‹أخرَجَنا اللهُ بِقُوَّةِ ذِراعِهِ مِنْ أرْضِ مِصرَ، مِنْ بَيتِ العُبُودِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","لَكِنْ حِينَ رَفَضَ فِرعَوْنُ بِعِنَادِهِ أنْ يُطلِقَنا، قَتَلَ اللهُ جَمِيعَ الأبْكارِ فِي أرْضِ مِصرَ. قَتَلَ أبكارَ النّاسِ وَأبكارَ الحَيواناتِ. لِذَلِكَ أنا أذبَحُ للهِ جَمِيعَ الأبْكارِ الذُّكورِ، أوَّلَ المَواليدِ مِنَ الحَيواناتِ، وَهَكَذا أفدي كُلَّ بِكْرٍ مِنْ أبْنائِي.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","سَيَكُونُ هَذا العيدُ كَعَلامَةٍ عَلَى يَدِكَ، وَكَعُصابَةٍ تَعْقُدُها بَينَ عَينَيكَ. لِأنَّ اللهَ أخرَجَنا بِقُوَّةِ يَدِهِ مِنْ مِصرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","وَحِينَ أطلَقَ فِرعَوْنُ الشَّعبَ، لَمْ يَقُدْهُمُ اللهُ فِي الطَّرِيقِ إلَى أرْضِ الفِلِسطِيِّينَ، مَعَ أنَّها كَانَتْ أقْرَبَ، لِأنَّ اللهَ قالَ: «كَي لا يُغَيِّرَ الشَّعبُ رَأيَهُمْ حِينَ يَرَونَ الحَربَ فَيَعُودُوا إلَى مِصرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","فَأدارَ اللهُ الشَّعبَ إلَى طَرِيقِ بَرِّيَّةِ البَحرِ الأحمَرِ. وَخَرَجَ بَنو إسْرائِيلَ مِنْ مِصرَ مُستَعِدِّينَ لِلحَربِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","فَأخَذَ مُوسَى عِظامَ يُوسُفَ مَعَهُ، لِأنَّ يُوسُفَ كانَ قَدِ اسْتَحلَفَ أبناءَ إسْرائِيلَ، قالَ: «مِنَ المُؤَكَّدِ أنَّ اللهَ سَيَفْتَقِدُكُمْ، فَخُذُوا عِظامِي حِينَئِذٍ مِنْ هُنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","وَارتَحَلُوا مِنْ مَدِينَةِ سُكُّوتَ وَخَيَّمُوا فِي مَدِينَةِ إيثامَ فِي طَرَفِ الصَّحْراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","وَكانَ اللهُ يَسِيرُ أمامَهُمْ فِي النَّهارِ فِي عَمُودِ سَحابٍ لِيَقُودَهُمْ فِي الطَّرِيقِ، وَفِي اللَّيلِ فِي عَمُودِ نارٍ لِيُنِيرَ لَهُمْ لِيَستَطِيعُوا أنْ يَرتَحِلُوا فِي النَّهارِ وَاللَّيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","وَبَقِيَ عَمُودُ السَّحابِ نَهاراً وَعَمُودُ النّارِ لَيلاً أمامَ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«قُلْ لِبَنِي إسْرائِيلَ أنْ يَعُودوا وَيُخَيِّمُوا أمامَ فَمِ الحِيرُوثِ، بَينَ مَجدَلَ وَالبَحرِ، أمامَ بَعلَ صَفُونَ. خَيِّمُوا أمامَهُ بِجانِبِ البَحرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","فَيَقُولُ فِرعَوْنُ: ‹إنَّهُمْ تائِهُونَ فِي الأرْضِ، وَقَدْ حُبِسُوا فِي الصَّحراءِ.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","وَسَأُقَسِّي قَلْبَ فِرعَوْنَ فَيَتْبَعَهُمْ. وَسَأتَمَجَّدُ منْ خِلالِ فِرعَوْنَ وَقُوّاتِهِ، لِيَعرِفَ المِصرِيُّونَ أنِّي أنا الإلَهُ الحَقيقيُّ.» فَفَعَلَ بَنُو إسْرائِيلَ ذَلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","وَحِينَ عَلِمَ مَلِكُ مِصْرَ أنَّ بَنِي إسْرائِيلَ قَدْ هَرَبُوا، تَغَيَّرَ رَأيُهُ هُوَ وَخُدّامُهُ بِشَأْنِهِمْ، وَقالُوا: «ما الَّذِي عَمِلْناهُ بِإطلاقِ بَنِي إسْرائِيلَ مِنْ خِدمَتِنا؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","فَجَهَّزَ فِرعَوْنُ عَرَبَتَهُ وَأخَذَ جَيشَهُ مَعَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","أخَذَ فِرعَوْنُ سِتَّ مِئَةٍ مِنْ أفْضَلِ جُنُودِهِ، مَعَ جَمِيعِ عَرَباتِ الحَرْبِ. كُلُّ عَرَبَةٍ يَقودُها جُنْدِيٌ واحِدٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","خَرَجَ بَنُو إسْرائِيلَ وَأيدِيهُمْ مَرفُوعَةٌ بِانتِصارٍ. لَكِنَّ اللهَ قَسَّى قَلبَ فِرعَوْنَ مَلِكِ مِصرَ، فَلَحِقَ بِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","لَحِقَ المِصرِيُّونَ بِبَنِي إسْرائِيلَ. وَوَصَلُوا إلَيْهِمْ وَهُمْ مُخَيِّمُونَ بِجانِبِ البَحرِ. وَصَلَتْ جَمِيعُ خُيُولِ فِرعَوْنَ وَعَرَباتِهِ وَرُكّابِها، كُلُّ جَيشِهِ، إلَى حَيثُ كانَ بَنُو إسْرائِيلَ عِندَ فَمِ الحِيرُوثِ أمامَ بَعلِ صَفُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","وَحِينَ اقتَرَبَ فِرعَوْنُ، رَفَعَ بَنو إسْرائِيلَ عُيُونَهُمْ وَرَأَوْا المِصرِيِّينَ وَراءَهُمْ، فَخافَ بَنُو إسْرائِيلَ وَصَرَخُوا إلَى اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","وَقالَ الشَّعبُ لِمُوسَى: «هَلْ أحضَرْتَنا إلَى هُنا لِنَمُوتَ فِي الصَّحراءِ، لِأنَّهُ لَمْ تَكُنْ هُناكَ قُبُورٌ فِي مِصرَ؟ لِماذا صَنَعتَ هَذا بِنا وَأخرَجْتَنا مِنْ مِصرَ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ألَيسَ هَذا ما قُلْناهُ لَكَ فِي مِصرَ: ‹دَعْنا وَشَأنَنا فَنَخْدِمَ المِصرِيِّينَ.› نُفَضِّلُ أنْ نَخدِمَ فِي مِصرَ عَلَى أنْ نَمُوتَ فِي الصَّحْراءِ!» ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","فَقالَ مُوسَى لِلشَّعبِ: «لا تَخافُوا. قِفُوا وَانظُرُوا خَلاصَ اللهِ الَّذِي سَيَصْنَعُهُ لَكُمُ اليَومَ. قَدْ رَأيتُمُ المِصرِيِّينَ اليَومَ، لَكِنْ لَنْ تَرُوهُمْ ثانِيَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","سَيُحارِبُ اللهُ عَنكُمْ، وَأنتُمْ صامِتُونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","وَقالَ اللهُ لِمُوسَى: «لِماذا تَصرُخُ إلَيَّ؟ أخبِرْ بَني إسْرائِيلَ أنْ يَستَمِرُّوا فِي الارتِحالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ارفَعْ عَصاكَ الآنَ وَمُدَّ يَدَكَ عَلَى البَحرِ وَشُقَّهُ، لِيَتَمَكَّنَ بَنُو إسْرائِيلَ مِنَ السَّيرِ عَبْرَ البَحرِ إلَى أرْضٍ يابِسَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","سَأُقَسِّي قُلُوبَ المِصرِيِّينَ لِيَتبَعُوهُمْ. سَأتَمَجَّدُ بِفِرعَونَ وَبِكُلِّ جَيشِهِ وَبِعَرَباتِهِ وَبِفُرسانِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","وَسَيَعرِفُ المِصرِيُّونَ أنِّي أنا اللهُ حِينَ أتَمَجَّدُ بِفِرعَونَ وَمَركِباتِهِ وَفُرسانِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","وَانتَقَلَ مَلاكُ اللهِ الَّذِي كانَ يَسِيرُ أمامَهُمُ وَسارَ خَلفَهُمْ. فانتَقَلَ عَمُودُ السَّحابِ مِنْ أمامِهِمْ وَوَقَفَ خَلفَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","فَوَقَفَ بَينَ مُخَيَّمِ المِصرِيِّينَ وَمُخَيَّمِ بَنِي إسْرائِيلَ. وَكانَ هُناكَ سَحابٌ وَظُلمَةٌ. وَقَدْ أضاءَ السَّحابُ اللَّيلَ. وَلَمْ يَقتَرِبْ أيٌّ مِنَ الفَرِيقَيْنِ إلَى الآخَرِ طِيلَةَ اللَّيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","وَمَدَّ مُوسَى يَدَهُ عَلَى البَحرِ، فَأزاحَ اللهُ البَحرَ إلَى الخَلفِ بِرِيحٍ شَرقِيَّةٍ قَوِيَّةٍ طَوالَ اللَّيلِ، وَحَوَّلَ البَحرَ إلَى أرْضٍ يابِسَةٍ، إذْ شَقَّ المِياهَ نِصْفينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","فَسارَ بَنو إسْرائِيلَ فِي وَسَطِ البَحرِ عَلَى أرْضٍ يابِسَةٍ. وَصارَتِ المِياهُ جِداراً لَهُمْ عَنْ يَمِينِهِمْ وَعَنْ يَسارِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","فَتَبِعَهُمُ المِصرِيِّونَ، وَتَبِعَتْهُمْ جَمِيعُ خُيُولِ فِرعَوْنَ وَعَرَباتِهِ وَفُرسانِهِ فِي وَسَطِ البَحرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","وَقُربَ الصُّبحِ، نَظَرَ اللهُ مِنْ خِلالِ النّارِ وَالسَّحابِ إلَى مُخَيَّمِ المِصرِيِّينَ، فَأفْزَعَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","وَعَطَّلَ عَجَلاتِ عَرَباتِ فِرعَوْنَ، فَساقُوها بِصُعُوبَةٍ. فَقالَ المِصرِيُّونَ: «لِنَهرُبْ مِنْ أمامِ إسْرائِيلَ، لِأنَّ اللهَ يُحارِبُ مِصرَ عَنهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","وَقالَ اللهُ لِمُوسَى: «مُدَّ يَدَكَ عَلَى البَحرِ لِتَعُودَ المِياهُ عَلَى المِصرِيِّينَ وَعَرَباتِهِمْ وَفُرسانِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","فَمَدَّ مُوسَى يَدَهُ عَلَى البَحرِ، فَعادَتِ المِياهُ كَما كانَتْ، بَينَما المِصرِيُّونَ يَهْرُبُونَ، فَغَطَّتْهُمُ المِياهُ. فأغْرَقَ اللهُ المِصرِيِّينَ فِي البَحرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","وَرَجِعَتِ المِيَاهُ وَأغرَقَتْ عَرَباتِ وَفُرسانَ جَيشِ فِرعَوْنَ الَّذِي تَبِعَهُمْ فِي البَحرِ. وَلَمْ يَنْجُ مِنهُمْ أحَدٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","وَأمّا بَنو إسْرائِيلَ فَسارُوا عَلَى أرْضٍ جافَّةٍ فِي وَسَطِ البَحرِ، وَكانَتِ المِياهُ جِداراً لَهُمْ عَنْ يَمِينِهِمْ وَعَنْ يَسارِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","فِي ذَلِكَ اليَومِ خَلَّصَ اللهُ إسْرائِيلَ مِنْ يَدِ المِصرِيِّينَ. وَرَأى بَنُو إسْرائِيلَ المِصرِيِّينَ مَوتَى عَلَى شاطِئِ البَحرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","رَأى بَنُو إسْرائِيلَ العَمَلَ العَظِيمَ الَّذِي عَمِلَهُ اللهُ ضِدَّ المِصرِيِّينَ، وَخافَ الشَّعبُ اللهَ، وَوَضَعُوا ثِقَتَهُمْ بِهِ وَبِمُوسَى خادِمِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","حِينَئِذٍ، رَنَّمَ مُوسَى وَبَنو إسْرائِيلَ هَذِهِ التَّرنِيمَةَ للهِ: «سَأُرَنِّمُ للهِ لِأنَّهُ تَمَجَّدَ جِدّاً. ألقَى بِالفَرَسِ وَراكِبِهِ إلَى البَحرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","يه هُوَ قُوَّتِي وَتَسْبيحِي. هُوَ صارَ خَلاصِي. هَذا هُوَ إلَهِي وَسَأُسَبِّحُهُ، إلَهُ آبائِي وَسَأُمَجِّدُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","اللهُ مُحارِبٌ، يهوه اسْمُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ألقَى بِعَرَباتِ فِرعَوْنَ وَجَيشِهِ إلَى البَحرِ، وَأفضَلُ ضُبّاطِهِ غَرِقُوا فِي البَحرِ الأحْمَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","غَطَّتْهُمُ الأمْواجُ. نَزَلُوا إلَى الأعماقِ مِثلَ حَجَرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","«يا اللهُ، يَدُكَ اليُمنَى مَجِيدَةٌ فِي قُوَّتِها، يا اللهُ، يَدُكَ اليُمنَى تُفَتِّتُ العَدُوَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","فِي عَظَمَةِ جَلالِكَ، طَرَحْتَ الَّذِينَ قامُوا عَلَيكَ. أرسَلْتَ غَضَبَكَ المُشتَعِلَ فَالتَهَمْتَهُمْ كَالتِّبْنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","نَفخَةُ أنفِكَ كَوَّمَتِ المِياهَ عَلَى الجانِبَينِ. وَالأعماقُ تَجَمَّدَتْ فِي قَلبِ البَحرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","«قالَ العَدُوُّ: ‹سَألحَقُ بِهِمْ، سأُمْسِكُ بِهِمْ، سَأُقَسِّمُ الغَنِيمَةَ. سَتُشبَعُ نَفسِي مِنْهُمْ. سَأُخرِجُ سَيفِي مِنْ غِمدِهِ، وَيَدِي سَتُحَطِّمُهُمْ.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","لَكِنَّكَ نَفَخْتَ بِنَفَسِكَ، فَغَطّاهُمُ البَحرُ. غرِقُوا كَالرَّصاصِ فِي مِياهِ البَحْرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","«مَنْ مِثلُكَ بَينَ الآلِهَةِ يا اللهُ؟ مَنْ مِثلُكَ فِي جَلالِ قَداسَتِكِ، وَفِي هَيبَةِ قُدْرَتِكَ، يا صَانِعَ العَجَائِبِ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","مَدَدْتَ يَدَكَ اليُمنَى فابتَلَعَتْهُمُ الأرْضُ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","أرشَدْتَ فِي مَحَبَّتِكَ هَذا الشَّعبَ الَّذِي فَدَيتَهُ، وَقُدْتَهُمْ إلَى مَسكِنِكَ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","سَمِعَتِ الشُّعُوبُ فارتَعَبَتْ. تَمَلَّكَ الرُّعبُ الفِلِسطِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","رُؤَساءُ أدُومَ مُرتَعِبُونَ. ارْتَعَشَ قادَةُ مُوآبَ. ذابَ كُلُّ سُكّانِ كَنعانَ مِنَ الخَوفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","وَقَعَ الرُّعبُ وَالخَوفُ عَلَيهِمْ. وَبِسَبَبِ عَظَمَةِ قُوَّتِكَ، صارُوا كَالحَجَرِ صامِتِينَ، إلَى أنْ عَبَرَ شَعبُكَ الَّذِي افتَدَيتَهُ يا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","سَتُحضِرُهُمْ وَتَزرَعُهُمْ عَلَى جَبَلِ مِيراثِكَ، المَكانِ الَّذِي جَعَلْتَهُ مَسكِنَكَ يا اللهُ، المَكانِ المُقَدَّسِ الَّذِي أسَّسَتْهُ يَداكَ، يا رَبُّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","اللهُ يَملُكُ إلَى أبَدِ الآبِدِينَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","لِأنَّهُ حِينَ دَخَلَتْ خُيُولُ فِرعَوْنَ وَعَرَباتُهُ وَفُرسانُهُ إلَى البَحرِ، أعادَ اللهُ مِياهَ البَحرِ عَلَيهِمْ. وَأمّا بَنُو إسْرائِيلَ فَسارُوا عَلَى أرْضٍ يابِسَةٍ فِي وَسَطِ البَحرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","وَأمسَكَتْ مَريَمُ النَّبِيَّةُ، أُختُ هارُونَ، بِالدُّفِّ فِي يَدِها، وَخَرَجَتْ كُلُّ النِّساءِ خَلفَها بِالدُّفُوفِ وَالرَّقصِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","وَغَنَّتْ مَريَمُ: «أُرَنِّمُ للهِ لِأنَّهُ تَمَجَّدَ جِدّاً. ألقَى بِالفَرَسِ وَراكِبِهِ إلَى البَحرِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","وَقادَ مُوسَى بَنِي إسْرائِيلَ مِنَ البَحرِ الأحْمَرِ، وَسارُوا إلَى صَحْراءِ شُورٍ. سارُوا ثَلاثَةً أيّامٍ فِي الصَّحْراءِ مِنْ غَيرِ أنْ يَجِدُوا ماءً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","وَحِينَ أتَوْا إلَى مَنْطِقَةِ مارَّةَ، لَمْ يَستَطِيعُوا أنْ يَشرَبُوا الماءَ الَّذِي كانَ فِيها لِأنَّهُ كانَ مُرّاً. لِذَلِكَ سُمِّيَتْ تِلْكَ المَنْطِقَةُ «مارَّة.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","وَتَذَمَّرَ الشَّعبُ عَلَى مُوسَى وَقالُوا: «ماذا سَنَشرَبُ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","فَصَرَخَ مُوسَى إلَى اللهِ، فَأراهُ اللهُ شَجَرَةً، فَطَرَحَها مُوسَى إلَى الماءِ، فَصارَ الماءُ عَذباً. فَهُناكَ أسَّسَ اللهُ فَرِيضَةً وَوَصِيَّةً لِمُوسَى، وَهُناكَ امتَحَنَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","فَقالَ لَهُ: «إنْ أطَعتَ إلَهَكَ وَعَمِلْتَ الصَّوابَ أمامَهُ، وَاستَمَعْتَ لِوَصاياهُ وَحَفِظتَ فَرائِضَهُ، فَإنِّي لَنْ أضَعَ عَلَيكَ أيَّ مَرَضٍ مِنَ الأمراضِ الَّتِي وَضَعْتُها عَلَى مِصرَ، لِأنِّي أنا اللهُ شَافِيكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","وَوَصَلُوا إلَى إيلِيمَ، حَيثُ كانَ هُناكَ اثْنا عَشَرَ نَبْعاً وَسَبْعُونَ نَخلَةً. فَخَيَّمُوا هُناكَ بِجانِبِ الماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","وَارتَحَلُوا مِنْ إيلِيمَ، وَأتَى كُلُّ بَنِي إسْرائِيلَ إلَى صَحْراءِ سِينَ، الواقِعَةِ بَينَ إيلِيمَ وَسِيناءَ. كانَ ذَلِكَ فِي اليَومِ الخامِسَ عَشَرَ مِنَ الشَّهرِ الثّانِي بَعدَ الخُرُوجِ مِنْ أرْضِ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","وَتَذَمَّرَ كُلُّ بَني إسْرائِيلَ عَلَى مُوسَى وَهارُونَ فِي الصَّحْراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","وَقالَ بَنُو إسْرائِيلَ لَهُما: «يا لَيتَنا مِتْنا بِيَدِ اللهِ فِي أرْضِ مِصرَ، حَيثُ كُنّا نَجلِسُ بِجانِبِ قُدُورِ اللَّحمِ، وَنَأْكُلُ خُبزاً إلَى الشَّبَعِ. قَدْ أحضَرْتُمانا إلَى هَذِهِ الصَّحْراءِ لِتَقتُلا الشَّعبَ بِالجُوعِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","فَقالَ اللهُ لِمُوسَى: «سَأُمطِرُ خُبزاً عَلَيكُمْ مِنَ السَّماءِ. وَسَيَخرُجُ الشَّعبُ مِنْ بُيُوتِهِمْ لِيَجمَعُوا حاجَةَ كُلِّ يَومٍ بِيَومِهِ، لِأمتَحِنَهُمْ وَأرَى إنْ كانُوا يُطِيعُونَ شَرِيعَتِي أمْ لا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","وَفِي اليَومِ السّادِسِ، عِنْدَما يُجَهِّزُونَ طَعَامَهُمْ، سَيَجِدُونَ أنَّ لَديهِمْ ضِعفَ ما يَجمَعُونَهُ فِي أيِّ يَومٍ آخَرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","وَقالَ مُوسَى وَهارُونُ لِكُلِّ بَنِي إسْرائِيلَ: «فِي المَساءِ سَتُدْرِكُونَ أنَّ اللهَ أخرَجَكُمْ مِنْ أرْضِ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","وَفِي الصَّباحِ سَتَرَوْنَ مَجدَ اللهَ لِأنَّهُ سَمِعَ تَذَمُّرَكُمْ عَلَيهِ. وَأمّا نَحنُ فَمَنْ نَكُونُ كَي تَتَذَمَّرُوا عَلَينا؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","وَقالَ مُوسَى: «سَيُعطِيكُمُ اللهُ لَحماً لِتَأْكُلُوا فِي المَساءِ، وَخُبزاً فِي الصَّباحِ لِتَشبَعُوا، لِأنَّ اللهَ سَمِعَ تَذَمُّرَكُمُ الَّذِي تَتَذَمَّرُونَ بِهِ عَلَيهِ، وَأمّا نَحنُ فَمَنْ نَكُونُ؟ تَذَمُّرُكُمْ لَيسَ عَلَينا بَلْ عَلَى اللهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","وَقالَ مُوسَى لِهارُونَ: «قُلْ لِكُلِّ بَنِي إسْرائِيلَ: ‹اقتَرِبُوا إلَى اللهِ فَقَدْ سَمِعَ تَذَمُّرَكُمْ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","وَحِينَ كَلَّمَ هارُونُ كُلَّ بَني إسْرائِيلَ، التَفَتُوا نَحوَ الصَّحْراءِ فَرَأَوْا مَجدَ اللهِ ظاهِراً فِي السَّحابِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«قَدْ سَمِعْتُ تَذَمُّرَ بَنِي إسْرائِيلَ. قُلْ لَهُمْ: ‹فِي المَساءِ سَتَأكُلُونَ لَحماً، وَفِي الصَّباحِ سَتَشبَعُونَ مِنَ الخُبزِ، كَي تَعرِفُوا أنِّي أنا إلَهُكُمْ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","وَفِي المَساءِ أتَتْ طُيُورُ السَّلوَى وَغَطَّتِ المُخَيَّمَ. وَفِي الصَّباحِ، كانَتْ هُناكَ طَبَقَةٌ مِنَ النَّدَى حَولَ المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","وَحِينَ اختَفَتْ طَبَقَةُ النَّدَى، ظَهَرَتْ طَبَقَةٌ رَقِيقَةٌ مِنَ الجَلِيدِ عَلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","فَحِينَ رَأى بَنو إسْرائِيلَ هَذا الشِّيءَ قالَ بَعضُهُمْ لِبَعضٍ: «ما هَذا؟» لِأنَّهُمْ لَمْ يَكُونُوا يَعرِفُونَ ما هُوَ. فَقالَ مُوسَى لَهُمْ: «إنَّهُ الخُبزُ الَّذِي أعطاهُ اللهُ لَكُمْ لِتَأكُلُوهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","فَهَذا هُوَ ما أمَرَ بِهِ اللهُ: ‹لِيَجمَعْ كُلُّ واحِدٍ ما يَستَطِيعُ أكلَهُ. اجمَعُوا مِلْءَ سَلَّةٍ لِكُلِّ واحِدٍ، بِحَسَبِ عَدَدِ الأفْرادِ الَّذِينَ فِي خَيمَتِهِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","فَعَمِلَ بَنو إسْرائِيلَ بِحَسَبِ هَذا الكَلامِ، فَجَمَعَ بَعضُهُمُ الكَثِيرَ، وَجَمَعَ بَعضُهُمُ القَلِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","وَحِينَ قاسُوا كَمِّيّاتِ الطَّعامِ بِالسِلالِ، وَجَدوا أنَّ الَّذِينَ جَمَعُوا كَثِيراً لَمْ يَفِيضُوا عَنْ حاجَتِهِمْ، وَالَّذِينَ جَمَعُوا قَليلاً لَمْ يَنْقُصْهُمْ شَيءٌ. فَقَدْ جَمَعَ كُلُّ واحِدٍ حَسَبَ احْتِياجِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","وَقالَ مُوسَى لَهُمْ: «لا تُبقُوا مِنهُ شَيئاً إلَى الصَّباحِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","لَكِنَّهُمْ لَمْ يَستَمِعُوا لِمُوسَى، فَتَرَكَ بَعضُهُمْ شَيئاً مِنهُ إلَى الصَّباحِ، فَظَهَرَ فِيهِ دُودٌ وَأنتَنَ. حِينَئِذٍ، غَضِبَ مُوسَى عَلَيهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","وَفِي كُلِّ صَباحٍ، كانَ كُلُّ واحِدٍ مِنهُمْ يَجمَعُ بِحَسَبِ قُدرَتِهِ عَلَى الأكلِ. وَحِينَ كانَتِ حَرارَةُ الشَّمسِ تَزيدُ، يَذُوبُ الطَّعامُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","وَكانُوا فِي اليَومِ السّادِسِ يَجمَعُونَ ضِعفَ الكَمِّيَّةِ المُعتادَةِ، مِلْءَ سَلَّتَيْنِ لِكُلِّ فَردٍ. فَجاءَ كُلُّ رُؤَساءِ الشَّعبِ وَأخبَرُوا مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","فَقالَ لَهُمْ: «هَذا ما أمَرَ اللهُ بِهِ: ‹غَداً هُوَ السَّبتُ، يَومُ راحَةٍ مُقَدَّسَةٍ للهِ. اخبِزُوا قَدْرَ ما تُرِيدُونَ، وَاسلِقُوا قَدْرَ ما تُرِيدُونَ، وَاحتَفِظُوا بِما يَتَبَقَّى إلَى الصَّباحِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","فَاحْتَفَظُوا بِهِ حَتَّى الصَّباحِ كَما أمَرَ مُوسَى، وَلَمْ يُنتِنْ وَلَمْ يَكُنْ فِيهِ دُودٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","وَقالَ مُوسَى: «كُلُوهُ اليَومَ، لِأنَّ اليَومَ سَبتٌ للهِ. لَنْ تَجِدُوهُ اليَومَ فِي الحَقلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","تَجمَعُونَهُ سِتَّةَ أيّامٍ، لَكِنْ فِي اليَومِ السّابِعِ، يَومِ السَّبتِ، لَنْ تَجِدُوهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","وَفِي اليَومِ السّابِعِ خَرَجَ بَعضُ النّاسِ لِيَجمَعُوا المَنَّ، لَكِنَّهُمْ لَمْ يَجِدُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","وَقالَ اللهُ لِمُوسَى: «إلَى مَتَى تَرفُضُونَ إطاعَةَ وَصايايَ وَشَرائِعِي؟ ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ها إنَّ اللهَ أعطاكُمُ السَّبتَ، وَلِهَذا فَهُوَ يُعطِيكُمْ طَعاماً لِيَومَينِ فِي اليَومِ السّادِسِ. عَلَى كُلِّ واحِدٍ مِنكُمْ أنْ يَبقَى فِي البَيتِ. لا يَخرُجْ أحَدٌ مِنْ مَكانِهِ فِي اليَومِ السّابِعِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","فَاسْتَراحَ الشَّعبُ فِي اليَومِ السّابِعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","وَسَمَّى بَنو إسْرائِيلَ ذَلِكَ الطَّعامَ «مَنَّ.» وَهُوَ يُشبِهُ بُذُورَ الكُزبَرَةِ، وَلَونُهُ أبْيَضُ، وَطَعمُهُ كَكَعكٍ بِالعَسَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","وَقالَ مُوسَى: «هَذا ما أمَرَ اللهُ بِهِ: ‹احْتَفِظُوا بِمِلءِ سَلَّةٍ مِنَ المَنِّ لِأجلِ أجيالِكُمْ فِي المُستَقبَلِ، لِكَي يَرَوا الخُبزَ الَّذِي أعطَيتُهُ لَكُمْ لِتَأكُلُوهُ فِي الصَّحْراءِ حِينَ أخرَجتُكُمْ مِنْ أرْضِ مِصرَ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","وَقالَ مُوسَى لِهارُونَ: «خُذْ مِلءَ سَلَّةٍ مِنَ المَنِّ، وَضَعْهُ فِي حَضرَةِ اللهِ لِلاحتِفاظِ بِهِ لِأجيالِكُمْ فِي المُستَقبَلِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","فَوَضَعَهُ هارُونُ أمامَ صَنْدُوقِ الشَّهادَةِ لِحِفظِهِ كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","وَأكَلَ بَنو إسْرائِيلَ المَنَّ لِأربَعِينَ سَنَةً، إلَى أنْ جاءُوا إلَى أرْضٍ مَسكُونَةٍ. أكَلُوا المَنَّ إلَى أنْ أتَوْا إلَى حُدُودِ أرْضِ كَنعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","وَكانَ حَجمُ السَّلَّةِ نَحْوَ عُشْرِ القُفَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","وَسافَرَ جَمِيعُ بَني إسْرائِيلَ مِنْ صَحْراءِ سِينَ عَلَى مَراحِلَ، كَما قالَ اللهُ لَهُمْ. وَخَيَّمُوا فِي مَنْطِقَةِ رَفِيدِيمَ، لَكِنْ لَمْ يَكُنْ هُناكَ ماءٌ لِيَشرَبُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","فَتَجادَلَ الشَّعبُ مَعَ مُوسَى، وَقالُوا لَهُ: «أعطِنا ماءً لِنَشرَبَ.» فَقالَ مُوسَى لَهُمْ: «لِماذا تُخاصِمُونَنِي؟ لِماذا تُجَرِّبُونَ صَبرَ اللهِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","لَكِنَّهُمْ عَطِشُوا وَتَذَمَّرُوا عَلَى مُوسَى وَقالُوا: «لِماذا أخرَجْتَنا مِنْ مِصرَ، لِتَقتُلَنا نَحنُ وَأولادَنا وَماشِيَتَنا بِالعَطَشِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","فَصَرَخَ مُوسَى إلَى اللهِ وَقالَ: «ماذا أفعَلُ بِهَذا الشَّعبِ؟ إنَّهُمْ يَكادُونَ يَرجُمُونَنِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","وَقالَ اللهُ لِمُوسَى: «مُرَّ مِنْ أمامِ الشَّعبِ، وَخُذْ مَعكَ بَعضَ شُيُوخِ إسْرائِيلَ. وَخُذْ بِيَدِكَ عَصاكَ الَّتِي ضَرَبْتَ بِها نَهْرَ النِّيلَ، وَاذْهَبْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","سَأقِفُ أمامَكَ هُناكَ عَلَى صَخرَةِ حُورِيبَ. فَحِينَ تَضرِبُ الصَّخرَةَ، سَيَخرُجُ مِنها ماءٌ لِيَشرَبَ الشَّعبُ.» فَفَعَلَ مُوسَى ذَلِكَ أمامَ شُيُوخِ إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","وَدَعا المَكانَ بِاسْمِ «مَسَّةَ وَمَرِيبَةَ» بِسَبَبِ مُخاصَمَةِ بَني إسْرائِيلَ للهِ وَبِسَبَبِ تَجرِبَتِهِمْ لِصَبرِهِ، إذْ قالُوا: «لِنَرَ إنْ كانَ يهوه فِي وَسَطِنا أمْ لا؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","وَأتَتْ قَبِيلَةُ عَمالِيقَ لِمُحارَبَةِ إسْرائِيلَ فِي رَفِيدِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","فَقالَ مُوسَى لِيَشُوعَ: «اختَرْ رِجالاً، وَاخرُجْ حارِبْ قَبِيلَةَ عَمالِيقَ. وَسَأقِفُ أنا غَداً عَلَى قِمَّةِ التَّلَّةِ وَعَصا اللهِ فِي يَدِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","فَعَمِلَ يَشُوعُ كَما قالَ مُوسَى لَهُ، فَحارَبَ قَبِيلَةَ عَمالِيقَ. وَصَعِدَ مُوسَى وَهارُونُ وَحُورُ إلَى قِمَّةِ التَّلَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","وَحِينَ كانَ مُوسَى يَرفَعُ يَدَيهِ، كانَ إسْرائِيلُ يَنتَصِرُ. وَحِينَ كانَ يُنزِلُ يَدَيهِ، كانَ عَمالِيقُ يَنتَصِرُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","وَحِينَ تَعِبَتْ يَدا مُوسَى، أخَذَ هارُونُ وَحُورُ حَجَراً وَوَضَعاهُ تَحْتَهُ. فَجَلَسَ مُوسَى عَلَى الحَجَرِ. وَأسْنَدَ هارُونُ وَحُورُ يَدَيهِ، كُلُّ واحِدٍ مِنْ جِهَةٍ. فَظَلَّتْ يَداهُ ثابِتَتَينِ إلَى غُرُوبِ الشَّمسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","وَهَزَمَ يَشُوعُ عَمالِيقَ وَشَعبَهُ بِحَدِّ السَّيفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","وَقالَ اللهُ لِمُوسَى: «اكتُبْ هَذا لِلذِّكرَى فِي كِتابٍ، وَقُلْ عَلَى مَسمَعِ يَشُوعَ: ‹سَأُلاشِي كُلَّ أثَرٍ لِقَبِيلَةِ عَمالِيقَ مِنْ تَحْتِ السَّماءِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","وَبَنَى مُوسَى مَذبَحاً، وَدَعاهُ «يهوه رايَتِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","وَقالَ: «أرفَعُ يَدَيَّ نَحوَ عَرشِ اللهِ وَأُقسِمُ: سَيُحارِبُ اللهُ قَبِيلَةَ عَمالِيقَ إلَى الأبَدِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","وَسَمِعَ يَثرُونُ كاهِنُ مِديانَ، حَمُو مُوسَى، عَنْ كُلِّ ما عَمِلَهُ اللهُ لِمُوسَى وَإسْرائِيلَ شَعبِهِ، وَكَيفَ أنَّ اللهَ أخرَجَهُمْ مِنْ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","فَاصْطَحَبَ يَثرُونُ، حَمُو مُوسَى، ابْنَتَهُ صِفُّورَةَ زَوجَةَ مُوسَى. وَكَانَ مُوسَى قَدْ أرسَلَها إلَى أبيها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","وَجاءَ مَعَها ابْناها. اسْمُ أحَدِهِما جِرْشُومُ، لِأنَّ مُوسَى قالَ: «كُنتُ غَريباً فِي أرْضٍ غَرِيبَةٍ،» ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","وَاسْمُ الآخَرِ ألِيعازَرُ، لِأنَّ مُوسَى قالَ: «إلَهُ أبِي هُوَ مُعِينِي، وَقَدْ أنقَذَنِي مِنْ سَيفِ فِرعَوْنَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","وَذَهَبَ يَثرُونُ حَمُو مُوسَى مَعَ ابْنَي مُوسَى وَزَوجَتِهِ إلَى مُوسَى إلَى الصَّحْراءِ، حَيثُ كانَ مُخَيِّماً قُربَ جَبَلِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","وَأرْسَلَ إلَى مُوسَى رَسُولاً يَقُولُ لَهُ: «أنا يَثرُونُ حَمُوكَ أتَيْتُ إلَيكَ مَعَ زَوجَتِكَ وَابْنَيكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","فَخَرَجَ مُوسَى لِلِقاءِ حَمِيهِ، وَانحَنَى وَقَبَّلَهُ. وَبَعْدَ أنْ سَلَّمَ كُلُّ مِنْهُما عَلَى الآخَرِ، دَخَلا الخَيمَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","وَرَوَى مُوسَى لِحَمِيهِ كُلَّ ما عَمِلَهُ اللهُ لِفِرعَونَ وَلِمِصرَ لِأجلِ بَنِي إسْرائِيلَ، وَكُلَّ الضِّيقِ الَّذِي واجَهَهُ بَنُو إسْرائِيلَ فِي الطَّرِيقِ، وَكَيفَ أنقَذَهُمُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","فَفَرِحَ يَثرُونُ بِكُلِّ الخَيرِ الَّذِي عَمِلَهُ اللهُ لِبَنِي إسْرائِيلَ إذْ أنقَذَهُمْ مِنْ أيْدِي المِصْريّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","وَقالَ يَثْرُونُ: «مُبارَكٌ اللهُ الَّذِي أنقَذَكُمْ مِنْ أيْدِي المِصْرِيّينَ وَمِنْ يَدِ فِرعَوْنَ، أنقَذَ الشَّعبَ مِنْ تَسَلُّطِ المِصرِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","الآنَ صِرتُ أعرِفُ أنَّ يهوه أعظَمُ مِنْ كُلِّ الآلِهَةِ، لِأنَّهُ أنقَذَ شَعبَهُ مِنْ تَسَلُّطِ مِصرَ، حِينَ ظَلَمَهُمُ المِصرِيُّونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","وَقَدَّمَ يَثرُونُ حَمُو مُوسَى ذَبيحَةً وَقَرابينَ للهِ. وَأتَى هارُونُ وَكُلُّ شُيُوخِ إسْرائِيلَ وَأكَلُوا مَعاً مَعَ حَمِي مُوسَى فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","وَفِي اليَومِ التّالِي، جَلَسَ مُوسَى لِيَنْظُرَ فِي قَضايا الشَّعبِ. وَوَقَفَ الشَّعبُ حَولَ مُوسَى مِنَ الصَّباحِ إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","فَلَمّا رَأى حَمُو مُوسَى كُلَّ ما كانَ مُوسَى يَعمَلُهُ لِلشَّعبِ، قالَ: «ماذا تَفْعَلُ؟ لِماذا تَجلِسُ وَحدَكَ وَيَقِفُ كُلُّ هَؤُلاءِ النّاسِ حَولَكَ مِنَ الصَّباحِ إلَى المَساءِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","فَقالَ مُوسَى لِحَمِيهِ: «إنَّهُمْ يأتُونَ إلَيَّ لِيسألُوا اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","وَحِينَ يَكُونُ بَينَهُمْ خِلافٌ، يَأتُونَ إلَيَّ لأحكُمَ بَينَ المُتَخاصِمِينَ، وَأُعَرِّفُهُمْ بِفَرائِضِ اللهِ وَشَرائِعِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","فَقالَ حَمُو مُوسَى: «لَيسَ جَيِّداً هَذا الَّذِي تَفعَلُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","هَذا مُنهِكٌ لَكَ وَلِلشَّعبِ، لِأنَّ هَذا العَمَلَ صَعبٌ جِدّاً عَلَيكَ، وَلا تَستَطِيعُ القِيامَ بِهِ وَحدَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","وَالآنَ استَمِعْ إلَيَّ. سَأنصَحُكَ وَأُصَلِّي أنْ يَكُونَ اللهُ مَعَكَ. كُنْ مُمَثِّلَ اللهِ لِلشَّعبِ، وَقَدِّمْ خِلافاتِهِمْ وَقَضاياهُمْ إلَى اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","تَستَطِيعُ أنْ تُعَلِّمَهُمُ الفَرائِضَ وَالشَّرائِعَ وَأنْ تُعَرِّفَهُمُ الطَّرِيقَ الَّذِي يَسلُكُونَهُ، وَالأعْمالَ الَّتِي يَعْمَلُونَها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","«لَكِنِ اخْتَرْ مِنَ الشَّعبِ رِجالاً شُرَفاءَ يَخافُونَ اللهَ، أُمَناءَ يَكرَهُونَ الرِّشوَةَ، فَتُعَيِّنَهُمْ عَلَى الشَّعبِ قادَةَ أُلُوفٍ وَمِئاتٍ وَخَماسِينَ وَعَشَراتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","يَنْظُرُ القادَةُ فِي قَضايا الشَّعبِ كُلَّ الوَقتِ. فَيُحَوِّلُونَ القَضايا الكَبِيرَةَ إلَيكَ. وَأمّا القَضايا الصَّغِيرَةُ فَيَحْكُمُونَ فِيها بِأنفُسِهِمْ. سَيُسَهِّلُ هَذا عَمَلَكَ لأنَّهُمْ سَيَحمِلُونَ الأعْباءَ مَعَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","«إنْ عَمِلتَ هَذا، وَأوصاكَ اللهُ بِعَمَلِهِ، تَصِيرُ قادِراً عَلَى احتِمالِ العَمَلِ. وَسَيَذهَبُ هَؤُلاءِ النّاسُ إلَى بُيُوتِهِمْ بِسَلامٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","فَاسْتَمَعَ مُوسَى لِحَمِيهِ وَعَمِلَ ما قالَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","فاختارَ رِجالاً شُرَفاءَ مِنْ كُلِّ بَنِي إسْرائِيلَ، وَعَيَّنَهُمْ قادَةً لِلشَّعبِ، رُؤَساءَ أُلُوفٍ وَمِئاتٍ وَخَماسِينَ وَعَشَراتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","فَكانُوا يَنْظُرُونَ فِي قَضايا الشَّعبِ كُلَّ الوَقتِ، فَيُحضِرُونَ القَضَايا الصَّعْبَةَ إلَى مُوسَى، بَينَما يَحكُمُونَ هُمْ فِي المَشاكِلِ الصَّغِيرَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ثُمَّ وَدَّعَ مُوسَى حَماهُ، فَعَادَ إلَى أرْضِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","فِي نِهَايَةِ الشَّهرِ الثّالِثِ بَعدَ خُرُوجِ بَنِي إسْرائِيلَ مِنْ مِصرَ، وَصَلُوا إلَى صَحْراءِ سِيناءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","فَقَدِ ارتَحَلُوا مِنْ رَفِيدِيمَ، وَأتَوْا إلَى صَحْراءِ سِيناءَ، وَخَيَّمُوا هُناكَ. وَبَينَما كانَ بَنُو إسْرائِيلَ مُخَيِّمِينَ مُقابِلَ الجَبَلِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","صَعِدَ مُوسَى إلَى الجَبَلِ، فَدَعاهُ اللهُ مِنَ الجَبَلِ وَقالَ: «هَذا ما تَقُولُهُ لِبَيتِ يَعقُوبَ، وَتُخْبِرُ بِهِ بَني إسْرائِيلَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹قَدْ رَأيتُمْ ما عَمِلْتُهُ بِالمَصْرِيينَ. أمَّا أنْتُمْ فَحَمَلْتُكُمْ عَلَى أجنِحَةِ النُّسُورِ وَأحضَرْتُكُمْ إلَيَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","وَالآنَ، إنْ أطَعتُمُونِي وَحَفِظتُمْ عَهدِي، سَتُصبِحُونَ كَنزاً لِي مِنْ بَينِ كُلِّ الشُّعُوبِ، لِأنَّ الأرْضَ كُلَّها لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","سَتَصِيرُونَ لِي مَملَكَةَ كَهَنَةٍ، وَأُمَّةً مُقَدَّسَةً.› هَذا ما تَقُولَهُ لِبَنِي إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","فَاسْتَدعَى مُوسَى شُيُوخَ الشَّعبِ، وَأخبَرَهُمْ بِكُلِّ الكَلامِ الَّذِي أمَرَهُ اللهُ بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","فَأجابَ الشَّعبُ مَعاً وَقالُوا: «سَنَفعَلُ كُلَّ ما قالَهُ اللهُ.» وَبَلَّغَ مُوسَى اللهَ بِجَوابِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","فَقالَ اللهُ لِمُوسَى: «سَآتِي إلَيكَ فِي سَحابَةٍ كَثِيفَةٍ لِيَسمَعَ الشَّعبُ حِينَ أتَكَلَّمُ مَعَكَ فَيَثِقُوا بِكَ دَائِماً.» وَأخبَرَ مُوسَى اللهَ بِكَلامِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","وَقالَ اللهُ لِمُوسَى: «اذْهَبْ إلَى الشَّعبِ وَقَدِّسْهُمُ اليَومَ وَغَداً، وَمُرْهُمْ بِغَسلِ ثِيابِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","فَليَكُونُوا مُستَعِدِّينَ فِي اليَومِ الثّالِثِ، لِأنَّ اللهَ سَيَنْزِلُ فِي اليَومِ الثّالِثِ أمامَ كُلِّ الشَّعبِ عَلَى جَبَلِ سِيناءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","«لَكِنْ ضَعْ حُدُوداً لِلشَّعبِ حَولَ الجَبَلِ، وَقُلْ لَهُمْ: ‹احذَرُوا الاقْتِرابَ مِنَ الجَبَلِ أوْ لَمْسِهِ. فَكُلُّ مَنْ يَلمِسُهُ يُقتَلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","فَمَنْ يَتَعَدَّى الحُدُودَ، لا يَنبغِي أنْ يَلْمِسَهُ أحَدٌ بِيَدِهِ، بَلْ يُرجَمَ أوْ يُرمى بِسَهْمٍ. سَواءٌ أكانَ إنساناً أمْ حَيواناً، لا يَعِيشَ!› لَكِنْ حِينَ يُضرَبُ بِالبُوقِ نَغَمَةً طَوِيلَةً، يُمكِنُهُمُ الصُّعُودُ إلَى الجَبَلِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","فَنَزَلَ مُوسَى مِنَ الجَبَلِ إلَى الشَّعبِ، وَقَدَّسَ الشَّعبَ، وَغَسَلَ الشَّعبُ ثِيابَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","وَقالَ مُوسَى لِلشَّعبِ: «كُونُوا مُستَعِدِّينَ لِأجلِ اليَومِ الثّالِثِ، وَلا تُعَاشِرُوا نِسَاءَكُمْ حَتَّى ذَلِكَ الحِينِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","وَفِي صَباحِ اليَومِ الثّالِثِ، كانَ هُناكَ رَعدٌ وَبَرقٌ وَسَحابٌ كَثِيفٌ عَلَى الجَبَلِ، وَصَوتُ بُوقٍ مُرتَفِعٌ. فارتَعَدَ كُلُّ الشَّعبِ الَّذِي كانَ فِي المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","وَأخرَجَ مُوسَى الشَّعبَ مِنَ المُخَيَّمِ لِلِقاءِ اللهِ، فَوَقَفُوا فِي أسفَلِ الجَبَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","وَكانَ جَبَلُ سِيناءَ كُلُّهُ مُغَطَّىً بِالدُّخانِ، لِأنَّ اللهَ نَزَلَ عَلَيهِ فِي نارٍ. وَصَعِدَ الدُّخانُ مِنَ الجَبَلِ كَدُخانِ الفُرنِ. وَكانَ كُلُّ الجَبَلِ يَهتَزُّ بِقُوَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","وَاستَمَرَّ صَوتُ البُوقِ بِالارتِفاعِ، بَينَما كانَ مُوسَى يَتَكَلَّمُ وَاللهُ يُجِيبُهُ بِصَوتٍ كَصَوتِ الرَّعدِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","وَنَزَلَ اللهُ عَلَى قِمَّةِ جَبَلِ سِيناءَ، وَدَعا مُوسَى إلَى الصُّعُودِ إلَى قِمَّةِ الجَبَلِ. فَصَعِدَ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","وَقالَ اللهُ لِمُوسَى: «انزِلْ وَحَذِّرِ الشَّعبَ لِئَلّا يَقتَحِمُوا مَحْضَرَ اللهِ لِيَنظُرُوا، فَيَسقُطَ كَثِيرُونَ مَوتَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","حَتَّى الكَهَنَةُ الَّذِينَ يَقتَرِبُونَ إلَى اللهِ، فَلْيُقَدِّسُوا أنفُسَهُمْ لِلِقائِي لِئَلّا أقضِيَ عَلَيهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","وَقالَ مُوسَى للهِ: «لا يَستَطِيعُ الشَّعبُ أنْ يَصْعَدَ إلَى جَبَلِ سِيناءَ، لِأنَّكَ حَذَّرْتَهُمْ بِنَفسِكَ فَقُلتَ: ‹ضَعْ حُدُوداً حَولَ الجَبَلِ وَقَدِّسْهُ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","وَقالَ اللهُ لِمُوسَى: «انزِلْ ثُمَّ اصعَدْ وَهارُونُ مَعَكَ. لَكِنْ لا تَسْمَحْ لِلكَهَنَةِ أوِ الشَّعبَ بِالصُّعُودِ لاقْتِحامِ مَحْضَرِ اللهِ، لِئَلّا يَقتَحِمَهُمُ اللهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","فَنَزَلَ مُوسَى إلَى الشَّعبِ وَقالَ لَهُمْ ذَلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","وَتَكَلَّمَ اللهُ بِكُلِّ هَذا الكَلامِ فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«أنا إلَهُكَ الَّذِي أخْرَجَكَ مِنْ أرْضِ مِصرَ، مِنْ بَيْتِ العُبُودِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«لا تَعْبُدْ آلِهَةً أُخْرَى مَعِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«لا تَصنَعْ لِنَفسِكَ تَمثالاً بِأيِّ شَكلٍ مِمّا فِي السَّماواتِ مِنْ فَوقُ، أوْ عَلَى الأرْضِ مِنْ تَحتُ، أوْ فِي الماءِ مِنْ تَحتِ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","لا تَسجُدَ لَها أوْ تَعبُدَها، لِأنِّي أنا إلَهَكَ إلَهٌ غَيُّورٌ. أحْسِبُ خَطايا الآباءِ فِي أولادِهِمْ وَأحْفَادِهِمْ وَأولادِ أحْفادِهِمُ مِنَ الَّذينَ يُبغِضُونَنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","لَكِنِّي أُحسِنُ لِلَّذينَ يُحِبُّونَنِي وَيَحفَظُونَ وَصايايَ إلَى الجِيلِ الألفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«لا تَنْطِقْ بِاسْمِ إلَهِكَ عَبَثاً، لِأنَّ اللهَ لَنْ يُبَرِّئَ مَنْ يَنْطِقُ بِاسْمِهِ عَبَثاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«تَنَبَّهْ لِيَومِ السَّبتِ وَخَصِّصْهُ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","تَعمَلُ سِتَّةَ أيّامٍ تُنْهِي فِيها مَا عَلَيكَ مِنْ أعْمالٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","وَأمّا اليَومُ السَّابِعُ فَهُوَ سَبتٌ، أيْ راحَةٌ، إكْراماً لإلَهِكَ. فَلا تَعمَلْ أيَّ عَمَلٍ فِيهِ، لا أنتَ وَلا ابْنُكَ وَلا ابْنَتُكَ وَلا عَبْدُكَ وَلا جارِيَتُكَ، وَلا حَيواناتُكَ، وَلا الغَرِيبُ المُقِيمُ فِي مُدُنِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","فَاللهُ خَلَقَ السَّماءَ وَالأرْضَ وَالبِحارَ وَكُلَّ ما فِيها فِي سِتَّةِ أيّامٍ، وَاستَراحَ فِي اليَومِ السّابِعِ. لِهَذا بارَكَ اللهُ اليَومَ السّابِعَ وَقَدَّسَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«أكرِمْ أباكَ وَأُمَّكَ، لِكَي يَطُولَ عُمْرُكَ عَلَى الأرْضِ الَّتِي يُعطِيها إلَهُكَ لَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«لا تَقْتُلْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«لا تَزْنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«لا تَسْرِقْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«لا تَشْهَدْ عَلَى صَاحِبِكَ زُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«لا تَشْتَهِ بَيتَ صَاحِبِكَ، وَلا تَشْتَهِ زَوجَتَهُ أوْ عَبدَهُ أوْ جارِيَتَهُ أوْ ثَورَهُ أوْ حِمارَهُ، أوْ أيَّ شَيءٍ يَخُصُّ صاحِبَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","وَرَأى الشَّعبُ الرَّعدَ وَالبَرقَ وَالدُّخانَ الَّذِي عَلَى الجَبَلِ، وَسَمِعُوا صَوتَ البُوقِ. فارتَعَدَ الشَّعبُ خَوفاً وَوَقَفُوا مِنْ بَعِيدٍ ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","وَقالُوا لِمُوسَى: «تَكَلَّمْ أنْتَ إلَينا فَنَسمَعُكَ. لَكِنْ قُلْ للهِ أنْ لا يَتَكَلَّمَ إلَينا لِئَلّا نَمُوتَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","وَقالَ مُوسَى لِلشَّعبِ: «لا تَخافُوا، لِأنَّ اللهَ قَدْ جاءَ لِيَمتَحِنَكُمْ، كَي تَهابُوهُ وَلا تُخطِئُوا.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","فَوَقَفَ الشَّعبُ مِنْ بَعِيدٍ، وَأمّا مُوسَى فَاقتَرَبَ إلَى السَّحابَةِ الكَثِيفَةِ الَّتِي كانَ اللهُ فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","وَقالَ اللهُ لِمُوسَى: «هَذا ما تَقُولُهُ لِبَنِي إسْرائِيلَ: ‹هَا إنَّنِي قَدْ تَكَلَّمْتُ مَعَكُمْ مِنَ السَّماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","فَلا تَصنَعُوا لَكُمْ آلِهَةً مِنَ الفِضَّةِ أوِ الذَّهَبِ لِتَعبُدُوها مَعِي، وَلا تَصنَعُوها لِأنفُسِكُمْ.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","«اصْنَعْ لِي مَذْبَحاً مِنْ تُرَابٍ، وَاذْبَحْ عَلَيهِ الذَّبائِحَ الصّاعِدَةَ وَتَقدِماتِ السَّلامِ مِنْ غَنَمِكَ وَبَقَرِكَ. افعَلْ ذَلِكَ فِي كُلِّ مَكانٍ أُحَدِّدُهُ لِذِكْرِ اسْمِي. فَآتِي إلَيكَ وَأُبارِكُكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","«وَإنْ صَنَعتَ لِي مَذبَحاً مِنْ حِجارَةٍ، فابْنِهِ مِنْ حِجارَةٍ لُمْ تُشَّذَبْ بِإزْميلٍ. إنِ استَخدَمْتَ الإزْمِيلَ تُنَجِّسُها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","وَلا تَصعَدْ إلَى مَذبَحِي عَلَى سُلَّمٍ لِئَلّا يَنكَشِفَ عُرْيُكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","وَقالَ اللهُ لِمُوسَى: «هَذِهِ هِيَ الشَرائِعِ الَّتِي تُعلِنُها لِلشَّعْبِ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","«حِينَ تَشتَرِي عَبداً عِبرانِيّاً، فَلْيَخدِمْكَ لِسِتِّ سَنَواتٍ. لَكِنْ فِي السَّنَةِ السّابِعَةِ تُطلِقُهُ حُرّاً مِنْ دُونِ أنْ يَدْفَعَ شَيئاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","إنْ كانَ أعزَبَ حِينَ اشتَرَيتَهُ، يَخرُجُ وَحدَهُ. وَإنْ كانَ مُتَزَوِّجاً، تَخرُجُ زَوجَتُهُ مَعَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","إنْ زَوَّجَهُ سَيِّدُهُ امْرأةً وَأنجَبَتْ لَهُ بَنِينَ وَبَناتٍ، فَإنَّ المَرأةَ وَالأولادَ يَكُونُونَ لِسَيِّدِهِمْ، أمّا هُوَ فَيَخرُجُ وَحدَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","«فَإنْ قالَ العَبدُ: ‹أُحِبُّ سَيِّدِي وَزَوجَتِي وَأولادِي، وَلَنْ أخرُجَ حُرّاً.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","يُقَدِّمُهُ سَيِّدُهُ إلَى القُضاةِ، وَيُوقِفُهُ في البابِ أوْ قائِمَتِهِ، وَيَثقُبُ أُذُنَهُ بِمِثقَبٍ، فَيَكُونُ عَلَى العَبدِ أنْ يَخدِمَهُ إلَى الأبَدِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«إذا باعَ رَجُلٌ ابْنَتَهُ كَجارِيَةٍ، فَإنَّها لا تَتَحَرَّرُ بِالطَّريقَةِ الَّتِي يَتَحَرَّرُ بِها العَبِيدُ الذُّكُورُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","إنْ لَمْ تُرْضِي سَيِّدَها الَّذِي اشْتَراها لِنَفسِهِ، يَسْمَحُ لأحَدِ أقَارِبِها أنْ يَفْدِيَها. لا يَحِقُّ لَهُ أنْ يَبِيعَها لِواحِدٍ مِنْ شَعبٍ غَرِيبٍ، لِأنَّهُ غَدَرَ بِها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","«فَإنْ زَوَّجَها مِنِ ابْنِهِ، يَنبَغِي أنْ يُعامِلَها كَابْنَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","«فَإنْ أبْقاها وَتَزَوَّجَ امْرأةً أُخْرَى، فَلا يُقَلِّلُ مِنْ طَعامِها أوْ ثِيابِها أوْ حُقُوقِها الزَّوجِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","فَإنْ لَمْ يَعمَلْ لَها أحَدَ هَذِهِ الخَياراتِ الثَّلاثَةَ، تَخرُجُ حُرَّةً مِنْ دُونِ فِديَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«مَنْ ضَرِبَ شَخْصاً وَقَتَلَهُ، يُقتَلُ قَتلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","لَكِنْ إنْ لَمْ يَتَعَمَّدْ قَتلَهُ، بَلْ أتاحَ اللهُ ذَلِكَ بِيَديهِ، فَإنِّي سَأُعطِيهِ مَكاناً لِيَهرُبَ إلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","لَكِنْ إنْ غَدَرَ رَجُلٌ جارَهَ وَقَتَلَهُ بِمَكرٍ، يُمكِنُكَ أنْ تَأخُذَهُ وَتَقتُلَهُ حَتَّى لَوِ احْتَمَى بِمَذبَحِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«مَنْ يَضرِبُ أباهُ أوْ أُمَّهُ، يُقتَلُ قَتلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«مَنْ يَخطِفُ إنساناً، يُقتَلُ قَتلاً. سَواءٌ أباعَهُ أمِ احتَفَظَ بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«مَنْ يَنطِقُ بِلَعنَةٍ ضِدَّ أبِيهِ أوْ أُمِّهِ، يُقتَلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«إنْ ضَرَبَ رَجُلٌ رَجُلاً آخَرَ بِحَجَرٍ أوْ بِقَبضَةِ يَدِهِ بَينَما كانا يَتَشاجَرانِ، وَلَمْ يَمُتِ الرَّجُلُ المَضرُوبُ لَكِنَّهُ صارَ طَرِيحَ الفِراشِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","فَإنْ نَهَضَ وَسارَ فِي الخارِجِ عَلَى عَصاهُ، فَإنَّ الضّارِبَ سَيَتَبَرَّأُ، لَكِنَّهُ يُعَوِّضَهُ عَنِ الوَقتِ الَّذِي يَتَعافَى الرَّجُلُ المَضرُوبُ فِيهِ، وَيَدْفَعُ تَكالِيفَ عِلاجِ الرَّجُلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«إنْ ضَرَبَ رَجُلٌ عَبدَهُ أوْ جارِيَتَهُ بِعَصاً، فَماتَ العَبدُ أوِ الجارِيَةُ بِسَبِبِ ضَرْبِهِ، فَإنَّهُ يُغَرَّمُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","لَكِنْ إنْ بَقِيَ العَبدُ أوِ الجارِيَةُ طَرِيحَ الفِراشِ يَوماً أوِ اثْنَينِ، فَلا يُغَرَّمُ المالِكُ لأنَّ العَبْدَ أوِ الجَارِيَةَ مُلْكُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«إنْ تَشاجَرَ رِجالٌ فَضَرَبُوا امْرأةً حُبلَى، فَسَقَطَ الجَنِينُ لَكِنَّها لَمْ تَتَأذَّ، يَدْفَعُ المَسؤُولُ عَنْ ذَلِكَ غَرامَةً يُحَدِّدُها زَوجُ المَرأةِ بِإشْرَافِ القاضِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","فَإنْ كانَتْ قَدْ تَأذَّتْ، يُعاقَبُ المؤذِي حَياةً بِحَياةٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","عَيناً بِعَينٍ، سِنّاً بِسِنٍّ، يَداً بِيَدٍ، رِجلاً بِرِجلٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","حَرقاً بِحَرقٍ، جُرْحاً بِجُرْحٍ، وَضَربَةً بِضَربَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«إنْ ضَرَبَ رَجُلٌ عَينَ عَبدِهِ أوْ جارِيَتِهِ فَأتلَفَها، يُطلِقُهُ حُرّاً مُقابِلَ عَينِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","وَإنْ أسقَطَ سَيِّدٌّ سِنَّ عَبدِهِ أوْ جارِيَتِهِ، يُطلِقُهُ حُرّاً مُقابِلَ سِنِّهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«إنْ نَطَحَ ثَوْرٌ امْرأةً أوْ رَجُلاً وَماتَ، يُرْجَمُ الثَّورُ وَلا يُؤكَلُ لَحمُهُ، وَأمّا مالِكُ الثَّورِ فَيَكُونُ بَرِيئاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","لَكِنْ إنْ كانَ مِنْ عادَةِ الثَّورِ أنْ يَنطَحَ، وَقَدْ حُذِّرَ مالِكُهُ لَكِنَّهُ لَمْ يَحتَجِزْهُ، وَقَتَلَ ذَلِكَ الثَّورُ رَجُلاً أوِ امْرأةً، يُرجَمُ الثَّورُ، وَيُقتَلُ صاحِبُهُ أيضاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","وَإنْ فُرِضَتْ عَلَيهِ فِديَةٌ، يَدفَعُها عَنْ حَياتِهِ بِحَسَبِ كُلِّ ما يُفرَضُ عَلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","«يُعْمَلُ بِهَذا الحُكْمِ إنْ نَطَحَ الثَّورُ ابْناً أوْ بِنتاً مِنَ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","فَإنْ نَطَحَ الثَّورُ عَبداً أوْ جارِيَةً، عَلَى مالِكِ الثَّورِ أنْ يَدْفَعَ ثَلاثِينَ مِثْقالاً مِنَ الفِضَّةِ لِمالِكِ العَبدِ، أمّا الثَّورُ فَيُرجَمُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«إنْ فَتَحَ رَجُلٌ بِئراً أوْ حَفَرَ بِئراً وَلَمْ يُغَطِّها، وَوَقَعَ فِيها ثَورٌ أوْ حِمارٌ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","يَدفَعُ مالِكُ البِئْرِ مالاً لِمالِكِ الحَيوانِ. أمّا الحَيوانُ المَيِّتُ فَيَكُونُ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«إنْ نَطَحَ ثَورُ رَجُلٍ ثَورَ رَجُلٍ آخَرَ فَماتَ، فَلْيَبِيعا الثَّورَ الحَيَّ وَيَقتَسِما ثَمَنَهُ. كَما يَقتَسِمانِ الثَّورَ المَيِّتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","لَكِنْ إنْ كانَ مَعرُوفاً أنَّ الثَّورَ مُعتادٌ عَلَى النَّطحِ لَكِنَّ مالِكَهُ لَمْ يَحتَجِزْهُ، فَإنَّهُ يُعَوِّضُ ثَوراً بِثَورٍ. أمّا الثَّورُ المَيِّتَ فَيَكُونُ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«إنْ سَرَقَ رَجُلٌ ثَوراً أوْ خَرُوفاً وَذَبَحَهُ أوْ باعَهُ، يُعَوِّضُ السّارِقُ بِخَمسَةِ ثِيرانٍ عَنِ الثَّورِ، وَبِأربَعَةِ خِرافٍ عَنِ الخَرُوفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","«إنْ أُمسِكَ لِصٌ وَهُوَ يَقتَحِمُ بَيتاً فَضُرِبَ وَماتَ، لا يَكُونُ لأحَدٍ حَقُّ الثَّأرِ لِدَمِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","لَكِنْ إنْ قُتِلَ فِي النَّهارِ، يَكُونُ هُناكَ حَقٌّ لِلثَّأرِ لِدَمِهِ. فَإنْ أُمْسِكَ حَيّاً وَلَيسَ مَعَهُ ما يُعَوِّضُ بِهِ عَمَّا سَرَقَهُ، يُباعُ كَعَبدٍ تَعْويضاً عَمَّا سَرَقَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","وَإنْ وُجِدَ ما سَرَقَهُ مَعَهُ حَيّاً، سَواءٌ أكانَ ثَوراً أمْ حِماراً أمْ خَرُوفاً، فَإنَّهُ يُعَوِّضُ بِالضِّعْفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«إنْ رَعَى رَجُلٌ قَطِيعَهُ فِي حَقلِهِ أوْ كَرْمِهِ، ثُمَّ تُرِكَتْ ماشِيَتُهُ لِتَرْعَى فِي حَقلِ رَجُلٍ آخَرَ، يَنبَغِي أنْ يُعَوِّضَ مِنْ أفضَلِ إنتاجِ حَقلِهِ أوْ كَرمِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«إنْ أشعَلَ رَجُلٌ ناراً فَتَخَطَّتْ حُدُودَ أرْضِهِ، وَأحرَقَتْ قَمحاً مُكَدَّساً أوْ زَرْعاً أوْ حَقلاً، يُعَوِّضُ مَنْ أشعَلَ النّارَ عَنْ ما احتَرَقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","«إنْ أعطَى رَجُلٌ مالاً أوْ بَضائِعَ لِجارِهِ لِيَحتَفِظَ بِها لَهُ، وَسُرِقَتْ مِنْ بَيتِ الرَّجُلِ، وَقُبِضَ عَلَى اللِّصِّ، يُعَوِّضُ اللِصُّ عَنها كُلِّها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","فَإنْ لَمْ يُقبَضْ عَلَى اللِّصِّ، يَقِفُ صاحِبُ البَيتِ أمامَ القُضاةِ لِمَعْرِفَةِ إنْ كانَ هُوَ قَدْ سَرَقَ جارَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«إنْ فُقِدَ ثَورٌ أوْ حِمارٌ أوْ خَرُوفٌ أوْ ثَوبٌ أوْ أيُّ شَيءٍ آخَرُ، وَجاءَ رَجُلانِ يَقُولُ كُلٌّ مِنْهُما إنَّ المَفْقُودَ لَهُ، تُقَدَّمُ دَعْواهُما إلَى القُضاةِ، وَالَّذِي يَحكُمُ القُضاةُ بِأنَّهُ المُذنِبُ، يُعَوِّضُ جارَهُ ضِعفَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","«إنْ أعطَى رَجُلٌ جارَهُ حِماراً أوْ ثَوراً أوْ خَرُوفاً أوْ أيَّ حَيوانٍ لِيَحتَفِظَ لَهُ بِهِ، وَماتَ الحَيَوانُ أوْ جُرِحَ أوْ سُرِقَ وَلَمْ يَجِدْهُ أحَدٌ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","يَحلِفُ الجارُ بِاللهِ إنَّهُ لَمْ يَسْرِقْ مُلكَ جارِهِ. وَيَقْبَلُ المالِكُ بِالحُكمِ. وَلا يَكُونَ عَلَى الرَّجُلِ الآخَرِ أنْ يُعَوِّضَ بِشَيءٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","لَكِنْ إنْ سُرِقَ مِنهُ بِسَبَبِ إهمالِهِ، فَإنَّهُ يُعَوِّضُ مالِكَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","وَإنِ مَزَّقَهُ حَيوانٌ بَرِّيٌّ، فَلْيُحِضِرْ بَقايا الحَيوانِ. وَلا يَكُونُ عَلَيهِ أنْ يُعَوِّضَ عَنِ الحَيَوانِ المُمَّزَقِ بِشَيءٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","«إنِ استَعارَ رَجُلٌ شَيئاً أوْ حَيواناً مِنْ جارِهِ، فَكُسِرَ ما استَعارَهُ أوْ ماتَ وَلَمْ يَكُنِ المالِكُ مَعَهُ، فَيَنبَغِي أنْ يُعَوِّضَ المالِكَ بِشَكلٍ كامِلٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","لَكِنْ إنْ كانَ مالِكُهُ مَعَهُ، لا يُعَوِّضُهُ بِشَيءٍ. وَإنْ كانَ الشَّيءُ أوِ الحَيوانُ مُستَأجَراً، فَالخَسارَةُ تُغَطَّى بِأُجرَةِ الاستِئجارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","«إنْ أغوَى رَجُلٌ فَتاةً عَذْراءَ غَيرَ مَخطُوبَةٍ لَهُ وَعاشَرَها، يَدفَعُ مَهْرَها كامِلاً وَيَتَزَوْجُها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","فَإنْ رَفَضَ أبوها أنْ يُزَوِّجَها مِنْهُ، يَدْفَعُ الرَّجُلُ، عَلَى ايَّةِ حالٍ، ما يُعادِلُ مَهْرَ عَذْراءٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«لا تَسمَحْ لِساحِرَةٍ بِأنْ تَعِيشَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«مَنْ عاشَرَ حَيواناً مُعاشَرَةً جِنْسيَّةً، يُقتَلُ قَتلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«مَنْ يُقَدِّمُ ذَبائِحَ لِآلِهَةٍ أُخْرَى غَيرِ اللهِ يَنبَغِي أنْ يُبادَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","«لا تُسِئْ مُعامَلَةَ الغَرِيبِ المُقِيمِ فِي أرْضِكَ، لِأنَّكُمْ كُنْتُمْ غُرَباءَ فِي أرْضِ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","«لا تُسِئْ إلَى أرمَلَةٍ أوْ يَتِيمٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","فَإنْ أسَأتَ إلَيها أوْ إلَيهِ، وَصَرَخَ إلَيَّ فَإنِّي سَأسمَعُ صَرْخَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","سَيَشْتَدُّ غَضَبِي وَأقتُلُكُمْ بِالسَّيفِ، وَتَصِيرُ زَوجاتُكُمْ أرامِلَ، وَأولادُكُمْ يَتامَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«إنْ أقرَضْتَ مالاً لِفَقِيرٍ مِنْ شَعبِيَ، فَلا تُعَامِلْهُ بِالرِّبا. لا تأخُذْ مِنْهُ فَائِدَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","وَإنْ كُنتَ تَحتَفِظُ بِثَوبِ جارِكَ كَرَهِينَةٍ، أعِدْهُ إلَيهِ قَبلَ غُرُوبِ الشَّمسِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","فَهُوَ غِطاؤُهُ الوَحِيدُ، وَهُوَ ثَوبُ جِلْدِهِ. بِماذا يَتَغَطَّى حِينَ يَنامُ؟ فَحِينَ يَصرُخُ إلَيَّ، سَأسمَعُهُ لِأنِّي رَحِيمٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«لا تَشْتِمِ القُضاةِ. وَلا تَنطِقْ بِلَعنَةٍ عَلَى قائِدِ شَعبِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","«لا تَحتَفِظْ بِأوَّلِ إنتاجِ حَقلِكَ مِنَ الحُبُوبِ أوْ مِنْ نَبيذِ مِعصَرَتِكَ. وَكَرِّسْ لِي بِكرَ أبْنائِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","وَكَذَلِكَ قَدِّمْ أبكارَ ثِيرانِكَ وَغَنَمِكَ. أبْقِ بِكرَ الحَيوانِ سَبعَةَ أيّامٍ مَعَ أُمِّهِ، ثُمَّ قَدِّمْهُ لِي فِي اليَومِ الثّامِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","«كُونوا مُخَصَّصينَ لِي، فَلا تَأْكُلُوا لَحمَ حَيوانٍ قَتَلَهُ حَيوانٌ آخَرُ فِي الحَقلِ، بَلْ ألقُوهُ إلَى الكِلابِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«لا تَنشُرْ إشاعَةً كاذِبَةً، وَلا تَشتَرِكْ مَعَ شِرِّيرٍ فِي شَهادَةٍ كاذِبَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","«لا تَقِفْ مَعَ الأغلَبِيَّةِ لِتَفعَلِ الشَّرَّ. فَلا تُقَدِّمْ شَهادَةَ زُورٍ لِصالِحِ الأغلَبِيَّةِ، فَتَمنَعَ العَدلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","«لا تَتَحَيَّزْ لِلفَقِيرِ فِي دَعْواهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«إذا وَجَدْتَ ثَورَ عَدُوِّكَ أوْ حِمارَهُ وَهُوَ تائِهٌ، أعِدْهُ إلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","وَإنْ رَأيْتَ حِمارَ عَدُوِّكَ وَقَدْ رَبَضَ تَحتَ حِملٍ ثَقِيلٍ، فَلا تَترُكْهُ، بَلْ ساعِدِ فِي فَكِّ حِملِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«لا تَمنَعِ العَدلَ عَنِ المِسكِينِ فِي دَعْواهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","«تَجَنَّبْ كُلَّ اتِّهامٍ كاذِبٍ. لا تَقتُلِ البَرِيءَ وَالبارَّ، لِأنِّي لَنْ أُبَرِّئَ المُذنِبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","«لا تَقبَلْ رِشْوَةً، لِأنَّ الرِّشوَةَ تُعمِي الأعيُنَ المَفتُوحَةَ، وَتُقَلِّلُ مِنْ قِيمَةِ كَلامِ الصّادِقينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«لا تَظلِمْ غَرِيباً مُقِيماً فِي أرْضِكَ. فَأنتُمْ تَعرِفُونَ ما يَشعُرُ بِهِ الغَرِيبُ، لِأنَّكُمْ كُنتُمْ غُرَباءَ فِي أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«ازرَعْ أرْضَكَ وَاجمَعْ مَحصُولَكَ لِسِتِّ سَنَواتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ثُمَّ اتْرُكِ الأرْضَ لِتَرتاحَ فِي السَّنَةِ السّابِعَةِ. سَيَأكُلُ فُقَراءُ شَعبِكَ مِنها، وَالحَيواناتُ البَرِّيَّةُ سَتَأْكُلُ ما يَترُكُهُ الفُقَراءُ. اعْمَلْ هَذا لِكَرمِكَ أوْ زَيتُونِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«اعْمَلْ سِتَّةَ أيّامٍ فِي الأُسبُوعِ، وَاسْتَرِحْ فِي اليَومِ السّابِعِ. لِتَستَرِحْ حَمِيرُكَ وَثِيرانُكَ، وَلْيَنتَعِشْ خُدّامُكَ وَالغُرَباءُ الَّذِينَ يُقِيمُونَ فِي أرْضِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«انتَبِهُوا لِكُلِّ ما قُلْتُهُ لَكُمْ، وَلا تَدْعُوا بِأسْماءَ آلِهَةٍ أُخْرَى، وَلا حَتَّى تَنْطِقْ بِها بِفَمِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«أقِمْ ثَلاثَةَ أعيادٍ كُلَّ سَنَةٍ لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","احْفَظْ عِيدَ الخُبْزِ غَيرِ المُخْتَمِرِ. حَيثُ تَأْكُلُ خُبزاً غَيرَ مُخْتَمِرٍ لِسَبعَةِ أيّامٍ فِي الوَقْتِ المُعَيَّنِ لَهُ فِي شَهرِ أبِيبَ، كَما أمَرْتُكَ، لِأنَّ فِيهِ خَرَجْتَ مِنْ مِصرَ. فَلا يَأْتِ الشَّعبُ أمامِي فارِغِي الأيدِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","«احفَظْ أيضاً عِيدَ حَصادِ أوّلِ غَلّاتِ تَعَبِكَ مِنْ حَقلِكَ. وَتَحفَظُ عِيدَ الجَمْعِ فِي نِهايَةِ السَّنَةِ، حِينَ تَجمَعُ غَلّاتِ تَعَبِكَ مِنَ الحَقلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","«يَنبَغِي أنْ يَحضُرَ جَمِيعُ الذُّكُورِ أمامَ الرَّبِّ الإلَهِ ثَلاثَ مَرّاتٍ فِي السَّنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«لا تُقَدِّمْ دَمَ ذَبيحَتِي مَعَ أيِّ شَيءٍ فيِهِ خَمِيْرَةٌ. وَلا يَبقَ شَحمُ ذَبِيحَةِ عِيدِي إلَى صَباحِ اليَومِ التَّالِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","«أحْضِرْ أفْضَلَ أوَّلِ إنتاجِ أرْضِكَ إلَى بَيتِ إلَهِكَ. «وَلاتَطبُخْ جَدْياً فِي حَلِيبِ أُمِّهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«سَأُرسِلُ رَسُولاً أمامَكَ لِيَحرُسَكَ فِي الطَّرِيقِ وَلِيُحضِرَكَ إلَى المَكانِ الَّذِي أعدَدْتُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","أصْغِ لَهُ وَأطِعْهُ، وَلا تَتَمَرَّدْ عَلَيهِ، فَهُوَ لَنْ يَغفِرَ لَكَ إساءَتَكَ لِأنَّ اسْمِيَ فِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","لَكِنْ إنْ أطَعْتَهُ، وَعَمِلْتَ كُلَّ ما أقُولُهُ لَكَ، فَإنِّي سَأكُونُ عَدُوّاً لِأعدائِكَ، وَسَأُقاوِمُ مُقاوِمِيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","«حِينَ يَسِيرُ رَسُولِي أمامَكَ وَيُحضِرُكَ إلَى أرْضِ الأمُورِيِّينَ وَالحِثِّيِّينَ وَالفِرِزِّيِّينَ وَالكَنعانِيِّينَ وَالحِوِّيِّينَ وَاليَبُوسِيِّينَ وَأُبِيدُهُمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","لا تَسجُدْ لِآلِهَتِهِمْ وَلا تَعبُدْها. لا تُقَلِّدْ أعْمَالَهُمْ، بَلْ حَطِّمْ أصنامَهُمْ وَكَسِّرْ أنْصابَهُمُ التَّذكارِيَّةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","إنْ خَدَمْتَ إلَهَكَ فَإنَّنِي سَأُبارِكُ طَعامَكَ وَماءَكَ، وَسَأُزِيلُ المَرَضَ مِنكَ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","وَلَنْ تُسْقِطَ امْرأةٌ فِي أرْضِكَ جَنِيناً أوْ تَكُونَ عاقِراً. وَسَتَعيشُ أيّامَ حَياتِكَ بِكامِلِها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«سَأُرسِلُ رُعبِي أمامَكَ، وَأُشَوِّشُ كُلَّ الشُّعُوبِ الَّتِي سَتُحارِبُها. سَأجعَلُ أعداءَكَ يَهرُبُونَ مِنْ أمامِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","سَأُرسِلُ الدَّبابِيرَ أمامَكَ فَيَطرُدُونَ الحِوِّيِّينَ وَالكَنعانِيِّينَ وَالحِثِّيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","لَنْ أطرُدَهُمْ مِنْ أمامِكَ فِي سَنَةٍ واحِدَةٍ كَي لا تُصبِحَ الأرْضُ مَهجُورَةً، فَتَكثُرَ الحَيواناتُ البَرِّيَّةُ عَلَيكَ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","بَلْ سَأطرُدُهُمْ مِنْ أمامِكَ سَنَةً بَعْدَ سَنَةٍ، إلَى أنْ يَتَكاثَرَ نَسلُكَ وَتَمتَلِكَ الأرْضَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","«سَأجعَلُ حُدُودَكَ مِنَ البَحرِ الأحْمَرِ إلَى بَحرِ الفِلِسْطِيِّينَ، وَمِنَ الصَّحْراءِ إلَى نَهْرِ الفُراتِ. لِأنِّي سَأُعطِي سُكّانَ الأرْضِ لَكَ لِتَطرُدَهُمْ مِنْ أمامِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","«لا تَقطَعْ عَهداً مَعَهُمْ أوْ مَعَ آلِهَتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","وَلا يَنبَغِي أنْ يَبْقَوْا فِي الأرْضِ، لِكَي لا يَجعَلُوكُمْ تُخطِئُونَ إلَيَّ. لِأنَّكَ إنْ عَبَدْتَ آلِهَتَهُمْ، سَتَكُونُ فَخّاً لَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","وَقالَ اللهُ لِمُوسَى: «اصعَدْ إلَى اللهِ أنتَ وَهارُونُ وَنادابُ وَأبِيهُو وَسَبعُونَ مِنْ شُيُوخِ إسْرائِيلَ، وَاعْبُدُوا مِنْ بَعِيدٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","لِيَقْتَرِبْ مُوسَى وَحدَهُ مِنَ اللهِ، وَأمّا الآخَرُونَ فَلا يَقتَرِبْ أحَدٌ مِنْهُمْ. وَبَقيَّةُ الشَّعبِ أيضاً لا تَصْعَدْ مَعَهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","فَأتَى مُوسَى وَأخبَرَ الشَّعبَ بِكُلِّ كَلامِ اللهِ وَوَصاياهُ. حِينَئِذٍ، أجابَ كُلُّ الشَّعبِ بِصَوتٍ واحِدٍ: «سَنَعمَلُ كُلَّ الأُمُورِ الَّتِي تَكَلَّمَ اللهُ بِها.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","وَكَتَبَ مُوسَى كُلَّ كَلامِ اللهِ. وَاستَيقَظَ فِي صَباحِ اليَومِ التّالِي باكِراً وَبَنَى مَذبَحاً فِي سَفْحِ الجَبَلِ مَعَ اثنَي عَشَرَ عَمُوداً تُمَثِّلُ قَبائِلَ إسْرائِيلَ الاثنَتي عَشْرَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ثُمَّ أرسَلَ شُبّانَ بَنِي إسْرائِيلَ لِيُقَدِّمُوا ذَبائِحَ صاعِدَةً وَذَبائِحَ سَلامٍ مِنَ الثِّيرانٍ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","وَأخَذَ مُوسَى نِصفَ كَمِّيَّةِ الدَّمِ وَوَضَعَهُ فِي طاساتٍ، وَرَشَّ النِّصفَ الآخَرَ مِنَ الدَّمِ عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ثُمَّ أخَذَ كِتابَ العَهدِ وَقَرَأهُ عَلَى مَسمَعِ الشَّعبِ، فَقالُوا: «سَنَعمَلُ كُلَّ الأُمُورِ الَّتِي تَكَلَّمَ اللهُ بِها، وَسَنُطِيعُهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","وَأخَذَ مُوسَى الدَّمَ الَّذِي فِي الطّاساتِ وَرَشَّهُ عَلَى الشَّعبِ، وَقالَ: «هَذا هُوَ دَمُ العَهدِ الَّذِي قَطَعَهُ اللهُ مَعَكُمْ بِناءً عَلَى كُلِّ هَذا الكَلامِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","فَصَعِدَ مُوسَى وَهارُونُ وَنادابُ وَأبِيهُو وَالسَّبعُونَ مِنْ شُيُوخِ إسْرائِيلَ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","وَرَأَوْا إلَهَ إسرائِيلَ! رَأَوْا تَحتَ قَدَمِهِ ما بَدا كَرَصِيفٍ مِنْ حِجارَةِ الياقُوتِ الأزرَقِ الصّافِي كَصَفاءِ السَّماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","فَلَمْ يَقْتُلِ اللهُ أحَدَ رُؤَساءِ بَنِي إسْرائِيلَ، بَلْ رَأَوْا اللهَ، وَأكَلُوا هُناكَ وَشَرِبُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ثُمَّ قالَ اللهُ لِمُوسَى: «اصعَدْ إلَى الجَبَلِ وَانتَظِرْ هُناكَ. فَسأُعطِيَكَ لَوحَي الحِجارَةِ، وَقَدْ نَقَشْتُ عَليهِما الشَّرِيعَةَ وَالوَصايا الَّتِي كَتَبْتُها لِتَعليمِ الشَّعبِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","فَقامَ مُوسَى وَيَشُوعُ خادِمُهُ وَصَعِدا إلَى جَبَلِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","وَقالَ مُوسَى لِلشُّيُوخِ: «انتَظِرُوا هُنا حَتَّى نَعُودَ إلَيَكُمْ. وَهَا هَارُونُ وَحُورُ مَعَكُمْ، فَلْيَذْهَبْ إلَيهِما كُلُّ مَنْ لَهُ دَعْوَى.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","فَصَعِدَ مُوسَى إلَى الجَبَلِ، وَغَطَّى السَّحابُ الجَبَلَ ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","وَحَلَّ مَجْدُ اللهِ عَلَى جَبَلِ سِيناءَ، وَغَطّاهُ السَّحابُ سِتَّةَ أيّامٍ. وَدَعا اللهُ مُوسَى فِي اليَومِ السّابِعِ مِنْ وَسَطِ السُّحُبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","وَكانَ مَنظَرُ مَجدِ اللهِ المُنِيرِ كَنارٍ مُشتَعِلَةٍ عَلَى قِمَّةِ الجَبَلِ أمامَ عُيُونِ جَمِيعِ بَنِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","وَدَخَلَ مُوسَى إلَى السَّحابِ، وَصَعِدَ إلَى الجَبَلِ. وَبَقِيَ مُوسَى عَلَى الجَبَلِ أربَعِينَ نَهاراً وَأربَعِينَ لَيلَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","وَتَكَلَّمَ اللهُ إلَى مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«قُلْ لِبَني إسْرائِيلَ أنْ يُحضِرُوا لِي تَقدِمَةً. لِيُقَدِّمُوا التَّقدِمَةَ الَّتِي يُعطِيها كُلُّ شَخصٍ كَما يُنَبِّهُهُ قَلبُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","وَهَذِهِ هِيَ الأشْياءُ الَّتِي تَأخُذُونَها مِنهُمْ: تَأخُذُونَ ذَهَباً وَفِضَّةً وَبُرونْزاً ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","وَأقمِشَةً زَرقاءَ وَبَنَفسَجِيِّةٍ وَحَمراءَ وَكِتّاناً وَشَعرَ ماعِزٍ ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","وَجُلُودَ كِباشٍ مَدبُوغَةٍ وَجُلُودَ تُيُوسٍ وَخَشَبَ سَنطٍ ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","وَزَيتاً لِلسُّرُجِ وَعُطُوراً لِزَيتِ المِسْحَةِ وَلِلبَخُورِ الطَّيِّبِ ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","وَحِجارَةَ جَزعٍ وَجَواهِرَ أُخْرَى لِتَرصِيعِ الثَّوبِ الكَهَنُوتِيِّ وَالصُّدرَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","«وَلْيَصْنَعُوا لِي مَكاناً مُقَدَّساً لِأسْكُنَ فِي وَسَطِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","وَذَلِكَ بِحَسَبِ التَّصمِيمِ الَّذِي أُظهِرُهُ لَكَ لِلمَسْكَنِ المُقَدَّسِ وَأثاثِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«فَلِيَصنَعُوا صُنْدُوقاً مِنْ خَشَبِ السَّنطِ طُولُهُ ذِراعانِ ونَصْفٌ، وَعَرضُهُ ذِراعٌ وَنِصْفٌ، وَارتِفاعُهُ ذِراعٌ وَنِصْفٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","وَتُغَشِّيهِ بِالذَّهَبِ النَقِيِّ مِنَ الدّاخِلِ وَمِنَ الخارِجِ، وَتَصنَعُ لَهُ إطاراً مِنْ حَولِهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","«اسْبُكْ لِلصُّندُوقِ أربَعَ حَلَقاتٍ مِنْ ذَهَبٍ وَضَعْها عَلَى زَواياهِ الأربَعِ: حَلَقَتينِ عَلَى كُلِّ جانِبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","وَاصْنَعْ عَصَوَينِ مِنْ خَشَبِ السَّنطِ تُغَشِيهِما بِالذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","وَتَضَعُ العَصَوَينِ فِي الحَلَقاتِ الَّتِي عَلَى جانِبَيِّ الصُّندُوقِ لِحَملِهِ بِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","وَتَبْقَى العَصَوانِ فِي حَلَقاتِ الصُّندُوقِ فَلا يُنزَعانِ مِنها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","«ضَعْ لَوحَيِّ الشَّهادَةِ اللَّذَينِ سَأُعطِيهُما لَكَ فِي الصُّندُوقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","وَاصْنَعْ لِلصُّنْدُوقِ غِطاءً مِنْ ذَهَبٍ نَقِيٍّ، طُولُهُ ذِراعانِ ونَصْفٌ، وَعَرضُهُ ذِراعٌ وَنِصْفٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","وَاصْنَعْ تِمثالينِ عَلَى شَكلِ مَلاكَي كَرُوبَيم مِنْ ذَهَبٍ مَطرُوقٍ، وَضَعْهُما عَلَى طَرَفَيِّ الغِطاءِ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","كَرُوباً واحِداً عَلَى كُلِّ طَرَفٍ مِنْ طَرَفَيِّ الغِطاءِ. وَيُصْنَعُ الكَرُوبانِ بِحَيثُ يَكُونانِ قِطعَةً واحِدَةً مَعَ الغَطاءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","يَكُونَ الكَرُوبانِ باسِطَيْنِ أجنِحَتَهُما إلَى الأعلَى يُظَلِّلانِ الغِطاءِ. يَكُون الكَرُوبانِ مُتَقابِلَيْنِ، وَوَجْهاهُما نَحوَ الغِطاءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","«ضَعِ الغِطاءَ فَوقَ الصُّندُوقِ. وَضَعْ داخِلَ الصُّندُوقِ الشَّهادَةَ الَّتِي سَأُعطِيها لَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","هُناكَ، مِنْ فَوقِ الغِطاءِ وَبَينَ الكَرُوبَينِ اللَّذَينِ فَوقَ صُندُوقِ الشَّهادَةِ، سأُعلِنُ ذاتِي لَكَ، وَسَأُخبِرُكَ بِكُلِّ ما أُوصِيكَ بِهِ لِبَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«اصْنَعْ مائِدَةً مِنْ خَشَبِ السَّنطِ، طُولُها ذِراعانِ، وَعَرضُها ذِراعٌ، وَارتِفاعُها ذِراعٌ وَنِصْفٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","غَشِّ المائِدَةَ بِالذَّهَبِ النَقِيِّ، وَاصْنَعْ لَها إطاراً مِنَ الذَّهَبِ حَولَها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","وَاصنَعْ لَها حافَّةً عَرضُها شِبرٌ حَولَها، وَإطاراً مِنْ ذَهَبٍ لِحافَّتِها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","«اصْنَعْ لِلمائِدَةِ أربَعَ حَلَقاتٍ مِنْ ذَهَبٍ، وَثَبِّتْها عَلَى الزَوايا الأربَعِ، عَلَى مُسْتَوَى أرْجُلِها الأرْبَعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","تَكُونُ الحَلَقاتُ قَرِيبَةً مِنَ الحافَّةِ العُلْيا، فُتُدْخِلُ فِيها العَصَوَينِ لِحَملِ المائِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","وَتَصْنَعُ العَصَوَينِ مِنْ خَشَبِ السَّنطِ وَتُغَشِّيهِما بِالذَّهَبِ. فَتُحمَلُ المائِدَةُ بِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","«اصْنَعْ أطباقَ المائِدَةِ وَصُحُونَها مِنَ الذَهَبِ النَّقِيِّ، وَكَذَلِكَ أبارِيقَها وَطاساتِها لِلتَّقْدِماتِ السَّائِلَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","وَضَعِ الخُبْزَ الَّذِي يُشيرُ إلَى حُضُورِي عَلَى هَذِهِ المائِدَةِ أمامِيَ دائِماً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«وَاصنَعْ مَنارَةً مِنَ الذَّهَبِ النَّقِيِّ. تُطْرَقُ قاعِدَةُ المَنارَةِ وَساقُها بالمِطْرَقَةِ. وَتَكُونُ كُؤُوسُها وَعُقَدُها وَوَرَقُها قِطعَةً واحِدَةً مَعَها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","وَتَتَفَرَّعُ المَنارَةُ إلَى سِتِّ شُعَبٍ عَلَى جانِبَيها: ثَلاثِ شُعَبٍ عَنْ كُلِّ جانِبٍ مِنْ جانِبَي المَنارَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","وَاسْبُكْ ثَلاثَ زَهْراتِ لَوْزٍ مَعَ عُقَدِها وَوَرَقِها عَلَى كُلِّ شُعْبَةٍ مِنَ الشُّعَبِ السِّتِّ المُتَفَرِّعَةِ مِنْ ساقِ المَنارَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","وَكَذَلِكَ أربَعَ زَهْراتِ لَوْزٍ مَعَ عُقَدِها وَوَرَقِها عَلَى ساقِ المَنارَةِ نَفْسِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","مِنْها ثَلاثُ زَهْراتٍ مَعَ عُقَدِها تَقَعُ كُلُّ واحِدَةٍ مِنْها عِنْدَ التِقاءِ كُلِّ شُعْبَتَينِ مِنَ الشُّعَبِ السِّتِّ المُتَفَرِّعَةِ مِنَ السّاقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","وَتَكُونُ عُقَدُ المَنارَةِ وَشُعَبُها قِطعَةً واحِدَةً مَعَها. وَجَمِيعُها مِنَ قِطْعَةٍ واحِدَةٍ مِنَ الذَّهَبِ النَّقِيِّ المَطرُوقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","«وَاصْنَعْ سَبعَةَ سُرَجٍ لِلمَنارَةِ. وَضَعِ السَّرُجَ عَلَيها بِحَيثُ تُضِيءُ حَولَها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","تَكُونَ مَلاقِطُ السُّرُجِ وَمَنافِضُها مِنَ الذَّهَبِ النَّقِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","«فَالمَنارَةُ مَعَ كُلِّ أدَواتِها تُصْنَعُ مِنْ قِنطارٍ واحِدٍ مِنَ الذَّهَبِ النَّقِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","فاحرِصْ عَلَى أنْ تَصنَعَها حَسَبَ النُّمُوذَجِ الَّذِي أرَيتُكَ إيّاهُ عَلَى الجَبَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«اصْنَعِ المَسْكَنَ المُقَدَّسَ مِنْ عَشْرِ سَتائِرَ مِنْ كِتّانٍ ناعِمٍ مَبْرُومٍ، وَأقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ مُطَرَّزةٍ بِمَهارَةٍ عَلَى شَكلِ مَلائِكَةِ الكَرُوبِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","يَكُونُ طُولُ كُلِّ سِتارَةٍ ثَمانٍ وَعُشْرُينَ ذِراعاً، وَعَرْضُها أربَعَ أذرُعٍ. فَلِجَمِيعِ السَتائِرِ مَقايِيسُ مُتَساوِيَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","وَتُوصَلُ السَّتائِرُ الخَمْسُ الأولَى مَعاً، وَالخَمْسُ الثّانِيَةُ مَعاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ثُمَّ تَصْنَعُ عُرَىً مِنْ قُماشٍ أزرَقَ عَلَى حافَّةِ سِتارَةِ المَجْمُوعَةِ الأولَى، وَكَذَلِكَ عَلَى حافَّةِ سِتارَةِ المَجْمُوعَةِ الثَّانِيَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","اصْنَعْ خَمسِينَ عُروَةً عَلَى سِتارَةِ المَجْمُوعَةِ الأولَى، وَخَمْسِينَ عُروَةً عَلَى حافَّةِ سِتارَةِ المَجمُوعَةِ الثّانِيَةِ. وَتَكُونُ العُرَى مُتَقابِلَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","«وَاصْنَعْ خَمسِينَ مِشبَكاً مِنَ الذَّهَبِ لِتُوصِلَ السَّتائِرَ مَعاً بِالمَشابِكِ. وَهَكَذا يَصِيرُ المَسْكَنُ المُقَدَّسُ كَقِطْعَةٍ واحِدَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«وَاصْنَعْ إحْدَى عَشْرَةَ سِتارَةً مِنْ شَعْرِ الماعِزِ لِلغِطاءِ الَّذِي فَوقَ المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","طُولُ كُلِّ سِتارَةٍ ثَلاثُونَ ذِراعاً، وَعَرْضُها أرْبَعُ أذْرُعَ. فَتَكُونُ لِلسَّتائِرِ الإحدَى عَشْرَةَ مَقايِيسُ مُتَساوِيَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","«صِلْ خَمسَ سَتائِرَ مَعاً، وَسِتَّ سَتائِرَ مَعاً. ثُمَّ اثْنِ السِّتارَةَ السّادِسَةَ لِتَكُونَ كَحِجابٍ أمامَ الخَيمَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","وَاصْنَعْ خَمسِينَ عُروَةً عَلَى حافَّةِ أقصَى سِتارَةٍ عَلَى طَرَفِ المَجمُوعَةِ الأُولَى، وَخَمْسِينَ عُروَةً عَلَى حافَّةِ أقصَى سِتارَةٍ عَلَى طَرَفِ المَجمُوعَةِ الثّانِيَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","وَاصنَعْ خَمسِينَ مِشبَكاً مِنْ بُرونْزٍ تَضَعُها فِي العُرَى، لِتَصِلَ أجْزاءَ المَسْكَنُ مَعاً، فَيَصيرَ قِطْعَةً واحِدَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","«وَأمّا الجُزءُ الباقِي مِنْ سَتائِرِ الغِطاءِ، فَتُدَلِّيَ نِصفَ السِّتارَةِ الباقِيَةِ عَلَى خَلفِ المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","وَأمّا الذِّراعُ الزّائِدَةُ مِنَ السَّتائِرِ عَلَى جَوانِبِ الغِطاءِ، فَتَتَدَلَّى عَلَى كُلِّ جِهَةٍ مِنْ جِهاتِ المَسْكَنِ لِتَغطِيَتِها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","«وَاصْنَعْ غِطاءً لِلمَسْكَنِ مِنْ جِلدِ الكِباشِ المَدبُوغِ، وَغِطاءً آخَرَ خارِجيّاً مِنَ الجِلدِ الفاخِرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«وَاصْنَعْ ألواحاً قائِمَةً مِنْ خَشَبِ السَّنطِ لِلمَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","طُولُ كُلِّ لَوحٍ عَشْرُ أذْرُعٍ، وَعَرضُهُ ذِراعٌ وَنِصْفٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","وَاجْعَلْ فِي كُلِّ لَوحٍ فَتحَتَينِ لِوَصلِهِا بالألْواحِ الأُخْرَى. هَكَذا تَصْنَعُ لِجَمِيعِ ألواحِ المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","«وَاصْنَعْ عِشرِينَ لَوحاً لِلجِهَةِ الجَنُوبِيَّةِ مِنَ المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","وَاصْنَعْ أربَعِينَ قاعِدَةً مِنْ فِضَّةٍ تَحْتَ الألْواحِ العِشرِينَ، قاعِدَتَينِ لِفُتْحَتَيِّ كُلِّ لَوْحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","وَاصْنَعْ عِشرِينَ لَوحاً لِلجِهَةِ الشَّمالِيَّةِ مِنَ المَسْكَنِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","وَتَحْتَها أربَعِينَ قاعِدَةً مِنْ فِضَّةٍ: قاعِدَتَينِ تَحتَ كُلِّ لَوحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","وَاصْنَعْ لِظَهْرِ المَسْكَنِ مِنَ الغَربِ سِتَّةَ ألواحٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","وَلَوحَينِ لِزاوِيَتَيِ المَسْكَنِ مِنَ الخَلْفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","يَكُونُ اللَوحانِ مُنفَصِلَينِ مِنَ الأسفَلِ، مُتَّصِلَينِ فِي الأعلَى داخِلَ الحَلَقَةِ الأُولَى. هَكَذا يَكُونُ اللَوحانِ عَلى الزّاوِيَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","فَيَكُونُ المَجْمُوعُ ثَمانِيَةَ ألواحٍ، لَها سِتَّ عَشْرَةَ قاعِدَةً: قاعِدَتَينِ تَحْتَ كُلِّ لَوحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«وَاصنَعْ عَوارِضَ مِنْ خَشَبِ السَّنطِ، خَمسَ عَوارِضَ لِجانِبِ المَسْكَنِ الأوَّلِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","وَخَمسَ عَوارِضَ لِلجانِبِ الثَّانِي، وَخَمْسَ عَوارِضَ لِظَهْرِ المَسْكَنِ مِنَ الغَربِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","وَتَصِلُ العارِضَةُ الوُسطَى لِتَمْتَدَّ بَينَ الألواحِ مِنَ الطَّرَفِ الأوَّلِ إلَى الطَّرَفِ الآخَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","«غَشِّ جَمِيعَ الألواحِ بِالذَّهَبِ، وَاصْنَعْ لَها حَلَقاتٍ مِنْ ذَهَبٍ كَبُيُوتٍ لِلعَوارِضِ. وَكَذَلِكَ غَشِّ العَوارِضَ بِالذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","وَهَكَذَ تَبْنِي المَسْكَنَ بِحَسَبِ المُخَطَّطِ الَّذِي أُظهِرَ لَكَ عَلَى الجَبَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«وَاصْنَعْ سِتارةً مِنْ أقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ مَبْرُومٍ مُطَرَّزةٍ بِمَهارَةٍ عَلَى شَكلِ مَلائِكَةِ الكَرُوبِيمَ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","وَعَلِّقْها عَلَى أربَعَةِ أعمِدَةٍ مَصنُوعَةٍ مِنْ خَشَبِ السَّنطِ وَمُغَشّاةٍ بِالذَّهَبِ وَلَها مَشابِكُ مِنْ ذَهَبٍ، تَقِفُ عَلَى أربَعِ قَواعِدَ مِنْ فِضَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","عَلِّقِ السِّتارَةَ بِالمَشابِكِ، وَأدْخِلْ صُندُوقَ الشَّهادَةِ خَلفَ السِّتارَةِ. وَلْتَفْصِلِ السِّتارَةُ بَينَ المَكَانِ المُقَدَّسِ وَقُدْسِ الأقداسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","«ضَعِ الغِطاءَ عَلَى صُندُوقِ الشَّهادَةِ فِي قُدسِ الأقداسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","وَضَعِ المائِدَةَ خارِجَ السِّتارَةِ، وَضَعِ المَنارَةَ مُقابِلَ المائِدَةِ فِي الجِهَةِ الجَنُوبِيَّةِ مِنَ المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","وَاصْنَعْ سِتارَةً مُزَخرَفَةً مِنْ أقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ مَبْرُومٍ لِأجلِ مَدْخَلِ الخَيمَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","وَاصْنَعْ لِهَذِهِ السِّتارَةِ خَمسَةَ أعمِدَةٍ مِنْ خَشَبِ السَّنطِ وَتُغَشِّيها بِالذَّهَبِ. وَاصْنَعْ مَشابِكَ مِنْ ذَهَبٍ. وَاسْبِكْ خَمْسَ قَواعِدَ مِنْ بُرونْزٍ لِلأعمِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«وَاصْنَعْ مَذبَحَ الأضاحِي مِنْ خَشَبِ السَّنطِ، قَاعِدَتُهُ مُرَبَّعَةٌ طُولُهُا خَمْسُ أذْرُعٍ، وَعَرضُهُا خَمْسُ أذْرُعٍ. أمّا ارْتِفاعُ المَذْبَحِ فَثَلاثُ أذْرُعٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","وَاصْنَعْ لَهُ أربَعَ زَوايا بارِزَةٍ عَلَى جَوانِبِهِ الأربَعَةِ، بِحَيثُ تَكُونُ قِطْعَةً واحِدَةً مَعَهُ، وَغَشِّها بِالبُرونْزِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","وَاصنَعِ القُدُورَ لِحَملِ الرَّمادِ وَالمَجارِفَ وَالطّاساتِ وَالمَناشِلَ وَالمَجامِرَ وَجَمِيعَ أدَواتِ المَذْبَحِ مِنْ بُرونْزٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","«وَاصْنَعْ شَبَكَةً مِنْ بُرونْزٍ لِلمَذْبَحِ، وَعَلَى زَواياها الأربَعِ أربَعُ حَلَقاتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","تَضَعُ الشَّبَكَةَ تَحتَ حافَّةِ المَذبَحِ عَلَى ارتِفاعِ نِصفِ المَذبَحِ مِنَ الدّاخِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","«وَاصْنَعْ لِلمَذبَحِ عَصَوَينِ مِنْ خَشَبِ السَّنطِ تُغَشِّيهِما بِالبُرونْزِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","تُدْخِلُ العَصَوَينِ فِي الحَلَقاتِ، فيَكُونا عَلَى جانِبَيِّ المَذبَحِ حِينَ يُحمَلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","«اصْنَعِ المَذْبَحَ مُجَوَّفاً وَلَهُ ألواحٌ عَلَى جَوانِبِهِ. وَهَكَذا يُصْنَعُ بِحَسَبِ النُّمُوذَجِ الَّذِي أُظهِرَ لَكَ عَلَى الجَبَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«وَسَيِّجْ ساحَةَ المَسْكَنِ المُقَدَّسِ. فَمِنَ الجَنُوبِ، تَضَعُ سَتائِرَ مِنَ كِتّانٍ مَبْرُومٍ طُولُها مِئَةُ ذِراعٍ لِذَلِكَ الجَانِبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","تُحْمَلُ السَّتائِرُ بِعِشرينَ عَمُوداً، تَحْتَها عِشرُونَ قاعِدَةً مِنَ البُرونْزِ. أمّا مَشابِكُ الأعمِدَةِ وَحَلَقاتُها فَتُصْنَعُ مِنَ الفِضَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","«وَسَيِّجِ الجانِبُ الشَّمالِيُّ بِالمَقايِيسِ وَالمُواصَفاتِ نَفْسِها. فَتَكُونُ السَّتائِرُ بِطُولِ مِئَةِ ذِراعٍ مَعَ أعمِدَتِها العِشرِينَ وَقَواعِدِها البُرونْزِيَّةِ العِشرِينَ وَمَشابِكِ الأعمِدَةِ وَحَلَقاتِها المَصنُوعَةِ مِنَ الفِضَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","«أمّا لِعَرضِ السّاحَةِ مِنَ الغَرْبِ، فَتَكُونُ السَّتائِرُ بِطُولِ خَمْسينَ ذِراعاً تَحْمِلُها عَشْرَةُ أعمِدَةٍ، تَحْتَها عَشَرُ قَواعِدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","فَيَكُونُ عَرضُ السّاحَةِ مِنَ الأمامِ خَمْسينَ ذِراعاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","كَما تُعَلَّقُ خَمسَ عَشْرَةَ ذِراعاً مِنَ السَّتائِرِ عَلَى أحَدِ جَانِبَي المَدْخَلِ. وَلَها ثَلاثَةُ أعمِدَةٍ وَثَلاثُ قَواعِدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","وَتُعَلَّقُ خَمسَ عَشْرَةَ ذِراعاً مِنَ السَّتائِرِ عَلَى الجانِبِ الثّانِي. وَلَها ثَلاثَةُ أعمِدَةٍ وَثَلاثُ قَواعِدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","«وَتُوضَعُ سِتارَةٌ لِمَدْخَلِ السّاحَةِ بِطُولِ عِشْرينَ ذِراعاً، مَصنُوعَةٌ مِنْ أقمِشَةٍ مُزَخرَفَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ مَبْرُومٍ، تَحمِلُها أربَعَةُ أعمِدَةٍ، تَحْتَها أربَعُ قَواعِدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","وَتَكُونُ كُلُّ أعمِدَةِ السّاحَةِ مُتَّصِلَةً مَعاً بِقُضبانٍ مِنْ فِضَّةٍ، وَلَها مَشابِكُ مِنْ فِضَّةٍ، وَقَواعِدُ مِنْ بُرونْزٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","وَهَكَذا يَكُونَ طُولُ السّاحَةِ مِئَةَ ذِراعٍ، وَعَرضُها خَمسينَ ذِراعاً. وَتَكُونُ لَها سَتائِرُ مِنْ كِتّانٍ مَبْرُومٍ ارْتِفاعُها خَمْسُ أذْرُعٍ، وَقَواعِدُها مِنْ بُرونْزٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","وَجَمِيعُ أدَواتِ المَسْكَنِ المُستَخدَمَةِ لِلخِدمَةِ، وَجَمِيعُ أوتادِ السّاحَةِ، تُصْنَعُ مِنَ البُرونْزِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«وَكَذَلِكَ تأمُرُ بَني إسْرائِيلَ بِأنْ يُحضِرُوا لَكَ زَيتَ زَيتُونٍ نَقِيّاً لِلإنارةِ، لِكَي تَبْقَى المَنارَةُ مُشْتَعِلَةً بِشَكلٍ دَائِمٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","عَلَى هارُونَ وَأبْنائِهِ أنْ يُبقُوا المَنارَةَ مُشتَعِلَةً مِنَ المَساءِ وَحَتَّى الصَّباحِ فِي حَضْرَةِ اللهِ فِي خَيمَةِ الاجْتِماعِ خارِجَ السِّتارَةِ الدّاخِلِيَّةِ الَّتِي أمامَ صُندُوقِ الشَّهادَةِ. احْفَظُوا هَذِهِ الفَرِيضَةَ جِيلاً بَعْدَ جِيلٍ كَعادَةٍ دائِمَةٍ فِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«قَدِّمْ هارُونَ أخاكَ وَأبناءَهُ إلَيَّ مِنْ بَنِي إسْرائِيلَ لِيَكُونُوا كَهَنَةً لِي. أي هارُونَ وَأبناءَهُ نادابَ وَأبِيهُو وَألِيعازارَ وَإيثامارَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","اصْنَعْ ثِياباً مُقَدَّسَةً لِهارُونَ أخِيكَ لإظْهارِ المَجدِ وَالجَمالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","اطلُبْ مِنَ الخَيّاطينَ المَهَرَةِ المُحتَرِفِينَ الَّذِينَ وَضَعتُ فِيهِمْ قُدرَةً، وَلِيَصنَعُوا ثِيابَ هارُونَ فَأُخَصِّصَهُ كاهِناً لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","«هَذِهِ هِيَ الثِّيابُ الَّتِي يَصنَعُونَها: صُدْرَةٌ وَثَوبٌ كَهَنوتِيٌّ وَجُبَّةٌ وَرِداءٌ مَنسُوجٌ وَعِمامَةٌ وَحِزامٌ. يَصنَعُونَ ثِياباً مُقَدَّسَةً لِأخِيكَ هارُونَ لِيَكُونَ كاهِناً لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","وَيَستَخدِمُونَ فِي صِناعَتِها الذَّهَبَ وَالكِتَّانَ وَأقمِشَةً زَرقاءَ وَبَنَفسَجِيَّةً وَحَمراءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«اصْنَعِ الثَّوبُ الكَهَنُوتِيُّ مِنْ ذَهَبٍ وَنَسِيجِ خُيُوطٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ مَبْرُومٍ، يَصنَعُهُ خَيّاطٌ ماهِرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","وَتَكُونُ لَهُ قِطعَتانِ لِلكَتِفَينِ مُتَّصِلَتانِ بِهِ عِندَ الكَتِفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","«وَاصْنَعِ الحِزامُ الَّذِي عَلَى الثَّوبِ الكَهَنُوتِيِّ بِمَهارَةٍ: قِطْعَةً واحِدَةً مِنْ ذَهَبٍ وَنَسِيجِ خُيُوطٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ مَبْرُومٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","«وَخُذْ حَجَرَي جَزْعٍ، وَانْقُشْ عَلَيهِما أسْماءَ أبناءِ إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","انْقُشْ سِتَّةَ أسْماءٍ عَلَى الحَجَرِ الأوَّلِ وَسِتَّةَ أسْماءٍ عَلَى الحَجَرِ الثّانِي، بِحَسَبِ تَرتِيبِ وِلادَتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","تَنْقُشُ أسْماءَ أبناءِ إسْرائِيلَ عَلَى الحَجَرَينِ بِالطَّرِيقَةِ الَّتِي يَصنَعُ بِها الصّائِغُ خَتماً. ثُمَّ تَضَعُ الحَجَرَينِ فِي إطارٍ مِنْ ذَهَبٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","وَتَضَعُهُما عَلَى كَتِفَيِّ الثَّوبِ الكَهَنُوتِيِّ كَحِجارَةِ تَذكارٍ لِبَنِي إسْرائِيلَ. عَلَى هارُونَ أنْ يَرتَدِيَ أسْماءَهُمْ فِي حَضرَةِ اللهِ عَلَى كَتِفِهِ كَتَذكارٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","وَاصْنَعْ إطارَينِ مِنْ ذَهَبٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","وَسِلسِلَتَينِ مِنْ ذَهَبٍ نَقِيٍّ مَجدُولَتَينِ كَالحَبلِ. وَصِلِ السِّلسِلَتَينِ بِالإطارَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«أمّا صُدرَةُ القَضاءِ فَيَصنَعُها خَيَّاطٌ ماهِرٌ كَما صُنِعَ الثَّوبُ الكَهَنُوتِيُّ. تُصْنَعُ مِنَ الذَّهَبِ وَأقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ مَبْرُومٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","وَتَكُونُ مُرَبَّعَةً وَمَثنِيَّةً، طُولُها شِبرٌ وَعَرضُها شِبرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","وَتُرْصَفُ بِأربَعَةِ صُفُوفٍ مِنَ الحِجارَةِ الكَرِيمَةِ: فِي الصَّفِّ الأوَّلِ عَقِيقٌ أحمَرُ وَياقُوتٌ أصفَرُ وَزُمُرُّدٌ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","وَفِي الصَّفِّ الثّانِي فَيرُوزٌ وَياقُوتٌ أزرَقُ وَعَقِيقٌ أبْيَضُ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","وَفِي الصَّفِّ الثّالِثِ عَينُ الهِرِّ وَيَشْمُ وَجَمشَتُ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","وَفِي الصَّفِّ الرّابِعِ زَبَرْجَدٌ وَجَزْعٌ وَيَشْبٌ. تُوضَعُ جَمِيعاً فِي أُطُرٍ مِنْ ذَهَبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","يَكُونُ هُناكَ اثْنا عَشَرَ حَجَراً تُمَثِّلُ أسْماءَ أبناءِ إسْرائِيلَ. وَيُحْفَرُ عَلَى كُلِّ حَجَرٍ اسْمُ إحْدَى القَبائِلِ الاثنَتَي عَشْرَةَ، كَما يُحفَرُ الاسْمُ عَلَى الخاتَمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«وَاصْنَعْ لِلصُّدرَةِ سَلاسِلَ مِنْ ذَهَبٍ نَقِيٍّ مَجْدُولٍ كَالحَبلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","وَاصْنَعْ حَلَقَتَينِ مِنْ ذَهَبٍ لِأجلِ الصُّدرَةِ تَضَعَهُما عَلَى طَرَفَيها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","وَتَضَعُ طَرَفي سِلْسِلَتَي الذَّهَبِ في الحَلَقَتَينِ عَلَى طَرَفيِّ الصُدْرَةِ مِنَ الخَارِجِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ثُمَّ صِلِ الطَّرَفَينِ الآخَرَينِ لِلسِّلسِلَتَينِ بِالإطارَينِ. فَيَثْبُتا عَلَى كَتِفَيِّ الثَّوبِ الكَهَنُوتِيِّ مِنَ الأمامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","وَاصْنَعْ حَلَقَتَينِ أُخرَيينِ مِنَ الذَّهَبِ، وَضَعْهُما عَلَى طَرَفَي الصُّدرَةِ الآخَرَينِ، أي عَلَى الجانِبِ الدّاخِلِيِّ المُلاصِقِ لِلثَّوبِ الكَهَنُوتِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","وَاصْنَعْ حَلَقَتَينِ أُخْرَيينِ مِنَ الذَّهَبِ، وَضَعهُما أسْفَلَ الكَتِفَينِ فِي مُقَدِّمَةِ الثَّوبِ الكَهَنوتِيِّ، فَوقَ الحِزامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","وَتُربَطُ حَلَقاتُ الصُّدرَةِ بِحَلَقاتِ الثَّوبِ الكَهَنُوتِيِّ بِخَيطٍ أزرَقَ. وَهَكَذا تَبقى صُدْرَةُ القَضاءِ قَرِيبَةً مِنْ حِزامِ الثَّوبِ الكَهَنُوتِيِّ، مُلتَصِقَةً بِالثَّوبِ الكَهَنُوتِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«وَيَرتَدِي هارُونُ أسْماءَ بَنِي إسْرائِيلَ عَلَى صُدْرَةِ القَضاءِ قَرِيبَةً مِنْ قَلبِهِ حِينَ يَدخُلُ إلَى القُدْسِ، كَتَذكارٍ دائِمٍ وَمُستَمِرٍّ فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","وَيُوضَعُ الأُورِيمُ وَالتُّمِّيمُ فِي عَلَى صُدرَةِ القَضاءِ قَرِيبَةً مِنْ قَلبِ هارُونَ حِينَ يَقِفُ فِي حَضرَةِ اللهِ. فَيَرتَدِي هارُونَ صُدْرَةَ قَضاءِ بَنِي إسْرائِيلَ بِقُربِ قَلبِهِ فِي حَضرَةِ اللهِ بِشَكلٍ دائِمٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«وَاصْنَعْ جُبَّةَ الثَّوبِ الكَهَنُوتِيِّ كُلَّها مِنْ قُماشٍ أزرَقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","وَتَكُونُ لَها فُتْحَةٌ لِلرَّأسِ فِي وَسَطِها كَفُتْحَةِ الدِّرعِ. وَلِلفُتْحَةِ حافَّةٌ مَحبُوكَةٌ حَولَها كَي لا تَتَمَزَّقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","وَاصْنَعْ رُمّاناتٍ مِنْ أقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ حَولَ الأطرافِ السُّفلَى لِلجُبَّةِ، وَأجراساً مِنْ ذَهَبٍ عَلَى أطرافِ الثَّوبِ وَسَطَ الرُّمّاناتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","فَيَكونُ جَرَسٌ ذَهَبيٌّ واحِدٌ بَينَ كُلِّ رُمّانَتَينِ حَولَ أسْفَلِ الجُبَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","فَيَرتَدي هارُونُ الجُبَّةَ أثْناءَ خِدمَتِهِ، فَيُسمَعُ صَوتُ الأجراسِ حِينَ يَدخُلُ قُدْسَ الأقداسِ فِي حَضْرَةِ اللهِ وَحِينَ يَخرُجُ، فَلا يَمُوتُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«وَاصْنَعْ صَفِيحَةً مِنَ الذَّهَبِ النَّقِيِّ، وَانْقُشْ عَلَيها العِبارَةَ: ‹مُخَصَّصٌ لِيهوه› كَنَقْشِ الخَتمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","وَثَبِّتها بِخَيطٍ أزرَقَ فِي مُقَدِّمَةِ العِمامَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","فَتَكُونُ عَلَى جَبِينِ هارُونَ. وَيُخَصِّصُ بَنُو إسْرائِيلَ تقدِماتِهِمْ لِتَكُونَ مُقَدَّسَةً للهِ، فَيَحْمِلُ هارُونُ شَوائِبَ الذُّنُوبِ العالِقَةَ بِجَمِيعِ هَذِهِ التَّقدِماتِ. يَضَعُها عَلَى جَبيْنِهِ دائِماً فَيَحظَوْنَ بِرِضَى اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«وَانْسِجِ الرِّداءَ مِنْ كِتّانٍ، وَاصْنَعِ العِمامَةَ مِنْ كِتّانٍ. وَيَكُونُ الحِزامُ مُزَخرَفاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","وَاصْنَعْ لِأبناءِ هارُونَ أردِيَةً وَأحزِمَةً. وَاصْنَعْ لَهُمْ عَمائِمَ لِلمَجدِ وَالجَمالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","فَتُلْبِسُ هارُونَ أخاكَ وَأبناءَهُ مَعَهُ، وَتَمسَحُهُمْ وَتُعَيِّنُهُمْ وَتُفرِزُهُمْ لِيَخدِمُونِي كَكَهَنَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","«وَاصنَعْ لَهُمْ سَراوِيلَ كِتّانِيَّةً داخِلِيَّةً لِتَغطِيَةِ أعضائِهِمْ، تَكُونُ مِنَ الخَصْرِ حَتَّى الفَخذَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","فَيَلبِسُها هارُونُ وَأبناؤهُ حِينَ يَأْتُونَ إلَى خَيمَةِ الاجْتِماعِ، وَحِينَ يَقتَرِبُونَ مِنَ المَذبَحِ لِيَخدِمُوا فِي قُدسِ الأقداسِ. وَبِهَذا لا يَرتَكِبُونَ إثماً فَيَمُوتُوا. فَليَحْفَظْ هارُونُ وَنَسلُهُ مِنْ بَعدِهِ هَذا الأمرَ كَعادَةٍ دائِمَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«هَذا ما تَعمَلُهُ لِتَقدِيسِهِمْ لِيَصِيرُوا كَهَنَةً لِي. خُذْ ثَوراً وَكَبْشَينِ سَلِيمَينِ تَماماً، ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","وَخُبزاً غَيْرَ مُخْتَمِرٍ وَكَعكاً غَيْرَ مُخْتَمِرٍ مَمزُوجاً بِزَيتٍ وَرَقائِقَ غَيْرَ مَخْتَمِرَةٍ مَمسُوحَةٍ بِزَيتٍ. اصْنَعْ كُلَّ هَذِهِ مِنْ طَحِينِ قَمْحٍ ناعِمٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","وَضَعْها فِي سَلَّةٍ وَأحْضِرْها فِي السَّلَّةِ مَعَ الثَّورِ وَالكَبْشَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","«ثُمَّ اسْتَدْعِ هارُونَ وَأبناءَهُ إلَى بابِ خَيمَةِ الاجْتِماعِ وَاغْسِلَهُمْ بِماءٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","وَخُذِ الثِّيابَ، وَألْبِسْ هارُونَ الرِّداءَ وَجُبَّةَ الثَّوبِ الكَهَنُوتِيِّ وَالصُّدرَةَ. ثُمَّ ارْبُطِ الثَّوبَ الكَهَنُوتِيِّ بِالحِزامِ المُزَخرَفِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","وَضَعِ العِمامَةَ عَلَى رَأسِهِ، وَالصَّفِيحَةَ المُقَدَّسَةَ عَلَى العِمامَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","«ثُمَّ خُذْ مِنْ زَيتِ المَسحَةِ وَاسكُبْ عَلَى رَأسِهِ لِتَمْسَحَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ثُمَّ أحْضِرْ أبْناءَهُ وَألبِسْهُمْ أردِيَتَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","وَاربُطْ أحزِمَةَ هارُونَ وَأبنائِهِ، وَضَعِ العَمائِمَ عَلَى رُؤُوسِهِمْ، فَيَصِيرُونَ كَهَنَةً. هَكَذا تُعَيِّنُ هارُونَ وَأبناءَهُ كَهَنَةً كَعادَةٍ دائِمَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«ثُمَّ أحْضِرْ ثَوراً إلَى أمامِ خَيمَةِ الاجْتِماعِ، وَاطلُبْ مِنْ هارُونَ وَأبْنائِهِ أنْ يَضَعُوا أيدِيَهُمْ عَلَى رَأسِ الثَّورِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ثُمَّ اذبَحِ الثَّورَ فِي حَضرَةِ اللهِ عِندَ بابِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","«ثُمَّ خُذْ مِنْ دَمِ الثَّورِ وَضَعْهُ عَلَى زَوايا المَذبَحِ البارِزَةِ بِإصْبَعِكَ، وَاسْكُبْ ما بَقِيَ مِنَ الدَّمِ عِندَ قاعِدَةِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ثُمَّ خُذِ الشَّحْمَ الَّذِي يُغَطِّي الأحْشاءَ الدّاخِلِيَّةَ وَمُلْحَقَاتِ الكَبِدِ وَالكُلْيَتَينِ وَالشَّحْمَ الَّذِي عَلَيهِما، وَأحْرِقْهَا كُلَّها عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","أمّا جَسَدُ الثَّورِ وَجِلدُهُ وَرَوثُهُ فَتُحْرَقُ بِالنّارِ خارِجَ المُخَيَّمِ، فَهُوَ ذَبِيحَةُ خَطِيَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«ثُمَّ خُذْ أحَدَ الكَبْشَينِ، وَلْيَضَعْ هارُونُ وَأبناؤُهُ أيدِيَهُمْ عَلَى رَأسِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ثُمَّ اذْبَحِ الكَبْشَ وَخُذْ مِنْ دَمِهِ وَرُشَّهُ عَلَى مُحِيطِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","قَطِّعِ الكَبْشَ وَاغْسِلْ أحْشاءَهُ وَساقَيهِ وَضَعْها مَعَ قِطَعِهِ وَرَأسِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ثُمَّ أحْرِقِ الكَبْشَ بِكامِلِهِ عَلَى المَذبَحِ. إنَّهُ ذَبيحَةٌ صاعِدَةٌ للهِ، وَرائِحَةٌ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«ثُمَّ خُذِ الكَبْشَ الثّانِي، وَلْيَضَعْ هارُونُ وَأبناؤهُ أيدِيَهُمْ عَلَى رَأسِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ثُمَّ اذْبَحِ الكَبْشَ وَخُذْ مِنْ دَمِهِ، وَضَعِ الدَّمَ عَلَى شَحمَةِ أُذُنِ هارُونَ اليُمنَى وَشَحْماتِ أُذُنِ أبْنائِهِ اليُمنَى، وَعَلَى أباهِمِ أيديهِمِ اليُمنَى وَأباهِمِ أرجُلِهِمِ اليُمنَى. ثُمَّ تَرُشُّ الدَّمَ عَلَى مُحِيطِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","خُذْ مِنَ الدَّمِ الَّذِي عَلَى المَذبَحِ، وَمِنْ زَيتِ المَسحَةِ وَرُشْ عَلَى هارُونَ وَثِيابِهِ وَأبْنائِهِ وَثِيابِهِمْ. وَهَكَذا يُقَدَّسُ هارُونُ وَثِيابُهُ وَأبناؤُهُ وَثِيابُهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«ثُمَّ خُذْ مِنَ الكَبْشِ وَالإلْيَةِ وَالشَّحمِ الَّذِي يُغَطِّي الأحشاءَ الدّاخِلِيَّةَ وَمُلْحَقَاتِ الكَبِدِ وَالكُلْيَتَينِ وَالشَّحمَ الَّذِي عَلَيهِما وَالسّاقَ اليُمنَى، لِأنَّهُ كَبْشُ تَكْرِيسٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","خُذْ أيضاً رَغِيفَ خُبزٍ وَكَعكَةً مَعجُونَةً بِالزَّيتِ، وَرُقاقَةً مِنْ سَلَّةِ الخُبزِ غَيرِ المُخْتَمِرِ الَّتِي فِي حَضرَةِ اللهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","وَضَعْ كُلَّ هَذِهِ فِي يَدَي هارُونَ وَأيدِي أبْنائِهِ، فَيَرْفَعُونَها تَقْدِمَةً فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ثُمَّ خُذْها مِنْ أيدِيهِمْ وَأحْرِقْها عَلَى المَذبَحِ مَعَ ذَبيحَةِ الكَبْشِ الصّاعِدَةِ، فَتَكُونَ تَقدِمَةً طَيِّبَّةَ الرّائِحَةِ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","«ثُمَّ خُذْ صَدرَ كَبْشِ تَكْرِيسِ هارُونَ، وَارْفَعْهُ تَقْدِمَةً فِي حَضرَةِ اللهِ. هَذا يَكُونُ نَصِيبَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","وَخَصِّصْ لِهارُونَ وَأبْنائِهِ صَدرَ الذَّبِيحَةِ الَّتِي رُفِعَتْ، وَالسّاقَ الَّتِي رُفِعَتْ مِنْ ذَبِيحَةِ كَبْشِ التَكْريسِ الَّتِي رُفِعَتْ فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","هَذِهِ الأجزاءُ مِنَ الكَبْشِ هِيَ نَصيبُ هارُونَ وَأبْنائِهِ كَعادَةٍ دائِمَةٍ. تُرْفَعُ مِنْ تَقدِماتِ بَني إسْرائِيلَ الَّتِي يُقَدِّمُونَها كَذَبائِحِ سَلامٍ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«وَثِيابُ هارُونَ المُقَدَّسَةُ سَتَكُونُ لِأبنائِهِ مِنْ بَعدِهِ لِيُمسَحُوا فِيها وَلِيُعَيَّنُوا كَكَهَنَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","فَمَنْ يَحِلُّ مَحَلَّ هارُونَ مِنْ أبْنائِهِ، يَلبِسُ ثِيابَهُ سَبعَةَ أيّامٍ مُتَتالِيَةٍ حِينَ يَأتِي إلَى خَيمَةِ الاجْتِماعِ لِيَخدِمَ فِي القُدْسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«خُذْ كَبْشَ التَكْريسِ وَاطْبُخْ لَحمَهُ فِي مَكانٍ مُقَدَّسٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","وَليَأكُلْ هارُونُ وَأبناؤهُ لَحمَ الكَبْشِ وَالخُبزَ الَّذِي فِي السَّلَّةِ عِندَ بابِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","لِيأكُلُوا الذَّبائِحَ وَالتَّقدِماتِ الَّتِي اسْتُخدِمَتْ لِتَكفيرِ خَطاياهُمْ لِتَكْرِيسِهِمْ وَتَقْدِيسِهِمْ. وَلا يَجُوزُ لِغَرِيبٍ أنْ يَأكُلَ مِنها لِأنَّها مُخَصَّصَةٌ لِلكَهَنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","فَإنْ بَقِيَ شَيءٌ مِنْ لَحمِ ذَبِيحَةِ التَّكْرِيسِ أوْ مِنَ الخُبزِ إلَى الصَّباحِ، أحْرِقْهُ بِالنّارِ. لا يَنبَغِي أنْ يُؤكَلَ لِأنَّهُ مُقَدَّسٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«افْعَلْ لِهارُونَ وَأبْنائِهِ بِحَسَبِ كُلِّ ما أمَرتُكَ بِهِ. قَدِّمْ ذَبائِحَ تَكْرِيسٍ لَهُمْ لِمُدَّةِ سَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","قَدِّمْ كُلَّ يَومٍ ثَوراً ذَبِيحَةَ خَطِيَّةٍ كَكَفَّارَةٍ. وَقَدِّمْ ذَبِيحَةَ خَطِيَّةٍ ثانِيَةٍ لِلمَذْبَحِ لِتُكَفِّرَ عَنْهُ. ثُمَّ امْسَحْهُ وَكَرِّسْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","قَدِّمْ ذَبائِحَ تَكفِيرٍ عَلَى المَذبَحِ وَقَدِّسْهُ لِسَبعَةِ أيّامٍ، فَيَصيرَ قُدْسَ أقْداسٍ. وَكُلُّ ما يَلمِسُ المَذبَحَ يَتَقَدَّسُ أيضاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«هَذا هُوَ ما تُقَدِّمُهُ عَلَى المَذبَحِ: تُقّدِّمُ كَلَّ يَومٍ، وَبِشَكلٍ دائِمٍ، حَمَلَينِ اثْنَينِ عُمْرُ الواحِدِ سَنَةٌ كَامِلَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","تُقَدِّمُ الحَمَلَ الأوَّلَ فِي الصَّباحِ، وَالثّانِي بَعدَ الغُرُوبِ قُبَيلَ المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","وَتُقَدِّمُ مَعَ الحَمَلِ الأوَّلِ عُشْرَ كَيلٍ مِنَ طَحِينِ القَمحِ النّاعِمِ، مَمزُوجاً بِسَكِيبٍ مِقدارُهُ رُبعُ وِعاءٍ مِنَ زَيْتِ الزَّيتُونِ وَرُبعُ وِعاءٍ مِنَ النَّبِيذِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","وَتُقَدِّمُ الحَمَلَ الثّانِي قَبلَ المَساءِ، وَتُقَدِّمُ مَعَهُ تَقدِمَةَ الحُبُوبِ وَالتَّقدِمَةَ السّائِلَةَ الَّتِي قَدَّمْتَها فِي الصَّباحِ تَقدِمَةً طَيِّبَّةَ الرّائِحَةِ، مُسِرَّةً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","«تَكُونُ هَذِهِ ذَبيحَةً صاعِدَةً دائِمَةً جِيلاً بَعْدَ جِيلٍ عِندَ بابِ خَيمَةِ الاجْتِماعِ فِي حَضرَةِ اللهِ، حَيثُ سَألتَقِي بِكُمْ وَأتَكَلَّمُ إلَيكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","سَألتَقِي بِبَنِي إسْرائِيلَ هُناكَ، وَمَجدِي سَيُقَدِّسُ خَيمَةَ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","«سَأُقَدِّسُ خَيمَةَ الاجْتِماعِ وَالمَذبَحِ، كَما سَأُقَدِّسُ هارُونَ وَأبناءَهُ لِيَكُونُوا كَهَنَةً لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","سَأسكُنُ وَسَطَ بَنِي إسْرائِيلَ، وَأنا سَأكُونُ إلَهَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","حِينَئِذٍ، سَيَعرِفُونَ أنِّي أنا إلَهُهُمُ الَّذِي أخرَجْتُهُمْ مِنْ أرْضِ مِصرَ لِأسكُنَ فِي وَسَطِهِمْ. أنا إلَهُهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«اصْنَعْ مَذْبَحاً مِنْ خَشَبِ السَّنطِ لإحراقِ البَخُورِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","طُولُهُ ذِراعٌ وَعَرضُهُ ذِراعٌ، أي مُرَبَّعَ القاعِدَةِ، وَارتِفاعُهُ ذِراعانِ. وَلْتَكُنْ زَواياهُ البارِزَةُ قِطعَةً واحِدَةً مَعَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","غَشِّ سَطحَهُ وَجَوانِبَهُ وَزَواياهُ البارِزَةَ بِالذَّهَبِ النَقِيِّ. وَاصْنَعْ لَهُ حافَّةً حَوالَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","«ثُمَّ اصْنَعْ لَهُ حَلَقَتَينِ مِنْ ذَهَبٍ تَحتَ حافَّتِهِ عَلَى جانِبَيهِ. تُسْتَخْدَمُ الحَلَقَتانِ لِوَضعِ العَصَوَينِ لِحَملِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","اصْنَعِ العَصَوَينِ مِنْ خَشَبِ السَّنْطِ، وَغَشِّهِما بِالذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ضَعْ مَذْبَحَ البَخُورِ أمامَ السِّتارَةِ الَّتِي تَتَدَلَّى أمامَ غِطاءِ صُندُوقِ العَهدِ حَيثُ مَوعِدِي مَعَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","«عَلَى هارُونَ أنْ يُحْرِقَ بَخُوراً طَيِّباً عَلَى هَذا المَذْبَحِ. يُحْرِقَهُ كُلَّ صَباحٍ حِينَ يَصلِحُ السُّرُجَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","وَكَذَلِكَ حِينَ يُصلِحُ هارُونُ السُّرُجَ عِندَ المَساءِ. يُحْرِقُ البَخُورَ فِي حَضرَةِ اللهِ يَومِيّاً جِيلاً بَعْدَ جِيلٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","لَكِنْ لا تُقَدِّمْ عَلَيهِ بَخُوراً غَرِيباً أوْ ذَبيحَةً صاعِدَةً أوْ تَقدِمَةً مِنْ حُبُوبٍ. وَلا تَسكُبْ عَلَيهِ سَكيباً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","«وَيَقُومُ هارُونَ بِطَقْسِ التَّكفِيرِ عَلَى زِوايا المَذبَحِ مَرَّةً فِي السَّنَةِ. يَضَعُ دَمَ ذَبِيحَةِ كَفَّارَةِ الخَطِيَّةِ عَلَى الزَّوايا البارِزَةِ لِمَذْبَحِ البَخُورِ. لِيُصْنَعْ هَذا فِي جَمِيعِ أجيالِكُمْ. إنَّهُ قُدْسُ أقداسٍ للهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","وَتَكَلَّمَ اللهُ إلَى مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«حِينَ تُحْصِي بَني إسْرائِيلَ لِتُسَجِّلَهُمْ، يَدفَعُ كُلُّ مَنْ يُحصَى فِديَةً عَنْ حَياتِهِ للهِ، كَي لا يَأتِيَ وَباءٌ عَلَيهِمْ حِينَ يَتِمُّ إحصاؤُهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","فَكُلُّ مَنْ يُحْصَى يُقَدِّمُ نِصْفَ مِثْقالٍ بِحَسَبِ القِياسِ الرَّسميِّ – يساوِي المِثْقالُ عِشرِينَ قِيراطاً فَليُقَدِّمْ نِصْفَ مِثْقالٍ تَقدِمَةً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","وَكُلُّ مَنْ يُحْصَى مِنْ سِنِّ عِشرِينَ سَنَةً فَأكثَرَ، يُقَدِّمُ تَقدِمَةً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","لا يَدْفَعُ الغَنِيِّ أكثَرَ مِنْ نِصْفِ مِثْقالٍ. وَلا يَدْفَعُ الفَقِيرُ أقَلَّ مِنْ ذَلِكَ، حِينَ يُقَدِّمُونَ تَقدِمَةَ اللهِ كَفّارَةً لِحَياتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","خُذْ مالَ الفِدْيَةِ مِنْ بَنِي إسْرائِيلَ وَخَصِّصْهُ لِخِدْمَةِ خَيمَةِ الاجْتِماعِ تَذْكاراً لِبَني إسْرائِيلَ فِي حَضرَةِ اللهِ الَّذِي فَدَى حَياتِكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","وَتَكَلَّمَ اللهُ إلَى مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«اصْنَعْ حَوضاً برونْزِيّاً لِلاغتِسالِ، قاعِدَتُهُ بُرونْزِيَّةٌ. وَضَعْهُ بَينَ خَيمَةِ الاجْتِماعِ وَالمَذبَحِ، وَاملأهُ ماءً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","فَعَلَى هارُونَ وَأبْنائِهِ أنْ يَغسِلُوا أيدِيَهُمْ وَأرجُلَهُمْ بِذَلِكَ الماءِ ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","حِينَ يَأتُونَ إلَى خَيمَةِ الاجْتِماعِ. لِيَغتَسِلُوا بِالماءِ كَي لا يَمُوتُوا. وَكَذَلِكَ حِينَ يَقتَرِبُونَ إلَى المَذبَحِ لِيَخدِمُوا بِتَقدِيمِ تَقدِمَةٍ عَلَى النّارِ للهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","فَلْيَغْسِلُوا أيدِيَهُمْ وَأرجُلَهُمْ كَي لا يَمُوتُوا. فَليُحفَظْ هَذا العِيدُ جِيلاً بَعْدَ جِيلٍ كَعادَةٍ دائِمَةٍ لِهارُونَ وَلِنَسلِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","وَتَكَلَّمَ اللهُ إلَى مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«خُذْ أطيَبَ العُطُورِ: خَمْسَ مِئَةِ مِثْقالٍ مِنَ المُرِّ السّائِلِ، مِئَتينِ وَخَمْسِينَ مِثْقالاً مِنَ القِرفَةِ العَطِرَةِ، مِئِتينِ وَخَمْسِينَ مِثْقالاً مِنْ قَصَبِ الذَّرِيرَةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","خَمْسَ مِئَةِ مِثْقالٍ مِنَ السَّلِيخَةِ بِحَسَبِ الوَزنِ الرَّسمِيِّ، وَمِقدارَ وِعاءٍ مِنْ زَيتِ الزَّيتُونِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","«وَاصْنَعْ مِنْ كُلِّ هَذِهِ زَيتاً مُقَدَّساً لِلمَسحَةِ مَمزُوجاً مَعاً كَالعِطرِ. وَسَيَكُونُ هَذا زَيتاً مُقَدَّساً لِلمَسحَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","استَخْدِمْهُ لِمَسحِ خَيمَةِ الاجْتِماعِ وَصُندُوقِ لَوحَيِّ الشَّهادَةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","وَالمائِدَةِ وَأدَواتِها وَالمَنارَةِ وَأدَواتِها وَمَذْبَحِ البَخُورِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","وَمَذبَحِ الذَّبائِحِ الصّاعِدَةِ وَكُلَّ أدَواتِهِ وَحَوضَ الماءِ وَقاعِدَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","تُقَدِّسُها فَتَصِيرَ نَصِيباً مُخَصَّصاً لِلكَهَنَةِ بِالكامِلِ، وَكُلُّ مَنْ يَلمِسُها يَتَقَدَّسُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","«وَامْسَحْ هارُونَ وَأبناءَهُ لِكَي تُخَصِّصَهُمْ لِيَكُونُوا كَهَنَةً لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","وَتَكَلَّمْ إلَى بَنِي إسْرائِيلَ وَقُلْ لَهُمْ: سَيَكُونُ هَذا لِي زَيتَ المَسحَةِ المُقَدَّسَ جِيلاً بَعْدَ جِيلٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","فَلا يَنبَغي أنْ يُستَخدَمَ كَعِطرٍ عادِيٍّ، وَلا يَجُوزُ أنْ تَصنَعُوا عِطراً مِثلَهُ. فَهُوَ مُخَصَّصٌ لِلاستِخدامِ كَما أمَرَ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","كُلُّ مَنْ يُرَكِّبُ زَيتاً مِثلَهُ، أوْ يَضَعُ مِنهُ عَلَى شَخصٍ غَيْرِ مُؤهَّلٍ، يُقطَعُ مِنَ الشَّعبِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","وَقالَ اللهُ لِمُوسَى: «خُذْ كَمِّيّاتٍ مُتَساوِيَةً مِنَ العُطُورِ: مَيْعَةً وَأظفاراً وَقِنَّةً عَطِرَةً وَلُباناً نَقِيّاً، ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","وَاصْنَعْ مِنها بَخُوراً عَطِراً مُمَلَّحاً نَقِيّاً مُقَدَّساً، كَما يَفعَلُ أمهَرُ العَطّارِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","اسْحَقْ بَعضَهُ ناعِماً جِدّاً، وَضَعْ مِنهُ أمامَ صُندُوقِ الشَّهادَةِ فِي خَيمَةِ الاجْتِماعِ حَيثُ أُعلِنُ ذاتِي لَكَ. يَكُونُ هَذا البَخُورُ قُدسَ أقداسٍ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","اصنَعُوا البَخُورَ بمَقادِيرِهِ، لَكِنْ لا تَصنَعُوهُ لِأنفُسِكُمْ، بَلْ يَكُونُ مُخَصَّصاً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","وَمَنْ يَصنَعُ البَخُورَ نَفسَهُ لِيَشُمَّهُ، يُقطَعُ مِنَ الشَّعبِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","وَتَكَلَّمَ اللهُ إلَى مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«ها قَدِ اختَرتُ بَصَلْئِيلَ بْنَ أُورِي بْنَ حُورَ مِنْ قَبِيلَةِ يَهُوذا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","سَأملأُهُ بِرُوحٍ اللهِ مَهارَةً وَفَهماً وَمَعرِفَةً وَقُدراتٍ كَبِيرَةً ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","لِعَمَلِ تَصامِيمَ مِنَ الذَّهَبِ وَالفِضَّةِ وَالبُرونْزِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","وَفِي النَّقشِ عَلَى الحِجارَةِ الكَرِيمَةِ لِلتَّرصِيعِ، وَفِي زَخرَفَةِ الخَشَبِ، وَجَميعِ أنواعِ المَهاراتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","وَقَدْ أعطَيتُهُ أُهُولِيآبَ بْنَ أخِيساماكَ مِنْ قَبِيلَةِ دانَ لِمُساعَدَتِهِ. «وَأعطَيتُ مَهارَةً لِكُلِّ صانِعٍ مُحتَرِفٍ لِيَصْنَعُوا جَمِيعَ ما أمَرْتُكَ بِهِ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","خَيمَةَ الاجْتِماعِ وَصُندُوقَ لَوحَيِّ الشَّهادَةِ وَغِطاءَ صُندُوقِ لَوحَيِّ الشَّهادَةِ وَكُلَّ أدَواتِ الخَيمَةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","المائِدَةَ وَكُلَّ أدَواتِها، المَنارَةَ المَصْنُوعَةَ مِنَ الذَّهَبِ النَقِيِّ وَكُلَّ أدَواتِها، مَذْبَحَ البَخُورِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","مَذبَحَ الذَّبائِحِ الصّاعِدَةِ وَكُلَّ أدَواتِهِ، حَوضَ الاغتِسالِ وَقاعِدَتَهُ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","الثِّيابَ المَنسُوجَةَ وَالثِّيابَ المُقَدَّسَةَ الَّتِي لِهارُونَ، ثِيابَ أبْنائِهِ الكَهنُوتِيَّةَ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","زَيتَ المَسحَةِ وَالبَخُورَ الطَّيِّبَ لِلقُدسِ. «فَلْيَعْمَلُوها بِحَسَبِ ما أمَرْتُكَ بِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«تَكَلَّمْ إلَى بَني إسْرائِيلَ وَقُلْ لَهُمْ: ‹احفَظُوا سُبُوتِي لِأنَّها عَلامَةٌ بَينِي وَبَينَكُمْ جِيلاً بَعْدَ جِيلٍ لِتَعرِفُوا أنِّي أنا اللهُ الَّذِي أُقَدِّسُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","احْفَظُوا السَّبتَ لِأنَّهُ مُقَدَّسٌ. وَكُلُّ مَنْ يُنَجِّسُهُ يُقتَلُ. فَكُلُّ مَنْ يَقُومُ بِعَمَلٍ ما فِي السَّبتِ، يُقطَعُ مِنَ وَسَطِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","«‹اعمَلُوا سِتَّةَ أيّامٍ، وَأمّا اليَومُ السّابِعُ فاحفَظُوهُ لِلرَّاحَةِ، فَهُوَ يَومٌ مٌقَدَّسٌ للهِ. مَنْ يَعمَلُ فِي يَومِ السَّبتِ فَإنَّهُ يُقْتَلُ.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","عَلَى بَني إسْرائِيلَ أنْ يَحفَظُوا السَّبتَ لِيَبقَى جِيلاً بَعْدَ جِيلٍ كَعَهدٍ أبَدِيٍّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","إنَّهُ عَلامَةٌ أبَدِيَّةٌ بَينِي وَبَينَ بَنِي إسْرائِيلَ، لِأنَّ اللهَ صَنَعَ السَّماءَ وَالأرْضَ فِي سِتَّةِ أيّامٍ، وَفِي اليَومِ السّابِعِ أكْمَلَ العَمَلَ وَاستَراحَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","فَلَمّا انتَهَى اللهُ مِنَ الكَلامِ مَعَهُ عَلَى جَبَلِ سِيناءَ، أعطَى مُوسَى لَوحَيِّ الشَّهادَ. وَهُما الحَجَرانِ اللَّذانِ نَقَشَ اللهُ عَلَيهِما بِإصبَعِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","وَرَأى الشَّعبُ أنَّ مُوسَى قَدْ تَأخَّرَ فِي النُّزُولِ مِنَ الجَبَلِ، فاجتَمَعُوا حَولَ هارُونَ وَقالُوا لَهُ: «قُمْ وَاصنَعْ لَنا آلِهَةً لِتَقُودَنا فِي الطَّرِيقِ. فَنَحْنُ لا نَدرِي ما الَّذِي حَلَّ بهَذا الرَّجُلِ مُوسَى الَّذِي أخرَجَنا مِنْ أرْضِ مِصرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","فَقالَ هارُونُ لَهُمْ: «انزِعُوا أقراطَ الذَّهَبِ الَّتِي فِي آذانِ زَوجاتِكُمْ وَأولادِكُمْ وَأحضِرُوها لَي.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","فَنَزَعَ الشَّعبُ أقراطَ الذَّهَبِ الَّتِي كانَتْ فِي آذانِهِمْ وَأحضَرُوها إلَى هارُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","فَأخَذَ هارُونُ الذَّهَبَ مِنهُمْ، وَصَهَرَهُ وَشَكَّلَهُ بِالإزمِيلِ، وَصَنَعَ مِنهُ عِجلاً مَسبُوكاً. فَقالُوا: «هَذِهِ هِيَ آلِهَتُكَ الَّتِي أخرَجَتْكَ مِنْ أرْضِ مِصرَ يا إسْرائِيلُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","وَحِينَ رَأى هارُونُ هَذا، بَنَى مَذبَحاً أمامَهُ. وَأعلَنَ هارُونُ: «سَنَعمَلُ عِيداً للهِ غَداً.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","فَنَهَضَ الشَّعبُ باكِراً فِي صَباحِ اليَومِ التّالِي وَقَدَّمُوا ذَبائِحَ صاعِدَةً وَذَبائِحَ سَلامٍ. وَبَعدَ ذَلِكَ جَلَسَ الشَّعبُ لِيأكُلُوا وَيَشْرَبُوا، وَنَهَضُوا لِيُرَفِّهُوا عَنْ أنفُسِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","وَقالَ اللهُ لِمُوسَى: «انزِلْ فِي الحالِ! فَها شَعبُكَ الَّذِي أخرَجتَهُ مِنْ أرْضِ مِصرَ قَدْ فَسَدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","حادُوا سَريعاً عَنِ الطَّرِيقِ الَّذِي أمَرتُهُمْ بِهِ، إذْ صَنَعُوا عِجلاً مَسبُوكاً لِأنفُسِهِمْ وَسَجَدُوا لَهُ وَقَدَّمُوا لَهُ ذَبائِحَ، وَقالُوا: ‹هَذِهِ هِيَ آلِهَتُكَ الَّتِي أخرَجَتْكَ مِنْ مِصرَ يا إسْرائِيلُ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","وَقالَ اللهُ لِمُوسَى: «قَدْ رَأيتُ هَذا الشَّعبَ! إنَّهُمْ شَعبٌ عَنِيدٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","وَالآنَ، دَعْنِي فَيَشتَعِلَ غَضَبِي عَلَيهِمْ وَيَلتَهِمَهُمْ. حِينَئِذٍ، سَأجْعَلُ مِنكَ أُمَّةً عَظِيمَةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","لَكِنَّ مُوسَى تَوَسَّلَ إلَى إلَهِهِ وَقالَ: «لِماذا يا اللهُ يَشتَعِلُ غَضَبُكَ عَلَى شَعبِكَ الَّذِي أخرَجتَهُ مِنْ مِصرَ بِقُوَّةٍ عَظِيمَةٍ وَيَدٍ قَوِيَّةٍ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","لِماذا تُعطِي المِصرِيِّينَ فُرصَةً لِيَقُولُوا: ‹أخرَجَهُمُ إلَهُهُمْ وَهُوَ يُضْمِرُ لَهُمُ الشَّرَّ، لِيَقتُلَهُمْ في الجِبالِ، وَلِيُبِيدَهُمْ مِنْ عَلَى وَجهِ الأرْضِ›؟ ارجِعْ عَنْ غَضَبِكَ الشَّدِيدِ. وَلا تَعمَلْ ما فَكَّرْتَ بِهِ مِنَ الشَّرِّ عَلَى شَعبِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","تَذَكَّرْ إبراهِيمَ وَإسْحاقَ وَإسْرائِيلَ، خُدّامَكَ الَّذِينَ أقسَمتَ لَهُمْ بِنَفسِكَ وَوَعَدتَهُمْ: ‹سَأُكَثِّرُ نَسلَكَ لِيَصِيرَ كَعَدَدِ نُجُومِ السَّماءِ، وَسَأُعطِي هَذِهِ الأرْضَ، الَّتِي وَعَدْتُ بِها، لِنَسلِكُمْ لِيَمتَلِكُوها إلَى الأبَدِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","فَرَجِعَ اللهُ عَمّا كانَ يُفَكِّرُ بِهِ مِنْ شَرٍّ قالَ إنَّهُ سَيَعمَلُهُ بِشَعبِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ثُمَّ نَزَلَ مُوسَى مِنَ الجَبَلِ وَلَوحا الشَّهادَةِ فِي يَدِهِ. كانَتِ الوَصايا مَنْقُوشَةً عَلَى اللَّوحَينِ مِنَ الأمامِ وَمِنَ الخَلفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","اللهُ هُوَ مَنْ صَنَعَ اللَّوحَينِ، وَاللهُ هُوَ مَنْ نَقَشَ الكِتابَةَ عَلَيهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","وَحِينَ سَمِعَ يَشُوعُ ضَجيجَ الشَّعبِ، قالَ لِمُوسَى: «هُناكَ صَوتُ حَربٍ فِي المُخَيَّمِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","فَأجابَهُ مُوسَى: «لَيسَ هَذَا بِهُتافِ انتِصارٍ وَلا صُراخِ هَزِيمَةٍ. إنَّهُ صَوتُ غِناءٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","وَحِينَ اقتَرَبَ مُوسَى مِنَ المُخَيَّمِ، رَأى العِجلَ الذَّهَبِيَّ وَالرَّقصَ. فَغَضِبَ جِدّاً، وَطَرَحَ اللَّوحَينِ مِنْ يَدَيهِ فَتَحَطَّما عِندَ أسفَلِ الجَبَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ثُمَّ أخَذَ العِجلَ الَّذِي صَنَعُوهُ، وَأحرَقَهُ بِالنّارِ وَسَحَقَهُ سَحقاً، وَرَشَّهُ عَلَى الماءِ، وَجَعَلَ بَنِي إسْرائِيلَ يَشرَبُونَ مِنَ الماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","وَقالَ مُوسَى لِهارُونَ: «ماذا عَمِلَ هَذا الشَّعبُ ضِدَّكَ حَتَّى تَجلِبَ عَلَيهِمْ هَذِهِ الخَطِيَّةَ العَظِيمَةَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","فَقالَ هارُونُ: «لا تَغضَبْ يا سَيِّدِي! أنتَ تَعرِفُ أنَّ الشَّعبَ مَيّالٌ لِلشَّرِّ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","وَقَدْ قالُوا لِيَ: ‹قُمْ وَاصنَعْ لَنا آلِهَةً لِتَقُودَنا فِي الطَّرِيقِ. فَنَحْنُ لا نَدرِي ما الَّذِي حَلَّ بهَذا الرَّجُلِ مُوسَى الَّذِي أخرَجَنا مِنْ أرْضِ مِصرَ.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","فَقُلْتُ لَهُمْ مَنْ يَملُكُ ذَهَباً فَلْيَنْزِعْهُ وَلْيُعطِهِ لِي. ثُمَّ ألقَيتُ الذَّهَبَ فِي النّارِ، فَخَرَجَ هَذا العِجلُ!» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","فَرَأى مُوسَى أنَّ الشَّعبَ قَدْ خَرَجَ عَنِ السَّيطَرَةِ، لِأنَّ هارُونَ سَمَحَ بِذَلِكَ، حَتَّى إنْ أعْداءَهُمُ اسْتَهْزأوا بَسُلُوكِهِمُ المُخْزِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","فَوَقَفَ فِي مَدخَلِ المُخَيَّمِ وَقالَ: «مَنْ يَتبَعُ اللهَ فَلْيَأْتِ إلَيَّ.» فَأتَى الَّلاوِيُّونَ إلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","وَقالَ لَهُمْ: «هَذا هُوَ ما يَقُولُهُ إلَهُ إسْرائِيلَ: فَلْيَضَعْ كُلُّ رَجُلٍ سَيفَهُ عَلَى فَخذِهِ، وَيَمشِي فِي المُخَيَّمِ مِنْ بابٍ إلَى آخَرَ. وَلْيَقتُلْ كُلُّ واحِدٍ أخاهُ وَصَدِيقَهُ وَجارَهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","فَعَمِلَ الَّلاوِيُّونَ بِحَسَبِ قَولِ مُوسَى. وَماتَ فِي ذَلِكَ اليَومِ نَحْوُ ثَلاثَةِ آلافٍ مِنْ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","وَقالَ مُوسَى: «قَدْ كَرَّسْتُمْ أنفُسَكُمُ اليَومَ لِخِدْمَةِ اللهِ، حَتَّى بِأبنائِكُمْ وَإخوَتِكُمْ. فَسَيُبارِكَكُمُ اللهُ اليَومَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","وَفِي اليَومِ التّالِي، قالَ مُوسَى لِلشَّعبِ: «لَقَدْ أخطَأْتُمْ خَطِيَّةً عَظِيمَةً. وَالآنَ، سَأصعَدُ إلَى اللهِ، لَعَلَّهُ يَستَجِيبُ لِي فَيُكَفِّرَ عَنْكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","فَعادَ مُوسَى إلَى اللهِ وَقالَ: «يا اللهُ، قَدْ أخطَأ هَذا الشَّعبُ خَطِيَّةً عَظِيمَةً بِصُنعِهِمْ آلِهَةً مِنْ ذَهَبٍ لِأنفُسِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","وَالآنَ، اغفِرْ خَطِيَّتَهُمْ، أوِ امحُنِي مِنْ كِتابِكَ الَّذِي كَتَبتَهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","فَقالَ اللهُ لِمُوسَى: «مَنْ يُخطِئُ إلَيَّ، أمحُو اسْمَهُ مِنْ كِتابِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","وَالآنَ، اذْهَبْ وَقُدِ الشَّعبَ إلَى حَيثُ قُلْتُ لَكَ. سَيَسِيرُ مَلاكِي أمامَكَ، لَكِنِّي سَأُعاقِبُهُمْ عَلَى خَطِيَّتِهِمْ فِي الوَقتِ المُناسِبِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ثُمَّ ضَرَبَ اللهُ الشَّعبَ بِوَباءٍ لِأنَّهُمْ هُمْ بِالحَقيقَةِ الَّذينَ صَنَعُوا العِجلَ الَّذِي صَنَعَهُ هارُونُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","وَكَلَّمَ اللهُ مُوسَى فَقالَ: «اذْهَبْ مِنْ هُنا أنتَ وَالشَّعْبُ الَّذِي أخرَجْتَهُ مِنْ مِصرَ. اذْهَبوا إلَى الأرْضِ الَّتِي أقسَمتُ لإبراهِيمَ وَإسْحاقَ وَإسْرائِيلَ بِأنْ أعْطيها لِنَسلِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","سَأُرسِلُ مَلاكاً أمامَكَ، وَأطْرَدُ الكَنعانِيِّينَ وَالأمُورِيِّينَ وَالحِثِّيِّينَ وَالفِرِزِيِّينَ وَالحِوِّيِّينَ وَاليَبُوسِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","اذهَبُوا إلَى أرْضٍ تَفِيضُ لَبَناً وَعَسَلاً. لَكِنِّي لَنْ أكُونَ مَعَكُمْ لِأنَّكُمْ شَعبٌ عَنِيدٌ، لِئَلّا أُبِيدَكُمْ فِي الطَّرِيقِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","وَحِينَ سَمِعَ الشَّعبُ هَذا الكَلامَ القاسِي، ناحُوا، وَلَمْ يَرتَدِ أحَدٌ جَواهِرَهُ أوْ زِينَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","فَقَدْ قالَ اللهُ لِمُوسَى: «قُلْ لِبَنِي إسْرائِيلَ: أنتَ شَعبٌ عَنِيدٌ، فَإنْ حَضَرْتُ فِي وَسَطِكُمْ لِلَحظَةٍ فَإنِّي سَأُبِيدُكُمْ! انزِعُوا جَواهِرَكُمْ وَزِينَتَكُمْ فَأُقَرِّرَ ما عَلَيَّ أنْ أعمَلَهُ مَعَكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","فَنَزَعَ بَنُو إسْرائِيلَ جَواهِرَهُمْ وَزِينَتَهُمْ مُنذُ كانُوا عَلَى جَبَلِ حُورِيبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","وَكانَ مُوسَى يَأخُذُ خَيمَةً وَيَنصُبُها بَعِيداً خارِجَ المُخَيَّمِ. وَكانَ يُسَمِّيها «خَيمَةَ الاجْتِماعِ.» وَكُلُّ مَنْ كانَ يَطلُبُ اللهَ، كانَ يَخرُجُ إلَى خَيمَةِ الاجْتِماعِ الَّتِي كانَتْ خارِجَ المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","وَحِينَ كانَ مُوسَى يَذهَبُ إلَى تِلكَ الخَيمَةِ، كانَ الشَّعبُ يَقُومُونَ، وَيَقِفُ كُلُّ واحِدٍ فِي بابِ خَيمَتِهِ، وَكانُوا يُراقِبُونَ مُوسَى حَتَّى يَدخُلَ إلَى الخَيمَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","وَحِينَ كانَ مُوسَى يَدخُلُ الخَيمَةَ، كانَ عَمُودُ السَّحابِ يَنزِلُ وَيَستَقِرُّ عَلَى مَدْخَلِ الخَيمَةِ، وَكانَ اللهُ يَتَكَلَّمُ مَعَ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","وَحِينَ كانَ الشَّعبُ يَرَى عَمُودَ السَّحابِ واقِفاً عِندَ مَدْخَلِ الخَيمَةِ، كانُوا يَذهَبُونَ وَيَسجدُونَ عِندَ أبوابِ خِيامِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","كانَ اللهُ يُكَلِّمُ مُوسَى وَجهاً لِوَجهٍ، كَما يُكَلِّمُ الصَّدِيقُ صَدِيقَهُ. وَحِينَ كانَ مُوسَى يَعُودُ إلَى المُخَيَّمِ، كانَ خادِمُهُ يَشُوعُ بْنُ نُونَ يَمكُثُ فِي الخَيمَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","وَقالَ مُوسَى للهِ: «ها أنتَ تَقُولُ لِي: ‹أخرِجْ هَذا الشَّعبَ،› لَكِنَّكَ لَمْ تُخبِرْنِي مَنْ سَتُرسِلُ مَعِي. قُلْتَ لِي: ‹أعرِفُكَ بِاسْمِكَ، وَقَدْ حَظِيتَ بِرِضايَ.› ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","فَبِما أنِّي حَظِيتُ بِرِضاكَ، فَأعلِنْ لِي طَرِيقَكَ لِأعرِفَكَ وَأُرْضِيَكَ دائِماً. وَتَذَكَّرْ أنَّ هَذِهِ الأُمَّةَ هِيَ شَعبُكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","فَقالَ: «أنا سَأسِيرُ بِحُضُورِي أمامَكَ وَأقُودُكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","فَقالَ مُوسَى لَهُ: «إنْ لَمْ تَسِرْ بِحُضُورِكَ مَعَنا، فَلا تُخْرِجْنا مِنْ هُنا. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","كَيفَ سَيَعرِفُ النّاسُ أنِّي حَظِيتُ بِرِضاكَ أنا وَشَعبُكَ، إنْ لَمْ تَسِرْ مَعَنا؟ حِينَئِذٍ فَقَطْ أكُونُ أنا وَشَعبُكَ مُتَمَيِّزِينَ عَنْ شُعُوبِ الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","وَقالَ اللهُ لِمُوسَى: «سَأفعَلُ لَكَ هَذا الَّذِي قُلْتَهُ أيضاً، لأنَّكَ قَدْ حَظِيتَ بِرِضايَ، وَأنا أعرِفُكَ بِاسْمِكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","فَقالَ مُوسَى: «فَأرِنِي مَجدَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","فَقالَ اللهُ: «سَأجعَلُ كُلَّ صَلاحِي يَمُرُّ مِنْ أمامِكَ، وَسَأنطِقُ بِاسمِي ‹يهوه› عَلَى مَسْمَعٍ مِنْكَ. فَأنا أتَحَنَّنُ عَلَى مَنْ أشاءُ أنْ أتَحَنَّنَ عَلَيهِ، وَأرْحَمُ مَنْ أشاءُ أنْ أرْحَمَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","لَكِنَّكَ لَنْ تَستَطِيعَ أنْ تَرَى وَجهِي، لِأنَّهُ لا يُمكِنُ لإنسانٍ أنْ يَرانِي وَيَبْقَى حَيّاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ثُمَّ قالَ لَهُ اللهُ: «هُناكَ مَكانٌ قَرِيبٌ مِنِّي، فَقِفْ عَلَى الصَّخرَةِ فِي هَذا المَكانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","وَحِينَ يَمُرُّ مَجدِي، سَأضَعُكَ فِي شَقٍّ كَبِيرٍ فِي الصَّخرَةِ وَأُغَطِّيكَ بِيَدِي حَتَّى أعبُرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","وَحِينَ أرفَعُ يَدِي، سَتَرَى لَمْحَةً مِنْ مَجْدِي. أمّا وَجهِي فَلَنْ تَراهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","وَقالَ اللهُ لِمُوسَى: «انحَتْ لَوحَينِ مِنْ حَجَرٍ مَثلَ الَّلوحَينِ الأوَّلَينِ. وَسَأكتُبُ عَلَى اللَّوحَينِ الوَصايا الَّتِي كانَتْ عَلَى اللَّوحَينِ الأوَّلِيْنِ اللَّذَينِ حَطَّمتَهُما. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","كُنْ مُستَعِدّاً فِي الصَّباحِ لِلصُّعُودِ إلَى جَبَلِ سِيناءَ، وَانتَظِرْنِي عَلَى قِمَّةِ الجَبَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","لا يَصعَدْ أحَدٌ مَعَكَ فِي كُلِّ الجَبَلِ. وَلا يَرْعَ أحَدٌ الغَنَمَ وَالبَقَرَ مُقابِلَ ذَلِكَ الجَبَلِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","فَنَحَتَ مُوسَى لَوحَي حِجارَةٍ كَاللَّوحَينِ الأوَّلَيْنِ، وَقامَ فِي الصَّباحِ باكِراً، وَصَعِدَ إلَى جَبَلِ سِيناءَ كَما أمَرَهُ اللهُ، وَبِيَدِهِ لَوحا الحِجارَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","فَنَزَلَ اللهُ فِي السَّحابِ وَوَقَفَ مَعَ مُوسَى هُناكَ، فَدَعا مُوسَى اللهَ بِاسْمِ «يهوه.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ثُمَّ مَرَّ اللهُ مِنْ أمامِهِ وَهُوَ يُعلِنُ ما يَلِي: «يهوه، يهوه، إلَهٌ حَنُونٌ رَحِيمٌ، بَطِيءُ الغَضَبِ. رَحمَتُهُ وَوَفاؤُهُ عَظِيمانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","يَحفَظُ الأمانَةَ لِأُلُوفِ الأجيالِ، وَيَغفِرُ الذَّنبَ وَالمَعصِيَةَ وَالخَطِيَّةَ، لَكِنَّهُ لا يُلْغِي العُقُوبَةَ، بَلْ يَحْسِبُ خَطايا الآباءِ عَلَى أبْنائِهِمْ وَأحفادِهِمْ وَأحفادِ أبْنائِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","فَأسرَعَ مُوسَى وَسَجَدَ عَلَى الأرْضِ عابِداً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","وَقالَ مُوسَى: «بِما أنِّي حَظِيتُ بِرِضاكَ يا رَبُّ، فَسِرْ يا رَبُّ مَعَنا، وَاغفِرْ مَعصِيَتَنا وَخَطِيَّتَنا، وَاقبَلْنا مُلكاً لَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","فَقالَ اللهُ: «ها أنا سَأقطَعُ عَهداً مَعَكَ، أمامَ كُلِّ شَعبِكَ، سَأصنَعُ مُعجِزاتٍ لَمْ تُصنَعْ قَبلاً فِي كُلِّ الأرْضِ مَعَ شَعبٍ آخَرَ. وَسَيَرَى كُلُّ الشَّعبِ الَّذِي تَسكُنُ فِي وَسَطِهِ عَمَلَ اللهِ، لِأنِّي سَأعمَلُ أمراً رَهِيباً مَعَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","احفَظْ ما أُوصِيكَ بِهِ اليَومَ. سَأطرُدُ مِنْ أمامِكَ الأمُورِيِّينَ وَالكَنعانِيِّينَ وَالحِثِّيِّينَ وَالفِرِزِّيِّينَ وَالحِوِّيِّينَ وَاليَبُوسِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","احرِصْ عَلَى أنْ لا تَقْطَعْ عَهداً مَعَ سُكّانِ الأرْضِ الَّتِي سَتَدخُلُها، لكَي لا يَكُونُوا فَخّاً لَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","بَلِ اهْدِمْ مَذابِحَهُمْ وَحَطِّمْ أنْصابَهُمُ التَّذكارِيَّةَ، وَاقطَعْ أعمِدَةَ عَشْتَرُوتَ الَّتِي يَعبُدُونَها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","لا تَعبُدْ إلَهاً سِوايَ، فاسْمِي هُوَ ‹يهوه الغَيُورُ،› لأنَّي إلَهٌ غَيُورُ! ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","«لا تَقْطَعْ عَهْداً مَعَ سُكّانِ هَذِهِ الأرْضِ، خَوفاً مِنْ أنْ يَدعُوكَ وَهُمْ يَعبُدُونَ آلِهَتِهِمْ وَيَذبَحُونَ لَها، فَتأكُلَ مِنْ ذَبائِحِهِمْ! ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","لا تَأخُذْ مِنْ بَناتِهِمْ لِأبنائِكَ، إذْ سَتَزنِي بَناتُهُمْ وَراءَ آلِهَتِهِنَّ، وَيَجعَلْنَ أبْناءَكَ يَزنُونَ وَراءَ آلِهَتِهِنَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«لا تَصنَعْ لَكَ آلِهَةً مَسبُوكَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«احفَظْ عِيدَ الخُبزِ غَيرِ المُختَمِرِ. تَأكُلُ خُبزاً بِلا خَمِيرٍ لِسَبعَةِ أيّامٍ فِي الوَقتِ المُعَيَّنِ فِي شَهرِ أبِيبَ، كَما أمَرتُكَ لِأنَّكَ فِي شَهرِ أبِيبَ خَرَجتَ مِنْ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«كُلُّ الأبْكارِ لِي. كُلُّ الذُّكُورِ الأبْكارِ مِنْ ماشِيَتِكَ، بَقَراً كانَتْ أوْ غَنَماً، يَكُونُونَ لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","وَتَسْتَبْدِلُ بِبِكْرِ الحِمارَ خَرُوفاً. فَإنْ لَمْ تُرِدْ أنْ تَفتَدِيَهُ بِخَرُوفٍ، اكْسِرْ عُنقَهُ. كَما يَنبَغِي أنْ تَفتَدِيَ أبْكارَ أبْنائِكَ، فَلا يَأتُوا أمامِي فارِغِي الأيدِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«اعمَلْ لِسِتَّةِ أيّامٍ، وَاسْتَرِحْ فِي اليَومِ السّابِعِ، حَتَّى فِي أوقاتِ الحِراثَةِ وَالحَصادِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«احْفَظْ عِيدَ الأسابِيعِ فِي بِدايَةِ حَصادِ القَمحِ، وَعِيدَ الجَمعِ فِي خَرِيفِ السَّنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","«يَنبَغِي أنْ يَحضُرَ جَمِيعُ الذُّكُورِ أمامَ اللهِ، إلَهِ إسْرائِيلَ، ثَلاثَ مَرّاتٍ فِي السَّنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","«وَسَأطرُدُ الأُمَمَ مِنْ أمامِكَ وَأُوَسِّعُ أرْضَكَ. وَلَنْ يَطْمَعَ أحَدٌ فِي أرْضِكَ حِينَ تَأتِيَ لِلحُضُورِ أمامَ إلَهِكَ ثَلاثَ مَرّاتٍ فِي السَّنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«لا تُقَدِّمْ دَمَ ذَبِيحَتِي مَعَ خَمِيرٍ. وَلا يَبقَ مِنْ ذَبِيحَةِ الفِصحِ شَيءٌ إلَى صَباحِ اليَومِ التَّالِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«أَحْضِرْ أفَضَلَ أوَّلِ إنتاجِ أرْضِكَ إلَى بَيتِ إلَهِكَ. «وَلا تَطبُخْ جَدْياً فِي حَلِيبِ أُمِّهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","وَقالَ اللهُ لِمُوسَى: «اكتُبْ هَذِهِ الوَصايا، لِأنِّي بِحَسَبِ هَذِهِ الوَصايا قَدْ عَمِلتُ عَهداً مَعَكَ وَمَعَ إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","وَبَقِيَ مُوسَى هُناكَ مَعَ اللهِ أرْبَعِينَ نَهاراً وَأربَعِينَ لَيلَةً، لَمْ يَأكُلْ فِيها طَعاماً وَلَمْ يَشرَبْ ماءً. وَكَتَبَ وَصايا العَهدِ العَشْرَ عَلَى لَوحَيِّ الحَجَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","وَنَزَلَ مُوسَى مِنْ جَبَلِ سِيناءَ. وَكانَ لَوحا الشَّهادَةِ فِي يَدِهِ. وَلَمْ يَكُنْ مُوسَى يَعرِفُ أنَّ جِلدَ وَجهِهِ يَلمَعُ لأنَّهُ تَكَلَّمَ مَعَ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","وَحِينَ رَأى هارُونُ وَكُلُّ بَنِي إسْرائِيلَ أنَّ جِلدَ مُوسَى يَلمَعُ، خافُوا أنْ يَقتَرِبُوا مِنْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","فَدَعاهُمْ مُوسَى إلَيهِ. فَرَجِعَ هارُونُ وَكُلُّ قادَةِ الشَّعبِ إلَيهِ، وَتَكَلَّمَ مُوسَى إلَيْهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","بَعدَ ذَلِكَ، اقتَرَبَ إلَيهِ كُلُّ بَنِي إسْرائِيلَ. وَأوصاهُمْ مُوسَى بِجَميعِ الوَصايا الَّتِي أعْطاها إيّاهُ اللهُ عَلَى جَبَلِ سِيناءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","وَحِينَ انتَهَى مُوسَى مِنَ الكَلامِ مَعَهُمْ، وَضَعَ لِثاماً عَلَى وَجهِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","فَحِينَ كانَ مُوسَى يَأتِي فِي حَضرَةِ اللهِ لِيَتَكَلَّمَ مَعَهُ، كانَ يَرفَعُ اللِّثامَ إلَى أنْ يَخرُجَ مِنَ الخَيمَةِ. وَحِينَ كانَ يَخرُجُ لَيَقُولَ لِبَنِي إسرائِيلَ ما أُمِرَ بِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","يَرَى بَنُو إسْرائِيلَ جِلدَ مُوسَى يَلمَعُ، فَيَضَعُ مُوسَى اللِّثامَ عَلَى وَجهِهِ إلَى أنْ يَذهَبَ لِيَتَكَلَّمَ مَعَ اللهِ مِنْ جَدِيدٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","وَجَمَعَ مُوسَى بَنِي إسْرائِيلَ وَقالَ لَهُمْ: «هَذِهِ هِيَ الوَصايا الَّتِي أمَرَكُمُ اللهُ بِحِفظِها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","يُمكِنُكُمْ أنْ تَعمَلُوا لِسِتَّةِ أيّامٍ، وَأمّا اليَومُ السّابِعُ فَسَيَكُونُ لَكُمْ يَومَ راحَةٍ للهِ. فَمَنْ يَعْمَلْ يَومَ السَّبتِ يُقْتَلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","لا تُشعِلُوا ناراً يَومَ السَّبتِ فِي أيِّ مَكانٍ تَسْكُنُونَ فِيهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","وَقالَ مُوسَى لِكُلِّ بَنِي إسرائِيلَ: «هَذِهِ هِيَ الوَصِيَّةُ الَّتِي أوصاكُمْ اللهُ بِها: ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","قَدِّمُوا مِمّا تَملُكُونَ تَقدِمَةً للهِ. فَكُلٌّ بِحَسَبِ سَخاءِ قَلْبِهِ، يُقَدِّمُ للهِ ذَهَباً، فِضَّةً، بُرونْزاً، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","أقمِشَةً زَرقاءَ وَبَنَفسَجِيِّةٍ وَحَمراءَ وَكِتّاناً وَشَعرَ ماعِزٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","جُلُودَ كِباشٍ مَدبُوغَةٍ، جُلُودَ تُيُوسٍ، خَشَبَ سَنطٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","زَيتاً لِلإنارَةِ وَعُطُوراً لِزَيتِ المِسْحَةِ وَلِلبَخُورِ الطَّيِّبِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","حِجارَةَ جَزعٍ وَجَواهِرَ أُخْرَى لِتَرصِيعِ الثُّوبِ الكَهَنُوتِيِّ وَالصُّدرَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«وَكُلُّ مَنْ هُوَ ماهِرٌ بَينَكُمْ، فَلْيَأتِ وَيَعمَلْ كُلَّ ما أمَرَهُ اللهُ بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ابْنُوا المَسْكَنَ المُقَدَّسَ وَغِطاءَهُ وَالغِطاءَ الَّذِي فَوقَهُما، وَمَشابِكَهُما وَألواحَهُما وَقُضبانَهُما وَأعمِدَتَهُما وَقَواعِدَ أعمِدَتِهِما، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","وَصُندُوقَ العَهدِ وَعَصَوَيهِ وَغِطاءَهُ وَسِتارَ قُدسِ الأقداسِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","وَالمائِدَةَ وَعَصَوَيها وَأدَواتِها وَخُبزَ حَضْرَةِ اللهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","وَالمَنارَةَ لِلإضاءَةِ وَأدَواتِها وَسُرُجِها وَزَيتَ الإنارَةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","وَمَذْبَحَ البَخُورِ وَعَصَوَيهِ، وَزَيتَ المَسحَةِ وَالبَخُورَ الطَّيِّبَ، وَسِتارَ مَدْخَلِ المَسْكَنِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","وَمَذبَحَ الذَّبائِحِ الصّاعِدَةِ وَالشَّبَكَةَ البُرونْزِيَّةَ الَّتِي لِلمَذبَحِ، وَعَصَوَي المَذْبَحِ وَأدَواتِهِ، وَحَوضَ الاغتِسالِ وَقاعِدَتَهُ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","وَسَتائِرَ السّاحَةِ وَأعمِدَتَها وَقَواعِدَ أعمِدَتِها، وَسِتارَ مَدخَلِ السّاحَةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","وَأوتادَ المَسْكَنِ وَأوتادَ السّاحَةِ وَحِبالِها، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","وَالثِّيابَ المَنسُوجَةَ لِلخِدمَةِ فِي المَسْكَنِ، وَالثِّيابَ المُقَدَّسَةَ لِهارُونَ الكاهِنِ وَأبْنائِهِ لِيَخدِمُوا كَكَهَنَةٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","حِينَئِذٍ، ذَهَبَ كُلُّ بَنِي إسْرائِيلَ مِنْ أمامِ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","وَجاءَ كُلُّ مَنْ نَبَّهَهُ قَلبُهُ وَدَفَعَتْهُ رُوحُهُ، وَأحضَرُوا تَقدِمَةً للهِ لِأجلِ صُنْعِ خَيمَةِ الاجْتِماعِ، وَجَمِيعَ أدَواتِ خِدمَتِها، وَعَمَلِ الثِّيابِ المُقَدَّسَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","فأتَى الرِّجالُ وَالنِّساءُ بِحَسَبِ سَخاءِ قُلُوبِهِمْ، وَأحْضَروا أساوِرَ وَأقراطاً وَخَواتِمَ وَأنواعاً أُخْرَى مِنْ حُلِيِّ الذَّهَبِ. فَقَدَّمُوا جَميعَ تَقدِماتِ الذَّهَبِ هَذِهِ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","وَكُلُّ مَنْ لَدَيهِ أقمِشَةٌ زَرقاءُ وَبَنَفسَجِيَّةٌ وَحَمراءُ وَكِتّانٌ وَشَعرُ ماعِزٍ وَجُلُودُ كِباشٍ مَدبُوغَةٌ وَجُلُودُ تُيُوسٍ، أحضَرَها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","وَكُلُّ مَنْ أرادَ أنْ يُحضِرَ تَقدِمَةً مِنْ فِضَّةٍ وَنُحاسٍ أحضَرَها كَتَقدِمَةٍ للهِ. وَكُلُّ مَنْ لَدَيهِ خَشَبُ سَنطٍ صالِحٌ لِلاستِعْمالِ فِي أيِّ عَمَلٍ، أحضَرَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","وَكُلُّ امْرأةٍ ماهِرَةٍ غَزَلَتْ بِيَدِها، وَأحضَرَتْ ما غَزَلَتْهُ: أقمِشَةً زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّاناً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","وَكُلُّ النِّساءِ اللَّواتِي دَفَعَتْهُنَّ قُلُوبُهُنَّ، وَكانَتْ لَدَيهُنَّ مَهارَةٌ، غَزَلْنَ شَعرَ ماعِزَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","وَأحضَرَ القادَةُ حِجارَةَ جَزْعٍ وَأحجاراً كَرِيمَةً أُخْرَى لِلتَّرصِيعِ عَلَى الثَّوبِ الكَهَنُوتِيِّ وَالصُّدْرَةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","وَأعطاراً وَزَيتاً لِلإنارَةِ وَلِزَيتِ المَسْحَةِ وَلِلبَخُورِ الطَّيِّبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","وَقَدَّمَ جَميعُ الرِّجالِ وَالنِّساءِ الَّذِينَ دَفَعَتْهُمْ قُلُوبُهُمْ تَقدِماتٍ اختِيارِيَّةً للهِ، بِحَسَبِ ما أمَرَ اللهُ مُوسَى بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","وَقالَ مُوسَى لِبَنِي إسْرائِيلَ: «ها إنَّ اللهَ اختارَ بَصَلْئِيلَ بْنَ أُورِي بْنِ حُورَ مِنْ قَبِيلَةِ يَهُوذا ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","وَمَلأهُ بِرُوحٍ اللهِ مَهارَةً وَفَهماً وَمَعرِفَةً وَقُدراتٍ كَبِيرَةً ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","فِي عَمَلِ تَصامِيمَ الذَّهَبِ وَالفِضَّةِ وَالبُرونْزِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","وَفِي النَّقشِ عَلَى الحِجارَةِ الكَرِيمَةِ لِلتَّرصِيعِ، وَفِي زَخرَفَةِ الخَشَبِ، وَجَميعِ أنواعِ المَهاراتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","وَأعطَى بَصَلْئِيلَ وَأُهُولِيآبَ بْنَ أخِيساماكَ مِنْ قَبِيلَةِ دانَ، المَهارَةَ فِي تَعلِيمِ الآخَرِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","وَمَلأهُما بِالمَهارَةِ لِلقِيامِ بِكُلِّ الأعمالِ الحِرَفِيَّةِ وَالتَّصْميمِ وَالتَطْريزِ، فِي الأنْسِجَةِ الزَّرقاءِ وَالبَنَفسَجِيَّةِ وَالحَمراءِ وَالكِتّانِ، وَبِأعمالِ النَّسْجِ، لِيَقُومُوا بِكُلِّ الأعمالِ وَالتَّصامِيمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«فَليَعمَلْ بَصَلْئِيلُ وَأُهُولِيآبُ، وَكُلُّ ماهِرٍ أعطاهُ اللهُ المَهارَةَ وَالذَّكاءَ، فِي بِناءِ المَكانِ المُقَدَّسِ بِحَسَبِ كُلِّ ما أمَرَ اللهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","فَدَعا مُوسَى بَصَلْئِيلَ وَأُهُولِيآبَ وَكُلَّ ماهِرٍ أعطاهُ اللهُ المَهارَةَ، وَكُلَّ مَنْ حَثَّهُ قَلبُهُ عَلَى المَجِيءٍ لِلعَمَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","وَأخَذُوا مِنْ مُوسَى جَمِيعَ التَّقدِمَةِ الَّتِي أحضَرَها الشَّعبِ لِأجلِ خِدمَةِ المَكَانِ المُقَدَّسِ. وَكانُوا ما يَزالُونَ يُحضِرُونَ تَقدِماتٍ فِي كُلِّ صَباحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","وَأتَى كُلُّ المَهَرَةِ الَّذِينَ كانُوا يَقُومُونَ بِعَمَلِ المَكانِ المُقَدَّسِ، كُلُّ واحِدٍ بِحَسَبِ عَمَلِهِ الَّذِي كانَ يَقُومُ بِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","وَقالُوا لِمُوسَى: «إنَّ الشَّعبَ يُحضِرُونَ أكثَرَ مِنْ حاجَةِ العَمَلِ الَّذِي أمَرَ اللهُ بِعَمَلِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","حِينَئِذٍ، أمَرَ مُوسَى بِأنْ يُعلِنُوا فِي المُخَيَّمِ أنَّ عَلَى الرِّجالِ وَالنِّساءِ أنْ لا يُحْضِرُوا شَيئاً بَعْدُ لِتَقدِمَةِ المَكانِ المُقَدَّسِ. فَتَوَقَّفَ النّاسُ عَنْ إحضارِ المَزِيدِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","وَكانَوا قَدْ أحضَرُوا أكثَرَ مِنْ حاجَةِ العَمَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","فَصَنَعَ جَمِيعُ العامِلِينَ المَهَرَةِ المَسْكَنَ المُقَدَّسَ مِنْ عَشَرِ سَتائِرٍ مِنْ كِتّانٍ ناعِمٍ مَبْرُومٍ، وَأقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ مُطَرِّزةٍ بِمَهارَةٍ عَلَى شَكلِ مَلائِكَةِ الكَرُوبِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","وَكانَ طُولُ كُلِّ سِتارَةٍ ثَمانٍ وَعِشْرُينَ ذِراعاً، وَعَرْضُها أربَعَ أذرُعٍ. فَلِجَمِيعِ السَتائِرِ مَقايِيسُ مُتَساوِيَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","وَوَصَلَ السَّتائِرَ الخَمْسَ الأولَى مَعاً، وَالخَمْسَ الثّانِيَةَ مَعاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ثُمَّ صَنَعَ عُرَىً مِنْ قُماشٍ أزرَقَ عَلَى حافَّةِ سَتائِرِ المَجْمُوعَةِ الأولَى، وَكَذَلِكَ عَلَى حافَّةِ سَتائِرِ المَجْمُوعَةِ الثَّانِيَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","فَصَنَعَ خَمسِينَ عُروَةً عَلَى السِّتارَةِ الأُولَى، وَخَمْسِينَ عُروَةً عَلَى سِتارَةِ المَجمُوعَةِ الثّانِيَةِ. وَكَانَتِ العُرَى مُتَقابِلَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","وَصَنَعَ خَمسِينَ مِشبَكاً مِنَ الذَّهَبِ لِوَصلِ السَّتائِرَ مَعاً بِالمَشابِكِ. فَصارَ المَسْكَنُ مُتَّصِلاً كَقِطْعَةٍ واحِدَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","وَصَنَعَ سَتائِرَ مِنْ شَعرِ الماعِزِ لِلغِطاءِ الَّذِي فَوقَ المَسْكَنِ، عَدَدُها إحدَى عَشْرَةَ سِتارَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","طُولُ كُلُّ سِتارَةٍ ثَلاثُونَ ذِراعاً وَعَرضُها أرْبَعُ أذْرُعَ. فَكانَتِ لِلسَّتائِرِ الإحدَى عَشْرَةَ مَقايِيسُ مُتَساوِيَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","فَوَصَلَ خَمسَ سَتائِرَ مَعاً، وَسِتَّ سَتائِرَ مَعاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","وَصَنَعَ خَمسِينَ عُروَةً عَلَى حافَّةِ أقصَى سِتارَةٍ عَلَى طَرَفِ المَجمُوعَةِ الأُولَى، وَخَمْسِينَ عُروَةً عَلَى حافَّةِ السِّتارَةِ الَّتِي سَتُوصَلُ بِها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","وَصَنَعَ خَمسِينَ مِشبَكاً مِنْ بُرونْزٍ لِيَصِلَ الخَيمَةَ فَتَصيرَ قِطْعَةً واحِدَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","وَصَنَعَ غِطاءً لِلْخَيمَةِ مِنْ جِلدِ الكِباشِ المَدبُوغِ، وَغِطاءً آخَرَ خارِجِيّاً مِنَ الجِلدِ الفاخِرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","وَصَنَعَ ألواحاً قائِمَةً مِنْ خَشَبِ السَّنطِ لِلمَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","طُولُ كُلِّ لَوحٍ عَشْرُ أذْرُعٍ، وَعَرضُهُ ذِراعٌ وَنِصْفٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","وَكانَ لِجَمِيعِ ألواحِ المَسْكَنِ فَتحَتانِ لِوَصلِ أحَدِها بِالآخَرِ. هَكَذا صَنَعَ جَمِيعَ ألواحِ المَسْكَنِ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","صَنَعَ عِشرِينَ لَوحاً لِلجِهَةِ الجَنُوبِيَّةِ مِنَ الخَيْمَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","وَصَنَعَ أربَعِينَ قاعِدَةً مِنْ فِضَّةٍ تَحتَ الألْواحِ العِشرِينَ: قاعِدَتَينِ لِفُتحَتَيِّ كُلِّ لَوْحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","وَصَنَعَ عِشرِينَ لَوحاً لِلجِهَةِ الشَّمالِيَّةِ مِنَ المَسْكَنِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","وَتَحْتَها أربَعِينَ قاعِدَةً مِنْ فِضَّةٍ: قاعِدَتَينِ تَحتَ كُلِّ لَوحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","وَصَنَعَ لِظَهْرِ المَسْكَنِ مِنَ الغَربِ سِتَّةَ ألواحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","وَلَوحَينِ لِزاوِيَتَي المَسْكَنِ مِنَ الخَلْفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","فَكانَ اللَوحانِ مُنفَصِلَينِ مِنَ الأسفَلِ، مُتَّصِلَينِ فِي الأعلَى داخِلَ الحَلَقَةِ الأُولَى. هَكَذا كانَ اللَّوحانِ عَلى الزّاوِيَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","فَكانَ المَجْمُوعُ ثَمانِيَةَ ألواحٍ، لَها سِتَّ عَشْرَةَ قاعِدَةً: قاعِدَتَينِ تَحْتَ كُلِّ لَوحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","وَصَنَعَ عَوارِضَ مِنْ خَشَبِ السَّنطِ، خَمسَ عَوارِضَ لِجِهَةٍ مِنْ جِهاتِ المَسْكَنِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","وَخَمسَ عَوارِضَ لِلجِهَةِ الثَّانِيَةِ، وَخَمسَ عَوارِضَ لِظَهْرِ المَسْكَنِ مِنَ الغَربِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","وَوَصَلَ العارِضَةَ الوُسطَى لِتَمْتَدَّ بَينَ الألواحِ مِنَ الطَّرَفِ الأوَّلِ إلَى الطَّرَفِ الآخَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ثُمَّ غَشَّى جَمِيعَ الألواحِ بِالذَّهَبِ، وَصَنَعَ لَها حَلَقاتٍ مِنْ ذَهَبٍ كَبُيُوتٍ لِلعَوارِضِ. وَكَذَلِكَ غَشَّى العَوارِضَ بِالذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","وَصَنَعَ سِتارةً مِنْ أقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ مَبْرُومٍ مُطَرَّزةٍ بِمَهارَةٍ عَلَى شَكلِ مَلائِكَةِ الكَرُوبِيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","وَعَلَّقَها عَلَى أربَعَةِ أعمِدَةٍ مَصنُوعَةٍ مِنْ خَشَبِ السَّنطِ مُغَشَّاةٍ بِالذَّهَبِ وَلَها مَشابِكُ مِنْ ذَهَبٍ، تَقِفُ عَلَى أربَعِ قَواعِدَ مِنْ فِضَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","وَصَنَعَ سِتارةً مُزَخرَفَةً مِنْ أقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ مَبْرُومٍ، لِأجلِ مَدْخَلِ الخَيمَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","وَصَنَعَ لِلسِّتارَةِ خَمسَةَ أعمِدَةٍ وَغَشّاها بِالذَّهَبِ، وَصَنَعَ لَها مَشابِكَ مِنْ ذَهَبٍ، وَخَمسَ قَواعِدَ مِنْ بُرونْزٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","وَصَنَعَ بَصَلْئِيلُ صُندُوقَ العَهدِ مِنْ خَشَبِ السَّنطِ. طُولُهُ ذِراعانِ وَنِصْفٌ، وَعَرضُهُ ذِراعٌ وَنِصْفٌ، وَارتِفاعُهُ ذِراعٌ وَنِصْفُ الذِّراعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","وَغَشّاهُ بِالذَّهَبِ النَّقِيِّ مِنَ الدّاخِلِ وَمِنَ الخارِجِ، وَصَنَعَ لَهُ إطاراً مِنْ حَولِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","وَسَبَكَ أربَعَ حَلَقاتٍ مِنَ الذَّهَبِ وَضَعَها عَلَى زَواياهُ الأربَعِ: حَلَقَتَينِ عَلَى كُلِّ جانِبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","وَصَنَعَ عَصَوَينِ مِنْ خَشَبِ السَّنطِ وَغَشّاهُما بِالذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","وَوَضَعَ العَصَوَينِ فِي الحَلَقاتِ عَلَى جانِبَيِّ الصُّندُوقِ لِحَملِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","وَصَنَعَ غِطاءً مِنْ ذَهَبٍ نَقِيٍّ، طُولُهُ ذِراعانِ وَنِصْفٌ، وَعَرضُهُ ذِراعٌ وَنِصْفُ الذِّراعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","وَصَنَعَ كَرُوبَينِ مِنْ ذَهَبٍ مَطرُوقٍ عَلَى طَرَفَيِّ الغَطاءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","فَكانَ كَرُوبٌ عَلَى كُلِّ طَرَفٍ. وَصَنَعَ الكَرُوبَينِ مِنْ قِطعَةٍ واحِدَةٍ مَعَ الغَطاءِ عَلَى طَرَفَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","فَكانَ الكَرُوبانِ باسِطَيْنِ أجنِحَتَهُما إلَى الأعلَى يُظَلِّلانِ الغِطاءَ. كانَ الكَرُوبانِ مُتَقابِلَينِ، وَوَجْهاهُما نَحوَ الغِطاءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","وَصَنَعَ مائِدَةً مِنْ خَشَبِ السَّنطِ، طُولُها ذِراعانِ، وَعَرضُها ذِراعٌ، وَارتِفاعُها ذِراعٌ وَنِصْفٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","وَغَشّاها بِذَهَبٍ نَقِيٍّ، وَصَنَعَ لَها إطاراً مِنَ الذَّهَبِ حَولَها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","وَصَنَعَ لَها حافَّةً عَرضُها شِبرٌ حَولَها، وَإطاراً مِنْ ذَهَبٍ لِحافَّتِها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","وَسَبَكَ لِلمائِدَةِ أربَعَ حَلَقاتٍ مِنْ ذَهَبٍ، وَثَبَّتَها عَلَى زَواياها الأرْبَعِ، عَلَى مُسْتَوَى أرْجُلِها الأربَعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","وَكانَتِ الحَلَقاتُ قَرِيبَةً مِنَ الحافَّةِ العُلْيا لإدخالِ العَصَوَينِ فِيها لِحَملِ المائِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","وَصَنَعَ عَصَوَينِ مِنْ خَشَبِ السَّنطِ وَغَشّاهُما بِالذَّهَبِ، لِحَملِ المائِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","وَصَنَعَ جَمِيعَ الآنِيَةِ الَّتِي تُوضَعُ عَلَى المائِدَةِ مِنَ الذَّهَبِ النَقِيِّ: أطْباقَها وَصُحُونَها، وَكَذَلِكَ طاساتِها وَأبارِيقَها المُخَصَّصَةِ لِلتَّقْدِماتِ السَّائِلَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","وَصَنَعَ المَنارَةَ مِنَ الذَّهَبِ النَّقِيِّ. وَقَدْ طُرِقَتْ قاعِدَةُ المَنارَةِ وَساقُها بِالمِطْرَقَةِ. وَكانَتْ كُؤُوسُها وَعُقَدُها وَوَرَقُها قِطعَةً واحِدَةً مَعَها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","وَتفَرَّعَتِ المَنارَةُ إلَى سِتِّ شُعَبٍ عَلَى جانِبَيها: ثَلاثِ شُعَبٍ عَنْ كُلِّ جانِبٍ مِنْ جانِبَي المَنارَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","وَسُبِكَتْ ثَلاثُ زَهْراتِ لَوْزٍ مَعَ عُقَدِها وَوَرَقِها عَلَى كُلِّ شُعْبَةٍ مِنَ الشُّعَبِ السِّتِّ المُتَفَرِّعَةِ مِنْ قاعِدَةِ المَنارَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","وَكَذَلِكَ أربَعُ زَهْراتِ لَوْزٍ مَعَ عُقَدِها وَوَرَقِها عَلَى ساقِ المَنارَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","مِنْها ثَلاثُ زَهْراتٍ مَعَ عُقَدِها تَقَعُ الواحِدَةُ مِنْها عِنْدَ التِقاءِ كُلِّ شُعْبَتَينِ مِنَ الشُّعَبِ السِّتِّ المُتَفَرِّعَةِ مِنَ السّاقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","فَكانَتْ عُقَدُ المَنارَةِ وَشُعَبُها قِطعَةً واحِدَةً مَعَها. وَجَمِيعُها مِنَ قِطْعَةٍ واحِدَةٍ مِنَ الذَّهَبِ النَّقِيِّ المَطرُوقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","وَصَنَعَ سُرُجَها السَّبعَةَ وَمَلاقِطَها وَمَنافِضَها مِنَ الذَّهَبِ النَّقِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","صَنَعَها مَعَ كُلِّ أدَواتِها مِنْ قِنطارٍ واحِدٍ مِنَ الذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","وَصَنَعَ مَذْبَحَ البَخُورِ مِنْ خَشَبِ السَّنطِ، قَاعِدَتُهُ مُرَبَّعَةٌ طُولُهُا ذِراعٌ وَعَرضُهُا ذِراعٌ. أمّا ارْتِفاعُ مَذْبَحِ البَخُورِ فَذِراعانِ. وَكانَتْ زَواياهُ البارِزَةَ قِطعَةً واحِدَةً مَعَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","وَغَشَّاهُ بِالذَّهَبِ النَقِيِّ. غَشَّى سَطحَهُ الأعلَى وَجَوانِبَهُ وَزَواياهُ البارِزَةَ. وَصَنَعَ إطاراً مِنْ ذَهَبٍ حَولَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","وَصَنَعَ حَلَقَتَينِ مِنْ ذَهَبٍ وَوَضَعَهُما تَحتَ حافَّتِهِ العُلْيا عَلَى الجِهَتَينِ المُقابِلَتَينِ لإدخالِ العَصَوَينِ فِيهِما لِحَملِهِ بِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","وَصَنَعَ العَصَوَينِ مِنْ خَشَبِ السَّنطِ، وغَشَّاهُما بِالذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","وَصَنَعَ زَيتَ المَسحَةِ المُقَدَّسَ وَالبَخُورَ الطَّيِّبَ، كَما يَصنَعُهُما العَطّارُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","وَصَنَعَ مَذبَحَ الذَّبائِحِ الصّاعِدَةِ مِنْ خَشَبِ السَّنطِ. قَاعِدَتُهُ مُرَبَّعَةٌ طُولُهُا خَمْسُ أذْرُعُ، وَعَرضُهُا خَمْسُ أذْرُعُ. أمّا ارْتِفاعُ المَذْبَحِ فَثَلاثُ أذْرُعٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","وَصَنَعَ لَهُ أربَعَ زَوايا بارِزَةٍ عَلَى جَوانِبِهِ الأربَعَةِ. وَكانَتِ الزَّوايا البارِزَةُ قِطعَةً واحِدَةً مَعَهُ. وَغَشّاها بِالبُرونْزِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","وَصَنَعَ جَمِيعَ أدَواتِ المَذبَحِ: القُدُورَ وَالمَجارِفَ وَالطّاساتِ وَالمَناشِلَ وَالمَجامِرَ وَجَمِيعَ أدَواتِ المَذْبَحِ مِنْ بُرونْزٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","وَصَنَعَ شَبَكَةً مِنْ بُرونْزٍ لِلمَذبَحِ، وَوَضَعَها عَلَى ارتِفاعِ مُنتَصَفِ المَذبَحِ مِنَ الدّاخِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","وَسَبَكَ أربَعَ حَلَقاتٍ عَلَى زَوايا الشَّبَكَةِ لِوَضعِ العَصَوَينِ فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","وَصَنَعَ العَصَوَينِ مِنْ خَشَبِ السَّنطِ وَغَشّاهُما بِالبُرونْزِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","وَأدْخَلَ العَصَوَينِ فِي الحَلَقاتِ عَلَى جانِبَيِّ المَذبَحِ لِحَملِهِ بِهِما. صَنَعَ المَذْبَحَ مُجَوَّفاً وَلَهُ ألواحٌ عَلَى جَوانِبِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","وَصَنَعَ الحَوضَ البُرونْزِيَّ وَقاعِدَتَهُ البُرونْزِيَّةَ بِاستِخدامِ مَرايا النِّساءِ اللَّواتِي خَدَمْنَ عِندَ بابِ ساحَةِ المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","وَسَيَّجَ ساحَةَ المَسْكَنِ. فَصَنَعَ لِلجِهَةِ الجَنُوبِيَّةِ سَتائِرَ مِنْ كِتّانٍ مَبْرُومٍ طُولُها مِئَةُ ذِراعٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","وَلَها عِشرُونَ عَمُوداً بِقَواعِدِها العِشرِينَ المَصنُوعَةِ مِنَ البُرونْزِ، وَمَشابِكَ الأعمِدَةِ وَحَلَقاتِها المَصنُوعَةِ مِنَ الفِضَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","وَلِلجِهَةِ الشَّمالِيَّةِ مِئَةُ ذِراعٍ مِنَ السَتائِرِ، لَها عِشرُونَ عَمُوداً بِقَواعِدِها العِشرِينَ المَصنُوعَةِ مِنْ بُرونْزٍ. وَمَشابِكَ الأعمِدَةِ وَحَلَقاتِها مَصنُوعَةٌ مِنْ فِضَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","وَلِلجِهَةِ الغَربيَّةِ خَمسُونَ ذِراعاً مِنَ السَتائِرِ، وَلَها عَشْرَةُ أعْمِدَةٍ بِقَواعِدِها العَشْرِ. وَمَشابِكَ الأعمِدَةِ وَحَلَقاتِها مَصنُوعَةٌ مِنَ الفِضَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","وَلِلجِهَةِ الأمامِيَّةِ الشَّرقِيَّةِ خَمسُونَ ذِراعاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","وَلَها سَتائِرُ بِطُولِ خَمْسَ عَشْرَةَ ذِراعاً عَلَى أحَدِ جَانِبَي المَدْخَلِ، وَلَها ثَلاثَةُ أعمِدَةٍ وَثَلاثُ قَواعِدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","وَخَمسَ عَشْرَةَ ذِراعاً مِنَ السَّتائِرِ عَلَى الجانِبِ الثّانِي. وَلَها ثَلاثَةُ أعمِدَةٍ وَثَلاثُ قَواعِدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","وَكانَتْ كُلُّ السَّتائِرِ الَّتِي حَولَ السّاحَةِ مَصنُوعَةً مِنْ كِتّانٍ مَبْرُومٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","كانَتْ قَواعِدُ الأعمِدَةِ مِنْ بْرُونزٍ، وَمَشابِكُ الأعمِدَةِ وَحَلَقاتُها مِنْ فِضَّةٍ، وَرُؤُوسُها مُغَشّاةٌ بِالفِضَّةِ. وَكانَتْ كُلُّ أعمِدَةِ السّاحَةِ مُتَّصِلَةً مَعاً بِقُضبانٍ مِنْ فِضَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","وَصُنِعَتْ سِتارَةُ مَدخَلِ السّاحَةِ مِنْ أقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ مَبْرُومٍ، طُولُها عِشْرُونَ ذِراعاً وَارْتِفاعُها خَمْسُ أذْرُعٍ، أيْ عَلَى ارتِفاعِ سَتائِرِ السّاحَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","وَكانَ لَها أربَعَةُ أعمِدَةٍ مِنْ بُرونْزٍ، وَلَها قَواعِدُ مِنْ بُرونْزٍ. وَأمّا مَشابِكُها فَمِنْ فِضَّةٍ، وَرُؤُوسُها وَحَلَقاتُها مُغَشّاةٌ بِالفِضَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","وَكُلُّ أوتادِ المَسْكَنِ وَالسّاحَةِ مِنْ بُرونْزٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","فَهَذِهِ هِيَ مَقادِيرُ المَوادِّ المُستَخدَمَةِ فِي صُنعِ مَسْكَنِ العَهْدِ. تَمَّ حِسابُها بِأمرٍ مِنْ مُوسَى. وَأشْرَفَ عَلَى ذَلِكَ الَّلاوِيُّونَ تَحتَ تَوجِيهِ إيثامارَ بْنِ هارُونَ الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","فَعَمِلَ بَصَلْئِيلُ بْنُ أورِي بْنُ حُورَ، الَّذِي مِنْ قَبِيلَةِ يَهُوذا، جَمِيعَ ما أمَرَ اللهُ مُوسَى بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","وَكانَ مَعَهُ أُهُولِيآبَ بْنِ أخِيساماكَ، الَّذِي مِنْ قَبِيلَةِ دانَ، حِرَفِيّاً وَمُصَمِّماً وَمُزَخْرِفاً فِي الأقمِشَةِ الزَّرقاءِ وَالبَنَفسَجِيَّةِ وَالحَمراءِ وَالكِتّانِ الأبْيَضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","وَكانَ وَزنُ الذَّهَبِ الَّذِي قَدَّمَهُ النَّاسُ لِصُنعِ المَكانِ المُقَدَّسِ، نَحْوَ تِسْعٍ وَعُشْرينَ قِنْطاراً، وَسَبْعِ مِئِةٍ وَثَلاثينَ مِثْقالاً بِحَسَبِ المَقاييسِ الرَّسْمِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","أمّا الفِضَّةُ الَّتِي تَمَّ جَمعُها مِنَ المَعدُودِينَ فَكانَتْ مِئَةَ قِنْطارٍ وَألْفٍ وَسَبْعِ مِئَةٍ وَخَمْسَةٍ وَسَبْعينَ مِثْقالاً بِحَسَبِ المَقاييسِ الرَّسْمِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","فَجَمَعُوا نِصْفَ مِثْقالٍ، بِحَسَبِ الوَزْنِ الرَّسْمِيِّ، مِنْ كُلِّ واحِدٍ تَمَّ تَسجِيلُهُ مِمَّنْ بَلَغَ العِشرِينَ فَما فَوقُ. فَكانَ عَدَدُهُمْ سِتِّ مِئَةٍ ألْفٍ وَثَلاثَةَ آلافٍ وَخَمسَ مِئَةٍ وَخَمْسِينَ رَجُلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","وَقَدِ استُخدَمُوا مِئَةُ قِنْطارٍ لِسَبكِ قَواعِدِ المَكانِ المُقَدَّسِ وَقَواعِدِ الحِجابِ الدّاخِلِيِّ. مِئَةَ قِنْطارٍ لِسَبكِ مِئَةِ قاعِدَةٍ. فَلِكُلِّ قَاعِدَةٍ قِنْطارٌ واحِدٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","وَبِألْفٍ وَسَبْعِ مِئَةٍ وَخَمْسَةٍ وَسَبْعينَ مِثْقالاً صَنَعَ مَشابِكَ الأعمِدَةِ، وَالحَلَقاتِ، وَغَطَّى بِها رُؤُوسَ الأعمِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","أمّا وَزنُ البُرونْزِ المُقَدَّمِ فَكَانَ سَبعينَ قِنْطاراً، وَألفاً وَأرْبَعِ مِئَةِ مِثْقالٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","صَنَعَ مِنْهُ قَواعِدَ مَدْخَلِ خَيمَةِ الاجْتِماعِ، وَالمَذبَحِ البُرونْزِيِّ وَشَبَكَتِهِ البُرونْزِيَّةِ الَّتِي عَلَيهِ، وَجَمِيعَ أدَواتِ المَذبَحِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","وَقَواعِدِ ألواحِ السّاحَةِ، وَقَواعِدِ مَدخَلِ السّاحَةِ، وَجَمِيعَ أوتادِ المَسْكَنِ وَالسّاحَةِ مِنْ حَولِها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","وَمِنَ الأقمِشَةِ الزَّرقاءِ وَالبَنَفسَجِيَّةِ وَالحَمراءِ صَنَعُوا ثِياباً مَنسُوجَةً لِلخِدمَةِ فِي المَكانِ المُقَدَّسِ، وَصَنَعُوا الثِّيابَ المُقَدَسَةَ الَّتِي لِهارُونَ كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","وَصَنَعَ بَصَلْئِيلُ الثَّوبَ الكَهَنُوتِيَّ مِنْ ذَهَبٍ وَأقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ مَبْرُومٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","فَطَرَقُوا الذَّهَبَ وَجَعَلُوهُ صَفائِحَ ثُمَّ قَطَّعُوها إلَى خُيُوطٍ لِوَضعِها فِي الأقمِشَةِ الزَّرقاءِ وَالبَنَفسَجِيَّةِ وَالحَمراءِ وَالكِتّانِ بِتَصامِيمَ ماهِرَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","وَصَنَعُوا لِلثُوبِ الكَهَنوتِيِّ كَتِفَينِ مُتَّصِلَينِ عِندَ نِهايَتِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","وَصَنَعُوا الحِزامَ مِنْ نَفْسِ المَوادِّ المُسْتَخْدَمَةِ لِلثُوبِ، أي مِنَ الذَّهَبِ وَأقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ مَبْرُومٍ كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ثُمَّ وَضَعُوا حَجَرَيِّ الجَزْعِ فِي إطارَينِ مِنْ ذَهَبٍ. وَكانَتْ أسْماءُ أبناءِ إسْرائِيلَ مَحفُورَةً عَلَى حَجَرَيِّ الجَزْعِ كَنَقشِ الخاتَمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","وَوَضَعَهُما عَلَى كَتِفَيِّ الثَّوبِ الكَهَنُوتِيِّ كَحَجَرَي تَذكارٍ لِبَنِي إسْرائِيلَ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","وَصَنَعَ الصُّدرَةَ خَيَّاطٌ ماهِرٌ كَما صُنِعَ الثَّوبُ الكَهَنُوتِيُّ. صُنِعَتْ مِنْ ذَهَبٍ وَأنْسِجَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ نَقِيٍّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","وَقَدْ صُنِعَتْ مُرَبَّعَةً وَمَثنِيَّةً، طُولُها شِبرٌ وَعَرضُها شِبرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","وَرُصِفَتْ بِأربَعَةِ صُفُوفٍ مِنَ الحِجارَةِ كَرِيمَةِ: فِي الصَّفِّ الأوَّلِ عَقِيقٌ أحمَرُ وَياقُوتٌ أصفَرُ وَزُمُرُّدُ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","وَفِي الصَّفِّ الثّانِي فَيرُوزٌ وَياقُوتٌ أزرَقُ وَعَقِيقٌ أبْيَضُ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","وَفِي الصَّفِّ الثّالِثِ عَينُ الهِرِّ وَيَشْمُ وَجَمشَتُ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","وَفِي الصَّفِّ الرّابِعِ زَبَرْجَدٌ وَجَزْعٌ وَيَشْبٌ. وُضِعَتْ جَمِيعاً فِي أُطُرٍ مِنْ ذَهَبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","كانَ هُناكَ اثْنا عَشَرَ حَجَراً تُمَثِّلُ أسْماءَ أبناءِ إسْرائِيلَ. وَحُفِرَ عَلَى كُلِّ حَجَرٍ اسْمُ إحْدَى القَبائِلِ الاثنَتَي عَشْرَةَ، كَما يُحفَرُ الاسْمُ عَلَى الخاتَمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","وَصَنَعُوا لِلصُّدرَةِ سَلاسِلَ مِنْ ذَهَبٍ نَقِيٍّ مَجْدُولٍ كَالحَبلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","وَصَنَعُوا إطارَينِ وَحَلَقَتَينِ مِنْ ذَهَبٍ، وَوَضَعُوا الحَلَقَتَينِ عَلَى طَرَفَيِّ الصُّدرَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","وَأدخَلُوا سِلسِلَتَيِّ الذَّهَبِ فِي الحَلَقَتَينِ اللَّتَينِ عَلَى طَرَفَيِّ الصُّدرَةِ مِنَ الخَارِجِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","وَوَصَلُوا الطَّرَفَينِ الآخَرَينِ لِلسِّلسِلَتَينِ بِالإطارَينِ. فَثَبَتا عَلَى كَتِفَيِّ الثَّوبِ الكَهَنُوتِيِّ مِنَ الأمامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","وَصَنَعُوا حَلَقَتَينِ أُخرَيينِ مِنَ الذَّهَبِ، وَوَضَعُوهُما عَلَى طَرَفَي الصُّدرَةِ الآخَرَينِ، أي عَلَى الجانِبِ الدّاخِلِيِّ المُلاصِقِ لِلثَّوبِ الكَهَنُوتِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","وَصَنَعُوا حَلَقَتَينِ أُخْرَيينِ مِنَ الذَّهَبِ، وَوَضَعُوهُما أسْفَلَ الكَتِفَينِ فِي مُقَدِّمَةِ الثُّوبِ الكَهَنوتِيِّ، فَوقَ الحِزامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","وَرَبَطُوا حَلَقاتِ الصُّدرَةِ بِحَلَقاتِ الثَّوبِ الكَهَنُوتِيِّ بِخَيطٍ أزرَقَ. وَهَكَذا بَقِيَتْ صُدْرَةُ القَضاءِ قَرِيبَةً مِنْ حِزامِ الثَّوبِ الكَهَنُوتِيِّ، مُلتَصِقَةً بِالثَّوبِ الكَهَنُوتِيِّ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","وَصَنَعَ جُبَّةَ الثَّوبِ الكَهَنُوتِيِّ كُلَّها مِنْ صُوفٍ أزرَقَ مَنْسُوجٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","وَكانَتْ فُتْحَةُ الجُبَّةِ في وَسَطِها كَفُتْحَةِ الدِّرعِ. وَلِلفُتْحَةِ حافَّةٌ حَولَها كَي لا تَتَمَزَّقَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","وَصَنَعُوا أشكالَ رُمّاناتٍ مِنْ أقمِشَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ وَكِتّانٍ أبْيَضَ وَوَضَعُوها عَلَى الأطرافِ السُّفلَى لِلجُبَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","كَما صَنَعُوا أجراساً مِنْ ذَهَبٍ نَقِيٍّ وَوَضَعُوها عَلَى أطرافِ الجُبَّةِ وَسَطَ الرُّمّاناتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","فَوَضَعُوا جَرَساً بَينَ كُلِّ رُمّانَتَينِ عَلَى امتِدادِ حافَّةِ الجُبَّةِ الَّتِي يَلبَسُها الكاهِنُ أثناءَ الخِدمَةِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","وَصَنَعُوا أثواباً مَنسُوجَةً مِنْ كِتّانٍ لِهارُونَ وَأبْنائِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","وَصَنَعُوا العِمامَةَ مِنْ كِتّانٍ مَبْرُومٍ، وَأغْطِيَةَ الرّأسِ مِنْ كِتّانٍ مَبْرُومٍ، وَالمَلابِسَ الدَّاخِليَّةِ مِنْ كِتّانٍ مَبْرُومٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","وَالحِزامَ مِنْ كِتّانٍ مَبْرُومٍ مِنْ أنْسِجَةٍ زَرقاءَ وَبَنَفسَجِيَّةٍ وَحَمراءَ مُزَخرَفَةٍ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","وَصَنَعُوا الشِّعارَ الَّذِي فِي مُقَدَّمَةِ الإكلِيلِ المُقَدَّسِ مِنْ ذَهَبٍ نَقِيٍّ. وَنَقَشُوا فَوقَهُ كَما يُنْقَشُ عَلَى الخاتَمِ: «مُخَصَّصٌ لِيهوه.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","وَرَبَطُوا بِها خَيطاً أزرَقَ لِوَضعِها عَلَى العِمامَةِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","وَاكتَمَلَ كُلُّ العَمَلِ فِي مَسْكَنِ خَيمَةِ الاجْتِماعِ، وَعَمِلَ بَنو إسْرائِيلَ بِحَسَبِ ما أمَرَ اللهُ مُوسَى بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","بَعْدَ ذَلِكَ اسْتَدْعَوا مُوسَى لِيَرَى المَسْكَنَ المُقَدَّسَ وَكُلَّ ما فِيهِ. فَرأى مُوسَى الخَيمَةَ مَعَ غِطائِها وَأدَواتِها وَمَشابِكِها وَألواحِها وَعَوارِضِها وَأعمِدَتِها وَقَواعِدِها، ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","وَغِطاءِ جُلُودِ الكِباشِ المَدبُوغَةِ وَغِطاءِ جُلُودِ التُّيُوسِ، وَالسِّتارَةِ الدّاخِلِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","وَرأى صُندُوقِ لَوحَيِّ الشَّهادَةِ وَعَصَوَيهِ وَغِطاءَ الصُّندُوقِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","وَالمائِدَةَ وَكُلَّ أدَواتِها وَخُبزَ حَضْرَةِ اللهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","وَمَنارَةَ الذَّهَبِ وَسُرُجَها، الَّتِي وُضِعَتْ فِي صَفٍّ واحِدٍ، وَأدَواتِها، وَزَيتَ الإنارَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","وَرأى مَذبَحَ الذَّهَبِ وَزَيتَ المِسحَةِ وَالبَخُورَ الطَّيِّبَ وَسِتارَ مَدخَلِ الخَيمَةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","وَمَذبَحَ البُرونْزِ وَشَبَكَتِهِ البُرونْزِيَّةَ وَأدَواتِهِ، وَحَوضَ الاغتِسالِ وَقاعِدَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","وَرأى مُوسَى سَتائِرَ السّاحَةِ وَأعمِدَتِها وَقَواعِدَ أعْمِدَتِها وَسِتارَةَ مَدْخَلِ السّاحَةِ وَحِبالَها وَأوتادَها، وَكُلَّ الأدَواتِ المُستَخدَمَةِ لِلخِدمَةِ فِي المَسْكَنِ المُقَدَّسِ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","وَرأى الثِّيابَ المَنسُوجَةَ لِلخِدمَةِ فِي المَكانِ المُقَدَّسِ، وَالثِّيابَ المُقَدَّسَةِ لِهارُونَ الكاهِنِ وَلأبْنائِهِ لِيَخدِمُوا كَكَهَنَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","وَعَمِلَ بَنو إسْرائِيلَ العَمَلَ بِحَسَبِ كُلِّ ما أمَرَ اللهُ مُوسَى بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","وَرَأى مُوسَى بِأنَّهُمْ أنجَزُوا كُلَّ العَمَلِ بِحَسَبِ أمْرِ اللهِ، فَبارَكَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«فِي اليَومِ الأوَّلِ مِنَ الشَّهرِ الأوَّلِ تُقيْمُ المَسْكَنِ المُقَدَّسَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ضَعْ فِيهِ صُندُوقَ لَوحَيِّ الشَّهادَةِ وَأخْفِهِ بِالسِّتارَةِ الدّاخِلِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ثُمَّ أدْخِلْ المائِدَةَ وَرَتِّبْ خُبزَ حَضْرَةِ اللهِ عَلَيها، وَأحْضِرْ المَنارَةَ وَأشْعِلْ سُرُجَها. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","وَضَعْ مَذْبَحَ البَخُورِ الذَّهَبِيَّ أمامَ صُندُوقِ العَهْدِ، وَالسِّتارَةَ عَلَى مَدْخَلِ المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","«ضَعْ مَذْبَحَ الذَّبيحَةِ الصَّاعِدَةِ أمامَ مَدْخَلِ المَسْكَنِ، أي مَدْخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","وَضَعْ حَوضَ الاغتِسالِ بَينَ خَيمَةِ الاجْتِماعِ وَالمَذبَحِ، مَملوءاً بِالماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ضَعْ سَتائِرَ السّاحَةِ حَولَ الخَيمَةِ، ثُمَّ ضَعْ سِتارَةَ مَدْخَلِ السّاحَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","وَخَذْ زَيتَ المَسحَةِ، وَامْسَحْ بِهِ المَسْكَنَ وَكُلَّ ما فِيهِ وَكُلَّ أثاثِهِ لِيَكُونَ مُخَصَّصاً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","وَامْسَحْ مَذبَحَ الذَّبائِحِ الصّاعِدَةِ وَكُلَّ أدَواتِهِ، وَكَرِّسِ المَذبَحَ، فَيَصيْرَ قُدسَ أقداسٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","وَامْسَحْ حَوضَ الاغتِسالِ وَقاعِدَتَهُ وَتُقَدِّسَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«ثُمَّ اسْتَدْعِ هارُونَ وَأبناءَهُ إلَى مَدْخَلِ خَيمَةِ الاجْتِماعِ وَاغْسِلْهُمْ بِالماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ألْبِسْ هارُونَ ثِياباً مُقَدَّسَةً، وَامْسَحْهُ وَكَرِّسْهُ لِيَخدِمَنِي كَكاهِنٍ لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","أحْضِرْ كَذَلِكَ أبْناءَهُ وَألبِسْهُمُ الثِّيابَ المُخَصَّصَةَ لَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","وَامْسَحْهُمْ كَما مَسَحتَ أباهُمْ لِيَخدِمُونِي كَكَهَنَةٍ لِي. فَسَتُؤَهِّلُهُمْ هَذِهِ المِسْحَةُ لِيَكونوا كَهَنَةً إلَى الأبَدِ فِي كُلِّ أجيالِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","فَعَمِلَ مُوسَى بِحَسَبِ ما أمَرَهُ اللهُ بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","وَفِي اليَومِ الأوَّلِ مِنَ الشَّهرِ الأوَّلِ فِي السَّنَةِ الثّانِيَةِ، أُقيمَ المَسْكَنُ المُقَدَّسُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","أقامَ مُوسَى المَسْكَنَ وَوَضَعَ قَواعِدَهُ وَألواحَهُ وَعَوارِضَهُ وَأعمِدَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","وَنَشَرَ مُوسَى الخَيمَةَ فَوقَ المَسْكَنِ. ثُمَّ وَضَعَ فَوقَهُ غِطاءَ جُلُودِ الكِباشِ المَدبُوغَةِ وَغِطاءِ جُلُودِ التُّيُوسِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","وَأخَذَ مُوسَى لَوحَيِّ الشَّهادَةِ وَوَضَعَهُما فِي الصُّندُوقِ. وَوَضَعَ العَصَوَينِ فِي حَلَقاتِ الصُّندُوقِ، وَوَضَعَ الغِطاءَ فَوقَ الصُّندُوقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","وَأحضَرَ مُوسَى الصُّندُوقَ إلَى المَسْكَنِ، وَوَضَعَ السِّتارَةَ الدّاخِلِيَّةَ، وَأخْفَى صُندُوقَ لَوحَيِّ الشَّهادَةِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","وَوَضَعَ مُوسَى المائِدَةَ فِي خَيمَةِ الاجْتِماعِ عَلَى الجِهَةِ الشَّمالِيَّةِ مِنَ المَسْكَنِ، خارِجَ السِّتارَةِ الدّاخِلِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","وَرَتَّبَ عَلَيها الخُبزَ فِي حَضرَةِ اللهِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","وَوَضَعَ مُوسَى المَنارَةَ فِي خَيمَةِ الاجْتِماعِ عَلَى الجِهَةِ الجَنُوبِيَّةِ مِنَ المَسْكَنِ مُقابِلَ المائِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","وَوَضَعَ السُّرُجَ فِي حَضرَةِ اللهِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","وَوَضَعَ المَذبَحَ الذَّهَبِيَّ فِي خَيمَةِ الاجْتِماعِ أمامَ السِّتارَةِ الدّاخِلِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","وَأحرَقَ بَخُوراً طَيِّباً، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","وَوَضَعَ السِّتارَةَ عَلَى مَدخَلِ المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","وَوَضَعَ مَذبَحَ الذَّبائِحِ الصّاعِدَةِ عِندَ مَدخَلِ مَسْكَنِ خَيمَةِ الاجْتِماعِ، وَقَدَّمَ عَلَيهِ الذَّبائِحَ الصّاعِدَةَ وَتَقدِماتِ الحُبُوبِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","وَوَضَعَ مُوسَى الحَوضَ بَينَ خَيمَةِ الاجْتِماعِ وَالمَذبَحِ، وَوَضَعَ فِيهِ ماءً لِلاغْتِسالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","وَكانَ مُوسَى وَهارُونُ وَأبناؤُهُ يَغسِلُونَ أيدِيَهِمْ وَأرجُلَهُمْ فِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","فَحِينَ كانُوا يَأْتُونَ إلَى خَيمَةِ الاجْتِماعِ وَيَقتَرِبُونَ إلَى المَذبَحِ، كانُوا يَغتَسِلُونَ كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","وَوَضَعَ مُوسَى سَتائِرَ السّاحَةِ حَولَ المَسْكَنِ وَالمَذبَحِ. وَوَضَعَ سِتارَةَ مَدْخَلِ السّاحَةِ. وَبِهَذا أكمَلَ مُوسَى كُلَّ العَمَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","وَغَطَّتِ السَّحابَةُ خَيمَةَ الاجْتِماعِ، وَمَلأ مَجدُ اللهِ المَسْكَنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","وَلَمْ يَستَطِعْ مُوسَى الدُّخُولَ إلَى خَيمَةِ الاجْتِماعِ لِأنَّ مَجدَ اللهِ مَلأ المَسْكَنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","وَفِي كُلِّ رِحلاتِ بَني إسْرائِيلَ، حِينَ كانَتِ السَّحابَةُ تَرتَفِعُ عَنِ المَسْكَنِ كانَ بَنو إسْرائِيلَ يَرتَحِلُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","فَإنْ لَمْ تَرتَفِعِ السَّحابَةُ، لَمْ يَكُونُوا يَرتَحِلُونَ إلَى أنْ تَرتَفِعَ. ");
INSERT INTO arbwbtc_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","لِأنَّ سَحابَةَ اللهِ كانَتْ فَوقَ المَسْكَنِ فِي النَّهارِ. وَكانَتِ النّارُ فِي السَّحابَةِ طَوالَ اللَّيلِ أمامَ عُيونِ جَمِيعِ بَيتِ إسْرائِيلَ فِي كُلِّ رِحلاتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","وَدَعا اللهُ مُوسَى وَتَكَلَّمَ إلَيهِ مِنْ خَيمَةِ الاجْتِماعِ فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«كَلِّمْ بَنِي إسْرائِيلَ وَقُلْ لَهُمْ: حِينَ يُقَدِّمُ أحَدُكُمْ تَقدِمَةً مِنَ الحَيواناتِ للهِ، فَلْيُقَدِّمْ مِنَ البَقَرِ أوْ الغَنَمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","«فَإنْ كانَتِ التَّقدِمَةُ ذَبيحَةً صاعِدَةً مِنَ البَقَرِ، فَلْتَكُنْ عِجلاً سَلِيماً مِنَ العُيُوبِ، وَلْيُقَدِّمْهُ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ لِيَكُونَ مَقبُولاً فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","عَلَى مَنْ يُقَدِّمُهُ أنْ يَضَعَ يَدَهُ عَلَى رَأسِ الحَيوانِ لِيَكُونَ مَقبُولاً لِلتَّكفِيرِ عَنْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","«يَنبَغِي أنْ تَذْبَحَ العِجلَ فِي حَضْرَةِ اللهِ. وَعَلَى أبناءِ هارُونَ، الكَهَنَةِ، أنْ يُقَدِّمُوا الدَّمَ للهِ، وَأنْ يَسكُبُوهُ عَلَى جَوانِبِ المَذبَحِ الَّذِي أمامَ مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ثُمَّ يَنبَغِي سَلخُ جِلدِ الذَّبيحَةِ الصّاعِدَةِ وَتَقطِيعُها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ثُمَّ يَضَعُ أبناءُ هارُونَ ناراً عَلَى المَذبَحِ، وَيُرَتِّبُونَ الخَشَبَ عَلَى النّارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","بَعْدَ ذَلِكَ يَضَعُ أبناءُ هارُونَ الكَهَنَةُ القِطَعَ وَالرَّأْسَ وَالشَّحمَ عَلَى الخَشَبِ الَّذِي عَلَى النّارِ الَّتِي عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ثُمَّ تُغْسَلُ أحشاءُ العِجلِ وَسِيقانُهُ بِالماءِ. وَيُحرِقُها الكاهِنُ جَمِيعاً عَلَى المَذبَحِ ذَبيحَةً صاعِدَةً، مُعَدَّةً بِالنّارِ كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«وَإنْ كانَتْ تَقدِمَتُهُ ذَبيحَةً صاعِدَةً مِنَ الغَنَمِ أوِ الماعِزِ، فَيَنبَغِي أنْ يُقَدِّمَ تَيساً سَلِيماً مِنَ العُيُوبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","يَذبَحُهُ فِي الجِهَةِ الشَّمالِيَّةِ مِنَ المَذبَحِ فِي حَضْرَةِ اللهِ. وَيَسْكُبُ أبناءِ هارُونَ دَمَهُ عَلَى جَوانِبِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ثُمَّ يُقَطِّعُهُ الكاهِنُ وَيُرَتِّبُ قِطَعَهُ وَرَأسَهُ وَشَحْمَهُ عَلَى الخَشَبِ الَّذِي عَلَى النّارِ الَّتِي عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ثُمَّ تُغْسَلُ أحشاءُ التَّيسِ وَسِيقانُهُ بِالماءِ، وَيُقَدِّمُها الكاهِنُ بِالكامِلِ وَيُحرِقُها عَلَى المَذبَحِ ذَبيحَةً صاعِدَةً، مُعَدَّةً بِالنّارِ كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«وَإنْ كانَتْ تَقدِمَتُهُ للهِ ذَبيحَةً صاعِدَةً مِنَ الطُّيُورِ، فَلْتَكُنْ مِنَ اليَمامِ أوِ الحَمامِ الصَّغِيرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","فَيُحضِرُها الكاهِنُ إلَى المَذبَحِ، وَيَقطَعُ رَأسَها، وَيُحرِقُها عَلَى المَذبَحِ، ثُمَّ يُصَفِّي الدَّمَ عَلَى جانِبِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","وَيَنزِعُ الكاهِنُ الحَوصَلَةَ وَالرِّيشَ وَيَطرَحُها إلَى الجِهَةِ الشَّرقِيَّةِ مِنَ المَذبَحِ، إلَى مَكانِ الرَّمادِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ثُمَّ يَشُقُّ الكاهِنُ الطَّيرَ مِنْ بَينِ جَناحَيهِ مِنْ دُونِ أنْ يَفصِلَ شَطرَيهِ. ثُمَّ يُحرِقُهُ عَلَى المَذبَحِ عَلَى الخَشَبِ الَّذِي عَلَى النّارِ. إنَّهُ ذَبيحَةٌ صاعِدَةٌ مُعَدَّةٌ بِالنّارِ كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«وَحِينَ يُقَدِّمُ أحَدُكُمْ تَقدِمَةً مِنَ الحُبُوبِ للهِ، فَلْتَكُنْ مِنْ أجوَدِ أنواعِ الطَّحينِ. يَسكُبُ عَلَيهِ زَيتاً وَبَخُوراً، ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","وَيُحضِرَهُ إلَى أبناءِ هارُونَ الكَهَنَةِ. فَيَغرِفُ أحَدُ الكَهَنَةِ مِقدارَ قَبضَةٍ مِنَ الطَحِينِ الجَيِّدِ وَالزَّيتِ وَالبَخُورِ، وَيَحْرِقُهُ تَقْدِمَةً مُعَدَّةً بِالنّارِ كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","وَأمّا بَقِيَّةُ تَقدِمَةِ الحُبُوبِ فَتَكُونُ لِهارُونَ وَأبْنائِهِ نَصيباً مُقّدَّساً مِنْ تَقدِماتِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«وَحِينَ تُقَدِّمُ تَقدِمَةَ حُبُوبٍ مَخبُوزَةٍ فِي الفُرنِ، فَلْتَكُنْ مِنْ أجوَدِ أنواعِ الطَّحِينِ. تَكُونُ خُبزاً بِلا خَمِيرَةٍ مَمزُوجاً بِزَيتٍ وَرَقائِقَ مَمسُوحَةً بِزَيتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","فَإنْ كانَتْ تَقدِمَتُكَ مِنْ حُبُوبٍ مَخبُوزَةٍ عَلَى الصّاجِ، فَلْتَكُنْ مِنْ أجوَدِ أنواعِ الطَّحِينِ المَمزُوجِ بِالزَّيتِ وَمِنْ غَيرِ خَمِيرَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","فَتِّتْها إلَى قِطَعٍ صَغِيرَةٍ، وَاسكُبْ عَلَيها زَيتاً. إنَّها تَقدِمَةُ طَحِينٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","وَإنْ كانَتْ تَقدِمَتُكَ مِنْ حُبُوبٍ مَقلِيَّةٍ فِي مِقلاةٍ، فَلْتَكُنْ مِنْ أجوَدِ أنواعِ الطَّحِينِ مَعَ زَيتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","«وَحِينَ تُحْضِرُ تَقدِمَةَ الحُبُوبِ المَصنُوعَةِ بِإحدَى هَذِهِ الطُّرُقِ للهِ، قَدِّمْها لِلكاهِنِ، وَسَيُقَدِّمُها الكاهِنُ إلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ثُمَّ يَأخُذُ الكاهِنُ شَيئاً مِنَ التَّقدِمَةِ، وَيُحْرِقُهُ تِقْدِمَةً مُعَدَّةً بِالنّارِ كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","وَأمّا بَقِيَّةُ تَقدِمَةِ الطَّحِينِ فَتَكُونُ لِهارُونَ وَأبْنائِهِ نَصيباً مُقّدَّساً مِنْ تَقدِماتِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«يَنبَغِي أنْ تَكُونَ جَمِيعُ تَقدِماتِ الحُبُوبِ الَّتِي يُقَدِّمُونَها للهِ خالِيَةً مِنَ الخَمِيرَةِ. لا تَحْرِقْ خَمِيرَةً أوْ عَسَلاً كَتَقدِمَةٍ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","يُمكِنُكُمْ أنْ تُقَدِّمُوها للهِ كَتَقدِمَةٍ مِنْ أوائِلِ الحَصادِ، لَكِنَّها لا تُقَدَّمُ عَلَى المَذبَحِ كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","«ضَعْ مِلْحاً عَلى كُلِّ تَقدِمَةِ حُبُوبٍ. لا يَنبَغِي أنْ تَخلُو تَقدِماتُكَ مِنْ مِلْحِ عَهدِكَ مَعَ إلَهِكَ، بَلْ قَدِّمِ المِلْحَ مَعَ كُلِّ ذَبائِحِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«وَإذا أحضَرْتَ تَقدِمَةَ حُبُوبٍ مِنْ أوائِلِ الحَصادِ للهِ، فَقَدِّمْ فَرِيكاً مَشوِيّاً فِي النّارِ كَتَقدِمَةِ حُبُوبٍ مِنْ أوائِلِ حَصادِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","أضِفْ إلَيهِ زَيتاً، وَضَعْ عَلَيهِ بَخُوراً. إنَّها تَقدِمَةُ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","يُحرِقُ الكاهِنُ جُزءاً مِنَ الفَرِيكِ وَالزَّيتِ وَالبَخُورِ كَعَلامَةٍ، كَتَقدِمَةِ رائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«وَإنْ كانَتْ تَقدِمَتُهُ ذَبِيحَةَ سَلامٍ، وَقَدَّمَ ثَوراً أوْ بَقَرَةً، فَلْيُقَدِّمْ حَيواناً بِلا عَيبٍ فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","يَضَعُ يَدَهُ عَلَى رَأْسِ تَقدِمَتِهِ، وَتُذبَحُ فِي مَدخَلِ خَيمَةِ الاجْتِماعِ. ثُمَّ يَسْكُبُ أبناءُ هارُونَ الكَهَنَةُ الدَّمَ حَولَ المَذبَحِ مِنْ كُلِّ جانِبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ثُمَّ يُقَدِّمُ مِنْ ذَبِيحَةِ السَّلامِ الشَّحمَ الَّذِي يُغَطِّي الأحشاءَ وَيُحِيطُ بِها. يُقَدِّمُهُ تَقدِمَةً مُعَدَّةً بالشَّحمَ الَّذِي يُغَطِّي الأحشاءَ وَيُحِيطُ بالنّارِ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","كَما يُقَدِّمُ الكُلْيَتَينِ وَالشَّحمَ الَّذِي حَولَهُما وَالشَّحمَ الَّذِي عَلَى الخاصِرَتَينِ وَمُلحَقاتِ الكَبِدِ. فَيَنْزِعُ مُلحَقاتِ الكَبِدِ مَعَ الكُلْيَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ثُمَّ يَحْرِقُها أبناءُ هارُونَ عَلَى المَذبَحِ مَعَ الذَّبيحَةِ الصّاعِدَةِ الَّتِي عَلَى الخَشَبِ الَّذِي عَلَى النّارِ، كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«وَإنْ كانَتْ تَقدِمَةُ ذَبِيحَةِ السَّلامِ للهِ مِنَ الغَنَمِ، فَلْتَكُنْ ذَكَراً أوْ أُنثَىً بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","وَإنْ كانَ خَرُوفاً، فَلْيُقَدِّمْهُ فِي حَضْرَةِ اللهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","وَيَضَعْ يَدَهُ عَلَى رَأْسِ تَقدِمَتِهِ، وَتُذبَحُ فِي مَدخَلِ خَيمَةِ الاجْتِماعِ. ثُمَّ يَرُشُّ أبناءِ هارُونَ الكَهَنَةِ دَمَها حَولَ المَذبَحِ مِنْ كُلِّ جانِبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","وَيُقَدِّمُ الكاهِنُ مِنْ ذَبِيحَةِ السَّلامِ للهِ شَحْمَها، وَكُلَّ الذَّيلِ مِنْ نِهايَةِ العَمُودِ الفِقَرِيِّ، وَالشَّحمَ الَّذِي يُغَطِّي الأحشاءَ وَما يُحِيطُ بِها، ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","وَالكُلْيَتَينِ وَالشَّحمَ الَّذِي حَولَهُما وَالشَّحمَ الَّذِي عَلَى الخاصِرَتَينِ وَمُلحَقاتِ الكَبِدِ. فَيَنْزِعُ مُلحَقاتِ الكَبِدِ مَعَ الكُلْيَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","فَيُحرِقُها الكاهِنُ عَلَى المَذبَحِ كَتَقدِمَةٍ مُعَدَّةٍ بِالنّارِ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«فإنْ كانَتْ تَقدِمَتُهُ مِنَ الماعِزِ، فَلْيُقَدِّمْها فِي حَضْرَةِ اللهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","وَيَضَعْ يَدَهُ عَلَى رَأْسِها، فَتُذبَحُ أمامَ خَيمَةِ الاجْتِماعِ. ثُمَّ يَرُشُّ أبناءِ هارُونَ الكَهَنَةِ دَمَها حَولَ المَذبَحِ مِنْ كُلِّ جانِبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ثُمَّ يُقَدِّمُ الكاهِنُ الشَّحمَ الَّذِي يُغَطِّي الأحشاءَ وَما حَولَها، ذَبِيحَةً مُعَدَّةً بِالنّارِ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","فَيأخُذُ الكُلْيَتَينِ وَالشَّحمَ الَّذِي حَولَهُما وَالشَّحمَ الَّذِي عَلَى الخاصِرَتَينِ وَمُلحَقاتِ الكَبِدِ، وَيَنْزِعُ مُلحَقاتِ الكَبِدِ مَعَ الكُلْيَتَينِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ثُمَّ يُحرِقُها الكاهِنُ عَلَى المَذبَحِ كَرائِحَةٍ يُسَرُّ بِها اللهُ. كُلُّ الشَّحمِ يُقَدَّمُ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","هَذِهِ فَرِيضَةٌ دائِمَةٌ جِيلاً بَعْدَ جِيلٍ. وَحَيثُما كُنتُمْ تَسكُنُونَ، لا تَأكُلُوا مِنَ الشَّحمِ وَلا مِنَ الدَّمِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«أخبِرْ بَنِي إسْرائِيلَ بِما يَنبَغِي عَمَلُهُ إنْ أخطَأ أحَدٌ بِغَيرِ قَصدٍ، فَعَمِلَ ما نَهَى اللهُ عَنِ عَمَلِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«إنْ أخطَأ الكاهِنُ المَمسُوحُ فَجَلَبَ ذَنباً عَلَى الشَّعبِ، فَلْيُقَدِّمْ للهِ عَنْ خَطِيَّتِهِ الَّتِي اقتَرَفَها ثَوراً بِلا عَيبٍ ذَبيحَةَ خَطِيَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","يُحضِرُ الثَّورَ إلَى مَدخَلِ خَيمَةِ الاجْتِماعِ فِي حَضْرَةِ اللهِ، وَيَضَعُ يَدَهُ عَلَى رَأْسِ الثَّورِ وَيَذبَحُهُ فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ثُمَّ يَأخُذُ الكاهِنُ المَمسُوحُ مِنْ دَمِ الثَّورِ وَيُحضِرُهُ إلَى خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","وَيَغْمِسُ الكاهِنُ إصبَعَهُ فِي الدَّمِ، وَيَرُشُّ مِنهُ سَبعَ مَرّاتٍ فِي حَضرَةِ اللهِ، مُقابِلَ سِتارَةِ قُدسِ الأقداسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ثُمَّ يَضَعُ الكاهِنُ بَعضَ الدَّمِ عَلَى زَوايا مَذْبَحِ البَخُورِ الطَّيِّبِ فِي حَضرَةِ اللهِ فِي خَيمَةِ الاجْتِماعِ، وَيَسكُبُ بَقِيَّةَ دَمِ الثَّورِ عِندَ قاعِدَةِ مَذبَحِ الذَّبائِحِ الصّاعِدَةِ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","وَيُزِيلُ الكاهِنُ الشَّحمَ مِنْ ثَورِ ذَبِيحَةِ السَّلامِ الَّذِي يُغَطِّي الأحشاءَ وَكُلَّ الشَّحمِ المُحِيطِ بِها، ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","وَالكُلْيَتَينِ وَالشَّحمَ الَّذِي حَولَهُما وَالشَّحمَ الَّذِي عَلَى الخاصِرَتَينِ وَمُلحَقاتِ الكَبِدِ. فَيَنْزِعُ مُلحَقاتِ الكَبِدِ مَعَ الكُلْيَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","يُزِيلُ الشَّحمَ مِنْ ذَبِيحَةِ الخَطِيَّةِ – بِالطَّرِيقَةِ الَّتِي يُزِيلُهُ بِها مِنْ ثَورِ ذَبِيحَةِ السَّلامِ. – ثُمَّ يُحرِقُهُ الكاهِنُ عَلَى مَذبَحِ الذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","وَأمّا جِلدُ الثَّورِ وَلَحمُهُ وَرَأسُهُ وَسِيقانُهُ وَأحشاؤُهُ الدّاخِلِيَّةُ وَرَوثُهُ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","وَكُلُّ بَقِيَّتِهِ يَنبَغِي أنْ تُؤخَذَ إلَى مَكانٍ طاهِرٍ خارِجَ المُخَيَّمِ، إلَى مَكَبٍّ لِلرَّمادِ، فَتُحرَقَ هُناكَ عَلَى حَطَبٍ. تُحرَقُ تَماماً عَلَى مَكَبِّ الرَّمادِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«إنْ أخطَأ بَنُو إسْرائِيلَ بِغَيرِ قَصْدٍ، وَلَمْ يُدرِكُوا ذَلِكَ، فَعَمِلُوا ما تَنهَى عَنهُ وَصايا اللهِ، فَإنَّهُمْ يُعْتَبَرُونَ مُذنِبِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","فَحِينَ تُعرَفُ الخَطِيَّةُ الَّتِي ارتَكَبُوها، يُقَدِّمُونَ ثَوراً ذَبيحَةَ خَطِيَّةٍ. يُحضِرُونَهُ إلَى أمامِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ثًمَّ يَضَعُ شُيُوخُ الشَّعبِ أيدِيَهُمْ عَلَى رَأْسِ الثَّورِ فِي حَضرَةِ اللهِ، وَيُذْبَحُ فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","وَيُحْضِرُ الكاهِنُ المَمسُوحُ بَعضاً مِنَ دَمِ الثَّورِ إلَى خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","وَيَغْمِسُ الكاهِنُ إصبَعَهُ فِي الدَّمِ، وَيَرُشُّ مِنهُ سَبعَ مَرّاتٍ فِي حَضرَةِ اللهِ، مُقابِلَ سِتارَةِ قُدسِ الأقداسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ثُمَّ يَضَعُ الكاهِنُ بَعضَ الدَّمِ عَلَى زَوايا مَذْبَحِ البَخُورِ فِي حَضرَةِ اللهِ فِي خَيمَةِ الاجْتِماعِ، وَيَسكُبُ بَقِيَّةَ الدّمِ عِندَ قاعِدَةِ مَذبَحِ الذَّبائِحِ الصّاعِدَةِ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ثُمَّ يُزِيلُ الكَاهِنُ كُلَّ الشَّحمِ مِنهُ، وَيُحرِقُهُ عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","يَصْنَعُ بِهَذا الثَّورِ ما صَنَعَهُ بِثَورِ ذَبِيحَةِ الخَطِيَّةِ الَّذِي لِلكاهِنِ. وَهَكَذا يَعمَلُ الكاهِنُ كَفّارَةً لِلشَّعبِ فَيُغفَرَ لَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ثُمَّ يُؤخَذُ الثَّورُ إلَى خارِجِ المُخَيَّمِ لِيَتِمَّ حَرقُهُ كَما أحرِقَ الثَّورُ الأوَّلُ. إنَّهُ ذَبِيحَةُ خَطِيَّةٍ لِلشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«وَإنْ أخطَأ رَئِيسٌ، فَعَمِلَ أمراً تَنهَى عَنهُ وَصايا إلَهِهِ بِغَيرِ قَصدٍ، فَصارَ مُذنِباً، ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ثُمَّ عَرَفَ خَطِيَّتَهُ، فَلْيُحْضِرْ تَقدِمَتَهُ تَيساً ذَكَراً مِنَ الماعِزِ لا عَيبَ فِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","بَعْدَ ذَلِكَ يَضَعُ يَدَهُ عَلَى رَأسِ التَّيسِ، وَيُذبَحُ التَّيسُ فِي المَكانِ الَّذِي تُذبَحُ فِيهِ الذَّبيحَةُ الصّاعِدَةُ فِي حَضْرَةِ اللهِ، إنَّهُ ذَبِيحَةُ خَطِيَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ثُمَّ يَأخُذُ الكاهِنُ بَعضاً مِنْ دَمِ ذَبِيحَةِ الخَطِيَّةِ بِإصبَعِهِ وَيَضَعُهُ عَلَى زَوايا مَذبَحِ الذَّبيحَةِ الصّاعِدَةِ، وَيَسكُبُ بَقِيَّةَ الدَّمِ عِندَ قاعِدَةِ مَذبَحِ الذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ثُمَّ يَحْرِقُ شَحمَهُ عَلَى المَذبَحِ كَشَحمِ ذَبِيحَةِ السَّلامِ. وَهَكَذا يَعِدُّ الكاهِنُ كَفّارَةً عَنْ خَطِيَّتِهِ، فَتُغفَرَ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«وَإنْ أخطَأ أحَدٌ مِنْ عامَّةِ الشَّعبِ بِغَيرِ قَصدٍ، فَعَمِلَ ما تَنهَى عَنهُ وَصايا اللهِ ثُمَّ عَرَفَ ذَنبَهُ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","أوْ عَرَّفَهُ أحَدٌ بِذَنبِهِ، فَلْيُحْضِرْ تَقدِمَتَهُ عَنزاً أُنثَىً مِنَ الماعِزِ لا عَيبَ فِيها لِأجلِ الذَّنبِ الَّذِي اقتَرَفَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","يَضَعُ المُذْنِبُ يَدَهُ عَلَى ذَبِيحَةِ الخَطِيَّةِ، ثُمَّ تُذبَحُ فِي المَكانِ الَّذِي تُذبَحُ فِيهِ الذَّبيحَةُ الصّاعِدَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","وَيَأخُذُ الكاهِنُ بَعضاً مِنْ دَمِ الذَّبِيحَةِ بِإصبَعِهِ وَيَضَعُهُ عَلَى زَوايا مَذبَحِ الذَّبيحَةِ الصّاعِدَةِ، ثُمَّ يَسكُبُ بَقِيَّةَ الدَّمِ عِندَ قاعِدَةِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ثُمَّ يُزِيلُ كُلَّ الشَّحْمِ، مِثلَ الشَّحْمِ الَّذِي يُزالُ مِنْ ذَبِيحَةِ السَّلامِ، وَيُحرِقُهُ عَلَى المَذبَحِ، كَرائِحَةٍ يُسَرُّ بِها اللهُ. وَهَكَذا يَعِدُّ الكاهِنُ كَفّارَةً عَنْ خَطِيَّتِهِ، فَتُغفَرَ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«وَإنْ كانَتِ التَّقدِمَةُ الَّتِي تُحضِرُها مِنَ الغَنَمِ، يَنبَغِي أنْ تُحضِرَ أُنثَىً لا عَيبَ فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","تَضَعُ يَدَكَ عَلَى رَأْسِ ذَبِيحَةِ الخَطِيَّةِ، ثُمَّ تُذبَحُ كَذَبِيحَةِ خَطِيَّةٍ فِي المَكانِ الَّذِي تُذبَحُ فِيهِ الذَّبيحَةُ الصّاعِدَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","يَأخُذُ الكاهِنُ بَعضاً مِنْ دَمِ ذَبِيحَةِ الخَطِيَّةِ بِإصبَعِهِ وَيَضَعُهُ عَلَى زَوايا مَذبَحِ الذَّبيحَةِ الصّاعِدَةِ، ثُمَّ يَسكُبُ بَقِيَّةَ الدَّمِ عِندَ قاعِدَةِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","وَيُزِيلُ الكاهِنُ كُلَّ شَحمِها – بِالطَّرِيقَةِ الَّتِي يُزِيلُهُ بِها مِنْ ذَبيحَةِ السَّلامِ – وَيُحرِقُهُ عَلَى المَذبَحِ مَعَ تَقدِماتِ اللهِ. وَهَكَذا يَعِدُّ الكاهِنُ كَفّارَةً عَنْ خَطِيَّتِكَ، فَتُغفَرَ لَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«إنْ سَمِعَ أحَدٌ دَعوَةً عَلَنِيَّةً لِتَقدِيمِ شَهادَةٍ فِي أمرٍ ما، وَكانَ يَعْرِفُ بَعْضَ الحَقائِقِ فَأخْفاها وَلَمْ يَشهَدْ بِها، فَإنَّهُ يَكُونُ مَسؤُولاً عَنْ ذَنْبِهِ هَذا. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«إنْ لَمَسَ أحَدُكُمْ أيَّ شَيءٍ نَجِسٍ – سَواءٌ أكانَ جُثَّةَ حَيوانٍ نَجِسٍ، أمْ جُثَّةَ حَيوانٍ أليفٍ، أمْ جُثَّةَ حَيوانٍ زاحِفٍ – وَلَمْ يَنتَبِهْ إلَى الأمْرِ، فَإنَّهُ يَتَنَجَّسُ وَيُعْتَبْرُ مُذنِباً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","«إنْ لَمَسَ أحَدٌ نَجاسَةَ إنسانٍ آخَرَ، مَهما كانَتْ، وَلَمْ يَنتَبِهْ لِلأمرِ، فَإنَّهُ حِينَ يَعرِفُ يُعْتَبَرُ مُذْنِباً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","«إنْ أقسَمَ أحَدُهُمْ بِلا تَفكِيرٍ بِأنْ يَعمَلَ أمراً سَيِّئاً أوْ حَسَناً، مَهما كانَ ما يَقُولُهُ بِلا تَفكِيرٍ، وَلَمْ يَنتَبِهْ، فَإنَّهُ حِينَ يَتَذَكَّرُ يُعْتَبَرُ مُذنِباً فِي أيٍّ مِنْ هَذِهِ الأُمُورِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","فَحِينَ يُعْتَبَرُ مُذنِباً فِي أيٍّ مِنْ هَذِهِ الأُمُورِ، يَنبَغِي أنْ يَعتَرِفَ بِذَنْبِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","وَأنْ يُقَدِّمَ للهِ ذَبِيحَةً بِسَبَبِ خَطِيَّتِهِ الَّتِي ارتَكَبَها. فَلْيُقَدِّمْ أُنثَى مِنَ الغَنَمِ أوِ الماعِزِ ذَبِيْحَةَ خَطِيَّةٍ. وَهَكَذا يَعمَلُ الكاهِنُ كَفّارَةً لِخَطِيَّتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«فَإنْ لَمْ يَستَطِعْ تَقدِيمَ النَّعجَةِ لِفَقْرِهِ، فَلْيُقَدِّمْ للهِ يَمامَتَينِ أوْ حَمامَتَينِ صَغيرَتَينِ. فَيَكُونُ أحَدُ الطَّيرَينِ ذَبِيحَةَ خَطِيَّةٍ، وَالآخَرُ ذَبيحَةً صاعِدَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","يُقَدِّمُهُما لِلكاهِنِ، فَيُقَدِّمُ الكَاهِنُ أحَدَهُما ذَبِيْحَةَ خَطِيَّةٍ. يَقطَعُ الكاهِنُ رَأْسَ الطّيْرِ مِنَ العُنقِ دُونَ أنْ يَفصِلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ثُمَّ يَرُشُّ بَعضاً مِنْ دَمِ ذَبِيحَةِ الخَطِيَّةِ عَلَى جانِبِ المَذبَحِ. وَما يَتَبَقَّى مِنَ الدَّمِ يُصَفَّى عِندَ قاعِدَةِ المَذبَحِ. هَذِهِ ذَبِيحَةُ خَطِيَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","وَأمّا الطَّيرُ الثّانِي فَيُقَدِّمُهُ ذَبيحَةً صاعِدَةً بِحَسَبِ الشَّريعَةِ. وَهَكَذا يَعِدُّ الكاهِنُ كَفّارَةً عَنْ خَطِيَّتِهِ، فَتُغفَرَ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«فَإنْ لَمْ يَستَطِعْ تَقدِيمَ يَمامَتَينِ أوْ حَمامَتَينِ، فَلْيُحْضِرْ كَتَقدِمَةٍ عَنْ خَطِيَّتِهِ الَّتِي اقتَرَفَها عُشْرَ قُفَّةٍ مِنْ طَحِينٍ جَيِّدٍ ذَبِيحَةَ خَطِيَّةٍ. لا يَنْبَغِي أنْ يَضَعَ عَلَى الطَّحينِ زَيتاً أوْ بَخُوراً، لِأنَّهُ تَقدِمَةُ تَطهِيرٍ مِنَ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ثُمَّ يُحضِرُهُ لِلكاهِنِ، فَيَأْخُذُ الكاهِنُ مِلءَ كَفِّهِ مِنهُ وَيُحرِقُهُ عَلَى المَذبَحِ مَعَ تَقدِماتِ اللهِ. إنَّهُ تَقدِمَةُ تَطهِيرٍ مِنَ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","وَهَكَذا يَعِدُّ الكاهِنُ كَفّارَةً عَنْ خَطاياهُ هَذِهِ جَميعاً، فَتُغفَرَ لَهُ. أمّا بَقِيَّةُ تَقْدِمَةِ الحُبُوبِ فَتَكُونُ لِلكاهِنِ كَتَقدِمَةِ الحُبُوبِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ثُمَّ قالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«حِينَ يَرتَكِبُ أحَدٌ خَطَأً بِغَيرِ قَصْدٍ فِي أُمُورِ اللهِ المُقَدَّسَةِ، يُحضِرُ للهِ، كَعُقُوبَةٍ، كَبْشاً لا عَيبَ فِيهِ مِنَ الغَنَمِ، ثَمَنُهُ يُعادِلُ القِيمَةَ المُناسِبَةَ مِنَ الفِضَّةِ بِحَسَبِ المِقياسِ الرَّسمِيِّ لِلْمِثْقالِ، فَيَكُونُ ذَبِيحَةَ ذَنبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","يَدفَعُ المُخطِئُ مُقابِلَ الخَطَإ الَّذِي ارتَكَبَهُ. وَيُضِيفُ خُمْسَ ثَمَنِ الذَّبِيحَةِ وَيُعطِيَهُ لِلكاهِنِ. وَيُكَفِّرُ الكاهِنُ عَنهُ بِكَبْشِ ذَبِيحَةِ الذَّنبِ، فَيُغفَرَ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«حِينَ يُخطِئُ شَخصٌ بِعَمَلِ أمرٍ تَنهَى عَنهُ وَصايا اللهِ، لَكِنْ لا يُدرِكُ، فَإنَّهُ يَكُونُ مُذنِباً، وَهُوَ مَسؤُولٌ عَنْ خَطِيَّتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","فَلْيُحْضِرْ لِلكاهِنِ كَبْشاً لا عَيبَ فِيهِ مِنَ الغَنَمِ، كَما تُحَدِّدُ أنتَ كَتَقدِمَةِ ذَنبٍ. ثُمَّ يَصْنَعُ الكاهِنُ كَفّارَةً لَهُ لِأجلِ الذَّنْبِ الَّذِي اقتَرَفَهُ وَلَمْ يَعرِفْ عَنهُ، فَيُغفَرَ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","إنَّهُ ذَبِيحَةُ ذَنبٍ إذْ أنَّهُ أذنَبَ فِي حَضرَةِ اللهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«إذا ارْتَكَبَ أحَدٌ خَطَأً ضِدَّ اللهِ، فَكَذَبَ بِشَأْنِ أمانَةٍ أُعطِيَتْ لَهُ أوْ قَرضٍ أوْ سَرِقَةٍ، أوِ احتالَ عَلَى جارِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","أوْ وَجَدَ شَيئاً فَكَذَبَ بِشَأْنِهِ، أوْ حَلَفَ كَذِباً بِشَأْنِ أيِّ أمرٍ يُمكِنُ للإنْسانِ أنْ يَفعَلَهُ فَيُخطِئَ بِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","فَإنَّهُ يَكُونُ مُذنِباً. يَنبَغِي أنْ يُعِيدَ ما سَرَقَهُ أوِ احتالَ لِأخذِهِ أوِ الأمانَةَ الَّتِي أعطاها شَخصٌ لَهُ لِيَحتَفِظَ بِها أوِ الشَّيءَ الضّائِعَ الَّذِي وَجَدَهُ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","أوْ أيَّ شَيءٍ أقسَمَ كَذِباً بِشَأْنِهِ. فَلْيَدْفَعِ الثَّمَنَ الأصلِيَّ وَيُضِيفَ مِقدارَ خُمْسِهِ، وَيَدفَعُهُ لِصاحِبِ الشَّيءِ فِي اليَومِ الَّذِي يَتِمُّ فِيهِ إثباتُ ذَنبِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ثُمَّ يُقَدِّمُ لِلكاهِنِ تَقدِمَةَ ذَنبٍ للهِ كَبْشاً لا عَيبَ فِيهِ مِنَ الغَنَمِ ثَمَنُهُ يُعادِلُ القِيمَةَ الرَّسْمِيَّةِ لِذَبِيحَةِ الذَّنبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","فَيُكَفِّرُ عَنهُ الكاهِنُ فِي حَضْرَةِ اللهِ، فَتُغفَرَ لَهُ كُلُّ الأُمُورِ الَّتِي عَمِلَها وَاعْتُبِرَ مُذنِباً بِها.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«أوصِ هارُونَ بِما يَلِي: هَذِهِ هِيَ شَرِيعَةُ تَقدِمَةِ الذَّبيحَةِ الصّاعِدَةِ: يَنبَغِي أنْ تَبقَى تَقدِمَةُ الذَّبيحَةِ الصّاعِدَةِ عَلَى المَوقِدِ فَوقَ المَذبَحِ طُولَ اللَّيلِ وَحَتَّى الصَّباحِ، وَيَنبَغِي أنْ تَبقَى النّارُ مُشتَعِلَةً فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","وَيَرتَدِي الكاهِنُ رِداءَهُ الكِتّانِيَّ وَسِروالَهُ الكِتّانِيَّ، ثُمَّ يُزِيلُ الرَّمادَ المُتَبَقِّيَ مِنَ النّارِ مِنْ تَقدِمَةِ الذَّبيحَةِ الصّاعِدَةِ عَلَى المَذبَحِ وَيَضَعُهُ إلَى جانِبِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ثُمَّ يَخلَعُ ثِيابَهُ وَيَرتَدِيَ ثِياباً أُخْرَى وَيَأخُذُ الرَّمادَ إلَى مَكانٍ طاهِرٍ خارِجَ المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","يَنْبَغِي أنْ تَبقَى النّارُ الَّتِي عَلَى المَذبَحِ مُشتَعِلَةً وَلا تَنطَفِئَ. يَضَعُ الكاهِنُ خَشَباً عَلَيها كُلَّ صَباحٍ، وَيُرَتِّبُ تَقدِمَةَ الذَّبيحَةِ الصّاعِدَةِ، وَيَحرِقُ شَحمَ ذَبِيحَةِ السَّلامِ عَلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","فَتَبقَى النّارُ مُشتَعِلَةً عَلَى المَذبَحِ وَلا تَنطَفِئُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","«وَهَذِهِ هِيَ شَرِيعَةُ تَقدِمَةِ الطَّحِينِ: يُقَدِّمُها أبْناءُ هارُونَ فِي حَضْرَةِ اللهِ مُقابِلَ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","يَأخُذُ الكاهِنُ مِلءَ كَفِّهِ مِنَ الطَّحِينِ الجَيِّدِ وَزَيتٍ وَكُلِّ البَخُورِ، وَيُحرِقُهُ كَعَلامَةٍ عَلَى المَذبَحِ، كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","يُمْكِنُ لِهارُونَ وَأبنائِهِ أنْ يَأكُلُوا بَقِيَّتَهُ، لَكِنْ مِنْ دُونِ خَمِيرَةٍ، وَفِي مَكانٍ مُقَدَّسٍ: فِي ساحَةِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","لا يُخبَزُ بِخَمِيرَةٍ. فَقَدْ أعطَيتُ الكَهَنَةَ هَذا الطَّحِينَ كَنَصِيبٍ لَهُمْ مِنْ تَقدِماتِي. إنَّهُ نَصيبٌ مُخَصَّصٌ لَهُمْ بِالكامِلِ كَذَبِيحَةِ الخَطِيَّةِ وَتَقدِمَةِ الذَّنبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","يُسْمَحُ لِأيِّ ذَكَرٍ مِنْ نَسلِ هارُونَ أنْ يَأكُلَ مِنْهُ كَنَصِيبٍ دائِمٍ لَهُمْ مِنْ تَقدِماتِ اللهِ جِيلاً بَعْدَ جِيلٍ. وَلا يَمَسُّ هَذِهِ التَّقدِماتِ إلّا المُقَدَّسُونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«هَذِهِ هِيَ التَّقدِمَةُ الَّتِي عَلَى هارُونَ وَأبْنائِهِ أنْ يُقَدِّمُوها للهِ فِي اليَومِ الَّذِي يُمسَحُ فِيهِ كاهِناً: عُشْرَ قُفَّةٍ مِنْ طَحِينٍ جَيِّدٍ كَتَقدِمَةِ طَحِينٍ دائِمَةٍ مُنتَظَمَةٍ، نِصفُها فِي الصَّباحِ وَنِصفُها فِي المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","يَنبَغِي أنْ تُجَهَّزَ التَّقدِمَةُ مَعَ زَيتٍ. يُخلَطُ الطَّحِينُ جَيِّداً بِالزَّيتِ ثُمَّ يُخبَزُ عَلَى الصّاجِ، ثُمَّ تُقَدَّمُ تَقدِمَةَ الحُبُوبِ قِطَعاً مَخبُوزَةً، كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","«الكاهِنُ الَّذِي يُمْسَحُ مِنْ نَسلِ هارُونَ لِيَخلِفَ هارُونَ، يَسْتَمِرُّ بَتَقْديمِ هَذِهِ التَّقدِمَةَ للهِ فَرِيضَةً دائِمَةٌ. وَيَنبَغِي إحْراقُها بِالكامِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","كُلُّ تَقدِمَةٍ يُقَدِّمُها الكاهِنُ تُحرَقُ بِالكامِلِ، وَلا تُؤْكَلُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«قُلْ لِهارُونَ وَأبْنائِهِ هَذِهِ التَّعلِيماتِ بِشأنِ شَرِيعَةِ ذَبِيحَةِ الخَطِيَّةِ: فِي المَكانِ الَّذِي تُذبَحُ فِيهِ الذَّبيحَةُ الصّاعِدَةُ، تُذْبَحُ ذَبِيحَةُ الخَطِيَّةِ فِي حَضْرَةِ اللهِ. إنَّها نَصِيبٌ مُخَصَّصٌ لِلكَهَنَةِ بِالكامِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","وَالكاهِنُ الَّذِي يُقَدِّمُ ذَبِيحَةَ الخَطِيَّةِ، يَأكُلُها فِي مَكانٍ مُقَدَّسٍ، فِي ساحَةِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","وَكُلُّ شَخصٍ أوْ شَيءٍ يَمَسُّ لَحمَها يَصِيرُ مُقَدَّساً. «فَإنْ رُشَّ مِنْ دَمِ الذَّبِيحَةِ عَلَى أيَّةِ ثِيابٍ، يَنْبَغِي أنْ تُغْسَلَ فِي مَكانٍ مُقَدَّسٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","وَكُلُّ وِعاءٍ مِنْ خَزَفٍ تُطبَخُ ذَبِيحَةُ الخَطِيَّةِ فِيهِ يَنبَغِي كَسْرُهُ. وَإنْ طُبِخَتْ فِي وِعاءٍ نُحاسِيٍّ، يَنبَغِي غَسلُهُ وَشَطفُهُ بِالماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","«يُمكِنُ لِكُلِّ ذَكَرٍ مِنَ الكَهَنَةِ أنْ يَأكُلَ مِنْ هَذِهِ الذَّبيحَةِ. إنَّها نَصِيبٌ مُخَصَّصٌ لِلكَهَنَةِ بِالكامِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","وَأمّا كُلُّ ذَبائِحِ الخَطِيَّةِ الَّتِي يُجلَبُ دَمُها إلَى خَيمَةِ الاجْتِماعِ لِعَمَلِ كَفّارَةٍ فِي المَكانِ المُقَدَّسِ، فَلا يَنبَغِي أنْ تُؤكَلَ، بَلْ لِتُحرَقْ بِالنّارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«هَذِهِ هِيَ شَرِيعَةُ ذَبِيحَةِ الذَّنبِ. هِيَ نَصِيبٌ مُخَصَّصٌ لِلكَهَنَةِ بِالكامِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","تُذَبحُ ذَبِيحَةُ الذَّنبِ فِي المَكانِ الَّذِي تُذبَحُ فِيهِ الذَّبيحَةُ الصّاعِدَةُ. وَيُرَشُّ دَمُها عَلَى جَوانِبِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","«وَيُقَدَّمُ الكاهِنُ شَحْمَها كُلَّهُ: الذَّيلَ وَالشَّحمَ الَّذِي يُغَطِّي الأحشاءَ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","وَالكُلْيَتَينِ وَالشَّحمَ الَّذِي حَولَهُما وَالشَّحمَ الَّذِي عَلَى الخاصِرَتَينِ وَمُلحَقاتِ الكَبِدِ. فَيَنْزِعُ مُلحَقاتِ الكَبِدِ مَعَ الكُلْيَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","يَأخُذُهُ الكاهِنُ وَيُحْرِقُهُ عَلَى المَذبَحِ كَتَقدِمَةٍ للهِ. إنَّها ذَبِيحَةُ ذَنبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","«يُمكِنُ لِكُلِّ الذُّكُورِ مِنَ الكَهَنَةِ أنْ يَأكُلُوها. يَنبَغِي أكلُها فِي مَكانٍ مُقَدَّسٍ، فَهِيَ نَصِيبٌ مُخَصَّصٌ لِلكَهَنَةِ بِالكامِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","وَتَنطَبِقُ عَلَى ذَبِيحَةِ الذَّنبِ وَذَبِيحَةِ الخَطِيَّةِ القاعِدَةُ نَفسُها، أي أنَّ الذَّبِيحَةَ تَكُونُ لِلكاهِنِ الَّذِي يُقَدِّمُها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","حِينَ يُقَدِّمُ الكاهِنُ ذَبيحَةً صاعِدَةً عَنْ إنْسانٍ، فَإنَّ جِلدَ الذَّبيحَةِ الصّاعِدَةِ الَّتِي يُقَدِّمُها يَكُونُ لِلكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","وَكُلُّ تَقدِمَةِ طَحِينٍ مَخبُوزٍ فِي الفُرنِ، وَكُلُّ تَقدِمَةِ طَحِينٍ مُجَهَّزٍ فِي مِقلاةٍ أوْ عَلَى الصّاجِ فَإنَّها تَكُونُ لِلكاهِنِ الَّذِي يُقَدِّمُها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","وَأمّا كُلُّ تَقدِماتِ الطَّحِينِ الأُخرَى، المَمزُوجَةِ بِالزَّيتِ، أوِ الجافَّةِ، فَتَكُونُ لِكُلِّ أبناءِ هارُونَ بِالتَّساوِي. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«هَذِهِ هِيَ شَرِيعَةُ ذَبِيحَةِ السَّلامِ الَّتِي يُقَدِّمُها الإنسانُ للهِ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","إنْ قَدَّمَها شَخصٌ كَذَبيحَةِ شُكرٍ، فَلْيُحْضِرْ مَعَ ذَبِيحَةِ الشُّكرِ كَعكاً بِلا خَمِيرٍ مَمزُوجاً بِزَيتٍ، وَرَقائِقَ بِلا خَمِيرٍ مَسكُوباً عَلَيها زَيتٌ، وَأرغِفَةً مِنْ طَحِينٍ جَيِّدٍ مَمزُوجَةً بِزَيتٍ بِشَكلٍ جَيِّدٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","وَلْيُقَدِّمْ هَذِهِ التَّقدِمَةَ مَعَ خُبزٍ مُختَمِرٍ مَعَ ذَبِيحَةِ السَّلامِ لِلتَّعبِيرِ عَنِ الشُّكرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","وَيُقَدِّمُ رَغِيفُ خُبزٍ مِنْ كُلِّ نَوْعٍ تَقدِمَةً مَرفُوعَةً للهِ، فَتَكُونُ هَذِهِ الإرْغِفَةُ مِنْ نَصِيبِ الكاهِنِ الَّذِي يَرُشُّ دَمَ ذَبِيحَةِ السَّلامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","وَيَنبَغِي أنْ يُؤكَلُ لَحمُ تَقدِمَةِ السَّلامِ الَّتِي لإظْهارِ الشُّكْرِ فِي اليَومِ الَّذِي قُدِّمَتْ فِيهِ. لا تُبْقوا مِنْها شَيئاً إلَى الصَّباحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«فَإنْ كانَتِ ذَبِيحَةُ السَّلامِ اختِيارِيَّةً، أوْ بِسَبَبِ نَذْرٍ، فَيَنبَغِي أنْ تُؤكَلَ فِي اليَومِ الَّذِي تُقَدَّمُ فِيهِ. وَما يَتَبَقَّى مِنْها يُؤكَلُ فِي اليَومِ التّالِي. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","وَما يَتَبَقَّى مِنْ لَحمِ الذَّبِيحَةِ لِليَومِ الثّالِثِ يَنبَغِي حَرقُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","إنْ أكَلَ شَخْصٌ مِنْ لَحمِ ذَبِيحَةِ السَّلامِ فِي اليَومِ الثّالِثِ، فَإنَّها تُصْبِحُ غَيرَ مَقبُولَةٍ. لا تُحسَبُ لِلَّذِي قَدَّمَها. إنَّها نَتِنَةٌ، وَالَّذِي يَأكُلُ مِنْها مَسؤُولٌ عَنْ خَطِيَّتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","«اللَّحمُ الَّذِي يَمَسُّ أيَّ شَيءٍ نَجِسٍ لا يَنبَغِي أنْ يُؤْكَلَ، فَيَنبَغِي حَرقُهُ بِالنّارِ. أمّا اللَّحمُ الَّذِي لَمْ يَتَنَجَّسْ فَيُمكِنُ لِأيِّ شَخصٍ طاهِرٍ أنْ يَأكُلَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","وَأمّا مَنْ يَأكُلُ لَحمَ ذَبِيحَةِ السَّلامِ المُقَدَّمَةِ للهِ بَينَما هُوَ نَجِسٌ، فَيُقطَعُ مِنْ عَشِيرَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","«وَمَنْ يَلمِسُ شَيئاً نَجِساً – سَواءٌ أكانَ نَجاسَةً بَشَرِيَّةً أمْ حَيواناً نَجِساً أمْ أيَّ شَيءٍ كَرِيهٍ – ثُمَّ يَأكُلُ لَحْماً مِنْ ذَبِيحَةٍ سَلامٍ مُقَدَّمَةٍ للهِ، يُقطَعُ مِنْ عَشِيرَتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«قُلْ لِبَنِي إسْرائِيلَ: لا تَأكُلُوا أيَّ شَحمٍ مِنْ ثَورٍ أوْ غَنَمٍ أوْ ماعِزٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","اسْتَخدِمُوا شَحْمِ الحَيوانِ المَيْتِ أوْ الحَيوانِ الَّذِي قُتِلَ وَتُرِكَ فِي أيِّ غَرَضٍ آخَرَ، لَكِنْ لا تَأكُلُوهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","إنْ أكَلَ أحَدٌ شَحْماً مِنْ حَيوانٍ مُقَدَّمٍ للهِ، يُقطَعُ مِنْ عَشِيرَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","«لا تَأكُلُوا دَماً، لا دَمَ طَيرٍ وَلا حَيوانٍ، فِي كُلِّ الأماكِنِ الَّتِي تَقطُنُونَ فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","مَنْ يَأْكُلُ دَماً مِنكُمْ، يُقطَعُ مِنْ عَشِيرَتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«قُلْ لِبَنِي إسْرائِيلَ: مَنْ يُقَدِّمُ مِنكُمْ ذَبِيحَةَ سَلامٍ للهِ، يَنبَغِي أنْ يُحْضِرَ بِنَفسِهِ ذَبِيحَةَ السَّلامِ للهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","وَأنْ يُحْضِرَ التَّقدِماتِ للهِ بِيَدَيهِ. فَلْيُحْضِرِ الشَّحمَ مَعَ صَدْرِ الحَيوانِ لِلكاهِنِ، وَيَرْفَعْهُ تَقْدِمَةً فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","وَيُحرِقُ الشَّحمَ عَلَى المَذبَحِ. يَكُونُ الصَّدرُ لِهارُونَ وَأبْنائِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","وَتُعْطَى الفَخذُ اليُمنَى مِنْ ذَبيحَةِ السَّلامِ تَقدِمَةً لِلكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","فَتَكُونُ الفَخذُ اليُمنَى مِنْ نَصِيبِ مَنْ يُقَدِّمُ دَمَ ذَبِيحَةِ السَّلامِ وَشَحمَها مِنْ بَنِي هارُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","فَقَدْ خَصَّصْتُ صَدْرَ وَفَخذَ التَّقدِمَةِ الَّتِي رُفِعَتْ فِي حَضرَةِ اللهِ لِهارُونَ الكاهِنِ وَأبْنائِهِ نَصِيباً دائِماً لَهُمْ مِنْ تَقدِماتِ السَّلامِ الَّتِي يُقَدِّمُها بَنُو إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","هَذا هُوَ نَصِيبُ هارُونَ وَأبْنائِهِ مِنْ تَقدِماتِ اللهِ المُعَدَّةِ بِالنّارِ مُنذُ تَعيِينِهِمْ لِيَخدِمُوا كَكَهَنَةٍ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","أمَرَ اللهُ بِإعطاءِ هَذِهِ الأجزاءِ لَهُمْ مِنْ وَقْتِ مَسْحِهِمْ كَكَهَنَةٍ، نَصِيباً دائِماً مِنْ بَنِي إسْرائِيلَ جَيلاً بَعْدَ جَيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","هَذِهِ هِيَ قَواعِدُ تَقدِيمِ الذَّبائِحِ الصّاعِدَةِ، وَتَقدِماتِ الطَّحِينِ وَذَبِيحَةِ الذَّنبِ وَتَقدِماتِ تَعيِينِ الكَهَنَةِ وَذَبِيحَةِ السَّلامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","أعطَى اللهُ هَذِهِ الوَصايا لِمُوسَى عَلَى جَبَلِ سِيناءَ حِينَ أمَرَ اللهُ بَنِي إسْرائِيلَ أنْ يُقَدِّمُوا تَقدِماتِهِمْ للهِ فِي بَرِّيَّةِ سِيناءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«خُذْ هارُونَ وَأبناءَهُ مَعَهُ وَالثِّيابَ الكَهنُوتِيَّةَ وَزَيتَ المَسحَةِ وَثَورَ ذَبيحَةِ الخَطِيَّةِ وَالكَبْشَينِ وَسَلَّةَ الخُبزِ الخالِي مِنَ الخَمِيرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ثُمَّ اجمَعِ الشَّعبَ كُلَّهُ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","فَعَمِلَ مُوسَى بِحَسَبِ ما أمَرَهُ اللهُ. فاجتَمَعَ الشَّعبُ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","وَقالَ مُوسَى لِلشَّعبِ: «هَذا ما أمَرَ اللهُ بِعَمَلِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ثُمَّ أحضَرَ مُوسَى هارُونَ وَأبناءَهُ إلَى الأمامِ وَغَسَّلَهُمْ بِالماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ثُمَّ ألبَسَ مُوسَى هارُونَ الجُبَّةَ الدّاخِلِيَّةَ المَنسُوجَةَ، وَوَضَعَ حِزاماً عَلَيها ثُمَّ ألبَسَهُ الرِّداءَ، وَمِنْ ثُمَّ الصُّدرَةَ، وَوَضَعَ الحِزامَ المُزَخرَفَ عَلَيهِ، وَرَبَطَ بِهِ الصُّدرَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ثُمَّ وَضَعَ صُدْرَةَ القَضاءِ عَلَيهِ، وَوَضَعَ فِيها الأُورِيمَ وَالتُّمِّيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ثُمَّ وَضَعَ مُوسَى العِمامَةَ عَلَى رَأْسِ هارُونَ، وَوَضَعَ عَلَى العِمامَةِ مِنَ الأمامِ صَفِيحَةَ الذَّهَبِ، الإكلِيلَ المُقَدَّسَ. عَمِلَ مُوسَى كُلَّ هَذا بِحَسَبِ ما أمَرَهُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ثُمَّ أخَذَ مُوسَى زَيتَ المِسحَةِ وَمَسَحَ بِهِ المَسْكَنَ وَكُلَّ ما فِيهِ. وَهَكَذا قَدَّسَ كُلَّ ما فيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ثُمَّ رَشَّ بَعضَ الزَّيتِ عَلَى المَذبَحِ سَبْعَ مَرّاتٍ، وَمَسَحَ المَذبَحَ وَكُلَّ أدَواتِهِ، وَالحَوضَ وَقاعِدَتَهُ لِيُقَدِّسَها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ثُمَّ سَكَبَ مُوسَى بَعضاً مِنْ زَيتِ المَسحَةِ عَلَى رَأسِ هارُونَ وَمَسَحَهُ لِتَقدِيسِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ثُمَّ أحضَرَ مُوسَى أبناءَ هارُونَ إلَى الأمامِ وَألبَسَهُمْ أثواباً، وَرَبَطَها بِأحزِمَةٍ، وَوَضَعَ عَصائِبَ عَلَى رُؤُوسِهِمْ. عَمِلَ مُوسَى كُلَّ هَذا بِحَسَبِ ما أمَرَهُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ثُمَّ أحضَرَ مُوسَى ثَورَ ذَبيحَةِ الخَطِيَّةِ إلَى الأمامِ. وَوَضَعَ هارُونَ وَأبناءَهُ أيدِيَهُمْ عَلَى رَأْسِ ثَورِ ذَبيحَةِ الخَطِيَّةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ثُمَّ ذَبَحَهُ وَأخَذَ مِنَ الدَّمِ وَوَضَعَ عَلَى زَوايا المَذبَحِ بِإصبَعِهِ. وَبِهَذا طَهَّرَ مُوسَى المَذبَحَ، وَسَكَبَ الدَّمَ عِندَ قاعِدَةِ المَذبَحِ. وَهَكَذا قَدَّسَ مُوسَى المَذبَحَ وَعَمِلَ لَهُ كَفّارَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ثُمَّ أخَذَ الشَّحمَ الَّذِي عَلَى الأحشاءِ وَمُلحَقاتِ الكَبِدِ وَالكُلْيَتَينِ وَالشَّحمَ الَّذِي عَلَيهِما، وَأحرَقَهُ مُوسَى عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","وَأمّا بَقِيَّةُ الثَّورِ، جِلدُهُ وَلَحمُهُ وَرَوثُهُ، فَقَدْ أُحرِقَتْ خارِجَ المُخَيَّمِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ثُمَّ أُحضِرَ كَبْشُ الذَّبيحَةِ الصّاعِدَةِ إلَى الأمامِ، وَوَضَعَ هارُونُ وَأبناؤُهُ أيدِيَهُمْ عَلَى رَأسِ الكَبْشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","وَذَبَحَهُ مُوسَى وَرَشَّ الدَّمَ عَلَى جَوانِبِ المَذبَحِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ثُمَّ قُطِّعَ الكَبْشُ إلَى أجْزاءَ. وَأحرَقَ مُوسَى الرَّأسَ وَالأجزاءَ وَالشَّحمَ عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","وَغُسِلَتِ الأحشاءُ وَالسِّيقانُ بِالماءِ، وَأحرَقَ مُوسَى كُلَّ الكَبْشِ عَلَى المَذبَحِ. هَذِهِ ذَبيحَةٌ صاعِدَةٌ لِرائِحَةٍ مُسِرَّةٍ، تَقدِمَةٌ للهِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ثُمَّ أُحضِرَ كَبْشُ التَّكْرِيسِ، الكَبْشُ الثّانِي، إلَى الأمامِ، وَوَضَعَ هارُونُ وَأبناؤُهُ أيدِيَهُمْ عَلَى رَأسِ الكَبْشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","وَذَبَحَهُ مُوسَى وَأخَذَ بَعضاً مِنْ دَمِهِ وَوَضَعَهُ عَلَى شَحمَةِ الأُذُنِ اليُمنَى لِهارُونَ وَعَلَى إبهامِ يَدِهِ اليُمنَى وَعَلَى إبهامِ رِجلِهِ اليُمنَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ثُمَّ أُحضِرَ أبناءُ هارُونَ إلَى الأمامِ، وَوَضَعَ مُوسَى بَعضَ الدَّمِ عَلَى شَحمَةِ آذانِهِمِ اليُمنَى وَعَلَى أباهِمِ أيديهِمِ اليُمنَى وَعَلَى أباهِمِ أرجُلِهِمِ اليُمنَى، ثُمَّ رَشَّ مُوسَى الدَّمَ عَلَى كُلِّ جَوانِبِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ثُمَّ أخَذَ مُوسَى الشَّحمَ: شَحمَ الذَّيلِ وَالشَّحمَ الَّذِي عَلَى الأحشاءِ وَمُلحَقاتِ الكَبِدِ وَالكُلْيَتَينِ وَشَحمَهُما وَالفَخذَ اليُمنَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","وَمِنْ سَلَّةِ الخُبزِ غَيرِ المُختَمِرِ الَّتِي كانَتْ فِي حَضرَةِ اللهِ، أخَذَ مُوسَى رَغِيفَ خُبزٍ غَيرَ مُختَمِرٍ وَكَعكَةً مَعمُولَةً بِزَيتٍ وَرَقائِقَ، وَوَضَعَ كُلَّ هَذا عَلَى الشَّحمِ وَعَلَى الفَخذِ اليُمنَى لِلكَبْشِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","وَوَضَعَ كُلَّ هَذا عَلَى كَفَّيِّ هارُونَ وَكُفُوفِ أبْنائِهِ، ثُمَّ رَفَعَهُ مُوسَى تَقْدِمَةً فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ثُمَّ أخَذَهُ مُوسَى مِنْ عَلَى كُفُوفِهِمْ وَأحرَقَهُ عَلَى المَذبَحِ مَعَ الذَّبيحَةِ الصّاعِدَةِ. هَذِهِ هِيَ تَقدِمَةُ تَكْرِيسٍ لِلكَهَنَةِ، كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ثُمَّ أخَذَ مُوسَى الصَّدرَ وَرَفَعَهُ تَقْدِمَةً فِي حَضرَةِ اللهِ. كانَ الصَّدرُ حِصَّةَ مُوسَى مِنْ كَبْشِ تَكْرِيسِ الكَهَنَةِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ثُمَّ أخَذَ مُوسَى بَعضاً مِنْ زَيتِ المَسحَةِ وَالدَّمِ اللَّذَينِ عَلَى المَذبَحِ، وَرَشَّهُ عَلَى هارُونَ وَثِيابِهِ وَأبْنائِهِ وَثِيابِهِمْ. هَكَذا كَرَّسَ مُوسَى هارُونَ وَثِيابَهُ وَأبناءَهُ وَثِيابَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","وَقالَ مُوسَى لِهارُونَ وَأبْنائِهِ: «اطبُخُوا اللَّحمَ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ، وَكُلُوهُ هُناكَ مَعَ خُبزِ تَعيِينِكُمْ كَكَهَنَةٍ الَّذِي فِي السَّلَّةِ، كَما أمَرَنِي اللهُ بِقَولِهِ: ‹عَلَى هارُونَ وَأبْنائِهِ أنْ يَأكُلُوهُ.› ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","وَما يَتَبَقَّى مِنَ اللَّحمِ وَالخُبزِ تَحرِقُونَهُ بِالنّارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","لا تَخرُجُوا مِنْ خَيمَةِ الاجْتِماعِ لِسَبعَةِ أيّامٍ إلَى يَومِ إتمامِ فَترَةِ تَكْرِيسِكُمْ كَكَهَنَةٍ. فَمَراسِمُ تَعيِينِكُمْ سَتَدُومُ لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","أمَرَ اللهُ بِعَمَلِ ما تَمَّ عَمَلُهُ اليَومَ لِلتَّكفِيرِ عَنكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","فَامْكُثوا عِنْدَ مَدخَلِ خَيمَةِ الاجْتِماعِ نَهاراً وَلَيلاً لِفَترَةِ سَبعَةِ أيّامٍ. احْفَظُوا وَصِيَّةَ اللهِ لِئَلّا تَمُوتُوا. لِأنَّ اللهَ أمَرَنِي بِهَذا.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","فَفَعَلَ هارُونُ وَأبناؤُهُ كُلَّ هَذِهِ الأُمُورِ الَّتِي أمَرَ اللهُ بِها عَلَى فَمِ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","وَفِي اليَومِ الثّامِنِ، دَعا مُوسَى هارُونَ وَأبناءَهُ وَشُيُوخَ إسْرائِيلَ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","وَقالَ لِهارُونَ: «خُذْ عِجلاً لا عَيبَ فِيهِ لِذَبِيحَةِ الخَطِيَّةِ، وَكَبْشاً لا عَيبَ فِيهِ ذَبِيحَةً صّاعِدَةِ، وَقَدِّمْهُما فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","وَقُلْ لِبَنِي إسْرائِيلَ: ‹خُذُوا تَيساً مِنَ الماعِزِ لِذَبِيحَةِ الخَطِيَّةِ، وَعِجلاً وَحَمَلاً عُمْرُ كُلٍّ مِنْهُما سَنَةٌ وَلا عَيبَ فِيهِما لِلذَّبيحَةِ الصّاعِدَةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","وَثَوراً وَكَبْشاً لِذَبيحَتِي السَّلامِ لِذَبحِهِما فِي حَضْرَةِ اللهِ، وَتَقدِمَةَ طَحِينٍ بِزَيتٍ، وَذَلِكَ كُلُّهُ لِأنَّ اللهَ سَيَظهَرُ لَكُمُ اليَومَ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","فَأحضَرُوا ما أمَرَ بِهِ أمامَ خَيمَةِ الاجْتِماعِ. وَأتَى كُلُّ الشَّعبِ إلَى الأمامِ وَوَقَفُوا فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","فَقالَ مُوسَى: «هَذا هُوَ ما أمَرَكُمُ اللهُ بِأنْ تَعمَلُوهُ كَي يَظهَرَ مَجدُ اللهِ لَكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ثُمَّ قالَ مُوسَى لِهارُونَ: «تَقَدَّمْ إلَى المَذبَحِ وَقَدِّمْ ذَبِيحَةَ الخَطِيَّةِ وَالذَّبيحَةَ الصّاعِدَةَ اللَّتَينِ لَكَ، وَاعْمَلْ ما يَنبَغِي لِعَمَلِ كَفّارَةٍ لَكَ وَلِلشَّعبِ، وَقَدِّمْ تَقدِماتِ الشَّعبِ وَاعْمَلْ ما يَنبَغِي لِعَمَلِ كَفّارَةٍ لَهُمْ، كَما أمَرَ اللهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","فَتَقَدَّمَ هارُونُ إلَى المَذبَحِ، وَذَبَحَ عِجلَ ذَبيحَةِ الخَطِيَّةِ الَّذِي كانَ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","وَأحضَرَ أبْناؤُهُ الدَّمَ، فَغَمَسَ إصبَعَهُ فِي الدَّمِ وَوَضَعَ بَعضاً مِنْهُ عَلَى زَوايا المَذبَحِ، وَسَكَبَ بَقِيَّةَ الدَّمِ عِندَ قاعِدَةِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ثُمَّ أحرَقَ الشَّحمَ وَالكُلْيَتَينِ وَمُلحَقاتِ الكَبِدِ الَّتِي مِنْ ذَبِيحَةِ الخَطِيَّةِ عَلَى المَذبَحِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","وَأُحرَقَ اللَّحمُ وَالجِلدُ بِنارٍ خارِجَ المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ثُمَّ ذَبَحَ هارُونُ كَبْشَ الذَّبيحَةِ الصّاعِدَةِ. وَأحضَرَ أبناؤُهُ الدَّمَ، فَسَكَبَهُ عَلَى جَوانِبِ المَذْبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","وَقَدَّمُوا لَهُ الذَّبيحَةَ الصّاعِدَةَ مُقَطَّعَةً مَعَ رَأْسِها، فَأحرَقَها هارُونُ عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ثُمَّ غَسَلَ الأحشاءَ وَالسِّيقانَ وَأحرَقَها مَعَ الذَّبيحَةِ الصّاعِدَةِ عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ثُمَّ أحضَرَ تَقدِمَةَ الشَّعبِ، فَأخَذَ تَيسَ الماعِزِ لِذَبِيحَةِ خَطِيَّةِ الشَّعبِ، وَذَبَحَهُ، وَقَدَّمَهُ ذَبِيحَةَ خَطِيَّةٍ مِثلَ أوَّلِ ذَبِيحَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ثُمَّ أحْضَرَ الذَّبيحَةَ الصّاعِدَةَ وَقَدَّمَها بِالطَريقَةِ المَقْبُولَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ثُمَّ أحضَرَ تَقدِمَةَ الطَّحِينِ، وَأخَذَ مِنْها مِقدارَ مِلءِ كَفِّهِ وَأحرَقَهُ عَلَى المَذبَحِ مَعَ ذَبيحَةِ الصَّباحِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ثُمَّ ذَبَحَ هارُونُ الثَّورَ وَالكَبْشَ ذَبائِحَ سَلامٍ لِلشَّعبِ، وَقَدَّمَ أبْناؤُهُ الدَّمَ لَهُ، فَسَكَبَهُ عَلَى جَوانِبِ المَذْبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","وَقَدَّمَ أبْناؤُهُ لَهُ شَحْمَ الثَّورِ وَالكَبْشِ: الذَّيلَ وَالشَّحمَ الَّذِي يُغَطِّي الأحشاءَ وَالكُلْيَتَينِ وَمُلحَقاتِ الكَبِدِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","وَوَضَعُوا الشَّحمَ عَلَى الصَّدرَينِ وَأحرَقَهُما مَعاً عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","وَرَفَعَ هارُونُ الصَّدرَينِ وَالفَخذَ اليُمنَى تَقدِمَةً فِي حَضرَةِ اللهِ، كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ثُمَّ رَفَعَ هارُونُ يَدَيهِ نَحوَ الشَّعبِ وَبارَكَهُمْ. وَبَعدَ أنِ انتَهَى مِنْ تَقدِيمِ ذَبِيحَةِ الخَطِيَّةِ وَالذَّبيحَةِ الصّاعِدَةِ وَذَبِيحَةِ السَّلامِ، نَزَلَ مِنْ عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ثُمَّ دَخَلَ مُوسَى وَهارُونُ إلَى خَيمَةِ الاجْتِماعِ. وَحِينَ خَرَجا، بارَكا الشَّعبَ، حِينَئِذٍ، ظَهَرَ مَجدُ اللهِ لِلشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","وَخَرَجَتْ نارٌ مِنْ مَحضَرِ اللهِ وَأحرَقَتِ الذَّبيحَةَ الصّاعِدَةَ وَالشَّحمَ اللَّذَينِ عَلَى المَذبَحِ. وَرَأى كُلُّ الشَّعبِ ذَلِكَ، وَهَتَفُوا، وَرَكَعُوا وَوُجُوهُهُمْ إلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","وَأخَذَ ابْنا هارُونَ، نادابُ وَأبِيهُو، كُلُّ واحِدٍ مِجمَرَتَهُ، وَوَضَعا فِيهما ناراً، وَوَضَعا عَلَى النّارِ بَخُوراً، وَقَدَّما فِي حَضْرَةِ اللهِ ناراً مِنْ مَصدَرٍ غَرِيبٍ لَمْ يَأْمُرْهُما اللهُ بِاستِخدامِها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","فَخَرَجَتْ نارٌ مِنْ مَحضَرِ اللهِ وَأحرَقَتْهُما، فَماتا فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","حِينَئِذٍ، قالَ مُوسَى لِهارُونَ: «هَذا ما قَصَدَهُ اللهُ بِقَولِهِ: ‹سَأتَقَدَّسُ بِالكَهَنَةِ الَّذِينَ يَقتَرِبُونَ إلَيَّ، وَسَأتَمَجَّدُ أمامَ كُلِّ الشَّعبِ.›» وَكانَ هارُونُ صامِتاً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","وَدَعا مُوسَى مِيشائِيلَ وَألْصافانَ ابْنَي عُزِّيئِيلَ، عَمِّ هارُونَ. وَقالَ لَهُما: «تَعالا وَاحْمِلا قَرِيبَيكُما إلَى خارِجِ المُخَيَّمِ مِنْ أمامِ المَكانِ المُقَدَّسِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","فَأتَيا وَحَمَلاهُما إلَى خارِجِ المُخَيَّمِ وَهُما فِي ثِيابِهِما الخاصَّةِ، كَما قالَ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ثُمَّ قالَ مُوسَى لِهارُونَ وَابْنَيهِ، ألِيعازارَ وَإيثامارَ: «لا تَشُدُّوا شَعرَكُمْ وَلا تُمَزِّقُوا ثِيابَكُمْ، لِئَلّا تَمُوتُوا، وَلِئَلّا يَغضَبَ اللهُ عَلَى كُلِّ الشَّعبِ. وَأمّا أقرِباؤكُمْ، كُلُّ بَنِي إسْرائِيلَ، فَيُمكِنُهُمْ أنْ يَبكُوا بِسَبَبِ إحراقِ اللهِ لِنادابَ وَأبِيهُو. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","لا تَخرُجُوا إلَى خارِجِ مَدْخَلِ خَيمَةِ الاجْتِماعِ، وَإلّا فَإنَّكُمْ سَتَمُوتُونَ، لِأنَّ زَيتَ مَسحَةِ اللهِ عَلَيكُمْ.» فَعَمِلُوا كَما قالَ مُوسَى لَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ثُمَّ قالَ اللهُ لِهارُونَ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«لا تَشرَبْ أنتَ وَابْناؤكَ خَمْراً وَلا شَراباً مُسكِراً حِينَ تَدخُلُونَ إلَى خَيمَةِ الاجْتِماعِ لِئَلّا تَمُوتُوا. هَذِهِ شَرِيعَةٌ دائِمَةٌ لَكُمْ جِيلاً بَعْدَ جِيلٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","مَيِّزُوا بَينَ ما هُوَ مُقَدَّسٌ وَما هُوَ نَجِسٌ، وَبَينَ ما هُوَ طاهِرٌ وَما هُوَ نَجِسٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","لِأنَّكُمْ سَتُعَلِّمُونَ بَنِي إسْرائِيلَ كُلَّ الشَّرائِعِ الَّتِي أعطاها اللهُ لَهُمْ مِنْ خِلالِ مُوسَى.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","وَقالَ مُوسَى لِهارُونَ وَابْنَيهِ الباقِيَينِ، ألِيعازارَ وَإيثامارَ: «خُذُوا تَقدِمَةَ الطَّحِينِ الباقِيَةِ مِنْ تَقدِماتِ اللهِ، وَكُلُوها بِلا خَمِيرٍ بِجانِبِ المَذبَحِ، لِأنَّها نَصِيبٌ مُخَصَّصٌ لِلكَهَنَةِ بِالكامِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","كُلُوها فِي مَكانٍ مُقَدَّسٍ لِأنَّها حِصَّتُكَ وَحِصَّةُ أبْنائِكَ مِنْ تَقدِماتِ اللهِ، لِأنَّ اللهَ أمَرَنِي بِهَذا. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","«وَأمّا صَدرُ وَفَخذُ التَّقدِمَةِ اللَّذانِ رَفَعَهُما الكَاهِنُ قِي حَضرَةِ اللهِ، فَتَأكُلُونَهما فِي مَكانٍ طاهِرٍ أنتَ وَأبناؤُكَ. قَدْ أُعطِيا كَحِصَّةٍ لَكَ وَلِأبنائِكَ مِنْ ذَبائِحِ السَّلامِ الَّتِي يُقَدِّمُها بَنُو إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","يُقَدِّمُ الشَّعبُ السّاقَ وَالصَّدرَ المَرْفُوعانِ فِي حَضرَةِ اللهِ مَعَ تَقدِماتِ الشَّحمِ المُعَدَّةِ بِالنّارِ إلَى مَحْضَرِ اللهِ. هَذِهِ حِصَّتُكَ الدّائِمَةُ أنتَ وَأبناؤُكَ كَما أمَرَ اللهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ثُمَّ سَألَ مُوسَى عَنْ تَيسِ الخَطِيَّةِ، وَكانَ قَدِ احْتَرَقَ. فَغَضِبَ مُوسَى عَلَى ألِيعازارَ وَإيثامارَ، ابْنَي هارُونَ الباقِيَينِ، وَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«لِماذا لَمْ تَأكُلا ذَبِيحَةَ الخَطِيَّةِ فِي مَكانٍ مُقَدَّسٍ؟ فَهِيَ نَصِيبٌ مُخَصَّصٌ لَكُما بِالكامِلِ، وَقَدْ أعطاها اللهُ لَكُما لإزالَةِ ذَنبِ الشَّعبِ وَعَمَلِ كَفّارَةٍ لَهُ فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","لَمْ يُحْضَرْ دَمُهُما إلَى داخِلِ المَكانِ المُقَدَّسِ، لِذا كانَ يَنبَغِي أنْ تَأكُلاها فِي المَكانِ المُقَدَّسِ كَما أمَرْتُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","فَقالَ هارُونُ لِمُوسَى: «لَقَدْ قَدَّما اليَومَ عَنْهُما ذَبِيحَتَي خَطِيَّةٍ وَتَقدِمَتَينِ صاعِدَتَينِ، وَانظُرْ ما الَّذِي حَدَثَ! فَهَلْ يَرضَى اللهُ بِأنْ آكُلَ هَذِهِ الذَّبائِحَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","وَحِينَ سَمِعَ مُوسَى هَذا اقتَنَعَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","وَكَلَّمَ اللهُ مُوسَى وَهارُونَ فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«بَيِّنا لِبَنِي إسْرائِيلَ ما هِيَ الحَيواناتُ الَّتِي يُمكِنُهُمْ أنْ يَأكُلُوها مِنْ الحَيواناتِ البَرِّيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","يُسْمَحُ لَكُمْ أنْ تَأكُلُوا أيَّ حَيوانٍ لَهُ حافِرٌ مَشقُوقٌ وَيَجتَرُّ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","«لَكِنْ لا تَأكُلُوا الحَيواناتِ الَّتِي تَجتَرُّ وَلَيسَ لَها حافِرٌ مَشقُوقٌ. لا تَأكُلُوا الجَمَلَ، فَهُوَ يَجتَرُّ لَكِنْ لَيسَ لَهُ حافِرٌ مَشْقُوقٌ، فَهُوَ نَجِسٌ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","لا تَأكُلُوا الغَرِيرَ فَهُوَ يَجتَرُّ لَكِنْ لَيسَ لَهُ حافِرٌ مَشْقُوقٌ، فَهُوَ نَجِسٌ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","لا تَأكُلُوا الأرنَبَ، فَهُوَ يَجتَرُّ، لَكِنْ لَيسَ لَهُ حافِرٌ مَشْقُوقٌ، فَهُوَ نَجِسٌ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","لا تَأكُلُوا الخِنزِيرَ، إذْ لَهُ حافِرٌ مَشقُوقٌ، لَكِنَّهُ لا يَجتَرُّ، فَهُوَ نَجِسٌ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","لا تَأكُلُوا مِنْ لَحمِ هَذِهِ الحَيَواناتِ وَلا تَلمِسُوا جُثَثَها، فَهِيَ نَجِسَةٌ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«وَمِنَ الحَيواناتِ البَحرِيَّةِ تَأكُلُونَ كُلَّ شَيءٍ يَعِيشُ فِي الماءِ – فِي البِحارِ أوِ الأنهارِ – وَلَهُ زَعانِفُ وَحَراشِفُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","أمّا ما يَعِيشُ فِي البِحارِ أوِ الأنهارِ وَلَيسَتْ لَهُ زَعانِفُ وَحَراشِفُ مِنْ كُلِّ الكائِناتِ الَّتِي تَزحَفُ فِي الماءِ أوِ الكائِناتِ المائِيَّةِ الأُخرَى، فَمُحَرَّمٌ عَلَيْكُمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","وَسَيبقَى مُحَرَّماً. فَلا تَأكُلُوا لَحمَها وَلا تَلمِسُوا جُثَثَها كَي لا تَتَنَجَّسُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","كُلُّ كائِنٍ فِي الماءِ لَيسَتْ لَهُ زَعانِفُ وَحَراشِفُ يَكُونُ مُحَرَّماً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«وَتَمقُتُونَ الطُّيُورَ التّالِيَةَ فَلا تَأكُلُوها لأنَّها نَجِسَةٌ: النَّسرَ وَالأنُوقَ وَالعُقابَ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","وَالحِدَأةَ وَكُلَّ أنواعِ الصُّقُورِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","وَكُلَّ أنواعِ الغِربانِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","وَالنَّعامَةَ وَالخُطّافَ وَالنَّورَسَ وَكُلَّ أنواعِ البازِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","وَالبُومَ وَالغَوّاصَ وَالكُرْكِيَّ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","وَالبَجَعَ وَالقُوقَ وَالرَّخَمَ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","وَاللَّقلَقَ وَمالِكِ الحَزِينِ بِأنْواعِهِ وَالهُدهُدَ وَالخَفّاشَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«لا تَأكُلُوا كُلَّ حَشَرَةٍ لَها أجنِحَةٌ وَتَسِيرُ عَلَى أربَعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","وَلَكِنْ تَأكُلُونَ الحَشَراتِ الَّتِي لَها أجنِحَةٌ وَتَسِيرُ عَلَى أربَعِ فَقَطْ إنْ كانَ لِسِيقانِها مَفاصِلُ فَوقَ رِجلَيها لِتَقفِزَ بِهِما عَلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","فَتَأكُلُونَ كُلَّ أنواعِ الجَرادِ وَكُلَّ أنواعِ الدَّبا وَكُلَّ أنواعِ الحَرْجُوانِ وَكُلَّ أنواعِ الجَنادِبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","«وَأمّا الحَشَراتُ الَّتِي لَها أجنِحَةٌ وَتَسِيرُ عَلَى أربَعِ، فامْتَنِعُوا عَنْها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","هَذِهِ الكائِناتُ تُنَجِّسُكُمْ. فَكُلُّ مَنْ يَلمِسُ جُثَثَها يَكُونُ نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","وَكُلُّ مَنْ يَحمِلُ جُزءاً مِنْ جُثَثِها، فَلِيَغْسِلْ ثِيابَهُ. وَسَيَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","«كُلُّ حَيوانٍ لَهُ حافِرٌ غَيرُ مَشقُوقٍ، أوْ لا يَجتَرُّ، هُوَ نَجِسٌ لَكُمْ، وَكُلُّ مَنْ يَلمِسُهُ يَصِيرُ نَجِساً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","كَذَلِكَ كُلُّ مَنْ يَمْشِي عَلَى خُفٍّ مِنَ الحَيواناتِ الَّتِي تَمْشِي عَلَى أربَعَ، فَهُوَ نَجِسٌ لَكُمْ، وَكُلُّ مَنْ يَلمِسُها يَصِيرُ نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","وَكُلُّ مَنْ يَحمِلُ جُثَثَها، لِيَغْسِلْ ثِيابَهُ. وَسَيَبقَى نَجِساً إلَى المَساءِ. إنَّها نَجِسَةٌ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«وَالحَيواناتُ الزّاحِفَةُ الَّتِي تَزحَفُ عَلَى الأرْضِ نَجِسَةٌ لَكُمْ: الخُلْدُ وَالفَأْرُ وَكُلُّ أنواعِ السَّحالِي الكَبيرَةُ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","وَالحَرذُونُ وَالتِمْساحَ وَالعَضاءَةُ وَسِحلِيَّةُ الرَّملِ وَالحِرباءُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","هَذِهِ الحَيواناتُ الزّاحِفَةُ نَجِسَةٌ لَكُمْ، وَكُلُّ مَنْ يَلمِسُ جُثَثَها يَكُونُ نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","«إنْ وَقَعَ أيٌّ مِنَ الحَيواناتِ النَّجِسَةِ المَيِّتَةِ عَلَى شَيءٍ، فَإنَّهُ يَكُونُ نَجِساً. أيِّ وِعاءٍ خَشَبِيٍّ أوْ ثِيابٍ أوْ جِلْدٍ أوْ قُماشٍ مِنْ شَعرِ الماعِزِ أوْ أيَّةِ أداةٍ تُستَخدَمُ لِأيِّ غَرَضٍ تُوضَعُ فِي الماءِ، وَسَتَبقَى نَجِسَةً إلَى المَساءِ حَيثُ تُصبِحُ طاهِرَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","إنْ سَقَطَ أيٌّ مِنْها فِي وِعاءٍ خَزَفِيٍّ، فَإنَّ أيَّ شَيءٍ فِي الوِعاءِ يُصبِحُ نَجِساً. فاكْسِرِ الوِعاءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","إنِ انْسَكَبَ ماءٌ مِنْ وِعاءٍ نَجِسٍ عَلَى أيِّ طَعامٍ طاهِرٍ فَإنَّهُ يَصِيرُ نَجِساً. وَكُلُّ شَرابٍ يُوضَعُ فِي وِعاءٍ نَجِسٍ، يَصِيرُ نَجِساً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","وَإنْ سَقَطَ أيُّ جُزءٍ مِنْ جُثَثِها عَلَى أيِّ شَيءٍ، فَإنَّهُ يَصِيرُ نَجِساً. فَإنْ وَقَعَ عَلَى تَنُّورٍ أوْ فُرنٍ، يَنبَغِي أنْ يُهدَمَ. كُلُّ هَذِهِ الأشْياءِ تَصيرُ نَجِسَةً، وَتَبقَى نَجِسَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","«وَأمّا النَّبعُ أوِ البِئْرُ اللَّذانِ يَجمَعانِ الماءَ فَيَبقَيانِ طاهِرَينِ، لَكِنْ كُلُّ شَخصٍ يَلمِسُ الجُثَثَ السَّاقِطَةَ فِي الماءِ يَصِيرُ نَجِساً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","وَإنْ وَقَعَ مِنْ جُثَثِها عَلَى بُذُورٍ لِلزِراعَةِ فَإنَّها تَبقَى طاهِرَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","لَكِنْ إنْ كانَ عَلَى البُذُورِ ماءٌ، وَسَقَطَ عَلَيها أيُّ جُزءٍ مِنْ جُثَثِها، فَإنَّ البُذُورَ تُصبِحُ نَجِسَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«وَإنْ ماتَ حَيوانٌ مِنَ الحَيواناتِ الَّتِي تَأكُلُونَها، فَمَنْ يَلمِسُ جُثَّتَهُ يَكُونُ نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","كُلُّ مَنْ يَأكُلُ مِنْ جُثَّتِهِ، فَليَغْسِلْ ثِيابَهُ. وَسَيَكُونُ نَجِساً إلَى المَساءِ. وَكَذَلِكَ كُلُّ مَنْ يَحمِلُهُ، فَليَغْسِلْ ثِيابَهُ. وَسَيَكُونُ نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«كُلُّ كائِنٍ يَزحَفُ عَلَى الأرْضِ مَكْرُوهٌ فَلا تَأكُلُوهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","لا تَأكُلُوا أيَّ كائِنٍ يَزحَفُ عَلَى الأرْضِ عَلَى بَطنِهِ أمْ عَلَى أربَعِ أمْ عَلَى أقدامٍ كَثِيرَةٍ، فَإنَّهُ مَكرُوهٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","لا تُدَنِّسُوا أنفُسَكُمْ بِأيِّ حَيوانٍ زاحِفٍ. لا تُنَجِّسُوا أنفُسَكُمْ بِها فَتَصِيرُوا نَجِسِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","لِأنِّي أنا إلَهُكُمْ. احفَظُوا أنفُسَكُمْ مُقَدَّسِينَ لِأنِّي أنا قُدُّوسٌ. فَلا تُنَجِّسُوا أنفُسَكُمْ بِالحَيواناتِ الزّاحِفَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","لِأنِّي أنا اللهُ الَّذِي أخرَجَكُمْ مِنْ أرْضِ مِصْرَ لِأكُونَ إلَهَكُمْ. كُونُوا مُقَدَّسِينَ، لِأنِّي أنا قُدُّوسٌ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","هَذِهِ هِيَ الشَّرائِعُ المُتَعَلِّقَةُ بِالحَيواناتِ البَرِّيَة وَالطُّيُورِ وَالكائِناتِ البَحرِيَّةِ وَالحَيواناتُ الزّاحِفَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","وَذَلِكَ لِكَي يُمَيِّزَ الشَّعْبُ بَينَ النَّجِسِ وَالطّاهِرِ مِنَ الحَيواناتِ، وَما يُمكِنُ أكلُهُ مِنْها وَما لا يُمكِنُ أكلُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«قُلْ لِبَنِي إسْرائِيلَ: «إنْ حَبِلَتِ امْرأةٌ وَوَلَدَتْ طِفلاً ذَكَراً فَإنَّها تَكُونُ نَجِسَةً لِسَبعَةِ أيّامٍ. تَكُونُ نَجِسَةً كَما لَوْ أنَّها فِي فَترَةِ الحَيضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","وَفِي اليَومِ الثّامِنِ، يُختَنُ الطِّفلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","وَتَنتَظِرُ الأُمُّ ثَلاثَةً وَثَلاثِينَ يَوماً حَتَّى يَتَوَقَّفَ نَزفُ دَمِها. فِي هَذِهِ الفَترَةِ، لا يَنبَغِي أنْ تَلمِسَ أيَّ شَيءٍ مُقَدَّسٍ، أوْ أنْ تَدخُلَ المَكانَ المُقَدَّسَ، إلَى أنْ تَنتَهِيَ فَترَةُ تَطهِيرِها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","فَإنْ وَلَدَتْ أُنثَىً، فَإنَّها تَكُونُ نَجِسَةً لِأربَعَةَ عَشَرَ يَوماً كَما لَوْ أنَّها فِي فَترَةِ الحَيضِ. فَلْتَنْتَظِرْ سِتَّةً وَسِتِّينَ يَوماً حَتَّى يَتَوَقَّفَ نَزْفُ دَمِها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","«وَحِينَ تَكتَمِلُ فَترَةُ تَطهِيرِها – سَواءٌ أأنجَبَتْ وَلَداً أمْ بِنتاً – يَنبَغِي أنْ تُحضِرَ خَرُوفاً عُمْرُهُ سَنَةٌ واحِدَةٌ ذَبيحَةً صاعِدَةً، وَيَمامَةً أوْ حَمامَةً صَغِيرَةً ذَبِيحَةَ خَطِيَّةٍ. ثُمَّ تأتِي بِهِما إلَى مَدخَلِ خَيمَةِ الاجْتِماعِ، إلَى الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","فَيُقَدِّمُهُما الكاهِنُ فِي حَضْرَةِ اللهِ، وَيَعمَلُ لَها كَفّارَةً، فَتَصِيرَ طاهِرَةً مِنْ نَزْفِ دَمِها. هَذِهِ هِيَ شَرِيعَةُ المَرأةِ الَّتِي تَلِدُ ذَكَراً أوْ أُنثَىً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","فَإنْ لَمْ تَكُنْ قادِرَةً عَلَى تَقدِيمِ حَمَلٍ، فَلْتُقَدِّمْ يَمامَتينِ أوْ حَمامَتينِ صَغيرَتَينِ. واحِدَةً لِلذَّبيحَةِ الصّاعِدَةِ، وَالأُخرَى لِذَبِيحَةِ الخَطِيَّةِ. وَيَعمَلُ لَها الكاهِنُ كَفّارَةً، فَتَصِيرَ طاهِرَةً تَماماً.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","وَقالَ اللهُ لِمُوسَى وَهارُونَ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«إنْ كانَ لأحَدٍ نُتُوءٌ أوْ جَرَبٌ أوْ بُقَعٌ لامِعَةٌ عَلَى جِلدِهِ قَدْ تَتَحَوَّلُ إلَى بَرَصٍ، يُقَدَّمُ إلَى هارُونَ الكاهِنِ أوْ أحَدِ أبْنائِهِ الكَهَنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","فَيُعايِنُ الكاهِنُ الإصابَةَ الَّتِي عَلَى جِلدِهِ، فَإنْ كانَ شَعرُ البُقعَةِ المُصابَةِ قَدْ صارَ أبْيَضَ، وَتَعَمَّقَتِ الإصابَةُ فِي الجِلدِ، فَإنَّها تَكُونُ بَرَصاً. حِينَئِذٍ، يُعلِنُ الكاهِنُ بَعدَ فَحصِهِ أنَّهُ نَجِسٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","«لَكِنْ إنْ كانَتِ الإصابَةُ بُقعَةً بَيضاءَ لامِعَةً عَلَى جِلدِ جَسَدِهِ، وَلَمْ تَكُنْ أعمَقَ مِنَ الجِلدِ، وَلَمْ يَكُنِ الشَّعرُ الَّذِي عَلَيها أبْيَضَ، يَعزِلُ الكاهنُ المُصابَ بَعِيداً عَنِ النّاسِ لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ثُمَّ يُعايِنُهُ الكاهِنُ فِي اليَومِ السّابِعِ، فَإنْ رَأى أنَّ الإصابَةَ لَمْ يَتَغَيَّرْ مَنظَرُها، وَأنَّها لَمْ تَنتَشِرْ فِي الجِلدِ، يَعزِلُ الكاهِنُ المُصابَ لِسَبعَةِ أيّامٍ أُخْرَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","وَفِي اليَومِ السّابِعِ يُعايِنُهُ الكاهِنُ ثانِيَةً، فَإنْ رَأى أنَّ الإصابَةَ قَدِ انطَفَأ لَمَعانُها، وَأنَّها لَمْ تَنتَشِرْ فِي الجِلدِ، يُعلِنُ الكاهِنُ أنَّهُ طاهِرٌ. فَهُوَ مُصابٌ بِاحْمِرارٍ فِي الجِلْدِ. فَليَغسِلْ ثِيابَهُ فَقَطْ وَيَكُونُ طاهِراً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","«أمَّا إنِ انتَشَرَتِ الإصابَةُ فِي الجِلدِ بَعدَ أنْ عَرَضَ المُصابُ نَفسَهُ عَلَى الكاهِنِ لإعلانِ طَهارَتِهِ، فَإنَّه يَعُودُ إلَى الكاهِنِ ثانِيَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","فَإنْ نَظَرَ الكاهِنُ وَرَأى أنَّ الإصابَةَ قَدِ انتَشَرَتْ فِي الجِلدِ، يُعلِنُ أنَّهُ نَجِسٌ. إنَّهُ أبرَصُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«وَحِينَ يُصابُ أحَدُهُمْ بِالبَرَصِ، فَإنَّهُ يُقَدَّمُ إلَى الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","فَإنْ نَظَرَ الكاهِنُ وَرَأى نُتُوءاً فِي الجِلدِ، وَقَدْ صارَ بَعضُ الشَّعرِ أبْيَضَ مَعَ وُجُودِ لَحمٍ حَيٍّ مُتَقَرِّحٍ فِي النُّتُوءِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","فَإنَّهُ بَرَصٌ فِي جِلدِهِ. يُعلِنُ الكاهِنُ أنَّهُ نَجِسٌ، وَيَعزِلُهُ عَنِ النّاسِ بِسَبَبِ ذَلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","«وَإنِ انتَشَرَ البَرَصُ فِي الجِلدِ، وَغَطَّى كُلَّ جِلدِ المُصابِ مِنْ رَأسِهِ حَتَّى قَدَمَيهِ حَيثُما نَظَرَ الكاهِنُ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","فَحِينَئِذٍ، يَتَأكَّدُ الكاهِنُ مِنْ أنَّ البَرَصَ قَدْ غَطَّى كُلَّ الجَسَدِ تَماماً، وَيُعلِنُ أنَّهُ طاهِرٌ. فَقَدْ تَحَوَّلَ كُلُّ الجِلدِ إلَى اللَّونِ الأبْيَضِ، وَلِهَذا فَهُوَ طاهِرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","لَكِنْ إنْ رَأى الكاهِنُ لَحماً حَيّاً مُتَقَرِّحاً عَلَى جَسَدِهِ، فَإنَّهُ يَكُونُ نَجِساً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","فَيُعايِنُ الكاهِنُ اللَّحمَ الحَيَّ المُتَقَرِّحَ، وَيُعلِنَ أنَّ المُصابَ نَجِسٌ. فَاللَّحمُ الحَيُّ المُتَقَرِّحُ نَجِسٌ، لِأنَّهُ بَرَصٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","«فَإنْ صارَ اللَّحمُ المُتَقَرِّحُ أبْيَضَ ثانِيَةً، يَذهَبُ المُصابُ إلَى الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","فَإنْ رَأى الكاهِنُ أنَّ المِنطَقَةَ المُصابَةَ قَدْ صارَتْ كُلُّها بَيضاءَ، يُعلِنُ أنَّهُ طاهِرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«وَإنْ ظَهَرَ دُمَّلٌ عَلَى جِلدِ إنسانٍ وَشُفِيَ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","وَنَشَأ نُتُوءٌ أوْ بُقَعٌ لامِعَةٌ بَيضاءُ مُحمَرَّةٌ فِي مَكانِ الدُّمَّلِ، يَذهَبُ المُصابُ إلَى الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","فَيُعايِنُ الكاهِنُ النُّتُوءَ أوِ البُقَعَ. فَإنْ كانَتْ غائِرَةً فِي جِلدِهِ وَسَطحُها أبْيَضُ، يُعلِنُ الكاهِنُ أنَّ المُصابَ نَجِسٌ. فَهَذا بَرَصٌ ظَهَرَ مِنَ الدُّمَّلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","لَكِنْ إنْ عَايَنَها الكاهِنُ، وَلَمْ يَكُنْ فِيها شَعرٌ أبْيَضُ، وَهِيَ غائِرَةٌ فِي الجِلدِ، وَقَدْ زالَ اللَّمَعانُ الَّذِي كانَ فِيها، يَعْزِلُ الكاهِنُ المُصابَ لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","فَإنِ انتَشَرَتْ فِي الجِلدِ، يُعلِنُ الكاهِنُ أنْ المُصابَ نَجِسٌ، فَهَذِهِ بُقْعَةُ التِهابٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","لَكِنْ إنْ بَقِيَتِ البُقعَةُ اللّامِعَةُ فِي مَكانِها، وَلَمْ تَنتَشِرْ، فَإنَّها نُدبَةٌ ناتِجَةٌ عَنِ الدُّمَّلِ. فَيُعلِنُهُ الكاهِنُ طاهِراً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«وَحِينَ يَكُونُ لَدَى شَخصٍ حَرقٌ عَلَى جِلدِهِ، وَاللَّحمُ الحَيُّ النّاتِجُ عَنِ الحَرقِ أبْيَضَ مُحمَرّاً، أوْ بُقعَةً بَيضاءَ لامِعَةً، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","يُعايِنُهُ الكاهِنُ، فَإنْ كانَ بَعضُ الشَّعرِ فِي البُقعَةِ الَّلامِعَةِ قَدْ صارَ أبْيَضَ، وَغائِراً فِي الجِلْدِ، فَإنَّهُ بَرَصٌ قَدْ نَشَأ عَنِ الحَرقِ. فَيُعلِنُ الكاهِنُ أنَّ المُصابَ نَجِسٌ، فَهُوَ بَرَصٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","لَكِنْ إنْ نَظَرَ الكاهِنُ إلَيهِ، وَلَمْ يَكُنْ هُناكَ شَعرٌ أبْيَضُ فِي البُقَعِ البَيضاءِ، وَلَمْ تَكُنِ البُقْعَةُ غائِرَةً فِي الجِلدِ، وَكانَ لَمَعانُها قَدْ زالَ، يَعْزِلُهُ الكاهِنُ لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","وَيُعايِنُ الكاهِنُ المُصابَ ثانِيَةً فِي اليَومِ السّابِعِ، فَإنْ كانَتِ البُقعَةُ البَيضاءُ الَّلامِعَةُ قَدِ انتَشَرَتْ فِي الجِلدِ، يُعلِنُ الكاهِنُ أنَّ المُصابَ نَجِسٌ. إنَّهُ بَرَصٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","لَكِنْ إنْ بَقِيَتِ البُقعَةُ الَّلامِعَةُ فِي مَكانِها، فَلَمْ تَنتَشِرْ فِي الجِلدِ، وَانطَفَأ لَمَعانُها، فَإنَّها تَكُونُ نُتُوءاً ناتِجاً عَنِ الحَرقِ. يُعلِنُ الكاهِنُ أنَّهُ طاهِرٌ، لِأنَّ تِلكَ البُقعَةَ نُدبَةٌ بِسَبِبِ الحَرقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«إنْ كانَتْ لَدَى رَجُلٍ أوِ امْرأةٍ بُقْعَةٌ عَلَى فَروَةِ الرَّأسِ أوِ الذَّقنِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","يُعايِنُ الكاهِنُ البُقْعَةَ، فَإنْ كانَتْ غائِرَةً فِي الجِلدِ وَكانَ الشَّعرُ أشقَرَ وَدَقِيقاً، يُعلِنُ الكاهِنُ أنَّهُ نَجِسٌ. إنَّهُ التِهابٌ جِلدِيٌّ، بَرَصٌ يُصِيبُ الرَّأسَ وَالذَّقنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","لَكِنْ إنْ نَظَرَ الكاهِنُ إلَى البُقْعَةِ، وَلَمْ تَكُنْ غائِرَةً فِي الجِلدِ لَكِنْ لَيسَ فِيها شَعرٌ أسوَدُ، فَيَعْزِلُ الكاهِنُ المُصابَ لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","وَيُعايِنُ الكاهِنُ البُقْعَةَ فِي اليَومِ السّابِعِ، فَإنْ رَأى أنَّها لَمْ تَنتَشِرْ وَأنَّهُ لا يُوجَدُ شَعرٌ أشقَرُ فِيها، وَأنَّ الاحْمِرارَ لَيسَ غائِراً فِي الجِلدِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","فَيَنبَغِي أنْ يَحلِقَ شَعْرَهُ، مِنْ دُونِ أنْ يَحلِقَ البُقْعَةَ المُحْمَرَّةَ. وَيَعْزِلُ الكاهِنُ المُصابَ ثانِيَةً لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","وَيُعايِنُ الكاهِنُ الاحْمِرارَ فِي اليَومِ السّابِعِ. فَإنْ لَمْ يَكُنْ قَدِ انتَشَرَ وَلا كانَ أعمَقَ مِنَ الجِلدِ، يُعلِنُ الكاهِنُ أنَّهُ طاهِرٌ. عَلَيهِ أنْ يَغسِلَ ثِيابَهُ فَيَصِيرُ طاهِراً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","لَكِنْ إنِ انتَشَرَ الاحْمِرارُ فِي الجِلدِ بَعدَ أنْ أُعلِنَ أنَّهُ طاهِرٌ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","يَعايِنُهُ الكاهِنُ، فَإنْ رَأى أنَّ الاحْمِرارَ قَدِ انتَشَرَ فِي الجِلدِ، فَإنَّ الكاهِنَ لا يَحتاجُ إلَى البَحثِ عَنْ شَعرٍ أشقَرَ، فَالمُصابُ نَجِسٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","لَكِنْ إنْ بَقِيَ مَنظَرُ الاحْمِرارِ بِلا تَغيِيرٍ، وَقَدْ نَما فِيهِ شَعرٌ أسوَدُ، فَإنَّ الاحْمِرارَ قَدْ شُفِيَ. فَهُوَ طاهِرٌ، وَيُعلِنُ الكاهِنُ أنَّهُ طاهِرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«إنْ كانَتْ لَدَى رَجُلٍ أوِ امْرأةٍ بُقَعٌ بَيضاءُ عَلَى جِلدِ جَسَدِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","يُعايِنُ الكاهِنُ الإصابَةَ. فَإنْ كانَتِ البُقَعُ الَّتِي عَلَى الجِلدِ بَيضاءَ كامِدَةً، فَإنَّهُ يَكُونُ التِهاباً جِلدِيّاً غَيرَ مُؤذٍ قَدْ ظَهَرَ عَلَى الجِلدِ، وَيَكُونُ الشَّخصُ طاهِراً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«حِينَ يَفقِدُ رَجُلٌ شَعرَ رَأْسِهِ فَإنَّهُ أصلَعُ، لَكِنَّهُ طاهِرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","إنْ كانَ يَفقِدُ شَعرَهُ مِنَ الجِهَةِ الأمامِيَّةِ لِرَأسِهِ فَإنَّهُ أصلَعُ الجَبهَةِ، لَكِنَّهُ طاهِرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","لَكِنْ إنْ ظَهَرَتْ بُقعَةٌ بَيضاءُ مُحمَرَّةٌ عَلَى بُقعَةِ الصَّلَعِ أعلَى الرَّأْسِ أوْ عَلَى الجَبهَةِ فَهَذا بَرَصٌ ظَهَرَ أعلَى رَأسِهِ أوْ عَلَى جَبهَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","يُعايِنُهُ الكاهِنُ، فَإنْ رَأى بُقْعَةً صارَتْ بَيضاءَ مُحمَرَّةً أعلَى رَأسِهِ أوْ عَلَى جَبهَتِهِ مِثلَ مَنظَرِ البَرَصِ الَّذِي يُصِيبُ الجَسَدَ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","فَإنَّ هَذا الرَّجُلَ مُصابٌ بِالبَرَصِ، وَلِهَذا فَهُوَ نَجِسٌ، يُعلِنُ الكاهِنُ هَذا الرَّجُلَ نَجِساً لِأنَّ رَأسَهُ مُصابٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«إنْ كانَ الشَّخصُ مُصاباً بِالبَرَصِ، فَلْيُمَزِّقْ ثِيابَهُ وَيَكشِفْ شَعرَهُ وَيُغَطِّ شارِبَيهِ وَيَصرُخْ: ‹أنا نَجِسٌ، أنا نَجِسٌ.› ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","وَيَكُونُ نَجِساً ما دامَ مُصاباً. إنَّهُ نَجِسٌ، لِذا يَعِيشُ وَحدَهُ خارِجَ المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«وَإنْ كانَ هُناكَ عَفَنٌ فِي قُماشٍ، كانَ صُوفاً أوْ كِتّاناً، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","مَنسُوجاً أوْ مُخاطاً مِنَ الكِتّانِ أوِ الصُّوفِ أوِ الجِلدِ أوْ أيِّ شَيءٍ مَصنُوعٍ مِنَ الجِلدِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","وَكانَتِ البُقعَةُ عَلَى القُماشِ أوِ الجِلدِ أوِ المادَةِ المَنسُوجَةِ أوِ المُخاطَةِ أوِ المَصنُوعَةِ مِنَ الجِلدِ، خَضراءَ أوْ حَمراءَ، فَإنَّها عَفَنٌ مُنتَشِرٌ وَيَنبَغِي أنْ تُعرَضَ عَلَى الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","يُعايِنُ الكاهِنُ البُقعَةَ المُصابَةَ وَيَضَعُ ذَلِكَ القُماشَ فِي مَكانٍ مُنعَزِلٍ لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","وَيُعايِنُ الكاهِنُ البُقعَةَ فِي اليَومِ السّابِعِ. فَإنْ كانَتِ البُقعَةُ قَدِ انتَشَرَتْ عَلَى القُماشِ أوِ المادَّةِ المَنسُوجَةِ أوِ المُخاطَةِ أوِ الجِلدِ أوْ أيِّ شَيءٍ يُصنَعُ مِنَ الجِلدِ، فَإنَّ البُقعَةَ تَكُونُ عَفَناً مُنتَشِراً، وَيَكُونُ ذَلِكَ الشَّيءُ نَجِساً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","يَحْرِقُ الكاهِنُ ذَلِكَ القُماشَ، سَواءٌ أكانَ مَنسُوجاً أمْ مُخاطاً أمْ كِتّاناً أمْ جِلداً عَلَيهِ عَفَنٌ، لِأنَّهُ عَفَنٌ مُنتَشِرٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","«فَإنْ نَظَرَ الكاهِنُ وَرَأى أنَّ البُقعَةَ لَمْ تَنتَشِرْ فِي القُماشِ، سَواءٌ أكانَ مِنْ مادَّةٍ مَنسُوجَةٍ أمْ مُخاطَةٍ أمْ مِنْ جِلدٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","يَأمُرُ بِغَسلِ ذَلِكَ القُماشِ الَّذِي عَلَيهِ البُقعَةُ، وَوَضْعِهِ فِي مَكانٍ مُنعَزِلٍ لِسَبعَةِ أيّامٍ أُخْرَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","وَبَعدَ أنْ يُغسَلَ القُماشُ الَّذِي عَلَيهِ البُقعَةُ، يُعايِنُهُ الكاهِنُ ثانِيَةً، فَإنْ رَأى أنَّ البُقعَةَ لَمْ يَتَغَيَّرْ لَونُها، وَأنَّ العَفَنَ لَمْ يَنتَشِرْ فَإنَّ القُماشَ يَكُونُ نَجِساً. يُحْرَقُ القُماشُ، سَواءٌ أكانَتِ البُقعَةُ فِي الجِهَةِ الأمامِيَّةِ أمِ الخَلفِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","«لَكِنْ إنْ فَحَصَ الكاهِنُ القُماشَ فَرَأى أنَّ البُقعَةَ قَدْ بَهَتَ لَونُها بَعدَ أنْ غُسِلَ القُماشُ، يَقُصُّ الكاهِنُ البُقعَةَ مِنَ الجِلدِ أوِ القُماشِ مَنسُوجاً كانَ أوْ مُخاطاً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","فَإنْ ظَهَرَتِ البُقَعُ ثانِيَةً فِي القُماشِ مَنسُوجاً كانَ أوْ مُخاطاً، أوْ فِي أيِّ شَيءٍ مَصنُوعٍ مِنَ الجِلدِ، فَقَدِ انتَشَرَ ثانِيَةً. يُحْرَقُ القُماشُ الَّذِي عَلَيهِ البُقعَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","لَكِنْ إنِ اختَفَتِ البُقعَةُ مِنَ القُماشِ – مَنسُوجاً كانَ أوْ مُخاطاً أوْ فِي الجِلدِ القابِلِ لِلغَسلِ – فَيَنبَغِي أنْ يُغسَلَ ثانِيَةً فَيَصِيرَ طاهِراً.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","هَذِهِ هِيَ الشَّرائِعُ المُتَعَلِّقَةُ بِعَفَنِ القُماشِ لِلحُكمِ فِي طَهارَتِهِ أوْ نَجاسَتِهِ، سَواءٌ أكانَ صُوفاً أمْ كِتّاناً – مَبْرُوماً أوْ مُخاطاً – أمْ مَصنُوعاً مِنَ جِلدٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«هَذِهِ شَرِيعَةُ الأبرَصِ حِينَ يُطَهَّرُ. «يَنبَغِي أنْ يُحضَرَ الشَّخصُ إلَى الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","فَيَخْرُجُ الكاهِنُ خارِجَ المُخَيَّمِ إلَى الشَّخصِ المُصابِ، فَإنْ عايَنَهُ الكاهِنُ وَرَآهُ قَدْ شُفِيَ مِنْ بَرَصِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","يَأمُرُ بِإحضارِ عُصفُورَينِ حَيَّينِ طاهرَينِ وَقِطعَةَ خَشَبِ أرزٍ وَخَيطاً أحمَرَ وَغُصْناً مِنْ نَباتِ الزُّوفا لِأجلِ الَّذِي تَطَهَّرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","وَيَأمُرُ الكاهِنُ بِذَبحِ أحَدِ العُصْفُورَينِ وَوَضعِ دَمِهِ فِي طَبَقٍ مِنْ فُخّارٍ فَوقَ ماءٍ جارٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ثُمَّ يَأخُذُ العُصفُورَ الحَيَّ وَقِطعَةَ خَشَبِ الأرْزِ وَالخَيطَ الأحمَرَ وَالزُّوفا، وَيَغمِسُها جَمِيعاً مَعَ العُصفُورِ الحَيِّ فِي دَمِ العُصفُورِ الَّذِي ذُبِحَ فَوقَ ماءٍ جارٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ثُمَّ يَرُشُّ الدَّمَ سَبعَ مَرّاتٍ عَلَى الشَّخصِ الَّذِي تَطَهَّرَ مِنَ البَرَصِ. بَعدَ ذَلِكَ، يُعلِنُ الشَّخصَ طاهِراً. وَيُطلِقُ الكاهِنُ العُصفُورَ الحَيَّ فِي سَهلٍ مَفتُوحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«وَعَلَى مَنْ تَطَهَّرَ أنْ يَغسِلَ ثِيابَهُ وَيَحلِقَ شَعرَهُ وَيَستَحِمَّ فِي ماءٍ، فَيَصِيرَ طاهِراً. ثُمَّ يَدخُلُ المُخَيَّمَ، لَكِنَّهُ يَبقَى خارِجَ خَيمَتِهِ لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","وَفِي اليَومِ السّابِعِ، يَحلِقُ كُلَّ شَعرِ رَأسِهِ وَذَقنِهِ وَحَواجِبِهِ. يَنبَغِي أنْ يَحلِقَ كُلَّ شَعرِهِ، وَأنْ يَغسِلَ ثِيابَهُ وَجَسَدَهُ فِي الماءِ، حِينَئِذٍ، يَكُونُ طاهِراً تَماماً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«وَفِي اليَومِ الثّامِنِ، يَأخُذُ حَمَلَينِ ذَكَرَينِ لا عَيبَ فِيهِما، وَنَعْجَةً واحِدَةً عُمْرُها سَنَةٌ لا عَيبَ فِيها، وَثَلاثَةَ أعْشارِ القُفَّةِ مِنَ الطَّحِينِ الجَيِّدِ مَمزُوجاً بِزَيتٍ، وَكُوباً وَاحِداً مِنْ زَيتِ الزَّيتُونِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","وَعَلَى الكاهِنِ الَّذِي يَقُوُمُ بالتَّطهِيرِ أنْ يُعِدَّ ذَلِكَ الإنسانَ لِيَتَطَهَّرَ، وَأنْ يُحْضِرَ هَذِهِ التَّقدِماتِ إلَى مَحْضَرِ اللهِ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ثُمَّ يَأخُذُ الكاهِنُ حَمَلاً ذَكَراً وَيُقَدِّمُهُ ذَبِيحَةَ ذَنبٍ مَعَ كُوبٍ مِنَ الزَّيتِ، وَيرفَعُهُا تَقدِمَةً فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","وَيَذبَحُ الحَمَلَ فِي مِنْطَقَةٍ مُقَدَّسَةٍ حَيثُ تُذبَحُ تَقدِمَةُ الذَّبيحَةِ الصّاعِدَةِ. وَلِأنَّ ذَبِيحَةَ الذَّنبِ هِيَ مِثلُ ذَبِيحَةِ الخَطِيَّةِ، فَإنَّها تَكُونُ مِنْ نَصِيبِ الكاهِنِ. إنَّها نَصِيبٌ مُخَصَّصٌ لِلكَهَنَةِ بِالكامِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","«وَيَأخُذُ الكاهِنُ بَعضَ دَمِ ذَبِيحَةِ الذَّنبِ، وَيَضَعَهُ عَلَى شَحمَةِ الأُذُنِ اليُمنَى لِلمُتَطَهِّرِ، وَعَلَى إبهامِ يَدِهِ اليُمنَى، وَعَلَى إبهامِ رِجلِهِ اليُمنَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ثُمَّ يَأخُذُ الكاهِنُ مِنْ كُوبِ الزَّيتِ، وَيَسكُبُ مِنهُ فِي كَفِّهِ الأيْسَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ثُمَّ يَغمِسُ إصبَعاً مِنْ يَدِهِ اليُمنَى فِي الزَّيتِ الَّذِي فِي كَفِّهِ الأيْسَرِ، وَيَرُشَّ بَعضَ الزَّيتِ بِإصبَعِهِ سَبعَ مَرّاتٍ فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","أمّا ما تَبَقَّى مِنَ الزَّيتِ فِي كَفِّهِ، فَيَضَعُهُ الكاهِنُ مِنْهُ عَلَى شَحمَةِ الأُذُنِ اليُمنَى لِلشَّخصِ المُتَطَهِّرِ، وَعَلَى إبهامِ يَدِهِ اليُمنَى وَإبهامِ رِجلِهِ اليُمنَى. فَوقَ دَمِ ذَبِيحَةِ الذَّنبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","وَما تَبّقَّى فِي كَفِّ الكاهِنِ يَضَعُهُ علَى رَأسِ المُتَطَهِّرِ. وَهَكَذا، يَعمَلُ لَهُ الكاهِنُ كَفّارَةً فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","«ثُمَّ يَذْبَحُ الكاهِنُ ذَبِيحَةَ الخَطِيَّةِ وَيُطَهِّرَ المُتَطَهِّرَ مِنْ نَجاسَتِهِ. ثُمَّ يَذبَحُ ذَبيحَةً صاعِدَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","يُقَدِّمُ الكاهِنُ الذَّبيحَةَ الصّاعِدَةَ وَتَقدِمَةَ الطَّحِينِ عَلَى المَذبَحِ. وَهَكَذا يَعِدُّ الكاهِنُ كَفّارَةً عَنْ خَطِيَّتِهِ، فَتُغفَرَ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«فَإنْ كانَ المُتَطَهِّرُ فَقِيراً، لا يَستَطِيعُ تَقدِيمَ تِلكَ الذَّبائِحِ، فَلْيَجلِبْ حَمَلاً ذَبِيحَةَ ذَنبٍ تُرفَعُ فِي حَضرَةِ اللهِ كَفّارَةً لِخَطاياهُ. كَما يُقَدِّمُ عُشَرَ قُفَّةٍ مِنَ الطَّحِينِ الجَيِّدِ مَمزُوجاً بِزَيتٍ، وَكُوباً وَاحِداً مِنْ زَيتِ الزَّيتُونِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","وَيَمامَتَينِ أوْ حَمامَتَينِ صَغِيرَتَينِ بِحَسَبِ قُدْرَتِهِ. فَتَكُونُ إحداهُما لِذَبِيحَةِ الخَطِيَّةِ، وَالثّانِيَةُ لِتَقدِمَةِ الذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","«يُحضِرُ المُتَطَهِّرُ هَذِهِ التَّقدِماتِ فِي اليَومِ الثّامِنِ مِنْ يَومِ تَطهِيرِهِ، إلَى الكاهِنِ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","فَيَأخُذُ الكاهِنُ الحَمَلَ لِذَبِيحَةِ الذَّنبِ وَكُوباً واحِداً مِنْ زَيتِ الزَّيتُونِ، وَيَرفَعُهما تَقدِمَةً فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ثُمَّ يُذبَحُ حَمَلُ ذَبِيحَةِ الذَّنبِ، وَيَأخُذُ الكاهِنُ بَعضَ دَمِ ذَبِيحَةِ الذَّنبِ وَيَضَعُهُ عَلَى شَحْمَةِ الأُذُنِ اليُمنَى لِلشَّخصِ المُتَطَهِّرِ، وَعَلَى إبهامِ يَدِهِ اليُمنَى وَعَلَى إبهامِ رِجلِهِ اليُمنَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","وَيَسكُبُ الكاهِنُ بَعضَ الزَّيتِ فِي كَفِّهِ الأيَسَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ثُمَّ يَرُشُّ الكاهِنُ بِإصبَعٍ مِنْ يَدِهِ اليُمنَى بَعضَ الزَّيتِ الَّذِي فِي كَفِّهِ الأيسَرِ سَبعَ مَرّاتٍ فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ثُمَّ يَضَعُ الكاهِنُ بَعضَ الزَّيتِ الَّذِي فِي كَفِّهِ عَلَى شَحمَةِ الأُذُنِ اليُمنَى لِلمُتَطَهِّرِ، وَعَلَى إبهامِ يَدِهِ اليُمنَى وَعَلَى إبهامِ رِجلِهِ اليُمنَى، عَلَى الأماكِنِ الَّتِي وُضِعَ عَلَيها مِنْ دَمِ ذَبِيحَةِ الذَّنبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","وَبَقِيَّةُ الزَّيتِ الَّذِي فِي كَفَّةِ الكاهِنِ، يَسْكُبُها عَلَى رَأسِ المُتَطَهِّرِ لِعَمَلِ كَفّارَةٍ لَهُ فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","«ثُمَّ يُقَدِّمُ الكاهِنُ إحْدَى اليَمامَتَينِ أوْ إحْدَى الحَمامَتَينِ الصَّغِيرَتَينِ، بِحَسَبِ قُدْرَةِ المُتَطَهِّرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","فَتَكُونُ إحداهُما لِذَبِيحَةِ الخَطِيَّةِ وَالأُخرَى لِلذَّبيحَةِ الصّاعِدَةِ، مَعَ تَقدِمَةِ الطَّحِينِ. وَهَكَذا يَعمَلُ الكاهِنُ لِلشَّخصِ المُتَطَهِّرِ كَفّارَةً فِي حَضْرَةِ اللهِ، فَيَصيرُ طاهِراً.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","هَذِهِ هِيَ شَرِيعَةُ المُصابِ بِالبَرَصِ. وَلا يَستَطِيعُ تَقدِيمَ الذَّبائِحِ وَالتَّقدِماتِ المُعْتادَةِ لِتَطهِيرِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","وَقالَ اللهُ لِمُوسَى وَهارُونَ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«حِينَ تَدخُلُونَ أرْضَ كَنعانَ الَّتِي سَأُعطِيها لَكُمْ مُلكاً، وَأرسَلْتُ عَفَناً عَلَى بَيتٍ فِي أرْضِكُمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","فَعَلَى صاحِبِ البَيتِ أنْ يَأتِيَ وَيُخبِرَ الكاهِنَ فَيَقُولُ: ‹رَأيتُ شَيئاً يُشبِهُ العَفَنَ فِي بَيتِي.› ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","فَيَأمُرُ الكاهِنُ بِإخراجِ كُلِّ شَيءٍ مِنَ البَيتِ قَبلَ أنْ يَأتِيَ الكاهِنُ لِيَفحَصَ العَفَنَ. فَإنْ عَمِلُوا هَذا فَإنَّ الأشياءَ الَّتِي فِي البَيتِ لَنْ تُصبِحَ نَجِسَةً. ثُمَّ يَأتِي الكاهِنُ لِيَرَى البَيتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ثُمَّ يُعايِنُ الكاهِنُ البَيتَ. وَيَفحَصُ الكاهِنُ العَفَنَ، فَإنْ كانَ العَفَنُ الَّذِي عَلَى جُدرانِ البَيتِ يَتَكَوَّنُ مِنْ بُقَعٍ حَمراءَ أوْ خَضراءَ غائِرَةٍ فِي سَطحِ الجِدارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","فَيَخْرُجُ الكاهِنُ مِنَ البَيتِ إلَى مَدخَلِهِ، وَيُغلِقُ البَيتَ لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","«وَيَعُودُ الكاهِنُ فِي اليَومِ السّابِعِ وَيُعايِنُ البَيتَ، فَإنِ انتَشَرَ العَفَنُ الَّذِي عَلَى جُدرانِ البَيتِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","يَأمُرُ بِنَزعِ الحِجارَةِ الَّتِي عَلَيْها العَفَنُ وَإلقائِها خارِجَ المَدِينَةِ فِي مَكانٍ نَجِسٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ثُمَّ يَأمُرُ الكاهِنُ بِقَشرِ كُلِّ الطِّينَةِ الدّاخِلِيَّةِ لِلبَيتِ، وَيُلْقَى التَّرابُ الَّذِي قَشَّرُوهُ إلَى خارِجِ المَدِينَةِ فِي مَكانٍ نَجِسٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ثُمَّ تُوضَعُ حِجارَةٌ أُخْرَى مَكانَ الحِجارَةِ الَّتِي أُزِيلَتْ، وَيُطَيَّنُ البَيتُ بِطِينَةٍ جَدِيدَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«فَإنْ عادَ العَفَنُ وَانتَشَرَ فِي البَيتِ بَعدَ أنْ أُزِيلَتِ الحِجارَةُ وَتَمَّ تَقشِيرُ البَيتِ وَتَطيِينُهُ مِنْ جَدِيدٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","فَحِينَئِذٍ، يَأتي الكاهِنُ وَيُعايِنُهُ. فِإنْ كانَ العَفَنُ قَدِ انتَشَرَ فِي البَيتِ، فَهُوَ عَفَنٌ مُفسِدٌ وَمُتلِفٌ لِلبَيتِ وَما فِيهِ. إنَّهُ بَيتٌ نَجِسٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","يَنبَغِي هَدمُ البَيتِ، حِجارَتِهِ وَخَشَبِهِ وَكُلِّ طِينَتِهِ، وَإحضارِها إلَى خارِجِ المَدِينَةِ، إلَى مَكانٍ نَجِسٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","كُلُّ شَخصٍ يَدخُلُ البَيتَ خِلالَ فَترَةِ إغلاقِهِ يَكُونُ نَجِساً إلَى المَساءِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","وَكُلُّ شَخصٍ يَنامُ فِي البَيتِ يَنبَغِي أنْ يَغسِلَ ثِيابَهُ. وَكُلُّ شَخصٍ يَأكُلُ فِي البَيتِ يَنبَغِي أنْ يَغسِلَ ثِيابَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«لَكِنْ إنْ أتَى الكاهِنُ وَرَأى البَيتَ، وَلَمْ يَكُنِ العَفَنُ قَدِ انتَشَرَ فِي البَيتِ بَعدَ أنْ تَمَّ تَطيِينُ البَيتِ ثانِيَةً، فَإنَّ الكاهِنَ يُعلِنُ البَيتَ طاهِراً لِأنَّ العَفَنَ قَدْ زالَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","وَلِتَطهِيرِ البَيتِ، يَأخُذُ الكاهِنُ عُصفُورَينِ وَقِطعَةَ خَشَبِ أرزٍ وَخَيطاً أحمَرَ وَغُصْناً مِنْ نَباتِ الزُّوفا. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ثُمَّ يَذبَحُ أحَدَ العُصفُورَينِ فِي طَبَقٍ مِنْ خَزَفٍ فَوقَ ماءٍ جارٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","وَيَأخُذُ قِطعَةَ خَشَبِ الأرْزِ وَغُصْنَ الزُّوفا وَالخَيطَ الأحمَرَ وَالطَّيرَ الحَيَّ، وَيَغمِسُها جَمِيعَها فِي دَمِ العُصفُورِ الَّذِي ذُبِحَ فِي الماءِ الجارِي، ثُمَّ يَرُشُّ البَيتَ سَبعَ مَرّاتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","وَهَكَذا يَطهُرُ البَيتُ بِدَمِ العُصفُورِ وَبِالماءِ الجارِي وَبِالعُصفُورِ الحَيِّ وَقِطْعَةِ خَشَبِ الأرْزِ وَغُصْنِ الزُّوفا وَالخَيطِ الأحمَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ثُمَّ يُطلِقُ الكاهِنُ العُصفُورَ الحَيَّ خارِجَ المَدِينَةِ فِي سَهلٍ مَفتُوحٍ، وَيُكَفِّرُ عَنِ البَيتِ فَيَصِيرُ طاهِراً.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","هَذِهِ هِيَ شَرِيعَةُ كُلِّ بَرَصٍ وَالتِهابٍ جِلدِيٍّ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","وَعَفَنِ القُماشِ أوِ البَيتِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","وَتَغَيُّرِ لَونِ الجِلدِ وَالجَرَبِ وَالبُقَعِ اللّامِعَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","هَذِهِ الشَّرِيعَةُ لِلتَّفرِيقِ بَينَ ما هُوَ نَجِسٌ وَما هُوَ طاهِرٌ. إنَّها شَرِيعَةُ البَرَصِ وَالعَفَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","وَقالَ اللهُ لِمُوسَى وَهارُونَ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«كَلِّما بَنِي إسْرائِيلَ وَقُولا لَهُمْ: حِينَ يَكُونُ لَدَى رَجُلٍ إفرازٌ مِنْ عُضوِهِ فَهُوَ نَجِسٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","سَيَكُونُ الإفرازُ نَجاسَةً لَهُ، سَواءٌ أكانَ يُخرِجُ الإفرازَ أمْ يَحتَقِنُ بِهِ، فَهَذِهِ نَجاسَةٌ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","«أيُّ سَرِيرٍ يَستَلقِي عَلَيهِ الَّذِي لَدَيهِ الإفرازُ يَكُونُ نَجِساً، وَأيُّ شَيءٍ يَجلِسُ عَلَيهِ يَكُونُ نَجِساً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","أيُّ إنسانٍ يَلمِسُ سَرِيرَهُ يَنبَغِي أنْ يَغسِلَ ثِيابَهُ وَيَستَحِمَّ بِماءٍ، وَسَيَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","وَمَنْ يَجلِسُ عَلَى أيِّ شَيءٍ جَلَسَ عَلَيهِ الَّذِي لَدَيهِ الإفرازُ يَنبَغِي أنْ يَغسِلَ ثِيابَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","وَكُلُّ مَنْ يَمَسُّ جَسَدَ الَّذِي لَدَيهِ الإفرازُ، يَنبَغِي أنْ يَغسِلَ ثِيابَهُ وَيَستَحِمَّ بِماءٍ. وَسَيَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","وَإنْ بَصَقَ رَجُلٌ لَدَيهِ الإفرازُ عَلَى شَخصٍ طاهِرٍ، فَعَلَى الطّاهِرِ أنْ يَغسِلَ ثِيابَهُ وَيَستَحِمَّ بِماءٍ. وَسَيَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","كُلُّ شَيءٍ يَركَبُ عَلَيهِ الَّذِي لَدَيهِ الإفرازُ يَكُونُ نَجِساً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","كُلُّ مَنْ يَلمِسُ أيَّ شَيءٍ تَحتَ الرَّجُلِ الَّذِي لَدَيهِ الإفرازُ يَكُونُ نَجِساً إلَى المَساءِ. وَكُلُّ مَنْ يَحمِلُ شَيئاً كانَ تَحتَ الرَّجُلِ الَّذِي لَدَيهِ الإفرازُ، يَنبَغِي أنْ يَغسِلَ ثِيابَهُ وَيَستَحِمَّ بِماءٍ، وَسَيَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","وَإنْ لَمْ يَغسِلِ الَّذِي لَدَيهِ الإفرازُ يَدَيهِ بِالماءِ، وَلَمَسَ أحَداً، فَعَلَيهِ أنْ يَغسِلَ ثِيابَهُ وَيَستَحِمَّ بِماءٍ. وَسَيَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","«يَنبَغِي كَسْرُ إناءِ الخَزَفِ الَّذِي يَلمِسُهُ الرَّجُلُ الَّذِي لَدَيهِ الإفرازُ. وَأيُّ إناءٍ خَشَبِيٍّ يَلمِسُهُ يَنبَغِي غَسلُهُ فِي الماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«وَحِينَ يُشفَى الرَّجُلُ الَّذِي لَدَيهِ الإفرازُ، يَنتَظِرُ سَبعَةَ أيّامٍ قَبلَ أنْ يَتَطَهَّرَ. يَغسِلُ ثِيابَهُ وَيَستَحِمُّ فِي ماءٍ جارٍ فَيَطْهُرُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","وَفِي اليَومِ الثّامِنِ، يَأخُذُ يَمامَتَينِ أوْ حَمامَتَينِ، وَيَأتِيَ إلَى الكاهِنِ فِي حَضْرَةِ اللهِ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ، وَيُعطِيَهُما إلَى الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","فَيُقَدِّمُ الكاهِنُ واحِدَةً ذَبِيحَةَ خَطِيَّةٍ، وَالأُخرَى ذَبيحَةً صاعِدَةً. هَكَذا سَيَعمَلُ لَهُ كَفّارَةً فِي حَضْرَةِ اللهِ مِنَ الإفرازِ الَّذِي كانَ لَدَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«إنْ أفرَزَ رَجُلٌ مِنْ سائِلِهِ، فَلِيَغسِلْ كُلَّ جَسَدِهِ بِماءٍ، وَسَيَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","وَأيَّةُ ثِيابٍ أوْ جِلدٍ لَمَسَها السّائِلُ يَنبَغِي غَسلُها بِالماءِ، وَسَتَبقَى نَجِسَةً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","فَإنْ عاشَرَ رَجُلٌ امْرأتَهُ وَأفرَزَ مِنْ سائِلِهِ، فَلْيَسْتَحِمّا بِماءٍ. وَسَيَبقَيانِ نَجِسَيْنِ إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«فَإذا كانَتِ المَرْأةُ فِي فَترَةِ حَيضِها الشَّهرِيَّةِ، فَإنَّها تَكُونُ نَجِسَةً لِسَبعَةِ أيّامٍ، وَكُلُّ مَنْ يَلمِسُها يَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","كُلُّ ما تَستَلقِي عَلَيهِ خِلالَ فَترَةِ حَيضِها يَكُونُ نَجِساً. وَكُلُّ ما تَجلِسُ عَلَيهِ يَكُونُ نَجِساً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","وَمَنْ يَلمِسُ سَرِيرَها، يَنبَغِي أنْ يَغسِلَ ثِيابَهُ وَيَستَحِمَّ بِماءٍ، وَسَيَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","وَمَنْ يَلمِسُ شَيئاً جَلَسَتْ عَلَيهِ، يَنبَغِي أنْ يَغسِلَ ثِيابَهُ وَيَستَحِمَّ بِماءٍ، وَسَيَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","وَإنْ كانَ هُناكَ شَيءٌ عَلَى السَّرِيرِ وَلَمَسَهُ، أوْ لَمَسَ شَيئاً كانَتْ تَجلِسُ عَلَيهِ، فَإنَّهُ سَيَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","وَإنْ عاشَرَها زَوجُها، فَإنَّ دَمَ حَيضِها يَأتِي عَلَيهِ فَيُنَجِّسُهُ. يَبقى نَجِساً لِسَبعَةِ أيّامٍ. وَأيُّ سَرِيرٍ يَستَلقِي عَلَيهِ يَكُونُ نَجِساً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«حِينَ يَكُونُ لَدَى امْرأةٍ إفرازُ دَمٍ لِأيّامٍ كَثِيرَةٍ، لَيسَ فِي فَترَةِ حَيضِها الشَّهرِيَّةِ، أوْ أنَّ الدَّمَ يَستَمِرُّ إلَى ما بَعدَ فَترَةِ حَيضِها الشَّهرِيَّةِ، فَإنَّها تَكُونُ نَجِسَةً طِيلَةَ فَترَةِ إفرازِها النَّجِسِ، مِثلَما هِيَ نَجِسَةٌ خِلالَ فَترَةِ حَيضِها الشَّهرِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","وَأيُّ سَرِيرٍ تَستَلقِي عَلَيهِ خِلالَ فَترَةِ الإفرازِ سَيَكُونُ لَها كَالسَّرِيرِ الَّذِي تَستَلقِي عَلَيهِ فِي فَترَةِ حَيضِها الشَّهرِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","وَكُلُّ مَنْ يَلمِسُ هَذِهِ الأشياءَ يَكُونُ نَجِساً. فَلْيَغسِلْ ثِيابَهُ وَيَستَحِمْ بِماءٍ، وَسَيَبقَى نَجِساً إلَى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","وَحِينَ تُشفَى مِنْ إفرازِها فَعَلَيها أنْ تَنتَظِرَ لِسَبعَةِ أيّامٍ، وَبَعدَ ذَلِكَ سَتَكُونُ طاهِرَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","وَفِي اليَومِ الثّامِنِ، تَأخُذُ يَمامَتَينِ أوْ حَمامَتَينِ وَتُحضِرُهُما إلَى الكاهِنِ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","فَيُقَدِّمُ الكاهِنُ إحْداهُما ذَبيحَةَ خَطِيَّةٍ، وَيُقَدِّمَ الأُخرَى ذَبيحَةً صاعِدَةً. هَكَذا سَيَعمَلُ لَها الكاهِنُ كَفّارَةً فِي حَضْرَةِ اللهِ مِنَ الإفرازِ النَّجِسِ الَّذِي كانَ لَدَيها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«حَذِّرا بَنِي إسْرائِيلَ مِنَ النَّجاسَةِ. فَإنْ نَجَّسُوا مَسْكَنِي المُقَدَّسِ فِي وَسَطِهِمْ بِسَبَبِ نَجاسَتِهِمْ، يَمُوتُونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","هَذِهِ شَرِيعَةُ الَّذِي لَدَيهِ إفرازٌ مِنَ السّائِلِ المَنَوِيِّ يَجعَلُهُ نَجِساً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","وَشَرِيعَةُ المَرأةِ خِلالَ فَترَةِ حَيضِها الشَّهرِيَّةِ. فَهِيَ شَرِيعَةُ إفرازِ السَوائِلِ، سَواءٌ أكانَ رَجُلاً أمِ امْرأةً. وَشَرِيعَةُ الرَّجُلِ الَّذِي يُعاشِرُ امْرأةً نَجِسَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","وَتَكَلَّمَ اللهُ لِمُوسَى بَعدَ مَوتِ وَلَدَي هارُونَ اللَّذَينِ ماتا حِينَ حاوَلا الاقتِرابَ مِنَ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","وَقالَ اللهُ لِمُوسَى: «قُلْ لِهارُونَ أخِيكَ أنْ لا يَأتِيَ مَتَى أرادَ إلَى المَكانِ المُقَدَّسِ خَلفَ السِّتارَةِ الدّاخِلِيِّةِ، أمامَ الغِطاءِ الَّذِي عَلَى الصُّندُوقِ المُقَدَّسِ، وَإلّا فَإنَّهُ سَيَمُوتُ. لِأنِّي أظهَرُ فِي سَحابَةٍ فَوقَ الغِطاءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«لَكِنْ يُمكِنُ لِهارُونَ أنْ يَدخُلَ المَكانَ المُقَدَّسَ بَعدَ أنْ يُقَدِّمَ ثَوراً مِنَ البَقَرِ ذَبيحَةَ خَطِيَّةٍ وَكَبْشاً ذَبيحَةً صاعِدَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","يَنبَغِي أنْ يَرتَدِيَ المَلابِسَ الدّاخِلِيَّةَ عَلَى جَسَدِهِ، وَيَربِطَ حِزامَ الكِتّانِ حَولَهُ، وَيَضَعَ العِمامَةَ الكِتّانِيَّةَ عَلَى رَأسِهِ. هَذِهِ الثِّيابُ مُقَدَّسَةٌ. يَنبَغِي أنْ يَسْتَحِمَ بِالماءِ، وَبَعدَ ذَلِكَ يَرتَدِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","«يَأخُذَ هارُونَ مِنْ بَنِي إسْرائِيلَ تَيسَينِ لِذَبِيحَةِ الخَطِيَّةِ وَكَبْشاً لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","كَما يُقَدِّمُ هُوَ ثَورَ ذَبِيحَةِ الخَطِيَّةِ، فَيُكَفِّرُ عَنْ نَفسِهِ وَعَنْ عائِلَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ثُمَّ يَأخُذُ التَّيسَينِ وَيُقَدِّمُهُما فِي حَضْرَةِ اللهِ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","وَيُلقِيَ هارُونُ قُرعَتَينِ عَلَى التَّيسَينِ: القُرعَةَ الأُولَى للهِ، وَالقُرعَةَ الثَّانِيَةَ لِعَزازِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ثُمَّ يُحضِرُ هارُونَ التَّيسَ الَّذِي اختِيرَ بِالقُرعَةِ للهِ، وَيُقَدِّمُهُ ذَبيحَةَ خَطِيَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","وَأمّا التَّيسُ الَّذِي اختِيرَ بِالقُرعَةِ لِعَزازِيلَ، فَيُقَدَّمُ حَيّاً فِي حَضْرَةِ اللهِ. ثُمَّ يُرْسَلُ إلَى الصَّحْراءِ إلَى عَزازِيلَ لِلتَّكْفِيرِ عَنِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«ثُمَّ يُقَدِّمُ هارُونُ الثَّورَ ذَبيحَةَ خَطِيَّةٍ لِنَفسِهِ، فَيُكَفِّرُ عَنْ نَفسِهِ وَعَنْ عائِلَتِهِ، وَيَذبَحُ ثَورَ ذَبِيحَةِ الخَطِيَّةِ لِنَفسِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ثُمَّ يَأخُذُ مِبخَرَةً مَلِيئَةً بِالجَمرِ مِنَ المَذبَحِ الَّذِي فِي حَضْرَةِ اللهِ، وَمِلءَ كَفَّيهِ مِنْ بَخُورٍ عَطِرٍ، وَيَدخُلُ بِهِما إلَى خَلفِ السِّتارَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","وَيَضَعُ هارُونُ البَخُورَ عَلَى النّارِ فِي حَضْرَةِ اللهِ لِيُغَطِّيَ دُخانُ البَخُورِ الغِطاءَ الَّذِي عَلَى صُندُوقِ الشَّهادَةِ لِئَلّا يَمُوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ثُمَّ يَأخُذُ مِنْ دَمِ الثَّورِ وَيَرُشُّهُ بِإصبَعِهِ عَلَى الغِطاءِ فِي الجِهَةِ الشَّرقِيَّةِ. يَرُشُّ مِنَ الدَّمِ سَبعَ مَرّاتٍ بِإصبَعِهِ أمامَ الغِطاءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«ثُمَّ يَذبَحُ هارُونُ تَيسَ ذَبِيحَةِ الخَطِيَّةِ عَنِ الشَّعبِ. وَيُحضِرُ دَمَهُ إلَى خَلفِ السِّتارَةِ الدّاخِلِيِّةِ. وَيَعمَلُ بِدَمِهِ ما عَمِلَهُ بِدَمِ الثَّورِ، فَيَرُشُّهُ عَلَى الغِطاءِ مِنَ الجِهَةِ الأمامِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","هَكَذا يَصْنَعُ كَفّارَةً لِلمَكانِ المُقَدَّسِ مِنْ نَجاساتِ بَنِي إسْرائِيلَ وَتَعَدِّياتِهِمْ وَكُلِّ خَطاياهُمْ. وَعَلَى هارُونَ أنْ يَفعَلَ ذَلِكَ أيضاً لِخَيمَةِ الاجْتِماعِ لِأنَّها وَسَطَ شَعبٍ نَجِسٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","«لا يَنبَغِي أنْ يَكُونَ أحَدٌ فِي خَيمَةِ الاجْتِماعِ مُنْذُ دُخُولِ هارُونَ إلَى المَكانِ المُقَدَّسِ لِعَمَلِ كَفّارَةٍ لَهُ وَحَتَّى خُرُوجِهِ. فَيُكَفِّرُ هارُونُ عَنْ نَفسِهِ وَعَنْ عائِلَتِهِ وَكُلِّ بَنِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ثُمَّ يَخرُجُ هارُونُ إلَى المَذبَحِ الَّذِي فِي حَضْرَةِ اللهِ، وَيُكَفِّرُ عَنهُ. فَيَأخُذُ مِنْ دَمِ الثَّورِ وَدَمِ التَّيسِ وَيَضَعُهُ عَلَى زَوايا المَذبَحِ مِنْ كُلِّ الجِهاتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ثُمَّ يَرُشُّ بَعضَ الدَّمِ عَلَيهِ بِإصبَعِهِ سَبعَ مَرّاتٍ، فَيُطَهِّرُهُ مِنْ نَجاسَةِ بَنِي إسْرائِيلَ وَيُقَدِّسُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«وَحِينَ يَنتَهِي هارُونُ مِنْ عَمَلِ كَفّارَةٍ لِلمَقدِسِ وَخَيمَةِ الاجْتِماعِ وَالمَذبَحِ، يُحضِرُ التَّيسَ الحَيَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","وَيَضَعُ هارُونُ يَدَيهِ عَلَى رَأسِ التَّيسِ، وَيَعتَرِفُ فَوقَهُ بِكُلِّ شُرُورِ بَنِي إسْرائِيلَ وَمَعاصِيهِمْ وَكُلِّ خَطاياهُمْ. وَبِهَذا فَإنَّ هارُونَ يَضَعُ هَذِهِ الخَطايا عَلَى رَأسِ التَّيسِ. ثُمَّ يُرسِلُ التَّيسَ إلَى الصَّحراءِ، وَالَّذِي سَيَقُودُهُ هُوَ رَجُلٌ سَبَقَ تَعيِينُهُ لِهَذا الأمرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","وَبِهَذا سَيَحمِلُ التَّيسُ عَلَيهِ كُلَّ خَطايا الشَّعبِ إلَى مِنْطَقَةٍ مَعزُولَةٍ مُقفِرَةٍ. سَيُطلِقُ الرَّجُلُ التَّيسَ فِي الصَّحراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«ثُمَّ يَدخُلُ هارُونُ خَيمَةَ الاجْتِماعِ وَيَخلَعُ ثِيابَ الكِتّانِ الَّتِي ارتَداها حِينَ دَخَلَ إلَى المَكانِ المُقَدَّسِ، وَيَترُكُها هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ثُمَّ يَغسِلُ جَسَدَهُ فِي مَكانٍ مُقَدَّسٍ، وَيَرتَدِي ثِياباً أُخْرَى، وَيَخرُجُ وَيُقَدِّمُ ذَبيحَتَهُ الصّاعِدَةَ وَذَبيحَةَ الشَّعبِ، وَيُكَفِّرُ عَنْ نَفسِهِ وَعَنِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ثُمَّ يُحرِقُ شَحمَ ذَبِيحَةِ الخَطِيَّةِ عَلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«أمّا الرَّجُلُ الَّذِي أطلَقَ التَّيسَ إلَى عَزازِيلَ، فَيَنبَغِي أنْ يَغْسِلَ ثِيابَهُ وَيَستَحِمَّ بِماءٍ، ثُمَّ يُمكِنُهُ أنْ يَدخُلَ المُخَيَّمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","«أمّا ثَورُ ذَبِيحَةِ الخَطِيَّةِ وَتَيسُ ذَبِيحَةِ الخَطِيَّةِ، اللّذانِ أُحضِرَ دَمُهُما إلَى المَكانِ المُقَدَّسِ لِلتَّكفِيرِ، فَيُؤخَذا إلَى خارِجِ المُخَيَّمِ، وَيُحرَقُ جِلدُهُما وَلَحمُهُما وَرَوثُهُما فِي النّارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","وَالَّذِي يَحرِقُهُما يَنبَغِي أنْ يَغسِلَ ثِيابَهُ وَيَستَحِمَّ بِماءٍ، ثُمَّ يُمكِنُهُ أنْ يَدخُلَ المُخَيَّمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«هَذِهِ شَرِيعَةٌ دائِمَةٌ لَكُمْ: فِي اليَومِ العاشِرِ مِنَ الشَّهرِ السّابِعِ، تَتَذَلِّلُونَ بِالصَّومِ، وَلا تَعْمَلُونَ أيَّ عَمَلٍ. هَذا يَنطَبِقُ عَلَى المُواطِنِ وَعَلَى الغَرِيبِ الَّذِي يُقِيمُ بَينَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","فِي هَذا اليَومِ، يَعمَلُ رَئِيسُ الكَهَنَةِ كَفّارَةً لَكُمْ لِتَطهِيرِكُمْ مِنْ كُلِّ خَطاياكُمْ، فَتَكُونُونَ طاهِرِينَ فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","هَذا يَومُ راحَةٍ لَكُمْ، عَلَيكُمْ فِيهِ أنْ تُذَلِّلُوا أنفُسَكُمْ بِالصَّومِ. هَذِهِ شَرِيعَةٌ دائِمَةٌ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","«عَلَى الكاهِنِ الَّذِي يَتِمُّ اختِيارُهُ لِيَكُونَ رَئِيسَ الكَهَنَةِ، وَالمُعَيَّنَ مَكانَ أبِيهِ، أنْ يَعمَلَ الكَفّارَةَ لَكُمْ. فَيَرتَدِي الثِّيابَ الكِتّانِيَّةَ الخاصَّةَ بالمَكانِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","وَيُطَهِّرُ المَكانَ المُقَدَّسَ وَخَيمَةَ الاجْتِماعِ وَالمَذبَحَ وَالكَهَنَةَ وَكُلَّ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","سَتَكُونُ هَذِهِ شَرِيعَةً دائِمَةً لَكُمْ لِلتَّكفِيرِ عَنْ بَنِي إسْرائِيلَ مِنْ خَطاياهُمْ مَرَّةً فِي السَّنَةِ.» فَعَمِلَ هارُونُ بِحَسَبِ أمرِ اللهِ لِمُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«كَلِّمْ هارُونَ وَبَنِيهِ وَكُلَّ بَنِي إسْرائِيلَ وَقُلْ لَهُمْ: هَذا ما أمَرَ اللهُ بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","إنْ ذَبَحَ أيُّ واحِدٍ مِنْ بَنِي إسْرائِيلَ ثَوراً أوْ غَنَماً أوْ ماعِزاً كَذَبِيحَةٍ فِي المُخَيَّمِ أوْ خارِجَهُ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","وَلَمْ يُحضِرْهُ إلَى مَدخَلِ خَيمَةِ الاجْتِماعِ لِيُقَدِّمَهُ ذَبِيحَةً للهِ أمامَ مَسْكَنِ اللهِ المُقَدَّسِ، يُعتَبَرُ مُذنِباً، لِأنَّهُ سَفَكَ دَماً، وَيُبادُ مِنَ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","فَهَدَفُ هَذِهِ الشَّرِيعَةِ أنْ يُحضِرَ بَنُو إسْرائِيلَ الذَّبائِحَ الَّتِي كانُوا يَذبَحُونَها فِي البَرِّيَّةِ إلَى اللهِ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ، إلَى الكاهِنِ، وَيَذبَحُوها كَذَبائِحِ سَلامٍ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","وَيَرُشُّ الكاهِنُ الدَّمَ عَلَى مَذبَحِ اللهِ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ، وَيُحرِقُ الشَّحمَ، كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","أمّا الَّذِينَ خانُونِي بِتَقدِيمِ ذَبائِحِهِمْ لِلتُّيُوسِ، فَلا يُقَدِّمُوها فِيما بَعْدُ. لَقَدْ خانُونِي بِذَلِكَ. هَذِهِ شَرِيعَةٌ دائِمَةٌ لَهُمْ فِي كُلِّ أجيالِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«وَقُلْ لَهُمْ: أيُّ شَخصٍ مِنْ بَيتِ إسْرائِيلَ، أوْ غَرِيبٍ يَقُيمُ بَينَهُمْ، يُقَدِّمُ ذَبيحَةً صاعِدَةً أوْ قُرْباناً، ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","وَلا يُحضِرُها إلَى مَدخَلِ خَيمَةِ الاجْتِماعِ لِيُقَدِّمَها للهِ، يُقطَعُ مِنَ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«وَإنْ أكَلَ شَخصٌ مِنْ بَيتِ إسْرائِيلَ أوْ غَرِيبٌ يَعِيشُ بَينَكُمْ دَماً، فَسَأُواجِهُ ذاكَ الَّذِي أكَلَ الدَّمَ، وَسَأعزِلُهُ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","لِأنَّ حَياةَ الجَسَدِ فِي الدَّمِ، وَقَدْ أعطَيتُ الدَّمَ لِلتَّكفِيرِ عَنكُمْ بِسَكبِهِ عَلَى المَذبَحِ. لِأنَّ الدَّمَ يُكَفِّرُ عَنِ النّاسِ بِتَقدِيمِ حَياةٍ مُقابِلَ حَياةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","وَلِذَلِكَ أقُولُ لَكُمْ يا بَنِي إسْرائِيلَ: لا يَأكُلُ أحَدٌ مِنْكُمْ دَماً، وَلا يَأكُلُ أيُّ غَرِيبٍ يَعِيشُ بَينَكُمْ دَماً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","«وَأيُّ واحِدٍ مِنْ بَنِي إسْرائِيلَ أوْ أيُّ غَرِيبٍ يَعِيشُ بَينَكُمْ يَصطادُ حَيواناً بَرِّيّاً أوْ طَيراً يُؤكَلَ، فَلْيَسْفِكْ دَمَهُ وَيُغَطِّيهِ بِالرَّملِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","لِأنَّ حَياةَ الكائِناتِ الحَيَّةِ فِي دَمِها. لِذَلِكَ أقُولُ لِبَنِي إسْرائِيلَ: لا تَأكُلُوا دَمَ أيِّ كائِنٍ حَيٍّ، لِأنَّ حَياةَ كُلِّ الكائِناتِ فِي دَمِها. كُلُّ واحِدٍ يَأكُلُ دَماً يُعزَلُ مِنْ شَعبِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«وَكُلُّ مُواطِنٍ أوْ غَرِيبٍ يَأكُلُ حَيواناً ماتَ وَحدَهُ، أوْ حَيواناً قَتَلَهُ حَيوانٌ آخَرُ، يَنبَغِي أنْ يَغسِلَ ثِيابَهُ وَيَستَحِمَّ بِماءٍ، وَسَيَبقَى نَجِساً إلَى المَساءِ، ثُمَّ يَصِيرُ طاهِراً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","فَإنْ لَمْ يَغسِلْ ثِيابَهُ وَلَمْ يَستَحِمَّ، فَإنَّهُ يَحمِلُ عُقُوبَةَ خَطِيَّتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«قُلْ لِبَنِي إسْرائِيلَ: أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","فَلا تَعمَلُوا الأشياءَ الَّتِي كانَتْ تُعمَلُ فِي أرْضِ مِصرَ حَيثُ كُنتُمْ تَسكُنُونَ. وَلا تَعمَلُوا الأُمُورَ الَّتِي تُعمَلُ فِي أرْضِ كَنعانَ حَيثُ سَأُحضِرُكُمْ. وَلا تَعِيشُوا بِحَسَبِ شَرائِعِهِمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","بَلِ احْفَظُوا أحكامِي وَاعْمَلُوا بِشَرائِعِي، لِكَي تَحيُوا بِها. أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","احفَظُوا شَرائِعِي وَأحكامِي، لأنَّ الإنسانَ الَّذِي يَعْمَلُ ذَلِكَ يَحيا. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«لا يُعاشِرْ أحَدٌ امْرأةً لَهُ بِها صِلَةُ قَرابَةٍ شَدِيدَةٌ. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","لا تَأتِيَ بِالعارِ لِأبِيكَ بِأنْ تُعاشِرَ أُمَّكَ! إنَّها أُمُّكَ! فَلا تُعاشِرْها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","لا تُعاشِرْ زَوجَةَ أبِيكَ، فَهَذا يَأتِي بِالعارِ إلَى أبِيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","لا تُعاشِرْ أُختَكَ، لا بِنتَ أُمِّكَ وَلا بِنتَ أبِيكَ، إنْ كانَتْ قَدْ وُلِدَتْ فِي نَفسِ البَيتِ أوْ فِي بَيتٍ آخَرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","لا تُعاشِرِ ابْنَةَ ابْنِكَ أوِ ابْنَةَ ابْنَتِكَ لِأنَّ هَذا سَيَأتِي بِالعارِ عَلَيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","لا تُعاشِرِ ابْنَةَ زَوجَةَ أبِيكَ الَّتِي أنجَبَتْها مِنْ أبِيكَ، فَهِيَ أُختُكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","لا تُعاشِرْ أُختَ أبِيكَ، فَهِيَ قَرِيبَةٌ جِدّاً لِأبِيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","لا تُعاشِرْ أُختَ أُمِّكَ، فَهِيَ قَرِيبَةٌ جِدّاً لِأُمِّكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","لا تُعاشِرْ زَوجَةَ عَمِّكَ، فَهَذا يَأتِي بِالعارِ عَلَى عَمِّكَ، إنَّها عَمَّتُكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","لا تُعاشِرْ كِنَّتَكَ. إنَّها زَوجَةُ ابْنِكَ، فَلا تُعاشِرْها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","لا تُعاشِرِ ابْنَةَ زَوجَةِ أخِيكَ، فَهَذا يَأتِي بِالعارِ عَلَى أخِيكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","لا تُعاشِرِ امْرأةً وَابْنَتَها. وَلا تَتَزَوَّجْ وَتُعاشِرِ ابْنَةَ ابْنِها أوِ ابْنَةَ ابْنَتِها. إنَّهُما قَرِيبَتانِ جِدّاً لَها. هَذا شَرٌّ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","لا تَتَزَوَّجْ أُخْتَ زَوجَتِكَ وَتُعاشِرْها بَينَما أُختُها حَيَّةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","لا تُعاشِرِ امْرَأتَكَ فِي فَترَةِ حَيضِها الشَّهرِيَّةِ إذْ تَكُونُ نَجِسَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","لا تُعاشِرْ زَوجَةَ جارِكَ فَتُنَجِّسَ نَفسَكَ بِها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«لا تَسمَحْ بِأنْ يُعطَى أحَدُ أولادِكَ لِيُذبَحَ لِلإلَهِ مُولَكَ. لا تُنَجِّسِ اسْمَ إلَهِكَ بِعَمَلِ هَذا. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«لا تُعاشِرْ ذَكَراً كَما تَفعَلُ مَعَ امْرأةٍ. هَذِهِ نَجاسَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","لا تُعاشِرْ حَيواناً فَتَتَنَجَّسَ بِهِ. وَلا تُعاشِرِ المَرأةُ حَيواناً. فَهَذا أمْرٌ بَغيضٌ جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«لا تَتَنَجَّسُوا بَأيٍّ مِنْ هَذِهِ الأعمالِ، لِأنَّ الأُمَمَ الَّتِي سَأطرُدُها مِنْ أمامِكُمْ يُنَجِّسُونَ أنفُسَهُمْ بِها، ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","حَتَّى صارَتِ الأرْضُ نَجِسَةً. لِذا سَأُعاقِبُها عَلَى خَطايا الشَّعبِ الَّذِي يَعِيشُ فِيها، كَي تَطرُدَ الأرْضُ السّاكِنِينَ فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","«احْفَظُوا شَرائِعِي وَأحكامِي، وَلا تَعمَلُوا كُلَّ هَذِهِ الأُمُورِ البَغِيضَةِ. لا المُواطِنُ وَلا الغَرِيبُ السّاكِنُ بَينَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","لِأنَّ الَّذِينَ عاشُوا فِي الأرْضِ قَبلَكُمْ عَمِلُوا كُلَّ هَذِهِ الأُمُورِ البَغِيضَةِ، فَصارَتِ الأرْضُ نَجِسَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","فَهَكَذا أيضاً سَتَطرُدُكُمُ الأرْضُ بِسَبَبِ تَنْجِيسِكُمْ إيَّاها، كَما طَرَدَتِ الأُمَمَ الَّتِي كانَتْ مِنْ قَبلِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","فَكُلُّ مَنْ يَعمَلُ شَيئاً مِنْ هَذِهِ الأُمُورِ البَغِيضَةِ، يُقطَعُ مِنْ شَعبِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","احفَظُوا وَصِيَّتِي، فَلا تَعمَلُوا أيّاً مِنَ الأُمُورِ البَغِيضَةِ الَّتِي عُمِلَتْ قَبلَكُمْ. لا تُنَجِّسُوا أنفُسَكُمْ بِعَمَلِ هَذِهِ الأُمُورِ. أنا إلَهُكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«قُلْ لِبَنِي إسْرائِيلَ: كُونُوا مُقَدَّسينَ لِأنِّي أنا إلَهَكُمْ قُدُّوسٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","«لِيُكْرِمْ كُلُّ واحِدٍ مِنكُمْ أباهُ وَأُمَّهُ، وَلَيَحفَظْ جَمِيعَ أيّامِ راحَتِي. أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«لا تَترُكُونِي وَتَعبُدُوا الأصنامَ. لا تَصنَعُوا لَكُمْ تَماثِيلَ مَعدَنِيَّةً. أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«وَحِينَ تُقَدِّمُونَ ذَبِيحَةَ سَلامٍ للهِ، قَدِّمُوها بِالطَّرِيقَةِ الصَّحِيحَةِ لِتَكُونَ مَقبُولَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","يَنبَغِي أنْ تُؤكَلَ فِي يَومِ ذَبحِكُمْ لَها أوِ اليَومِ التّالِي، لَكِنْ ما يَبقَى مِنها فِي اليَومِ الثّالِثِ يَنبَغِي أنْ يُحرَقَ بالنّارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","إنْ أُكِلَ أيُّ شَيءٍ مِنَ الذَّبِيحَةِ فِي اليَومِ الثّالِثِ، فَإنَّها تَصِيرُ فاسِدَةً وَغَيرَ مَقْبُولَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","مَنْ يَأكُلُها، يَتَحَمَّلُ عُقُوبَةً عَلَى خَطِيَّتِهِ لِأنَّهُ نَجَّسَ أحَدَ الأُمُورِ المُقَدَّسَةِ الخاصَّةِ بِاللهِ، فَيُقطَعُ مِنَ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«وَحِينَ تَحصُدُونَ مَحاصِيلَ أرْضِكُمْ، فَلا تَحصُدُوا زَوايا حُقُولِكُمْ، وَلا تَعُودُوا لِجَمعِ ما سَقَطَ عَلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","لا تَلتَقِطُوا كُلَّ عِنَبِ كَرمِكُمْ. وَلا تَلتَقِطُوا العِنَبَ المُتَساقِطَ عَلَى الأرْضِ، بَلِ اتْرُكُوهُ لِلفُقَراءِ وَالغُرَباءِ. أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«لا تَسرِقُوا، وَلا تَغِشُّوا النّاسَ، وَلا تَكذِبُوا أحَدُكُمْ عَلَى الآخَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","«لا تَحلِفُوا بِاسمِي بِالكَذِبِ، فَتُدَنِّسُوا اسمَ إلَهِكُمْ. أنا يهوه. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«لا تَغتَصِبْ ما لِقَرِيبِكَ وَلا تَسرِقْ. وَلا تَحتَفِظْ بِأُجرَةِ الأجِيرِ إلَى الصُّبحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","«لا تَلعَنْ إنساناً أطرَشَ، وَلا تَضَعْ شَيئاً فِي طَرِيقِ الأعمَى لِيَتَعَثَّرَ بِهِ. خَفْ إلَهَكَ. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«كُونُوا عادِلِينَ فِي القَضاءِ، فَلا تَتَحَيَّزُوا لِلفُقَراءِ وَالمَساكِينِ، وَلا تُقَدِّمُوا إكراماً خاصّاً لأصْحابِ المَرَاكِزِ. احْكُمْ عَلَى قَرِيبِكَ بِالعَدِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","«لا تَجُلْ بَينَ شَعبِكَ مُخبِراً بِقِصَصٍ كاذِبَةٍ عَنِ النّاسِ. وَلا تَقِفْ مُتَفَرِّجاً حِينَ تَكُونُ حَياةُ قَرِيبِكَ فِي خَطَرٍ. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","«لا تُبغِضْ صَاحِبَكَ فِي قَلبِكَ، لَكِنْ أنذِرْهُ وَعاتِبهُ حِينَ يُخطِئُ، لِئَلّا تَحمِلَ ذَنباً بِسَبَبِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","لا تَنتَقِمْ وَلا تَحقِدْ عَلَى أحَدٍ مِنْ شَعبِكَ، بَلْ تُحِبُّ صَاحِبَكَ كَما تُحِبُّ نَفْسَكَ. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«احْفَظْ شَرائِعِي. لا تُهَجِّنْ حَيواناتِكَ مِنْ حَيوانَينِ مُختَلِفَينِ. لا تَزرَعْ حَقلَكَ بِنَوعَينِ مِنَ الحُبُوبِ. لا تَرتَدِ ثِياباً مَصنُوعَةً مِنْ مادَّتَينِ مُختَلِفَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«إنْ عاشَرَ رَجُلٌ جارِيَةً مَخطُوبَةً لِرَجُلٍ آخَرَ، وَلَمْ يَكُنْ قَدْ تَمَّ تَحْرِيرُها بَعدُ، فَيَنبَغِي أنْ يُعاقَبا. لا يُقتَلا لِأنَّها لَمْ تَكُنْ حُرَّةٌ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","لَكِنْ يُحضِرُ الرَّجُلُ كَبْشاً ذَبِيحَةَ ذَنبِهِ إلَى اللهِ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","فَيَعمَلُ لَهُ الكاهِنُ فِي حَضرَةِ اللهِ كَفّارَةً بِكَبْشِ ذَبِيحَةِ الذَّنبِ، بِسَبَبِ الخَطِيَّةِ الَّتِي ارتَكَبَها، فَتُغفَرُ لَهُ الخَطِيَّةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«حِينَ تَدخُلُونَ الأرْضَ وَتَزرَعُونَ أشجاراً مُثمِرَةً، لِيَكُنْ ثَمَرُها مُحَرَّماً، فَلا تَأكُلُوا مِنهُ لِثَلاثِ سَنَواتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","لَكِنْ فِي السَّنَةِ الرّابِعَةِ يُعطَى كُلُّ ثَمَرِها كَتَقدِمَةِ تَسبِيحٍ مُقَدَّسَةٍ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","وَفِي السَّنَةِ الخامِسَةِ تَأكُلُونَ مِنْها. هَكَذا سَتَزدادُ غَلَّتُها. أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«لا تَأكُلُوا لَحْماً دَمُهُ فِيهِ. «لا تُحاوِلُوا مَعرِفَةَ المُستَقبَلِ بِاستِخدامِ العَلاماتِ أوِ السِّحرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","«لا تَحلِقُوا سَوالِفَكُمْ لِيَصِيرَ شَعرُكُمْ مُستَدِيراً، وَلا تُشَذِّبُوا جَوانِبَ لِحاكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","لا تُجَرِّحُوا أجسادَكُمْ حُزناً عَلَى مَيِّتٍ، وَلا تَضَعُوا وَشماً عَلَى أجْسادِكُمْ. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«لا تُهِنِ ابْنَتَكَ بِأنْ تَجعَلَها عاهِرَةً، لِئَلّا يُصبِحَ شَعبُ الأرْضِ زانِياً عاهِراً فَتَمتَلِئُ الأرْضُ مِنَ الشَّرِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","«احفَظُوا أيّامَ راحَتِي، وَاحتَرِمُوا مَكانِيَ المُقَدَّسَ. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«لا تَذهَبُوا إلَى الوُسَطاءِ، وَلا تَطلُبُوا نَصِيحَةَ أصحابِ الجانِ فَتَتَنَجَّسُوا بِهِمْ. أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«قِفْ فِي حَضْرَةِ كِبارِ السِّنِّ، أكْرِمْهُمْ وَاحتَرِمْهُمْ. هَبِ القُضاةَ. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«حِينَ يَكُونُ هُناكَ غَرِيبٌ يَعِيشُ فِي أرْضِكَ فَلا تُسِئْ مُعامَلَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","الغَرِيبُ الَّذِي يَعِيشُ مَعَكُمْ يَنبَغِي أنْ يَكُونَ كَواحِدٍ مِنَ المُواطِنِينَ. تُحِبُّهُ كَنَفسِكَ. لِأنَّكُمْ أنْتُمْ أيضاً كُنتُمْ غُرَباءَ فِي أرْضِ مِصْرَ. أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«لا يَنبَغِي أنْ تَظلِمُوا فِي القَضاءِ وَلا فِي قِياسِ الطُّولِ وَالوَزنِ وَالكَمِّيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","يَنبَغِي أنْ تَكُونَ مَوازِينُكُمْ صَحِيحَةً فِي قِياسِ الأوزانِ وَالكَمِّيّاتِ لِلحُبُوبِ وَالسَّوائِلِ. أنا إلَهُكُمْ الَّذِي أخرَجَكُمْ مِنْ أرْضِ مِصْرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","«احفَظُوا شَرائِعِي وَأحكامِي وَاعْمَلُوا بِها. أنا اللهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«قُلْ لِبَنِي إسْرائِيلَ: كُلُّ واحِدٍ مِنْ بَنِي إسْرائِيلَ أوِ الغُرَباءِ السّاكِنِينَ فِي إسْرائِيلَ يُقَدِّمُ مِنْ أولادِهِ لِلإلَهِ مُولَكَ، يَنبَغِي أنْ يُقتَلَ. عَلَى شَعبِ الأرْضِ أنْ يَقتُلُوهُ بِرَجمِهِ بِالحِجارَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","فَسَأُواجِهُهُ وَسَأعزِلُهُ مِنَ الشَّعبِ، لِأنَّهُ أعطَى مِنْ أولادِهِ لِلإلَهِ مُولَكَ فَنَجَّسَ مَكانِيَ المُقَدَّسَ، وَلَمْ يُكْرِمْ اسْمِي المُقَدَّسَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","لَكِنْ إنْ تَجاهَلَ شَعبُ الأرْضِ ذَلِكَ الرَّجُلَ الَّذِي أعطَى مِنْ أولادِهِ لِلإلَهِ مُولَكَ فَلَمْ يَقتُلُوهُ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","فَسَأُواجِهُ ذَلِكَ الرَّجُلِ وَعائِلَتِهِ وَسَأعزِلُهُمْ مِنْ شَعبِهِمْ ذَلِكَ الرَّجُلَ وَالَّذِينَ يَخُونُونَنِي وَيَسِيرُونَ وَراءَ الإلَهِ مُولَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","«إنْ خانَنِي أحَدٌ وَالتَجَأ لِلوُسَطاءِ وَالمُشَعوِذاتِ لِأجلِ النَّصِيحَةِ، فَسَأُواجِهُهُ وَسَأقطَعُهُ مِنَ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","«كَرِّسُوا أنفُسَكُمْ وَكُونُوا قِدِّيسِينَ، لِأنِّي أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","«احفَظُوا شَرائِعِي وَاعمَلُوا بِها. أنا اللهُ الَّذِي أُقَدِّسُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«إنْ شَتَمَ أحَدٌ أباهُ أوْ أُمَّهُ فَيَنبَغِي أنْ يُعدَمَ. قَدْ شَتَمَ أباهُ وَأُمَّهُ، فَهُوَ مَسؤُولٌ عَنْ مَوتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«إنْ زَنَى رَجُلٌ بِزَوجَةِ رَجُلٍ آخَرَ، فَإنَّهُ يَنبَغِي إعدامُ الرَّجُلِ وَالمَرأةِ اللَذينِ زَنَيا. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","إنْ عاشَرَ رَجُلٌ زَوجَةَ أبِيهِ، فَإنَّهُ قَدْ جَلَبَ العارَ لِأبِيهِ. يَنبَغِي إعدامُ الرَّجُلِ وَالمَرأةِ. هُما مَسؤُولانِ عَنْ مَوتِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","إنْ عاشَرَ رَجُلٌ كِنَّتَهُ، فَإنَّهُ يَنبَغِي إعدامُهُما. قَدِ ارتَكَبا انحِرافاً عَظِيماً. هُما مَسؤُولانِ عَنْ مَوتِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","إنْ عاشَرَ رَجُلٌ رَجُلاً آخَرَ كَما يُعاشِرُ امْرأةً، فَإنَّ كِلَيهِما قَدْ عَمِلا خَطِيَّةً بَغِيضَةً، وَيَنبَغِي إعدامُهُما. هُما مَسؤُولانِ عَنْ مَوتِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","إنْ تَزَوَّجَ رَجُلٌ امْرأةً وَأُمَّها، فَهَذا شَرٌّ. لِيَحْرِقْهُ الشَّعبُ هُوَ وَالمَرأتَينِ بِالنّارِ حَتَّى المَوتِ، لِئَلّا يَكُونَ هَذا الشَّرُّ فِي وَسَطِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","«الرَّجُلُ الَّذِي يُعاشِرُ حَيَواناً يَنبَغِي إعدامُهُ، كَما يَنبَغِي أنْ تَقتُلُوا الحَيوانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","وَإنْ عاشَرَتِ امْرأةٌ حَيواناً، فَيَنبَغِي إعدامُ المَرأةِ وَالحَيوانِ. يَنبَغِي قَتلُهُما. هُما مَسؤُولانِ عَنْ مَوتِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«إنْ تَزَوَّجَ رَجُلٌ بِأُختِهِ غَيْرِ الشَّقِيقَةِ، ابْنَةِ أبِيهِ أوِ ابْنَةِ أُمِّهِ، فَعاشَرَها وَعاشَرَتْهُ، فَهَذا عارٌ. يَنبَغِي عَزلُهُما مِنْ شَعبِهِما أمامَ عائِلَتَيهِما. قَدْ عاشَرَ أُختَهُ، فَيَنبَغِي أنْ يُعاقَبَ عَلَى خَطِيَّتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","إنْ عاشَرَ رَجُلٌ امْرأةً فِي فَترَةِ حَيضِها الشَّهرِيَّةِ فَكَشَفَ مَصدَرَ دَمِها، وَهِيَ كَشَفَتْ مَصدَرَ دَمِها، فَيَنبَغِي أنْ يُقطَعا مِنْ شَعبِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«لا تُعاشِرْ أُختَ أُمِّكَ أوْ أُختَ أبِيكَ، لِأنَّهُما قَرِيبَتانِ مِنكَ. إنْ حَدَثَ هَذا يَنبَغِي أنْ يُعاقَبا عَلَى خَطِيَّتِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","إنْ عاشَرَ رَجُلٌ زَوجَةَ عَمِّهِ، فَإنَّهُ يَكُونُ قَدْ جَلَبَ العارَ عَلَى عَمِّهِ. يَنبَغِي أنْ يُعاقَبا عَلَى خَطِيَّتِهِما. سَيَمُوتانِ بِلا أولادٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","إنْ عاشَرَ رَجُلٌ زَوجَةَ أخِيهِ، فَهَذِهِ نَجاسَةٌ. قَدْ جَلَبَ العارَ لِأخِيهِ. سَيَمُوتانِ بِلا أولادٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«احْفَظُوا كُلَّ شَرائِعِي وَأحكامِي وَاعْمَلُوا بِها لِئَلّا تَتَقَيَّأكُمُ الأرْضُ الَّتِي أقُودُكُمْ إلَيها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","لا تَسلُكُوا بِحَسَبِ عاداتِ الأُمَمِ الَّذِينَ سَأطرُدُهُمْ مِنَ الأرْضِ أمامَكُمْ، لِأنَّهُمْ عَمِلُوا هَذِهِ الخَطايا فَأبْغَضْتُهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","لَكِنِّي قُلْتُ لَكُمْ: سَتَمتَلِكُونَ أرْضَهُمْ، وَسَأُعطِيها لَكُمْ لِتَمتَلِكُوها، أرْضاً تَفِيضُ لَبَناً وَعَسَلاً. أنا إلَهُكُمْ. «قَدْ مَيَّزتُكُمْ عَنْ كُلِّ الأُمَمِ الأُخرَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","فَيَنبَغِي أنْ تُمَيِّزُوا بَينَ الحَيواناتِ وَالطُّيُورِ الطّاهِرَةِ وَغَيرِ الطّاهِرَةِ. لا تُنَجِّسُوا أنفُسَكُمْ بِأنْ تَأكُلُوا حَيواناً أوْ طَيراً أوْ أيَّ كائِنٍ يَزحَفُ عَلَى الأرْضِ قَدِ اعتَبَرتُهُ نَجِساً لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","كُونُوا قِدِّيسِينَ، لِأنِّي أنا اللهُ قُدُّوسٌ. قَدْ مَيَّزْتُكُمْ مِنْ كُلِّ الشُّعُوبِ الأُخرَى لِتَكُونُوا لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«أيُّ رَجُلٍ، أوِ امْرأةٍ، يُحاوِلُ اسْتِحْضارَ أرْواحِ المَوتَى، أوْ يَتَعامَلُ بِالسِّحرِ، يَنبَغِي إعدامُهُ. يَرجُمُهُ الشَّعبُ بِالحِجارَةِ حَتَّى المَوتِ. هُوَ مَسؤُولٌ عَنْ مَوتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","وَقالَ اللهُ لِمُوسَى: «قُلْ لِلكَهَنَةِ، أبناءِ هارُونَ: لا يُنَجِّسِ الكاهِنُ نَفسَهُ لِأجلِ مَيِّتٍ مِنْ أقرِبائِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","إلّا لِأجلِ القَرِيبِينَ جِدّاً مِنهُ: أُمِّهِ وَأبِيهِ وَابْنِهِ وَابْنَتِهِ وَأخِيهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","وَأُختِهِ العَذراءِ غَيرِ المُتَزَوِّجَةِ لِأنَّها لَمْ تَتَزَوَّجْ، يُسْمَحُ لِلكاهِنِ بِأنْ يَتَنَجَّسَ لِأجلِها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","لَكِنْ لا يَجُوزُ لَهُ أنْ يَتَنَجَّسَ لِأجلِ مَيِّتٍ لَهُ صِلَةُ نَسَبٍ بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«لا يَحلِقِ الكَهَنَةُ شَعرَ رُؤُوسِهِمْ بِشَكلٍ كامِلٍ، وَلا أطرافَ لِحاهُمْ، وَلا يُجَرِّحُوا أجسادَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","بَلْ يَكُونُوا مُقَدَّسِينَ لإلَهِهِمْ، وَلا يُدَنِّسُوا اسْمَ إلَهِهِمْ. لِأنَهُمُ يُقَدِّمُونَ تَقدِماتِ اللهِ، فَيَنبَغِي أنْ يَكُونُوا مُقَدَّسِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","«لا يَتَزَوَّجِ الكَهَنَةُ مِنْ عاهِرَةٍ أوْ نَجِسَةٍ أوْ مُطَلَّقَةٍ مِنْ زَوجِها، لِأنَّ الكاهِنَ مُقَدَّسٌ لإلَهِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","عامِلُوا الكاهِنَ كَشَخْصٍ مُقَدَّسٍ لِأنَّهُ يُقَدِّمُ تَقدِمَةَ إلَهِكُمْ. يَكُونُ مُقَدَّساً بِالنِّسبَةِ لَكُمْ، لِأنِّي أنا اللهُ قُدُّوسٌ وَأُقدِّسُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","«إنْ نَجَّسَتِ ابْنَةُ كاهِنٍ نَفسَها بِأنْ زَنَتْ فَإنَّها تَجعَلُ أباها نَجِساً. تُحْرَقُ بِالنّارِ حَتَّى المَوتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«أمّا رَئيسُ الكَهَنَةِ الَّذِي سُكِبَ عَلَى رَأسِهِ زَيتُ المَسحَةِ، وَعُيِّنَ لِيَرتَدِيَ ثِيابَ رَئِيسِ الكَهَنَةِ الخاصَّةِ، فَلا يَكْشِفْ رَأسَهُ وَلا يُمَزِّقْ ثِيابَهُ حُزناً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","وَلا يَقتَرِبْ مِنْ جَسَدٍ مَيِّتٍ، لِئَلّا يَتَنّجَّسَ، حَتَّى لَوْ كانَ المَيِّتُ أباهُ أوْ أُمَّهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","وَلا يَترُكَ المَكانَ المُقَدَّسَ، فَلا يُنَجِّسَ مَكانَ إلَهِهِ المُقَدَّسِ لِأنَّهُ مُكَرَّسٌ للهِ بِزَيتِ مَسحَةِ إلَهِهِ. أنا اللهَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","«لِيَتَزَوَّجْ رَئِيسُ الكَهَنَةِ عَذراءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","فَلا يَجُوزُ أنْ يَتَزَوَّجَ مِنْ أرمَلَةٍ أوْ مُطَلَّقَةٍ أوْ زانِيَةٍ نَجِسَةٍ. لا يَتَزَوَّجُ إلّا مِنْ عَذراءَ مِنْ شَعبِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","لِئَلّا يُنَجِّسَ أولادَهُ وَسَطَ شَعبِهِ، لِأنِّي أنا اللهَ قَدْ قَدَّسْتُهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«قُلْ لِهارُونَ: إنْ كانَ رَجُلٌ مِنْ نَسلِكَ فِي كُلِّ أجيالِهِ لَدَيهِ عَيبٌ جَسَدِيٌّ، فَلا يُمكِنُهُ أنْ يَقتَرِبَ مِنَ المَذبَحِ لِيُقَدِّمَ تَقدِماتِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","فَلا يَنبَغِي أنْ يَقتَرِبَ إلَى المَذبَحِ رَجُلٌ فِيهِ عَيبٌ جَسَدِيٌّ، لا أعمَى وَلا أعرَجُ وَلا مُشَوَّهُ الوَجهِ أوِ الجَسَدِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","وَلا رَجُلٌ مَكْسُورُ اليَدِ أوِ الرِّجلِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","وَلا أحدَبُ وَلا قَزَمٌ وَلا مَنْ لَدَيهِ عَيبٌ فِي عَينَيهِ، وَلا أجْرَبُ وَلا أبْرَصُ وَلا مَسْحُوقُ الخُصَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","«كُلُّ رَجُلٍ مِنْ نَسلِ هارُونَ فِيهِ عَيبٌ، لا يُمكِنُهُ الاقتِرابُ مِنَ المَذبَحِ لِيُقَدِّمَ تَقدِماتِ اللهِ وَفِيهِ عَيبٌ، فَلا يُقَدِّمْ تَقدِماتِ إلَهِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","لَكِنْ يُمكِنُهُ أنْ يَأكُلَ مِنْ جَمِيعِ الطَّعامِ المُقّدَّمِ لإلَهِهِ: الطَّعامِ المُقَدَّسِ وَطَعامِ الكَهَنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","لَكِنْ لا يُمكِنُهُ الدُّخُولُ خَلفَ الحِجابِ أوْ الاقتِرابُ مِنَ المَذبَحِ، لِأنَّ فِيهِ عَيباً. فَلا يَنبَغِي أنْ يُنَجِّسَ أماكِنِي المُقَدَّسَةَ، لِأنِّي أنا اللهَ سَأُقَدِّسُكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","فَقالَ مُوسَى كُلَّ هَذِهِ الأُمُورَ لِهارُونَ وَأبْنائِهِ وَكُلِّ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","وَكَلَّمَ اللهُ مُوسَى فَقالَ لَهُ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«كَلِّمْ هارُونَ وَنَسلَهُ وَقُلْ لَهُمْ أنْ يَتَجَنَّبُوا استِخدامَ التَّقدِماتِ الَّتِي يُكَرِّسُها الشَّعبُ لِي وَحدِي. فَهُمْ بِهَذا يُدَنِّسُونَ اسْمِي، أنا يهوه. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","قُلْ لَهُمْ: مِنَ الآنَ فَصاعِداً، مَنْ يَقتَرِبُ مِنْ أولادِكُمْ إلَى التَّقدِماتِ المُقَدَّسَةِ الَّتِي يُكَرِّسُها بَنُو إسْرائِيلَ للهِ وَحدَهُ، فَهُوَ نَجِسٌ. يَنبَغِي أنْ يُعزَلَ مِنْ مَحضَرِي، أنا اللهَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","«لا يُسْمَحُ لأيِّ رَجُلٍ مِنْ نَسلِ هارُونَ لَدَيهِ بَرَصٌ أوْ إفرازٌ مِنْ جَسَدِهِ، أنْ يَأكُلَ مِنَ الطَّعامِ المُقَدَّسِ إلَى أنْ يُصبِحَ طاهِراً. فَمَنْ لَمَسَ شَخْصاً أوْ شَيئاً تَنَجَّسَ بِسَبَبِ لَمسِهِ جَسَداً مَيِّتاً، أوْ لَمَسَ رَجُلاً أفرَزَ سائِلاً مَنَوِيّاً، ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","أوْ لَمَسَ حَيواناً زاحِفاً نَجِساً، أوْ شَخصاً نَجِساً، مَهما كانَ سَبَبُ نَجاسَتِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","فَالشَّخصُ الَّذِي يَلمِسُ يَكُونُ نَجِساً إلَى المَساءِ. لا يُمكِنُهُ أنْ يَأكُلَ مِنَ الطَّعامِ المُقَدَّسِ إلّا بَعدَ أنْ يَغسِلَ جَسَدَهُ بِماءٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","وَحِينَ تَغرُبُ الشَّمسُ يَكُونُ طاهِراً. بَعدَ ذَلِكَ يُمكِنُهُ أنْ يَأكُلَ مِنَ الطَّعامِ المُقَدَّسِ لِأنَّهُ طَعامُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","«لا يَنبَغِي أنْ يَأكُلَ الكاهِنُ حَيواناً ماتَ وَحْدَهُ أوْ مَزَّقَهُ حَيوانٌ بَرِّيٌّ، لأنَّهُ يَتَنَجَّسُ بِهِ. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","«لِيُحافِظِ الكَهَنَةُ عَلَى شَعائِرِي، لِئَلّا يأثَمُوا وَيَمُوتوا فِي المَكانِ المُقَدَّسِ لِأنَّهُمْ دَنَّسُوا تَعالِيمِي. أنا اللهَ أُقَدَّسَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«لا يُسْمَحُ لِغَريبٍ بأنْ يَأكُلَ مِنَ الطَّعامِ المُقَدَّسِ، وَلا ضَيْفُ الكاهِنِ وَلا أجِيرٌ عِنْدَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","لَكِنْ إنِ اشتَرَى كاهِنٌ عَبداً بِمالِهِ، أوْ وُلِدَ عَبدٌ فِي بَيتِهِ، يُسمَحُ لَهُما بِأنْ يَأكُلا مِنَ الطَّعامِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","إنْ تَزَوَّجَتِ ابْنَةُ الكاهِنِ رَجُلاً مِنْ خارِجِ العائِلَةِ الكَهنُوتِيَّةِ، لا يَعُودُ بِإمكانِها أنْ تَأكُلَ مِنَ التَّقدِماتِ المُقَدَّسَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","فَإنْ تَرَمَّلَتِ ابْنَةُ الكاهِنِ أوْ تَطَلَّقَتْ، وَلا أولادَ لَها، وَعادَتْ إلَى بَيتِ أبِيها، كَما فِي أيّامِ شَبابِها، فَيُمكِنُها أنْ تَأكُلَ مِنْ طَعامِ أبِيها. لَكِنْ لا يُسْمَحُ بِذَلِكَ لِأحَدٍ مِنْ خارِجِ العائِلَةِ الكَهنُوتِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","«فإنْ أكَلَ شَخصٌ مِنَ التَّقدِماتِ المُقَدَّسَةِ بِغَيرِ قَصدٍ، يَنبَغِي أنْ يُضِيفَ خُمْسَ الكَمِّيَّةِ الَّتِي أكَلَها، وَيَرُدَّها لِلكاهِنِ تَعوِيضاً عَنِ الطَّعامِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","«عَلَى الكَهَنَةِ أنْ لا يسمَحُوا بِتَدْنيسِ تَقْدِماتِ بَنِي إسْرائِيلَ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","فَلا يُحَمِّلُوا الشَّعبَ ذَنباً يَستَحِقُّ العُقُوبَةَ، بِأنْ يَسْمَحُوا لَهُمْ بِأكلِ تَقدِماتِهِمِ المُقَدَّسَةِ. لِأنِّي أنا اللهُ أقَدِّسُهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«قُلْ لِهارُونَ وَأبْنائِهِ وَكُلِّ بَنِي إسْرائِيلَ: حِينَ يُقَدِّمُ أيُّ إنسانٍ مِنْ بَيتِ إسْرائِيلَ، أوْ أيُّ أجْنَبِيٍّ مُقيْمٍ فِي إسْرائِيلَ، ذَبيحَةً لإيفاءِ نَذْرٍ أوْ كَتَقدِمَةٍ اختِيارِيَّةٍ للهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","فَيَنبَغِي أنْ تَكُونَ ذَكَراً لا عَيبَ فِيهِ مِنَ البَقَرِ أوِ الغَنَمِ أوِ الماعِزِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","لا تُقَدِّمُوا حَيواناً فِيهِ عَيبٌ لِأنَّهُ لَنْ يَكُونَ مَقبُولاً مِنكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","«حِينَ يُقَدِّمُ رَجُلٌ مِنَ البَقَرِ أوِ الغَنَمِ ذَبِيحَةَ سَلامٍ للهِ إتماماً لِنَذْرٍ أوْ كَتَقدِمَةٍ اختِيارِيَّةٍ، يَنبَغِي أنْ تَكُونَ بِلا عَيبٍ لِتَكُونَ مَقبُولَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","فَلا تُقَدِّمُوا حَيواناً أعمَى أوْ أعرَجَ أوْ مُشَوَّهاً أوْ ذا بُثُورٍ أوْ أجْرَبَ أوْ أبْرَصَ. لا تُقَدِّمُوا عَلَى المَذبَحِ تَقدِمَةٍ للهِ حَيواناً فِيهِ إحْدَى هَذِهِ العُيُوبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","«يُمكِنُكُمْ أنْ تُقَدِّمُوا ثَوراً أوْ حَمَلاً قَزَماً أوْ مُشَوَّهاً كَتَقدِمَةٍ اختِيارِيَّةٍ، لَكِنَّهُ لا يَكُونُ مَقبُولاً كَنَذْرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","لا تُقَدِّمُوا للهِ حَيواناً خِصيَتُهُ مَرضُوضَةٌ أوْ مَسحُوقَةٌ أوْ مَقطُوعَةٌ. لا يَنبَغِي عَمَلُ هَذا فِي أرْضِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","وَلا تَأخُذُوا مِثلَ هَذِهِ الحَيواناتِ مِنْ غَرِيبٍ وَتُقَدِّمُوها لإلَهِكُمْ، لِأنَّها مُشَوَّهَةٌ وَفِيها عَيبٌ، فَلَنْ تُقبَلَ مِنكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«حِينَ يُولَدُ بَقَرٌ أوْ غَنَمٌ أوْ ماعِزٌ، يَبقَى المُولُودُ مَعَ أُمِّهِ لِسَبعَةِ أيّامٍ، وَمِنَ اليَومِ الثّامِنِ فَصاعِداً يَكُونُ مَقبُولاً كَتَقدِمَةٍ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","«لا تَذبَحُوا بَقَرَةً أوْ نَعجَةً وَابْنَها فِي ذاتِ اليَومِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«وَحِينَ تُقَدِّمُونَ ذَبِيحَةَ شُكرٍ للهِ، اذبَحُوها بِطَرِيقَةٍ مَقبُولَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","يَنبَغِي أنْ تُؤكَلَ فِي ذَلِكَ اليَومِ وَأنْ لا يُتْرَكَ شَيءٌ مِنها حَتَّى الصَّباحِ. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«فَهَكَذا تُطيعُونَ وَصايايَ وَتَعْمَلُونَ بِها. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","وَلا تُنَجِّسُونَ اسْمِيَ القُدُّوسِ. لِيَتَذَكَّرْ بَنُو إسْرائِيلَ أنِّي قُدُّوسٌ. أنا اللهُ الَّذِي أُقَدِّسُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","أخرَجْتُكُمْ مِنْ أرْضِ مِصرَ لِأكُونَ إلَهَكُمْ. أنا اللهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«قُلْ لِبَنِي إسْرائِيلَ: هَذِهِ هِيَ أعيادُ اللهِ الَّتِي حَدَّدْتُ مَواعِيدَها، فأعلِنُوها كَمُناسَباتٍ خاصَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«تَعمَلُونَ فِي سِتَّةِ أيّامٍ، لَكِنَّ اليَومَ السّابِعَ يَكُونُ يَومَ راحَةٍ، سَبْتاً، مُناسَبَةً مُقَدَّسَةً، فَلا تَعمَلُوا فِيهِ. إنَّهُ سَبتٌ للهِ فِي كُلِّ أماكِنِ سُكناكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«هَذِهِ هِيَ أعيادُ اللهِ الخاصَّةِ، المَواسِمُ المُقَدَّسَةُ الَّتِي تُعلِنُوها فِي أوقاتِها المُعَيَّنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","فِي اليَومِ الرّابِعَ عَشَرَ مِنَ الشَّهرِ الأوَّلِ تُقَدِّمُونَ ذَبيحَةَ الفِصحِ للهِ بَعْدَ الغُرُوبِ وَقَبلَ حُلُولِ الظَلامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","«وَفِي اليَومِ الخامِسَ عَشَرَ مِنَ الشَّهرِ نَفْسِهِ، يَبْدأُ عِيدُ الخُبزِ غَيرِ المُختَمِرِ للهِ. وَلِمُدَّةِ سَبعَةِ أيّامٍ، تَأكُلُونَ خَبْزاً غَيرَ مُخْتَمِرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","فِي اليَومِ الأوَّلِ، يَكُونُ لَكُمُ اجتِماعٌ مُقَدَّسٌ. وَتَتْرُكُونَ جَمِيعَ أعْمالِكُمْ فِي ذَلِكَ اليَوْمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","تَأتُونَ بِتَقدِماتٍ تُحَرَقُ للهِ لِسَبعَةِ أيّامٍ. وَفِي اليَومِ السّابِعِ، يَكُونُ هُناكَ اجتِماعٌ مُقَدَّسٌ. وَتَتْرُكُونَ جَمِيعَ أعْمالِكُمْ فِي ذَلِكَ اليَوْمِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«قُلْ لِبَنِي إسْرائِيلَ: حِينَ تَدخُلُونَ الأرْضَ الَّتِي سَأُعطِيها لَكُمْ وَتَحصُدُونَ مَحاصِيلَها، أحْضِرُوا أوَّلَ حُزمَةٍ مِنْ حَصِيدِكُمْ إلَى الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","يُقَدِّمُ الكاهِنُ الحُزمَةَ فِي حَضْرَةِ اللهِ لِتُقبَلَ مِنكُمْ. يُقَدِّمُها فِي اليَومِ الَّذِي يَلِي السَّبتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","«وَفي اليَومِ الَّذِي تُقَدِّمُونَ فِيهِ الحُزمَةَ، قَدِّمُوا حَمَلاً عُمْرُهُ سَنَةٌ لا عَيبَ فِيهِ ذَبيحَةً صاعِدَةً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","وَقَدِّمُوا تَقدِمَةَ طَحِينٍ مَعَ الحَمَلِ: عُشْرَينِ القُفَّةِ مِنَ الطَّحِينِ مَمزُوجاً بِالزَّيتِ، تِقْدِمَةً مُعَدَّةً بِالنّارِ كَرائِحَةٍ يُسَرُّ بِها اللهُ. وَتَسكُبُونَ تَقدِمَةً مِنَ النَّبيذِ بِمِقدارِ وِعاءٍ واحِدٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","لا تَأكُلُوا مِنَ القَمحِ الجَدِيدِ – لا فَرِيكاً وَلا خُبزاً – إلَى اليَومِ الَّذِي تَأتُونَ فِيهِ بِهَذِهِ التَّقدِمَةِ إلَى إلَهِكُمْ. سَتَكُونُ لَكُمْ هَذِهِ الشَّرِيعَةُ جِيلاً بَعْدَ جِيلٍ حَيثُما تَسكُنُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«احسِبُوا سَبعَةَ أسابِيعَ كامِلَةً، مِنْ اليَومِ التّالِي لِلسَّبتِ حِيْنَ أحضَرْتُمْ حُزمَةَ التَّقدِمَةِ الَّتِي رُفِعَتْ فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","احسِبُوا خَمسِينَ يَوماً إلَى اليَومِ الَّذِي يَلِي السَّبتَ، وَقَدِّمُوا تَقدِمَةً جَدِيدَةً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","أحْضِرُوا مِنْ بُيُوتِكُمْ رَغِيفَيِّ خُبزٍ تَقدِمَةً مَرفُوعَةً للهِ. يُصْنَعُ الرَّغِيفانِ مِنْ عُشْرَي قُفَّةٍ مِنْ طَحِينٍ جَيِّدٍ، وَيُخبَزانِ مَعَ خَمِيرَةٍ. هَذِهِ هِيَ تَقدِمَتُكُمْ للهِ مِنْ باكُورَةِ أوَّلِ الحَصادِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","وَقَدِّمُوا مَعَ الخُبزِ سَبعَةَ حِملانٍ ذُكُورٍ عُمْرُ الواحِدِ سَنَةٌ، وَعِجلاً، وَكَبْشَينِ، جَمِيعُها بِلا عَيبٍ. لِتَكُونَ ذَبيحَةً صاعِدَةً للهِ مَعَ تَقدِمَةِ الطَّحِينِ وَمَعَ السَّكِيبِ، تِقْدِمَةً مُعَدَّةً بِالنّارِ كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ثُمَّ قَدِّمُوا تَيساً ذَكَراً ذَبيحَةَ خَطِيَّةٍ، وَحَمَلَينِ عُمْرُ الواحِدِ سَنَةٌ، تُقَدَّمُ ذَبِيحَةَ سَلامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","«يَرفَعُ الكاهِنُ الحَمَلَينِ مَعَ الخُبزِ الَّذِي مِنْ باكُورَةِ أوَّلِ الحَصادِ تَقدِمَةً فِي حَضرَةِ اللهِ. تَكُونُ التَّقدِمَةُ مُقَدَّسَةً للهِ وَتُعطَى لِلكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","فِي ذَلِكَ اليَومِ نَفْسِهِ، تُعلِنُونَ انْعِقادَ اجتِماعٍ مُقَدَّسٍ. وَتَتْرُكُونَ جَمِيعَ أعْمالِكُمْ فِي ذَلِكَ اليَوْمِ. سَتَكُونُ لَكُمْ هَذِهِ الشَّرِيعَةُ فِي جَمِيعِ أجيالِكُمْ حَيثُما تَسكُنُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«حِينَ تَحصُدُونَ أرْضَكُمْ، لا تَحصُدُوا أطرافَها، وَلا تَعُودُوا إلَى الحَقلِ لِجَمْعِ ما تَبَقَّى أوْ سَقَطَ، بَلْ تَترُكُوهُ لِلفُقَراءِ وَالغُرَباءِ. أنا إلَهُكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«قُلْ لِبَنِي إسْرائِيلَ: يَكُونُ اليَومُ الأوَّلُ مِنَ الشَّهرِ السّابِعِ يَومَ راحَةٍ لَكُمْ. تَنفُخُونَ فِي البُوقِ لِتُذَكِّرُوا النّاسَ بِالاحتِفالِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","لا تَقُومُوا بِأيِّ عَمَلٍ فِي ذَلِكَ اليَومِ، بَلْ قَدِّمُوا تَقدِماتٍ للهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«سَيَكُونُ يَومُ الكَفّارَةِ فِي اليَومِ العاشِرِ مِنَ الشَّهرِ السّابِعِ. سَيَكُونُ مُناسَبَةً خاصَّةً لَكُمْ. تَتَذَلَّلُونَ بِالصَومِ فِي هَذا اليَومِ وَتُحضِرُونَ تَقدِماتٍ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","اتْرُكُوا جَمِيعَ أعْمالِكُمْ فِي هَذا اليَومِ لِأنَّهُ يَومُ الكَفّارَةِ، لِلتَّكْفِيرِ عَنْكُمْ فِي حَضْرَةِ إلَهِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","«فَمَنْ لَمْ يَصُمْ فِي هَذا اليَومِ، يُقطَعُ مِنَ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","وَإنْ عَمِلَ أحَدٌ عَمَلاً فِي هَذا اليَومِ، يُبادُ مِنَ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","اتْرُكُوا جَمِيعَ أعْمالِكُمْ فِي هَذا اليَومِ. سَتَكُونُ لَكُمْ هَذِهِ الشَّرِيعَةُ جِيلاً بَعْدَ جِيلٍ حَيثُما تَسكُنُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","سَيَكُونُ يَومَ راحَةٍ لَكُمْ، تَتَذَلَّلُونَ فِيهِ بِالصَومِ. مِنْ مَساءِ اليَومِ التّاسِعِ فِي الشَّهرِ وَحَتَّى مَساءِ اليَومِ التّالِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«قُلْ لِبَنِي إسْرائِيلَ: فِي اليَومِ الخامِسَ عَشَرَ مِنَ الشَّهرِ السّابِعِ يَبدَأُ عِيدُ السَّقائِفِ، وَيَسْتَمِرُّ سَبعَةَ أيّامٍ إكراماً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","يَكُونُ اليَومُ الأوَّلُ اجتِماعاً مُقَدَّساً، تَتْرُكُونَ فِيهِ جَمِيعَ أعْمالِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","تُحْضِرُونَ تَقدِماتٍ للهِ لِسَبعَةِ أيّامٍ. وَفِي اليَومِ الثّامِنِ، تَعْقِدُونَ اجتِماعاً مُقَدَّساً، وَتُحضِرُونَ فِيهِ تَقدِماتٍ مُعَدَّةً بِالنّارِ للهِ. يَكُونُ ذَلِكَ تَجَمُّعاً مَهِيباً، وَتَتْرُكُونَ جَمِيعَ أعْمالِكُمْ فِي ذَلِكَ اليَوْمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«هَذِهِ هِيَ أعيادُ اللهِ الَّتِي تُعلِنُونَها مُناسَباتٍ مُقَدَّسَةً، لِتَقدِيمِ تَقدِماتٍ للهِ: ذَبائِحَ صاعِدَةٍ وَتَقدِماتِ طَحِينٍ وَذَبائِحَ وَسَكِيباً، كُلُّ واحِدَةٍ مِنها فِي يَومِها المُناسِبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","تُقامُ هَذِهِ الأعيادُ عَدا سُبُوتِ اللهِ، وَعَدا تَقدِماتِ النُّذُورِ وَالتَّقدِماتِ الاختِيارِيَّةِ الإضافِيّةِ الَّتِي تُقَدِّمُونَها للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«فِي اليَومِ الخامِسَ عَشَرَ مِنَ الشَّهرِ السّابِعِ، وَبَعدَ أنْ تَكُونُوا قَدْ جَمَعتُمْ حَصِيدَ الأرْضِ وَغَلّاتِها، تَحتَفِلُونَ بِعِيدٍ للهِ لِسَبعَةِ أيّامٍ. وَاليَومُ الأوَّلُ وَالثّامِنُ سَيَكُونانِ يَومَي راحَةٍ خاصَّينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","فِي اليَومِ الأوَّلِ، تَأخُذُونَ مِنْ ثَمَرِ أشجارِكُمُ الجَيِّدِ، وَسُعُفاً مِنْ أشجارِ النَّخِيلِ، وَأغصاناً مِنْ أشجارٍ مُورِقَةٍ، وَمِنَ الصَّفصافِ الَّذِي بِجانِبِ الجَداوِلِ، وَتَحتَفِلُونَ فِي حَضْرَةِ إلَهِكُمْ سَبعَةَ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","احتَفِلُوا بِهِ عِيداً للهِ لِسَبعَةِ أيّامٍ فِي السَّنَةِ. سَتَكُونُ لَكُمْ هَذِهِ الشَّرِيعَةُ جِيلاً بَعْدَ جِيلٍ حَيثُما تَسكُنُونَ، تَحتَفِلُونَ بِهِ فِي اليَومِ السّابِعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","سَتَسكُنُونَ فِي سَقائِفَ مُؤَقَّتَةٍ لِسَبعَةِ أيّامٍ. سَيُقِيمُ كُلُّ مُواطِنٍ فِي إسْرائِيلَ فِي سَقائِفَ مُؤَقَّتَةٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","لِيَعرِفَ أحفادُكُمْ أنِّي أنا أسكَنتُ بَنِي إسْرائِيلَ فِي سَقائِفَ مُؤَقَّتَةٍ حِينَ أخرَجتُهُمْ مِنْ أرْضِ مِصرَ. أنا إلَهُكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","فَأخبَرَ مُوسَى بَنِي إسْرائِيلَ بِكُلِّ أعيادِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«مُرْ بَنِي إسْرائِيلَ بِأنْ يُحضِرُوا لَكَ زَيتَ زَيتُونٍ نَقِيّاً لِأجلِ المَنارَةِ، لِتَبقَى مُضاءَةً دائِماً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","عَلَى هارُونَ أنْ يُرَتِّبَها خارِجَ السِّتارَةِ المُعَلَّقَةِ أمامَ صُندُوقِ الشَّهادَةِ فِي خَيمَةِ الاجْتِماعِ، مِنَ المَساءِ وَحَتَّى الصَّباحِ فِي حَضْرَةِ اللهِ بِانتِظامٍ وَبِشَكلٍ دائِمٍ. هَذِهِ الشَّرِيعَةُ لِكُلِّ أجيالِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","وَيُرَتِّبُ هارُونَ السُّرُجَ عَلَى المَنارَةِ الطّاهِرَةِ فِي حَضْرَةِ اللهِ لِتَشتَعِلَ بِشَكلٍ دائِمٍ وَمُستَمِرٍّ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«خُذْ طَحِيناً جَيِّداً وَاخبِزْ مِنهُ اثنَي عَشَرَ رَغِيفاً. يُصْنَعُ الرَّغِيفُ مِنْ عُشْرَي قُفَّةِ طَحيْنٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ضَعِ الأرْغِفَةَ فِي صَفَّينِ. ضَعْ فِي كُلِّ صَفٍّ سِتَّةَ أرغِفَةٍ عَلَى المائِدَةِ الذَّهَبِيَّةِ الطّاهِرَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","وَضَعْ بَخُوراً نَقِيّاً عَلَى كُلِّ صَفٍّ مِنْ صًفُوفِ الخُبزِ، لِيَكُونَ رَمزاً وَتَقدِمَةً مَعَدَّةً بِالنّارِ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","يَنبَغِي تَرتِيبُ الأرغِفَةِ فِي حَضْرَةِ اللهِ فِي كُلِّ يَومِ سَبتٍ دائِماً مِنْ أجلِ بَنِي إسْرائِيلَ لِعَهدٍ دائِمٍ مُستَمِرٍّ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","سَيَكُونُ الخُبزُ لِهارُونَ وَأبْنائِهِ، وَسَيَأكُلُونَهُ فِي مَكانٍ مُقَدَّسٍ، لِأنَّهُ لَهُمْ نَصِيبٌ مُخَصَّصٌ لِلكَهَنَةِ بِالكامِلِ، نَصِيبٌ مِنْ تَقدِماتِ اللهِ، مَقْسُومٌ لَهَمْ إلَى الأبَدِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","وَخَرَجَ شابٌّ ابْنُ امْرأةٍ مِنْ بَنِي إسْرائِيلَ، وَكانَ أبوهُ رَجُلاً مِصرِيّاً يَعِيِشُ وَسَطَ بَنِي إسْرائِيلَ. وَتَشاجَرَ ابْنُ الإسْرائِيلِيَّةِ مَعَ رَجُلٍ مِنْ بَنِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","وَأهانَ ابْنُ الإسْرائِيلِيَّةِ اسْمَ يهوه وَنَطَقَ بِاللَّعنَةِ عَلَيهِ! فَأحضَرَهُ الشَّعبُ إلَى مُوسَى. وَكانَ اسْمُ أُمِّهِ شَلُومِيَةَ بِنتَ دِبْرِي مِنْ قَبِيلَةِ دانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","وَوَضَعُوهُ تَحتَ الحِراسَةِ حَتَّى يُعلِنَ اللهُ ما يَنبَغِي عَمَلُهُ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«خَذِ الرَّجُلَ الَّذِي نَطَقَ بِلَعنَةٍ عَلَيَّ، إلَى خارِجِ المُخَيَّمِ. وَلَيَضَعْ جَمِيعُ الَّذِينَ سَمِعُوهُ أيدِيَهُمْ عَلَى رَأسِهِ. ثُمَّ يَقْتُلُهُ الشَّعبُ رَجْماً بِالحِجارَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ثُمَّ قُلْ لِبَنِي إسْرائِيلَ: إنْ نَطَقَ أحَدٌ بِلَعنَةٍ عَلَى اللهِ، يَنبَغِي أنْ يُعاقَبَ عَلَى خَطِيَّتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","وَإنْ أهانَ أحَدٌ اسْمَ يهوه، يَنبَغِي أنْ يُقتَلَ. يَقْتُلُهُ الشَّعبُ رَجْماً بِالحِجارَةِ. الغَرِيبُ أوِ المُواطِنُ الَّذِي يُهِينُ اسْمَ يهوه يَنبَغِي أنْ يُقتَلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«إذا قَتَلَ أحَدٌ إنساناً فَيَنبَغِي أنْ يُقتَلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","وَمَنْ يَقتُلُ حَيواناً يَملُكُهُ شَخصٌ آخَرُ يَنبَغِي أنْ يُعَوِّضَ عَنهُ بِمِثلِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","إنْ آذَى شَخصٌ جارَهُ، فَمَهما كانَ ما فَعَلَهُ يُفعَلُ بِهِ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","كَسرٌ بِكَسرٍ، وَعَينٌ بِعَينٍ، وَسِنٌّ بِسِنٍّ. مَنْ يُؤذِي يَنبَغِي أنْ يُؤذَى بِمِثلِ أذِيَّتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","وَمَنْ يَقتُلُ حَيواناً يُعَوِّضُ عَنهُ. وَمَنْ يَقتُلُ إنساناً يُقتَلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","هَذِهِ شَرِيعَةٌ واحِدَةٌ لِجَمِيعِكُمْ، لِلغَرِيبِ وَلِلمُواطِنِ، أنا إلَهُكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ثُمَّ كَلَّمَ مُوسَى بَنِي إسْرائِيلَ، فَأخَذُوا الرَّجُلَ الَّذِي جَدَّفَ إلَى خارِجِ المُخَيَّمِ، وَقَتَلُوهُ بِرَجمِهِ بِالحِجارَةِ. وَبِهَذا عَمِلَ بَنُو إسْرائِيلَ كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","وَقالَ اللهُ لِمُوسَى عَلَى جَبَلِ سِيناءَ: ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«قُلْ لِبَنِي إسْرائِيلَ: حِينَ تَدخُلُونَ الأرْضَ الَّتِي سَأُعطِيها لَكُمْ، أرِيحُوا الأرْضَ منَ الزِّراعَةِ فِي كُلِّ سابِعِ سَنَةٍ لإكرامِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","لِسِتِّ سَنَواتٍ يُمكِنُكَ أنْ تَزرَعَ حَقلَكَ وَتُقَلِّمَ كَرمَكَ وَتَجمَعَ الغِلالَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","أمّا السَّنَةُ السّابِعَةُ فَتَكُونُ راحَةً تامَّةً لِلأرْضِ، سَبتاً لإكرامِ اللهِ. لا تَزرَعْ فِيها حَقلَكَ وَلا تُقَلِّمْ كَرْمَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","وَلا تَحصُدِ المَحاصِيلَ الَّتِي تَنمُو مِنْ ذاتِها، وَلا تَجمَعْ عِنَبَ الكُرُومِ غَيرِ المُقَلَّمَةِ. إنَّها سَنَةُ راحَةٍ تامَّةٍ لِلأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","«أمَّا ما تُخرِجُهُ الأرْضُ مِنْ ذاتِها فِي سَنَةِ راحَتِها سَيَكُونُ لَكُمْ طَعاماً لَكَ وَلِعَبدِكَ وَلِأمَتِكَ وَلِأجِيرِكَ وَلِلغَرِيبِ السّاكِنِ مَعَكُمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","وَلِماشِيَتِكَ وَلِلحَيواناتِ البَرِّيَّةِ الَّتِي فِي أرْضِكَ. كُلُّ ما تُنتِجُهُ الأرْضُ سَيَكُونُ لَكُمْ طَعاماً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«احسِبْ سَبعَ سِنِينَ سَبعَ مَرّاتٍ، فَيَكُونُ مَجمُوعُها تِسعاً وَأربَعِينَ سَنَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ثُمَّ تَنفُخُونَ بِالبُوقِ فِي اليَومِ العاشِرِ مِنَ الشَّهرِ السّابِعِ، أي فِي يَومِ الكَفّارَةِ، فِي كُلِّ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","تَعْتَبِرُونَ السَّنَةَ الخَمسِينَ مُقَدَّسَةً وَمُمَيَّزَةً. فَتُعلِنُونَ فِيها العِتْقَ لِكُلِّ مَنْ يَعِيشُ فِي الأرْضِ. ادعُو هَذِهِ السَّنَةَ سَنَةَ اليُوبِيلِ. كُلُّ واحِدٍ فِيكُمْ سَيَعُودُ إلَى مُلكِهِ وَعَشِيرَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","سَتَكُونُ السَّنَةُ الخَمسُونَ يُوبِيلاً لَكُمْ. لا تَزرَعُوا فِيها وَلا تَحصُدُوا ما يَنبُتُ وَحْدَهُ، وَلا تَقطِفُوا العِنَبَ مِنَ الكُرُومِ غَيرِ المُقَلَّمَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","لِأنَّ هَذِهِ سَنَةُ اليُوبِيلِ، وَهِيَ مُقَدَّسَةً لَكُمْ. يُمكِنُكُمْ أنْ تَأكُلُوا ما يَتَساقَطُ مِنَ الثَّمَرِ وَحدَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","فِي سَنَةِ اليُوبِيلِ سَيَعُودُ كُلُّ واحِدٍ مِنكُمْ إلَى مُلكِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","«حِينَ تَبِيعُ مُلْكَكَ لِجارِكَ، أوْ حِينَ تَشتَرِي مِنْ جارِكَ، لا يَغِشَّ بَعضُكُمْ بَعضاً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","اشْتَرِ مِنْ جارِكَ بِحَسَبِ عَدَدِ السِّنِينِ مِنْ سَنَةِ اليُوبِيلِ السّابِقَةِ. يَنبَغِي أنْ يَبِيعَكَ بِحَسَبِ عَدَدِ سِنِيِّ المَحاصِيلِ الباقِيَةِ حَتَّى اليُوبِيلِ التّالِي. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","كُلَّما كانَتِ السَّنَواتُ الباقِيَةُ أكثَرَ يَرتَفِعُ سِعرُ الأرْضِ، وَكُلَّما قَلَّ عَدَدُ السَّنَواتِ يَنخَفِضُ سِعرُ الأرْضِ، لِأنَّهُ يَبِيعُ عَدَدَ المَحاصِيلِ لَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","لا يَغِشَّ بَعضُكُمْ بَعضاً، بَلِ اخشُوا اللهَ، لِأنِّي أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","«أطِيعُوا شَرائِعِي، وَاحْفَظُوا أحكامِي وَاعْمَلُوا بِها كَي تَعِيشُوا فِي الأرْضِ بِأمانٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","فَتُعْطِي الأرْضُ غَلَّتَها، وَيَكُونُ لَدَيكُمْ طَعامٌ كَثِيرٌ، وَتَسكُنُونَ فِي أمانٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","«وَإنْ قُلْتُمْ: ‹ماذا سَنَأكُلُ فِي السَّنَةِ السّابِعَةِ إنْ لَمْ نَزرَعْ وَلَمْ نَجمَعْ غَلّاتِ الأرْضِ؟› ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","فَإنِّي سَآمُرُ بِأنْ تَأتِيَ بَرَكَتِي عَلَيكُمْ فِي السَّنَةِ السّادِسَةِ، فَتُنتِجُ الأرْضُ غَلّاتٍ تَكفِي لِثَلاثِ سِنِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","فَتَأكُلُونَ مِنْ هَذِهِ الغَلّاتِ بَينَما تَزرَعُونَ فِي السَّنَةِ الثّامِنَةِ. فَتأكُلُونَ مِنَ الغَلَّةِ القَدِيمَةِ حَتَّى حَصادِ السَّنَةِ التّاسِعَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«يُمْنَعُ أنْ تُباعَ الأرْضُ بِشَكلٍ دائِمٍ، لِأنَّ الأرْضَ لِي، وَأنتُمْ غُرَباءُ وَوُكَلاءُ يَسكُنُونَ أرْضِي. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","فِي كُلِّ أرْضِكُمُ الَّتِي تَمتَلِكُونَها، تَسمَحُونَ لِمالِكِ الأرْضِ الأصلِيِّ أنْ يَرُدَّها بِدَفعِ ثَمَنِها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","إذا افتَقَرَ قَرِيبُكَ وَباعَ جُزءاً مِنْ أرْضِهِ، فَعَلَى قَرِيبِهِ أنْ يَأتِيَ وَيَستَرِدَّ الأرْضَ الَّتِي باعَها قَرِيبُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","فَإنْ لَمْ يَكُنْ لَهُ قَرِيبٌ لِيَشتَرِيَها، لَكِنَّهُ استَطاعَ الحُصُولَ عَلَى ما يَكفِي مِنَ المالِ لِاستِعادَةِ أرْضِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","فَحِينَئِذٍ، يَحسِبُ السَّنَواتِ مُنذُ باعَها، وَيَدفَعُ لِلمُشتَرِي مُقابِلَ ما تَبَقَّى مِنَ السَّنَواتِ، وَيَعُودُ إلَى أرْضِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","لَكِنْ إنْ لَمْ يَكَنْ قادِراً عَلَى شِرائِها ثانِيَةً، فَإنَّها تَبقَى مُلكاً لِلَّذِي اشتَراها إلَى سَنَةِ اليُوبِيلِ. وَفِي سَنَةِ اليُوبِيلِ، تُعتَقُ الأرْضُ، وَتَعُودُ إلَى صاحِبِها الأصلِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«إنْ باعَ رَجُلٌ بَيتاً فِي مَدِينَةٍ مُحاطَةٍ بِأسوارٍ، فَيُمكِنُ أنْ يَشتَرِيَهُ ثانِيَةً خِلالَ سَنَةٍ مِنْ بَيعِهِ. فَحَقُّهُ بِاسْتِعادَتِهِ مَحصُورٌ فِي سَنَةٍ واحِدَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","فَإنْ لَمْ يَشتَرِ البَيتَ قَبلَ اكتِمالِ السَّنَةِ، فَإنَّ البَيتَ فِي المَدِينَةِ المُحاطَةِ بِأسوارٍ يَصِيرُ مُلكاً دائِماً لِلَّذِي اشتَراهُ وَلِنَسلِهِ مِنْ بَعدِهِ، وَلَنْ يَتِمَّ تَحْرِيرُهُ فِي سَنَةِ اليُوبِيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","أمّا البُيُوتُ الَّتِيُ فِي القُرَى الَّتِي بِلا أسوارٍ فَإنَّها تُعامَلُ كَمُعامَلَةِ الأرْضِ، إذْ يُمكِنُ لِصاحِبِها أنْ يَشتَرِيَها ثانِيَةً، وَيَتِمُّ تَحْرِيرُها فِي سَنَةِ اليُوبِيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","«أمّا بُيُوتُ اللّاوِيِّينَ الَّتِي فِي مُدُنِ اللّاوِيِّينَ المُحاطَةِ بِأسْوارٍ فَيُمكِنُ شِراؤُها ثانِيَةً فِي أيِّ وَقتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","وَإنْ لَمْ يَشْتَرِ اللّاوِي بَيتَهُ ثانِيَةً، فَإنَّ ذَلِكَ البَيتَ يَعُودُ إلَى مالِكِهِ فِي سَنَةِ اليُوبِيلِ، لِأنَّ بُيُوتَ الَّلاوِيِّينَ فِي المُدُنِ مُلكٌ دائِمٌ لَهُمْ وَسَطَ بَنِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","وَأمّا الأرْضُ الَّتِي حَولَ مُدُنِهِمْ فَلا يَجُوزُ بَيعُها لِأنَّها مُلْكٌ أبَدِيُّ لِجَمِيعِ اللّاوِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«إنِ افتَقَرَ واحِدٌ مِنْ إخْوَتِكَ بَنِي إسْرائِيلَ، وَلَمْ يَستَطِعْ إعالَةَ نَفسِهِ، فَساعِدْهُ، حَتَّى وَإنْ كانَ غَرِيباً مُقِيماً فِي أرْضِكَ أوْ نَزيلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","اخشَ إلَهَكَ وَلا تَأخُذْ مِنْ ذَلِكَ الشَّخصِ رِباً، لِكَي يَتَمَكَّنَ مِنَ العَيشِ بَينَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","لا تُقرِضْهُ مالَكَ بِفائِدَةٍ، وَلا تُعطِهِ طَعامَكَ مُقابِلَ رِبحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","أنا إلَهُكُمْ الَّذِي أخرَجَكُمْ مِنْ أرْضِ مِصرَ لِأُعطِيَكُمْ أرْضَ كَنعانَ، وَلِأكُونَ إلَهَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«إنِ افتَقَرَ أحَدٌ مِنْ شَعبِكَ وَباعَ نَفْسَهُ لَكَ، فَلا تَسْتَعْبِدْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","بَلْ يَعْمَلُ لَدَيكَ كَأجِيرٍ أوْ وَكِيلٍ، وَيَخدِمُكَ إلَى سَنَةِ اليُوبِيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ثُمَّ يَترُكُكَ هُوَ وَأولادُهُ وَيَعُودُونَ إلَى عَشِيرَتِهِمْ وَأرْضِ آبائِهِمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","لِأنَّهُمْ عَبِيدِي الَّذِينَ أخرَجتُهُمْ مِنْ أرْضِ مِصرَ، فَلا يُباعُونَ كَعَبِيدٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","لا تَتَسَلَّطْ عَلَيهِ بِقَسوَةٍ، بَلِ اخشَ إلَهَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","«يَنبَغِي أنْ يَكُونَ عَبِيدُكَ وَجَوارِيكَ مِنَ الأُمَمِ الَّتِي حَولَكَ، فَتَشتَرِي العَبِيدَ وَالجَوارِيَ مِنهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","وَيُمكِنُكَ أنْ تَشتَرِيَ عَبِيداً مِنْ أبناءِ الغُرَباءِ السّاكِنِينَ مَعَكُمْ، أوْ مِنْ عَشائِرِهِمِ السّاكِنَةِ مَعَكُمُ الَّذِينَ وُلِدُوا فِي أرْضِكَ. هَؤُلاءِ يَكُونُونَ مُلكاً لَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","يُمْكِنُكُمْ أنْ تُورِّثُوهُ لأولادِكُمْ كَمُلكٍ دائِمٍ. يُمكِنُكُمْ أنْ تَستَعبِدُوا هَؤُلاءِ، وَأمّا الَّذِينَ مِنْ بَنِي إسْرائِيلَ فَلا تَتَسَلَّطُوا عَلَيهِمْ بِقَسوَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«إنِ اغتَنَى غَرِيبٌ أوْ زائِرٌ بَينَكُمْ، وَافتَقَرَ واحِدٌ مِنْ بَنِي إسْرائِيلَ فَباعَ نَفسَهُ لِلغَرِيبِ أوِ الزّائِرِ، أوْ لِشَخصٍ مِنْ عَشِيرَةِ الغَرِيبِ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","فَإنَّهُ بَعدَ بَيعِهِ يَنبَغِي شِراؤُهُ ثانِيَةً. يَفتَدِيهِ أخُوهُ ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","أوْ عَمُّهُ أوِ ابْنُ عَمِّهِ أوْ قَرِيبٌ آخَرُ مِنْ عائِلَتِهِ. وَإنِ اغتَنَى هُوَ نَفسُهُ، فَيُمكِنُهُ أنْ يَفتَدِي نَفسَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","«فَيَحسِبُ العَبدُ وَمُشتَرِيهِ عَدَدَ السَّنَواتِ مِنْ سَنَةِ بَيعِهِ لِنَفسِهِ إلَى سَنَةِ اليُوبِيلِ، وَيُحَدَّدُ سِعْرُهُ بِحَسَبِ عَدَدِ السَّنَواتِ. وَتَكُونُ فَترَةُ عُبُودِيَّتِهِ كَفَترَةِ عَمَلِ أجِيرٍ لَدَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","فَإنْ بَقِيَتْ سَنَواتٌ كَثِيرَةٌ إلَى سَنَةِ اليُوبِيلِ، يَدفَعُ ثَمَنَ تَحْرِيرِ نَفسِهِ حَسَبَ عَدَدِها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","وَإنْ بَقِيَتْ سَنَواتٌ قَلِيلَةٌ إلَى سَنَةِ اليُوبِيلِ، يَدفَعُ ثَمَنَ تَحْرِيرِ نَفسِهِ حَسَبَ عَدَدِها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","وَيَعِيشُ الإسْرائِيلِيُّ عِندَ الغَرِيبِ كَأجِيرٍ مِنْ سَنَةٍ لِأُخرَى، فَلا يَتَسَلَّطْ عَلَيهِ بِقَسوَةٍ أمامَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","«وَإنْ لَمْ يَتِمَّ شِراؤُهُ ثانِيَةً بِأيَّةِ طَريقَةٍ، فَإنَّهُ سَيُعتَقُ هُوَ وَأولادُهُ فِي سَنَةِ اليُوبِيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","لِأنَّ بَنِي إسْرائِيلَ خُدّامِي أنا. إنَّهُمْ خُدّامِي الَّذِينَ أخرَجتُهُمْ مِنْ أرْضِ مِصرَ. أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«لا تَصنَعُوا لَكُمْ أوثاناً، وَلا تُقِيمُوا أنْصاباً تَذْكارِيَّةً لَكُمْ، وَلا تَضَعُوا تِمثالاً مَنحُوتاً فِي أرْضِكُمْ لِتَسجُدُوا أمامَهُ، لِأنِّي أنا إلَهُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","«احَفَظُوا أيّامَ الرّاحَةِ، وَاحْتَرِمُوا مَكانِيَ المُقَدَّسَ. أنا اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«إنْ عِشْتُمْ بِحَسَبِ شَرائِعِي وَحَفِظْتُمْ وَصايايَ وَعَمِلْتُمْ بِها، ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","فَإنِّي سَأُعطِيكُمُ الأمطارَ فِي أوقاتِها المُناسِبَةِ لِتُنتِجَ الأرْضُ مَحاصِيلَها، وَأشْجارُ الحَقلِ ثَمَرَها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","سَيَستَمِرُّ دَرْسُ الحُبُوبِ حَتَّى وَقتِ قِطافِ العِنَبِ. وَيَستَمِرُّ قِطافُ العِنَبِ حَتَّى وَقتِ البِذارِ. فَسَيَكُونُ لَدَيكُمْ طَعامٌ كَثِيرٌ، وَسَتَعِيشُونَ بِأمانٍ فِي أرْضِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","سَأُعطِي سَلاماً لِأرضِكُمْ، فَتَنامُوا بِسَلامٍ، وَلَنْ يُخِيفَكُمْ شَيءٌ فِيما بَعْدُ. وَسَأُخرِجُ الحَيواناتِ المُؤذِيَةَ مِنْ أرْضِكُمْ، وَلَنْ تَقْتَحِمَ الجُيُوشُ أرْضَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","«سَتُطارِدُونَ أعداءَكُمْ وَتَهزِمُونَهُمْ وَتَقتُلُونَهُمْ بِالسَّيفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","سَيُطارِدُ خَمسَةٌ مِنكُمْ مِئَةَ رَجُلٍ، وَيُطارِدُ مِئَةُ رَجُلٍ عَشْرَةَ آلافِ رَجُلٍ. فَسَتَهزِمُونَ أعداءَكُمْ وَتَقتُلُونَهُمْ بِالسَّيفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","«سَأعتَنِي بِكُمْ وَأُعطِيكُمْ أولاداً كَثِيرِينَ، وَأحفَظُ عَهدِي مَعَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","سَيَكُونُ لَدَيكُمْ ما يَكفِي مِنَ المَحاصِيلِ لِأكثَرَ مِنْ سَنَةٍ، فَتَتَخَلَّصُونَ مِنَ المَحصُولِ القَدِيمِ، لَيَتَّسِعَ المَكانُ لِلمَحصُولِ الجَدِيدِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","وَسَأسْكُنُ بَينَكُمْ، وَلَنْ أرفُضَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","وَسأسْيرُ بَينَكُمْ، وَسَأكُونُ إلَهَكُمْ، وَسَتَكُونُونَ شَعبِيَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","أنا إلَهُكُمُ الَّذِي أخرَجَكُمْ مِنْ أرْضِ مِصرَ لِئَلّا تَظَلُّوا عَبِيداً لَهُمْ. أنا كَسَرْتُ قُيُودَكُمْ، وَجَعَلْتُكُمْ تَسِيرُونَ شامِخِينَ غَيرَ مُنحَنِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«لَكِنْ إنْ لَمْ تُطِيعُونِي وَلَمْ تَعمَلُوا بِكُلِّ هَذِهِ الوَصايا، ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","وَإنْ رَفَضْتُمْ شَرائِعِي وَأبغَضْتُمْ أحكامِي فَلَمْ تُطِيعُوا وَصايايَ لَكِنْ خَرَقْتُمْ عَهدِي، ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","فَإنِّي سَأعمَلُ هَذا بِكُمْ: سَأجلِبُ عَلَيكُمُ الوَباءَ وَالحُمَّى الَّتِي تُفسِدُ العُيُونَ وَتُتلِفُ الجَسَدَ. سَتَزرَعُونَ بُذُورَكُمْ وَلَنْ تَنتَفِعُوا بِها، بَلْ سَيَأكُلُها أعداؤُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","سَأُواجِهُكُمْ، وَسَيَهزِمُكُمْ أعداؤُكُمْ، وَيَحْكُمُكُمْ مُبْغِضُوكُمْ. فَتَهرُبُونَ وَلَيْسَ مَنْ يُطارِدُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«فَإنْ لَمْ تُطِيعُونِي بَعدَ كُلِّ هَذِهِ الأُمُورِ فَإنِّي سَأُعاقِبُكُمْ سَبعَةَ أضعافٍ عَلَى خَطاياكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","سَأُحَطِّمُ كِبرِياءَكُمُ. فَسَأجَعَلُ السَّماءَ فَوقَكُمْ كَالحَديدِ، وَالأرْضَ تَحْتَكُمْ كَالنُّحاسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","سَتَتْعَبُونَ بِلا فائِدَةٍ، فَلَنْ تُعطِيَ أرْضُكُمْ مَحاصِيلَها، وَلا أشجارُكُمْ ثِمارَها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«فَإنْ وَاصَلْتُمْ عِصيانِي وَعَدَمَ طاعَتِي، فَإنِّي سَأُعاقِبُكُمْ سَبعَةَ أضعافٍ عَلَى خَطاياكُمْ كَما قُلْتُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","سَأُطلِقُ عَلَيكُمُ الوُحُوشَ البَرِّيَّةَ، فَيَأخُذُونَ أولادَكُمْ وَيُفنُونَ حَيواناتِكُمْ. سَيَتْرُكُونَ قَلِيلينَ مِنكُمْ، فَتَخلُو الطُّرُقُ مِنَ النّاسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«فَإنْ لَمْ تَخضَعُوا بَعدَ كُلِّ هَذا، لَكِنْ وَاصَلْتُمْ عِصيانِي، ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","فَإنِّي سَأُعادِيكُمْ وَأضرِبُكُمْ سَبعَةَ أضعافٍ عَلَى خَطاياكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","سَأجلِبُ جُيُوشاً عَلَيكُمْ لِأُعاقِبَكُمْ عَلَى خَرقِكُمْ لِعَهدِي. إنْ تَجَمَّعْتُمْ فِي مُدُنِكُمْ لِأجلِ الحِمايَةِ، فَسَأُرسِلُ وَباءً بَينَكُمْ، وَسَأُسَلِّمُكُمْ إلَى أعدائِكُمْ لِيَتَسَلَّطُوا عَلَيكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","سَأقَلِّلُ طَعامَكُمْ، حَتَّى تَخْبِزُ عَشْرُ نِساءٍ خُبزَكُمْ كُلَّهُ فِي فُرنٍ واحِدٍ، وَيُوَزِّعْنَهُ قِطَعاً صَغيرَةً. سَتَأكُلُونَ لَكِنْ لَنْ تَشبَعُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«فَإنْ لَمْ تُطِيعُونِي بَعدَ هَذا، بَلِ وَاصَلْتُمْ مُقاوَمَتِي وَعِصيانِي، ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","فَإنِّي سَأُقاوِمُكُمْ بِغَضَبٍ، وَسَأُعاقِبُكُمْ سَبعَةَ أضعافٍ عَلَى خَطاياكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","سَيَكُونُ جُوعُكُمْ عَظِيماً جِدّاً حَتَّى إنَّكُمْ سَتَأكُلُونَ لَحمَ أبْنائِكُمْ وَبَناتِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","سَأُدَمِّرُ مُرتَفَعاتِكُمْ، وَسَأهدِمُ مَذابِحَ البَخُورِ الَّتِي لَكُمْ، وَسَأضَعُ جُثَثَكُمْ عَلَى جُثَثِ أصنامِكُمْ، وَسَتَعافُكُمْ نَفْسِي. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","سَأُدَمِّرُ مُدُنَكُمْ، وَسَأجعَلُ أماكِنَكُمُ المُقَدَّسَةَ مُقفِرَةً خَرِبَةً، وَلَنْ أُسَرَّ بِرَوائِحِ ذَبائِحِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","سَأُخَرِّبُ الأرْضَ، حَتَّى إنَّ أعداءَكُمُ الَّذِينَ سَيَحتَلُّونَها سَيَكُونُونَ مَصدُومِينَ مِنها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","سَأُشَتِّتُكُمْ فِي كُلِّ الأُمَمِ، وَسَأُجَرِّدُ سَيفِي مِنْ غِمدِهِ ضِدَّكُمْ. سَتُصبِحُ أرْضُكُمْ مَهجُورَةً وَمُدُنُكُمْ خَرِبَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","«حِينَئِذٍ، سَتُعَوِّضُ الأرْضُ عَنْ سَنَواتِ راحَتِها وَهِيَ مَهجُورَةٌ، بَينَما أنتُمْ فِي أرْضِ أعدائِكُمْ. فَسَتَستَرِيحُ الأرْضُ وَتَتَمَتَّعْ بِسَنَواتِ راحَتِها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","وَما دامَتْ مَهجُورَةً، سَتَسْتَرِيحُ عِوَضاً عَنْ سِنينِ الرّاحَةِ التِي حُرِمِتْ مِنْها وَانْتُمْ ساكِنونَ فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","وَسَأُدْخِلُ الخَوفَ فِي قُلُوبِ الباقِينَ مِنكُمْ، فَيَهرُبُونَ حَتَّى مِنْ صَوتِ وَرَقَةِ شَجَرٍ طائِرَةٍ. تَهرُبُونَ كَما لَوْ أنَّ أحَدَهُمْ يُطارِدُكُمْ بِسَيفٍ، وَتَسقُطُونَ حَتَّى حِينَ لا يَكُونُ هُناكَ مَنْ يُطارِدُكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","سَيَتَعَثَّرُ بَعضُكُمْ بِبَعضٍ كَما لَوْ أنَّكُمْ تَهرُبُونَ مِنَ السَّيفِ، حَتَّى حِينَ لا يَكُونُ هُناكَ مَنْ يُطارِدُكُمْ. «وَلَنْ تَكُونَ لَدَيكُمُ القُوَّةُ لِمُحارَبَةِ أعدائِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","سَتَمُوتُونَ بَينَ الأُمَمِ، وَسَتَختَفُونَ فِي أرْضِ أعدائِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","وَسَيَفنَى الباقُونَ مِنكُمْ فِي أراضِي أعدائِهِمْ بِسَبَبِ خَطِيَّتِهِمْ، وَكَذَلِكَ بِسَبِبِ خَطِيَّةِ آبائِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«ثُمَّ يَعتَرِفُونَ بِخَطِيَّتِهِمْ وَخَطِيَّةِ آبائِهِمْ. سَيَعتَرِفُونَ بِعَدَمِ أمانَتِهِمْ وَبِمُقاوَمَتِهِمْ وَعِصيانِهِمْ لِي، ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","فأُقاوِمُهُمْ وَأجلِبُهُمْ إلَى أرْضِ أعدائِهِمْ. فَإنْ تَواضَعَتْ قُلُوبُهُمْ غَيْرُ المُطَهَّرَةِ، وَقَبِلُوا عِقابِي لِخَطاياهُمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","فَإنِّي سَأتَذَكَّرُ عَهدِي مَعَ يَعقُوبَ وَعَهدِيَ مَعَ إسْحاقَ وَعَهدِيَ مَعَ إبراهِيمَ، وَسَأتَذَكَّرُ الأرْضَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","«سَيَهْجُرُونَ أرْضَهَمْ، فَتُعَوِّضُ الأرْضُ سَنَواتِ راحَتِها وَهِيَ مَهجُورَةً. وَيَنالُ الباقُونَ مِنكُمُ العِقابَ عَلَى خَطِيَّتِهِمْ لِأجلِ رَفْضِهِمْ لِأحكامِي وَبُغْضِهِمْ لِشَرائِعِي. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","وَعَلَى الرُّغمِ مِنْ كُلِّ هَذا، وَبَينَما هُمْ فِي أرْضِ أعدائِهِمْ، لَنْ أرفُضَهُمْ وَلَنْ أبْغُضَهُمْ، فَيُبادوا جَمِيعا وَيُكْسَرُ عَهدِي مَعَهُمْ، لِأنِّي أنا إلَهُهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","سَأتَذَكَّرُ عَهدِي مَعَ آبائِكُمُ الَّذِينَ أخرَجْتُهُمْ مِنْ أرْضِ مِصرَ عَلَى مَرأىً مِنْ كُلِّ الأُمَمِ، لِأكُونَ إلَهَهُمْ. أنا اللهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","هَذِهِ هِيَ الشَّرائِعُ وَالأحكامُ وَالتَّعلِيماتُ الَّتِي وَضَعَها اللهُ بَينَهُ وَبَينَ بَنِي إسْرائِيلَ مِنْ خِلالِ مُوسَى عَلَى جَبَلِ سِيناءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«قُلْ لِبَنِي إسْرائِيلَ: إنْ نَذَرَ شَخصٌ بِأنْ يُكَرِّسَ إنساناً للهِ، يُحَدِّدُ الكاهِنُ ثَمَنا مُقابِلَ ذَلِكَ الإنسانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","فَالثَّمَنُ المُقابِلُ لِلذَّكَرِ مِنْ سِنِّ العِشرِينَ إلَى سِنِّ السِّتِّينَ هُوَ خَمْسُونَ مِثْقالاً مِنْ فِضَّةٍ، بِحَسَبِ المِقياسِ الرَّسمِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","وَإنْ كانَتْ أُنثَى، فَالثَّمَنُ المُقابِلَ لَها هُوَ ثَلاثُونَ مِثْقالاً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","وَإنْ كانَ ذَكَراً مِنْ سِنِّ الخامِسَةِ إلَى العِشْرِينَ، فَإنَّ الثَّمَنَ المُقابِلَ هُوَ عِشْرُونَ مِثْقالاً مِنَ الفِضَّةِ، وَلِلأُنثَى عَشْرَةُ مَثاقِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","وَإنْ كانَ المُكَرَّسُ مِنْ سِنِّ شَهْرٍ إلَى خَمسِ سَنَواتٍ، فَإنَّ الثَّمَنَ المُقابِلَ لِلذَّكَرِ هُوَ خَمْسَةُ مَثاقِيلَ مِنَ الفِضَّةِ، وَلِلأُنثَى ثَلاثَةُ مَثاقِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","فَإنْ تَجاوَزَ عُمْرُهُ سِتِّينَ سَنَةً، فَإنَّ الثَّمَنَ المُقابِلَ لِلذَّكَرِ هُوَ خَمْسَةَ عَشَرَ مِثْقالاً، وَلِلأُنثَى عَشْرَةُ مَثاقِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","وَإنْ كانَ الَّذِي نَذَرَ أفقَرَ مِنْ أنْ يَدفَعَ الثَّمَنَ المُقابِلَ لَهُ، فَلْيُحْضِرْ نَذْرَهُ أمامَ الكاهِنِ. فَيُقَدِّرُ الكاهِنُ الثَّمَنَ مَعَ أخْذِ حالَةِ الَّذِي نَذَرَ بِعَيْنِ الاعْتِبارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«وَإنْ كانَ المَنذُورُ حَيواناً يُقَدِّمُهُ النّاسُ للهِ، فَإنَّ كُلَّ حَيوانٍ مِنْ هَذا النَّوعِ يُقَدِّمُهُ للهِ يَكُونُ مُقَدَّساً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","فَلا يَستَبدِلْهُ بِحَيوانٍ آخَرَ، لا أحسَنَ مِنهُ وَلا أردَأ. وَإنِ استَبدَلَهُ بِحَيوانٍ آخَرَ، يَكُونُ كِلا الحَيوانَينِ مُقَدَّسَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","«وَإنْ كانَ الحَيوانُ المَنذُورُ حَيواناً نَجِساً لا يُقَدِّمُهُ النّاسُ للهِ، فَعَلَى الَّذِي نَذَرَ أنْ يُحضِرَ الحَيوانَ إلَى أمامِ الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","وَيُحَدِّدُ الكاهِنُ الثَّمَنَ المُقابِلَ لِلحَيوانِ، سَواءٌ أكانَ الحَيوانُ جَيِّداً أمْ رَدِيئاً. فَيَكُونُ الثَّمَنُ المُقابِلُ هُوَ ما يُحَدِّدُهُ الكاهِنُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","فَإنْ أرادَ استِردادَ الحَيوانِ، يَدفَعُ ثَمَنَهُ، وَيُضِيفُ خُمسَ ثَمَنِهِ إلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«وَإنْ كَرَّسَ رَجُلٌ بَيتَهُ للهِ، يُحَدِّدُ الكاهِنُ الثَّمَنَ المُقابِلَ لَهُ، سَواءٌ أكانَ جَيِّداً أمْ رَدِيئاً. الثَّمَنُ الّذِي يُحَدِّدُهُ الكاهِنُ هُوَ يَكُونُ ثَمَنَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","وَإنْ أرادَ الَّذِي كَرَّسَ بَيتَهُ استِردادَ بَيتِهِ، يَدفَعُ ثَمَنَهُ، وَيُضِيفُ خُمسَ ثَمَنِهِ إلَيهِ. وَبِهَذا يَسْتَرِدُّ مُلْكِيَّتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«وَإنْ كَرَّسَ شَخصٌ قِطعَةً مِنْ أرْضِهِ للهِ، فَإنَّ قِيمَتَها تَعتَمِدُ عَلَى كَمِّيَّةِ البُذُورِ اللازِمَةِ لِزِراعَتِها. فَكُلُّ كِيسٍ مِنَ الشَّعِيرِ لِلبَذْرِ فِي الحَقلِ، يَقابِلُ خَمْسينَ مِثْقالاً مِنَ الفِضَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","إنْ كَرَّسَ شَخصٌ أرْضَهُ للهِ خِلالَ سَنَةِ اليُوبِيلِ، فَسَتَكُونُ قِيمَتُها بِحَسَبِ ما يُحَدِّدُهُ الكاهِنُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","لَكِنْ إنْ كَرَّسَ شَخصٌ أرْضَهُ بَعدَ سَنَةِ اليُوبِيلِ فَإنَّ الكاهِنَ سَيَحسِبُ قِيمَتَها بِحَسَبِ السَّنَواتِ الباقِيَةِ حَتَّى سَنَةِ اليُوبِيلِ التّالِيَةِ، فَيُنقِصُ القِيمَةَ بِحَسَبِ السَّنَواتِ الَّتِي مَضَتْ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","وَإنْ أرادَ الَّذِي كَرَّسَ أرْضَهُ أنْ يَستَرِدَّها، يَدفَعُ ثَمَنَها، وَيُضِيفُ خُمسَ ثَمَنِها مِنَ الفِضَّةِ. وَبِهَذا سَتَبقَى الأرْضُ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","فَإنْ لَمْ يَستَرِدَّ الأرْضَ، وَباعَها الكاهِنُ إلَى رَجُلٍ آخَرَ، فَلا يُمكِنُ استِعادَةُ الأرْضِ فِيما بَعْدُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","وَحِينَ تُعتَقُ الأراضِي فِي سَنَةِ اليُوبِيلِ، فَإنَّها سَتَكُونُ مُقَدَّسَةً للهِ مِثلَ الأرْضِ المُعطاةِ لِلرَّبِّ بِشَكلٍ كامِلٍ. سَتَكُونُ مُلكاً دائِماً لِلكَهَنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«وَإنْ كَرَّسَ رَجُلٌ للهِ قِطعَةَ أرْضٍ قَدِ اشتَراها وَلَيسَتْ مُلكاً مَورُوثاً لَهُ، ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","يَحسِبُ الكاهِنُ ثَمَنَها إلَى سَنَةِ اليُوبِيلِ. وَيَدفَعُ الرَّجُلُ ذَلِكَ الثَّمَنَ فِي ذَلِكَ اليَومِ، وَيَكُونُ ثَمَنُها مُكَرَّساً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","وَفِي سَنَةِ اليُوبِيلِ، تَعُودُ الأرْضُ إلَى الرَّجُلِ الَّذِي اشتَرَى الأرْضَ مِنْهُ، الَّذِي يَملِكُ الأرْضَ شَرْعِيّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","«كُلُّ ثَمَنٍ يُقَدَّرُ وَفْقاً للقِياسِ الرَّسمِيِّ لِلمِثْقالِ: المِثْقالُ بِعِشرِينَ قِيراطاً. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«لا يَجُوزُ لِأحَدٍ أنْ يُكَرِّسَ بِكرَ الحَيواناتِ لِأنَّهُ للهِ. سَواءٌ أكانَ ثَوراً أمْ خَرُوفاً، فَهُوَ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","لَكِنْ إنْ كانَ بِكرُ حَيوانٍ نَجِسٍ، فَيَستَرِدُّهُ بِالثَّمَنِ الَّذِي يُحَدِّدُهُ الكاهِنُ وَيُضِيفُ خُمسَ ثَمَنِهِ إلَيهِ. فَإنْ لَمْ يَشتَرِهِ صاحِبُهُ ثانِيَةً، يُباعُ بِالسِّعرِ المُناسِبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«أيُّ شَيءٍ يُكَرِّسُهُ شَخصٌ للهِ بِالكامِلِ وَبِلا شُرُوطٍ – سَواءٌ أكانَ حَيواناً أمْ إنساناً أمْ حَقلاً مِنْ مِيراثِ عائِلَتِهِ – لا يُمكِنُ بَيعُهُ أوِ استِردادُهُ. كُلُّ شَيءٍ قُدِّمَ للهِ بِالكامِلِ وَبِلا شُرُوطٍ، يَكُونُ قُدْسَ أقْداسٍ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","«الإنسانُ الَّذِي يَتِمُّ تَقْديمُهُ للهِ بِالكامِلِ وَبِلا شُرُوطٍ لا يَجُوزُ فِداؤُهُ، لَكِنْ يَنبَغِي قَتلُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«عُشرُ مَحاصِيلِ الأرْضِ للهِ، سَواءٌ أكانَتْ حُبُوباً أمْ ثِمارَ أشجارٍ. إنَّهُ عُشْرٌ مُخَصَّصٌ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","إنْ أرادَ أحَدٌ استِردادَ شَيءٍ مِنْ عُشرِهِ، عَلَيهِ أنْ يَدفَعَ ثَمَنَهُ، وَيُضِيفُ خُمسَ ثَمَنِهِ إلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","«عُشرُ الأبقارِ وَالأغنامِ، أيْ كُلُّ حَيوانٍ عاشِرٍ يَمُرُّ تَحتَ عَصَا الرّاعِي يَخَصَّصُ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","لا يُفْحَصُ إنْ كانَ جَيِّداً أوْ رَدِيئاً، وَلا يَستَبدِلُ الرّاعِي حَيَواناً بِآخَرَ. فَإنِ استَبدَلَهُ، يَكُونُ الاثنانِ مُخَصَّصينِ. لا يُمكِنُ استِردادُهُما.» ");
INSERT INTO arbwbtc_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","هَذِهِ هِيَ الوَصايا الَّتِي أمَرَ اللهُ مُوسَى فِي جَبَلِ سِيناءَ بِأنْ يُعْطِيَها لِبَنِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","وَتَكَلَّمَ اللهُ إلَى مُوسَى فِي بَرِّيَّةِ سِيناءَ فِي خَيمَةِ الاجْتِماعِ. حَدَثَ هَذا فِي اليَومِ الأوَّلِ مِنَ الشَّهرِ الثّانِي فِي السَّنَةِ الثّانِيَةِ بَعدَ مُغادَرَةِ بَني إسْرائِيلَ لإرضِ مِصرَ. وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«أحْصُوا جَمِيعَ بَني إسْرائِيلَ. دَوِّنُوا اسْمَ كُلِّ ذَكَرٍ وَعَائِلَتِهِ وَعَشيرَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","دَوِّنْ أنتَ وَهارُونَ أسْماءَ جَمِيعِ رِجالِ إسْرائِيلَ البالِغِينَ عِشرِينَ سَنَةً أوْ أكثَرَ، الَّذِينَ يَستَطِيعُونَ الخِدمَةَ فِي الجَيشِ، وَذَلِكَ بِحَسَبِ صُفُوفِهِمْ فِي الجَيْشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","وَسَيَكُونُ هُناكَ رَجُلٌ مِنْ كُلِّ عَشِيرَةٍ لِيُساعِدَكُما. عَلَى أنْ يَكُونَ هَذا الرَّجُلُ قائِدَ عائِلَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","وَهَذِهِ هِيَ أسْماءُ الرِّجالِ الَّذِينَ سَيُساعِدُونَكُما: مِنْ قَبِيلَةِ رَأُوبَيْنَ ألِيصُورُ بْنُ شَدَيئُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","مِنْ قَبِيلَةِ شِمْعُونَ شَلُومِيئِيلُ بْنُ صُورِيشَدّايَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","مِنْ قَبِيلَةِ يَهُوذا نَحْشُونُ بْنُ عَمِّينادابَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","مِنْ قَبِيلَةِ يسّاكِرَ نَثَنائِيلُ بْنُ صُوغَرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","مِنْ قَبِيلَةِ زَبُولُونَ ألِيآبُ بْنُ حِيلُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","مِنْ نَسلِ يُوسُفَ: مِنْ قَبِيلَةِ أفْرايِمَ ألِيشَمَعُ بْنُ عَمِّيهُودَ. وَمِنْ قَبِيلَةِ مَنَسَّى جَملِيئِيلُ بْنُ فَدَهْصُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","مِنْ قَبِيلَةِ بَنْيامِيْنَ أبِيدَنُ بْنُ جِدْعُونِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","مِنْ قَبِيلَةِ دانَ أخِيعَزَرُ بْنُ عَمِّيشَدّايَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","مِنْ قَبِيلَةِ أشِيرَ فَجْعِيئِيلُ بْنُ عُكْرَنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","مِنْ قَبِيلَةِ جادَ ألِياسافُ بْنُ دَعُوئِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","مِنْ قَبِيلَةِ نَفْتالِي أخِيرَعُ بْنُ عِينَنَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","هَؤُلاءِ هُمُ الرِّجالُ الَّذِينَ وَقَعَ عَلَيهِمْ الاخْتِيارُ مِنْ وَسَطِ الشَّعبِ لِيَكُونُوا رُؤَساءَ قَبائِلِ آبائِهِمْ. إنَّهُمْ قادَةُ قَبائِلِ إسرائيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","وَأخَذَ مُوسَى وَهارُونُ هَؤُلاءِ الرِّجالَ الَّذِينَ تَمَّ تَعيِينُهُمْ بِالاسْمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","وَجَمَعا كُلَّ الشَّعبِ فِي اليَومِ الأوَّلِ مِنَ الشَّهرِ الثّانِي. وَتَمَّ تَسجِيلُ الشَّعبِ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. كَما تَمَّ تَسْجيلُ أسْماءِ الرِّجالِ البالِغِينَ عِشْرِينَ سَنَةً أوْ أكثَرَ، بِحَسَبِ عَشائِرِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","فَكَما أمَرَ اللهُ مُوسَى، هَكَذا أحصاهُمْ مُوسَى فِي بَرِّيَّةِ سِيناءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","وَتَمَّ إحصاءُ نَسلِ رَأُوبَيْنَ، الابْنِ البِكرِ لإسْرائِيلَ، بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلِّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ رَأُوبَيْنَ سِتَّةً وَأربَعِينَ ألفاً وَخَمْسَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","وَتَمَّ إحصاءُ نَسلِ شِمْعُونَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلِّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ شِمْعُونَ تِسعَةً وَخَمْسِينَ ألفاً وَثَلاثَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","وَتَمَّ إحصاءُ نَسلِ جادَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلَّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ جادَ خَمْسَةً وَأربَعِينَ ألفاً وَسِتَّ مِئَةٍ وَخَمْسِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","وَتَمَّ إحصاءُ نَسلِ يَهُوذا بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلَّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ يَهُوذا أربَعَةً وَسَبعِينَ ألفاً وَسِتَّ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","وَتَمَّ إحصاءُ نَسلِ يَسّاكَرَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلَّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ يسّاكِرَ أربَعَةً وَخَمْسِينَ ألفاً وَأربَعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","وَتَمَّ إحصاءُ نَسلِ زَبُولُونَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلَّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ زَبُولُونَ سَبعَةً وَخَمْسِينَ ألفاً وَأربَعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","وَمِنِ ابنَيِّ يُوسُفَ، تَمَّ إحصاءُ نَسلِ أفْرايِمَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلَّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ أفْرايِمَ أربَعِينَ ألفاً وَخَمسَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","وَتَمَّ إحصاءُ نَسلِ مَنَسَّى بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلَّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ مَنَسَّى اثْنَينِ وَثَلاثِينَ ألفاً وَمِئَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","وَتَمَّ إحصاءُ نَسلِ بَنْيامِيْنَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلَّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ بَنْيامِيْنَ خَمسَةً وَثَلاثِينَ ألفاً وَأربَعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","وَتَمَّ إحصاءُ نَسلِ دانَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلَّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ دانَ اثْنَينِ وَسِتِّينَ ألفاً وَسَبعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","وَتَمَّ إحصاءُ نَسلِ أشِيرَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلَّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ أشِيرَ واحِداً وَأربَعِينَ ألفاً وَخَمسَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","وَتَمَّ إحصاءُ نَسلِ نَفتالِي بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلَّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","وَكانَ عَدَدُ الرِّجالِ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ قَبِيلَةِ نَفْتالِي ثَلاثَةً وَخَمْسِينَ ألفاً وَأربَعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","هَؤُلاءِ هُمُ الَّذِينَ أحصاهُمْ مُوسَى وَهارُونُ وَرُؤَساءُ إسْرائِيلَ الاثنا عَشَرَ. وَكانَ كُلُّ واحِدٍ مِنهُمْ يُمَثِّلُ قَبِيلَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","كُلُّ رِجالِ بَني إسْرائِيلَ أُولَئِكَ تَمَّ إحصاؤُهُمْ بِحَسَبِ عائِلاتِهِمْ. وَتَمَّ تَسْجيلُ اسْمِ كُلِّ ذَكَرٍ بَلَغَ عِشرِينَ سَنَةً أوْ أكثَرَ، كُلَّ مُؤهَّلٍ لِلخِدمَةِ فِي الجَيشِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","فَكانَ المَجمُوعُ سِتَّ مِئَةٍ وَثَلاثَةَ آلافٍ وَخَمسَ مِئَةٍ وَخَمْسِينَ رَجُلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","وَلَمْ يَتِمَّ إحصاءُ نَسلِ الَّلاوِيِّينَ بِحَسَبِ عَشائِرِهِمْ مَعَ بَقِيَّةِ إسْرائِيلَ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","فَقَدْ قالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«لا تُحْصِ قَبِيلَةَ لاوِي. لا تَحْسِبْ عَدَدَهُمْ مَعَ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","بَلْ أعْطِ الَّلاوِيِّينَ مَسْؤوليَةَ مَسْكَنَ العَهْدِ، وَجَمِيعِ أثاثِهِ وَأدَواتِهِ. هُمْ يَحمِلُونَ المَسْكَنَ وَأثاثَهُ، وَيَهتَمُّونَ بِهِ، وَيَنْصُبُونَ خِيامَهُمْ حَولَ المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","وَحِينَ يأتي وَقْتُ ارْتِحالِ المَسْكَنِ، يُنْزِلُهُ الَّلاوِيُّونَ. وَحِينَ يُقامُ، يُقيمُهُ الَّلاوِيُّونَ. وَكُلُّ مَنْ يَقتَرِبُ مِنَ الخَيمَةِ المُقَدَّسَةِ غَيْرُهُمْ يُقتَلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","وَيُقِيمُ بَنو إسْرائِيلَ فِي مُخَيَّماتِهِمْ فِي أقسامٍ مُنفَصِلَةٍ. يُقِيمُ كُلُّ واحِدٍ فِي مُخَيَّمِهِ قُرْبَ رايَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","وَأمّا الَّلاوِيُّونَ فَيُخَيِّمُوا حَولَ مَسْكَنِ العَهْدِ، كَي لا يَحِلَّ غَضَبُ اللهِ عَلَى بَني إسْرائِيلَ. وَيَكُونُ الَّلاوِيُّونَ مَسؤُولِينَ عَنْ مَسْكَنِ العَهْدِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","وَعَمِلَ بَنو إسْرائِيلَ كُلَّ ما أمَرَ اللهُ بِهِ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","وَقالَ اللهُ لِمُوسَى وَهارُونَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«لِيُخَيِّمْ كُلُّ واحِدٍ مِنْ بَني إسْرائِيلَ تَحتَ رايَتِهِ. فَتَكُونُ لِكُلِّ عَشِيرَةٍ رايَةٌ. وَلَيَنصُبُوا خِيامَهُمْ حَولَ خَيمَةِ الاجْتِماعِ، عَلَى مَسافَةٍ مِنها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","«فِي الجِهَةِ الشَّرقِيَّةِ نَحوَ شُرُوقِ الشَّمسِ سَتَكُونُ رايَةُ يَهُوذا عَلَى مُخَيَّمِهِمْ بِحَسَبِ فِرَقِها. وَرَئِيسُ قَبِيلَةِ يَهُوذا هُوَ نَحشُونُ بْنُ عَمِّينادابَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","وَكانَ عَدَدُ جُندِهِ أربَعَةً وَسَبعِينَ ألفاً وَسِتَّ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","«وَتُخَيِّمُ إلَى جانِبِهِمْ قَبِيلَةُ يَسّاكَرَ. وَرَئِيسُ قَبِيلَةِ يسّاكِرَ هُوَ نَثَنائِيلُ بْنُ صُوغَرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","وَكانَ عَدَدُ جُندِهِ أربَعَةً وَخَمْسِينَ ألفاً وَأربَعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","«وَتُخَيِّمُ إلَى جانِبِهِمْ قَبِيلَةُ زَبُولُونَ. وَرَئِيسُ قَبِيلَةِ زَبُولُونَ هُوَ ألِيآبُ بْنُ حِيلُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","وَكانَ عَدَدُ جُندِهِ سَبعَةً وَخَمْسِينَ ألفاً وَأربَعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","«جَمِيعُ الَّذِينَ تَمَّ إحصاؤُهُمْ فِي مُخَيَّمِ يَهُوذا بِحَسَبِ فِرَقِهِمْ كانُوا مِئَةً وَسِتَّةً وَثَمانِينَ ألفاً وَأربَعَ مِئَةِ رَجُلٍ. وَهُمْ مَنْ يَبدَأُونَ بِالإرتِحالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","«وَفِي الجِهَةِ الجَنُوبِيَّةِ سَتَكُونُ رايَةُ مُخَيَّمِ رَأُوبَيْنَ بِحَسَبِ فِرَقِها. وَرَئِيسُ قَبِيلَةِ رَأُوبَيْنَ هُوَ ألِيصُورُ بْنُ شَدَيئُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","وَكانَ عَدَدُ جُندِهِ سِتَّةً وَأربَعِينَ ألفاً وَخَمسَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","«وَتُخَيِّمُ إلَى جانِبِهِمْ قَبِيلَةُ شِمعُونَ. وَرَئِيسُ قَبِيلَةِ شِمْعُونَ هُوَ شَلُومِيئِيلُ بْنُ صُورِيَشَدّايَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","وَكانَ عَدَدُ جُندِهِ تِسعَةً وَخَمْسِينَ ألفاً وَثَلاثَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","«وَتُخَيِّمُ إلَى جانِبِهِمْ قَبِيلَةُ جادَ. وَرَئِيسُ قَبِيلَةِ جادَ هُوَ ألِياسافُ بْنُ دَعُوئِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","وَكانَ عَدَدُ جُندِهِ خَمسَةً وَأربَعِينَ ألفاً وَسِتَّ مِئَةٍ وَخَمْسِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","«جَمِيعُ الَّذِينَ تَمَّ إحصاؤُهُمْ فِي مُخَيَّمِ رَأُوبَيْنَ بِحَسَبِ فِرَقِهِمْ كانُوا مِئَةً وَواحِداً وَخَمْسِينَ ألفاً وَأربَعَ مِئَةٍ وَخَمْسِينَ رَجُلاً. وَهُمْ مَنْ سَيَرتَحِلُونَ بَعدَ مُخَيَّمِ يَهُوذا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","«وَبَعدَهُمْ تَرتَحِلُ خَيمَةُ الاجْتِماعِ مِنْ مُخَيَّمِ اللّاوِيِّينَ وَسَطَ المُخَيَّماتِ الأُخرَى. وَسَيَرتَحِلُونَ بِالتَّرْتِيبِ الَّذِي كانُوا مُخَيِّمِينَ بِهِ، كُلُّ واحِدٍ فِي مَوقِعِهِ وَتَحتَ رايَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","«وَفِي الجِهَةِ الغَربِيَّةِ سَتَكُونُ رايَةُ مُخَيَّمِ أفْرايِمَ مُرَتَّبَةً بِحَسَبِ فِرَقِها. وَرَئِيسُ قَبِيلَةِ أفْرايِمَ هُوَ ألِيشَمَعُ بْنُ عَمِّيهُودَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","وَكانَ عَدَدُ جُندِهِ أربَعِينَ ألفاً وَخَمسَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","«وَتُخَيِّمُ إلَى جانِبِهِمْ قَبِيلَةُ مَنَسَّى. وَرَئِيسُ قَبِيلَةِ مَنَسَّى هُوَ جَملِيئِيلُ بْنُ فَدَهْصُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","وَكانَ عَدَدُ جُندِهِ اثْنَينِ وَثَلاثِينَ ألفاً وَمِئَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","«وَتُخَيِّمُ إلَى جانِبِهِمْ قَبِيلَةُ بَنْيامِيْنَ. وَرَئِيسُ قَبِيلَةِ بَنْيامِيْنَ هُوَ أبِيدَنُ بْنُ جِدْعُونِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","وَكانَ عَدَدُ جُندِهِ خَمسَةً وَثَلاثِينَ ألفاً وَأربَعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","«جَمِيعُ الَّذِينَ تَمَّ إحصاؤُهُمْ فِي مُخَيَّمِ أفْرايِمَ بِحَسَبِ فِرَقِهِمْ كانُوا مِئَةً وَثَمانِيَةَ آلافٍ وَمِئَةَ رَجُلٍ. وَهُمُ المَجمُوعَةُ الثّالِثَةُ الَّتِي ارْتَحَلَتْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","«وَفِي الجِهَةِ الشِّمالِيَّةِ سَتَكُونُ رايَةُ مُخَيَّمِ أفْرايِمَ دانَ بِحَسَبِ فِرَقِها. وَرَئِيسُ قَبِيلَةِ دانَ هُوَ أخِيعَزَرُ بْنُ عَمِّيشَدّايَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","وَكانَ عَدَدُ جُندِهِ اثْنَينِ وَسِتِّينَ ألفاً وَسَبعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","«وَتُخَيِّمُ إلَى جانِبِهِمْ قَبِيلَةُ أشِيرَ. وَرَئِيسُ قَبِيلَةِ أشِيرَ هُوَ فَجْعِيئِيلُ بْنُ عُكْرَنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","وَكانَ عَدَدُ جُندِهِ واحِداً وَأربَعِينَ ألفاً وَخَمسَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","«وَتُخَيِّمُ إلَى جانِبِهِمْ قَبِيلَةُ نَفتالِي. وَرَئِيسُ قَبِيلَةِ نَفْتالِي هُوَ أخِيرَعُ بْنُ عِينَنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","وَكانَ عَدَدُ جُندِهِ ثَلاثاً وَخَمْسِينَ ألفاً وَخَمسَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","«جَمِيعُ الَّذِينَ تَمَّ إحصاؤُهُمْ فِي مُخَيَّمِ دانَ بِحَسَبِ فِرَقِهِمْ كانُوا مِئَةً وَسَبعاً وَخَمْسِينَ ألفاً وَسِتَّ مِئَةِ رَجُلٍ. وَهُمْ آخِرُ مَجمُوعَةٍ تَرتَحِلُ تَحتَ راياتِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","هَؤُلاءِ هُمُ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ بَني إسْرائِيلَ بِحَسَبِ عَشائِرِهِمْ. وَكانَ مَجمُوعُ الَّذِينَ تَمَّ إحصاؤُهُمْ فِي المُخَيَّماتِ بِحَسَبِ فِرَقِهِمْ سِتَّ مِئَةٍ وَثَلاثَةَ آلافٍ وَخَمْسِينَ رَجُلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","وَكَما أمَرَ اللهُ مُوسَى، لَمْ يَتِمَّ إحصاءُ اللّاوِيِّينَ مَعَ بَقِيَّةِ بَنِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","وَبِهَذا عَمِلَ بَنو إسْرائِيلَ كُلَّ ما أمَرَ اللهُ بِهِ مُوسَى. فَعِندَما خَيَّمُوا، خَيَّمَ كُلُّ واحِدٍ مَعَ قَبيلَتِهِ وَعائِلَتِهِ. وَعِندَما ارْتَحَلُوا، ارْتَحَلَ كُلُّ واحِدٍ مَعَ قَبيلَتِهِ وَعائِلَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","وَهَذِهِ هِيَ عائِلَةُ هارُونَ وَمُوسَى حِينَ كَلَّمَ اللهُ مُوسَى عَلَى جَبَلِ سِيناءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","وَهَذِهِ هِيَ أسْماءُ أبناءِ هارُونَ: نادابُ الابنُ البِكرُ، ثُمَّ أبِيهُو وَألِيعازارُ وَإيثامارُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","هَذِهِ هِيَ أسْماءُ أبناءِ هارُونَ الَّذِينَ مُسِحُوا كَكَهَنَةٍ. وَقَدْ تَمَّ تَعيِينُهُمْ لِيَخدِمُوا كَكَهَنَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","وَلَكِنَّ نادابَ وَأبِيهُو ماتا بَينَما كانا يَخدِمانِ اللهَ حِينَ قَدَّما ناراً مِنْ مَصدَرٍ غَرِيبٍ فِي حَضْرَةِ اللهِ فِي بَرِّيَّةِ سِيناءَ، وَلَمْ يَكُنْ لَهُما أبناءٌ. فَخَدَمَ ألِيعازارُ وَإيثامارُ كَكاهِنَينِ بَينَما كانَ هارُونُ حَيّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«قَدِّمْ قَبِيلَةَ لاوِي لِهارُونَ الكاهِنِ كَي يُساعِدُوهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","فَلْيَخْدِمُوهُ وَيَخدِمُوا كُلَّ الجَماعَةِ أمامَ خَيمَةِ الاجْتِماعِ، وَيَقُومُوا بِالأعمالِ الصَّعبَةِ فِي المَسْكَنِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","يَحرُسُونَ جَمِيعَ أدَواتِ خَيمَةِ الاجْتِماعِ. يَمَثِّلُونَ بِذَلِكَ جَمِيعَ بَني إسْرائِيلَ. وَيَخْدِمُونَ فِي المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","«عَيِّنِ اللّاوِيِّينَ لِمُساعَدَةِ هارُونَ وَأبْنائِهِ. يَكُونُونَ مُكَرَّسينَ بِالكامِلِ لِهارُونَ مِنْ بَينِ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","«عَيِّنْ هارُونَ وَأبناءَهُ لِيَقُومُوا بِواجِباتِ الكَهَنُوتِ. كُلُّ مَنْ يَتَطَفَّلُ لِلقِيامِ بِعَمَلِ الكَهنُوتِ يُقْتَلُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ثُمَّ قالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«ها قَدْ أخَذْتُ اللّاوِيِّينَ مِنْ بَينِ بَني إسْرائِيلَ. بَدَلَ كُلِّ الأولادِ الأبْكارِ فِي بَني إسْرائِيلَ، فَسَيَكُونُ الَّلاوِيُّونَ لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","جَمِيعُ الأبْكارِ مِنَ النّاسِ وَالحَيواناتِ لِي. فَحِينَ قَتَلْتُ الأبْكارَ فِي أرْضِ مِصرَ، خَصَّصْتُ لِنَفسِي جَمِيعَ الأبكارِ فِي إسْرائِيلَ، مِنَ النّاسِ وَالحَيواناتِ. هُمْ لِي، أنا اللهَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ثُمَّ قالَ اللهُ لِمُوسَى فِي بَرِّيَّةِ سِيناءَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«أحصِ اللّاوِيِّينَ بِحَسَبِ عائِلاتِهِمْ وَعَشائِرِهِمْ. أحْصِ جَمِيعَ الذُّكُورِ البالِغِينَ شَهراً أوْ أكثَرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","فَأحْصاهُمْ مُوسَى وَفْقاً لِكَلِمَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","وَهَذِهِ هِيَ أسْماءُ أبناءِ لاوِي: جَرْشُونُ وَقَهاتُ وَمَرارِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","وَهَذانِ اسْما عَشِيرَتَي جَرْشُونَ: لِبْنِي وَشِمْعِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","وَأمّا عَشائِرُ قَهاتَ فَهِيَ عَمْرامُ وَيِصْهارُ وَحَبْرُونُ وَعُزِّيئِيلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","وَأمّا عَشِيرَتا مَرارِي فَكانَتا: مَحلِي وَمُوشِي. هَذِهِ هِيَ عَشائِرُ اللّاوِيِّينَ بِحَسَبِ عائِلاتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","عَشِيرَتا جَرشُونَ هُما لِبْنِي وَشِمْعِي. هاتانِ هُما عَشِيرَتا الجَرشُونِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","وَعَدَدُ جَميعِ ذُكُورِهِمُ البالِغِينَ شَهراً فَأكثَرَ هُوَ سَبعَةُ آلافٍ وَخَمسُ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","كانَتْ عَشيرَتا الجَرشُونِيِّينَ تُخَيِّمانِ خَلفَ المَسْكَنِ إلَى الجِهَةِ الغَربِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","وَرَئِيسُ عَشِيرَتا الجَرشُونِيِّينَ هُوَ ألِياسافُ بْنُ لايِلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","أمَّا مَسؤولِيَّةُ الجَرشُونِيِّينَ فِي خَيمَةِ الاجْتِماعِ فَهِيَ المَسْكَنُ: الخَيمَةُ وَغِطاؤُها وَسِتارَةُ مَدخَلِ خَيمَةِ الاجْتِماعِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","وَسَتائِرُ السّاحَةِ وَسِتارَةُ مَدْخَلِ السّاحَةِ الَّتِي حَولَ المَسْكَنِ وَالمَذبَحِ وَالحِبالِ، مَعَ كُلِّ الأعمالِ المُختَصَّةِ بِحَملِ الخَيمَةِ المُقَدَّسَةِ وَنَقلِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","وَعَشائِرُ قَهاتَ هِيَ عَمْرامُ وَيِصْهارُ وَحَبْرُونُ وَعُزِّيئِيلُ. هَذِهِ هِيَ عَشائِرُ القَهاتِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","وَكانَ عَدَدُ جَمِيعِ ذُكُورِهِمُ البالِغِينَ شَهراً فَأكثَرَ ثَمانِيَةَ آلافٍ وَثَلاثَ مِئَةٍ. وَكانُوا يَقُومُونَ بِواجِباتِهِمْ فِي المَكانِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","وَكانَتْ عَشائِرُ القَهاتِيِّينَ تُخَيِّمُ فِي الجِهَةِ الجَنُوبِيَّةِ مِنَ المَسْكَنِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","وَرَئِيسُ عَشِيرَةِ القَهاتِيِّينَ هُوَ ألِيصافانُ بْنُ عُزِّيئِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","وَكانَتْ مَسْؤُوليّةُ القَهاتِيِّينَ هِيَ الصُّندُوقُ المُقَدَّسُ وَالمائِدَةُ وَالمَنارَةُ وَالمَذبَحَ وَمَذْبَحَ البَخُورِ وَآنِيَةِ المَكانِ المُقَدَّسِ الَّتِي يَسْتَخْدِمُها الكَهَنَةُ، وَالسِتارَةُ، وَجَمِيعُ الأدَواتِ المُتَعَلِّقَةِ بِالخِدْمَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","أمّا رَئِيسُ رُؤَساءِ اللّاوِيِّينَ، فَهُوَ ألِيعازارُ بْنُ هارُونَ الكاهِنِ. وَقَدْ كانَ مَسؤُولاً عَنْ القائِمينَ بِواجِباتِ المَكانِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","وَعَشِيرَتا مَرارِي هُما مَحلِي وَمُوشِي. هاتانِ هُما عَشِيرَتا مَرارِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","وَكانَ عَدَدُ جَمِيعِ ذُكُورِهِمُ البالِغِينَ شَهراً فَأكثَرَ سِتَّةَ آلافٍ وَمِئَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","وَرَئِيسُ عَشِيرَةِ المَرارِيِّينَ هُوَ صُورِئِيلُ بْنُ أبِيحايِلَ. وَكانُوا يُخَيِّمُونَ فِي الجِهَةِ الشَّمالِيَّةِ مِنَ المَسْكَنِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","وَكانَ المَرارِيُّونَ مَسؤُولُونَ عَنْ حِراسَةِ ألواحِ المَسْكَنِ وَعَوارِضِهِ وَأعمِدَتِهِ وَقَواعِدِها، وَكُلِّ أدَواتِهِ وَالخِدْماتِ المُتَعَلِّقَةِ بِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","كَما كُانُوا مَسؤُولِينَ عَنْ أعمِدَةِ السّاحَةِ المُحِيطَةِ بِالخَيمَةِ المُقَدَّسَةِ وَقَواعِدِها وَأوتادِها وَحِبالِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","وَكانَ مُوسَى وَهارُونُ وَأولادُ هارُونَ هُمُ الَّذِينَ يُخَيِّمُونَ أمامَ المَسْكَنِ فِي الجِهَةِ الشَّرقِيَّةِ، أمامَ خَيمَةِ الاجْتِماعِ بِاتِّجاهِ مَشرِقِ الشَّمسِ. كانُوا هُمُ المُشْرِفُونَ عَلَى جَمِيعِ الطُّقُوسِ الَّتِي تُقامُ داخِلَ المَكانِ المُقَدَّسِ، وَعَنْ جَمِيعِ المَسائِلِ المُتَعَلِّقَةِ بِبَنِي إسْرائيلَ. وَكُلُّ دَخيلٍ يَقْتَرِبُ مِنْ أرْضِهِمْ، كانَ يُقْتَلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","فَكَانَ عَدَدُ اللّاوِيِّينَ الَّذِينَ أحصاهُمْ مُوسَى وَهارُونُ بِحَسَبِ أمرِ اللهِ بِحَسَبِ عَشائِرِهِمْ، اثْنَينِ وَعِشرِينَ ألفاً مِنَ الذُّكُورِ البالِغِينَ شَهراً فَأكثَرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","وَقالَ اللهُ لِمُوسَى: «أحصِ كُلَّ الأبْكارِ الذُّكُورِ فِي بَني إسْرائِيلَ الَّذِينَ يَبلُغُونَ شَهراً فَأكثَرَ، وَاكتُبْ قائِمَةً بِأسمائِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","وَخُذِ اللّاوِيِّينَ لِي، أنا اللهُ، بَدَلَ كُلِّ الأبْكارِ فِي بَني إسْرائِيلَ. وَخُذْ حَيواناتِ اللّاوِيِّينَ بَدَلَ كُلِّ أبْكارِ حَيواناتِ بَني إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","فَأحصَى مُوسَى كُلَّ الأبْكارِ فِي بَني إسْرائِيلَ، كَما أمَرَهُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","وَكانَ عَدَدُ الأبْكارِ الذُّكُورِ، مُدَوَّنِينَ بِأسمائِهِمْ، مِمَّنْ يَبلُغُونَ شَهراً فَأكثَرَ، اثْنَينِ وَعِشرِينَ ألفاً وَمِئَتَينِ وَثَلاثاً وَسَبعِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«خُذِ اللّاوِيِّينَ بَدَلَ كُلِّ صَبِيٍّ بِكْرٍ فِي بَني إسْرائِيلَ، وَخُذْ حَيواناتِ اللّاوِيِّينَ بَدَلَ كُلِّ أبْكارِ حَيواناتِ إسْرائِيلَ. اللّاوِيُّونَ لِي، أنا اللهَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","وَلِفِداءِ المِئَتَينِ وَالثَّلاثَ وَالسَّبعِينَ بِكراً فِي بَني إسْرائِيلَ الَّذِينَ زادُوا عَنْ عَدَدِ اللّاوِيِّينَ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","خُذْ خَمسَةَ مَثَاقيلَ مِنَ الفِضَّةِ لِكُلِّ واحِدٍ مِنهُمْ. وَتَكُونَ الفِدْيَةُ بِحَسَبِ الوَزنِ الرَّسمِيِّ لِلمِثْقالِ: المِثْقالُ بِعِشرِينَ قِيراطاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","وَأعْطِ المالَ لِهارُونَ وَبَنِيهِ لِفِداءِ المِئَتَينِ وَالثَّلاثَ وَالسَّبعِينَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","فَأخَذَ مُوسَى المالَ لِفِداءِ الَّذِينَ زادَ عَدَدُهُمْ عَنْ عَدَدِ اللّاوِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","أخَذَ مُوسَى المالَ مِنْ أبْكارِ بَني إسْرائِيلَ. فَكانَ ألْفاً وَثَلاثَ مِئَةٍ وَخَمْسَةٍ وَسِتِّينَ مِثْقالاً بِحَسَبِ الوَزنِ الرَّسمِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","فَأعطَى مُوسَى، بِأمرِ اللهِ، مالَ الفِداءِ لِهارُونَ وَأبْنائِهِ وَفْقاً لِكَلِمَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","وَقالَ اللهُ لِمُوسَى وَهارُونَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«أحصِيا القَهاتِيِّينَ مِنْ بَينِ اللّاوِيِّينَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","الَّذِينَ مِنْ سِنِّ الثَّلاثِينَ وَإلَى الخَمسِينَ، المُؤَهَّلِينَ لِلخِدمَةِ لإجلِ العَمَلِ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","وَمَسؤُولِيَّةُ القَهاتِيِّينَ فِي خَيمَةِ الاجْتِماعِ هِيَ حَملُ الأشياءِ الَّتِي فِي قُدْسِ الأقداسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","«حِينَ يَتَحَرَّكُ الشَّعبُ لِلارتِحالِ، عَلَى هارُونَ وَأبْنائِهِ أنْ يَدخُلُوا إلَى الخَيمَةِ المُقَدَّسَةِ وَيُنزِلُوا السِّتارَةَ وَيُغَطُّوا بِها صُندُوقَ الشَّهادَةِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","وَلْيَضَعُوا فَوقَ السِّتارَةِ غِطاءً مَصنُوعاً مِنَ الجِلدِ النّاعِمِ وَأنْ يَضَعُوا فَوقَهُ قِطعَةَ قُماشٍ زَرْقاءَ، وَأنْ يَضَعُوا عِصِيَّهُ فِي أماكِنِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«ثُمَّ يَضَعُون قِطعَةَ قُماشٍ زَرقاءَ فَوقَ المائِدَةِ المُقَدَّسَةِ، وَيَفرِدُونَ عَلَيها الصُّحُونَ وَالمَغارِفَ وَالزِّبدِيّاتِ وَالأبارِيقِ المُخَصَّصَةِ لِلتَّقدِماتِ السّائِلَةِ. أمّا الخُبْزُ فَيَنبَغِي أنْ يَكُونَ عَلَى المائِدَةِ دائِماً. فَيُنْقَلُ مَعَها حَيْثُ تُنْقَلُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ثُمَّ يَضَعُونَ قِطعَةَ قُماشٍ حَمراءَ فَوقَ هَذِهِ الأشياءِ، وَيُغَطُّونَها بِغِطاءٍ مِنَ الجِلدِ النّاعِمِ. ثُمَّ يَضَعُونَ عِصِيَّ المائِدَةِ فِي أماكِنِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«بَعْدَ ذَلِكَ، يأخُذُونَ قِطعَةَ قُماشٍ زَرقاءَ، وَيُغَطُّونَ بِها المَنارَةَ وَسُرُجَها وَمَلاقِطَها وَمَنافِضَها وَجَمِيعَ آنِيَةِ الزَّيتِ المُستَخدَمَةِ لإجلِ السُّرُجِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ثُمَّ يَضَعُونَ المَنارَةَ وَكُلَّ أدَواتِها فِي غِطاءٍ مِنَ الجِلدِ النّاعِمِ، وَيُرَتِّبُونَها عَلَى لَوحٍ لِحَملِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«يَأْخُذُونَ أيضاً قِطعَةَ قُماشٍ زَرقاءَ، وَيُغَطُّونَ بِها المَذبَحَ الذَّهَبِيَّ. ثُمَّ يُغَطُّونَها بِغِطاءٍ مِنَ الجِلدِ النّاعِمِ، وَيَضَعُونَ عِصِيَّ المَذْبَحِ فِي أماكِنِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","«ثُمَّ يَأخُذُونَ جَمِيعَ أدَواتِ الخِدمَةِ الخاصَّةِ بِالمَكانِ المُقَدَّسِ، وَيَضَعُونَها فِي قِطعَةِ قُماشٍ زَرقاءَ، وَيُغَطُّونَها بِغِطاءٍ مِنَ الجِلدِ النّاعِمِ، وَيُرَتِّبُونَها عَلَى لَوحٍ لِحَملِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","«بَعْدَ ذَلِكَ، يُزِيلُونَ الرَّمادَ مِنْ عَلَى المَذبَحِ، ويَضَعُونَ عَلَيهِ غِطاءً مِنَ القُماشِ البَنَفسَجِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ثُمَّ يَضَعُونَ عَلَيهِ جَمِيعَ أدَواتِ المَذبَحِ مِنْ مَجامِرَ وَمَناشِلَ ورُفُوشٍ وَزُبدِيّاتٍ. وَيَضَعُونَ عَلى جَمِيعِ أدَواتِ المَذبَحِ غِطاءً مِنَ الجِلدِ النّاعِمِ، وَيَضَعُونَ عِصِيَّ المَذْبَحِ فِي أماكِنِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","«وَحِينَ يُكمِلُ هارُونُ وَأبناؤُهُ تَغطِيَةَ المَكان المُقَدَّسِ الآثاثِ وَتأثيثهِ، وَحِينَ يَكُونُ الشَّعبُ مُستَعِدّاً لِلتَّحَرُّكِ، حِينَئِذٍ، يَدخُلُ القَهاتِيُّونَ لِحَملِ تِلْكَ الأشياءِ. وَهَكَذا لَنْ يَلمِسُوا أيَّ شَيءٍ مُقَدَّسٍ فَيَمُوتُوا. هَذِهِ هِيَ الأشياءُ الَّتِي سَيَحمِلُها القَهاتِيُّونَ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«سَيَكُونُ ألِيعازارُ بْنُ هارُونَ هُوَ المَسؤُولُ عَنْ زَيتِ المَنارَةِ وَالبَخُورِ الطَّيِّبِ وَالعُطُورِ وَتَقدِمَةِ الحُبُوبِ اليَومِيَّةِ وَزَيتِ المَسْحَةِ. وَسَيَكُونُ المَسؤُولُ عَنِ المَسْكَنِ وَكُلِّ ما فِيهِ. عَنْ جَمِيعِ ما فِي المَكانِ المُقَدَّسِ وَعَنْ جَمِيعِ أدَواتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ثُمَّ قالَ اللهُ لِمُوسَى وَهارُونَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«لا تَدَعُوا عَشِيرَةَ القَهاتِيِّينَ تَفنَى مِنْ بَينِ اللّاوِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","افْعَلُوا هَذا لَهُمْ لِكَي يَحْيَوا وَلا يَمُوتُوا حِينَ يَقتَرِبُونَ مِنَ الأشْياءِ المُخَصَّصَةِ بِكامِلِها للهِ. فَليَدْخُلْ هارُونُ وَبَنُوهُ، وَيُعَيِّنُوا لِكُلِّ واحِدٍ ما عَلَيهِ عَمَلُهُ وَحَملُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","كَي لا يَدخُلُوا وَيَرَوا الأشياءَ المُقَدَّسَةَ، وَلَو لِلَحظَةٍ فَيَمُوتُوا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«أحصِ الجَرشُونِيِّينَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","الَّذِينَ مِنْ سِنِّ الثَّلاثِينَ وَإلَى الخَمسِينَ المُؤَهَّلِينَ لِلخِدمَةِ لأجلِ العَمَلِ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","«وَمَسؤُولِيَّةُ الجَرشُونِيِّينَ هِيَ الحَزْمُ وَالحَملُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","هُمْ يَحْمِلُونَ سَتائِرَ المَسْكَنِ وَخَيمَةَ الاجْتِماعِ وَأغطِيَتَها، وَالغِطاءَ الجِلدِيَّ النّاعِمَ الَّذِي فَوقَ الأغطِيَةِ، وَسِتارَةَ مَدخَلِ خَيمَةِ الاجْتِماعِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","وَسَتائِرَ السّاحَةِ وَسِتارَةَ مَدْخَلِ السّاحَةِ المُحِيطَةِ بِالمَسْكَنِ، وَالمَذبَحَ، وَالحِبالَ وَكُلَّ أدَواتِها وَالأشْياءَ الخَاصَّةَ بِها. وَيَنَبغِي أنْ يَعمَلُوا جَميعَ الاعمالِ المُوكَلَةِ إلَيهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","يَعَمَلُ الجَرشُونِيِّينَ أعْمالَ الحَملِ وَالتَحْزِيمِ تَحتَ إشرافِ هارُونَ وَأبْنائِهِ. وَتُوَكِّلَهُمْ بِحِراسَةِ الأشياءِ الَّتِي يَحمِلُونَها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","هَذا هُوَ عَمَلُ الجَرشُونِيِّينَ فِي خَيمَةِ الاجْتِماعِ تَحتَ إشرافِ إيثامارَ بْنِ هارُونَ الكاهِنِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«أحْصِ المَرارِيِّينَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","الَّذِينَ مِنْ سِنِّ الثَّلاثِينَ وَإلَى الخَمسِينَ المُؤَهَّلِينَ لِلخِدمَةِ لأجلِ العَمَلِ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","وَهَذا ما يُكَلَّفُونَ بِحَملِهِ طَوالَ خِدْمَتِهِمْ فِي خَيمَةِ الاجْتِماعِ: ألواحُ المَسْكَنِ وَعَوارِضُهِ وَأعمِدَتُهُ وَقَواعِدُها، ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","وَأعْمِدَةُ السّاحَةِ المُحِيطَةِ بِالخَيمَةِ المُقَدَّسَةِ وَقَواعِدُها وَأوتادُها وَحِبالُها وَكُلُّ أدَواتِها. اكتُبْ قائِمَةً بِأسْماءِ الرِّجالِ، وَعَيِّنْ لِكُلِّ واحِدٍ ما سَيَحْمِلُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","هَذا هُوَ عَمَلُ عَشائِرِ المَرارِيِّينَ. سَيَعمَلُونَ فِي خَيمَةِ الاجْتِماعِ تَحتَ إشرافِ إيثامارَ بْنِ هارُونَ الكاهِنِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","فَأحصَى مُوسَى وَهارُونُ وَرُؤَساءُ الشَّعبِ القَهاتِيِّينَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","سَجَّلُوا جَميعَ الرِّجالِ مِنْ سِنِّ الثَّلاثِينَ إلَى سِنِّ الخَمسِينَ. أيِ المُؤَهَّلِينَ لِلخِدمَةِ لأجلِ العَمَلِ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","فَكانَ عَدَدُ الرِّجالِ بِحَسَبِ عَشائِرِهِمْ ألفَينِ وَسَبعَ مِئَةٍ وَخَمْسِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","هَؤُلاءِ هُمُ الرِّجالُ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ عَشائِرِ القَهاتِيِّينَ، الَّذِينَ يَعمَلُونَ فِي خَيمَةِ الاجْتِماعِ، الَّذِينَ أحصاهُمْ مُوسَى وَهارُونُ بِحَسَبِ أمرِ اللهِ عَلَى فَمِ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","وَتَمَّ إحصاءُ الجَرشُونِيِّينَ بِحَسَبِ عَشائِرِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","تَمَّ تَسْجيلُ جَميعِ الرِّجالِ مِنْ سِنِّ الثَّلاثِينَ إلَى سِنِّ الخَمسِينَ، أيِ المُؤَهَّلِينَ لِلخِدمَةِ لأجلِ العَمَلِ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","فَكانَ عَدَدُ الرِّجالِ بِحَسَبِ عَشائِرِهِمْ ألفَينِ وَسِتَّ مِئَةٍ وَثَلاثِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","وَهَؤُلاءِ هُمُ الرِّجالُ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ عَشائِرِ القَهاتِيِّينَ، الَّذِينَ يَعمَلُونَ فِي خَيمَةِ الاجْتِماعِ، الَّذِينَ أحصاهُمْ مُوسَى وَهارُونُ بِحَسَبِ أمرِ اللهِ عَلَى فَمِ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","وَتَمَّ إحصاءُ المَرارِيِّينَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِ آبائِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","تَمَّ تَسْجيلُ جَميعِ الرِّجالِ مِنْ سِنِّ الثَّلاثِينَ إلَى سِنِّ الخَمسِينَ، أيِ المُؤَهَّلِينَ لِلخِدمَةِ لإجلِ العَمَلِ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","فَكانَ عَدَدُ الرِّجالِ بِحَسَبِ عَشائِرِهِمْ ثَلاثَةَ آلافٍ وَمِئَتَينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","وَهَؤُلاءِ هُمُ الرِّجالُ الَّذِينَ تَمَّ إحصاؤُهُمْ مِنْ عَشائِرِ المَرارِيِّينَ. أحصاهُمْ مُوسَى وَهارُونُ بِحَسَبِ أمرِ اللهِ عَلَى فَمِ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","وَأحصَى مُوسَى وَهارُونُ وَرُؤَساءُ إسْرائِيلَ كُلَّ اللّاوِيِّينَ بِحَسَبِ عَشائِرِهِمْ وَعائِلاتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","فَسَجَّلُوا جَميعَ الرِّجالِ مِنْ سِنِّ الثَّلاثِينَ إلَى سِنِّ الخَمسِينَ، أيِ المُؤَهَّلِينَ لِلخِدمَةِ لأجلِ العَمَلِ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","فَكانَ عَدَدُ المُسَجَّلِينَ ثَمانِيَةَ آلافٍ وَخَمسَ مِئَةٍ وَثَمانِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","تَمَّ إحصاؤُهُمْ بِأمرٍ مِنَ اللهِ مِنْ خِلالِ مُوسَى. كُلُّ واحِدٍ بِحَسَبِ عَمَلِهِ فِي الحَزمِ وَالحَملِ بِحَسَبِ أمرِ اللهِ عَلَى فَمِ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«عَلِّمْ بَني إسْرائِيلَ بِأنْ يَنفُوا مِنَ المُخَيَّمِ كُلَّ مُصابٍ بِالبَرَصِ، وَكُلَّ مَنْ يَسِيلُ مِنْ جَسَدِهِ سائِلٌ نَجِسٌ، وَكُلَّ مَنْ يَتَنَجَّسُ بِسَبَبِ لَمسِهِ لِمَيِّتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","انْفُوا الذُّكُورَ وَالإناثَ، وَاطْرُدُوهُمْ خارِجاً، حَتَّى لا يُنَجِّسُوا المُخَيَّمَ حَيثُ أسكُنُ فِي وَسَطِكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","فَفَعَلَ بَنو إسْرائِيلَ هَذا وَنَفُوا المُتَنَجِّسِينَ خارِجَ المُخَيَّمِ. فَعَلَ بَنو إسْرائِيلَ تَماماً كَما قالَ اللهُ لِمُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«قُلْ لِبَني إسْرائِيلَ: إنْ أخطَأ رَجُلٌ أوِ امْرأةٌ بِحَقِّ شَخصٍ آخَرَ بِالسَّرِقَةِ مِنهُ، فَإنَّهُ يَكُونُ قَدْ أخطَأ إلَى اللهِ خَطِيَّةً عَظِيمَةً. إنَّهُ مُذنِبٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","عَلَيهِ أنْ يَعتَرِفَ بِما سَرَقَهُ وَيُعَوِّضَ بِشَكلٍ كامِلٍ، وَيُضِيفَ إلَى التَّعوِيضِ خُمسَ قِيمَةِ المَسرُوقِ وَيُعطِيَهِ لِلَّذِي أخطَأ إلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","وَإنْ كانَ الرَّجُلُ مَيِّتاً، وَلا أقرِباءَ لَهُ لِيَأخُذُوا التَّعوِيضَ. فَإنَّ التَّعوِيضَ يَذهَبُ إلَى اللهِ فَيُعْطَى لِلكاهِنِ. عَدا الكَبْشِ الَّذِي يُحْضِرُهُ المُذنِبُ. فَهَذا يَذْبَحُهُ الكَاهِنُ كَفّارَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","«كُلُّ تَقدِمَةٍ مُقَدَّسَةٍ يُقَدِّمُها بَنو إسْرائِيلَ لِلكاهِنِ فَإنَّها تَكُونُ مِنْ نَصِيبِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","وَتَكُونُ التَّقْدِماتُ المُقَدَّسَةُ مُلْكاً لِمَنْ يُقَدِّمُها، عَدا ما يُعْطيهِ لِلكاهِنِ، فَإنَّهُ يَكُونُ مِنْ نَصِيبِ الكاهِنِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«قُلْ لِبَني إسْرائِيلَ: إنِ انْحَرَفَتْ زَوجَةُ رَجُلٍ ما وَخانَتهُ ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","بِمُعاشَرَةِ رَجُلٍ آخَرَ، وَزَوجُها لا يَعرِفُ، إذْ أنَّها تَعمَلُ هَذا سِرّاً. مَعَ أنَّها قَدْ نَجَّسَتْ نَفسَها، حَيْثُ إنَّهُ لا يُوجَدُ هُناكَ شاهِدٌ، كَما أنَّها لَمْ تُمسَكْ وَهِيَ تَرتَكِبُ الزِّنَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","فَإذا اعتَرَى رُوحُ الغِيرَةِ الرَّجُلَ فَشَكَّ بِزَوجَتِه الَّتِي قَدْ تَنَجَّسَتْ بِالفِعلِ، أوْ إذا اعتَرَاهُ رُوحُ الغِيرَةِ مَعَ أنَّها لَمْ تُنَجِّسْ نَفسَها، ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","فَليُحْضِرِ الرَّجُلُ زَوجَتَهُ إلَى الكاهِنِ، وَيُحضِرْ مَعَهُ تَقْدِمَتَها المَطلُوبَةَ: عُشْرَ قُفَّةٍ مِنْ طَحِينِ الشَّعِيرِ. لا يُسْكَبُ عَلَى الطَّحِينِ زَيتٌ، وَلا يُوضَعُ بَخُورٌ فَوقَهُ. لأنَّ هَذِهِ تَقدِمَةُ شَكٍّ، لِبَيانِ الاتِّهامِ وَالتَّذكِيرِ بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«وَيُحضِرُ الكاهِنُ المَرأةَ إلَى الأمامِ وَيُوقِفُها فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ثُمَّ يَأخُذُ الكاهِنُ ماءً مُقَدَّساً فِي إناءٍ خَزَفِيٍّ، وَيَأخُذُ مِنَ الغُبارِ الَّذِي عَلَى أرْضِيَّةِ المَسْكَنِ المُقَدَّسِ وَيَضَعُهُ فِي الماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ثُمَّ يُوقِفُ الكاهِنُ المَرْأةَ فِي حَضْرَةِ اللهِ، وَيَكْشِفُ رَأْسَها، وَيَضَعُ فِي كَفَّيْها التَّقْدِمَةَ، الّتِي هِيَ تَقدِمَةُ شَكٍّ. وَيُمسِكُ الكاهِنُ بِإناءِ الماءِ المُرِّ الَّذِي يَأتِي بِاللَّعنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","وَيَجعَلُ الكاهِنُ المَرأةَ تُقسِمُ فَيَقُولُ لَها: ‹إنْ لَمْ يَكُنْ لِرَجُلٍ آخَرَ عَلاقَةٌ بِكِ، وَلَمْ تَفسُدِي وَلَمْ تَتَنَجَّسِي وَأنتِ مُتَزَوِّجَةٌ بِزَوجِكِ، فَإنَّكِ تُطَهَّرِينَ مِنْ هَذا الماءِ المُرِّ الَّذِي يَأتِي بِاللَّعنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","لَكِنْ إنْ فَسَدْتِ وَأنتِ مُتَزَوِّجَةٌ بِزَوجِكِ، وَتَنَجَّسْتِ، وَكانَتْ لِرَجُلٍ آخَرَ غَيرُ زَوجِكِ عَلاقَةٌ بِكِ …› ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","«وَهَكَذا يَجعَلُ الكاهِنُ المَرأةَ تُقسِمُ بِقَسَمِ اللَّعنَةِ هَذا، وَيَقُولُ الكاهِنُ لِلمَرأةِ: ‹فَلْيَلعَنْكِ اللهُ حَتَّى يَصِيرَ النّاسُ يَستَخدِمُونَ اسْمَكِ كَلَعْنةٍ، وَلْيَجعَلِ اللهُ فَخْذَكِ مُتَرَهِّلَةً وَبَطْنَكِ مُتَوَرِّمةً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","فَلْيَأْتِ ماءُ اللَّعنَةِ هَذا بِاللَّعنَةِ إلَى بَطنِكِ، فَيَجعَلُ بَطنَكِ مُتَوَرِّماً وَفَخْذَكِ مُتَرَهِّلَةً.› فَتَقُولُ المَرأةُ: ‹لِيَكُنْ ذَلِكَ!› ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«ثُمَّ يَكتُبُ الكاهِنُ هَذِهِ اللَّعناتِ عَلَى قِطْعَةِ جِلْدٍ ثُمَّ يَمحُوها فِي الماءِ المُرِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ثُمَّ يَجعَلُ الكاهِنُ المَرأةَ تَشرَبُ الماءَ المُرَّ الَّذِي يَأتِي بِاللَّعنَةِ، وَالَّذِي يُسَبِّبُ ألَماً شَدِيداً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","«وَيَأخُذُ الكاهِنُ مِنْ يَدِ المَرأةِ تَقدِمَةَ الحُبُوبِ الَّتِي قَدَّمَها الزَّوجُ الَّذِي يَشُكُّ بِزَوْجَتِهِ، وَيرفَعُها فِي حَضْرَةِ اللهِ، ثُمَّ يَأتِي بِها إلَى المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ثُمَّ يَأخُذُ الكاهِنُ مِلءَ كَفِّهِ مِنْ تَقدِمَةِ الحُبُوبِ كَعَلامَةٍ، وَيُحرِقُهُ عَلَى المَذبَحِ. وَبَعدَ ذَلِكَ يَجعَلُ الكاهِنُ المَرأةَ تَشرَبُ الماءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","وَبَعدَ أنْ يَجعَلَها تَشرَبُ الماءَ، فَإنْ كانَتْ نَجِسَةً وَغَيرَ وَفِيَّةٍ لِزَوجِها، فَإنَّ الماءَ الَّذِي يَأتِي بِاللَّعنَةِ سَيَدخُلُ جَوفَها وَيُسَبِّبُ لَها ألَماً شَدِيداً، فَتَتَوَرَّمُ بَطْنُها وَتَتَرَهَّلُ فَخْذُها، وَتُصبِحُ لَعنَةً وَسَطَ شَعبِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","وَلَكِنْ إنْ لَمْ تَكُنِ المَرأةُ قَدْ نَجَّسَتْ نَفسَها، لَكِنَّها طاهِرَةٌ، فَإنَّهُ سَيَحكُمُ بِبَراءَتِها، وَسَتَكُونُ قادِرَةً عَلَى الإنجابِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«هَذا هُوَ القانُونُ المُختَصُّ بِحالاتِ الشَّكِّ. حِينَ تَنحَرِفُ المَرأةُ بَينَما هِيَ مُتَزَوِّجَةٌ بِزَوجِها، وَتُنَجِّسُ نَفسَها، ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","أوْ حِينَ يَعتَرِي الرَّجُلَ رُوحُ غِيرَةٍ وَيَشُكُّ بِزَوْجَتِهِ، فَإنَّهُ يُوقِفُها فِي حَضْرَةِ اللهِ. فَيَعمَلُ الكاهِنُ هَذِهِ الأُمُورَ لَها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","حِينَئِذٍ، لا يَكُونُ الزَّوجُ مُذْنِباً، وَأمّا المَرأةُ فَتَحمِلُ عِقابَ خَطِيَّتِها.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«قُلْ لِبَني إسْرائِيلَ: إنْ تَعَهَّدَ رَجُلٌ أوِ امْرأةٌ بِأنْ يَنذِرَ نَفسَهُ، مُكَرِّساً نَفسَهُ للهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","فَعَلَيهِ أنْ يَمتَنِعَ عَنْ شُربِ الخَمرِ وَالشَّرابِ المُسكِرِ، وَحَتَّى عَنْ شُرَبِ عَصِيرِ العِنَبِ وَأكلِ العِنَبِ الطّازِجِ أوْ الزَّبِيبِ ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","طِيلَةَ أيّامِ نَذرِهِ. لا يَأكُلْ شَيئاً مِنْ نِتاجِ الكَرمَةِ أوْ بُذُورِ العِنَبِ أوْ قِشرِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","«طِيلَةَ أيّامِ نَذْرِهِ، لا يَنْبَغِي أنْ يَقُصَّ شَعرَ رَأسِهِ، إلَى نِهايَةِ وَقْتِ تَكرِيسِهِ للهِ. يُرَبِّيَ خِصالَ شَعرِ رَأْسِهِ. وَيَكُونُ مُخَصَّصاً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","«طِيلَةَ أيّامِ تَكرِيسِهِ للهِ، لا يَنْبَغِي أنْ يَدخُلَ مَكاناً فِيهِ شَخصٌ مَيِّتٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","لا يَتَنَجَّسْ بِمَيِّتٍ حَتَّى وَإنْ كانَ أبِاهُ أوْ أُمَّهُ أوْ أخاهُ أوْ أُختَهُ، لأنَّ شَعرَهُ يَدُلُّ عَلَى تَكْرِيسِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","فَطِيلَةَ أيّامِ نَذرِهِ، يَكُونُ مُكَرَّساً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","«وَإنْ ماتَ شَخصٌ قُربَ النَّذِيرِ فَجأةً فَنَجَّسَ شَعرَ النَّذِيرِ، فَليَحلِقْ رَأسَهُ فِي يَومِ تَطهِيرِهِ. يَحلِقُ شَعرَهُ فِي اليَومِ السّابِعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","وَفِي اليَومِ الثّامِنِ، يُحضِرُ يَمامَتَينِ أوْ حَمامَتَينِ صَغِيرَتَينِ لِلكاهِنِ فِي مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","فَيُقَدِّمُ الكاهِنُ أحَدَ الطَيرَينِ ذَبِيحَةَ خَطِيَّةٍ، وَالآخَرَ ذَبيحَةً صَاعِدَةً، وَيُكَفِّرُ عَنهُ. فَقَدْ أذْنَبَ بِلَمسِهِ لِلمَيِّتِ. وَفِي ذَلِكَ اليَومِ، يُقَدِّسُ شَعرَ رَأسِهِ ثانِيَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","وَيُكَرِّسُ نَفسَهُ للهِ طَوالَ المُدَّةِ الَّتِي تَعَهَّدَ بِأنْ يَكُونَ نَذِيراً فِيها. وَيُحضِرُ حَمَلاً عُمْرُهُ سَنَةٌ ذَبِيحَةَ ذَنْبٍ. ولا تُحسَبُ فَتْرَةُ التَّطْهِيرِ مِنْ أيّامِ نِذْرِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«وَهَذِهِ هِيَ شَرِيعَةُ النَّذِيرِ: فِي اليَومِ الَّذِي فِيهِ تَكتَمِلُ أيّامُهُ كَنَذِيرٍ، يُحْضَرُ إلَى مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","وَيُقَدِّمُ ما يَلِي للهِ: حَمَلاً واحِداً عُمْرُهُ سَنَةٌ لا عَيْبَ فِيهِ، ذَبِيحَةً صاعِدَةً نَعْجَةً واحِدَةً عُمْرُها سَنَةٌ لا عَيْبَ فِيها، ذَبِيْحَةَ خَطِيَّةٍ، كَبْشاً لا عَيبَ فِيهِ ذَبِيحَةَ سَلامٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","سَلَّةَ خُبزٍ غَيرِ مُخْتَمِرٍ مَصنُوعٍ مِنَ الطَّحِينِ الجَيِّدِ مَمْزُوجاً بِالزَّيتِ، وَرَقائِقَ مَدهُونَةً بِزَيتٍ، مَعَ تَقدِماتِ الحُبُوبِ وَالسَّكِيبِ المَطلُوبَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","«يُقَدِّمُ الكاهِنُ هَذِهِ التَّقدِماتِ فِي حَضرَةِ اللهِ. يُقَدِّمُ ذَبِيحَةَ الخَطِيَّةِ وَالذَّبيْحَةَ الصَّاعِدَةَ لأجلِ النَّذِيرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","وَيُقَدِّمُ الكَبْشَ ذَبِيحَةَ سَلامٍ للهِ مَعَ سَلَّةِ الخُبزِ غَيرِ المُخْتَمِرِ مَعَ تَقدِماتِ الحُبُوبِ وَالسَّكِيبِ المَطلُوبَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","«ثُمَّ يَحلِقُ النَّذيرُ شَعرَهُ المُكَرَّسَ فِي مَدخَلِ خَيمَةِ الاجْتِماعِ. وَيَأخُذُ الشَّعْرَ المُكَرَّسَ وَيَضَعَهُ عَلَى النّارِ أسفَلَ ذَبِيحَةِ السَّلامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","«ثُمَّ يَأخُذُ الكاهِنُ كَتِفَ الكَبْشِ المَسلُوقَةِ، وَرَغِيفاً غَيرَ مُخْتَمِرٍ مِنَ السَّلَّةِ، وَرَقاقَةً غَيْرَ مُخْتَمِرَةٍ، وَيَضَعُها جَمِيعاً فِي كَفَّيِّ النَّذِيرِ، بَعدَ أنْ يَكُونَ قَدْ حَلَقَ شَعرَ رَأسِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ثُمَّ يَرفَعُها الكاهِنُ فِي حَضرَةِ اللهِ. إنّها نَصيْبٌ مُخَصَّصٌ لِلكاهِنِ مَعَ الصَّدرِ وَالفَخذِ المَرفُوعَانِ. بَعدَ ذَلِكَ يُمكِنُ لِلنَّذِيرِ أنْ يَشرَبَ نَبيذاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","«هَذِهِ هِيَ شَرِيعَةُ النَّذِيرِ الَّذِي يَتَعَهَّدُ بِنَذرٍ. وَهَذِهِ هِيَ تَقدِمَتُهُ للهِ لإجلِ تَكرِيسِهِ، وَما يَنبَغِي تَقدِيمُهُ بَحَسَبِ شَرِيعَةِ النَّذِيرِ. وَلَهُ أنْ يَتَعَهَّدَ بِأكْثَرِ مِنْ ذَلِكَ إنْ أرادَ، عَلَى أنْ يَلتَزِمَ بما يَتَعَهَّدُ بِهِ. لَكِنْ عَلَيهِ أنْ يُقَدِّمَ ما تَنُصُّ عَلَيهِ شَرِيعَةُ النَّذِيرِ عَلَى أقَلِ تَقْدِيرٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«قُلْ لِهارُونَ وَأبناءَهُ أنْ يُبارِكُوا بَني إسْرائِيلَ بِأنْ يَقُولُوا: ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‹فَلْيُبارِكْكُمْ يهوه وَيَحمِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","لِيُشْرِقْ يهوه بِوَجهِهِ عَلَيكُمْ، وَيَتَلَطَّفْ عَلَيكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","وَلْيَنظُرْ يهوه إلَيكُمْ بِحَنانِهِ، وَيُعطِكُمْ سَلاماً.› ");
INSERT INTO arbwbtc_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","«هَكَذا يَنبَغِي أنْ يُعلِنَ هارُونُ وَأبْناؤهُ اسْمِيَ لِيُبارِكُوا بَني إسْرائِيلَ. وَأنا سَأُبارِكُهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","وَحِينَ انتَهَى مُوسَى مِنْ إقامَةِ المَسْكَنِ المُقَدَّسِ، مَسَحَهُ بِالزَّيتِ وَكَرَّسَهُ مَعَ جَمِيعِ أثاثِهِ. كَما مَسَحَ وَكَرَّسَ المَذبَحَ وَجَمِيعَ أدَواتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ثُمَّ جاءَ رُؤَساءُ إسْرائِيلَ، الَّذِينَ هُمْ رُؤَساءُ العائِلاتِ وَرُؤَساءُ القَبائِلِ، وَالَّذِينَ كانُوا مَسؤُولِينَ عَنْ إحصاءِ الشَّعبِ، بِتَقدِماتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","أحضَرُوا تَقدِماتِهِمْ إلَى مَحْضَرِ اللهِ: سِتَّ عَرَباتٍ مُغَطّاةٍ، وَاثنَي عَشَرَ ثَوراً، عَرَبَةً مَعَ كُلِّ رَئِيسَينِ، وَثَوراً مَعَ كُلِّ رَئِيسٍ. وَأحضَرُوا جَمِيعَ تَقْدِماتِهِمْ أمامَ المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","فَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«اقْبَلْ هَذِهِ التَّقدِماتِ مِنهُمْ، فَهِيَ سَتُستَخدَمُ فِي أعمالِ نَقلِ خَيمَةِ الاجْتِماعِ. أعْطِها لِلّاوِيِّينَ، بِحَسَبِ ما تَتَطَلَّبُهُ أعمالُهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","فَأخَذَ مُوسَى العَرَباتِ وَالثِّيرانَ، وَأعطاها لِلّاوِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","أعطَى عَرَبَتَينِ وَأربَعَةَ ثِيرانٍ لِلجَرْشُونِيِّينَ، بِحَسَبِ ما يَحتاجُونَ فِي عَمَلِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","وَأعطَى أربَعَ عَرَباتٍ وَثَمانِيَةَ ثِيرانٍ لِلمَرارِيِّينَ، بِحَسَبِ ما يَحتاجُونَ فِي عَمَلِهِمْ، تَحتَ إشرافِ إيثامارَ بْنِ هارُونَ الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","وَلَمْ يُعطِ مُوسَى شَيئاً مِنها لِلقَهاتِيِّينَ، لأنَّ عَمَلَهُمْ هُوَ حَملُ الأشياءِ المُقَدَّسَةِ. وَكانُوا يَحمِلُونَها عَلَى أكتافِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","كَما أحضَرَ الرُّؤَساءُ تَقدِماتٍ لأجلِ تَدشِينِ المَذبَحِ فِي اليَومِ الَّذِي تَمَّ مَسْحُهُ فِيهِ. أحضَرَ الرُّؤَساءُ تَقدِماتِهِمْ إلَى أمامِ المَذبَحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ثُمَّ قالَ اللهُ لِمُوسَى: «فَلْيُقَدِّمُوا تَقدِماتِهِمْ لأجلِ تَدشِينِ المَذبَحِ، بِحَيثُ يُقَدِّمُ رَئِيسٌ واحِدٌ فِي اليَومِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","فَكانَ نَحشُونُ بْنُ عَمِّينادابَ، رَئِيسُ قَبِيلَةِ يَهُوذا، هُوَ مَنْ قَدَّمَ تَقدِمَتَهُ فِي اليَومِ الأوَّلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ نَحشُونُ بْنُ عَمِّينادابَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","وَفِي اليَومِ الثّانِي قَدَّمَ نَثَنائِيلُ بْنُ صُوغَرَ، رَئِيسُ قَبِيلَةِ يَسّاكِرَ، تَقدِمَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ نَثَنائِيلَ بْنِ صُوغَرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","وَفِي اليَومِ الثّالِثِ قَدَّمَ ألِيآبُ بْنُ حِيلُونَ، رَئِيسُ قَبِيلَةِ زَبُولُونَ، تَقدِمَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ ألِيآبَ بْنِ حِيلُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","وَفِي اليَومِ الرّابِعِ قَدَّمَ ألِيصُورُ بْنُ شَدَيئُورَ، رَئِيسُ قَبِيلَةِ رَأُوبَيْنَ، تَقدِمَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ ألِيصُورَ بْنِ شَدَيئُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","وَفِي اليَومِ الخامِسِ، قَدَّمَ شَلُومِيئِيلُ بْنُ صُورِيَشَدّايَ، رَئِيسُ قَبِيلَةِ شِمْعُونَ، تَقدِمَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ شَلُومِيئِيلَ بْنِ صُورِيَشَدّايَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","وَفِي اليَومِ السّادِسِ قَدَّمَ ألِيآسافُ بْنُ دَعُوئِيلَ، رَئِيسُ قَبِيلَةِ جادَ، تَقدِمَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ ألِيآسافَ بْنِ دَعُوئِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","وَفِي اليَومِ السّابِعِ، قَدَّمَ ألِيشَمَعُ بْنُ عَمِّيهُودَ، رَئِيسُ قَبِيلَةِ أفْرايِمَ، تَقدِمَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ ألِيشَمَعَ بْنِ عَمِّيهُودَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","وَفِي اليَومِ الثّامِنِ، قَدَّمَ جَملِيئِيلُ بْنُ فَدَهْصُورَ، رَئِيسُ قَبِيلَةِ مَنَسَّى، تَقدِمَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ جَملِيئٍيلَ بْنِ فَدَهْصُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","وَفِي اليَومِ التّاسِعِ، قَدَّمَ أبِيدَنُ بْنُ جِدْعُونِي، رَئِيسُ قَبِيلَةِ بَنْيامِيْنَ تَقدِمَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ أبِيدَنَ بْنِ جِدْعُونِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","وَفِي اليَومِ العاشِرِ، قَدَّمَ أخِيعَزَرُ بْنُ عَمِّيشَدّايَ، رَئِيسُ قَبِيلَةِ دانَ تَقدِمَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ أخِيعَزَرَ بْنِ عَمِّيشَدّايَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","وَفِي اليَومِ الحادِي عَشَرَ، قَدَّمَ فَجِعِيئِيلُ بْنِ عُكْرَنَ، رَئِيسُ قَبِيلَةِ أشِيرَ، تَقدِمَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ فَجْعِيئِيلَ بْنِ عُكْرَنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","وَفِي اليَومِ الثّانِي عَشَرَ، قَدَّمَ أخِيرَعُ بْنُ عِينَنَ، رَئِيسُ قَبِيلَةِ نَفْتالِي، تَقدِمَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","أمَّا تَقدِمَتُهُ فَهِيَ: طَبَقٌ مِنَ الفِضَّةِ وَزْنُهُ مِئَةٌ وَثَلاثُونَ مِثْقالاً، زُبدِيَّةٌ مِنَ الفِضَّةِ وَزْنُها سَبْعُونَ مِثْقالاً، كِلْتاهُما بِحَسَبِ الوَزْنِ الرَّسمِيِّ، وَكِلْتاهُما مَملُوءَتانِ طَحِيناً ناعِماً مَمزُوجاً بِزَيتٍ، كَتَقدِمَةِ حُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","مِغرَفَةٌ مِنَ الذَّهَبِ وَزْنُها عَشْرَةُ مَثاقِيلَ، مَملُوءَةً بَخُوراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","عِجلٌ وَاحِدٌ، كَبْشٌ وَاحِدٌ، حَمَلٌ وَاحِدٌ عُمْرُهُ سَنَةٌ لِلذَّبيحَةِ الصّاعِدَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","تَيسٌ وَاحِدٌ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ثَورَانِ وَخَمسَةَ كِباشٍ وَخَمسَةَ تُيُوسٍ وَخَمسَةَ حِملانٍ عُمْرُها سَنَةٌ لِذَبِيحَةِ السَّلامِ. كانَتْ هَذِهِ تَقدِمَةَ أخِيرَعَ بْنِ عِينَنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","وَهَذِهِ هِيَ تَقدِمَةُ تَدشِينِ المَذبَحِ المُقَدَّمَةِ مِنْ رُؤَساءِ إسرائِيلَ حِينَ مُسِحَ: اثنا عَشَرَ طَبَقاً مِنَ الفِضَّةِ. اثنَتا عَشَرَ زُبدِيَّةً مِنَ الفِضَّةِ. اثنَتا عَشَرَ مِغْرَفَةً مِنَ الذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","وَزْنُ كُلِّ طَبَقٍ مِئَةٌ وَثَلاثُونَ مِثْقالاً مِنَ الفِضَّةِ. وَزنُ كُلِّ زُبدِيَّةٍ سَبْعُونَ مِثْقالاً مِنَ الفِضَّةِ. فَكانَ وَزنُ جَمِيعِ الأوعِيَةِ الفِضِّيَّةِ ألْفينِ وَأرْبَعَ مِئَةِ مِثْقالٍ بِحَسَبِ الوَزنِ الرَّسمِيِّ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","وَكانَ وَزْنُ كُلُّ مِغْرَفَةٍ مِنَ مَغَارِفِ البَخُورِ الذَّهَبيَّةِ الاثْنَتَي عَشَرَ، عَشْرَةَ مَثاقيلَ بِحَسَبِ الوَزنِ الرَّسمِيِّ. فَيَكُونُ مَجْمُوعُ أوزانِها مِئَةً وَعِشْرينَ مِثْقالاً مِنَ الذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","وَكانَ مَجمُوعُ الحَيواناتِ المُقَدَّمَةِ ذَبائِحَ صاعِدَةً اثْنَي عَشَرَ ثَوراً وَاثْنَي عَشَرَ كَبْشاً وَاثْنَي عَشَرَ حَمَلاً ذَكَراً عُمْرُهُ سَنَةٌ، مَعَ تَقدِماتِ الحُبُوبِ المَطلُوبَةِ، وَاثْنَي عَشَرَ تَيساَ لِذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","وَكانَ مَجمُوعُ الحَيواناتِ المُقَدَّمَةِ كَذَبائِحِ سَلامٍ أربَعَةً وَعِشرِينَ ثَوراً وَسِتِّينَ كَبْشاً وَسِتِّينَ تَيساً وَسِتِّينَ حَمَلاً ذَكَراً عُمْرُ الواحِدِ سَنَةٌ. هَذِهِ هِيَ تَقدِماتُ تَدشِينِ المَذبَحِ بَعْدَ أنْ مُسِحَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","وَحِينَ كانَ مُوسَى يَدخُلُ إلَى خَيمَةِ الاجْتِماعِ لِيَتَكَلَّمَ إلَى اللهِ، كانَ يَسمَعُ صَوتَ اللهِ يَتَكَلَّمُ إلَيهِ مِنْ بَينِ الكارُوبَينِ فَوقَ غِطاءِ صُندُوقِ الشَّهادَةِ المُقَدَّسِ. هَذِهِ هِيَ الطَّرِيقَةُ الَّتِي كانَ اللهُ يَتَكَلَّمُ بِها إلَى مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«قُلْ لِهارُونَ: ‹حِينَ تُشعِلُ السُّرُجَ، فَيَنْبَغِي أنْ تُضِيءَ السُّرُجُ السَّبعَةُ المِنطَقَةَ الواقِعَةَ أمامَ المَنارَةِ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","فَعَمِلَ هارُونُ ذَلِكَ، إذْ أشعَلَ السُّرُجَ لِتُضِيءَ المِنطَقَةَ الواقِعَةَ أمامَ المَنارَةِ كَما أمَرَ اللهُ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","وَقَدْ صُنِعَتِ المَنارَةُ مِنْ ذَهَبٍ مَطرُوقٍ مِنْ قاعِدَتِها وَحَتَّى زَهراتِها. صُنِعَتِ حَسَبَ الشَّكلِ الَّذِي أظهَرَهُ اللهُ لِمُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«خُذِ اللّاوِيِّينَ مِنْ بَينِ بَني إسْرائِيلَ وَطَهِّرْهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","وَهَذا ما تَفْعَلُهُ لِتَطهِيرِهِمْ: رُشَّ ماءَ التَّطهِيرِ عَلَيهِمْ. وَلْيَحلِقُوا كُلَّ شَعرِ جِسمِهِمْ. وَلْيَغسِلُوا ثِيابَهُمْ وَيُطَهِّرُوا أنفُسَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","«ثُمَّ لِيَأخُذُوا ثَوراً صَغِيراً مِنَ القَطِيعِ، وَتَقدِمَةَ حُبُوبٍ مِنَ الطَّحِينِ الجَيِّدِ مَمْزُوجاً بِزَيتٍ. وَلِيَأخُذُوا ثَوراً صَغِيراً آخَرَ مِنَ القَطِيعِ لأجلِ ذَبِيحَةِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ثُمَّ تُحضِرُ اللّاوِيِّينَ أمامَ خَيمَةِ الاجْتِماعِ. وَتَجمَعُ جَمِيعَ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","وَحِينَ تُحضِرُ اللّاوِيِّينَ إلَى مَحْضَرِ اللهِ، لِيَضَعِ الشَّعبُ أيدِيَهُمْ عَلَيهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","وَهَكَذا يُقَدِّمُ هارُونُ اللّاوِيِّينَ تَقدِمَةً مِنْ بَني إسْرائِيلَ وَيَرفَعُهُمْ فِي حَضرَةِ اللهِ، لِكَي يَخدِمُوا اللهَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","«يَضَعُ اللّاوِيُّونَ أيدِيَهُمْ عَلَى رَأسَيِّ الثَّورَينِ، ثُمَّ يُقَدَّمُ أحَدُهُما ذَبِيحَةَ خَطِيَّةٍ، وَالآخَرُ ذَبيْحَةً صَاعِدَةً للهِ. وَيَتَطَهَّرُ اللّاوِيُّونَ بِهاتَينِ الذَّبيحَتينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","«هَكَذا تُعَيِّنُ اللّاوِيِّينَ وَتُخَصِّصُهُمْ لِمُساعَدَةِ هارُونَ وَأبْنائِهِ. تُقَدِّمُهُمْ تَقدِمَةً فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","خَصِّصِ اللّاوِيِّينَ مِنْ بَينِ بَني إسْرائِيلَ لِي. اللّاوِيُّونَ لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","«وَبَعدَ ذَلِكَ، يَصِيرُ اللّاوِيُّونَ مُؤَهَّلِينَ لِلخِدمَةِ فِي خَيمَةِ الاجْتِماعِ، حِينَ تَكُونُ قَدْ طَهَّرْتَهُمْ وَقَدَّمْتَهُمْ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","لأنَّهُمْ سَيَكُونُونَ مُكَرَّسِينَ لِي بِالكامِلِ مِنْ بَينِ بَني إسْرائِيلَ. أخَذْتُهُمْ بَدَلَ كُلِّ فاتِحِ رَحمٍ، أي بَدَلَ كُلِّ أبْكارِ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","فَأبْكارُ بَني إسْرائِيلَ، مِنَ النّاسِ وَمِنَ الحَيواناتِ، لِي. فِي اليَومِ الَّذِي ضَرَبْتُ فِيهِ كُلَّ الأبْكارِ فِي أرْضِ مِصرَ، أفرَزْتُ أبْكارَ إسْرائِيلَ لِيَكُونُوا لِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","لَكِنِّي سَآخُذُ اللّاوِيِّينَ بَدَلَ كُلِّ أبْكارِ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","وَسَأُعطِي اللّاوِيِّينَ كُلَّهُمْ لِهارُونَ وَأبْنائِهِ مِنْ بَينِ بَني إسْرائِيلَ لِيَقُومُوا بِخِدمَةِ بَني إسْرائِيلَ فِي خَيمَةِ الاجْتِماعِ، وَلِيُساعِدُوا فِي تَقْدِيمِ الذَّبائِحِ عَنْ بَني إسْرائِيلَ، لِئَلّا تأتِيَ كارِثَةٌ عَلَى بَني إسْرائِيلَ لاقتِرابِهِمْ كَثيراً مِنَ المَكانِ المُقَدَّسِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","فَفَعَلَ مُوسَى وَهارُونُ وَكُلُّ بَني إسْرائِيلَ هَذا الأمرَ. وَفَعَلَ بَنو إسْرائِيلَ لِلّاوِيِّينَ بِحَسَبِ ما أمَرَ اللهُ مُوسَى بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","فَطَهَّرَ اللّاوِيُّونَ أنفُسَهُمْ، وَغَسَلُوا ثِيابَهُمْ. وَقَدَّمَهُمْ هارُونُ تَقدِمَةً فِي حَضرَةِ اللهِ. وَكَفَّرَ عَنْ خَطاياهُمْ لِيُطَهِّرَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","وَبَعدَ ذَلِكَ، صارَ اللّاوِيُّونَ مُؤَهَّلِينَ لِلقِيامِ بِخِدمَتِهِمْ فِي خَيمَةِ الاجْتِماعِ تَحتَ إشرافِ هارُونَ وَأبْنائِهِ. عُمِلَ بِاللّاوِيِّينَ بِحَسَبِ ما أمَرَ اللهُ مُوسَى بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«هَذا ما فُرِضَ عَلَى اللّاوِيِّينَ: كُلُّ ذَكَرٍ يَبلُغُ خَمْساً وَعِشرِينَ سَنَةً أوْ أكثَرَ يَكُونُ مُؤَهَّلاً لِلخِدمَةِ فِي أعمالِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","لَكِنْ فِي سِنِّ الخَمسِينِ، يَنْبَغِي عَلَى كُلِّ لاوِيٍّ أنْ يَتَقاعَدَ مِنْ خِدمَةِ أعمالِ خَيمَةِ الاجْتِماعِ، وَيَتَوَقَّفَ عَنْ عَمَلِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","يُمكِنُهُ أنْ يُساعِدَ اللّاوِيِّينَ الآخَرِينَ فِي خَيمَةِ الاجْتِماعِ بِالحِراسَةِ. لَكِنَّهُ لا يَقُومَ بِالأعمالِ الثَّقِيلَةِ. هَكَذا تَتَعامَلُ مَعَ اللّاوِيِّينَ فِي خِدمَتِهِمْ فِي خَيمَةِ الاجْتِماعِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","وَتَكَلَّمَ اللهُ إلَى مُوسَى فِي بَرِّيَّةِ سِيناءَ فِي الشَّهرِ الأوَّلِ مِنَ السَّنَةِ الثّانِيَةِ بَعدَ أنْ تَرَكُوا أرْضَ مِصرَ، فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«لِيَحْتَفِلْ بَنُو إسْرائِيلَ بِعِيدِ الفِصحِ فِي مَوْعِدِهِ المُعَيَّنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","تَحتَفِلُون بِهِ فِي مَوعِدِهِ فِي اليَومِ الرّابِعَ عَشَرَ مِنَ الشَّهرِ بَعْدَ الغُرُوبِ وَقَبلَ حُلُولِ الظَلامِ. وَتُحَافِظُونَ عَلَى شَرائِعِهِ وَقَواعِدِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","فَطَلَبَ مُوسَى مِنَ الشَّعبِ أنْ يَحتَفِلُوا بِالفِصحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","فَاحْتَفَلُوا بِالفِصحِ فِي الرّابِعَ عَشَرَ مِنَ الشَّهرِ الأوَّلِ، بَعْدَ الغُرُوبِ وَقَبلَ حُلُولِ الظَلامِ، فِي بَرِّيَّةِ سِيناءَ. فَعَلَ بَنو إسْرائِيلَ هَذا بِحَسَبِ ما أمَرَ اللهُ مُوسَى بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","وَكانَ هُناكَ رِجالٌ غَيرُ طاهِرِينَ بِسَبَبِ لَمسِهِمْ لِجَسَدِ مَيِّتٍ، فَلَمْ يَكُونُوا قادِرِينَ عَلَى الاحتِفالِ بِالفِصحِ فِي ذَلِكَ اليَومِ. فَجاءوا إلَى مُوسَى وَهارُونَ فِي ذَلِكَ اليَومِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","وَقالُوا: «لَسْنا طاهِرِينَ بِسَبَبِ لَمْسِنا لِجَسَدٍ مَيِّتٍ، وَلا نَسْتَطيعُ أنْ نُقَدِّمَ للهِ التَّقدِمَةَ فِي مَوعِدِها مَعَ بَقِيَّةِ بَني إسْرائِيلَ؟ فَماذا نَفْعَلُ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","فَقالَ مُوسَى لَهُمْ: «انتَظِرُونِي. سَأسمَعُ ما سَيَأمُرُ اللهُ بِهِ بِشَأنِكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","فَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«قُلْ لِبَني إسْرائِيلَ: إنْ تَنَجَّسَ أحَدٌ مِنكُمْ أوْ مِنْ أولادِكُمْ بِسَبَبِ لَمسِ جَسَدٍ مَيِّتٍ، أوْ كانَ فِي رِحلَةٍ طَوِيلَةٍ، فَعَلَيهِ أنْ يُحتَفَلَ بِالفِصحِ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","يَنبَغِي أنْ يَحتَفِلُوا بِالفِصحِ فِي اليَومِ الرّابِعَ عَشَرَ مِنَ الشَّهرِ الثّانِي، بَعْدَ الغُرُوبِ وَقَبلَ حُلُولِ الظَلامِ. وَليَأكُلُوا حَمَلَ الفِصحِ مَعَ خُبزٍ غَيرِ مُخْتَمِرٍ وَأعشابٍ مُرَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","وَلا يَترُكُوا شَيئاً مِنهُ حَتَّى الصَّباحِ، وَلا يَكسِرُوا عَظْماً واحِداً مِنْ عِظامِهِ. يَنبَغِي أنْ يَحتَفِلُوا بِهِ بِحَسَبِ جَمِيعِ شَرائِعِ الفِصحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","وَأمّا الشَّخصُ الطّاهِرُ وَالَّذِي لَيسَ عَلَى سَفَرٍ، لَكِنَّهُ يَتَجاهَلُ الفِصحَ، فَيُقطَعُ مِنَ الشَّعبِ، لأنَّهُ لَمْ يُقَدِّمْ تَقدِمَةَ اللهِ فِي مَوعِدِها المُعَيَّنِ. وَهَكَذا يُعاقَبُ عَلَى خَطِيَّتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","«وَإنْ كانَ بَينَكُمْ غَرِيبٌ مُقِيْمٌ، وَيُرِيدُ أنْ يَحتَفِلَ بِفِصحِ اللهِ، فَلْيَحفَظْهُ بِحَسَبِ شَرائِعِ الفِصحِ وَقَواعِدِهِ. الشِّريعَةُ نُفسُها لِلغَرِيبِ وَالمُواطِنِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","وَفِي اليَومِ الَّذِي أُقيمَ بِهِ المَسْكَنُ المُقَدَّسُ، غَطَّتِ السَّحابَةُ المَسكَنَ وَخَيمَةَ العَهْدِ. وَفِي المَساءِ مَكَثَتِ السَّحابَةُ فَوقَ المَسْكَنِ، وَكانَتْ تَبدُو كَالنّارِ حَتَّى الصَّباحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","كانَ الأمرُ كَذَلِكَ دائِماً، فَكانَتِ السَّحابَةُ تُغَطِّي الخَيمَةَ المُقَدَّسَةَ فِي النَّهارِ، وَفِي اللَّيلِ كانَتِ السَّحابَةُ تَبدُو كَالنّارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","وَحِينَ كانَتِ السَّحابَةُ تَرتَفِعُ مِنْ فَوقِ الخَيمَةِ، كانَ بَنو إسْرائِيلَ يِرْتَحِلُونَ. وَحَيثُما كانَتِ الخَيمَةُ تَستَقِرُّ، كانَ بَنو إسْرائِيلَ يُخَيِّمونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","فَكانَ بنُو إسْرائيلَ يِرْتَحِلُونَ بِعَلامَةٍ مِنَ اللهِ، وَيُخَيِّمُونَ بِعَلامَةٍ مِنَ اللهِ. كانُوا يَمْكُثُونَ فِي المُخَيَّمِ مَا مَكَثَتِ السَّحابَةُ فَوقَ المَسْكَنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","فَإذا طالَ بَقاءُ السَّحابَةِ فَوقَ المَسْكَنِ لِعِدَّةِ أيَّامٍ، كانَ بَنو إسْرائِيلَ يَحفَظُونَ أمرَ اللهِ، فَلَمْ يَكُونُوا يِرْتَحِلُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","وَكَذَلِكَ الامْرُ إذا بَقِيَتِ السَّحابَةُ فَوقَ المَسْكَنِ لِبِضْعَةِ أيَّامٍ. فَكانُوا يُخَيِّمُونَ بِعَلامَةٍ مِنَ اللهِ، وَيِرْتَحِلُونَ بِعَلامَةٍ مِنَ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","وَحَتَّى حِينَ كانَتِ السَّحابَةُ تَبقَى فَوقَ الخَيمَةِ المُقَدَّسَةِ مِنَ المَساءِ وَحَتَّى الصَّباحِ فَقَطْ، ثُمَّ تَرتَفِعُ فِي الصَّباحِ، كانُوا يِرْتَحِلُونَ. فَسَواءٌ أكانَ الوَقْتُ نَهاراً أمْ لَيلاً، كانُوا يِرْتَحِلُونَ حِينَ تَرتَفِعُ السَّحابَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","وَإنْ مكَثَتِ السَّحابَةُ فَوقَ المَسْكَنِ لأيّامٍ كَثِيرَةٍ، كانَ بَنو إسْرائِيلَ يَمكُثُونَ فَلا يِرْتَحِلُونَ. لَكِنْ حِينَ كانَتْ تَرتَفِعُ، كانُوا يِرْتَحِلُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","فَكانُوا يُخَيِّمُونَ بِعَلامَةٍ مِنَ اللهِ، وَيِرْتَحِلُونَ بِعَلامَةٍ مِنَ اللهِ. كانوا يَحفَظُونَ أمرَ اللهِ الّذِي سَمِعُوهُ مِنْ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«اصنَعْ لِنَفسِكَ بُوقَينِ مِنْ فِضَّةٍ مَطرُوقَةٍ. استَخدِمْهُما لِتَدعُو الشَّعبَ لِلاجتِماعِ، وَتُعلِنْ لِلمُخَيَّماتِ مَواعيدَ الرَّحيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","فَحِينَ يُنْفَخُ فيهِما مَعاً، يَجتَمِعُ الشَّعبُ أمامَكَ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","فإنْ نُفِخَ فِي أحَدِ البُوقَينِ، يَجتَمِعُ رُؤَساءُ قَبائِلِ إسرائيلَ أمامَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","«وَحِينَ تُنْفَخُ نَفخاتٌ قَصِيرَةٌ، يَكُونُ عَلَى المُخَيَّماتِ فِي الشَّرقِ أنْ تَرتَحِلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","وَحِينَ تُنْفَخُ النَّفخاتُ القَصِيرَةُ ثانِيَةً، يَكُونُ عَلَى المُخَيَّماتِ فِي الجَنُوبِ أنْ تَرتَحِلَ. تُنْفَخُ نَفخاتٌ قَصِيرَةٌ لِيَنطَلِقَ الشَّعبُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","وَحِينَ تُرِيدُ أنْ تَجمَعَ الشَّعبَ، تُنْفَخُ نَفخاتٌ طَوِيلَةٌ ثابِتَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","وَفَقَطْ أبناءُ هارُونَ، الكَهَنَةُ، هُمْ يَنْفُخُونَ فِي الأبواقِ. هَذِهِ فَريضَةٌ لَكُمْ إلَى الأبَدِ فِي كُلِّ أجيالِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","وَحِينَ تَذهَبُونَ لِتُحارِبُوا أعداءَكُمُ الَّذِينَ يُضايِقُونَكُمْ فِي أرْضِكُمْ، انْفُخُوا فِي الأبواقِ، فيَلتَفِتُ إلَيكُمْ إلَهُكُمْ، وَيُنقِذُكُمْ مِنْ أعدائِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","وَفِي أوقاتِ احْتِفالاتِكُمِ وَأعيادِكُمْ وَبِداياتِ شُهُورِكُمْ، تَنفُخُونَ فِي الأبواقِ حِينَ تُقَدِّمُونَ الذَّبائِحَ الصَّاعِدَةَ وَذَبائِحِ السَّلامِ، فَألتَفِتَ إلَيكُمْ. أنا إلَهُكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","فِي اليَومِ العِشرِينَ مِنَ الشَّهرِ الثّانِي فِي السَّنَةِ الثّانِيَةِ، ارتَفَعَتِ السَّحابَةُ مِنْ فَوقِ مَسْكَنِ العَهْدِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","فَبَدَأ بَنو إسْرائِيلَ رِحلاتِهِمْ مِنْ بَرِّيَّةِ سِيناءَ، حَتَّى استَقَرَّتِ السَّحابَةُ فِي بَرِّيَّةِ فارانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","فارتَحَلُوا لِلمَّرَّةِ الأُولَى بِحَسَبِ العَلامَةِ الَّتِي أعطاها اللهُ لِمُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","فارتَحَلَ مُخَيَّمُ قَبِيلَةِ يَهُوذا أوَّلاً بِحَسَبِ مَجمُوعاتِهِمْ. وَكانَ نَحشُونُ بْنُ عَمِّينادابَ رَئِيساً لِمَجمُوعَةِ يَهُوذا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","وَكانَ نَثَنائِيلُ بْنُ صُوغَرَ، رَئِيساً لِمَجمُوعَةِ يَسّاكَرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","وَكانَ ألِيآبُ بْنُ حِيلُونَ رَئِيساً لِمَجمُوعَةِ زَبُولُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ثُمَّ فُكِّكَ المَسْكَنُ، وَارتَحَلَ الجَرشُونِيُّونَ وَالمَرارِيُّونَ الَّذِينَ حَملُوا المَسْكَنَ بَعدَ قَبِيلَةِ يَهُوذا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ثُمَّ ارْتَحَلَ قِسمُ مُخَيَّمِ قَبِيلَةِ رَأُوبَيْنَ بِحَسَبِ مَجمُوعاتِهِمْ. وَكانَ ألِيصُورُ بْنُ شَدَيئُورَ رَئِيساً لِمَجمُوعَةِ رَأُوبَيْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","وَكانَ شَلُومِيئِيلُ بْنُ صُورِيَشَدّايَ رَئِيساً لِمَجمُوعَةِ قَبِيلَةِ شِمْعُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","وَكانَ ألِياسافُ بْنُ دَعُوئِيلَ رَئِيساً لِمَجمُوعَةِ جادَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ثُمَّ ارْتَحَلَ القَهاتِيُّونَ الَّذِينَ كانُوا يَحمِلُونَ الأشياءَ المُقَدَّسَةَ. وَأُقيمَ المَسْكَنُ قَبلَ وُصُولِ القَهاتِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ثُمَّ ارْتَحَلَ مُخَيَّمُ قَبِيلَةِ أفْرايِمَ بِحَسَبِ مَجمُوعاتِهِمْ. وَكانَ ألِيشَمَعُ بْنُ عَمِّيهُودَ رَئِيساً لِمَجمُوعَةِ أفْرايِمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","وَكانَ جَملِيئِيلُ بْنِ فَدَهْصُورَ رَئِيساً لِمَجمُوعَةِ مَنَسَّى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","وَكانَ أبِيدَنُ بْنُ جِدْعُونِي رَئِيساً لِمَجمُوعَةِ بَنْيامِيْنَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ثُمَّ ارْتَحَلَ قِسمُ مُخَيَّمِ قَبِيلَةِ دانَ، مُؤَخَّرَةُ جَمِيعِ المُخَيَّماتِ. وَكانَ أخِيعَزَرُ بْنِ عَمِّيشَدّايَ رَئِيساً لِمَجمُوعَةِ دانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","وَكانَ فَجعِيئِيلُ بْنُ عُكْرَنَ رَئِيساً لِمَجمُوعَةِ أشِيرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","وَكانَ أخِيرَعُ بْنُ عِينَنَ، رَئِيساً لِمَجمُوعَةِ نَفتالِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","هَذا هُوَ تَرتِيبُ بَني إسْرائِيلَ بِحَسَبِ مَجمُوعاتِهِمْ حِينَ كانُوا يَرتَحِلُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","وَقالَ مُوسَى لِحُوبابَ بْنِ رَعُوئِيلَ المِديانِيِّ، حَمِي مُوسَى: «إنَّنا مُرتَحِلُونَ إلَى المَكانِ الَّذِي وَعَدَ اللهُ بِإعطائِهِ لَنا. تَعالَ مَعَنا، وَسَنُكْرِمُكَ، لأنَّ اللهَ وَعَدَ بِالخَيْرِ لِبَني إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","لَكِنَّ حُوبابَ قالَ لِمُوسَى: «لَنْ أذهَبَ مَعَكُمْ، لَكِنِّي سَأذهَبُ إلَى أرْضِي وَعَشِيرَتِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","فَقالَ لَهُ مُوسَى: «لا تَترُكْنا، فَأنتَ تَعرِفُ أينَ يُمكِنُنا أنْ نُخَيِّمَ فِي الصَّحراءِ. سَتَكُونُ مُرشِداً لَنا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","إنْ جِئتَ مَعَنا، فَإنَّهُ مَهما عَمِلَ اللهُ مِنْ أُمُورٍ صالِحَةٍ، فَإنَّنا سَنَعمَلُ الأُمُورَ ذاتَها لَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","فارتَحَلُوا مِنْ جَبَلِ اللهِ وَسافَرُوا لِمُدَّةِ ثَلاثَةِ أيّامٍ. وَسارَ الكَهَنَةُ بِصُندُوقِ عَهدِ اللهِ المُقَدَّسِ أمامَهُمْ عَلَى مَسافَةِ ثَلاثَةِ أيّامٍ مِنَ السَّفَرِ، لِيَجِدُوا لَهُمْ مَكاناً لِيُخَيِّمُوا فِيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","وَكانَتْ سَحابَةُ اللهِ فَوقَهُمْ طِيلَةَ اليَومِ حِينَ كانُوا يَرتَحِلُونَ مِنْ مَكانِ تَخْييمِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","حِينَ كانَ الصُّندُوقُ المُقَدَّسُ يَرتَحِلُ كانَ مُوسَى يَقُولُ: «قُمْ يا اللهُ، وَلْيَتَبَدَّدْ أعداؤُكَ، وَلْيَهرُبْ كارِهُوكَ مِنْكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","وَحِينَ كانَ الصُّندُوقُ يَنزِلُ، كانَ مُوسَى يَقُولُ: «عُدْ يا اللهُ إلَى عَشَراتِ أُلُوفِ قَبائِلِ إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","وَحِينَ بَدَأ الشَّعبُ يَتَذَمَّرُونَ بِشِدَّةٍ أمامَ اللهِ، سَمِعَ اللهُ تَذَمُّرَهُمْ وَغَضِبَ جِدّاً. فَخَرَجَتْ نارٌ مِنَ اللهِ عَلَيهِمْ وَالتَهَمَتْ بَعضَ الخِيَمِ فِي أطرافِ المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","فَصَرَخَ الشَّعبُ إلَى مُوسَى طالِبِينَ العَونَ، فَصَلَّى مُوسَى إلَى اللهِ، فَخَمَدَتِ النّارُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","وَلِذا دَعُوا ذَلِكَ المَكانَ تَبْعِيرَةَ، لأنَّ ناراً مَنْ عِندِ اللهِ خَرَجَتْ عَلَيهِمْ هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","وَاشتَهَى الغُرَباءُ الَّذِينَ خَرَجوا مِنْ مِصْرَ مَعَ بَني إسْرائِيلَ طَعاماً أفضَلَ. وَبَكَى بَنو إسْرائِيلَ ثانِيَةً وَقالُوا: «مَنْ يُعطِينا لَحماً لِنَأكُلَ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","نَحْنُ نَتَحَسَّرُ عَلَى السَّمَكِ الَّذِي كُنّا نَأكُلُهُ فِي مِصرَ مَجّاناً. وَكَذَلِكَ عَلَى الخِيارِ وَالبَطِّيخِ وَالكُرّاثِ وَالبَصَلِ وَالثَّومِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","أمّا الآنَ فَقَدْ فَقَدْنا شَهِيَّتَنا، فَلَيسَ هُناكَ سِوَى هَذا المَنِّ لِنَنظُرَ إلَيهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","كانَ المَنُّ كَبُذُورِ الكُزبَرَةِ، وَلَونُهُ كَالصَّمغِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","فَانتَشَرَ النّاسُ وَجَمَعُوا المَنَّ. فَكانُوا يَطحَنُونَهُ بَحَجَرَيِّ الرَّحَى أوْ يَدُقُّونَهُ فِي الهاوِنِ. ثُمَّ يَسلُقُونَهُ فِي قِدرٍ وَيَصنَعُونَ مِنهُ كَعْكاً، طَعمُهُ كَطَعمِ الكَعْكِ المَقلِيِّ بِالزَّيتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","فَحِينَ كانَ النَّدَى يَأتِي عَلَى أرْضِ المُخَيَّمِ فِي اللَّيلِ، كانَ المَنُّ يَنزِلُ مَعَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","فَسَمِعَ مُوسَى الشَّعبَ يَبكُونَ فِي عَشائِرِهِمْ، كُلُّ واحِدٍ عَلَى مَدْخَلِ خَيمَتِهِ. فَغَضِبَ اللهُ جِدّاً، وَتَضايَقَ مُوسَى مِنْ كُلِّ هَذا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","وَقالَ مُوسَى للهِ: «لِماذا سَبَّبْتَ لِيَ الضِّيقَ وَأنا خادِمُكَ؟ لِماذا لَمْ أحظَ بِرِضاكَ؟ لِماذا جَعَلْتَ مَسؤُولِيَّةَ هَذا الشَّعبِ وَحِملَهُ عَلَى أكتافِي؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","هَلْ حَبِلْتُ بِكُلِّ هَذا الشَّعبِ؟ هَلْ وَلَدْتُهُمْ حَتَّى تَقُولُ لِي: ‹احْمِلْهُمْ فِي حِضْنِكَ كَالمُرَبِّيَةِ الَّتِي تَحمِلُ طِفلاً، إلَى الأرْضِ الَّتِي وَعَدْتُ بِأنْ أُعطِيَها لآبائِهِمْ؟› ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","مِنْ أيْنَ لِي لَحْمٌ لأُعْطِيَ كُلَّ هَذا الشَّعبِ حِينَ يَبكُونَ أمامِي وَيَقُولُونَ: ‹أعطِنا لَحْماً لِنَأكُلَ؟› ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","لا أستَطِيعُ أنْ أهتَمَّ بِكُلِّ هَذا الشَّعبِ وَحدِي، لأنَّهُ أكثَرُ مِمّا أستَطِيعُ قِيادَتَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","فَإنْ كُنتَ سَتُعامِلُنِي هَكَذا، فَأسألُكَ أنْ تَقتُلَنِي، إنْ حَظِيتُ بِرِضاكَ، وَلا تَدَعْنِي أرَى بَلِيَّتِي وَبُؤْسِي أكثَرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","فَقَالَ اللهُ لِمُوسَى: «اجْمَعْ لِي سَبعِينَ مِنْ شُيُوخِ إسْرائِيلَ تَعرِفُ أنَّهُمْ شُيُوخٌ وَقادةٌ لِلشَّعبِ. أحضِرْهُمْ إلَى خَيمَةِ الاجْتِماعِ وَأوقِفْهُمْ هُناكَ مَعَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","فَسَأنزِلُ وَأتَكَلَّمُ مَعَكَ هُناكَ. سَآخُذُ مِنَ الرُّوحِ الَّذِي عَلَيكَ وَأضَعُ عَلَيهِمْ، فَيُساعِدُونَكَ فِي الاهتِمامِ بِالشَّعْبِ حَتَّى لا تَهتَمَّ بِهِمْ وَتَحْمِلَ مَسْؤُولِيَّتِهِم وَحدَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","«وَقُلْ لِلشَّعبِ: قَدِّسُوا أنفُسَكُمْ لأجلِ الغَدِ، وَسَتَأكُلُونَ لَحماً، لأنَّكُمْ بَكَيتُمْ أمامَ اللهِ وَقُلْتُمْ: ‹مَنْ يُعطِينا لَحماً لِنَأكُلَ؟ كانَ الوَضعُ فِي مِصرَ أفضَلَ.› سَيُعطِيكُمُ اللهُ لَحماً فَتَأكُلُونَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","وَلَنْ تَأكُلُوا مِنهُ لِيَومٍ أوِ يَومينِ أوْ خَمسَةِ أيّامٍ أوْ عَشْرَةٍ أوْ عِشرِينَ يَوماً، ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","لَكِنَّكُمْ سَتَأكُلُونَ لَحماً لِشَهرٍ كامِلٍ إلَى أنْ يَخْرُجَ مِنْ مَناخِرِكُمْ فَتَقْرَفونَهُ! لأنَّكُمْ رَفَضْتُمْ اللهَ السّاكِنَ فِي وَسَطِكُمْ، وَبَكَيتُمْ أمامَهُ وَقُلْتُمْ: ‹لِماذا خَرَجْنا مِنْ مِصرَ؟›» ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ثُمَّ قالَ مُوسَى للهِ: «مَعِي سِتُّ مِئَةِ ألفِ رَجُلٍ، وَمَعَ هَذا فَأنتَ تَقُولُ: ‹سَأُعطِيهِمْ لَحماً، وَسَيَأكُلُونَ مِنهُ لِمُدَّةِ شَهرٍ كامِلٍ.› ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","إنْ ذُبِحَتِ الأغنامُ وَالأبقارُ، فَهَلْ سَيَكُونُ ذَلِكَ كافِياً لَهُمْ؟ وَحَتَّى لَوْ اصْطَدْنا كُلَّ سَمَكِ البَحْرِ فَلَنْ يَكْفِيهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","فَقالَ اللهُ لِمُوسَى: «هَلْ قُدرَةُ اللهِ مَحْدُودَةٌ؟ سَتَرَى الآنَ إنْ كانَ ما قُلْتُهُ سَيَتِمُّ أمْ لا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","فَخَرَجَ مُوسَى وَأخبَرَ الشَّعبَ بِما قالَهُ اللهُ، وَجَمَعَ السَّبعِينَ رَجُلاً مِنْ شُيُوخِ إسْرائِيلَ وَجَعَلَهُمْ يَقِفُونَ حَولَ الخَيمَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ثُمَّ نَزَلَ اللهُ فِي السَّحابَةِ وَتَكَلَّمَ إلَى مُوسَى. وَأخَذَ اللهُ مِنَ الرُّوحِ الَّذِي كانَ عَلَى مُوسَى وَوَضَعَهُ عَلَى السَّبعِينَ شَيخاً. وَحِينَ حَلَّ الرُّوحُ عَلَيهِمْ بَدَأُوا يِتَنَبَّأُونَ، لَكِنَّهُمْ لَمْ يَتَنَبَّأُوا مَرَّةً ثانِيَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","وَكانَ اثْنانِ مِنَ الرِّجالِ قَدْ بَقِيا فِي المُخَيَّمِ، وَكانَ اسْمُ أحَدِهِما ألْدادَ وَاسْمُ الثّانِي مِيدادَ. وَحَلَّ الرُّوحُ عَلَيهِما. وَكانا مِنْ ضِمنِ المُسَجَّلِينَ، وَلَكِنَّهُما لَمْ يَخرُجا إلَى خَيمَةِ الاجْتِماعِ، وَلِذا كانا يَتَنَبَّآنِ فِي المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","فَرَكَضَ شابٌّ وَقالَ لِمُوسَى: «ألْدادُ وَمِيدادُ يَتَنَبَّآنِ فِي المُخَيَّمِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","فَقالَ يَشُوعُ بْنُ نُونَ مُساعِدُ مُوسَى مُنذُ شَبابِهِ: «يا سَيِّدِي مُوسَى، أوقِفْهُما.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","فَقالَ مُوسَى لَهُ: «أتَغارُ عَلَيَّ؟ إنَّنِي أتَمَنَّى لَو أنَّ كُلَّ شَعبِ اللهِ كانُوا أنبِياءَ، إذْ يَضَعُ اللهُ رُوحَهُ عَلَيهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ثُمَّ رَجِعَ مُوسَى وَالشُّيُوخُ إلَى المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","وَهَبَّتْ رِيحٌ مِنْ عِنْدِ اللهِ، فَساقَتْ طُيُورَ السَّلوَى مِنَ البَحرِ، وَنَشَرَتْها حَولَ المُخَيَّمِ. كانَتِ الطُّيُورُ عَلَى بُعْدِ مَسِيرِ يَومٍ مِنْ جَمِيعِ جِهاتِ المُخَيَّمِ، وَعَلَى ارْتِفاعِ ذِرَاعَينِ! ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","فَقامَ النَّاسُ وَجَمَعُوا مِنَ السَّلوَى طِيلَةَ ذَلِكَ اليَومِ وَتِلكَ اللَّيلَةِ وَاليَومِ التّالِي. وَأقَلُّ كَمِّيَّةٍ جَمَعَها فَرْدٌ واحِدٌ، كَانَتْ نَحْوَ عَشْرَةِ أكياسٍ كَبِيرَةٍ! وَنَشَرُوا السَّلوَى حَولَ المُخَيَّم. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","وَبَينَما كانَ اللَّحمُ ما يَزالُ بَينَ أسنانِهِمْ، وَقَبلَ أنْ يُلتَهَمَ، اشْتَدَّ غَضَبُ اللهِ عَلَى الشَّعبِ، وَأرسَلَ اللهُ مَرَضاً فَظِيعاً عَلَى الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","وَلِذا دَعَوا ذَلِكَ المَكانَ قَبَرُوتَ هَتَّأوَةَ، لأنَّهُمْ هُناكَ دَفَنُوا ذَوِي الشَّهوَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","وَمِنْ قَبَرُوتَ هَتَّأوَةَ ارْتَحَلَ الشَّعبُ إلَى حَضَيرُوتَ وَمَكَثُوا فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","وَتَكَلَّمَتْ مَريَمُ وَهارُونُ عَلَى مُوسَى بِسَبَبِ المَرأةِ الكُوشِيَّةِ الَّتِي كانَ تَزَوَّجَها، لأنَّهُ كانَ قَدْ تَزَوَّجَ امْرأةً كُوشِيَّةً، ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","فَقالا: «هَلْ تَكَلَّمَ اللهُ مِنْ خِلالِ مُوسَى فَقَطْ؟ ألَمْ يَتَكَلَّمْ مِنْ خِلالِنا أيضاً؟» فَسَمِعَ اللهُ هَذا الكَلامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","أمّا مُوسَى فَقَدْ كانَ مُتَواضِعاً جِدّاً أكثَرَ مِنْ كُلِّ النّاسِ عَلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","وَفَوراً، قالَ اللهُ لِمُوسَى وَهارُونَ وَمَريَمَ: «اخرُجُوا ثَلاثَتُكُمْ إلَى خَيمَةِ الاجْتِماعِ.» فَخَرَجَ ثَلاثَتُهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ثُمَّ نَزَلَ اللهُ فِي عَمُودِ سَحابٍ وَوَقَفَ فِي مَدخَلِ الخَيمَةِ، وَدَعا هارُونَ وَمَريَمَ، فَخَرَجَ كِلاهُما. ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","فَقالَ اللهُ: «اسْمَعا كَلامِيَ: حِينَ يَكُونُ هُناكَ نَبِيٌّ بَينَكُمْ فَإنَّنِي، أنا اللهَ، أُعلِنُ عَنْ نَفسِي لَهُ بِرُؤْيا، وَقَدْ أتَكَلَّمُ مَعَهُ فِي حُلْمٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","لَكِنِّي لا أتَعامَلُ هَكَذا مَعَ خادِمِي مُوسَى، فَأنا أثِقُ بِمُوسَى فِي كُلِّ شُؤُونِ بَيتِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","أتَكَلَّمُ إلَيهِ مُباشَرَةً وَبِوُضُوحٍ وَلَيسَ بِألغازٍ، وَهُوَ يَرَى شَكلَ اللهِ. كَيفَ لَمْ تَخافا مِنَ الإساءَةِ لِخادِمِي مُوسَى؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","وَاشتَعَلَ غَضَبُ اللهِ عَلَيهِما وَتَرَكَهُما. ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","وَحِينَ ارتَفَعَتِ السَّحابَةُ مِنَ الخَيمَةِ، كانَ جِلْدُ مَريَمَ أبْيَضَ كَالثَّلجِ. فَرآها هارُونُ وَعَرَفَ أنَّها بَرْصاءُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","فَقالَ هارُونُ لِمُوسَى: «يا سَيِّدِي، لا تُعاقِبْنا، فَقَدْ تَصَرَّفْنا بِحَماقَةٍ وَأخطَأْنا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","فَلا تَتْرُكْها حَتَّى يَنْسَلِخَ جِلْدُها كَطِفلٍ وُلِدَ مَيِّتاً نِصْفَ مُشَوَّهٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","فَصَرَخَ مُوسَى إلَى اللهِ: «يا اللهُ، اشْفِها.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","فَقالَ اللهُ لِمُوسَى: «لَو بَصَقَ أبوها فِي وَجهِها، أفَما كانَتْ سَتَبقَى مَخزِيَّةً لِسَبعَةِ أيّامٍ. فَلْتُطْرَدْ خارِجَ المُخَيَّمِ لِسَبعَةِ أيّامٍ، وَبَعدَ ذَلِكَ تَعُودُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","فَوَضَعُوا مَريَمَ خارِجَ المُخَيَّمِ لِسَبعَةِ أيّامٍ. وَلَمْ يَرتَحِلِ الشَّعبُ حَتَّى عادَتْ مَريَمُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","وَبَعدَ ذَلِكَ ارْتَحَلَ الشَّعبُ مِنْ حَضَيرُوتَ وَخَيَّمُوا فِي بَرِّيَّةِ فارانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«أرسِلْ رِجالاً لِيَستَكشِفُوا أرْضَ كَنعانَ الَّتِي سَأُعطِيها لِبَني إسْرائِيلَ. أرسِلُوا رَجُلاً مِنْ كُلِّ عَشِيرَةٍ بِحَيثُ يَكُونُ مِنْ قادَةِ قَبِيلَتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","فَأرسَلَهُمْ مُوسَى مِنْ بَرِّيَّةِ فارانَ بِحَسَبِ أمرِ اللهِ. وَكانَ هَؤُلاءِ الرِّجالُ مِنْ قادَةِ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","وَهَذِهِ هِيَ أسماؤُهُمْ: مِنْ قَبِيلَةِ رَأُوبَيْنَ شَمُّوعُ بْنُ زَكُّورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","وَمِنْ قَبِيلَةِ شِمْعُونَ شافاطُ بْنُ حُورِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","وَمِنْ قَبِيلَةِ يَهُوذا كالِبُ بْنُ يَفُنَّةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","وَمِنْ قَبِيلَةِ يسّاكِرَ يَجْآلُ بنُ يُوسُفَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","وَمِنْ قَبِيلَةِ أفْرايِمَ هُوشَعُ بْنُ نُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","وَمِنْ قَبِيلَةِ بَنْيامِيْنَ فَلْطِي بْنُ رافُو. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","وَمِنْ قَبِيلَةِ زَبُولُونَ جَدِّيئِيلُ بْنُ سُودِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","وَمِنْ عَشِيرَةِ يُوسُفَ، أي قَبِيلَةِ مَنَسَّى جِدِّي بْنُ سُوسِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","وَمِنْ قَبِيلَةِ دانَ عَمِّيئِيلُ بْنُ جَمَلِّي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","وَمِنْ قَبِيلَةِ أشِيرَ سَتُورُ بْنُ مِيخائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","وَمِنْ قَبِيلَةِ نَفْتالِي نَحْبِي بْنُ وَفْسِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","وَمِنْ قَبِيلَةِ جادَ جَأُوئِيلُ بْنُ ماكي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","هَذِهِ هِيَ أسْماءُ الرِّجالِ الَّذِينَ أرسَلَهُمْ مُوسَى لِيَتَجَسَّسُوا الأرْضَ وَيَستَكشِفُوها. أمَّا هُوشَعُ بْنُ نُونَ فَدَعاهُ مُوسَى يَشُوعَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","وَحِينَ أرسَلَهُمْ مُوسَى لاستِكشافِ أرْضِ كَنعانَ، قالَ لَهُمْ: «اصْعَدُوا إلَى النَّقَبِ ثُمَّ إلَى مِنْطَقَةِ التِّلالِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","تَفَحَّصُوا طَبِيعَةَ الأرْضِ، وَالسّاكِنِينَ فِيها. أهُمْ أقوِياءُ أمْ ضُعَفاءُ، قَلِيلونَ أمْ كَثِيرُونَ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","تَفَحَّصُوا طَبِيعَةَ الأرْضِ الَّتِي يَعِيشُونَ فِيها، إنْ كانَتْ حَسَنَةً أمْ رَدِيئَةً، وَهَلْ هِيَ مُخَيَّماتٌ مَفتُوحَةٌ أمْ حُصُونٌ تُحِيطُها أسوارٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","وَافْحَصُوا الأرْضَ إنْ كانَتْ خَصِبَةً أمْ فَقِيرَةً. وَإنْ كانَ هُناكَ أشجارٌ أوْ لا. وَاحْرِصُوا أنْ تُحضِرُوا مِنْ ثَمَرِ الأرْضِ.» فَقَدْ كانَ ذَلِكَ الوَقتُ بِدايَةَ مَوسِمِ العِنَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","فَذَهَبُوا وَاستَكشَفُوا الأرْضَ مِنْ بَرِّيَّةِ صِينَ إلَى رَحُوبَ قُربَ مَدخَلِ حَماةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","فَذَهَبُوا إلَى النَّقَبِ، وَأتَوْا إلَى حَبْرُونَ. وَكانَتْ قَبائِلُ أخِيمانَ وَشِيشايَ وَتَلْمايَ تَسكُنُ هُناكَ – وَهُمْ مِنْ نَسلِ عَناقَ. وَكانَتْ مَدِينَةُ حَبرُونَ قَدْ بُنِيَتْ قَبلَ مَدِينَةِ صُوعَنَ فِي مِصرَ بِسَبعِ سَنَواتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ثُمَّ أتَوا إلَى وادِي أشكُولَ. وَمِنْ هُناكَ قَطَعُوا غُصناً فِيهِ عُنقُودُ عِنَبٍ واحِدٍ، حَمَلَهُ رَجُلانِ بِعَصاً فِيما بَينَهما! كَما حَمَلُوا مَعَهُمْ بَعضَ العِنَبِ وَالتِّينِ أيضاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","وَدُعِيَ ذَلِكَ المُكانُ بِوادِي أشكُولَ بِسَبَبِ العُنقُودِ الَّذِي قَطَعَهُ بَنو إسْرائِيلَ مِنْ هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","وَرَجِعَ الرِّجالُ مِنِ استِكشافِ الأرْضِ بَعدَ أربَعِينَ يَوماً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","وَأتَوا إلَى مُوسَى وَهارُونَ وَكُلِّ بَني إسْرائِيلَ فِي بَرِّيَّةِ فارانَ فِي قادِشَ. وَقَدَّمُوا لَهُما وَلِكُلِّ الشَّعبِ تَقرِيراً عَمّا رَأُوهُ، وَأرُوهُمْ ثَمَرَ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","فَقالُوا لِمُوسَى: «قَدْ ذَهَبْنا إلَى الأرْضِ الَّتِي أرسَلْتَنا إلَيها. هِيَ حَقّاً أرْضٌ تَفيِضُ لَبَناً وَعَسَلاً. وَهَذا ثَمَرُها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","لَكِنَّ الشَّعبَ الَّذِي يَعِيشُ فِي الأرْضِ قَوِيٌّ، وَمُدُنُهُمْ مُحَصَّنَةٌ وَضَخمَةٌ جِدّاً. كَما أنَّنا رَأينا مِنْ نَسلِ عَناقَ هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","وَالعَمالِقَةُ يَسكُنُونَ أرْضَ النَّقَبِ، وَالحِثِّيُّونَ وَاليَبُوسِيُّونَ وَالأمُّورِيُّونَ يَسكُنُونَ فِي التِّلالِ. وَيَسكُنُ الكَنعانِيُّونَ قُربَ البَحرِ وَعَلَى طُولِ نَهرِ الأردُنِّ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","حِينَئِذٍ، أسْكَتَ كالِبُ الشَّعبَ الَّذِيَ بِقُربِ مُوسَى، وَقالَ: «سَنَصعَدُ وَنَمتَلِكُ الأرْضَ، لأنَّنا قَادِرُونَ عَلَى أنْ نَغزُوَها وَنَمتَلِكَها.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","لَكِنَّ الرِّجالَ الَّذِينَ ذَهَبُوا مَعَهُ قالُوا: «لَسنا قادِرِينَ عَلَى أنْ نَهزِمَ ذَلِكَ الشَّعبَ لأنَّهُمْ أقوَى مِنّا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","وَهَكَذا ثَبَّطُوا بِكَلامِهِمْ هَذا عَزِيمَةَ بَني إسْرائِيلَ بِشأنِ الأرْضِ الَّتِي استَكشَفُوها. وَقالُوا: «الأرْضُ الَّتِي سافَرْنا عَبْرَها لاسْتِكشافِها هِيَ أرْضٌ تُدَمِّرُ الشَّعبَ الَّذِي يَعِيشُ فِيها. وَكُلُّ النّاسِ الَّذِينَ رَأيناهُمْ فِيها مِنَ العَمالِقَةِ! ");
INSERT INTO arbwbtc_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","وَقَدْ رَأينا هُناكَ الجَبابِرَةَ – جاءَ نَسلُ عَناقَ مِنَ الجَبابِرَةِ – فَشَعَرْنا وَكَأنَّنا جَرادٌ أمامَهُمْ! وَهَكَذا كُنّا بِالفِعلِ فِي نَظَرِهِمْ!» ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","فَأخَذَ الشَّعبُ يَصرُخُونَ وَيَبكُونَ طِيلَةَ تِلكَ اللَّيلَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","وَتَذَمَّرَ كُلُّ بَني إسْرائِيلَ عَلَى مُوسَى وَهارُونَ. وَقالَ كُلُّ الشَّعبِ لَهُما: «لَيتَنا مُتنا فِي أرْضِ مِصرَ أوْ فِي هَذِهِ الصَّحْراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","لِماذا يُحضِرُنا اللهُ إلَى هَذِهِ الأرْضِ لِنَمُوتَ فِي الحَربِ وَتُؤخَذَ نِساؤُنا وَأطفالُنا كَغَنِيمَةٍ؟ ألَيسَ مِنَ الأفضَلِ لَنا أنْ نَعُودَ إلَى مِصرَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","وَقالَ بَعضُهُمْ لِبَعضٍ: «فَلْنَختَرْ رَئِيساً عَلَينا وَنَرجِعْ إلَى مِصرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","فَوَقَعَ مُوسَى وَهارُونُ إلَى الأرْضِ أمامَ كُلِّ جَماعَةِ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","وَيَشُوعُ بْنُ نُونَ وَكالِبُ بْنُ يَفُنَّةَ، اللَّذانِ كانا مِمَّنْ اسْتَكْشَفَوا الأرْضَ، مَزَّقا ثِيابَهُما حُزناً مِنْ مَوقِفِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","وَقالا لِجَمِيعِ بَني إسْرائِيلَ: «الأرْضُ الَّتِي جُلْنا فِيها لاستِكشافِها، أرْضٌ جَيِّدَةٌ جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","فَإنْ رَضِيَ اللهُ عَنّا، سَيُدْخِلُنا إلَى هَذِهِ الأرْضِ وَسَيُعطِيها لَنا. إنَّها أرْضٌ تَفِيضُ لَبَناً وَعَسَلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","فَلا تَتَمَرَّدُوا عَلَى اللهِ، وَلا تَخافُوا مِنْ شَعبِ الأرْضِ، لأنَّنا سَنَهزِمُهُمْ. قَدْ زالَ عَنهُمْ ما كانَ يَحمِيهِمْ. وَأمّا نَحنُ فَاللهُ مَعَنا، فَلا تَخافُوا مِنْهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","فَهَدَّدَ كُلُّ الشَّعبِ بِقَتلِهِما رَجماً بِالحِجارَةِ. حِينَئِذٍ، ظَهَرَ مَجدُ اللهِ فِي خَيمَةِ الاجْتِماعِ لِكُلِّ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","وَقالَ اللهُ لِمُوسَى: «إلَى مَتَى يُهينُنِي هَذا الشَّعبُ؟ إلَى مَتَى لا يَثِقُونَ بِي عَلَى الرُّغْمِ مِنْ كُلِّ العَجائِبِ الَّتِي عَمِلْتُها بَينَهُمْ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","سَأُرْسِلُ إلَيْهِمْ وَباءً فَظِيعاً وَأطْرُدُهُمْ مِنْ أرْضِهِمْ. وَسَأجعَلُكَ، يا مُوسَى، أُمَّةً أعظَمَ وَأقوَى مِنهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","فَقالَ مُوسَى للهِ: «حِينَئِذٍ، سَيَسمَعُ المِصرِيُّونَ بِهَذا، لأنَّكَ أخرَجْتَ هَذا الشَّعبَ مِنْ بَينِهِمْ بِقُوَّتِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","وَسَيُخبِرُونَ سُكّانَ هَذِهِ الأرْضِ. قَدْ سَمِعَ سُكّانُ هَذِهِ الأرْضِ بِأنَّكَ مَعَ هَذا الشَّعبِ يا اللهُ، وَبِأنَّكَ ظَهَرْتَ لِهَذا الشَّعبِ وَبِأنَّ سَحابَتَكَ تَقِفُ فَوقَهُمْ وَبِأنَّكَ تَسِيرُ أمامَهُمْ فِي عَمُودِ سَحابٍ فِي النَّهارِ وَفِي عَمُودِ نارٍ فِي اللَّيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","فَإنْ قَتَلْتَ هَذا الشَّعبَ كُلَّهُ فَإنَّ الأُمَمَ الَّتِي سَمِعَتْ عَنْكَ سَتَقُولُ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‹لَمْ يَستَطِعِ اللهُ أنْ يُدخِلَ هَذا الشَّعبَ إلَى الأرْضِ الَّتِي وَعَدَهُمْ بِها، فَقَتَلَهُمْ فِي الصَّحْراءِ.› ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","«لِذَلِكَ لِتَعظُمْ قُوَّةُ اللهِ كَما وَعَدْتَ وَقُلْتَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‹اللهُ بَطِيءُ الغَضَبِ، وَمَحَبَّتُهُ عَظِيمَةٌ. يَغْفِرُ الذَّنْبَ وَالمَعْصِيَةَ. لَكِنَّهُ لا يُلْغِي العُقُوبَةَ، بَلْ يَحْسِبُ خَطايا الآباءِ عَلَى أبْنائِهِمْ وَأحفادِهِمْ وَأحفادِ أبْنائِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","اغْفِرْ خَطِيَّةَ هَذا الشَّعبِ بِحَسَبِ مَحَبَّتِكَ العَظِيمَةِ، كَما غَفَرْتَ لَهُ مُنذُ خُرُوجِهِ مِنْ مِصرَ وَحَتَّى الآنَ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","فَقالَ اللهُ: «سَأغفِرُ لَهُمْ كَما طَلَبْتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","لَكِنِّي أُقسِمُ بِذاتِي، وَبِمَجدِي الَّذِي سَيَمْلَأُ الأرْضَ بِمَجدِ اللهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","إنَّ جَمِيعَ أولَئِكَ الَّذينَ رَأَوْا مَجدِي وَعَجائِبِي الَّتِي عَمِلْتُها فِي مِصرَ وَفِي الصَّحْراءِ، وجَرَّبُونِي عَشرَ مَرَّاتٍ، وَلَمْ يُطِيعُونِي، ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","لَنْ يَرَوا الأرْضَ الَّتِي وَعَدْتُ بِها آباءَهُمْ. جَمِيعُ الَّذِينَ أهانُونِي لَنْ يَدخُلُوا الأرْضَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","«أمّا خادِمِي كالِبَ فَرأى الأمْرَ بِرُوحٍ مُختَلِفَةٍ. وَقَدْ أطاعِنِي تَماماً. لِذَلِكَ سَأُدخِلُهُ إلَى الأرْضِ الَّتِي ذَهَبَ إلَيها، وَيَرِثُها نَسلُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","«هَا العَمالِقَةُ وَالكَنعانِيُّونَ يَسكُنُونَ الوادِي. فَاسْتَدِيرُوا فِي الغَدِ نَحوَ الصَّحْراءِ فِي الطَّرِيقِ إلَى البَحرِ الأحمَرِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","وَكَلَّمَ اللهُ مُوسَى وَهارُونَ فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«إلَى مَتَى سَيَستَمِرُّ هَذا الشَّعبُ الشِّرِّيرُ فِي التَّذَمُّرِ عَلَيَّ؟ لَقَدْ سَمِعْتُ تَذَمُّراتِ بَني إسْرائِيلَ الَّتِي يَتَذَمَّرُونَها عَلَيَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","قُلْ لَهُمْ: ‹أُقسِمُ بِذاتِي، يَقُولُ اللهُ، سَأعمَلُ لَكُمْ ما قُلْتُمُوهُ أمامِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","فَسَتَمُوتُونَ فِي هَذِهِ الصَّحْراءِ، أيْ جَمِيعُ الَّذِينَ تَمَّ إحصاؤُهُمْ، كُلُّ مَنْ كانَ فِي العِشرِينَ فَأكثَرَ، الَّذِينَ تَذَمَّرُوا عَلَيَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","فَلَنْ تَدخُلُوا الأرْضَ الَّتِي وَعَدْتُ بِأنْ تَسكُنُوا فِيها، بِاستِثناءِ كالِبَ بْنِ يَفُنَّةَ وَيَشُوعَ بْنَ نُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","وَأطفالُكُمُ الَّذِينَ قُلْتُمْ بِأنَّهُمْ سَيُؤخَذُونَ غَنِيمَةً، سَأُدخِلُهُمُ الأرْضَ. وَسَيَعرِفُونَ الأرْضَ الَّتِي رَفَضْتُمُوها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","أمّا أنتُمْ، فَسَتَمُوتُونَ فِي هَذِهِ الصَّحْراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","«‹سَيَكُونُ أبْناؤُكُمْ رُعاةً فِي الصَّحْراءِ لأرْبَعِينَ سَنَةً. سَيُعانُونَ بِسَبَبِ عَدَمِ أمانَتِكُمْ، إلَى أنْ تَسقُطَ جُثَثُكُمْ جَمِيعاً فِي الصَّحْراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","سَتُعاقَبُونَ عَلَى خَطاياكُمْ لأرْبَعِينَ سَنَةً، بِحَسَبِ عَدَدِ الأيّامِ الَّتِي استَكشَفْتُمْ فِيها الأرْضَ: أربَعِينَ يَوماً، سَنَةً مُقابِلَ يَومٍ. فَتَعرِفُونَ عَاقِبَةَ الابْتِعادِ عَنِّي.› ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","«أنا اللهَ تَكَلَّمْتُ، وَسَأفعَلُ ما تَكَلَّمْتُ بِهِ عَنْ هَذا الشَّعبِ الشِّرِّيرِ المُجتَمِعِ ضِدِّي. فَسَيَمُوتُونَ جَمِيعاً فِي الصَّحْراءِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","وَكانَ مُوسَى قَدْ أرسَلَ رِجالاً لِيَستَكشِفُوا الأرْضَ. فَجَعَلُوا كُلَّ الشَّعبِ يَتَذَمَّرُ عَلَى مُوسَى عِندما رَجِعُوا بأخبارٍ مُحبِطَةٍ عَنِ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","هَؤُلاءِ الرِّجالُ الَّذِينَ رَجِعُوا بأخبارٍ مُحبِطَةٍ عَنِ الأرْضِ، ماتُوا بِوَباءٍ أرسَلَهُ اللهُ عَلَيهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","فَقَطْ يَشُوعُ بْنُ نُونَ وَكالِبُ بْنُ يَفُنَّةَ بَقِيا حَيَّيْنِ مِنْ ضِمنِ الرِّجالِ الَّذِينَ ذَهَبُوا لِيَستَكشِفُوا الأرْضَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","وَحِينَ تَكَلَّمَ مُوسَى بِهَذِهِ الكَلِماتِ لِكُلِّ بَني إسْرائِيلَ ناحَ الشَّعبُ كَثِيراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","وَنَهَضُوا فِي الصَّباحِ باكِراً، وَبَدَأُوا سَيرَهُمْ نَحوَ أعلَى مِنْطَقَةٍ فِي مِنْطَقَةِ التِّلالِ. وَقالُوا: «ها نَحنُ ذاهِبُونَ إلَى المَكانِ الَّذِي وَعَدَ اللهُ بِإعطائِهِ لَنا، فَإنَّنا أخطَأْنا إذْ تَذَمَّرْنا عَلَيهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","حِينَئِذٍ، قالَ مُوسَى لَهُمْ: «لِماذا تَعصُونَ أمرَ اللهِ؟ لَنْ تَنجَحُوا فِي ما تَعمَلُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","لا تَصعَدُوا كَي لا يَهزِمَكُمْ أعداؤُكُمْ، لأنَّ اللهَ لَيسَ مَعَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","لأنَّ العَمالِقَةَ وَالكَنعانِيِّينَ سَيَكُونُونَ هُناكَ وَيُقاوِمُونَكُمْ، وَسَتُقتَلُونَ فِي المَعرَكَةِ، لأنَّكُمْ لَسْتُمْ تَتْبَعُونَ اللهَ، فاللهُ لَنْ يَكُونَ مَعَكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","لَكِنَّهُمْ صَعِدُوا بِعِنادٍ إلَى أعلَى مَوقِعٍ فِي مِنْطَقَةِ التِّلالِ. أمّا صُندُوقُ عَهدِ اللهِ وَمُوسَى فَبَقِيا وَسَطَ المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","فَنَزَلَ العَمالِقَةُ وَالكَنعانِيُّونَ الَّذِينَ كانُوا يَسكُنُونَ فِي تِلكَ التِّلالِ، وَهاجَمُوا بَنِي إسْرائِيلَ وَحَطَّمُوهُمْ طَوالَ الطَّرِيقِ حَتَّى حُرْمَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«قُلْ لِبَني إسْرائِيلَ: حِينَ تَدخُلُونَ الأرْضَ الَّتِي سَتَسكُنُونَ فِيها وَالَّتِي سَأُعطِيها لَكُمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","فَحِينَ تُقَدِّمُونَ تَقدِمَةً للهِ مِنَ البَقَرِ أوِ الغَنَمِ، ذَبيحَةً صَاعِدَةً أوْ ذَبِيحَةَ نَذْرٍ أوْ ذَبِيحَةً اختِيارِيَّةً، أوْ أيَّةَ ذَبيحَةٍ فِي أعيادِكُمِ المُنتَظَمَةِ، لِتَقدِيمِ رائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","«فَعَلَى مَنْ يُقَدِّمُ التَّقدِمَةَ للهِ أنْ يُقَدِّمَ مَعَها تَقدِمَةَ حُبُوبٍ، مِقدارَ عُشْرِ قُفَّةٍ مِنَ الطَّحِينِ الجَيِّدِ، مَمزُوجَةً بِرُبْعِ وِعاءٍ مِنْ زَيتِ الزَّيتُونِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","وَيُقَدِّمُ مَعَها سَكيباً مِقدارُهُ رُبْعُ وِعاءٍ مِنَ النَّبيذِ مَعَ الذَّبيحَةِ الصّاعِدَةِ أوِ غَيْرِها: رُبْعَ وِعاءٍ لِكُلِّ خَرُوفٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","«وَإذا كانَتِ التَّقدِمَةُ كَبْشاً، فَلْيُقَدِّمْ مَعَها تَقدِمَةَ حُبُوبٍ مِقدارَ عُشْرَي القُفَّةِ مِنَ الطَّحِينِ الجَيِّدِ، مَمزُوجَةً بِثُلُثِ وِعاءٍ مِنَ زَيتِ الزَّيتونِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","وَيُقَدِّمُ مَعَها سَكيباً مِقدارُهُ ثُلُثُ وِعاءٍ مِنَ النَّبيذِ، كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","«وَحِينُ يُقَدِّمُ ثَوراً صَغِيراً ذَبِيحَةً صاعِدَةً أوْ ذَبِيحَةً لِلوَفاءِ بِنَذرٍ أوْ ذَبِيحَةٍ اختِيارِيَّةٍ للهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","تُقَدِّمُ مَعَ الثَّورِ الصَّغِيرِ تَقدِمَةُ حُبُوبٍ مِقدارَ ثَلاثَةِ أعْشارِ قُفَّةٍ مِنَ الطَّحِينِ الجَيِّدِ، مَمزُوجَةٍ بِنِصفِ وِعاءٍ مِنْ زَيتِ الزَّيتونِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","وَيُقَدِّمُ مَعَها سَكيباً مِقدارُهُ نِصْفُ وِعاءٍ مِنَ النَّبيذِ، كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","يَنْبَغِي أنْ يُصَنَعُ هَذا لِكُلِّ ثَورٍ وَكَبْشٍ وَمَعزٍ وَتَيسٍ وَخَرُوفٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","فَمَهما كانَ عَدَدُ الذَّبائِحِ، تَصنَعُونَ هَذا لِكُلِّ واحِدَةٍ مِنها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","«عَلَى كُلِّ مُواطِنٍ أنْ يَعمَلَ هَذِهِ الأُمُورَ حِينَ يُقَدِّمُ للهِ تَقدِمَةً، كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","وَكَذَلِكَ الغَرِيبُ الَّذِي يُقِيمُ بَينَكُمْ، لِيُقَدِّمْ تَقدِمَةً بِالطَّرِيقَةِ نَفْسِها الَّتِي تُقَدِّمُونَها، كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","هَذِهِ شَرِيعَةٌ واحِدَةٌ، جيلاً بَعدَ جِيلٍ، لِلشَّعبِ وَلِلغَرِيبِ المُقِيمِ بَينَكُمْ. أنْتُمْ وَالغَرِيبُ مُتساوونَ فِي هَذا أمامَ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","فَلَكُمْ وَلِلغَرِيبِ شَرِيعَةٌ واحِدَةٌ وَنِظامٌ واحِدٌ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«قُلْ لِبَني إسْرائِيلَ: حِينَ أُدخِلُكُمْ إلَى الأرْضِ الَّتِي أقُودُكُمْ إلَيها، ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","وَحِينَ تَأكُلُونَ طَعاماً مِنَ الأرْضِ، يَنبَغِي أنْ تُقَدِّمُوا تَقدِمَةً للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","قَدِّمُوا رَغِيفاً مِنْ أوَّلِ عَجنَةٍ. تُقَدِّمُونَهُ كَما تُقَدِّمُونَ تَقدِمَةَ بَيدَرِ التَّذْرِيَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","تُقَدِّمُونَ مِنْ أوَّلِ عَجنَةٍ لَكُمْ تَقدِمَةً للهِ جِيلاً بَعْدَ جِيلٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«فَإنْ أخطَأتُمْ بِغَيرِ قَصدٍ، فَلَمْ تَعمَلُوا بِكُلِّ الأوامِرِ الَّتِي أعطاها اللهُ لِمُوسَى، ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","فَلَمْ تَلْتَزِمُوا بِكُلِّ ما أمَرَ اللهُ بِهِ مِنْ خِلالِ مُوسَى، مِنْ أوَّلِ يَومٍ بَدَأ اللهُ بِإعطائِهِ الوَصايا لَكُمْ وَلِكُلِّ أجيالِكُمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","وَإنِ ارتَكَبَ أحَدُكُمْ خَطِيَّةً، خِفْيَةً أوْ سَهْواً، يُقَدِّمُ جَمِيعُ الشَّعبِ ثَوراً واحِداً ذَبيْحَةً صَاعِدَةً، كَرائِحَةٍ يُسَرُّ بِها اللهُ، مَعَ تَقدِمَةِ الحُبُوبِ وَالسَّكِيبِ المُرافِقَةِ لَها بِحَسَبِ الشَّرِيعَةِ. ثُمَّ يُقَدِّمُونَ تَيساً واحِداً ذَبِيحَةَ خَطِيَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","«هَكَذا يُطَهِّرُ الكاهِنُ بَني إسْرائِيلَ كُلَّهُمْ كَي يُغفَرَ لَهُمْ. فَقَدْ كانَتِ الخَطِيَّةُ بِغَيرِ قَصدٍ، وَقَدْ قَدَّمُوا تَقدِماتِهِمْ للهِ، وَذَبِيحَةَ خَطِيَّتِهِمْ فِي حَضْرَةِ اللهِ عَنِ الخَطَإ الَّذِي ارتَكَبُوهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","وَسَيُغفَرُ لِكُلِّ بَني إسْرائِيلَ وَلِلغُرَباءِ السّاكِنِينَ بَينَهُمْ. لأنَّ الخَطَأ يَتَعَلَّقُ بِكُلِّ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«لَكِنْ إنْ أخطَأ شَخصٌ ما بِغَيرِ قَصدٍ، يُقَدِّمُ عَنزَةً عُمْرُها سَنَةٌ ذَبِيْحَةَ خَطِيَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","وَيُكَفِّرُ الكاهِنُ فِي حَضْرَةِ اللهِ عَنْ ذاكَ الَّذِي أخطَأ بِغَيرِ قَصدٍ. يُكَفِّرُ عَنْهُ فَيُغفَرَ لَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","هَذِهِ شَرِيعَةٌ واحِدَةٌ لِكُلِّ مَنْ يُخطِئُ بِغَيرِ قَصدٍ، لِلمُواطِنِ فِي إسْرائِيلَ وَلِلأجْنَبِيِّ المُقِيمِ بَينَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","«وَأمّا مَنْ يَرتَكِبُ خَطِيَّةً عَنْ قَصدٍ، وَطَنِيّاً كانَ أمْ أجْنبِيّاً، فَإنَّهُ يُهِينُ اللهَ وَيَنبَغِي أنْ يُقطَعَ مِنَ وَسَطِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","فَلأنَّهُ احتَقَرَ كَلامَ اللهِ وَنَقَضَ وَصِيَّتَهُ، فَإنَّهُ يُقطَعُ مِنَ الشَّعبِ وَيَتَحَمَّلُ ذَنبَهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","وَيَوماً، كانَ بَنو إسْرائِيلَ فِي البَرِّيَّةِ، فَوَجَدُوا رَجُلاً يَجمَعُ خَشَباً يَومَ السَّبتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","فَأخَذَهُ الَّذِينَ وَجَدُوهُ إلَى مُوسَى وَهارُونَ وَكُلِّ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","وَوَضَعُوهُ تَحتَ الحِراسَةِ لأنَّهُ لَمْ يَكُنْ قَدْ أُعلِنَ ما يَنْبَغِي أنْ يُفعَلَ بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","فَقالَ اللهُ لِمُوسَى: «يُقَتلُ ذَلِكَ الرَّجُلِ. يَرجِمُهُ جَميعُ الشَّعبِ خارِجَ المُخَيَّمِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","فَأخَذَهُ كُلُّ الشَّعبِ إلَى خارِجِ المُخَيَّمِ، وَرَجَمُوهُ حَتَّى ماتَ، بِحَسَبِ أمرِ اللهِ لِمُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ثُمَّ قالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«قُلْ لِبَني إسْرائِيلَ أنْ يَصنَعُوا لأنفُسِهِمْ أهداباً عَلَى أطرافِ أثوابِهِمْ مِنَ الآنَ فَصاعِداً، فِي كُلِّ أجيالِهِمْ. وَأنْ يَضَعُوا خَيطاً أزرَقَ عَلَى الهُدْبِ فِي كُلِّ أطرافِ الثَّوبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","فَتَرَوْنَ تِلكَ الأهدابَ، وَتَتَذَكَّرُونَ وَصايا اللهِ وَتَعمَلُونَ بِها. فَلا تَتبَعُوا شَهَواتِكُمْ وَرَغَباتِكُمْ وَتَكُونُوا غَيرَ أوفِياءٍ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","لَكِنَّكُمْ بِهَذا تَتَذَكَّرُونَ جَمِيعَ وَصايايَ، وَتَكُونُونَ شَعباً مُقَدَّساً لإلَهِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","أنا إلَهُكُمْ، الَّذِي أخرَجَكُمْ مِنْ أرْضِ مِصرَ لِيَكُونَ إلهاً لَكُمْ. أنا إلَهُكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","أمّا قُورَحُ بْنُ يِصْهارَ بْنِ قَهاتَ بْنِ لاوِي وَداثانُ وَأبِيرامُ ابْنا ألِيآبَ وَأُونُ بْنُ فالَتَ مِنْ بَنِي رَأُوبَيْنَ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","فَبَدأوا يُقاوِمُونَ مُوسَى مَعَ مِئَتَينِ وَخَمْسِينَ رَجُلاً مِنْ بَني إسْرائِيلَ. وَكانَ هَؤُلاءِ الرِّجالُ رُؤَساءَ مَعرُوفِينَ فِي المُجْتَمَعِ، مُمَثِّلينَ لِلشَّعْبِ، وَمَعْرُوفينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","فاجتَمَعُوا عَلَى مُوسَى وَهارُونَ وَقالُوا لَهُما: «أنْتُما تُبالِغانِ! فَكُلُّ الشَّعبِ مُقَدَّسٌ وَاللهُ فِي وَسَطِهِمْ. فَلِماذا تَرفَعانِ نفْسَيكُما فَوقَ جَماعَةِ اللهِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","وَحِينَ سَمِعَهُمْ مُوسَى وَقَعَ عَلَى وَجهِهِ إلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ثُمَّ قالَ مُوسَى لِقُورَحَ وَلِكُلِّ أتباعِهِ: «فِي الصَّباحِ، سَيُعلِنُ اللهُ مَنْ هُمُ الَّذِينَ يَنتَمُونَ إلَيهِ، وَمَنْ هُوَ المُقَدَّسُ، وَمَنْ يُسْمَحُ لَهُ بِالاقْتِرابِ مِنْهُ. فَالَّذِي يَختارُهُ، سَيَسْمَحُ لَهُ بِالاقْتِرابِ مِنْهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","افعَلُوا ما آمُرُكُمْ بِهِ: خُذْ أنتَ وَأتباعُكَ مَجامِرَ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","وَضَعُوا ناراً فِيها، وَضَعُوا عَلَيها بَخُوراً فِي حَضْرَةِ اللهِ فِي الغَدِ. وَالرَّجُلُ الَّذِي يَختارُهُ اللهُ سَيَكُونُ هُوَ المُقَدَّسُ. إنَّكُمْ تُقُولُونَ ما لا يَنْبَغِي أيُّها اللّاوِيُّونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ثُمَّ قالَ مُوسَى لِقُورَحَ: «اسْمَعُوا يا أبناءَ لاوِي، ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ألا يَكفِيكُمْ أنَّ إلَهَ إسْرائِيلَ أفرَزَكُمْ مِنْ بَني إسْرائِيلَ لِتَكُونُوا قَرِيبِينَ مِنهُ، وَتَقُومُوا بِواجِباتِ مَسْكَنِ اللهِ المُقَدَّسِ، وَتَقِفُوا أمامَ الشَّعبِ لِتَخدِمُوهُمْ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","لَقَدْ قَرَّبَكَ اللهُ أنتَ وَإخوَتَكَ اللّاوِيِّينَ لَكِنَّكُمْ مَعَ هَذا تُرِيدُونَ أنْ تَكُونُوا كَهَنَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","فَأنتَ وَأتباعُكَ إنَّما تَجتَمِعُونَ ضِدَّ اللهِ. وَما هُوَ هارُونُ حَتَّى تَتَذَمَّرُوا عَلَيهِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ثُمَّ دَعا مُوسَى داثانَ وَأبِيرامَ إبنَي ألِيآبَ، وَلَكِنَّهُما قالا: «لَنْ نَأتِيَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ألا يَكفِيكَ أنَّكَ أخرَجْتَنا مِنْ أرْضٍ تَفِيضُ لَبَناً وَعَسَلاً كَي تَقتُلَنا فِي الصَّحْراءِ؟ وَالآنَ تُرِيدُ أنْ تَجعَلَ نَفسَكَ رَئِيساً عَلَينا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","كَما أنَّكَ لَمْ تُحضِرْنا إلَى أرْضٍ خَصبَةٍ مَلِيئَةٍ بِخَيراتٍ كَثِيرَةٍ، وَلا أعطَيتَنا أرْضاً فِيها حُقُولٌ وَكُرُومٌ. هَلْ سَتُواصِلُ خِداعَ هَؤًلاءِ الرِّجالِ؟ لَنْ نَأتِيَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","فَغَضِبَ مُوسَى جِدّاً وَقالَ للهِ: «لا تَقبَلْ تَقدِمَتَهُما. لَمْ آخُذْ مِنهُما حَتَّى حِماراً! وَلَمْ أظلِمْهُما بِأيِّ شَيءٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ثُمَّ قالَ مُوسَى لِقُورَحَ: «قِفْ أنتَ وَجَماعَتُكَ فِي حَضْرَةِ اللهِ فِي الغَدِ، أنتُمْ وَهارُونُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","فَلْيأخُذْ كُلِّ واحِدٍ مِنكُمْ مِجمَرَتَهُ وَيَضَعَ بَخُوراً فِيها. ثُمَّ عَلَى كُلِّ واحِدٍ مِنْكُمْ أنْ يُحضِرَ مِجمَرَتَهُ أمامَ اللهِ، مِئَتَينِ وَخَمْسِينَ مِجمَرَةً. وَأنتُما يا قُورَحُ وَهارُونُ، هاتا مِجمَرَتَيكُما.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","فَحَمَلَ كُلُّ واحِدٍ مِجمَرَتَهُ، وَوَضَعَ فيْها جَمراً مُشتَعِلاً وَبَخُوراً. وَوَقَفُوا جَمِيعاً فِي مَدخَلِ خَيمَةِ الاجْتِماعِ مَعَ مُوسَى وَهارُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","وَجَمَعَ قُورَحُ كُلَّ الشَّعبِ عِندَ مَدخَلِ خَيمَةِ الاجْتِماعِ ضِدَّهُما. حِينَئِذٍ، ظَهَرَ مَجدُ اللهِ لِكُلِّ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","وَكَلَّمَ اللهُ مُوسَى وَهارُونَ فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«ابْتَعِدا عَنِ الشَّعبِ وَسَأُبِيدُهُمْ فِي لَحظَةٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","فَوَقَعا عَلَى وَجهَيهِما وَقالا: «يا اللهُ، أنتَ إلَهُ أرواحِ كُلِّ البَشَرِ. هَلْ تَغضَبُ عَلَى كُلِّ الجَماعَةِ فِي حِينِ أنَّ الَّذِي أخطَأ رَجُلٌ واحِدٌ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","فَكَلَّمَ اللهُ مُوسَى وَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«قُلْ لِلشَّعبِ: ابْتَعِدُوا عَنْ خِيامِ قُورَحَ وَداثانَ وَأبِيرامَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","فَقامَ مُوسَى وَذَهَبَ إلَى داثانَ وَأبِيرامَ، وَذَهَبَ شُيُوخُ إسْرائِيلَ مَعَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","وَقالَ مُوسَى لِلشَّعبِ: «ابْتَعِدُوا عَنْ خِيامِ هَؤُلاءِ الرِّجالِ الأشرارِ، وَلا تَلمِسُوا شَيئاً مِنْ مُقْتَنَياتِهِمْ، وَإلّا سَتَهلِكُونَ مَعَهُمْ بِسَبَبِ خَطاياهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","فابتَعَدُوا عَنْ خِيامِ قُورَحَ وَداثانَ وَأبِيرامَ. وَكانَ داثانُ وَأبِيرامُ قَدْ خَرَجا وَوَقَفا فِي مَدخَلِ خَيمَتِهِما مَعَ زَوجاتِهِما وَأولادِهِما وَأطفالِهِما. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","فَقالَ مُوسَى: «بِهَذا سَتَعرِفُونَ أنَّ اللهَ أرسَلَنِي لأعمَلَ هَذِهِ الأشياءَ، وَأنَّها لَمْ تَكُنْ فِكرَتِي: ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","إنْ ماتَ هَؤُلاءِ مِيتَةً طَبِيعِيَّةً كَكُلُّ النّاسِ، وَكانَتْ مُصِيبَتُهُمْ كَمَصائِبِ كُلُّ النّاسِ، لا يَكُونُ اللهُ قَدْ أرسَلَنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","لَكِنْ إنْ عَمِلَ اللهُ شَيئاً جَدِيداً، فَفَتَحَتِ الأرْضُ فاها وَابتَلَعَتْهُمْ مَعَ كُلِّ ما لَهُمْ، وَدُفِنُوا أحياءَ، حِينَئِذٍ سَتَعرِفُونَ أنَّ هَؤُلاءِ الرِّجالُ قَدْ أهانُوا اللهَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","وَما أنِ انتَهَى مُوسَى مِنْ هَذا الكَلامِ، حَتَّى انشَقَّتِ الأرْضُ تَحتَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","فَكَأنَّ الأرْضَ فَتَحَتْ فاها وَابتَلَعَتْهُمْ مَعَ عائِلاتِهِمْ وَكُلِّ أتباعِ قُورَحَ مَعَ كُلِّ أملاكِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","فَدُفِنُوا أحياءَ مَعَ كُلِّ ما كانَ لَهُمْ. وَانطَبَقَتِ الأرْضُ عَلَيهِمْ، فَاُبيدُوا مِنْ وَسَطِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","وَهَرَبَ كُلُّ بَني إسْرائِيلَ مِنْ حَولِهِمْ حِينَ سَمِعُوا صِياحَهُمْ، لأنَّهُمْ قالُوا: «قَدْ تَبتَلِعُنا الأرْضُ نَحنُ أيضاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ثُمَّ أرسَلَ اللهُ ناراً التَهَمَتِ المِئَتَينِ وَالخَمسِينَ رَجُلاً الَّذِينَ كانُوا يُقَدِّمُونَ البَخُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«قُلْ لألِيعازارَ بْنَ هارُونَ الكاهِنِ أنْ يَأخُذَ المَجامِرَ مِنْ بَينِ بَقايا الحَرِيقِ، وَأنْ يُذَرِّيَ الجَمرَ مِنها. لأنَّ المَجامِرَ صارَتْ مُقَدَّسَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","خُذْ مَجامِرَ الَّذِينَ أخطَأُوا ضِدَّ أنفُسِهِمْ وَهَلَكُوا، وَاصنَعُوا مِنها صَفائِحَ مَطرُوقَةً لِتَكُونَ غِطاءً لِلمَذبَحِ، لأنَّهُمْ قَدَّمُوها فِي حَضْرَةِ اللهِ فَجَعَلُوها مُقَدَّسَةً. وَهَكَذا تَكُونُ عَلامَةَ تَحذِيرٍ لِبَني إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","فَأخَذَ ألِيعازارُ المَجامِرَ البُرونْزِيَّةَ الَّتِي قَدَّمَها الَّذِينَ احتَرَقُوا، وَطَرَقُوها صانِعِينَ مِنها صَفائِحَ لِتَغطِيَةِ المَذبَحِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","كَما قالَ اللهُ لألِيعازارَ عَلَى فَمِ مُوسَى. وَقَدْ كانَ هَذا الغِطاءُ لِتَذكِيرِ بَني إسْرائِيلَ بِأنْ لا يَقتَرِبَ أحَدٌ لَيسَ مِنْ نَسلِ هارُونَ إلَى المَذبَحِ لِيَحرِقَ بَخُوراً فِي حَضْرَةِ اللهِ، فَيُلاقِيَ مَصيرَ قُورَحَ وَأتباعِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","وَفِي اليَومِ التّالِي، تَذَمَّرَ بَنو إسْرائِيلَ عَلَى مُوسَى وَهارُونَ وَقالُوا: «لَقَدْ سَبَّبْتُما مَوتَ شَعبِ اللهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","وَبَينما كانَ الشَّعبُ مُجْتَمِعِينَ ضِدَّ مُوسَى وَهارُونَ، التَفَتُوا إلَى خَيمَةِ الاجْتِماعِ فَرَأَوْا السَّحابَةَ تُغَطِّيها، وَظَهَرَ مَجدُ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","حِينَئِذٍ، جاءَ مُوسَى وَهارُونُ إلَى أمامِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","فَكَلَّمَ اللهُ مُوسَى وَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«ابتَعِدْ عَنْ هَذا الشَّعبِ كَي أُهلِكَهُ فِي لَحظَةٍ.» فانحَنَيا وَوَجهاهُما إلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ثُمَّ قالَ مُوسَى لِهارُونَ: «خُذِ المِجمَرَةَ وَضَعْ فِيها ناراً مِنَ المَذبَحِ وَضَعْ فَوقَها بَخُوراً، وَاذْهَبْ بِسُرعَةٍ إلَى الشَّعبِ وَطَهِّرْهُمْ، لأنَّ اللهَ غاضِبٌ عَلَيهِمْ وَقَدْ بَدَأ الوَباءُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","فَأخَذَ هارُونُ مِجمَرَةَ النّارِ كَما قالَ لَهُ مُوسَى، وَرَكَضَ إلَى وَسَطِ الشَّعبِ وَوَجَدَ أنَّ الوَباءَ قَدْ بَدَأ يَفتِكُ فِي الشَّعبِ. فَوَضَعَ هارُونُ بَخُوراً فِي المِجمَرَةِ وَعَمِلَ ما يَنْبَغِي لِتَطهِيرِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","وَوَقَفَ هارُونُ بَينَ المَوتَى وَالأحياءِ فَتَوَقَّفَ الوَباءُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","وَوَصَلَ عَدَدُ الَّذِينَ ماتُوا مِنَ الوَباءِ إلَى أربَعَةَ عَشَرَ ألفاً وَسَبعِ مِئَةٍ، بِالإضافَةِ إلَى الَّذِينَ سَبَقَ وَأنْ ماتُوا بِسَبَبِ قُورَحَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ثُمَّ عادَ هارُونُ إلَى مُوسَى فِي مَدخَلِ خَيمَةِ الاجْتِماعِ، بَعدَ أنْ تَوَقَّفَ الوَباءُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«كَلِّمْ بَني إسْرائِيلَ، وَخُذْ مِنهُمُ اثْنَتَي عَشْرَةَ عَصاً: عَصاً واحِدَةً لِكُلِّ قَبيلَةٍ مِنْ جَمِيعِ رُؤَساءِ القَبائِلِ. وَاكتُبِ اسْمَ كُلِّ رَجُلٍ عَلَى عَصاهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","وَاكتُبِ اسْمَ هارُونَ عَلَى عَصا قَبِيلَةِ لاوِي، إذْ سَتَكُونُ هُناكَ عَصاً واحِدَةً لِكُلِّ واحِدٍ مِنْ رُؤَساءِ القَبائِلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","وَضَعِ العِصِيَّ فِي خَيمَةِ الاجْتِماعِ أمامَ صُندُوقِ العَهدِ، حَيثُ ألتَقِي بِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","وَعَصا الرَّجُلِ الَّذِي أختارُهُ سَتُورِقُ. وَهَكَذا سَأُوقِفُ تَذَمُّراتِ بَني إسْرائِيلَ الَّتِي يَتَذَمَّرُونَها عَلَيكُما.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ثُمَّ كَلَّمَ مُوسَى بَني إسْرائِيلَ. وَأعطى كُلُّ رُؤَسائِهِمْ عِصِيّاً: عَصاً مِنْ كُلِّ رَئِيسِ عَشِيرَةٍ. وَكانَتْ عَصا هارُونَ بَينَ عِصِيِّهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","وَوَضَعَ مُوسَى العِصِيَّ فِي حَضْرَةِ اللهِ فِي خَيمَةِ العَهدِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","وَفِي اليَومِ التّالِي، دَخَلَ مُوسَى إلَى خَيمَةِ العَهدِ، وَرَأى عَصا هارُونَ الَّتِي تُمَثِّلُ قَبِيلَةَ لاوِي قَدْ أورَقَتْ وَأخرَجَتْ بَراعِمَ وَأزهَرَتْ وَأثمَرَتْ لَوزاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","فَحِينَئِذٍ، أخرَجَ مُوسَى كُلَّ العِصِيِّ مِنْ مَحْضَرِ اللهِ إلَى بَني إسْرائِيلَ، فَرَأى كُلُّ القادَةِ عِصِيَّهُمْ وَأخَذَ كُلُّ واحِدٍ عَصاهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","فَحِينَئِذٍ، قالَ اللهُ لِمُوسَى: «أرجِعْ عَصا هارُونَ إلَى أمامِ صُندُوقِ الشَّهادَةِ لِحِفظِها كَعَلامَةٍ لِتَحذِيرِ المُتَمَرِّدِينَ كَي يَتَوَقَّفُوا عَنِ التَّذَمُّرِ عَلَيَّ كَي لا يَمُوتُوا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","فَفَعَلَ مُوسَى ذَلِكَ، تَماماً كَما أمَرَهُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","فَقالَ بَنو إسْرائِيلَ لِمُوسَى: «سَنَمُوتُ! سَنَهلِكُ! سَنَفنَى! ");
INSERT INTO arbwbtc_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","كُلُّ مَنْ يَقتَرِبُ مِنْ مَسْكَنِ اللهِ سَيَمُوتُ. فَهَلْ سَنَمُوتُ جَمِيعاً؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","وَقالَ اللهُ لِهارُونَ: «أنتَ وَأبناؤُكَ وَعَشِيرَتُكَ مَعَكَ سَتَنالُونَ العِقابَ عَلَى أيِّ تَنجِيسٍ يَحدُثُ لِلْمَكانِ المُقَدَّسِ. وَأنتَ وَأبناؤُكَ مِنْ بَعدِكَ سَتَنالُونَ العِقابَ عَلَى أيِّ تَنجِيسٍ يَحدُثُ لِكَهَنُوتِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","أحضِرْ مَعكَ إخْوَتَكَ قَبِيلَةَ لاوِي، عَشِيرَةَ أبِيكَ، وَسَيَنضَمُّونَ إلَيكَ كَي يُساعِدُوكَ حِينَ تَكُونُ أنتَ وَأولادُكَ أمامَ خَيمَةِ العَهْدِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","سَيَقُومُونَ بِخِدمَتِكَ وَخِدمَةِ الخَيمَةِ المُقَدَّسَةِ. لَكِنْ لَيْسَ لَهُمْ أنْ يَقتَرِبُوا مِنَ أدَواتِ المَكانِ المُقَدَّسِ أوِ مِنَ المَذبَحِ، كَي لا يَمُوتُوا هُمْ وَلا أنتُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","سَيَنضَمُّونَ إلَيكَ وَيَقُومُونَ بِواجِبِ خِدمَةِ خَيمَةِ الاجْتِماعِ، بِما فِي ذَلِكَ الأعمالِ الثَّقِيلَةِ فِي الخَيمَةِ. لَكِنْ لا يَقتَرِبْ غَريبٌ مَعَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","«اهْتَمُّوا بِالمَكانِ المُقَدَّسِ وَالمَذبَحِ بِأنفُسِكُمْ، كَي لا أغضَبَ عَلَى بَني إسْرائِيلَ ثانِيَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","قَدْ أخَذْتُ إخْوَتَكُمُ اللّاوِيِّينَ مِنْ بَينِ بَني إسْرائِيلَ. إنَّهُمْ هَدِيَّةٌ لَكُمْ مُكَرَّسَةٌ للهِ لِلقِيامِ بِالأعمالِ الثَّقِيلَةِ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","وَأمّا أنتَ وَأولادُكَ، فَتَقُومُونَ بِواجِباتِ الكَهَنَةِ. أنْتُمْ فَقَطْ تَقتَرِبُونَ مِنَ المَذْبَحِ، وَتَجْتازُونَ خَلفَ السِّتارَةِ. قُوموا بِعَمَلِكُمْ، فَقَدْ مَنَحْتُكُمُ خِدْمَةَ الكَهَنُوتِ عَطِيَّةً لَكُمْ، وَكُلُّ شَخْصٍ آخَرَ يَقتَرِبُ مِنْ خَيمَةِ الاجْتِماعِ يُقتَلُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","وَقالَ اللهُ لِهارُونَ: «لَقَدْ عَيَّنْتُكَ أنا نَفسِي لِحِراسَةِ العَطايا الَّتِي تُقَدَّمُ لِي بِما فِي ذَلِكَ التَّقدِماتِ المُقَدَّسَةِ الَّتِي يُقَدِّمُها بَنو إسْرائِيلَ. سَأُعطِيها لَكَ وَلأولادِكَ كَحِصَّةٍ دائِمَةٍ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","سَيَكُونُ هَذا نَصِيبَكَ مِنَ التَّقْدِماتِ المُخَصَّصَةِ لِلكَهَنَةِ بِالكامِلِ الَّتِي تَبقَى مِنْ نارِ المَذبَحِ: جَمِيعُ تَقدِماتِهِمْ، بِما فِيها تَقدِماتِ الحُبُوبِ وَذَبائِحِ الخَطِيَّةِ وَذَبائِحِ التَّعوِيضِ الَّتِي يُعِيدُونَها لِي. جَمِيعُها سَتَكُونُ نَصِيباً مُخَصَّصاً بِالكامِلِ لَكَ أنتَ وَأبناؤُكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","فَكُلْها نَصِيبٌ مُخَصَّصٌ لِلكَهَنَةِ بِالكامِلِ. يُمكِنُ لِكُلِّ الذُّكُورِ أنْ يَأكُلُوا مِنها. سَتَكُونُ مُخَصَّصَةً لَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«وَهَذِهِ أيضاً سَتَكُونُ لَكَ: جَمِيعُ التَّقدِماتِ الَّتِي يَرفَعُها بَنو إسْرائِيلَ لِي، أُعطِيها لَكَ وَلأولادِكَ وَبَناتِكَ كَنَصِيبٍ دائِمٍ. يَأكُلُ مِنها كُلُّ طاهِرٍ فِي عائِلَتِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","«سَأُعطيهِمْ أوَّلَ إنتاجِ بَني إسْرائِيلَ الَّذِي يُقَدِّمُونَهُ للهِ: أفضَلَ زَيتٍ وَنَبِيذٍ وَحُبُوبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","وَتَكُونُ لَكَ أوَّلُ مَحاصِيلِهِمِ النّاضِجَةِ فِي أرْضِهِمِ الَّتِي يُقَدِّمُونَها للهِ. يُمكِنُ لأيِّ شَخصٍ طاهِرٍ فِي عائِلَتِكَ أنْ يَأكُلَ مِنها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","كُلُّ شَيءٍ يُكَرَّسُ فِي إسْرائِيلَ سَيَكُونُ لَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","«كُلُّ طِفلٍ بِكرٍ أوْ حَيوانٍ بِكرٍ يُقَدِّمُونَهُ للهِ يَكُونُ لَكُمْ. لَكِنْ تَأخُذُ مالاً كَفِداءٍ لأبْكارِ النّاسِ وَالحَيواناتِ غَيرِ الطّاهِرَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","حِينَ يَبلُغُ البِكْرُ شَهراً، تأحُذُ مالَ الفِداءِ بِحَسَبِ المَبلَغِ المُحَدَّدِ، وَهُوَ خَمْسَةُ مَثاقيلَ مِنَ الفِضَّةِ، بِحَسَبِ المِقياسِ الرَّسْمِي لِلمِثْقالِ: المِثْقالُ بِعِشرِينَ قِيراطاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","«لَكِنْ لا تَقبَلْ مالاً لِفِداءِ بِكرِ الأبقارِ أوِ الخِرافِ أوِ الماعِزِ، فَهِيَ مُخَصَّصَةٌ للهِ. فَاسْفِكْ دَمَها عَلَى المَذبَحِ. وَأحْرِقْ شَحْمَها تَقدِمَةً كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","وَأمّا لَحمُها فَيَكُونُ لَكَ، كَالصَّدرِ أوْ الفَخْذِ اليُمنَى مِنَ التَّقدِماتِ المَرفُوعَةِ فِي حَضرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","كُلُّ التَّقدِماتِ المُقَدَّسَةِ الَّتِي يُقَدِّمُها بَنو إسْرائِيلَ للهِ سَأُعطِيها لَكَ وَلأولادِكَ وَبَناتِكَ كَنَصِيبٍ دائِمٍ. هَذا عَهدُ مِلْحٍ دائِمٌ مِنَ اللهِ لَكَ وَلِنَسلِكَ مِنْ بَعدِكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","وَقالَ اللهُ لِهارُونَ: «لَنْ تَحصُلَ عَلَى أيِّ نَصِيبٍ فِي أرْضِهِمْ، وَلَنْ تَملُكَ أيَّ حِصَّةٍ مِنَ الأرْضِ فِي وَسَطِهِمْ. أنا نَصِيبُكَ وَحِصَّتُكَ فِي وَسَطِ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","«وَأمّا اللّاوِيُّونَ فَسَأُعطِيهُمُ العُشرَ مِنْ مَحاصِيلِ بَني إسْرائِيلَ وَمنْ جَمِيعِ ما يُنتِجُونَهُ. هَذِهِ حِصَّتُهُمْ مُقابِلَ خِدْمَتِهِمْ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","فَعَلَى بَني إسْرائِيلَ مُنْذُ الآنَ أنْ لا يَقتَرِبُوا مِنْ خَيمَةِ الاجْتِماعِ. فَهُمْ يَقْتَرِفُونَ بِذَلِكَ خَطيَّةً تُؤدَّي إلَى المَوتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","فَمُنْذُ الآنَ يَخْدِمُ اللّاويُّونَ خِدْمَةَ خَيمَةِ الاجْتِماعِ، وَهُمْ يَتَحَمَّلونَ العِقابَ عَلَى أيِّ تَقصِيرٍ. هَذِهِ شَرِيعَةٌ دائِمَةٌ مِنَ الآنَ فَصاعِداً. وَلَنْ يَنالَ اللّاويُّونَ حِصَّةً مِنَ الأرْضِ مِثلَ بَقيَّةِ إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","فَعَلَى بَني إسْرائِيلَ أنْ يُقَدِّمُوا عُشرَ دَخلِهِمْ للهِ. وَأنا أُعطِي ذَلِكَ لِلّاوِيِّينَ كَنَصِيبٍ لَهُمْ بَدَلَ الأرْضِ. وَلِهَذا قُلْتُ لَنْ يَنالَ اللّاويُّونَ حِصَّةً مِنَ الأرْضِ مِثلَ بَقيَّةِ بَني إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«قُلْ لِلّاوِيِّينَ: حِينَ تَأخُذُونَ مِنْ بَني إسْرائِيلَ أعشارَهُمُ الَّتِي أعطَيتُها لَكُمْ مِنهُمْ كَنَصِيبٍ لَكُمْ، فَعَلَيكُمْ حِينَئِذٍ، أنْ تُقَدِّمُوا للهِ عُشراً مِنَ العُشرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","سَتُحْسَبُ تَقدِمَتُكُمْ كَالقَمحِ مِنْ بَيدَرِ التَّذرِيَةِ وَكالعَصِيرِ مِنْ مِعصَرَةِ الخَمرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","فَيَنبَغِي أنْ تُقَدِّمُوا للهِ مِنَ العُشرِ الَّذِي تَأخُذُونَهُ مِنْ بَني إسْرائِيلَ. مِنْ ذَلِكَ العُشرِ تُقَدِّمُونَ تَقدِمَةً للهِ لِهارُونَ الكاهِنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","مِنْ بَينِ جَمِيعِ التَّقدِماتِ الَّتِي تَأخُذُونَها، تُقَدِّمُونَ تَقدِمَةً مُناسِبَةً للهِ. تُقَدِّمُونَ أفضَلَ وَأقدَسَ جُزءٍ مِمّا يُقَدَّمُ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","«وَقُلْ لَهُمْ: حِينَ تُقَدِّمُونَ أفضَلَ جُزءٍ مِنها، سَتُحْسَبُ لَكُمْ أيُّها اللّاوِيُّونَ كَأنَّها مِنْ إنتاجِ بَيدَرِ التَّذرِيَةِ وَمِعصَرَةِ الخَمرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","يُمكِنُكَ أنتَ وَعائِلَتُكَ أنْ تَأكُلُوهُ فِي أيِّ مَكانٍ لأنَّهُ أُجرَةٌ لَكُمْ عَلَى عَمَلِكُمْ فِي خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","لَنْ تُعاقَبُوا إنْ قَدَّمْتُمْ أفضَلَ جُزءٍ مِنَ التَّقدِماتِ. فَلا تُنَجِّسُوا تَقدِماتِ بَني إسْرائِيلَ المُقَدَّسَةَ، وَإلّا فَإنَّكُمْ سَتَمُوتُونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","وَقالَ اللهُ لِمُوسَى وَهارُونَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«هَذِهِ هِيَ فَرِيضَةُ الشَّرِيعَةِ الَّتِي أمَرَ اللهُ بِها: قُلْ لِبَني إسْرائِيلَ أنْ يُحضِرُوا لَكَ بَقَرَةً حَمراءَ لا عَيبَ فِيها وَصَحِيحَةً، وَلَمْ يُوضَعْ عَلَيها نِيرٌ قَطُّ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","وَأعْطِها لألِيعازارَ الكاهِنِ الَّذِي يَأخُذُها خارِجَ المُخَيَّمِ لِتُذبَحَ أمامَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ثُمَّ يَأخُذُ ألِيعازارُ الكاهِنُ مِنْ دَمِها بِإصْبَعِهِ، وَيَرُشُّهُ سَبعَ مَرّاتٍ أمامَ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ثُمَّ تُحرَقُ البَقَرَةُ أمامَ عَينَيهِ: جِلدُها وَلَحمُها وَدَمُها وَأحشاؤُها وَكُلُّ ما فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","وَيَأخُذُ الكاهِنُ خَشَبَ أرْزٍ وَغُصْنَ زُوفا وَقِطعَةً مِنْ قُماشِ القِرْمِزِ، وَيُلقِيَها عَلَى البَقَرَةِ المُشتَعِلَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ثُمَّ يَغْسِلُ الكاهِنُ ثِيابَهُ وَجَسَدَهُ بِالماءِ. حِينَئِذٍ، يَعُودُ إلَى المُخَيَّمِ، لَكِنَّهُ يَبقَى غَيرَ طاهِرٍ حَتَّى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","أمّا الرَّجُلُ الَّذِي أحرَقَها، فَلْيَغسِلْ ثِيابَهُ وَجَسَدَهُ فِي الماءِ، لَكِنَّهُ يَبقَى غَيرَ طاهِرٍ حَتَّى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","«ثُمَّ يَذْهَبُ رَجُلٌ طاهِرٌ وَيَجمَعُ رَمادَ البَقَرَةِ وَيَضَعُهُ خارِجَ المُخَيَّمِ فِي مَكانٍ طاهِرٍ. يُحفَظُ الرَّمادُ لِبَني إسْرائِيلَ لأجلِ التَّطهِيرِ، فَهوَ سَيُسْتَخْدَمُ لِماءِ تَطهِيرِ الخَطِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","«وَعَلَى الرَّجُلِ الَّذِي جَمَعَ رَمادَ البَقَرَةِ أنْ يَغسِلَ ثِيابَهُ، لَكِنَّهُ سَيَبقَى غَيرَ طاهِرٍ حَتَّى المَساءِ. «هَذِهِ شَرِيعَةٌ دائِمَةٌ لِبَني إسْرائِيلَ، وَلِلأجانِبِ المُقِيمينَ بَينَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","مَنْ يَلمِسُ جُثَّةَ إنسانٍ مَيِّتٍ، يَبقَى غَيرَ طاهِرٍ لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","فَلْيَتَطَهَّرْ بِماءِ التَّطهِيرِ فِي اليَومَينِ الثّالِثِ وَالسّابِعِ. حِينَئِذٍ، سَيَكُونُ طاهِراً. فِإنْ لَمْ يَتَطَّهَرْ فِي اليَومَينِ الثّالِثِ وَالسّابِعِ، لا يَعْتَبَرُ طاهِراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","مَنْ يَلمِسُ جُثَّةَ إنسانٍ مَيِّتٍ، وَلا يَتَطَهَّرُ، فَإنَّهُ يُنَجِّسُ مَسْكَنَ اللهِ المُقَدَّسِ. لِذَلِكَ يُقطَعُ مِنْ إسْرائِيلَ. وَلأنَّ ماءَ التَّطهِيرِ لَمْ يُرَشَّ عَلَيهِ، يَبقَى غَيرَ طاهِرٍ، لأنَّ نَجاسَتَهُ ما زالَتْ عَلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«هَذِهِ هِيَ الشَّرِيعَةُ: إنْ ماتَ شَخصٌ فِي خَيمَةٍ، فَكُلُّ مَنْ يَدخُلُ الخَيمَةَ، أوْ كانَ فِيها، يَكُونُ غَيرَ طاهِرٍ لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","كُلُّ صَحنٍ بِلا غِطاءٍ، يَكُونُ غَيرَ طاهِرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","وَكُلُّ مَنْ يَلمِسُ قَتيلاً قُتِلَ فِي مَعرَكَةٍ فِي البَرِّيَةِ، أوْ ماتَ مَوتاً طَبِيعِيّاً، أوْ يَلمِسُ عَظمَةَ مَيِّتٍ، أوْ قَبراً، فَإنَّهُ سَيَكُونُ غَيرَ طاهِرٍ لِمُدَّةِ سَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«فَلْيُؤخَذْ بَعضُ رَمادِ ذَبِيحَةِ التَّطهِيرِ لأجلِ الشَّخصِ المُتَنَجِّسِ، ثُمَّ يُسكَبُ ماءٌ جارٍ فِي وِعاءٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","وَلْيأخُذْ شَخصٌ طاهِرٌ غُصْنَ زُوفا، وَيَغمِسْهُ فِي الماءِ، وَلْيَرُشَّ الماءَ عَلَى الخَيمَةِ وَعَلَى جَمِيعِ الأوعِيَةِ وَالنَّاسِ الَّذِينَ كانُوا فِيها. لِيَرُشَّ الماءَ عَلَى كُلِّ مَنْ لَمَسَ عَظماً أوْ قَتيلاً أوْ مَيِّتاً ميتَةً طَبيعيَّةً أوْ قَبراً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","«لِيَرُشَّ الشَّخصُ الطّاهِرُ الماءَ عَلَى غَيرِ الطّاهِرِ فِي اليَومَينِ الثّالِثِ وَالسّابِعِ، فَيَصِيرَ طاهِراً فِي اليَومِ السّابِعِ، حَيثُ يَغْسِلُ غَيرُ الطّاهِرِ ثِيابَهُ وَجَسَدَهُ فِي الماءِ، فَيَصِيرَ طاهِراً فِي المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«مَنْ يَتَنَجَّسُ وَلا يَتَطَهَّرُ، يُقطَعُ مِنَ إسرائِيلَ لأنَّهُ نَجَّسَ مَكانَ اللهِ المُقَدَّسِ، وَرَفَضَ أنْ يُرَشَّ ماءُ التَّطهِيرِ عَلَيهِ، وَهُوَ نَجِسٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","هَذِهِ فَرِيضَةٌ دائِمَةٌ لَكُمْ. أمّا مَنْ يَرُشُّ ماءَ التَّطهِيرِ، فَيَنبَغِي أنْ يَغسِلَ ثِيابَهُ. وَمَنْ يَلمِسُ ماءَ التَّطهِيرِ، يَكُونُ غَيرَ طاهِرٍ حَتَّى المَساءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","وَكُلُّ ما يَلمِسُهُ غَيرُ الطّاهِرِ يَكُونُ غَيرَ طاهِرٍ. وَكُلُّ شَخصٍ يَلمِسُهُ يَكُونُ غَيرَ طاهِرٍ حَتَّى المَساءِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","وَأتَى كُلُّ بَني إسْرائِيلَ إلَى بَرِّيَّةِ صِينَ فِي الشَّهرِ الأوَّلِ، وَأقامُوا فِي قادِشَ. وَهُناكَ ماتَتْ مَريَمُ وَدُفِنَتْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","وَلَمْ يَكُنْ هُناكَ ماءٌ لِلشَّعبِ لِيَشْرَبُوا. فاجتَمَعُوا مَعَاً ضِدَّ مُوسَى وَهارُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","وَتَجادَلَ الشَّعبُ مَعَ مُوسَى وَقالُوا لَهُ: «لَيتَنا مُتْنا حِينَ ماتَ إخْوَتُنا فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","لِماذا أتَيتُما بِشَعبِ اللهِ إلَى هَذِهِ الصَّحراءِ كَي نَمُوتَ نَحنُ وَحَيواناتُنا هُنا؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","وَلِماذا أخرَجْتُمانا مِنْ مِصرَ إلَى هَذا المَكانِ المُرِيعِ؟ فَلَيسَ فِي هَذا المَكانِ قَمحٌ وَلا تِينٌ وَلا كُرُومٌ وَلا رُمّانٌ وَلا حَتَّى ماءٌ لِلشُّرْبِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","فَذَهَبَ مُوسَى وَهارُونُ مِنْ أمامِ الشَّعبِ إلَى مَدخَلِ خَيمَةِ الاجْتِماعِ، وَانحَنَيا وَوَجهاهُما نَحوَ الأرْضِ، فَظَهَرَ مَجدُ اللهِ لَهُما. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«خُذْ أنتَ وَهارُونُ العَصا وَاجمَعا الشَّعبَ. وَأمُرا الصَّخرَةَ أمامَهُمْ بِأنْ تُعْطِيَ ماءَها. هَكَذا تُخرِجُ لَهُمْ ماءً مِنَ الصَّخرَةِ. تُزَوِّدُهُمْ بِالماءِ لِيَشْرَبوا هُمْ وَحَيواناتُهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","فَأخَذَ مُوسَى العَصا مِنْ مَحْضَرِ اللهِ، كَما أمَرَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ثُمَّ جَمَعَ مُوسَى وَهارُونُ الشَّعبَ أمامَ الصَّخرَةِ. وَقالَ لَهُمْ مُوسَى: «اسْتَمِعُوا أيُّها الشَّعبُ المُتَمَرِّدُ، هَلْ نُخرِجُ لَكُمْ ماءً مِنْ هَذِهِ الصَّخرَةِ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ثُمَّ رَفَعَ مُوسَى يَدَهُ وَضَرَبَ الصَّخرَةَ مَرَّتَينِ بِالعَصا، فَتَدَفَّقَ الماءُ مِنها، وَشَرِبَ النَّاسُ وَحَيواناتُهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","فَقالَ اللهُ لِمُوسَى وَهارُونَ: «لأنَّكُما لَمْ تَثِقا بِي بِما يَكفِي لِتُقَدِّسانِي أمامَ بَني إسْرائِيلَ، لَنْ تَقُودا هَذا الشَّعبَ إلَى الأرْضِ الَّتِي سَأُعطِيها لَهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","هَذِهِ هِيَ مِياهُ مَرِيبَةَ حَيثُ تَمَرَّدَ بَنو إسْرائِيلَ عَلَى اللهِ، وَحَيْثُ أظهَرَ قَداسَتَهُ فِي وَسَطِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","وَأرسَلَ مُوسَى رُسُلاً مِنْ قادِشَ إلَى مَلِكِ أدُومَ وَقالَ لَهُ: «أخُوكَ إسْرائِيلُ يَقُولُ لَكَ: أنتَ تَعرِفُ الضِّيقَ الَّذِي تَعَرَّضْنا لَهُ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","أنَّ آباءَنا نَزَلُوا إلَى مِصرَ، وَأنَّنا عِشنا هُناكَ لِفَترَةٍ طَوِيلَةٍ، وَأنَّ المِصرِيِّينَ كانُوا قُساةً عَلَينا وَعَلَى آبائِنا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","لَكِنَّنا صَرَخنا إلَى اللهِ طالِبِينَ عَونَهُ، وَقَدِ اسْتَجابَ وَأرسَلَ مَلاكاً أخرَجَنا مِنْ مِصرَ. إنَّنا فِي قادِشَ، المَدِينَةِ الَّتِي عَلَى حُدُودِ أرْضِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","فاسْمَحْ لَنا بِالمُرُورِ فِي أرْضِكَ. نَتَعَهَّدُ بِأنْ لا نَمُرَّ فِي الحُقُولِ أوِ الكُرُومِ، أوْ نَشرَبَ ماءً مِنْ آبارِكُمْ. نَسِيرُ فِي ‹طَرِيقِ المَلِكِ.› لا نَمِيلُ إلَى اليَمِينِ أوِ اليَسارِ حَتَّى نَجتازَ أرْضَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","فَقالَ مَلِكُ أدُومَ لَهُمْ: «لا أسمَحُ لَكُمْ بِالمُرُورِ فِي أرْضِي، فَإنْ حاوَلْتُمْ عَمَلَ ذَلِكَ، فَإنَّنا سَنَخرُجُ وَنُقاوِمُكُمْ بِالسُّيُوفِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","فَقالَ بَنُو إسْرائِيلَ لَهُ: «سَنَسِيرُ فِي ‹طَرِيقِ المَلِكِ.› وَإنْ شَرِبْنا نَحنُ أوْ حَيواناتُنا مِنْ مائِكَ، سَنَدفَعُ ثَمَنَهُ. اسْمَحْ لَنا بِأنْ نَمُرَّ فِي أرْضِكَ سَيْراً عَلَى الأقدامِ. هَذا كُلُّ ما نَطلُبُهُ مِنكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","وَأمّا مَلِكُ أدُومَ فَقالَ: «لَنْ تَمُرُّوا فِي أرْضِي.» وَخَرَجَ أدُومُ لِيُلاقِي بَنِي إسْرائِيلَ بِجَيشٍ عَظِيمٍ وَقَوِيٍّ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","وَرَفَضَ مَلِكُ أدُومَ السَّماحَ لِبَنِي إسْرائِيلَ بِالمُرُورِ فِي أرْضِهِ، فَمالُوا عَنْ أرْضِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","فَتَرَكَ جَمِيعُ بَني إسْرائِيلَ قادِشَ وَأتَوا إلَى جَبَلِ هُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","وَقالَ اللهُ لِمُوسَى وَهارُونَ عَلَى جَبَلِ هُورَ الَّذِي يَقَعُ قُربَ حُدُودِ أدُومَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«ليَمُتْ هارُونُ وَيُضَمّ إلَى جَماعَتِهِ. فَهُوَ لَنْ يَدخُلَ الأرْضَ الَّتِي سَأُعطِيها لِبَني إسْرائِيلَ، لأنَّكُما عَصَيتُما أمرِي عِندَ مَرِيبَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","«خُذْ هارُونَ وَألِيعازارَ ابْنَهُ وَاصعَدْ بِهِما إلَى جَبَلِ هُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ثُمَّ انْزَعْ ثِيابَ هارُونَ الكَهَنُوتِيَّةَ عَنهُ وَألبِسْها لألِيعازارَ ابْنِهِ. فَسَيَمُوتُ هارُونُ هُناكَ وَيُضَمُّ إلَى جَماعَتِهِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","فَفَعَلَ مُوسَى كَما أمَرَهُ اللهُ. فَصَعِدُوا إلَى جَبَلِ هُورَ أمامَ كُلِّ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","وَنَزَعَ مُوسَى ثِيابَ هارُونَ الكَهَنُوتِيَّةَ عَنهُ وَألبَسَها لألِيعازارَ ابنِهِ. وَماتَ هارُونُ عَلَى قِمَّةِ الجَبَلِ. حِينَئِذٍ، نَزَلَ مُوسَى وَألِيعازارُ مِنَ الجَبَلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","وَعَرَفَ جَمِيعُ الشَّعبِ أنَّ هارُونَ قَدْ ماتَ. فَبَكَى جَمِيعُ بَنِي إسْرائِيلَ عَلَى هارُونَ مُدَّةَ ثَلاثِينَ يَوماً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","وَسَمِعَ عَرادُ، المَلِكُ الكَنعانِيُّ الَّذِي كانَ يَسكُنُ فِي النَّقَبِ أنَّ إسْرائِيلَ كانَ آتِياً فِي طَرِيقِ أتارِيمَ، فَحارَبَ بَنِي إسْرائِيلَ وَسَبَى بَعضاً مِنْهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","فَنَذَرَ إسْرائِيلُ نَذراً خاصّاً للهِ، فَقالَ: «إنْ ساعَدْتَنا فِي هَزِيمَةِ هَذا الشَّعبِ، فَسَنُدَمِّرُ مُدُنَهُمْ تَماماً.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","وَسَمِعَ اللهُ لِصَوتِ إسْرائِيلَ وَساعَدَهُمْ فِي هَزِيمَةِ الكَنعانِيِّينَ، فَقَضَوْا عَلَيهِمْ وَدَمَّرُوا مُدُنَهُمْ بِالكامِلِ. وَلِذا دَعُوا اسْمَ المَكانِ حُرْمَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ثُمَّ تَرَكُوا جَبَلَ هُورَ فِي الطَّرِيقِ إلَى البَحرِ الأحمَرِ لِيَدُورُوا حَولَ أرْضِ أدُومَ. فَتَضايَقَ الشَّعبُ جِدّاً فِي الطَّرِيقِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","وَبَدَأوا يَتَكَلَّمُونَ ضِدَّ اللهِ وَمُوسَى: «لِماذا جَعَلْتُمانا نَترُكُ مِصرَ لِنَمُوتَ فِي الصَّحْراءِ؟ فَلَيسَ هُناكَ خُبزٌ أوْ ماءٌ فِي هَذا المَكانِ، وَقَدْ مَلَلْنا هَذا الطَّعامَ السَّخِيفَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","فَأرسَلَ اللهُ حَيّاتٍ سامَّةً إلَى الشَّعبِ، فَلَدَغَتْهُمْ. وَماتَ كَثِيرُونَ مِنْ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","وَلِذا أتَى الشَّعبُ إلَى مُوسَى وَقالُوا: «لَقَدْ أخطَأْنا بِتَكَلّمِنا ضِدَّ اللهِ وَضِدَّكَ. صَلِّ إلَى اللهِ أنْ يَأخُذَ الحَيّاتِ بَعِيداً عَنّا.» فَصَلَّى مُوسَى لأجلِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","فَقالَ اللهُ لِمُوسَى: «اصنَعْ حَيَّةً نُحاسِيَّةً وَضَعْها عَلَى عَمُودٍ. وَحِينَ يَنظُرُ إلَيها أيُّ شَخصٍ لَدَغَتْهُ حَيَّةٌ فَإنَّهُ سَيُشفَى.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","فَصَنَعَ مُوسَى حَيَّةً نُحاسِيَّةً وَعَلَّقَها عَلَى سارِيَةٍ خَشَبِيَّةٍ. فَكانَ كُلُّ مَنْ لَدَغَتْهُ حَيَّةٌ، وَنَظَرَ إلَى الحَيَّةِ البُرونْزِيَّةِ، يُشفَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ثُمَّ تَرَكَ بَنو إسْرائِيلَ ذَلِكَ المَكانَ وَخَيَّمُوا فِي أُوبُوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ثُمَّ تَرَكُوا أُوبُوتَ وَخَيَّمُوا فِي عَيِّي عَبارِيمَ فِي الصَّحْراءِ عَلَى حَدِّ مُوآبَ إلَى الشَّرقِ مِنها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","وَتَرَكُوا ذَلِكَ المَكانَ وَخَيَّمُوا فِي وادِي زارَدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","وَتَرَكُوا ذَلِكَ المَكانَ وَخَيَّمُوا عَلَى ضِفَّةِ نَهرِ أرنُونَ فِي الصَّحْراءِ المُمتَدَّةِ مِنْ أرْضِ الأمُورِيِّينَ – فَنَهرُ أرْنُونَ هُوَ الحَدُّ الفاصِلُ بَينَ مُوآبَ وَأرْضِ الأمُورِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","وَيُوصَفُ هَذا فِي كِتابِ حُرُوبِ اللهِ كَما يَلِي: «… وَاهِبٌ فِي سُوفَةَ وَأودِيَةِ أرنُونَ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","وَمُنحَدَراتُ أودِيَتِهِ تُؤَدِّي إلَى مَساكِنِ عارَ وَتَقَعُ عَلَى حُدُودِ مُوآبَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","وَمِنْ هُناكَ ذَهَبُوا إلَى مِنْطَقَةِ بِيْرَ، حَيْثُ البِئْرُ الَّتِي قالَ اللهُ لِمُوسَى عَنْها: «اجمَعِ الشَّعبَ هُناكَ، وَأنا سَأُعطِيهِمْ ماءً.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ثُمَّ رَنَّمَ بَنو إسْرائِيلَ هَذِهِ التَّرنِيمَةَ: «تَدَفَّقِي بِالماءِ أيَّتُها البِئْرُ. رَنِّمُوا لَها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","البِئْرُ الَّتِي حَفَرَها عُظَماءُ الشَّعبِ، الَّتِي بَدَأ قادَةُ الشَّعبِ بِحَفرِها، بِصَولَجاناتِهِمْ وَعِصِيِّهِمْ.» ثُمَّ تَرَكُوا تِلْكَ الصَّحْراءَ وَأتَوا إلَى مَتّانَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","وَمِنْ مَتّانَةَ أتَوا إلَى نَحلِيئِيلَ. وَمِنْ نَحلِيئِيلَ أتَوا إلَى بامُوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","وَمِنْ بامُوتَ أتَوا إلَى الوادِي الَّذِيِ فِي مِنْطَقَةِ مُوآبَ عَلَى قِمَّةِ جَبَلِ الفِسْجَةِ الَّذِي يُشرِفُ عَلَى الصَّحْراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","وَأرسَلَ إسْرائِيلُ رُسُلاً إلَى المَلِكِ سِيحُونَ مَلِكِ الأمُورِيِّينَ فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«اسْمَحْ لَنا بِالمُرُورِ فِي بَلَدِكَ. وَنَحنُ نَعِدُ بِأنَّنا لَنْ نَمِيلَ إلَى حُقُولِكَ أوْ كُرُومِكَ، وَلَنْ نَشرَبَ ماءً مِنْ بِئرِكَ. سَنَسِيرُ فِي ‹طَرِيقِ المَلِكِ› حَتَّى نَتَجاوَزَ أرْضَكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","لَكِنَّ سِيحُونَ لَمْ يَسمَحْ لإسْرائِيلَ بِالمُرُورِ فِي أرْضِهِ، بَلْ جَمَعَ كُلَّ شَعبِهِ وَخَرَجَ لِيَلتَقِيَ إسْرائِيلَ فِي الصَّحْراءِ، فَجاءَ إلَى ياهَصَ وَهاجَمَ إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","لَكِنَّ إسْرائِيلَ قَتَلُوهُ وَأخَذُوا أرْضَهُ مِنْ نَهرِ أرنُونَ إلَى نَهرِ يَبُّوقَ، وَإلَى حُدُودِ أرْضِ العَمُّونِيِّينَ، لأنَّ حُدُودَ العَمُّونِيِّينَ كانَتْ قَوِيَّةً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","فَأخَذَ إسْرائِيلُ كُلَّ هَذِهِ المُدُنِ وَسَكَنُوا كُلَّ مُدُنِ الأمُورِيِّينَ تِلكَ، فِي حَشبُونَ وَالمُدُنِ المُحِيطَةِ بِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","كانَتْ أدُومُ مَدِينَةَ المَلِكِ الأمُورِيِّ سِيحُونَ. وَكانَ سِيحُونُ قَدْ حارَبَ مَلِكَ مُوآبَ السّابِقَ، وَأخَذَ كُلَّ أرْضِهِ مِنهُ إلَى نَهرِ أرنُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","وَلِهَذا يَقُولُ المُغَنُّونَ: «تَعالَوا إلَى حَشبُونَ، فَلْيُعَدْ بِناؤُها. فَلْيُعَدْ بِناءُ مَدِينَةِ حَشْبُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","لأنَّ ناراً خَرَجَتْ مِنْ مَدِينَةِ سِيحُونَ، وَلَهِيباً مِنْ مَدِينَةِ سِيحُونَ. أكَلَتِ النّارُ عارَ فِي مُوآبَ، وَالتَهَمَتِ التِّلالَ الَّتِي فَوقَ أرنُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","وَيلٌ لَكَ يا مُوآبُ. قَدْ تَحَطَّمْتُمْ يا شَعبَ كَمُوشَ. جَعَلَ كَمُوشُ أبْناءَكَ يَهرُبُونَ، وَبَناتِكَ أسِيراتٍ لِسِيحُونَ مَلِكِ الأمُورِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","وَلَكِنَّنا هَزَمْنا هَؤُلاءِ الأمُورِيِّينَ. دَمَّرْنا مُدُنَهُمْ مِنْ حَشْبُونَ إلَى دِيبُونَ، مِنْ نَشِيمَ إلَى نُوفَحَ، القَرِيبَةِ مِنْ مِيدَبا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","وَسَكَنَ إسْرائِيلُ فِي أرْضِ الأمُورِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","وَأرسَلَ مُوسَى رِجالاً لِيَستَكشِفُوا يَعزِيرَ، فَأخَذُوا المُدُنَ المُحِيطَةَ بِها وَأجبَرُوا الأمُورِيِّينَ الَّذِينَ كانُوا هُناكَ عَلَى تَركِ المِنطَقَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ثُمَّ دارَ بَنُو إسْرائِيلَ وَسارُوا فِي الطَّرِيقِ إلَى باشانَ. فَخَرَجَ عُوجُ مَلِكُ باشانَ إلَى إذرَعِي مَعَ كُلِّ شَعبِهِ لِيُحارِبَ بَنِي إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","وَقالَ اللهُ لِمُوسَى: «لا تَخَفْ مِنهُ، لأنِّي سَأُسَلِّمُهُ هُوَ وَكُلَّ شَعبِهِ وَكُلَّ أرْضِهِ إلَيكَ. فَافْعَلْ بِهِ كَما فَعَلْتَ بِسِيحُونَ مَلِكِ الأمُورِيِّينَ الَّذِي كانَ يَحْكُمُ فِي حَشبُونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","فَقَتَلَ بَنُو إسْرائِيلَ عُوجَ وَأبناءَهُ وَكُلَّ شَعبِهِ، حَتَّى لَمْ يَبقَ هُناكَ ناجٍ واحِدٌ. ثُمَّ أخَذُوا أرْضَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ثُمَّ أكمَلَ بَنو إسْرائِيلَ رِحلَتَهُمْ وَخَيَّمُوا فِي سُهُولِ مُوآبَ إلَى الشَّرقِ مِنْ نَهرِ الأُردُنِّ مُقابِلَ أرِيحا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","وَرَأى بالاقُ بْنُ صِفُّورَ كُلَّ ما عَمِلَهُ بَنُو إسْرائِيلَ بِالأمُورِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","وَارتَعَبَ المُوآبِيُّونَ مِنْ بَني إسْرائِيلَ لأنَّهُمْ كانُوا كَثِيرِينَ. كانَ المُوآبِيُّونَ مُرتَعِبِينَ مِنْ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","وَقالَ مَلِكُ مُوآبَ لِشُيُوخِ مِديانَ: «سَيُدَمِّرُ هَذا الشَّعبُ العَظِيمُ كُلَّ شَيءٍ حَولَنا، كَما يَلتَهِمُ الثَّورُ عُشبَ الحَقلِ.» وَكانَ بالاقُ بْنُ صِفُّورَ مَلِكَ مُوآبَ فِي ذَلِكَ الوَقتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","فَأرسَلَ بالاقُ رُسُلاً إلَى بَلْعامَ بْنِ بَعُورَ فِي فَتُورَ الواقِعَةِ عَلَى نَهرِ الفُراتِ حَيْثُ كانَ يَعِيشُ شَعبُ بَلْعامَ، لِيَدعُوَهُ. فَقالَ لَهُ: «لَقَدْ خَرَجَ شَعبٌ مِنْ مِصرَ، وَقَدْ غَطُّوا الأرْضَ مِنْ كَثرَتِهِمْ، وَهُمْ مُخَيِّمُونَ بِجِوارِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","وَالآنَ، تَعالَ وَالعَنْ لِي هَذا الشَّعبَ لأنَّهُمْ أقوَى مِنِّي. فَرُبَّما أُصْبِحُ عِنْدها قادِراً عَلَى مُهاجَمَتِهِمْ وَطَردِهِمْ مِنَ الأرْضِ. أنا أعْرِفُ أنَّ الَّذِي تُبارِكُهُ يَكُونُ مُبارَكاً، وَالَّذِي تَلعَنُهُ يَكُونُ مَلعُوناً.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","فَذَهَبَ شُيُوخُ مُوآبَ وَشُيُوخُ مِديانَ وَمَعَهُمْ أُجرَةُ بَلْعامَ مُقابِلَ عِرافَتِهِ. وَأتَوا إلَى بَلعامَ وَأخبَرُوهُ بِما قالَهُ بالاقُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","فَقالَ بَلعامُ لَهُمُ: «امْكُثوا هُنا اللَّيلَةَ، وَأنا سَأُخبِرُكُمْ بِما سَيَقُولُهُ اللهُ لِي.» فَمَكَثَ رُؤَساءُ مُوآبَ عِندَ بَلعامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","وَأتَى اللهُ إلَى بَلعامَ فِي حُلْمٍ وَقالَ لَهُ: «مَنْ هَؤُلاءِ الرِّجالُ الَّذِينَ عِندَكَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","فَقالَ بَلعامُ للهِ: «هَؤُلاءِ رِجالٌ أرسَلَهُمْ بالاقُ بْنُ صِفُّورَ، مَلِكُ مُوآبَ، إلَيَّ بِرِسالَةٍ يَقُولُ فِيها: ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‹خَرَجَ شَعبٌ مِنْ مِصرَ وَقَدْ غَطَّى الأرْضَ مِنْ كَثرَتِهِ. تَعالَ الآنَ وَالعَنْهُمْ لِي، وَبِهَذا أُصبِحُ قادِراً عَلَى مُحارَبَتِهِمْ وَطَردِهِمْ.›» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","فَقالَ اللهُ لِبَلعامَ: «لا تَذهَبْ مَعَهُمْ، وَلا تَلعَنَ هَذا الشَّعبَ لأنَّهُ مُبارَكٌ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","فَقامَ بَلعامُ فِي الصَّباحِ وَقالَ لِلقادَةِ الَّذِينَ أرسَلَهُمْ بالاقُ: «ارجِعُوا إلَى أرْضِكُمْ لأنَّ اللهَ رَفَضَ أنْ يَسمَحَ لِيَ بِالذَّهابِ مَعَكُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","فَقامَ قادَةُ مُوآبَ وَذَهَبُوا إلَى بالاقَ، وَقالُوا لَهُ: «رَفَضَ بَلعامُ أنْ يَأتِيَ مَعَنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","فَأرسَلَ بالاقُ مَرَّةً أُخْرَى قادَةً آخَرِينَ أكثَرَ عَدَداً وَأهَمِّيَّةً مِنْ مَجمُوعَةِ القادَةِ الأُولَى، ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","وَذَهَبُوا إلَى بَلعامَ وَقالُوا لَهُ: «هَذا هُوَ ما يَقُولُهُ بالاقُ بْنُ صِفُّورَ: أرجُو أنْ لا يَمنَعَكَ مَانِعٌ مِنَ المَجِيءِ إلَيَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","لأنِّي سَأُكافِئُكَ كَثِيراً، وَسَأعْطيكَ كُلَّ ما تَطلُبُهُ. فَتَعالَ وَالْعَنْ لِي هَذا الشَّعبَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","فَأجابَ بَلعامُ قادَةَ بالاقَ: «حَتَّى لَو أعطانِي بالاقُ مِلءَ بَيتِهِ مِنَ الفِضَّةِ وَالذَّهَبِ، فَإنِّي لا أستَطِيعُ أنْ أعصِيَ أمرَ إلَهِي بِشَيءٍ كَبِيرٍ أوْ صَغِيرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","وَالآنَ، امْكُثوا هُنا اللَّيلَةَ كَما فَعَلَ الآخَرونَ لأعْرِفَ ماذا يُرِيدُ اللهُ أنْ يَقُولَ لِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","وَفِي تِلكَ اللَّيلَةِ أتَى اللهُ إلَى بَلعامَ فِي حُلْمٍ وَقالَ لَهُ: «إنْ طَلَبَ هَؤُلاءِ الرِّجالُ مِنكَ الذَّهابَ مَعَهُمْ، قُمْ وَاذْهَبْ مَعَهُمْ، لَكِنِ افْعَلْ ما أطلُبُهُ مِنكَ فَقَطْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","فَقامَ بَلعامُ فِي الصَّباحِ وَسَرَجَ حِمارَهُ وَذَهَبَ مَعَ قادَةِ مُوآبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","فَغَضِبَ اللهُ لأنَّ بَلعامَ ذَهَبَ. فَأتَى مَلاكُ اللهِ وَوَقَفَ فِي الطَّرِيقِ لِيُوقِفَهُ، وَقَدْ كانَ بَلعامُ راكِباً عَلَى حِمارِهِ وَيُرافِقُهُ اثْنانِ مِنْ خُدّامِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","وَحِينَ رَأى الحِمارُ مَلاكَ اللهِ واقِفاً فِي الطَّرِيقِ وَسَيفُهُ فِي يَدِهِ، انحَرَفَ الحِمارُ عَنِ الطَّرِيقِ وَذَهَبَ إلَى الحَقلِ، وَلِذا ضَرَبَ بَلعامُ الحِمارَ لِيُعِيدَهُ إلَى الطَّرِيقِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ثُمَّ وَقَفَ مَلاكُ اللهِ فِي طَرِيقٍ ضَيِّقٍ بَينَ كَرْمَينِ، لِكُلٍّ مِنْهُما حائِطٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","وَحِينَ رَأى الحِمارُ مَلاكَ اللهِ التَصَقَ بِالحائِطِ فَضَغَطَ قَدَمَ بَلعامَ، فَضَرَبَ بَلعامُ الحِمارَ ثانِيَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ثُمَّ عادَ مَلاكُ اللهِ وَوَقَفَ فِي مَكانٍ ضَيِّقٍ لا يُمكِنُ تَجاوزُهُ إلَى اليَمِينِ أوِ اليَسارِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","وَحِينَ رَأى الحِمارُ مَلاكَ اللهِ، بَرَكَ تَحتَ بَلعامَ. فَغَضِبَ بَلعامُ وَضَرَبَ الحِمارَ بِعَصاهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","حِينَئِذٍ، جَعَلَ اللهُ الحِمارَ يَتَكَلَّمَ، فَقالَ لِبَلعامَ: «ماذا عَمِلْتُ لَكَ لِتَضْرِبَنِي ثَلاثَ مَرّاتٍ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","فَقالَ بَلعامُ لِلحِمارِ: «قَدِ اسْتَهَنْتَ بِي. لَيْتَ فِي يَدِي سَيفٌ كَي أقتُلَكَ الآنَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","فَقالَ الحِمارُ لِبَلعامَ: «ألَسْتُ حِمارَكَ الَّذِي رَكِبْتَهُ طِيلَةَ حَياتِكَ إلَى هَذا اليَومِ؟ فَهَلْ عَمِلْتُ هَذا مَعكَ سابِقاً؟» فَقالَ بَلعامُ: «لا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","فَفَتَحَ اللهُ عَينَيِّ بَلعامَ لِيَرَى مَلاكَ اللهِ الَّذِي كانَ واقِفاً فِي الطَّرِيقِ وَبِيَدِهِ سَيفٌ مَسلُولٌ. فَسَجَدَ بَلعامُ وَوَجهُهُ إلَى الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","فَقالَ مَلاكُ اللهِ: «لِماذا ضَرَبْتَ حِمارَكَ هَذِهِ المَرّاتِ الثَّلاثَ؟ لَقَدْ خَرَجْتُ لإيقافِكَ. رأيَتُ طَرِيقَكَ قَدِ انحَرَفَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","رَآنِي الحِمارُ فَمالَ عَنِّي ثَلاثَ مَرّاتٍ. وَلَو لَمْ يَمِلْ، لَكُنْتُ قَتَلْتُكَ، وَاسْتَبْقَيتُ الحِمارَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","فَقالَ بَلعامُ لِمَلاكِ اللهِ: «أخطَأْتُ بِعَدَمِ مَعرِفَتِي أنَّكَ كُنتَ تَقِفُ فِي الطَّرِيقِ لِتُوقِفَنِي. وَالآنَ، إنْ كانَتْ رِحلَتِي لا تُرضِيكَ فَإنِّي سَأرجِعُ إلَى بَيتِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","فَقالَ مَلاكُ اللهِ لِبَلعامَ: «اذهَبْ مَعَ الرِّجالِ، لَكِنْ قُلْ ما أقُولُهُ لَكَ فَقَطْ.» فَذَهَبَ بَلعامُ مَعَ القادَةِ الَّذِينَ أرسَلَهُمْ بالاقُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","وَحِينَ سَمِعَ بالاقُ بِقُدُومِ بَلعامَ، خَرَجَ لِلِقائِهِ عِندَ عِيرِ مُوآبَ الواقِعَةِ عَلَى نَهرِ أرنُونَ عِندَ أبعَدِ نُقطَةٍ عَلَى الحُدُودِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","فَقالَ بالاقُ لِبَلعامَ: «ألَمْ أُرسِلْ لَكَ رِجالاً لأدعُوكَ لِلمَجِيءِ؟ فَلِماذا لَمْ تَأتِ إلَيَّ؟ هَلْ أنا غَيرُ قادِرٍ عَلَى إكْرامِكَ وَمُكافَئَتِكَ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","فَقالَ بَلعامُ لِبالاقَ: «ها قَدْ أتَيتُ إلَيكَ الآنَ، فَهَلْ أستَطِيعُ أنْ أعمَلَ شَيئاً؟ فَعَلَيَّ أنْ أقُولَ ما يَقُولُهُ اللهُ لِي.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","وَجاءَ بَلعامُ مَعَ بالاقَ إلَى قَريَةِ حُصُوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","وَذَبَحَ بالاقُ بَقَراً وَغَنَماً وَأرسَلَها إلَى بَلعامَ وَالقادَةِ الَّذِينَ كانُوا مَعَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","وَفِي الصَّباحِ أخَذَ بالاقُ بَلعامَ إلَى بامُوتَ بَعلَ. فَاسْتَطاعَ بَلعامُ مِنْ هُناكَ أنْ يَرَى جُزءاً مِنْ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","وَقالَ بَلعامُ لِبالاقَ: «ابْنِ سَبعَةَ مَذابِحَ هُنا. وَجَهِّزْ لِي سَبعَةَ ثِيرانٍ وَسَبعَةَ كِباشٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","فَفَعَلَ بالاقُ كَما طَلَبَ بَلعامُ. وَقَدَّمَ بالاقُ وَبَلعامُ ثَوراً وَكَبْشاً ذَبِيحَةً صاعِدَةً عَلَى كُلِّ مَذبَحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","فَقالَ بَلْعامُ لِبالاقَ: «قِفْ بِجانِبِ مُحرَقَتِكَ، وَأنا سَأنفَرِدُ بِنَفْسِي، فَلَرُبَّما سَيَلتَقِي اللهُ بِي. وَمَهما أظهَرَهُ اللهُ لِي فَإنِّي سَأُخبِرُكَ بِهِ.» ثُمَّ ذَهَبَ إلَى قِمَّةِ تَلَّةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","فَأتَى اللهُ إلَى بَلعامَ، فَقالَ بَلعامُ للهِ: «قَدْ نَصَبْتُ سَبعَةَ مَذابِحَ، وَقَدَّمْتُ ثَوراً وَكَبْشاً عَلَى كُلِّ مَذبَحٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","وَأخبَرَ اللهُ بَلعامَ بِما يَنْبَغِي أنْ يَقُولَهُ. وَقالَ اللهُ لَهُ: «ارجِعْ إلَى بالاقَ وَقُلْ لَهُ كَذا وَكَذا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","فَرَجِعَ بَلْعامُ إلَى بالاقَ الَّذِي كانَ واقِفاً بِجانِبِ مُحرَقَتِهِ مَعَ قادَةِ مُوآبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","فَتَكَلَّمَ بَلْعامُ بِهَذِهِ الكَلِماتِ: «أحضَرَنِي بالاقُ إلَى هُنا مِنْ أرامَ أحضَرَنِي مَلِكُ مُوآبَ مِنَ الجِبالِ الشَّرقِيَّةِ. قالَ بالاقُ لِي: ‹تَعالَ وَالعَنْ لِي يَعقُوبَ، تَعالَ وَتَكَلَّمْ ضِدَّ بَني إسْرائِيلَ.› ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","كَيفَ أستَطِيعُ أنْ ألعَنَ مَنْ لَمْ يَلعَنْهُ اللهُ؟ كَيفَ أستَطِيعُ أنْ أتَكَلَّمَ ضِدَّ الَّذِينَ لَمْ يَتَكَلَّمِ اللهُ ضِدَّهُمْ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","لأنِّي مِنْ قِمَّةِ الجِبالِ أراهُمْ، وَمِنَ التِّلالِ أُبصِرُهُمْ. ها إنَّهُمْ شَعبٌ يَعِيشُ وَحِيداً، وَلا يَعتَبِرُ نَفسَهُ أُمَّةً مِنَ الأُمَمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","مَنْ يَستَطِيعُ أنْ يُحصِيَ شَعبَ يَعقُوبَ وَهُوَ كالرَّمِلِ؟ أوْ أنْ يَعُدَّ وَلَوْ رُبعَ بَني إسْرائِيلَ؟ فَلأمُتْ مِيتَةِ المُستَقِيمينَ، وَلْتَكُنْ نِهايَتِي كَنِهايَتِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","وَقالَ بالاقُ لِبَلعامَ: «ماذا عَمِلْتَ بِي؟ أحضَرْتُكَ لِتَلْعَنَ أعدائِيَ، وَلَكِنْ كُلَّ ما فَعَلْتَهُ هُوَ أنَّكَ بارَكْتَهُمْ!» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","فَأجابَ بَلْعامُ: «ألا يَنْبَغِي أنْ أكُونَ حَرِيصاً عَلَى قَولِ ما يَطلُبُ اللهُ مِنِّي قَولَهُ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","فَقالَ بالاقُ لَهُ: «تَعالَ مَعِي إلَى مَكانٍ آخَرَ يُمكِنُكَ مِنهُ رُؤيَتُهُمْ، وَلَنْ تَرَى سِوَى جُزءٍ مِنهُمْ، فَلَنْ تَراهُمْ جَمِيعاً. وَالعَنْهُمْ لِي هُناكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","فَأخَذَ بالاقُ بَلعامَ إلَى حَقلِ صُوفِيمَ عَلَى قِمَّةِ جَبَلِ الفِسجَةِ. وَبَنَى بالاقُ هُناكَ سَبعَةَ مَذابِحَ، وَقَدَّمَ ثَوراً وَكَبْشاً عَلَى كُلِّ مَذبَحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","حِينَئِذٍ، قالَ بَلْعامُ لِبالاقَ: «قِفْ هُنا بِجانِبِ مُحرَقَتِكَ، بَينَما أنا ألتَقِي بِاللهِ هُناكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","وَأتَى اللهُ إلَى بَلْعامَ وَأخبَرَهُ بِما يَنْبَغِي أنْ يَقُولَهُ. وَقالَ لَهُ: «ارجِعْ إلَى بالاقَ وَقُلْ لَهُ كَذا وَكَذا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","فَذَهَبَ بَلْعامُ إلَى بالاقَ الَّذِي كانَ واقِفاً بِجانِبِ ذَبيحَتِهِ مَعَ قادَةِ مُوآبَ. فَسَألَهُ بالاقُ: «ماذا قالَ اللهُ؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","حِينَئِذٍ، تَكَلَّمَ بَلْعامُ بِهَذِهِ النُّبُوَّةِ: «قُمْ يا بالاقُ، وَاستَمِعْ لِي يا ابنَ صِفُّورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","لَيسَ اللهُ إنساناً لِكَي يَكْذِبَ، وَلا بَشَراً لِكَي يُغَيِّرَ رَأيَهُ. فَهَلْ يَقُولُ شَيئاً لَكِنْ لا يَعمَلُ بِهِ؟ أوْ هَلْ يَعِدُ بِشَيءٍ لَكِنْ لا يُوفِي بِهِ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ها قَدْ أُمِرْتُ بِأنْ أُبارِكَ. قَدْ بارَكَ إسْرائِيلَ، وَلَنْ أستَطِيعَ تَغيِيرَ هَذا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","لا يُرَى سُوءٌ فِي شَعبِ يَعقُوبَ، وَلا ضِيقٌ فِي بَني إسْرائِيلَ. إلَهُهُمْ مَعَهُمْ. وَهُوَ مُسَبَّحٌ بَينَهُمْ. إنَّهُ مُسَبَّحٌ كَمَلِكٍ فِي وَسَطِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","اللهُ الَّذِي أخرَجَهُمْ مِنْ مِصرَ قَوِيٌّ كَقَرنَيِّ ثَورٍ بَرِّيٍّ، وَهُوَ مَعَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","فَلا سِحرٌ يُؤَثِّرُ فِي يَعقُوبَ، وَلا عِرافَةٌ تُؤَثِّرُ فِي إسْرائِيلَ. سَيَعلَمُ يَعقُوبُ وَإسْرائِيلُ أعْمالَ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","يَقُومُ هَذا الشَّعبُ كَلَبْوَةٍ، وَيَقِفُ كَأسَدٍ. لَنْ يَنامَ إلَى أنْ يَأكُلَ فَرِيسَتَهُ، وَيَشرَبَ دَمَ الَّذِينَ قَتَلَهُمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","حِينَئِذٍ، قالَ بالاقُ لِبَلْعامَ: «إنْ لَمْ تُرِدْ أنْ تَلعَنَهُمْ، فَلا تُبارِكْهُمْ!» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","فَأجابَ بَلْعامُ بالاقَ: «ألَمْ أُخبِرْكَ بِأنِّي سَأفعَلُ كُلَّ ما يَقُولُهُ اللهُ لِي؟» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","وَقالَ بالاقُ لِبَلْعامَ: «تَعالَ لآخُذَكَ إلَى مَكانٍ آخَرَ، فَرُبَّما سَيَرضَى اللهُ أنْ تَلعَنَهُمْ مِنْ هُناكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","فَأخَذَ بالاقُ بَلْعامَ إلَى قِمَّةِ جَبَلِ فَغُورَ المُشرِفِ عَلَى الصَّحْراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","وَقالَ بَلْعامُ لِبالاقَ: «ابْنِ لِي سَبعَةَ مَذابِحَ هُنا، وَجَهِّزْ لِي سَبعَةَ ثِيرانٍ وَسَبعَةَ كِباشٍ عَلَيها.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","فَفَعَلَ بالاقُ ما طَلَبَهُ بَلْعامُ، فَقَدَّمَ ثَوراً وَكَبْشاً ذَبِيحَةً صاعِدَةً عَلَى كُلِّ مَذبَحٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","وَرَأى بَلْعامُ أنَّهُ أمرٌ يُرضِي اللهَ أنْ يُبارِكَ إسْرائِيلَ، وَلِذا لَمْ يَعْتَزِلْ كَما فَعَلَ سابِقاً، لَكِنَّهُ نَظَرَ إلَى الصَّحْراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","نَظَرَ بَلْعامُ فَرَأى بَني إسْرائِيلَ مُخَيِّماً بِحَسَبِ قَبائِلِهِ، فحَلَّ عَلَيهِ رُوحُ اللهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","وَتَكَلَّمَ بِهَذِهِ النُّبُوَّةِ: «هَذِهِ هِيَ رِسالَةُ بَلْعامَ بْنِ بَعُورَ، الرِّسالَةُ الَّتِي رَآها الرَّجُلُ المَفْتُوحُ العَينِينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","رِسالَةُ الَّذِي يَسمَعُ كَلامَ اللهِ القَدِيرِ، فَيَقَعَ أمامَهُ وَعَيناهُ مَفتُوحَتانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","«ما أجمَلَ خِيامَكَ يا شَعبَ يَعقُوبَ! ما أجمَلَ مَساكِنَكَ يا إسْرائِيلَ! ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","إنَّ خِيامَكَ كَبَساتِينَ مُمتَدَّةٍ، وَكَحَدائِقَ بِجانِبِ نَهرٍ، وَكَأشجارِ طِيبٍ زَرَعَها اللهُ، وَكَأرزٍ بِجانِبِ المِياهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","سَيَفِيضُ الماءُ مِنْ دِلائِهِمْ، وَسَيَكُونُ لِبُذُورِهِمْ ماءٌ غَزِيرٌ. سَيَكُونُ مُلْكُهُمْ أعظَمُ مِنْ مُلْكِ أجاجَ، وَسَتَكُونُ مَملَكَتُهُمْ عَظِيمَةً جِدّاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","«أخرَجَهُمُ اللهُ مِنْ مِصرَ، وَهُوَ لَهُمْ كَقَرْنَي ثَورٍ بَرِّيٍّ. سَيَهزِمُونَ أعداءَهُمْ، وَسَيَسحَقُونَ عِظامَهُمْ، وَسَيَضرِبُونَهُمْ بِسِهامِهِمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","إنَّهُمْ يَجثُمُونَ وَيَربِضُونَ كَأسَدٍ. إنَّهُمْ مِثلُ أسَدٍ! فَمَنْ سَيُنهِضُهُمْ؟ لا أحَدَ. كُلُّ مَنْ يَلعَنُهُمْ يَكُونُ مَلعُوناً.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","فَغَضِبَ بالاقُ جِدّاً مِنْ بَلعامَ، وَأخَذَ يُصَفِّقُ بِيَدَيهِ مِنْ شِدَّةِ الغَضَبِ. وَقالَ لِبَلْعامَ: «قَدْ دَعَوتُكَ لِتَلعَنَ أعدائِيَ، لَكِنَّكَ بارَكْتَهُمْ هَذِهِ المَرّاتِ الثَّلاثَ! ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","اذْهَبْ إلَى بَيتِكَ الآنَ! كُنتُ أُريدُ أنْ أكرِمَكَ وَأُكافِئَكَ، وَلَكِنَّ اللهَ مَنَعَ عَنكَ الإكرامَ وَالمُكافَأةَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","فَقالَ بَلْعامُ لِبالاقَ: «ألَمْ أقُلْ لِرُسُلِكَ الَّذِينَ أرسَلْتَهُمْ إلَيَّ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹حَتَّى وَلَو أعطانِي بالاقُ مِلءَ بَيتِهِ مِنَ الفِضَّةِ وَالذَّهَبِ، فَإنِّي لا أستَطِيعُ عِصيانَ أمرِ اللهِ بِأنْ أعمَلَ أيَّ شَيءٍ صالِحٍ أوْ رَدِيءٍ مِنْ ذاتِيَ، لَكِنْ عَلَيَّ أنْ أقُولَ ما يَقُولُهُ اللهُ لِي؟› ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","وَالآنَ سَأرجِعُ إلَى شَعبِي، لَكِنْ تَعالَ أُخبِرُكَ بِما سَيَعمَلُهُ هَذا الشَّعبُ فِي المُستَقبَلِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","حِينَئِذٍ، تَكَلَّمَ بَلْعامُ وَقالَ: «هَذِهِ هِيَ رِسالَةُ بَلْعامَ بْنِ بَعُورَ، الرِّسالَةُ الَّتِي رَآها الرَّجُلُ المَفْتُوحُ العَينِينِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","رِسالَةُ الَّذِي يَسمَعُ كَلامَ اللهِ، وَيَستَقبِلُ المَعرِفَةَ مِنَ العَلِيِّ، الَّذِي يَرَى رُؤَىً مِنَ اللهِ القَدِيرِ، فَيَقَعُ أمامَهُ وَعَيناهُ مَفتُوحَتانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","«أراهُ، لَكِنْ لَيسَ الآنَ، لَكِنْ فِي المُستَقبَلِ. أراهُ، لَكِنْ لَيسَ قَرِيباً، لَكِنْ فِي المُستَقبَلِ البَعِيدِ. سَيَخرُجُ مَلِكٌ كَنَجمٍ مِنْ وَسَطِ شَعبِ يَعقُوبَ. سَيَقُومُ حاكِمٌ مِنْ بَني إسْرائِيلَ. سَيَسحَقُ رُؤُوسَ شَعبِ مُوآبَ، وَيُحَطِّمُ جَماجِمَ الشِّيثيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","سَتُصبِحُ أرْضُ أدُومَ مُلْكاً لِبَني إسْرائِيلَ، وَسَيَمتَلِكُونَ سَعِيرَ، أرْضَ أعدائِهِمْ. بَينَما يَزدادُ إسْرائِيلُ قُوَّةً وَشَجاعَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","«سَيَأتِي حاكِمٌ مِنْ يَعقُوبَ، وَيُتلِفُ كُلَّ ما بَقِيَ مِنْ تِلكَ المُدُنِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","وَرَأى بَلْعامُ عَمالِيقَ، فَقالَ عَنهُمْ: «كانَ عَمالِيقُ مِنْ أهَمِّ الأُمَمِ، لَكِنَّ نِهايَتَهُ سَتَكُونُ دَماراً كامِلاً.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","وَرَأى القِينِيِّينَ، فَقالَ عَنهُمْ: «بَيتُكَ آمِنٌ، كَعُشٍّ مَوضُوعٍ عَلَى جَبَلٍ عالٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","لَكِنَّ القِينِيِّينَ سَيَتَعَرَّضُونَ لِلهَلاكِ حِينَ يَسبِيهِمِ الأشُّورِيُّونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ثُمَّ تَكَلَّمَ بَلْعامُ فَقالَ: «مَنْ سَيَعيشُ عِنْدَما يَفْعَلُ اللهُ هَذا؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","سَتَأْتِي سُفُنٌ مِنْ شاطِئٍ كِتِّيمَ، وَسَتَهزِمُ أشُّورَ وَعابِرَ. حَتَّى شَعبُ كِتِّيمَ أنفُسُهُمْ سَيَهلِكُونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ثُمَّ قامَ بَلْعامُ وَرَجِعَ إلَى بَيتِهِ، وَرَجِعَ بالاقُ أيضاً فِي طَرِيقِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","وَكانَ بَنو إسْرائِيلَ يُقيمونَ فِي شِطِّيمَ. فِي ذَلِكَ الوَقتِ، بَدَأ رِجالُ إسْرائِيلَ يَزنُونَ مَعَ نِساءٍ مُوآبِيّاتٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","وَدَعَتِ النِّساءُ المُوآبِيّاتُ بَني إسْرائِيلَ لِلمُشارَكَةِ فِي الذَّبحِ لإلِهَتِهِنَّ. فَأكَلَ بَنو إسْرائِيلَ مِنَ الذَّبائِحِ وَعَبَدُوا آلِهَةَ المُوآبِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","وَهَكَذا بَدَأ بَنُو إسْرائِيلَ يَعبُدُونَ الإلَهَ المُزَيَّفَ بَعلَ فَغُورَ، مِمّا أغْضَبَ اللهَ عَلَى إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","فَقالَ اللهُ لِمُوسَى: «خُذْ كُلَّ قادَةِ الشَّعبِ وَعَلِّقْهُمْ خَارِجاً تَحْتَ الشَّمْسِ أمامَ اللهِ، فَيَزُولُ غَضَبُ اللهِ عَلَى إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","فَقالَ مُوسَى لِقُضاةِ إسْرائِيلَ: «عَلَى كُلِّ واحِدٍ مِنكُمْ أنْ يَقتُلَ أقرِباءَهُ الَّذِينَ يَعبُدُونَ الإلَهَ المُزَيَّفَ بَعلَ فَغُورَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","وَفِي تِلكَ اللَّحظَةِ، أتَى أحَدُ بَنِي إسْرائِيلَ وَمَعَهُ امْرأةٌ مِديانِيَّةٌ قَدْ أحضَرَها إلَى إخْوَتِهِ. فَعَلَ هَذا أمامَ مُوسَى وَكُلِّ بَني إسْرائِيلَ، الَّذِينَ كانُوا يَبكُونَ فِي مَدخَلِ خَيمَةِ الاجْتِماعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","وَحِينَ رَأى فِينْحاسُ بْنُ ألِيعازارَ بْنِ هارُونَ الكاهِنِ هَذا، تَرَكَ مَكانَ تَجَمُّعِ الشَّعبِ، وَأمسَكَ بِرُمحِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","وَلَحِقَ بِالرَّجُلِ الإسْرائِيلِيِّ إلَى الخَيمَةِ. وَطَعَنَ فِينْحاسُ الإسْرائِيلِيَّ وَالمَرأةَ المِديانِيَّةَ فِي بَطنَيهِما. حِينَئِذٍ، تَوَقَّفَ الوَباءُ فِي بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","وَكانَ عَدَدُ الَّذِينَ ماتُوا مِنَ الوَباءِ أربَعَةً وَعِشرِينَ ألفاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«فِينْحاسُ بْنُ ألِيعازَرَ بنِ هارُونَ الكاهِنِ أنقَذَ بَني إسْرائِيلَ مِنْ غَضَبِي. فَقَدْ أظْهَرَ غِيرَتِي بِغِيرَتِهِ عَلَى مَجْدِي فِي وَسْطِهِمْ. وَلِذَلِكَ لَمْ أقتُلْ بَني إسْرائِيلَ بِسَبِبِ غَيرَتِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","فَقُلْ لَهُ إنِّي أعقِدُ عَهدَ صَداقَةٍ وَسَلامٍ مَعَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","وَهَذا هُوَ العَهدُ: هُوَ وَنَسلُهُ الَّذِي سَيَأتِي مِنْ بَعدِهِ سَيَكُونُونَ دائِماً كَهَنَةً. لأنَّهُ كانَ غَيُّوراً عَلَى اللهِ وَمُحِبّاً لَهُ، فَأنْقَذَ بَنِي إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","وَكانَ اسْمُ الإسْرائِيلِيِّ الَّذِي قُتِلَ مَعَ المَرأةِ المِديانِيَّةِ زِمْرِي بْنَ سالُو. وَهُوَ قائِدٌ لِعائِلَةٍ فِي قَبِيلَةِ شِمْعُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","أمّا اسْمُ المَرأةِ الَّتِي قُتِلَتْ فَهُوَ كُزْبِي بِنتَ صُورٍ. وَأبوها رَئِيسٌ فِي بَعْضِ قَبائِلِ مِديانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«عادُوا المِديانِيِّينَ وَاقتُلُوهُمْ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","لأنَّهُمْ عادُوكُمْ بِسَبَبِ المَكِيدَةِ الَّتِي احتالُوا عَلَيكُمْ بِها فِي فَغُورَ، وَبِسَبَبِ المَكِيدَةِ الَّتِي دَبَّرُوها مِنْ خِلالِ قَرِيبَتِهِمْ كُزْبِي بِنتِ أحَدِ رُؤَساءِ مِديانَ، الَّتِي قُتِلَتْ فِي وَقتِ الوَباءِ بِسَبَبِ ما حَدَثَ فِي فَغُورَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","وَبَعدَ الوَبَاءِ الشَّديدِ، قالَ اللهُ لِمُوسَى وَألِيعازارَ بْنِ هارُونَ الكاهِنِ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«أحصِيا كُلَّ بَني إسْرائِيلَ بِحَسَبِ عَشائِرِهِمْ كُلَّ الرِّجالِ مِنْ سِنِّ عِشرِينَ سَنَةً فَما فَوْقُ، الَّذِينَ يَستَطِيعُونَ الخِدمَةَ فِي الجَيشِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","فَتَكَلَّمَ مُوسَى وَألِيعازارُ إلَى بَني إسْرائِيلَ فِي سُهُولِ مُوآبَ بِقُربِ نَهرِ الأُردُنِّ إلَى الشَّرقِ مِنْ أرِيحا فِي الجِهَةِ الأُخرَى لِلنَّهرِ فَقالا: ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«أحْصُوا كُلَّ الرِّجالِ مِنْ سِنِّ عِشرِينَ سَنَةً فَما فَوْقُ، كَما أمَرَ اللهُ مُوسَى وَبَني إسْرائِيلَ حِينَ خَرَجُوا مِنْ أرْضِ مِصرَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","كانَ رَأُوبَيْنُ بِكرَ إسْرائِيلَ. هَؤُلاءِ هُمْ نَسلُ رَأُوبَيْنَ: مِنْ حَنُوكَ عَشِيرَةُ الحَنُوكِيِّينَ. وَمِنْ فَلُّو عَشِيرَةُ الفَلُّوِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","وَمِنْ حَصرُونَ عَشِيرَةُ الحَصرُونِيِّينَ. وَمِنْ كَرمِي عَشِيرَةُ الكَرمِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","هَذِهِ هِيَ عَشائِرُ رَأُوبَيْنَ. وَكانَ عَدَدُ المُسَجَّلِينَ ثَلاثَةً وَأربَعِينَ ألفاً وَسَبعَ مِئَةٍ وَثَلاثِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","وَكانَ لِفَلُّو ابْنٌ هُوَ ألِيآبُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","وَأبناءُ ألِيآبُ هُمْ نَمُوئِيلُ وَداثانُ وَأبِيرامُ. وَداثانُ وَأبِيرامُ هُما المَدعُوّانِ مِنَ الشَّعبِ اللَّذانِ تَمَرَّدا عَلَى مُوسَى وَهارُونَ مَعَ أتباعِ قُورَحَ حِينَ تَمَرَّدُوا عَلَى اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","إذْ فَتَحَتِ الأرْضُ فَمَها وَابتَلَعَتْهُمْ، فَماتُوا مَعَ قُورَحَ وَجَماعَتِهِ. أكَلَتِ النّارُ مِئَتَينِ وَخَمْسِينَ رَجُلاً، فَصارُوا مَثَلاً لِلشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","وَأمّا أبناءُ قُورَحَ فَلَمْ يَمُوتُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","وَهَؤُلاءِ هُمْ نَسلُ شِمعُونَ بِحَسَبِ عَشائِرِهِمْ: مِنْ نَمُوئِيلَ عَشِيرَةُ النَّمُوئِيلِيِّينَ. وَمِنْ يامِينَ عَشِيرَةُ اليامِنِيِّينَ. وَمِنْ ياكِينَ عَشِيرَةُ الياكِينِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","وَمِنْ زارَحَ عَشِيرَةُ الزّارَحِيِّينَ. وَمِنْ شَاوُلَ عَشِيرَةُ الشَّؤُولِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","هَذِهِ هِيَ عَشائِرُ شِمعُونَ: اثْنانِ وَعِشرُونَ ألفاً وَمِئَتانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","وَهَؤُلاءِ هُمْ نَسلُ جادَ بِحَسَبِ عَشائِرِهِمْ: مِنْ صِفُونَ عَشِيرَةُ الصِّفُونِيِّينَ. وَمِنْ حَجِّي عَشِيرَةُ الحَجِّيِّينَ. وَمِنْ شُونِي عَشِيرَةُ الشُّونِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","وَمِنْ أُزنِي عَشِيرَةُ الأُزنِيِّينَ. وَمِنْ عِيرِي عَشِيرَةُ العِيرّيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","وَمِنْ أرُودَ عَشِيرَةُ الأرُودِيِّينَ. وَمِنْ أرئِيلِي عَشِيرَةُ الأرئِيلِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","هَذِهِ هِيَ عَشائِرُ جادَ. وَكانَ عَدَدُ المُسَجَّلِينَ أربَعِينَ ألفاً وَخَمسَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","وَكانَ عِيرُ وَأُونانُ ابنَينِ لِيَهُوذا، وَقَدْ ماتا فِي أرْضِ كَنعانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","وَهَؤُلاءِ هُمْ نَسلُ يَهُوذا بِحَسَبِ عَشائِرِهِمْ: مِنْ شِيلَةَ عَشِيرَةُ الشِّيلِيِّينَ. وَمِنْ فارَصَ عَشِيرَةُ الفارَصِيِّينَ. وَمِنْ زارَحَ عَشِيرَةُ الزّارْحِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","وَهَؤُلاءِ هُمْ نَسلُ فارَصَ: مِنْ حَصرُونَ عَشِيرَةُ الحَصرُونِيِّينَ. وَمِنْ حامُولَ عَشِيرَةُ الحامُولِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","هَذِهِ هِيَ عَشائِرُ يَهُوذا. وَكانَ عَدَدُ المُسَجَّلِينَ سِتَّةً وَعِشرِينَ ألفاً وَخَمسَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","وَهَؤُلاءِ هُمْ نَسلُ يَسّاكَرَ بِحَسَبِ عَشائِرِهِمْ: مِنْ تُولاعَ عَشِيرَةُ التُّولاعِيِّينَ. وَمِنْ فُوَّةَ عَشِيرَةُ الفُوِّيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","وَمِنْ ياشُوبَ عَشِيرَةُ الياشُوبِيِّينَ. وَمِنْ شِمرُونَ عَشِيرَةُ الشِّمرُونِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","هَذِهِ هِيَ عَشائِرُ يَسّاكَرَ. وَكانَ عَدَدُ المُسَجَّلِينَ أربَعَةً وَسِتِّينَ ألفاً وَثَلاثَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","وَهَؤُلاءِ هُمْ نَسلُ زَبُولُونَ بِحَسَبِ عَشائِرِهِمْ: مِنْ سارَدَ عَشِيرَةُ السّارَدِيِّينَ. وَمِنْ إيلُونَ عَشِيرَةُ الإيلُونِيِّينَ. وَمِنْ ياحِلْئِيلَ عَشِيرَةُ الياحِلْئِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","هَذِهِ هِيَ عَشائِرُ زَبُولُونَ. وَكانَ عَدَدُ المُسَجَّلِينَ سِتِّينَ ألفاً وَخَمسَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","وَكانَ مَنَسَّى وَأفرايِمُ ابْنَي يُوسُفَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","وَهَؤُلاءِ هُمْ نَسلُ مَنَسَّى بِحَسَبِ عَشائِرِهِمْ: مِنْ ماكِيرَ عَشِيرَةُ الماكِيرِيِّينَ. وَكانَ ماكِيرُ أبا جِلْعادَ. وَمِنْ جِلْعادَ عَشِيرَةُ الجِلْعادِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","وَهَؤُلاءِ هُمْ نَسلُ جِلْعادَ: مِنْ إيعَزَرَ عَشِيرَةُ الإيعَزَرَيِّينَ. وَمِنْ حالَقَ عَشِيرَةُ الحالَقِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","وَمِنْ إسْرائِيلَ عَشِيرَةُ الإسْرائِيلِيِّينَ. وَمِنْ شَكَمَ عَشِيرَةُ الشَّكمِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","وَمِنْ شَمِيداعَ عَشِيرَةُ الشَّمِيداعِيِّينَ. وَمِنْ حافَرَ عَشِيرَةُ الحافَرِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","وَكانَ صَلُفْحادُ ابناً لِحافَرَ، وَلَمْ يَكُنْ لَهُ أبناءٌ ذُكُورٌ، لَكِنْ كانَتْ لَهُ بَناتٌ. وَأسْماءُ بَناتِ صَلُفْحادَ مَحلَةُ وَنُوعَةُ وَحُجلَةُ وَمِلْكَةُ وَتِرْصَةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","هَذِهِ هِيَ عَشائِرُ مَنَسَّى. وَكانَ عَدَدُ المُسَجَّلِينَ اثْنَينِ وَخَمْسِينَ ألفاً وَسَبعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","هَؤُلاءِ هُمْ نَسلُ أفْرايِمَ بِحَسَبِ عَشائِرِهِمْ: مِنْ شُوتالَحَ عَشِيرَةَ الشُّوتالِيحِيِّينَ. وَمِنْ باكِرَ عَشِيرَةَ الباكرِيِّينَ. وَمِنْ تاحَنَ عَشِيرَةُ التّاحَنِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","وَكانَ عِيرانُ مِنْ عَشيرَةِ شُوتالَحَ. وَمِنْ عِيرانَ عَشِيرَةُ العِيرانِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","هَذِهِ هِيَ عَشائِرُ أفْرايِمَ. وَكانَ عَدَدُ المُسَجَّلِينَ اثْنَينِ وَثَلاثِينَ ألْفاً وَخَمْسَ مِئَةٍ. هَؤُلاءِ هُمْ نَسلُ يُوسُفَ بِحَسَبِ عَشائِرِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","وَهَؤُلاءِ هُمْ نَسلُ بَنْيامِيْنَ بِحَسَبِ عَشائِرِهِمْ: مِنْ بالَعَ عَشِيرَةُ البالَعِيِّينَ. وَمِنْ أشبِيلَ عَشِيرَةُ الأشبِيلِيِّينَ. وَمِنْ أحِيرامَ عَشِيرَةُ الأحِيرامِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","وَمِنْ شَفُوفامَ عَشِيرَةُ الشَّفُوفامِيِّينَ. وَمِنْ حُوفامَ عَشِيرَةُ الحُوفامِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","وَكانَ أرْدُ وَنُعْمانُ ابْنَي بالَعَ. وَمِنْ أرْدَ عَشِيرَةُ الأردِيِّينَ. وَمِنْ نُعمانَ عَشِيرَةُ النُّعمانِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","هَذِهِ هِيَ عَشائِرُ بَنْيامِيْنَ. وَكانَ عَدَدُ المُسَجَّلِينَ خَمسَةً وَأربَعِينَ ألفاً وَسِتَّ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","وَهَؤُلاءِ هُمْ نَسلُ دانَ بِحَسَبِ عَشائِرِهِمْ: مِنْ شُوحامَ عَشِيرَةُ الشُّوحامِيِّينَ. هَؤُلاءِ هُمْ نَسلُ دانَ بِحَسَبِ عَشائِرِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","وَكانَ عَدَدُ المُسَجَّلِينَ أربَعَةً وَسِتِّينَ ألفاً وَأربَعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","وَهَؤُلاءِ هُمْ نَسلُ أشِيرَ بِحَسَبِ عَشائِرِهِمْ: مِنْ يِمْنَةَ عَشِيرَةُ اليِمْنِيِّينَ. وَمِنْ يِشْوِي عَشِيرَةُ اليِشْوِيِّينَ. وَمِنْ بَرِيعَةَ عَشِيرَةُ البَرِيعِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","وَنَسلُ بَرِيعَةَ هُمْ: مِنْ حابِرَ عَشِيرَةُ الحابِرِيِّينَ. وَمِنْ مَلْكِيئِيلَ عَشِيرَةُ المَلْكِيئِيلِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","وَكانَتْ لأشِيرَ ابْنَةٌ اسْمُها سارَحُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","هَذِهِ هِيَ عَشائِرُ أشِيرَ. وَكانَ عَدَدُ المُسَجَّلِينَ ثَلاثَةً وَخَمْسِينَ ألفاً وَأربَعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","وَهَؤُلاءِ هُمْ نَسلُ نَفتالِي بِحَسَبِ عَشائِرِهِمْ: مِنْ ياحَصْئِيلَ عَشِيرَةُ الياحَصْئِيلِيِّينَ. وَمِنْ جُونِي عَشِيرَةُ الجُونِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","وَمِنْ يَصَرَ عَشِيرَةُ الِيَصَرِيِّينَ. وَمِنْ شِلِّيمَ عَشِيرَةُ الشِّلِّيمِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","هَذِهِ هِيَ عَشائِرُ نَفتالِي. وَكانَ عَدَدُ المُسَجَّلِينَ خَمسَةً وَأربَعِينَ ألفاً وَأربَعَ مِئَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","فَكانَ بِذَلِكَ عَدَدُ المُسَجَّلِينَ مِنْ بَني إسْرائِيلَ سِتَّ مِئَةِ ألفٍ وَألْفاً وَسَبعَ مِئَةٍ وَثَلاثِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«سَتُقَسَّمُ الأرْضُ بَينَ هَؤُلاءِ بِحَسَبِ عَدَدِ أسمائِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","لِلمَجمُوعَةِ الكَبِيرَةِ أعطِ حِصَّةً كَبِيرَةً، وَلِلمَجمُوعَةِ الصَّغِيرَةِ أعطِ حِصَّةً صَغِيرَةً. فَلتَتَناسَبِ الحِصَصُ مَعَ عَدَدِ المُسَجَّلِينَ مِنْ كُلِّ مَجمُوعَةٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","لَكِنَّ مَوقِعَ الأرْضِ يَتِمُّ تَعيِينُهُ بِالقُرعَةِ، فَسَيَمتَلِكُونَ الأرْضَ بِحَسَبِ أسْماءِ آباءِ قَبائِلِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","وَسَيَتِمُّ تَعيِينُ حِصَّةِ كُلِّ عَشِيرَةٍ بِإلقاءِ القُرْعَةِ، سَواءٌ أكانَتْ حِصَّةً كَبِيرَةً أمْ صَغِيرَةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","وَهَؤُلاءِ هُمُ اللّاوِيُّونَ الَّذِينَ تَمَّ إحصاؤُهُمْ بِحَسَبِ عَشائِرِهِمْ: مِنْ جَرشُونَ عَشِيرَةُ الجَرشُونِيِّينَ. مِنْ قَهاتَ عَشِيرَةُ القَهاتِيِّينَ. مِنْ مَرارِي عَشِيرَةُ المَرارِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","وَهَذِهِ هِيَ عَشائِرُ لاوِي: عَشِيرَةُ اللِّبْنِيِّينَ، وَعَشِيرَةُ الحَبرُونِيِّينَ، وَعَشِيرَةُ المَحلِيِّينَ، وَعَشِيرَةُ المُوشِيِّينَ، وَعَشِيرَةُ القُورَحِيِّينَ. وَكانَ قَهاتُ وَالِدَ عَمرامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","وَكانَ اسْمُ زَوجَةِ عَمْرامَ يُوكابَدَ. وَهِيَ مِنْ نَسلِ لاوِي، وُلِدَتْ لَهُ فِي مِصرَ. وَوَلَدَتْ يُوكابَدُ لِعَمْرامَ هارُونَ وَمُوسَى وَأُختَهُما مَريَمُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","وَكانَ نادابُ وَأبِيهُو وَألِيعازارُ وَإيثامارُ أبناءَ هارُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","وَماتَ نادابُ وَأبِيهُو حِينَ قَدَّما ناراً غَيرَ مَسمُوحٍ بِها فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","وَكانَ عَدَدُ المُسَجَّلِينَ مِنَ اللّاوِيِّينَ، أي كُلُّ الذُّكُورِ مِنْ سِنِّ شَهرٍ فَما فَوْقُ، ثَلاثَةً وَعِشرِينَ ألفاً. وَلَمْ يَتِمَّ إحصاءُ اللّاوِيِّينَ مَعَ بَقِيَّةِ بَني إسْرائِيلَ، لأنَّهُمْ لَمْ يُعطَوا حِصَّةً مِنَ الأرْضِ مَعَ بَقِيَّةِ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","هَؤُلاءِ هُمُ الرِّجالُ الَّذِينَ أحصاهُمْ مُوسَى وَألِيعازارُ الكاهِنُ، حِينَ أحصَيا بَني إسْرائِيلَ فِي سُهُولِ مُوآبَ بِجانِبِ نَهرِ الأُردُنِّ، إلَى الشَّرقِ مِنْ أرِيحا مِنَ الجِهَةِ الأُخرَى لِلنَّهرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","وَمِنْ بَينِ هَؤُلاءِ، لَمْ يَكُنْ هُناكَ أيُّ واحِدٍ مِمَّنْ أحصاهُمْ مُوسَى وَهارُونُ حِينَ أحصَيا بَني إسْرائِيلَ فِي بَرِّيَّةِ سِيناءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","فَاللهُ قالَ بِشَأنِهِمْ: «سَيَمُوتُونَ فِي الصَّحْراءِ.» فَلَمْ يَبقَ أحَدٌ مِنهُمْ حَيّاً سِوَى كالِبَ بْنَ يَفُنَّةَ وَيَشُوعَ بْنَ نُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","فَتَقَدَّمَتْ بَناتُ صَلُفْحادَ بْنِ حافَرَ بْنِ جِلْعادَ بْنِ ماكِيرَ بْنِ مَنَسَّى، مِنْ قَبِيلَةِ مَنَسَّى بْنِ يُوسُفَ. وَكانَتْ أسْماءُ بَناتِهِ مَحلَةُ وَنُوعَةَ وَحُجلَةَ وَمِلْكَةَ وَتِرْصَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","فَوَقَفْنَ أمامَ مُوسَى وَألِيعازارَ الكاهِنِ وَالرُّؤَساءِ وَكُلِّ الشَّعبِ فِي مَدخَلِ خَيمَةِ الاجْتِماعِ وَقُلْنَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«ماتَ أبونا فِي الصَّحْراءِ وَلَمْ يَكُنْ مَعَ جَماعَةِ قُورَحَ الَّذِينَ تَمَرَّدُوا عَلَى اللهِ، لَكِنَّهُ ماتَ بِسَبَبِ خَطِيَّتِهِ، وَلَمْ يَكُنْ لَدَيهِ أبناءٌ ذُكُورٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","فَلِماذا لا يُذكَرُ اسْمُ أبِينا وَسَطَ عَشِيرَتِهِ لأنَّهُ لَيسَ لَدَيهِ أبناءٌ ذُكُورٌ؟ أعطِنا أرْضاً فِي وَسَطِ عَشِيرَتِنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","فَأتَى مُوسَى بِقَضِيَّتِهِنَّ إلَى اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","فَكَلَّمَ اللهُ مُوسَى وَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«إنَّ طَلَبَ بَناتِ صَلُفْحادَ حَقٌّ وَعادِلٌ. أعْطِهِنَّ أرْضاً يُوَرِّثْنَها لِنَسلِهِنَّ وَسَطَ عَشِيرَتِهِنَّ. أعْطِهِنَّ حَقَّ أبِيهِنَّ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","«وَقُلْ لِبَني إسْرائِيلَ: حِينَ يَمُوتُ رَجُلٌ وَلَيَسَ لَهُ ابْنٌ، أعْطُوا حِصَّتَهُ لِبَناتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","وَإنْ لَمْ يَكُنْ لَهُ بَناتٌ، أعْطُوا حِصَّتَهُ لإخوَتِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","وَإنْ لَمْ يَكُنْ لَهُ إخْوَةٌ، أعْطُوا حِصَّتَهُ لأعمامِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","وَإنْ لَمْ يَكُنْ لأبِيهِ إخْوَةٌ، أعْطُوا الأرْضَ لأقرَبِ أقرِبائِهِ مِنْ عَشِيرَتِهِ فَيَمتَلِكَها. هَذهِ شَريعَةٌ لِبَني إسْرائِيلَ، كَما أمَرَ اللهُ مُوسَى.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","وَقالَ اللهُ لِمُوسَى: «اصعَدْ إلَى هَذا الجَبَلِ فِي مِنْطَقَةِ جِبالِ عَبارِيمَ، وَانظُرِ إلَى الأرْضِ الَّتِي سَأُعطِيها لِبَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","بَعْدَ أنْ تَراها، سَتَنضَمُّ إلَى آبائِكَ، كَما انضَمَّ أخُوكَ هارُونُ إلَى آبائِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","هَذا لأنَّكُما عَصَيتُما أمرِي فِي بَرِّيَّةِ صِينَ حِينَ ثارَ الشَّعبُ عَلَيَّ، وَلَمْ تُكرِمانِي وَتُقَدِّسانِي عِندَ الماءِ أمامَهُمْ.» قَصَدَ بَذَلِكَ مِياهَ مَرِيبَةَ قُرْبَ قادِشَ فِي بَرِّيَّةِ صِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","فَكَلَّمَ مُوسَى اللهَ وَقالَ لَهُ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«اللهُ هُوَ إلَهُ أرْواحِ النّاسِ جَمِيعاً، فَلْيُعَيِّنِ رَجُلاً قائِداً لِهَذا الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","يَقُودُهُمْ فِي الحَربِ وَفِي كُلِّ أُمُورِ حَياتِهِمْ، كَي لا يَكُونَ شَعبُ اللهِ كَقَطِيعِ غَنَمٍ لا راعِيَ لَهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","فَقالَ اللهُ لِمُوسَى: «خُذْ يَشُوعَ بْنَ نُونَ، الرَّجُلَ الَّذِي فيهِ رُوحُ الله، وَضَعْ يَدَكَ عَلَيهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","أوقِفْهُ أمامَ ألِيعازارَ الكاهِنِ وَكُلِّ الشَّعبِ، وَأوصِهِ وَسَلِّمْهُ مَهامَّ القِيادَةِ أمامَ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","«وَامنَحْهُ مِنْ جاهِكَ، كَي يُطِيعَهُ بَنو إسْرائِيلَ وَيَحْتَرِمُونَهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","فَليَقِفْ يَشُوعُ أمامَ ألِيعازارَ الكاهِنِ، وَألِيعازارُ سَيَطلُبُ الإرْشادَ بِمُساعَدَةِ الأُورِيمِ وَالتُّمِّيمِ فِي حَضْرَةِ اللهِ لأجلِ يَشُوعَ. فَبِحَسَبِ أمرِ اللهِ يَخرُجُ يَشُوعُ وَكُلُّ بَنِي إسْرائِيلَ مَعَهُ لِلحَربِ، وَبِحَسَبِ أمرِ اللهِ يَرجِعُونَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","فَفَعَلَ مُوسَى بِحَسَبِ ما أمَرَهُ اللهُ، فَأخَذَ يَشُوعَ وَأوقَفَهُ أمامَ ألِيعازارَ الكاهِنِ وَكُلِّ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","حِينَئِذٍ، وَضَعَ مُوسَى يَدَيهِ عَلَى يَشُوعَ وَأوصاهُ كَما قالَ اللهُ عَنْ طَريقِ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","وَكَلَّمَ اللهُ مُوسَى وَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«أوصِ بَني إسْرائِيلَ وَقُلْ لَهُمْ: احْرِصُوا عَلَى تَقْدِيمِ تَقدِماتِي مِنَ الطَّعامِ المُعَدِّ بِالنَّارِ فِي مَواعيدِهِ المُحَدَّدَةِ، فَرائِحتُهُ تَسُرُّنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","وَقُلْ لَهُمْ: هَذا وَقُودُ النَّارِ الَّذِي تُقَدِّمُونَهُ للهِ: حَمَلانِ عُمْرُ الواحِدِ سَنَةٌ، لا عَيبَ فِيهِما. يُقَدَّمانِ ذَبيحَةً صاعِدَةً كُلَّ يَوْمٍ وَدائِماً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","يُقَدَّمُ حَمَلٌ واحِدٌ فِي الصَّباحِ، وَالثّانِي يُقَدَّمُ بَعْدَ الغُرُوبِ وَقَبلَ حُلُولِ الظَلامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","كَما تُقَدَّمُ عُشْرُ قُفَّةٍ مِنَ الطَّحِينِ النّاعِمِ المَمزُوجِ بِمِقْدارِ وِعاءٍ واحِدٍ مِنَ الزَّيتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","هَذِهِ هِيَ الذَّبيحَةُ الصّاعِدَةُ الدّائِمَةُ المُنتَظَمَةُ الَّتِي بَدَأتْ عَلَى جَبَلِ سِيناءَ، المُتَّقِدَةِ بِالنَّارِ للهِ، وَرائِحتُها تَسُرُّنِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","أمّا السَّكِيبُ المُرافِقُ فَمِقْدارُ وِعاءٍ واحِدٍ مِنَ النَّبيذِ لِكُلِّ حَمَلٍ. وَيُسْكَبُ الشَّرابُ للهِ فِي المَكانِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","وَمِثلَ تَقْدِمَةِ الصَّباحِ، قَدِّمِ الحَمَلَ الثَّانِي بَعْدَ الغُرُوبِ وَقَبلَ حُلُولِ الظَلامِ، كَما فِي الصَّباحِ، وُقُوداً لِلنَّارِ، كَرائِحَةٍ يُسَرُّ بِها اللهُ. وَتُقَدِّمُهُ مَعَ سَكِيبٍ مُماثِلٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«وَفِي يَومِ السَّبْتِ، قَدِّمُوا حَمَلَينِ عُمْرُ الواحِدِ سَنَةٌ، لا عَيبَ فِيهِما. مَعَ عُشْرَي القُفَّةِ مِنَ الطَّحِينِ النّاعِمِ المَمزُوجِ بِزَيتٍ. قَدِّمْهُما مَعَ السَّكِيبِ المُناسِبِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ذَبيحَةً صاعِدَةً كُلَّ سَبْتٍ. هَذا عَدا الذَّبائِحِ اليَومِيَّةِ مَعَ سَكيبِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«وَفِي اليَومِ الأوَّلِ مِنْ كُلِّ شَهْرِ، قَدِّمُوا ذَبيحَةً صاعِدَةً للهِ: عِجلَينِ وَكَبْشاً واحِداً وَسَبعَةَ حِملانٍ عُمْرُ الواحِدِ مِنها سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","وَقَدِّمُوا مَعَها ثَلاثَةَ أعشارِ القُفَّةِ مِنَ الطَّحِينِ الجَيِّدِ مَمزُوجاً بِزَيتٍ لِكُلِّ ثَورٍ، وَعُشْرَيّ القُفَّةِ مِنَ الطَّحِينِ الجَيِّدِ مَمزُوجاً بِزَيتٍ لِكُلِّ كَبْشٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","وَعُشْرَ القُفَّةِ مِنَ الطَّحِينِ الجَيِّدِ مَمزُوجاً بِزَيتٍ لِكُلِّ حَمَلٍ. هَذِهِ ذَبيحَةٌ صاعِدَةٌ وُقُوداً لِلنّارِ كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","أمّا السَّكِيبُ المُرافِقُ لَها فَمِقدارُ نِصْفِ وِعاءٍ مِنَ النَّبيذِ لِكُلِّ ثَورٍ، وَثُلُثِ وِعاءٍ لِكُلِّ كَبْشٍ، وَرُبْعِ وِعاءٍ لِكُلِّ حَمَلٍ. هَذِهِ ذَبيحَةٌ صاعِدَةٌ تُقَدَّمُ فِي بِدايَةِ كُلِّ شَهرٍ مِنْ شُهُورِ السَّنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","وَتُقَدِّمُونَ تَيساً واحِداً ذَبِيحَةَ خَطِيَّةٍ. هَذا عَدا الذَّبيحَةِ اليَومِيَّةِ المُنتَظَمَةِ، وَما يُرافِقُها مِنَ السَّكِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«وَفِي اليَومِ الرّابِعَ عَشَرَ مِنَ الشَّهرِ الأوَّلِ تُقَدِّمُونَ ذَبيحَةَ الفِصحِ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","وَيَكُونُ اليَومُ الخامِسَ عَشَرَ مِنَ الشَّهرِ عِيداً. وَلِمُدَّةِ سَبعَةِ أيّامٍ، تَاكُلُونَ خَبْزاً غَيرَ مُخْتَمِرٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","فِي اليَومِ الأوَّلِ، يَكُونُ هُناكَ اجتِماعٌ مُقَدَّسٌ. وَتَتْرُكُونَ جَمِيعَ أعْمالِكُمْ فِي ذَلِكَ اليَوْمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","قَدِّمُوا وَقُوداً لِلنّارِ ذَبيحَةً صاعِدَةً للهِ مِنْ عِجلَينِ وَكَبْشٍ واحِدٍ وَسَبعَةِ حِملانٍ عُمْرُ كُلِّ واحِدٍ سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","كَما تُقَدِّمُونَ ما يُرافِقُ ذَلِكَ مِنَ الطَّحِينِ النَّاعِمِ مَمزُوجاً بِزَيتٍ: ثَلاثَةَ أعشارِ القُفَّةِ لِكُلِّ عِجلٍ، وَعُشْرَينِ اثْنينِ لِكُلِّ كَبْشٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","وَعُشْراً واحِداً لِكُلِّ حَمَلٍ مِنَ الحِملانِ السَّبْعَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","وَيَنْبَغِي تَقدِيمُ تَيسٍ ذَبِيْحَةَ خَطِيَّةٍ لِلتَّكفيرِ عَنْ خَطاياكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","هَذا عَدا الذَّبيحَةِ الصَّباحِيَّةِ المُنتَظَمَةِ الصّاعِدَةِ، وَما يُرافِقُها مِنْ تَقْدِمِةِ الطَّحيْنِ وَالتَّقْدِمَةِ السَّائِلَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","«قَدِّمُوا هَذِهِ التَّقدِماتِ كُلَّ يَومٍ، لِمُدَّةِ سَبعَةِ أيّامٍ، وُقُوداً لِلنّارِ كَرائِحَةٍ يُسَرُّ بِها اللهُ، مَعَ ما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","وَفِي اليَومِ السّابِعِ، يَكُونُ لَكُمُ اجتِماعٌ مُقَدَّسٌ. وَتَتْرُكُونَ جَمِيعَ أعْمالِكُمْ فِي ذَلِكَ اليَوْمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«وَفِي اليَومِ الَّذِي يُحصَدُ فِيهِ أوَّلُ الزَّرْعِ، عِيدُ الأسابِيعِ، حِينَ تُقَدِّمُونَ للهِ تَقدِمَةً مِنَ القَمحِ الجَدِيدِ للهِ، سَيَكُونُ لَكُمْ تَجَمُّعٌ مُقَدَّسٌ. وَتَتْرُكُونَ جَمِيعَ أعْمالِكُمْ فِي ذَلِكَ اليَوْمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","تُقَدِّمُونَ فِيهِ ذَبيحَةً صاعِدَةً كَرائِحَةٍ يُسَرُّ بِها اللهُ. تُقَدِّمُونَ عِجلَينِ وَكَبْشٍ وَسَبعَةُ حِملانٍ عُمْرُ كُلِّ واحِدٍ مِنهُما سَنَةٌ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","كَما تُقَدِّمُونَ ما يُرافِقُ ذَلِكَ مِنَ الطَّحِينِ النَّاعِمِ مَمزُوجاً بِزَيتٍ: ثَلاثَةَ أعْشارِ القُفَّةِ لِكُلِّ ثَورٍ، وَعُشْرَينِ اثْنَينِ لِكُلِّ كَبْشٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","وَعُشْراً واحِداً لِكُلِّ حَمَلٍ مِنَ الحِملانِ السَّبعَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","وَتُقَدِّمُونَ تَيساً لِلتَّكْفيرِ عَنْ خَطاياكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","هَذا عَدا الذَّبيحَةِ اليَومِيَّةِ المُنتَظَمَةِ، وَما يُرافِقُها مِنَ تَقْدِمَةِ الحُبُوبِ وآلسَّكِيبِ بِمَقاديرِها المُعْتادَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«وَفِي اليَومِ الأوَّلِ مِنَ الشَّهرِ السّابِعِ، يَكُونُ لَكُمُ اجْتِماعٌ مُقَدَّسٌ. تَترُكُونَ جَمِيعَ أعْمالِكُمْ فِيهِ. فَفِي ذَلِكَ اليَومِ تَنْفُخُونَ بِالأبواقِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","وَتُقَدِّمُونَ ذَبائِحَ صَاعِدةً، كَرائِحَةٍ يُسَرُّ بِها اللهُ. فَتُقَدِّمُونَ عِجلاً واحِداً وَكَبْشاً واحِداً وَسَبعَةَ حِملانٍ عُمْرُ كُلِّ واحِدٍ مِنها سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","كَما تُقَدِّمُونَ ما يُرافِقُ ذَلِكَ مِنَ الطَّحِينِ النَّاعِمِ مَمزُوجاً بِزَيتٍ: ثَلاثَةَ أعْشارِ القُفَّةِ مِنَ الطَّحيِنِ لِكُلِّ ثَورٍ، وَعُشْرَينِ اثْنَينِ لِكُلِّ كَبْشٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","وَعُشْراً واحِداً لِكُلِّ حَمَلٍ مِنَ الحِملانِ السَّبعَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","كَما تُقَدِّمُونَ تَيساً واحِداً ذَبِيْحَةَ خَطِيَّةٍ لِلتَّكفيرِ عَنْ خَطاياكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","هَذا عَدا الذَّبيحَةِ الشَّهرِيَّةِ المُنتَظَمَةِ، وَالذَّبيحَةِ اليَومِيَّةِ المُنتَظَمَةِ وَما يُرافِقُهما مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ بِمَقاديرِها المُعْتادَةِ، كَرائِحَةٍ يُسَرُّ بِها اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«وَفِي اليَومِ العاشِرِ مِنَ الشَّهرِ السّابِعِ، يَكُونُ لَكُمْ تَجَمُّعٌ مُقَدَّسٌ خاصٌّ. وَفِيهِ تَتَذَلَّلُونَ بِالصَومِ وَالمَلابِسِ البَسيطَةِ، وَلا تَعمَلُونَ أيَّ عَمَلٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","لَكِنْ تُقَدِّمُونَ ذَبائِحَ صَاعِدَةً للهِ، كَرائِحَةٍ يُسَرُّ بِها. فَتُقَدِّمُونَ عِجلاً واحِداً وَكَبْشاً واحِداً وَسَبعَةَ حِملانٍ عُمْرُ كُلِّ واحِدٍ مِنها سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","كَما تُقَدِّمُونَ تَقدِماتِ حُبُوبٍ مَعَ الذَّبائِحِ الصَّاعِدَةِ، مِنَ الطَّحِينِ الجَيِّدِ مَمزُوجاً بِزَيتٍ. تُقَدِّمُونَ ثَلاثَةَ أعْشارِ القُفَّةِ لِكُلِّ ثَورٍ، وَعُشْرَينِ اثْنَينِ لِكُلِّ كَبْشٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","وَعُشْراً واحِداً لِكُلِّ حَمَلٍ مِنَ الحِملانِ السَّبعَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","كَما تُقَدِّمُونَ تَيساً واحِداً ذَبِيْحَةَ خَطِيَّةٍ لِلتَّطهِيرِ. تُقَدِّمُونَ هَذِهِ الذَّبائِحَ مَعَ ذَبيحَةِ اليَومِ الأوَّلِ مِنَ الشَّهرِ، وَمَعَ تَقدِمَةِ الحُبُوبِ المُرافِقَةِ لَها. وَمَعَ الذَّبيحَةِ اليَومِيَّةِ، وَتَقدِمَةِ الحُبُوبِ المُرافِقَةِ لَها وَالسَكِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«وَفِي اليَومِ الخامِسَ عَشَرَ مِنَ الشَّهرِ السّابِعِ، يَكُونُ لَكُمُ اجتِماعٌ مُقَدَّسٌ. وَتَتْرُكُونَ جَمِيعَ أعْمالِكُمْ فِي ذَلِكَ اليَوْمِ. تَحتَفِلُونَ بِعِيدِ اللهِ لِسَبعَةِ أيّامٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","وَفِي هَذا اليَومِ، قَدِّمُوا ذَبائِحَ صَاعِدَةً للهِ، كَرائِحَةٍ يُسَرُّ بِها اللهُ. قَدِّمُوا ثَلاثَةَ عَشَرَ عِجلاً وَكَبْشَينِ وَأربَعَةَ عَشَرَ حَمَلاً عُمْرُ كُلِّ واحِدٍ مِنها سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","كَما تُقَدِّمُونَ ما يُرافِقُ ذَلِكَ مِنَ الطَّحِينِ النَّاعِمِ مَمزُوجاً بِزَيتٍ: ثَلاثَةَ أعشارِ القُفَّةِ لِكُلِّ ثَورٍ مِنَ العُجُولِ الثَّلاثَةَ عَشَرَ، وَعُشْرَينِ اثْنينِ لِكُلِّ كَبْشٍ مِنَ الكَبْشَينِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","وَعُشْراً واحِداً لِكُلِّ حَمَلٍ مِنَ الحِملانِ الأربَعَةَ عَشَر. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","كَما تُقَدِّمُونَ تَيساً واحِداً ذَبِيحَةَ خَطِيَّةٍ. هَذا عَدا الذَّبيحَةِ اليَومِيَّةِ المُنتَظَمَةِ، وَما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«وَفِي اليَومِ الثّانِي، قَدِّمُوا اثْنَي عَشَرَ عِجلاً وَكَبْشَينِ وَأربَعَةَ عَشَرَ حَمَلاً عُمْرُ كُلِّ واحِدٍ مِنها سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","وَتُقَدِّمُونَ ما يُرافِقُ هَذا مِنْ تَقْدِمَةِ الحُبُوبِ وَالسَّكِيبِ لِلعُجُولِ وِالكَبْشَينِ وَالحِملانِ بِحَسَبِ عَدَدِها كَالعَادَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","وَتُقَدِّمُونَ تَيساً واحِداً ذَبِيحَةَ خَطِيَّةٍ. هَذا عَدا الذَّبيحَةِ اليَومِيَّةِ المُنتَظَمَةِ، وَما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«وَفِي اليَومِ الثّالِثِ، قَدِّمُوا أحَدَ عَشَرَ عِجلاً وَكَبْشَينِ وَأربَعَةَ عَشَرَ حَمَلاً عُمْرُ كُلِّ واحِدٍ مِنها سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","وَتُقَدِّمُونَ ما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ لِلعُجُولِ وِالكَبْشَينِ وَالحِملانِ بِحَسَبِ عَدَدِها كَالعَادَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","وَتُقَدِّمُونَ تَيساً واحِداً ذَبِيحَةَ خَطِيَّةٍ. هَذا عَدا الذَّبيحَةِ اليَومِيَّةِ المُنتَظَمَةِ، وَما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«وَفِي اليَومِ الرّابِعِ، قَدِّمُوا عَشْرَةَ عُجُولٍ وَكَبْشَينِ وَأربَعَةَ عَشَرَ حَمَلاً عُمْرُ كُلِّ واحِدٍ مِنها سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","وَتُقَدِّمُونَ ما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ لِلعُجُولِ وِالكَبْشَينِ وَالحِملانِ بِحَسَبِ عَدَدِها كَالعَادَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","وَتُقَدِّمُونَ تَيساً واحِداً ذَبِيحَةَ خَطِيَّةٍ. هَذا عَدا الذَّبيحَةِ اليَومِيَّةِ المُنتَظَمَةِ، وَما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«وَفِي اليَومِ الخامِسِ، قَدِّمُوا تِسْعَةَ عُجُولٍ وَكَبْشَينِ وَأربَعَةَ عَشَرَ حَمَلاً عُمْرُ كُلِّ واحِدٍ مِنها سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","وَتُقَدِّمُونَ ما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ لِلعُجُولِ وِالكَبْشَينِ وَالحِملانِ بِحَسَبِ عَدَدِها كَالعَادَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","وَتُقَدِّمُونَ تَيساً واحِداً ذَبِيحَةَ خَطِيَّةٍ. هَذا عَدا الذَّبيحَةِ اليَومِيَّةِ المُنتَظَمَةِ، وَما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«وَفِي اليَومِ السّادِسِ، قَدِّمُوا ثَمانِيَةَ عُجُولٍ وَكَبْشَينِ وَأربَعَةَ عَشَرَ حَمَلاً عُمْرُ كُلِّ واحِدٍ مِنها سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","وَتُقَدِّمُونَ ما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ لِلعُجُولِ وِالكَبْشَينِ وَالحِملانِ بِحَسَبِ عَدَدِها كَالعَادَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","وَتُقَدِّمُونَ تَيساً واحِداً ذَبِيحَةَ خَطِيَّةٍ. هَذا عَدا الذَّبيحَةِ اليَومِيَّةِ المُنتَظَمَةِ، وَما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«وَفِي اليَومِ السّابِعِ، قَدِّمُوا سَبْعَةَ عُجُولٍ وَكَبْشَينِ وَأربَعَةَ عَشَرَ حَمَلاً عُمْرُ كُلِّ واحِدٍ مِنها سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","وَتُقَدِّمُونَ ما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ لِلعُجُولِ وِالكَبْشَينِ وَالحِملانِ بِحَسَبِ عَدَدِها كَالعَادَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","وَتُقَدِّمُونَ تَيساً واحِداً ذَبِيحَةَ خَطِيَّةٍ. هَذا عَدا الذَّبيحَةِ اليَومِيَّةِ المُنتَظَمَةِ، وَما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«وَفِي اليَومِ الثّامِنِ، تَتَفَرَّغُونَ لِلعِبادَةِ، فَتَتْرُكُونَ جَمِيعَ أعْمالِكُمْ فِي ذَلِكَ اليَوْمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","وَتُقَدِّمُونَ ذَبيحَةً صاعِدَةً مُعَدَّةً بِالنّارِ كَرائِحَةٍ يُسَرُّ بِها اللهُ: ثَوراً واحِداً وَكَبْشاً وَاحِداً وَسَبعَةَ حِملانٍ عُمْرُ كُلِّ واحِدٍ مِنها سَنَةٌ. وَجَمِيعُها بِلا عَيبٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","وَتُقَدِّمُونَ ما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ لِلثَّورِ وِالكَبْشِ وَالحِملانِ بِحَسَبِ عَدَدِها كَالعَادَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","وَتُقَدِّمُونَ تَيساً واحِداً ذَبِيحَةَ خَطِيَّةٍ. هَذا عَدا الذَّبيحَةِ اليَومِيَّةِ المُنتَظَمَةِ، وَما يُرافِقُها مِنْ تَقْدِمِةِ الحُبُوبِ وَالسَّكِيبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","«قَدِّمُوا هَذِهِ الذَّبائِحَ وَالتَّقدِماتِ للهِ فِي أعيادِكُمْ، بِالإضافَةِ إلَى النُّذُورِ وَالتَّقدِماتِ الاختِيارِيَّةِ مِنْ ذَبائِحَ صاعِدَةٍ وَطَحيْنٍ وَتَقْدِماتٍ سائِلَةٍ وَذَبائِحَ سَلامٍ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","فَتَكَلَّمَ مُوسَى إلَى بَني إسْرائِيلَ بِكُلِّ ما أمَرَهُ اللهُ بِأنْ يَقُولُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","وَقالَ مُوسَى لِرُؤَساءِ قَبائِلِ بَني إسْرائِيلَ: «هَذا هُوَ ما أمَرَ اللهُ بِهِ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","إذا تَعَهَّدَ رَجُلٌ بِنَذْرٍ للهِ، أوْ أقسَمَ فَألْزَمَ نَفْسَهُ بِأمرٍ ما، فَلا يَكْسِرْ كَلامَهُ، بَلْ لِيَفْعَلْ ما نَطَقَ بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","«لَكِنْ إنْ تَعَهَّدَتِ امْرأةٌ بِنَذْرٍ للهِ، أوْ ألْزَمَتْ نَفْسَها بِامْرٍ وَهِيَ ما تَزالُ تَسكُنُ بَيْتَ أبِيها لأنَّها صَغِيرَةٌ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","وَسَمِعَ أبوها نَذْرَها وَما ألْزَمَتْ نَفسَها بِهِ، وَلَمْ يَعتَرِضْ، تَبْقى جَمِيعُ نُذُورِها وَالتِزاماتِها الَّتِي ألْزَمَتْ نَفْسَها بِها ثَابِتَةً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","فَإنْ نَهاها أبوها يَومَ سَمِعَ تَعَهُّداتِها، تَسْقُطُ عَنْها جَمِيعُ نُذُورِها وَالتِزاماتِها الَّتِي ألْزَمَتْ نَفْسَها بِها، وَاللهُ سَيَغفِرُ لَها، لأنَّ أباها نَهاها عَنْ ذَلِكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","«لَكِنْ إنْ تَزَوَّجَتْ بَعدَ أنْ نَذَرَتْ نِذراً أو تَعَهَّدَتْ بِأمرٍ مُعَيَّنٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","وَسَمِعَ زَوجُها وَلَمْ يَعتَرِضْ عِندَما سَمِعَها، فَعَلَيها الوَفاءُ بِنُذُورِها وَالالتِزامُ بِما تَعَهَّدَتْ بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","فَإنْ عَبَّرَ زَوجُها عَنْ عَدَمِ مُوافَقَتِهِ حِينَ سَمِعَ كَلامَها، فَعَلَيها أنْ تُلغِي نِذرَها الَّذِي التَزَمَتْ بِهِ، وَتَعَهُّدَها الَّذِي نَطَقَتْ بِهِ، وَاللهُ سَيَغفِرُ لَها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","«كُلُّ نَذْرٍ تَتَعَهَّدُ بِهِ أرمَلَةٌ أوْ مُطَلَّقَةٌ عَلَى نَفسِها، يَنْبَغِي الوَفاءُ بِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","لَكِنْ إنْ تَعَهَّدَتِ امْرأةٌ مُتَزَوِّجَةٌ بِالقِيامِ بِأمرٍ مُعَيَّنٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","وَسَمِعَ زَوجُها عَنِ الأمرِ، وَلَمْ يَقُلْ شَيئاً لَها وَلَمْ يَمنَعْها عَنِ الوَفاءِ بِهِ، فَإنَّها تَكُونُ مُلزَمَةً بِالوَفاءِ بِكُلِّ تَعَهُّداتِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","لَكِنْ إنْ ألغَى زَوجُها تَعَهُّداتِها حِينَ سَمِعَ بِها، فَإنَّها لا تَكُونُ مُطالَبَةً بِالوَفاءِ بِها، إذْ إنَّ زَوجَها ألغَى تَعَهُّداتِها وَاللهُ سَيَغفِرُ لَها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","«وَإذا نَذَرَتِ امْرأةٌ نَذْراَ أوْ تَعَهَّدَت بِالامْتِناعِ عَنْ شَيءٍ، يُمكِنُ لِزَوجِها أنْ يَسمَحَ لَها بِالوَفاءِ بِما تَعَهَّدَتْ بِهِ، أوْ يُمكِنُهُ إلغاؤُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","فَإنْ لَمْ يَقُلْ زَوجُها شَيئاً حَتَّى اليَومِ التّالِي، فَهُوَ قَدْ أيَّدَ نُذُورَها أوَ تَعَهُّداتِها الَّتِي التَزَمَتْ بِها. فَهُوَ قَدْ وافَقَ بِصَمتِهِ وَعَدَمِ اعتِراضِهِ بَعَدَ أنْ سَمِعَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","لَكِنْ إنْ ألغَى زَوجُها كُلَّ تَعَهُّداتِها بَعدَ سَماعِهِ بِها، هُوَ مَنْ يَتَحَمَّلُ جَزاءَ ذَنبِها.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","هَذِهِ هِيَ القَواعِدُ الَّتِي أعطاها اللهُ لِمُوسَى بِشَأنِ عَلاقَةِ الزَّوجِ بِزَوجَتِهِ، وَالأبِ بابْنَتِهِ السّاكِنَةِ فِي بَيتِهِ قَبلَ زَواجِها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«انتَقِمْ لِبَنِي إسْرائِيلَ مِنَ المِديانِيِّينَ بِسَبَبِ ما عَمِلُوهُ بِبَني إسْرائِيلَ. وَبَعدَ ذَلِكَ تَمُوتُ وَتَنضَمُّ إلَى آبائِكَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","فَقالَ مُوسَى لِلشَّعبِ: «اختارُوا بَعضاً مِنْ رِجالِكُمْ لِيُهاجِمُوا مِديانَ وَيُعاقِبُوهُمْ عَلَى ما عَمِلُوا ضِدَّ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","فأرْسِلُوا فِي هَذِهِ الحَملَةِ ألفَ رَجُلٍ مِنْ كُلِّ قَبِيلَةٍ مِنْ قَبائِلِ إسْرائِيلَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","وَهَكَذا تَمَّ حَشدُ ألفِ رَجُلٍ مِنْ كُلِّ عَشِيرَةٍ مِنْ أُلُوفِ إسْرائِيلَ. تَمَّ اختِيارُ اثْنَي عَشَرَ ألفَ جُندِيٍّ لِهَذِهِ الحَملَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","فَأرسَلَ مُوسَى الألفَ رَجُلٍ مِنْ كُلِّ عَشِيرَةٍ لِهَذِهِ الحَملَةِ مَعَ فِينْحاسَ بْنِ ألِيعازارَ الكاهِنِ. وَأخَذَ فِينْحاسُ مَعَهُ آنِيَةَ المَكانِ المُقَدَّسِ وَالأبواقَ لإعطاءِ الإشاراتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","فَحارَبُوا مِديانَ كَما أمَرَ اللهُ مُوسَى، وَقَتَلُوا كُلَّ ذُكُورِهِمُ البالِغِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","وَمِنْ ضِمْنِ مَنْ قَتَلُوهُمْ أوِيُ وَراقَمُ وَصُورُ وَحُورُ وَرابَعُ، مُلُوكُ مِديانَ الخَمسَةُ. كَما قَتَلُوا بَلْعامَ بْنَ بَعُورَ بِالسَّيفِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","وَسَبَى بَنُو إسْرائِيلَ نِساءَ مِديانَ وَأطفالَهُمْ، كَما اغتَنَمُوا كُلَّ حَيواناتِهِمْ وَثَروَتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","وَأحرَقَ بَنُو إسْرائِيلَ كُلَّ مُدُنِ المِديانِيِّينَ حَيثُ كانُوا يَسكُنُونَ مَعَ كُلِّ مُخَيَّماتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","وَجَمَعُوا كُلَّ ما أخَذُوهُ فِي الحَربِ، بِما فِي ذَلِكَ النّاسَ وَالحَيواناتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ثُمَّ أحضَرُوا الأسْرَى وَالسَبْيَ وَالْغَنائِمَ إلَى مُوسَى وَألِيعازارَ الكاهِنِ وَإلَى كُلِّ بَني إسْرائِيلَ فِي المُخَيَّمِ فِي سُهُولِ مُوآبَ، بِجِوارِ نَهرِ الأُردُنِّ، مُقابِلَ أرِيحا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","فَخَرَجَ مُوسَى وَألِيعازارُ الكاهِنُ وَكُلُّ رُؤَساءِ الشَّعبِ لِيَستَقبِلُوهُمْ خارِجَ المُخَيَّمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","وَغَضِبَ مُوسَى جِدّاً عَلَى قادَةِ الجَيشِ، وَعَلَى قادَةِ الألفِ وَقادَةِ المِئَةِ، الَّذِينَ عادُوا مِنَ الحَملَةِ العَسكَرِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","وَقالَ مُوسَى لَهُمْ: «هَلْ تَرَكْتُمُ النِّساءَ حَيّاتٍ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","هَؤُلاءِ هُنَّ اللَّواتِي اتَّبَعْنَ نَصِيحَةَ بَلْعامَ، وَجَعَلْنَ بَنِي إسْرائِيلَ يُخطِئُونَ إلَى اللهِ فِي فَغُورَ. فأدَّى ذَلِكَ إلَى وَباءٍ فَظِيعٍ عَلَى شَعبِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","وَالآنَ، اقتُلُوا كُلَّ طِفلٍ ذَكَرٍ وَكُلَّ امْرأةٍ عاشَرَتْ رَجُلاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","أمّا الفَتَياتُ اللَّواتِي لَمْ يُعاشِرْنَ أحَداً، فَأبقُوا عَلَى حَياتِهِنَّ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","امْكُثُوا خارِجَ المُخَيَّمِ لِسَبعَةِ أيّامٍ. وَكُلُّ واحِدٍ مِنْكُمْ، أوْ مِنَ المُسَبِّبِينَ، قَتلَ شَخْصاً أوْ لَمَسَ جُثَّةَ مَيِّتٍ، فَلْيَتَطَّهَرْ فِي اليَومَينِ الثّالِثِ وَالسّابِعِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","طَهِّرُوا كُلَّ ثَوبٍ، وَكُلَّ شَيءٍ مَصنُوعٍ مِنَ الجِلدِ أوْ شَعرِ الماعِزِ أوْ مِنَ الخَشَبِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ثُمَّ قالَ ألِيعازارُ الكاهِنُ لِلرِّجالِ الَّذِينَ ذَهَبُوا فِي الحَملَةِ: «هَذِهِ هِيَ قاعِدَةُ الشَّرِيعَةِ الَّتِي أعطاها اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","الذَّهَبُ وَالفِضَّةُ وَالبُرونْزُ وَالحَدِيدُ وَالقَصدِيرُ وَالرَّصاصُ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","وَكُلُّ شَيءٍ يَحتَمِلُ النّارَ ضَعُوهُ فِي النّارِ فَيَصِيرَ طاهِراً. لَكِنْ يَنْبَغِي تَطهِيرُهُ أيضاً بِماءِ التَّطهِيرِ. وَكُلُّ ما لا يُمكِنُ وَضعُهُ فِي النّارِ، يُوضَعُ فِي الماءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","وَفِي اليَومِ السّابِعِ، تَغسِلُونَ ثِيابَكُمْ فَتَكُونُونَ طاهِرِينَ. وَبَعدَ هَذا يُمكِنُكُمْ أنْ تَدخُلُوا المُخَيَّمَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«قُمْ أنتَ وَألِيعازارُ الكاهِنُ وَرُؤَساءُ عَشائِرِ الشَّعبِ بِإحصاءِ ما تَمَّ سَبيُهُ مِنَ النّاسِ وَالحَيواناتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","وَوَزِّعُوا غَنائِمَ الحَربِ بِالتَّساوِي: نِصْفاً للجُنُودِ الَّذِينَ شارَكُوا فِي الحَملَةِ العَسكَرِيَّةِ، وَنِصْفاً لِبَقِيَّةِ الشَّعبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","وَخُذُوا ضَرِيبَةً للهِ. فَمِنَ الجُنُودِ الَّذِينَ اشتَرَكُوا فِي الحَملَةِ، خُذُوا واحِداً مِنْ كُلِّ خَمسِ مِئَةٍ: مِنَ النّاسِ وَالبَقَرِ وَالحَمِيرِ وَالغَنَمِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","تُؤخَذُ هَذِهِ الأشياءُ مِنْ نِصْفِ الغَنِيمَةِ، وَتُعطَى لإلِيعازارَ الكاهِنِ كَتَقدِمَةٍ للهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","وَمِنَ النِّصفِ الخاصِّ بِبَني إسْرائِيلَ، خُذُوا واحِداً مِنْ كُلِّ خَمسِينَ: مِنَ النّاسِ وَالبَقَرِ وَالحَمِيرِ وَالغَنَمِ وَكُلِّ الحَيواناتِ، وَأعطُوها لِلّاوِيِّينَ المَسْؤولِينَ عَنْ مَسْكَنِ اللهِ المُقَدَّسِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","فَفَعَلَ مُوسَى وَألِيعازارُ الكاهِنُ حَسَبَ ما أمَرَ اللهُ بِهِ مُوسَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","وَغَنِمَ الجُنُودُ ما يَلِي مِنَ الحَربِ: سِتَّ مِئَةٍ وَخَمساً وَسَبعِينَ ألفاً مِنَ الغَنَمِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","وَاثْنَينِ وَسَبعِينَ ألفاً مِنَ البَقَرِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","وَواحِداً وَسِتِّينَ ألفاً مِنَ الحَمِيرِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","وَاثْنَينِ وَثَلاثِينَ ألفاً مِنَ النّاسِ، أي النِّساءِ اللَّواتِي لَمْ يُعاشِرْنَ رَجُلاً قَطُّ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","وَكانَ النِّصفُ الخاصُّ بِالجُنُودِ ما يَلِي: عَدَدُ الغَنَمِ ثَلاثُ مِئَةٍ وَسَبعَةً وَثَلاثِينَ ألفاً وَخَمسَ مِئَةٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","وَكانَتْ ضَرِيبَةُ اللهِ مِنَ الغَنَمِ سِتَّ مِئَةٍ وَخَمساً وَسَبعِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","وَكانَ عَدَدُ الأبقارِ سِتَّةً وَثَلاثِينَ ألفاً، وَكانَتْ ضَرِيبَةُ اللهِ مِنها اثْنَينِ وَسَبعِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","وَكانَ عَدَدُ الحَمِيرِ ثَلاثِينَ ألفاً وَخَمسَ مِئَةٍ، وَكانَتْ ضَرِيبَةُ اللهِ مِنهُمْ واحِداً وَسِتِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","وَكانَ عَدَدُ النّاسِ سِتَّةَ عَشَرَ ألفاً، وَكانَتْ ضَرِيبَةُ اللهِ مِنهُمُ اثْنَينِ وَثَلاثِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","فَأعطَى مُوسَى الضَّرِيبَةَ، الَّتِي هِيَ حِصَّةُ اللهِ لألِيعازارَ الكاهِنِ، كَما أمَرَهُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","وَكانَ النِّصفُ الخاصُّ بِبَني إسْرائِيلَ وَالَّذِي أُخِذَ مِنَ الجُنُودِ كَما يَلِي: ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","كانَ عَدَدُ الغَنَمِ ثَلاثَ مِئَةٍ وَسَبعَةً وَثَلاثِينَ ألفاً وَخَمسَ مِئَةٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","وَكانَ عَدَدُ الأبقارِ سِتَّةً وَثَلاثِينَ ألفاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","وَعَدَدُ الحَمِيرِ ثَلاثِينَ ألفاً وَخَمسَ مِئَةٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","وَعَدَدُ النّاسِ سِتَّةَ عَشَرَ ألفاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","وَأخَذَ مُوسَى مِنَ النِّصفِ الخاصِّ بِبَني إسْرائِيلَ واحِداً مِنْ كُلِّ خَمسِينَ مِنَ الحَيواناتِ وَالنّاسِ وَأعطاها لِلّاوِيِّينَ المَسْؤولِينَ عَنْ مَسْكَنِ اللهِ المُقَدَّسِ، تَماماً كما أمَرَهُ اللهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ثُمَّ أتَى قادَةُ أقسامِ الجَيشِ إلَى مُوسَى – قادَةُ الألُوفِ وَقادَةُ المِئاتِ – ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","وَقالُوا لِمُوسَى: «نَحنُ خُدّامَكَ قَدْ أحصَينا الجُنُودَ الَّذِينَ كانُوا تَحتَ إمرَتِنا، فَوَجَدْنا أنَّهُ لَمْ يُفقَدْ وَلا رَجُلٌ واحِدٌ مِنّا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","وَلِذا نَأتِي بِتَقدِمَةٍ للهِ مِنَ الأشياءِ المَصنُوعَةِ مِنْ ذَهَبٍ الَّتِي وَجَدَها كُلُّ واحِدٍ فِينا: أربِطَةً لِلسَّواعِدِ وَأساوِرَ وَخَواتِمَ وَأحلاقَ وَقَلائِدَ، تَقدِمَةً اختِيارِيَّةً فِي حَضْرَةِ اللهِ، تَقدِيراً لإنقاذِهِ حَياتَنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","فَأخَذَ مُوسَى وَألِيعازارُ الكاهِنُ الذَّهَبَ مِنهُمْ، كُلَّ الأشياءِ المَصنُوعَةِ مِنَ الذَّهَبِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","فَكانَ وَزنُ الذَّهَبِ الَّذِي رَفَعَهُ قادَةُ الأُلوفِ وَقادَةُ المِئاتِ للهِ سِتَّةَ عَشَرَ ألْفاً وَسَبْعَ مِئَةٍ وَخَمْسِينَ مِثْقالاً. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","وَأخَذَ كُلُّ جُندِيٍّ نَصِيبَهُ مِنَ الغَنِيمَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","فَأخَذَ مُوسَى وَألِيعازارُ الكاهِنُ الذَّهَبَ مِنْ قادَةِ الأُلوفِ وَقادَةِ المِئاتِ، وَأتَيا بِهِ إلَى خَيمَةِ الاجْتِماعِ لِيَكُونَ تَذكاراً لِبَني إسْرائِيلَ فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","وَكانَتْ لِقَبِيلَتَي رَأُوبَيْنَ وَجادَ مَواشٍ كَثِيرَةٌ جِدّاً، وَلِذا رَأيا أرْضَ يَعزِيزَ وَأرْضَ جِلْعادَ جَيِّدَةً لِلمَواشِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","وَلِذا ذَهَبَ الجادِيُّونَ وَالرَّأُوبِنِيُّونَ إلَى مُوسَى وَألِيعازَرَ الكاهِنِ وَرُؤَساءِ الشَّعبِ وَقالُوا لَهُمْ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«الأرْضُ المُحيطَةُ بِبِعَطارُوتَ وَدِيبُونَ وَيَعزِيزَ وَنِمْرَةَ وَحَشبُونَ وَألِعالَةَ وَشَبامَ وَنَبُو وَبَعُونَ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","كُلُّها هَزَمَها اللهُ أمامَ بَنِي إسْرائيلَ. هِيَ أرْضٌ جَيِّدَةٌ لِلمَواشِي. وَنَحنُ، خُدّامَكَ، نَمتَلِكُ مَواشِيَ كَثِيرَةً.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","وَقالوا: «فإنْ حَظِينا بِرِضاكَ، نَحنُ خُدّامَكَ، أعْطِنا هَذِهِ الأرْضَ مُلكاً لَنا. وَلا تُرْغِمْنا عَلَى عُبُورِ نَهْرِ الأُردُنِّ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","فَقالَ مُوسَى لِقَبِيلَتَي جادَ وَرَأُوبَيْنَ: «فَهَلْ يَذهَبُ إخْوَتُكُمْ إلَى الحَربِ بَينَما تَقْعُدُونَ هُنا؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","لِماذا تُثَبِّطُونَ هِمَمِ بَني إسْرائِيلَ عَنِ العُبُورِ إلَى الأرْضِ الَّتِي أعطاها اللهُ لَهُمْ؟ ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","آباؤُكُمْ عَمِلُوا الأمرَ ذاتَهُ حِينَ أرسَلْتُهُمْ مِنْ قادِشَ بَرْنِيعَ لِيَستَكشِفُوا الأرْضَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","فَصَعِدُوا حَتَّى وَصَلُوا إلَى وادِي أشكُولَ، وَاستَكشَفُوا الأرْضَ، لَكِنَّهُمْ ثَبَّطُوا هِمَّةَ بَني إسْرائِيلَ عَنْ دُخُولِ الأرْضِ الَّتِي أعطاها اللهُ لَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","فَغَضِبَ اللهُ جِدّاً فِي ذَلِكَ اليَومِ، وَأقسَمَ وَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‹لَنْ يَرَى أحَدٌ مِنَ الخارِجِينَ مِنْ مِصرَ، البالِغِينَ عِشرِينَ سَنَةً فَما فَوْقُ، الأرْضَ الَّتِي وَعَدْتُ بِأنْ أُعْطِيَها لإبراهِيمَ وَإسْحاقَ وَيَعقُوبَ، لأنَّهُمْ لَمْ يَكُونُوا أُمَناءَ تَماماً مَعِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","لَنْ يَدخُلَ مِنهُمْ إلّا كالِبُ بْنُ يَفُنَّةَ وَيَشُوعُ بْنُ نُونَ، لأنَّهُما كانا أمِينَيْنِ بِالكامِلِ للهِ.› ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","وَغَضِبَ اللهُ عَلَى بَني إسْرائِيلَ، وَجَعَلَهُمْ يَتُوهُونَ فِي الصَّحْراءِ لأربَعِينَ سَنَةً، إلَى أنِ اخْتَفَى كُلُّ الجِيلِ الَّذِي فَعَلَ الشَّرَّ أمامَ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","وَالآنَ، يا نَسلَ الخُطاةِ، قَدْ حَلَلْتُمْ مَحَلَّ آبائِكُمْ لِتَزِيدُوا غَضَبَ اللهِ عَلَى إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","فَإنْ تَوَقَّفْتُمْ عَنِ اتِّباعِهِ، فَإنَّهُ سَيَترُكُ إسْرائِيلَ فِي الصَّحْراءِ لِمُدَّةٍ أطوَلَ، وَبِهَذا تُهلِكُونَ كُلَّ هَذا الشَّعبِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","حِينَئِذٍ، دَنَتْ قَبِيلَتا رَأُوبَيْنَ وَجادَ إلَيهِ وَقالُوا: «لِنَبْنِ حَظائِرَ لِماشِيَتِنا هُنا، وَمُدُناً لأطْفالِنا وَنِسائِنا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","حِينَئِذٍ، سَنَتَسَلَّحُ وَنَسِيرُ أمامَ بَني إسْرائِيلَ إلَى أنْ نَأتِيَ بِهِمْ إلَى مَكانِهِمْ، بَينَما يَسكُنُ أطفالُنا وَنِساؤُنا مُدُناً حَصِينَةً لِحِمايَتِهِمْ مِنَ الشَّعبِ السّاكِنِ فِي الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","لَنْ نَعُودَ إلَى بُيُوتِنا إلَى أنْ يَمتَلِكَ كُلُّ شَخصٍ فِي بَني إسْرائِيلَ حِصَّتَهُ مِنَ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","وَأمّا نَحنُ فَلَنْ نَمتَلِكَ حِصَّةً مَعَهُمْ فِي الجِهَةِ الأُخرَى مِنْ نَهرِ الأُردُنِّ، لأنَّنا سَنَنالُ حِصَّتَنا مِنَ الأرْضِ فِي الجِهَةِ الشَّرقِيَّةِ مِنْ نَهرِ الأُردُنِّ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","فَقالَ مُوسَى لَهُمْ: «إنْ كُنتُمْ سَتَفعَلُونَ هَذا، وَإنْ تَسَلَّحْتُمْ أمامَ اللهِ لِلخُرُوجِ إلَى الحَربِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","وَإنْ عَبَرَ كُلُّ مُتَسَلِّحٍ نَهرَ الأُردُنِّ أمامَ اللهِ إلَى أنْ يَطرُدَ اللهُ كُلَّ أعدائِهِ مِنْ أمامِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","وَحَتَّى يَتِمَّ إخضاعُ الأرْضِ أمامَ اللهِ. حِينَئِذٍ، تَستَطِيعُونَ العَودَةَ إلَى بُيُوتِكُمْ إذْ تَكُونُونَ قَدْ قُمْتُمْ بِواجِبِكُمْ نَحوَ اللهِ وَإسْرائِيلَ، وَسَتَكُونُ هَذِهِ الأرْضُ مُلْكاً لَكُمْ أمامَ اللهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","لَكِنْ إنْ كُنتُمْ لا تَفعَلُونَ هَذا، فَإنَّكُمْ سَتُخطِئُونَ إلَى اللهِ، وَبِالتّالِي كُونُوا عَلَى يَقِينٍ مِنْ أنَّكُمْ سَتُعاقَبُونَ عَلَى خَطِيَّتِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","فابْنُوا مُدُناً لأطفالِكُمْ وَنِسائِكُمْ وَحَظائِرَ لِماشِيَتِكُمْ، وَاعْمَلُوا كُلَّ ما قُلْتُمْ بِأنَّكُمْ سَتَعمَلُونَهُ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","فَقالَتْ قَبِيلَتا جادَ وَرَأُوبَيْنَ: «سَنَفعَلُ، نَحنُ خُدّامَكَ، كَما أمَرَنا سَيِّدُنا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","سَيَبقَى أطفالُنا وَنِساؤُنا وَقُطعانُنا وَماشِيَتُنا فِي مُدُنِ جِلْعادَ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","وَأمّا نَحنُ، خُدّامَكَ، فَسَنَعبُرُ النَّهْرَ مُتَسَلِّحِينَ لِلحَربِ أمامَ اللهِ بِحَسَبِ ما يَقُولُهُ سَيِّدُنا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","حِينَئِذٍ، أوصَى مُوسَى بِخُصُوصِهِمْ ألِيعازارَ الكاهِنَ وَيَشُوعَ بْنَ نُونَ وَرُؤَساءَ قَبائِلِ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","وَقالَ مُوسَى لَهُمْ: «إنْ عَبَرَتْ قَبِيلَتا جادَ وَرَأُوبَيْنَ نَهرَ الأُردُنِّ مَعَكُمْ، بِكُلِّ جُندِيٍّ مُسَلَّحٍ لِلحَربِ أمامَ اللهِ، وَخَضَعَتِ الأرْضُ لَكُمْ، أعْطُوهُمْ أرْضَ جِلْعادَ مُلْكاً لَهُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","لَكِنْ إنْ لَمْ يَعبُرِ المُختارُونَ لِلمُحارَبَةِ مَعَكُمْ، فَلْيَنالوا حِصَّتَهُمْ مَعَكُمْ فِي أرْضِ كَنعانَ فَقَطْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","فَأجابَتْ قَبِيلَتا جادَ وَرَأُوبَيْنَ: «سَنَفعَلُ كُلَّ ما يَقُولُهُ لَنا اللهُ، نَحنُ خُدّامَكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","فَسَيَعبُرُ المُختارُونَ المُتَسَلِّحُونَ مِنّا أمامَ اللهِ إلَى أرْضِ كَنْعانَ، وَلَكِنَّ حِصَّتَنا مِنَ الأرْضِ سَتَكُونُ فِي الجِهَةِ الشَّرقِيَّةِ مِنْ نَهرِ الأُردُنِّ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","فَأعطَى مُوسَى مَملَكَةَ المَلِكِ سِيحُونَ مَلِكِ الأمُورِيِّينَ، وَمَملَكَةَ المَلِكِ عُوجَ، مَلِكِ باشانَ، بِما فِيها الأرْضَ وَالمُدُنَ، لِقَبِيلَةِ جادَ وَقَبيلَةِ رَأُوبَيْنَ وَنِصفِ قَبِيلَةِ مَنَسَّى بْنِ يُوسُفَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","حِينَئِذٍ، أعادَتْ قَبِيلَةُ جادَ بِناءَ دِيبُونَ وَعَطارُوتَ وَعَرُوعِيرَ ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","وَعَطْرُوتَ شُوفانَ وَيَعزِيرَ وَيُجْبَهَةَ ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","وَبَيتَ نِمْرَةَ وَبَيتَ هارانَ كَمُدُنٍ مُحَصَّنَةٍ، كَما بَنُوا حَظائِرَ لِقُطعانِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","وَأعادَتْ قَبِيلَةُ رَأُوبَيْنَ بِناءَ حَشْبُونَ وَألِعالَةَ وَقِرْيَتايِمَ ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","وَنَبُوَ وَبَعلَ مَعُونَ وَسِيمَةَ. وَقَدْ غَيَّرُوا اسْمَيِّ مَدِينَتَي نَبُوَ وَبَعلَ مَعُونَ، بَينَما دَعُوا المُدُنَ الَّتِي أعادُوا بِناءَها بِأسمائِها الأصلِيَّةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","وَذَهَبَتْ عَشِيرَةُ ماكِيرَ بْنِ مَنَسَّى إلَى جِلْعادَ وَأخَذُوها، وَطَرَدُوا كُلَّ الأمُورِيِّينَ الَّذِينَ كانُوا فِي جِلْعادَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","فَأعطَى مُوسَى جِلْعادَ لِعَشِيرَةِ ماكِيرَ بْنِ مَنَسَّى، فَسَكَنَتْ عَشِيرَةُ ماكِيرَ فِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","وَاستَولَتْ عَشِيرَةُ يائِيرَ بِنِ مَنَسَّى عَلَى القُرَى الصَّغِيرَةِ، وَسَمُّوها قُرَى يائِيرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","وَذَهَبَتْ عَشِيرَةُ نُوبَحَ وَأخَذَتْ قَناةَ وَالقُرَى القَرِيبَةَ مِنها، وَدَعُوها بِاسْمِ نُوبَحَ جَدِّهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","هَذِهِ هِيَ مَراحِلُ رِحلَةِ بَني إسْرائِيلَ الَّذِينَ خَرَجُوا مِنْ أرْضِ مِصرَ فِي مَجمُوعاتٍ وَفِرَقٍ تَحتَ قِيادَةِ مُوسَى وَهارُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","وَكَتَبَ مُوسَى أسْماءَ الأماكِنِ الَّتِي بَدَأُوا مِنها رَحَلاتِهِمْ بِحَسَبِ أمرِ اللهِ. وَهَذِهِ هِيَ الأماكِنُ الَّتِي أتَوها وَارْتَحَلُوا مِنها: ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","تَرَكُوا رَعَمْسِيسَ فِي اليَومِ الخامِسَ عَشَرَ مِنَ الشَّهرِ الأوَّلِ. فِي غَدِ الفِصحِ، خَرَجَ بَنو إسْرائِيلَ بِشَجاعَةٍ أمامَ كُلِّ المِصرِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","كانَ المِصرِيُّونَ يَدفِنُونَ أبْكارَهُمُ الَّذِينَ قَتَلَهُمْ اللهُ. وَكانَ اللهُ قَدْ أعلَنَ دَينُونَتَهُ عَلَى آلِهَةِ المِصرِيِّينَ وَعَمِلَ فِيها عَجائِبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","فَتَرَكَ بَنو إسْرائِيلَ رَعَمْسِيسَ وَخَيَّمُوا فِي سُكُّوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","وَتَرَكُوا سُكُّوتَ وَخَيَّمُوا فِي إيثامَ الواقِعَةِ فِي طَرَفِ الصَّحْراءِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","وَتَرَكُوا إيثامَ وَاتَّجَهُوا نَحوَ فَمِ الحِيرُوثِ الواقِعِ إلَى الشَّرقِ مِنْ بَعلِ صَفُّونَ، فَخَيَّمُوا بِقُربِ مَجْدَلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","وَتَرَكُوا فَمَ الحِيرُوثِ وَسارُوا عَبرَ البَحرِ الأحمَرِ إلَى الصَّحْراءِ. وَسافَرُوا لِمُدَّةِ ثَلاثَةِ أيّامٍ فِي بَرِّيَّةِ إيثامَ، وَخَيَّمُوا فِي مارَّةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","وَتَرَكُوا مارَّةَ وَذَهَبُوا إلَى إيلِيمَ. وَفِي إيلِيمَ، كانَ هُناكَ اثنا عَشَرَ نَبعَ ماءٍ وَسَبعُونَ نَخلَةً، فَخَيَّمُوا هُناكَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","وَتَرَكُوا إيلِيمَ وَخَيَّمُوا بِقُربِ البَحرِ الأحمَرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","وَتَرَكُوا البَحرَ الأحمَرَ وَخَيَّمُوا فِي بَرِّيَّةِ صِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","وَتَرَكُوا بَرِّيَّةَ صِينَ وَخَيَّمُوا فِي دُفْقَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","وَتَرَكُوا دُفْقَةَ وَخَيَّمُوا فِي ألُوشَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","وَتَرَكُوا ألُوشَ وَخَيَّمُوا فِي رَفِيدِيمَ، وَلَمْ يَكُنْ هُناكَ ماءٌ لِلشَّعبِ لِيَشرَبُوا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","وَتَرَكُوا رَفِيدِيمَ وَخَيَّمُوا فِي بَرِّيَّةِ سِيناءَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","وَتَرَكُوا بَرِّيَّةَ سِيناءَ وَخَيَّمُوا فِي قَبْرُوتَ هَتَّأوَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","وَتَرَكُوا قَبْرُوتَ هَتَّأوَةَ وَخَيَّمُوا فِي حَضَيرُوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","وَتَرَكُوا حَضَيرُوتَ وَخَيَّمُوا فِي رِثْمَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","وَتَرَكُوا رِثْمَةَ وَخَيَّمُوا فِي رِمُّونَ فارَصَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","وَتَرَكُوا رِمُّونَ فارَصَ وَخَيَّمُوا فِي لِبْنَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","وَتَرَكُوا لِبْنَةَ وَخَيَّمُوا فِي رِسَّةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","وَتَرَكُوا رِسَّةَ وَخَيَّمُوا فِي قُهَيلاتَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","وَتَرَكُوا قُهَيلاتَةَ وَخَيَّمُوا فِي جَبَلِ شافَرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","وَتَرَكُوا جَبَلَ شافَرَ وَخَيَّمُوا فِي حَرادَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","وَتَرَكُوا حَرادَةَ وَخَيَّمُوا فِي مَقْهَيلُوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","وَتَرَكُوا مَقْهَيلُوتَ وَخَيَّمُوا فِي تاحَتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","وَتَرَكُوا تاحَتَ وَخَيَّمُوا فِي تارَحَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","وَتَرَكُوا تارَحَ وَخَيَّمُوا فِي مِثْقَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","وَتَرَكُوا مِثْقَةَ وَخَيَّمُوا فِي حَشْمُونَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","وَتَرَكُوا حَشْمُونَةَ وَخَيَّمُوا فِي مُسِيرُوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","وَتَرَكُوا مُسِيرُوتَ وَخَيَّمُوا فِي بَنِي يَعْقانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","وَتَرَكُوا بَنِي يَعْقانَ وَخَيَّمُوا فِي حُورِ الجَدْجادِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","وَتَرَكُوا حُورَ الجَدْجادِ وَخَيَّمُوا فِي يُطْباتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","وَتَرَكُوا يُطباتَ وَخَيَّمُوا فِي عَبْرُونَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","وَتَرَكُوا عَبْرُونَةَ وَخَيَّمُوا فِي عِصْيُونِ جابِرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","وَتَرَكُوا عِصْيُونَ جابِرَ وَخَيَّمُوا فِي قادَشَ فِي بَرِّيَّةِ صِينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","وَتَرَكُوا قادَشَ وَخَيَّمُوا فِي هُورَ، الجَبَلِ الواقِعِ عَلَى حُدُودِ أرْضِ أدُومَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","وَصَعِدَ هارُونُ الكاهِنُ إلَى جَبَلِ هُورَ بِحَسَبِ أمرِ اللهِ، وَماتَ عَلَيهِ فِي اليَومِ الأوَّلِ مِنَ الشَّهرِ الخامِسِ فِي السَّنَةِ الأربَعِينَ لِخُرُوجِ بَني إسْرائِيلَ مِنْ مِصرَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","وَكانَ هارُونُ قَدْ بَلَغَ مِنَ العُمْرِ مِئَةً وَثَلاثاً وَعِشْرِينَ سَنَةً حِينَ ماتَ عَلَى جَبَلِ هُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","وَسَمِعَ مَلِكُ عَرادَ الكَنعانِيَّ، الَّذِي كانَ يَسكُنُ فِي النَّقَبِ، أنَّ بَنِي إسْرائِيلَ آتٍ نَحوَ بِلادِهِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","فَتَرَكَ بَنُو إسْرائِيلَ جَبَلَ هُورَ وَخَيَّمُوا فِي صَلْمُونَةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","وَتَرَكُوا صَلْمُونَةَ وَخَيَّمُوا فِي فُونُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","وَتَرَكُوا فُونُونَ وَخَيَّمُوا فِي أُوبُوتَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","وَتَرَكُوا أُوبُوتَ وَخَيَّمُوا فِي عَيِّيِ عَبارِيمَ، عَلَى حُدُودِ مُوآبَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","وَتَرَكُوا عَيِّيَ عَبارِيمَ وَخَيَّمُوا فِي دِيبُونَ جادَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","وَتَرَكُوا دِيبُونَ جادَ وَخَيَّمُوا فِي عَلْمُونَ دِبلاتايِمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","وَتَرَكُوا عَلْمُونَ دِبلاتايِمَ وَخَيَّمُوا فِي جِبالِ عَبارِيمَ قُرْبَ نِبُو. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","وَتَرَكَ بَنو إسْرائِيلَ جِبالَ عَبارِيمَ وَخَيَّمُوا فِي سُهُولِ مُوآبَ بِجانِبِ نَهرِ الأُردُنِّ فِي الجِهَةِ الشَّرقِيَّةِ مُقابِلَ مَدِينَةِ أرِيحا. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","وَخَيَّمُوا بِجِوارِ نَهرِ الأُردُنِّ فِي سُهُولِ مُوآبَ فِي بَيتِ يَشِيمُوتَ إلَى آبَلَ شِطِّيمَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","وَكَلَّمَ اللهُ مُوسَى فِي سُهُولِ مُوآبَ بِقُربِ نَهرِ الأُردُنِّ، إلَى الشَّرقِ مِنْ أرِيحا، فَقالَ لَهُ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«قُلْ لِبَني إسْرائِيلَ: حِينَ تَعبُرُونَ نَهرَ الأُردُنِّ إلَى أرْضِ كَنعانَ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","اطْرُدُوا جَمِيعَ الَّذِينَ يَسكُنُونَ فِي تِلْكَ الأرْضِ. حَطِّمُوا كُلَّ تَماثِيلِهِمِ المَنحُوتَةِ وَأوثانِهِمِ المَسبُوكَةِ، وَاهدِمُوا أماكِنَ عِبادَتِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","حِينَئِذٍ، تَمتَلِكُونَ الأرْضَ وَتَسكُنُونَ فِيها، لأنِّي أعطَيتُ هَذِهِ الأرْضَ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","«قَسِّمُوا الأرْضَ بَينَكُمْ بِإلقاءِ القُرَعِ بِحَسَبِ قَبائِلِكُمْ وَعَشائِرِكُمْ. اجعَلُوا حِصَّةَ القَبِيلَةِ الكَبِيرَةِ كَبِيرَةً، وَحِصَّةَ القَبِيلَةِ الصَّغِيرَةِ صَغِيرَةً. وَحَيثُما وَقَعَتِ القُرعَةُ عَلَى أيَّةِ عَشِيرَةٍ، فَإنَّ تِلكَ الأرْضَ تَكُونُ لِتِلكَ القَبِيلَةِ. فَتَنالُونَ حِصَصَكُمْ مِنَ الأرْضِ بِحَسَبِ قَبائِلِكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","«وَإنْ لَمْ تَطرُدُوا النّاسَ السّاكِنِينَ فِي تِلْكَ الأرْضِ، فَإنَّ الباقِينَ مِنهُمْ سَيَكُونُونَ كَالمَخارِزِ فِي عُيُونِكُمْ، وَكالأشواكِ فِي جَوانِبِكُمْ، إذْ سَيُسَبِّبُونَ الضِّيقَ لَكُمْ فِي الأرْضِ الَّتِي سَتَسْكُنُونَها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","حِينَئِذٍ، سَأعمَلُ بِكُمْ كَما خَطَّطْتُ لِلعَمَلِ بِهِمْ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","وَكَلَّمَ اللهُ مُوسَى فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«أبلِغْ هَذا الأمْرَ لِبَني إسْرائِيلَ: سَتَدخُلُونَ أرْضَ كَنعانَ الَّتِي سَتَكُونُ مُلْكاً لَكُمْ. وَهَذِهِ أرْضُ كَنعانَ بِحَسَبِ حُدُودِها: ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","الجِهَةُ الجَنُوبِيَّةُ سَتَكُونُ فِي بَرِّيَّةِ صِينَ قُرْبَ أدُومَ. حُدُودُكُمُ الجَنُوبِيَّةُ سَتَبدَأُ فِي الشَّرقِ مِنَ الطَّرَفِ الجَنُوبِيِّ إلَى بَحْرِ المِلحِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ثُمَّ تَمُرُّ حُدُودُكُمْ إلَى الجَنُوبِ مِنْ مَمَرِّ عَقْرِبِّيمَ ثُمَّ عَبْرَ بَرِّيَّةِ صِينَ، ثُمَّ تَصِلُ إلَى قادَشَ بَرْنِيعَ، ثُمَّ تَستَمِرُّ إلَى حَصَرَ أدّارَ، ثُمَّ تَصِلُ إلَى عَصْمُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","وَمِنْ عَصْمُونَ سَتَتَّجِهُ نَحوَ نَهْرِ مِصرَ حَتَّى تَصِلَ إلَى البَحرِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","وَأمّا حُدُودُكُمُ الغَربِيَّةُ فَسَتَكُونُ شاطِئَ البَحرِ الكَبِيرِ وَساحِلَهُ. هُناكَ تَكُونُ الحُدُودُ الغَربِيَّةُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","وَهَذِهِ هِيَ حُدُودُكُمُ الشَّمالِيَّةُ: مِنَ البَحرِ تَتبَعُونَ خَطّاً إلَى جَبَلِ هُورَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","وَمِنْ جَبَلِ هُورَ تُحَدِّدُونَ الخَطَّ إلَى لِيبُو حَماةَ، ثُمَّ تَتَصِلُّ الحُدُودُ بِمَدينَةِ صَدَدَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","وَتَستَمِرُّ الحُدُودُ الشَّمالِيَّةُ إلَى زِفْرُونَ، وَتَكُونُ نِهايَتُها إلَى حَصَرِ عِينانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","أمّا حُدُودُكُمُ الشَّرقِيَّةُ فَتَبْدأُ مِنْ حَصَرِ عِينانَ وَتَمتّدُّ إلَى شَفامَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","وَمِنْ شَفامَ إلَى رِبلَةَ الواقِعَةِ إلَى الشَّرقِ مِنْ عَينٍ. وَتَستَمِرُّ الحُدُودُ مَعَ التِّلالِ الواقِعَةِ شَرقَ بَحرِ الجَلِيلِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ثُمَّ مَعَ امْتِدادِ نَهرِ الأُردُنِّ وَحَتَّى بَحْرِ المِلْحِ. هَذِهِ هِيَ حُدُودُ أرْضِكُمْ مِنْ كُلِّ الجِهاتِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","فَأعطَى مُوسَى هَذا الأمرَ لِبَني إسْرائِيلَ: «هَذِهِ هِيَ الأرْضُ الَّتِي سَتُقَسِّمُونَها فِيما بَينَكُمْ بِإلقاءِ القُرَعِ. أمَرَ اللهُ بِأنْ تُعطَى هَذِهِ الأرْضُ لِلتِّسْعِ قَبائِلَ وَنِصْفِ القَبِيلَةِ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","لأنَّ قَبِيلَتَيِّ رَأُوبَيْنَ وَجادَ وَنِصفَ قَبِيلَةِ مَنَسَّى قَدْ أخَذُوا حِصَّتَهُمْ مِنَ الأرْضِ بِحَسَبِ عَشائِرِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","فَقَدْ نالَتِ القَبِيلَتانِ وَنِصفُ القَبِيلَةِ حِصَصَهُمْ إلَى الشَّرقِ مِنْ نَهرِ الأُردُنِّ، إلَى الشَّرقِ مِنْ أرِيحا.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","ثُمَّ قالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«هَذانِ الرَّجُلانِ يَقسِمانِ الأرْضَ بَينَكُمْ: ألِيعازارُ الكاهِنُ وَيَشُوعُ بْنُ نُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","وَيُساعِدُهُمْ قائِدٌ مِنْ كُلِّ عَشِيرَةٍ لأجلِ تَقسِيمِ الأرْضِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","وَهَذِهِ هِيَ أسْماءُ هَؤلاءِ القادَةِ: مِنْ قَبِيلَةِ يَهُوذا كالِبُ بْنُ يَفُنَّةَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","وَمِنْ قَبِيلَةِ شِمْعُونَ شَمُوئِيلُ بْنُ عَمِّيهُودَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","وَمِنْ قَبِيلَةِ بَنْيامِيْنَ ألِيدادُ بْنُ كِسلُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","وَمِنْ قَبِيلَةِ دانَ الرَّئِيسُ بُقِّي بْنُ يُجلِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","وَمِنْ نَسلِ يُوسُفَ: مِنْ قَبِيلَةِ مَنَسَّى الرَّئِيسُ حَنِّيئِيلُ بْنُ إيفُودَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","وَمِنْ قَبِيلَةِ أفْرايِمَ الرَّئِيسُ قَمُوئِيلُ بْنُ شِفطانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","وَمِنْ قَبِيلَةِ زَبُولُونَ الرَّئِيسُ ألِيصافانُ بْنُ فَزْناخَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","وَمِنْ قَبِيلَةِ يسّاكِرَ الرَّئِيسُ فَلْطِيئِيلُ بْنُ عَزّانَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","وَمِنْ قَبِيلَةِ أشِيرَ الرَّئِيسُ أخِيهُودُ بْنُ شَلُومِي. ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","وَمِنْ قَبِيلَةِ نَفْتالِي الرَّئِيسُ فَدَهْئِيلُ بْنُ عَمِّيهُودَ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","هَؤُلاءِ هُمُ الرِّجالُ الَّذِينَ أمَرَهُمُ اللهُ بِأنْ يَقْتَسِمُوا أرْضَ كَنعانَ فِيما بَينَ بَني إسْرائِيلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","وَتَكَلَّمَ اللهُ إلَى مُوسَى فِي سُهُولِ مُوآبَ بِقُربِ نَهرِ الأُردُنِّ، فِي الجِهَةِ الشَّرقِيَّةِ مُقابِلَ أرِيحا فَقالَ: ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«أوصِ بَني إسْرائِيلَ بِأنْ يُخَصِّصُوا لِلّاوِيِّينَ مُدُناً لِيَسكُنُوا فِيها مِنَ الأرْضِ الَّتِي أخَذُوها، وَمَراعِيَ حَولَ مُدُنِهِمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","سَتَكُونُ هَذِهِ المُدُنُ لَهُمْ لِلسَّكَنِ، وَالمَراعِي لِماشِيَتِهِمْ وَجَمِيعِ الحَيواناتِ الَّتِي يَملِكُونَها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","سَتَمتَدُّ مَراعِي اللّاوِيِّينَ مِنْ سُورِ المَدِينَةِ مَسافَةَ ألْفِ ذِراعٍ مِنْ كُلِّ الجِهاتِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","قِيسُوا خارِجَ المَدِينَةِ ألفِي ذِراعٍ مِنْ كُلِّ جِهَةٍ: ألفِي ذِراعٍ مِنَ الجِهَةِ الشَّرقِيَّةِ، وَألفِي ذِراعٍ مِنَ الجِهَةِ الجَنُوبِيَّةِ، ألفِي ذِراعٍ مِنَ الجِهَةِ الغَربِيَّةِ، وَألفِي ذِراعٍ مِنَ الجِهَةِ الشَّمالِيَّةِ. فَتَكُونُ المَدِينَةُ فِي الوَسَطِ، وَتَكُونُ هَذِهِ المساحاتُ الإضافِيّةُ مِراعِيَ لِمُدُنِ اللّاوِيِّينَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","«وَمِنْ ضِمنِ المُدُنِ الَّتِي سَتُعطُونَها لِلّاوِيِّينَ، سَتَكُونُ هُناكَ سِتُّ مُدُنٍ لِلُّجُوءِ، يَهرُبَ إلَيها كُلُّ مَنْ يَقتُلُ شَخصاً آخَرَ بِغَيرِ قَصدٍ. وَبِالإضافَةِ إلَى هَذِهِ المُدُنِ السِّتِّ، أعطُوا اللّاوِيِّينَ اثنَتَيْنِ وَأربَعِينَ مَدِينَةً أُخْرَى. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","فَسَيَكُونُ مَجْمُوعُ المُدُنِ الَّتِي يأخُذُونَها ثَمانٍ وَأربَعِينَ مَدِينَةً مَعَ مَراعِيها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","خُذُوا لِلّاوِيِّينَ مِنْ أرْضِ قَبائِلِ بَني إسْرائِيلَ عَدَداً مِنَ المُدُنِ يَتَناسَبُ مَعَ حَجمِ كُلِّ قَبِيلَةٍ. فَتُعْطِي كُلَّ قَبِيلَةٍ مِنْ مُدُنِها لِلّاوِيِّينَ، بِحَسَبِ مَساحَةِ حِصَّتِها مِنَ الأرْضِ.» ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","وَقالَ اللهُ لِمُوسَى: ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«قُلْ لِبَني إسْرائِيلَ: حِينَ تَعبُرُونَ نَهرَ الأُردُنِّ إلَى أرْضِ كَنعانَ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","اخْتارُوا مُدُناً لِتَكُونَ مُدُناً لِلُجُوءِ. فَمَنْ يَقتُلُ شَخْصاً بِغَيرِ قَصدٍ، يُمكِنُهُ الهُرُوبُ إلَى إحدَى هَذِهِ المُدُنِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","فَسَتَكُونُ مُدُناً يَلجأُ إلَيها القَاتِلُ مِنْ قَرِيبِ القَتِيلِ الَّذِي يُريدُ الأخذُ بِالثَّأرِ. وَهَكَذا لا يُقتَلُ القاتِلُ إلَى أنْ يَقِفَ أمامَ الشَّعبِ لِلمُحاكَمَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","فَالمُدُنُ الَّتِي تَخْتارُونَها سَتَكُونُ مُدُنَ لُجُوءٍ لَكُمْ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","اخْتارُوا ثَلاثَ مُدُنٍ شَرقَ نَهرِ الأُردُنِّ، وَثَلاثَ مُدُنٍ فِي أرْضِ كَنْعانَ، لِتَكُونَ مُدُنَ لُجُوءٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","تَكُونُ هَذِهِ المُدُنُ السِّتُّ لِلُجُوءِ بَني إسْرائِيلَ وَالغُرَباءِ السّاكِنِينَ بَينَهُمْ. فَكُلُّ مَنْ يَقتُلُ شَخصاً بِغَيرِ قَصْدٍ، يَهْرُبُ إلَيها. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","«فَإنْ ضَرَبَ شَخصٌ شَخصاً آخَرَ بِأداةٍ مِنْ حَدِيدٍ فَماتَ، فَإنَّ الضّارِبَ يُعتَبَرُ قاتِلاً وَيَنْبَغِي قَتلُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","وَإنْ ضَرَبَهُ بِحَجَرٍ بِيَدِهِ مِمّا سَبَّبَ مَوتَهُ، فَإنَّ الضّارِبَ يُعتَبَرُ قاتِلاً وَيَنْبَغِي قَتلُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","وَإنْ ضَرَبَهُ بِأداةٍ خَشَبِيَّةٍ بِيَدِهِ مِمّا سَبَّبَ مَوتَهُ، فَإنَّ الضّارِبَ يُعتَبَرُ قاتِلاً وَيَنْبَغِي قَتلُهُ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","الَّذي يَثأرُ لِلدَّمِ هُوَ يَقْتُلُ القاتِلَ. عِنْدَما يَلْتَقِيانِ، فَالَّذي يَثأرُ لِلدَّمِ يُنَفِّذُ حُكْمَ الإعْدامِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","«وَكَذَلِكَ إنْ دَفَعَهُ بِسَبِبِ كُرْهِهِ لَهُ، أوْ ألقَى شَيئاً عَلَيهِ عَنْ قَصْدٍ فَماتَ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","أوْ إنْ ضَرَبَهُ بِيدِهِ بِسَبِبِ كُرْهِهِ لَهُ، فَماتَ، فَحِينَئِذٍ، يَنْبَغِي قَتلُهُ لأنَّهُ قاتِلٌ. وَالَّذي يَثأرُ لِلدَّمِ فَقَطْ، هُوَ يَقْتُلُ القاتِلَ عِنْدَما يَلْتَقِيانِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","«وَلَكِنْ إنْ دَفَعَهُ بِغَيرِ قَصدٍ وَمِنْ دُونِ كُرْهٍ، أوْ ألقَى شَيئاً عَلَيهِ بِغَيرِ قَصْدٍ، ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","أوْ أسقَطَ حَجَراً بِغَيرِ قَصدٍ، فَسَقَطَ عَلَيهِ فَماتَ، وَلَيسَ بَينَهُما عَداوَةٌ، وَلَمْ يَقصَدِ الأذَى، ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","سَيَحُكُمُ الشَّعبُ بَينَ القاتِلِ وَالَّذي يَثأرُ لِدَمِ القَتِيلِ بِحَسَبِ هَذِهِ القَواعِدِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","وَيَكُونُ عَلَى الشَّعبِ أنْ يَحمِيَ القاتِلَ مِنْ قَريبِ القَتِيلِ الَّذي يَثأرُ لِدَمِهِ. فَيُعيدُونَهُ إلَى مَدِينَةِ اللُّجُوءِ الَّتِي هَرَبَ إلَيها. فَيَسكُنُ هُناكَ إلَى أنْ يَمُوتَ رَئِيسُ الكَهَنةِ الَّذِي مُسِحَ بِالزَّيتِ المُقَدَّسِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","«لَكِنْ إنْ تَرَكَ القاتِلُ حُدُودَ مَدِينَةِ اللُّجُوءِ الَّتِي هَرَبَ إلَيها، ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","وَوَجَدَهُ الَّذي يَثأرُ لِلدَّمِ خارِجَ مَدِينَةِ اللُّجُوءِ، فَيُمْكِنُ لِلَّذي يَثأرُ لِلدَّمِ أنْ يَقتُلَ القاتِلَ. وَلا يُحْسَبُ مُذنِباً بِجِرِيمَةِ قتلٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","لأنْ عَلَى القاتِلِ أنْ يَبقَى فِي مَدِينَةِ اللُّجُوءِ إلَى مَوتِ رَئِيسِ الكَهَنَةِ. وَبَعْدَ مَوتِ رَئِيسِ الكَهَنَةِ يُمكِنُ لِلقاتِلِ أنْ يَعُودَ إلَى أرْضِهِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","هَذِهِ هِيَ أحكامُ الشَّرِيعَةِ لَكُمْ مِنَ الآنَ فَصاعِداً، حَيثُما كَنتُمْ تَقيمُونَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","«إنْ قَتَلَ أحَدُهُمْ شَخصاً، فَإنَّهُ يُقتَلُ بِشَهادَةِ شُهُودٍ. لَكِنْ لا يَجُوزُ قَتلُ أحَدٍ بِشَهادَةِ شاهِدٍ واحِدٍ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","«لا تَقبَلُوا فِدْيَةً عَنْ حَياةِ القاتِلِ المَحكُومِ عَلَيهِ بِالمَوْتِ، لأنَّهُ يَنبَغِي أنْ يُقتَلَ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","«لا تَقبَلُوا فِدْيةً مِنَ الشَّخصِ الَّذِي هَرَبَ إلَى مَدِينَةِ لُجُوءٍ لِكَي يَعُودَ وَيَسْكُنَ فِي الأرْضِ حَيثُما يَشاءُ. بَلْ يَبقَى هُناكَ إلَى مَوتِ رَئِيسِ الكَهَنَةِ. ");
INSERT INTO arbwbtc_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","فَلا تُفسِدُوا الأرْضَ الَّتِي تَعيشُونَ عَلَيها، فَلا فِديَةَ لِتَحْريرِ الأرْضِ مِنْ جَرِيمَةِ القَتلِ الُمرتَكَبَ