﻿USE sofia;
DROP TABLE IF EXISTS sofia.arbnav_vpl;
CREATE TABLE arbnav_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES arbnav_vpl WRITE;
INSERT INTO arbnav_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","فِي الْبَدْءِ خَلَقَ اللهُ السَّمَاوَاتِ وَالأَرْضَ، ");
INSERT INTO arbnav_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","وَإِذْ كَانَتِ الأَرْضُ مُشَوَّشَةً وَمُقْفِرَةً وَتَكْتَنِفُ الظُّلْمَةُ وَجْهَ الْمِيَاهِ، وَإِذْ كَانَ رُوحُ اللهِ يُرَفْرِفُ عَلَى سَطْحِ الْمِيَاهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","أَمَرَ اللهُ: «لِيَكُنْ نُورٌ». فَصَارَ نُورٌ، ");
INSERT INTO arbnav_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","وَرَأَى اللهُ النُّورَ فَاسْتَحْسَنَهُ وَفَصَلَ بَيْنَهُ وَبَيْنَ الظَّلامِ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","وَسَمَّى اللهُ النُّورَ نَهَاراً، أَمَّا الظَّلامُ فَسَمَّاهُ لَيْلاً. وَهَكَذَا جَاءَ مَسَاءٌ أَعْقَبَهُ صَبَاحٌ، فَكَانَ الْيَوْمَ الأَوَّلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ثُمَّ أَمَرَ اللهُ: «لِيَكُنْ جَلَدٌ يَحْجُزُ بَيْنَ مِيَاهٍ وَمِيَاهٍ». ");
INSERT INTO arbnav_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","فَخَلَقَ اللهُ الْجَلَدَ، وَفَرَّقَ بَيْنَ الْمِيَاهِ الَّتِي تَحْمِلُهَا السُّحُبُ وَالْمِيَاهِ الَّتِي تَغْمُرُ الأَرْضَ. وَهَكَذَا كَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","وَسَمَّى اللهُ الْجَلَدَ سَمَاءً. ثُمَّ جَاءَ مَسَاءٌ أَعْقَبَهُ صَبَاحٌ فَكَانَ الْيَوْمَ الثَّانِي. ");
INSERT INTO arbnav_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ثُمَّ أَمَرَ اللهُ: «لِتَتَجَمَّعِ الْمِيَاهُ الَّتِي تَحْتَ السَّمَاءِ إِلَى مَوْضِعٍ وَاحِدٍ، وَلْتَظْهَرِ الْيَابِسَةُ». وَهَكَذَا كَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","وَسَمَّى اللهُ الْيَابِسَةَ أَرْضاً وَالْمِيَاهَ الْمُجْتَمِعَةَ بِحَاراً. وَرَأَى اللهُ ذَلِكَ فَاسْتَحْسَنَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","وَأَمَرَ اللهُ: «لِتُنْبِتِ الأَرْضُ خُضْرَةً، وَشَجَراً مُثْمِراً فِيهِ بِزْرُهُ الَّذِي يُنْتِجُ ثَمَراً كَجِنْسِهِ فِي الأَرْضِ». وَهَكَذَا كَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","فَأَنْبَتَتِ الأَرْضُ كُلَّ أَنْوَاعِ الأَعْشَابِ وَالْبُقُولِ الَّتِي تَحْمِلُ بُزُوراً مِنْ جِنْسِهَا، وَالأَشْجَارَ الَّتِي تَحْمِلُ أَثْمَاراً ذَاتَ بُذُورٍ حَسَبَ نَوْعِهَا. وَرَأَى اللهُ ذَلِكَ فَاسْتَحْسَنَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","وَجَاءَ مَسَاءٌ أَعْقَبَهُ صَبَاحٌ فَكَانَ الْيَوْمَ الثَّالِثَ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ثُمَّ أَمَرَ اللهُ: «لِتَكُنْ أَنْوَارٌ فِي قُبَّةِ السَّمَاءِ لِتُفَرِّقَ بَيْنَ النَّهَارِ وَاللَّيْلِ، فَتَكُونَ عَلَامَاتٍ لِتَحْدِيدِ أَزْمِنَةٍ وَأَيَّامٍ وَسِنِينَ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","وَتَكُونَ أَيْضاً أَنْوَاراً فِي قُبَّةِ السَّمَاءِ لِتُضِيءَ الأَرْضَ». وَهَكَذَا كَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","وَخَلَقَ اللهُ نُورَيْنِ عَظِيمَيْنِ، النُّورَ الأَكْبَرَ لِيُشْرِقَ فِي النَّهَارِ، وَالنُّورَ الأَصْغَرَ لِيُضِيءَ فِي اللَّيْلِ، كَمَا خَلَقَ النُّجُومَ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","وَجَعَلَهَا اللهُ فِي قُبَّةِ السَّمَاءِ لِتُضِيءَ الأَرْضَ، ");
INSERT INTO arbnav_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","لِتَتَحَكَّمَ بِالنَّهَارِ وَبِاللَّيْلِ وَلِتُفَرِّقَ بَيْنَ النُّورِ وَالظَّلامِ. وَرَأَى اللهُ ذَلِكَ فَاسْتَحْسَنَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","وَجَاءَ مَسَاءٌ أَعْقَبَهُ صَبَاحٌ فَكَانَ الْيَوْمَ الرَّابِعَ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ثُمَّ أَمَرَ اللهُ: «لِتَمْتَلِئِ الْمِيَاهُ بِشَتَّى الْحَيَوَانَاتِ الْحَيَّةِ وَلْتُحَلِّقِ الطُّيُورُ فَوْقَ الأَرْضِ عَبْرَ فَضَاءِ السَّمَاءِ». ");
INSERT INTO arbnav_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","وَهَكَذَا خَلَقَ اللهُ الْحَيَوَانَاتِ الْمَائِيَّةَ الضَّخْمَةَ، وَالْكَائِنَاتِ الْحَيَّةَ الَّتِي امْتَلأَتْ بِها الْمِيَاهُ، كُلًّا حَسَبَ أَجْنَاسِهَا، وَأَيْضاً الطُّيُورَ وَفْقاً لأَنْوَاعِهَا. وَرَأَى اللهُ ذَلِكَ فَاسْتَحْسَنَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","وَبَارَكَهَا اللهُ قَائِلاً: «انْتِجِي، وَتَكَاثَرِي وَامْلإِي مِيَاهَ الْبِحَارِ. وَلْتَتَكَاثَرِ الطُّيُورُ فَوْقَ الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ثُمَّ جَاءَ مَسَاءٌ أَعْقَبَهُ صَبَاحٌ فَكَانَ الْيَوْمَ الْخَامِسَ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ثُمَّ أَمَرَ اللهُ: «لِتُخْرِجِ الأَرْضُ كَائِنَاتٍ حَيَّةً، كُلًّا حَسَبَ جِنْسِهَا، مِنْ بَهَائِمَ وَزَوَاحِفَ وَوُحُوشٍ وَفْقاً لأَنْوَاعِهَا». وَهَكَذَا كَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","فَخَلَقَ اللهُ وُحُوشَ الأَرْضِ، وَالْبَهَائِمَ وَالزَّوَاحِفَ، كُلًّا حَسَبَ نَوْعِهَا. وَرَأَى اللهُ ذَلِكَ فَاسْتَحْسَنَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ثُمَّ قَالَ اللهُ: «لِنَصْنَعِ الإِنْسَانَ عَلَى صُورَتِنَا، كَمِثَالِنَا، فَيَتَسَلَّطَ عَلَى سَمَكِ الْبَحْرِ، وَعَلَى طَيْرِ السَّمَاءِ، وَعَلَى الأَرْضِ، وَعَلَى كُلِّ زَاحِفٍ يَزْحَفُ عَلَيْهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","فَخَلَقَ اللهُ الإِنْسَانَ عَلَى صُورَتِهِ. عَلَى صُورَةِ اللهِ خَلَقَهُ. ذَكَراً وَأُنْثَى خَلَقَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","وَبَارَكَهُمُ اللهُ قَائِلاً لَهُمْ: «أَثْمِرُوا وَتَكَاثَرُوا وَامْلَأُوا الأَرْضَ وَأَخْضِعُوهَا. وَتَسَلَّطُوا عَلَى سَمَكِ الْبَحْرِ، وَعَلَى طَيْرِ السَّمَاءِ وَعَلَى كُلِّ حَيَوَانٍ يَتَحَرَّكُ عَلَى الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ثُمَّ قَالَ لَهُمْ: «إِنِّي قَدْ أَعْطَيْتُكُمْ كُلَّ أَصْنَافِ النَّبَاتَاتِ ذَاتِ الْبُذُورِ الْمُنْتَشِرَةِ عَلَى كُلِّ سَطْحِ الأَرْضِ، وَكُلَّ شَجَرٍ يَحْمِلُ ثَمَراً فِيهِ بُذُورٌ، لِتَكُونَ لَكُمْ طَعَاماً. ");
INSERT INTO arbnav_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","أَمَّا الْعُشْبُ الأَخْضَرُ فَقَدْ جَعَلْتُهُ طَعَاماً لِوُحُوشِ الأَرْضِ وَلِطُيُورِ السَّمَاءِ وَالْحَيَوَانَاتِ الزَّاحِفَةِ، وَلجَمِيعِ الْكَائِنَاتِ الْحَيَّةِ». وَهَكَذَا كَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","وَرَأَى اللهُ مَا خَلَقَهُ فَاسْتَحْسَنَهُ جِدّاً. ثُمَّ جَاءَ مَسَاءٌ أَعْقَبَهُ صَبَاحٌ فَكَانَ الْيَوْمَ السَّادِسُ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","وَهَكَذَا اكْتَمَلَتِ السَّمَاوَاتُ وَالأَرْضُ بِكُلِّ مَا فِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","وَفِي الْيَوْمِ السَّابِعِ أَتَمَّ اللهُ عَمَلَهُ الَّذِي قَامَ بِهِ، فَاسْتَرَاحَ فِيهِ مِنْ جَمِيعِ مَا عَمِلَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","وَبَارَكَ اللهُ الْيَوْمَ السَّابِعَ وَقَدَّسَهُ، لأَنَّهُ اسْتَرَاحَ فِيهِ مِنْ جَمِيعِ أَعْمَالِ الْخَلْقِ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","هَذَا وَصْفٌ مَبْدَئِيٌّ لِلسَّمَاوَاتِ وَالأَرْضِ يَوْمَ خَلَقَهَا الرَّبُّ الإِلَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","وَلَمْ يَكُنْ قَدْ نَبَتَ بَعْدُ فِي الأَرْضِ شَجَرٌ بَرِّيٌّ وَلَا عُشْبٌ بَرِّيٌّ، لأَنَّ الرَّبَّ الإِلَهَ لَمْ يَكُنْ قَدْ أَرْسَلَ مَطَراً عَلَى الأَرْضِ، وَلَمْ يَكُنْ هُنَاكَ إِنْسَانٌ لِيَفْلَحَهَا، ");
INSERT INTO arbnav_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","إلَّا أَنَّ ضَبَاباً كَانَ يَتَصَاعَدُ مِنَ الأَرْضِ فَيَسْقِي سَطْحَهَا كُلَّهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ثُمَّ جَبَلَ الرَّبُّ الإِلَهُ آدَمَ مِنْ تُرَابِ الأَرْضِ وَنَفَخَ فِي أَنْفِهِ نَسَمَةَ حَيَاةٍ، فَصَارَ آدَمُ نَفْساً حَيَّةً. ");
INSERT INTO arbnav_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","وَأَقَامَ الرَّبُّ الإِلَهُ جَنَّةً فِي شَرْقِيِّ عَدْنٍ وَوَضَعَ فِيهَا آدَمَ الَّذِي جَبَلَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","وَاستَنْبَتَ الرَّبُّ الإِلَهُ مِنَ الأَرْضِ كُلَّ شَجَرَةٍ بَهِيَّةٍ لِلنَّظَرِ، وَلَذِيذَةٍ لِلأَكْلِ، وَغَرَسَ أَيْضاً شَجَرَةَ الْحَيَاةِ، وَشَجَرَةَ مَعْرِفَةِ الْخَيْرِ وَالشَّرِّ فِي وَسَطِ الْجَنَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","وَكَانَ نَهْرٌ يَجْرِي فِي عَدْنٍ لِيَسْقِيَ الْجَنَّةَ، وَمَا يَلْبَثُ أَنْ يَنْقَسِمَ مِنْ هُنَاكَ إِلَى أَرْبَعَةِ أَنْهارٍ: ");
INSERT INTO arbnav_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","الأَوَّلُ مِنْهَا يُدْعَى فِيشُونَ، الَّذِي يَلْتَفُّ حَوْلَ كُلِّ الْحَوِيلَةِ حَيْثُ يُوْجَدُ الذَّهَبُ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","وَذَهَبُ تِلْكَ الأَرْضِ جَيِّدٌ، وَفِيهَا أَيْضاً الْمُقْلُ وَحَجَرُ الْجَزْعِ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","وَالنَّهْرُ الثَّانِي يُدْعَى جِيحُونَ الَّذِي يُحِيطُ بِجَمِيعِ أَرْضِ كُوشٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","وَالنَّهْرُ الثَّالِثُ يُدْعَى حِدَّاقِلَ وَهُوَ الْجَارِي فِي شَرْقِيِّ أَشُّورَ. وَالنَّهْرُ الرَّابِعُ هُوَ الْفُرَاتُ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","وَأَخَذَ الرَّبُّ الإِلَهُ آدَمَ وَوَضَعَهُ فِي جَنَّةِ عَدْنٍ لِيَفْلَحَهَا وَيَعْتَنِيَ بِها. ");
INSERT INTO arbnav_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","وَأَمَرَ الرَّبُّ الإِلَهُ آدَمَ قَائِلا: «كُلْ مَا تَشَاءُ مِنْ جَمِيعِ أَشْجَارِ الْجَنَّةِ، ");
INSERT INTO arbnav_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","وَلَكِنْ إِيَّاكَ أَنْ تَأْكُلَ مِنْ شَجَرَةِ مَعْرِفَةِ الْخَيْرِ وَالشَّرِّ لأَنَّكَ حِينَ تَأْكُلُ مِنْهَا حَتْماً تَمُوت». ");
INSERT INTO arbnav_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ثُمَّ قَالَ الرَّبُّ الإِلَهُ: «لَيْسَ جَيِّداً أَنْ يَبْقَى آدَمُ وَحِيداً. سَأَصْنَعُ لَهُ مُعِيناً مُشَابِهاً لَهُ». ");
INSERT INTO arbnav_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","وَكَانَ الرَّبُّ الإِلَهُ قَدْ جَبَلَ مِنَ التُّرَابِ كُلَّ وُحُوشِ الْبَرِّيَّةِ وَطُيُورِ الْفَضَاءِ وَأَحْضَرَهَا إِلَى آدَمَ لِيَرَى بِأَيِّ أَسْمَاءَ يَدْعُوهَا، فَصَارَ كُلُّ اسْمٍ أَطْلَقَهُ آدَمُ عَلَى كُلِّ مَخْلُوقٍ حَيٍّ اسْماً لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","وَهَكَذَا أَطْلَقَ آدَمُ أَسْمَاءَ عَلَى كُلِّ الطُّيُورِ وَالْحَيَوَانَاتِ وَالْبَهَائِمِ. غَيْرَ أَنَّهُ لَمْ يَجِدْ لِنَفْسِهِ مُعِيناً مُشَابِهاً لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","فَأَوْقَعَ الرَّبُّ الإِلَهُ آدَمَ فِي نَوْمٍ عَمِيقٍ، ثُمَّ تَنَاوَلَ ضِلْعاً مِنْ أَضْلَاعِهِ وَسَدَّ مَكَانَهَا بِاللَّحْمِ، ");
INSERT INTO arbnav_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","وَعَمِلَ مِنْ هَذِهِ الضِّلْعِ امْرَأَةً أَحْضَرَهَا إِلَى آدَمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","فَقَالَ آدَمُ: «هَذِهِ الآنَ عَظْمٌ مِنْ عِظَامِي وَلَحْمٌ مِنْ لَحْمِي. فَهِيَ تُدْعَى امْرَأَةً لأَنَّهَا مِنِ امْرِئٍ أُخِذَتْ». ");
INSERT INTO arbnav_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","لِهَذَا، فَإِنَّ الرَّجُلَ يَتْرُكُ أَبَاهُ وَأُمَّهُ وَيَلْتَصِقُ بِامْرَأَتِهِ، وَيَصِيرَانِ جَسَداً وَاحِداً. ");
INSERT INTO arbnav_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","وَكَانَ آدَمُ وَامْرَأَتُهُ عُرْيَانَيْنِ، وَلَمْ يَخْجَلَا مِنْ ذَلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","وَكَانَتِ الْحَيَّةُ أَمْكَرَ وُحُوشِ الْبَرِّيَّةِ الَّتِي صَنَعَهَا الرَّبُّ الإِلَهُ، فَسَأَلَتِ الْمَرْأَةَ: «أَحَقّاً أَمَرَكُمَا اللهُ أَلَّا تَأْكُلَا مِنْ جَمِيعِ شَجَرِ الْجَنَّةِ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","فَأَجَابَتِ الْمَرْأَةُ: «يُمْكِنُنَا أَنْ نَأْكُلَ مِنْ ثَمَرِ الْجَنَّةِ كُلِّهَا، ");
INSERT INTO arbnav_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","مَاعَدَا ثَمَرَ الشَّجَرَةِ الَّتِي فِي وَسَطِهَا، فَقَدْ قَالَ اللهُ: لَا تَأْكُلَا مِنْهُ وَلَا تَلْمَسَاهُ وَإلَّا تَمُوتَا». ");
INSERT INTO arbnav_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","فَقَالَتِ الْحَيَّةُ لِلْمَرْأَةِ: «لَنْ تَمُوتَا، ");
INSERT INTO arbnav_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","بَلْ إِنَّ اللهَ يَعْرِفُ أَنَّهُ يَوْمَ تَأْكُلانِ مِنْ ثَمَرِ هَذِهِ الشَّجَرَةِ تَنْفَتِحُ أَعْيُنُكُمَا فَتَصِيرَانِ مِثْلَهُ، قَادِرَيْنِ عَلَى التَّمْيِيزِ بَيْنَ الْخَيْرِ وَالشَّرِّ». ");
INSERT INTO arbnav_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","وَعِنْدَمَا شَاهَدَتِ الْمَرْأَةُ أَنَّ الشَّجَرَةَ لَذِيذَةٌ لِلْمَأْكَلِ وَشَهِيَّةٌ لِلْعُيُونِ، وَمُثِيرَةٌ لِلنَّظَرِ قَطَفَتْ مِنْ ثَمَرِهَا وَأَكَلَتْ، ثُمَّ أَعْطَتْ زَوْجَهَا أَيْضاً فَأَكَلَ مَعَهَا، ");
INSERT INTO arbnav_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","فَانْفَتَحَتْ لِلْحَالِ أَعْيُنُهُمَا، وَأَدْرَكَا أَنَّهُمَا عُرْيَانَانِ، فَخَاطَا لأَنْفُسِهِمَا مَآزِرَ مِنْ أَوْرَاقِ التِّينِ. ");
INSERT INTO arbnav_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ثُمَّ سَمِعَ الزَّوْجَانِ صَوْتَ الرَّبِّ الإِلَهِ وَهُوَ يَمْشِي فِي الْجَنَّةِ عِنْدَ هُبُوبِ رِيحِ النَّهَارِ، فَاخْتَبَآ مِنْ حَضْرَةِ الرَّبِّ الإِلَهِ بَيْنَ شَجَرِ الْجَنَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","فَنَادَى الرَّبُّ الإِلَهُ آدَمَ: «أَيْنَ أَنْتَ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","فَأَجَابَ: «سَمِعْتُ صَوْتَكَ فِي الْجَنَّةِ فَاخْتَبَأْتُ خِشْيَةً مِنْكَ لأَنِّي عُرْيَانٌ». ");
INSERT INTO arbnav_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","فَسَأَلَهُ: «مَنْ قَالَ لَكَ إِنَّكَ عُرْيَانٌ؟ هَلْ أَكَلْتَ مِنْ ثَمَرِ الشَّجَرَةِ الَّتِي نَهَيْتُكَ عَنْهَا؟» ");
INSERT INTO arbnav_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","فَأَجَابَ آدَمُ: «إِنَّهَا الْمَرْأَةُ الَّتِي جَعَلْتَهَا رَفِيقَةً لِي. هِيَ الَّتِي أَطْعَمَتْنِي مِنْ ثَمَرِ الشَّجَرَةِ، فَأَكَلْتُ». ");
INSERT INTO arbnav_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","فَسَأَلَ الرَّبُّ الإِلَهُ الْمَرْأَةَ: «مَاذَا فَعَلْتِ؟» فَأَجَابَتْ: «أَغْوَتْنِي الْحَيَّةُ فَأَكَلْتُ». ");
INSERT INTO arbnav_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","فَقَالَ الرَّبُّ الإِلَهُ لِلْحَيَّةِ: «لأَنَّكِ فَعَلْتِ هَذَا، مَلْعُونَةٌ أَنْتِ مِنْ بَيْنَ جَمِيعِ الْبَهَائِمِ وَمِنْ جَمِيعِ وُحُوشِ الْبَرِّيَّةِ، عَلَى بَطْنِكِ تَسْعَيْنَ، وَمِنَ التُّرَابِ تَأْكُلِينَ طَوَالَ حَيَاتِكِ، ");
INSERT INTO arbnav_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","وَأُثِيرُ عَدَاوَةً دَائِمَةً بَيْنَكِ وَبَيْنَ الْمَرْأَةِ، وَكَذَلِكَ بَيْنَ نَسْلَيْكُمَا. هُوَ يَسْحَقُ رَأْسَكِ وَأَنْتِ تَلْدَغِينَ عَقِبَهُ». ");
INSERT INTO arbnav_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ثُمَّ قَالَ لِلْمَرْأَةِ: «أُكَثِّرُ تَكْثِيراً أَوْجَاعَ مَخَاضِكِ فَتُنْجِبِينَ بِالآلَامِ أَوْلَاداً، وَإِلَى زَوْجِكِ يَكُونُ اشْتِيَاقُكِ وَهُوَ يَتَسَلَّطُ عَلَيْكِ». ");
INSERT INTO arbnav_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","وَقَالَ لِآدَمَ: «لأَنَّكَ أَذْعَنْتَ لِقَوْلِ امْرَأَتِكَ، وَأَكَلْتَ مِنَ الشَّجَرَةِ الَّتِي نَهَيْتُكَ عَنْهَا، فَالأَرْضُ مَلْعُونَةٌ بِسَبَبِكَ وَبِالْمَشَقَّةِ تَقْتَاتُ مِنْهَا طَوَالَ عُمْرِكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","شَوْكاً وَحَسَكاً تُنْبِتُ لَكَ، وَأَنْتَ تَأْكُلُ عُشْبَ الْحَقْلِ. ");
INSERT INTO arbnav_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","بِعَرَقِ جَبِينِكَ تَكْسَبُ عَيْشَكَ حَتَّى تَعُودَ إِلَى الأَرْضِ، فَمِنْ تُرَابٍ أُخِذْتَ، وَإِلَى تُرَابٍ تَعُودُ». ");
INSERT INTO arbnav_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","وَسَمَّى آدَمُ زَوْجَتَهُ «حَوَّاءَ» لأَنَّهَا أُمُّ كُلِّ حَيٍّ. ");
INSERT INTO arbnav_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","وَكَسَا الرَّبُّ الإِلَهُ آدَمَ وَزَوْجَتَهُ رِدَاءَيْنِ مِنْ جِلْدٍ صَنَعَهُمَا لَهُمَا. ");
INSERT INTO arbnav_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ثُمَّ قَالَ الرَّبُّ الإِلَهُ: «هَا الإِنْسَانُ قَدْ صَارَ كَوَاحِدٍ مِنَّا، يُمَيِّزُ بَيْنَ الْخَيْرِ وَالشَّرِّ. وَقَدْ يَمُدُّ يَدَهُ وَيَتَنَاوَلُ مِنْ شَجَرَةِ الْحَيَاةِ وَيَأْكُلُ، فَيَحْيَا إِلَى الأَبَدِ». ");
INSERT INTO arbnav_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","فَأَخْرَجَهُ مِنْ جَنَّةِ عَدْنٍ لِيَفْلَحَ الأَرْضَ الَّتِي أُخِذَ مِنْ تُرَابِهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","وَهَكَذَا طَرَدَ اللهُ الإِنْسَانَ مِنْ جَنَّةِ عَدْنٍ، وَأَقَامَ مَلائِكَةَ الْكَرُوبِيمِ وَسَيْفاً نَارِيًّا مُتَقَلِّباً شَرْقِيَّ الْجَنَّةِ لِحِرَاسَةِ الطَّرِيقِ الْمُفْضِيَةِ إِلَى «شَجَرَةِ الْحَيَاةِ». ");
INSERT INTO arbnav_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","وَعَاشَرَ آدَمُ حَوَّاءَ زَوْجَتَهُ فَحَبِلَتْ، وَوَلَدَتْ ابْناً أَسْمَتْهُ قَايِينَ إِذْ قَالَتْ: «اقْتَنَيْتُ رَجُلاً مِنْ عِنْدِ الرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ثُمَّ عَادَتْ فَوَلَدَتْ أَخَاهُ هَابِيلَ، وَكَانَ هَابِيلُ رَاعِياً لِلْغَنَمِ. أَمَّا قَايِينُ فَقَدْ عَمِلَ فِي فِلَاحَةِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","وَحَدَثَ بَعْدَ مُرُورِ أَيَّامٍ أَنْ قَدَّمَ قَايِينُ مِنْ ثِمَارِ الأَرْضِ قُرْبَاناً لِلرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","وَقَدَّمَ هَابِيلُ أَيْضاً مِنْ خَيْرَةِ أَبْكَارِ غَنَمِهِ وَأَسْمَنِهَا. فَتَقَبَّلَ الرَّبُّ قُرْبَانَ هَابِيلَ وَرَضِيَ عَنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","لَكِنَّهُ لَمْ يَتَقَبَّلْ قُرْبَانَ قَايِينَ وَلَمْ يَرْضَ عَنْهُ. فَاغْتَاظَ قَايِينُ جِدّاً وَتَجَهَّمَ وَجْهُهُ كَمَداً. ");
INSERT INTO arbnav_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","فَسَأَلَ الرَّبُّ قَايِينَ: «لِمَاذَا اغْتَظْتَ؟ لِمَاذَا تَجَهَّمَ وَجْهُكَ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","لَوْ أَحْسَنْتَ فِي تَصَرُّفِكَ أَلَا يُشْرِقُ وَجْهُكَ فَرَحاً؟ وَإِنْ لَمْ تُحْسِنِ التَّصَرُّفَ، فَعِنْدَ الْبَابِ خَطِيئَةٌ تَنْتَظِرُكَ، تَتَشَوَّقُ أَنْ تَتَسَلَّطَ عَلَيْكَ، لَكِنْ يَجِبُ أَنْ تَتَحَكَّمَ فِيهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","وَعَادَ قَايِينُ يَتَظَاهَرُ بِالْوُدِّ لأَخِيهِ هَابِيلَ. وَحَدَثَ إِذْ كَانَا مَعاً فِي الْحَقْلِ أَنَّ قَايِينَ هَجَمَ عَلَى أَخِيهِ هَابِيلَ وَقَتَلَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","وَسَأَلَ الرَّبُّ قَايِينَ: «أَيْنَ أَخُوكَ هَابِيلُ؟» فَأَجَابَ: «لَا أَعْرِفُ. هَلْ أَنَا حَارِسٌ لأَخِي؟» ");
INSERT INTO arbnav_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","فَقَالَ الرَّبُّ لَهُ: «مَاذَا فَعَلْتَ؟ إِنَّ صَوْتَ دَمِ أَخِيكَ يَصْرُخُ إِلَيَّ مِنَ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","فَمُنْذُ الآنَ، تَحِلُّ عَلَيْكَ لَعْنَةُ الأَرْضِ الَّتِي فَتَحَتْ فَاهَا وَابْتَلَعَتْ دَمَ أَخِيكَ الَّذِي سَفَكَتْهُ يَدُكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","عِنْدَمَا تَفْلَحُهَا لَنْ تُعْطِيَكَ خَيْرَهَا، وَتَكُونُ شَرِيداً وَطَرِيداً فِي الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","فَقَالَ قَايِينُ لِلرَّبِّ: «عُقُوبَتِي أَعْظَمُ مِنْ أَنْ تُحْتَمَلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","هَا أَنْتَ الْيَوْمَ قَدْ طَرَدْتَنِي عَنْ وَجْهِ الأَرْضِ، وَمِنْ أَمَامِ حَضْرَتِكَ أَخْتَفِي، وَأَكُونُ شَرِيداً طَرِيداً فِي الأَرْضِ، وَيَقْتُلُنِي كُلُّ مَنْ يَجِدُنِي». ");
INSERT INTO arbnav_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","فَقَالَ الرَّبُّ لَهُ: «سَأُعَاقِبُ كُلَّ مَنْ يَقْتُلُكَ بِسَبْعَةِ أَضْعَافِ الْعُقُوبَةِ الَّتِي عَاقَبْتُكَ بِها». وَوَسَمَ الرَّبُّ قَايِينَ بِعَلَامَةٍ تَحْظُرُ عَلَى مَنْ يَلْقَاهُ اغْتِيَالَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","وَهَكَذَا خَرَجَ قَايِينُ مِنْ حَضْرَةِ الرَّبِّ وَسَكَنَ فِي أَرْضِ نُودٍ شَرْقِيَّ عَدْنٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","وَعَاشَرَ قَايِينُ زَوْجَتَهُ فَحَبِلَتْ وَأَنْجَبَتِ ابْناً دَعَاهُ «حَنُوكَ». وَكَانَ قَايِينُ آنَئِذٍ يَبْنِي مَدِينَةً فَسَمَّاهَا «حَنُوكَ» عَلَى اسْمِ ابْنِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ثُمَّ وَلَدَ حَنُوكُ عِيرَادَ، وَوَلَدَ عِيرَادُ مَحُويَائِيلَ، وَوَلَدَ مَحُويَائِيلُ مَتُوشَائِيلَ، وَوَلَدَ مَتُوشَائِيلُ لَامَكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","وَتَزَوَّجَ لَامَكُ امْرَأَتَيْنِ: اسْمُ الْوَاحِدَةِ عَادَةُ، وَاسْمُ الأُخْرَى صِلَّةُ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","وَوَلَدَتْ عَادَةُ كُلًّا مِنْ «يَابَالَ» أَوَّلِ رُعَاةِ الْمَوَاشِي وَسَاكِنِي الْخِيَامِ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","وَأَخِيهِ يُوبَالَ أَوَّلِ الْعَازِفِينَ بِالْعُودِ وَالْمِزْمَارِ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","وَوَلَدَتْ صِلَّةُ «تُوبَالَ قَايِينَ» أَوَّلَ صَانِعِي آلَاتِ النُّحَاسِ وَالْحَدِيدِ. كَمَا وَلَدَتْ «نَعْمَةَ» أُخْتَ تُوبَالَ قَايِينَ. ");
INSERT INTO arbnav_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","وَقَالَ لَامَكُ لِزَوْجَتَيْهِ: «يَا عَادَةُ وَصِلَّةُ، اسْمَعَا قَوْلِي، يَا زَوْجَتَيْ لَامَكَ أَصْغِيَا لِكَلَامِي: إِنِّي قَتَلْتُ رَجُلاً جَرَحَنِي وَشَابّاً كَسَرَنِي. ");
INSERT INTO arbnav_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","فَإِنْ كَانَ يُنْتَقَمُ لِقَايِينَ سَبْعَةَ أَضْعَافٍ، فَإِنَّهُ يُنْتَقَمُ لِلَامَكَ سَبْعَةً وَسَبْعِينَ ضِعْفاً». ");
INSERT INTO arbnav_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","وَعَاشَرَ آدَمُ زَوْجَتَهُ حَوَّاءَ مَرَّةً أُخْرَى فَأَنْجَبَتْ لَهُ ابْناً أَسْمَتْهُ «شِيثاً» إِذْ قَالَتْ: «قَدْ عَوَّضَنِي اللهُ نَسْلاً آخَرَ عِوَضاً عَنْ هَابِيلَ الَّذِي قَتَلَهُ قَايِينُ». ");
INSERT INTO arbnav_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","وَوُلِدَ لِشِيثٍ أَيْضاً ابْنٌ سَمَّاهُ أَنُوشَ وَعَنْدَئِذٍ ابْتَدَأَ النَّاسُ يَدْعُونَ بِاسْمِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","هَذَا سِجِلٌّ بِمَوَالِيدِ آدَمَ. يَوْمَ خَلَقَ اللهُ الإِنْسَانَ، صَنَعَهُ اللهُ عَلَى مِثَالِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","وَقَدْ خَلَقَهُ ذَكَراً وَأُنْثَى. وَيَوْمَ خَلَقَهُ، بَارَكَهُ وَسَمَّاهُ آدَمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","كَانَ عُمْرُ آدَمَ مِئَةً وَثَلَاثِينَ سَنَةً عِنْدَمَا أَنْجَبَ وَلَداً كَشَبَهِهِ وَمِثَالِهِ، وَسَمَّاهُ شِيثاً. ");
INSERT INTO arbnav_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","وَعَاشَ آدَمُ بَعْدَ مَوْلِدِ شِيثٍ ثَمَانِيَ مِئَةِ سَنَةٍ، وَوُلِدَ لَهُ بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","وَمَاتَ آدَمُ وَلَهُ مِنَ الْعُمْرِ تِسْعُ مِئَةٍ وَثَلَاثُونَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","كَانَ عُمْرُ شِيثٍ مِئَةً وَخَمْسَ سَنَوَاتٍ عِنْدَمَا أَنْجَبَ أَنُوشَ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","وَعَاشَ شِيثٌ بَعْدَ ذَلِكَ ثَمَانِيَ مِئَةٍ وَسَبْعَ سَنَوَاتٍ، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","وَمَاتَ شِيثٌ وَلَهُ مِنَ الْعُمْرِ تِسْعُ مِئَةٍ وَاثْنَتَا عَشَرَةَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","وَكَانَ عُمْرُ أَنُوشَ تِسْعِينَ سَنَةً عِنْدَمَا أَنْجَبَ قِينَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","وَعَاشَ أَنُوشُ بَعْدَ ذَلِكَ ثَمَانِيَ مِئَةٍ وَخَمْسَ عَشَرَةَ سَنَةً، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","وَمَاتَ أَنُوشُ وَلَهُ مِنَ الْعُمْرِ تِسْعُ مِئَةٍ وَخَمْسُ سَنَوَاتٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","وَكَانَ عُمْرُ قِينَانَ سَبْعِينَ سَنَةً عِنْدَمَا أَنْجَبَ مَهْلَلْئِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","وَعَاشَ قِينَانُ بَعْدَ ذَلِكَ ثَمَانِيَ مِئَةٍ وَأَرْبَعِينَ سَنَةً، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","وَمَاتَ قِينَانُ وَلَهُ مِنَ الْعُمْرِ تِسْعُ مِئَةٍ وَعَشْرُ سَنَوَاتٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","وَكَانَ عُمْرُ مَهْلَلْئِيلَ خَمْساً وَسِتِّينَ سَنَةً عِنْدَمَا أَنْجَبَ يَارَدَ، ");
INSERT INTO arbnav_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","وَعَاشَ مَهْلَلْئِيلُ بَعْدَ ذَلِكَ ثَمَانِيَ مِئَةٍ وَثَلاثِينَ سَنَةً، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","وَمَاتَ مَهْلَلْئِيلُ وَلَهُ مِنَ الْعُمْرِ ثَمَانِيَ مِئَةٍ وَخَمْسٌ وَتِسْعُونَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","وَكَانَ عُمْرُ يَارَدَ مِئَةً وَاثْنَتَيْنِ وَسِتِّينَ سَنَةً عِنْدَمَا أَنْجَبَ أَخْنُوخَ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","وَعَاشَ بَعْدَ ذَلِكَ ثَمَانِيَ مِئَةِ سَنَةٍ، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","وَمَاتَ يَارَدُ وَلَهُ مِنَ الْعُمْرِ تِسْعُ مِئَةٍ وَاثْنَتَانِ وَسِتُّونَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","وَكَانَ عُمْرُ أَخْنُوخَ خَمْساً وَسِتِّينَ سَنَةً عِنْدَمَا أَنْجَبَ مَتُوشَالَحَ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ثُمَّ عَاشَ أَخْنُوخُ بَعْدَ ذَلِكَ ثَلَاثَ مِئَةِ سَنَةٍ سَارَ فِيهَا مَعَ اللهِ. وَوُلِدَ لَهُ بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","وَكَانَتْ كُلُّ أَيَّامِ أَخْنُوخَ ثَلَاثَ مِئَةٍ وَخَمْساً وَسِتِّينَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","وَسَارَ أَخْنُوخُ مَعَ اللهِ، ثُمَّ تَوَارَى مِنَ الْوُجُودِ، لأَنَّ اللهَ نَقَلَهُ إِلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","وَكَانَ عُمْرُ مَتُوشَالَحَ مِئَةً وَسَبْعاً وَثَمَانِينَ سَنَةً عِنْدَمَا أَنْجَبَ لَامَكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","وَعَاشَ مَتُوشَالَحُ بَعْدَ ذَلِكَ سَبْعَ مِئَةٍ وَاثْنَتَيْنِ وَثَمَانِينَ سَنَةً، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","وَمَاتَ مَتُوشَالَحُ وَلَهُ مِنَ الْعُمْرِ تِسْعُ مِئَةٍ وَتِسْعٌ وَسِتُّونَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","كَانَ عُمْرُ لَامَكَ مِئَةً وَاثْنَتَيْنِ وَثَمَانِينَ سَنَةً عِنْدَمَا أَنْجَبَ ابْناً، ");
INSERT INTO arbnav_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","سَمَّاهُ نُوحاً قَائِلاً: «هَذَا يُعَزِّينَا عَنْ أَعْمَالِنَا وَمَشَقَّةِ أَيْدِينَا فِي الأَرْضِ الَّتِي لَعَنَهَا الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","وَعَاشَ لَامَكُ خَمْسَ مِئَةٍ وَخَمْساً وَتِسْعِينَ سَنَةً بَعْدَ وِلَادَةِ نُوحٍ، وُلِدَ لَهُ فِيهَا بَنُونَ وبَنَاتٌ ");
INSERT INTO arbnav_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","وَمَاتَ لَامَكُ وَلَهُ مِنَ الْعُمْرِ سَبْعُ مِئَةٍ وَسَبْعٌ وَسَبْعُونَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","كَانَ عُمْرُ نُوحٍ خَمْسَ مِئَةِ سَنَةٍ عِنْدَمَا أَنْجَبَ سَاماً وَحَاماً وَيَافَثَ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","وَحَدَثَ لَمَّا ابْتَدَأَ النَّاسُ يَتَكَاثَرُونَ عَلَى سَطْحِ الأَرْضِ وَوُلِدَ لَهُمْ بَنَاتٌ، ");
INSERT INTO arbnav_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","انْجَذَبَتْ أَنْظَارُ أَبْنَاءِ اللهِ إِلَى بَنَاتِ النَّاسِ فَرَأَوْا أَنَّهُنَّ جَمِيلاتٌ فَاتَّخَذُوا لأَنْفُسِهِمْ مِنْهُنَّ زَوْجَاتٍ كَمَا طَابَ لَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","فَقَالَ الرَّبُّ: «لَنْ يَمْكُثَ رُوحِي مُجَاهِداً فِي الإِنْسَانِ إِلَى الأَبَدِ. هُوَ بَشَرِيٌّ زَائِغٌ، لِذَلِكَ لَنْ تَطُولَ أَيَّامُهُ أَكْثَرَ مِنْ مِئَةٍ وَعِشْرِينَ سَنَةً فَقَطْ». ");
INSERT INTO arbnav_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","وَفِي تِلْكَ الْحِقَبِ، كَانَ فِي الأَرْضِ جَبَابِرَةٌ، وَبَعْدَ أَنْ دَخَلَ أَبْنَاءُ اللهِ عَلَى بَنَاتِ النَّاسِ وَلَدْنَ لَهُمْ أَبْنَاءً، صَارَ هَؤُلَاءِ الأَبْنَاءُ أَنْفُسُهُمُ الْجَبَابِرَةَ الْمَشْهُورِينَ مُنْذُ الْقِدَمِ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","وَرَأَى الرَّبُّ أَنَّ شَرَّ الإِنْسَانِ قَدْ كَثُرَ فِي الأَرْضِ، وَأَنَّ كُلَّ تَصَوُّرِ فِكْرِ قَلْبِهِ يَتَّسِمُ دَائِماً بِالإِثْمِ، ");
INSERT INTO arbnav_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","فَمَلأَ قَلبَهُ الأَسَفُ وَالْحُزْنُ لأَنَّهُ خَلَقَ الإِنْسَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","وَقَالَ الرَّبُّ: «أَمْحُو الإِنْسَانَ الَّذِي خَلَقْتُهُ عَنْ وَجْهِ الأَرْضِ مَعَ سَائِرِ النَّاسِ وَالْحَيَوَانَاتِ وَالزَّوَاحِفِ وَطُيُورِ السَّمَاءِ، لأَنِّي حَزِنْتُ أَنِّي خَلَقْتُهُ». ");
INSERT INTO arbnav_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","أَمَّا نُوحٌ فَقَدْ حَظِيَ بِرِضَى الرَّبِ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","وَهَذَا سِجِلُّ مَوَالِيدِ نُوحٍ: كَانَ نُوحٌ صَالِحاً كَامِلاً فِي زَمَانِهِ، وَسَارَ نُوحٌ مَعَ اللهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","وَأَنْجَبَ نُوحٌ ثَلَاثَةَ أَبْنَاءٍ هُمْ سَامٌ وَحَامٌ وَيَافَثُ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","وَإِذْ سَادَ الشَّرُّ الأَرْضَ أَمَامَ اللهِ وَعَمَّهَا الظُّلْمُ، ");
INSERT INTO arbnav_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","نَظَرَ اللهُ وَإذَا بِها فَاسِدَةٌ لأَنَّ كُلَّ بَشَرٍ عَلَى الأَرْضِ قَدْ سَلَكَ فِي طَرِيقِ الإِثْمِ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","فَقَالَ اللهُ لِنُوحٍ: «قَدْ أَزِفَتْ نِهَايَةُ الْبَشَرِ جَمِيعاً أَمَامِي، لأَنَّهُمْ مَلَأُوا الأَرْضَ ظُلْماً. لِذَلِكَ سَأُبِيدُهُمْ مَعَ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ابْنِ لَكَ فُلْكاً مِنْ خَشَبِ السَّرْوِ، وَاجْعَلْ فِيهِ غُرَفاً تَطْلِيهَا بِالزِّفْتِ مِنَ الدَّاخِلِ وَالْخَارِجِ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","اصْنَعْهُ عَلَى هَذَا الْمِثَالِ: لِيَكُنْ طُولُهُ ثَلَاثَ مِئَةِ ذِرَاعٍ (نَحْوَ مِئَةٍ وَخَمْسَةٍ وَثَلَاثِينَ مِتْراً)، وَعَرْضُهُ خَمْسِينَ ذِرَاعاً (نَحْوَ اثْنَيْنِ وَعِشْرِينَ مِتْراً وَنِصْفِ الْمِتْرِ) وَارْتِفَاعُهُ ثَلَاثِينَ ذِرَاعاً (نَحْوَ ثَلَاثَةَ عَشَرَ مِتْراً وَنِصْفِ الْمِتْرِ). ");
INSERT INTO arbnav_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","وَاجْعَلْ لَهُ نَافِذَةً عَلَى انْخِفَاضِ ذِرَاعٍ (نَحْوَ خَمْسَةٍ وَأَرْبَعِينَ سَنْتِمِتْراً) مِنَ السَّقْفِ، وَبَاباً تُقِيمُهُ فِي جَانِبِهِ. وَلْيَكُنْ لِلْفُلْكِ طَوَابِقُ سُفْلِيَّةٌ وَمُتَوَسِّطَةٌ وَعُلْوِيَّةٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","فَهَا أَنَا أُغْرِقُ الأَرْضَ بِطُوفَانٍ مِنَ الْمِيَاهِ لأُبِيدَ كُلَّ كَائِنٍ حَيٍّ فِيهَا مِمَّنْ تَحْتَ السَّمَاءِ. كُلُّ مَا عَلَى الأَرْضِ لَابُدَّ أَنْ يَمُوتَ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","وَلَكِنِّي سَأُقِيمُ مَعَكَ عَهْداً، فَتَدْخُلُ أَنْتَ مَعَ بَنِيكَ وَامْرَأَتِكَ وَنِسَاءِ بَنِيكَ إِلَى الْفُلْكِ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","وَتَأْخُذُ مَعَكَ فِي الْفُلْكِ زَوْجَيْنِ، ذَكَراً وَأُنْثَى، مِنْ كُلِّ كَائِنٍ حَيٍّ ذِي جَسَدٍ، لاسْتِبْقَائِهَا مَعَكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","تُدْخِلُ مَعَكَ اثْنَيْنِ مِنْ كُلِّ صَنْفٍ مِنْ أَصْنَافِ الطُّيُورِ وَالْبَهَائِمِ وَالزَّوَاحِفِ عَلَى الأَرْضِ، حِفَاظاً عَلَى اسْتِمْرَارِ بَقَائِهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","وَتَدَّخِرُ لِنَفْسِكَ مِنْ كُلِّ طَعَامٍ يُؤْكَلُ وَتَخْزُنُهُ عِنْدَكَ لِيَكُونَ لَكَ وَلَهَا غِذَاءً». ");
INSERT INTO arbnav_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","وَفَعَلَ نُوحٌ تَمَاماً حَسَبَ كُلِّ مَا أَمَرَ الرَّبُّ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","وَقَالَ الرَّبُّ لِنُوحٍ: «هَيَّا ادْخُلْ أَنْتَ وَأَهْلُ بَيْتِكَ جَمِيعاً إِلَى الْفُلْكِ لأَنِّي وَجَدْتُكَ وَحْدَكَ صَالِحاً أَمَامِي فِي هَذَا الْجِيلِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","خُذْ مَعَكَ مِنْ كُلِّ نَوْعٍ مِنَ الْحَيَوَانَاتِ الطَّاهِرَةِ سَبْعَةَ ذُكُورٍ وَسَبْعَ إِنَاثٍ، وَاثْنَيْنِ، ذَكَراً وَأُنْثَى مِنْ كُلِّ نَوْعٍ مِنَ الْحَيَوَانَاتِ الأُخْرَى غَيْرِ الطَّاهِرَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","وَخُذْ مَعَكَ أَيْضاً مِنْ كُلِّ نَوْعٍ مِنَ الطُّيُورِ سَبْعَةَ ذُكُورٍ وَسَبْعَ إِنَاثٍ لاسْتِبْقَاءِ نَسْلِهَا عَلَى وَجْهِ كُلِّ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","فَإِنِّي بَعْدَ سَبْعَةِ أَيَّامٍ أُمْطِرُ عَلَى الأَرْضِ أَرْبَعِينَ يَوْماً، لَيْلاً وَنَهَاراً، فَأَمْحُو عَنْ وَجْهِ الأَرْضِ كُلَّ مَخْلُوقٍ حَيٍّ». ");
INSERT INTO arbnav_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","وَفَعَلَ نُوحٌ بِمُوْجِبِ كُلِّ مَا أَمَرَهُ الرَّبُّ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","وَكَانَ عُمْرُ نُوحٍ سِتَّ مِئَةِ سَنَةٍ عِنْدَمَا حَدَثَ طُوفَانُ الْمَاءِ عَلَى الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","فَدَخَلَ نُوحٌ إِلَى الْفُلْكِ مَعَ زَوْجَتِهِ وَأَبْنَائِهِ وَزَوْجَاتِهِمْ (لِيَنْجُوا) مِنْ مِيَاهِ الطُّوفَانِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","وَكَذَلِكَ الْحَيَوَانَاتُ الطَّاهِرَةُ وَغَيْرُ الطَّاهِرَةِ، وَالطُّيُورُ وَالزَّوَاحِفُ، ");
INSERT INTO arbnav_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","دَخَلَتْ مَعَ نُوحٍ إِلَى الْفُلْكِ اثْنَيْنِ اثْنَيْنِ، ذَكَراً وَأُنْثَى، كَمَا أَمَرَ اللهُ نُوحاً. ");
INSERT INTO arbnav_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","وَمَا إِنِ انْقَضَتِ الأَيَّامُ السَّبْعَةُ حَتَّى فَاضَتِ الْمِيَاهُ عَلَى الأَرْضِ ");
INSERT INTO arbnav_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","فَفِي سَنَةِ سِتِّ مَئَةٍ مِنْ عُمْرِ نُوحٍ، فِي الشَّهْرِ الثَّانِي، فِي الْيَوْمِ السَّابِعَ عَشَرَ مِنْهُ، تَفَجَّرَتِ الْمِيَاهُ مِنَ اللُّجَجِ الْعَمِيقَةِ فِي بَاطِنِ الأَرْضِ، وَهَطَلَتْ أَمْطَارُ السَّمَاءِ الْغَزِيرَةُ، ");
INSERT INTO arbnav_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","وَاسْتَمَرَّ هَذَا الطُّوفَانُ عَلَى الأَرْضِ لَيْلاً وَنَهَاراً مُدَّةَ أَرْبَعِينَ يَوْماً. ");
INSERT INTO arbnav_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","فِي ذَلِكَ الْيَوْمِ الَّذِي بَدَأَ فِيهِ الطُّوفَانُ دَخَلَ نُوحٌ وَزَوْجَتُهُ وَأَبْنَاؤُهُ سَامٌ وَحَامٌ وَيَافَثُ وَزَوْجَاتُهُمُ الثَّلَاثُ إِلَى الْفُلْكِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","وَدَخَلَ مَعَهُمْ أَيْضاً مِنَ الْوُحُوشِ وَالْبَهَائِمِ وَالزَّوَاحِفِ وَالطُّيُورِ وَذَوَاتِ الأَجْنِحَةِ كُلٍّ حَسَبَ أَصْنَافِهَا؛ ");
INSERT INTO arbnav_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","مِنْ جَمِيعِ الْمَخْلُوقَاتِ الْحَيَّةِ أَقْبَلَتْ إِلَى الْفُلْكِ، وَدَخَلَتْ مَعَ نُوحٍ اثْنَيْنِ اثْنَيْنِ، ");
INSERT INTO arbnav_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ذَكَراً وَأُنْثَى دَخَلَتْ، مِنْ كُلِّ ذِي جَسَدٍ، كَمَا أَمَرَهُ اللهُ. ثُمَّ أَغْلَقَ الرَّبُّ عَلَيْهِ بَابَ الْفُلْكِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","وَدَامَ الطُّوفَانُ أَرْبَعِينَ يَوْماً عَلَى الأَرْضِ، وَطَغَتِ الْمِيَاهُ وَرَفَعَتِ الْفُلْكَ فَوْقَ الأَرْضِ، ");
INSERT INTO arbnav_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","وَتَكَاثَرَتِ الْمِيَاهُ عَلَى الأَرْضِ وَطَغَتْ جِدّاً، فَكَانَ الْفُلْكُ يَطْفُو فَوْقَ الْمِيَاهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","وَتَعَاظَمَتِ الْمِيَاهُ جِدّاً فَوْقَ الأَرْضِ حَتَّى أَغْرَقَتْ جَمِيعَ الْجِبَالِ الْعَالِيَةِ الَّتِي تَحْتَ السَّمَاءِ كُلِّهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","وَبَلَغَ ارْتِفَاعُهَا خَمْسَ عَشْرَةَ ذِرَاعاً (نَحْوَ سَبْعَةِ أَمْتَارٍ) عَنْ أَعْلَى الْجِبَالِ، ");
INSERT INTO arbnav_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","فَمَاتَ كُلُّ كَائِنٍ حَيٍّ يَتَحَرَّكُ عَلَى الأَرْضِ مِنْ طُيُورٍ وَبَهَائِمَ وَوُحُوشٍ وَزَوَاحِفَ وَكُلِّ بَشَرٍ ");
INSERT INTO arbnav_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","مَاتَ كُلُّ مَا يَحْيَا وَيَتَنَفَّسُ عَلَى الْيَابِسَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","وَبَادَ مِنْ عَلَى سَطْحِ الأَرْضِ كُلُّ كَائِنٍ حَيٍّ سَوَاءٌ مِنَ النَّاسِ أَمِ الْبَهَائِمِ أَمِ الزَّوَاحِفِ أَمِ الطُّيُورِ، كُلُّهَا أُبِيدَتْ مِنَ الأَرْضِ، وَلَمْ يَبْقَ سِوَى نُوحٍ وَمَنْ مَعَهُ فِي الْفُلْكِ. ");
INSERT INTO arbnav_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","وَظَلَّتِ الْمِيَاهُ طَامِيَةً عَلَى الأَرْضِ مُدَّةَ مِئَةٍ وَخَمْسِينَ يَوْماً. ");
INSERT INTO arbnav_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ثُمَّ افْتَقَدَ اللهُ نُوحاً وَمَا مَعَهُ فِي الْفُلْكِ مِنْ وُحُوشٍ وبَهَائِمَ، فَأَرْسَلَ رِيحاً عَلَى الأَرْضِ فَتَقَلَّصَتِ الْمِيَاهُ ");
INSERT INTO arbnav_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","وَانْسَدَّتْ يَنَابِيعُ الْمَاءِ فِي الْأَرْضِ وَالسَّمَاءِ، وَاحْتَبَسَ الْمَطَرُ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","وَتَرَاجَعَتِ الْمِيَاهُ عَنِ الأَرْضِ تَدْرِيجِيًّا. وَبَعْدَ مِئَةٍ وَخَمْسِينَ يَوْماً نَقَصَتِ الْمِيَاهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","وَاسْتَقَرَّ الْفُلْكُ عَلَى جِبَالِ أَرَارَاطَ فِي الْيَوْمِ السَّابِعَ عَشَرَ مِنَ الشَّهْرِ السَّابِعِ لِلطُّوفَانِ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","وَظَلَّتِ الْمِيَاهُ تَتَنَاقَصُ تَدْرِيجِيًّا حَتَّى الشَّهْرِ الْعَاشِرِ. وَفِي الْيَوْمِ الأَوَّلِ مِنَ الشَّهْرِ الْعَاشِرِ بَدَتْ قِمَمُ الْجِبَالِ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","وَبَعْدَ أَرْبَعِينَ يَوْماً أُخْرَى فَتَحَ نُوحٌ النَّافِذَةَ الَّتِي كَانَ قَدْ عَمِلَهَا فِي الْفُلْكِ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","وَأَطْلَقَ غُرَاباً، فَخَرَجَ وَظَلَّ يَحُومُ مُتَرَدِّداً إِلَى الْفُلْكِ حَتَّى جَفَّتِ الْمِيَاهُ عَنِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ثُمَّ أَطْلَقَ نُوحٌ حَمَامَةً مِنَ الْفُلْكِ لِيَرَى إِنْ كَانَتِ الْمِيَاهُ قَدْ تَقَلَّصَتْ عَنْ وَجْهِ الأَرْضِ، ");
INSERT INTO arbnav_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","وَلَكِنَّ الْحَمَامَةَ لَمْ تَجِدْ مَوْضِعاً تَسْتَقِرُّ عَلَيْهِ رِجْلُهَا فَرَجَعَتْ إِلَيْهِ فِي الْفُلْكِ، لأَنَّ الْمِيَاهَ كَانَتْ مَازَالَتْ تَغْمُرُ سَطْحَ الأَرْضِ، فَمَدَّ يَدَهُ وَأَخَذَهَا، وَأَدْخَلَهَا عِنْدَهُ إِلَى الْفُلْكِ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","وَانْتَظَرَ سَبْعَةَ أَيَّامٍ أُخْرَى ثُمَّ عَادَ فَأَطْلَقَ الْحَمَامَةَ مِنَ الْفُلْكِ، ");
INSERT INTO arbnav_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","فَرَجَعَتْ إِلَيْهِ عِنْدَ الْمَسَاءِ تَحْمِلُ فِي مِنْقَارِهَا وَرَقَةَ زَيْتُونٍ خَضْرَاءَ، فَأَدْرَكَ نُوحٌ أَنَّ الْمِيَاهَ قَدْ تَنَاقَصَتْ عَنِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","فَمَكَثَ سَبْعَةَ أَيَّامٍ أُخْرَى ثُمَّ أَطْلَقَ الْحَمَامَةَ فَلَمْ تَرْجِعْ إِلَيْهِ هَذِهِ الْمَرَّةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","وَفِي الْيَوْمِ الأَوَّلِ مِنَ الشَّهْرِ الأَوَّلِ مِنَ السَّنَةِ الْوَاحِدَةِ وَالسِّتِّ مِئَةٍ مِنْ عُمْرِ نُوحٍ، جَفَّتِ الْمِيَاهُ عَنِ الأَرْضِ، فَرَفَعَ نُوحٌ سَقْفَ الْفُلْكِ وَتَطَلَّعَ حَوْلَهُ، فَرَأَى أَنَّ سَطْحَ الأَرْضِ قَدْ أَخَذَ فِي الْجَفَافِ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","وَلَكِنَّ الأَرْضَ لَمْ تَجِفَّ تَمَاماً إِلّا فِي الْيَوْمِ السَّابِعِ وَالْعِشْرِينَ مِنَ الشَّهْرِ الثَّانِي. ");
INSERT INTO arbnav_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","وَخَاطَبَ اللهُ نُوحاً قَائِلا: ");
INSERT INTO arbnav_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«اخْرُجْ مِنَ الْفُلْكِ أَنْتَ وَامْرَأَتُكَ وَبَنُوكَ وَنِسَاءُ بَنِيكَ مَعَكَ، ");
INSERT INTO arbnav_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","وَأَخْرِجْ كُلَّ مَا مَعَكَ مِنَ الْكَائِنَاتِ الْحَيَّةِ، مِنْ طُيُورٍ وَبَهَائِمَ وَكُلِّ مَا يَزْحَفُ عَلَى الأَرْضِ لِتَتَوَالَدَ وَتَتَكَاثَرَ عَلَى الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","وَخَرَجَ نُوحٌ وَبَنُوهُ وَامْرَأَتُهُ وَزَوْجَاتُ بَنِيهِ مَعَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","وَكَذَلِكَ خَرَجَتْ مَعَهُ كُلُّ الْحَيَوَانَاتِ، وَالزَّوَاحِفِ وَالطُّيُورِ، وَكُلُّ مَا يَدِبُّ عَلَى الأَرْضِ، كُلٌّ مِنْهَا كَجِنْسِهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","وَبَنَى نُوحٌ مَذْبَحاً لِلرَّبِّ ثُمَّ اخْتَارَ بَعْضاً مِنْ جَمِيعِ الْبَهَائِمِ وَالطُّيُورِ الطَّاهِرَةِ وَقَرَّبَهَا مُحْرَقَاتٍ عَلَى الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","فَتَقَبَّلَهَا الرَّبُّ بِرِضًى، وَقَالَ فِي نَفْسِهِ: «لَنْ أَلْعَنَ الأَرْضَ مَرَّةً أُخْرَى مِنْ أَجْلِ الإِنْسَانِ، لأَنَّ أَهْوَاءَ قَلْبِ الإِنْسَانِ شِرِّيرَةٌ مُنْذُ حَدَاثَتِهِ وَلَنْ أُقْدِمَ عَلَى إِهْلاكِ كُلِّ حَيٍّ كَمَا فَعَلْتُ. ");
INSERT INTO arbnav_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","وَتَكُونُ كُلُّ أَيَّامِ الأَرْضِ مَوَاسِمَ زَرْعٍ وَحَصَادٍ وَبَرْدٍ وَحَرٍّ وَصَيْفٍ وَشِتَاءٍ وَنَهَارٍ وَلَيْلٍ، لَنْ تَبْطُلَ أَبَداً». ");
INSERT INTO arbnav_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","وَبَارَكَ اللهُ نُوحاً وَأَبْنَاءَهُ قَائِلاً لَهُمْ: «أَثْمِرُوا وَتَكَاثَرُوا وَامْلَأُوا الأَرْضَ، ");
INSERT INTO arbnav_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","لِتَخْشَكُمْ وَتَرْهَبْكُمْ كُلُّ حَيَوَانَاتِ الأَرْضِ وَطُيُورِ السَّمَاءِ، وَكُلُّ مَا يَتَحَرَّكُ عَلَى الأَرْضِ، وَسَمَكُ الْبَحْرِ، فَإِنَّهَا كُلَّهَا قَدْ أَصْبَحَتْ خَاضِعَةً لَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","وَلْيَكُنْ كُلُّ حَيٍّ مُتَحَرِّكٍ طَعَاماً لَكُمْ، فَتَأْكُلُونَ كُلَّ شَيْءٍ كَمَا تَأْكُلُونَ الْبُقُولَ الْخَضْرَاءَ الَّتِي أَعْطَيْتُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","وَلَكِنْ لَا تَأْكُلُوا لَحْماً بِدَمِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","وَأُطَالِبُ أَنَا بِدَمِكُمْ لأَنْفُسِكُمْ. مِنْ يَدِ كُلِّ حَيَوَانٍ أُطَالِبُ بِهِ، وَمِنْ يَدِ الإِنْسَانِ أَيْضاً أُطَالِبُ الأَخَ بِنَفْسِ أَخِيهِ الإِنْسَانِ. ");
INSERT INTO arbnav_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","فَسَافِكُ دَمِ الإِنْسَانِ يُحْكَمُ عَلَيْهِ بِسَفْكِ دَمِهِ لأَنَّ اللهَ خَلَقَ الإِنْسَانَ عَلَى صُورَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","أَمَّا أَنْتُمْ فَأَثْمِرُوا وَتَكَاثَرُوا وَتَوَالَدُوا فِي الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","وَخَاطَبَ الرَّبُّ نُوحاً وَأَبْنَاءَهُ مَعَهُ قَائِلاً: ");
INSERT INTO arbnav_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«هَا أَنَا أقْطَعُ عَهْدِي مَعَكُمْ وَمَعْ ذُرِّيَّتِكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","وَمَعْ جَمِيعِ الْمَخْلُوقَاتِ الْحَيَّةِ الَّتِي مَعَكُمْ، مِنْ طُيُورٍ وَبَهَائِمَ، وَمِنْ كُلِّ حَيَوَانَاتِ الأَرْضِ الَّتِي خَرَجَتْ مَعَكُمْ مِنَ الْفُلْكِ، مَعْ كُلِّ الْمَخْلُوقَاتِ الْحَيَّةِ عَلَى الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","أقْطَعُ عَهْدِي مَعَكُمْ بِأَنْ لَا يُبِيدَ الطُّوفَانُ كُلَّ ذِي جَسَدٍ ثَانِيَةً، وَأَنْ لَا يَكُونَ هُنَاكَ طُوفَانٌ لِيَقْضِيَ عَلَى الْحَيَاةِ فِي الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","وَقَالَ الرَّبُّ: «وَهَذِهِ هِيَ عَلامَةُ الْعَهْدِ الأَبَدِيِّ الَّذِي أُقِيمُهُ بَيْنِي وَبَيْنَكُمْ وَبَيْنَ الْمَخْلُوقَاتِ الْحَيَّةِ الَّتِي مَعَكُمْ: ");
INSERT INTO arbnav_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","أَضَعُ قَوْسِي فِي السَّحَابِ فَتَكُونُ عَلامَةَ عَهْدٍ بَيْنِي وَبَيْنَ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","فَيَكُونُ عِنْدَمَا أُخَيِّمُ بِالسَّحَابِ فَوْقَ الأَرْضِ، وَتَظْهَرُ الْقَوْسُ، ");
INSERT INTO arbnav_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","أَنِّي أَذْكُرُ عَهْدِي الَّذِي بَيْنِي وَبَيْنَكُمْ وَبَيْنَ كُلِّ الْمَخْلُوقَاتِ الْحَيَّةِ مِنْ ذَوَاتِ الْجَسَدِ، فَلا تَتَحَوَّلُ الْمِيَاهُ إِلَى طُوفَانٍ يُبِيدُ كُلَّ حَيَاةٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","وَتَكُونُ الْقَوْسُ فِي السَّحَابِ، فَأُبْصِرُهَا، وَأَذْكُرُ الْعَهْدَ الأَبَدِيَّ الْمَقْطُوعَ بَيْنِي وَبَيْنَ جَمِيعِ الْمَخْلُوقَاتِ الْحَيَّةِ عَلَى الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","وَقَالَ اللهُ لِنُوحٍ: «هَذِهِ هِيَ عَلامَةُ الْعَهْدِ الَّذِي قَطَعْتُهُ بَيْنِي وَبَيْنَ كُلِّ حَيٍّ عَلَى الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","أَمَّا أَبْنَاءُ نُوحٍ الَّذِينَ خَرَجُوا مَعَهُ مِنَ الْفُلْكِ فَكَانُوا: سَاماً وَحَاماً وَيَافَثَ. وَحَامٌ هُوَ أَبُو الْكَنْعَانِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","هَؤُلاءِ كَانُوا أَبْنَاءَ نُوحٍ الثَّلاثَةَ الَّذِينَ تَفَرَّعَتْ مِنْهُمْ شُعُوبُ الأَرْضِ كُلِّهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","وَاشْتَغَلَ نُوحٌ بِالْفِلاحَةِ وَغَرَسَ كَرْماً، ");
INSERT INTO arbnav_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","وَشَرِبَ مِنَ الْخَمْرِ فَسَكِرَ وَتَعَرَّى دَاخِلَ خَيْمَتِهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","فَشَاهَدَ حَامٌ أَبُو الْكَنْعَانِيِّينَ عُرْيَ أَبِيهِ، فَخَرَجَ وَأَخْبَرَ أَخَوَيْهِ اللَّذَيْنِ كَانَا خَارِجاً. ");
INSERT INTO arbnav_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","فَأَخَذَ سَامٌ وَيَافَثُ رِدَاءً وَوَضَعَاهُ عَلَى أَكْتَافِهِمَا وَمَشَيَا الْقَهْقَرِيَّ إِلَى دَاخِلِ الْخَيْمَةِ، وَسَتَرَا عُرْيَ أَبِيهِمَا مِنْ غَيْرِ أَنْ يَسْتَدِيرَا بِوَجْهَيْهِمَا نَحْوَهُ فَيُبْصِرَا عُرْيَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","وَعِنْدَمَا أَفَاقَ نُوحٌ مِنْ سُكْرِهِ وَعَلِمَ مَا فَعَلَهُ بِهِ ابْنُهُ الصَّغِيرُ ");
INSERT INTO arbnav_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","قَالَ: «لِيَكُنْ كَنْعَانُ مَلْعُوناً، وَلْيَكُنْ عَبْدَ الْعَبِيدِ لإِخْوَتِهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ثُمَّ قَالَ: «تَبَارَكَ اللهُ إِلَهُ سَامٍ. وَلْيَكُنْ كَنْعَانُ عَبْداً لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","لِيُوْسِعِ اللهُ لِيَافَثَ فَيَسْكُنَ فِي خِيَامِ سَامٍ. وَلْيَكُنْ كَنْعَانُ عَبْداً لَهُ». ");
INSERT INTO arbnav_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","وَعَاشَ نُوحٌ بَعْدَ الطُّوفَانِ ثَلاثَ مِئَةٍ وَخَمْسِينَ سَنَةً، ");
INSERT INTO arbnav_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ثُمَّ مَاتَ وَلَهُ مِنَ الْعُمْرِ تِسْعُ مِئَةٍ وَخَمْسُونَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","هَذَا سِجِلُّ مَوَالِيدِ سَامٍ وَحَامٍ وَيَافَثَ أَبْنَاءِ نُوحٍ، وَمَنْ وُلِدَ لَهُمْ مِنْ بَعْدِ الطُّوفَانِ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","أَبْنَاءُ يَافَثَ: جُومَرُ وَمَاجُوجُ وَمَادَايُ وَيَاوَانُ وَتُوبَالُ وَمَاشَكُ وَتِيرَاسُ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","وَأَبْنَاءُ جُومَرَ: أَشْكَنَازُ وَرِيفَاثُ وَتُوجَرْمَةُ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","وَأَبْنَاءُ يَاوَانَ: أَلِيشَةُ وَتَرْشِيشُ وَكِتِّيمُ وَدُودَانِيمُ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","وَتَفَرَّعَ مِنْ هَؤُلاءِ سُكَّانُ الْجَزَائِرِ وَتَفَرَّقُوا فِي مَنَاطِقِهِمْ حَسَبَ قَبَائِلِهِمْ وَأُمَمِهِمْ، وَلُغَاتِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","وَأَبْنَاءُ حَامٍ: كُوشٌ وَمِصْرَايِمُ وَفُوطُ وَكَنْعَانُ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","وَأَبْنَاءُ كُوشٍ: سَبَا، وَحَوِيلَةُ، وَسَبْتَةُ وَرَعْمَةُ وَسَبْتَكَا. وَأَبْنَاءُ رَعْمَةَ: سَبَا وَدَدَانُ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","وَأَنْجَبَ كُوْشُ نِمْرُودَ الَّذِي مَا لَبِثَ أَنْ أَصْبَحَ عَاتِياً فِي الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","كَانَ صَيَّاداً عَاتِياً أَمَامَ الرَّبِّ، لِذَلِكَ يُقَالُ: «كَنِمْرُودَ جَبَّارُّ صَيْدٍ أَمَامَ الرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","وَقَدْ تَكَوَّنَتْ مَمْلَكَتُهُ أَوَّلَ الأَمْرِ مِنْ بَابِلَ وَأَرَكَ وَأَكَّدَ وَكَلْنَةَ فِي أَرْضِ شِنْعَارَ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","وَمِنْ تِلْكَ الأَرْضِ خَرَجَ أَشُّورُ وَبَنَى مُدُنَ نِينَوَى وَرَحُبُوتَ عَيْرَ وَكَالَحَ، ");
INSERT INTO arbnav_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","وَرَسَنَ الْوَاقِعَةَ بَيْنَ نِينَوَى وَكَالَحَ. وَهِيَ الْمَدِينَةُ الْكَبِيرَةُ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","وَمِنْ مِصْرَايِمَ تَحَدَّرَتْ هَذِهِ الْقَبَائِلُ: اللُّودِيُّونَ وَالْعَنَامِيُّونَ، وَاللهَابِيُّونَ وَالنَّفْتُوحِيُّونَ ");
INSERT INTO arbnav_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","وَالْفَتْرُوسِيُّونَ وَالْكَسْلُوحِيُّونَ. وَمِنْهُمْ تَحَدَّرَ الْفِلِسْطِينِيُّونَ وَالْكَفْتُورِيُّونَ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","وَأَنْجَبَ كَنْعَانُ صِيدُونَ ابْنَهُ الْبِكْرَ ثُمَّ حِثًّا، ");
INSERT INTO arbnav_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","وَمِنْهُ تَحَدَّرَتْ قَبَائِلُ الْيَبُوسِيِّينَ وَالأَمُورِيِّينَ وَالْجِرْجَاشِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","وَالْحِوِّيِّينَ وَالْعَرْقِيِّينَ وَالسِّينِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","وَالأَرْوَادِيِّينَ وَالصَّمَارِيِّينَ وَالْحَمَاتِيِّينَ، وَبَعْدَ ذَلِكَ انْتَشَرَتِ الْقَبَائِلُ الْكَنْعَانِيَّةُ ");
INSERT INTO arbnav_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","فِي الأَرَاضِي الْوَاقِعَةِ بَيْنَ صِيدُونَ وَغَزَّةَ مُرُوراً بِجَرَارَ، وَبَيْنَ صِيدُونَ وَلاشَعَ مُرُوراً بِسَدُومَ وَعَمُورَةَ وَأَدْمَةَ وَصَبُويِيمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","كَانَ هَؤُلاءِ هُمُ الْمُنْحَدِرُونَ مِنْ حَامٍ بِحَسَبِ قَبَائِلِهِمْ وَلُغَاتِهِمْ وَبُلْدَانِهِمْ وَشُعُوبِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","وَأَنْجَبَ سَامٌ، أَخُو يَافَثَ الأَكْبَرُ، أَبْنَاءً. وَمِنْهُ تَحَدَّرَ جَمِيعُ بَنِي عَابِرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","أَمَّا أَبْنَاءُ سَامٍ فَهُمْ: عِيلامُ وَأَشُّورُ وَأَرْفَكْشَادُ وَلُودُ وَأَرَامُ ");
INSERT INTO arbnav_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","وَأَبْنَاءُ أَرَامَ: عُوصُ، وَحُولُ، وَجَاثَرُ وَمَاشُ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","وَأَنْجَبَ أَرْفَكْشَادُ شَالَحَ، وَوَلَدَ شَالَحُ عَابِرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","وَوُلِدَ لِعَابِرَ ابْنَانِ: اسْمُ أَحَدِهِمَا فَالَجُ (وَمَعْنَاهُ انْقِسَامٌ) لأَنَّ أَهْلَ الأَرْضِ انْقَسَمُوا فِي أَيَّامِهِ. وَاسْمُ أَخِيهِ يَقْطَانُ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","وَأَنْجَبَ يَقْطَانُ أَلْمُودَادَ وَشَالَفَ وَحَضَرْمَوْتَ وَيَارَحَ، ");
INSERT INTO arbnav_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","وَهَدُورَامَ وَأُوزَالَ وَدِقْلَةَ، ");
INSERT INTO arbnav_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","وَعُوبَالَ وَأَبِيمَايِلَ وَشَبَا، ");
INSERT INTO arbnav_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","وَأُوفِيرَ وَحَوِيلَةَ وَيُوبَابَ. وَهَؤُلاءِ جَمِيعُهُمْ أَبْنَاءُ يَقْطَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","وَقَدِ اسْتَوْطَنُوا فِي الأَرَاضِي الْوَاقِعَةِ بَيْنَ مِيشَا وَالتِّلالِ الشَّرْقِيَّةِ مِنْ جَبَلِ سَفَارَ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","هَؤُلاءِ هُمُ الْمُنْحَدِرُونَ مِنْ سَامٍ حَسَبَ قَبَائِلِهِمْ وَلُغَاتِهِمْ وَبُلْدَانِهِمْ وَشُعُوبِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","هَذِهِ هِيَ الْقَبَائِلُ الْمُنْحَدِرَةُ مِنْ أَبْنَاءِ نُوحٍ حَسَبَ شُعُوبِهِمْ، وَمِنْهُمُ انْتَشَرَتِ الأُمَمُ فِي الأَرْضِ بَعْدَ الطُّوفَانِ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","وَكَانَ أَهْلُ الأَرْضِ جَمِيعاً يَتَكَلَّمُونَ أَوَّلاً بِلِسَانٍ وَاحِدٍ وَلُغَةٍ وَاحِدَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","وَإِذِ ارْتَحَلُوا شَرْقاً وَجَدُوا سَهْلاً فِي أَرْضِ شِنْعَارَ فَاسْتَوْطَنُوا هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","فَقَالَ بَعْضُهُمْ لِبَعْضٍ: «لِنَصْنَعْ طُوباً مَشْوِيًّا أَحْسَنَ شَيٍّ». فَاسْتَخْدَمُوا الطُّوبَ بَدِيلاً لِلْحِجَارَةِ بِالطُّوبِ، وِالْحُمْرَ بَدِيلاً للطِّينِ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ثُمَّ قَالُوا: «لِنُشَيِّدْ لأَنْفُسِنَا مَدِينَةً وَبُرْجاً يَبْلُغُ رَأْسُهُ السَّمَاءَ، فَنُخَلِّدَ لَنَا اسْماً لِئَلّا نَتَشَتَّتَ عَلَى وَجْهِ الأَرْضِ كُلِّهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","وَنَزَلَ الرَّبُّ لِيَشْهَدَ الْمَدِينَةَ وَالْبُرْجَ اللَّذَيْنِ شَرَعَ بَنُو الْبَشَرِ فِي بِنَائِهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","فَقَالَ الرَّبُّ: «إِنْ كَانُوا، كَشَعْبٍ وَاحِدٍ يَنْطِقُونَ بِلُغَةٍ وَاحِدَةٍ، قَدْ عَمِلُوا هَذَا مُنْذُ أَوَّلِ الأَمْرِ، فَلَنْ يَمْتَنِعَ إِذاً عَلَيْهِمْ أَيُّ شَيْءٍ عَزَمُوا عَلَى فِعْلِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","هَيَّا نَنْزِلْ إِلَيْهِمْ وَنُبَلْبِلْ لِسَانَهُمْ، حَتَّى لَا يَفْهَمَ بَعْضُهُمْ كَلامَ بَعْضٍ». ");
INSERT INTO arbnav_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","وَهَكَذَا شَتَّتَهُمُ الرَّبُّ مِنْ هُنَاكَ عَلَى سَطْحِ الأَرْضِ كُلِّهَا، فَكَفُّوا عَنْ بِنَاءِ الْمَدِينَةِ، ");
INSERT INTO arbnav_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","لِذَلِكَ سُمِّيَتِ الْمَدِينَةُ «بَابِلَ» لأَنَّ الرَّبَّ بَلْبَلَ لِسَانَ أَهْلِ كُلِّ الأَرْضِ، وَبِالتَّالِي شَتَّتَهُمْ مِنْ هُنَاكَ فِي أَرْجَاءِ الأَرْضِ كُلِّهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","وَهَذَا سِجِلُّ مَوَالِيدِ سَامٍ. لَمَّا كَانَ سَامٌ ابْنَ مِئَةِ سَنَةٍ وَلَدَ أَرْفَكْشَادَ بَعْدَ الطُّوفَانِ بِسَنَتَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","وَعَاشَ سَامٌ بَعْدَ ذَلِكَ خَمْسَ مِئَةِ سَنَةٍ، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","وَعِنْدَمَا بَلَغَ أَرْفَكْشَادُ خَمْساً وَثَلاثِينَ سَنَةً مِنَ الْعُمْرِ وَلَدَ شَالَحَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","وَعَاشَ بَعْدَ ذَلِكَ أَرْبَعَ مِئَةٍ وَثَلاثَ سَنَوَاتٍ، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","وَكَانَ شَالَحُ فِي الثَّلاثِينَ مِنْ عُمْرِهِ عِنْدَمَا وَلَدَ عَابِرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","وَعَاشَ بَعْدَ ذَلِكَ أَرْبَعَ مِئَةٍ وَثَلاثَ سَنَوَاتٍ، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","وَكَانَ عُمْرُ عَابِرَ أَرْبَعاً وَثَلاثِينَ سَنَةً عِنْدَمَا وَلَدَ فَالَجَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","وَعَاشَ عَابِرُ بَعْدَ ذَلِكَ أَرْبَعَ مِئَةٍ وَثَلاثِينَ سَنَةً، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","وَكَانَ عُمْرُ فَالَجَ ثَلاثِينَ سَنَةً عِنْدَمَا وَلَدَ رَعُوَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","وَعَاشَ فَالَجُ بَعْدَ ذَلِكَ مِئَتَيْنِ وَتِسْعَ سِنِينَ وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","وَكَانَ عُمْرُ رَعُوَ اثْنَتَيْنِ وَثَلاثِينَ سَنَةً عِنْدَمَا وَلَدَ سَرُوجَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","وَعَاشَ رَعُو بَعْدَ ذَلِكَ مِئَتَيْنِ وَسَبْعَ سِنِينَ، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","وَكَانَ عُمْرُ سَرُوجَ ثَلاثِينَ سَنَةً عِنْدَمَا وَلَدَ نَاحُورَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","وَعَاشَ سَرُوجُ بَعْدَ ذَلِكَ مِئَتَيْ سَنَةٍ، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","وَكَانَ عُمْرُ نَاحُورَ تِسْعاً وَعِشْرِينَ سَنَةً عِنْدَمَا وَلَدَ تَارَحَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","وَعَاشَ نَاحُورُ بَعْدَ ذَلِكَ مِئَةً وَتِسْعَ عَشْرَةَ سَنَةً، وُلِدَ لَهُ فِيهَا بَنُونَ وَبَنَاتٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","وَعِنْدَمَا بَلَغَ تَارَحُ السَّبْعِينَ مِنْ عُمْرِهِ أَنْجَبَ أَبْرَامَ وَنَاحُورَ وَهَارَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","وَهَذَا هُوَ سِجِلُّ مَوَالِيدِ تَارَحَ: وَلَدَ تَارَحُ أَبْرَامَ وَنَاحُورَ وَهَارَانَ. وَوَلَدَ هَارَانُ لُوطاً. ");
INSERT INTO arbnav_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","وَمَاتَ هَارَانُ قَبْلَ تَارَحَ أَبِيهِ فِي أَرْضِ مَوْلِدِهِ فِي أُورِ الْكَلْدَانِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","وَتَزَوَّجَ كُلٌّ مِنْ أَبْرَامَ وَنَاحُورَ. وَكَانَ اسْمُ زَوْجَةِ أَبْرَامَ سَارَايَ، وَاسْمُ زَوْجَةِ نَاحُورَ مِلْكَةَ بِنْتَ هَارَانَ الَّذِي أَنْجَبَ مِلْكَةَ وَيِسْكَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","وَكَانَتْ سَارَايُ عَاقِراً لَيْسَ لَهَا وَلَدٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","وَأَخَذَ تَارَحُ ابْنَهُ أَبْرَامَ وَحَفِيدَهُ لُوطاً بْنَ هَارَانَ، وَسَارَايَ كَنَّتَهُ زَوْجَةَ ابْنِهِ أَبْرَامَ، وَارْتَحَلَ بِهِمْ مِنْ أُورِ الْكَلْدَانِيِّينَ لِيَذْهَبُوا إِلَى أَرْضِ كَنْعَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","لَكِنَّهُمْ وَصَلُوا إِلَى حَارَانَ وَاسْتَقَرُّوا فِيهَا. وَهُنَاكَ مَاتَ تَارَحُ وَلَهُ مِنَ الْعُمْرِ مِئَتَانِ وَخَمْسُ سِنِينَ. ");
INSERT INTO arbnav_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","وَقَالَ الرَّبُّ لأَبْرَامَ: «اتْرُكْ أَرْضَكَ وَعَشِيرَتَكَ وَبَيْتَ أَبِيكَ وَاذْهَبْ إِلَى الأَرْضِ الَّتِي أُرِيكَ، ");
INSERT INTO arbnav_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","فَأَجْعَلَ مِنْكَ أُمَّةً كَبِيرَةً وَأُبَارِكَكَ وَأُعَظِّمَ اسْمَكَ، وَتَكُونَ بَرَكَةً (لِكَثِيرِينَ). ");
INSERT INTO arbnav_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","وَأُبَارِكُ مُبَارِكِيكَ وَأَلْعَنُ لاعِنِيكَ، وَتَتَبَارَكُ فِيكَ جَمِيعُ أُمَمِ الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","فَارْتَحَلَ أَبْرَامُ كَمَا أَمَرَهُ الرَّبُّ، وَرَافَقَهُ لُوطٌ. وَكَانَ أَبْرَامُ فِي الْخَامِسَةِ وَالسَّبْعِينَ مِنْ عُمْرِهِ عِنْدَمَا غَادَرَ حَارَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","وَأَخَذَ أَبْرَامُ سَارَايَ زَوْجَتَهُ وَلُوطاً ابْنَ أَخِيهِ وَكُلَّ مَا جَمَعَاهُ مِنْ مُقْتَنَيَاتٍ وَكُلَّ مَا امْتَلَكَاهُ مِنْ نُفُوسٍ فِي حَارَانَ، وَانْطَلَقُوا جَمِيعاً إِلَى أَرْضِ كَنْعَانَ إِلَى أَنْ وَصَلُوهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","فَشَرَعَ أَبْرَامُ يَتَنَقَّلُ فِي الأَرْضِ إِلَى أَنْ بَلَغَ مَوْضِعَ شَكِيمَ إِلَى سَهْلِ مُورَةَ. وَكَانَ الْكَنْعَانِيُّونَ آنَئِذٍ يَقْطُنُونَ تِلْكَ الأَرْضَ. ");
INSERT INTO arbnav_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","وَظَهَرَ الرَّبُّ لأَبْرَامَ وَقَالَ لَهُ: «سَأُعْطِي هَذِهِ الأَرْضَ لِذُرِّيَّتِكَ». فَبَنَى أَبْرَامُ هُنَاكَ مَذْبَحاً لِلرَّبِّ الَّذِي ظَهَرَ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","وَانْتَقَلَ مِنْ هُنَاكَ إِلَى الْجَبَلِ شَرْقِيَّ بَيْتِ إِيلٍ حَيْثُ نَصَبَ خِيَامَهُ مَا بَيْنَ بَيْتِ إِيلٍ غَرْباً وَعَايَ شَرْقاً وَشَيَّدَ هُنَاكَ مَذْبَحاً لِلرَّبِّ وَدَعَا بِاسْمِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ثُمَّ تَابَعَ أَبْرَامُ ارْتِحَالَهُ نَحْوَ الْجَنُوبِ. ");
INSERT INTO arbnav_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","وَعَمَّتْ تِلْكَ الْبِلادَ مَجَاعَةٌ، فَانْحَدَرَ أَبْرَامُ إِلَى مِصْرَ لِيَتَغَرَّبَ فِيهَا لأَنَّ الْمَجَاعَةَ كَانَتْ شَدِيدَةً فِي الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","وَمَا إِنِ اقْتَرَبَ مِنْ تُخُومِ مِصْرَ حَتَّى قَالَ لِزَوْجَتِهِ سَارَايَ: «أَنَا أَعْرِفُ أَنَّكِ امْرَأَةٌ جَمِيلَةٌ، ");
INSERT INTO arbnav_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","فَمَا إِنْ يَرَاكِ الْمِصْرِيُّونَ حَتَّى يَقُولُوا: هَذِهِ هِيَ زَوْجَتُهُ فَيَقْتُلُونَنِي وَيَسْتَحْيُونَكِ. ");
INSERT INTO arbnav_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","لِذَلِكَ قُولِي إِنَّكِ أُخْتِي، فَيُحْسِنُوا مُعَامَلَتِي مِنْ أَجْلِكِ وَتَنْجُوَ حَيَاتِي بِفَضْلِكِ». ");
INSERT INTO arbnav_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","وَلَمَّا اقْتَرَبَ أَبْرَامُ مِنْ مِصْرَ اسْتَرْعَى جَمَالُ سَارَايَ أَنْظَارَ الْمِصْرِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","وَشَاهَدَهَا أَيْضاً رُؤَسَاءُ فِرْعَوْنَ فَأَشَادُوا بِها أَمَامَهُ. فَأُخِذَتِ الْمَرْأَةُ إِلَى بَيْتِ فِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","فَأَحْسَنَ إِلَى أَبْرَامَ بِسَبَبِهَا وَأَجْزَلَ لَهُ الْعَطَاءَ مِنَ الْغَنَمِ وَالْبَقَرِ وَالْحَمِيرِ وَالْعَبِيدِ وَالإِمَاءِ وَالأُتُنِ وَالْجِمَالِ. ");
INSERT INTO arbnav_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","وَلَكِنَّ الرَّبَّ ابْتَلَى فِرْعَوْنَ وَأَهْلَهُ بِبَلايَا عَظِيمَةٍ بِسَبَبِ سَارَايَ زَوْجَةِ أَبْرَامَ. ");
INSERT INTO arbnav_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","فَاسْتَدْعَى فِرْعَوْنُ أَبْرَامَ وَسَأَلَهُ: «مَاذَا فَعَلْتَ بِي؟ لِمَاذَا لَمْ تُخْبِرْنِي أَنَّهَا زَوْجَتُكَ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","وَلِمَاذَا ادَّعَيْتَ أَنَّهَا أُخْتُكَ حَتَّى أَخَذْتُهَا لِتَكُونَ زَوْجَةً لِي؟ وَالآنَ هَا هِيَ زَوْجَتُكَ، خُذْهَا وَامْضِ فِي طَرِيقِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","وَأَوْصَى فِرْعَوْنُ رِجَالَهُ بِأَبْرَامَ، فَشَيَّعُوهُ وَامْرَأَتَهُ وَكُلَّ مَا كَانَ يَمْلِكُ. ");
INSERT INTO arbnav_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","وَغَادَرَ أَبْرَامُ مِصْرَ وَتَوَجَّهَ هُوَ وَزَوْجَتُهُ وَلُوطٌ وَكُلُّ مَا كَانَ لَهُ، نَحْوَ مِنْطَقَةِ النَّقَبِ ");
INSERT INTO arbnav_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","وَكَانَ أَبْرَامُ يَمْلِكُ ثَرْوَةً طَائِلَةً مِنَ الْمَوَاشِي وَالْفِضَّةِ وَالذَّهَبِ. ");
INSERT INTO arbnav_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","وَظَلَّ يَتنَقَّلُ فِي مِنْطَقَةِ النَّقَبِ مُتَّجِهاً إِلَى بَيْتِ إِيلٍ، إِلَى الْمَكَانِ الَّذِي كَانَ قَدْ نَصَبَ فِيهِ خِيَامَهُ أَوَّلاً بَيْنَ بَيْتِ إِيلٍ وَعَايَ. ");
INSERT INTO arbnav_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","حَيْثُ كَانَ قَدْ شَيَّدَ الْمَذْبَحَ أَوَّلاً، وَدَعَا هُنَاكَ أَبْرَامُ بِاسْمِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","وَكَانَ لِلُوطٍ الْمُرَافِقِ لأَبْرَامَ غَنَمٌ وَبَقَرٌ وَخِيَامٌ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","فَضَاقَتْ بِهِمَا الأَرْضُ لِكَثْرَةِ أَمْلاكِهِمَا فَلَمْ يَقْدِرَا أَنْ يَسْكُنَا مَعاً. ");
INSERT INTO arbnav_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","وَنَشَبَ نِزَاعٌ بَيْنَ رُعَاةِ مَوَاشِي أَبْرَامَ وَرُعَاةِ مَوَاشِي لُوطٍ، فِي الْوَقْتِ الَّذِي كَانَ فِيهِ الْكَنْعَانِيُّونَ وَالْفِرِزِّيُّونَ يُقِيمُونَ فِي الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","فَقَالَ أَبْرَامُ لِلُوطٍ: «لا يَكُنْ نِزَاعٌ بَيْنِي وَبَيْنَكَ، وَلا بَيْنَ رُعَاتِي وَرُعَاتِكَ لأَنَّنَا نَحْنُ أَخَوَانِ. ");
INSERT INTO arbnav_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","أَلَيْسَتِ الأَرْضُ كُلُّهَا أَمَامَكَ؟ فَاعْتَزِلْ عَنِّي. إِنِ اتَّجَهْتَ شِمَالاً، أَتَّجِهْ أَنَا يَمِيناً، وَإِنْ تَحَوَّلْتَ يَمِيناً، أَتَحَوَّلْ أَنَا شِمَالاً». ");
INSERT INTO arbnav_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","وَتَلَفَّتَ لُوطٌ حَوْلَهُ فَشَاهَدَ السُّهُولَ الْمُحِيطَةَ بِنَهْرِ الأُرْدُنِّ وَإذَا بِها رَيَّانَةٌ كُلُّهَا، قَبْلَمَا دَمَّرَ الرَّبُّ سَدُومَ وَعَمُورَةَ، وَكَأَنَّهَا جَنَّةُ الرَّبِّ كَأَرْضِ مِصْرَ الْمُمْتَدَّةِ إِلَى صُوغَرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","فَاخْتَارَ لُوطٌ لِنَفْسِهِ حَوْضَ الأُرْدُنِّ كُلَّهُ وَارْتَحَلَ شَرْقاً. وَهَكَذَا اعْتَزَلَ أَحَدُهُمَا عَنِ الآخَرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","وَسَكَنَ أَبْرَامُ فِي أَرْضِ كَنْعَانَ، وَأَقَامَ لُوطٌ فِي مُدُنِ السَّهْلِ حَيْثُ نَصَبَ خِيَامَهُ بِجُوَارِ سَدُومَ. ");
INSERT INTO arbnav_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","وَكَانَ أَهْلُ سَدُومَ مُتَوَرِّطِينَ فِي الشَّرِّ وَخَاطِئِينَ جِدّاً أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","وَقَالَ الرَّبُّ لأَبْرَامَ بَعْدَ أَنِ اعْتَزَلَ عَنْهُ لُوطٌ: «ارْفَعْ عَيْنَيْكَ وَتَلَفَّتْ حَوْلَكَ مِنَ الْمَوْضِعِ الَّذِي أَنْتَ فِيهِ، شِمَالاً وَجَنُوباً، شَرْقاً وَغَرْباً، ");
INSERT INTO arbnav_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","فَإِنَّ هَذِهِ الأَرْضَ الَّتِي تَرَاهَا، سَأُعْطِيهَا لَكَ وَلِذُرِّيَّتِكَ إِلَى الأَبَدِ. ");
INSERT INTO arbnav_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","وَسَأَجْعَلُ نَسْلَكَ كَتُرَابِ الأَرْضِ، فَإِنِ اسْتَطَاعَ أَحَدٌ أَنْ يُحْصِيَ تُرَابَ الأَرْضِ يَقْدِرُ آنَئِذٍ أَنْ يُحْصِيَ نَسْلَكَ ");
INSERT INTO arbnav_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","قُمْ وَامْشِ فِي طُولِ الأَرْضِ وَعَرْضِهَا لأَنِّي لَكَ أُعْطِيهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","فَنَقَلَ أَبْرَامُ خِيَامَهُ ونَصَبَهَا فِي سَهْلِ مَمْرَا فِي حَبْرُونَ. وَهُنَاكَ بَنَى لِلرَّبِّ مَذْبَحاً. ");
INSERT INTO arbnav_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","وَحَدَثَ فِي زَمَانِ أَمْرَافَلَ مَلِكِ شِنْعَارَ وَأَرْيُوكَ مَلِكِ أَلاسَارَ وَكَدَرْلَعَوْمَرَ مَلِكِ عِيلامَ وَتِدْعَالَ مَلِكِ جُويِيمَ، ");
INSERT INTO arbnav_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","أَنَّ حَرْباً نَشَبَتْ بَيْنَهُمْ وَبَيْنَ بَارَعَ مَلِكِ سَدُومَ وَبِرْشَاعَ مَلِكِ عَمُورَةَ وَشِنْآبَ مَلِكِ أَدْمَةَ وَشِمْئِيبَرَ مَلِكِ صَبُويِيمَ، وَمَلِكِ بَالَعَ الْمَعْرُوفَةِ بِصُوغَرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","هَؤُلاءِ جَمِيعُهُمُ احْتَشَدُوا فِي وَادِي السِّدِّيمِ (وَهُوَ بَحْرُ الْمِلْحِ؛ الْبَحْرُ الْمَيِّتُ) ");
INSERT INTO arbnav_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","وَكَانَ كَدَرْلَعَوْمَرُ قَدِ اسْتَعْبَدَهُمْ طَوَالَ اثْنَتَيْ عَشْرَةَ سَنَةً، وَفِي السَّنَةِ الثَّالِثَةَ عَشْرَةَ تَمَرَّدُوا عَلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","وَفِي السَّنَةِ الرَّابِعَةَ عَشْرَةَ اجْتَمَعَ كَدَرْلَعَوْمَرُ وَحُلَفَاؤُهُ الْمُلُوكُ وَقَهَرُوا الرَّفَائِيِّينَ فِي عَشْتَارُوثَ قَرْنَايِمَ، وَالزُّوزِيِّينَ فِي هَامَ، وَالإِيمِيِّينَ فِي سَهْلِ قَرْيَتَايِمَ، ");
INSERT INTO arbnav_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","وَالْحُورِيِّينَ فِي جَبَلِهِمْ سَعِيرَ حَتَّى بُطْمَةِ فَارَانَ عَلَى حُدُودِ الصَّحْرَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ثُمَّ اسْتَدَارُوا حَتَّى أَقْبَلُوا عَلَى عَيْنِ مِشْفَاطَ، الَّتِي هِيَ قَادِشُ، فَهَزَمُوا بِلادَ الْعَمَالِقَةِ كُلَّهَا وَالأَمُورِيِّينَ السَّاكِنِينَ فِي حَصُّونَ تَامَارَ. ");
INSERT INTO arbnav_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","فَخَرجَ مَلِكُ سَدُومَ وَمَلِكُ عَمُورَةَ وَمَلِكُ أَدْمَةَ وَمَلِكُ صَبُويِيمَ وَمَلِكُ بَالَعَ، الَّتِي هِيَ صُوغَرُ، فِي عُمْقِ السِّدِّيمِ وَخَاضُوا حَرْباً ");
INSERT INTO arbnav_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","مَعْ كَدَرْلَعَوْمَرَ مَلِكِ عِيلامَ وَتِدْعَالَ مَلِكِ جُويِيمَ وَأَمْرَافَلَ مَلِكِ شِنْعَارَ وَأَرْيُوكَ مَلِكِ أَلاسَارَ، فَكَانُوا أَرْبَعَةَ مُلوكٍ ضِدَّ خَمْسَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","وَكَانَ وَادِي السِّدِّيمِ مَلِيئاً بِآبَارِ الزِّفْتِ، فَانْدَحَرَ مَلِكَا سَدُومَ وَعَمُورَةَ وَسَقَطَا بَيْنَهَا، أَمَّا الْبَاقُونَ فَهَرَبُوا إِلَى الْجِبَالِ. ");
INSERT INTO arbnav_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","فَغَنِمَ الْمُنْتَصِرُونَ جَمِيعَ مَا فِي سَدُومَ وَعَمُورَةَ مِنْ مُمْتَلَكَاتٍ وَمُؤَنٍ وَمَضَوْا. ");
INSERT INTO arbnav_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","وَأَسَرُوا لُوطاً ابْنَ أَخِي أَبْرَامَ الْمُقِيمَ فِي سَدُومَ، وَنَهَبُوا أَمْلاكَهُ ثُمَّ ذَهَبُوا. ");
INSERT INTO arbnav_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","وَجَاءَ أَحَدُ النَّاجِينَ إِلَى أَبْرَامَ الْعِبْرَانِيِّ، الَّذِي كَانَ مُقِيماً حَتَّى ذَلِكَ الْوَقْتِ عِنْدَ بَلُّوطَاتِ مَمْرَا أَخِي أَشْكُولَ وَعَانِرَ حُلَفَاءِ أَبْرَامَ، وَأَبْلَغَهُ بِمَا جَرَى. ");
INSERT INTO arbnav_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","فَلَمَّا سَمِعَ أَبْرَامُ أَنَّ ابْنَ أَخِيهِ قَدْ أُسِرَ، جَرَّدَ ثَلاثَ مِئَةٍ وَثَمَانِيَةَ عَشَرَ مِنْ غِلْمَانِهِ الْمُدَرَّبِينَ الْمَوْلُودِينَ فِي بَيْتِهِ وَتَعَقَّبَهُمْ حَتَّى بَلَغَ دَانَ ");
INSERT INTO arbnav_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","وَفِي أَثْنَاءِ اللَّيْلِ قَسَّمَ رِجَالَهُ، وَهَاجَمَهُمْ وَقَهَرَهُمْ، ثُمَّ طَارَدَهُمْ حَتَّى حُوبَةَ شَمَالِيَّ دِمَشْقَ. ");
INSERT INTO arbnav_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","وَاسْتَرَدَّ كُلَّ الْغَنَائِمِ، وَاسْتَرْجَعَ ابْنَ أَخِيهِ لُوطاً وَأَمْلاكَهُ، وَالنِّسَاءَ أَيْضاً وَسِوَاهُمْ مِنَ الأَسْرَى. ");
INSERT INTO arbnav_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","وَجَاءَ مَلِكُ سَدُومَ لِلِقَاءِ أَبْرَامَ فِي وَادِي شَوَى الْمَعْرُوفِ بِوَادِي الْمَلِكِ، بَعْدَ عَوْدَتِهِ مِنْ كَسْرَةِ كَدَرْلَعَوْمَرَ وَالْمُلُوكِ حُلَفَائِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","وَكَذَلِكَ حَمَلَ إِلَيْهِ مَلْكِي صَادِقُ مَلِكُ شَالِيمَ، الَّذِي كَانَ كَاهِناً لِلهِ الْعَلِيِّ، خُبْزاً وَخَمْراً، ");
INSERT INTO arbnav_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","وَبَارَكَهُ قَائِلاً: «لِتَكُنْ عَلَيْكَ يَا أَبْرَامُ بَرَكَةُ اللهِ الْعَلِيِّ، مَالِكِ السَّمَاوَاتِ وَالأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","وَتَبَارَكَ اللهُ الْعَلِيُّ الَّذِي دَفَعَ أَعْدَاءَكَ إِلَى يَدَيْكَ». فَأَعْطَاهُ أَبْرَامُ عُشْرَ الْغَنَائِمِ كُلِّهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","وَقَالَ مَلِكُ سَدُومَ لأَبْرَامَ: «أَعْطِنِي الأَسْرَى الْمَعْتُوقِينَ أَمَّا الْغَنَائِمُ فَاحْتَفِظْ بِها لِنَفْسِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","فَأَجَابَهُ أَبْرَامُ: «لَقَدْ أَقْسَمْتُ بِالرَّبِّ الإِلَهِ الْعَلِيِّ، مَالِكِ السَّمَاوَاتِ وَالأَرْضِ، ");
INSERT INTO arbnav_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","وَعَاهَدْتُهُ أَلّا آخُذَ شَيْئاً مِمَّا هُوَ لَكَ، وَلَوْ كَانَ خَيْطاً أَوْ شَرِيطَ حِذَاءٍ، لِئَلّا تَقُولَ: أَنَا أَغْنَيْتُ أَبْرَامَ ");
INSERT INTO arbnav_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","لَنْ آخُذَ غَيْرَ مَا أَكَلَهُ الْغِلْمَانُ. أَمَّا نَصِيبُ الرِّجَالِ الَّذِينَ ذَهَبُوا مَعِي: عَانِرَ وَأَشْكُولَ وَمَمْرَا، فَإِنَّهُمْ يَأْخُذُونَهُ». ");
INSERT INTO arbnav_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","وَبَعْدَ هَذِهِ الأُمُورِ قَالَ الرَّبُّ لأَبْرَامَ فِي الرُّؤْيَا: «لا تَخَفْ يَا أَبْرَامُ. أَنَا تُرْسٌ لَكَ. وَأَجْرُكَ عَظِيمٌ جِدّاً». ");
INSERT INTO arbnav_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","فَقَالَ أَبْرَامُ: «أَيُّهَا السَّيِّدُ الرَّبُّ أَيُّ خَيْرٍ فِي مَا تُعْطِينِي وَأَنَا مِنْ غَيْرِ عَقِبٍ وَوَارِثُ بَيْتِي هُوَ أَلِيعَازَرُ الدِّمَشْقِيُّ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","وَقَالَ أَبْرَامُ أَيْضاً: «إِنَّكَ لَمْ تُعْطِنِي نَسْلاً، وَهَا هُوَ عَبْدٌ مَوْلُودٌ فِي بَيْتِي يَكُونُ وَارِثِي» ");
INSERT INTO arbnav_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","فَأَجَابَهُ الرَّبُّ: «لَنْ يَكُونَ هَذَا لَكَ وَرِيثاً، بَلِ الَّذِي يَخْرُجُ مِنْ صُلْبِكَ يَكُونُ وَرِيثَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","وَأَخْرَجَهُ الرَّبُّ إِلَى الْخَارِجِ وَقَالَ: «انْظُرْ إِلَى السَّمَاءِ وَعُدَّ النُّجُومَ إِنِ اسْتَطَعْتَ ذَلِكَ». ثُمَّ قَالَ لَهُ: «هَكَذَا يَكُونُ نَسْلُكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","فَآمَنَ بِالرَّبِّ فَحَسَبَهُ لَهُ بِرّاً، ");
INSERT INTO arbnav_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","وَقَالَ لَهُ: «أَنَا هُوَ الرَّبُّ الَّذِي أَتَى بِكَ مِنْ أُورِ الْكَلْدَانِيِّينَ لأُعْطِيَكَ هَذِهِ الأَرْضَ مِيرَاثاً». ");
INSERT INTO arbnav_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","فَسَأَلَ: «كَيْفَ أَعْلَمُ أَنِّي أَرِثُهَا؟» ");
INSERT INTO arbnav_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","فَأَجَابَهُ الرَّبُّ: «خُذْ لِي عِجْلَةً وَعَنْزَةً وَكَبْشاً، عُمْرُ كُلٍّ مِنْهَا ثَلاثُ سَنَوَاتٍ، وَيَمَامَةً وَحَمَامَةً». ");
INSERT INTO arbnav_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","فَأَخَذَ هَذِهِ كُلَّهَا وَشَقَّ الْبَهَائِمَ مِنَ الْوَسَطِ إِلَى شَطْرَيْنِ، وَجَعَلَ كُلَّ شَطْرٍ مِنْهَا مُقَابِلَ الشَّطْرِ الآخَرِ. أَمَّا الطَّيْرُ فَلَمْ يَشْطُرْهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","وَعِنْدَمَا أَخَذَتِ الطُّيُورُ الْجَارِحَةُ تَنْقَضُّ عَلَى الْجُثَثِ زَجَرَهَا أَبْرَامُ. ");
INSERT INTO arbnav_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","وَلَمَّا مَالَتِ الشَّمْسُ إِلَى الْمَغِيبِ غَرِقَ أَبْرَامُ فِي نَوْمٍ عَمِيقٍ، وَإذَا بِظُلْمَةٍ مُخِيفَةٍ وَمُتَكَاثِفَةٍ تَكْتَنِفُهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","فَقَالَ لَهُ الرَّبُّ: «تَيَقَّنْ أَنَّ نَسْلَكَ سَيَتَغَرَّبُ فِي أَرْضٍ لَيْسَتْ لَهُمْ، فَيَسْتَعْبِدُهُمْ أَهْلُهَا وَيُذِلُّونَهُمْ أَرْبَعَ مِئَةِ سَنَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","وَلَكِنَّنِي سَأَدِينُ تِلْكَ الأُمَّةَ الَّتِي اسْتَعْبَدَتْهُمْ، ثُمَّ بَعْدَ ذَلِكَ يَخْرُجُونَ بِأَمْوَالٍ طَائِلَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","أَمَّا أَنْتَ فَسَتَمُوتُ بِسَلامٍ وَتُدْفَنُ بِشَيْبَةٍ صَالِحَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","أَمَّا هُمْ فَسَيَرْجِعُونَ بَعْدَ أَرْبَعَةِ أَجْيَالٍ إِلَى هُنَا، لأَنَّ إِثْمَ الأَمُورِيِّينَ لَمْ يَكْتَمِلْ بَعْدُ». ");
INSERT INTO arbnav_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","وَعِنْدَمَا غَرَبَتِ الشَّمْسُ وَخَيَّمَ الظَّلامُ (ظَهَرَ) تَنُّورُ دُخَانٍ وَمِشْعَلُ نَارٍ يَجْتَازُ بَيْنَ تِلْكَ الْقِطَعِ. ");
INSERT INTO arbnav_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","فِي ذَلِكَ الْيَوْمِ قَطَعَ اللهُ عَهْداً مَعْ أَبْرَامَ قَائِلاً: «سَأُعْطِي نَسْلَكَ هَذِهِ الأَرْضَ مِنْ وَادِي الْعَرِيشِ إِلَى النَّهْرِ الْكَبِيرِ، نَهْرِ الْفُرَاتِ. ");
INSERT INTO arbnav_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","أَرْضَ الْقَيْنِيِّينَ وَالْقَنِزِّيِّينَ، وَالْقَدْمُونِيِّينَ ");
INSERT INTO arbnav_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","وَالْحِثِّيِّينَ وَالْفَرِزِّيِّينَ وَالرَّفَائِيِّينَ ");
INSERT INTO arbnav_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","وَالأَمُورِيِّينَ وَالْكَنْعَانِيِّينَ وَالْجِرْجَاشِيِّينَ وَالْيَبُوسِيِّينَ». ");
INSERT INTO arbnav_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","وَأَمَّا سَارَايُ زَوْجَةُ أَبْرَامَ فَقَدْ كَانَتْ عَاقِراً، وَكَانَتْ لَهَا جَارِيَةٌ مِصْرِيَّةٌ تُدْعَى هَاجَرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","فَقَالَتْ سَارَايُ لأَبْرَامَ: «هُوَذَا الرَّبُّ قَدْ حَرَمَنِي مِنَ الْوِلادَةِ، فَادْخُلْ عَلَيْهَا لَعَلَّنِي أُرْزَقُ مِنْهَا بَنِينَ». فَسَمِعَ أَبْرَامُ لِكَلامِ زَوْجَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","وَهَكَذَا بَعْدَ إِقَامَةِ عَشْرِ سَنَوَاتٍ فِي أَرْضِ كَنْعَانَ، أَخَذَتْ سَارَايُ جَارِيَتَهَا الْمِصْرِيَّةَ هَاجَرَ وَأَعْطَتْهَا لِرَجُلِهَا أَبْرَامَ لِتَكُونَ زَوْجَةً لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","فَعَاشَرَ هَاجَرَ فَحَبِلَتْ مِنْهُ. وَلَمَّا أَدْرَكَتْ أَنَّهَا حَامِلٌ هَانَتْ مَوْلاتُهَا فِي عَيْنَيْهَا، ");
INSERT INTO arbnav_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","فَقَالَتْ سَارَايُ لأَبْرَامَ: «لِيَقَعْ ظُلْمِي عَلَيْكَ، فَأَنَا قَدْ زَوَّجْتُكَ مِنْ جَارِيَتِي وَحِينَ أَدْرَكَتْ أَنَّهَا حَامِلٌ هِنْتُ فِي عَيْنَيْهَا. لِيَقْضِ الرَّبُّ بَيْنِي وَبَيْنَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","فَأَجَابَهَا أَبْرَامُ: «هَا هِيَ جَارِيَتُكِ تَحْتَ تَصَرُّفِكِ، فَافْعَلِي بِها مَا يَحْلُو لَكِ». فَأَذَلَّتْهَا سَارَايُ حَتَّى هَرَبَتْ مِنْهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","فَوَجَدَهَا مَلاكُ الرَّبِّ بِالْقُرْبِ مِنْ عَيْنِ الْمَاءِ فِي الطَّرِيقِ الْمُؤَدِّيَةِ إِلَى شُورٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","فَقَالَ: «يَا هَاجَرُ جَارِيَةَ سَارَايَ، مِنْ أَيْنَ جِئْتِ؟ وَإِلَى أَيْنَ تَذْهَبِينَ؟». فَأَجَابَتْ: «إِنَّنِي هَارِبَةٌ مِنْ وَجْهِ سَيِّدَتِي سَارَايَ». ");
INSERT INTO arbnav_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","فَقَالَ لَهَا مَلاكُ الرَّبِّ: «عُودِي إِلَى مَوْلاتِكِ وَاخْضَعِي لَهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","وَقَالَ لَهَا مَلاكُ الرَّبِّ: «لأُكَثِّرَنَّ نَسْلَكِ فَلا يَعُودُ يُحْصَى»، ");
INSERT INTO arbnav_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","وَأَضَافَ مَلاكُ الرَّبِّ: «هُوَذَا أَنْتِ حَامِلٌ، وَسَتَلِدِينَ ابْناً تَدْعِينَهُ إِسْمَاعِيلَ (وَمَعْنَاهُ: اللهُ يَسْمَعُ) لأَنَّ الرَّبَّ قَدْ سَمِعَ صَوْتَ شَقَائِكِ. ");
INSERT INTO arbnav_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","وَيَكُونُ إِنْسَاناً وَحْشِيًّا يُعَادِي الْجَمِيعَ وَالْجَمِيعُ يُعَادُونَهُ، وَيَعِيشُ مُسْتَوْحِشاً مُتَحَدِّياً كُلَّ إِخْوَتِهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","فَدَعَتِ اسْمَ الرَّبِّ الَّذِي خَاطَبَهَا: «أَنْتَ اللهُ الَّذِي رَآنِي» لأَنَّهَا قَالَتْ: «حَقّاً رَأَيْتُ الآنَ الَّذِي يَرَانِي» ");
INSERT INTO arbnav_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","لِذَلِكَ سُمِّيَتِ الْبِئْرُ «بِئْرَ لَحَيْ رُئِي» (وَمَعْنَاهُ بِئْرُ الْحَيِّ الَّذِي يَرَانِي) وَهِيَ وَاقِعَةٌ بَيْنَ قَادَشَ وَبَارَدَ. ");
INSERT INTO arbnav_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ثُمَّ وَلَدَتْ هَاجَرُ لأَبْرَامَ ابْناً، فَدَعَا أَبْرَامُ ابْنَهُ الَّذِي أَنْجَبَتْهُ لَهُ هَاجَرُ إِسْمَاعِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","وَكَانَ أَبْرَامُ فِي السَّادِسَةِ وَالثَّمَانِينَ مِنْ عُمْرِهِ عِنْدَمَا وَلَدَتْ لَهُ هَاجَرُ إِسْمَاعِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","وَعِنْدَمَا كَانَ أَبْرَامُ فِي التَّاسِعَةِ وَالتِّسْعِينَ مِنْ عُمْرِهِ، ظَهَرَ لَهُ الرَّبُّ قَائِلاً: «أَنَا هُوَ اللهُ الْقَدِيرُ. سِرْ أَمَامِي وَكُنْ كَامِلاً، ");
INSERT INTO arbnav_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","فَأَجْعَلَ عَهْدِي بَيْنِي وَبَيْنَكَ وَأُكَثِّرَ نَسْلَكَ جِدّاً». ");
INSERT INTO arbnav_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","فَسَقَطَ أَبْرَامُ عَلَى وَجْهِهِ، فَخَاطَبَهُ اللهُ قَائِلاً: ");
INSERT INTO arbnav_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«هَا أَنَا أَقْطَعُ لَكَ عَهْدِي، فَتَكُونُ أَباً لأُمَمٍ كَثِيرَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","وَلَنْ يُدْعَى اسْمُكَ بَعْدَ الآنَ أَبْرَامَ (وَمَعْنَاهُ الأَبُ الرَّفِيعُ) بَلْ يَكُونُ اسْمُكَ إِبْرَاهِيمَ (وَمَعْنَاهُ أَبٌ لِجُمْهُورٍ) لأَنِّي أَجْعَلُكَ أَباً لِجُمْهُورٍ مِنَ الأُمَمِ؛ ");
INSERT INTO arbnav_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","وَأُصَيِّرُكَ مُثْمِراً جِدّاً، وَأَجْعَلُ أُمَماً تَتَفَرَّعُ مِنْكَ، وَيَخْرُجُ مِنْ نَسْلِكَ مُلُوكٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","وَأُقِيمُ عَهْدِي الأَبَدِيَّ بَيْنِي وَبَيْنَكَ، وَبَيْنَ نَسْلِكَ مِنْ بَعْدِكَ جِيلاً بَعْدَ جِيلٍ، فَأَكُونُ إِلَهاً لَكَ وَلِنَسْلِكَ مِنْ بَعْدِكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","وَأَهَبُكَ أَنْتَ وَذُرِّيَّتَكَ مِنْ بَعْدِكَ جَمِيعَ أَرْضِ كَنْعَانَ، الَّتِي نَزَلْتَ فِيهَا غَرِيباً، مُلْكاً أَبَدِيًّا. وَأَكُونُ لَهُمْ إِلَهاً». ");
INSERT INTO arbnav_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","وَقَالَ الرَّبُّ لإِبْرَاهِيمَ: «أَمَّا أَنْتَ فَاحْفَظْ عَهْدِي، أَنْتَ وَذُرِّيَّتُكَ مِنْ بَعْدِكَ مَدَى أَجْيَالِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","هَذَا هُوَ عَهْدِي الَّذِي بَيْنِي وَبَيْنَكَ وَبَيْنَ ذُرِّيَّتِكَ مِنْ بَعْدِكَ الَّذِي عَلَيْكُمْ أَنْ تَحْفَظُوهُ: أَنْ يُخْتَتَنَ كُلُّ ذَكَرٍ مِنْكُمْ ");
INSERT INTO arbnav_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","تَخْتِنُونَ رَأْسَ قُلْفَةِ غُرْلَتِكُمْ فَتَكُونُ عَلامَةَ الْعَهْدِ الَّذِي بَيْنِي وَبَيْنَكُمْ ");
INSERT INTO arbnav_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","تَخْتِنُونَ عَلَى مَدَى أَجْيَالِكُمْ كُلَّ ذَكَرٍ فِيكُمُ ابْنَ ثَمَانِيَةِ أَيَّامٍ سَوَاءٌ كَانَ الْمَوْلُودُ مِنْ ذُرِّيَّتِكَ أَمْ كَانَ ابْناً لِغَرِيبٍ مُشْتَرىً بِمَالِكَ مِمَّنْ لَيْسَ مِنْ نَسْلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","فَعَلَى كُلِّ وَلِيدٍ سَوَاءٌ وُلِدَ فِي بَيْتِكَ أَمِ اشْتُرِيَ بِمَالٍ أَنْ يُخْتَنَ، فَيَكُونُ عَهْدِي فِي لَحْمِكُمْ عَهْداً أَبَدِيًّا. ");
INSERT INTO arbnav_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","أَمَّا الذَّكَرُ الأَغْلَفُ الَّذِي لَمْ يُخْتَنْ، يُسْتَأْصَلُ مِنْ بَيْنِ قَوْمِهِ لأَنَّهُ نَكَثَ عَهْدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","وَقَالَ الرَّبُّ لإِبْرَاهِيمَ: «أَمَّا سَارَايُ زَوْجَتُكَ فَلا تَدْعُوهَا سَارَايَ بَعْدَ الآنَ، بَلْ يَكُونُ اسْمُهَا سَارَةَ (وَمَعْنَاهُ أَمِيرةٌ). ");
INSERT INTO arbnav_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","وَأُبَارِكُهَا وَأُعْطِيكَ ابْناً مِنْهَا. سَأُبَارِكُهَا وَأَجْعَلُهَا أُمّاً لِشُعُوبٍ، وَمِنْهَا يَتَحَدَّرُ مُلُوكُ أُمَمٍ». ");
INSERT INTO arbnav_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","فَانْطَرَحَ إِبْرَاهِيمُ عَلَى وَجْهِهِ وَضَحِكَ قَائِلاً فِي نَفْسِهِ: «أَيُوْلَدُ ابْنٌ لِمَنْ بَلَغَ الْمِئَةَ مِنْ عُمْرِهِ؟ وَهَلْ تُنْجِبُ سَارَةُ وَهِيَ فِي التِّسْعِينَ مِنْ عُمْرِهَا؟» ");
INSERT INTO arbnav_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","وَقَالَ إِبْرَاهِيمُ لِلهِ: «لَيْتَ إِسْمَاعِيلَ يَحْيَا فِي رِعَايَتِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","فَأَجَابَ الرَّبُّ: «إِنَّ سَارَةَ زَوْجَتَكَ هِيَ الَّتِي تَلِدُ لَكَ ابْناً وَتَدْعُو اسْمَهُ إِسْحاقَ (وَمَعْنَاهُ يَضْحَكُ). وَأُقِيمُ عَهْدِي مَعَهُ وَمَعَ ذُرِّيَّتِهِ مِنْ بَعْدِهِ عَهْداً أَبَدِيًّا. ");
INSERT INTO arbnav_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","أَمَّا إِسْمَاعِيلُ، فَقَدِ اسْتَجَبْتُ لِطِلْبَتِكَ مِنْ أَجْلِهِ. سَأُبَارِكُهُ حَقّاً، وَأَجْعَلُهُ مُثْمِراً، وَأُكَثِّرُ ذُرِّيَّتَهُ جِدّاً فَيَكُونُ أَباً لاثْنَيْ عَشَرَ رَئِيساً، وَيُصْبِحُ أُمَّةً كَبِيرَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","غَيْرَ أَنَّ عَهْدِي أُبْرِمُهُ مَعَ إِسْحاقَ الَّذِي تُنْجِبُهُ لَكَ سَارَةُ فِي مِثْلِ هَذَا الْوَقْتِ مِنَ السَّنَةِ الْقَادِمَةِ». ");
INSERT INTO arbnav_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","وَلَمَّا انْتَهَى مِنْ مُحَادَثَتِهِ فَارَقَ اللهُ إِبْرَاهِيمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","وَفِي ذَلِكَ الْيَوْمِ بِعَيْنِهِ أَخَذَ إِبْرَاهِيمُ إِسْمَاعِيلَ وَجَمِيعَ الْمَوْلُودِينَ فِي بَيْتِهِ وَكُلَّ مَنِ اشْتُرِيَ بِمَالٍ، كُلَّ ذَكَرٍ مِنْ أَهْلِ بَيْتِهِ وَخَتَنَ لَحْمَ غُرْلَتِهِمْ كَمَا أَمَرَهُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","وَكَانَ إِبْرَاهِيمُ فِي التَّاسِعَةِ وَالتِّسْعِينَ مِنْ عُمْرِهِ عِنْدَمَا خُتِنَ فِي لَحْمِ غُرْلَتِهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","أَمَّا إِسْمَاعِيلُ ابْنُهُ فَقَدْ كَانَ ابْنَ ثَلاثَ عَشْرَةَ سَنَةً حِينَ خُتِنَ فِي لَحْمِ غُرْلَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","وَهَكَذَا خُتِنَ إِبْرَاهِيمُ وَإِسْمَاعِيلُ ابْنُهُ فِي الْيَوْمِ نَفْسِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","وَكَذَلِكَ خُتِنَ مَعَهُ كُلُّ رِجَالِ بَيْتِهِ الْمَوْلُودِينَ فِيهِ وَالْمُبْتَاعِينَ بِمَالٍ مِنَ الْغَرِيبِ. ");
INSERT INTO arbnav_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ثُمَّ ظَهَرَ الرَّبُّ لإِبْرَاهِيمَ وَهُوَ جَالِسٌ عِنْدَ بَلُّوطَاتِ مَمْرَا وَقْتَ اشْتِدَادِ حَرِّ النَّهَارِ، ");
INSERT INTO arbnav_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","فَرَفَعَ عَيْنَيْهِ وَإذَا بِهِ يَرَى ثَلاثَةَ رِجَالٍ مَاثِلِينَ لَدَيْهِ. فَأَسْرَعَ لاسْتِقْبَالِهِمْ مِنْ بَابِ الْخَيْمَةِ وَسَجَدَ إِلَى الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","وَقَالَ: «يَا سَيِّدِي، إِنْ كُنْتُ قَدْ حَظِيْتُ بِرِضَاكَ فَلا تَعْبُرْ عَنْ عَبْدِكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","بَلْ دَعْنِي أُقَدِّمُ لَكُمْ بَعْضَ مَاءٍ تَغْسِلُونَ بِهِ أَرْجُلَكُمْ وَتَتَّكِئُونَ تَحْتَ الشَّجَرَةِ، ");
INSERT INTO arbnav_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ثُمَّ آتِي لَكُمْ بِلُقْمَةِ خُبْزٍ تُسْنِدُونَ بِها قُلُوبَكُمْ، وَبَعْدَ ذَلِكَ تُوَاصِلُونَ مَسِيرَتَكُمْ، لأَنَّكُمْ قَدْ مِلْتُمْ إِلَى بَيْتِ عَبْدِكُمْ». فَأَجَابُوهُ: «حَسَناً، لِيَكُنْ كَمَا قُلْتَ». ");
INSERT INTO arbnav_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","فَأَسْرَعَ إِبْرَاهِيمُ إِلَى دَاخِلِ الْخَيْمَةِ إِلَى زَوْجَتِهِ سَارَةَ وَقَالَ: «هَيَّا أَسْرِعِي وَاعْجِنِي ثَلاثَ كَيْلاتٍ مِنْ أَفْضَلِ الدَّقِيقِ وَاخْبِزِيهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ثُمَّ أَسْرَعَ إِبْرَاهِيمُ نَحْوَ قَطِيعِهِ وَاخْتَارَ عِجْلاً غَضّاً مُسَمَّناً وَأَعْطَاهُ لِغُلامٍ كَيْ يُجَهِّزَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ثُمَّ أَخَذَ زُبْداً وَلَبَناً وَالْعِجْلَ الَّذِي طَبَخَهُ، وَمَدَّهَا أَمَامَهُمْ، وَبَقِيَ وَاقِفاً فِي خِدْمَتِهِمْ تَحْتَ الشَّجَرَةِ وَهُمْ يَأْكُلُونَ. ");
INSERT INTO arbnav_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ثُمَّ سَأَلُوهُ: «أَيْنَ زَوْجَتُكَ؟» فَأَجَابَ: «هَا هِيَ فِي الْخَيْمَةِ». ");
INSERT INTO arbnav_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","فَقَالَ: «إِنِّي أَرْجِعُ إِلَيْكَ فِي مِثْلِ هَذَا الْوَقْتِ مِنَ السَّنَةِ الْقَادِمَةِ فَتَكُونُ سَارَةُ آنَئِذٍ قَدْ وَلَدَتْ لَكَ ابْناً». وَكَانَتْ سَارَةُ وَرَاءَهُ، عِنْدَ بَابِ الْخَيْمَةِ، فَسَمِعَتْ حَدِيثَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","وَكَانَ إِبْرَاهِيمُ وَسَارَةُ عَجُوزَيْنِ طَاعِنَيْنِ جِدّاً فِي السِّنِّ وَقَدْ تَجَاوَزَتْ سَارَةُ سِنَّ الْيَأْسِ. ");
INSERT INTO arbnav_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","فَضَحِكَتْ سَارَةُ فِي نَفْسِهَا قَائِلَةً: «أَبَعْدَ أَنْ فَنِيَ عُمْرِي وَأَصْبَحَ زَوْجِي شَيْخاً يَكُونُ لِي هَذَا التَّنَعُّمُ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","فَقَالَ الرَّبُّ لإِبْرَاهِيمَ: «لِمَاذَا ضَحِكَتْ سَارَةُ قَائِلَةً: أَحَقّاً أَلِدُ ابْناً وَقَدْ بَلَغْتُ سِنَّ الشَّيْخُوخَةِ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","أَيَتَعَذَّرُ عَلَى الرَّبِّ شَيْءٌ؟ سَأَرْجِعُ إِلَيْكَ فِي مِثْلِ هَذَا الْوَقْتِ مِنَ السَّنَةِ الْقَادِمَةِ فَتَكُونُ سَارَةُ قَدْ أَنْجَبَتِ ابْناً». ");
INSERT INTO arbnav_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","فَخَافَتْ سَارَةُ وَأَنْكَرَتْ قَائِلَةً: «لَمْ أَضْحَكْ». فَقَالَ: «لا، بَلْ ضَحِكْتِ». ");
INSERT INTO arbnav_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ثُمَّ نَهَضَ الرِّجَالُ وَتَطَلَّعُوا نَحْوَ سَدُومَ. فَمَشَى إِبْرَاهِيمُ مَعَهُمْ لِيُوَدِّعَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","فَقَالَ الرَّبُّ: «أَأَكْتُمُ عَنْ إِبْرَاهِيمَ مَا أَنَا فَاعِلُهُ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","وَإِبْرَاهِيمُ لابُدَّ أَنْ يُصْبِحَ أُمَّةً كَبِيرَةً وَقَوِيَّةً، وَبِهِ تَتَبَارَكُ شُعُوبُ الأَرْضِ جَمِيعاً، ");
INSERT INTO arbnav_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","لأَنَّنِي قَدِ اخْتَرْتُهُ لِيُوْصِيَ بَنِيهِ وَأَهْلَ بَيْتِهِ مِنْ بَعْدِهِ كَيْ يَحْفَظُوا طَرِيقَ الرَّبِّ، عَامِلِينَ الْبِرَّ وَالْعَدْلَ، حَتَّى يُنْجِزَ الرَّبُّ مَا وَعَدَ بِهِ إِبْرَاهِيمَ». ");
INSERT INTO arbnav_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","وَقَالَ الرَّبُّ: «لأَنَّ الشَّكْوَى ضِدَّ مَظَالِمِ سَدُومَ وَعَمُورَةَ قَدْ كَثُرَتْ وَخَطِيئَتُهُمْ قَدْ عَظُمَتْ جِدّاً ");
INSERT INTO arbnav_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","أَنْزِلُ لأَرَى إِنْ كَانَتْ أَعْمَالُهُمْ مُطَابِقَةً لِلشَّكْوَى ضِدَّهُمْ وَإلَّا فَأَعْلَمُ». ");
INSERT INTO arbnav_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","وَانْطَلَقَ الرَّجُلانِ مِنْ هُنَاكَ نَحْوَ سَدُومَ، وَبَقِيَ إِبْرَاهِيمُ مَاثِلاً أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","فَاقْتَرَبَ إِبْرَاهِيمُ وَقَالَ: «أَتُهْلِكُ الْبَارَّ مَعَ الأَثِيمِ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","لَوْ وُجِدَ فِي الْمَدِينَةِ خَمْسُونَ بَارّاً، فَهَلْ تُدَمِّرُهَا وَلا تَصْفَحُ عَنْهَا مِنْ أَجْلِ الْخَمْسِينَ بَارّاً الَّذِينَ فِيهَا؟ ");
INSERT INTO arbnav_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","تَنَزَّهْتَ عَنْ أَنْ تُهْلِكَ الْبَارَّ مَعَ الأَثِيمِ، فَيَكُونُ الْبَارُّ كَالأَثِيمِ؛ حَاشَا لَكَ. أَدَيَّانُ الأَرْضِ كُلِّهَا لَا يُجْرِي عَدْلاً؟» ");
INSERT INTO arbnav_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","فَقَالَ الرَّبُّ: «إِنْ وَجَدْتُ فِي سَدُومَ خَمْسِينَ بَارّاً فَإِنَّنِي أَصْفَحُ عَنِ الْمَكَانِ كُلِّهِ مِنْ أَجْلِهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","فَأَجَابَ إِبْرَاهِيمُ: «هَا أَنَا قَدْ أَخَذْتُ فِي مُخَاطَبَةِ الْمَوْلَى، مَعَ أَنَّنِي لَسْتُ سِوَى تُرَابٍ وَرَمَادٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","مَاذَا لَوْ نَقَصَ الْخَمْسُونَ بَارّاً خَمْسَةً؟ أَفَتُهْلِكُ الْمَدِينَةَ كُلَّهَا مِنْ أَجْلِ الْخَمْسَةِ؟» فَأَجَابَهُ: «إِنْ وَجَدْتُ خَمْسَةً وَأَرْبَعِينَ بَارّاً لَا أُهْلِكُهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","فَخَاطَبَهُ إِبْرَاهِيمُ ثَانِيَةً: «وَمَاذَا لَوْ وُجِدَ هُنَاكَ أَرْبَعُونَ بَارّاً فَقَطْ؟». فَأَجَابَهُ: «لا أُهْلِكُهَا مِنْ أَجْلِ الأَرْبَعِينَ». ");
INSERT INTO arbnav_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","وَقَالَ إِبْرَاهِيمُ: «لا يَغْضَبِ الْمَوْلَى، بَلْ دَعْنِي أَتَكَلَّمُ. مَاذَا لَوْ وُجِدَ هُنَاكَ ثَلاثُونَ بَارّاً؟». فَأَجَابَهُ: «لا أُهْلِكُهَا إِنْ وَجَدْتُ ثَلاثِينَ». ");
INSERT INTO arbnav_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","وَقَالَ إِبْرَاهِيمُ: «هَا أَنَا قَدِ اسْتَرْسَلْتُ فِي الْكَلامِ أَمَامَ الْمَوْلَى، فَمَاذَا لَوْ وَجَدْتَ هُنَاكَ عِشْرِينَ بَارّاً؟» فَقَالَ: «لا أُهْلِكُهَا مِنْ أَجْلِ الْعِشْرِينَ». ");
INSERT INTO arbnav_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","وَقَالَ إِبْرَاهِيمُ: «لا يَغْضَبِ الْمَوْلَى، فَأَتَكَلَّمَ مَرَّةً أُخْرَى: مَاذَا لَوْ وُجِدَ هُنَاكَ عَشَرَةٌ؟». فَأَجَابَهُ الرَّبُّ: «لا أُهْلِكُهَا مِنْ أَجْلِ الْعَشَرَةِ». ");
INSERT INTO arbnav_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","وَعِنْدَمَا فَرَغَ الرَّبُّ مِنْ مُحَادَثَةِ إِبْرَاهِيمَ مَضَى، وَرَجَعَ إِبْرَاهِيمُ إِلَى مَكَانِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","وَأَقْبَلَ الْمَلاكَانِ عَلَى سَدُومَ عِنْدَ الْمَسَاءِ. وَكَانَ لُوطٌ جَالِساً عِنْدَ بَابِ سَدُومَ، فَمَا إِنْ رَآهُمَا حَتَّى نَهَضَ لاسْتِقْبَالِهِمَا، وَسَجَدَ بِوَجْهِهِ إِلَى الأَرْضِ، ");
INSERT INTO arbnav_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","وَقَالَ: «يَا سَيِّدَيَّ، انْزِلا فِي بَيْتِ عَبْدِكُمَا لِتَقْضِيَا لَيْلَتَكُمَا، وَاغْسِلا أَرْجُلَكُمَا، وَفِي الصَّبَاحِ الْبَاكِرِ تَمْضِيَانِ فِي طَرِيقِكُمَا». لَكِنَّهُمَا قَالا: «لا، بَلْ نَمْكُثُ اللَّيْلَةَ فِي السَّاحَةِ». ");
INSERT INTO arbnav_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","فَأَصَرَّ عَلَيْهِمَا جِدّاً حَتَّى قَبِلا الذَّهَابَ مَعَهُ وَالنُّزُولَ فِي بَيْتِهِ. فَأَعَدَّ لَهُمَا مَأْدُبَةً وَخَبَزَ فَطِيراً فَأَكَلا. ");
INSERT INTO arbnav_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","وَقَبْلَ أَنْ يَرْقُدَا، حَاصَرَ رِجَالُ مَدِينَةِ سَدُومَ مِنْ أَحْدَاثٍ وَشُيُوخٍ، الْبَيْتَ، ");
INSERT INTO arbnav_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","وَنَادُوا لُوطاً: «أَيْنَ الرَّجُلانِ اللَّذَانِ اسْتَضَفْتَهُمَا اللَّيْلَةَ؟ أَخْرِجْهُمَا إِلَيْنَا لِنُضَاجِعَهُمَا». ");
INSERT INTO arbnav_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","فَخَرَجَ إِلَيْهِمْ لُوطٌ بَعْدَ أَنْ أَغْلَقَ الْبَابَ خَلْفَهُ، ");
INSERT INTO arbnav_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","وَقَالَ: «لا تَرْتَكِبُوا شَرّاً يَا إِخْوَتِي. ");
INSERT INTO arbnav_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","هُوَذَا لِي ابْنَتَانِ عَذْرَاوَانِ أُخْرِجُهُمَا إِلَيْكُمْ فَافْعَلُوا بِهِمَا مَا يَحْلُو لَكُمْ، أَمَّا هَذَانِ الرَّجُلانِ فَلا تُسِيئوا إِلَيْهِمَا لأَنَّهُمَا لَجَآ إِلَى حِمَى مَنْزِلِي». ");
INSERT INTO arbnav_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","فَقَالُوا: «تَنَحَّ بَعِيداً»، وَأَضَافُوا: «لَقَدْ جَاءَ هَذَا الإِنْسَانُ لِيَتَغَرَّبَ بَيْنَنَا، وَهَا هُوَ يَتَحَكَّمُ فِينَا. الآنَ نَفْعَلُ بِكَ شَرّاً أَكْثَرَ مِنْهُمَا». وَتَدَافَعُوا حَوْلَ لُوطٍ وَتَقَدَّمُوا لِيُحَطِّمُوا الْبَابَ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","غَيْرَ أَنَّ الرَّجُلَيْنِ مَدَّا أَيْدِيَهُمَا وَاجْتَذَبَا لُوطاً إِلَى دَاخِلِ الْبَيْتِ، وَأَغْلَقَا الْبَابَ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ثُمَّ ضَرَبَا الرِّجَالَ، صَغِيرَهُمْ وَكَبِيرَهُمْ، الْوَاقِفِينَ أَمَامَ بَابِ الْبَيْتِ بِالْعَمَى، فَعَجَزُوا عَنِ الْعُثُورِ عَلَى الْبَابِ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","وَقَالَ الرَّجُلانِ لِلُوطٍ: «أَلَكَ أَقْرِبَاءُ فِي هَذِهِ الْمَدِينَةِ؟ أَصْهَارٌ وَأَبْنَاءٌ وَبَنَاتٌ أَوْ أَيُّ شَخْصٍ آخَرَ يَمُتُّ إِلَيْكَ بِصِلَةٍ؟ أَخْرِجْهُمْ مِنْ هُنَا، ");
INSERT INTO arbnav_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","لأَنَّنَا عَازِمَانِ عَلَى تَدْمِيرِ هَذَا الْمَكَانِ، إِذْ أَنَّ صُرَاخَ الشَّكْوَى مِنْ شَرِّهِ قَدْ تَعَاظَمَ أَمَامَ الرَّبِّ، فَأَرْسَلَنَا الرَّبُّ لِنُدَمِّرَهُ». ");
INSERT INTO arbnav_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","فَمَضَى لُوطٌ وَخَاطَبَ أَصْهَارَهُ أَزْوَاجَ بَنَاتِهِ، قَائِلاً: «هَيَّا. قُومُوا وَاخْرُجُوا مِنْ هَذَا الْمَكَانِ، لأَنَّ الرَّبَّ سَيُدَمِّرُ هَذِهِ الْمَدِينَةَ». فَبَدَا كَمَازِحٍ فِي أَعْيُنِ أَصْهَارِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","وَمَا إِنْ أَطَلَّ الْفَجْرُ حَتَّى طَفِقَ الْمَلاكَانِ يَلِحَّانِ عَلَى لُوطٍ قَائِلَيْنِ: «هَيَّا انْهَضْ وَخُذْ زَوْجَتَكَ وَابْنَتَيْكَ اللَّتَيْنِ هُنَا، لِئَلّا تَهْلِكَ بِإِثْمِ الْمَدِينَةِ». ");
INSERT INTO arbnav_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","وَإِذْ تَوَانَى لُوطٌ، أَمْسَكَ الرَّجُلانِ بِيَدِهِ وَأَيْدِي زَوْجَتِهِ وَابْنَتَيْهِ وَقَادَاهُمْ إِلَى خَارِجِ الْمَدِينَةِ، لأَنَّ الرَّبَّ أَشْفَقَ عَلَيْهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","وَمَا إِنْ أَخْرَجَاهُمْ بَعِيداً حَتَى قَالَ أَحَدُ الْمَلاكَيْنِ: «اُنْجُ بِحَيَاتِكَ. لَا تَلْتَفِتْ وَرَاءَكَ وَلا تَتَوَقَّفْ فِي كُلِّ مِنْطَقَةِ السَّهْلِ. اهْرُبْ إِلَى الْجَبَلِ لِئَلّا تَهْلِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","فَقَالَ لُوطٌ: «لَيْسَ هَكَذَا يَا سَيِّدُ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","هَا عَبْدُكَ قَدْ حَظِيَ بِرِضَاكَ، وَهَا أَنْتَ قَدْ عَظَّمْتَ لُطْفَكَ إِذْ أَنْقَذْتَ حَيَاتِي، وَأَنَا لَا أَسْتَطِيعُ اللُّجُوءَ إِلَى الْجَبَلِ لِئَلّا يُدْرِكَنِي مَكْرُوهٌ فَأَمُوتَ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","هَا هِيَ الْمَدِينَةُ قَرِيبَةٌ يَسْهُلُ الْهَرَبُ إِلَيْهَا. إِنَّهَا مَدِينَةٌ صَغِيرَةٌ، فَدَعْنِي أَلْجَأُ إِلَيْهَا. أَلَيْسَتْ هِيَ مَدِينَةً صَغِيرَةً جِدّاً فَأَنْجُوَ فِيهَا بِحَيَاتِي؟» ");
INSERT INTO arbnav_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","فَقَالَ لَهُ الْمَلاكُ: «إِنِّي قَدْ قَبِلْتُ طِلْبَتَكَ بِشَأْنِ هَذَا الأَمْرِ، وَلَنْ أُدَمِّرَ هَذِهِ الْمَدِينَةَ الَّتِي ذَكَرْتَهَا ");
INSERT INTO arbnav_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","أَسْرِعْ، وَاهْرُبْ إِلَيْهَا، لأَنَّنِي لَا أَسْتَطِيعُ أَنْ أَصْنَعَ شَيْئاً إِلَى أَنْ تَبْلُغَهَا». لِذَلِكَ دُعِيَ اسْمُ تِلْكَ الْمَدِينَةِ صُوغَرَ (وَمَعْنَاهَا صَغِيرَةٌ). ");
INSERT INTO arbnav_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","وَمَا إِنْ أَشْرَقَتِ الشَّمْسُ عَلَى الأَرْضِ حَتَّى كَانَ لُوطٌ قَدْ دَخَلَ إِلَى صُوغَرَ، ");
INSERT INTO arbnav_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","فَأَمْطَرَ الرَّبُّ عَلَى سَدُومَ وَعَمُورَةَ كِبْرِيتاً وَنَاراً، مِنْ عِنْدِهِ مِنَ السَّمَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","وَقَلَبَ تِلْكَ الْمُدُنَ وَالسَّاكِنِينَ فِيهَا، وَالسَّهْلَ الْمُحِيطَ بِها وَكُلَّ مَزْرُوعَاتِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","وَتَلَفَّتَتْ زَوْجَةُ لُوطٍ السَّائِرَةُ خَلْفَهُ وَرَاءَهَا، فَتَحَوَّلَتْ إِلَى عَمُودٍ مِنَ الْمِلْحِ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","وَمَضَى إِبْرَاهِيمُ مُبَكِّراً فِي الصَّبَاحِ إِلَى الْمَكَانِ الَّذِي وَقَفَ فِيهِ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","وَتَطَلَّعَ نَحْوَ سَدُومَ وَعَمُورَةَ وَلِسَائِرِ أَرْضِ السَّهْلِ، فَأَبْصَرَ الدُّخَانَ يَتَصَاعَدُ مِنْهَا كَالأَتُونِ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","وَهَكَذَا عِنْدَمَا دَمَّرَ اللهُ مُدُنَ السَّهْلِ ذَكَرَ إِبْرَاهِيمَ، فَأَخْرَجَ لُوطاً قُبَيْلَ وُقُوعِ الْكَارِثَةِ حِينَ قَلَبَ الْمُدُنَ الَّتِي سَكَنَ فِيهَا لُوطٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","وَغَادَرَ لُوطٌ وَابْنَتَاهُ بَعْدَ ذَلِكَ صُوغَرَ، وَاسْتَقَرُّوا فِي الْجَبَلِ لأَنَّهُ خَافَ أَنْ يَسْكُنَ فِي صُوغَرَ. فَلَجَأَ هُوَ وَابْنَتَاهُ إِلَى كَهْفٍ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","فَقَالَتْ الابْنَةُ الْبِكْرُ لأُخْتِهَا الصَّغِيرَةِ: «إِنَّ أَبَانَا قَدْ شَاخَ وَلَيْسَ فِي الأَرْضِ حَوْلَنَا رَجُلٌ يَتَزَوَّجُنَا كَعَادَةِ كُلِّ النَّاسِ. ");
INSERT INTO arbnav_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","فَتَعَالَيْ نَسْقِيهِ خَمْراً وَنَضْطَجِعُ مَعَهُ فَلا تَنْقَطِعُ ذُرِّيَّةُ أَبِينَا». ");
INSERT INTO arbnav_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","فَسَقَتَا فِي تِلْكَ اللَّيْلَةِ أَبَاهُمَا خَمْراً، وَأَقْبَلَتْ الابْنَةُ الْكُبْرَى وَضَاجَعَتْ أَبَاهَا فَلَمْ يَعْلَمْ بِاضْطِجَاعِهَا وَلا بِقِيَامِهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","وَفِي الْيَوْمِ الثَّانِي قَالَتْ الابْنَةُ الْبِكْرُ لأُخْتِهَا الصَّغِيرَةِ: «إِنِّي قَدِ اضْطَجَعْتُ مَعَ أَبِي لَيْلَةَ أَمْسِ، فَتَعَالَيْ نَسْقِيهِ اللَّيْلَةَ أَيْضاً خَمْراً ثُمَّ ادْخُلِي وَاضْطَجِعِي مَعَهُ فَنُحْيِيَ مِنْ أَبِينَا نَسْلاً». ");
INSERT INTO arbnav_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","فَسَقَتَا أَبَاهُمَا خَمْراً فِي تِلْكَ اللَّيْلَةِ أَيْضاً وَأَقْبَلَتْ الابْنَةُ الصَّغِيرَةُ وَضَاجَعَتْ أَبَاهَا. فَلَمْ يَعْلَمْ بِاضْطِجَاعِهَا وَلا بِقِيَامِهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","وَهَكَذَا حَمَلَتْ الابْنَتَانِ كِلْتَاهُمَا مِنْ أَبِيهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","فَوَلَدَتِ الْكُبْرَى ابْناً دَعَتْهُ مُوآبَ (وَمَعْنَاهُ مِنَ الأَبِ)، وَهُوَ أَبُو الْمُوآبِيِّينَ إِلَى الْيَوْمِ، ");
INSERT INTO arbnav_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","أَمَّا الصُّغْرَى فَوَلَدَتِ ابْناً وَدَعَتْهُ «بِنْ عَمِّي» (وَمَعْنَاهُ ابْنُ قَوْمِي) وَهُوَ أَبُو بَنِي عَمُّونَ إِلَى الْيَوْمِ. ");
INSERT INTO arbnav_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","وَارْتَحَلَ إِبْرَاهِيمُ مِنْ هُنَاكَ إِلَى أَرْضِ النَّقَبِ، وَأَقَامَ بَيْنَ قَادَشَ وَشُورَ، وَتَغَرَّبَ فِي جَرَارَ. ");
INSERT INTO arbnav_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","وَهُنَاكَ قَالَ إِبْرَاهِيمُ عَنْ سَارَةَ زَوْجَتِهِ: «هِيَ أُخْتِي». فَأَرْسَلَ أَبِيمَالِكُ مَلِكُ جَرَارَ وَأَحْضَرَ سَارَةَ إِلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","وَلِكَنَّ اللهَ تَجَلَّى لأَبِيمَالِكَ فِي حُلْمٍ فِي اللَّيْلِ وَقَالَ لَهُ: «إِنَّكَ سَتَمُوتُ بِسَبَبِ الْمَرْأَةِ الَّتِي أَخَذْتَهَا، فَإِنَّهَا مُتَزَوِّجَةٌ». ");
INSERT INTO arbnav_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","وَلَمْ يَكُنْ أَبِيمَالِكُ قَدْ مَسَّهَا بَعْدُ، فَقَالَ لِلرَّبِّ: «أَتُمِيتُ أُمَّةً بَرِيئَةً؟ ");
INSERT INTO arbnav_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","أَلَمْ يَقُلْ لِي إِنَّهَا أُخْتِي وَهِيَ نَفْسُهَا ادَّعَتْ أَنَّهُ أَخُوهَا؟ مَا فَعَلْتُ هَذَا إِلّا بِسَلامَةِ قَلْبِي وَطَهَارَةِ يَدَيَّ». ");
INSERT INTO arbnav_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","فَأَجَابَهُ الرَّبُّ: «أَنَا أَيْضاً عَلِمْتُ أَنَّكَ بِسَلامَةِ قَلْبِكَ قَدْ فَعَلْتَ هَذَا، وَأَنَا أَيْضاً مَنَعْتُكَ مِنْ أَنْ تُخْطِئَ إِلَيَّ وَلَمْ أَدَعْكَ تَمَسُّهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","وَالآنَ، رُدَّ لِلرَّجُلِ زَوْجَتَهُ فَإِنَّهُ نَبِيٌّ، فَيُصَلِّيَ مِنْ أَجْلِكَ فَتَحْيَا. وَإِنْ لَمْ تَرُدَّهَا فَإِنَّك وَكُلَّ مَنْ لَكَ حَتْماً تَمُوتُونَ». ");
INSERT INTO arbnav_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","فَبَكَّرَ أَبِيمَالِكُ فِي الصَّبَاحِ وَاسْتَدْعَى جَمِيعَ عَبِيدِهِ، وَأَطْلَعَهُمْ عَلَى جَلِيَّةِ الأَمْرِ، فَاعْتَرَاهُمْ خَوْفٌ عَظِيمٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ثُمَّ دَعَا أَبِيمَالِكُ إِبْرَاهِيمَ وَقَالَ لَهُ: «مَاذَا فَعَلْتَ بِنَا؟ أَيُّ خَطَأٍ ارْتَكَبْتُهُ فِي حَقِّكَ حَتَّى جَلَبْتَ عَلَيَّ وَعَلَى مَمْلَكَتِي هَذَا الذَّنْبَ الْعَظِيمَ؟ لَقَدِ اقْتَرَفْتَ فِي حَقِّي أُمُوراً مَا كَانَ يَجِبُ أَنْ تَقْتَرِفَهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","وَسَأَلَ أَبِيمَالِكُ إِبْرَاهِيمَ: «مَاذَا بَدَا لَكَ حَتَّى ارْتَكَبْتَ هَذَا الْفِعْلَ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","فَقَالَ إِبْرَاهِيمُ: «لَقَدْ فَعَلْتُ هَذَا لأَنَّنِي ظَنَنْتُ أَنَّهُ لَيْسَ فِي هَذَا الْمَوْضِعِ بِأَسْرِهِ خَوْفُ اللهِ فَخَشِيتُ أَنْ تَقْتُلُونِي مِنْ أَجْلِ زَوْجَتِي. ");
INSERT INTO arbnav_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","وَهِيَ بِالْحَقِيقَةِ أُخْتِي، ابْنَةُ أَبِي، غَيْرَ أَنَّهَا لَيْسَتْ ابْنَةَ أُمِّي فَاتَّخَذْتُهَا زَوْجَةً لِي. ");
INSERT INTO arbnav_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","وَعِنْدَمَا دَعَانِي اللهُ لأَتَغَرَّبَ بَعِيداً عَنْ بَيْتِ أَبِي قُلْتُ لَهَا: حَيْثُمَا نَذْهَبُ قُولِي إِنِّي أَخُوكِ فَهَذَا هُوَ الْمَعْرُوفُ الَّذِي تَصْنَعِينَهُ لِي». ");
INSERT INTO arbnav_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","فَأَخَذَ أَبِيمَالِكُ غَنَماً وَبَقَراً وَعَبِيداً وَإِمَاءً وَقَدَّمَهَا لإِبْرَاهِيمَ، وَأَرْجَعَ إِلَيْهِ سَارَةَ زَوْجَتَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","وَقَالَ أَبِيمَالِكُ: «هَا هِيَ أَرْضِي أَمَامَكَ فَأَقِمْ حَيْثُ طَابَ لَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","وَقَالَ لِسَارَةَ: «هَا قَدْ وَهَبْتُ أَخَاكِ أَلْفَ قِطْعَةٍ مِنَ الْفِضَّةِ، تَبْرِئَةً لَكِ مِنْ كُلِّ إِسَاءَةٍ أَمَامَ الَّذِينَ مَعَكِ، فَأَنْتِ بَرِيئَةٌ أَمَامَ كُلِّ وَاحِدٍ، وَهَكَذَا تَكُونِينَ قَدْ أُنْصِفْتِ». ");
INSERT INTO arbnav_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","فَابْتَهَلَ إِبْرَاهِيمُ إِلَى اللهِ، فَشَفَى أَبِيمَالِكَ وَزَوْجَتَهُ وَجَوَارِيَهُ فَوَلَدْنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","لأَنَّ الرَّبَّ كَانَ قَدْ أَصَابَ نِسَاءَ بَيْتِ أَبِيمَالِكَ بِالْعُقْمِ مِنْ أَجْلِ سَارَةَ زَوْجَةِ إِبْرَاهِيمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","وَافْتَقَدَ الرَّبُّ سَارَةَ كَمَا قَالَ، وَأَنْجَزَ لَهَا مَا وَعَدَ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","فَحَبِلَتْ سَارَةُ وَوَلَدَتْ لإِبْرَاهِيمَ فِي شَيْخُوخَتِهِ ابْناً، فِي الْوَقْتِ الَّذِي عَيَّنَهُ اللهُ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","فَدَعَا إِبْرَاهِيمُ ابْنَهُ الَّذِي أَنْجَبَتْهُ لَهُ سَارَةُ «إِسْحاقَ». ");
INSERT INTO arbnav_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","وَخَتَنَهُ فِي الْيَوْمِ الثَّامِنِ بِمُوجِبِ أَمْرِ اللهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","وَكَانَ إِبْرَاهِيمُ قَدْ بَلَغَ الْمِئَةَ مِنْ عُمْرِهِ عِنْدَمَا وُلِدَ لَهُ إِسْحاقُ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","وَقَالَتْ سَارَةُ «لَقَدْ أَضْحَكَنِي الرَّبُّ. كُلُّ مَنْ يَسْمَعُ هَذَا الأَمْرَ يَضْحَكُ مَعِي». ");
INSERT INTO arbnav_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","وَأَضَافَتْ أَيْضاً: «مَنْ كَانَ يُمْكِنُ أَنْ يَقُولَ لإِبْرَاهِيمَ إِنَّ سَارَةَ سَتُرْضِعُ بَنِينَ؟ فَهَا أَنَا قَدْ أَنْجَبْتُ لَهُ ابْناً فِي شَيْخُوخَتِهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","وَكَبُرَ إِسْحاقُ وَفُطِمَ. فَأَقَامَ إِبْرَاهِيمُ فِي يَوْمِ فِطَامِهِ مَأْدُبَةً عَظِيمَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","وَرَأَتْ سَارَةُ أَنَّ ابْنَ هَاجَرَ الْمِصْرِيَّةِ الَّذِي أَنْجَبَتْهُ لإِبْرَاهِيمَ يَسْخَرُ مِنِ ابْنِهَا إِسْحاقَ، ");
INSERT INTO arbnav_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","فَقَالَتْ لإِبْرَاهِيمَ: «اطْرُدْ هَذِهِ الْجَارِيَةَ وَابْنَهَا، فَإِنَّ ابْنَ الْجَارِيَةِ لَنْ يَرِثَ مَعَ ابْنِي إِسْحاقَ». ");
INSERT INTO arbnav_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","فَقَبُحَ هَذَا الْقَوْلُ فِي نَفْسِ إِبْرَاهِيمَ مِنْ أَجْلِ ابْنِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","فَقَال اللهُ لَهُ: «لا يَسُوءُ فِي نَفْسِكَ أَمْرُ الصَّبِيِّ أَوْ أَمْرُ جَارِيَتِكَ، وَاسْمَعْ لِكَلامِ سَارَةَ فِي كُلِّ مَا تُشِيرُ بِهِ عَلَيْكَ لأَنَّهُ بِإِسْحاقَ يُدْعَى لَكَ نَسْلٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","وَسَأُقِيمُ مِنِ ابْنِ الْجَارِيَةِ أُمَّةً أَيْضاً لأَنَّهُ مِنْ ذُرِّيَّتِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","فَنَهَضَ إِبْرَاهِيمُ فِي الصَّبَاحِ الْبَاكِرِ وَأَخَذَ خُبْزاً وَقِرْبَةَ مَاءٍ وَدَفَعَهُمَا إِلَى هَاجَرَ، وَوَضَعَهُمَا عَلَى كَتِفَيْهَا، ثُمَّ صَرَفَهَا مَعَ الصَّبِيِّ. فَهَامَتْ عَلَى وَجْهِهَا فِي بَرِّيَّةِ بِئْرِ سَبْعٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","وَعِنْدَمَا فَرَغَ الْمَاءُ مِنَ الْقِرْبَةِ طَرَحَتِ الصَّبِيَّ تَحْتَ إِحْدَى الأَشْجَارِ، ");
INSERT INTO arbnav_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","وَمَضَتْ وَجَلَسَتْ مُقَابِلَهُ، عَلَى بُعْدِ نَحْوِ مِئَةِ مِتْرٍ، لأَنَّهَا قَالَتْ: «لا أَشْهَدُ مَوْتَ الصَّبِيِّ». فَجَلَسَتْ مُقَابِلَهُ وَرَفَعَتْ صَوْتَهَا وَبَكَتْ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","وَسَمِعَ اللهُ بُكَاءَ الصَّبِيِّ، فَنَادَى مَلاكُ اللهِ هَاجَرَ مِنَ السَّمَاءِ وَقَالَ لَهَا: «مَا الَّذِي يُزْعِجُكِ يَا هَاجَرُ؟ لَا تَخَافِي، لأَنَّ اللهَ قَدْ سَمِعَ بُكَاءَ الصَّبِيِّ مِنْ حَيْثُ هُوَ مُلْقىً. ");
INSERT INTO arbnav_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","قُومِي وَاحْمِلِي الصَّبِيَّ، وَتَشَبَّثِي بِهِ لأَنَّنِي سَأَجْعَلُهُ أُمَّةً عَظِيمَةً». ");
INSERT INTO arbnav_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ثُمَّ فَتَحَ عَيْنَيْهَا فَأَبْصَرَتْ بِئْرَ مَاءٍ، فَذَهَبَتْ وَمَلأَتِ الْقِرْبَةَ وَسَقَتِ الصَّبِيَّ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","وَكَانَ اللهُ مَعَ الصَّبِيِّ فَكَبُرَ، وَسَكَنَ فِي صَحْرَاءِ فَارَانَ، وَبَرَعَ فِي رَمْيِ الْقَوْسِ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","وَاتَّخَذَتْ لَهُ أُمُّهُ زَوْجَةً مِنْ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","وَفِي ذَلِكَ الزَّمَانِ خَاطَبَ أَبِيمَالِكُ وَفِيكُولُ قَائِدُ جَيْشِهِ إِبْرَاهِيمَ قَائِلَيْنِ: «إِنَّ اللهَ مَعَكَ فِي كُلِّ مَا تَقُومُ بِهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","فَاحْلِفْ لِي الآنَ بِاللهِ أَنْ لَا تَغْدُرَ بِي وَلا بِنَسْلِي وَذُرِّيَّتِي، بَلْ تُحْسِنَ إِلَيَّ وَإِلَى شَعْبِي الَّذِي تَغَرَّبْتَ بَيْنَهُ، كَمَا أَحْسَنْتُ إِلَيْكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","فَقَالَ إِبْرَاهِيمُ: «أَحْلِفُ». ");
INSERT INTO arbnav_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","وَعَاتَبَ إِبْرَاهِيمُ أَبِيمَالِكَ مِنْ أَجْلِ الْبِئْرِ الَّتِي اغْتَصَبَهَا عَبِيدُ أَبِيمَالِكَ، ");
INSERT INTO arbnav_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","فَقَالَ أَبِيمَالِكُ: «لَسْتُ أَعْلَمُ مَنِ ارْتَكَبَ هَذَا الأَمْرَ، وَأَنْتَ لَمْ تُخْبِرْنِي بِهِ، وَلَمْ أَسْمَعْ عَنْهُ سِوَى الْيَوْمِ». ");
INSERT INTO arbnav_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ثُمَّ أَعْطَى إِبْرَاهِيمُ أَبِيمَالِكَ غَنَماً وَبَقَراً وَقَطَعَ كِلاهُمَا عَهْداً. ");
INSERT INTO arbnav_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","وَفَرَزَ إِبْرَاهِيمُ سَبْعَ نِعَاجٍ مِنَ الْغَنَمِ وَحْدَهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","فَقَالَ أَبِيمَالِكُ لإِبْرَاهِيمَ: «مَاذَا تَقْصِدُ بِهَذِهِ النِّعَاجِ السَّبْعِ الَّتِي فَرَزْتَهَا جَانِباً؟» ");
INSERT INTO arbnav_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","فَأَجَابَ: «هِيَ سَبْعُ نِعَاجٍ أُقَدِّمُهَا لَكَ بِيَدِي شَهَادَةً لِي أَنَّنِي حَفَرْتُ هَذِهِ الْبِئْرَ». ");
INSERT INTO arbnav_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","لِذَلِكَ دَعَا ذَلِكَ الْمَكَانَ بِئْرَ سَبْعٍ (وَمَعْنَاهْ بِئْرُ الْحَلْفِ) لأَنَّ إِبْرَاهِيمَ وَأَبِيمَالِكَ كِلاهُمَا حَلَفَا هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","وَهَكَذَا قَطَعَا عَهْداً فِي بِئْرِ سَبْعٍ، ثُمَّ نَهَضَ أَبِيمَالِكُ وَفِيكُولُ رَئِيسُ جَيْشِهِ وَرَجَعَا إِلَى أَرْضِ الْفِلِسْطِينِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","وَغَرَسَ إِبْرَاهِيمُ شَجَرَ أَثْلٍ فِي بِئْرِ سَبْعٍ، وَدَعَا هُنَاكَ بِاسْمِ الرَّبِّ الإِلَهِ السَّرْمَدِيِّ ");
INSERT INTO arbnav_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","وَمَكَثَ إِبْرَاهِيمُ فِي بِلادِ الْفِلِسْطِينِيِّينَ فَتْرَةً طَوِيلَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","وَبَعْدَ هَذَا امْتَحَنَ اللهُ إِبْرَاهِيمَ، فَنَادَاهُ: «يَا إِبْرَاهِيمُ» فَأَجَابَهُ: «لَبَّيْكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","فَقَالَ لَهُ: «خُذِ ابْنَكَ وَحِيدَكَ، إِسْحاقَ الَّذِي تُحِبُّهُ، وَانْطَلِقْ إِلَى أَرْضِ الْمُرِيَّا وَقَدِّمْهُ مُحْرَقَةً عَلَى أَحَدِ الْجِبَالِ الَّذِي أَهْدِيكَ إِلَيْهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","فَاسْتَيْقَظَ إِبْرَاهِيمُ مُبَكِّراً فِي الصَّبَاحِ التَّالِي، وَأَسْرَجَ حِمَارَهُ، وَأَخَذَ اثْنَيْنِ مِنْ غِلْمَانِهِ، وَابْنَهُ إِسْحاقَ. وَجَهَّزَ حَطَباً لِمُحْرَقَةٍ، وَانْطَلَقَ مَاضِياً إِلَى الْمَوْضِعِ الَّذِي قَالَ لَهُ اللهُ عَنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","وَفِي الْيَوْمِ الثَّالِثِ تَطَلَّعَ إِبْرَاهِيمُ فَشَاهَدَ الْمَكَانَ مِنْ بَعِيدٍ، ");
INSERT INTO arbnav_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","فَقَالَ إِبْرَاهِيمُ لِغُلامَيْهِ: «امْكُثَا هُنَا مَعَ الْحِمَارِ، رَيْثَمَا أَصْعَدُ أَنَا وَالصَّبِيُّ إِلَى هُنَاكَ لَنَتَعَبَّدَ لِلهِ ثُمَّ نَعُودَ إِلَيْكُمَا». ");
INSERT INTO arbnav_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","فَحَمَّلَ إِبْرَاهِيمُ إِسْحاقَ حَطَبَ الْمُحْرَقَةِ، وَأَخَذَ هُوَ بِيَدِهِ النَّارَ وَالسِّكِّينَ وَذَهَبَا كِلاهُمَا مَعاً. ");
INSERT INTO arbnav_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","وَقَالَ إِسْحاقُ لإِبْرَاهِيمَ أَبِيهِ: «يَا أَبِي». فَأَجَابَهُ: «نَعَمْ يَا بُنَيَّ». فَسَأَلَهُ: «هَا هِيَ النَّارُ وَالْحَطَبُ، وَلَكِنْ أَيْنَ خَرُوفُ الْمُحْرَقَةِ؟». ");
INSERT INTO arbnav_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","فَرَدَّ عَلَيْهِ إِبْرَاهِيمُ: «إِنَّ اللهَ يُدَبِّرُ لِنَفْسِهِ الْخَرُوفَ لِلْمُحْرَقَةِ يَا ابْنِي». وَتَابَعَا مَسِيرَهُمَا مَعاً. ");
INSERT INTO arbnav_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","وَلَمَّا بَلَغَا الْمَوْضِعَ الَّذِي أَشَارَ إِلَيْهِ اللهُ شَيَّدَ إِبْرَاهِيمُ مَذْبَحاً هُنَاكَ، وَرَتَّبَ الْحَطَبَ، ثُمَّ أَوْثَقَ إِسْحاقَ ابْنَهُ وَوَضَعَهُ عَلَى الْمَذْبَحِ فَوْقَ الْحَطَبِ. ");
INSERT INTO arbnav_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","وَمَدَّ إِبْرَاهِيمُ يَدَهُ وَتَنَاوَلَ السِّكِّينَ لِيَذْبَحَ ابْنَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","فَنَادَاهُ مَلاكُ الرَّبِّ مِنَ السَّمَاءِ قَائِلاً: «إِبْرَاهِيمُ، إِبْرَاهِيمُ» فَأَجَابَ: «نَعَمْ». ");
INSERT INTO arbnav_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","فَقَالَ: «لا تَمُدَّ يَدَكَ إِلَى الصَّبِيِّ وَلا تُوْقِعْ بِهِ ضَرَراً لأَنِّي عَلِمْتُ أَنَّكَ تَخَافُ اللهَ وَلَمْ تَمْنَعِ ابْنَكَ وَحِيدَكَ عَنِّي». ");
INSERT INTO arbnav_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","وَإِذْ تَطَلَّعَ إِبْرَاهِيمُ حَوْلَهُ رَأَى خَلْفَهُ كَبْشاً قَدْ عَلِقَ بِفُرُوعِ أَشْجَارِ الْغَابَةِ، فَذَهَبَ وَأَحْضَرَهُ وَأَصْعَدَهُ مُحْرَقَةً عِوَضاً عَنِ ابْنِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","وَدَعَا إِبْرَاهِيمُ اسْمَ ذَلِكَ الْمَكَانِ «يَهْوَهْ يِرْأَه» (وَمَعْنَاهُ: الرَّبُّ يُدَبِّرُ). وَلِذَلِكَ يُقَالُ حَتَّى الْيَوْمِ «فِي جَبَلِ الرَّبِّ، الإِلَهِ يُرَى». ");
INSERT INTO arbnav_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","وَنَادَى مَلاكُ الرَّبِّ إِبْرَاهِيمَ مِنَ السَّمَاءِ مَرَّةً ثَانِيَةً: ");
INSERT INTO arbnav_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","وَقَالَ: «هَا أَنَا أُقْسِمُ بِذَاتِي يَقُولُ الرَّبُّ: لأَنَّكَ صَنَعْتَ هَذَا الأَمْرَ، وَلَمْ تَمْنَعِ ابْنَكَ وَحِيدَكَ عَنِّي، ");
INSERT INTO arbnav_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","لأُبَارِكَنَّكَ وَأُكَثِّرَنَّ ذُرِّيَّتَكَ فَتَكُونُ كَنُجُومِ السَّمَاءِ وَكَرَمْلِ شَاطِئِ الْبَحْرِ، وَتَرِثُ ذُرِّيَّتُكَ مُدُنَ أَعْدَائِهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","وَبِذُرِّيَّتِكَ تَتَبَارَكُ جَمِيعُ أُمَمِ الأَرْضِ، لأَنَّكَ أَطَعْتَنِي». ");
INSERT INTO arbnav_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ثُمَّ رَجَعَ إِبْرَاهِيمُ إِلَى غُلَامَيْهِ، وَعَادُوا جَمِيعاً إِلَى بِئْرِ سَبْعٍ حَيْثُ أَقَامَ إِبْرَاهِيمُ. ");
INSERT INTO arbnav_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","وَقِيلَ لإِبْرَاهِيمَ بَعْدَ هَذِهِ الأُمُورِ: «هُوَذَا مِلْكَةُ أَيْضاً قَدْ وَلَدَتْ بَنِينَ لأَخِيكَ نَاحُورَ. ");
INSERT INTO arbnav_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","عُوصاً الْبِكْرَ، وَأَخَاهُ بُوزاً وَقُمُوئِيلَ أَبَا أَرَامَ، ");
INSERT INTO arbnav_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","وَكَاسَدَ وَحَزْواً وَفِلْدَاشَ وَيِدْلافَ وَبَتُوئِيلَ». ");
INSERT INTO arbnav_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","وَأَنْجَبَ بَتُوئِيلُ رِفْقَةَ. هَؤُلاءِ الثَّمَانِيَةُ أَنْجَبَتْهُمْ مِلْكَةُ لِنَاحُورَ أَخِي إِبْرَاهِيمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","كَذَلِكَ أَنْجَبَتْ لَهُ سُرِّيَّتُهُ الْمَدْعُوَّةُ رُؤُومَةَ طَابَحَ وَجَاحَمَ وَتَاحَشَ وَمَعْكَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","وَعَاشَتْ سَارَةُ مِئَةً وَسَبْعاً وَعِشْرِينَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ثُمَّ مَاتَتْ سَارَةُ فِي قَرْيَةِ أَرْبَعَ، أَيْ حَبْرُونَ، فِي أَرْضِ كَنْعَانَ، فَجَاءَ إِبْرَاهِيمُ لِيَنْدُبَ سَارَةَ وَيَبْكِيَ عَلَيْهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","وَنَهَضَ إِبْرَاهِيمُ مِنْ أَمَامِ الْجُثْمَانِ وَقَالَ لِلْحِثِّيِّينَ: ");
INSERT INTO arbnav_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«أَنَا غَرِيبٌ وَنَزِيلٌ بَيْنَكُمْ، فَمَلِّكُونِي مَعَكُمْ مَدْفَناً أُوَارِي فِيهِ مَيْتِي مِنْ أَمَامِي». ");
INSERT INTO arbnav_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","فَأَجَابُوهُ قَائِلِينَ: ");
INSERT INTO arbnav_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«أَصْغِ لَنَا يَا سَيِّدِي. أَنْتَ رَئِيسٌ مِنَ اللهِ فِي وَسَطِنَا، فَادْفِنْ مَيْتَكَ فِي أَفْضَلِ قُبُورِنَا، فَلا أَحَدَ مِنَّا يَمْنَعُ قَبْرَهُ عَنْكَ لِتَدْفِنَ مَيْتَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","فَنَهَضَ إِبْرَاهِيمُ وَانْحَنَى أَمَامَ الْحِثِّيِّينَ أَهْلِ الْبِلادِ، ");
INSERT INTO arbnav_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","وَقَالَ: «إِنْ طَابَتْ نُفُوسُكُمْ أَنْ أَدْفِنَ مَيْتِي مِنْ أَمَامِي، فَاسْمَعُوا لِي وَالْتَمِسُوا لأَجْلِي مِنْ عِفْرُونَ بْنِ صُوحَرَ، ");
INSERT INTO arbnav_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","أَنْ يَبِيعَنِي مَغَارَةَ الْمَكْفِيلَةِ الَّتِي فِي طَرَفِ حَقْلِهِ، فَأَشْتَرِيَهَا مِنْهُ لِقَاءَ ثَمَنٍ كَامِلٍ، وَأَمْتَلِكَهَا لِتَكُونَ مَدْفَناً لِي فِي وَسَطِكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","وَكَانَ عِفْرُونُ جَالِساً بَيْنَ الْحِثِّيِّينَ، فَقَالَ فِي مَسَامِعِ الْحِثِّيِّينَ، أَمَامَ كُلِّ الْحَاضِرِينَ فِي مَجْلِسِ مَدِينَتِهِ: ");
INSERT INTO arbnav_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«لا يَا سَيِّدِي، بَلْ أَصْغِ إِلَيَّ، هُوَذَا الْحَقْلُ الَّذِي لِي وَالْمَغَارَةُ الَّتِي فِيهِ أَهَبُهُمَا لَكَ عَلَى مَشْهَدٍ مِنْ بَنِي شَعْبِي فَخُذْهُمَا وَادْفِنْ مَيْتَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","فَانْحَنَى إِبْرَاهِيمُ أَمَامَ أَهْلِ الْبِلادِ مَرَّةً ثَانِيَةً، ");
INSERT INTO arbnav_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","وَقَالَ لِعِفْرُونَ فِي مَسَامِعِ شَعْبِ الأَرْضِ: «إِنْ كُنْتَ تَشَاءُ فَاسْمَعْ لِي. أَنَا أَدْفَعُ ثَمَنَ الْحَقْلِ. فَاقْبَلْ ذَلِكَ مِنِّي فَأَقُومَ بِدَفْنِ مَيْتِي هُنَاكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","فَأَجَابَ عِفْرُونُ إِبْرَاهِيمَ: ");
INSERT INTO arbnav_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«أَصْغِ لِي يَا سَيِّدِي، إِنَّ الأَرْضَ تُسَاوِي أَرْبَعَ مِئَةِ شَاقِلٍ (حَوَالَي خَمْسَةِ كِيلُو جِرَامَاتٍ) مِنَ الْفِضَّةِ، وَهُوَ (ثَمَنٌ) لَا قِيمَةَ لَهُ بَيْنِي وَبَيْنَكَ، فَادْفِنْ مَيْتَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","فَقَبِلَ إِبْرَاهِيمُ عَرْضَ عِفْرُونَ، وَوَزَنَ لَهُ الْفِضَّةَ الَّتِي ذَكَرَهَا فِي مَسَامِعِ الْحِثِّيِّينَ. أَرْبَعَ مِئَةِ شَاقِلٍ رَائِجَةً بَيْنَ التُّجَّارِ. ");
INSERT INTO arbnav_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","وَبِمُقْتَضَى ذَلِكَ أَصْبَحَ حَقْلُ عِفْرُونَ الَّذِي فِي الْمَكْفِيلَةِ مُقَابِلَ مَمْرَا، وَالْمَغَارَةُ الَّتِي فِيهِ، وَجَمِيعُ الأَشْجَارِ الْقَائِمَةِ فِي كُلِّ الْحُدُودِ الْمُحِيطَةِ بِهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","مُلْكاً لإِبْرَاهِيمَ، بِمَشْهَدٍ مِنَ الْحِثِّيِّينَ وَسَائِرِ الْحَاضِرِينَ فِي مَجْلِسِ مَدِينَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","وَبَعْدَ ذَلِكَ دَفَنَ إِبْرَاهِيمُ زَوْجَتَهُ سَارَةَ فِي مَغَارَةِ الْمَكْفِيلَةِ، مُقَابِلَ مَمْرَا. وَهِيَ حَبْرُونُ فِي أَرْضِ كَنْعَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","فَامْتَلَكَ إِبْرَاهِيمُ مِنَ الْحِثِّيِّينَ الْحَقْلَ وَالْمَغَارَةَ الَّتِي فِيهِ لِيَكُونَا مَدْفَناً لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","وَشَاخَ إِبْرَاهِيمُ وَتَقَدَّمَ بِهِ الْعُمْرُ. وَبَارَكَ الرَّبُّ إِبْرَاهِيمَ فِي كُلِّ شَيْءٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","وَقَالَ إِبْرَاهِيمُ لِرَئِيسِ عَبِيدِهِ، الْمُتَوَلِّي جَمِيعَ شُؤُونِ بَيْتِهِ: «ضَعْ يَدَكَ تَحْتَ فَخْذِي، ");
INSERT INTO arbnav_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","فَأَسْتَحْلِفَكَ بِالرَّبِّ إِلَهِ السَّمَاءِ وَالأَرْضِ أَنْ لَا تَأْخُذَ لابْنِي زَوْجَةً مِنْ بَنَاتِ الْكَنْعَانِيِّينَ الَّذِيْنَ أَنَا مُقِيمٌ فِي وَسَطِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","بَلْ تَمْضِي إِلَى بَلَدِي وَإِلَى عَشِيرَتِي، وَتَأْخُذُ زَوْجَةً لابْنِي إِسْحاقَ». ");
INSERT INTO arbnav_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","فَقَالَ لَهُ الْعَبْدُ: «هَبْ أَنَّ الْمَرْأَةَ لَا تَشَاءُ أَنْ تَتْبَعَنِي إِلَى هَذِهِ الأَرْضِ، فَهَلْ أَرْجِعُ بِابْنِكَ إِلَى الأَرْضِ الَّتِي ارْتَحَلْتَ عَنْهَا؟». ");
INSERT INTO arbnav_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","فَأَجَابَ إِبْرَاهِيمُ: «إِيَّاكَ أَنْ تَرْجِعَ بِابْنِي إِلَى هُنَاكَ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","فَالرَّبُّ إِلَهُ السَّمَاءِ الَّذِي أَخَذَنِي مِنْ بَيْتِ أَبِي وَمِنْ أَرْضِ قَوْمِي، وَخَاطَبَنِي وَأَقْسَمَ لِي قَائِلاً: لِذُرِّيَّتِكَ أَهَبُ هَذِهِ الأَرْضَ، هُوَ يُرْسِلُ مَلاكَهُ أَمَامَكَ لِتَأْخُذَ زَوْجَةً لابْنِي مِنْ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","إِنْ أَبَتِ الْمَرْأَةُ أَنْ تَتْبَعَكَ، تَكُونُ آنَئِذٍ فِي حِلٍّ مِنْ حَلْفِي هَذَا، أَمَّا ابْنِي فَإِيَّاكَ أَنْ تَرْجِعَ بِهِ إِلَى هُنَاكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","فَوَضَعَ الْعَبْدُ يَدَهُ تَحْتَ فَخْذِ سَيِّدِهِ إِبْرَاهِيمَ وَحَلَفَ لَهُ عَلَى ذَلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","وَاخْتَارَ الْعَبْدُ عَشَرَةَ جِمَالٍ وَحَمَّلَهَا مِنْ جَمِيعِ خَيْرَاتِ مَوْلاهُ الَّتِي فِي يَدِهِ، وَقَامَ وَانْطَلَقَ إِلَى أَرَامِ النَّهْرَيْنِ إِلَى مَدِينَةِ نَاحُورَ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","وَهُنَاكَ أَنَاخَ الْجِمَالَ خَارِجَ الْمَدِينَةِ عِنْدَ بِئْرِ الْمَاءِ وَقْتَ الْمَسَاءِ، فِي مَوْعِدِ خُرُوجِ الْمُسْتَقِيَاتِ مِنَ النِّسَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","وَقَالَ: «أَيُّهَا الرَّبُّ إِلَهَ سَيِّدِي إِبْرَاهِيمَ، أَتَوَسَّلُ إِلَيْكَ أَنْ تُيَسِّرَ أَمْرِي الْيَوْمَ وَتُسْدِيَ مَعْرُوفاً لِسَيِّدِي إِبْرَاهِيمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","هَا أَنَا وَاقِفٌ عِنْدَ بِئْرِ الْمَاءِ حَيْثُ تُقْبِلُ بَنَاتُ أَهْلِ الْمَدِينَةِ ");
INSERT INTO arbnav_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","فَلْيَكُنْ أَنَّ الْفَتَاةَ الَّتِي أَقُولُ لَهَا: ضَعِي جَرَّتَكِ لأَشْرَبَ مِنْهَا، فَتُجِيبُ: اشْرَبْ وَأَنَا أَسْقِي جِمَالَكَ أَيْضاً، تَكُونُ هِيَ الَّتِي اخْتَرْتَهَا لِعَبْدِكَ إِسْحاقَ. وَبِذَلِكَ أُدْرِكُ أَنَّكَ أَسْدَيْتَ مَعْرُوفاً لِسَيِّدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","وَقَبْلَ أَنْ يُتِمَّ صَلاتَهُ إِذَا بِهِ يُشَاهِدُ رِفْقَةَ ابْنَةَ بَتُوئِيلَ ابْنِ مِلْكَةَ زَوْجَةِ نَاحُورَ أَخِي إِبْرَاهِيمَ مُقْبِلَةً، وَجَرَّتُهَا عَلَى كَتِفِهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","وَكَانَتِ الْفَتَاةُ رَائِعَةَ الْجَمَالِ، عَذْرَاءَ لَمْ يَمَسَّهَا رَجُلٌ. فَنَزَلَتْ إِلَى الْعَيْنِ وَمَلأَتْ جَرَّتَهَا ثُمَّ صَعِدَتْ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","فَرَكَضَ الْعَبْدُ لِلِقَائِهَا وَقَالَ: «أَرْجُوكِ، اسْقِينِي قَلِيلاً مِنْ مَاءِ جَرَّتِكِ». ");
INSERT INTO arbnav_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","فَأَجَابَتِ الْفَتَاةُ: «اشْرَبْ يَا سَيِّدِي». وَأَسْرَعَتْ وَأَنْزَلَتْ جَرَّتَهَا عَلَى يَدِهَا وَسَقَتْهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","وَبَعْدَ أَنْ شَرِبَ قَالَتْ: «أَسْتَقِي لِجِمَالِكَ أَيْضاً حَتَّى تَرْتَوِيَ». ");
INSERT INTO arbnav_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","وَمَضَتْ مُسْرِعَةً وَأَفْرَغَتْ جَرَّتَهَا فِي حَوْضِ الْمَاءِ، ثُمَّ رَكَضَتْ نَحْوَ الْبِئْرِ فَاسْتَقَتْ لِكُلِّ جِمَالِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","وَظَلَّ الرَّجُلُ يَتَأَمَّلُهَا صَامِتاً لِيَعْلَمَ إِنْ كَانَ الرَّبُّ قَدْ وَفَّقَ مَسْعَاهُ أَمْ لا. ");
INSERT INTO arbnav_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","وَعِنْدَمَا ارْتَوَتِ الْجِمَالُ تَنَاوَلَ الرَّجُلُ خِزَامَةً ذَهَبِيَّةً وَزْنُهَا نِصْفُ شَاقِلٍ (نَحْوَ سِتَّةِ جِرَامَاتٍ) وَسُوَارَيْنِ ذَهَبِيَّيْنِ وَزْنُهُمَا عَشَرَةُ شَواقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً)، ");
INSERT INTO arbnav_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","وَسَأَلَهَا: «ابْنَةُ مَنْ أَنْتِ؟ أَخْبِرِينِي: هَلْ فِي بَيْتِ أَبِيكِ مَوْضِعٌ نَبِيتُ فِيهِ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","فَأَجَابَتْهُ: «أَنَا ابْنَةُ بَتُوئِيلَ ابْنِ مِلْكَةَ الَّذِي أَنْجَبَتْهُ لِنَاحُورَ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","عِنْدَنَا كَثِيرٌ مِنَ التِّبْنِ وَالْعَلَفِ، وَمَكَانٌ لِتَبِيتُوا فِيهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","فَأَطْرَقَ الرَّجُلُ بِرَأْسِهِ وَسَجَدَ لِلرَّبِّ مُصَلِّياً: ");
INSERT INTO arbnav_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","«تَبَارَكَ الرَّبُّ إِلَهُ سَيِّدِي إِبْرَاهِيمَ الَّذِي لَمْ يَتَخَلَّ عَنْ لُطْفِهِ وَوَفَائِهِ لِسَيِّدِي. أَمَّا أَنَا فَقَدْ هَدَانِي الرَّبُّ فِي الطَّرِيقِ إِلَى بَيْتِ إِخْوَةِ سَيِّدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","فَهُرِعَتِ الْفَتَاةُ وَأَخْبَرَتْ بَيْتَ أُمِّهَا بِهَذِهِ الأُمُورِ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","وَكَانَ لِرِفْقَةَ أَخٌ يُدْعَى لابَانَ، فَأَسْرَعَ نَحْوَ الرَّجُلِ عِنْدَ بِئْرِ الْمَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","إِذْ كَانَ قَدْ رَأَى الْخِزَامَةَ وَالسِّوَارَيْنِ عَلَى يَدَيْ أُخْتِهِ، وَسَمِعَ حَدِيثَهَا عَنِ الرَّجُلِ؛ فَوَجَدَهُ وَاقِفاً بِالْقُرْبِ مِنَ الْجِمَالِ عِنْدَ الْمَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","فَقَالَ: «ادْخُلْ أَيُّهَا الْمُبَارَكُ مِنَ الرَّبِّ، لِمَاذَا تَقِفُ خَارِجاً؟ لَقَدْ أَعْدَدْتُ الْبَيْتَ وَكَذَلِكَ مَكَاناً لِلْجِمَالِ». ");
INSERT INTO arbnav_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","فَدَخَلَ الرَّجُلُ إِلَى الْمَنْزِلِ، وَحَلَّ عَنِ الْجِمَالِ، وَقَدَّمَ لَهَا تِبْناً وَعَلَفاً، وَأَتَى لابَانُ بِمَاءٍ لِغَسْلِ رِجْلَيْهِ وَأَرْجُلِ مُرَافِقِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ثُمَّ وَضَعَ الطَّعَامَ بَيْنَ يَدَيْهِ لِيَأْكُلَ. لَكِنَّهُ قَالَ: «لَنْ آكُلَ حَتَّى أُخْبِرَكُمْ بِمَا يَجِبُ أَنْ أَقُولَهُ». فَقَالَ لَهُ: «تَكَلَّمْ». ");
INSERT INTO arbnav_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","فَقَالَ: «أَنَا عَبْدُ إِبْرَاهِيمَ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","وَقَدْ أَغْدَقَ الرَّبُّ عَلَى مَوْلايَ بَرَكَاتٍ جَمَّةً فَصَارَ عَظِيماً، إِذْ أَنْعَمَ عَلَيْهِ بِغَنَمٍ وَبَقَرٍ وَفِضَّةٍ وَذَهَبٍ وَعَبِيدٍ وَإِمَاءٍ وَجِمَالٍ وَحَمِيرٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","وَأَنْجَبَتْ سَارَةُ امْرَأَةُ سَيِّدِي بَعْدَ أَنْ شَاخَتِ ابْناً لِسَيِّدِي أَوْرَثَهُ كُلَّ مَالَهُ ");
INSERT INTO arbnav_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","وَقَدِ اسْتَحْلَفَنِي سَيِّدِي أَلّا آخُذَ زَوْجَةً لابْنِهِ مِنْ بَنَاتِ الْكَنْعَانِيِّينَ الَّذِينَ يَسْكُنُ أَرْضَهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","بَلْ أَذْهَبُ إِلَى بَيْتِ أَبِيهِ وَعَشِيرَتِهِ وَآخُذُ لابْنِهِ مِنْهُمْ زَوْجَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","فَقُلْتُ لِسَيِّدِي: قَدْ تَأْبَى الْفَتَاةُ أَنْ تَتْبَعَنِي إِلَى هَذِهِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","فَأَجَابَنِي: إِنَّ الرَّبَّ الَّذِي سَلَكْتُ أَمَامَهُ، هُوَ يُرْسِلُ مَلاكَهُ مَعَكَ وَيُوَفِّقُ مَسْعَاكَ فَتَأْخُذُ لابْنِي زَوْجَةً مِنْ عَشِيرَتِي وَمِنْ بَيْتِ أَبِي. ");
INSERT INTO arbnav_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","وَإذَا قَدِمْتَ عَلَى قَوْمِي وَرَفَضُوا أَنْ يُعْطُوكَ إِيَّاهَا تَكُونُ آنَئِذٍ فِي حِلٍّ مِنْ حَلْفِي. ");
INSERT INTO arbnav_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","فَأَقْبَلْتُ الْيَوْمَ عَلَى الْعَيْنِ وَقُلْتُ: أَيُّهَا الرَّبُّ، إِلَهَ سَيِّدِي إِبْرَاهِيمَ. أَرْجُوكَ أَنْ تُوَفِّقَ مَسْعَايَ الَّذِي مِنْ أَجْلِهِ قُمْتُ بِهَذِهِ الرِّحْلَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","هَا أَنَا وَاقِفٌ عِنْدَ بِئْرِ الْمَاءِ، فَلْيَكُنْ أَنَّ الْفَتَاةَ الَّتِي تَأْتِي لِتَسْتَقِيَ، وَالَّتِي أَطْلُبُ مِنْهَا أَنْ تَسْقِيَنِي بَعْضَ الْمَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","فَتَقُولُ لِي: اشْرَبْ أَنْتَ، وَأَنَا أَسْتَقِي لِجِمَالِكَ أَيْضاً، تَكُونُ هِيَ الْفَتَاةَ الَّتِي عَيَّنَهَا الرَّبُّ لابْنِ سَيِّدِي. ");
INSERT INTO arbnav_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","وَبَيْنَمَا كُنْتُ أُنَاجِي نَفْسِي بِهَذَا الْكَلامِ، إِذَا رِفْقَةُ قَادِمَةٌ، حَامِلَةً جَرَّةً عَلَى كَتِفِهَا، فَنَزَلَتْ إِلَى الْعَيْنِ وَاسْتَقَتْ، فَقُلْتُ لَهَا: أَرْجُوكِ أَنْ تَسْقِينِي ");
INSERT INTO arbnav_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","فَأَسْرَعَتْ وَوَضَعَتْ جَرَّتَهَا عَنْهَا قَائِلَةً: اشْرَبْ وَأَنَا أَسْقِي جِمَالَكَ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ثُمَّ سَأَلْتُهَا: ابْنَةُ مَنْ أَنْتِ؟ فَأَجَابَتْ: ابْنَةُ بَتُوئِيلَ بْنِ نَاحُورَ الَّذِي أَنْجَبَتْهُ مِلْكَةُ لَهُ. فَوَضَعْتُ الْخِزَامَةَ فِي أَنْفِهَا وَالسِّوَارَيْنِ عَلَى يَدَيْهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ثُمَّ خَرَرْتُ وَسَجَدْتُ وَبَارَكْتُ الرَّبَّ إِلَهَ مَوْلايَ إِبْرَاهِيمَ الَّذِي هَدَانِي فِي الطَّرِيقِ الْقَوِيمِ لِآخُذَ ابْنَةَ أَخِي سَيِّدِي لابْنِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","وَالآنَ إِنْ كُنْتُمْ تُبْدُونَ لُطْفاً وَأَمَانَةً لِسَيِّدِي فَأَجِيبُوا طَلَبِي، وَإلَّا فَأَخْبِرُونِي لأَتَّجِهَ يَمِيناً أَوْ شِمَالاً». ");
INSERT INTO arbnav_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","فَأَجَابَ لابَانُ وَبَتُوئِيلُ: «قَدْ صَدَرَ هَذَا الأَمْرُ مِنَ الرَّبِّ، وَلا نَقْدِرُ أَنْ نَقُولَ لَكَ خَيْراً أَوْ شَرّاً. ");
INSERT INTO arbnav_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","هَا هِيَ رِفْقَةُ أَمَامَكَ، خُذْهَا وَامْضِ. لِتَكُنْ لابْنِ سَيِّدِكَ كَمَا قَالَ الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","فَمَا إِنْ سَمِعَ عَبْدُ إِبْرَاهِيمَ كَلامَهُمْ حَتَّى خَرَّ عَلَى الأَرْضِ سَاجِداً لِلرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ثُمَّ أَخْرَجَ جَوَاهِرَ مِنْ فِضَّةٍ وَمِنْ ذَهَبٍ وَثِيَاباً وَأَعْطَاهَا لِرِفْقَةَ، وَأَهْدَى أَيْضاً أَخَاهَا وَأُمَّهَا تُحَفاً ");
INSERT INTO arbnav_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","وَأَكَلَ وَشَرِبَ هُوَ وَرِجَالُهُ، وَقَضَوْا لَيْلَتَهُمْ هُنَاكَ. وَعِنْدَمَا اسْتَيْقَظُوا فِي الصَّبَاحِ قَالَ: «أَطْلِقُونِي لأَعُودَ إِلَى سَيِّدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","فَأَجَابَ أَخُوهَا وَأُمُّهَا: «دَعِ الْفَتَاةَ تَمْكُثُ مَعْنَا عَشَرَةَ أَيَّامٍ أَوْ نَحْوَهَا، ثُمَّ بَعْدَ ذَلِكَ تَنْطَلِقُ». ");
INSERT INTO arbnav_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","فَقَالَ لَهُمْ: «لا تُعِيقُونِي فَالرَّبُّ وَفَّقَ مَسْعَايَ، أَطْلِقُونِي لأَمْضِيَ إِلَى سَيِّدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","فَقَالا: «نَدْعُو الْفَتَاةَ وَنَسْأَلُهَا رَأْيَهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","فَدَعَيَا رِفْقَةَ وَسَأَلاهَا: «أَتَذْهَبِينَ مَعَ هَذَا الرَّجُلِ؟» فَأَجَابَتْ: «أَذْهَبُ». ");
INSERT INTO arbnav_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","فَصَرَفُوا رِفْقَةَ أُخْتَهُمْ وَمَعَهَا مُرَبِّيَتَهَا وَعَبْدَ إِبْرَاهِيمَ وَرِجَالَهُ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","وَبَارَكُوا رِفْقَةَ قَائِلِينَ لَهَا: «أَنْتِ أُخْتُنَا، فَلْتَتَكَاثَرِي لِتَصِيرِي أُلُوفَ أُلُوفٍ وَلْتَرِثْ ذُرِّيَّتُكِ مُدُنَ مُبْغِضِيهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","فَنَهَضَتْ رِفْقَةُ وَفَتَيَاتُهَا وَرَكِبْنَ الْجِمَالَ وَتَبِعْنَ الرَّجُلَ. فَانْطَلَقَ الْعَبْدُ بِرِفْقَةَ وَمَضَى فِي طَرِيقِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","وَكَانَ إِسْحاقُ الْمُقِيمُ آنَئِذٍ فِي النَّقَبِ قَدْ عَادَ مِنْ طَرِيقِ بِئْرِ «لَحَيْ رُئِي». ");
INSERT INTO arbnav_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","فَخَرَجَ عِنْدَ الْمَسَاءِ إِلَى الْحَقْلِ مُتَأَمِّلًا، وَإِذْ تَطَلَّعَ حَوْلَهُ شَاهَدَ جِمَالاً مُقْبِلَةً، ");
INSERT INTO arbnav_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","وَرَفَعَتْ رِفْقَةُ كَذَلِكَ عَيْنَيْهَا وَرَأَتْ إِسْحاقَ فَتَرَجَّلَتْ عَنِ الْجَمَلِ، ");
INSERT INTO arbnav_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","وَسَأَلَتِ الْعَبْدَ: «مَنْ هَذَا الرَّجُلُ الْمَاشِي فِي الْحَقْلِ لِلِقَائِنَا؟» فَقَالَ الْعَبْدُ: «هُوَ سَيِّدِي». فَتَنَاوَلَتِ الْحِجَابَ وَتَغَطَّتْ. ");
INSERT INTO arbnav_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ثُمَّ حَدَّثَ الْعَبْدُ إِسْحاقَ بِكُلِّ الأُمُورِ الَّتِي قَامَ بِها. ");
INSERT INTO arbnav_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","فَأَدْخَلَ إِسْحاقُ رِفْقَةَ إِلَى خَيْمَةِ أُمِّهِ سَارَةَ، وَتَزَوَّجَهَا وَأَحَبَّهَا وَتَعَزَّى بِها بَعْدَ مَوْتِ أُمِّهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","وَعَادَ إِبْرَاهِيمُ فَاتَّخَذَ لِنَفْسِهِ زَوْجَةً تُدْعَى قَطُورَةَ، ");
INSERT INTO arbnav_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","فَأَنْجَبَتْ لَهُ زِمْرَانَ وَيَقْشَانَ وَمَدَانَ وَمِدْيَانَ وَيِشْبَاقَ وَشُوحاً. ");
INSERT INTO arbnav_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","وَأَنْجَبَ يَقْشَانُ شَبَا وَدَدَانَ. أَمَّا أَبْنَاءُ دَدَانَ فَهُمْ: أَشُّورِيمُ وَلَطُوشِيمُ وَلأُمِّيمُ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","وَأَبْنَاءُ مِدْيَانَ هُمْ: عَيْفَةُ وَعِفْرُ وَحَنُوكُ وَأَبِيدَاعُ، وَأَلْدَعَةُ. وَهَؤُلاءِ جَمِيعاً مِنْ ذُرِّيَّةِ قَطُورَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","وَوَرَّثَ إِبْرَاهِيمُ إِسْحاقَ كُلَّ مَالَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","أَمَّا أَبْنَاؤُهُ مِنْ سَرَارِيهِ فَأَعْطَاهُمْ إِبْرَاهِيمُ عَطَايَا، وَصَرَفَهُمْ فِي أَثْنَاءِ حَيَاتِهِ نَحْوَ أَرْضِ الْمَشْرِقِ بَعِيداً عَنْ إِسْحاقَ ابْنِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","وَعَاشَ إِبْرَاهِيمُ مِئَةً وَخَمْساً وَسَبْعِينَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ثُمَّ مَاتَ بِشَيْبَةٍ صَالِحَةٍ وَانْضَمَّ إِلَى أَسْلافِهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","فَدَفَنَهُ ابْنَاهُ إِسْحاقُ وَإِسْمَاعِيلُ فِي مَغَارَةِ الْمَكْفِيلَةِ، فِي حَقْلِ عِفْرُونَ بْنِ صُوحَرَ الْحِثِّيِّ مُقَابِلَ مَمْرَا، ");
INSERT INTO arbnav_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","وَهُوَ الْحَقْلُ الَّذِي اشْتَرَاهُ إِبْرَاهِيمُ مِنَ الْحِثِّيِّينَ، وَفِيهِ دُفِنَ إِبْرَاهِيمُ وَزَوْجَتُهُ سَارَةُ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","وَبَعْدَ وَفَاةِ إِبْرَاهِيمَ بَارَكَ اللهُ إِسْحاقَ ابْنَهُ، وَأَقَامَ إِسْحاقُ عِنْدَ بِئْرِ لَحَيْ رُئِي. ");
INSERT INTO arbnav_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","وَهَذَا سِجِلُّ مَوَالِيدِ إِسْمَاعِيلَ بْنِ إِبْرَاهِيمَ الَّذِي أَنْجَبَتْهُ هَاجَرُ الْمِصْرِيَّةُ جَارِيَةُ سَارَةَ لإِبْرَاهِيمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","وَهَذِهِ أَسْمَاءُ أَبْنَاءِ إِسْمَاعِيلَ مَدَوَّنَةً حَسَبَ تَرْتِيبِ وِلادَتِهِمْ: نَبَايُوتُ بِكْرُ إِسْمَاعِيلَ، وَقِيدَارُ وَأَدَبْئِيلُ وَمِبْسَامُ، ");
INSERT INTO arbnav_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","وَمِشْمَاعُ وَدُومَةُ وَمَسَّا، ");
INSERT INTO arbnav_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","وَحَدَارُ وَتَيْمَا وَيَطُورُ وَنَافِيشُ وَقِدْمَةُ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","هَؤُلاءِ هُمْ بَنُو إِسْمَاعِيلَ، وَهَذِهِ هِيَ أَسْمَاؤُهُمْ حَسَبَ دِيَارِهِمْ وَحُصُونِهِمْ، وَقَدْ صَارُوا اثْنَي عَشَرَ رَئِيساً لاثْنَتَيْ عَشْرَةَ قَبِيلَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","وَمَاتَ إِسْمَاعِيلُ وَلَهُ مِنَ الْعُمْرِ مِئَةٌ وَسَبْعٌ وَثَلاثُونَ سَنَةً، وَلَحِقَ بِقَوْمِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","أَمَّا ذُرِّيَّتُهُ فَقَدِ انْتَشَرَتْ مِنْ حَوِيلَةَ إِلَى شُورَ الْمُتَاخِمَةِ لِمِصْرَ فِي اتِّجَاهِ أَشُّورَ، وَكَانَتْ عَلَى عَدَاءٍ مَعَ بَقِيَّةِ إِخْوَتِهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","وَهَذَا سِجِلُّ مَوَالِيدِ إِسْحاقَ بْنِ إِبْرَاهِيمَ. أَنْجَبَ إِبْرَاهِيمُ إِسْحاقَ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","وَكَانَ إِسْحاقُ فِي الأَرْبَعِينَ مِنْ عُمْرِهِ عِنْدَمَا تَزَوَّجَ رِفْقَةَ بِنْتَ بَتُوئِيلَ الأَرَامِيِّ مِنْ سَهْلِ أَرَامَ، وَأُخْتَ لابَانَ الأَرَامِيِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","وَصَلَّى إِسْحاقُ إِلَى الرَّبِّ مِنْ أَجْلِ امْرَأَتِهِ لأَنَّهَا كَانَتْ عَاقِراً، فَاسْتَجَابَ لَهُ الرَّبُّ، فَحَمَلَتْ رِفْقَةُ زَوْجَتُهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","وَإِذْ تَصَارَعَ الطِّفْلانِ فِي بَطْنِهَا قَالَتْ: «إِنْ كَانَ الأَمْرُ هَكَذَا فَمَالِي وَالْحَبَلُ؟» وَمَضَتْ لِتَسْتَفْهِمَ مِنَ الرَّبِّ ");
INSERT INTO arbnav_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","فَقَالَ لَهَا الرَّبُّ: «فِي أَحْشَائِكِ أُمَّتَانِ، يَتَفَرَّعُ مِنْهُمَا شَعْبَانِ. شَعْبٌ يَسْتَقْوِي عَلَى شَعْبٍ، وَكَبِيرٌ يُسْتَعْبَدُ لِصَغِيرٍ». ");
INSERT INTO arbnav_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","وَعِنْدَمَا اكْتَمَلَتْ أَيَّامُهَا لِتَلِدَ إِذَا فِي أَحْشَائِهَا تَوْأَمَانِ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","فَخَرَجَ الأَوَّلُ مَكْسُوّاً بِالشَّعْرِ وَكَأَنَّهُ يَرْتَدِي فَرْوَةً حَمْرَاءَ، فَدَعَوْهُ عِيسُو (وَمَعْنَاهُ أَشْعَرُ). ");
INSERT INTO arbnav_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ثُمَّ خَرَجَ أَخُوهُ وَيَدُهُ قَابِضَةٌ عَلَى عَقِبِ عِيسُو فَدَعَوْهُ يَعْقُوبَ (وَمَعَنَاهُ مُتَعَقِّبٌ). وَكَانَ إِسْحاقُ فِي السِّتِّينَ مِنْ عُمْرِهِ عِنْدَمَا أَنْجَبَتْهُمَا لَهُ رِفْقَةُ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","وَكَبُرَ الْوَلَدَانِ، فَأَصْبَحَ عِيسُو صَيَّاداً مَاهِراً وَرَجُلَ بَرِّيَّةٍ، بَيْنَمَا كَانَ يَعْقُوبُ رَجُلاً هَادِئاً يُقِيمُ فِي الْخِيَامِ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","وَأَحَبَّ إِسْحاقُ عِيسُو لأَنَّهُ كَانَ يَأْكُلُ مِنْ صَيْدِهِ، أَمَّا رِفْقَةُ فَقَدْ أَحَبَّتْ يَعْقُوبَ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","وَذَاتَ مَرَّةٍ عَادَ عِيسُو مِنَ الْحَقْلِ مُرْهَقاً فَوَجَدَ يَعْقُوبَ قَدْ طَبَخَ طَعَاماً، ");
INSERT INTO arbnav_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","فَقَالَ عِيسُو لِيَعْقُوبَ: «أَطْعِمْنِي مِنْ هَذَا الطَّبِيخِ الأَحْمَرِ لأَنَّنِي جَائِعٌ جِدّاً». لِهَذَا دُعِيَ عِيسُو بِأَدُومَ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","فَقَالَ يَعْقُوبُ: «بِعْنِي أَوَّلاً امْتِيَازَاتِ بَكُورِيَّتِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","فَقَالَ عِيسُو: «أَنَا لابُدَّ مَائِتٌ، فَأَيُّ نَفْعٍ لِي مِنْ بَكُورِيَّتِي؟» ");
INSERT INTO arbnav_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","فَأَجَابَهُ يَعْقُوبُ: «احْلِفْ لِي أَوَّلًا». فَحَلَفَ لَهُ، وَبَاعَ امْتِيَازَاتِ بَكُورِيَّتِهِ لِيَعْقُوبَ. ");
INSERT INTO arbnav_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","عِنْدَئِذٍ أَعْطَى يَعْقُوبُ عِيسُو خُبْزاً وَطَبِيخَ عَدَسٍ، فَأَكَلَ وَشَرِبَ ثُمَّ قَامَ وَمَضَى فِي سَبِيلِهِ. وَهَكَذَا احْتَقَرَ عِيسُو امْتِيَازَاتِ الْبَكُورِيَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","وَحَدَثَ فِي الأَرْضِ جُوعٌ غَيْرُ الْجُوعِ الأَوَّلِ الَّذِي كَانَ فِي أَيَّامِ إِبْرَاهِيمَ، فَارْتَحَلَ إِسْحاقُ إِلَى مَدِينَةِ جَرَارَ حَيْثُ أَبِيمَالِكُ مَلِكُ الْفِلِسْطِينِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","فَظَهَرَ لَهُ الرَّبُّ قَائِلاً: «لا تَمْضِ إِلَى مِصْرَ، بَلُ امْكُثْ فِي الأَرْضِ الَّتِي أُعَيِّنُهَا لَكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","أَقِمْ فِي هَذِهِ الأَرْضِ فَأَكُونَ مَعَكَ وَأُبَارِكَكَ، لأَنَّنِي أُعْطِي لَكَ وَلِذُرِّيَّتِكَ جَمِيعَ هَذِهِ الأَرْضِ وَفَاءً بِقَسَمِي الَّذِي أَقْسَمْتُ لإِبْرَاهِيمَ أَبِيكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","وَأُكَثِّرُ ذُرِّيَّتَكَ كَنُجُومِ السَّمَاءِ وَأَهِبُهَا جَمِيعَ هَذِهِ الْبِلادِ. وَتَتَبَارَكُ فِي نَسْلِكَ جَمِيعُ أُمَمِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","لأَنَّ إِبْرَاهِيمَ أَطَاعَ قَوْلِي، وَحَفِظَ أَوَامِرِي وَوَصَايَايَ وَفَرَائِضِي وَشَرَائِعِي». ");
INSERT INTO arbnav_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","فَأَقَامَ إِسْحاقُ فِي مَدِينَةِ جَرَارَ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","وَعِنْدَمَا سَأَلَهُ أَهْلُ الْمَدِينَةِ عَنْ زَوْجَتِهِ قَالَ: «هِيَ أُخْتِي» لأَنَّهُ خَافَ أَنْ يَقُولَ: «هِيَ زَوْجَتِي» لِئَلّا يَقْتُلَهُ أَهْلُ الْمَدِينَةِ مِنْ أَجْلِ رِفْقَةَ، لأَنَّهَا كَانَتْ رَائِعَةَ الْجَمَالِ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","وَحَدَثَ بَعْدَ أَنْ طَالَ مُكُوثُهُ هُنَاكَ، أَنَّ أَبِيمَالِكَ مَلِكَ الْفِلِسْطِينِيِّينَ أَطَلَّ مِنَ النَّافِذَةِ، فَشَاهَدَ إِسْحاقَ يُدَاعِبُ امْرَأَتَهُ رِفْقَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","فَاسْتَدْعَاهُ إِلَيْهِ وَقَالَ: «إِنَّهَا بِالْحَقِيقَةِ زَوْجَتُكَ، فَكَيْفَ قُلْتَ هِيَ أُخْتِي؟» فَأَجَابَ إِسْحاقُ: «لأَنِّي قُلْتُ: لَعَلِّي أُقْتَلُ بِسَبَبِهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","فَقَالَ أَبِيمَالِكُ: «مَا هَذَا الَّذِي فَعَلْتَ بِنَا؟ لَقَدْ كَانَ يَسِيراً عَلَى أَيِّ وَاحِدٍ مِنَ الشَّعْبِ أَنْ يَضْطَجِعَ مَعَ زَوْجَتِكَ فَتَجْلِبُ بِذَلِكَ عَلَيْنَا إِثْماً». ");
INSERT INTO arbnav_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","وَأَنْذَرَ أَبِيمَالِكُ كُلَّ الشَّعْبِ قَائِلاً: «كُلُّ مَنْ يَمَسُّ هَذَا الرَّجُلَ أَوْ زَوْجَتَهُ فَحَتْماً يَمُوتُ». ");
INSERT INTO arbnav_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","وَزَرَعَ إِسْحاقُ فِي تِلْكَ الأَرْضِ، فَحَصَدَ فِي تِلْكَ السَّنَةِ مِئَةَ ضِعْفٍ لأَنَّ اللهَ بَارَكَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","وَعَظُمَ شَأْنُ الرَّجُلِ، وَتَزَايَدَ غِنَاهُ وَأَصْبَحَ وَاسِعَ الثَّرَاءِ وَالنُّفُوذِ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","وَصَارَتْ لَهُ مَاشِيَةٌ، غَنَمٌ وَقُطْعَانُ بَقَرٍ وَعَبِيدٌ كَثِيرُونَ. فَحَسَدَهُ الْفِلِسْطِينِيُّونَ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","وَرَدَمَ الْفِلِسْطِينِيُّونَ بِالتُّرَابِ جَمِيعَ الآبَارِ الَّتِي حَفَرَهَا عَبِيدُ أَبِيهِ فِي أَيَّامِ إِبْرَاهِيمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","وَقَالَ أَبِيمَالِكُ لإِسْحاقَ: «ارْحَلْ عَنَّا لأَنَّكَ أَصْبَحْتَ أَكْثَرَ قُوَّةً مِنَّا». ");
INSERT INTO arbnav_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","فَانْصَرَفَ إِسْحاقُ مِنْ هُنَاكَ وَضَرَبَ خِيَامَهُ فِي وَادِي جَرَارَ حَيْثُ أَقَامَ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","وَأَعَادَ إِسْحاقُ حَفْرَ آبَارِ الْمِيَاهِ الَّتِي كَانَ قَدْ تَمَّ حَفْرُهَا فِي أَيَّامِ إِبْرَاهِيمَ وَرَدَمَهَا الْفِلِسْطِينِيُّونَ بَعْدَ مَوْتِ أَبِيهِ، وَدَعَاهَا بِالأَسْمَاءِ الَّتِي أَطْلَقَهَا عَلَيْهَا أَبُوهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","وَعِنْدَمَا حَفَرَ عَبِيدُ إِسْحاقَ فِي الْوَادِي وَعَثَرُوا عَلَى بِئْرِ مَاءٍ جَارٍ، ");
INSERT INTO arbnav_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","خَاصَمَ رُعَاةُ مَدِينَةِ جَرَارَ رُعَاةَ إِسْحاقَ قَائِلِينَ: «هَذَا الْمَاءُ لَنَا». فَدَعَا الْبِئْرَ «عِسِقَ» لأَنَّهُمْ نَازَعُوهُ عَلَيْهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ثُمَّ حَفَرُوا بِئْراً أُخْرَى وَتَخَاصَمُوا عَلَيْهَا، فَدَعَاهَا «سِطْنَةَ» (وَمَعْنَاهَا عَدَاوَةٌ). ");
INSERT INTO arbnav_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","وَانْتَقَلَ بَعْدَ ذَلِكَ مِنْ هُنَاكَ وَحَفَرَ بِئْراً أُخْرَى وَلَمْ يَتَنَازَعُوا عَلَيْهَا، فَدَعَا اسْمَهَا «رَحُوبُوتَ» (وَمَعْنَاهَا الأَمَاكِنُ الرَّحْبَةُ) قَائِلاً: «لأَنَّ الرَّبَّ قَدْ أَرْحَبَ الآنَ لَنَا وَأَثْمَرْنَا فِي الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ثُمَّ مَضَى مِنْ هُنَاكَ إِلَى بِئْرِ سَبْعٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","فَتَجَلَّى لَهُ الرَّبُّ فِي تِلْكَ اللَّيْلَةِ وَقَالَ: «أَنَا هُوَ إِلَهُ إِبْرَاهِيمَ أَبِيكَ. لَا تَخَفْ لأَنِّي مَعَكَ وَأُبَارِكُكَ وَأُكَثِّرُ ذُرِّيَّتَكَ مِنْ أَجْلِ عَبْدِي إِبْرَاهِيمَ». ");
INSERT INTO arbnav_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","فَشَيَّدَ إِسْحاقُ هُنَاكَ مَذْبَحاً وَدَعَا بِاسْمِ الرَّبِّ، ثُمَّ نَصَبَ هُنَاكَ خَيْمَتَهُ، وَحَفَرَ عَبِيدُهُ بِئْراً. ");
INSERT INTO arbnav_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","وَأَقْبَلَ عَلَيْهِ مِنْ مَدِينَةِ جَرَارَ أَبِيمَالِكُ وَأَحُزَّاتُ مُسْتَشَارُهُ، وَفِيكُولُ رَئِيسُ جَيْشِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","فَقَالَ لَهُمْ إِسْحاقُ: «مَا بَالُكُمْ قَدْ أَتَيْتُمْ إِلَيَّ، وَأَنْتُمْ قَدْ أَبْغَضْتُمُونِي وَصَرَفْتُمُونِي مِنْ عِنْدِكُمْ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","فَأَجَابُوهُ: «لَقَدْ تَبَيَّنَ لَنَا أَنَّ الرَّبَّ مَعَكَ، فَقُلْنَا: لِيَكُنْ بَيْنَنَا حَلْفٌ وَلْنَقْطَعْ مَعَكَ عَهْداً: ");
INSERT INTO arbnav_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","أَنْ لَا تُسِيءَ إِلَيْنَا كَمَا لَمْ نَمَسَّكَ بِشَرٍّ وَلَمْ يُصِبْكَ مِنَّا سِوَى الْخَيْرِ، ثُمَّ صَرَفْنَاكَ بِسَلامٍ. وَهَا أَنْتَ الآنَ مُبَارَكٌ مِنَ الرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","فَأَقَامَ لَهُمْ مَأْدُبَةً فَأَكَلُوا وَشَرِبُوا. ");
INSERT INTO arbnav_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ثُمَّ بَكَّرُوا فِي الصَّبَاحِ وَحَلَفَ بَعْضُهُمْ لِبَعْضٍ، وَشَيَّعَهُمْ إِسْحاقُ فَانْصَرَفُوا بِسَلامٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","وَفِي نَفْسِ ذَلِكَ الْيَوْمِ جَاءَ عَبِيدُ إِسْحاقَ وَأَخْبَرُوهُ قَائِلِينَ: «إِنَّنَا عَثَرْنَا عَلَى مَاءٍ فِي الْبِئْرِ الَّتِي حَفَرْنَاهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","فَدَعَاهَا شِبْعَةَ، لِذَلِكَ سُمِّيَتِ الْمَدِينَةُ بِئْرَ سَبْعٍ إِلَى هَذَا الْيَوْمِ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","وَلَمَّا بَلَغَ عِيسُو الأَرْبَعِينَ مِنْ عُمْرِهِ تَزَوَّجَ كُلًّا مِنْ يَهُودِيتَ بِنْتِ بِيرِي الْحِثِّيِّ، وَبَسْمَةَ بِنْتِ إِيلُونَ الْحِثِّيِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","فَأَتْعَسَتَا حَيَاةَ إِسْحاقَ وَرِفْقَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","وَلَمَّا شَاخَ إِسْحاقُ وَضَعُفَ بَصَرُهُ اسْتَدْعَى ابْنَهُ الأَكْبَرَ عِيسُو وَقَالَ لَهُ: «يَا بُنَيَّ، ");
INSERT INTO arbnav_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","هَا أَنَا قَدْ شِخْتُ وَلَسْتُ أَعْرِفُ مَتَى يَحِينُ يَوْمُ وَفَاتِي. ");
INSERT INTO arbnav_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","فَالآنَ خُذْ عُدَّتَكَ: جُعْبَتَكَ وَقَوْسَكَ، وَامْضِ إِلَى الْبَرِّيَّةِ وَاقْتَنِصْ لِي صَيْداً. ");
INSERT INTO arbnav_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","وَجَهِّزْ لِي طَعَاماً شَهِيًّا كَمَا أُحِبُّ وَائْتِنِي بِهِ لِآكُلَ، لِتُبَارِكَكَ نَفْسِي قَبْلَ أَنْ أَمُوتَ». ");
INSERT INTO arbnav_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","وَسَمِعَتْ رِفْقَةُ حَدِيثَ إِسْحاقَ لابْنِهِ عِيسُو. فَعِنْدَمَا انْطَلَقَ عِيسُو إِلَى الْبَرِّيَّةِ لِيَصْطَادَ صَيْداً وَيَأْتِيَ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","قَالَتْ رِفْقَةُ لابْنِهَا يَعْقُوبَ: «سَمِعْتُ أَبَاكَ يَقُولُ لِعِيسُو أَخِيكَ: ");
INSERT INTO arbnav_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","اقْتَنِصْ لِي صَيْداً، وَجَهِّزْ لِي أَطْعِمَةً شَهِيَّةً لِآكُلَ وَأُبَارِكَكَ أَمَامَ الرَّبِّ قَبْلَ مَوْتِي. ");
INSERT INTO arbnav_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","وَالآنَ يَا بُنَيَّ أَطِعْ قَوْلِي فِي مَا آمُرُكَ بِهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","وَاذْهَبْ إِلَى قَطِيعِ الْمَاشِيَةِ، وَاخْتَرْ جَدْيَيْنِ لأُجَهِّزَ لأَبِيكَ أَطْعِمَةً شَهِيَّةً كَمَا يُحِبُّ، ");
INSERT INTO arbnav_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","تُقَدِّمُهَا لأَبِيكَ لِيَأْكُلَ، فَيُبَارِكَكَ قَبْلَ وَفَاتِهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","فَقَالَ يَعْقُوبُ لِرِفْقَةَ أُمِّهِ: «أَخِي عِيسُو رَجُلٌ أَشْعَرُ، وَأَنَا رَجُلٌ أَمْلَسُ. ");
INSERT INTO arbnav_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","وَقَدْ يَجُسُّنِي أَبِي فَيَتَبَيَّنُ خِدَاعِي، وَأَسْتَجْلِبُ عَلَى نَفْسِي لَعْنَةً لَا بَرَكَةً». ");
INSERT INTO arbnav_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","فَقَالَتْ لَهُ أُمُّهُ: «لَعْنَتُكَ عَلَيَّ يَا بُنَيَّ، فَأَطِعْ قَوْلِي فَقَطْ، وَاذْهَبْ وَأَحْضِرِ الْجَدْيَيْنِ لِي». ");
INSERT INTO arbnav_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","فَذَهَبَ وَاخْتَارَهُمَا وَأَحْضَرَهُمَا لأُمِّهِ، فَأَعَدَّتْ رِفْقَةُ الأَطْعِمَةَ الْمُطَيَّبَةَ كَمَا يُحِبُّ أَبُوهُ ");
INSERT INTO arbnav_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","وَتَنَاوَلَتْ ثِيَابَ بِكْرِهَا عِيسُو الْفَاخِرَةَ الْمَوْجُودَةَ عِنْدَهَا فِي الْبَيْتِ وَأَلْبَسَتْ يَعْقُوبَ ابْنَهَا الأَصْغَرَ، ");
INSERT INTO arbnav_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","وَكَذَلِكَ غَطَّتْ يَدَيْهِ وَمَلاسَةَ عُنُقِهِ بِجِلْدِ الْجَدْيَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","وَأَعْطَتْهُ مَا أَعَدَّتْهُ مِنَ الأَطْعِمَةِ الشَّهِيَّةِ وَالْخُبْزِ. ");
INSERT INTO arbnav_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","فَأَقْبَلَ عَلَى أَبِيهِ وَقَالَ: «يَا أَبِي». فَأَجَابَهُ: «نَعَمْ يَا ابْنِي، مَنْ أَنْتَ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","فَقَالَ يَعْقُوبُ: «أَنَا عِيسُو بِكْرُكَ. وَقَدْ فَعَلْتُ كَمَا طَلَبْتَ، وَالآنَ قُمْ وَاجْلِسْ وَكُلْ مِنْ صَيْدِي حَتَّى تُبَارِكَنِي». ");
INSERT INTO arbnav_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","فَقَالَ إِسْحَاقُ: «كَيْفَ اسْتَطَعْتَ أَنْ تَجِدَ صَيْداً بِمِثْلِ هَذِهِ السُّرْعَةِ يَا وَلَدِي؟» فَأَجَابَهُ: «لأَنَّ الرَّبَّ إِلَهَكَ قَدْ يَسَّرَ لِي ذَلِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","وَقَالَ إِسْحاقُ: «اقْتَرِبْ مِنِّي لأَجُسَّكَ يَا ابْنِي لأَرَى إِنْ كُنْتَ حَقّاً ابْنِي عِيسُو أَمْ لا». ");
INSERT INTO arbnav_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","فَدَنَا يَعْقُوبُ مِنْ أَبِيهِ إِسْحاقَ فَجَسَّهُ وَقَالَ: «الصَّوْتُ صَوْتُ يَعْقُوبَ، أَمَّا الْيَدَانِ فَهُمَا يَدَا عِيسُو». ");
INSERT INTO arbnav_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","وَلَمْ يَعْرِفْهُ لأَنَّ يَدَيْهِ كَانَتَا مُشْعِرَتَيْنِ كَيَدَيْ أَخِيهِ عِيسُو، فَبَارَكَهُ، ");
INSERT INTO arbnav_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","وَسَأَلَ: «هَلْ أَنْتَ ابْنِي عِيسُو؟» فَأَجَابَ: «أَنَا هُوَ». ");
INSERT INTO arbnav_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ثُمَّ قَالَ: «قَدِّمْ لِي مِنْ صَيْدِكَ حَتَّى آكُلَ وَأُبَارِكَكَ». فَأَحْضَرَ يَعْقُوبُ إِلَيْهِ الطَّعَامَ فَأَكَلَ ثُمَّ قَدَّمَ لَهُ خَمْراً فَشَرِبَ، ");
INSERT INTO arbnav_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","فَقَالَ لَهُ إِسْحاقُ أَبُوهُ: «تَعَالَ وَقَبِّلْنِي يَا وَلَدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","فَاقْتَرَبَ مِنْهُ وَقَبَّلَهُ، فَتَنَسَّمَ رَائِحَةَ ثِيَابِهِ وَبَارَكَهُ قَائِلاً: «هَا إِنَّ رَائِحَةَ ابْنِي كَرَائِحَةِ حَقْلٍ بَارَكَهُ الرَّبُّ، ");
INSERT INTO arbnav_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","فَلْيُنْعِمْ عَلَيْكَ الرَّبُّ مِنْ نَدَى السَّمَاءِ وَمِنْ خَيْرَاتِ الأَرْضِ، فَيُكَثِّرُ لَكَ الْحِنْطَةَ وَالْخَمْرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","لِتَخْدُمْكَ الشُّعُوبُ، وَتَسْجُدْ لَكَ الْقَبَائِلُ، لِتَكُنْ سَيِّداً عَلَى إِخْوَتِكَ. وَبَنُو أُمِّكِ لَكَ يَنْحَنُونَ. وَلْيَكُنْ لاعِنُوكَ مَلْعُونِينَ، وَمُبَارِكُوكَ مُبَارَكِينَ». ");
INSERT INTO arbnav_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","وَلَمَّا فَرَغَ إِسْحاقُ مِنْ مُبَارَكَةِ يَعْقُوبَ، وَخَرَجَ يَعْقُوبُ مِنْ عِنْدِ أَبِيهِ، رَجَعَ عِيسُو مِنْ صَيْدِهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","فَجَهَّزَ هُوَ أَيْضاً أَطْعِمَةً طَيِّبَةً وَأَحْضَرَهَا إِلَى أَبِيهِ وَقَالَ: «لِيَقُمْ أَبِي وَيَأْكُلْ مِنْ صَيْدِ ابْنِهِ فَتُبَارِكَنِي نَفْسُكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","فَقَالَ إِسْحاقُ: «مَنْ أَنْتَ؟» فَأَجَابَهُ: «أَنَا ابْنُكَ بِكْرُكَ عِيسُو». ");
INSERT INTO arbnav_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","فَارْتَعَدَ إِسْحاقُ بِعُنْفٍ وَقَالَ: «مَنْ هُوَ إِذاً الَّذِي اصْطَادَ صَيْداً وَأَحْضَرَهُ إِلَيَّ فَأَكَلْتُ مِنَ الْكُلِّ قَبْلَ أَنْ تَجِيءَ، وَبَارَكْتُهُ؟ وَحَقّاً يَكُونُ مُبَارَكاً». ");
INSERT INTO arbnav_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","فَمَا إِنْ سَمِعَ عِيسُو كَلامَ أَبِيهِ حَتَّى أَطْلَقَ صَرْخَةً هَائِلَةً وَمُرَّةً جِدّاً وَقَالَ: «بَارِكْنِي أَنَا أَيْضاً يَا أَبِي». ");
INSERT INTO arbnav_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","فَأَجَابَ: «لَقَدْ مَكَرَ بِي أَخُوكَ وَسَلَبَ بَرَكَتَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","فَقَالَ: «أَلَمْ يُدْعَ اسْمُهُ يَعْقُوبَ؟ لَقَدْ تَعَقَّبَنِي مَرَّتَيْنِ: أَخَذَ بَكُورِيَّتِي، وَهَا هُوَ يَسْلُبُنِي الآنَ بَرَكَتِي». ثُمَّ قَالَ: «أَمَا احْتَفَظْتَ لِي بِبَرَكَةٍ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","فَأَجَابَ إِسْحاقُ: «لَقَدْ جَعَلْتُهُ سَيِّداً لَكَ، وَصَيَّرْتُ جَمِيعَ إِخْوَتِهِ لَهْ خُدَّاماً، وَبِالْحِنْطَةِ وَالْخَمْرِ أَمْدَدْتُهُ. فَمَاذَا أَفْعَلُ لَكَ الآنَ يَا وَلَدِي؟». ");
INSERT INTO arbnav_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","فَقَالَ عِيسُو: «أَلَكَ بَرَكَةٌ وَاحِدَةٌ فَقَطْ يَا أَبِي؟ بَارِكْنِي أَنَا أَيْضاً يَا أَبِي». وَأَجْهَشَ عِيسُو بِالْبُكَاءِ بِصَوْتٍ عَالٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","فَأَجَابَهُ أَبُوهُ: «هَا مَسْكَنُكَ يَكُونُ فِي أَرْضٍ جَدْبَاءَ لَا يَهْطِلُ عَلَيْهَا نَدَى السَّمَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","بِسَيْفِكَ تَعِيشُ وَلأَخِيكَ تَكُونُ عَبْداً، وَلَكِنْ حِينَ تَجْمَحُ تُحَطِّمُ نِيرَهُ عَنْ عُنْقِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","وَحَقَدَ عِيسُو عَلَى يَعْقُوبَ مِنْ أَجْلِ مَا نَالَهُ مِنْ بَرَكَةِ أَبِيهِ. فَنَاجَى نَفْسَهُ: «قَرِيباً يَمُوتُ أَبِي، وَبَعْدَئِذٍ أَقْتُلُ أَخِي يَعْقُوبَ». ");
INSERT INTO arbnav_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","فَبَلَغَ رِفْقَةَ وَعِيدُ عِيسُو ابْنِهَا الأَكْبَرِ، فَأَرْسَلَتْ وَاسْتَدْعَتْ يَعْقُوبَ ابْنَهَا الأَصْغَرَ وَقَالَتْ لَهُ: «عِيسُو يُخَطِّطُ لِقَتْلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","وَالآنَ يَا ابْنِي أَصْغِ لِقَوْلِي، وَقُمِ اهْرُبْ إِلَى أَخِي لابَانَ إِلَى حَارَانَ، ");
INSERT INTO arbnav_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","وَامْكُثْ عِنْدَهُ أَيَّاماً قَلائِلَ رَيْثَمَا يَهْدَأُ سُخْطُ أَخِيكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","وَمَتَى سَكَنَ غَضَبُهُ وَنَسِيَ مَا صَنَعْتَ بِهِ، عِنْدَئِذٍ أَبْعَثُ إِلَيْكَ لِتَعُودَ مِنْ هُنَاكَ. فَلِمَاذَا أُحْرَمُ مِنْكُمَا كِلَيْكُمَا فِي يَوْمٍ وَاحِدٍ؟». ");
INSERT INTO arbnav_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ثُمَّ قَالَتْ رِفْقَةُ لإِسْحاقَ: «قَدْ كَرِهْتُ حَيَاتِي مِنْ جَرَّاءِ الْبَنَاتِ الْحِثِّيَّاتِ، فَإِنْ تَزَوَّجَ يَعْقُوبُ مِنِ الْحِثِّيَّاتِ بَنَاتِ هَذِهِ الأَرْضِ الْمُمَاثِلاتِ لِزَوْجَتَيْ عِيسُو، فَإِنَّ مَوْتِي خَيْرٌ مِنْ حَيَاتِي». ");
INSERT INTO arbnav_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","فَاسْتَدْعَى إِسْحاقُ يَعْقُوبَ وَبَارَكَهُ وَأَوْصَاهُ قَائِلاً: «لا تَتَزَوَّجْ مِنْ بَنَاتِ كَنْعَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","قُمِ انْطَلِقْ إِلَى سَهْلِ أَرَامَ، إِلَى بَيْتِ بَتُوئِيلَ أَبِي أُمِّكَ، وَتَزَوَّجْ إِحْدَى بَنَاتِ خَالِكَ لابَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","وَلْيُبَارِكْكَ اللهُ الْقَدِيرُ وَيُنَمِّكَ وَيُكَثِّرْكَ لِتَكُونَ أُمَّةً تَتَفَرَّعُ مِنْهَا شُعُوبٌ كَثِيرَةٌ، ");
INSERT INTO arbnav_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","وَلْيُعْطِكَ أَنْتَ وَذُرِّيَّتَكَ مَعَكَ بَرَكَةَ إِبْرَاهِيمَ لِتَرِثَ أَرْضَ غُرْبَتِكَ الَّتِي تُقِيمُ فِيهَا الآنَ؛ هَذِهِ الأَرْضَ الَّتِي وَهَبَهَا اللهُ لإِبْرَاهِيمَ». ");
INSERT INTO arbnav_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ثُمَّ صَرَفَ إِسْحاقُ يَعْقُوبَ فَمَضَى إِلَى سَهْلِ أَرَامَ، حَيْثُ يُقِيمُ لابَانُ بْنُ بَتُوئِيلَ الأَرَامِيُّ أَخُو رِفْقَةَ أُمِّ يَعْقُوبَ وَعِيسُو. ");
INSERT INTO arbnav_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","وَلَمَّا رَأَى عِيسُو أَنَّ إِسْحاقَ قَدْ بَارَكَ يَعْقُوبَ وَصَرَفَهُ إِلَى سَهْلِ أَرَامَ لِيَخْتَارَ مِنْ هُنَاكَ زَوْجَةً، وَأَوْصَاهُ قَائِلاً: «لا تَتَزَوَّجِ امْرَأَةً كَنْعَانِيَّةً» ");
INSERT INTO arbnav_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","وَأَنَّ يَعْقُوبَ أَطَاعَ وَالِدَيْهِ وَارْتَحَلَ إِلَى سَهْلِ أَرَامَ ");
INSERT INTO arbnav_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","وَإِذْ رَأَى عِيسُو أَنَّ بَنَاتِ كَنْعَانَ شِرِّيرَاتٌ لَمْ يَحْظَيْنَ بِرِضَى أَبِيهِ ");
INSERT INTO arbnav_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","مَضَى إِلَى إِسْمَاعِيلَ عَمِّهِ وَأَخَذَ مَحْلَةَ ابْنَةَ إِسْمَاعِيلَ بْنِ إِبْرَاهِيمَ، أُخْتَ نَبَايُوتَ، زَوْجَةً لَهُ عَلَى نِسَائِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","أَمَّا يَعْقُوبُ فَتَوَجَّهَ مِنْ بِئْرِ سَبْعٍ نَحْوَ حَارَانَ، ");
INSERT INTO arbnav_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","فَصَادَفَ مَوْضِعاً قَضَى فِيهِ لَيْلَتَهُ لأَنَّ الشَّمْسَ كَانَتْ قَدْ غَابَتْ، فَأَخَذَ بَعْضَ حِجَارَةِ الْمَوْضِعِ وَتَوَسَّدَهَا وَبَاتَ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","وَرَأَى حُلْماً شَاهَدَ فِيهِ سُلَّماً قَائِمَةً عَلَى الأَرْضِ وَرَأْسُهَا يَمَسُّ السَّمَاءَ، وَمَلائِكَةُ اللهِ تَصْعَدُ وَتَنْزِلُ عَلَيْهَا، ");
INSERT INTO arbnav_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","وَالرَّبُّ نَفْسُهُ وَاقِفٌ فَوْقَهَا يَقُولُ: «أَنَا هُوَ الرَّبُّ إِلَهُ أَبِيكَ إِبْرَاهِيمَ وَإِلَهُ إِسْحاقَ. إِنَّ الأَرْضَ الَّتِي تَرْقُدُ عَلَيْهَا الآنَ أُعْطِيهَا لَكَ وَلِذُرِّيَّتِكَ، ");
INSERT INTO arbnav_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","الَّتِي سَتَكُونُ كَتُرَابِ الأَرْضِ، وَتَمْتَدُّ غَرْباً وَشَرْقاً، وَشِمَالاً وَجَنُوباً، وَتَتَبَارَكُ بِكَ وَبِذُرِّيَّتِكَ جَمِيعُ شُعُوبِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","هَا أَنَا مَعَكَ وَأَرْعَاكَ حَيْثُمَا تَذْهَبُ، وَأَرُدُّكَ إِلَى هَذِهِ الأَرْضِ. وَلَنْ أَتْرُكَكَ إِلَى أَنْ أَفِيَ بِكُلِّ مَا وَعَدْتُكَ بِهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ثُمَّ أَفَاقَ يَعْقُوبُ مِنْ نَوْمِهِ وَقَالَ: «حَقّاً إِنَّ الرَّبَّ فِي هَذَا الْمَوْضِعِ وَأَنَا لَمْ أَعْلَمْ!» ");
INSERT INTO arbnav_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","وَاعْتَرَاهُ خَوْفٌ وَقَالَ: «مَا أَرْهَبَ هَذَا الْمَكَانَ! مَا هَذَا سِوَى بَيْتِ اللهِ وَهَذَا هُوَ بَابُ السَّمَاءِ». ");
INSERT INTO arbnav_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ثُمَّ بَكَّرَ يَعْقُوبُ فِي الصَّبَاحِ، وَأَخَذَ الْحَجَرَ الَّذِي تَوَسَّدَهُ وَنَصَبَهُ عَمُوداً وَصَبَّ عَلَيْهِ زَيْتاً، ");
INSERT INTO arbnav_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","وَدَعَا الْمَكَانَ «بَيْتَ إِيلَ» (وَمَعْنَاهُ: بَيْتُ اللهِ) وَكَانَ اسْمُ الْمَدِينَةِ أَوَّلاً «لُوزَ». ");
INSERT INTO arbnav_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","وَنَذَرَ يَعْقُوبُ نَذْراً قَائِلاً: «إِنْ كَانَ اللهُ مَعِي، وَرَعَانِي فِي هَذِهِ الطَّرِيقِ الَّتِي أَنَا أَسِيرُ فِيهَا وَوَفَّرَ لِي طَعَاماً لِآكُلَ وَثِيَاباً لأَلْبَسَ، ");
INSERT INTO arbnav_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","وَعُدْتُ بِسَلامٍ إِلَى بَيْتِ أَبِي، عِنْدَئِذٍ يَكُونُ الرَّبُّ إِلَهاً لِي ");
INSERT INTO arbnav_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","وَيَكُونُ هَذَا الْحَجَرُ الَّذِي نَصَبْتُهُ عَمُوداً بَيْتاً لِلهِ، وَأَدْفَعُ عُشْرَ كُلِّ مَا تَرْزُقُنِي بِهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","وَتَابَعَ يَعْقُوبُ رِحْلَتَهُ حَتَّى وَصَلَ أَرْضَ حَارَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","وَتَطَلَّعَ حَوْلَهُ فَشَاهَدَ بِئْراً فِي الْحَقْلِ، تَرْبِضُ عِنْدَهَا ثَلاثَةُ قُطْعَانِ غَنَمٍ، لأَنَّهُمْ كَانُوا يَسْقُونَ الْقُطْعَانَ مِنْ تِلْكَ الْبِئْرِ. وَكَانَ الْحَجَرُ الَّذِي عَلَى فَمِ الْبِئْرِ كَبِيراً، ");
INSERT INTO arbnav_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","فَكَانَ رُعَاةُ جَمِيعِ الْقُطْعَانِ يَجْتَمِعُونَ هُنَاكَ، وَيُدَحْرِجُونَ الْحَجَرَ عَنْ فَمِ الْبِئْرِ وَيَسْقُونَ الْغَنَمَ. ثُمَّ يَرُدُّونَ الْحَجَرَ إِلَى مَوْضِعِهِ عَلَى فَمِ الْبِئْرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","فَقَالَ لَهُمْ يَعْقُوبُ: «يَا إِخْوَتِي مِنْ أَيْنَ أَنْتُمْ؟» فَأَجَابُوا: «نَحْنُ مِنْ حَارَانَ». ");
INSERT INTO arbnav_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","فَسَأَلَهُمْ: «أَتَعْرِفُونَ لابَانَ بْنَ نَاحُورَ؟» فَأَجَابُوا: «نَعْرِفُهُ». ");
INSERT INTO arbnav_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","فَقَالَ لَهُمْ: «أَهُوَ بِخَيْرٍ؟». فَأَجَابُوهُ: «هُوَ بِخَيْرٍ، وَهَا هِيَ رَاحِيلُ ابْنَتُهُ مُقْبِلَةٌ مَعَ الْغَنَمِ». ");
INSERT INTO arbnav_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","فَقَالَ لَهُمْ: «هُوَذَا النَّهَارُ مَازَالَ طَوِيلاً، وَلَيْسَ هَذَا أَوَانَ اجْتِمَاعِ الْمَوَاشِي، فَاسْقُوا الْغَنَمَ وَامْضُوا بِها إلَى الْمَرَاعِي». ");
INSERT INTO arbnav_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","فَقَالُوا: «لا يُمْكِنُنَا ذَلِكَ إِلّا بَعْدَ أَنْ تَجْتَمِعَ جَمِيعُ الْقُطْعَانِ وَرُعَاتُهَا فَيُدَحْرِجُوا الْحَجَرَ عَنْ فَمِ الْبِئْرِ، فَنَسْقِي الْغَنَمَ». ");
INSERT INTO arbnav_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","وَفِيمَا هُوَ يُكَلِّمُهُمْ أَقْبَلَتْ رَاحِيلُ مَعَ غَنَمِ أَبِيهَا لأَنَّهَا كَانَتْ رَاعِيَةً أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","وَعِنْدَمَا رَآهَا يَعْقُوبُ، تَقَدَّمَ وَدَحْرَجَ الْحَجَرَ عَنْ فَمِ الْبِئْرِ وَسَقَى غَنَمَ خَالِهِ لابَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","وَقَبَّلَ يَعْقُوبُ رَاحِيلَ وَأَجْهَشَ بِالْبُكَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ثُمَّ أَخْبَرَهَا أَنَّهُ قَرِيبُ وَالِدِهَا وَأَنَّهُ ابْنُ رِفْقَةَ. فَرَكَضَتْ وَأَخْبَرَتْ أَبَاهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","فَعِنْدَمَا سَمِعَ لابَانُ بِخَبَرِ ابْنِ أُخْتِهِ أَسْرَعَ لِلِقَائِهِ وَعَانَقَهُ وَقَبَّلَهُ وَأَحْضَرَهُ إِلَى مَنْزِلِهِ. فَقَصَّ يَعْقُوبُ عَلَى لابَانَ جَمِيعَ هَذِهِ الأُمُورِ. ");
INSERT INTO arbnav_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","فَقَالَ لَهُ لابَانُ: «حَقّاً إِنَّكَ عَظْمِي وَلَحْمِي». وَأَقَامَ عِنْدَهُ نَحْوَ شَهْرٍ مِنَ الزَّمَانِ. ");
INSERT INTO arbnav_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","وَقَالَ لابَانُ لِيَعْقُوبَ: «هَلْ لأَنَّكَ قَرِيبِي تَخْدُمُنِي مَجَّاناً؟ أَخْبِرْنِي مَا أُجْرَتُكَ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","وَكَانَ لِلابَانَ ابْنَتَانِ، اسْمُ الْكُبْرَى لَيْئَةُ وَاسْمُ الصُّغْرَى رَاحِيلُ، ");
INSERT INTO arbnav_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","وَكَانَتْ لَيْئَةُ ضَعِيفَةَ الْبَصَرِ، وَأَمَّا رَاحِيلُ فَكَانَتْ جَمِيلَةَ الصُّورَةِ وَحَسَنَةَ الْمَنْظَرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","فَأَحَبَّ يَعْقُوبُ رَاحِيلَ. وَأَجَابَ يَعْقُوبُ خَالَهُ: «أَخْدِمُكَ سَبْعَ سِنِينَ لِقَاءَ زَوَاجِي بِرَاحِيلَ ابْنَتِكَ الصُّغْرَى». ");
INSERT INTO arbnav_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","فَقَالَ لابَانُ: «أَنْ أُزَوِّجَهَا مِنْكَ خَيْرٌ مِنْ أَنْ أزَوِّجَهَا مِنْ رَجُلٍ آخَرَ، فَامْكُثْ عِنْدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","فَخَدَمَ يَعْقُوبُ سَبْعَ سَنَوَاتٍ لِيَتَزَوَّجَ مِنْ رَاحِيلَ بَدَتْ فِي نَظَرِهِ كَأَيَّامٍ قَلِيلَةٍ، لِفَرْطِ مَحَبَّتِهِ لَهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ثُمَّ قَالَ يَعْقُوبُ لِلابَانَ: «أَعْطِنِي زَوْجَتِي لأَنَّ خِدْمَتِي قَدْ كَمُلَتْ فَأَدْخُلَ عَلَيْهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","فَجَمَعَ لابَانُ سَائِرَ أَهْلِ النَّاحِيَةِ وَأَقَامَ لَهُمْ مَأْدُبَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","وَعِنْدَمَا حَلَّ الْمَسَاءُ حَمَلَ ابْنَتَهُ لَيْئَةَ وَزَفَّهَا إِلَيْهِ فَدَخَلَ عَلَيْهَا ");
INSERT INTO arbnav_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","وَوَهَبَ لابَانُ زِلْفَةَ جَارِيَتَهُ لِتَكُونَ جَارِيَةً لابْنَتِهِ لَيْئَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","وَفِي الصَّبَاحِ اكْتَشَفَ يَعْقُوبُ أَنَّهُ تَزَوَّجَ بِلَيْئَةَ، فَقَالَ لِلابَانَ: «مَاذَا فَعَلْتَ بِي؟ أَلَمْ أَخْدِمْكَ سَبْعَ سَنَوَاتٍ لِقَاءَ زَوَاجِي مِنْ رَاحِيلَ؟ فَلِمَاذَا خَدَعْتَنِي؟». ");
INSERT INTO arbnav_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","فَأَجَابَهُ لابَانُ: «لَيْسَ مِنْ عَادَةِ بِلادِنَا أَنْ نُزَوِّجَ الصَّغِيرَةَ قَبْلَ الْبِكْرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","أَكْمِلْ أُسْبُوعَ لَيْئَةَ ثُمَّ نُزَوِّجُكَ مِنْ رَاحِيلَ، لِقَاءَ خِدْمَتِكَ لِي سَبْعَ سِنِينَ أُخَرَ». ");
INSERT INTO arbnav_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","فَوَافَقَ يَعْقُوبُ، وَأَكْمَلَ أُسْبُوعَ لَيْئَةَ، فَأَعْطَاهُ لابَانُ رَاحِيلَ ابْنَتَهُ زَوْجَةً أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","وَوَهَبَ لابَانُ بِلْهَةَ جَارِيَتَهُ لِتَكُونَ جَارِيَةً لابْنَتِهِ رَاحِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","فَدَخَلَ يَعْقُوبُ عَلَى رَاحِيلَ أَيْضاً، وَأَحَبَّ رَاحِيلَ أَكْثَرَ مِنْ لَيْئَةَ. وَخَدَمَ خَالَهُ سَبْعَ سِنِينَ أُخَرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","وَعِنْدَمَا رَأَى الرَّبُّ أَنَّ لَيْئَةَ مَكْرُوهَةٌ جَعَلَهَا مُنْجِبَةً، أَمَّا رَاحِيلُ فَكَانَتْ عَاقِراً. ");
INSERT INTO arbnav_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","فَحَمَلَتْ لَيْئَةُ وَأَنْجَبَتِ ابْناً دَعَتْهُ رَأُوبَيْنَ (وَمَعْنَاهُ: هُوَذَا ابْنٌ) لأَنَّهَا قَالَتْ: «حَقّاً قَدْ نَظَرَ الرَّبُّ إِلَى مَذَلَّتِي، فَالآنَ يُحِبُّنِي زَوْجِي». ");
INSERT INTO arbnav_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","وَحَمَلَتْ مَرَّةً أُخْرَى وَأَنْجَبَتِ ابْناً، فَقَالَتْ: «لأَنَّ الرَّبَّ سَمِعَ أَنَّنِي كُنْتُ مَكْرُوهَةً رَزَقَنِي هَذَا الابْنَ أَيْضاً». فَدَعَتْهُ شِمْعُونَ (وَمَعْنَاهُ: سَمِيعٌ) ");
INSERT INTO arbnav_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ثُمَّ حَمَلَتْ مَرَّةً ثَالِثَةً وَأَنْجَبَتِ ابْناً فَقَالَتْ: «الآنَ فِي هَذِهِ الْمَرَّةِ يَتَّحِدُ بِي زَوْجِي، لأَنَّنِي أَنْجَبْتُ لَهُ ثَلاثَةَ بَنِينَ». لِذَلِكَ دُعِيَ اسْمُهُ لاوِي (وَمَعْنَاهُ: مُتَّحِدٌ) ");
INSERT INTO arbnav_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","وَحَبِلَتْ مَرَّةً رَابِعَةً وَأَنْجَبَتِ ابْناً فَقَالَتْ: «فِي هَذِهِ الْمَرَّةِ أَحْمَدُ الرَّبَّ». لِذَلِكَ دَعَتْهُ يَهُوذَا (وَمَعْنَاهُ: حَمْدٌ). ثُمَّ تَوَقَّفَتْ عَنِ الْوِلادَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","وَعِنْدَمَا تَبَيَّنَتْ رَاحِيلُ أَنَّهَا عَاقِرٌ، غَارَتْ مِنْ أُخْتِهَا، وَقَالَتْ لِيَعْقُوبَ: «هَبْ لِي بَنِينَ وَإلَّا فَإِنِّي أَمُوتُ». ");
INSERT INTO arbnav_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","فَاحْتَدَمَ غَضَبُ يَعْقُوبَ عَلَى رَاحِيلَ وَقَالَ: «أَلَعَلِّي أَقُومُ مَقَامَ اللهِ الَّذِي حَرَمَكِ مِنَ الإِنْجَابِ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","فَقَالَتْ لَهُ: «هَا هِيَ جَارِيَتِي بِلْهَةُ، عَاشِرْهَا فَتَلِدَ وَيَكُونَ لِي مِنْهَا بَنُونَ». ");
INSERT INTO arbnav_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","وَأَعْطَتْهُ بِلْهَةَ زَوْجَةً فَدَخَلَ عَلَيْهَا يَعْقُوبُ. ");
INSERT INTO arbnav_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","وَحَمَلَتْ بِلْهَةُ وَأَنْجَبَتْ لِيَعْقُوبَ ابْناً. ");
INSERT INTO arbnav_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","فَقَالَتْ رَاحِيلُ: «قَدْ قَضَى اللهُ لِي وَأَصْغَى لِصَوْتِي وَرَزَقَنِي ابْناً». لِذَلِكَ دَعَتْهُ دَاناً (وَمَعْنَاهُ: قَاضٍ). ");
INSERT INTO arbnav_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ثُمَّ حَمَلَتْ بِلْهَةُ جَارِيَةُ رَاحِيلَ مَرَّةً أُخْرَى وَأَنْجَبَتْ لِيَعْقُوبَ ابْناً ثَانِياً، ");
INSERT INTO arbnav_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","فَقَالَتْ رَاحِيلُ: «قَدْ تَصَارَعْتُ مَعَ أُخْتِي مُصَارَعَاتٍ عَنِيفَةً وَظَفِرْتُ». وَدَعَتْهُ نَفْتَالِي (وَمَعْنَاهُ: مُصَارَعَتِي). ");
INSERT INTO arbnav_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","وَلَمَّا رَأَتْ لَيْئَةُ أَنَّهَا كَفَّتْ عَنِ الْوِلادَةِ، أَخَذَتْ جَارِيَتَهَا زِلْفَةَ وَأَعْطَتْهَا لِيَعْقُوبَ زَوْجَةً، ");
INSERT INTO arbnav_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","فَأَنْجَبَتْ زِلْفَةُ جَارِيَةُ لَيْئَةَ لِيَعْقُوبَ ابْناً ");
INSERT INTO arbnav_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","فَقَالَتْ لَيْئَةُ: «يَا لَحُسْنِ الْحَظِّ!» وَدَعَتْهُ جَاداً (وَمَعْنَاهُ: فَأْلٌ حَسَنٌ، أَوْ كَتِيبَةٌ قَادِمَةٌ). ");
INSERT INTO arbnav_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","وَأَنْجَبَتْ زِلْفَةُ جَارِيَةُ لَيْئَةُ ابْناً ثَانِياً لِيَعْقُوبَ، ");
INSERT INTO arbnav_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","فَقَالَتْ لَيْئَةُ: «يَا لَغِبْطَتِي، لأَنَّ النِّسَاءَ سَيَدْعُونَنِي الْمَغْبُوطَةَ». وَأَسْمَتْهُ أَشِيْرَ (وَمَعْنَاهُ: سَعِيدٌ أَوْ مَغْبُوطٌ). ");
INSERT INTO arbnav_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","وَذَهَبَ رَأُوبَيْنُ فِي مَوْسِمِ حَصَادِ الْقَمْحِ إِلَى الْحَقْلِ، فَعَثَرَ فِيهِ عَلَى نَبَاتِ اللُّفَّاحِ وَجَاءَ بِهِ إِلَى أُمِّهِ لَيْئَةَ. فَقَالَتْ رَاحِيلُ لِلَيْئَةَ: «أَعْطِنِي مِنْ لُفَّاحِ ابْنِكِ». ");
INSERT INTO arbnav_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","فَأَجَابَتْهَا: «أَلَمْ يَكْفِ أَنَّكِ أَخَذْتِ مِنِّي زَوْجِي، وَالآنَ تُرِيِدينَ أَنْ تَأْخُذِي لُفَّاحَ ابْنِي أَيْضاً؟» فَأَجَابَتْهَا رَاحِيلُ: «إِذاً يُعَاشِرُكِ اللَّيلَةَ لِقَاءَ لُفَّاحِ ابْنِكِ». ");
INSERT INTO arbnav_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","وَعِنْدَمَا رَجَعَ يَعْقُوبُ مِنَ الْحَقَلِ فِي الْمَسَاءِ خَرَجَتْ لَيْئَةُ لِلِقَائِهِ وَقَالَتْ لَهُ: «إِلَيَّ تَجِيءُ اللَّيْلَةَ لأَنَّنِي قَدِ اسْتَأْجَرْتُكَ بِلُفَّاحِ ابْنِي». فَعَاشَرَهَا فِي تِلْكَ اللَّيْلَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","وَاسْتَجَابَ اللهُ لِلَيْئَةَ فَحَمَلَتْ وَأَنْجَبَتْ لِيَعْقُوبَ ابْناً خَامِساً. ");
INSERT INTO arbnav_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","فَقَالَتْ لَيْئَةُ: «قَدْ أَعْطَانِي اللهُ أُجْرَتِي لأَنَّنِي وَهَبْتُ جَارِيَتِي لِزَوْجِي». وَدَعَتْهُ يَسَّاكَرَ (وَمَعْنَاهُ: يَعْمَلُ بِأُجْرَةٍ) ");
INSERT INTO arbnav_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","وَحَبِلَتْ لَيْئَةُ مَرَّةً أُخْرَى فَأَنْجَبَتْ لِيَعْقُوبَ ابْناً سَادِساً. ");
INSERT INTO arbnav_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","وَقَالَتْ لَيْئَةُ: «قَدَ وَهَبَنِي اللهُ هِبَةً ثَمِينَةً، وَالآنَ يُقِيمُ مَعِي زَوْجِي لأَنِّي أَنْجَبْتُ لَهُ سِتَّةَ بَنِينَ». وَدَعَتْهُ زَبُولُونَ (وَمَعْنَاهُ إِقَامَةُ). ");
INSERT INTO arbnav_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ثُمَّ أَنْجَبَتِ ابْنَةً دَعَتْهَا «دِينَةَ». ");
INSERT INTO arbnav_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","وَذَكَرَ اللهُ رَاحِيلَ وَاسْتَجَابَ لَهَا وَفَتَحَ رَحِمَهَا، ");
INSERT INTO arbnav_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","فَحَمَلَتْ وَأَنْجَبَتِ ابْناً وَقَالَتْ: «قَدَ نَزَعَ اللهُ عَنِّي عَارِي». ");
INSERT INTO arbnav_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","وَدَعَتْهُ يُوسُفَ (وَمَعْنَاهُ يَزِيدُ) قَائِلَةً: «لِيَزِدْنِي الرَّبُّ ابْناً آخَرَ». ");
INSERT INTO arbnav_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","وَعِنْدَمَا وَلَدَتْ رَاحِيلُ يُوسُفَ، قَالَ يَعْقُوبُ لِلابَانَ: «أَخْلِ سَبِيلِي فَأَنْطَلِقَ إِلَى بَلَدِي وَإِلَى أَرْضِي، ");
INSERT INTO arbnav_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","وَأَعْطِنِي نِسَائِي وَأَوْلادِي الَّذِينَ خَدَمْتُكَ بِهِمْ، وَدَعْنِي أَمْضِي، فَأَنْتَ تُدْرِكُ أَيَّةَ خِدْمَةٍ خَدَمْتُكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","فَقَالَ لَهُ لابَانُ: «إِنْ كُنْتُ قَدْ حَظِيتُ بِرِضَاكَ فَأَرْجُوكَ أَنْ تَمْكُثَ مَعِي، لأَنَّنِي عَرَفْتُ بِالتَّفَاؤُلِ بِالْغَيْبِ أَنَّ الرَّبَّ قَدْ بَارَكَنِي بِفَضْلِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","وَأَضَافَ: «عَيِّنْ لِي أُجْرَتَكَ فَأُعْطِيَكَ إِيَّاهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","فَقَالَ لَهُ يَعْقُوبُ: «أَنْتَ تَعْلَمُ كَيْفَ خَدَمْتُكَ، وَمَاذَا آلَتْ إِلَيْهِ مَوَاشِيكَ تَحْتَ رِعَايَتِي، ");
INSERT INTO arbnav_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","فَالْقَلِيلُ الَّذِي كَانَ لَكَ قَبْلَ مَجِيئِي ازْدَادَ أَضْعَافاً كَثِيرَةً، فَبَارَكَكَ الرَّبُّ مُنْذُ أَنْ قَدِمْتُ عَلَيْكَ، وَالآنَ مَتَى أَشْرَعُ فِي تَحْصِيلِ رِزْقِ عَائِلَتِي؟» ");
INSERT INTO arbnav_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","فَسَأَلَهُ: «مَاذَا أُعْطِيكَ؟» فَأَجَابَهُ يَعْقُوبُ: «لا تُعْطِنِي شَيْئاً. وَلَكِنْ إِنْ أَرَدْتَ، فَاصْنَعْ لِي هَذَا الأَمْرَ الْوَاحِدَ فَأَذْهَبَ وَأَرْعَى غَنَمَكَ وَأَعْتَنِيَ بِها: ");
INSERT INTO arbnav_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","دَعْنِي أَمُرُّ الْيَوْمَ بَيْنَ مَوَاشِيكَ كُلِّهَا، فَتَعْزِلَ مِنْهَا كُلَّ شَاةٍ رَقْطَاءَ وَبَلْقَاءَ وَسَوْدَاءَ مِنْ بَيْنِ الْخِرْفَانِ، وَكُلَّ بَلْقَاءَ وَرَقْطَاءَ بَيْنَ الْمِعْزَى، فَتَكُونُ هَذِهِ أُجْرَتِي. ");
INSERT INTO arbnav_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","وَتَكُونُ أَمَانَتِي شَاهِدَةً عَلَى صِدْقِ خِدْمَتِي فِي مُسْتَقْبَلِ الأَيَّامِ. فَإِذَا جِئْتَ تَفْحَصُ أُجْرَتِي، وَوَجَدْتَ عِنْدِي مَا لَيْسَ أَرْقَطَ أَوْ أَبْلَقَ بَيْنَ الْمِعْزَى وَأَسْوَدَ بَيْنَ الْخِرْفَانِ، يَكُونُ مَسْرُوقاً عِنْدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","فَقَالَ لابَانُ: «لِيَكُنْ وَفْقاً لِقَوْلِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","وَعَزَلَ لابَانُ فِي ذَلِكَ الْيَوْمِ التُّيُوسَ الْمُخَطَّطَةَ وَالْبَلْقَاءَ، وَكُلَّ عَنْزٍ رَقْطَاءَ وَبَلْقَاءَ، كُلَّ مَا فِيهِ بَيَاضٌ وَكُلَّ خَرُوفٍ أَسْوَدَ. وَعَهِدَ بِها إِلَى أَبْنَاءِ يَعْقُوبَ. ");
INSERT INTO arbnav_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","وَجَعَلَ بَيْنَهُ وَبَيْنَ يَعْقُوبَ مَسَافَةَ ثَلاثَةِ أَيَّامٍ، وَاسْتَمَرَّ يَعْقُوبُ يَرْعَى مَوَاشِي لابَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","وَأَخَذَ يَعْقُوبُ قُضْبَاناً خَضْرَاءَ مِنْ أَشْجَارِ اللُّبْنَى وَاللَّوْزِ وَالدُّلْبِ وَقَلَّمَهَا بِخُطُوطٍ بَيْضَاءَ كَاشِفاً عَمَّا تَحْتَ الْقِشْرَةِ مِنْ بَيَاضٍ، ");
INSERT INTO arbnav_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","وَنَصَبَ الْقُضْبَانَ الَّتِي قَلَّمَهَا تِجَاهَ الْغَنَمِ فِي أَجْرَانِ مَسَاقِي الْمَاءِ حَيْثُ تَرِدُ الْمَوَاشِي، فَتَتَوَحَّمُ عَلَيْهَا إِذَا مَا أَقْبَلَتْ لِتَشْرَبَ. ");
INSERT INTO arbnav_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","فَكَانَتِ الْغَنَمُ تَتَوَحَّمُ عِنْدَ الْقُضْبَانِ، فَتَلِدُ غَنَماً مُخَطَّطَةً وَرَقْطَاءَ وَبَلْقَاءَ. ");
INSERT INTO arbnav_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","وَفَرَزَ يَعْقُوبُ الْحُمْلانَ، وَجَعَلَ مُقَدِّمَةَ الْمَوَاشِي فِي مُوَاجَهَةِ كُلِّ مَا هُوَ مُخَطَّطٌ وَأَسْوَدُ مِنْ غَنَمِ لابَانَ، وَأَقَامَ لِنَفْسِهِ قُطْعَاناً عَلَى حِدَةٍ بِمَعْزِلٍ عَنْ غَنَمِ لابَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","فَكَانَ يَعْقُوبُ كُلَّمَا تَوَحَّمَتِ الْغَنَمُ الْقَوِيَّةُ يَنْصِبُ الْقُضْبَانَ أَمَامَ عُيُونِ الْمَوَاشِي فِي الأَجْرَانِ لِتَتَوَحَّمَ بَيْنَ الْقُضْبَانِ. ");
INSERT INTO arbnav_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","وَحِينَ تَكُونُ الْغَنَمُ ضَعِيفَةً، لَا يَضَعُ الْقُضْبَانَ أَمَامَهَا، فَصَارَتِ الضَّعِيفَةُ لِلابَانَ وَالْقَوِيَّةُ لِيَعْقُوبَ. ");
INSERT INTO arbnav_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","فَاغْتَنَى الرَّجُلُ جِدّاً، وَكَثُرَتْ مَوَاشِيهِ وَجَوَارِيهِ وَعَبِيدُهُ وَجِمَالُهُ وَحَمِيرُهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","وَسَمِعَ يَعْقُوبُ مَا يُرَدِّدُهُ أَبْنَاءُ لابَانَ قَائِلِينَ: «لَقَدِ اسْتَوْلَى يَعْقُوبُ عَلَى كُلِّ مَا لأَبِينَا، وَجَمَعَ ثَرْوَتَهُ مِمَّا يَمْلِكُهُ وَالِدُنَا». ");
INSERT INTO arbnav_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","وَرَأَى يَعْقُوبُ أَنَّ مُعَامَلَةَ لابَانَ لَهُ قَدْ طَرَأَ عَلَيْهَا تَغْيِيرٌ فَاخْتَلَفَتْ عَمَّا كَانَتْ عَلَيْهِ سَابِقاً. ");
INSERT INTO arbnav_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","وَقَالَ الرَّبُّ لِيَعْقُوبَ: «عُدْ إِلَى أَرْضِ آبَائِكَ وَإِلَى قَوْمِكَ وَأَنَا أَكُونُ مَعَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","فَأَرْسَلَ يَعْقُوبُ وَاسْتَدْعَى رَاحِيلَ وَلَيْئَةَ إِلَى الْحَقْلِ حَيْثُ يَرْعَى الْمَاشِيَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","وَقَالَ لَهُمَا: «إِنِّي أَرَى أَنَّ أَبَاكُمَا لَمْ يَعُدْ يُعَامِلُنِي كَالْعَهْدِ بِهِ مِنْ قَبْلُ، وَلَكِنْ إِلَهُ أَبَائِي كَانَ وَمَازَالَ مَعِي. ");
INSERT INTO arbnav_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","أَنْتُمَا تَعْلَمَانِ أَنَّنِي خَدَمْتُ أَبَاكُمَا بِكُلِّ قُوَايَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","أَمَّا أَبُوكُمَا فَقَدْ غَدَرَ بِي وَغَيَّرَ أُجْرَتِي عَشْرَ مَرَّاتٍ. لَكِنَّ اللهَ لَمْ يَسْمَحْ لَهُ بِأَنْ يُسِيءَ إِلَيَّ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","فَإِنْ قَالَ: لِتَكُنِ الْغَنَمُ الرُّقْطُ أُجْرَتَكَ، وَلَدَتْ كُلُّ الْغَنَمِ رُقْطاً. وَإِنْ قَالَ: لِتَكُنِ الْغَنَمُ الْمُخَطَّطَةُ أُجْرَتَكَ، وَلَدَتْ كُلُّ الْغَنَمِ مُخَطَّطَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","لَقَدْ سَلَبَ اللهُ مَوَاشِي أَبِيكُمَا وَأَعْطَانِي إِيَّاهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","وَرَأَيْتُ فِي مَوْسِمِ تَلاقُحِ الْغَنَمِ حُلْماً: أَنَّ جَمِيعَ الْفُحُولِ الصَّاعِدَةِ عَلَى الْغَنَمِ مُخَطَّطَةٌ وَرَقْطَاءُ وَمُنَمَّرَةٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","وَقَالَ لِي مَلاكُ اللهِ فِي الْحُلْمِ: يَا يَعْقُوبُ، ");
INSERT INTO arbnav_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","تَطَلَّعْ حَوْلَكَ وَانْظُرْ، فَتَرَى أَنَّ جَمِيعَ الْفُحُولِ الصَّاعِدَةِ عَلَى الْغَنَمِ هِيَ مُخَطَّطَةٌ وَرَقْطَاءُ وَمُنَمَّرَةٌ. فَإِنِّي رَأَيْتُ مَا يَصْنَعُهُ بِكَ لابَانُ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","أَنَا إِلَهُ بَيْتِ إِيلَ، حَيْثُ مَسَحْتَ عَمُوداً، وَحَيْثُ نَذَرْتَ لِي نَذْراً. الآنَ قُمْ وَامْضِ مِنْ هَذِهِ الأَرْضِ وَارْجِعْ إِلَى أَرْضِ مَوْلِدِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","فَقَالَتْ رَاحِيلُ وَلَيْئَةُ: «هَلْ بَقِيَ لَنَا نَصِيبٌ وَمِيرَاثٌ فِي بَيْتِ أَبِينَا؟ ");
INSERT INTO arbnav_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","أَلَمْ يُعَامِلْنَا كَأَجْنَبِيَّتَيْنِ لأَنَّهُ بَاعَنَا وَأَكَلَ ثَمَنَنَا أَيْضاً؟ ");
INSERT INTO arbnav_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","إِنَّ كُلَّ الثَّرْوَةِ الَّتِي سَلَبَهَا اللهُ مِنْ أَبِينَا هِيَ لَنَا وَلأَوْلادِنَا، وَالآنَ افْعَلْ كُلَّ مَا قَالَهُ اللهُ لَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","فَقَامَ يَعْقُوبُ وَحَمَلَ أَوْلادَهُ وَنِسَاءَهُ عَلَى الْجِمَالِ، ");
INSERT INTO arbnav_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","وَسَاقَ كُلَّ مَاشِيَتِهِ أَمَامَهُ وَجَمِيعَ مُقْتَنَيَاتِهِ الَّتِي اقْتَنَاهَا فِي سَهْلِ أَرَامَ وَاتَّجَهَ إِلَى إِسْحاقَ أَبِيهِ فِي أَرْضِ كَنْعَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","وَكَانَ لابَانُ قَدْ مَضَى لِيَجُزَّ غَنَمَهُ، فَسَرَقَتْ رَاحِيلُ أَصْنَامَ أَبِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","وَكَذَلِكَ خَدَعَ يَعْقُوبُ لابَانَ الأَرَامِيَّ فَلَمْ يُخْبِرْهُ بِقَرَارِهِ ");
INSERT INTO arbnav_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","فَهَرَبَ هُوَ وَكُلُّ مَا مَعَهُ، وَانْطَلَقَ عَابِراً النَّهْرَ مُتَوَجِّهاً نَحْوَ جَبَلِ جِلْعَادَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","فَأُخْبِرَ لابَانُ فِي الْيَوْمِ الثَّالِثِ أَنَّ يَعْقُوبَ قَدْ هَرَبَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","فَصَحِبَ إِخْوَتَهُ مَعَهُ وَتَعَقَّبَهُ مَسِيرَةَ سَبْعَةِ أَيَّامٍ حَتَّى أَدْرَكَهُ فِي جَبَلِ جِلْعَادَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","فَتَجَلَّى اللهُ لِلابَانَ الأَرَامِيِّ فِي حُلْمٍ لَيْلاً وَقَالَ لَهُ: «إِيَّاكَ أَنْ تُخَاطِبَ يَعْقُوبَ بِخَيْرٍ أَوْ بِشَرٍّ». ");
INSERT INTO arbnav_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","وَحِينَ أَدْرَكَ لابَانُ يَعْقُوبَ كَانَ يَعْقُوبُ قَدْ ضَرَبَ خَيْمَتَهُ فِي الْجَبَلِ، فَخَيَّمَ لابَانُ وَإخْوَتُهُ فِي جَبَلِ جِلْعَادَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","وَقَالَ لابَانُ لِيَعْقُوبَ: «مَاذَا دَهَاكَ حَتَّى إِنَّكَ خَدَعْتَنِي وَسُقْتَ ابْنَتَيَّ كَسَبَايَا السَّيْفِ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","لِمَاذَا هَرَبْتَ خِفْيَةً وَخَدَعْتَنِي؟ لِمَاذَا لَمْ تُخْبِرْنِي فَكُنْتُ أُشَيِّعُكَ بِفَرَحٍ وَغِنَاءٍ وَدُفٍّ وَعُودٍ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","وَلَمْ تَدَعْنِي أُقَبِّلُ أَحْفَادِي وَابْنَتَيَّ؟ إِنَّكَ بِغَبَاوَةٍ تَصَرَّفْتَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","إنَّ فِي مَقْدُورِي أَنْ أُؤْذِيَكَ، وَلِكِنَّ إِلَهَ أَبِيكَ أَمَرَنِي لَيْلَةَ أَمْسٍ قَائِلاً: إِيَّاكَ أَنْ تُخَاطِبَ يَعْقُوبَ بِخَيْرٍ أَوْ بِشَرٍّ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","وَالآنَ أَنْتَ تَمْضِي لأَنَّكَ اشْتَقْتَ إِلَى بَيْتِ أَبِيكَ، وَلَكِنْ لِمَاذَا سَرَقْتَ آلِهَتِي؟». ");
INSERT INTO arbnav_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","فَأَجَابَ يَعْقُوبُ: «لأَنَّنِي خِفْتُ أَنْ تَغْتَصِبَ ابْنَتَيْكَ مِنِّي. ");
INSERT INTO arbnav_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","وَالآنَ، مَنْ تَجِدُ آلِهَتَكَ مَعَهُ فَالْمَوْتُ عِقَابُهُ. فَتِّشْ أَمَامَ إِخْوَتِنَا كُلَّ مَا مَعِي. إِنْ وَجَدْتَ لَكَ شَيْئاً فَخُذْهُ». وَلَمْ يَكُنْ يَعْقُوبُ يَعْلَمُ أَنَّ رَاحِيلَ قَدْ سَرَقَتِ الآلِهَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","فَدَخَلَ لابَانُ خَيْمَةَ كُلٍّ مِنْ يَعْقُوبَ وَلَيْئَةَ وَالْجَارِيَتَيْنِ فَلَمْ يَجِدْ شَيْئاً. ثُمَّ خَرَجَ مِنْ خِبَاءِ لَيْئَةَ وَدَخَلَ إِلَى خَيْمَةِ رَاحِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","وَكَانَتْ رَاحِيلُ قَدْ أَخَذَتِ الأَصْنَامَ وَأَخْفَتْهَا فِي رَحْلِ الْجَمَلِ وَجَلَسَتْ عَلَيْهَا، فَبَحَثَ فِي كُلِّ الْخَيْمَةِ دُونَ أَنْ يَعْثُرَ عَلَى شَيْءٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","وَقَالَتْ لأَبِيهَا «لا يُسِئْكَ يَا سَيِّدِي عَدَمُ اسْتِطَاعَتِي الْوُقُوفَ أَمَامَكَ لأَنَّ عَادَةَ النِّسَاءِ قَدْ عَرَضَتْ لِي». وَعِنْدَمَا بَحَثَ لابَانُ وَلَمْ يَجِدْ شَيْئاً ");
INSERT INTO arbnav_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","اغْتَاظَ يَعْقُوبُ وَخَاصَمَ لابَانَ قَائِلاً: «مَا هُوَ ذَنْبِي وَمَا هِيَ خَطِيئَتِي حَتَّى تَعَقَّبْتَنِي بِغَيْظٍ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","وَهَا أَنْتَ قَدْ فَتَّشْتَ جَمِيعَ أَثَاثِ بَيْتِي، فَمَاذَا وَجَدْتَ مِنْ جَمِيعِ أَثَاثِ بَيْتِكَ؟ اعْرِضْهُ هُنَا أَمَامَ أَقْرِبَائِنَا فَيَحْكُمُوا بَيْنَنَا كِلَيْنَا. ");
INSERT INTO arbnav_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","لَقَدْ مَكَثْتُ مَعَكَ عِشْرِينَ سَنَةً، فَمَا أَسْقَطَتْ نِعَاجُكَ وَعِنَازُكَ، وَلَمْ آكُلْ مِنْ كِبَاشِ غَنَمِكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","أَشْلاءَ فَرِيسَةٍ لَمْ أُحْضِرْ لَكَ بَلْ كُنْتُ أَتَحَمَّلُ خَسَارَتَهَا، وَمِنْ يَدِي كُنْتَ تَطْلُبُهَا، سَوَاءٌ كَانَتْ مَخْطُوفَةً فِي النَّهَارِ أَمْ فِي اللَّيْلِ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","كُنْتُ فِي النَّهَارِ يَأْكُلُنِي الْحَرُّ وَفِي اللَّيْلِ الْجَلِيدُ، وَفَارَقَ نَوْمِي عَيْنَيَّ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","لَقَدْ صَارَ لِي عِشْرُونَ سَنَةً فِي بَيْتِكَ. أَرْبَعَ عَشْرَةَ سَنَةً مِنْهَا خَدَمْتُكَ لِقَاءَ زَوَاجِي بِابْنَتَيْكَ، وَسِتَّ سَنَوَاتٍ مُقَابِلَ غَنَمِكَ، وَقَدْ غَيَّرْتَ أُجْرَتِي عَشْرَ مَرَّاتٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","وَلَوْلا أَنَّ إِلَهَ أَبِي، إِلَهَ إِبْرَاهِيمَ وَهَيْبَةَ إِسْحاقَ كَانَا مَعِي لَكُنْتَ الآنَ قَدْ صَرَفْتَنِي فَارِغاً. لَكِنِ الرَّبُّ قَدْ رَأَى مَذَلَّتِي وَتَعَبَ يَدَيَّ فَوَبَّخَكَ لَيْلَةَ أَمْسِ». ");
INSERT INTO arbnav_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","فَأَجَابَ لابَانُ: «الْبَنَاتُ بَنَاتِي، وَالأَبْنَاءُ أَبْنَائِي وَالْغَنَمُ غَنَمِي، وَكُلُّ مَا تَرَاهُ هُوَ لِي. وَلَكِنْ مَاذَا أَفْعَلُ بِبَنَاتِي وَأَوْلادِهِنَّ الآنَ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","فَلْنَقْطَعْ عَهْداً بَيْنَنَا الْيَوْمَ، فَيَكُونَ شَاهِداً بَيْنِي وَبَيْنَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","فَأَخَذَ يَعْقُوبُ حَجَراً وَنَصَبَهُ عَمُوداً، ");
INSERT INTO arbnav_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","وَقَالَ لأَقْرِبَائِهِ: «اجْمَعُوا حِجَارَةً». فَأَخَذُوا الْحِجَارَةَ وَجَعَلُوهَا رُجْمَةً وَأَكَلُوا هُنَاكَ فَوْقَهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","وَدَعَاهَا لابَانُ «يَجَرْ سَهْدُوثَا» (وَمَعْنَاهَا: رُجْمَةُ الشَّهَادَةِ بِلُغَةِ لابَانَ) وَأَمَّا يَعْقُوبُ فَدَعَاهَا «جَلْعِيدَ» (وَمَعْنَاهَا: رُجْمَةُ الشَّهَادَةِ بِلُغَةِ يَعْقُوبَ). ");
INSERT INTO arbnav_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","وَقَالَ لابَانُ: «هَذِهِ الرُّجْمَةُ شَاهِدَةٌ الْيَوْمَ بَيْنِي وَبَيْنَكَ». لِذَلِكَ دُعِيَ اسْمُهَا جَلْعِيدَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","وَكَذَلِكَ دُعِيَتْ بِالْمِصْفَاةِ أَيْضاً لأَنَّهُ قَالَ: «لِيَكُنِ الرَّبُّ رَقِيباً بَيْنِي وَبَيْنَكَ حِينَ يَغِيبُ كُلٌّ مِنَّا عَنِ الآخَرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","إِنْ أَسَأْتَ مُعَامَلَةَ ابْنَتَيَّ، أَوْ تَزَوَّجْتَ عَلَيْهِمَا، فَإِنَّ اللهَ يَرَاكَ وَيَكُونُ حَاكِماً بَيْنِي وَبَيْنَكَ حَتَّى لَوْ لَمْ أَعْرِفْ أَنَا». ");
INSERT INTO arbnav_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","وَأَضَافَ: «لِتَكُنِ الرُّجْمَةُ، وَهَذَا الْعَمُودُ الَّذِي أَقَمْتُهُ بَيْنِي وَبَيْنَكَ ");
INSERT INTO arbnav_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","شَاهِدَيْنِ أَنْ لَا أَتَجَاوَزَ هَذِهِ الرُّجْمَةَ لإِيقَاعِ الأَذَى بِكَ، أَوْ تَتَجَاوَزَ أَنْتَ الرُّجْمَةَ وَهَذَا الْعَمُودَ لإِلْحَاقِ الضَّرَرِ بِي. ");
INSERT INTO arbnav_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","وَلْيَكُنْ إِلَهُ إِبْرَاهِيمَ وَإِلَهُ نَاحُورَ وَإِلَهُ أَبِيهِمَا حَاكِماً بَيْنَنَا». فَحَلَفَ يَعْقُوبُ بِهَيْبَةِ أَبِيهِ إِسْحاقَ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ثُمَّ قَدَّمَ يَعْقُوبُ قُرْبَاناً فِي الْجَبَلِ وَدَعَا أَقْرِبَاءَهُ لِيَأْكُلُوا طَعَاماً، فَأَكَلُوا وَقَضَوْا لَيْلَتَهُمْ فِي الْجَبَلِ. ");
INSERT INTO arbnav_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","وَفِي الصَّبَاحِ الْمُبَكِّرِ نَهَضَ لابَانُ وَقَبَّلَ أَحْفَادَهُ وَابْنَتَيْهِ وَبَارَكَهُمْ، ثُمَّ انْصَرَفَ رَاجِعاً، إِلَى مَحَلِّ إِقَامَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","وَلَمَّا مَضَى يَعْقُوبُ فِي سَبِيلِهِ لاقَتْهُ مَلائِكَةُ اللهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","فَقَالَ يَعْقُوبُ: «هَذَا جُنْدُ اللهِ». فَدَعَا اسْمَ ذَلِكَ الْمكَانِ مَحَنَايِمَ. (وَمَعْنَاهُ: الْمُعَسْكَرَانِ). ");
INSERT INTO arbnav_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","وَبَعَثَ يَعْقُوبُ قُدَّامَهُ رُسُلاً إِلَى أَخِيهِ عِيسُو فِي أَرْضِ سَعِيرَ بِلادِ أَدُومَ. ");
INSERT INTO arbnav_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","وَأَوْصَاهُمْ قَائِلاً: «هَذَا مَا تَقُولُونَهُ لِسَيِّدِي عِيسُو: هَكَذَا يَقُولُ عَبْدُكَ يَعْقُوبُ: لَقَدْ تَغَرَّبْتُ عِنْدَ لابَانَ وَمَكَثْتُ هُنَاكَ إِلَى الآنَ، ");
INSERT INTO arbnav_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","وَاقْتَنَيْتُ بَقَراً وَحَمِيراً وَغَنَماً وَعَبِيداً وَإِمَاءً وَأَرْسَلْتُ لأُعْلِمَ سَيِّدِي لَعَلَّنِي أَحْظَى بِرِضَاكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","فَرَجَعَ الرُّسُلُ إِلَى يَعْقُوبَ قَائِلِينَ: «لَقَدْ قَدِمْنَا عَلَى أَخِيكَ عِيسُو وَهَا هُوَ مُقْبِلٌ إِلَيْكَ، وَمَعَهُ أَرْبَعُ مِئَةِ رَجُلٍ». ");
INSERT INTO arbnav_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","فَاعْتَرَى يَعْقُوبَ خَوْفٌ وَكَرَبٌ عَظِيمَانِ وَقَسَّمَ الْقَوْمَ الَّذِينَ مَعَهُ وَالْغَنَمَ وَالْبَقَرَ وَالْجِمَالَ إِلَى جَمَاعَتَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","وَقَالَ: «إِنْ صَادَفَ عِيسُو إِحْدَى الْجَمَاعَتَيْنِ وَأَهْلَكَهَا، تَنْجُ الْجَمَاعَةُ الْبَاقِيَةُ». ");
INSERT INTO arbnav_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","وَصَلَّى يَعْقُوبُ: «يَا إِلَهَ أَبِي إِبْرَاهِيمَ وَإِلَهَ أَبِي إِسْحاقَ، أَيُّهَا الرَّبُّ الَّذِي قَالَ لِي: ارْجِعْ إِلَى أَرْضِكَ وَإِلَى قَوْمِكَ فَأُحْسِنَ إِلَيْكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","أَنَا لَا أَسْتَحِقُّ جَمِيعَ إِحْسَانَاتِكَ وَأَمَانَتَكَ الَّتيِ أَبْدَيْتَهَا نَحْوَ عَبْدِكَ، فَقَدْ عَبَرْتُ الأُرْدُنَّ وَلَيْسَ مَعِي سِوَى عَصَايَ، وَهَا أَنَا أَعُودُ وَقَدْ أَصْبَحْتُ جَيْشَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","نَجِّنِي مِنْ يَدِ أَخِي عِيسُو لأَنِّي خَائِفٌ أَنْ يَقْدِمَ عَلَيَّ فَيُهْلِكَنِي وَيُهْلِكَ مَعِي الأُمَّهَاتِ وَالْبَنِينَ. ");
INSERT INTO arbnav_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","وَأَنْتَ قُلْتَ: إِنِّي أُحْسِنُ إِلَيْكَ وَأَجْعَلُ ذُرِّيَّتَكَ كَرَمْلِ الْبَحْرِ فَلا تُحْصَى لِكَثْرَتِهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","وَبَاتَ هُنَاكَ تِلْكَ اللَّيْلَةَ، وَانْتَقَى مِمَّا لَدَيْهِ هَدِيَّةً لأَخِيهِ عِيسُو. ");
INSERT INTO arbnav_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","فَكَانَتْ مِئَتَيْ عَنْزٍ وَعِشْرِينَ تَيْساً وَمِئَتَيْ نَعْجَةٍ وَعِشْرِينَ كَبْشاً، ");
INSERT INTO arbnav_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","وَثَلاثِينَ نَاقَةً مُرْضِعَةً مَعَ أَوْلادِهَا، وَأَرْبَعِينَ بَقَرَةً وَعَشَرَةَ ثِيرَانٍ وَعِشْرِينَ أَتَاناً وَعَشَرَةَ حَمِيرٍ، ");
INSERT INTO arbnav_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","وَعَهِدَ بِها إِلَى أَيْدِي عَبِيدِهِ، كُلِّ قَطِيعٍ عَلَى حِدَةٍ. وَقَالَ لِعَبِيدِهِ: «تَقَدَّمُونِي، وَاجْعَلُوا بَيْنَ كُلِّ قَطِيعٍ وَقَطِيعٍ مَسَافَةً». ");
INSERT INTO arbnav_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","وَأَوْصَى طَلِيعَتَهُمْ قَائِلاً: «إِذَا لَقِيتَ أَخِي عِيسُو وَسَأَلَكَ: لِمَنْ أَنْتَ؟ وَإِلَى أَيْنَ تَذْهَبُ؟ وَمَنْ هُوَ صَاحِبُ الْقَطِيعِ الَّذِي أَمَامَكَ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","أَنَّكَ تُجِيبُ: هِيَ لِعَبْدِكَ يَعْقُوبَ، هَدِيَّةٌ بَعَثَ بِها لِسَيِّدِي عِيسُو. وَهَا هُوَ قَادِمٌ خَلْفَنَا». ");
INSERT INTO arbnav_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","وَأَوْصَى أَيْضاً بَقِيَّةَ السَّائِرِينَ وَرَاءَ الْقُطْعَانِ بِمِثْلِ هَذَا الْكَلامِ وَأَضَافَ: ");
INSERT INTO arbnav_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","«تَقُولُونَ أَيْضاً: هُوَذَا عَبْدُكَ يَعْقُوبُ قَادِمٌ وَرَاءَنَا». وَكَانَ يَعْقُوبُ يَقُولُ فِي نَفْسِهِ: «أَسْتَعْطِفُهُ بِالْهَدَايَا الَّتِي تَتَقَدَّمُنِي، ثُمَّ بَعْدَ ذَلِكَ أُشَاهِدُ وَجْهَهُ لَعَلَّهُ يَرْضَى عَنِّي». ");
INSERT INTO arbnav_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","وَهَكَذَا تَقَدَّمَتْهُ هَدَايَاهُ. أَمَّا هُوَ فَقَضَى لَيْلَتَهُ فِي الْمُخَيَّمِ. ");
INSERT INTO arbnav_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ثُمَّ قَامَ فِي تِلْكَ اللَّيْلَةِ وَصَحِبَ مَعَهُ زَوْجَتَيْهِ وَجَارِيَتَيْهِ وَأَوْلادَهُ الأَحَدَ عَشَرَ، وَعَبَرَ بِهِمْ مَخَاضَةَ يَبُّوقَ، ");
INSERT INTO arbnav_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","وَلَمَّا أَجَازَهُمْ وَكُلَّ مَالَهُ عَبْرَ الْوَادِي، ");
INSERT INTO arbnav_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","وَبَقِيَ وَحْدَهُ، صَارَعَهُ إِنْسَانٌ حَتَّى مَطْلَعِ الْفَجْرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","وَعِنْدَمَا رَأَى أَنَّهُ لَمْ يَتَغَلَّبْ عَلَى يَعْقُوبَ، ضَرَبَهُ عَلَى حُقِّ فَخْذِهِ، فَانْخَلَعَ مَفْصِلُ فَخْذِ يَعْقُوبَ فِي مُصَارَعَتِهِ مَعَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","وَقَالَ لَهُ: «أَطْلِقْنِي، فَقَدْ طَلَعَ الْفَجْرُ». فَأَجَابَهُ يَعْقُوبُ: «لا أُطْلِقُكَ حَتَّى تُبَارِكَنِي». ");
INSERT INTO arbnav_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","فَسَأَلَهُ: «مَا اسْمُكَ؟» فَأَجَابَ: «يَعْقُوبُ». ");
INSERT INTO arbnav_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","فَقَالَ: «لا يُدْعَى اسْمُكَ فِيمَا بَعْدُ يَعْقُوبَ، بَلْ إِسْرَائِيلَ (وَمَعْنَاهُ: يُجَاهِدُ مَعَ اللهِ)، لأَنَّكَ جَاهَدْتَ مَعَ اللهِ وَالنَّاسِ وَقَدَرْتَ». ");
INSERT INTO arbnav_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","فَسَأَلَهُ يَعْقُوبُ: «أَخْبِرْنِي مَا اسْمُكَ؟» فَقَالَ: «لِمَاذَا تَسْأَلُ عَنِ اسْمِي؟» وَبَارَكَهُ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","وَدَعَا يَعْقُوبُ اسْمَ الْمَكَانِ فَنِيئِيلَ (وَمَعْنَاهُ: وَجْهُ اللهِ) إِذْ قَالَ: «لأَنِّي شَاهَدْتُ اللهَ وَجْهاً لِوَجْهٍ وَبَقِيتُ حَيًّا». ");
INSERT INTO arbnav_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","وَمَا إِنْ عَبَرَ فَنِيئِيلَ حَتَّى أَشْرَقَتْ عَلَيْهِ الشَّمْسُ فَسَارَ وَهُوَ عَارِجٌ مِنْ فَخْذِهِ ");
INSERT INTO arbnav_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","لِذَلِكَ يَمْتَنِعُ بَنُو إِسْرَائِيلَ عَنْ أَكْلِ عِرْقِ النَّسَا الَّذِي عَلَى حُقِّ الْفَخْذِ إِلَى هَذَا الْيَوْمِ، لأَنَّ الرَّجُلَ ضَرَبَ حُقَّ فَخْذِ يَعْقُوبَ عَلَى عِرْقِ النَّسَا. ");
INSERT INTO arbnav_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","وَتَطَلَّعَ يَعْقُوبُ مِنْ بَعِيدٍ، فَرَأَى عِيسُو مُقْبِلاً وَمَعَهُ أَرْبَعُ مِئَةِ رَجُلٍ، فَفَرَّق أَوْلادَهُ عَلَى لَيْئَةَ وَرَاحِيلَ وَالْجَارِيَتَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","فَجَعَلَ الْجَارِيَتَيْنِ وَأَوْلادَهُمَا فِي الطَّلِيعَةِ، ثُمَّ لَيْئَةَ وَأَوْلادَهَا، وَأَخِيراً رَاحِيلَ وَيُوسُفَ. ");
INSERT INTO arbnav_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","وَتَقَدَّمَهُمْ، وَسَجَدَ إِلَى الأَرْضِ سَبْعَ مَرَّاتٍ حَتَّى اقْتَرَبَ مِنْ أَخِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","فَأَسْرَعَ عِيسُو لِمُلاقَاتِهِ وَعَانَقَهُ وَقَبَّلَهُ، وَبَكَيَا. ");
INSERT INTO arbnav_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","وَتَلَفَّتَ عِيسُو حَوْلَهُ فَشَاهَدَ النِّسَاءَ وَالأَوْلادَ فَقَالَ: «مَنْ هَؤُلاءِ الَّذِينَ مَعَكَ؟» فَأَجَابَ: «هُمُ الأَوْلادُ الَّذِينَ أَنْعَمَ اللهُ بِهِمْ عَلَى عَبْدِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ثُمَّ دَنَتِ الْجَارِيَتَانِ مَعَ أَوْلادِهِمَا وَانْحَنَوْا أَمَامَ عِيسُو. ");
INSERT INTO arbnav_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","وَبَعْدَهُمْ اقْتَرَبَتْ لَيْئَةُ وَأَوْلادُهَا وَانْحَنَوْا أَيْضاً، وَأَخِيراً تَقَدَّمَتْ رَاحِيلُ وَيُوسُفُ وَانْحَنَيَا أَمَامَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","وَسَأَلَ عِيسُو: «مَا هُوَ قَصْدُكَ مِنْ كُلِّ هَذِهِ الْقُطْعَانِ الَّتِي صَادَفْتُهَا؟». فَأَجَابَ يَعْقُوبُ: «هِيَ لِكَيْ أَحْظَى بِرِضَى سَيِّدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","فَقَالَ عِيسُو: «إِنَّ لَدَيَّ كَثِيراً يَا أَخِي. فَاحْتَفِظْ لِنَفْسِكَ بِمَا لَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","فَقَالَ يَعْقُوبُ: «لا، إِنْ كُنْتُ قَدْ حَظِيتُ بِرِضَاكَ، فَأَرْجُو مِنْكَ أَنْ تَقْبَلَ مِنِّي هَدِيَّتِي لأَنِّي رَأَيْتُ وَجْهَكَ كَمَا يُرَى وَجْهُ اللهِ، فَرَضِيتَ عَنِّي. ");
INSERT INTO arbnav_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","فَأَطْلُبُ إِلَيْكَ أَنْ تَقْبَلَ بَرَكَتِي الَّتِي حَمَلْتُهَا إِلَيْكَ، فَإِنَّ اللهَ قَدْ أَغْدَقَ عَلَيَّ، وَلَدَيَّ مِنْ كُلِّ شَيْءٍ». وَأَلَحَّ عَلَيْهِ حَتَّى قَبِلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","وَقَالَ عِيسُو: «لِنَرْتَحِلْ فَأَسِيرَ أَمَامَكَ وَتَتْبَعَنِي». ");
INSERT INTO arbnav_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","فَأَجَابَهُ يَعْقُوبُ: «يَا سَيِّدِي أَنْتَ تَعْلَمُ أَنَّ الأَوْلادَ مَا بَرِحُوا أَطْرِيَاءَ الْعُودِ، وَغَنَمِي وَبَقَرِي مُرْضِعَةٌ، فَإِنْ أَجْهَدْتُهَا يَوْماً وَاحِداً فَإِنَّ كُلَّ الْغَنَمِ تَمُوتُ. ");
INSERT INTO arbnav_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","فَلْيَتَقَدَّمْ مَوْلايَ عَبْدَهُ، وَأَنَا أَسِيرُ مُتَمَهِّلاً فِي إِثْرِ الْمَاشِيَةِ الَّتِي أَمَامِي، وَفِي إِثْرِ الأَوْلادِ أَيْضاً، إِلَى أَنْ أُقْبِلَ عَلَى سَيِّدِي فِي سَعِيرَ». ");
INSERT INTO arbnav_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","فَقَالَ لَهُ عِيسُو: «إِذاً أَتْرُكُ مَعَكَ بَعْضَ الْقَوْمِ الَّذِينَ مَعِي». فَأَجَابَهُ: «وَأَيُّ حَاجَةٍ لِذَلِكَ؟ إِنَّ كُلَّ مَا أَطْلُبُهُ هُوَ أَنْ أَحْظَى بِرِضَى سَيِّدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","فَمَضَى عِيسُو فِي طَرِيقِهِ فِي ذَلِكَ الْيَوْمِ رَاجِعاً إِلَى سَعِيرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","أَمَّا يَعْقُوبُ فَارْتَحَلَ إِلَى سُكُّوتَ، وَبَنَى لِنَفْسِهِ بَيْتاً وَصَنَعَ لِمَوَاشِيهِ مِظَلاتٍ. لِذَلِكَ دُعِيَ ذَلِكَ الْمَكَانُ بِاسْمِ سُكُّوتَ (وَمَعْنَاهُ: الْمِظَلاتُ). ");
INSERT INTO arbnav_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ثُمَّ وَصَلَ يَعْقُوبُ سَالِماً مَدِينَةَ شَكِيمَ (وَهِيَ نَابُلْسُ) الَّتِي فِي أَرْضِ كَنْعَانَ، عَلَى طَرِيقِهِ الْمُؤَدِّيَةِ إِلَى سَهْلِ أَرَامَ، وَنَصَبَ خِيَامَهُ مُقَابِلَ الْمَدِينَةِ، ");
INSERT INTO arbnav_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","وَاشْتَرَى الأَرْضَ الَّتِي نَصَبَ عَلَيْهَا خَيْمَتَهُ، مِنْ أَبْنَاءِ حَمُورَ أَبِي شَكِيمَ بِمِئَةِ قِطْعَةٍ مِنَ الْفِضَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","وَشَيَّدَ هُنَاكَ مَذْبَحاً دَعَاهُ إِيلَ (وَمَعْنَاهُ إِلَهُ إِسْرَائِيلَ). ");
INSERT INTO arbnav_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","وَخَرَجَتْ دِينَةُ ابْنَةُ لَيْئَةَ الَّتِي أَنْجَبَتْهَا لِيَعْقُوبَ لِتَتَعَرَّفَ عَلَى بَنَاتِ الْمِنْطَقَةِ الْمُحِيطَةِ، ");
INSERT INTO arbnav_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","فَرَآهَا شَكِيمُ بنُ حَمُورَ الْحِوِّيِّ، رَئِيسِ الْمِنْطَقَةِ، فَأَخَذَهَا وَاغْتَصَبَهَا وَلَوَّثَ شَرَفَهَا، ");
INSERT INTO arbnav_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","وَأُغْرِمَ قَلْبُهُ بِدِينَةَ وَلاطَفَهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","وَقَالَ شَكِيمُ لِحَمُورَ أَبِيهِ: «خُذْ لِي هَذِهِ الْفَتَاةَ زَوْجَةً». ");
INSERT INTO arbnav_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","وَسَمِعَ يَعْقُوبُ أَنَّهُ قَدْ لَوَّثَ شَرَفَ ابْنَتِهِ دِينَةَ. وَكَانَ بَنُوهُ آنَئِذٍ يَرْعَوْنَ مَوَاشِيَهِ فِي الْحَقْلِ، فَسَكَتَ حَتَّى رَجَعُوا. ");
INSERT INTO arbnav_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","وَوَفَدَ حَمُورُ وَالِدُ شَكِيمَ عَلَى يَعْقُوبَ لِيُخَاطِبَهُ بِشَأْنِ دِينَةَ ");
INSERT INTO arbnav_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","وَأَتَى بَنُو يَعْقُوبَ مِنَ الْحَقْلِ عِنْدَمَا سَمِعُوا بِالأَمْرِ، وَقَدِ اسْتَشَاطُوا غَضَباً وَغَيْظاً لأَنَّ شَكِيمَ قَدِ ارْتَكَبَ فَاحِشَةً فِي إِسْرَائِيلَ بِمُضَاجَعَةِ ابْنَةِ يَعْقُوبَ، وَهُوَ أَمْرٌ مَحْظُورٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","وَقَالَ حَمُورُ: «لَقَدْ تَعَلَّقَتْ نَفْسُ ابْنِي شَكِيمَ بِابْنَتِكُمْ، فَأَطْلُبُ إِلَيْكُمْ أَنْ تُزَوِّجُوهُ مِنْهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","صَاهِرُونَا، وَزَوِّجُونَا بَنَاتِكُمْ، وَتَزَوَّجُوا مِنْ بَنَاتِنَا، ");
INSERT INTO arbnav_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","وَاسْكُنُوا مَعَنَا، فَهَا هِيَ الأَرْضُ أَمَامَكُمْ. أَقِيمُوا بِها وَاتَّجِرُوا وَتَمَلَّكُوا فِيهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","وَقَالَ شَكِيمُ لأَبِيهَا وَإِخْوَتِهَا: «دَعُونِي أَحْظَى بِرِضَاكُمْ، وَكُلُّ مَا تَسْأَلُونَهُ أُعْطِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","أَغْلُوا عَلَيَّ الْمَهْرَ وَالْهَدِيَّةَ فَأَبْذُلَهُمَا كَمَا تَطْلُبُونَ، إِنَّمَا زَوِّجُونِي مِنَ الْفَتَاةِ». ");
INSERT INTO arbnav_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","وَأَجَابَ أَبْنَاءُ يَعْقُوبَ شَكِيمَ وَأَبَاهُ حَمُورَ بِدَهَاءٍ، لأَنَّهُ كَانَ قَدْ لَوَّثَ شَرَفَ أُخْتِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","وَقَالُوا لَهُمَا: «لا يُمْكِنُ أَنْ يَحْدُثَ هَذَا الأَمْرُ فَنُعْطِيَ أُخْتَنَا لأَغْلَفَ، لأَنَّ هَذَا عَارٌ عَلَيْنَا. ");
INSERT INTO arbnav_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","غَيْرَ أَنَّنَا نُوَافِقُ عَلَى طَلَبِكُمْ إِنْ صِرْتُمْ مِثْلَنَا، وَاخْتَتَنَ كُلُّ ذَكَرٍ مِنْكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","عِنْدَئِذٍ نُزَوِّجُكُمْ بَنَاتِنَا، وَنَتَزَوَّجُ مِنْ بَنَاتِكُمْ، فَنُقِيمُ بَيْنَكُمْ وَنُصْبِحُ شَعْباً وَاحِداً، ");
INSERT INTO arbnav_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","وَإِنْ لَمْ تَسْمَعُوا لَنَا وَتَخْتَتِنُوا، نَأْخُذُ ابْنَتَنَا وَنَمْضِي». ");
INSERT INTO arbnav_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","فَاسْتَحْسَنَ حَمُورُ وَوَلَدُهُ شَكِيمُ كَلامَهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","وَلَمْ يَتَوَانَ الشَّابُ عَنْ تَنْفِيذِ الأَمْرِ، لأَنَّهُ كَانَ مُغْرَماً بِابْنَةِ يَعْقُوبَ، وَكَانَ أَكْرَمَ جَمِيعِ بَيْتِ أَبِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","فَجَاءَ حَمُورُ وَشَكِيمُ ابْنُهُ إِلَى مَجْلِسِ الْمَدِينَةِ وَقَالا لِرِجَالِهَا: ");
INSERT INTO arbnav_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«إِنَّ هَؤُلاءِ الْقَوْمَ مُسَالِمُونَ لَنَا، فَلْنَدَعْهُمْ يُقِيمُونَ فِي الأَرْضِ وَيَتَّجِرُونَ فِيهَا، فَالأَرْضُ رَحْبَةٌ أَمَامَهُمْ، وَلْنَتَزَوَّجْ بَنَاتِهِمْ وَهُمْ يَتَزَوَّجُونَ بَنَاتِنَا. ");
INSERT INTO arbnav_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","وَقَدِ اشْتَرَطُوا لِلإِقَامَةِ بَيْنَنَا وَأَنْ نُصْبِحَ شَعْباً وَاحِداً، أَنْ يَخْتَتِنَ كُلُّ ذَكَرٍ كَمَا هُمْ ");
INSERT INTO arbnav_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","عِنْدَ ذَلِكَ تُصْبِحُ مَاشِيَتُهُمْ وَمُقْتَنَيَاتُهُمْ وَكُلُّ بَهَائِمِهِمْ مِلْكاً لَنَا. فَلْنُوَافِقْهُمْ عَلَى ذَلِكَ فَيُقِيمُوا مَعَنَا». ");
INSERT INTO arbnav_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","فَوَافَقَ جَمِيعُ الْحَاضِرِينَ فِي مَجْلِسِ الْمَدِينَةِ عَلَى كَلامِ حَمُورَ وَابْنِهِ شَكِيمَ، فَاخْتَتَنَ كُلُّ ذَكَرٍ فِي الْمَدِينَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","وَفِي الْيَوْمِ الثَّالِثِ، بَيْنَمَا هُمْ مَازَالُوا مُتَوَجِّعِينَ، تَقَلَّدَ شِمْعُونَ وَلاوِي ابْنَا يَعْقُوبَ وَأَخَوَيْ دِينَةَ، سَيْفَيهِمَا، وَدَخَلا الْمَدِينَةَ بِجَرَاءَةٍ وَقَتَلا كُلَّ الذُّكُورِ. ");
INSERT INTO arbnav_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","وَقَتَلا أَيْضاً حَمُورَ وَشَكِيمَ بِحَدِّ السَّيْفِ، وَأَنْقَذَا دِينَةَ مِنْ بَيْتِ شَكِيمَ وَخَرَجَا. ");
INSERT INTO arbnav_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ثُمَّ أَقْبَلَ بَنُو يَعْقُوبَ عَلَى الْقَتْلَى وَنَهَبُوا الْمَدِينَةَ لأَنَّهُمْ لَوَّثُوا شَرَفَ أُخْتِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","وَاسْتَوْلَوْا عَلَى غَنَمِهِمْ وَبَقَرِهِمْ وَحَمِيرِهِمْ وَعَلَى كُلِّ مَا فِي الْمَدِينَةِ وَفِي الْحَقْلِ، ");
INSERT INTO arbnav_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","وَسَبَوْا وَنَهَبُوا جَمِيعَ ثَرْوَتِهِمْ وَكُلَّ أَطْفَالِهِمْ وَنِسَائِهِمْ وَكُلَّ مَا فِي الْبُيُوتِ. ");
INSERT INTO arbnav_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","فَقَالَ يَعْقُوبُ لِشِمْعُونَ وَلاوِي: «لَقَدْ جَلَبْتُمَا عَلَيَّ الشَّقَاءَ وَكَرَاهِيَةَ الْكَنْعَانِيِّينَ وَالْفِرِزِّيِّينَ السَّاكِنِينَ فِي هَذِهِ الْبِلادِ. وَهَا أَنَا نَفَرٌ قَلِيلٌ، فَيَتَأَلَّبُونَ عَلَيَّ وَيَقْتُلُونَنِي، فَأَبِيدُ أَنَا وَبَيْتِي». ");
INSERT INTO arbnav_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","فَقَالا لَهُ: «أَمِثْلَ زَانِيَةٍ يُعَامِلُ أُخْتَنَا؟». ");
INSERT INTO arbnav_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ثُمَّ قَالَ اللهُ لِيَعْقُوبَ: «اصْعَدْ إِلَى بَيْتِ إِيلَ وَاسْكُنْ هُنَاكَ، وَشَيِّدْ مَذْبَحاً لِلهِ الَّذِي ظَهَرَ لَكَ عِنْدَمَا كُنْتَ هَارِباً مِنْ أَمَامِ أَخِيكَ عِيسُو». ");
INSERT INTO arbnav_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","فَأَمَرَ يَعْقُوبُ أَهْلَ بَيْتِهِ، وَكُلَّ مَنْ كَانَ مَعَهُ: «تَخَلَّصُوا مِنَ الآلِهَةِ الْغَرِيبَةِ الَّتِي بَيْنَكُمْ، وَتَطَهَّرُوا وَأَبْدِلُوا ثِيَابَكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ثُمَّ تَعَالَوْا لِنَذْهَبَ إِلَى بَيْتِ إِيلَ لأُشَيِّدَ هُنَاكَ مَذْبَحاً لِلهِ الَّذِي اسْتَجَابَ لِي فِي يَوْمِ ضِيقَتِي، وَرَافَقَنِي فِي الطَّرِيقِ الَّتِي سَلَكْتُهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","فَسَلَّمُوا يَعْقُوبَ كُلَّ الآلِهَةِ الْغَرِيبَةِ الَّتِي كَانَتْ لَدَيْهِمْ وَالأَقْرَاطَ الَّتِي فِي آذَانِهِمْ، فَطَمَرَ هَا يَعْقُوبُ تَحْتَ الْبُطْمَةِ الَّتِي فِي شَكِيمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ثُمَّ ارْتَحَلُوا، فَهَيْمَنَ رُعْبُ اللهِ عَلَى الْمُدُنِ الَّتِي حَوْلَهُمْ، فَلَمْ يَسْعَوْا وَرَاءَهُمْ ");
INSERT INTO arbnav_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","فَوَصَلَ يَعْقُوبُ وَجَمِيعُ الْقَوْمِ الَّذِينَ مَعَهُ إِلَى لُوزَ فِي أَرْضِ الْكَنْعَانِيِّينَ، وَهِيَ نَفْسُهَا بَيْتُ إِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","وَشَيَّدَ مَذْبَحاً هُنَاكَ، وَدَعَا الْمَكَانَ «بَيْتَ إِيلَ» لأَنَّ اللهَ تَجَلَّى لَهُ هُنَاكَ عِنْدَمَا كَانَ هَارِباً مِنْ أَمَامِ أَخِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","وَمَاتَتْ هُنَاكَ دَبُورَةُ مُرْضِعَةُ رِفْقَةَ، فَدُفِنَتْ فِي مُنْخَفَضِ بَيْتِ إِيلَ تَحْتَ شَجَرَةِ الْبَلُّوطِ، وَسَمُّوهَا «أَلُّونَ بَاكُوتَ» (وَمَعْنَاهَا: بَلُّوطَةُ الْبُكَاءِ). ");
INSERT INTO arbnav_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","وَظَهَرَ اللهُ لِيَعْقُوبَ مَرَّةً أُخْرَى بَعْدَ رُجُوعِهِ مِنْ سَهْلِ أَرَامَ وَبَارَكَهُ، ");
INSERT INTO arbnav_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","وَقَالَ لَهُ: «لَنْ يُدْعَى اسْمُكَ يَعْقُوبَ فِي مَا بَعْدُ، بَلْ إِسْرَائِيلَ» (وَمَعْنَاهُ: يُجَاهِدُ مَعَ اللهِ). وَهَكَذَا سَمَّاهُ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","وَقَالَ اللهُ لَهُ: «أَنَا هُوَ اللهُ الْقَدِيرُ. أَثْمِرْ وَاكْثُرْ، فَيَكُونَ مِنْكَ أُمَّةٌ وَطَوَائِفُ أُمَمٍ، وَمِنْ صُلْبِكَ يَخْرُجُ مُلُوكٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","وَالأَرْضُ الَّتِي وَهَبْتُهَا لإِبْرَاهِيمَ وَإِسْحاقَ أُعْطِيهَا لَكَ وَلِذُرِّيَّتِكَ مِنْ بَعْدِكَ أَيْضاً». ");
INSERT INTO arbnav_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ثُمَّ فَارَقَهُ اللهُ فِي الْمَكَانِ الَّذِي خَاطَبَهُ فِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","وَأَقَامَ يَعْقُوبُ عَمُوداً مِنْ حَجَرٍ فِي الْمَكَانِ الَّذِي تَكَلَّمَ فِيهِ مَعَهُ، وَسَكَبَ عَلَيْهِ سَكِيبَ قُرْبَانٍ وَصَبَّ عَلَيْهِ زَيْتاً أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","وَدَعَا اسْمَ الْمَكَانِ «بَيْتَ إِيلَ» (وَمَعْنَاهُ: بَيْتُ اللهِ) لأَنَّ اللهَ خَاطَبَهُ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ثُمَّ ارْتَحَلُوا مِنْ بَيْتِ إِيلَ. وَإِذْ كَانُوا بَعْدُ عَلَى مَسَافَةٍ مِنْ أَفْرَاتَةَ شَعَرَتْ رَاحِيلُ بِالْمَخَاضِ وَتَعَسَّرَتْ وِلادَتُهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","وَإِذْ كَانَتْ تُقَاسِي فِي وِلادَتِهَا قَالَتْ لَهَا الْقَابِلَةُ: «لا تَخَافِي، فَإِنَّ هَذَا أَيْضاً ابْنٌ آخَرُ لَكِ». ");
INSERT INTO arbnav_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","وَبَيْنَمَا كَانَتْ تَلْفِظُ أَنْفَاسَهَا عِنْدَ مَوْتِهَا دَعَتْهُ «بِنْ أُوْنِي» (وَمَعْنَاهُ: ابْنُ حُزْنِي) غَيْرَ أَنَّ أَبَاهُ دَعَاهُ «بِنْيَامِينَ» (وَمَعْنَاهُ: ابْنُ يَمِينِي). ");
INSERT INTO arbnav_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ثُمَّ مَاتَتْ رَاحِيلُ وَدُفِنَتْ فِي الطَّرِيقِ الْمُؤَدِّيَةِ إِلَى أَفْرَاتَةَ، أَيْ بَيْتِ لَحْمٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","وَأَقَامَ يَعْقُوبُ عَمُوداً عَلَى قَبْرِهَا، وَهُوَ الْمَعْرُوفُ بِعَمُودِ قَبْرِ رَاحِيلَ إِلَى الْيَوْمِ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","وَتَابَعَ إِسْرَائِيلُ رَحِيلَهُ وَنَصَبَ خِيَامَهُ وَرَاءَ «بُرْجِ عِدْرٍ» ");
INSERT INTO arbnav_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","وَبَيْنَمَا كَانَ إِسْرَائِيلُ يُقِيمُ فِي تِلْكَ الأَرْضِ مَضَى رَأُوبَيْنُ وَضَاجَعَ بِلْهَةَ سُرِّيَّةَ أَبِيهِ. وَعَرَفَ إِسْرَائِيلُ بِالأَمْرِ. وَهَؤُلاءِ هُمْ أَبْنَاءُ يَعْقُوبَ الاثْنَا عَشَرَ: ");
INSERT INTO arbnav_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","أَبْنَاءُ لَيْئَةَ: رَأُوبَيْنُ بِكْرُ يَعْقُوبَ، وَشِمْعُونُ وَلاوِي وَيَهُوذَا وَيَسَّاكَرُ وَزَبُولُونُ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","وَابْنَا رَاحِيلَ: يُوسُفُ وَبَنْيَامِينُ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","وَابْنَا بِلْهَةَ جَارِيَةِ رَاحِيلَ: دَانٌ وَنَفْتَالِي. ");
INSERT INTO arbnav_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","وَابْنَا زِلْفَةَ جَارِيَةِ لَيْئَةَ: جَادٌ وَأَشِيرُ. وَهَؤُلاءِ هُمْ أَوْلادُ يَعْقُوبَ الَّذِينَ وُلِدُوا لَهُ فِي سَهْلِ أَرَامَ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","وَقَدِمَ يَعْقُوبُ عَلَى إِسْحاقَ أَبِيهِ إِلَى مَمْرَا فِي قَرْيَةِ أَرْبَعَ الْمَعْرُوفَةِ بِحَبْرُونَ حَيْثُ تَغَرَّبَ إِبْرَاهِيمُ وَإِسْحاقُ. ");
INSERT INTO arbnav_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","وَعَاشَ إِسْحاقُ مِئَةً وَثَمَانِينَ سَنَةً، ");
INSERT INTO arbnav_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ثُمَّ أَسْلَمَ رُوحَهُ وَلَحِقَ بِقَوْمِهِ شَيْخاً طَاعِناً فِي السِّنِّ وَدَفَنَهُ ابْنَاهُ عِيسُو وَيَعْقُوبُ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","وَهَذَا سِجِلُّ مَوَالِيدِ عِيسُو أَيْ أَدُومَ: ");
INSERT INTO arbnav_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","تَزَوَّجَ عِيسُو مِنْ بَنَاتِ كَنْعَانَ: عَدَا بِنْتَ إِيلُونَ الْحِثِّيِّ وَأُهُولِيبَامَةَ بِنْتَ عَنَى بِنْتِ صِبْعُونَ الْحِوِّيِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","وَتَزَوَّجَ أَيْضاً بَسْمَةَ بِنْتَ إِسْمَاعِيلَ عَمِّهِ، أُخْتَ نَبَايُوتَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","فَأَنْجَبَتْ عَدَا لِعِيسُو أَلِيفَازَ، وَأَنْجَبَتْ بَسْمَةُ رَعُوئِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","أَمَّا أُهُولِيبَامَةُ فَقَدْ أَنْجَبَتْ يَعُوشَ وَيَعْلامَ وَقُورَحَ. هَؤُلاءِ هُمْ أَبْنَاءُ عِيسُو الَّذِينَ وُلِدُوا لَهُ فِي أَرْضِ كَنْعَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","وَأَخَذَ عِيسُو زَوْجَاتِهِ وَبَنِيهِ وَبَنَاتِهِ وَجَمِيعَ أَهْلِ بَيْتِهِ وَمَوَاشِيهِ وَكُلَّ بَهَائِمِهِ وَسَائِرَ مُقْتَنَيَاتِهِ الَّتِي اقْتَنَاهَا فِي أَرْضِ كَنْعَانَ وَانْتَقَلَ إِلَى أَرْضٍ أُخْرَى بَعِيداً عَنْ أَخِيهِ يَعْقُوبَ، ");
INSERT INTO arbnav_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","لأَنَّ أَمْلاكَهُمَا كَانَتْ مِنَ الْكَثْرَةِ بِحَيْثُ لَمْ تَسَعْهُمَا الأَرْضُ لِلإِقَامَةِ مَعاً، وَلَمْ تَسْتَطِعْ أَرْضُ غُرْبَتِهِمَا أَنْ تَكْفِيَهُمَا لِرَعْيِ مَوَاشِيهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","فَاسْتَوْطَنَ عِيسُو، أَيْ أَدُومُ، جَبَلَ سَعِيرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","وَهَذِهِ هِيَ أَسْمَاءُ أَبنَاءِ عِيسُو: ");
INSERT INTO arbnav_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","أَلِيفَازُ بْنُ عَدَا، وَرَعُوئِيلُ بْنُ بَسْمَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","أَمَّا أَبْنَاءُ أَلِيفَازَ فَهُمْ: تَيْمَانُ وَأُوْمَارُ وَصَفْوُ وَجَعْثَامُ وَقَنَازُ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","وَكَانَتْ تِمْنَاعُ سُرِّيَّةً لأَلِيفَازَ بْنِ عِيسُو فَأَنْجَبَتْ لأَلِيفَازَ عَمَالِيقَ. هَؤُلاءِ أَبْنَاءُ عَدَا زَوْجَةِ عِيسُو. ");
INSERT INTO arbnav_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","أَمَّا أَبْنَاءُ رَعُوئِيلَ فَهُمْ: نَحَثُ وَزَارَحُ وَشَمَّةُ وَمِزَّةُ. وَجَمِيعُهُمْ أَبْنَاءُ بَسْمَةَ زَوْجَةِ عِيسُو. ");
INSERT INTO arbnav_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","وَهَؤُلاءِ هُمْ أَبْنَاءُ أُهُولِيبَامَةَ بِنْتِ عَنَى حَفِيدَةِ صِبْعُونَ، زَوْجَةِ عِيسُو؛ فَقَدْ أَنْجَبَتْ لِعيسُو يَعُوشَ وَيَعْلامَ وَقُورَحَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","وَهَؤُلاءِ هُمْ رُؤَسَاءُ قَبَائِلِ بَنِي عِيسُو، مِنْ مَوَالِيدِ أَلِيفَازَ بِكْرِ عِيسُو: تَيْمَانُ وَأُوْمَارُ وَصَفْوُ وَقَنَازُ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","وَقُورَحُ وَجَعْثَامُ وَعَمَالِيقُ. هَؤُلاءِ هُمْ رُؤَسَاءُ الْقَبَائِلِ الْمُنْحَدِرَةِ مِنْ أَلِيفَازَ فِي أَرْضِ أَدُومَ. وَهُمْ مِنْ ذُرِّيَّةِ عَدَا. ");
INSERT INTO arbnav_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","وَهَؤُلاءِ هُمْ رُؤَسَاءُ قَبَائِلِ بَنِي رَعُوئِيلَ ابْنِ عِيسُو: نَحَثُ وَزَارَحُ وَشَمَّةُ وَمِزَّةُ. هَؤُلاءِ هُمْ رُؤَسَاءُ الْقَبَائِلِ الْمُنْحَدِرَةِ مِنْ رَعُوئِيلَ فِي أَرْضِ أَدُومَ. وَهُمْ مِنْ ذُرِّيَّةِ بَسْمَةَ امْرَأَةِ عِيسُو. ");
INSERT INTO arbnav_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","وَهَؤُلاءِ هُمْ أَبْنَاءُ أَهُولِيبَامَةَ امْرَأَةِ عِيسُو: الرُّؤَسَاءُ يَعُوشُ وَيَعْلامُ وَقُورَحُ. وَهُمْ رُؤَسَاءُ الْقَبَائِلِ الْمُنْحَدِرَةِ مِنْ أُهُولِيبَامَةَ امْرَأَةِ عِيسُو. ");
INSERT INTO arbnav_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","هَؤُلاءِ هُمْ أَبْنَاءُ عِيسُو، أَيْ أَدُومَ، وَهَؤُلاءِ هُمْ رُؤَسَاءُ قَبَائِلِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","وَهَؤُلاءِ هُمْ أَبْنَاءُ سِعِيرَ الْحُورِيِّ رُؤَسَاءُ الْقَبَائِلِ الْقَاطِنَةِ فِي الْمِنْطَقَةِ: لُوطَانُ وَشُوبَالُ وَصِبْعُونُ وَعَنَى. ");
INSERT INTO arbnav_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","وَدِيشُونُ وَإِيصَرُ وَدِيشَانُ. هَؤُلاءِ هُمْ رُؤَسَاءُ قَبَائِلِ الْحُورِيِّينَ مِنْ بَنِي سِعِيرَ الْمُقِيمِينَ فِي أَرْضِ أَدُومَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","أَمَّا ابْنَا لُوطَانَ فَهُمَا حُورِيُّ وَهَيْمَامُ، وَتِمْنَاعُ هِيَ أُخْتُ لُوطَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","وَهَؤُلاءِ هُمْ بَنُو شُوبَالَ: عَلْوَانُ وَمَنَاحَةُ وَعِيبَالُ وَشَفْوُ وَأُونَامُ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","أَمَّا ابْنَا صِبْعُونَ فَهُمَا أَيَّةُ وَعَنَى. هَذَا هُوَ عَنَى الَّذِي عَثَرَ عَلَى يَنَابِيعِ الْمِيَاهِ الْحَارَّةِ فِي الصَّحْرَاءِ عِنْدَمَا كَانَ يَرْعَى حَمِيرَ أَبِيهِ صِبْعُونَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","وَأَنْجَبَ عَنَى دِيشُونَ وَابْنَتَهُ أَهُولِيبَامَة. ");
INSERT INTO arbnav_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","وَأَبْنَاءُ دِيَشَانَ حَمْدَانُ وَأَشْبَانُ وَيثْرَانُ وَكَرَانُ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","وَأَبْنَاءُ إِيصَرَ: بِلْهَانُ وَزَعْوَانُ وَعَقَانُ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","أَمَّا ابْنَا دِيشَانَ فَهُمَا: عُوصٌ وَأَرَانُ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","هَؤُلاءِ هُمْ رُؤَسَاءُ قَبَائِلِ الْحُورِيِّينَ: لُوطَانُ وَشُوبَالُ وَصِبْعُونُ وَعَنَى. ");
INSERT INTO arbnav_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","وَدِيشُونُ وَإِيصَرُ وَدِيشَانُ. هَؤُلاءِ هُمْ رُؤَسَاءُ قَبَائِلِ الْحُورِيِّينَ وَفْقاً لِطَوَائِفِهِمِ الْمُقِيمَةِ فِي أَرْضِ سِعِيرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","وَهَؤُلاءِ هُمُ الْمُلُوكُ الَّذِينَ حَكَمُوا أَرْضَ أَدُومَ قَبْلَ أَنْ يُتَوَّجَ مَلِكٌ فِي إِسْرَائِيلَ: ");
INSERT INTO arbnav_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","بَالَعُ بْنُ بَعُورَ مَلَكَ فِي أَدُومَ وَكَانَ اسْمُ مَدِينَتِهِ دِنْهَابَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","وَمَاتَ بَالَعُ فَخَلَفَهُ يُوبَابُ بْنُ زَارَحَ مِنْ بُصْرَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","وَمَاتَ يُوبَابُ فَخَلَفَهُ حُوشَامُ مِنْ أَرْضِ التَّيْمَانِيِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","وَمَاتَ حُوشَامُ فَخَلَفَهُ هَدَادُ بْنُ بَدَادَ الَّذِي قَهَرَ الْمِدْيَانِيِّينَ فِي بِلادِ مُوآبَ. وَاسْمُ مَدِينَتِهِ عَوِيتُ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","وَمَاتَ هَدَادُ فَخَلَفَهُ سَمْلَةُ مِنْ مَسْرِيقَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","وَمَاتَ سَمْلَةُ فَخَلَفَهُ شَأُولُ مِنْ رَحُوبُوتِ النَّهْرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","وَمَاتَ شَأُولُ فَخَلَفَهُ بَعْلُ حَانَانَ بْنُ عَكْبُورَ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","وَمَاتَ بَعْلُ حَانَانَ فَخَلَفَهُ هَدَارُ وَاسْمُ مَدِينَتِهِ فَاعُوَ، وَكَانَتْ زَوْجَتُهُ مَهِيطَبْئِيلَ بِنْتَ مَطْرِدَ بِنْتِ مَاءِ ذَهَبٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","وَهَذِهِ أَسْمَاءُ رُؤَسَاءِ الْقَبَائِلِ الْمُتَفَرِّعَةِ مِنْ نَسْلِ عِيسُو حَسَبَ قَبَائِلِهِمْ وَأَمَاكِنِهِمِ الَّتِي حَمَلَتْ أَسْمَاءَهُمْ: رُؤَسَاءُ تِمْنَاعَ وَعَلْوَةَ وَيَتِيتَ ");
INSERT INTO arbnav_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","وَأُهُولِيبَامَةَ وَإِيلَةَ وَفِينُونَ ");
INSERT INTO arbnav_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","وَقَنَازَ وَتَيْمَانَ وَمِبْصَارَ ");
INSERT INTO arbnav_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","وَمَجْدِيئِيلَ وَعِيرَامَ. هَؤُلاءِ هُمْ رُؤَسَاءُ أَدُومَ، حَسَبَ مَوَاطِنِ سُكْنَاهُمْ فِي الأَرْضِ الَّتِي امْتَلَكُوهَا. وَجَمِيعُهُمْ مِنْ ذُرِّيَّةِ عِيسُو، أَبِي أَدُومَ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","وَسَكَنَ يَعْقُوبُ فِي أَرْضِ كَنْعَانَ، حَيْثُ تَغَرَّبَ أَبُوهُ، ");
INSERT INTO arbnav_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","وَهَذَا سِجِلٌّ بِسِيرَةِ يَعْقُوبَ. إِذْ كَانَ يُوسُفُ غُلَاماً فِي السَّابِعَةِ عَشْرَةَ مِنْ عُمْرِهِ، رَاحَ يَرْعَى الْغَنَمَ مَعَ إِخْوَتِهِ أَبْنَاءِ بِلْهَةَ وَزِلْفَةَ زَوْجَتَيْ أَبِيهِ، فَأَبْلَغَ يُوسُفُ أَبَاهُ بِنَمِيمَتِهِمِ الرَّدِيئَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","وَكَانَ إِسْرَائِيلُ يُحِبُّ يُوسُفَ أَكْثَرَ مِنْ بَقِيَّةِ إِخْوَتِهِ، لأَنَّهُ كَانَ ابْنَ شَيْخُوخَتِهِ، فَصَنَعَ لَهُ قَمِيصاً مُلَوَّناً. ");
INSERT INTO arbnav_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","وَلَمَّا رَأَى إِخْوَتُهُ أَنَّ أَبَاهُمْ يُحِبُّهُ أَكْثَرَ مِنْهُمْ كَرِهُوهُ وَأَسَاءُوا إِلَيْهِ بِكَلامِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","وَحَلُمَ يُوسُفُ حُلْماً قَصَّهُ عَلَى إِخْوَتِهِ، فَازْدَادُوا لَهُ بُغْضاً. ");
INSERT INTO arbnav_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","قَالَ لَهُمْ: «اسْمَعُوا هَذَا الْحُلْمَ الَّذِي حَلَمْتُهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","رَأَيْتُ وَكَأَنَّنَا نَحْزِمُ حُزَماً فِي الْحَقْلِ، فَإِذَا بِحُزْمَتِي وَقَفَتْ ثُمَّ انْتَصَبَتْ، فَأَحَاطَتْ بِها حُزَمُكُمْ وَانْحَنَتْ لَهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","فَقَالَ لَهُ إِخْوَتُهُ: «أَلَعَلَّكَ تَمْلِكُ عَلَيْنَا أَوْ تَحْكُمُنَا؟» وَزَادَ بُغْضُهُمْ لَهُ بِسَبَبِ أَحْلامِهِ وَكَلامِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ثُمَّ حَلُمَ حُلْماً آخَرَ سَرَدَهُ عَلَى إِخْوَتِهِ، قَالَ: «حَلَمْتُ حُلْماً آخَرَ، وَإذَا الشَّمْسُ وَالْقَمَرُ وَأَحَدَ عَشَرَ كَوْكَباً سَاجِدَةٌ لِي». ");
INSERT INTO arbnav_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","وَقَصَّهُ عَلَى أَبِيهِ وَإِخْوَتِهِ، فَأَنَّبَهُ أَبُوهُ وَقَالَ: «أَيُّ حُلْمٍ هَذَا الَّذِي حَلَمْتَهُ؟ أَتَظُنُّ حَقّاً أَنَّنِي وَأُمَّكَ وَإِخْوَتَكَ سَنَأْتِي وَنَنْحَنِي لَكَ إِلَى الأَرْضِ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","فَحَسَدَهُ إِخْوَتُهُ. أَمَّا أَبُوهُ فَأَسَرَّ هَذَا الْكَلامَ فِي قَلْبِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","وَانْطَلَقَ إِخْوَتُهُ لِيَرْعَوْا غَنَمَ أَبِيهِمْ عِنْدَ شَكِيمَ، ");
INSERT INTO arbnav_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","فَقَالَ إِسْرَائِيلُ لِيُوسُفَ: أَلا يَرْعَى إِخْوَتُكَ الْغَنَمَ عِنْدَ شَكِيمَ؟ تَعَالَ لأُرْسِلَكَ إِلَيْهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","اذْهَبْ وَاطْمَئِنَّ عَلَى إِخْوَتِكَ وَعَلَى الْمَوَاشِي، ثُمَّ عُدْ وَأَخْبِرْنِي عَنْ أَحْوَالِهِمْ، فَمَضَى مِنْ وَادِي حَبْرُونَ حَتَّى أَقْبَلَ إِلَى شَكِيمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","وَالْتَقَاهُ رَجُلٌ فَوَجَدَهُ تَائِهاً فِي الْحُقُولِ، فَسَأَلَهُ: «عَمَّنْ تَبْحَثُ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","فَأَجَابَهُ: «أَبْحَثُ عَنْ إِخْوَتِي. أَرْجُوكَ أَنْ تُخْبِرَنِي أَيْنَ يَرْعَوْنَ مَوَاشِيَهُمْ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","فَقَالَ الرَّجُلُ: «لَقَدِ انْتَقَلُوا مِنْ هُنَا، وَسَمِعْتُهُمْ يَقُولُونَ: لِنَذْهَبْ إِلَى دُوثَانَ». فَانْطَلَقَ يُوسُفُ فِي إِثْرِ إِخْوَتِهِ حَتَّى قَدِمَ عَلَيْهِمْ فِي دُوثَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","وَمَا إِنْ رَأَوْهُ مِنْ بَعِيدٍ، وَقَبْلَ أَنْ يَقْتَرِبَ مِنْهُمْ حَتَّى تَآمَرُوا عَلَيْهِ لِيَقْتُلُوهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","وَقَالَ بَعْضُهُمْ لِبَعْضٍ: «هَا هُوَ صَاحِبُ الأَحْلامِ مُقْبِلٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","هَيَّا نَقْتُلُهُ وَنُلْقِ بِهِ فِي إِحْدَى الآبَارِ، وَنَدَّعِي أَنَّ وَحْشاً ضَارِياً افْتَرَسَهُ، لِنَرَى مَاذَا تُجْدِيهِ أَحْلامُهُ». ");
INSERT INTO arbnav_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","وَإِذْ سَمِعَ رَأُوبَيْنُ حَدِيثَهُمْ، أَرَادَ أَنْ يُنْقِذَهُ فَقَالَ: «لا نَقْتُلُهُ، ");
INSERT INTO arbnav_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","وَلا تَسْفِكُوا دَماً، بَلِ اطْرَحُوهُ فِي هَذِهِ الْبِئْرِ فِي الْبَرِّيَّةِ، وَلا تَمُدُّوا إِلَيْهِ يَداً بِأَذىً». وَقَدْ أَشَارَ رَأُوبَيْنُ بِهَذَا لأَنَّهُ أَرَادَ أَنْ يُخَلِّصَهُ مِنْهُمْ وَيَرُدَّهُ إِلَى أَبِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","وَعِنْدَمَا قَدِمَ عَلَى إِخْوَتِهِ، نَزَعُوا عَنْهُ قَمِيصَهُ الْمُلَوَّنَ الَّذِي كَانَ يَرْتَدِيهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","وَأَخَذُوهُ وَأَلْقَوْا بِهِ فِي الْبِئْرِ. وَكَانَتِ الْبِئْرُ فَارِغَةً مِنَ الْمَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","وَحِينَ جَلَسُوا لِيَأْكُلُوا شَاهَدُوا عَنْ بُعْدٍ قَافِلَةً مِنَ الإِسْمَاعِيلِيِّينَ قَادِمِينَ مِنْ جِلْعَادَ فِي طَرِيقِهِمْ إِلَى مِصْرَ، وَجِمَالُهُمْ مُثَقَّلَةٌ بِالتَّوَابِلِ وَالْبَلَسَانِ وَالْمُرِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","فَقَالَ يَهُوذَا لإِخْوَتِهِ: «مَا جَدْوَى قَتْلِ أَخِينَا وَإِخْفَاءِ دَمِهِ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","تَعَالَوْا نَبِيعُهُ إِلَى الإِسْمَاعِيلِيِّينَ وَنُبْرِئُ أَيْدِينَا مِنْ دَمِهِ لأَنَّهُ أَخُونَا وَمِنْ لَحْمِنَا». فَوَافَقَ إِخْوَتُهُ عَلَى رَأْيِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","وَعِنْدَمَا دَنَا مِنْهُمُ التُّجَّارُ الْمِدْيَانِيُّونَ، سَحَبُوا يُوسُفَ مِنَ الْبِئْرِ وَبَاعُوهُ لَهُمْ بِعِشْرِينَ قِطْعَةً مِنَ الْفِضَّةِ، فَحَمَلُوهُ إِلَى مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ثُمَّ ذَهَبَ رَأُوبَيْنُ إِلَى الْبِئْرِ لِيُنْقِذَ يُوسُفَ فَلَمْ يَجِدْهُ، فَمَزَّقَ ثِيَابَهُ، ");
INSERT INTO arbnav_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","وَرَجَعَ إِلَى إِخْوَتِهِ يَقُولُ: «الْوَلَدُ لَيْسَ مَوْجُوداً، وَأَنَا الآنَ إِلَى أَيْنَ أَتَوَجَّهُ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","فَأَخَذُوا قَمِيصَ يُوسُفَ الْمُلَوَّنَ، وَذَبَحُوا تَيْساً مِنَ الْمِعْزَى وَغَمَسُوا الْقَمِيصَ فِي الدَّمِ، ");
INSERT INTO arbnav_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","وَأَرْسَلُوهُ إِلَى أَبِيهِمْ قَائِلِينَ: «لَقَدْ وَجَدْنَا هَذَا الْقَمِيصَ، فَتَحَقَّقْ مِنْهُ، أَهُوَ قَمِيصُ ابْنِكَ أَمْ لا؟» ");
INSERT INTO arbnav_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","فَتَعَرَّفَ يَعْقُوبُ عَلَيْهِ وَقَالَ: «هَذَا قَمِيصُ ابْنِي. وَحْشٌ ضَارٍ افْتَرَسَهُ وَمَزَّقَهُ أَشْلاءَ». ");
INSERT INTO arbnav_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","فَشَقَّ يَعْقُوبُ ثِيَابَهُ، وَارْتَدَى الْمُسُوحَ عَلَى حَقْوَيْهِ، وَنَاحَ عَلَى ابْنِهِ أَيَّاماً عَدِيدَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","وَعِنْدَمَا قَامَ جَمِيعُ أَبْنَائِهِ لِيُعَزُّوهُ أَبَى أَنْ يَتَعَزَّى وَقَالَ: «إِنِّي أَمْضِي إِلَى ابْنِي نَائِحاً إِلَى الْهَاوِيَةِ». وَبَكَى عَلَيْهِ أَبُوهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","وَبَاعَ الْمِدْيَانِيُّونَ يُوسُفَ فِي مِصْرَ لِفُوطِيفَارَ كَبِيرِ خَدَمِ فِرْعَوْنَ، رَئِيسِ الْحَرَسِ. ");
INSERT INTO arbnav_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","وَحَدَثَ فِي ذَلِكَ الْوَقْتِ أَنَّ يَهُوذَا افْتَرَقَ عَنْ إِخْوَتِهِ وَأَقَامَ عِنْدَ رَجُلٍ عَدُلَّامِيٍّ يُدْعَى حِيرَةَ ");
INSERT INTO arbnav_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","وَشَاهَدَ هُنَاكَ ابْنَةَ كَنْعَانِيٍّ اسْمُهُ شُوعٌ، فَتَزَوَّجَهَا، ");
INSERT INTO arbnav_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","فَحَمَلَتْ وَأَنْجَبَتْ لَهُ ابْناً دَعَاهُ عِيراً. ");
INSERT INTO arbnav_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ثُمَّ حَمَلَتْ أَيْضاً وَأَنْجَبَتِ ابْناً سَمَّتْهُ أُونَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ثُمَّ عَادَتْ فَأَنْجَبَتْ فِي كَزِيبَ ابْناً دَعَتْهُ شِيلَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","وَأَخَذَ يَهُوذَا لِعِيرَ بِكْرِهِ زَوْجَةً تُدْعَى ثَامَارَ. ");
INSERT INTO arbnav_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","وَإِذْ كَانَ عِيرُ بِكْرُ يَهُوذَا شِرِّيراً، أَمَاتَهُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","فَقَالَ يَهُوذَا لأُونَانَ: «ادْخُلْ عَلَى زَوْجَةِ أَخِيكَ وَتَزَوَّجْهَا وَأَقِمْ لأَخِيكَ نَسْلاً». ");
INSERT INTO arbnav_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","وَعَرَفَ أُونَانُ أَنَّ النَّسْلَ لَا يَكُونُ لَهُ، فَكَانَ كُلَّمَا عَاشَرَ امْرَأَةَ أَخِيهِ يُفْسِدُ عَلَى الأَرْضِ، كَيْ لا يُقِيمَ لأَخِيهِ نَسْلاً. ");
INSERT INTO arbnav_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","فَسَاءَ عَمَلُهُ هَذَا فِي عَيْنَيِ الرَّبِّ فَأَمَاتَهُ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","فَقَالَ يَهُوذَا لِثَامَارَ كَنَّتِهِ: «امْكُثِي أَرْمَلَةً فِي بَيْتِ أَبِيكِ رَيْثَمَا يَكْبُرُ شِيلَةُ ابْنِي». لأَنَّهُ قَالَ: «لِئَلّا يَمُوتَ شِيلَةُ أَيْضاً كَمَا مَاتَ أَخَوَاهُ». فَمَضَتْ ثَامَارُ وَمَكَثَتْ فِي بَيْتِ أَبِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","وَبَعْدَ زَمَنٍ طَوِيلٍ مَاتَتْ زَوْجَةُ يَهُوذَا ابْنةُ شُوعٍ. وَإِذْ تَعَزَّى يَهُوذَا بَعْدَهَا انْطَلَقَ إِلَى جُزَّازِ غَنَمِهِ فِي تِمْنَةَ بِرِفْقَةِ حِيرَةَ صَاحِبِهِ الْعَدُلامِيِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","فَقِيلَ لِثَامَارَ: «هُوَذَا حَمُوكِ قَادِمٌ لِتِمْنَةَ لِجَزِّ غَنَمِهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","فَنَزَعَتْ عَنْهَا ثِيَابَ تَرَمُّلِهَا، وَتَبَرْقَعَتْ وَتَلَفَّعَتْ وَجَلَسَتْ عِنْدَ مَدْخَلِ عَيْنَايِمَ الَّتِي عَلَى طَرِيقِ تِمْنَةَ، لأَنَّهَا عَرَفَتْ أَنَّ شِيلَةَ قَدْ كَبُرَ وَأَنَّهَا لَنْ تُزَفَّ إِلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","فَعِنْدَمَا رَآهَا يَهُوذَا ظَنَّهَا زَانِيَةً لأَنَّهَا كَانَتْ تُغَطِّي وَجْهَهَا، ");
INSERT INTO arbnav_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","فَمَالَ نَحْوَهَا إِلَى جَانِبِ الطَّرِيقِ وَقَالَ: «دَعِينِي أُعَاشِرُكِ». وَلَمْ يَكُنْ يَدْرِي أَنَّهَا كَنَّتُهُ. فَقَالَتْ: «مَاذَا تُعْطِينِي لِكَيْ تُعَاشِرَنِي؟» ");
INSERT INTO arbnav_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","فَقَالَ: «أَبْعَثُ إِلَيْكِ جَدْيَ مِعْزَى مِنَ الْقَطِيعِ». فَقَالَتْ: «أَتُعْطِينِي رَهْناً حَتَّى تَبْعَثَ بِهِ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","فَسَأَلَهَا: «أَيُّ رَهْنٍ أُعْطِيكِ؟» فَأَجَابَتْهُ: «خَاتَمُكَ وَعِصَابَتُكَ وَعَصَاكَ». فَأَعْطَاهَا مَا طَلَبَتْ، وَعَاشَرَهَا فَحَمَلَتْ مِنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ثُمَّ قَامَتْ وَمَضَتْ، وَخَلَعَتْ بُرْقُعَهَا وَارْتَدَتْ ثِيَابَ تَرَمُّلِهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","وَعِنْدَمَا أَرْسَلَ الْجَدْيَ مَعَ صَاحِبِهِ الْعَدُلامِيِّ لِيَسْتَرِدَّ الرَّهْنَ مِنْ يَدِ الْمَرْأَةِ لَمْ يَجِدْهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","فَسَأَلَ أَهْلَ الْمَكَانِ: «أَيْنَ الزَّانِيَةُ الَّتِي كَانَتْ تَجْلِسُ عَلَى الطَّرِيقِ فِي عَيْنَايِمَ؟» فَقَالُوا: «لَمْ تَكُنْ فِي هَذَا الْمَكَانِ زَانِيَةٌ». ");
INSERT INTO arbnav_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","فَعَادَ إِلَى يَهُوذَا وَقَالَ: «لَمْ أَجِدْهَا؛ وَكَذَلِكَ قَالَ أَهْلُ الْمَكَانِ: لَمْ تَكُنْ هَهُنَا زَانِيَةٌ». ");
INSERT INTO arbnav_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","فَأَجَابَ يَهُوذَا: «فَلْتَحْتَفِظْ بِمَا عِنْدَهَا، فَلَسْتُ أُرِيدُ أَنْ يَسْخَرَ النَّاسُ مِنِّي. لَقَدْ بَعَثْتُ بِهَذَا الْجَدْيِ أُجْرَةً لَهَا وَلَكِنَّكَ لَمْ تَجِدْهَا». ");
INSERT INTO arbnav_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","وَبَعْدَ مُضِيِّ ثَلاثَةِ أَشْهُرٍ قِيلَ لِيَهُوذَا: «ثَامَارُ كَنَّتُكَ زَنَتْ، وَحَبِلَتْ مِنْ زِنَاهَا». فَقَالَ يَهُوذَا: «أَخْرِجُوهَا لِتُحْرَقَ». ");
INSERT INTO arbnav_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","وَعِنْدَمَا أُخْرِجَتْ أَرْسَلَتْ إِلَى حَمِيهَا قَائِلَةً: «أَنَا حُبْلَى مِنْ صَاحِبِ هَذِهِ الأَشْيَاءِ. تَحَقَّقْ لِمَنْ هَذَا الْخَاتَمُ وَالْعِصَابَةُ وَالْعَصَا؟» ");
INSERT INTO arbnav_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","فَأَقَرَّ بِها يَهُوذَا وَقَالَ: «هِيَ حَقّاً أَبَرُّ مِنِّي، لأَنَّنِي لَمْ أُزَوِّجْهَا مِنِ ابْنِي شِيلَةَ». وَلَمْ يُعَاشِرْهَا فِي مَا بَعْدُ. ");
INSERT INTO arbnav_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","وَعِنْدَمَا أَزِفَ مَوْعِدُ وِلادَتِهَا إِذَا فِي أَحْشَائِهَا تَوْأَمَانِ. ");
INSERT INTO arbnav_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","وَفِي أَثْنَاءِ وِلادَتِهَا أَخْرَجَ أَحَدُهُمَا يَداً فَرَبَطَتِ الْقَابِلَةُ حَوْلَهَا خَيْطاً أَحْمَرَ، وَقَالَتْ: «هَذَا خَرَجَ أَوَّلاً». ");
INSERT INTO arbnav_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","غَيْرَ أَنَّهُ سَحَبَ يَدَهُ فَخَرَجَ أَخُوهُ، فَقَالَتْ: «أَيُّ اقْتِحَامٍ اقْتَحَمْتَ لِنَفْسِكَ؟» لِذَلِكَ دُعِيَ اسْمُهُ فَارَصَ (وَمَعْنَاهُ: اقْتِحَامٌ). ");
INSERT INTO arbnav_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","وَبَعْدَ ذَلِكَ خَرَجَ أَخُوهُ ذُو الْمِعْصَمِ الْمُطَوَّقِ بِالْخَيْطِ الأَحْمَرِ فَسُمِّيَ زَارَحَ (وَمَعْنَاهُ: أَحْمَرُ، أَوْ إِشْرَاقٌ). ");
INSERT INTO arbnav_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","وَأَخَذَ الإِسْمَاعِيلِيُّونَ يُوسُفَ إِلَى مِصْرَ، فَاشْتَرَاهُ مِنْهُمْ مِصْرِيٌّ يُدْعَى فُوطِيفَارَ، كَانَ خَصِيَّ فِرْعَوْنَ وَرَئِيسَ الْحَرَسِ. ");
INSERT INTO arbnav_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","وَكَانَ الرَّبُّ مَعَ يُوسُفَ، فَأَفْلَحَ فِي أَعْمَالِهِ، وَأَقَامَ فِي بَيْتِ سَيِّدِهِ الْمِصْرِيِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","وَرَأَى مَوْلاهُ أَنَّ الرَّبَّ مَعَهُ وَأَنَّهُ يُكَلِّلُ كُلَّ مَا تَصْنَعُهُ يَدَاهُ بِالنَّجَاحِ، ");
INSERT INTO arbnav_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","فَحَظِيَ يُوسُفُ بِرِضَى سَيِّدِهِ، فَجَعَلَهُ وَكِيلاً عَلَى بَيْتِهِ وَوَلَّاهُ عَلَى كُلِّ مَالَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","وَبَارَكَ الرَّبُّ بَيْتَ الْمِصْرِيِّ وَكُلَّ مَالَهُ مِنْ مُقْتَنَيَاتٍ فِي الْبَيْتِ وَالْحَقْلِ بِفَضْلِ يُوسُفَ. ");
INSERT INTO arbnav_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","فَعَهِدَ بِكُلِّ مَالَهُ إِلَى يُوسُفَ. وَلَمْ يَكُنْ يَعْرِفُ مَعَهُ شَيْئاً إِلّا الْخُبْزَ الَّذِي يَأْكُلُهُ. وَكَانَ يُوسُفُ جَمِيلَ الْهَيْئَةِ وَسِيمَ الْوَجْهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ثُمَّ لَمْ تَلْبَثْ أَنْ أُغْرِمَتْ بِهِ زَوْجَةُ مَوْلاهُ فَقَالَتْ: «اضْطَجِعْ مَعِي». ");
INSERT INTO arbnav_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","فَأَبَى وَقَالَ لَهَا: «هُوَذَا سَيِّدِي قَدْ عَهِدَ إِلَيَّ بِكُلِّ مَا يَمْلِكُ فِي هَذَا الْبَيْتِ وَلَمْ يُشْغِلْ نَفْسَهُ بِأَيِّ شَأْنٍ فِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","وَلَيْسَ فِي هَذَا الْبَيْتِ مَنْ هُوَ أَعْظَمُ مِنِّي. وَلَمْ يَمْنَعْ عَنِّي شَيْئاً غَيْرَكِ لأَنَّكِ زَوْجَتُهُ. فَكَيْفَ أَقْتَرِفُ هَذَا الشَّرَّ الْعَظِيمَ وَأُخْطِئُ إِلَى اللهِ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","وَلَمْ يُذْعِنْ يُوسُفُ لَهَا مَعَ أَنَّهَا كَانَتْ تُلِحُّ عَلَيْهِ يَوْماً بَعْدَ آخَرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","وَحَدَثَ يَوْماً أَنَّهُ دَخَلَ الْبَيْتَ لِيَقُومَ بِعَمَلِهِ، وَلَمْ يَكُنْ فِي الْمَنْزِلِ أَحَدٌ، ");
INSERT INTO arbnav_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","فَأَمْسَكَتْهُ مِنْ رِدَائِهِ وَقَالَتْ: «اضْطَجِعْ مَعِي». فَتَرَكَ رِدَاءَهُ بِيَدِهَا وَهَرَبَ خَارِجاً تَارِكاً رِدَاءَهُ بِيَدِهَا ");
INSERT INTO arbnav_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","وَعِنْدَمَا رَأَتْ أَنَّهُ قَدْ رَفَضَ وَهَرَبَ خَارِجاً تَارِكاً رِدَاءَهُ بِيَدِهَا ");
INSERT INTO arbnav_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","نَادَتْ أَهْلَ بَيْتِهَا وَقَالَتْ: «انْظُرُوا مَا جَرَى؟ هَذَا الْعِبْرَانِيُّ الَّذِي جَاءَ بِهِ زَوْجِي إِلَى الْبَيْتِ. شَرَعَ يُرَاوِدُنِي عَنْ نَفْسِي. دَخَلَ غُرْفَتِي وَحَاوَلَ اغْتِصَابِي، فَصَرَخْتُ بِأَعْلَى صَوْتِي. ");
INSERT INTO arbnav_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","وَعِنْدَمَا سَمِعَنِي قَدْ رَفَعْتُ صَوْتِي وَصَرَخْتُ، تَرَكَ رِدَاءَهُ مَعِي وَهَرَبَ خَارِجاً». ");
INSERT INTO arbnav_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","وَأَلْقَتْ رِدَاءَهُ إِلَى جَانِبِهَا حَتَّى قَدِمَ مَوْلاهُ إِلَى بَيْتِهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","فَقَصَّتْ عَلَيْهِ مِثْلَ هَذَا الْحَدِيثِ قَائِلَةً: «دَخَلَ الْعَبْدُ الْعِبْرَانِيُّ الَّذِي جِئْتَ بِهِ إِلَيْنَا لِيُرَاوِدَنِي عَنْ نَفْسِي، ");
INSERT INTO arbnav_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","وَحِينَ رَفَعْتُ صَوْتِي وَصَرَخْتُ، تَرَكَ ثَوْبَهُ بِجَانِبِي وَفَرَّ خَارِجاً». ");
INSERT INTO arbnav_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","فَلَمَّا سَمِعَ سَيِّدُهُ كَلامَ زَوْجَتِهِ وَمَا اتَّهَمَتْ بِهِ يُوسُفَ احْتَدَمَ غَضَبُهُ، ");
INSERT INTO arbnav_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","فَقَبَضَ عَلَى يُوسُفَ وَزَجَّهُ فِي السِّجْنِ، حَيْثُ كَانَ أَسْرَى الْمَلِكِ مُعْتَقَلِينَ، فَمَكَثَ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","وَلَكِنَّ الرَّبَّ كَانَ مَعَ يُوسُفَ، فَأَغْدَقَ عَلَيْهِ رَحْمَتَهُ، فَنَالَ رِضَى رَئِيسِ السِّجْنِ، ");
INSERT INTO arbnav_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","حَتَّى عَهِدَ إِلَى يُوسُفَ بِكُلِّ الْمَسَاجِينِ الْمُعْتَقَلِينَ، وَجَعَلَهُ مَسْؤولاً عَنْ كُلِّ مَا يَجْرِي هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","وَلَمْ يُحَاسِبْ رَئِيسُ السِّجْنِ يُوسُفَ بِأَيِّ شَيْءٍ أَوْكَلَهُ إِلَيْهِ، لأَنَّ الرَّبَّ كَانَ مَعَهُ. وَمَهْمَا فَعَلَ كَانَ الرَّبُّ يُكَلِّلُهُ بِالنَّجَاحِ. ");
INSERT INTO arbnav_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","وَاتَّفَقَ بَعْدَ ذَلِكَ أَنَّ سَاقِيَ مَلِكِ مِصْرَ وَالْخَبَّازَ أَذْنَبَا إِلَى سَيِّدِهِمَا مَلِكِ مِصْرَ، ");
INSERT INTO arbnav_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","فَسَخَطَ فِرْعَوْنُ عَلَى خَصِيَّيْهِ: رَئِيسِ السُّقَاةِ وَرَئِيسِ الْخَبَّازِينَ، ");
INSERT INTO arbnav_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","وَزَجَّهُمَا فِي مُعْتَقَلِ بَيْتِ رَئِيسِ الْحَرَسِ فِي السِّجْنِ، فِي الْمَكَانِ الَّذِي كَانَ يُوسُفُ مَحْبُوساً فِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","فَوَلَّى رَئِيسُ الْحَرَسِ يُوسُفَ أَمْرَهُمَا، فَقَامَ عَلَى خِدْمَتِهِمَا، فَمَكَثَا فِي الْمُعْتَقَلِ أَيَّاماً. ");
INSERT INTO arbnav_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","وَحَلُمَ كُلٌّ مِنْ سَاقِي مَلِكِ مِصْرَ وَخَبَّازِهِ الْمُعْتَقَلَيْنِ فِي السِّجْنِ حُلْماً فِي لَيْلَةٍ وَاحِدَةٍ. وَكَانَ لِحُلْمِ كُلٍّ مِنْهُمَا مَعْنَاهُ الْخَاصُّ بِصَاحِبِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","فَأَقْبَلَ عَلَيْهِمَا يُوسُفُ فِي الصَّبَاحِ فَوَجَدَهُمَا مُكْتَئِبَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","فَسَأَلَهُمَا: «لِمَاذَا وَجْهَاكُمَا مُكَمَّدَانِ فِي هَذَا الْيَوْمِ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","فَأَجَابَاهُ: «حَلُمَ كُلٌّ مِنَّا حُلْماً وَلَيْسَ مَنْ يُفَسِّرُهُ». فَقَالَ يُوسُفُ: «أَلَيْسَتْ تَفَاسِيرُ الأَحْلامِ لِلهِ؟ حَدِّثَانِي بِهِمَا». ");
INSERT INTO arbnav_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","فَسَرَدَ رَئِيسُ السُّقَاةِ حُلْمَهُ عَلَى يُوسُفَ. قَالَ: «رَأَيْتُ فِي حُلْمِي وَإذَا كَرْمَةٌ أَمَامِي، ");
INSERT INTO arbnav_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","فِيهَا ثَلاثَةُ أَغْصَانٍ أَفْرَخَتْ ثُمَّ أَزْهَرَتْ، وَمَا لَبِثَتْ عَنَاقِيدُهَا أَنْ أَثْمَرَتْ عِنَباً نَاضِجاً. ");
INSERT INTO arbnav_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","وَكَانَتْ كَأْسُ فِرْعَوْنَ فِي يَدِي، فَتَنَاوَلْتُ الْعِنَبَ وَعَصَرْتُهُ فِي كَأْسِ فِرْعَوْنَ وَوَضَعْتُ الْكَأْسَ فِي يَدِهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","فَقَالَ لَهُ يُوسُفُ: «إِلَيْكَ تَفْسِيرَهُ: الثَّلاثَةُ الأَغْصَان هِيَ ثَلاثَةُ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","بَعْدَ ثَلاثَةِ أَيَّامٍ يَرْضَى عَنْكَ فِرْعَوْنُ، وَيَرُدُّكَ إِلَى مَنْزِلَتِكَ حَيْثُ تُنَاوِلُ فِرْعَوْنَ كَأْسَهُ، تَمَاماً كَمَا كُنْتَ مُعْتَاداً أَنْ تَفْعَلَ عِنْدَمَا كُنْتَ سَاقِيَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","إِنَّمَا إِذَا أَصَابَكَ خَيْرٌ فَاذْكُرْنِي وَأَحْسِنْ إِلَيَّ. اذْكُرْنِي لَدَى فِرْعَوْنَ وَأَخْرِجْنِي مِنْ هَذَا السِّجْنِ، ");
INSERT INTO arbnav_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","لأَنَّنِي حُمِلْتُ عَنْوَةً مِنْ أَرْضِ الْعِبْرَانِيِّينَ، وَهُنَا أَيْضاً لَمْ أَجْنِ شَيْئاً لِيَزُجُّوا بِي فِي هَذَا السِّجْنِ». ");
INSERT INTO arbnav_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","وَعِنْدَمَا رَأَى رَئِيسُ الْخَبَّازِينَ أَنَّ يُوسُفَ أَحْسَنَ التَّفْسِيرَ، قَالَ لَهُ: «رَأَيْتُ أَنَا أَيْضاً حُلْماً، وَإذَا بِثَلاثَةِ سِلالٍ بَيْضَاءَ عَلَى رَأْسِي. ");
INSERT INTO arbnav_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","وَكَانَ السَّلُّ الأَعْلَى مَلِيئاً مِنْ طَعَامِ فِرْعَوْنَ مِمَّا يُعِدُّهُ الْخَبَّازُ، إِلّا أَنَّ الطُّيُورَ كَانَتْ تَلْتَهِمُهُ مِنَ السَّلِّ الَّذِي عَلَى رَأْسِي». ");
INSERT INTO arbnav_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","فَقَالَ يُوسُفُ: «إِلَيْكَ تَفْسِيرَهُ: الثَّلاثَةُ السِّلالُ هِيَ ثَلاثَةُ أَيَّامٍ ");
INSERT INTO arbnav_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","بَعْدَ ثَلاثَةِ أَيَّامٍ يَقْطَعُ فِرْعَوْنُ رَأْسَكَ وَيُعَلِّقُكَ عَلَى خَشَبَةٍ فَتَأْكُلُ الطُّيُورُ لَحْمَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","وَكَانَ الْيَوْمُ الثَّالِثُ هُوَ يَوْمُ عِيدِ مِيلادِ فِرْعَوْنَ، فَأَقَامَ مَأْدُبَةً لِجَمِيعِ رِجَالِهِ، وَأَحْضَرَ مِنَ السِّجْنِ رَئِيسَ السُّقَاةِ وَرَئِيسَ الْخَبَّازِينَ أَمَامَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","وَرَدَّ رَئِيسَ السُّقَاةِ إِلَى عَمَلِهِ، فَصَارَ يُقَدِّمُ الْكَأْسَ لِيَدِ فِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","أَمَّا رَئِيسُ الْخَبَّازِينَ فَقَدْ عَلَّقَهُ (عَلَى خَشَبَةٍ) مِثْلَمَا فَسَّرَ لَهُمَا يُوسُفُ حُلْمَيْهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","وَلَكِنَّ رَئِيسَ السُّقَاةِ لَمْ يَذْكُرْ يُوسُفَ بَلْ نَسِيَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","وَبَعْدَ انْقِضَاءِ سَنَتَيْنِ رَأَى فِرْعَوْنُ حُلْماً، وَإذَا بِهِ وَاقِفٌ بِجُوَارِ نَهْرِ النِّيلِ ");
INSERT INTO arbnav_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","وَإذَا بِسَبْعِ بَقَرَاتٍ حِسَانِ الْمَنْظَرِ وَسَمِينَاتِ الأَبْدَانِ، صَاعِدَاتٍ مِنَ النَّهْرِ أَخَذَتْ تَرْعَى فِي الْمَرْجِ، ");
INSERT INTO arbnav_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ثُمَّ إِذَا بِسَبْعِ بَقَرَاتٍ أُخْرَى قَبِيحَاتِ الْمَنْظَرِ وَهَزِيلاتٍ تَصْعَدُ وَرَاءَهَا مِنَ النَّهْرِ وَتَقِفُ إِلَى جُوَارِ الْبَقَرَاتِ الأُولَى عَلَى ضَفَّةِ النَّهْرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","وَالْتَهَمَتِ الْبَقَرَاتُ الْقَبِيحَاتُ الْبَقَرَاتِ السَّبْعَ الْحَسَنَاتِ الْمَنْظَرِ وَالسَّمِينَاتِ. وَأَفَاقَ فِرْعَوْنُ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ثُمَّ نَامَ، فَحَلُمَ ثَانِيَةً، وَإذَا بِسَبْعِ سَنَابِلَ نَابِتَةٍ مِنْ سَاقٍ وَاحِدَةٍ زَاهِيَةٍ وَمُمْتَلِئَةٍ ");
INSERT INTO arbnav_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ثُمَّ رَأَى سَبْعَ سَنَابِلَ عَجْفَاءَ قَدْ لَفَحَتْهَا الرِّيحُ الشَّرْقِيَّةُ نَابِتَةً وَرَاءَهَا، ");
INSERT INTO arbnav_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","فَابْتَلَعَتِ السَّنَابِلُ الْعَجْفَاءُ السَّبْعَ السَّنَابِلَ الزَّاهِيَةَ الْمُمْتَلِئَةَ. وَأَفَاقَ فِرْعَوْنُ، وَأَدْرَكَ أَنَّهُ حُلْمٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","وَلَمَّا كَانَ الصَّبَاحُ اسْتَوْلَى الانْزِعَاجُ عَلَى فِرْعَوْنَ فَأَرْسَلَ وَاسْتَدْعَى جَمِيعَ سَحَرَةِ مِصْرَ وَكُلَّ حُكَمَائِهَا، وَسَرَدَ عَلَيْهِمْ حُلْمَهُ، فَلَمْ يَجِدْ مَنْ يُفَسِّرُهُ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","عِنْدَئِذٍ قَالَ رَئِيسُ السُّقَاةِ لِفِرْعَوْنَ: «إِنِّي أَذْكُرُ الْيَوْمَ ذُنُوبِي. ");
INSERT INTO arbnav_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","لَقَدْ سَخَطَ فِرْعَوْنُ عَلَى عَبْدَيْهِ، فَزَجَّنِي وَرَئِيسَ الْخَبَّازِينَ فِي مُعْتَقَلِ بَيْتِ رَئِيسِ الْحَرَسِ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","فَحَلُمَ كُلٌّ مِنَّا حُلْماً فِي نَفْسِ اللَّيْلَةِ، وَكَانَ تَفْسِيرُ كُلِّ حُلْمٍ يَتَّفِقُ مَعَ أَحْوَالِ رَائِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","وَكَانَ مَعَنَا هُنَاكَ غُلامٌ عِبْرَانِيٌّ، عَبْدٌ لِرَئِيسِ الْحَرَسِ، فَسَرَدْنَا عَلَيْهِ حُلْمَيْنَا فَفَسَّرَهُمَا لِكُلٍّ مِنَّا حَسَبَ تَعْبِيرِ حُلْمِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","وَقَدْ تَمَّ مَا فَسَّرَهُ لَنَا. فَرَدَّنِي فِرْعَوْنُ إِلَى وَظِيفَتِي وَأَمَّا ذَاكَ فَعَلَّقَهُ (عَلَى خَشَبَةٍ)». ");
INSERT INTO arbnav_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","فَبَعَثَ فِرْعَوْنُ وَاسْتَدْعَى يُوسُفَ، فَأَسْرَعُوا وَأَتَوْا بِهِ مِنَ السِّجْنِ فَحَلَقَ وَاسْتَبْدَلَ ثِيَابَهُ وَمَثَلَ أَمَامَ فِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","فَقَالَ فِرْعَوْنُ لِيُوسُفَ: «لَقَدْ رَأَيْتُ حُلْماً وَلَيْسَ هُنَاكَ مَنْ يُفَسِّرُهُ، وَقَدْ سَمِعْتُ عَنْكَ حَدِيثاً أَنَّكَ إِنْ سَمِعْتَ حُلْماً تَقْدِرُ أَنْ تُفَسِّرَهُ». ");
INSERT INTO arbnav_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","فَأَجَابَ يُوسُفُ: «لا فَضْلَ لِي فِي ذَلِكَ، بَلْ إِنَّ اللهَ هُوَ الَّذِي يُعْطِي فِرْعَوْنَ الْجَوَابَ الصَّائِبَ». ");
INSERT INTO arbnav_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","فَقَالَ فِرْعَوْنُ لِيُوسُفَ: «رَأَيْتُ نَفْسِي فِي الْحُلْمِ وَإذَا بِي أَقِفُ عَلَى ضَفَّةِ النَّهْرِ، ");
INSERT INTO arbnav_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","وَإذَا بِسَبْعِ بَقَرَاتٍ حِسَانِ الْمَنْظَرِ وَسَمِينَاتِ الأَبْدَانِ صَاعِدَاتٍ مِنَ النَّهْرِ تَرْعَى فِي الْمَرْجِ، ");
INSERT INTO arbnav_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ثُمَّ إِذَا بِسَبْعِ بَقَرَاتٍ أُخَرَ قَبِيحَاتِ الْمَنْظَرِ وَهَزِيلاتٍ تَصْعَدُ وَرَاءَهَا مِنَ النَّهْرِ. لَمْ أَرَ فِي أَرْضِ مِصْرَ كُلِّهَا نَظِيرَهَا فِي الْقَبَاحَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","فَالْتَهَمَتِ الْبَقَرَاتُ الْهَزِيلاتُ الْقَبِيحَاتُ السَّبْعَ الْبَقَرَاتِ الأُولَى السَّمِينَاتِ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","وَمَعَ أَنَّهَا ابْتَلَعَتْهَا ظَلَّتْ عَجْفَاءَ وَكَأَنَّهَا لَمْ تَبْتَلِعْهَا وَبَقِيَ مَنْظَرُهَا قَبِيحاً كَمَا كَانَتْ. وَاسْتَيْقَظْتُ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ثُمَّ رَأَيْتُ فِي حُلْمِي وَإذَا بِسَبْعِ سَنَابِلَ زَاهِيَةٍ وَمُمْتَلِئَةٍ نَابِتَةٍ مِنْ سَاقٍ وَاحِدَةٍ، ");
INSERT INTO arbnav_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ثُمَّ إِذَا بِسَبْعِ سَنَابِلَ يَابِسَةٍ عَجْفَاءَ قَدْ لَفَحَتْهَا الرِّيحُ الشَّرْقِيَّةُ نَابِتَةٍ وَرَاءَهَا، ");
INSERT INTO arbnav_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","فَابْتَلَعَتِ السَّنَابِلُ الْعَجْفَاءُ السَّبْعَ الزَّاهِيَةَ. وَلَقَدْ سَرَدْتُ عَلَى السَّحَرَةِ هَذَيْنِ الْحُلْمَيْنِ، فَلَمْ أَجِدْ بَيْنَهُمْ مَنْ يُفَسِّرُهُمَا لِي». ");
INSERT INTO arbnav_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","فَقَالَ يُوسُفُ لِفِرْعَوْنَ: «حُلْمَا فِرْعَوْنَ هُمَا حُلْمٌ وَاحِدٌ. وَقَدْ أَطْلَعَ اللهُ فِرْعَوْنَ عَمَّا هُوَ فَاعِلٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","السَّبْعُ الْبَقَرَاتُ الْحِسَانُ هِيَ سَبْعُ سَنَوَاتٍ. وَالسَّبْعُ السَّنَابِلُ الزَّاهِيَاتُ هِيَ أَيْضاً سَبْعُ سَنَوَاتٍ. فَالْحُلْمَانِ هُمَا حُلْمٌ وَاحِدٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","وَالسَّبْعُ الْبَقَرَاتُ الْقَبِيحَاتُ الْهَزِيلاتُ الَّتِي صَعِدَتْ وَرَاءَهَا هِيَ سَبْعُ سَنَوَاتٍ. وَالسَّبْعُ السَّنَابِلُ الْفَارِغَاتُ الْمَلْفُوحَاتُ بِالرِّيحِ الشَّرْقِيَّةِ سَتَكُونُ سَبْعَ سَنَوَاتِ جُوعٍ ");
INSERT INTO arbnav_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","وَالأَمْرُ هُوَ كَمَا أَخْبَرْتُ بِهِ فِرْعَوْنَ: فَقَدْ أَطْلَعَ اللهُ فِرْعَوْنَ عَمَّا هُوَ صَانِعٌ ");
INSERT INTO arbnav_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","هُوَذَا سَبْعُ سِنِينَ رَخَاءٍ عَظِيمٍ قَادِمَةٌ عَلَى كُلِّ أَرْضِ مِصْرَ، ");
INSERT INTO arbnav_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","تَعْقُبُهَا سَبْعُ سَنَوَاتِ جُوعٍ، حَتَّى يَنْسَى النَّاسُ كُلَّ الرَّخَاءِ الَّذِي عَمَّ أَرْضَ مِصْرَ، وَيُتْلِفُ الْجُوعُ الأَرْضَ، ");
INSERT INTO arbnav_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","وَيَخْتَفِي كُلُّ أَثَرٍ لِلرَّخَاءِ فِي الْبِلادِ مِنْ جَرَّاءِ الْمَجَاعَةِ الَّتِي تَعْقُبُهُ، لأَنَّهَا سَتَكُونُ قَاسِيَةً جِدّاً ");
INSERT INTO arbnav_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","أَمَّا تَكْرَارُ الْحُلْمِ عَلَى فِرْعَوْنَ مَرَّتَيْنِ فَلَأَنَّ الأَمْرَ قَدْ قَرَّرَهُ اللهُ، وَلابُدَّ أَنْ يُجْرِيَهُ سَرِيعاً. ");
INSERT INTO arbnav_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","وَالآنَ لِيَبْحَثْ فِرْعَوْنُ عَنْ رَجُلٍ بَصِيرٍ حَكِيمٍ يُوَلِّيهِ عَلَى الْبِلادِ، ");
INSERT INTO arbnav_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","وَلْيُقِمْ فِرْعَوْنُ نُظَّاراً عَلَى أَرْضِ مِصْرَ يَجْبُونَ خُمْسَ غَلَّتِهَا فِي سَنَوَاتِ الرَّخَاءِ السَّبْعِ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","وَلِيَجْمَعُوا كُلَّ طَعَامِ سَنَوَاتِ الْخَيْرِ الْمُقْبِلَةِ، وَيَخْزِنُوا الْقَمْحَ بِتَفْوِيضٍ مِنْ فِرْعَوْنَ وَيَحْفَظُوهُ فِي الْمُدُنِ لِيَكُونَ طَعَاماً، ");
INSERT INTO arbnav_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","وَمَؤُونَةً لأَهْلِ الأَرْضِ فِي سَنَوَاتِ الْمَجَاعَةِ السَّبْعِ الَّتِي سَتَسُودُ أَرْضَ مِصْرَ فَلا يَهْلِكُونَ جُوعاً». ");
INSERT INTO arbnav_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","فَاسْتَحْسَنَ فِرْعَوْنُ وَرِجَالُهُ جَمِيعاً هَذَا الْكَلامَ، ");
INSERT INTO arbnav_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","وَقَالَ فِرْعَوْنُ لِعَبِيدِهِ: «هَلْ نَجِدُ نَظِيرَ هَذَا رَجُلاً فِيهِ رُوحُ اللهِ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ثُمَّ قَالَ فِرْعَوْنُ لِيُوسُفَ: «مِنْ حَيْثُ إِنَّ اللهَ قَدْ أَطْلَعَكَ عَلَى كُلِّ هَذَا، فَلَيْسَ هُنَاكَ بَصِيرٌ وَحَكِيمٌ نَظِيرَكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","لِذَلِكَ أُوَلِّيكَ عَلَى بَيْتِي، وَيُذْعِنُ شَعْبِي لِكُلِّ أَمْرٍ تُصْدِرُهُ، وَلَنْ يَكُونَ أَعْظَمَ مِنْكَ سِوَايَ أَنَا صَاحِبِ الْعَرْشِ». ");
INSERT INTO arbnav_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ثُمَّ قَالَ فِرْعَوْنُ لِيُوسُفَ: «هَا أَنَا قَدْ وَلَّيْتُكَ عَلَى كُلِّ أَرْضِ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","وَنَزَعَ فِرْعَوْنُ خَاتَمَهُ مِنْ يَدِهِ وَوَضَعَهُ فِي يَدِ يُوسُفَ، وَأَلْبَسَهُ ثِيَابَ كَتَّانٍ فَاخِرَةً وَطَوَّقَ عُنُقَهُ بِطَوْقٍ مِنْ ذَهَبٍ، ");
INSERT INTO arbnav_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","وَأَرْكَبَهُ فِي مَرْكَبَتِهِ الثَّانِيَةِ، وَنَادُوا: «ارْكَعُوا أَمَامَهُ». وَأَقَامَهُ وَالِياً عَلَى كُلِّ أَرْضِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","وَقَالَ فِرْعَوْنُ لِيُوسُفَ: «أَنَا فِرْعَوْنُ، وَلا أَحَدَ يُمْكِنُ أَنْ يُحَرِّكَ سَاكِناً فِي كُلِّ أَرْضِ مِصْرَ مِنْ غَيْرِ إِذْنِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","وَدَعَا فِرْعَوْنُ اسْمَ يُوسُفَ صَفْنَاتَ فَعْنِيحَ (وَمَعْنَاهُ بِالْمِصْرِيَّةِ الْقَدِيمَةِ مُخَلِّصُ الْعَالَمِ أَوْ حَافِظُ الْحَيَاةِ). وَزَوَّجَهُ مِنْ أَسْنَاتَ بِنْتِ فُوطِيفَارَعَ كَاهِنِ أُونَ، فَذَاعَ اسْمُ يُوسُفَ فِي جَمِيعِ أَرْجَاءِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","وَكَانَ يُوسُفُ فِي الثَّلاثِينَ مِنْ عُمْرِهِ عِنْدَمَا مَثَلَ أَمَامَ فِرْعَوْنَ مَلِكِ مِصْرَ. وَبَعْدَ أَنْ خَرَجَ مِنْ حَضْرَةِ فِرْعَوْنَ شَرَعَ يَجُولُ فِي جَمِيعِ أَرْجَاءِ الْبِلادِ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","وَفِي سَنَوَاتِ الْخِصْبِ السَّبْعِ غَلَّتِ الأَرْضُ بِوَفْرَةٍ، ");
INSERT INTO arbnav_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","فَجَمَعَ كُلَّ طَعَامِ السَّبْعِ سَنَوَاتٍ الْمُتَوَافِرِ فِي أَرْضِ مِصْرَ وَخَزَنَهُ فِي الْمُدُنِ، فَاخْتَزَنَ فِي كُلِّ مَدِينَةٍ غَلَّاتِ مَا حَوْلَهَا مِنْ حُقُولٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","وَادَّخَرَ يُوسُفُ كَمِّيَّاتٍ هَائِلَةً مِنَ الْقَمْحِ حَتَّى كَفَّ عَنْ إِحْصَائِهَا لِوَفْرَتِهَا الْعَظِيمَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","وَأَنْجَبَتْ أَسْنَاتُ بِنْتُ فُوطِي فَارَعَ كَاهِنِ أُونَ لِيُوسُفَ ابْنَيْنِ قَبْلَ حُلُولِ سَنَوَاتِ الْجُوعِ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","فَدَعَا يُوسُفُ اسْمَ الْبِكْرِ مَنَسَّى (وَمَعْنَاهُ: مَنْ يَنْسَى أَوْ الْمَنْسِيُّ) وَقَالَ: «لأَنَّ اللهَ أَنْسَانِي كُلَّ مَشَقَّتِي وَكُلَّ بَيْتِ أَبِي». ");
INSERT INTO arbnav_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","أَمَّا الثَّانِي فَدَعَا اسْمَهُ أَفْرَايِمَ (وَمَعْنَاهُ: الْمُثْمِرُ مُضَاعَفاً) وَقَالَ: «لأَنَّ اللهَ جَعَلَنِي مُثْمِراً فِي أَرْضِ مَذَلَّتِي». ");
INSERT INTO arbnav_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ثُمَّ انْتَهَتْ سَبْعُ سَنَوَاتِ الرَّخَاءِ الَّذِي عَمَّ أَرْضَ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","وَحَلَّتْ سَبْعُ سَنَوَاتِ الْمَجَاعَةِ كَمَا أَنْبَأَ يُوسُفُ. فَحَدَثَتْ مَجَاعَةٌ فِي جَمِيعِ الْبُلْدَانِ. أَمَّا أَرْضُ مِصْرَ فَقَدْ تَوَافَرَ فِيهَا الْخُبْزُ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","وَعِنْدَمَا عَمَّتِ الْمَجَاعَةُ جَمِيعَ أَرْضِ مِصْرَ صَرَخَ الشَّعْبُ إِلَى فِرْعَوْنَ طَالِبِينَ الْخُبْزَ، فَقَالَ فِرْعَوْنُ لِكُلِّ الْمِصْرِيِّينَ: «اذْهَبُوا إِلَى يُوسُفَ وَافْعَلُوا كَمَا يَقُولُ لَكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","وَطَغَتِ الْمَجَاعَةُ عَلَى كُلِّ أَرْجَاءِ الْبِلادِ فَفَتَحَ يُوسُفُ الْمَخَازِنَ وَبَاعَ الطَّعَامَ لِلْمِصْرِيِّينَ. وَلَكِنَّ وَطْأَةَ الْجُوعِ اشْتَدَّتْ فِي أَرْضِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","وَأَقْبَلَ أَهْلُ الْبُلْدَانِ الأُخْرَى إِلَى مِصْرَ، إِلَى يُوسُفَ، لِيَبْتَاعُوا قَمْحاً لأَنَّ الْمَجَاعَةَ كَانَتْ شَدِيدَةً فِي كُلِّ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","وَعِنْدَمَا رَأَى يَعْقُوبُ أَنَّ الْقَمْحَ مُتَوَافِرٌ فِي مِصْرَ، قَالَ لأَبْنَائِهِ: «مَا بَالُكُمْ تَنْظُرُونَ بَعْضُكُمْ إِلَى بَعْضٍ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","لَقَدْ سَمِعْتُ أَنَّ الْقَمْحَ مُتَوَافِرٌ فِي مِصْرَ. فَانْحَدِرُوا إِلَى هُنَاكَ وَاشْتَرُوا لَنَا قَمْحاً لِنَبْقَى عَلَى قَيْدِ الْحَيَاةِ وَلا نَمُوتَ». ");
INSERT INTO arbnav_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","فَذَهَبَ عَشَرَةٌ مِنْ إِخْوَةِ يُوسُفَ لِيَشْتَرُوا قَمْحاً مِنْ مِصْرَ، ");
INSERT INTO arbnav_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","أَمَّا بَنْيَامِينُ أَخُو يُوسُفَ فَلَمْ يُرْسِلْهُ يَعْقُوبُ مَعَ إِخْوَتِهِ خَوْفاً مِنْ أَنْ يَنَالَهُ مَكْرُوهٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","فَقَدِمَ أَبْنَاءُ إِسْرَائِيلَ إِلَى مِصْرَ مَعَ جُمْلَةِ الْقَادِمِينَ لِيَشْتَرُوا قَمْحاً، لأَنَّ الْمَجَاعَةَ كَانَتْ قَدْ أَصَابَتْ أَرْضَ كَنْعَانَ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","وَكَانَ يُوسُفُ هُوَ الْمُتَسَلِّطُ عَلَى مِصْرَ، وَالْقَائِمُ عَلَى بَيْعِ الْقَمْحِ لأَهْلِهَا جَمِيعاً. فَأَقْبَلَ إِخْوَةُ يُوسُفَ وَسَجَدُوا لَهُ بِوُجُوهِهِمْ إِلَى الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","فَلَمَّا رَآهُمْ عَرَفَهُمْ، وَلَكِنَّهُ تَنَكَّرَ لَهُمْ وَخَاطَبَهُمْ بِجَفَاءٍ وَسَأَلَهُمْ: «مِنْ أَيْنَ جِئْتُمْ؟» فَأَجَابُوهُ: «مِنْ أَرْضِ كَنْعَانَ لِنَشْتَرِيَ طَعَاماً». ");
INSERT INTO arbnav_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","وَمَعَ أَنَّ يُوسُفَ عَرَفَهُمْ، إِلّا أَنَّهُمْ لَمْ يَعْرِفُوهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ثُمَّ تَذَكَّرَ يُوسُفُ أَحْلامَهُ الَّتِي حَلَمَهَا بِشَأْنِهِمْ، فَقَالَ لَهُمْ: «أَنْتُمْ جَوَاسِيسُ، وَقَدْ جِئْتُمْ لاكْتِشَافِ ثُغُورِنَا غَيْرِ الْمَحْمِيَّةِ» ");
INSERT INTO arbnav_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","فَقَالُوا لَهُ: «لا يَا سَيِّدِي إِنَّمَا قَدِمَ عَبِيدُكَ لِشِرَاءِ الطَّعَامِ، ");
INSERT INTO arbnav_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","فَنَحْنُ كُلُّنَا أَبْنَاءُ رَجُلٍ وَاحِدٍ، نَحْنُ أُمَنَاءُ وَلَيْسَ عَبِيدُكَ جَوَاسِيسَ». ");
INSERT INTO arbnav_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","وَلَكِنَّهُ قَالَ لَهُمْ: «لا! أَنْتُمْ قَدْ جِئْتُمْ لاكْتِشَافِ ثُغُورِنَا غَيْرِ الْمَحْمِيَّةِ» ");
INSERT INTO arbnav_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","فَأَجَابُوهُ: «إِنَّ عَبِيدَكَ اثْنَا عَشَرَ أَخاً، أَبْنَاءُ رَجُلٍ وَاحِدٍ مُقِيمٍ فِي أَرْضِ كَنْعَانَ. وَقَدْ بَقِيَ أَخُونَا الصَّغِيرُ عِنْدَ أَبِينَا الْيَوْمَ، وَالآخَرُ مَفْقُودٌ». ");
INSERT INTO arbnav_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","فَقَالَ لَهُمْ: «إِنَّ الأَمْرَ كَمَا قُلْتُ لَكُمْ! أَنْتُمْ جَوَاسِيسُ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","وَحَيَاةِ فِرْعَوْنَ إِنَّكُمْ لَنْ تُغَادِرُوا هُنَا حَتَّى تَأْتُوا بِأَخِيكُمُ الأَصْغَرِ، وَبِذَلِكَ تُثْبِتُونَ صِدْقَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","أَوْفِدُوا وَاحِداً مِنْكُمْ لِيَأْتِيَ بِأَخِيكُمْ، أَمَّا بَقِيَّتُكُمْ فَتَمْكُثُونَ فِي السِّجْنِ حَتَّى تَثْبُتَ صِحَّةُ كَلامِكُمْ إِنْ كُنْتُمْ صَادِقِينَ. وَإلَّا فَوَحَيَاةِ فِرْعَوْنَ أَنْتُمْ لَسْتُمْ سِوَى جَوَاسِيسَ». ");
INSERT INTO arbnav_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","وَطَرَحَهُمْ فِي السِّجْنِ مَعاً ثَلاثَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","وَفِي الْيَوْمِ الثَّالِثِ قَالَ لَهُمْ: «افْعَلُوا مَا أَطْلُبُهُ مِنْكُمْ فَتَحْيَوْا، فَأَنَا رَجُلٌ أَتَّقِي اللهَ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","إِنْ كُنْتُمْ حَقّاً صَادِقِينَ فَلْيَبْقَ وَاحِدٌ مِنْكُمْ رَهِينَةً، بَيْنَمَا يَأْخُذُ بَقِيَّتُكُمُ الْقَمْحَ وَيَنْطَلِقُونَ إِلَى بُيُوتِكُمُ الْجَائِعَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","وَلَكِنْ إِيتُونِي بِأَخِيكُمُ الأَصْغَرِ فَأَتَحَقَّقَ بِذَلِكَ مِنْ صِدْقِكُمْ وَلا تَمُوتُوا». فَوَافَقُوا عَلَى ذَلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","وَقَالُوا: «حَقّاً إِنَّنَا أَذْنَبْنَا فِي حَقِّ أَخِينَا. لَقَدْ رَأَيْنَا ضِيقَةَ نَفْسِهِ عِنْدَمَا اسْتَرْحَمَنَا فَلَمْ نَسْمَعْ لَهُ. لِذَلِكَ أَصَابَتْنَا هَذِهِ الضِّيقَةُ» ");
INSERT INTO arbnav_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","فَقَالَ رَأُوبَيْنُ: «أَلَمْ أَقُلْ لَكُمْ لَا تَجْنُوا عَلَيْهِ فَلَمْ تَسْمَعُوا؟ وَالآنَ هَا نَحْنُ مُطَالَبُونَ بِدَمِهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","وَلَمْ يَعْلَمُوا أَنَّ يُوسُفَ كَانَ فَاهِماً حَدِيثَهُمْ، لأَنَّهُ كَانَ يُخَاطِبُهُمْ عَنْ طَرِيقِ مُتَرْجِمٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","فَتَحَوَّلَ عَنْهُمْ وَبَكَى، ثُمَّ رَجَعَ إِلَيْهِمْ وَخَاطَبَهُمْ، وَأَخَذَ شِمْعُونَ وَقَيَّدَهُ أَمَامَ عُيُونِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ثُمَّ أَمَرَ يُوسُفُ مُوَظَّفِيهِ أَنْ يَمْلَأُوا أَكْيَاسَهُمْ بِالْقَمْحِ، وَأَنْ يَرُدُّوا فِضَّةَ كُلِّ وَاحِدٍ مِنْهُمْ إِلَى كِيسِهِ، وَأَنْ يُعْطُوهُمْ زَاداً لِلطَّرِيقِ. فَفَعَلُوا ذَلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","فَحَمَّلُوا حَمِيرَهُمُ الْقَمْحَ وَانْطَلَقُوا مِنْ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","وَحِينَ فَتَحَ أَحَدُهُمْ كِيسَهُ فِي الْخَانِ لِيَعْلِفَ حِمَارَهُ، لَمَحَ فِضَّتَهُ لأَنَّهَا كَانَتْ مَوْضُوعَةً فِي فَمِ الْكِيسِ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","فَقَالَ لإِخْوَتِهِ: «لَقَدْ رُدَّتْ إِلَيَّ فِضَّتِي، انْظُرُوا هَا هِيَ فِي كِيسِي». فَغَاصَتْ قُلُوبُهُمْ، وَتَطَلَّعَ بَعْضُهُمْ إِلَى بَعْضٍ مُرْتَعِدِينَ وَقَالُوا: «مَا هَذَا الَّذِي فَعَلَهُ اللهُ بِنَا؟». ");
INSERT INTO arbnav_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","وَعِنْدَمَا قَدِمُوا عَلَى أَبِيهِمْ يَعْقُوبَ فِي أَرْضِ كَنْعَانَ قَصُّوا عَلَيْهِ مَا حَلَّ بِهِمْ، وَقَالُوا: ");
INSERT INTO arbnav_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«الرَّجُلُ الْمُتَسَلِّطُ عَلَى مِصْرَ خَاطَبَنَا بِجَفَاءٍ، وَظَنَّ أَنَّنَا جَوَاسِيسُ عَلَى الأَرْضِ، ");
INSERT INTO arbnav_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","فَقُلْنَا لَهُ: نَحْنُ أُمَنَاءُ وَلَسْنَا جَوَاسِيسَ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","نَحْنُ اثْنَا عَشَرَ أَخاً أَبْنَاءُ أَبِينَا. أَحَدُنَا مَفْقُودٌ، وَالأَصْغَرُ بَقِيَ الْيَوْمَ مَعَ أَبِينَا فِي أَرْضِ كَنْعَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","فَقَالَ لَنَا الرَّجُلُ سَيِّدُ الْبِلادِ: لِكَيْ أَتَحَقَّقَ مِنْ كَوْنِكُمْ أُمَنَاءَ. دَعُوا أَخاً وَاحِداً مِنْكُمْ عِنْدِي رَهِينَةً وَخُذُوا طَعَاماً لِبُيُوتِكُمُ الْجَائِعَةِ وَامْضُوا، ");
INSERT INTO arbnav_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ثُمَّ أَحْضِرُوا لِي أَخَاكُمُ الأَصْغَرَ، وَبَذَلِكَ أَعْرِفُ أَنَّكُمْ لَسْتُمْ جَوَاسِيسَ بَلْ قَوْماً أُمَنَاءَ، فَأُطْلِقَ لَكُمْ أَخَاكُمْ وَتَتَّجِرُونَ فِي الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","وَإِذْ شَرَعُوا فِي تَفْرِيغِ أَكْيَاسِهِمْ وَجَدَ كُلُّ وَاحِدٍ مِنْهُمْ فِضَّتَهُ فِي كِيسِهِ، وَمَا إِنْ رَأَوْا هُمْ وَأَبُوهُمْ ذَلِكَ حَتَّى اسْتَبَدَّ بِهِمِ الْخَوْفُ. ");
INSERT INTO arbnav_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","فَقَالَ لَهُمْ أَبُوهُمْ: «لَقَدْ أَثْكَلْتُمُونِي أَوْلادِي. يُوسُفُ مَفْقُودٌ، وَشِمْعُونُ مَفْقُودٌ، وَهَا أَنْتُمْ تَأْخُذُونَ بِنْيَامِينَ بَعِيداً! كُلُّ هَذِهِ الدَّوَاهِي حَلَّتْ بِي!» ");
INSERT INTO arbnav_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","فَقَالَ لَهُ رَأُوبَيْنُ: «اقْتُلِ ابْنَيَّ إِنْ لَمْ أَرْجِعْ بِهِ إِلَيْكَ. اعْهَدْ بِهِ إِلَيَّ وَأَنَا أَرُدُّهُ إِلَيْكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","فَقَالَ: «لَنْ يَذْهَبَ ابْنِي مَعَكُمْ، فَقَدْ مَاتَ أَخُوهُ، وَهُوَ وَحْدَهُ بَاقٍ. فَإِنْ نَالَهُ مَكْرُوهٌ فِي الطَّرِيقِ الَّتِي تَذْهَبُونَ فِيهَا، فَإِنَّكُمْ تُنْزِلُونَ شَيْبَتِي بِحُزْنٍ إِلَى قَبْرِي». ");
INSERT INTO arbnav_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","وَتَفَاقَمَتِ الْمَجَاعَةُ فِي الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","وَلَمَّا اسْتَهْلَكُوا الْقَمْحَ الَّذِي أَحْضَرُوهُ مِنْ مِصْرَ، قَالَ لَهُمْ أَبُوهُمْ: «ارْجِعُوا وَاشْتَرُوا لَنَا قَلِيلاً مِنَ الطَّعَامِ». ");
INSERT INTO arbnav_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","فَقَالَ يَهُوذَا: «لَقَدْ حَذَّرَنَا الرَّجُلُ أَشَدَّ تَحْذِيرٍ وَقَالَ: لَنْ تَرَوْا وَجْهِي مَا لَمْ يَكُنْ أَخُوكُمْ مَعَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","فَإِنْ كُنْتَ تُرْسِلُ أَخَانَا مَعَنَا، نَمْضِي وَنَشْتَرِي لَكَ طَعَاماً ");
INSERT INTO arbnav_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","وَإلَّا فَلَنْ نَذْهَبَ لأَنَّ الرَّجُلَ قَالَ لَنَا: لَا تَرَوْا وَجْهِي مَا لَمْ يَكُنْ أَخُوكُمْ مَعَكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","فَقَالَ إِسْرَائِيلُ: «لِمَاذَا أَسَأْتُمْ إِلَيَّ فَأَخْبَرْتُمُ الرَّجُلَ أَنَّ لَكُمْ أَخاً أَيْضاً؟» ");
INSERT INTO arbnav_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","فَأَجَابُوا: «إِنَّ الرَّجُلَ قَدْ دَقَّقَ فِي اسْتِجْوَابِنَا عَنْ أَنْفُسِنَا وَعَنْ عَشِيرَتِنَا سَائِلاً: هَلْ أَبُوكُمْ حَيٌّ بَعْدُ؟ هَلْ لَكُمْ أَخٌ؟ فَأَجَبْنَاهُ حَسَبَ أَسْئِلَتِهِ. فَمِنْ أَيْنَ لَنَا أَنْ نَعْرِفَ أَنَّهُ سَيَقُولُ: أَحْضِرُوا أَخَاكُمْ إِلَى هُنَا؟» ");
INSERT INTO arbnav_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","وَقَالَ يَهُوذَا لإِسْرَائِيلَ أَبِيهِ: «أَرْسِلِ الْغُلامَ مَعِي فَنَقُومَ وَنَذْهَبَ فَنَحْيَا وَلا نَمُوتَ نَحْنُ وَأَنْتَ وَأَوْلادُنَا جَمِيعاً. ");
INSERT INTO arbnav_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","وَأَنَا ضَامِنٌ لَهُ. مِنْ يَدِي تَطْلُبُهُ. فَإِنْ لَمْ أَرُدَّهُ إِلَيْكَ وَأُوقِفْهُ أَمَامَكَ، أَكُنْ مُذْنِباً إِلَيْكَ كُلَّ الأَيَّامِ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","فَلَوْ لَمْ نَتَوَانَ فِي السَّفَرِ لَكُنَّا قَدْ رَجَعْنَا مَرَّتَيْنِ». ");
INSERT INTO arbnav_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","فَقَالَ لَهُمْ أَبُوهُمْ: «إِنْ كَانَ لابُدَّ مِنْ ذَلِكَ فَافْعَلُوا. وَخُذُوا مَعَكُمْ هَدِيَّةً لِلرَّجُلِ: وَامْلَأُوا أَوْعِيَتَكُمْ مِنْ أَحْسَنِ مَا تُنْتِجُهُ الأَرْضُ وَقَلِيلاً مِنَ الْبَلَسَانِ وَالْعَسَلِ وِالتَّوَابِلِ الْمُرِّ وَالْفُسْتُقِ وَاللَّوْزِ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","وَخُذُوا مَعَكُمْ فِضَّةً أُخْرَى، وَالْفِضَّةَ الْمَرْدُودَةَ فِي أَفْوَاهِ أَكْيَاسِكُمْ وَأَعِيدُوهَا. فَلَعَلَّ فِي الأَمْرِ سَهْواً. ");
INSERT INTO arbnav_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","وَاسْتَصْحِبُوا مَعَكُمْ أَيْضاً أَخَاكُمْ وَقُومُوا ارْجِعُوا إِلَى الرَّجُلِ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","وَلْيُنْعِمْ عَلَيْكُمُ اللهُ الْقَدِيرُ بِالرَّحْمَةِ لَدَى الرَّجُلِ، فَيُطْلِقَ لَكُمْ أَخَاكُمُ الآخَرَ وَبَنْيَامِينَ أَيْضاً. وَأَنَا إِنْ ثَكِلْتُهُمَا، أَكُونُ قَدْ ثَكِلْتُهُمَا». ");
INSERT INTO arbnav_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","فَأَخَذَ الرِّجَالُ تِلْكَ الْهَدِيَّةَ، وَضِعْفَ الْفِضَّةِ، وَبَنْيَامِينَ، وَسَافَرُوا إِلَى مِصْرَ وَمَثَلُوا أَمَامَ يُوسُفَ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","وَعِنْدَمَا شَاهَدَ يُوسُفُ بِنْيَامِينَ مَعَهُمْ قَالَ لِمُدَبِّرِ بَيْتِهِ: «أَدْخِلِ الرِّجَالَ إِلَى الْبَيْتِ وَاذْبَحْ ذَبِيحَةً وَهَيِّئْهَا، لأَنَّ هَؤُلاءِ الرِّجَالَ سَيَتَنَاوَلُونَ مَعِي الطَّعَامَ فِي سَاعَةِ الْغَذَاءِ». ");
INSERT INTO arbnav_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","فَفَعَلَ الرَّجُلُ كَمَا أَمَرَ يُوسُفُ، وَأَدْخَلَ الرِّجَالَ إِلَى بَيْتِ يُوسُفَ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","وَلَمَّا أُدْخِلُوا إِلَى بَيْتِ يُوسُفَ اعْتَرَاهُمُ الْخَوْفُ وَقَالُوا: «لَقَدْ جِيءَ بِنَا إِلَى هُنَا لِيَهْجُمَ عَلَيْنَا وَيَقَعَ بِنَا وَيَسْتَعْبِدَنَا وَيَسْتَوْلِيَ عَلَى حَمِيرِنَا، بِسَبَبِ الْفِضَّةِ الأُولَى الْمَرْدُودَةِ فِي أَكْيَاسِنَا». ");
INSERT INTO arbnav_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","فَتَقَدَّمُوا إِلَى مُدَبِّرِ بَيْتِ يُوسُفَ وَقَالُوا لَهُ عِنْدَ مَدْخَلِ الْبَابِ: ");
INSERT INTO arbnav_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«اسْتَمِعْ يَا سَيِّدِي، لَقَدْ قَدِمْنَا إِلَى هُنَا فِي الْمَرَّةِ الأُولَى لِنَشْتَرِيَ طَعَاماً، ");
INSERT INTO arbnav_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","وَلَكِنَّنَا حِينَ نَزَلْنَا فِي الْخَانِ وَفَتَحْنَا أَكْيَاسَنَا عَثَرَ كُلُّ رَجُلٍ مِنَّا عَلَى فِضَّتِهِ بِكَامِلِ وَزْنِهَا فِي فَمِ كِيسِهِ، فَأَحْضَرْنَاهَا مَعَنَا لِنَرُدَّهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","وَجِئْنَا مَعَنَا بِفِضَّةٍ أُخْرَى لِنَشْتَرِيَ طَعَاماً. وَلَسْنَا نَدْرِي مَنْ وَضَعَ فِضَّتَنَا فِي أَكْيَاسِنَا». ");
INSERT INTO arbnav_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","فَقَالَ: «سَلامٌ لَكُمْ، لَا تَخَافُوا، فَإِنَّ إِلَهَكُمْ وَإِلَهَ أَبِيكُمْ قَدْ وَهَبَكُمْ كَنْزاً فِي أَكْيَاسِكُمْ، أَمَّا فِضَّتُكُمْ فَقَدْ وَصَلَتْ إِلَيَّ». ثُمَّ أَخْرَجَ إِلَيْهِمْ شِمْعُونَ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","وَأَدْخَلَ الرَّجُلُ الْقَوْمَ إِلَى بَيْتِ يُوسُفَ وَقَدَّمَ لَهُمْ مَاءً لِيَغْسِلُوا أَرْجُلَهُمْ، وَعَلِيقاً لِحَمِيرِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","وَأَعَدُّوا الْهَدِيَّةَ فِي انْتِظَارِ مَجِيءِ يُوسُفَ عِنْدَ الظُّهْرِ، لأَنَّهُمْ سَمِعُوا أَنَّهُمْ سَيَتَنَاوَلُونَ الطَّعَامَ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","فَلَمَّا أَقْبَلَ يُوسُفُ إِلَى الْبَيْتِ أَحْضَرُوا إِلَيْهِ الْهَدِيَّةَ الَّتِي حَمَلُوهَا مَعَهُمْ إِلَى الْبَيْتِ، وَانْحَنَوْا أَمَامَهُ إِلَى الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","فَسَأَلَهُمْ عَنْ أَحْوَالِهِمْ، ثُمَّ قَالَ: «هَلْ أَبُوكُمُ الشَّيْخُ الَّذِي أَخْبَرْتُمْ عَنْهُ بِخَيْرٍ؟ أَمَازَالَ حَيًّا؟» ");
INSERT INTO arbnav_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","فَأَجَابُوا: «عَبْدُكَ أَبُونَا بِخَيْرٍ، وَهُوَ مَازَالَ حَيًّا». وَانْحَنَوْا وَسَجَدُوا. ");
INSERT INTO arbnav_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","وَتَلَفَّتَ فَرَأَى أَخَاهُ الشَّقِيقَ بِنْيَامِينَ، فَقَالَ: «أَهَذَا أَخُوكُمُ الأَصْغَرُ الَّذِي أَخْبَرْتُمُونِي عَنْهُ؟» ثُمَّ قَالَ: «لِيُنْعِمِ اللهُ عَلَيْكَ يَا ابْنِي». ");
INSERT INTO arbnav_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","وَانْدَفَعَ يُوسُفُ إِلَى مُخْدَعِهِ وَبَكَى هُنَاكَ لأَنَّ عَوَاطِفَهُ حَنَّتْ إِلَى أَخِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ثُمَّ غَسَلَ وَجْهَهُ وَخَرَجَ مُمْسِكاً نَفْسَهُ عَنْ الْبُكَاءِ، وَقَالَ: «قَدِّمُوا الطَّعَامَ». ");
INSERT INTO arbnav_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","فَقَدَّمُوا لَهُ وَحْدَهُ، وَلَهُمْ وَحْدَهُمْ، وَلِلْمِصْرِيِّينَ الآكِلِينَ مَعَهُ وَحْدَهُمْ، إِذْ أَنَّهُ مَحْظُورٌ عَلَى الْمِصْرِيِّينَ أَنْ يَأْكُلُوا مَعَ الْعِبْرَانِيِّينَ، لأَنَّ ذَلِكَ رِجْسٌ عِنْدَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","فَجَلَسُوا فِي مَحْضَرِهِ، كُلٌّ وَفْقاً لِعُمْرِهِ، مِنَ الْبِكْرِ حَتَّى الصَّغِيرِ. فَنَظَرُوا بَعْضُهُمْ إِلَى بَعْضٍ مُتَعَجِّبِين. ");
INSERT INTO arbnav_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","وَقَدَّمَ إِلَيْهِمْ حِصَصاً مِنْ مَائِدَتِهِ، فَكَانَتْ حِصَّةُ بِنْيَامِينَ خَمْسَةَ أَضْعَافِ حِصَصِ إِخْوَتِهِ. وَاحْتَفُوا وَشَرِبُوا مَعَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","وَأَمَرَ يُوسُفُ مَدَبِّرَ بَيْتِهِ قَائِلاً: «امْلأْ أَكْيَاسَ الرِّجَالِ بِالطَّعَامِ بِقَدْرِ وُسْعِهَا، وَرُدَّ فِضَّةَ كُلِّ رَجُلٍ إِلَى فَمِ كِيسِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","وَضَعْ فِي فَمِ كِيسِ الصَّغِيرِ كَأْسِيَ الْفِضِّيَّةَ وَثَمَنَ قَمْحِهِ». فَنَفَّذَ أَمْرَ يُوسُفَ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","وَمَا إِنْ أَشْرَقَ الصَّبَاحُ حَتَّى انْطَلَقَ الرِّجَالُ، هُمْ وَحَمِيرُهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","وَمَا كَادُوا يَبْتَعِدُونَ عَنِ الْمَدِينَةِ قَلِيلاً حَتَّى قَالَ يُوسُفُ لِمُدَبِّرِ بَيْتِهِ: «اسْعَ خَلْفَ الرِّجَالِ، وَمَا إِنْ تُدْرِكُهُمْ حَتَّى تَقُولَ لَهُمْ: لِمَاذَا تُكَافِئُونَ الْخَيْرَ بِالشَّرِّ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","أَلَيْسَتْ هَذِهِ هِيَ الكَأْسُ الَّتِي يَشْرَبُ فِيهَا سَيِّدِي وَيَتَفَاءَلُ بِالْغَيْبِ؟ لَشَدَّ مَا أَسَأْتُمْ فِي مَا صَنَعْتُمْ». ");
INSERT INTO arbnav_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","فَلَمَّا أَدْرَكَهُمْ خَاطَبَهُمْ بِهَذَا الْقَوْلِ، فَأَجَابُوهُ: ");
INSERT INTO arbnav_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","«لِمَاذَا يَتَكَلَّمُ سَيِّدِي بِمِثْلِ هَذَا الْكَلامِ؟ حَاشَا لِعَبِيدِكَ أَنْ يَرْتَكِبُوا هَذَا الأَمْرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","هُوَذَا الْفِضَّةُ الَّتِي عَثَرْنَا عَلَيْهَا فِي أَفْوَاهِ أَكْيَاسِنَا رَدَدْنَاهَا لَكَ مَعَنَا مِنْ أَرْضِ كَنْعَانَ، فَكَيْفَ نَسْرِقُ فِضَّةً أَوْ ذَهَباً مِنْ بَيْتِ سَيِّدِكَ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","مَنْ تَجِدْ مَعَهُ الْكَأْسَ مِنْ عَبِيدِكَ يَمُتْ، وَنَكُنْ نَحْنُ أَيْضاً عَبِيداً لِسَيِّدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","فَقَالَ: «فَلْيَكُنْ كَمَا تَقُولُونَ. فَالَّذِي أَجِدُهَا مَعَهُ يُصْبِحُ عَبْداً لِي، وَالْبَاقُونَ يَكُونُونَ أَبْرِيَاءَ». ");
INSERT INTO arbnav_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","فَبَادَرَ كُلٌّ مِنْهُمْ إِلَى كِيسِهِ وَحَطَّهُ عَلَى الأَرْضِ وَفَتَحَهُ، ");
INSERT INTO arbnav_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","فَفَتَّشَ مُبْتَدِئاً مِنْ كِيسِ الْكَبِيرِ حَتَّى انْتَهَى إِلَى كِيسِ الصَّغِيرِ، فَعَثَرَ عَلَى الْكَأْسِ فِي كِيسِ بِنْيَامِينَ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","فَمَزَّقُوا ثِيَابَهُمْ وَحَمَلَ كُلٌّ مِنْهُمْ كِيسَهُ عَلَى حِمَارِهِ وَرَجَعُوا إِلَى الْمَدِينَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","وَدَخَلَ يَهُوذَا وَإخْوَتُهُ إِلَى بَيْتِ يُوسُفَ إِذْ كَانَ مَا بَرِحَ هُنَاكَ، فَارْتَمَوا أَمَامَهُ إِلَى الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","فَقَالَ لَهُمْ يُوسُفُ: «أَيُّ جِنَايَةٍ اقْتَرَفْتُمْ؟ أَمَا عَلِمْتُمْ أَنَّ رَجُلاً مِثْلِي يَسْتَخْدِمُ كَأْسَهُ فِي مَعْرِفَةِ الْغَيْبِ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","فَقَالَ يَهُوذَا: «مَاذَا نَقُولُ لِسَيِّدِي، وَبِمَاذَا نُخَاطِبُهُ، وَكَيْفَ نُبْرِئُ أَنْفُسَنَا؟ إِنَّ اللهَ قَدْ فَضَحَ إِثْمَ عَبِيدِكَ. فَنَحْنُ وَمَنْ عُثِرَ مَعَهُ عَلَى الْكَأْسِ عَبِيدٌ لِسَيِّدِي». ");
INSERT INTO arbnav_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","فَقَالَ: «حَاشَا لِي أَنْ أَفْعَلَ هَذَا؛ إِنَّمَا الرَّجُلُ الَّذِي عُثِرَ مَعَهُ عَلَى الْكَأْسِ هُوَ يَكُونُ لِي عَبْداً، أَمَّا أَنْتُمْ فَامْضُوا إِلَى أَبِيكُمْ بِأَمَانٍ». ");
INSERT INTO arbnav_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","فَتَقَدَّمَ مِنْهُ يَهُوذَا وَقَالَ: «يَا سَيِّدِي، دَعْ عَبْدَكَ يَنْطِقُ بِكَلِمَةٍ فِي مَسْمَعِ سَيِّدِي، وَلا يَحْتَدِمْ غَضَبُكَ عَلَى عَبْدِكَ، لأَنَّ سُلْطَتَكَ مُمَاثِلَةٌ لِسُلْطَةِ فِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","لَقَدْ سَأَلَ سَيِّدِي عَبِيدَهُ: أَلَكُمْ أَبٌ أَوْ أَخٌ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","فَأَجَبْنَا سَيِّدِي: لَنَا أَبٌ شَيْخٌ، وَابْنُ شَيْخُوخَةٍ صَغِيرٌ مَاتَ أَخُوهُ الشَّقِيقُ وَبَقِيَ هُوَ وَحْدَهُ مِنْ أُمِّهِ، وَأَبُوهُ يُحِبُّهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","فَقُلْتَ لِعَبِيدِكَ: أَحْضِرُوهُ إِلَيَّ لأَرَاهُ بِعَيْنَيَّ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","فَقُلْنَا لِسَيِّدِي: لَا يَقْدِرُ الْغُلامُ أَنْ يَتْرُكَ أَبَاهُ لِئَلّا يَمُوتَ أَبُوهُ إِذَا فَارَقَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","فَقُلْتَ لِعَبِيدِكَ: مَا لَمْ تُحْضِرُوا أَخَاكُمْ إِلَيَّ لَا تَرَوْنَ وَجْهِي بَعْدُ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","فَعِنْدَمَا قَدِمْنَا عَلَى عَبْدِكَ أَبِي، أَخْبَرْنَاهُ بِحَدِيثِ سَيِّدِي. ");
INSERT INTO arbnav_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","فَقَالَ أَبُونَا: ارْجِعُوا وَاشْتَرُوا لَنَا بَعْضَ الطَّعَامِ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","فَأَجَبْنَا: لَا يُمْكِنُنَا أَنْ نَذْهَبَ إِلَى هُنَاكَ مَا لَمْ نَأْخُذْ أَخَانَا مَعَنَا، لأَنَّنَا لَا نَقْدِرُ أَنْ نُقَابِلَ الرَّجُلَ مَا لَمْ يَكُنْ أَخُونَا الصَّغِيرُ مَعَنَا. ");
INSERT INTO arbnav_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","فَقَالَ لَنَا عَبْدُكَ أَبُونَا: أَنْتُمْ تَعْلَمُونَ أَنَّ زَوْجَتِي قَدْ أَنْجَبَتْ لِيَ ابْنَيْنِ، ");
INSERT INTO arbnav_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","فَقَدْتُ أَحَدَهُمَا وَقُلْتُ: إِنَّمَا هُوَ قَدِ افْتُرِسَ افْتِرَاساً. وَلَمْ أَرَهُ إِلَى الآنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","فَإِنْ أَخَذْتُمْ هَذَا مِنِّي، وَلَحِقَهُ مَكْرُوهٌ، تُنْزِلُونَنِي إِلَى الْقَبْرِ بِشَيْبَةٍ شَقِيَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","فَإِذَا عُدْتُ إِلَى عَبْدِكَ أَبِي الَّذِي تَعَلَّقَتْ نَفْسُهُ بِنَفْسِ الْغُلامِ، وَلَمْ يَكُنِ الْغُلامُ مَعَنَا، ");
INSERT INTO arbnav_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","وَرَأَى أَنَّ الْغُلامَ مَفْقُودٌ، فَإِنَّهُ يَمُوتُ، وَيُوَارِي عَبِيدُكَ شَيْبَةَ عَبْدِكَ أَبِيهِمْ بِشَقَاءٍ فِي الْقَبْرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","لأَنَّ عَبْدَكَ ضَمِنَ الْغُلامَ لأَبِي، وَقُلْتُ: إِنْ لَمْ أُرْجِعْهُ إِلَيْكَ أَكُنْ مُذْنِباً إِلَيْكَ مَدَى الْحَيَاةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","فَأَرْجُو مِنْ سَيِّدِي أَنْ يَتَّخِذَنِي عَبْداً لَهُ بَدَلاً مِنْ الْغُلامِ، وَدَعِ الْغُلامَ يَمْضِي مَعَ بَقِيَّةِ إِخْوَتِهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","إِذْ كَيْفَ يُمْكِنُنِي أَنْ أَرْجِعَ إِلَى أَبِي وَالْغُلامُ لَيْسَ مَعِي وَأَشْهَدَ مَا يَحِلُّ بِهِ مِنَ الشَّرِّ؟». ");
INSERT INTO arbnav_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","فَلَمْ يَسْتَطِعْ يُوسُفُ أَنْ يَتَمَالَكَ نَفْسَهُ أَمَامَ الْمَاثِلِينَ أَمَامَهُ، فَصَرَخَ: «لِيَخْرُجِ الْجَمِيعُ مِنْ هُنَا». فَلَمْ يَبْقَ أَحَدٌ مَعَ يُوسُفَ حِينَ كَشَفَ عَنْ نَفْسِهِ لإِخْوَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","وَبَكَى بِصَوْتٍ عَالٍ فَسَمِعَ الْمِصْرِيُّونَ كَمَا سَمِعَ بَيْتُ فِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","وَقَالَ يُوسُفُ لإِخْوَتِهِ: «أَنَا يُوسُفُ. فَهَلْ أَبِي مَازَالَ حَيًّا؟» فَلَمْ يَسْتَطِعْ إِخْوَتُهُ أَنْ يُجِيبُوهُ لأَنَّهُمُ امْتَلأُوا رُعْباً مِنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","فَقَالَ يُوسُفُ لإِخْوَتِهِ: «اُدْنُوا مِنِّي». فَاقْتَرَبُوا مِنْهُ، فَقَالَ: «أَنَا يُوسُفُ أَخُوكُمُ الَّذِي بِعْتُمُوهُ إِلَى مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","فَلا تَتَأَسَّفُوا الآنَ، وَلا يَصْعُبْ عَلَيْكُمْ أَنَّكُمْ بِعْتُمُونِي إِلَى هُنَا، لأَنَّ اللهَ أَرْسَلَنِي أَمَامَكُمْ حِفَاظاً عَلَى حَيَاتِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","فَقَدْ صَارَ لِلْمَجَاعَةِ فِي هَذِهِ الأَرْضِ سَنَتَانِ، وَبَقِيَتْ خَمْسُ سَنَوَاتٍ لَنْ يَكُونَ فِيهَا فَلاحَةٌ وَلا حَصَادٌ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","وَقَدْ أَرْسَلَنِي اللهُ أَمَامَكُمْ لِيَجْعَلَ لَكُمْ بَقِيَّةً فِي الأَرْضِ وَيُنْقِذَ حَيَاتَكُمْ بِخَلاصٍ عَظِيمٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","فَلَسْتُمْ إِذاً أَنْتُمُ الَّذِينَ أَرْسَلْتُمُونِي إِلَى هُنَا بَلِ اللهُ، الَّذِي جَعَلَنِي مُسْتَشَاراً لِفِرْعَوْنَ وَسَيِّداً لِكُلِّ بَيْتِهِ، وَمُتَسَلِّطاً عَلَى جَمِيعِ أَرْضِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","فَأَسْرِعُوا وَارْجِعُوا إِلَى أَبِي وَقُولُوا لَهُ: ابْنُكَ يُوسُفُ يَقُولُ: لَقَدْ أَقَامَنِي اللهُ سَيِّداً عَلَى كُلِّ مِصْرَ. تَعَالَ وَلا تَتَبَاطَأْ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","فَتُقِيمَ فِي أَرْضِ جَاسَانَ لِتَكُونَ قَرِيباً مِنِّي أَنْتَ وَبَنُوكَ وَأَحْفَادُكَ وَغَنَمُكَ وَبَقَرُكَ وَكُلُّ مَالَكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","وَأَعُولُكَ هُنَاكَ لأَنَّ الْجُوعَ سَيَسْتَمِرُّ خَمْسَ سَنَوَاتٍ أُخْرَى، فَلا تَحْتَاجُ أَنْتَ وَعَائِلَتُكَ وَبَهَائِمُكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","وَهَا أَنْتُمْ وَأَخِي بِنْيَامِينُ شُهُودٌ أَنَّنِي أَنَا حَقّاً الَّذِي يُخَاطِبُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","وَتُحَدِّثُونَ أَبِي عَنْ كُلِّ مَجْدِي فِي مِصْرَ وَعَمَّا شَهِدْتُمُوهُ. وَتُسْرِعُونَ فِي إِحْضَارِ أَبِي إِلَى هُنَا». ");
INSERT INTO arbnav_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ثُمَّ تَعَانَقَ يُوسُفُ وَبِنْيَامِينُ وَبَكَيَا ");
INSERT INTO arbnav_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","وَقَبَّلَ يُوسُفُ بَاقِي إِخْوَتِهِ وَبَكَى مَعَهُمْ. وَعِنْدَئِذٍ فَقَطْ تَجَرَّأَ إِخْوَتُهُ عَلَى مُخَاطَبَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","وَسَرَى الْخَبَرُ إِلَى بَيْتِ فِرْعَوْنَ وَقِيلَ قَدْ جَاءَ إِخْوَةُ يُوسُفَ، فَسَرَّ ذَلِكَ فِرْعَوْنَ، وَعَبِيدَهُ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","وَقَالَ فِرْعَوْنُ لِيُوسُفَ: «اطْلُبْ مِنْ إِخْوَتِكَ أَنْ يُحَمِّلُوا دَوَابَهُمْ بِالْقَمْحِ وَيَرْجِعُوا إِلَى أَرْضِ كَنْعَانَ، ");
INSERT INTO arbnav_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","لِيُحْضِرُوا أَبَاهُمْ وَأُسَرَهُمْ وَيَجِيئُوا إِلَيَّ، فَأُعْطِيَهُمْ أَفْضَلَ أَرْضِ مِصْرَ لِيَسْتَمْتِعُوا بِخَيْرَاتِهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","وَقَدْ صَدَرَ أَمْرٌ إِلَيْكَ أَنْ يَأْخُذُوا لَهُمْ عَرَبَاتٍ مِنْ أَرْضِ مِصْرَ لِيَنْقُلُوا عَلَيْهَا أَوْلادَهُمْ وَزَوْجَاتِهِمْ وَأَبَاهُمْ وَيَحْضُرُوا إِلَى هُنَا. ");
INSERT INTO arbnav_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","لَا يَكْتَرِثُوا لِمَا يُخَلِّفُونَهُ مِنْ مَتَاعٍ، فَخَيْرَاتُ أَرْضِ مِصْرَ كُلِّهَا هِيَ لَهُمْ». ");
INSERT INTO arbnav_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","فَفَعَلَ بَنُو إِسْرَائِيلَ هَكَذَا، وَأَعْطَاهُمْ يُوسُفُ عَرَبَاتٍ حَسَبَ أَمْرِ فِرْعَوْنَ وَمَؤُونَةً لِلطَّرِيقِ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","وَأَعْطَى كُلَّ وَاحِدٍ مِنْهُمْ حُلَلَ ثِيَابٍ. أَمَّا بِنْيَامِينُ فَخَصَّهُ بِثَلاثِ مِئَةِ قِطْعَةٍ مِنَ الْفِضَّةِ وَخَمْسِ حُلَلِ ثِيَابٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","وَأَرْسَلَ إِلَى أَبِيهِ عَشَرَةَ حَمِيرٍ مُحَمَّلَةٍ بِأَفْضَلِ خَيْرَاتِ مِصْرَ وَعَشْرَ أُتُنٍ مُثْقَلَةٍ بِالْحِنْطَةِ وَخُبْزاً وَطَعَاماً يَقْتَاتُ مِنْهَا فِي الطَّرِيقِ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","وَهَكَذَا صَرَفَ إِخْوَتَهُ بَعْدَ أَنْ أَوْصَاهُمْ: «لا تَتَخَاصَمُوا فِي الطَّرِيقِ». ");
INSERT INTO arbnav_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","وَانْطَلَقُوا مِنْ مِصْرَ حَتَّى أَقْبَلُوا إِلَى أَرْضِ كَنْعَانَ إِلَى أَبِيهِمْ يَعْقُوبَ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","فَقَالُوا لَهُ: «إِنَّ يُوسُفَ مَازَالَ حَيًّا، وَهُوَ الْمُتَسَلِّطُ عَلَى كُلِّ أَرْضِ مِصْرَ». فَغُشِيَ عَلَى قَلْبِ يَعْقُوبَ لأَنَّهُ لَمْ يُصَدِّقْهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ثُمَّ حَدَّثُوهُ بِكَلامِ يُوسُفَ. وَعِنْدَمَا عَايَنَ يَعْقُوبُ الْعَرَبَاتِ الَّتِي أَرْسَلَهَا يُوسُفُ لِتَنْقُلَهُ، انْتَعَشَتْ رُوحُهُ، ");
INSERT INTO arbnav_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","وَقَالَ: «كَفَى! يُوسُفُ ابْنِي حَيٌّ بَعْدُ، سَأَذْهَبُ لأَرَاهُ قَبْلَ أَنْ أَمُوتَ». ");
INSERT INTO arbnav_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","وَارْتَحَلَ إِسْرَائِيلُ وَكُلُّ مَالَهُ حَتَّى وَصَلَ إِلَى بِئْرِ سَبْعٍ، فَقَدَّمَ ذَبَائِحَ إِلَى إِلَهِ أَبِيهِ إِسْحاقَ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","وَقَالَ اللهُ لإِسْرَائِيلَ فِي رُؤَى اللَّيْلِ: «يَعْقُوبُ، يَعْقُوبُ». فَأَجَابَ: «هَا أَنَا» ");
INSERT INTO arbnav_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","فَقَالَ: «أَنَا هُوَ اللهُ، إِلَهُ أَبِيكَ. لَا تَخَفْ مِنَ الذَّهَابِ إِلَى مِصْرَ لأَنِّي أَجْعَلُكَ أُمَّةً عَظِيمَةً هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","أَنَا أَصْحَبُكَ إِلَى مِصْرَ، وَأَنَا أُرْجِعُكَ أَيْضاً، وَيُغْمِضُ يُوسُفُ أَجْفَانَكَ بِيَدَيْهِ عِنْدَ مَوْتِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","فَانْطَلَقَ يَعْقُوبُ مِنْ بِئْرِ سَبْعٍ. وَحَمَلَ بَنُو إِسْرَائِيلَ يَعْقُوبَ أَبَاهُمْ وَأَوْلادَهُمْ وَزَوْجَاتِهِمْ فِي الْعَرَبَاتِ الَّتِي أَرْسَلَهَا فِرْعَوْنُ لِنَقْلِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","وَأَخَذُوا مَعَهُمْ مَوَاشِيَهُمْ وَمُقْتَنَيَاتِهِمِ الَّتِي اقْتَنَوْهَا فِي أَرْضِ كَنْعَانَ وَجَاءُوا جَمِيعاً إِلَى مِصْرَ، ");
INSERT INTO arbnav_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","فَقَدْ صَحِبَ يَعْقُوبُ مَعَهُ إِلَى مِصْرَ أَبْنَاءَهُ وَأَحْفَادَهُ مِنْ بَنِينَ وَبَنَاتٍ، وَسَائِرَ ذُرِّيَّتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","وَهَذِهِ أَسْمَاءُ أَبْنَاءِ إِسْرَائِيلَ الَّذِينَ قَدِمُوا مَعَهُ إِلَى مِصْرَ. يَعْقُوبُ وَأَبْنَاؤُهُ: رَأُوبَيْنُ بِكْرُ يَعْقُوبَ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","وَأَبْنَاءُ رَأُوبَيْنَ: حَنُوكُ وَفَلُّو وَحَصْرُونُ وَكَرْمِي. ");
INSERT INTO arbnav_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","وَأَبْنَاءُ شِمْعُونَ: يَمُوئِيلُ وَيَامِينُ وَأُوهَدُ وَيَاكِينُ وَصُوحَرُ وَشَأُولُ ابْنُ الْكَنْعَانِيَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","وَأَبْنَاءُ لاوِي: جِرْشُونُ وَقَهَاتُ وَمَرَارِي. ");
INSERT INTO arbnav_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","وَأَبْنَاءُ يَهُوذَا: عِيرٌ وَأُونَانُ وَشِيلَةُ وَفَارَصُ وَزَارَحُ. وَمَاتَ عِيرٌ وَأُونَانُ فِي أَرْضِ كَنْعَانَ. وَأَمَّا ابْنَا فَارَصَ فَهُمَا حَصْرُونُ وَحَامُولُ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","وَأَبْنَاءُ يَسَّاكَرَ: تُولاعُ وَفَوَّةُ وَيُوبٌ وَشِمْرُونُ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","وَأَبْنَاءُ زَبُولُونَ: سَارَدُ وَإِيلُونُ وَيَاحَلْئِيلُ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","هَؤُلاءِ جَمِيعُهُمْ أَبْنَاءُ لَيْئَةَ الَّذِينَ أَنْجَبَتْهُمْ لِيَعْقُوبَ فِي سَهْلِ أَرَامَ، فَضْلاً عَنِ ابْنَتِهِ دِينَةَ. فَكَانَ مَجْمُوعُ عَدَدِ بَنِيهِ وَبَنَاتِهِ وَأَحْفَادِهِ مِنْ لَيْئَةَ ثَلاثَةً وَثَلاثِينَ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","وَأَبْنَاءُ جَادٍ صِفْيُونُ وَحَجِّي وَشُونِي وَأَصْبُونَ وَعِيرِي وَأَرُودِي وَأَرْئِيلِي. ");
INSERT INTO arbnav_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","وَأَبْنَاءُ أَشِيرَ: يِمْنَةُ وَيِشْوَةُ وَيِشْوِيُ وَبَرِيعَةُ وَأُخْتُهُمْ سَارَحُ. أَمَّا ابْنَا بَرِيعَةَ فَهُمَا حَابَرُ وَمَلْكِيئِيلُ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","هُؤُلاءِ هُمْ بَنُو زِلْفَةَ جَارِيَةِ لَيْئَةَ الَّتِي وَهَبَهَا إِيَّاهَا لابَانُ. فَكَانَ عَدَدُ ذُرِّيَّتِهَا الَّتِي أَنْجَبَتْهَا لِيَعْقُوبَ سِتَّ عَشْرَةَ نَفْساً. ");
INSERT INTO arbnav_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","أَمَّا ابْنَا رَاحِيلَ زَوْجَةِ يَعْقُوبَ فَهُمَا يُوسُفُ وَبِنْيَامِينُ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","وَوُلِدَ لِيُوسُفَ فِي أَرْضِ مِصْرَ مَنَسَّى وَأَفْرَايِمُ اللَّذَانِ أَنْجَبَتْهُمَا لَهُ أَسْنَاتُ ابْنَةُ فُوطِيفَارَعَ كَاهِنِ أُونٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","وَأَبْنَاءُ بِنْيَامِينَ بَالَعُ وَبَاكَرُ وَأَشْبِيلُ وَجِيرَا وَنَعْمَانُ وَإِيحِي وَرُوشُ وَمُفِّيمُ وَحُفِّيمُ وَأَرْدُ ");
INSERT INTO arbnav_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","هَؤُلاءِ ذُرِّيَّةُ رَاحِيلَ الَّذِينَ وُلِدُوا لِيَعْقُوبَ. وَعَدَدُهُمْ جَمِيعاً أَرْبَعَةَ عَشَرَ شَخْصاً. ");
INSERT INTO arbnav_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","وَابْنُ دَانٍ هُوَ حُوشِيمُ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","وَأَبْنَاءُ نَفْتَالِي: يَاحَصْئِيلُ وَجُونِي وَيِصْرُ وَشِلِّيمُ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","هَؤُلاءِ بَنُو يَعْقُوبَ الَّذِينَ أَنْجَبَتْهُمْ لَهُ بِلْهَةُ جَارِيَةُ رَاحِيلَ الَّتِي أَعْطَاهَا إِيَّاهَا أَبُوهَا لابَانُ، وَعَدَدُهُمْ جَمِيعاً سَبْعَةُ أَشْخَاصٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","فَكَانَ عَدَدُ جَمِيعِ الأَشْخَاصِ الْخَارِجِينَ مِنْ صُلْبِ يَعْقُوبَ، مِمَّنْ وَفَدُوا إِلَى مِصْرَ، سِتَّةً وَسِتِّينَ شَخْصاً مَاعَدَا زَوْجَاتِ أَبْنَائِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","وَابْنَا يُوسُفَ اللَّذَانِ وُلِدَا لَهُ فِي مِصْرَ هُمَا شَخْصَانِ. فَيَكُونُ عَدَدُ نُفُوسِ بَيْتِ يَعْقُوبَ الَّتِي قَدِمَتْ إِلَى مِصْرَ سَبْعِينَ نَفْساً. ");
INSERT INTO arbnav_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","وَأَرْسَلَ يَعْقُوبُ يَهُوذَا أَمَامَهُ إِلَى يُوسُفَ لِيَدُلَّهُ عَلَى الطَّرِيقِ الْمُؤَدِّيَةِ إِلَى جَاسَانَ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","فَأَعَدَّ يُوسُفُ مَرْكَبَتَهُ وَصَعِدَ لِلِقَاءِ أَبِيهِ إِسْرَائِيلَ فِي جَاسَانَ. وَمَا إِنْ أَقْبَلَ عَلَيْهِ حَتَّى عَانَقَهُ يُوسُفُ وَبَكَى زَمَاناً طَوِيلاً. ");
INSERT INTO arbnav_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","وَقَالَ إِسْرَائِيلُ لِيُوسُفَ: «دَعْنِي أَمُوتُ الآنَ إِذْ قَدْ أَبْصَرْتُ وَجْهَكَ وَرَأَيْتُ أَنَّكَ مَازِلْتَ حَيًّا». ");
INSERT INTO arbnav_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","وَخَاطَبَ يُوسُفُ إخْوَتَهُ وَبَيْتَ أَبِيهِ: «أَنَا مَاضٍ الآنَ إِلَى فِرْعَوْنَ لأُخْبِرَهُ أَنَّ إخْوَتِي وَبَيْتَ أَبِي الْمُقِيمِينَ فِي أَرْضِ كَنْعَانَ قَدْ قَدِمُوا إِلَيَّ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","وَهُمْ رُعَاةُ غَنَمٍ، وَحِرْفَتُهُمْ رِعَايَةُ الْمَوَاشِي، لِذَلِكَ أَحْضَرُوا مَعَهُمْ غَنَمَهُمْ وَبَقَرَهُمْ وَكُلَّ مَالَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","فَإِذَا دَعَاكُمْ وَسَأَلَكُمْ: مَا حِرْفَتُكُمْ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","قُولُوا: حِرْفَتُنَا رِعَايَةُ الْمَوَاشِي مُنْذُ صِبَانَا إِلَى الآنَ، كَذَلِكَ نَحْنُ وَهَكَذَا كَانَ آبَاؤُنَا جَمِيعاً. لِكَيْ تُقِيمُوا فِي أَرْضِ جَاسَانَ؛ لأَنَّ كُلَّ رَاعِي غَنَمٍ نَجِسٌ لَدَى الْمِصْرِيِّينَ». ");
INSERT INTO arbnav_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","وَمَثَلَ يُوسُفُ أَمَامَ فِرْعَوْنَ وَقَالَ لَهُ: «لَقَدْ جَاءَ أَبِي وَإِخْوَتِي مَعَ قُطْعَانِهِمْ وَمَوَاشِيهِمْ وَكُلِّ مَالَهُمْ مِنْ أَرْضِ كَنْعَانَ، وَهَا هُمُ الآنَ فِي أَرْضِ جَاسَانَ». ");
INSERT INTO arbnav_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","وَأَخَذَ خَمْسَةً مِنْ إِخْوَتِهِ وَقَدَّمَهُمْ إِلَى فِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","فَسَأَلَهُمْ فِرْعَوْنُ: «مَا هِيَ حِرْفَتُكُمْ؟» فَأَجَابُوهُ: «عَبِيدُكَ وَآبَاؤُهُمْ رُعَاةُ غَنَمٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","وَلَقَدْ جِئْنَا لِنَتَغَرَّبَ فِي الأَرْضِ إِذْ لَيْسَ لِغَنَمِ عَبِيدِكَ مَرْعىً مِنْ جَرَّاءِ وَطْأَةِ الْجُوعِ فِي أَرْضِ كَنْعَانَ، فَدَعْ عَبِيدَكَ يُقِيمُونَ فِي أَرْضِ جَاسَانَ». ");
INSERT INTO arbnav_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","فَقَالَ فِرْعَوْنُ لِيُوسُفَ: «لَقَدْ جَاءَ إِلَيْكَ أَبُوكَ وَإِخْوَتُكَ، ");
INSERT INTO arbnav_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","وَأَرْضُ مِصْرَ أَمَامَكَ، فَأَنْزِلْ أَبَاكَ وَإِخْوَتَكَ فِي أَفْضَلِ الأَرْضِ. دَعْهُمْ يُقِيمُونَ فِي أَرْضِ جَاسَانَ. وَإِنْ كُنْتَ تَعْرِفُ أَنَّ بَيْنَهُمْ ذَوِي خِبْرَةٍ فَاعْهَدْ إِلَيْهِمْ فِي الإِشْرَافِ عَلَى مَوَاشِيَّ». ");
INSERT INTO arbnav_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ثُمَّ أَحْضَرَ يُوسُفُ أَبَاهُ يَعْقُوبَ وَأَوْقَفَهُ أَمَامَ فِرْعَوْنَ، فَبَارَكَ يَعْقُوبُ فِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","وَسَأَلَ فِرْعَوْنُ يَعْقُوبَ: «كَمْ هُوَ عُمْرُكَ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","فَأَجَابَ يَعْقُوبُ فِرْعَوْنَ: «سَنَوَاتُ غُرْبَتِي مِئَةٌ وَثَلاثُونَ سَنَةً، قَلِيلَةٌ وَشَاقَّةٌ، وَلَمْ تَبْلُغْ سِنِي غُرْبَةِ آبَائِي». ");
INSERT INTO arbnav_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ثُمَّ بَارَكَ يَعْقُوبُ فِرْعَوْنَ وَخَرَجَ مِنْ لَدُنِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","وَأَنْزَلَ يُوسُفُ أَبَاهُ وَإِخْوَتَهُ فِي مِصْرَ وَمَلَّكَهُمْ فِي رَعَمْسِيسَ أَجْوَدَ الأَرْضِ كَمَا أَمَرَ فِرْعَوْنُ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","وَأَمَدَّ يُوسُفُ أَبَاهُ وَإِخْوَتَهُ وَأَهْلَ بَيْتِ أَبِيهِ بِالطَّعَامِ عَلَى حَسَبِ عَدَدِ أَوْلادِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","وَنَفَدَ الْخُبْزُ فِي جَمِيعِ الْبِلادِ لِشِدَّةِ الْمَجَاعَةِ، وَأَقْحَلَتْ أَرْضُ مِصْرَ وَأَرْضُ كَنْعَانَ مِنَ الْجُوعِ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","فَقَايَضَ يُوسُفُ الْقَمْحَ الَّذِي بِيعَ بِكُلِّ الْفِضَّةِ الْمَوْجُودَةِ فِي أَرْضِ مِصْرَ وَفِي أَرْضِ كَنْعَانَ، وَحَمَلَهَا إِلَى خَزِينَةِ فِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","وَعِنْدَمَا نَفَدَتِ الْفِضَّةُ مِنْ أَرْضِ مِصْرَ وَمِنْ أَرْضِ كَنْعَانَ أَقْبَلَ جَمِيعُ الْمِصْرِيِّينَ إِلَى يُوسُفَ قَائِلِينَ: «أَعْطِنَا خُبْزاً، فَلِمَاذَا نَمُوتُ أَمَامَ عَيْنَيْكَ؟ إِنَّ فِضَّتَنَا قَدْ نَفَدَتْ». ");
INSERT INTO arbnav_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","فَأَجَابَهُمْ: «إِنْ نَفَدَتْ فِضَّتُكُمْ، فَهَاتُوا مَوَاشِيَكُمْ أُقَايِضُكُمْ بِها طَعَاماً». ");
INSERT INTO arbnav_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","فَأَتَوْا بِمَوَاشِيهِمْ، فَقَايَضَهُمْ يُوسُفُ خُبْزاً بِالْخَيْلِ وَمَوَاشِي الْغَنَمِ وَالْبَقَرِ وَالْحَمِيرِ. وَهَكَذَا قَايَضَ جَميِعَ مَوَاشِيهِمْ بِالْخُبْزِ فِي تِلْكَ السَّنَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","وَعِنْدَمَا انْقَضَتْ تِلْكَ السَّنَةُ، أَقْبَلُوا إِلَيْهِ فِي السَّنَةِ التَّالِيَةِ قَائِلِينَ: «لا نُخْفِي عَنْ سَيِّدِي أَنَّ فِضَّتَنَا قَدْ نَفَدَتْ، وَأَنَّ مَوَاشِيَ الْبَهَائِمِ قَدْ أَصْبَحَتْ عِنْدَ سَيِّدِي، وَلَمْ يَبْقَ أَمَامَهُ إِلّا أَبْدَانُنَا وَأَرَاضِينَا، ");
INSERT INTO arbnav_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","فَلِمَاذَا نَمُوتُ نَحْنُ، وَأَرْضُنَا أَمَامَ عَيْنَيْكَ، اشْتَرِنَا نَحْنُ وَأَرْضَنَا لِقَاءَ الْخُبْزِ فَنُصْبِحَ نَحْنُ وَأَرَاضِينَا عَبِيداً لِفِرْعَوْنَ. وَأَعْطِنَا بُذُوراً لِنَزْرَعَهَا فَنَحْيَا وَلا نَمُوتَ وَلا تَصِيرَ أَرَاضِينَا مُقْفِرَةً». ");
INSERT INTO arbnav_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","وَهَكَذَا اشْتَرَى يُوسُفُ لِفِرْعَوْنَ كُلَّ أَرْضِ مِصْرَ، لأَنَّ جَمِيعَ الْمِصْرِيِّينَ بَاعُوا حُقُولَهُمْ مِنْ جَرَّاءِ الْمَجَاعَةِ الَّتِي أَلَمَّتْ بِهِمْ، وَصَارَتْ كُلُّ الأَرْضِ مِلْكاً لِفِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","أَمَّا الشَّعْبُ فَقَدْ نَقَلَهُمْ إِلَى الْمُدُنِ مِنْ أَقْصَى حُدُودِ مِصْرَ إِلَى أَقْصَاهَا. ");
INSERT INTO arbnav_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","إِلّا أَنَّ أَرْضَ الْكَهَنَةِ لَمْ يَشْتَرِهَا، إِذْ كَانَ لِلْكَهَنَةِ مُخَصَّصَاتٌ مُعَيَّنَةٌ أَجْرَاهَا عَلَيْهِمْ فِرْعَوْنُ، فَكَانُوا يَأْكُلُونَ مِنْهَا، فَلَمْ يَبِيعُوا أَرْضَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ثُمَّ قَالَ يُوسُفُ لِلشَّعْبِ: «هَا قَدِ اشْتَرَيْتُكُمُ الْيَوْمَ أَنْتُمْ وَأَرْضَكُمْ فَصِرْتُمْ مِلْكاً لِفِرْعَوْنَ، فَإِلَيْكُم الْبِذَارَ لِتَزْرَعُوا الأَرْضَ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","وَيَكُونُ فِي مَوْسِمِ الْحَصَادِ أَنَّكُمْ تُقَدِّمُونَ لِفِرْعَوْنَ خُمْسَ الْغَلَّةِ وَتَحْتَفِظُونَ لَكُمْ بِالأَرْبَعَةِ الأَخْمَاسِ لِتَكُونَ بِذَاراً لِلْحَقْلِ وَطَعَاماً لَكُمْ وَلِمَنْ فِي بُيُوتِكُمْ وَلأَوْلادِكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","فَأَجَابُوا: «لَقَدْ أَنْقَذْتَ حَيَاتَنَا، فَيَا لَيْتَنَا نَحْظَى بِرِضَى سَيِّدِنَا فَنَكُونَ عَبِيداً لِفِرْعَوْنَ» ");
INSERT INTO arbnav_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","وَمِنْ ذَلِكَ الْحِينِ إِلَى يَوْمِنَا هَذَا جَعَلَ يُوسُفُ فَرِيضَةَ الْخُمْسِ هَذِهِ ضَرِيبَةً عَلَى كُلِّ أَرْضِ مِصْرَ، تُجْبَى لِفِرْعَوْنَ، بِاسْتِثْنَاءِ أَرْضِ الْكَهَنَةِ الَّتِي لَمْ تُصْبِحْ مِلْكاً لِفِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","وَأَقَامَ بَنُو إِسْرَائِيلَ فِي مِصْرَ فِي أَرْضِ جَاسَانَ. وَاقْتَنَوْا فِيهَا أَمْلاكاً وَأَثْمَرُوا وَتَكَاثَرُوا. ");
INSERT INTO arbnav_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","وَعَاشَ يَعْقُوبُ فِي أَرْضِ مِصْرَ سَبْعَ عَشْرَةَ سَنَةً حَتَّى بَلَغَ مِنَ الْعُمْرِ مِئَةً وَسَبْعَةً وَأَرْبَعِينَ عَاماً. ");
INSERT INTO arbnav_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","وَعِنْدَمَا قَرُبَ يَوْمُ وَفَاتِهِ، اسْتَدْعَى ابْنَهُ يُوسُفَ وَقَالَ لَهُ: «إِنْ كُنْتُ قَدْ حَظِيتُ بِرِضَاكَ، فَضَعْ يَدَكَ تَحْتَ فَخْذِي، وَأَسْدِ لِي مَعْرُوفاً وَأَمَانَةً: لَا تَدْفِنِّي فِي مِصْرَ ");
INSERT INTO arbnav_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","بَلْ دَعْنِي أَضْطَجِعُ إِلَى جُوَارِ آبَائِي. انْقُلْنِي مِنْ مِصْرَ وَوَارِنِي فِي مَدْفَنِهِمْ»، فَقَالَ: «أَنَا أَفْعَلُ حَسَبَ قَوْلِكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","فَقَالَ يَعْقُوبُ: «احْلِفْ لِي». فَحَلَفَ لَهُ، فَسَجَدَ يَعْقُوبُ (شَاكِراً) عَلَى رَأْسِ السَّرِيرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ثُمَّ مَا لَبِثَ أَنْ قِيلَ لِيُوسُفَ: «أَبُوكَ مَرِيضٌ» فَاصْطَحَبَ مَعَهُ ابْنَيْهِ مَنَسَّى وَأَفْرَايِمَ. ");
INSERT INTO arbnav_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","وَقِيلَ لِيَعْقُوبَ: «ابْنُكَ يُوسُفُ قَادِمٌ إِلَيْكَ». فَاسْتَجْمَعَ قُوَاهُ وَجَلَسَ عَلَى السَّرِيرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","وَقَالَ يَعْقُوبُ لِيُوسُفَ: «تَجَلَّى اللهُ الْقَدِيرُ لِي فِي لُوزَ فِي أَرْضِ كَنْعَانَ وَبَارَكَنِي، ");
INSERT INTO arbnav_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","وَقَالَ لِي: هَا أَنَا أَجْعَلُكَ مُثْمِراً، وَأُكَثِّرُكَ وَيَخْرُجُ مِنْ صُلْبِكَ جُمْهُورُ شُعُوبٍ وَأَهَبُ ذُرِّيَّتَكَ هَذِهِ الأَرْضَ مِلْكاً أَبَدِيًّا. ");
INSERT INTO arbnav_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","وَالآنَ، إِنَّ ابْنَيْكَ أَفْرَايِمَ وَمَنَسَّى اللَّذَيْنِ أَنْجَبْتَهُمَا فِي مِصْرَ قَبْلَ مَجِيئِي إِلَيْكَ هُنَا هُمَا لِي يَرِثَانِنِي كَرَأُوبَيْنَ وَشِمْعُونَ. ");
INSERT INTO arbnav_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","وَأَمَّا أَوْلادُكَ الَّذِينَ تُنْجِبُهُمْ بَعْدَ ذَلِكَ، فَيَكُونُونَ لَكَ، وَمَا يَرِثُونَهُ يَكُونُ تَحْتَ اسْمِ أَخَوَيْهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","لأَنَّنِي فِيمَا كُنْتُ رَاجِعاً مِنْ سَهْلِ أَرَامَ، مَاتَتْ رَاحِيلُ فِي أَرْضِ كَنْعَانَ فِي الطَّرِيقِ عَلَى مَقْرُبَةٍ مِنْ أَفْرَاتَةَ، فَدَفَنْتُهَا فِي الطَّرِيقِ الْمُؤَدِّيَةِ إِلَى أَفْرَاتَةَ، الَّتِي هِيَ بَيْتُ لَحْمٍ». ");
INSERT INTO arbnav_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","وَأَبْصَرَ إِسْرَائِيلُ ابْنَيْ يُوسُفَ فَسَأَلَ: «مَنْ هَذَانِ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","فَأَجَابَهُ يُوسُفُ: «هُمَا ابْنَايَ اللَّذَانِ رَزَقَنِي إِيَّاهُمَا اللهُ هُنَا». فَقَالَ: «أَدْنِهُمَا مِنِّي فَأُبَارِكَهُمَا». ");
INSERT INTO arbnav_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","وَكَانَتْ عَيْنَا إِسْرَائِيلَ قَدْ كَلَّتَا مِنَ الشَّيْخُوخَةِ، فَلَمْ يَكُنْ قَادِراً عَلَى النَّظَرِ، فَقَرَّبَهُمَا إِلَيْهِ فَقَبَّلَهُمَا وَاحْتَضَنَهُمَا ");
INSERT INTO arbnav_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","وَقَالَ إِسْرَائِيلُ لِيُوسُفَ: «مَا كُنْتُ أَظُنُّ أَنَّنِي أُبْصِرُ وَجْهَكَ، وَهُوَذَا اللهُ قَدْ أَرَانِي ذُرِّيَّتَكَ أَيْضاً». ");
INSERT INTO arbnav_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ثُمَّ أَبْعَدَهُمَا يُوسُفُ عَنْ حِضْنِ أَبِيهِ وَسَجَدَ فِي حَضْرَتِهِ إِلَى الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","وَأَخَذَ يُوسُفُ أَفْرَايِمَ بِيَمِينِهِ وَأَوْقَفَهُ إِلَى يَسَارِ إِسْرَائِيلَ، وَأَخَذَ مَنَسَّى بِيَسَارِهِ وَأَوْقَفَهُ إِلَى يَمِينِهِ، ");
INSERT INTO arbnav_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","فَمَدَّ إِسْرَائِيلُ يَمِينَهُ، مُتَعَمِّداً، وَوَضَعَهَا عَلَى رَأْسِ أَفْرَايِمَ وَهُوَ الصَّغِيرُ، وَيَسَارَهُ عَلَى رَأْسِ مَنَسَّى مَعْ أَنَّهُ الْبِكْرُ. ");
INSERT INTO arbnav_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","وَبَارَكَ يُوسُفَ قَائِلاً: «إِنَّ اللهَ الَّذِي سَلَكَ أَمَامَهُ أَبَوَايَ إِبْرَاهِيمُ وَإِسْحاقُ، اللهَ الَّذِي رَعَانِي مُنْذُ وُجُودِي إِلَى هَذَا الْيَوْمِ، ");
INSERT INTO arbnav_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","الْمَلاكَ الَّذِي أَنْقَذَنِي مِنْ كُلِّ شَرٍّ، يُبَارِكُ الْغُلامَيْنِ، وَلْيُدْعَ عَلَيْهِمَا اسْمِي وَاسْمَا أَبَوَيَّ إِبْرَاهِيمَ وَإِسْحاقَ، وَلْيَكْثُرَا كَثِيراً فِي الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","وَعِنْدَمَا رَأَى يُوسُفُ أَنَّ أَبَاهُ قَدْ وَضَعَ يَدَهُ الْيُمْنَى عَلَى رَأْسِ أَفْرَايِمَ سَاءَهُ ذَلِكَ، فَأَمْسَكَ بِيَدِ أَبِيهِ لِيَنْقُلَهَا مِنْ رَأْسِ أَفْرَايِمَ إِلَى رَأْسِ مَنَسَّى. ");
INSERT INTO arbnav_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","وَقَالَ يُوسُفُ لأَبِيهِ: «لَيْسَ هَكَذَا يَا أَبِي. فَهَذَا هُوَ الْبِكْرُ، ضَعْ يَمِينَكَ عَلَى رَأْسِهِ». ");
INSERT INTO arbnav_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","فَأَبَى أَبُوهُ وَقَالَ: «أَنَا أَعْرِفُ هَذَا يَا ابْنِي، أَنَا أَعْرِفُ هَذَا، فَإِنَّهُ أَيْضاً يُصْبِحُ أُمَّةً عَظِيمَةً، وَلَكِنَّ أَخَاهُ الصَّغِيرَ يُصْبِحُ أَكْبَرَ مِنْهُ، وَذُرِّيَّتَهُ تَصِيرُ جُمْهُوراً مِنَ الأُمَمِ». ");
INSERT INTO arbnav_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","وَبَارَكَهُمَا فِي ذَلِكَ الْيَوْمِ قَائِلاً: «بِكَ يَتَبَارَكُ بَنُو إِسْرَائِيلَ قَائِلِينَ: ’لِيَجْعَلْكَ اللهُ مِثْلَ أَفْرَايِمَ وَمِثْلَ مَنَسَّى‘». وَهَكَذَا قَدَّمَ أَفْرَايِمَ عَلَى مَنَسَّى. ");
INSERT INTO arbnav_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ثُمَّ قَالَ إِسْرَائِيلُ لِيُوسُفَ: «إِنَّنِي مُشْرِفٌ عَلَى الْمَوْتِ وَلَكِنَّ اللهَ سَيَكُونُ مَعَكُمْ وَيَرُدُّكُمْ إِلَى أَرْضِ آبَائِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","وَهَا أَنَا قَدْ وَهَبْتُ لَكَ مِنَ الأَرْضِ سَهْماً وَاحِداً عَلاوَةً عَلَى إِخْوَتِكَ، أَخَذْتُهُ مِنَ الأَمُورِيِّينَ بِسَيْفِي وَقَوْسِي». ");
INSERT INTO arbnav_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ثُمَّ اسْتَدْعَى يَعْقُوبُ أَبْنَاءَهُ وَقَالَ: «الْتَفُّوا حَوْلِي لأُنْبِئَكُمْ بِمَا سَيَحْدُثُ لَكُمْ فِي الأَيَّامِ الْمُقْبِلَةِ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","اجْتَمِعُوا وَاسْمَعُوا يَا أَبْنَاءَ يَعْقُوبَ، وَأَصْغَوْا إِلَى إِسْرَائِيلَ أَبِيكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","رَأُوبَيْنُ أَنْتَ بِكْرِي وَقُوَّتِي وَأَوَّلُ مَظْهَرِ رُجُولَتِي، فَضْلُ الرِّفْعَةِ وَفَضْلُ الْعِزِّ ");
INSERT INTO arbnav_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","لَكِنَّكَ فَائِرٌ كَالْمَاءِ لِذَلِكَ لَنْ تَظَلَّ مُتَفَوِّقاً، لأَنَّكَ اضْطَجَعْتَ فِي فِرَاشِ أَبِيكَ. صَعِدْتَ عَلَى سَرِيرِي فَدَنَّسْتَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","شِمْعُونُ وَلاوِي أَخَوَانِ سُيُوفُهُمَا آلاتُ ظُلْمٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","فَيَا نَفْسِي لَا تَدْخُلِي فِي مَجْلِسِهِمَا، وَيَا رُوحِي لَا تَنْضَمِّي إِلَى مَجْمَعِهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","لأَنَّهُمَا فِي غَضَبِهِمَا يَقْتُلانِ النَّاسَ، وَفِي رِضَاهُمَا يُعَرْقِلانِ الثِّيرَانَ. مَلْعُونٌ سْخْطُهُمَا لأَنَّهُ عَنِيفٌ وَغَضَبُهُمَا لأَنَّهُ ضَارٍ. أُفَرِّقُهُمَا فِي يَعْقُوبَ وَأُشَتِّتُهُمَا فِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","يَهُوذَا، إِيَّاكَ يَحْمَدُ إِخْوَتُكَ، وَتَكُونُ يَدُكَ عَلَى عُنُقِ أَعْدَائِكَ، وَيَسْجُدُ لَكَ بَنُو أَبِيكَ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","يَهُوذَا شِبْلُ أَسَدٍ، عَنْ فَرِيسَةٍ قُمْتَ يَا ابْنِي. ثُمَّ جَثَا وَرَبَضَ كَأَسَدٍ أَوْ كَلَبْوَةٍ، فَمَنْ يَجْرُؤُ عَلَى إِثَارَتِهِ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","لَا يَزُولُ صَوْلَجَانُ الْمُلْكِ مِنْ يَهُوذَا وَلا مُشْتَرِعٌ مِنْ صُلْبِهِ حَتَّى يَأْتِيَ شِيلُوهُ (وَمَعْنَاهُ: مَنْ لَهُ الأَمْرُ) فَتُطِيعُهُ الشُّعُوبُ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","يَرْبِطُ بِالْكَرْمَةِ جَحْشَهُ، وَبِأَفْضَلِ جَفْنَةٍ ابْنَ أَتَانِهِ. بِالْخَمْرِ يَغْسِلُ لِبَاسَهُ وَبِدَمِ الْعِنَبِ ثَوْبَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","تَكُونُ عَيْنَاهُ أَشَدَّ سَوَاداً مِنَ الْخَمْرِ، وَأَسْنَانُهُ أَكْثَرَ بَيَاضاً مِنَ اللَّبَنِ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","زَبُولُونُ يَسْكُنُ عِنْدَ سَوَاحِلِ الْبَحْرِ، وَيُصْبِحُ مَقَرُّهُ مَرْفَأً لِلسُّفُنِ، وَتَمْتَدُّ تُخُومُهُ نَحْوَ صَيْدَا ");
INSERT INTO arbnav_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","يَسَّاكَرُ حِمَارٌ قَوِيٌّ رَابِضٌ بَيْنَ الْحَظَائِرِ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","عِنْدَمَا يَرَى خُصُوبَةَ مَرْتَعِهِ وَبَهْجَةَ أَرْضِهِ، تَسْتَكِينُ كَتِفَاهُ لِلأَثْقَالِ، وَيُسْتَعْبَدُ لِلْعَمَلِ الشَّاقِ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","دَانٌ يَقْضِي لِشَعْبِهِ كَأَحَدِ أَسْبَاطِ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","دَانٌ يَكُونُ ثُعْبَاناً عَلَى جَانِبِ الطَّرِيقِ وَأُفْعُوَاناً عَلَى السَّبِيلِ، يَلْسَعُ عَقِبَيِ الْفَرَسِ فَيَهْوِي رَاكِبُهُ إِلَى الْوَرَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","إِنَّنِي انْتَظَرْتُ خَلاصَكَ يَا رَبُّ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","جَادٌ يَقْتَحِمُهُ الْغُزَاةُ، وَلَكِنَّهُ يُطَارِدُ فُلُولَهُمْ وَيَقْحَمُهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","طَعَامُ أَشِيرَ دَسِمٌ، وَأَطَايبُهُ صَالِحَةٌ لِمَوَائِدِ الْمُلُوكِ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","نَفْتَالِي غَزَالَةٌ طَلِيقَةٌ يُرَدِّدُ أَقْوَالاً جَمِيلَةً. ");
INSERT INTO arbnav_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","يُوسُفُ كَرْمَةٌ مُثْمِرَةٌ إِلَى جُوَارِ عَيْنٍ، تَسَلَّقَتْ أَغْصَانُهُ الْحَائِطَ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","يُهَاجِمُهُ الرُّمَاةُ بِمَرَارَةٍ. وَيُطْلِقُونَ سِهَامَهُمْ عَلَيْهِ بِعَدَاوَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","وَلَكِنْ قَوْسُهُ ظَلَّتْ مَتِينَةً، وَتَشَدَّدَتْ سَوَاعِدُ يَدَيْهِ بِفَضْلِ سَوَاعِدِ عَزِيزِ يَعْقُوبَ، الرَّاعِي صَخْرِ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","بِفَضْلِ إِلَهِ أَبِيكَ الَّذِي يُعِينُكَ، بِفَضْلِ الْقَدِيرِ الَّذِي يُبَارِكُكَ بِبَرَكَاتِ السَّمَاوَاتِ مِنْ فَوْقُ، وَبَرَكَاتِ الْغَمْرِ مِنْ تَحْتُ، وَبَرَكَاتِ الثَّدْيِ وَالرَّحِمِ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","إِنَّ بَرَكَاتِ أَبِيكَ أَعْظَمُ مِنْ بَرَكَاتِ الْجِبَالِ الدَّهْرِيَّةِ، وَأَعْظَمُ مِنْ ذَخَائِرِ التِّلالِ الْقَدِيمَةِ، فَلْتَحُلَّ جَمِيعُهَا عَلَى رَأْسِكَ يَا يُوسُفُ وَعَلَى جَبِينِ الَّذِي انْفَصَلَ عَنْ إِخْوَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","بَنْيَامِينُ ذِئْبٌ ضَارٍ، يَفْتَرِسُ ضَحِيَّتَهُ فِي الصَّبَاحِ، وَيُفَرِّقُ الْغَنِيمَةَ فِي الْمَسَاءِ». ");
INSERT INTO arbnav_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","هَؤُلاءِ جَمِيعاً هُمْ رُؤَسَاءُ أَسْبَاطِ إِسْرَائِيلَ الاثْنَيْ عَشَرَ. وَهَذَا مَا خَاطَبَهُمْ بِهِ أَبُوهُمْ وَبَارَكَهُمْ؛ كُلُّ وَاحِدٍ بِالْبَرَكَةِ الْمُنَاسِبَةِ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ثُمَّ أَوْصَاهُمْ قَائِلاً: «قَرِيباً أَنْضَمُّ إِلَى آبَائِي، فَادْفِنُونِي إِلَى جُوَارِهِمْ فِي مَغَارَةِ حَقْلِ عِفْرُونَ الْحِثِّيِّ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","الَّتِي فِي حَقْلِ الْمَكْفِيلَةِ الْمُوَاجِهَةِ لِمَمْرَا فِي أَرْضِ كَنْعَانَ، الَّتِي اشْتَرَاهَا إِبْرَاهِيمُ مَعَ الْحَقْلِ مِنْ عِفْرُونَ الْحِثِّيِّ لِتَكُونَ مَدْفَناً خَاصّاً. ");
INSERT INTO arbnav_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","فِيهَا دُفِنَ إِبْرَاهِيمُ وَزَوْجَتُهُ سَارَةُ، ثُمَّ إِسْحاقُ وَزَوْجَتُهُ رِفْقَةُ، وَأَيْضاً دَفَنْتُ لَيْئَةَ. ");
INSERT INTO arbnav_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","وَقَدِ اشْتَرَى إِبْرَاهِيمُ الْحَقْلَ وَالْمَغَارَةَ الَّتِي فِيهِ مِنَ الْحِثِّيِّينَ.» ");
INSERT INTO arbnav_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","وَلَمَّا فَرَغَ يَعْقُوبُ مِنْ تَوْصِيَةِ أَبْنَائِهِ تَمَدَّدَ عَلَى سَرِيرِهِ، وَضَمَّ رِجْلَيْهِ مَعاً، ثُمَّ أَسْلَمَ رُوحَهُ وَلَحِقَ بِآبَائِهِ. ");
INSERT INTO arbnav_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","فَأَلْقَى يُوسُفُ بِنَفْسِهِ عَلَى جُثْمَانِ أَبِيهِ، وَبَكَى وَقَبَّلَهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ثُمَّ أَمَرَ يُوسُفُ عَبِيدَهُ الأَطِبَّاءَ أَنْ يُحَنِّطُوا أَبَاهُ. ");
INSERT INTO arbnav_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","وَقَدِ اسْتَغْرَقَ ذَلِكَ أَرْبَعِينَ يَوْماً، وَهِيَ الأَيَّامُ الْمَطْلُوبَةُ لاسْتِكْمَالِ التَّحْنِيطِ. وَبَكَى الْمِصْرِيُّونَ عَلَيْهِ سَبْعِينَ يَوْماً. ");
INSERT INTO arbnav_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","وَبَعْدَمَا انْقَضَتْ أَيَّامُ النُّوَاحِ عَلَيْهِ، قَالَ يُوسُفُ لأَهْلِ بَيْتِ فِرْعَوْنَ: «إِنْ كُنْتُ قَدْ حَظِيتُ بِرِضَاكُمْ، فَتَكَلَّمُوا فِي مَسَامِعِ فِرْعَوْنَ قَائِلِينَ: ");
INSERT INTO arbnav_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","لَقَدِ اسْتَحْلَفَنِي أَبِي وَقَالَ: أَنَا مُشْرِفٌ عَلَى الْمَوْتِ، فَادْفِنِّي فِي الْقَبْرِ الَّذِي حَفَرْتُهُ لِنَفْسِي فِي أَرْضِ كَنْعَانَ، فَاسْمَحْ لِيَ الآنَ بِأَنْ أَمْضِيَ لأَدْفِنَ أَبِي ثُمَّ أَعُودَ». ");
INSERT INTO arbnav_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","فَقَالَ فِرْعَوْنُ: «امْضِ وَادْفِنْ أَبَاكَ كَمَا اسْتَحْلَفَكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","فَانْطَلَقَ يُوسُفُ لِيَدْفِنَ أَبَاهُ، وَرَافَقَتْهُ حَاشِيَةُ فِرْعَوْنَ مِنْ أَعْيَانِ بَيْتِهِ وَوُجَهَاءِ مِصْرَ، ");
INSERT INTO arbnav_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","وَكَذَلِكَ أَهْلُ بَيْتِهِ وَإخْوَتُهُ وَأَهْلُ بَيْتِ أَبِيهِ. وَلَمْ يُخَلِّفُوا وَرَاءَهُمْ فِي أَرْضِ جَاسَانَ سِوَى صِغَارِهِمْ وَغَنَمِهِمْ وَقُطْعَانِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","وَصَاحَبَتْهُ أَيْضاً مَرْكَبَاتٌ وَفُرْسَانٌ، فَكَانُوا مَوْكِباً عَظِيماً. ");
INSERT INTO arbnav_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","وَلَمَّا وَصَلُوا إِلَى بَيْدَرِ أَطَادَ فِي عَبْرِ الأُرْدُنِّ أَقَامَ يُوسُفُ لأَبِيهِ مَنَاحَةً عَظِيمَةً مَرِيرَةً نَاحُوا فِيهَا عَلَيْهِ طَوَالَ سَبْعَةِ أَيَّامٍ ");
INSERT INTO arbnav_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","وَعِنْدَمَا شَاهَدَ الْكَنْعَانِيُّونَ السَّاكِنُونَ هُنَاكَ الْمَنَاحَةَ فِي بَيْدَرِ أَطَادَ قَالُوا: «هَذِهِ مَنَاحَةٌ هَائِلَةٌ لِلْمَصْرِيِّينَ». وَسَمُّوا الْمَكَانَ الَّذِي فِي عَبْرِ الأُرْدُنِّ «آبِلَ مِصْرَايِمَ» (وَمَعْنَاهُ: مَنَاحَةُ الْمِصْرِيِّينَ). ");
INSERT INTO arbnav_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","وَنَفَّذَ أَبْنَاءُ يَعْقُوبَ وَصِيَّةَ أَبِيهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","فَنَقَلُوهُ إِلَى أَرْضِ كَنْعَانَ وَدَفَنُوهُ فِي مَغَارَةِ حَقْلِ الْمَكْفِيلَةِ مُقَابِلَ مَمْرَا الَّتِي اشْتَرَاهَا إِبْرَاهِيمُ مَعَ الْحَقْلِ مِنْ عِفْرُونَ الْحِثِّيِّ لِتَكُونَ مَدْفَناً خَاصّاً. ");
INSERT INTO arbnav_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","وَبَعْدَ أَنْ دَفَنَ يُوسُفُ أَبَاهُ، رَجَعَ هُوَ وَإخْوَتُهُ وَسَائِرُ الَّذِينَ رَافَقُوهُ إِلَى مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","وَلَمَا رَأى إِخْوَةُ يُوسُفُ أَنَّ أَبَاهُمْ قَدْ مَاتَ قَالُوا: «لَعَلَّ يُوسُفَ الآنَ يَشْرَعُ فِي اضْطِهَادِنَا وَيَنْتَقِمُ مِنَّا لإِسَاءَتِنَا إِلَيْهِ؟» ");
INSERT INTO arbnav_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","فَبَعَثُوا إِلَيْهِ رَسُولاً قَائِلِينَ: «لَقَدْ أَوْصَى أَبُوكَ قَبْلَ مَوْتِهِ وَقَالَ: ");
INSERT INTO arbnav_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","هَكَذَا تَقُولُونَ لِيُوسُفَ: اغْفِرْ لإِخْوَتِكَ ذَنْبَهُمْ وَخَطِيئَتَهُمْ، فَإِنَّهُمْ قَدْ أَسَاءُوا إِلَيْكَ. فَالآنَ اصْفَحْ عَنْ إِثْمِ عَبِيدِ إِلَهِ أَبِيكَ». فَلَمَّا بَلَغَتْهُ رِسَالَتُهُمْ بَكَى يُوسُفُ. ");
INSERT INTO arbnav_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","وَجَاءَ إِخْوَتُهُ أَيْضاً وَانْطَرَحُوا أَمَامَهُ وَقَالُوا: «هَا نَحْنُ عَبِيدُكَ». ");
INSERT INTO arbnav_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","فَقَالَ لَهُمْ: «لا تَخَافُوا: هَلْ أَنَا أَقُومُ مَقَامَ اللهِ؟ ");
INSERT INTO arbnav_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","أَنْتُمْ نَوَيْتُمْ لِي شَرّاً، وَلَكِنَّ اللهَ قَصَدَ بِالشَّرِّ خَيْراً، لِيُنْجِزَ مَا تَمَّ الْيَوْمَ، لإِحْيَاءِ شَعْبٍ كَثِيرٍ. ");
INSERT INTO arbnav_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","لِذَلِكَ لَا تَخَافُوا، فَأَنَا أَعُولُكُمْ أَنْتُمْ وَأَوْلادَكُمْ». فَطَمْأَنَهُمْ وَهَدَّأَ رَوْعَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","وَأَقَامَ يُوسُفُ فِي مِصْرَ هُوَ وَأَهْلُ بَيْتِ أَبِيهِ. وَعَاشَ يُوسُفُ مِئَةً وَعَشْرَ سِنِينَ، ");
INSERT INTO arbnav_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","حَتَّى شَهِدَ الجِيلَ الثَّالِثَ مِنْ ذُرِّيَّةِ أَفْرَايِمَ، وَكَذَلِكَ أَوْلادَ مَاكِيرَ بْنِ مَنَسَّى الَّذِينَ احْتَضَنَهُمْ عِنْدَ وِلادَتِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ثُمَّ قَالَ يُوسُفُ لإِخْوَتِهِ: «أَنَا مُوْشِكٌ عَلَى الْمَوْتِ، وَلَكِنَّ اللهَ سَيَفْتَقِدُكُمْ وَيُخْرِجُكُمْ مِنْ هَذِهِ الأَرْضِ وَيَرُدُّكُمْ إِلَى الأَرْضِ الَّتِي وَعَدَ بِها بِقَسَمٍ لإِبْرَاهِيمَ وَإِسْحاقَ وَيَعْقُوبَ». ");
INSERT INTO arbnav_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","وَاسْتَحْلَفَ يُوسُفُ أَبْنَاءَ إِسْرَائِيلَ قَائِلاً: «إِنَّ اللهَ سَيَفْتَقِدُكُمْ فَانْقُلُوا عِظَامِي مِنْ هُنَا». ");
INSERT INTO arbnav_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ثُمَّ مَاتَ يُوسُفُ وَقَدْ بَلَغَ مِنَ الْعُمْرِ مِئَةً وَعَشْرَ سِنِينَ. فَحَنَّطُوهُ وَوَضَعُوهُ فِي تَابُوتٍ فِي مِصْرَ.");
INSERT INTO arbnav_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","وَهَذِهِ هِيَ أَسْمَاءُ أَبْنَاءِ إِسْرَائِيلَ الَّذِينَ قَدِمُوا مَعَ يَعْقُوبَ إِلَى مِصْرَ، كُلُّ وَاحِدٍ مِنْهُمْ مَعَ أَهْلِ بَيْتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","رَأُوبَيْنُ، وَشِمْعُونُ، وَلاوِي وَيَهُوذَا، ");
INSERT INTO arbnav_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","وَيَسَّاكَرُ وَزَبُولُونُ وَبَنْيَامِينُ، ");
INSERT INTO arbnav_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","وَدَانٌ وَنَفْتَالِي وَجَادٌ وَأَشِيرُ. ");
INSERT INTO arbnav_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","وَكَانَتْ جُمْلَةُ النُّفُوسِ الْمَوْلُودِينَ مِنْ صُلْبِ يَعْقُوبَ سَبْعِينَ نَفْساً. أَمَّا يُوسُفُ فَقَدْ كَانَ فِي مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ثُمَّ مَاتَ يُوسُفُ وَإخْوَتُهُ جَمِيعاً وَكَذَلِكَ سَائِرُ ذَلِكَ الْجِيلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","وَنَمَا بَنُو إِسْرَائِيلَ، وَتَوَالَدُوا وَتَكَاثَرُوا وَعَظُمُوا جِدّاً حَتَّى اكْتَظَّتْ بِهِمِ الأَرْضُ. ");
INSERT INTO arbnav_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","وَمَا لَبِثَ أَنْ قَامَ مَلِكٌ جَدِيدٌ عَلَى مِصْرَ لَمْ يَكُنْ يَعْرِفُ يُوسُفَ. ");
INSERT INTO arbnav_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","فَقَالَ لِشَعْبِهِ: «هَا بَنُو إِسْرَائِيلَ أَكْثَرُ مِنَّا وَأَعْظَمُ قُوَّةً. ");
INSERT INTO arbnav_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","فَلْنَتَآمَرْ عَلَيْهِمْ لِكَيْلا يَتَكَاثَرُوا وَيَنْضَمُّوا إِلَى أَعْدَائِنَا إِذَا نَشَبَ قِتَالٌ وَيُحَارِبُونَا ثُمَّ يَخْرُجُوا مِنَ الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","فَعَهِدُوا بِهِمْ إِلَى مُشْرِفِينَ عُتَاةٍ لِيُسَخِّرُوهُمْ بِالأَعْمَالِ الشَّاقَةِ. فَبَنَوْا مَدِينَتَيْ فِيثُومَ وَرَعَمْسِيسَ لِتَكُونَا مَخَازِنَ لِفِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","وَلَكِنْ كُلَّمَا زَادُوا مِنْ إذْلالِهِمْ، ازْدَادَ تَكَاثُرُهُمْ وَنُمُوُّهُمْ، فَتَخَوَّفُوا مِنْ بَنِي إِسْرَائِيلَ ");
INSERT INTO arbnav_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","فَتَزَايَدَ عُنْفُ اسْتِعْبَادِ الْمِصْرِيِّينَ لِبَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","وَأَتْعَسُوا حَيَاتَهُمْ بالأَعْمَالِ الشَّاقَةِ فِي الطِّينِ وَاللِّبْنِ كَادِحِينَ فِي الْحُقُولِ. وسَخَّرَهُمُ الْمِصْرِيُّونَ بِعُنْفٍ فِي كُلِّ أَعْمَالِهِمِ الشَّاقَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ثُمَّ قَالَ مَلِكُ مِصْرَ لِلْقَابِلَتَيْنِ الْعِبْرَانِيَّتَيْنِ الْمَدْعُوَّتَيْنِ شِفْرَةَ وَفُوعَةَ: ");
INSERT INTO arbnav_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«عِنْدَمَا تُشْرِفَانِ عَلَى تَوْلِيدِ النِّسَاءِ الْعِبْرَانِيَّاتِ رَاقِبَاهُنَّ عَلَى كُرْسِيِّ الْوِلادَةِ، فَإنْ كَانَ الْمَوْلُودُ صَبِيًّا فَاقْتُلاهُ، وَإِنْ كَانَ بِنْتاً فاتْرُكَاهَا تَحْيَا». ");
INSERT INTO arbnav_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","غَيْرَ أَنَّ الْقَابِلَتَيْنِ كَانَتَا تَخَافَانِ اللهَ فَلَمْ تُنَفِّذَا أَمْرَ الْمَلِكِ فاسْتَحْيَتَا الأَطْفَالَ الذُّكُورَ. ");
INSERT INTO arbnav_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","فَاسْتَدْعَى مَلِكُ مِصْرَ الْقَابِلَتَيْنِ وَسَأَلَهُمَا: «لِمَاذَا فَعَلْتُمَا هَذَا الأَمْرَ واسْتَحْيَيْتُمَا الأَطْفَالَ الذُّكُورَ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","فَأَجَابَتَاهُ: «إنَّ النِّسَاءَ الْعِبْرَانِيَّاتِ لَسْنَ كَالْمِصْرِيَّاتِ، فَإِنَّهُنَّ قَوِيَّاتٌ يَلِدْنَ قَبْلَ وُصُولِ الْقَابِلَةِ إِلَيْهِنَّ». ");
INSERT INTO arbnav_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","وَتَكَاثَرَ الشَّعْبُ وَعَظُمَ جِدّاً. ");
INSERT INTO arbnav_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","وَإِذْ خَافَتِ الْقَابِلَتَانِ اللهَ أَثَابَهُمَا بِنَسْلٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ثُمَّ أَصْدَرَ فِرْعَوْنُ أَمْرَهُ لِجَمِيعِ شَعْبِهِ قَائِلاً: «اطْرَحُوا كُلَّ ابْنٍ (عِبْرَانِيٍّ) يُوْلَدُ فِي النَّهْرِ، أَمَّا الْبَنَاتُ فَاسْتَحْيُوهُنَّ». ");
INSERT INTO arbnav_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","وَتَزَوَّجَ رَجُلٌ مِنْ بَيْتِ لاوِي فَتَاةً ابْنَةَ لاوِي. ");
INSERT INTO arbnav_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","فَحَمَلَتِ الْمَرْأَةُ وَأَنْجَبَتِ ابْناً، وَإذْ رَاقَهَا جَمَالُهُ خَبَّأَتْهُ ثَلاثَةَ أَشْهُرٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","وَلَمَّا لَمْ تَسْتَطِعْ أَنْ تُخْفِيَهُ بَعْدُ، أَتَتْ بِسَلَّةٍ مِنَ الْبَرْدِيِّ وَطَلَتْهَا بِالْحُمَرِ والزِّفْتِ وأَضْجَعَتِ الطِّفْلَ وَوَضَعَتْهُ بَيْنَ الْحَلْفَاءِ عَلَى ضَفَّةِ النَّهْرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","وَوَقَفَتْ أُخْتُهُ مِنْ بَعِيدٍ لِتَرَى مَا يَحْدُثُ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","وَأَقْبَلَتِ ابْنَةُ فِرْعَوْنَ لِتَسْتَحِمَّ فِي النَّهْرِ، بَيْنَمَا رَاحَتْ وَصِيفَاتُهَا تَتَمَشَّيْنَ عَلَى ضَفَّةِ النَّهْرِ. فَرَأَتِ السَّلَّةَ بَيْنَ الْحَلْفَاءِ فَأَرْسَلَتْ وَصِيفَتَهَا لِتَأْتِيَ بِها. ");
INSERT INTO arbnav_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","فَفَتَحَتْهَا وَرَأَتِ الطِّفْلَ وَإذَا هُوَ يَبْكِي، فَرَقَّتْ لَهُ وَقَالَتْ: «هَذَا مِنْ أَوْلادِ الْعِبْرَانِيِّينَ» ");
INSERT INTO arbnav_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","فَقَالَتْ أُخْتُهُ لاِبْنَةِ فِرْعَوْنَ: «هَلْ أَذْهَبُ وَأَدْعُو لَكِ مُرْضِعَةً مِنَ الْعِبْرَانِيَّاتِ لِتُرْضِعَ لَكِ الْوَلَدَ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","فَأَجَابَتْهَا ابْنَةُ فِرْعَوْنَ: «اذْهَبِي»؛ فَمَضَتِ الْفَتَاةُ وَدَعَتْ أَمَّ الصَّبِيِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","فَقَالَتْ لَهَا ابْنَةُ فِرْعَوْنَ: «خُذِي هَذَا الصَّبِيَّ وَأَرْضِعِيهِ لِي، وَأَنَا أُعْطِيكِ أُجْرَتَكِ». فَأَخَذَتِ الْمَرْأَةُ الصَّبِيَّ وَأَرْضَعَتْهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","وَلَمَّا كَبُرَ الْوَلَدُ، رَدَّتْهُ إِلَى ابْنَةِ فِرْعَوْنَ فَتَبَنَّتْهُ وَدَعَتْهُ مُوسَى (وَمَعْنَاهُ مُنْتَشَلٌ) قَائِلَةً: «إِنِّي انْتَشَلْتُهُ مِنَ الْمَاءِ». ");
INSERT INTO arbnav_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","وَحَدَثَ بَعْدَ أَنْ كَبُرَ مُوسَى أَنَّهُ ذَهَبَ لِيَفْتَقِدَ إِخْوَتَهُ الْعِبْرَانِيِّينَ وَيَشْهَدَ مَشَقَّتَهُمْ، فَلَمَحَ رَجُلاً مِصْرِيًّا يَضْرِبُ رَجُلاً عِبْرَانِيًّا، ");
INSERT INTO arbnav_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","فَتَلَفَّتَ حَوْلَهُ، وَإِذْ لَمْ يَجِدْ أَحَداً هُنَاكَ قَتَلَ الْمِصْرِيَّ وَطَمَرَهُ فِي الرَّمْلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ثُمَّ خَرَجَ فِي الْيَوْمِ الثَّانِي وَإذَا رَجُلانِ عِبْرَانِيَّانِ يَتَضَارَبَانِ، فَقَالَ لِلْمُسِيءِ: «لِمَاذَا تَضْرِبُ صَاحِبَكَ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","فَأَجَابَهُ: «مَنْ أَقَامَكَ رَئِيساً وَقَاضِياً عَلَيْنَا؟ أَعَازِمٌ أَنْتَ عَلَى قَتْلِي كَمَا قَتَلْتَ الْمِصْرِيَّ؟» فَخَافَ مُوسَى وَقَالَ: «حَقّاً إِنَّ الْخَبَرَ قَدْ ذَاعَ». ");
INSERT INTO arbnav_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","وَبَلَغَ الْخَبَرُ مَسْمَعَ فِرْعَوْنَ، فَسَعَى إِلَى قَتْلِ مُوسَى، إلّا أَنَّ مُوسَى هَرَبَ مِنْ وَجْهِ فِرْعَوْنَ، وَمَضَى لِيُقِيمَ فِي أَرْضِ مِدْيَانَ، فَبَلَغَهَا وَجَلَسَ عِنْدَ الْبِئْرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","وَكَانَ لِكَاهِنِ مِدْيَانَ سَبْعُ فَتَيَاتٍ فَأَقْبَلْنَ وَاسْتَقَيْنَ مَاءً وَمَلأْنَ الأَجْرَانَ لِيَسْقِينَ غَنَمَ أَبِيهِنَّ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","فَأَتَى الرُّعَاةُ وَطَرَدُوهُنَّ. غَيْرَ أَنَّ مُوسَى هَبَّ لِنَجْدَتِهِنَّ وَسَقَى غَنَمَهُنَّ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","وَعِنْدَمَا رَجَعَتِ الْفَتَيَاتُ إِلَى رَعُوئِيلَ أَبِيهِنَّ سَأَلَهُنَّ: «مَا بَالُكُنَّ بَكَّرْتُنَّ بِالرُّجُوعِ الْيَوْمَ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","فَأَجَبْنَهُ: «رَجُلٌ مِصْرِيٌّ أَنْقَذَنَا مِنْ أَيْدِي الرُّعَاةِ، فَاسْتَقَى لَنَا وَلِغَنَمِنَا أَيْضاً». ");
INSERT INTO arbnav_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","فَسَأَلَهُنَّ: «وَأَيْنَ هُوَ؟ لِمَاذَا تَرَكْتُنَّ الرَّجُلَ؟ ادْعُونَهُ لِيَأْكُلَ طَعَاماً». ");
INSERT INTO arbnav_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","وَقَبِلَ مُوسَى أنْ يُقِيمَ مَعَ الرَّجُلِ الَّذِي زَوَّجَهُ مِنِ ابْنَتِهِ صَفُّورَةَ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","فَأَنْجَبَتْ لَهُ ابْناً دَعَاهُ جِرْشُومَ (وَمَعْنَاهُ غَرِيبٌ) إِذْ قَالَ: «كُنْتُ نَزِيلاً فِي أَرْضٍ غَرِيبَةٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","وَبَعْدَ مُرُورِ حِقْبَةٍ طَوِيلَةٍ مَاتَ مَلِكُ مِصْرَ. وَارْتَفَعَ أَنِينُ بَنِي إِسْرَائِيلَ وَصُرَاخُهُمْ مِنْ وَطْأَةِ الْعُبُودِيَّةِ، وَصَعِدَ إِلَى اللهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","فَأَصْغَى اللهُ إِلَى أَنِينِهِمْ، وَتَذَكَّرَ عَهْدَهُ مَعَ إِبرَاهِيمَ وَإِسْحاقَ وَيَعْقُوبَ. ");
INSERT INTO arbnav_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","وَنَظَرَ اللهُ إِلَى بَنِي إِسْرَائِيلَ (وَرَقَّ لِحَالِهِمْ). ");
INSERT INTO arbnav_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","وَأَمَّا مُوسَى فَكَانَ يَرْعَى غَنَمَ حَمِيهِ يَثْرُونَ كَاهِنِ مِدْيَانَ، فَقَادَ الْغَنَمَ إِلَى مَا وَرَاءِ الطَّرَفِ الأَقْصَى مِنَ الصَّحْرَاءِ حَتَّى جَاءَ إلى حُورِيبَ جَبَلِ اللهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","وَهُنَاكَ تَجَلَّى لَهُ مَلاكُ الرَّبِّ بِلَهِيبِ نَارٍ وَسَطَ عُلَّيْقَةٍ. فَنَظَرَ مُوسَى وَإذَا بِالْعُلَّيْقَةِ تَتَّقِدُ دُونَ أَنْ تَحْتَرِقَ. ");
INSERT INTO arbnav_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","فَقَالَ مُوسَى: «أَمِيلُ الآنَ لأَسْتَطْلِعَ هَذَا الأَمْرَ الْعَظِيمَ. لِمَاذَا لَا تَحْتَرِقُ الْعُلَّيْقَةُ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","وَعِنْدَمَا رَأَى الرَّبُّ أَنَّ مُوسَى قَدْ دَنَا لِيَسْتَطْلِعَ الأَمْرَ، نَادَاهُ مِنْ وَسَطِ الْعُلَّيْقَةِ قَائِلاً: «مُوسَى». فَقَالَ: «هَا أَنَا». ");
INSERT INTO arbnav_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","فَقَالَ: «لا تَقْتَرِبْ إِلَى هُنَا: اخْلَعْ حِذَاءَكَ مِنْ رِجْلَيْكَ، لأَنَّ الْمَكَانَ الَّذِي أَنْتَ وَاقِفٌ عَلَيْهِ أَرْضٌ مُقَدَّسَةٌ». ");
INSERT INTO arbnav_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ثُمَّ قَالَ: «أَنَا هُوَ إِلَهُ أَبِيكَ، إِلَهُ إِبْرَاهِيمَ، وَإِلَهُ إسْحاقَ، وَإِلَهُ يَعْقُوبَ». عِنْدَئِذٍ غَطَّى مُوسَى وَجْهَهُ خَوْفاً مِنْ أَنْ يَرَى اللهَ (فَيَمُوتَ). ");
INSERT INTO arbnav_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","فَقَالَ الرَّبُّ: «قَدْ شَهِدْتُ مَذَلَّةَ شَعْبِي الَّذِي فِي مِصْرَ وَسَمِعْتُ صُرَاخَهُمْ مِنْ جَرَّاءِ عُتُوِّ مُسَخِّرِيهِمْ وأَدْرَكْتُ مُعَانَاتَهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","فَنَزَلْتُ لأُنْقِذَهُمْ مِنْ يَدِ الْمِصْرِيِّينَ وَأُخْرِجَهُمْ مِنْ تِلْكَ الأَرْضِ إِلَى أَرْضٍ طَيِّبَةٍ رَحِيبَةٍ تَفِيضُ لَبَناً وَعَسَلاً، أَرْضِ الْكَنْعَانِيِّينَ وَالْحِثِّيِّينَ وَالأَمُورِيِّينَ وَالْفَرِزِّيِّينَ وَالْحِوِّيِّينَ وَالْيَبُوسِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","وَهَا هُوَ الآنَ قَدْ وَصَلَ إِلَيَّ صُرَاخُ بَنِي إِسْرَائِيلَ، وَرَأَيْتُ كَيْفَ يُضَايِقُهُمُ الْمِصْرِيُّونَ. ");
INSERT INTO arbnav_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","فَهَلُمَّ الآنَ لأُرْسِلَكَ إِلَى فِرْعَوْنَ، فَتُخْرِجَ شَعْبِي بَنِي إِسْرَائِيلَ مِنْ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","فَقَالَ مُوسَى لِلهِ: «مَنْ أَنَا حَتَّى أَمْضِيَ إِلَى فِرْعَوْنَ وَأُخْرِجَ بَنِي إِسْرَائِيلَ مِنْ مِصْرَ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","فَأَجَابَ: «أَنَا أَكُونُ مَعَكَ. وَمَتَى أَخْرَجْتَ الشَّعْبَ مِنْ مِصْرَ تَعْبُدُونَ اللهَ عَلَى هَذَا الْجَبَلِ، فَتَكُونُ هَذِهِ لَكَ الْعَلامَةَ أَنَّنِي أَنَا أَرْسَلْتُكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","فَقَالَ مُوسَى لِلهِ: «حِينَمَا أُقْبِلُ عَلَى بَنِي إِسْرَائِيلَ وَأَقُولُ لَهُمْ: إِنَّ إِلَهَ آبَائِكُمْ قَدْ بَعَثَنِي إِلَيْكُمْ وَسَأَلُونِي: مَا اسْمُهُ؟ فَمَاذَا أَقُولُ لَهُمْ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","فَأَجَابَهُ اللهُ: «أَهْيَه الَّذِي أَهْيَه» (وَمَعْنَاهُ أَنَا الْكَائِنُ الدَّائِمُ). وَأَضَافَ: «هَكَذَا تَقُولُ لِبَنِي إِسْرَائِيلَ: أَهْيَه (أَنَا الْكَائِنُ)، هُوَ الَّذِي أَرْسَلَنِي إِلَيْكُمْ.» ");
INSERT INTO arbnav_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","وَقَالَ أَيْضاً لِمُوسَى: «هَكَذَا تَقُولُ لِشَعْبِ إِسْرَائِيلَ: إِنَّ الرَّبَّ ’الكَائِنَ‘ إِلهَ آبَائِكُمْ، إِلَهَ إبْرَاهِيمَ وَإِسْحاقَ وَيَعْقُوبَ قَدْ أَرْسَلَنِي إِلَيْكُمْ. هَذَا هُوَ اسْمِي إِلَى الْأَبَدِ، وَهُوَ الاسْمُ الَّذِي أُدْعَى بِهِ مِنْ جِيلٍ إِلَى جِيلٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","اذْهَبْ وَاجْمَعْ شُيُوخَ إِسْرَائِيلَ وَقُلْ لَهُمْ: إِنَّ الرَّبَّ إِلَهَ آبَائِكُمْ، إِلَهَ إبْرَاهِيمَ وَإِسْحَاقَ وَيَعْقُوبَ قَدْ تَجَلَّى لِي قَائِلاً: إنَّنِي حَقّاً قَدْ تَفَقَّدْتُكُمْ، وَشَهِدْتُ مَا أَصَابَكُمْ فِي مِصْرَ، ");
INSERT INTO arbnav_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","وَهَا أَنَا قَدْ وَعَدْتُ أَنْ أُخْرِجَكُمْ مِنْ ضِيقَةِ مِصْرَ إِلَى أَرْضِ الْكَنْعَانِيِّينَ وَالْحِثِّيِّينَ وَالأَمُورِيِّينَ وَالْفَرِزِّيِّينَ وَالْحِوِّيِّينَ وَالْيَبُوسِيِّينَ، هَذِهِ الأَرْضِ الَّتِي تَفِيضُ لَبَناً وَعَسَلاً، ");
INSERT INTO arbnav_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","فَيَسْتَمِعُ الشُّيُوخُ لِكَلامِكَ فَتَمْثُلُ أَنْتَ وَشُيُوخُ إِسْرَائِيلَ أَمَامَ مَلِكِ مِصْرَ وَتَقُولُ لَهُ: إِنَّ الرَّبَّ إِلَهَ الْعِبْرَانِيِّينَ قَدْ تَفَقَّدَنَا، فَدَعْنَا نَمْضِي مَسِيرَةَ ثَلاثَةِ أَيَّامٍ فِي الْبَرِّيَّةِ وَنُقَدِّمُ ذَبَائِحَ لِلرَّبِّ إِلَهِنَا. ");
INSERT INTO arbnav_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","وَلَكِنَّنِي عَالِمٌ أَنَّ مَلِكَ مِصْرَ لَنْ يُطْلِقَكُمْ مَا لَمْ تُرْغِمْهُ يَدٌ قَوِيَّةٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","فَأَمُدُّ يَدِي وأَضْرِبُ مِصْرَ بِجَمِيعِ وَيْلاتِي الَّتِي أَصْنَعُهَا فِيهَا، وَبَعْدَ ذَلِكَ يُطْلِقُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","وَأَجْعَلُ هَذَا الشَّعْبَ يَحْظَى بِرِضَى الْمِصْرِيِّينَ، فَلا تَخْرُجُونَ فَارِغِينَ حِينَ تَمْضُونَ، ");
INSERT INTO arbnav_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","بَلْ تَطْلُبُ كُلُّ امْرَأَةٍ مِنْ جَارَتِهَا أَوْ نَزِيلَةِ بَيْتِهَا جَوَاهِرَ فِضَّةٍ وَذَهَبٍ وَثِيَاباً تُلْبِسُونَهَا بَنِيكُمْ وَبَنَاتِكُمْ فَتَغْنَمُونَ ذَلِكَ مِنَ الْمِصْرِيِّينَ». ");
INSERT INTO arbnav_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","فَقَالَ مُوسَى: «مَاذَا إذَا لَمْ يُصَدِّقُونِي وَلَمْ يُصْغُوا إلَيَّ وَقَالُوا: إِنَّ الرَّبَّ لَمْ يَظْهَرْ لَكَ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","فَسَأَلَهُ الرَّبُّ: «مَا تِلْكَ الَّتِي بِيَدِكَ؟» فَأَجَابَ: «عَصاً». ");
INSERT INTO arbnav_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","فَقَالَ: «أَلْقِهَا عَلَى الأَرْضِ». فَأَلْقَاهَا فَإِذَا هِيَ حَيَّةٌ، فَهَرَبَ مِنْهَا مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","فَقَالَ الرَّبُّ لِمُوسَى: «مُدَّ يَدَكَ وَاقْبِضْ عَلَيْهَا مِنْ ذَيْلِهَا». فَمَدَّ مُوسَى يَدَهُ وَقَبَضَ عَلَيْهَا، فَارْتَدَّتْ عَصاً فِي يَدِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","وَقَالَ الرَّبُّ: «هَذَا لِكَي يُؤْمِنُوا أَنَّ الرَّبَّ إِلَهَ آبَائِكُمْ، إِلَهَ إبْرَاهِيمَ وَإِلَهَ إسْحاقَ وَإِلَهَ يَعْقُوبَ قَدْ ظَهَرَ لَكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ثُمَّ قَالَ الرَّبُّ أَيْضاً: «أَدْخِلْ يَدَكَ فِي عُبِّكَ». فَأَدْخَلَ يَدَهُ فِي عُبِّهِ. وَعِنْدَمَا أَخْرَجَهَا إِذَا بِها بَرْصَاءُ كَالثَّلْجِ. ");
INSERT INTO arbnav_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","وَأَمَرَهُ الرَّبُّ: «رُدَّ يَدَكَ إِلَى عُبِّكَ ثَانِيَةً». فَرَدَّ يَدَهُ إِلَى عُبِّهِ ثَانِيَةً ثُمَّ أَخْرَجَهَا مِنْ عُبِّهِ، وَإذَا بِها قَدْ عَادَتْ مِثْلَ بَاقِي جَسَدِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","وَقَالَ الرَّبُّ: «إِذَا لَمْ يُصَدِّقُوكَ، أَوْ يُعِيرُوا الْمُعْجِزَةَ الأُولَى انْتِبَاهَهُمْ، فَإِنَّهُمْ يُصَدِّقُونَ الثَّانِيَةَ. ");
INSERT INTO arbnav_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","وَإذَا لَمْ يُصَدِّقُوا هَاتَيْنِ الآيَتَيْنِ وَلَمْ يُصْغُوا لِكَلامِكَ، فَاغْرِفْ مِنْ مَاءِ النَّهْرِ وَاسْكُبْهُ عَلَى الْأَرْضِ الْجَافَّةِ، فَيَتَحَوَّلَ الْمَاءُ الَّذِي غَرَفْتَهُ مِنَ النَّهْرِ إِلَى دَمٍ فَوْقَ الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","فَقَالَ مُوسَى لِلرَّبِّ: «أَصْغِ يَا رَبُّ، أَنَا لَمْ أَكُنْ فِي يَوْمٍ مِنَ الأَيَّامِ فَصِيحاً، لَا فِي الأَمْسِ، وَلا مُنْذُ أَنْ خَاطَبْتَ عَبْدَكَ. إِنَّمَا أَنَا بَطِيءُ النُّطْقِ عَيِيُّ اللِّسَانِ». ");
INSERT INTO arbnav_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","فَقَالَ الرَّبُّ لَهُ: «مَنْ هُوَ بَارِئُ فَمِ الإِنْسَانِ؟ أَوْ مَنْ يَجْعَلُهُ أَخْرَسَ أَوْ أَصَمَّ أَوْ بَصِيراً أَوْ كَفِيفاً؟ أَلَسْتُ أَنَا، الرَّبَّ؟ ");
INSERT INTO arbnav_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","فَالآنَ انْطَلِقْ فَأُلَقِّنَ فَمَكَ النُّطْقَ، وَأُعَلِّمَكَ مَاذَا تَقُولُ». ");
INSERT INTO arbnav_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","لَكِنَّ مُوسَى أَجَابَ: «يَا سَيِّدُ، أَتَوَسَّلُ إِلَيْكَ أَنْ تُرْسِلَ مَنْ تَشَاءُ غَيْرِي». ");
INSERT INTO arbnav_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","فَاحْتَدَمَ غَضَبُ الرَّبِّ عَلَى مُوسَى وَقَالَ: «أَلَيْسَ هَرُونُ اللّاوِيُّ أَخَاكَ؟ أَنَا أَعْلَمُ أَنَّهُ يُحْسِنُ الْكَلامَ، وَهَا هُوَ أَيْضاً قَادِمٌ لِلِقَائِكَ. وَحَالَمَا يَرَاكَ يَبْتَهِجُ قَلْبُهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","فَتُحَدِّثُهُ وَتُلَقِّنُ فَمَهُ الْكَلامَ، فَأُعِينُكُمَا عَلَى الْقَوْلِ، وَأُعَلِّمُكُمَا مَاذَا تَفْعَلانِ، ");
INSERT INTO arbnav_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","فَيُخَاطِبُ هُوَ الشَّعْبَ عَنْكَ ويَكُونُ لَكَ بِمَثَابَةِ فَمٍ وَأَنْتَ تَكُونُ لَهُ بِمَثَابَةِ إِلَهٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","وَخُذْ بِيَدِكَ هَذِهِ الْعَصَا لِتَصْنَعَ بِها الْمُعْجِزَاتِ». ");
INSERT INTO arbnav_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","فَرَجَعَ مُوسَى إِلَى يَثْرُونَ حَمِيهِ وَقَالَ لَهُ: «دَعْنِي أَعُودُ إِلَى قَوْمِي فِي مِصْرَ لأَرَى أَمَازَالُوا بَعْدُ أَحْيَاءَ». فَأَجَابَ يَثْرُونُ مُوسَى: «اذْهَبْ بِسَلامٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","وَأَمَرَ الرَّبُّ مُوسَى فِي مِدْيَانَ: «هَيَّا ارْجِعْ إِلَى مِصْرَ، فَإِنَّهُ قَدْ مَاتَ جَمِيعُ السَّاعِينَ إِلَى الْقَضَاءِ عَلَيْكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","فَأَخَذَ مُوسَى امْرَأَتَهُ وَبَنِيهِ وَأَرْكَبَهُمْ عَلَى الْحَمِيرِ وَمَضَى عَائِداً إِلَى أَرْضِ مِصْرَ. وَأَخَذَ مَعَهُ عَصَا اللهِ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","وَقَالَ الرَّبُّ لِمُوسَى: «حَالَمَا تَرْجِعُ إِلَى مِصْرَ، تَذَكَّرْ أَنْ تُجْرِيَ أَمَامَ فِرْعَوْنَ جَمِيعَ الْعَجَائِبِ الَّتِي مَنَحْتُكَ الْقُوَّةَ عَلَى إِجْرَائِهَا، وَلَكِنَّنِي سَأُقَسِّي قَلْبَهُ لِكَيْ لَا يُطْلِقَ الشَّعْبَ. ");
INSERT INTO arbnav_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ثُمَّ قُلْ لِفِرْعَوْنَ: هَذَا مَا يَقُولُهُ الرَّبُّ: إِسْرَائِيلُ هُوَ ابْنِي الْبِكْرُ. ");
INSERT INTO arbnav_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","قُلْتُ لَكَ: أَطْلِقِ ابْنِي لِيَعْبُدَنِي، وَلَكِنَّكَ رَفَضْتَ إِطْلاقَهُ، لِذَلِكَ سَأُهْلِكُ ابْنَكَ الْبِكْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","وَفِي أَثْنَاءِ الطَّرِيقِ، بِالقُرْبِ مِنْ خَانٍ، الْتَقَاهُ الرَّبُّ وَهَمَّ أَنْ يَقْتُلَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","فَأَخَذَتْ صَفُّورَةُ صَوَّانَةً وَقَطَعَتْ قُلْفَةَ ابْنِهَا وَمَسَّتْ بِها قَدَمَيْ مُوسَى قَائِلَةً: «حَقّاً إِنَّكَ عَرِيسُ دَمٍ لِي». ");
INSERT INTO arbnav_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","فَعَفَا الرَّبُّ عَنْهُ. حِينَئِذٍ قَالَتْ: «عَرِيسُ دَمٍ مِنْ أَجْلِ الْخِتَانِ». ");
INSERT INTO arbnav_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","وَقَالَ الرَّبُّ لِهَرُونَ: «اذْهَبْ إِلَى الصَّحْرَاءِ لاِسْتِقْبَالِ مُوسَى». فَمَضَى وَالْتَقَاهُ عِنْدَ جَبَلِ الرَّبِّ وَقَبَّلَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","فَأَطْلَعَ مُوسَى هَرُونَ عَلَى جَمِيعِ كَلامِ الرَّبِّ الَّذِي حَمَّلَهُ إِيَّاهُ، وَمَا كَلَّفَهُ بِهِ مِنْ آيَاتٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ثُمَّ انْطَلَقَ مُوسَى وَهَرُونُ وَجَمَعَا كُلَّ شُيُوخِ بَنِي إِسْرَائِيلَ، ");
INSERT INTO arbnav_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","فَحَدَّثَهُمْ هَرُونُ بِجَمِيعِ مَا قَالَهُ الرَّبُّ لِمُوسَى. وَأَجْرَى مُوسَى الْمُعْجِزَاتِ أَمَامَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","فَآمَنَ الشَّعْبُ. وَعِنْدَمَا سَمِعُوا أَنَّ اللهَ قَدِ افْتَقَدَهُمْ وَنَظَرَ إِلَى مَذَلَّتِهِمْ انْحَنَوْا سَاجِدِينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","وَبَعْدَ ذَلِكَ ذَهَبَ مُوسَى وَهَرُونُ وَقَالا لِفِرْعَوْنَ: «هَذَا مَا يُعْلِنُهُ الرَّبُّ إِلَهُ إِسْرَائِيلَ: أَطْلِقْ شَعْبِي لِيَحْتَفِلَ لِي فِي الْبَرِّيَّةِ». ");
INSERT INTO arbnav_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","فَقَالَ فِرْعَوْنُ: «مَنْ هُوَ الرَّبُّ حَتَّى أُطِيعَ أَمْرَهُ وَأُطْلِقَ إِسْرَائِيلَ؟ أَنَا لَا أَعْرِفُ الرَّبَّ وَلَنْ أُطْلِقَ بَنِي إِسْرَائِيلَ». ");
INSERT INTO arbnav_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ثُمَّ قَالا: «إِنَّ إِلَهَ الْعِبْرَانِيِّينَ قَدِ الْتَقَانَا، فَدَعْنَا نَذْهَبُ مَسِيرَةَ ثَلاثَةِ أَيَّامٍ فِي الصَّحْرَاءِ لِنُقَدِّمَ ذَبَائِحَ لِلرَّبِّ إِلَهِنَا لِئَلّا يُعَاقِبَنَا بِوَبَأٍ أَوْ سَيْفٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","فَقَالَ لَهُمَا مَلِكُ مِصْرَ: «يَا مُوسَى وَهَرُونُ، لِمَاذَا تُعَطِّلانِ الشَّعْبَ عَنْ أَعْمَالِهِ؟ ارْجِعُوا إِلَى أَعْمَالِكُمُ الشَّاقَةِ». ");
INSERT INTO arbnav_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ثُمَّ قَالَ فِرْعَوْنُ: «هُوَذَا شَعْبُ الأَرْضِ قَدْ كَثُرَ الآنَ، وَأَنْتُمَا تُرِيدَانِ أَنْ تُرِيحَاهُمْ مِنَ الأَعْمَالِ الشَّاقَةِ». ");
INSERT INTO arbnav_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","فِي ذَلِكَ الْيَوْمِ أَمَرَ فِرْعَوْنُ الْقَائِمِينَ عَلَى تَسْخِيرِ الشَّعْبِ وَرُؤَسَاءَ الْعُمَّالِ قَائِلاً: ");
INSERT INTO arbnav_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«كُفُّوا عَنْ إِعْطَاءِ الشَّعْبِ تِبْناً لِصُنْعِ اللِّبْنِ كَمَا كُنْتُمْ تَفْعَلُونَ سَابِقاً، وَلْيَذْهَبُوا هُمْ وَيَجْمَعُوا تِبْناً لأَنْفُسِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","وَطَالِبُوهُمْ بِإِنْتَاجِ نَفْسِ كَمِّيَّةِ اللِّبْنِ السَّابِقَةِ. لَا تُنْقِصُوهَا فَإِنَّهُمْ كُسَالَى، لِذَلِكَ يَصْرُخُونَ قَائِلِينَ: دَعْنَا نَذْهَبُ وَنَذْبَحُ لإِلَهِنَا. ");
INSERT INTO arbnav_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ثَقِّلُوا الْعَمَلَ عَلَى كَوَاهِلِ الْقَوْمِ حَتَّى يَشْتَغِلُوا بِهِ وَلا يَلْتَفِتُوا إِلَى الأَقْوَالِ الْكَاذِبَةِ». ");
INSERT INTO arbnav_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","فَخَرَجَ مُسَخِّرُو الشَّعْبِ وَرُؤَسَاءُ الْعُمَّالِ وَخَاطَبُوا الشَّعْبَ قَائِلِينَ: «هَكَذَا يَقُولُ فِرْعَوْنُ: لَنْ أُعْطِيَكُمْ تِبْناً. ");
INSERT INTO arbnav_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","اذْهَبُوا أَنْتُمْ وَاجْمَعُوا لأَنْفُسِكُمْ تِبْناً حَيْثُ تَجِدُونَهُ عَلَى أَلّا يَنْقُصَ إِنْتَاجُكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","فَتَفَرَّقَ الشَّعْبُ فِي كُلِّ أَرْضِ مِصْرَ لِيَجْمَعُوا قَشّاً بَدَلاً مِنَ التِّبْنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","وَكَانَ الْمُسَخِّرُونَ يَلِحُّونَ عَلَيْهِمْ قَائِلِينَ: «أَوْفُوا أَعْمَالَكُمْ، إِنْتَاجَ كُلِّ يَوْمٍ بِيَوْمِهِ كَمَا كَانَ الْحَالُ حِينَ تَوَافَرَ التِّبْنُ». ");
INSERT INTO arbnav_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","وَجَلَدَ مُسَخِّرُو فِرْعَوْنَ رْؤَسَاءَ الْعُمَّالِ الَّذِينَ أَقَامُوهُمْ عَلَى بَنِي إِسْرَائِيلَ قَائِلِينَ لَهُمْ: «لِمَاذَا لَمْ تُوْفُوا قِسْطَكُمْ مِنْ إِنْتَاجِ اللِّبْنِ أَمْسِ وَالْيَوْمَ كَمَا كُنْتُمْ تَفْعَلُونَ سَابِقاً؟» ");
INSERT INTO arbnav_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","فَأَقْبَلَ رُؤَسَاءُ عُمَّالِ بَنِي إِسْرَائِيلَ وَتَوَسَّلُوا إِلَى فِرْعَوْنَ قَائِلِينَ: «لِمَاذَا تَفْعَلُ هَكَذَا بِعَبِيدِكَ؟ ");
INSERT INTO arbnav_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","إِنَّ عَبِيدَكَ لَا يَحْصُلُونَ عَلَى التِّبْنِ، وَمُطَالَبُونَ بِكَمِّيَّةِ اللِّبْنِ نَفْسِهَا، وَيُجْلَدُ عَبِيْدُكَ أَيْضاً. وَلَكِنَّ الذَّنْبَ هُوَ ذَنْبُ شَعْبِكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","غَيْرَ أَنَّهُ قَالَ: «أَنْتُمْ كُسَالَى، لِذَلِكَ تَقُولُونَ: دَعْنَا نَذْهَبُ لِنَذْبَحَ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","هَيَّا اذْهَبُوا وَاعْمَلُوا، فَالتِّبْنُ لَنْ يُعْطَى لَكُمْ، وَعَلَيْكُمْ أَنْ تُنْتِجُوا كَامِلَ كَمِّيَّةِ اللِّبْنِ نَفْسِهَا». ");
INSERT INTO arbnav_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","فَوَجَدَ رُؤَسَاءُ عُمَّالِ بَنِي إِسْرَائِيلَ أَنْفُسَهُمْ فِي وَرْطَةٍ سَيِّئَةٍ بَعْدَ أَنْ قِيلَ لَهُمْ أَنْتِجُوا مِنْ لِبْنِكُمْ فَرِيضَةَ كُلِّ يَوْمٍ بِيَوْمِهِ. لَا تُنْقِصُوا مِنْهَا شَيْئاً ");
INSERT INTO arbnav_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","وَصَادَفُوا مُوسَى وَهَرُونَ وَهُمَا وَاقِفَانِ فِي انْتِظَارِهِمْ عِنْدَ خُروجِهِمْ مِنْ لَدُنْ فِرْعَوْنَ ");
INSERT INTO arbnav_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","فَقَالُوا لَهُمَا: «لِيَنْظُرْ إِلَيْكُمَا الرَّبُّ وَيَقْضِ. لَقَدْ كَرَّهْتُمَا فِينَا فِرْعَوْنَ وَحَاشِيَتَهُ، وَأَعْطَيْتُمَاهُمْ سَيْفاً فِي أَيْدِيهِمْ لِيَقْتُلُونَا». ");
INSERT INTO arbnav_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","فَرَجَعَ مُوسَى إِلَى الرَّبِّ وَقَالَ: «لِمَاذَا أَسَأْتَ إِلَى شَعْبِكَ يَا رَبُّ؟ لِمَاذَا أَرْسَلْتَنِي؟ ");
INSERT INTO arbnav_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","فَمُنْذُ أَنْ جِئْتُ لأُخَاطِبَ فِرْعَوْنَ بِاسْمِكَ، أَسَاءَ إِلَى الشَّعْبِ، وَأَنْتَ لَمْ تُخَلِّصْ شَعْبَكَ عَلَى الإِطْلاقِ». ");
INSERT INTO arbnav_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","فَأَجَابَ الرَّبُّ مُوسَى: «سَتَرَى الآنَ مَا أَنَا فَاعِلُهُ بِفِرْعَوْنَ، لأَنَّنِي بِيَدٍ قَدِيرَةٍ سَأَجْعَلُهُ يُطْلِقُهُمْ، بَلْ يَطْرُدُهُمْ طَرْداً أَيْضاً». ");
INSERT INTO arbnav_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","وَقَالَ الرَّبُّ لِمُوسَى: «أَنَا هُوَ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","قَدْ ظَهَرْتُ لإِبْرَاهِيمَ وَإِسْحاقَ وَيَعْقُوبَ إِلَهاً قَدِيراً عَلَى كُلِّ شَيْءٍ. أَمَّا اسْمِي يَهْوَهْ (أَيِ الرَّبُّ) فَلَمْ أُعْلِنْهُ لَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","وَقَدْ قَطَعْتُ مَعَهُمْ أَيْضاً عَهْدِي بِأَنْ أَهَبَهُمْ أَرْضَ كَنْعَانَ حَيْثُ أَقَامُوا فِيهَا كَغُرَبَاءَ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","كَذَلِكَ أَصْغَيْتُ إِلَى أَنِينِ بَنِي إِسْرَائِيلَ الْمُسْتَعْبَدِينَ الْمِصْرِيِّينَ، وَتَذَكَّرْتُ عَهْدِي ");
INSERT INTO arbnav_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","لِهَذَا قُلْ لِبَنِي إِسْرَائِيلَ إِنَّنِي أَنَا الرَّبُّ وَأَنَا أُحَرِّرُكُمْ مِنْ أَثْقَالِ الْمِصْرِيِّينَ وَأُنْقِذُكُمْ مِنْ عُبُودِيَّتِهِمْ، وَأُخَلِّصُكُمْ بِذِرَاعٍ مَمْدُودَةٍ وَأَحْكَامٍ قَوِيَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","وَأَتَّخِذُكُمْ لِي شَعْباً وَأَكُونُ لَكُمْ إِلَهاً، فَتَعْرِفُونَ أَنِّي أَنَا الرَّبُّ إِلَهُكُمْ مُحَرِّرُكُمْ مِنْ أَثْقَالِ الْمِصْرِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","وَأَقُودُكُمْ إِلَى الأَرْضِ الَّتِي أَقْسَمْتُ أَنْ أَهَبَهَا لإِبْرَاهِيمَ وإِسْحَاقَ وَيَعْقُوبَ لأُعْطِيَهَا لَكُمْ مِلْكاً. أَنَا هُوَ الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","فَخَاطَبَ مُوسَى بَنِي إِسْرَائِيلَ، لَكِنَّهُمْ لَمْ يُصْغُوا إِلَيْهِ لِتَوَجُّعِ نُفُوسِهِمْ وَعُبُودِيَّتِهِمِ الْقَاسِيَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«امْثُلْ أَمَامَ فِرْعَوْنَ مَلِكِ مِصْرَ وَاطْلُبْ إِلَيْهِ أَنْ يُطْلِقَ بَنِي إِسْرَائِيلَ مِنَ الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","فَأَجَابَ مُوسَى: «هُوَذَا بَنُو إِسْرَائِيلَ لَمْ يُصْغُوا إِلَيَّ، فَكَيْفَ يَسْتَمِعُ إِلَيَّ فِرْعَوْنُ وَأَنَا ثَقِيلُ اللِّسَانِ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","فَخَاطَبَ الرَّبُّ مُوسَى وَهَرُونَ وَأَمَرَهُمَا أَنْ يَرْجِعَا إِلَى بَنِي إِسْرَائِيلَ، وَفِرْعَوْنَ مَلِكِ مِصْرَ، لِكَيْ يُطْلِقَ بَنِي إِسْرَائِيلَ مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","وَهَؤُلاءِ هُمْ رُؤَسَاءُ الْعَشَائِرِ الْمُتَفَرِّعَةِ عَنْ أَبْنَاءِ إِسْرَائِيلَ: أَبْنَاءُ رَأُوبَيْنَ بِكْرِ إِسْرَائِيلَ حَنُوكُ وَفَلُّو وَحَصْرُونُ وَكَرْمِي: هَذِهِ عَشَائِرُ رَأُوبَيْنَ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","أَبْنَاءُ شِمْعُونَ يَمُوئِيلُ وَيَامِينُ وَأُوهَدُ وَيَاكِينُ وَصُوحَرُ وَشَأُولُ وأُمُّهُ كَنْعَانِيَّةٌ: هَذِهِ هِي عَشَائِرُ شِمْعُونَ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","وَهَذِهِ أَسْمَاءُ أَبْنَاءِ لاوِي حَسَبَ عَشَائِرِهِمْ: جِرْشُونُ وَقَهَاتُ وَمَرَارِي. وَقَدْ عَاشَ لاوِي مِئَةً وَسَبْعاً وَثَلاثِينَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","أَمَّا ابْنَا جِرْشُونَ حَسَبَ عَشَائِرِهِمَا فَهُمَا: لِبْنِي وَشِمْعِي. ");
INSERT INTO arbnav_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","وَأَبْنَاءُ قَهَاتَ هُمْ: عَمْرَامُ وَيِصْهَارُ وَحَبْرُونُ وَعُزِّيئِيلُ. وَقَدْ عَاشَ قَهَاتُ مِئَةً وَثَلاثاً وَثَلاثِينَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","وَابْنَا مَرَارِي هُمَا مَحْلِي وَمُوشِي. هَذِهِ هِيَ عَشَائِرُ اللّاوِيِّينَ بِحَسَبِ سِجِلِّ مَوَالِيدِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","وَتَزَوَّجَ عَمْرَامُ عَمَّتَهُ يُوكَابَدَ فَأَنْجَبَتْ لَهُ هَرُونَ وَمُوسَى. وَقَدْ عَاشَ عَمْرَامُ مِئَةً وَسَبْعاً وَثَلاثِينَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","وَأَبْنَاءُ يِصْهَارَ هُمْ: قُورَحُ وَنَافَجُ وَذِكْرِي. ");
INSERT INTO arbnav_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","أَبْنَاءُ عُزِّيئِيلَ هُمْ: مِيشَائِيلُ وأَلْصَافَانُ وَسِتْرِي ");
INSERT INTO arbnav_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","وَتَزَوَّجَ هَرُونُ مِنْ أَلِيشَابَعَ ابْنَةِ عَمِّينَادَابَ أُخْتِ نَحْشُونَ فَأَنْجَبَتْ لَهُ نَادَابَ وَأَبِيهُوَ وَأَلِعَازَارَ وإِيثَامَارَ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","وَأَبْنَاءُ قُورَحَ هُمْ: أَسِّيرُ وَأَلْقَانَةُ وَأَبِيَأَسَافُ: هَذِهِ هِيَ عَشَائِرُ الْقُورَحِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","وَتَزَوَّجَ أَلِعَازَارُ بنُ هَرُونَ مِنْ إِحْدَى بَنَاتِ فُوطِيئِيلَ فَأَنْجَبَتْ لَهُ فِيْنحَاسَ. هَؤُلاءِ رُؤَسَاءُ آبَاءِ اللّاوِيِّينَ بِحَسَبِ تَرْتِيبِ عَشَائِرِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","هَذَانِ هُمَا هَروُنُ وَمُوسَى اللَّذَانِ قَالَ لَهُمَا الرَّبُّ: أَخْرِجَا بَنِي إِسْرَائِيلَ مِنْ أَرْضِ مِصْرَ بِحَسَبِ فِرَقِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","وَهُمَا نَفْسُ مُوسَى وَهَرُونَ اللَّذَيْنِ خَاطَبَا فِرْعَوْنَ مَلِكَ مِصْرَ لِيُطْلِقَ بَنِي إِسْرَائِيلَ مِنْ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","وَحَدَثَ فِي الْيَوْمِ الَّذي كَلَّمَ فِيهِ الرَّبُّ مُوسَى فِي أَرْضِ مِصْرَ ");
INSERT INTO arbnav_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","أَنَّ الرَّبَّ قَالَ لَهُ: «أَنَا الرَّبُّ بَلِّغْ فِرْعَوْنَ كُلَّ مَا أَقُولُهُ لَكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","فَأَجَابَهُ مُوسَى: «أَنَا ثَقِيلُ اللِّسَانِ فَكَيْفَ يَسْتَمِعُ لِي فِرْعَوْنُ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","فَقَالَ الرَّبُّ لِمُوسَى: «أَنَا جَعَلْتُكَ كإِلَهٍ لِفِرْعَوْنَ، وَهَرُونُ أَخُوكَ يَكُونُ كَنَبِيٍّ لَكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","فَعَلَيْكَ أَنْ تُبْلِغَهُ بِكُلِّ مَا آمُرُكَ بِهِ، وَيُخَاطِبَ أَخُوكَ هَرُونُ فِرْعَوْنَ كَيْ يُطْلِقَ سَرَاحَ بَنِي إِسْرَائِيلَ مِنْ بِلادِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","وَلَكِنَّنِي أُقَسِّي قَلْبَ فِرْعَوْنَ فَأُكَثِّرُ آيَاتِي وَعَجَائِبِي فِي أَرْضِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","إلّا أَنَّ فِرْعَوْنَ لَنْ يَسْتَمِعَ لَكُمَا. عِنْدَئِذٍ أَضْرِبُ مِصْرَ وَأُخْرِجُ شَعْبِي إِسْرَائِيلَ مِنْ أَرْضِ مِصْرَ بِقُوَّاتِ أَحْكَامٍ عَظِيمَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","فَيُدْرِكُ الْمِصْرِيُّونَ حِينَ أَضْرِبُ مِصْرَ وَأُخْرِجُ بَنِي إِسْرَائِيلَ مِنْ بَيْنِهِمُ أَنَّنِي أَنَا الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","فَفَعَلَ مُوسَى وَهَرُونُ تَمَاماً كَمَا أَمَرَهُمَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","وَكَانَ مُوسَى فِي الثَّمَانِينَ مِنْ عُمْرِهِ، وَهَرُونُ فِي الثَّالِثَةِ وَالثَّمَانِينَ، عِنْدَمَا خَاطَبَا فِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","وَقَالَ الرَّبُّ لِمُوسَى وَهَرُونَ: ");
INSERT INTO arbnav_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«عِنْدَمَا يَطْلُبُ فِرْعَوْنُ مِنْكُمَا قَائِلاً: أَرِيَانِي عَجِيبَةً فَإِنَّكَ تَقُولُ لِهَرُونَ: خُذْ عَصَاكَ وَأَلْقِهَا أَمَامَ فِرْعَوْنَ فَتَتَحَوَّلَ إِلَى حَيَّةٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","فَمَثُلَ هَرُونُ وَمُوسَى أَمَامَ فِرْعَوْنَ وَفَعَلا تَمَاماً حَسَبَ أَمْرِ الرَّبِّ، فَأَلْقَى هَرُونُ عَصَاهُ أَمَامَ فِرْعَوْنَ وَأَمَامَ حَاشِيَتِهِ فَتَحَوَّلَتْ إِلَى حَيَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","فَاسْتَدْعَى فِرْعَوْنُ حُكَمَاءَهُ وَسَحَرَتَهُ فَصَنَعَ سَحَرَةُ مِصْرَ عَلَى غِرَارِ ذَلِكَ بِسِحْرِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","فَطَرَحَ كُلُّ وَاحِدٍ عَصَاهُ فَتَحَوَّلَتْ إِلَى حَيَّةٍ. غَيْرَ أَنَّ عَصَا هَرُونَ ابْتَلَعَتْ عِصِيَّهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","لَكِنَّ قَلْبَ فِرْعَوْنَ ازْدَادَ تَصَلُّباً فَلَمْ يَسْتَمِعْ لَهُمَا، تَمَاماً كَمَا قَالَ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: «إِنَّ قَلْبَ فِرْعَوْنَ قَدْ تَصَلَّبَ، وَهُوَ يَرْفُضُ أَنْ يُطْلِقَ سَرَاحَ الشَّعْبِ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","فَامْثُلْ أَمَامَ فِرْعَوْنَ فِي الْغَدِ عِنْدَمَا يَخْرُجُ إِلَى الْمَاءِ، وَقِفْ لِلِقَائِهِ عِنْدَ ضَفَّةِ النَّهْرِ، وَخُذْ بِيَدِكَ الْعَصَا الَّتِي تَحَوَّلَتْ إِلَى حَيَّةٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","وَقُلْ لَهُ: إِنَّ الرَّبَّ إِلَهَ الْعِبْرَانِيِّينَ قَدْ أَرْسَلَنِي إِلَيْكَ قَائِلاً: أَطْلِقْ شَعْبِي لِيَعْبُدُونِي فِي الصَّحْرَاءِ. وَهَا أَنْتَ حَتَّى الآنَ لَمْ تَسْتَمِعْ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","لِهَذَا إِلَيْكَ مَا يَقُولُهُ الرَّبُّ: سَتَعْلَمُ، بِمَا أُجْرِيهِ الآنَ، أَنَّنِي أَنَا الرَّبُّ. هَا أَنَا ضَارِبٌ بِهَذِهِ الْعَصَا الَّتِي فِي يَدِي عَلَى مَاءِ النَّهْرِ فَيَتَحَوَّلُ دَماً. ");
INSERT INTO arbnav_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","فَيَمُوتُ السَّمَكُ، وَيَنْتِنُ النَّهْرُ، فَيَعَافُ الْمِصْرِيُّونَ مِنَ الشُّرْبِ مِنْ مَائِهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","وَخَاطَبَ الرَّبُّ مُوسَى: «قُلْ لِهَرُونَ: خُذْ عَصَاكَ وَابْسُطْ يَدَكَ عَلَى مِيَاهِ الْمِصْرِيِّينَ وَعَلَى أَنْهَارِهِمْ وَعَلَى جَدَاوِلِهِمْ وَسَوَاقِيهِمْ وَخَزَّانَاتِ الْمِيَاهِ فَتَتَحَوَّلَ كُلُّهَا إِلَى دَمٍ، وَيَكُونُ دَمٌ فِي كُلِّ أَرْضِ مِصْرَ حَتَّى فِي الأَوَانِي الْخَشَبِيَّةِ وَالْحَجَرِيَّةِ». ");
INSERT INTO arbnav_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","وَهَكَذَا فَعَلَ مُوسَى وَهَرُونُ كَمَا أَمَرَ الرَّبُّ، فَرَفَعَ هَرُونُ الْعَصَا وَضَرَبَ مَاءَ النَّهْرِ عَلَى مَشْهَدٍ مِنْ فِرْعَوْنَ وَحَاشِيَتِهِ فَتَحَوَّلَ كُلُّ مَاءِ النَّهْرِ إِلَى دَمٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","وَمَاتَ كُلُّ سَمَكِهِ وَأَنْتَنَ النَّهْرُ فَلَمْ يَسْتَطِعِ الْمِصْرِيُّونَ الشُّرْبَ مِنْ مَائِهِ. وَكَانَ دَمٌ فِي كُلِّ أَرْجَاءِ أَرْضِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","وَكَذَلِكَ فَعَلَ سَحَرَةُ مِصْرَ بِسِحْرِهِمْ، فَتَصَلَّبَ قَلْبُ فِرْعَوْنَ فَلَمْ يَسْتَمِعْ إِلَيْهِمَا، تَمَاماً حَسَبَ قَوْلِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","وَانْصَرَفَ فِرْعَوْنُ إِلَى مَنْزِلِهِ مِنْ غَيْرِ أَنْ يَتْرُكَ ذَلِكَ أَثَراً فِي قَلْبِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","وَحَفَرَ جَمِيعُ الْمِصْرِيِّينَ حُفَراً حَوْلَ النَّهْرِ طَلَباً لِمَاءِ الشُّرْبِ، لأَنَّهُمْ لَمْ يَسْتَطِيعُوا أَنْ يَشْرَبُوا مِنْ مَاءِ النَّهْرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","وَانْقَضَتْ سَبْعَةُ أَيَّامٍ مُنْذُ أَنْ ضَرَبَ اللهُ مِيَاهَ النَّهْرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: «امْثُلْ أَمَامَ فِرْعَوْنَ وَقُلْ لَهُ: هَذَا مَا يُعْلِنُهُ الرَّبُّ: أَطْلِقْ شَعْبِي لِيَعْبُدُونِي. ");
INSERT INTO arbnav_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","وَإِنْ أَبَيْتَ أَنْ تُطْلِقَهُمْ فَهَا أَنَا ضَارِبٌ جَمِيعَ تُخُومِكَ بِالضَّفَادِعِ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","فَيَفِيضُ النَّهْرُ بِالضَّفَادِعِ الَّتِي تَصْعَدُ وَتَقْتَحِمُ بَيْتَكَ وَمُخْدَعَ فِرَاشِكَ وَسَرِيرَكَ وَبُيُوتَ حَاشِيَتِكَ وَشَعْبِكَ وَأَفْرَانَكَ وَمَعَاجِنَكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","عَلَيْكَ وَعَلَى شَعْبِكَ وَعَلَى سَائِرِ حَاشِيَتِكَ تَصْعَدُ الضَّفَادِعُ». ");
INSERT INTO arbnav_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: «قُلْ لِهَرُونَ ابْسُطْ يَدَكَ بِعَصَاكَ عَلَى الأَنْهَارِ وَالسَّوَاقِي وَالْبِرَكِ وَأَصْعِدِ الضَّفَادِعَ عَلَى كُلِّ أَرْضِ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","فَبَسَطَ هَرُونُ يَدَهُ عَلَى مِيَاهِ مِصْرَ فَأَقْبَلَتِ الضَّفَادِعُ وَغَطَّتْ أَرْضَ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","وَكَذَلِكَ فَعَلَ السَّحَرَةُ بِسِحْرِهِمْ فَأَصْعَدُوا ضَفَادِعَ عَلَى أَرْضِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ثُمَّ اسْتَدْعَى فِرْعَوْنُ مُوسَى وَهَرُونَ وَقَالَ: «تَضَرَّعَا إِلَى الرَّبِّ لِيَرْفَعَ الضَّفَادِعَ عَنِّي وَعَنْ شَعْبِي، فَأُطْلِقَ الشَّعْبَ لِيُقَدِّمُوا ذَبَائِحَ لَهُ». ");
INSERT INTO arbnav_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","فَأَجَابَ مُوسَى فِرْعَوْنَ: «عَيِّنْ لِي مَتَى أُصَلِّي مِنْ أَجْلِكَ وَمِنْ أَجْلِ عَبِيدِكَ وَشَعْبِكَ، لِكَيْ تُبَادَ الضَّفَادِعُ عَنْكَ وَعَنْ بُيُوتِكَ، مَاعَدَا تِلْكَ الْبَاقِيَةَ فِي النَّهْرِ». ");
INSERT INTO arbnav_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","فَقَالَ فِرْعَوْنُ: «غَداً». فَأَجَابَهُ مُوسَى: «فَلْيَكُنْ كَقَوْلِكَ، لِتَعْرِفَ أَنَّهُ لَا مَثِيلَ لِلرَّبِّ إِلَهِنَا. ");
INSERT INTO arbnav_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","فَإِنَّ الضَّفَادِعَ سَتَنْسَحِبُ مِنْ حَوْلِكَ وَمِنْ بُيُوتِكَ وَمِنْ حَوْلِ حَاشِيَتِكَ وَشَعْبِكَ، وَلا تَبْقَى إلّا فِي النَّهْرِ». ");
INSERT INTO arbnav_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","وَبَعْدَ أَنِ انْصَرَفَ مُوسَى وَهَرُونُ مِنْ لَدُنْ فِرْعَوْنَ صَلَّى مُوسَى إِلَى الرَّبِّ مِنْ أَجْلِ الضَّفَادِعِ الَّتِي أَصْعَدَهَا عَلَى فِرْعَوْنَ، ");
INSERT INTO arbnav_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","فَفَعَلَ الرَّبُّ حَسَبَ دُعَاءِ مُوسَى، فَانْقَطَعَتِ الضَّفَادِعُ مِنَ الْبُيُوتِ وَالدُّورِ وَالْحُقُولِ، ");
INSERT INTO arbnav_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","فَجمَعُوهَا أَكْوَاماً كَثِيَرةً حَتَّى أَنْتَنَتْ مِنْهَا الأَرْضُ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","وَعِنْدَمَا رَأَى فِرْعَوْنُ أَنَّ الْبَلِيَّةَ قَدِ انْقَشَعَتْ، أَغْلَظَ قَلْبَهُ وَلَمْ يَسْتَمِعْ لَهُمَا، تَمَاماً كَمَا قَالَ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","فَقَالَ الرَّبُّ لِمُوسَى: «قُلْ لِهَرُونَ أَنْ يَبْسُطَ يَدَهُ بِعَصَاهُ وَيَضْرِبَ تُرَابَ الأَرْضِ لِيَملأَ الْبَعُوضُ كُلَّ أَرْجَاءِ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","وَهَكَذَا فَعَلا، إِذْ بَسَطَ هَرُونُ يَدَهُ بِعَصَاهُ وَضَرَبَ تُرَابَ الأَرْضِ، فَانْتَشَرَ الْبَعُوضُ عَلَى النَّاسِ وَالْبَهَائِمِ. فَصَارَ كُلُّ تُرَابِ الأَرْضِ بَعُوضاً فِي جَمِيعِ أَرْجَاءِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","وَكَذَلِكَ حَاوَلَ السَّحَرَةُ بِسِحْرِهِمْ لِيُخْرِجُوا الْبَعُوضَ فَأَخْفَقُوا. وَكَانَ الْبَعُوضُ مُنْتَشِراً عَلَى النَّاسِ وَالْبَهَائِمِ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","فَقَالَ السَّحَرَةُ لِفِرْعَوْنَ «إِنَّهُ فِعْلُ اللهِ». وَلَكِنَّ قَلْبَ فِرْعَوْنَ ظَلَّ مُتَصَلِّباً فَلَمْ يَسْمَعْ لَهُمَا، تَمَاماً كَمَا قَالَ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: «انْهَضْ مُبَكِّراً فِي الصَّبَاحِ وَقِفْ أَمَامَ فِرْعَوْنَ عِنْدَ خُرُوجِهِ إِلَى الْمَاءِ وَقُلْ لَهُ: هَكَذَا يَقُولُ الرَّبُّ: أَطْلِقْ شَعْبِي لِيَعْبُدُونِي. ");
INSERT INTO arbnav_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","وَإِنْ لَمْ تُطْلِقْ شَعْبِي فَهَا أَنَا أُرْسِلُ أَسْرَابَ الذُّبَابِ عَلَيْكَ وَعَلَى حَاشِيَتِكَ وَعَلَى شَعْبِكَ وَعَلَى بُيُوتِكَ، فَتَمْتَلِئُ بُيُوتُ الْمِصْرِيِّينَ بِالذُّبَابِ، وَكَذَلِكَ الأَرْضُ الَّتِي يُقِيمُونَ عَلَيْهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","وَلَكِنِّي فِي ذَلِكَ الْيَوْمِ أَسْتَثْنِي أَرْضَ جَاسَانَ حَيْثُ يَسْكُنُ شَعْبِي فَلا يَغْزُوهَا الذُّبَابُ، فَتُدْرِكُ أَنَّنِي، أَنَا الرَّبَّ، كَائِنٌ فِي هَذِهِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","وَأُمَيِّزُ بَيْنَ شَعْبِي وَشَعْبِكَ، فَتَكُونُ هَذِهِ آيَةَ الْغَدِ». ");
INSERT INTO arbnav_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","وَهَكَذَا صَنَعَ الرَّبُّ، فَقَدْ غَزَتْ أَسْرَابٌ عَظِيمَةٌ مِنَ الذُّبَابِ بَيْتَ فِرْعَوْنَ وَبُيُوتَ حَاشِيَتِهِ، وَكُلَّ أَرْضِ مِصْرَ فَأَصَابَ الذُّبَابُ الأَرْضَ بِالْخَرَابِ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","فَاسْتَدْعَى فِرْعَوْنُ مُوسَى وَهَرُونَ وَقَالَ: «امْضُوا وَقَدِّمُوا ذَبِيحَةً لإِلَهِكُمْ فِي هَذِهِ الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","فَأَجَابَ مُوسَى: «لَيْسَ مُسْتَحْسَناً أَنْ نَفْعَلَ هَذَا، لأَنَّ الذَّبَائِحَ الَّتِي نُقَدِّمُهَا لِلرَّبِّ إِلَهِنَا هِي رِجْسٌ لَدَى الْمِصْرِيِّينَ. فَإِنْ قَدَّمْنَا هَذِهِ الذَّبَائِحَ الَّتِي يَكْرَهُهَا الْمِصْرِيُّونَ، أَلا يَرْجُمُونَنَا؟ ");
INSERT INTO arbnav_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","لَكِنْ نَذْهَبُ مَسِيرَةَ ثَلاثَةِ أَيَّامٍ فِي الصَّحْرَاءِ، فَنُقَدِّمُ ذَبَائِحَ لِلرَّبِّ إِلَهِنَا كَمَا أَمَرَنَا». ");
INSERT INTO arbnav_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","فَقَالَ فِرْعَوْنُ: «سَأُطْلِقُكُمْ لِتُقَرِّبُوا لِلرَّبِّ إِلَهِكُمْ فِي الصَّحْرَاءِ، وَلَكِنْ لَا تَذْهَبُوا بَعِيداً. صَلِّيَا لأَجْلِي». ");
INSERT INTO arbnav_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","فَأَجَابَ مُوسَى: «حَالَمَا أَنْصَرِفُ أُصَلِّي إِلَى الرَّبِّ. وَغَداً يَرْتَفِعُ الذُّبَابُ عَنْ فِرْعَوْنَ وَعَنْ حَاشِيَتِهِ وَعَنْ شَعْبِهِ. وَلَكِنْ عَلَى فِرْعَوْنَ أَلّا يُخَادِعَ، بَلْ يُطْلِقَ الشَّعْبَ لِيُقَدِّمَ لِلرَّبِّ ذَبَائِحَ». ");
INSERT INTO arbnav_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","وَفَارَقَ مُوسَى فِرْعَوْنَ وَصَلَّى إِلَى الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","فَاسْتَجَابَ الرَّبُّ دُعَاءَ مُوسَى، فَارْتَفَعَ الذُّبَابُ عَنْ فِرْعَوْنَ وَعَنْ حَاشِيَتِهِ وَعَنْ شَعْبِهِ. لَمْ تَبْقَ ذُبَابَةٌ وَاحِدَةٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","وَلَكِنَّ فِرْعَوْنَ قَسَّى قَلْبَهُ هَذِهِ الْمَرَّةَ أَيْضاً وَلَمْ يُطْلِقْ الشَّعْبَ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: «امْضِ إِلَى فِرْعَوْنَ وَقُلْ لَهُ: هَذَا مَا يُعْلِنُهُ إِلَهُ الْعِبْرَانِيِّينَ أَطْلِقْ شَعْبِي لِيَعْبُدَنِي. ");
INSERT INTO arbnav_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","لأَنَّكَ إنْ أَبَيْتَ أَنْ تُطْلِقَهُمْ وَحَجَزْتَهُمْ لَدَيْكَ، ");
INSERT INTO arbnav_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","فَإِنَّ يَدَ الرَّبِّ سَتُهْلِكُ مَوَاشِيكَ الَّتِي فِي الْحُقُولِ، وَالْخُيُولَ، وَالْحَمِيرَ وَالجِّمَالَ وَالْثِّيرَانَ وَالْغَنَمَ، بِوَبَأٍ شَدِيدٍ جِدّاً. ");
INSERT INTO arbnav_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","وَأُمَيِّزُ بَيْنَ مَوَاشِي إِسْرَائِيلَ وَمَوَاشِي الْمِصْرِيِّينَ. فَلا يَهْلِكُ شَيْءٌ لِبَنِي إِسْرَائِيلَ». ");
INSERT INTO arbnav_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","وَعَيَّنَ الرَّبُّ مَوْعِداً لِذَلِكَ قَائِلاً: «غَداً يَصْنَعُ الرَّبُّ هَذَا فِي الأَرْضِ». ");
INSERT INTO arbnav_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","وَفِي الْغَدِ صَنَعَ الرَّبُّ هَذَا الأَمْرَ. فَهَلَكَتْ جَمِيعُ مَوَاشِي الْمِصْرِيِّينَ، أَمَّا مَوَاشِي بَنِي إِسْرَائِيلَ فَلَمْ يَهْلِكْ مِنْهَا وَاحِدٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","وَأَرْسَلَ فِرْعَوْنُ لِيَتَحَقَّقَ مِنَ الأَمْرِ، وَإذَا مَوَاشِي إِسْرَائِيلَ لَمْ يَهْلِكْ مِنْهَا وَاحِدٌ. وَتَصَلَّبَ قَلْبُ فِرْعَوْنَ فَلَمْ يُطْلِقْ الشَّعْبَ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","فَقَالَ الرَّبُّ لِمُوسَى وَهَرُونَ: «لِيَأْخُذْ كُلٌّ مِنْكُمَا حَفْنَةً مِنْ رَمَادِ الْأَتُونِ، وَلْيُذَرِّ مُوسَى الرَّمَادَ نَحْوَ السَّمَاءِ بِمَرْأَى مِنْ فِرْعَوْنَ، ");
INSERT INTO arbnav_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","فَيَتَحَوَّلَ إِلَى غُبَارٍ يُغَطِّي كُلَّ أَرْضِ مِصْرَ، فَيُصَابَ النَّاسُ وَالْبَهَائِمُ بِدَمَامِلَ مُتَقَيِّحَةٍ فِي كُلِّ أَرْضِ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","فَأَخَذَا رَمَاداً مِنَ الأَتُونِ، وَوَقَفَا أَمَامَ فِرْعَوْنَ، ثُمَّ ذَرَّاهُ مُوسَى نَحْوَ السَّمَاءِ، فَتَحَوَّلَ إِلَى دَمَامِلَ مُتَقَيِّحَةٍ أَصَابَتِ النَّاسَ وَالْبَهَائِمَ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","وَلَمْ يَسْتَطِعِ السَّحَرَةُ أَنْ يُواجِهُوا مُوسَى مِن جَرَّاءِ الدَّمَامِلِ، لأَنَّ الدَّمَامِلَ أَصَابَتِ السَّحَرَةَ وَكُلَّ الْمِصْرِيِّينَ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","لَكِنَّ الرَّبَّ قَسَّى قَلْبَ فِرْعَوْنَ فَلَمْ يَسْمَعْ لَهُمَا، تَمَاماً كَمَا قَالَ الرَّبُّ لِمُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: «قُمْ مُبَكِّراً فِي الصَّبَاحِ وَامْثُلْ أَمَامَ فِرْعَوْنَ وَقُلْ لَهُ: هَذَا مَا يُعْلِنُهُ الرَّبُّ إِلَهُ الْعِبْرَانِيِّينَ: أَطْلِقْ شَعْبِي لِيَعْبُدَنِي. ");
INSERT INTO arbnav_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","لأَنَّنِي فِي هَذِهِ الْمَرَّةِ سَأُوَجِّهُ جَمِيعَ ضَرَبَاتِي إِلَى قَلْبِكَ وَإِلَى حَاشِيَتِكَ وَإِلَى شَعْبِكَ، لِكَيْ تَعْرِفَ أَنَّهُ لَيْسَ مَثِيلٌ لِي فِي كُلِّ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","فَقَدْ كَانَ بِوُسْعِي حَتَّى الآنَ أَنْ أَمُدَّ يَدِي وَأَضْرِبَكَ وَأَضْرِبَ شَعْبَكَ أَيْضاً بِالوَبَأِ لِتُبَادَ مِنَ الأَرْضِ، ");
INSERT INTO arbnav_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","وَلَكِنَّنِي أَقَمْتُكَ لأُرِيَكَ قُوَّتِي، وَلِكَيْ يُذَاعَ اسْمِي فِي جَمِيعِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","وَهَا أَنْتَ مَازِلْتَ تُقَاوِمُ شَعْبِي وَلا تُطْلِقُهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","لِذَلِكَ غَداً فِي مِثْلِ هَذَا الْوَقْتِ أُمْطِرُ بَرَداً ثَقِيلاً لَمْ تَشْهَدْهُ مِصْرُ مُنْذُ يَوْمِ تَأْسِيسِهَا حَتَّى الآنَ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","فَأَرْسِلِ الآنَ وَاجْمَعْ مَوَاشِيَكَ وَكُلَّ مَالَكَ فِي الْحَقْلِ، لأَنَّ كُلَّ مَنْ يَمْكُثُ فِي الْحَقْلِ مِنَ النَّاسِ وَالْبَهَائِمِ وَلا يَلْجَأُ إِلَى مَأْوىً، يَنْهَمِرُ عَلَيْهِ الْبَرَدُ فَيَمُوتُ». ");
INSERT INTO arbnav_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","فَكُلُّ مَنْ خَافَ كَلِمَةَ الرَّبِّ مِنْ رِجَالِ فِرْعَوْنَ لاذَ بِعَبِيدِهِ وَمَاشِيَتِهِ بِالْبُيُوتِ، ");
INSERT INTO arbnav_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","أَمَّا الَّذِينَ اسْتَخَفُّوا بِكَلامِ الرَّبِّ فَقَدْ تَرَكُوا عَبِيدَهُمْ وَمَوَاشِيَهُمْ فِي الْحَقْلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","وَقَالَ الرَّبُّ لِمُوسَى: «مُدَّ يَدَكَ نَحْوَ السَّمَاءِ فَيَنْهَمِرَ الْبَرَدُ عَلَى كُلِّ أَرْضِ مِصْرَ، وَعَلَى الرِّجَالِ وَالْبَهَائِمِ وَعَلَى عُشْبِ الْحَقْلِ فِي جَمِيعِ أَرْضِ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","فَمَدَّ مُوسَى عَصَاهُ نَحْوَ السَّمَاءِ، فَأَرْسَلَ الرَّبُّ رُعُوداً وَبَرَداً. وَأَصَابَتِ الصَّوَاعِقُ الأَرْضَ، وَأَمْطَرَ الرَّبُّ بَرَداً عَلَى كُلِّ بِلادِ مِصْرَ، ");
INSERT INTO arbnav_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","فَانْهَمَرَ الْبَرَدُ، وَاخْتَلَطَتِ الصَّوَاعِقُ بِالْبَرَدِ، فَكَانَتْ أَسْوَأَ عَاصِفَةٍ شَهِدَتْهَا أَرْضُ مِصْرَ مُنْذُ أَنْ صَارَتْ أُمَّةً. ");
INSERT INTO arbnav_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","وَأَصَابَ الْبَرَدُ فِي كُلِّ أَرْجَاءِ مِصْرَ جَمِيعَ مَا فِي الْحُقُولِ مِنْ نَاسٍ وَبَهَائِمَ. وَأَتْلَفَ كُلَّ نَبَاتٍ نَامٍ فِي الْحَقْلِ وَكَسَّرَ جَمِيعَ الأَشْجَارِ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","أَمَّا أَرْضُ جَاسَانَ حَيْثُ يُقِيمُ بَنُو إِسْرَائِيلَ، فَإِنَّهَا وَحْدَهَا لَمْ يَسْقُطْ فِيهَا بَرَدٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","فَأَرْسَلَ فِرْعَوْنُ وَاسْتَدْعَى مُوسَى وَهَرُونَ وَقَالَ لَهُمَا: «لَقَدْ أَخْطَأْتُ هَذِهِ الْمَرَّةَ وَالرَّبُّ هُوَ الْبَارُّ، أَمَّا أَنَا وَشَعْبِي فَأَشْرَارٌ، ");
INSERT INTO arbnav_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","فَتَضَرَّعَا إِلَى الرَّبِّ إذْ يَكْفِينَا مَا ابْتُلِينَا بِهِ مِنْ رُعُودٍ وَبَرَدٍ، فَأُطْلِقَكُمْ، وَلا تَمْكُثُونَ هُنَا بَعْدُ». ");
INSERT INTO arbnav_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","فَأَجَابَ مُوسَى: «حَالَمَا أَخْرُجُ مِنَ الْمَدِينَةِ أَبْسُطُ يَدِي فِي الصَّلاةِ إِلَى الرَّبِّ فَيَتَوَقَّفُ الرَّعْدُ وَيَنْقَطِعُ الْبَرَدُ لِكَيْ تَعْرِفَ أَنَّ الأَرْضَ هِيَ للرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","وَلَكِنَّنِي عَالِمٌ أَنَّكَ أَنْتَ وَحَاشِيَتَكَ مَازِلْتُمْ لَا تَخْشَوْنَ الرَّبَّ الإِلَهَ». ");
INSERT INTO arbnav_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","إنَّ الْكَتَّانَ وَالشَّعِيرَ قَدْ تَلِفَا، لأَنَّ الشَّعِيرَ أَصْبَحَ سَنَابِلَ، وَالكَتَّانَ كَانَ مُبْزِراً، ");
INSERT INTO arbnav_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","أَمَّا الْحِنْطَةُ وَالقَطَانِيُّ فَلَمْ تَتْلَفْ بَعْدُ لأَنَّهَا تَنْمُو مُتَأَخِّرَةً. ");
INSERT INTO arbnav_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","وَانْصَرَفَ مُوسَى مِنْ لَدُنْ فِرْعَوْنَ مِنَ الْمَدِينَةِ وَبَسَطَ يَدَيْهِ إِلَى الرَّبِّ، فَتَوَقَّفَ الرَّعْدُ وَالْبَرَدُ وَانْقَطَعَ الْمَطَرُ عَنِ الانْهِمَارِ عَلَى الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","وَعِنْدَمَا رَأَى فِرْعَوْنُ أَنَّ الْمَطَرَ وَالْبَرَدَ وَالرَّعْدَ قَدْ تَوَقَّفَتْ أَخْطَأَ مَرَّةً أُخْرَى وَصَلَّبَ قَلْبَهُ هُوَ وَحَاشِيَتُهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","وَهَكَذَا تَقَسَّى قَلْبُ فِرْعَوْنَ، فَلَمْ يُطْلِقْ بَنِي إِسْرَائِيلَ، تَمَاماً كَمَا أَنْبَأَ الرَّبُّ عَلَى لِسَانِ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","وَقَالَ الرَّبُّ لِمُوسَى: «امْثُلْ أَمَامَ فِرْعَوْنَ لأَنَّنِي قَدْ قَسَّيْتُ قَلْبَهُ وَقُلُوبَ حَاشِيَتِهِ لِكَيْ أُجْرِيَ آيَاتِي هَذِهِ بَيْنَهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","لِكَيْ تُخْبِرَ فِي مَسَامِعِ بَنِيكَ وَأَحْفَادِكَ عَمَّا ابْتَلَيْتُ بِهِ الْمِصْرِيِّينَ وَبِآيَاتِي الَّتِي أَجْرَيْتُهَا بَيْنَهُمْ فَتَعْلَمُونَ أَنِّي أَنَا الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","فَمَثَلَ مُوسَى وَهَرُونُ أَمَامَ فِرْعَوْنَ وَقَالا لَهُ: «هَذَا مَا يُعْلِنُهُ الرَّبُّ إِلَهُ الْعِبْرَانِيِّينَ: إِلَى مَتَى تَأْبَى أَنْ تَخْضَعَ لِي؟ أَطْلِقْ شَعْبِي لِيَعْبُدَنِي. ");
INSERT INTO arbnav_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","وَإذَا أَبَيْتَ أَنْ تُطْلِقَ شَعْبِي، فَهَا أَنَا أَجْلِبُ غَداً الْجَرَادَ عَلَى تُخُومِكَ، ");
INSERT INTO arbnav_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","فَيُغَطِّي وَجْهَ الأَرْضِ، فَيَعْسُرُ عَلَى أَحَدٍ أَنْ يَرَاهَا، وَيَلْتَهِمُ الْبَقِيَّةَ الْمُتَخَلِّفَةَ لَكُمْ عَنِ الْبَرَدِ، وَكُلَّ شَجَرَةٍ نَابِتَةٍ لَكُمْ فِي الْحَقْلِ، ");
INSERT INTO arbnav_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","وَيَمْلأُ بُيُوتَكَ وَبُيُوتَ حَاشِيَتِكَ وَبُيُوتَ جَمِيعِ الْمِصْرِيِّينَ، الأَمْرُ الَّذِي لَمْ يَشْهَدْ مِثْلَهُ آبَاؤُكَ وَلا أَجْدَادُكَ مُنْذُ أَنِ اسْتَوْطَنُوا هَذِهِ الأَرْضَ إِلَى الآنَ». ثُمَّ تَحَوَّلَ وَانْصَرَفَ مِنْ لَدُنْ فِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","فَقَالَتْ حَاشِيَةُ فِرْعَوْنَ لَهُ: «إِلَى مَتَى يَظَلُّ هَذَا الرَّجُلُ شَرَكاً لَنَا؟ أَطْلِقِ الشَّعْبَ لِيَعْبُدُوا الرَّبَّ إِلَهَهُمْ. أَلَمْ تَعْلَمْ أَنَّ مِصْرَ قَدْ عَمَّهَا الْخَرَابُ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","فَاسْتُدْعِيَ مُوسَى وَهَرُونُ ثَانِيَةً لِلْمُثُولِ أَمَامَ فِرْعَوْنَ، وَقَالَ لَهُمَا: «امْضُوا وَاعْبُدُوا الرَّبَّ إِلَهَكُمْ، وَلَكِنْ مَنْ هُمُ الَّذِينَ سَيَذْهَبُونَ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","فَأَجَابَ مُوسَى: «نَذْهَبُ بِفِتْيَانِنَا وَشُيُوخِنَا. نَذْهَبُ بِبَنِينَا وَبَنَاتِنَا، بِمَوَاشِينَا وَقُطْعَانِنَا لأَنَّهُ يَجِبُ أَنْ نُقِيمَ عِيداً لِلرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","فَقَالَ فِرْعَوْنُ: «لِيَكُنِ الرَّبُّ بِعَوْنِكُمْ إنْ أَنَا أَطْلَقْتُكُمْ مَعَ نِسَائِكُمْ وَأَوْلادِكُمْ. فَمِنَ الْجَلِيِّ أَنَّكُمْ عَازِمُونَ عَلَى الشَّرِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","لا، فَلْيَمْضِ الرِّجَالُ فَقَطْ لِعِبَادَةِ الرَّبِّ، لأَنَّ هَذَا هُوَ مَا تَطْلُبُونَهُ». ثُمَّ طُرِدَا مِنْ حَضْرَةِ فِرْعَوْنَ. ");
INSERT INTO arbnav_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","فَقَالَ الرَّبُّ لِمُوسَى: «ابْسُطْ يَدَكَ عَلَى أَرْضِ مِصْرَ لِتُبْتَلَى بِالجَّرَادِ، فَيُغَطِّي بِلادَ مِصْرَ وَيَلْتَهِمَ كُلَّ نَبَاتِ الأَرْضِ الْمُتَخَلِّفِ عَنِ الْبَرَدِ». ");
INSERT INTO arbnav_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","فَمَدَّ مُوسَى عَصَاهُ عَلَى أَرْضِ مِصْرَ، فَأَرْسَلَ الرَّبُّ عَلَيْهِمْ رِيحاً شَرْقِيَّةً طَوَالَ ذَلِكَ النَّهَارِ وَاللَّيْلِ، وَمَا إِنْ أَقْبَلَ الصَّبَاحُ حَتَّى حَمَلَتِ الرِّيحُ الشَّرْقِيَّةُ الْجَرَادَ. ");
INSERT INTO arbnav_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","فَانْتَشَرَ الْجَرَادُ فِي كُلِّ بِلادِ مِصْرَ، وَحَلَّ فِي جَمِيعِ تُخُومِهَا بِأَسْرَابٍ عَظِيمَةٍ، فَلَمْ يَكُنْ لَهُ نَظِيرٌ مِنْ قَبْلُ وَلَنْ يَحْدُثَ مِثْلُهُ فِيمَا بَعْدُ. ");
INSERT INTO arbnav_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","فَقَدْ غَطَّى وَجْهَ كُلِّ الأَرْضِ حَتَّى أَظْلَمَتْ، وَالْتَهَمَ كُلَّ عُشْبٍ فِيهَا وَكُلَّ أَثْمَارِ الأَشْجَارِ الَّتِي خَلَّفَهَا الْبَرَدُ، فَلَمْ يَبْقَ شَيْءٌ أَخْضَرُ لَا عَلَى الأَشْجَارِ وَلا فِي حُقُولِ الْمَزْرُوعَاتِ فِي كُلِّ أَرْجَاءِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","عِنْدَئِذٍ أَسْرَعَ فِرْعَوْنُ فَاسْتَدْعَى مُوسَى وَهَرُونَ قَائِلاً: «لَقَدْ أَخْطَأْتُ إِلَى الرَّبِّ إِلَهِكُمْ وَإِلَيْكُمَا. ");
INSERT INTO arbnav_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","فَاصْفَحَا هَذِهِ الْمَرَّةَ فَقَطْ عَنْ خَطِيئَتِي وَابْتَهِلا إِلَى الرَّبِّ إِلَهِكُمَا كَيْ يُزِيلَ عَنِّي هَذَا الْبَلاءَ الْمُمِيتَ». ");
INSERT INTO arbnav_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","فَانْصَرَفَ مُوسَى مِنْ لَدُنْ فِرْعَوْنَ وَابْتَهَلَ إِلَى الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","فَأَرْسَلَ الرَّبُّ رِيحاً غَرْبِيَّةً عَاصِفَةً حَمَلَتِ الْجَرَادَ وَطَرَحَتْهُ فِي الْبَحْرِ الأَحْمَرِ، فَلَمْ تَبْقَ جَرَادَةٌ وَاحِدَةٌ فِي جَمِيعِ أَرْجَاءِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","وَلَكِنَّ الرَّبَّ صَلَّبَ قَلْبَ فِرْعَوْنَ فَلَمْ يُطْلِقْ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","فَقَالَ الرَّبُّ لِمُوسَى: «ابْسُطْ يَدَكَ نَحْوَ السَّمَاءِ فَيَطْغَى ظَلامٌ عَلَى كُلِّ أَرْجَاءِ مِصْرَ حَتَّى يَكَادَ يُلْمَسُ لِكَثَافَتِهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","فَبَسَطَ مُوسَى يَدَهُ نَحْوَ السَّمَاءِ، فَطَغَى ظَلامٌ كَثِيفٌ عَلَى كُلِّ أَرْجَاءِ أَرْضِ مِصْرَ لِمُدَّةِ ثَلاثَةِ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","فَلَمْ يَتَمَكَّنْ أَحَدٌ مِنْ أَنْ يَرَى أَخَاهُ، وَلا غَادَرَ أَحَدٌ مَكَانَهُ طَوَالَ ثَلاثَةِ أَيَّامٍ. غَيْرَ أَنَّ النُّورَ كَانَ يَغْمُرُ بَنِي إِسْرَائِيلَ فِي أَمَاكِنِ إِقَامَتِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","فَاسْتَدْعَى فِرْعَوْنُ مُوسَى وَقَالَ: «اذْهَبُوا وَاعْبُدُوا الرَّبَّ، وَلَكِنِ اتْرُكُوا وَرَاءَكُمْ مَاشِيَتَكُمْ وَقُطْعَانَكُمْ: أَمَّا صِغَارُكُمْ فَلْيَمْضُوا مَعَكُمْ أَيْضاً». ");
INSERT INTO arbnav_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","فَقَالَ مُوسَى: «عَلَيْكَ أَنْ تَسْمَحَ لَنَا بِأَخْذِ ذَبَائِحَ مُحْرَقَاتٍ لِنُقَدِّمَهَا لِلرَّبِّ إِلَهِنَا. ");
INSERT INTO arbnav_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","لِذَلِكَ تَذْهَبُ مَوَاشِينَا مَعْنَا أَيْضاً، فَلا يَبْقَى مِنْهَا ظِلْفٌ وَاحِدٌ، لأَنَّ عَلَيْنَا أَنْ نَخْتَارَ مِنْهَا لِعِبَادَةِ الرَّبِّ إِلَهِنَا، وَلا يُمْكِنُنَا أَنْ نَعْرِفَ مَاذَا نَخْتَارُ مِنْهَا لِنَعْبُدَ الرَّبَّ حَتَّى نَصِلَ إِلَى هُنَاكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","وَلَكِنَّ الرَّبَّ صَلَّبَ قَلْبَ فِرْعَوْنَ فَلَمْ يُطْلِقْ سَرَاحَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","وَقَالَ لَهُ فِرْعَوْنُ: «اذْهَبْ عَنِّي، وَاحْذَرْ لِنَفْسِكَ. لَا تَمْثُلْ أَمَامِي مَرَّةً أُخْرَى، فَيَوْمَ تَرَى وَجْهِي تَمُوتُ». ");
INSERT INTO arbnav_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","فَقَالَ مُوسَى: «حَسَناً قُلْتَ، فَأَنَا لَنْ أَرَى وَجْهَكَ مَرَّةً أُخْرَى». ");
INSERT INTO arbnav_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: «بَقِيَتْ بَلِيَّةٌ وَاحِدَةٌ أُصِيبُ بِها فِرْعَوْنَ وَالْمِصْرِيِّينَ، وَبَعْدَ ذَلِكَ يُطْلِقُكُمْ مِنْ هُنَا. وَعِنْدَمَا يَفْعَلُ ذَلِكَ فَإِنَّهُ يَطْرُدُكُمْ جَمِيعاً طَرْداً. ");
INSERT INTO arbnav_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","فَقُلِ الآنَ لِلشَّعْبِ: لِيَطْلُبْ كُلُّ رَجُلٍ مِنْ جَارِهِ، وَكُلُّ امْرَأَةٍ مِنْ جَارَتِهَا، آنِيَةَ فِضَّةٍ وَذَهَبٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ذَلِكَ لأَنَّ الرَّبَّ جَعَلَ الشَّعْبَ يَحْظَى بِرِضَى الْمِصْرِيِّينَ، كَمَا أَنَّ الرَّجُلَ مُوسَى كَانَ عَظِيماً فِي مِصْرَ فِي عُيُونِ حَاشِيَةِ فِرْعَوْنَ وَالشَّعْبِ. ");
INSERT INTO arbnav_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","وَقَالَ مُوسَى هَذَا مَا يُعْلِنُهُ الرَّبُّ: «سَأَجْتَازُ حَوَالَي نِصْفِ اللَّيْلِ فِي وَسَطِ مِصْرَ، ");
INSERT INTO arbnav_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","فَيَمُوتُ كُلُّ بِكْرٍ فِيهَا: مِنْ بِكْرِ فِرْعَوْنَ الْمُتَرَبِّعِ عَلَى الْعَرْشِ إِلَى بِكْرِ الأَمَةِ الَّتِي وَرَاءَ الرَّحَى، وَكَذَلِكَ بِكْرِ كُلِّ بَهِيمَةٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","فَيَعْلُو صُرَاخٌ عَظِيمٌ فِي كُلِّ أَرْضِ مِصْرَ، لَمْ يُشْهَدْ مِثْلُهُ مِنْ قَبْلُ وَلا يَكُونُ مِثْلُهُ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","أَمَّا بَيْنَ الإِسْرَائِيلِيِّينَ فَلَنْ يَنْبَحَ كَلْبٌ عَلَى أَيِّ إِنْسَانٍ أَوْ حَيَوَانٍ. وَعِنْدَئِذٍ تَعْلَمُونَ أَنَّ الرَّبَّ يُمَيِّزُ بَيْنَ الْمِصْرِيِّينَ وَإِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","فَيَأْتِي إِلَيَّ، مِنْ ثَمَّ، جَمِيعُ عَبِيدِكَ هَؤُلاءِ وَيَنْحَنُونَ أَمَامِي قَائِلِينَ: انْطَلِقْ أَنْتَ وَكُلُّ مَنْ يَتْبَعُكَ مِنَ الشَّعْبِ. وَآنَئِذٍ فَقَطْ أَمْضِي». ثُمَّ انْصَرَفَ مِنْ لَدُنْ فِرْعَوْنَ بِغَضَبٍ مُحْتَدِمٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","وَقَالَ الرَّبُّ لِمُوسَى: «إِنَّ فِرْعَوْنَ يَأْبَى الاسْتِمَاعَ لَكُمَا لِكَيْ تَتَكَاثَرَ آيَاتِي فِي أَرْضِ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","وَلَقَدْ أَجْرَى مُوسَى وَهَرُونُ كُلَّ هَذِهِ الآيَاتِ أَمَامَ فِرْعَوْنَ، وَلَكِنَّ الرَّبَّ قَسَّى قَلْبَ فِرْعَوْنَ فَلَمْ يُطْلِقْ بَنِي إِسْرَائِيلَ مِنْ دِيَارِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","وَخَاطَبَ الرَّبُّ مُوسَى وَهَرُونَ فِي أَرْضِ مِصْرَ قَائِلاً: ");
INSERT INTO arbnav_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«مُنْذُ الآنَ يَكُونُ لَكُمْ هَذَا الشَّهْرُ رَأْسَ الشُّهُورِ وَأَوَّلَ شُهُورِ السَّنَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","خَاطِبَا كُلَّ جَمَاعَةِ إِسْرَائِيلَ قَائِلَيْنِ: عَلَى كُلِّ وَاحِدٍ أَنْ يَأْخُذَ فِي الْعَاشِرِ مِنْ هَذَا الشَّهْرِ حَمَلاً لِعَائِلَتِهِ، وَفْقاً لِبُيُوتِ الْآبَاءِ، حَمَلاً لِكُلِّ عَائِلَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","وَإِنْ كَانَ الْبَيْتُ صَغِيراً لَا يَسْتَهْلِكُ حَمَلاً كَامِلاً، يَتَقَاسَمُهُ هُوَ وَجَارُهُ الْقَرِيبُ مِنْهُ بِحَسَبِ عَدَدِ الأَشْخَاصِ الْمَوْجُودِينَ هُنَاكَ، بِمِقْدَارِ مَا يَسْتَطِيعُ كُلُّ وَاحِدٍ أَنْ يَأْكُلَهُ مِنَ الْحَمَلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","وَيَجِبُ أَنْ يَكُونَ الْحَمَلُ ذَكَراً ابْنَ سَنَةٍ، خَالِياً مِنْ كُلِّ عَيْبٍ، تَنْتَقُونَهُ مِنَ الْخِرْفَانِ أَوِ الْمَعِيزِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","وَيَكُونُ عِنْدَكُمْ مَحْفُوظاً حَتَّى الْيَوْمِ الرَّابِعَ عَشَرَ مِنْ هَذَا الشَّهْرِ. ثُمَّ يَقُومُ كُلُّ جُمْهُورِ إِسْرَائِيلَ بِذَبْحِ الْحُمْلانِ عِنْدَ الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","وَيَأْخُذُونَ الدَّمَ وَيَضَعُونَهُ عَلَى الْقَائِمَتَيْنِ وَالْعَتَبَةِ الْعُلْيَا فِي الْبُيُوتِ الَّتِي يَأْكُلُونَهُ فِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ثُمَّ فِي نَفْسِ تِلْكَ اللَّيْلَةِ يَتَنَاوَلُونَ اللَّحْمَ مَشْوِيًّا بِالنَّارِ مَعَ فَطِيرٍ، يَأْكُلُونَهُ مَعَ أَعْشَابٍ مُرَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","لَا تَأْكُلُوا مِنْهُ نِيئاً أَوْ مَسْلُوقاً، بَلْ مَشْوِيًّا بِنَارٍ، رَأْسَهُ مَعَ أَكَارِعِهِ وَجَوْفِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","وَلا تُبْقُوا مِنْهُ إِلَى الصَّبَاحِ، بَلْ تُحْرِقُونَ كُلَّ مَا تَبَقَّى مِنْهُ إِلَى الصَّبَاحِ بِالنَّارِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","تَأْكُلُونَهُ بِعَجَلَةٍ وَأَحْقَاؤُكُمْ مَشْدُودَةٌ، وَأَحْذِيَتُكُمْ فِي أَرْجُلِكُمْ، وَعِصِيُّكُمْ فِي أَيْدِيكُمْ. فَيَكُونُ هَذَا فِصْحاً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","فَفِي هَذِهِ اللَّيْلَةِ أَجْتَازُ فِي بِلادِ مِصْرَ وَأَقْتُلُ كُلَّ بِكْرٍ فِيهَا مِنَ النَّاسِ وَالْبَهَائِمِ وَأُجْرِي قَضَاءً عَلَى كُلِّ آلِهَةِ الْمِصْرِيِّينَ. أَنَا هُوَ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","أَمَّا أَنْتُمْ فَإِنَّ الدَّمَ الَّذِي عَلَى بُيُوتِكُمُ الْمُقِيمِينَ فِيهَا يَكُونُ الْعَلامَةَ الَّتِي تُمَيِّزُكُمْ، فَأَرَى الدَّمَ وَأَعْبُرُ عَنْكُمْ، فَلا تَنْزِلُ بِكُمْ بَلِيَّةُ الْهَلاكِ حِينَ أَبْتَلِي بِها أَرْضَ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","وَيَكُونُ لَكُمْ هَذَا الْيَوْمُ تَذْكَاراً تَحْتَفِلُونَ بِهِ عِيداً لِلرَّبِّ، فَرِيضَةً أَبَدِيَّةً تَحْتَفِلُونَ بِهِ فِي أَجْيَالِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","سَبْعَةَ أَيَّامٍ تَحْتَفِلُونَ، تَأْكُلُونَ فِيهَا فَطِيراً، تُخْلُونَ بُيُوتَكُمْ مِنَ الْخَمِيرِ فِي الْيَوْمِ الأَوَّلِ، فَإِنَّ كُلَّ مَنْ أَكَلَ خَمِيراً فِي الْيَوْمِ الأَوَّلِ إِلَى الْيَوْمِ السَّابِعِ، تُبَادُ تِلْكَ النَّفْسُ مِنْ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","وَتُقِيمُونَ فِي الْيَوْمِ الأَوَّلِ حَفْلاً مُقَدَّساً، وَكَذَلِكَ فِي الْيَوْمِ السَّابِعِ. لَا يُجْرَى فِيهِمَا عَمَلٌ مَا إلّا تَجْهِيزُ طَعَامِ الأَكْلِ. هَذَا كُلُّ مَا تَعْمَلُونَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","وَتَحْتَفِلُونَ بِعِيدِ الْفَطِيرِ، لأَنَّنِي فِي هَذَا الْيَوْمِ عَيْنِهِ أَخْرَجْتُ أَجْنَادَكُمْ مِنْ أَرْضِ مِصْرَ، فَاحْتَفِلُوا بِهَذَا الْيَوْمِ فَرِيضَةً أَبَدِيَّةً فِي أَجْيَالِكُمُ الْمُقْبِلَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","وَمُنْذُ مَسَاءِ الْيَوْمِ الرَّابِعَ عَشَرَ مِنَ الشَّهْرِ الأَوَّلِ وَحَتَّى مَسَاءِ الْيَوْمِ الْحَادِي وَالعِشْرِينَ مِنْهُ تَأْكُلُونَ فَطِيراً. ");
INSERT INTO arbnav_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","سَبْعَةَ أَيَّامٍ تَخْلُو بُيُوتُكُمْ مِنَ الْخَمِيرِ فَإِنَّ كُلَّ مَنْ أَكَلَ خُبْزاً مُخْتَمِراً يُبَادُ مِنْ جَمَاعَةِ إِسْرَائِيلَ، الْغَرِيبُ وَالمُوَاطِنُ عَلَى حَدٍّ سَوَاءَ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","لَا تَأْكُلُوا شَيْئاً مُخْتَمِراً، بَلْ فِي كُلِّ مَسَاكِنِكُمْ تَأْكُلُونَ فَطِيراً». ");
INSERT INTO arbnav_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ثُمَّ اسْتَدْعَى مُوسَى كُلَّ شُيُوخِ إِسْرَائِيلَ وَقَالَ لَهُمْ: «اذْهَبُوا وَانْتَقُوا حُمْلاناً بِحَسَبِ عَائِلاتِكُمْ وَاذْبَحُوا حَمَلَ الْفِصْحِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ثُمَّ خُذُوا بَاقَةَ زُوفَا وَاغْمِسُوهَا فِي الدَّمِ الَّذِي تَصَفَّى فِي الإِنَاءِ وَاطْلُوا بِهِ عَتَبَةَ الْبَابِ الْعُلْيَا وَالْقَائِمَتَيْنِ، وَلا يَخْرُجُ أَحَدٌ مِنْكُمْ مِنْ بَيْتِهِ حَتَّى الصَّبَاحِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","لأَنَّ الرَّبَّ سَيَجْتَازُ لَيْلاً لِيُهْلِكَ الْمِصْرِيِّينَ. فَحِينَ يَرَى الدَّمَ عَلَى الْعَتَبَةِ الْعُلْيَا وَالْقَائِمَتَيْنِ يَعْبُرُ عَنِ الْبَابِ وَلا يَدَعُ الْمُهْلِكَ يَدْخُلُ بُيُوتَكُمْ لِيَضْرِبَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","فَتُمَارِسُونَ هَذَا الأَمْرَ فَرِيضَةً لَكُمْ وَلأَوْلادِكُمْ إِلَى الأَبَدِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","وَعِنْدَمَا تَدْخُلُونَ الأَرْضَ الَّتِي وَعَدَ الرَّبُّ أَنْ يَهَبَهَا لَكُمْ، فَإِنَّكُمْ تُمَارِسُونَ هَذِهِ الْفَرِيضَةَ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","وَيَكُونُ حِينَ يَسْأَلُكُمْ أَبْنَاؤُكُمْ: مَاذَا تَعْنِي هَذِهِ الْفَرِيضَةُ لَكُمْ؟ ");
INSERT INTO arbnav_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","تُجِيبُونَهُمْ آنَئِذٍ: إِنَّهَا ذَبِيحَةُ فِصْحٍ لِلرَّبِّ الَّذِي عَبَرَ عَنْ بُيُوتِ بَنِي إِسْرَائِيلَ فِي مِصْرَ عِنْدَمَا أَهْلَكَ الْمِصْرِيِّينَ، وَأَنْقَذَ بُيُوتَنَا». فَحَنَى الشَّعْبُ رُؤُوسَهُمْ سَاجِدِينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","فَمَضَى بَنُو إِسْرَائِيلَ وَفَعَلُوا تَمَاماً كَمَا أَمَرَ الرَّبُّ مُوسَى وَهَرُونَ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","وَفِي مُنْتَصَفِ اللَّيْلِ أَهْلَكَ الرَّبُّ كُلَّ بِكْرٍ فِي بِلادِ مِصْرَ، مِنْ بِكْرِ فِرْعَوْنَ الْمُتَرَبِّعِ عَلَى الْعَرْشِ إِلَى بِكْرِ الْحَبِيسِ فِي السِّجْنِ، وَأَبْكَارَ الْبَهَائِمِ جَمِيعاً أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","فَاسْتَيْقَظَ فِرْعَوْنُ وَحَاشِيَتُهُ وَجَمِيعُ الْمِصْرِيِّينَ وَإذَا عَوِيلٌ عَظِيمٌ فِي أَرْضِ مِصْرَ، لأَنَّهُ لَمْ يُوْجَدْ بَيْتٌ لَيْسَ فِيهِ مَيْتٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","فَاسْتَدْعَى مُوسَى وَهَرُونَ لَيْلاً قَائِلاً: «قُومُوا وَاخْرُجُوا مِنْ بَيْنِ الشَّعْبِ أَنْتُمَا وَبَنُو إِسْرَائِيلَ، وَانْطَلِقُوا اعْبُدُوا الرَّبَّ كَمَا طَلَبْتُمْ، ");
INSERT INTO arbnav_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","وَخُذُوا مَعَكُمْ غَنَمَكُمْ وَبَقَرَكُمْ كَمَا سَأَلْتُمْ وَامْضُوا وَبَارِكُونِي أَيْضاً». ");
INSERT INTO arbnav_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","وَأَلَحَّ الْمِصْرِيُّونَ عَلَى الشَّعْبِ لِيُسْرِعُوا فِي الارْتِحَالِ عَنِ الْبِلادِ قَائِلِينَ: «لِئَلّا نَمُوتَ جَمِيعاً». ");
INSERT INTO arbnav_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","فَصَرَّ الشَّعْبُ فِي ثِيَابِهِمْ مَعَاجِنَهُمْ وَعَجِينَهُمْ قَبْلَ أَنْ يَخْتَمِرَ، وَحَمَلُوهَا عَلَى أَكْتَافِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","وَطَلَبُوا مِنَ الْمِصْرِيِّينَ آنِيَةَ فِضَّةٍ وَذَهَباً وَثِيَاباً بِحَسَبِ قَوْلِ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","وَجَعَلَ الرَّبُّ الشَّعْبَ يَحْظَى بِرِضَى الْمِصْرِيِّينَ، فَأَعْطَوْهُمْ كُلَّ مَا طَلَبُوهُ، فَغَنِمُوا مِنَ الْمِصْرِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","وَارْتَحَلَ بَنُو إِسْرَائِيلَ مِنْ رَعَمْسِيسَ إِلَى سُكُّوتَ فَكَانُوا نَحْوَ سِتِّ مِئَةِ أَلْفٍ مِنَ الرِّجَالِ المُشَاةِ مَاعَدَا النِّسَاءَ وَالأَوْلادَ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","وَكَذَلِكَ انْضَمَّ إِلَيْهِمْ حَشْدٌ كَبِيرٌ مِنَ النَّاسِ، مَعَ غَنَمٍ وَمَوَاشٍ وَقُطْعَانٍ كَثِيرَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ثُمَّ خَبَزُوا الْعَجِينَ الَّذِي أَخْرَجُوهُ مَعَهُمْ مِنْ مِصْرَ خُبْزَ مَلَّةٍ، لأَنَّهُ لَمْ يَكُنْ مُخْتَمِراً، إذْ أَنَّهُمْ طُرِدُوا مِنْ مِصْرَ وَلَمْ يَقْدِرُوا أَنْ يَتَأَخَّرُوا فَمَا أَعَدُّوا لأَنْفُسِهِمْ زَاداً. ");
INSERT INTO arbnav_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","وَكَانَتْ مُدَّةُ غُرْبَةِ بَنِي إِسْرَائِيلَ الَّتِي أَقَامُوهَا فِي مِصْرَ أَرْبَعَ مِئَةٍ وَثَلاثِينَ سَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","وَفِي الْيَوْمِ الأَخِيرِ بِالذَّاتِ، فِي خِتَامِ أَرْبَعِ مِئَةٍ وَثَلاثِينَ سَنَةً خَرَجَ جَمِيعُ أَجْنَادِ الرَّبِّ مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","هِيَ لَيْلَةٌ تُكَرَّسُ لِلرَّبِّ إذْ أَخْرَجَهُمْ فِيهَا مِنْ أَرْضِ مِصْرَ. هَذِهِ اللَّيْلَةُ هِيَ لِلرَّبِّ، يُكَرِّسُهَا بَنُو إِسْرَائِيلَ فِي جَمِيعِ أَجْيَالِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","وَقَالَ الرَّبُّ لِمُوسَى وَهَرُونَ: «هَذِهِ هِيَ مَرَاسِيمُ الْفِصْحِ: لَا يَأْكُلُ غَرِيبٌ مِنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","كُلُّ عَبْدٍ مُشْتَرَى بِفِضَّةٍ يَأْكُلُ مِنْهُ بَعْدَ أَنْ تَخْتِنَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","النَّزِيلُ وَالأَجِيرُ لَا يَأْكُلانِ مِنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","يُؤْكَلُ فِي بَيْتٍ وَاحِدٍ فَلا تَحْمِلْ لَحْماً إِلَى خَارِجِ الْمَنْزِلِ، وَلا تَكْسِرْ مِنْهُ عَظْماً. ");
INSERT INTO arbnav_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","وَعَلَى كُلِّ جَمَاعَةِ إِسْرَائِيلَ أَنْ تَحْتَفِلَ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","وَإذَا عَزَمَ غَرِيبٌ مُقِيمٌ بَيْنَكُمْ أَنْ يَحْتَفِلَ بِفِصْحِ الرَّبِّ فَلْيُخْتَنْ كُلُّ ذَكَرٍ مِنْ أَهْلِ بَيْتِهِ، ثُمَّ يَحْتَفِلُ بِهِ، فَيَكُونُ آنَئِذٍ كَمَوْلُودِ الأَرْضِ. لَا يَأْكُلُ مِنْهُ أَيُّ ذَكَرٍ أَغْلَفَ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","فَتَسُودُ هَذِهِ الشَّرِيعَةُ عَلَى الْمُوَاطِنِ وَالدَّخِيلِ الْمُقِيمِ بَيْنَكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","فَفَعَلَ جَمِيعُ بَنِي إِسْرَائِيلَ تَمَاماً كَمَا أَمَرَ الرَّبُّ مُوسَى وَهَرُونَ. ");
INSERT INTO arbnav_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","فِي ذَلِكَ الْيَوْمِ عَيْنِهِ أَخْرَجَ الرَّبُّ بَنِي إِسْرَائِيلَ مِنْ أَرْضِ مِصْرَ بِحَسَبِ فِرَقِ عَشَائِرِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«خَصِّصْ لِي كُلَّ بِكْرٍ ذَكَرٍ. كُلُّ فَاتِحِ رَحِمٍ مِنْ بَنِي إِسْرَائِيلَ هُوَ لِي. كُلُّ بِكْرٍ مِنَ النَّاسِ أَوِ الْبَهَائِمِ». ");
INSERT INTO arbnav_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","وَقَالَ مُوسَى لِلشَّعْبِ: «اذْكُرُوا هَذَا الْيَوْمَ الَّذِي خَرَجْتُمْ فِيهِ مِنْ مِصْرَ مِنْ بَيْتِ الْعُبُودِيَّةِ، فَقَدْ أَطْلَقَكُمُ الرَّبُّ مِنْ هُنَا بِيَدٍ قَدِيرَةٍ، فَلا تَأْكُلُوا خُبْزاً مُخْتَمِراً. ");
INSERT INTO arbnav_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","الْيَوْمَ فِي شَهْرِ أَبِيبَ (أَيْ فِي شَهْرِ آذَارَ – مَارِسَ) أَنْتُمْ خَارِجُونَ، ");
INSERT INTO arbnav_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","لِذَلِكَ عِنْدَمَا يُدْخِلُكُمُ الرَّبُّ أَرْضَ الْكَنْعَانِيِّينَ وَالْحِثِّيِّينَ وَالأَمُورِيِّينَ وَالْحِوِّيِّينَ وَالْيَبُوسِيِّينَ، الَّتِي تَفِيضُ لَبَناً وَعَسَلاً، وَالَّتِي أَقْسَمَ لِآبَائِكُمْ أَنْ يَهَبَكُمْ إِيَّاهَا، تُمَارِسُونَ هَذِهِ الْفَرِيضَةَ فِي هَذَا الشَّهْرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","سَبْعَةَ أَيَّامٍ لَا تَأْكُلُونَ فِيهَا خُبْزاً مُخْتَمِراً، وَفِي الْيَوْمِ السَّابِعِ يَكُونُ احْتِفَالٌ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","سَبْعَةَ أَيَّامٍ تَأْكُلُونَ فِيهَا خُبْزاً فَطِيراً وَلا تَحْتَفِظُونَ فِي بُيُوتِكُمْ بِشَيْءٍ مُخْتَمِرٍ أَوْ بِخَمِيرٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","فِي ذَلِكَ الْيَوْمِ تَقُولُ لابْنِكَ: إنَّنِي أُمَارِسُ هَذَا مِنْ أَجْلِ مَا صَنَعَهُ الرَّبُّ لِي، حِينَ أَخْرَجَنِي مِنْ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","فَتَكُونُ هَذِهِ الْفَرِيضَةُ بِمَثَابَةِ عَلامَةٍ عَلَى يَدِكَ، وَتَذْكَاراً بَيْنَ عَيْنَيْكَ، لِتَكُونَ شَرِيعَةُ الرَّبِّ فِي فَمِكَ، لأَنَّ الرَّبَّ قَدْ أَخْرَجَكَ بِيَدٍ قَدِيرَةٍ مِنْ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","فَتُمَارِسُ هَذِهِ الْفَرِيضَةَ فِي مِيعَادِهَا مَرَّةً كُلَّ سَنَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","وَيَكُونُ حِينَ يُدْخِلُكَ الرَّبُّ إِلَى أَرْضِ الْكَنْعَانِيِّينَ، كَمَا أَقْسَمَ لَكَ وَلِآبَائِكَ أَنْ يَهَبَكَ إِيَّاهَا، ");
INSERT INTO arbnav_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","أَنَّكَ تَفْرِزُ لِلرَّبِّ كُلَّ ذَكَرٍ فَاتِحِ رَحِمٍ. وَكَذَلِكَ كُلَّ بِكْرٍ مِنْ نِتَاجِ الْبَهَائِمِ الَّتِي تَمْلِكُهَا يَكُونُ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","إِنَّمَا كُلُّ بِكْرِ حِمَارٍ تَفْدِيهِ بِحَمَلٍ. وَإِنْ لَمْ تَفْدِهِ تَكْسِرْ عُنُقَهُ. وَكَذَلِكَ تَفْدِي أَيْضاً كُلَّ بِكْرٍ مِنْ بَنِيكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","وَحِينَ يَسْأَلُكَ ابْنُكَ فِي الأَيَّامِ الْمُقْبِلَةِ: مَا مَعْنَى هَذَا؟ تُجِيبُهُ: إِنَّهُ بِيَدٍ قَدِيرَةٍ أَخْرَجَنَا الرَّبُّ مِنْ دِيَارِ الْعُبُودِيَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","وَعِنْدَمَا تَصَلَّبَ فِرْعَوْنُ وَامْتَنَعَ عَنْ إِطْلاقِنَا، أَهْلَكَ الرَّبُّ كُلَّ بِكْرٍ فِي بِلادِ مِصْرَ، مِنْ أَبْكَارِ النَّاسِ وَالْبَهَائِمِ. لِذَلِكَ أَنَا أُقَرِّبُ لِلرَّبِّ الذُّكُورَ مِنْ كُلِّ فَاتِحِ رَحِمٍ وَأَفْدِي كُلَّ بِكْرٍ مِنْ أَوْلادِي. ");
INSERT INTO arbnav_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","فَتَكُونُ هَذِهِ الْفَرِيضَةُ بِمَثَابَةِ عَلامَةٍ عَلَى يَدِكَ وَرَمْزاً عَلَى جَبْهَتِكَ، لأَنَّ الرَّبَّ قَدْ أَخْرَجَنَا بِيَدٍ قَدِيرَةٍ مِنْ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","وَعِنْدَمَا أَطْلَقَ فِرْعَوْنُ الشَّعْبَ لَمْ يَقُدْهُمُ اللهُ فِي طَرِيقِ بِلادِ الْفِلِسْطِينِيِّينَ عَلَى الرَّغْمِ مِنْ قِصَرِهَا. لأَنَّ اللهَ قَالَ لِئَلّا يَنْدَمَ الشَّعْبُ إِذَا تَعَرَّضَ لِحَرْبٍ وَيَرْجِعَ إِلَى مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","إِنَّمَا اقْتَادَ اللهُ الشَّعْبَ عَبْرَ صَحْرَاءِ الْبَحْرِ الأَحْمَرِ. وَكَانَ بَنُو إِسْرَائِيلَ قَدْ غَادَرُوا مِصْرَ مُتَسَلِّحِينَ مُتَأَهِّبِينَ لِلْقِتَالِ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","وَحَمَلَ مُوسَى عِظَامَ يُوسُفَ مَعَهُ، لأَنَّهُ كَانَ قَدِ اسْتَحْلَفَ بَنِي إِسْرَائِيلَ بِحَلْفٍ قَائِلاً: «لابُدَّ أَنْ يَفْتَقِدَكُمُ اللهُ فَعَلَيْكُمْ أَنْ تَنْقُلُوا عِظَامِي مَعَكُمْ مِنْ هَذَا الْمَكَانِ». ");
INSERT INTO arbnav_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","وَارْتَحَلُوا مِنْ سُكُّوتَ وَخَيَّمُوا فِي إِيثَامَ عَلَى طَرَفِ الصَّحْرَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","وَكَانَ الرَّبُّ يَتَقَدَّمُهُمْ نَهَاراً فِي عَمُودِ سَحَابٍ لِيَهْدِيَهُمْ فِي الطَّرِيقِ، وَلَيْلاً فِي عَمُودِ نَارٍ لِيُضِيءَ لَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","وَلَمْ يَبْرَحْ عَمُودُ السَّحَابِ نَهَاراً وَعَمُودُ النَّارِ لَيْلاً مِنْ أَمَامِ الشَّعْبِ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«قُلْ لِبَنِي إِسْرَائِيلَ أَنْ يَرْجِعُوا وَيَتَجَمَّعُوا مُقَابِلَ فَمِ الْحِيرُوثِ بَيْنَ مَجْدَلَ وَالْبَحْرِ أَمَامَ بَعْلَ صَفُونَ مُبَاشَرَةً تُخَيِّمَونَ عِنْدَ الْبَحْرِ، ");
INSERT INTO arbnav_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","فَيَظُنُّ فِرْعَوْنُ أَنَّكُمْ هَائِمُونَ فِي الأَرْضِ عَلَى غَيْرِ هُدىً، وَقَدِ اسْتَغْلَقَتْ عَلَيْكُمُ الصَّحْرَاءُ، ");
INSERT INTO arbnav_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","فَأُقَسِّي قَلْبَ فِرْعَوْنَ حَتَّى يَسْعَى وَرَاءَكُمْ فَأَتَعَظَّمُ آنَئِذٍ (بِالقَضَاءِ) عَلَى فِرْعَوْنَ وَعَلَى جَيْشِهِ، وَيَعْرِفُ الْمِصْرِيُّونَ أَنِّي أَنَا الرَّبُّ». وَهَكَذَا فَعَلَ الإِسْرَائِيلِيُّونَ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","وَقِيلَ لِمَلِكِ مِصْرَ: «هُوَذا الشَّعْبُ قَدْ هَرَبَ». فَتَحَوَّلَ قَلْبُ فِرْعَوْنَ وَقُلُوبُ حَاشِيَتِهِ ضِدَّهُمْ، وَقَالُوا: «مَاذَا دَهَانَا حَتَّى أَطْلَقْنَا إِسْرَائِيلَ مِنْ خِدْمَتِنَا؟» ");
INSERT INTO arbnav_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","فَأَعَدَّ مَرْكَبَتَهُ وَاصْطَحَبَ جَيْشَهُ مَعَهُ، ");
INSERT INTO arbnav_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","فَأَعَدَّ سِتَّ مِئَةِ مَرْكَبَةٍ وَسَائِرَ مَرْكَبَاتِ مِصْرَ، وَحَمَلَ عَلَيْهَا قَادَةَ سِلاحِ الْمَرْكَبَاتِ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","وَقَسَّى الرَّبُّ قَلْبَ فِرْعَوْنَ مَلِكِ مِصْرَ، فَطَارَدَ بَنِي إِسْرَائِيلَ الَّذِينَ غَادَرُوا مِصْرَ بِقُدْرَةٍ ظَاهِرَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","وَسَعَى الْمِصْرِيُّونَ وَرَاءَهُمْ بِجَمِيعِ خَيْلِ فِرْعَوْنَ وَمَرْكَبَاتِهِ وَفُرْسَانِهِ وَجُيُوشِهِ، فَأَدْرَكُوهُمْ وَهُمْ مُتَجَمِّعُونَ عِنْدَ الْبَحْرِ بالقُرْبِ مِنْ فَمِ الْحِيروثِ مُقَابِلَ بَعْلَ صَفُونَ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","وَلَمَّا اقْتَرَبَ فِرْعَوْنُ، نَظَرَ بَنُو إسْرَائِيلَ، وَإذَا بِالْمِصْرِيِّينَ يَنْدَفِعُونَ نَحْوَهُمْ، فَارْتَعَبُوا وَاسْتَغَاثُوا بِالرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ثُمَّ قَالُوا لَمُوسَى: «هَلْ لِافْتِقَارِ مِصْرَ لِلْقُبُورِ أَخْرَجْتَنَا إِلَى الصَّحْرَاءِ لِنَمُوتَ فِيهَا؟ مَاذَا فَعَلْتَ بِنَا حَتَّى أَخْرَجْتَنَا مِنْ مِصْرَ؟ ");
INSERT INTO arbnav_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","أَلَمْ نَقُلْ لَكَ فِي مِصْرَ: دَعْنَا وَشَأْنَنَا فَنَخْدُمَ الْمِصْرِيِّينَ، إذْ كَانَ خَيْراً لَنَا أَنْ نَخْدُمَ الْمِصْرِيِّينَ مِنْ أَنْ نَمُوتَ فِي الصَّحْرَاءِ». ");
INSERT INTO arbnav_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","فَقَالَ مُوسَى لِلشَّعْبِ: «لا تَخَافُوا. قِفُوا وَانْظُرُوا خَلاصَ الرَّبِّ الَّذِي يُجْرِيهِ لَكُمُ الْيَوْمَ، لأَنَّ الْمِصْرِيِّينَ الَّذِينَ رَأَيْتُمُوهُمُ الْيَوْمَ، لَنْ تَرَوْهُمْ فِيمَا بَعْدُ إِلَى الأَبَدِ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","فَالرَّبُّ يُحَارِبُ عَنْكُمْ وَأَنْتُمْ تَصْمُتُونَ». ");
INSERT INTO arbnav_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","وَقَالَ الرَّبُّ لمُوسَى: «مَا بَالُكَ تَسْتَغِيثُ بِي؟ قُلْ لِبَنِي إِسْرَائِيلَ أَنْ يَرْحَلُوا. ");
INSERT INTO arbnav_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ارْفَعْ عَصَاكَ وَابْسُطْ يَدَكَ فَوْقَ الْبَحْرِ وَشُقَّهُ، فَيَجْتَازَ بَنُو إِسْرَائِيلَ فِي وَسْطِ الْبَحْرِ عَلَى الْيَابِسَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","فَهَا أَنَا أُغْلِظُ قُلُوبَ الْمِصْرِيِّينَ فَيَسْعَوْنَ وَرَاءَكُمْ، فَأَتَعَظَّمُ (بِالقَضَاءِ) عَلَى فِرْعَوْنَ وَعَلَى مَرْكَبَاتِهِ وَفُرْسَانِهِ، ");
INSERT INTO arbnav_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","فَيُدْرِكُ الْمِصْرِيُّونَ أَنَّنِي أَنَا الرَّبُّ، عِنْدَمَا أَتَعَظَّمُ (بِالقَضَاءِ) عَلَى فِرْعَوْنَ وَمَرْكَبَاتِهِ وَفُرْسَانِهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","وَانْتَقَلَ مَلاكُ اللهِ الَّذِي كَانَ يَتَقَدَّمُ عَسْكَرَ إِسْرَائِيلَ إِلَى الْمُؤَخَّرَةِ خَلْفَهُمْ، وَكَذَلِكَ انْتَقَلَ عَمُودُ السَّحَابِ مِنْ أَمَامِهِمْ وَوَقَفَ وَرَاءَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","فَدَخَلَ بَيْنَ عَسْكَرِ الْمِصْرِيِّينَ وَعَسْكَرِ الإِسْرَائِيلِيِّينَ، وَصَارَ عَمُودُ السَّحَابِ ظَلاماً قَاتِماً عَلَى الْمِصْرِيِّينَ، وَضِيَاءً عَلَى بَنِي إِسْرَائِيلَ، فَلَمْ يَقْتَرِبْ أَحَدُهُمَا مِنَ الآخَرِ طَوَالَ اللَّيْلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","وَبَسَطَ مُوسَى يَدَهُ فَوْقَ الْبَحْرِ، فَأَرْسَلَ الرَّبُّ طَوَالَ تِلْكَ اللَّيْلَةِ رِيحاً شَرْقِيَّةً قَوِيَّةً رَدَّتِ الْبَحْرَ إِلَى الْوَرَاءِ، وَحَوَّلَتْهُ إِلَى يَابِسَةٍ. وَهَكَذَا انْشَقَّ الْبَحْرُ، ");
INSERT INTO arbnav_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","فَاجْتَازَ الإِسْرَائِيلِيُّونَ فِي وَسْطِ الْبَحْرِ عَلَى أَرْضٍ يَابِسَةٍ، فَكَانَ الْمَاءُ بِمَثَابَةِ سُورَيْنِ عَنْ يَمِينِهِمْ وَعَنْ يَسَارِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","وَلَحِقَ بِهِمِ الْمِصْرِيُّونَ وَدَخَلُوا وَرَاءَهُمْ إِلَى وَسْطِ الْبَحْرِ، بِجَمِيعِ خَيْلِ فِرْعَوْنَ وَمَرْكَبَاتِهِ وَفُرْسَانِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","وَقَبْلَ طُلُوعِ الصَّبَاحِ أَشْرَفَ الرَّبُّ فِي عَمُودِ النَّارِ وَالسَّحَابِ عَلَى عَسْكَرِ الْمِصْرِيِّينَ وَأَرْبَكَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","فَجَعَلَ عَجَلاتِ مَرْكَبَاتِهِمْ تَتَخَلَّعُ. فَطَفِقُوا يَجُرُّونَهَا بِمَشَقَّةٍ حَتَّى قَالَ الْمِصْرِيُّونَ: «لِنَهْرُبْ مِنَ الإِسْرَائِيلِيِّينَ، لأَنَّ الرَّبَّ يُحَارِبُ عَنْهُمْ ضِدَّنَا». ");
INSERT INTO arbnav_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","وَقَالَ الرَّبُّ لِمُوسَى: «ابْسُطْ يَدَكَ فَوْقَ الْبَحْرِ لِيَرْتَدَّ الْمَاءُ عَلَى الْمِصْرِيِّينَ مَعَ مَرْكَبَاتِهِمْ وَفُرْسَانِهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","فَبَسَطَ مُوسَى يَدَهُ فَوْقَ البَحْرِ عِنْدَ انْبِثَاقِ الصَّبَاحِ، فَارْتَدَّ الْبَحْرُ إِلَى مَوْضِعِهِ عَلَى الْمِصْرِيِّينَ الْهَارِبِينَ فِي اتِّجَاهِهِ، فَجَرَفَهُمُ الرَّبُّ نَحْوَ وَسْطِ الْبَحْرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","وَارْتَدَّتِ الْمِيَاهُ وَأَغْرَقَتِ الْمَرْكَبَاتِ وَالْفُرْسَانَ وَكُلَّ جَيْشِ فِرْعَوْنَ الَّذِي لَحِقَ بِهِمْ إِلَى الْبَحْرِ، فَلَمْ يَفْلِتْ مِنْهُمْ نَاجٍ وَاحِدٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","أَمَّا بَنُو إِسْرَائِيلَ فَقَدْ سَارُوا فَوْقَ أَرْضٍ يَابِسَةٍ وَسْطَ مِيَاهِ الْبَحْرِ. وَكَانَتِ الْمِيَاهُ كَسُورَيْنِ عَنْ يَمِينِهِمْ وَعَنْ شِمَالِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","وَهَكَذَا أَنْقَذَ الرَّبُّ فِي ذَلِكَ الْيَوْمِ الإِسْرَائِيلِيِّينَ مِنْ يَدِ الْمِصْرِيِّينَ، وَشَاهَدُوا جُثَثَ الْمِصْرِيِّينَ مَطْرُوحَةً عَلَى شَاطِئِ الْبَحْرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","وَعِنْدَمَا شَهِدَ الإِسْرَائِيلِيُّونَ الْقُوَّةَ الْعَظِيمَةَ الَّتِي عَامَلَ بِها الرَّبُّ الْمِصْرِيِّينَ، خَافَ الشَّعْبُ الرَّبَّ وَآمَنُوا بِهِ وَبِمُوسَى عَبْدِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","عِنْدَئِذٍ شَدَا مُوسَى وَبَنُو إِسْرَائِيلَ بِهَذِهِ التَّسْبِحَةِ لِلرَّبِّ قَائِلِينَ: «أُرَنِّمُ لِلرَّبِّ لأَنَّهُ تَمَجَّدَ جِدّاً، الْفَرَسَ وَرَاكِبَهُ قَدْ طَرَحَهُمَا فِي الْبَحْرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","الرَّبُّ قُوَّتِي وَنَشِيدِي وَقَدْ صَارَ خَلاصِي، هَذَا هُوَ إِلَهِي فَأُسَبِّحُهُ. وَإِلَهُ أَبِي فَأُعَظِّمُهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","الرَّبُّ مُحَارِبٌ، ’الرَّبُّ‘ اسْمُهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","طَرَحَ فِرْعَوْنَ وَجَيْشَهُ فِي الْبَحْرِ، وَأَغْرَقَ خِيرَةَ قَادَةِ فِرْعَوْنَ فِي الْبَحْرِ الأَحْمَرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","غَمَرَتْهُمُ اللُّجَجُ فَغَاصُوا إِلَى الأَعْمَاقِ كَالْحِجَارَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","يَمِينُكَ يَا رَبُّ مَجِيدَةٌ فِي قُوَّتِهَا. بِيَمِينِكَ يَا رَبُّ تَسْحَقُ الْعَدُوَّ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","بِعَظَمَةِ جَلالِكَ تَصْرَعُ مُقَاوِمِيكَ. تُرْسِلُ غَضَبَكَ فَتَأْكُلُهُمْ كَالقَشِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","بِرِيحِكَ الْعَاصِفَةِ تَكَوَّمَتِ الْمِيَاهُ، وَانْتَصَبَتِ اللُّجَجُ فِي قَلْبِ الْبَحْرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","قَالَ الْعَدُوُّ: أَسْعَى وَرَاءَهُمْ فَأُدْرِكُهُمْ. أُقَسِّمُ أَسْلابَهُمْ وَتَشْتَفِي مِنْهُمْ نَفْسِي. أَسْتَلُّ سَيْفِي بِيَدِي وَأُهْلِكُهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","لَكِنَّكَ أَطْلَقْتَ رِيحَكَ فَغَشِيَهُمُ الْبَحْرُ، فَغَرِقُوا كَالرَّصَاصِ فِي اللُّجَجِ الْعَمِيقَةِ ");
INSERT INTO arbnav_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","فَمَنْ مِثْلُكَ يَا رَبُّ بَيْنَ كُلِّ الآلِهَةِ؟ مَنْ مِثْلُكَ جَلِيلٌ فِي الْقَدَاسَةِ مَهِيبٌ فِي الْمَجْدِ، صَانِعٌ عَجَائِبَ! ");
INSERT INTO arbnav_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","بَسَطْتَ يَمِينَكَ فَابْتَلَعَتْهُمُ الأَرْضُ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","قُدْتَ بِرَحْمَتِكَ الشَّعْبَ الَّذِي افْتَدَيْتَهُ، وَبِقُدْرَتِكَ هَدَيْتَهُ إِلَى مَسْكَنِكَ الْمُقَدَّسِ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","فَتَسْمَعُ الشُّعُوبُ وَتَرْتَعِبُ، وَتَسْتَوْلِي الرَّعْدَةُ عَلَى أَهْلِ فِلِسْطِينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","آنَئِذٍ يَنْدَهِشُ أُمَرَاءُ أَدُومَ، جَبَابِرَةُ مُوآبَ تَأْخُذُهُمُ الرَّجْفَةُ، وَيَذُوبُ حُكَّامُ كَنْعَانَ هَلَعاً. ");
INSERT INTO arbnav_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","يَسُودُهُمُ الْخَوْفُ والرَّعْدَةُ وَبِقُدْرَةِ ذِرَاعِكَ يَجْمُدُونَ كَالْحِجَارَةِ حَتَّى يَعْبُرَ شَعْبُكَ يَا رَبُّ، حَتَّى يَعْبُرَ شَعْبُكَ الَّذِي اشْتَرَيْتَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","تَأْتِي بِهِمْ وَتَغْرِسُهُمْ فِي جَبَلِ مِيرَاثِكَ، الْمَوْضِعِ الَّذِي جَعَلْتَهُ يَا رَبُّ لِسُكْنَاكَ، الْمَقْدِسِ الَّذِي أَعَدَّتْهُ يَا رَبُّ يَدَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","الرَّبُّ يَمْلِكُ إِلَى الدَّهْرِ وَالأَبَدِ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","وَعِنْدَمَا دَخَلَتْ خُيُولُ فِرْعَوْنَ وَمَرْكَبَاتُهُ وَفُرْسَانُهُ إِلَى الْبَحْرِ رَدَّ عَلَيْهِمْ مِيَاهَ الْبَحْرِ، أَمَّا بَنُو إِسْرَائِيلَ فَمَشَوْا عَلَى الْيَابِسَةِ فِي وَسْطِ الْبَحْرِ». ");
INSERT INTO arbnav_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","عِنْدَئِذٍ أَخَذَتْ مَرْيَمُ النَّبِيَّةُ أُخْتُ هَرُونَ، الدُّفَّ بِيَدِهَا، فَتَبِعَهَا جَمِيعُ النِّسَاءِ بالدُّفِّ وَالرَّقْصِ. ");
INSERT INTO arbnav_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","فَكَانَتْ مَرْيَمُ تُجَاوِبُهُنَّ: «رَنِّمُوا لِلرَّبِّ لأَنَّهُ قَدْ تَمَجَّدَ جِدّاً. الْفَرَسَ وَرَاكِبَهُ قَدْ طَرَحَهُمَا فِي الْبَحْرِ». ");
INSERT INTO arbnav_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ثُمَّ ارْتَحَلَ مُوسَى بِإِسْرَائِيلَ مِنَ الْبَحْرِ الأَحْمَرِ، وَتَوَجَّهُوا نَحْوَ صَحْرَاءِ شُورٍ، وَظَلُّوا يَجُوبُونَ الصَّحْرَاءَ ثَلاثَةَ أَيَّامٍ مِنْ غَيْرِ أَنْ يَجِدُوا مَاءً. ");
INSERT INTO arbnav_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","وَعِنْدَمَا وَصَلُوا إِلَى مَارَّةَ لَمْ يَقْدِرُوا أَنْ يَشْرَبُوا مَاءَهَا لِمَرَارَتِهِ، لِذَلِكَ سُمِّيَتْ «مَارَّةَ». ");
INSERT INTO arbnav_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","فَتَذَمَّرَ الشَّعْبُ عَلَى مُوسَى قَائِلِينَ: «مَاذَا نَشْرَبُ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","فَاسْتَغَاثَ بِالرَّبِّ، فَأَرَاهُ الرَّبُّ شَجَرَةً فَأَلْقَاهَا إِلَى الْمَاءِ، فَصَارَ عَذْباً. وَهُنَاكَ أَيْضاً وَضَعَ الرَّبُّ لِلشَّعْبِ فَرِيضَةً وَشَرِيعَةً، وَامْتَحَنَهُ، ");
INSERT INTO arbnav_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","وَقَالَ: «إِنْ كُنْتَ تَحْرِصُ عَلَى سَمَاعِ صَوْتِ الرَّبِّ إِلَهِكَ، وَتَفْعَلُ مَا هُوَ حَقٌّ أَمَامَهُ، وَتُطِيعُ وَصَايَاهُ وَتُحَافِظُ عَلَى جَمِيعِ فَرَائِضِهِ، فَلَنْ أَدَعَكَ تُقَاسِي مِنْ أَيِّ مَرَضٍ مِنَ الأَمْرَاضِ الَّتِي ابْتَلَيْتُ بِها الْمِصْرِيِّينَ، فَإِنِّي أَنَا الرَّبُّ شَافِيكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ثُمَّ بَلَغُوا إِيلِيمَ حَيْثُ كَانَتِ اثْنَتَا عَشْرَةَ عَيْنَ مَاءٍ وَسَبْعُونَ نَخْلَةً. فَخَيَّمُوا إِلَى جُوَارِ عُيُونِ الْمَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ثُمَّ انْتَقَلَتْ كُلُّ جَمَاعَةِ إِسْرَائِيلَ مِنْ إِيلِيمَ حَتَّى أَقْبَلُوا إِلَى صَحْرَاءِ سِينَ الْوَاقِعَةِ بَيْنَ إِيلِيمَ وَسِينَاءَ، وَذَلِكَ فِي الْيَوْمِ الْخَامِسَ عَشَرَ مِنَ الشَّهْرِ الثَّانِي بَعْدَ خُرُوجِهِمْ مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","وَهُنَاكَ فِي الصَّحْرَاءِ تَذَمَّرَ بَنُو إِسْرَائِيلَ عَلَى مُوسَى وَهَرُونَ، ");
INSERT INTO arbnav_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","وَقَالُوا لَهُمَا: «لَيْتَ الرَّبَّ أَمَاتَنَا فِي أَرْضِ مِصْرَ، فَهُنَاكَ كُنَّا نَجْلِسُ حَوْلَ قُدُورِ اللَّحْمِ نَأْكُلُ خُبْزاً حَتَّى الشَّبْعِ. وَهَا أَنْتُمَا قَدْ أَخْرَجْتُمَانَا إِلَى هَذِهِ الصَّحْرَاءِ لِتُمِيتَا كُلَّ هَذِهِ الْجَمَاعَةِ جُوعاً». ");
INSERT INTO arbnav_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","فَقَالَ الرَّبُّ لِمُوسَى: «هَا أَنَا أُمْطِرُ عَلَيْكُمْ خُبْزاً مِنَ السَّمَاءِ، فَيَخْرُجُ الشَّعْبُ وَيَلْتَقِطُ حَاجَةَ كُلِّ يَوْمٍ بِيَوْمِهِ، لِكَيْ أَمْتَحِنَهُمْ، فَأَرَى إنْ كَانُوا يَسْلُكُونَ فِي شَرِيعَتِي أَمْ لا. ");
INSERT INTO arbnav_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","وَلَكِنْ لِيَكُنْ مَا يَلْتَقِطُونَهُ فِي الْيَوْمِ السَّادِسِ ضِعْفَ مَا يَجْمَعُونَهُ فِي كُلِّ يَوْمٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","فَقَالَ مُوسَى وَهَرُونُ لِجَمِيعِ بَنِي إِسْرَائِيلَ: «فِي الْمَسَاءِ تَعْلَمُونَ أَنَّ الرَّبَّ هُوَ الَّذِي أَخْرَجَكُمْ مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","وَفِي الصَّبَاحِ تُعَايِنُونَ مَجْدَ الرَّبِّ، لأَنَّهُ قَدْ سَمِعَ تَذَمُّرَكُمْ عَلَيْهِ، وَلَكِنْ مَنْ نَحْنُ حَتَّى تَتَذَمَّرُوا عَلَيْنَا؟» ");
INSERT INTO arbnav_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","وَقَالَ مُوسَى أَيْضاً: «إِنَّكُمْ سَتَعْلَمُونَ أَنَّهُ هُوَ الرَّبُّ، عِنْدَمَا يُعْطِيكُمْ لَحْماً فِي الْمَسَاءِ لِتَأْكُلُوا، وَخُبْزاً فِي الصَّبَاحِ لِتَشْبَعُوا، لأَنَّهُ سَمِعَ تَذَمُّرَكُمْ عَلَيْهِ. فَمَاذَا نَحْنُ؟ إِنَّكُمْ تَتَذَمَّرُونَ عَلَى اللهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","وَقَالَ مُوسَى لِهَرُونَ: «قُلْ لِبَنِي إِسْرَائِيلَ أَنْ يَمْثُلُوا أَمَامَ الرَّبِّ لأَنَّهُ قَدْ سَمِعَ تَذَمُّرَهُمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","وَفِيمَا كَانَ هَرُونُ يُخَاطِبُ كُلَّ جَمَاعَةِ بَنِي إِسْرَائِيلَ، الْتَفَتُوا نَحْوَ الصَّحْرَاءِ وَإذَا بِمَجْدِ الرَّبِّ قَدْ تَجَلَّى فِي السَّحَابِ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","فَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«سَمِعْتُ تَذَمُّرَ بَنِي إِسْرَائِيلَ، فَقُلْ لَهُمْ: فِي الْمَسَاءِ تَأْكُلُونَ لَحْماً، وَفِي الصَّبَاحِ تَشْبَعُونَ خُبْزاً، فَتَعْلَمُونَ أَنَّنِي أَنَا الرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","فِي ذَلِكَ الْمَسَاءِ أَقْبَلَتْ طُيُورُ السَّلْوَى (السُّمَانَي) وَغَطَّتِ الْمُخَيَّمَ. وَفِي الصَّبَاحِ كَسَتْ طَبَقَةُ النَّدَى الأَرْضَ الْمُحِيطَةَ بِالْمُخَيَّمِ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","وَعِنْدَمَا زَالَتْ طَبَقَةُ النَّدَى إِذَا وَجْهُ الصَّحْرَاءِ مُغَطَّى بِشَيْءٍ رَقِيقٍ كالْقُشُورِ، مُكَتَّلٍ كَالْجَلِيدِ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","وَعِنْدَمَا رَآهُ بَنُو إِسْرَائِيلَ، قَالَ بَعْضُهُمْ لِبَعْضٍ «مَنْهُو» أَيْ مَا هَذَا؟ لأَنَّهُمْ لَمْ يَعْرِفُوا مَا هُوَ. فَقَالَ لَهُمْ موُسَى: «هُوَ خُبْزُ الرَّبِّ الَّذِي أَعْطَاكُمْ لِتَأْكُلُوهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","وَهَذَا مَا يَأْمُرُكُمْ بِهِ الرَّبُّ: الْتَقِطُوا مِنْهُ كُلُّ وَاحِدٍ عَلَى قَدْرِ مَأْكَلِهِ، لِكُلِّ وَاحِدٍ عُمِراً (نَحْوَ لِتْرَيْنِ وَنِصْفِ اللِّتْرِ) وَفْقاً لِعَدَدِ أَهْلِ بَيْتِهِ الْمُقِيمِينَ مَعَهُ فِي خَيْمَتِهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","فَفَعَلَ بَنُو إِسْرَائِيلَ هَكَذَا فَمِنْهُمْ مَنِ الْتَقَطَ مُكَثِّراً، وَمِنْهُمْ مَنِ الْتَقَطَ مُقِلًّا. ");
INSERT INTO arbnav_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","وَلَكِنْ عِنْدَمَا كَالُوا بِالعُمِرِ مَا الْتَقَطُوهُ، فَإِنَّ الْمُكَثِّرَ لَمْ يَفْضُلْ عَنْهُ، وَالمُقِلَّ لَمْ يَنْقُصْهُ شَيْءٌ، فَجَمَعَ كُلُّ وَاحِدٍ عَلَى قَدْرِ مَأْكَلِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","وَقَالَ مُوسَى لَهُمْ: «لا يُبْقِ أَحَدٌ مِنْهُ شَيْئاً إِلَى الصَّبَاحِ». ");
INSERT INTO arbnav_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","وَمَعَ ذَلِكَ، فَإِنَّ بَعْضَهُمْ لَمْ يَسْمَعْ لِمُوسَى، بَلْ أَبْقَوْا مِنْهُ لِلصَّبَاحِ، فَتَوَلَّدَ فِيهِ دُودٌ وَأَنْتَنَ. فَسَخَطَ عَلَيْهِمْ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","فَكَانَ كُلُّ وَاحِدٍ يَلْتَقِطُ كُلَّ صَبَاحٍ عَلَى قَدْرِ مَأْكَلِهِ. وَمَا إِنْ تَشْتَدُّ حَرَارَةُ الشَّمْسِ حَتَّى يَذُوبَ مَا بَقِيَ مِنْهُ عَلَى الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","أَمَّا فِي الْيَوْمِ السَّادِسِ فَكَانُوا يَلْتَقِطُونَ مِنَ الْخُبْزِ الضِّعْفَ، أَيْ عُمِرَيْنِ (نَحْوَ خَمْسَةِ لِتْرَاتٍ) لِكُلِّ وَاحِدٍ فَجَاءَ رُؤَسَاءُ الْجَمَاعَةِ وَأَبْلَغُوا الأَمْرَ لِمُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","فَقَالَ لَهُمْ: «هَذَا مَا أَمَرَ بِهِ الرَّبُّ. غَداً يَكُونُ يَوْمَ رَاحَةٍ، سَبْتاً مُقَدَّساً لِلرَّبِّ. اخْبِزُوا مَا تُرِيدُونَ خَبْزَهُ وَاطْبُخُوا مَا تَشَاؤُونَ، وَاحْتَفِظُوا بِمَا يَفْضُلُ إِلَى الصَّبَاحِ». ");
INSERT INTO arbnav_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","فَأَبْقُوهُ إِلَى الصَّبَاحِ كَمَا أَمَرَ مُوسَى، فَلَمْ يُنْتِنْ وَلا صَارَ فِيهِ دُودٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","وَقَالَ مُوسَى: «كُلُوا الْيَوْمَ لأَنَّ الْيَوْمَ هُوَ سَبْتٌ لِلرَّبِّ، إذْ لَنْ تَجِدُوا الْيَوْمَ طَعَاماً فِي الْحَقْلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","سِتَّةَ أَيَّامٍ تَلْتَقِطُونَهُ وَأَمَّا الْيَوْمُ السَّابِعُ فَهُوَ سَبْتٌ وَلَنْ تَجِدُوا فِيهِ طَعَاماً». ");
INSERT INTO arbnav_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","غَيْرَ أَنَّ أُنَاساً مِنْهُمْ خَرَجُوا فِي السَّبْتِ لِيَلْتَقِطُوا مِنْهُ، فَلَمْ يَجِدُوا شَيْئاً. ");
INSERT INTO arbnav_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: «إِلَى مَتَى تَأْبُونَ حِفْظَ وَصَايَايَ وَشَرِيعَتِي؟ ");
INSERT INTO arbnav_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","انْظُرُوا. فَهَا الرَّبُّ قَدْ أَعْطَاكُمُ السَّبْتَ لِذَلِكَ هُوَ يُقَدِّمُ لَكُمْ فِي الْيَوْمِ السَّادِسِ خُبْزَ يَوْمَيْنِ، فَلْيَلْبَثْ كُلُّ وَاحِدٍ فِي مَكَانِهِ وَلا يُغَادِرْهُ فِي الْيَوْمِ السَّابِعِ». ");
INSERT INTO arbnav_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","فَاسْتَرَاحَ الشَّعْبُ فِي الْيَوْمِ السَّابِعِ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","وَدَعَا شَعْبُ إِسْرَائِيلَ الْخُبْزَ «مَنّاً». وَكَانَ أَبْيَضَ كَبِزْرِ الْكُزْبَرَةِ، وَمَذَاقُهُ كَرِقَاقٍ مَصْنُوعَةٍ بِعَسَلٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","وَقَالَ مُوسَى: «إِلَيْكُمْ مَا أَمَرَ بِهِ الرَّبُّ: احْفَظُوا مِلْءَ الْعُمِرِ مِنْهُ ذِكْرَى لأَجْيَالِكُمُ الْمُقْبِلَةِ، لِكَيْ يَرَوْا الْخُبْزَ الَّذِي أَطْعَمْتُكُمْ بِهِ فِي الصَّحْرَاءِ عِنْدَمَا أَخْرَجْتُكُمْ مِنْ أَرْضِ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","وَقَالَ مُوسَى لِهَرُونَ: «خُذْ إِنَاءً وَاجْعَلْ فِيهِ مِقْدَارَ عُمِرٍ مِنَ الْمَنِّ وَضَعْهُ أَمَامَ الرَّبِّ لِيَظَلَّ مَحْفُوظاً فِي أَجْيَالِكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","وَكَمَا أَمَرَ الرَّبُّ مُوسَى وَضَعَهُ هَرُونُ أَمَامَ الشَّهَادَةِ حِفَاظاً عَلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","وَاقْتَاتَ الإِسْرَائِيلِيُّونَ بِالمَنِّ طَوَالَ أَرْبَعِينَ سَنَةً حَتَّى جَاءُوا إِلَى تُخُومِ أَرْضِ كَنْعَانَ الْعَامِرَةِ بِالسُّكَّانِ. ");
INSERT INTO arbnav_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","وَأَمَّا الْعُمِرُ فَهُوَ عُشْرُ الإِيفَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","وَتَنَقَّلَ بَنُو إِسْرَائِيلَ عَلَى مَرَاحِلَ، مِنْ صَحْرَاءِ سِينَ بِمُقْتَضَى أَمْرِ الرَّبِّ إِلَى أَنْ خَيَّمُوا فِي رَفِيدِيمَ حَيْثُ لَمْ يَجِدُوا مَاءً لِلشُّرْبِ. ");
INSERT INTO arbnav_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","فَتَخَاصَمَ الشَّعْبُ مَعَ مُوسَى قَائِلِينَ: «أَعْطُونَا مَاءً لِنَشْرَبَ». فَأَجَابَ مُوسَى: «لِمَاذَا تُخَاصِمُونَنِي؟ وَلِمَاذَا تَجَرِّبُونَ الرَّبَّ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","وَلَكِنَّ الشَّعْبَ كَانَ مُتَعَطِّشاً إِلَى الْمَاءِ، فَتَذَمَّرُوا عَلَى مُوسَى وَقَالُوا: «لِمَاذَا أَخْرَجْتَنَا مِنْ مِصْرَ لِتُمِيتَنَا وَأَوْلادَنَا وَمَوَاشِينَا عَطَشاً؟» ");
INSERT INTO arbnav_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","فَصَرَخَ مُوسَى إِلَى الرَّبِّ: «مَاذَا أَصْنَعُ بِهَذَا الشَّعْبِ؟ إِنَّهُمْ يَكَادُونَ يَرْجُمُونَنِي» ");
INSERT INTO arbnav_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","فَأَجَابَهُ الرَّبُّ: «تَقَدَّمِ الشَّعْبَ وَخُذْ مَعَكَ بَعْضَ شُيُوخِ بَنِي إِسْرَائِيلَ، وَخُذْ بِيَدِكَ عَصَاكَ أَيْضاً الَّتِي ضَرَبْتَ بِها النَّهْرَ، ");
INSERT INTO arbnav_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","فَهَا أَنَا أَقِفُ هُنَاكَ أَمَامَكَ عَلَى الصَّخْرَةِ فِي حُورِيبَ. اضْرِبِ الصَّخْرَةَ فَيَنْفَجِرَ مِنْهَا الْمَاءُ لِيَشْرَبَ الشَّعْبُ». وَهَكَذَا فَعَلَ مُوسَى أَمَامَ شُيُوخِ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","وَدَعَا اسْمَ الْمَوْضِعِ مَسَّةَ وَمَرِيبَةَ (وَمَعْنَاهُ الامْتِحَانُ وَالمُخَاصَمَةُ) نَتِيجَةً لِتَخَاصُمِ بَنِي إِسْرَائِيلَ وَامْتِحَانِهِمْ لِلرَّبِّ قَائِلِينَ: «هَلِ الرَّبُّ فِي وَسْطِنَا أَمْ لا؟» ");
INSERT INTO arbnav_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","وَخَرَجَ الْعَمَالِقَةُ وَحَارَبُوا إِسْرَائِيلَ فِي رَفِيدِيمَ. ");
INSERT INTO arbnav_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","فَقَالَ مُوسَى لِيَشُوعَ: «انْتَخِبْ بَعْضَ رِجَالِنَا وَامْضِ لِمُحَارَبَةِ عَمَالِيقَ. وَهَا أَنَا أَقِفُ غَداً عَلَى قِمَّةِ التَّلِّ وَعَصَا اللهِ فِي يَدِي». ");
INSERT INTO arbnav_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","فَحَارَبَ يَشُوعُ الْعَمَالِقَةَ كَمَا أَمَرَ مُوسَى. وَصَعِدَ مُوسَى وَهَرُونُ وَحُورُ عَلَى قِمَّةِ التَّلَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","فَطَالَمَا كَانَ مُوسَى رَافِعاً يَدَهُ، يَغْلِبُ بَنُو إِسْرَائِيلَ، وَإذَا خَفَضَهَا يَفُوزُ الْعَمَالِقَةُ. ");
INSERT INTO arbnav_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","وَعِنْدَمَا دَبَّ التَّعَبُ فِي يَدَيْ مُوسَى أَخَذَ هَرُونُ وَحُورُ حَجَراً وَوَضَعَاهُ تَحْتَهُ، فَجَلَسَ عَلَيْهِ، وَأَسْنَدَ هَرُونُ وَحُورُ يَدَيْهِ، كُلُّ وَاحِدٍ مِنْهُمَا مِنْ جَانِبٍ. وَهَكَذَا بَقِيَتْ يَدَاهُ مَرْفُوعَتَيْنِ حَتَّى مَغْرِبِ الشَّمْسِ. ");
INSERT INTO arbnav_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","فَهَزَمَ يَشُوعُ الْعَمَالِقَةَ وَجَيْشَهُمْ بِحَدِّ السَّيْفِ. ");
INSERT INTO arbnav_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","فَقَالَ الرَّبُّ لِمُوسَى: «دَوِّنْ هَذَا فِي الْكِتَابِ لِلتَّذْكَارِ، وَاتْلُهُ عَلَى يَشُوعَ، لأَنَّنِي سَأَمْحُو ذِكْرَ الْعَمَالِقَةِ مِنْ تَحْتِ السَّمَاءِ». ");
INSERT INTO arbnav_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","وَشَيَّدَ مُوسَى مَذْبَحاً لِلرَّبِّ دَعَاهُ «يَهْوَهْ نِسِّي» (وَمَعْنَاهُ: الرَّبُّ رَايَتِي أَوْ عَلَمِي)، ");
INSERT INTO arbnav_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","قَائِلاً: «لأَنَّ يَداً ارْتَفَعَتْ ضِدَّ عَرْشِ الرَّبِّ، فَإِنَّ الرَّبَّ سَيُحَارِبُ الْعَمَالِقَةَ جِيلاً بَعْدَ جِيلٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","وَسَمِعَ يَثْرُونُ كَاهِنُ مِدْيَانَ وَحَمُو مُوسَى بِجَمِيعِ مَا أَجْرَاهُ اللهُ لِمُوسَى وَلإِسْرَائِيلَ شَعْبِهِ، وَكَيْفَ أَخْرَجَهُمْ مِنْ مِصْرَ، ");
INSERT INTO arbnav_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","فَأَخَذَ يَثْرُونُ حَمُو مُوسَى صَفُّورَةَ زَوْجَةَ مُوسَى الَّتِي كَانَ قَدْ أَرْجَعَهَا إِلَى أَبِيهَا ");
INSERT INTO arbnav_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","وَابْنَيْهَا اللَّذَيْنِ يُدْعَى أَحَدُهُمَا جِرْشُومَ (وَمَعْنَاهُ: غَرِيبٌ) لأَنَّ (مُوسَى) قَالَ: «كُنْتُ نَزِيلاً فِي أَرْضٍ غَرِيبَةٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","وَاسْمُ الثَّانِي أَلِيعَازَرُ (وَمَعْنَاهُ: إِلَهِي عَوْنٌ لِي) لأَنَّهُ قَالَ: «إِلَهُ أَبِي كَانَ عَوْنِي، فَأَنْقَذَنِي مِنْ سَيْفِ فِرْعَوْنَ». ");
INSERT INTO arbnav_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","وَقَدِمَ يَثْرُونُ حَمُو مُوسَى وَمَعَهُ ابْنَا مُوسَى وَزَوْجَتُهُ إِلَى مُوسَى فِي الصَّحْرَاءِ حَيْثُ كَانَ مُجْتَمِعاً عِنْدَ جَبَلِ اللهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","فَأَرْسَلَ إِلَى مُوسَى قَائِلاً: «أَنَا حَمُوكَ يَثْرُونُ قَادِمٌ إِلَيْكَ وَمَعِي زَوْجَتُكَ وَابْنَاهَا». ");
INSERT INTO arbnav_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","فَخَفَّ مُوسَى لاِسْتِقْبَالِ حَمِيهِ، وَانْحَنَى لَهُ احْتِرَاماً وَقَبَّلَهُ. وَسَأَلَ كُلٌّ مِنْهُمَا الآخَرَ عَنْ أَحْوَالِهِ، ثُمَّ دَخَلا إِلَى الْخَيْمَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","وَسَرَدَ مُوسَى عَلَى حَمِيهِ كُلَّ مَا أَجْرَاهُ الرَّبُّ عَلَى فِرْعَوْنَ وَالْمِصْرِيِّينَ لإِنْقَاذِ بَنِي إِسْرَائِيلَ، وَمَا تَعَرَّضُوا لَهُ مِنْ مَشَقَّةٍ فِي الطَّرِيقِ، وَكَيْفَ أَنْقَذَهُمُ الرَّبُّ مِنْهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","فَاغْتَبَطَ يَثْرُونُ بِجَمِيعِ مَا صَنَعَهُ الرَّبُّ مِنْ إِحْسَانٍ إِلَى إِسْرَائِيلَ، إذْ أَنْقَذَهُمْ مِنْ يَدِ الْمِصْرِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","وَقَالَ يَثْرُونُ: «مُبَارَكٌ الرَّبُّ الَّذِي أَنْقَذَكُمْ مِنْ يَدِ الْمِصْرِيِّينَ وَمِنْ يَدِ فِرْعَوْنَ، وَحَرَّرَ الشَّعْبَ مِنْ نِيرِ الْمِصْرِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","الآنَ أَعْلَمُ أَنَّ الرَّبَّ هُوَ أَعْظَمُ مِنْ جَمِيعِ الآلِهَةِ، لأَنَّهُ عَامَلَهُمْ بِمِثْلِ مَا بَغَوْا بِهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","وَقَدَّمَ يَثْرُونُ حَمُو مُوسَى مُحْرَقَةً وَذَبَائِحَ لِلهِ. وَجَاءَ هَرُونُ وَجَمِيعُ شُيُوخِ إِسْرَائِيلَ لِيَأْكُلُوا طَعَاماً مَعَ حَمِي مُوسَى فِي حَضْرَةِ اللهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","وَفِي الصَّبَاحِ جَلَسَ مُوسَى لِيَقْضِيَ لِلشَّعْبِ، وَظَلَّ الشَّعْبُ وَاقِفاً لَدَى مُوسَى مِنَ الصَّبَاحِ إِلَى المَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","فَلَمَّا رَأَى حَمُو مُوسَى جَمِيعَ مَا يَقُومُ بِهِ لِلشَّعْبِ قَالَ لَهُ: «مَا هَذَا الَّذِي تَصْنَعُهُ لِلشَّعْبِ؟ وَلِمَاذَا تَجْلِسُ وَحْدَك لِلْقَضَاءِ، بِيْنَمَا يَظَلُّ جَمِيعُ الشَّعْبِ وَاقِفاً لَدَيْكَ مِنَ الصَّبَاحِ إِلَى الْمَسَاءِ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","فَأَجَابَ مُوسَى: «لأَنَّ الشَّعْبَ يُقْبِلُ إِلَيَّ لِيَسْتَطْلِعَ إرَادَةَ اللهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","فَإِنْ كَانَ لَهُمْ دَعْوَى يَلْجَأُونَ إِلَيَّ فَأَقْضِي بَيْنَ الرَّجُلِ وَالآخَرِ، وَأُطْلِعُهُمْ عَلَى فَرَائِضِ اللهِ وَشَرَائِعِهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","فَقَالَ حَمُو مُوسَى: «إِنَّ مَا تَفْعَلُهُ لَيْسَ بِالأَمْرِ الصَّائِبِ، ");
INSERT INTO arbnav_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","إذْ لابُدَّ لِلْكَلَلِ أَنْ يَعْتَرِيَكَ أَنْتَ وَكُلَّ هَذَا الشَّعْبِ الَّذِي مَعَكَ، لأَنَّ الأَمْرَ فَوْقَ طَاقَتِكَ، وَلا يُمْكِنُكَ أَنْ تَتَوَلاهُ وَحْدَكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","فَأَصْغِ إِلَى صَوْتِي لأُسْدِيَ لَكَ نَصِيحَةً، وَلْيَكُنِ اللهُ مَعَكَ. فَلْتَكُنْ أَنْتَ مُمَثِّلَ الشَّعْبِ أَمَامَ اللهِ، فَتَرْفَعَ إِلَيْهِ دَعَاوَاهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","وَعَلِّمْهُمُ الْفَرَائِضَ وَالشَّرَائِعَ، وَأَعْلِنْ لَهُمُ الطَّرِيقَ الَّذِي يَسْلُكُونَهُ، وَمَا يَسْتَوْجِبُ عَلَيْهِمِ الْقِيَامُ بِهِ مِنْ أَعْمَالٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","وَلَكِنِ اخْتَرْ مِنْ بَيْنِ الشَّعْبِ رِجَالاً مُقْتَدِرِينَ خَائِفِينَ اللهَ أُمَنَاءَ يُبْغِضُونَ الرِّشْوَةَ، تُقِيمُهُمْ عَلَيْهِمْ رُؤَسَاءَ لِفِئَاتِ الأُلُوفِ وَالْمِئَاتِ وَالْخَمَاسِينَ وَالْعَشَرَاتِ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","فَيَقْضُونَ لِلشَّعْبِ فِي الدَعَاوَى الصَّغِيرَةِ فِي كُلِّ حِينٍ. أَمَّا الْقَضَايَا الْمُسْتَعْصِيَةُ فَيَرْفَعُونَهَا إِلَيْكَ، فَيُخَفِّفُ ذَلِكَ عَنْكَ، إذْ يُشَارِكُونَكَ فِي حَمْلِ الْعِبْءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","فَإِنْ فَعَلْتَ هَذَا وَأَوْصَاكَ اللهُ بِهِ، أَمْكَنَكَ الْقِيَامُ بِمَسْؤولِيَّاتِكَ، وَيَمْضِي جَمِيعُ هَذَا الشَّعْبِ إِلَى مَكَانِهِ بِسَلامٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","فَاسْتَمَعَ مُوسَى إِلَى نِصيحَةِ حَمِيهِ، وَنَفَّذَ كُلَّ مَا قَالَهُ لَهُ، ");
INSERT INTO arbnav_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","وَاخْتَارَ مُوسَى مِنْ بَيْنِ جَمِيعِ الإِسْرَائِيلِيِّينَ رِجَالاً مُقْتَدِرِينَ، وَأَقَامَهُمْ عَلَى الشَّعْبِ، رُؤَسَاءَ أُلُوفٍ وَمِئَاتٍ وَخَمَاسِينَ وَعَشَرَاتٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","فَكَانُوا يَقْضُونَ لِلشَّعْبِ فِي كُلِّ الدَعَاوَى الصَّغِيرَةِ. أَمَّا الْقَضَايَا الُمُسْتَعْصِيَةُ فَكَانُوا يَرْفَعُونَهَا إِلَى مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ثُمَّ شَيَّعَ مُوسَى حَمَاهُ، فَرَجَعَ هَذَا إِلَى أَرْضِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","وَفِي تَمَامِ الشَّهْرِ الثَّالِثِ مِنْ خُرُوجِ بَنِي إِسْرَائِيلَ مِنْ أَرْضِ مِصْرَ وَصَلُوا إِلَى بَرِّيَّةِ سِينَاءَ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","فَقَدِ ارْتَحَلَ الإِسْرَائِيلِيُّونَ مِنْ رَفِيدِيمَ إِلَى أَنْ جَاءُوا إِلَى بَرِّيَّةِ سِينَاءَ، فَنَزَلُوا مُقَابِلَ الْجَبَلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","فَصَعِدَ مُوسَى لِلْمُثُولِ أَمَامَ اللهِ. فَنَادَاهُ الرَّبُّ مِنَ الجَبَلِ: «هَكَذَا تَقُولُ لِآلِ يَعْقُوبَ، وَتُخْبِرُ شَعْبَ إِسْرَائِيلَ: ");
INSERT INTO arbnav_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","لَقَدْ عَايَنْتُمْ بِأَنْفُسِكُمْ مَا أَجْرَيْتُهُ عَلَى مِصْرَ، وَكَيْفَ حَمَلْتُكُمْ عَلَى أَجْنِحَةِ النُّسُورِ وَجِئْتُ بِكُمْ إِلَيَّ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","لِذَلِكَ إنْ أَطَعْتُمْ عَهْدِي، تَكُونُوا لِي مِلْكاً خَاصّاً مِنْ بَيْنِ جَمِيعِ الشُّعُوبِ، لأَنَّ لِي كُلَّ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","وَتَكُونُوا لِي مَمْلَكَةَ كَهَنَةٍ وَأُمَّةً مُقَدَّسَةً. هَذَا هُوَ الْكَلامُ الَّذِي تُخَاطِبُ بِهِ بَنِي إِسْرَائِيلَ». ");
INSERT INTO arbnav_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","فَاسْتَدْعَى مُوسَى شُيُوخَ الشَّعْبِ وَتَلا أَمَامَهُمْ جَمِيعَ هَذَا الْكَلامِ الَّذِي أَوْصَاهُ بِهِ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","فَقَالَ كُلُّ الشَّعْبِ مَعاً: «كُلُّ مَا نَطَقَ بِهِ الرَّبُّ نَعْمَلُ». فَحَمَلَ مُوسَى جَوَابَهُمْ إِلَى الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","فَقَالَ الرَّبُّ لِمُوسَى: «هَا أَنَا مُقْبِلٌ عَلَيْكَ فِي هَيْئَةِ سَحَابٍ مُظْلِمٍ، فَيَسْمَعُنِي الشَّعْبُ حِينَمَا أُخَاطِبُكَ، فَيَثِقُونَ أَيْضاً بِكَ دَائِماً». وَنَقَلَ مُوسَى إِلَى الرَّبِّ كَلامَ الشَّعْبِ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","وَقَالَ الرَّبُّ لِمُوسَى: «انْزِلْ إِلَى الشَّعْبِ وَقَدِّسْهُمُ الْيَوْمَ وَغَداً، وَدَعْهُمْ يَغْسِلُونَ ثِيَابَهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","لِيَكُونُوا مُتَأَهِّبِينَ لِلْيَوْمِ الثَّالِثِ، لأَنَّهُ فِي اليَوْمِ الثَّالِثِ أَنْزِلُ أَمَامَ جَمِيعِ الشَّعْبِ عَلَى جَبَلِ سِينَاءَ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","وَأَقِمْ حُدُوداً حَوْلَ الْجَبَلِ لَا يَتَخَطَّاهَا الشَّعْبُ. وَقُلْ لَهُمْ: حَذَارِ مِنْ أَنْ تَصْعَدُوا إِلَى الْجَبَلِ، أَوْ تَمَسُّوا طَرَفَهُ، فَكُلُّ مَنَ يَمَسُّ الْجَبَلَ حَتْماً يُقْتَلُ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","لَا تَمَسُّهُ يَدٌ، بَلْ يُرْجَمُ رَجْماً أَوْ يُرْمَى بِالسِّهَامِ، سَوَاءَ أَكَانَ بَهِيمَةً أَمْ إِنْسَاناً. لَا يُبْقَى عَلَيْهِ. أَمَّا عِنْدَمَا يَتَرَدَّدُ صَوْتُ بُوقٍ طَوِيلٍ، فَعِنْدَئِذٍ فَقَطْ يَصْعَدُونَ إِلَى الْجَبَلِ». ");
INSERT INTO arbnav_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","وَبَعْدَ أَنِ انْحَدَرَ مُوسَى مِنَ الْجَبَلِ إِلَى الشَّعْبِ قَدَّسَهُمْ وَغَسَلُوا ثِيَابَهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","وَقَالَ لِلشَّعْبِ: «كُونُوا مُتَأَهِّبِينَ لِلْيَوْمِ الثَّالِثِ، وَامْتَنِعُوا عَنْ مُعَاشَرَةِ نِسَائِكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","وَفِي صَبَاحِ الْيَوْمِ الثَّالِثِ حَدَثَتْ رُعُودٌ وَبُرُوقٌ، وَخَيَّمَ سَحَابٌ كَثِيفٌ عَلَى الْجَبَلِ، وَدَوَّى صَوْتُ بُوقٍ قَوِيٌّ جِدّاً، فَارْتَعَدَ كُلُّ الشَّعْبِ الَّذِي فِي المُخَيَّمِ، ");
INSERT INTO arbnav_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","فَأَخْرَجَ مُوسَى الشَّعْبَ مِنَ المُخَيَّمِ لِلِقَاءِ اللهِ، فَوَقَفُوا عِنْدَ سَفْحِ الجَبَلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","وَكَانَ جَبَلُ سِينَاءَ كُلُّهُ مُغَطَّى بِدُخَانٍ، لأَنَّ الرَّبَّ نَزَلَ عَلَيْهِ فِي هَيْئَةِ نَارٍ. وَتَصَاعَدَ دُخَانُهُ كَدُخَانِ الأَتُونِ، وَاهْتَزَّ الجَبَلُ كُلُّهُ بِعُنْفٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","وَازْدَادَ دَوِيُّ الْبُوقِ أَكْثَرَ فِيمَا كَانَ مُوسَى يَتَكَلَّمُ، وَالرَّبُّ يُجِيبُهُ بِرَعْدٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","وَنَزَلَ الرَّبُّ عَلَى قِمَّةِ جَبَلِ سِينَاءَ، وَنَادَى مُوسَى لِيَصْعَدَ إِلَى قِمَّةِ الجَبَلِ، فَصَعِدَ إِلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","فَقَالَ لَهُ الرَّبُّ: «انْزِلْ وَحَذِّرِ الشَّعْبَ لِئَلّا يَقْتَحِمُوا الجَبَلَ لِيَرَونِي فَيَهْلِكَ مِنْهُمْ كَثِيرُونَ. ");
INSERT INTO arbnav_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","وَلْيَتَقَدَّسْ أَيْضاً الْكَهَنَةُ الَّذِينَ يَقْتَرِبُونَ إِلَيَّ لِئَلّا أَبْطُشَ بِهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","فَقَالَ مُوسَى لِلرَّبِّ: «لا يَقْدِرُ الشَّعْبُ أَنْ يَصْعَدَ إِلَى جَبَلِ سِينَاءَ، لأَنَّكَ أَنْتَ قَدْ حَذَّرْتَنَا قَائِلاً: أَقِمْ حُدُوداً حَوْلَ الجَبَلِ وَقَدِّسْهُ». ");
INSERT INTO arbnav_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","فَأَجَابَ الرَّبُّ: «انْزِلْ وَاصْعَدْ بِأَخِيكَ هَرُونَ مَعَكَ، أَمَّا الكَهَنَةُ وَالشَّعْبُ فَلا يَقْتَحِمُوا طَرِيقَهُمْ لِيَصْعَدُوا إِلَيَّ لِئَلّا أَبْطُشَ بِهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","فَانْحَدَرَ مُوسَى إِلَى الشَّعْبِ وَأَنْذَرَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ثُمَّ نَطَقَ اللهُ بِجَمِيعِ هَذِهِ الأَقْوَالِ: ");
INSERT INTO arbnav_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«أَنَا هُوَ الرَّبُّ إِلَهُكَ الَّذِي أَخْرَجَكَ مِنْ أَرْضِ مِصْرَ دِيَارِ عُبُودِيَّتِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","لَا يَكُنْ لَكَ آلِهَةٌ أُخْرَى سِوَايَ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","لَا تَنْحَتْ لَكَ تِمْثَالاً، وَلا تَصْنَعْ صُورَةً مَّا مِمَّا فِي السَّمَاءِ مِنْ فَوْقُ، وَمَا فِي الأَرْضِ مِنْ تَحْتُ، وَمَا فِي الْمَاءِ مِنْ أَسْفَلِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","لَا تَسْجُدْ لَهُنَّ وَلا تَعْبُدْهُنَّ، لأَنِّي أَنَا الرَّبَّ إِلَهَكَ، إِلَهٌ غَيُورٌ، أَفْتَقِدُ آثَامَ الآبَاءِ فِي البَنِينَ حَتَّى الْجِيلِ الثَّالِثِ وَالرَّابِعِ مِنْ مُبْغِضِيَّ، ");
INSERT INTO arbnav_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","وَأَبْدِي إحْسَاناً نَحْوَ أُلُوفٍ مِنْ مُحِبِّيَّ الَّذِينَ يُطِيعُونَ وَصَايَايَ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","لَا تَنْطِقْ بِاسْمِ الرَّبِّ إِلَهِكَ بَاطِلاً، لأَنَّ الرَّبَّ يُعَاقِبُ مَنْ نَطَقَ بِاسْمِهِ بَاطِلاً. ");
INSERT INTO arbnav_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","اذْكُرْ يَوْمَ السَّبْتِ لِتُقَدِّسَهُ، ");
INSERT INTO arbnav_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","سِتَّةَ أَيَّامٍ تَعْمَلُ وَتَقُومُ بِجَمِيعِ مَشَاغِلِكَ، ");
INSERT INTO arbnav_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","أَمَّا الْيَوْمُ السَّابِعُ فَتَجْعَلُهُ سَبْتاً لِلرَّبِّ إِلَهِكَ، فَلا تَقُمْ فِيهِ بِأَيِّ عَمَلٍ أَنْتَ أَوِ ابْنُكَ أَوْ ابْنَتُكَ أَوِ عَبْدُكَ أَوْ أَمَتُكَ أَوْ بَهِيمَتُكَ أَوِ النَّزِيلُ الْمُقِيمُ دَاخِلَ أَبْوَابِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","لأَنَّ الرَّبَّ قَدْ صَنَعَ السَّمَاءَ وَالأَرْضَ وَالْبَحْرَ وَكُلَّ مَا فِيهَا فِي سِتَّةِ أَيَّامٍ، ثُمَّ اسْتَراحَ فِي الْيَوْمِ الْسَّابِعِ. لِهَذَا بَارَكَ الرَّبُّ يَوْمَ السَّبْتِ وَجَعَلَهُ مُقَدَّساً. ");
INSERT INTO arbnav_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","أَكْرِمْ أَبَاكَ وَأُمَّكَ لِكَيْ يَطُولَ عُمْرُكَ فِي الأَرْضِ الَّتِي يَهَبُكَ إِيَّاهَا الرَّبُّ إِلَهُكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","لَا تَقْتُلْ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","لَا تَزْنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","لَا تَسْرِقْ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","لَا تَشْهَدْ زُوراً عَلَى جَارِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","لَا تَشْتَهِ بَيْتَ جَارِكَ، وَلا زَوْجَتَهُ، وَلا عَبْدَهُ، وَلا أَمَتَهُ، وَلا ثَوْرَهُ، وَلا حِمَارَهُ، وَلا شَيْئاً مِمَّا لَهُ». ");
INSERT INTO arbnav_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","وَعِنْدَمَا عَايَنَ الشَّعْبُ كُلُّهُ الرُّعُودَ وَالْبُرُوقَ، وَسَمِعُوا دَوِيَّ صَوْتِ الْبُوقِ، وَرَأَوْا الجَبَلَ يُدَخِّنُ ارْتَجَفُوا خَوْفاً وَوَقَفُوا مِنْ بَعِيدٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","وَقَالُوا لِمُوسَى: «كَلِّمْنَا أَنْتَ بِنَفْسِكَ فَنَسْمَعَ، لِئَلّا نَمُوتَ إذَا ظَلَّ اللهُ يُخَاطِبُنَا». ");
INSERT INTO arbnav_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","فَأَجَابَ مُوسَى: «لا تَخَافُوا. إِنَّمَا الرَّبُّ قَدْ جَاءَ لِيَمْتَحِنَكُمْ حَتَّى تَظَلَّ مَخَافَةُ الرَّبِّ تُلازِمُكُمْ فَلا تُخْطِئُوا». ");
INSERT INTO arbnav_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","وَبَيْنَمَا كَانَ الشَّعْبُ وَاقِفاً مِنْ بَعِيدٍ، اقْتَرَبَ مُوسَى مِنَ الظَّلامِ المُتَكَاثِفِ حَيْثُ كَانَ اللهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","فَقَالَ الرَّبُّ لِمُوسَى: «تَقُولُ لِبَنِي إِسْرَائِيلَ: أَنْتُمْ رَأَيْتُمْ بِأَنْفُسِكُمْ كَيْفَ كَلَّمْتُكُمْ مِنَ السَّمَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","فَامْتَنِعُوا عَنْ صُنْعِ آلِهَةِ فِضَّةٍ أَوْ آلِهَةِ ذَهَبٍ لَكُمْ لِتُشْرِكُوهَا مَعِي. ");
INSERT INTO arbnav_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","أَقِمْ لِي مَذْبَحاً مِنْ تُرَابٍ تُقَدِّمُ عَلَيْهِ مُحْرَقَاتِكَ وَقَرَابِينَ سَلامَتِكَ مِنْ غَنَمِكَ وَبَقَرِكَ. وَآتِي إِلَيْكَ وَأُبَارِكُكَ فِي جَمِيعِ الأَمَاكِنِ الَّتِي أُقِيمُ فِيهَا لاِسْمِي ذِكْراً. ");
INSERT INTO arbnav_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","وَإِنْ بَنَيْتَ لِي مَذْبَحاً مِنْ حِجَارَةٍ، فَلا تَبْنِهِ مِنْ حِجَارَةٍ مَنْحُوتَةٍ، لأَنَّ اسْتِعْمَالَكَ لِلإِزْمِيلِ يُدَنِّسُهَا ");
INSERT INTO arbnav_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","وَلا تَرْتَقِ إِلَى مَذْبَحِي بِدَرَجٍ لِئَلّا تَنْكَشِفَ عَوْرَتُكَ عَلَيْهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","وَهَذِهِ هِي الأَحْكَامُ الَّتِي تَضَعُهَا أَمَامَهُمْ: ");
INSERT INTO arbnav_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","إنِ اشْتَرَيْتَ عَبْداً عِبْرَانِيًّا فَلْيَخْدُمْكَ سِتَّ سَنَوَاتٍ، وَفِي السَّنَةِ السَّابِعَةِ تُطْلِقُهُ حُرّاً مَجَّاناً ");
INSERT INTO arbnav_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","وَإذَا اشْتَرَيْتَهُ وَهُوَ أَعْزَبُ يُطْلَقُ وَحْدَهُ. وَإِنِ اشْتَرَيْتَهُ وَهُوَ بَعْلُ امْرَأَةٍ، تُطْلَقُ زَوْجَتُهُ مَعَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","وَإِنْ وَهَبَهُ مَوْلاهُ زَوْجَةً وَأَنْجَبَتْ لَهُ بَنِينَ وَبَنَاتٍ، فَإِنَّ زَوْجَتَهُ وَأَوْلادَهَا يَكُونُونَ مِلْكاً لِسَيِّدِهِ، وَهُوَ يُطْلَقُ وَحْدَهُ حُرّاً. ");
INSERT INTO arbnav_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","لَكِنْ إِنْ قَالَ الْعَبْدُ: «أُحِبُّ مَوْلايَ وَزَوْجَتِي وَأَوْلادِي، وَلا أُرِيدُ أَنْ أَخْرُجَ حُرّاً. ");
INSERT INTO arbnav_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","يَأْخُذُهُ سَيِّدُهُ إِلَى قُضَاةِ الْمَدِينَةِ، ثُمَّ يُقِيمُهُ لِصْقَ الْبَابِ أَوْ قَائِمَتِهِ، وَيَثْقُبُ أُذُنَهُ بِمِخْرَزٍ، فَيُصْبِحُ خَادِماً لَهُ مَدَى الْحَيَاةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","وَلَكِنْ إِذَا بَاعَ رَجُلٌ ابْنَتَهُ كَأَمَةٍ، فَإِنَّهَا لَا تُطْلَقُ حُرَّةً كَمَا يُطْلَقُ الْعَبْدُ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","فَإِذَا لَمْ تَرُقْ لِمَوْلاهَا الَّذِي خَطَبَهَا لِنَفْسِهِ، يَسْمَحُ بِافْتِدَائِهَا، وَلا يَحِقُّ لَهُ أَنْ يَبِيعَهَا لِقَوْمٍ أَجَانِبَ لأَنَّهُ غَدَرَ بِها فَلَمْ يَتَزَوَّجْهَا ");
INSERT INTO arbnav_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","وَإِنْ خَطَبَهَا لاِبْنِهِ فَإِنَّهُ يُعَامِلُهَا كَابْنَةٍ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","أَمَّا إِذَا أَعْجَبَتْهُ وَتَزَوَّجَهَا، ثُمَّ عَادَ فَتَزَوَّجَ مِنْ أُخْرَى، فَإِنَّهُ لَا يُنَقِّصُ شَيْئاً مِنْ طَعَامِهَا وَكُسْوَتِهَا وَمُعَاشَرَتِهَا، ");
INSERT INTO arbnav_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","فَإِذَا قَصَّرَ فِي وَاحِدٍ مِنْ هَذِهِ الأَشْيَاءِ الثَّلاثَةِ، عَلَيْهِ أَنْ يُطْلِقَهَا حُرَّةً مَجَّاناً. ");
INSERT INTO arbnav_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","مَنْ ضَرَبَ إنْسَاناً وَقَتَلَهُ، فَالضَّارِبُ حَتْماً يَمُوتُ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","وَلَكِنْ إِنْ لَمْ يَتَعَمَّدِ الضَّارِبُ ذَلِكَ، بَلْ حَدَثَ الأَمْرُ بِقَضَاءِ اللهِ فَإِنِّي سَأُعَيِّنُ لَهُ مَكَاناً يَلْجَأُ إِلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","وَلَكِنْ إِذَا تَآمَرَ أَحَدٌ عَلَى آخَرَ وَتَعَمَّدَ قَتْلَهُ، فَسُقْهُ لِلْمَوْتِ حَتَّى وَلَوِ احْتَمَى بِمَذْبَحِي ");
INSERT INTO arbnav_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","كُلُّ مَنْ يَضْرِبْ أَبَاهُ أَوْ أُمَّهُ، يُقْتَلْ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","مَنْ يَخْطِفْ إِنْسَاناً وَيَبِعْهُ أَوْ يَسْتَرِقَّهُ عِنْدَهُ حَتْماً يَمُتْ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","مَنْ يَشْتِمْ أَبَاهُ أَوْ أُمَّهُ يُقْتَلْ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","إِذَا تَعَارَكَ رَجُلانِ فَضَرَبَ أَحَدُهُمَا الآخَرَ بِحَجَرٍ أَوْ لَكَمَهُ مِنْ غَيْرِ أَنْ يُمِيتَهُ بَلْ أَلْزَمَهُ الْفِرَاشَ، ");
INSERT INTO arbnav_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ثُمَّ قَامَ مُتَمَشِّياً مُتَوَكِّئاً عَلَى عُكَّازِهِ، يُبَرَّأُ الضَّارِبُ، إلّا أَنَّ عَلَيْهِ أَنْ يَدْفَعَ لِلْمَضْرُوبِ تَعْوِيضاً عَنْ مُدَّةِ تَعَطُّلِهِ، وَيَتَحَمَّلَ نَفَقَاتِ عِلاجِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","إنْ ضَرَبَ أَحَدٌ عَبْدَهُ أَوْ أَمَتَهُ بِالْعَصَا ضَرْباً أَفْضَى إِلَى الْمَوْتِ، يُعَاقَبُ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","لَكِنْ إِنْ بَقِيَ حَيًّا يَوْماً أَوْ يَوْمَيْنِ، لَا يُعَاقَبُ الضَّارِبُ، لأَنَّ العَبْدَ مِلْكُهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","إِنْ تَضَارَبَ رِجَالٌ وَصَدَمُوا امْرَأَةً حَامِلاً فَأَجْهَضَتْ مِنْ غَيْرِ أَنْ تَتَأَذَّى، يَدْفَعُ الصَّادِمُ غَرَامَةً بِمُقْتَضَى مَا يُطَالِبُ بِهِ الزَّوْجُ وَوَفْقاً لِقَرَارِ الْقُضَاةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","أَمَّا إِذَا تَأَذَّتِ الْمَرْأَةُ، تَأْخُذُ نَفْساً بِنَفْسٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","وَعَيْناً بِعَيْنٍ، وَسِنّاً بِسِنٍّ، وَيَداً بِيَدٍ، وَرِجْلاً بِرِجْلٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","وَكَيًّا بِكَيٍّ، وَجُرْحاً بِجُرْحٍ، وَرَضّاً بِرَضٍّ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","وَإذَا ضَرَبَ أَحَدٌ عَبْدَهُ أَوْ أَمَتَهُ، فَأَتْلَفَ عَيْنَهُ، فَإِنَّهُ يُطْلِقُهُ حُرّاً تَعْوِيضاً لَهُ عَنْ عَيْنِهِ ");
INSERT INTO arbnav_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","وَإذَا ضَرَبَ أَحَدٌ عَبْدَهُ أَوْ أَمَتَهُ، فَأَسْقَطَ سِنَّهُ، فَإِنَّهُ يُطْلِقُهُ حُرّاً تَعْوِيضاً عَنْ سِنِّهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","إِذَا نَطَحَ ثَوْرٌ رَجُلاً أَوِ امْرَأَةً فَمَاتَ، يُرْجَمُ الثَّوْرُ حَتَّى الْمَوْتِ وَلا تَأْكُلُونَ لَحْمَهُ، وَيَكُونُ صَاحِبُ الثَّوْرِ بَرِيئاً. ");
INSERT INTO arbnav_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","أَمَّا إِنْ كَانَ الثَّوْرُ نَطَّاحاً مِنْ قَبْلُ، وَسَبَقَ إِنْذَارُ صَاحِبِهِ، فَلَمْ يَكْبَحْهُ، فَقَتَلَ رَجُلاً أَوِ امْرَأَةً، يُرْجَمُ الثَّوْرُ، وَيُقْتَلُ صَاحِبُهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","إلّا إِذَا طُولِبَ بِدَفْعِ الدِّيَّةِ، فَيَدْفَعُ آنَئِذٍ فِدَاءَ نَفْسِهِ مَا هُوَ مَتَوَجِّبٌ عَلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","وَإذَا نَطَحَ ابْناً أَوِ ابْنَةً، يُنَفَّذُ فِيهِ هَذَا الْحُكْمُ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","وَإذَا نَطَحَ الثَّوْرُ عَبْداً أَوْ أَمَةً، فَإِنَّ صَاحِبَهُ يَدْفَعُ ثَلاثِينَ قِطْعَةَ فِضَّةٍ تَعْوِيضاً لِمَوْلاهُ، وَيُرْجَمُ الثَّوْرُ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","إنْ كَشَفَ إِنْسَانٌ غِطَاءَ بِئْرِهِ، أَوْ حَفَرَ بِئْراً وَتَرَكَهَا مِنْ غَيْرِ غِطَاءٍ، فَوَقَعَ فِيهَا ثَوْرٌ أَوْ حِمَارٌ، ");
INSERT INTO arbnav_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","يَقُومُ صَاحِبُ الْبِئْرِ بِدَفْعِ تَعْوِيضٍ عَنِ الْخَسَارَةِ تُضَاهِي ثَمَنَهُ، وَيَكُونُ الْمَيْتُ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","وَإذَا نَطَحَ ثَوْرُ إِنْسَانٍ ثَوْرَ صَاحِبٍ لَهُ فَمَاتَ الثَّوْرُ، فَإِنَّهُمَا يَبِيعَانِ الثَّوْرَ الْحَيَّ وَيَقْتَسِمَانِ ثَمَنَهُ، وَكَذَلِكَ يَقْتَسِمَانِ الثَّوْرَ الْمَيْتَ. ");
INSERT INTO arbnav_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","وَأَمَّا إِذَا كَانَ مَعْرُوفاً مِنْ قَبْلُ، أَنَّ الثَّوْرَ نَطَّاحٌ وَلَمْ يَكْبَحْهُ صَاحِبُهُ، فَإِنَّهُ يُعَوِّضُ ثَوْراً بِثَوْرٍ، وَيَكُونُ الثَّوْرُ الْمَيْتُ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","وَإذَا سَرَقَ إِنْسَانٌ ثَوْراً أَوْ خَرُوفاً وَذَبَحَهُ أَوْ بَاعَهُ، فَعَلَيْهِ أَنْ يُعَوِّضَ صَاحِبَ الثَّوْرِ بِخَمْسَةِ ثِيرَانٍ، وَصَاحِبَ الْخَرُوفِ بِأَرْبَعَةٍ مِنَ الْغَنَمِ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","إِذَا ضُبِطَ السَّارِقُ وَهُوَ يَنْقُبُ لَيْلاً وَضُرِبَ فَمَاتَ، يَذْهَبُ دَمُهُ هَدْراً. ");
INSERT INTO arbnav_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","وَلَكِنْ إِنْ ضُبِطَ بَعْدَ شُرُوقِ الشَّمْسِ وَهُوَ يَنْقُبُ وَضُرِبَ حَتَّى قُتِلَ، يَكُونُ الضَّارِبُ مُطَالَباً بِدَمِهِ. عَلَى اللِّصِّ أَنْ يَدْفَعَ تَعْوِيضاً. إِنْ كَانَ مُعْدَماً، يُبَاعُ بِسَرِقَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","وَإذَا وُجِدَ الْحَيَوَانُ الْمَسْرُوقُ حَيًّا فِي حَوْزَتِهِ، ثَوْراً كَانَ أَمْ حِمَاراً أَمْ خَرُوفاً، يُعَوِّضُ السَّارِقُ بِمِثْلَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","إِذَا سَرَّحَ إِنْسَانٌ بَهَائِمَهُ لِتَرْعَى فِي حَقْلِ جَارِهِ أَوِ كَرْمِهِ، فَعَلَيْهِ أَنْ يُعَوِّضَ صَاحِبَ الْحَقْلِ أَوِ الْكَرْمِ مِنْ أَجْوَدِ نِتَاجِ حَقْلِهِ أَوْ كَرْمِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","إذَا انْدَلَعَتْ نَارٌ وَامْتَدَّتْ مِنَ الشَّوْكِ إِلَى أَكْدَاسِ الْقَمْحِ أَوِ السَّنَابِلِ النَّامِيَةِ أَوْ مَزْرُوعَاتِ الْحُقُولِ، فَعَلَى مَنْ أَوْقَدَ النَّارَ أَنْ يُعَوِّضَ الْخَسَارَةَ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","إذَا أَوْدَعَ إِنْسَانٌ صَاحِبَهُ فِضَّةً أَوْ أَمْتِعَةً أَمَانَةً، ثُمَّ سُرِقَتْ مِنْ بَيْتِ صَاحِبِهِ، فَعَلَى السَّارِقِ إِذَا اكْتُشِفَ أَمْرُهُ أَنْ يَدْفَعَ ضِعْفَيْ قِيمَةِ الْمَسْرُوقِ كَتَعْوِيضٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","وَلَكِنْ إِذَا لَمْ يُقْبَضْ عَلَى اللِّصِّ، يَمْثُلُ صَاحِبُ الْبَيْتِ أَمَامَ الْقُضَاةِ لِيُقَرِّرُوا إنْ كَانَ هُوَ الَّذِي امْتَدَّتْ يَدُهُ إِلَى أَمْتِعَةِ صَاحِبِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","فِي كُلِّ قَضِيَّةِ حِيَازَةٍ غَيْرِ شَرْعِيَّةٍ سَوَاءَ أَكَانَتْ مُتَعَلِّقَةً بِثَوْبٍ أَمْ حِمَارٍ أَمْ خَرُوفٍ أَمْ ثَوْرٍ أَمْ أَيِّ شَيْءٍ مَفْقُودٍ، يَدَّعِي شَخْصٌ مَا أَنَّهُ يمْلِكُهُ، يَمْثُلُ الطَّرَفَانِ الْمُتَنَازِعَانِ أَمَامَ الْقُضَاةِ، وَمَنْ يَحْكُمُ عَلَيْهِ الْقُضَاةُ بِالذَّنْبِ يُعَوِّضُ صَاحِبَهُ بِمِثْلَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","إِذَا أَوْدَعَ إِنْسَانٌ ثَوْراً أَوْ حِمَاراً أَوْ بَهِيمَةً أَمَانَةً، فَمَاتَ أَوْ تَأَذَّى أَوْ سُرِقَ فِي غَفْلَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","يَحْلِفُ صَاحِبُ الْبَيْتِ بِالرَّبِّ أَنَّهُ لَمْ يَمُدَّ يَدَهُ إِلَى مِلْكِ جَارِهِ، فَيَقْبَلُ مِنْهُ صَاحِبُهُ الْيَمِينَ وَلا يَأْخُذُ تَعْوِيضاً. ");
INSERT INTO arbnav_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","وَلَكِنْ إِنْ سُرِقَ مِنْهُ بِفِعْلِ الْإِهْمَالِ فَعَلَيْهِ أَنْ يُعَوِّضَ صَاحِبَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","أَمَّا إِذَا افْتُرِسَ فَعَلَيْهِ أَنْ يَأْتِيَ بِأَشْلائِهِ شَهَادَةً عَلَى ذَلِكَ، وَلا يُطَالَبُ بِالتَّعْوِيضِ عَنِ الْحَيَوَانِ الْمُفْتَرَسِ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","إِذَا اسْتَعَارَ إِنْسَانٌ مِنْ صَاحِبِهِ شَيْئاً فَانْكَسَرَ أَوْ مَاتَ فِي غِيَابِ صَاحِبِهِ، يَدْفَعُ المُسْتَعِيرُ تَعْوِيضاً. ");
INSERT INTO arbnav_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","لَكِنْ إِنْ كَانَ صَاحِبُ الْحَيَوَانِ حَاضِراً، فَلا يَدْفَعُ الْمُسْتَعِيرُ تَعْوِيضاً. أَمَّا إِذَا كَانَ الْحَيَوَانُ أَوِ الشَّيْءُ مُسْتَأْجَراً، فَتُغَطِّي الأُجْرَةُ الْمَدْفُوعَةُ قِيمَةَ الْخَسَارَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","إِذَا رَاوَدَ رَجُلٌ عَذْرَاءَ غَيْرَ مَخْطُوبَةٍ، وَعَاشَرَهَا، يَدْفَعُ مَهْرَهَا وَيَتَزَوَّجُهَا، ");
INSERT INTO arbnav_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","وَإِنْ أَبَى وَالِدُهَا قَطْعِيًّا أَنْ يُزَوِّجَهَا مِنْهُ، يَتَحَتَّمْ عَلَيْهِ أَيْضاً أَنْ يَدْفَعَ لَهُ مَهْرَ العَذَارَى. ");
INSERT INTO arbnav_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","لَا تَدَعْ سَاحِرَةً تَعِيشُ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","كُلُّ مَنْ ضَاجَعَ بَهِيمَةً حَتْماً يُقْتَلُ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","مَنْ يُقَرِّبْ ذَبَائِحَ لِآلِهَةٍ غَيْرِ الرَّبِّ وَحْدَهُ، يُبَدْ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","لَا تَضْطَهِدْ غَرِيباً وَلا تُضَايِقْهُ، فَقَدْ كُنْتُمْ غُرَبَاءَ فِي دِيَارِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","لَا تُسِئْ إِلَى أَرْمَلَةٍ أَوْ يَتِيمٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","لأَنَّكَ إِنْ أَسَأْتَ إِلَيْهِمَا وَصَرَخَا إِلَيَّ أَسْمَعْ صُرَاخَهُمَا، ");
INSERT INTO arbnav_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","فَيَحْتَدِمُ غَضَبِي وَأَقْتُلُكُمْ بِالسَّيْفِ، فَتُصْبِحُ زَوْجَاتُكُمْ أَرَامِلَ وَأَوْلادُكُمْ يَتَامَى. ");
INSERT INTO arbnav_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","إِنْ أَقْرَضْتَ فَقِيراً مِنْ شَعْبِيَ الْمُقِيمِ عِنْدَكَ فَلا تُعَامِلْهُ كَالْمُرَابيِ، وَلا تَتَقَاضَ مِنْهُ فَائِدَةً. ");
INSERT INTO arbnav_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","إِذَا اسْتَرْهَنْتَ ثَوْبَ صَاحِبِكَ لِقَاءَ دَيْنٍ، فَرُدَّهُ إِلَيْهِ عِنْدَ مَغِيبِ الشَّمْسِ، ");
INSERT INTO arbnav_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","لأَنَّ ذَلِكَ الثَّوْبَ هُوَ ثَوْبُهُ الَّذِي يَقِي بِهِ بَدَنَهُ، وَإلَّا فَبِأَيِّ شَيْءٍ يَنَامُ؟ إِذَا صَرَخَ إِلَيَّ أَسْمَعُهُ لأَنِّي رَحِيمٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","لَا تَشْتِمِ الْقُضَاةَ وَلا تَلْعَنْ رُؤَسَاءَ شَعْبِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","لَا تُؤَخِّرْ تَقْدِيمَ بَاكُورَةِ مَحْصُولِ بَيْدَرِكَ وَمَعْصَرَتِكَ، وَأَعْطِنِي أَبْكَارَ بَنِيكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","وَكَذَلِكَ تَفْعَلُ بِبَقَرِكَ وَغَنَمِكَ. سَبْعَةَ أَيَّامٍ تُبْقِي الْبِكْرَ مَعَ أُمِّهِ، وَفِي يَوْمِهِ الثَّامِنِ تُقَدِّمُهُ لِي. ");
INSERT INTO arbnav_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","وَتَكُونُونَ لِي شَعْباً مُقَدَّساً. لَا تَأْكُلُوا لَحْمَ فَرِيسَةٍ فِي الصَّحْرَاءِ، بَلِ اطْرَحُوهُ طَعَاماً لِلْكِلابِ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","لَا تَنْقُلْ أَخْبَاراً كَاذِبَةً، وَلا تَتَعَاوَنْ مَعَ المُنَافِقِ فِي شَهَادَةِ زُورٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","لَا تَتْبَعِ الأَغْلَبِيَّةَ لاِرْتِكَابِ الشَّرِّ، وَلا تُحَرِّفْ شَهَادَتَكَ فِي دَعْوَى انْجِرَافاً مَعَ الأَكْثَرِيَّةِ، ");
INSERT INTO arbnav_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","وَلا تَتَحَيَّزْ لِلْفَقِيرِ فِي دَعْوَاهُ لِمُجَرَّدِ كَوْنِهِ فَقِيراً فَقَطْ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","إِذَا صَادَفْتَ ثَوْرَ عَدُوِّكَ أَوْ حِمَارَهُ شَارِداً، فَرُدَّهُ إِلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","وَإذَا عَايَنْتَ حِمَارَ مُبْغِضِكَ وَاقِعاً تَحْتَ حِمْلِهِ، فَلا تَتَجَاوَزْهُ حَتَّى تُسْعِفَ عَدُوَّكَ فِي حَلِّ ثِقْلِ حِمَارِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","لَا تَتَهَاوَنْ فِي حَقِّ فَقِيرِكَ فِي دَعْوَاهُ لِكَوْنِهِ فَقِيراً. ");
INSERT INTO arbnav_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","اجْتَنِبْ الاتِّهَامَ الْكَاذِبَ وَلا تَقْتُلِ الْبَرِيءَ وَالصَّالِحَ، لأَنَّنِي لَا أُبْرِىءُ المُذْنِبَ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","لَا تَقْبَلْ رِشْوَةً لأَنَّ الرِّشْوَةَ تُعْمِي الْمُبْصِرِينَ وَتُحَرِّفُ أَقْوَالَ الصَّالِحِينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","لَا تُضَايِقْ غَرِيباً لأَنَّكُمْ تَعْلَمُونَ مَشَاعِرَ الغَرِيبِ، فَقَدْ كُنْتُمْ غُرَبَاءَ فِي دِيَارِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ازْرَعْ أَرْضَكَ وَاحْصُدْ غَلَّتَهَا سِتَّ سِنِينَ، ");
INSERT INTO arbnav_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ثُمَّ أَرِحْهَا فِي السَّنَةِ السَّابِعَةِ وَاتْرُكْهَا لِيَأْكُلَ مِنْهَا فُقَرَاءُ شَعْبِكَ. وَمَا فَضَلَ عَنْهُمْ تَقْتَاتُهُ وُحُوشُ الْبَرِّيَّةِ. وَهَكَذَا تَفْعَلُ أَيْضاً بِكَرْمِكَ وَزَيْتُونِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","اعْمَلْ سِتَّةَ أَيَّامٍ فَقَطْ، وَفِي الْيَوْمِ السَّابِعِ تَسْتَرِيحُ لِكَيْ يَسْتَرِيحَ أَيْضاً ثَوْرُكَ وَحِمَارُكَ، وَيَنْتَعِشَ ابْنُ أَمَتِكَ وَالغَرِيبُ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","أَطِيعُوا كُلَّ مَا أَوْصَيْتُكُمْ بِهِ، وَلا تَذْكُرُوا اسْمَ آلِهَةٍ أُخْرَى، وَلا يَتَلَفَّظْ بِهِ فَمُكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","ثَلاثَ مَرَّاتٍ تَحْتَفِلُ لِي فِي السَّنَةِ: ");
INSERT INTO arbnav_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","تَحْتَفِلُ بِعِيدِ الْفَطِيرِ فَتَأْكُلُ كَمَا أَمَرْتُكَ فَطِيراً، مُدَّةَ سَبْعَةِ أَيَّامٍ، فِي الْوَقْتِ الْمُعَيَّنِ مِنْ شَهْرِ أَبِيبَ (أَيْ شَهْرِ آذَارَ – مَارِسَ)، لأَنَّهُ فِيهِ خَرَجْتَ مِنْ مِصْرَ. وَلا يَمْثُلُ أَحَدٌ أَمَامِي بِيَدَيْنِ فَارِغَتَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","وَتَحْتَفِلُ أَيْضاً بِعِيدِ الْحَصَادِ، حَيْثُ تُقَدِّمُ بَاكُورَةَ غَلّاتِكَ الَّتِي زَرَعْتَهَا فِي الْحَقْلِ، ثُمَّ عِيدِ الْجَمْعِ فِي نِهَايَةِ مَوْسِمِ الْحَصَادِ عِنْدَمَا تَجْمَعُ غَلّاتِكَ مِنَ الْحَقْلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ثَلاثَ مَرَّاتٍ يَمْثُلُ جَمِيعُ الرِّجَالِ أَمَامَ السَّيِّدِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","لَا تُقَرِّبْ لِي دَمَ ذَبِيحَةٍ مَعَ خُبْزٍ مُخْتَمِرٍ، وَلا يَبِتْ شَحْمُ ذَبَائِحِ عِيدِي إِلَى صَبَاحِ الْغَدِ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","أَحْضِرْ أَجْوَدَ بَاكُورَةِ أَرْضِكَ إِلَى بَيْتِ إِلَهِكَ. وَلا تَطْبُخْ جَدْياً فِي لَبَنِ أُمِّهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","هَا أَنَا مُرْسِلٌ مَلاكِي أَمَامَكَ لِيَحْرُسَكَ طَوَالَ الطَّرِيقِ، وَيَقُودَكَ إِلَى الأَرْضِ الَّتِي أَعْدَدْتُهَا لَكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","فَأصْغِ إِلَيْهِ وَامْتَثِلْ لَهُ وَلا تَعْصَهُ لأَنَّهُ لَا يَصْفَحُ عَنْ ذُنُوبِكُمْ إِذْ أَنَّ اسْمِي فِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","إِنْ حَرِصْتَ عَلَى الاسْتِمَاعِ إِلَى أَقْوَالِهِ وَفَعَلْتَ كُلَّ مَا قُلْتُهُ، أُعَادِي مَنْ يُعَادِيكَ، وَأُقَاوِمُ مُقَاوِمِيكَ، ");
INSERT INTO arbnav_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","إِذْ يَسِيرُ مَلاكِي أَمَامَكَ حَتَّى يُدْخِلَكَ بِلادَ الأَمُورِيِّينَ وَالْحِثِّيِّينَ وَالْفَرِزِّيِّينَ وَالْكَنْعَانِيِّينَ وَالْحِوِّيِّينَ وَالْيَبُوسِيِّينَ الَّذِينَ أُبِيدُهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","إِيَّاكَ أَنْ تَسْجُدَ لِآلِهَتِهِمْ، وَلا تَعْبُدْهَا، وَلا تَعْمَلْ أَعْمَالَهُمْ، بَلْ تُبِيدُهُمْ وَتُحَطِّمُ أَصْنَامَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","إِنَّمَا تَعْبُدُونَنِي أَنَا الرَّبَّ إِلَهَكُمْ فَأُبَارِكُ طَعَامَكَ وَشَرَابَكَ وَأُزِيلُ الأَمْرَاضَ مِنْ بَيْنِكُمْ ");
INSERT INTO arbnav_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","فَلا تَكُونُ مُجْهِضَةٌ وَلا عَاقِرٌ فِي أَرْضِكَ. وَأُمَتِّعُكَ بِكَامِلِ عُمْرِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","وَأَجْعَلُ هَيْبَتِي تَتَقَدَّمُكَ، أُزْعِجُ كُلَّ أُمَّةٍ تَقِفُ فِي وَجْهِكَ، وَأَجْعَلُ أَعْدَاءَكَ يُوَلُّونَ الأَدْبَارَ أَمَامَكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","وَأَبْعَثُ الزَّنَابِيرَ أَمَامَكَ، فَتَطْرُدُ الْحِوِّيِّينَ وَالْكَنْعَانِيِّينَ وَالْحِثِّيِّينَ مِنْ قُدَّامِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","إِنَّمَا لَنْ أَطْرُدَهُمْ فِي سَنَةٍ وَاحِدَةٍ لِئَلّا تُقْفِرَ الأَرْضُ فَتَتَكَاثَرَ عَلَيْكَ وُحُوشُ الْبَرِّيَّةِ، ");
INSERT INTO arbnav_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","بَلْ أَطْرُدُهُمْ تَدْرِيجِيًّا مِنْ أَمَامِكَ رَيْثَمَا تَنْمُونَ وَتَرِثُونَ الْبِلادَ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","وَأَجْعَلُ تُخُومَكَ تَمْتَدُّ مِنَ الْبَحْرِ الأَحْمَرِ إِلَى سَاحِلِ فِلِسْطِينَ، وَمِنَ الْبَرِّيَّةِ حَتَّى نَهْرِ الْفُرَاتِ، وَأُخْضِعُ لَكَ سُكَّانَ الأَرْضِ فَتَطْرُدُهُمْ مِنْ أَمَامِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","لَا تَقْطَعْ مَعَهُمْ وَلا مَعْ آلِهَتِهِمْ عَهْداً، ");
INSERT INTO arbnav_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","وَلا تُسْكِنْهُمْ فِي أَرْضِكَ لِئَلّا يَجْعَلُوكَ تُخْطِئُ إِلَيَّ، لأَنَّكَ إنْ عَبَدْتَ آلِهَتَهُمْ، يَكُونُ ذَلِكَ لَكَ فَخّاً». ");
INSERT INTO arbnav_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: «اصْعَدْ إِلَيَّ أَنْتَ وَهَرُونُ وَنَادَابُ وَأَبِيهُو، وَسَبْعُونَ مِنْ شُيُوخِ إِسْرَائِيلَ وَلْيَسْجُدْ هَؤُلاءِ مِنْ بَعِيدٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","لَا يَقْتَرِبْ إِلَيَّ أَحَدٌ سِوَاكَ، أَمَّا الآخَرُونَ فَيَبْقُونَ بَعِيداً. وَحَذَارِ أَنْ يَصْعَدَ الشَّعْبُ مَعَكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","فَجَاءَ مُوسَى وَبَلَّغَ الشَّعْبَ بِكُلِّ كَلامِ الرَّبِّ وَأَحْكَامِهِ، فَأَجَابَ الشَّعْبُ بِصَوْتٍ وَاحِدٍ: «كُلُّ مَا أَمَرَنَا بِهِ الرَّبُّ نَفْعَلُ». ");
INSERT INTO arbnav_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","فَكَتَبَ مُوسَى جَمِيعَ أَقْوَالِ الرَّبِّ، ثُمَّ بَكَّرَ فِي الصَّبَاحِ وَشَيَّدَ مَذْبَحاً عَلَى سَفْحِ الجَبَلِ، وَنَصَبَ اثْنَيْ عَشَرَ عَمُوداً عَلَى عَدَدِ أَسْبَاطِ بَنِي إِسْرَائِيلَ الاثْنَيْ عَشَرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","وَأَرْسَلَ بَعْضَ شُبَّانِ بَنِي إِسْرَائِيلَ فَقَدَّمُوا مُحْرَقَاتٍ وَقَرَّبُوا ذَبَائِحَ سَلامَةٍ لِلرَّبِّ مِنَ الْعُجُولِ، ");
INSERT INTO arbnav_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","وَأَخَذَ مُوسَى نِصْفَ الدَّمِ وَاحْتَفَظَ بِهِ فِي طُسُوسٍ وَرَشَّ النِّصْفَ الْبَاقِي عَلَى الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","وَتَنَاوَلَ كِتَابَ الْعَهْدِ وَتَلاهُ عَلَى مَسَامِعِ الشَّعْبِ، فَقَالُوا: «كُلُّ مَا أَمَرَ بِهِ الرَّبُّ نَفْعَلُهُ وَنُطِيعُهُ». ");
INSERT INTO arbnav_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ثُمَّ أَخَذَ مُوسَى الدَّمَ الَّذِي فِي الطُّسُوسِ وَرَشَّهُ عَلَى الشَّعْبِ قَائِلاً: «هُوَذَا دَمُ الْعَهْدِ الَّذِي قَطَعَهُ الرَّبُّ مَعَكُمْ بِنَاءً عَلَى جَمِيعِ هَذِهِ الأَقْوَالِ». ");
INSERT INTO arbnav_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ثُمَّ صَعِدَ مُوسَى وَهَرُونُ وَنَادَابُ وَأَبِيهُو وَسَبْعُونَ مِنْ شُيُوخِ إِسْرَائِيلَ، ");
INSERT INTO arbnav_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","وَرَأَوْا إِلَهَ إِسْرَائِيلَ، وَتَحْتَ قَدَمَيْهِ أَرْضِيَّةٌ كَأَنَّهَا مَصْنُوعَةٌ مِنَ الْيَاقُوتِ الأَزْرَقِ الشَّفَّافِ تُمَاثِلُ السَّمَاءَ فِي النَّقَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","وَلَكِنَّ اللهَ لَمْ يَمُدَّ يَدَهُ لِيُهْلِكَ أَشْرَافَ بَنِي إِسْرَائِيلَ، فَرَأَوْا اللهَ وَأَكَلُوا وَشَرِبُوا. ");
INSERT INTO arbnav_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","وَقَالَ الرَّبُّ لِمُوسَى: «اصْعَدْ إِلَى الْجَبَلِ وَامْكُثْ هُنَاكَ لأُعْطِيَكَ الْوَصَايَا وَالشَّرَائِعَ الَّتِي كَتَبْتُهَا عَلَى لَوْحَيِ الْحَجَرِ لِتُلَقِّنَهَا لَهُمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","فَقَامَ مُوسَى وَأَخَذَ خَادِمَهُ يَشُوعَ وَصَعِدَ إِلَى جَبَلِ اللهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","وَقَالَ لِلشُّيُوخِ: «انْتَظِرُونَا هُنَا حَتَّى نَرْجِعَ إِلَيْكُمْ. وَهُوَذَا هَرُونُ وَحُورُ مَعَكُمْ، فَإِنْ كَانَ لأَحَدٍ دَعْوَى فَلْيَرْفَعْهَا إِلَيْهِمَا». ");
INSERT INTO arbnav_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","وَعِنْدَمَا صَعِدَ مُوسَى إِلَى الجَبَلِ، تَغَطَّى الجَبَلُ بِالسَّحَابِ، ");
INSERT INTO arbnav_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","وَحَلَّ مَجْدُ الرَّبِّ عَلَى جَبَلِ سِينَاءَ، وَغَطَّاهُ السَّحَابُ سِتَّةَ أَيَّامٍ. وَفِي الْيَوْمِ السَّابِعِ دَعَا الرَّبُّ مُوسَى مِنْ وَسَطِ السَّحَابِ. ");
INSERT INTO arbnav_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","وَبَدَا مَجْدُ الرَّبِّ لِعُيُونِ بَنِي إِسْرَائِيلَ كَنَارٍ آكِلَةٍ عَلَى قِمَّةِ الجَبَلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","وَاخْتَفَى مُوسَى فِي وَسَطِ السَّحَابِ وَصَعِدَ إِلَى الجَبَلِ حَيْثُ مَكَثَ هُنَاكَ أَرْبَعِينَ نَهَاراً وَأَرْبَعِينَ لَيْلَةً. ");
INSERT INTO arbnav_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","وَخَاطَبَ الرَّبُّ مُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","كَلِّمْ بَنِي إِسْرَائِيلَ أَنْ يَأْخُذُوا لِي تَقْدِمَةً مِنْ كُلِّ إِنْسَانٍ يَحُثُّهُ قَلْبُهُ عَلَى ذَلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","أَمَّا التَّقْدِمَاتُ الَّتِي تَأْخُذُونَهَا مِنْهُمْ فَهِيَ: ذَهَبٌ وَفِضَّةٌ وَنُحَاسٌ ");
INSERT INTO arbnav_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","وَأَقْمِشَةٌ زَرْقَاءُ وَبَنَفْسَجِيَّةٌ وَحَمْرَاءُ، وَمَنْسُوجَاتٌ كَتَّانِيَّةٌ وَشَعْرُ مِعْزَى، ");
INSERT INTO arbnav_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","وَجُلُودُ كِبَاشٍ مُصَبَّغَةٌ بِالْحُمْرَةِ، وَجُلُودُ دَلافِينَ وَخَشَبُ السَّنْطِ، ");
INSERT INTO arbnav_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","وَزَيْتٌ لِلْمَنَارَةِ، وَأَطْيَابٌ لِدُهْنِ الْمَسْحَةِ وَلِلْبَخُورِ الْعَطِرِ ");
INSERT INTO arbnav_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","وَحِجَارَةُ جَزْعٍ كَرِيمَةٌ وَحِجَارَةٌ كَرِيمَةٌ أُخْرَى لِتَرْصِيعِ رِدَاءِ الْكَاهِنِ وَصُدْرَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","فَيَصْنَعُونَ لِي مَقْدِساً حَيْثُ أُقِيمُ فِيهِ بَيْنَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","تَصْنَعُونَهُ حَسَبَ مِثَالِ الْمَسْكَنِ وَالآنِيَةِ الَّتِي أُرِيكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","يَصْنَعُونَ تَابُوتاً مِنْ خَشَبِ السَّنْطِ، طُولُهُ ذِرَاعَانِ وَنِصْفٌ (نَحْوَ مِتْرٍ وَرُبْعِ الْمِتْرِ)، وَعَرْضُهُ ذِرَاعٌ وَنِصْفٌ (نَحْوَ خَمْسَةٍ وَسَبْعِينَ سَنْتِيمِتْراً) وَارْتِفَاعُهُ ذِرَاعٌ وَنِصْفٌ (نَحْوَ خَمْسَةٍ وَسَبْعِينَ سَنْتِيمِتْراً). ");
INSERT INTO arbnav_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","وَتَضَعُ عَلَيْهِ غِشَاءً مِنْ ذَهَبٍ نَقِيٍّ مِنَ الدَّاخِلِ وَالْخَارِجِ، وَاجْعَلْ لَهُ إطَاراً مِنْ ذَهَبٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","وَاسْبِكْ لَهُ أَرْبَعَ حَلَقَاتٍ مِنْ ذَهَبٍ تُثَبِّتُهَا عَلَى قَوَائِمِهِ الأَرْبَعِ حَلْقَتَيْنِ مِنْ كُلِّ جَانِبٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","وَتَصْنَعُ عَصَوَيْنِ مِنْ خَشَبِ السَّنْطِ تُغَشِّيهِمَا بِالذَّهَبِ، ");
INSERT INTO arbnav_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ثُمَّ تُدْخِلُهُمَا فِي الحَلَقَاتِ الَّتِي عَلَى جَانِبَيِ التَّابُوتِ لِيُحْمَلَ بِهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","وَتَبْقَى الْعَصَوَانِ فِي حَلَقَاتِ التَّابُوتِ، لَا تُنْزَعَانِ مِنْهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ثُمَّ تَضَعُ الشَّهَادَةَ الَّتِي أُعْطِيكَ فِي دَاخِلِ التَّابُوتِ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","وَتَصْنَعُ غِطَاءً مِنْ ذَهَبٍ خَالِصٍ، هُوَ كُرْسِيُّ الرَّحْمَةِ، طُولُهُ ذِرَاعَانِ وَنِصْفٌ (نَحْوَ مِتْرٍ وَرُبْعِ الْمِتْرِ) وَعَرْضُهُ ذِرَاعٌ وَنِصْفٌ (نَحْوَ خَمْسَةٍ وَسَبْعِينَ سَنْتِيمِتْراً) ");
INSERT INTO arbnav_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","وَتَخْرِطُ كَرُوبَيْنِ (تِمْثَالَيْ مَلاكَيْنِ) مِنْ ذَهَبٍ وَتُقِيمُهُمَا عَلَى طَرَفَيِ الْغِطَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","فَتَصْنَعُ كَرُوباً وَاحِداً عَلَى كُلِّ طَرَفٍ مِنَ الْغِطَاءِ، مَخْرُوطَيْنِ مِنَ الْغِطَاءِ نَفْسِهِ، وَقَائِمَيْنِ عَلَى طَرَفَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","وَيَكُونُ الْكَرُوبَانِ مُتَوَاجِهَيْنِ أَيْضاً، بَاسِطَيْنِ أَجْنِحَتَهُمَا إِلَى فَوْقُ، يُظَلِّلانِ بِهِمَا الْغِطَاءَ، وَيَتَّجِهَانِ بِوَجْهَيْهِمَا نَحْوَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","وَتَضَعُ الْغِطَاءَ فَوْقَ التَّابُوتِ الَّذِي تَحْتَفِظُ بِدَاخِلِهِ بِلَوْحَيِ الشَّهَادَةِ الَّتِي أُعْطِيكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","وَهُنَاكَ أَجْتَمِعُ بِكَ وَأُكَلِّمُكَ بِكُلِّ مَا أُوصِيكَ بِهِ لِتُبَلِّغَهُ لِبَنِي إِسْرَائِيلَ مِنْ عَلَى الْغِطَاءِ، مَا بَيْنَ الْكَرُوبَيْنِ اللَّذَيْنِ يَعْلُوَانِ تَابُوتَ الشَّهَادَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","وَكَذَلِكَ تَصْنَعُ مَائِدَةً مِنْ خَشَبِ السَّنْطِ طُولُهَا ذِرَاعَانِ (نَحْوَ مِتْرٍ) وَعَرْضُهَا ذِرَاعٌ (نَحْوَ خَمْسِينَ سَنْتِيمِتْراً) وَارْتِفَاعُهَا ذِرَاعٌ وَنِصْفٌ (نَحْوَ خَمْسَةٍ وَسَبْعِينَ سَنْتِيمِتْراً) ");
INSERT INTO arbnav_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","وَغَشِّهَا بِالذَّهَبِ وَاصْنَعْ لَهَا إِطَاراً عَالِياً مِنَ الذَّهَبِ، ");
INSERT INTO arbnav_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","وَاصْنَعْ لَهَا حَافَّةً حَوْلَهَا مِقْدَارُ عَرْضِهَا شِبْرٌ، وَاجْعَلْ لِمُحِيطِ الْحَافَةِ إطَاراً مِنْ ذَهَبٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","وَاسْبِكْ لَهَا أَرْبَعَ حَلَقَاتٍ مِنْ ذَهَبٍ تُثَبِّتُهَا عَلَى زَوَايَا قَوَائِمِهَا الأَرْبَعِ، ");
INSERT INTO arbnav_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","فَتَكُونُ الْحَلَقَاتُ المُثَبَّتَةُ عَلَى الْحَافَةِ، أَمَاكِنَ لِعَصَوَيْنِ تُحْمَلُ بِهِمَا الْمَائِدَةُ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","وَتَصْنَعُ الْعَصَوَيْنِ مِنْ خَشَبِ السَّنْطِ وَتُغَشِّيهِمَا بِالذَّهَبِ لِتُحْمَلَ بِهِمَا الْمَائِدَةُ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","وَأَمَّا صِحَافُ الْمَائِدَةِ وَصُحُونُهَا وَكُؤُوسُهَا وَأَبَارِيقُهَا الَّتِي يُسْكَبُ بِها، فَتَصُوغُهَا مِنْ ذَهَبٍ خَالِصٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","وَتَضَعُ أَمَامِي خُبْزَ التَّقْدِمَةِ عَلَى هَذِهِ الْمَائِدَةِ دَائِماً. ");
INSERT INTO arbnav_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","وَاخْرِطْ مَنَارَةً مِنْ ذَهَبٍ خَالِصٍ، فَتَكُونَ قَاعِدَتُهَا وَسَاقُهَا وَكَاسَاتُهَا وَبَرَاعِمُهَا وَأَزْهَارُهَا كُلُّهَا مَخْرُوطَةً مَعاً مِنْ قِطْعَةٍ وَاحِدَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","وَتَتَشَعَّبُ مِنْ كُلِّ جَانِبٍ مِنْهَا ثَلاثَةُ أَفْرُعٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","فِي كُلِّ شُعْبَةٍ ثَلاثُ كَاسَاتٍ بِبُرْعُمٍ وَزَهْرٍ، وَهَكَذَا إِلَى السِّتَّةِ الأَفْرُعِ الْمُتَشَعِّبَةِ مِنَ الْمَنَارَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","وَيَكُونُ عَلَى الْمَنَارَةِ أَرْبَعُ كَاسَاتٍ لَوْزِيَّةِ الشَّكْلِ بِبَرَاعِمِهَا وَأَزْهَارِهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","وَتَجْعَلُ تَحْتَ فَرْعَيْنِ مِنَ الأَفْرُعِ الْمُتَشَعِّبَةِ مِنَ الْمَنَارَةِ بُرْعُماً. هَكَذَا تَفْعَلُ لِلسِّتَّةِ الْأَفْرُعٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","وَيَكُونُ سَاقُ الْمَنَارَةِ وَبَرَاعِمُهَا وَأَفْرُعُهَا كُلُّهَا قِطْعَةً وَاحِدَةً مَصْوغَةً مِنْ ذَهَبٍ خَالِصٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","ثُمَّ اصْنَعْ سَبْعَةَ سُرُجٍ لِلْمَنَارَةِ، وَاجْعَلْهَا عَلَيْهَا بِحَيْثُ تُضِيءُ أَمَامَهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","وَلْتَكُنْ مَلاقِطُهَا وَمَنَافِضُهَا مِنْ ذَهَبٍ خَالِصٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","فَيَكُونَ وَزْنُ الذَّهَبِ الْخَالِصِ الْمُصَاغِ لِصُنْعِ الْمَنَارَةِ وَجَمِيعِ أَوَانِيهَا وَزْنَةً وَاحِدَةً (نَحْوَ سِتَّةٍ وَثَلاثِينَ كِيلُو جِرَاماً) ");
INSERT INTO arbnav_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","وَاحْرِصْ أَنْ يَكُونَ كُلُّ مَا تَصْنَعُهُ مُطَابِقاً لِلْمِثَالِ الَّذِي أَظْهَرْتُهُ لَكَ عَلَى الْجَبَلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","أَمَّا المَسْكِنُ فَتَصْنَعُ سَقْفَهُ مِنْ عَشْرِ قِطَعٍ كَتَّانِيَّةٍ مَبْرُومَةٍ بِإِتْقَانٍ، ذَاتِ أَلْوَانٍ زَرْقَاءَ وَبَنَفْسَجِيَّةٍ وَحَمْرَاءَ طَرَّزَ عَلَيْهَا حَائِكٌ مَاهِرٌ (رَسْمَ) الْكَرُوبِيمِ، ");
INSERT INTO arbnav_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","وَيَكُونُ طُولُ كُلِّ قِطْعَةٍ ثَمَانِيَ وَعِشْرِينَ ذِرَاعاً (نَحْوَ أَرْبَعَةَ عَشَرَ مِتْراً) وَعَرْضُهَا أَرْبَعَ أَذْرُعٍ (نَحْوَ مِتْرَيْنِ) فَيَكُونُ لِجَمِيعِ الْقِطَعِ قِيَاسٌ وَاحِدٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","وَتَصِلُ خَمْسَ قِطَعٍ مِنْهَا بِبَعْضٍ، وَكَذَلِكَ افْعَلْ بِالْقِطَعِ الْخَمْسِ الأُخْرَى. ");
INSERT INTO arbnav_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","وَاصْنَعْ عُرىً مِنْ قُمَاشٍ أَزْرْقَ عَلَى حَاشِيَةِ الطَّرَفِ الْوَاحِدِ فِي الْقِطَعِ الْمَوْصُولَةِ الأُولَى. وَكَذَلِكَ تَفْعَلُ أَيْضاً فِي حَاشِيَةِ الطَّرَفِ الْوَاحِدِ فِي الْقِطَعِ الْمَوْصُولَةِ الثَّانِيَةِ. وَكَذَلِكَ تَفْعَلُ أَيْضاً فِي حَاشِيَةِ الطَّرَفِ الأَخِيرِ مِنَ الْقِطَعِ الأُخْرَى الْمَوْصُولَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","فَيَكُونُ لِلطَّرَفِ الأَخِيرِ الْوَاحِدِ خَمْسُونَ عُرْوَةً فِي الْمَجْمُوعَةِ الأُولَى، وَخَمْسُونَ عُرْوَةً فِي طَرَفِ الْمَجْمُوعَةِ الثَّانِيَةِ، الْوَاحِدَةُ مُقَابِلَ الأُخْرَى. ");
INSERT INTO arbnav_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ثُمَّ اصْنَعْ خَمْسِينَ مِشْبَكاً مِنْ ذَهَبٍ تَصِلُ بِها عُرَى الْمَجْمُوعَتَيْنِ، فَتَتَّصِلَ الْمُجْمُوعَتَانِ مَعاً لِتُصْبِحَا سَقْفاً وَاحِداً لِلْمَسْكِنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","وَتَصْنَعُ أَيْضاً سَقْفاً ثَانِياً لِلْمَسْكِنِ، مِنْ إِحْدَى عَشْرَةَ قِطْعَةً مِنْ نَسِيجِ شَعْرِ المِعْزَى. ");
INSERT INTO arbnav_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","طُولُ الْقِطْعَةِ الْوَاحِدَةِ ثَلاثُونَ ذِرَاعاً (نَحْوَ خَمْسَةَ عَشَرَ مِتْراً) وَعَرْضُهَا أَرْبَعُ أَذْرُعٍ (نَحْوَ مِتْرَيْنِ) فَتَكُونُ كُلُّهَا ذَاتَ مَقَاسٍ وَاحِدٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","وَتَصِلُ خَمْسَ قِطَعٍ مَعاً لِتُصْبِحَ قِطْعَةً وَاحِدَةً، وَكَذَلِكَ افْعَلْ بِالْقِطَعِ السِّتِّ الأُخْرَى. عَلَى أَنْ تَثْنِيَ الْقِطْعَةَ السَّادِسةَ، فَتَتَدَلَّى كَحِجَابٍ أَمَامَ وَاجِهَةِ المَسْكِنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","وَاصْنَعْ خَمْسِينَ عُرْوَةً عَلَى حَاشِيَةِ طَرَفٍ وَاحِدٍ لِلْمَجْمُوعَةِ الأُولى. وَكَذَلِكَ تَصْنَعُ بِحَاشِيَةِ طَرَفٍ وَاحِدٍ لِلمَجْمُوعَةِ الثَّانِيَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","وَتَصْنَعُ خَمْسِينَ مِشْبَكاً مِنْ نُحَاسٍ تُدْخِلُهَا فِي العُرَى فَتَتَّصِلُ الْمَجْمُوعَتَانِ مَعاً، لِتُصْبِحَا سَقْفاً ثَانِياً لِلْمَسْكِنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","وَيَتَبَقَّى لَدَيْكَ ذِرَاعٌ (نَحْوَ نِصْفِ الْمِتْرِ) مِنْ غِطَاءِ السَّقْفِ مُدَلًّى لِحَجْبِ مُؤَخَّرِ الْمَسْكِنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","وَالجُزْءُ الْفَاصِلُ مِنْ طُولِ الْقِطَعِ عَلَى كُلِّ جَانِبٍ مِنْ بَيْنِ الْجَانِبَيْنِ، تُسْدِلُهُ عَلَى جَانِبَيِ المَسْكِنِ مِنْ هُنَا وَمِنْ هُنَاكَ لِتُغَطِّيَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","وَتَصْنَعُ غِطَاءً لِلْخَيْمَةِ مِنْ جُلُودٍ بَنَفْسَجِيَّةِ الْلَوْنِ، وَفَوْقَهُ سَقْفٌ آخَرُ مِنْ جُلُودِ الدُّلْفِينِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","أَمَّا جُدْرَانُ المَسْكِنِ فَتَصْنَعُهَا مِنْ أَلْوَاحٍ قَائِمَةٍ مِنْ خَشَبِ السَّنْطِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","طُولُ اللَّوْحِ مِنْهَا عَشْرُ أَذْرُعٍ (نَحْوَ خَمْسَةِ أَمْتَارٍ) وَعَرْضُهُ ذِرَاعٌ وَنِصْفٌ (نَحْوَ خَمْسةٍ وَسَبْعِينَ سَنْتِيمِتْراً) ");
INSERT INTO arbnav_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","وَلْتَكُنْ لِكُلِّ لَوْحٍ رِجْلانِ مُتَقَابِلَتَانِ إِحْدَاهُمَا بِإِزَاءِ الأُخْرَى. هَكَذَا تَصْنَعُ لِجَمِيعِ أَلْوَاحِ الْمَسْكِنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","فَتَجْعَلُ الْجَانِبَ الْجَنُوبِيَّ لِلْمَسْكِنِ مُكَوَّناً مِنْ عِشْرِينَ لَوْحاً. ");
INSERT INTO arbnav_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","وَاصْنَعْ أَرْبَعِينَ قَاعِدَةً مِنْ فِضَّةٍ تَحْتَ الْعِشْرِينَ لَوْحاً، فَيَكُونَ لِكُلِّ لَوْحٍ مُنْفَرِدٍ قَاعِدَتَانِ لِرِجْلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","وَاجْعَلْ لِجَانِبِ الْمَسْكِنِ الثَّانِي الشَّمَالِيِّ عِشْرِينَ لَوْحاً. ");
INSERT INTO arbnav_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","وَاصْنَعْ لَهُ أَيْضاً أَرْبَعِينَ قَاعِدَةً مِنْ فِضَّةٍ، لِيَكُونَ لِكُلِّ لَوْحٍ مُنْفَرِدٍ قَاعِدَتَانِ لِرِجْلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","أَمَّا جِدَارُ مُؤَخَّرِ الْمَسْكِنِ الغَرْبِيِّ فَتَصْنَعُ لَهُ سِتَّةَ أَلْوَاحٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","كَمَا تَصْنَعُ لَوْحَيْنِ لِزَاوِيَتَيِ الْمَسْكِنِ فِي المُؤَخَّرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","عَلَى أَنْ يَكُونَ كُلٌّ مِنْهُمَا مُزْدَوَجاً مِنْ أَسْفَلِهِ إِلَى أَعْلاهُ، حَيْثُ تُثَبَّتُ فِي رَأْسِ كُلِّ مُزْدَوَجٍ حَلَقَةٌ وَاحِدَةٌ. كُلٌّ مِنْهُمَا لِلزَّاوِيَتَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","فَيَكُونُ هُنَاكَ ثَمَانِيَةُ أَلْوَاحٍ لِلْجَانِبِ الغَرْبِيِّ، وَسِتَّ عَشْرَةَ قَاعِدَةً مِنْ فِضَّةٍ، قَاعِدَتَانِ تَحْتَ كُلِّ لَوْحٍ مُنْفَرِدٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","وَتَصْنَعُ عَوَارِضَ مِنْ خَشَبِ السَّنْطِ، خَمْساً لأَلْوَاحِ جَانِبِ الْمَسْكِنِ الْجَنُوبِيِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","وَخَمْسَ عَوَارِضَ لأَلْوَاحِ مُؤَخَّرِ الْمَسْكِنِ الْغَرْبِيِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","وَتَجْعَلُ الْعَارِضَةَ الْوُسْطَى تَنْفُذُ فِي وَسَطِ الأَلْوَاحِ مِنْ طَرَفٍ إِلَى طَرَفٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","وَتُغَشِّي الأَلْوَاحَ بِرَقَائِقَ مِنْ ذَهَبٍ. وَاصْنَعْ لَهَا حَلَقَاتٍ مِنْ ذَهَبٍ لِتَكُونَ بُيُوتاً لِلْعَوَارِضِ، وَتُغَشِّي الْعَوَارِضَ بِذَهَبٍ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","وَهَكَذَا تُقِيمُ الْمَسْكِنَ وَفْقاً لِلْمِثَالِ الَّذِي أَرَيْتُكَ إِيَّاهُ عَلَى الجَبَلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","وَتَصْنَعُ سِتَاراً مِنْ كَتَّانٍ مَبْرُومٍ ذِي أَلْوَانٍ زَرْقَاءَ وَبَنَفْسِجِيَّةٍ وَحَمْرَاءَ، بَعْدَ أَنْ يُطَرِّزَ عَلَيْهِ حَائِكٌ مَاهِرٌ رَسْمَ الْكَرُوبِيمِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","وَعَلِّقْهُ عَلَى أَرْبَعَةِ أَعْمِدَةٍ مِنْ خَشَبِ السَّنْطِ مُغَشَّاةٍ بِذَهَبٍ. لَهَا أَرْبَعَةُ خَطَاطِيفَ مِنْ ذَهَبٍ، وَقَائِمَةٌ عَلَى أَرْبَعِ قَوَاعِدَ مِنْ فِضَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","وَتَجْعَلُ السِّتَارَ تَحْتَ الْمَشَابِكِ. ثُمَّ تَأْتِي بِتَابُوتِ الشَّهَادَةِ (الَّذِي فِيهِ لَوْحَا الْوَصَايَا الْعَشْرِ) فَتُدْخِلُهُ إِلَى هُنَاكَ، إِلَى مَا وَرَاءَ السِّتَارَةِ الْفَاصِلَةِ بَيْنَ الْقُدْسِ وَقُدْسِ الأَقْدَاسِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","وَتَضَعُ الْغِطَاءَ عَلَى تَابُوتِ الشَّهَادَةِ فِي قُدْسِ الأَقْدَاسِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","وَتَنْصِبُ الْمَائِدَةَ خَارِجَ السِّتَارَةِ مُقَابِلَ الْمَنَارَةِ، فَتَكُونُ الْمَائِدَةُ قَائِمَةً فِي الْجِهَةِ الْجَنُوبِيَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","وَتَصْنَعُ سِتَارَةً لِمَدْخَلِ الْمَسْكِنِ، ذَاتَ أَلْوَانٍ زَرْقَاءَ وَبَنَفْسِجِيَّةٍ وَحَمْرَاءَ وَخُيُوطِ كَتَّانٍ مَبْرُومٍ مِنْ تَطْرِيزِ حَائِكٍ مَاهِرٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","وَتَجْعَلُ لِلسِّتَارَةِ خَمْسَةَ أَعْمِدَةٍ مِنْ خَشَبِ السَّنْطِ، ذَاتَ خَطَاطِيفَ مِنْ ذَهَبٍ، وَتُغَشِّي الْأَعْمِدَةَ بِذَهَبٍ وَتَسْبِكُ لَهَا خَمْسَ قَوَاعِدَ مِنْ نُحَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","وَتَصْنَعُ الْمَذْبَحَ مِنْ خَشَبِ السَّنْطِ. سَطْحُهُ مُرَبَّعُ الشَّكْلِ. طُولُهُ خَمْسَةُ أَذْرُعٍ (نَحْوَ مِتْرَيْنِ وَنِصْفِ الْمِتْرِ) وَعَرْضُهُ خَمْسَةُ أَذْرُعٍ (نَحْوَ مِتْرَيْنِ وَنِصْفِ الْمِتْرِ) وَارْتِفَاعُهُ ثَلاثَةُ أَذْرُعٍ (نَحْوَ مِتْرٍ وَنِصْفِ الْمِتْرِ) ");
INSERT INTO arbnav_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","وَتَصْنَعُ لَهُ قُرُوناً تُقِيمُهَا عَلَى زَوَايَاهُ الأَرْبَعِ، عَلَى أَنْ تَكُونَ مَنْحُوتَةً مِنْ ذَاتِ خَشَبِ الْمَذْبَحِ وَفِيهِ، وَتُغَشِّيهِ بِنُحَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","وَتَصْنَعُ جَمِيعَ آنِيَتِهِ مِنْ نُحَاسٍ: قُدُورَهُ لِرَفْعِ رَمَادِهِ، وَمَجَارِفَهُ وَأَحْوَاضَهُ وَمَنَاشِلَهُ وَمَجَامِرَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","وَتَصْنَعُ لَهُ شَبَكَةً مِنْ نُحَاسٍ ذَاتَ أَرْبَعِ حَلَقَاتٍ مِنْ نُحَاسٍ، مُثَبَّتَةٍ عَلَى أَطْرَافِهِ الأَرْبَعَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","وَتَضَعُهَا تَحْتَ حَافَةِ الْمَذْبَحِ مِنْ أَسْفَلُ بِحَيْثُ تَصِلُ إِلَى مُنْتَصَفِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","وَتَصْنَعُ لِلْمَذْبَحِ عَصَوَيْنِ مِنْ خَشَبِ السَّنْطِ وَتُغَشِّيهُمَا بِالنُّحَاسِ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","وَتُدْخِلُ الْعَصَوَيْنِ فِي الْحَلَقَاتِ عَلَى جَانِبَيِ الْمَذْبَحِ لِيُحْمَلَ بِهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","وَتَصْنَعُ المَذْبَحَ مُجَوَّفاً تَمَاماً مِنْ أَلْوَاحٍ، بِحَسَبِ الْمِثَالِ الَّذِي أَرَيْتُكَ إيَّاهُ فِي الجَبَلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","وَتُحِيطُ سَاحَةَ الْمَسْكِنِ مِنْ جِهَةِ الْجَنُوبِ بِسَتَائِرَ مِنْ كَتَّانٍ مَجْدُولٍ، طُولُهَا مِئَةُ ذِرَاعٍ (نَحْوَ خَمْسِينَ مِتْراً). ");
INSERT INTO arbnav_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","وَلَهَا عِشْرُونَ عَمُوداً، وَعِشْرُونَ قَاعِدَةً مِنْ نُحَاسٍ، وَتَكُونُ خَطَاطِيفُهَا وَقُضْبَانُهَا مِنْ فِضَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","وَكَذَلِكَ يَكُونُ الْجَانِبُ الشَّمَالِيُّ، إِذْ يَكُونُ طُولُ سَتَائِرِهِ مِئَةَ ذِرَاعٍ (نَحْوَ خَمْسِينَ مِتْراً) وَأَعْمِدَتُهُ عِشْرُونَ، قَائِمَةً عَلَى عِشْرِينَ قَاعِدَةً مِنْ نُحَاسٍ وَخَطَاطِيفُهُ وَقُضْبَانُهُ مِنْ فِضَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","أَمَّا عَرْضُ الدَّارِ الْغَرْبِيِّ فَيَكُونُ طُولُ سَتَائِرِهِ خَمْسِينَ ذِرَاعاً (نَحْوَ خَمْسَةٍ وَعِشْرِينَ مِتْراً) مُعَلَّقَةً عَلَى أَعْمِدَةٍ عَشْرَةٍ ذَاتِ عَشْرِ قَوَاعِدَ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","وَيَكُونُ عَرْضُ السَّاحَةِ مِنْ نَاحِيَةِ الشَّرْقِ خَمْسِينَ ذِرَاعاً (نَحْوَ خَمْسَةٍ وَعِشْرِينَ مِتْراً). ");
INSERT INTO arbnav_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","فَيَكُونُ طُولُ السَّتَائِرِ عَلَى الْجَانِبِ الأَوَّلِ لِمَدْخَلِ السَّاحَةِ خَمْسَ عَشْرَةَ ذِرَاعاً (نَحْوَ سَبْعَةِ أَمْتَارٍ وَنِصْفِ الْمِتْرِ) مُعَلَّقَةً عَلَى أَعْمِدَةٍ ثَلاثَةٍ ذَاتِ ثَلاثِ قَوَاعِدَ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","وَكَذَلِكَ يَكُونُ طُولُ السَّتَائِرِ عَلَى الْجَانِبِ الْآخَرِ لِمَدْخَلِ السَّاحَةِ خَمْسَ عَشْرَةَ ذِرَاعاً (نَحْوَ سَبْعَةِ أَمْتَارٍ وَنِصْفِ الْمِتْرِ)، مُعَلَّقَةً عَلَى أَعْمِدَةٍ ثَلاثَةٍ ذَاتِ ثَلاثِ قَوَاعِدَ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","أَمَّا طُولُ سَتَائِرِ الْمَدْخَلِ فَيَكُونُ عِشْرِينَ ذِرَاعاً (نَحْوَ عَشَرَةِ أَمْتَارٍ) مِنْ كَتَّانٍ مَبْرُومٍ ذِي أَلْوَانٍ زَرْقَاءَ وَبَنَفْسِجِيَّةٍ وَحَمْرَاءَ، مِنْ صِنَاعَةِ حَائِكٍ مَاهِرٍ، وَتَكُونُ مُعَلَّقَةً عَلَى أَعْمِدَةٍ ذَاتِ أَرْبَعِ قَوَاعِدَ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","وَيُحِيطُ بِكُلِّ أَعْمِدَةِ الدَّارِ قُضْبَانٌ مِنْ فِضَّةٍ، ذَاتُ خَطَاطِيفَ مِنْ فِضَّةٍ وَقَوَاعِدَ مِنْ نُحَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","فَيَكُونُ طُولُ السَّاحَةِ مِئَةَ ذِرَاعٍ (نَحْوَ خَمْسِينَ مِتْراً) وَعَرْضُهَا خَمْسِينَ ذِرَاعاً (نَحْوَ خَمْسَةٍ وَعِشْرِينَ مِتْراً) وَارْتِفَاعُ سَتَائِرِهَا خَمْسَ أَذْرُعٍ (نَحْوَ مِتْرَيْنِ وَنِصْفِ الْمِتْرِ). ");
INSERT INTO arbnav_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","وَلْتَكُنْ جَمِيعُ الأَوَانِي الْمُسْتَعْمَلَةِ فِي خِدْمَةِ الْمَسْكِنِ وَالْمَشَاجِبِ وَأَوْتَادِ الْمَسْكِنِ وَالسَّاحَةِ مَصْنُوعَةً مِنْ نُحَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","وَتَأْمُرُ بَنِي إِسْرَائِيلَ أَنْ يُقَدِّمُوا إِلَيْكَ زَيْتَ زَيْتُونٍ مَرْضُوضٍ لإِضَاءَةِ الْمَنَارَةِ الدَّائِمَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","وَيَقُومُ هَرُونُ وَبَنُوهُ مِنَ الْمَسَاءِ إِلَى الصَّبَاحِ، بِالْمُحَافَظَةِ الدَّائِمَةِ عَلَى إِضَاءَةِ السُّرُجِ أَمَامَ الرَّبِّ فِي خَيْمَةِ الاجْتِمَاعِ، خَارِجَ الْحِجَابِ الْقَائِمِ أَمَامَ تَابُوتِ الشَّهَادَةِ فَتَكُونُ هَذِهِ فَرِيضَةً دَهْرِيَّةً لِبَنِي إِسْرَائِيلَ فِي كُلِّ أَجْيَالِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","وَافْرِزْ لِي هَرُونَ أَخَاكَ وَأَوْلادَهُ: نَادَابَ وَأَبِيهُوَ وَأَلِعَازَارَ وَإِيثَامَارَ، مِنْ بَيْنِ بَنِي إِسْرَائِيلَ، لِيَكُونُوا لِي كَهَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","وَاصْنَعْ لأَخِيكَ هَرُونَ ثِيَاباً مُقَدَّسَةً لِتُضْفِيَ عَلَيْهِ مَجْداً وَبَهَاءً. ");
INSERT INTO arbnav_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","وَخَاطِبْ كُلَّ ذِي مَهَارَةٍ مِمَّنْ وَهَبْتُهُمْ رُوحَ الْبَرَاعَةِ فِي الْحِيَاكَةِ لِيَصْنَعُوا ثِيَابَ هَرُونَ لِتَقْدِيسِهِ، فَيَكُونَ كَاهِناً لِي. ");
INSERT INTO arbnav_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","وَهَذِهِ هِيَ الثِّيَابُ الَّتِي يَتَوَجَّبُ عَلَيْهِمْ صِنَاعَتُهَا: صُدْرَةٌ وَرِدَاءٌ وَجُبَّةٌ وَقَمِيصٌ مُخَرَّمٌ وَعِمَامَةٌ وَحِزَامٌ، يَصْنَعُونَهَا ثِيَاباً مُقَدَّسَةً لِهَرُونَ وَأَوْلادِهِ، لِيَكُونُوا كَهَنَةً لِي. ");
INSERT INTO arbnav_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","وَلْيَسْتَخْدِمُوا فِي حِيَاكَتِهَا خُيُوطاً ذَهَبِيَّةً وَزَرْقَاءَ وَبَنَفْسِجِيَّةً وَحَمْرَاءَ وَالْكَتَّانَ الْفَاخِرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","وَلْيَقُمْ أَمْهَرُ الخَيَّاطِينَ عَلَى صِنَاعَةِ الرِّدَاءِ مِنْ خُيُوطٍ ذَهَبِيَّةٍ وَزَرْقَاءَ وَبَنَفْسَجِيَّةٍ وَحَمْرَاءَ وَمِنَ الكَتَّانِ الْمَبْرُومِ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","يَكُونُ لَهُ كَتِفَانِ مُتَّصِلانِ فِي طَرَفَيْهِ لِيُمْكِنَ تَثْبِيتُهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","أَمَّا الْحِزَامُ الَّذِي يَشُدُّهُ، فَيَكُونُ مُحَاكاً مِنْهُ، مَصْنُوعاً بِمَهَارَةٍ مِنْ خُيُوطٍ ذَهَبِيَّةٍ وَزَرْقَاءَ وَبَنَفْسَجِيَّةٍ وَحَمْرَاءَ وَكَتَّانٍ مَبْرُومٍ فَاخِرٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ثُمَّ خُذْ حَجَرَيْ جَزْعٍ، وَانْقُشْ عَلَيْهِمَا أَسْمَاءَ رُؤَسَاءِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","تَنْقُشُ كلَّ سِتَّةِ أَسْمَاءَ عَلَى حَجَرٍ وَاحِدٍ بِحَسَبِ تَارِيخِ وِلادَتِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","انْقُشْ أَسْمَاءَ رُؤَسَاءِ أَسْبَاطِ بَنِي إِسْرَائِيلَ عَلَى الْحَجَرَيْنِ تَمَاماً مِثْلَ حَفْرِ النَّقَّاشِ الْمَاهِرِ عَلَى الْخَاتَمِ، وَطَوِّقْهُمَا بِإِطَارَيْنِ مِنْ ذَهَبٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","وَتُرَصِّعُ كَتِفَي الرِّدَاءِ بِالْحَجَرَيْنِ، فَيَكُونَانِ حَجَرَيْ تَذْكَارٍ لِبَنِي إِسْرَائِيلَ، فَيَحْمِلُ هَرُونُ أَسْمَاءَهُمْ عَلَى كَتِفَيْهِ لِلتَّذْكَارِ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","وَتَصْنَعُ طَوْقَيْنِ مِنْ ذَهَبٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","وَسِلْسِلَتَيْنِ مِنْ ذَهَبٍ خَالِصٍ مَبْرُومَتَيْنِ كَحَبْلٍ، تُعَلِّقُهُمَا بِالطَّوْقَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","كَلِّفْ أَمْهَرَ الخَيَّاطِينَ بِصِنَاعَةِ «صُدْرَةِ الْقَضَاءِ» مِنْ خُيُوطٍ ذَهَبِيَّةٍ وَزَرْقَاءَ وَبَنَفْسَجِيَّةٍ وَحَمْرَاءَ وَكَتَّانٍ مَبْرُومٍ عَلَى غِرَارِ صِنَاعَةِ الرِّدَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","وَتَكُونُ مُرَبَّعَةً مَثْنِيَّةً مِنْ طَبَقَتَيْنِ، وَطُولُهَا شِبْرٌ وَعَرْضُهَا شِبْرٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","وَتُرَصِّعُونَهَا بِأَرْبَعَةِ صُفُوُفٍ مِنَ الْحِجَارَةِ الْكَرِيمَةِ. الصَّفُ الأَوَّلُ: عَقِيقٌ أَحْمَرُ وَيَاقُوتٌ أَصْفَرُ وَزُمُرُّدٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","وَالصَّفُّ الثَّانِي: بَهْرَمَانٌ وَيَاقُوتٌ أَزْرَقُ وَعَقِيقٌ أَبْيَضُ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","وَالصَّفُّ الثَّالِثُ: عَيْنُ الهِرِّ وَيَشْمٌ وَجَمَشْتٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","وَالصَّفُّ الرَّابعُ: زَبَرْجَدٌ وَجَزْعٌ وَيَشَبٌ، وَتُؤَطِّرُهَا جَمِيعَهَا بِأَطْوَاقٍ ذَهَبِيَّةٍ فِي تَرْصِيعِهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","وَتَنْقُشُ عَلَى كُلِّ حَجَرٍ كَرِيمٍ اسْمَ سِبْطٍ مِنْ أَسْبَاطِ بَنِي إِسْرَائِيلَ الاثْنَيْ عَشَرَ عَلَى غِرَارِ نَقْشِ الْخَاتَمِ الْمَحْفُورَةِ عَلَيْهِ أَسْمَاءُ الاثْنَيْ عَشَرَ سِبْطاً. ");
INSERT INTO arbnav_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","وَاصْنَعْ عَلَى الصُّدْرَةِ سَلاسِلَ مَبْرُومَةً مِنْ ذَهَبٍ خَالِصٍ مِثْلَ الْحَبْلِ الْمَضْفُورِ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","وَتَضَعُ عَلَى طَرَفَيِ الصُّدْرَةِ حَلْقَتَيْنِ مِنْ ذَهَبٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","وَتَجْعَلُ ضَفِيرَتَيِ الذَّهَبِ فِي الْحَلْقَتَيْنِ عَلَى طَرَفَيِ الصُّدْرَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","كَمَا تُدْخِلُ طَرَفَيِ الضَّفِيرَتَيْنِ الآخَرَيْنِ فِي الطَّوْقَيْنِ، وَتَجْعَلُهُمَا عَلَى كَتِفَيِ الرِّدَاءِ إِلَى أَمَامِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","وَتَصْنَعُ حَلْقَتَيْنِ مِنْ ذَهَبٍ وَتُثَبِّتُهُمَا عَلَى طَرَفَيِ الصُّدْرَةِ الدَّاخِلِيَّةِ الْمُلاصِقَةِ لِلرِّدَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","كَذَلِكَ تَصْنَعُ حَلْقَتَيْنِ مِنْ ذَهَبٍ أُخْرَيَيْنِ، وَتَضَعُهُمَا عَلَى أَسْفَلِ كَتِفَيِ الرِّدَاءِ مِنَ الأَمَامِ عِنْدَ مَكَانِ الْوَصْلِ فَوْقَ حِزَامِ الرِّدَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","وَتَرْبِطُ حَلْقَتَيِ الصُّدْرَةِ إِلَى حَلْقَتَيِ الرِّدَاءِ بِخَيْطٍ أَزْرَقَ لِتَثْبُتَ فَوْقَ حِزَامِ الرِّدَاءِ، وَهَكَذَا لَا تُنْتَزَعُ الصُّدْرَةُ عَنِ الرِّدَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","فَيَحْمِلُ هَرُونُ أَسْمَاءَ أَسْبَاطِ بَنِي إِسْرَائِيلَ فِي «صُدْرَةِ الْقَضَاءِ» عَلَى قَلْبِهِ عِنْدَمَا يَدْخُلُ إِلَى الْقُدْسِ، تَذْكَاراً دَائِماً أَمَامَ الرَّبِّ ");
INSERT INTO arbnav_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","وَتَضَعُ أَيْضاً فِي صُدْرَةِ الْقَضَاءِ «الأُورِيمَ وَالتُّمِّيمَ» لِيَحْمِلَهَا هَرُونُ عَلَى قَلْبِهِ عِنْدَمَا يَمْثُلُ أَمَامَ الرَّبِّ. وَهَكَذَا يَحْمِلُ هَرُونُ عَلَى قَلْبِهِ أَمَامَ الرَّبِّ دَائِماً رَمْزَ قَضَاءِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","أَمَّا الْجُبَّةُ فَتَصْنَعُهَا كُلَّهَا مِنْ قُمَاشٍ أَزْرَقَ، ");
INSERT INTO arbnav_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","لَهَا فَتْحَةٌ لِلرَّأْسِ فِي وَسَطِهَا، ذَاتُ حَاشِيَةٍ مُحِيطَةٍ مُطَرَّزَةٍ، صِنَاعَةِ حَائِكٍ مَاهِرٍ. عَلَى غِرَارِ فَتْحَةِ الْقَمِيصِ تَكُونُ، لِكَيْ لَا تَتَمَزَّقَ، ");
INSERT INTO arbnav_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","وَتَتَدَلَّى مِنْ هُدْبِهَا رُمَّانَاتٌ زَرْقَاءُ وَبَنَفْسِجِيَّةٌ وَحَمْرَاءُ، وَتُعَلِّقُ بَيْنَهَا أَجْرَاساً مِنْ ذَهَبٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","فَيَكُونُ بَيْنَ كُلِّ رُمَّانَتَيْنِ جَرَسٌ مِنْ ذَهَبٍ، وَتَجْعَلُهَا جَمِيعَهَا عَلَى أَذْيَالِ الْجُبَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","فَيَرْتَدِي هَرُونُ الْجُبَّةَ كُلَّمَا دَخَلَ لِلْخِدْمَةِ، فَتُسْمَعُ أَصْوَاتُهَا عِنْدَ دُخُولِهِ إِلَى الْقُدْسِ أَمَامَ الرَّبِّ وَعِنْدَ خُرُوجِهِ، لَئِلا يَمُوتَ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","وَاصْنَعْ صَفِيحَةً مِنْ ذَهَبٍ خَالِصٍ، وَاحْفُرْ عَلَيْهَا كَالْحَفْرِ عَلَى خَاتَمٍ: «قُدْسٌ للرَّبِّ» ");
INSERT INTO arbnav_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","وَثَبِّتْهَا بِخَيْطٍ أَزْرَقَ فِي مُقَدِّمَةِ عِمَامَةِ هَرُونَ، ");
INSERT INTO arbnav_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","فَتَكُونَ دَائِماً عَلَى جَبْهَةِ هَرُونَ، فَيَحْمِلَ بِذَلِكَ عَنْ بَنِي إِسْرَائِيلَ وِزْرَ أَخْطَائِهِمْ فِي تَقْدِمَاتِهِمِ الَّتِي يُخَصِّصُونَهَا لِلرَّبِّ. وَعَلَى هَرُونَ أَنْ يَتَعَمَّمَ بِها دَائِماً عِنْدَمَا يَمْثُلُ أَمَامَ الرَّبِّ، لِكَيْ يَرْضَى الرَّبُّ عَنْهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","وَتَصْنَعُ قَمِيصَ هَرُونَ الْمُخَرَّمَ وَعِمَامَتَهُ مِنْ قُمَاشٍ كَتَّانِيٍّ، أَمَّا الْحِزَامُ فَتُطَرِّزُهُ تَطْرِيزَ حَائِكٍ مَاهِرٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","وَكَذَلِكَ تَصْنَعُ لِبَنِي هَرُونَ أَقْمِصَةً وَأَحْزِمَةً، وَقَلانِسَ لِتُضْفِيَ عَلَيْهِمْ مَجْداً وَبَهَاءً. ");
INSERT INTO arbnav_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","وَتُلْبِسُهَا هَرُونَ وَبَنِيهِ. ثُمَّ امْسَحْهُمْ بِزَيْتِ الزَّيْتُونِ، وَكَرِّسْهُمْ لِلْخِدْمَةِ الَّتِي يَقُومُونَ بِها، وَتُقَدِّسُهُمْ لِيَكُونُوا كَهَنَةً لِي. ");
INSERT INTO arbnav_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","وَتَصْنَعُ لَهُمْ سَرَاوِيلَ مِنْ كَتَّانٍ لِسَتْرِ الْعَوْرَةِ، تَصِلُ مِنَ الْحَقْوَيْنِ إِلَى الرُّكْبَتَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","فَيَلْبَسُهَا هَرُونُ وَبَنُوهُ تَحْتَ قُمْصَانِهِمْ عِنْدَ دُخُولِهِمْ إِلَى خَيْمَةِ الاجْتِمَاعِ، أَوْ عِنْدَ اقْتِرَابِهِمْ إِلَى الْمَذْبَحِ لِيَخْدِمُوا فِي القُدْسِ، لِئَلّا يُخْطِئُوا فَيَمُوتُوا. هَذَا فَرْضٌ دَائِمٌ عَلَى هَرُونَ وَنَسْلِهِ جِيلاً بَعْدَ جِيلٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","وَهَذَا مَا تَقُومُ بِهِ لِتَكْرِيسِ هَرُونَ وَبَنِيهِ لِيَكُونُوا كَهَنَةً لِي: خُذْ عِجْلاً وَكَبْشَيْنِ خَالِيَيْنِ مِنْ أَيِّ عَيْبٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","وَتُعِدُّ مِنْ دَقِيقِ الْقَمْحِ خُبْزَ فَطِيرٍ وَكَعْكاً مَعْجُوناً بِالزَّيْتِ، وَرِقَاقَ فَطِيرٍ مَدْهُونَةً بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","وَتَضَعُهَا فِي سَلَّةٍ وَاحِدَةٍ، وَتُقَدِّمُهَا فِي السَّلَّةِ مَعَ العِجْلِ وَالكَبْشَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ثُمَّ تُحْضِرُ هَرُونَ وَبَنِيهِ إِلَى بَابِ خَيْمَةِ الاجْتِمَاعِ، وَتَدَعُهُمْ يَغْتَسِلُونَ بِمَاءٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","وَتُلْبِسُ هَرُونَ الْقَمِيصَ وَالْجُبَّةَ وَالرِّدَاءَ وَالصُّدْرَةَ وَتَشُدُّ الرِّدَاءَ عَلَيْهِ بِالْحِزَامِ الْمُطَرَّزِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","وَتَضَعُ الْعِمَامَةَ عَلَى رَأْسِهِ وَتُثَبِّتُ عَلَيْهَا الإِكْلِيلَ الْمُقَدَّسَ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","وَتَأْخُذُ دُهْنَ الْمَسْحَةِ وَتَسْكُبُهُ عَلَى رَأْسِهِ وَتَمْسَحُهُ تَكْرِيساً لَهُ، ");
INSERT INTO arbnav_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ثُمَّ تُحْضِرُ بَنِيهِ وَتُلْبِسُهُمْ أَقْمِصَتَهُمْ الْمُطَرَّزَةَ، ");
INSERT INTO arbnav_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","وَأَحْزِمَتَهُمْ فَيُكَرَّسُونَ كَهَنَةً فَرِيضَةً لَهُمْ إِلَى الأَبَدِ. بِهَذِهِ الطَّرِيقَةِ تُكَرِّسُ هَرُونَ وَبَنِيهِ كَهَنَةً. ");
INSERT INTO arbnav_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","ثُمَّ أَحْضِرِ الْعِجْلَ أَمَامَ خَيْمَةِ الاجْتِمَاعِ، لِيَضَعَ هَرُونُ وَبَنُوهُ أَيْدِيَهُمْ عَلَى رَأْسِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","فَتَذْبَحُ الْعِجْلَ أَمَامَ الرَّبِّ عِنْدَ بَابِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","وَتَأْخُذُ مِنْ دَمِ الْعِجْلِ بِإِصْبَعِكَ، وَتَضَعُهُ عَلَى قُرُونِ الْمَذْبَحِ، وَتَصُبُّ بَقِيَّةَ الدَّمِ عِنْدَ قَاعِدَةِ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ثُمَّ تَأْخُذُ جَمِيعَ الشَّحْمِ الَّذِي يُغَشِّي الْجَوْفَ، وَزِيَادَةَ الكَبِدِ وَالْكُلْيَتَيْنِ وَمَا عَلَيْهَا مِنْ شَحْمٍ، وَتَحْرِقُهَا فَوْقَ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","وَأَمَّا لَحْمُ الْعِجْلِ وَجِلْدُهُ وَرَوْثُهُ، فَتَحْرِقُهَا خَارِجَ الْمُخَيَّمِ، فَإِنَّهُ ذَبِيحَةُ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","وَتَأْخُذُ أَحَدَ الْكَبْشَيْنِ لِيَضَعَ هَرُونُ وَبَنُوهُ أَيْدِيَهُمْ عَلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","تَذْبَحُ الْكَبْشَ، وتَأْخُذُ مِنْ دَمِهِ وَتَرُشُّهُ عَلَى الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","وَتَقْطَعُ الْكَبْشَ إِلَى قِطَعٍ، وَتَغْسِلُ أَعْضَاءَهُ الدَّاخِلِيَّةَ وَأَكَارِعَهُ وَتَضَعُهَا مَعَ رَأْسِ الْكَبْشِ وَقِطَعِهِ عَلَى الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","وَتَحْرِقُ كَامِلَ الْكَبْشِ عَلَى الْمَذْبَحِ، فَيَكُونُ مُحْرَقَةً لِلرَّبِّ لِنَيْلِ رِضَاهُ. هُوَ قُرْبَانُ مُحْرَقَةٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","ثُمَّ تَأْخُذُ الْكَبْشَ الثَّانِي لِيَضَعَ هَرُونُ وَبَنُوهُ أَيْدِيَهُمْ عَلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ثُمَّ تَذْبَحُهُ وَتَأْخُذُ مِنْ دَمِهِ وَتَضَعُهُ عَلَى شَحْمَاتِ آذَانِ هَرُونَ وَبَنِيهِ الْيُمْنَى، وَكَذِلكَ عَلَى أَبَاهِمِ أَيْدِيهِمْ وَأَرْجُلِهِمِ الْيُمْنَى، ثُمَّ تَرُشُّ الدَّمَ عَلَى الْمَذْبَحِ مِنْ كُلِّ نَاحِيَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","وَتَأْخُذُ مِنَ الدَّمِ الَّذِي عَلَى الْمَذْبَحِ، وَمِنْ دُهْنِ الْمَسْحَةِ، وَتُقَطِّرُ مِنْهُ عَلَى هَرُونَ وَبَنِيهِ وَعَلَى ثِيَابِهِمْ، فَيَتَقَدَّسُونَ هُمْ وَثِيَابُهُمْ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ثُمَّ تَأْخُذُ شَحْمَ الْكَبْشِ وَإِلْيَتَهُ وَالشَّحْمَ الَّذِي يُغَشِّي أَعْضَاءَهُ الدَّاخِلِيَّةَ، وَالْمَرَارَةَ وَالْكُلْيَتَيْنِ وَمَا عَلَيْهِمَا مِنْ شَحْمٍ، وَالْكَتِفَ الْيُمْنَى لأَنَّهُ كَبْشُ تَكْرِيسٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","وَتَأْخُذُ رَغِيفَ خُبْزٍ وَاحِداً، وَكَعْكَةً وَاحِدَةً مَعْجُونَةً بِالزَّيْتِ، وَرُقَاقَةً وَاحِدَةً مِنْ سَلَّةِ الْفَطِيرِ الَّتِي قَدَّمْتَهَا أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","وَتَضَعُهَا كُلَّهَا فِي أَيْدِي هَرُونَ وَبَنِيهِ لِيُرَجِّحُوهَا أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ثُمَّ تَأْخُذُهَا مِنْ أَيْدِيهِمْ وَتُوْقِدُهَا عَلَى الْمَذْبَحِ فَوْقَ الْمُحْرَقَةِ لِتَكُونَ رَائِحَةَ رِضًى أَمَامَ الرَّبِّ. هُوَ قُرْبَانُ مُحْرَقَةٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","وَتَأْخُذُ مِنَ ثَمَّ صَدْرَ كَبْشِ تَكْرِيسِ هَرُونَ وَتُرَجِّحُهُ أَمَامَ الرَّبِّ فَيَكُونُ قِسْطَكَ مِنَ الذَّبِيحَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","وَعَلَيْكَ أَنْ تُقَدِّسَ صَدْرَ ذَبِيحَةِ التَّرْجِيحِ، وَكَتِفَ ذَبِيحَةِ تَكْرِيسِ هَرُونَ وَبَنِيهِ الَّذِي رَجَّحْتَهُ، ");
INSERT INTO arbnav_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","فَيَكُونَانِ قِسطَ هَرُونَ وَبَنِيهِ. فَرِيضَةً أَبَدِيَّةً يُقَدِّمُهَا بَنُو إِسْرَائِيلَ نَصِيبَ الْكَهَنَةِ مِنْ بَنِي إِسْرَائِيلَ، مِنْ ذَبَائِحِ سَلامَتِهِمْ تَقْدِمَةً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","وَاحْتَفِظُوا بِثِيَابِ هَرُونَ الْمُقَدَّسَةِ لِتَكْرِيسِ مَنْ يَخْلُفُهُ مِنْ نَسْلِهِ وَمَسْحِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","وَعَلَى الابْنِ الَّذِي يَخْلُفُهُ كَرَئِيسِ كَهَنَةٍ، أَنْ يَلْبَسَهَا سَبْعَةَ أَيَّامٍ عِنْدَمَا يَدْخُلُ إِلَى خَيْمَةِ الاجْتِمَاعِ لِيَخْدِمَ فِي الْقُدْسِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","وَتَأْخُذُ لَحْمَ كَبْشِ التَّكْرِيسِ وَتَطْبُخُهُ فِي مَكَانٍ مُقَدَّسٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","وَعَلَى هَرُونَ وَبَنِيهِ أَنْ يَأْكُلُوا لَحْمَ الْكَبْشِ، وَالْخُبْزَ الَّذِي فِي السَّلَّةِ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","هُمْ وَحْدَهُمْ يَأْكُلُونَ مِنْهُ لأَنَّهُ قَدْ كُفِّرَ بِهِ عَنْهُمْ عِنْدَ تَكْرِيسِهِمْ وَتَقْدِيسِهِمْ، وَلا يَأْكُلُ مِنْهُ أَحَدٌ آخَرُ لأَنَّهُ مُقَدَّسٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","أَمَّا إِذَا تَبَقَّى شَيْءٌ مِنْ لَحْمِ التَّكْرِيسِ أَوْ مِنَ الْخُبْزِ حَتَّى الصَّبَاحِ، فَعَلَيْكَ أَنْ تَحْرِقَهُ بِالنَّارِ لَا يُؤْكَلُ مِنْهُ لأَنَّهُ مُقَدَّسٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","هَكَذَا تَصْنَعُ لِهَرُونَ وَبَنِيهِ بِمُوجِبِ كُلِّ مَا أَمَرْتُكَ، إِذْ تُكَرِّسُهُمْ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","وَتُقَدِّمُ خِلالَهَا ثَوْراً فِي كُلِّ يَوْمٍ ذَبِيحَةَ خَطِيئَةٍ لأَجْلِ الْكَفَّارَةِ. وَتُطَهِّرُ الْمَذْبَحَ بِتَكْفِيرِكِ عَلَيْهِ. وَتَمْسَحُهُ لِتَقْدِيسِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","سَبْعَةَ أَيَّامٍ تُقَدِّمُ ذَبِيحَةَ كَفَّارَةٍ عَلَى الْمَذْبَحِ وَتُقَدِّسُهُ، فَيَكُونُ الْمَذْبَحُ قُدْسَ أَقْدَاسٍ. وَكُلُّ مَا يَمَسُّهُ يُصْبِحُ مُقَدَّساً. ");
INSERT INTO arbnav_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","وَإِلَيْكَ مَا تُقَدِّمُهُ عَلَى الْمَذْبَحِ: حَمَلانِ حَوْلِيَّانِ كُلَّ يَوْمٍ بِصُورَةٍ مُسْتَمِرَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","تُقَدِّمُ أَحَدَ الْحَمَلَيْنِ فِي الصَّبَاحِ، وَتُقَدِّمُ الثَّانِي فِي الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","وَتُقَدِّمُ مَعَ كُلٍّ مِنْهُمَا عُشْراً (لِتْرَيْنِ وَنِصْفَ اللِّتْرِ) مِنَ الدَّقِيقِ الْمَعْجُونِ بِرُبْعِ الْهِينِ (لِتْرٍ وَنِصْفِ اللِّتْرِ) مِنْ زَيْتِ الزَّيْتُونِ النَّقِيِّ، بَعْدَ أَنْ تَسْكُبَ عَلَيْهِ رُبْعَ الْهِينِ (لِتْراً وَنِصْفَ الْلِّتْرِ) مِنَ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","وَتُقَرِّبُ الْحَمَلَ الثَّانِي فِي الْمَسَاءِ مَعَ تَقْدِمَةِ دَقِيقٍ وَسَكِيبِ خَمْرٍ، كَمَا فَعَلْتَ فِي الصَّبَاحِ، لِتَكُونَ التَّقْدِمَةُ رَائِحَةَ رِضًى. هِيَ قُرْبَانُ مُحْرَقَةٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","فَتَكُونُ مُحْرَقَةً دَائِمَةً أَمَامَ الرَّبِّ مَدَى أَجْيَالِكُمْ. تُقَدَّمُ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، حَيْثُ أَجْتَمِعُ بِكُمْ لأُكَلِّمَكَ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","وَأَجْتَمِعُ هُنَاكَ أَيْضاً بِبَنِي إِسْرَائِيلَ، فَيَتَقَدَّسُ الْمَكَانُ بِمَجْدِي. ");
INSERT INTO arbnav_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","فَأُقَدِّسُ خَيْمَةَ الاجْتِمَاعِ وَالْمَذْبَحَ، كَمَا أُقَدِّسُ هَرُونَ وَبَنِيهِ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","وَأَسْكُنُ بَيْنَ شَعْبِ إِسْرَائِيلَ، وَأَكُونُ لَهُمْ إِلَهاً، ");
INSERT INTO arbnav_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","فَيَعْلَمُونَ أَنَّنِي أَنَا الرَّبُّ إِلَهُهُمُ الَّذِي أَخْرَجَهُمْ مِنْ دِيَارِ مِصْرَ لأُقِيمَ فِي وَسْطِهِمْ. أَنَا الرَّبُّ إِلَهُهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","وَتَصْنَعُ مَذْبَحاً مِنْ خَشَبِ السَّنْطِ لإِحْرَاقِ الْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","يَكُونُ ذَا سَطْحٍ مُرَبَّعٍ، طُولُهُ ذِرَاعٌ (نَحْوَ نِصْفِ الْمِتْرِ) وَعَرْضُهُ ذِرَاعٌ (نَحْوَ نِصْفِ الْمِتْرِ) وَيَكُونُ ارْتِفَاعُهُ ذِرَاعَينِ (نَحْوَ مِتْرٍ)، وَلَهُ قُرُونٌ مَنْحُوتَةٌ فِي ذَاتِ خَشَبِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","وَتُغَشِّي سَطْحَهُ وَجَوانِبَهُ وَقُرُونَهُ بِذَهَبٍ خَالِصٍ، وَطَوِّقْهُ بِإِطَارٍ مِنَ الذَّهَبِ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","وَثَبِّتْ عَلَى كُلٍّ مِنْ جَانِبَيْهِ تَحْتَ الإِطَارِ، حَلْقَتَيْنِ مَصْنُوعَتَيْنِ مِنَ الذَّهَبِ، لِتَضَعَ فِيهِمَا عَصَوَيْنِ يُحْمَلُ الْمَذْبَحُ بِهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","أَمَّا الْعَصَوَانِ فَاصْنَعْهُمَا مِنْ خَشَبِ السَّنْطِ الْمُغَشَّى بِذَهَبٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","وَتَضَعُ هَذَا الْمَذْبَحَ أَمَامَ الْحِجَابِ الْمُوَاجِهِ لِتَابُوتِ الشَّهَادَةِ (الَّذِي فِيهِ لَوْحَا الْشَّرِيعَةِ) مُقَابِلَ الْغِطَاءِ الَّذِي فَوْقَ التَّابُوتِ حَيْثُ أَجْتَمِعُ بِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","فَيَحْرِقُ هَرُونُ عَلَيْهِ بَخُوراً عَطِراً فِي كُلِّ صَبَاحٍ، عِنْدَمَا يَدْخُلُ لإِصْلاحِ فَتَائِلِ الْمَنَارَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","وَكَذَلِكَ يَحْرِقُهُ أَيْضاً عِنْدَمَا يُضِيءُ هَرُونُ الْمَنَارَةَ فِي الْمَسَاءِ. فَيَظَلُّ الْبَخُورُ مُوْقَداً أَمَامَ الرَّبِّ مِنْ جِيلٍ إِلَى جِيلٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","لَا تَحْرِقْ عَلَى هَذَا الْمَذْبَحِ بَخُوراً غَرِيباً وَلا مُحْرَقَةً أَوْ تَقْدِمَةً، وَلا تَسْكُبُوا عَلَيْهِ سَكِيباً. ");
INSERT INTO arbnav_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","وَيُقَرِّبُ هَرُونُ كَفَّارَةً عَلَى قُرُونِهِ مَرَّةً فِي السَّنَةِ فَيَرُشُّ مِنْ دَمِ ذَبِيحَةِ الْخَطِيئَةِ الْكَفَّارِيَّةِ عَلَيْهِ مَرَّةً فِي السَّنَةِ مِنْ جِيلٍ إِلَى جِيلٍ، لأَنَّهُ هُوَ قُدْسُ أَقْدَاسٍ للرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","وَخَاطَبَ الرَّبُّ مُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«عِنْدَمَا تَقُومُ بِإِحْصَاءِ بَنِي إِسْرَائِيلَ، يُقَدِّمُ كُلُّ مَنْ تُحْصِيهِ فِدْيَةً عَنْ نَفْسِهِ للرَّبِّ لِئَلّا يُصِيبَهُمْ وَبَأٌ عِنْدَ إحْصَائِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","فَيُعْطِي كُلُّ مُحْصىٍ نِصْفَ شَاقِلٍ (نَحْوَ سِتَّةِ جِرَامَاتٍ) مِنَ الْفِضَّةِ تَقْدِمَةً للرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","كُلُّ مَنْ جَازَ عَلَيْهِ الإِحْصَاءُ مِنِ ابْنِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، يُعْطِي تَقْدِمَةً للرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","فَلا يُعْطِي الْغَنِيُّ أَكْثَرَ مِنْ نِصْفِ شَاقِلٍ (نَحْوِ سِتَّةِ جِرَامَاتٍ) وَلا يَدْفَعُ الْفَقِيرُ أَقَلَّ مِنْهَا لأَنَّهَا تَقْدِمَةُ الرَّبِّ، لِلتَّكْفِيرِ عَنْ نُفُوسِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","وَتَسْتَخْدِمُ فِضَّةَ الْكَفَّارَةِ هَذِهِ الَّتِي تَجْمَعُهَا مِنْ بَنِي إِسْرَائِيلَ، لِنَفَقَاتِ خَيْمَةِ الاجْتِمَاعِ. فَتَكُونُ تَذْكَاراً. لِبَنِي إِسْرَائِيلَ أَمَامَ الرَّبِّ لِلتَّكْفِيرِ عَنْ نُفُوسِكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","وَخَاطَبَ الرَّبُّ مُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«اصْنَعْ حَوْضاً نُحَاسِيًّا لِلاغْتِسَالِ ذَا قَاعِدَةٍ نُحَاسِيَّةٍ، وَأَقِمْهُ بَيْنَ خَيْمَةِ الاجْتِمَاعِ وَالْمَذْبَحِ، وَامْلأْهُ بِالْمَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","لِيَغْسِلَ هَرُونُ وَبَنُوهُ أَيْدِيَهُمْ وَأَرْجُلَهُمْ مِنْهُ، ");
INSERT INTO arbnav_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","لَدَى دُخُولِهِمْ إِلَى خَيْمَةِ الاجْتِمَاعِ، أَوْ عِنْدَ اقْتِرَابِهِمْ إِلَى الْمَذْبَحِ لِلْقِيَامِ بِخِدْمَةِ تَقْدِيمِ الْمُحْرَقَاتِ لِئَلّا يَمُوتُوا إِذَا لَمْ يَغْتَسِلُوا. ");
INSERT INTO arbnav_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","لِيَغْسِلُوا أَيْدِيَهُمْ وَأَرْجُلَهُمْ لِئَلّا يَمُوتُوا. فَتَكُونُ هَذِهِ فَرِيضَةً أَبَدِيَّةً لِهَرُونَ وَنَسْلِهِ جِيلاً بَعْدَ جِيلٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«خُذْ لَكَ أَطْيَبَ الْعُطُورِ: خَمْسَ مِئَةِ شَاقِلٍ (نَحْوَ سِتَّةَ كِيلو جِرَامَاتٍ) مِنَ الْمُرِّ النَّقِيِّ السَّائِلِ، وَمِئَتَيْنِ وَخَمْسِينَ شَاقِلاً (نَحْوَ ثَلاثَةِ كِيلو جِرَامَاتٍ) مِنَ الْقِرْفَةِ، وَمَئَتَيْنِ وَخَمْسِينَ شَاقِلاً (نَحْوَ ثَلاثَةِ كِيلو جِرَامَاتٍ) مِنْ قَصَبِ الذَّرِيرَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","وَخَمْسَ مِئَةِ شَاقِلٍ (نَحْوَ سِتَّةِ كِيلُو جِرَامَاتٍ) مِنَ السَّلِيخَةِ وَهِيناً (نَحْوَ سِتَّةِ لِتْرَاتٍ) مِنْ زَيْتِ الزَّيْتُونِ النَّقِيِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","وَاصْنَعْ مِنْهَا دُهْنَ مَسْحَةٍ مُقَدَّساً طَيِّباً شَذِيًّا صَنْعَةَ عَطَّارٍ مَاهِرٍ، فَيَكُونَ دُهْنَ مَسْحَةٍ مُقَدَّساً. ");
INSERT INTO arbnav_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","تَمْسَحُ بِهِ خَيْمَةَ الاجْتِمَاعِ، وَتَابُوتَ الشَّهَادَةِ، ");
INSERT INTO arbnav_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","وَالْمَائِدَةَ مَعَ كُلِّ آنِيَتِهَا، وَالْمَنَارَةَ وَآنِيَتَهَا، وَمَذْبَحَ الْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","وَمَذْبَحَ الْمُحْرَقَةِ وَسَائِرَ آنِيَتِهِ، وَالْحَوْضَ وَقَاعِدَتَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","تُقَدِّسُهَا فَتُصْبِحُ قُدْسَ أَقْدَاسٍ، وَيُصْبِحُ كُلُّ مَا مَسَّهَا مُقَدَّساً. ");
INSERT INTO arbnav_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","وَتَمْسَحُ هَرُونَ وَبَنِيهِ أَيْضاً وَتُقَدِّسُهُمْ لِيَكُونُوا كَهَنَةً لِي. ");
INSERT INTO arbnav_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","وَتَقُولُ لِبَنِي إِسْرَائِيلَ: إِنَّ هَذَا الدُّهْنَ يَكُونُ لِي دُهْناً مُقَدَّساً لِلْمَسْحَةِ عَلَى مَرِّ أَجْيَالِكُمْ ");
INSERT INTO arbnav_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","لَا يُسْكَبُ عَلَى جَسَدِ إِنْسَانٍ، وَلا تَسْتَخْدِمُوا مَقَادِيرَهُ فِي صِنَاعَةِ طِيبٍ مِثْلِهِ، فَهُوَ مُقَدَّسٌ، وَيَجِبُ أَنْ يَكُونَ مُقَدَّساً عِنْدَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","كُلُّ مَنْ رَكَّبَ مِثْلَهُ أَوْ دَهَنَ بِهِ غَرِيباً مِنْ غَيْرِ الْكَهَنَةِ يُسْتَأْصَلُ مِنْ بَيْنِ قَوْمِهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","وَقَالَ الرَّبُّ لِمُوسَى: «خُذْ لَكَ أَطْيَاباً، أَجْزَاءَ مُتَسَاوِيَةً مِنَ الْمَيْعَةِ وَالأَظْفَارِ وَالْقِنَّةِ الْعَطِرَةِ وَاللُّبَانِ الزَّكِيِّ، وَاخْلِطْهَا، ");
INSERT INTO arbnav_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","صَانِعاً مِنْهَا بَخُوراً عَطِراً مُمَلَّحاً نَقِيًّا مُقَدَّساً، كَمَا يَفْعَلُ أَمْهَرُ الْعَطَّارِينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","وَتَسْحَقُ بَعْضاً مِنْهُ وَتَجْعَلُهُ أَمَامَ التَّابُوتِ فِي خَيْمَةِ الاجْتِمَاعِ حَيْثُ أَجْتَمِعُ بِكَ. فَيَكُونُ قُدْسَ أَقْدَاسٍ عِنْدَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","وَلا يَسْتَخْدِمُ أَحَدٌ مَقَادِيرَهُ فِي صِنَاعَةِ بَخُورٍ مِثْلِهِ. يَكُونُ مُقَدَّساً عِنْدَكَ لِلرَّبِّ وَحْدَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","كُلُّ مَنْ يُرَكِّبُ مِثْلَهُ لِيَشُمَّهُ يُسْتَأْصَلُ مِنْ بَيْنِ قَوْمِهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","وَخَاطَبَ الرَّبُّ مُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«هَا أَنَا قَدْ دَعَوْتُ بَصَلْئِيلَ بْنَ أُوْرِي، حَفِيدَ حُورَ مِنْ سِبْطِ يَهُوذَا، بِاسْمِهِ، ");
INSERT INTO arbnav_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","وَمَلأْتُهُ مِنْ رُوحِ اللهِ وَوَهَبْتُهُ حِكْمَةً وَمَهَارَةً وَمَقْدِرَةً وَمَعْرِفَةً فِي كُلِّ أَنْوَاعِ الْحِرَفِ، ");
INSERT INTO arbnav_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","وَلِابْتِكَارِ فُنُونِ التَّصْمِيمَاتِ الْمَصْنُوعَةِ مِنَ الذَّهَبِ وَالْفِضَّةِ وَالنُّحَاسِ، ");
INSERT INTO arbnav_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","وَصَقْلِ الْجَوَاهِرِ وَتَرْصِيعِهَا، وَنِجَارَةِ الْخَشَبِ، وَلِيَكُونَ مُحْتَرِفاً لِكُلِّ صِنَاعَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","كَمَا اخْتَرْتُ أَهُولِيآبَ بْنَ أَخِيسَامَاكَ مِنْ سِبْطِ دَانَ، لِيَكُونَ مُسَاعِداً لَهُ. وَكَذَلِكَ وَهَبْتُ جَمِيعَ الصُّنَّاعِ مَهَارَةً خَاصَّةً لِيَقُومُوا بِكُلِّ مَا أَمَرْتُكَ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","فِي صُنْعِ خَيْمَةِ الاجْتِمَاعِ وَتَابُوتِ الشَّهَادَةِ وَالْغِطَاءِ الَّذِي عَلَيْهِ وَسَائِرِ آنِيَةِ الْخَيْمَةِ، ");
INSERT INTO arbnav_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","كَالْمَائِدَةِ وَآنِيَتِهَا، وَالْمَنَارَةِ الذَّهَبِيَّةِ الطَّاهِرَةِ، وَكُلِّ آنِيَتِهَا، وَمَذْبَحِ الْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","وَمَذْبَحِ الْمُحْرَقَةِ وَكُلِّ آنِيَتِهِ، وَحَوْضِ الاغْتِسَالِ وَقَاعِدَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","وَكَذَلِكَ الثِّيَابِ الْمَنْسُوجَةِ، ثِيَابِ هَرُونَ الْكَاهِنِ الْمُقَدَّسَةِ وَثِيَابِ بَنِيهِ الْقَائِمِينَ عَلَى خِدْمَةِ الْكِهَانَةِ، ");
INSERT INTO arbnav_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","وَدُهْنِ الْمَسْحَةِ وَالْبَخُورِ الْعَطِرِ لِلْقُدْسِ. فَيَعْمَلُونَ هَذِهِ كُلَّهَا بِمُقْتَضَى كُلِّ مَا أَمَرْتُكَ بِهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«قُلْ لِبَنِي إِسْرَائِيلَ: احْفَظُوا أَيَّامَ سُبُوتِي لأَنَّهَا عَلامَةُ الْعَهْدِ الَّذِي بَيْنِي وَبَيْنَكُمْ، عَلَى مَرِّ الأَجْيَالِ، لِتَعْلَمُوا أَنِّي أَنَا الرَّبُّ الَّذِي يُقَدِّسُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","احْفَظُوا يَوْمَ السَّبْتِ لأَنَّهُ مُقَدَّسٌ لَكُمْ. مَنْ يُدَنِّسْهُ حَتْماً يَمُتْ. فَكُلُّ مَنْ يَقُومُ فِيهِ بِعَمَلٍ، تُسْتَأْصَلُ تِلْكَ النَّفْسُ مِنْ بَيْنِ قَوْمِهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","فِي سِتَّةِ أَيَّامٍ تَعْمَلُونَ، أَمَّا يَوْمُ السَّبْتِ فَهُوَ يَوْمُ عُطْلَةٍ مُقَدَّسٌ لِلرَّبِّ. كُلُّ مَنْ يَقُومُ بِعَمَلٍ فِي يَوْمِ السَّبْتِ يُقْتَلُ حَتْماً. ");
INSERT INTO arbnav_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","لِيَحْفَظْ بَنُو إِسْرَائِيلَ السَّبْتَ وَيَحْتَفِلُوا بِهِ فِي كُلِّ أَجْيَالِهِمْ عَهْداً أَبَدِيًّا. ");
INSERT INTO arbnav_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","هُوَ بَيْنِي وَبَنِي إِسْرَائِيلَ عَلامَةُ عَهْدٍ إِلَى الأَبَدِ، لأَنَّهُ فِي سِتَّةِ أَيَّامٍ صَنَعَ الرَّبُّ السَّمَاءَ وَالأَرْضَ، وَفِي الْيَوْمِ السَّابِعِ فَرَغَ مِنَ الْعَمَلِ وَاسْتَرَاحَ». ");
INSERT INTO arbnav_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","وَعِنْدَمَا فَرَغَ اللهُ مِنْ مُخَاطَبَةِ مُوسَى فِي جَبَلِ سِينَاءَ، أَعْطَاهُ لَوْحَيِ الشَّهَادَةِ، وَهُمَا لَوْحَانِ مِنْ حَجَرٍ مَكْتُوبَانِ بِإِصْبَعِ اللهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","وَلَمَّا رَأَى الشَّعْبُ أَنَّ مُوسَى قَدْ طَالَتْ إقَامَتُهُ عَلَى الْجَبَلِ، اجْتَمَعُوا حَوْلَ هَرُونَ، وَقَالُوا لَهُ: «هَيَّا، اصْنَعْ لَنَا إِلَهاً يَتَقَدَّمُنَا فِي مَسِيرِنَا، لأَنَّنَا لَا نَدْرِي مَاذَا أَصَابَ هَذَا الرَّجُلَ مُوسَى الَّذِي أَخْرَجَنَا مِنْ دِيَارِ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","فَأَجَابَهُمْ هَرُونُ: «انْزِعُوا أَقْرَاطَ الذَّهَبِ الَّتِي فِي آذَانِ نِسَائِكُمْ وَبَنَاتِكُمْ وَبَنِيكُمْ، وَأَعْطُونِي إِيَّاهَا». ");
INSERT INTO arbnav_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","فَنَزَعُوهَا مِنْ آذَانِهِمْ، وَجَاءُوا بِها إِلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","فَأَخَذَهَا مِنْهُمْ وَصَهَرَهَا وَصَاغَ عِجْلاً. عِنْدَئِذٍ قَالُوا: «هَذِهِ آلِهَتُكَ يَا إِسْرَائِيلُ الَّتِي أَخْرَجَتْكَ مِنْ دِيَارِ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","وَعِنْدَمَا شَاهَدَ هَرُونُ ذَلِكَ شَيَّدَ مَذْبَحاً أَمَامَ الْعِجْلِ وَأَعْلَنَ: «غَداً هُوَ عِيدٌ لِلرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","فَبَكَّرَ الشَّعْبُ فِي الْيَوْمِ الثَّانِي وَأَصْعَدُوا مُحْرَقَاتٍ وَقَدَّمُوا قَرَابِينَ سَلامٍ. ثُمَّ احْتَفَلُوا فَأَكَلُوا وَشَرِبُوا، وَمِنْ ثَمَّ قَامُوا لِلَّهْوِ وَالْمُجُونِ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","فَأَمَرَ الرَّبُّ مُوسَى: «قُمْ وَانْزِلْ فَإِنَّ الشَّعْبَ الَّذِي قَدْ أَخْرَجْتَهُ مِنْ دِيَارِ مِصْرَ، قَدْ فَسَدَ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","إِذِ انْحَرَفُوا سَرِيعاً عَنِ الطَّرِيقِ الَّذِي أَمَرْتُهُمْ بِهِ، فَصَاغُوا لَهُمْ عِجْلاً وَعَبَدُوهُ وَذَبَحُوا لَهُ الذَّبَائِحَ هَاتِفِينَ: هَذَا هُوَ إِلهُكَ يَا إِسْرَائِيلُ الَّذِي أَخْرَجَكَ مِنْ دِيَارِ مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","وَقَالَ الرَّبُّ لِمُوسَى: «لَقَدْ تَأَمَّلْتُ فِي هَذَا الشَّعْبِ، وَإذَا بِهِ شَعْبٌ عَنِيدٌ مُتَصَلِّبُ الْقَلْبِ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","وَالآنَ دَعْنِي وَغَضَبِي الْمُحْتَدِمَ فَأَفْنِيَهُمْ، ثُمَّ أَجْعَلَكَ أَنْتَ شَعْباً عَظِيماً». ");
INSERT INTO arbnav_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","فَابْتَهَلَ مُوسَى إِلَى الرَّبِّ وَقَالَ: «لِمَاذَا يَحْتَدِمُ غَضَبُكَ عَلَى شَعْبِكَ الَّذِي أَخْرَجْتَهُ مِنْ دِيَارِ مِصْرَ بِقُوَّةٍ عَظِيمَةٍ وَذِرَاعٍ مُقْتَدِرَةٍ؟ ");
INSERT INTO arbnav_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","لِمَاذَا يَشْمَتُ الْمِصْرِيُّونَ فِينَا قَائِلِينَ: لَقَدِ احْتَالَ عَلَيْهِمْ إِلَهُهُمْ فَأَخْرَجَهُمْ مِنْ هَهُنَا لِيُهْلِكَهُمْ فِي الْجِبَالِ وَيُفْنِيَهُمْ عَنْ وَجْهِ الأَرْضِ. ارْجِعْ عَنْ حُمُوِّ غَضَبِكَ وَلا تُوْقِعْ هَذَا الْعِقَابَ بِشَعْبِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","اذْكُرْ وُعُودَكَ لِعَبِيدِكَ إِبْرَاهِيمَ وَإِسْحَاقَ وَإِسْرَائِيلَ الَّذِينَ أَقْسَمْتَ لَهُمْ بِنَفْسِكَ قَائِلاً: أُكَثِّرُ نَسْلَكُمْ كَنُجُومِ السَّمَاءِ، وَأَهَبُكُمْ جَمِيعَ هَذِهِ الأَرْضِ الَّتِي وَعَدْتُ بِها فَتَمْلِكُونَهَا إِلَى الأَبَدِ». ");
INSERT INTO arbnav_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","فَتَرَاءَفَ الرَّبُّ وَلَمْ يُوْقِعْ بِشَعْبِهِ الْعِقَابَ الَّذِي تَوَعَّدَ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ثُمَّ نَزَلَ مُوسَى وَانْحَدَرَ مِنَ الجَبَلِ حَامِلاً فِي يَدِهِ لَوْحَيِ الشَّهَادَةِ (الْوَصَايَا الْعَشْرِ)، وَقَدْ نُقِشَتْ كِتَابَةٌ عَلَى وَجْهَيْ كُلٍّ مِنْهُمَا، ");
INSERT INTO arbnav_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","وَكَانَ اللهُ قَدْ صَنَعَ اللَّوْحَيْنِ وَنَقَشَ الْكِتَابَةَ عَلَيْهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","وَسَمِعَ يَشُوعُ هُتَافَ الشَّعْبِ فَقَالَ لِمُوسَى: «هَذَا صَوْتُ تَأَهُّبٍ لِقِتَالٍ فِي المُخَيَّمِ». ");
INSERT INTO arbnav_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","فَأَجَابَهُ مُوسَى: «هَذَا لَيْسَ هُتَافَ نَصْرَةٍ وَلا صُرَاخَ هَزِيمَةٍ، لَكِنْ مَا أَسْمَعُهُ هُوَ صَوْتُ غِنَاءٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","وَمَا إِنِ اقْتَرَبَ مُوسَى مِنَ الْمُخَيَّمِ وَشَاهَدَ الْعِجْلَ وَالرَّقْصَ حَتَّى احْتَدَمَ غَضَبُهُ وَأَلْقَى بِاللَّوْحَيْنِ مِنْ يَدِهِ وَكَسَّرَهُمَا عِنْدَ سَفْحِ الْجَبَلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ثُمَّ أَخَذَ العِجْلَ الذَّهَبِيَّ وَأَحْرَقَهُ بِالنَّارِ وَطَحَنَهُ حَتَّى صَارَ نَاعِماً، وَذَرَّاهُ عَلَى وَجْهِ الْمَاءِ وَأَرْغَمَهُمْ عَلَى الشُّرْبِ مِنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","وَقَالَ مُوسَى لِهرُونَ: «مَاذَا فَعَلَ بِكَ هَذَا الشَّعْبُ حَتَّى جَلَبْتَ عَلَيْهِ هَذِهِ الْخَطِيئَةَ الْعَظِيمَةَ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","فَأَجَابَ هَرُونُ: «لا يَحْتَدِمْ غَضَبُ سَيِّدِي. إِنَّكَ تَعْرِفُ شَرَّ هَذَا الشَّعْبِ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","لَقَدْ قَالُوا لِي: اصْنَعْ لَنَا إِلَهاً يَتَقَدَّمُنَا فِي مَسِيرِنَا، لأَنَّنَا لَا نَدْرِي مَاذَا أَصَابَ هَذَا الرَّجُلَ مُوسَى الَّذِي أَخْرَجَنَا مِنْ دِيَارِ مِصْرَ، ");
INSERT INTO arbnav_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","فَقُلْتُ لَهُمْ مَنْ لَدَيْهِ ذَهَبٌ فَلْيَنْزِعْهُ وَيُعْطِنِي إِيَّاهُ، فَطَرَحْتُهُ فِي النَّارِ فَخَرَجَ هَذَا الْعِجْلُ». ");
INSERT INTO arbnav_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","وَلَمَّا رَأَى مُوسَى أَنَّ الشَّعْبَ غَارِقٌ فِي مُجُونِهِ بَعْدَ أَنْ أَفْلَتَ هَرُونُ زِمَامَهُمْ فَصَارُوا بِذَلِكَ مَثَارَ سُخْرِيَةِ أَعْدَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","وَقَفَ فِي بَابِ الْمُخَيَّمِ وَصَاحَ: «كُلُّ مَنْ يَتْبَعُ الرَّبَّ فَلْيُقْبِلْ إِلَيَّ هُنَا». فَاجْتَمَعَ حَوْلَهُ اللّاوِيُّونَ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","فَهَتَفَ بِهِمْ: «هَذَا مَا يُعْلِنُهُ الرَّبُّ إِلَهُ بَنِي إِسْرَائِيلَ: لِيَتَقَلَّدْ كُلُّ وَاحِدٍ سَيْفَهُ، وَجُولُوا فِي الْمُخَيَّمِ ذِهَاباً وَإِيَاباً مِنْ مَدْخَلٍ إِلَى مَدْخَلٍ، وَاقْتُلُوا كُلَّ دَاعِرٍ أَخاً كَانَ أَمْ صَاحِباً أَمْ قَرِيباً». ");
INSERT INTO arbnav_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","فَأَطَاعَ اللّاوِيُّونَ أَمْرَ مُوسَى. فَقُتِلَ مِنَ الشَّعْبِ فِي ذَلِكَ الْيَوْمِ نَحْوَ ثَلاثَةِ آلافِ رَجُلٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","عِنْدَئِذٍ قَالَ مُوسَى لِلّاوِيِّينَ: «لَقَدْ كَرَّسْتُمُ الْيَوْمَ أَنْفُسَكُمْ لِخِدْمَةِ الرَّبِّ، وَقَدْ كَلَّفَ ذَلِكَ كُلَّ وَاحِدٍ مِنْكُمْ قَتْلَ ابْنِهِ أَوْ أَخِيهِ، وَلِكِنْ لِيُنْعِمْ عَلَيْكُمُ الرَّبُّ فِي هَذَا اليَوْمِ بِبَرَكَةٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","وَفِي الْغَدِ قَالَ مُوسَى لِلشَّعْبِ: «لَقَدِ ارْتَكَبْتُمْ خَطِيئَةً عَظِيمَةً، وَهَا أَنَا أَعُودُ إِلَى الْجَبَلِ لأَمْثُلَ أَمَامَ الرَّبِّ، لَعَلِّي أَحْظَى لَكُمْ بِغُفْرَانِهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","وَرَجَعَ مُوسَى إِلَى الرَّبِّ وَتَضَرَّعَ قَائِلاً: «يَا رَبُّ لَقَدِ اقْتَرَفَ هَذَا الشَّعْبُ خَطِيئَةً عَظِيمَةً، وَصَاغُوا لأَنْفُسِهِمْ إِلَهاً مِنْ ذَهَبٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","وَالآنَ إِنْ شِئْتَ، فَاغْفِرْ لَهُمْ، وَإلَّا فَامْحُنِي مِنْ كِتَابِكَ الَّذِي كَتَبْتَ». ");
INSERT INTO arbnav_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","فَأَجَابَ الرَّبُّ مُوسَى: «الَّذِي أَخْطَأَ إِلَيَّ أَمْحُوهُ مِنْ كِتَابِي ");
INSERT INTO arbnav_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","وَالآنَ اذْهَبْ، وَقُدِ الشَّعْبَ إِلَى الْمَكَانِ الَّذِي ذَكَرْتُهُ لَكَ. وَهَا هُوَ مَلاكِي يَتَقَدَّمُكَ، وَلَكِنْ لابُدَّ مِنْ مُعَاقَبَةِ الشَّعْبِ عَلَى خَطِيئَتِهِمْ فِي يَوْمِ قَضَائِي». ");
INSERT INTO arbnav_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","وَضَرَبَ الرَّبُّ الشَّعْبَ بالْوَبَأِ عِقَاباً لَهُمْ عَلَى عِبَادَةِ الْعِجْلِ الَّذِي صَنَعَهُ هَرُونُ. ");
INSERT INTO arbnav_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","وَقَالَ الرَّبُّ لِمُوسَى: «اتْرُكْ هَذَا الْمَكَانَ أَنْتَ وَالشَّعْبُ الَّذِي أَصْعَدْتَهُ مِنْ دِيَارِ مِصْرَ، وَامْضِ إِلَى الأَرْضِ الَّتِي أَقْسَمْتُ لإِبْرَاهِيمَ وَإِسْحَاقَ وَيَعْقُوبَ قَائِلاً: سَأَهَبُهَا لِنَسْلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","وَسَأُرْسِلُ أَمَامَكَ مَلاكاً، وَأَطْرُدُ الْكَنْعَانِيِّينَ وَالأَمُورِيِّينَ وَالْحِثِّيِّينَ وَالْفَرِزِّيِّينَ وَالْحِوِّيِّينَ وَالْيَبُوسِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","إِنَّهَا أَرْضٌ تَفِيضُ لَبَناً وَعَسَلاً. أَمَّا أَنَا فَلَنْ أَسِيرَ فِي وَسَطِكُمْ لأَنَّكُمْ شَعْبٌ مُتَصَلِّبُ الْقَلْبِ لِئَلّا أَفْنِيَكُمْ فِي الطَّرِيقِ». ");
INSERT INTO arbnav_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","فَلَمَّا سَمِعَ الْشَّعْبُ هَذَا الْكَلامَ الْقَاسِي، شَرَعُوا فِي النَّوْحِ، وَلَمْ يَتَزَيَّنْ أَحَدٌ مِنْهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","وَكَانَ الرَّبُّ قَدْ قَالَ لِمُوسَى: «قُلْ لِبَنِي إِسْرَائِيلَ أَنْتُمْ شَعْبٌ مُتَصَلِّبُ الْقَلْبِ، لِهَذَا إِنْ بَقِيتُ لَحْظَةً وَاحِدَةً فِي وَسَطِكُمْ أَفْنِيكُمْ. وَلَكِنِ الْآنَ انْزَعُوا زِينَتَكُمْ عَنْكُمْ إِلَى أَنْ أَتَّخِذَ قَرَارِي بِشَأْنِكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","فَخَلَعَ الشَّعْبُ زِينَتَهُمْ عِنْدَ جَبَلِ حُورِيبَ. ");
INSERT INTO arbnav_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","وَأَخَذَ مُوسَى خَيْمَةً وَنَصَبَهَا بَعِيداً خَارِجَ الْمُخَيَّمِ، وَدَعَاهَا خَيْمَةَ الاجْتِمَاعِ. فَكَانَ كُلُّ مُلْتَمِسٍ لِلرَّبِّ يَسْعَى إِلَى خَيْمَةِ الاجْتِمَاعِ الْقَائِمَةِ خَارِجَ الْمُخَيَّمِ. ");
INSERT INTO arbnav_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","وَكُلَّمَا مَضَى مُوسَى إِلَى الْخَيْمَةِ، كَانَ كُلُّ وَاحِدٍ مِنَ الشَّعْبِ يَقِفُ فِي بَابِ خَيْمَتِهِ، وَيُتَابِعُونَهُ بِأَنْظَارِهِمْ إِلَى أَنْ يَدْخُلَهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","وَمَا إِنْ يَتَوَارَى مُوسَى فِيهَا، حَتَّى يَنْزِلَ عَمُودُ السَّحَابِ وَيَقِفَ عِنْدَ مَدْخَلِهَا، فَيَتَكَلَّمُ الرَّبُّ مَعَ مُوسَى، ");
INSERT INTO arbnav_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","فَيُشَاهِدُ جَمِيعُ الشَّعْبِ عَمُودَ السَّحَابِ وَاقِفاً عِنْدَ بَابِ الْخَيْمَةِ، فَيَسْجُدُونَ لِلرَّبِّ، كُلُّ وَاحِدٍ أَمَامَ بَابِ خَيْمَتِهِ، ");
INSERT INTO arbnav_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","فَكَانَ الرَّبُّ يُكَلِّمُ مُوسَى وَجْهاً لِوَجْهٍ كَمَا يُكَلِّمُ الإِنْسَانُ صَاحِبَهُ. وَإذَا رَجَعَ مُوسَى إِلَى الْمُخَيَّمِ، كَانَ خَادِمُهُ الشَّابُ يَشُوعُ بْنُ نُونَ يَمْكُثُ دَاخِلَ الْخَيْمَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","وَقَالَ مُوسَى لِلرَّبَّ: «هَا أَنْتَ قَدْ قُلْتَ لِي: قُدْ هَذَا الشَّعْبَ، وَلَكِنْ لَمْ تُعْلِمْنِي مَنْ سَتُرْسِلُ مَعِي. ثُمَّ قُلْتَ: إِنِّي عَرَفْتُكَ بِاسْمِكَ وَحَظِيتَ بِرِضَايْ. ");
INSERT INTO arbnav_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","فَالآنَ إِنْ كُنْتُ حَقّاً قَدْ حَظِيتُ بِرِضَاكَ، فَأَرْشِدْنِي إِلَى طَرِيقِكَ لِكَيْ أَسْلُكَ حَسَبَ قَصْدِكَ، وَأَحْظَى بِمَسَرَّتِكَ، وَاذْكُرْ أَيْضاً أَنَّ هَذِهِ الأُمَّةَ هِيَ شَعْبُكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","فَأَجَابَهُ: «إِنِّي أُرَافِقُكَ فَأُرِيحُكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","فَقَالَ مُوسَى: «إِنْ لَمْ تُرَافِقْنَا، فَلا تُصْعِدْنَا مِنْ هُنَا، ");
INSERT INTO arbnav_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","إِذْ كَيْفَ يُدْرَكُ أَنَّنِي وَشَعْبَكَ قَدْ حَظِينَا بِرِضَاكَ؟ أَلَيْسَ بِمُرَافَقَتِكَ لَنَا، فَنَتَمَيَّزُ أَنَا وَشَعْبُكَ بِذَلِكَ عَنْ جَمِيعِ الشُّعُوبِ السَّاكِنِينَ فِي الأَرْضِ؟» ");
INSERT INTO arbnav_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","فَأَجَابَ الرَّبُّ مُوسَى: «سَأَفْعَلُ عَيْنَ هَذَا الأَمْرِ الَّذِي الْتَمَسْتَهُ. لأَنَّكَ حَظِيتَ بِرِضَايْ وَأَنَا عَرَفْتُكَ بِاسْمِكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","وَقَالَ مُوسَى: «أَرِنِي مَجْدَكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","فَقَالَ الرَّبُّ: «أُجِيزُ إِحْسَانَاتِي أَمَامَكَ، وَأُذِيعُ اسْمِي (الرَّبَّ) أَمَامَكَ. أُغْدِقُ رَأْفَتِي عَلَى مَنْ أَشَاءُ وَرَحْمَتِي عَلَى مَنْ أُرِيدُ»، ");
INSERT INTO arbnav_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","وَأَضَافَ: «وَلَكِنَّكَ لَنْ تَرَى وَجْهِي، لأَنَّ الإِنْسَانَ الَّذِي يَرَانِي لَا يَعِيشُ». ");
INSERT INTO arbnav_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ثُمَّ قَالَ الرَّبُّ: «لَدَيَّ مَكَانٌ قَرِيبٌ مِنِّي. فَقِفْ عَلَى الصَّخْرَةِ، ");
INSERT INTO arbnav_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","وَعِنْدَمَا يَعْبُرُ مَجْدِي، أَضَعُكَ فِي نُقْرَةٍ مِنَ الصَّخْرِ، وَأَحْجُبُكَ بِيَدِي حَتَّى أَعْبُرَ، ");
INSERT INTO arbnav_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ثُمَّ أَرْفَعُ يَدِي فَتَنْظُرُ وَرَائِي، أَمَّا وَجْهِي فَيَظَلُّ مَحْجُوباً عَنِ الْعِيَانِ». ");
INSERT INTO arbnav_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: «انْحَتْ لَكَ لَوْحَينِ مِنْ حَجَرٍ مِثْلَ اللَّوْحَينِ الأَوَّلَيْنِ. فَأَكْتُبَ أَنَا عَليْهِمَا الْكَلِمَاتِ الَّتِي دَوَّنْتُهَا عَلَى اللَّوْحَينِ الأَوَّلَيْنِ اللَّذَيْنِ كَسَرْتَهُمَا. ");
INSERT INTO arbnav_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","وَتَأَهَّبْ فِي الصَّبَاحِ ثُمَّ اصْعَدْ إِلَى جَبَلِ سِينَاءَ، وَامْثُلْ أَمَامِي هُنَاكَ عَلَى قِمَّةِ الجَبَلِ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","وَلا يَصْعَدْ مَعَكَ أَحَدٌ، وَلا يُشَاهَدْ عَلَى الجَبَلِ إِنْسَانٌ، وَلا تَرْعَ الْغَنَمُ أَيْضاً وَالْبَقَرُ بِاتِّجَاهِ هَذَا الجَبَلِ». ");
INSERT INTO arbnav_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","فَنَحَتَ مُوسَى لَوْحَيْنِ مِنْ حَجَرٍ مُمَاثِلَيْنِ لِلأَوَّلَيْنِ، وَبَكَّرَ فِي الصَّبَاحِ وَصَعِدَ إِلَى جَبَلِ سِينَاءَ حَسَبَ أَمْرِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","فَنَزَلَ بِهَيْئَةِ سَحَابٍ، وَوَقَفَ مَعَهُ هُنَاكَ حَيْثُ أَعْلَنَ لَهُ اسْمَهُ: «الرَّبُّ»، ");
INSERT INTO arbnav_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","وَعَبَرَ مِنْ أَمَامِ مُوسَى مُنَادِياً: «أَنَا الرَّبُّ. الرَّبُّ إِلَهٌ رَؤُوفٌ رَحِيمٌ، بَطِيءُ الْغَضَبِ وَكَثِيرُ الإِحْسَانِ وَالْوَفَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","أَدَّخِرُ الإِحْسَانَ وَأَغْفِرُ الإِثْمَ وَالْمَعْصِيَةَ وَالْخَطِيئَةَ. وَلَكِنِّي لَا أُعْفِي الْمُذْنِبَ مِنَ الْعِقَابِ، بَلْ أَفْتَقِدُ إِثْمَ الآبَاءِ فِي الأَبْنَاءِ وَالأَحْفَادِ حَتَّى الْجِيلِ الرَّابِعِ». ");
INSERT INTO arbnav_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","فَخَرَّ مُوسَى فِي الحَالِ وَسَجَدَ، ");
INSERT INTO arbnav_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","وَقَالَ: «إِنْ حَظِيتُ بِرِضَاكَ أَيُّهَا السَّيِّدُ، فَلْيُرَافِقْنَا الرَّبُّ فِي مَسِيرِنَا. وَمَعَ أَنَّ هَذَا الشَّعْبَ عَنِيدٌ. لَكِنِ اصْفَحْ عَنْ إِثْمِنَا وَخَطِيئَتِنَا وَاتَّخِذْنَا شَعْباً خَاصّاً لَكَ». ");
INSERT INTO arbnav_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","فَأَجَابَ الرَّبُّ: «هَا أَنَا أَقْطَعُ مَعَكَ عَهْداً، فَأُجْرِي أَمَامَ جَمِيعِ شَعْبِكَ مُعْجِزَاتٍ لَمْ يُجْرَ مَثِيلُهَا فِي جَمِيعِ أُمَمِ الأَرْضِ كُلِّهَا، فَيَشْهَدُ الشَّعْبُ الَّذِي تُقِيمُ فِي وَسَطِهِ، الْفِعْلَ الْمَهُولَ الَّذِي أَصْنَعُهُ مِنْ أَجْلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","وَلَكِنْ أَطِعْ مَا أَوْصَيْتُكَ الْيَوْمَ بِهِ. هَا أَنَا طَارِدٌ مِنْ أَمَامِكَ الأَمُورِيِّينَ وَالْكَنْعَانِيِّينَ وَالْحِثِّيِّينَ وَالْفَرِزِّيِّينَ وَالْحِوِّيِّينَ وَالْيَبُوسِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","إِيَّاكَ أَنْ تَعْقِدَ مُعَاهَدَةً مَعَ سُكَّانِ الأَرْضِ الَّتِي أَنْتَ مَاضٍ إِلَيْهَا لِئَلّا يَكُونُوا شَرَكاً لَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","بَلِ اهْدِمُوا مَذَابِحَهُمْ، وَاكْسِرُوا أَصْنَامَهُمْ، وَاقْطَعُوا أَشْجَارَهُمُ الْمُقَدَّسَةَ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","إِيَّاكُمْ أَنْ تَعْبُدُوا إِلَهاً آخَرَ غَيْرِي، لأَنَّ الرَّبَّ اسْمُهُ غَيُورٌ جِدّاً. ");
INSERT INTO arbnav_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","إِيَّاكُمْ أَنْ تَعْقِدُوا مُعَاهَدَةً مَعَ سُكَّانِ الأَرْضِ، لأَنَّهُمْ حِينَ يَعْبُدُونَ آلِهَتَهُمْ مُشْرِكِينَ وَيَذْبَحُونَ لَهُمْ، يَدْعُونَكُمْ فَتَأْكُلُونَ مِنْ ذَبِيحَتِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","وَتُزَوِّجُونَ بَنِيكُمْ مِنْ بَنَاتِهِمْ، فَيَجْعَلْنَ بَنِيكُمْ يَغْوُونَ أَيْضاً بِعِبَادَةِ آلِهَتِهِنَّ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","إِيَّاكَ أَنْ تَصْنَعَ آلِهَةً مَسْبُوكَةً. ");
INSERT INTO arbnav_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","احْتَفِلُوا بِعِيدِ الْفَطِيرِ، فَتَأْكُلُونَ فَطِيراً سَبْعَةَ أَيَّامٍ كَمَا أَمَرْتُكُمْ فِي شَهْرِ أَبِيبَ (أَيْ شَهْرِ نِيسَانَ وَهُوَ الشَّهْرُ الأَوَّلُ مِنَ السَّنَةِ الْعِبْرِيَّةِ)، لأَنَّكُمْ فِي هَذَا الشَّهْرِ خَرَجْتُمْ مِنْ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","كُلُّ بِكْرٍ ذَكَرٍ هُوَ لِي، وَكَذَلِكَ كُلُّ بِكْرٍ مِنْ مَاشِيَتِكَ مِنَ الثِّيرَانِ وَالْخِرْفَانِ وَالْمَاعِزِ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","أَمَّا بِكْرُ الْحِمَارِ فَتَفْدِيهِ بِحَمَلٍ، وَإلَّا تَدُقُّ عُنُقَهُ. كُلُّ ابْنٍ بِكْرٍ لَكَ تَفْدِيهِ بِحَمَلٍ. لَا تَمْثُلُوا أَمَامِي بِأَيْدٍ فَارِغَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","فِي سِتَّةِ أَيَّامٍ تَعْمَلُ، وَفِي الْيَوْمِ الْسَّابِعِ تَسْتَرِيحُ، حَتَّى لَوْ كَانَ ذَلِكَ فِي مَوَاسِمِ الْفَلاحَةِ وَالْحَصَادِ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","احْتَفِلُوا أَيْضاً بِعِيدِ الأَسَابِيعِ فِي أَوَّلِ حَصَادِ الْقَمْحِ. وَبِعِيدِ الْجَمْعِ فِي آخِرِ السَّنَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","عَلَى جَمِيعِ الذُّكُورِ أَنْ يَمْثُلُوا ثَلاثَ مَرَّاتٍ فِي السَّنَةِ أَمَامَ السَّيِّدِ الرَّبِّ إِلَهِ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","هَا أَنَا أَطْرُدُ الأُمَمَ مِنْ أَمَامِكُمْ، وَأُوَسِّعُ حُدُودَكُمْ، وَلَنْ يَطْمَعَ أَحَدٌ فِي أَرْضِكُمْ حِينَ تَصْعَدُونَ لِلْمُثُولِ أَمَامَ الرَّبِّ إِلَهِكُمْ ثَلاثَ مَرَّاتٍ فِي السَّنَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","لَا تُقَرِّبْ دَمَ ذَبِيحَةٍ مَعَ عَجِينٍ مُخْتَمِرٍ. وَلا تَتْرُكْ شَيْئاً مِنْ ذَبِيحَةِ الْفِصْحِ إِلَى الْيَوْمِ التَّالِي. ");
INSERT INTO arbnav_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","تُحْضِرُ إِلَى بَيْتِ الرَّبِّ إِلَهِكَ بَاكُورَةَ ثِمَارِ أَرْضِكَ. وَلا تَطْبُخْ جَدْياً فِي لَبَنِ أُمِّهِ». ");
INSERT INTO arbnav_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","وَاسْتَطْرَدَ الرَّبُّ: «دَوِّنْ هَذِهِ الْكَلِمَاتِ، لأَنَّنِي قَطَعْتُ مَعَكَ وَمَعَ إِسْرَائِيلَ عَهْداً بُناءً عَلَيْهَا». ");
INSERT INTO arbnav_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","وَمَكَثَ مُوسَى فِي حَضْرَةِ الرَّبِّ أَرْبَعِينَ يَوْماً وَأَرْبَعِينَ لَيْلَةً، لَمْ يَأْكُلْ فِيهَا خُبْزاً، وَلَمْ يَشْرَبْ مَاءً. فَدَوَّنَ عَلَى اللَّوْحَينِ كَلِمَاتِ العَهْدِ، أَيِ الْوَصَايَا الْعَشْرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","وَعِنْدَمَا انْحَدَرَ مِنْ جَبَلِ سِينَاءَ حَامِلاً بِيَدَيْهِ لَوْحَيِ الشَّهَادَةِ، لَمْ يَكُنْ يَدْرِي أَنَّ وَجْهَهُ كَانَ يَلْمَعُ لأَنَّهُ كَانَ يَتَحَدَّثُ مَعَ اللهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","وَحِينَ شَاهَدَ هَرُونُ وَبَنُو إِسْرَائِيلَ مُوسَى، كَانَ وَجْهُهُ لامِعاً، فَخَافُوا أَنْ يَقْتَرِبُوا مِنْهُ، ");
INSERT INTO arbnav_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","فَدَعَاهُمْ مُوسَى فَرَجَعَ إِلَيْهِ هَرُونُ وَرُؤَسَاءُ الشَّعْبِ فَخَاطَبَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","وَمَا لَبِثَ أَنِ اقْتَرَبَ مِنْهُ جَمِيعُ بَنِي إِسْرَائِيلَ، فَتَلا عَلَيْهِمْ كُلَّ الْوَصَايَا الَّتِي أَمْلاهَا الرَّبُّ فِي جَبَلِ سِينَاءَ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","وَعِنْدَمَا أَنْهَى مُوسَى حَدِيثَهُ مَعَهُمْ، وَضَعَ عَلَى وَجْهِهِ بُرْقُعاً، ");
INSERT INTO arbnav_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","كَانَ يَخْلَعُهُ عِنْدَ مُثُولِهِ أَمَامَ الرَّبِّ لِيَتَحَادَثَ مَعَهُ إِلَى أَنْ يَنْصَرِفَ مِنْ لَدُنْهِ، ثُمَّ يَخْرُجُ لِيُخَاطِبَ بَنِي إِسْرَائِيلَ بِمَا أَوْصَاهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","فَإِذَا عَايَنَ بَنُو إِسْرَائِيلَ لَمَعَاناً فِي جِلْدِ وَجْهِ مُوسَى، كَانَ يَرُدُّ الْبُرْقُعَ إِلَى حِينِ دُخُولِهِ إِلَى الْخَيْمَةِ لِلتَّحَدُّثِ مَعَ الرَّبِّ فَيَرْفَعُهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","وَعَقَدَ مُوسَى اجْتِمَاعاً لِكُلِّ شَعْبِ إِسْرَائِيلَ وَقَالَ لَهُمْ: «هَذِهِ هِيَ الأُمُورُ الَّتِي أَوْصَى الرَّبُّ أَنْ تُطِيعُوهَا: ");
INSERT INTO arbnav_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","سِتَّةَ أَيَّامٍ تَنْصَرِفُونَ فِيهَا إِلَى أَعْمَالِكُمْ. أَمَّا السَّابِعُ فَيَكُونُ يَوْمَ رَاحَةٍ لَكُمْ مُقَدَّساً لِعِبَادَةِ الرَّبِّ. كُلُّ مَنْ يَقُومُ فِيهِ بِأَيِّ عَمَلٍ يُقْتَلُ. ");
INSERT INTO arbnav_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","لَا تُوْقِدُوا نَاراً فِي بُيُوتِكُمْ فِي يَوْمِ السَّبْتِ». ");
INSERT INTO arbnav_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ثُمَّ قَالَ مُوسَى لِكُلِّ شَعْبِ إِسْرَائِيلَ: «هَذَا هُوَ أَمْرُ الرَّبِّ: ");
INSERT INTO arbnav_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","هَاتُوا مِمَّا لَدَيْكُمْ تَقْدِمَةً لِلرَّبِّ. كُلُّ مَنْ هُوَ سَخِيُّ النَّفْسِ فَلْيَتَبَرَّعْ بِتَقْدِمَةٍ لِلرَّبِّ: ذَهَباً وَفِضَّةً وَنُحَاساً، ");
INSERT INTO arbnav_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","وَأَقْمِشَةً زَرْقَاءَ وَبَنَفْسَجِيَّةً وَحَمْرَاءَ، وَمَنْسُوجَاتٍ كَتَّانِيَّةً، وَمِنْ شَعْرِ الْمِعْزَى، ");
INSERT INTO arbnav_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","وَجُلُودَ كِبَاشٍ، وَجُلُودَ دُلْفِينٍ، وَخَشَبَ السَّنْطِ، ");
INSERT INTO arbnav_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","وَزَيْتاً لِلإِنَارَةِ، وَأَطْيَاباً لِدُهْنِ الْمَسْحَةِ وَلِلْبَخُورِ الْعَطِرِ، ");
INSERT INTO arbnav_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","وَحِجَارَةَ جَزْعٍ، وَحِجَارَةً كَرِيمَةً لِتَرْصِيعِ الرِّدَاءِ وَالصُّدْرَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","وَلْيَتَقَدَّمْ كُلُّ صَانِعٍ مَاهِرٍ بَيْنَكُمْ لِتَنْفِيذِ مَا أَمَرَ بِهِ الرَّبُّ: ");
INSERT INTO arbnav_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","المَسْكَنَ وَخَيْمَتَهُ وَسُقُوفَهَا وَمَشَابِكَهَا وَأَلْوَاحَهَا وَعَوَارِضَهَا وَأَعْمِدَتَهَا وَقَوَاعِدَ الأَعْمِدَةِ، ");
INSERT INTO arbnav_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","وَالتَّابُوتَ وَعَصَوَيْهِ، وَغِطَاءَ الْكَفَّارَةِ، وَالسِّتَارَ الَّذِي يَحْجُبُ الْتَّابُوتَ، ");
INSERT INTO arbnav_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","وَالْمَائِدَةَ وَعَصَوَيْهَا، وَجَمِيعَ أَوَانِيهَا، وَخُبْزَ التَّقْدِمَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","وَمَنَارَةَ الإِضَاءَةِ وَأَوَانِيهَا وَسُرُجَهَا وَزَيْتَ ضَوْئِهَا، ");
INSERT INTO arbnav_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","وَمَذْبَحَ الْبَخُورِ وَعَصَوَيْهِ، وَدُهْنَ الْمَسْحَةِ، وَالْبَخُورَ الْعَطِرَ، وَسِتَارَ بَابِ مَدْخَلِ الْمَسْكِنِ، ");
INSERT INTO arbnav_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","وَمَذْبَحَ الْمُحْرَقَةِ، وَشَبَكَتَهُ النُّحَاسِيَّةَ وَعَصَوَيْهِ وَكُلَّ أَوَانِيهِ، وَحَوْضَ الاغْتِسَالِ وَقَاعِدَتَهُ، ");
INSERT INTO arbnav_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","وَسَتَائِرَ سَاحَةِ الْمَسْكِنِ وَأَعْمِدَتَهَا، وَقَوَاعِدَ الأَعْمِدَةِ، وَسِتَارَ السَّاحَةِ، ");
INSERT INTO arbnav_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","وَأَوْتَادَ الْخَيْمَةِ وَالسَّاحَةِ وَحِبَالَهُمَا، ");
INSERT INTO arbnav_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","وَثِيَابَ هَرُونَ الْكَاهِنِ، وَثِيَابَ بَنِيهِ الْمُقَدَّسَةَ، وَالثِّيَابَ الْمَنْسُوجَةَ لِلْخِدْمَةِ فِي الْمَقْدِسِ». ");
INSERT INTO arbnav_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","فَانْصَرَفَ كُلُّ شَعْبِ إِسْرَائِيلَ مِنْ قُدَّامِ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ثُمَّ أَقْبَلَ كُلُّ مَنْ حَثَّهُ قَلْبُهُ، وَكُلُّ مَنْ سَخَتْ نَفْسُهُ، حَامِلِينَ تَقْدِمَةَ الرَّبِّ، لإِقَامَةِ خَيْمَةِ الاجْتِمَاعِ وَأَوَانِي خِدْمَتِهَا وَلِتَجْهِيزِ الثِّيَابِ الْمُقَدَّسَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","وَتَوَافَدَ الرِّجَالُ مَعَ النِّسَاءِ مِنْ ذَوِي النُّفُوسِ السَّخِيَّةِ، مُتَبَرِّعِينَ بِأَسَاوِرَ وَأَقْرَاطٍ وَخَوَاتِمَ وَقَلائِدَ وَغَيْرِ ذَلِكَ مِنَ الأَمْتِعَةِ الذَّهَبِيَّةِ، فَكَانَتْ كُلُّ تَقْدِمَاتِ الْمُتَبَرِّعِينَ مِنَ الذَّهَبِ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","وَكَذَلِكَ كُلُّ مَنْ وُجِدَ لَدَيْهِ أَقْمِشَةٌ زَرْقَاءُ وَبَنَفْسَجِيَّةٌ وَحَمْرَاءُ، وَمَنْسُوجَاتٌ كَتَّانِيَّةٌ، وَمِنْ شَعْرِ الْمِعْزَى، وَجُلُودُ كِبَاشٍ، وَجُلُودُ دُلْفِينٍ، تَبَرَّعَ بِها. ");
INSERT INTO arbnav_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","وَمِنْهُمْ أَيْضاً مَنْ تَبَرَّعَ بِتَقْدِمَاتِ فِضَّةٍ وَنُحَاسٍ، جَاءَ بِها لِلرَّبِّ وَكُلُّ مَنْ وُجِدَ لَدَيْهِ خَشَبُ سَنْطٍ صَالِحٌ لِلاسْتِخْدَامِ فِي عَمَلٍ مَا، تَبَرَّعَ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","وَغَزَلَتْ جَمِيعُ النِّسَاءِ الْمَاهِرَاتِ بِأَيْدِيهِنَّ مَنْسُوجَاتٍ مِنْ خُيُوطٍ زَرْقَاءَ وَبَنَفْسَجِيَّةٍ وَحَمْرَاءَ، وَمَنْسُوجَاتٍ كَتَّانِيَّةً، ");
INSERT INTO arbnav_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","كَمَا غَزَلَتِ النِّسَاءُ اللَّوَاتِي حَثَّتْهُنَّ قُلُوبُهُنَّ، مَنْسُوجَاتٍ مِنْ شَعْرِ الْمِعْزَى. ");
INSERT INTO arbnav_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","وَتَبَرَّعَ وُجَهَاءُ الشَّعْبِ بِحِجَارَةِ الْجَزْعِ وَحِجَارَةٍ كَرِيمَةٍ لِتَرْصِيعِ الرِّدَاءِ وَالصُّدْرَةِ، ");
INSERT INTO arbnav_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","وَبِالأَطْيَابِ وَزَيْتِ الإِنَارَةِ وَلِدُهْنِ الْمَسْحَةِ وَلِلْبَخُورِ الْعَطِرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","فَتَبَرَّعَ جَمِيعُ الرِّجَالِ وَالنِّسَاءِ مِنْ بَنِي إِسْرَائِيلَ، مِمَّنْ سَخَتْ قُلُوبُهُمْ، مُقَدِّمِينَ شَيْئاً لِلرَّبِّ لِتَنْفِيذِ كُلِّ الْعَمَلِ الَّذِي كَلَّفَ الرَّبُّ مُوسَى بِالإِشْرَافِ عَلَى إِنْجَازِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","وَقَالَ مُوسَى لِبَنِي إِسْرَائِيلَ: «هَا إِنَّ الرَّبَّ قَدْ دَعَا بَصَلْئِيلَ بْنَ أُورِي حَفِيدَ حُورٍ، مِنْ سِبْطِ يَهُوذَا بِاسْمِهِ، ");
INSERT INTO arbnav_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","وَمَلأَهُ مِنْ رُوحِ اللهِ وَوَهَبَهُ الْحِكْمَةَ وَالْمَهَارَةَ وَالْمَعْرِفَةَ فِي كُلِّ أَنْوَاعِ الْحِرَفِ، ");
INSERT INTO arbnav_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","لاِبْتِكَارِ فُنُونِ التَّصْمِيمَاتِ الْمَصْنُوعَةِ مِنَ الذَّهَبِ وَالْفِضَّةِ وَالنُّحَاسِ، ");
INSERT INTO arbnav_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","وَنَقْشِ الْحِجَارَةِ وَتَرْصِيعِهَا، وَنِجَارَةِ الْخَشَبِ، وَلِيَكُونَ مُحْتَرِفاً لِكُلِّ صِنَاعَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","وَقَدْ مَنَحَهُ الرَّبُّ هُوَ وَأَهُولِيآبَ بْنَ أَخِيسَامَاكَ مِنْ دَانٍ، الْقُدْرَةَ عَلَى تَعْلِيمِ الآخَرِينَ. ");
INSERT INTO arbnav_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","وَجَعَلَهُمَا حَاذِقَيْنِ مُتَفَوِّقَيْنِ فِي صِنَاعَةِ نَقْشِ الْجَوَاهِرِ وَالنِّجَارَةِ وَالْحِيَاكَةِ، وَتَطْرِيزِ الْمَنْسُوجَاتِ الزَّرْقَاءِ وَالْبَنَفْسَجِيَّةِ وَالْحَمْرَاءِ وَالْمَنْسُوجَاتِ الْكَتَّانِيَّةِ، وَسَائِرِ حِرَفِ النَّسِيجِ، وَفِي كُلِّ حِرْفَةِ صَانِعٍ وَمُبْتَكِرِ تَصْمِيمٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","وَهَكَذَا يَقُومُ بَصَلْئِيلُ وَأَهُولِيَآبُ وَكُلُّ صَانِعٍ حَاذِقٍ وَهَبَهُ الرَّبُّ مَقْدِرَةً فِي تَنْفِيذِ بِنَاءِ خَيْمَةِ الْاِجْتِمَاعِ، بِإِنْجَازِ الْعَمَلِ، بِحَسَبِ كُلِّ مَا أَمَرَ بِهِ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ثُمَّ اسْتَدْعَى مُوسَى بَصَلْئِيلَ وَأَهُولِيآبَ وَكُلَّ صَانِعٍ مَاهِرٍ وَهَبَهُ الرَّبُّ حَذَاقَةً، وَكُلَّ مَنْ حَثَّهُ قَلْبُهُ عَلَى الْمُسَاهَمَةِ فِي إِنْجَازِ عَمَلٍ مَّا. ");
INSERT INTO arbnav_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","وَتَسَلَّمُوا مِنْ مُوسَى جَمِيعَ تَقْدِمَاتِ بَنِي إِسْرَائِيلَ، الَّتِي تَبَرَّعُوا بِها لِبنَاءِ الْمَقْدِسِ. وَظَلَّ الشَّعْبُ يَأْتُونَ كُلَّ صَبَاحٍ بِمَزِيدٍ مِنَ التَّبَرُّعَاتِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","فَأَقْبَلَ الصُّنَّاعُ الْمَهَرَةُ الْقَائِمُونَ بِأَعْمَالِ الْمَقْدِسِ، مِنْ مَهَامِّهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","وَقَالُوا لِمُوسَى: «إِنَّ الشَّعْبَ يَأْتِي بِمَا يَفِيضُ عَمَّا نَحْتَاجُ إِلَيْهِ لإِنْجَازِ الْعَمَلِ الَّذِي أَمَرَ بِهِ الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","فَأَمَرَ مُوسَى أَنْ يُذِيعُوا فِي الْمُخَيَّمِ بِالامْتِنَاعِ عَنْ تَقْدِيمِ تَبَرُّعَاتٍ. فَكَفَّ الشَّعْبُ عَنْ ذَلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","لأَنَّ مَا لَدَيْهِمْ، كَانَ كَافِياً لِتَنْفِيذِ الْعَمَلِ كُلِّهِ، وَأَكْثَرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","أَمَّا الصُّنَّاعُ الْحَاذِقُونَ بَيْنَ الْحِرَفِيِّينَ فَقَدْ صَنَعُوا سَقْفَ الْمَسْكَنِ مِنْ عَشْرِ قِطَعٍ مِنْ كَتَّانٍ مَبْرُومٍ، ذَاتِ أَلْوَانٍ زَرْقَاءَ وَبَنَفْسَجِيَّةٍ وَحَمْرَاءَ، طَرَّزَ عَلَيْهَا حَائِكٌ مَاهِرٌ رَسْمَ الْكَرُوبِيمِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","وَكَانَ طُولُ كُلِّ قِطْعِةٍ ثَمانِي وَعِشْرِينَ ذِرَاعاً (نَحْوَ أَرْبَعَةَ عَشَرَ مِتْراً) وَعَرْضُهُ أَرْبَعَ أَذْرُعٍ (نَحْوَ مِتْرَيْنِ). فَكَانَتْ جَمِيعُهَا ذَاتَ قِيَاسٍ وَاحِدٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","وَوَصَلُوا خَمْسَ قِطَعٍ مِنْهَا بَعْضَهَا بِبَعْضٍ، وَكَذَلِكَ وُصِلَتِ الْقِطَعُ الْخَمْسُ الأُخْرَى ");
INSERT INTO arbnav_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","وَصَنَعُوا عُرىً مِنْ قُمَاشٍ عَلَى حَاشِيَةِ الطَّرَفِ الْوَاحِدِ مِنَ الْقِطَعِ الْمَوْصُولَةِ الأُولَى، وَكَذَلِكَ فَعَلُوا أَيْضاً فِي حَاشِيَةِ الطَّرَفِ الأَخِيرِ مِنَ الْقِطَعِ الأُخْرَى الْمَوْصُولَةِ ");
INSERT INTO arbnav_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","فَكَانَ فِي الطَّرَفِ الأَخِيرِ مِنَ الْمَجْمُوعَةِ الأُولَى خَمْسُونَ عُرْوَةً، وَخَمْسُونَ عُرْوَةً فِي طَرَفِ الْمَجْمُوعَةِ الثَّانِيَةِ، الْوَاحِدَةُ مُقَابِلَ الأُخْرَى. ");
INSERT INTO arbnav_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","وَصَنَعُوا خَمْسِينَ مِشْبَكاً مِنْ ذَهَبٍ وُصِلَتْ بِها عُرَى الْمَجْمُوعَتَيْنِ، فَأَصْبَحَتَا سَقْفاً وَاحِداً لِلْمَسْكِنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","وَحَاكُوا أَيْضاً سَقْفاً ثَانِياً لِلْمَسْكَنِ مِنْ إِحْدَى عَشْرَةَ قِطْعَةً، مَصْنُوعةً مِنْ نَسِيجِ شَعْرِ الْمِعْزَى. ");
INSERT INTO arbnav_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","طُولُ الْقِطْعَةِ الْوَاحِدَةِ ثَلاثُونَ ذِرَاعاً (نَحْوَ خَمْسَةَ عَشَرَ مِتْراً) وَعَرْضُهَا أَرْبَعُ أَذْرُعٍ (نَحْوَ مِتْرَيْنِ). فَكَانَتْ جَمِيعُهَا ذَاتَ مِقْيَاسٍ وَاحِدٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","وَوَصَلُوا خَمْسَ قِطَعٍ مَعاً لِتَكُونَ قِطْعَةً وَاحِدَةً، وَكَذَلِكَ فَعَلُوا بِالْقِطَعِ السِّتِّ الأُخْرَى ");
INSERT INTO arbnav_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","وَصَنَعُوا خَمْسِينَ عُرْوَةً عَلَى حَاشِيَةِ طَرَفٍ وَاحِدٍ لِلْمَجْمُوعَةِ الأُولَى، وَثَبَّتُوا خَمْسِينَ عُرْوَةً أُخْرَى عَلَى حَاشِيَةِ طَرَفٍ وَاحِدٍ مِنَ الْمَجْمُوعَةِ الثَّانِيَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","وَصَنَعُوا خَمْسِينَ مِشْبَكاً مِنْ نُحَاسٍ لِتَصِلَ عُرَى الْمَجْمُوعَتَيْنِ مَعاً لِتُصْبِحَا سَقْفاً ثَانِياً لِلْمَسْكَنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","وَعَمِلُوا غِطَاءً لِلْخَيْمَةِ مِنْ جُلُودِ كِبَاشٍ مَدْبُوغَةٍ بِاللَّوْنِ الأَحْمَرِ، وَنَصَبُوا فَوْقَهُ سَقْفاً آخَرَ مِنْ جُلُودٍ بَنَفْسَجِيَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","وَصَنَعُوا جُدْرَانَ الْمَسْكَنِ مِنْ أَلْوَاحٍ قَائِمَةٍ مِنْ خَشَبِ السَّنْطِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","طُولُ اللَّوْحِ مِنْهَا عَشْرُ أَذْرُعٍ (نَحْوَ خَمْسَةِ أَمْتَارٍ) وَعَرْضُهُ ذِرَاعٌ وَنِصْفٌ (نَحْوَ خَمْسَةٍ وَسَبْعِينَ سَنْتِيمِتْراً). ");
INSERT INTO arbnav_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","وَلِكُلِّ لَوْحٍ رِجْلانِ مُتَقَابِلَتَانِ، إِحْدَاهُمَا بِإِزَاءِ الأُخْرَى. هَكَذَا بَنَوْا جَمِيعَ أَلْوَاحِ الْمَسْكَنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","وَجَعَلُوا الْجَانِبَ الْجَنُوبِيَّ لِلْمَسْكَنِ مُكَوَّناً مِنْ عِشْرِينَ لَوْحاً. ");
INSERT INTO arbnav_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","وَصَنَعُوا أَرْبَعِينَ قَاعِدَةً مِنْ فِضَّةٍ تَحْتَ الْعِشْرِينَ لَوْحاً. فَكَانَ لِكُلِّ لَوْحٍ مُنْفَرِدٍ قَاعِدَتَانِ لِرِجْلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","أَمَّا جَانِبُ الْمَسْكَنِ الثَّانِي الشِّمَالِيُّ، فَكَانَ لَهُ أَيْضاً عِشْرُونَ لَوْحاً، ");
INSERT INTO arbnav_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","وَأَرْبَعُونَ قَاعِدَةً مِنْ فِضَّةٍ، فَكَانَ لِكُلِّ لَوْحٍ مُنْفَرِدٍ قَاعِدَتَانِ لِرِجْلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","وَبَنَوْا جِدَارَ مُؤَخَّرِ الْمَسْكَنِ الْغَرْبِيَّ مِنْ سِتَّةِ أَلْوَاحٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","وَصَنَعُوا لَوْحَيْنِ لِزَاوِيَتَيِ الْمَسْكَنِ فِي الْمُؤَخَّرِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","فَكَانَ كُلٌّ مِنْهُمَا مُزْدَوِجاً مِنْ أَسْفَلِهِ إِلَى أَعْلاهُ، حَيْثُ تُثَبَّتُ فِي رَأْسِ كُلِّ مُزْدَوِجٍ حَلَقَةٌ وَاحِدَةٌ. هَكَذَا يَكُونُ كُلٌّ مِنْهُمَا لِلزَّاوِيَتَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","فَكَانَتْ فِي مَجْمُوعِهَا ثَمَانِيَةَ أَلْوَاحٍ وَسِتَّ عَشْرَةَ قَاعِدَةً مِنْ فِضَّةِ، قَاعِدَتَيْنِ لِكُلِّ لَوْحٍ مُنْفَرِدٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","وَصَنَعُوا عَوَارِضَ مِنْ خَشَبِ السَّنْطِ، خَمْساً لأَلْوَاحِ جَانِبِ الْمَسْكَنِ الْجَنُوبِيِّ، ");
INSERT INTO arbnav_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","وَخَمْساً لأَلْوَاحِ جَانِبِ الْمَسْكَنِ الشِّمَالِيِّ، وَخَمْسَ عَوَارِضَ لأَلْوَاحِ مُؤَخَّرِ الْمَسْكَنِ الْغَرْبِيِّ، ");
INSERT INTO arbnav_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","وَجَعَلُوا الْعَارِضَةَ الْوُسْطَى تَنْفُذُ فِي وَسَطِ الأَلْوَاحِ مِنْ طَرَفٍ إِلَى طَرَفٍ ");
INSERT INTO arbnav_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","وَغَشَّوْا الأَلْوَاحَ بِرَقَائِقَ مِنْ ذَهَبٍ. وَصَنَعُوا لَهَا حَلَقَاتٍ مِنْ ذَهَبٍ لِتَكُونَ بُيُوتاً لِلْعَوَارِضِ. وَكَذَلِكَ غَشَّوْا الْعَوَارِضَ بِالذَّهَبِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","وَصَنَعُوا الْحِجَابَ مِنْ كَتَّانٍ مَبْرُومٍ ذِي أَلْوَانٍ زَرْقَاءَ وَبَنَفْسَجِيَّةٍ وَحَمْرَاءَ، بَعْدَ أَنْ حَاكَ عَلَيْهِ حَائِكٌ مَاهِرٌ رَسْمَ الْكَرُوبِيمِ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","وَصَنَعُوا لَهُ أَرْبَعَةَ أَعْمِدَةٍ مِنْ خَشَبِ السَّنْطِ مُغَشَّاةً بِذَهَبٍ، لَهَا أَرْبَعَةُ خَطَاطِيفَ مِنْ ذَهَبٍ، وَقَائِمَةً عَلَى أَرْبَعِ قَوَاعِدَ مِنْ فِضَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","وَنَسَجُوا سِتَاراً لِمَدْخَلِ الْمَسْكَنِ ذَا أَلْوَانٍ زَرْقَاءَ وَبَنَفْسَجِيَّةٍ وَحَمْرَاءَ، وَخُيُوطِ كَتَّانٍ مَبْرُومٍ مِنْ تَطْرِيزِ حَائِكٍ مَاهِرٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","لَهُ خَمْسَةُ أَعْمِدَةٍ، ذَاتِ خَطَاطِيفَ وَغَشَّوْا رُؤُوسَهَا وَقُضْبَانَهَا بِذَهَبٍ وَسَبَكُوا لَهَا خَمْسَ قَوَاعِدَ مِنْ نُحَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ثُمَّ صَنَعَ بَصَلْئِيلُ التَّابُوتَ مِنْ خَشَبِ السَّنْطِ، طُولُهُ ذِرَاعَانِ وَنِصْفٌ (نحْوَ مِتْرٍ وَرُبْعِ الْمِتْرِ) وَعَرْضُهُ ذِرَاعٌ وَنِصْفٌ (نَحْوَ خَمْسَةٍ وَسَبْعِينَ سَنْتِيمِتْراً) وَارْتِفَاعُهُ ذِرَاعٌ وَنِصْفٌ (نَحْوَ خَمْسَةٍ وَسَبْعِينَ سَنْتِيمِتْراً). ");
INSERT INTO arbnav_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","وَغَشَّى جُدْرَانَهُ الدَّاخِلِيَّةَ وَالْخَارِجِيَّةَ بِذَهَبٍ خَالِصٍ، وَجَعَلَ لَهُ إِطَاراً مِنْ ذَهَبٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","وَسَبَكَ لَهُ أَرْبَعَ حَلَقَاتٍ مِنْ ذَهَبٍ، ثَبَّتَهَا عَلَى قَوَائِمِهِ الأَرْبَعِ، حَلْقَتَيْنِ مِنْ كُلِّ جَانِبٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","وَصَنَعَ عَصَوَيْنِ مِنْ خَشَبِ السَّنْطِ غَشَّاهُمَا بِالذَّهَبِ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","وَأَدْخَلَهُمَا فِي الْحَلَقَاتِ الْمُثَبَّتَةِ عَلَى جَانِبَيِ التَّابُوتِ لِيُحْمَلَ بِهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","وَصَنَعَ بَصَلْئِيلُ غِطَاءً مِنْ ذَهَبٍ خَالِصٍ، طُولُهُ ذِرَاعَانِ وَنِصْفٌ (نَحْوَ مِتْرٍ وَرُبْعِ الْمِتْرِ) وَعَرْضُهُ ذِرَاعٌ وَنِصْفٌ (نَحْوَ خَمْسَةٍ وَسَبْعِينَ سَنْتِيمِتْراً) ");
INSERT INTO arbnav_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","وَخَرَطَ كَرُوبَيْنِ مِنْ ذَهَبٍ أَقَامَهُمَا عَلَى طَرَفَيِ الْغِطَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","فَصَنَعَ كَرُوباً وَاحِداً عَلَى كُلِّ طَرَفٍ مِنَ الْغِطَاءِ، مَخْرُوطَيْنِ مِنَ الْغِطَاءِ نَفْسِهِ، وَقَائِمَيْنِ عَلَى طَرَفَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","وَكَانَ الْكَرُوبَانِ مُتَوَاجِهَيْنِ بَاسِطَيْنِ أَجْنِحَتَهُمَا إِلَى فَوْقُ، يُظَلِّلانِ بِهِمَا الْغِطَاءَ، وَيَتَّجِهَانِ بِوَجْهَيْهِمَا نَحْوَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","وَصَنَعَ مَائِدَةً مِنْ خَشَبِ السَّنْطِ طُولُهَا ذِرَاعَانِ (نَحْوَ مِتْرٍ) وَعَرْضُهَا ذِرَاعٌ (نَحْوَ نِصْفِ الْمِتْرِ) وَارْتِفَاعُهَا ذِرَاعٌ وَنِصْفٌ (نَحْوَ خَمْسَةٍ وَسَبْعِينَ سَنْتِيمِتْراً). ");
INSERT INTO arbnav_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","وَغَشَّاهَا بِالذَّهَبِ الْخَالِصِ. وَصَنَعَ لَهَا إِطَاراً عَالِياً مِنَ الذَّهَبِ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","وَأَحَاطَهَا بِحَافَةٍ عَرْضُهَا شِبْرٌ. وَصَنَعَ لِمُحِيطِ الْحَافَةِ إطَاراً مِنْ ذَهَبٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","وَسَبَكَ لَهَا أَرْبَعَ حَلَقَاتٍ مِنْ ذَهَبٍ، ثَبَّتَهَا عَلَى زَوَايَا قَوَائِمِهَا الأَرْبَعِ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","فَكَانَتِ الْحَلَقَاتُ الْمُثَبَّتَةُ عَلَى الْحَافَةِ أَمَاكِنَ لِعَصَوَيْنِ، تُحْمَلُ بِهِمَا الْمَائِدَةُ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","وَصَنَعَ الْعَصَوَيْنِ مِنْ خَشَبِ السَّنْطِ، وَغَشَّاهُمَا بِالذَّهَبِ لِتُحْمَلَ بِهِمَا الْمَائِدَةُ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","أَمَّا صِحَافُ الْمَائِدَةِ وَصُحُونُهَا وَكُؤُوسُهَا وَأَبَارِيقُهَا الَّتِي يُسْكَبُ بِها، فَصَاغَهَا مِنْ ذَهَبٍ خَالِصٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","وَخَرَطَ الْمَنَارَةَ مِنْ ذَهَبٍ خَالِصٍ، فَكَانَتْ قَاعِدَتُهَا وَسَاقُهَا وَكَاسَاتُهَا وَبَرَاعِمُهَا وَأَزْهَارُهَا كُلُّهَا مَخْرُوطَةً مَعاً مِنْ قِطْعَةٍ وَاحِدَةٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","وَلَهَا سِتُّ شُعَبٍ. يَتَفَرَّعُ مِنْ كُلِّ جَانِبٍ مِنْهَا ثَلاثُ شُعَبِ مَنَارَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","وَفِي كُلِّ شُعْبَةٍ ثَلاثُ كَاسَاتٍ لَوْزِيَّةٍ بِبُرْعُمٍ وَزَهْرٍ. وَهَكَذَا إِلَى السِّتَّةِ الأَفْرُعِ الْمُتَشَعِّبَةِ مِنَ الْمَنَارَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","وَعَلَى الْمَنَارَةِ أَرْبَعُ كَاسَاتٍ لَوْزِيَّةٍ بِبَرَاعِمِهَا وَأَزْهَارِهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","وَجَعَلَ تَحْتَ كُلِّ فَرْعَيْنِ مِنَ الأَفْرُعِ الْمُتَشَعِّبَةِ مِنَ الْمَنَارَةِ بُرْعُماً، وَهَكَذَا فَعَلَ لِلسِّتَّةِ الأَفْرُعِ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","فَكَانَتْ بَرَاعِمُهَا وَأَفْرُعُهَا الْمَصْنُوعَةُ مِنَ الذَّهَبِ الْخَالِصِ، مَخْرُوطَةً كُلُّهَا مِنْ قِطْعَةٍ وَاحِدَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","وَصَنَعَ لَهَا سَبْعَةَ سُرُجٍ مَعَ مَلاقِطِهَا وَمَنَافِضِهَا مِنْ ذَهَبٍ خَالِصٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","فَكَانَ وَزْنُ الذَّهَبِ الْخَالِصِ الْمُصَاغِ فِي صُنْعِهَا وَصُنْعِ أَوَانِيهَا وَزْنَةً (نَحْوَ سِتَّةٍ وَثَلاثِينَ كِيْلُو جِرَاماً). ");
INSERT INTO arbnav_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","وَصَنَعَ مَذْبَحَ الْبَخُورِ مِنْ خَشَبِ السَّنْطِ، فَكَانَ سَطْحُهُ مُرَبَّعاً، طُولُهُ ذِرَاعٌ (نَحْوَ نِصْفِ الْمِتْرِ)، وَعَرْضُهُ ذِرَاعٌ (نَحْوَ نِصْفِ الْمِتْرِ) وَارْتِفَاعُهُ ذِرَاعَانِ (نَحْوَ مِتْرٍ). وَكَانَتْ قُرُونُهُ مَخْرُوطَةٌ مِنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","وَغَشَّى سَطْحَهُ وَجُدْرَانَهُ وَقُرُونَهُ بِذَهَبٍ خَالِصٍ. وَطَوَّقَهُ بِإِطَارٍ مِنْ ذَهَبٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","وَصَنَعَ لَهُ أَرْبَعَ حَلَقَاتٍ مِنْ ذَهَبٍ، ثَبَّتَ كُلَّ اثْنَتَيْنِ مِنْهَا تَحْتَ الإِطَارِ عَلَى جَانِبَيْهِ، لِتُوْضَعَ فِيهَا الْعَصَوَانِ اللَّتَانِ يُحْمَلُ بِهِمَا الْمَذْبَحُ. ");
INSERT INTO arbnav_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","وَصَنَعَ الْعَصَوَيْنِ مِنْ خَشَبِ السَّنْطِ الْمُغَشَّى بِالذَّهَبِ ");
INSERT INTO arbnav_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","وَصَنَعَ دُهْنَ الْمَسْحَةِ الْمُقَدَّسَ وَالْبَخُورَ الْعَطِرَ النَّقِيَّ كَمَا يَصْنَعُهَا عَطَّارٌ حَاذِقٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","وَصَنَعَ مَذْبَحَ الْمُحْرَقَةِ مِنْ خَشَبِ السَّنْطِ، فَكَانَ سَطْحُهُ مُرَبَّعَ الشَّكْلِ، طُولُهُ خَمْسُ أَذْرُعٍ (نَحْوَ مِتْرَيْنِ وَنِصْفِ الْمِتْرِ)، وَعَرْضُهُ خَمْسُ أَذْرُعٍ (نَحْوَ مِتْرَيْنِ وَنِصْفِ الْمِتْرِ)، وَارْتِفَاعُهُ ثَلاثَةُ أَذْرُعٍ (نَحْوَ مِتْرٍ وَنِصْفِ الْمِتْرِ). ");
INSERT INTO arbnav_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","وَصَنَعَ لَهُ قُرُوناً، أَقَامَهَا عَلَى زَوَايَاهُ الأَرْبَعِ، مَخْرُوطَةً مِنْ ذَاتِ خَشَبِهِ. وَغَشَّاهُ بِنُحَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","وَكَذَلِكَ طَرَقَ مِنْ نُحَاسٍ جَمِيعَ آنِيَةِ الْمَذْبَحِ: الْقُدُورَ وَالْمَجَارِفَ وَالأَحْوَاضَ وَالْمَنَاشِلَ وَالْمَجَامِرَ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","وَصَنَعَ لِلْمَذْبَحِ شَبَكَةً نُحَاسِيَّةً، وَضَعَهَا تَحْتَ حَافَةِ الْمَذْبَحِ مِنْ أَسْفَلُ، بِحَيْثُ تَصِلُ إِلَى مُنْتَصَفِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","وَسَكَبَ أَرْبَعَ حَلَقَاتٍ نُحَاسِيَّةً عَلَى أَطْرَافِ الشَّبَكَةِ النُّحَاسِيَّةِ لإِدْخَالِ الْعَصَوَيْنِ فِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","وَصَنَعَ الْعَصَوَيْنِ مِنْ خَشَبِ السَّنْطِ المُغَشَّى بِالنُّحَاسِ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","وَأَدْخَلَ الْعَصَوَيْنِ فِي الْحَلَقَاتِ الْمُثَبَّتَةِ عَلَى جَانِبَيِ الْمَذْبَحِ، لِيُحْمَلَ بِهِمَا. وَكَانَ الْمَذْبَحُ مُجَوَّفاً مَصْنُوعاً مِنْ أَلْوَاحٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","وَصَنَعَ حَوْضَ الاغْتِسَالِ وَقَاعِدَتَهُ مِنْ نُحَاسٍ. صَهَرَهَا مِنَ الْمَرَايَا النُّحَاسِيَّةِ الَّتِي تَبَرَّعَتْ بِها النِّسَاءُ اللَّوَاتِي احْتَشَدْنَ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","وَأَحَاطَ بَصَلْئِيلُ سَاحَةَ الْمَسْكَنِ مِنْ جِهَةِ الْجَنُوبِ بِسَتَائِرَ مِنْ كَتَّانٍ مَبْرُومٍ، طُولُهَا مِئَةُ ذِرَاعٍ (نَحْوَ خَمْسِينَ مِتْراً). ");
INSERT INTO arbnav_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","لَهَا عِشْرُونَ عَمُوداً، ذَاتُ عِشْرِينَ قَاعِدَةً نُحَاسِيَّةً بِخَطَاطِيفَ وَقُضْبَانٍ مِنْ فِضَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","وَكَذَلِكَ جَعَلَ طُولَ سَتَائِرِ الْجَانِبِ الشِّمَالِيِّ مِئَةَ ذِرَاعٍ (نَحْوَ خَمْسِينَ مِتْراً) وَأَعْمِدَتَهُ عِشْرِينَ عَمُوداً ذَاتَ عِشْرِينَ قَاعِدَةً نُحَاسِيَّةً، بِخَطَاطِيفَ وَقُضْبَانٍ مِنْ فِضَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","أَمَّا الْجَانِبُ الْغَرْبِيُّ فَقَدْ كَانَ طُولُ سَتَائِرِهِ خَمْسِينَ ذِرَاعاً (نَحْوَ خَمْسَةٍ وَعِشْرِينَ مِتْراً) مُعَلَّقَةً بَخَطَاطِيفَ وَقُضْبَانٍ مِنْ فِضَّةٍ، عَلَى أَعْمِدَةٍ ذَاتِ عَشْرِ قَوَاعِدَ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","وَكَذَلِكَ الْجَانِبُ الشَّرْقِيُّ فَقَدْ كَانَ طُولُهُ خَمْسِينَ ذِرَاعاً (نَحْوَ خَمْسَةٍ وَعِشْرِينَ مِتْراً). ");
INSERT INTO arbnav_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","فَكَانَ طُولُ السَّتَائِرِ عَلَى الْجَانِبِ الْجَنُوبِيِّ لِمَدْخَلِ السَّاحَةِ خَمْسَ عَشْرَةَ ذِرَاعاً (نَحْوَ سَبْعةِ أَمْتَارٍ وَنِصْفِ الْمِتْرِ)، مُعَلَّقَةً عَلَى ثَلاثَةِ أَعْمِدَةٍ ذَاتِ ثَلاثِ قَوَاعِدَ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","أَمَّا طُولُ السَّتَائِرِ عَلَى الْجَانِبِ الآخَرِ (أَيِ الشِّمَالِيِّ) لِمَدْخَلِ السَّاحَةِ فَكَانَ خَمْسَ عَشْرَةَ ذِرَاعاً (نَحْوَ سَبْعَةِ أَمْتَارٍ وَنِصْفِ الْمِتْرِ)، مُعَلَّقَةً عَلَى ثَلاثَةِ أَعْمِدَةٍ ذَاتِ ثَلاثِ قَوَاعِدَ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","وَكَانَتْ جَمِيعُ السَّتَائِرِ الْمُحِيطَةِ بِالسَّاحَةِ مَنْسُوجَةً مِنْ كَتَّانٍ نَقِيٍّ مَبْرُومٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","وَصَنَعَ قَوَاعِدَ الأَعْمِدَةِ مِنْ نُحَاسٍ. أَمَّا الْمَشَابِكُ وَالْقُضْبَانُ فَكَانَتْ مِنْ فِضَّةٍ، وَتِيجَانُ الأَعْمِدَةِ مُغَطَّاةً بِالْفِضَّةِ. وَجَمِيعُ أَعْمِدَةِ السَّاحَةِ مَوْصُولَةٌ بِقُضْبَانٍ مِنْ فِضَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","وَكَانَ عَرْضُ سِتَارِ مَدْخَلِ سَاحَةِ الْمَسْكَنِ عِشْرِينَ ذِرَاعاً (نَحْوَ عَشَرَةِ أَمْتَارٍ) وَارْتِفَاعُهُ خَمْسَ أَذْرُعٍ (نَحْوَ مِتْرَيْنِ وَنِصْفِ الْمِتْرِ)، كَارْتِفَاعِ السَّاحَةِ، وَهُوَ مَصْنُوعٌ مِنْ كَتَّانٍ ذِي أَلْوَانٍ زَرْقَاءَ وَبَنَفَسَجِيَّةٍ وَحَمْرَاءَ مِنْ صِنَاعَةِ حَائِكٍ مَاهِرٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","وَعَلَّقَهُ بِخَطَاطِيفَ فضِّيَّةٍ عَلَى أَرْبَعَةِ أَعْمِدَةٍ فِضِّيَّةٍ فَوْقَ أَرْبَعِ قَوَاعِدَ نُحَاسِيَّةٍ. وَكَانَتْ تِيجَانُ الأَعْمِدَةِ وَقُضْبَانُهَا مِنْ فِضَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","أَمَّا جَمِيعُ أَوْتَادِ الْخَيْمَةِ والسَّاحَةِ الْمُحِيطَةِ بِها، فَقَدْ كَانَتْ مِنْ نُحَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","وَمَا يَلِي الْمَقَادِيرُ الْمُسْتَخْدَمَةُ فِي بِنَاءِ مَسْكَنِ الشَّهَادَةِ، الَّتِي تَمَّ حِسَابُهَا بِمُقْتَضَى أَمْرِ مُوسَى، بِإِشْرَافِ اللّاوِيِّينَ عَلَى يَدِ إِيثَامَارَ بْنِ هَرُونَ الْكَاهِنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","وَكَانَ بَصَلْئِيلُ بْنُ أُورِي حَفِيدُ حُورٍ مِنْ سِبْطِ يَهُوذَا، هُوَ الَّذِي صَنَعَ كُلَّ مَا أَمَرَ بِهِ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","يُعَاوِنُهُ أَهُولِيآبُ بْنُ أَخِيسَامَاكَ مِنْ سِبْطِ دَانٍ، الَّذِي بَرَعَ فِي النَّقْشِ وَالتَّوْشِيَةِ وَالتَّطْرِيزِ بِالأَلْوَانِ الزَّرْقَاءِ وَالْبَنَفْسَجِيَّةِ وَالْحَمْرَاءِ وَخُيُوطِ الكَتَّانِ الْبَيْضَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","كَانَ وَزْنُ الذَّهَبِ الْمُسْتَخْدَمِ فِي جَمِيعِ عَمَلِ الْمَسْكَنِ مِنَ التَّبَرُّعَاتِ تِسْعاً وَعِشْرِينَ وَزْنَةً وَسَبْعَ مِئَةٍ وَثَلاثِينَ شَاقِلاً (نَحْوَ أَلْفٍ وَثَلاثَةٍ وَخَمْسِينَ كِيلُو جِرَاماً) طِبْقاً لِمَوازِينِ الْمَقْدِسِ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","أَمَّا وَزْنُ الْفِضَّةِ الْمُجْبَاةِ مِنَ الْمَعْدُودِينَ مِنَ الشَّعْبِ، فَكَانَ مِئَةَ وَزْنَةٍ وَأَلْفاً وَسَبْعَ مِئَةٍ وَخَمْسَةٍ وَسَبْعِينَ شَاقِلاً (نَحْوَ ثَلاثَةِ آلافٍ وَسِتِّ مِئَةٍ وَوَاحِدٍ وَعِشْرِينَ كِيلُو جِرَاماً) طِبْقاً لِمَوازِينِ الْمَقْدِسِ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","إِذْ كَانَ يُفْرَضُ عَلَى كُلِّ شَخْصٍ مِنَ الْمَعْدُودِينَ بَلَغَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً وَمَا فَوْقُ، نِصْفُ شَاقِلٍ (نَحْوَ سِتَّةِ جِرَامَاتٍ) طِبْقاً لِمَوَازِينِ الْمَقْدِسِ. وَكَانَ عَدَدُ الْمَعْدُودِينَ نَحْوَ سِتِّ مِئَةٍ وَثَلاثَةِ آلافِ رَجُلٍ وَخَمْسِ مِئَةٍ وَخَمْسِينَ رَجُلاً ");
INSERT INTO arbnav_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","وَكَانَ وَزْنُ الفِضَّةِ الْمُسْتَهْلَكَةِ فِي صَبِّ قَوَاعِدِ الْمَسْكَنِ وَالسَّتَائِرِ الْمِئَةِ مِئَةَ وَزْنَةٍ (نَحْوَ ثَلاثَةِ آلافٍ وَسِتِّ مِئَةِ كِيلُو جِرَامٍ)، أَيْ وَزْنَةً وَاحِدَةً (نَحْوَ سِتَّةٍ وَثَلاثِينَ كِيلُو جِرَاماً) لِكُلِّ قَاعِدَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","أَمَّا مَا فَضَلَ مِنَ الفِضَّةِ البَالِغَةِ أَلْفاً وَسَبْع مِئَةٍ وَخَمْسَةً وَسَبْعِينَ شاقِلاً (نَحْوَ وَاحِدٍ وَعِشْرِينَ كِيلُو جِرَاماً) فَقَدِ اسْتُخْدِمَتْ فِي صُنْعِ خَطَاطِيفِ الأَعْمِدَةِ وَالْقُضْبَانِ وَتَغْشِيَةِ تِيجَانِ الأَعْمِدَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","وَكَانَ وَزْنُ النُّحَاسِ الَّذِي تَبَرَّعَ بِهِ الشَّعْبُ سَبْعِينَ وَزْنَةً وَأَلْفَيْنِ وَأَرْبَعَ مِئَةِ شَاقِلٍ (نَحْوَ أَلْفَيْنِ وَخَمْسِ مِئَةِ وَتِسْعَةٍ وَأَرْبَعِينَ كيلُو جِرَاماً). ");
INSERT INTO arbnav_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","وَمِنْهُ صَبَّ قَواعِدَ بَابِ خَيْمَةِ الْاجْتِمَاعِ وَمَذْبَحَ النُّحَاسِ وَشَبَكَتَهُ النُّحَاسِيَّةَ وَجَمِيعَ أَوَانِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","وَقَوَاعِدَ السَّاحَةِ الْمُحِيطَةِ بِالْخَيْمَةِ، وَقَوَاعِدَ مَدْخَلِهَا وَجَمِيعَ أَوْتَادِ الْمَسْكَنِ وَالدَّارِ الْمُحِيطَةِ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","وَحَاكُوا مِنَ الْخُيُوطِ الزَّرْقَاءِ وَالْبَنَفْسَجِيَّةِ وَالْحَمْرَاءِ ثِيَاباً مَنْسُوجَةً لاِرْتِدَائِهَا فِي أَثْنَاءِ خِدْمَةِ الْمَقْدِسِ، وَكَذَلِكَ نَسَجُوا مِنْهَا ثِيَابَ هَرُونَ الْمُقَدَّسَةَ تَمَاماً كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","فَنَسَجُوا الرِّدَاءَ مِنْ خُيُوطٍ ذَهَبِيَّةٍ وَزَرْقَاءَ وَبَنَفْسَجِيَّةٍ وَحَمْرَاءَ وَنَسِيجِ الْكَتَّانِ الْمَبْرُومِ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","وَطَرَقُوا الذَّهَبَ رَقَائِقَ، وَقَدُّوهَا خُيُوطاً لِيَنْسِجُوهَا بَيْنَ الْخُيُوطِ الزَّرْقَاءِ وَالْبَنَفْسَجِيَّةِ وَالْحَمْرَاءِ وَالْكَتَّانِيَّةِ صَنْعَةَ مُطَرِّزٍ حَاذِقٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","وَصَنَعُوا لِلرِّدَاءِ كَتِفَيْنِ مَوْصُولَيْنِ عِنْدَ الطَّرَفَيْنِ لِيُمْكِنَ تَثْبِيتُهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","أَمَّا الْحِزَامُ فَقَدْ حِيكَ مِنْ ذَاتِ نَوْعِ الْقُمَاشِ، مِنْ خُيُوطٍ ذَهَبِيَّةٍ وَزَرْقَاءَ وَحَمْرَاءَ وَكَتَّانٍ مَبْرُومٍ تَمَاماً كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","وَأَحَاطُوا حَجَرَيِ الْجَزْعِ بِطَوْقَينِ مِنْ ذَهَبٍ نُقِشَتْ عَلَيْهِمَا أَسْمَاءُ أَسْبَاطِ إِسْرَائِيلَ كَمَا يُنْقَشُ عَلَى الْخَاتَمِ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","وَتَمَّ تَثْبِيتُهَا عَلَى كَتِفَيِ الرِّدَاءِ، كَحَجَرَيْ تَذْكِرَةٍ بِبَنِي إِسْرَائِيلَ، كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","وَحَاكُوا الصُّدْرَةَ حِيَاكَةَ مُطَرِّزٍ حَاذِقٍ مِنْ ذَاتِ نَسِيجِ الرِّدَاءِ مِنْ خُيُوطٍ ذَهَبِيَّةٍ وَزَرْقَاءَ وَبَنَفْسَجِيَّةٍ وَحَمْرَاءَ وَكَتَّانٍ مَبْرُومٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","وَكَانَتِ الصُّدْرَةُ مُرَبَّعَةً، طُولُهَا شِبْرٌ وَعَرْضُهَا شِبْرٌ، وَمَثْنِيَّةً، ");
INSERT INTO arbnav_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","مُرَصَّعَةً بِأَرْبَعَةِ صُفُوفِ حِجَارَةٍ كَرِيمَةٍ، الصَّفُّ الأَوَّلُ عَقِيقٌ أَحْمَرُ وَيَاقُوتٌ أَصْفَرُ وَزُمُرُّدٌ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","وَالصَّفُّ الثَّانِي بَهْرَمَانُ وَيَاقُوتٌ أَزْرَقُ وَعَقِيقٌ أَبْيَضُ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","وَالصَّفُّ الثَّالِثُ عَيْنُ الهِرِّ وَيَشْمٌ وَجَمَشْتُ ");
INSERT INTO arbnav_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","وَالصَّفُّ الرَّابِعُ زَبَرْجَدٌ وَجَزْعٌ وَيَشْبٌ. وَكَانَتْ كُلُّهَا مُحَاطَةً بِأَطْوَاقٍ مِنْ ذَهَبٍ فِي تَرْصِيعِهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","وَنُقِشَ عَلَى كُلِّ حَجَرٍ مِنَ الأَحْجَارِ الْكَرِيمَةِ اسْمُ وَاحِدٍ مِنْ أَسْمَاءِ أَسْبَاطِ بَنِي إِسْرَائِيلَ الاثْنَيْ عَشَرَ كَمَا يُنْقَشُ عَلَى الْخَاتَمِ، ");
INSERT INTO arbnav_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","وَصَنَعُوا عَلَى الصُّدْرَةِ سِلْسِلَتَيْنِ مِنْ ذَهَبٍ خَالِصٍ مَضْفُورَتَيْنِ كَحَبْلٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","وَصَاغُوا طَوْقَيْنِ مِنْ ذَهَبٍ وَحَلْقَتَيْنِ ذَهَبِيَّتَيْنِ، وَثَبَّتُوا الْحَلْقَتَيْنِ عَلَى طَرَفَيِ الصُّدْرَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","وَأَدْخَلُوا سِلْسِلَتَيِ الذَّهَبِ فِي الْحَلْقَتَيْنِ عَلَى طَرَفَيِ الصُّدْرَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","وَأَمَّا طَرَفَا السِّلْسِلَتَيْنِ فَرَبَطُوهُمَا بِالطَّوْقَيْنِ، وَثَبَّتُوهُمَا عَلَى كَتِفَيِ الرِّدَاءِ مِنَ الأَمَامِ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","كَذَلِكَ صَاغُوا حَلْقَتَيْنِ ذَهَبِيَّتَيْنِ وَثَبَّتُوهُمَا عَلَى حَاشِيَةِ طَرَفَيِ الصُّدْرَةِ الدَّاخِلِيَّةِ الْمُلاصِقَةِ لِلرِّدَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","كَمَا صَاغُوا حَلْقَتَيْنِ ذَهَبِيَّتَيْنِ أُخْرَيَيْنِ، وَوَضَعُوهُمَا عَلَى أَسْفَلِ كَتِفَيِ الرِّدَاءِ مِنَ الأَمَامِ، عِنْدَ مَكَانِ الْوَصْلِ فَوْقَ حِزَامِ الرِّدَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","وَرَبَطُوا حَلْقَتَيِ الصُّدْرَةِ إِلَى حَلْقَتَيِ الرِّدَاءِ بِخَيْطٍ أَزْرَقَ لِتَثْبُتَ فَوْقَ حِزَامِ الرِّدَاءِ وَهَكَذَا لَا تُنْتَزَعُ الصُّدْرَةُ عَنِ الرِّدَاءِ، تَمَاماً كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","وَصَنَعُوا جُبَّةَ الرِّدَاءِ مِنْ قُمَاشٍ أَزْرَقَ صِنَاعَةَ حَائِكٍ حَاذِقٍ، ");
INSERT INTO arbnav_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","فَكَانَ لَهَا فَتْحَةٌ فِي وَسَطِهَا عَلَى غِرَارِ فَتْحَةِ الْقَمِيصِ، ذَاتُ حَاشِيَةٍ مُحِيطَةٍ لِئَلّا تَتَمَزَّقَ ");
INSERT INTO arbnav_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","وَجَعَلُوا عَلَى اسْتِدَارَةِ أَذْيَالِهَا رُمَّانَاتٍ مِنْ خُيُوطٍ كَتَّانِيَّةٍ مَبْرُومَةٍ زَرْقَاءَ وَبَنَفْسَجِيَّةٍ وَحَمْرَاءَ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","وَعَلَّقُوا بَيْنَهَا أَجْرَاساً مِنْ ذَهَبٍ خَالِصٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","فَكَانَ بَيْنَ كُلِّ رُمَّانَتَيْنِ جَرَسٌ مُعَلَّقٌ عَلَى اسْتِدَارَةِ هُدْبِ الْجُبَّةِ الَّتِي تُرْتَدَى فِي أَثْنَاءِ الْخِدْمَةِ، تَمَاماً كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","وَنَسَجُوا أَقْمِصَةَ هَرُونَ وَبَنِيهِ مِنْ كَتَّانٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","وَكَذَلِكَ الْعِمَامَةَ وَعَصَائِبَ الْقَلانِسِ وَالسَّرَاوِيلِ، نَسَجُوهَا كُلَّهَا مِنْ خُيُوطِ الْكَتَّانِ الْمَبْرُومَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","أَمَّا الْحِزَامُ فَقَدْ حَاكُوهُ مِنْ خُيُوطِ الْكَتَّانِ الْمَبْرُومَةِ ذَاتِ الأَلْوَانِ الزَّرْقَاءِ وَالْبَنَفْسَجِيَّةِ وَالْحَمْرَاءِ، تَطْرِيزَ حَائِكٍ حَاذِقٍ، تَمَاماً كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","وَصَنَعُوا صَفِيحَةَ الإِكْلِيلِ الْمُقَدَّسِ مِنْ ذَهَبٍ نَقِيٍّ، وَنَقَشُوا عَلَيْهَا كَمَا يُنْقَشُ عَلَى الْخَاتَمِ: «قُدْسٌ لِلرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","وَثَبَّتُوهَا بِخَيْطٍ أَزْرَقَ فِي مُقَدِّمَةِ عِمَامَةِ هَرُونَ تَمَاماً كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","وَهَكَذَا اكْتَمَلَ كُلُّ بِنَاءِ مَسْكَنِ خَيْمَةِ الاجْتِمَاعِ. فَأَقَامَهُ بَنُو إِسْرَائِيلَ بِمُوجِبِ مَا أَمَرَ الرَّبُّ بِهِ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","فَجَاءُوا بِالْمَسْكَنِ إِلَى مُوسَى، الْخَيْمَةِ وَجَمِيعِ أَوَانِيهَا وَمَشَابِكِهَا وَأَلْوَاحِهَا وَعَوَارِضِهَا وَأَعْمِدَتِهَا وَقَوَاعِدِهَا ");
INSERT INTO arbnav_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","وَالسَّقْفِ الْمَصْنُوعِ مِنْ جُلُودِ الْكِبَاشِ الْمَصْبُوغَةِ بِاللَّوْنِ الْبَنَفْسِجَيِّ، وَكَذَلِكَ السَّقْفِ الْمَصْنُوعِ مِنْ جُلُودِ الدُّلْفِينِ، وَالْحِجَابِ الْفَاصِلِ بَيْنَ الْقُدْسِ وَقُدْسِ الأَقْدَاسِ، ");
INSERT INTO arbnav_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","وَتَابُوتِ الشَّهَادَةِ وَعَصَوَيْهِ وَالْغِطَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","وَالْمَائِدَةِ مَعَ كُلِّ أَوَانِيهَا وَخُبْزِ التَّقْدِمَةِ، ");
INSERT INTO arbnav_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","وَالْمَنَارَةِ الذَّهَبِيَّةِ وَسُرُجِهَا الْمُنَضَّدَةِ مَعَ سَائِرِ أَوَانِيهَا، وَزَيْتِ إِضَاءَتِهَا، ");
INSERT INTO arbnav_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","وَمَذْبَحِ الذَّهَبِ وَدُهْنِ الْمَسْحَةِ، وَالْبَخُورِ الْعَطِرِ، وَسَتَائِرِ مَدْخَلِ الْخَيْمَةِ، ");
INSERT INTO arbnav_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","وَمَذْبَحِ النُّحَاسِ وَشَبَكَتِهِ النُّحَاسِيَّةِ، وَعَصَوَيْهِ، وَجَمِيعِ أَوَانِيهِ، وَحَوْضِ الاغْتِسَالِ وَقَاعِدَتِهِ، ");
INSERT INTO arbnav_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","وَأَسْتَارِ السَّاحَةِ وَأَعْمِدَتِهَا وَقَوَاعِدِهَا، وَسِتَارَةِ بَابِ السَّاحَةِ وَحِبَالِهَا وَأَوْتَادِهَا، وَسَائِرِ أَوَانِي الْخِدْمَةِ الْمُسْتَعْمَلَةِ فِي خَيْمَةِ الاجْتِمَاعِ، ");
INSERT INTO arbnav_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","وَالثِّيَابِ الْمَنْسُوجَةِ الَّتِي تُرْتَدَى فِي أَثْنَاءِ الْخِدْمَةِ فِي الْمَقْدِسِ وَثِيَابِ هَرُونَ الْكَاهِنِ الْمُقَدَّسَةِ، وَثِيَابِ بَنِيهِ الْكَهَنَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","وَهَكَذَا قَامَ بَنُو إِسْرَائِيلَ بِجَمِيعِ الْعَمَلِ بِمُقْتَضَى مَا أَمَرَ الرَّبُّ بِهِ مُوسَى، ");
INSERT INTO arbnav_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","فَنَظَرَ مُوسَى جَمِيعَ الْعَمَلِ وَإذَا هُمْ قَدْ صَنَعُوهُ كَمَا أَمَرَ الرَّبُّ، فَبَارَكَهُمْ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«تُقِيمُ مَسْكَنَ خَيْمَةِ الاجْتِمَاعِ فِي الْيَوْمِ الأَوَّلِ مِنَ الشَّهْرِ الأَوَّلِ (مِنَ السَّنَةِ الْعِبْرِيَّةِ). ");
INSERT INTO arbnav_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","وَتَضَعُ فِيهِ تَابُوتَ الشَّهَادَةِ الَّذِي فِيهِ الْوَصَايَا الْعَشَرُ، وَتَسْتُرُهُ بِالْحِجَابِ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ثُمَّ تُدْخِلُ الْمَائِدَةَ وَتُرَتِّبُ أَوَانِيهَا عَلَيْهَا، وَأَيْضاً الْمَنَارَةَ وَتُضِيءُ سُرُجَهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","وَتَضَعُ مَذْبَحَ الْبَخُورِ الذَّهَبِيَّ أَمَامَ تَابُوتِ الشَّهَادَةِ الْقَائِمِ وَرَاءَ الْحِجَابِ، وَتُعَلِّقُ سَتَائِرَ بَابِ الْمَسْكَنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","وَتَجْعَلُ مَذْبَحَ الْمُحْرَقَةِ النُّحَاسِيَّ أَمَامَ بَابِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ثُمَّ تَضَعُ حَوْضَ الاغْتِسَالِ بَيْنَ الْمَسْكَنِ وَالْمَذْبَحِ، وَامْلأْهُ بِالْمَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","وَتَنْصِبُ سَتَائِرَ السَّاحَةِ الْمُحِيطَةِ بِالْمَسْكَنِ، وَتُعَلِّقُ سِتَارَ مَدْخَلِهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","وَتَأْخُذُ دُهْنَ الْمَسْحَةِ وَتَمْسَحُ بِهِ الْخَيْمَةَ وَكُلَّ مَا فِيهَا، وَتُقَدِّسُ جَمِيعَ أَوَانِيهَا لِتَكُونَ مُخَصَّصَةً لِي. ");
INSERT INTO arbnav_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","وَتَمْسَحُ أَيْضاً مَذْبَحَ الْمُحْرَقَةِ وَجَمِيعَ أَوَانِيهِ وَتُقَدِّسُهُ لِيَكُونَ قُدْسَ أَقْدَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","وَكَذَلِكَ تَمْسَحُ حَوْضَ الاغْتِسَالِ وَقَاعِدَتَهُ وَتُقَدِّسُهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","وَتُحْضِرُ هَرُونَ وَبَنِيهِ إِلَى مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ وَتَغْسِلُهُمْ بِمَاءٍ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","وَتُلْبِسُ هَرُونَ ثِيَابَهُ الْمُقَدَّسَةَ، وَتَمْسَحُهُ وَتُكَرِّسُهُ كَاهِناً لِخِدْمَتِي. ");
INSERT INTO arbnav_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ثُمَّ تُحْضِرُ بَنِيهِ وَتُلْبِسُهُمْ أَقْمِصَتَهُمْ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","وَتَمْسَحُهُمْ كَمَا مَسَحْتَ أَبَاهُمْ، فَيَكُونُونَ كَهَنَةً لِي. فَتَكُونُ هَذِهِ الْمَسْحَةُ مَسْحَةَ كَهَنُوتٍ لَهُمْ جِيلاً بَعْدَ جِيلٍ». ");
INSERT INTO arbnav_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","فَفَعَلَ مُوسَى كُلَّ مَا أَمَرَ بِهِ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","فَأَقَامَ الْمَسْكَنَ فِي الْيَوْمِ الأَوَّلِ مِنَ الشَّهْرِ الأَوَّلِ (لِلسَّنَةِ الْعِبْرِيَّةِ). ");
INSERT INTO arbnav_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","وَصَبَّ قَوَاعِدَهُ وَوَضَعَ أَلْوَاحَهُ وَعَوَارِضَهُ، وَنَصَبَ أَعْمِدَتَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","وَبَسَطَ السَّقْفَ فَوْقَ الْمَسْكَنِ وَوَضَعَ غِطَاءَهُ عَلَيْهِ، كَمَا أَمَرَهُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ثُمَّ أَخَذَ لَوْحَيِ الْوَصَايَا الْعَشْرِ وَوَضَعَهَا فِي التَّابُوتِ، وَوَضَعَ الْعَصَوَيْنِ عَلَى التَّابُوتِ مِنْ فَوْقُ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","وَحَمَلَ التَّابُوتَ إِلَى قُدْسِ الأَقْدَاسِ، وَسَتَرَ تَابُوتَ الشَّهَادَةِ بِالْحِجَابِ، كَمَا أَمَرَهُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","وَأَقَامَ الْمَائِدَةَ فِي خَيْمَةِ الاجْتِمَاعِ فِي الْجَانِبِ الشِّمَالِيِّ مِنَ الْمَسْكَنِ خَارِجَ الْحِجَابِ (أَيْ فِي الْقُدْسِ). ");
INSERT INTO arbnav_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","وَرَتَّبَ مُوسَى خُبْزَ التَّقْدِمَةِ عَلَى الْمَائِدَةِ أَمَامَ الرَّبِّ، كَمَا أَمَرَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ثُمَّ وَضَعَ الْمَنَارَةَ فِي خَيْمَةِ الاجْتِمَاعِ، فِي الْجَانِبِ الْجَنُوبِيِّ مِنَ الْمَسْكَنِ مُقَابِلَ الْمَائِدَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","وَأَضَاءَ سُرُجَهَا أَمَامَ الرَّبِّ كَمَا أَمَرَهُ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","وَوَضَعَ مَذْبَحَ الذَّهَبِ فِي خَيْمَةِ الاجْتِمَاعِ أَمَامَ الْحِجَابِ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","وَأَحْرَقَ عَلَيْهِ بَخُوراً عَطِراً، كَمَا أَمَرَهُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","وَوَضَعَ سِتَارَةً عَلَى مَدْخَلِ الْخَيْمَةِ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","وَوَضَعَ مَذْبَحَ الْمُحْرَقَةِ عِنْدَ بَابِ مَسَكَنِ خَيْمَةِ الاجْتِمَاعِ. وَأَصْعَدَ عَلَيْهِ الْمُحْرَقَةَ وَالتَّقْدِمَةَ، كَمَا أَمَرَهُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","وَوَضَعَ حَوْضَ الاغْتِسَالِ بَيْنَ خَيْمَةِ الاجْتِمَاعِ وَمَذْبَحِ الْمُحْرَقَةِ. وَمَلأَهُ بِالْمَاءِ لِلاغْتِسَالِ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","لِيَغْسِلَ مُوسَى وَهَرُونُ وَبَنُوهُ أَيْدِيَهُمْ وَأَرْجُلَهُمْ بِمَائِهِ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","فَيَغْتَسِلُونَ كُلَّمَا دَخَلُوا إِلَى خَيْمَةِ الاجْتِمَاعِ أَوِ اقْتَرَبُوا إِلَى الْمَذْبَحِ، كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ثُمَّ نَصَبَ مُوسَى جَوَانِبَ السَّاحَةِ الْمُحِيطَةِ بِالْمَسْكَنِ، وَعَلَّقَ سِتَارَ مَدْخَلِهَا. وَهَكَذَا أَكْمَلَ مُوسَى الْعَمَلَ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","وَمَا لَبِثَتِ السَّحَابَةُ أَنْ غَطَّتْ خَيْمَةَ الاجْتِمَاعِ وَمَلأَ جَلالُ الرَّبِّ الْمَسْكَنَ، ");
INSERT INTO arbnav_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","فَلَمْ يَسْتَطِعْ مُوسَى دُخُولَ خَيْمَةِ الاجْتِمَاعِ، لأَنَّ السَّحَابَةَ حَلَّتْ عَلَيْهَا، وَمَجْدَ الرَّبِّ مَلأَ الْمَسْكَنَ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","وَكَانَ بَنُو إِسْرَائِيلَ لَا يَرْتَحِلُونَ فِي جَمِيعِ أَسْفَارِهِمْ، إِلا إذَا ارْتَفَعَتِ السَّحَابَةُ عَنِ الْمَسْكَنِ. ");
INSERT INTO arbnav_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","وَإِنْ لَمْ تَرْتَفِعْ، يَمْكُثُونَ حَيْثُ هُمْ حَتَّى يَوْمِ ارْتِفَاعِهَا. ");
INSERT INTO arbnav_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","وَكَانَتِ السَّحَابَةُ تُغَطِّي الْمَسْكَنَ نَهَاراً، وَتَتَوَهَّجُ مِنْهَا نَارٌ لَيْلاً، عَلَى مَرْأَى كُلِّ شَعْبِ إِسْرَائِيلَ فِي جَمِيعِ رِحْلاتِهِمْ.");
INSERT INTO arbnav_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","وَاسْتَدْعَى الرَّبُّ مُوسَى، وَخَاطَبَهُ مِنْ خَيْمَةِ الاجْتِمَاعِ قَائِلاً: ");
INSERT INTO arbnav_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ: إِذَا قَدَّمَ أَحَدُكُمْ ذَبِيحَةً مِنَ الْبَهَائِمِ لِلرَّبِّ، فَلْيَكُنْ ذَلِكَ الْقُرْبَانُ مِنَ الْبَقَرِ وَالْغَنَمِ. ");
INSERT INTO arbnav_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","إِنْ كَانَتْ تَقْدِمَتُهُ مُحْرَقَةً مِنَ الْبَقَرِ، فَلْيُقَرِّبْ ثَوْراً سَلِيماً، يُحْضِرُهُ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، وَيُقَدِّمُهُ أَمَامَ الرَّبِّ طَلَباً لِرِضَاهُ عَنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","فَيَضَعُ يَدَهُ عَلَى رَأْسِ الْمُحْرَقَةِ، فَيَرْضَى الرَّبُّ بِمَوْتِ الثَّوْرِ بَدِيلاً عَنْ صَاحِبِهِ، لِلتَّكْفِيرِ عَنْ خَطَايَاهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ثُمَّ يَذْبَحُ الْمُقَرِّبُ الْعِجْلَ أَمَامَ الرَّبِّ. وَيُقَدِّمُ بَنُو هَرُونَ، الْكَهَنَةُ، الدَّمَ وَيَرُشُّونَهُ عَلَى جَوَانِبِ الْمَذْبَحِ الْقَائِمِ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","وَعَلَى الْمُقَرِّبِ أَيْضاً أَنْ يَسْلُخَ الْمُحْرَقَةَ وَيُقَطِّعَهَا إِلَى أَجْزَاءَ. ");
INSERT INTO arbnav_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","وَيُوْقِدُ أَبْنَاءُ هَرُونَ نَاراً عَلَى الْمَذْبَحِ وَيُرَتِّبُونَ عَلَيْهَا حَطَباً ");
INSERT INTO arbnav_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ثُمَّ يُرَتِّبُونَ فَوْقَ حَطَبِ نَارِ الْمَذْبَحِ أَجْزَاءَ الثَّوْرِ وَرَأْسَهُ وَشَحْمَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","أَمَّا أَعْضَاؤُهُ الدَّاخِلِيَّةُ وَأَكَارِعُهُ فَيَغْسِلُهَا الْمُقَرِّبُ بِمَاءٍ، ثُمَّ يُحْرِقُهَا الْكَاهِنُ جَمِيعاً عَلَى الْمَذْبَحِ، فَتَكُونُ مُحْرَقَةً، وَقُودَ رِضًى تَسُرُّ الرَّبَّ. ");
INSERT INTO arbnav_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","وَإِنْ كَانَتْ مُحْرَقَتُهُ مِنَ الْمَاشِيَةِ: الضَّأْنِ أَوِ الْمَعَزِ، فَلْتَكُنْ ذَكَراً سَلِيماً. ");
INSERT INTO arbnav_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","وَعَلَى الْمُقَرِّبِ أَنْ يَذْبَحَهُ فِي حَضْرَةِ الرَّبِّ، عِنْدَ الْجَانِبِ الشَّمَالِيِّ لِلْمَذْبَحِ، ثُمَّ يَقُومُ أَبْنَاءُ هَرُونَ الْكَهَنَةُ بِرَشِّ دَمِهِ عَلَى جَوَانِبِ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","وَيُقَطِّعُهُ الْمُقَرِّبُ إِلَى أَجْزَاءَ مَعَ رَأْسِهِ وَشَحْمِهِ، فَيُرَتِّبُهَا الْكَاهِنُ فَوْقَ حَطَبِ نَارِ الْمَذْبَحِ، ");
INSERT INTO arbnav_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","وَأَمَّا الأَعْضَاءُ الدَّاخِلِيَّةُ وَالأَكَارِعُ فَيَغْسِلُهَا بِمَاءٍ، ثُمَّ يُحْرِقُهَا الْكَاهِنُ جَمِيعَهَا فَتَكُونُ مُحْرَقَةً وَوَقُودَ رِضًى تَسُرُّ الرَّبَّ. ");
INSERT INTO arbnav_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","وَإِنْ كَانَتْ تَقْدِمَتُهُ لِلرَّبِّ مُحْرَقَةً مِنَ الطَّيْرِ، فَلْتَكُنْ مِنَ الْيَمَامِ أَوْ مِنْ أَفْرَاخِ الْحَمَامِ. ");
INSERT INTO arbnav_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","فَيُقَدِّمُ الْكَاهِنُ الْقُرْبَانَ إِلَى الْمَذْبَحِ وَيَحُزُّ رَأْسَهُ وَيُصَفِّي دَمَهُ عَلَى حَائِطِ الْمَذْبَحِ بَعْدَ إِيْقَادِ النَّارِ عَلَى الْمَذْبَحِ، ");
INSERT INTO arbnav_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","وَيَنْزِعُ حَوْصَلَتَهُ بِكُلِّ مَا بِها وَيَطْرَحُهُمَا إِلَى جَانِبِ الْمَذْبَحِ الشَّرْقِيِّ، حَيْثُ يُجْمَعُ الرَّمَادُ. ");
INSERT INTO arbnav_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","وَيَشُقُّ الْكَاهِنُ الطَّائِرَ مِنْ بَيْنِ جَنَاحَيْهِ، مِنْ غَيْرِ أَنْ يَفْصِلَهُ إِلَى قِطْعَتَيْنِ، وَيُحْرِقُهُ عَلَى الْمَذْبَحِ فَوْقَ حَطَبِ النَّارِ، فَيَكُونُ مُحْرَقَةً وَوَقُودَ رِضًى تَسُرُّ الرَّبَّ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","وَإذَا قَدَّمَ أَحَدٌ لِلرَّبِّ تَقْدِمَةً مِنْ حِنْطَةٍ، فَلْتَكُنْ مِنْ دَقِيقٍ يَسْكُبُ عَلَيْهَا زَيْتاً وَيَضَعُ عَلَيْهَا لُبَاناً، ");
INSERT INTO arbnav_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ثُمَّ يُحْضِرُهَا إِلَى أَبْنَاءِ هَرُونَ الْكَهَنَةِ، فَيَمْلأُ الْكَاهِنُ قَبْضَتَهُ مِنْ دَقِيقِ التَّقْدِمَةِ وَزَيْتِهَا مَعَ كُلِّ لُبَانِهَا وَيُوْقِدُهَا الْكَاهِنُ تَذْكَاراً عَلَى الْمَذْبَحِ، فَتَكُونُ وَقُودَ مُحْرَقَةِ رِضًى تَسُرُّ الرَّبَّ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","أَمَّا بَقِيَّةُ التَّقْدِمَةِ فَتَكُونُ مِنْ نَصِيبِ هَرُونَ وَأَبْنَائِهِ، فَهِيَ تَقْدِمَةُ مُحْرَقَةٍ مُقَدَّسَةٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","إِنْ كَانَ الْقُرْبَانُ تَقْدِمَةً مَخْبُوزَةً فِي تَنُّورٍ، فَلْتَكُنْ أَقْرَاصاً مِنْ دَقِيقٍ، فَطِيراً مَلْتُوتَةً أَوْ مَدْهُونَةً بِزَيْتٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","وَإِنْ كَانَ قُرْبَانُكَ مَخْبُوزاً عَلَى الصَّاجِ، فَلْتَكُنْ مِنْ دَقِيقٍ فَطِيراً مَلْتُوتَةً بِزَيْتٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","قَطِّعْهَا إِلَى فُتَاتٍ وَصُبَّ عَلَيْهَا زَيْتاً؛ إِنَّهَا تَقْدِمَةٌ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","وَإِنْ كَانَتْ تَقْدِمَتُكَ مَخْبُوزَةً فِي مِقْلَاةٍ، فَلْتَكُنْ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","فَتُحْضِرُ التَّقْدِمَةَ، سَوَاءٌ أَكَانَتْ مَخْبُوزَةً فِي فُرْنٍ أَمْ عَلَى الصَّاجِ أَمْ فِي مِقْلَاةٍ، إِلَى الْكَاهِنِ وَهُوَ يَقْتَرِبُ بِها إِلَى الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","وَيَتَنَاوَلُ مِنَ التَّقْدِمَةِ جُزْءاً تَذْكَارِيًّا وَيُحْرِقُهُ عَلَى الْمَذْبَحِ، فَيَكُونُ وَقُودَ مُحْرَقَةِ رِضًى تَسُرُّ الرَّبَّ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","أَمَّا بَقِيَّةُ التَّقْدِمَةِ فَتَكُونُ مِنْ نَصِيبِ هَرُونَ وَأَبْنَائِهِ، فَهِيَ تَقْدِمَةُ مُحْرَقَةٍ مُقَدَّسَةٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","لَا تَضَعُوا خَمِيراً فِي كُلِّ تَقْدِمَةِ دَقِيقٍ تُقَدِّمُونَهَا لِلرَّبِّ. كُلُّ قُرْبَانٍ فِيهِ خَمِيرٌ أَوْ عَسَلٌ لَا تُقَدِّمُوهُ مُحْرَقَةً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","يُمْكِنُ أَنْ تُقَدِّمُوا لِلرَّبِّ خُبْزاً مُخْتَمِراً وَعَسَلاً كَقَرَابِينِ بَوَاكِيرِ الْحَصَادِ، وَلَكِنَّهَا لَا تُصْعَدُ عَلَى الْمَذْبَحِ كَمُحْرَقَاتِ رِضًى وَسُرُورٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","عَلَيْكَ أَنْ تُمَلِّحَ تَقْدِمَاتِكَ. إِيَّاكَ أَنْ تُخْلِيَ تَقْدِمَتَكَ مِنْ مِلْحِ عَهْدِ إِلَهِكَ. مَعَ جَمِيعِ تَقْدِمَاتِكَ قَرِّبْ مِلْحاً. ");
INSERT INTO arbnav_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","وَإِنْ قَدَّمْتَ قُرْبَاناً مِنْ بَوَاكِيرِ حَصَادِكَ، فَلْيَكُنْ فَرِيكاً مَشْوِيًّا بِنَارٍ، تَنْزِعُ حَبَّهُ مِنْ رُؤُوسِ سَنَابِلِهِ الطَّرِيَّةِ وَتَجْرِشُهُ وَتَشْوِيهِ، ثُمَّ تُقَدِّمُهُ بَاكُورَةَ حَصَادِكَ، ");
INSERT INTO arbnav_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","بَعْدَ أَنْ تَصُبَّ عَلَيْهِ زَيْتاً وَتَضَعَ فَوْقَهُ لُبَاناً. إِنَّهُ تَقْدِمَةٌ. ");
INSERT INTO arbnav_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ثُمَّ يُحْرِقُ الْكَاهِنُ مِنْهُ جُزْءاً تَذْكَارِيًّا مَعَ زَيْتِهِ وَجَمِيعِ لُبَانِهِ، فَيَكُونُ مُحْرَقَةً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","وَإِنْ قَرَّبَ أَحَدٌ ذَبِيحَةَ سَلامٍ مِنْ بَقَرٍ، ثَوْراً أَوْ عِجْلَةً، فَلْيُقَدِّمْ قُرْبَاناً لِلرَّبِّ سَلِيماً مِنْ كُلِّ عَيْبٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","فَيَضَعُ الْمُقَرِّبُ يَدَهُ عَلَى رَأْسِ تَقْدِمَتِهِ وَيَذْبَحُهَا عِنْدَ بَابِ خَيْمَةِ الاجْتِمَاعِ، ثُمَّ يَرُشُّ أَبْنَاءُ هَرُونَ، الْكَهَنَةُ، الدَّمَ عَلَى جَوَانِبِ الْمَذْبَحِ، الْمُحِيطَةِ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","وَيُحْرِقُ الْكَاهِنُ أَمَامَ الرَّبِّ مِنْ ذَبِيحَةِ السَّلامِ، جَمِيعَ شَحْمِ الأَعْضَاءِ الدَّاخِلِيَّةِ ");
INSERT INTO arbnav_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","وَالْكُلْيَتَيْنِ وَشَحْمَهُمَا الَّذِي عَلَى الْخَاصِرَتَيْنِ وَالْمَرَارَةَ. ");
INSERT INTO arbnav_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","فَيُوْقِدُهَا أَبْنَاءُ هَرُونَ عَلَى الْمَذْبَحِ، عَلَى الْمُحْرَقَةِ الَّتِي فَوْقَ حَطَبِ النَّارِ، فَتَكُونُ مُحْرَقَةً وَوَقُودَ رِضًى تَسُرُّ الرَّبَّ. ");
INSERT INTO arbnav_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","وَإِنْ قَرَّبَ ذَبِيحَةَ سَلامٍ مِنْ غَنَمٍ، ذَكَراً أَوْ أُنْثَى، فَلْيُقَدِّمْ قُرْبَاناً لِلرَّبِّ سَلِيماً مِنْ كُلِّ عَيْبٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","وَإِنْ كَانَ الْقُرْبَانُ مِنَ الضَّأْنِ، فَلْيُقَدِّمْهُ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","وَيَضَعُ يَدَهُ عَلَى رَأْسِ تَقْدِمَتِهِ وَيَذْبَحُهَا عِنْدَ خَيْمَةِ الاجْتِمَاعِ، فَيَرُشُّ أَبْنَاءُ هَرُونَ دَمَهَا عَلَى جَوَانِبِ الْمَذْبَحِ الْمُحِيطَةِ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","وَيُحْرِقُ الْكَاهِنُ أَمَامَ الرَّبِّ مِنْ ذَبِيحَةِ السَّلامِ شَحْمَهَا، فَيَنْزِعُ كَامِلَ الأَلْيَةِ مِنْ عِنْدِ الْعُصْعُصِ وَجَمِيعَ شَحْمِ الأَعْضَاءِ الدَّاخِلِيَّةِ ");
INSERT INTO arbnav_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","وَالْكُلْيَتَيْنِ وَشَحْمَهُمَا الَّذِي عَلَى الْخَاصِرَتَيْنِ، وَالْمَرَارَةَ، ");
INSERT INTO arbnav_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","وَيُحْرِقُهَا الْكَاهِنُ عَلَى الْمَذْبَحِ طَعَامَ وَقُودٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","وَإِنْ كَانَ قُرْبَانُهُ مِنَ الْمَعَزِ فَلْيُقَدِّمْهُ أَمَامَ الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","فَيَضَعُ يَدَهُ عَلَى رَأْسِ تَقْدِمَتِهِ وَيَذْبَحُهَا عِنْدَ خَيْمَةِ الاجْتِمَاعِ، فَيَرُشُّ أَبْنَاءُ هَرُونَ دَمَهَا عَلَى جَوَانِبِ الْمَذْبَحِ الْمُحِيطَةِ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","وَيُحْرِقُ الْكَاهِنُ أَمَامَ الرَّبِّ مِنْ ذَبِيحَتِهِ جَمِيعَ شَحْمِ الأَعْضَاءِ الدَّاخِلِيَّةِ، ");
INSERT INTO arbnav_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","وَيَنْزِعُ كَذَلِكَ الْكُلْيَتَيْنِ وَشَحْمَهُمَا الَّذِي عَلَى الْخَاصِرَتَيْنِ وَالْمَرَارَةَ. ");
INSERT INTO arbnav_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","وَيُحْرِقُهَا الْكَاهِنُ عَلَى الْمَذْبَحِ طَعَامَ وَقُودِ رِضًى وَسُرُورٍ، فَيَكُونُ كُلُّ الشَّحْمِ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","لَا تَأْكُلُوا الشَّحْمَ وَلا الدَّمَ. هَذَا فَرْضٌ دَائِمٌ عَلَيْكُمْ حَيْثُ تُقِيمُونَ، جِيلاً بَعْدَ جِيلٍ». ");
INSERT INTO arbnav_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ: إِنْ سَهَتْ نَفْسٌ فَأَخْطَأَتْ فِي أَمْرٍ مِنْ كُلِّ نَوَاهِي الرَّبِّ، وَاقْتَرَفَتْ مَا لَا يَنْبَغِي، فَهَذَا مَا تَفْعَلُونَهُ: ");
INSERT INTO arbnav_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","إِنْ أَخْطَأَ الْكَاهِنُ الْمَمْسُوحُ سَهْواً، وَجَلَبَ عَلَى الشَّعْبِ إِثْماً، فَلْيُقَدِّمْ لِلرَّبِّ عَنْ خَطِيئَتِهِ الَّتِي ارْتَكَبَهَا ثَوْراً لَا عَيْبَ فِيهِ، ذَبِيحَةَ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","فَيُحْضِرُ الثَّوْرَ إِلَى مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ فِي حَضْرَةِ الرَّبِّ، وَيَضَعُ يَدَهُ عَلَى رَأْسِهِ وَيَذْبَحُهُ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","وَيَأْخُذُ الْكَاهِنُ الْمَمْسُوحُ مِنْ دَمِ الثَّوْرِ وَيَدْخُلُ بِهِ إِلَى خَيْمَةِ الاجْتِمَاعِ، ");
INSERT INTO arbnav_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ثُمَّ يَغْمِسُ إِصْبَعَهُ فِي الدَّمِ وَيَرُشُّ مِنْهُ سَبْعَ مَرَّاتٍ أَمَامَ الرَّبِّ عِنْدَ حِجَابِ الْقُدْسِ، الْفَاصِلِ بَيْنَ الْقُدْسِ وَقُدْسِ الأَقْدَاسِ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ثُمَّ يَضَعُ الْكَاهِنُ بَعْضَ الدَّمِ عَلَى قُرُونِ مَذْبَحِ الْبَخُورِ الْعَطِرِ الَّذِي فِي دَاخِلِ الْقُدْسِ فِي حَضْرَةِ الرَّبِّ. أَمَّا بَقِيَّةُ دَمِ الثَّوْرِ فَيَصُبُّهُ عِنْدَ قَاعِدَةِ مَذْبَحِ الْمُحْرَقَةِ، الْقَائِمِ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","وَيَنْزِعُ جَمِيعَ شَحْمِ ثَوْرِ الْخَطِيئَةِ وَشَحْمِ الأَعْضَاءِ الدَّاخِلِيَّةِ كُلِّهَا، ");
INSERT INTO arbnav_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","وَالْكُلْيَتَيْنِ وَشَحْمَهُمَا الَّذِي عَلَى الْخَاصِرَتَيْنِ وَالْمَرَارَةَ، ");
INSERT INTO arbnav_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","عَلَى غِرَارِ مَا يَفْعَلُ بِثَوْرِ ذَبِيحَةِ السَّلامِ، وَيُحْرِقُهَا الْكَاهِنُ عَلَى مَذْبَحِ الْمُحْرَقَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","أَمَّا جِلْدُ الثَّوْرِ وَكُلُّ لَحْمِهِ مَعَ رَأْسِهِ وَأَكَارِعِهِ وَأَمْعَائِهِ وَفَرْثِهِ ");
INSERT INTO arbnav_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","فَإِنَّهُ يَحْمِلُهَا إِلَى خَارِجِ الْمُخَيَّمِ إِلَى مَكَانٍ طَاهِرٍ، حَيْثُ يَطْرَحُ الرَّمَادَ، فَيُحْرِقُهَا كُلَّهَا عَلَى حَطَبٍ مُشْتَعِلٍ فَوْقَ مَكَانِ إِلْقَاءِ الرَّمَادِ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","وَإِنْ أَخْطَأَ شَعْبُ إِسْرَائِيلَ كُلُّهُ سَهْواً، وَاقْتَرَفُوا إِحْدَى نَوَاهِي الرَّبِّ الَّتِي لَا يَنْبَغِي اقْتِرَافُهَا، وَأَثِمُوا، وَكَانَ الْمَجْمَعُ غَافِلاً عَنِ الأَمْرِ، ");
INSERT INTO arbnav_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ثُمَّ اكْتَشَفَ الْمَجْمَعُ الْخَطِيئَةَ الْمُرْتَكَبَةَ، عِنْدَئِذٍ يُقَرِّبُ الْمَجْمَعُ ثَوْراً ذَبِيحَةَ خَطِيئَةٍ، يُحْضِرُونَهُ أَمَامَ الرَّبِّ عِنْدَ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","وَيَضَعُ شُيُوخُ الشَّعْبِ أَيْدِيَهُمْ عَلَى رَأْسِ الثَّوْرِ فِي حَضْرَةِ الرَّبِّ، وَيَذْبَحُونَهُ هُنَاكَ، ");
INSERT INTO arbnav_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","وَيَأْخُذُ الْكَاهِنُ الْمَمْسُوحُ مِنْ دَمِ الثَّوْرِ وَيَدْخُلُ بِهِ إِلَى خَيْمَةِ الاجْتِمَاعِ، ");
INSERT INTO arbnav_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ثُمَّ يَغْمِسُ إِصْبَعَهُ فِي الدَّمِ وَيَرُشُّ مِنْهُ سَبْعَ مَرَّاتٍ أَمَامَ الرَّبِّ عِنْدَ حِجَابِ الْقُدْسِ ");
INSERT INTO arbnav_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","وَكَذَلِكَ يَضَعُ بَعْضَ الدَّمِ عَلَى قُرُونِ مَذْبَحِ الْبَخُورِ الْعَطِرِ الَّذِي فِي دَاخِلِ الْقُدْسِ فِي حَضْرَةِ الرَّبِّ. أَمَّا بَقِيَّةُ الدَّمِ فَيَصُبُّهُ عِنْدَ قَاعِدَةِ مَذْبَحِ الْمُحْرَقَةِ الْقَائِمِ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","وَيَنْزِعُ الْكَاهِنُ جَمِيعَ شَحْمِهِ وَيُحْرِقُهُ عَلَى الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","وَيَفْعَلُ بِالثَّوْرِ كَمَا فَعَلَ بِثَوْرِ الْخَطِيئَةِ، فَيُكَفِّرُ عَنْهُمُ الْكَاهِنُ وَيَغْفِرُ اللهُ لَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ثُمَّ يَحْمِلُ بَقِيَّةَ الثَّوْرِ إِلَى خَارِجِ الْمُخَيَّمِ وَيُحْرِقُهُ كَمَا أَحْرَقَ الثَّوْرَ الأَوَّلَ، فَيَكُونُ ذَبِيحَةَ خَطِيئَةٍ عَنْ كُلِّ الشَّعْبِ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","إِنْ أَخْطَأَ أَحَدُ قَادَةِ الشَّعْبِ سَهْواً، وَاقْتَرَفَ إِحْدَى نَوَاهِي الرَّبِّ الَّتِي لَا يَنْبَغِي اقْتِرَافُهَا وَأَثِمَ، ");
INSERT INTO arbnav_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ثُمَّ تَنَبَّهَ إِلَى خَطَئِهِ الَّذِي ارْتَكَبَهُ، فَإِنَّهُ يُحْضِرُ قُرْبَاناً، جَدْياً ذَكَراً سَلِيماً مِنْ كُلِّ عَيْبٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","وَيَضَعُ يَدَهُ عَلَى رَأْسِ الْجَدْيِ وَيَذْبَحُهُ فِي الْجَانِبِ الشِّمَالِيِّ لِمَذْبَحِ الْمُحْرَقَةِ، أَمَامَ الرَّبِّ. فَيَكُونُ ذَبِيحَةَ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","وَيَأْخُذُ الْكَاهِنُ مِنْ دَمِ ذَبِيحَةِ الْخَطِيئَةِ بِإِصْبَعِهِ وَيَضَعُهُ عَلَى قُرُونِ مَذْبَحِ الْمُحْرَقَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","وَيُحْرِقُ جَمِيعَ شَحْمِهِ عَلَى الْمَذْبَحِ، كَمَا فَعَلَ بِشَحْمِ ذَبِيحَةِ السَّلامِ. وَهَكَذَا يُكَفِّرُ الْكَاهِنُ عَنْ خَطِيئَتِهِ، فَيَغْفِرُ الرَّبُّ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","وَإِنْ أَخْطَأَ وَاحِدٌ مِنْ عَامَّةِ الشَّعْبِ سَهْواً وَاقْتَرَفَ إِحْدَى نَوَاهِي الرَّبِّ الَّتِي لَا يَنْبَغِي اقْتِرَافُهَا وَأَثِمَ، ");
INSERT INTO arbnav_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ثُمَّ نُبِّهَ إِلَى خَطِيئَتِهِ الَّتِي ارْتَكَبَهَا، فَإِنَّهُ يُحْضِرُ قُرْبَاناً: عَنْزاً أُنْثَى سَلِيمَةً مِنْ كُلِّ عَيْبٍ لِلتَّكْفِيرِ عَنْ خَطِيئَتِهِ الَّتِي ارْتَكَبَهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","وَيَضَعُ يَدَهُ عَلَى رَأْسِ ذَبِيحَةِ الْخَطِيئَةِ وَيَذْبَحُهَا عِنْدَ مَوْضِعِ الْمُحْرَقَةِ، ");
INSERT INTO arbnav_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","فَيَأْخُذُ الْكَاهِنُ مِنْ دَمِهَا وَيَضَعُهُ عَلَى قُرُونِ مَذْبَحِ الْمُحْرَقَةِ، وَيَصُبُّ بَقِيَّةَ دَمِهَا عِنْدَ قَاعِدَةِ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ثُمَّ يَنْتَزِعُ الْكَاهِنُ جَمِيعَ شَحْمِهَا عَلَى غِرَارِ مَا فَعَلَ بِشَحْمِ ذَبِيحَةِ السَّلامِ، وَيُحْرِقُهَا عَلَى الْمَذْبَحِ تَقْدِمَةَ رِضًى وَسُرُورٍ لِلرَّبِّ فَيُكَفِّرُ الْكَاهِنُ عَنْهُ وَيَغْفِرُ الرَّبُّ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","وَإِنْ أَحْضَرَ قُرْبَانَهُ مِنَ الضَّأْنِ لِتَكُونَ ذَبِيحَةَ خَطِيئَةٍ، فَلْيَكُنْ نَعْجَةً سَلِيمَةً مِنْ كُلِّ عَيْبٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","فَيَضَعُ يَدَهُ عَلَى رَأْسِهَا وَيَذْبَحُهَا قُرْبَانَ خَطِيئَةٍ، فِي الْمَوْضِعِ الَّذِي تُذْبَحُ فِيهِ الْمُحْرَقَةُ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","وَيَأْخُذُ الْكَاهِنُ مِنْ دَمِ ذَبِيحَةِ الْخَطِيئَةِ بِإِصْبَعِهِ وَيَضَعُهُ عَلَى قُرُونِ مَذْبَحِ الْمُحْرَقَةِ، وَيَصُبُّ بَقِيَّةَ الدَّمِ عِنْدَ قَاعِدَةِ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","وَيَنْزِعُ جَمِيعَ شَحْمِهَا عَلَى غِرَارِ مَا فَعَلَ بِشَحْمِ ذَبِيحَةِ السَّلامِ، وَيُحْرِقُهُ عَلَى الْمَذْبَحِ فَوْقَ وَقَائِدِ الرَّبِّ. وَهَكَذَا يُكَفِّرُ الْكَاهِنُ عَنْ خَطِيئَتِهِ الَّتِي ارْتَكَبَهَا، وَيَغْفِرُ الرَّبُّ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","إِذَا أَخْطَأَ أَحَدٌ لأَنَّهُ صَمَتَ عِنْدَمَا اسْتُحْلِفَ، وَلَمْ يُدْلِ بِشَهَادَتِهِ حَوْلَ جَرِيمَةٍ رَآهَا أَوْ عَلِمَ بِها، فَإِنَّهُ يَكُونُ شَرِيكاً فِي الذَّنْبِ. ");
INSERT INTO arbnav_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","كُلُّ مَنْ يَلْمِسُ شَيْئاً نَجِساً، سَوَاءٌ أَكَانَ جُثَّةَ حَيَوَانٍ مُحَرَّمٍ أَكْلُهُ، أَمْ جُثَّةَ وَحْشٍ أَوْ حَشَرَةٍ مُحَرَّمَةٍ، يَكُونُ مُذْنِباً وَنَجِساً، حَتَّى لَوْ لَمْ يَعْلَمْ أَنَّهُ لَمَسَهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","كُلُّ مَنْ يَمَسُّ إِحْدَى نَجَاسَاتِ الإِنْسَانِ الَّتِي يَتَنَجَّسُ بِها، عَنْ غَيْرِ عِلْمٍ مِنْهُ، ثُمَّ نُبِّهَ إِلَى الأَمْرِ، يُصْبِحُ مُذْنِباً. ");
INSERT INTO arbnav_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","كُلُّ مَنْ يَحْلِفْ بِشَفَتَيْهِ دُونَ أَنْ يَتَفَكَّرَ، سَوَاءٌ لِلإِحْسَانِ أَوْ لِلإِسَاءَةِ مِنْ جَمِيعِ الأَحْلافِ الَّتِي يَفْرُطُ بِها اللِّسَانُ، مِنْ غَيْرِ عِلْمٍ مِنْهُ، ثُمَّ نُبِّهَ إِلَى الأَمْرِ، يُصْبِحْ مُذْنِباً فِي كِلا الْحَالَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","فَكُلُّ مَنْ يَكُونُ مُذْنِباً فِي أَحَدِ هَذِهِ الأُمُورِ، عَلَيْهِ الإِقْرَارُ بِمَا أَخْطَأَ بِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ثُمَّ يُحْضِرُ إِلَى الرَّبِّ ذَبِيحَةَ إِثْمٍ عَنْ خَطِيئَتِهِ الَّتِي اقْتَرَفَهَا: نَعْجَةً أَوْ عَنْزَةً، فَيُكَفِّرُ الْكَاهِنُ عَنْ خَطِيئَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","وَإِنْ كَانَ فَقِيراً، غَيْرَ قَادِرٍ عَلَى إِحْضَارِ شَاةٍ، فَلْيُقَدِّمْ إِلَى الرَّبِّ ذَبِيحَةً عَنْ إِثْمِهِ الَّذِي ارْتَكَبَهُ يَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ، فَيَكُونُ أَحَدُهَا ذَبِيحَةَ خَطِيئَةٍ وَالآخَرُ مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","فَيَأْخُذُ الْكَاهِنُ ذَبِيحَةَ الْخَطِيئَةِ أَوَّلاً، وَيُقَرِّبُهَا بِأَنْ يَحُزَّ رَأْسَهَا مِنَ الْخَلْفِ وَلا يَفْصِلَهُ، ");
INSERT INTO arbnav_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","وَيَرُشُّ بَعْضَ دَمِهَا عَلَى حَائِطِ الْمَذْبَحِ، وَيُصَفِّي بَقِيَّةَ الدَّمِ عِنْدَ قَاعِدَةِ الْمَذْبَحِ. إِنَّهَا ذَبِيحَةُ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ثُمَّ يُقَدِّمُ الثَّانِي مُحْرَقَةً وَفْقاً لِلنِّظَامِ الْمُتَّبَعِ، وَهَكَذَا يُكَفِّرُ الْكَاهِنُ عَنْ خَطِيئَةِ الْمُذْنِبِ وَيَغْفِرُ الرَّبُّ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","وَإِنْ كَانَ الْمُذْنِبُ أَفْقَرَ مِنْ أَنْ يُقَدِّمَ يَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ، فَلْيُحْضِرْ قُرْبَاناً عَنْ خَطِيئَتِهِ. عُشْرَ الإِيفَةِ (نَحْوَ لِتْرَيْنِ وَنِصْفِ اللِّتْرِ) مِنْ دَقِيقٍ نَاعِمٍ، لَا يَضَعُ عَلَيْهِ زَيْتاً أَوْ لُبَاناً، لأَنَّهُ قُرْبَانُ خَطِيئَةٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","وَيُقَدِّمْهُ إِلَى الْكَاهِنِ، فَيَمْلأُ مِنْهُ قَبْضَتَهُ لِلتَّذْكَارِ، وَيُحْرِقُهُ عَلَى الْمَذْبَحِ، عَلَى وَقَائِدِ الرَّبِّ. إِنَّهُ قُرْبَانُ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","فَيُكَفِّرُ الْكَاهِنُ بِذَلِكَ عَنْ أَيِّ خَطِيئَةٍ مِنَ الْخَطَايَا السَّالِفَةِ الَّتِي ارْتَكَبَهَا، فَيَغْفِرُ الرَّبُّ لَهُ. أَمَّا بَقِيَّةُ التَّقْدِمَةِ فَتَكُونُ مِنْ نَصِيبِ الْكَاهِنِ عَلَى غِرَارِ تَقْدِمَةِ الدَّقِيقِ». ");
INSERT INTO arbnav_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","قَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«إِنْ سَهَا أَحَدٌ وَتَعَدَّى عَلَى وَاحِدٍ مِنْ أَقْدَاسِ الرَّبِّ، يُحْضِرُ إِلَى الرَّبِّ ذَبِيحَةَ إِثْمٍ: كَبْشاً سَلِيماً، يُقَدِّرُ الْكَاهِنُ قِيمَتَهُ مِنَ الْفِضَّةِ وَفْقاً لِلْمَعَايِيرِ الْمُسْتَعْمَلَةِ فِي الْقُدْسِ، ");
INSERT INTO arbnav_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","فَيُعَوِّضُ عَمَّا أَخْطَأَ بِهِ مِنَ الْقُدْسِ، بَعْدَ أَنْ يُضِيفَ عَلَيْهِ مَا يُعَادِلُ خُمْسَهُ غَرَامَةً، وَيُؤَدِّيَهُ لِلْكَاهِنِ. فَيُكَفِّرُ الْكَاهِنُ عَنْهُ بِكَبْشِ الإِثْمِ، وَيَغْفِرُ الرَّبُّ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","إِنْ أَخْطَأَ أَحَدٌ سَهْواً وَارْتَكَبَ إِحْدَى نَوَاهِي الرَّبِّ الَّتِي يَنْبَغِي أَلّا يَرْتَكِبَهَا، يَكُونُ مُذْنِباً وَمَسْؤولاً عَنْ إِثْمِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","وَعَلَيْهِ أَنْ يُحْضِرَ إِلَى الْكَاهِنِ ذَبِيحَةَ إِثْمٍ كَبْشاً سَلِيماً تُقَدِّرُ أَنْتَ ثَمَنَهُ، فَيُكَفِّرُ الْكَاهِنُ عَمَّا ارْتَكَبَهُ الْمُخْطِئُ مِنْ سَهْوٍ عَلَى غَيْرِ عِلْمٍ مِنْهُ، فَيَغْفِرُ الرَّبُّ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","إِنَّهُ ذَبِيحَةُ إِثْمٍ، إِذْ قَدِ ارْتَكَبَ ذَنْباً فِي حَقِّ الرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«إِنْ أَخْطَأَ أَحَدٌ فِي حَقِّ الرَّبِّ وَرَفَضَ أَنْ يَرُدَّ لِصَاحِبِهِ وَدِيعَةً أَوْ أَمَانَةً أَوْ مَسْلُوباً، أَوِ اغْتَصَبَ مِنْهُ شَيْئاً، ");
INSERT INTO arbnav_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","أَوْ عَثَرَ عَلَى شَيْءٍ مَفْقُودٍ وَأَنْكَرَهُ، أَوْ حَلَفَ كَاذِباً عَلَى خَطِيئَةٍ ارْتَكَبَهَا فَأَثِمَ، ");
INSERT INTO arbnav_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","فَعَلَيْهِ إِذَا أَخْطَأَ وَأَثِمَ أَنْ يَرُدَّ مَا سَلَبَهُ أَوِ اغْتَصَبَهُ أَوِ اسْتُوْدِعَهُ، أَوِ الْمَفْقُودَ الَّذِي عَثَرَ عَلَيْهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","أَوْ كُلَّ مَا حَلَفَ عَلَيْهِ كَاذِباً، وَيُعَوِّضَ قِيمَةَ الشَّيْءِ مُضَافاً إِلَيْهِ خُمْسُهُ، وَفِي نَفْسِ الْيَوْمِ يُحْضِرُ إِلَى خَيْمَةِ الْاِجْتِمَاعِ ذَبِيحَةَ إِثْمٍ: ");
INSERT INTO arbnav_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","كَبْشاً سَلِيماً تُقَدِّرُ أَنْتَ ثَمَنَهُ وَيَأْتِي بِهِ إِلَى الْكَاهِنِ، ");
INSERT INTO arbnav_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","فَيُكَفِّرُ عَنْهُ الْكَاهِنُ أَمَامَ الرَّبِّ، فَيَغْفِرُ الرَّبُّ لَهُ ذَنْبَهُ الَّذِي ارْتَكَبَهُ». ");
INSERT INTO arbnav_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«وَهَذَا مَا تُوْصِي بِهِ هَرُونَ وَأَبْنَاءَهُ بِشَأْنِ شَرِيعَةِ تَقْدِمَةِ الْمُحْرَقَةِ: تُتْرَكُ الْمُحْرَقَةُ عَلَى الْمَوْقِدَةِ فَوْقَ الْمَذْبَحِ كُلَّ اللَّيْلِ حَتَّى الصَّبَاحِ، وَنَارُ الْمَذْبَحِ تَتَوَهَّجُ عَلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ثُمَّ يَرْتَدِي الْكَاهِنُ ثَوْبَهُ وَسَرَاوِيلَهُ الْكَتَّانِيَّةَ، وَيُنَظِّفُ الْمَذْبَحَ مِنْ رَمَادِ الْمُحْرَقَةِ وَيَضَعُهُ إِلَى جَانِبِ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ثُمَّ يَسْتَبْدِلُ مَلابِسَهُ بِمَلابِسَ أُخْرَى، وَيَحْمِلُ هَذَا الرَّمَادَ إِلَى خَارِجِ الْمُخَيَّمِ إِلَى مَكَانٍ طَاهِرٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","وَتَظَلُّ النَّارُ فِي غُضُونِ ذَلِكَ تَتَوَهَّجُ عَلَى الْمَذْبَحِ لَا تُطْفَأُ، لِكَيْ يُشْعِلَ الْكَاهِنُ بِها حَطَباً كُلَّ صَبَاحٍ، وَيُرَتِّبَ عَلَيْهَا الْمُحْرَقَةَ، وَيُوْقِدَ عَلَيْهَا شَحْمَ ذَبِيحَةِ السَّلامِ الْيَوْمِيَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","لِتَبْقَ النَّارُ دَائِماً مُتَّقِدَةً عَلَى الْمَذْبَحِ، لَا تَنْطَفِئُ أَبَداً. ");
INSERT INTO arbnav_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","وَهَذِهِ نُصُوصُ تَعْلِيمَاتِ تَقْدِمَةِ الدَّقِيقِ الَّتِي يُقَرِّبُهَا أَبْنَاءُ هَرُونَ فِي حَضْرَةِ الرَّبِّ أَمَامَ الْمَذْبَحِ: ");
INSERT INTO arbnav_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","يَأْخُذُ الْكَاهِنُ مِلْءَ قَبْضَتِهِ مِنْ دَقِيقِ التَّقْدِمَةِ وَزَيْتِهَا وَكُلَّ اللُّبَانِ الَّذِي عَلَيْهَا، وَيُحْرِقُهَا عَلَى الْمَذْبَحِ لِلتَّذْكَارِ، فَتَكُونُ ذَبِيحَةَ رِضًى وَسُرُورٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","أَمَّا بَقِيَّتُهَا فَيَأْكُلُهُ هَرُونُ وَأَبْنَاؤُهُ فَطِيراً فِي مَكَانٍ مُقَدَّسٍ فِي دَارِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","يَجِبُ أَلّا يُخْبَزَ بِخَمِيرَةٍ، فَقَدْ جَعَلْتُهُ نَصِيبَ الْكَهَنَةِ مِنْ مُحْرَقَاتِي. إِنَّهَا قُدْسُ أَقْدَاسٍ كَذَبِيحَةِ الْخَطِيئَةِ وَذَبِيحَةِ الإِثْمِ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","كُلُّ ذَكَرٍ مِنْ أَبْنَاءِ هَرُونَ يَأْكُلُ مِنْهَا، فَتَكُونُ لَكُمْ مِنْ مُحْرَقَاتِ الرَّبِّ فَرِيضَةً أَبَدِيَّةً جِيلاً بَعْدَ جِيلٍ، وَلا يَمَسُّهَا إِلّا مَنْ كَانَ مُقَدَّساً». ");
INSERT INTO arbnav_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«هَذَا مَا يُقَرِّبُهُ هَرُونُ وَأَبْنَاؤُهُ لِلرَّبِّ يَوْمَ تَكْرِيسِهِمْ كَهَنَةً: يُقَدِّمُونَ لِلرَّبِّ عُشْرَ الإِيفَةِ (نَحْوَ لِتْرَيْنِ وَنِصْفِ اللِّتْرِ) تَقْدِمَةً دَائِمَةً مِنَ الدَّقِيقِ، نِصْفُهَا فِي الصَّبَاحِ وَنِصْفُهَا فِي الْمَسَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","مَعْجُونَةً بِزَيْتٍ عَجْناً جَيِّداً وَمَخْبُوزَةً عَلَى صَاجٍ وَمُقَطَّعَةً إِلَى فُتَاتٍ، فَتُقَرِّبُونَهَا لِلرَّبِّ قُرْبَانَ رِضًى وَسُرُورٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","وَعَلَى كُلِّ أَبْنَاءِ الْكَهَنَةِ الَّذِينَ يَتَكَرَّسُونَ كَهَنَةً عِوَضاً عَنْ وَالِدِيهِمْ أَنْ يُقَدِّمُوا التَّقْدِمَةَ نَفْسَهَا فَرِيضَةً أَبَدِيَّةً لِلرَّبِّ، وَتُحْرَقُ كُلُّهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","كُلُّ تَقْدِمَةِ كَاهِنٍ تُحْرَقُ بِأَجْمَعِهَا، وَلا يُؤْكَلُ مِنْهَا». ");
INSERT INTO arbnav_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«قُلْ لِهَرُونَ وَأَبْنَائِهِ: هَذِهِ نُصُوصُ تَعْلِيمَاتِ ذَبِيحَةِ الْخَطِيئَةِ: تُذْبَحُ ذَبِيحَةُ الْخَطِيئَةِ فِي حَضْرَةِ الرَّبِّ، فِي نَفْسِ الْمَكَانِ الَّذِي تُذْبَحُ فِيهِ الْمُحْرَقَةُ. إِنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","وَعَلَى الْكَاهِنِ الَّذِي يُقَرِّبُهَا أَنْ يَأْكُلَهَا فِي مَكَانٍ مُقَدَّسٍ، فِي دَارِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","كُلُّ مَنْ مَسَّ لَحْمَهَا يَكُونُ مُقَدَّساً. وَإذَا تَنَاثَرَ دَمُهَا عَلَى ثَوْبٍ، تَغْسِلُ الثَّوْبَ فِي مَوْضِعٍ مُقَدَّسٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","أَمَّا إِنَاءُ الْخَزَفِ الَّذِي تُطْبَخُ فِيهِ فَيُكْسَرُ. أَمَّا إِنْ طُبِخَتْ فِي إِنَاءٍ نُحَاسِيٍّ فَيَجِبُ أَنْ يُجْلَى وَيُغْسَلَ بِمَاءٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","لَا يَأْكُلُ مِنْهَا إِلّا الذُّكُورُ مِنْ أَوْلادِ الْكَهَنَةِ لأَنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","كُلُّ ذَبِيحَةٍ يُؤْخَذُ مِنْ دَمِهَا إِلَى خَيْمَةِ الاجْتِمَاعِ لِلتَّكْفِيرِ فِي الْقُدْسِ لَا يُؤْكَلُ مِنْهَا بَلْ تُحْرَقُ كُلُّهَا بِنَارٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","وَهَذِهِ نُصُوصُ تَعْلِيمَاتِ ذَبِيحَةِ الإِثْمِ. إِنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","تَذْبَحُونَ ذَبِيحَةَ الإِثْمِ فِي نَفْسِ الْمَوْضِعِ الَّذِي تَذْبَحُونَ فِيهِ ذَبِيحَةَ الْمُحْرَقَةِ، وَيُرَشُّ دَمُهَا عَلَى جَوَانِبِ الْمَذْبَحِ الْمُحِيطَةِ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","وَيُقَرِّبُ الْكَاهِنُ مِنْهَا كُلَّ شَحْمِهَا: الأَلْيَةَ وَشَحْمَ الأَعْضَاءِ الدَّاخِلِيَّةِ، ");
INSERT INTO arbnav_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","وَالْكُلْيَتَيْنِ وَشَحْمَهُمَا الَّذِي عَلَى الْخَاصِرَتَيْنِ وَيَنْزِعُ الْمَرَارَةَ مَعَ الْكُلْيَتَيْنِ، ");
INSERT INTO arbnav_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","وَيُحْرِقُهَا الْكَاهِنُ عَلَى الْمَذْبَحِ وَقُوداً لِلرَّبِّ. إِنَّهَا قُرْبَانُ إِثْمٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","كُلُّ ذَكَرٍ مِنَ الْكَهَنَةِ يَأْكُلُ مِنْهَا فِي مَكَانٍ مُقَدَّسٍ، لأَنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","وَشَرِيعَةُ ذَبِيحَةِ الإِثْمِ مُمَاثِلَةٌ لِذَبِيحَةِ الْخَطِيئَةِ، إِذْ تَكُونُ مِنْ نَصِيبِ الْكَاهِنِ الَّذِي يُكَفِّرُ بِها. ");
INSERT INTO arbnav_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","وَالْكَاهِنُ الَّذِي يُقَرِّبُ مُحْرَقَةَ إِنْسَانٍ يَكُونُ جِلْدُ الْمُحْرَقَةِ الْمُقَرَّبَةِ مِنْ نَصِيبِهِ أَيْضاً، ");
INSERT INTO arbnav_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","وَكَذَلِكَ كُلُّ تَقْدِمَةِ دَقِيقٍ مَخْبُوزٍ فِي فُرْنٍ أَوْ مِقْلَاةٍ أَوْ عَلَى الصَّاجِ تَكُونُ لِلْكَاهِنِ الَّذِي يُقَرِّبُهَا ");
INSERT INTO arbnav_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","وَكُلُّ تَقْدِمَةِ دَقِيقٍ بِزَيْتٍ أَوْ جَافَّةٍ تَكُونُ مِنْ نَصِيبِ أَبْنَاءِ هَرُونَ، تُوَزَّعُ عَلَيْهِمْ بِالتَّسَاوِي. ");
INSERT INTO arbnav_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","وَهَذِهِ نُصُوصُ تَعْلِيمَاتِ ذَبِيحَةِ السَّلامِ الْمُقَرَّبَةِ إِلَى الرَّبِّ: ");
INSERT INTO arbnav_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","إِنْ قَرَّبَهَا أَحَدٌ لأَجْلِ الشُّكْرِ، فَلْيُقَدِّمْ مَعَهَا كَعْكاً غَيْرَ مُخْتَمِرٍ مَعْجُوناً بِزَيْتٍ، وَرِقَاقَ فَطِيرٍ مَدْهُونَةً بِالزَّيْتِ وَدَقِيقاً مَلْتُوتاً بِزَيْتٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","فَضْلاً عَنْ أَرْغِفَةِ خُبْزٍ مُخْتَمِرَةٍ، يُقَرِّبُهَا مَعَ ذَبِيحَةِ شُكْرِ سَلامَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","وَعَلَيْهِ أَنْ يُقَدِّمَ وَاحِداً مِنْ كُلِّ قُرْبَانٍ يَرْفَعُهُ وَيُرَجِّحُهُ أَمَامَ الرَّبِّ وَيَكُونُ مِنْ نَصِيبِ الْكَاهِنِ الَّذِي يَرُشُّ دَمَ ذَبِيحَةِ السَّلامِ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","أَمَّا لَحْمُ ذَبِيحَةِ شُكْرِ سَلامَتِهِ فَيُؤْكَلُ فِي نَفْسِ يَوْمِ تَقْدِيمِ الذَّبِيحَةِ كَقُرْبَانٍ، لَا يُبْقِي مِنْهُ شَيْئاً إِلَى الصَّبَاحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","وَإذَا كَانَتْ ذَبِيحَةُ تَقْدِمَتِهِ نَذْراً أَوْ ذَبِيحَةً اخْتِيَارِيَّةً أُخْرَى، فَإِنَّهَا تُؤْكَلُ فِي يَوْمِ تَقْدِيمِهَا، وَفِي الْيَوْمِ التَّالِي يُؤْكَلُ مَا فَضَلَ مِنْهَا، ");
INSERT INTO arbnav_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","وَيُحْرَقُ كُلُّ مَا يَتَبَقَّى مِنَ الذَّبِيحَةِ لِلْيَوْمِ الثَّالِثِ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","وَكُلُّ مَنْ يَأْكُلُ مِنْ ذَبِيحَةِ سَلامَتِهِ فِي الْيَوْمِ الثَّالِثِ يَكُونُ مُذْنِباً، لأَنَّهَا تُصْبِحُ غَيْرَ مَقْبُولَةٍ وَلا يَحْسَبُهَا اللهُ لِمَنْ قَرَّبَهَا إِذْ تَكُونُ نَجِسَةً. ");
INSERT INTO arbnav_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","وَأَيُّ لَحْمٍ يَمَسُّ شَيْئاً نَجِساً لَا تَأْكُلُوا مِنْهُ بَلْ أَحْرِقُوهُ بِالنَّارِ. لَا يَأْكُلُ مَنَ اللَّحْمِ إِلا مَنْ كَانَ طَاهِراً. ");
INSERT INTO arbnav_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","وَكُلُّ نَجِسٍ يَأْكُلُ مِنْ لَحْمِ ذَبِيحَةِ السَّلامِ الْمُكَرَّسَةِ لِلرَّبِّ يُسْتَأْصَلُ مِنْ بَيْنِ شَعْبِهِ ");
INSERT INTO arbnav_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","وَالنَّفْسُ الَّتِي تَمَسُّ شَيْئاً نَجِساً، سَوَاءٌ أَكَانَ نَجَاسَةَ إِنْسَانٍ أَمْ حَيَوَانٍ أَمْ مَكْرُوهاً مَا نَجِساً، ثُمَّ تَتَنَاوَلُ مِنْ لَحْمِ ذَبِيحَةِ السَّلامِ، تُسْتَأْصَلُ تِلْكَ النَّفْسُ مِنْ بَيْنِ شَعْبِهَا». ");
INSERT INTO arbnav_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«أَوْصِ بَنِي إِسْرَائِيلَ: لَا تَأْكُلُوا كُلَّ شَحْمِ ثَوْرٍ أَوْ كَبْشٍ أَوْ مَاعِزٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","أَمَّا شَحْمُ الْحَيَوَانَاتِ الْمَيْتَةِ أَوِ الْمُفْتَرَسَةِ فَاسْتَخْدِمُوهُ فِي أَغْرَاضِكُمُ الْمُخْتَلِفَةِ، إِنَّمَا إِيَّاكُمْ أَنْ تَأْكُلُوا مِنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","مَنْ يَأْكُلُ شَحْمَ بَهَائِمِ الْمُحْرَقَاتِ الَّتِي تُقَدِّمُونَهَا لِلرَّبِّ يُبَادُ مِنْ بَيْنِ شَعْبِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","لَا تَأْكُلُوا فِي جَمِيعِ مَسَاكِنِكُمْ مِنْ دَمِ الطَّيْرِ أَوِ الْبَهَائِمِ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","مَنْ يَأْكُلُ شَيْئاً مِنَ الدَّمِ يُبَادُ مِنْ بَيْنِ شَعْبِهِ». ");
INSERT INTO arbnav_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«أَوْصِ بَنِي إِسْرَائِيلَ: مَنْ يُقَدِّمُ لِلرَّبِّ ذَبِيحَةَ سَلامَتِهِ عَلَيْهِ أَنْ يُحْضِرَهَا بِنَفْسِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","هُوَ نَفْسُهُ يَأْتِي بِوَقَائِدِ الرَّبِّ. يَأْتِي بِالشَّحْمِ وَالصَّدْرِ. فَيُرَجِّحُ الصَّدْرَ أَمَامَ الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","أَمَّا الشَّحْمُ فَيُوْقِدُهُ الْكَاهِنُ عَلَى الْمَذْبَحِ، وَيَكُونُ الصَّدْرُ مِنْ نَصِيبِ هَرُونَ وَبَنِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","وَتُقَدِّمُونَ السَّاقَ الْيُمْنَى مِنْ ذَبَائِحِ سَلامَتِكُمْ إِلَى الْكَاهِنِ نَصِيباً لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","فَمَنْ يُقَرِّبُ دَمَ قُرْبَانِ السَّلامِ وَالشَّحْمَ مِنْ أَبْنَاءِ هَرُونَ تَكُونُ السَّاقُ الْيُمْنَى نَصِيباً لَهُ، ");
INSERT INTO arbnav_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","لأَنَّنِي قَدْ أَخَذْتُ صَدْرَ التَّرْجِيحِ وَسَاقَ ذَبِيحَةِ سَلامِ بَنِي إِسْرَائِيلَ وَأَعْطَيْتُهَا لِهَرُونَ الْكَاهِنِ وَأَبْنَائِهِ، فَرِيضَةً دَائِمَةً، جِيلاً بَعْدَ جِيلٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","هَذَا هُوَ نَصِيبُ هَرُونَ وَنَصِيبُ أَبْنَائِهِ مِنْ مُحْرَقَاتِ الرَّبِّ، يَوْمَ تَكْرِيسِهِمْ لِيَكُونُوا كَهَنَةً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","وَقَدْ أَمَرَ الرَّبُّ أَنْ يُعْطَى لَهُمْ يَوْمَ تَكْرِيسِهِمْ مِنْ بَيْنِ بَنِي إِسْرَائِيلَ، فَرِيضَةً دَائِمَةً جِيلاً بَعْدَ جِيلٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","تِلْكَ هِي نُصُوصُ تَعْلِيمَاتِ شَرِيعَةِ الْمُحْرَقَةِ وَتَقْدِمَةِ الدَّقِيقِ وَذَبِيحَةِ الْخَطيئَةِ وَذَبِيحَةِ الإِثْمِ، وَذَبِيحَةِ التَّكْرِيسِ وَذَبِيحَةِ السَّلامِ، ");
INSERT INTO arbnav_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","الَّتِي أَوْصَى الرَّبُّ بِها مُوسَى فِي جَبَلِ سِينَاءَ، عِنْدَمَا أَمَرَ بَنِي إِسْرَائِيلَ بِتَقْدِيمِ قَرَابِينِهِمْ لِلرَّبِّ فِي صَحْرَاءِ سِينَاءَ». ");
INSERT INTO arbnav_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«أَحْضِرْ هَرُونَ وَأَبْنَاءَهُ وَثِيَابَهُمْ وَدُهْنَ الْمَسْحَةِ وَثَوْرَ ذَبِيحَةِ الْخَطِيئَةِ وَالْكَبْشَيْنِ وَسَلَّ الْفَطِيرِ، ");
INSERT INTO arbnav_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","وَاجْمَعْ سَائِرَ بَنِي إِسْرَائِيلَ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ». ");
INSERT INTO arbnav_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","فَنَفَّذَ مُوسَى أَمْرَ الرَّبِّ، فَاجْتَمَعَتِ الْجَمَاعَةُ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، ");
INSERT INTO arbnav_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","فَقَالَ لَهُمْ مُوسَى: «هَذَا مَا أَمَرَ الرَّبُّ بِهِ». ");
INSERT INTO arbnav_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","فَقَدَّمَ مُوسَى هَرُونَ وَأَبْنَاءَهُ وَغَسَّلَهُمْ بِمَاءٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","وَأَلْبَسَ هَرُونَ الْقَمِيصَ وَنَطَّقَهُ بِالْحِزَامِ، وَكَسَاهُ بِالْجُبَّةِ، وَوَضَعَ عَلَيْهِ الرِّدَاءَ، وَنَطَّقَهُ بِحِزَامِ الرِّدَاءِ وَشَدَّهُ بِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","وَجَعَلَ عَلَيْهِ الصُّدْرَةَ، وَثَبَّتَ فِي الصُّدْرَةِ الْأُورِيمَ وَالتُّمِّيمَ، ");
INSERT INTO arbnav_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","وَوَضَعَ مُوسَى عَلَى رَأْسِ هَرُونَ الْعِمَامَةَ، وَعَلَّقَ عَلَيْهَا فَوْقَ الْجَبْهَةِ صَفِيحَةَ الذَّهَبِ، الإِكْلِيلَ الْمُقَدَّسَ، تَمَاماً كَمَا أَمَرَهُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ثُمَّ أَخَذَ مُوسَى دُهْنَ الْمَسْحَةِ وَمَسَحَ الْمَسْكِنَ وَكُلَّ مَا فِيهِ وَقَدَّسَهُ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ثُمَّ رَشَّ مِنَ الدُّهْنِ عَلَى الْمَذْبَحِ سَبْعَ مَرَّاتٍ، وَمَسَحَ الْمَذْبَحَ وَجَمِيعَ أَوَانِيهِ وَحَوْضَ الاغْتِسَالِ وَقَاعِدَتَهُ لِتَقْدِيسِهَا، ");
INSERT INTO arbnav_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","وَصَبَّ مِنْ دُهْنِ الْمَسْحَةِ عَلَى رَأْسِ هَرُونَ وَمَسَحَهُ تَكْرِيساً لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ثُمَّ أَحْضَرَ مُوسَى أَبْنَاءَ هَرُونَ وَأَلْبَسَهُمْ أَقْمِصَةً، وَنَطَّقَهُمْ بِأَحْزِمَةٍ، وَعَصَبَ عَلَى رُؤُوسِهِمِ الْقَلانِسَ كَمَا أَمَرَهُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ثُمَّ أَتَى بِثَوْرِ الْخَطِيئَةِ، فَوَضَعَ هَرُونُ وَأَبْنَاؤُهُ أَيْدِيَهُمْ عَلَى رَأْسِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","فَذَبَحَهُ مُوسَى، وَأَخَذَ الدَّمَ وَوَضَعَهُ عَلَى قُرُونِ الْمَذْبَحِ الأَرْبَعَةِ، وَعَلَى الْمَذْبَحِ نَفْسِهِ لِيُقَدِّسَهُ. ثُمَّ صَبَّ بَقِيَّةَ الدَّمِ عِنْدَ قَاعِدَتِهِ، وَكَرَّسَهُ تَكْفِيراً عَنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","وَأَخَذَ مُوسَى شَحْمَ أَعْضَاءِ الثَّوْرِ الدَّاخِلِيَّةِ، وَكَذَلِكَ الْمَرَارَةَ وَالْكُلْيَتَيْنِ وَشَحْمَهُمَا وَأَحْرَقَهَا كُلَّهَا عَلَى الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","وَأَمَّا جِلْدُ الثَّوْرِ وَلَحْمُهُ وَفَرْثُهُ فَأَحْرَقَهَا بِنَارٍ خَارِجَ الْمُخَيَّمِ كَمَا أَمَرَهُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ثُمَّ قَدَّمَ كَبْشَ الْمُحْرَقَةِ، فَوَضَعَ هَرُونُ وَأَبْنَاؤُهُ أَيْدِيَهُمْ عَلَى رَأْسِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","فَذَبَحَهُ مُوسَى وَرَشَّ الدَّمَ عَلَى جَوَانِبِ الْمَذْبَحِ، ");
INSERT INTO arbnav_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","وَقَطَّعَ الْكَبْشَ إِلَى أَجْزَائِهِ، ثُمَّ أَحْرَقَ الرَّأْسَ وَالأَجْزَاءَ وَالشَّحْمَ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","وَأَمَّا أَمْعَاؤُهُ وَأَكَارِعُهُ فَقَدْ غَسَلَهَا بِمَاءٍ. وَأَحْرَقَ مُوسَى كُلَّ الْكَبْشِ عَلَى الْمَذْبَحِ، فَكَانَ مُحْرَقَةً لِرِضَى الرَّبِّ وَسُرُورِهِ. وَقُودٌ هُوَ لِلرَّبِّ، تَمَاماً كَمَا أَمَرَ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ثُمَّ أَحْضَرَ الْكَبْشَ الثَّانِي، كَبْشَ التَّكْرِيسِ، فَوَضَعَ هَرُونُ وَأَبْنَاؤُهُ أَيْدِيَهُمْ عَلَى رَأْسِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","فَذَبَحَهُ مُوسَى، وَأَخَذَ مِنْ دَمِهِ فَوَضَعَهُ عَلَى شَحْمَةِ أُذْنِ هَرُونَ الْيُمْنَى، وَعَلَى إِبْهَامِ يَدِهِ الْيُمْنَى وَإِبْهَامِ رِجْلِهِ الْيُمْنَى. ");
INSERT INTO arbnav_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ثُمَّ قَدَّمَ مُوسَى أَبْنَاءَ هَرُونَ وَوَضَعَ مِنَ الدَّمِ عَلَى شَحْمِ آذَانِهِمِ الْيُمْنَى، وَعَلَى أَبَاهِمِ أَيْدِيهِمِ الْيُمْنَى، وَعَلَى أَبَاهِمِ أَرْجُلِهِمِ الْيُمْنَى، وَرَشَّ بَقِيَّةَ الدَّمِ عَلَى جَوَانِبِ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ثُمَّ أَخَذَ شَحْمَ الأَلْيَةِ وَكُلَّ شَحْمِ الأَعْضَاءِ الدَّاخِلِيَّةِ وَالْمَرَارَةَ وَالْكُلْيَتَيْنِ وَشَحْمَهُمَا وَالسَّاقَ الْيُمْنَى، ");
INSERT INTO arbnav_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","وَأَخَذَ مِنْ سَلِّ الْفَطِيرِ الَّذِي فِي حَضْرَةِ الرَّبِّ قُرْصَ فَطِيرٍ وَاحِداً، وَكَعْكَةً وَاحِدَةً مَعْجُونَةً بِزَيْتٍ وَرِقَاقَةً، وَوَضَعَهَا عَلَى الشَّحْمِ وَعَلَى السَّاقِ الْيُمْنَى، ");
INSERT INTO arbnav_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","وَوَضَعَهَا جَمِيعاً عَلَى كَفَّيْ هَرُونَ وَأَكُفِّ أَبْنَائِهِ لِيُرَجِّحُوهَا أَمَامَ الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ثُمَّ أَخَذَهَا مُوسَى عَنْ أَكُفِّهِمْ وَأَحْرَقَهَا أَمَامَ الرَّبِّ عَلَى الْمَذْبَحِ فَوْقَ الْمُحْرَقَةِ، فَكَانَتْ قُرْبَانَ تَكْرِيسٍ لِرِضَى الرَّبِّ وَسُرُورِهِ. إِنَّهَا مُحْرَقَةٌ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","وَتَنَاوَلَ مُوسَى صَدْرَ كَبْشِ التَّكْرِيسِ وَرَجَّحَهُ أَمَامَ الرَّبِّ، فَكَانَ الصَّدْرُ نَصِيبَ مُوسَى كَمَا أَمَرَهُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ثُمَّ أَخَذَ مُوسَى بَعْضَ دُهْنِ الْمَسْحَةِ وَبَعْضَ الدَّمِ الَّذِي عَلَى الْمَذْبَحِ، وَرَشَّهَا عَلَى هَرُونَ وَثِيَابِهِ، وَعَلَى أَبْنَاءِ هَرُونَ وَثِيَابِهِمْ، فَقَدَّسَهُمْ جَمِيعاً مَعَ مَلابِسِهِمْ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ثُمَّ قَالَ لِهَرُونَ وَأَبْنَائِهِ: «اطْبُخُوا اللَّحْمَ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، وَكُلُوهُ هُنَاكَ مَعَ خُبْزِ سَلِّ التَّكْرِيسِ، كَمَا أَوْصَيْتُ أَلّا يَأْكُلَهُ سِوَى هَرُونَ وَأَبْنَائِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","وَمَا تَبَقَّى مِنَ اللَّحْمِ وَالْخُبْزِ تُحْرِقُونَهُ بِنَارٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","وَلا تُفَارِقُوا مَدْخَلَ خَيْمَةِ الاجْتِمَاعِ سَبْعَةَ أَيَّامٍ، إِلَى يَوْمِ اكْتِمَالِ تَكْرِيسِكُمْ، لأَنَّ الرَّبَّ يُكَرِّسُكُمْ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","إِنَّ مَا جَرَى الْيَوْمَ هُوَ مَا أَمَرَ بِهِ الرَّبُّ تَكْفِيراً عَنْكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","فَامْكُثُوا عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ سَبْعَةَ أَيَّامٍ، لَيْلاً وَنَهَاراً، عَامِلِينَ شَعَائِرَ الرَّبِّ، فَلا تَمُوتُوا لأَنَّ هَذَا مَا أَوْصَيْتُ بِهِ». ");
INSERT INTO arbnav_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","فَنَفَّذَ هَروُنُ وَأَبْنَاؤُهُ كُلَّ مَا أَمَرَ بِهِ الرَّبُّ عَلَى لِسَانِ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","وَفِي الْيَوْمِ الثَّامِنِ دَعَا مُوسَى هَرُونَ وَأَبْنَاءَهُ وَقَادَةَ بَنِي إِسْرَائِيلَ، ");
INSERT INTO arbnav_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","وَقَالَ لِهَرُونَ: «أَحْضِرْ ثَوْراً لِذَبِيحَةِ الْخَطِيئَةِ وَكَبْشاً لِمُحْرَقَةٍ، عَلَى أَنْ يَكُونَا سَلِيمَيْنِ، وَقَدِّمْهُمَا فِي حَضْرَةِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","وَقُلْ لِبَنِي إِسْرَائِيلَ: خُذُوا تَيْساً مِنَ الْمَعْزِ لِذَبِيحَةِ الْخَطِيئَةِ، وَثَوْراً وَخَرُوفاً حَوْلِيَّيْنِ سَلِيمَيْنِ لِمُحْرَقَةٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","وَثَوْراً وَكَبْشاً لِقُرْبَانِ سَلامٍ، لِلذَّبْحِ فِي حَضْرَةِ الرَّبِّ، وَتَقْدِمَةً مِنْ دَقِيقٍ مَعْجُونٍ بِالزَّيْتِ، لأَنَّ الرَّبَّ سَيَتَجَلَّى لَكُمُ الْيَوْمَ». ");
INSERT INTO arbnav_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","فَجَاءُوا بِمَا أَمَرَ بِهِ مُوسَى إِلَى أَمَامِ خَيْمَةِ الاجْتِمَاعِ، وَتَقَدَّمَ كُلُّ الشَّعْبِ وَوَقَفُوا فِي حَضْرَةِ الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","فَقَالَ مُوسَى: «هَذَا مَا أَمَرَكُمْ بِهِ الرَّبُّ لِتَعْمَلُوا، لِكَيْ يَتَجَلَّى لَكُمْ مَجْدُ الرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ثُمَّ قَالَ مُوسَى لِهَرُونَ: «اقْتَرِبْ مِنَ الْمَذْبَحِ وَقَدِّمْ ذَبِيحَةَ خَطِيئَتِكَ وَمُحْرَقَتَكَ، وَكَفِّرْ عَنْ نَفْسِكَ وَعَنِ الشَّعْبِ، ثُمَّ أَحْضِرْ قُرْبَانَ الشَّعْبِ وَكَفِّرْ عَنْهُمْ كَمَا أَمَرَ الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","فَاقْتَرَبَ هَرُونُ مِنَ الْمَذْبَحِ، وَقَرَّبَ الثَّوْرَ ذَبِيحَةَ خَطِيئَةٍ عَنْ نَفْسِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","وَقَدَّمَ لَهُ أَبْنَاؤُهُ الدَّمَ فَغَمَسَ إِصْبَعَهُ فِيهِ وَوَضَعَهُ عَلَى قُرُونِ الْمَذْبَحِ، ثُمَّ سَكَبَ بَقِيَّةَ الدَّمِ عِنْدَ قَاعِدَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","وَأَحْرَقَ عَلَى الْمَذْبَحِ شَحْمَ ذَبِيحَةِ الْخَطِيئَةِ وَكُلْيَتَيْهَا وَمَرَارَتَهَا، كَمَا أَمَرَ الرَّبُّ مُوسَى ");
INSERT INTO arbnav_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","أَمَّا اللَّحْمُ وَالْجِلْدُ فَقَدْ أَحْرَقَهُمَا خَارِجَ الْمُخَيَّمِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ثُمَّ ذَبَحَ هَرُونُ كَبْشَ الْمُحْرَقَةِ، وَقَدَّمَ لَهُ أَبْنَاؤُهُ الدَّمَ فَرَشَّهُ عَلَى جَوَانِبِ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ثُمَّ نَاوَلُوهُ أَجْزَاءَ لَحْمِ الْمُحْرَقَةِ، وَرَأْسَهَا فَأَحْرَقَهَا عَلَى الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","وَغَسَلَ الأَمْعَاءَ وَالأَكَارِعَ وَأَحْرَقَهَا فَوْقَ الْمُحْرَقَةِ عَلَى الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ثُمَّ قَدَّمَ قُرْبَانَ الشَّعْبِ. فَأَخَذَ تَيْسَ خَطِيئَةِ الشَّعْبِ، وَذَبَحَهُ وَقَدَّمَهُ قُرْبَانَ خَطِيئَةٍ عَلَى مِثَالِ قُرْبَانِ الْخَطِيئَةِ الأَوَّلِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ثُمَّ أَحْضَرَ الْمُحْرَقَةَ وَأَصْعَدَهَا حَسَبَ الشَّعَائِرِ الْمَنْصُوصَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","وَرَفَعَ أَيْضاً تَقْدِمَةَ الدَّقِيقِ، فَمَلأَ قَبْضَتَهُ مِنْهَا وَأَحْرَقَهَا عَلَى الْمَذْبَحِ، بِالإِضَافَةِ إِلَى التَّقْدِمَةِ الصَّبَاحِيَّةِ الْمُعْتَادَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","وَكَذَلِكَ ذَبَحَ الثَّوْرَ وَالْكَبْشَ، ذَبِيحَةَ سَلامٍ عَنِ الشَّعْبِ وَأَعْطَاهُ أَبْنَاؤُهُ الدَّمَ فَرَشَّهُ عَلَى جَوَانِبِ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","وَانْتَزَعَ شَحْمَ الثَّوْرِ وَأَلْيَةَ الْكَبْشِ وَشَحْمَ الْكُلْيَتَيْنِ وَالْمَرَارَةَ مِنْهُمَا، ");
INSERT INTO arbnav_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","وَوَضَعُوا الشَّحْمَ عَلَى الصَّدْرَيْنِ، ثُمَّ أَحْرَقَ الشَّحْمَ عَلَى الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","وَأَمَّا صَدْرُ كُلٍّ مِنْهُمَا وَسَاقُهُ الْيُمْنَى فَقَدْ رَجَّحَهَا أَمَامَ الرَّبِّ كَمَا أَمَرَ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ثُمَّ رَفَعَ هَرُونُ يَدَيْهِ نَحْوَ الشَّعْبِ وَبَارَكَهُمْ. وَلَمَّا انْتَهَى مِنْ تَقْرِيبِ ذَبِيحَةِ الْخَطِيئَةِ وَالْمُحْرَقَةِ وَذَبِيحَةِ السَّلامِ، انْحَدَرَ مِنْ عِنْدِ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","وَدَخَلَ مُوسَى وَهَرُونُ إِلَى خَيْمَةِ الاجْتِمَاعِ، وَمَا لَبِثَا أَنْ خَرَجَا وَبَارَكَا الشَّعْبَ، فَتَجَلَّى مَجْدُ الرَّبِّ لِلشَّعْبِ كُلِّهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","وَخَرَجَتْ نَارٌ مِنْ عِنْدِ الرَّبِّ أَحْرَقَتْ ذَبِيحَةَ الْمُحْرَقَةِ وَالشَّحْمَ الَّذِي عَلَى الْمَذْبَحِ. وَعِنْدَمَا شَهِدَ الشَّعْبُ هَذَا، هَتَفُوا سَاجِدِينَ بِوُجُوهٍ مُنْحَنِيَةٍ نَحْوَ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ثُمَّ وَضَعَ نَادَابُ وَأَبِيهُو، ابْنَا هَرُونَ، فِي مِجْمَرَتَيْهِمَا نَاراً غَيْرَ مُقَدَّسَةٍ، وَبَخُوراً عَلَى خِلافِ مَا أَمَرَهُمَا الرَّبُّ، وَقَرَّبَا أَمَامَ الرَّبِّ ");
INSERT INTO arbnav_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","فَانْدَلَعَتْ نَارٌ مِنْ عِنْدِ الرَّبِّ فَالْتَهَمَتْهُمَا، فَمَاتَا فِي حَضْرَةِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","فَقَالَ مُوسَى لِهَرُونَ: «إِلَيْكَ مَا قَالَهُ الرَّبُّ: فِي الْقَرِيبِينَ مِنِّي أُظْهِرُ قَدَاسَتِي، وَأُعْلِنُ مَجْدِي أَمَامَ جَمِيعِ الشَّعْبِ». فَصَمَتَ هَرُونُ. ");
INSERT INTO arbnav_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","وَاسْتَدْعَى مُوسَى مِيشَائِيلَ وَأَلْصَافَانَ ابْنَيْ عُزِّيئِيلَ عَمِّ هَروُنَ وَقَالَ لَهُمَا: «تَعَالَيَا وَاحْمِلا جُثَّتَيْ قَرِيبَيْكُمَا مِنْ أَمَامِ الْقُدْسِ إِلَى خَارِجِ الْمُخَيَّمِ». ");
INSERT INTO arbnav_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","فَتَقَدَّمَا وَرَفَعَاهُمَا بِقَمِيصَيْهِمَا إِلَى خَارِجِ الْمُخَيَّمِ، كَمَا أَمَرَ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","وَقَالَ مُوسَى لِهَرُونَ وَأَلِعَازَارَ وَإِيثَامَارَ ابْنَيْهِ: «لا تَكْشِفُوا رُؤُوسَكُمْ وَلا تَشُقُّوا ثِيَابَكُمْ حِدَاداً، لِئَلّا تَمُوتُوا وَيَسْخَطَ الرَّبُّ عَلَى كُلِّ الشَّعْبِ. وَأَمَّا بَقِيَّةُ الشَّعْبِ فَلْيَبْكُوا عَلَى اللَّذَيْنِ أَحْرَقَهُمَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","وَإِيَّاكُمْ أَنْ تَخْرُجُوا مِنْ بَابِ خَيْمَةِ الاجْتِمَاعِ لِئَلّا تَمُوتُوا، لأَنَّ دُهْنَ مَسْحَةِ الرَّبِّ مَازَالَ عَلَيْكُمْ». فَنَفَّذُوا أَمْرَ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","وَأَمَرَ الرَّبُّ هَرُونَ: ");
INSERT INTO arbnav_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«لا تَشْرَبْ أَنْتَ وَأَبْنَاؤُكَ خَمْراً مُسْكِراً عِنْدَ دُخُولِكُمْ لِخِدْمَتِي فِي خَيْمَةِ الاجْتِمَاعِ، لِئَلّا تَمُوتُوا، وَتَكُونُ هَذِهِ عَلَيْكُمْ فَرِيضَةً أَبَدِيَّةً جِيلاً بَعْدَ جِيلٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","لِتُمَيِّزُوا بَيْنَ الْمُقَدَّسِ وَالْمُحَلَّلِ، النَّجِسِ وَالطَّاهِرِ، ");
INSERT INTO arbnav_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","وَلِتُعَلِّمُوا شَعْبَ إِسْرَائِيلَ جَمِيعَ الْفَرَائِضِ الَّتِي أَمَرْتُ بِها عَلَى لِسَانِ مُوسَى». ");
INSERT INTO arbnav_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","وَقَالَ مُوسَى لِهَرُونَ وَابْنَيْهِ الْبَاقِيَيْنِ، أَلِعَازَارَ وَإِيثَامَارَ: «خُذُوا مَا تَبَقَّى مِنْ تَقْدِمَةِ الدَّقِيقِ الْمُقَرَّبَةِ إِلَى الرَّبِّ وَكُلُوهَا فَطِيراً إِلَى جِوَارِ الْمَذْبَحِ، لأَنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","كُلُوهَا فِي مَكَانٍ مُقَدَّسٍ لأَنَّهَا نَصِيبُكَ وَنَصِيبُ ابْنَيْكَ مِنْ مُحْرَقَاتِ الرَّبِّ، لأَنَّنِي هَكَذَا أُمِرْتُ. ");
INSERT INTO arbnav_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","وَأَمَّا الصَّدْرُ الْمُرَجَّحُ وَالسَّاقُ الْيُمْنَى الْمُقَدَّمَةُ، فَكُلْهَا أَنْتَ وَبَنُوكَ وَبَنَاتُكَ فِي مَكَانٍ طَاهِرٍ، لأَنَّهَا نَصِيبُكَ وَنَصِيبُ أَبْنَائِكَ مِنْ ذَبَائِحِ سَلامِ شَعْبِ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","عِنْدَمَا يَأْتِي الشَّعْبُ بِسَاقِ التَّقْدِمَةِ وَصَدْرِ التَّرْجِيحِ وَوَقَائِدِ الشَّحْمِ لِتَرْجِيحِهَا أَمَامَ الرَّبِّ، يُصْبِحَانِ مِنَ نَصِيبِكَ وَنَصِيبِ أَبْنَائِكَ، فَرِيضَةً أَبَدِيَّةً جِيلاً بَعْدَ جِيلٍ». ");
INSERT INTO arbnav_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","وَبَحَثَ مُوسَى عَنْ تَيْسِ الْخَطِيئَةِ فَوَجَدَهُ قَدِ احْتَرَقَ فَاغْتَاظَ مِنْ أَلِعَازَارَ وَإِيثَامَارَ ابْنَيْ هَرُونَ الْبَاقِيَيْنِ وَقَالَ: ");
INSERT INTO arbnav_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«لِمَاذَا لَمْ تَأْكُلا ذَبِيحَةَ الْخَطِيئَةِ فِي الْمَكَانِ الْمُقَدَّسِ؟ إِنَّهَا قُدْسُ أَقْدَاسٍ، وَهَبَهَا الرَّبُّ لَكُمَا لِتَحْمِلا إِثْمَ الْجَمَاعَةِ، تَكْفِيراً عَنْهُمْ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","مَادَامَ دَمُهَا لَمْ يُؤْخَذْ إِلَى دَاخِلِ الْقُدْسِ، كَانَ عَلَيْكُمَا أَنْ تَأْكُلاهَا فِي الْقُدْسِ كَمَا أَوْصَيْتُ». ");
INSERT INTO arbnav_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","فَقَالَ هَرُونُ لِمُوسَى: «لَقَدْ قَرَّبَا الْيَوْمَ ذَبِيحَةَ خَطِيئَتِهِمَا وَمُحْرَقَتَهُمَا فِي حَضْرَةِ الرَّبِّ، فَلَوْ أَكَلْنَا ذَبِيحَةَ الْخَطِيئَةِ فِي مِثْلِ هَذَا الْيَوْمِ، وَقَدْ أَصَابَنَا مَا أَصَابَنَا، فَهَلْ كَانَ الرَّبُّ يَرْضَى عَنَّا؟» ");
INSERT INTO arbnav_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","فَاقْتَنَعَ مُوسَى بِهَذَا الْجَوَابِ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","وَأَمَرَ الرَّبُّ مُوسَى وَهَرُونَ: ");
INSERT INTO arbnav_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«أَوْصِيَا بَنِي إِسْرَائِيلَ: هَذِهِ هِيَ الْحَيَوَانَاتُ الَّتِي تَأْكُلُونَهَا مِنْ جَمِيعِ بَهَائِمِ الأَرْضِ: ");
INSERT INTO arbnav_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","تَأْكُلُونَ كُلَّ حَيَوَانٍ مَشْقُوقِ الظِّلْفِ وَمُجْتَرٍّ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","أَمَّا الْحَيَوَانَاتُ الْمُجْتَرَّةُ فَقَطْ، أَوِ الْمَشْقُوقَةُ الظِّلْفِ فَقَطْ، فَلا تَأْكُلُوا مِنْهَا، فَالْجَمَلُ غَيْرُ طَاهِرٍ لَكُمْ لأَنَّهُ مُجْتَرٌّ وَلَكِنَّهُ غَيْرُ مَشْقُوقِ الظِّلْفِ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","وَكَذَلِكَ الْوَبْرُ نَجِسٌ لَكُمْ لأَنَّهُ مُجْتَرٌّ وَلَكِنَّهُ غَيْرُ مَشْقُوقِ الظِّلْفِ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","أَمَّا الأَرْنَبُ فَإِنَّهُ مُجْتَرٌّ وَلَكِنَّهُ غَيْرُ مَشْقُوقِ الظِّلْفِ، لِذَلِكَ هُوَ نَجِسٌ لَكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","وَالْخِنْزِيرُ أَيْضاً نَجِسٌ لَكُمْ لأَنَّهُ مَشْقُوقُ الظِّلْفِ وَلَكِنَّهُ غَيْرُ مُجْتَرٍّ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","لَا تَأْكُلُوا مِنْ لَحْمِهَا وَلا تَلْمَسُوا جُثَثَهَا لأَنَّهَا نَجِسَةٌ لَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","أَمَّا مَا يَعِيشُ فِي الْمَاءِ فَتَأْكُلُونَ مِنْهُ كُلَّ مَالَهُ زَعَانِفُ وَقُشُورٌ، سَوَاءٌ كَانَ يَعِيشُ فِي الْبِحَارِ أَمِ الأَنْهَارِ، فَهَذِهِ تَأْكُلُونَهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","وَلَكِنْ إِيَّاكُمْ أَنْ تَأْكُلُوا الْحَيَوَانَاتِ الْمَائِيَّةَ الَّتِي لَيْسَ لَهَا زَعَانِفُ أَوْ قُشُورٌ، سَوَاءٌ كَانَتْ تَعِيشُ فِي الأَنْهَارِ أَوِ الْبِحَارِ، أَوِ الزَّوَاحِفَ فِي الْمِيَاهِ، أَوْ كُلَّ نَفْسٍ حَيَّةٍ فِيهَا، فَهَذِهِ كُلُّهَا مَحْظُورَةٌ عَلَيْكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","فَلا تَأْكُلُوا مِنْ لَحْمِهَا وَامْقُتُوا جُثَثَهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","كُلُّ حَيَوَانٍ مَائِيٍّ خَالٍ مِنَ الزَّعَانِفِ وَالْقُشُورِ يَكُونُ مَحْظُوراً عَلَيْكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","وَمِنَ الطُّيُورِ الَّتِي يُحَظَرُ عَلَيْكُمْ أَكْلُهَا لأَنَّهَا مَمْقُوتَةٌ: النَّسْرُ وَالأَنُوقُ وِالصَّقْرُ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","وَالْحِدَأَةُ وَالْبَاشِقُ عَلَى مُخْتَلَفِ أَصْنَافِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","وَكُلُّ أَجْنَاسِ الْغِرْبَانِ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","وَالنَّعَامَةُ وَالظَّلِيمُ وَالسَّأَفُ وَكُلُّ أَنْوَاعِ طَيْرِ الْبَازِ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","وَالْبُومَةُ وَالْغَوَّاصُ وَالْكُرْكِيُّ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","وَالْبَجَعُ وَالْقُوقُ وَالرَّخَمُ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","وَاللَّقْلَقُ وَالْبَبْغَاءُ عَلَى اخْتِلافِ أَجْنَاسِهَا، وَالْهُدْهُدُ وَالْخُفَّاشُ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","وَكَذَلِكَ تُحَظَرُ عَلَيْكُمْ كُلُّ حَشَرَةٍ مُجَنَّحَةٍ ذَاتِ أَرْبَعِ أَرْجُلٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","وَلَكِنْ كُلُوا مِنْ بَيْنِ الْكَائِنَاتِ الْمُجَنَّحَةِ الَّتِي تَمْشِي عَلَى أَرْبَعٍ مَالَهُ سَاقَانِ أَطْوَلُ مِنْ يَدَيْهِ يَقْفِزُ بِهِمَا عَلَى الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","فَمِنْ هَذِهِ الْكَائِنَاتِ تَأْكُلُونَ: كُلُّ أَنْوَاعِ الْجَرَادِ، وَجَمِيعُ أَصْنَافِ الدَّبَا وَالحَرْجُوَانُ عَلَى مُخْتَلَفِ أَجْنَاسِهِ وَالْجُنْدُبُ بِأَنْوَاعِهِ ");
INSERT INTO arbnav_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","أَمَّا سَائِرُ دَبِيبِ الطَّيْرِ ذَوَاتِ الأَرْبَعِ الأَرْجُلِ فَهُوَ مَحْظُورٌ عَلَيْكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","فَإِنَّهَا تُنَجِّسُكُمْ، وَكُلُّ مَنْ يَلْمِسُ جُثَثَهَا يَتَنَجَّسُ حَتَّى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","وَعَلَى كُلِّ مَنْ حَمَلَ جُثَثَهَا أَنْ يَغْسِلَ ثِيَابَهُ وَيَكُونُ نَجِساً حَتَّى الْمَسَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","وَكَذَلِكَ جَمِيعُ الْبَهَائِمِ ذَوَاتِ الأَظْلافِ غَيْرِ الْمَشْقُوقَةِ وَغَيْرِ الْمُجْتَرَّةِ تَكُونُ نَجِسَةً لَكُمْ، وَكُلُّ مَنْ يَلْمِسُهَا يَتَنَجَّسُ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","وَأَيْضاً كُلُّ حَيَوَانٍ يَمْشِي عَلَى كُفُوفِهِ مِنْ جَمِيعِ الْحَيَوَانَاتِ ذَوَاتِ الأَرْبَعِ الأَرْجُلِ، فَهُوَ نَجِسٌ لَكُمْ، وَكُلُّ مَنْ يَمَسُّ جُثَثَهَا يَكُونُ نَجِساً حَتَّى الْمَسَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","وَمَنْ يَحْمِلُ جُثَثَهَا يَغْسِلُ ثِيَابَهُ وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ. جَمِيعُهَا مَحْظُورَةٌ عَلَيْكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","أَمَّا الْحَيَوَانَاتُ الدَّابَةُ حَوْلَكُمْ فَوْقَ الأَرْضِ وَالْمَحْظُورَةُ عَلَيْكُمْ لِنَجَاسَتِهَا فَهِيَ: ابْنُ عِرْسٍ وَالْفَأْرُ وَالضَّبُّ عَلَى مُخْتَلَفِ أَجْنَاسِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","وَالْحِرْذَوْنُ وَالْوَرَلُ وَالْوَزَغَةُ والْعِظَايَةُ وَالْحِرْبَاءُ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","هَذِهِ هِيَ الْحَيَوَانَاتُ النَّجِسَةُ لَكُمْ مِنْ جَمِيعِ الْحَيَوَانَاتِ الدَّابَةِ. كُلُّ مَنْ لَمَسَهَا يَكُونُ نَجِساً حَتَّى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","إِنْ وَقَعَتْ جُثَّةُ أَحَدِ هَذِهِ الْحَيَوَانَاتِ عَلَى شَيْءٍ فَإِنَّهُ يَتَنَجَّسُ، سَوَاءٌ أَكَانَ آنِيَةً مِنْ خَشَبٍ أَمْ قُمَاشٍ أَمْ جِلْدٍ أَمْ مِسْحٍ، أَمْ أَيِّ شَيْءٍ يُسْتَخْدَمُ فِي عَمَلٍ مَا. يُوْضَعُ فِي مَاءٍ وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ، ثُمَّ يَطْهُرُ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","أَمَّا إِنْ وَقَعَتْ جُثَّةُ أَحَدِهَا فِي إِنَاءٍ خَزَفِيٍّ، فَإِنَّ مَا فِي الإِنَاءِ يَتَنَجَّسُ، وَأَمَّا الإِنَاءُ فَيُكْسَرُ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","وَأَيُّ طَعَامٍ يُؤْكَلُ اسْتُخْدِمَ فِيهِ مَاءٌ مِنْ هَذَا الإِنَاءِ يَكُونُ نَجِساً. وَكَذَلِكَ يَكُونُ مَاؤُهُ الَّذِي يُشْرَبُ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","وَإذَا سَقَطَتْ جُثَّةُ أَحَدِ هَذِهِ الْحَيَوَانَاتِ فِي التَّنُّورِ أَوِ الْمَوْقِدِ، فَإِنَّهُ يُهْدَمُ، لأَنَّهُ نَجِسٌ وَأَنْتُمْ بِهِ تَتَنَجَّسُونَ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","أَمَّا إِنْ سَقَطَتْ فِي نَبْعٍ أَوْ بِئْرٍ حَيْثُ يَجْتَمِعُ الْمَاءُ، فَإِنَّهُمَا تَظَلّانِ طَاهِرَتَيْنِ. لَكِنْ كُلُّ مَنْ لَمَسَ جُثَّتَهَا يَكُونُ نَجِساً. ");
INSERT INTO arbnav_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","وَإذَا وَقَعَتْ جُثَّةُ وَاحِدَةٍ مِنْهَا عَلَى حُبُوبٍ يَبْذُرُونَهَا فِي حَقْلٍ، فَإِنَّهَا تَبْقَى طَاهِرَةً. ");
INSERT INTO arbnav_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","لَكِنْ إِنْ كَانَتِ الْحُبُوبُ مُبْتَلَّةً بِمَاءٍ وَسَقَطَتِ الْجُثَّةُ عَلَيْهَا، فَإِنَّ الْحُبُوبَ الْمُبْتَلَّةَ تُصْبِحُ نَجِسَةً لَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","إِنْ مَاتَ حَيَوَانٌ لَا يَحِلُّ لَكُمْ أَكْلُهُ، وَلَمَسَ أَحَدٌ جُثَّتَهُ، فَاللّامِسُ يَكُونُ نَجِساً حَتَّى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","وَعَلَى مَنْ أَكَلَ مِنْ جُثَّتِهِ أَوْ حَمَلَهَا أَنْ يَغْسِلَ ثِيَابَهُ وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","ويُحَظَرُ عَلَيْكُمُ الأَكْلُ مِنَ الْحَيَوَانَاتِ الزَّاحِفَةِ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","سَوَاءٌ كَانَتْ تَزْحَفُ عَلَى بَطْنِهَا أَوْ تَدِبُّ عَلَى أَرْبَعٍ أَوْ أَكْثَرَ فَإِنَّهَا مَحْظُورَةٌ عَلَيْكُمْ، فَلا تَأْكُلُوا مِنْهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","لَا تُدَنِّسُوا أَنْفُسَكُمْ بِالْحَيَوَانَاتِ الدَّابَةِ هَذِهِ، وَلا تَتَنَجَّسُوا بِها. كُونُوا طَاهِرِينَ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","أَنَا الرَّبُّ إِلَهُكُمْ، فَكَرِّسُوا أَنْفُسَكُمْ وَتَقَدَّسُوا، لأَنِّي أَنَا قُدُّوسٌ، وَلا تُنَجِّسُوا أَنْفُسَكُمْ بِشَيْءٍ مِنَ الدَّبِيبِ الْمُتَحَرِّكِ عَلَى الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","لأَنِّي أَنَا الرَّبُّ الَّذِي أَخْرَجَكُمْ مِنْ دِيَارِ مِصْرَ لأَكُونَ لَكُمْ إِلَهاً. فَكُونُوا قِدِّيسِينَ لأَنِّي أَنَا قُدُّوسٌ. ");
INSERT INTO arbnav_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","هَذِهِ هِيَ الشَّرَائِعُ الْخَاصَّةُ بِالْحَيَوَانَاتِ وَالطُّيُورِ وَالْحَيَوَانَاتِ الْمَائِيَّةِ وَالزَّوَاحِفِ، ");
INSERT INTO arbnav_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","لِكَيْ تُمَيِّزُوا بَيْنَ النَّجِسِ وَالطَّاهِرِ، وَبَيْنَ الْحَيَوَانَاتِ الَّتِي تُؤْكَلُ وَالْحَيَوَانَاتِ الْمَحْظُورِ أَكْلُهَا». ");
INSERT INTO arbnav_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ: إِذَا حَمَلَتِ امْرَأَةٌ وَوَلَدَتْ ذَكَراً، تَظَلُّ الأُمُّ فِي حَالَةِ نَجَاسَةٍ سَبْعَةَ أَيَّامٍ، كَمَا فِي أَيَّامِ فَتْرَةِ الْحَيْضِ. ");
INSERT INTO arbnav_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","وَفِي الْيَوْمِ الثَّامِنِ يُجْرَى خِتَانُ الطِّفْلِ. ");
INSERT INTO arbnav_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","وَعَلَى الْمَرْأَةِ أَنْ تَبْقَى ثَلاثَةً وَثَلاثِينَ يَوْماً أُخْرَى إِلَى أَنْ تَطْهُرَ مِنْ نَزِيفِهَا، فَلا تَمَسُّ أَيَّ شَيْءٍ مُقَدَّسٍ، وَلا تَحْضُرُ إِلَى الْمَقْدِسِ، إِلَى أَنْ تَتِمَّ أَيَّامُ تَطْهِيرِهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","وَإِنْ وَلَدَتْ أُنْثَى فَإِنَّهَا تَظَلُّ فِي حَالَةِ نَجَاسَةٍ مُدَّةَ أُسْبُوعَيْنِ كَمَا فِي فَتْرَةِ الْحَيْضِ، وَتَبْقَى سِتَّةً وَسِتِّينَ يَوْماً حَتَّى تَتَطَهَّرَ مِنْ نَزِيفِهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","وَعِنْدَمَا تَكْتَمِلُ أَيَّامُ تَطْهِيرِهَا سَوَاءٌ وَلَدَتْ ذَكَراً أَمْ أُنْثَى، تُحْضِرُ حَمَلاً حَوْلِيًّا تُقَدِّمُهُ مُحْرَقَةً، وَكَذَلِكَ فَرْخَ حَمَامَةٍ أَوْ يَمَامَةٍ ذَبِيحَةَ خَطِيئَةٍ، إِلَى مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ إِلَى الْكَاهِنِ، ");
INSERT INTO arbnav_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","فَيُقَرِّبُهَا أَمَامَ الرَّبِّ وَيُكَفِّرُ عَنْهَا، فَتَتَطَهَّرُ مِنْ نَزِيفِهَا. هَذِهِ هِيَ الشَّرِيعَةُ الْخَاصَّةُ بِكُلِّ أُمٍّ بَعْدَ الْوِلادَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","وَإِنْ كَانَتِ الأُمُّ أَفْقَرَ مِن أَنْ تُقَدِّمَ حَمَلاً، فَلْتَأْتِ بِيَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ، فَيَكُونَ أَحَدُهُمَا مُحْرَقَةً وَالآخَرُ ذَبِيحَةَ خَطِيئَةٍ، فَيُكَفِّرُ بِهِمَا عَنْهَا الْكَاهِنُ وَتَطْهُرُ». ");
INSERT INTO arbnav_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","وَقَالَ الرَّبُّ لِمُوسَى وَهَرُونَ: ");
INSERT INTO arbnav_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«إِذَا أُصِيبَ جِلْدُ إِنْسَانٍ بِوَرَمٍ أَوْ قُوبَاءَ أَوْ لُمْعَةٍ، يُمْكِنُ أَنْ تَتَحَوَّلَ فِي جِلْدِهِ إِلَى دَاءِ الْبَرَصِ، فَلْيُؤْخَذْ إِلَى هَرُونَ أَوْ إِلَى أَحَدِ أَبْنَائِهِ الْكَهَنَةِ لِيُعَايِنَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","فَإِنْ وَجَدَ الْكَاهِنُ أَنَّ الشَّعْرَ فِي مَوْضِعِ الدَّاءِ قَدِ ابْيَضَّ، وَأَنَّ مَكْمَنَ الدَّاءِ غَائِرٌ عَنْ سَطْحِ الْجِلْدِ الْمُحِيطِ بِهِ، فَالدَّاءُ يَكُونُ ضَرْبَةَ الْبَرَصِ. فَيُعْلِنُ الْكَاهِنُ أَنَّهُ مُصَابٌ بِمَرَضِ الْبَرَصِ النَّجِسِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","وَإِنْ لَمْ تَكُنِ الْبُقْعَةُ الْبَيْضَاءُ غَائِرَةً عَنْ سَطْحِ الْجِلْدِ، وَلَمْ يَكُنِ الشَّعْرُ الْمَوْجُودُ فِيهَا قَدِ ابْيَضَّ، يَحْجُزُ الْكَاهِنُ الْمَرِيضَ سَبْعَةَ أَيَّامٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ثُمَّ يَفْحَصُهُ بَعْدَ ذَلِكَ، فَإِنْ وَجَدَ أَنَّ الْبُقْعَةَ لَمْ تَتَّسِعْ وَتَمْتَدَّ، يَحْجُزُهُ الْكَاهِنُ سَبْعَةَ أَيَّامٍ أُخْرَى، ");
INSERT INTO arbnav_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","وَيُعَايِنُهُ فِي الْيَوْمِ السَّابِعِ ثَانِيَةً. فَإِذَا وَجَدَ أَنَّ الضَّرْبَةَ دَاكِنَةُ اللَّوْنِ وَالْبُقْعَةَ لَمْ تَتَّسِعْ وَتَمْتَدَّ، يَحْكُمُ بِسَلامَتِهِ. إِنَّهَا قُوبَاءُ. وَعَلَيْهِ فَقَطْ أَنْ يَغْسِلَ ثِيَابَهُ فَيُعْتَبَرَ طَاهِراً. ");
INSERT INTO arbnav_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","لَكِنْ إِنِ امْتَدَّتِ الْبُقْعَةُ فِي الْجِلْدِ بَعْدَ مُعَايَنَةِ الْكَاهِنِ لَهُ لِتَطْهِيرِهِ، يُعْرَضُ عَلَى الْكَاهِنِ مَرَّةً أُخْرَى، ");
INSERT INTO arbnav_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","فَإِنْ وَجَدَ الْكَاهِنُ بَعْدَ فَحْصِهِ أَنَّ الْبُقْعَةَ قَدِ امْتَدَّتْ وَاتَّسَعَتْ، يُعْلِنُ الْكَاهِنُ نَجَاسَتَهُ لإِصَابَتِهِ بِمَرَضِ الْبَرَصِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","إِذَا كَانَ إِنْسَانٌ مُصَاباً بِدَاءِ الْبَرَصِ تَعْرِضُونَهُ عَلَى الْكَاهِنِ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","فَإِنْ وَجَدَ الْكَاهِنُ بَعْدَ فَحْصِهِ أَنَّ فِي الْجِلْدِ وَرَماً أَبْيَضَ، ابْيَضَّ فِيهِ الشَّعْرُ وَبَدَتْ فِيهِ قُرْحَةٌ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","فَيَكُونُ هَذَا مَرَضَ بَرَصٍ مُزْمِنٍ أَصَابَ جِلْدَهُ. وَيُعْلِنُ الْكَاهِنُ لِذَلِكَ نَجَاسَتَهُ، وَلا يَحْجُزُهُ لِثُبُوتِ الدَّاءِ فِيهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","لَكِنْ إِنْ كَانَ الْبَرَصُ قَدِ انْتَشَرَ فِي جِلْدِ الْبَدَنِ كُلِّهِ، وَغَطَّى الْمُصَابَ مِنْ رَأْسِهِ إِلَى قَدَمَيْهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","يُعِيدُ الْكَاهِنُ فَحْصَهُ. فَإِذَا وَجَدَ أَنَّ الْبَرَصَ غَطَّى الْجِسْمَ كُلَّهُ يُعْلِنُ طَهَارَتَهُ، لأَنَّ جِلْدَهُ كُلَّهُ قَدِ اسْتَحَالَ إِلَى اللَّوْنِ الأَبْيَضِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","لَكِنْ حِينَ يَرَى فِيهِ قُرْحَةً، يَحْكُمُ بِنَجَاسَةِ الْمَرِيضِ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ثُمَّ يُعِيدُ فَحْصَهُ. فَإِذَا وَجَدَ الْقُرْحَةَ فِي الْجِلْدِ الْمُصَابِ، يُعْلِنُ نَجَاسَةَ الْمَرِيضِ، لأَنَّ الْقُرْحَةَ نَجِسَةٌ، وَهِيَ عَلامَةُ الْبَرَصِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ثُمَّ إِنْ عَادَ لَوْنُ الْقُرْحَةِ وَابْيَضَّ يَعْرِضُ نَفْسَهُ عَلَى الْكَاهِنِ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","فَإِنْ فَحَصَهَا الكَاهِنُ وَوَجَدَ أَنَّ الْبُقْعَةَ قَدْ تَحَوَّلَتْ إِلَى بَيْضَاءَ، يُعْلِنُ طَهَارَةَ الْمُصَابِ. إِنَّهُ طَاهِرٌ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","إِنْ كَانَ فِي جِلْدِ إِنْسَانٍ دُمَّلٌ تَمَّ شِفَاؤُهُ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ثُمَّ تَخَلَّفَ عَنْهُ وَرَمٌ أَبْيَضُ أَوْ بُقْعَةٌ لامِعَةٌ بَيْضَاءُ ضَارِبَةٌ إِلَى الْحُمْرَةِ، فَلْيُعْرَضْ عَلَى الْكَاهِنِ ");
INSERT INTO arbnav_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","فَإِنْ وَجَدَ الْكَاهِنُ أَنَّ مَوْضِعَ الدَّاءِ غَائِرٌ عَنْ سَطْحِ بَاقِي الْجِلْدِ، وَقَدِ ابْيَضَّ الشَّعْرُ فِيهِ، يُعْلِنُ نَجَاسَتَهُ، لأَنَّهُ دَاءُ بَرَصٍ أَفْرَخَ فِي الدُّمَّلِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","وَلَكِنْ إِنْ عَايَنَهُ الْكَاهِنُ فَوَجَدَ أَنَّ مَوْضِعَ الدَّاءِ خَالٍ مِنَ الشَّعْرِ الْأَبْيَضِ، وَأَنَّهُ يَسْتَوِي مَعَ سَطْحِ بَاقِي الْجِلْدِ، وَأَنَّ لَوْنَهُ دَاكِنٌ، يَحْجُزُ الْمُصَابُ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","فَإِنِ امْتَدَّ وَاتَّسَعَ فِي الْجِلْدِ يَحْكُمُ الْكَاهِنُ بِنَجَاسَتِهِ، لأَنَّهُ مُصَابٌ بِالدَّاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","وَلَكِنْ إِنْ بَقِيَتِ الْبُقْعَةُ اللّامِعَةُ كَمَا هِيَ، وَلَمْ تَتَّسِعْ وَتَمْتَدَّ، تَكُونُ مُجَرَّدَ أَثَرٍ لِلدُّمَّلِ، فَيُعْلِنُ طَهَارَةَ الْمُصَابِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","إِنِ احْتَرَقَ جِلْدُ إِنْسَانٍ فَابْيَضَّ مَوْضِعُ الْحَرْقِ، أَوْ صَارَ أَبْيَضَ ضَارِباً إِلَى الْحُمْرَةِ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","وَفَحَصَ الْكَاهِنُ الْبُقْعَةَ اللّامِعَةَ فَوَجَدَ أَنَّ شَعْرَهَا قَدِ ابْيَضَّ، وَبَدَتْ غَائِرَةً عَنْ سَطْحِ بَاقِي الْجِلْدِ، يَكُونُ ذَلِكَ بَرَصاً أَفْرَخَ فِي مَوْضِعِ الْحَرْقِ، فَيَحْكُمُ بِنَجَاسَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","وَلَكِنْ إِنْ فَحَصَهَا الْكَاهِنُ وَلَمْ يَجِدْ فِي الْبُقْعَةِ شَعْراً أَبْيَضَ، وَأَنَّهَا تَسْتَوِي مَعَ سَطْحِ بَاقِي الْجِلْدِ، وَأَنَّ لَوْنَهَا دَاكِنٌ يَحْجُزُهُ أُسْبُوعاً، ");
INSERT INTO arbnav_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ثُمَّ يُعِيدُ فَحْصَهُ فِي الْيَوْمِ السَّابِعِ. فَإِنْ وَجَدَ أَنَّهَا امْتَدَّتْ فِي الْجِلْدِ، يُعْلِنُ نَجَاسَتَهُ لأَنَّهُ مُصَابٌ بِالْبَرَصِ ");
INSERT INTO arbnav_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","لَكِنْ إِنْ بَقِيَتِ الْبُقْعَةُ اللّامِعَةُ عَلَى حَالِهَا وَلَمْ تَمْتَدَّ فِي الْجِلْدِ، وَاكْمَدَّ لَوْنُهَا، فَهِيَ مُجَرَّدُ أَثَرِ الْحَرْقِ وَلَيْسَتْ بَرَصاً، وَيُعْلِنُ الْكَاهِنُ طَهَارَةَ الْمُصَابِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","إِذَا أُصِيبَ رَجُلٌ أَوِ امْرَأَةٌ بِقُرْحَةٍ فِي الرَّأْسِ أَوْ فِي الذَّقَنِ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","وَعَايَنَ الْكَاهِنُ الإِصَابَةَ فَوَجَدَهَا غَائِرَةً عَنْ سَطْحِ بَاقِي الْجِلْدِ، وَفِيهَا شَعْرٌ أَشْقَرُ دَقِيقٌ، يَحْكُمُ بِنَجَاسَةِ الْمُصَابِ لأَنَّهَا قَرَعٌ، بَرَصُ الرَّأْسِ أَوْ الذَّقَنِ ");
INSERT INTO arbnav_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","لَكِنْ إذَا وَجَدَ الْكَاهِنُ بَعْدَ فَحْصِهِ إِصَابَةَ الْقَرَعِ أَنَّهَا لَيْسَتْ غَائِرَةً عَنْ سَطْحِ بَاقِي الْجِلْدِ، وَأَنَّهَا خَالِيَةٌ مِنَ الشَّعْرِ الأَسْوَدِ، يَحْجُزُ الْكَاهِنُ الْمُصَابَ بِالْقَرَعِ سَبْعَةَ أَيَّامٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ثُمَّ يُعِيدُ الْفَحْصَ فِي الْيَوْمِ السَّابِعِ. فَإِنْ وَجَدَ أَنَّهَا لَمْ تَمْتَدَّ وَأَنَّهَا خَالِيَةٌ مِنَ الشَّعْرِ الأَشْقَرِ وَأَنَّهَا تَسْتَوِي مَعَ سَطْحِ بَاقِي الْجِلْدِ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","يَحْلِقُ الْمُصَابُ شَعْرَهُ بِاسْتِثْنَاءِ شَعْرِ الْبُقْعَةِ الْمُصَابَةِ. وَيَحْجُزُهُ الْكَاهِنُ سَبْعَةَ أَيَّامٍ أُخْرَى ");
INSERT INTO arbnav_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","فَإِنْ وَجَدَ الْكَاهِنُ فِي الْيَوْمِ السَّابِعِ أَنَّ الإِصَابَةَ لَمْ تَمْتَدَّ فِي جِلْدِ الْمَرِيضِ، وَأَنَّهَا تَسْتَوِي مَعَ سَطْحِ بَاقِي الْجِلْدِ، يَحْكُمُ بِطَهَارَتِهِ. وَعَلَيْهِ فَقَطْ أَنْ يَغْسِلَ ثِيَابَهُ فَيَكُونُ طَاهِراً. ");
INSERT INTO arbnav_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","لَكِنْ إِنِ امْتَدَّ الْقَرَعُ فِي الْجِلْدِ بَعْدَ عَرْضِهِ عَلَى الْكَاهِنِ وَالْحُكْمِ بِطَهَارَتِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","يَفْحَصُهُ الكَاهِنُ ثَانِيَةً. فَإِنْ رَأَى أَنَّ الإِصَابَةَ قَدِ امْتَدَّتْ فِي الْجِلْدِ، لَا يَحْتَاجُ الْكَاهِنُ أَنْ يَبْحَثَ عَنْ شَعْرٍ أَشْقَرَ، لأَنَّ الْمُصَابَ مَرِيضٌ بِدَاءِ الْبَرَصِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","لَكِنْ إِنْ وَجَدَ الْكَاهِنُ أَنَّ الإِصَابَةَ تَوَقَّفَتْ وَلَمْ تَمْتَدَّ، وَقَدْ نَبَتَ فِيهَا شَعْرٌ أَسْوَدُ، فَتِلْكَ عَلامَةُ شِفَائِهِ. وَيَحْكُمُ بِطَهَارَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","وَإِنْ ظَهَرَتْ فِي جِلْدِ رَجُلٍ أَوِ امْرَأَةٍ بُقَعٌ لامِعَةٌ بَيْضَاءُ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","وَفَحَصَهَا الْكَاهِنُ، وَإذَا بِها كَامِدَةُ اللَّوْنِ بَيْضَاءُ، يَكُونُ ذَلِكَ بَهَقٌ قَدِ انْتَشَرَ فِي الْجِلْدِ، وَالْمُصَابُ يَكُونُ طَاهِراً. ");
INSERT INTO arbnav_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","وَإذَا سَقَطَ شَعْرُ إِنْسَانٍ فَهُوَ أَقْرَعُ، وَيَكُونُ طَاهِراً. ");
INSERT INTO arbnav_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","وَإِنْ سَقَطَ الشَّعْرُ مِنْ مُقَدَّمَةِ رَأْسِهِ فَهُوَ أَصْلَعُ، وَيَكُونُ طَاهِراً. ");
INSERT INTO arbnav_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","وَلَكِنْ إِنْ ظَهَرَ فِي الْقَرَعَةِ أَوِ الصُّلْعَةِ قُرْحَةٌ بَيْضَاءُ ضَارِبَةٌ إِلَى الْحُمْرَةِ، يَكُونُ هَذَا بَرَصٌ قَدْ أَفْرَخَ فِي قَرْعَتِهِ أَوْ صُلْعَتِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","فَيَفْحَصُهُ الْكَاهِنُ. فَإِذَا وَجَدَ أَنَّ الْوَرَمَ فِي قَرْعَتِهِ أَوْ صُلْعَتِهِ أَبْيَضُ ضَارِبٌ إِلَى الْحُمْرَةِ، مُمَاثِلٌ لِلْبَرَصِ فِي جِلْدِ الْبَدَنِ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","يَكُونُ آنَئِذٍ أَبْرَصَ نَجِساً مُصَاباً بِرَأْسِهِ، وَيَحْكُمُ الْكَاهِنُ بِنَجَاسَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","وَعَلَى الْمُصَابِ بِدَاءِ الْبَرَصِ أَنْ يَشُقَّ ثِيَابَهُ وَيَكْشِفَ رَأْسَهُ وَيُغَطِّيَ شَارِبَيْهِ، وَيُنَادِيَ: ’نَجِسٌ! نَجِسٌ!‘. ");
INSERT INTO arbnav_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","وَيَظَلُّ طُولَ فَتْرَةِ مَرَضِهِ نَجِساً يُقِيمُ وَحْدَهُ خَارِجَ الْمُخَيَّمِ مَعْزُولاً. ");
INSERT INTO arbnav_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","وَإذَا بَدَا دَاءُ الْبَرَصِ الْمُعْدِي، فِي ثَوْبِ صُوفٍ أَوْ كَتَّانٍ ");
INSERT INTO arbnav_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","أَوْ فِي قِطْعَةِ قُمَاشٍ مَنْسُوجَةٍ أَوْ مَحِيكَةٍ مِنْ صُوفٍ أَوْ كَتَّانٍ، أَوْ فِي جِلْدٍ، أَوْ فِي كُلِّ مَصْنُوعٍ مِنْ جِلْدٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","وَكَانَتْ إِصَابَةُ الثَّوْبِ أَوِ الْجِلْدِ أَوْ قِطْعَةِ الْقُمَاشِ الْمَنْسُوجَةِ أَوِ الْمَحِيكَةِ، أَوْ فِي شَيْءٍ مَصْنُوعٍ مِنْ جِلْدٍ، ضَارِبَةً إِلَى الْحُمْرَةِ أَوِ الْخُضْرَةِ، فَإِنَّهَا إِصَابَةُ بَرَصٍ تُعْرَضُ عَلَى الْكَاهِنِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","فَيَفْحَصُ الإِصَابَةَ وَيَحْجُزُ الشَّيْءَ الْمُصَابَ سَبْعَةَ أَيَّامٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ثُمَّ يَفْحَصُهَا فِي الْيَوْمِ السَّابِعِ. فَإِنْ وَجَدَهَا قَدِ امْتَدَّتْ فِي الثَّوْبِ أَوْ قِطْعَةِ الْقُمَاشِ، أَوْ فِي الْجِلْدِ أَوْ فِي كُلِّ مَا يُصْنَعُ مِنْ جِلْدٍ، وَيُسْتَخْدَمُ فِي عَمَلٍ مَا، فَإِنَّ الإِصَابَةَ تَكُونُ بَرَصاً مُعْدِياً وَتَكُونُ نَجِسَةً. ");
INSERT INTO arbnav_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","فَيُحْرِقُ الْكَاهِنُ بِالنَّارِ الثَّوْبَ أَوْ قِطْعَةَ قُمَاشِ الصُّوفِ أَوِ الْكَتَّانِ أَوْ مَتَاعَ الْجِلْدِ الْمُصَابِ، لأَنَّهُ دَاءٌ مُعْدٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","لَكِنْ إِنْ وَجَدَ الْكَاهِنُ أَنَّ الإِصَابَةَ لَمْ تَمْتَدَّ فِي الثَّوْبِ أَوْ فِي قِطْعَةِ الْقُمَاشِ الْمَنْسُوجَةِ أَوِ الْمَحِيكَةِ أَوْ فِي مَتَاعِ الْجِلْدِ، ");
INSERT INTO arbnav_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","يَأْمُرُ بِغَسْلِ الشَّيْءِ وَيَحْجُزُهُ سَبْعَةَ أَيَّامٍ أُخْرَى. ");
INSERT INTO arbnav_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","فَإِنْ رَأَى الْكَاهِنُ أَنَّ لَوْنَ الْبُقْعَةِ فِي الشَّيْءِ الْمُصَابِ لَمْ يَتَغَيَّرْ، وَلا اتَّسَعَتِ الْبُقْعَةُ فِيهِ، يَأْمُرُ بِحَرْقِهِ فَهُوَ نَجِسٌ لأَنَّهُ انْتَشَرَ فِي ظَاهِرِ الْمَتَاعِ وَفِي بَاطِنِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","وَلَكِنْ إِنْ وَجَدَ الْكَاهِنُ، بَعْدَ فَحْصِ الشَّيْءِ الْمُصَابِ، أَنَّ الْبُقْعَةَ قَدْ كَمِدَ لَوْنُهَا بَعْدَ غَسْلِهَا، فَلْيَنْتَزِعْهَا مِنَ الثَّوْبِ أَوِ الْجِلْدِ أَوْ قِطْعَةِ الْقُمَاشِ الْمَنْسُوجَةِ أَوِ الْمَحِيكَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ثُمَّ إِنْ عَادَتِ الْبُقْعَةُ فَظَهَرَتْ ثَانِيَةً فِي الثَّوْبِ أَوْ فِي الْقُمَاشِ الْمَنْسُوجِ أَوِ الْمَحِيكِ أَوْ مَتَاعِ الْجِلْدِ، تَكُونُ الْإِصَابَةُ مُعْدِيَةً. وَيَجِبُ إِحْرَاقُ الشَّيْءِ المُصَابِ بِالنَّارِ. ");
INSERT INTO arbnav_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","وَأَمَّا الثَّوْبُ أَوْ بِطَانَتُهُ الْمَنْسُوجَةُ أَوِ الْمَحِيكَةُ، أَوْ مَتَاعُ الْجِلْدِ الَّذِي يَتِمُّ غَسْلُهُ وَتَزُولُ مِنْهُ الْبُقْعَةُ، فَيُغْسَلُ ثَانِيَةً وَيَطْهُرُ.» ");
INSERT INTO arbnav_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","هَذِهِ هِيَ نُصُوصُ التَّعْلِيمَاتِ الْمُتَعَلِّقَةِ بِإِصَابَةِ الْبَرَصِ فِي الصُّوفِ أَوِ الْكَتَّانِ فِي الْبِطَانَةِ الْمَنْسُوجَةِ أَوِ الْمَحِيكَةِ، أَوْ فِي كُلِّ مَتَاعٍ جِلْدِيٍّ، وَبِمُقْتَضَاهَا تَحْكُمُونَ عَلَى طَهَارَتِهَا أَوْ نَجَاسَتِهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«هَذِهِ هِيَ نُصُوصُ التَّعْلِيمَاتِ الْمُتَعَلِّقَةِ بِالأَبْرَصِ الْمُطَهَّرِ مِنْ بَرَصِهِ. يُحْضِرُونَهُ إِلَى الْكَاهِنِ فِي يَوْمِ شِفَائِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","فَيَخْرُجُ الْكَاهِنُ إِلَى خَارِجِ الْمُخَيَّمِ لِيَفْحَصَهُ فَإِنْ وَجَدَ أَنَّهُ قَدْ بَرِئَ مِنْ دَاءِ الْبَرَصِ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","يَأْمُرُ الْكَاهِنُ أَنْ يُؤْتَى لِلأَبْرَصِ الْمُبَرَّءِ بِعُصْفُورَيْنِ حَيَّيْنِ طَاهِرَيْنِ، وَخَشَبِ أَرْزٍ، وَخَيْطٍ أَحْمَرَ وَبَاقَةِ زُوفَا. ");
INSERT INTO arbnav_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","فَيَأْمُرُ الْكَاهِنُ بَذَبْحِ عُصْفُورٍ وَاحِدٍ فِي إِنَاءٍ خَزَفِيٍّ فَوْقَ مَاءٍ جَارٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","أَمَّا الْعُصْفُورُ الْحَيُّ فَيَأْخُذُهُ مَعَ خَشَبِ الأَرْزِ وَالْخَيْطِ الأَحْمَرِ وَالزُّوفَا، وَيَغْمِسُهَا جَمِيعاً فِي دَمِ الْعُصْفُورِ الْمَذْبُوحِ فَوْقَ الْمَاءِ الْجَارِي، ");
INSERT INTO arbnav_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ثُمَّ يَرُشُّ عَلَى الْمُتَطَهِّرِ مِنَ الْبَرَصِ سَبْعَ مَرَّاتٍ فَيُطَهِّرُهُ، ثُمَّ يُطْلِقُ الْعُصْفُورَ الْحَيَّ عَلَى وَجْهِ الصَّحْرَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","وَيَغْسِلُ الْمُتَطَهِّرُ ثِيَابَهُ، وَيَحْلِقُ كُلَّ رَأْسِهِ، وَيَسْتَحِمُّ بِمَاءٍ فَيَطْهُرُ، ثُمَّ يَدْخُلُ الْمُخَيَّمَ. إِلّا أَنَّهُ يُقِيمُ خَارِجَ خَيْمَتِهِ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","وَفِي الْيَوْمِ السَّابِعِ يَحْلِقُ مَا نَمَا مِنْ شَعْرِ رَأْسِهِ، وَكَذَلِكَ لِحْيَتَهُ وَحَوَاجِبَهُ، وَيَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ فَيُصْبِحُ طَاهِراً. ");
INSERT INTO arbnav_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","وَفِي الْيَوْمِ الثَّامِنِ يُحْضِرُ إِلَى الْكَاهِنِ كَبْشَيْنِ صَحِيحَيْنِ، وَنَعْجَةً حَوْلِيَّةً سَلِيمَةً وَثَلاثَةَ أَعْشَارٍ (نَحْوَ سَبْعَةِ لِتْرَاتٍ) مِنَ الدَّقِيقِ الْمَعْجُونِ بِزَيْتٍ وَلُجَّ (نَحْوَ ثُلْثَ لِتْرٍ) زَيْتٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","فَيُوْقِفُ الْكَاهِنُ الْقَائِمُ بِالتَّطْهِيرِ الأَبْرَصَ الْمُتَطَهِّرَ وَتَقْدِمَتَهُ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ثُمَّ يَأْخُذُ أَحَدَ الْكَبْشَيْنِ وَالزَّيْتَ وَيُرَجِّحُهُمَا فِي حَضْرَةِ الرَّبِّ، وَيُقَرِّبُهُمَا ذَبِيحَةَ إِثْمٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ثُمَّ يَذْبَحُ الْكَبْشَ فِي الْجَانِبِ الشِّمَالِيِّ مِنَ الْمَذْبَحِ حَيْثُ يَذْبَحُ قُرْبَانَ الْخَطِيئَةِ وَالْمُحْرَقَةَ فِي الْمَكَانِ الْمُقَدَّسِ، لأَنَّ ذَبِيحَةَ الإِثْمِ هِيَ كَذَبِيحَةِ الْخَطِيئَةِ، تَكُونُ مِنْ نَصِيبِ الْكَاهِنِ. إِنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","وَيَضَعُ الْكَاهِنُ مِنْ دَمِ ذَبِيحَةِ الإِثْمِ عَلَى شَحْمَةِ أُذْنِ الْمُتَطَهِّرِ الْيُمْنَى، وَعَلَى إِبْهَامِ يَدِهِ الْيُمْنَى، وَإِبْهَامِ قَدَمِهِ الْيُمْنَى، ");
INSERT INTO arbnav_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ثُمَّ يَأْخُذُ الْكَاهِنُ الزَّيْتَ وَيَصُبُّ فِي كَفِّهِ الْيُسْرَى، ");
INSERT INTO arbnav_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","وَيَغْمِسُ إِصْبَعَهُ الْيُمْنَى فِي الزَّيْتِ الْمَصْبُوبِ فِي يَدِهِ الْيُسْرَى، وَيَرُشُّ مِنْهُ سَبْعَ مَرَّاتٍ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","وَيَضَعُ الْكَاهِنُ مِنَ الزَّيْتِ الْبَاقِي فِي كَفِّهِ عَلَى شَحْمَةِ أُذْنِ الْمُتَطَهِّرِ الْيُمْنَى وَعَلَى إِبْهَامِ يَدِهِ الْيُمْنَى وَإِبْهَامِ رِجْلِهِ الْيُمْنَى فَوْقَ دَمِ ذَبِيحَةِ الإِثْمِ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","وَيَسْكُبُ الْكَاهِنُ مَا تَبَقَّى مِنْ زَيْتٍ فِي كَفِّهِ عَلَى رَأْسِ الْمُتَطَهِّرِ، وَيُكَفِّرُ عَنْهُ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ثُمَّ يُقَدِّمُ الْكَاهِنُ ذَبِيحَةَ الْخَطِيئَةِ تَكْفِيراً عَنِ الْمُتَطَهِّرِ مِنْ بَرَصِهِ ثُمَّ يَذْبَحُ الْمُحْرَقَةَ ");
INSERT INTO arbnav_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","وَيُصْعِدُ الْكَاهِنُ الْمُحْرَقَةَ وَالتَّقْدِمَةَ عَلَى الْمَذْبَحِ تَكْفِيراً عَنْهُ، فَيُصْبِحُ طَاهِراً. ");
INSERT INTO arbnav_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","أَمَّا إِذَا كَانَ الْمُتَطَهِّرُ فَقِيراً وَعَاجِزاً عَنْ ذَلِكَ، يُحْضِرُ كَبْشاً وَاحِداً ذَبِيحَةَ إِثْمٍ تَكْفِيراً عَنْهُ، وَعُشْراً (نَحْوَ لِتْرَيْنِ وَنِصْفِ اللِّتْرِ) مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ كَتَقْدِمَةٍ، وَلُجَّ (نَحْوَ ثُلْثِ لِتْرٍ) زَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","وَيَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ، حَسَبَ قُدْرَتِهِ، فَيَكُونُ الْوَاحِدُ ذَبِيحَةَ خَطِيئَةٍ وَالآخَرُ مُحْرَقَةً. ");
INSERT INTO arbnav_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","يُحْضِرُ هَذِهِ كُلَّهَا فِي الْيَوْمِ الثَّامِنِ إِلَى الْكَاهِنِ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ لِفَرِيضَةِ تَطْهِيرِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","فَيَأْخُذُ الْكَاهِنُ كَبْشَ الإِثْمِ وَالزَّيْتَ وَيُرَجِّحُهُمَا أَمَامَ الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ثُمَّ يَذْبَحُ كَبْشَ الإِثْمِ وَيَأْخُذُ مِنْ دَمِهِ وَيَضَعُ مِنْهُ عَلَى شَحْمَةِ أُذْنِ الْمُتَطَهِّرِ الْيُمْنَى، وَعَلَى إِبْهَامَيْ يَدِهِ الْيُمْنَى وَرِجْلِهِ الْيُمْنَى. ");
INSERT INTO arbnav_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","وَيَصُبُّ الْكَاهِنُ فِي كَفِّهِ الْيُسْرَى زَيْتاً، ");
INSERT INTO arbnav_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","وَيَرُشُّ مِنْهُ بِإِصْبَعِهِ الْيُمْنَى سَبْعَ مَرَّاتٍ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","وَكَذَلِكَ يَضَعُ الْكَاهِنُ مِنَ الزَّيْتِ الَّذِي فِي كَفِّهِ عَلَى شَحْمَةِ أُذْنِ الْمُتَطَهِّرِ الْيُمْنَى وَعَلَى إِبْهَامَيْ يَدِهِ الْيُمْنَى وَرِجْلِهِ الْيُمْنَى فَوْقَ مَوْضِعِ دَمِ ذَبِيحَةِ الإِثْمِ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","وَيَسْكُبُ مَا تَبَقَّى مِنْ زَيْتٍ فِي كَفِّهِ عَلَى رَأْسِ الْمُتَطَهِّرِ، تَكْفِيراً عَنْهُ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ثُمَّ يُقَدِّمُ الْكَاهِنُ الْيَمَامَتَيْنِ أَوْ فَرْخَيِ الْحَمَامِ، بِحَسَبِ قُدْرَةِ الْمُتَطَهِّرِ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","فَيُقَرِّبُ إِحْدَاهُمَا ذَبِيحَةَ خَطِيئَةٍ وَالأُخْرَى مُحْرَقَةً مَعَ التَّقْدِمَةِ، تَكْفِيراً عَنِ الْمُتَطَهِّرِ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","هَذِهِ هِيَ نُصُوصُ التَّعْلِيمَاتِ الْمُتَعَلِّقَةِ بِالأَبْرَصِ الْمُتَطَهِّرِ الْفَقِيرِ». ");
INSERT INTO arbnav_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«عِنْدَمَا تَدْخُلُونَ أَرْضَ كَنْعَانَ الَّتِي وَهَبْتُهَا لَكُمْ مُلْكاً، وَجَعَلْتُ الْبَرَصَ الْمُعْدِي يَتَفَشَّى فِي أَحَدِ الْبُيُوتِ فِي الأَرْضِ الَّتِي امْتَلَكْتُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","يَأْتِي صَاحِبُ الْبَيْتِ وَيُخْبِرُ الْكَاهِنَ أَنَّ دَاءَ الْبَرَصِ قَدْ يَكُونُ مُتَفَشِّياً بِالْبَيْتِ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","فَيَأْمُرُ الْكَاهِنُ بِإِخْلاءِ الْبَيْتِ قَبْلَ أَنْ يَدْخُلَ إِلَيْهِ لِئَلّا يَتَنَجَّسَ كُلُّ مَا فِي الْبَيْتِ، ثُمَّ يَدْخُلُ الْكَاهِنُ الْبَيْتَ لِيَفْحَصَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","فَإِذَا عَايَنَ الإِصَابَةَ وَوَجَدَ أَنَّ فِي حِيطَانِ الْبَيْتِ نُقَراً لَوْنُهَا ضَارِبٌ إِلَى الْخُضْرَةِ أَوْ إِلَى الْحُمْرَةِ، وَبَدَا مَنْظَرُهَا غَائِراً فِي الْحِيطَانِ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","يُغَادِرُ الْكَاهِنُ الْبَيْتَ وَيُغْلِقُ بَابَهُ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","فَإِذَا رَجَعَ فِي الْيَوْمِ السَّابِعِ وَفَحَصَهُ، وَوَجَدَ أَنَّ الإِصَابَةَ قَدِ امْتَدَّتْ فِي حِيطَانِ الْبَيْتِ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","يَأْمُرُ الْكَاهِنُ بِقَلْعِ الْحِجَارَةِ الْمُصَابَةِ وَطَرْحِهَا خَارِجَ الْمَدِينَةِ فِي مَكَانٍ نَجِسٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","وَتُكْشَطُ حِيطَانُ الْبَيْتِ الدَّاخِلِيَّةُ، وَيَطْرَحُونَ التُّرَابَ الْمَكْشُوطَ خَارِجَ الْمَدِينَةِ فِي مَكَانٍ نَجِسٍ ");
INSERT INTO arbnav_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ثُمَّ يَأْتُونَ بِحِجَارَةٍ أُخْرَى يَضَعُونَهَا مَكَانَ الْحِجَارَةِ الْمُقْتَلَعَةِ وَيُعِيدُونَ تَطْيِينَ الْبَيْتِ مِنْ جَدِيدٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","فَإِنْ رَجَعَتِ الإِصَابَةُ وَانْتَشَرَتْ فِي الْبَيْتِ بَعْدَ قَلْعِ الْحِجَارَةِ وَكَشْطِ الْحِيطَانِ وَتَطْيِينِهَا، ");
INSERT INTO arbnav_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","وَوَجَدَ الْكَاهِنُ ذَلِكَ، تَكُونُ هَذِهِ إِصَابَةَ دَاءِ بَرَصٍ مُعْدٍ فِي الْبَيْتِ، إِنَّهُ نَجِسٌ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","فَيَتِمُّ هَدْمُ الْبَيْتِ بِمَا فِيهِ مِنْ حِجَارَةٍ وَأَخْشَابٍ وَتُرَابٍ، وَتُنْقَلُ كُلُّهَا إِلَى خَارِجِ الْمَدِينَةِ إِلَى مَكَانٍ نَجِسٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","وَمَنْ دَخَلَ الْبَيْتَ فِي أَثْنَاءِ غَلْقِهِ يَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","وَعَلَى كُلِّ مَنْ نَامَ فِيهِ أَوْ أَكَلَ، أَنْ يَغْسِلَ ثِيَابَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","لَكِنْ إِنْ وَجَدَ الْكَاهِنُ أَنَّ الإِصَابَةَ لَمْ تَنْتَشِرْ فِي الْبَيْتِ بَعْدَ تَطْيِينِهِ، يُطَهِّرُهُ الْكَاهِنُ، لأَنَّ دَاءَ الْبَرَصِ قَدْ زَالَ منْهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","فَيُحْضِرُ لِتَطْهِيرِ الْبَيْتِ عُصْفُورَيْنِ وَخَشَبَ أَرْزٍ وَخَيْطاً أَحْمَرَ وَزُوفاً، ");
INSERT INTO arbnav_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","فَيَذْبَحُ أَحَدَ الْعُصْفُورَيْنِ فِي إِنَاءٍ خَزَفِيٍّ فَوْقَ مَاءٍ جَارٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","وَيَغْمِسُ خَشَبَ الأَرْزِ وَالزُّوفَا وَالْخَيْطَ الأَحْمَرَ وَالْعُصْفُورَ الْحَيَّ بِدَمِ الْعُصْفُورِ الْمَذْبُوحِ وَبِالْمَاءِ الْجَارِي، وَيَرُشُّ الْبَيْتَ سَبْعَ مَرَّاتٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","وَيُطَهِّرُ الْبَيْتَ بِدَمِ الْعُصْفُورِ وَبِالْمَاءِ الْجَارِي وَبِالْعُصْفُورِ الْحَيِّ وَبِخَشَبِ الأَرْزِ وَالزُّوفَا وَالْخَيْطِ الأَحْمَرِ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ثُمَّ يُطْلِقُ الْعُصْفُورَ الْحَيَّ إِلَى خَارِجِ الْمَدِينَةِ عَلَى وَجْهِ الصَّحْرَاءِ، تَكْفِيراً عَنِ الْبَيْتِ، فَيُصْبِحُ طَاهِراً. ");
INSERT INTO arbnav_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","هَذِهِ هِيَ نُصُوصُ التَّعْلِيمَاتِ الْمُتَعَلِّقَةِ بِكُلِّ أَنْوَاعِ إِصَابَاتِ الْبَرَصِ وَالْقَرَعِ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","الَّتِي مِنْهَا بَرَصُ الثَّوْبِ وَالْبَيْتِ، ");
INSERT INTO arbnav_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","وَالْوَرَمُ الْجِلْدِيُّ وَالْقُوبَاءُ وَالْبُقْعَةُ اللّامِعَةُ. ");
INSERT INTO arbnav_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","وَهَذِهِ التَّعْلِيمَاتُ هِيَ لِلتَّمْيِيزِ بَيْنَ مَا هُوَ نَجِسٌ وَمَا هُوَ طَاهِرٌ فِي حَالَةِ الإِصَابَةِ بِمَا يَبْدُو أَنَّهُ دَاءُ الْبَرَصِ». ");
INSERT INTO arbnav_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","وَقَالَ الرَّبُّ لِمُوسَى وَهَرُونَ: ");
INSERT INTO arbnav_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«أَوْصِيَا بَنِي إِسْرَائِيلَ: كُلُّ رَجُلٍ جَسَدُهُ مُصَابٌ بِالسَّيَلانِ فَهُوَ نَجِسٌ، ");
INSERT INTO arbnav_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","وَنَجَاسَتُهُ فِي سَيَلانِهِ، سَوَاءٌ أَفْرَزَ الْبَدَنُ السَّيَلانَ أَمِ احْتَبَسَهُ، فَذَلِكَ يَكُونُ نَجَاسَتَهُ، ");
INSERT INTO arbnav_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","كُلُّ مَا يَنَامُ عَلَيْهِ الْمُصَابُ بِالسَّيَلانِ مِنْ فِرَاشٍ أَوْ يَجْلِسُ عَلَيْهِ مِنْ مَتَاعٍ يَكُونُ نَجِساً، ");
INSERT INTO arbnav_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","وَعَلَى مَنْ لَمَسَ فِرَاشَهُ أَنْ يَغْسِلَ ثِيَابَهُ وَيَسْتَحِمَّ، وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","وَمَنْ يَجْلِسُ عَلَى مَتَاعٍ جَلَسَ عَلَيْهِ الْمُصَابُ بِالسَّيَلانِ يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","وَمَنْ يَمَسُّ جَسَدَ الْمُصَابِ بِالسَّيَلانِ يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","وَإِنْ بَصَقَ الْمُصَابُ بِالسَّيَلانِ عَلَى شَخْصٍ طَاهِرٍ، فَعَلَى الطَّاهِرِ أَنْ يَغْسِلَ ثِيَابَهُ وَيَسْتَحِمَّ بِمَاءٍ، وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ ");
INSERT INTO arbnav_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","كُلُّ مَا يَمْتَطِيهِ الْمُصَابُ بِالسَّيَلانِ يُصْبِحُ نَجِساً. ");
INSERT INTO arbnav_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","وَكُلُّ مَنْ يَلْمِسُ شَيْئاً كَانَ تَحْتَ الْمُصَابِ، أَوْ حَمَلَهُ يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","وَعَلَى كُلِّ شَخْصٍ يَمَسُّهُ الْمُصَابُ مِنْ غَيْرِ أَنْ يَكُونَ قَدْ غَسَلَ يَدَيْهِ بِمَاءٍ، أَنْ يَغْسِلَ ثِيَابَهُ بِمَاءٍ وَيَسْتَحِمَّ بِمَاءٍ، وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","وَأَيُّ إِنَاءٍ خَزَفِيٍّ يَلْمِسُهُ الْمُصَابُ يُكْسَرُ. أَمَّا إِنَاءُ الْخَشَبِ فَيُغْسَلُ بِمَاءٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","وَإذَا بَرِئَ الْمُصَابُ بِالسَّيَلانِ مِنْ دَائِهِ فَلْيَمْكُثْ سَبْعَةَ أَيَّامٍ لِطُهْرِهِ، وَيَغْسِلْ ثِيَابَهُ وَيَسْتَحِمَّ بِمَاءٍ جَارٍ، فَيَطْهُرَ، ");
INSERT INTO arbnav_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","وَفِي الْيَوْمِ الثَّامِنِ يَأْخُذُ لِنَفْسِهِ يَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ وَيَأْتِي أَمَامَ الرَّبِّ إِلَى مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ وَيُعْطِيهِمَا لِلْكَاهِنِ، ");
INSERT INTO arbnav_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","فَيُقَدِّمُ الْكَاهِنُ أَحَدَهُمَا ذَبِيحَةَ خَطِيئَةٍ وَالآخَرَ مُحْرَقَةً. وَيُكَفِّرُ الْكَاهِنُ عَنِ الْمُصَابِ بِالسَّيَلانِ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","وَإذَا أَفْرَزَ رَجُلٌ سَائِلَهُ الْمَنَوِيَّ، يَغْسِلُ كُلَّ جَسَدِهِ بِمَاءٍ وَيُصْبِحُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","وَكُلُّ مَا يَقَعُ عَلَيْهِ السَّائِلُ الْمَنَوِيُّ مِنْ ثِيَابٍ أَوْ جِلْدٍ يُغْسَلُ بِمَاءٍ وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","وَإذَا عَاشَرَ رَجُلٌ زَوْجَتَهُ يَسْتَحِمَّانِ كِلاهُمَا بِمَاءٍ وَيَكُونَانِ نَجِسَيْنِ إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","وَإذَا حَاضَتِ الْمَرْأَةُ فَسَبْعَةَ أَيَّامٍ تَكُونُ فِي طَمْثِهَا، وَكُلُّ مَنْ يَلْمِسُهَا يَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","كُلُّ مَا تَنَامُ عَلَيْهِ فِي أَثْنَاءِ حَيْضِهَا أَوْ تَجْلِسُ عَلَيْهِ يَكُونُ نَجِساً، ");
INSERT INTO arbnav_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","وَكُلُّ مَنْ يَلْمِسُ فِرَاشَهَا يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","وَكُلُّ مَنْ مَسَّ مَتَاعاً تَجْلِسُ عَلَيْهِ، يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","وَكُلُّ مَنْ يَلَمِسُ شَيْئاً كَانَ مَوْجُوداً عَلَى الْفِرَاشِ أَوْ عَلَى الْمَتَاعِ الَّذِي تَجْلِسُ عَلَيْهِ يَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","وَإِنْ عَاشَرَهَا رَجُلٌ وَأَصَابَهُ شَيْءٌ مِنْ طَمْثِهَا، يَكُونُ نَجِساً سَبْعَةَ أَيَّامٍ. وَكُلُّ فِرَاشٍ يَنَامُ عَلَيْهِ يُصْبِحُ نَجِساً. ");
INSERT INTO arbnav_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","إِذَا نَزَفَ دَمُ امْرَأَةٍ فَتْرَةً طَوِيلَةً فِي غَيْرِ أَوَانِ طَمْثِهَا، أَوِ اسْتَمَرَّ الْحَيْضُ بَعْدَ مَوْعِدِهِ، تَكُونُ كُلَّ أَيَّامِ نَزْفِهَا نَجِسَةً كَمَا فِي أَثْنَاءِ طَمْثِهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","كُلُّ مَا تَنَامُ عَلَيْهِ فِي أَثْنَاءِ نَزْفِهَا يَكُونُ نَجِساً كَفِرَاشِ طَمْثِهَا، وَكُلُّ مَا تَجْلِسُ عَلَيْهِ مِنْ مَتَاعٍ يَكُونُ نَجِساً كَنَجَاسَةِ طَمْثِهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","وَأَيُّ شَخْصٍ يَلْمِسُهُنَّ يَكُونُ نَجِساً، فَيَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِساً إِلَى الْمَسَاءِ ");
INSERT INTO arbnav_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","وَإذَا بَرِئَتْ مِنْ نَزْفِهَا فَلْتَمْكُثْ سَبْعَةَ أَيَّامٍ ثُمَّ تَطْهُرُ، ");
INSERT INTO arbnav_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","وَفِي الْيَوْمِ الثَّامِنِ تَجِيءُ بِيَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ إِلَى الْكَاهِنِ إِلَى مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، ");
INSERT INTO arbnav_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","فَيُقَدِّمُ الْكَاهِنُ أَحَدَهُمَا ذَبِيحَةَ خَطِيئَةٍ، وَالآخَرَ مُحْرَقَةً. وَيُكَفِّرُ الْكَاهِنُ عَنْهَا فِي حَضْرَةِ الرَّبِّ مِنْ نَزْفِ نَجَاسَتِهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","وَبِهَذَا تَحْفَظَانِ بَنِي إِسْرَائِيلَ مِمَّا يُنَجِّسُهُمْ، لِئَلّا يَمُوتُوا فِي نَجَاسَتِهِمْ إِنْ دَنَّسُوا مَسْكَنِي الَّذِي فِي وَسَطِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","هَذِهِ هِيَ نُصُوصُ التَّعْلِيمَاتِ بَشَأْنِ الْمُصَابِ بِالسَّيَلانِ، أَوْ مَنْ يُفْرِزُ سَائِلَهُ الْمَنَوِيَّ فَيَتَنَجَّسُ بِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","وَالْمَرْأَةِ الْحَائِضِ، وَالرَّجُلِ أَوِ الْمَرْأَةِ الْمُصَابِ بِالسَّيَلانِ، وَالرَّجُلِ الَّذِي عَاشَرَ امْرَأَةً حَائِضاً». ");
INSERT INTO arbnav_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","وَقَالَ الرَّبُّ لِمُوسَى بَعْدَ وَفَاةِ ابْنَيْ هَرُونَ، عِنْدَمَا اقْتَرَبَا أَمَامَ الرَّبِّ فَمَاتَا: ");
INSERT INTO arbnav_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","«كَلِّمْ أَخَاكَ هَرُونَ وَحَذِّرْهُ مِنَ الدُّخُولِ فِي كُلِّ وَقْتٍ إِلَى قُدْسِ الأَقْدَاسِ، وَرَاءَ الْحِجَابِ أَمَامَ غِطَاءِ التَّابُوتِ، لِئَلّا يَمُوتَ، لأَنَّنِي أَتَجَلَّى فِي السَّحَابِ عَلَى الْغِطَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","بِهَذَا يَدْخُلُ هَرُونُ إِلَى الْقُدْسِ: يَأْتِي بِثَوْرٍ لِذَبِيحَةِ خَطِيئَةٍ وَكَبْشٍ لِمُحْرَقَةٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","وَعَلَيْهِ أَنْ يَلْبَسَ قَمِيصَ كَتَّانٍ مُقَدَّساً، وَيَرْتَدِيَ فَوْقَ جَسَدِهِ سَرَاوِيلَ كَتَّانٍ، وَيَتَنَطَّقَ بِحِزَامِ كَتَّانٍ، وَيَتَعَمَّمَ بِعِمَامَةِ كَتَّانٍ، بَعْدَ أَنْ يَغْتَسِلَ بِمَاءٍ. إِنَّهَا ثِيَابٌ مُقَدَّسَةٌ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","يَأْخُذُ مِنْ شَعْبِ إِسْرَائِيلَ تَيْسَيْنِ مِنَ الْمَعْزِ لِذَبِيحَةِ الْخَطِيئَةِ، وَكَبْشاً وَاحِداً لِيَكُونَ مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","فَيُقَرِّبُ هَرُونُ ثَوْرَ الْخَطِيئَةِ تَكْفِيراً عَنْ نَفْسِهِ وَعَنْ أُسْرَتِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ثُمَّ يَأْخُذُ التَّيْسَيْنِ وَيُقَدِّمُهُمَا أَمَامَ الرَّبِّ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","وَيُلْقِي عَلَيْهِمَا قُرْعَتَيْنِ: قُرْعَةً لِلرَّبِّ وَقُرْعَةً لِعَزَازِيلَ (كَبْشِ الْفِدَاءِ). ");
INSERT INTO arbnav_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","وَيُقَرِّبُ هَرُونُ التَّيْسَ الَّذِي وَقَعَتْ عَلَيْهِ قُرْعَةُ الرَّبِّ وَيُصْعِدُهُ ذَبِيحَةَ خَطِيئَةٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","وَأَمَّا التَّيْسُ الَّذِي وَقَعَتْ عَلَيْهِ قُرْعَةُ عَزَازِيلَ، فَيُوْقِفُهُ حَيًّا أَمَامَ الرَّبِّ لِيُكَفِّرَ عَنْهُ، ثُمَّ يُطْلِقُهُ إِلَى الصَّحْرَاءِ، فَهُوَ كَبْشُ فِدَاءٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","وَبَعْدَ أَنْ يُقَدِّمَ هَرُونُ ثَوْرَ الْخَطِيئَةِ تَكْفِيراً عَنْ نَفْسِهِ وَعَنْ أُسْرَتِهِ وَيَذْبَحَهُ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","يَمْلأُ الْمِجْمَرَةَ بِجَمْرِ نَارٍ مِنْ عَلَى الْمَذْبَحِ مِنْ أَمَامِ الرَّبِّ، وَيَأْخُذُ مِلْءَ قَبْضَتِهِ مِنَ الْبَخُورِ الْعَطِرِ الدَّقِيقِ وَيَدْخُلُ بِهِمَا إِلَى مَا وَرَاءِ الْحِجَابِ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","وَيَضَعُ الْبَخُورَ عَلَى النَّارِ فِي حَضْرَةِ الرَّبِّ، فَتُغَشِّي سَحَابَةُ الْبَخُورِ غِطَاءَ التَّابُوتِ، فَلا يَمُوتُ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ثُمَّ يَأْخُذُ بَعْضَ دَمِ الثَّوْرِ وَيَرُشُّ بِإِصْبَعِهِ عَلَى وَجْهِ الْجُزْءِ الشَّرْقِيِّ مِنْ غِطَاءِ التَّابُوتِ، كَمَا يَرُشُّ مِنَ الدَّمِ بِإِصْبَعِهِ سَبْعَ مَرَّاتٍ أَمَامَ الْغِطَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","وَيَذْبَحُ تَيْسَ الْخَطِيئَةِ الْمُقَدَّمَ مِنَ الشَّعْبِ، وَيَدْخُلُ بِدَمِهِ إِلَى مَا وَرَاءَ الْحِجَابِ، وَيَرُشُّ مِنْ دَمِهِ كَمَا رَشَّ مِنْ دَمِ الثَّوْرِ عَلَى الْغِطَاءِ وَأَمَامَهُ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","فَيُكَفِّرُ عَنِ الْقُدْسِ مِنْ نَجَاسَاتِ بَنِي إِسْرَائِيلَ وَسَيِّئَاتِهِمْ وَسَائِرِ خَطَايَاهُمْ. وَمِثْلَ ذَلِكَ يَفْعَلُ لِخَيْمَةِ الاجْتِمَاعِ الْقَائِمَةِ فِي وَسَطِهِمْ، مُحَاطَةٍ بِنَجَاسَاتِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","وَلا يَكُنْ أَحَدٌ فِي خَيْمَةِ الاجْتِمَاعِ عِنْدَ دُخُولِ هَرُونَ إِلَى قُدْسِ الأَقْدَاسِ لِلتَّكْفِيرِ عَنْ نَفْسِهِ وَعَنْ أُسْرَتِهِ وَعَنْ كُلِّ جَمَاعَةِ إِسْرَائِيلَ، وَإِلَى وَقْتِ خُرُوجِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ثُمَّ يَأْتِي إِلَى الْمَذْبَحِ الْقَائِمِ فِي حَضْرَةِ الرَّبِّ وَيُكَفِّرُ عَنْهُ، فَيَأْخُذُ مِنْ دَمِ الثَّوْرِ وَمِنْ دَمِ التَّيْسِ، وَيَضَعُ مِنْهُمَا عَلَى قُرُونِ جَوَانِبِ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","وَيَرُشُّ عَلَيْهِ مِنَ الدَّمِ بِإِصْبَعِهِ سَبْعَ مَرَّاتٍ وَيُطَهِّرُهُ وَيُقَدِّسُهُ مِنْ نَجَاسَاتِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","وَعِنْدَمَا يَنْتَهِي مِنَ التَّكْفِيرِ عَنْ قُدْسِ الأَقْدَاسِ، وَعَنْ خَيْمَةِ الاجْتِمَاعِ، وَعَنِ الْمَذْبَحِ، يَأْتِي بِالتَّيْسِ الْحَيِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","وَيَضَعُ هَرُونُ يَدَيْهِ عَلَى رَأْسِهِ، وَيَعْتَرِفُ بِجَمِيعِ خَطَايَا بَنِي إِسْرَائِيلَ وَسَيِّئَاتِهِمْ وَذُنُوبِهِمْ، وَيُحَمِّلُهَا عَلَى رَأْسِ التَّيْسِ، ثُمَّ يُطْلِقُهُ إِلَى الصَّحْرَاءِ مَعَ شَخْصٍ تَمَّ اخْتِيَارُهُ لِذَلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","فَيَحْمِلُ التَّيْسُ ذُنُوبَ الشَّعْبِ كُلَّهَا إِلَى أَرْضٍ مُقْفِرَةٍ، وَهُنَاكَ يُطْلِقُهُ فِي الصَّحْرَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","ثُمَّ يَدْخُلُ هَرُونُ إِلَى خَيْمَةِ الاجْتِمَاعِ، حَيْثُ يَخْلَعُ الْمَلابِسَ الْكَتَّانِيَّةَ الَّتِي ارْتَدَاهَا عِنْدَ دُخُولِهِ إِلَى قُدْسِ الأَقْدَاسِ وَيَضَعُهَا هُنَاكَ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","وَيَسْتَحِمُّ بِمَاءٍ فِي مَكَانٍ مُقَدَّسٍ، ثُمَّ يَرْتَدِي ثِيَابَهُ وَيَخْرُجُ لِيُصْعِدَ مُحْرَقَتَهُ وَمُحْرَقَةَ الشَّعْبِ، وَيُكَفِّرَ عَنْ نَفْسِهِ وَعَنِ الشَّعْبِ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","وَيُحْرِقَ شَحْمَ ذَبِيحَةِ الْخَطِيئَةِ عَلَى الْمَذْبَحِ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","وَيَغْسِلَ ثِيَابَهُ وَيَسْتَحِمَّ بِمَاءٍ، وَبَعْدَ ذَلِكَ يَدْخُلُ إِلَى الْمُخَيَّمِ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ثُمَّ يُخْرِجُ هَرُونُ ثَوْرَ الْخَطِيئَةِ وَتَيْسَ الْخَطِيئَةِ اللَّذَيْنِ كَفَّرَ بِدَمِهِمَا فِي قُدْسِ الأَقْدَاسِ إِلَى خَارِجِ الْمُخَيَّمِ، وَتُحْرِقُونَهُمَا بِالنَّارِ: جِلْدَيْهِمَا وَلَحْمَهُمَا وَرَوْثَهُمَا، ");
INSERT INTO arbnav_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","وَعَلَى مَنْ يُحْرِقُهُمَا أَنْ يَغْسِلَ ثِيَابَهُ وَيَسْتَحِمَّ بِمَاءٍ، وَبَعْدَ ذَلِكَ يَدْخُلُ إِلَى الْمُخَيَّمِ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","وَإِلَيْكُمْ هَذِهِ الشَّرِيعَةَ الدَّائِمَةَ: إِنَّكُمْ فِي الْيَوْمِ الْعَاشِرِ مِنَ الشَّهْرِ السَّابِعِ (أَيْ شَهْرِ أَيْلُولَ – سِبْتَمْبَر) تَتَذَلَّلُونَ وَلا تَقُومُونَ بِأَيِّ عَمَلٍ. الْمُوَاطِنُ وَالْغَرِيبُ النَّازِلُ فِي وَسَطِكُمْ عَلَى حَدٍّ سَوَاءٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","لأَنَّهُ فِي هَذَا الْيَوْمِ يَجْرِي التَّكْفِيرُ عَنْكُمْ، فَتَطْهُرُونَ مِنْ جَمِيعِ خَطَايَاكُمْ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","إِنَّهُ يَوْمُ رَاحَةٍ مُقَدَّسَةٍ لَكُمْ تَتَذَلَّلُونَ فِيهِ، فَرِيضَةً دَائِمَةً. ");
INSERT INTO arbnav_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","وَيَقُومُ الْكَاهِنُ الْمَمْسُوحُ وَالْمُكَرَّسُ الَّذِي يَخْلِفُ وَالِدَهُ عَلَى رَئَاسَةِ الْكَهَنَةِ بِفَرَائِضِ التَّكْفِيرِ وَهُوَ لابِسٌ ثِيَابَ الْكَتَّانِ الْمُقَدَّسَةَ، ");
INSERT INTO arbnav_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","فَيُكَفِّرُ عَنْ قُدْسِ الأَقْدَاسِ، وَعَنْ خَيْمَةِ الاجْتِمَاعِ، وَالْمَذْبَحِ، وَيُكَفِّرُ أَيْضاً عَنِ الْكَهَنَةِ وَعَنْ كُلِّ شَعْبِ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","وَتَكُونُ هَذِهِ لَكُمْ فَرِيضَةً دَائِمَةً لِلتَّكْفِيرِ عَنْ جَمِيعِ خَطَايَا بَنِي إِسْرَائِيلَ، مَرَّةً فِي السَّنَةِ». فَنَفَّذَ هَرُونُ مَا أَمَرَ بِهِ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«قُلْ لِهَرُونَ وَأَبْنَائِهِ وَسَائِرِ بَنِي إِسْرَائِيلَ: إِلَيْكُمْ مَا أَوْصَى بِهِ الرَّبُّ: ");
INSERT INTO arbnav_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","أَيُّ إِسْرَائِيلِيٍّ يَذْبَحُ قُرْبَاناً بَقَراً أَوْ غَنَماً أَوْ مِعْزَى فِي الْمُخَيَّمِ أَوْ خَارِجَ الْمُخَيَّمِ، ");
INSERT INTO arbnav_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","وَلَيْسَ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ حَيْثُ يَتَوَجَّبُ عَلَيْهِ تَقْدِيمُهُ أَمَامَ مَسْكَنِ الرَّبِّ، يُعْتَبَرُ قَاتِلاً قَدْ سَفَكَ دَماً، وَيَجِبُ أَنْ يُسْتَأْصَلَ ذَلِكَ الإِنْسَانُ مِنْ بَيْنِ شَعْبِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","وَذَلِكَ لِكَيْ يَأْتِيَ بَنُو إِسْرَائِيلَ بِذَبَائِحِهِمِ الَّتِي يَذْبَحُونَهَا فِي خَلاءِ الصَّحْرَاءِ وَيُقَدِّمُوهَا لِلرَّبِّ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، عَلَى يَدِ الْكَاهِنِ، وَيُقَرِّبُوهَا ذَبَائِحَ سَلامٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","فَيَرُشُّ الْكَاهِنُ دَمَ الذَّبِيحَةِ عَلَى مَذْبَحِ الرَّبِّ، عِنْدَ مَدْخَلِ خَيْمَةِ الْاجْتِمَاعِ، وَيُحْرِقُ الشَّحْمَ لِيَحْظَى بِرِضَى الرَّبِّ وَسُرُورِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","وَلا يَذْبَحُوا ذَبَائِحَهُمْ فِي الْخَلاءِ كَمُحْرَقَاتٍ لأَوْثَانِ التُّيُوسِ الَّتِي يَغْوُونَ وَرَاءَهَا فَتَكُونُ لَهُمْ هَذِهِ فَرِيضَةً دَائِمَةً جِيلاً بَعْدَ جِيلٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","وَتَقُولُ لَهُمْ: أَيُّ إِسْرَائِيلِيٍّ، أَوْ غَرِيبٍ مِنَ الْغُرَبَاءِ الْمُقِيمِينَ فِي وَسَطِكُمْ، يُصْعِدُ مُحْرَقَةً أَوْ ذَبِيحَةً، ");
INSERT INTO arbnav_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","وَلا يَأْتِي بِها إِلَى مَدْخَلِ خَيْمَةِ الاِجْتِمَاعِ، وَلا يُقَدِّمُهَا لِلرَّبِّ يُسْتَأْصَلُ مِنْ بَيْنِ شَعْبِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","وَأَيُّ إِسْرَائِيلِيٍّ أَوْ غَرِيبٍ مِنَ الْمُقِيمِينَ فِي وَسَطِكُمْ، يَأْكُلُ دَماً، أَنْقَلِبُ عَلَيْهِ وَأَسْتَأْصِلُهُ مِنْ بَيْنِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","لأَنَّ حَيَاةَ الْجَسَدِ هِيَ فِي الدَّمِ. لِهَذَا وَهَبْتُكُمْ إِيَّاهُ لِتُكَفِّرُوا عَنْ نُفُوسِكُمْ، لأَنَّ الدَّمَ يُكَفِّرُ عَنِ النَّفْسِ. ");
INSERT INTO arbnav_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","لِذَلِكَ أَوْصَيْتُ بَنِي إِسْرَائِيلَ أَلّا يَأْكُلُوا دَماً، وَكَذَلِكَ لَا يَأْكُلُهُ الْغَرِيبُ الْمُقِيمُ فِي وَسَطِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","أَيُّ إِسْرَائِيلِيٍّ، أَوْ غَرِيبٍ مُقِيمٍ فِي وَسَطِكُمْ، يَقْتَنِصُ حَيَوَاناً أَوْ طَيْراً مُحَلَّلاً أَكْلُهُ، يَسْفِكُ دَمَهَ وَيُغَطِّيهِ بِالتُّرَابِ، ");
INSERT INTO arbnav_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","لأَنَّ حَيَاةَ كُلِّ مَخْلُوقٍ هِيَ دَمُهُ، وَلِهَذَا أَوْصَيْتُ بَنِي إِسْرَائِيلَ أَلّا يَأْكُلُوا دَمَ جَسَدٍ مَا، لأَنَّ حَيَاةَ كُلِّ جَسَدٍ هِيَ دَمُهُ، وَكُلُّ مَنْ يَأْكُلُ مِنْهُ يُسْتَأْصَلُ. ");
INSERT INTO arbnav_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","أَيُّ إِنْسَانٍ، سَوَاءٌ كَانَ مُوَاطِناً أَمْ غَرِيباً، يَأْكُلُ مِنْ جِيفَةٍ أَوْ فَرِيسَةٍ، عَلَيْهِ أَنْ يَغْسِلَ ثِيَابَهُ وَيَسْتَحِمَّ بِمَاءٍ، وَيَبْقَى نَجِساً إِلَى الْمَسَاءِ، ثُمَّ يُصْبِحُ طَاهِراً. ");
INSERT INTO arbnav_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","وَلَكِنْ إِنْ لَمْ يَغْسِلْ ثِيَابَهُ وَلَمْ يَسْتَحِمَّ يَتَحَمَّلْ عِقَابَ ذَنْبِهِ». ");
INSERT INTO arbnav_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ: أَنَا الرَّبُّ إِلَهُكُمْ ");
INSERT INTO arbnav_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","لَا تَرْتَكِبُوا أَعْمَالَ أَهْلِ مِصْرَ الَّتِي أَقَمْتُمْ فِيهَا، وَلا تَعْمَلُوا صَنِيعَ أَهْلِ أَرْضِ كَنْعَانَ الَّتِي أَنَا مُدْخِلُكُمْ إِلَيْهَا، وَلا تُمَارِسُوا فَرَائِضَهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","إِنَّمَا تُطَبِّقُونَ أَحْكَامِي وَتَحْفَظُونَ فَرَائِضِي لِتَسْلُكُوا فِيهَا. أَنَا الرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","احْفَظُوا فَرَائِضِي وَأَحْكَامِي الَّتِي إِذَا أَطَاعَهَا الإِنْسَانُ يَحْيَا بِها. أَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","لَا يُقَارِبْ إِنْسَانٌ جَسَدَ مَنْ هُوَ مِنْ لَحْمِهِ وَدَمِهِ لِيُعَاشِرَهُ. أَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","لَا تَتَزَوَّجْ فَتَاةٌ أَبَاهَا، وَلا ابْنٌ أُمَّهُ إِنَّهَا أُمُّكَ فَلا تَكْشِفْ عَوْرَتَهَا ");
INSERT INTO arbnav_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","لَا تَتَزَوَّجْ امْرَأَةَ أَبِيكَ لأَنَّهَا زَوْجَةُ أَبِيكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","لَا تَتَزَوَّجْ أُخْتَكَ بِنْتَ أَبِيكَ، أَوْ بِنْتَ أُمِّكَ، سَوَاءٌ وُلِدَتْ فِي الْبَيْتِ أَمْ بَعِيداً عَنْهُ، وَلا تَكْشِفْ عَوْرَتَهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","لَا تَتَزَوَّجِ ابْنَةَ ابْنِكَ أَوِ ابْنَةَ ابْنَتِكَ، وَلا تَكْشِفْ عَوْرَتَهَا لأَنَّهَا عَوْرَتُكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","لَا تَتَزَوَّجْ بِنْتَ امْرَأَةِ أَبِيكَ الْمَوْلُودَةَ مِنْ أَبِيكَ، وَلا تَكْشِفْ عَوْرَتَهَا لأَنَّهَا أُخْتُكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","لَا تَتَزَوَّجْ أُخْتَ أَبِيكَ. إِنَّهَا عَمَّتُكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","لَا تَتَزَوَّجْ أُخْتَ أُمِّكَ. إِنَّهَا خَالَتُكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","لَا تَتَزَوَّجْ فَتَاةٌ عَمَّهَا، وَلا تُعَاشِرْ زَوْجَةَ عَمِّكَ. إِنَّهَا عَمَّتُكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","لَا تَتَزَوَّجْ كَنَّتَكَ، فَإِنَّهَا امْرَأَةُ ابْنِكَ، وَلا تَكْشِفْ عَوْرَتَهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","لَا تَتَزَوَّجِ امْرَأَةَ أَخِيكَ، فَإِنَّهَا عَوْرَةُ أَخِيكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","لَا تَتَزَوَّجِ امْرَأَةً وَابْنَتَهَا، وَلا تَتَزَوَّجْ مَعَهَا ابْنَةَ ابْنِهَا أَوِ ابْنَةَ بِنْتِهَا، لأَنَّهُمَا قَرِيبَتَاهَا، وَإِنْ فَعَلْتَ تَرْتَكِبْ رَذِيلَةً. ");
INSERT INTO arbnav_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","لَا تَتَزَوَّجِ امْرَأَةً عَلَى أُخْتِهَا لِتَكُونَ ضَرَّةً مَعَهَا فِي أَثْنَاءِ حَيَاةِ زَوْجَتِكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","لَا تُعَاشِرِ امْرَأَةً وَهِيَ فِي نَجَاسَةِ حَيْضِهَا، ");
INSERT INTO arbnav_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","وَلا تُقَارِبِ امْرَأَةَ صَاحِبِكَ فَتُعَاشِرَهَا وَتَتَنَجَّسَ بِها. ");
INSERT INTO arbnav_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","لَا تُجِزْ أَحَدَ أَبْنَائِكَ فِي النَّارِ قُرْبَاناً لِلْوَثَنِ مُولَكَ، لِئَلّا تُدَنِّسَ اسْمَ إِلَهِكَ. أَنَا الرَّبُّ ");
INSERT INTO arbnav_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","لَا تُضَاجِعْ ذَكَراً مُضَاجَعَةَ امْرَأَةٍ. إِنَّهَا رَجَاسَةٌ، ");
INSERT INTO arbnav_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","وَلا تُعَاشِرْ بَهِيمَةً فَتَتَنَجَّسَ بِها، وَلا تَقِفِ امْرَأَةٌ أَمَامَ بَهِيمَةٍ ذَكَرٍ لِتُضَاجِعَهَا. إِنَّهُ فَاحِشَةٌ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","لَا تَتَنَجَّسُوا بِكُلِّ هَذِهِ الأَعْمَالِ الْمُشِينَةِ لأَنَّ بِها تَنَجَّسَتِ الشُّعُوبُ الَّتِي سَأَطْرُدُهَا مِنْ أَمَامِكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","فَقَدْ تَنَجَّسَتْ بِها الأَرْضُ، لِهَذَا سَأُعَاقِبُ الأَرْضَ بِذَنْبِهَا فَتَتَقَيَّأُ سُكَّانَهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","أَمَّا أَنْتُمْ فاحْفَظُوا فَرَائِضِي وَأَحْكَامِي، وَلا تَقْتَرِفُوا شَيْئاً مِنْ هَذِهِ الرَّجَاسَاتِ، الْمُوَاطِنُ وَالْغَرِيبُ الْمُقِيمُ فِي وَسَطِكُمْ عَلَى حَدٍّ سَوَاءٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","لأَنَّ جَمِيعَ هَذِهِ الرَّجَاسَاتِ قَدِ ارْتَكَبَهَا أَهْلُ الْبِلادِ الَّذِينَ قَبْلَكُمْ، فَتَنَجَّسَتِ الأَرْضُ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","فَلا تُنَجِّسُوا الأَرْضَ بِارْتِكَابِكُمْ إِيَّاهَا، لِئَلّا تَتَقَيَّأَكُمْ كَمَا تَقَيَّأَتِ الأُمَمَ الَّتِي قَبْلَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","بَلْ كُلُّ مَنِ اقْتَرَفَ شَيْئاً مِنْ هَذِهِ الرَّجَاسَاتِ جَمِيعِهَا تُسْتَأْصَلُ تِلْكَ النَّفْسُ الْجَانِيَةُ مِنْ بَيْنِ شَعْبِهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","فَاحْفَظُوا شَعَائِرِي لِكَيْ لَا تَرْتَكِبُوا شَيْئاً مِنَ الْمُمَارَسَاتِ الرَّجِسَةِ الَّتِي اقْتُرِفَتْ قَبْلَكُمْ، وَلا تَتَنَجَّسُوا بِها. أَنَا الرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«قُلْ لِبَنِي إِسْرَائِيلَ: كُونُوا قِدِّيسِينَ لأَنِّي أَنَا الرَّبَّ إِلَهَكُمْ قُدُّوسٌ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","لِيُوَقِّرْ كُلُّ إِنْسَانٍ أُمَّهُ وَأَبَاهُ، وَرَاعُوا سُبُوتِي. فَأَنَا الرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","وَلا تَتَحَوَّلُوا لِعِبَادَةِ الأَوْثَانِ، وَلا تَصُوغُوا لأَنْفُسِكُمْ آلِهَةً مَسْبُوكَةً، فَأَنَا الرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","وَمَتَى ذَبَحْتُمْ ذَبِيحَةَ سَلامٍ لِلرَّبِّ فَلْتَكُنْ ذَبِيحَةَ رِضًى. ");
INSERT INTO arbnav_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","تَأْكُلُونَهَا فِي الْيَوْمِ الأَوَّلِ وَالثَّانِي مِنْ تَقْرِيبِهَا، وَفِي الْيَوْمِ الثَّالِثِ تُحْرِقُونَ مَا تَبَقَّى مِنْهَا بِالنَّارِ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","أَمَّا الأَكْلُ مِنْهَا فِي الْيَوْمِ الثَّالِثِ فَذَلِكَ نَجَاسَةٌ مُنْكَرَةٌ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","وَالآكِلُ مِنْهَا يُعَاقَبُ بِذَنْبِهِ لأَنَّهُ قَدْ دَنَّسَ قُدْسَ الرَّبِّ فَتُسْتَأْصَلُ تِلْكَ النَّفْسُ مِنْ بَيْنِ شَعْبِهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","وَعِنْدَمَا تَحْصُدُ مَحْصُولَ حَقْلِكَ لَا تَحْصُدْ زَوَايَاهُ وَلا تَلْتَقِطْ مَا يَتَنَاثَرُ مِنْ حَصِيدِكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","لَا تَرْجِعْ لِتَجْمَعَ بَقَايَا عَنَاقِيدِ كَرْمِكَ، وَلا تَلْتَقِطْ مَا يَنْفَرِطُ مِنْهَا، بَلِ اتْرُكْهُ لِلْمِسْكِينِ وَلِعَابِرِي السَّبِيلِ، فَأَنَا الرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","لَا تَسْرِقْ، وَلا تَكْذِبْ، وَلا تَغْدُرْ بِصَاحِبِكَ، ");
INSERT INTO arbnav_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","لَا تَحْلِفْ بِاسْمِي كَاذِباً، فَتُدَنِّسَ اسْمَ إِلَهِكَ. فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","لَا تَظْلِمْ قَرِيبَكَ، وَلا تَسْلُبْ وَلا تُرْجِئْ دَفْعَ أُجْرَةِ أَجِيرِكَ إِلَى الْغَدِ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","لَا تَشْتُمِ الأَصَمَّ، وَلا تَضَعْ عَثْرَةً فِي طَرِيقِ الأَعْمَى، بَلِ اتَّقِ إِلَهَكَ. فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","لَا تَظْلِمُوا فِي الْقَضَاءِ، وَلا تَتَحَيَّزُوا لِمِسْكِينٍ وَلا تُحَابُوا عَظِيماً. احْكُمْ لِقَرِيبِكَ بِالْعَدْلِ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","لَا تَسْعَ فِي الْوِشَايَةِ بَيْنَ شَعْبِكَ، وَلا تَرْتَكِبْ مَا يُعَرِّضُ حَيَاةَ جَارِكَ لِلْخَطَرِ، فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","لَا تُبْغِضْ أَخَاكَ فِي قَلْبِكَ، بَلْ إِنْذَاراً تُنْذِرُهُ لِئَلّا تَكُونَ شَرِيكاً فِي ذَنْبِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","لَا تَنْتَقِمْ وَلا تَحْقِدْ عَلَى أَحَدِ أَبْنَاءِ شَعْبِكَ، وَلَكِنْ تُحِبُّ قَرِيبَكَ كَمَا تُحِبُّ نَفْسَكَ، فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","أَطِيعُوا شَرَائِعِي. لَا تُزَاوِجْ بَهَائِمَكَ مِنْ جِنْسَيْنِ، وَلا تَزْرَعْ حَقْلَكَ مِنْ صِنْفَيْنِ، وَلا تَلْبَسْ ثَوْباً مَنْسُوجاً مِنْ مَادَّتَيْنِ مُخْتَلِفَتَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","إِنْ عَاشَرَ رَجُلٌ أَمَةً مَخْطُوبَةً لِرَجُلٍ آخَرَ، وَلَمْ تَكُنْ قَدِ افْتُدِيَتْ أَوْ أُعْتِقَتْ فَلْيُؤَدَّبَا، وَلا يُقْتَلا، لأَنَّهَا لَمْ تَكُنْ مَعْتُوقَةً. ");
INSERT INTO arbnav_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","وَلْيَأْتِ الرَّجُلُ بِكَبْشٍ إِلَى الرَّبِّ ذَبِيحَةَ إِثْمٍ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، ");
INSERT INTO arbnav_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","فَيُكَفِّرُ عَنْهُ الْكَاهِنُ بِكَبْشِ الإِثْمِ أَمَامَ الرَّبِّ مِنْ أَجْلِ خَطِيئَتِهِ الَّتِي ارْتَكَبَهَا، فَيَغْفِرُ لَهُ الرَّبُّ خَطِيئَتَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","وَمَتَى دَخَلْتُمْ دِيَارَ كَنْعَانَ، وَغَرَسْتُمْ أَشْجَاراً ذَاتَ أَثْمَارٍ تُؤْكَلُ فَاحْسِبُوا مَحْصُولَ سَنَوَاتِهَا الثَّلاثِ الأُولَى مُحَرَّماً، وَتَكُونُ مَحْظُورَةً عَلَيْكُمْ فَلا تَأْكُلُوا مِنْهَا، ");
INSERT INTO arbnav_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","أَمَّا ثَمَرُ السَّنَةِ الرَّابِعَةِ فَيَكُونُ كُلُّهُ مُخَصَّصاً لِتَمْجِيدِ الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","وَفِي السَّنَةِ الْخَامِسَةِ تَأْكُلُونَ مِنْ ثَمَرِهَا، لِتَزْدَادَ لَكُمْ غَلَّتُهَا، فَأَنَا الرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","لَا تَأْكُلُوا لَحْماً بِدَمِهِ، وَلا تُمَارِسُوا الْعِرَافَةَ وَالْعِيَافَةَ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","لَا تَحْلِقُوا رُؤُوسَكُمْ حَلْقاً مُسْتَدِيراً، وَلا تُقَلِّمْ جَانِبَيْ لِحْيَتِكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","لَا تَجْرَحُوا أَجْسَامَكُمْ حُزْناً عَلَى مَيْتٍ، وَلا تَرْسِمْ وَشْماً عَلَيْهِ. فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","لَا تُدَنِّسِ ابْنَتَكَ فَتَبْذُلَهَا لِلْفُجُورِ، لِئَلّا تَزْنِيَ الأَرْضُ وَتَمْتَلِئَ بِالرَّذِيلَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","رَاعُوا شَرَائِعَ سُبُوتِي، وَأَجِلُّوا مَقْدِسِي، فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","لَا تَضِلُّوا وَرَاءَ مُسْتَحْضِرِي الأَرْوَاحِ، وَلا تَطْلُبُوا التَّوَابِعَ، فَتَتَنَجَّسُوا بِهِمْ. فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","قِفْ فِي حَضْرَةِ كِبَارِ السِّنِّ، وَوَقِّرِ الشُّيُوخَ، وَاتَّقِ إِلَهَكَ، فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","إِذَا أَقَامَ فِي أَرْضِكُمْ غَرِيبٌ فَلا تَظْلِمُوهُ، ");
INSERT INTO arbnav_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","وَلْيَكُنْ لَكُمُ الْغَرِيبُ الْمُقِيمُ عِنْدَكُمْ كَالْمُوَاطِنِ. تُحِبُّهُ كَمَا تُحِبُّ نَفْسَكَ، لأَنَّكُمْ كُنْتُمْ غُرَبَاءَ فِي أَرْضِ مِصْرَ. فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","لَا تَجُورُوا فِي الْقَضَاءِ، وَلا تَغُشُّوا فِي الْقِيَاسِ أَوِ الْوَزْنِ أَوِ الْكَيْلِ، ");
INSERT INTO arbnav_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","بَلِ اسْتَخْدِمُوا مَوَازِينَ عَادِلَةً وَعِيَارَاتٍ عَادِلَةً وَمَكَايِيلَ عَادِلَةً، فَأَنَا الرَّبُّ إِلَهُكُمُ الَّذِي أَخْرَجَكُمْ مِنْ دِيَارِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","فَاحْفَظُوا جَمِيعَ فَرَائِضِي وَأَحْكَامِي وَاعْمَلُوا بِها، فَأَنَا الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","وَكَلَّمَ الرَّبُّ مُوسَى قَائِلاً: ");
INSERT INTO arbnav_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«قُلْ لِبَنِي إِسْرَائِيلَ: أَيُّ إِنْسَانٍ مِنْهُمْ أَوْ مِنَ الْغُرَبَاءِ الْمُقِيمِينَ بَيْنَهُمْ قَرَّبَ لِلصَّنَمِ مُولَكَ أَحَدَ أَبْنَائِهِ، فَإِنَّهُ يُقْتَلُ إِذْ يَرْجُمُهُ شَعْبُ الأَرْضِ بِالْحِجَارَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","وَأَنَا أَنْقَلِبُ عَلَى ذَلِكَ الإِنْسَانِ وَأَسْتَأْصِلُهُ مِنْ بَيْنِ شَعْبِهِ، لأَنَّهُ قَرَّبَ أَحَدَ أَبْنَائِهِ لِلْوَثَنِ مُولَكَ لِيُنَجِّسَ قُدْسِي وَيُدَنِّسَ اسْمِي الْمُقَدَّسَ. ");
INSERT INTO arbnav_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","وَإِنْ تَغَاضَى شَعْبُ الأَرْضِ عَنْ ذَلِكَ الإِنْسَانِ، عِنْدَمَا قَرَّبَ لِمُولَكَ أَحَدَ أَبْنَائِهِ، فَلَمْ يَقْتُلُوهُ، ");
INSERT INTO arbnav_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","فَإِنِّي أَنْقَلِبُ عَلَى ذَلِكَ الإِنْسَانِ وَعَلَى عَشِيرَتِهِ، وَأَسْتَأْصِلُهُ مَعَ جَمِيعِ الضَّالِّينَ وَرَاءَهُ، الزَّانِينَ مَعَ الصَّنَمِ مُولَكَ مِنْ بَيْنِ شَعْبِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","وَكُلُّ نَفْسٍ غَوَتْ وَرَاءَ أَصْحَابِ الْجَانِّ وَتَعَلَّقَتْ بِالتَّوَابِعِ خِيَانَةً لِي، أَنْقَلِبُ عَلَى تِلْكَ النَّفْسِ وَأَسْتَأْصِلُهَا مِنْ بَيْنِ شَعْبِهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","فَتَقَدَّسُوا وَكُونُوا قِدِّيسِينَ، لأَنِّي أَنَا الرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","أَطِيعُوا فَرَائِضِي وَاعْمَلُوا بِها، فَأَنَا الرَّبُّ الَّذِي يُقَدِّسُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","كُلُّ مَنْ شَتَمَ أَبَاهُ أَوْ أُمَّهُ يُقْتَلُ لأَنَّهُ شَتَمَ أَبَاهُ أَوْ أُمَّهُ، لِذَلِكَ دَمُهُ عَلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","إِذَا زَنَى رَجُلٌ مَعَ امْرَأَةِ قَرِيبِهِ، فَالزَّانِي وَالزَّانِيَةُ يُقْتَلانِ. ");
INSERT INTO arbnav_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","وَإذَا عَاشَرَ رَجُلٌ زَوْجَةَ أَبِيهِ، فَكِلاهُمَا يُقْتَلانِ لأَنَّهُ كَشَفَ عَوْرَةَ أَبِيهِ، وَيَكُونُ دَمُهُمَا عَلَى رَأْسَيْهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","وَإذَا عَاشَرَ رَجُلٌ كَنَّتَهُ فَكِلاهُمَا يُقْتَلانِ، لأَنَّهُمَا قَدِ اقْتَرَفَا فَاحِشَةً، وَيَكُونُ دَمُهُمَا عَلَى رَأْسَيْهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","وَإذَا ضَاجَعَ رَجُلٌ ذَكَراً مُضَاجَعَةَ امْرَأَةٍ، فَكِلاهُمَا يُقْتَلانِ لأَنَّهُمَا ارْتَكَبَا رِجْساً. وَيَكُونُ دَمُهُمَا عَلَى رَأْسَيْهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","وَإذَا تَزَوَّجَ رَجُلٌ مِنِ امْرَأَةٍ وَأُمِّهَا، فَتِلْكَ رَذِيلَةٌ. لِيُحْرَقُوا بِالنَّارِ لِئَلّا تَفْشُوَ رَذِيلَةٌ بَيْنَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","وَإذَا عَاشَرَ رَجُلٌ بَهِيمَةً فَإِنَّهُ يُقْتَلُ، وَكَذَلِكَ الْبَهِيمَةُ تُمِيتُونَهَا أَيْضاً ");
INSERT INTO arbnav_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","وَإذَا قَارَبَتِ امْرَأَةٌ بَهِيمَةً ذَكَراً لِتَنْزُوَهَا فَأَمِتْهُمَا. كِلاهُمَا يُقْتَلانِ، وَيَكُونُ دَمُهُمَا عَلَى رَأْسَيْهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","إِذَا تَزَوَّجَ رَجُلٌ أُخْتَهُ، ابْنَةَ أَبِيهِ أَوِ ابْنَةَ أُمِّهِ، فَذَلِكَ عَارٌ، وَيَجِبُ أَنْ يُسْتَأْصَلا عَلَى مَشْهَدٍ مِنْ أَبْنَاءِ شَعْبِهِ، لأَنَّهُ قَدْ كَشَفَ عَوْرَةَ أُخْتِهِ، وَيُعَاقَبُ بِذَنْبِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","إِذَا عَاشَرَ رَجُلٌ امْرَأَةً حَائِضاً وَكَشَفَ عَوْرَتَهَا فَقَدْ عَرَّى يَنْبُوعَهَا، وَهِيَ أَيْضاً كَشَفَتْ عَنْهُ. فَيَجِبُ أَنْ يُسْتَأْصَلا كِلاهُمَا مِنْ بَيْنِ شَعْبِهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","إِذَا عَاشَرَ رَجُلٌ عَمَّتَهُ أَوْ خَالَتَهُ، يُعَاقَبُ كِلاهُمَا بِذَنْبِهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","وَإذَا عَاشَرَ رَجُلٌ زَوْجَةَ عَمِّهِ فَقَدْ كَشَفَ عَوْرَتَهَا، وَيُعَاقَبُ كِلاهُمَا بِذَنْبِهِمَا، وَيَمُوتَانِ مِنْ غَيْرِ أَنْ يُعْقِبَا نَسْلاً. ");
INSERT INTO arbnav_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","وَإذَا تَزَوَّجَ رَجُلٌ امْرَأَةَ أَخِيهِ فَذَلِكَ نَجَاسَةٌ لأَنَّهُ كَشَفَ عَوْرَةَ أَخِيهِ. كِلاهُمَا يَمُوتَانِ مِنْ غَيْرِ أَنْ يُعْقِبَا نَسْلاً. ");
INSERT INTO arbnav_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","أَطِيعُوا جَمِيعَ فَرَائِضِي وَأَحْكَامِي وَاعْمَلُوا بِها فَلا تَنْبِذَكُمُ الأَرْضُ الَّتِي أَنَا ذَاهِبٌ بِكُمْ إِلَيْهَا لِتُقِيمُوا فِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","لَا تُمَارِسُوا عَادَاتِ الأُمَمِ الَّتِي سَأَطْرُدُهَا مِنْ أَمَامِكُمْ، لأَنَّهَا ارْتَكَبَتْ كُلَّ هَذِهِ الْقَبَائِحِ، فَكَرِهْتُهَا، ");
INSERT INTO arbnav_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","وَوَعَدْتُكُمْ أَنْ تَرِثُوا دِيَارَهَا. وَأَنَا أَهَبُكُمْ إِيَّاهَا لِتَمْتَلِكُوهَا، أَرْضاً تَفِيضُ لَبَناً وَعَسَلاً. فَأَنَا الرَّبُّ إِلَهُكُمْ، مَيَّزْتُكُمْ عَنْ بَقِيَّةِ الشُّعُوبِ. ");
INSERT INTO arbnav_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","مَيِّزُوا الْبَهَائِمَ الطَّاهِرَةَ مِنَ النَّجِسَةِ، وَالطُّيُورَ النَّجِسَةَ مِنَ الطَّاهِرَةِ، فَلا تُدَنِّسُوا أَنْفُسَكُمْ بِالْبَهَائِمِ وَالطُّيُورِ وَالزَّوَاحِفِ الَّتِي حَظَرْتُهَا عَلَيْكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","وَكُونُوا قِدِّيسِينَ لأَنِّي أَنَا قُدُّوسٌ، وَقَدْ أَفْرَزْتُكُمْ مِنْ بَيْنِ الشُّعُوبِ لِتَكُونُوا خَاصَّتِي. ");
INSERT INTO arbnav_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","أَيُّ رَجُلٍ أَوِ امْرَأَةٍ يُمَارِسُ الْوَسَاطَةَ مَعَ الْجَانِّ أَوْ مُنَاجَاةَ الأَرْوَاحِ، ارْجُمُوهُ وَيَكُونُ دَمُهُ عَلَى رَأْسِهِ». ");
INSERT INTO arbnav_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","وَقَالَ الرَّبُّ لِمُوسَى: «أَوْصِ الْكَهَنَةَ أَبْنَاءَ هَرُونَ أَلّا يُنَجِّسَ أَحَدٌ مِنْهُمْ نَفْسَهُ بِلَمْسِ جُثَّةِ مَيْتٍ مِنْ قَوْمِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","إِلّا إِذَا كَانَ الْمَيْتُ أَقْرَبَ أَقْرِبَائِهِ إِلَيْهِ: أُمَّهُ وَأَبَاهُ وَابْنَهُ وَابْنَتَهُ وَأَخَاهُ، ");
INSERT INTO arbnav_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","وَأُخْتَهُ الْعَذْرَاءَ الَّتِي لَمْ تَتَزَوَّجْ، الْمُقِيمَةَ عَلَى مَقْرُبَةٍ مِنْهُ، فَمِنْ أَجْلِهَا يَتَنَجَّسُ، ");
INSERT INTO arbnav_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","لأَنَّ الْكَاهِنَ هُوَ رَئِيسٌ فِي قَوْمِهِ، وَعَلَيْهِ أَلّا يُنَجِّسَ نَفْسَهُ شَعَائِرِيًّا كَغَيْرِهِ مِنَ النَّاسِ الْعَادِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","وَلا يَحْلِقَ الْكَاهِنُ شَعْرَهُ قَرْعَةً، أَوْ جَانِبَيْ لِحْيَتِهِ، أَوْ يَجْرَحَ جَسَدَهُ حُزْناً عَلَى مَيْتٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","وَعَلَى الْكَهَنَةِ أَنْ يَكُونُوا مَفْرُوزِينَ لإِلَهِهِمْ. لَا يُدَنِّسُوا اسْمَهُ لأَنَّهُمْ يُقَرِّبُونَ وَقَائِدَ الرَّبِّ كَأَنَّهَا طَعَامٌ يُقَدِّمُونَهُ لإِلَهِهِمْ فَيَكُونُ مُقَدَّساً. ");
INSERT INTO arbnav_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","وَلا يَتَزَوَّجُوا امْرَأَةً زَانِيَةً أَوْ مِنْ غَيْرِ سِبْطِهِمْ، أَوِ امْرَأَةً مُطَلَّقَةً مِنْ زَوْجِهَا، لأَنَّهُمْ مُقَدَّسُونَ لإِلَهِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","لأَنَّ الْكَاهِنَ مُفْرَزٌ لِيُقَدِّمَ ذَبَائِحَ لإِلَهِكَ فَهُوَ مُقَدَّسٌ عِنْدَكَ، لأَنِّي أَنَا الرَّبُّ مُقَدِّسُكُمْ، قُدُّوسٌ. ");
INSERT INTO arbnav_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","وَإذَا زَنَتِ ابْنَةُ الْكَاهِنِ فَيَجِبُ حَرْقُهَا لأَنَّهَا دَنَّسَتْ قَدَاسَةَ أَبِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","وَالْكَاهِنُ الأَعْظَمُ بَيْنَ إِخْوَتِهِ، الَّذِي سُكِبَ عَلَى رَأْسِهِ دُهْنُ الْمَسْحَةِ، وَتَكَرَّسَ لِيَرْتَدِيَ الثِّيَابَ الْمُقَدَّسَةَ، لَا يَكْشِفُ عَنْ رَأْسِهِ وَلا يَشُقُّ ثِيَابَهُ حِدَاداً عَلَى مَيْتٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","وَلْيَتَفَادَ الدُّخُولَ إِلَى مَكَانٍ فِيهِ جُثَّةُ مَيْتٍ. وَلا يُنَجِّسْ نَفْسَهُ بِلَمْسِ جُثْمَانِ مَيْتٍ، حَتَّى لَوْ كَانَ ذَلِكَ جُثْمَانَ أَبِيهِ أَوْ أُمِّهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","لَا يُفَارِقِ الْمَقْدِسَ فِي أَثْنَاءِ خِدْمَتِهِ، لِئَلّا يُدَنِّسَ مَقْدِسَ إِلَهِهِ، لأَنَّهُ قَدْ تَمَّ تَكْرِيسُهُ بِسَكْبِ دُهْنِ مَسْحَةِ إِلَهِهِ عَلَيْهِ، فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","لِيَتَزَوَّجْ مِنْ عَذْرَاءَ، ");
INSERT INTO arbnav_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","لَا مِنْ أَرْمَلَةٍ، وَلا مُطَلَّقَةٍ، وَلا زَانِيَةٍ مُدَنَّسَةٍ، بَلْ يَتَزَوَّجُ عَذْرَاءَ مِنْ سِبْطِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","فَلا يُدَنِّسُ نَسْلَهُ بَيْنَ شَعْبِهِ، لأَنِّي أَنَا الرَّبُّ الَّذِي أُقَدِّسُهُ». ");
INSERT INTO arbnav_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«قُلْ لِهَرُونَ: لَا يُقَرِّبْ رَجُلٌ مِنْ نَسْلِكَ فِيهِ عَاهَةٌ ذَبَائِحَ لإِلَهِهِ عَلَى مَدَى أَجْيَالِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","فَكُلُّ رَجُلٍ مُصَابٍ بِعَاهَةٍ لَا يَتَقَدَّمْ سَوَاءٌ أَكَانَ أَعْمَى أَمْ أَعْرَجَ أَمْ مُشَوَّهَ الْوَجْهِ أَمْ فِيهِ عُضْوٌ زَائِدٌ، ");
INSERT INTO arbnav_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","وَلا مَكْسُورَ الْيَدِ أَوِ الرِّجْلِ، ");
INSERT INTO arbnav_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","وَلا أَحْدَبَ وَلا قَزْمَ، أَوْ مَنْ فِي عَيْنِهِ بَيَاضٌ، وَلا الأَجْرَبَ وَلا الأَكْلَفَ وَلا مَرْضُوضَ الْخِصْيَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","يُحَظَرُ عَلَى كُلِّ رَجُلٍ فِيهِ عَاهَةٌ مِنْ نَسْلِ هرُونَ الْكَاهِنِ أَنْ يَتَقَدَّمَ لِيُقَرِّبَ ذَبَائِحَ الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","وَلَكِنَّهُ يَأْكُلُ مِنْ ذَبَائِحِ إِلَهِهِ، الْمُقَدَّمَةِ فِي قُدْسِ الأَقْدَاسِ وَالْقُدْسِ. ");
INSERT INTO arbnav_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","غَيْرَ أَنَّهُ لَا يَدْخُلُ إِلَى مَا وَرَاءِ الحِجَابِ، وَلا يَقْتَرِبُ مِنَ الْمَذْبَحِ، لأَنَّ فِيهِ عَيْباً، لِئَلّا يُدَنِّسَ مَقْدِسِي، لأَنَّنِي أَنَا الرَّبُّ الَّذِي أُقَدِّسُهُمْ». ");
INSERT INTO arbnav_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","وَهَكَذَا أَبْلَغَ مُوسَى هَذِهِ الْوَصَايَا لِهَرُونَ وَأَبْنَائِهِ وَسَائِرِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«قُلْ لِهَرُونَ وَأَبْنَائِهِ أَلّا يَنْتَهِكُوا تَقْدِمَاتِ بَنِي إِسْرَائِيلَ الَّتِي يُقَدِّسُونَهَا، وَلا يُدَنِّسُوا اسْمِي الْقُدُّوسَ. فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","قُلْ لَهُمْ: إِيَّاكُمْ عَلَى مَدَى أَجْيَالِكُمْ أَنْ يَقْتَرِبَ كَاهِنٌ إِلَى التَّقْدِمَاتِ الَّتِي يُقَدِّسُهَا بَنُو إِسْرَائِيلَ وَهُوَ غَيْرُ طَاهِرٍ، فَإِنَّ تِلْكَ النَّفْسَ تُسْتَأْصَلُ مِنْ أَمَامِي، فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","أَيُّ كَاهِنٍ مِنْ نَسْلِ هَرُونَ مُصَابٌ بِالْبَرَصِ أَوِ السَّيَلانِ، لَا يَأْكُلْ مِنَ الذَّبَائِحِ الْمُقَدَّسَةِ حَتَّى يَطْهُرَ، وَكَذَلِكَ كُلُّ مَنْ لَمَسَ شَيْئاً تَنَجَّسَ بِجُثَّةِ مَيْتٍ، أَوْ شَخْصاً حَدَثَ مِنْهُ قَذْفٌ مَنَوِيٌّ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","أَيُّ كَاهِنٍ لَمَسَ حَيَوَاناً أَوْ إِنْسَاناً غَيْرَ طَاهِرٍ لِنَجَاسَةٍ فِيهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","فَاللّامِسُ يَكُونُ نَجِساً إِلَى الْمَسَاءِ، وَلا يَأْكُلُ مِنَ الذَّبَائِحِ الْمُقَدَّسَةِ، بَلْ يَسْتَحِمُّ بِمَاءٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","وَلَكِنْ مَتَى غَرَبَتِ الشَّمْسُ يُصْبِحُ طَاهِراً، ثُمَّ يَأْكُلُ مِنَ الذَّبَائِحِ الْمُقَدَّسَةِ، لأَنَّهَا طَعَامُهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","لَا يَأْكُلْ مِنْ جِيفَةِ حَيَوَانٍ أَوْ فَرِيسَةٍ فَيَتَنَجَّسَ بِها. فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","أَطِيعُوا شَعَائِرِي لِئَلَّا تَحْمِلُوا خَطِيئَتَهَا وَتَمُوتُوا بِسَبَبِهَا لأَنَّكُمْ دَنَّسْتُمُوهَا، فَأَنَا الرَّبُّ الَّذِي أُقَدِّسُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","يُحَظَرُ عَلَى غَيْرِ أُسْرَةِ الْكَاهِنِ أَنْ يَأْكُلُوا مِنَ الذَّبَائِحِ الْمُقَدَّسَةِ، سَوَاءٌ أَكَانَ ضَيْفَ الْكَاهِنِ أَمْ أَجِيرَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","لَكِنْ إِذَا اشْتَرَى الْكَاهِنُ عَبْداً بِفِضَّةٍ، أَوْ وُلِدَ فِي بَيْتِهِ عَبْدٌ، فَإِنَّ ذَلِكَ الْعَبْدَ يَأْكُلُ مِنْ طَعَامِ الْكَاهِنِ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","وَإذَا تَزَوَّجَتِ ابْنَةُ الْكَاهِنِ مِنْ غَيْرِ كَاهِنٍ، فَإِنَّهَا لَا تَأْكُلُ مِنَ التَّقْدِمَاتِ الْمُقَدَّسَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","أَمَّا إِذَا أَصْبَحَتْ أَرْمَلَةً، أَوْ مُطَلَّقَةً مِنْ غَيْرِ عَائِلٍ مِنْ نَسْلِهَا، وَرَجَعَتْ إِلَى بَيْتِ أَبِيهَا كَمَا فِي أَيَّامِ صِبَاهَا، فَإِنَّهَا تَأْكُلُ مِنْ طَعَامِ أَبِيهَا. إِنَّمَا الْغَرِيبُ لَا يَأْكُلُ مِنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","وَإذَا أَكَلَ أَحَدٌ مِنَ الذَّبَائِحِ الْمُقَدَّسَةِ سَهْواً، وَلَمْ يَكُنْ مِنْ نَسْلِ هَرُونَ، يَرُدُّ لِلْكَاهِنِ قِيمَةَ مَا أَكَلَهُ مِنَ الذَّبِيحَةِ، مُضَافاً إِلَيْهِ خُمْسُهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","عَلَى الْكَهَنَةِ أَلّا يُدَنِّسُوا الذَّبَائِحَ الَّتِي يُحْضِرُهَا بَنُو إِسْرَائِيلَ لِلرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","لأَنَّهُمْ بِذَلِكَ يُحَمِّلُونَ الآكِلِينَ مِنَ الذَّبَائِحِ الْمُقَدَّسَةِ ذُنُوباً تَسْتَوْجِبُ الْعِقَابَ، لأَنِّي أَنَا الرَّبُّ الَّذِي أُقَدِّسُهَا». ");
INSERT INTO arbnav_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«قُلْ لِهَرُونَ وَأَبْنَائِهِ وَسَائِرِ إِسْرَائِيلَ: كُلُّ إِسْرَائِيلِيٍّ، أَوْ مِنَ الْغُرَبَاءِ الْمُقِيمِينَ فِي إِسْرَائِيلَ يُقَدِّمُ قُرْبَاناً، سَوَاءٌ كَانَ وَفَاءً لِنَذْرٍ، أَمْ تَقْدِمَةً طَوْعِيَّةً يُقَرِّبُونَهَا مُحْرَقَةً لِلرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","تَكُونُ مُحْرَقَةً لِلرِّضَى عَنْكُمْ، ثَوْراً أَوْ كَبْشاً أَوْ تَيْساً سَلِيماً. ");
INSERT INTO arbnav_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","لَا تُقَرِّبُوا تَقْدِمَةً فِيهَا عَيْبٌ، لأَنَّهَا لَنْ تَكُونَ مَقْبُولَةً لِلرِّضَى عَنْكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","وَإذَا أَصْعَدَ أَحَدُكُمْ ذَبِيحَةَ سَلامٍ لِلرَّبِّ، وَفَاءً لِنَذْرٍ، أَوْ ذَبِيحَةً طَوْعِيَّةً، فَلْتَكُنْ مِنَ الْبَقَرِ أَوِ الْغَنَمِ، سَلِيمَةً خَالِيَةً مِنْ كُلِّ عَيْبٍ لِيَرْضَى الرَّبُّ عَنْكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","لَا تُقَرِّبُوا لِلرَّبِّ مِنَ الذَّبَائِحِ مَا هُوَ أَعْمَى أَوْ مَكْسُورٌ أَوْ مَجْرُوحٌ أَوْ بِهِ بُثُورٌ أَوْ أَجْرَبُ أَوْ أَكْلَفُ، وَلا تَجْعَلُوا مِنْهَا وَقُوداً عَلَى الْمَذْبَحِ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","أَمَّا الثَّوْرُ أَوِ الْحَمَلُ الَّذِي فِيهِ عُضْوٌ زَائِدٌ أَوْ نَاقِصٌ، فَلَكَ أَنْ تُقَرِّبَهُ تَقْدِمَةً طَوْعِيَّةً، وَلَكِنْ لَيْسَ وَفَاءً لِنَذْرٍ، فَإِنَّهُ يَكُونُ مَرْفُوضاً. ");
INSERT INTO arbnav_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","لَا تُصْعِدُوا لِلرَّبِّ حَيَوَاناً ذَا خُصىً مَرْضُوضَةٍ أَوْ مَسْحُوقَةٍ أَوْ مَقْطُوعَةٍ. لَا تَفْعَلُوا هَذَا فِي أَرْضِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","لَا تَشْتَرُوا مِثْلَ هَذِهِ الْحَيَوَانَاتِ مِنْ غَرِيبٍ لِتُقَدِّمُوهَا ذَبَائِحَ لإِلَهِكُمْ، لأَنَّهُ لَنْ يَقْبَلَهَا مِنْكُمْ، لِمَا فِيهَا مِنْ تَشْوِيهٍ وَعَيْبٍ». ");
INSERT INTO arbnav_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«مَتَى وَلَدَتْ بَقَرَةٌ أَوْ شَاةٌ أَوْ عَنْزَةٌ يَمْكُثُ وَلِيدُهَا مَعَهَا سَبْعَةَ أَيَّامٍ، ثُمَّ فِي الْيَوْمِ الثَّامِنِ يَصِحُّ تَقْدِيمُهَا قُرْبَانَ وَقُودٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","لَا تَذْبَحُوا الْبَقَرَةَ أَوِ الشَّاةَ مَعَ ابْنِهَا فِي يَوْمٍ وَاحِدٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","وَمَتَى ذَبَحْتُمْ قُرْبَانَ شُكْرٍ لِلرَّبِّ، فَاذْبَحُوهْ لِلرِّضَى عَنْكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","وَكُلُوهُ فِي الْيَوْمِ عَيْنِهِ، وَلا تُبْقُوا مِنْهُ شَيْئاً إِلَى الْغَدِ، فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","أَطِيعُوا وَصَايَايَ وَاعْمَلُوا بِها، فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","وَلا تُدَنِّسُوا اسْمِي الْقُدُّوسَ، فَأَتَقَدَّسَ وَسَطَ بَنِي إِسْرَائِيلَ، فَأَنَا الرَّبُّ الَّذِي أُقَدِّسُكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","وَالَّذِي أَخْرَجَكُمْ مِنْ دِيَارِ مِصْرَ لِيَكُونَ لَكُمْ إِلَهاً. أَنَا الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ: هَذِهِ هِيَ مَوَاسِمِي وَأَعْيَادِي الَّتِي تُعْلِنُونَهَا مَحَافِلَ مُقَدَّسَةً. ");
INSERT INTO arbnav_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","سِتَّةَ أَيَّامٍ تَعْمَلُونَ، أَمَّا الْيَوْمُ السَّابِعُ فَهُوَ سَبْتُ رَاحَةٍ وَمَحْفَلٌ مُقَدَّسٌ. لَا تَقُومُوا فِيهِ بِأَيِّ عَمَلٍ، بَلْ يَكُونُ سَبْتَ رَاحَةٍ لِلرَّبِّ حَيْثُ تُقِيمُونَ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","إِلَيْكُمْ مَوَاسِمَ الرَّبِّ وَالْمَحَافِلَ الْمُقَدَّسَةَ الَّتِي تُعَيِّدُونَهَا فِي أَوْقَاتِهَا: ");
INSERT INTO arbnav_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","فِي الْيَوْمِ الرَّابِعَ عَشَرَ مِنَ الشَّهْرِ الأَوَّلِ الْعِبْرِيِّ (أَيْ شَهْرِ نِيسَانَ – أَبْرِيلَ) بَيْنَ العِشَاءَيْنِ يَكُونُ فِصْحٌ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","وَفِي الْيَوْمِ الْخَامِسِ عَشَرَ مِنْ هَذَا الشَّهْرِ يَكُونُ عِيدُ الْفَطِيرِ لِلرَّبِّ، فَتَأْكُلُونَ فَطِيراً سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","فِي الْيَوْمِ الأَوَّلِ يَكُونُ لَكُمْ مَحْفَلٌ مُقَدَّسٌ، تَتَوَقَّفُ فِيهِ جَمِيعُ الأَعْمَالِ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ثُمَّ تُقَرِّبُونَ مُحْرَقَاتٍ لِلرَّبِّ طَوَالَ سَبْعَةِ أَيَّامٍ. وَفِي الْيَوْمِ السَّابِعِ تُقِيمُونَ مَحْفَلاً مُقَدَّساً تَتَعَطَّلُ فِيهِ جَمِيعُ الأَعْمَالِ». ");
INSERT INTO arbnav_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","وَخَاطَبَ الرَّبُّ مُوسَى: «أَوْصِ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: ");
INSERT INTO arbnav_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","مَتَى دَخَلْتُمُ الأَرْضَ الَّتِي أَهَبُهَا لَكُمْ وَحَصَدْتُمْ غَلّاتِهَا، تُحْضِرُونَ أَوَّلَ حُزْمَةٍ مِنْ حَصَادِكُمْ لِلْكَاهِنِ، ");
INSERT INTO arbnav_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","فَيُرَجِّحُ الْكَاهِنُ الْحُزْمَةَ فِي الْيَوْمِ التَّالِي لِيَوْمِ السَّبْتِ أَمَامَ الرَّبِّ لِيَرْضَى عَنْكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","وَتُقَدِّمُونَ يَوْمَ تَرْجِيحِ الْحُزْمَةِ خَرُوفاً سَلِيماً مُحْرَقَةً لِلرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","مَعَ عُشْرَيْنِ (نَحْوَ خَمْسَةِ لِتْرَاتٍ) مِنْ دَقِيقٍ مَعْجُونٍ بِالزَّيْتِ وَقُوداً لِلرَّبِّ لِتَحْظَوْا بِرِضَاهُ. وَكَذَلِكَ تُقَدِّمُونَ سَكِيبَهُ رُبْعَ الْهِينِ (نَحْوَ لِتْرٍ) مِنَ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","لَا تَأْكُلُوا مِنَ الْغَلَّةِ الْجَدِيدَةِ، لَا دَقِيقاً مَخْبُوزاً وَلا فَرِيكاً وَلا سَوِيقاً إِلَى الْيَوْمِ الَّذِي تُحْضِرُونَ فِيهِ قُرْبَانَ إِلَهِكُمْ، فَتَكُونُ هَذِهِ عَلَيْكُمْ فَرِيضَةً دَائِمَةً جِيلاً بَعْدَ جِيلٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","ثُمَّ تَحْسُبُونَ سَبْعَةَ أَسَابِيعَ كَامِلَةٍ، ابْتَدَاءً مِنَ الْيَوْمِ التَّالِي لِلسَّبْتِ الَّذِي تُحْضِرُونَ فِيهِ حُزْمَةَ التَّرْجِيحِ، ");
INSERT INTO arbnav_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","فَتَحْسُبُونَ خَمْسِينَ يَوْماً إِلَى الْيَوْمِ التَّالِي لِلسَّبْتِ السَّابِعِ، ثُمَّ تُقَرِّبُونَ تَقْدِمَةً جَدِيدَةً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","فَتَأْتُونَ مِنْ مَسَاكِنِكُمْ بِخُبْزِ تَرْجِيحٍ، رَغِيفَيْنِ مِقْدَارُهُمَا عُشْرَيْنِ (نَحْوَ خَمْسَةِ لِتْرَاتٍ) مِنْ دَقِيقٍ مَخْبُوزَيْنِ بِخَمِيرٍ، فَيَكُونَانِ بَاكُورَةً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","وَتُقَدِّمُونَ مَعَ الْخُبْزِ سَبْعَةَ خِرَافٍ سَلِيمَةٍ حَوْلِيَّةٍ وَثَوْراً وَاحِداً وَكَبْشَيْنِ وَسَكِيبَ خَمْرٍ. فَتَكُونُ جَمِيعُهَا مُحْرَقَةً وَوَقُودَ رِضًى وَسُرُورٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","وَتُقَرِّبُونَ تَيْساً وَاحِداً مِنَ الْمَعَزِ ذَبِيحَةَ خَطِيئَةٍ وَخَرُوفَيْنِ حَوْلِيَّيْنِ ذَبِيحَةَ سَلامٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","فَيُرَجِّحُهَا الْكَاهِنُ أَمَامَ الرَّبِّ مَعَ خُبْزِ الْبَاكُورَةِ وَالْخَرُوفَيْنِ، فَتَكُونُ مُقَدَّسَةً لِلرَّبِّ نَصِيباً لِلْكَاهِنِ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","وَتُخَصِّصُونَ ذَلِكَ الْيَوْمَ عَيْنَهُ لِيَكُونَ مَحْفَلاً مُقَدَّساً لَكُمْ، تَتَعَطَّلُ فِيهِ جَمِيعُ الأَعْمَالِ، فَتَكُونُ عَلَيْكُمْ فَرِيضَةً دَائِمَةً حَيْثُ تُقِيمُونَ جِيلاً بَعْدَ جِيلٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","وَعِنْدَمَا تَسْتَوْفُونَ حَصَادَ غَلّاتِكُمْ، اتْرُكُوا زَوَايَا حُقُولِكُمْ غَيْرَ مَحْصُودَةٍ، وَلا تَلْتَقِطُوا مَا يَقَعُ مِنْهَا عَلَى الأَرْضِ، بَلِ اتْرُكُوهْ لِلْمِسْكِينِ وَعَابِرِ السَّبِيلِ. فَأَنَا الرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«أَوْصِ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: يَكُونُ لَكُمُ الْيَوْمُ الأَوَّلُ مِنَ الشَّهْرِ السَّابِعِ (أَيْ شَهْرِ أَيْلُولَ – سِبْتَمْبَر) يَوْمَ عُطْلَةٍ فِيهِ تَحْتَفِلُونَ احْتِفَالاً مُقَدَّساً، تَنْفُخُونَ فِيهِ بِالأَبْوَاقِ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","تَتَوَقَّفُونَ فِيهِ عَنْ أَعْمَالِكُمْ وَتُصْعِدُونَ تَقْدِمَاتِ مُحْرَقَاتٍ لِلرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«وَيَكُونُ الْيَوْمُ الْعَاشِرُ مِنْ هَذَا الشَّهْرِ السَّابِعِ يَوْمَ كَفَّارَةٍ، تَحْتَفِلُونَ فِيهِ احْتِفَالاً مُقَدَّساً، وَتُذَلِّلُونَ نُفُوسَكُمْ، وَتُقَرِّبُونَ مُحْرَقَاتٍ لِلرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","وَتَتَوَقَّفُونَ فِيهِ أَيْضاً عَنْ أَعْمَالِكُمْ، لأَنَّهُ يَوْمُ كَفَّارَةٍ لِلتَّكْفِيرِ عَنْكُمْ أَمَامَ الرَّبِّ إِلَهِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","وَكُلُّ نَفْسٍ لَا تَتَذَلَّلُ فِي هَذَا الْيَوْمِ تُسْتَأْصَلُ مِنْ بَيْنِ شَعْبِهَا ");
INSERT INTO arbnav_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","وَأُبِيدُ كُلَّ مَنْ لَا يَتَوَقَّفُ عَنْ عَمَلِهِ فِي هَذَا الْيَوْمِ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","إِيَّاكُمُ والْقِيَامَ بِعَمَلٍ مَا. إِنَّهَا فَرِيضَةٌ دَائِمَةٌ عَلَيْكُمْ جِيلاً بَعْدَ جِيلٍ حَيْثُ تُقِيمُونَ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","إِنَّهُ سَبْتُ رَاحَةٍ لَكُمْ تَتَذَلَّلُونَ فِيهِ، فَتَسْتَرِيحُونَ مِنْ مَسَاءِ الْيَوْمِ التَّاسِعِ حَتَّى مَسَاءِ الْيَوْمِ التَّالِي». ");
INSERT INTO arbnav_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«أَوْصِ بَنِي إِسْرَائِيلَ أَنْ يَحْتَفِلُوا بِعِيدِ الْخِيَامِ فِي الْيَوْمِ الْخَامِسَ عَشَرَ مِنَ الشَّهْرِ السَّابِعِ. يَحْتَفِلُونَ لِلرَّبِّ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","تَجْتَمِعُونَ فِي الْيَوْمِ الأَوَّلِ فِي مَحْفَلٍ مُقَدَّسٍ، تَتَوَقَّفُ فِيهِ جَمِيعُ الأَعْمَالِ، ");
INSERT INTO arbnav_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ثُمَّ تُثَابِرُونَ عَلَى تَقْرِيبِ مُحْرَقَاتٍ لِلرَّبِّ طَوَالَ سَبْعَةِ أَيَّامٍ. وَفِي الْيَوْمِ الثَّامِنِ تَجْتَمِعُونَ لاِحْتِفَالٍ مُقَدَّسٍ تُقَدِّمُونَ فِيهِ مُحْرَقَاتٍ لِلرَّبِّ، وَتَعْتَكِفُونَ لِلْعِبَادَةِ. وَفِي هَذَا الْيَوْمِ تَتَوَقَّفُ أَيْضاً جَمِيعُ الأَعْمَالِ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","هَذِهِ هِيَ أَعْيَادُ الرَّبِّ الَّتِي تَحْتَفِلُونَ فِيهَا احْتِفَالاً مُقَدَّساً لِتَقْرِيبِ مُحْرَقَاتٍ لِلرَّبِّ، مُحْرَقَةً وَتَقْدِمَةً وَذَبِيحَةً وَخَمْراً لِلرَّبِّ، كُلَّ يَوْمٍ بِيَوْمِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","فَتَكُونُ هَذِهِ الْمُحْرَقَاتُ عَلاوَةً عَلَى تَقْدِمَاتِ سُبُوتِ الرَّبِّ، وَعَلاوَةً عَلَى عَطَايَاكُمْ وَجَمِيعِ نُذُورِكُمْ وِتِبِرُّعَاتِكُمْ الَّتِي تُقَدِّمُونَهَا لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","وَتُعَيِّدُونَ فِي الْيَوْمِ الْخَامِسَ عَشَرَ مِنَ الشَّهْرِ السَّابِعِ عِيداً لِلرَّبِّ، لأَنَّ فِيهِ تَجْمَعُونَ غَلَّةَ أَرْضِكُمْ. تُعَيِّدُونَ لِلرَّبِّ سَبْعَةَ أَيَّامٍ، فَيَكُونُ الْيَوْمُ الثَّامِنُ عُطْلَةً. ");
INSERT INTO arbnav_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","فِي الْيَوْمِ الأَوَّلِ تَجْمَعُونَ ثِمَارَ أَشْجَارٍ نَضِرَةٍ وَسَعَفَ نَخْلٍ وَأَغْصَانَ أَشْجَارٍ كَثِيفَةِ الْوَرَقِ، وَأَغْصَانَ صَفْصَافٍ نَهْرِيٍّ، وَتَفْرَحُونَ أَمَامَ الرَّبِّ إِلَهِكُمْ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","سَبْعَةَ أَيَّامٍ فِي السَّنَةِ مِنَ الشَّهْرِ السَّابِعِ تَحْتَفِلُونَ بِهِ عِيداً لِلرَّبِّ. وَيَكُونُ هَذَا فَرِيضَةً دَائِمَةً عَلَيْكُمْ جِيلاً بَعْدَ جِيلٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","فَيُقِيمُ كُلُّ أَبْنَاءِ أَرْضِ إِسْرَائِيلَ فِي خِيَامٍ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","لِكَيْ تَتَذَكَّرَ أَجْيَالُكُمْ أَنَّنِي أَسْكَنْتُ أَبْنَاءَ إِسْرَائِيلَ فِي خِيَامٍ عِنْدَمَا أَخْرَجْتُهُمْ مِنْ أَرْضِ مِصْرَ. فَأَنَا الرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","وَهَكَذَا أَبْلَغَ مُوسَى بَنِي إِسْرَائِيلَ بِأَعْيَادِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ أَنْ يُحْضِرُوا لَكَ زَيْتَ زَيْتُونٍ مَرْضُوضٍ نَقِيًّا لإِنَارَةِ السُّرُجِ الدَّائِمَةِ، ");
INSERT INTO arbnav_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","الْقَائِمَةِ خَارِجَ حِجَابِ الشَّهَادَةِ فِي خَيْمَةِ الاجْتِمَاعِ، فَيَقُومُ هَرُونُ بِالإِشْرَافِ عَلَى إِنَارَتِهَا أَمَامَ الرَّبِّ مِنَ الْمَسَاءِ إِلَى الصَّبَاحِ، فَتَكُونُ فَرِيضَةً أَبَدِيَّةً جِيلاً بَعْدَ جِيلٍ ");
INSERT INTO arbnav_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","إِذْ يَتَوَجَّبُ دَائِماً إِنَارَةُ السُّرُجِ الَّتِي عَلَى الْمَنَارَةِ الذَّهَبِيَّةِ النَّقِيَّةِ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","وَعَلَيْكَ أَنْ تَأْخُذَ دَقِيقاً وَتَخْبِزَهُ، صَانِعاً مِنْهُ اثْنَيْ عَشَرَ رَغِيفاً، عَلَى أَنْ يَكُونَ مِقْدَارُ كُلِّ رَغِيفٍ عُشْرَيْنِ (نَحْوَ خَمْسَةِ لِتْرَاتٍ). ");
INSERT INTO arbnav_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","وَتُرَتِّبُهَا صَفَّيْنِ، كُلُّ صَفٍّ مِنْ سِتَّةِ أَرْغِفَةٍ، عَلَى الْمَائِدَةِ الطَّاهِرَةِ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","وَتَضَعُ عَلَى كُلِّ صَفٍّ لُبَاناً، فَيَكُونُ لِلْخُبْزِ تَذْكَاراً، وَلِيَكُونَ وَقُوداً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","وَتُرَتِّبُ هَذَا الْخُبْزَ، بِانْتِظَامٍ، كُلَّ يَوْمِ سَبْتٍ أَمَامَ الرَّبِّ، مِنْ أَجْلِ بَنِي إِسْرَائِيلَ مِيثَاقاً أَبَدِيًّا. ");
INSERT INTO arbnav_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","وَيَكُونُ هَذَا الْخُبْزُ مِنْ نَصِيبِ هَرُونَ وَأَبْنَائِهِ، فَيَأْكُلُونَهُ فِي مَكَانٍ مُقَدَّسٍ، لأَنَّهُ قُدْسُ أَقْدَاسٍ لَهُ مِنْ مُحْرَقَاتِ الرَّبِّ، فَرِيضَةً دَائِمَةً». ");
INSERT INTO arbnav_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","وَحَدَثَ أَنْ خَرَجَ ابْنُ امْرَأَةٍ إِسْرائِيلِيَّةٍ، أَبُوهُ رَجُلٌ مِصْرِيٌّ، وَسَطَ بَنِي إِسْرَائِيلَ وَتَخَاصَمَ فِي الْمُخَيَّمِ مَعَ رَجُلٍ إِسْرَائِيلِيٍّ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","فَجَدَّفَ ابْنُ الإِسْرَائِيلِيَّةِ، الْمَدْعُوَّةِ شَلُومِيَةَ بِنْتَ دِبْرِي، مِنْ سِبْطِ دَانٍ عَلَى اسْمِ الرَّبِّ وَسَبَّهُ، فَأَحْضَرُوهُ إِلَى مُوسَى، ");
INSERT INTO arbnav_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","وَزَجُّوهُ فِي السِّجْنِ رَيْثَمَا يُصْدِرُ الرَّبُّ حُكْمَهُ عَلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","فَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«خُذِ الشَّاتِمَ إِلَى خَارِجِ الْمُخَيَّمِ، وَاجْعَلْ جَمِيعَ الَّذِينَ سَمِعُوا تَجْدِيفَهُ يَضَعُونَ أَيْدِيَهُمْ عَلَى رَأْسِهِ، وَيَرْجُمُهُ كُلُّ الشَّعْبِ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","وَقُلْ لِبَنِي إِسْرَائِيلَ: كُلُّ مَنْ شَتَمَ إِلَهَهُ يُعَاقَبُ بِذَنْبِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","وَمَنْ جَدَّفَ عَلَى اسْمِ الرَّبِّ يُقْتَلُ، إِذْ يَرْجُمُهُ الشَّعْبُ رَجْماً، الْغَرِيبُ كَالإِسْرَائِيلِيِّ يُعَاقَبُ بِالْقَتْلِ عِنْدَ تَجْدِيفِهِ عَلَى اسْمِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","وَإذَا قَتَلَ أَحَدٌ إِنْسَاناً فَإِنَّهُ يُقْتَلُ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","وَمَنْ أَمَاتَ بَهِيمَةَ جَارِهِ يُعَوِّضُ عَنْهَا نَفْساً بِنَفْسٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","وَمَنْ أَوْقَعَ بِقَرِيبِهِ ضَرَراً فَبِمِثْلِ مَا أَوْقَعَ يُوْقَعُ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","كَسْرٌ بِكَسْرٍ وَعَيْنٌ بِعَيْنٍ وَسِنٌّ بِسِنٍّ. وَكَمَا أَنْزَلَ بِسِوَاهُ مِنْ أَذىً يُنْزَلُ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","مَنْ قَتَلَ بَهِيمَةَ جَارِهِ يُعَوِّضُ عَنْهَا، وَمَنْ قَتَلَ إِنْسَاناً يُقْتَلُ. ");
INSERT INTO arbnav_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","حُكْمٌ وَاحِدٌ يُطَبَّقُ عَلَيْكُمُ، الْغَرِيبُ كَالإِسْرَائِيلِيِّ، إِنِّي أَنَا الرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","فَأَمَرَ مُوسَى بَنِي إِسْرَائِيلَ أَنْ يُخْرِجُوا الشَّاتِمَ إِلَى خَارِجِ الْمُخَيَّمِ وَيَرْجُمُوهُ بِالْحِجَارَةِ، فَنَفَّذَ بَنُو إِسْرَائِيلَ أَمْرَ الرَّبِّ لِمُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","وَقَالَ الرَّبُّ لِمُوسَى فِي جَبَلِ سِينَاءَ: ");
INSERT INTO arbnav_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ: مَتَى جِئْتُمْ إِلَى الأَرْضِ الَّتِي أَهَبُكُمْ إِيَّاهَا، لَا تَزْرَعُوهَا فِي السَّنَةِ السَّابِعَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ازْرَعْ حَقْلَكَ سِتَّ سَنَوَاتٍ، وَقَلِّمْ كَرْمَكَ سِتَّ سَنَوَاتٍ، وَاجْمَعْ غَلَّتَهُمَا. ");
INSERT INTO arbnav_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","وَأَمَّا السَّنَةُ السَّابِعَةُ فَفِيهَا تُرِيحُ الأَرْضَ وَتُعَطِّلُهَا سَبْتاً لِلرَّبِّ. لَا تَزْرَعْ فِيهَا حَقْلَكَ وَلا تُقَلِّمْ كَرْمَكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","لَا تَحْصُدْ زَرْعَكَ الَّذِي نَمَا بِنَفْسِهِ، وَلا تَقْطِفْ عِنَبَ كَرْمِكَ الْمُحْوِلِ، بَلْ تَكُونُ سَنَةَ رَاحَةٍ لِلأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","وَمَا تُغِلُّهُ الأَرْضُ فِي سَنَةِ الرَّاحَةِ يَكُونُ طَعَاماً لَكَ وَلِعَبْدِكَ وَأَمَتِكَ وَأَجِيرِكَ وَالْمُسْتَوْطِنِ النَّازِلِ عِنْدَكَ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","وَكَذَلِكَ تَكُونُ كُلُّ غَلَّتِهَا طَعَاماً لِلْبَهَائِمِ وَلِلْحَيَوَانِ الرَّاعِي فِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","وَبَعْدَ انْقِضَاءِ تِسْعٍ وَأَرْبَعِينَ سَنَةً، أَيْ بَعْدَ سَبْعِ سُبُوتٍ مِنَ السِّنِينَ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","فِي الْيَوْمِ الْعَاشِرِ مِنَ الشَّهْرِ السَّابِعِ، مِنْ كُلِّ خَمْسِينَ سَنَةً عِبْرِيَّةً، تَنْفُخُونَ بُوقَ الْهُتَافِ فِي يَوْمِ الْكَفَّارَةِ فِي جَمِيعِ أَرْضِكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","وَتُقَدِّسُونَ السَّنَةَ الْخَمْسِينَ وَتُعْلِنُونَ فِيهَا الْعِتْقَ لِجَمِيعِ سُكَّانِهَا، فَتَكُونُ لَكُمْ يُوبِيلاً، وَتَرْجِعُونَ كُلُّ وَاحِدٍ إِلَى مُلْكِهِ وَعَشِيرَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","وَتَكُونُ لَكُمُ السَّنَةُ الْخَمْسُونَ هَذِهِ يُوبِيلاً، لَا تَزْرَعُوا فِيهَا وَلا تَحْصُدُوا غَلَّتَهَا وَلا تَقْطِفُوا كَرْمَهَا الْمُحْوِلَ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","إِنَّهَا يُوبِيلٌ، سَنَةٌ مُقَدَّسَةٌ لَكُمْ. لَا تَأْكُلُوا إِلّا مَا يُجْنَى مُبَاشَرَةً مِنَ الْحَقْلِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","وَفِي سَنَةِ الْيُوبِيلِ هَذِهِ يَرْتَدُّ كُلُّ وَاحِدٍ إِلَى مُلْكِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","فَإِنْ بِعْتَ مُوَاطِنَكَ، أَوِ اشْتَرَيْتَ مِنْهُ، فَلا تَظْلِمْهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","يَكُونُ شِرَاؤُكَ مِنْ صَاحِبِكَ وَفْقاً لِعَدَدِ السِّنِينَ بَعْدَ الْيُوبِيلِ، وَبَيْعُهُ لَكَ يَكُونُ بِنَاءً عَلَى سِنِي الْغَلَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","فَكُلَّمَا كَثُرَتِ السِّنُونَ تَزِيدُ قِيمَتُهُ، وَكُلَّمَا قَلَّتِ السِّنُونَ يَنْخَفِضُ ثَمَنُهُ، لأَنَّهُ يَبِيعُكَ بِنَاءً عَلَى عَدَدِ الْغَلّاتِ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","فَلا يَظْلِمَنَّ أَحَدٌ صَاحِبَهُ، بَلِ اتَّقِ إِلَهَكَ، لأَنِّي أَنَا الرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","فَاعْمَلُوا بِفَرَائِضِي وَرَاعُوا أَحْكَامِي وَمَارِسُوهَا، لِتَسْكُنُوا فِي الأَرْضِ آمِنِينَ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","عِنْدَئِذٍ تَغِلُّ الأَرْضُ ثَمَرَهَا، فَتَأْكُلُونَ وَتَشْبَعُونَ وَتَسْكُنُونَ عَلَيْهَا آمِنِينَ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","وَإِنْ قُلْتُمْ: مَاذَا نَأْكُلُ فِي السَّنَةِ السَّابِعَةِ إِنْ لَمْ نَزْرَعْ وَلَمْ نَجْمَعْ غَلَّتَنَا؟ ");
INSERT INTO arbnav_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","هَا أَنَا آمُرُ بِبَرَكَتِي لَكُمْ فِي السَّنَةِ السَّادِسَةِ فَتُغِلُّ لِثَلاثِ سِنِينَ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","فَتَزْرَعُونَ فِي السَّنَةِ الثَّامِنَةِ وَتَأْكُلُونَ مِنَ الْغَلَّةِ الْقَدِيمَةِ إِلَى أَنْ يَتِمَّ حَصِيدُ مَوْسِمِ السَّنَةِ التَّاسِعَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","أَمَّا الأَرْضُ فَلا تُبَاعُ مُطْلَقاً لأَنَّ لِي الأَرْضَ، وَأَنْتُمْ غُرَبَاءُ وَنُزَلاءُ عِنْدِي. ");
INSERT INTO arbnav_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","بَلْ فِي كُلِّ عَقْدِ بَيْعٍ تَضَعُونَ شَرْطَ فِكَاكٍ لِلأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","وَإذَا افْتَقَرَ مُوَاطِنُكَ وَبَاعَ بَعْضَ مُلْكِهِ فَلْيَأْتِ أَقْرَبُ أَقْرِبَائِهِ وَيَفُكَّ مَبِيعَ قَرِيبِهِ ");
INSERT INTO arbnav_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","وَمَنْ لَمْ يَكُنْ لَهُ قَرِيبٌ، وَاسْتَطَاعَ الْحُصُولَ عَلَى مِقْدَارٍ كَافٍ مِنَ الْمَالِ لِفَكِّ الْبَيْعِ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","فَلْيَحْسُبْ عَدَدَ السَّنَوَاتِ الَّتِي انْقَضَتْ عَلَى الْمَبِيعِ، وَمَا هُوَ مُتَبَقٍّ مِنْهَا حَتَّى حُلُولِ سَنَةِ الْيُوبِيلِ، فَيَدْفَعَ لِلْمُشْتَرِي مَا يُعَادِلُ غِلَالَ السَّنَوَاتِ الْمُتَبَقِّيَةِ، وَيَسْتَرِدَّ مُلْكَهُ ");
INSERT INTO arbnav_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","وَإِنْ لَمْ يَتَوَافَرْ لَدَيْهِ الْمَالُ لاِسْتِرْدَادِ مَبِيعِهِ مِنْ يَدِ الشَّارِي، فَلْيَنْتَظِرْ حَتَّى حُلُولِ سَنَةِ الْيُوبِيلِ لِيَسْتَرِدَّ مُلْكَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","وَإذَا بَاعَ إِنْسَانٌ بَيْتاً لِلسُّكْنَى فِي مَدِينَةٍ مُسَوَّرَةٍ يَحِقُّ اسْتِرْدَادُهُ فِي خِلالِ سَنَةٍ مِنْ بَيْعِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","وَإِنْ عَجَزَ عَنْ فِكَاكِهِ قَبْلَ انْقِضَاءِ سَنَةٍ، يُصْبِحُ الْبَيْتُ الَّذِي فِي الْمَدِينَةِ الْمُسَوَّرَةِ مِنْ حَقِّ شَارِيهِ وَنَسْلِهِ لَا يُرَدُّ فِي سَنَةِ الْيُوبِيلِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","أَمَّا الْبُيُوتُ الْمَبِيعَةُ فِي الْقُرَى غَيْرِ الْمُسَوَّرَةِ فَإِنَّهَا تُعَامَلُ مُعَامَلَةَ الْحُقُولِ الزِّرَاعِيَّةِ، قَابِلَةٌ لِلْفِكَاكِ وَالاسْتِرْدَادِ فِي سَنَةِ الْيُوبِيلِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","أَمَّا بُيُوتُ اللّاوِيِّينَ الْقَائِمَةُ فِي مُدُنِ اللّاوِيِّينَ الْمُسَوَّرَةِ، فَإِنَّ لِلّاوِيِّينَ حَقَّ اسْتِرْدَادِهَا دَائِماً، ");
INSERT INTO arbnav_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","فَبُيُوتُ اللّاوِيِّينَ قَابِلَةٌ لِلْفِكَاكِ وَتُسْتَرَدُّ فِي سَنَةِ الْيُوبِيلِ، لأَنَّ بُيُوتَهُمْ فِي مُدُنِ اللّاوِيِّينَ هِيَ مُلْكُهُمْ بَيْنَ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","أَمَّا الْمَزَارِعُ الْمُحِيطَةُ بِمُدُنِهِمْ فَلا تُبَاعُ، لأَنَّهَا مُلْكٌ أَبَدِيٌّ لَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","وَإذَا افْتَقَرَ أَخُوكَ وَعَجَزَ عَنْ إِعَالَةِ نَفْسِهِ فِي وَسَطِكَ، فَأَعِنْهُ، سَوَاءٌ كَانَ غَرِيباً أَوْ مُوَاطِناً، لِيَتَمَكَّنَ مِنَ الْعَيْشِ مَعَكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","اِتَّقِ إِلَهَكَ وَلا تَأْخُذْ مِنْهُ رِباً وَلا رِبْحاً، لِيَتَمَكَّنَ مِنَ الْعَيْشِ فِي وَسَطِكَ ");
INSERT INTO arbnav_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","لَا تُقْرِضْهُ فِضَّتَكَ بِرِباً، وَلا تَبِعْهُ طَعَامَكَ بِرِبْحٍ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","أَنَا الرَّبُّ إِلَهُكُمُ الَّذِي أَخْرَجَكُمْ مِنْ دِيَارِ مِصْرَ لِيَهَبَكُمْ أَرْضَ كَنْعَانَ، فَيَكُونُ لَكُمْ إِلَهاً. ");
INSERT INTO arbnav_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","وَإذَا افْتَقَرَ أَخُوكَ وَبِيعَ لَكَ عَبْداً، فَلا تُعَامِلْهُ كَعَبْدٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","بَلْ لِيَكُنْ عِنْدَكَ كَأَجِيرٍ أَوْ نَزِيلٍ، فَيَخْدُمَكَ حَتَّى حُلُولِ سَنَةِ الْيُوبِيلِ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ثُمَّ تَعْتِقُهُ هُوَ وَأَوْلادَهُ، وَيَعُودُ إِلَى قَوْمِهِ، وَيَرْجِعُ إِلَى مُلْكِ آبَائِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","لأَنَّ بَنِي إِسْرَائِيلَ عَبِيدِي الَّذِينَ أَخْرَجْتُهُمْ مِنْ مِصْرَ، لَا يُبَاعُونَ كَالْعَبِيدِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","لَا تَطْغَ بِتَسَلُّطِكَ، بَلِ اتَّقِ إِلَهَكَ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","وَلْيَكُنْ عَبِيدُكُمْ وَإِمَاؤُكُمْ مِنَ الشُّعُوبِ الَّتِي حَوْلَكُمْ، مِنْهَا تَقْتَنُونَ عَبِيداً وَإِمَاءً، ");
INSERT INTO arbnav_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","وَكَذَلِكَ مِنْ أَبْنَاءِ الْمُسْتَوْطِنِينَ النَّازِلِينَ عِنْدَكُمْ، فَمِنْهُمْ وَمِنْ عَشَائِرهِمْ، الَّذِينَ عِنْدَكُمُ الْمَوْلُودِينَ فِي أَرْضِكُمْ، تَقْتَنُونَ عَبِيداً لَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","وَتُوَرِّثُونَهُمْ لِبَنِيكُمْ مِنْ بَعْدِكُمْ مِيرَاثَ مُلْكٍ، فَيَكُونُونَ عَبِيداً لَكُمْ إِلَى الأَبَدِ. وَأَمَّا إِخْوَتُكُمْ مِنْ بَنِي إِسْرَائِيلَ فَلا تَطْغَوْا بِتَسَلُّطِكُمْ عَلَيْهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","وَإذَا اغْتَنَى غَرِيبٌ أَوْ نَزِيلٌ مُقِيمٌ فِي وَسَطِكُمْ، وَافْتَقَرَ أَخُوكَ فَبِيعَ لِلْغَرِيبِ الْمُسْتَوْطِنِ عِنْدَكَ، أَوْ لِنَسْلِ عَشِيرَتِهِ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","فَلْيَفُكَّهُ وَاحِدٌ مِنْ أَقْرِبَائِهِ بَعْدَ بَيْعِهِ، لأَنَّهُ يَمْلِكُ حَقَّ الانْعِتَاقِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","أَوْ يَفُكَّهُ عَمُّهُ أَوِ ابْنُ عَمِّهِ أَوْ أَحَدُ أَقْرِبَائِهِ مِنْ أَبْنَاءِ عَشِيرَتِهِ، أَوْ يَسْتَرِدَّ هُوَ نَفْسُهُ حُرِّيَّتَهُ إِذَا حَصَلَ عَلَى مَا يَكْفِي مِنْ مَالٍ، ");
INSERT INTO arbnav_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","فَيَتَحَاسَبُ مَعَ شَارِيهِ مُنْذُ سَنَةِ بَيْعِهِ حَتَّى سَنَةِ الْيُوبِيلِ، فَيَكُونُ ثَمَنُ عِتْقِهِ وَفْقاً لِمَا يُدْفَعُ لأَجِيرٍ، لِذَلِكَ الْعَدَدِ مِنَ السَّنَوَاتِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","وَإذَا كَانَتِ السَّنَوَاتُ الْبَاقِيَةُ حَتَّى حُلُولِ الْيُوبِيلِ كَثِيرَةً، فَعَلَيْهِ أَنْ يَدْفَعَ نِسْبَةً أَكْبَرَ مِنْ أَصْلِ الثَّمَنِ الَّذِي دُفِعَ فِي شِرَائِهِ، اِسْتِرْدَاداً لِحُرِّيَّتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","وَإِنْ كَانَتِ السَّنَوَاتُ الْبَاقِيَةُ حَتَّى سَنَةِ الْيُوبِيلِ قَلِيلَةً، فَعَلَيْهِ أَنْ يَحْسُبَ عَدَدَ السَّنَوَاتِ وَيَدْفَعَ وَفْقَهَا فِي سَبِيلِ فِكَاكِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","وَعَلَى الأَجْنَبِيِّ أَنْ يُعَامِلَهُ كَأَجِيرٍ مِنْ سَنَةٍ إِلَى سَنَةٍ، وَلا يَقْسُوَ عَلَيْهِ أَمَامَ عَيْنَيْكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","وَإِنْ لَمْ يُوْجَدْ سَبِيلٌ لِفِكَاكِهِ، فَإِنَّهُ يُعْتَقُ هُوَ وَبَنُوهُ مَعَهُ فِي سَنَةِ الْيُوبِيلِ. ");
INSERT INTO arbnav_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","لأَنَّ بَنِي إِسْرَائِيلَ لِي عَبِيدٌ. هُمْ عَبِيدِي الَّذِينَ أَخْرَجْتُهُمْ مِنْ مِصْرَ. أَنَا الرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","لَا تَصْنَعُوا لَكُمْ أَصْنَاماً، وَلا تُقِيمُوا لَكُمْ تَمَاثِيلَ مَنْحُوتَةً، أَوْ أَنْصَاباً مُقَدَّسَةً، وَلا تَرْفَعُوا حَجَراً مُصَوَّراً فِي أَرْضِكُمْ لِتَسْجُدُوا لَهُ، لأَنِّي أَنَا الرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","رَاعُوا رَاحَةَ أَيَّامِ السَّبْتِ، وَوَقِّرُوا مَقْدِسِي، فَأَنَا الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","إِنْ سَلَكْتُمْ فِي فَرَائِضِي وَأَطَعْتُمْ وَصَايَايَ وَعَمِلْتُمْ بِها، ");
INSERT INTO arbnav_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","فَإِنِّي أَسْكُبُ عَلَيْكُمُ الْمَطَرَ فِي أَوَانِهِ، وَتُعْطِي الأَرْضُ غَلَّتَهَا، وَتُثْمِرُ أَشْجَارُ الْحَقْلِ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","فَتَسْتَمِرُّ دِرَاسَةُ حِنْطَتِكُمْ حَتَّى مَوْعِدِ قِطَافِ الْعِنَبِ، وَيَسْتَمِرُّ قِطَافُ الْعِنَبِ حَتَّى مَوْسِمِ الزِّرَاعَةِ، فَتَأْكُلُونَ خُبْزَكُمْ حَتَّى الشَّبْعِ، وَتَسْكُنُونَ فِي أَرْضِكُمْ آمِنِينَ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","وَأُشِيعُ سَلاماً فِي الأَرْضِ، فَتَنَامُونَ مُطْمَئِنِّينَ، وَأُبِيدُ الْوُحُوشَ الْبَرِّيَّةَ مِنَ الأَرْضِ وَلا يَجْتَازُ سَيْفٌ فِي دِيَارِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","وَتَطْرُدُونَ أَعْدَاءَكُمْ فَيَسْقُطُونَ أَمَامَكُمْ بِالسَّيْفِ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","خَمْسَةٌ مِنْكُمْ يَطْرُدُونَ مِئَةً، وَمِئَةٌ مِنْكُمْ يَطْرُدُونَ عَشَرَةَ آلافٍ. وَيَتَسَاقَطُ أَعْدَاؤُكُمْ أَمَامَكُمْ بِحَدِّ السَّيْفِ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","وَأَرْعَاكُمْ بِعِنَايَتِي، وَأُنَمِّيكُمْ وَأُكَثِّرُكُمْ، وَأَفِي بِمِيثَاقِي مَعَكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","وَتَظَلُّونَ تَأْكُلُونَ مِنَ الْغِلالِ الْقَدِيمَةِ حِينَ تُفَرِّغُونَهَا مِنْ مَخَازِنِهَا لِتُوَسِّعُوا لِغَلّاتِ السَّنَةِ الْجَدِيدَةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","وَأُقِيمُ مَسْكَنِي فِي وَسَطِكُمْ وَلا أَخْذِلُكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","وَأَسِيرُ بَيْنَكُمْ وَأَكُونُ إِلَهَكُمْ، وَأَنْتُمْ تَكُونُونُ لِي شَعْباً. ");
INSERT INTO arbnav_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","أَنَا الرَّبُّ إِلَهُكُمْ أَخْرَجْتُكُمْ مِنْ مِصْرَ، وَحَطَّمْتُ أَغْلالَ قُيُودِكُمْ وَرَفَعْتُ شَأْنَكُمْ، لِكَيْ لَا تَظَلُّوا عَبِيداً لِلْمِصْرِيِّينَ فِي مَا بَعْدُ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","وَلَكِنْ إِنْ عَصَيْتُمُونِي وَلَمْ تَعْمَلُوا بِكُلِّ هَذِهِ الْوَصَايَا، ");
INSERT INTO arbnav_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","وَإِنْ تَنَكَّرْتُمْ لِفَرَائِضِي وَكَرِهْتُمْ أَحْكَامِي وَلَمْ تَعْمَلُوا بِكُلِّ وَصَايَايَ، بَلْ نَكَثْتُمْ مِيثَاقِي، ");
INSERT INTO arbnav_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","فَإِنِّي أَبْتَلِيكُمْ بِالرُّعْبِ الْمُفَاجِئِ وَدَاءِ السِّلِّ وَالْحُمَّى الَّتِي تُفْنِي الْعَيْنَيْنِ وَتُتْلِفُ النَّفْسَ، وَتَزْرَعُونَ عَلَى غَيْرِ طَائِلٍ، وَيَنْهَبُ أَعْدَاؤُكُمْ زَرْعَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","وَأَنْقَلِبُ عَلَيْكُمْ فَتَنْهَزِمُونَ أَمَامَ أَعْدَائِكُمْ، وَيَتَحَكَّمُ بِكُمْ مُبْغِضُوكُمْ وَتَهْرُبُونَ مِنْ غَيْرِ طَارِدٍ لَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","وَإِنْ أَمْعَنْتُمْ فِي عِصْيَانِكُمْ أَزِيدُ مِنْ عِقَابِكُمْ سَبْعَ مَرَّاتٍ وَفْقاً لِخَطَايَاكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","أُذِلُّ غَطْرَسَتَكُمْ، وَأَجْعَلُ سَمَاءَكُمْ كَالْحَدِيدِ لَا تُمْطِرُ وَأَرْضَكُمْ كَالنُّحَاسِ لَا تُغِلُّ ");
INSERT INTO arbnav_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","فَيَذْهَبُ جَهْدُكُمْ بَاطِلاً لأَنَّ أَرْضَكُمْ لَنْ تُعْطِيَ غَلَّتَهَا، وَأَشْجَارَ الأَرْضِ لَنْ تُعْطِيَ أَثْمَارَهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","وَإِنْ وَاظَبْتُمْ عَلَى عِصْيَانِكُمْ وَأَبَيْتُمْ طَاعَتِي، أُضَاعِفُ عِقَابِي لَكُمْ سَبْعَ مَرَّاتٍ وَفْقاً لِخَطَايَاكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","وَأُطْلِقُ عَلَيْكُمْ وُحُوشَ الصَّحْرَاءِ فَتَفْتَرِسُ أَوْلادَكُمْ وَتُهْلِكُ بَهَائِمَكُمْ، وَتُنْقِصُ مِنْ عَدَدِكُمْ، فَتُقْفِرُ طُرُقَاتُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","وَإِنْ لَمْ تَتَّعِظُوا، وَتَمَادَيْتُمْ فِي عِصْيَانِكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","أَنْقَلِبُ عَلَيْكُمْ وَأَزِيدُ فِي بَلائِكُمْ سَبْعَ مَرَّاتٍ وَفْقاً لِخَطَايَاكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","أُسَلِّطُ عَلَيْكُمْ سَيْفَ الْعَدُوِّ. فَيَنْتَقِمُ مِنْكُمْ لِنَقْضِكُمْ مِيثَاقِي، فَتَحْتَمُونَ بِمُدُنِكُمْ حَيْثُ أُرْسِلُ عَلَيْكُمُ الْوَبَاءَ وَتُسَلَّمُونَ إِلَى يَدِ الْعَدُوِّ ");
INSERT INTO arbnav_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","وَحِينَ أَقْطَعُ عَنْكُمْ مَؤُونَةَ الدَّقِيقِ، تَخْبِزُ عَشْرُ نِسَاءٍ خُبْزَكُمْ فِي فُرْنٍ وَاحِدٍ لِقِلَّةِ الدَّقِيقِ، وَتَقْسِمُونَ الْخُبْزَ بِالْمِيزَانِ فَتَأْكُلُونَ وَلا تَشْبَعُونَ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","وَإِنْ لَمْ يُجْدِ هَذَا الْعِقَابُ فِي تَأْدِيبِكُمْ، فَتَمَادَيْتُمْ فِي عِصْيَانِكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","فَإِنِّي أَزِيدُ فِي احْتِدَامِ غَضَبِي، مِنْ عَدَائِي لَكُمْ وَأُضَاعِفُ عِقَابِي سَبْعَ مَرَّاتٍ أُخْرَى وَفْقاً لِخَطَايَاكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","فَتَأْكُلُونَ لَحْمَ أَبْنَائِكُمْ وبَنَاتِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","وَأَهْدِمُ مَذَابِحَ مُرْتَفَعَاتِكُمْ، وَأُحَطِّمُ أَصْنَامَ شَمُوسِكُمْ وَأُكَوِّمُ جُثَثَكُمْ فَوْقَ بَقَايَا أَصْنَامِكُمْ، وَتَنْبِذُكُمْ نَفْسِي. ");
INSERT INTO arbnav_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","وَأُحَوِّلُ مُدُنَكُمْ إِلَى خَرَائِبَ، وَأَجْعَلُ مَقَادِسَكُمْ مُوْحِشَةً، وَلا أَبْتَهِجُ بِرَائِحَةِ تَقْدِمَاتِ سُرُورِكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","وَأَجْعَلُ الأَرْضَ قَفْراً فَيَرْتَاعُ مِنْ وَحْشَتِهَا أَعْدَاؤُكُمُ السَّاكِنُونَ فِيهَا ");
INSERT INTO arbnav_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","وَأُشَتِّتُكُمْ بَيْنَ الشُّعُوبِ، وَأُجَرِّدُ عَلَيْكُمْ سَيْفِي، وَأُلاحِقُكُمْ، وَأُحَوِّلُ أَرْضَكُمْ إِلَى قَفْرٍ وَمُدُنَكُمْ إِلَى خَرَائِبَ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","عِنْدَئِذٍ تَسْتَوْفِي الأَرْضُ رَاحَةَ سُبُوتِهَا طَوَالَ سِنِي وَحْشَتِهَا وَأَنْتُمْ مُشَتَّتُونَ فِي دِيَارِ أَعْدَائِكُمْ. حِينَئِذٍ تَرْتَاحُ الأَرْضُ وَتَسْتَوْفِي سِنِي سُبُوتِهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","فَتُعَوِّضُ فِي أَيَّامِ وَحْشَتِهَا عَنْ رَاحَتِهَا الَّتِي لَمْ تَنْعَمْ بِها فِي سَنَوَاتِ سُبُوتِكُمْ عِنْدَمَا كُنْتُمْ تُقِيمُونَ عَلَيْهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","أَمَّا الْبَاقُونَ مِنْكُمْ فِي أَرْضِ أَعْدَائِكُمْ، فَإِنِّي أُلْقِي الرُّعْبَ فِي قُلُوبِهِمْ فَيَهْرُبُونَ مِنْ حَفِيفِ وَرَقَةٍ تَسُوقُهَا الرِّيحُ، وَكَأَنَّهُمْ يَهْرُبُونَ مِنَ السَّيْفِ، وَيَسْقُطُونَ وَلَيْسَ ثَمَّةَ مِنْ طَارِدٍ لَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","وَيَعْثُرُ بَعْضُهُمْ بِبَعْضٍ كَمَنْ يَفِرُّ مِنْ أَمَامِ سَيْفٍ مِنْ غَيْرِ طَارِدٍ لَهُمْ، وَلا تَثْبُتُونَ أَمَامَ أَعْدَائِكُمْ ");
INSERT INTO arbnav_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","فَتَهْلِكُونَ بَيْنَ الشُّعُوبِ، وَتَبْتَلِعُكُمْ أَرْضُ أَعْدَائِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","أَمَّا بَقِيَّتُكُمْ فَتَفْنَى بِذُنُوبِهَا وَذُنُوبِ آبَائِهَا فِي أَرْضِ أَعْدَائِكُمْ كَمَا فَنِيَ آبَاؤُهُمْ مِنْ قَبْلِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","وَلَكِنْ إِنِ اعْتَرَفُوا بِخَطَايَاهُمْ وَخَطَايَا آبَائِهِمْ وَبِخِيَانَتِهِمْ لِي وَعَدَاوَتِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","الَّتِي جَعَلَتْنِي أَنْقَلِبُ عَلَيْهِمْ وَأَنْفِيهِمْ إِلَى أَرْضِ أَعْدَائِهِمْ، وَإِنْ خَضَعَتْ قُلُوبُهُمُ النَّجِسَةُ بَعْدَ أَنِ اسْتَوْفَوْا عِقَابَ خَطَايَاهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","فَإِنِّي أَذْكُرُ عَهْدِي مَعَ يَعْقُوبَ، وَعَهْدِي مَعَ إِسْحاقَ، وَعَهْدِي مَعَ إِبْرَاهِيمَ، وَأَذْكُرُ الأَرْضَ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","الَّتِي أَقْفَرَتْ مِنْهُمْ، فَاسْتَوْفَتْ رَاحَةَ سُبُوتِهَا فِي أَثْنَاءِ نَفْيِهِمْ عَنْهَا، وَيَكُونُونَ آنَئِذٍ قَدِ اسْتَوْفَوْا عِقَابَ خَطَايَاهُمْ لأَنَّهُمْ تَنَكَّرُوا لِشَرَائِعِي وَكَرِهُوا فَرَائِضِي. ");
INSERT INTO arbnav_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","وَلَكِنْ عَلَى الرَّغْمِ مِنْ ذَلِكَ فَإِنَّنِي لَمْ أَنْبِذْهُمْ وَهُمْ فِي أَرْضِ أَعْدَائِهِمْ، وَلا كَرِهْتُهُمْ حَتَّى أُبِيدَهُمْ وَأَنْقُضَ عَهْدِي مَعَهُمْ، لأَنِّي أَنَا الرَّبُّ إِلَهُهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","بَلْ أَذْكُرُ عَهْدِي مَعَ آبَائِهِمِ الأَوَّلِينَ الَّذِينَ أَخْرَجْتُهُمْ مِنْ دِيَارِ مِصْرَ عَلَى مَشْهَدٍ مِنَ الشُّعُوبِ لأَكُونَ لَهُمْ إِلَهاً. أَنَا الرَّبَّ». ");
INSERT INTO arbnav_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","هَذِهِ هِيَ الْفَرَائِضُ وَالأَحْكَامُ وَالشَّرَائِعُ الَّتِي أَقَامَهَا الرَّبُّ بَيْنَهُ وَبَيْنَ بَنِي إِسْرَائِيلَ فِي جَبَلِ سِينَاءَ عَلَى لِسَانِ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ أَنَّهُ إِذَا نَذَرَ أَحَدٌ نَفْسَهُ أَوْ سِواهُ لِلرَّبِّ فَإِنَّ فِدَاءَ الْمَنْذُورِ يَكُونُ بِمُوجِبِ جَدْوَلِ تَقْدِيرِكَ التَّالِي حَسَبَ مَوَازِينِ الْقُدْسِ: ");
INSERT INTO arbnav_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","يُفْتَدَى كُلُّ ذَكَرٍ مِنِ ابْنِ عِشْرِينَ إِلَى ابْنِ سِتِّينَ سَنَةً بِخَمْسِينَ شَاقِلاً (نَحْوِ سِتِّ مِئةِ جِرَامٍ) مِنَ الْفِضَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","وَتُفْتَدَي كُلُّ امْرَأَةٍ مَنْذُورَةٍ بِثَلاثِينَ شَاقِلاً (نَحْوِ ثَلاثِ مِئَةٍ وَسِتِّينَ جِرَاماً) مِنَ الْفِضَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","أَمَّا إِنْ كَانَ الْمَنْذُورُ ذَكَراً مِنِ ابْنِ خَمْسِ سَنَوَاتٍ إِلَى عِشْرِينَ فَيُفْتَدَى بِعِشْرِينَ شَاقِلاً (نَحْوِ مِئَتَيْنِ وَأَرْبَعِينَ جِرَاماً) مِنَ الْفِضَّةِ. أَمَّا فِدَاءُ الأُنْثَى فَيَكُونُ عَشَرَةَ شَوَاقِلَ (نَحْوِ مِئَةٍ وَعِشْرِينَ جِرَاماً). ");
INSERT INTO arbnav_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","وَإِنْ كَانَ عُمْرُ الْمَنْذُورِ بَيْنَ شَهْرٍ وَخَمْسِ سَنَوَاتٍ فَيُفْتَدَى الذَّكَرُ بِخَمْسَةِ شَوَاقِلَ (نَحْوِ سِتِّينَ جِرَاماً) مِنَ الْفِضَّةِ، وَالأُنْثَى بِثَلاثَةِ شَوَاقِلَ (نَحْوِ سِتَّةٍ وَثَلاثِينَ جِرَاماً). ");
INSERT INTO arbnav_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","وَإِنْ كَانَ الْمَنْذُورُ ذَكَراً ابْنَ سِتِّينَ سَنَةً فَمَا فَوْقُ يُفْتَدَى بِخَمْسَةَ عَشَرَ شَاقِلاً (نَحْوِ مِئَةٍ وَثَمَانِينَ جِرَاماً)؛ أَمَّا الأُنْثَى فَتُفْتَدَى بِعَشَرَةِ شَوَاقِلَ (نَحْوِ مِئَةٍ وَعِشْرِينَ جِرَاماً). ");
INSERT INTO arbnav_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","وَإِنْ كَانَ النَّاذِرُ فَقِيراً يَعْجُزُ عَنْ دَفْعِ الْقِيمَةِ الْمُقِدَّرَةِ، يَحْضُرُ إِلَى الْكَاهِنِ فَيُقَدِّرُ فِدَاءَهُ وَفْقاً لِقُدْرَةِ النَّاذِرِ الْمَادِّيَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","وَإِنْ كَانَ الْمَنْذُورُ بَهِيمَةً مِمَّا يُقَدِّمُونَهُ قُرْبَاناً لِلرَّبِّ فَإِنَّ هَذِهِ الْبَهِيمَةَ تُصْبِحُ قُدْسَاً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","لَا يُغَيِّرُهُ النَّاذِرُ وَلا يُبَدِّلُهُ جَيِّداً بِرَدِيءٍ أَوْ رَدِيئاً بِجَيِّدٍ. وَإِنِ اسْتَبْدَلَ بَهِيمَةً بِأُخْرَى فَإِنَّهَا تَكُونُ هِيَ وَبَدِيلُهَا قُدْساً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","وَإِنْ كَانَ النَّذْرُ بَهِيمَةً نَجِسَةً، لَا يَجُوزُ تَقْرِيبُهَا لِلرَّبِّ، يُحْضِرُ النَّاذِرُ الْبَهِيمَةَ أَمَامَ الْكَاهِنِ، ");
INSERT INTO arbnav_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","فَيُقَدِّرُ قِيمَتَهَا، سَوَاءَ كَانَتْ جَيِّدَةً أَمْ رَدِيئَةً، وَحَسَبَ تَقْدِيرِ الْكَاهِنِ يَدْفَعُ النَّاذِرُ قِيمَتَهَا. ");
INSERT INTO arbnav_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","فَإِنْ فَكَّهَا فَعَلَيْهِ أَنْ يُضِيفَ خُمْسَهَا عَلَى تَقْدِيرِ الْكَاهِنِ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","وَإِنْ كَرَّسَ إِنْسَانٌ بَيْتَهُ قُدْساً لِلرَّبِّ، يُقَدِّرُ الْكَاهِنُ قِيمَتَهُ وَفْقاً لِحَالَتِهِ مِنَ الْجَوْدَةِ وَالرَّدَاءَةِ. وَحَسَبَ تَقْدِيرِ الْكَاهِنِ هَكَذَا يَكُونُ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","فَإِذَا رَغِبَ الْمُكَرِّسُ أَنْ يَفُكَّ بَيْتَهُ، يُضِيفُ عَلَى تَقْدِيرِ الْكَاهِنِ مَا يُعَادِلُ خُمْسَهُ وَيَسْتَرِدُّهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","وَإِنْ كَرَّسَ إِنْسَانٌ جُزْءاً مِنْ حَقْلٍ يَمْلِكُهُ لِلرَّبِّ، فَإِنَّ تَقْدِيرَك قِيمَتَهُ يَكُونُ عَلَى قَدْرِ مَا يُزْرَعُ فِيهِ مِنْ بِذَارٍ، فَيَكُونُ لِكُلِّ بِذَارِ حُومَرٍ (نَحْوِ مِئَتَيْنِ وَأَرْبَعِينَ لِتْراً) مِنْ بِذَارِ الشَّعِيرِ خَمْسُونَ شَاقِلاً (نَحْوِ سِتِّ مِئَةِ جِرَامٍ) مِنَ الْفِضَّةِ ");
INSERT INTO arbnav_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","فَإِنْ كَرَّسَ حَقْلَهُ فِي سَنَةِ الْيُوبِيلِ فَإِنَّهُ يَقُومُ بِدَفْعِ مَا تَمَّ تَقْدِيرُهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","وَإِنْ كَرَّسَ حَقْلَهُ بَعْدَ سَنَةِ الْيُوبِيلِ فَعَلَى الْكَاهِنِ أَنْ يُقَدِّرَ قِيمَةَ الْفِضَّةِ وَفْقاً لِعَدَدِ السِّنِينَ الْبَاقِيَةِ لِحُلُولِ سَنَةِ الْيُوبِيلِ، فَيَتِمُّ إِنْقَاصُ تَقْدِيرِكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","فَإِنْ فَكَّ الْمُكَرِّسُ الْحَقْلَ يُضِيفُ عَلَى تَقْدِيرِكَ خُمْسَهُ مِنَ الْفِضَّةِ وَيَسْتَرِدُّهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","لَكِنْ إِنْ لَمْ يَفُكَّ الْحَقْلَ، وَبَاعَهُ لإِنْسَانٍ آخَرَ فَإِنَّهُ لَا يَسْتَرِدُّهُ أَبَداً، ");
INSERT INTO arbnav_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","بَلْ يُصْبِحُ الْحَقْلُ فِي سَنَةِ الْيُوبِيلِ قُدْساً لِلرَّبِّ، وَيَكُونُ مُلْكاً لِلْكَاهِنِ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","وَإِنِ اشْتَرَى حَقْلاً وَلَمْ يَكُنْ قَدْ آل إِلَيْهِ بِالْمِيرَاثِ، وَكَرَّسَهُ لِلرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","يُقَدِّرُ الْكَاهِنُ ثَمَنَهُ حَسَبَ تَقْدِيرِكَ إِلَى سَنَةِ الْيُوبِيلِ. فَيَدْفَعُ فِي ذَلِكَ الْيَوْمِ مِقْدَارَ تَقْدِيرِكَ، قُدْساً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","وَفِي سَنَةِ الْيُوبِيلِ يُرَدُّ الْحَقْلُ إِلَى مَالِكهِ الَّذِي بَاعَهُ إِيَّاهُ، ");
INSERT INTO arbnav_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","أَمَّا تَقْدِيرُكَ فَيَكُونُ قَائِماً عَلَى شَاقِلِ الْمَقْدِسِ، فَكُلُّ عِشْرِينَ جِيرَةً تُعَادِلُ شَاقِلاً، (أَيِ اثْنَيْ عَشَرَ جِرَاماً) مِنَ الْفِضَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","لَا يُقَدِّسْ أَحَدٌ بِكْراً مِنَ الْبَهَائِمِ فَإِنَّهُ يُفْرَزُ لِلرَّبِّ، سَوَاءَ كَانَ ثَوْراً أَمْ شَاةً فَهُوَ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","أَمَّا إِنْ كَانَ مِنَ الْبَهَائِمِ النَّجِسَةِ، فَعَلَى صَاحِبِهِ أَنْ يَفْدِيَهُ حَسَبَ تَقْدِيرِكَ، وَيُضِيفَ عَلَى ذَلِكَ خُمْسَهُ وَإِنْ لَمْ يَفْدِهِ يُبَاعُ وَفْقاً لِتَقْدِيرِكَ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","لَكِنْ كُلُّ مَا يُوْقِفُهُ إِنْسَانٌ لِلرَّبِّ مِمَّا يَمْلِكُهُ مِنَ النَّاسِ وَالْبَهَائِمِ وَالْحُقُولِ الْمَوْرُوثَةِ فَلا يُبَاعُ وَلا يُفْتَدَى، لأَنَّ كُلَّ وَقْفٍ هُوَ قُدْسُ أَقْدَاسٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","كُلُّ مَا يَصْدُرُ الأَمْرُ بِتَحْرِيمِهِ مِنَ النَّاسِ لَا يُفْدَى بَلْ يُقْتَلُ حَتْماً. ");
INSERT INTO arbnav_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","كُلُّ عُشُورِ غَلّاتِ الأَرْضِ مِنَ الْحُبُوبِ وَأَثْمَارِ الشَّجَرِ هُوَ لِلرَّبِّ وَقُدْسٌ لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","وَإِنْ فَكَّ إِنْسَانٌ بَعْضَ عُشْرِهِ يُضِيفُ عَلَيْهِ خُمْسَ ثَمَنِهِ. ");
INSERT INTO arbnav_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","أَمَّا كُلُّ عُشْرِ الْبَقَرِ وَالْغَنَمِ فَيَكُونُ الْعَاشِرُ مِنْهَا قُدْساً لِلرَّبِّ وَفْقاً لإِحْصَاءِ الرَّاعِي ");
INSERT INTO arbnav_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","لَا فَرْقَ إِنْ كَانَ جَيِّداً أَوْ رَدِيًّا، وَلا يَجْرِي تَبْدِيلُهُ؛ وَإِنْ أُبْدِلَ يَكُونُ هُوَ وَبَدِيلُهُ قُدْساً لَا يُفْتَدَى». ");
INSERT INTO arbnav_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","هَذِهِ هِيَ الْوَصَايَا الَّتِي أَمَرَ الرَّبُّ مُوسَى أَنْ يُبَلِّغَهَا لِبَنِي إِسْرَائِيلَ فِي جَبَلِ سِينَاءَ.");
INSERT INTO arbnav_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","فِي الْيَوْمِ الأَوَّلِ مِنَ الشَّهْرِ الثَّانِي مِنَ السَّنَةِ الثَّانِيَةِ لِخُرُوجِ بَنِي إِسْرَائِيلَ مِنْ دِيَارِ مِصْرَ، أَمَرَ الرَّبُّ مُوسَى فِي بَرِّيَّةِ سِينَاءَ فِي خَيْمَةِ الاجْتِمَاعِ قَائِلاً: ");
INSERT INTO arbnav_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«أَحْصُوا كُلَّ ذَكَرٍ بِاسْمِهِ مِنْ شَعْبِ إِسْرَائِيلَ حَسَبَ قَبَائِلِهِمْ وَبُيُوتِ آبَائِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","وَعَلَيْكَ أَنْتَ وَهَرُونَ أَنْ تَحْسِبَهُمْ وَفْقاً لفِرَقِهِمْ مِنِ ابْنِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنَ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، مِنْ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","وَلْيَكُنْ مَعَكُمَا مِنْ كُلِّ سِبْطٍ رَجُلٌ يَتَوَلَّى رِيَاسَةَ بَيْتِ آبَائِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","وَهَذِهِ أَسْمَاءُ الرِّجَالِ الَّذِينَ يُشْرِفُونَ مَعَكُمَا عَلَى الإحْصَاءِ: عَنْ سِبْطِ رَأُوبَيْنَ أَلِيصُورُ بْنُ شَدَيْئُورَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","عَنْ سِبْطِ شِمْعُونَ شَلُومِيئِيلُ بْنُ صُورِيشَدَّايْ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","عَنْ سِبْطِ يَهُوذَا نَحْشُونُ بْنُ عَمِّينَادَابَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","عَنْ سِبْطِ يَسَّاكَرَ نَثَنَائِيلُ بْنُ صُوغَرَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","عَنْ سِبْطِ زَبُولُونَ أَلِيآبُ بْنُ حِيلُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","عَنْ سِبْطِ أَفْرَايِمَ بْنُ يُوسُفَ أَلِيشَمَعُ بْنُ عَمِّيهُودَ. عَنْ سِبْطِ مَنَسَّى بْنِ يُوسُفَ جَمْلِيئِيلُ بْنُ فَدَهْصُورَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","عَنْ سِبْطِ بِنْيَامِينَ أَبِيدَنُ بْنُ جِدْعُونِي. ");
INSERT INTO arbnav_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","عَنْ سِبْطِ دَانٍ أَخِيعَزَرُ بْنُ عَمِّيشَدَّايْ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","عَنْ سِبْطِ أَشِيرَ فَجْعِيئِيلُ بْنُ عُكْرَنَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","عَنْ سِبْطِ جَادٍ أَلِيَاسَافُ بْنُ دَعُوئِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","عَنْ سِبْطِ نَفْتَالِي أَخِيرَعُ بْنُ عِينَنَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","هَؤُلاءِ هُمُ الرِّجَالُ الْمُنْتَخَبُونَ مِنْ بَيْنِ الشَّعْبِ، رُؤَسَاءُ أَسْبَاطِهِمْ وَشُيُوخُ عَشَائِرِهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","فَأَخَذَ مُوسَى وَهَرُونُ هَؤُلاءِ الرِّجَالَ الَّذِينَ تَعَيَّنُوا بِأَسْمَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","وَجَمَعَا كُلَّ الشَّعْبِ فِي أَوَّلِ الشَّهْرِ الثَّانِي. فانْتَسَبَ كُلُّ ذَكَرٍ بِاسْمِهِ مِنِ ابْنِ عِشْرِينَ فَمَا فَوْقُ إِلَى سِبْطِهِ حَسَبَ عَشِيرَتِهِ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","كَمَا أَمَرَ الرَّبُّ مُوسَى. فَأَحْصَاهُمْ فِي صَحْرَاءِ سِينَاءَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","فَمِنْ نَسْلِ رَأُوبَيْنَ بِكْرِ إِسْرَائِيلَ تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنَ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ رَأُوبَيْنَ سِتَّةً وَأَرْبَعِينَ أَلْفاً وَخَمسَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","وَمِنْ نَسْلِ شِمْعُونَ، تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنَ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ شِمْعُونَ تِسْعَةً وَخَمْسِينَ أَلْفاً وَثَلاثَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","وَمِنْ نَسْلِ جَادٍ، تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنَ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ جَادٍ خَمْسَةً وَأَرْبَعِينَ أَلْفاً وَسِتَّ مِئَةٍ وَخَمْسِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","وَمِنْ نَسْلِ يَهُوذَا، تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنَ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ يَهُوذَا أَرْبَعَةً وَسَبْعِينَ أَلْفاً وَسِتَّ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","وَمِنْ نَسْلِ يَسَّاكَرَ، تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنَ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ يَسَّاكَرَ أَرْبَعَةً وَخَمْسِينَ أَلْفاً وَأَرْبَعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","وَمِنْ نَسْلِ زَبُولُونَ، تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنَ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ زَبُولُونَ سَبْعَةً وَخَمْسِينَ أَلْفاً وَأَرْبَعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","وَمِنْ نَسْلِ أَفْرَايِمَ بْنِ يُوسُفَ، تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنَ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ أَفْرَايِمَ أَرْبَعِينَ أَلْفاً وَخَمْسَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","وَمِنْ نَسْلِ مَنَسَّى بْنِ يُوسُفَ، تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنْ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ مَنَسَّى اثْنَيْنِ وَثَلاثِينَ أَلْفاً وَمِئَتَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","وَمِنْ نَسْلِ بِنْيَامِينَ، تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنْ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ بِنْيَامِينَ خَمْسَةً وَثَلاثِينَ أَلْفاً وَأَرْبَعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","وَمِنْ نَسْلِ دَانٍ، تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنْ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ دَانَ اثْنَيْنِ وَسِتِّينَ أَلْفاً وَسَبْعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","وَمِنْ نَسْلِ أَشِيرَ، تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنْ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ أَشِيرَ وَاحِداً وَأَرْبَعِينَ أَلْفاً وَخَمَسَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","وَمِنْ نَسْلِ نَفْتَالِي، تَمَّ إِحْصَاءُ جَمِيعِ الرِّجَالِ الْبَالِغِينَ مِنَ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مَنْ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ، كُلٍّ بِاسْمِهِ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","فَكَانَ عَدَدُ الْمُحْصَيْنَ مِنْ سِبْطِ نَفْتَالِي ثَلاثَةً وَخَمْسِينَ أَلْفاً وَأَرْبَعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","هَؤُلاءِ هُمْ جُمْلَةُ الَّذِينَ أَحْصَاهُمْ مُوسَى وَهَرُونَ وَرُؤَسَاءُ إِسْرَائِيلَ الاثْنَا عَشَرَ الْمُمَثِّلُونَ لأَسْبَاطِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","فَكَانَ الْمَجْمُوعُ الْكُلِّيُّ لِلرِّجَالِ الْمُحْصَيْنَ مِنْ إِسْرَائِيلَ الْبَالِغِينَ مِنْ الْعُمْرِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، حَسَبَ بُيُوتِ آبَائِهِمْ مِنَ الْقَادِرِينَ عَلَى الْقِتَالِ فِي الْحَرْبِ فِي إِسْرَائِيلَ ");
INSERT INTO arbnav_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","سِتَّ مِئَةِ أَلْفٍ وَثَلاثَةَ آلافٍ وَخَمْسَ مِئَةٍ وَخَمْسِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","أَمَّا اللّاوِيُّونَ الْمُنْتَسِبُونَ لِسِبْطِ آبَائِهِمْ فَلَمْ يُحْصَوْا بَيْنَهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","إِذْ قَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«أَمَّا سِبْطُ لاوِي فَلا تَحْسِبْهُ وَلا تُحْصِهِ بَيْنَ بَنِي إِسْرَائِيلَ، ");
INSERT INTO arbnav_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","بَلْ اعْهَدْ بِمَسْكِنِ الشَّهَادَةِ وَأَمْتِعَتِهِ كُلِّهَا وَسَائِرِ مَالَهُ إِلَى اللّاوِيِّينَ. فَهُمْ يَنْقُلُونَ الْمَسْكَنَ وَأَمْتِعَتَهُ كُلَّهَا وَيَعْتَنُونَ بِهِ، وَحَوْلَهُ يُقِيمُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","وَهُمُ الَّذِينَ يُنْزِلُونَ الْمَسْكَنَ عِنْدَ ارْتِحَالِهِ وَيَنْصِبُونَهُ عِنْدَ حُلُولِهِ، وَأَيُّ وَاحِدٍ آخَرَ غَيْرَهُمْ يَقْتَرِبُ مِنْهُ يُقْتَلُ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","وَلْيَضْرِبْ بَنُو إِسْرَائِيلَ خِيَامَهُمْ كُلٌّ فِي مَوْضِعِهِ فِي الْمُخَيَّمِ، وَكُلٌّ تَحْتَ رَايَةِ قَوْمِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","وَأَمَّا اللّاوِيُّونَ فَيُقِيمُونَ حَوْلَ مَسْكَنِ الشَّهَادَةِ، لِئَلّا يَحِلَّ سَخَطُ الرَّبِّ عَلَى شَعْبِ إِسْرَائِيلَ. وَليُحَافِظِ اللّاوِيُّونَ عَلَى خِدْمَةِ مَسْكَنِ الشَّهَادَةِ وَشَعَائِرِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","فَنَفَّذَ بَنُو إِسْرَائِيلَ تَمَاماً كُلَّ مَا أَمَرَ الرَّبُّ بِهِ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","وَخَاطَبَ الرَّبُّ مُوسَى وَهَرُونَ: ");
INSERT INTO arbnav_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«لِيُخَيِّمْ بَنُو إِسْرَائِيلَ كُلٌّ عِنْدَ رَايَتِهِ تَحْتَ أَعْلامِ بُيُوتِ آبَائِهِمْ، وَلْيُقِيمُوا مُقَابِلَ خَيْمَةِ الاجْتِمَاعِ وَحَوْلَهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","وَلْيُخَيِّمْ سِبْطُ يَهُوذَا بِرَايَتِهِ إِلَى الشَّرْقِ حَسَبَ عَشَائِرِهِ وَيَكُونُ رَئِيسُ سِبْطِ يَهُوذَا نَحْشُونَ بْنَ عَمِّينَادَابَ، ");
INSERT INTO arbnav_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","وَعَدَدُ جُنُودِهِ الْمُحْصَوْنَ أَرْبَعَةٌ وَسَبْعُونَ أَلْفاً وَسِتُّ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","وَلْيَنْزِلْ مَعَهُ كُلٌّ مِنْ سِبْطِ يَسَّاكَرَ الَّذِي يَرْأَسُهُ نَثَنَائِيلُ بْنُ صُوغَرَ، ");
INSERT INTO arbnav_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","مَعَ جُنْدِهِ الَّذِينَ أَحْصَاهُمُ الْبَالِغِينَ أَرْبَعَةً وَخَمْسِينَ أَلْفاً وَأَرْبَعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","وَسِبْطِ زَبُولُونَ الَّذِي يَرْأَسُهُ أَلِيَآبُ بْنُ حِيلُونَ، ");
INSERT INTO arbnav_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","مَعَ جُنْدِهِ الَّذِينَ أَحْصَاهُمُ الْبَالِغِينَ سَبْعَةً وَخَمْسِينَ أَلْفاً وَأَرْبَعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","فَمَجْمُوعُ الْمُحْصَيْنَ الْمُقِيمِينَ فِي مِنْطَقَةِ يَهُوذَا مِئَةُ أَلْفٍ وَسِتَّةٌ وَثَمَانُونَ أَلْفاً وَأَرْبَعُ مِئَةٍ مِنَ الْجُنُودِ. هَؤُلاءِ يَرْتَحِلُونَ أَولاً. ");
INSERT INTO arbnav_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","وَلْيُخَيِّمْ رَأُوبَيْنُ بِرَايَتِهِ إِلَى الْجَنُوبِ. وَيَكُونُ رَئِيسُ سِبْطِ رَأُوبَيْنَ أَلِيصُورَ بْنَ شَدَيْئُورَ، ");
INSERT INTO arbnav_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","مَعَ جُنْدِهِ الَّذِينَ أَحْصَاهُمُ الْبَالِغِينَ سِتَّةً وَأَرْبَعِينَ أَلْفاً وَخَمْسَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","وَلْيَنْزِلْ مَعَهُ كُلٌّ مِنْ سِبْطِ شِمْعُونَ الَّذِي يَرْأَسُهُ شَلُومِيئِيلُ بْنُ صُورِيشَدَّايْ، ");
INSERT INTO arbnav_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","مَعَ جُنْدِهِ الَّذِينَ أَحْصَاهُمُ الْبَالِغِينَ تِسْعَةً وَخَمْسِينَ أَلْفاً وَثَلاثَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","وَسِبْطِ جَادٍ الَّذِي يَرْأَسُهُ أَلِيَاسَافُ بْنُ دَعُوئِيلَ، ");
INSERT INTO arbnav_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","مَعَ جُنْدِهِ الَّذِينَ أَحْصَاهُمُ الْبَالِغِينَ خَمْسَةً وَأَرْبَعِينَ أَلْفاً وَسِتَّ مِئَةٍ وَخَمْسِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","فَيَكُونُ مَجْمُوعُ الْمُحْصَيْنَ الْمُقِيمِينَ فِي مِنْطَقَةِ رَأُوبَيْنَ مِئَةَ أَلْفٍ وَوَاحِداً وَخَمْسِينَ أَلْفاً وَأَرْبَعَ مِئَةٍ وَخَمْسِينَ مِنَ الْجُنُودِ. هَؤُلاءِ يَرْتَحِلُونَ ثَانِيَةً. ");
INSERT INTO arbnav_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ثُمَّ تَرْتَحِلُ خَيْمَةُ الاجْتِمَاعِ وَسِبْطُ اللّاوِيِّينَ فِي وَسَطِ الْمُخَيَّمِ. كَمَا يَنْزِلُونَ كَذَلِكَ يَرْتَحِلُونَ. كُلٌّ يَنْزِلُ فِي مَوْضِعِهِ مَعَ رَايَاتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","وَلْيُخَيِّمْ أَفْرَايِمُ بِرَايَتِهِ وَفِرَقِ جُنُودِهِ إِلَى الْغَرْبِ. وَيَكُونُ رَئِيسُ سِبْطِ أَفْرَايِمَ أَلِيشَمَعَ بْنَ عَمِّيهُودَ، ");
INSERT INTO arbnav_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","وَعَدَدُ جُنْدِهِ الَّذِينَ أَحْصَاهُمْ أَرْبَعُونَ أَلْفاً وَخَمْسُ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","وَلْيَنْزِلْ مَعَهُ كُلٌّ مِنْ سِبْطِ مَنَسَّى الَّذِي يَرْأَسُهُ جَمْلِيئِيلُ بْنُ فَدَهْصُورَ، ");
INSERT INTO arbnav_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","مَعَ جُنْدِهِ الَّذِينَ أَحْصَاهُمُ الْبَالِغِينَ اثْنَيْنِ وَثَلاثِينَ أَلْفاً وَمِئَتَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","وَسِبْطِ بِنْيَامِينَ الَّذِي يَرْأَسُهُ أَبِيدَنُ بْنُ جِدْعُونِي، ");
INSERT INTO arbnav_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","مَعَ جُنْدِهِ الَّذِينَ أَحْصَاهُمُ الْبَالِغِينَ خَمْسَةً وَثَلاثِينَ أَلْفاً وَأَرْبَعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","فَيَكُونُ مَجْمُوعُ الْمُحْصَيْنَ الْمُقِيمِينَ فِي مِنْطَقَةِ أَفْرَايِمَ مِئَةَ أَلْفٍ وَثَمَانِيَةَ آلافٍ وَمِئَةً مِنَ الْجُنُودِ. هَؤُلاءِ يَرْتَحِلُونَ ثَالِثَةً. ");
INSERT INTO arbnav_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","وَلْيُخَيِّمْ دَانٌ بِرَايَتِهِ وَفِرَقِ جُنُودِهِ إِلَى الشِّمَالِ. وَيَكُونُ رَئِيسُ سِبْطِ دَانَ أَخِيعَزَرَ بْنَ عَمِّيشَدَّايْ، ");
INSERT INTO arbnav_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","وَعَدَدُ جُنْدِهِ الَّذِينَ أَحْصَاهُمُ اثْنَانِ وَسِتُّونَ أَلْفاً وَسَبْعُ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","وَلْيَنْزِلْ مَعَهُ كُلٌّ مِنْ سِبْطِ أَشِيرَ الَّذِي يَرْأَسُهُ فَجْعِيئِيلُ بْنُ عُكْرَنَ، ");
INSERT INTO arbnav_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","مَعَ جُنْدِهِ الَّذِينَ أَحْصَاهُمُ الْبَالِغِينَ وَاحِداً وَأَرْبَعِينَ أَلْفاً وَخَمْسَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","وَسِبْطِ نَفْتَالِي الَّذِي يَرْأَسُهُ أَخِيرَعُ بْنُ عِينَنَ، ");
INSERT INTO arbnav_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","مَعَ جُنْدِهِ الَّذِينَ أَحْصَاهُمُ الْبَالِغِينَ ثَلاثَةً وَخَمْسِينَ أَلْفاً وَأَرْبَعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","فَيَكُونُ مَجْمُوعُ الْمُحْصَيْنَ الْمُقِيمِينَ فِي مِنْطَقَةِ دَانٍ مِئَةَ أَلْفٍ وَسَبْعَةً وَخَمْسِينَ أَلْفاً وَسِتَّ مِئَةٍ. هَؤُلاءِ يَرْتَحِلُونَ أَخِيراً بِرَايَاتِهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","فَيَكُونُ عَدَدُ الْمُحْصَيْنَ مِنْ بَنِي إِسْرَائِيلَ حَسَبَ بُيُوتِ آبَائِهِمِ الْمُقِيمِينَ فِي الْمُخَيَّمِ وَفْقاً لِعَشَائِرِهِمْ سِتَّ مِئَةِ أَلْفٍ وَثَلاثَةَ آلافٍ وَخَمْسَ مِئَةٍ وَخَمْسِينَ فَرْداً. ");
INSERT INTO arbnav_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","أَمَّا اللّاوِيُّونَ فَلَمْ يَتِمَّ إِحْصَاؤُهُمْ بَيْنَ بَنِي إِسْرَائِيلَ، كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","فَنَفَّذَ بَنُو إِسْرَائِيلَ تَمَاماً كُلَّ مَا أَمَرَ الرَّبُّ بِهِ مُوسَى فِي حِلِّهِمْ وَتِرْحَالِهِمْ نَازِلِينَ تَحْتَ رَايَاتِهِمْ، كُلٌّ حَسَبَ عَشَائِرِهِ وَسِبْطِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","وَهَذِهِ هِيَ مَوَالِيدُ هَروُنَ وَمُوسَى يَوْمَ خَاطَبَ الرَّبُّ مُوسَى فِي جَبَلِ سِينَاءَ: ");
INSERT INTO arbnav_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","هَذِهِ هِيَ أَسْمَاءُ أَبْنَاءِ هَرُونَ: نَادَابُ الْبِكْرُ، وَأَبِيهُو، وَأَلِعَازَارُ، وَإِيثَامَارُ، ");
INSERT INTO arbnav_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","الَّذِينَ كَانُوا كَهَنَةً مَمْسُوحِينَ تَكَرَّسُوا لِلْكَهَنُوتِ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","إِلّا أَنَّ نَادَابَ وَأَبِيهُو مَاتَا بَيْنَ يَدَيِ الرَّبِّ عِنْدَمَا قَرَّبَا نَاراً غَرِيبَةً أَمَامَهُ فِي صَحْرَاءِ سِينَاءَ، وَلَمْ يَكُنْ لَهُمَا بَنُون. وَأَمَّا أَلِعَازَارُ وَإِيثَامَارُ فَقَدْ قَامَا بِخِدْمَةِ الْكَهَنُوتِ تَحْتَ رِعَايَةِ أَبِيهِمَا هَرُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«أَحْضِرْ سِبْطَ لاوِي لِيَمْثُلُوا أَمَامَ هَرُونَ الْكَاهِنِ وَيَخْدِمُوهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","وَيُحَافِظُوا عَلَى شَعَائِرِهِ وَشَعَائِرِ كُلِّ الشَّعْبِ أَمَامَ خَيْمَةِ الاجْتِمَاعِ، وَيَقُومُوا بِخِدْمَةِ الْمَسْكَنِ، ");
INSERT INTO arbnav_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","وَيَحْرُسُوا كُلَّ أَمْتِعَةِ خَيْمَةِ الاجْتِمَاعِ، وَيَنُوبُوا عَنِ الشَّعْبِ فِي تَأْدِيَةِ وَاجِبَاتِ خِدْمَةِ الْمَسْكَنِ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","وَلْيَكُنِ اللّاوِيُّونَ تَحْتَ إِمْرَةِ هَرُونَ وَأَبْنَائِهِ هِبَةً لَهُ مِنْ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","أَمَّا هَرُونُ وَأَبْنَاؤُهُ فَهُمْ وَحْدُهُمْ يَقُومُونَ بِخِدْمَةِ الْكَهَنُوتِ، وَأَيُّ وَاحِدٍ سِوَاهُمْ يَقْتَرِبُ مِنَ الْمَقْدِسِ يُقْتَلُ». ");
INSERT INTO arbnav_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«هَا إِنِّي قَدْ أَفْرَزْتُ اللّاوِيِّينَ مِنْ بَيْنِ بَنِي إِسْرَائِيلَ بَدَلاً مِنْ أَبْكَارِ الشَّعْبِ، فَيَكُونُ اللّاوِيُّونَ خَاصَّتِي، ");
INSERT INTO arbnav_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","لأَنَّ كُلَّ بِكْرٍ مِنْ شَعْبِ إِسْرَائِيلَ هُوَ لِي. فَقَدْ أَفْرَزْتُ لِي كُلَّ بِكْرٍ فِي إِسْرَائِيلَ مِنَ النَّاسِ وَالْبَهَائِمِ مُنْذُ أَنْ أَهْلَكْتُ كُلَّ بِكْرٍ فِي دِيَارِ مِصْرَ. لِي يَكُونُونَ. أَنَا الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","وَقَالَ الرَّبُّ لِمُوسَى فِي صَحْرَاءِ سِينَاءَ: ");
INSERT INTO arbnav_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«أَحْصِ كُلَّ ذَكَرٍ مِنْ أَبْنَاءِ سِبْطِ لاوِي مِنِ ابْنِ شَهْرٍ فَمَا فَوْقُ، حَسَبَ بُيُوتِ آبَائِهِمْ وَعَشَائِرِهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","فَأَحْصَاهُمْ مُوسَى وَفْقاً لأَمْرِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","وَهَذِهِ هِيَ أَسْمَاءُ أَبْنَاءِ لاوِي: جَرْشُونُ وَقَهَاتُ وَمَرَارِي. ");
INSERT INTO arbnav_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","أَمَّا اسْمَا ابْنَيْ جَرْشُونَ حَسَبَ عَشَائِرِهِمَا، فَهُمَا: لِبْنِي وَشِمْعِي ");
INSERT INTO arbnav_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","وَبَنُو قَهَاتَ حَسَبَ عَشَائِرِهِمْ هُمْ: عَمْرَامُ وَيِصْهَارُ وَحَبْرُونُ وَعُزِّيئِيلُ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","وَابْنَا مَرَارِي حَسَبَ عَشَائِرِهِمَا هُمَا مَحْلِي وَمُوشِي. هَذِهِ هِيَ عَشَائِرُ اللّاوِيِّينَ وَفْقاً لِبُيُوتِ آبَائِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","فَقَدْ تَفَرَّعَ عَنْ جَرْشُونَ عَشِيرَتَا اللِّبْنِيِّينَ وَالشِّمْعِيِّينَ. هَاتَانِ هُمَا عَشِيرَتَا الْجَرْشُونِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","وَكَانَ عَدَدُ الذُّكُورِ الْمُحْصَيْنَ مِنْهُمَا مِنِ ابْنِ شَهْرٍ وَمَا فَوْقُ، سَبْعَةَ آلافٍ وَخَمْسَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","وَقَدْ خَيَّمَتْ عَشِيرَتَا الْجَرْشُونِيِّينَ وَرَاءَ الْمَسْكَنِ إِلَى الْغَرْبِ، ");
INSERT INTO arbnav_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","وَكَانَ رَئِيسُهُمَا أَلِيَاسَافَ بْنَ لايِلَ ");
INSERT INTO arbnav_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","وَعُهِدَ إِلَى الْجَرْشُونِيِّينَ بِحِرَاسَةِ الْمَسْكَنِ فِي خَيْمَةِ الاجْتِمَاعِ وَالْخَيْمَةِ وَغِطَائِهَا وَسَتَائِرِ بَابِ خَيْمَةِ الاجْتِمَاعِ، ");
INSERT INTO arbnav_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","وَسَتَائِرِ الدَّارِ وَسِتَارَةِ بَابِ الدَّارِ الَّتِي حَوْلَ الْمَسْكَنِ وَحَوْلَ جَوَانِبِ الْمَذْبَحِ وَحِبَالِهِ مَعَ كُلِّ خِدْمَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","وَتَفَرَّعَ عَنْ قَهَاتَ عَشَائِرُ الْعَمْرَامِيِّينَ وَالْيِصْهَارِيِّينَ وَالْحَبْرُونِيِّينَ وَالْعُزِّيئِيلِيِّينَ. هَذِهِ هِيَ عَشَائِرُ الْقَهَاتِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","فَكَانَ عَدَدُ الذُّكُورِ الْمُحْصَيْنَ مِنْهُمْ مِنِ ابْنِ شَهْرٍ فَمَا فَوْقُ، ثَمَانِيَةَ آلافٍ وَسِتَّ مِئَةٍ. وَمُهِمَّتُهُمْ حِرَاسَةُ الْقُدْسِ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","وَتُخَيِّمُ عَشَائِرُ بَنِي قَهَاتَ فِي جَنُوبِيِّ الْمَسْكَنِ، ");
INSERT INTO arbnav_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","وَكَانَ رَئِيسُهَا أَلِيصَافَانَ بْنَ عُزِّيئِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","وَهُمْ يَتَوَلَّوْنَ حِرَاسَةَ التَّابُوتِ وَالْمَائِدَةِ وَالْمَنَارَةِ وَالْمَذْبَحَيْنِ وَأَمْتِعَةِ الْقُدْسِ الَّتِي يَخْدُمُونَ بِها، وَالْحِجَابِ وَكُلِّ مَا يَتَعَلَّقُ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","أَمَّا رَئِيسُ رُؤَسَاءِ اللّاوِيِّينَ أَلِعَازَارُ بْنُ هَرُونَ الْكَاهِنِ فَيَتَوَلَّى أَيْضاً أَمْرَ حُرَّاسِ حِرَاسَةِ الْقُدْسِ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","وَتَفَرَّعَ عَنْ مَرَارِي عَشِيرَتَا الْمَحْلِيِّينَ وَالْمُوشِيِّينَ. هَاتَانِ هُمَا عَشِيرَتَا مَرَارِي. ");
INSERT INTO arbnav_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","فَكَانَ عَدَدُ الذُّكُورِ الْمُحْصَيْنَ مِنْهُمَا مِنِ ابْنِ شَهْرٍ فَمَا فَوْقُ، سِتَّةَ آلافٍ وَمِئَتَيْنِ، ");
INSERT INTO arbnav_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","وَرَئِيسُهُمَا صُورِيئِيلُ بْنُ أَبِيحَايِلَ. وَتُخَيِّمَانِ إِلَى شِمَالِيِّ الْمَسْكَنِ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","وَمُهِمَّةُ أَبْنَاءِ مَرَارِي حِرَاسَةُ أَلْوَاحِ الْمَسْكَنِ وَعَوَارِضِهِ وَقَوَاعِدِهَا وَكُلِّ أَوَانِيهِ وَالْعِنَايَةُ بِها، ");
INSERT INTO arbnav_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","وَأَعْمِدَةِ جَوَانِبِ الدَّارِ وَقَوَاعِدِهَا وَأَوْتَادِهَا وَحِبَالِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","أَمَّا مُوسَى وَهَرُونُ وَأَبْنَاؤُهُ فَيَنْزِلُونَ قُدَّامَ الْمَسْكَنِ إِلَى الشَّرْقِ لِيَقُومُوا بِحِرَاسَةِ الْمَقْدِسِ نِيَابَةً عَنْ بَنِي إِسْرَائِيلَ، وَأَيُّ وَاحِدٍ سِوَاهُمْ يَقْتَرِبُ مِنْهُ يُقْتَلُ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","فَكَانَ مَجْمُوعُ الْمُحْصَيْنَ مِنْ ذُكُورِ اللّاوِيِّينَ مِنِ ابْنِ شَهْرٍ فَمَا فَوْقُ، الَّذِينَ أَحْصَاهُمْ مُوسَى وَهَرُونُ حَسَبَ عَشَائِرِهِمْ كَمَا أَمَرَ الرَّبُّ، اثْنَيْنِ وَعِشْرِينَ أَلْفاً. ");
INSERT INTO arbnav_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","وَقَالَ الرَّبُّ لِمُوسَى: «أَحْصِ كُلَّ بِكْرٍ ذَكَرٍ مِنْ بَنِي إِسْرَائِيلَ مِنِ ابْنِ شَهْرٍ فَمَا فَوْقُ، وَدَوِّنْ أَسْمَاءَهُمْ جَمِيعاً، ");
INSERT INTO arbnav_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","فَتَفْرِزُ لِيَ اللّاوِيِّينَ، أَنَا الرَّبُّ، لِيَكُونُوا لِي بَدَلَ كُلِّ بِكْرٍ فِي بَنِي إِسْرَائِيلَ، وَكَذَلِكَ بَهَائِمَ اللّاوِيِّينَ بَدَلَ كُلِّ بِكْرٍ فِي بَهَائِمِ بَنِي إِسْرَائِيلَ». ");
INSERT INTO arbnav_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","فَأَحْصَى مُوسَى أَبْكَارَ بَنِي إِسْرَائِيلَ كَمَا أَمَرَهُ الرَّبُّ، ");
INSERT INTO arbnav_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","فَكَانَ مَجْمُوعُ عَدَدِ الذُّكُورِ الأَبْكَارِ الْمُحْصَيْنَ، كُلٍّ بِاسْمِهِ، مِنِ ابْنِ شَهْرٍ فَمَا فَوْقُ، اثْنَيْنِ وَعِشْرِينَ أَلْفاً وَمِئَتَيْنِ وَثَلاثَةً وَسَبْعِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«أَفْرِزِ اللّاوِيِّينَ بَدَلَ كُلِّ بِكْرٍ فِي بَنِي إِسْرَائِيلَ، وَكَذَلِكَ بَهَائِمَ اللّاوِيِّينَ بَدَلَ بَهَائِمِهِمْ، فَيَكُونَ اللّاوِيُّونَ خَاصَّتِي، أَنَا الرَّبَّ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","وَأَمَّا فِدَاءُ الْمِئَتَيْنِ وَالثَّلاثَةِ وَالسَّبْعِينَ مِنْ أَبْكَارِ بَنِي إِسْرَائِيلَ الزَّائِدِينَ عَنْ عَدَدِ اللّاوِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","فَتَأْخُذُ عَنْ كُلِّ وَاحِدٍ مِنْهُمْ خَمْسَةَ شَوَاقِلَ (نَحْوَ سِتِّينَ جِرَاماً) مِنَ الْفِضَّةِ وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ فَيَكُونُ كُلُّ عِشْرِينَ جِيرَةً مُعَادِلَةً لِشَاقِلٍ (أَيْ لاثْنَيْ عَشَرَ جِرَاماً). ");
INSERT INTO arbnav_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","وَتُعْطِي الْفِضَّةَ لِهَرُونَ وَأَبْنَائِهِ فِدْيَةً عَنِ الأَبْكَارِ الزَّائِدِينَ عَنْ عَدَدِ اللّاوِيِّينَ» ");
INSERT INTO arbnav_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","فَجَمَعَ مُوسَى فِضَّةَ الْفِدْيَةِ مِنَ الزَّائِدِينَ عَنْ عَدَدِ اللّاوِيِّينَ فِدَاءً لَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","جَبَاهَا مِنْ أَبْكَارِ بَنِي إِسْرَائِيلَ، فَكَانَتْ أَلْفاً وَثَلاثَ مِئَةٍ وَخَمْسَةً وَسِتِّينَ مِنَ الْفِضَّةِ عَلَى شَاقِلِ الْقُدْسِ (نَحْوَ سِتَّةَ عَشَرَ كِيلُو جِرَاماً وَثُلْثٍ). ");
INSERT INTO arbnav_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","وَأَعْطَى مُوسَى فِضَّةَ الْفِدْيَةِ لِهَرُونَ وَأَبْنَائِهِ كَمَا أَمَرَ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","وَقَالَ الرَّبُّ لِمُوسَى وَهَرُونَ: ");
INSERT INTO arbnav_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«أَحْصِيَا بَنِي قَهَاتَ مِنْ بَيْنِ أَبْنَاءِ لاوِي حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","مِنِ ابْنِ ثَلاثِينَ سَنَةً حَتَّى ابْنِ خَمْسِينَ، مِنَ الْمُتَجَنِّدِينَ لِخِدْمَةِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","وَهَذِهِ هِيَ الْخِدْمَةُ الَّتِي تُوْكَلُ إِلَى بَنِي قَهَاتَ فِي خَيْمَةِ الاجْتِمَاعِ: قُدْسُ الأَقْدَاسِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","عِنْدَ وَقْتِ الرَّحِيلِ، يَأْتِي هَرُونُ وَأَبْنَاؤُهُ وَيُنْزِلُونَ الحِجَابَ الْفَاصِلَ، وَيُغَطُّونَ بِهِ تَابُوتَ الشَّهَادَةِ، ");
INSERT INTO arbnav_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","وَيَضَعُونَ فَوْقَهُ غِطَاءً مِنْ جِلْدِ الدَّلْفِينِ، وَيَبْسُطُونَ فَوْقَهُ ثَوْباً مِنْ قُمَاشٍ أَزْرَقَ ثُمَّ يَضَعُونَ عِصِيَّهُ فِي حَلَقَاتِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","وَيَبْسُطُونَ عَلَى مَائِدَةِ خُبْزِ الْوُجُوهِ ثَوْباً مِنْ قُمَاشٍ أَزْرَقَ وَيَضَعُونَ عَلَيْهِ الصِّحَافَ وَالصُّحُونَ وَالْكُئوسَ وَالأَبَارِيقَ الَّتِي تُسْكَبُ بِها الْقَرَابِينُ، وَيَكُونُ الْخُبْزُ الدَّائِمُ مَوْجُوداً عَلَيْهِ، ");
INSERT INTO arbnav_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ثُمَّ يُغَطُّونَهَا بِثَوْبٍ أَحْمَرِ اللَّوْنِ وَيَضَعُونَ فَوْقَهَا غِطَاءً مِنْ جِلْدِ الدَّلْفِينِ وَيُدْخِلُونَ عِصِيَّهَا فِي حَلَقَاتِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","وَيُغَطُّونَ أَيْضاً الْمَنَارَةَ وَسُرُجَهَا وَمَلاقِطَهَا وَمَنَافِضَهَا، وَسَائِرَ آنِيَةِ زَيْتِهَا الَّتِي يَسْتَعْمِلُونَهَا، بِثَوْبٍ أَزْرَقَ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","وَيَلُفُّونَهَا مَعَ جَمِيعِ أَوَانِيهَا بِغِطَاءٍ مِنْ جِلْدِ الدَّلْفِينِ، وَيَضَعُونَهَا عَلَى حَمَّالَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","وَيَبْسُطُونَ عَلَى مَذْبَحِ الذَّهَبِ ثَوْباً أَزْرَقَ وَيُغَطُّونَهُ بِغِطَاءٍ مِنْ جِلْدِ الدَّلْفِينِ، وَيُدْخِلُونَ عِصِيَّهُ فِي حَلَقَاتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","وَكَذَلِكَ يَلُفُّونَ جَمِيعَ أَوَانِي الْخِدْمَةِ الَّتِي يَسْتَعْمِلُونَهَا فِي الْقُدْسِ بِثَوْبٍ أَزْرَقَ وَيُغَطُّونَهَا بِغِطَاءٍ مِنَ الدَّلْفِينِ وَيَضَعُونَهَا عَلَى حَمَّالَةٍ ");
INSERT INTO arbnav_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","وَيَرْفَعُونَ رَمَادَ الْمَذْبَحِ وَيَبْسُطُونَ عَلَيْهِ ثَوْباً مِنْ قُمَاشٍ بَنَفْسَجِيٍّ، ");
INSERT INTO arbnav_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","وَيَضَعُونَ عَلَيْهِ جَمِيعَ أَوَانِيهِ الَّتِي يَسْتَعْمِلُونَهَا، الْمَجَامِرَ وَالْمَنَاشِلَ وَالرُّفُوشَ وَالْمَنَاضِحَ، كُلَّ أَوَانِي الْمَذْبَحِ، وَيُغَطُّونَهُ بِغِطَاءٍ مِنْ جِلْدِ الدَّلْفِينِ، ثُمَّ يُدْخِلُونَ عِصِيَّهُ فِي حَلَقَاتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","وَحَالَمَا يَنْتَهِي هَرُونُ وَأَبْنَاؤُهُ مِنْ تَغْطِيَةِ الْقُدْسِ وَجَمِيعِ آنِيَتِهِ عِنْدَ وَقْتِ ارْتِحَالِ الْمُخَيَّمِ، يُقْبِلُ بَنُو قَهَاتَ لِيَحْمِلُوهَا. وَلَكِنْ إِيَّاهُمْ أَنْ يَمَسُّوا الأَشْيَاءَ الْمُقَدَّسَةَ لِئَلّا يَمُوتُوا. هَذِهِ هِيَ مَسْؤولِيَّةُ بَنِي قَهَاتَ فِي حَمْلِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","وَيَكُونُ أَلِعَازَارُ بْنُ هَرُونَ الْكَاهِنِ مَسْؤولاً عَنْ زَيْتِ الإِنَارَةِ، وَعَنِ الْبَخُورِ الْعَطِرِ، وَتَقْدِمَةِ الدَّقِيقِ الْيَوْمِيَّةِ وَدُهْنِ الْمَسْحَةِ وَعَنْ سَائِرِ الْمَسْكَنِ وَمَا فِيهِ مِنَ الْقُدْسِ وَأَوَانِيهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","وَقَالَ الرَّبُّ لِمُوسَى وَهَرُونَ: ");
INSERT INTO arbnav_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«احْرِصَا أَلّا يَنْقَرِضَ فَرْعُ عَشَائِرِ الْقَهَاتِيِّينَ مِنْ بَيْنِ اللّاوِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","بَلِ اعْمَلا هَذَا التَّرْتِيبَ فَيَعِيشُوا وَلا يَمُوتُوا عِنْدَ اقْتِرَابِهِمْ إِلَى قُدْسِ الأَقْدَاسِ. يَدْخُلُ مَعَهُمْ هَرُونُ وَأَبْنَاؤُهُ وَيُعَيِّنُونَ لِكُلِّ إِنْسَانٍ خِدْمَتَهُ وَحِمْلَهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","وَلَكِنْ إِيَّاهُمْ أَنْ يَدْخُلُوا لِمُشَاهَدَةِ الْقُدْسِ وَلَوْ لِلَحْظَةٍ، لِئَلّا يَهْلِكُوا». ");
INSERT INTO arbnav_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«أَحْصِ عَدَدَ بَنِي جَرْشُونَ أَيْضاً حَسَبَ بُيُوتِ آبَائِهِمْ وَعَشَائِرِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","مِنِ ابْنِ ثَلاثِينَ سَنَةً فَمَا فَوْقُ حَتَّى ابْنِ خَمْسِينَ مِنَ الْمُتَجَنِّدِينَ فِي خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","وَهَذِهِ هِيَ الخَدَمَاتُ الَّتِي تُوْكَلُ إِلَى عَشَائِرِ الْجَرْشُونِيِّينَ مِنْ عَمَلٍ وَحَمْلٍ: ");
INSERT INTO arbnav_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","يَحْمِلُونَ شُقَقَ الْمَسْكَنِ وَخَيْمَةَ الاجْتِمَاعِ وَغِطَاءَهَا وَغِطَاءَ جِلْدِ الدَّلْفِينِ الَّذِي فَوْقَهَا، وَسِتَارَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","وَأَسْتَارَ السَّاحَةِ الْمُحِيطَةِ بِالْمَسْكَنِ وَالْمَذْبَحِ، وَسِتَارَةَ الْمَدْخَلِ وَالْحِبَالَ وَالأَوَانِي الْمُسْتَخْدَمَةَ فِي خِدْمَتِهَا. وَيُؤَدِّي الْجَرْشُونِيُّونَ جَمِيعَ الْخِدْمَاتِ الْوَاجِبَةِ لَهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","وَيَجِبُ أَنْ يَقُومُوا بِخِدْمَتِهِمْ، سَوَاءٌ أَكَانَتْ خِدْمَةَ نَقْلٍ أَمْ أَيَّ عَمَلٍ آخَرَ، تَحْتَ إِشْرَافِ هَرُونَ وَأَبْنَائِهِ. وَعَلَيْكَ أَنْ تُعَيِّنَ لَهُمْ مَا يَتَوَجَّبُ عَلَيْهِمْ حَمْلُهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","هَذِهِ هِيَ مَسْؤولِيَّةُ عَشَائِرِ الْجَرْشُونِيِّينَ فِي خَيْمَةِ الاجْتِمَاعِ، وَيَكُونُ إِيثَامَارُ بْنُ هَرُونَ الْكَاهِنِ هُوَ الْمُشْرِفُ عَلَى تَأْدِيَةِ وَاجِبَاتِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","وَتُحْصِي بَنِي مَرَارِي حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","مِنِ ابْنِ ثَلاثِينَ سَنَةً فَمَا فَوْقُ حَتَّى ابْنِ خَمْسِينَ، مِنَ الْمُتَجَنِّدِينَ فِي خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","وَتَكُونُ مَسْؤولِيَّةُ خِدْمَتِهِمْ فِي خَيْمَةِ الاجْتِمَاعِ نَقْلَ أَلْوَاحِ الْمَسْكَنِ وَعَوَارِضِهِ وَأَعْمِدَتِهِ وَقَوَاعِدِهِ، ");
INSERT INTO arbnav_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","وَأَعْمِدَةِ السَّاحَةِ الْمُحِيطَةِ وَقَوَاعِدِهَا وَأَوْتَادِهَا وَحِبَالِهَا وَأَوَانِيهَا وَكُلِّ مَا يَتَّصِلُ بِخِدْمَتِهَا. وَحَدِّدُوا بِالتَّفْصِيلِ مَا يَتَوَجَّبُ عَلَى كُلِّ رَجُلٍ حَمْلُهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","هَذِهِ هِيَ مَسْؤولِيَّةُ عَشَائِرِ الْمَرَارِيِّينَ الَّتِي يَقُومُونَ بِها فِي خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ تَحْتَ إِشْرَافِ إِيثَامَارَ بْنِ هَرُونَ الْكَاهِنِ». ");
INSERT INTO arbnav_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","فَأَحْصَى مُوسَى وَهَرُونُ وَرُؤَسَاءُ الشَّعْبِ جُمْلَةَ أَبْنَاءِ الْقَهَاتِيِّينَ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","مِنِ ابْنِ ثَلاثِينَ سَنَةً فَمَا فَوْقُ إِلَى ابْنِ خَمْسِينَ سَنَةً، مِنَ الْمُتَجَنِّدِينَ فِي خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","فَكَانَتْ جُمْلَةُ الْمُحْصَيْنَ مِنْهُمْ حَسَبَ عَشَائِرِهِمْ أَلْفَيْنِ وَسَبْعَ مِئَةٍ وَخَمْسِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","هَؤُلاءِ هُمُ الْمُحْصَوْنَ مِنْ عَشَائِرِ الْقَهَاتِيِّينَ الْخَادِمِينَ فِي خَيْمَةِ الاجْتِمَاعِ الَّذِينَ أَحْصَاهُمْ مُوسَى وَهَرُونُ كَمَا أَمَرَ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","وَتَمَّ إِحْصَاءُ جُمْلَةِ أَبْنَاءِ جَرْشُونَ حَسَب عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","مِنْ ابْنِ ثَلاثِينَ سَنَةً فَمَا فَوْقُ إِلَى ابْنِ خَمْسِينَ سَنَةً، مِنَ الْمُتَجَنِّدِينَ فِي خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","وَكَانَتْ جُمْلَةُ الْمُحْصَيْنَ مِنْهُم حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ أَلْفَيْنِ وَسِتَّ مِئَةٍ وَثَلاثِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","هَؤُلاءِ هُمُ الْمُحْصَوْنَ مِنْ عَشَائِرِ بَنِي جَرْشُونَ الْخَادِمِينَ فِي خَيْمَةِ الاجْتِمَاعِ الَّذِينَ أَحْصَاهُمْ مُوسَى وَهَرُونُ كَمَا أَمَرَ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","وَتَمَّ إِحْصَاءُ جُمْلَةِ بَنِي مَرَارِي حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","مِنِ ابْنِ ثَلاثِينَ سَنَةً فَمَا فَوْقُ إِلَى ابْنِ خَمْسِينَ سَنَةً، مِنَ الْمُتَجَنِّدِينَ فِي خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","فَكَانَتْ جُمْلَةُ الْمُحْصَيْنَ مِنْهُمْ حَسَبَ عَشَائِرِهِمْ ثَلاثَةَ آلافٍ وَمِئَتَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","هَؤُلاءِ هُمُ الْمُحْصَوْنَ مِنْ عَشَائِرِ بَنِي مَرَارِي الَّذِينَ أَحْصَاهُمْ مُوسَى وَهَرُونُ حَسَبَ أَمْرِ الَّربِّ عَلَى لِسَانِ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","فَكَانَ مَجْمُوعُ الْمُحْصَيْنَ مِنَ اللّاوِيِّينَ الَّذِينَ أَحْصَاهُمْ مُوسَى وَهَرُونُ وَرُؤَسَاءُ إِسْرَائِيلَ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","مِنِ ابْنِ ثَلاثَينَ سَنَةً فَمَا فَوْقُ إِلَى ابْنِ خَمْسِينَ سَنَةً، الْمُجَنَّدِينَ فِي عَمَلِ الْخِدْمَةِ فِي خَيْمَةِ الاجْتِمَاعِ وَفِي خِدْمَةِ نَقْلِهَا، ");
INSERT INTO arbnav_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ثَمَانِيَةَ آلافٍ وَخَمْسَ مِئَةٍ وَثَمَانِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","وَكَمَا أَمَرَ الرَّبُّ مُوسَى تَمَّ تَعْيِينُ كُلِّ لاوِيٍّ عَلَى خِدْمَتِهِ وَتَحْدِيدُ مَا يَتَوَجَّبُ عَلَيْهِ حَمْلُهُ. وَهَكَذَا تَمَّ إِحْصَاؤُهُمْ كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ أَنْ يَعْزِلُوا مِنَ الْمُخَيَّمِ كُلَّ أَبْرَصَ، وَكُلَّ مَرِيضٍ بِالسَّيَلانِ، وَكُلَّ مَنْ يَتَنَجَّسُ بِلَمْسِ مَيْتٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","اعْزِلُوهُمْ إِلَى خَارِجِ الْمُخَيَّمِ سَوَاءٌ كَانَ رَجُلاً أَمِ امْرَأَةً لِئَلّا يُنَجِّسُوا مُخَيَّمَهُمْ، حَيْثُ أَنَا سَاكِنٌ فِي وَسَطِهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","فَنَفَّذَ بَنُو إِسْرَائِيلَ الأَمْرَ، وَعَزَلُوهُمْ إِلَى خَارِجِ الْمُخَيَّمِ، طِبْقاً لِمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«أَوْصِ بَنِي إِسْرَائِيلَ إِذَا ارْتَكَبَ رَجُلٌ أَوِ امْرَأَةٌ خَطِيئَةَ السَّرِقَةِ وَخَانَ الرَّبَّ، فَقَد أَذْنَبَتْ تِلْكَ النَّفْسُ، ");
INSERT INTO arbnav_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","وَعَلَيْهَا أَنْ تَعْتَرِفَ بِخَطِيئَتِهَا الَّتِي اقْتَرَفَتْهَا، وَتَرُدَّ مَا أَذْنَبَتْ بِهِ، بَعْدَ أَنْ تُضِيفَ عَلَيْهِ خُمْسَهُ وَتَدْفَعَهُ لِمَنْ أَذْنَبَتْ بِحَقِّهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","وَإِنْ لَمْ يَكُنْ لِلرَّجُلِ الْمَسْرُوقِ، إِذَا مَاتَ، وَلِيٌّ يُرَدُّ إِلَيْهِ الْمَسْرُوقُ، فَلْيَكُنِ الْمَسْرُوقُ لِلرَّبِّ. يَأْخُذُهُ الْكَاهِنُ لِنَفْسِهِ، فَضْلاً عَنْ كَبْشِ الْكَفَّارَةِ الَّذِي يُكَفِّرُ بِهِ عَنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","وَتَكُونُ كُلُّ التَّقْدِمَاتِ الْمُقَدَّسَةِ الَّتِي يُقَرِّبُهَا الإِسْرَائِيلِيُّونَ لِلْكَاهِنِ نَصِيباً لَهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","وَكَذَلِكَ أَقْدَاسُ الإِنْسَانِ تَكُونُ لَهُ. وَإذَا أَعْطَى إِنْسَانٌ شَيْئاً لِلْكَاهِنِ فَلَهُ يَكُونُ». ");
INSERT INTO arbnav_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«أَوْصِ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: إِذَا ضَلَّتْ زَوْجَةٌ وَخَانَتْ زَوْجَهَا ");
INSERT INTO arbnav_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","بِزِنَاهَا مَعَ رَجُلٍ آخَرَ، وَخَفِيَ الأَمْرُ عَلَى زَوْجِهَا، وَلَمْ يَقُمْ عَلَيْهَا دَلِيلٌ وَلَمْ يُقْبَضْ عَلَيْهَا مُتَلَبِّسَةً بِزِنَاهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","وَإذَا اعْتَرَتْ زَوْجَهَا الْغَيْرَةُ وَارْتَابَ بِزَوْجَتِهِ وَكَانَتْ نَجِسَةً، أَوْ غَارَ عَلَى امْرَأَتِهِ مَعَ أَنَّهَا طَاهِرَةٌ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","فَلْيُحْضِرِ الرَّجُلُ امْرَأَتَهُ إِلَى الْكَاهِنِ، وَيَأْتِ مَعَهُ بِقُرْبَانِهَا عُشْرِ الإِيفَةِ (نَحْوَ لِتْرَيْنِ وَنِصْفِ اللِّتْرِ) مِنْ دَقِيقِ الشَّعِيرِ. لَا يَصُبُّ عَلَيْهِ زَيْتاً، وَلا يَضَعُ عَلَيْهِ لُبَاناً، لأَنَّهُ تَقْدِمَةُ غَيْرَةٍ، تَقْدِمَةُ تَذْكِرَةٍ تُذَكِّرُ بِذَنْبٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","فَيَجْعَلُ الْكَاهِنُ الزَّوْجَةَ تَمْثُلُ أَمَامَ الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ثُمَّ يَأْخُذُ مَاءً مُقَدَّساً فِي إِنَاءٍ مِنْ خَزَفٍ وَيَلْتَقِطُ بَعْضَ غُبَارِ أَرْضِ الْمَسْكَنِ وَيَضَعُهُ فِي الْمَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","وَيَكْشِفُ رَأْسَ الزَّوْجَةِ، وَيَضَعُ فِي يَدَيْهَا تَقْدِمَةَ التَّذْكَارِ الَّتِي هِيَ تَقْدِمَةُ الْغَيْرَةِ، وَيَحْمِلُ الْكَاهِنُ بِيَدِهِ مَاءَ اللَّعْنَةِ الْمُرَّ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","وَيَسْتَحْلِفُ الْكَاهِنُ الْمَرْأَةَ قَائِلاً لَهَا: إِنْ كَانَ رَجُلٌ آخَرُ لَمْ يُضَاجِعْكِ، وَلَمْ تَخُونِي زَوْجَكِ، فَأَنْتِ بَرِيئَةٌ مِنْ مَاءِ اللَّعْنَةِ الْمُرِّ هَذَا. ");
INSERT INTO arbnav_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","وَلَكِنْ إِنْ كُنْتِ قَدْ خُنْتِ زَوْجَكِ وَتَنَجَّسْتِ بِمُضَاجَعَةِ رَجُلٍ غَيْرِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","فَلْيَجْعَلِ الرَّبُّ لَعْنَةَ شَعْبِكِ عَلَيْكِ، فَيَتَبَرَّأُوا مِنْكِ عِنْدَمَا يَجْعَلُ الرَّبُّ فَخْذَكِ يَذْوِي وَبَطْنَكِ يَتَوَرَّمُ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","وَلْيَدْخُلْ مَاءُ اللَّعْنَةِ هَذَا فِي أَحْشَائِكِ لِيُسَبِّبَ وَرَماً لِبَطْنِكِ، وَلْيَذْوِ فَخْذُكِ. فَتَقُولُ الْمَرْأَةُ: آمِين. آمِين». ");
INSERT INTO arbnav_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«ثُمَّ يُدَوِّنُ الْكَاهِنُ هَذِهِ اللَّعَنَاتِ فِي دَرْجٍ وَيَمْحُوهَا بِالْمَاءِ الْمُرِّ؛ ");
INSERT INTO arbnav_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","وَيَسْقِي الْمَرْأَةَ مَاءَ اللَّعْنَةِ الْمُرَّ الَّذِي مَحَا بِهِ اللَّعْنَاتِ فَيَدْخُلُ فِيهَا مَاءُ اللَّعْنَةِ لِيُسَبِّبَ لَهَا آلامَ الْمَرَارَةِ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ثُمَّ يَأْخُذُ الْكَاهِنُ مِنْ يَدِ الْمَرْأَةِ تَقْدِمَةَ الْغَيْرَةِ، وَيُرَجِّحُهَا أَمَامَ الرَّبِّ، ثُمَّ يُقَدِّمُهَا إِلَى الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","وَيَتَنَاوَلُ مِلْءَ قَبْضَتِهِ مِنْهَا وَيُحْرِقُهُ عَلَى الْمَذْبَحِ، وَبَعْدَ ذَلِكَ يَسْقِي الْمَرْأَةَ الْمَاءَ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","فَإِنْ كَانَتِ الْمَرْأَةُ قَدْ تَنَجَّسَتْ وَخَانَتْ زَوْجَهَا، فَإِنَّهَا حِينَ تَشْرَبُ الْمَاءَ الْجَالِبَ اللَّعْنَةَ يُسَبِّبُ لَهَا آلامَ مَرَارَةٍ، فَيَتَوَرَّمُ بَطْنُهَا وَيَذْوِي فَخْذُهَا، وَتُصْبِحُ الْمَرْأَةُ لَعْنَةً فِي وَسَطِ شَعْبِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","أَمَّا إِنْ كَانَتْ بَرِيئَةً طَاهِرَةً، فَإِنَّهَا تَتَبَرَّأُ وَلا تُصْبِحُ عَاقِراً. ");
INSERT INTO arbnav_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","إِذاً، هَذِهِ هِيَ شَرِيعَةُ الْغَيْرَةِ الَّتِي تُطَبِّقُونَهَا إِذَا خَانَتِ امْرَأَةٌ زَوْجَهَا وَتَنَجَّسَتْ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","أَوْ إِذَا اعْتَرَتِ الْغَيْرَةُ رَجُلاً، فَغَارَ عَلَى زَوْجَتِهِ، فَعَلَيْهِ أَنْ يَأْتِيَ بِالْمَرْأَةِ أَمَامَ الرَّبِّ وَيُمَارِسُ عَلَيْهَا الْكَاهِنُ كُلَّ هَذِهِ الشَّعَائِرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","وَلا يُعَاقَبُ الرَّجُلُ إِذَا أَصَابَ الضَّرَرُ زَوْجَتَهُ الْمُذْنِبَةَ، أَمَّا هِيَ فَتَحْمِلُ قَصَاصَ خَطِيئَتِهَا». ");
INSERT INTO arbnav_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: أَيُّ رَجُلٍ أَوِ امْرَأَةٍ تَعَهَّدَ بِنَذْرٍ خَاصٍّ يَتَنَسَّكُ فِيهِ لِلرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","فَلْيَمْتَنِعْ عَنِ الْخَمْرِ وَالْمُسْكِرِ، وَلا يَشْرَبْ خَلَّ الْخَمْرِ وَلا خَلَّ الْمُسْكِرِ أَوْ نَقِيعَ الْعِنَبِ، وَلا يَأْكُلْ عِنَباً رَطْباً وَلا يَابِساً. ");
INSERT INTO arbnav_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","لَا يَذُقْ كُلَّ أَيَّامِ نَذْرِهِ شَيْئاً مِنْ نِتَاجِ الْكَرْمَةِ حَتَّى بُذُورِ الْعِنَبِ وَقِشْرِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","وَلا يَحْلِقْ رَأْسَهُ طَوَالَ مُدَّةِ نَذْرِهِ إِلَى أَنْ تَتِمَّ الأَيَّامُ الَّتِي نَذَرَ فِيهَا نَفْسَهُ لِلرَّبِّ، لأَنَّهُ مُقَدَّسٌ، فَعَلَيْهِ أَنْ يُرْخِيَ خُصَلَ شَعْرِ رَأْسِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","لَا يَقْرُبْ جَسَدَ مَيْتٍ كُلَّ أَيَّامِ نَذْرِهِ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","سَوَاءٌ كَانَ الْمَيْتُ أَبَاهُ أَمْ أُمَّهُ أَمْ أَخَاهُ أَمْ أُخْتَهُ فَلا يَتَنَجَّسْ مِنْ أَجْلِهِمْ عِنْدَ مَوْتِهِمْ، لأَنَّ رَمْزَ نُسْكِ إِلَهِهِ عَلَى رَأْسِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","وَيَكُونُ كُلَّ أَيَّامِ نَذْرِهِ مُقَدَّساً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","وَإذَا تَنَجَّسَ شَعْرُ انْتِذَارِهِ عَلَى أَثَرِ مَوْتِ أَحَدٍ عِنْدَهُ بَغْتَةً، يَحْلِقُ شَعْرَهُ بَعْدَ ذَلِكَ بِسَبْعَةِ أَيَّامٍ فَيَطْهُرُ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ثُمَّ فِي الْيَوْمِ الثَّامِنِ يَأْتِي بِيَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ إِلَى الْكَاهِنِ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","فَيُقَدِّمُ الْكَاهِنُ أَحَدَهُمَا ذَبِيحَةَ خَطِيئَةٍ وَالآخَرَ مُحْرَقَةً، وَيُكَفِّرُ عَنْهُ خَطِيئَتَهُ لِوُجُودِهِ أَمَامَ جُثَّةِ مَيْتٍ، وَيُقَدِّسُ رَأْسَهُ فِي ذَلِكَ الْيَوْمِ بِعَيْنِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","وَلا تُحْسَبُ لَهُ أَيَّامُ نَذْرِهِ الَّتِي سَبَقَتْ تَنْجِيسَهُ بِسَبَبِ الْمَيْتِ، وَعَلَيْهِ أَنْ يَبْدَأَ عَدَّ أَيَّامِ فَتْرَةِ نَذْرِهِ مِنْ جَدِيدٍ، وَيَأْتِيَ بِحَمَلٍ حَوْلِيٍّ وَيُقَدِّمَهُ ذَبِيحَةَ إِثْمٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","وَهَذِهِ هِيَ شَرِيعَةُ النَّذِيرِ عِنْدَمَا يَسْتَوْفِي أَيَّامَ نَذْرِهِ: يَأْتِي إِلَى مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، ");
INSERT INTO arbnav_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","فَيُقَدِّمُ قُرْبَانَهُ لِلرَّبِّ حَمَلاً حَوْلِيًّا، بِلا عَيْبٍ، لِيَكُونَ مُحْرَقَةً، وَنَعْجَةً حَوْلِيَّةً، صَحِيحَةً، لِتَكُونَ ذَبِيحَةَ خَطِيئَةٍ، وَكَبْشاً سَلِيماً لِيَكُونَ ذَبِيحَةَ سَلامَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","فَضْلاً عَنْ سَلٍّ مِنْ كَعْكِ فَطِيرٍ مَعْجُونٍ بِزَيْتٍ، وَرِقَاقٍ غَيْرِ مُخْتَمِرَةٍ مَدْهُونَةٍ بِالزَّيْتِ مَعَ تَقْدِمَةِ دَقِيقٍ وَخَمْرٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","فَيُقَدِّمُهَا الْكَاهِنُ أَمَامَ الرَّبِّ ذَبِيحَةَ خَطِيئَتِهِ وَمُحْرَقَتَهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ثُمَّ يُقَرِّبُ كَبْشَ ذَبِيحَةِ السَّلامِ مَعَ سَلِّ كَعْكِ الْفَطِيرِ. وَأَخِيراً يَرْفَعُ الْكَاهِنُ تَقْدِمَةَ الدَّقِيقِ وَالْخَمْرَ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ثُمَّ يَحْلِقُ النَّذِيرُ شَعْرَ انْتِذَارِهِ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، وَيُحْرِقُهُ عَلَى نَارِ ذَبِيحَةِ السَّلامِ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","ثُمَّ يَأْخُذُ الْكَاهِنُ كَتِفَ الْكَبْشِ بَعْدَ سَلْقِهِ، وَكَعْكَةَ فَطِيرٍ وَاحِدَةً وَرِقَاقَةً وَاحِدَةً. وَيَضَعُهَا بَيْنَ يَدَيِ النَّذِيرِ بَعْدَ حَلْقِهِ شَعْرَ انْتِذَارِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","وَيُرَجِّحُهَا الْكَاهِنُ أَمَامَ الرَّبِّ، فَتَكُونُ نَصِيباً مُقَدَّساً لِلْكَاهِنِ مَعَ صَدْرِ التَّرْجِيحِ وَسَاقِ الذَّبِيحَةِ. وَبَعْدَ ذَلِكَ يَشْرَبُ النَّذِيرُ خَمْراً. ");
INSERT INTO arbnav_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","هَذِهِ هِيَ شَرِيعَةُ النَّذِيرِ الَّذِي يَنْذُرُ تَقْدِمَةً لِلرَّبِّ وَقْتَ نُسْكِهِ، فَضْلاً عَنْ تَقْدِمَاتِهِ الطَّوْعِيَّةِ الَّتِي يَبْذُلُهَا. وَعَلَيْهِ أَنْ يَفِيَ بِمَا نَذَرَ حَسَبَ شَرِيعَةِ انْتِذَارِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«أَوْصِ هَرُونَ وَأَبْنَاءَهُ قَائِلاً: هَذَا مَا يُبَارِكُونَ بِهِ بَنِي إِسْرَائِيلَ قَائِلِينَ لَهُمْ: ");
INSERT INTO arbnav_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","يُبَارِكُكَ الرَّبُّ وَيَحْرُسُكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","يُضِيءُ الرَّبُّ بِوَجْهِهِ عَلَيْكَ وَيَرْحَمُكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","يَلْتَفِتُ الرَّبُّ بِوَجْهِهِ إِلَيْكَ وَيَمْنَحُكَ سَلاماً. ");
INSERT INTO arbnav_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","وَهَكَذَا يَجْعَلُونَ اسْمِي عَلَى بَنِي إِسْرَائِيلَ وَأَنَا أُبَارِكُهُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","وَعِنْدَمَا انْتَهَى مُوسَى مِنْ نَصْبِ الْمَسْكَنِ وَمَسْحِهِ وَتَقْدِيسِهِ، مَعَ سَائِرِ أَوَانِيهِ، وَالْمَذْبَحِ مَعَ أَمْتِعَتِهِ كُلِّهَا الَّتِي مَسَحَهَا وَقَدَّسَهَا، ");
INSERT INTO arbnav_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","أَحْضَرَ رُؤَسَاءُ أَسْبَاطِ إِسْرَائِيلَ قَرَابِينَهُمْ، وَهُمْ قَادَةُ عَشَائِرِهِمْ أَيْضاً، الَّذِينَ أَشْرَفُوا عَلَى تَنْظِيمِ الإِحْصَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","وَجَاءُوا بِها أَمَامَ الرَّبِّ، فَكَانَتْ سِتَّ عَرَبَاتٍ مُغَطَّاةٍ يَجُرُّهَا اثْنَا عَشَرَ ثَوْراً، ثَوْرٌ لِكُلِّ رَئِيسٍ وَعَرَبَةٌ لِكُلِّ رَئِيسَيْنِ، وَقَدَّمُوهَا أَمَامَ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","فَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«اقْبَلِ الْقَرَابِينَ مِنْهُمْ لِتُسْتَخْدَمَ فِي عَمَلِ خَيْمَةِ الاجْتِمَاعِ، وَأَعْطِهَا لِلّاوِيِّينَ؛ لِكُلِّ وَاحِدٍ حَسَبَ خِدْمَتِهِ الْمَنُوطَةِ بِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","فَأَخَذَ مُوسَى الْعَرَبَاتِ وَالثِّيرَانَ وَقَدَّمَهَا لِلّاوِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","فَأَعْطَى اثْنَيْنِ مِنَ الْعَرَبَاتِ مَعَ أَرْبَعَةِ ثِيرَانٍ لِبَنِي جَرْشُونَ، وَفْقاً لِمَا تَتَطَلَّبُهُ خِدْمَتُهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","وَأَرْبَعاً مِنَ الْعَرَبَاتِ وَثَمَانِيَةَ ثِيرَانٍ لِبَنِي مَرَارِي، وَفْقاً لِمَا تَتَطَلَّبُهُ خِدْمَتُهُمْ تَحْتَ إِشْرَافِ إِيثَامَارَ بْنِ هَرُونَ الْكَاهِنِ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","أَمَّا بَنُو قَهَاتَ فَلَمْ يَحْظَوْا بِنَصِيبٍ مِنْهَا إِذْ تَوَجَّبَ عَلَيْهِمْ أَنْ يَحْمِلُوا الأَشْيَاءَ الْمُقَدَّسَةَ عَلَى أَكْتَافِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","وَعِنْدَ تَدْشِينِ الْمَذْبَحِ وَمَسْحِهِ قَدَّمَ الرُّؤَسَاءُ قَرَابِينَهُمْ أَمَامَ الْمَذْبَحِ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","فَقَالَ الرَّبُّ لِمُوسَى: «لِيُحْضِرْ رَئِيسٌ وَاحِدٌ فِي كُلِّ يَوْمٍ قُرْبَانَهُ لِتَدْشِينِ الْمَذْبَحِ». ");
INSERT INTO arbnav_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","فَكَانَ نَحْشُونُ بْنُ عَمِّينَادَابَ مِنْ سِبْطِ يَهُوذَا هُوَ الَّذِي قَدَّمَ قُرْبَانَهُ فِي الْيَوْمِ الأَوَّلِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ بِتَقْدِمَةٍ مِنْ دَقِيقٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً وَاحِداً حَوْلِيًّا، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ، فَكَانَتْ هَذِهِ قُرْبَانَ نَحْشُونَ بْنِ عَمِّينَادَابَ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","وَفِي الْيَوْمِ الثَّانِي أَحْضَرَ نَثَنَائِيلُ بْنُ صُوغَرَ رَئِيسُ سِبْطِ يَسَّاكَرَ قُرْبَانَهُ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ بِتَقْدِمَةٍ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً حَوْلِيًّا وَاحِداً، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ فَكَانَتْ هَذِهِ قُرْبَانَ نَثَنَائِيلَ بْنِ صُوغَرَ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","وَفِي الْيَوْمِ الثَّالِثِ أَحْضَرَ رَئِيسُ سِبْطِ زَبُولُونَ، أَلِيآبُ بْنُ حِيلُونَ قُرْبَانَهُ ");
INSERT INTO arbnav_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ بِتَقْدِمَةٍ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مَئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً حَوْلِيًّا وَاحِداً، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ فَكَانَتْ هَذِهِ قُرْبَانَ أَلِيآبَ بْنِ حِيلُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","وَفِي الْيَوْمِ الرَّابِعِ أَحْضَرَ رَئِيسُ بَنِي رَأُوبَيْنَ، أَلِيصُورُ بْنُ شَدَيْئُورَ قُرْبَانَهُ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ بِتَقْدِمَةِ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً حَوْلِيًّا وَاحِداً، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ فَكَانَتْ هَذِهِ قُرْبَانَ أَلِيصُورَ بْنِ شَدَيْئُورَ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","وَفِي الْيَوْمِ الْخَامِسِ أَحْضَرَ رَئِيسُ بَنِي شِمْعُونَ، شَلُومِيئِيلُ بْنُ صُورِيشَدَّاي قُرْبَانَهُ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً حَوْلِيًّا وَاحِداً، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ. فَكَانَتْ هَذِهِ قُرْبَانَ شَلُومِيئِيلَ بْنِ صُورِيشَدَّاي. ");
INSERT INTO arbnav_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","وَفِي الْيَوْمِ السَّادِسِ أَحْضَرَ رَئِيسُ بَنِي جَادَ، أَلِيَاسَافُ بْنُ دَعُوئِيلَ قُرْبَانَهُ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً حَوْلِيًّا وَاحِداً، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ. فَكَانَتْ هَذِهِ قُرْبَانَ أَلِيَاسَافَ بْنِ دَعُوئِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","وَفِي الْيَوْمِ السَّابِعِ أَحْضَرَ رَئِيسُ بَنِي أَفْرَايِمَ أَلِيشَمَعُ بْنُ عَمِّيهُودَ قُرْبَانَهُ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً حَوْلِيًّا وَاحِداً، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ. فَكَانَتْ هَذِهِ قُرْبَانَ أَلِيشَمَعَ بْنِ عَمِّيهُودَ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","وَفِي الْيَوْمِ الثَّامِنِ أَحْضَرَ رَئِيسُ بَنِي مَنَسَّى، جَمْلِيئِيلُ بْنُ فَدَهْصُورَ قُرْبَانَهُ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً حَوْلِيًّا وَاحِداً، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ. فَكَانَتْ هَذِهِ قُرْبَانَ جَمْلِيئِيلَ بْنِ فَدَهْصُورَ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","وَفِي الْيَوْمِ التَّاسِعِ أَحْضَرَ رَئِيسُ بَنِي بِنْيَامِينَ، أَبِيدَنُ بْنُ جِدعُونِي قُرْبَانَهُ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً حَوْلِيًّا وَاحِداً، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ. فَكَانَتْ هَذِهِ قُرْبَانَ أَبِيدَنَ بْنِ جِدْعُونِي. ");
INSERT INTO arbnav_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","وَفِي الْيَوْمِ الْعَاشِرِ أَحْضَرَ رَئِيسُ بَنِي دَانٍ، أَخِيعَزَرُ بْنُ عَمِّيشَدَّاي قُرْبَانَهُ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً حَوْلِيًّا وَاحِداً، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ. فَكَانَتْ هَذِهِ قُرْبَانَ أَخِيعَزَرَ بْنِ عَمِّيشَدَّاي. ");
INSERT INTO arbnav_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","وَفِي الْيَوْمِ الْحَادِي عَشَرَ أَحْضَرَ رَئِيسُ أَشِيرَ، فَجْعِيئِيلُ بْنُ عُكْرَنَ قُرْبَانَهُ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً حَوْلِيًّا وَاحِداً، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ. فَكَانَتْ هَذِهِ قُرْبَانَ فَجْعِيئِيلَ بْنِ عُكْرَنَ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","وَفِي الْيَوْمِ الثَّانِي عَشَرَ أَحْضَرَ رَئِيسُ بَنِي نَفْتَالِي، أَخِيرَعُ بْنُ عِينَنَ قُرْبَانَهُ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","فَكَانَ طَبَقاً فِضِّيًّا وَاحِداً وَزْنُهُ مِئَةٌ وَثَلاثُونَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) وَمِنْضَحَةً فِضِّيَّةً وَاحِدَةً وَزْنُهَا سَبْعُونَ شَاقِلاً (نَحْوَ ثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. وَكِلا الإِنَاءَيْنِ مَمْلُوءَانِ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","وَصَحْناً وَاحِداً وَزْنُهُ عَشْرَةُ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) مِنْ ذَهَبٍ مَلِيئاً بِالْبَخُورِ، ");
INSERT INTO arbnav_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","وَثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَخَرُوفاً حَوْلِيًّا وَاحِداً، لِتَكُونَ كُلُّهَا مُحْرَقَةً، ");
INSERT INTO arbnav_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","وَتَيْساً وَاحِداً لِذَبِيحَةِ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","كَمَا قَرَّبَ ثَوْرَيْنِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةَ تُيُوسٍ وَخَمْسَةَ حُمْلانٍ حَوْلِيَّةٍ لِذَبِيحَةِ السَّلامِ. فَكَانَتْ هَذِهِ قُرْبَانَ أَخِيرَعَ بْنِ عِينَنَ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","فَهَذِهِ كَانَتْ جُمْلَةَ تَقْدِمَاتِ رُؤَسَاءِ أَسْبَاطِ إِسْرَائِيلَ يَوْمَ تَدْشِينِ الْمَذْبَحِ وَمَسْحِهِ، اثْنَا عَشَرَ طَبَقاً فِضِّيًّا، وَاثْنَتَا عَشْرَةَ مِنْضَحَةً فِضِّيَّةً وَاثْنَا عَشَرَ صَحْناً ذَهَبِيًّا. ");
INSERT INTO arbnav_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","وَكَانَ وَزْنُ كُلِّ طَبَقٍ مِئَةً وَثَلاثِينَ شَاقِلاً (نَحْوَ أَلْفٍ وَخَمْسِ مِئَةٍ وَسِتِّينَ جِرَاماً) مِنَ الْفِضَّةِ، وَوَزْنُ كُلِّ مِنْضَحَةٍ سَبْعِينَ شَاقِلاً (نَحْوَ ثَمَانِيَةِ آلافٍ وَثَمَانِي مِئَةٍ وَأَرْبَعِينَ جِرَاماً) فَكَانَ مَجْمُوعُ وَزْنِ فِضَّةِ الآنِيَةِ أَلْفَيْنِ وَأَرْبَعَ مِئَةِ شَاقِلٍ (نَحْوَ ثَمَانِيَةِ وَعِشْرِينَ أَلْفاً وَثَمَانِ مِئَةِ جِرَامٍ) وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","أَمَّا صُحُونُ الذَّهَبِ الاثْنَا عَشَرَ الْمَمْلُوءَةُ بِالْبَخُورِ، فَكَانَ وَزْنُ كُلٍّ مِنْهَا عَشْرَةَ شَوَاقِلَ (نَحْوَ مِئَةٍ وَعِشْرِينَ جِرَاماً) وَفْقاً لِلْوَزْنِ المُعْتَمَدِ فِي الْقُدْسِ وَهِيَ بِمَجْمُوعِهَا تُعَادِلُ مِئَةً وَعِشْرِينَ شَاقِلاً (نَحْوَ أَلْفٍ وَأَرْبَعِ مِئَةٍ وَأَرْبَعِينَ جِرَاماً). ");
INSERT INTO arbnav_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","وَكَانَ مَجْمُوعُ ثِيرَانِ الْمُحْرَقَةِ اثْنَيْ عَشَرَ ثَوْراً، وَالْكِبَاشِ اثْنَيْ عَشَرَ كَبْشاً، وَالْخِرَافِ الْحَوْلِيَّةِ اثْنَيْ عَشَرَ خَرُوفاً فَضْلاً عَنْ تَقْدِمَتِهَا، وَالتُّيُوسِ الاثْنَيْ عَشَرَ لِذَبِيحَةِ الْخَطِيئَةِ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","وَكَانَ مَجْمُوعُ ثِيرَانِ ذَبِيحَةِ السَّلامِ أَرْبَعَةً وَعِشْرِينَ ثَوْراً، وَالْكِبَاشِ سِتِّينَ كَبْشاً، وَالتُّيُوسِ سِتِّينَ تَيْساً، وَالْحُمْلانِ الْحَوْلِيَّةِ سِتِّينَ حَمَلاً. هَذِهِ قَرَابِينُ تَدْشِينِ الْمَذْبَحِ بَعْدَ مَسْحِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","وَعِنْدَمَا دَخَلَ مُوسَى إِلَى خَيْمَةِ الاجْتِمَاعِ لِيَتَكَلَّمَ مَعَ الرَّبِّ سَمِعَ الصَّوْتَ يُخَاطِبُهُ مِنْ عَلَى الْغِطَاءِ الَّذِي فَوْقَ تَابُوتِ الشَّهَادَةِ مِنْ بَيْنِ الْكَرُوبَيْنِ، فَكَلَّمَهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«أَوْصِ هَرُونَ وَقُلْ لَهُ: مَتَى أَضَأْتَ سُرُجَ الْمَنَارَةِ السَّبْعَةَ، فَاجْعَلْ نُورَهَا يَنْعَكِسُ إِلَى الأَمَامِ». ");
INSERT INTO arbnav_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","فَنَفَّذَ هَرُونُ الأَمْرَ، إِذْ جَعَلَ أَنْوَارَ الْمَنَارَةِ تَنْعَكِسُ أَمَامَهَا كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","أَمَّا الْمَنَارَةُ فَكَانَتْ مَطْرُوقَةً مِنْ ذَهَبٍ هِيَ وَسَاقُهَا وَزَهْرُهَا وَفْقاً لِلْمِثَالِ الَّذِي أَرَاهُ الرَّبُّ لِمُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«أَفْرِزِ اللّاوِيِّينَ مِنْ بَيْنِ بَنِي إِسْرَائِيلَ وَطَهِّرْهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","وَهَذَا مَا تَفْعَلُهُ لِتَطْهِيرِهِمْ: رُشَّ عَلَيْهِمْ مَاءَ الْخَطِيئَةِ، ثُمَّ لِيَحْلِقُوا شَعْرَ جَسَدِهِمْ، وَيَغْسِلُوا ثِيَابَهُمْ فَيَتَطَهَّرُوا. ");
INSERT INTO arbnav_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ثُمَّ لِيُحْضِرُوا ثَوْراً مَعَ تَقْدِمَةٍ مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، وَعِجْلاً آخَرَ لِيَكُونَ ذَبِيحَةَ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","وَتُوْقِفُ اللّاوِيِّينَ أَمَامَ خَيْمَةِ الاجْتِمَاعِ وَتَجْمَعُ كُلَّ شَعْبِ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","وَتُقَدِّمُ اللّاوِيِّينَ أَمَامَ الرَّبِّ فَيَضَعُ بَنُو إِسْرَائِيلَ أَيْدِيَهُمْ عَلَيْهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","وَلْيُرَجِّحْ هَرُونُ يَدَيْهِ أَمَامَ الرَّبِّ كَرَمْزٍ لِتَقْدِيمِ اللّاوِيِّينَ مِنْ بَيْنِ بَنِي إِسْرَائِيلَ، لِيَقُومُوا بِخِدْمَةِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ثُمَّ يَضَعُ اللّاوِيُّونَ أَيْدِيَهُمْ عَلَى رَأْسَيِ الْعِجْلَيْنِ، فَتُقَرِّبُ أَحَدَهُمَا ذَبِيحَةَ خَطِيئَةٍ وَالآخَرَ مُحْرَقَةً لِلرَّبِّ تَكْفِيراً عَنِ اللّاوِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","وَاجْعَلِ اللّاوِيِّينَ يَقِفُونَ أَمَامَ هَرُونَ وَأَبْنَائِهِ وَقَدِّمْهُمْ كَتَقْدِمَةِ تَرْجِيحٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","وَأَفْرِزِ اللّاوِيِّينَ مِنْ بَيْنِ شَعْبِ إِسْرَائِيلَ لِيَكُونُوا مِلْكاً لِي ");
INSERT INTO arbnav_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","ثُمَّ يُقْبِلُ اللّاوِيُّونَ عَلَى خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ، فَتُطَهِّرُهُمْ وَتَجْعَلُهُمْ تَقْدِمَةَ تَرْجِيحٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","لأَنَّهُمْ قَدْ وُهِبُوا لِي مِنْ بَيْنِ بَنِي إِسْرَائِيلَ، فَقَدِ اسْتَعَضْتُ بِهِمْ عَنْ كُلِّ بِكْرٍ فَاتِحِ رَحِمٍ مِنْ إِسْرَائِيلَ، ");
INSERT INTO arbnav_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","لأَنَّ كُلَّ بِكْرٍ فِي إِسْرَائِيلَ مِنَ النَّاسِ وَالْبَهَائِمِ هُوَ لِي، إِذْ قَدَّسْتُهُمْ لِي يَوْمَ قَضَيْتُ عَلَى كُلِّ بِكْرٍ فِي دِيَارِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","فَاسْتَعَضْتُ بِاللّاوِيِّينَ عَنْ كُلِّ بِكْرٍ لِي مِنْ شَعْبِ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","وَقَدْ وَهَبْتُ اللّاوِيِّينَ لِهَرُونَ وَأَبْنَائِهِ مِنْ بَيْنِ شَعْبِ إِسْرَائِيلَ، لِيَقُومُوا عَلَى خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ، عِوَضاً عَنْ شَعْبِ إِسْرَائِيلَ، وَلِلتَّكْفِيرِ عَنْهُمْ، لِئَلّا يَتَفَشَّى وَبَأٌ فِي إِسْرَائِيلَ عِنْدَ اقْتِرَابِهِمْ مِنَ الْقُدْسِ». ");
INSERT INTO arbnav_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","فَفَعَلَ مُوسَى وَهَرُونُ وَشَعْبُ إِسْرَائِيلَ لِلّاوِيِّينَ، بِكُلِّ دِقَّةٍ، جَمِيعَ مَا أَمَرَ الرَّبُّ بِهِ ");
INSERT INTO arbnav_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","فَتَطَهَّرَ اللّاوِيُّونَ وَغَسَّلُوا ثِيَابَهُمْ وَأَحْضَرَهُمْ هَرُونُ أَمَامَ الرَّبِّ كَتَقْدِمَةِ تَرْجِيحٍ وَكَفَّرَ عَنْهُمْ تَطْهِيراً لَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","وَبَعْدَ ذَلِكَ أَقْبَلَ اللّاوِيُّونَ عَلَى خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ تَحْتَ إِشْرَافِ هَرُونَ وَأَبْنَائِهِ، وَهَكَذَا تَمَّ تَنْفِيذُ كُلِّ مَا أَمَرَ الرَّبُّ بِهِ بِشَأْنِ اللّاوِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«هَذِهِ هِيَ شَرِيعَةُ اللّاوِيِّينَ: كُلُّ لاوِيٍّ عُمْرُهُ خَمْسٌ وَعِشْرُونَ سَنَةً فَمَا فَوْقُ، يُجَنَّدُ فِي خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","وَلَكِنَّهُمْ يَتَقَاعَدُونَ عَنِ الْخِدْمَةِ عِنْدَ بُلُوغِهِمِ الْخَمْسِينَ مِنَ الْعُمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","إِنَّمَا يُمْكِنُهُمْ بَعْدَ سِنِّ الْخَمْسِينَ أَنْ يُسَاعِدُوا إِخْوَتَهُمُ الْقَائِمِينَ بِوَاجِبَاتِهِمْ، وَلَكِنَّهُمْ لَا يَتَوَلَّوْنَ هُمُ الْخِدْمَةَ. فَهَذَا مَا يَتَوَجَّبُ عَلَيْكَ أَنْ تَعْهَدَ بِهِ للّاوِيِّينَ مِنْ مَسْؤولِيَّاتٍ». ");
INSERT INTO arbnav_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","وَفِي الشَّهْرِ الأَوَّلِ مِنَ السَّنَةِ الثَّانِيَةِ لِخُرُوجِهِمْ مِنْ دِيَارِ مِصْرَ، قَالَ الرَّبُّ لِمُوسَى فِي صَحْرَاءِ سِينَاءَ: ");
INSERT INTO arbnav_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«لِيَحْتَفِلْ شَعْبُ إِسْرَائِيلَ بِالْفِصْحِ فِي أَوَانِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","احْتَفِلُوا بِهِ فِي الْيَوْمِ الرَّابِعَ عَشَرَ مِنَ الشَّهْرِ الأَوَّلِ بَيْنَ غُرُوبِ الشَّمْسِ وَحُلُولِ الظَّلامِ قَائِمِينَ بِكُلِّ شَعَائِرِهِ وَأَحْكَامِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","فَأَمَرَ مُوسَى الإِسْرَائِيلِيِّينَ أَنْ يَحْتَفِلُوا بِالْفِصْحِ، ");
INSERT INTO arbnav_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","فَاحْتَفَلُوا بِهِ فِي صَحْرَاءِ سِينَاءَ فِي الْيَوْمِ الرَّابِعَ عَشَرَ مِنَ الشَّهْرِ الأَوَّلِ بَيْنَ غُرُوبِ الشَّمْسِ وَحُلُولِ الظَّلامِ، طِبْقاً لِكُلِّ مَا أَمَرَ الرَّبُّ بِهِ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","إِلّا أَنَّ قَوْماً كَانُوا قَدْ لَمَسُوا مَيْتاً فَتَنَجَّسُوا، فَلَمْ يَحِلَّ لَهُمُ الاحْتِفَالُ بِالْفِصْحِ فِي ذَلِكَ الْيَوْمِ، فَمَثَلُوا أَمَامَ مُوسَى وَهَرُونَ، ");
INSERT INTO arbnav_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","وَسَأَلُوهُ: «إِنَّنَا مُتَنَجِّسُونَ لأَنَّنَا لَمَسْنَا مَيْتاً، فَلِمَاذَا نُحْرَمُ مِنْ تَقْدِيمِ قُرْبَانِ الرَّبِّ فِي أَوَانِهِ مِنْ دُونِ شَعْبِ إِسْرَائِيلَ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","فَأَجَابَهُمْ مُوسَى: «انْتَظِرُوا رَيْثَمَا يُبَلِّغُنِي الرَّبُّ أَمْرَهُ بِشَأْنِكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","فَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«أَوْصِ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: فِي وُسْعِ كُلِّ إِنْسَانٍ مِنْكُمْ وَمِنْ أَعْقَابِكُمْ تَنَجَّسَ لِلَمْسِهِ مَيْتاً أَوْ كَانَ فِي سَفَرٍ بَعِيدٍ، أَنْ يَحْتَفِلَ بِفِصْحِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","احْتَفِلُوا بِهِ فِي الْيَوْمِ الرَّابِعَ عَشَرَ مِنَ الشَّهْرِ الثَّانِي بَيْنَ غُرُوبِ الشَّمْسِ وَحُلُولِ الظَّلامِ فَتَأْكُلُوا الْفِصْحَ مَعَ فَطِيرٍ وَأَعْشَابٍ مُرَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","لَا تَتْرُكُوا مِنْهُ شَيْئاً إِلَى الصَّبَاحِ، وَلا تَكْسِرُوا مِنْهُ عَظْماً. احْتَفِلُوا بِهِ طِبْقاً لِشَعَائِرِ الْفِصْحِ كُلِّهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","وَلَكِنْ مَنْ كَانَ طَاهِراً وَلَيْسَ فِي سَفَرٍ، وَأَغْفَلَ الاحْتِفَالَ بِالْفِصْحِ، فَإِنَّهُ يُسْتَأْصَلُ مِنْ بَيْنِ شَعْبِهِ، لأَنَّهُ لَمْ يُقَدِّمْ قُرْبَانَ الرَّبِّ فِي أَوَانِهِ. ذَلِكَ الإِنْسَانُ يَتَحَمَّلُ عِقَابَ خَطِيئَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","وَإذَا حَلَّ عِنْدَكُمْ غَرِيبٌ فَلْيَحْتَفِلْ بِالْفِصْحِ طِبْقاً لِشَعَائِرِ الْفِصْحِ وَأَحْكَامِهِ، فَتَكُونَ لَكُمْ فَرِيضَةً وَاحِدَةً لِلْغَرِيبِ وَلِلْمُوَاطِنِ عَلَى حَدٍّ سَوَاءٍ». ");
INSERT INTO arbnav_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","وَفِي الْيَوْمِ الَّذِي نُصِبَ فِيهِ الْمَسْكَنُ غَطَّتِ السَّحَابَةُ خَيْمَةَ الشَّهَادَةِ. وَفِي الْمَسَاءِ بَدَا وَكَأَنَّ عَلَى الْمَسْكَنِ نَاراً بَقِيَتْ حَتَّى الصَّبَاحِ. ");
INSERT INTO arbnav_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","وَاسْتَمَرَّ الأَمْرُ عَلَى هَذِهِ الْحَالِ، إِذْ كَانَتِ السَّحَابَةُ تُغَطِّي الْمَسْكَنَ نَهَاراً، وَتَتَحَوَّلُ إِلَى مَا يُشْبِهُ النَّارَ لَيْلاً. ");
INSERT INTO arbnav_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","وَكُلَّمَا ارْتَفَعَتِ السَّحَابَةُ عَنِ الْخَيْمَةِ كَانَ عَلَى شَعْبِ إِسْرَائِيلَ الارْتِحَالُ، وَحَيْثُمَا حَلَّتِ السَّحَابَةُ كَانُوا يَنْزِلُونَ هُنَاكَ، ");
INSERT INTO arbnav_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","فَكَانَ بَنُو إِسْرَائِيلَ يَرْتَحِلُونَ حَسَبَ قَوْلِ الرَّبِّ، وَبِمُوْجِبِ أَمْرِهِ كَانُوا يَنْزِلُونَ، وَيَمْكُثُونَ مُقِيمِينَ طَوَالَ أَيَّامِ حُلُولِ السَّحَابَةِ عَلَى الْمَسْكَنِ. ");
INSERT INTO arbnav_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","وَإِنْ طَالَ أَمَدُ حُلُولِ السَّحَابَةِ عَلَى الْمَسْكَنِ أَيَّاماً كَثِيرَةً، كَانَ شَعْبُ إِسْرَائِيلَ يُطِيعُونَ أَمْرَ الرَّبِّ، وَيَلْبَثُونَ مُقِيمِينَ لَا يَرْتَحِلُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","وَكَانَتِ السَّحَابَةُ تُخَيِّمُ أَحْيَاناً عَلَى الْمَسْكَنِ أَيَّاماً قَلِيلَةً، فَكَانَ الإِسْرَائِيلِيُّونَ يَنْزِلُونَ حَسَبَ قَوْلِ الرَّبِّ، وَوَفْقاً لأَمْرِهِ كَانُوا يَرْتَحِلُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","وَإذَا حَلَّتِ السَّحَابَةُ مِنَ الْمَسَاءِ إِلَى الصَّبَاحِ ثُمَّ ارْتَفَعَتْ عِنْدَ الصَّبَاحِ فَإِنَّهُمْ كَانُوا يَرْتَحِلُونَ، وَكَذَلِكَ إِنْ حَلَّتْ يَوْماً وَلَيْلَةً ثُمَّ ارْتَفَعَتْ، كَانُوا يَرْتَحِلُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","أَوْ إِنْ مَكَثَتِ السَّحَابَةُ يَوْمَيْنِ أَوْ شَهْراً أَوْ سَنَةً، كَانَ الإِسْرَائِيلِيُّونَ يُقِيمُونَ وَلا يَرْتَحِلُونَ مَادَامَتِ السَّحَابَةُ حَالَّةً عَلَى الْمَسْكَنِ. وَمَتَى ارْتَفَعَتْ كَانُوا يَرْتَحِلُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","وَهَكَذَا كَانُوا فِي نُزُولِهِمْ وَرَحِيلِهِمْ يَأْتَمِرُونَ بِقَوْلِ الرَّبِّ، فَأَطَاعُوا أَوَامِرَ الرَّبِّ طِبْقاً لِمَا أَوْصَى بِهِ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«اصْنَعْ لَكَ بُوقَيْنِ مِنْ فِضَّةٍ مَطْرُوقَةٍ تَسْتَخْدِمُهُمَا لِدَعْوَةِ الشَّعْبِ، وَلإِعْلانِ نَفِيرِ الرَّحِيلِ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","فَحَالَمَا يُنْفَخُ فِيهِمَا يَجْتَمِعُ إِلَيْكَ الشَّعْبُ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","أَمَّا إِذَا نُفِخَ فِي بُوقٍ وَاحِدٍ، يَتَوَافَدُ إِلَيْكَ رُؤَسَاءُ أَسْبَاطِ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","وَعِنْدَمَا يَرْتَفِعُ نَفِيرُ هُتَافٍ، تَرْتَحِلُ الأَسْبَاطُ الْمُخَيِّمَةُ إِلَى الشَّرْقِ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","وَإذَا ارْتَفَعَ نَفِيرُ هُتَافٍ ثَانٍ تَرْتَحِلُ الأَسْبَاطُ النَّازِلَةُ إِلَى الْجَنُوبِ، وَهَكَذَا يُعْلَنُ عَنِ الارْتِحَالِ بِنَفِيرِ الْهُتَافِ. ");
INSERT INTO arbnav_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","أَمَّا عِنْدَ جَمْعِ الشَّعْبِ، فَانْفُخُوا بِالْبُوقَيْنِ، وَلَكِنْ مِنْ غَيْرِ هُتَافٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","وَيَكُونُ أَبْنَاءُ هَرُونَ هُمُ النَّافِخُونَ بِالأَبْوَاقِ، فَرِيضَةً دَائِمَةً لَكُمْ جِيلاً بَعْدَ جِيلٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","وَإِنْ ذَهَبْتُمْ لِمُحَارَبَةِ عَدُوٍّ فِي أَرْضِكُمْ يَضُرُّ بِكُمْ، فَاضْرِبُوا بِالأَبْوَاقِ، فَأَذْكُرَكُمْ وَأُخَلِّصَكُمْ مِنْ أَعْدَائِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","انْفُخُوا فِي الأَبْوَاقِ أَيْضاً فِي أَيَّامِ فَرَحِكُمْ وَفِي أَعْيَادِكُمْ وَرُؤُوسِ شُهُورِكُمْ، وَكَذَلِكَ عَلَى مُحْرَقَاتِكُمْ وَذَبَائِحِ سَلامِكُمْ، فَتَكُونَ لَكُمْ تَذْكَاراً أَمَامِي. أَنَا الرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","وَفِي الْيَوْمِ الْعِشْرِينَ مِنَ الشَّهْرِ الثَّانِي مِنَ السَّنَةِ الثَّانِيَةِ (الْعِبْرِيَّةِ) ارْتَفَعَتِ السَّحَابَةُ عَنْ مَسْكَنِ الشَّهَادَةِ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","فَارْتَحَلَ بَنُو إِسْرَائِيلَ فِي صَحْرَاءِ سِينَاءَ مِنْ مَكَانٍ إِلَى آخَرَ إِلَى أَنِ اسْتَقَرَّتِ السَّحَابَةُ فِي بَرِّيَّةِ فَارَانَ. ");
INSERT INTO arbnav_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","وَكَانَتْ هَذِهِ أَوَّلَ مَرَّةٍ يَرْتَحِلُونَ فِيهَا بِمُوْجِبِ التَّنْظِيمِ الْجَدِيدِ الَّذِي أَمَرَ بِهِ الرَّبُّ عَلَى لِسَانِ مُوسَى، ");
INSERT INTO arbnav_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","فَقَدِ ارْتَحَلَتْ أَوَّلاً مُخَيَّمَاتُ سِبْطِ يَهُوذَا طِبْقاً لِعَشَائِرِهِمْ، وَعَلَى رَأْسِهِمْ نَحْشُونُ بْنُ عَمِّينَادَابَ. ");
INSERT INTO arbnav_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ثُمَّ عَشَائِرُ سِبْطِ يَسَّاكَرَ، وَعَلَى رَأْسِهِمْ نَثَنَائِيلُ بْنُ صُوغَرَ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","وَتَلاهُمْ سِبْطُ زَبُولُونَ، وَعَلَى رَأْسِهِ آلِيآبُ بْنُ حِيلُونَ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ثُمَّ أُنْزِلَ الْمَسْكَنُ، فَارْتَحَلَ بَنُو جَرْشُونَ وَبَنُو مَرَارِي حَامِلِينَ الْمَسْكَنَ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","وَأَعْقَبَتْهُمْ مُخَيَّمَاتُ سِبْطِ رَأُوبَيْنَ وَفْقاً لِعَشَائِرِهِمْ، وَعَلَى رَأْسِهِمْ أَلِيصُورُ بْنُ شَدَيْئُورَ. ");
INSERT INTO arbnav_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ثُمَّ عَشَائِرُ سِبْطِ شِمْعُونَ، وَعَلَى رَأْسِهِمْ شَلُومِيئِيلُ بْنُ صُورِيشَدَّاي، ");
INSERT INTO arbnav_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","وَتَبِعَتْهُمْ عَشَائِرُ سِبْطِ جَادٍ، وَعَلَى رَأْسِهِمْ أَلِيَاسَافُ بْنُ دَعُوئِيلَ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ثُمَّ ارْتَحَلَ الْقَهَاتِيُّونَ حَامِلِينَ الْمَقْدِسَ إِلَى حَيْثُ كَانَ الْمَسْكَنُ قَدْ أُقِيمَ فِي انْتِظَارِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","وَارْتَحَلَتْ عَلَى أَثَرِهِمْ مُخَيَّمَاتُ أَفْرَايِمَ حَسَبِ عَشَائِرِهَا وَعَلَى رَأْسِهَا أَلِيشَمَعُ بْنُ عَمِّيهُودَ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ثُمَّ سِبْطُ مَنَسَّى وَعَلَى رَأْسِهِ جَمْلِيئِيلُ بْنُ فَدَهْصُورَ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","وَتَبِعَهُمْ سِبْطُ بِنْيَامِينَ، وَعَلَى رَأْسِهِ أَبِيدَنُ بْنُ جِدْعُونِي، ");
INSERT INTO arbnav_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ثُمَّ ارْتَحَلَتْ مُخَيَّمَاتُ سِبْطِ دَانٍ بِرَايَتِهِ مَعَ جَمِيعِ عَشَائِرِهِ، فِي مُؤَخَّرَةِ الْجَمَاعَةِ، وَكَانَ عَلَى رَأْسِهِ أَخِيعَزَرُ بْنُ عَمِّيشَدَّاي. ");
INSERT INTO arbnav_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","وَسِبْطِ أَشِيرَ وَعَلَى رَأْسِهِ فَجْعِيئِيلُ بْنُ عُكْرَنَ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","وَسِبْطِ نَفْتَالِي وَعَلَى رَأْسِهِ أَخِيرَعُ بْنُ عِينَنَ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","فَكَانَ هَذَا هُوَ النِّظَامُ الَّذِي سَارَتْ عَلَيْهِ أَسْبَاطُ بَنِي إِسْرَائِيلَ فِي أَثْنَاءِ رَحِيلِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","وَقَالَ مُوسَى لِحَمِيهِ حُوبَابَ بْنِ رَعُوئِيلَ الْمِدْيَانِيِّ: «إِنَّنَا رَاحِلُونَ إِلَى الأَرْضِ الَّتِي وَعَدَ الرَّبُّ أَنْ يَهَبَهَا لَنَا، فَتَعَالَ مَعْنَا، فَنُحْسِنَ إِلَيْكَ، لأَنَّ الرَّبَّ قَدْ وَعَدَ أَنْ يُحْسِنَ إِلَى إِسْرَائِيلَ». ");
INSERT INTO arbnav_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","فَقَالَ لَهُ: «لا أَذْهَبُ، بَلْ دَعْنِي أَمْضِي إِلَى أَرْضِي وَعَشِيرَتِي». ");
INSERT INTO arbnav_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","فَقَالَ مُوسَى: «لا تَتْرُكْنَا لأَنَّكَ تَعْرِفُ مَسَالِكَ الصَّحْرَاءِ وَمَوَاضِعَ الإِقَامَةِ فِيهَا، فَتَكُونَ لَنَا دَلِيلاً. ");
INSERT INTO arbnav_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","وَإِنْ رَافَقْتَنَا فَإِنَّنَا نُحْسِنُ إِلَيْكَ بِنَفْسِ الإِحْسَانِ الَّذِي يُحْسِنُ الرَّبُّ بِهِ إِلَيْنَا». ");
INSERT INTO arbnav_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","فَارْتَحَلُوا مِنْ عِنْدِ جَبَلِ الرَّبِّ مَسِيرَةَ ثَلاثَةِ أَيَّامٍ، وَكَانَ تَابُوتُ الرَّبِّ يَتَقَدَّمُهُمْ بَاحِثاً لَهُمْ عَنْ مَوْضِعِ إِقَامَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","وَكَانَتْ سَحَابَةُ الرَّبِّ تُظَلِّلُهُمْ نَهَاراً فِي أَثْنَاءِ ارْتِحَالِهِمْ مِنَ الْمُخَيَّمِ، ");
INSERT INTO arbnav_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","وَكَانَ مُوسَى يَقُولُ عِنْدَ ارْتِحَالِ التَّابُوتِ: «قُمْ يَا رَبُّ وَبَدِّدْ أَعْدَاءَكَ فَيَهْرُبَ مُبْغِضُوكَ مِنْ أَمَامِكَ» ");
INSERT INTO arbnav_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","وَكَانَ يَقُولُ عِنْدَ حُلُولِهِ: «ارْجِعْ يَا رَبُّ إِلَى عَشَرَاتِ أُلُوفِ إِسْرَائِيلَ». ");
INSERT INTO arbnav_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","وَرَاحَ الشَّعْبُ يَتَذَمَّرُ فِي مَسْمَعِ الرَّبِّ وَكَأَنَّ شَرّاً أَصَابَهُمْ، فَاحْتَدَمَ غَضَبُ الرَّبِّ عَلَيْهِمْ، وَانْدَلَعَتْ فِيهِمْ نَارُهُ وَأَحْرَقَتْ طَرَفَ الْمُخَيَّمِ، ");
INSERT INTO arbnav_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","فَصَرَخُوا إِلَى مُوسَى، فَصَلَّى مُوسَى إِلَى الرَّبِّ فَخَمِدَتِ النَّارُ، ");
INSERT INTO arbnav_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","فَدُعِيَ ذَلِكَ الْمَكَانُ «تَبْعِيرَةَ» (وَمَعْنَاهُ: اشْتِعَالٌ) لأَنَّ نَارَ الرَّبِّ اشْتَعَلَتْ فِيهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","وَاشْتَهَى أَخْلاطُ الأُمَمِ الْمُقِيمُونَ بَيْنَ بَنِي إِسْرَائِيلَ، مِمَّنْ خَرَجُوا مَعَهُمْ مِنْ مِصْرَ، طَعَامَ مِصْرَ، فَعَادَ بَنُو إِسْرَائِيلَ يَبْكُونَ قَائِلِينَ: «مَنْ يُطْعِمُنَا لَحْماً؟ ");
INSERT INTO arbnav_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","لَقَدْ تَذَكَّرْنَا سَمَكَ مِصْرَ الَّذِي كُنَّا نَأْكُلُهُ مَجَّاناً، وَالقِثَّاءَ وَالْبَطِّيخَ وَالْكُرَّاتَ وَالْبَصَلَ وَالثُّومَ، ");
INSERT INTO arbnav_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","أَمَّا الآنَ فَقَدْ فَقَدْنَا شَهِيَّتَنَا وَهُزِلْنَا، وَلَيْسَ أَمَامَ أَعْيُنِنَا سِوَى هَذَا الْمَنِّ». ");
INSERT INTO arbnav_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","وَكَانَ الْمَنُّ فِي حَجْمِ بُذُورِ الْكُزْبَرَةِ، وَشَكْلُهُ مُمَاثِلاً لِلْمُقْلِ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","وَكَانَ الشَّعْبُ يَطُوفُونَ لِيَجْمَعُوهُ ثُمَّ يَطْحَنُونَهُ بِالرَّحَى أَوْ يَدُقُّونَهُ فِي الْهَاوَنِ وَيَطْبُخُونَهُ فِي الْقُدُورِ أَوْ يَخْبِزُونَهُ عَلَى حِجَارَةٍ مُحَمَّاةٍ. وَكَانَ طَعْمُهُ كَطَعْمِ قَطَائِفَ بِزَيْتٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","وَكَانَ الْمَنُّ يَنْزِلُ بِنُزُولِ النَّدَى عَلَى الْمُخَيَّمِ فِي أَثْنَاءِ اللَّيْلِ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","فَلَمَّا سَمِعَ مُوسَى بُكَاءَ جَمِيعِ أَفْرَادِ الشَّعْبِ، كُلٍّ أَمَامَ بَابِ خَيْمَتِهِ، وَرَأَى احْتِدَامَ غَضَبِ الرَّبِّ الشَّدِيدِ اعْتَرَاهُ الاسْتِيَاءُ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","فَقَالَ مُوسَى لِلرَّبِّ: «لَمَاذَا أَسَأْتَ إِلَى عَبْدِكَ وَلَمْ تَرْضَ عَنْهُ حَتَّى إِنَّكَ حَمَّلْتَهُ مَسْؤولِيَّةَ هَذَا الشَّعْبِ؟ ");
INSERT INTO arbnav_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","أَلَعَلِّي حَبِلْتُ بِهِ أَوْ وَلَدْتُهُ، حَتَّى تَقُولَ لِي احْمِلْهُ فِي حِضْنِكَ كَمَا يَحْمِلُ الْمُرَبِّي الرَّضِيعَ، وَقُدْهُ إِلَى الأَرْضِ الَّتِي وَعَدْتَ بِها آبَاءَهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","مِنْ أَيْنَ أَجِيءُ بِلَحْمٍ يَكْفِي جَمِيعَ هَذَا الشَّعْبِ؟ فَإِنَّهُمْ يَبْكُونَ إِلَيَّ قَائِلِينَ: أَعْطِنَا لَحْماً لِنَأْكُلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","إِنَّنِي عَاجِزٌ عَنْ حَمْلِ عِبْءِ هَذَا الشَّعْبِ وَحْدِي لأَنَّهُ ثَقِيلٌ عَلَيَّ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","إِنْ كُنْتَ سَتُعَامِلُنِي هَكَذَا، فَاقْتُلْنِي، إِنْ حَظِيتُ بِرِضَاكَ، فَلا أَشْهَدُ بَلِيَّتِي». ");
INSERT INTO arbnav_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","فَقَالَ الرَّبُّ لِمُوسَى: «اجْمَعْ إِلَيَّ سَبْعِينَ رَجُلاً مِنَ رُؤَسَاءِ إِسْرَائِيلَ مِمَّنْ تَعْلَمُ أَنَّهُمْ حَقّاً شُيُوخُ الشَّعْبِ وَعُرَفَاؤُهُ، وَأَقْبِلْ بِهِمْ إِلَى خَيْمَةِ الاجْتِمَاعِ لِيَمْثُلُوا مَعَكَ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","فَأَنْزِلَ وَأُخَاطِبَكَ هُنَاكَ، وَآخُذَ مِنَ الرُّوحِ الَّذِي عَلَيْكَ وَأَضَعَ عَلَيْهِمْ، فَيُعِينُونَكَ فِي حَمْلِ مَسْؤولِيَّةِ الشَّعْبِ، فَلا تَحْمِلُهَا أَنْتَ وَحْدَكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","وَقُلْ لِلشَّعْبِ، أَنْ يَتَقَدَّسُوا لِلْغَدِ، فَيَأْكُلُوا لَحْماً، لأَنَّكُمْ قَدْ بَكَيْتُمْ فِي أُذُنَي الرَّبِّ مُتَسَائِلِينَ: مَنْ يُطْعِمُنَا لَحْماً؟ لَقَدْ كَانَ لَنَا خَيْرٌ فِي مِصْرَ. إِنَّ الرَّبَّ سَيُعْطِيكُمْ لَحْماً فَتَأْكُلُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","وَسَتَأْكُلُونَهُ لَا لِيَوْمٍ وَاحِدٍ، وَلا لِيَوْمَيْنِ، وَلا لِخَمْسَةِ أَيَّامٍ أَوْ لِعَشْرَةِ أَيَّامٍ وَلا لِعِشْرِينَ يَوْماً، ");
INSERT INTO arbnav_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","بَلْ لِشَهْرٍ كَامِلٍ إِلَى أَنْ تَعَافُوهُ وَيَخْرُجَ مِنْ أُنُوفِكُمْ، لأَنَّكُمْ رَفَضْتُمُ الرَّبَّ الَّذِي فِي وَسَطِكُمْ، وَبَكَيْتُمْ لَدَيْهِ قَائِلِينَ: لِمَاذَا خَرَجْنَا مِنْ مِصْرَ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","فَقَالَ مُوسَى: «هَذَا الشَّعْبُ الَّذِي أَنَا قَائِمٌ فِي وَسَطِهِ نَحْوَ سِتِّ مِئَةِ أَلْفِ رَجُلٍ، مَاعَدَا النَّسَاءَ وَالأَطْفَالَ، وَأَنْتَ تَقُولُ إِنَّكَ سَتُعْطِيهِمْ لَحْماً لِيَأْكُلُوا شَهْراً كَامِلاً، ");
INSERT INTO arbnav_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","فَمَهْمَا ذُبِحَ مِنْ غَنَمٍ وَبَقَرٍ أَيَكْفِيهِمْ؟ أَمْ يَكْفِيهِمْ لَوْ جُمِعَ كُلُّ سَمَكِ الْبَحْرِ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","فَقَالَ الرَّبُّ لِمُوسَى: «هَلْ تَعْجَزُ يَدُ الرَّبِّ؟ انْتَظِرِ الآنَ لِتَرَى إِنْ كَانَ يَتَحَقَّقُ كَلامِي أَمْ لا». ");
INSERT INTO arbnav_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","فَخَرجَ مُوسَى وَكَلَّمَ الشَّعْبَ بِمَا قَالَهُ الرَّبُّ، وَجَمَعَ سَبْعِينَ رَجُلاً مِنْ رُؤَسَائِهِمْ وَأَوْقَفَهُمْ حَوْلَ الْخَيْمَةِ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","فَنَزَلَ الرَّبُّ فِي سَحَابَةٍ وَخَاطَبَهُ، وَأَخَذَ مِنَ الرُّوحِ الْحَالِّ عَلَيْهِ وَوَضَعَهُ عَلَى السَّبْعِينَ رَئِيساً. فَلَمَّا حَلَّ عَلَيْهِمِ الرُّوحُ تَنَبَّأُوا لِفَتْرَةٍ وَتَوَقَّفُوا. ");
INSERT INTO arbnav_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","وَكَانَ قَدْ بَقِيَ اثْنَانِ مِنَ الشُّيُوخِ الْمُسَجَّلِينَ بَيْنَ السَّبْعِينَ فِي الْمُخَيَّمِ لَمْ يَأْتِيَا إِلَى الْخَيْمَةِ، اسْمُ أَحَدِهِمَا أَلْدَادُ، وَاسْمُ الآخَرِ مِيدَادُ. فَحَلَّ عَلَيْهِمَا الرُّوحُ فَتَنَبَّآ فِي الْمُخَيَّمِ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","فَأَسْرَعَ أَحَدُ الشُّبَّانِ وَأَخْبَرَ مُوسَى بِذَلِكَ، ");
INSERT INTO arbnav_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","فَقَالَ يَشُوعُ بْنُ نُونَ، مُسَاعِدُ مُوسَى مُنْذُ حَدَاثَتِهِ: «يَا سَيِّدِي، امْنَعْهُمَا!» ");
INSERT INTO arbnav_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","غَيْرَ أَنَّ مُوسَى قَالَ لَهُ: «هَلْ مَلَأَتْكَ غَيْرَةٌ عَلَيَّ؟ لَيْتَ كُلَّ شَعْبِ الرَّبِّ يُصْبِحُونَ أَنْبِيَاءَ يَحِلُّ عَلَيْهِمِ الرَّبُّ بِرُوحِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ثُمَّ رَجَعَ مُوسَى وَشُيُوخُ إِسْرَائِيلَ إِلَى الْمُخَيَّمِ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","فَهَبَّتْ رِيحٌ مِنْ عِنْدِ الرَّبِّ سَاقَتِ السُّمَانِيَ مِنْ جِهَةِ الْبَحْرِ وَأَسْقَطَتْهَا عَلَى الْمُخَيَّمِ، نَحْوَ مَسِيرَةِ يَوْمٍ، مِنْ كِلا جِهَتَيْهِ وَحَوَالَيْهِ، وَتَرَاكَمَ حَتَّى بَلَغَ ارْتِفَاعُهُ ذِرَاعَيْنِ (نَحْوَ مِتْرٍ) فَوْقَ وَجْهِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","فَهَبَّ الشَّعْبُ طَوَالَ ذَلِكَ النَّهَارِ وَاللَّيْلِ، وَكُلَّ نَهَارِ الْيَوْمِ التَّالِي يَلْتَقِطُونَ السُّمَانِيَ. فَكَانَتْ أَقَلُّ كَمِّيَّةٍ جُمِعَتْ حَوَالَيْ عَشْرَةِ حَوَامِرَ (نَحْوَ أَلْفَيْنِ وَأَرْبَعَ مِئَةِ لِتْرٍ)، ثُمَّ نَشَرُوهَا حَوْلَ الْمُخَيَّمِ لِتَجِفَّ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","وَإِذْ كَانُوا مَازَالُوا يَمْضُغُونَ اللَّحْمَ، احْتَدَمَ غَضَبُ الرَّبِّ عَلَيْهِمْ، فَأَفْشَى بَيْنَهُمْ وَبَأً مُمِيتاً، ");
INSERT INTO arbnav_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","فَدَعُوا الْمَكَانَ «قَبَرُوتَ هَتَّأَوَةَ» (وَمَعْنَاهُ قُبُورُ الشَّهْوَةِ) لأَنَّهُمْ هُنَاكَ دَفَنُوا الْقَوْمَ الْمُشْتَهِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ثُمَّ ارْتَحَلَ الشَّعْبُ مِنْ قَبَرُوتَ هَتَّأَوَةَ إِلَى حَضَيْرُوتَ وَمَكَثُوا فِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","وَانْتَقَدَتْ مَرْيَمُ وَهروُنُ مُوسَى لِزَوَاجِهِ مِنِ امْرَأَةٍ كُوشِيَّةٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","وَقَالا: «هَلْ كَلَّمَ الرَّبُّ مُوسَى وَحْدَهُ؟ أَلَمْ يُكَلِّمْنَا نَحْنُ أَيْضاً؟» فَسَمِعَ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","أَمَّا مُوسَى فَقَدْ كَانَ أَكْثَرَ حِلْماً مِنْ جَمِيعِ النَّاسِ الَّذِينَ عَلَى وَجْهِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","فَقَالَ الرَّبُّ حَالاً لِمُوسَى وَهَرُونَ وَمَرْيَمَ: «اذْهَبُوا أَنْتُمُ الثَّلاثَةُ إِلَى خَيْمَةِ الاجْتِمَاعِ». فَمَضَى ثَلاثَتُهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","فَنَزَلَ الرَّبُّ فِي عَمُودِ سَحَابٍ وَحَلَّ عِنْدَ بَابِ الْخَيْمَةِ، وَنَادَى هَرُونَ وَمَرْيَمَ، فَتَقَدَّمَا وَحْدَهُمَا، ");
INSERT INTO arbnav_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","فَقَالَ: «اسْمَعَا كَلامِي: إِنْ كَانَ بَيْنَكُمْ نَبِيٌّ لِلرَّبِّ فَإِنِّي أَسْتَعْلِنُ لَهُ بِالرُّؤْيَا، وَأُكَلِّمُهُ بِالْحُلْمِ، ");
INSERT INTO arbnav_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","أَمَّا عَبْدِي مُوسَى فَلَسْتُ أُعَامِلُهُ هَكَذَا، بَلْ هُوَ أَمِينٌ فِي بَيْتِي، ");
INSERT INTO arbnav_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","لِذَلِكَ أُكَلِّمُهُ وَجْهاً لِوَجْهٍ، وَبِوُضُوحٍ مِنْ غَيْرِ أَلْغَازٍ، وَيُعَايِنُ صُورَةَ الرَّبِّ. فَلِمَاذَا جَرُؤْتُمَا عَلَى انْتِقَادِ عَبْدِي مُوسَى؟» ");
INSERT INTO arbnav_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","وَاحْتَدَّ غَضَبُ الرَّبِّ عَلَيْهِمَا، ثُمَّ مَضَى عَنْهُمَا. ");
INSERT INTO arbnav_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","فَلَمَّا ارْتَفَعَتِ السَّحَابَةُ عَنْ خَيْمَةِ الاجْتِمَاعِ، إِذَا مَرْيَمُ بَرْصَاءُ كَالثَّلْجِ فَالْتَفَتَ هَرُونُ وَمُوسَى نَحْوَ مَرْيَمَ، وَإذَا هِيَ مُصَابَةٌ بِالْبَرَصِ. ");
INSERT INTO arbnav_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","فَقَالَ هَروُنُ لِمُوسَى: «أَرْجُوكَ يَا سَيِّدِي، لَا تُحَمِّلْنَا الْخَطِيئَةَ الَّتِي ارْتَكَبْنَاهَا كَالْحَمْقَى، وَأَسَأْنَا بِها إِلَيْكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","وَلا تَجْعَلْ مَرْيَمَ كَالْجَنِينِ الْمَيْتِ الْخَارِجِ مِنْ رَحِمِ أُمِّهِ وَقَدْ تَهَرَّأَ نِصْفُ لَحْمِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","فَصَرَخَ مُوسَى إِلَى الرَّبِّ قَائِلاً: «اللهُمَّ اشْفِهَا». ");
INSERT INTO arbnav_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","فَأَجَابَهُ الرَّبُّ: «لَوْ أَنَّ أَبَاهَا بَصَقَ فِي وَجْهِهَا، أَمَا كَانَتْ تَمْكُثُ خَجِلَةً سَبْعَةَ أَيَّامٍ؟ فَلْتُحْجَزْ خَارِجَ الْمُخَيَّمِ سَبْعَةَ أَيَّامٍ وَبَعْدَ ذَلِكَ تَرْجِعُ». ");
INSERT INTO arbnav_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","فَحُجِزَتْ مَرْيَمُ سَبْعَةَ أَيَّامٍ خَارِجَ الْمُخَيَّمِ، وَلَمْ يَرْتَحِلِ الشَّعْبُ حَتَّى عَادَتْ مَرْيَمُ، ");
INSERT INTO arbnav_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","وَبَعْدَ ذَلِكَ ارْتَحَلَ الشَّعْبُ مِنْ حَضَيْرُوتَ وَنَزَلُوا فِي صَحْرَاءِ فَارَانَ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«أَرْسِلْ جَوَاسِيسَ إِلَى أَرْضِ كَنْعَانَ الَّتِي أَنَا وَاهِبُهَا لِبَنِي إِسْرَائِيلَ. أَرْسِلْ رَئِيساً مِنْ كُلِّ سِبْطٍ مُمَثِّلاً لَهُ». ");
INSERT INTO arbnav_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","فَأَرْسَلَ مُوسَى مُمَثِّلِي الشَّعْبِ الرُّؤَسَاءَ مِنْ صَحْرَاءِ فَارَانَ طِبْقاً لأَمْرِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","وَهُمْ: شَمُّوعُ بْنُ زَكُّورَ عَنْ سِبْطِ رَأُوبَيْنَ، ");
INSERT INTO arbnav_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","شَافَاطُ بْنُ حُورِي عَنْ سِبْطِ شِمْعُونَ، ");
INSERT INTO arbnav_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","كَالَبُ بْنُ يَفُنَّةَ عَنْ سِبْطِ يَهُوذَا، ");
INSERT INTO arbnav_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","يَجْآلُ بْنُ يُوسُفَ عَنْ سِبْطِ يَسَّاكَرَ، ");
INSERT INTO arbnav_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","هُوشَعُ بْنُ نُونٍ عَنْ سِبْطِ أَفْرَايِمَ، ");
INSERT INTO arbnav_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","فَلْطِي بْنُ رَافُو عَنْ سِبْطِ بِنْيَامِينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","جَدِّيئِيلُ بْنُ سُودِي عَنْ سِبْطِ زَبُولُونَ، ");
INSERT INTO arbnav_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","جِدِّي بْنُ سُوسِي مِنْ سِبْطِ مَنَسَّى عَنْ سِبْطِ يُوسُفَ، ");
INSERT INTO arbnav_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","عَمِّيئِيلُ بْنُ جَمَلِّي عَنْ سِبْطِ دَانٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","سَتُورُ بْنُ مِيخَائِيلَ عَنْ سِبْطِ أَشِيرَ، ");
INSERT INTO arbnav_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","نَحْبِي بْنُ وَفْسِي عَنْ سِبْطِ نَفْتَالِي، ");
INSERT INTO arbnav_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","جَأُوئِيلُ بْنُ مَاكِي عَنْ سِبْطِ جَادٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","هَذِهِ هِيَ أَسْمَاءُ الرِّجَالِ الَّذِينَ أَرْسَلَهُمْ مُوسَى لِيَتَجَسَّسُوا أَرْضَ كَنْعَانَ، وَآنَذَاكَ غَيَّرَ مُوسَى اسْمَ هُوشَعَ بْنِ نُونٍ إِلَى يَشُوعَ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","وَعِنْدَمَا أَطْلَقَهُمْ مُوسَى لِيَتَجَسَّسُوا أَرْضَ كَنْعَانَ قَالَ لَهُمْ: «انْطَلِقُوا مِنْ هُنَا نَحْوَ الْجَنُوبِ، ثُمَّ اصْعَدُوا إِلَى الْجَبَلِ، ");
INSERT INTO arbnav_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","وَاسْتَكْشِفُوا الْبِلادَ وَأَوْضَاعَهَا وَهَلْ شَعْبُهَا الْمُقِيمُ فِيهَا قَوِيٌّ أَمْ ضَعِيفٌ؟ أَكَثِيرٌ هُوَ أَمْ قَلِيلٌ؟ ");
INSERT INTO arbnav_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","وَمَا هِيَ طَبِيعَةُ الأَرْضِ السَّاكِنُ فِيهَا، أَصَالِحَةٌ هِيَ أَمْ رَدِيئَةٌ؟ وَمَا هِيَ الْمُدُنُ الَّتِي هُوَ قَاطِنٌ فِيهَا؟ أَمُخَيَّمَاتٌ هِيَ أَمْ حُصُونٌ؟ ");
INSERT INTO arbnav_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","وَكَيْفَ هِيَ أَرْضُهُ: أَخَصِبَةٌ أَمْ قَاحِلَةٌ؟ أَفِيهَا شَجَرٌ أَمْ جَرْدَاءُ؟ تَشَجَّعُوا وَأَحْضِرُوا عَيِّنَةً مِنْ ثَمَرِ الأَرْضِ». وَكَانَ الْمَوْسِمُ عِنْدَئِذٍ مَوْسِمَ بَاكُورَاتِ الْعِنَبِ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","فَمَضَوْا وَتَجَسَّسُوا الأَرْضَ، ابْتِدَاءً مِنْ صَحْرَاءِ صِينَ إِلَى رَحُوبَ عَلَى مَشَارِفِ حَمَاةَ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","وَاجْتَازُوا صَحْرَاءَ النَّقَبِ حَتَّى وَصَلُوا حَبْرُونَ حَيْثُ تُقِيمُ قَبَائِلُ بَنِي عَنَاقَ: أَخِيمَانَ وَشِيشَايَ وَتَلْمَايَ. وَكَانَتْ حَبْرُونُ قَدْ بُنِيَتْ قَبْلَ مَدِينَةِ صُوعَنَ الْمِصْرِيَّةِ بِسَبْعِ سَنَوَاتٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ثُمَّ قَدِمُوا عَلَى وَادِي أَشْكُولَ، فَقَطَفُوا فَرْعاً مِنْ كَرْمَةِ عِنَبٍ فِيهِ عُنْقُودٌ وَاحِدٌ، حَمَلُوهُ بِعَصاً عَلَى كَتِفَيْ اثْنَيْنِ مِنْهُمْ، فَضْلاً عَنْ شَيْءٍ مِنَ التِّينِ وَالرُّمَّانِ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","فَدُعِيَ ذَلِكَ الْمَوْضِعُ وَادِي أَشْكُولَ (وَمَعْنَاهُ: وَادِي الْعُنْقُودِ) بِسَبَبِ عُنْقُودِ الْعِنَبِ الَّذِي قَطَفَهُ الإِسْرَائِيلِيُّونَ مِنْ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","وَبَعْدَ أَرْبَعِينَ يَوْماً رَجَعُوا مِنِ اسْتِكْشَافِ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","فَأَقْبَلُوا عَلَى مُوسَى وَهَرُونَ وَسَائِرِ شَعْبِ إِسْرَائِيلَ فِي صَحْرَاءِ فَارَانَ فِي قَادِشَ، وَبَلَّغُوهُمْ بِمَا شَاهَدُوهُ، وَأَرَوْهُمْ ثَمَرَ الأَرْضِ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","وَقَالُوا: «قَدِ انْطَلَقْنَا إِلَى الأَرْضِ الَّتِي أَرْسَلْتَنَا إِلَيْهَا، فَوَجَدْنَاهَا تَفِيضُ حَقّاً لَبَناً وَعَسَلاً، وَهَذِهِ هِيَ ثِمَارُهَا، ");
INSERT INTO arbnav_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","غَيْرَ أَنَّ الشَّعْبَ الْمُسْتَوْطِنَ فِيهَا بَالِغُ الْقُوَّةِ وَمُدُنَهُ مَنِيعَةٌ وَعَظِيمَةٌ جِدّاً. كَمَا شَاهَدْنَا هُنَاكَ بَنِي عَنَاقَ، ");
INSERT INTO arbnav_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","فَالْعَمَالِقَةُ مُقِيمُونَ فِي أَرْضِ الْجَنُوبِ، وَالْحِثِّيُّونَ وَالْيَبُوسِيُّونَ وَالأَمُورِيُّونَ مُتَمَنِّعُونَ فِي الْجَبَلِ، وَالْكَنْعَانِيُّونَ مُسْتَوْطِنُونَ عِنْدَ الْبَحْرِ وَعَلَى مُحَاذَاةِ الأُرْدُنِّ». ");
INSERT INTO arbnav_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","وَلَكِنَّ كَالَبَ هَدَّأَ رَوْعَ الشَّعْبِ الْمَاثِلِ أَمَامَ مُوسَى وَقَالَ: «لِنَمْضِ وَنَمْتَلِكِ الأَرْضَ لأَنَّنَا قَادِرُونَ حَقّاً عَلَى ذَلِكَ». ");
INSERT INTO arbnav_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","فَعَارَضَهُ الرِّجَالُ الَّذِينَ كَانُوا مَعَهُ وَقَالُوا: «لا نَقْدِرُ أَنْ نُقَاوِمَ سُكَّانَهَا لأَنَّهُمْ أَقْوَى مِنَّا». ");
INSERT INTO arbnav_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","وَبِذَلِكَ أَشَاعُوا الذُّعْرَ بَيْنَ الإِسْرَائِيلِيِّينَ مِنَ الْبِلادِ الَّتِي تَجَسَّسُوهَا قَائِلِينَ: «سَتَفْتَرِسُنَا الأَرْضُ الَّتِي تَجَسَّسْنَاهَا، وَجَمِيعُ مَنْ شَاهَدْنَاهُمْ مِنْ سُكَّانِهَا عَمَالِقَةٌ. ");
INSERT INTO arbnav_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","فَقَدْ رَأَيْنَا هُنَاكَ الْجَبَابِرَةَ بَنِي عَنَاقَ، فَبَدَوْنَا فِي أَعْيُنِ أَنْفُسِنَا كَالْجَرَادِ، وَكَذَلِكَ كُنَّا فِي عُيُونِهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","فَرَفَعَ الشَّعْبُ كُلُّهُ صَوْتَهُ وَبَكَى فِي تِلْكَ اللَّيْلَةِ، ");
INSERT INTO arbnav_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","وَتَذَمَّرَ عَلَى مُوسَى وَهَرُونَ، وَقَالُوا: «لَيْتَنَا مُتْنَا فِي دِيَارِ مِصْرَ، أَوْ لَيْتَنَا مُتْنَا فِي الصَّحْرَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","لِمَاذَا أَحْضَرَنَا الرَّبُّ إِلَى هَذِهِ الأَرْضِ لِنَهْلِكَ بِحَدِّ السَّيْفِ، وَتُؤْخَذَ نِسَاؤُنَا وَأَطْفَالُنَا سَبَايَا؟ أَلَيْسَ مِنَ الأَفْضَلِ لَنَا أَنْ نَرْجِعَ إِلَى مِصْرَ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","وَقَالَ بَعْضُهُمْ لِبَعْضٍ: «لِنَنْتَخِبْ لَنَا قَائِداً وَنَرْجِعْ إِلَى مِصْرَ». ");
INSERT INTO arbnav_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","فَخَرَّ مُوسَى وَهَرُونُ عَلَى وَجْهَيْهِمَا أَمَامَ جَمِيعِ شَعْبِ إِسْرَائِيلَ، ");
INSERT INTO arbnav_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","وَمَزَّقَ يَشُوعُ بْنُ نُونَ وَكَالَبُ بْنُ يَفُنَّةَ ثِيَابَهُمَا، وَهُمَا مِمَّنْ تَجَسَّسُوا الأَرْضَ، ");
INSERT INTO arbnav_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","وَقَالا لِكُلِّ الشَّعْبِ: «إِنَّ الأَرْضَ الَّتِي اجْتَزْنَا فِيهَا هِيَ أَرْضُ خَيْرَاتٍ عَظِيمَةٍ جِدّاً. ");
INSERT INTO arbnav_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","فَإِنْ رَضِيَ عَنَّا الرَّبُّ يُدْخِلْنَا إِلَيْهَا وَيَهَبْهَا لَنَا، أَرْضاً تَفِيضُ لَبَناً وَعَسَلاً. ");
INSERT INTO arbnav_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","إِنَّمَا لَا تَتَمَرَّدُوا عَلَى الرَّبِّ وَلا تَجْزَعُوا مِنْ شَعْبِ الأَرْضِ، لأَنَّنَا سَنَبْتَلِعُهُمْ كَالْخُبْزِ، فَقَدْ تَلاشَى ظِلُّ الْحِمَايَةِ عَنْهُمْ، وَالرَّبُّ مَعَنَا فَلا تَرْهَبُوهُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","وَلَكِنَّ الشَّعْبَ طَالَبَ بِرَجْمِهِمَا بِالْحِجَارَةِ. غَيْرَ أَنَّ مَجْدَ الرَّبِّ ظَهَرَ فِي خَيْمَةِ الاجْتِمَاعِ عَلَى مَرْأَىً مِنْهُمْ جَمِيعاً. ");
INSERT INTO arbnav_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","وَقَالَ الرَّبُّ لِمُوسَى: «إِلَى مَتَى يُمْعِنُ هَذَا الشَّعْبُ فِي إِهَانَتِي، وَإِلَى مَتَى لَا يُصَدِّقُونَنِي عَلَى الرَّغْمِ مِنْ مُعْجِزَاتِي الَّتِي أَجْرَيْتُهَا فِي وَسَطِهِمْ؟ ");
INSERT INTO arbnav_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","سَأُبِيدُهُمْ بِالْوَبَأِ، وَأَجْعَلُكَ شَعْباً أَكْبَرَ وَأَعْظَمَ مِنْهُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","فَقَالَ مُوسَى لِلرَّبِّ: «عِنْدَئِذٍ يَسْمَعُ الْمِصْرِيُّونَ، الَّذِينَ أَخْرَجْتَ هَذَا الشَّعْبَ مِنْ بَيْنِهِمْ بِقُدْرَتِكَ، بِهَذَا ");
INSERT INTO arbnav_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","وَيُخْبِرُونَ بِهِ أَهْلَ هَذِهِ الأَرْضِ، الَّذِينَ قَدْ سَمِعُوا يَا رَبُّ أَنَّكَ قَائِمٌ فِي وَسَطِ هَذَا الشَّعْبِ، وَأَنَّكَ قَدْ ظَهَرْتَ لَهُمْ وَجْهاً لِوَجْهٍ تُظَلِّلُهُمْ بِحِمَايَتِكَ، وَتَسِيرُ أَمَامَهُمْ فِي عَمُودِ سَحَابٍ نَهَاراً وَفِي عَمُودِ نَارٍ لَيْلاً. ");
INSERT INTO arbnav_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","فَإِنْ أَهْلَكْتَ هَذَا الشَّعْبَ دَفْعَةً وَاحِدَةً، فَإِنَّ الأُمَمَ الَّتِي سَمِعَتْ بِخَبَرِكَ تَقُولُ ");
INSERT INTO arbnav_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","إِنَّكَ قَدْ عَجَزْتَ عَنْ أَنْ تُدْخِلَ هَذَا الشَّعْبَ إِلَى الأَرْضِ الَّتِي وَعَدْتَهُمْ بِها، فَأَهْلَكْتَهُمْ فِي الصَّحْرَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","وَالآنَ لِتَتَعَظَّمْ قُدْرَةُ سَيِّدِي كَمَا نَطَقْتَ قَائِلاً: ");
INSERT INTO arbnav_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","الرَّبُّ طَوِيلُ الأَنَاةِ، وَافِرُ الرَّحْمَةِ، يَغْفِرُ الذَّنْبَ وَالسَّيِّئَةَ. لَكِنَّهُ لَا يُبْرِئُ، بَلْ يَفْتَقِدُ ذَنْبَ الآبَاءِ فِي الأَبْنَاءِ إِلَى الْجِيلِ الثَّالِثِ وَالرَّابِعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","فَاصْفَحْ عَنْ ذَنْبِ هَذَا الشَّعْبِ بِحَسَبِ نِعْمَتِكَ، وَاغْفِرْ لَهُ كَمَا غَفَرْتَ ذُنُوبَهُ مِنْ مِصْرَ إِلَى هَهُنَا». ");
INSERT INTO arbnav_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","فَأَجَابَ الرَّبُّ: «قَدْ صَفَحْتُ بِحَسَبِ قَوْلِكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","وَلَكِنْ كَمَا أَنَا حَقّاً حَيٌّ، وَكَمَا أَنَّ مَجْدَ الرَّبِّ حَقّاً يَمْلأُ الأَرْضَ، ");
INSERT INTO arbnav_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","فَإِنَّ جَمِيعَ الرِّجَالِ الَّذِينَ عَايَنُوا مَجْدِي وَمُعْجِزَاتِي الَّتِي أَجْرَيْتُهَا فِي مِصْرَ وَفِي الصَّحْرَاءِ، وَجَرَّبُونِي عَشْرَ مَرَّاتٍ مِنْ غَيْرِ أَنْ يُطِيعُوا قَوْلِي، ");
INSERT INTO arbnav_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","لَنْ يَرَوْا الأَرْضَ الَّتِي وَعَدْتُ بِها آبَاءَهُمْ. جَمِيعُ الَّذِينَ اسْتَخَفُّوا بِي، لَنْ يُشَاهِدُوهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","وَلَكِنْ لأَنَّ فِي عَبْدِي كَالَبَ رُوحاً مُخْتَلِفَةً، وَقَدْ تَبِعَنِي بِكُلِّ قَلْبِهِ، فَسَأُدْخِلُهُ إِلَى الأَرْضِ الَّتِي ذَهَبَ إِلَيْهَا، وَسَيَرِثُهَا نَسْلُهُ مِنْ بَعْدِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","وَبِمَا أَنَّ الْعَمَالِقَةَ وَالْكَنْعَانِيِّينَ سَاكِنُونَ فِي الْوِدْيَانِ، فَارْجِعُوا غَداً إِلَى الصَّحْرَاءِ فِي اتِّجَاهِ الْبَحْرِ الأَحْمَرِ». ");
INSERT INTO arbnav_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","قَالَ الرَّبُّ لِمُوسَى وَهَرُونَ: ");
INSERT INTO arbnav_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«إِلَى مَتَى أَصْفَحُ عَنْ هَذِهِ الْجَمَاعَةِ الشِّرِّيرَةِ الْمُتَذَمِّرَةِ عَلَيَّ؟ لَقَدْ سَمِعْتُ تَذَمُّرَهُمْ عَلَيَّ، ");
INSERT INTO arbnav_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","فَقُلْ لَهُمْ: حَيٌّ أَنَا يَقُولُ الرَّبُّ، لأُنْزِلَنَّ بِكُمْ كُلَّ مَا تَكَلَّمْتُمْ بِهِ فِي مَسْمَعِي. ");
INSERT INTO arbnav_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","إِذْ تَتَسَاقَطُ جُثَثُكُمْ فِي هَذِهِ الصَّحْرَاءِ، مِنِ ابْنِ عِشْرِينَ سَنَةً فَمَا فَوْقُ مِمَّنْ تَمَّ إِحْصَاؤُهُمْ وَتَذَمَّرُوا عَلَيَّ. ");
INSERT INTO arbnav_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","لَنْ تَدْخُلُوا الأَرْضَ الَّتِي وَعَدْتُ رَافِعاً يَدِي بِقَسَمٍ أَنْ أُسْكِنَكُمْ فِيهَا، مَاعَدَا كَالَبَ بنَ يَفُنَّةَ وَيَشُوعَ بْنَ نُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","غَيْرَ أَنِّي سَأُدْخِلُ إِلَيْهَا أَوْلادَكُمُ الَّذِينَ ادَّعَيْتُمْ أَنَّهُمْ يُصْبِحُونَ أَسْرَى، فَيَتَمَتَّعُونَ بِالأَرْضِ الَّتِي احْتَقَرْتُمُوهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","أَمَّا أَنْتُمْ فَإِنَّ جُثَثَكُمْ تَتَسَاقَطُ فِي هَذَا الْقَفْرِ، ");
INSERT INTO arbnav_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","وَيَبْقَى بَنُوكُمْ فِي الصَّحْرَاءِ أَرْبَعِينَ سَنَةً، تُعَانُونَ مِنْ فُجُورِكُمْ، حَتَّى تَبْلَى جُثَثُكُمْ فِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","وَتَحْمِلُونَ أَوْزَارَكُمْ أَرْبَعِينَ سَنَةً. كُلُّ يَوْمٍ بِسَنَةٍ، عَلَى عَدَدِ الأَيَّامِ الأَرْبَعِينَ الَّتِي تَجَسَّسْتُمْ فِيهَا الأَرْضَ، فَتُدْرِكُونَ عَاقِبَةَ ابْتِعَادِي عَنْكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","أَنَا الرَّبُّ قَدْ تَكَلَّمْتُ، وَهَذَا مَا سَأُعَاقِبُ بِهِ هَذِهِ الْجَمَاعَةَ الشِّرِّيرَةَ الْمُتَآمِرَةَ عَلَيَّ: فِي هَذِهِ الصَّحْرَاءِ يَفْنَوْنَ وَيَمُوتُونَ». ");
INSERT INTO arbnav_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","أَمَّا الْجَوَاسِيسُ الَّذِينَ أَرْسَلَهُمْ مُوسَى لاِسْتِكْشَافِ الأَرْضِ، فَرَجَعُوا فَأَثَارُوا عَلَيْهِ الشَّعْبَ بِمَا رَوَّجُوهُ مِنْ أَخْبَارٍ سَيِّئَةٍ عَنِ الأَرْضِ، ");
INSERT INTO arbnav_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","فَقَدْ أَمَاتَهُمُ الرَّبُّ بِالْوَبَأِ عِقَاباً لَهُمْ ");
INSERT INTO arbnav_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","وَلَمْ يَعِشْ مِنْهُمْ إِلّا يَشُوعُ بْنُ نُونَ وَكَالَبُ بْنُ يَفُنَّةَ. ");
INSERT INTO arbnav_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","وَلَمَا أَبْلَغَ مُوسَى هَذَا الْكَلامَ إِلَى جَمِيعِ بَنِي إِسْرَائِيلَ بَكَوْا بُكَاءً شَدِيداً. ");
INSERT INTO arbnav_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","وَفِي الصَّبَاحِ الْبَاكِرِ صَعِدُوا إِلَى رَأْسِ الْجَبَلِ قَائِلِينَ: «هَا نَحْنُ قَدْ أَخْطَأْنَا، فَلْنَمْضِ إِلَى الْمَكَانِ الَّذِي وَعَدَنَا بِهِ الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","فَقَالَ مُوسَى: «لِمَاذَا تَعْصَوْنَ أَمْرَ الرَّبِّ؟ إِنَّ عَمَلَكُمْ هَذَا لَنْ يُفْلِحَ. ");
INSERT INTO arbnav_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","لَا تَنْطَلِقُوا لِئَلّا تَنْهَزِمُوا أَمَامَ أَعْدَائِكُمْ، لأَنَّ الرَّبَّ لَيْسَ فِي وَسَطِكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","فَالْعَمَالِقَةُ وَالْكَنْعَانِيُّونَ مُتَرَبِّصُونَ بِكُمْ هُنَاكَ فَتَهْلِكُونَ بِحَدِّ السَّيْفِ، لأَنَّكُمْ قَدِ ارْتَدَدْتُمْ عَنِ الرَّبِّ وَلَنْ يَكُونَ الرَّبُّ مَعَكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","لَكِنَّهُمْ، فِي غَطْرَسَتِهِمْ، ارْتَقَوْا إِلَى قِمَّةِ الْجَبَلِ، غَيْرَ أَنَّ تَابُوتَ عَهْدِ الرَّبِّ وَمُوسَى لَمْ يَبْرَحَا مِنْ وَسَطِ الْمُخَيَّمِ. ");
INSERT INTO arbnav_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","فَانْقَضَّ عَلَيْهِمِ الْعَمَالِقَةُ وَالْكَنْعَانِيُّونَ الْمُقِيمُونَ فِي ذَلِكَ الْجَبَلِ، وَهَاجَمُوهُمْ وَتَعَقَّبُوهُمْ إِلَى «حُرْمَةَ». ");
INSERT INTO arbnav_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: مَتَى اسْتَوْطَنْتُمُ الأَرْضَ الَّتِي أَنَا وَاهِبُهَا لَكُمْ مَسْكَناً، ");
INSERT INTO arbnav_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","وَقَدَّمْتُمْ لِي قُرْبَانَ مُحْرَقَةٍ أَوْ ذَبِيحَةٍ وَفَاءً لِنَذْرٍ، أَوْ تَقْدِمَةً طَوْعِيَّةً أَوْ قَرَابِينَ فِي أَعْيَادِكُمْ لِلْحُظْوَةِ بِرِضَى الرَّبِّ وَمَسَرَّتِهِ، مِنَ الْبَقَرِ وَالْغَنَمِ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","فَلْيُرْفِقْهَا الْمُقَرِّبُ بِتَقْدِمَةِ عُشْرٍ مِنَ الدَّقِيقِ الْمَعْجُونِ بِرُبْعِ الْهِينِ (نَحْوَ لِتْرٍ) مِنَ الزَّيْتِ، ");
INSERT INTO arbnav_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","وَسَكِيبِ خَمْرٍ مِقْدَارُهُ رُبْعُ الْهِينِ (نَحْوَ لِتْرٍ)، يُصْعِدُهُ مَعَ الْمُحْرَقَةِ أَوِ الذَّبِيحَةِ لِلْحَمَلِ الْوَاحِدِ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","أَمَّا مَعَ الْكَبْشِ فَلْيُقَرِّبْ تَقْدِمَةً عُشْرَيْنِ مِنَ الدَّقِيقِ مَعْجُونَيْنِ بِثُلْثِ الْهِينِ (بِنَحْوِ لِتْرٍ وَثُلْثِ اللِّتْرِ) مِنَ الزَّيْتِ ");
INSERT INTO arbnav_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","وَسَكِيبَ خَمْرٍ مِقْدَارُهُ ثُلْثُ الْهِينِ (نَحْوَ لِتْرٍ وَثُلْثِ اللِّتْرِ)، يُصْعِدُهَا لِلْحُظْوَةِ بِرِضَى الرَّبِّ وَمَسَرَّتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","وَإذَا قَرَّبْتَ ثَوْراً مُحْرَقَةً أَوْ ذَبِيحَةً وَفَاءً لِنَذْرٍ أَوْ ذَبِيحَةَ سَلامٍ لِلرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","فَأَصْعِدْ مَعَ الثَّوْرِ تَقْدِمَةً ثَلاثَةَ أَعْشَارٍ مِنَ الدَّقِيقِ مَعْجُونَةً بِنِصْفِ الْهِينِ (بِنَحْوِ لِتْرَيْنِ) مِنَ الزَّيْتِ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","وَسَكِيبَ خَمْرٍ مِقْدَارُهُ نِصْفُ الْهِينِ (نَحْوَ لِتْرَيْنِ)، لِيَكُونَ وَقُودَ رِضَىً وَمَسَرَّةٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","هَذَا مَا يُقَدَّمُ لِلثَّوْرِ الْوَاحِدِ، أَوْ لِلْكَبْشِ الْوَاحِدِ، أَوْ لِلْحَمَلِ أَوْ لِلتَّيْسِ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","هَكَذَا تَفْعَلُونَ بِكُلِّ وَاحِدٍ مِنْهَا عَلَى حَسَبِ أَعْدَادِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","وَيُمَارِسُ كُلُّ مُواطِنٍ إِسْرَائِيلِيٍّ هَذِهِ الشَّعَائِرَ عَلَى هَذَا الْمِثَالِ عِنْدَمَا يُقَدِّمُ مُحْرَقَةً لِتَكُونَ رَائِحَةَ سُرُورٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","وَإذَا قَرَّبَ غَرِيبٌ مُقِيمٌ فِي وَسَطِكُمْ، أَوْ نَازِلٌ فِي دِيَارِكُمْ عَلَى مَدَى أَجْيَالِكُمْ مُحْرَقَةً رَائِحَةَ سُرُورٍ لِلرَّبِّ، فَلْيَصْنَعْ كَمَا تَصْنَعُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","فَهَذِهِ فَرِيضَةٌ دَائِمَةٌ لَكُمْ، وَلِلْغَرِيبِ النَّازِلِ عِنْدَكُمْ عَلَى مَدَى أَجْيَالِكُمْ، فَتَكُونُونَ عَلَى حَدٍّ سَوَاءٍ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","فَتَكُونُ لَكُمْ وَلِلْغَرِيبِ النَّازِلِ عِنْدَكُمْ شَرِيعَةٌ وَاحِدَةٌ وَحُكْمٌ وَاحِدٌ». ");
INSERT INTO arbnav_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«أَوْصِ شَعْبَ إِسْرَائِيلَ وَقُلْ لَهُمْ: مَتَى دَخَلْتُمُ الأَرْضَ الَّتِي أَنَا آخِذُكُمْ إِلَيْهَا، ");
INSERT INTO arbnav_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","وَأَكَلْتُمْ مِنْ غَلَّتِهَا، فَأَصْعِدُوا لِي تَقْدِمَةً مِنْهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","مِنْ أَوَّلِ عَجِينِكُمْ تُقَدِّمُونَ قُرْصاً قُرْبَاناً، كَقُرْبَانِ الْبَيْدَرِ هَكَذَا تُقَدِّمُونَهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","إِذْ يَتَوَجَّبُ عَلَيْكُمْ، جِيلاً بَعْدَ جِيلٍ، أَنْ تُقَدِّمُوا قُرْبَاناً لِي مِنْ أَوَّلِ عَجِينِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","وَإذَا سَهَوْتُمْ وَلَمْ تُنَفِّذُوا جَمِيعَ هَذِهِ الْوَصَايَا الَّتِي أَبْلَغْتُهَا لِمُوسَى، ");
INSERT INTO arbnav_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","وَالَّتِي أَمَرْتُكُمْ بِمُمَارَسَتِهَا عَلَى مَدَى أَجْيَالِكُمْ، مُنْذُ أَنْ أَصْدَرْتُهَا إِلَيْكُمْ عَلَى لِسَانِ مُوسَى، ");
INSERT INTO arbnav_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","وَإِنْ حَدَثَ هَذَا سَهْواً وَعَنْ غَيْرِ عِلْمِ الْجَمَاعَةِ، فَعَلَى كُلِّ الْجَمَاعَةِ أَنْ تُقَرِّبَ ثَوْراً مُحْرَقَةً رَائِحَةَ سُرُورٍ لِلرَّبِّ مَعَ تَقْدِمَةٍ مِنَ الدَّقِيقِ وَسَكِيبِهِ مِنَ الْخَمْرِ طِبْقاً لِلشَّعَائِرِ، وَتَيْساً وَاحِداً ذَبِيحَةَ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","فَيُكَفِّرُ الْكَاهِنُ عَنْ جَمِيعِ شَعْبِ إِسْرَائِيلَ، فَأَصْفَحُ عَنْهُمْ، لأَنَّ الأَمْرَ صَدَرَ سَهْواً عَنْهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","فَأَصْفَحُ عَنِ الشَّعْبِ كُلِّهِ، وَالْغَرِيبِ الْمُقِيمِ بَيْنَكُمْ، لأَنَّ الأَمْرَ صَدَرَ سَهْواً عَنِ الشَّعْبِ جَمِيعِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","وَإِنْ أَخْطَأَتْ نَفْسٌ وَاحِدَةٌ سَهْواً، فَلْتُقَرِّبْ عَنْزَةً حَوْلِيَّةً ذَبِيحَةَ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","فَيُكَفِّرُ الْكَاهِنُ عَنِ النَّفْسِ الَّتِي سَهَتْ فَأَخْطَأَتْ أَمَامِي فَأَصْفَحُ عَنْهَا عِنْدَمَا يَتِمُّ التَّكْفِيرُ عَنْهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","وَتَكُونُ هَذِهِ شَرِيعَةً وَاحِدَةً تُطَبَّقُ عَلَى كُلِّ مَنْ أَخْطَأَ سَهْواً سَوَاءٌ كَانَ مُواطِناً أَمْ غَرِيباً نَازِلاً بَيْنَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","أَمَّا إِنْ تَعَمَّدَ أَحَدٌ الْخَطَأَ، سَوَاءٌ كَانَ مِنَ الإِسْرَائِيلِيِّينَ أَمْ مِنَ الْغُرَبَاءِ، فَهُوَ يَزْدَرِي بِي وَيَجِبُ أَنْ يُسْتَأْصَلَ مِنْ بَيْنِ شَعْبِهِ، ");
INSERT INTO arbnav_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","لأَنَّهُ احْتَقَرَ كَلامِي وَنَقَضَ وَصِيَّتِي، لِهَذَا يُسْتَأْصَلُ مُتَحَمِّلاً عِقَابَ ذَنْبِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","وَفِي أَثْنَاءِ إِقَامَةِ بَنِي إِسْرَائِيلَ فِي الصَّحْرَاءِ، وَجَدُوا رَجُلاً يَجْمَعُ حَطَباً فِي يَوْمِ السَّبْتِ، ");
INSERT INTO arbnav_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","فَاقْتَادُوهُ إِلَى مُوسَى وَهَرُونَ وَبَقِيَّةِ الْجَمَاعَةِ، ");
INSERT INTO arbnav_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","وَزَجُّوهُ فِي السِّجْنِ لأَنَّهُ لَمْ يَكُنْ وَاضِحاً بَعْدُ مَا يَتَوَجَّبُ عَلَيْهِمْ أَنْ يَفْعَلُوا بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","فَقَالَ الرَّبُّ لِمُوسَى: «لِتَرْجُمْهُ الْجَمَاعَةُ كُلُّهَا بِالْحِجَارَةِ خَارِجَ الْمُخَيَّمِ، لأَنَّ عِقَابَهُ الْقَتْلُ حَتْماً». ");
INSERT INTO arbnav_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","فَأَخَذَهُ الشَّعْبُ إِلَى خَارِجِ الْمُخَيَّمِ وَرَجَمُوهُ بِالْحِجَارَةِ حَتَّى مَاتَ، كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«أَوْصِ شَعْبَ إِسْرَائِيلَ وَقُلْ لَهُمْ: اِصْنَعُوا عَلَى مَدَى أَجْيَالِكُمْ، أَهْدَاباً فِي أَذْيَالِ ثِيَابِكُمْ وَضَعُوا عَلَى هُدُبِ الذَّيْلِ خَيْطاً أَزْرَقَ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","فَتَرَوْنَ أَهْدَابَكُمْ هَذِهِ وَتَذْكُرُونَ كُلَّ وَصَايَايَ وَتُطِيعُونَهَا، وَلا تُغْوُونَ أَنْفُسَكُمْ بِاتِّبَاعِ شَهْوَاتِ قُلُوبِكُمْ وَعُيُونِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","عِنْدَئِذٍ تَتَذَكَّرُونَ أَنْ تُطِيعُوا جَمِيعَ وَصَايَايَ وَتَتَقَدَّسُوا لإِلَهِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","فَأَنَا الرَّبُّ إِلَهُكُمُ الَّذِي أَخْرَجَكُمْ مِنْ دِيَارِ مِصْرَ لِيَكُونَ لَكُمْ إِلَهاً. أَنَا الرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","وَشَرَعَ قُورَحُ بْنُ يِصْهَارَ بْنِ قَهَاتَ بْنِ لاوِي، وَدَاثَانُ وَأَبِيرَامُ ابْنَا أَلِيَآبَ، وَأُونُ بْنُ فَالَتَ مِنْ سِبْطِ رَأُوبَيْنَ، ");
INSERT INTO arbnav_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","يَتَآمَرُونَ عَلَى مُوسَى، مَعَ مِئَتَيْنِ وَخَمْسِينَ مِنْ رُؤَسَاءِ جَمَاعَةِ بَنِي إِسْرَائِيلَ، ذَوِي الْمَكَانَةِ مِمَّنْ تَمَّ تَعْيِينُهُمْ فِي الْمَجْلِسِ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","هَؤُلاءِ تَأَلَّبُوا عَلَى مُوسَى وَهَرُونَ وَقَالُوا: «حَسْبُكُمَا! إِنَّ كُلَّ الْجَمَاعَةِ بِأَسْرِهَا مُقَدَّسَةٌ، وَفِي وَسَطِهَا الرَّبُّ. فَمَا بَالُكُمَا تَتَرَفَّعَانِ عَلَى جَمَاعَةِ الرَّبِّ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","فَلَمَّا سَمِعَ مُوسَى هَذَا، أَكَبَّ عَلَى وَجْهِهِ، ");
INSERT INTO arbnav_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ثُمَّ قَالَ لِقُورَحَ وَسَائِرِ جَمَاعَتِهِ: «غَداً يُعْلِنُ الرَّبُّ مَنْ هُوَ لَهُ، وَمَنْ هُوَ الْمُقَدَّسُ فَيُقَرِّبُهُ مِنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","وَلَكِنْ يَا قُورَحُ افْعَلْ هَذَا أَنْتَ وَجَمَاعَتُكَ: خُذُوا لَكُمْ مَجَامِرَ، ");
INSERT INTO arbnav_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","وَضَعُوا فِيهَا نَاراً وَبَخُوراً أَمَامَ الرَّبِّ غَداً. وَالرَّجُلُ الَّذِي يَخْتَارُهُ الرَّبُّ يَكُونُ هُوَ الْمُقَدَّسُ، فَحَسْبُكُمْ أَيُّهَا اللّاوِيُّونَ!» ");
INSERT INTO arbnav_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","وَأَضَافَ مُوسَى قَائِلاً لِقُورَحَ: «اسْتَمِعُوا يَا بَنِي لاوِي، ");
INSERT INTO arbnav_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","أَلَمْ يَكْفِكُمْ أَنَّ إِلَهَ إِسْرَائِيلَ قَدْ أَفْرَزَكُمْ مِنْ بَيْنِ الشَّعْبِ لِيُقَرِّبَكُمْ إِلَيْهِ لِكَيْ تَخْدِمُوا مَسْكَنَ الرَّبِّ وَتَقِفُوا فِي حَضْرَةِ الشَّعْبِ كُلِّهِ لِخِدْمَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","فَقَرَّبَكَ مَعَ بَقِيَّةِ إِخْوَتِكَ مِنْ بَنِي لاوِي، حَتَّى صِرْتُمْ تَطْمَعُونَ فِي الْكَهَنُوتِ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","إِذَنْ أَنْتَ وَكُلُّ جَمَاعَتِكَ قَدْ تَأَلَّبْتُمْ عَلَى الرَّبِّ، لأَنَّهُ مَنْ هُوَ هَرُونُ حَتَّى تَتَذَمَّرُوا عَلَيْهِ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","فَأَرْسَلَ مُوسَى يَسْتَدْعِي دَاثَانَ وَأَبِيرَامَ ابْنَيْ أَلِيآبَ، فَرَدَّا: «لَنْ نَحْضُرَ! ");
INSERT INTO arbnav_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","أَلَمْ يَكْفِكَ أَنَّكَ أَخْرَجْتَنَا مِنْ أَرْضٍ تُدِرُّ لَبَناً وَعَسَلاً لِتُهْلِكَنَا فِي الصَّحْرَاءِ، ثُمَّ تَتَرَأَّسُ عَلَيْنَا؟ ");
INSERT INTO arbnav_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","فَأَنْتَ لَمْ تَقُدْنَا إِلَى أَرْضٍ تَفِيضُ خَيْرَاتٍ، وَلا أَوْرَثْتَنَا حُقُولاً وَكُرُوماً. فَمَنْ تُحَاوِلُ أَنْ تَخْدَعَ؟ إِنَّنَا لَنْ نَحْضُرَ!» ");
INSERT INTO arbnav_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","فَاحْتَدَمَ غَيْظُ مُوسَى وَقَالَ لِلرَّبِّ: «لا تَقْبَلْ تَقْدِمَتَهُمَا، فَأَنَا لَمْ آخُذْ حَتَّى حِمَاراً وَاحِداً مِنْهُمَا، وَلَمْ أُسِئْ إِلَى أَحَدٍ مِنْهُمَا». ");
INSERT INTO arbnav_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","وَقَالَ مُوسَى لِقُورَحَ: «امْثُلْ أَنْتَ وَجَمَاعَتُكَ كُلُّهَا أَمَامَ الرَّبِّ غَداً، وَكَذَلِكَ يَحْضُرُ هَرُونُ أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","وَلْيَأْخُذْ كُلٌّ مِنْكُمْ مَجْمَرَتَهُ وَضَعُوا فِيهَا بَخُوراً، وَلْيُقَدِّمْ كُلُّ وَاحِدٍ مَجْمَرَتَهُ، فَتَكُونَ مِئَتَيْنِ وَخَمْسِينَ مَجْمَرَةً، وَكَذَلِكَ خُذْ أَنْتَ وَهَرُونُ، كُلُّ وَاحِدٍ مَجْمَرَتَهُ». ");
INSERT INTO arbnav_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","فَجَاءَ كُلُّ وَاحِدٍ بِمَجْمَرَتِهِ وَوَضَعُوا فِيهَا نَاراً وَبَخُوراً، وَمَثَلُوا عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ مَعَ مُوسَى وَهَرُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","وَحَشَدَ قُورَحُ عَلَيْهِمَا كُلَّ الْجَمَاعَةِ الْمُتَآمِرَةِ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، فَتَرَاءَى آنَئِذٍ مَجْدُ الرَّبِّ لِلْجَمَاعَةِ كُلِّهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","وَقَالَ الرَّبُّ لِمُوسَى وَهَرُونَ: ");
INSERT INTO arbnav_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«افْتَرِزَا مِنْ بَيْنِ هَذِهِ الْجَمَاعَةِ لأَنِّي سَأُفْنِيهِمْ فِي لَحْظَةٍ». ");
INSERT INTO arbnav_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","فَانْطَرَحَا عَلَى وَجْهَيْهِمَا وَابْتَهَلا قَائِلَيْنِ: «اللهُمَّ، يَا إِلَهَ أَرْوَاحِ جَمِيعِ الْبَشَرِ، أَتَسْخَطُ عَلَى الْجَمَاعَةِ كُلِّهَا مِنْ أَجْلِ خَطِيئَةِ رَجُلٍ وَاحِدٍ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","فَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«اطْلُبْ مِنَ الشَّعْبِ أَنْ يَبْتَعِدُوا مِنْ حَوَالَيْ خِيَامِ قُورَحَ وَدَاثَانَ وَأَبِيرَامَ». ");
INSERT INTO arbnav_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","فَذَهَبَ مُوسَى إِلَى دَاثَانَ وَأَبِيرَامَ، وَتَبِعَهُ شُيُوخُ إِسْرَائِيلَ، ");
INSERT INTO arbnav_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","وَقَالَ لِلْجَمَاعَةِ كُلِّهَا: «ابْتَعِدُوا عَنْ خِيَامِ هَؤُلاءِ الْقَوْمِ الأَشْرَارِ، وَلا تَلْمَسُوا شَيْئاً مِمَّا لَهُمْ لِئَلّا تَهْلِكُوا مِنَ جَرَّاءِ خَطَايَاهُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","فَابْتَعَدُوا مِنْ حَوَالَيْ خِيَامِ قُورَحَ وَدَاثَانَ وَأَبِيرَامَ، وَخَرَجَ دَاثَانُ وَأَبِيرَامُ، وَوَقَفَا أَمَامَ خَيْمَتَيْهِمَا مَعَ زَوْجَاتِهِمَا وَأَوْلادِهِمَا صِغَاراً وَكِبَاراً. ");
INSERT INTO arbnav_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","فَقَالَ مُوسَى: «بِهَذَا تَعْرِفُونَ أَنَّ الرَّبَّ قَدْ أَرْسَلَنِي لأُجْرِيَ كُلَّ هَذِهِ الأَعْمَالِ، وَأَنَّهَا لَيْسَتْ صَادِرَةً عَنْ نَفْسِي: ");
INSERT INTO arbnav_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","إِنْ مَاتَ هَؤُلاءِ مَوْتاً طَبِيعِيًّا، أَوِ ابْتُلُوا بِمَا يُبْتَلَى بِهِ النَّاسُ عَادَةً، فَلا يَكُونُ الرَّبُّ قَدْ أَرْسَلَنِي. ");
INSERT INTO arbnav_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","وَلَكِنْ إِنْ أَجْرَى الرَّبُّ أَمْراً جَدِيداً، وَانْشَقَّتِ الأَرْضُ وَابْتَلَعَتْهُمْ مَعَ كُلِّ مَالَهُمْ، وَدُفِنُوا فِي بَاطِنِ الأَرْضِ أَحْيَاءَ، عِنْدَئِذٍ تُدْرِكُونَ أَنَّ هَؤُلاءِ الْقَوْمَ قَدِ ازْدَرَوْا بِالرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","وَحَالَمَا انْتَهَى مِنْ كَلامِهِ انْشَقَّتِ الأَرْضُ تَحْتَهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","وَفَتَحَتْ فَاهَا وَابْتَلَعَتْهُمْ مَعَ بُيُوتِهِمْ، كَمَا ابْتَلَعَتْ رِجَالَ قُورَحَ مَعَ كُلِّ مَا يَمْلِكُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","فَاخْتَفَوْا هُمْ وَكُلُّ مَا يَمْلِكُونَ أَحْيَاءَ فِي بَاطِنِ الأَرْضِ الَّتِي انْطَبَقَتْ عَلَيْهِمْ، فَبَادُوا مِنْ بَيْنِ الْجَمَاعَةِ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","وَهَرَبَ الإِسْرَائِيلِيُّونَ الَّذِينَ حَوْلَهُمْ مِنْ صَوْتِ صَرَخَاتِهِمْ قَائِلِينَ: «لِئَلّا تَبْتَلِعَنَا الأَرْضُ». ");
INSERT INTO arbnav_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","وَانْدَلَعَتْ نَارٌ مِنْ عِنْدِ الرَّبِّ فَالْتَهَمَتِ الْمِئَتَيْنِ وَالْخَمْسِينَ رَجُلاً الَّذِينَ قَرَّبُوا الْبَخُورَ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«اطْلُبْ مِنْ أَلِعَازَارَ بْنِ هَرُونَ الْكَاهِنِ أَنْ يَجْمَعَ الْمَجَامِرَ مِنَ الْحَرِيقِ، وَلْيَذْرِ مَا فِيهَا مِنْ جَمْرٍ فَإِنَّهَا قَدْ تَقَدَّسَتْ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","وَاطْرُقُوا مَجَامِرَ هَؤُلاءِ الَّذِينَ أَخْطَأُوا فِي حَقِّ نُفُوسِهِمْ صَفَائِحَ، لِتَكُونَ غِشَاءً لِلْمَذْبَحِ، لأَنَّهُمْ قَدَّمُوهَا فِي حَضْرَةِ الرَّبِّ فَتَقَدَّسَتْ، فَتَكُونُ عِبْرَةً لِبَنِي إِسْرَائِيلَ». ");
INSERT INTO arbnav_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","فَجَمَعَ أَلِعَازَارُ الْكَاهِنُ مَجَامِرَ النُّحَاسِ الَّتِي قَرَّبَهَا الْمُحْتَرِقُونَ، فَطُرِقَتْ غِشَاءً لِلْمَذْبَحِ، ");
INSERT INTO arbnav_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","عِبْرَةً لِبَنِي إِسْرَائِيلَ لِكَيْ لَا يَدْنُوَ أَحَدٌ مِنْ غَيْرِ نَسْلِ هَرُونَ لِيُبَخِّرَ فِي حَضْرَةِ الرَّبِّ، فَيُصِيبَهُ مَا أَصَابَ قُورَحَ وَجَمَاعَتَهُ، كَمَا كَلَّمَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","وَفِي الْيَوْمِ الثَّانِي تَذَمَّرَ جَمِيعُ بَنِي إِسْرَائِيلَ عَلَى مُوسَى وَهَرُونَ قَائِلِينَ: «لَقَدْ قَتَلْتُمَا شَعْبَ الرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","فَلَمَّا اجْتَمَعَتِ الْجَمَاعَةُ عَلَى مُوسَى وَهَرُونَ مَضَيَا إِلَى خَيْمَةِ الاجْتِمَاعِ، وَإذَا بِالسَّحَابَةِ قَدْ غَطَّتْهَا وَمَجْدُ الرَّبِّ قَدْ تَرَاءَى. ");
INSERT INTO arbnav_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","فَأَقْبَلَ مُوسَى وَهَرُونُ إِلَى أَمَامِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","فَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«اخْرُجَا مِنْ بَيْنِ هَذِهِ الْجَمَاعَةِ لأَنَّنِي سَأُفْنِيهِمْ فِي لَحْظَةٍ». فَخَرَّا عَلَى وَجْهَيْهِمَا ");
INSERT INTO arbnav_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ثُمَّ قَالَ مُوسَى لِهَرُونَ: «خُذِ الْمَجْمَرَةَ وَضَعْ فِيهَا نَاراً مِنْ عَلَى الْمَذْبَحِ، وَأَيْضاً بَخُوراً، وَأَسْرِعْ إِلَى الْجَمَاعَةِ لِتُكَفِّرَ عَنْهُمْ، لأَنَّ الْغَضَبَ الْمُحْتَدِمَ قَدْ صَدَرَ عَنِ الرَّبِّ وَتَفَشَّى فِيهِمِ الْوَبَأُ». ");
INSERT INTO arbnav_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","فَنَفَّذَ هَرُونُ أَمْرَ مُوسَى، وَأَسْرَعَ إِلَى وَسَطِ الْجَمَاعَةِ، وَإذَا بِالْوَبَأِ قَدِ ابْتَدَأَ يَتَفَشَّى فِيهِمْ، فَوَضَعَ الْبَخُورَ وَكَفَّرَ عَنِ الشَّعْبِ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","وَوَقَفَ هَرُونُ بَيْنَ الْمَوْتَى وَالأَحْيَاءِ، فَتَوَقَّفَ الوَبَأُ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","فَكَانَ الَّذِينَ هَلَكُوا بِالْوَبَإِ أَرْبَعَةَ عَشَرَ أَلْفاً وَسَبْعَ مِئَةٍ، عَدَا الَّذِينَ مَاتُوا بِسَبَبِ قُورَحَ. ");
INSERT INTO arbnav_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ثُمَّ رَجَعَ هَرُونُ إِلَى مُوسَى عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ وَقَدْ تَوَقَّفَ سَرَيَانُ الْوَبَإِ. ");
INSERT INTO arbnav_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ، وَخُذْ مِنْهُمْ اثْنَتَيْ عَشْرَةَ عَصاً، وَاحِدَةً مِنْ كُلِّ رَئِيسِ سِبْطٍ مِنْ أَسْبَاطِ آبَائِهِمْ، وَاحْفُرِ اسْمَ كُلِّ وَاحِدٍ مِنْهُمْ عَلَى عَصَاهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","وَاحْفُرِ اسْمَ هَرُونَ عَلَى عَصَا لاوِي، لأَنَّ لِرَئِيسِ بَيْتِ آبَائِهِمْ عَصاً وَاحِدَةً. ");
INSERT INTO arbnav_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","وَضَعِ الْعِصِيَّ فِي خَيْمَةِ الاجْتِمَاعِ أَمَامَ الشَّهَادَةِ حَيْثُ أَجْتَمِعُ بِكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","فَالرَّجُلُ الَّذِي أَخْتَارُهُ تُوْرِقُ عَصَاهُ، وَبِذَلِكَ أَضَعُ حَدّاً لِتَذَمُّرَاتِ بَنِي إِسْرَائِيلَ الَّتِي تَرْتَفِعُ ضِدَّكُمَا». ");
INSERT INTO arbnav_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","فَأَبْلَغَ مُوسَى ذَلِكَ بَنِي إِسْرَائِيلَ، فَأَعْطَاهُ كُلُّ وَاحِدٍ مِنْ رُؤَسَائِهِمْ عَصاً بِحَسَبِ أَسْبَاطِهِمْ فَكَانَتِ اثْنَتَيْ عَشْرَةَ عَصاً. وَكَانَتْ عَصَا هَرُونَ مِنْ بَيْنِ عِصِيِّهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","فَوَضَعَ مُوسَى الْعِصِيَّ أَمَامَ الرَّبِّ فِي خَيْمَةِ الشَّهَادَةِ. ");
INSERT INTO arbnav_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","وَفِي الْيَوْمِ التَّالِي دَخَلَ مُوسَى إِلَى خَيْمَةِ الشَّهَادَةِ فَوَجَدَ أَنَّ عَصَا هَرُونَ الَّتِي تُمَثِّلُ سِبْطَ لاوِي قَدْ أَوْرَقَتْ، إِذْ أَخْرَجَتْ فُرُوخاً وَأَزْهَرَتْ وَأَثْمَرَتْ لَوْزاً نَاضِجاً. ");
INSERT INTO arbnav_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","فَأَخْرَجَ مُوسَى جَمِيعَ الْعِصِيِّ مِنْ حَضْرَةِ الرَّبِّ لِيَتَفَحَّصَهَا بَنُو إِسْرَائِيلَ كُلُّهُمْ، فَأَخَذَ كُلُّ وَاحِدٍ عَصَاهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","وَقَالَ الرَّبُّ لِمُوسَى: «رُدَّ عَصَا هَرُونَ إِلَى أَمَامِ تَابُوتِ الْعَهْدِ وَاحْفَظْهَا لِتَكُونَ عِبْرَةً لِلْمُتَمَرِّدِينَ، فَتَكُفَّ تَذَمُّرَاتُهُمْ عَنِّي لِئَلّا يَهْلِكُوا». ");
INSERT INTO arbnav_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","فَفَعَلَ مُوسَى بِمُقْتَضَى أَمْرِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","وَقَالَ بَنُو إِسْرَائِيلَ لِمُوسَى: «إِنَّنَا انْقَرَضْنَا وَهَلَكْنَا جَمِيعاً، ");
INSERT INTO arbnav_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","لأَنَّ كُلَّ مَنِ اقْتَرَبَ إِلَى مَسْكَنِ الرَّبِّ يَمُوتُ. تُرَى أَنَفْنَى كُلُّنَا؟» ");
INSERT INTO arbnav_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","وَقَالَ الرَّبُّ لِهَرُونَ: «أَنْتَ وَأَبْنَاؤُكَ وَبَيْتُ أَبِيكَ مَسْؤولُونَ عَمَّا يُصِيبُ الْمَقْدِسَ مِنْ تَدْنِيسٍ، وَأَنْتَ وَأَبْنَاؤُكَ مَعَكَ تَحْمِلُونَ مَسْؤولِيَّةَ مَا يُرْتَكَبُ فِي حَقِّ الْكَهَنُوتِ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","وَاسْتَعِنْ بِإِخْوَتِكَ مِنْ سِبْطِ لاوِي، سِبْطِ أَبِيكَ، فَيَنْضَمُّوا إِلَيْكَ وَيُؤَازِرُوكَ أَنْتَ وَأَبْنَاءَكَ حِينَ تَقُومُونَ بِالْخِدْمَةِ أَمَامَ خَيْمَةِ الشَّهَادَةِ، ");
INSERT INTO arbnav_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","فَيَقُومُونَ عَلَى خِدْمَتِكَ، وَعَلَى خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ. وَلَكِنْ إِيَّاهُمُ الاقْتِرَابَ مِنْ أَوَانِي الْمَقْدِسِ وَمِنَ الْمَذْبَحِ، لِئَلّا يَمُوتُوا جَمِيعاً وَأَنْتُمْ مَعَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","لِيَنْضَمُّوا إِلَيْكَ قَائِمِينَ بِخِدْمَةِ الْخَيْمَةِ وَكُلِّ مَا يُنَاطُ بِهِمْ مِنْ وَاجِبَاتٍ لِلْعِنَايَةِ بِها. وَلَكِنْ لَا يَقْتَرِبْ مِنْهَا مَنْ لَيْسَ مِنْكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","فَأَنْتُمُ الْكَهَنَةُ الَّذِينَ تَقُومُونَ عَلَى خِدْمَةِ الْمَقْدِسِ وَالْمَذْبَحِ، لِئَلّا يَنْصَبَّ السَّخَطُ عَلَى بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","فَقَدِ اخْتَرْتُ إِخْوَتَكُمُ اللّاوِيِّينَ مِنْ بَيْنِ الإِسْرَائِيلِيِّينَ لِيَكُونُوا لَكُمْ عَطِيَّةً مِنَ الرَّبِّ، لِيَعْتَنُوا بِخِدْمَةِ خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","أَمَّا أَنْتَ، وَأَبْنَاؤُكَ مَعَكَ فَقَطْ، فَتَقُومُونَ بِخِدْمَةِ الْكَهَنُوتِ فِي جَمِيعِ مَا لِلْمَذْبَحِ ومَا هُوَ وَرَاءَ الْحِجَابِ، فَأَنَا قَدْ أَعْطَيْتُكُمْ خِدْمَةَ الْكَهَنُوتِ هِبَةً. وَكُلُّ غَرِيبٍ يَقْتَرِبُ مِنَ الْمَقْدِسِ يُقْتَلُ». ");
INSERT INTO arbnav_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","وَقَالَ الرَّبُّ لِهَرُونَ: «هَا أَنَا قَدْ وَلَّيْتُكَ الْقِيَامَ بِخِدْمَةِ قَرَابِينِي. وَكُلُّ التَّقْدِمَاتِ الْمُقَدَّسَةِ الَّتِي يُحْضِرُهَا بَنُو إِسْرَائِيلَ لِي، أَمْنَحُكَ إِيَّاهَا أَنْتَ وَبَنِيكَ لِتَكُونَ لَكُمْ نَصِيباً فَرِيضَةً دَائِمَةً. ");
INSERT INTO arbnav_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","فَيَكُونُ مِنْ نَصِيبِكُمْ قَرَابِينُ قُدْسِ الأَقْدَاسِ، إِلا مَا تُحْرِقُونَهُ مِنْهَا عَلَى الْمَذْبَحِ؛ فَيَكُونُ لَكُمْ مِنْ تَقْدِمَاتِ قُدْسِ الأَقْدَاسِ الَّتِي يُحْضِرُونَهَا لِي، سَوَاءٌ كَانَتْ تَقْدِمَاتِ دَقِيقٍ أَمْ ذَبَائِحَ خَطَايَاهُمْ أَمْ ذَبَائِحَ آثَامِهِمْ. هَذِهِ تَكُونُ نَصِيباً لَكَ وَلأَبْنَائِكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","وَعَلَى كُلِّ ذَكَرٍ مِنْكُمْ أَنْ يَأْكُلَهَا فِي مَكَانٍ مُقَدَّسٍ لأَنَّهَا أَصْبَحَتْ مُقَدَّسَةً ");
INSERT INTO arbnav_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","وَأَمَّا مَا تُرَجِّحُهُ مِنْ عَطَايَا بَنِي إِسْرَائِيلَ فَإِنَّنِي أَهَبُهُ لَكَ وَلأَبْنَائِكَ وَبَنَاتِكَ فَرِيضَةً دَائِمَةً، وَلا يَأْكُلُ مِنْهَا مِنْ أَهْلِ بَيْتِكَ إِلّا مَنْ كَانَ طَاهِراً. ");
INSERT INTO arbnav_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","وَأُعْطِيكَ أَيْضاً بَاكُورَةَ غَلّاتِ أَفْضَلِ زَيْتِ الزَّيْتُونِ وَالْخَمْرِ وَالْحِنْطَةِ الَّتِي يُقَدِّمُونَهَا لِلرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","فَتَكُونُ لَكَ أَبْكَارُ غَلّاتِ أَرْضِهِمِ الَّتِي يُقَدِّمُونَهَا لِلرَّبِّ، فَيَأْكُلُ مِنْهَا كُلُّ طَاهِرٍ مِنْ أَهْلِ بَيْتِكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","كُلُّ مَا هُوَ مَنْذُورٌ لِلرَّبِّ فِي إِسْرَائِيلَ يَكُونُ لَكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","وَكَذَلِكَ كُلُّ بِكْرٍ فَاتِحِ رَحِمٍ مِنَ النَّاسِ وَالْبَهَائِمِ يُقَدِّمُونَهُ لِلرَّبِّ يَكُونُ لَكَ، مَاعَدَا بِكْرَ الإِنْسَانِ وَبِكْرَ الْبَهِيمَةِ النَّجِسَةِ فَإِنَّكَ تَقْبَلُ فِدَاءَهُمَا. ");
INSERT INTO arbnav_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","وَفِدَاءُ النَّاسِ مِنِ ابْنِ شَهْرٍ، حَسَبَ تَقْوِيمِكَ، خَمْسَةُ شَوَاقِلَ (نَحْوَ سِتِّينَ جِرَاماً) مِنَ الفِضَّةِ وَفْقاً لِلْوَزْنِ الْمُعْتَمَدِ فِي الْقُدْسِ، ");
INSERT INTO arbnav_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","لَكِنْ لَا تَقْبَلْ فِدَاءَ بِكْرِ الْبَقَرِ أَوِ الضَّأْنِ أَوِ الْمَعْزِ. إِنَّهُ مُفْرَزٌ لِلرَّبِّ. بَلْ تَرُشُّ دَمَهُ عَلَى الْمَذْبَحِ، وَتُحْرِقُ شَحْمَهُ وَقُوداً رَائِحَةَ رِضًى وَمَسَرَّةٍ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","أَمَّا لَحْمُهُ فَيَكُونُ لَكَ نَصِيباً كَصَدْرِ التَّرْجِيحِ وَالسَّاقِ الْيُمْنَى. ");
INSERT INTO arbnav_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","وَهَكَذَا أُعْطِيكَ أَنْتَ وَأَبْنَاءَكَ وَبَنَاتِكَ، حَقّاً أَبَدِيًّا، جَمِيعَ تَقْدِمَاتِ الأَقْدَاسِ الَّتِي يُقَرِّبُهَا بَنُو إِسْرَائِيلَ لِلرَّبِّ، فَيَكُونُ هَذَا مِيثَاقَ مِلْحٍ أَبَدِيًّا أَمَامَ الرَّبِّ، لَكَ وَلِنَسْلِكَ أَيْضاً». ");
INSERT INTO arbnav_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","وَقَالَ الرَّبُّ لِهَرُونَ: «لا يَكُونُ لَكَ مِيرَاثٌ فِي أَرْضِهِمْ وَلا نَصِيبٌ بَيْنَهُمْ، لأَنَّنِي أَنَا نَصِيبُكَ وَمِيرَاثُكَ فِي وَسَطِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","أَمَّا اللّاوِيُّونَ فَقَدْ وَهَبْتُهُمْ كُلَّ عُشْرٍ فِي إِسْرَائِيلَ، لِقَاءَ عَمَلِهِمِ الَّذِي يَقُومُونَ بِهِ فِي خِدْمَةِ خَيْمَةِ الاجِتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","وَعَلَى الإِسْرَائِيلِيِّينَ، مُنْذُ الآنَ، أَنْ لَا يَقْتَرِبُوا إِلَى خَيْمَةِ الاجْتِمَاعِ، وَإلَّا تَحَمَّلُوا نَتَائِجَ خَطِيئَتِهِمْ فَيَمُوتُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","فَاللّاوِيُّونَ وَحْدَهُمْ يَقُومُونَ بِخِدْمَةِ خَيْمَةِ الاجْتِمَاعِ، وَيَتَحَمَّلُونَ مَسْؤولِيَّةَ خَطَئِهِمْ، فَتَكُونُ هَذِهِ لَكُمْ فَرِيضَةً دَائِمَةً جِيلاً بَعْدَ جِيلٍ. وَلا يَكُونُ لِلّاوِيِّينَ نَصِيبٌ مِنَ الأَمْلاكِ فِي وَسَطِ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","إِنَّ الْعُشُورَ الَّتِي يُقَدِّمُهَا الإِسْرَائِيلِيُّونَ لِلرَّبِّ قَدْ وَهَبْتُهَا لِلّاوِيِّينَ نَصِيباً، لِهَذَا قُلْتُ لَهُمْ، لَا يَرِثُونَ نَصِيباً فِي وَسَطِ إِسْرَائِيلَ». ");
INSERT INTO arbnav_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«أَوْصِ اللّاوِيِّينَ وَقُلْ لَهُمْ: مَتَى أَخَذْتُمْ مِنَ الإِسْرَائِيلِيِّينَ الْعُشْرَ الَّذِي جَعَلْتُهُ نَصِيباً لَكُمْ، تُقَدِّمُونَ مِنْهُ عُشْرَهُ لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","فَيُحْسَبُ تَقْدِمَتَكُمْ مِثْلَ الْحِنْطَةِ مِنَ الْبَيْدَرِ أَوْ تَقْدِمَةِ عَصِيرِ الْكَرْمَةِ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","وَهَكَذَا تُقَدِّمُونَ أَنْتُمْ أَيْضاً تَقْدِمَةً لِلرَّبِّ مِنْ جَمِيعِ عُشُورِكُمُ الَّتِي تَأْخُذُونَهَا مِنْ بَنِي إِسْرَائِيلَ، وَمَا تُقَرِّبُونَهُ لِلرَّبِّ، تُعْطُونَهُ لِهَرُونَ الْكَاهِنِ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","وَعَلَيْكُمْ أَنْ تُحْضِرُوا لِلرَّبِّ أَفْضَلَ جُزْءٍ وَأَقْدَسَهُ مِمَّا أُعْطِيَ لَكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","وَقُلْ لَهُمْ: حِينَ تُقَدِّمُونَ مِنْ أَفْضَلِ عَطَايَاكُمْ فَإِنَّهَا تُحْسَبُ لَكُمْ مِثْلَ مَحْصُولِ الْبَيْدَرِ وَنِتَاجِ الْمَعْصَرَةِ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","وَتَأْكُلُونَهُ فِي كُلِّ مَكَانٍ أَنْتُمْ وَأَهْلُ بُيُوتِكُمْ، لأَنَّهُ أُجْرَةٌ لَكُمْ لِقَاءَ خِدْمَتِكُمْ فِي خَيْمَةِ الاجْتِمَاعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","وَلَدَى تَقْدِيمِ خَيْرِ جُزْءٍ مِنْهَا لَا تَتَحَمَّلُونَ وِزْراً بِسَبَبِهَا. أَمَّا أَقْدَاسُ بَنِي إِسْرَائِيلَ فَلا تُدَنِّسُوهَا لِئَلّا تَمُوتُوا». ");
INSERT INTO arbnav_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","وَقَالَ الرَّبُّ لِمُوسَى وَهَرُونَ: ");
INSERT INTO arbnav_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«هَذِهِ هِيَ مُتَطَلَّبَاتُ الشَّرِيعَةِ الَّتِي آمُرُ بِها: قُلْ لِبَنِي إِسْرَائِيلَ أَنْ يَأْتُوكَ بِبَقَرَةٍ حَمْرَاءَ سَلِيمَةٍ خَالِيَةٍ مِنْ كُلِّ عَيْبٍ، لَمْ يَعْلُهَا نِيرٌ، ");
INSERT INTO arbnav_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","فَتُعْطُونَهَا لأَلِعَازَارَ الْكَاهِنِ، لِيَأْخُذَهَا إِلَى خَارِجِ الْمُخَيَّمِ وَتُذْبَحُ أَمَامَهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","وَيَغْمِسُ الْكَاهِنُ إِصْبَعَهُ بِدَمِهَا وَيَرُشُّ مِنْهُ نَحْوَ وَجْهِ خَيْمَةِ الاجْتِمَاعِ سَبْعَ مَرَّاتٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","وَتُحْرَقُ الْبَقَرَةُ بِجِلْدِهَا وَلَحْمِهَا وَدَمِهَا مَعَ فَرْثِهَا عَلَى مَشْهَدٍ مِنْهُ، ");
INSERT INTO arbnav_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ثُمَّ يَأْخُذُ خَشَبَ أَرْزٍ وَزُوفَا، وَخَيْطاً أَحْمَرَ، وَيَطْرَحُهَا فِي وَسَطِ النِّيرَانِ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ثُمَّ يَغْسِلُ الْكَاهِنُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَبَعْدَ ذَلِكَ يَدْخُلُ الْمُخَيَّمَ، وَيَظَلُّ الْكَاهِنُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","وَيَغْسِلُ الرَّجُلُ الَّذِي أَحْرَقَ الْبَقَرَةَ ثِيَابَهُ بِمَاءٍ وَيَسْتَحِمُّ، وَيَظَلُّ أَيْضاً نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","وَيَجْمَعُ رَجُلٌ طَاهِرٌ رَمَادَ الْبَقَرَةِ وَيُلْقِيهِ خَارِجَ الْمُخَيَّمِ فِي مَوْضِعٍ طَاهِرٍ، فَيَظَلُّ مَحْفُوظاً لِجَمَاعَةِ إِسْرَائِيلَ لاِسْتِخْدَامِهِ فِي مَاءِ التَّطْهِيرِ. إِنَّهَا ذَبِيحَةُ خَطِيئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","وَعَلَى مَنْ جَمَعَ رَمَادَ الْبَقَرَةِ أَنْ يَغْسِلَ ثِيَابَهُ وَيَظَلَّ نَجِساً إِلَى الْمَسَاءِ، فَتَكُونُ هَذِهِ فَرِيضَةً دَائِمَةً لِبَنِي إِسْرَائِيلَ وَلِلْغَرِيبِ الْمُقِيمِ فِي وَسَطِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","مَنْ لَمَسَ جُثْمَانَ إِنْسَانٍ مَيْتٍ يَبْقَى نَجِساً سَبْعَةَ أَيَّامٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","وَعَلَيْهِ أَنْ يَتَطَهَّرَ بِمَاءِ التَّطْهِيرِ فِي الْيَوْمِ الثَّالِثِ، وَفِي الْيَوْمِ السَّابِعِ يُصْبِحُ طَاهِراً. وَإِنْ لَمْ يَتَطَهَّرْ فِي الْيَوْمِ الثَّالِثِ، فَلا يَكُونُ طَاهِراً فِي الْيَوْمِ السَّابِعِ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","كُلُّ مَنْ لَمَسَ جُثْمَانَ إِنْسَانٍ مَيْتٍ وَلَمْ يَتَطَهَّرْ، يُنَجِّسُ مَسْكَنَ الرَّبِّ، وَيَجِبُ اسْتِئْصَالُهُ مِنَ الشَّعْبِ لأَنَّهُ نَجِسٌ، إِذْ إِنَّ مَاءَ التَّطْهِيرِ لَمْ يُرَشَّ عَلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","أَمَّا شَرِيعَةُ مَنْ مَاتَ فِي خَيْمَةٍ، فَإِنَّ كُلَّ مَنْ دَخَلَ الْخَيْمَةَ وَكُلَّ مَنْ كَانَ فِيهَا، يَكُونُ نَجِساً سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","وَكُلُّ إِنَاءٍ مَفْتُوحٍ، لَا غِطَاءَ عَلَيْهِ، أَوْ غَيْرِ مُحْكَمِ السَّدِّ، يُصْبِحُ نَجِساً. ");
INSERT INTO arbnav_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","وَكُلُّ مَنْ لَمَسَ عَلَى وَجْهِ الصَّحْرَاءِ قَتِيلاً بِسَيْفٍ أَوْ مَيْتاً، أَوْ عَظْمَ إِنْسَانٍ أَوْ قَبْراً، يَكُونُ نَجِساً سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","فَيَأْخُذُونَ لِلنَّجِسِ مِنْ غُبَارِ حَرِيقِ ذَبِيحَةِ الْخَطِيئَةِ، وَيُصَبُّ عَلَيْهِ مِنْ مَاءِ نَبْعٍ جَارٍ فِي إِنَاءٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","وَيَأْخُذُ رَجُلٌ طَاهِرٌ أَغْصَانَ الزُّوفَا وَيَغْمِسُهَا فِي الْمَاءِ، وَيَرُشُّهُ عَلَى الْخَيْمَةِ وَعَلَى جَمِيعِ الأَمْتِعَةِ، وَعَلَى كُلِّ مَنْ كَانَ حَاضِراً هُنَاكَ، وَعَلَى الَّذِي لَمَسَ الْعَظْمَ أَوِ الْقَتِيلَ أَوِ الْمَيْتَ أَوِ الْقَبْرَ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ثُمَّ يَرُشُّ الطَّاهِرُ مَاءَ التَّطْهِيرِ عَلَى النَّجِسِ فِي الْيَوْمِ الثَّالِثِ وَالْيَوْمِ السَّابِعِ، وَيُطَهِّرُهُ فِي الْيَوْمِ السَّابِعِ. وَعَلَى الْمُتَطَهِّرِ أَنْ يَغْسِلَ ثِيَابَهُ وَيَسْتَحِمَّ بِمَاءٍ فَيُصْبِحَ طَاهِراً فِي الْمَسَاءِ ");
INSERT INTO arbnav_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","أَمَّا الَّذِي يَتَنَجَّسُ وَلا يَتَطَهَّرُ فَيُسْتَأْصَلُ مِنْ بَيْنِ الْجَمَاعَةِ، لأَنَّهُ نَجَّسَ مَقْدِسَ الرَّبِّ، وَلَمْ يُرَشَّ عَلَيْهِ مَاءُ التَّطْهِيرِ، فَظَلَّ نَجِساً. ");
INSERT INTO arbnav_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","وَتَكُونُ هَذِهِ لَكُمْ فَرِيضَةً دَائِمَةً. وَعَلَى مَنْ رَشَّ مَاءَ التَّطْهِيرِ أَنْ يَغْسِلَ ثِيَابَهُ. وَكُلُّ مَنْ لَمَسَ مَاءَ التَّطْهِيرِ يَكُونُ نَجِساً إِلَى الْمَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","وَأَيُّ شَيْءٍ يَلْمِسُهُ النَّجِسُ يُصْبِحُ نَجِساً، وَكُلُّ مَنْ يَلْمِسُهُ الشَّيْءُ الْمُتَنَجِّسُ يُصْبِحُ نَجِساً إِلَى الْمَسَاءِ». ");
INSERT INTO arbnav_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","وَفِي الشَّهْرِ الأَوَّلِ أَقْبَلَ بَنُو إِسْرَائِيلَ عَلَى صَحْرَاءِ صِينَ، وَأَقَامُوا فِي قَادَشَ حَيْثُ مَاتَتْ مَرْيَمُ وَدُفِنَتْ هُنَاكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","وَإِذْ لَمْ يَتَوَافَرْ مَاءٌ لِلشَّعْبِ اجْتَمَعُوا عَلَى مُوسَى وَهَرُونَ، ");
INSERT INTO arbnav_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","وَخَاصَمُوا مُوسَى قَائِلِينَ لَهُ: «لَيْتَنَا هَلَكْنَا كَإِخْوَتِنَا الَّذِينَ أَهْلَكَهُمُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","لِمَاذَا قُدْتُمَا شَعْبَ الرَّبِّ إِلَى هَذِهِ الصَّحْرَاءِ، لِكَيْ نَمُوتَ فِيهَا نَحْنُ وَمَوَاشِينَا؟ ");
INSERT INTO arbnav_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","لِمَاذَا أَخْرَجْتُمَانَا مِنْ مِصْرَ لِتَأْتِيَا بِنَا إِلَى هَذَا الْمَكَانِ الْقَاحِلِ، حَيْثُ لَا زَرْعَ فِيهِ وَلا تِينَ وَلا كَرْمَ وَلا رُمَّانَ وَلا مَاءَ لِلشُّرْبِ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","فَافْتَرَقَ مُوسَى وَهَرُونُ عَنِ الْجَمَاعَةِ، وَقَدِمَا إِلَى مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ حَيْثُ انْطَرَحَا عَلَى وَجْهَيْهِمَا، فَتَرَاءَى لَهُمَا مَجْدُ الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«خُذِ الْعَصَا، وَاجْمَعِ الشَّعْبَ أَنْتَ وَأَخُوكَ هَرُونُ وَأْمُرَا الصَّخْرَةَ عَلَى مَشْهَدٍ مِنْهُمْ أَنْ تُعْطِيَ مَاءَهَا، فَتُخْرِجَ لَهُمْ مَاءً مِنَ الصَّخْرَةِ فَيَشْرَبَ الشَّعْبُ وَمَوَاشِيهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","فَأَطَاعَ مُوسَى وَأَخَذَ الْعَصَا مِنْ أَمَامِ الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","وَجَمَعَ مُوسَى وَهَرُونُ الشَّعْبَ عِنْدَ الصَّخْرَةِ وَقَالا لَهُمْ: «اسْمَعُوا أَيُّهَا الْمُتَمَرِّدُونَ، أَعَلَيْنَا أَنْ نُخْرِجَ لَكُمْ مِنْ هَذِهِ الصَّخْرَةِ مَاءً؟» ");
INSERT INTO arbnav_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","وَرَفَعَ مُوسَى يَدَهُ وَضَرَبَ الصَّخْرَةَ بِعَصَاهُ مَرَّتَيْنِ، فَتَفَجَّرَ مَاءٌ غَزِيرٌ، فَشَرِبَتِ الْجَمَاعَةُ وَمَوَاشِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","فَقَالَ الرَّبُّ لِمُوسَى وَهَرُونَ: «مِنْ حَيْثُ إِنَّكُمَا لَمْ تُؤْمِنَا بِي حَتَّى تُقَدِّسَانِي عَلَى مَرْأَىً مِنْ بَنِي إِسْرَائِيلَ فَإِنَّكُمَا لَنْ تُدْخِلا هَذَا الشَّعْبَ الأَرْضَ الَّتِي وَهَبْتُهَا لَهُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","فَكَانَ هَذَا مَاءَ مَرِيبَةَ حَيْثُ خَاصَمَ الإِسْرَائِيلِيُّونَ الرَّبَّ فَأَظْهَرَ قَدَاسَتَهُ أَمَامَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","وَبَعَثَ مُوسَى رُسُلاً مِنْ قَادَشَ إِلَى مَلِكِ أَدُومَ يَقُولُونَ لَهُ: «هَذَا مَا يَقُولُهُ لَكَ أَخُوكَ إِسْرَائِيلُ: قَدْ بَلَغَكَ مَا أَصَابَنَا مِنْ مَشَقَّةٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","فَقَدِ انْحَدَرَ آبَاؤُنَا إِلَى مِصْرَ فَمَكَثْنَا فِيهَا أَيَّاماً كَثِيرَةً، فَسَامَنَا الْمِصْرِيُّونَ، نَحْنُ وَآبَاءَنَا سُوءَ الْعَذَابِ، ");
INSERT INTO arbnav_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","فَتَضَرَّعْنَا إِلَى الرَّبِّ فَاسْتَجَابَ لِصَوْتِنَا، وَأَرْسَلَ مَلاكاً أَخْرَجَنَا مِنْ مِصْرَ. وَهَا نَحْنُ نَازِلُونَ فِي مَدِينَةِ قَادَشَ فِي طَرَفِ تُخُومِكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","فَأْذَنْ لَنَا أَنْ نَمُرَّ فِي أَرْضِكَ مِنْ غَيْرِ أَنْ نَدُوسَ فِي حَقْلٍ أَوْ كَرْمٍ أَوْ نَشْرَبَ مَاءَ بِئْرٍ، بَلْ نَسِيرُ فِي الطَّرِيقِ الْعَامَّةِ الْمُخَصَّصَةِ لِلسَّفَرِ. لَا نَمِيلُ يَمِيناً أَوْ شِمَالاً حَتَّى نَتَجَاوَزَ حُدُودَكَ». ");
INSERT INTO arbnav_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","فَقَالَ لَهُمْ مَلِكُ أَدُومَ: «إِيَّاكُمُ الْمُرُورَ بِأَرْضِي لِئَلّا أُجَابِهَكُمْ بِالسَّيْفِ». ");
INSERT INTO arbnav_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","فَأَجَابَهُ بَنُو إِسْرَائِيلَ: «لَنْ نَسِيرَ إِلّا عَلَى طَرِيقِ السَّفَرِ، وَإِنِ اسْتَقَيْنَا نَحْنُ وَمَوَاشِينَا مِنْ مَائِكَ نَدْفَعْ ثَمَنَهُ. إِنَّنَا لَا نَطْلُبُ أَكْثَرَ مِنَ الْمُرُورِ رَاجِلِينَ». ");
INSERT INTO arbnav_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","فَقَالَ: «لا تَمُرُّوا». وَعَبَّأَ مَلِكُ أَدُومَ جَيْشاً قَوِيًّا وَخَرَجَ لِلِقَاءِ إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","وَأَبَى مَلِكُ أَدُومَ أَنْ يَأْذَنَ لِلإِسْرَائِيلِيِّينَ بِاجْتِيَازِ أَرَاضِيهِ. فَتَحَوَّلُوا عَنْهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","وَارْتَحَلُوا جَمِيعُهُمْ مِنْ قَادَشَ حَتَّى أَقْبَلُوا عَلَى جَبَلِ هُورٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","وَقَالَ الرَّبُّ لِمُوسَى وَهَرُونَ فِي جَبَلِ هُورٍ عِنْدَ حُدُودِ أَرْضِ أَدُومَ: ");
INSERT INTO arbnav_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«هَرُونُ لَنْ يَلْبَثَ أَنْ يَمُوتَ، لأَنَّهُ لَنْ يَدْخُلَ الأَرْضَ الَّتِي وَهَبْتُهَا لِبَنِي إِسْرَائِيلَ، لأَنَّكُمَا عَصَيْتُمَا كَلامِي عِنْدَ مَاءِ مَرِيبَةَ. ");
INSERT INTO arbnav_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","خُذْ هَرُونَ وَأَلِعَازَارَ ابْنَهُ وَاصْعَدْ إِلَى جَبَلِ هُورٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","وَانْزِعْ عَنْ هَرُونَ ثِيَابَهُ وَأَلْبِسْهَا أَلِعَازَارَ ابْنَهُ، لأَنَّ هُنَاكَ يَمُوتُ هَرُونُ». ");
INSERT INTO arbnav_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","فَفَعَلَ مُوسَى كَمَا أَمَرَ الرَّبُّ، فَصَعِدُوا جَمِيعاً إِلَى الْجَبَلِ عَلَى مَرْأىً مِنَ الشَّعْبِ كُلِّهِ، ");
INSERT INTO arbnav_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","فَنَزَعَ مُوسَى ثِيَابَ هَرُونَ وَأَلْبَسَهَا أَلِعَازَارَ ابْنَهُ. وَمَاتَ هَرُونُ هُنَاكَ عَلَى قِمَّةِ الْجَبَلِ، ثُمَّ انْحَدَرَ مُوسَى وَأَلِعَازَارُ عَنِ الْجَبَلِ. ");
INSERT INTO arbnav_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","وَعِنْدَمَا عَلِمَ الشَّعْبُ أَنَّ هَرُونَ قَدْ مَاتَ، نَاحُوا عَلَيْهِ ثَلاثِينَ يَوْماً. ");
INSERT INTO arbnav_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","وَعِنْدَمَا سَمِعَ مَلِكُ عَرَادَ الْكَنْعَانِيُّ، الْمُسْتَوْطِنُ فِي النَّقَبِ، أَنَّ الإِسْرَائِيلِيِّينَ قَادِمُونَ عَلَى طَرِيقِ أَتَارِيمَ، حَارَبَهُمْ وَأَسَرَ عَدَداً مِنْهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","فَنَذَرَ الإِسْرَائِيلِيُّونَ لِلرَّبِّ نَذْراً قَائِلِينَ: «إِنْ أَظْفَرْتَنَا بِهَؤُلاءِ الْقَوْمِ، لَنُحَرِّمَنَّ مُدُنَهُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","فَاسْتَجَابَ الرَّبُّ لَهُمْ، وَأَظْفَرَهُمْ بِالْكَنْعَانِيِّينَ، فَحَرَّمُوهُمْ وَمُدُنَهُمْ، فَدُعِيَ اسْمُ الْمَكَانِ «حُرْمَةَ». ");
INSERT INTO arbnav_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","وَارْتَحَلُوا مِنْ جَبَلِ هُورٍ عَنْ طَرِيقِ الْبَحْرِ الأَحْمَرِ لِيَدُورُوا حَوْلَ أَرْضِ أَدُومَ فَأَعْيَتْ نَفْسُ الشَّعْبِ فِي الطَّرِيقِ، ");
INSERT INTO arbnav_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","وَتَذَمَّرُوا عَلَى اللهِ وَعَلَى مُوسَى قَائِلِينَ: «لِمَاذَا أَخْرَجْتُمَانَا مِنْ مِصْرَ لِنَمُوتَ فِي الصَّحْرَاءِ، حَيْثُ لَا خُبْزَ وَلا مَاءَ؟ وَقَدْ عَافَتْ أَنْفُسُنَا الطَّعَامَ التَّافِهَ». ");
INSERT INTO arbnav_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","فَأَطْلَقَ الرَّبُّ عَلَى الشَّعْبِ الْحَيَّاتِ السَّامَّةَ، فَلَدَغَتِ الشَّعْبَ، فَمَاتَ مِنْهُمْ قَوْمٌ كَثِيرُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","فَجَاءَ الشَّعْبُ إِلَى مُوسَى قَائِليِنَ: «لَقَدْ أَخْطَأْنَا إِذْ تَذَمَّرْنَا عَلَى الرَّبِّ وَعَلَيْكَ، فَابْتَهِلْ إِلَى الرَّبِّ لِيُخَلِّصَنَا مِنَ الْحَيَّاتِ». فَصَلَّى مُوسَى مِنْ أَجْلِ الشَّعْبِ، ");
INSERT INTO arbnav_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","فَقَالَ الرَّبُّ لِمُوسَى: «اصْنَعْ لَكَ حَيَّةً سَامَّةً وَارْفَعْهَا عَلَى عَمُودٍ، لِكَيْ يَلْتَفِتَ إِلَيْهَا كُلُّ مَنْ تَلْدَغُهُ حَيَّةٌ، فَيَحْيَا» ");
INSERT INTO arbnav_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","فَصَنَعَ مُوسَى حَيَّةً مِنْ نُحَاسٍ وَأَقَامَهَا عَلَى عَمُودٍ، فَكَانَ كُلُّ مَنْ لَدَغَتْهُ حَيَّةٌ، يَلْتَفِتُ إِلَى حَيَّةِ النُّحَاسِ وَيَحْيَا. ");
INSERT INTO arbnav_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ثُمَّ انْتَقَلَ بَنُو إِسْرَائِيلَ وَنَزَلُوا فِي أُوبُوتَ، ");
INSERT INTO arbnav_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","وَمِنْهَا ارْتَحَلُوا وَحَلُّوا فِي عَيِيِّ عَبَارِيمَ، فِي الصَّحْرَاءِ الْمُقَابِلَةِ لِمُوآبَ فِي اتِّجَاهِ الشَّرْقِ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ثُمَّ ارْتَحَلُوا مِنْ هُنَاكَ وَنَزَلُوا فِي وَادِي زَارَدَ، ");
INSERT INTO arbnav_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","بَعْدَ ذَلِكَ انْتَقَلُوا مِنْ هُنَاكَ وَأَقَامُوا إِلَى جَانِبِ أَرْنُونَ فِي الصَّحْرَاءِ، وَرَاءَ حُدُودِ الأَمُورِيِّينَ، لأَنَّ أَرْنُونَ هِيَ الْحَدُّ الْفَاصِلُ مَا بَيْنَ بِلادِ مُوآبَ وَالأَمُورِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","لِذَلِكَ وَرَدَ فِي كِتَابِ حُرُوبِ الرَّبِّ: «مَدِينَةُ وَاهِبٍ فِي مِنْطَقَةِ سُوفَةَ، وَأَوْدِيَةِ نَهْرِ أَرْنُونَ، ");
INSERT INTO arbnav_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","وَمَصَبِّ الأَوْدِيَةِ الْمُمْتَدِّ نَحْوَ مَدِينَةِ عَارَ، وَالْمُسْتَنِدِ إِلَى حُدُودِ مُوآبَ». ");
INSERT INTO arbnav_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","وَمِنْ هُنَاكَ مَضَوْا نَحْوَ بِئْرٍ، وَهِيَ الْبِئْرُ الَّتِي قَالَ الرَّبُّ عِنْدَهَا لِمُوسَى: «اجْمَعِ الشَّعْبَ لأُعْطِيَهُمْ مَاءً» ");
INSERT INTO arbnav_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","حِينَئِذٍ شَدَا الإِسْرَائِيلِيُّونَ بِهَذَا النَّشِيدِ: «ارْتَفِعْ يَا مَاءَ الْبِئْرِ! ");
INSERT INTO arbnav_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","تَغَنَّوْا بِها، تَغَنَّوْا بِالْبِئْرِ الَّتِي حَفَرَهَا رُؤَسَاءُ. حَفَرَهَا شُرَفَاءُ الشَّعْبِ بِالصَّوْلَجَانِ وَالْعِصِيِّ». ثُمَّ انْتَقَلُوا مِنَ الصَّحْرَاءِ إِلَى مَتَّانَةَ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","وَمِنْ مَتَّانَةَ إِلَى نَحْلِيئِيلَ وَمِنْ نَحْلِيئِيلَ إِلَى بَامُوتَ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","وَمِنْ بَامُوتَ إِلَى الْجِوَاءِ الَّتِي فِي صَحْرَاءِ مُوآبَ عِنْدَ قِمَّةِ الْفِسْجَةِ الْمُشْرِفَةِ عَلَى امْتِدَادِ الصَّحْرَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","وَبَعَثَ الإِسْرَائِيلِيُّونَ رُسُلاً إِلَى سِيحُونَ مَلِكِ الأَمُورِيِّينَ قَائِلِينَ: ");
INSERT INTO arbnav_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«دَعْنَا نَجْتَزْ فِي أَرْضِكَ، فَلا نَمِيلُ إِلَى حَقْلٍ وَلا إِلَى كَرْمٍ، وَلا نَشْرَبُ مَاءَ بِئْرٍ، بَلْ نَسِيرُ فِي الطَّرِيقِ الْعَامَّةِ الْمُخَصَّصَةِ لِلسَّفَرِ حَتَّى نَعْبُرَ حُدُودَكَ». ");
INSERT INTO arbnav_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","فَلَمْ يَأْذَنْ سِيحُونُ لِلإِسْرَائِيلِيِّينَ بِالْمُرُورِ فِي تُخُومِهِ، بَلْ حَشَدَ جَيْشَهُ وَخَرَجَ لِلِقَائِهِمْ إِلَى الصَّحْرَاءِ، وَحَارَبَهُمْ عِنْدَ يَاهَصَ، ");
INSERT INTO arbnav_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","فَهَزَمَهُ الإِسْرَائِيلِيُّونَ بِحَدِّ السَّيْفِ، وَاسْتَوْلَوْا عَلَى بِلادِهِ مِنْ أَرْنُونَ إِلَى يَبُّوقَ حَتَّى حُدُودِ الْعَمُّونِيِّينَ وَلَمْ يَتَجَاوَزُوهَا لِمَنَاعَتِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","وَامْتَلَكَ الإِسْرَائِيلِيُّونَ كُلَّ مُدُنِ الأَمُورِيِّينَ، وَمِنْ جُمْلَتِهَا حَشْبُونُ وَضَوَاحِيهَا وَأَقَامُوا فِيهَا، ");
INSERT INTO arbnav_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","لأَنَّ حَشْبُونَ كَانَتْ عَاصِمَةَ سِيحُونَ مَلِكِ الأَمُورِيِّينَ الَّذِي كَانَ قَدْ حَارَبَ مَلِكَ مُوآبَ السَّابِقَ وَاسْتَوْلَى عَلَى أَرَاضِيهِ كُلِّهَا حَتَّى أَرْنُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","لِهَذَا يَقُولُ الشُّعَرَاءُ: «هَيَّا إِلَى حَشْبُونَ فَتُبْنَى، وَتُشَيَّدُ مَدِينَةُ سِيحُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","فَقَدِ انْدَلَعَتْ نَارٌ مِنْ حَشْبُونَ، لَهِيبٌ مِنْ مَدِينَةِ سِيحُونَ، فَالْتَهَمَتْ عَارَ مُوآبَ، وَأَهْلَكَتْ أَهْلَ مُرْتَفَعَاتِ أَرْنُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","وَيْلٌ لَكَ يَا مُوآبُ. هَلَكْتِ يَا أُمَّةَ كَمُوشَ. قَدْ هَرَبَ أَبْنَاؤُهُ وَأَصْبَحَتْ بَنَاتُهُ سَبَايَا سِيحُونَ مَلِكِ الأَمُورِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","لَكِنْ قَدْ طَوَّحْنَا بِهِمْ. هَلَكَتْ حَشْبُونُ إِلَى دِيبُونَ، دَمَّرْنَا الْبِلادَ حَتَّى نُوفَحَ الَّتِي تَمْتَدُّ إِلَى مِيدَبَا». ");
INSERT INTO arbnav_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","فَأَقَامَ الإِسْرَائِيلِيُّونَ فِي بِلادِ الأَمُورِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","وَأَرْسَلَ مُوسَى لِيَسْتَكْشِفَ مِنْطَقَةَ يَعَزِيرَ، وَمَا لَبِثَ بَنُو إِسْرَائِيلَ أَنِ اسْتَوْلَوْا عَلَى قُرَاهَا وَطَرَدُوا مِنْهَا الأَمُورِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ثُمَّ اتَّجَهُوا نَحْوَ طَرِيقِ بَاشَانَ. فَهَبَّ عُوجُ مَلِكُ بَاشَانَ مَعَ جَمِيعِ قَوْمِهِ لِلِقَائِهِمْ فِي إِذْرَعِي وَمُحَارَبَتِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","فَقَالَ الرَّبُّ لِمُوسَى: «لا تَخَفْ مِنْهُ لأَنَّنِي قَدْ دَفَعْتُهُ لِيَدِكَ مَعَ جَمِيعِ قَوْمِهِ وَأَرْضِهِ، فَتَفْعَلُ بِهِ مَا فَعَلْتَهُ بِسِيحُونَ مَلِكِ الأَمُورِيِّينَ فِي حَشْبُونَ». ");
INSERT INTO arbnav_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","فَقَضَوْا عَلَيْهِ وَعَلَى أَبْنَائِهِ وَقَوْمِهِ حَتَّى لَمْ يَبْقَ مِنْهُمْ حَيٌّ، وَامْتَلَكُوا دِيَارَهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","وَارْتَحَلَ الإِسْرَائِيلِيُّونَ وَنَزَلُوا فِي سُهُولِ مُوآبَ، شَرْقِيَّ الأُرْدُنِّ مُقَابِلَ أَرِيحَا. ");
INSERT INTO arbnav_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","وَإِذْ بَلَغَ بَالاقَ بْنَ صِفُّورَ مَلِكَ مُوآبَ جَمِيعُ مَا أَنْزَلَهُ الإِسْرَائِيلِيُّونَ بِالأَمُورِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","اعْتَرَاهُ الْفَزَعُ لِكَثْرَةِ عَدَدِهِمْ، وَمَلأَ الْخَوْفُ قَلْبَ شَعْبِهِ مِنَ الإِسْرَائِيلِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","فَقَالَ بَالاقُ لِشُيُوخِ مِدْيَانَ: «إِنَّ هَذَا الْجُمْهُورَ قَادِرٌ عَلَى لَحْسِ كُلِّ مَا حَوْلَنَا كَمَا يَلْحَسُ الثَّوْرُ عُشْبَ الْحَقْلِ». ");
INSERT INTO arbnav_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ثُمَّ بَعَثَ بِرُسُلٍ يَسْتَدْعِي بَلْعَامَ بْنَ بَعُورَ، الْمُقِيمَ فِي مَوْطِنِهِ فِي فَتُورَ، الْوَاقِعَةِ عَلَى نَهْرِ الْفُرَاتِ قَائِلاً: «هَا قَدْ خَرَجَ شَعْبٌ مِنْ مِصْرَ يُغَشِّي وَجْهَ الأَرْضِ بِكَثْرَتِهِ، وَهُوَ مُنْتَشِرٌ أَمَامِي. ");
INSERT INTO arbnav_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","فَتَعَالَ الآنَ وَالْعَنْ لِي هَذَا الشَّعْبَ لأَنَّهُ أَعْظَمُ مِنِّي، لَعَلِّي أَتَمَكَّنُ مِنْ دَحْرِهِ وَطَرْدِهِ مِنَ الأَرْضِ، لأَنِّي عَرَفْتُ أَنَّ مَنْ تُبَارِكُهُ يَكُونُ مُبَارَكاً وَمَنْ تَلْعَنُهُ يَكُونُ مَلْعُوناً». ");
INSERT INTO arbnav_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","فَمَضَى شُيُوخُ مُوآبَ وَشُيُوخُ مِدْيَانَ حَامِلِينَ مَعَهُمْ حُلْوَانَ الْعِرَافَةِ، وَأَقْبَلُوا عَلَى بَلْعَامَ وَأَبْلَغُوهُ كَلامَ بَالاقَ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","فَقَالَ لَهُمْ: «بِيتُوا هُنَا اللَّيْلَةَ، وَغَداً أَرُدُّ عَلَيْكُمْ جَوَاباً كَمَا يُعْلِنُ لِي الرَّبُّ». فَمَكَثَ رُؤَسَاءُ مُوآبَ عِنْدَ بَلْعَامَ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","فَتَجَلَّى اللهُ لِبَلْعَامَ وَسَأَلَهُ: «مَنْ هُمْ هَؤُلاءِ الرِّجَالُ الَّذِينَ عِنْدَكَ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","فَأَجَابَ: «لَقَدْ أَرْسَلَ بَالاقُ بْنُ صِفُّورَ مَلِكُ مُوآبَ إِلَيَّ قَائِلاً: ");
INSERT INTO arbnav_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","هَا قَدْ خَرَجَ شَعْبٌ مِنْ مِصْرَ يُغَشِّي وَجْهَ الأَرْضِ. فَتَعَالَ الآنَ وَالْعَنْهُ لِي، لَعَلِّي أَقْدِرُ عَلَى مُحَارَبَتِهِ وَطَرْدِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","فَقَالَ اللهُ لِبَلْعَامَ: «لا تَمْضِ مَعَهُمْ وَلا تَلْعَنِ الشَّعْبَ لأَنَّهُ مُبَارَكٌ». ");
INSERT INTO arbnav_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","فَنَهَضَ بَلْعَامُ فِي الصَّبَاحِ وَقَالَ لِرُؤَسَاءِ بَالاقَ: «انْطَلِقُوا إِلَى دِيَارِكُمْ، لأَنَّ الرَّبَّ أَبَى أَنْ يَأْذَنَ لِي بِالذَّهَابِ مَعَكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","فَانْطَلَقَ رُؤَسَاءُ مُوآبَ وَأَبْلَغُوا بَالاقَ أَنَّ بَلْعَامَ رَفَضَ أَنْ يَحْضُرَ مَعَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","فَعَادَ بَالاقُ وَبَعَثَ أَيْضاً عَدَداً مِنَ الرُّؤَسَاءِ أَكْبَرَ، وَعُظَمَاءَ أَكْثَرَ مِنَ الرُّؤَسَاءِ الأَوَّلِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","فَقَدِمُوا عَلَى بَلْعَامَ وَقَالُوا: «هَذَا مَا يَقُولُهُ لَكَ بَالاقُ بْنُ صِفُّورَ: ");
INSERT INTO arbnav_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","لَا تَتَقَاعَسْ عَنِ الْمَجِيءِ إِلَيَّ، لأَنَّنِي سَأُبَالِغُ فِي إِكْرَامِكَ، وَكُلُّ مَا تَطْلُبُهُ أَفْعَلُهُ، فَتَعَالَ الآنَ وَالْعَنْ هَذَا الشَّعْبَ». ");
INSERT INTO arbnav_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","فَأَجَابَ بَلْعَامُ رُسُلَ بَالاقَ: «لا يُمْكِنُنِي أَنْ أَعْصَى أَمْرَ الرَّبِّ إِلَهِي فِي أَيِّ عَمَلٍ صَغِيرٍ أَوْ كَبِيرٍ، وَلَوْ أَغْدَقَ عَلَيَّ بَالاقُ مِلْءَ قَصْرِهِ فِضَّةً وَذَهَباً. ");
INSERT INTO arbnav_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","فَالآنَ، اقْضُوا هُنَا لَيْلَتَكُمْ لأَعْلَمَ بِمَاذَا يَعُودُ الرَّبُّ فَيُوْصِينِي بِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","فَتَرَاءَى اللهُ لِبَلْعَامَ لَيْلاً وَقَالَ لَهُ: «إِنْ جَاءَ الرِّجَالُ يَسْتَدْعُونَكَ فَقُمْ وَامْضِ مَعَهُمْ، إِنَّمَا لَا تَنْطِقْ إِلّا بِمَا آمُرُكَ بِهِ فَقَطْ». ");
INSERT INTO arbnav_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","فَنَهَضَ بَلْعَامُ صَبَاحاً وَأَسْرَجَ أَتَانَهُ، وَانْطَلَقَ مَعَ رُؤَسَاءِ مُوآبَ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","فَاحْتَدَمَ غَضَبُ اللهِ لأَنَّهُ مَضَى مَعَهُمْ، فَاعْتَرَضَهُ مَلاكُ الرَّبِّ فِي الطَّرِيقِ لِيُقَاوِمَهُ وَهُوَ رَاكِبٌ عَلَى أَتَانِهِ وَغُلامَاهُ مَعَهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","فَأَبْصَرَتِ الأَتَانُ مَلاكَ الرَّبِّ مُنْتَصِباً فِي الطَّرِيقِ، وَقَدِ اسْتَلَّ سَيْفَهُ بِيَدِهِ، فَحَادَتْ عَنِ الطَّرِيقِ وَمَشَتْ فِي الْحَقْلِ. فَضَرَبَهَا بَلْعَامُ لِيَرُدَّهَا إِلَى الطَّرِيقِ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ثُمَّ وَقَفَ مَلاكُ الرَّبِّ فِي مَمَرٍّ لِلْكُرُومِ يَقُومُ عَلَى جَانِبَيْهِ حَائِطَانِ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","فَلَمَّا شَاهَدَتِ الأَتَانُ مَلاكَ الرَّبِّ زَحَمَتْ جَانِبَ الْحَائِطِ وَضَغَطَتْ رِجْلَ بَلْعَامَ عَلَيْهِ، فَضَرَبَهَا أَيْضاً. ");
INSERT INTO arbnav_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ثُمَّ اجْتَازَ بِهِ مَلاكُ الرَّبِّ وَوَقَفَ فِي مَوْضِعٍ ضَيِّقٍ، لَا سَبِيلَ فِيهِ لِلتَّحَوُّلِ يَمْنَةً أَوْ يَسْرَةً. ");
INSERT INTO arbnav_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","فَلَمَّا رَأَتِ الأَتَانُ مَلاكَ الرَّبِّ رَبَضَتْ تَحْتَ بَلْعَامَ. فَثَارَ غَضَبُ بَلْعَامَ وَضَرَبَ الأَتَانَ بِالْقَضِيبِ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","عِنْدَئِذٍ أَنْطَقَ الرَّبُّ الأَتَانَ، فَقَالَتْ لِبَلْعَامَ: «مَاذَا جَنَيْتُ حَتَّى ضَرَبْتَنِي الْآنَ ثَلاثَ دَفْعَاتٍ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","فَقَالَ بَلْعَامُ: «لأَنَّكِ سَخَرْتِ مِنِّي. لَوْ كَانَ فِي يَدِي سَيْفٌ لَكُنْتُ قَدْ قَتَلْتُكِ». ");
INSERT INTO arbnav_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","فَأَجَابَتْهُ الأَتَانُ: «أَلَسْتُ أَنَا أَتَانَكَ الَّتِي رَكِبْتَ عَلَيْهَا دَائِماً إِلَى هَذَا الْيَوْمِ؟ وَهَلْ عَوَّدْتُكَ أَنْ أَصْنَعَ بِكَ هَكَذَا؟» فَقَالَ: «لا». ");
INSERT INTO arbnav_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","عِنْدَئِذٍ كَشَفَ الرَّبُّ عَنْ عَيْنَيْ بَلْعَامَ، فَشَاهَدَ مَلاكَ الرَّبِّ مُنْتَصِباً فِي الطَّرِيقِ وَسَيْفُهُ مَسْلُولٌ فِي يَدِهِ، فَخَرَّ عَلَى وَجْهِهِ سَاجِداً. ");
INSERT INTO arbnav_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","فَقَالَ لَهُ مَلاكُ الرَّبِّ: «لِمَاذَا ضَرَبْتَ الآنَ أَتَانَكَ ثَلاثَ مَرَّاتٍ؟ فَهَا أَنَا قَدْ جِئْتُ لأَعْتَرِضَكَ، لأَنَّ طَرِيقَكَ مُلْتَوِيَةٌ فِي نَظَرِي، ");
INSERT INTO arbnav_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","فَشَاهَدَتْنِي الأَتَانُ فَحَادَتْ مِنْ أَمَامِي ثَلاثَ مَرَّاتٍ. وَلَوْ لَمْ تَفْعَلْ لَكُنْتُ قَدْ قَتَلْتُكَ وَاسْتَحْيَيْتُهَا». ");
INSERT INTO arbnav_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","فَقَالَ بَلْعَامُ لِمَلاكِ الرَّبِّ: «لَقَدْ أَخْطَأْتُ، وَلَمْ أَعْلَمْ أَنَّكَ وَاقِفٌ لاِعْتِرَاضِي فِي الطَّرِيقِ. وَالآنَ إِنْ سَاءَ فِي عَيْنَيْكَ فَإِنِّي أَرْجِعُ». ");
INSERT INTO arbnav_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","فَقَالَ مَلاكُ الرَّبِّ لِبَلْعَامَ: «امْضِ مَعَ الرِّجَالِ، وَلَكِنْ عَلَيْكَ أَنْ تَنْطِقَ بِمَا آمُرُكَ بِهِ فَقَطْ». فَانْطَلَقَ بَلْعَامُ مَعَ رُؤَسَاءِ بَالاقَ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","فَلَمَّا بَلَغَ بَالاقَ أَنَّ بَلْعَامَ قَدْ قَدِمَ أَسْرَعَ لاِسْتِقْبَالِهِ إِلَى مَدِينَةِ مُوآبَ الْوَاقِعَةِ عَلَى حُدُودِ أَرْنُونَ الْقَصِيَّةِ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","فَقَالَ بَالاقُ لِبَلْعَامَ: «أَلَمْ أَبْعَثْ إِلَيْكَ أَسْتَدْعِيكَ؟ فَلِمَاذَا لَمْ تَقْدِمْ عَلَيَّ؟ أَحَقّاً أَعْجَزُ عَنْ إِكْرَامِكَ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","فَأَجَابَ بَلْعَامُ: «هَا أَنَا جِئْتُ إِلَيْكَ. أَتَظُنُّ أَنَّ فِي وُسْعِي أَنْ أَتَكَلَّمَ الآنَ بِمَا أُرِيدُ؟ عَلَيَّ أَنْ أَنْطِقَ فَقَطْ بِمَا يَأْمُرُنِي بِهِ الرَّبُّ». ");
INSERT INTO arbnav_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","فَمَضَى بَلْعَامُ مَعَ بَالاقَ حَتَّى أَقْبَلا إِلَى قَرْيَةِ حَصُوتَ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","فَذَبَحَ بَالاقُ بَقَراً وَغَنَماً وَأَرْسَلَهَا إِلَى بَلْعَامَ وَمَنْ مَعَهُ مِنَ الرُّؤَسَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","وَفِي الصَّبَاحِ التَّالِي أَخَذَ بَالاقُ بَلْعَامَ إِلَى مُرْتَفَعَاتِ بَعْلٍ، فَرَأَى مِنْ هُنَاكَ بَنِي إِسْرَائِيلَ كُلَّهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","فَقَالَ بَلْعَامُ لِبَالاقَ: «ابْنِ لِي هُنَا سَبْعَةَ مَذَابِحَ، وَأَعِدَّ لِي هُنَا سَبْعَةَ ثِيرَانٍ وَسَبْعَةَ كِبَاشٍ». ");
INSERT INTO arbnav_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","فَفَعَلَ بَالاقُ كَمَا طَلَبَ بَلْعَامُ. وَقَرَّبَ بَالاقُ وَبَلْعَامُ ثَوْراً وَكَبْشاً عَلَى كُلِّ مَذْبَحٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ثُمَّ قَالَ بَلْعَامُ لِبَالاقَ: «قِفْ هُنَا عِنْدَ مُحْرَقَاتِكَ فَأَمْضِيَ أَنَا، لَعَلَّ الرَّبَّ يَأْتِي لِلِقَائِي، وَمَهْمَا يُعْلِنْ لِي أُبْلِغْكَ بِهِ». ثُمَّ ارْتَقَى بَلْعَامُ رَابِيَةً. ");
INSERT INTO arbnav_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","فَوَافَى اللهُ بَلْعَامَ. فَقَالَ بَلْعَامُ: «قَدْ أَعْدَدْتُ سَبْعَةَ مَذَابِحَ وَقَرَّبْتُ ثَوْراً وَكَبْشاً عَلَى كُلِّ مَذْبَحٍ». ");
INSERT INTO arbnav_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","فَحَمَّلَ الرَّبُّ بَلْعَامَ رِسَالَةً وَقَالَ: «ارْجِعْ إِلَى بَالاقَ وَبَلِّغْهُ إِيَّاهَا». ");
INSERT INTO arbnav_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","فَعَادَ إِلَيْهِ، وَإذَا بِهِ مَازَالَ وَاقِفاً عِنْدَ مُحْرَقَاتِهِ، وَمَعَهُ جَمِيعُ رُؤَسَاءِ مُوآبَ، ");
INSERT INTO arbnav_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","فَنَطَقَ بِنُبُوءَتِهِ قَائِلاً: «أَتَى بِي بَالاقُ مَلِكُ مُوآبَ مِنْ بِلادِ أَرَامَ مِنَ الْجِبَالِ الشَّرْقِيَّةِ، وَقَالَ: تَعَالَ الْعَنْ لِي يَعْقُوبَ، وَاشْتِمْ لِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","كَيْفَ أَلْعَنُ مَنْ لَمْ يَلْعَنْهُ اللهُ؟ وَكَيْفَ أَشْتِمُ مَنْ لَمْ يَشْتِمْهُ الرَّبُّ؟ ");
INSERT INTO arbnav_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","هَا أَنَا أَرَاهُمْ مِنْ قِمَمِ الصُّخُورِ، وَمِنَ الآكَامِ أُبْصِرُهُمْ. هُوَذَا شَعْبٌ يَسْكُنُ وَحْدَهُ. وَلا يَحْسَبُونَ أَنْفُسَهُمْ أُمَّةً مِنَ الأُمَمِ. ");
INSERT INTO arbnav_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","مَنْ يَقْدِرُ أَنْ يُحْصِيَ تُرَابَ يَعْقُوبَ أَوْ يَعُدَّ رُبْعَ إِسْرَائِيلَ؟ لِتَمُتْ نَفْسِي مَوْتَ الأَبْرَارِ، وَلْتَكُنْ آخِرَتِي كَآخِرَتِهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","فَقَالَ بَالاقُ لِبَلْعَامَ: «مَاذَا فَعَلْتَ بِي؟ لَقَدِ اسْتَدْعَيْتُكَ لِتَشْتِمَ أَعْدَائِي، وَهَا أَنْتَ تُبَارِكُهُمْ» ");
INSERT INTO arbnav_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","فَأَجَابَهُ: «إِنَّنِي أَحْرِصُ أَنْ لَا أَتَكَلَّمَ إِلّا بِمَا يَضَعُهُ الرَّبُّ عَلَى فَمِي». ");
INSERT INTO arbnav_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","فَقَالَ لَهُ بَالاقُ: «تَعَالَ مَعِي إِلَى مَوْضِعٍ آخَرَ فَلا تَرَى مِنْهُ إِلّا طَرَفَ مُخَيَّمِ الشَّعْبِ فَقَطْ، وَالْعَنْهُ لِي مِنْ هُنَاكَ». ");
INSERT INTO arbnav_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","فَأَخَذَهُ إِلَى حَقْلِ صُوفِيمَ الْمُشْرِفِ عَلَى رَأْسِ الْفِسْجَةِ وَهُنَاكَ شَيَّدَ سَبْعَةَ مَذَابِحَ، وَقَرَّبَ بَلْعَامُ ثَوْراً وَكَبْشاً عَلَى كُلِّ مَذْبَحٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","وَقَالَ لِبَالاقَ: «انْتَظِرْنِي هُنَاكَ عِنْدَ مُحْرَقَاتِكَ وَأَنَا أَمْضِي إِلَى هُنَاكَ». ");
INSERT INTO arbnav_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","فَوَافَى الرَّبُّ بَلْعَامَ وَلَقَّنَهُ رِسَالَةً وَقَالَ لَهُ: «ارْجِعْ إِلَى بَالاقَ وَبَلِّغْهُ إِيَّاهَا». ");
INSERT INTO arbnav_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","فَأَقْبَلَ عَلَى بَالاقَ، وَإذَا بِهِ مُنْتَظِرٌ عِنْدَ مُحْرَقَاتِهِ وَمَعَهُ رُؤَسَاءُ مُوآبَ. فَسَأَلَهُ بَالاقُ: «مَاذَا تَكَلَّمَ بِهِ الرَّبُّ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","فَضَرَبَ مَثَلَهُ قَائِلاً: «انْهَضْ يَا بَالاقُ وَأَصْغَ، اسْتَمِعْ إِلَيَّ يَا ابْنَ صِفُّورَ ");
INSERT INTO arbnav_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","لَيْسَ اللهُ إِنْسَاناً فَيَكْذِبَ. وَلا هُوَ ابْنَ آدَمَ فَيَنْدَمَ. هَلْ يَقُولُ وَلا يَفْعَلُ أَوْ يَعِدُ ولا يَفِي؟ ");
INSERT INTO arbnav_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","إِنِّي أُمِرْتُ أَنْ أُبَارِكَ، وَهُوَ قَدْ بَارَكَ وَلا طَاقَةَ لِي عَلَى رَدِّهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","لَمْ يَشْهَدْ إِثْماً فِي يَعْقُوبَ، وَلَمْ يَرَ مَشَقَّةً فِي إِسْرَائِيلَ. الرَّبُّ إِلَهُهُمْ مَعَهُمْ، وَهُتَافٌ لِلْمَلِكِ فِيهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","اللهُ أَخْرَجَهُمْ مِنْ مِصْرَ، وَقُوَّتُهُمْ مِثْلُ قُوَّةِ الثَّوْرِ الْوَحْشِيِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","فَلا عِيَافَةَ تَضُرُّ يَعْقُوبَ، وَلا عِرَافَةَ تُؤَثِّرُ فِي إِسْرَائِيلَ. مُنْذُ الآنَ يُقَالُ عَنْ يَعْقُوبَ وَعَنْ إِسْرَائِيلَ: ’انْظُرْ مَاذَا فَعَلَ اللهُ!‘ ");
INSERT INTO arbnav_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","هُوَذَا شَعْبٌ يَتَحَفَّزُ كَلَبْوَةٍ وَيَنْهَضُ كَأَسَدٍ. لَا يَنَامُ حَتَّى يَلْتَهِمَ فَرِيسَةً وَيَلَغَ فِي دَمِ قَتْلَى». ");
INSERT INTO arbnav_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","فَقَالَ بَالاقُ لِبَلْعَامَ: «إِذَنْ لَا تَلْعَنْهُ وَلا تُبَارِكْهُ!» ");
INSERT INTO arbnav_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","فَأَجَابَ بَلْعَامُ: «أَلَمْ أُخْبِرْكَ أَنَّنِي لَنْ أَنْطِقَ إِلّا بِمَا يَأْمُرُنِي بِهِ الرَّبُّ؟» ");
INSERT INTO arbnav_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","فَقَالَ بَالاقُ: «دَعْنِي آخُذُكَ إِلَى مَوْضِعٍ آخَرَ، فَعَسَى أَنْ يَحْسُنَ فِي عَيْنَيِ اللهِ أَنْ تَلْعَنَ لِيَ الشَّعْبَ مِنْ هُنَاكَ». ");
INSERT INTO arbnav_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","فَأَخَذَ بَالاقُ بَلْعَامَ إِلَى قِمَّةِ جَبَلِ فَغُورَ الْمُشْرِفِ عَلَى امْتِدَادِ الصَّحْرَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","فَقَالَ بَلْعَامُ لِبَالاقَ: «ابْنِ لِي هُنَا سَبْعَةَ مَذَابِحَ. وَجَهِّزْ لِي هُنَا سَبْعَةَ ثِيرَانٍ وَسَبْعَةَ كِبَاشٍ». ");
INSERT INTO arbnav_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","فَلَبَّى بَالاقُ طَلَبَ بَلْعَامَ، وَقَرَّبَ ثَوْراً وَكَبْشاً عَلَى كُلِّ مَذْبَحٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","وَلَمَّا رَأَى بَلْعَامُ أَنَّ الرَّبَّ يُسَرُّ بِمُبَارَكَةِ إِسْرَائِيلَ لَمْ يَمْضِ كَالْمَرَّتَيْنِ السَّابِقَتَيْنِ لِمُلاقَاةِ الرَّبِّ، لَكِنَّهُ تَوَجَّهَ بِنَظَرِهِ نَحْوَ الصَّحْرَاءِ، ");
INSERT INTO arbnav_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","وَهُنَاكَ شَاهَدَ بَنِي إِسْرَائِيلَ مُخَيِّمِينَ حَسَبَ أَسْبَاطِهِمْ، فَحَلَّ عَلَيْهِ رُوحُ اللهِ، ");
INSERT INTO arbnav_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","وَتَنَبَّأَ قَائِلاً: «كَلامُ بَلْعَامَ بْنِ بَعُورَ، كَلامُ الرَّجُلِ الْمَفْتُوحِ الْعَيْنَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","كَلامُ مَنْ يَسْمَعُ أَقْوَالَ اللهِ، الَّذِي يُشَاهِدُ رُؤْيَا الْقَدِيرِ. الَّذِي يَنْطَرِحُ فَتَنْفَتِحُ عَيْنَاهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","مَا أَجْمَلَ خِيَامَكَ يَا يَعْقُوبُ، وَمَا أَبْهَى مَسَاكِنَكَ يَا إِسْرَائِيلُ! ");
INSERT INTO arbnav_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","هِيَ مِثْلُ أَوْدِيَةٍ مُمْتَدَّةٍ، وَكَجَنَّاتٍ عَلَى مَجْرَى نَهْرٍ، وَكَشَجَرَاتِ صَبَّارٍ غَرَسَهَا الرَّبُّ، وَمِثْلُ أَشْجَارِ الأَرْزِ النَّامِيَةِ بِجُوَارِ الْمِيَاهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","تَجْرِي مِيَاهٌ مِنْ مَسَاقِيهِ، وَلِزَرْعِهِ يَتَوَافَرُ مَاءٌ غَزِيرٌ. يَكُونُ مَلِكُهُ أَعْظَمَ شَأْناً مِنْ أَجَاجَ وَتَتَسَامَى مَمْلَكَتُهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","اللهُ أَخْرَجَهُ مِنْ مِصْرَ، وَقُوَّتُهُ مِثْلُ الثَّوْرِ الْوَحْشِيِّ. يَفْتَرِسُ خُصُومَهُ مِنَ الأُمَمِ، وَيَقْضَمُ عِظَامَهُمْ وَيُثْخِنُهُمْ بِسِهَامِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","يَجْثِمُ كَأَسَدٍ، وَيَرْبِضُ كَلَبْوَةٍ. فَمَنْ يَجْرُؤُ عَلَى إِثَارَتِهِ؟ مَنْ يُبَارِكُكَ يَكُونُ مُبَارَكاً، وَمَنْ يَلْعَنُكَ يَكُونُ مَلْعُوناً». ");
INSERT INTO arbnav_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","فَاسْتَشَاطَ بَالاقُ غَضَباً عَلَى بَلْعَامَ، وَضَرَبَ كَفّاً عَلَى كَفٍّ قَائِلاً لَهُ: «دَعَوْتُكَ لِتَشْتِمَ أَعْدَائِي، وَهَا أَنْتَ قَدْ بَارَكْتَهُمْ ثَلاثَ مَرَّاتٍ! ");
INSERT INTO arbnav_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","وَالآنَ اغْرُبْ عَنْ وَجْهِي وَامْضِ إِلَى بَيْتِكَ، فَقَدْ كَانَ فِي عَزْمِي إِكْرَامُكَ وَلَكِنَّ الرَّبَّ شَاءَ أَنْ لَا تَحْظَى بِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","فَأَجَابَهُ بَلْعَامُ: «أَلَمْ أَقُلْ لِرُسُلِكَ الَّذِينَ بَعَثْتَهُمْ إِلَيَّ ");
INSERT INTO arbnav_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","إِنَّهُ وَلَوْ أَغْدَقَ عَلَيَّ بَالاقُ مِلْءَ قَصْرِهِ ذَهَباً وَفِضَّةً فَلَنْ أَعْصَى أَمْرَ الرَّبِّ، فَأَصْنَعَ خَيْراً أَوْ شَرّاً مِنْ نَفْسِي؟ فَإِنَّ مَا يُعْلِنُهُ لِي الرَّبُّ فَإِيَّاهُ أُبَلِّغُ. ");
INSERT INTO arbnav_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","وَالآنَ أَعُودُ إِلَى شَعْبِي، وَلَكِنْ دَعْنِي أُنْبِئُكَ بِمَا سَيُنْزِلُهُ هَذَا الشَّعْبُ بِقَوْمِكَ فِي آخِرِ الأَيَّامِ». ");
INSERT INTO arbnav_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ثُمَّ تَنَبَّأَ قَائِلاً: «كَلامُ بَلْعَامَ بْنِ بَعُورَ، كَلامُ الرَّجُلِ الْمَفْتُوحِ الْعَيْنَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","كَلامُ مَنْ يَسْمَعُ أَقْوَالَ اللهِ، وَيَتَلَقَّى الْمَعْرِفَةَ مِنَ الْعَلِيِّ، الَّذِي يُشَاهِدُ رُؤْيَا الْقَدِيرِ، الَّذِي يَنْطَرِحُ فَتَنْفَتِحُ عَيْنَاهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","أَرَاهُ وَلَكِنْ لَيْسَ حَاضِراً، وَأُبْصِرُهُ وَلَكِنْ لَيْسَ قَرِيباً. يَخْرُجُ نَجْمٌ مِنْ يَعْقُوبَ، وَيَظْهَرُ مَلِكٌ مِنْ إِسْرَائِيلَ فَيُحَطِّمُ طَرَفَيْ مُوآبَ، وَيُهْلِكُ كُلَّ رِجَالِ الْحَرْبِ. ");
INSERT INTO arbnav_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","وَيَرِثُ أَرْضَ أَدُومَ، وَيَتَمَلَّكُ دِيَارَ سَعِيرَ. أَمَّا إِسْرَائِيلُ فَيَزْدَادُ قُوَّةً. ");
INSERT INTO arbnav_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","وَيَبْرُزُ حَاكِمٌ مِنْ يَعْقُوبَ فَيُدَمِّرُ مَا تَبَقَّى مِنْ مُدُنٍ». ");
INSERT INTO arbnav_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ثُمَّ تَطَلَّعَ بَلْعَامُ نَحْوَ مَسَاكِنِ أَهْلِ عَمَالِيقَ فَتَنَبَّأَ: «كَانَ عَمَالِيقُ أَوَّلَ الشُّعُوبِ، أَمَّا عَاقِبَتُهُ فَإِلَى الْهَلاكِ». ");
INSERT INTO arbnav_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ثُمَّ الْتَفَتَ نَحْوَ الْقَيْنِيِّينَ فَأَنْبَأَ: «لِيَكُنْ مَسْكَنُكَ مَنِيعاً، وَعُشُّكَ مَوْضُوعاً فِي صَخْرَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","وَإِنَّمَا سَتُدَمَّرُونَ عِنْدَمَا يَطْرُدُكُمُ الأَشُّورِيُّونَ». ");
INSERT INTO arbnav_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ثُمَّ تَنَبَّأَ قَائِلاً: «مَنْ لَهُ طَاقَةٌ عَلَى الْعَيْشِ حِينَ يُجْرِي الرَّبُّ ذَلِكَ؟ ");
INSERT INTO arbnav_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","تُقْبِلُ سُفُنٌ مِنْ كِتِّيمَ، وَتُخْضِعُ أَشُورَ وَتُذِلُّ عَابِرَ، فَهُمَا أَيْضاً يَهْلِكَانِ». ");
INSERT INTO arbnav_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ثُمَّ رَجَعَ بَلْعَامُ إِلَى دِيَارِهِ، وَأَمَّا بَالاقُ فَمَضَى فِي سَبِيلِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","وَأَقَامَ الإِسْرَائِيلِيُّونَ فِي شِطِّيمَ، فَشَرَعَ الرِّجَالُ يَرْتَكِبُونَ الزِّنَى مَعَ الْمُوآبِيَّاتِ ");
INSERT INTO arbnav_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","اللَّوَاتِي أَغْوَيْنَ الشَّعْبَ لِحُضُورِ ذَبَائِحِ آلِهَتِهِنَّ وَالأَكْلِ مِنْهَا وَالسُّجُودِ لَهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","فَاشْتَرَكَ الإِسْرَائِيلِيُّونَ فِي عِبَادَةِ بَعْلِ فَغُورَ. فَاحْتَدَمَ غَضَبُ الرَّبِّ عَلَيْهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","فَقَالَ الرَّبُّ لِمُوسَى: «خُذْ جَمِيعَ قَادَةِ عَبَدَةِ الْبَعْلِ وَاصْلِبْهُمْ، وَعَلِّقْهُمْ تَحْتَ وَطْأَةِ حَرَارَةِ الشَّمْسِ أَمَامَ الرَّبِّ، فَتَرْتَدَّ شِدَّةُ غَضَبِهِ عَنْ بَنِي إِسْرَائِيلَ». ");
INSERT INTO arbnav_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","فَقَالَ مُوسَى لِقُضَاةِ إِسْرَائِيلَ: «اقْتُلُوا كُلَّ وَاحِدٍ مِنْ قَوْمِكُمْ مِنَ الْمُتَعَلِّقِينَ بِعِبَادَةِ بَعْلِ فَغُورَ». ");
INSERT INTO arbnav_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","وَإِذْ كَانَ مُوسَى وَسَائِرُ جَمَاعَةِ إِسْرَائِيلَ يَبْكُونَ عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ، أَقْبَلَ إِسْرَائِيلِيٌّ وَقَدَّمَ إِلَى إِخْوَتِهِ امْرَأَةً مِدْيَانِيَّةً عَلَى مَرْأَى مِنْهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","فَلَمَّا رَأَى فِينْحَاسُ بْنُ أَلِعَازَارَ بْنِ هَرُونَ ذَلِكَ، هَبَّ مِنْ بَيْنِ الْجَمَاعَةِ، وَتَنَاوَلَ رُمْحاً بِيَدِهِ، ");
INSERT INTO arbnav_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","وَتَبِعَ الإِسْرَائِيلِيَّ إِلَى الْخَيْمَةِ حَيْثُ طَعَنَهُمَا. فَاخْتَرَقَ الرُّمْحُ الرَّجُلَ الإِسْرَائِيلِيَّ وَبَطْنَ الْمَرأَةِ، فَكَفَّ الْوَبَأُ عَنْ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","وَكَانَ عَدَدُ الَّذِينَ مَاتُوا بِالْوَبَإِ أَرْبَعَةً وَعِشْرِينَ أَلْفاً. ");
INSERT INTO arbnav_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","فَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«إِنَّ فِينْحَاسَ بْنَ أَلِعَازَارَ بْنِ هَرُونَ الْكَاهِنِ قَدْ رَدَّ غَضَبِي عَنْ بَنِي إِسْرَائِيلَ، إِذْ غَارَ غَيْرَتِي فِي وَسَطِهِمْ، فَلَمْ أَفْنِ بَنِي إِسْرَائِيلَ بِغَيْرَتِي. ");
INSERT INTO arbnav_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","لِذَلِكَ قُلْ لَهُ: هَأَنَذَا أَقْطَعُ مَعَهُ مِيثَاقَ سَلامٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","فَيَكُونُ لَهُ وَلِنَسْلِهِ مِنْ بَعْدِهِ مِيثَاقَ كَهَنُوتٍ أَبَدِيٍّ، لأَنَّهُ غَارَ للهِ وَكَفَّرَ عَنِ الإِسْرَائِيلِيِّينَ». ");
INSERT INTO arbnav_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","وَكَانَ اسْمُ الإِسْرَائِيلِيِّ الَّذِي قُتِلَ مَعَ الْمَرْأَةِ الْمِدْيَانِيَّةِ زِمْرِيَ بْنَ سَالُو، وَهُوَ أَحَدُ رُؤَسَاءِ عَائِلَةٍ مِنْ سِبْطِ شِمْعُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","أَمَّا الْمَرْأَةُ الْمِدْيَانِيَّةُ الْمَقْتُولَةُ فَكَانَ اسْمُهَا كُزْبِيَ بِنْتَ صُورٍ الَّذِي كَانَ رَئِيسَ قَبِيلَةٍ مِنْ قَبَائِلِ مِدْيَانَ. ");
INSERT INTO arbnav_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«أَسِيئُوا مُعَامَلَةَ الْمِدْيَانِيِّينَ وَأَهْلِكُوهُمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","لأَنَّهُمْ ضَايَقُوكُمْ بِمَكَايِدِهِمِ الَّتِي احْتَالُوا بِها عَلَيْكُمْ بِشَأْنِ فَغُورَ، وَأُخْتِهِمْ كُزْبِي ابْنَةِ رَئِيسٍ لِمِدْيَانَ، الَّتِي قُتِلَتْ عِنْدَمَا تَفَشَّى الْوَبَأُ بِسَبَبِ عِبَادَةِ فَغُورَ». ");
INSERT INTO arbnav_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","وَبَعْدَ تَوَقُّفِ الْوَبَإِ قَالَ الرَّبُّ لِمُوسَى وَأَلِعَازَارَ بْنِ هَرُونَ الْكَاهِنِ: ");
INSERT INTO arbnav_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«أَحْصِيَا كُلَّ جَمَاعَةِ إِسْرَائِيلَ، مِنِ ابْنِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، مِنَ الْقَادِرِينَ عَلَى التَّجَنُّدِ فِي جَيْشِ إِسْرَائِيلَ، حَسَبَ انْتِمَاءِ كُلٍّ مِنْهُمْ لِسِبْطِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","فَقَالَ مُوسَى وَأَلِعَازَارُ الْكَاهِنُ لِلشَّعْبِ فِي سُهُولِ مُوآبَ بِقُرْبِ نَهْرِ الأُرْدُنِّ مُقَابِلَ أَرِيحَا: ");
INSERT INTO arbnav_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«أَحْصُوا كُلَّ رَجُلٍ مِنِ ابْنِ عِشْرِينَ سَنَةً فَمَا فَوْقُ، كَمَا أَمَرَ الرَّبُّ مُوسَى». فَكَانَ هَؤُلاءِ هُمُ الْخَارِجُونَ مِنْ دِيَارِ مِصْرَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","رَأُوبَيْنُ بِكْرُ يَعْقُوبَ، أَمَّا أَبْنَاؤُهُ فَهُمْ: حَنُوكُ رَأْسُ عَشِيرَةِ الْحَنُوكِيِّينَ، وَفَلُّو رَأْسُ عَشِيرَةِ الْفَلُّويِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","وَحَصْرُونُ رَأْسُ عَشِيرَةِ الْحَصْروُنِيِّينَ، وَكَرْمِي رَأْسُ عَشِيرَةِ الْكَرْمِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","هَذِهِ الْعَشَائِرُ الْمُنْحَدِرَةُ مِنْ نَسْلِ رَأُوبَيْنَ. وَكَانَ الْمُحْصَوْنَ مِنْهُمْ ثَلاثَةً وَأَرْبَعِينَ أَلْفاً وَسَبْعَ مِئَةٍ وَثَلاثِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","وَأَلِيآبُ بْنُ فَلُّو. ");
INSERT INTO arbnav_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","أَمَّا أَبْنَاءُ أَلِيآبَ فَهُمْ: نَمُوئِيلُ وَدَاثَانُ وَأَبِيرَامُ. وَكَانَ دَاثَانُ وَأَبِيرَامُ مِنَ الْمُنْتَخَبِينَ فِي الْمَجْلِسِ وَهُمَا اللَّذَانِ خَاصَمَا مُوسَى وَهَرُونَ مَعَ بَقِيَّةِ جَمَاعَةِ قُورَحَ حِينَ تَمَرَّدُوا عَلَى الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","فَانْشَقَّتِ الأَرْضُ آنَئِذٍ وَابْتَلَعَتْهُمَا مَعَ قُورَحَ، حِينَ أَحْرَقَتِ النَّارُ الْقَوْمَ الْبَالِغَ عَدَدُهُمْ مِئَتَيْنِ وَخَمْسِينَ رَجُلاً، فَصَارُوا عِبْرَةً. ");
INSERT INTO arbnav_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","غَيْرَ أَنَّ أَبْنَاءَ قُورَحَ لَمْ يَهْلِكُوا. ");
INSERT INTO arbnav_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","أَمَّا أَبْنَاءُ شِمْعُونَ فَهُمْ: نَمُوئِيلُ رَأْسُ عَشِيرَةِ النَّمُوئِيلِيِّينَ، وَيَامِينُ رَأْسُ عَشِيرَةِ الْيَامِينِيِّينَ، وَيَاكِينُ رَأْسُ عَشِيرَةِ الْيَاكِينِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","وَزَارَحُ رَأْسُ عَشِيرَةِ الزَّارَحِيِّينَ. وَشَأُولُ رَأْسُ عَشِيرَةِ الشَّأُولِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","هَذِهِ هِيَ الْعَشَائِرُ الْمُنْحَدِرَةُ مِنْ نَسْلِ شِمْعُونَ، وَعَدَدُ الْمُحْصَيْنَ مِنْهُمُ اثْنَانِ وَعِشْرُونَ أَلْفاً وَمِئَتَانِ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","أَمَّا أَبْنَاءُ جَادٍ فَهُمْ: صِفُونُ رَأْسُ عَشِيرَةِ الصِّفُونِيِّينَ، وَحَجِّي رَأْسُ عَشِيرَةِ الْحَجِّيِّينَ، وَشُونِي رَأْسُ عَشِيرَةِ الشُّونِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","وَأُزْنِي رَأْسُ عَشِيرَةِ الأُزْنِيِّينَ، وَعِيرِي رَأْسُ عَشِيرَةِ الْعِيرِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","وَأَرُودُ رَأْسُ عَشِيرَةِ الأَرُودِيِّينَ، وَأَرْئِيلِي رَأْسُ عَشِيرَةِ الأَرْئِيلِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","هَذِهِ هِيَ الْعَشَائِرُ الْمُنْحَدِرَةُ مِنْ نَسْلِ جَادٍ. وَكَانَ الْمُحْصَوْنَ مِنْهُمْ أَرْبَعِينَ أَلْفاً وَخَمْسَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","أَمَّا ابْنَا يَهُوذَا عِيرُ وَأُونَانُ فَقَدْ مَاتَا فِي أَرْضِ كَنْعَانَ مِنْ غَيْرِ عَقِبٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","وَالَّذِينَ أَعْقَبُوا نَسْلاً مِنْ أَبْنَاءِ يَهُوذَا هُمْ: شِيلَةُ رَأْسُ عَشِيرَةِ الشِّيلِيِّينَ، وَفَارَصُ رَأْسُ عَشِيرَةِ الْفَارَصِيِّينَ، وزَارَحُ رَأْسُ عَشِيرَةِ الزَّارَحِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","وَأَبْنَاءُ فَارَصَ: حَصْرُونُ رَأْسُ عَشِيرَةِ الْحَصْرُونِيِّينَ، وَحَامُولُ رَأْسُ عَشِيرَةِ الْحَامُولِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","هَذِهِ هِيَ الْعَشَائِرُ الْمُنْحَدِرَةُ مِنْ نَسْلِ يَهُوذَا. وَكَانَ الْمُحْصَوْنَ مِنْهُمْ سِتَّةً وَسَبْعِينَ أَلْفاً وَخَمْسَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","أَمَّا أَبْنَاءُ يَسَّاكَرَ فَهُمْ: تُولاعُ رَأْسُ عَشِيرَةِ التُّولاعِيِّينَ، وَفُوَّةُ رَأْسُ عَشِيرَةِ الْفُوِّيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","وَيَاشُوبُ رَأْسُ عَشِيرَةِ الْيَاشُوبِيِّينَ، وَشِمْرُونُ رَأْسُ عَشِيرَةِ الشِّمْرُونِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","هَذِهِ هِيَ الْعَشَائِرُ الْمُنْحَدِرَةُ مِنْ نَسْلِ يَسَّاكَرَ. وَكَانَ الْمُحْصَوْنَ مِنْهُمْ أَرْبَعَةً وَسِتِّينَ أَلْفاً وَثَلاثَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","أَمَّا أَبْنَاءُ زَبُولُونَ فَهُمْ: سَارَدُ رَأْسُ عَشِيرَةِ السَّارَدِيِّينَ، وَإِيلُونُ رَأْسُ عَشِيرَةِ الإِيلُونِيِّينَ وَيَاحِلْئِيلُ رَأْسُ عَشِيرَةِ الْيَاحِلْئِيلِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","هَذِهِ هِيَ الْعَشَائِرُ الْمُنْحَدِرَةُ مِنْ نَسْلِ زَبُولُونَ. وَكَانَ الْمُحْصَوْنَ مِنْهُمْ سِتِّينَ أَلْفاً وَخَمْسَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","أَمَّا ابْنَا يُوسُفَ فَهُمَا: مَنَسَّى وَأَفْرَايِمُ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","وَنَسْلُ مَنَسَّى مَاكِيرُ رَأْسُ عَشِيرَةِ الْمَاكِيرِيِّينَ، وَأَنْجَبَ مَاكِيرُ جِلْعَادَ، فَكَانَ جِلْعَادُ رَأْسَ عَشِيرَةِ الْجِلْعَادِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","وَهَؤُلاءِ هُمْ أَبْنَاءُ جِلْعَادَ: إِيعَزَرُ رَأْسُ عَشِيرَةِ الإِيعَزَرِيِّينَ وَحَالَقُ رَأْسُ عَشِيرَةِ الْحَالَقِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","وَأَسْرِيئِيلُ رَأْسُ عَشِيرَةِ الأَسْرِيئِيلِيِّينَ، وَشَكَمُ رَأْسَ عَشِيرَةِ الشَّكَمِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","وَشَمِيدَاعُ رَأْسُ عَشِيرَةِ الشَّمِيدَاعِيِّينَ، وَحَافَرُ رَأْسُ عَشِيرَةِ الْحَافَرِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","وَأَنْجَبَ حَافَرُ صَلُفْحَادَ الَّذِي لَمْ يُنْجِبْ سِوَى بَنَاتٍ هُنَّ: مَحْلَةُ وَنُوعَةُ وَحُجْلَةُ وَمِلْكَةُ وَتِرْصَةُ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","هَذِهِ هِيَ الْعَشَائِرُ الْمُنْحَدِرَةُ مِنْ نَسْلِ مَنَسَّى. وَكَانَ الْمُحْصَوْنَ مِنْهُمُ اثْنَيْنِ وَخَمْسِينَ أَلْفاً وَسَبْعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","أَمَّا أَبْنَاءُ أَفْرَايِمَ فَهُمْ: شُوتَالَحُ رَأْسُ عَشِيرَةِ الشُّوتَالَحِيِّينَ، وَبَاكَرُ رَأْسُ عَشِيرَةِ الْبَاكَرِيِّينَ، وَتَاحَنُ رَأْسَ عَشِيرَةِ التَّاحَنِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","وَأَنْجَبَ شُوتَالَحُ عِيرَانَ رَأْسُ عَشِيرَةِ الْعِيرَانِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","هَذِهِ هِيَ الْعَشَائِرُ الْمُنْحَدِرَةُ مِنْ نَسْلِ أَفْرَايِمَ. وَكَانَ الْمُحْصَوْنَ مِنْهُمْ اثْنَيْنِ وَثَلاثِينَ أَلْفاً وَخَمْسَ مِئَةٍ، وَجَمِيعُ هَذِهِ الْعَشَائِرِ مِنْ نَسْلِ يُوسُفَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","أَمَّا أَبْنَاءُ بِنْيَامِينَ فَهُمْ: بَالَعُ رَأْسُ عَشِيرَةِ الْبَالَعِيِّينَ، وَأَشْبِيلُ رَأْسُ عَشِيرَةِ الأَشْبِيلِيِّينَ، وَأَحِيرَامُ رَأْسُ عَشِيرَةِ الأَحِيرَامِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","وَشَفُوفَامُ رَأْسُ عَشِيرَةِ الشَّفُوفَامِيِّينَ، وَحُوفَامُ رَأْسُ عَشِيرَةِ الْحُوفَامِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","وَأَنْجَبَ بَالَعُ أَرْدَ وَنُعْمَانَ، فَكَانَ أَرْدُ رَأْسَ عَشِيرَةِ الأَرْدِيِّينَ، وَنُعْمَانُ رَأْسَ عَشِيرَةِ النُّعْمَانِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","هَذِهِ هِيَ الْعَشَائِرُ الْمُنْحَدِرَةُ مِنْ نَسْلِ بِنْيَامِينَ، وَكَانَ الْمُحْصَوْنَ مِنْهُمْ خَمْسَةً وَأَرْبَعِينَ أَلْفاً وَسِتَّ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","أَمَّا ابْنُ دَانٍ فَهُوَ: شُوحَامُ رَأْسُ عَشِيرَةِ الشُّوحَامِيِّينَ، وَهِيَ الْعَشِيرَةُ الْمُنْحَدِرَةُ مِنْ نَسْلِ دَانَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","وَكَانَ الْمُحْصَوْنَ مِنْ عَشِيرَةِ الشُّوحَامِيِّينَ أَرْبَعَةً وَسِتيِّنَ أَلْفاً وَأَرْبَعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","أَمَّا أَبْنَاءُ أَشِيرَ فَهُمْ: يِمْنَةُ رَأْسُ عَشِيرَةِ الْيِمْنِيِّينَ، وَيِشْوِي رَأْسُ عَشِيرَةِ الْيِشْوِيِّينَ، وَبَرِيعَةُ رَأْسُ عَشِيرَةِ الْبَرِيعِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","وَأَنْجَبَ بَرِيعَةُ حَابَرَ رَأْسَ عَشِيرَةِ الْحَابَرِيِّينَ، وَمَلْكِيئِيلَ رَأْسَ عَشِيرَةِ الْمَلْكِيئِيلِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","وَكَانَ لأَشِيرَ ابْنَةٌ اسْمُهَا سَارَحُ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","هَذِهِ هِيَ الْعَشَائِرُ الْمُنْحَدِرَةُ مِنْ نَسْلِ أَشِيرَ، وَكَانَ الْمُحْصَوْنَ مِنْهُمْ ثَلاثَةً وَخَمْسِينَ أَلْفاً وَأَرْبَعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","أَمَّا أَبْنَاءُ نَفْتَالِي فَهُمْ: يَاحَصْئِيلُ رَأْسُ عَشِيرَةِ الْيَاحَصْئِيلِيِّينَ، وَجُونِي رَأْسُ عَشِيرَةِ الْجُونِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","وَيِصِرُ رَأْسُ عَشِيرَةِ الْيِصِرِيِّينَ، وَشِلِّيمُ رَأْسُ عَشِيرَةِ الشِّلِّيمِيِّينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","هَذِهِ هِيَ الْعَشَائِرُ الْمُنْحَدِرَةُ مِنْ نَسْلِ نَفْتَالِي، وَكَانَ الْمُحْصَوْنَ مِنْهُمْ خَمْسَةً وَأَرْبَعِينَ أَلْفاً وَأَرْبَعَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","فَكَانَتْ جُمْلَةُ الْمُحْصَيْنَ مِنْ بَنِي إِسْرَائِيلَ سِتَّ مِئَةِ أَلْفٍ وَأَلْفاً وَسَبْعَ مِئَةٍ وَثَلاثِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ثُمَّ قَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«قَسِّمِ الأَرْضَ بَيْنَ الأَسْبَاطِ وَفْقاً لِنِسْبَةِ عَدَدِ أَفْرَادِ كُلِّ سِبْطٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","فَالسِّبْطُ الْكَبِيرُ أَعْطِهِ نَصِيباً أَكْبَرَ، وَالسِّبْطُ الصَّغِيرُ أَعْطِهِ نَصِيباً أَقَلَّ. أَعْطِ كُلَّ سِبْطٍ حَسَبَ أَعْدَادِ أَفْرَادِهِ الْمُحْصَيْنَ، ");
INSERT INTO arbnav_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","عَلَى أَنْ تُوَزَّعَ الأَرْضُ بِالْقُرْعَةِ، فَيَمْلِكُونَ الأَرْضَ حَسَبَ أَسْمَاءِ آبَاءِ أَسْبَاطِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","فَتُوَزَّعُ الأَرْضُ مَا بَيْنَ الأَسْبَاطِ الْكَبِيرَةِ وَالصَّغِيرَةِ بِالْقُرْعَةِ». ");
INSERT INTO arbnav_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","أَمَّا اللّاوِيُّونَ الَّذِينَ أُحْصُوْا حَسَبَ عَشَائِرِهِمْ فَهُمْ: الْجِرْشُونِيُّونَ مِنْ نَسْلِ جِرْشُونَ، وَالْقَهَاتِيُّونَ مِنْ نَسْلِ قَهَاتَ، وَالْمَرَارِيُّونَ مِنْ نَسْلِ مَرَارِي. ");
INSERT INTO arbnav_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","وَمِنْ عَشَائِرِ لاوِي أَيْضاً: عَشِيرَةُ اللِّبْنِيِّينَ، وَعَشِيرَةُ الْحَبْرُونِيِّينَ، وَعَشِيرَةُ الْمَحْلِيِّينَ، وَعَشِيرَةُ الْمُوشِيِّينَ، وَعَشِيرَةُ الْقُورَحِيِّينَ. وَكَانَ عَمْرَامُ مُنْحَدِراً مِنْ نَسْلِ قَهَاتَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","وَاسْمُ امْرَأَةِ عَمْرَامَ يَوْكَابَدُ بِنْتُ لاوِي، الَّتِي وُلِدَتْ فِي مِصْرَ وَأَنْجَبَتْ لِعَمْرَامَ هَرُونَ وَمُوسَى وَمَرْيَمَ أُخْتَهُمَا. ");
INSERT INTO arbnav_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","وَأَنْجَبَ هَرُونُ نَادَابَ وَأَبِيهُو وَأَلِعَازَارَ وَإِيثَامَارَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","أَمَّا نَادَابُ وَأَبِيهُو فَقَدْ مَاتَا عِنْدَمَا قَرَّبَا نَاراً غَيْرَ مُقَدَّسَةٍ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","وَكَانَ الْمُحْصَوْنَ مِنْ ذُكُورِ اللّاوِيِّينَ ثَلاثَةً وَعِشْرِينَ أَلْفاً، مِنِ ابْنِ شَهْرٍ فَمَا فَوْقُ. هَؤُلاءِ لَمْ يُحْصَوْا مَعَ بَقِيَّةِ الإِسْرَائِيلِيِّينَ، لأَنَّهُمْ لَمْ يَرِثُوا نَصِيباً بَيْنَ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","هَؤُلاءِ هُمُ الَّذِينَ أَحْصَاهُمْ مُوسَى وَأَلِعَازَارُ الْكَاهِنُ، حِينَ قَامَا بِإِحْصَاءِ بَنِي إِسْرَائِيلَ فِي سُهُولِ مُوآبَ بِالْقُرْبِ مِنْ نَهْرِ الأُرْدُنِّ مُقَابِلَ أَرِيحَا. ");
INSERT INTO arbnav_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","وَلَمْ يَكُنْ بَيْنَ هَؤُلاءِ الْمُحْصَيْنَ إِنْسَانٌ مِمَّنْ عَدَّهُمْ مُوسَى وَهَرُونُ سَابِقاً فِي صَحْرَاءِ سِينَاءَ، ");
INSERT INTO arbnav_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","لأَنَّ الرَّبَّ كَانَ قَدْ قَالَ لَهُمْ، إِنَّهُمْ جَمِيعاً سَيَمُوتُونَ فِي الصَّحْرَاءِ، فَلَمْ يَبْقَ مِنْهُمْ إِنْسَانٌ سِوَى كَالَبَ بْنِ يَفُنَّةَ وَيَشُوعَ بْنِ نُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","وَأَقْبَلَتْ بَنَاتُ صَلُفْحَادَ بْنِ حَافَرَ بْنِ جِلْعَادَ بْنِ مَاكِيرَ بْنِ مَنَسَّى، الْمُنْتَمِيَاتُ إِلَى عَشَائِرِ مَنَسَّى بْنِ يُوسُفَ، وَهُنَّ: مَحْلَةُ وَنُوعَةُ وَحُجْلَةُ وَمِلْكَةُ وَتِرْصَةُ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","وَوَقَفْنَ أَمَامَ مُوسَى وَأَلِعَازَارَ الْكَاهِنِ، وَأَمَامَ الْقَادَةِ وَالشَّعْبِ، عِنْدَ مَدْخَلِ خَيْمَةِ الاجْتِمَاعِ وَقُلْنَ: ");
INSERT INTO arbnav_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«لَقَدْ مَاتَ أَبُونَا فِي الصَّحْرَاءِ، وَلَمْ يَكُنْ مِنَ الْقَوْمِ الَّذِينَ اجْتَمَعُوا مَعَ قُورَحَ وَتَمَرَّدُوا ضِدَّ الرَّبِّ، بَلْ بِخَطِيئَتِهِ مَاتَ مِنْ غَيْرِ أَنْ يُعْقِبَ بَنِينَ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","فَلِمَاذَا يَسْقُطُ اسْمُ أَبِينَا مِنْ بَيْنِ عَشِيرَتِهِ لأَنَّهُ لَمْ يُخْلِفِ ابْناً؟ أَعْطِنَا مُلْكاً بَيْنَ أَعْمَامِنَا». ");
INSERT INTO arbnav_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","فَرَفَعَ مُوسَى قَضِيَّتَهُنَّ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","فَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«إِنَّ بَنَاتِ صَلُفْحَادَ قَدْ نَطَقْنَ بِحَقٍّ، فَأَعْطِهِنَّ نَصِيباً مُلْكاً لَهُنَّ بَيْنَ أَعْمَامِهِنَّ. انْقُلْ إِلَيْهِنَّ نَصِيبَ أَبِيهِنَّ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","وَأَوْصِ بَنِي إِسْرَائِيلَ أَنَّ أَيَّ رَجُلٍ يَمُوتُ مِنْ غَيْرِ أَنْ يُخْلِفَ ابْناً، تَنْقُلُونَ مُلْكَهُ إِلَى ابْنَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","وَإِنْ لَمْ تَكُنْ لَهُ ابْنَةٌ تُعْطُوا مُلْكَهُ لإِخْوَتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","وَإِنْ لَمْ يَكُنْ لَهُ إِخْوَةٌ، فَأَعْطُوا مُلْكَهُ لأَعْمَامِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","وَإِنْ لَمْ يَكُنْ لَهُ أَعْمَامٌ، فَأَعْطُوا مُلْكَهُ لأَقْرَبِ أَقْرِبَائِهِ مِنْ عَشِيرَتِهِ، فَيَرِثَهُ. وَلْتَكُنْ هَذِهِ فَرِيضَةَ قَضَاءٍ لِبَنِي إِسْرَائِيلَ كَمَا أَمَرَ الرَّبُّ مُوسَى». ");
INSERT INTO arbnav_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","وَقَالَ الرَّبُّ لِمُوسَى: «اصْعَدْ إِلَى جَبَلِ عَبَارِيمَ، وَانْظُرْ مِنْ عَبْرِ النَّهْرِ إِلَى الأَرْضِ الَّتِي أَعْطَيْتُهَا لِبَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","وَمَتَى شَاهَدْتَهَا تَمُوتُ وَتَنْضَمُّ إِلَى قَوْمِكَ أَيْضاً، نَظِيرَ أَخِيكَ هَرُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","لأَنَّكُمَا فِي صَحْرَاءِ صِينَ عَصَيْتُمَا قَوْلِي، حِينَ تَمَرَّدَ الشَّعْبُ، وَلَمْ تُقَدِّسَانِي أَمَامَ أَعْيُنِهِمْ، إِذْ لَمْ تَأْمُرَا الْمَاءَ بِالتَّفَجُّرِ مِنَ الصَّخْرَةِ». ذَلِكَ مَاءُ مَرِيبَةَ عِنْدَ قَادَشَ فِي صَحْرَاءِ صِينَ ");
INSERT INTO arbnav_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","فَقَالَ مُوسَى لِلرَّبِّ: ");
INSERT INTO arbnav_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«لِيُقِمِ الرَّبُّ، إِلَهُ أَرْوَاحِ جَمِيعِ النَّاسِ، قَائِداً لِلشَّعْبِ، ");
INSERT INTO arbnav_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","يَخْرُجُ وَيَدْخُلُ أَمَامَهُمْ، يَقُودُهُمْ وَيُرْجِعُهُمْ لِئَلّا تُصْبِحَ جَمَاعَةُ الرَّبِّ كَغَنَمٍ لَا رَاعِيَ لَهَا». ");
INSERT INTO arbnav_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","فَقَالَ الرَّبُّ لِمُوسَى: «خُذْ يَشُوعَ بْنَ نُونَ، رَجُلاً فِيهِ رُوحُ الرَّبِّ، وَضَعْ يَدَكَ عَلَيْهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ثُمَّ أَوْقِفْهُ أَمَامَ أَلِعَازَارَ وَأَمَامَ الْجَمَاعَةِ كُلِّهَا، وَأَوْصِهِ بِحَضْرَتِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","وَسَلِّمْهُ بَعْضَ سُلْطَتِكَ، لِكَيْ يُطِيعَهُ كُلُّ جَمَاعَةِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","لِيَمْثُلَ أَمَامَ أَلِعَازَارَ الْكَاهِنِ الَّذِي يَتَلَقَّى الْقَرَارَاتِ بِشَأْنِهِ بِوَاسِطَةِ الأُورِيمِ أَمَامَ الرَّبِّ. فَلا يَخْرُجُونَ وَلا يَدْخُلُونَ إِلّا بِأَمْرِهِ، هُوَ وَجَمِيعُ الشَّعْبِ مَعَهُ». ");
INSERT INTO arbnav_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","فَأَخَذَ مُوسَى يَشُوعَ وَأَوْقَفَهُ أَمَامَ أَلِعَازَارَ الْكَاهِنِ وَسَائِرِ الْجَمَاعَةِ، ");
INSERT INTO arbnav_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","وَوَضَعَ يَدَيْهِ عَلَيْهِ وَأَوْصَاهُ كَمَا أَمَرَهُ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: عَلَيْكُمْ أَنْ تُقَرِّبُوا لِي طَعَامَ وَقَائِدِي فِي مَوَاعِيدِهِ كَرَائِحَةِ رِضًى لِي، ");
INSERT INTO arbnav_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","وَقُلْ لَهُمْ: هَذَا هُوَ الْوَقُودُ الَّذِي تُقَدِّمُونَهُ لِلرَّبِّ: حَمَلانِ حَوْلِيَّانِ صَحِيحَانِ يَوْمِيًّا، لِيَكُونَا مُحْرَقَةً دَائِمَةً. ");
INSERT INTO arbnav_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","قَدِّمُوا أَحَدَ الْحَمَلَيْنِ صَبَاحاً، وَالْحَمَلَ الآخَرَ مَا بَيْنَ غُرُوبِ الشَّمْسِ والظَّلامِ، ");
INSERT INTO arbnav_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","مَعَ تَقْدِمَةٍ مِنْ عُشْرِ الإِيفَةِ (نَحْوَ لِتْرَيْنِ وَنِصْفِ اللِّتْرِ) مِنْ دَقِيقٍ مَعْجُونٍ بِرُبْعِ الْهِينِ (نَحْوَ لِتْرٍ) مِنْ زَيْتِ زَيْتُونٍ مَرْضُوضٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","هَذِهِ هِيَ التَّقْدِمَةُ الْمُعْتَادَةُ الَّتِي نُصَّ عَلَيْهَا فِي جَبَلِ سِينَاءَ لِتَكُونَ رَائِحَةَ رِضًى وَمُحْرَقَةً دَائِمَةً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","وَيُسْكَبُ مَعَ الْحَمَلِ الْوَاحِدِ رُبْعُ الْهِينِ (نَحْوَ لِتْرٍ) مِنَ الْخَمْرِ لِلرَّبِّ فِي الْقُدْسِ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","أَمَّا الْحَمَلُ الثَّانِي فَتُقَدِّمُونَهُ بَيْنَ الْعَشَاءَيْنِ كَتَقْدِمَةِ الصَّبَاحِ، مَعَ سَكِيبِهِ، فَيَكُونُ مُحْرَقَةً رَائِحَةَ رِضًى لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","وَفِي يَوْمِ السَّبْتِ تُقَرِّبُونَ حَمَلَيْنِ حَوْلِيَّيْنِ صَحِيحَيْنِ، مَعَ تَقْدِمَةٍ مِنْ عُشْرَيِ الإيفَةِ (نَحْوَ خَمْسَةِ لِتْرَاتٍ) مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، وَأَيْضاً سَكِيبِ خَمْرٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","فَتَكُونُ هَذِهِ مُحْرَقَةً فِي كُلِّ سَبْتٍ، عَلاوَةً عَلَى الْمُحْرَقَةِ الدَّائِمَةِ وَسَكِيبِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","وَتُقَرِّبُونَ أَيْضاً فِي الْيَوْمِ الأَوَّلِ مِنْ كُلِّ شَهْرٍ مُحْرَقَةً لِلرَّبِّ مِنْ ثَوْرَيْنِ وَكَبْشٍ وَاحِدٍ، وَسَبْعَةِ حُمْلانٍ حَوْلِيَّةٍ صَحِيحَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","وَتَقْدِمَةً مِنْ ثَلاثَةِ أَعْشَارِ الإيفَةِ (نَحْوَ سَبْعَةِ لِتْرَاتٍ وَنِصْفِ اللِّتْرِ) مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ، لِكُلِّ ثَوْرٍ، وَتَقْدِمَةً مِنْ عُشْرَيِ الإيفَةِ (نَحْوَ خَمْسَةِ لِتْرَاتٍ) مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ لِلْكَبْشِ الْوَاحِدِ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","وَتَقْدِمَةً مِنْ عُشْرِ الإيفَةِ (نَحْوَ لِتْرَيْنِ وَنِصْفِ اللِّتْرِ) مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ لِكُلِّ حَمَلٍ، فَتَكُونُ مُحْرَقَةً رَائِحَةَ رِضًى وَقُرْبَاناً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","وَتَكُونُ سَكَائِبُ خَمْرِهَا نِصْفَ الْهِينِ (نَحْوَ لِتْرَينِ) لِلثَّوْرِ، وَثُلْثَ الْهِينِ (نَحْوَ لِتْرٍ وَثُلْثِ اللِّتْرِ) لِلْكَبْشِ، وَرُبْعَ الْهِينِ (نَحْوَ لِتْرٍ) لِلْحَمَلِ. هَذِهِ مُحْرَقَةٌ تُقَرَّبُ كُلَّ شَهْرٍ مِنْ أَشْهُرِ السَّنَةِ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","كَذَلِكَ تُقَدِّمُونَ تَيْساً وَاحِداً مِنَ الْمَعْزِ ذَبِيحَةَ خَطِيئَةٍ لِلرَّبِّ عَلاوَةً عَلَى الْمُحْرَقَةِ الدَّائِمَةِ الْمُقَرَّبَةِ مَعَ سَكِيبِهَا مِنَ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","وَيَكُونُ الْيَوْمُ الرَّابِعَ عَشَرَ مِنَ الشَّهْرِ الأَوَّلِ الْعِبْرِيِّ فِصْحاً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","وَفِي الْيَوْمِ الْخَامِسَ عَشَرَ مِنْهُ تَحْتَفِلُونَ وَتَأْكُلُونَ فَطِيراً سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","وَتُقِيمُونَ فِي الْيَوْمِ الأَوَّلِ مَحْفَلاً مُقَدَّساً، تَمْتَنِعُونَ فِيهِ عَنْ أَيِّ عَمَلٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","وَتُصْعِدُونَ ذَبَائِحَ مُحْرَقَاتٍ لِلرَّبِّ ثَوْرَيْنِ وَكَبْشاً وَاحِداً وَسَبْعَةَ حُمْلانٍ حَوْلِيَّةٍ صَحِيحَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","وَتَكُونُ تَقْدِمَتُهَا ثَلاثَةَ أَعْشَارِ الإيفَةِ (نَحْوَ سَبْعَةِ لِتْرَاتٍ وَنِصْفِ اللِّتْرِ) مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ لِكُلِّ ثَوْرٍ، وَعُشْرَيِ الإيفَةِ (نَحْوَ خَمْسَةِ لِتْرَاتٍ) لِلْكَبْشِ الْوَاحِدِ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","وَعُشْرَ الإيفَةِ (نَحْوَ لِتْرَيْنِ وَنِصْفٍ) لِكُلِّ حَمَلٍ مِنَ السَّبْعَةِ الْحُمْلانِ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","وَتُقَرِّبُونَ أَيْضاً تَيْساً وَاحِداً ذَبِيحَةَ خَطِيئَةٍ لِلتَّكْفِيرِ عَنْكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","فَتَكُونُ هَذِهِ التَّقْدِمَةُ عَلاوَةً عَلَى مُحْرَقَةِ الصَّبَاحِ الدَّائِمَةِ الَّتِي تُصْعِدُونَهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","هَكَذَا تَصْنَعُونَ كُلَّ يَوْمٍ طَوَالَ السَّبْعَةِ الأَيَّامِ، فَتُقَدِّمُونَ طَعَامَ وَقُودِ رَائِحَةِ رِضًى لِلرَّبِّ، فَضْلاً عَنِ الْمُحْرَقَةِ الدَّائِمَةِ الَّتِي تُقَرَّبُ مَعَ سَكِيبِ خَمْرِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ثُمَّ تُقِيمُونَ مَحْفَلاً مُقَدَّساً فِي الْيَوْمِ السَّابِعِ، تَمْتَنِعُونَ فِيهِ عَنْ أَيِّ عَمَلٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","وَفِي يَوْمِ أَوَّلِ الأَثْمَارِ حِينَ تُقَرِّبُونَ تَقْدِمَةً جَدِيدَةً لِلرَّبِّ فِي أَثْنَاءِ عِيدِ الأَسَابِيعِ، أَقِيمُوا مَحْفَلاً مُقَدَّساً، تَمْتَنِعُونَ فِيهِ عَنْ أَيِّ عَمَلٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","وَتُقَرِّبُونَ مُحْرَقَةً كَرَائِحَةِ رِضًى لِلرَّبِّ، مِنْ ثَوْرَيْنِ وَكَبْشٍ وَاحِدٍ وَسَبْعَةِ حُمْلانٍ حَوْلِيَّةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","أَمَّا تَقْدِمَتُها فَتَكُونُ ثَلاثَةَ أَعْشَارِ الإيفَةِ (نَحْوَ سَبْعَةِ لِتْرَاتٍ وَنِصْفِ اللِّتْرِ) مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ لِكُلِّ ثَوْرٍ، وَعُشْرَيِ الإيفَةِ (نَحْوَ خَمْسَةِ لِتْرَاتٍ) لِلْكَبْشِ الْوَاحِدِ ");
INSERT INTO arbnav_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","وَعُشْرَ الإيفَةِ (نَحْوَ لِتْرَيْنِ وَنِصْفِ اللِّتْرِ) لِكُلِّ حَمَلٍ مِنَ الْحُمْلانِ السَّبْعَةِ. ");
INSERT INTO arbnav_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","وَأَيْضاً تُقَدِّمُونَ تَيْساً وَاحِداً مِنَ الْمَعْزِ لِلتَّكْفِيرِ عَنْكُمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","وَهَكَذَا عَلاوَةً عَلَى الْمُحْرَقَةِ الدَّائِمَةِ وَتَقْدِمَتِهَا، أَصْعِدُوا هَذِهِ مَعَ سَكَائِبِهَا مِنَ الْخَمْرِ، عَلَى أَنْ تَكُونَ الذَّبَائِحُ خَالِيَةً مِنْ كُلِّ عَيْبٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","وَفِي الْيَوْمِ الأَوَّلِ مِنَ الشَّهْرِ السَّابِعِ الْعِبْرِيِّ تُقِيمُونَ لَكُمْ مَحْفَلاً مُقَدَّساً لِلرَّبِّ، تَمْتَنِعُونَ فِيهِ عَنْ أَيِّ عَمَلٍ، إذْ يَكُونُ لَكُمْ يَوْمَ نَفْخٍ بِالأَبْوَاقِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","وَتُصْعِدُونَ فِيهِ مُحْرَقَةً لِرَائِحَةِ رِضًى لِلرَّبِّ ثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَسَبْعَةَ حُمْلانٍ حَوْلِيَّةٍ سَلِيمَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","وَتَكُونُ تَقْدِمَتُهَا ثَلاثَةَ أَعْشَارِ الإيفَةِ (نَحْوَ سَبْعَةِ لِتْرَاتٍ وَنِصْفِ اللِّتْرِ) مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ لِلثَّوْرِ، وَعُشْرَيِ الإيفَةِ (نَحْوَ خَمْسَةِ لِتْرَاتٍ) لِلْكَبْشِ، ");
INSERT INTO arbnav_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","وَعُشْرَ الإيفَةِ (نَحْوَ لِتْرَيْنِ وَنِصْفِ اللِّتْرِ) لِكُلِّ حَمَلٍ مِنَ السَّبْعَةِ الْحُمْلانِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","كَمَا تُقَدِّمُونَ تَيْساً وَاحِداً مِنَ الْمَعْزِ ذَبِيحَةَ خَطِيئَةٍ لِلتَّكْفِيرِ عَنْكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","فَتَكُونُ هَذِهِ عَلاوَةً عَلَى الْمُحْرَقَةِ الشَّهْرِيَّةِ وَتَقْدِمَتِهَا مِنَ الدَّقِيقِ وَالْمُحْرَقَةِ الْيَوْمِيَّةِ الدَّائِمَةِ وَتَقْدِمَتِهَا مِنَ الدَّقِيقِ، مَعَ مَا يُرَافِقُهَا مِنْ سَكَائِبِ الْخَمْرِ، هِيَ مُحْرَقَةٌ رَائِحَةُ رِضًى لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","وَفِي الْيَوْمِ الْعَاشِرِ مِنَ الشَّهْرِ السَّابِعِ تُقِيمُونَ لَكُمْ مَحْفَلاً مُقَدَّساً، تَصُومُونَ فِيهِ وَتَمْتَنِعُونَ عَنْ أَيِّ عَمَلٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","وَتُقَرِّبُونَ مُحْرَقَةً لِلرَّبِّ رَائِحَةَ رِضًى ثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَسَبْعَةَ حُمْلانٍ حَوْلِيَّةٍ سَلِيمَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","تَكُونُ تَقْدِمَتُهَا ثَلاثَةَ أَعْشَارِ الإيفَةِ (نَحْوَ سَبْعَةِ لِتْرَاتٍ وَنِصْفِ اللِّتْرِ) مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ لِلثَّوْرِ، وَعُشْرَيِ الإيفَةِ (نَحْوَ خَمْسَةِ لِتْرَاتٍ) لِلْكَبْشِ الْوَاحِدِ، ");
INSERT INTO arbnav_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","وَعُشْرَ الإيفَةِ (نَحْوَ لِتْرَيْنِ وَنِصْفِ اللِّتْرِ) لِكُلِّ حَمَلٍ مِنَ السَّبْعَةِ الْحُمْلانِ ");
INSERT INTO arbnav_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","كَمَا تُقَدِّمُونَ تَيْساً وَاحِداً مِنَ الْمَعْزِ ذَبِيحَةَ خَطِيئَةٍ لِلتَّكْفِيرِ عَنْكُمْ. فَتَكُونُ هَذِهِ عَلاوَةً عَلَى ذَبِيحَةِ الْخَطِيئَةِ السَّنَوِيَّةِ الْمُقَدَّمَةِ فِي يَوْمِ الْكَفَّارَةِ، وَالْمُحْرَقَةِ الْيَوْمِيَّةِ الدَّائِمَةِ مَعَ مَا يُرَافِقُهَا مِنْ سَكَائِبِ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","وَفِي الْيَوْمِ الْخَامِسَ عَشَرَ مِنَ الشَّهْرِ نَفْسِهِ تُقِيمُونَ لَكُمْ مَحْفَلاً مُقَدَّساً، تَمْتَنِعُونَ فِيهِ عَنْ أَيِّ عَمَلٍ، وَتَحْتَفِلُونَ فِيهِ لِلرَّبِّ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","وَتُقَرِّبُونَ فِي الْيَوْمِ الأَوَّلِ مُحْرَقَةً رَائِحَةَ رِضًى لِلرَّبِّ، ثَلاثَةَ عَشَرَ ثَوْراً وَكَبْشَيْنِ وَأَرْبَعَةَ عَشَرَ حَمَلاً حَوْلِيًّا سَلِيماً. ");
INSERT INTO arbnav_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","وَتَكُونُ تَقْدِمَتُهَا ثَلاثَةَ أَعْشَارِ الإيفَةِ (نَحْوَ سَبْعَةِ لِتْرَاتٍ وَنِصْفِ اللِّتْرِ) مِنْ دَقِيقٍ مَعْجُونٍ بِزَيْتٍ لِكُلِّ ثَوْرٍ مِنَ الثِّيرَانِ الثَّلاثَةَ عَشَرَ، وَعُشْرَيِ الإيفَةِ (نَحْوَ خَمْسَةِ لِتْرَاتٍ) لِكُلِّ كَبْشٍ مِنَ الْكَبْشَيْنِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","وَعُشْرَ الإيفَةِ (نَحْوَ لِتْرَيْنِ وَنِصْفِ اللِّتْرِ) لِكُلِّ حَمَلٍ مِنَ الأَرْبَعَةَ عَشَرَ حَمَلاً. ");
INSERT INTO arbnav_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","كَمَا تُقَدِّمُونَ تَيْساً مِنَ الْمَعْزِ ذَبِيحَةَ خَطِيئَةٍ، عَلاوَةً عَلَى الْمُحْرَقَةِ الْيَوْمِيَّةِ الدَّائِمَةِ وَتَقْدِمَتِهَا وَسَكِيبِهَا مِنَ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","وَتُقَرِّبُونَ فِي الْيَوْمِ الثَّانِي اثْنَيْ عَشَرَ ثَوْراً وَكَبْشَيْنِ وَأَرْبَعَةَ عَشَرَ حَمَلاً حَوْلِيًّا سَلِيماً. ");
INSERT INTO arbnav_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","وَتَكُونُ تَقْدِمَتُهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ لِكُلٍّ مِنَ الثِّيرَانِ وَالْكَبْشَيْنِ وَالْحُمْلانِ، هِيَ التَّقْدِمَةُ الْمُعْتَادَةُ بِمَا يَتَّفِقُ مَعَ عَدَدِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","كَمَا تُقَدِّمُونَ تَيْساً وَاحِداً مِنَ الْمَعْزِ ذَبِيحَةَ خَطِيئَةٍ، عَلاوَةً عَلَى الْمُحْرَقَةِ الْيَوْمِيَّةِ الدَّائِمَةِ، وَتَقْدِمَتِهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","وَتُقَرِّبوُنَ فِي الْيَوْمِ الثَّالِثِ أَحَدَ عَشَرَ ثَوْراً وَكَبْشَيْنِ وَأَرْبَعَةَ عَشَرَ حَمَلاً حَوْلِيًّا سَلِيماً. ");
INSERT INTO arbnav_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","وَتَكُونُ تَقْدِمَتُهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ لِكُلٍّ مِنَ الثِّيرَانِ وَالْكَبْشَيْنِ وَالْحُمْلانِ هِيَ التَّقْدِمَةُ الْمُعْتَادَةُ بِمَا يَتَّفِقُ مَعَ عَدَدِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","كَمَا تُقَدِّمُونَ تَيْساً وَاحِداً مِنَ الْمَعْزِ ذَبِيحَةَ خَطِيئَةٍ، عَلاوَةً عَلَى الْمُحْرَقَةِ الْيَوْمِيَّةِ الدَّائِمَةِ وَتَقْدِمَتِهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","وَتُقَرِّبُونَ فِي الْيَوْمِ الرَّابِعَ عَشَرَةَ ثِيرَانٍ وَكَبْشَيْنِ وَأَرْبَعَةَ عَشَرَ حَمَلاً حَوْلِيًّا سَلِيماً. ");
INSERT INTO arbnav_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","وَتَكُونُ تَقْدِمَتُهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ لِكُلٍّ مِنَ الثِّيرَانِ وَالْكَبْشَيْنِ وَالْحُمْلانِ هِيَ التَّقْدِمَةُ الْمُعْتَادَةُ بِمَا يَتَّفِقُ مَعَ عَدَدِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","كَمَا تُقَدِّمُونَ تَيْساً وَاحِداً مِنَ الْمَعْزِ ذَبِيحَةَ خَطِيئَةٍ، عَلاوَةً عَلَى الْمُحْرَقَةِ الْيَوْمِيَّةِ الدَّائِمَةِ وَتَقْدِمَتِهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","وَتُقَرِّبُونَ فِي الْيَوْمِ الْخَامِسِ تِسْعَةَ ثِيرَانٍ وَكَبْشَيْنِ وَأَرْبَعَةَ عَشَرَ حَمَلاً حَوْلِيًّا صَحِيحاً، ");
INSERT INTO arbnav_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","وَتَكُونُ تَقْدِمَتُهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ لِكُلٍّ مِنَ الثِّيرَانِ وَالْكَبْشَيْنِ وَالْحُمْلانِ هِيَ التَّقْدِمَةُ الْمُعْتَادَةُ بِمَا يَتَّفِقُ مَعَ عَدَدِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","كَمَا تُقَدِّمُونَ تَيْساً وَاحِداً مِنَ الْمَعْزِ ذَبِيحَةَ خَطِيئَةٍ، عَلاوَةً عَلَى الْمُحْرَقَةِ الْيَوْمِيَّةِ الدَّائِمَةِ وَتَقْدِمَتِهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","وَتُقَرِّبُونَ فِي الْيَوْمِ السَّادِسِ ثَمَانِيَةَ ثِيرَانٍ وَكَبْشَيْنِ وَأَرْبَعَةَ عَشَرَ حَمَلاً حَوْلِيًّا سَلِيماً. ");
INSERT INTO arbnav_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","وَتَكُونُ تَقْدِمَتُهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ لِكُلٍّ مِنَ الثِّيرَانِ وَالْكَبْشَيْنِ وَالْحُمْلانِ هِيَ التَّقْدِمَةُ الْمُعْتَادَةُ بِمَا يَتَّفِقُ مَعَ عَدَدِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","كَمَا تُقَدِّمُونَ تَيْساً وَاحِداً مِنَ الْمَعْزِ ذَبِيحَةَ خَطِيئَةٍ، عَلاوَةً عَلَى الْمُحْرَقَةِ الْيَوْمِيَّةِ الدَّائِمَةِ وَتَقْدِمَتِهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","وَتُقَرِّبُونَ فِي الْيَوْمِ السَّابِعِ سَبْعَةَ ثِيرَانٍ وَكَبْشَيْنِ وَأَرْبَعَةَ عَشَرَ حَمَلاً حَوْلِيًّا سَلِيماً. ");
INSERT INTO arbnav_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","وَتَكُونُ تَقْدِمَتُهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ لِكُلٍّ مِنَ الثِّيرَانِ وَالْكَبْشَيْنِ وَالْحُمْلانِ هِيَ التَّقْدِمَةُ الْمُعْتَادَةُ بِمَا يَتَّفِقُ مَعَ عَدَدِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","كَمَا تُقَدِّمُونَ تَيْساً وَاحِداً مِنَ الْمَعْزِ ذَبِيحَةَ خَطِيئَةٍ، عَلاوَةً عَلَى الْمُحْرَقَةِ الْيَوْمِيَّةِ الدَّائِمَةِ وَتَقْدِمَتِهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","وَفِي الْيَوْمِ الثَّامِنِ تَجْتَمِعُونَ لِلْعِبَادَةِ وَفِيهِ تَمْتَنِعُونَ عَنْ أَيِّ عَمَلٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","وَتُقَرِّبُونِ مُحْرَقَةً لِتَكُونَ رَائِحَةَ رِضًى لِلرَّبِّ ثَوْراً وَاحِداً وَكَبْشاً وَاحِداً وَسَبْعَةَ حُمْلانٍ حَوْلِيَّةٍ سَلِيمَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","وَتَكُونُ تَقْدِمَتُهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ لِكُلٍّ مِنَ الثَّوْرِ وَالْكَبْشِ وَالْحُمْلانِ هِيَ التَّقْدِمَةُ الْمُعْتَادَةُ بِمَا يَتَّفِقُ مَعَ عَدَدِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","كَمَا تُقَدِّمُونَ تَيْساً وَاحِداً مِنَ الْمَعْزِ ذَبِيحَةَ خَطِيئَةٍ عَلاوَةً عَلَى الْمُحْرَقَةِ الْيَوْمِيَّةِ الدَّائِمَةِ وَتَقْدِمَتِهَا مِنَ الدَّقِيقِ وَسَكَائِبِ الْخَمْرِ. ");
INSERT INTO arbnav_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","فَهَذِهِ هِيَ الذَّبَائِحُ الَّتِي تُقَرِّبُونَهَا لِلرَّبِّ فِي مَوَاسِمِ أَعْيَادِكُمْ، عَلاوَةً عَلَى نُذُورِكُمْ وَقَرَابِينِ مُحْرَقَاتِكُمُ الطَّوْعِيَّةِ وَتَقْدِمَاتِكُمْ مِنَ الدَّقِيقِ وَسَكَائِبِ خَمْرِكُمْ وَذَبَائِحِ سَلامَتِكُمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","فَأَبْلَغَ مُوسَى بَنِي إِسْرَائِيلَ جَمِيعَ مَا أَمَرَهُ بِهِ الرَّبُّ. ");
INSERT INTO arbnav_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","وَقَالَ مُوسَى لِقَادَةِ أَسْبَاطِ بَنِي إِسْرَائِيلَ: «إِلَيْكُمْ مَا أَمَرَ بِهِ الرَّبُّ: ");
INSERT INTO arbnav_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","إِذَا نَذَرَ رَجُلٌ نَذْراً لِلرَّبِّ، أَوْ أَقْسَمَ أَنْ يَلْتَزِمَ بِأَمْرٍ مَا، فَعَلَيْهِ أَنْ يَفِيَ بِكَلامِهِ وَيُنَفِّذَ كُلَّ مَا تَعَهَّدَ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","وَلَكِنْ إِذَا نَذَرَتْ صَبِيَّةٌ نَذْراً لِلرَّبِّ وَأَلْزَمَتْ نَفْسَهَا بِأَمْرٍ، وَهِيَ مَا بَرِحَتْ فِي بَيْتِ أَبِيهَا، ");
INSERT INTO arbnav_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","وَسَمِعَ أَبُوهَا مَا نَذَرَتْهُ أَوْ تَعَهَّدَتْ بِهِ، وَسَكَتَ، فَإِنَّهَا تَكُونُ مُلْزَمَةً بِكُلِّ نُذُورِهَا وَتَعَهُّدَاتِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","وَلَكِنْ إِنْ مَنَعَهَا أَبُوهَا عِنْدَ سَمَاعِهِ مَا نَذَرَتْ أَوْ تَعَهَّدَتْ بِهِ، فَإِنَّهَا لَا تَكُونُ مُلْزَمَةً بِالإِيفَاءِ، وَالرَّبُّ يَصْفَحُ عَنْهَا لأَنَّ أَبَاهَا قَدْ مَنَعَهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","وَإذَا تَزَوَّجَتْ بَعْدَ أَنْ نَذَرَتْ أَوْ تَعَهَّدَتْ بِمَا أَلْزَمَتْ بِهِ نَفْسَهَا، ");
INSERT INTO arbnav_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ثُمَّ عَرَفَ زَوْجُهَا بِنُذُورِهَا فَسَكَتَ عَنْهَا، تُصْبِحُ مُلْزَمَةً بِها. ");
INSERT INTO arbnav_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","وَإِنْ مَنَعَهَا زَوْجُهَا عِنْدَ مَعْرِفَتِهِ بِنُذُورِهَا، فَإِنَّ مَا تَعَهَّدَتْ بِهِ وَأَلْزَمَتْ نَفْسَهَا بِهِ يُصْبِحُ لاغِياً، وَالرَّبُّ يَصْفَحُ عَنْهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","وَأَمَّا نَذْرُ الأَرْمَلَةِ وَالْمُطَلَّقَةِ فَكُلُّ مَا تَعَهَّدَتْ بِهِ يَثْبُتُ عَلَيْهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","إِنْ نَذَرَتِ امْرَأَةٌ مُتَزَوِّجَةٌ أَوْ أَقْسَمَتْ أَنْ تَلْتَزِمَ بِأَمْرٍ، وَهِيَ مَا بَرِحَتْ فِي بَيْتِ زَوْجِهَا، ");
INSERT INTO arbnav_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","وَسَمِعَ زَوْجُهَا وَلَمْ يَعْتَرِضْ، تُصْبِحُ مُلْزَمَةً بِكُلِّ نُذُورِهَا وَبِكُلِّ مَا تَعَهَّدَتْ بِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","وَلَكِنْ إِنْ أَبْطَلَ زَوْجُهَا نُذُورَهَا عِنْدَ مَعْرِفَتِهِ بِها، فَإِنَّ كُلَّ مَا تَعَهَّدَتْ بِهِ مِنْ نُذُورٍ، أَوْ مَا أَلْزَمَتْ بِهِ نَفْسَهَا، يُصْبِحُ لاغِياً، لأَنَّ زَوْجَهَا قَدْ أَبْطَلَ نُذُورَهَا، وَالرَّبُّ يَصْفَحُ عَنْهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","كُلُّ نَذْرٍ وَكُلُّ تَعَهُّدٍ مُلْزِمٍ بِقَمْعِ النَّفْسِ، فَزَوْجُهَا يُثْبِتُهُ، وَزَوْجُهَا يُبْطِلُهُ. ");
INSERT INTO arbnav_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","وَلَكِنْ إِنْ لَمْ يَعْتَرِضْ زَوْجُهَا خِلالَ يَوْمٍ مِنْ مَعْرِفَتِهِ بِهِ، فَقَدْ أَثْبَتَ عَلَيْهَا كُلَّ نُذُورِهَا وَتَعَهُّدَاتِهَا، لأَنَّهُ لَمْ يَعْتَرِضْ عَلَيْهَا عِنْدَ مَعْرِفَتِهِ بِها. ");
INSERT INTO arbnav_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","وَلَكِنْ إِنْ أَبْطَلَ نُذُورَهَا بَعْدَ ذَلِكَ، فَإِنَّهُ يَحْمِلُ عِقَابَ ذَنْبِهَا». ");
INSERT INTO arbnav_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","هَذِهِ هِيَ الْفَرَائِضُ الَّتِي أَمَرَ بِها الرَّبُّ مُوسَى بِشَأْنِ نُذُورِ الأُنْثَى، الْخَاصَّةُ بِالزَّوْجِ وَزَوْجَتِهِ، وَالأَبِ وَابْنَتِهِ الصَّبِيَّةِ الَّتِي مَا بَرِحَتْ مُقِيمَةً فِي بَيْتِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«انْتَقِمْ مِنَ الْمِدْيَانِيِّينَ لِبَنِي إِسْرَائِيلَ، وَبَعْدَهَا تَمُوتُ وَتَنْضَمُّ إِلَى قَوْمِكَ». ");
INSERT INTO arbnav_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","فَقَالَ مُوسَى لِلشَّعْبِ: «جَهِّزُوا مِنْكُمْ رِجَالاً مُجَنَّدِينَ لِمُحَارَبَةِ الْمِدْيَانِيِّينَ وَالانْتِقَامِ لِلرَّبِّ مِنْهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","أَرْسِلُوا لِلْحَرْبِ أَلْفاً وَاحِداً مِنْ كُلِّ سِبْطٍ مِنْ أَسْبَاطِ إِسْرَائِيلَ». ");
INSERT INTO arbnav_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","فَتَمَّ اخْتِيَارُ أَلْفٍ مِنْ كُلِّ سِبْطٍ، فَكَانُوا اثْنَيْ عَشَرَ أَلْفاً مِنْ بَيْنِ أُلُوفِ إِسْرَائِيلَ مُجَرَّدِينَ لِلْقِتَالِ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","فَأَرْسَلَهُمْ مُوسَى، أَلْفاً مِنْ كُلِّ سِبْطٍ، لِلْحَرْبِ بِقِيَادَةِ فِينْحَاسَ بْنِ أَلِعَازَارَ الْكَاهِنِ، الَّذِي أَخَذَ مَعَهُ أَمْتِعَةَ الْقُدْسِ وَأَبْوَاقَ الْهُتَافِ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","فَحَارَبُوا الْمِدْيَانِيِّينَ كَمَا أَمَرَ الرَّبُّ وَقَتَلُوا كُلَّ ذَكَرٍ؛ ");
INSERT INTO arbnav_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","وَقَتَلُوا مَعَهُمْ مُلُوكَهُمُ الْخَمْسَةَ: أَوِيَ وَرَاقِمَ وَصُورَ وَحُورَ وَرَابِعَ، كَمَا قَتَلُوا بَلْعَامَ بْنَ بَعُورَ بِحَدِّ السَّيْفِ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","وَأَسَرَ بَنُو إِسْرَائِيلَ نِسَاءَ الْمِدْيَانِيِّينَ وَأَطْفَالَهُمْ، وَغَنِمُوا جَمِيعَ بَهَائِمِهِمْ وَمَوَاشِيهِمْ وَسَائِرَ أَمْلاكِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","وَأَحْرَقُوا مُدُنَهُمْ كُلَّهَا بِمَسَاكِنِهَا وَحُصُونِهَا، ");
INSERT INTO arbnav_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","وَاسْتَوْلَوْا عَلَى كُلِّ الْغَنَائِمِ وَالأَسْلابِ مِنَ النَّاسِ وَالْحَيَوَانِ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","وَرَجَعُوا إِلَى مُوسَى وَأَلِعَازَارَ الْكَاهِنِ وَجَمَاعَةِ إِسْرَائِيلَ بِالسَّبْيِ والأَسْلابِ وَالْغَنِيمَةِ إِلَى الْمُخَيَّمِ فِي سُهُولِ مُوآبَ بِالْقُرْبِ مِنْ نَهْرِ الأُرْدُنِّ مُقَابِلَ أَرِيحَا. ");
INSERT INTO arbnav_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","فَخَرَجَ مُوسَى وَأَلِعَازَارُ وَكُلُّ قَادَةِ إِسْرَائِيلَ لاِسْتِقْبَالِهِمْ إِلَى خَارِجِ الْمُخَيَّمِ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","فَأَبْدَى مُوسَى سُخْطَهُ عَلَى قَادَةِ الْجَيْشِ مِنْ رُؤَسَاءِ الأُلُوفِ وَرُؤَسَاءِ الْمِئَاتِ الْقَادِمِينَ مِنَ الْحَرْبِ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","وَقَالَ لَهُمْ: «لِمَاذَا اسْتَحْيَيْتُمُ النِّسَاءَ؟ ");
INSERT INTO arbnav_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","إِنَّهُنَّ بِاتِّبَاعِهِنَّ نَصِيحَةَ بَلْعَامَ أَغْوَيْنَ بَنِي إِسْرَائِيلَ لِعِبَادَةِ فَغُورَ، وَكُنَّ سَبَبَ خِيَانَةٍ لِلرَّبِّ، فَتَفَشَّى الْوَبَأُ فِي جَمَاعَةِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","فَالآنَ اقْتُلُوا كُلَّ ذَكَرٍ مِنَ الأَطْفَالِ، وَاقْتُلُوا أَيْضاً كُلَّ امْرَأَةٍ ضَاجَعَتْ رَجُلاً، ");
INSERT INTO arbnav_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","وَلَكِنِ اسْتَحْيَوْا لَكُمْ كُلَّ عَذْرَاءَ لَمْ تُضَاجِعْ رَجُلاً. ");
INSERT INTO arbnav_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","وَأَمَّا أَنْتُمْ فَامْكُثُوا خَارِجَ الْمُخَيَّمِ سَبْعَةَ أَيَّامٍ، وَعَلَى كُلِّ مَنْ قَتَلَ نَفْساً، وَمَنْ لَمَسَ قَتِيلاً أَنْ يَتَطَهَّرَ فِي الْيَوْمِ الثَّالِثِ، وَفِي الْيَوْمِ السَّابعِ. افْعَلُوا هَذَا أَنْتُمْ وَسَبَايَاكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","وَكَذَلِكَ طَهِّرُوا كُلَّ ثَوْبٍ، وَكُلَّ مَتَاعٍ جِلْدِيٍّ، وَكُلَّ مَا هُوَ مَصْنُوعٌ مِنْ شَعْرِ الْمَعْزِ وَكُلَّ آنِيَةٍ مِنْ خَشَبٍ». ");
INSERT INTO arbnav_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","وَقَالَ أَلِعَازَارُ الْكَاهِنُ لِلْمُحَارِبِينَ: «هَذِهِ هِيَ فَرِيضَةُ الشَّرِيعَةِ الَّتِي أَمَرَ بِها الرَّبُّ مُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","الذَّهَبُ وَالْفِضَّةُ وَالنُّحَاسُ وَالْحَدِيدُ وَالْقَصْدِيرُ وَالرَّصَاصُ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","وَكُلُّ مَا يَتَحَمَّلُ حَرَارَةَ النَّارِ، أَجِيزُوهُ فِيهَا فَيُصْبِحَ طَاهِراً. وَلَكِنْ عَلَيْكُمْ أَيْضاً أَنْ تُطَهِّرُوهُ بِمَاءِ التَّطْهِيرِ، وَمَا لَا يَحْتَمِلُ النَّارَ طَهِّرُوهُ بِمَاءِ التَّطْهِيرِ فَقَطْ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ثُمَّ اغْسِلُوا ثِيَابَكُمْ فِي الْيَوْمِ السَّابعِ فَتَكُونُوا طَاهِرِينَ. وَبَعْدَ ذَلِكَ تَدْخُلُونَ الْمُخَيَّمَ». ");
INSERT INTO arbnav_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","وَقَالَ الرَّبُّ لِمُوسَى: ");
INSERT INTO arbnav_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«أَحْصِ أَنْتَ وَأَلِعَازَارُ الْكَاهِنُ وَرُؤَسَاءُ الْعَشَائِرِ الْغَنَائِمَ وَالسَّبْيَ مِنَ النَّاسِ وَالْحَيَوَانِ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","وَقَسِّمِ الْغَنَائِمَ مُنَاصَفَةً بَيْنَ الْجُنْدِ الْمُشْتَرِكِينَ فِي الْحَرْبِ وَبَيْنَ كُلِّ الْجَمَاعَةِ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","وَخُذْ نَصِيباً لِلرَّبِّ مِنْ غَنَائِمِ أَهْلِ الْحَرْبِ، وَاحِداً مِنْ كُلِّ خَمْسِ مَئَةٍ مِنَ النَّاسِ وَالْبَقَرِ وَالْحَمِيرِ وَالْغَنَمِ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","مِنْ نِصْفِ أَهْلِ الْحَرْبِ تَأْخُذُهَا وَتُعْطِيهَا لأَلِعَازَارَ الْكَاهِنِ تَقْدِمَةً لِلرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","وَتَأْخُذُ مِنْ نِصْفِ بَنِي إِسْرَائِيلَ وَاحِداً مِنْ كُلِّ خَمْسِينَ مِنَ النَّاسِ وَالْبَقَرِ وَالْحَمِيرِ وَالْغَنَمِ وَسَائِرِ الْبَهَائِمِ، وَتُعْطِيهَا لِلّاوِيِّينَ الْقَائِمِينَ عَلَى خِدْمَةِ خَيْمَةِ الاجْتِمَاعِ». ");
INSERT INTO arbnav_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","فَنَفَّذَ مُوسَى وَأَلِعَازَارُ الْكَاهِنُ كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","وَكَانَ النَّهْبُ الْمُتَبَقِّي مِنْ غَنَائِمِ رِجَالِ الْحَرْبِ مِنَ الْغَنَمِ سِتَّ مِئَةٍ وَخَمْسَةً وَسَبْعِينَ أَلْفاً، ");
INSERT INTO arbnav_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","وَمِنَ الْبَقَرِ اثْنَيْنِ وَسَبْعِينَ أَلْفاً، ");
INSERT INTO arbnav_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","وَمِنَ الْحَمِيرِ وَاحِداً وَسِتِّينَ أَلْفاً، ");
INSERT INTO arbnav_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","وَمِنَ الْعَذَارَى اللَّوَاتِي لَمْ يُضَاجِعْنَ ذَكَراً اثْنَيْنِ وَثَلاثِينَ أَلْفاً. ");
INSERT INTO arbnav_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","فَكَانَ النِّصْفُ نَصِيبُ أَهْلِ الْحَرْبِ، مِنَ الْغَنَمِ ثَلاثَ مِئَةٍ وَسَبْعَةً وَثَلاثِينَ أَلْفاً وَخَمْسَ مِئَةٍ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","وَكَانَتْ زَكَاةُ الرَّبِّ مِنْهَا سِتَّ مِئَةٍ وَخَمْسَةً وَسَبْعِينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","وَمِنَ الْبَقَرِ سِتَّةً وَثَلاثِينَ أَلْفاً، وَزَكَاةُ الرَّبِّ مِنْهَا اثْنَيْنِ وَسَبْعِينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","وَمِنَ الْحَمِيرِ ثَلاثِينَ أَلْفاً وَخَمْسَ مِئَةٍ، وَزَكَاةُ الرَّبِّ مِنْهَا وَاحِداً وَسِتِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","وَمِنَ النِّسَاءِ الْعَذَارَى سِتَّةَ عَشَرَ أَلْفاً، وَزَكَاةُ الرَّبِّ مِنْهَا اثْنَيْنِ وَثَلاثِينَ نَفْساً. ");
INSERT INTO arbnav_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","فَأَعْطَى مُوسَى الزَّكَاةَ تَقْدِمَةَ الرَّبِّ لأَلِعَازَارَ الْكَاهِنِ، كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","أَمَّا نِصْفُ غَيْرِ الْمُحَارِبِينَ مِنَ الإِسْرَائِيلِيِّينَ مِنَ الْغَنِيمَةِ الَّذِي قَسَمَهُ مُوسَى مِنْ كَامِلِ غَنَائِمِ أَهْلِ الْحَرْبِ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","فَكَانَ مِنَ الْغَنَمِ ثَلاثَ مِئَةٍ وَسَبْعَةً وَثَلاثِينَ أَلْفاً وَخَمْسَ مِئَةٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","وَمِنَ الْبَقَرِ سِتَّةً وَثَلاثِينَ أَلْفاً، ");
INSERT INTO arbnav_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","وَمِنَ الْحَمِيرِ ثَلاثِينَ أَلْفاً وَخَمْسَ مِئَةٍ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","وَمِنَ الْعَذَارَى سِتَّةَ عَشَرَ أَلْفاً. ");
INSERT INTO arbnav_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","فَأَفْرَزَ مُوسَى مِنْ نَصِيبِ الإِسْرَائِيلِيِّينَ وَاحِداً مِنْ كُلِّ خَمْسِينَ مِنَ النِّسَاءِ وَمِنَ الْبَهَائِمِ وَأَعْطَاهَا لِلّاوِيِّينَ الْقَائِمِينَ عَلَى خِدْمَةِ الْمَسْكَنِ، كَمَا أَمَرَ الرَّبُّ مُوسَى. ");
INSERT INTO arbnav_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ثُمَّ تَقَدَّمَ قَادَةُ الْجُنْدِ مِنْ رُؤَسَاءِ الأُلُوفِ وَرُؤَسَاءِ الْمِئَاتِ إِلَى مُوسَى، ");
INSERT INTO arbnav_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","وَقَالُوا لَهُ: «لَقَدْ أَحْصَى عَبِيدُكَ عَدَدَ جُنُودِهِمِ الْمُحَارِبِينَ، فَلَمْ يُفْقَدْ مِنَّا إِنْسَانٌ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","لِذَلِكَ يُقَدِّمُ كُلُّ وَاحِدٍ مِنَّا قُرْبَانَ الرَّبِّ فِي مَا وَجَدَهُ مِنْ أَمْتِعَةِ ذَهَبٍ: حُجُولٍ وَأَسَاوِرَ وَخَوَاتِمَ وَأَقْرَاطٍ وَقَلائِدَ لِلتَّكْفِيرِ عَنْ أَنْفُسِنَا أَمَامَ الرَّبِّ». ");
INSERT INTO arbnav_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","فَأَخَذَ مُوسَى وَأَلِعَازَارُ الْكَاهِنُ مِنْهُمْ كُلَّ مَا هُوَ مَصْنُوعٌ مِنَ الذَّهَبِ، ");
INSERT INTO arbnav_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","فَكَانَتْ جُمْلَةُ ذَهَبِ التَّقْدِمَةِ الَّتِي قَرَّبُوهَا لِلرَّبِّ سِتَّةَ عَشَرَ أَلَفاً وَسَبْعَ مِئَةٍ وَخَمْسِينَ شَاقِلاً (نَحْوَ مِئَتَيْ كِيلُو جِرَاماً) قَدَّمَهَا رُؤَسَاءُ الأُلُوفِ وَرُؤَسَاءُ الْمِئَاتِ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","أَمَّا الْجُنْدُ فَقَدْ أَخَذَ كُلٌّ مِنْهُمْ مَا اغْتَنَمَهُ لِنَفْسِهِ. ");
INSERT INTO arbnav_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","وَحَمَلَ مُوسَى وَأَلِعَازَارُ الْكَاهِنُ الذَّهَبَ الَّذِي قَدَّمَهُ رُؤَسَاءُ الأُلُوفِ وَرُؤَسَاءُ الْمِئَاتِ وَأَتَيَا بِهِ إِلَى خَيْمَةِ الاجْتِمَاعِ تَذْكَاراً لِبَنِي إِسْرَائِيلَ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","وَكَانَ لِسِبْطَيْ رَأُوبَيْنَ وَجَادٍ مَوَاشٍ كَثِيرَةٌ جِدّاً. فَلَمَّا أَقْبَلُوا عَلَى أَرْضِ يَعَزِيرَ وَأَرْضِ جِلْعَادَ وَجَدُوا أَنَّهَا صَالِحَةٌ لِرَعْيِ الْمَوَاشِي. ");
INSERT INTO arbnav_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","فَقَالُوا لِمُوسَى وَأَلِعَازَارَ الْكَاهِنِ وَرُؤَسَاءِ الشَّعْبِ: ");
INSERT INTO arbnav_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«إِنَّ أَرَاضِي عَطَارُوتَ وَدِيبُونَ وَيَعَزِيرَ وَنِمْرَةَ وَحَشْبُونَ وَأَلِعَالَةَ وَشَبَامَ وَنَبُو وَبَعُونَ ");
INSERT INTO arbnav_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","الأَرَاضِي الَّتِي أَخْضَعَهَا الرَّبُّ لِبَنِي إِسْرَائِيلَ هِيَ مَرَاعٍ صَالِحَةٌ لِرَعْيِ مَوَاشِي عَبِيدِكَ. ");
INSERT INTO arbnav_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","فَإِنْ حَسُنَ لَدَيْكَ، أَعْطِ هَذِهِ الأَرَاضِي لِعَبِيدِكَ مُلْكاً، وَلا تَدَعْنَا نَعْبُرُ نَهْرَ الأُرْدُنِّ». ");
INSERT INTO arbnav_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","فَقَالَ مُوسَى لأَبْنَاءِ سِبْطَيْ جَادٍ وَرَأُوبَيْنَ: «أَيَنْطَلِقُ إِخْوَتُكُمْ لِخَوْضِ الْحَرْبِ وَأَنْتُمْ هُنَا قَاعِدُونَ؟ ");
INSERT INTO arbnav_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","لِمَاذَا تُضْعِفُونَ قُلُوبَ الإِسْرَائِيلِيِّينَ عَنِ الْعُبُورِ إِلَى الأَرْضِ الَّتِي وَهَبَهَا الرَّبُّ لَهُمْ؟ ");
INSERT INTO arbnav_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","إِنَّ هَذَا مَا فَعَلَهُ آبَاؤُكُمْ حِينَ أَرْسَلْتُهُمْ مِنْ قَادَشَ بَرْنِيعَ لِيَتَجَسَّسُوا الأَرْضَ، ");
INSERT INTO arbnav_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","فَبَعْدَ أَنْ بَلَغُوا وَادِي أَشْكُولَ وَتَجَسَّسُوا الأَرْضَ أَضْعَفُوا قُلُوبَ الإِسْرَائِيلِيِّينَ عَنِ الْعُبُورِ إِلَى الأَرْضِ الَّتِي وَهَبَهَا الرَّبُّ لَهُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","فَاحْتَدَمَ فِي ذَلِكَ الْيَوْمِ غَضَبُ الرَّبِّ وَقَالَ: ");
INSERT INTO arbnav_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","لأَنَّهُمْ لَمْ يُطِيعُونِي مِنْ كُلِّ قُلُوبِهِمْ فَإِنَّ الرِّجَالَ مِنِ ابْنِ عِشْرِينَ سَنَةً فَمَا فَوْقُ مِنَ الَّذِينَ خَرَجُوا مِنْ مِصْرَ لَنْ يَرَوْا الأَرْضَ الَّتِي أَقْسَمْتُ أَنْ أَهَبَهَا لِنَسْلِ إِبْرَاهِيمَ وَإِسْحَاقَ وَيَعْقُوبَ، ");
INSERT INTO arbnav_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","مَاعَدَا كَالَبَ بْنَ يَفُنَّةَ الْقِنِزِّيَّ وَيَشُوعَ بْنَ نُونٍ، لأَنَّهُمَا أَطَاعَانِي مِنْ كُلِّ قَلْبَيْهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","وَإِذِ اشْتَدَّ غَضَبُ الرَّبِّ عَلَى بَنِي إِسْرَائِيلَ أَتَاهَهُمْ فِي الصَّحْرَاءِ أَرْبَعِينَ سَنَةً، حَتَّى فَنِيَ كُلُّ الْجِيلِ الَّذِي ارْتَكَبَ الشَّرَّ فِي عَيْنَيِ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","وَهَا أَنْتُمْ نِتَاجُ تَرْبِيَةِ قَوْمٍ خُطَاةٍ، تَرْتَكِبُونَ وِزْرَ آبَائِكُمْ، لِتَزِيدُوا مِنْ شِدَّةِ غَضَبِهِ عَلَى إِسْرَائِيلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","لأَنَّكُمْ إِنْ تَخَلَّيْتُمْ عَنْ طَاعَتِهِ، يَعُودُ وَيَتْرُكُهُمْ فِي الصَّحْرَاءِ وَتَكُونُونَ أَنْتُمْ سَبَبَ هَلاكِهِمْ». ");
INSERT INTO arbnav_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","فَاقْتَرَبُوا مِنْهُ وَقَالُوا: «سَنَبْنِي حَظَائِرَ لِمَوَاشِينَا وَمُدُناً لأَطْفَالِنَا وَنِسَائِنَا، ");
INSERT INTO arbnav_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","أَمَّا نَحْنُ فَنَتَسَلَّحُ وَنَنْطَلِقُ مُسْرِعِينَ أَمَامَ بَنِي إِسْرَائِيلَ حَتَّى يَبْلُغُوا أَمَاكِنَهُمْ بَيْنَمَا يَمْكُثُ نِسَاؤُنَا وَأَطْفَالُنَا فِي مُدُنٍ مُحَصَّنَةٍ تَقِيهِمْ هَجْمَاتِ أَهْلِ الأَرْضِ، ");
INSERT INTO arbnav_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","وَلا نَرْجِعُ إِلَى بُيُوتِنَا حَتَّى يَمْتَلِكَ كُلُّ وَاحِدٍ مِنْ بَنِي إِسْرَائِيلَ نَصِيبَهُ مِنَ الْمِيرَاثِ. ");
INSERT INTO arbnav_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","وَإِنَّنَا لَا نَرِثُ مَعَهُمْ شَيْئاً فِي غَرْبِيِّ نَهْرِ الأُرْدُنِّ، لأَنَّنَا قَدْ حَصَلْنَا عَلَى نَصِيبِنَا فِي الأَرَاضِي الْوَاقِعَةِ فِي شَرْقِيِّهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","فَقَالَ لَهُمْ مُوسَى: «إِنْ وَفَيْتُمْ بِعَهْدِكُمْ فَحَمَلْتُمُ السِّلاحَ لِخَوْضِ الْحَرْبِ أَمَامَ الرَّبِّ، ");
INSERT INTO arbnav_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","وَعَبَرَ كُلُّ مُتَسَلِّحٍ مِنْكُمْ نَهْرَ الأُرْدُنِّ لِيُحَارِبَ أَمَامَ الرَّبِّ حَتَّى يَتِمَّ طَرْدُ أَعْدَائِهِ مِنْ أَمَامِهِ، ");
INSERT INTO arbnav_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","فَتَخْضَعُ الأَرْضُ بَيْنَ يَدَيِ الرَّبِّ، وَبَعْدَهَا تَرْجِعُونَ، عِنْدَئِذٍ تَكُونُونَ أَبْرِيَاءَ عِنْدَ الرَّبِّ وَعِنْدَ شَعْبِ إِسْرَائِيلَ، وَتُصْبِحُ هَذِهِ الأَرْضُ مُلْكاً لَكُمْ أَمَامَ الرَّبِّ. ");
INSERT INTO arbnav_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","وَلَكِنْ إِنْ نَكَثْتُمْ بِتَعَهُّدِكُمْ فَإِنَّكُمْ تُخْطِئُونَ إِلَى الرَّبِّ. وَثِقُوا أَنَّ خَطِيئَتَكُمْ سَتُلاحِقُكُمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ابْنُوا مُدُناً لِنِسَائِكُمْ وَأَطْفَالِكُمْ، وَحَظَائِرَ لِغَنَمِكُمْ، وَنَفِّذُوا مَا تَعَهَّدْتُمْ بِهِ». ");
INSERT INTO arbnav_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","فَأَجَابَ أَبْنَاءُ سِبْطَيْ جَادٍ وَرَأُوبَيْنَ مُوسَى: «سَيَفْعَلُ عَبِيدُكَ كَأَمْرِ سَيِّدِهِمْ، ");
INSERT INTO arbnav_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","إِذْ يَمْكُثُ أَطْفَالُنَا وَنِسَاؤُنَا وَمَوَاشِينَا وَكُلُّ بَهَائِمِنَا فِي مُدُنِ جِلْعَادَ، ");
INSERT INTO arbnav_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","بَيْنَمَا يَعْبُرُ كُلُّ مُنْخَرِطٍ فِي الْجَيْشِ مِنْ عَبِيدِكَ نَهْرَ الأُرْدُنِّ لِلْحَرْبِ أَمَامَ الرَّبِّ كَمَا أَمَرَ سَيِّدُنَا». ");
INSERT INTO arbnav_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","فَأَوْصَى بِهِمْ مُوسَى أَلِعَازَارَ الْكَاهِنَ وَيَشُوعَ بْنَ نُونٍ وَرُؤَسَاءَ أَسْبَاطِ إِسْرَائِيلَ ");
INSERT INTO arbnav_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","قَائِلاً: «إِنْ عَبَرَ مَعَكُمْ نَهْرَ الأُرْدُنِّ كُلُّ مُتَجَرِّدٍ لِلْحَرْبِ بَيْنَ يَدَيِ الرَّبِّ مِنْ أَبْنَاءِ سِبْطَيْ جَادٍ وَرَأُوبَيْنَ، وَتَمَّ الاسْتِيلاءُ عَلَى الأَرْضِ، تُوَرِّثُونَهُمْ أَرْضَ جِلْعَادَ مُلْكاً. ");
INSERT INTO arbnav_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","وَلَكِنْ إِنْ تَقَاعَسُوا عَنِ الْعُبُورِ لِخَوْضِ الْحَرْبِ مَعَكُمْ، فَإِنَّكُمْ تُوَرِّثُونَهُمْ فِي وَسَطِكُمْ فِي أَرْضِ كَنْعَانَ». ");
INSERT INTO arbnav_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","فَأَجَابَ أَبْنَاءُ سِبْطَيْ جَادٍ وَرَأُوبَيْنَ: «كُلُّ مَا تَكَلَّمَ الرَّبُّ بِهِ مِنْ نَحْوِ عَبِيدِكَ نَلْتَزِمُ بِهِ، ");
INSERT INTO arbnav_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","فَإِنَّنَا نَعْبُرُ بِكَامِلِ أَسْلِحَتِنَا لِنُحَارِبَ بَيْنَ يَدَيِ الرَّبِّ فِي أَرْضِ كَنْعَانَ، وَلَكِنَّنَا لَا نَرِثُ نَصِيباً فِي غَرْبِيِّ الأُرْدُنِّ». ");
INSERT INTO arbnav_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","فَوَهَبَ مُوسَى أَبْنَاءَ سِبْطَيْ جَادٍ وَرَأُوبَيْنَ وَأَبْنَاءَ نِصْفِ سِبْطِ مَنَسَّى بْنِ يُوسُفَ مَمْلَكَةَ سِيحُونَ مَلِكِ الأَمُورِيِّينَ، وَمَمْلَكَةَ عُوجٍ مَلِكِ بَاشَانَ بِمَا فِيهِمَا مِنْ أَرَاضٍ وَمُدُنٍ وَاقِعَةٍ ضِمْنَ حُدُودِهِمَا. ");
INSERT INTO arbnav_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","فَرَمَّمَ أَبْنَاءُ سِبْطِ جَادٍ مُدُنَ دِيبُونَ وَعَطَاروُتَ وَعَرُوعِيرَ، ");
INSERT INTO arbnav_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","وَعَطْرُوتَ شُوفَانَ وَيَعَزِيرَ وَيَجْبَهَةَ، ");
INSERT INTO arbnav_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","وَبَيْتَ نِمْرَةَ وَبَيْتَ هَارَانَ، وَجَعَلُوهَا مُدُناً مُحَصَّنَةً وَبَنَوْا أَيْضاً حَظَائِرَ لِغَنَمِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","وَبَنَى أَبْنَاءُ رَأُوبَيْنَ مُدُنَ حَشْبُونَ وَأَلِعَالَةَ وَقِرْيَتَايِمَ، ");
INSERT INTO arbnav_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","وَنَبُو وَبَعْلَ مَعُونَ اللَّتَيْنِ تَمَّ تَغْيِيرُ اسْمَيْهِمَا، وَسَبْمَةَ وَأَطْلَقُوا أَسْمَاءَ أُخْرَى عَلَى الْمُدُنِ الَّتِي بَنَوْهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","وَتَوَجَّهَ أَبْنَاءُ مَاكيِرَ مِنْ سِبْطِ مَنَسَّى نَحْوَ جِلْعَادَ وَاسْتَوْلَوْا عَلَيْهَا، وَطَرَدُوا الأَمُورِيِّينَ مِنْهَا، ");
INSERT INTO arbnav_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","فَوَهَبَ مُوسَى جِلْعَادَ لِنَسْلِ مَاكِيرَ بْنِ مَنَسَّى فَأَقَامُوا فِيهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","وَاسْتَوْلَى يَائِيرُ مِنْ سِبْطِ مَنَسَّى عَلَى مَزَارِعِ جِلْعَادَ، وَدَعَاهَا حَوُّوثَ يَائِيرَ (وَمَعْنَاهَا قُرَى يَائِيرَ). ");
INSERT INTO arbnav_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","كَمَا انْطَلَقَ نُوبَحُ وَتَمَلَّكَ قَنَاةَ وَالْقُرَى الْمُحِيطَةَ بِها وَأَطْلَقَ عَلَيْهَا اسْمَهُ «نُوبَحَ». ");
INSERT INTO arbnav_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","هَذَا هُوَ سِجِلُّ رِحْلاتِ بَنِي إِسْرَائِيلَ مُنْذُ خُرُوجِهِمْ مِنْ دِيَارِ مِصْرَ، بِقِيَادَةِ مُوسَى وَهَرُونَ. ");
INSERT INTO arbnav_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","فَقَدْ دَوَّنَ مُوسَى مَرَاحِلَ رِحْلاتِهِمْ، تَلْبِيَةً لأَمْرِ الرَّبِّ، حَسَبَ وُقُوعِهَا. ");
INSERT INTO arbnav_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","فِي الْيَوْمِ الْخَامِسَ عَشَرَ مِنَ الشَّهْرِ الأَوَّلِ (الْعِبْرِيِّ)، فِي صَبَاحِ غَدِ الْفِصْحِ، ارْتَحَلَ الإِسْرَائِيلِيُّونَ مِنْ رَعَمْسِيسَ بِقُوَّةٍ أَمَامَ أَعْيُنِ جَمِيعِ الْمِصْرِيِّينَ، ");
INSERT INTO arbnav_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","الَّذِينَ كَانُوا يَدْفِنُونَ أَبْكَارَهُمُ الَّذِينَ أَهْلَكَهُمُ الرَّبُّ، وَبَعْدَ أَنْ أَنْزَلَ قَضَاءَهُ بِآلِهَتِهِمْ. ");
INSERT INTO arbnav_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","وَتَوَجَّهَ بَنُو إِسْرَائِيلَ مِنْ رَعَمْسِيسَ وَخَيَّمُوا فِي سُكُّوتَ. ");
INSERT INTO arbnav_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ثُمَّ ارْتَحَلُوا مِنْ سُكُّوتَ وَحَلُّوا فِي إِيثَامَ الْمُجَاوِرَةِ لِطَرَفِ الصَّحْرَاءِ. ");
INSERT INTO arbnav_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ثُمَّ ارْتَدُّوا مِنْ إِيثَامَ إِلَى فَمِ الْحِيرُوثِ مُقَابِلَ بَعْلِ صَفُونَ، وَنَزَلُوا أَمَامَ مَجْدَلَ. ");
INSERT INTO arbnav_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","بَعْدَ ذَلِكَ انْطَلَقُوا مِنْ أَمَامِ الْحِيرُوثِ وَاجْتَازُوا فِي وَسَطِ الْبَحْرِ إِلَى الصَّحْرَاءِ، وَتَقَدَّمُوا مَسِيرَةَ ثَلاثَةِ أَيَّامٍ فِي صَحْرَاءِ إِيثَامَ، وَأَقَامُوا فِي مَارَّةَ. ");
INSERT INTO arbnav_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ثُمَّ ارْتَحَلُوا مِنْ مَارَّةَ وَأَقْبَلُوا عَلَى إِيلِيمَ، حَيْثُ وَجَدُوا فِيهَا اثْنَتَيْ عَشْرَةَ عَيْنَ مَاءٍ وَسَبْعِينَ نَخْلَةً، فَخ