﻿USE sofia;
DROP TABLE IF EXISTS sofia.arb_vd_vpl;
CREATE TABLE arb_vd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES arb_vd_vpl WRITE;
INSERT INTO arb_vd_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","فِي ٱلْبَدْءِ خَلَقَ ٱللهُ ٱلسَّمَاوَاتِ وَٱلْأَرْضَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","وَكَانَتِ ٱلْأَرْضُ خَرِبَةً وَخَالِيَةً، وَعَلَى وَجْهِ ٱلْغَمْرِ ظُلْمَةٌ، وَرُوحُ ٱللهِ يَرِفُّ عَلَى وَجْهِ ٱلْمِيَاهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","وَقَالَ ٱللهُ: «لِيَكُنْ نُورٌ»، فَكَانَ نُورٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","وَرَأَى ٱللهُ ٱلنُّورَ أَنَّهُ حَسَنٌ. وَفَصَلَ ٱللهُ بَيْنَ ٱلنُّورِ وَٱلظُّلْمَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","وَدَعَا ٱللهُ ٱلنُّورَ نَهَارًا، وَٱلظُّلْمَةُ دَعَاهَا لَيْلًا. وَكَانَ مَسَاءٌ وَكَانَ صَبَاحٌ يَوْمًا وَاحِدًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","وَقَالَ ٱللهُ: «لِيَكُنْ جَلَدٌ فِي وَسَطِ ٱلْمِيَاهِ. وَلْيَكُنْ فَاصِلًا بَيْنَ مِيَاهٍ وَمِيَاهٍ». ");
INSERT INTO arb_vd_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","فَعَمِلَ ٱللهُ ٱلْجَلَدَ، وَفَصَلَ بَيْنَ ٱلْمِيَاهِ ٱلَّتِي تَحْتَ ٱلْجَلَدِ وَٱلْمِيَاهِ ٱلَّتِي فَوْقَ ٱلْجَلَدِ. وَكَانَ كَذَلِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","وَدَعَا ٱللهُ ٱلْجَلَدَ سَمَاءً. وَكَانَ مَسَاءٌ وَكَانَ صَبَاحٌ يَوْمًا ثَانِيًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","وَقَالَ ٱللهُ: «لِتَجْتَمِعِ ٱلْمِيَاهُ تَحْتَ ٱلسَّمَاءِ إِلَى مَكَانٍ وَاحِدٍ، وَلْتَظْهَرِ ٱلْيَابِسَةُ». وَكَانَ كَذَلِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","وَدَعَا ٱللهُ ٱلْيَابِسَةَ أَرْضًا، وَمُجْتَمَعَ ٱلْمِيَاهِ دَعَاهُ بِحَارًا. وَرَأَى ٱللهُ ذَلِكَ أَنَّهُ حَسَنٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","وَقَالَ ٱللهُ: «لِتُنْبِتِ ٱلْأَرْضُ عُشْبًا وَبَقْلًا يُبْزِرُ بِزْرًا، وَشَجَرًا ذَا ثَمَرٍ يَعْمَلُ ثَمَرًا كَجِنْسِهِ، بِزْرُهُ فِيهِ عَلَى ٱلْأَرْضِ». وَكَانَ كَذَلِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","فَأَخْرَجَتِ ٱلْأَرْضُ عُشْبًا وَبَقْلًا يُبْزِرُ بِزْرًا كَجِنْسِهِ، وَشَجَرًا يَعْمَلُ ثَمَرًا بِزْرُهُ فِيهِ كَجِنْسِهِ. وَرَأَى ٱللهُ ذَلِكَ أَنَّهُ حَسَنٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","وَكَانَ مَسَاءٌ وَكَانَ صَبَاحٌ يَوْمًا ثَالِثًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","وَقَالَ ٱللهُ: «لِتَكُنْ أَنْوَارٌ فِي جَلَدِ ٱلسَّمَاءِ لِتَفْصِلَ بَيْنَ ٱلنَّهَارِ وَٱللَّيْلِ، وَتَكُونَ لِآيَاتٍ وَأَوْقَاتٍ وَأَيَّامٍ وَسِنِينٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","وَتَكُونَ أَنْوَارًا فِي جَلَدِ ٱلسَّمَاءِ لِتُنِيرَ عَلَى ٱلْأَرْضِ». وَكَانَ كَذَلِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","فَعَمِلَ ٱللهُ ٱلنُّورَيْنِ ٱلْعَظِيمَيْنِ: ٱلنُّورَ ٱلْأَكْبَرَ لِحُكْمِ ٱلنَّهَارِ، وَٱلنُّورَ ٱلْأَصْغَرَ لِحُكْمِ ٱللَّيْلِ، وَٱلنُّجُومَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","وَجَعَلَهَا ٱللهُ فِي جَلَدِ ٱلسَّمَاءِ لِتُنِيرَ عَلَى ٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","وَلِتَحْكُمَ عَلَى ٱلنَّهَارِ وَٱللَّيْلِ، وَلِتَفْصِلَ بَيْنَ ٱلنُّورِ وَٱلظُّلْمَةِ. وَرَأَى ٱللهُ ذَلِكَ أَنَّهُ حَسَنٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","وَكَانَ مَسَاءٌ وَكَانَ صَبَاحٌ يَوْمًا رَابِعًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","وَقَالَ ٱللهُ: «لِتَفِضِ ٱلْمِيَاهُ زَحَّافَاتٍ ذَاتَ نَفْسٍ حَيَّةٍ، وَلْيَطِرْ طَيْرٌ فَوْقَ ٱلْأَرْضِ عَلَى وَجْهِ جَلَدِ ٱلسَّمَاءِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","فَخَلَقَ ٱللهُ ٱلتَّنَانِينَ ٱلْعِظَامَ، وَكُلَّ ذَوَاتِ ٱلْأَنْفُسِ ٱلْحيَّةِ ٱلدَّبَّابَةِ ٱلْتِى فَاضَتْ بِهَا ٱلْمِيَاهُ كَأَجْنَاسِهَا، وَكُلَّ طَائِرٍ ذِي جَنَاحٍ كَجِنْسِهِ. وَرَأَى ٱللهُ ذَلِكَ أَنَّهُ حَسَنٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","وَبَارَكَهَا ٱللهُ قَائِلًا: «أَثْمِرِي وَٱكْثُرِي وَٱمْلَإِي ٱلْمِيَاهَ فِي ٱلْبِحَارِ. وَلْيَكْثُرِ ٱلطَّيْرُ عَلَى ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","وَكَانَ مَسَاءٌ وَكَانَ صَبَاحٌ يَوْمًا خَامِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","وَقَالَ ٱللهُ: «لِتُخْرِجِ ٱلْأَرْضُ ذَوَاتِ أَنْفُسٍ حَيَّةٍ كَجِنْسِهَا: بَهَائِمَ، وَدَبَّابَاتٍ، وَوُحُوشَ أَرْضٍ كَأَجْنَاسِهَا». وَكَانَ كَذَلِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","فَعَمِلَ ٱللهُ وُحُوشَ ٱلْأَرْضِ كَأَجْنَاسِهَا، وَٱلْبَهَائِمَ كَأَجْنَاسِهَا، وَجَمِيعَ دَبَّابَاتِ ٱلْأَرْضِ كَأَجْنَاسِهَا. وَرَأَى ٱللهُ ذَلِكَ أَنَّهُ حَسَنٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","وَقَالَ ٱللهُ: «نَعْمَلُ ٱلْإِنْسَانَ عَلَى صُورَتِنَا كَشَبَهِنَا، فَيَتَسَلَّطُونَ عَلَى سَمَكِ ٱلْبَحْرِ وَعَلَى طَيْرِ ٱلسَّمَاءِ وَعَلَى ٱلْبَهَائِمِ، وَعَلَى كُلِّ ٱلْأَرْضِ، وَعَلَى جَمِيعِ ٱلدَّبَّابَاتِ ٱلَّتِي تَدِبُّ عَلَى ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","فَخَلَقَ ٱللهُ ٱلْإِنْسَانَ عَلَى صُورَتِهِ. عَلَى صُورَةِ ٱللهِ خَلَقَهُ. ذَكَرًا وَأُنْثَى خَلَقَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","وَبَارَكَهُمُ ٱللهُ وَقَالَ لَهُمْ: «أَثْمِرُوا وَٱكْثُرُوا وَٱمْلَأُوا ٱلْأَرْضَ، وَأَخْضِعُوهَا، وَتَسَلَّطُوا عَلَى سَمَكِ ٱلْبَحْرِ وَعَلَى طَيْرِ ٱلسَّمَاءِ وَعَلَى كُلِّ حَيَوَانٍ يَدِبُّ عَلَى ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","وَقَالَ ٱللهُ: «إِنِّي قَدْ أَعْطَيْتُكُمْ كُلَّ بَقْلٍ يُبْزِرُ بِزْرًا عَلَى وَجْهِ كُلِّ ٱلْأَرْضِ، وَكُلَّ شَجَرٍ فِيهِ ثَمَرُ شَجَرٍ يُبْزِرُ بِزْرًا لَكُمْ يَكُونُ طَعَامًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","وَلِكُلِّ حَيَوَانِ ٱلْأَرْضِ وَكُلِّ طَيْرِ ٱلسَّمَاءِ وَكُلِّ دَبَّابَةٍ عَلَى ٱلْأَرْضِ فِيهَا نَفْسٌ حَيَّةٌ، أَعْطَيْتُ كُلَّ عُشْبٍ أَخْضَرَ طَعَامًا». وَكَانَ كَذَلِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","وَرَأَى ٱللهُ كُلَّ مَا عَمِلَهُ فَإِذَا هُوَ حَسَنٌ جِدًّا. وَكَانَ مَسَاءٌ وَكَانَ صَبَاحٌ يَوْمًا سَادِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","فَأُكْمِلَتِ ٱلسَّمَاوَاتُ وَٱلْأَرْضُ وَكُلُّ جُنْدِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","وَفَرَغَ ٱللهُ فِي ٱلْيَوْمِ ٱلسَّابِعِ مِنْ عَمَلِهِ ٱلَّذِي عَمِلَ. فَٱسْتَرَاحَ فِي ٱلْيَوْمِ ٱلسَّابِعِ مِنْ جَمِيعِ عَمَلِهِ ٱلَّذِي عَمِلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","وَبَارَكَ ٱللهُ ٱلْيَوْمَ ٱلسَّابِعَ وَقَدَّسَهُ، لِأَنَّهُ فِيهِ ٱسْتَرَاحَ مِنْ جَمِيعِ عَمَلِهِ ٱلَّذِي عَمِلَ ٱللهُ خَالِقًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","هَذِهِ مَبَادِئُ ٱلسَّمَاوَاتِ وَٱلْأَرْضِ حِينَ خُلِقَتْ، يَوْمَ عَمِلَ ٱلرَّبُّ ٱلْإِلَهُ ٱلْأَرْضَ وَٱلسَّمَاوَاتِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","كُلُّ شَجَرِ ٱلْبَرِّيَّةِ لَمْ يَكُنْ بَعْدُ فِي ٱلْأَرْضِ، وَكُلُّ عُشْبِ ٱلْبَرِّيَّةِ لَمْ يَنْبُتْ بَعْدُ، لِأَنَّ ٱلرَّبَّ ٱلْإِلَهَ لَمْ يَكُنْ قَدْ أَمْطَرَ عَلَى ٱلْأَرْضِ، وَلَا كَانَ إِنْسَانٌ لِيَعْمَلَ ٱلْأَرْضَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ثُمَّ كَانَ ضَبَابٌ يَطْلَعُ مِنَ ٱلْأَرْضِ وَيَسْقِي كُلَّ وَجْهِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","وَجَبَلَ ٱلرَّبُّ ٱلْإِلَهُ آدَمَ تُرَابًا مِنَ ٱلْأَرْضِ، وَنَفَخَ فِي أَنْفِهِ نَسَمَةَ حَيَاةٍ. فَصَارَ آدَمُ نَفْسًا حَيَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","وَغَرَسَ ٱلرَّبُّ ٱلْإِلَهُ جَنَّةً فِي عَدْنٍ شَرْقًا، وَوَضَعَ هُنَاكَ آدَمَ ٱلَّذِي جَبَلَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","وَأَنْبَتَ ٱلرَّبُّ ٱلْإِلَهُ مِنَ ٱلْأَرْضِ كُلَّ شَجَرَةٍ شَهِيَّةٍ لِلنَّظَرِ وَجَيِّدَةٍ لِلْأَكْلِ، وَشَجَرَةَ ٱلْحَيَاةِ فِي وَسَطِ ٱلْجَنَّةِ، وَشَجَرَةَ مَعْرِفَةِ ٱلْخَيْرِ وَٱلشَّرِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","وَكَانَ نَهْرٌ يَخْرُجُ مِنْ عَدْنٍ لِيَسْقِيَ ٱلْجَنَّةَ، وَمِنْ هُنَاكَ يَنْقَسِمُ فَيَصِيرُ أَرْبَعَةَ رُؤُوسٍ: ");
INSERT INTO arb_vd_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","اِسْمُ ٱلْوَاحِدِ فِيشُونُ، وَهُوَ ٱلْمُحِيطُ بِجَمِيعِ أَرْضِ ٱلْحَوِيلَةِ حَيْثُ ٱلذَّهَبُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","وَذَهَبُ تِلْكَ ٱلْأَرْضِ جَيِّدٌ. هُنَاكَ ٱلْمُقْلُ وَحَجَرُ ٱلْجَزْعِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","وَٱسْمُ ٱلنَّهْرِ ٱلثَّانِى جِيحُونُ، وَهُوَ ٱلْمُحِيطُ بِجَمِيعِ أَرْضِ كُوشٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","وَٱسْمُ ٱلنَّهْرِ ٱلثَّالِثِ حِدَّاقِلُ، وَهُوَ ٱلْجَارِي شَرْقِيَّ أَشُّورَ. وَٱلنَّهْرُ ٱلرَّابِعُ ٱلْفُرَاتُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","وَأَخَذَ ٱلرَّبُّ ٱلْإِلَهُ آدَمَ وَوَضَعَهُ فِي جَنَّةِ عَدْنٍ لِيَعْمَلَهَا وَيَحْفَظَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","وَأَوْصَى ٱلرَّبُّ ٱلْإِلَهُ آدَمَ قَائِلًا: «مِنْ جَمِيعِ شَجَرِ ٱلْجَنَّةِ تَأْكُلُ أَكْلًا، ");
INSERT INTO arb_vd_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","وَأَمَّا شَجَرَةُ مَعْرِفَةِ ٱلْخَيْرِ وَٱلشَّرِّ فَلَا تَأْكُلْ مِنْهَا، لِأَنَّكَ يَوْمَ تَأْكُلُ مِنْهَا مَوْتًا تَمُوتُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","وَقَالَ ٱلرَّبُّ ٱلْإِلَهُ: «لَيْسَ جَيِّدًا أَنْ يَكُونَ آدَمُ وَحْدَهُ، فَأَصْنَعَ لَهُ مُعِينًا نَظِيرَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","وَجَبَلَ ٱلرَّبُّ ٱلْإِلَهُ مِنَ ٱلْأَرْضِ كُلَّ حَيَوَانَاتِ ٱلْبَرِّيَّةِ وَكُلَّ طُيُورِ ٱلسَّمَاءِ، فَأَحْضَرَهَا إِلَى آدَمَ لِيَرَى مَاذَا يَدْعُوهَا، وَكُلُّ مَا دَعَا بِهِ آدَمُ ذَاتَ نَفْسٍ حَيَّةٍ فَهُوَ ٱسْمُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","فَدَعَا آدَمُ بِأَسْمَاءٍ جَمِيعَ ٱلْبَهَائِمِ وَطُيُورَ ٱلسَّمَاءِ وَجَمِيعَ حَيَوَانَاتِ ٱلْبَرِّيَّةِ. وَأَمَّا لِنَفْسِهِ فَلَمْ يَجِدْ مُعِينًا نَظِيرَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","فَأَوْقَعَ ٱلرَّبُّ ٱلْإِلَهُ سُبَاتًا عَلَى آدَمَ فَنَامَ، فَأَخَذَ وَاحِدَةً مِنْ أَضْلَاعِهِ وَمَلَأَ مَكَانَهَا لَحْمًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","وَبَنَى ٱلرَّبُّ ٱلْإِلَهُ ٱلضِّلْعَ ٱلَّتِي أَخَذَهَا مِنْ آدَمَ ٱمْرَأَةً وَأَحْضَرَهَا إِلَى آدَمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","فَقَالَ آدَمُ: «هَذِهِ ٱلْآنَ عَظْمٌ مِنْ عِظَامِي وَلَحْمٌ مِنْ لَحْمِي. هَذِهِ تُدْعَى ٱمْرَأَةً لِأَنَّهَا مِنِ ٱمْرِءٍ أُخِذَتْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","لِذَلِكَ يَتْرُكُ ٱلرَّجُلُ أَبَاهُ وَأُمَّهُ وَيَلْتَصِقُ بِٱمْرَأَتِهِ وَيَكُونَانِ جَسَدًا وَاحِدًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","وَكَانَا كِلَاهُمَا عُرْيَانَيْنِ، آدَمُ وَٱمْرَأَتُهُ، وَهُمَا لَا يَخْجَلَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","وَكَانَتِ ٱلْحَيَّةُ أَحْيَلَ جَمِيعِ حَيَوَانَاتِ ٱلْبَرِّيَّةِ ٱلَّتِي عَمِلَهَا ٱلرَّبُّ ٱلْإِلَهُ، فَقَالَتْ لِلْمَرْأَةِ: «أَحَقًّا قَالَ ٱللهُ لَا تَأْكُلَا مِنْ كُلِّ شَجَرِ ٱلْجَنَّةِ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","فَقَالَتِ ٱلْمَرْأَةُ لِلْحَيَّةِ: «مِنْ ثَمَرِ شَجَرِ ٱلْجَنَّةِ نَأْكُلُ، ");
INSERT INTO arb_vd_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","وَأَمَّا ثَمَرُ ٱلشَّجَرَةِ ٱلَّتِي فِي وَسَطِ ٱلْجَنَّةِ فَقَالَ ٱللهُ: لَا تَأْكُلَا مِنْهُ وَلَا تَمَسَّاهُ لِئَلَّا تَمُوتَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","فَقَالَتِ ٱلْحَيَّةُ لِلْمَرْأَةِ: «لَنْ تَمُوتَا! ");
INSERT INTO arb_vd_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","بَلِ ٱللهُ عَالِمٌ أَنَّهُ يَوْمَ تَأْكُلَانِ مِنْهُ تَنْفَتِحُ أَعْيُنُكُمَا وَتَكُونَانِ كَٱللهِ عَارِفَيْنِ ٱلْخَيْرَ وَٱلشَّرَّ». ");
INSERT INTO arb_vd_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","فَرَأَتِ ٱلْمَرْأَةُ أَنَّ ٱلشَّجَرَةَ جَيِّدَةٌ لِلْأَكْلِ، وَأَنَّهَا بَهِجَةٌ لِلْعُيُونِ، وَأَنَّ ٱلشَّجَرَةَ شَهِيَّةٌ لِلنَّظَرِ. فَأَخَذَتْ مِنْ ثَمَرِهَا وَأَكَلَتْ، وَأَعْطَتْ رَجُلَهَا أَيْضًا مَعَهَا فَأَكَلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","فَٱنْفَتَحَتْ أَعْيُنُهُمَا وَعَلِمَا أَنَّهُمَا عُرْيَانَانِ. فَخَاطَا أَوْرَاقَ تِينٍ وَصَنَعَا لِأَنْفُسِهِمَا مَآزِرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","وَسَمِعَا صَوْتَ ٱلرَّبِّ ٱلْإِلَهِ مَاشِيًا فِي ٱلْجَنَّةِ عِنْدَ هُبُوبِ رِيحِ ٱلنَّهَارِ، فَٱخْتَبَأَ آدَمُ وَٱمْرَأَتُهُ مِنْ وَجْهِ ٱلرَّبِّ ٱلْإِلَهِ فِي وَسَطِ شَجَرِ ٱلْجَنَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","فَنَادَى ٱلرَّبُّ ٱلْإِلَهُ آدَمَ وَقَالَ لَهُ: «أَيْنَ أَنْتَ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","فَقَالَ: «سَمِعْتُ صَوْتَكَ فِي ٱلْجَنَّةِ فَخَشِيتُ، لِأَنِّي عُرْيَانٌ فَٱخْتَبَأْتُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","فَقَالَ: «مَنْ أَعْلَمَكَ أَنَّكَ عُرْيَانٌ؟ هَلْ أَكَلْتَ مِنَ ٱلشَّجَرَةِ ٱلَّتِي أَوْصَيْتُكَ أَنْ لَا تَأْكُلَ مِنْهَا؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","فَقَالَ آدَمُ: «ٱلْمَرْأَةُ ٱلَّتِي جَعَلْتَهَا مَعِي هِيَ أَعْطَتْنِي مِنَ ٱلشَّجَرَةِ فَأَكَلْتُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","فَقَالَ ٱلرَّبُّ ٱلْإِلَهُ لِلْمَرْأَةِ: «مَا هَذَا ٱلَّذِي فَعَلْتِ؟» فَقَالَتِ ٱلْمَرْأَةُ: «ٱلْحَيَّةُ غَرَّتْنِي فَأَكَلْتُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","فَقَالَ ٱلرَّبُّ ٱلْإِلَهُ لِلْحَيَّةِ: «لِأَنَّكِ فَعَلْتِ هَذَا، مَلْعُونَةٌ أَنْتِ مِنْ جَمِيعِ ٱلْبَهَائِمِ وَمِنْ جَمِيعِ وُحُوشِ ٱلْبَرِّيَّةِ. عَلَى بَطْنِكِ تَسْعَيْنَ وَتُرَابًا تَأْكُلِينَ كُلَّ أَيَّامِ حَيَاتِكِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","وَأَضَعُ عَدَاوَةً بَيْنَكِ وَبَيْنَ ٱلْمَرْأَةِ، وَبَيْنَ نَسْلِكِ وَنَسْلِهَا. هُوَ يَسْحَقُ رَأْسَكِ، وَأَنْتِ تَسْحَقِينَ عَقِبَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","وَقَالَ لِلْمَرْأَةِ: «تَكْثِيرًا أُكَثِّرُ أَتْعَابَ حَبَلِكِ، بِٱلْوَجَعِ تَلِدِينَ أَوْلَادًا. وَإِلَى رَجُلِكِ يَكُونُ ٱشْتِيَاقُكِ وَهُوَ يَسُودُ عَلَيْكِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","وَقَالَ لِآدَمَ: «لِأَنَّكَ سَمِعْتَ لِقَوْلِ ٱمْرَأَتِكَ وَأَكَلْتَ مِنَ ٱلشَّجَرَةِ ٱلَّتِي أَوْصَيْتُكَ قَائِلًا: لَا تَأْكُلْ مِنْهَا، مَلْعُونَةٌ ٱلْأَرْضُ بِسَبَبِكَ. بِٱلتَّعَبِ تَأْكُلُ مِنْهَا كُلَّ أَيَّامِ حَيَاتِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","وَشَوْكًا وَحَسَكًا تُنْبِتُ لَكَ، وَتَأْكُلُ عُشْبَ ٱلْحَقْلِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","بِعَرَقِ وَجْهِكَ تَأْكُلُ خُبْزًا حَتَّى تَعُودَ إِلَى ٱلْأَرْضِ ٱلَّتِي أُخِذْتَ مِنْهَا. لِأَنَّكَ تُرَابٌ، وَإِلَى تُرَابٍ تَعُودُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","وَدَعَا آدَمُ ٱسْمَ ٱمْرَأَتِهِ «حَوَّاءَ» لِأَنَّهَا أُمُّ كُلِّ حَيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","وَصَنَعَ ٱلرَّبُّ ٱلْإِلَهُ لِآدَمَ وَٱمْرَأَتِهِ أَقْمِصَةً مِنْ جِلْدٍ وَأَلْبَسَهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","وَقَالَ ٱلرَّبُّ ٱلْإِلَهُ: «هُوَذَا ٱلْإِنْسَانُ قَدْ صَارَ كَوَاحِدٍ مِنَّا عَارِفًا ٱلْخَيْرَ وَٱلشَّرَّ. وَٱلْآنَ لَعَلَّهُ يَمُدُّ يَدَهُ وَيَأْخُذُ مِنْ شَجَرَةِ ٱلْحَيَاةِ أَيْضًا وَيَأْكُلُ وَيَحْيَا إِلَى ٱلْأَبَدِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","فَأَخْرَجَهُ ٱلرَّبُّ ٱلْإِلَهُ مِنْ جَنَّةِ عَدْنٍ لِيَعْمَلَ ٱلْأَرْضَ ٱلَّتِي أُخِذَ مِنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","فَطَرَدَ ٱلْإِنْسَانَ، وَأَقَامَ شَرْقِيَّ جَنَّةِ عَدْنٍ ٱلْكَرُوبِيمَ، وَلَهِيبَ سَيْفٍ مُتَقَلِّبٍ لِحِرَاسَةِ طَرِيقِ شَجَرَةِ ٱلْحَيَاةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","وَعَرَفَ آدَمُ حَوَّاءَ ٱمْرَأَتَهُ فَحَبِلَتْ وَوَلَدَتْ قَايِينَ. وَقَالَتِ: «ٱقْتَنَيْتُ رَجُلًا مِنْ عِنْدِ ٱلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ثُمَّ عَادَتْ فَوَلَدَتْ أَخَاهُ هَابِيلَ. وَكَانَ هَابِيلُ رَاعِيًا لِلْغَنَمِ، وَكَانَ قَايِينُ عَامِلًا فِي ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","وَحَدَثَ مِنْ بَعْدِ أَيَّامٍ أَنَّ قَايِينَ قَدَّمَ مِنْ أَثْمَارِ ٱلْأَرْضِ قُرْبَانًا لِلرَّبِّ، ");
INSERT INTO arb_vd_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","وَقَدَّمَ هَابِيلُ أَيْضًا مِنْ أَبْكَارِ غَنَمِهِ وَمِنْ سِمَانِهَا. فَنَظَرَ ٱلرَّبُّ إِلَى هَابِيلَ وَقُرْبَانِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","وَلَكِنْ إِلَى قَايِينَ وَقُرْبَانِهِ لَمْ يَنْظُرْ. فَٱغْتَاظَ قَايِينُ جِدًّا وَسَقَطَ وَجْهُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","فَقَالَ ٱلرَّبُّ لِقَايِينَ: «لِمَاذَا ٱغْتَظْتَ؟ وَلِمَاذَا سَقَطَ وَجْهُكَ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","إِنْ أَحْسَنْتَ أَفَلَا رَفْعٌ؟ وَإِنْ لَمْ تُحْسِنْ فَعِنْدَ ٱلْبَابِ خَطِيَّةٌ رَابِضَةٌ، وَإِلَيْكَ ٱشْتِيَاقُهَا وَأَنْتَ تَسُودُ عَلَيْهَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","وَكَلَّمَ قَايِينُ هَابِيلَ أَخَاهُ. وَحَدَثَ إِذْ كَانَا فِي ٱلْحَقْلِ أَنَّ قَايِينَ قَامَ عَلَى هَابِيلَ أَخِيهِ وَقَتَلَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","فَقَالَ ٱلرَّبُّ لِقَايِينَ: «أَيْنَ هَابِيلُ أَخُوكَ؟» فَقَالَ: «لَا أَعْلَمُ! أَحَارِسٌ أَنَا لِأَخِي؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","فَقَالَ: «مَاذَا فَعَلْتَ؟ صَوْتُ دَمِ أَخِيكَ صَارِخٌ إِلَيَّ مِنَ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","فَٱلْآنَ مَلْعُونٌ أَنْتَ مِنَ ٱلْأَرْضِ ٱلَّتِي فَتَحَتْ فَاهَا لِتَقْبَلَ دَمَ أَخِيكَ مِنْ يَدِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","مَتَى عَمِلْتَ ٱلْأَرْضَ لَا تَعُودُ تُعْطِيكَ قُوَّتَهَا. تَائِهًا وَهَارِبًا تَكُونُ فِي ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","فَقَالَ قَايِينُ لِلرَّبِّ: «ذَنْبِي أَعْظَمُ مِنْ أَنْ يُحْتَمَلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","إِنَّكَ قَدْ طَرَدْتَنِي ٱلْيَوْمَ عَنْ وَجْهِ ٱلْأَرْضِ، وَمِنْ وَجْهِكَ أَخْتَفِي وَأَكُونُ تَائِهًا وَهَارِبًا فِي ٱلْأَرْضِ، فَيَكُونُ كُلُّ مَنْ وَجَدَنِي يَقْتُلُنِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","فَقَالَ لَهُ ٱلرَّبُّ: «لِذَلِكَ كُلُّ مَنْ قَتَلَ قَايِينَ فَسَبْعَةَ أَضْعَافٍ يُنْتَقَمُ مِنْهُ». وَجَعَلَ ٱلرَّبُّ لِقَايِينَ عَلَامَةً لِكَيْ لَا يَقْتُلَهُ كُلُّ مَنْ وَجَدَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","فَخَرَجَ قَايِينُ مِنْ لَدُنِ ٱلرَّبِّ، وَسَكَنَ فِي أَرْضِ نُودٍ شَرْقِيَّ عَدْنٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","وَعَرَفَ قَايِينُ ٱمْرَأَتَهُ فَحَبِلَتْ وَوَلَدَتْ حَنُوكَ. وَكَانَ يَبْنِي مَدِينَةً، فَدَعَا ٱسْمَ ٱلْمَدِينَةِ كَٱسْمِ ٱبْنِهِ حَنُوكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","وَوُلِدَ لِحَنُوكَ عِيرَادُ. وَعِيرَادُ وَلَدَ مَحُويَائِيلَ. وَمَحُويَائِيلُ وَلَدَ مَتُوشَائِيلَ. وَمَتُوشَائِيلُ وَلَدَ لَامَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","وَٱتَّخَذَ لَامَكُ لِنَفْسِهِ ٱمْرَأَتَيْنِ: ٱسْمُ ٱلْوَاحِدَةِ عَادَةُ، وَٱسْمُ ٱلْأُخْرَى صِلَّةُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","فَوَلَدَتْ عَادَةُ يَابَالَ ٱلَّذِي كَانَ أَبًا لِسَاكِنِي ٱلْخِيَامِ وَرُعَاةِ ٱلْمَوَاشِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","وَٱسْمُ أَخِيهِ يُوبَالُ ٱلَّذِي كَانَ أَبًا لِكُلِّ ضَارِبٍ بِٱلْعُودِ وَٱلْمِزْمَارِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","وَصِلَّةُ أَيْضًا وَلَدَتْ تُوبَالَ قَايِينَ ٱلضَّارِبَ كُلَّ آلَةٍ مِنْ نُحَاسٍ وَحَدِيدٍ. وَأُخْتُ تُوبَالَ قَايِينَ نَعْمَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","وَقَالَ لَامَكُ لِٱمْرَأَتَيْهِ عَادَةَ وَصِلَّةَ: «ٱسْمَعَا قَوْلِي يَا ٱمْرَأَتَيْ لَامَكَ، وَأَصْغِيَا لِكَلَامِي. فَإِنِّي قَتَلْتُ رَجُلًا لِجُرْحِي، وَفَتىً لِشَدْخِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","إِنَّهُ يُنْتَقَمُ لِقَايِينَ سَبْعَةَ أَضْعَافٍ، وَأَمَّا لِلَامَكَ فَسَبْعَةً وَسَبْعِينَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","وَعَرَفَ آدَمُ ٱمْرَأَتَهُ أَيْضًا، فَوَلَدَتِ ٱبْنًا وَدَعَتِ ٱسْمَهُ شِيثًا، قَائِلَةً: «لِأَنَّ ٱللهَ قَدْ وَضَعَ لِي نَسْلًا آخَرَ عِوَضًا عَنْ هَابِيلَ». لِأَنَّ قَايِينَ كَانَ قَدْ قَتَلَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","وَلِشِيثَ أَيْضًا وُلِدَ ٱبْنٌ فَدَعَا ٱسْمَهُ أَنُوشَ. حِينَئِذٍ ٱبْتُدِئَ أَنْ يُدْعَى بِٱسْمِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","هَذَا كِتَابُ مَوَالِيدِ آدَمَ، يَوْمَ خَلَقَ ٱللهُ ٱلْإِنْسَانَ. عَلَى شَبَهِ ٱللهِ عَمِلَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ذَكَرًا وَأُنْثَى خَلَقَهُ، وَبَارَكَهُ وَدَعَا ٱسْمَهُ آدَمَ يَوْمَ خُلِقَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","وَعَاشَ آدَمُ مِئَةً وَثَلَاثِينَ سَنَةً، وَوَلَدَ وَلَدًا عَلَى شَبَهِهِ كَصُورَتِهِ وَدَعَا ٱسْمَهُ شِيثًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","وَكَانَتْ أَيَّامُ آدَمَ بَعْدَ مَا وَلَدَ شِيثًا ثَمَانِيَ مِئَةِ سَنَةٍ، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","فَكَانَتْ كُلُّ أَيَّامِ آدَمَ ٱلَّتِي عَاشَهَا تِسْعَ مِئَةٍ وَثَلَاثِينَ سَنَةً، وَمَاتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","وَعَاشَ شِيثُ مِئَةً وَخَمْسَ سِنِينَ، وَوَلَدَ أَنُوشَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","وَعَاشَ شِيثُ بَعْدَ مَا وَلَدَ أَنُوشَ ثَمَانِيَ مِئَةٍ وَسَبْعَ سِنِينَ، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","فَكَانَتْ كُلُّ أَيَّامِ شِيثَ تِسْعَ مِئَةٍ وَٱثْنَتَيْ عَشَرَةَ سَنَةً، وَمَاتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","وَعَاشَ أَنُوشُ تِسْعِينَ سَنَةً، وَوَلَدَ قِينَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","وَعَاشَ أَنُوشُ بَعْدَ مَا وَلَدَ قِينَانَ ثَمَانِيَ مِئَةٍ وَخَمْسَ عَشَرَةَ سَنَةً، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","فَكَانَتْ كُلُّ أَيَّامِ أَنُوشَ تِسْعَ مِئَةٍ وَخَمْسَ سِنِينَ، وَمَاتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","وَعَاشَ قِينَانُ سَبْعِينَ سَنَةً، وَوَلَدَ مَهْلَلْئِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","وَعَاشَ قِينَانُ بَعْدَ مَا وَلَدَ مَهْلَلْئِيلَ ثَمَانِيَ مِئَةٍ وَأَرْبَعِينَ سَنَةً، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","فَكَانَتْ كُلُّ أَيَّامِ قِينَانَ تِسْعَ مِئَةٍ وَعَشْرَ سِنِينَ، وَمَاتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","وَعَاشَ مَهْلَلْئِيلُ خَمْسًا وَسِتِّينَ سَنَةً، وَوَلَدَ يَارَدَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","وَعَاشَ مَهْلَلْئِيلُ بَعْدَ مَا وَلَدَ يَارَدَ ثَمَانِيَ مِئَةٍ وَثَلَاثِينَ سَنَةً، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","فَكَانَتْ كُلُّ أَيَّامِ مَهْلَلْئِيلَ ثَمَانِيَ مِئَةٍ وَخَمْسًا وَتِسْعِينَ سَنَةً، وَمَاتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","وَعَاشَ يَارَدُ مِئَةً وَٱثْنَتَيْنِ وَسِتِّينَ سَنَةً، وَوَلَدَ أَخْنُوخَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","وَعَاشَ يَارَدُ بَعْدَ مَا وَلَدَ أَخْنُوخَ ثَمَانِيَ مِئَةِ سَنَةٍ، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","فَكَانَتْ كُلُّ أَيَّامِ يَارَدَ تِسْعَ مِئَةٍ وَٱثْنَتَيْنِ وَسِتِّينَ سَنَةً، وَمَاتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","وَعَاشَ أَخْنُوخُ خَمْسًا وَسِتِّينَ سَنَةً، وَوَلَدَ مَتُوشَالَحَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","وَسَارَ أَخْنُوخُ مَعَ ٱللهِ بَعْدَ مَا وَلَدَ مَتُوشَالَحَ ثَلَاثَ مِئَةِ سَنَةٍ، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","فَكَانَتْ كُلُّ أَيَّامِ أَخْنُوخَ ثَلَاثَ مِئَةٍ وَخَمْسًا وَسِتِّينَ سَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","وَسَارَ أَخْنُوخُ مَعَ ٱللهِ، وَلَمْ يُوجَدْ لِأَنَّ ٱللهَ أَخَذَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","وَعَاشَ مَتُوشَالَحُ مِئَةً وَسَبْعًا وَثَمَانِينَ سَنَةً، وَوَلَدَ لَامَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","وَعَاشَ مَتُوشَالَحُ بَعْدَ مَا وَلَدَ لَامَكَ سَبْعَ مِئَةٍ وَٱثْنَتَيْنِ وَثَمَانِينَ سَنَةً، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","فَكَانَتْ كُلُّ أَيَّامِ مَتُوشَالَحَ تِسْعَ مِئَةٍ وَتِسْعًا وَسِتِّينَ سَنَةً، وَمَاتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","وَعَاشَ لَامَكُ مِئَةً وَٱثْنَتَيْنِ وَثَمَانِينَ سَنَةً، وَوَلَدَ ٱبْنًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","وَدَعَا ٱسْمَهُ نُوحًا، قَائِلًا: «هَذَا يُعَزِّينَا عَنْ عَمَلِنَا وَتَعَبِ أَيْدِينَا مِنْ قِبَلِ ٱلْأَرْضِ ٱلَّتِي لَعَنَهَا ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","وَعَاشَ لَامَكُ بَعْدَ مَا وَلَدَ نُوحًا خَمْسَ مِئَةٍ وَخَمْسًا وَتِسْعِينَ سَنَةً، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","فَكَانَتْ كُلُّ أَيَّامِ لَامَكَ سَبْعَ مِئَةٍ وَسَبْعًا وَسَبْعِينَ سَنَةً، وَمَاتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","وَكَانَ نُوحٌ ٱبْنَ خَمْسِ مِئَةِ سَنَةٍ. وَوَلَدَ نُوحٌ: سَامًا، وَحَامًا، وَيَافَثَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","وَحَدَثَ لَمَّا ٱبْتَدَأَ ٱلنَّاسُ يَكْثُرُونَ عَلَى ٱلْأَرْضِ، وَوُلِدَ لَهُمْ بَنَاتٌ، ");
INSERT INTO arb_vd_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","أَنَّ أَبْنَاءَ ٱللهِ رَأَوْا بَنَاتِ ٱلنَّاسِ أَنَّهُنَّ حَسَنَاتٌ. فَٱتَّخَذُوا لِأَنْفُسِهِمْ نِسَاءً مِنْ كُلِّ مَا ٱخْتَارُوا. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","فَقَالَ ٱلرَّبُّ: «لَا يَدِينُ رُوحِي فِي ٱلْإِنْسَانِ إِلَى ٱلْأَبَدِ، لِزَيَغَانِهِ، هُوَ بَشَرٌ. وَتَكُونُ أَيَّامُهُ مِئَةً وَعِشْرِينَ سَنَةً». ");
INSERT INTO arb_vd_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","كَانَ فِي ٱلْأَرْضِ طُغَاةٌ فِي تِلْكَ ٱلْأَيَّامِ. وَبَعْدَ ذَلِكَ أَيْضًا إِذْ دَخَلَ بَنُو ٱللهِ عَلَى بَنَاتِ ٱلنَّاسِ وَوَلَدْنَ لَهُمْ أَوْلَادًا، هَؤُلَاءِ هُمُ ٱلْجَبَابِرَةُ ٱلَّذِينَ مُنْذُ ٱلدَّهْرِ ذَوُو ٱسْمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","وَرَأَى ٱلرَّبُّ أَنَّ شَرَّ ٱلْإِنْسَانِ قَدْ كَثُرَ فِي ٱلْأَرْضِ، وَأَنَّ كُلَّ تَصَوُّرِ أَفْكَارِ قَلْبِهِ إِنَّمَا هُوَ شِرِّيرٌ كُلَّ يَوْمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","فَحَزِنَ ٱلرَّبُّ أَنَّهُ عَمِلَ ٱلْإِنْسَانَ فِي ٱلْأَرْضِ، وَتَأَسَّفَ فِي قَلْبِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","فَقَالَ ٱلرَّبُّ: «أَمْحُو عَنْ وَجْهِ ٱلْأَرْضِ ٱلْإِنْسَانَ ٱلَّذِي خَلَقْتُهُ، ٱلْإِنْسَانَ مَعَ بَهَائِمَ وَدَبَّابَاتٍ وَطُيُورِ ٱلسَّمَاءِ، لِأَنِّي حَزِنْتُ أَنِّي عَمِلْتُهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","وَأَمَّا نُوحٌ فَوَجَدَ نِعْمَةً فِي عَيْنَيِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","هَذِهِ مَوَالِيدُ نُوحٍ: كَانَ نُوحٌ رَجُلًا بَارًّا كَامِلًا فِي أَجْيَالِهِ. وَسَارَ نُوحٌ مَعَ ٱللهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","وَوَلَدَ نُوحٌ ثَلَاثَةَ بَنِينَ: سَامًا، وَحَامًا، وَيَافَثَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","وَفَسَدَتِ ٱلْأَرْضُ أَمَامَ ٱللهِ، وَٱمْتَلَأَتِ ٱلْأَرْضُ ظُلْمًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","وَرَأَى ٱللهُ ٱلْأَرْضَ فَإِذَا هِيَ قَدْ فَسَدَتْ، إِذْ كَانَ كُلُّ بَشَرٍ قَدْ أَفْسَدَ طَرِيقَهُ عَلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","فَقَالَ ٱللهُ لِنُوحٍ: «نِهَايَةُ كُلِّ بَشَرٍ قَدْ أَتَتْ أَمَامِي، لِأَنَّ ٱلْأَرْضَ ٱمْتَلَأَتْ ظُلْمًا مِنْهُمْ. فَهَا أَنَا مُهْلِكُهُمْ مَعَ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","اِصْنَعْ لِنَفْسِكَ فُلْكًا مِنْ خَشَبِ جُفْرٍ. تَجْعَلُ ٱلْفُلْكَ مَسَاكِنَ، وَتَطْلِيهِ مِنْ دَاخِلٍ وَمِنْ خَارِجٍ بِٱلْقَارِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","وَهَكَذَا تَصْنَعُهُ: ثَلَاثَ مِئَةِ ذِرَاعٍ يَكُونُ طُولُ ٱلْفُلْكِ، وَخَمْسِينَ ذِرَاعًا عَرْضُهُ، وَثَلَاثِينَ ذِرَاعًا ٱرْتِفَاعُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","وَتَصْنَعُ كَوًّا لِلْفُلْكِ، وَتُكَمِّلُهُ إِلَى حَدِّ ذِرَاعٍ مِنْ فَوْقُ. وَتَضَعُ بَابَ ٱلْفُلْكِ فِي جَانِبِهِ. مَسَاكِنَ سُفْلِيَّةً وَمُتَوَسِّطَةً وَعُلْوِيَّةً تَجْعَلُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","فَهَا أَنَا آتٍ بِطُوفَانِ ٱلْمَاءِ عَلَى ٱلْأَرْضِ لِأُهْلِكَ كُلَّ جَسَدٍ فِيهِ رُوحُ حَيَاةٍ مِنْ تَحْتِ ٱلسَّمَاءِ. كُلُّ مَا فِي ٱلْأَرْضِ يَمُوتُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","وَلَكِنْ أُقِيمُ عَهْدِي مَعَكَ، فَتَدْخُلُ ٱلْفُلْكَ أَنْتَ وَبَنُوكَ وَٱمْرَأَتُكَ وَنِسَاءُ بَنِيكَ مَعَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","وَمِنْ كُلِّ حَيٍّ مِنْ كُلِّ ذِي جَسَدٍ، ٱثْنَيْنِ مِنْ كُلٍّ تُدْخِلُ إِلَى ٱلْفُلْكِ لِٱسْتِبْقَائِهَا مَعَكَ. تَكُونُ ذَكَرًا وَأُنْثَى. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","مِنَ ٱلطُّيُورِ كَأَجْنَاسِهَا، وَمِنَ ٱلْبَهَائِمِ كَأَجْنَاسِهَا، وَمِنْ كُلِّ دَبَّابَاتِ ٱلْأَرْضِ كَأَجْنَاسِهَا. ٱثْنَيْنِ مِنْ كُلٍّ تُدْخِلُ إِلَيْكَ لِٱسْتِبْقَائِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","وَأَنْتَ، فَخُذْ لِنَفْسِكَ مِنْ كُلِّ طَعَامٍ يُؤْكَلُ وَٱجْمَعْهُ عِنْدَكَ، فَيَكُونَ لَكَ وَلَهَا طَعَامًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","فَفَعَلَ نُوحٌ حَسَبَ كُلِّ مَا أَمَرَهُ بِهِ ٱللهُ. هَكَذَا فَعَلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","وَقَالَ ٱلرَّبُّ لِنُوحٍ: «ٱدْخُلْ أَنْتَ وَجَمِيعُ بَيْتِكَ إِلَى ٱلْفُلْكِ، لِأَنِّي إِيَّاكَ رَأَيْتُ بَارًّا لَدَيَّ فِي هَذَا ٱلْجِيلِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","مِنْ جَمِيعِ ٱلْبَهَائِمِ ٱلطَّاهِرَةِ تَأْخُذُ مَعَكَ سَبْعَةً سَبْعَةً ذَكَرًا وَأُنْثَى. وَمِنَ ٱلْبَهَائِمِ ٱلَّتِي لَيْسَتْ بِطَاهِرَةٍ ٱثْنَيْنِ: ذَكَرًا وَأُنْثَى. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","وَمِنْ طُيُورِ ٱلسَّمَاءِ أَيْضًا سَبْعَةً سَبْعَةً: ذَكَرًا وَأُنْثَى. لِٱسْتِبْقَاءِ نَسْلٍ عَلَى وَجْهِ كُلِّ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","لِأَنِّي بَعْدَ سَبْعَةِ أَيَّامٍ أَيْضًا أُمْطِرُ عَلَى ٱلْأَرْضِ أَرْبَعِينَ يَوْمًا وَأَرْبَعِينَ لَيْلَةً. وَأَمْحُو عَنْ وَجْهِ ٱلْأَرْضِ كُلَّ قَائِمٍ عَمِلْتُهُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","فَفَعَلَ نُوحٌ حَسَبَ كُلِّ مَا أَمَرَهُ بِهِ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","وَلَمَّا كَانَ نُوحٌ ٱبْنَ سِتِّ مِئَةِ سَنَةٍ صَارَ طُوفَانُ ٱلْمَاءِ عَلَى ٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","فَدَخَلَ نُوحٌ وَبَنُوهُ وَٱمْرَأَتُهُ وَنِسَاءُ بَنِيهِ مَعَهُ إِلَى ٱلْفُلْكِ مِنْ وَجْهِ مِيَاهِ ٱلطُّوفَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","وَمِنَ ٱلْبَهَائِمِ ٱلطَّاهِرَةِ وَٱلْبَهَائِمِ ٱلَّتِي لَيْسَتْ بِطَاهِرَةٍ، وَمِنَ ٱلطُّيُورِ وَكُلِّ مَا يَدِبُّ عَلَى ٱلْأَرْضِ: ");
INSERT INTO arb_vd_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","دَخَلَ ٱثْنَانِ ٱثْنَانِ إِلَى نُوحٍ إِلَى ٱلْفُلْكِ، ذَكَرًا وَأُنْثَى، كَمَا أَمَرَ ٱللهُ نُوحًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","وَحَدَثَ بَعْدَ ٱلسَّبْعَةِ ٱلْأَيَّامِ أَنَّ مِيَاهَ ٱلطُّوفَانِ صَارَتْ عَلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","فِي سَنَةِ سِتِّ مِئَةٍ مِنْ حَيَاةِ نُوحٍ، فِي ٱلشَّهْرِ ٱلثَّانِي، فِي ٱلْيَوْمِ ٱلسَّابِعَ عَشَرَ مِنَ ٱلشَّهْرِ فِي ذَلِكَ ٱليَوْمِ، ٱنْفَجَرَتْ كُلُّ يَنَابِيعِ ٱلْغَمْرِ ٱلْعَظِيمِ، وَٱنْفَتَحَتْ طَاقَاتُ ٱلسَّمَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","وَكَانَ ٱلْمَطَرُ عَلَى ٱلْأَرْضِ أَرْبَعِينَ يَوْمًا وَأَرْبَعِينَ لَيْلَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","فِي ذَلِكَ ٱلْيَوْمِ عَيْنِهِ دَخَلَ نُوحٌ، وَسَامٌ وَحَامٌ وَيَافَثُ بَنُو نُوحٍ، وَٱمْرَأَةُ نُوحٍ، وَثَلَاثُ نِسَاءِ بَنِيهِ مَعَهُمْ إِلَى ٱلْفُلْكِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","هُمْ وَكُلُّ ٱلْوُحُوشِ كَأَجْنَاسِهَا، وَكُلُّ ٱلْبَهَائِمِ كَأَجْنَاسِهَا، وَكُلُّ ٱلدَّبَّاباتِ ٱلَّتِي تَدِبُّ عَلَى ٱلْأَرْضِ كَأَجْنَاسِهَا، وَكُلُّ ٱلطُّيُورِ كَأَجْنَاسِهَا: كُلُّ عُصْفُورٍ، كُلُّ ذِي جَنَاحٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","وَدَخَلَتْ إِلَى نُوحٍ إِلَى ٱلْفُلْكِ، ٱثْنَيْنِ ٱثْنَيْنِ مِنْ كُلِّ جَسَدٍ فِيهِ رُوحُ حَيَاةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","وَٱلدَّاخِلَاتُ دَخَلَتْ ذَكَرًا وَأُنْثَى، مِنْ كُلِّ ذِي جَسَدٍ، كَمَا أَمَرَهُ ٱللهُ. وَأَغْلَقَ ٱلرَّبُّ عَلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","وَكَانَ ٱلطُّوفَانُ أَرْبَعِينَ يَوْمًا عَلَى ٱلْأَرْضِ. وَتَكَاثَرَتِ ٱلْمِيَاهُ وَرَفَعَتِ ٱلْفُلْكَ، فَٱرْتَفَعَ عَنِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","وَتَعَاظَمَتِ ٱلْمِيَاهُ وَتَكَاثَرَتْ جِدًّا عَلَى ٱلْأَرْضِ، فَكَانَ ٱلْفُلْكُ يَسِيرُ عَلَى وَجْهِ ٱلْمِيَاهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","وَتَعَاظَمَتِ ٱلْمِيَاهُ كَثِيرًا جِدًّا عَلَى ٱلْأَرْضِ، فَتَغَطَّتْ جَمِيعُ ٱلْجِبَالِ ٱلشَّامِخَةِ ٱلَّتِي تَحْتَ كُلِّ ٱلسَّمَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","خَمْسَ عَشَرَةَ ذِرَاعًا فِي ٱلِٱرْتِفَاعِ تَعَاظَمَتِ ٱلْمِيَاهُ، فَتَغَطَّتِ ٱلْجِبَالُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","فَمَاتَ كُلُّ ذِي جَسَدٍ كَانَ يَدِبُّ عَلَى ٱلْأَرْضِ مِنَ ٱلطُّيُورِ وَٱلْبَهَائِمِ وَٱلْوُحُوشِ، وَكُلُّ ٱلزَّحَّافَاتِ ٱلَّتِي كَانَتْ تَزْحَفُ عَلَى ٱلْأَرْضِ، وَجَمِيعُ ٱلنَّاسِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","كُلُّ مَا فِي أَنْفِهِ نَسَمَةُ رُوحِ حَيَاةٍ مِنْ كُلِّ مَا فِي ٱلْيَابِسَةِ مَاتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","فَمَحَا ٱللهُ كُلَّ قَائِمٍ كَانَ عَلَى وَجْهِ ٱلْأَرْضِ: ٱلنَّاسَ، وَٱلْبَهَائِمَ، وَٱلدَّبَّابَاتِ، وَطُيُورَ ٱلسَّمَاءِ. فَٱنْمَحَتْ مِنَ ٱلْأَرْضِ. وَتَبَقَّى نُوحٌ وَٱلَّذِينَ مَعَهُ فِي ٱلْفُلْكِ فَقَطْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","وَتَعَاظَمَتِ ٱلْمِيَاهُ عَلَى ٱلْأَرْضِ مِئَةً وَخَمْسِينَ يَوْمًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ثُمَّ ذَكَرَ ٱللهُ نُوحًا وَكُلَّ ٱلْوُحُوشِ وَكُلَّ ٱلْبَهَائِمِ ٱلَّتِي مَعَهُ فِي ٱلْفُلْكِ. وَأَجَازَ ٱللهُ رِيحًا عَلَى ٱلْأَرْضِ فَهَدَأَتِ ٱلْمِيَاهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","وَٱنْسَدَّتْ يَنَابِيعُ ٱلْغَمْرِ وَطَاقَاتُ ٱلسَّمَاءِ، فَٱمْتَنَعَ ٱلْمَطَرُ مِنَ ٱلسَّمَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","وَرَجَعَتِ ٱلْمِيَاهُ عَنِ ٱلْأَرْضِ رُجُوعًا مُتَوَالِيًا. وَبَعْدَ مِئَةٍ وَخَمْسِينَ يَوْمًا نَقَصَتِ ٱلْمِيَاهُ، ");
INSERT INTO arb_vd_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","وَٱسْتَقَرَّ ٱلْفُلْكُ فِي ٱلشَّهْرِ ٱلسَّابِعِ، فِي ٱلْيَوْمِ ٱلسَّابِعَ عَشَرَ مِنَ ٱلشَّهْرِ، عَلَى جِبَالِ أَرَارَاطَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","وَكَانَتِ ٱلْمِيَاهُ تَنْقُصُ نَقْصًا مُتَوَالِيًا إِلَى ٱلشَّهْرِ ٱلْعَاشِرِ. وَفِي ٱلْعَاشِرِ فِي أَوَّلِ ٱلشَّهْرِ، ظَهَرَتْ رُؤُوسُ ٱلْجِبَالِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","وَحَدَثَ مِنْ بَعْدِ أَرْبَعِينَ يَوْمًا أَنَّ نُوحًا فَتَحَ طَاقَةَ ٱلْفُلْكِ ٱلَّتِي كَانَ قَدْ عَمِلَهَا ");
INSERT INTO arb_vd_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","وَأَرْسَلَ ٱلْغُرَابَ، فَخَرَجَ مُتَرَدِّدًا حَتَّى نَشِفَتِ ٱلْمِيَاهُ عَنِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ثُمَّ أَرْسَلَ ٱلْحَمَامَةَ مِنْ عِنْدِهِ لِيَرَى هَلْ قَلَّتِ ٱلْمِيَاهُ عَنْ وَجْهِ ٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","فَلَمْ تَجِدِ ٱلْحَمَامَةُ مَقَرًّا لِرِجْلِهَا، فَرَجَعَتْ إِلَيْهِ إِلَى ٱلْفُلْكِ لِأَنَّ مِيَاهًا كَانَتْ عَلَى وَجْهِ كُلِّ ٱلْأَرْضِ. فَمَدَّ يَدَهُ وَأَخَذَهَا وَأَدْخَلَهَا عِنْدَهُ إِلَى ٱلْفُلْكِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","فَلَبِثَ أَيْضًا سَبْعَةَ أَيَّامٍ أُخَرَ وَعَادَ فَأَرْسَلَ ٱلْحَمَامَةَ مِنَ ٱلْفُلْكِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","فَأَتَتْ إِلَيْهِ ٱلْحَمَامَةُ عِنْدَ ٱلْمَسَاءِ، وَإِذَا وَرَقَةُ زَيْتُونٍ خَضْرَاءُ فِي فَمِهَا. فَعَلِمَ نُوحٌ أَنَّ ٱلْمِيَاهَ قَدْ قَلَّتْ عَنِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","فَلَبِثَ أَيْضًا سَبْعَةَ أَيَّامٍ أُخَرَ وَأَرْسَلَ ٱلْحَمَامَةَ فَلَمْ تَعُدْ تَرْجِعُ إِلَيْهِ أَيْضًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","وَكَانَ فِي ٱلسَّنَةِ ٱلْوَاحِدَةِ وَٱلسِّتِّ مِئَةٍ، فِي ٱلشَّهْرِ ٱلْأَوَّلِ فِي أَوَّلِ ٱلشَّهْرِ، أَنَّ ٱلْمِيَاهَ نَشِفَتْ عَنِ ٱلْأَرْضِ. فَكَشَفَ نُوحٌ ٱلْغِطَاءَ عَنِ ٱلْفُلْكِ وَنَظَرَ، فَإِذَا وَجْهُ ٱلْأَرْضِ قَدْ نَشِفَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","وَفِي ٱلشَّهْرِ ٱلثَّانِي، فِي ٱلْيَوْمِ ٱلسَّابِعِ وَٱلْعِشْرِينَ مِنَ ٱلشَّهْرِ، جَفَّتِ ٱلْأَرْضُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","وَكَلَّمَ ٱللهُ نُوحًا قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«ٱخْرُجْ مِنَ ٱلْفُلْكِ أَنْتَ وَٱمْرَأَتُكَ وَبَنُوكَ وَنِسَاءُ بَنِيكَ مَعَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","وَكُلَّ ٱلْحَيَوَانَاتِ ٱلَّتِي مَعَكَ مِنْ كُلِّ ذِي جَسَدٍ: ٱلطُّيُورِ، وَٱلْبَهَائِمِ، وَكُلَّ ٱلدَّبَّابَاتِ ٱلَّتِي تَدِبُّ عَلَى ٱلْأَرْضِ، أَخْرِجْهَا مَعَكَ. وَلْتَتَوَالَدْ فِي ٱلْأَرْضِ وَتُثْمِرْ وَتَكْثُرْ عَلَى ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","فَخَرَجَ نُوحٌ وَبَنُوهُ وَٱمْرَأَتُهُ وَنِسَاءُ بَنِيهِ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","وَكُلُّ ٱلْحَيَوَانَاتِ، كُلُّ ٱلدَّبَّابَاتِ، وَكُلُّ ٱلطُّيُورِ، كُلُّ مَا يَدِبُّ عَلَى ٱلْأَرْضِ، كَأَنْوَاعِهَا خَرَجَتْ مِنَ ٱلْفُلْكِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","وَبَنَى نُوحٌ مَذْبَحًا لِلرَّبِّ. وَأَخَذَ مِنْ كُلِّ ٱلْبَهَائِمِ ٱلطَّاهِرَةِ وَمِنْ كُلِّ ٱلطُّيُورِ ٱلطَّاهِرَةِ وَأَصْعَدَ مُحْرَقَاتٍ عَلَى ٱلْمَذْبَحِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","فَتَنَسَّمَ ٱلرَّبُّ رَائِحَةَ ٱلرِّضَا. وَقَالَ ٱلرَّبُّ فِي قَلْبِهِ: «لَا أَعُودُ أَلْعَنُ ٱلْأَرْضَ أَيْضًا مِنْ أَجْلِ ٱلْإِنْسَانِ، لِأَنَّ تَصَوُّرَ قَلْبِ ٱلْإِنْسَانِ شِرِّيرٌ مُنْذُ حَدَاثَتِهِ. وَلَا أَعُودُ أَيْضًا أُمِيتُ كُلَّ حَيٍّ كَمَا فَعَلْتُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","مُدَّةَ كُلِّ أَيَّامِ ٱلْأَرْضِ: زَرْعٌ وَحَصَادٌ، وَبَرْدٌ وَحَرٌّ، وَصَيْفٌ وَشِتَاءٌ، وَنَهَارٌ وَلَيْلٌ، لَا تَزَالُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","وَبَارَكَ ٱللهُ نُوحًا وَبَنِيهِ وَقَالَ لَهُمْ: «أَثْمِرُوا وَٱكْثُرُوا وَٱمْلَأُوا ٱلْأَرْضَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","وَلْتَكُنْ خَشْيَتُكُمْ وَرَهْبَتُكُمْ عَلَى كُلِّ حَيَوَانَاتِ ٱلْأَرْضِ وَكُلِّ طُيُورِ ٱلسَّمَاءِ، مَعَ كُلِّ مَا يَدِبُّ عَلَى ٱلْأَرْضِ، وَكُلِّ أَسْمَاكِ ٱلْبَحْرِ. قَدْ دُفِعَتْ إِلَى أَيْدِيكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","كُلُّ دَابَّةٍ حَيَّةٍ تَكُونُ لَكُمْ طَعَامًا. كَٱلْعُشْبِ ٱلْأَخْضَرِ دَفَعْتُ إِلَيْكُمُ ٱلْجَمِيعَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","غَيْرَ أَنَّ لَحْمًا بِحَيَاتِهِ، دَمِهِ، لَا تَأْكُلُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","وَأَطْلُبُ أَنَا دَمَكُمْ لِأَنْفُسِكُمْ فَقَطْ. مِنْ يَدِ كُلِّ حَيَوَانٍ أَطْلُبُهُ. وَمِنْ يَدِ ٱلْإِنْسَانِ أَطْلُبُ نَفْسَ ٱلْإِنْسَانِ، مِنْ يَدِ ٱلْإِنْسَانِ أَخِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","سَافِكُ دَمِ ٱلْإِنْسَانِ بِٱلْإِنْسَانِ يُسْفَكُ دَمُهُ. لِأَنَّ ٱللهَ عَلَى صُورَتِهِ عَمِلَ ٱلْإِنْسَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","فَأَثْمِرُوا أَنْتُمْ وَٱكْثُرُوا وَتَوَالَدُوا فِي ٱلْأَرْضِ وَتَكَاثَرُوا فِيهَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","وَكَلَّمَ ٱللهُ نُوحًا وَبَنِيهِ مَعهُ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«وَهَا أَنَا مُقِيمٌ مِيثَاقِي مَعَكُمْ وَمَعَ نَسْلِكُمْ مِنْ بَعْدِكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","وَمَعَ كُلِّ ذَوَاتِ ٱلْأَنْفُسِ ٱلْحَيَّةِ ٱلَّتِي مَعَكُمْ: ٱلطُّيُورِ وَٱلْبَهَائِمِ وَكُلِّ وُحُوشِ ٱلْأَرْضِ ٱلَّتِي مَعَكُمْ، مِنْ جَمِيعِ ٱلْخَارِجِينَ مِنَ ٱلْفُلْكِ حَتَّى كُلُّ حَيَوَانِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","أُقِيمُ مِيثَاقِي مَعَكُمْ فَلَا يَنْقَرِضُ كُلُّ ذِي جَسَدٍ أَيْضًا بِمِيَاهِ ٱلطُّوفَانِ. وَلَا يَكُونُ أَيْضًا طُوفَانٌ لِيُخْرِبَ ٱلْأَرْضَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","وَقَالَ ٱللهُ: «هَذِهِ عَلَامَةُ ٱلْمِيثَاقِ ٱلَّذِي أَنَا وَاضِعُهُ بَيْنِي وَبَيْنَكُمْ، وَبَيْنَ كُلِّ ذَوَاتِ ٱلْأَنْفُسِ ٱلْحَيَّةِ ٱلَّتِي مَعَكُمْ إِلَى أَجْيَالِ ٱلدَّهْرِ: ");
INSERT INTO arb_vd_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","وَضَعْتُ قَوْسِي فِي ٱلسَّحَابِ فَتَكُونُ عَلَامَةَ مِيثَاقٍ بَيْنِي وَبَيْنَ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","فَيَكُونُ مَتَى أَنْشُرْ سَحَابًا عَلَى ٱلْأَرْضِ، وَتَظْهَرِ ٱلْقَوْسُ فِي ٱلسَّحَابِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","أَنِّي أَذْكُرُ مِيثَاقِي ٱلَّذِي بَيْنِي وَبَيْنَكُمْ وَبَيْنَ كُلِّ نَفْسٍ حَيَّةٍ فِي كُلِّ جَسَدٍ. فَلَا تَكُونُ أَيْضًا ٱلْمِيَاهُ طُوفَانًا لِتُهْلِكَ كُلَّ ذِي جَسَدٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","فَمَتَى كَانَتِ ٱلْقَوْسُ فِي ٱلسَّحَابِ، أُبْصِرُهَا لِأَذْكُرَ مِيثَاقًا أَبَدِيًّا بَيْنَ ٱللهِ وَبَيْنَ كُلِّ نَفْسٍ حَيَّةٍ فِي كُلِّ جَسَدٍ عَلَى ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","وَقَالَ ٱللهُ لِنُوحٍ: «هَذِهِ عَلَامَةُ ٱلْمِيثَاقِ ٱلَّذِي أَنَا أَقَمْتُهُ بَيْنِي وَبَيْنَ كُلِّ ذِي جَسَدٍ عَلَى ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","وَكَانَ بَنُو نُوحٍ ٱلَّذِينَ خَرَجُوا مِنَ ٱلْفُلْكِ سَامًا وَحَامًا وَيَافَثَ. وَحَامٌ هُوَ أَبُو كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","هَؤُلَاءِ ٱلثَّلَاثَةُ هُمْ بَنُو نُوحٍ. وَمِنْ هَؤُلَاءِ تَشَعَّبَتْ كُلُّ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","وَٱبْتَدَأَ نُوحٌ يَكُونُ فَلَّاحًا وَغَرَسَ كَرْمًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","وَشَرِبَ مِنَ ٱلْخَمْرِ فَسَكِرَ وَتَعَرَّى دَاخِلَ خِبَائِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","فَأَبْصَرَ حَامٌ أَبُو كَنْعَانَ عَوْرَةَ أَبِيهِ، وَأَخْبَرَ أَخَوَيْهِ خَارِجًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","فَأَخَذَ سَامٌ وَيَافَثُ ٱلرِّدَاءَ وَوَضَعَاهُ عَلَى أَكْتَافِهِمَا وَمَشَيَا إِلَى ٱلْوَرَاءِ، وَسَتَرَا عَوْرَةَ أَبِيهِمَا وَوَجْهَاهُمَا إِلَى ٱلْوَرَاءِ. فَلَمْ يُبْصِرَا عَوْرَةَ أَبِيهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","فَلَمَّا ٱسْتَيْقَظَ نُوحٌ مِنْ خَمْرِهِ، عَلِمَ مَا فَعَلَ بِهِ ٱبْنُهُ ٱلصَّغِيرُ، ");
INSERT INTO arb_vd_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","فَقَالَ: «مَلْعُونٌ كَنْعَانُ! عَبْدَ ٱلْعَبِيدِ يَكُونُ لإِخْوَتِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","وَقَالَ: «مُبَارَكٌ ٱلرَّبُّ إِلَهُ سَامٍ. وَلْيَكُنْ كَنْعَانُ عَبْدًا لَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","لِيَفْتَحِ ٱللهُ لِيَافَثَ فَيَسْكُنَ فِي مَسَاكِنِ سَامٍ، وَلْيَكُنْ كَنْعَانُ عَبْدًا لَهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","وَعَاشَ نُوحٌ بَعْدَ ٱلطُّوفَانِ ثَلَاثَ مِئَةٍ وَخَمْسِينَ سَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","فَكَانَتْ كُلُّ أَيَّامِ نُوحٍ تِسْعَ مِئَةٍ وَخَمْسِينَ سَنَةً، وَمَاتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","وَهَذِهِ مَوَالِيدُ بَنِي نُوحٍ: سَامٌ وَحَامٌ وَيَافَثُ. وَوُلِدَ لَهُمْ بَنُونَ بَعْدَ ٱلطُّوفَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","بَنُو يَافَثَ: جُومَرُ وَمَاجُوجُ وَمَادَاي وَيَاوَانُ وَتُوبَالُ وَمَاشِكُ وَتِيرَاسُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","وَبَنُو جُومَرَ: أَشْكَنَازُ وَرِيفَاثُ وَتُوجَرْمَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","وَبَنُو يَاوَانَ: أَلِيشَةُ وَتَرْشِيشُ وَكِتِّيمُ وَدُودَانِيمُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","مِنْ هَؤُلَاءِ تَفَرَّقَتْ جَزَائِرُ ٱلْأُمَمِ بِأَرَاضِيهِمْ، كُلُّ إِنْسَانٍ كَلِسَانِهِ حَسَبَ قَبَائِلِهِمْ بِأُمَمِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","وَبَنُو حَامٍ: كُوشُ وَمِصْرَايِمُ وَفُوطُ وَكَنْعَانُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","وَبَنُو كُوشَ: سَبَا وَحَوِيلَةُ وَسَبْتَةُ وَرَعْمَةُ وَسَبْتَكَا. وَبَنُو رَعْمَةَ: شَبَا وَدَدَانُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","وَكُوشُ وَلَدَ نِمْرُودَ ٱلَّذِي ٱبْتَدَأَ يَكُونُ جَبَّارًا فِي ٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ٱلَّذِي كَانَ جَبَّارَ صَيْدٍ أَمَامَ ٱلرَّبِّ. لِذَلِكَ يُقَالُ: «كَنِمْرُودَ جَبَّارُ صَيْدٍ أَمَامَ ٱلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","وَكَانَ ٱبْتِدَاءُ مَمْلَكَتِهِ بَابِلَ وَأَرَكَ وَأَكَّدَ وَكَلْنَةَ، فِي أَرْضِ شِنْعَارَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","مِنْ تِلْكَ ٱلْأَرْضِ خَرَجَ أَشُّورُ وَبَنَى نِينَوَى وَرَحُوبُوتَ عَيْرَ وَكَالَحَ ");
INSERT INTO arb_vd_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","وَرَسَنَ، بَيْنَ نِينَوَى وَكَالَحَ، هِيَ ٱلْمَدِينَةُ ٱلْكَبِيرَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","وَمِصْرَايِمُ وَلَدَ: لُودِيمَ وَعَنَامِيمَ وَلَهَابِيمَ وَنَفْتُوحِيمَ ");
INSERT INTO arb_vd_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","وَفَتْرُوسِيمَ وَكَسْلُوحِيمَ. ٱلَّذِينَ خَرَجَ مِنْهُمْ فِلِشْتِيمُ وَكَفْتُورِيمُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","وَكَنْعَانُ وَلَدَ: صِيْدُونَ بِكْرَهُ، وَحِثًّا ");
INSERT INTO arb_vd_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","وَٱلْيَبُوسِيَّ وَٱلْأَمُورِيَّ وَٱلْجِرْجَاشِيَّ ");
INSERT INTO arb_vd_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","وَٱلْحِوِّيَّ وَٱلْعَرْقِيَّ وَٱلسِّينِيَّ ");
INSERT INTO arb_vd_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","وَٱلْأَرْوَادِيَّ وَٱلصَّمَارِيَّ وَٱلْحَمَاتِيَّ. وَبَعْدَ ذَلِكَ تَفَرَّقَتْ قَبَائِلُ ٱلْكَنْعَانِيِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","وَكَانَتْ تُخُومُ ٱلْكَنْعَانِيِّ مِنْ صَيْدُونَ، حِينَمَا تَجِيءُ نَحْوَ جَرَارَ إِلَى غَزَّةَ، وَحِينَمَا تَجِيءُ نَحْوَ سَدُومَ وَعَمُورَةَ وَأَدْمَةَ وَصَبُويِيمَ إِلَى لَاشَعَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","هَؤُلَاءِ بَنُو حَامٍ حَسَبَ قَبَائِلِهِمْ كَأَلْسِنَتِهِمْ بِأَرَاضِيهِمْ وَأُمَمِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","وَسَامٌ أَبُو كُلِّ بَنِي عَابِرَ، أَخُو يَافَثَ ٱلْكَبِيرُ، وُلِدَ لَهُ أَيْضًا بَنُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","بَنُو سَامٍ: عِيلَامُ وَأَشُّورُ وَأَرْفَكْشَادُ وَلُودُ وَأَرَامُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","وَبَنُو أَرَامَ: عُوصُ وَحُولُ وَجَاثَرُ وَمَاشُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","وَأَرْفَكْشَادُ وَلَدَ شَالَحَ، وَشَالَحُ وَلَدَ عَابِرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","وَلِعَابِرَ وُلِدَ ٱبْنَانِ: ٱسْمُ ٱلْوَاحِدِ فَالَجُ لِأَنَّ فِي أَيَّامِهِ قُسِمَتِ ٱلْأَرْضُ. وَٱسْمُ أَخِيهِ يَقْطَانُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","وَيَقْطَانُ وَلَدَ: أَلْمُودَادَ وَشَالَفَ وَحَضَرْمَوْتَ وَيَارَحَ ");
INSERT INTO arb_vd_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","وَهَدُورَامَ وَأُوزَالَ وَدِقْلَةَ ");
INSERT INTO arb_vd_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","وَعُوبَالَ وَأَبِيمَايِلَ وَشَبَا ");
INSERT INTO arb_vd_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","وَأُوفِيرَ وَحَوِيلَةَ وَيُوبَابَ. جَمِيعُ هَؤُلَاءِ بَنُو يَقْطَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","وَكَانَ مَسْكَنُهُمْ مِنْ مِيشَا حِينَمَا تَجِيءُ نَحْوَ سَفَارَ جَبَلِ ٱلْمَشْرِقِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","هَؤُلَاءِ بَنُو سَامٍ حَسَبَ قَبَائِلِهِمْ كَأَلْسِنَتِهِمْ بِأَرَاضِيهِمْ حَسَبَ أُمَمِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","هَؤُلَاءِ قَبَائِلُ بَنِي نُوحٍ حَسَبَ مَوَالِيدِهِمْ بِأُمَمِهِمْ. وَمِنْ هَؤُلَاءِ تَفَرَّقَتِ ٱلْأُمَمُ فِي ٱلْأَرْضِ بَعْدَ ٱلطُّوفَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","وَكَانَتِ ٱلْأَرْضُ كُلُّهَا لِسَانًا وَاحِدًا وَلُغَةً وَاحِدَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","وَحَدَثَ فِي ٱرْتِحَالِهِمْ شَرْقًا أَنَّهُمْ وَجَدُوا بُقْعَةً فِي أَرْضِ شِنْعَارَ وَسَكَنُوا هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","وَقَالَ بَعْضُهُمْ لِبَعْضٍ: «هَلُمَّ نَصْنَعُ لِبْنًا وَنَشْوِيهِ شَيًّا». فَكَانَ لَهُمُ ٱللِّبْنُ مَكَانَ ٱلْحَجَرِ، وَكَانَ لَهُمُ ٱلْحُمَرُ مَكَانَ ٱلطِّينِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","وَقَالُوا: «هَلُمَّ نَبْنِ لِأَنْفُسِنَا مَدِينَةً وَبُرْجًا رَأْسُهُ بِٱلسَّمَاءِ. وَنَصْنَعُ لِأَنْفُسِنَا ٱسْمًا لِئَلَّا نَتَبَدَّدَ عَلَى وَجْهِ كُلِّ ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","فَنَزَلَ ٱلرَّبُّ لِيَنْظُرَ ٱلْمَدِينَةَ وَٱلْبُرْجَ ٱللَّذَيْنِ كَانَ بَنُو آدَمَ يَبْنُونَهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","وَقَالَ ٱلرَّبُّ: «هُوَذَا شَعْبٌ وَاحِدٌ وَلِسَانٌ وَاحِدٌ لِجَمِيعِهِمْ، وَهَذَا ٱبْتِدَاؤُهُمْ بِٱلْعَمَلِ. وَٱلْآنَ لَا يَمْتَنِعُ عَلَيْهِمْ كُلُّ مَا يَنْوُونَ أَنْ يَعْمَلُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","هَلُمَّ نَنْزِلْ وَنُبَلْبِلْ هُنَاكَ لِسَانَهُمْ حَتَّى لَا يَسْمَعَ بَعْضُهُمْ لِسَانَ بَعْضٍ». ");
INSERT INTO arb_vd_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","فَبَدَّدَهُمُ ٱلرَّبُّ مِنْ هُنَاكَ عَلَى وَجْهِ كُلِّ ٱلْأَرْضِ، فَكَفُّوا عَنْ بُنْيَانِ ٱلْمَدِينَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","لِذَلِكَ دُعِيَ ٱسْمُهَا «بَابِلَ» لِأَنَّ ٱلرَّبَّ هُنَاكَ بَلْبَلَ لِسَانَ كُلِّ ٱلْأَرْضِ. وَمِنْ هُنَاكَ بَدَّدَهُمُ ٱلرَّبُّ عَلَى وَجْهِ كُلِّ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","هَذِهِ مَوَالِيدُ سَامٍ: لَمَّا كَانَ سَامٌ ٱبْنَ مِئَةِ سَنَةٍ وَلَدَ أَرْفَكْشَادَ، بَعْدَ ٱلطُّوفَانِ بِسَنَتَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","وَعَاشَ سَامٌ بَعْدَ مَا وَلَدَ أَرْفَكْشَادَ خَمْسَ مِئَةِ سَنَةٍ، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","وَعَاشَ أَرْفَكْشَادُ خَمْسًا وَثَلَاثِينَ سَنَةً وَوَلَدَ شَالَحَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","وَعَاشَ أَرْفَكْشَادُ بَعْدَ مَا وَلَدَ شَالَحَ أَرْبَعَ مِئَةٍ وَثَلَاثَ سِنِينَ، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","وَعَاشَ شَالَحُ ثَلَاثِينَ سَنَةً وَوَلَدَ عَابِرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","وَعَاشَ شَالَحُ بَعْدَ مَا وَلَدَ عَابِرَ أَرْبَعَ مِئَةٍ وَثَلَاثَ سِنِينَ، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","وَعَاشَ عَابِرُ أَرْبَعًا وَثَلَاثِينَ سَنَةً وَوَلَدَ فَالَجَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","وَعَاشَ عَابِرُ بَعْدَ مَا وَلَدَ فَالَجَ أَرْبَعَ مِئَةٍ وَثَلَاثِينَ سَنَةً، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","وَعَاشَ فَالَجُ ثَلَاثِينَ سَنَةً وَوَلَدَ رَعُوَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","وَعَاشَ فَالَجُ بَعْدَ مَا وَلَدَ رَعُوَ مِئَتَيْنِ وَتِسْعَ سِنِينَ، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","وَعَاشَ رَعُو ٱثْنَتَيْنِ وَثَلَاثِينَ سَنَةً وَوَلَدَ سَرُوجَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","وَعَاشَ رَعُو بَعْدَ مَا وَلَدَ سَرُوجَ مِئَتَيْنِ وَسَبْعَ سِنِينَ، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","وَعَاشَ سَرُوجُ ثَلَاثِينَ سَنَةً وَوَلَدَ نَاحُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","وَعَاشَ سَرُوجُ بَعْدَ مَا وَلَدَ نَاحُورَ مِئَتَيْ سَنَةٍ، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","وَعَاشَ نَاحُورُ تِسْعًا وَعِشْرِينَ سَنَةً وَوَلَدَ تَارَحَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","وَعَاشَ نَاحُورُ بَعْدَ مَا وَلَدَ تَارَحَ مِئَةً وَتِسْعَ عَشَرَةَ سَنَةً، وَوَلَدَ بَنِينَ وَبَنَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","وَعَاشَ تَارَحُ سَبْعِينَ سَنَةً، وَوَلَدَ أَبْرَامَ وَنَاحُورَ وَهَارَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","وَهَذِهِ مَوَالِيدُ تَارَحَ: وَلَدَ تَارَحُ أَبْرَامَ وَنَاحُورَ وَهَارَانَ. وَوَلَدَ هَارَانُ لُوطًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","وَمَاتَ هَارَانُ قَبْلَ تَارَحَ أَبِيهِ فِي أَرْضِ مِيلَادِهِ فِي أُورِ ٱلْكَلْدَانِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","وَٱتَّخَذَ أَبْرَامُ وَنَاحُورُ لِأَنْفُسِهِمَا ٱمْرَأَتَيْنِ: ٱسْمُ ٱمْرَأَةِ أَبْرَامَ سَارَايُ، وَٱسْمُ ٱمْرَأَةِ نَاحُورَ مِلْكَةُ بِنْتُ هَارَانَ، أَبِي مِلْكَةَ وَأَبِي يِسْكَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","وَكَانَتْ سَارَايُ عَاقِرًا لَيْسَ لَهَا وَلَدٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","وَأَخَذَ تَارَحُ أَبْرَامَ ٱبْنَهُ، وَلُوطًا بْنَ هَارَانَ، ٱبْنَ ٱبْنِهِ، وَسَارَايَ كَنَّتَهُ ٱمْرَأَةَ أَبْرَامَ ٱبْنِهِ، فَخَرَجُوا مَعًا مِنْ أُورِ ٱلْكَلْدَانِيِّينَ لِيَذْهَبُوا إِلَى أَرْضِ كَنْعَانَ. فَأَتَوْا إِلَى حَارَانَ وَأَقَامُوا هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","وَكَانَتْ أَيَّامُ تَارَحَ مِئَتَيْنِ وَخَمْسَ سِنِينَ. وَمَاتَ تَارَحُ فِي حَارَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","وَقَالَ ٱلرَّبُّ لِأَبْرَامَ: «ٱذْهَبْ مِنْ أَرْضِكَ وَمِنْ عَشِيرَتِكَ وَمِنْ بَيْتِ أَبِيكَ إِلَى ٱلْأَرْضِ ٱلَّتِي أُرِيكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","فَأَجْعَلَكَ أُمَّةً عَظِيمَةً وَأُبَارِكَكَ وَأُعَظِّمَ ٱسْمَكَ، وَتَكُونَ بَرَكَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","وَأُبَارِكُ مُبَارِكِيكَ، وَلَاعِنَكَ أَلْعَنُهُ. وَتَتَبَارَكُ فِيكَ جَمِيعُ قَبَائِلِ ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","فَذَهَبَ أَبْرَامُ كَمَا قَالَ لَهُ ٱلرَّبُّ وَذَهَبَ مَعَهُ لُوطٌ. وَكَانَ أَبْرَامُ ٱبْنَ خَمْسٍ وَسَبْعِينَ سَنَةً لَمَّا خَرَجَ مِنْ حَارَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","فَأَخَذَ أَبْرَامُ سَارَايَ ٱمْرَأَتَهُ، وَلُوطًا ٱبْنَ أَخِيهِ، وَكُلَّ مُقْتَنَيَاتِهِمَا ٱلَّتِي ٱقْتَنَيَا وَٱلنُّفُوسَ ٱلَّتِي ٱمْتَلَكَا فِي حَارَانَ. وَخَرَجُوا لِيَذْهَبُوا إِلَى أَرْضِ كَنْعَانَ. فَأَتَوْا إِلَى أَرْضِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","وَٱجْتَازَ أَبْرَامُ فِي ٱلْأَرْضِ إِلَى مَكَانِ شَكِيمَ إِلَى بَلُّوطَةِ مُورَةَ. وَكَانَ ٱلْكَنْعَانِيُّونَ حِينَئِذٍ فِي ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","وَظَهَرَ ٱلرَّبُّ لِأَبْرَامَ وَقَالَ: «لِنَسْلِكَ أُعْطِي هَذِهِ ٱلْأَرْضَ». فَبَنَى هُنَاكَ مَذْبَحًا لِلرَّبِّ ٱلَّذِي ظَهَرَ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ثُمَّ نَقَلَ مِنْ هُنَاكَ إِلَى ٱلْجَبَلِ شَرْقِيَّ بَيْتِ إِيلٍ وَنَصَبَ خَيْمَتَهُ. وَلَهُ بَيْتُ إِيلَ مِنَ ٱلْمَغْرِبِ وَعَايُ مِنَ ٱلْمَشْرِقِ. فَبَنَى هُنَاكَ مَذْبَحًا لِلرَّبِّ وَدَعَا بِٱسْمِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ثُمَّ ٱرْتَحَلَ أَبْرَامُ ٱرْتِحَالًا مُتَوَالِيًا نَحْوَ ٱلْجَنُوبِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","وَحَدَثَ جُوعٌ فِي ٱلْأَرْضِ، فَٱنْحَدَرَ أَبْرَامُ إِلَى مِصْرَ لِيَتَغَرَّبَ هُنَاكَ، لِأَنَّ ٱلْجُوعَ فِي ٱلْأَرْضِ كَانَ شَدِيدًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","وَحَدَثَ لَمَّا قَرُبَ أَنْ يَدْخُلَ مِصْرَ أَنَّهُ قَالَ لِسَارَايَ ٱمْرَأَتِهِ: «إِنِّي قَدْ عَلِمْتُ أَنَّكِ ٱمْرَأَةٌ حَسَنَةُ ٱلْمَنْظَرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","فَيَكُونُ إِذَا رَآكِ ٱلْمِصْرِيُّونَ أَنَّهُمْ يَقُولُونَ: هَذِهِ ٱمْرَأَتُهُ. فَيَقْتُلُونَنِي وَيَسْتَبْقُونَكِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","قُولِي إِنَّكِ أُخْتِي، لِيَكُونَ لِي خَيْرٌ بِسَبَبِكِ وَتَحْيَا نَفْسِي مِنْ أَجْلِكِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","فَحَدَثَ لَمَّا دَخَلَ أَبْرَامُ إِلَى مِصْرَ أَنَّ ٱلْمِصْرِيِّينَ رَأَوْا ٱلْمَرْأَةَ أَنَّهَا حَسَنَةٌ جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","وَرَآهَا رُؤَسَاءُ فِرْعَوْنَ وَمَدَحُوهَا لَدَى فِرْعَوْنَ، فَأُخِذَتِ ٱلْمَرْأَةُ إِلَى بَيْتِ فِرْعَوْنَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","فَصَنَعَ إِلَى أَبْرَامَ خَيْرًا بِسَبَبِهَا، وَصَارَ لَهُ غَنَمٌ وَبَقَرٌ وَحَمِيرٌ وَعَبِيدٌ وَإِمَاءٌ وَأُتُنٌ وَجِمَالٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","فَضَرَبَ ٱلرَّبُّ فِرْعَوْنَ وَبَيْتَهُ ضَرَبَاتٍ عَظِيمَةً بِسَبَبِ سَارَايَ ٱمْرَأَةِ أَبْرَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","فَدَعَا فِرْعَوْنُ أَبْرَامَ وَقَالَ: «مَا هَذَا ٱلَّذِي صَنَعْتَ بِي؟ لِمَاذَا لَمْ تُخْبِرْنِي أَنَّهَا ٱمْرَأَتُكَ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","لِمَاذَا قُلْتَ: هِيَ أُخْتِي، حَتَّى أَخَذْتُهَا لِي لِتَكُونَ زَوْجَتِي؟ وَٱلْآنَ هُوَذَا ٱمْرَأَتُكَ! خُذْهَا وَٱذْهَبْ!». ");
INSERT INTO arb_vd_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","فَأَوْصَى عَلَيْهِ فِرْعَوْنُ رِجَالًا فَشَيَّعُوهُ وَٱمْرَأَتَهُ وَكُلَّ مَا كَانَ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","فَصَعِدَ أَبْرَامُ مِنْ مِصْرَ هُوَ وَٱمْرَأَتُهُ وَكُلُّ مَا كَانَ لَهُ، وَلُوطٌ مَعَهُ إِلَى ٱلْجَنُوبِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","وَكَانَ أَبْرَامُ غَنِيًّا جِدًّا فِي ٱلْمَوَاشِي وَٱلْفِضَّةِ وَٱلذَّهَبِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","وَسَارَ فِي رِحْلَاتِهِ مِنَ ٱلْجَنُوبِ إِلَى بَيْتِ إِيلَ، إِلَى ٱلْمَكَانِ ٱلَّذِي كَانَتْ خَيْمَتُهُ فِيهِ فِي ٱلْبَدَاءَةِ، بَيْنَ بَيْتِ إِيلَ وَعَايَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","إِلَى مَكَانِ ٱلْمَذْبَحِ ٱلَّذِي عَمِلَهُ هُنَاكَ أَوَّلًا. وَدَعَا هُنَاكَ أَبْرَامُ بِٱسْمِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","وَلُوطٌ ٱلسَّائِرُ مَعَ أَبْرَامَ، كَانَ لَهُ أَيْضًا غَنَمٌ وَبَقَرٌ وَخِيَامٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","وَلَمْ تَحْتَمِلْهُمَا ٱلْأَرْضُ أَنْ يَسْكُنَا مَعًا، إِذْ كَانَتْ أَمْلَاكُهُمَا كَثِيرَةً، فَلَمْ يَقْدِرَا أَنْ يَسْكُنَا مَعًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","فَحَدَثَتْ مُخَاصَمَةٌ بَيْنَ رُعَاةِ مَوَاشِي أَبْرَامَ وَرُعَاةِ مَوَاشِي لُوطٍ. وَكَانَ ٱلْكَنْعَانِيُّونَ وَٱلْفَرِزِّيُّونَ حِينَئِذٍ سَاكِنِينَ فِي ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","فَقَالَ أَبْرَامُ لِلُوطٍ: «لَا تَكُنْ مُخَاصَمَةٌ بَيْنِي وَبَيْنَكَ، وَبَيْنَ رُعَاتِي وَرُعَاتِكَ، لِأَنَّنَا نَحْنُ أَخَوَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","أَلَيْسَتْ كُلُّ ٱلْأَرْضِ أَمَامَكَ؟ ٱعْتَزِلْ عَنِّي. إِنْ ذَهَبْتَ شِمَالًا فَأَنَا يَمِينًا، وَإِنْ يَمِينًا فَأَنَا شِمَالًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","فَرَفَعَ لُوطٌ عَيْنَيْهِ وَرَأَى كُلَّ دَائِرَةِ ٱلْأُرْدُنِّ أَنَّ جَمِيعَهَا سَقْيٌ، قَبْلَمَا أَخْرَبَ ٱلرَّبُّ سَدُومَ وَعَمُورَةَ، كَجَنَّةِ ٱلرَّبِّ، كَأَرْضِ مِصْرَ. حِينَمَا تَجِيءُ إِلَى صُوغَرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","فَٱخْتَارَ لُوطٌ لِنَفْسِهِ كُلَّ دَائِرَةِ ٱلْأُرْدُنِّ، وَٱرْتَحَلَ لُوطٌ شَرْقًا. فَٱعْتَزَلَ ٱلْوَاحِدُ عَنِ ٱلْآخَرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","أَبْرَامُ سَكَنَ فِي أَرْضِ كَنْعَانَ، وَلُوطٌ سَكَنَ فِي مُدُنِ ٱلدَّائِرَةِ، وَنَقَلَ خِيَامَهُ إِلَى سَدُومَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","وَكَانَ أَهْلُ سَدُومَ أَشْرَارًا وَخُطَاةً لَدَى ٱلرَّبِّ جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","وَقَالَ ٱلرَّبُّ لِأَبْرَامَ، بَعْدَ ٱعْتِزَالِ لُوطٍ عَنْهُ: «ٱرْفَعْ عَيْنَيْكَ وَٱنْظُرْ مِنَ ٱلْمَوْضِعِ ٱلَّذِي أَنْتَ فِيهِ شِمَالًا وَجَنُوبًا وَشَرْقًا وَغَرْبًا، ");
INSERT INTO arb_vd_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","لِأَنَّ جَمِيعَ ٱلْأَرْضِ ٱلَّتِي أَنْتَ تَرَى لَكَ أُعْطِيهَا وَلِنَسْلِكَ إِلَى ٱلْأَبَدِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","وَأَجْعَلُ نَسْلَكَ كَتُرَابِ ٱلْأَرْضِ، حَتَّى إِذَا ٱسْتَطَاعَ أَحَدٌ أَنْ يَعُدَّ تُرَابَ ٱلْأَرْضِ فَنَسْلُكَ أَيْضًا يُعَدُّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","قُمِ ٱمْشِ فِي ٱلْأَرْضِ طُولَهَا وَعَرْضَهَا، لِأَنِّي لَكَ أُعْطِيهَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","فَنَقَلَ أَبْرَامُ خِيَامَهُ وَأَتَى وَأَقَامَ عِنْدَ بَلُّوطَاتِ مَمْرَا ٱلَّتِي فِي حَبْرُونَ، وَبَنَى هُنَاكَ مَذْبَحًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","وَحَدَثَ فِي أَيَّامِ أَمْرَافَلَ مَلِكِ شِنْعَارَ، وَأَرْيُوكَ مَلِكِ أَلَّاسَارَ، وَكَدَرْلَعَوْمَرَ مَلِكِ عِيلَامَ، وَتِدْعَالَ مَلِكِ جُويِيمَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","أَنَّ هَؤُلَاءِ صَنَعُوا حَرْبًا مَعَ بَارَعَ مَلِكِ سَدُومَ، وَبِرْشَاعَ مَلِكِ عَمُورَةَ، وَشِنْآبَ مَلِكِ أَدْمَةَ، وَشِمْئِيبَرَ مَلِكِ صَبُويِيمَ، وَمَلِكِ بَالَعَ ٱلَّتِي هِيَ صُوغَرُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","جَمِيعُ هَؤُلَاءِ ٱجْتَمَعُوا مُتَعَاهِدِينَ إِلَى عُمْقِ ٱلسِّدِّيمِ ٱلَّذِي هُوَ بَحْرُ ٱلْمِلْحِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","اِثْنَتَيْ عَشَرَةَ سَنَةً ٱسْتُعْبِدُوا لِكَدَرْلَعَوْمَرَ، وَٱلسَّنَةَ ٱلثَّالِثَةَ عَشَرَةَ عَصَوْا عَلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","وَفِي ٱلسَّنَةِ ٱلرَّابِعَةَ عَشَرْةَ أَتَى كَدَرْلَعَوْمَرُ وَٱلْمُلُوكُ ٱلَّذِينَ مَعَهُ وَضَرَبُوا ٱلرَّفَائِيِّينَ فِي عَشْتَارُوثَ قَرْنَايِمَ، وَٱلزُّوزِيِّينَ فِي هَامَ، وَٱلْإِيمِيِّينَ فِي شَوَى قَرْيَتَايِمَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","وَٱلْحُورِيِّينَ فِي جَبَلِهِمْ سَعِيرَ إِلَى بُطْمَةِ فَارَانَ ٱلَّتِي عِنْدَ ٱلْبَرِّيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ثُمَّ رَجَعُوا وَجَاءُوا إِلَى عَيْنِ مِشْفَاطَ ٱلَّتِي هِيَ قَادِشُ. وَضَرَبُوا كُلَّ بِلَادِ ٱلْعَمَالِقَةِ، وَأَيْضًا ٱلْأَمُورِيِّينَ ٱلسَّاكِنِينَ فِي حَصُّونَ تَامَارَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","فَخَرَجَ مَلِكُ سَدُومَ، وَمَلِكُ عَمُورَةَ، وَمَلِكُ أَدْمَةَ، وَمَلِكُ صَبُويِيمَ، وَمَلِكُ بَالَعَ، ٱلَّتِي هِيَ صُوغَرُ، وَنَظَمُوا حَرْبًا مَعَهُمْ فِي عُمْقِ ٱلسِّدِّيمِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","مَعَ كَدَرْلَعَوْمَرَ مَلِكِ عِيلَامَ، وَتِدْعَالَ مَلِكِ جُويِيمَ، وَأَمْرَافَلَ مَلِكِ شِنْعَارَ، وَأَرْيُوكَ مَلِكِ أَلَّاسَارَ. أَرْبَعَةُ مُلُوكٍ مَعَ خَمْسَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","وَعُمْقُ ٱلسِّدِّيمِ كَانَ فِيهِ آبَارُ حُمَرٍ كَثِيرَةٌ. فَهَرَبَ مَلِكَا سَدُومَ وَعَمُورَةَ وَسَقَطَا هُنَاكَ، وَٱلْبَاقُونَ هَرَبُوا إِلَى ٱلْجَبَلِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","فَأَخَذُوا جَمِيعَ أَمْلَاكِ سَدُومَ وَعَمُورَةَ وَجَمِيعَ أَطْعِمَتِهِمْ وَمَضَوْا. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","وَأَخَذُوا لُوطًا ٱبْنَ أَخِي أَبْرَامَ وَأَمْلَاكَهُ وَمَضَوْا، إِذْ كَانَ سَاكِنًا فِي سَدُومَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","فَأَتَى مَنْ نَجَا وَأَخْبَرَ أَبْرَامَ ٱلْعِبْرَانِيَّ. وَكَانَ سَاكِنًا عِنْدَ بَلُّوطَاتِ مَمْرَا ٱلْأَمُورِيِّ، أَخِي أَشْكُولَ وَأَخِي عَانِرَ. وَكَانُوا أَصْحَابَ عَهْدٍ مَعَ أَبْرَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","فَلَمَّا سَمِعَ أَبْرَامُ، أَنَّ أَخَاهُ سُبِيَ جَرَّ غِلْمَانَهُ ٱلْمُتَمَرِّنِينَ، وِلْدَانَ بَيْتِهِ، ثَلَاثَ مِئَةٍ وَثَمَانِيَةَ عَشَرَ، وَتَبِعَهُمْ إِلَى دَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","وَٱنْقَسَمَ عَلَيْهِمْ لَيْلًا هُوَ وَعَبِيدُهُ فَكَسَّرَهُمْ وَتَبِعَهُمْ إِلَى حُوبَةَ ٱلَّتِي عَنْ شِمَالِ دِمَشْقَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","وَٱسْتَرْجَعَ كُلَّ ٱلْأَمْلَاكِ، وَٱسْتَرْجَعَ لُوطًا أَخَاهُ أَيْضًا وَأَمْلَاكَهُ، وَٱلنِّسَاءَ أَيْضًا وَٱلشَّعْبَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","فَخَرَجَ مَلِكُ سَدُومَ لِٱسْتِقْبَالِهِ، بَعْدَ رُجُوعِهِ مِنْ كَسْرَةِ كَدَرْلَعَوْمَرَ وَٱلْمُلُوكِ ٱلَّذِينَ مَعَهُ إِلَى عُمْقِ شَوَى، ٱلَّذِي هُوَ عُمْقُ ٱلْمَلِكِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","وَمَلْكِي صَادِقُ، مَلِكُ شَالِيمَ، أَخْرَجَ خُبْزًا وَخَمْرًا. وَكَانَ كَاهِنًا لِلهِ ٱلْعَلِيِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","وَبَارَكَهُ وَقَالَ: «مُبَارَكٌ أَبْرَامُ مِنَ ٱللهِ ٱلْعَلِيِّ مَالِكِ ٱلسَّمَاوَاتِ وَٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","وَمُبَارَكٌ ٱللهُ ٱلْعَلِيُّ ٱلَّذِي أَسْلَمَ أَعْدَاءَكَ فِي يَدِكَ». فَأَعْطَاهُ عُشْرًا مِنْ كُلِّ شَيْءٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","وَقَالَ مَلِكُ سَدُومَ لِأَبْرَامَ: «أَعْطِنِي ٱلنُّفُوسَ، وَأَمَّا ٱلْأَمْلَاكَ فَخُذْهَا لِنَفْسِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","فَقَالَ أَبْرَامُ لِمَلِكِ سَدُومَ: «رَفَعْتُ يَدِي إِلَى ٱلرَّبِّ ٱلْإِلَهِ ٱلْعَلِيِّ مَالِكِ ٱلسَّمَاءِ وَٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","لَا آخُذَنَّ لَا خَيْطًا وَلَا شِرَاكَ نَعْلٍ وَلَا مِنْ كُلِّ مَا هُوَ لَكَ، فَلَا تَقُولُ: أَنَا أَغْنَيْتُ أَبْرَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","لَيْسَ لِي غَيْرُ ٱلَّذِي أَكَلَهُ ٱلْغِلْمَانُ، وَأَمَّا نَصِيبُ ٱلرِّجَالِ ٱلَّذِينَ ذَهَبُوا مَعِي: عَانِرَ وَأَشْكُولَ وَمَمْرَا، فَهُمْ يَأْخُذُونَ نَصِيبَهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","بَعْدَ هَذِهِ ٱلْأُمُورِ صَارَ كَلَامُ ٱلرَّبِّ إِلَى أَبْرَامَ فِي ٱلرُّؤْيَا قَائِلًا: «لَا تَخَفْ يَا أَبْرَامُ. أَنَا تُرْسٌ لَكَ. أَجْرُكَ كَثِيرٌ جِدًّا». ");
INSERT INTO arb_vd_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","فَقَالَ أَبْرَامُ: «أَيُّهَا ٱلسَّيِّدُ ٱلرَّبُّ، مَاذَا تُعْطِينِي وَأَنَا مَاضٍ عَقِيمًا، وَمَالِكُ بَيْتِي هُوَ أَلِيعَازَرُ ٱلدِّمَشْقِيُّ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","وَقَالَ أَبْرَامُ أَيْضًا: «إِنَّكَ لَمْ تُعْطِنِي نَسْلًا، وَهُوَذَا ٱبْنُ بَيْتِي وَارِثٌ لِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","فَإِذَا كَلَامُ ٱلرَّبِّ إِلَيْهِ قَائِلًا: «لَا يَرِثُكَ هَذَا، بَلِ ٱلَّذِي يَخْرُجُ مِنْ أَحْشَائِكَ هُوَ يَرِثُكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ثُمَّ أَخْرَجَهُ إِلَى خَارِجٍ وَقَالَ: «ٱنْظُرْ إِلَى ٱلسَّمَاءِ وَعُدَّ ٱلنُّجُومَ إِنِ ٱسْتَطَعْتَ أَنْ تَعُدَّهَا». وَقَالَ لَهُ: «هَكَذَا يَكُونُ نَسْلُكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","فَآمَنَ بِٱلرَّبِّ فَحَسِبَهُ لَهُ بِرًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","وَقَالَ لَهُ: «أَنَا ٱلرَّبُّ ٱلَّذِي أَخْرَجَكَ مِنْ أُورِ ٱلْكَلْدَانِيِّينَ لِيُعْطِيَكَ هَذِهِ ٱلْأَرْضَ لِتَرِثَهَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","فَقَالَ: «أَيُّهَا ٱلسَّيِّدُ ٱلرَّبُّ، بِمَاذَا أَعْلَمُ أَنِّي أَرِثُهَا؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","فَقَالَ لَهُ: «خُذْ لِي عِجْلَةً ثُلَاثِيَّةً، وَعَنْزَةً ثُلَاثِيَّةً، وَكَبْشًا ثُلَاثِيًّا، وَيَمَامَةً وَحَمَامَةً». ");
INSERT INTO arb_vd_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","فَأَخَذَ هَذِهِ كُلَّهَا وَشَقَّهَا مِنَ ٱلْوَسَطِ، وَجَعَلَ شِقَّ كُلِّ وَاحِدٍ مُقَابِلَ صَاحِبِهِ. وَأَمَّا ٱلطَّيْرُ فَلَمْ يَشُقَّهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","فَنَزَلَتِ ٱلْجَوَارِحُ عَلَى ٱلْجُثَثِ، وَكَانَ أَبْرَامُ يَزْجُرُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","وَلَمَّا صَارَتِ ٱلشَّمْسُ إِلَى ٱلْمَغِيبِ، وَقَعَ عَلَى أَبْرَامَ سُبَاتٌ، وَإِذَا رُعْبَةٌ مُظْلِمَةٌ عَظِيمَةٌ وَاقِعَةٌ عَلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","فَقَالَ لِأَبْرَامَ: «ٱعْلَمْ يَقِينًا أَنَّ نَسْلَكَ سَيَكُونُ غَرِيبًا فِي أَرْضٍ لَيْسَتْ لَهُمْ، وَيُسْتَعْبَدُونَ لَهُمْ. فَيُذِلُّونَهُمْ أَرْبَعَ مِئَةِ سَنَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ثُمَّ ٱلْأُمَّةُ ٱلَّتِي يُسْتَعْبَدُونَ لَهَا أَنَا أَدِينُهَا، وَبَعْدَ ذَلِكَ يَخْرُجُونَ بِأَمْلَاكٍ جَزِيلَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","وَأَمَّا أَنْتَ فَتَمْضِي إِلَى آبَائِكَ بِسَلَامٍ وَتُدْفَنُ بِشَيْبَةٍ صَالِحَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","وَفِي ٱلْجِيلِ ٱلرَّابِعِ يَرْجِعُونَ إِلَى هَهُنَا، لِأَنَّ ذَنْبَ ٱلْأَمُورِيِّينَ لَيْسَ إِلَى ٱلْآنَ كَامِلًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ثُمَّ غَابَتِ ٱلشَّمْسُ فَصَارَتِ ٱلْعَتَمَةُ، وَإِذَا تَنُّورُ دُخَانٍ وَمِصْبَاحُ نَارٍ يَجُوزُ بَيْنَ تِلْكَ ٱلْقِطَعِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","فِي ذَلِكَ ٱلْيَوْمِ قَطَعَ ٱلرَّبُّ مَعَ أَبْرَامَ مِيثَاقًا قَائِلًا: «لِنَسْلِكَ أُعْطِي هَذِهِ ٱلْأَرْضَ، مِنْ نَهْرِ مِصْرَ إِلَى ٱلنَّهْرِ ٱلْكَبِيرِ، نَهْرِ ٱلْفُرَاتِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ٱلْقِينِيِّينَ وَٱلْقَنِزِّيِّينَ وَٱلْقَدْمُونِيِّينَ ");
INSERT INTO arb_vd_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","وَٱلْحِثِّيِّينَ وَٱلْفَرِزِّيِّينَ وَٱلرَّفَائِيِّينَ ");
INSERT INTO arb_vd_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","وَٱلْأَمُورِيِّينَ وَٱلْكَنْعَانِيِّينَ وَٱلْجِرْجَاشِيِّينَ وَٱلْيَبُوسِيِّينَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","وَأَمَّا سَارَايُ ٱمْرَأَةُ أَبْرَامَ فَلَمْ تَلِدْ لَهُ. وَكَانَتْ لَهَا جَارِيَةٌ مِصْرِيَّةٌ ٱسْمُهَا هَاجَرُ، ");
INSERT INTO arb_vd_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","فَقَالَتْ سَارَايُ لِأَبْرَامَ: «هُوَذَا ٱلرَّبُّ قَدْ أَمْسَكَنِي عَنِ ٱلْوِلَادَةِ. ٱدْخُلْ عَلَى جَارِيَتِي لَعَلِّي أُرْزَقُ مِنْهَا بَنِينَ». فَسَمِعَ أَبْرَامُ لِقَوْلِ سَارَايَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","فَأَخَذَتْ سَارَايُ ٱمْرَأَةُ أَبْرَامَ هَاجَرَ ٱلْمِصْرِيَّةَ جَارِيَتَهَا، مِنْ بَعْدِ عَشَرِ سِنِينَ لإِقَامَةِ أَبْرَامَ فِي أَرْضِ كَنْعَانَ، وَأَعْطَتْهَا لِأَبْرَامَ رَجُلِهَا زَوْجَةً لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","فَدَخَلَ عَلَى هَاجَرَ فَحَبِلَتْ. وَلَمَّا رَأَتْ أَنَّهَا حَبِلَتْ صَغُرَتْ مَوْلَاتُهَا فِي عَيْنَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","فَقَالَتْ سَارَايُ لِأَبْرَامَ: «ظُلْمِي عَلَيْكَ! أَنَا دَفَعْتُ جَارِيَتِي إِلَى حِضْنِكَ، فَلَمَّا رَأَتْ أَنَّهَا حَبِلَتْ صَغُرْتُ فِي عَيْنَيْهَا. يَقْضِي ٱلرَّبُّ بَيْنِي وَبَيْنَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","فَقَالَ أَبْرَامُ لِسَارَايَ: «هُوَذَا جَارِيَتُكِ فِي يَدِكِ. ٱفْعَلِي بِهَا مَا يَحْسُنُ فِي عَيْنَيْكِ». فَأَذَلَّتْهَا سَارَايُ، فَهَرَبَتْ مِنْ وَجْهِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","فَوَجَدَهَا مَلَاكُ ٱلرَّبِّ عَلَى عَيْنِ ٱلْمَاءِ فِي ٱلْبَرِّيَّةِ، عَلَى ٱلْعَيْنِ ٱلَّتِي فِي طَرِيقِ شُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","وَقَالَ: «يَا هَاجَرُ جَارِيَةَ سَارَايَ، مِنْ أَيْنَ أَتَيْتِ؟ وَإِلَى أَيْنَ تَذْهَبِينَ؟». فَقَالَتْ: «أَنَا هَارِبَةٌ مِنْ وَجْهِ مَوْلَاتِي سَارَايَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","فَقَالَ لَهَا مَلَاكُ ٱلرَّبِّ: «ٱرْجِعِي إِلَى مَوْلَاتِكِ وَٱخْضَعِي تَحْتَ يَدَيْهَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","وَقَالَ لَهَا مَلَاكُ ٱلرَّبِّ: «تَكْثِيرًا أُكَثِّرُ نَسْلَكِ فَلَا يُعَدُّ مِنَ ٱلْكَثْرَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","وَقَالَ لَهَا مَلَاكُ ٱلرَّبِّ: «هَا أَنْتِ حُبْلَى، فَتَلِدِينَ ٱبْنًا وَتَدْعِينَ ٱسْمَهُ إِسْمَاعِيلَ، لِأَنَّ ٱلرَّبَّ قَدْ سَمِعَ لِمَذَلَّتِكِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","وَإِنَّهُ يَكُونُ إِنْسَانًا وَحْشِيًّا، يَدُهُ عَلَى كُلِّ وَاحِدٍ، وَيَدُ كُلِّ وَاحِدٍ عَلَيْهِ، وَأَمَامَ جَمِيعِ إِخْوَتِهِ يَسْكُنُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","فَدَعَتِ ٱسْمَ ٱلرَّبِّ ٱلَّذِي تَكَلَّمَ مَعَهَا: «أَنْتَ إِيلُ رُئِي». لِأَنَّهَا قَالَتْ: «أَهَهُنَا أَيْضًا رَأَيْتُ بَعْدَ رُؤْيَةٍ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","لِذَلِكَ دُعِيَتِ ٱلْبِئْرُ «بِئْرَ لَحَيْ رُئِي». هَا هِيَ بَيْنَ قَادِشَ وَبَارَدَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","فَوَلَدَتْ هَاجَرُ لِأَبْرَامَ ٱبْنًا. وَدَعَا أَبْرَامُ ٱسْمَ ٱبْنِهِ ٱلَّذِي وَلَدَتْهُ هَاجَرُ «إِسْمَاعِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","كَانَ أَبْرَامُ ٱبْنَ سِتٍّ وَثَمَانِينَ سَنَةً لَمَّا وَلَدَتْ هَاجَرُ إِسْمَاعِيلَ لِأَبْرَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","وَلَمَّا كَانَ أَبْرَامُ ٱبْنَ تِسْعٍ وَتِسْعِينَ سَنَةً ظَهَرَ ٱلرَّبُّ لِأَبْرَامَ وَقَالَ لَهُ: «أَنَا ٱللهُ ٱلْقَدِيرُ. سِرْ أَمَامِي وَكُنْ كَامِلًا، ");
INSERT INTO arb_vd_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","فَأَجْعَلَ عَهْدِي بَيْنِي وَبَيْنَكَ، وَأُكَثِّرَكَ كَثِيرًا جِدًّا». ");
INSERT INTO arb_vd_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","فَسَقَطَ أَبْرَامُ عَلَى وَجْهِهِ. وَتَكَلَّمَ ٱللهُ مَعَهُ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«أَمَّا أَنَا فَهُوَذَا عَهْدِي مَعَكَ، وَتَكُونُ أَبًا لِجُمْهُورٍ مِنَ ٱلْأُمَمِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","فَلَا يُدْعَى ٱسْمُكَ بَعْدُ أَبْرَامَ بَلْ يَكُونُ ٱسْمُكَ إِبْرَاهِيمَ، لِأَنِّي أَجْعَلُكَ أَبًا لِجُمْهُورٍ مِنَ ٱلْأُمَمِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","وَأُثْمِرُكَ كَثِيرًا جِدًّا، وَأَجْعَلُكَ أُمَمًا، وَمُلُوكٌ مِنْكَ يَخْرُجُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","وَأُقِيمُ عَهْدِي بَيْنِي وَبَيْنَكَ، وَبَيْنَ نَسْلِكَ مِنْ بَعْدِكَ فِي أَجْيَالِهِمْ، عَهْدًا أَبَدِيًّا، لِأَكُونَ إِلَهًا لَكَ وَلِنَسْلِكَ مِنْ بَعْدِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","وَأُعْطِي لَكَ وَلِنَسْلِكَ مِنْ بَعْدِكَ أَرْضَ غُرْبَتِكَ، كُلَّ أَرْضِ كَنْعَانَ مُلْكًا أَبَدِيًّا. وَأَكُونُ إِلَهَهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","وَقَالَ ٱللهُ لِإِبْرَاهِيمَ: «وَأَمَّا أَنْتَ فَتَحْفَظُ عَهْدِي، أَنْتَ وَنَسْلُكَ مِنْ بَعْدِكَ فِي أَجْيَالِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","هَذَا هُوَ عَهْدِي ٱلَّذِي تَحْفَظُونَهُ بَيْنِي وَبَيْنَكُمْ، وَبَيْنَ نَسْلِكَ مِنْ بَعْدِكَ: يُخْتَنُ مِنْكُمْ كُلُّ ذَكَرٍ، ");
INSERT INTO arb_vd_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","فَتُخْتَنُونَ فِي لَحْمِ غُرْلَتِكُمْ، فَيَكُونُ عَلَامَةَ عَهْدٍ بَيْنِي وَبَيْنَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","اِبْنَ ثَمَانِيَةِ أَيَّامٍ يُخْتَنُ مِنْكُمْ كُلُّ ذَكَرٍ فِي أَجْيَالِكُمْ: وَلِيدُ ٱلْبَيْتِ، وَٱلْمُبْتَاعُ بِفِضَّةٍ مِنْ كُلِّ ٱبْنِ غَرِيبٍ لَيْسَ مِنْ نَسْلِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","يُخْتَنُ خِتَانًا وَلِيدُ بَيْتِكَ وَٱلْمُبْتَاعُ بِفِضَّتِكَ، فَيَكُونُ عَهْدِي فِي لَحْمِكُمْ عَهْدًا أَبَدِيًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","وَأَمَّا ٱلذَّكَرُ ٱلْأَغْلَفُ ٱلَّذِي لَا يُخْتَنُ فِي لَحْمِ غُرْلَتِهِ فَتُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ شَعْبِهَا. إِنَّهُ قَدْ نَكَثَ عَهْدِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","وَقَالَ ٱللهُ لِإِبْرَاهِيمَ: «سَارَايُ ٱمْرَأَتُكَ لَا تَدْعُو ٱسْمَهَا سَارَايَ، بَلِ ٱسْمُهَا سَارَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","وَأُبَارِكُهَا وَأُعْطِيكَ أَيْضًا مِنْهَا ٱبْنًا. أُبَارِكُهَا فَتَكُونُ أُمَمًا، وَمُلُوكُ شُعُوبٍ مِنْهَا يَكُونُونَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","فَسَقَطَ إِبْرَاهِيمُ عَلَى وَجْهِهِ وَضَحِكَ، وَقَالَ فِي قَلْبِهِ: «هَلْ يُولَدُ لِٱبْنِ مِئَةِ سَنَةٍ؟ وَهَلْ تَلِدُ سَارَةُ وَهِيَ بِنْتُ تِسْعِينَ سَنَةً؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","وَقَالَ إِبْرَاهِيمُ لِلهِ: «لَيْتَ إِسْمَاعِيلَ يَعِيشُ أَمَامَكَ!». ");
INSERT INTO arb_vd_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","فَقَالَ ٱللهُ: «بَلْ سَارَةُ ٱمْرَأَتُكَ تَلِدُ لَكَ ٱبْنًا وَتَدْعُو ٱسْمَهُ إِسْحَاقَ. وَأُقِيمُ عَهْدِي مَعَهُ عَهْدًا أَبَدِيًّا لِنَسْلِهِ مِنْ بَعْدِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","وَأَمَّا إِسْمَاعِيلُ فَقَدْ سَمِعْتُ لَكَ فِيهِ. هَا أَنَا أُبَارِكُهُ وَأُثْمِرُهُ وَأُكَثِّرُهُ كَثِيرًا جِدًّا. اِثْنَيْ عَشَرَ رَئِيسًا يَلِدُ، وَأَجْعَلُهُ أُمَّةً كَبِيرَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","وَلَكِنْ عَهْدِي أُقِيمُهُ مَعَ إِسْحَاقَ ٱلَّذِي تَلِدُهُ لَكَ سَارَةُ فِي هَذَا ٱلْوَقْتِ فِي ٱلسَّنَةِ ٱلْآتِيَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","فَلَمَّا فَرَغَ مِنَ ٱلْكَلَامِ مَعَهُ صَعِدَ ٱللهُ عَنْ إِبْرَاهِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","فَأَخَذَ إِبْرَاهِيمُ إِسْمَاعِيلَ ٱبْنَهُ، وَجَمِيعَ وِلْدَانِ بَيْتِهِ، وَجَمِيعَ ٱلْمُبْتَاعِينَ بِفِضَّتِهِ، كُلَّ ذَكَرٍ مِنْ أَهْلِ بَيْتِ إِبْرَاهِيمَ، وَخَتَنَ لَحْمَ غُرْلَتِهِمْ فِي ذَلِكَ ٱلْيَوْمِ عَيْنِهِ كَمَا كَلَّمَهُ ٱللهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","وَكَانَ إِبْرَاهِيمُ ٱبْنَ تِسْعٍ وَتِسْعِينَ سَنَةً حِينَ خُتِنَ فِي لَحْمِ غُرْلَتِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","وَكَانَ إِسْمَاعِيلُ ٱبْنُهُ ٱبْنَ ثَلَاثَ عَشَرَةَ سَنَةً حِينَ خُتِنَ فِي لَحْمِ غُرْلَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","فِي ذَلِكَ ٱلْيَوْمِ عَيْنِهِ خُتِنَ إِبْرَاهِيمُ وَإِسْمَاعِيلُ ٱبْنُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","وَكُلُّ رِجَالِ بَيْتِهِ وِلْدَانِ ٱلْبَيْتِ وَٱلْمُبْتَاعِينَ بِٱلْفِضَّةِ مِنِ ٱبْنِ ٱلْغَرِيبِ خُتِنُوا مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","وَظَهَرَ لَهُ ٱلرَّبُّ عِنْدَ بَلُّوطَاتِ مَمْرَا وَهُوَ جَالِسٌ فِي بَابِ ٱلْخَيْمَةِ وَقْتَ حَرِّ ٱلنَّهَارِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","فَرَفَعَ عَيْنَيْهِ وَنَظَرَ وَإِذَا ثَلَاثَةُ رِجَالٍ وَاقِفُونَ لَدَيْهِ. فَلَمَّا نَظَرَ رَكَضَ لِٱسْتِقْبَالِهِمْ مِنْ بَابِ ٱلْخَيْمَةِ وَسَجَدَ إِلَى ٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","وَقَالَ: «يَا سَيِّدُ، إِنْ كُنْتُ قَدْ وَجَدْتُ نِعْمَةً فِي عَيْنَيْكَ فَلَا تَتَجَاوَزْ عَبْدَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","لِيُؤْخَذْ قَلِيلُ مَاءٍ وَٱغْسِلُوا أَرْجُلَكُمْ وَٱتَّكِئُوا تَحْتَ ٱلشَّجَرَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","فَآخُذَ كِسْرَةَ خُبْزٍ، فَتُسْنِدُونَ قُلُوبَكُمْ ثُمَّ تَجْتَازُونَ، لِأَنَّكُمْ قَدْ مَرَرْتُمْ عَلَى عَبْدِكُمْ». فَقَالُوا: «هَكَذَا تَفْعَلُ كَمَا تَكَلَّمْتَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","فَأَسْرَعَ إِبْرَاهِيمُ إِلَى ٱلْخَيْمَةِ إِلَى سَارَةَ، وَقَالَ: «أَسْرِعِي بِثَلَاثِ كَيْلَاتٍ دَقِيقًا سَمِيذًا. ٱعْجِنِي وَٱصْنَعِي خُبْزَ مَلَّةٍ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ثُمَّ رَكَضَ إِبْرَاهِيمُ إِلَى ٱلْبَقَرِ وَأَخَذَ عِجْلًا رَخْصًا وَجَيِّدًا وَأَعْطَاهُ لِلْغُلَامِ فَأَسْرَعَ لِيَعْمَلَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ثُمَّ أَخَذَ زُبْدًا وَلَبَنًا، وَٱلْعِجْلَ ٱلَّذِي عَمِلَهُ، وَوَضَعَهَا قُدَّامَهُمْ. وَإِذْ كَانَ هُوَ وَاقِفًا لَدَيْهِمْ تَحْتَ ٱلشَّجَرَةِ أَكَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","وَقَالُوا لَهُ: «أَيْنَ سَارَةُ ٱمْرَأَتُكَ؟» فَقَالَ: «هَا هِيَ فِي ٱلْخَيْمَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","فَقَالَ: «إِنِّي أَرْجِعُ إِلَيْكَ نَحْوَ زَمَانِ ٱلْحَيَاةِ وَيَكُونُ لِسَارَةَ ٱمْرَأَتِكَ ٱبْنٌ». وَكَانَتْ سَارَةُ سَامِعَةً فِي بَابِ ٱلْخَيْمَةِ وَهُوَ وَرَاءَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","وَكَانَ إِبْرَاهِيمُ وَسَارَةُ شَيْخَيْنِ مُتَقَدِّمَيْنِ فِي ٱلْأَيَّامِ، وَقَدِ ٱنْقَطَعَ أَنْ يَكُونَ لِسَارَةَ عَادَةٌ كَٱلنِّسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","فَضَحِكَتْ سَارَةُ فِي بَاطِنِهَا قَائِلَةً: «أَبَعْدَ فَنَائِي يَكُونُ لِي تَنَعُّمٌ، وَسَيِّدِي قَدْ شَاخَ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","فَقَالَ ٱلرَّبُّ لِإِبْرَاهِيمَ: «لِمَاذَا ضَحِكَتْ سَارَةُ قَائِلَةً: أَفَبِٱلْحَقِيقَةِ أَلِدُ وَأَنَا قَدْ شِخْتُ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","هَلْ يَسْتَحِيلُ عَلَى ٱلرَّبِّ شَيْءٌ؟ فِي ٱلْمِيعَادِ أَرْجِعُ إِلَيْكَ نَحْوَ زَمَانِ ٱلْحَيَاةِ وَيَكُونُ لِسَارَةَ ٱبْنٌ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","فَأَنْكَرَتْ سَارَةُ قَائِلَةً: «لَمْ أَضْحَكْ». لِأَنَّهَا خَافَتْ. فَقَالَ: «لَا! بَلْ ضَحِكْتِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ثُمَّ قَامَ ٱلرِّجَالُ مِنْ هُنَاكَ وَتَطَلَّعُوا نَحْوَ سَدُومَ. وَكَانَ إِبْرَاهِيمُ مَاشِيًا مَعَهُمْ لِيُشَيِّعَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","فَقَالَ ٱلرَّبُّ: «هَلْ أُخْفِي عَنْ إِبْرَاهِيمَ مَا أَنَا فَاعِلُهُ، ");
INSERT INTO arb_vd_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","وَإِبْرَاهِيمُ يَكُونُ أُمَّةً كَبِيرَةً وَقَوِيَّةً، وَيَتَبَارَكُ بِهِ جَمِيعُ أُمَمِ ٱلْأَرْضِ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","لِأَنِّي عَرَفْتُهُ لِكَيْ يُوصِيَ بَنِيهِ وَبَيْتَهُ مِنْ بَعْدِهِ أَنْ يَحْفَظُوا طَرِيقَ ٱلرَّبِّ، لِيَعْمَلُوا بِرًّا وَعَدْلًا، لِكَيْ يَأْتِيَ ٱلرَّبُّ لِإِبْرَاهِيمَ بِمَا تَكَلَّمَ بِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","وَقَالَ ٱلرَّبُّ: «إِنَّ صُرَاخَ سَدُومَ وَعَمُورَةَ قَدْ كَثُرَ، وَخَطِيَّتُهُمْ قَدْ عَظُمَتْ جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","أَنْزِلُ وَأَرَى هَلْ فَعَلُوا بِٱلتَّمَامِ حَسَبَ صُرَاخِهَا ٱلْآتِي إِلَيَّ، وَإِلَا فَأَعْلَمُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","وَٱنْصَرَفَ ٱلرِّجَالُ مِنْ هُنَاكَ وَذَهَبُوا نَحْوَ سَدُومَ، وَأَمَّا إِبْرَاهِيمُ فَكَانَ لَمْ يَزَلْ قَائِمًا أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","فَتَقَدَّمَ إِبْرَاهِيمُ وَقَالَ: «أَفَتُهْلِكُ ٱلْبَارَّ مَعَ ٱلْأَثِيمِ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","عَسَى أَنْ يَكُونَ خَمْسُونَ بَارًّا فِي ٱلْمَدِينَةِ. أَفَتُهْلِكُ ٱلْمَكَانَ وَلَا تَصْفَحُ عَنْهُ مِنْ أَجْلِ ٱلْخَمْسِينَ بَارًّا ٱلَّذِينَ فِيهِ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","حَاشَا لَكَ أَنْ تَفْعَلَ مِثْلَ هَذَا ٱلْأَمْرِ، أَنْ تُمِيتَ ٱلْبَارَّ مَعَ ٱلْأَثِيمِ، فَيَكُونُ ٱلْبَارُّ كَٱلْأَثِيمِ. حَاشَا لَكَ! أَدَيَّانُ كُلِّ ٱلْأَرْضِ لَا يَصْنَعُ عَدْلًا؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","فَقَالَ ٱلرَّبُّ: «إِنْ وَجَدْتُ فِي سَدُومَ خَمْسِينَ بَارًّا فِي ٱلْمَدِينَةِ، فَإِنِّي أَصْفَحُ عَنِ ٱلْمَكَانِ كُلِّهِ مِنْ أَجْلِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","فَأَجَابَ إِبْرَاهِيمُ وَقَالَ: «إِنِّي قَدْ شَرَعْتُ أُكَلِّمُ ٱلْمَوْلَى وَأَنَا تُرَابٌ وَرَمَادٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","رُبَّمَا نَقَصَ ٱلْخَمْسُونَ بَارًّا خَمْسَةً. أَتُهْلِكُ كُلَّ ٱلْمَدِينَةِ بِٱلْخَمْسَةِ؟» فَقَالَ: «لَا أُهْلِكُ إِنْ وَجَدْتُ هُنَاكَ خَمْسَةً وَأَرْبَعِينَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","فَعَادَ يُكَلِّمُهُ أَيْضًا وَقَالَ: «عَسَى أَنْ يُوجَدَ هُنَاكَ أَرْبَعُونَ». فَقَالَ: «لَا أَفْعَلُ مِنْ أَجْلِ ٱلْأَرْبَعِينَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","فَقَالَ: «لَا يَسْخَطِ ٱلْمَوْلَى فَأَتَكَلَّمَ. عَسَى أَنْ يُوجَدَ هُنَاكَ ثَلَاثُونَ». فَقَالَ: «لَا أَفْعَلُ إِنْ وَجَدْتُ هُنَاكَ ثَلَاثِينَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","فَقَالَ: «إِنِّي قَدْ شَرَعْتُ أُكَلِّمُ ٱلْمَوْلَى. عَسَى أَنْ يُوجَدَ هُنَاكَ عِشْرُونَ». فَقَالَ: «لَا أُهْلِكُ مِنْ أَجْلِ ٱلْعِشْرِينَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","فَقَالَ: «لَا يَسْخَطِ ٱلْمَوْلَى فَأَتَكَلَّمَ هَذِهِ ٱلْمَرَّةَ فَقَطْ. عَسَى أَنْ يُوجَدَ هُنَاكَ عَشْرَةٌ». فَقَالَ: «لَا أُهْلِكُ مِنْ أَجْلِ ٱلْعَشْرَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","وَذَهَبَ ٱلرَّبُّ عِنْدَمَا فَرَغَ مِنَ ٱلْكَلَامِ مَعَ إِبْرَاهِيمَ، وَرَجَعَ إِبْرَاهِيمُ إِلَى مَكَانِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","فَجَاءَ ٱلْمَلَاكَانِ إِلَى سَدُومَ مَسَاءً، وَكَانَ لُوطٌ جَالِسًا فِي بَابِ سَدُومَ. فَلَمَّا رَآهُمَا لُوطٌ قَامَ لِٱسْتِقْبَالِهِمَا، وَسَجَدَ بِوَجْهِهِ إِلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","وَقَالَ: «يَا سَيِّدَيَّ، مِيلَا إِلَى بَيْتِ عَبْدِكُمَا وَبِيتَا وَٱغْسِلَا أَرْجُلَكُمَا، ثُمَّ تُبَكِّرَانِ وَتَذْهَبَانِ فِي طَرِيقِكُمَا». فَقَالَا: «لَا، بَلْ فِي ٱلسَّاحَةِ نَبِيتُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","فَأَلَحَّ عَلَيْهِمَا جِدًّا، فَمَالَا إِلَيْهِ وَدَخَلَا بَيْتَهُ، فَصَنَعَ لَهُمَا ضِيَافَةً وَخَبَزَ فَطِيرًا فَأَكَلَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","وَقَبْلَمَا ٱضْطَجَعَا أَحَاطَ بِٱلْبَيْتِ رِجَالُ ٱلْمَدِينَةِ، رِجَالُ سَدُومَ، مِنَ ٱلْحَدَثِ إِلَى ٱلشَّيْخِ، كُلُّ ٱلشَّعْبِ مِنْ أَقْصَاهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","فَنَادَوْا لُوطًا وَقَالُوا لَهُ: «أَيْنَ ٱلرَّجُلَانِ ٱللَّذَانِ دَخَلَا إِلَيْكَ ٱللَّيْلَةَ؟ أَخْرِجْهُمَا إِلَيْنَا لِنَعْرِفَهُمَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","فَخَرَجَ إِلَيْهِمْ لُوطٌ إِلَى ٱلْبَابِ وَأَغْلَقَ ٱلْبَابَ وَرَاءَهُ ");
INSERT INTO arb_vd_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","وَقَالَ: «لَا تَفْعَلُوا شَرًّا يَا إِخْوَتِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","هُوَذَا لِي ٱبْنَتَانِ لَمْ تَعْرِفَا رَجُلًا. أُخْرِجُهُمَا إِلَيْكُمْ فَٱفْعَلُوا بِهِمَا كَمَا يَحْسُنُ فِي عُيُونِكُمْ. وَأَمَّا هَذَانِ ٱلرَّجُلَانِ فَلَا تَفْعَلُوا بِهِمَا شَيْئًا، لِأَنَّهُمَا قَدْ دَخَلَا تَحْتَ ظِلِّ سَقْفِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","فَقَالُوا: «ٱبْعُدْ إِلَى هُنَاكَ». ثُمَّ قَالُوا: «جَاءَ هَذَا ٱلْإِنْسَانُ لِيَتَغَرَّبَ، وَهُوَ يَحْكُمُ حُكْمًا. ٱلْآنَ نَفْعَلُ بِكَ شَرًّا أَكْثَرَ مِنْهُمَا». فَأَلَحُّوا عَلَى ٱلْرَّجُلِ لُوطٍ جِدًّا وَتَقَدَّمُوا لِيُكَسِّرُوا ٱلْبَابَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","فَمَدَّ ٱلرَّجُلَانِ أَيْدِيَهُمَا وَأَدْخَلَا لُوطًا إِلَيْهِمَا إِلَى ٱلْبَيْتِ وَأَغْلَقَا ٱلْبَابَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","وَأَمَّا ٱلرِّجَالُ ٱلَّذِينَ عَلَى بَابِ ٱلْبَيْتِ فَضَرَبَاهُمْ بِٱلْعَمَى، مِنَ ٱلصَّغِيرِ إِلَى ٱلْكَبِيرِ، فَعَجِزُوا عَنْ أَنْ يَجِدُوا ٱلْبَابَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","وَقَالَ ٱلرَّجُلَانِ لِلُوطٍ: «مَنْ لَكَ أَيْضًا هَهُنَا؟ أَصْهَارَكَ وَبَنِيكَ وَبَنَاتِكَ وَكُلَّ مَنْ لَكَ فِي ٱلْمَدِينَةِ، أَخْرِجْ مِنَ ٱلْمَكَانِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","لِأَنَّنَا مُهْلِكَانِ هَذَا ٱلْمَكَانَ، إِذْ قَدْ عَظُمَ صُرَاخُهُمْ أَمَامَ ٱلرَّبِّ، فَأَرْسَلَنَا ٱلرَّبُّ لِنُهْلِكَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","فَخَرَجَ لُوطٌ وَكَلَّمَ أَصْهَارَهُ ٱلْآخِذِينَ بَنَاتِهِ وَقَالَ: «قُومُوا ٱخْرُجُوا مِنْ هَذَا ٱلْمَكَانِ، لِأَنَّ ٱلرَّبَّ مُهْلِكٌ ٱلْمَدِينَةَ». فَكَانَ كَمَازِحٍ فِي أَعْيُنِ أَصْهَارِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","وَلَمَّا طَلَعَ ٱلْفَجْرُ كَانَ ٱلْمَلَاكَانِ يُعَجِّلَانِ لُوطًا قَائِلَيْنِ: «قُمْ خُذِ ٱمْرَأَتَكَ وَٱبْنَتَيْكَ ٱلْمَوْجُودَتَيْنِ لِئَلَّا تَهْلِكَ بِإِثْمِ ٱلْمَدِينَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","وَلَمَّا تَوَانَى، أَمْسَكَ ٱلرَّجُلَانِ بِيَدِهِ وَبِيَدِ ٱمْرَأَتِهِ وَبِيَدِ ٱبْنَتَيْهِ، لِشَفَقَةِ ٱلرَّبِّ عَلَيْهِ، وَأَخْرَجَاهُ وَوَضَعَاهُ خَارِجَ ٱلْمَدِينَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","وَكَانَ لَمَّا أَخْرَجَاهُمْ إِلَى خَارِجٍ أَنَّهُ قَالَ: «ٱهْرُبْ لِحَيَاتِكَ. لَا تَنْظُرْ إِلَى وَرَائِكَ، وَلَا تَقِفْ فِي كُلِّ ٱلدَّائِرَةِ. ٱهْرُبْ إِلَى ٱلْجَبَلِ لِئَلَّا تَهْلِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","فَقَالَ لَهُمَا لُوطٌ: «لَا يَا سَيِّدُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","هُوَذَا عَبْدُكَ قَدْ وَجَدَ نِعْمَةً فِي عَيْنَيْكَ، وَعَظَّمْتَ لُطْفَكَ ٱلَّذِي صَنَعْتَ إِلَيَّ بِٱسْتِبْقَاءِ نَفْسِي، وَأَنَا لَا أَقْدِرُ أَنْ أَهْرُبَ إِلَى ٱلْجَبَلِ لَعَلَّ ٱلشَّرَّ يُدْرِكُنِي فَأَمُوتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","هُوَذَا ٱلْمَدِينَةُ هَذِهِ قَرِيبَةٌ لِلْهَرَبِ إِلَيْهَا وَهِيَ صَغِيرَةٌ. أَهْرُبُ إِلَى هُنَاكَ. أَلَيْسَتْ هِيَ صَغِيرَةً؟ فَتَحْيَا نَفْسِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","فَقَالَ لَهُ: «إِنِّي قَدْ رَفَعْتُ وَجْهَكَ فِي هَذَا ٱلْأَمْرِ أَيْضًا، أَنْ لَا أَقْلِبَ ٱلْمَدِينَةَ ٱلَّتِي تَكَلَّمْتَ عَنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","أَسْرِعِ ٱهْرُبْ إِلَى هُنَاكَ لِأَنِّي لَا أَسْتَطِيعُ أَنْ أَفْعَلَ شَيْئًا حَتَّى تَجِيءَ إِلَى هُنَاكَ». لِذَلِكَ دُعِيَ ٱسْمُ ٱلْمَدِينَةِ «صُوغَرَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","وَإِذْ أَشْرَقَتِ ٱلشَّمْسُ عَلَى ٱلْأَرْضِ دَخَلَ لُوطٌ إِلَى صُوغَرَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","فَأَمْطَرَ ٱلرَّبُّ عَلَى سَدُومَ وَعَمُورَةَ كِبْرِيتًا وَنَارًا مِنْ عِنْدِ ٱلرَّبِّ مِنَ ٱلسَّمَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","وَقَلَبَ تِلْكَ ٱلْمُدُنَ، وَكُلَّ ٱلدَّائِرَةِ، وَجَمِيعَ سُكَّانِ ٱلْمُدُنِ، وَنَبَاتِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","وَنَظَرَتِ ٱمْرَأَتُهُ مِنْ وَرَائِهِ فَصَارَتْ عَمُودَ مِلْحٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","وَبَكَّرَ إِبْرَاهِيمُ فِي ٱلْغَدِ إِلَى ٱلْمَكَانِ ٱلَّذِي وَقَفَ فِيهِ أَمَامَ ٱلرَّبِّ، ");
INSERT INTO arb_vd_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","وَتَطَلَّعَ نَحْوَ سَدُومَ وَعَمُورَةَ، وَنَحْوَ كُلِّ أَرْضِ ٱلدَّائِرَةِ، وَنَظَرَ وَإِذَا دُخَانُ ٱلْأَرْضِ يَصْعَدُ كَدُخَانِ ٱلْأَتُونِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","وَحَدَثَ لَمَّا أَخْرَبَ ٱللهُ مُدُنَ ٱلدَّائِرَةِ أَنَّ ٱللهَ ذَكَرَ إِبْرَاهِيمَ، وَأَرْسَلَ لُوطًا مِنْ وَسَطِ ٱلِٱنْقِلَابِ. حِينَ قَلَبَ ٱلْمُدُنَ ٱلَّتِي سَكَنَ فِيهَا لُوطٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","وَصَعِدَ لُوطٌ مِنْ صُوغَرَ وَسَكَنَ فِي ٱلْجَبَلِ، وَٱبْنَتَاهُ مَعَهُ، لِأَنَّهُ خَافَ أَنْ يَسْكُنَ فِي صُوغَرَ. فَسَكَنَ فِي ٱلْمَغَارَةِ هُوَ وَٱبْنَتَاهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","وَقَالَتِ ٱلْبِكْرُ لِلصَّغِيرَةِ: «أَبُونَا قَدْ شَاخَ، وَلَيْسَ فِي ٱلْأَرْضِ رَجُلٌ لِيَدْخُلَ عَلَيْنَا كَعَادَةِ كُلِّ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","هَلُمَّ نَسْقِي أَبَانَا خَمْرًا وَنَضْطَجِعُ مَعَهُ، فَنُحْيِي مِنْ أَبِينَا نَسْلًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","فَسَقَتَا أَبَاهُمَا خَمْرًا فِي تِلْكَ ٱللَّيْلَةِ، وَدَخَلَتِ ٱلْبِكْرُ وَٱضْطَجَعَتْ مَعَ أَبِيهَا، وَلَمْ يَعْلَمْ بِٱضْطِجَاعِهَا وَلَا بِقِيَامِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","وَحَدَثَ فِي ٱلْغَدِ أَنَّ ٱلْبِكْرَ قَالَتْ لِلصَّغِيرَةِ: «إِنِّي قَدِ ٱضْطَجَعْتُ ٱلْبَارِحَةَ مَعَ أَبِي. نَسْقِيهِ خَمْرًا ٱللَّيْلَةَ أَيْضًا فَٱدْخُلِي ٱضْطَجِعِي مَعَهُ، فَنُحْيِيَ مِنْ أَبِينَا نَسْلًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","فَسَقَتَا أَبَاهُمَا خَمْرًا فِي تِلْكَ ٱللَّيْلَةِ أَيْضًا، وَقَامَتِ ٱلصَّغِيرَةُ وَٱضْطَجَعَتْ مَعَهُ، وَلَمْ يَعْلَمْ بِٱضْطِجَاعِهَا وَلَا بِقِيَامِهَا، ");
INSERT INTO arb_vd_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","فَحَبِلَتِ ٱبْنَتَا لُوطٍ مِنْ أَبِيهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","فَوَلَدَتِ ٱلْبِكْرُ ٱبْنًا وَدَعَتِ ٱسْمَهُ «مُوآبَ»، وَهُوَ أَبُو ٱلْمُوآبِيِّينَ إِلَى ٱلْيَوْمِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","وَٱلصَّغِيرَةُ أَيْضًا وَلَدَتِ ٱبْنًا وَدَعَتِ ٱسْمَهُ «بِنْ عَمِّي»، وَهُوَ أَبُو بَنِي عَمُّونَ إِلَى ٱلْيَوْمِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","وَٱنْتَقَلَ إِبْرَاهِيمُ مِنْ هُنَاكَ إِلَى أَرْضِ ٱلْجَنُوبِ، وَسَكَنَ بَيْنَ قَادِشَ وَشُورَ، وَتَغَرَّبَ فِي جَرَارَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","وَقَالَ إِبْرَاهِيمُ عَنْ سَارَةَ ٱمْرَأَتِهِ: «هِيَ أُخْتِي». فَأَرْسَلَ أَبِيمَالِكُ مَلِكُ جَرَارَ وَأَخَذَ سَارَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","فَجَاءَ ٱللهُ إِلَى أَبِيمَالِكَ فِي حُلْمِ ٱللَّيْلِ وَقَالَ لَهُ: «هَا أَنْتَ مَيِّتٌ مِنْ أَجْلِ ٱلْمَرْأَةِ ٱلَّتِي أَخَذْتَهَا، فَإِنَّهَا مُتَزَوِّجَةٌ بِبَعْلٍ». ");
INSERT INTO arb_vd_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","وَلَكِنْ لَمْ يَكُنْ أَبِيمَالِكُ قَدِ ٱقْتَرَبَ إِلَيْهَا، فَقَالَ: «يَا سَيِّدُ، أَأُمَّةً بَارَّةً تَقْتُلُ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","أَلَمْ يَقُلْ هُوَ لِي: إِنَّهَا أُخْتِي، وَهِيَ أَيْضًا نَفْسُهَا قَالَتْ: هُوَ أَخِي؟ بِسَلَامَةِ قَلْبِي وَنَقَاوَةِ يَدَيَّ فَعَلْتُ هَذَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","فَقَالَ لَهُ ٱللهُ فِي ٱلْحُلْمِ: «أَنَا أَيْضًا عَلِمْتُ أَنَّكَ بِسَلَامَةِ قَلْبِكَ فَعَلْتَ هَذَا. وَأَنَا أَيْضًا أَمْسَكْتُكَ عَنْ أَنْ تُخْطِئَ إِلَيَّ، لِذَلِكَ لَمْ أَدَعْكَ تَمَسُّهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","فَٱلْآنَ رُدَّ ٱمْرَأَةَ ٱلرَّجُلِ، فَإِنَّهُ نَبِيٌّ، فَيُصَلِّيَ لِأَجْلِكَ فَتَحْيَا. وَإِنْ كُنْتَ لَسْتَ تَرُدُّهَا، فَٱعْلَمْ أَنَّكَ مَوْتًا تَمُوتُ، أَنْتَ وَكُلُّ مَنْ لَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","فَبَكَّرَ أَبِيمَالِكُ فِي ٱلْغَدِ وَدَعَا جَمِيعَ عَبِيدِهِ، وَتَكَلَّمَ بِكُلِّ هَذَا ٱلْكَلَامِ فِي مَسَامِعِهِمْ، فَخَافَ ٱلرِّجَالُ جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ثُمَّ دَعَا أَبِيمَالِكُ إِبْرَاهِيمَ وَقَالَ لَهُ: «مَاذَا فَعَلْتَ بِنَا؟ وَبِمَاذَا أَخْطَأْتُ إِلَيْكَ حَتَّى جَلَبْتَ عَلَيَّ وَعَلَى مَمْلَكَتِي خَطِيَّةً عَظِيمَةً؟ أَعْمَالًا لَا تُعْمَلُ عَمِلْتَ بِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","وَقَالَ أَبِيمَالِكُ لِإِبْرَاهِيمَ: «مَاذَا رَأَيْتَ حَتَّى عَمِلْتَ هَذَا ٱلشَّيْءَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","فَقَالَ إِبْرَاهِيمُ: «إِنِّي قُلْتُ: لَيْسَ فِي هَذَا ٱلْمَوْضِعِ خَوْفُ ٱللهِ ٱلْبَتَّةَ، فَيَقْتُلُونَنِي لِأَجْلِ ٱمْرَأَتِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","وَبِٱلْحَقِيقَةِ أَيْضًا هِيَ أُخْتِي ٱبْنَةُ أَبِي، غَيْرَ أَنَّهَا لَيْسَتِ ٱبْنَةَ أُمِّي، فَصَارَتْ لِي زَوْجَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","وَحَدَثَ لَمَّا أَتَاهَنِي ٱللهُ مِنْ بَيْتِ أَبِي أَنِّي قُلْتُ لَهَا: هَذَا مَعْرُوفُكِ ٱلَّذِي تَصْنَعِينَ إِلَيَّ: فِي كُلِّ مَكَانٍ نَأْتِي إِلَيْهِ قُولِي عَنِّي: هُوَ أَخِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","فَأَخَذَ أَبِيمَالِكُ غَنَمًا وَبَقَرًا وَعَبِيدًا وَإِمَاءً وَأَعْطَاهَا لِإِبْرَاهِيمَ، وَرَدَّ إِلَيْهِ سَارَةَ ٱمْرَأَتَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","وَقَالَ أَبِيمَالِكُ: «هُوَذَا أَرْضِي قُدَّامَكَ. ٱسْكُنْ فِي مَا حَسُنَ فِي عَيْنَيْكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","وَقَالَ لِسَارَةَ: «إِنِّي قَدْ أَعْطَيْتُ أَخَاكِ أَلْفًا مِنَ ٱلْفِضَّةِ. هَا هُوَ لَكِ غِطَاءُ عَيْنٍ مِنْ جِهَةِ كُلِّ مَا عِنْدَكِ وَعِنْدَ كُلِّ وَاحِدٍ، فَأُنْصِفْتِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","فَصَلَّى إِبْرَاهِيمُ إِلَى ٱللهِ، فَشَفَى ٱللهُ أَبِيمَالِكَ وَٱمْرَأَتَهُ وَجَوَارِيَهُ فَوَلَدْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","لِأَنَّ ٱلرَّبَّ كَانَ قَدْ أَغْلَقَ كُلَّ رَحِمٍ لِبَيْتِ أَبِيمَالِكَ بِسَبَبِ سَارَةَ ٱمْرَأَةِ إِبْرَاهِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","وَٱفْتَقَدَ ٱلرَّبُّ سَارَةَ كَمَا قَالَ، وَفَعَلَ ٱلرَّبُّ لِسَارَةَ كَمَا تَكَلَّمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","فَحَبِلَتْ سَارَةُ وَوَلَدَتْ لِإِبْرَاهِيمَ ٱبْنًا فِي شَيْخُوخَتِهِ، فِي ٱلْوَقْتِ ٱلَّذِي تَكَلَّمَ ٱللهُ عَنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","وَدَعَا إِبْرَاهِيمُ ٱسْمَ ٱبْنِهِ ٱلْمَوْلُودِ لَهُ، ٱلَّذِي وَلَدَتْهُ لَهُ سَارَةُ «إِسْحَاقَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","وَخَتَنَ إِبْرَاهِيمُ إِسْحَاقَ ٱبْنَهُ وَهُوَ ٱبْنُ ثَمَانِيَةِ أَيَّامٍ كَمَا أَمَرَهُ ٱللهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","وَكَانَ إِبْرَاهِيمُ ٱبْنَ مِئَةِ سَنَةٍ حِينَ وُلِدَ لَهُ إِسْحَاقُ ٱبْنُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","وَقَالَتْ سَارَةُ: «قَدْ صَنَعَ إِلَيَّ ٱللهُ ضِحْكًا. كُلُّ مَنْ يَسْمَعُ يَضْحَكُ لِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","وَقَالَتْ: «مَنْ قَالَ لِإِبْرَاهِيمَ: سَارَةُ تُرْضِعُ بَنِينَ؟ حَتَّى وَلَدْتُ ٱبْنًا فِي شَيْخُوخَتِهِ!». ");
INSERT INTO arb_vd_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","فَكَبِرَ ٱلْوَلَدُ وَفُطِمَ. وَصَنَعَ إِبْرَاهِيمُ وَلِيمَةً عَظِيمَةً يَوْمَ فِطَامِ إِسْحَاقَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","وَرَأَتْ سَارَةُ ٱبْنَ هَاجَرَ ٱلْمِصْرِيَّةِ ٱلَّذِي وَلَدَتْهُ لِإِبْرَاهِيمَ يَمْزَحُ، ");
INSERT INTO arb_vd_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","فَقَالَتْ لِإِبْرَاهِيمَ: «ٱطْرُدْ هَذِهِ ٱلْجَارِيَةَ وَٱبْنَهَا، لِأَنَّ ٱبْنَ هَذِهِ ٱلْجَارِيَةِ لَا يَرِثُ مَعَ ٱبْنِي إِسْحَاقَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","فَقَبُحَ ٱلْكَلَامُ جِدًّا فِي عَيْنَيْ إِبْرَاهِيمَ لِسَبَبِ ٱبْنِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","فَقَالَ ٱللهُ لِإِبْرَاهِيمَ: «لَا يَقْبُحُ فِي عَيْنَيْكَ مِنْ أَجْلِ ٱلْغُلَامِ وَمِنْ أَجْلِ جَارِيَتِكَ. فِي كُلِّ مَا تَقُولُ لَكَ سَارَةُ ٱسْمَعْ لِقَوْلِهَا، لِأَنَّهُ بِإِسْحَاقَ يُدْعَى لَكَ نَسْلٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","وَٱبْنُ ٱلْجَارِيَةِ أَيْضًا سَأَجْعَلُهُ أُمَّةً لِأَنَّهُ نَسْلُكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","فَبَكَّرَ إِبْرَاهِيمُ صَبَاحًا وَأَخَذَ خُبْزًا وَقِرْبَةَ مَاءٍ وَأَعْطَاهُمَا لِهَاجَرَ، وَاضِعًا إِيَّاهُمَا عَلَى كَتِفِهَا، وَٱلْوَلَدَ، وَصَرَفَهَا. فَمَضَتْ وَتَاهَتْ فِي بَرِّيَّةِ بِئْرِ سَبْعٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","وَلَمَّا فَرَغَ ٱلْمَاءُ مِنَ ٱلْقِرْبَةِ طَرَحَتِ ٱلْوَلَدَ تَحْتَ إِحْدَى ٱلْأَشْجَارِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","وَمَضَتْ وَجَلَسَتْ مُقَابِلَهُ بَعِيدًا نَحْوَ رَمْيَةِ قَوْسٍ، لِأَنَّهَا قَالَتْ: «لَا أَنْظُرُ مَوْتَ ٱلْوَلَدِ». فَجَلَسَتْ مُقَابِلَهُ وَرَفَعَتْ صَوْتَهَا وَبَكَتْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","فَسَمِعَ ٱللهُ صَوْتَ ٱلْغُلَامِ، وَنَادَى مَلَاكُ ٱللهِ هَاجَرَ مِنَ ٱلسَّمَاءِ وَقَالَ لَهَا: «مَا لَكِ يَا هَاجَرُ؟ لَا تَخَافِي، لِأَنَّ ٱللهَ قَدْ سَمِعَ لِصَوْتِ ٱلْغُلَامِ حَيْثُ هُوَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","قُومِي ٱحْمِلِي ٱلْغُلَامَ وَشُدِّي يَدَكِ بِهِ، لِأَنِّي سَأَجْعَلُهُ أُمَّةً عَظِيمَةً». ");
INSERT INTO arb_vd_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","وَفَتَحَ ٱللهُ عَيْنَيْهَا فَأَبْصَرَتْ بِئْرَ مَاءٍ، فَذَهَبَتْ وَمَلَأَتِ ٱلْقِرْبَةَ مَاءً وَسَقَتِ ٱلْغُلَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","وَكَانَ ٱللهُ مَعَ ٱلْغُلَامِ فَكَبِرَ، وَسَكَنَ فِي ٱلْبَرِّيَّةِ، وَكَانَ يَنْمُو رَامِيَ قَوْسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","وَسَكَنَ فِي بَرِّيَّةِ فَارَانَ، وَأَخَذَتْ لَهُ أُمُّهُ زَوْجَةً مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","وَحَدَثَ فِي ذَلِكَ ٱلزَّمَانِ أَنَّ أَبِيمَالِكَ وَفِيكُولَ رَئِيسَ جَيْشِهِ كَلَّمَا إِبْرَاهِيمَ قَائِلَيْنِ: «ٱللهُ مَعَكَ فِي كُلِّ مَا أَنْتَ صَانِعٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","فَٱلْآنَ ٱحْلِفْ لِي بِٱللهِ هَهُنَا أَنَّكَ لَا تَغْدُرُ بِي وَلَا بِنَسْلِي وَذُرِّيَّتِي، كَٱلْمَعْرُوفِ ٱلَّذِي صَنَعْتُ إِلَيْكَ تَصْنَعُ إِلَيَّ وَإِلَى ٱلْأَرْضِ ٱلَّتِي تَغَرَّبْتَ فِيهَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","فَقَالَ إِبْرَاهِيمُ: «أَنَا أَحْلِفُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","وَعَاتَبَ إِبْرَاهِيمُ أَبِيمَالِكَ لِسَبَبِ بِئْرِ ٱلْمَاءِ ٱلَّتِي ٱغْتَصَبَهَا عَبِيدُ أَبِيمَالِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","فَقَالَ أَبِيمَالِكُ: «لَمْ أَعْلَمْ مَنْ فَعَلَ هَذَا ٱلْأَمْرَ. أَنْتَ لَمْ تُخْبِرْنِي، وَلَا أَنَا سَمِعْتُ سِوَى ٱلْيَوْمِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","فَأَخَذَ إِبْرَاهِيمُ غَنَمًا وَبَقَرًا وَأَعْطَى أَبِيمَالِكَ، فَقَطَعَا كِلَاهُمَا مِيثَاقًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","وَأَقَامَ إِبْرَاهِيمُ سَبْعَ نِعَاجٍ مِنَ ٱلْغَنَمِ وَحْدَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","فَقَالَ أَبِيمَالِكُ لِإِبْرَاهِيمَ: «مَا هِيَ هَذِهِ ٱلسَّبْعُ ٱلنِّعَاجِ ٱلَّتِي أَقَمْتَهَا وَحْدَهَا؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","فَقَالَ: «إِنَّكَ سَبْعَ نِعَاجٍ تَأْخُذُ مِنْ يَدِي، لِكَيْ تَكُونَ لِي شَهَادَةً بِأَنِّي حَفَرْتُ هَذِهِ ٱلْبِئْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","لِذَلِكَ دَعَا ذَلِكَ ٱلْمَوْضِعَ «بِئْرَ سَبْعٍ»، لِأَنَّهُمَا هُنَاكَ حَلَفَا كِلَاهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","فَقَطَعَا مِيثَاقًا فِي بِئْرِ سَبْعٍ، ثُمَّ قَامَ أَبِيمَالِكُ وَفِيكُولُ رَئِيسُ جَيْشِهِ وَرَجَعَا إِلَى أَرْضِ ٱلْفِلِسْطِينِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","وَغَرَسَ إِبْرَاهِيمُ أَثْلًا فِي بِئْرِ سَبْعٍ، وَدَعَا هُنَاكَ بِٱسْمِ ٱلرَّبِّ ٱلْإِلَهِ ٱلسَّرْمَدِيِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","وَتَغَرَّبَ إِبْرَاهِيمُ فِي أَرْضِ ٱلْفِلِسْطِينِيِّينَ أَيَّامًا كَثِيرَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","وَحَدَثَ بَعْدَ هَذِهِ ٱلْأُمُورِ أَنَّ ٱللهَ ٱمْتَحَنَ إِبْرَاهِيمَ، فَقَالَ لَهُ: «يَا إِبْرَاهِيمُ!». فَقَالَ: «هَأَنَذَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","فَقَالَ: «خُذِ ٱبْنَكَ وَحِيدَكَ، ٱلَّذِي تُحِبُّهُ، إِسْحَاقَ، وَٱذْهَبْ إِلَى أَرْضِ ٱلْمُرِيَّا، وَأَصْعِدْهُ هُنَاكَ مُحْرَقَةً عَلَى أَحَدِ ٱلْجِبَالِ ٱلَّذِي أَقُولُ لَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","فَبَكَّرَ إِبْرَاهِيمُ صَبَاحًا وَشَدَّ عَلَى حِمَارِهِ، وَأَخَذَ ٱثْنَيْنِ مِنْ غِلْمَانِهِ مَعَهُ، وَإِسْحَاقَ ٱبْنَهُ، وَشَقَّقَ حَطَبًا لِمُحْرَقَةٍ، وَقَامَ وَذَهَبَ إِلَى ٱلْمَوْضِعِ ٱلَّذِي قَالَ لَهُ ٱللهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","وَفِي ٱلْيَوْمِ ٱلثَّالِثِ رَفَعَ إِبْرَاهِيمُ عَيْنَيْهِ وَأَبْصَرَ ٱلْمَوْضِعَ مِنْ بَعِيدٍ، ");
INSERT INTO arb_vd_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","فَقَالَ إِبْرَاهِيمُ لِغُلَامَيْهِ: «ٱجْلِسَا أَنْتُمَا هَهُنَا مَعَ ٱلْحِمَارِ، وَأَمَّا أَنَا وَٱلْغُلَامُ فَنَذْهَبُ إِلَى هُنَاكَ وَنَسْجُدُ، ثُمَّ نَرْجِعُ إِلَيْكُمَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","فَأَخَذَ إِبْرَاهِيمُ حَطَبَ ٱلْمُحْرَقَةِ وَوَضَعَهُ عَلَى إِسْحَاقَ ٱبْنِهِ، وَأَخَذَ بِيَدِهِ ٱلنَّارَ وَٱلسِّكِّينَ. فَذَهَبَا كِلَاهُمَا مَعًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","وَكَلَّمَ إِسْحَاقُ إِبْرَاهِيمَ أَبِاهُ وَقَالَ: «يَا أَبِي!». فَقَالَ: «هَأَنَذَا يَا ٱبْنِي». فَقَالَ: «هُوَذَا ٱلنَّارُ وَٱلْحَطَبُ، وَلَكِنْ أَيْنَ ٱلْخَرُوفُ لِلْمُحْرَقَةِ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","فَقَالَ إِبْرَاهِيمُ: «ٱللهُ يَرَى لَهُ ٱلْخَرُوفَ لِلْمُحْرَقَةِ يَا ٱبْنِي». فَذَهَبَا كِلَاهُمَا مَعًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","فَلَمَّا أَتَيَا إِلَى ٱلْمَوْضِعِ ٱلَّذِي قَالَ لَهُ ٱللهُ، بَنَى هُنَاكَ إِبْرَاهِيمُ ٱلْمَذْبَحَ وَرَتَّبَ ٱلْحَطَبَ وَرَبَطَ إِسْحَاقَ ٱبْنَهُ وَوَضَعَهُ عَلَى ٱلْمَذْبَحِ فَوْقَ ٱلْحَطَبِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ثُمَّ مَدَّ إِبْرَاهِيمُ يَدَهُ وَأَخَذَ ٱلسِّكِّينَ لِيَذْبَحَ ٱبْنَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","فَنَادَاهُ مَلَاكُ ٱلرَّبِّ مِنَ ٱلسَّمَاءِ وَقَالَ: «إِبْرَاهِيمُ! إِبْرَاهِيمُ!». فَقَالَ: «هَأَنَذَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","فَقَالَ: «لَا تَمُدَّ يَدَكَ إِلَى ٱلْغُلَامِ وَلَا تَفْعَلْ بِهِ شَيْئًا، لِأَنِّي ٱلْآنَ عَلِمْتُ أَنَّكَ خَائِفٌ ٱللهَ، فَلَمْ تُمْسِكِ ٱبْنَكَ وَحِيدَكَ عَنِّي». ");
INSERT INTO arb_vd_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","فَرَفَعَ إِبْرَاهِيمُ عَيْنَيْهِ وَنَظَرَ وَإِذَا كَبْشٌ وَرَاءَهُ مُمْسَكًا فِي ٱلْغَابَةِ بِقَرْنَيْهِ، فَذَهَبَ إِبْرَاهِيمُ وَأَخَذَ ٱلْكَبْشَ وَأَصْعَدَهُ مُحْرَقَةً عِوَضًا عَنِ ٱبْنِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","فَدَعَا إِبْرَاهِيمُ ٱسْمَ ذَلِكَ ٱلْمَوْضِعِ «يَهْوَهْ يِرْأَهْ». حَتَّى إِنَّهُ يُقَالُ ٱلْيَوْمَ: «فِي جَبَلِ ٱلرَّبِّ يُرَى». ");
INSERT INTO arb_vd_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","وَنَادَى مَلَاكُ ٱلرَّبِّ إِبْرَاهِيمَ ثَانِيَةً مِنَ ٱلسَّمَاءِ ");
INSERT INTO arb_vd_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","وَقَالَ: «بِذَاتِي أَقْسَمْتُ، يَقُولُ ٱلرَّبُّ، أَنِّي مِنْ أَجْلِ أَنَّكَ فَعَلْتَ هَذَا ٱلْأَمْرَ، وَلَمْ تُمْسِكِ ٱبْنَكَ وَحِيدَكَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","أُبَارِكُكَ مُبَارَكَةً، وَأُكَثِّرُ نَسْلَكَ تَكْثِيرًا كَنُجُومِ ٱلسَّمَاءِ وَكَالرَّمْلِ ٱلَّذِي عَلَى شَاطِئِ ٱلْبَحْرِ، وَيَرِثُ نَسْلُكَ بَابَ أَعْدَائِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","وَيَتَبَارَكُ فِي نَسْلِكَ جَمِيعُ أُمَمِ ٱلْأَرْضِ، مِنْ أَجْلِ أَنَّكَ سَمِعْتَ لِقَوْلِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ثُمَّ رَجَعَ إِبْرَاهِيمُ إِلَى غُلَامَيْهِ، فَقَامُوا وَذَهَبُوا مَعًا إِلَى بِئْرِ سَبْعٍ. وَسَكَنَ إِبْرَاهِيمُ فِي بِئْرِ سَبْعٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","وَحَدَثَ بَعْدَ هَذِهِ ٱلْأُمُورِ أَنَّ إِبْرَاهِيمَ أُخْبِرَ وَقِيلَ لَهُ: «هُوَذَا مِلْكَةُ قَدْ وَلَدَتْ هِيَ أَيْضًا بَنِينَ لِنَاحُورَ أَخِيكَ: ");
INSERT INTO arb_vd_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","عُوصًا بِكْرَهُ، وَبُوزًا أَخَاهُ، وَقَمُوئِيلَ أَبَا أَرَامَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","وَكَاسَدَ وَحَزْوًا وَفِلْدَاشَ وَيِدْلَافَ وَبَتُوئِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","وَوَلَدَ بَتُوئِيلُ رِفْقَةَ. هَؤُلَاءِ ٱلثَّمَانِيَةُ وَلَدَتْهُمْ مِلْكَةُ لِنَاحُورَ أَخِي إِبْرَاهِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","وَأَمَّا سُرِّيَّتُهُ، وَٱسْمُهَا رَؤُومَةُ، فَوَلَدَتْ هِيَ أَيْضًا: طَابَحَ وَجَاحَمَ وَتَاحَشَ وَمَعْكَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","وَكَانَتْ حَيَاةُ سَارَةَ مِئَةً وَسَبْعًا وَعِشْرِينَ سَنَةً، سِنِي حَيَاةِ سَارَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","وَمَاتَتْ سَارَةُ فِي قَرْيَةِ أَرْبَعَ، ٱلَّتِي هِيَ حَبْرُونُ، فِي أَرْضِ كَنْعَانَ. فَأَتَى إِبْرَاهِيمُ لِيَنْدُبَ سَارَةَ وَيَبْكِيَ عَلَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","وَقَامَ إِبْرَاهِيمُ مِنْ أَمَامِ مَيِّتِهِ وَكَلَّمَ بَنِي حِثَّ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«أَنَا غَرِيبٌ وَنَزِيلٌ عِنْدَكُمْ. أَعْطُونِي مُلْكَ قَبْرٍ مَعَكُمْ لِأَدْفِنَ مَيْتِي مِنْ أَمَامِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","فَأَجَابَ بَنُو حِثَّ إِبْرَاهِيمَ قَائِلِينَ لَهُ: ");
INSERT INTO arb_vd_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«اِسْمَعْنَا يَا سَيِّدِي. أَنْتَ رَئِيسٌ مِنَ ٱللهِ بَيْنَنَا. فِي أَفْضَلِ قُبُورِنَا ٱدْفِنْ مَيْتَكَ، لَا يَمْنَعُ أَحَدٌ مِنَّا قَبْرَهُ عَنْكَ حَتَّى لَا تَدْفِنَ مَيْتَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","فَقَامَ إِبْرَاهِيمُ وَسَجَدَ لِشَعْبِ ٱلْأَرْضِ، لِبَنِي حِثَّ، ");
INSERT INTO arb_vd_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","وَكَلَّمَهُمْ قَائِلًا: «إِنْ كَانَ فِي نُفُوسِكُمْ أَنْ أَدْفِنَ مَيْتِي مِنْ أَمَامِي، فَٱسْمَعُونِي وَٱلْتَمِسُوا لِي مِنْ عِفْرُونَ بْنِ صُوحَرَ ");
INSERT INTO arb_vd_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","أَنْ يُعْطِيَنِي مَغَارَةَ ٱلْمَكْفِيلَةِ ٱلَّتِي لَهُ، ٱلَّتِي فِي طَرَفِ حَقْلِهِ. بِثَمَنٍ كَامِلٍ يُعْطِينِي إِيَّاهَا فِي وَسَطِكُمْ مُلْكَ قَبْرٍ». ");
INSERT INTO arb_vd_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","وَكَانَ عِفْرُونُ جَالِسًا بَيْنَ بَنِي حِثَّ، فَأَجَابَ عِفْرُونُ ٱلْحِثِّيُّ إِبْرَاهِيمَ فِي مَسَامِعِ بَنِي حِثَّ، لَدَى جَمِيعِ ٱلدَّاخِلِينَ بَابَ مَدِينَتِهِ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«لَا يَا سَيِّدِي، ٱسْمَعْنِي. اَلْحَقْلُ وَهَبْتُكَ إِيَّاهُ، وَٱلْمَغَارَةُ ٱلَّتِي فِيهِ لَكَ وَهَبْتُهَا. لَدَى عُيُونِ بَنِي شَعْبِي وَهَبْتُكَ إِيَّاهَا. ٱدْفِنْ مَيْتَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","فَسَجَدَ إِبْرَاهِيمُ أَمَامَ شَعْبِ ٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","وَكَلَمَ عِفْرُونَ فِي مَسَامِعِ شَعْبِ ٱلْأَرْضِ قَائِلًا: «بَلْ إِنْ كُنْتَ أَنْتَ إِيَّاهُ فَلَيْتَكَ تَسْمَعُنِي. أُعْطِيكَ ثَمَنَ ٱلْحَقْلِ. خُذْ مِنِّي فَأَدْفِنَ مَيْتِي هُنَاكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","فَأَجَابَ عِفْرُونُ إِبْرَاهِيمَ قَائِلًا لَهُ: ");
INSERT INTO arb_vd_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«يَا سَيِّدِي، ٱسْمَعْنِي. أَرْضٌ بِأَرْبَعِ مِئَةِ شَاقِلِ فِضَّةٍ، مَا هِيَ بَيْنِي وَبَيْنَكَ؟ فَٱدْفِنْ مَيْتَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","فَسَمِعَ إِبْرَاهِيمُ لِعِفْرُونَ، وَوَزَنَ إِبْرَاهِيمُ لِعِفْرُونَ ٱلْفِضَّةَ ٱلَّتِي ذَكَرَهَا فِي مَسَامِعِ بَنِي حِثَّ. أَرْبَعَ مِئَةِ شَاقِلِ فِضَّةٍ جَائِزَةٍ عِنْدَ ٱلتُّجَّارِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","فَوَجَبَ حَقْلُ عِفْرُونَ ٱلَّذِي فِي ٱلْمَكْفِيلَةِ ٱلَّتِي أَمَامَ مَمْرَا، ٱلْحَقْلُ وَٱلْمَغَارَةُ ٱلَّتِي فِيهِ، وَجَمِيعُ ٱلشَّجَرِ ٱلَّذِي فِي ٱلْحَقْلِ ٱلَّذِي فِي جَمِيعِ حُدُودِهِ حَوَالَيْهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","لِإِبْرَاهِيمَ مُلْكًا لَدَى عُيُونِ بَنِي حِثَّ، بَيْنَ جَمِيعِ ٱلدَّاخِلِينَ بَابَ مَدِينَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","وَبَعْدَ ذَلِكَ دَفَنَ إِبْرَاهِيمُ سَارَةَ ٱمْرَأَتَهُ فِي مَغَارَةِ حَقْلِ ٱلْمَكْفِيلَةِ أَمَامَ مَمْرَا، ٱلَّتِي هِيَ حَبْرُونُ، فِي أَرْضِ كَنْعَانَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","فَوَجَبَ ٱلْحَقْلُ وَٱلْمَغَارَةُ ٱلَّتِي فِيهِ لِإِبْرَاهِيمَ مُلْكَ قَبْرٍ مِنْ عِنْدِ بَنِي حِثَّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","وَشَاخَ إِبْرَاهِيمُ وَتَقَدَّمَ فِي ٱلْأَيَّامِ. وَبَارَكَ ٱلرَّبُّ إِبْرَاهِيمَ فِي كُلِّ شَيْءٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","وَقَالَ إِبْرَاهِيمُ لِعَبْدِهِ كَبِيرِ بَيْتِهِ ٱلْمُسْتَوْلِي عَلَى كُلِّ مَا كَانَ لَهُ: «ضَعْ يَدَكَ تَحْتَ فَخْذِي، ");
INSERT INTO arb_vd_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","فَأَسْتَحْلِفَكَ بِٱلرَّبِّ إِلَهِ ٱلسَّمَاءِ وَإِلَهِ ٱلْأَرْضِ أَنْ لَا تَأْخُذَ زَوْجَةً لِٱبْنِي مِنْ بَنَاتِ ٱلْكَنْعَانِيِّينَ ٱلَّذِينَ أَنَا سَاكِنٌ بَيْنَهُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","بَلْ إِلَى أَرْضِي وَإِلَى عَشِيرَتِي تَذْهَبُ وَتَأْخُذُ زَوْجَةً لِٱبْنِي إِسْحَاقَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","فَقَالَ لَهُ ٱلْعَبْدُ: «رُبَّمَا لَا تَشَاءُ ٱلْمَرْأَةُ أَنْ تَتْبَعَنِي إِلَى هَذِهِ ٱلْأَرْضِ. هَلْ أَرْجِعُ بِٱبْنِكَ إِلَى ٱلْأَرْضِ ٱلَّتِي خَرَجْتَ مِنْهَا؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","فَقَالَ لَهُ إِبْرَاهِيمُ: «ٱحْتَرِزْ مِنْ أَنْ تَرْجِعَ بِٱبْنِي إِلَى هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","اَلرَّبُّ إِلَهُ ٱلسَّمَاءِ ٱلَّذِي أَخَذَنِي مِنْ بَيْتِ أَبِي وَمِنْ أَرْضِ مِيلَادِي، وَٱلَّذِي كَلَّمَنِي وَٱلَّذِي أَقْسَمَ لِي قَائِلًا: لِنَسْلِكَ أُعْطِي هَذِهِ ٱلْأَرْضَ، هُوَ يُرْسِلُ مَلَاكَهُ أَمَامَكَ، فَتَأْخُذُ زَوْجَةً لِٱبْنِي مِنْ هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","وَإِنْ لَمْ تَشَإِ ٱلْمَرْأَةُ أَنْ تَتْبَعَكَ، تَبَرَّأْتَ مِنْ حَلْفِي هَذَا. أَمَّا ٱبْنِي فَلَا تَرْجِعْ بِهِ إِلَى هُنَاكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","فَوَضَعَ ٱلْعَبْدُ يَدَهُ تَحْتَ فَخْذِ إِبْرَاهِيمَ مَوْلَاهُ، وَحَلَفَ لَهُ عَلَى هَذَا ٱلْأَمْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ثُمَّ أَخَذَ ٱلْعَبْدُ عَشْرَةَ جِمَالٍ مِنْ جِمَالِ مَوْلَاهُ، وَمَضَى وَجَمِيعُ خَيْرَاتِ مَوْلَاهُ فِي يَدِهِ. فَقَامَ وَذَهَبَ إِلَى أَرَامِ ٱلنَّهْرَيْنِ إِلَى مَدِينَةِ نَاحُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","وَأَنَاخَ ٱلْجِمَالَ خَارِجَ ٱلْمَدِينَةِ عِنْدَ بِئْرِ ٱلْمَاءِ وَقْتَ ٱلْمَسَاءِ، وَقْتَ خُرُوجِ ٱلْمُسْتَقِيَاتِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","وَقَالَ: «أَيُّهَا ٱلرَّبُّ إِلَهَ سَيِّدِي إِبْرَاهِيمَ، يَسِّرْ لِي ٱلْيَوْمَ وَٱصْنَعْ لُطْفًا إِلَى سَيِّدِي إِبْرَاهِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","هَا أَنَا وَاقِفٌ عَلَى عَيْنِ ٱلْمَاءِ، وَبَنَاتُ أَهْلِ ٱلْمَدِينَةِ خَارِجَاتٌ لِيَسْتَقِينَ مَاءً. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","فَلْيَكُنْ أَنَّ ٱلْفَتَاةَ ٱلَّتِي أَقُولُ لَهَا: أَمِيلِي جَرَّتَكِ لِأَشْرَبَ، فَتَقُولَ: ٱشْرَبْ وَأَنَا أَسْقِي جِمَالَكَ أَيْضًا، هِيَ ٱلَّتِي عَيَّنْتَهَا لِعَبْدِكَ إِسْحَاقَ. وَبِهَا أَعْلَمُ أَنَّكَ صَنَعْتَ لُطْفًا إِلَى سَيِّدِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","وَإِذْ كَانَ لَمْ يَفْرَغْ بَعْدُ مِنَ ٱلْكَلَامِ، إِذَا رِفْقَةُ ٱلَّتِي وُلِدَتْ لِبَتُوئِيلَ ٱبْنِ مِلْكَةَ ٱمْرَأَةِ نَاحُورَ أَخِي إِبْرَاهِيمَ، خَارِجَةٌ وَجَرَّتُهَا عَلَى كَتِفِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","وَكَانَتِ ٱلْفَتَاةُ حَسَنَةَ ٱلْمَنْظَرِ جِدًّا، وَعَذْرَاءَ لَمْ يَعْرِفْهَا رَجُلٌ. فَنَزَلَتْ إِلَى ٱلْعَيْنِ وَمَلَأَتْ جَرَّتَهَا وَطَلَعَتْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","فَرَكَضَ ٱلْعَبْدُ لِلِقَائِهَا وَقَالَ: «ٱسْقِينِي قَلِيلَ مَاءٍ مِنْ جَرَّتِكِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","فَقَالَتِ: «ٱشْرَبْ يَا سَيِّدِي». وَأَسْرَعَتْ وَأَنْزَلَتْ جَرَّتَهَا عَلَى يَدِهَا وَسَقَتْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","وَلَمَّا فَرَغَتْ مِنْ سَقْيِهِ قَالَتْ: «أَسْتَقِي لِجِمَالِكَ أَيْضًا حَتَّى تَفْرَغَ مِنَ ٱلشُّرْبِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","فَأَسْرَعَتْ وَأَفْرَغَتْ جَرَّتَهَا فِي ٱلْمَسْقَاةِ، وَرَكَضَتْ أَيْضًا إِلَى ٱلْبِئْرِ لِتَسْتَقِيَ، فَٱسْتَقَتْ لِكُلِّ جِمَالِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","وَٱلرَّجُلُ يَتَفَرَّسُ فِيهَا صَامِتًا لِيَعْلَمَ: أَأَنْجَحَ ٱلرَّبُّ طَرِيقَهُ أَمْ لَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","وَحَدَثَ عِنْدَمَا فَرَغَتِ ٱلْجِمَالُ مِنَ ٱلشُّرْبِ أَنَّ ٱلرَّجُلَ أَخَذَ خِزَامَةَ ذَهَبٍ وَزْنُهَا نِصْفُ شَاقِلٍ وَسِوَارَيْنِ عَلَى يَدَيْهَا وَزْنُهُمَا عَشْرَةُ شَوَاقِلِ ذَهَبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","وَقَالَ: «بِنْتُ مَنْ أَنْتِ؟ أَخْبِرِينِي: هَلْ فِي بَيْتِ أَبِيكِ مَكَانٌ لَنَا لِنَبِيتَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","فَقَالَتْ لَهُ: «أَنَا بِنْتُ بَتُوئِيلَ ٱبْنِ مِلْكَةَ ٱلَّذِي وَلَدَتْهُ لِنَاحُورَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","وَقَالَتْ لَهُ: «عِنْدَنَا تِبْنٌ وَعَلَفٌ كَثِيرٌ، وَمَكَانٌ لِتَبِيتُوا أَيْضًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","فَخَرَّ ٱلرَّجُلُ وَسَجَدَ لِلرَّبِّ، ");
INSERT INTO arb_vd_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","وَقَالَ: «مُبَارَكٌ ٱلرَّبُّ إِلَهُ سَيِّدِي إِبْرَاهِيمَ ٱلَّذِي لَمْ يَمْنَعْ لُطْفَهُ وَحَقَّهُ عَنْ سَيِّدِي. إِذْ كُنْتُ أَنَا فِي ٱلطَّرِيقِ، هَدَانِي ٱلرَّبُّ إِلَى بَيْتِ إِخْوَةِ سَيِّدِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","فَرَكَضَتِ ٱلْفَتَاةُ وَأَخْبَرَتْ بَيْتَ أُمِّهَا بِحَسَبِ هَذِهِ ٱلْأُمُورِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","وَكَانَ لِرِفْقَةَ أَخٌ ٱسْمُهُ لَابَانُ، فَرَكَضَ لَابَانُ إِلَى ٱلرَّجُلِ خَارِجًا إِلَى ٱلْعَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","وَحَدَثَ أَنَّهُ إِذْ رَأَى ٱلْخِزَامَةَ وَٱلسِّوَارَيْنِ عَلَى يَدَيْ أُخْتِهِ، وَإِذْ سَمِعَ كَلَامَ رِفْقَةَ أُخْتِهِ قَائِلَةً: «هَكَذَا كَلَّمَنِي ٱلرَّجُلُ»، جَاءَ إِلَى ٱلرَّجُلِ، وَإِذَا هُوَ وَاقِفٌ عِنْدَ ٱلْجِمَالِ عَلَى ٱلْعَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","فَقَالَ: «ٱدْخُلْ يَا مُبَارَكَ ٱلرَّبِّ، لِمَاذَا تَقِفُ خَارِجًا وَأَنَا قَدْ هَيَّأْتُ ٱلْبَيْتَ وَمَكَانًا لِلْجِمَالِ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","فَدَخَلَ ٱلرَّجُلُ إِلَى ٱلْبَيْتِ وَحَلَّ عَنِ ٱلْجِمَالِ، فَأَعْطَى تِبْنًا وَعَلَفًا لِلْجِمَالِ، وَمَاءً لِغَسْلِ رِجْلَيْهِ وَأَرْجُلِ ٱلرِّجَالِ ٱلَّذِينَ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","وَوُضِعَ قُدَّامَهُ لِيَأْكُلَ. فَقَالَ: «لَا آكُلُ حَتَّى أَتَكَلَّمَ كَلَامِي». فَقَالَ: «تَكَلَّمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","فَقَالَ: «أَنَا عَبْدُ إِبْرَاهِيمَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","وَٱلرَّبُّ قَدْ بَارَكَ مَوْلَايَ جِدًّا فَصَارَ عَظِيمًا، وَأَعْطَاهُ غَنَمًا وَبَقَرًا وَفِضَّةً وَذَهَبًا وَعَبِيدًا وَإِمَاءً وَجِمَالًا وَحَمِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","وَوَلَدَتْ سَارَةُ ٱمْرَأَةُ سَيِّدِي ٱبْنًا لِسَيِّدِي بَعْدَ مَاشَاخَتْ، فَقَدْ أَعْطَاهُ كُلَّ مَا لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","وَٱسْتَحْلَفَنِي سَيِّدِي قَائِلًا: لَا تَأْخُذْ زَوْجَةً لِٱبْنِي مِنْ بَنَاتِ ٱلْكَنْعَانِيِّينَ ٱلَّذِينَ أَنَا سَاكِنٌ فِي أَرْضِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","بَلْ إِلَى بَيْتِ أَبِي تَذْهَبُ وَإِلَى عَشِيرَتِي، وَتَأْخُذُ زَوْجَةً لِٱبْنِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","فَقُلْتُ لِسَيِّدِي: رُبَّمَا لَا تَتْبَعُنِي ٱلْمَرْأَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","فَقَالَ لِي: إِنَّ ٱلرَّبَّ ٱلَّذِي سِرْتُ أَمَامَهُ يُرْسِلُ مَلَاكَهُ مَعَكَ وَيُنْجِحُ طَرِيقَكَ، فَتَأْخُذُ زَوْجَةً لِٱبْنِي مِنْ عَشِيرَتِي وَمِنْ بَيْتِ أَبِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","حِينَئِذٍ تَتَبَرَّأُ مِنْ حَلْفِي حِينَمَا تَجِيءُ إِلَى عَشِيرَتِي. وَإِنْ لَمْ يُعْطُوكَ فَتَكُونُ بَرِيئًا مِنْ حَلْفِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","فَجِئْتُ ٱلْيَوْمَ إِلَى ٱلْعَيْنِ، وَقُلْتُ: أَيُّهَا ٱلرَّبُّ إِلَهُ سَيِّدِي إِبْرَاهِيمَ، إِنْ كُنْتَ تُنْجِحُ طَرِيقِي ٱلَّذِي أَنَا سَالِكٌ فِيهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","فَهَا أَنَا وَاقِفٌ عَلَى عَيْنِ ٱلْمَاءِ، وَلْيَكُنْ أَنَّ ٱلْفَتَاةَ ٱلَّتِي تَخْرُجُ لِتَسْتَقِيَ وَأَقُولُ لَهَا: ٱسْقِينِي قَلِيلَ مَاءٍ مِنْ جَرَّتِكِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","فَتَقُولَ لِيَ: ٱشْرَبْ أَنْتَ، وَأَنَا أَسْتَقِي لِجِمَالِكَ أَيْضًا، هِيَ ٱلْمَرْأَةُ ٱلَّتِي عَيَّنَهَا ٱلرَّبُّ لِٱبْنِ سَيِّدِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","وَإِذْ كُنْتُ أَنَا لَمْ أَفْرَغْ بَعْدُ مِنَ ٱلْكَلَامِ فِي قَلْبِي، إِذَا رِفْقَةُ خَارِجَةٌ وَجَرَّتُهَا عَلَى كَتِفِهَا، فَنَزَلَتْ إِلَى ٱلْعَيْنِ وَٱسْتَقَتْ. فَقُلْتُ لَهَا: ٱسْقِينِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","فَأَسْرَعَتْ وَأَنْزَلَتْ جَرَّتَهَا عَنْهَا وَقَالَتِ: ٱشْرَبْ وَأَنَا أَسْقِي جِمَالَكَ أَيْضًا. فَشَرِبْتُ، وَسَقَتِ ٱلْجِمَالَ أَيْضًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","فَسَأَلْتُهَا وَقُلتُ: بِنْتُ مَنْ أَنْتِ؟ فَقَالَتْ: بِنْتُ بَتُوئِيلَ بْنِ نَاحُورَ ٱلَّذِي وَلَدَتْهُ لَهُ مِلْكَةُ. فَوَضَعْتُ ٱلْخِزَامَةَ فِي أَنْفِهَا وَٱلسِّوَارَيْنِ عَلَى يَدَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","وَخَرَرْتُ وَسَجَدْتُ لِلرَّبِّ، وَبَارَكْتُ ٱلرَّبَّ إِلَهَ سَيِّدِي إِبْرَاهِيمَ ٱلَّذِي هَدَانِي فِي طَرِيقٍ أَمِينٍ لِآخُذَ ٱبْنَةَ أَخِي سَيِّدِي لِٱبْنِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","وَٱلْآنَ إِنْ كُنْتُمْ تَصْنَعُونَ مَعْرُوفًا وَأَمَانَةً إِلَى سَيِّدِي فَأَخْبِرُونِي، وَإِلَا فَأَخْبِرُونِي لِأَنْصَرِفَ يَمِينًا أَوْ شِمَالًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","فَأَجَابَ لَابَانُ وَبَتُوئِيلُ وَقَالَا: «مِنْ عِنْدِ ٱلرَّبِّ خَرَجَ ٱلْأَمْرُ. لَا نَقْدِرُ أَنْ نُكَلِّمَكَ بِشَرٍّ أَوْ خَيْرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","هُوَذَا رِفْقَةُ قُدَّامَكَ. خُذْهَا وَٱذْهَبْ. فَلْتَكُنْ زَوْجَةً لِٱبْنِ سَيِّدِكَ، كَمَا تَكَلَّمَ ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","وَكَانَ عِنْدَمَا سَمِعَ عَبْدُ إِبْرَاهِيمَ كَلَامَهُمْ أَنَّهُ سَجَدَ لِلرَّبِّ إِلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","وَأَخْرَجَ ٱلْعَبْدُ آنِيَةَ فِضَّةٍ وَآنِيَةَ ذَهَبٍ وَثِيَابًا وَأَعْطَاهَا لِرِفْقَةَ، وَأَعْطَى تُحَفًا لِأَخِيهَا وَلِأُمِّهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","فَأَكَلَ وَشَرِبَ هُوَ وَٱلرِّجَالُ ٱلَّذِينَ مَعَهُ وَبَاتُوا. ثُمَّ قَامُوا صَبَاحًا فَقَالَ: «ٱصْرِفُونِي إِلَى سَيِّدِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","فَقَالَ أَخُوهَا وَأُمُّهَا: «لِتَمْكُثِ ٱلْفَتَاةُ عِنْدَنَا أَيَّامًا أَوْ عَشْرَةً، بَعْدَ ذَلِكَ تَمْضِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","فَقَالَ لَهُمْ: «لَا تُعَوِّقُونِي وَٱلرَّبُّ قَدْ أَنْجَحَ طَرِيقِي. اِصْرِفُونِي لِأَذْهَبَ إِلَى سَيِّدِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","فَقَالُوا: «نَدْعُو ٱلْفَتَاةَ وَنَسْأَلُهَا شِفَاهًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","فَدَعَوْا رِفْقَةَ وَقَالُوا لَهَا: «هَلْ تَذْهَبِينَ مَعَ هَذَا ٱلرَّجُلِ؟» فَقَالَتْ: «أَذْهَبُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","فَصَرَفُوا رِفْقَةَ أُخْتَهُمْ وَمُرْضِعَتَهَا وَعَبْدَ إِبْرَاهِيمَ وَرِجَالَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","وَبَارَكُوا رِفْقَةَ وَقَالُوا لَهَا: «أَنْتِ أُخْتُنَا. صِيرِي أُلُوفَ رِبْوَاتٍ، وَلْيَرِثْ نَسْلُكِ بَابَ مُبْغِضِيهِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","فَقَامَتْ رِفْقَةُ وَفَتَيَاتُهَا وَرَكِبْنَ عَلَى ٱلْجِمَالِ وَتَبِعْنَ ٱلرَّجُلَ. فَأَخَذَ ٱلْعَبْدُ رِفْقَةَ وَمَضَى. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","وَكَانَ إِسْحَاقُ قَدْ أَتَى مِنْ وُرُودِ بِئْرِ لَحَيْ رُئِي، إِذْ كَانَ سَاكِنًا فِي أَرْضِ ٱلْجَنُوبِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","وَخَرَجَ إِسْحَاقُ لِيَتَأَمَّلَ فِي ٱلْحَقْلِ عِنْدَ إِقْبَالِ ٱلْمَسَاءِ، فَرَفَعَ عَيْنَيْهِ وَنَظَرَ وَإِذَا جِمَالٌ مُقْبِلَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","وَرَفَعَتْ رِفْقَةُ عَيْنَيْهَا فَرَأَتْ إِسْحَاقَ فَنَزَلَتْ عَنِ ٱلْجَمَلِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","وَقَالَتْ لِلْعَبْدِ: «مَنْ هَذَا ٱلرَّجُلُ ٱلْمَاشِي فِي ٱلْحَقْلِ لِلِقَائِنَا؟» فَقَالَ ٱلْعَبْدُ: «هُوَ سَيِّدِي». فَأَخَذَتِ ٱلْبُرْقُعَ وَتَغَطَّتْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ثُمَّ حَدَّثَ ٱلْعَبْدُ إِسْحَاقَ بِكُلِّ ٱلْأُمُورِ ٱلَّتِي صَنَعَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","فَأَدْخَلَهَا إِسْحَاقُ إِلَى خِبَاءِ سَارَةَ أُمِّهِ، وَأَخَذَ رِفْقَةَ فَصَارَتْ لَهُ زَوْجَةً وَأَحَبَّهَا. فَتَعَزَّى إِسْحَاقُ بَعْدَ مَوْتِ أُمِّهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","وَعَادَ إِبْرَاهِيمُ فَأَخَذَ زَوْجَةً ٱسْمُهَا قَطُورَةُ، ");
INSERT INTO arb_vd_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","فَوَلَدَتْ لَهُ: زِمْرَانَ وَيَقْشَانَ وَمَدَانَ وَمِدْيَانَ وَيِشْبَاقَ وَشُوحًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","وَوَلَدَ يَقْشَانُ: شَبَا وَدَدَانَ. وَكَانَ بَنُو دَدَانَ: أَشُّورِيمَ وَلَطُوشِيمَ وَلَأُمِّيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","وَبَنُو مِدْيَانَ: عَيْفَةُ وَعِفْرُ وَحَنُوكُ وَأَبِيدَاعُ وَأَلْدَعَةُ. جَمِيعُ هَؤُلَاءِ بَنُو قَطُورَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","وَأَعْطَى إِبْرَاهِيمُ إِسْحَاقَ كُلَّ مَا كَانَ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","وَأَمَّا بَنُو ٱلسَّرَارِيِّ ٱللَّوَاتِي كَانَتْ لِإِبْرَاهِيمَ فَأَعْطَاهُمْ إِبْرَاهِيمُ عَطَايَا، وَصَرَفَهُمْ عَنْ إِسْحَاقَ ٱبْنِهِ شَرْقًا إِلَى أَرْضِ ٱلْمَشْرِقِ، وَهُوَ بَعْدُ حَيٌّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","وَهَذِهِ أَيَّامُ سِنِي حَيَاةِ إِبْرَاهِيمَ ٱلَّتِي عَاشَهَا: مِئَةٌ وَخَمْسٌ وَسَبْعُونَ سَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","وَأَسْلَمَ إِبْرَاهِيمُ رُوحَهُ وَمَاتَ بِشَيْبَةٍ صَالِحَةٍ، شَيْخًا وَشَبْعَانَ أَيَّامًا، وَٱنْضَمَّ إِلَى قَوْمِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","وَدَفَنَهُ إِسْحَاقُ وَإِسْمَاعِيلُ ٱبْنَاهُ فِي مَغَارَةِ ٱلْمَكْفِيلَةِ فِي حَقْلِ عِفْرُونَ بْنِ صُوحَرَ ٱلْحِثِّيِّ ٱلَّذِي أَمَامَ مَمْرَا، ");
INSERT INTO arb_vd_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ٱلْحَقْلِ ٱلَّذِي ٱشْتَرَاهُ إِبْرَاهِيمُ مِنْ بَنِي حِثٍّ. هُنَاكَ دُفِنَ إِبْرَاهِيمُ وَسَارَةُ ٱمْرَأَتُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","وَكَانَ بَعْدَ مَوْتِ إِبْرَاهِيمَ أَنَّ ٱللهَ بَارَكَ إِسْحَاقَ ٱبْنَهُ. وَسَكَنَ إِسْحَاقُ عِنْدَ بِئْرِ لَحَيْ رُئِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","وَهَذِهِ مَوَالِيدُ إِسْمَاعِيلَ بْنِ إِبْرَاهِيمَ، ٱلَّذِي وَلَدَتْهُ هَاجَرُ ٱلْمِصْرِيَّةُ جَارِيَةُ سَارَةَ لِإِبْرَاهِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","وَهَذِهِ أَسْمَاءُ بَنِي إِسْمَاعِيلَ بِأَسْمَائِهِمْ حَسَبَ مَوَالِيدِهِمْ: نَبَايُوتُ بِكْرُ إِسْمَاعِيلَ، وَقِيدَارُ، وَأَدَبْئِيلُ وَمِبْسَامُ ");
INSERT INTO arb_vd_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","وَمِشْمَاعُ وَدُومَةُ وَمَسَّا ");
INSERT INTO arb_vd_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","وَحَدَارُ وَتَيْمَا وَيَطُورُ وَنَافِيشُ وَقِدْمَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","هَؤُلَاءِ هُمْ بَنُو إِسْمَاعِيلَ، وَهَذِهِ أَسْمَاؤُهُمْ بِدِيَارِهِمْ وَحُصُونِهِمْ. ٱثْنَا عَشَرَ رَئِيسًا حَسَبَ قَبَائِلِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","وَهَذِهِ سِنُو حَيَاةِ إِسْمَاعِيلَ: مِئَةٌ وَسَبْعٌ وَثَلَاثُونَ سَنَةً، وَأَسْلَمَ رُوحَهُ وَمَاتَ وَٱنْضَمَّ إِلَى قَوْمِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","وَسَكَنُوا مِنْ حَوِيلَةَ إِلَى شُورَ ٱلَّتِي أَمَامَ مِصْرَ حِينَمَا تَجِيءُ نَحْوَ أَشُّورَ. أَمَامَ جَمِيعِ إِخْوَتِهِ نَزَلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","وَهَذِهِ مَوَالِيدُ إِسْحَاقَ بْنِ إِبْرَاهِيمَ: وَلَدَ إِبْرَاهِيمُ إِسْحَاقَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","وَكَانَ إِسْحَاقُ ٱبْنَ أَرْبَعِينَ سَنَةً لَمَّا ٱتَّخَذَ لِنَفْسِهِ زَوْجَةً، رِفْقَةَ بِنْتَ بَتُوئِيلَ ٱلْأَرَامِيِّ، أُخْتَ لَابَانَ ٱلْأَرَامِيِّ مِنْ فَدَّانِ أَرَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","وَصَلَّى إِسْحَاقُ إِلَى ٱلرَّبِّ لِأَجْلِ ٱمْرَأَتِهِ لِأَنَّهَا كَانَتْ عَاقِرًا، فَٱسْتَجَابَ لَهُ ٱلرَّبُّ، فَحَبِلَتْ رِفْقَةُ ٱمْرَأَتُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","وَتَزَاحَمَ ٱلْوَلَدَانِ فِي بَطْنِهَا، فَقَالَتْ: «إِنْ كَانَ هَكَذَا فَلِمَاذَا أَنَا؟» فَمَضَتْ لِتَسْأَلَ ٱلرَّبَّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","فَقَالَ لَهَا ٱلرَّبُّ: «فِي بَطْنِكِ أُمَّتَانِ، وَمِنْ أَحْشَائِكِ يَفْتَرِقُ شَعْبَانِ: شَعْبٌ يَقْوَى عَلَى شَعْبٍ، وَكَبِيرٌ يُسْتَعْبَدُ لِصَغِيرٍ». ");
INSERT INTO arb_vd_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","فَلَمَّا كَمُلَتْ أَيَّامُهَا لِتَلِدَ إِذَا فِي بَطْنِهَا تَوْأَمَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","فَخَرَجَ ٱلْأوَّلُ أَحْمَرَ، كُلُّهُ كَفَرْوَةِ شَعْرٍ، فَدَعَوْا ٱسْمَهُ «عِيسُوَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","وَبَعْدَ ذَلِكَ خَرَجَ أَخُوهُ وَيَدُهُ قَابِضَةٌ بِعَقِبِ عِيسُو، فَدُعِيَ ٱسْمُهُ «يَعْقُوبَ». وَكَانَ إِسْحَاقُ ٱبْنَ سِتِّينَ سَنَةً لَمَّا وَلَدَتْهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","فَكَبِرَ ٱلْغُلَامَانِ، وَكَانَ عِيسُو إِنْسَانًا يَعْرِفُ ٱلصَّيْدَ، إِنْسَانَ ٱلْبَرِّيَّةِ، وَيَعْقُوبُ إِنْسَانًا كَامِلًا يَسْكُنُ ٱلْخِيَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","فَأَحَبَّ إِسْحَاقُ عِيسُوَ لِأَنَّ فِي فَمِهِ صَيْدًا، وَأَمَّا رِفْقَةُ فَكَانَتْ تُحِبُّ يَعْقُوبَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","وَطَبَخَ يَعْقُوبُ طَبِيخًا، فَأَتَى عِيسُو مِنَ ٱلْحَقْلِ وَهُوَ قَدْ أَعْيَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","فَقَالَ عِيسُو لِيَعْقُوبَ: «أَطْعِمْنِي مِنْ هَذَا ٱلْأَحْمَرِ لِأَنِّي قَدْ أَعْيَيْتُ». لِذَلِكَ دُعِيَ ٱسْمُهُ «أَدُومَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","فَقَالَ يَعْقُوبُ: «بِعْنِي ٱلْيَوْمَ بَكُورِيَّتَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","فَقَالَ عِيسُو: «هَا أَنَا مَاضٍ إِلَى ٱلْمَوْتِ، فَلِمَاذَا لِي بَكُورِيَّةٌ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","فَقَالَ يَعْقُوبُ: «ٱحْلِفْ لِيَ ٱلْيَوْمَ». فَحَلَفَ لَهُ، فَبَاعَ بَكُورِيَّتَهُ لِيَعْقُوبَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","فَأَعْطَى يَعْقُوبُ عِيسُوَ خُبْزًا وَطَبِيخَ عَدَسٍ، فَأَكَلَ وَشَرِبَ وَقَامَ وَمَضَى. فَٱحْتَقَرَ عِيسُو ٱلْبَكُورِيَّةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","وَكَانَ فِي ٱلْأَرْضِ جُوعٌ غَيْرُ ٱلْجُوعِ ٱلْأَوَّلِ ٱلَّذِي كَانَ فِي أَيَّامِ إِبْرَاهِيمَ، فَذَهَبَ إِسْحَاقُ إِلَى أَبِيمَالِكَ مَلِكِ ٱلْفِلِسْطِينِيِّينَ، إِلَى جَرَارَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","وَظَهَرَ لَهُ ٱلرَّبُّ وَقَالَ: «لَا تَنْزِلْ إِلَى مِصْرَ. ٱسْكُنْ فِي ٱلْأَرْضِ ٱلَّتِي أَقُولُ لَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","تَغَرَّبْ فِي هَذِهِ ٱلْأَرْضِ فَأَكُونَ مَعَكَ وَأُبَارِكَكَ، لِأَنِّي لَكَ وَلِنَسْلِكَ أُعْطِي جَمِيعَ هَذِهِ ٱلْبِلَادِ، وَأَفِي بِٱلْقَسَمِ ٱلَّذِي أَقْسَمْتُ لِإِبْرَاهِيمَ أَبِيكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","وَأُكَثِّرُ نَسْلَكَ كَنُجُومِ ٱلسَّمَاءِ، وَأُعْطِي نَسْلَكَ جَمِيعَ هَذِهِ ٱلْبِلَادِ، وَتَتَبَارَكُ فِي نَسْلِكَ جَمِيعُ أُمَمِ ٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","مِنْ أَجْلِ أَنَّ إِبْرَاهِيمَ سَمِعَ لِقَوْلِي وَحَفِظَ مَا يُحْفَظُ لِي: أَوَامِرِي وَفَرَائِضِي وَشَرَائِعِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","فَأَقَامَ إِسْحَاقُ فِي جَرَارَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","وَسَأَلَهُ أَهْلُ ٱلْمَكَانِ عَنِ ٱمْرَأَتِهِ، فَقَالَ: «هِيَ أُخْتِي». لِأَنَّهُ خَافَ أَنْ يَقُولَ: «ٱمْرَأَتِي» لَعَلَّ أَهْلَ ٱلْمَكَانِ: «يَقْتُلُونَنِي مِنْ أَجْلِ رِفْقَةَ» لِأَنَّهَا كَانَتْ حَسَنَةَ ٱلْمَنْظَرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","وَحَدَثَ إِذْ طَالَتْ لَهُ ٱلْأَيَّامُ هُنَاكَ أَنَّ أَبِيمَالِكَ مَلِكَ ٱلْفِلِسْطِينِيِّينَ أَشْرَفَ مِنَ ٱلْكُوَّةِ وَنَظَرَ، وَإِذَا إِسْحَاقُ يُلَاعِبُ رِفْقَةَ ٱمْرَأَتَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","فَدَعَا أَبِيمَالِكُ إِسْحَاقَ وَقَالَ: «إِنَّمَا هِيَ ٱمْرَأَتُكَ! فَكَيْفَ قُلْتَ: هِيَ أُخْتِي؟» فَقَالَ لَهُ إِسْحَاقُ: «لِأَنِّي قُلْتُ: لَعَلِّي أَمُوتُ بِسَبَبِهَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","فَقَالَ أَبِيمَالِكُ: «مَا هَذَا ٱلَّذِي صَنَعْتَ بِنَا؟ لَوْلَا قَلِيلٌ لَٱضْطَجَعَ أَحَدُ ٱلشَّعْبِ مَعَ ٱمْرَأَتِكَ فَجَلَبْتَ عَلَيْنَا ذَنْبًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","فَأَوْصَى أَبِيمَالِكُ جَمِيعَ ٱلشَّعْبِ قَائِلًا: «ٱلَّذِي يَمَسُّ هَذَا ٱلرَّجُلَ أَوِ ٱمْرَأَتَهُ مَوْتًا يَمُوتُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","وَزَرَعَ إِسْحَاقُ فِي تِلْكَ ٱلْأَرْضِ فَأَصَابَ فِي تِلْكَ ٱلسَّنَةِ مِئَةَ ضِعْفٍ، وَبَارَكَهُ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","فَتَعَاظَمَ ٱلرَّجُلُ وَكَانَ يَتَزَايَدُ فِي ٱلتَّعَاظُمِ حَتَّى صَارَ عَظِيمًا جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","فَكَانَ لَهُ مَوَاشٍ مِنَ ٱلْغَنَمِ وَمَوَاشٍ مِنَ ٱلْبَقَرِ وَعَبِيدٌ كَثِيرُونَ. فَحَسَدَهُ ٱلْفِلِسْطِينِيُّونَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","وَجَمِيعُ ٱلْآبَارِ، ٱلَّتِي حَفَرَهَا عَبِيدُ أَبِيهِ فِي أَيَّامِ إِبْرَاهِيمَ أَبِيهِ، طَمَّهَا ٱلْفِلِسْطِينِيُّونَ وَمَلَأُوهَا تُرَابًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","وَقَالَ أَبِيمَالِكُ لِإِسْحَاقَ: «ٱذْهَبْ مِنْ عِنْدِنَا لِأَنَّكَ صِرْتَ أَقْوَى مِنَّا جِدًّا». ");
INSERT INTO arb_vd_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","فَمَضَى إِسْحَاقُ مِنْ هُنَاكَ، وَنَزَلَ فِي وَادِي جَرَارَ وَأَقَامَ هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","فَعَادَ إِسْحَاقُ وَنَبَشَ آبَارَ ٱلْمَاءِ ٱلَّتِي حَفَرُوهَا فِي أَيَّامِ إِبْرَاهِيمَ أَبِيهِ، وَطَمَّهَا ٱلْفِلِسْطِينِيُّونَ بَعْدَ مَوْتِ أَبِيهِ، وَدَعَاهَا بِأَسْمَاءٍ كَٱلْأَسْمَاءِ ٱلَّتِي دَعَاهَا بِهَا أَبُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","وَحَفَرَ عَبِيدُ إِسْحَاقَ فِي ٱلْوَادِي فَوَجَدُوا هُنَاكَ بِئْرَ مَاءٍ حَيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","فَخَاصَمَ رُعَاةُ جَرَارَ رُعَاةَ إِسْحَاقَ قَائِلِينَ: «لَنَا ٱلْمَاءُ». فَدَعَا ٱسْمَ ٱلْبِئْرِ «عِسِقَ» لِأَنَّهُمْ نَازَعُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ثُمَّ حَفَرُوا بِئْرًا أُخْرَى وَتَخَاصَمُوا عَلَيْهَا أَيْضًا، فَدَعَا ٱسْمَهَا «سِطْنَةَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ثُمَّ نَقَلَ مِنْ هُنَاكَ وَحَفَرَ بِئْرًا أُخْرَى وَلَمْ يَتَخَاصَمُوا عَلَيْهَا، فَدَعَا ٱسْمَهَا «رَحُوبُوتَ»، وَقَالَ: «إِنَّهُ ٱلْآنَ قَدْ أَرْحَبَ لَنَا ٱلرَّبُّ وَأَثْمَرْنَا فِي ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ثُمَّ صَعِدَ مِنْ هُنَاكَ إِلَى بِئْرِ سَبْعٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","فَظَهَرَ لَهُ ٱلرَّبُّ فِي تِلْكَ ٱللَّيْلَةِ وَقَالَ: «أَنَا إِلَهُ إِبْرَاهِيمَ أَبِيكَ. لَا تَخَفْ لِأَنِّي مَعَكَ، وَأُبَارِكُكَ وَأُكَثِّرُ نَسْلَكَ مِنْ أَجْلِ إِبْرَاهِيمَ عَبْدِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","فَبَنَى هُنَاكَ مَذْبَحًا وَدَعَا بِٱسْمِ ٱلرَّبِّ. وَنَصَبَ هُنَاكَ خَيْمَتَهُ، وَحَفَرَ هُنَاكَ عَبِيدُ إِسْحَاقَ بِئْرًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","وَذَهَبَ إِلَيْهِ مِنْ جَرَارَ أَبِيمَالِكُ وَأَحُزَّاتُ مِنْ أَصْحَابِهِ وَفِيكُولُ رَئِيسُ جَيْشِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","فَقَالَ لَهُمْ إِسْحَاقُ: «مَا بَالُكُمْ أَتَيْتُمْ إِلَيَّ وَأَنْتُمْ قَدْ أَبْغَضْتُمُونِي وَصَرَفْتُمُونِي مِنْ عِنْدِكُمْ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","فَقَالُوا: «إِنَّنَا قَدْ رَأَيْنَا أَنَّ ٱلرَّبَّ كَانَ مَعَكَ، فَقُلْنَا: لِيَكُنْ بَيْنَنَا حَلْفٌ، بَيْنَنَا وَبَيْنَكَ، وَنَقْطَعُ مَعَكَ عَهْدًا: ");
INSERT INTO arb_vd_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","أَنْ لَا تَصْنَعَ بِنَا شَرًّا، كَمَا لَمْ نَمَسَّكَ وَكَمَا لَمْ نَصْنَعْ بِكَ إِلَا خَيْرًا وَصَرَفْنَاكَ بِسَلَامٍ. أَنْتَ ٱلْآنَ مُبَارَكُ ٱلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","فَصَنَعَ لَهُمْ ضِيَافَةً، فَأَكَلُوا وَشَرِبُوا. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ثُمَّ بَكَّرُوا فِي ٱلْغَدِ وَحَلَفُوا بَعْضُهُمْ لِبَعْضٍ، وَصَرَفَهُمْ إِسْحَاقُ. فَمَضَوْا مِنْ عِنْدِهِ بِسَلَامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","وَحَدَثَ فِي ذَلِكَ ٱلْيَوْمِ أَنَّ عَبِيدَ إِسْحَاقَ جَاءُوا وَأَخْبَرُوهُ عَنِ ٱلْبِئْرِ ٱلَّتِي حَفَرُوا، وَقَالُوا لَهُ: «قَدْ وَجَدْنَا مَاءً». ");
INSERT INTO arb_vd_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","فَدَعَاهَا «شِبْعَةَ»، لِذَلِكَ ٱسْمُ ٱلْمَدِينَةِ بِئْرُ سَبْعٍ إِلَى هَذَا ٱلْيَوْمِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","وَلَمَّا كَانَ عِيسُو ٱبْنَ أَرْبَعِينَ سَنَةً ٱتَّخَذَ زَوْجَةً: يَهُودِيتَ ٱبْنَةَ بِيرِي ٱلْحِثِّيِّ، وَبَسْمَةَ ٱبْنَةَ إِيلُونَ ٱلْحِثِّيِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","فَكَانَتَا مَرَارَةَ نَفْسٍ لِإِسْحَاقَ وَرِفْقَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","وَحَدَثَ لَمَّا شَاخَ إِسْحَاقُ وَكَلَّتْ عَيْنَاهُ عَنِ ٱلنَّظَرِ، أَنَّهُ دَعَا عِيسُوَ ٱبْنَهُ ٱلْأَكْبَرَ وَقَالَ لَهُ: «يَا ٱبْنِي». فَقَالَ لَهُ: «هَأَنَذَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","فَقَالَ: «إِنَّنِي قَدْ شِخْتُ وَلَسْتُ أَعْرِفُ يَوْمَ وَفَاتِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","فَٱلْآنَ خُذْ عُدَّتَكَ: جُعْبَتَكَ وَقَوْسَكَ، وَٱخْرُجْ إِلَى ٱلْبَرِّيَّةِ وَتَصَيَّدْ لِي صَيْدًا، ");
INSERT INTO arb_vd_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","وَٱصْنَعْ لِي أَطْعِمَةً كَمَا أُحِبُّ، وَأْتِنِي بِهَا لِآكُلَ حَتَّى تُبَارِكَكَ نَفْسِي قَبْلَ أَنْ أَمُوتَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","وَكَانَتْ رِفْقَةُ سَامِعَةً إِذْ تَكَلَّمَ إِسْحَاقُ مَعَ عِيسُو ٱبْنِهِ. فَذَهَبَ عِيسُو إِلَى ٱلْبَرِّيَّةِ كَيْ يَصْطَادَ صَيْدًا لِيَأْتِيَ بِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","وَأَمَّا رِفْقَةُ فَكَلمتْ يَعْقُوبَ ٱبْنِهَا قَائِلةً: «إِنِّي قَدْ سَمِعْتُ أَبَاكَ يُكَلِّمُ عِيسُوَ أَخَاكَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ٱئْتِنِي بِصَيْدٍ وَٱصْنَعْ لِي أَطْعِمَةً لِآكُلَ وَأُبَارِكَكَ أَمَامَ ٱلرَّبِّ قَبْلَ وَفَاتِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","فَٱلْآنَ يَا ٱبْنِي ٱسْمَعْ لِقَوْلِي فِي مَا أَنَا آمُرُكَ بِهِ: ");
INSERT INTO arb_vd_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","اِذْهَبْ إِلَى ٱلْغَنَمِ وَخُذْ لِي مِنْ هُنَاكَ جَدْيَيْنِ جَيِّدَيْنِ مِنَ ٱلْمِعْزَى، فَأَصْنَعَهُمَا أَطْعِمَةً لِأَبِيكَ كَمَا يُحِبُّ، ");
INSERT INTO arb_vd_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","فَتُحْضِرَهَا إِلَى أَبِيكَ لِيَأْكُلَ حَتَّى يُبَارِكَكَ قَبْلَ وَفَاتِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","فَقَالَ يَعْقُوبُ لِرِفْقَةَ أُمِّهِ: «هُوَذَا عِيسُو أَخِي رَجُلٌ أَشْعَرُ وَأَنَا رَجُلٌ أَمْلَسُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","رُبَّمَا يَجُسُّنِي أَبِي فَأَكُونُ فِي عَيْنَيْهِ كَمُتَهَاوِنٍ، وَأَجْلِبُ عَلَى نَفْسِي لَعْنَةً لَا بَرَكَةً». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","فَقَالَتْ لَهُ أُمُّهُ: «لَعْنَتُكَ عَلَيَّ يَا ٱبْنِي. اِسْمَعْ لِقَوْلِي فَقَطْ وَٱذْهَبْ خُذْ لِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","فَذَهَبَ وَأَخَذَ وَأَحْضَرَ لِأُمِّهِ، فَصَنَعَتْ أُمُّهُ أَطْعِمَةً كَمَا كَانَ أَبُوهُ يُحِبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","وَأَخَذَتْ رِفْقَةُ ثِيَابَ عِيسُو ٱبْنِهَا ٱلْأَكْبَرِ ٱلْفَاخِرَةَ ٱلَّتِي كَانَتْ عِنْدَهَا فِي ٱلْبَيْتِ وَأَلْبَسَتْ يَعْقُوبَ ٱبْنَهَا ٱلْأَصْغَرَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","وَأَلْبَسَتْ يَدَيْهِ وَمَلَاسَةَ عُنُقِهِ جُلُودَ جَدْيَيِ ٱلْمِعْزَى. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","وَأَعْطَتِ ٱلْأَطْعِمَةَ وَٱلْخُبْزَ ٱلَّتِي صَنَعَتْ فِي يَدِ يَعْقُوبَ ٱبْنِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","فَدَخَلَ إِلَى أَبِيهِ وَقَالَ: «يَا أَبِي». فَقَالَ: «هَأَنَذَا. مَنْ أَنْتَ يَا ٱبْنِي؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","فَقَالَ يَعْقُوبُ لِأَبِيهِ: «أَنَا عِيسُو بِكْرُكَ. قَدْ فَعَلْتُ كَمَا كَلَّمْتَنِي. قُمِ ٱجْلِسْ وَكُلْ مِنْ صَيْدِي لِكَيْ تُبَارِكَنِي نَفْسُكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","فَقَالَ إِسْحَاقُ لِٱبْنِهِ: «مَا هَذَا ٱلَّذِي أَسْرَعْتَ لِتَجِدَ يَا ٱبْنِي؟». فَقَالَ: «إِنَّ ٱلرَّبَّ إِلَهَكَ قَدْ يَسَّرَ لِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","فَقَالَ إِسْحَاقُ لِيَعْقُوبَ: «تَقَدَّمْ لِأَجُسَّكَ يَا ٱبْنِي. أَأَنْتَ هُوَ ٱبْنِي عِيسُو أَمْ لَا؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","فَتَقَدَّمَ يَعْقُوبُ إِلَى إِسْحَاقَ أَبِيهِ، فَجَسَّهُ وَقَالَ: «ٱلصَّوْتُ صَوْتُ يَعْقُوبَ، وَلَكِنَّ ٱلْيَدَيْنِ يَدَا عِيسُو». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","وَلَمْ يَعْرِفْهُ لِأَنَّ يَدَيْهِ كَانَتَا مُشْعِرَتَيْنِ كَيَدَيْ عِيسُو أَخِيهِ، فَبَارَكَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","وَقَالَ: «هَلْ أَنْتَ هُوَ ٱبْنِي عِيسُو؟». فَقَالَ: «أَنَا هُوَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","فَقَالَ: «قَدِّمْ لِي لِآكُلَ مِنْ صَيْدِ ٱبْنِي حَتَّى تُبَارِكَكَ نَفْسِي». فَقَدَّمَ لَهُ فَأَكَلَ، وَأَحْضَرَ لَهُ خَمْرًا فَشَرِبَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","فَقَالَ لَهُ إِسْحَاقُ أَبُوهُ: «تَقَدَّمْ وَقَبِّلْنِي يَا ٱبْنِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","فَتَقَدَّمَ وَقَبَّلَهُ، فَشَمَّ رَائِحَةَ ثِيَابِهِ وَبَارَكَهُ، وَقَالَ: «ٱنْظُرْ! رَائِحَةُ ٱبْنِي كَرَائِحَةِ حَقْلٍ قَدْ بَارَكَهُ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","فَلْيُعْطِكَ ٱللهُ مِنْ نَدَى ٱلسَّمَاءِ وَمِنْ دَسَمِ ٱلْأَرْضِ. وَكَثْرَةَ حِنْطَةٍ وَخَمْرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","لِيُسْتَعْبَدْ لَكَ شُعُوبٌ، وَتَسْجُدْ لَكَ قَبَائِلُ. كُنْ سَيِّدًا لِإِخْوَتِكَ، وَلْيَسْجُدْ لَكَ بَنُو أُمِّكَ. لِيَكُنْ لَاعِنُوكَ مَلْعُونِينَ، وَمُبَارِكُوكَ مُبَارَكِينَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","وَحَدَثَ عِنْدَمَا فَرَغَ إِسْحَاقُ مِنْ بَرَكَةِ يَعْقُوبَ، وَيَعْقُوبُ قَدْ خَرَجَ مِنْ لَدُنْ إِسْحَاقَ أَبِيهِ، أَنَّ عِيسُوَ أَخَاهُ أَتَى مِنْ صَيْدِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","فَصَنَعَ هُوَ أَيْضًا أَطْعِمَةً وَدَخَلَ بِهَا إِلَى أَبِيهِ وَقَالَ لِأَبِيهِ: «لِيَقُمْ أَبِي وَيَأْكُلْ مِنْ صَيْدِ ٱبْنِهِ حَتَّى تُبَارِكَنِي نَفْسُكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","فَقَالَ لَهُ إِسْحَاقُ أَبُوهُ: «مَنْ أَنْتَ؟» فَقَالَ: «أَنَا ٱبْنُكَ بِكْرُكَ عِيسُو». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","فَٱرْتَعَدَ إِسْحَاقُ ٱرْتِعَادًا عَظِيمًا جِدًّا وَقَالَ: «فَمَنْ هُوَ ٱلَّذِي ٱصْطَادَ صَيْدًا وَأَتَى بِهِ إِلَيَّ فَأَكَلْتُ مِنَ ٱلْكُلِّ قَبْلَ أَنْ تَجِيءَ، وَبَارَكْتُهُ؟ نَعَمْ، وَيَكُونُ مُبَارَكًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","فَعِنْدَمَا سَمِعَ عِيسُو كَلَامَ أَبِيهِ صَرَخَ صَرْخَةً عَظِيمَةً وَمُرَّةً جِدًّا، وَقَالَ لِأَبِيهِ: «بَارِكْنِي أَنَا أَيْضًا يَا أَبِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","فَقَالَ: «قَدْ جَاءَ أَخُوكَ بِمَكْرٍ وَأَخَذَ بَرَكَتَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","فَقَالَ: «أَلَا إِنَّ ٱسْمَهُ دُعِيَ يَعْقُوبَ، فَقَدْ تَعَقَّبَنِي ٱلْآنَ مَرَّتَيْنِ! أَخَذَ بَكُورِيَّتِي، وَهُوَذَا ٱلْآنَ قَدْ أَخَذَ بَرَكَتِي». ثُمَّ قَالَ: «أَمَا أَبْقَيْتَ لِي بَرَكَةً؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","فَأَجَابَ إِسْحَاقُ وَقَالَ لِعِيسُو: «إِنِّي قَدْ جَعَلْتُهُ سَيِّدًا لَكَ، وَدَفَعْتُ إِلَيْهِ جَمِيعَ إِخْوَتِهِ عَبِيدًا، وَعَضَدْتُهُ بِحِنْطَةٍ وَخَمْرٍ. فَمَاذَا أَصْنَعُ إِلَيْكَ يَا ٱبْنِي؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","فَقَالَ عِيسُو لِأَبِيهِ: «أَلَكَ بَرَكَةٌ وَاحِدَةٌ فَقَطْ يَا أَبِي؟ بَارِكْنِي أَنَا أَيْضًا يَا أَبِي». وَرَفَعَ عِيسُو صَوْتَهُ وَبَكَى. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","فَأَجَابَ إِسْحَاقُ أَبُوهُ وَقَالَ لَهُ: «هُوَذَا بِلَا دَسَمِ ٱلْأَرْضِ يَكُونُ مَسْكَنُكَ، وَبِلَا نَدَى ٱلسَّمَاءِ مِنْ فَوْقُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","وَبِسَيْفِكَ تَعِيشُ، وَلِأَخِيكَ تُسْتَعْبَدُ، وَلَكِنْ يَكُونُ حِينَمَا تَجْمَحُ أَنَّكَ تُكَسِّرُ نِيرَهُ عَنْ عُنُقِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","فَحَقَدَ عِيسُو عَلَى يَعْقُوبَ مِنْ أَجْلِ ٱلْبَرَكَةِ ٱلَّتِي بَارَكَهُ بِهَا أَبُوهُ. وَقَالَ عِيسُو فِي قَلْبِهِ: «قَرُبَتْ أَيَّامُ مَنَاحَةِ أَبِي، فَأَقْتُلُ يَعْقُوبَ أَخِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","فَأُخْبِرَتْ رِفْقَةُ بِكَلَامِ عِيسُوَ ٱبْنِهَا ٱلْأَكْبَرِ، فَأَرْسَلَتْ وَدَعَتْ يَعْقُوبَ ٱبْنَهَا ٱلْأَصْغَرَ وَقَالَتْ لَهُ: «هُوَذَا عِيسُو أَخُوكَ مُتَسَلٍّ مِنْ جِهَتِكَ بِأَنَّهُ يَقْتُلُكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","فَٱلْآنَ يَا ٱبْنِي ٱسْمَعْ لِقَوْلِي، وَقُمِ ٱهْرُبْ إِلَى أَخِي لَابَانَ إِلَى حَارَانَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","وَأَقِمْ عِنْدَهُ أَيَّامًا قَلِيلَةً حَتَّى يَرْتَدَّ سُخْطُ أَخِيكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","حَتَّى يَرْتَدَّ غَضَبُ أَخِيكَ عَنْكَ، وَيَنْسَى مَا صَنَعْتَ بِهِ. ثُمَّ أُرْسِلُ فَآخُذُكَ مِنْ هُنَاكَ. لِمَاذَا أُعْدَمُ ٱثْنَيْكُمَا فِي يَوْمٍ وَاحِدٍ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","وَقَالَتْ رِفْقَةُ لِإِسْحَاقَ: «مَلِلْتُ حَيَاتِي مِنْ أَجْلِ بَنَاتِ حِثَّ. إِنْ كَانَ يَعْقُوبُ يَأْخُذُ زَوْجَةً مِنْ بَنَاتِ حِثَّ مِثْلَ هَؤُلَاءِ مِنْ بَنَاتِ ٱلْأَرْضِ، فَلِمَاذَا لِي حَيَاةٌ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","فَدَعَا إِسْحَاقُ يَعْقُوبَ وَبَارَكَهُ، وَأَوْصَاهُ وَقَالَ لَهُ: «لَا تَأْخُذْ زَوْجَةً مِنْ بَنَاتِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","قُمِ ٱذْهَبْ إِلَى فَدَّانِ أَرَامَ، إِلَى بَيْتِ بَتُوئِيلَ أَبِي أُمِّكَ، وَخُذْ لِنَفْسِكَ زَوْجَةً مِنْ هُنَاكَ، مِنْ بَنَاتِ لَابَانَ أَخِي أُمِّكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","وَٱللهُ ٱلْقَدِيرُ يُبَارِكُكَ، وَيَجْعَلُكَ مُثْمِرًا، وَيُكَثِّرُكَ فَتَكُونُ جُمْهُورًا مِنَ ٱلشُّعُوبِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","وَيُعْطِيكَ بَرَكَةَ إِبْرَاهِيمَ لَكَ وَلِنَسْلِكَ مَعَكَ، لِتَرِثَ أَرْضَ غُرْبَتِكَ ٱلَّتِي أَعْطَاهَا ٱللهُ لِإِبْرَاهِيمَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","فَصَرَفَ إِسْحَاقُ يَعْقُوبَ فَذَهَبَ إِلَى فَدَّانِ أَرَامَ، إِلَى لَابَانَ بْنِ بَتُوئِيلَ ٱلْأَرَامِيِّ، أَخِي رِفْقَةَ أُمِّ يَعْقُوبَ وَعِيسُوَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","فَلَمَّا رَأَى عِيسُو أَنَّ إِسْحَاقَ بَارَكَ يَعْقُوبَ وَأَرْسَلَهُ إِلَى فَدَّانِ أَرَامَ لِيَأْخُذَ لِنَفْسِهِ مِنْ هُنَاكَ زَوْجَةً، إِذْ بَارَكَهُ وَأَوْصَاهُ قَائِلًا: «لَا تَأْخُذْ زَوْجَةً مِنْ بَنَاتِ كَنْعَانَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","وَأَنَّ يَعْقُوبَ سَمِعَ لِأَبِيهِ وَأُمِّهِ وَذَهَبَ إِلَى فَدَّانِ أَرَامَ،. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","رَأَى عِيسُو أَنَّ بَنَاتِ كَنْعَانَ شِرِّيرَاتٌ فِي عَيْنَيْ إِسْحَاقَ أَبِيهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","فَذَهَبَ عِيسُو إِلَى إِسْمَاعِيلَ وَأَخَذَ مَحْلَةَ بِنْتَ إِسْمَاعِيلَ بْنِ إِبْرَاهِيمَ، أُخْتَ نَبَايُوتَ، زَوْجَةً لَهُ عَلَى نِسَائِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","فَخَرَجَ يَعْقُوبُ مِنْ بِئْرِ سَبْعٍ وَذَهَبَ نَحْوَ حَارَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","وَصَادَفَ مَكَانًا وَبَاتَ هُنَاكَ لِأَنَّ ٱلشَّمْسَ كَانَتْ قَدْ غَابَتْ، وَأَخَذَ مِنْ حِجَارَةِ ٱلْمَكَانِ وَوَضَعَهُ تَحْتَ رَأْسِهِ، فَٱضْطَجَعَ فِي ذَلِكَ ٱلْمَكَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","وَرَأَى حُلْمًا، وَإِذَا سُلَّمٌ مَنْصُوبَةٌ عَلَى ٱلْأَرْضِ وَرَأْسُهَا يَمَسُّ ٱلسَّمَاءَ، وَهُوَذَا مَلَائِكَةُ ٱللهِ صَاعِدَةٌ وَنَازِلَةٌ عَلَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","وَهُوَذَا ٱلرَّبُّ وَاقِفٌ عَلَيْهَا، فَقَالَ: «أَنَا ٱلرَّبُّ إِلَهُ إِبْرَاهِيمَ أَبِيكَ وَإِلَهُ إِسْحَاقَ. ٱلْأَرْضُ ٱلَّتِي أَنْتَ مُضْطَجِعٌ عَلَيْهَا أُعْطِيهَا لَكَ وَلِنَسْلِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","وَيَكُونُ نَسْلُكَ كَتُرَابِ ٱلْأَرْضِ، وَتَمْتَدُّ غَرْبًا وَشَرْقًا وَشَمَالًا وَجَنُوبًا، وَيَتَبَارَكُ فِيكَ وَفِي نَسْلِكَ جَمِيعُ قَبَائِلِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","وَهَا أَنَا مَعَكَ، وَأَحْفَظُكَ حَيْثُمَا تَذْهَبُ، وَأَرُدُّكَ إِلَى هَذِهِ ٱلْأَرْضِ، لِأَنِّي لَا أَتْرُكُكَ حَتَّى أَفْعَلَ مَا كَلَّمْتُكَ بِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","فَٱسْتَيْقَظَ يَعْقُوبُ مِنْ نَوْمِهِ وَقَالَ: «حَقًّا إِنَّ ٱلرَّبَّ فِي هَذَا ٱلْمَكَانِ وَأَنَا لَمْ أَعْلَمْ!». ");
INSERT INTO arb_vd_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","وَخَافَ وَقَالَ: «مَا أَرْهَبَ هَذَا ٱلْمَكَانَ! مَا هَذَا إِلَا بَيْتُ ٱللهِ، وَهَذَا بَابُ ٱلسَّمَاءِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","وَبَكَّرَ يَعْقُوبُ فِي ٱلصَّبَاحِ وَأَخَذَ ٱلْحَجَرَ ٱلَّذِي وَضَعَهُ تَحْتَ رَأْسِهِ وَأَقَامَهُ عَمُودًا، وَصَبَّ زَيْتًا عَلَى رَأْسِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","وَدَعَا ٱسْمَ ذَلِكَ ٱلْمَكَانِ «بَيْتَ إِيلَ»، وَلَكِنِ ٱسْمُ ٱلْمَدِينَةِ أَوَّلًا كَانَ لُوزَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","وَنَذَرَ يَعْقُوبُ نَذْرًا قَائِلًا: «إِنْ كَانَ ٱللهُ مَعِي، وَحَفِظَنِي فِي هَذَا ٱلطَّرِيقِ ٱلَّذِي أَنَا سَائِرٌ فِيهِ، وَأَعْطَانِي خُبْزًا لِآكُلَ وَثِيَابًا لِأَلْبَسَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","وَرَجَعْتُ بِسَلَامٍ إِلَى بَيْتِ أَبِي، يَكُونُ ٱلرَّبُّ لِي إِلَهًا، ");
INSERT INTO arb_vd_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","وَهَذَا ٱلْحَجَرُ ٱلَّذِي أَقَمْتُهُ عَمُودًا يَكُونُ بَيْتَ ٱللهِ، وَكُلُّ مَا تُعْطِينِي فَإِنِّي أُعَشِّرُهُ لَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ثُمَّ رَفَعَ يَعْقُوبُ رِجْلَيْهِ وَذَهَبَ إِلَى أَرْضِ بَنِي ٱلْمَشْرِقِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","وَنَظَرَ وَإِذَا فِي ٱلْحَقْلِ بِئْرٌ وَهُنَاكَ ثَلَاثَةُ قُطْعَانِ غَنَمٍ رَابِضَةٌ عِنْدَهَا، لِأَنَّهُمْ كَانُوا مِنْ تِلْكَ ٱلْبِئْرِ يَسْقُونَ ٱلْقُطْعَانَ، وَٱلْحَجَرُ عَلَى فَمِ ٱلْبِئْرِ كَانَ كَبِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","فَكَانَ يَجْتَمِعُ إِلَى هُنَاكَ جَمِيعُ ٱلْقُطْعَانِ فَيُدَحْرِجُونَ ٱلْحَجَرَ عَنْ فَمِ ٱلْبِئْرِ وَيَسْقُونَ ٱلْغَنَمَ، ثُمَّ يَرُدُّونَ ٱلْحَجَرَ عَلَى فَمِ ٱلْبِئْرِ إِلَى مَكَانِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","فَقَالَ لَهُمْ يَعْقُوبُ: «يَا إِخْوَتِي، مِنْ أَيْنَ أَنْتُمْ؟» فَقَالُوا: «نَحْنُ مِنْ حَارَانَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","فَقَالَ لَهُمْ: «هَلْ تَعْرِفُونَ لَابَانَ ٱبْنَ نَاحُورَ؟» فَقَالُوا: «نَعْرِفُهُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","فَقَالَ لَهُمْ: «هَلْ لَهُ سَلَامَةٌ؟» فَقَالُوا: «لَهُ سَلَامَةٌ. وَهُوَذَا رَاحِيلُ ٱبْنَتُهُ آتِيَةٌ مَعَ ٱلْغَنَمِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","فَقَالَ: «هُوَذَا ٱلنَّهَارُ بَعْدُ طَوِيلٌ. لَيْسَ وَقْتَ ٱجْتِمَاعِ ٱلْمَوَاشِي. اِسْقُوا ٱلْغَنَمَ وَٱذْهَبُوا ٱرْعَوْا». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","فَقَالُوا: «لَا نَقْدِرُ حَتَّى تَجْتَمِعَ جَمِيعُ ٱلْقُطْعَانِ وَيُدَحْرِجُوا ٱلْحَجَرَ عَنْ فَمِ ٱلْبِئْرِ، ثُمَّ نَسْقِي ٱلْغَنَمَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","وَإِذْ هُوَ بَعْدُ يَتَكَلَّمُ مَعَهُمْ أَتَتْ رَاحِيلُ مَعَ غَنَمِ أَبِيهَا، لِأَنَّهَا كَانَتْ تَرْعَى. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","فَكَانَ لَمَّا أَبْصَرَ يَعْقُوبُ رَاحِيلَ بِنْتَ لَابَانَ خَالِهِ، وَغَنَمَ لَابَانَ خَالِهِ، أَنَّ يَعْقُوبَ تَقَدَّمَ وَدَحْرَجَ ٱلْحَجَرَ عَنْ فَمِ ٱلْبِئْرِ وَسَقَى غَنَمَ لَابَانَ خَالِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","وَقَبَّلَ يَعْقُوبُ رَاحِيلَ وَرَفَعَ صَوْتَهُ وَبَكَى. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","وَأَخْبَرَ يَعْقُوبُ رَاحِيلَ أَنَّهُ أَخُو أَبِيهَا، وَأَنَّهُ ٱبْنُ رِفْقَةَ، فَرَكَضَتْ وَأَخْبَرَتْ أَبَاهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","فَكَانَ حِينَ سَمِعَ لَابَانُ خَبَرَ يَعْقُوبَ ٱبْنِ أُخْتِهِ أَنَّهُ رَكَضَ لِلِقَائِهِ وَعَانَقَهُ وَقَبَّلَهُ وَأَتَى بِهِ إِلَى بَيْتِهِ. فَحَدَّثَ لَابَانَ بِجَمِيعِ هَذِهِ ٱلْأُمُورِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","فَقَالَ لَهُ لَابَانُ: «إِنَّمَا أَنْتَ عَظْمِي وَلَحْمِي». فَأَقَامَ عِنْدَهُ شَهْرًا مِنَ ٱلزَّمَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ثُمَّ قَالَ لَابَانُ لِيَعْقُوبَ: «أَلِأَنَّكَ أَخِي تَخْدِمُنِي مَجَّانًا؟ أَخْبِرْنِي مَا أُجْرَتُكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","وَكَانَ لِلَابَانَ ٱبْنَتَانِ، ٱسْمُ ٱلْكُبْرَى لَيْئَةُ وَٱسْمُ ٱلصُّغْرَى رَاحِيلُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","وَكَانَتْ عَيْنَا لَيْئَةَ ضَعِيفَتَيْنِ، وَأَمَّا رَاحِيلُ فَكَانَتْ حَسَنَةَ ٱلصُّورَةِ وَحَسَنَةَ ٱلْمَنْظَرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","وَأَحَبَّ يَعْقُوبُ رَاحِيلَ، فَقَالَ: «أَخْدِمُكَ سَبْعَ سِنِينٍ بِرَاحِيلَ ٱبْنَتِكَ ٱلصُّغْرَى». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","فَقَالَ لَابَانُ: «أَنْ أُعْطِيَكَ إِيَّاهَا أَحْسَنُ مِنْ أَنْ أُعْطِيَهَا لِرَجُلٍ آخَرَ. أَقِمْ عِنْدِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","فَخَدَمَ يَعْقُوبُ بِرَاحِيلَ سَبْعَ سِنِينٍ، وَكَانَتْ فِي عَيْنَيْهِ كَأَيَّامٍ قَلِيلَةٍ بِسَبَبِ مَحَبَّتِهِ لَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ثُمَّ قَالَ يَعْقُوبُ لِلَابَانَ: «أَعْطِنِي ٱمْرَأَتِي لِأَنَّ أَيَّامِي قَدْ كَمُلَتْ، فَأَدْخُلَ عَلَيْهَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","فَجَمَعَ لَابَانُ جَمِيعَ أَهْلِ ٱلْمَكَانِ وَصَنَعَ وَلِيمَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","وَكَانَ فِي ٱلْمَسَاءِ أَنَّهُ أَخَذَ لَيْئَةَ ٱبْنَتَهُ وَأَتَى بِهَا إِلَيْهِ، فَدَخَلَ عَلَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","وَأَعْطَى لَابَانُ زِلْفَةَ جَارِيَتَهُ لِلَيْئَةَ ٱبْنَتِهِ جَارِيَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","وَفِي ٱلصَّبَاحِ إِذَا هِيَ لَيْئَةُ، فَقَالَ لِلَابَانَ: «مَا هَذَا ٱلَّذِي صَنَعْتَ بِي؟ أَلَيْسَ بِرَاحِيلَ خَدَمْتُ عِنْدَكَ؟ فَلِمَاذَا خَدَعْتَنِي؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","فَقَالَ لَابَانُ: «لَا يُفْعَلُ هَكَذَا فِي مَكَانِنَا أَنْ تُعْطَى ٱلصَّغِيرَةُ قَبْلَ ٱلْبِكْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","أَكْمِلْ أُسْبُوعَ هَذِهِ، فَنُعْطِيَكَ تِلْكَ أَيْضًا، بِٱلْخِدْمَةِ ٱلَّتِي تَخْدِمُنِي أَيْضًا سَبْعَ سِنِينٍ أُخَرَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","فَفَعَلَ يَعْقُوبُ هَكَذَا. فَأَكْمَلَ أُسْبُوعَ هَذِهِ، فَأَعْطَاهُ رَاحِيلَ ٱبْنَتَهُ زَوْجَةً لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","وَأَعْطَى لَابَانُ رَاحِيلَ ٱبْنَتَهُ بِلْهَةَ جَارِيَتَهُ جَارِيَةً لَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","فَدَخَلَ عَلَى رَاحِيلَ أَيْضًا، وَأَحَبَّ أَيْضًا رَاحِيلَ أَكْثَرَ مِنْ لَيْئَةَ. وَعَادَ فَخَدَمَ عِنْدَهُ سَبْعَ سِنِينٍ أُخَرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","وَرَأَى ٱلرَّبُّ أَنَّ لَيْئَةَ مَكْرُوهَةٌ فَفَتَحَ رَحِمَهَا، وَأَمَّا رَاحِيلُ فَكَانَتْ عَاقِرًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","فَحَبِلَتْ لَيْئَةُ وَوَلَدَتِ ٱبْنًا وَدَعَتِ ٱسْمَهُ «رَأُوبَيْنَ»، لِأَنَّهَا قَالَتْ: «إِنَّ ٱلرَّبَّ قَدْ نَظَرَ إِلَى مَذَلَّتِي. إِنَّهُ ٱلْآنَ يُحِبُّنِي رَجُلِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","وَحَبِلَتْ أَيْضًا وَوَلَدَتِ ٱبْنًا، وَقَالَتْ: «إِنَّ ٱلرَّبَّ قَدْ سَمِعَ أَنِّي مَكْرُوهَةٌ فَأَعْطَانِي هَذَا أَيْضًا». فَدَعَتِ ٱسْمَهُ «شِمْعُونَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","وَحَبِلَتْ أَيْضًا وَوَلَدَتِ ٱبْنًا، وَقَالَتِ: «ٱلْآنَ هَذِهِ ٱلْمَرَّةَ يَقْتَرِنُ بِي رَجُلِي، لِأَنِّي وَلَدْتُ لَهُ ثَلَاثَةَ بَنِينَ». لِذَلِكَ دُعِيَ ٱسْمُهُ «لَاوِيَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","وَحَبِلَتْ أَيْضًا وَوَلَدَتِ ٱبْنًا وَقَالَتْ: «هَذِهِ ٱلْمَرَّةَ أَحْمَدُ ٱلرَّبَّ». لِذَلِكَ دَعَتِ ٱسْمَهُ «يَهُوذَا». ثُمَّ تَوَقَّفَتْ عَنِ ٱلْوِلَادَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","فَلَمَّا رَأَتْ رَاحِيلُ أَنَّهَا لَمْ تَلِدْ لِيَعْقُوبَ، غَارَتْ رَاحِيلُ مِنْ أُخْتِهَا، وَقَالَتْ لِيَعْقُوبَ: «هَبْ لِي بَنِينَ، وَإِلَا فَأَنَا أَمُوتُ!». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","فَحَمِيَ غَضَبُ يَعْقُوبَ عَلَى رَاحِيلَ وَقَالَ: «أَلَعَلِّي مَكَانَ ٱللهِ ٱلَّذِي مَنَعَ عَنْكِ ثَمْرَةَ ٱلْبَطْنِ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","فَقَالَتْ: «هُوَذَا جَارِيَتِي بِلْهَةُ، ٱدْخُلْ عَلَيْهَا فَتَلِدَ عَلَى رُكْبَتَيَّ، وَأُرْزَقُ أَنَا أَيْضًا مِنْهَا بَنِينَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","فَأَعْطَتْهُ بِلْهَةَ جَارِيَتَهَا زَوْجَةً، فَدَخَلَ عَلَيْهَا يَعْقُوبُ، ");
INSERT INTO arb_vd_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","فَحَبِلَتْ بِلْهَةُ وَوَلَدَتْ لِيَعْقُوبَ ٱبْنًا، ");
INSERT INTO arb_vd_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","فَقَالَتْ رَاحِيلُ: «قَدْ قَضَى لِيَ ٱللهُ وَسَمِعَ أَيْضًا لِصَوْتِي وَأَعْطَانِيَ ٱبْنًا». لِذَلِكَ دَعَتِ ٱسْمَهُ «دَانًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","وَحَبِلَتْ أَيْضًا بِلْهَةُ جَارِيَةُ رَاحِيلَ وَوَلَدَتِ ٱبْنًا ثَانِيًا لِيَعْقُوبَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","فَقَالَتْ رَاحِيلُ: «مُصَارَعَاتِ ٱللهِ قَدْ صَارَعْتُ أُخْتِي وَغَلَبْتُ». فَدَعَتِ ٱسْمَهُ «نَفْتَالِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","وَلَمَّا رَأَتْ لَيْئَةُ أَنَّهَا تَوَقَّفَتْ عَنِ ٱلْوِلَادَةِ، أَخَذَتْ زِلْفَةَ جَارِيَتَهَا وَأَعْطَتْهَا لِيَعْقُوبَ زَوْجَةً، ");
INSERT INTO arb_vd_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","فَوَلَدَتْ زِلْفَةُ جَارِيَةُ لَيْئَةَ لِيَعْقُوبَ ٱبْنًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","فَقَالَتْ لَيْئَةُ: «بِسَعْدٍ». فَدَعَتِ ٱسْمَهُ «جَادًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","وَوَلَدَتْ زِلْفَةُ جَارِيَةُ لَيْئَةَ ٱبْنًا ثَانِيًا لِيَعْقُوبَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","فَقَالَتْ لَيْئَةُ: «بِغِبْطَتِي، لِأَنَّهُ تُغَبِّطُنِي بَنَاتٌ». فَدَعَتِ ٱسْمَهُ «أَشِيرَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","وَمَضَى رَأُوبَيْنُ فِي أَيَّامِ حَصَادِ ٱلْحِنْطَةِ فَوَجَدَ لُفَّاحًا فِي ٱلْحَقْلِ وَجَاءَ بِهِ إِلَى لَيْئَةَ أُمِّهِ. فَقَالَتْ رَاحِيلُ لِلَيْئَةَ: «أَعْطِينِي مِنْ لُفَّاحِ ٱبْنِكِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","فَقَالَتْ لَهَا: «أَقَلِيلٌ أَنَّكِ أَخَذْتِ رَجُلِي فَتَأْخُذِينَ لُفَّاحَ ٱبْنِي أَيْضًا؟» فَقَالَتْ رَاحِيلُ: «إِذًا يَضْطَجِعُ مَعَكِ ٱللَّيْلَةَ عِوَضًا عَنْ لُفَّاحِ ٱبْنِكِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","فَلَمَّا أَتَى يَعْقُوبُ مِنَ ٱلْحَقْلِ فِي ٱلْمَسَاءِ، خَرَجَتْ لَيْئَةُ لِمُلَاقَاتِهِ وَقَالَتْ: «إِلَيَّ تَجِيءُ لِأَنِّي قَدِ ٱسْتَأْجَرْتُكَ بِلُفَّاحِ ٱبْنِي». فَٱضْطَجَعَ مَعَهَا تِلْكَ ٱللَّيْلَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","وَسَمِعَ ٱللهُ لِلَيْئَةَ فَحَبِلَتْ وَوَلَدَتْ لِيَعْقُوبَ ٱبْنًا خَامِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","فَقَالَتْ لَيْئَةُ: «قَدْ أَعْطَانِي ٱللهُ أُجْرَتِي، لِأَنِّي أَعْطَيْتُ جَارِيَتِي لِرَجُلِي». فَدَعَتِ ٱسْمَهُ «يَسَّاكَرَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","وَحَبِلَتْ أَيْضًا لَيْئَةُ وَوَلَدَتِ ٱبْنًا سَادِسًا لِيَعْقُوبَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","فَقَالَتْ لَيْئَةُ: «قَدْ وَهَبَنِي ٱللهُ هِبَةً حَسَنَةً. ٱلْآنَ يُسَاكِنُنِي رَجُلِي، لِأَنِّي وَلَدْتُ لَهُ سِتَّةَ بَنِينَ». فَدَعَتِ ٱسْمَهُ «زَبُولُونَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ثُمَّ وَلَدَتِ ٱبْنَةً وَدَعَتِ ٱسْمَهَا «دِينَةَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","وَذَكَرَ ٱللهُ رَاحِيلَ، وَسَمِعَ لَهَا ٱللهُ وَفَتَحَ رَحِمَهَا، ");
INSERT INTO arb_vd_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","فَحَبِلَتْ وَوَلَدَتِ ٱبْنًا فَقَالَتْ: «قَدْ نَزَعَ ٱللهُ عَارِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","وَدَعَتِ ٱسْمَهُ «يُوسُفَ» قَائِلَةً: «يَزِيدُنِي ٱلرَّبُّ ٱبْنًا آخَرَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","وَحَدَثَ لَمَّا وَلَدَتْ رَاحِيلُ يُوسُفَ أَنَّ يَعْقُوبَ قَالَ لِلَابَانَ: «ٱصْرِفْنِي لِأَذْهَبَ إِلَى مَكَانِي وَإِلَى أَرْضِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","أَعْطِنِي نِسَائِي وَأَوْلَادِي ٱلَّذِينَ خَدَمْتُكَ بِهِمْ فَأَذْهَبَ، لِأَنَّكَ أَنْتَ تَعْلَمُ خِدْمَتِي ٱلَّتِي خَدَمْتُكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","فَقَالَ لَهُ لَابَانُ: «لَيْتَنِي أَجِدُ نِعْمَةً فِي عَيْنَيْكَ. قَدْ تَفَاءَلْتُ فَبَارَكَنِي ٱلرَّبُّ بِسَبَبِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","وَقَالَ: «عَيِّنْ لِي أُجْرَتَكَ فَأُعْطِيَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","فَقَالَ لَهُ: «أَنْتَ تَعْلَمُ مَاذَا خَدَمْتُكَ، وَمَاذَا صَارَتْ مَوَاشِيكَ مَعِي، ");
INSERT INTO arb_vd_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","لِأَنَّ مَا كَانَ لَكَ قَبْلِي قَلِيلٌ فَقَدِ ٱتَّسَعَ إِلَى كَثِيرٍ، وَبَارَكَكَ ٱلرَّبُّ فِي أَثَرِي. وَٱلْآنَ مَتَى أَعْمَلُ أَنَا أَيْضًا لِبَيْتِي؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","فَقَالَ: «مَاذَا أُعْطِيكَ؟» فَقَالَ يَعْقُوبُ: «لَا تُعْطِينِي شَيْئًا. إِنْ صَنَعْتَ لِي هَذَا ٱلْأَمْرَ أَعُودُ أَرْعَى غَنَمَكَ وَأَحْفَظُهَا: ");
INSERT INTO arb_vd_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","أَجْتَازُ بَيْنَ غَنَمِكَ كُلِّهَا ٱلْيَوْمَ، وَٱعْزِلْ أَنْتَ مِنْهَا كُلَّ شَاةٍ رَقْطَاءَ وَبَلْقَاءَ، وَكُلَّ شَاةٍ سَوْدَاءَ بَيْنَ ٱلْخِرْفَانِ، وَبَلْقَاءَ وَرَقْطَاءَ بَيْنَ ٱلْمِعْزَى. فَيَكُونَ مِثْلُ ذَلِكَ أُجْرَتِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","وَيَشْهَدُ فِيَّ بِرِّي يَوْمَ غَدٍ إِذَا جِئْتَ مِنْ أَجْلِ أُجْرَتِي قُدَّامَكَ. كُلُّ مَا لَيْسَ أَرْقَطَ أَوْ أَبْلَقَ بَيْنَ ٱلْمِعْزَى وَأَسْوَدَ بَيْنَ ٱلْخِرْفَانِ فَهُوَ مَسْرُوقٌ عِنْدِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","فَقَالَ لَابَانُ: «هُوَذَا لِيَكُنْ بِحَسَبِ كَلَامِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","فَعَزَلَ فِي ذَلِكَ ٱلْيَوْمِ ٱلتُّيُوسَ ٱلْمُخَطَّطَةَ وَٱلْبَلْقَاءَ، وَكُلَّ ٱلْعِنَازِ ٱلرَّقْطَاءِ وَٱلْبَلْقَاءِ، كُلَّ مَا فِيهِ بَيَاضٌ وَكُلَّ أَسْوَدَ بَيْنَ ٱلْخِرْفَانِ، وَدَفَعَهَا إِلَى أَيْدِي بَنِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","وَجَعَلَ مَسِيرَةَ ثَلَاثَةِ أَيَّامٍ بَيْنَهُ وَبَيْنَ يَعْقُوبَ، وَكَانَ يَعْقُوبُ يَرْعَى غَنَمَ لَابَانَ ٱلْبَاقِيَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","فَأَخَذَ يَعْقُوبُ لِنَفْسِهِ قُضْبَانًا خُضْرًا مِنْ لُبْنَى وَلَوْزٍ وَدُلْبٍ، وَقَشَّرَ فِيهَا خُطُوطًا بِيضًا، كَاشِطًا عَنِ ٱلْبَيَاضِ ٱلَّذِي عَلَى ٱلْقُضْبَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","وَأَوْقَفَ ٱلْقُضْبَانَ ٱلَّتِي قَشَّرَهَا فِي ٱلْأَجْرَانِ فِي مَسَاقِي ٱلْمَاءِ حَيْثُ كَانَتِ ٱلْغَنَمُ تَجِيءُ لِتَشْرَبَ، تُجَاهَ ٱلْغَنَمِ، لِتَتَوَحَّمَ عِنْدَ مَجِيئِهَا لِتَشْرَبَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","فَتَوَحَّمَتِ ٱلْغَنَمُ عِنْدَ ٱلْقُضْبَانِ، وَوَلَدَتِ ٱلْغَنَمُ مُخَطَّطَاتٍ وَرُقْطًا وَبُلْقًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","وَأَفْرَزَ يَعْقُوبُ ٱلْخِرْفَانَ وَجَعَلَ وُجُوهَ ٱلْغَنَمِ إِلَى ٱلْمُخَطَّطِ وَكُلِّ أَسْوَدَ بَيْنَ غَنَمِ لَابَانَ. وَجَعَلَ لَهُ قُطْعَانًا وَحْدَهُ وَلَمْ يَجْعَلْهَا مَعَ غَنَمِ لَابَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","وَحَدَثَ كُلَّمَا تَوَحَّمَتِ ٱلْغَنَمُ ٱلْقَوِيَّةُ أَنَّ يَعْقُوبَ وَضَعَ ٱلْقُضْبَانَ أَمَامَ عُيُونِ ٱلْغَنَمِ فِي ٱلْأَجْرَانِ لِتَتَوَحَّمَ بَيْنَ ٱلْقُضْبَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","وَحِينَ ٱسْتَضْعَفَتِ ٱلْغَنَمُ لَمْ يَضَعْهَا، فَصَارَتِ ٱلضَّعِيفَةُ لِلَابَانَ وَٱلْقَوِيَّةُ لِيَعْقُوبَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","فَٱتَّسَعَ ٱلرَّجُلُ كَثِيرًا جِدًّا، وَكَانَ لَهُ غَنَمٌ كَثِيرٌ وَجَوَارٍ وَعَبِيدٌ وَجِمَالٌ وَحَمِيرٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","فَسَمِعَ كَلَامَ بَنِي لَابَانَ قَائِلِينَ: «أَخَذَ يَعْقُوبُ كُلَّ مَا كَانَ لِأَبِينَا، وَمِمَّا لِأَبِينَا صَنَعَ كُلَّ هَذَا ٱلْمَجْدِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","وَنَظَرَ يَعْقُوبُ وَجْهَ لَابَانَ وَإِذَا هُوَ لَيْسَ مَعَهُ كَأَمْسِ وَأَوَّلَ مِنْ أَمْسِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","وَقَالَ ٱلرَّبُّ لِيَعْقُوبَ: «ٱرْجِعْ إِلَى أَرْضِ آبَائِكَ وَإِلَى عَشِيرَتِكَ، فَأَكُونَ مَعَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","فَأَرْسَلَ يَعْقُوبُ وَدَعَا رَاحِيلَ وَلَيْئَةَ إِلَى ٱلْحَقْلِ إِلَى غَنَمِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","وَقَالَ لَهُمَا: «أَنَا أَرَى وَجْهَ أَبِيكُمَا أَنَّهُ لَيْسَ نَحْوِي كَأَمْسِ وَأَوَّلَ مِنْ أَمْسِ. وَلَكِنْ إِلَهُ أَبِي كَانَ مَعِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","وَأَنْتُمَا تَعْلَمَانِ أَنِّي بِكُلِّ قُوَّتِي خَدَمْتُ أَبَاكُمَا، ");
INSERT INTO arb_vd_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","وَأَمَّا أَبُوكُمَا فَغَدَرَ بِي وَغَيَّرَ أُجْرَتِي عَشَرَ مَرَّاتٍ. لَكِنَّ ٱللهَ لَمْ يَسْمَحْ لَهُ أَنْ يَصْنَعَ بِي شَرًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","إِنْ قَالَ هَكَذَا: ٱلرُّقْطُ تَكُونُ أُجْرَتَكَ، وَلَدَتْ كُلُّ ٱلْغَنَمِ رُقْطًا. وَإِنْ قَالَ هَكَذَا: ٱلْمُخَطَّطَةُ تَكُونُ أُجْرَتَكَ، وَلَدَتْ كُلُّ ٱلْغَنَمِ مُخَطَّطَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","فَقَدْ سَلَبَ ٱللهُ مَوَاشِيَ أَبِيكُمَا وَأَعْطَانِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","وَحَدَثَ فِي وَقْتِ تَوَحُّمِ ٱلْغَنَمِ أَنِّي رَفَعْتُ عَيْنَيَّ وَنَظَرْتُ فِي حُلْمٍ، وَإِذَا ٱلْفُحُولُ ٱلصَّاعِدَةُ عَلَى ٱلْغَنَمِ مُخَطَّطَةٌ وَرَقْطَاءُ وَمُنَمَّرَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","وَقَالَ لِي مَلَاكُ ٱللهِ فِي ٱلْحُلْمِ: يَا يَعْقُوبُ. فَقُلْتُ: هَأَنَذَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","فَقَالَ: ٱرْفَعْ عَيْنَيْكَ وَٱنْظُرْ. جَمِيعُ ٱلْفُحُولِ ٱلصَّاعِدَةِ عَلَى ٱلْغَنَمِ مُخَطَّطَةٌ وَرَقْطَاءُ وَمُنَمَّرَةٌ، لِأَنِّي قَدْ رَأَيْتُ كُلَّ مَا يَصْنَعُ بِكَ لَابَانُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","أَنَا إِلَهُ بَيْتِ إِيلَ حَيْثُ مَسَحْتَ عَمُودًا، حَيْثُ نَذَرْتَ لِي نَذْرًا. ٱلْآنَ قُمِ ٱخْرُجْ مِنْ هَذِهِ ٱلْأَرْضِ وَٱرْجِعْ إِلَى أَرْضِ مِيلَادِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","فَأَجَابَتْ رَاحِيلُ وَلَيْئَةُ وَقَاَلتَا لَهُ: «أَلَنَا أَيْضًا نَصِيبٌ وَمِيرَاثٌ فِي بَيْتِ أَبِينَا؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","أَلَمْ نُحْسَبْ مِنْهُ أَجْنَبِيَّتَيْنِ، لِأَنَّهُ بَاعَنَا وَقَدْ أَكَلَ أَيْضًا ثَمَنَنَا؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","إِنَّ كُلَّ ٱلْغِنَى ٱلَّذِي سَلَبَهُ ٱللهُ مِنْ أَبِينَا هُوَ لَنَا وَلِأَوْلَادِنَا، فَٱلْآنَ كُلَّ مَا قَالَ لَكَ ٱللهُ ٱفْعَلْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","فَقَامَ يَعْقُوبُ وَحَمَلَ أَوْلَادَهُ وَنِسَاءَهُ عَلَى ٱلْجِمَالِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","وَسَاقَ كُلَّ مَوَاشِيهِ وَجَمِيعَ مُقْتَنَاهُ ٱلَّذِي كَانَ قَدِ ٱقْتَنَى: مَوَاشِيَ ٱقْتِنَائِهِ ٱلَّتِي ٱقْتَنَى فِي فَدَّانِ أَرَامَ، لِيَجِيءَ إِلَى إِسْحَاقَ أَبِيهِ إِلَى أَرْضِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","وَأَمَّا لَابَانُ فَكَانَ قَدْ مَضَى لِيَجُزَّ غَنَمَهُ، فَسَرَقَتْ رَاحِيلُ أَصْنَامَ أَبِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","وَخَدَعَ يَعْقُوبُ قَلْبَ لَابَانَ ٱلْأَرَامِيِّ إِذْ لَمْ يُخْبِرْهُ بِأَنَّهُ هَارِبٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","فَهَرَبَ هُوَ وَكُلُّ مَا كَانَ لَهُ، وَقَامَ وَعَبَرَ ٱلنَّهْرَ وَجَعَلَ وَجْهَهُ نَحْوَ جَبَلِ جِلْعَادَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","فَأُخْبِرَ لَابَانُ فِي ٱلْيَوْمِ ٱلثَّالِثِ بِأَنَّ يَعْقُوبَ قَدْ هَرَبَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","فَأَخَذَ إِخْوَتَهُ مَعَهُ وَسَعَى وَرَاءَهُ مَسِيرَةَ سَبْعَةِ أَيَّامٍ، فَأَدْرَكَهُ فِي جَبَلِ جِلْعَادَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","وَأَتَى ٱللهُ إِلَى لَابَانَ ٱلْأَرَامِيِّ فِي حُلْمِ ٱللَّيْلِ وَقَالَ لَهُ: «ٱحْتَرِزْ مِنْ أَنْ تُكَلِّمَ يَعْقُوبَ بِخَيْرٍ أَوْ شَرٍّ». ");
INSERT INTO arb_vd_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","فَلَحِقَ لَابَانُ يَعْقُوبَ، وَيَعْقُوبُ قَدْ ضَرَبَ خَيْمَتَهُ فِي ٱلْجَبَلِ. فَضَرَبَ لَابَانُ مَعَ إِخْوَتِهِ فِي جَبَلِ جِلْعَادَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","وَقَالَ لَابَانُ لِيَعْقُوبَ: «مَاذَا فَعَلْتَ، وَقَدْ خَدَعْتَ قَلْبِي، وَسُقْتَ بَنَاتِي كَسَبَايَا ٱلسَّيْفِ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","لِمَاذَا هَرَبْتَ خُفْيَةً وَخَدَعْتَنِي وَلَمْ تُخْبِرْنِي حَتَّى أُشَيِّعَكَ بِٱلْفَرَحِ وَٱلْأَغَانِيِّ، بِٱلدُّفِّ وَٱلْعُودِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","وَلَمْ تَدَعْنِي أُقَبِّلُ بَنِيَّ وَبَنَاتِي؟ ٱلْآنَ بِغَبَاوَةٍ فَعَلْتَ! ");
INSERT INTO arb_vd_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","فِي قُدْرَةِ يَدِي أَنْ أَصْنَعَ بِكُمْ شَرًّا، وَلَكِنْ إِلَهُ أَبِيكُمْ كَلَّمَنِيَ ٱلْبَارِحَةَ قَائِلًا: ٱحْتَرِزْ مِنْ أَنْ تُكَلِّمَ يَعْقُوبَ بِخَيْرٍ أَوْ شَرٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","وَٱلْآنَ أَنْتَ ذَهَبْتَ لِأَنَّكَ قَدِ ٱشْتَقْتَ إِلَى بَيْتِ أَبِيكَ، وَلَكِنْ لِمَاذَا سَرَقْتَ آلِهَتِي؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","فَأَجَابَ يَعْقُوبُ وَقَالَ لِلَابَانَ: «إِنِّي خِفْتُ لِأَنِّي قُلْتُ لَعَلَّكَ تَغْتَصِبُ ٱبْنَتَيْكَ مِنِّي. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","اَلَّذِي تَجِدُ آلِهَتَكَ مَعَهُ لَا يَعِيشُ. قُدَّامَ إِخْوَتِنَا ٱنْظُرْ مَاذَا مَعِي وَخُذْهُ لِنَفْسِكَ». وَلَمْ يَكُنْ يَعْقُوبُ يَعْلَمُ أَنَّ رَاحِيلَ سَرَقَتْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","فَدَخَلَ لَابَانُ خِبَاءَ يَعْقُوبَ وَخِبَاءَ لَيْئَةَ وَخِبَاءَ ٱلْجَارِيَتَيْنِ وَلَمْ يَجِدْ. وَخَرَجَ مِنْ خِبَاءِ لَيْئَةَ وَدَخَلَ خِبَاءَ رَاحِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","وَكَانَتْ رَاحِيلُ قَدْ أَخَذَتِ ٱلْأَصْنَامَ وَوَضَعَتْهَا فِي حِدَاجَةِ ٱلْجَمَلِ وَجَلَسَتْ عَلَيْهَا. فَجَسَّ لَابَانُ كُلَّ ٱلْخِبَاءِ وَلَمْ يَجِدْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","وَقَالَتْ لِأَبِيهَا: «لَا يَغْتَظْ سَيِّدِي أَنِّي لَا أَسْتَطِيعُ أَنْ أَقُومَ أَمَامَكَ لِأَنَّ عَلَيَّ عَادَةَ ٱلنِّسَاءِ». فَفَتَّشَ وَلَمْ يَجِدِ ٱلْأَصْنَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","فَٱغْتَاظَ يَعْقُوبُ وَخَاصَمَ لَابَانَ. وَأجَابَ يَعْقُوبُ وَقَالَ لِلَابَانَ: «مَا جُرْمِي؟ مَا خَطِيَّتِي حَتَّى حَمِيتَ وَرَائِي؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","إِنَّكَ جَسَسْتَ جَمِيعَ أَثَاثِي. مَاذَا وَجَدْتَ مِنْ جَمِيعِ أَثَاثِ بَيْتِكَ؟ ضَعْهُ هَهُنَا قُدَّامَ إِخْوَتِي وَإِخْوَتِكَ، فَلْيُنْصِفُوا بَيْنَنَا ٱلِٱثْنَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","اَلْآنَ عِشْرِينَ سَنَةً أَنَا مَعَكَ. نِعَاجُكَ وَعِنَازُكَ لَمْ تُسْقِطْ، وَكِبَاشَ غَنَمِكَ لَمْ آكُلْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","فَرِيسَةً لَمْ أُحْضِرْ إِلَيْكَ. أَنَا كُنْتُ أَخْسَرُهَا. مِنْ يَدِي كُنْتَ تَطْلُبُهَا. مَسْرُوقَةَ ٱلنَّهَارِ أَوْ مَسْرُوقَةَ ٱللَّيْلِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","كُنْتُ فِي ٱلنَّهَارِ يَأْكُلُنِي ٱلْحَرُّ وَفِي ٱللَّيْلِ ٱلْجَلِيدُ، وَطَارَ نَوْمِي مِنْ عَيْنَيَّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","اَلْآنَ لِي عِشْرُونَ سَنَةً فِي بَيْتِكَ. خَدَمْتُكَ أَرْبَعَ عَشَرَةَ سَنَةً بَٱبْنَتَيْكَ، وَسِتَّ سِنِينٍ بِغَنَمِكَ. وَقَدْ غَيَّرْتَ أُجْرَتِي عَشَرَ مَرَّاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","لَوْلَا أَنَّ إِلَهَ أَبِي إِلَهَ إِبْرَاهِيمَ وَهَيْبَةَ إِسْحَاقَ كَانَ مَعِي، لَكُنْتَ ٱلْآنَ قَدْ صَرَفْتَنِي فَارِغًا. مَشَقَّتِي وَتَعَبَ يَدَيَّ قَدْ نَظَرَ ٱللهُ، فَوَبَّخَكَ ٱلْبَارِحَةَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","فَأَجَابَ لَابَانُ وَقَالَ لِيَعقُوبَ: «ٱلْبَنَاتُ بَنَاتِي، وَٱلْبَنُونَ بَنِيَّ، وَٱلْغَنَمُ غَنَمِي، وَكُلُّ مَا أَنْتَ تَرَى فَهُوَ لِي. فَبَنَاتِي مَاذَا أَصْنَعُ بِهِنَّ ٱلْيَوْمَ أَوْ بِأَوْلَادِهِنَّ ٱلَّذِينَ وَلَدْنَ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","فَٱلْآنَ هَلُمَّ نَقْطَعْ عَهْدًا أَنَا وَأَنْتَ، فَيَكُونُ شَاهِدًا بَيْنِي وَبَيْنَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","فَأَخَذَ يَعْقُوبُ حَجَرًا وَأَوْقَفَهُ عَمُودًا، ");
INSERT INTO arb_vd_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","وَقَالَ يَعْقُوبُ لِإِخْوَتِهِ: «ٱلْتَقِطُوا حِجَارَةً». فَأَخَذُوا حِجَارَةً وَعَمِلُوا رُجْمَةً وَأَكَلُوا هُنَاكَ عَلَى ٱلرُّجْمَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","وَدَعَاهَا لَابَانُ «يَجَرْ سَهْدُوثَا» وَأَمَّا يَعْقُوبُ فَدَعَاهَا «جَلْعِيدَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","وَقَالَ لَابَانُ: «هَذِهِ ٱلرُّجْمَةُ هِيَ شَاهِدَةٌ بَيْنِي وَبَيْنَكَ ٱلْيَوْمَ». لِذَلِكَ دُعِيَ ٱسْمُهَا «جَلْعِيدَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","وَ«ٱلْمِصْفَاةَ»، لِأَنَّهُ قَالَ: «لِيُرَاقِبِ ٱلرَّبُّ بَيْنِي وَبَيْنَكَ حِينَمَا نَتَوَارَى بَعْضُنَا عَنْ بَعْضٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","إِنَّكَ لَا تُذِلُّ بَنَاتِي، وَلَا تَأْخُذُ نِسَاءً عَلَى بَنَاتِي. لَيْسَ إِنْسَانٌ مَعَنَا. اُنْظُرْ، ٱللهُ شَاهِدٌ بَيْنِي وَبَيْنَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","وَقَالَ لَابَانُ لِيَعْقُوبَ: «هُوَذَا هَذِهِ ٱلرُّجْمَةُ، وَهُوَذَا ٱلْعَمُودُ ٱلَّذِي وَضَعْتُ بَيْنِي وَبَيْنَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","شَاهِدَةٌ هَذِهِ ٱلرُّجْمَةُ وَشَاهِدٌ ٱلْعَمُودُ أَنِّي لَا أَتَجَاوَزُ هَذِهِ ٱلرُّجْمَةَ إِلَيْكَ، وَأَنَّكَ لَا تَتَجَاوَزُ هَذِهِ ٱلرُّجْمَةَ وَهَذَا ٱلْعَمُودَ إِلَيَّ لِلشَّرِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","إِلَهُ إِبْرَاهِيمَ وَآلِهَةُ نَاحُورَ، آلِهَةُ أَبِيهِمَا، يَقْضُونَ بَيْنَنَا». وَحَلَفَ يَعْقُوبُ بِهَيْبَةِ أَبِيهِ إِسْحَاقَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","وَذَبَحَ يَعْقُوبُ ذَبِيحَةً فِي ٱلْجَبَلِ وَدَعَا إِخْوَتَهُ لِيَأْكُلُوا طَعَامًا، فَأَكَلُوا طَعَامًا وَبَاتُوا فِي ٱلْجَبَلِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ثُمَّ بَكَّرَ لَابَانُ صَبَاحًا وَقَبَّلَ بَنِيهِ وَبَنَاتِهِ وَبَارَكَهُمْ وَمَضَى. وَرَجَعَ لَابَانُ إِلَى مَكَانِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","وَأَمَّا يَعْقُوبُ فَمَضَى فِي طَرِيقِهِ وَلَاقَاهُ مَلَائِكَةُ ٱللهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","وَقَالَ يَعْقُوبُ إِذْ رَآهُمْ: «هَذَا جَيْشُ ٱللهِ!». فَدَعَا ٱسْمَ ذَلِكَ ٱلْمَكَانِ «مَحَنَايِمَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","وَأَرْسَلَ يَعْقُوبُ رُسُلًا قُدَّامَهُ إِلَى عِيسُوَ أَخِيهِ إِلَى أَرْضِ سَعِيرَ بِلَادِ أَدُومَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","وَأَمَرَهُمْ قَائِلًا: «هَكَذَا تَقُولُونَ لِسَيِّدِي عِيسُوَ: هَكَذَا قَالَ عَبْدُكَ يَعْقُوبُ: تَغَرَّبْتُ عِنْدَ لَابَانَ وَلَبِثْتُ إِلَى ٱلْآنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","وَقَدْ صَارَ لِي بَقَرٌ وَحَمِيرٌ وَغَنَمٌ وَعَبِيدٌ وَإِمَاءٌ. وَأَرْسَلْتُ لِأُخْبِرَ سَيِّدِي لِكَيْ أَجِدَ نِعْمَةً فِي عَيْنَيْكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","فَرَجَعَ ٱلرُّسُلُ إِلَى يَعْقُوبَ قَائِلِينَ: «أَتَيْنَا إِلَى أَخِيكَ، إِلَى عِيسُو، وَهُوَ أَيْضًا قَادِمٌ لِلِقَائِكَ، وَأَرْبَعُ مِئَةِ رَجُلٍ مَعَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","فَخَافَ يَعْقُوبُ جِدًّا وَضَاقَ بِهِ ٱلْأَمْرُ، فَقَسَمَ ٱلْقَوْمَ ٱلَّذِينَ مَعَهُ وَٱلْغَنَمَ وَٱلْبَقَرَ وَٱلْجِمَالَ إِلَى جَيْشَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","وَقَالَ: «إِنْ جَاءَ عِيسُو إِلَى ٱلْجَيْشِ ٱلْوَاحِدِ وَضَرَبَهُ، يَكُونُ ٱلْجَيْشُ ٱلْبَاقِي نَاجِيًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","وَقَالَ يَعْقُوبُ: «يَا إِلَهَ أَبِي إِبْرَاهِيمَ وَإِلَهَ أَبِي إِسْحَاقَ، ٱلرَّبَّ ٱلَّذِي قَالَ لِيَ: ٱرْجِعْ إِلَى أَرْضِكَ وَإِلَى عَشِيرَتِكَ فَأُحْسِنَ إِلَيْكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","صَغِيرٌ أَنَا عَنْ جَمِيعِ أَلْطَافِكَ وَجَمِيعِ ٱلْأَمَانَةِ ٱلَّتِي صَنَعْتَ إِلَى عَبْدِكَ. فَإِنِّي بِعَصَايَ عَبَرْتُ هَذَا ٱلْأُرْدُنَّ، وَٱلْآنَ قَدْ صِرْتُ جَيْشَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","نَجِّنِي مِنْ يَدِ أَخِي، مِنْ يَدِ عِيسُوَ، لِأَنِّي خَائِفٌ مِنْهُ أَنْ يَأْتِيَ وَيَضْرِبَنِي ٱلْأُمَّ مَعَ ٱلْبَنِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","وَأَنْتَ قَدْ قُلْتَ: إِنِّي أُحْسِنُ إِلَيْكَ وَأَجْعَلُ نَسْلَكَ كَرَمْلِ ٱلْبَحْرِ ٱلَّذِي لَا يُعَدُّ لِلْكَثْرَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","وَبَاتَ هُنَاكَ تِلْكَ ٱللَّيْلَةَ وَأَخَذَ مِمَّا أَتَى بِيَدِهِ هَدِيَّةً لِعِيسُو أَخِيهِ: ");
INSERT INTO arb_vd_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","مِئَتَيْ عَنْزٍ وَعِشْرِينَ تَيْسًا، مِئَتَيْ نَعْجَةٍ وَعِشْرِينَ كَبْشًا، ");
INSERT INTO arb_vd_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ثَلَاثِينَ نَاقَةً مُرْضِعَةً وَأَوْلَادَهَا، أَرْبَعِينَ بَقَرَةً وَعَشْرَةَ ثِيرَانٍ، عِشْرِينَ أَتَانًا وَعَشْرَةَ حَمِيرٍ، ");
INSERT INTO arb_vd_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","وَدَفَعَهَا إِلَى يَدِ عَبِيدِهِ قَطِيعًا قَطِيعًا عَلَى حِدَةٍ. وَقَالَ لِعَبِيدِهِ: «ٱجْتَازُوا قُدَّامِي وَٱجْعَلُوا فُسْحَةً بَيْنَ قَطِيعٍ وَقَطِيعٍ». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","وَأَمَرَ ٱلْأَوَّلَ قَائِلًا: «إِذَا صَادَفَكَ عِيسُو أَخِي وَسَأَلَكَ قَائِلًا: لِمَنْ أَنْتَ؟ وَإِلَى أَيْنَ تَذْهَبُ؟ وَلِمَنْ هَذَا ٱلَّذِي قُدَّامَكَ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","تَقُولُ: لِعَبْدِكَ يَعْقُوبَ. هُوَ هَدِيَّةٌ مُرْسَلَةٌ لِسَيِّدِي عِيسُوَ، وَهَا هُوَ أَيْضًا وَرَاءَنَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","وَأَمَرَ أَيْضًا ٱلْثَانِى وَٱلثَّالِثَ وَجَمِيعَ ٱلسَّائِرِينَ وَرَاءَ ٱلْقُطْعَانِ قَائِلًا: «بِمِثْلِ هَذَا ٱلْكَلَامِ تُكَلِّمُونَ عِيسُوَ حِينَمَا تَجِدُونَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","وَتَقُولُونَ: هُوَذَا عَبْدُكَ يَعْقُوبُ أَيْضًا وَرَاءَنَا». لِأَنَّهُ قَالَ: «أَسْتَعْطِفُ وَجْهَهُ بِٱلْهَدِيَّةِ ٱلسَّائِرَةِ أَمَامِي، وَبَعْدَ ذَلِكَ أَنْظُرُ وَجْهَهُ، عَسَى أَنْ يَرْفَعَ وَجْهِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","فَٱجْتَازَتِ ٱلْهَدِيَّةُ قُدَّامَهُ، وَأَمَّا هُوَ فَبَاتَ تِلْكَ ٱللَّيْلَةَ فِي ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ثُمَّ قَامَ فِي تِلْكَ ٱللَّيْلَةِ وَأَخَذَ ٱمْرَأَتَيْهِ وَجَارِيَتَيْهِ وَأَوْلَادَهُ ٱلْأَحَدَ عَشَرَ وَعَبَرَ مَخَاضَةَ يَبُّوقَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","أَخَذَهُمْ وَأَجَازَهُمُ ٱلْوَادِيَ، وَأَجَازَ مَا كَانَ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","فَبَقِيَ يَعْقُوبُ وَحْدَهُ، وَصَارَعَهُ إِنْسَانٌ حَتَّى طُلُوعِ ٱلْفَجْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","وَلَمَّا رَأَى أَنَّهُ لَا يَقْدِرُ عَلَيْهِ، ضَرَبَ حُقَّ فَخْذِهِ، فَٱنْخَلَعَ حُقُّ فَخْذِ يَعْقُوبَ فِي مُصَارَعَتِهِ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","وَقَالَ: «أَطْلِقْنِي، لِأَنَّهُ قَدْ طَلَعَ ٱلْفَجْرُ». فَقَالَ: «لَا أُطْلِقُكَ إِنْ لَمْ تُبَارِكْنِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","فَقَالَ لَهُ: «مَا ٱسْمُكَ؟» فَقَالَ: «يَعْقُوبُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","فَقَالَ: «لَا يُدْعَى ٱسْمُكَ فِي مَا بَعْدُ يَعْقُوبَ بَلْ إِسْرَائِيلَ، لِأَنَّكَ جَاهَدْتَ مَعَ ٱللهِ وَٱلنَّاسِ وَقَدَرْتَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","وَسَأَلَ يَعْقُوبُ وَقَالَ: «أَخْبِرْنِي بِٱسْمِكَ». فَقَالَ: «لِمَاذَا تَسْأَلُ عَنِ ٱسْمِي؟». وَبَارَكَهُ هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","فَدَعَا يَعْقُوبُ ٱسْمَ ٱلْمَكَانِ «فَنِيئِيلَ» قَائِلًا: «لِأَنِّي نَظَرْتُ ٱللهَ وَجْهًا لِوَجْهٍ، وَنُجِّيَتْ نَفْسِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","وَأَشْرَقَتْ لَهُ ٱلشَّمْسُ إِذْ عَبَرَ فَنُوئِيلَ وَهُوَ يَخْمَعُ عَلَى فَخْذِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","لِذَلِكَ لَا يَأْكُلُ بَنُو إِسْرَائِيلَ عِرْقَ ٱلنَّسَا ٱلَّذِي عَلَى حُقِّ ٱلْفَخْذِ إِلَى هَذَا ٱلْيَوْمِ، لِأَنَّهُ ضَرَبَ حُقَّ فَخْذِ يَعْقُوبَ عَلَى عِرْقِ ٱلنَّسَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","وَرَفَعَ يَعْقُوبُ عَيْنَيْهِ وَنَظَرَ وَإِذَا عِيسُو مُقْبِلٌ وَمَعَهُ أَرْبَعُ مِئَةِ رَجُلٍ، فَقَسَمَ ٱلْأَوْلَادَ عَلَى لَيْئَةَ وَعَلَى رَاحِيلَ وَعَلَى ٱلْجَارِيَتَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","وَوَضَعَ ٱلْجَارِيَتَيْنِ وَأَوْلَادَهُمَا أَوَّلًا، وَلَيْئَةَ وَأَوْلَادَهَا وَرَاءَهُمْ، وَرَاحِيلَ وَيُوسُفَ أَخِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","وَأَمَّا هُوَ فَٱجْتَازَ قُدَّامَهُمْ وَسَجَدَ إِلَى ٱلْأَرْضِ سَبْعَ مَرَّاتٍ حَتَّى ٱقْتَرَبَ إِلَى أَخِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","فَرَكَضَ عِيسُو لِلِقَائِهِ وَعَانَقَهُ وَوَقَعَ عَلَى عُنُقِهِ وَقَبَّلَهُ، وَبَكَيَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ثُمَّ رَفَعَ عَيْنَيْهِ وَأَبْصَرَ ٱلنِّسَاءَ وَٱلْأَوْلَادَ وَقَالَ: «مَا هَؤُلَاءِ مِنْكَ؟» فَقَالَ: «ٱلْأَوْلَادُ ٱلَّذِينَ أَنْعَمَ ٱللهُ بِهِمْ عَلَى عَبْدِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","فَٱقْتَرَبَتِ ٱلْجَارِيَتَانِ هُمَا وَأَوْلَادُهُمَا وَسَجَدَتَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ثُمَّ ٱقْتَرَبَتْ لَيْئَةُ أَيْضًا وَأَوْلَادُهَا وَسَجَدُوا. وَبَعْدَ ذَلِكَ ٱقْتَرَبَ يُوسُفُ وَرَاحِيلُ وَسَجَدَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","فَقَالَ: «مَاذَا مِنْكَ كُلُّ هَذَا ٱلْجَيْشِ ٱلَّذِي صَادَفْتُهُ؟» فَقَالَ: «لِأَجِدَ نِعْمَةً فِي عَيْنَيْ سَيِّدِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","فَقَالَ عِيسُو: «لِي كَثِيرٌ، يَا أَخِي. لِيَكُنْ لَكَ ٱلَّذِي لَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","فَقَالَ يَعْقُوبُ: «لَا. إِنْ وَجَدْتُ نِعْمَةً فِي عَيْنَيْكَ تَأْخُذْ هَدِيَّتِي مِنْ يَدِي، لِأَنِّي رَأَيْتُ وَجْهَكَ كَمَا يُرَى وَجْهُ ٱللهِ، فَرَضِيتَ عَلَيَّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","خُذْ بَرَكَتِي ٱلَّتِي أُتِيَ بِهَا إِلَيْكَ، لِأَنَّ ٱللهَ قَدْ أَنْعَمَ عَلَيَّ وَلِي كُلُّ شَيْءٍ». وَأَلَحَّ عَلَيْهِ فَأَخَذَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ثُمَّ قَالَ: «لِنَرْحَلْ وَنَذْهَبْ، وَأَذْهَبُ أَنَا قُدَّامَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","فَقَالَ لَهُ: «سَيِّدِي عَالِمٌ أَنَّ ٱلْأَوْلَادَ رَخْصَةٌ، وَٱلْغَنَمَ وَٱلْبَقَرَ ٱلَّتِي عِنْدِي مُرْضِعَةٌ، فَإِنِ ٱسْتَكَدُّوهَا يَوْمًا وَاحِدًا مَاتَتْ كُلُّ ٱلْغَنَمِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","لِيَجْتَزْ سَيِّدِي قُدَّامَ عَبْدِهِ، وَأَنَا أَسْتَاقُ عَلَى مَهَلِي فِي إِثْرِ ٱلْأَمْلَاكِ ٱلَّتِي قُدَّامِي، وَفِي إِثْرِ ٱلْأَوْلَادِ، حَتَّى أَجِيءَ إِلَى سَيِّدِي إِلَى سَعِيرَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","فَقَالَ عِيسُو: «أَتْرُكُ عِنْدَكَ مِنَ ٱلْقَوْمِ ٱلَّذِينَ مَعِي». فَقَالَ: «لِمَاذَا؟ دَعْنِي أَجِدْ نِعْمَةً فِي عَيْنَيْ سَيِّدِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","فَرَجَعَ عِيسُو ذَلِكَ ٱلْيَوْمَ فِي طَرِيقِهِ إِلَى سَعِيرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","وَأَمَّا يَعْقُوبُ فَٱرْتَحَلَ إِلَى سُكُّوتَ، وَبَنَى لِنَفْسِهِ بَيْتًا، وَصَنَعَ لِمَوَاشِيهِ مِظَالًا. لِذَلِكَ دَعَا ٱسْمَ ٱلْمَكَانِ «سُكُّوتَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ثُمَّ أَتَى يَعْقُوبُ سَالِمًا إِلَى مَدِينَةِ شَكِيمَ ٱلَّتِي فِي أَرْضِ كَنْعَانَ، حِينَ جَاءَ مِنْ فَدَّانِ أَرَامَ. وَنَزَلَ أَمَامَ ٱلْمَدِينَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","وَٱبْتَاعَ قِطْعَةَ ٱلْحَقْلِ ٱلَّتِي نَصَبَ فِيهَا خَيْمَتَهُ مِنْ يَدِ بَنِي حَمُورَ أَبِي شَكِيمَ بِمِئَةِ قَسِيطَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","وَأَقَامَ هُنَاكَ مَذْبَحًا وَدَعَاهُ «إِيلَ إِلَهَ إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","وَخَرَجَتْ دِينَةُ ٱبْنَةُ لَيْئَةَ ٱلَّتِي وَلَدَتْهَا لِيَعْقُوبَ لِتَنْظُرَ بَنَاتِ ٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","فَرَآهَا شَكِيمُ ٱبْنُ حَمُورَ ٱلْحِوِّيِّ رَئِيسِ ٱلْأَرْضِ، وَأَخَذَهَا وَٱضْطَجَعَ مَعَهَا وَأَذَلَّهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","وَتَعَلَّقَتْ نَفْسُهُ بِدِينَةَ ٱبْنَةِ يَعْقُوبَ، وَأَحَبَّ ٱلْفَتَاةَ وَلَاطَفَ ٱلْفَتاةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","فَكَلَّمَ شَكِيمُ حَمُورَ أَبَاهُ قَائِلًا: «خُذْ لِي هَذِهِ ٱلصَّبِيَّةَ زَوْجَةً». ");
INSERT INTO arb_vd_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","وَسَمِعَ يَعْقُوبُ أَنَّهُ نَجَّسَ دِينَةَ ٱبْنَتَهُ. وَأَمَّا بَنُوهُ فَكَانُوا مَعَ مَوَاشِيهِ فِي ٱلْحَقْلِ، فَسَكَتَ يَعْقُوبُ حَتَّى جَاءُوا. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","فَخَرَجَ حَمُورُ أَبُو شَكِيمَ إِلَى يَعْقُوبَ لِيَتَكَلَّمَ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","وَأَتَى بَنُو يَعْقُوبَ مِنَ ٱلْحَقْلِ حِينَ سَمِعُوا. وَغَضِبَ ٱلرِّجَالُ وَٱغْتَاظُوا جِدًّا لِأَنَّهُ صَنَعَ قَبَاحَةً فِي إِسْرَائِيلَ بِمُضَاجَعَةِ ٱبْنَةِ يَعْقُوبَ، وَهَكَذَا لَا يُصْنَعُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","وَتَكَلَّمَ حَمُورُ مَعَهُمَ قَائِلًا: «شَكِيمُ ٱبْنِي قَدْ تَعَلَّقَتْ نَفْسُهُ بِٱبْنَتِكُمْ. أَعْطُوهُ إِيَّاهَا زَوْجَةً ");
INSERT INTO arb_vd_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","وَصَاهِرُونَا. تُعْطُونَنَا بَنَاتِكُمْ، وَتَأْخُذُونَ لَكُمْ بَنَاتِنَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","وَتَسْكُنُونَ مَعَنَا، وَتَكُونُ ٱلْأَرْضُ قُدَّامَكُمُ. ٱسْكُنُوا وَٱتَّجِرُوا فِيهَا وَتَمَلَّكُوا بِهَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ثُمَّ قَالَ شَكِيمُ لِأَبِيهَا وَلإِخْوَتِهَا: «دَعُونِي أَجِدْ نِعْمَةً فِي أَعْيُنِكُمْ. فَٱلَّذِي تَقُولُونَ لِي أُعْطِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","كَثِّرُوا عَلَيَّ جِدًّا مَهْرًا وَعَطِيَّةً، فَأُعْطِيَ كَمَا تَقُولُونَ لِي. وَأَعْطُونِي ٱلْفَتَاةَ زَوْجَةً». ");
INSERT INTO arb_vd_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","فَأَجَابَ بَنُو يَعْقُوبَ شَكِيمَ وَحَمُورَ أَبَاهُ بِمَكْرٍ وَتَكَلَّمُوا. لِأَنَّهُ كَانَ قَدْ نَجَّسَ دِينَةَ أُخْتَهُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","فَقَالُوُا لَهُمَا: «لَا نَسْتَطِيعُ أَنْ نَفْعَلَ هَذَا ٱلْأَمْرَ أَنْ نُعْطِيَ أُخْتَنَا لِرَجُلٍ أَغْلَفَ، لِأَنَّهُ عَارٌ لَنَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","غَيْرَ أَنَّنَا بِهَذَا نُواتِيكُمْ: إِنْ صِرْتُمْ مِثْلَنَا بِخَتْنِكُمْ كُلَّ ذَكَرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","نُعْطِيكُمْ بَنَاتِنَا وَنَأْخُذُ لَنَا بَنَاتِكُمْ، وَنَسْكُنُ مَعَكُمْ وَنَصِيرُ شَعْبًا وَاحِدًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","وَإِنْ لَمْ تَسْمَعُوا لَنَا، أَنْ تَخْتَتِنُوا، نَأْخُذُ ٱبْنَتَنَا وَنَمْضِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","فَحَسُنَ كَلَامُهُمْ فِي عَيْنَيْ حَمُورَ وَفِي عَيْنَيْ شَكِيمَ بْنِ حَمُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","وَلَمْ يَتَأَخَّرِ ٱلْغُلَامُ أَنْ يَفْعَلَ ٱلْأَمْرَ، لِأَنَّهُ كَانَ مَسْرُورًا بِٱبْنَةِ يَعْقُوبَ. وَكَانَ أَكْرَمَ جَمِيعِ بَيْتِ أَبِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","فَأَتَى حَمُورُ وَشَكِيمُ ٱبْنُهُ إِلَى بَابِ مَدِينَتِهْمَا، وَكَلَّمَا أَهْلَ مَدِينَتِهْمَا قَائِلَيْنِ: ");
INSERT INTO arb_vd_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«هَؤُلَاءِ ٱلْقَوْمُ مُسَالِمُونَ لَنَا. فَلْيَسْكُنُوا فِي ٱلْأَرْضِ وَيَتَّجِرُوا فِيهَا. وَهُوَذَا ٱلْأَرْضُ وَاسِعَةُ ٱلطَّرَفَيْنِ أَمَامَهُمْ. نَأْخُذُ لَنَا بَنَاتِهِمْ زَوْجَاتٍ وَنُعْطِيهِمْ بَنَاتِنَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","غَيْرَ أَنَّهُ بِهَذَا فَقَطْ يُواتِينَا ٱلْقَوْمُ عَلَى ٱلسَّكَنِ مَعَنَا لِنَصِيرَ شَعْبًا وَاحِدًا: بِخَتْنِنَا كُلَّ ذَكَرٍ كَمَا هُمْ مَخْتُونُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","أَلَا تَكُونُ مَوَاشِيهِمْ وَمُقْتَنَاهُمْ وَكُلُّ بَهَائِمِهِمْ لَنَا؟ نُواتِيهِمْ فَقَطْ فَيَسْكُنُونَ مَعَنَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","فَسَمِعَ لِحَمُورَ وَشَكِيمَ ٱبْنِهِ جَمِيعُ ٱلْخَارِجِينَ مِنْ بَابِ ٱلْمَدِينَةِ، وَٱخْتَتَنَ كُلُّ ذَكَرٍ. كُلُّ ٱلْخَارِجِينَ مِنْ بَابِ ٱلْمَدِينَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","فَحَدَثَ فِي ٱلْيَوْمِ ٱلثَّالِثِ إِذْ كَانُوا مُتَوَجِّعِينَ أَنَّ ٱبْنَيْ يَعْقُوبَ، شِمْعُونَ وَلَاوِيَ أَخَوَيْ دِينَةَ، أَخَذَا كُلُّ وَاحِدٍ سَيْفَهُ وَأَتَيَا عَلَى ٱلْمَدِينَةِ بِأَمْنٍ وَقَتَلَا كُلَّ ذَكَرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","وَقَتَلَا حَمُورَ وَشَكِيمَ ٱبْنَهُ بِحَدِّ ٱلسَّيْفِ، وَأَخَذَا دِينَةَ مِنْ بَيْتِ شَكِيمَ وَخَرَجَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ثُمَّ أَتَى بَنُو يَعْقُوبَ عَلَى ٱلْقَتْلَى وَنَهَبُوا ٱلْمَدِينَةَ، لِأَنَّهُمْ نَجَّسُوا أُخْتَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","غَنَمَهُمْ وَبَقَرَهُمْ وَحَمِيرَهُمْ وَكُلُّ مَا فِي ٱلْمَدِينَةِ وَمَا فِي ٱلْحَقْلِ أَخَذُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","وَسَبَوْا وَنَهَبُوا كُلَّ ثَرْوَتِهِمْ وَكُلَّ أَطْفَالِهِمْ، وَنِسَاءَهُمْ وَكُلَّ مَا فِي ٱلْبُيُوتِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","فَقَالَ يَعْقُوبُ لِشَمْعُونَ وَلَاوِي: «كَدَّرْتُمَانِي بِتَكْرِيهِكُمَا إِيَّايَ عِنْدَ سُكَّانِ ٱلْأَرْضِ ٱلْكَنْعَانِيِّينَ وَٱلْفِرِزِيِّينَ، وَأَنَا نَفَرٌ قَلِيلٌ. فَيَجْتَمِعُونَ عَلَيَّ وَيَضْرِبُونَنِي، فَأَبِيدُ أَنَا وَبَيْتِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","فَقَالَا: «أَنَظِيرَ زَانِيَةٍ يَفْعَلُ بِأُخْتِنَا؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ثُمَّ قَالَ ٱللهُ لِيَعْقُوبَ: «قُمِ ٱصْعَدْ إِلَى بَيْتِ إِيلَ وَأَقِمْ هُنَاكَ، وَٱصْنَعْ هُنَاكَ مَذْبَحًا لِلهِ ٱلَّذِي ظَهَرَ لَكَ حِينَ هَرَبْتَ مِنْ وَجْهِ عِيسُو أَخِيكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","فَقَالَ يَعْقُوبُ لِبَيْتِهِ وَلِكُلِّ مَنْ كَانَ مَعَهُ: «ٱعْزِلُوا ٱلْآلِهَةَ ٱلْغَرِيبَةَ ٱلَّتِي بَيْنَكُمْ وَتَطَهَّرُوا وَأَبْدِلُوا ثِيَابَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","وَلْنَقُمْ وَنَصْعَدْ إِلَى بَيْتِ إِيلَ، فَأَصْنَعَ هُنَاكَ مَذْبَحًا لِلهِ ٱلَّذِي ٱسْتَجَابَ لِي فِي يَوْمِ ضِيقَتِي، وَكَانَ مَعِي فِي ٱلطَّرِيقِ ٱلَّذِي ذَهَبْتُ فِيهِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","فَأَعْطَوْا يَعْقُوبَ كُلَّ ٱلْآلِهَةِ ٱلْغَرِيبَةِ ٱلَّتِي فِي أَيْدِيهِمْ وَٱلْأَقْرَاطِ ٱلَّتِي فِي آذَانِهِمْ، فَطَمَرَهَا يَعْقُوبُ تَحْتَ ٱلْبُطْمَةِ ٱلَّتِي عِنْدَ شَكِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ثُمَّ رَحَلُوا، وَكَانَ خَوْفُ ٱللهِ عَلَى ٱلْمُدُنِ ٱلَّتِي حَوْلَهُمْ، فَلَمْ يَسْعَوْا وَرَاءَ بَنِي يَعْقُوبَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","فَأَتَى يَعْقُوبُ إِلَى لُوزَ ٱلَّتِي فِي أَرْضِ كَنْعَانَ، وَهِيَ بَيْتُ إِيلَ. هُوَ وَجَمِيعُ ٱلْقَوْمِ ٱلَّذِينَ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","وَبَنَى هُنَاكَ مَذْبَحًا، وَدَعَا ٱلْمَكَانَ «إِيلَ بَيْتِ إِيلَ» لِأَنَّهُ هُنَاكَ ظَهَرَ لَهُ ٱللهُ حِينَ هَرَبَ مِنْ وَجْهِ أَخِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","وَمَاتَتْ دَبُورَةُ مُرْضِعَةُ رِفْقَةَ وَدُفِنَتْ تَحْتَ بَيْتَ إِيلَ تَحْتَ ٱلْبَلُّوطَةِ، فَدَعَا ٱسْمَهَا «أَلُّونَ بَاكُوتَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","وَظَهَرَ ٱللهُ لِيَعْقُوبَ أَيْضًا حِينَ جَاءَ مِنْ فَدَّانِ أَرَامَ وَبَارَكَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","وَقَالَ لَهُ ٱللهُ: «ٱسْمُكَ يَعْقُوبُ. لَا يُدْعَى ٱسْمُكَ فِيمَا بَعْدُ يَعْقُوبَ، بَلْ يَكُونُ ٱسْمُكَ إِسْرَائِيلَ». فَدَعَا ٱسْمَهُ «إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","وَقَالَ لَهُ ٱللهُ: «أَنَا ٱللهُ ٱلْقَدِيرُ. أَثْمِرْ وَٱكْثُرْ. أُمَّةٌ وَجَمَاعَةُ أُمَمٍ تَكُونُ مِنْكَ، وَمُلُوكٌ سَيَخْرُجُونَ مِنْ صُلْبِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","وَٱلْأَرْضُ ٱلَّتِي أَعْطَيْتُ إِبْرَاهِيمَ وَإِسْحَاقَ، لَكَ أُعْطِيهَا، وَلِنَسْلِكَ مِنْ بَعْدِكَ أُعْطِي ٱلْأَرْضَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ثُمَّ صَعِدَ ٱللهُ عَنْهُ فِي ٱلْمَكَانِ ٱلَّذِي فِيهِ تَكَلَّمَ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","فَنَصَبَ يَعْقُوبُ عَمُودًا فِي ٱلْمَكَانِ ٱلَّذِي فِيهِ تَكَلَّمَ مَعَهُ، عَمُودًا مِنْ حَجَرٍ، وَسَكَبَ عَلَيْهِ سَكِيبًا، وَصَبَّ عَلَيْهِ زَيْتًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","وَدَعَا يَعْقُوبُ ٱسْمَ ٱلْمَكَانِ ٱلَّذِي فِيهِ تَكَلَّمَ ٱللهُ مَعَهُ «بَيْتَ إِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ثُمَّ رَحَلُوا مِنْ بَيْتِ إِيلَ. وَلَمَّا كَانَ مَسَافَةٌ مِنَ ٱلْأَرْضِ بَعْدُ حَتَّى يَأْتُوا إِلَى أَفْرَاتَةَ، وَلَدَتْ رَاحِيلُ وَتَعَسَّرَتْ وِلَادَتُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","وَحَدَثَ حِينَ تَعسَّرَتْ وِلَادَتُهِا أَنَّ ٱلْقَابِلَةَ قَالَتِ لَهَا: «لَا تَخَافِي، لِأَنَّ هَذَا أَيْضًا ٱبْنٌ لَكِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","وَكَانَ عِنْدَ خُرُوجِ نَفْسِهَا، لِأَنَّهَا مَاتَتْ، أَنَّهَا دَعَتِ ٱسْمَهُ «بَنْ أُونِي». وَأَمَّا أَبُوهُ فَدَعَاهُ «بَنْيَامِينَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","فَمَاتَتْ رَاحِيلُ وَدُفِنَتْ فِي طَرِيقِ أَفْرَاتَةَ، ٱلَّتِي هِيَ بَيْتُ لَحْمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","فَنَصَبَ يَعْقُوبُ عَمُودًا عَلَى قَبْرِهَا، وَهُوَ «عَمُودُ قَبْرِ رَاحِيلَ» إِلَى ٱلْيَوْمِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ثُمَّ رَحَلَ إِسْرَائِيلُ وَنَصَبَ خَيْمَتَهُ وَرَاءَ مَجْدَلَ عِدْرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","وَحَدَثَ إِذْ كَانَ إِسْرَائِيلُ سَاكِنًا فِي تِلْكَ ٱلْأَرْضِ، أَنَّ رَأُوبَيْنَ ذَهَبَ وَٱضْطَجَعَ مَعَ بِلْهَةَ سُرِّيَّةِ أَبِيهِ، وَسَمِعَ إِسْرَائِيلُ. وَكَانَ بَنُو يَعْقُوبَ ٱثْنَيْ عَشَرَ: ");
INSERT INTO arb_vd_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","بَنُو لَيْئَةَ: رَأُوبَيْنُ بِكْرُ يَعْقُوبَ، وَشِمْعُونُ وَلَاوِي وَيَهُوذَا وَيَسَّاكَرُ وَزَبُولُونُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","وَٱبْنَا رَاحِيلَ: يُوسُفُ وَبَنْيَامِينُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","وَٱبْنَا بِلْهَةَ جَارِيَةِ رَاحِيلَ: دَانُ وَنَفْتَالِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","وَٱبْنَا زِلْفَةَ جَارِيَةِ لَيْئَةَ: جَادُ وَأَشِيرُ. هَؤُلَاءِ بَنُو يَعْقُوبَ ٱلَّذِينَ وُلِدُوا لَهُ فِي فَدَّانِ أَرَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","وَجَاءَ يَعْقُوبُ إِلَى إِسْحَاقَ أَبِيهِ إِلَى مَمْرَا، قِرْيَةِ أَرْبَعَ، ٱلَّتِي هِيَ حَبْرُونُ، حَيْثُ تَغَرَّبَ إِبْرَاهِيمُ وَإِسْحَاقُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","وَكَانَتْ أَيَّامُ إِسْحَاقَ مِئَةً وَثَمَانِينَ سَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","فَأَسْلَمَ إِسْحَاقُ رُوحَهُ وَمَاتَ وَٱنْضَمَّ إِلَى قَوْمِهِ، شَيْخًا وَشَبْعَانَ أَيَّامًا. وَدَفَنَهُ عِيسُو وَيَعْقُوبُ ٱبْنَاهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","وَهَذِهِ مَوَالِيدُ عِيسُوَ، ٱلَّذِي هُوَ أَدُومُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","أَخَذَ عِيسُو نِسَاءَهُ مِنْ بَنَاتِ كَنْعَانَ: عَدَا بِنْتَ إِيلُونَ ٱلْحِثِّيِّ، وَأُهُولِيبَامَةَ بِنْتَ عَنَى بِنْتِ صِبْعُونَ ٱلْحِوِّيِّ، ");
INSERT INTO arb_vd_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","وَبَسْمَةَ بِنْتَ إِسْمَاعِيلَ أُخْتَ نَبَايُوتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","فَوَلَدَتْ عَدَا لِعِيسُو أَلِيفَازَ، وَوَلَدَتْ بَسْمَةُ رَعُوئِيلَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","وَوَلَدَتْ أُهُولِيبَامَةُ: يَعُوشَ وَيَعْلَامَ وَقُورَحَ. هَؤُلَاءِ بَنُو عِيسُو ٱلَّذِينَ وُلِدُوا لَهُ فِي أَرْضِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ثُمَّ أَخَذَ عِيسُو نِسَاءَهُ وَبَنِيهِ وَبَنَاتِهِ وَجَمِيعَ نُفُوسِ بَيْتِهِ وَمَوَاشِيَهُ وَكُلَّ بَهَائِمِهِ وَكُلَّ مُقْتَنَاهُ ٱلَّذِي ٱقْتَنَى فِي أَرْضِ كَنْعَانَ، وَمَضَى إِلَى أَرْضٍ أُخْرَى مِنْ وَجْهِ يَعْقُوبَ أَخِيهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","لِأَنَّ أَمْلَاكَهُمَا كَانَتْ كَثِيرَةً عَلَى ٱلسُّكْنَى مَعًا، وَلَمْ تَسْتَطِعْ أَرْضُ غُرْبَتِهِمَا أَنْ تَحْمِلَهُمَا مِنْ أَجْلِ مَوَاشِيهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","فَسَكَنَ عِيسُو فِي جَبَلِ سَعِيرَ. وَعِيسُو هُوَ أَدُومُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","وَهَذِهِ مَوَالِيدُ عِيسُو أَبِي أَدُومَ فِي جَبَلِ سَعِيرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","هَذِهِ أَسْمَاءُ بَنِي عِيسُو: أَلِيفَازُ ٱبْنُ عَدَا ٱمْرَأَةِ عِيسُو، وَرَعُوئِيلُ ٱبْنُ بَسْمَةَ ٱمْرَأَةِ عِيسُو. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","وَكَانَ بَنُو أَلِيفَازَ: تَيْمَانَ وَأَوْمَارَ وَصَفْوًا وَجَعْثَامَ وَقَنَازَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","وَكَانَتْ تِمْنَاعُ سُرِّيَّةً لِأَلِيفَازَ بْنِ عِيسُو، فَوَلَدَتْ لِأَلِيفَازَ عَمَالِيقَ. هَؤُلَاءِ بَنُو عَدَا ٱمْرَأَةِ عِيسُو. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","وَهَؤُلَاءِ بَنُو رَعُوئِيلَ: نَحَثُ وَزَارَحُ وَشَمَّةُ وَمِزَّةُ. هَؤُلَاءِ كَانُوا بَنِي بَسْمَةَ ٱمْرَأَةِ عِيسُو. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","وَهَؤُلَاءِ كَانُوا بَنِي أُهُولِيبَامَةَ بِنْتِ عَنَى بِنْتِ صِبْعُونَ ٱمْرَأَةِ عِيسُو، وَلَدَتْ لِعِيسُو: يَعُوشَ وَيَعْلَامَ وَقُورَحَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","هَؤُلَاءِ أُمَرَاءُ بَنِي عِيسُو: بَنُو أَلِيفَازَ بِكْرِ عِيسُو: أَمِيرُ تَيْمَانَ وَأَمِيرُ أُومَارَ وَأَمِيرُ صَفْوٍ وَأَمِيرُ قَنَازَ ");
INSERT INTO arb_vd_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","وَأَمِيرُ قُورَحَ وَأَمِيرُ جَعْثَامَ وَأَمِيرُ عَمَالِيقَ. هَؤُلَاءِ أُمَرَاءُ أَلِيفَازَ فِي أَرْضِ أَدُومَ. هَؤُلَاءِ بَنُو عَدَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","وَهَؤُلَاءِ بَنُو رَعُوئِيلَ بْنِ عِيسُو: أَمِيرُ نَحَثَ وَأَمِيرُ زَارَحَ وَأَمِيرُ شَمَّةَ وَأَمِيرُ مِزَّةَ. هَؤُلَاءِ أُمَرَاءُ رَعُوئِيلَ فِي أَرْضِ أَدُومَ. هَؤُلَاءِ بَنُو بَسْمَةَ ٱمْرَأَةِ عِيسُو. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","وَهَؤُلَاءِ بَنُو أُهُولِيبَامَةَ ٱمْرَأَةِ عِيسُو: أَمِيرُ يَعُوشَ وَأَمِيرُ يَعْلَامَ وَأَمِيرُ قُورَحَ. هَؤُلَاءِ أُمَرَاءُ أُهُولِيبَامَةَ بِنْتِ عَنَى ٱمْرَأَةِ عِيسُو. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","هَؤُلَاءِ بَنُو عِيسُو ٱلَّذِي هُوَ أَدُومُ، وَهَؤُلَاءِ أُمَرَاؤُهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","هَؤُلَاءِ بَنُو سَعِيرَ ٱلْحُورِيِّ سُكَّانُ ٱلْأَرْضِ: لُوطَانُ وَشُوبَالُ وَصِبْعُونُ وَعَنَى ");
INSERT INTO arb_vd_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","وَدِيشُونُ وَإِيصَرُ وَدِيشَانُ. هَؤُلَاءِ أُمَرَاءُ ٱلْحُورِيِّينَ بَنُو سَعِيرَ فِي أَرْضِ أَدُومَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","وَكَانَ ٱبْنَا لُوطَانَ: حُورِيَ وَهَيْمَامَ. وَكَانَتْ تِمْنَاعُ أُخْتَ لُوطَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","وَهَؤُلَاءِ بَنُو شُوبَالَ: عَلْوَانُ وَمَنَاحَةُ وَعَيْبَالُ وَشَفْوٌ وَأُونَامُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","وَهَذَانِ ٱبْنَا صِبْعُونَ: أَيَّةُ وَعَنَى. هَذَا هُوَ عَنَى ٱلَّذِي وَجَدَ ٱلْحَمَائِمَ فِي ٱلْبَرِّيَّةِ إِذْ كَانَ يَرْعَى حَمِيرَ صِبْعُونَ أَبِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","وَهَذَا ٱبْنُ عَنَى: دِيشُونُ. وَأُهُولِيبَامَةُ هِيَ بِنْتُ عَنَى. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","وَهَؤُلَاءِ بَنُو دِيشَانَ: حَمْدَانُ وَأَشْبَانُ وَيِثْرَانُ وَكَرَانُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","هَؤُلَاءِ بَنُو إِيصَرَ: بِلْهَانُ وَزَعْوَانُ وَعَقَانُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","هَذَانِ ٱبْنَا دِيشَانَ: عُوصٌ وَأَرَانُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","هَؤُلَاءِ أُمَرَاءُ ٱلْحُورِيِّينَ: أَمِيرُ لُوطَانَ وَأَمِيرُ شُوبَالَ وَأَمِيرُ صِبْعُونَ وَأَمِيرُ عَنَى ");
INSERT INTO arb_vd_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","وَأَمِيرُ دِيشُونَ وَأَمِيرُ إِيصَرَ وَأَمِيرُ دِيشَانَ. هَؤُلَاءِ أُمَرَاءُ ٱلْحُورِيِّينَ بِأُمَرَائِهِمْ فِي أَرْضِ سَعِيرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","وَهَؤُلَاءِ هُمُ ٱلْمُلُوكُ ٱلَّذِينَ مَلَكُوا فِي أَرْضِ أَدُومَ، قَبْلَمَا مَلَكَ مَلِكٌ لِبَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","مَلَكَ فِي أَدُومَ بَالَعُ بْنُ بَعُورَ، وَكَانَ ٱسْمُ مَدِينَتِهِ دِنْهَابَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","وَمَاتَ بَالَعُ، فَمَلَكَ مَكَانَهُ يُوبَابُ بْنُ زَارَحَ مِنْ بُصْرَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","وَمَاتَ يُوبَابُ، فَمَلَكَ مَكَانَهُ حُوشَامُ مِنْ أَرْضِ ٱلتَّيْمَانِيِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","وَمَاتَ حُوشَامُ، فَمَلَكَ مَكَانَهُ هَدَادُ بْنُ بَدَادَ ٱلَّذِي كَسَّرَ مِدْيَانَ فِي بِلَادِ مُوآبَ، وَكَانَ ٱسْمُ مَدِينَتِهِ عَوِيتَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","وَمَاتَ هَدَادُ، فَمَلَكَ مَكَانَهُ سَمْلَةُ مِنْ مَسْرِيقَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","وَمَاتَ سَمْلَةُ، فَمَلَكَ مَكَانَهُ شَأُولُ مِنْ رَحُوبُوتِ ٱلنَّهْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","وَمَاتَ شَأُولُ، فَمَلَكَ مَكَانَهُ بَعْلُ حَانَانَ بْنُ عَكْبُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","وَمَاتَ بَعْلُ حَانَانَ بْنُ عَكْبُورَ، فَمَلَكَ مَكَانَهُ هَدَارُ وَكَانَ ٱسْمُ مَدِينَتِهِ فَاعُوَ، وَٱسْمُ ٱمْرَأَتِهِ مَهِيطَبْئِيلُ بِنْتُ مَطْرِدَ بِنْتِ مَاءِ ذَهَبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","وَهَذِهِ أَسْمَاءُ أُمَرَاءِ عِيسُو، حَسَبَ قَبَائِلِهِمْ وَأَمَاكِنِهِمْ بِأَسْمَائِهِمْ: أَمِيرُ تِمْنَاعَ وَأَمِيرُ عَلْوَةَ وَأَمِيرُ يَتِيتَ ");
INSERT INTO arb_vd_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","وَأَمِيرُ أُهُولِيبَامَةَ وَأَمِيرُ إِيلَةَ وَأَمِيرُ فِينُونَ ");
INSERT INTO arb_vd_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","وَأَمِيرُ قَنَازَ وَأَمِيرُ تَيْمَانَ وَأَمِيرُ مِبْصَارَ ");
INSERT INTO arb_vd_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","وَأَمِيرُ مَجْدِيئِيلَ وَأَمِيرُ عِيرَامَ. هَؤُلَاءِ أُمَرَاءُ أَدُومَ حَسَبَ مَسَاكِنِهِمْ فِي أَرْضِ مُلْكِهِمْ. هَذَا هُوَ عِيسُو أَبُو أَدُومَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","وَسَكَنَ يَعْقُوبُ فِي أَرْضِ غُرْبَةِ أَبِيهِ، فِي أَرْضِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","هَذِهِ مَوَالِيدُ يَعْقُوبَ: يُوسُفُ إِذْ كَانَ ٱبْنَ سَبْعَ عَشَرَةَ سَنَةً، كَانَ يَرْعَى مَعَ إِخْوَتِهِ ٱلْغَنَمَ وَهُوَ غُلَامٌ عِنْدَ بَنِي بِلْهَةَ وَبَنِي زِلْفَةَ ٱمْرَأَتَيْ أَبِيهِ، وَأَتَى يُوسُفُ بِنَمِيمَتِهِمِ ٱلرَّدِيئَةِ إِلَى أَبِيهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","وَأَمَّا إِسْرَائِيلُ فَأَحَبَّ يُوسُفَ أَكْثَرَ مِنْ سَائِرِ بَنِيهِ لِأَنَّهُ ٱبْنُ شَيْخُوخَتِهِ، فَصَنَعَ لَهُ قَمِيصًا مُلَوَّنًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","فَلَمَّا رَأَى إِخْوَتُهُ أَنَّ أَبَاهُمْ أَحَبَّهُ أَكْثَرَ مِنْ جَمِيعِ إِخْوَتِهِ أَبْغَضُوهُ، وَلَمْ يَسْتَطِيعُوا أَنْ يُكَلِّمُوهُ بِسَلَامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","وَحَلُمَ يُوسُفُ حُلْمًا وَأَخْبَرَ إِخْوَتَهُ، فَٱزْدَادُوا أَيْضًا بُغْضًا لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","فَقَالَ لَهُمُ: «ٱسْمَعُوا هَذَا ٱلْحُلْمَ ٱلَّذِي حَلُمْتُ: ");
INSERT INTO arb_vd_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","فَهَا نَحْنُ حَازِمُونَ حُزَمًا فِي ٱلْحَقْلِ، وَإِذَا حُزْمَتِي قَامَتْ وَٱنْتَصَبَتْ، فَٱحْتَاطَتْ حُزَمُكُمْ وَسَجَدَتْ لِحُزْمَتِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","فَقَالَ لَهُ إِخْوَتُهُ: «أَلَعَلَّكَ تَمْلِكُ عَلَيْنَا مُلْكًا أَمْ تَتَسَلَّطُ عَلَيْنَا تَسَلُّطًا؟» وَٱزْدَادُوا أَيْضًا بُغْضًا لَهُ مِنْ أَجْلِ أَحْلَامِهِ وَمِنْ أَجْلِ كَلَامِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ثُمَّ حَلُمَ أَيْضًا حُلْمًا آخَرَ وَقَصَّهُ عَلَى إِخْوَتِهِ، فَقَالَ: «إِنِّي قَدْ حَلُمْتُ حُلْمًا أَيْضًا، وَإِذَا ٱلشَّمْسُ وَٱلْقَمَرُ وَأَحَدَ عَشَرَ كَوْكَبًا سَاجِدَةٌ لِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","وَقَصَّهُ عَلَى أَبِيهِ وَعَلَى إِخْوَتِهِ، فَٱنْتَهَرَهُ أَبُوهُ وَقَالَ لَهُ: «مَا هَذَا ٱلْحُلْمُ ٱلَّذِي حَلُمْتَ؟ هَلْ نَأْتِي أَنَا وَأُمُّكَ وَإِخْوَتُكَ لِنَسْجُدَ لَكَ إِلَى ٱلْأَرْضِ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","فَحَسَدَهُ إِخْوَتُهُ، وَأَمَّا أَبُوهُ فَحَفِظَ ٱلْأَمْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","وَمَضَى إِخْوَتُهُ لِيَرْعَوْا غَنَمَ أَبِيهِمْ عِنْدَ شَكِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","فَقَالَ إِسْرَائِيلُ لِيُوسُفَ: «أَلَيْسَ إِخْوَتُكَ يَرْعَوْنَ عِنْدَ شَكِيمَ؟ تَعَالَ فَأُرْسِلَكَ إِلَيْهِمْ». فَقَالَ لَهُ: «هَأَنَذَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","فَقَالَ لَهُ: «ٱذْهَبِ ٱنْظُرْ سَلَامَةَ إِخْوَتِكَ وَسَلَامَةَ ٱلْغَنَمِ وَرُدَّ لِي خَبَرًا». فَأَرْسَلَهُ مِنْ وَطَاءِ حَبْرُونَ فَأَتَى إِلَى شَكِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","فَوَجَدَهُ رَجُلٌ وَإِذَا هُوَ ضَالٌّ فِي ٱلْحَقْلِ. فَسَأَلَهُ ٱلرَّجُلُ قَائِلًا: «مَاذَا تَطْلُبُ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","فَقَالَ: «أَنَا طَالِبٌ إِخْوَتِي. أَخْبِرْنِي «أَيْنَ يَرْعَوْنَ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","فَقَالَ ٱلرَّجُلُ: «قَدِ ٱرْتَحَلُوا مِنْ هُنَا، لِأَنِّي سَمِعْتُهُمْ يَقُولُونَ: لِنَذْهَبْ إِلَى دُوثَانَ». فَذَهَبَ يُوسُفُ وَرَاءَ إِخْوَتِهِ فَوَجَدَهُمْ فِي دُوثَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","فَلَمَّا أَبْصَرُوهُ مِنْ بَعِيدٍ، قَبْلَمَا ٱقْتَرَبَ إِلَيْهِمِ، ٱحْتَالُوا لَهُ لِيُمِيتُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","فَقَالَ بَعْضُهُمْ لِبَعْضٍ: «هُوَذَا هَذَا صَاحِبُ ٱلْأَحْلَامِ قَادِمٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","فَٱلْآنَ هَلُمَّ نَقْتُلْهُ وَنَطْرَحْهُ فِي إِحْدَى ٱلْآبَارِ وَنَقُولُ: وَحْشٌ رَدِيءٌ أَكَلَهُ. فَنَرَى مَاذَا تَكُونُ أَحْلَامُهُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","فَسَمِعَ رَأُوبَيْنُ وَأَنْقَذَهُ مِنْ أَيْدِيهِمْ، وَقَالَ: «لَا نَقْتُلُهُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","وَقَالَ لَهُمْ رَأُوبَيْنُ: «لَا تَسْفِكُوا دَمًا. اِطْرَحُوهُ فِي هَذِهِ ٱلْبِئْرِ ٱلَّتِي فِي ٱلْبَرِّيَّةِ وَلَا تَمُدُّوا إِلَيْهِ يَدًا». لِكَيْ يُنْقِذَهُ مِنْ أَيْدِيهِمْ لِيَرُدَّهُ إِلَى أَبِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","فَكَانَ لَمَّا جَاءَ يُوسُفُ إِلَى إِخْوَتِهِ أَنَّهُمْ خَلَعُوا عَنْ يُوسُفَ قَمِيصَهُ، ٱلْقَمِيصَ ٱلْمُلَوَّنَ ٱلَّذِي عَلَيْهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","وَأَخَذُوهُ وَطَرَحُوهُ فِي ٱلْبِئْرِ. وَأَمَّا ٱلْبِئْرُ فَكَانَتْ فَارِغَةً لَيْسَ فِيهَا مَاءٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ثُمَّ جَلَسُوا لِيَأْكُلُوا طَعَامًا. فَرَفَعُوا عُيُونَهُمْ وَنَظَرُوا وَإِذَا قَافِلَةُ إِسْمَاعِيلِيِّينَ مُقْبِلَةٌ مِنْ جِلْعَادَ، وَجِمَالُهُمْ حَامِلَةٌ كَثِيرَاءَ وَبَلَسَانًا وَلَاذَنًا، ذَاهِبِينَ لِيَنْزِلُوا بِهَا إِلَى مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","فَقَالَ يَهُوذَا لِإِخْوَتِهِ: «مَا ٱلْفَائِدَةُ أَنْ نَقْتُلَ أَخَانَا وَنُخْفِيَ دَمَهُ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","تَعَالَوْا فَنَبِيعَهُ لِلْإِسْمَاعِيلِيِّينَ، وَلَا تَكُنْ أَيْدِينَا عَلَيْهِ لِأَنَّهُ أَخُونَا وَلَحْمُنَا». فَسَمِعَ لَهُ إِخْوَتُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","وَٱجْتَازَ رِجَالٌ مِدْيَانِيُّونَ تُجَّارٌ، فَسَحَبُوا يُوسُفَ وَأَصْعَدُوهُ مِنَ ٱلْبِئْرِ، وَبَاعُوا يُوسُفَ لِلْإِسْمَاعِيلِيِّينَ بِعِشْرِينَ مِنَ ٱلْفِضَّةِ. فَأَتَوْا بِيُوسُفَ إِلَى مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","وَرَجَعَ رَأُوبَيْنُ إِلَى ٱلْبِئْرِ، وَإِذَا يُوسُفُ لَيْسَ فِي ٱلْبِئْرِ، فَمَزَّقَ ثِيَابَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ثُمَّ رَجَعَ إِلَى إِخْوَتِهِ وَقَالَ: «ٱلْوَلَدُ لَيْسَ مَوْجُودًا، وَأَنَا إِلَى أَيْنَ أَذْهَبُ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","فَأَخَذُوا قَمِيصَ يُوسُفَ وَذَبَحُوا تَيْسًا مِنَ ٱلْمِعْزَى وَغَمَسُوا ٱلْقَمِيصَ فِي ٱلدَّمِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","وَأَرْسَلُوا ٱلْقَمِيصَ ٱلْمُلَوَّنَ وَأَحْضَرُوهُ إِلَى أَبِيهِمْ وَقَالُوا: «وَجَدْنَا هَذَا. حَقِّقْ أَقَمِيصُ ٱبْنِكَ هُوَ أَمْ لَا؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","فَتَحَقَّقَهُ وَقَالَ: «قَمِيصُ ٱبْنِي! وَحْشٌ رَدِيءٌ أَكَلَهُ، ٱفْتُرِسَ يُوسُفُ ٱفْتِرَاسًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","فَمَزَّقَ يَعْقُوبُ ثِيَابَهُ، وَوَضَعَ مِسْحًا عَلَى حَقَوَيْهِ، وَنَاحَ عَلَى ٱبْنِهِ أَيَّامًا كَثِيرَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","فَقَامَ جَمِيعُ بَنِيهِ وَجَمِيعُ بَنَاتِهِ لِيُعَزُّوهُ، فَأَبَى أَنْ يَتَعَزَّى وَقَالَ: «إِنِّي أَنْزِلُ إِلَى ٱبْنِي نَائِحًا إِلَى ٱلْهَاوِيَةِ». وَبَكَى عَلَيْهِ أَبُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","وَأَمَّا ٱلْمِدْيَانِيُّونَ فَبَاعُوهُ فِي مِصْرَ لِفُوطِيفَارَ خَصِيِّ فِرْعَوْنَ، رَئِيسِ ٱلشُّرَطِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","وَحَدَثَ فِي ذَلِكَ ٱلزَّمَانِ أَنَّ يَهُوذَا نَزَلَ مِنْ عِنْدِ إِخْوَتِهِ، وَمَالَ إِلَى رَجُلٍ عَدُّلَامِيٍّ ٱسْمُهُ حِيرَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","وَنَظَرَ يَهُوذَا هُنَاكَ ٱبْنَةَ رَجُلٍ كَنْعَانِيٍّ ٱسْمُهُ شُوعٌ، فَأَخَذَهَا وَدَخَلَ عَلَيْهَا، ");
INSERT INTO arb_vd_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","فَحَبِلَتْ وَوَلَدَتِ ٱبْنًا وَدَعَا ٱسْمَهُ «عِيرًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ثُمَّ حَبِلَتْ أَيْضًا وَوَلَدَتِ ٱبْنًا وَدَعَتِ ٱسْمَهُ «أُونَانَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ثُمَّ عَادَتْ فَوَلَدَتْ أَيْضًا ٱبْنًا وَدَعَتِ ٱسْمَهُ «شِيلَةَ». وَكَانَ فِي كَزِيبَ حِينَ وَلَدَتْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","وَأَخَذَ يَهُوذَا زَوْجَةً لِعِيرٍ بِكْرِهِ ٱسْمُهَا ثَامَارُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","وَكَانَ عِيرٌ بِكْرُ يَهُوذَا شِرِّيرًا فِي عَيْنَيِ ٱلرَّبِّ، فَأَمَاتَهُ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","فَقَالَ يَهُوذَا لِأُونَانَ: «ٱدْخُلْ عَلَى ٱمْرَأَةِ أَخِيكَ وَتَزَوَّجْ بِهَا، وَأَقِمْ نَسْلًا لِأَخِيكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","فَعَلِمَ أُونَانُ أَنَّ ٱلنَّسْلَ لَا يَكُونُ لَهُ، فَكَانَ إِذْ دَخَلَ عَلَى ٱمْرَأَةِ أَخِيهِ أَنَّهُ أَفْسَدَ عَلَى ٱلْأَرْضِ، لِكَيْ لَا يُعْطِيَ نَسْلًا لِأَخِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","فَقَبُحَ فِي عَيْنَيِ ٱلرَّبِّ مَا فَعَلَهُ، فَأَمَاتَهُ أَيْضًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","فَقَالَ يَهُوذَا لِثَامَارَ كَنَّتِهِ: «ٱقْعُدِي أَرْمَلَةً فِي بَيْتِ أَبِيكِ حَتَّى يَكْبُرَ شِيلَةُ ٱبْنِي». لِأَنَّهُ قَالَ: «لَعَلَّهُ يَمُوتُ هُوَ أَيْضًا كَأَخَوَيْهِ». فَمَضَتْ ثَامَارُ وَقَعَدَتْ فِي بَيْتِ أَبِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","وَلَمَّا طَالَ ٱلزَّمَانُ مَاتَتِ ٱبْنَةُ شُوعٍ ٱمْرَأَةُ يَهُوذَا. ثُمَّ تَعَزَّى يَهُوذَا فَصَعِدَ إِلَى جُزَّازِ غَنَمِهِ إِلَى تِمْنَةَ، هُوَ وَحِيرَةُ صَاحِبُهُ ٱلْعَدُّلَامِيُّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","فَأُخْبِرَتْ ثَامَارُ وَقِيلَ لَهَا: «هُوَذَا حَمُوكِ صَاعِدٌ إِلَى تِمْنَةَ لِيَجُزَّ غَنَمَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","فَخَلَعَتْ عَنْهَا ثِيَابَ تَرَمُّلِهَا، وَتَغَطَّتْ بِبُرْقُعٍ وَتَلَفَّفَتْ، وَجَلَسَتْ فِي مَدْخَلِ عَيْنَايِمَ ٱلَّتِي عَلَى طَرِيقِ تِمْنَةَ، لِأَنَّهَا رَأَتْ أَنَّ شِيلَةَ قَدْ كَبُرَ وَهِيَ لَمْ تُعْطَ لَهُ زَوْجَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","فَنَظَرَهَا يَهُوذَا وَحَسِبَهَا زَانِيَةً، لِأَنَّهَا كَانَتْ قَدْ غَطَّتْ وَجْهَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","فَمَالَ إِلَيْهَا عَلَى ٱلطَّرِيقِ وَقَالَ: «هَاتِي أَدْخُلْ عَلَيْكِ». لِأَنَّهُ لَمْ يَعْلَمْ أَنَّهَا كَنَّتُهُ. فَقَالَتْ: «مَاذَا تُعْطِينِي لِكَيْ تَدْخُلَ عَلَيَّ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","فَقَالَ: «إِنِّي أُرْسِلُ جَدْيَ مِعْزَى مِنَ ٱلْغَنَمِ». فَقَالَتْ: «هَلْ تُعْطِينِي رَهْنًا حَتَّى تُرْسِلَهُ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","فَقَالَ: «مَا ٱلرَّهْنُ ٱلَّذِي أُعْطِيكِ؟» فَقَالَتْ: «خَاتِمُكَ وَعِصَابَتُكَ وَعَصَاكَ ٱلَّتِي فِي يَدِكَ». فَأَعْطَاهَا وَدَخَلَ عَلَيْهَا، فَحَبِلَتْ مِنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ثُمَّ قَامَتْ وَمَضَتْ وَخَلَعَتْ عَنْهَا بُرْقُعَهَا وَلَبِسَتْ ثِيَابَ تَرَمُّلِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","فَأَرْسَلَ يَهُوذَا جَدْيَ ٱلْمِعْزَى بِيَدِ صَاحِبِهِ ٱلْعَدُّلَامِيِّ لِيَأْخُذَ ٱلرَّهْنَ مِنْ يَدِ ٱلْمَرْأَةِ، فَلَمْ يَجِدْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","فَسَأَلَ أَهْلَ مَكَانِهَا قَائِلًا: «أَيْنَ ٱلزَّانِيَةُ ٱلَّتِي كَانَتْ فِي عَيْنَايِمَ عَلَى ٱلطَّرِيقِ؟» فَقَالُوا: «لَمْ تَكُنْ هَهُنَا زَانِيَةٌ». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","فَرَجَعَ إِلَى يَهُوذَا وَقَالَ: «لَمْ أَجِدْهَا. وَأَهْلُ ٱلْمَكَانِ أَيْضًا قَالُوا: لَمْ تَكُنْ هَهُنَا زَانِيَةٌ». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","فَقَالَ يَهُوذَا: «لِتَأْخُذْ لِنَفْسِهَا، لِئَلَّا نَصِيرَ إِهَانَةً. إِنِّي قَدْ أَرْسَلْتُ هَذَا ٱلْجَدْيَ وَأَنْتَ لَمْ تَجِدْهَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","وَلَمَّا كَانَ نَحْوُ ثَلَاثَةِ أَشْهُرٍ، أُخْبِرَ يَهُوذَا وَقِيلَ لَهُ: «قَدْ زَنَتْ ثَامَارُ كَنَّتُكَ، وَهَا هِيَ حُبْلَى أَيْضًا مِنَ ٱلزِّنَا». فَقَالَ يَهُوذَا: «أَخْرِجُوهَا فَتُحْرَقَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","أَمَّا هِيَ فَلَمَّا أُخْرِجَتْ أَرْسَلَتْ إِلَى حَمِيهَا قَائِلَةً: «مِنَ ٱلرَّجُلِ ٱلَّذِي هَذِهِ لَهُ أَنَا حُبْلَى!» وَقَالَتْ: «حَقِّقْ لِمَنِ ٱلْخَاتِمُ وَٱلْعِصَابَةُ وَٱلْعَصَا هَذِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","فَتَحَقَّقَهَا يَهُوذَا وَقَالَ: «هِيَ أَبَرُّ مِنِّي، لِأَنِّي لَمْ أُعْطِهَا لِشِيلَةَ ٱبْنِي». فَلَمْ يَعُدْ يَعْرِفُهَا أَيْضًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","وَفِي وَقْتِ وِلَادَتِهَا إِذَا فِي بَطْنِهَا تَوْأَمَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","وَكَانَ فِي وِلَادَتِهَا أَنَّ أَحَدَهُمَا أَخْرَجَ يَدًا فَأَخَذَتِ ٱلْقَابِلَةُ وَرَبَطَتْ عَلَى يَدِهِ قِرْمِزًا، قَائِلَةً: «هَذَا خَرَجَ أَوَّلًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","وَلَكِنْ حِينَ رَدَّ يَدَهُ، إِذَا أَخُوهُ قَدْ خَرَجَ. فَقَالَتْ: «لِمَاذَا ٱقْتَحَمْتَ؟ عَلَيْكَ ٱقْتِحَامٌ!». فَدُعِيَ ٱسْمُهُ «فَارِصَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","وَبَعْدَ ذَلِكَ خَرَجَ أَخُوهُ ٱلَّذِي عَلَى يَدِهِ ٱلْقِرْمِزُ. فَدُعِيَ ٱسْمُهُ «زَارَحَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","وَأَمَّا يُوسُفُ فَأُنْزِلَ إِلَى مِصْرَ، وَٱشْتَرَاهُ فُوطِيفَارُ خَصِيُّ فِرْعَوْنَ رَئِيسُ ٱلشُّرَطِ، رَجُلٌ مِصْرِيٌّ، مِنْ يَدِ ٱلْإِسْمَاعِيلِيِّينَ ٱلَّذِينَ أَنْزَلُوهُ إِلَى هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","وَكَانَ ٱلرَّبُّ مَعَ يُوسُفَ فَكَانَ رَجُلًا نَاجِحًا، وَكَانَ فِي بَيْتِ سَيِّدِهِ ٱلْمِصْرِيِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","وَرَأَى سَيِّدُهُ أَنَّ ٱلرَّبَّ مَعَهُ، وَأَنَّ كُلَّ مَا يَصْنَعُ كَانَ ٱلرَّبُّ يُنْجِحُهُ بِيَدِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","فَوَجَدَ يُوسُفُ نِعْمَةً فِي عَيْنَيْهِ، وَخَدَمَهُ، فَوَكَّلَهُ عَلَى بَيْتِهِ وَدَفَعَ إِلَى يَدِهِ كُلَّ مَا كَانَ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","وَكَانَ مِنْ حِينِ وَكَّلَهُ عَلَى بَيْتِهِ، وَعَلَى كُلِّ مَا كَانَ لَهُ، أَنَّ ٱلرَّبَّ بَارَكَ بَيْتَ ٱلْمِصْرِيِّ بِسَبَبِ يُوسُفَ. وَكَانَتْ بَرَكَةُ ٱلرَّبِّ عَلَى كُلِّ مَا كَانَ لَهُ فِي ٱلْبَيْتِ وَفِي ٱلْحَقْلِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","فَتَرَكَ كُلَّ مَا كَانَ لَهُ فِي يَدِ يُوسُفَ. وَلَمْ يَكُنْ مَعَهُ يَعْرِفُ شَيْئًا إِلَا ٱلْخُبْزَ ٱلَّذِي يَأْكُلُ. وَكَانَ يُوسُفُ حَسَنَ ٱلصُّورَةِ وَحَسَنَ ٱلْمَنْظَرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","وَحَدَثَ بَعْدَ هَذِهِ ٱلْأُمُورِ أَنَّ ٱمْرَأَةَ سَيِّدِهِ رَفَعَتْ عَيْنَيْهَا إِلَى يُوسُفَ وَقَالَتِ: «ٱضْطَجِعْ مَعِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","فَأَبَى وَقَالَ لِٱمْرَأَةِ سَيِّدِهِ: «هُوَذَا سَيِّدِي لَا يَعْرِفُ مَعِي مَا فِي ٱلْبَيْتِ، وَكُلُّ مَا لَهُ قَدْ دَفَعَهُ إِلَى يَدِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","لَيْسَ هُوَ فِي هَذَا ٱلْبَيْتِ أَعْظَمَ مِنِّي. وَلَمْ يُمْسِكْ عَنِّي شَيْئًا غَيْرَكِ، لِأَنَّكِ ٱمْرَأَتُهُ. فَكَيْفَ أَصْنَعُ هَذَا ٱلشَّرَّ ٱلْعَظِيمَ وَأُخْطِئُ إِلَى ٱللهِ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","وَكَانَ إِذْ كَلَّمَتْ يُوسُفَ يَوْمًا فَيَوْمًا أَنَّهُ لَمْ يَسْمَعْ لَهَا أَنْ يَضْطَجِعَ بِجَانِبِهَا لِيَكُونَ مَعَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ثُمَّ حَدَثَ نَحْوَ هَذَا ٱلْوَقْتِ أَنَّهُ دَخَلَ ٱلْبَيْتَ لِيَعْمَلَ عَمَلَهُ، وَلَمْ يَكُنْ إِنْسَانٌ مِنْ أَهْلِ ٱلْبَيْتِ هُنَاكَ فِي ٱلْبَيْتِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","فَأَمْسَكَتْهُ بِثَوْبِهِ قَائِلَةً: «ٱضْطَجِعْ مَعِي!». فَتَرَكَ ثَوْبَهُ فِي يَدِهَا وَهَرَبَ وَخَرَجَ إِلَى خَارِجٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","وَكَانَ لَمَّا رَأَتْ أَنَّهُ تَرَكَ ثَوْبَهُ فِي يَدِهَا وَهَرَبَ إِلَى خَارِجٍ، ");
INSERT INTO arb_vd_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","أَنَّهَا نَادَتْ أَهْلَ بَيْتِهَا، وَكَلَّمَتهُمْ قَائِلةً: «ٱنْظُرُوا! قَدْ جَاءَ إِلَيْنَا بِرَجُلٍ عِبْرَانِيٍّ لِيُدَاعِبَنَا! دَخَلَ إِلَيَّ لِيَضْطَجِعَ مَعِي، فَصَرَخْتُ بِصَوْتٍ عَظِيمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","وَكَانَ لَمَّا سَمِعَ أَنِّي رَفَعْتُ صَوْتِي وَصَرَخْتُ، أَنَّهُ تَرَكَ ثَوْبَهُ بِجَانِبِي وَهَرَبَ وَخَرَجَ إِلَى خَارِجٍ». ");
INSERT INTO arb_vd_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","فَوَضَعَتْ ثَوْبَهُ بِجَانِبِهَا حَتَّى جَاءَ سَيِّدُهُ إِلَى بَيْتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","فَكَلَّمَتْهُ بِمِثْلِ هَذَا ٱلْكَلَامِ قَائِلَةً: «دَخَلَ إِلَيَّ ٱلْعَبْدُ ٱلْعِبْرَانِيُّ ٱلَّذِي جِئْتَ بِهِ إِلَيْنَا لِيُدَاعِبَنِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","وَكَانَ لَمَّا رَفَعْتُ صَوْتِي وَصَرَخْتُ، أَنَّهُ تَرَكَ ثَوْبَهُ بِجَانِبِي وَهَرَبَ إِلَى خَارِجٍ». ");
INSERT INTO arb_vd_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","فَكَانَ لَمَّا سَمِعَ سَيِّدُهُ كَلَامَ ٱمْرَأَتِهِ ٱلَّذِي كَلَّمَتْهُ بِهِ قَائِلَةً: «بِحَسَبِ هَذَا ٱلْكَلَامِ صَنَعَ بِي عَبْدُكَ»، أَنَّ غَضَبَهُ حَمِيَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","فَأَخَذَ يُوسُفَ سَيِّدُهُ وَوَضَعَهُ فِي بَيْتِ ٱلسِّجْنِ، ٱلْمَكَانِ ٱلَّذِي كَانَ أَسْرَى ٱلْمَلِكِ مَحْبُوسِينَ فِيهِ. وَكَانَ هُنَاكَ فِي بَيْتِ ٱلسِّجْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","وَلَكِنَّ ٱلرَّبَّ كَانَ مَعَ يُوسُفَ، وَبَسَطَ إِلَيْهِ لُطْفًا، وَجَعَلَ نِعْمَةً لَهُ فِي عَيْنَيْ رَئِيسِ بَيْتِ ٱلسِّجْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","فَدَفَعَ رَئِيسُ بَيْتِ ٱلسِّجْنِ إِلَى يَدِ يُوسُفَ جَمِيعَ ٱلْأَسْرَى ٱلَّذِينَ فِي بَيْتِ ٱلسِّجْنِ. وَكُلُّ مَا كَانُوا يَعْمَلُونَ هُنَاكَ كَانَ هُوَ ٱلْعَامِلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","وَلَمْ يَكُنْ رَئِيسُ بَيْتِ ٱلسِّجْنِ يَنْظُرُ شَيْئًا ٱلْبَتَّةَ مِمَّا فِي يَدِهِ، لِأَنَّ ٱلرَّبَّ كَانَ مَعَهُ، وَمَهْمَا صَنَعَ كَانَ ٱلرَّبُّ يُنْجِحُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","وَحَدَثَ بَعْدَ هَذِهِ ٱلْأُمُورِ أَنَّ سَاقِيَ مَلِكِ مِصْرَ وَٱلْخَبَّازَ أَذْنَبَا إِلَى سَيِّدِهِمَا مَلِكِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","فَسَخَطَ فِرْعَوْنُ عَلَى خَصِيَّيْهِ: رَئِيسِ ٱلسُّقَاةِ وَرَئِيسِ ٱلْخَبَّازِينَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","فَوَضَعَهُمَا فِي حَبْسِ بَيْتِ رَئِيسِ ٱلشُّرَطِ، فِي بَيْتِ ٱلسِّجْنِ، ٱلْمَكَانِ ٱلَّذِي كَانَ يُوسُفُ مَحْبُوسًا فِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","فَأَقَامَ رَئِيسُ ٱلشُّرَطِ يُوسُفَ عِنْدَهُمَا فَخَدَمَهُمَا. وَكَانَا أَيَّامًا فِي ٱلْحَبْسِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","وَحَلُمَا كِلَاهُمَا حُلْمًا فِي لَيْلَةٍ وَاحِدَةٍ، كُلُّ وَاحِدٍ حُلْمَهُ، كُلُّ وَاحِدٍ بِحَسَبِ تَعْبِيرِ حُلْمِهِ، سَاقِي مَلِكِ مِصْرَ وَخَبَّازُهُ، ٱلْمَحْبُوسَانِ فِي بَيْتِ ٱلسِّجْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","فَدَخَلَ يُوسُفُ إِلَيْهِمَا فِي ٱلصَّبَاحِ وَنَظَرَهُمَا، وَإِذَا هُمَا مُغْتَمَّانِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","فَسَأَلَ خَصِيَّيْ فِرْعَوْنَ ٱللَّذَيْنِ مَعَهُ فِي حَبْسِ بَيْتِ سَيِّدِهِ قَائِلًا: «لِمَاذَا وَجْهَاكُمَا مُكْمَدَّانِ ٱلْيَوْمَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","فَقَالَا لَهُ: «حَلُمْنَا حُلْمًا وَلَيْسَ مَنْ يُعَبِّرُهُ». فَقَالَ لَهُمَا يُوسُفُ: «أَلَيْسَتْ لِلهِ ٱلتَّعَابِيرُ؟ قُصَّا عَلَيَّ». ");
INSERT INTO arb_vd_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","فَقَصَّ رَئِيسُ ٱلسُّقَاةِ حُلْمَهُ عَلَى يُوسُفَ وَقَالَ لَهُ: «كُنْتُ فِي حُلْمِي وَإِذَا كَرْمَةٌ أَمَامِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","وَفِي ٱلْكَرْمَةِ ثَلَاثَةُ قُضْبَانٍ، وَهِيَ إِذْ أَفْرَخَتْ طَلَعَ زَهْرُهَا، وَأَنْضَجَتْ عَنَاقِيدُهَا عِنَبًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","وَكَانَتْ كَأْسُ فِرْعَوْنَ فِي يَدِي، فَأَخَذْتُ ٱلْعِنَبَ وَعَصَرْتُهُ فِي كَأْسِ فِرْعَوْنَ، وَأَعْطَيْتُ ٱلْكَأْسَ فِي يَدِ فِرْعَوْنَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","فَقَالَ لَهُ يُوسُفُ: «هَذَا تَعْبِيرُهُ: ٱلثَّلَاثَةُ ٱلْقُضْبَانِ هِيَ ثَلَاثَةُ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","فِي ثَلَاثَةِ أَيَّامٍ أَيْضًا يَرْفَعُ فِرْعَوْنُ رَأْسَكَ وَيَرُدُّكَ إِلَى مَقَامِكَ، فَتُعْطِي كَأْسَ فِرْعَوْنَ فِي يَدِهِ كَٱلْعَادَةِ ٱلْأُولَى حِينَ كُنْتَ سَاقِيَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","وَإِنَّمَا إِذَا ذَكَرْتَنِي عِنْدَكَ حِينَمَا يَصِيرُ لَكَ خَيْرٌ، تَصْنَعُ إِلَيَّ إِحْسَانًا وَتَذْكُرُنِي لِفِرْعَوْنَ، وَتُخْرِجُنِي مِنْ هَذَا ٱلْبَيْتِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","لِأَنِّي قَدْ سُرِقْتُ مِنْ أَرْضِ ٱلْعِبْرَانِيِّينَ، وَهُنَا أَيْضًا لَمْ أَفْعَلْ شَيْئًا حَتَّى وَضَعُونِي فِي ٱلسِّجْنِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","فَلَمَّا رَأَى رَئِيسُ ٱلْخَبَّازِينَ أَنَّهُ عَبَّرَ جَيِّدًا، قَالَ لِيُوسُفَ: «كُنْتُ أَنَا أَيْضًا فِي حُلْمِي وَإِذَا ثَلَاثَةُ سِلَالِ حُوَّارَى عَلَى رَأْسِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","وَفِي ٱلسَّلِّ ٱلْأَعْلَى مِنْ جَمِيعِ طَعَامِ فِرْعَوْنَ مِنْ صَنْعَةِ ٱلْخَبَّازِ. وَٱلطُّيُورُ تَأْكُلُهُ مِنَ ٱلسَّلِّ عَنْ رَأْسِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","فَأَجَابَ يُوسُفُ وَقَالَ: «هَذَا تَعْبِيرُهُ: ٱلثَّلَاثَةُ ٱلسِّلَالِ هِيَ ثَلَاثَةُ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","فِي ثَلَاثَةِ أَيَّامٍ أَيْضًا يَرْفَعُ فِرْعَوْنُ رَأْسَكَ عَنْكَ، وَيُعَلِّقُكَ عَلَى خَشَبَةٍ، وَتَأْكُلُ ٱلطُّيُورُ لَحْمَكَ عَنْكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","فَحَدَثَ فِي ٱلْيَوْمِ ٱلثَّالِثِ، يَوْمِ مِيلَادِ فِرْعَوْنَ، أَنَّهُ صَنَعَ وَلِيمَةً لِجَمِيعِ عَبِيدِهِ، وَرَفَعَ رَأْسَ رَئِيسِ ٱلسُّقَاةِ وَرَأْسَ رَئِيسِ ٱلْخَبَّازِينَ بَيْنَ عَبِيدِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","وَرَدَّ رَئِيسَ ٱلسُّقَاةِ إِلَى سَقْيِهِ، فَأَعْطَى ٱلْكَأْسَ فِي يَدِ فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","وَأَمَّا رَئِيسُ ٱلْخَبَّازِينَ فَعَلَّقَهُ، كَمَا عَبَّرَ لَهُمَا يُوسُفُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","وَلَكِنْ لَمْ يَذْكُرْ رَئِيسُ ٱلسُّقَاةِ يُوسُفَ بَلْ نَسِيَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","وَحَدَثَ مِنْ بَعْدِ سَنَتَيْنِ مِنَ ٱلزَّمَانِ أَنَّ فِرْعَوْنَ رَأَى حُلْمًا: وَإِذَا هُوَ وَاقِفٌ عِنْدَ ٱلنَّهْرِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","وَهُوَذَا سَبْعُ بَقَرَاتٍ طَالِعَةٍ مِنَ ٱلنَّهْرِ حَسَنَةِ ٱلْمَنْظَرِ وَسَمِينَةِ ٱللَّحْمِ، فَٱرْتَعَتْ فِي رَوْضَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ثُمَّ هُوَذَا سَبْعُ بَقَرَاتٍ أُخْرَى طَالِعَةٍ وَرَاءَهَا مِنَ ٱلنَّهْرِ قَبِيحَةِ ٱلْمَنْظَرِ وَرَقِيقَةِ ٱللَّحْمِ، فَوَقَفَتْ بِجَانِبِ ٱلْبَقَرَاتِ ٱلْأُولَى عَلَى شَاطِئِ ٱلنَّهْرِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","فَأَكَلَتِ ٱلْبَقَرَاتُ ٱلْقَبِيحَةُ ٱلْمَنْظَرِ وَٱلرَّقِيقَةُ ٱللَّحْمِ ٱلْبَقَرَاتِ ٱلسَّبْعَ ٱلْحَسَنَةَ ٱلْمَنْظَرِ وَٱلسَّمِينَةَ. وَٱسْتَيْقَظَ فِرْعَوْنُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ثُمَّ نَامَ فَحَلُمَ ثَانِيَةً: وَهُوَذَا سَبْعُ سَنَابِلَ طَالِعَةٍ فِي سَاقٍ وَاحِدٍ سَمِينَةٍ وَحَسَنَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ثُمَّ هُوَذَا سَبْعُ سَنَابِلَ رَقِيقَةٍ وَمَلْفُوحَةٍ بِٱلرِّيحِ ٱلشَّرْقِيَّةِ نَابِتَةٍ وَرَاءَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","فَٱبْتَلَعَتِ ٱلسَّنَابِلُ ٱلرَّقِيقَةُ ٱلسَّنَابِلَ ٱلسَّبْعَ ٱلسَّمِينَةَ ٱلْمُمْتَلِئَةَ. وَٱسْتَيْقَظَ فِرْعَوْنُ، وَإِذَا هُوَ حُلْمٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","وَكَانَ فِي ٱلصَّبَاحِ أَنَّ نَفْسَهُ ٱنْزَعَجَتْ، فَأَرْسَلَ وَدَعَا جَمِيعَ سَحَرَةِ مِصْرَ وَجَمِيعَ حُكَمَائِهَا. وَقَصَّ عَلَيْهِمْ فِرْعَوْنُ حُلْمَهُ، فَلَمْ يَكُنْ مَنْ يُعَبِّرُهُ لِفِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ثُمَّ كَلَّمَ رَئِيسُ ٱلسُّقَاةِ فِرْعَوْنَ قَائِلًا: «أَنَا أَتَذَكَّرُ ٱلْيَوْمَ خَطَايَايَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","فِرْعَوْنُ سَخَطَ عَلَى عَبْدَيْهِ، فَجَعَلَنِي فِي حَبْسِ بَيْتِ رَئِيسِ ٱلشُّرَطِ أَنَا وَرَئِيسَ ٱلْخَبَّازِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","فَحَلُمْنَا حُلْمًا فِي لَيْلَةٍ وَاحِدَةٍ أَنَا وَهُوَ. حَلُمْنَا كُلُّ وَاحِدٍ بِحَسَبِ تَعْبِيرِ حُلْمِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","وَكَانَ هُنَاكَ مَعَنَا غُلَامٌ عِبْرَانِيٌّ عَبْدٌ لِرَئِيسِ ٱلشُّرَطِ، فَقَصَصْنَا عَلَيْهِ، فَعَبَّرَ لَنَا حُلْمَيْنَا. عَبَّرَ لِكُلِّ وَاحِدٍ بِحَسَبِ حُلْمِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","وَكَمَا عَبَّرَ لَنَا هَكَذَا حَدَثَ. رَدَّنِي أَنَا إِلَى مَقَامِي، وَأَمَّا هُوَ فَعَلَّقَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","فَأَرْسَلَ فِرْعَوْنُ وَدَعَا يُوسُفَ، فَأَسْرَعُوا بِهِ مِنَ ٱلسِّجْنِ. فَحَلَقَ وَأَبْدَلَ ثِيَابَهُ وَدَخَلَ عَلَى فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","فَقَالَ فِرْعَوْنُ لِيُوسُفَ: «حَلُمْتُ حُلْمًا وَلَيْسَ مَنْ يُعَبِّرُهُ. وَأَنَا سَمِعْتُ عَنْكَ قَوْلًا، إِنَّكَ تَسْمَعُ أَحْلَامًا لِتُعَبِّرَهَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","فَأَجَابَ يُوسُفُ فِرْعَوْنَ قَائِلًا: «لَيْسَ لِي. ٱللهُ يُجِيبُ بِسَلَامَةٍ فِرْعَوْنَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","فَقَالَ فِرْعَوْنُ لِيُوسُفَ: «إِنِّي كُنْتُ فيِ حُلْمِي وَاقِفًا عَلَى شَاطِئِ ٱلنَّهْرِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","وَهُوَذَا سَبْعُ بَقَرَاتٍ طَالِعَةٍ مِنَ ٱلنَّهْرِ سَمِينَةِ ٱللَّحْمِ وَحَسَنَةَ ٱلصُّورَةِ، فَٱرْتَعَتْ فِي رَوْضَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ثُمَّ هُوَذَا سَبْعُ بَقَرَاتٍ أُخْرَى طَالِعَةٍ وَرَاءَهَا مَهْزُولَةً وَقَبِيحَةَ ٱلصُّورَةِ جِدًّا وَرَقِيقَةَ ٱللَّحْمِ. لَمْ أَنْظُرْ فِي كُلِّ أَرْضِ مِصْرَ مِثْلَهَا فِي ٱلْقَبَاحَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","فَأَكَلَتِ ٱلْبَقَرَاتُ ٱلرَّقِيقَةُ وَٱلْقَبِيحَةُ ٱلْبَقَرَاتِ ٱلسَّبْعَ ٱلْأُولَى ٱلسَّمِينَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","فَدَخَلَتْ أَجْوَافَهَا، وَلَمْ يَعْلَمْ أَنَّهَا دَخَلَتْ فِي أَجْوَافِهَا، فَكَانَ مَنْظَرُهَا قَبِيحًا كَمَا فِي ٱلْأَوَّلِ. وَٱسْتَيْقَظْتُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ثُمَّ رَأَيْتُ فِي حُلْمِي وَهُوَذَا سَبْعُ سَنَابِلَ طَالِعَةٌ فِي سَاقٍ وَاحِدٍ مُمْتَلِئَةً وَحَسَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ثُمَّ هُوَذَا سَبْعُ سَنَابِلَ يَابِسَةً رَقِيقَةً مَلْفُوحَةً بِٱلرِّيحِ ٱلشَّرْقِيَّةِ نَابِتَةٌ وَرَاءَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","فَٱبْتَلَعَتِ ٱلسَّنَابِلُ ٱلرَّقِيقَةُ ٱلسَّنَابِلَ ٱلسَّبْعَ ٱلْحَسَنَةَ. فَقُلْتُ لِلسَّحَرَةِ، وَلَمْ يَكُنْ مَنْ يُخْبِرُنِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","فَقَالَ يُوسُفُ لِفِرْعَوْنَ: «حُلْمُ فِرْعَوْنَ وَاحِدٌ. قَدْ أَخْبَرَ ٱللهُ فِرْعَوْنَ بِمَا هُوَ صَانِعٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","اَلْبَقَرَاتُ ٱلسَّبْعُ ٱلْحَسَنَةُ هِيَ سَبْعُ سِنِينَ، وَٱلسَّنَابِلُ ٱلسَّبْعُ ٱلْحَسَنَةُ هِيَ سَبْعُ سِنِينَ. هُوَ حُلْمٌ وَاحِدٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","وَٱلْبَقَرَاتُ ٱلسَّبْعُ ٱلرَّقِيقَةُ ٱلْقَبِيحَةُ ٱلَّتِي طَلَعَتْ وَرَاءَهَا هِيَ سَبْعُ سِنِينَ، وَٱلسَّنَابِلُ ٱلسَّبْعُ ٱلْفَارِغَةُ ٱلْمَلْفُوحَةُ بِٱلرِّيحِ ٱلشَّرْقِيَّةِ تَكُونُ سَبْعَ سِنِينَ جُوعًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","هُوَ ٱلْأَمْرُ ٱلَّذِي كَلَّمْتُ بِهِ فِرْعَوْنَ. قَدْ أَظْهَرَ ٱللهُ لِفِرْعَوْنَ مَا هُوَ صَانِعٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","هُوَذَا سَبْعُ سِنِينَ قَادِمَةٌ شِبَعًا عَظِيمًا فِي كُلِّ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ثُمَّ تَقُومُ بَعْدَهَا سَبْعُ سِنِينَ جُوعًا، فَيُنْسَى كُلُّ ٱلشِّبَعِ فِي أَرْضِ مِصْرَ وَيُتْلِفُ ٱلْجُوعُ ٱلْأَرْضَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","وَلَا يُعْرَفُ ٱلشِّبَعُ فِي ٱلْأَرْضِ مِنْ أَجْلِ ذَلِكَ ٱلْجُوعِ بَعْدَهُ، لِأَنَّهُ يَكُونُ شَدِيدًا جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","وَأَمَّا عَنْ تَكْرَارِ ٱلْحُلْمِ عَلَى فِرْعَوْنَ مَرَّتَيْنِ، فَلِأَنَّ ٱلْأَمْرَ مُقَرَّرٌ مِنْ قِبَلِ ٱللهِ، وَٱللهُ مُسْرِعٌ لِيَصْنَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«فَٱلْآنَ لِيَنْظُرْ فِرْعَوْنُ رَجُلًا بَصِيرًا وَحَكِيمًا وَيَجْعَلْهُ عَلَى أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","يَفْعَلْ فِرْعَوْنُ فَيُوَكِّلْ نُظَّارًا عَلَى ٱلْأَرْضِ، وَيَأْخُذْ خُمْسَ غَلَّةِ أَرْضِ مِصْرَ فِي سَبْعِ سِنِي ٱلشِّبَعِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","فَيَجْمَعُونَ جَمِيعَ طَعَامِ هَذِهِ ٱلسِّنِينَ ٱلْجَيِّدَةِ ٱلْقَادِمَةِ، وَيَخْزِنُونَ قَمْحًا تَحْتَ يَدِ فِرْعَوْنَ طَعَامًا فِي ٱلْمُدُنِ وَيَحْفَظُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","فَيَكُونُ ٱلطَّعَامُ ذَخِيرَةً لِلْأَرْضِ لِسَبْعِ سِنِي ٱلْجُوعِ ٱلَّتِي تَكُونُ فِي أَرْضِ مِصْرَ، فَلَا تَنْقَرِضُ ٱلْأَرْضُ بِٱلْجُوعِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","فَحَسُنَ ٱلْكَلَامُ فِي عَيْنَيْ فِرْعَوْنَ وَفِي عُيُونِ جَمِيعِ عَبِيدِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","فَقَالَ فِرْعَوْنُ لِعَبِيدِهِ: «هَلْ نَجِدُ مِثْلَ هَذَا رَجُلًا فِيهِ رُوحُ ٱللهِ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ثُمَّ قَالَ فِرْعَوْنُ لِيُوسُفَ: «بَعْدَ مَا أَعْلَمَكَ ٱللهُ كُلَّ هَذَا، لَيْسَ بَصِيرٌ وَحَكِيمٌ مِثْلَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","أَنْتَ تَكُونُ عَلَى بَيْتِي، وَعَلَى فَمِكَ يُقَبِّلُ جَمِيعُ شَعْبِي إِلَا إِنَّ ٱلْكُرْسِيَّ أَكُونُ فِيهِ أَعْظَمَ مِنْكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ثُمَّ قَالَ فِرْعَوْنُ لِيُوسُفَ: «ٱنْظُرْ، قَدْ جَعَلْتُكَ عَلَى كُلِّ أَرْضِ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","وَخَلَعَ فِرْعَوْنُ خَاتِمَهُ مِنْ يَدِهِ وَجَعَلَهُ فِي يَدِ يُوسُفَ، وَأَلْبَسَهُ ثِيَابَ بُوصٍ، وَوَضَعَ طَوْقَ ذَهَبٍ فِي عُنُقِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","وَأَرْكَبَهُ فِي مَرْكَبَتِهِ ٱلْثَّانِيَةِ، وَنَادَوْا أَمَامَهُ «ٱرْكَعُوا». وَجَعَلَهُ عَلَى كُلِّ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","وَقَالَ فِرْعَوْنُ لِيُوسُفَ: «أَنَا فِرْعَوْنُ. فَبِدُونِكَ لَا يَرْفَعُ إِنْسَانٌ يَدَهُ وَلَا رِجْلَهُ فِي كُلِّ أَرْضِ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","وَدَعَا فِرْعَوْنُ ٱسْمَ يُوسُفَ «صَفْنَاتَ فَعْنِيحَ»، وَأَعْطَاهُ أَسْنَاتَ بِنْتَ فُوطِي فَارَعَ كَاهِنِ أُونَ زَوْجَةً. فَخَرَجَ يُوسُفُ عَلَى أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","وَكَانَ يُوسُفُ ٱبْنَ ثَلَاثِينَ سَنَةً لَمَّا وَقَفَ قُدَّامَ فِرْعَوْنَ مَلِكِ مِصْرَ. فَخَرَجَ يُوسُفُ مِنْ لَدُنْ فِرْعَوْنَ وَٱجْتَازَ فِي كُلِّ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","وَأَثْمَرَتِ ٱلْأَرْضُ فِي سَبْعِ سِنِي ٱلشِّبَعِ بِحُزَمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","فَجَمَعَ كُلَّ طَعَامِ ٱلسَّبْعِ سِنِينَ ٱلَّتِي كَانَتْ فِي أَرْضِ مِصْرَ، وَجَعَلَ طَعَامًا فِي ٱلْمُدُنِ. طَعَامَ حَقْلِ ٱلْمَدِينَةِ ٱلَّذِي حَوَالَيْهَا جَعَلَهُ فِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","وَخَزَنَ يُوسُفُ قَمْحًا كَرَمْلِ ٱلْبَحْرِ، كَثِيرًا جِدًّا حَتَّى تَرَكَ ٱلْعَدَدَ، إِذْ لَمْ يَكُنْ لَهُ عَدَدٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","وَوُلِدَ لِيُوسُفَ ٱبْنَانِ قَبْلَ أَنْ تَأْتِيَ سَنَةُ ٱلْجُوعِ، وَلَدَتْهُمَا لَهُ أَسْنَاتُ بِنْتُ فُوطِي فَارَعَ كَاهِنِ أُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","وَدَعَا يُوسُفُ ٱسْمَ ٱلْبِكْرِ «مَنَسَّى» قَائِلًا: «لِأَنَّ ٱللهَ أَنْسَانِي كُلَّ تَعَبِي وَكُلَّ بَيْتِ أَبِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","وَدَعَا ٱسْمَ ٱلثَّانِى «أَفْرَايِمَ» قَائِلًا: «لِأَنَّ ٱللهَ جَعَلَنِي مُثْمِرًا فِي أَرْضِ مَذَلَّتِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ثُمَّ كَمِلَتْ سَبْعُ سِنِي ٱلشِّبَعِ ٱلَّذِي كَانَ فِي أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","وَٱبْتَدَأَتْ سَبْعُ سِنِي ٱلْجُوعِ تَأْتِي كَمَا قَالَ يُوسُفُ، فَكَانَ جُوعٌ فِي جَمِيعِ ٱلْبُلْدَانِ. وَأَمَّا جَمِيعُ أَرْضِ مِصْرَ فَكَانَ فِيهَا خُبْزٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","وَلَمَّا جَاعَتْ جَمِيعُ أَرْضِ مِصْرَ وَصَرَخَ ٱلشَّعْبُ إِلَى فِرْعَوْنَ لِأَجْلِ ٱلْخُبْزِ، قَالَ فِرْعَوْنُ لِكُلِّ ٱلْمِصْرِيِّينَ: «ٱذْهَبُوا إِلَى يُوسُفَ، وَٱلَّذِي يَقُولُ لَكُمُ ٱفْعَلُوا». ");
INSERT INTO arb_vd_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","وَكَانَ ٱلْجُوعُ عَلَى كُلِّ وَجْهِ ٱلْأَرْضِ، وَفَتَحَ يُوسُفُ جَمِيعَ مَا فِيهِ طَعَامٌ وَبَاعَ لِلْمِصْرِيِّينَ. وَٱشْتَدَّ ٱلْجُوعُ فِي أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","وَجَاءَتْ كُلُّ ٱلْأَرْضِ إِلَى مِصْرَ إِلَى يُوسُفَ لِتَشْتَرِيَ قَمْحًا، لِأَنَّ ٱلْجُوعَ كَانَ شَدِيدًا فِي كُلِّ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","فَلَمَّا رَأَى يَعْقُوبُ أَنَّهُ يُوجَدُ قَمْحٌ فِي مِصْرَ، قَالَ يَعْقُوبُ لِبَنِيهِ: «لِمَاذَا تَنْظُرُونَ بَعْضُكُمْ إِلَى بَعْضٍ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","وَقَالَ «إِنِّي قَدْ سَمِعْتُ أَنَّهُ يُوجَدُ قَمْحٌ فِي مِصْرَ. ٱنْزِلُوا إِلَى هُنَاكَ وَٱشْتَرُوا لَنَا مِنْ هُنَاكَ لِنَحْيَا وَلَا نَمُوتَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","فَنَزَلَ عَشْرَةٌ مِنْ إِخْوَةِ يُوسُفَ لِيَشْتَرُوا قَمْحًا مِنْ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","وَأَمَّا بَنْيَامِينُ أَخُو يُوسُفَ فَلَمْ يُرْسِلْهُ يَعْقُوبُ مَعَ إِخْوَتِهِ، لِأَنَّهُ قَالَ: «لَعَلَّهُ تُصِيبُهُ أَذِيَّةٌ». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","فَأَتَى بَنُو إِسْرَائِيلَ لِيَشْتَرُوا بَيْنَ ٱلَّذِينَ أَتَوْا، لِأَنَّ ٱلْجُوعَ كَانَ فِي أَرْضِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","وَكَانَ يُوسُفُ هُوَ ٱلْمُسَلَّطَ عَلَى ٱلْأَرْضِ، وَهُوَ ٱلْبَائِعَ لِكُلِّ شَعْبِ ٱلْأَرْضِ. فَأَتَى إِخْوَةُ يُوسُفَ وَسَجَدُوا لَهُ بِوُجُوهِهِمْ إِلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","وَلَمَّا نَظَرَ يُوسُفُ إِخْوَتَهُ عَرَفَهُمْ، فَتَنَكَّرَ لَهُمْ وَتَكَلَّمَ مَعَهُمْ بِجَفَاءٍ، وَقَالَ لَهُمْ: «مِنْ أَيْنَ جِئْتُمْ؟» فَقَالُوا: «مِنْ أَرْضِ كَنْعَانَ لِنَشْتَرِيَ طَعَامًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","وَعَرَفَ يُوسُفُ إِخْوَتَهُ، وَأَمَّا هُمْ فَلَمْ يَعْرِفُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","فَتَذَكَّرَ يُوسُفُ ٱلْأَحْلَامَ ٱلَّتِي حَلُمَ عَنْهُمْ، وَقَالَ لَهُمْ: «جَوَاسِيسُ أَنْتُمْ! لِتَرَوْا عَوْرَةَ ٱلْأَرْضِ جِئْتُمْ» ");
INSERT INTO arb_vd_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","فَقَالُوا لَهُ: «لَا يَا سَيِّدِي، بَلْ عَبِيدُكَ جَاءُوا لِيَشْتَرُوا طَعَامًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","نَحْنُ جَمِيعُنَا بَنُو رَجُلٍ وَاحِدٍ. نَحْنُ أُمَنَاءُ، لَيْسَ عَبِيدُكَ جَوَاسِيسَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","فَقَالَ لَهُمْ: «كَلَّا! بَلْ لِتَرَوْا عَوْرَةَ ٱلْأَرْضِ جِئْتُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","فَقَالُوا: «عَبِيدُكَ ٱثْنَا عَشَرَ أَخًا. نَحْنُ بَنُو رَجُلٍ وَاحِدٍ فِي أَرْضِ كَنْعَانَ. وَهُوَذَا ٱلصَّغِيرُ عِنْدَ أَبِينَا ٱلْيَوْمَ، وَٱلْوَاحِدُ مَفْقُودٌ». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","فَقَالَ لَهُمْ يُوسُفُ: «ذَلِكَ مَا كَلَّمْتُكُمْ بِهِ قَائِلًا: جَوَاسِيسُ أَنْتُمْ! ");
INSERT INTO arb_vd_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","بِهَذَا تُمْتَحَنُونَ. وَحَيَاةِ فِرْعَوْنَ لَا تَخْرُجُونَ مِنْ هُنَا إِلَا بِمَجِيءِ أَخِيكُمُ ٱلصَّغِيرِ إِلَى هُنَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","أَرْسِلُوا مِنْكُمْ وَاحِدًا لِيَجِيءَ بِأَخِيكُمْ، وَأَنْتُمْ تُحْبَسُونَ، فَيُمْتَحَنَ كَلَامُكُمْ هَلْ عِنْدَكُمْ صِدْقٌ. وَإِلَا فَوَحَيَاةِ فِرْعَوْنَ إِنَّكُمْ لَجَوَاسِيسُ!». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","فَجَمَعَهُمْ إِلَى حَبْسٍ ثَلَاثَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ثُمَّ قَالَ لَهُمْ يُوسُفُ فِي ٱلْيَوْمِ ٱلثَّالِثِ: «ٱفْعَلُوا هَذَا وَٱحْيَوْا. أَنَا خَائِفُ ٱللهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","إِنْ كُنْتُمْ أُمَنَاءَ فَلْيُحْبَسْ أَخٌ وَاحِدٌ مِنْكُمْ فِي بَيْتِ حَبْسِكُمْ، وَٱنْطَلِقُوا أَنْتُمْ وَخُذُوا قَمْحًا لِمَجَاعَةِ بُيُوتِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","وَأَحْضِرُوا أَخَاكُمُ ٱلصَّغِيرَ إِلَيَّ، فَيَتَحَقَّقَ كَلَامُكُمْ وَلَا تَمُوتُوا». فَفَعَلُوا هَكَذَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","وَقَالُوا بَعْضُهُمْ لِبَعْضٍ: «حَقًّا إِنَّنَا مُذْنِبُونَ إِلَى أَخِينَا ٱلَّذِي رَأَيْنَا ضِيقَةَ نَفْسِهِ لَمَّا ٱسْتَرْحَمَنَا وَلَمْ نَسْمَعْ. لِذَلِكَ جَاءَتْ عَلَيْنَا هَذِهِ ٱلضِّيقَةُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","فَأَجَابَهُمْ رَأُوبَيْنُ قَائِلًا: «أَلَمْ أُكَلِّمْكُمْ قَائِلًا: لَا تَأْثَمُوا بِٱلْوَلَدِ، وَأَنْتُمْ لَمْ تَسْمَعُوا؟ فَهُوَذَا دَمُهُ يُطْلَبُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","وَهُمْ لَمْ يَعْلَمُوا أَنَّ يُوسُفَ فَاهِمٌ، لِأَنَّ ٱلتُّرْجُمَانَ كَانَ بَيْنَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","فَتَحَوَّلَ عَنْهُمْ وَبَكَى، ثُمَّ رَجَعَ إِلَيْهِمْ وَكَلَّمَهُمْ، وَأَخَذَ مِنْهُمْ شِمْعُونَ وَقَيَّدَهُ أَمَامَ عُيُونِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ثُمَّ أَمَرَ يُوسُفُ أَنْ تُمْلَأَ أَوْعِيَتُهُمْ قَمْحًا، وَتُرَدَّ فِضَّةُ كُلِّ وَاحِدٍ إِلَى عِدْلِهِ، وَأَنْ يُعْطَوْا زَادًا لِلطَّرِيقِ. فَفُعِلَ لَهُمْ هَكَذَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","فَحَمَلُوا قَمْحَهُمْ عَلَى حَمِيرِهِمْ وَمَضَوْا مِنْ هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","فَلَمَّا فَتَحَ أَحَدُهُمْ عِدْلَهُ لِيُعْطِيَ عَلِيقًا لِحِمَارِهِ فِي ٱلْمَنْزِلِ، رَأَى فِضَّتَهُ وَإِذَا هِيَ فِي فَمِ عِدْلِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","فَقَالَ لِإِخْوَتِهِ: «رُدَّتْ فِضَّتِي وَهَا هِيَ فِي عِدْلِي». فَطَارَتْ قُلُوبُهُمْ وَٱرْتَعَدُوا بَعْضُهُمْ فِي بَعْضٍ قَائِلِينَ: «مَا هَذَا ٱلَّذِي صَنَعَهُ ٱللهُ بِنَا؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","فَجَاءُوا إِلَى يَعْقُوبَ أَبِيهِمْ إِلَى أَرْضِ كَنْعَانَ، وَأَخْبَرُوهُ بِكُلِّ مَا أَصَابَهُمْ قَائِلِينَ: ");
INSERT INTO arb_vd_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«تَكَلَّمَ مَعَنَا ٱلرَّجُلُ سَيِّدُ ٱلْأَرْضِ بِجَفَاءٍ، وَحَسِبَنَا جَوَاسِيسَ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","فَقُلْنَا لَهُ: نَحْنُ أُمَنَاءُ، لَسْنَا جَوَاسِيسَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","نَحْنُ ٱثْنَا عَشَرَ أَخًا بَنُو أَبِينَا. ٱلْوَاحِدُ مَفْقُودٌ وَٱلصَّغِيرُ ٱلْيَوْمَ عِنْدَ أَبِينَا فِي أَرْضِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","فَقَالَ لَنَا ٱلرَّجُلُ سَيِّدُ ٱلْأَرْضِ: بِهَذَا أَعْرِفُ أَنَّكُمْ أُمَنَاءُ. دَعُوا أَخًا وَاحِدًا مِنْكُمْ عِنْدِي، وَخُذُوا لِمَجَاعَةِ بُيُوتِكُمْ وَٱنْطَلِقُوا. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","وَأَحْضِرُوا أَخَاكُمُ ٱلصَّغِيرَ إِلَيَّ فَأَعْرِفَ أَنَّكُمْ لَسْتُمْ جَوَاسِيسَ، بَلْ أَنَّكُمْ أُمَنَاءُ، فَأُعْطِيَكُمْ أَخَاكُمْ وَتَتَّجِرُونَ فِي ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","وَإِذْ كَانُوا يُفَرِّغُونَ عِدَالَهُمْ إِذَا صُرَّةُ فِضَّةِ كُلِّ وَاحِدٍ فِي عِدْلِهِ. فَلَمَّا رَأَوْا صُرَرَ فِضَّتِهِمْ هُمْ وَأَبُوهُمْ خَافُوا. ");
INSERT INTO arb_vd_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","فَقَالَ لَهُمْ يَعْقُوبُ: «أَعْدَمْتُمُونِي ٱلْأَوْلَادَ. يُوسُفُ مَفْقُودٌ، وَشِمْعُونُ مَفْقُودٌ، وَبَنْيَامِينُ تَأْخُذُونَهُ. صَارَ كُلُّ هَذَا عَلَيَّ». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","وَكَلَّمَ رَأُوبَيْنُ أَبَاهُ قَائِلًا: «ٱقْتُلِ ٱبْنَيَّ إِنْ لَمْ أَجِئْ بِهِ إِلَيْكَ. سَلِّمْهُ بِيَدِي وَأَنَا أَرُدُّهُ إِلَيْكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","فَقَالَ: «لَا يَنْزِلُ ٱبْنِي مَعَكُمْ، لِأَنَّ أَخَاهُ قَدْ مَاتَ، وَهُوَ وَحْدَهُ بَاقٍ. فَإِنْ أَصَابَتْهُ أَذِيَّةٌ فِي ٱلطَّرِيقِ ٱلَّتِي تَذْهَبُونَ فِيهَا تُنْزِلُونَ شَيْبَتِي بِحُزْنٍ إِلَى ٱلْهَاوِيَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","وَكَانَ ٱلْجُوعُ شَدِيدًا فِي ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","وَحَدَثَ لَمَّا فَرَغُوا مِنْ أَكْلِ ٱلْقَمْحِ ٱلَّذِي جَاءُوا بِهِ مِنْ مِصْرَ، أَنَّ أَبَاهُمْ قَالَ لَهُمُ: «ٱرْجِعُوا ٱشْتَرُوا لَنَا قَلِيلًا مِنَ ٱلطَّعَامِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","فَكَلَّمَهُ يَهُوذَا قَائِلًا: «إِنَّ ٱلرَّجُلَ قَدْ أَشْهَدَ عَلَيْنَا قَائِلًا: لَا تَرَوْنَ وَجْهِي بِدُونِ أَنْ يَكُونَ أَخُوكُمْ مَعَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","إِنْ كُنْتَ تُرْسِلُ أَخَانَا مَعَنَا، نَنْزِلُ وَنَشْتَرِي لَكَ طَعَامًا، ");
INSERT INTO arb_vd_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","وَلَكِنْ إِنْ كُنْتَ لَا تُرْسِلُهُ لَا نَنْزِلُ. لِأَنَّ ٱلرَّجُلَ قَالَ لَنَا: لَا تَرَوْنَ وَجْهِي بِدُونِ أَنْ يَكُونَ أَخُوكُمْ مَعَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","فَقَالَ إِسْرَائِيلُ: «لِمَاذَا أَسَأْتُمْ إِلَيَّ حَتَّى أَخْبَرْتُمُ ٱلرَّجُلَ أَنَّ لَكُمْ أَخًا أَيْضًا؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","فَقَالُوا: «إِنَّ ٱلرَّجُلَ قَدْ سَأَلَ عَنَّا وَعَنْ عَشِيرَتِنَا، قَائِلًا: هَلْ أَبُوكُمْ حَيٌّ بَعْدُ؟ هَلْ لَكُمْ أَخٌ؟ فَأَخْبَرْنَاهُ بِحَسَبِ هَذَا ٱلْكَلَامِ. هَلْ كُنَّا نَعْلَمُ أَنَّهُ يَقُولُ: ٱنْزِلُوا بِأَخِيكُمْ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","وَقَالَ يَهُوذَا لِإِسْرَائِيلَ أَبِيهِ: «أَرْسِلِ ٱلْغُلَامَ مَعِي لِنَقُومَ وَنَذْهَبَ وَنَحْيَا وَلَا نَمُوتَ، نَحْنُ وَأَنْتَ وَأَوْلَادُنَا جَمِيعًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","أَنَا أَضْمَنُهُ. مِنْ يَدِي تَطْلُبُهُ. إِنْ لَمْ أَجِئْ بِهِ إِلَيْكَ وَأُوقِفْهُ قُدَّامَكَ، أَصِرْ مُذْنِبًا إِلَيْكَ كُلَّ ٱلْأَيَّامِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","لِأَنَّنَا لَوْ لَمْ نَتَوَانَ لَكُنَّا قَدْ رَجَعْنَا ٱلْآنَ مَرَّتَيْنِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","فَقَالَ لَهُمْ إِسْرَائِيلُ أَبُوهُمْ: «إِنْ كَانَ هَكَذَا فَٱفْعَلُوا هَذَا: خُذُوا مِنْ أَفْخَرِ جَنَى ٱلْأَرْضِ فِي أَوْعِيَتِكُمْ، وَأَنْزِلُوا لِلرَّجُلِ هَدِيَّةً. قَلِيلًا مِنَ ٱلْبَلَسَانِ، وَقَلِيلًا مِنَ ٱلْعَسَلِ، وَكَثِيرَاءَ وَلَاذَنًا وَفُسْتُقًا وَلَوْزًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","وَخُذُوا فِضَّةً أُخْرَى فِي أَيَادِيكُمْ. وَٱلْفِضَّةَ ٱلْمَرْدُودَةَ فِي أَفْوَاهِ عِدَالِكُمْ رُدُّوهَا فِي أَيَادِيكُمْ، لَعَلَّهُ كَانَ سَهْوًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","وَخُذُوا أَخَاكُمْ وَقُومُوا ٱرْجِعُوا إِلَى ٱلرَّجُلِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","وَٱللهُ ٱلْقَدِيرُ يُعْطِيكُمْ رَحْمَةً أَمَامَ ٱلرَّجُلِ حَتَّى يُطْلِقَ لَكُمْ أَخَاكُمُ ٱلْآخَرَ وَبَنْيَامِينَ. وَأَنَا إِذَا عَدِمْتُ ٱلْأَوْلَادَ عَدِمْتُهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","فَأَخَذَ ٱلرِّجَالُ هَذِهِ ٱلْهَدِيَّةَ، وَأَخَذُوا ضِعْفَ ٱلْفِضَّةِ فِي أَيَادِيهِمْ، وَبَنْيَامِينَ، وَقَامُوا وَنَزَلُوا إِلَى مِصْرَ وَوَقَفُوا أَمَامَ يُوسُفَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","فَلَمَّا رَأَى يُوسُفُ بَنْيَامِينَ مَعَهُمْ، قَالَ لِلَّذِي عَلَى بَيْتِهِ: «أَدْخِلِ ٱلرِّجَالَ إِلَى ٱلْبَيْتِ وَٱذْبَحْ ذَبِيحَةً وَهَيِّئْ، لِأَنَّ ٱلرِّجَالَ يَأْكُلُونَ مَعِي عِنْدَ ٱلظُّهْرِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","فَفَعَلَ ٱلرَّجُلُ كَمَا قَالَ يُوسُفُ. وَأَدْخَلَ ٱلرَّجُلُ ٱلرِّجَالَ إِلَى بَيْتِ يُوسُفَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","فَخَافَ ٱلرِّجَالُ إِذْ أُدْخِلُوا إِلَى بَيْتِ يُوسُفَ، وَقَالُوا: «لِسَبَبِ ٱلْفِضَّةِ ٱلَّتِي رَجَعَتْ أَوَّلًا فِي عِدَالِنَا نَحْنُ قَدْ أُدْخِلْنَا لِيَهْجِمَ عَلَيْنَا وَيَقَعَ بِنَا وَيَأْخُذَنَا عَبِيدًا وَحَمِيرَنَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","فَتَقَدَّمُوا إِلَى ٱلرَّجُلِ ٱلَّذِي عَلَى بَيْتِ يُوسُفَ، وَكَلَّمُوهُ فِي بَابِ ٱلْبَيْتِ ");
INSERT INTO arb_vd_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","وَقَالُوا: «ٱسْتَمِعْ يَا سَيِّدِي، إِنَّنَا قَدْ نَزَلْنَا أَوَّلًا لِنَشْتَرِيَ طَعَامًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","وَكَانَ لَمَّا أَتَيْنَا إِلَى ٱلْمَنْزِلِ أَنَّنَا فَتَحْنَا عِدَالَنَا، وَإِذَا فِضَّةُ كُلِّ وَاحِدٍ فِي فَمِ عِدْلِهِ. فِضَّتُنَا بِوَزْنِهَا. فَقَدْ رَدَدْنَاهَا فِي أَيَادِينَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","وَأَنْزَلْنَا فِضَّةً أُخْرَى فِي أَيَادِينَا لِنَشْتَرِيَ طَعَامًا. لَا نَعْلَمُ مَنْ وَضَعَ فِضَّتَنَا فِي عِدَالِنَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","فَقَالَ: «سَلَامٌ لَكُمْ، لَا تَخَافُوا. إِلَهُكُمْ وَإِلَهُ أَبِيكُمْ أَعْطَاكُمْ كَنْزًا فِي عِدَالِكُمْ. فِضَّتُكُمْ وَصَلَتْ إِلَيَّ». ثُمَّ أَخْرَجَ إِلَيْهِمْ شِمْعُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","وَأَدْخَلَ ٱلرَّجُلُ ٱلرِّجَالَ إِلَى بَيْتِ يُوسُفَ وَأَعْطَاهُمْ مَاءً لِيَغْسِلُوا أَرْجُلَهُمْ، وَأَعْطَى عَلِيقًا لِحَمِيرِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","وَهَيَّأُوا ٱلْهَدِيَّةَ إِلَى أَنْ يَجِيءَ يُوسُفُ عِنْدَ ٱلظُّهْرِ، لِأَنَّهُمْ سَمِعُوا أَنَّهُمْ هُنَاكَ يَأْكُلُونَ طَعَامًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","فَلَمَّا جَاءَ يُوسُفُ إِلَى ٱلْبَيْتِ أَحْضَرُوا إِلَيْهِ ٱلْهَدِيَّةَ ٱلَّتِي فِي أَيَادِيهِمْ إِلَى ٱلْبَيْتِ، وَسَجَدُوا لَهُ إِلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","فَسَأَلَ عَنْ سَلَامَتِهِمْ، وَقَالَ: «أَسَالِمٌ أَبُوكُمُ ٱلشَّيْخُ ٱلَّذِي قُلْتُمْ عَنْهُ؟ أَحَيٌّ هُوَ بَعْدُ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","فَقَالُوا: «عَبْدُكَ أَبُونَا سَالِمٌ. هُوَ حَيٌّ بَعْدُ». وَخَرُّوا وَسَجَدُوا. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","فَرَفَعَ عَيْنَيْهِ وَنَظَرَ بَنْيَامِينَ أَخَاهُ ٱبْنَ أُمِّهِ، وَقَالَ: «أَهَذَا أَخُوكُمُ ٱلصَّغِيرُ ٱلَّذِي قُلْتُمْ لِي عَنْهُ؟» ثُمَّ قَالَ: «ٱللهُ يُنْعِمُ عَلَيْكَ يَا ٱبْنِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","وَٱسْتَعْجَلَ يُوسُفُ لِأَنَّ أَحْشَاءَهُ حَنَّتْ إِلَى أَخِيهِ وَطَلَبَ مَكَانًا لِيَبْكِيَ، فَدَخَلَ ٱلْمَخْدَعَ وَبَكَى هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ثُمَّ غَسَلَ وَجْهَهُ وَخَرَجَ وَتَجَلَّدَ، وَقَالَ: «قَدِّمُوا طَعَامًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","فَقَدَّمُوا لَهُ وَحْدَهُ، وَلَهُمْ وَحْدَهُمْ، وَلِلْمِصْرِيِّينَ ٱلْآكِلِينَ عِنْدَهُ وَحْدَهُمْ، لِأَنَّ ٱلْمِصْرِيِّينَ لَا يَقْدِرُونَ أَنْ يَأْكُلُوا طَعَامًا مَعَ ٱلْعِبْرَانِيِّينَ، لِأَنَّهُ رِجْسٌ عِنْدَ ٱلْمِصْرِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","فَجَلَسُوا قُدَّامَهُ: ٱلْبِكْرُ بِحَسَبِ بَكُورِيَّتِهِ، وَٱلصَّغِيرُ بِحَسَبِ صِغَرِهِ، فَبُهِتَ ٱلرِّجَالُ بَعْضُهُمْ إِلَى بَعْضٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","وَرَفَعَ حِصَصًا مِنْ قُدَّامِهِ إِلَيْهِمْ، فَكَانَتْ حِصَّةُ بَنْيَامِينَ أَكْثَرَ مِنْ حِصَصِ جَمِيعِهِمْ خَمْسَةَ أَضْعَافٍ. وَشَرِبُوا وَرَوُوا مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ثُمَّ أَمَرَ ٱلَّذِي عَلَى بَيْتِهِ قَائِلًا: «ٱمْلَأْ عِدَالَ ٱلرِّجَالِ طَعَامًا حَسَبَ مَا يُطِيقُونَ حِمْلَهُ، وَضَعْ فِضَّةَ كُلِّ وَاحِدٍ فِي فَمِ عِدْلِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","وَطَاسِي، طَاسَ ٱلْفِضَّةِ، تَضَعُ فِي فَمِ عِدْلِ ٱلصَّغِيرِ، وَثَمَنَ قَمْحِهِ». فَفَعَلَ بِحَسَبِ كَلَامِ يُوسُفَ ٱلَّذِي تَكَلَّمَ بِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","فَلَمَّا أَضَاءَ ٱلصُّبْحُ ٱنْصَرَفَ ٱلرِّجَالُ هُمْ وَحَمِيرُهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","وَلَمَّا كَانُوا قَدْ خَرَجُوا مِنَ ٱلْمَدِينَةِ وَلَمْ يَبْتَعِدُوا، قَالَ يُوسُفُ لِلَّذِي عَلَى بَيْتِهِ: «قُمِ ٱسْعَ وَرَاءَ ٱلرِّجَالِ، وَمَتَى أَدْرَكْتَهُمْ فَقُلْ لَهُمْ: لِمَاذَا جَازَيْتُمْ شَرًّا عِوَضًا عَنْ خَيْرٍ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","أَلَيْسَ هَذَا هُوَ ٱلَّذِي يَشْرَبُ سَيِّدِي فِيهِ؟ وَهُوَ يَتَفَاءَلُ بِهِ. أَسَأْتُمْ فِي مَا صَنَعْتُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","فَأَدْرَكَهُمْ وَقَالَ لَهُمْ هَذَا ٱلْكَلَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","فَقَالُوا لَهُ: «لِمَاذَا يَتَكَلَّمُ سَيِّدِي مِثْلَ هَذَا ٱلْكَلَامِ؟ حَاشَا لِعَبِيدِكَ أَنْ يَفْعَلُوا مِثْلَ هَذَا ٱلْأَمْرِ! ");
INSERT INTO arb_vd_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","هُوَذَا ٱلْفِضَّةُ ٱلَّتِي وَجَدْنَا فِي أَفْوَاهِ عِدَالِنَا رَدَدْنَاهَا إِلَيْكَ مِنْ أَرْضِ كَنْعَانَ. فَكَيْفَ نَسْرِقُ مِنْ بَيْتِ سَيِّدِكَ فِضَّةً أَوْ ذَهَبًا؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ٱلَّذِي يُوجَدُ مَعَهُ مِنْ عَبِيدِكَ يَمُوتُ، وَنَحْنُ أَيْضًا نَكُونُ عَبِيدًا لِسَيِّدِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","فَقَالَ: «نَعَمِ، ٱلْآنَ بِحَسَبِ كَلَامِكُمْ هَكَذَا يَكُونُ. ٱلَّذِي يُوجَدُ مَعَهُ يَكُونُ لِي عَبْدًا، وَأَمَّا أَنْتُمْ فَتَكُونُونَ أَبْرِيَاءَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","فَٱسْتَعْجَلُوا وَأَنْزَلُوا كُلُّ وَاحِدٍ عِدْلَهُ إِلَى ٱلْأَرْضِ، وَفَتَحُوا كُلُّ وَاحِدٍ عِدْلَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","فَفَتَّشَ مُبْتَدِئًا مِنَ ٱلْكَبِيرِ حَتَّى ٱنْتَهَى إِلَى ٱلصَّغِيرِ، فَوُجِدَ ٱلطَّاسُ فِي عِدْلِ بَنْيَامِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","فَمَزَّقُوا ثِيَابَهُمْ وَحَمَّلَ كُلُّ وَاحِدٍ عَلَى حِمَارِهِ وَرَجَعُوا إِلَى ٱلْمَدِينَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","فَدَخَلَ يَهُوذَا وَإِخْوَتُهُ إِلَى بَيْتِ يُوسُفَ وَهُوَ بَعْدُ هُنَاكَ، وَوَقَعُوا أَمَامَهُ عَلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","فَقَالَ لَهُمْ يُوسُفُ: «مَا هَذَا ٱلْفِعْلُ ٱلَّذِي فَعَلْتُمْ؟ أَلَمْ تَعْلَمُوا أَنَّ رَجُلًا مِثْلِي يَتَفَاءَلُ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","فَقَالَ يَهُوذَا: «مَاذَا نَقُولُ لِسَيِّدِي؟ مَاذَا نَتَكَلَّمُ؟ وَبِمَاذَا نَتَبَرَّرُ؟ ٱللهُ قَدْ وَجَدَ إِثْمَ عَبِيدِكَ. هَا نَحْنُ عَبِيدٌ لِسَيِّدِي، نَحْنُ وَٱلَّذِي وُجِدَ ٱلطَّاسُ فِي يَدِهِ جَمِيعًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","فَقَالَ: «حَاشَا لِي أَنْ أَفْعَلَ هَذَا! ٱلرَّجُلُ ٱلَّذِي وُجِدَ ٱلطَّاسُ فِي يَدِهِ هُوَ يَكُونُ لِي عَبْدًا، وَأَمَّا أَنْتُمْ فَٱصْعَدُوا بِسَلَامٍ إِلَى أَبِيكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ثُمَّ تَقَدَّمَ إِلَيْهِ يَهُوذَا وَقَالَ: «ٱسْتَمِعْ يَا سَيِّدِي. لِيَتَكَلَّمْ عَبْدُكَ كَلِمَةً فِي أُذُنَيْ سَيِّدِي وَلَا يَحْمَ غَضَبُكَ عَلَى عَبْدِكَ، لِأَنَّكَ مِثْلُ فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","سَيِّدِي سَأَلَ عَبِيدَهُ قَائِلًا: هَلْ لَكُمْ أَبٌ أَوْ أَخٌ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","فَقُلْنَا لِسَيِّدِي: لَنَا أَبٌ شَيْخٌ، وَٱبْنُ شَيْخُوخَةٍ صَغِيرٌ، مَاتَ أَخُوهُ وَبَقِيَ هُوَ وَحْدَهُ لِأُمِّهِ، وَأَبُوهُ يُحِبُّهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","فَقُلْتَ لِعَبِيدِكَ: ٱنْزِلُوا بِهِ إِلَيَّ فَأَجْعَلَ نَظَرِي عَلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","فَقُلْنَا لِسَيِّدِي: لَا يَقْدِرُ ٱلْغُلَامُ أَنْ يَتْرُكَ أَبَاهُ، وَإِنْ تَرَكَ أَبَاهُ يَمُوتُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","فَقُلْتَ لِعَبِيدِكَ: إِنْ لَمْ يَنْزِلْ أَخُوكُمُ ٱلصَّغِيرُ مَعَكُمْ لَا تَعُودُوا تَنْظُرُونَ وَجْهِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","فَكَانَ لَمَّا صَعِدْنَا إِلَى عَبْدِكَ أَبِي أَنَّنَا أَخْبَرْنَاهُ بِكَلَامِ سَيِّدِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ثُمَّ قَالَ أَبُونَا: ٱرْجِعُوا ٱشْتَرُوا لَنَا قَلِيلًا مِنَ ٱلطَّعَامِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","فَقُلْنَا: لَا نَقْدِرُ أَنْ نَنْزِلَ، وَإِنَّمَا إِذَا كَانَ أَخُونَا ٱلصَّغِيرُ مَعَنَا نَنْزِلُ، لِأَنَّنَا لَا نَقْدِرُ أَنْ نَنْظُرَ وَجْهَ ٱلرَّجُلِ وَأَخُونَا ٱلصَّغِيرُ لَيْسَ مَعَنَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","فَقَالَ لَنَا عَبْدُكَ أَبِي: أَنْتُمْ تَعْلَمُونَ أَنَّ ٱمْرَأَتِي وَلَدَتْ لِي ٱثْنَيْنِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","فَخَرَجَ ٱلْوَاحِدُ مِنْ عِنْدِي، وَقُلْتُ: إِنَّمَا هُوَ قَدِ ٱفْتُرِسَ ٱفْتِرَاسًا، وَلَمْ أَنْظُرْهُ إِلَى ٱلْآنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","فَإِذَا أَخَذْتُمْ هَذَا أَيْضًا مِنْ أَمَامِ وَجْهِي وَأَصَابَتْهُ أَذِيَّةٌ، تُنْزِلُونَ شَيْبَتِي بِشَرٍّ إِلَى ٱلْهَاوِيَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","فَٱلْآنَ مَتَى جِئْتُ إِلَى عَبْدِكَ أَبِي، وَٱلْغُلَامُ لَيْسَ مَعَنَا، وَنَفْسُهُ مُرْتَبِطَةٌ بِنَفْسِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","يَكُونُ مَتَى رَأَى أَنَّ ٱلْغُلَامَ مَفْقُودٌ، أَنَّهُ يَمُوتُ، فَيُنْزِلُ عَبِيدُكَ شَيْبَةَ عَبْدِكَ أَبِينَا بِحُزْنٍ إِلَى ٱلْهَاوِيَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","لِأَنَّ عَبْدَكَ ضَمِنَ ٱلْغُلَامَ لِأَبِي قَائِلًا: إِنْ لَمْ أَجِئْ بِهِ إِلَيْكَ أَصِرْ مُذْنِبًا إِلَى أَبِي كُلَّ ٱلْأَيَّامِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","فَٱلْآنَ لِيَمْكُثْ عَبْدُكَ عِوَضًا عَنِ ٱلْغُلَامِ، عَبْدًا لِسَيِّدِي، وَيَصْعَدِ ٱلْغُلَامُ مَعَ إِخْوَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","لِأَنِّي كَيْفَ أَصْعَدُ إِلَى أَبِي وَٱلْغُلَامُ لَيْسَ مَعِي؟ لِئَلَّا أَنْظُرَ ٱلشَّرَّ ٱلَّذِي يُصِيبُ أَبِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","فَلَمْ يَسْتَطِعْ يُوسُفُ أَنْ يَضْبِطَ نَفْسَهُ لَدَى جَمِيعِ ٱلْوَاقِفِينَ عِنْدَهُ فَصَرَخَ: «أَخْرِجُوا كُلَّ إِنْسَانٍ عَنِّي». فَلَمْ يَقِفْ أَحَدٌ عِنْدَهُ حِينَ عَرَّفَ يُوسُفُ إِخْوَتَهُ بِنَفْسِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","فَأَطْلَقَ صَوْتَهُ بِٱلْبُكَاءِ، فَسَمِعَ ٱلْمِصْرِيُّونَ وَسَمِعَ بَيْتُ فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","وَقَالَ يُوسُفُ لِإِخْوَتِهِ: «أَنَا يُوسُفُ. أَحَيٌّ أَبِي بَعْدُ؟» فَلَمْ يَسْتَطِعْ إِخْوَتُهُ أَنْ يُجِيبُوهُ، لِأَنَّهُمُ ٱرْتَاعُوا مِنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","فَقَالَ يُوسُفُ لِإِخْوَتِهِ: «تَقَدَّمُوا إِلَيَّ». فَتَقَدَّمُوا. فَقَالَ: «أَنَا يُوسُفُ أَخُوكُمُ ٱلَّذِي بِعْتُمُوهُ إِلَى مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","وَٱلْآنَ لَا تَتَأَسَّفُوا وَلَا تَغْتَاظُوا لِأَنَّكُمْ بِعْتُمُونِي إِلَى هُنَا، لِأَنَّهُ لِٱسْتِبْقَاءِ حَيَاةٍ أَرْسَلَنِيَ ٱللهُ قُدَّامَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","لِأَنَّ لِلْجُوعِ فِي ٱلْأَرْضِ ٱلْآنَ سَنَتَيْنِ. وَخَمْسُ سِنِينَ أَيْضًا لَا تَكُونُ فِيهَا فَلَاحَةٌ وَلَا حَصَادٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","فَقَدْ أَرْسَلَنِي ٱللهُ قُدَّامَكُمْ لِيَجْعَلَ لَكُمْ بَقِيَّةً فِي ٱلْأَرْضِ وَلِيَسْتَبْقِيَ لَكُمْ نَجَاةً عَظِيمَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","فَٱلْآنَ لَيْسَ أَنْتُمْ أَرْسَلْتُمُونِي إِلَى هُنَا بَلِ ٱللهُ. وَهُوَ قَدْ جَعَلَنِي أَبًا لِفِرْعَوْنَ وَسَيِّدًا لِكُلِّ بَيْتِهِ وَمُتَسَلِّطًا عَلَى كُلِّ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","أَسْرِعُوا وَٱصْعَدُوا إِلَى أَبِي وَقُولُوا لَهُ: هَكَذَا يَقُولُ ٱبْنُكَ يُوسُفُ: قَدْ جَعَلَنِيَ ٱللهُ سَيِّدًا لِكُلِّ مِصْرَ. اِنْزِلْ إِلَيَّ. لَا تَقِفْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","فَتَسْكُنَ فِي أَرْضِ جَاسَانَ وَتَكُونَ قَرِيبًا مِنِّي، أَنْتَ وَبَنُوكَ وَبَنُو بَنِيكَ وَغَنَمُكَ وَبَقَرُكَ وَكُلُّ مَا لَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","وَأَعُولُكَ هُنَاكَ، لِأَنَّهُ يَكُونُ أَيْضًا خَمْسُ سِنِينَ جُوعًا. لِئَلَّا تَفْتَقِرَ أَنْتَ وَبَيْتُكَ وَكُلُّ مَا لَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","وَهُوَذَا عْيُونُكُمْ تَرَى، وَعَيْنَا أَخِي بَنْيَامِينَ، أَنَّ فَمِي هُوَ ٱلَّذِي يُكَلِّمُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","وَتُخْبِرُونَ أَبِي بِكُلِّ مَجْدِي فِي مِصْرَ وَبِكُلِّ مَا رَأَيْتُمْ، وَتَسْتَعْجِلُونَ وَتَنْزِلُونَ بِأَبِي إِلَى هُنَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ثُمَّ وَقَعَ عَلَى عُنُقِ بَنْيَامِينَ أَخِيهِ وَبَكَى، وَبَكَى بَنْيَامِينُ عَلَى عُنُقِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","وَقَبَّلَ جَمِيعَ إِخْوَتِهِ وَبَكَى عَلَيْهِمْ. وَبَعْدَ ذَلِكَ تَكَلَّمَ إِخْوَتُهُ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","وَسُمِعَ ٱلْخَبَرُ فِي بَيْتِ فِرْعَوْنَ، وَقِيلَ: «جَاءَ إِخْوَةُ يُوسُفَ». فَحَسُنَ فِي عَيْنَيْ فِرْعَوْنَ وَفِي عُيُونِ عَبِيدِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","فَقَالَ فِرْعَوْنُ لِيُوسُفَ: «قُلْ لِإِخْوَتِكَ: ٱفْعَلُوا هَذَا: حَمِّلُوا دَوَابَّكُمْ وَٱنْطَلِقُوا، ٱذْهَبُوا إِلَى أَرْضِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","وَخُذُوا أَبَاكُمْ وَبُيُوتَكُمْ وَتَعَالَوْا إِلَيَّ، فَأُعْطِيَكُمْ خَيْرَاتِ أَرْضِ مِصْرَ وَتَأْكُلُوا دَسَمَ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","فَأَنْتَ قَدْ أُمِرْتَ، ٱفْعَلُوا هَذَا: خُذُوا لَكُمْ مِنْ أَرْضِ مِصْرَ عَجَلَاتٍ لِأَوْلَادِكُمْ وَنِسَائِكُمْ، وَٱحْمِلُوا أَبَاكُمْ وَتَعَالَوْا. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","وَلَا تَحْزَنْ عُيُونُكُمْ عَلَى أَثَاثِكُمْ، لِأَنَّ خَيْرَاتِ جَمِيعِ أَرْضِ مِصْرَ لَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","فَفَعَلَ بَنُو إِسْرَائِيلَ هَكَذَا. وَأَعْطَاهُمْ يُوسُفُ عَجَلَاتٍ بِحَسَبِ أَمْرِ فِرْعَوْنَ، وَأَعْطَاهُمْ زَادًا لِلطَّرِيقِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","وَأَعْطَى كُلَّ وَاحِدٍ مِنْهُمْ حُلَلَ ثِيَابٍ، وَأَمَّا بَنْيَامِينُ فَأَعْطَاهُ ثَلَاثَ مِئَةٍ مِنَ ٱلْفِضَّةِ وَخَمْسَ حُلَلِ ثِيَابٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","وَأَرْسَلَ لِأَبِيهِ هَكَذَا: عَشْرَةَ حَمِيرٍ حَامِلَةً مِنْ خَيْرَاتِ مِصْرَ، وَعَشَرَ أُتُنٍ حَامِلَةً حِنْطَةً، وَخُبْزًا وَطَعَامًا لِأَبِيهِ لِأَجْلِ ٱلطَّرِيقِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ثُمَّ صَرَفَ إِخْوَتَهُ فَٱنْطَلَقُوا، وَقَالَ لَهُمْ: «لَا تَتَغَاضَبُوا فِي ٱلطَّرِيقِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","فَصَعِدُوا مِنْ مِصْرَ وَجَاءُوا إِلَى أَرْضِ كَنْعَانَ، إِلَى يَعْقُوبَ أَبِيهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","وَأَخْبَرُوهُ قَائِلِينَ: «يُوسُفُ حَيٌّ بَعْدُ، وَهُوَ مُتَسَلِّطٌ عَلَى كُلِّ أَرْضِ مِصْرَ». فَجَمَدَ قَلْبُهُ لِأَنَّهُ لَمْ يُصَدِّقْهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ثُمَّ كَلَّمُوهُ بِكُلِّ كَلَامِ يُوسُفَ ٱلَّذِي كَلَّمَهُمْ بِهِ، وَأَبْصَرَ ٱلْعَجَلَاتِ ٱلَّتِي أَرْسَلَهَا يُوسُفُ لِتَحْمِلَهُ. فَعَاشَتْ رُوحُ يَعْقُوبَ أَبِيهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","فَقَالَ إِسْرَائِيلُ: «كَفَى! يُوسُفُ ٱبْنِي حَيٌّ بَعْدُ. أَذْهَبُ وَأَرَاهُ قَبْلَ أَنْ أَمُوتَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","فَٱرْتَحَلَ إِسْرَائِيلُ وَكُلُّ مَا كَانَ لَهُ وَأَتَى إِلَى بِئْرِ سَبْعٍ، وَذَبَحَ ذَبَائِحَ لإِلَهِ أَبِيهِ إِسْحَاقَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","فَكَلَّمَ ٱللهُ إِسْرَائِيلَ فِي رُؤَى ٱللَّيْلِ وَقَالَ: «يَعْقُوبُ، يَعْقُوبُ!». فَقَالَ: «هَأَنَذَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","فَقَالَ: «أَنَا ٱللهُ، إِلَهُ أَبِيكَ. لَا تَخَفْ مِنَ ٱلنُّزُولِ إِلَى مِصْرَ، لِأَنِّي أَجْعَلُكَ أُمَّةً عَظِيمَةً هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","أَنَا أَنْزِلُ مَعَكَ إِلَى مِصْرَ، وَأَنَا أُصْعِدُكَ أَيْضًا. وَيَضَعُ يُوسُفُ يَدَهُ عَلَى عَيْنَيْكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","فَقَامَ يَعْقُوبُ مِنْ بِئْرِ سَبْعٍ، وَحَمَلَ بَنُو إِسْرَائِيلَ يَعْقُوبَ أَبَاهُمْ وَأَوْلَادَهُمْ وَنِسَاءَهُمْ فِي ٱلْعَجَلَاتِ ٱلَّتِي أَرْسَلَ فِرْعَوْنُ لِحَمْلِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","وَأَخَذُوا مَوَاشِيَهُمْ وَمُقْتَنَاهُمُ ٱلَّذِي ٱقْتَنَوْا فِي أَرْضِ كَنْعَانَ، وَجَاءُوا إِلَى مِصْرَ. يَعْقُوبُ وَكُلُّ نَسْلِهِ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","بَنُوهُ وَبَنُو بَنِيهِ مَعَهُ، وَبَنَاتُهُ وَبَنَاتُ بَنِيهِ وَكُلُّ نَسْلِهِ، جَاءَ بِهِمْ مَعَهُ إِلَى مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","وَهَذِهِ أَسْمَاءُ بَنِي إِسْرَائِيلَ ٱلَّذِينَ جَاءُوا إِلَى مِصْرَ: يَعْقُوبُ وَبَنُوهُ. بِكْرُ يَعْقُوبَ رَأُوبَيْنُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","وَبَنُو رَأُوبَيْنَ: حَنُوكُ وَفَلُّو وَحَصْرُونُ وَكَرْمِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","وَبَنُو شِمْعُونَ: يَمُوئِيلُ وَيَامِينُ وَأُوهَدُ وَيَاكِينُ وَصُوحَرُ وَشَأُولُ ٱبْنُ ٱلْكَنْعَانِيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","وَبَنُو لَاوِي: جِرْشُونُ وَقَهَاتُ وَمَرَارِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","وَبَنُو يَهُوذَا: عِيرٌ وَأُونَانُ وَشِيلَةُ وَفَارَصُ وَزَارَحُ. وَأَمَّا عِيرٌ وَأُونَانُ فَمَاتَا فِي أَرْضِ كَنْعَانَ. وَكَانَ ٱبْنَا فَارَصَ: حَصْرُونَ وَحَامُولَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","وَبَنُو يَسَّاكَرَ: تُولَاعُ وَفَوَّةُ وَيُوبُ وَشِمْرُونُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","وَبَنُو زَبُولُونَ: سَارَدُ وَإِيلُونُ وَيَاحَلْئِيلُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","هَؤُلَاءِ بَنُو لَيْئَةَ ٱلَّذِينَ وَلَدَتْهُمْ لِيَعْقُوبَ فِي فَدَّانَ أَرَامَ مَعَ دِينَةَ ٱبْنَتِهِ. جَمِيعُ نُفُوسِ بَنِيهِ وَبَنَاتِهِ ثَلَاثٌ وَثَلَاثُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","وَبَنُو جَادَ: صِفْيُونُ وَحَجِّي وَشُونِي وَأَصْبُونُ وَعِيرِي وَأَرُودِي وَأَرْئِيلِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","وَبَنُو أَشِيرَ: يِمْنَةُ وَيِشْوَةُ وَيِشْوِي وَبَرِيعَةُ، وَسَارَحُ هِيَ أُخْتُهُمْ. وَٱبْنَا بَرِيعَةَ: حَابِرُ وَمَلْكِيئِيلُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","هَؤُلَاءِ بَنُو زِلْفَةَ ٱلَّتِي أَعْطَاهَا لَابَانُ لِلَيْئَةَ ٱبْنَتِهِ، فَوَلَدَتْ هَؤُلَاءِ لِيَعْقُوبَ، سِتَّ عَشَرَةَ نَفْسًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","اِبْنَا رَاحِيلَ ٱمْرَأَةِ يَعْقُوبَ: يُوسُفُ وَبَنْيَامِينُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","وَوُلِدَ لِيُوسُفَ فِي أَرْضِ مِصْرَ: مَنَسَّى وَأَفْرَايِمُ، ٱللَّذَانِ وَلَدَتْهُمَا لَهُ أَسْنَاتُ بِنْتُ فُوطِي فَارَعَ كَاهِنِ أُونٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","وَبَنُو بَنْيَامِينَ: بَالَعُ وَبَاكَرُ وَأَشْبِيلُ وَجِيرَا وَنَعْمَانُ وَإِيحِي وَرُوشُ وَمُفِّيمُ وَحُفِّيمُ وَأَرْدُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","هَؤُلَاءِ بَنُو رَاحِيلَ ٱلَّذِينَ وُلِدُوا لِيَعْقُوبَ. جَمِيعُ ٱلنُّفُوسِ أَرْبَعَ عَشَرَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","وَٱبْنُ دَانَ: حُوشِيمُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","وَبَنُو نَفْتَالِي: يَاحَصْئِيلُ وَجُونِي وَيِصْرُ وَشِلِّيمُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","هَؤُلَاءِ بَنُو بِلْهَةَ ٱلَّتِي أَعْطَاهَا لَابَانُ لِرَاحِيلَ ٱبْنَتِهِ. فَوَلَدَتْ هَؤُلَاءِ لِيَعْقُوبَ. جَمِيعُ ٱلْأَنْفُسِ سَبْعٌ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","جَمِيعُ ٱلنُّفُوسِ لِيَعْقُوبَ ٱلَّتِي أَتَتْ إِلَى مِصْرَ، ٱلْخَارِجَةِ مِنْ صُلْبِهِ، مَا عَدَا نِسَاءَ بَنِي يَعْقُوبَ، جَمِيعُ ٱلنُّفُوسِ سِتٌّ وَسِتُّونَ نَفْسًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","وَٱبْنَا يُوسُفَ ٱللَّذَانِ وُلِدَا لَهُ فِي مِصْرَ نَفْسَانِ. جَمِيعُ نُفُوسِ بَيْتِ يَعْقُوبَ ٱلَّتِي جَاءَتْ إِلَى مِصْرَ سَبْعُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","فَأَرْسَلَ يَهُوذَا أَمَامَهُ إِلَى يُوسُفَ لِيُرِيَ ٱلطَّرِيقَ أَمَامَهُ إِلَى جَاسَانَ، ثُمَّ جَاءُوا إِلَى أَرْضِ جَاسَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","فَشَدَّ يُوسُفُ مَرْكَبَتَهُ وَصَعِدَ لِٱسْتِقْبَالِ إِسْرَائِيلَ أَبِيهِ إِلَى جَاسَانَ. وَلَمَّا ظَهَرَ لَهُ وَقَعَ عَلَى عُنُقِهِ وَبَكَى عَلَى عُنُقِهِ زَمَانًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","فَقَالَ إِسْرَائِيلُ لِيُوسُفَ: «أَمُوتُ ٱلْآنَ بَعْدَ مَا رَأَيْتُ وَجْهَكَ أَنَّكَ حَيٌّ بَعْدُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ثُمَّ قَالَ يُوسُفُ لِإِخْوَتِهِ وَلِبَيْتِ أَبِيهِ: «أَصْعَدُ وَأُخْبِرُ فِرْعَوْنَ وَأَقُولُ لَهُ: إِخْوَتِي وَبَيْتُ أَبِي ٱلَّذِينَ فِي أَرْضِ كَنْعَانَ جَاءُوا إِلَيَّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","وَٱلرِّجَالُ رُعَاةُ غَنَمٍ، فَإِنَّهُمْ كَانُوا أَهْلَ مَوَاشٍ، وَقَدْ جَاءُوا بِغَنَمِهِمْ وَبَقَرِهِمْ وَكُلِّ مَا لَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","فَيَكُونُ إِذَا دَعَاكُمْ فِرْعَوْنُ وَقَالَ: مَا صِنَاعَتُكُمْ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","أَنْ تَقُولُوا: عَبِيدُكَ أَهْلُ مَوَاشٍ مُنْذُ صِبَانَا إِلَى ٱلْآنَ، نَحْنُ وَآبَاؤُنَا جَمِيعًا. لِكَيْ تَسْكُنُوا فِي أَرْضِ جَاسَانَ. لِأَنَّ كُلَّ رَاعِي غَنَمٍ رِجْسٌ لِلْمِصْرِيِّينَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","فَأَتَى يُوسُفُ وَأَخبَرَ فِرْعَوْنَ وَقَالَ: «أَبِي وَإِخْوَتِي وَغَنَمُهُمْ وَبَقَرُهُمْ وَكُلُّ مَا لَهُمْ جَاءُوا مِنْ أَرْضِ كَنْعَانَ، وَهُوَذَا هُمْ فِي أَرْضِ جَاسَانَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","وَأَخَذَ مِنْ جُمْلَةِ إِخْوَتِهِ خَمْسَةَ رِجَالٍ وَأَوْقَفَهُمْ أَمَامَ فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","فَقَالَ فِرْعَوْنُ لِإِخْوَتِهِ: «مَا صِنَاعَتُكُمْ؟» فَقَالُوا لِفِرْعَوْنَ: «عَبِيدُكَ رُعَاةُ غَنَمٍ نَحْنُ وَآبَاؤُنَا جَمِيعًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","وَقَالُوا لِفِرْعَوْنَ: «جِئْنَا لِنَتَغَرَّبَ فِي ٱلْأَرْضِ، إِذْ لَيْسَ لِغَنَمِ عَبِيدِكَ مَرْعًى، لِأَنَّ ٱلْجُوعَ شَدِيدٌ فِي أَرْضِ كَنْعَانَ. فَٱلْآنَ لِيَسْكُنْ عَبِيدُكَ فِي أَرْضِ جَاسَانَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","فَكَلَّمَ فِرْعَوْنُ يُوسُفَ قَائِلًا: «أَبُوكَ وَإِخْوَتُكَ جَاءُوا إِلَيْكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","أَرْضُ مِصْرَ قُدَّامَكَ. فِي أَفْضَلِ ٱلْأَرْضِ أَسْكِنْ أَبَاكَ وَإِخْوَتَكَ، لِيَسْكُنُوا فِي أَرْضِ جَاسَانَ. وَإِنْ عَلِمْتَ أَنَّهُ يُوجَدُ بَيْنَهُمْ ذَوُو قُدْرَةٍ، فَٱجْعَلْهُمْ رُؤَسَاءَ مَوَاشٍ عَلَى ٱلَّتِي لِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ثُمَّ أَدْخَلَ يُوسُفُ يَعْقُوبَ أَبَاهُ وَأَوْقَفَهُ أَمَامَ فِرْعَوْنَ. وَبَارَكَ يَعْقُوبُ فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","فَقَالَ فِرْعَوْنُ لِيَعْقُوبَ: «كَمْ هِيَ أَيَّامُ سِنِي حَيَاتِكَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","فَقَالَ يَعْقُوبُ لِفِرْعَوْنَ: «أَيَّامُ سِنِي غُرْبَتِي مِئَةٌ وَثَلَاثُونَ سَنَةً. قَلِيلَةً وَ رَدِيَّةً كَانَتْ أَيَّامُ سِنِي حَيَاتِي، وَلَمْ تَبْلُغْ إِلَى أَيَّامِ سِنِي حَيَاةِ آبَائِي فِي أَيَّامِ غُرْبَتِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","وَبَارَكَ يَعْقُوبُ فِرْعَوْنَ وَخَرَجَ مِنْ لَدُنْ فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","فَأَسْكَنَ يُوسُفُ أَبَاهُ وَإِخْوَتَهُ وَأَعْطَاهُمْ مُلْكًا فِي أَرْضِ مِصْرَ، فِي أَفْضَلِ ٱلْأَرْضِ، فِي أَرْضِ رَعَمْسِيسَ كَمَا أَمَرَ فِرْعَوْنُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","وَعَالَ يُوسُفُ أَبَاهُ وَإِخْوَتَهُ وَكُلَّ بَيْتِ أَبِيهِ بِطَعَامٍ عَلَى حَسَبِ ٱلْأَوْلَادِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","وَلَمْ يَكُنْ خُبْزٌ فِي كُلِّ ٱلْأَرْضِ، لِأَنَّ ٱلْجُوعَ كَانَ شَدِيدًا جِدًّا. فَخَوَّرَتْ أَرْضُ مِصْرَ وَأَرْضُ كَنْعَانَ مِنْ أَجْلِ ٱلْجُوعِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","فَجَمَعَ يُوسُفُ كُلَّ ٱلْفِضَّةِ ٱلْمَوْجُودَةِ فِي أَرْضِ مِصْرَ وَفِي أَرْضِ كَنْعَانَ بِٱلْقَمْحِ ٱلَّذِي ٱشْتَرُوا، وَجَاءَ يُوسُفُ بِٱلْفِضَّةِ إِلَى بَيْتِ فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","فَلَمَّا فَرَغَتِ ٱلْفِضَّةُ مِنْ أَرْضِ مِصْرَ وَمِنْ أَرْضِ كَنْعَانَ أَتَى جَمِيعُ ٱلْمِصْرِيِّينَ إِلَى يُوسُفَ قَائِلِينَ: «أَعْطِنَا خُبْزًا، فَلِمَاذَا نَمُوتُ قُدَّامَكَ؟ لِأَنْ لَيْسَ فِضَّةٌ أَيْضًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","فَقَالَ يُوسُفُ: «هَاتُوا مَوَاشِيَكُمْ فَأُعْطِيَكُمْ بِمَوَاشِيكُمْ، إِنْ لَمْ يَكُنْ فِضَّةٌ أَيْضًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","فَجَاءُوا بِمَوَاشِيهِمْ إِلَى يُوسُفَ، فَأَعْطَاهُمْ يُوسُفُ خُبْزًا بِٱلْخَيْلِ وَبِمَوَاشِي ٱلْغَنَمِ وَٱلْبَقَرِ وَبِٱلْحَمِيرِ. فَقَاتَهُمْ بِٱلْخُبْزِ تِلْكَ ٱلسَّنَةَ بَدَلَ جَمِيعِ مَوَاشِيهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","وَلَمَّا تَمَّتْ تِلْكَ ٱلسَّنَةُ أَتَوْا إِلَيْهِ فِي ٱلسَّنَةِ ٱلْثَّانِيَةِ وَقَالُوا لَهُ: «لَا نُخْفِي عَنْ سَيِّدِي أَنَّهُ إِذْ قَدْ فَرَغَتِ ٱلْفِضَّةُ، وَمَوَاشِي ٱلْبَهَائِمِ عِنْدَ سَيِّدِي، لَمْ يَبْقَ قُدَّامَ سَيِّدِي إِلَا أَجْسَادُنَا وَأَرْضُنَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","لِمَاذَا نَمُوتُ أَمَامَ عَيْنَيْكَ نَحْنُ وَأَرْضُنَا جَمِيعًا؟ اِشْتَرِنَا وَأَرْضَنَا بِٱلْخُبْزِ، فَنَصِيرَ نَحْنُ وَأَرْضُنَا عَبِيدًا لِفِرْعَوْنَ، وَأَعْطِ بِذَارًا لِنَحْيَا وَلَا نَمُوتَ وَلَا تَصِيرَ أَرْضُنَا قَفْرًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","فَٱشْتَرَى يُوسُفُ كُلَّ أَرْضِ مِصْرَ لِفِرْعَوْنَ، إِذْ بَاعَ ٱلْمِصْرِيُّونَ كُلُّ وَاحِدٍ حَقْلَهُ، لِأَنَّ ٱلْجُوعَ ٱشْتَدَّ عَلَيْهِمْ. فَصَارَتِ ٱلْأَرْضُ لِفِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","وَأَمَّا ٱلشَّعْبُ فَنَقَلَهُمْ إِلَى ٱلْمُدُنِ مِنْ أَقْصَى حَدِّ مِصْرَ إِلَى أَقْصَاهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","إِلَا إِنَّ أَرْضَ ٱلْكَهَنَةِ لَمْ يَشْتَرِهَا، إِذْ كَانَتْ لِلْكَهَنَةِ فَرِيضَةٌ مِنْ قِبَلِ فِرْعَوْنَ، فَأَكَلُوا فَرِيضَتَهُمُ ٱلَّتِي أَعْطَاهُمْ فِرْعَوْنُ، لِذَلِكَ لَمْ يَبِيعُوا أَرْضَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","فَقَالَ يُوسُفُ لِلشَّعْبِ: «إِنِّي قَدِ ٱشْتَرَيْتُكُمُ ٱلْيَوْمَ وَأَرْضَكُمْ لِفِرْعَوْنَ. هُوَذَا لَكُمْ بِذَارٌ فَتَزْرَعُونَ ٱلْأَرْضَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","وَيَكُونُ عِنْدَ ٱلْغَلَّةِ أَنَّكُمْ تُعْطُونَ خُمْسًا لِفِرْعَوْنَ، وَٱلْأَرْبَعَةُ ٱلْأَجْزَاءُ تَكُونُ لَكُمْ بِذَارًا لِلْحَقْلِ، وَطَعَامًا لَكُمْ وَلِمَنْ فِي بْيُوتِكُمْ، وَطَعَامًا لِأَوْلَادِكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","فَقَالُوا: «أَحْيَيْتَنَا. لَيْتَنَا نَجِدُ نِعْمَةً فِي عَيْنَيْ سَيِّدِي فَنَكُونَ عَبِيدًا لِفِرْعَوْنَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","فَجَعَلَهَا يُوسُفُ فَرْضًا عَلَى أَرْضِ مِصْرَ إِلَى هَذَا ٱلْيَوْمِ: لِفِرْعَوْنَ ٱلْخُمْسُ. إِلَا إِنَّ أَرْضَ ٱلْكَهَنَةِ وَحْدَهُمْ لَمْ تَصِرْ لِفِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","وَسَكَنَ إِسْرَائِيلُ فِي أَرْضِ مِصْرَ، فِي أَرْضِ جَاسَانَ، وَتَمَلَّكُوا فِيهَا وَأَثْمَرُوا وَكَثُرُوا جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","وَعَاشَ يَعْقُوبُ فِي أَرْضِ مِصْرَ سَبْعَ عَشَرَةَ سَنَةً. فَكَانَتْ أَيَّامُ يَعْقُوبَ، سِنُو حَيَاتِهِ مِئَةً وَسَبْعًا وَأَرْبَعِينَ سَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","وَلَمَّا قَرُبَتْ أَيَّامُ إِسْرَائِيلَ أَنْ يَمُوتَ دَعَا ٱبْنَهُ يُوسُفَ وَقَالَ لَهُ: «إِنْ كُنْتُ قَدْ وَجَدْتُ نِعْمَةً فِي عَيْنَيْكَ فَضَعْ يَدَكَ تَحْتَ فَخْذِي وَٱصْنَعْ مَعِي مَعْرُوفًا وَأَمَانَةً: لَا تَدْفِنِّي فِي مِصْرَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","بَلْ أَضْطَجِعُ مَعَ آبَائِي، فَتَحْمِلُنِي مِنْ مِصْرَ وَتَدْفِنُنِي فِي مَقْبَرَتِهِمْ». فَقَالَ: «أَنَا أَفْعَلُ بِحَسَبِ قَوْلِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","فَقَالَ: «ٱحْلِفْ لِي». فَحَلَفَ لَهُ. فَسَجَدَ إِسْرَائِيلُ عَلَى رَأْسِ ٱلسَّرِيرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","وَحَدَثَ بَعْدَ هَذِهِ ٱلْأُمُورِ أَنَّهُ قِيلَ لِيُوسُفَ: «هُوَذَا أَبُوكَ مَرِيضٌ». فَأَخَذَ مَعَهُ ٱبْنَيْهِ مَنَسَّى وَأَفْرَايِمَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","فَأُخْبِرَ يَعْقُوبُ وَقِيلَ لَهُ: «هُوَذَا ٱبْنُكَ يُوسُفُ قَادِمٌ إِلَيْكَ». فَتَشَدَّدَ إِسْرَائِيلُ وَجَلَسَ عَلَى ٱلسَّرِيرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","وَقَالَ يَعْقُوبُ لِيُوسُفَ: «ٱللهُ ٱلْقَادِرُ عَلَى كُلِّ شَيْءٍ ظَهَرَ لِي فِي لُوزَ، فِي أَرْضِ كَنْعَانَ، وَبَارَكَنِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","وَقَالَ لِي: هَا أَنَا أَجْعَلُكَ مُثْمِرًا وَأُكَثِّرُكَ، وَأَجْعَلُكَ جُمْهُورًا مِنَ ٱلْأُمَمِ، وَأُعْطِي نَسْلَكَ هَذِهِ ٱلْأَرْضَ مِنْ بَعْدِكَ مُلْكًا أَبَدِيًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","وَٱلْآنَ ٱبْنَاكَ ٱلْمَوْلُودَانِ لَكَ فِي أَرْضِ مِصْرَ، قَبْلَمَا أَتَيْتُ إِلَيْكَ إِلَى مِصْرَ هُمَا لِي. أَفْرَايِمُ وَمَنَسَّى كَرَأُوبَيْنَ وَشِمْعُونَ يَكُونَانِ لِي. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","وَأَمَّا أَوْلَادُكَ ٱلَّذِينَ تَلِدُ بَعْدَهُمَا فَيَكُونُونَ لَكَ. عَلَى ٱسْمِ أَخَوَيْهِمْ يُسَمَّوْنَ فِي نَصِيبِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","وَأَنَا حِينَ جِئْتُ مِنْ فَدَّانَ مَاتَتْ عِنْدِي رَاحِيلُ فِي أَرْضِ كَنْعَانَ فِي ٱلطَّرِيقِ، إِذْ بَقِيَتْ مَسَافَةٌ مِنَ ٱلْأَرْضِ حَتَّى آتِيَ إِلَى أَفْرَاتَةَ، فَدَفَنْتُهَا هُنَاكَ فِي طَرِيقِ أَفْرَاتَةَ، ٱلَّتِي هِيَ بَيْتُ لَحْمٍ». ");
INSERT INTO arb_vd_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","وَرَأَى إِسْرَائِيلُ ٱبْنَيْ يُوسُفَ فَقَالَ: «مَنْ هَذَانِ؟». ");
INSERT INTO arb_vd_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","فَقَالَ يُوسُفُ لِأَبِيهِ: «هُمَا ٱبْنَايَ ٱللَّذَانِ أَعْطَانِيَ ٱللهُ هَهُنَا». فَقَالَ: «قَدِّمْهُمَا إِلَيَّ لِأُبَارِكَهُمَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","وَأَمَّا عَيْنَا إِسْرَائِيلَ فَكَانَتَا قَدْ ثَقُلَتَا مِنَ ٱلشَّيْخُوخَةِ، لَا يَقْدِرُ أَنْ يُبْصِرَ، فَقَرَّبَهُمَا إِلَيْهِ فَقَبَّلَهُمَا وَٱحْتَضَنَهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","وَقَالَ إِسْرَائِيلُ لِيُوسُفَ: «لَمْ أَكُنْ أَظُنُّ أَنِّي أَرَى وَجْهَكَ، وَهُوَذَا ٱللهُ قَدْ أَرَانِي نَسْلَكَ أَيْضًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ثُمَّ أَخْرَجَهُمَا يُوسُفُ مِنْ بَيْنَ رُكْبَتَيْهِ وَسَجَدَ أَمَامَ وَجْهِهِ إِلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","وَأَخَذَ يُوسُفُ ٱلِٱثْنَيْنِ أَفْرَايِمَ بِيَمِينِهِ عَنْ يَسَارِ إِسْرَائِيلَ، وَمَنَسَّى بِيَسَارِهِ عَنْ يَمِينِ إِسْرَائِيلَ وَقَرَّبَهُمَا إِلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","فَمَدَّ إِسْرَائِيلُ يَمِينَهُ وَوَضَعَهَا عَلَى رَأْسِ أَفْرَايِمَ وَهُوَ ٱلصَّغِيرُ، وَيَسَارَهُ عَلَى رَأْسِ مَنَسَّى. وَضَعَ يَدَيْهِ بِفِطْنَةٍ فَإِنَّ مَنَسَّى كَانَ ٱلْبِكْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","وَبَارَكَ يُوسُفَ وَقَالَ: «ٱللهُ ٱلَّذِي سَارَ أَمَامَهُ أَبَوَايَ إِبْرَاهِيمُ وَإِسْحَاقُ، ٱللهُ ٱلَّذِي رَعَانِي مُنْذُ وُجُودِي إِلَى هَذَا ٱلْيَوْمِ، ");
INSERT INTO arb_vd_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ٱلْمَلَاكُ ٱلَّذِي خَلَّصَنِي مِنْ كُلِّ شَرٍّ، يُبَارِكُ ٱلْغُلَامَيْنِ. وَلْيُدْعَ عَلَيْهِمَا ٱسْمِي وَٱسْمُ أَبَوَيَّ إِبْرَاهِيمَ وَإِسْحَاقَ، وَلْيَكْثُرَا كَثِيرًا فِي ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","فَلَمَّا رَأَى يُوسُفُ أَنَّ أَبَاهُ وَضَعَ يَدَهُ ٱلْيُمْنَى عَلَى رَأْسِ أَفْرَايِمَ، سَاءَ ذَلِكَ فِي عَيْنَيْهِ، فَأَمْسَكَ بِيَدِ أَبِيهِ لِيَنْقُلَهَا عَنْ رَأْسِ أَفْرَايِمَ إِلَى رَأْسِ مَنَسَّى. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","وَقَالَ يُوسُفُ لِأَبِيهِ: «لَيْسَ هَكَذَا يَا أَبِي، لِأَنَّ هَذَا هُوَ ٱلْبِكْرُ. ضَعْ يَمِينَكَ عَلَى رَأْسِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","فَأَبَى أَبُوهُ وَقَالَ: «عَلِمْتُ يَا ٱبْنِي، عَلِمْتُ. هُوَ أَيْضًا يَكُونُ شَعْبًا، وَهُوَ أَيْضًا يَصِيرُ كَبِيرًا. وَلَكِنَّ أَخَاهُ ٱلصَّغِيرَ يَكُونُ أَكْبَرَ مِنْهُ، وَنَسْلُهُ يَكُونُ جُمْهُورًا مِنَ ٱلْأُمَمِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","وَبَارَكَهُمَا فِي ذَلِكَ ٱلْيَوْمِ قَائِلًا: «بِكَ يُبَارِكُ إِسْرَائِيلُ قَائِلًا: يَجْعَلُكَ ٱللهُ كَأَفْرَايِمَ وَكَمَنَسَّى». فَقَدَّمَ أَفْرَايِمَ عَلَى مَنَسَّى. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","وَقَالَ إِسْرَائِيلُ لِيُوسُفَ: «هَا أَنَا أَمُوتُ، وَلَكِنَّ ٱللهَ سَيَكُونُ مَعَكُمْ وَيَرُدُّكُمْ إِلَى أَرْضِ آبَائِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","وَأَنَا قَدْ وَهَبْتُ لَكَ سَهْمًا وَاحِدًا فَوْقَ إِخْوَتِكَ، أَخَذْتُهُ مِنْ يَدِ ٱلْأَمُورِيِّينَ بِسَيْفِي وَقَوْسِي». ");
INSERT INTO arb_vd_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","وَدَعَا يَعْقُوبُ بَنِيهِ وَقَالَ: «ٱجْتَمِعُوا لِأُنْبِئَكُمْ بِمَا يُصِيبُكُمْ فِي آخِرِ ٱلْأَيَّامِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ٱجْتَمِعُوا وَٱسْمَعُوا يَا بَنِي يَعْقُوبَ، وَٱصْغَوْا إِلَى إِسْرَائِيلَ أَبِيكُمْ: ");
INSERT INTO arb_vd_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","رَأُوبَيْنُ، أَنْتَ بِكْرِي، قُوَّتِي وَأَوَّلُ قُدْرَتِي، فَضْلُ ٱلرِّفْعَةِ وَفَضْلُ ٱلْعِزِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","فَائِرًا كَٱلْمَاءِ لَا تَتَفَضَّلُ، لِأَنَّكَ صَعِدْتَ عَلَى مَضْجَعِ أَبِيكَ. حِينَئِذٍ دَنَّسْتَهُ. عَلَى فِرَاشِي صَعِدَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","شِمْعُونُ وَلَاوِي أَخَوَانِ، آلَاتُ ظُلْمٍ سُيُوفُهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","فِي مَجْلِسِهِمَا لَا تَدْخُلُ نَفْسِي. بِمَجْمَعِهِمَا لَا تَتَّحِدُ كَرَامَتِي. لِأَنَّهُمَا فِي غَضَبِهِمَا قَتَلَا إِنْسَانًا، وَفِي رِضَاهُمَا عَرْقَبَا ثَوْرًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","مَلْعُونٌ غَضَبُهُمَا فَإِنَّهُ شَدِيدٌ، وَسَخَطُهُمَا فَإِنَّهُ قَاسٍ. أُقَسِّمُهُمَا فِي يَعْقُوبَ، وَأُفَرِّقُهُمَا فِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","يَهُوذَا، إِيَّاكَ يَحْمَدُ إِخْوَتُكَ، يَدُكَ عَلَى قَفَا أَعْدَائِكَ، يَسْجُدُ لَكَ بَنُو أَبِيكَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","يَهُوذَا جَرْوُ أَسَدٍ، مِنْ فَرِيسَةٍ صَعِدْتَ يَا ٱبْنِي، جَثَا وَرَبَضَ كَأَسَدٍ وَكَلَبْوَةٍ. مَنْ يُنْهِضُهُ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","لَا يَزُولُ قَضِيبٌ مِنْ يَهُوذَا وَمُشْتَرِعٌ مِنْ بَيْنِ رِجْلَيْهِ حَتَّى يَأْتِيَ شِيلُونُ وَلَهُ يَكُونُ خُضُوعُ شُعُوبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","رَابِطًا بِٱلْكَرْمَةِ جَحْشَهُ، وَبِالْجَفْنَةِ ٱبْنَ أَتَانِهِ، غَسَلَ بِٱلْخَمْرِ لِبَاسَهُ، وَبِدَمِ ٱلْعِنَبِ ثَوْبَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","مُسْوَدُّ ٱلْعَيْنَيْنِ مِنَ ٱلْخَمْرِ، وَمُبْيَضُّ ٱلْأَسْنَانِ مِنَ ٱللَّبَنِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","زَبُولُونُ، عِنْدَ سَاحِلِ ٱلْبَحْرِ يَسْكُنُ، وَهُوَ عِنْدَ سَاحِلِ ٱلسُّفُنِ، وَجَانِبُهُ عِنْدَ صَيْدُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","يَسَّاكَرُ، حِمَارٌ جَسِيمٌ رَابِضٌ بَيْنَ ٱلْحَظَائِرِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","فَرَأَى ٱلْمَحَلَّ أَنَّهُ حَسَنٌ، وَٱلْأَرْضَ أَنَّهَا نَزِهَةٌ، فَأَحْنَى كَتِفَهُ لِلْحِمْلِ وَصَارَ لِلْجِزْيَةِ عَبْدًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","دَانُ، يَدِينُ شَعْبَهُ كَأَحَدِ أَسْبَاطِ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","يَكُونُ دَانُ حَيَّةً عَلَى ٱلطَّرِيقِ، أُفْعُوانًا عَلَى ٱلسَّبِيلِ، يَلْسَعُ عَقِبَيِ ٱلْفَرَسِ فَيَسْقُطُ رَاكِبُهُ إِلَى ٱلْوَرَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","لِخَلَاصِكَ ٱنْتَظَرْتُ يَا رَبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","جَادُ، يَزْحَمُهُ جَيْشٌ، وَلَكِنَّهُ يَزْحَمُ مُؤَخَّرَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","أَشِيرُ، خُبْزُهُ سَمِينٌ وَهُوَ يُعْطِي لَذَّاتِ مُلُوكٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","نَفْتَالِي، أَيِّلَةٌ مُسَيَّبَةٌ يُعْطِي أَقْوَالًا حَسَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","يُوسُفُ، غُصْنُ شَجَرَةٍ مُثْمِرَةٍ، غُصْنُ شَجَرَةٍ مُثْمِرَةٍ عَلَى عَيْنٍ. أَغْصَانٌ قَدِ ٱرْتَفَعَتْ فَوْقَ حَائِطٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","فَمَرَّرَتْهُ وَرَمَتْهُ وَٱضْطَهَدَتْهُ أَرْبَابُ ٱلسِّهَامِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","وَلَكِنْ ثَبَتَتْ بِمَتَانَةٍ قَوْسُهُ، وَتَشَدَّدَتْ سَوَاعِدُ يَدَيْهِ. مِنْ يَدَيْ عَزِيزِ يَعْقُوبَ، مِنْ هُنَاكَ، مِنَ ٱلرَّاعِي صَخْرِ إِسْرَائِيلَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","مِنْ إِلَهِ أَبِيكَ ٱلَّذِي يُعِينُكَ، وَمِنَ ٱلْقَادِرِ عَلَى كُلِّ شَيْءٍ ٱلَّذِي يُبَارِكُكَ، تَأْتِي بَرَكَاتُ ٱلسَّمَاءِ مِنْ فَوْقُ، وَبَرَكَاتُ ٱلْغَمْرِ ٱلرَّابِضِ تَحْتُ. بَرَكَاتُ ٱلثَّدْيَيْنِ وَٱلرَّحِمِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","بَرَكَاتُ أَبِيكَ فَاقَتْ عَلَى بَرَكَاتِ أَبَوَيَّ. إِلَى مُنْيَةِ ٱلْآكَامِ ٱلدَّهْرِيَّةِ تَكُونُ عَلَى رَأْسِ يُوسُفَ، وَعَلَى قِمَّةِ نَذِيرِ إِخْوَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","بَنْيَامِينُ ذِئْبٌ يَفْتَرِسُ. فِي ٱلصَّبَاحِ يَأْكُلُ غَنِيمَةً، وَعِنْدَ ٱلْمَسَاءِ يُقَسِّمُ نَهْبًا». ");
INSERT INTO arb_vd_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","جَمِيعُ هَؤُلَاءِ هُمْ أَسْبَاطُ إِسْرَائِيلَ ٱلِٱثْنَا عَشَرَ. وَهَذَا مَا كَلَّمَهُمْ بِهِ أَبُوهُمْ وَبَارَكَهُمْ. كُلُّ وَاحِدٍ بِحَسَبِ بَرَكَتِهِ بَارَكَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","وَأَوْصَاهُمْ وَقَالَ لَهُمْ: «أَنَا أَنْضَمُّ إِلَى قَوْمِي. اِدْفِنُونِي عِنْدَ آبَائِي فِي ٱلْمَغَارَةِ ٱلَّتِي فِي حَقْلِ عِفْرُونَ ٱلْحِثِّيِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","فِي ٱلْمَغَارَةِ ٱلَّتِي فِي حَقْلِ ٱلْمَكْفِيلَةِ، ٱلَّتِي أَمَامَ مَمْرَا فِي أَرْضِ كَنْعَانَ، ٱلَّتِي ٱشْتَرَاهَا إِبْرَاهِيمُ مَعَ ٱلْحَقْلِ مِنْ عِفْرُونَ ٱلْحِثِّيِّ مُلْكَ قَبْرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","هُنَاكَ دَفَنُوا إِبْرَاهِيمَ وَسَارَةَ ٱمْرَأَتَهُ. هُنَاكَ دَفَنُوا إِسْحَاقَ وَرِفْقَةَ ٱمْرَأَتَهُ، وَهُنَاكَ دَفَنْتُ لَيْئَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","شِرَاءُ ٱلْحَقْلِ وَٱلْمَغَارَةِ ٱلَّتِي فِيهِ كَانَ مِنْ بَنِي حِثَّ». ");
INSERT INTO arb_vd_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","وَلَمَّا فَرَغَ يَعْقُوبُ مِنْ تَوْصِيَةِ بَنِيهِ ضَمَّ رِجْلَيْهِ إِلَى ٱلسَّرِيرِ، وَأَسْلَمَ ٱلرُّوحَ وَٱنْضَمَّ إِلَى قَوْمِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","فَوَقَعَ يُوسُفُ عَلَى وَجْهِ أَبِيهِ وَبَكَى عَلَيْهِ وَقَبَّلَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","وَأَمَرَ يُوسُفُ عَبِيدَهُ ٱلْأَطِبَّاءَ أَنْ يُحَنِّطُوا أَبَاهُ. فَحَنَّطَ ٱلْأَطِبَّاءُ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","وَكَمُلَ لَهُ أَرْبَعُونَ يَوْمًا، لِأَنَّهُ هَكَذَا تَكْمُلُ أَيَّامُ ٱلْمُحَنَّطِينَ. وَبَكَى عَلَيْهِ ٱلْمِصْرِيُّونَ سَبْعِينَ يَوْمًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","وَبَعْدَ مَا مَضَتْ أَيَّامُ بُكَائِهِ كَلَّمَ يُوسُفُ بَيْتَ فِرْعَوْنَ قَائِلًا: «إِنْ كُنْتُ قَدْ وَجَدْتُ نِعْمَةً فِي عُيُونِكُمْ، فَتَكَلَّمُوا فِي مَسَامِعِ فِرْعَوْنَ قَائِلِينَ: ");
INSERT INTO arb_vd_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","أَبِي ٱسْتَحْلَفَنِي قَائِلًا: هَا أَنَا أَمُوتُ. فِي قَبْرِيَ ٱلَّذِي حَفَرْتُ لِنَفْسِي فِي أَرْضِ كَنْعَانَ هُنَاكَ تَدْفِنُنِي، فَٱلْآنَ أَصْعَدُ لِأَدْفِنَ أَبِي وَأَرْجِعُ». ");
INSERT INTO arb_vd_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","فَقَالَ فِرْعَوْنُ: «ٱصْعَدْ وَٱدْفِنْ أَبَاكَ كَمَا ٱسْتَحْلَفَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","فَصَعِدَ يُوسُفُ لِيَدْفِنَ أَبَاهُ، وَصَعِدَ مَعَهُ جَمِيعُ عَبِيدِ فِرْعَوْنَ، شُيُوخُ بَيْتِهِ وَجَمِيعُ شُيُوخِ أَرْضِ مِصْرَ، ");
INSERT INTO arb_vd_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","وَكُلُّ بَيْتِ يُوسُفَ وَإِخْوَتُهُ وَبَيْتُ أَبِيهِ، غَيْرَ أَنَّهُمْ تَرَكُوا أَوْلَادَهُمْ وَغَنَمَهُمْ وَبَقَرَهُمْ فِي أَرْضِ جَاسَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","وَصَعِدَ مَعَهُ مَرْكَبَاتٌ وَفُرْسَانٌ، فَكَانَ ٱلْجَيْشُ كَثِيرًا جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","فَأَتَوْا إِلَى بَيْدَرِ أَطَادَ ٱلَّذِي فِي عَبْرِ ٱلْأُرْدُنِّ وَنَاحُوا هُنَاكَ نَوْحًا عَظِيمًا وَشَدِيدًا جِدًّا، وَصَنَعَ لِأَبِيهِ مَنَاحَةً سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","فَلَمَّا رَأَى أَهْلُ ٱلْبِلَادِ ٱلْكَنْعَانِيُّونَ ٱلْمَنَاحَةَ فِي بَيْدَرِ أَطَادَ قَالُوا: «هَذِهِ مَنَاحَةٌ ثَقِيلَةٌ لِلْمِصْرِيِّينَ». لِذَلِكَ دُعِيَ ٱسْمُهُ «آبَلَ مِصْرَايِمَ». ٱلَّذِي فِي عَبْرِ ٱلْأُرْدُنِّ. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","وَفَعَلَ لَهُ بَنُوهُ هَكَذَا كَمَا أَوْصَاهُمْ: ");
INSERT INTO arb_vd_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","حَمَلَهُ بَنُوهُ إِلَى أَرْضِ كَنْعَانَ وَدَفَنُوهُ فِي مَغَارَةِ حَقْلِ ٱلْمَكْفِيلَةِ، ٱلَّتِي ٱشْتَرَاهَا إِبْرَاهِيمُ مَعَ ٱلْحَقْلِ مُلْكَ قَبْرٍ مِنْ عِفْرُونَ ٱلْحِثِّيِ أَمَامَ مَمْرَا. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ثُمَّ رَجَعَ يُوسُفُ إِلَى مِصْرَ هُوَ وَإِخْوَتُهُ وَجَمِيعُ ٱلَّذِينَ صَعِدُوا مَعَهُ لِدَفْنِ أَبِيهِ بَعْدَ مَا دَفَنَ أَبَاهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","وَلَمَّا رَأَى إِخْوَةُ يُوسُفَ أَنَّ أَبَاهُمْ قَدْ مَاتَ، قَالُوا: «لَعَلَّ يُوسُفَ يَضْطَهِدُنَا وَيَرُدُّ عَلَيْنَا جَمِيعَ ٱلشَّرِّ ٱلَّذِي صَنَعْنَا بِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","فَأَوَصَوْا إِلَى يُوسُفَ قَائِلِينَ: «أَبُوكَ أَوْصَى قَبْلَ مَوْتِهِ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","هَكَذَا تَقُولُونَ لِيُوسُفَ: آهِ! ٱصْفَحْ عَنْ ذَنْبِ إِخْوَتِكَ وَخَطِيَّتِهِمْ، فَإِنَّهُمْ صَنَعُوا بِكَ شَرًّا. فَٱلْآنَ ٱصْفَحْ عَنْ ذَنْبِ عَبِيدِ إِلَهِ أَبِيكَ». فَبَكَى يُوسُفُ حِينَ كَلَّمُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","وَأَتَى إِخْوَتُهُ أَيْضًا وَوَقَعُوا أَمَامَهُ وَقَالُوا: «هَا نَحْنُ عَبِيدُكَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","فَقَالَ لَهُمْ يُوسُفُ: «لَا تَخَافُوا. لِأَنَّهُ هَلْ أَنَا مَكَانَ ٱللهِ؟ ");
INSERT INTO arb_vd_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","أَنْتُمْ قَصَدْتُمْ لِي شَرًّا، أَمَّا ٱللهُ فَقَصَدَ بِهِ خَيْرًا، لِكَيْ يَفْعَلَ كَمَا ٱلْيَوْمَ، لِيُحْيِيَ شَعْبًا كَثِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","فَٱلْآنَ لَا تَخَافُوا. أَنَا أَعُولُكُمْ وَأَوْلَادَكُمْ». فَعَزَّاهُمْ وَطَيَّبَ قُلُوبَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","وَسَكَنَ يُوسُفُ فِي مِصْرَ هُوَ وَبَيْتُ أَبِيهِ، وَعَاشَ يُوسُفُ مِئَةً وَعَشَرَ سِنِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","وَرَأَى يُوسُفُ لِأَفْرَايِمَ أَوْلَادَ ٱلْجِيلِ ٱلثَّالِثِ. وَأَوْلَادُ مَاكِيرَ بْنِ مَنَسَّى أَيْضًا وُلِدُوا عَلَى رُكْبَتَيْ يُوسُفَ. ");
INSERT INTO arb_vd_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","وَقَالَ يُوسُفُ لِإِخْوَتِهِ: «أَنَا أَمُوتُ، وَلَكِنَّ ٱللهَ سَيَفْتَقِدُكُمْ وَيُصْعِدُكُمْ مِنْ هَذِهِ ٱلْأَرْضِ إِلَى ٱلْأَرْضِ ٱلَّتِي حَلَفَ لِإِبْرَاهِيمَ وَإِسْحَاقَ وَيَعْقُوبَ». ");
INSERT INTO arb_vd_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","وَٱسْتَحْلَفَ يُوسُفُ بَنِي إِسْرَائِيلَ قَائِلًا: «ٱللهُ سَيَفْتَقِدُكُمْ فَتُصْعِدُونَ عِظَامِي مِنْ هُنَا». ");
INSERT INTO arb_vd_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ثُمَّ مَاتَ يُوسُفُ وَهُوَ ٱبْنُ مِئَةٍ وَعَشَرِ سِنِينَ، فَحَنَّطُوهُ وَوُضِعَ فِي تَابُوتٍ فِي مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","وَهَذِهِ أَسْمَاءُ بَنِي إِسْرَائِيلَ ٱلَّذِينَ جَاءُوا إِلَى مِصْرَ. مَعَ يَعْقُوبَ جَاءَ كُلُّ إِنْسَانٍ وَبَيْتُهُ: ");
INSERT INTO arb_vd_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","رَأُوبَيْنُ وَشِمْعُونُ وَلَاوِي وَيَهُوذَا ");
INSERT INTO arb_vd_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","وَيَسَّاكَرُ وَزَبُولُونُ وَبَنْيَامِينُ ");
INSERT INTO arb_vd_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","وَدَانُ وَنَفْتَالِي وَجَادُ وَأَشِيرُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","وَكَانَتْ جَمِيعُ نُفُوسِ ٱلْخَارِجِينَ مِنْ صُلْبِ يَعْقُوبَ سَبْعِينَ نَفْسًا. وَلَكِنْ يُوسُفُ كَانَ فِي مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","وَمَاتَ يُوسُفُ وَكُلُّ إِخْوَتِهِ وَجَمِيعُ ذَلِكَ ٱلْجِيلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","وَأَمَّا بَنُو إِسْرَائِيلَ فَأَثْمَرُوا وَتَوَالَدُوا وَنَمَوْا وَكَثُرُوا كَثِيرًا جِدًّا، وَٱمْتَلَأَتِ ٱلْأَرْضُ مِنْهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ثُمَّ قَامَ مَلِكٌ جَدِيدٌ عَلَى مِصْرَ لَمْ يَكُنْ يَعْرِفُ يُوسُفَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","فَقَالَ لِشَعْبِهِ: «هُوَذَا بَنُو إِسْرَائِيلَ شَعْبٌ أَكْثَرُ وَأَعْظَمُ مِنَّا. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","هَلُمَّ نَحْتَالُ لَهُمْ لِئَلَّا يَنْمُوا، فَيَكُونَ إِذَا حَدَثَتْ حَرْبٌ أَنَّهُمْ يَنْضَمُّونَ إِلَى أَعْدَائِنَا وَيُحَارِبُونَنَا وَيَصْعَدُونَ مِنَ ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","فَجَعَلُوا عَلَيْهِمْ رُؤَسَاءَ تَسْخِيرٍ لِكَيْ يُذِلُّوهُمْ بِأَثْقَالِهِمْ، فَبَنَوْا لِفِرْعَوْنَ مَدِينَتَيْ مَخَازِنَ: فِيثُومَ، وَرَعَمْسِيسَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","وَلَكِنْ بِحَسْبِمَا أَذَلُّوهُمْ هَكَذَا نَمَوْا وَٱمْتَدُّوا. فَٱخْتَشَوْا مِنْ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","فَٱسْتَعْبَدَ ٱلْمِصْرِيُّونَ بَنِي إِسْرَائِيلَ بِعُنْفٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","وَمَرَّرُوا حَيَاتَهُمْ بِعُبُودِيَّةٍ قَاسِيَةٍ فِي ٱلطِّينِ وَٱللِّبْنِ وَفِي كُلِّ عَمَلٍ فِي ٱلْحَقْلِ. كُلِّ عَمَلِهِمِ ٱلَّذِي عَمِلُوهُ بِوَاسِطَتِهِمْ عُنْفًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","وَكَلَّمَ مَلِكُ مِصْرَ قَابِلَتَيِ ٱلْعِبْرَانِيَّاتِ ٱللَّتَيْنِ ٱسْمُ إِحْدَاهُمَا شِفْرَةُ وَٱسْمُ ٱلْأُخْرَى فُوعَةُ، ");
INSERT INTO arb_vd_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","وَقَالَ: «حِينَمَا تُوَلِّدَانِ ٱلْعِبْرَانِيَّاتِ وَتَنْظُرَانِهِنَّ عَلَى ٱلْكَرَاسِيِّ، إِنْ كَانَ ٱبْنًا فَٱقْتُلَاهُ، وَإِنْ كَانَ بِنْتًا فَتَحْيَا». ");
INSERT INTO arb_vd_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","وَلَكِنَّ ٱلْقَابِلَتَيْنِ خَافَتَا ٱللهَ وَلَمْ تَفْعَلَا كَمَا كَلَّمَهُمَا مَلِكُ مِصْرَ، بَلِ ٱسْتَحْيَتَا ٱلْأَوْلَادَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","فَدَعَا مَلِكُ مِصْرَ ٱلْقَابِلَتَيْنِ وَقَالَ لَهُمَا: «لِمَاذَا فَعَلْتُمَا هَذَا ٱلْأَمْرَ وَٱسْتَحْيَيْتُمَا ٱلْأَوْلَادَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","فَقَالَتِ ٱلْقَابِلَتَانِ لِفِرْعَوْنَ: «إِنَّ ٱلنِّسَاءَ ٱلْعِبْرَانِيَّاتِ لَسْنَ كَٱلْمِصْرِيَّاتِ، فَإِنَّهُنَّ قَوِيَّاتٌ يَلِدْنَ قَبْلَ أَنْ تَأْتِيَهُنَّ ٱلْقَابِلَةُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","فَأَحْسَنَ ٱللهُ إِلَى ٱلْقَابِلَتَيْنِ، وَنَمَا ٱلشَّعْبُ وَكَثُرَ جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","وَكَانَ إِذْ خَافَتِ ٱلْقَابِلَتَانِ ٱللهَ أَنَّهُ صَنَعَ لَهُمَا بُيُوتًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ثُمَّ أَمَرَ فِرْعَوْنُ جَمِيعَ شَعْبِهِ قَائِلًا: «كُلُّ ٱبْنٍ يُولَدُ تَطْرَحُونَهُ فِي ٱلنَّهْرِ، لَكِنَّ كُلَّ بِنْتٍ تَسْتَحْيُونَهَا». ");
INSERT INTO arb_vd_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","وَذَهَبَ رَجُلٌ مِنْ بَيْتِ لَاوِي وَأَخَذَ بِنْتَ لَاوِي، ");
INSERT INTO arb_vd_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","فَحَبِلَتِ ٱلْمَرْأَةُ وَوَلَدَتِ ٱبْنًا. وَلَمَّا رَأَتْهُ أَنَّهُ حَسَنٌ، خَبَّأَتْهُ ثَلَاثَةَ أَشْهُرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","وَلَمَّا لَمْ يُمْكِنْهَا أَنْ تُخَبِّئَهُ بَعْدُ، أَخَذَتْ لَهُ سَفَطًا مِنَ ٱلْبَرْدِيِّ وَطَلَتْهُ بِٱلْحُمَرِ وَٱلزِّفْتِ، وَوَضَعَتِ ٱلْوَلَدَ فِيهِ، وَوَضَعَتْهُ بَيْنَ ٱلْحَلْفَاءِ عَلَى حَافَةِ ٱلنَّهْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","وَوَقَفَتْ أُخْتُهُ مِنْ بَعِيدٍ لِتَعْرِفَ مَاذَا يُفْعَلُ بِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","فَنَزَلَتِ ٱبْنَةُ فِرْعَوْنَ إِلَى ٱلنَّهْرِ لِتَغْتَسِلَ، وَكَانَتْ جَوَارِيهَا مَاشِيَاتٍ عَلَى جَانِبِ ٱلنَّهْرِ. فَرَأَتِ ٱلسَّفَطَ بَيْنَ ٱلْحَلْفَاءِ، فَأَرْسَلَتْ أَمَتَهَا وَأَخَذَتْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","وَلَمَّا فَتَحَتْهُ رَأَتِ ٱلْوَلَدَ، وَإِذَا هُوَ صَبِيٌّ يَبْكِي. فَرَقَّتْ لَهُ وَقَالَتْ: «هَذَا مِنْ أَوْلَادِ ٱلْعِبْرَانِيِّينَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","فَقَالَتْ أُخْتُهُ لِٱبْنَةِ فِرْعَوْنَ: «هَلْ أَذْهَبُ وَأَدْعُو لَكِ ٱمْرَأَةً مُرْضِعَةً مِنَ ٱلْعِبْرَانِيَّاتِ لِتُرْضِعَ لَكِ ٱلْوَلَدَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","فَقَالَتْ لَهَا ٱبْنَةُ فِرْعَوْنَ: «ٱذْهَبِي». فَذَهَبَتِ ٱلْفَتَاةُ وَدَعَتْ أُمَّ ٱلْوَلَدِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","فَقَالَتْ لَهَا ٱبْنَةُ فِرْعَوْنَ: «ٱذْهَبِي بِهَذَا ٱلْوَلَدِ وَأَرْضِعِيهِ لِي وَأَنَا أُعْطِي أُجْرَتَكِ». فَأَخَذَتِ ٱلْمَرْأَةُ ٱلْوَلَدَ وَأَرْضَعَتْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","وَلَمَّا كَبِرَ ٱلْوَلَدُ جَاءَتْ بِهِ إِلَى ٱبْنَةِ فِرْعَوْنَ فَصَارَ لَهَا ٱبْنًا، وَدَعَتِ ٱسْمَهُ «مُوسَى» وَقَالَتْ: «إِنِّي ٱنْتَشَلْتُهُ مِنَ ٱلْمَاءِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","وَحَدَثَ فِي تِلْكَ ٱلْأَيَّامِ لَمَّا كَبِرَ مُوسَى أَنَّهُ خَرَجَ إِلَى إِخْوَتِهِ لِيَنْظُرَ فِي أَثْقَالِهِمْ، فَرَأَى رَجُلًا مِصْرِيًّا يَضْرِبُ رَجُلًا عِبْرَانِيًّا مِنْ إِخْوَتِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","فَٱلْتَفَتَ إِلَى هُنَا وَهُنَاكَ وَرَأَى أَنْ لَيْسَ أَحَدٌ، فَقَتَلَ ٱلْمِصْرِيَّ وَطَمَرَهُ فِي ٱلرَّمْلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ثُمَّ خَرَجَ فِي ٱلْيَوْمِ ٱلثَّانِي وَإِذَا رَجُلَانِ عِبْرَانِيَّانِ يَتَخَاصَمَانِ، فَقَالَ لِلْمُذْنِبِ: «لِمَاذَا تَضْرِبُ صَاحِبَكَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","فَقَالَ: «مَنْ جَعَلَكَ رَئِيسًا وَقَاضِيًا عَلَيْنَا؟ أَمُفْتَكِرٌ أَنْتَ بِقَتْلِي كَمَا قَتَلْتَ ٱلْمِصْرِيَّ؟». فَخَافَ مُوسَى وَقَالَ: «حَقًّا قَدْ عُرِفَ ٱلْأَمْرُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","فَسَمِعَ فِرْعَوْنُ هَذَا ٱلْأَمْرَ، فَطَلَبَ أَنْ يَقْتُلَ مُوسَى. فَهَرَبَ مُوسَى مِنْ وَجْهِ فِرْعَوْنَ وَسَكَنَ فِي أَرْضِ مِدْيَانَ، وَجَلَسَ عِنْدَ ٱلْبِئْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","وَكَانَ لِكَاهِنِ مِدْيَانَ سَبْعُ بَنَاتٍ، فَأَتَيْنَ وَٱسْتَقَيْنَ وَمَلَأْنَ ٱلْأَجْرَانَ لِيَسْقِينَ غَنَمَ أَبِيهِنَّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","فَأَتَى ٱلرُّعَاةُ وَطَرَدُوهُنَّ. فَنَهَضَ مُوسَى وَأَنْجَدَهُنَّ وَسَقَى غَنَمَهُنَّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","فَلَمَّا أَتَيْنَ إِلَى رَعُوئِيلَ أَبِيهِنَّ قَالَ: «مَا بَالُكُنَّ أَسْرَعْتُنَّ فِي ٱلْمَجِيءِ ٱلْيَوْمَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","فَقُلْنَ: «رَجُلٌ مِصْرِيٌّ أَنْقَذَنَا مِنْ أَيْدِي ٱلرُّعَاةِ، وَإِنَّهُ ٱسْتَقَى لَنَا أَيْضًا وَسَقَى ٱلْغَنَمَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","فَقَالَ لِبَنَاتِهِ: «وَأَيْنَ هُوَ؟ لِمَاذَا تَرَكْتُنَّ ٱلرَّجُلَ؟ ٱدْعُونَهُ لِيَأْكُلَ طَعَامًا». ");
INSERT INTO arb_vd_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","فَٱرْتَضَى مُوسَى أَنْ يَسْكُنَ مَعَ ٱلرَّجُلِ، فَأَعْطَى مُوسَى صَفُّورَةَ ٱبْنَتَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","فَوَلَدَتِ ٱبْنًا فَدَعَا ٱسْمَهُ «جَرْشُومَ»، لِأَنَّهُ قَالَ: «كُنْتُ نَزِيلًا فِي أَرْضٍ غَرِيبَةٍ». ");
INSERT INTO arb_vd_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","وَحَدَثَ فِي تِلْكَ ٱلْأَيَّامِ ٱلْكَثِيرَةِ أَنَّ مَلِكَ مِصْرَ مَاتَ. وَتَنَهَّدَ بَنُو إِسْرَائِيلَ مِنَ ٱلْعُبُودِيَّةِ وَصَرَخُوا، فَصَعِدَ صُرَاخُهُمْ إِلَى ٱللهِ مِنْ أَجْلِ ٱلْعُبُودِيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","فَسَمِعَ ٱللهُ أَنِينَهُمْ، فَتَذَكَّرَ ٱللهُ مِيثَاقَهُ مَعَ إِبْرَاهِيمَ وَإِسْحَاقَ وَيَعْقُوبَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","وَنَظَرَ ٱللهُ بَنِي إِسْرَائِيلَ وَعَلِمَ ٱللهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","وَأَمَّا مُوسَى فَكَانَ يَرْعَى غَنَمَ يَثْرُونَ حَمِيهِ كَاهِنِ مِدْيَانَ، فَسَاقَ ٱلْغَنَمَ إِلَى وَرَاءِ ٱلْبَرِّيَّةِ وَجَاءَ إِلَى جَبَلِ ٱللهِ حُورِيبَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","وَظَهَرَ لَهُ مَلَاكُ ٱلرَّبِّ بِلَهِيبِ نَارٍ مِنْ وَسَطِ عُلَّيْقَةٍ. فَنَظَرَ وَإِذَا ٱلْعُلَّيْقَةُ تَتَوَقَّدُ بِٱلنَّارِ، وَٱلْعُلَّيْقَةُ لَمْ تَكُنْ تَحْتَرِقُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","فَقَالَ مُوسَى: «أَمِيلُ ٱلْآنَ لِأَنْظُرَ هَذَا ٱلْمَنْظَرَ ٱلْعَظِيمَ. لِمَاذَا لَا تَحْتَرِقُ ٱلْعُلَّيْقَةُ؟». ");
INSERT INTO arb_vd_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","فَلَمَّا رَأَى ٱلرَّبُّ أَنَّهُ مَالَ لِيَنْظُرَ، نَادَاهُ ٱللهُ مِنْ وَسَطِ ٱلْعُلَّيْقَةِ وَقَالَ: «مُوسَى، مُوسَى!». فَقَالَ: «هَأَنَذَا». ");
INSERT INTO arb_vd_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","فَقَالَ: «لَا تَقْتَرِبْ إِلَى هَهُنَا. ٱخْلَعْ حِذَاءَكَ مِنْ رِجْلَيْكَ، لِأَنَّ ٱلْمَوْضِعَ ٱلَّذِي أَنْتَ وَاقِفٌ عَلَيْهِ أَرْضٌ مُقَدَّسَةٌ». ");
INSERT INTO arb_vd_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ثُمَّ قَالَ: «أَنَا إِلَهُ أَبِيكَ، إِلَهُ إِبْرَاهِيمَ وَإِلَهُ إِسْحَاقَ وَإِلَهُ يَعْقُوبَ». فَغَطَّى مُوسَى وَجْهَهُ لِأَنَّهُ خَافَ أَنْ يَنْظُرَ إِلَى ٱللهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","فَقَالَ ٱلرَّبُّ: «إِنِّي قَدْ رَأَيْتُ مَذَلَّةَ شَعْبِي ٱلَّذِي فِي مِصْرَ وَسَمِعْتُ صُرَاخَهُمْ مِنْ أَجْلِ مُسَخِّرِيهِمْ. إِنِّي عَلِمْتُ أَوْجَاعَهُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","فَنَزَلْتُ لِأُنْقِذَهُمْ مِنْ أَيْدِي ٱلْمِصْرِيِّينَ، وَأُصْعِدَهُمْ مِنْ تِلْكَ ٱلْأَرْضِ إِلَى أَرْضٍ جَيِّدَةٍ وَوَاسِعَةٍ، إِلَى أَرْضٍ تَفِيضُ لَبَنًا وَعَسَلًا، إِلَى مَكَانِ ٱلْكَنْعَانِيِّينَ وَٱلْحِثِّيِّينَ وَٱلْأَمُورِيِّينَ وَٱلْفِرِزَّيِّينَ وَٱلْحِوِّيِّينَ وَٱلْيَبُوسِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","وَٱلْآنَ هُوَذَا صُرَاخُ بَنِي إِسْرَائِيلَ قَدْ أَتَى إِلَيَّ، وَرَأَيْتُ أَيْضًا ٱلضِّيقَةَ ٱلَّتِي يُضَايِقُهُمْ بِهَا ٱلْمِصْرِيُّونَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","فَٱلْآنَ هَلُمَّ فَأُرْسِلُكَ إِلَى فِرْعَوْنَ، وَتُخْرِجُ شَعْبِي بَنِي إِسْرَائِيلَ مِنْ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","فَقَالَ مُوسَى لِلهِ: «مَنْ أَنَا حَتَّى أَذْهَبَ إِلَى فِرْعَوْنَ، وَحَتَّى أُخْرِجَ بَنِي إِسْرَائِيلَ مِنْ مِصْرَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","فَقَالَ: «إِنِّي أَكُونُ مَعَكَ، وَهَذِهِ تَكُونُ لَكَ ٱلْعَلَامَةُ أَنِّي أَرْسَلْتُكَ: حِينَمَا تُخْرِجُ ٱلشَّعْبَ مِنْ مِصْرَ، تَعْبُدُونَ ٱللهَ عَلَى هَذَا ٱلْجَبَلِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","فَقَالَ مُوسَى لِلهِ: «هَا أَنَا آتِي إِلَى بَنِي إِسْرَائِيلَ وَأَقُولُ لَهُمْ: إِلَهُ آبَائِكُمْ أَرْسَلَنِي إِلَيْكُمْ. فَإِذَا قَالُوا لِي: مَا ٱسْمُهُ؟ فَمَاذَا أَقُولُ لَهُمْ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","فَقَالَ ٱللهُ لِمُوسَى: «أَهْيَهِ ٱلَّذِي أَهْيَهْ». وَقَالَ: «هَكَذَا تَقُولُ لِبَنِي إِسْرَائِيلَ: أَهْيَهْ أَرْسَلَنِي إِلَيْكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","وَقَالَ ٱللهُ أَيْضًا لِمُوسَى: «هَكَذَا تَقُولُ لِبَنِي إِسْرَائِيلَ: يَهْوَهْ إِلَهُ آبَائِكُمْ، إِلَهُ إِبْرَاهِيمَ وَإِلَهُ إِسْحَاقَ وَإِلَهُ يَعْقُوبَ أَرْسَلَنِي إِلَيْكُمْ. هَذَا ٱسْمِي إِلَى ٱلْأَبَدِ وَهَذَا ذِكْرِي إِلَى دَوْرٍ فَدَوْرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","اِذْهَبْ وَٱجْمَعْ شُيُوخَ إِسْرَائِيلَ وَقُلْ لَهُمُ: ٱلرَّبُّ إِلَهُ آبَائِكُمْ، إِلَهُ إِبْرَاهِيمَ وَإِسْحَاقَ وَيَعْقُوبَ ظَهَرَ لِي قَائِلًا: إِنِّي قَدِ ٱفْتَقَدْتُكُمْ وَمَا صُنِعَ بِكُمْ فِي مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","فَقُلْتُ أُصْعِدُكُمْ مِنْ مَذَلَّةِ مِصْرَ إِلَى أَرْضِ ٱلْكَنْعَانِيِّينَ وَٱلْحِثِّيِّينَ وَٱلْأَمُورِيِّينَ وَٱلْفِرِزِّيِّينَ وَٱلْحِوِّيِّينَ وَٱلْيَبُوسِيِّينَ، إِلَى أَرْضٍ تَفِيضُ لَبَنًا وَعَسَلًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«فَإِذَا سَمِعُوا لِقَوْلِكَ، تَدْخُلُ أَنْتَ وَشُيُوخُ بَنِي إِسْرَائِيلَ إِلَى مَلِكِ مِصْرَ وَتَقُولُونَ لَهُ: ٱلرَّبُّ إِلَهُ ٱلْعِبْرَانِيِّينَ ٱلْتَقَانَا، فَٱلْآنَ نَمْضِي سَفَرَ ثَلَاثَةِ أَيَّامٍ فِي ٱلْبَرِّيَّةِ وَنَذْبَحُ لِلرَّبِّ إِلَهِنَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","وَلَكِنِّي أَعْلَمُ أَنَّ مَلِكَ مِصْرَ لَا يَدَعُكُمْ تَمْضُونَ وَلَا بِيَدٍ قَوِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","فَأَمُدُّ يَدِي وَأَضْرِبُ مِصْرَ بِكُلِّ عَجَائِبِي ٱلَّتِي أَصْنَعُ فِيهَا. وَبَعْدَ ذَلِكَ يُطْلِقُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","وَأُعْطِي نِعْمَةً لِهَذَا ٱلشَّعْبِ فِي عُيُونِ ٱلْمِصْرِيِّينَ. فَيَكُونُ حِينَمَا تَمْضُونَ أَنَّكُمْ لَا تَمْضُونَ فَارِغِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","بَلْ تَطْلُبُ كُلُّ ٱمْرَأَةٍ مِنْ جَارَتِهَا وَمِنْ نَزِيلَةِ بَيْتِهَا أَمْتِعَةَ فِضَّةٍ وَأَمْتِعَةَ ذَهَبٍ وَثِيَابًا، وَتَضَعُونَهَا عَلَى بَنِيكُمْ وَبَنَاتِكُمْ. فَتَسْلُبُونَ ٱلْمِصْرِيِّينَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","فَأَجَابَ مُوسَى وَقَالَ: «وَلَكِنْ هَا هُمْ لَا يُصَدِّقُونَنِي وَلَا يَسْمَعُونَ لِقَوْلِي، بَلْ يَقُولُونَ: لَمْ يَظْهَرْ لَكَ ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","فَقَالَ لَهُ ٱلرَّبُّ: «مَا هَذِهِ فِي يَدِكَ؟» فَقَالَ: «عَصًا». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","فَقَالَ: «ٱطْرَحْهَا إِلَى ٱلْأَرْضِ». فَطَرَحَهَا إِلَى ٱلْأَرْضِ فَصَارَتْ حَيَّةً، فَهَرَبَ مُوسَى مِنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «مُدَّ يَدَكَ وَأَمْسِكْ بِذَنَبِهَا». فَمَدَّ يَدَهُ وَأَمْسَكَ بِهِ، فَصَارَتْ عَصًا فِي يَدِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","«لِكَيْ يُصَدِّقُوا أَنَّهُ قَدْ ظَهَرَ لَكَ ٱلرَّبُّ إِلَهُ آبَائِهِمْ، إِلَهُ إِبْرَاهِيمَ وَإِلَهُ إِسْحَاقَ وَإِلَهُ يَعْقُوبَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ثُمَّ قَالَ لَهُ ٱلرَّبُّ أَيْضًا: «أَدْخِلْ يَدَكَ فِي عُبِّكَ». فَأَدْخَلَ يَدَهُ فِي عُبِّهِ ثُمَّ أَخْرَجَهَا، وَإِذَا يَدُهُ بَرْصَاءُ مِثْلَ ٱلثَّلْجِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ثُمَّ قَالَ لَهُ: «رُدَّ يَدَكَ إِلَى عُبِّكَ». فَرَدَّ يَدَهُ إِلَى عُبِّهِ ثُمَّ أَخْرَجَهَا مِنْ عُبِّهِ، وَإِذَا هِيَ قَدْ عَادَتْ مِثْلَ جَسَدِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","«فَيَكُونُ إِذَا لَمْ يُصَدِّقُوكَ وَلَمْ يَسْمَعُوا لِصَوْتِ ٱلْآيَةِ ٱلْأُولَى، أَنَّهُمْ يُصَدِّقُونَ صَوْتَ ٱلْآيَةِ ٱلْأَخِيرَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","وَيَكُونُ إِذَا لَمْ يُصَدِّقُوا هَاتَيْنِ ٱلْآيَتَيْنِ، وَلَمْ يَسْمَعُوا لِقَوْلِكَ، أَنَّكَ تَأْخُذُ مِنْ مَاءِ ٱلنَّهْرِ وَتَسْكُبُ عَلَى ٱلْيَابِسَةِ، فَيَصِيرُ ٱلْمَاءُ ٱلَّذِي تَأْخُذُهُ مِنَ ٱلنَّهْرِ دَمًا عَلَى ٱلْيَابِسَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","فَقَالَ مُوسَى لِلرَّبِّ: «ٱسْتَمِعْ أَيُّهَا ٱلسَّيِّدُ، لَسْتُ أَنَا صَاحِبَ كَلَامٍ مُنْذُ أَمْسِ وَلَا أَوَّلِ مِنْ أَمْسِ، وَلَا مِنْ حِينِ كَلَّمْتَ عَبْدَكَ، بَلْ أَنَا ثَقِيلُ ٱلْفَمِ وَٱللِّسَانِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","فَقَالَ لَهُ ٱلرَّبُّ: «مَنْ صَنَعَ لِلْإِنْسَانِ فَمًا؟ أَوْ مَنْ يَصْنَعُ أَخْرَسَ أَوْ أَصَمَّ أَوْ بَصِيرًا أَوْ أَعْمَى؟ أَمَا هُوَ أَنَا ٱلرَّبُّ؟ ");
INSERT INTO arb_vd_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","فَٱلْآنَ ٱذْهَبْ وَأَنَا أَكُونُ مَعَ فَمِكَ وَأُعَلِّمُكَ مَا تَتَكَلَّمُ بِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","فَقَالَ: «ٱسْتَمِعْ أَيُّهَا ٱلسَّيِّدُ، أَرْسِلْ بِيَدِ مَنْ تُرْسِلُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","فَحَمِيَ غَضَبُ ٱلرَّبِّ عَلَى مُوسَى وَقَالَ: «أَلَيْسَ هَارُونُ ٱللَّاوِيُّ أَخَاكَ؟ أَنَا أَعْلَمُ أَنَّهُ هُوَ يَتَكَلَّمُ، وَأَيْضًا هَا هُوَ خَارِجٌ لِٱسْتِقْبَالِكَ. فَحِينَمَا يَرَاكَ يَفْرَحُ بِقَلْبِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","فَتُكَلِّمُهُ وَتَضَعُ ٱلْكَلِمَاتِ فِي فَمِهِ، وَأَنَا أَكُونُ مَعَ فَمِكَ وَمَعَ فَمِهِ، وَأُعْلِمُكُمَا مَاذَا تَصْنَعَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","وَهُوَ يُكَلِّمُ ٱلشَّعْبَ عَنْكَ. وَهُوَ يَكُونُ لَكَ فَمًا، وَأَنْتَ تَكُونُ لَهُ إِلَهًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","وَتَأْخُذُ فِي يَدِكَ هَذِهِ ٱلْعَصَا ٱلَّتِي تَصْنَعُ بِهَا ٱلْآيَاتِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","فَمَضَى مُوسَى وَرَجَعَ إِلَى يَثْرُونَ حَمِيهِ وَقَالَ لَهُ: «أَنَا أَذْهَبُ وَأَرْجِعُ إِلَى إِخْوَتِي ٱلَّذِينَ فِي مِصْرَ لِأَرَى هَلْ هُمْ بَعْدُ أَحْيَاءٌ». فَقَالَ يَثْرُونُ لِمُوسَى: «ٱذْهَبْ بِسَلَامٍ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","وَقَالَ ٱلرَّبُّ لِمُوسَى فِي مِدْيَانَ: «ٱذْهَبْ ٱرْجِعْ إِلَى مِصْرَ، لِأَنَّهُ قَدْ مَاتَ جَمِيعُ ٱلْقَوْمِ ٱلَّذِينَ كَانُوا يَطْلُبُونَ نَفْسَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","فَأَخَذَ مُوسَى ٱمْرَأَتَهُ وَبَنِيهِ وَأَرْكَبَهُمْ عَلَى ٱلْحَمِيرِ وَرَجَعَ إِلَى أَرْضِ مِصْرَ. وَأَخَذَ مُوسَى عَصَا ٱللهِ فِي يَدِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","وَقَالَ ٱلرَّبُّ لِمُوسَى: «عِنْدَمَا تَذْهَبُ لِتَرْجِعَ إِلَى مِصْرَ، ٱنْظُرْ جَمِيعَ ٱلْعَجَائِبِ ٱلَّتِي جَعَلْتُهَا فِي يَدِكَ وَٱصْنَعْهَا قُدَّامَ فِرْعَوْنَ. وَلَكِنِّي أُشَدِّدُ قَلْبَهُ حَتَّى لَا يُطْلِقَ ٱلشَّعْبَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","فَتَقُولُ لِفِرْعَوْنَ: هَكَذَا يَقُولُ ٱلرَّبُّ: إِسْرَائِيلُ ٱبْنِي ٱلْبِكْرُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","فَقُلْتُ لَكَ: أَطْلِقِ ٱبْنِي لِيَعْبُدَنِي، فَأَبَيْتَ أَنْ تُطْلِقَهُ. هَا أَنَا أَقْتُلُ ٱبْنَكَ ٱلْبِكْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","وَحَدَثَ فِي ٱلطَّرِيقِ فِي ٱلْمَنْزِلِ أَنَّ ٱلرَّبَّ ٱلْتَقَاهُ وَطَلَبَ أَنْ يَقْتُلَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","فَأَخَذَتْ صَفُّورَةُ صَوَّانَةً وَقَطَعَتْ غُرْلَةَ ٱبْنِهَا وَمَسَّتْ رِجْلَيْهِ. فَقَالَتْ: «إِنَّكَ عَرِيسُ دَمٍ لِي». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","فَٱنْفَكَّ عَنْهُ. حِينَئِذٍ قَالَتْ: «عَرِيسُ دَمٍ مِنْ أَجْلِ ٱلْخِتَانِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","وَقَالَ ٱلرَّبُّ لِهَارُونَ: «ٱذْهَبْ إِلَى ٱلْبَرِّيَّةِ لِٱسْتِقْبَالِ مُوسَى». فَذَهَبَ وَٱلْتَقَاهُ فِي جَبَلِ ٱللهِ وَقَبَّلَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","فَأَخْبَرَ مُوسَى هَارُونَ بِجَمِيعِ كَلَامِ ٱلرَّبِّ ٱلَّذِي أَرْسَلَهُ، وَبِكُلِّ ٱلْآيَاتِ ٱلَّتِي أَوْصَاهُ بِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ثُمَّ مَضَى مُوسَى وَهَارُونُ وَجَمَعَا جَمِيعَ شُيُوخِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","فَتَكَلَّمَ هَارُونُ بِجَمِيعِ ٱلْكَلَامِ ٱلَّذِي كَلَّمَ ٱلرَّبُّ مُوسَى بِهِ، وَصَنَعَ ٱلْآيَاتِ أَمَامَ عُيُونِ ٱلشَّعْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","فَآمَنَ ٱلشَّعْبُ. وَلَمَّا سَمِعُوا أَنَّ ٱلرَّبَّ ٱفْتَقَدَ بَنِي إِسْرَائِيلَ وَأَنَّهُ نَظَرَ مَذَلَّتَهُمْ، خَرُّوا وَسَجَدُوا. ");
INSERT INTO arb_vd_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","وَبَعْدَ ذَلِكَ دَخَلَ مُوسَى وَهَارُونُ وَقَالَا لِفِرْعَوْنَ: «هَكَذَا يَقُولُ ٱلرَّبُّ إِلَهُ إِسْرَائِيلَ: أَطْلِقْ شَعْبِي لِيُعَيِّدُوا لِي فِي ٱلْبَرِّيَّةِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","فَقَالَ فِرْعَوْنُ: «مَنْ هُوَ ٱلرَّبُّ حَتَّى أَسْمَعَ لِقَوْلِهِ فَأُطْلِقَ إِسْرَائِيلَ؟ لَا أَعْرِفُ ٱلرَّبَّ، وَإِسْرَائِيلَ لَا أُطْلِقُهُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","فَقَالَا: «إِلَهُ ٱلْعِبْرَانِيِّينَ قَدِ ٱلْتَقَانَا، فَنَذْهَبُ سَفَرَ ثَلَاثَةِ أَيَّامٍ فِي ٱلْبَرِّيَّةِ وَنَذْبَحُ لِلرَّبِّ إِلَهِنَا، لِئَلَّا يُصِيبَنَا بِٱلْوَبَإِ أَوْ بِٱلسَّيْفِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","فَقَالَ لَهُمَا مَلِكُ مِصْرَ: «لِمَاذَا يَا مُوسَى وَهَارُونُ تُبَطِّلَانِ ٱلشَّعْبَ مِنْ أَعْمَالِهِ؟ اِذْهَبَا إِلَى أَثْقَالِكُمَا». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","وَقَالَ فِرْعَوْنُ: «هُوَذَا ٱلْآنَ شَعْبُ ٱلْأَرْضِ كَثِيرٌ وَأَنْتُمَا تُرِيحَانِهِمْ مِنْ أَثْقَالِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","فَأَمَرَ فِرْعَوْنُ فِي ذَلِكَ ٱلْيَوْمِ مُسَخِّرِي ٱلشَّعْبِ وَمُدَبِّرِيهِ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«لَا تَعُودُوا تُعْطُونَ ٱلشَّعْبَ تِبْنًا لِصُنْعِ ٱللِّبْنِ كَأَمْسِ وَأَوَّلَ مِنْ أَمْسِ. لِيَذْهَبُوا هُمْ وَيَجْمَعُوا تِبْنًا لِأَنْفُسِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","وَمِقْدَارَ ٱللِّبْنِ ٱلَّذِي كَانُوا يَصْنَعُونَهُ أَمْسِ، وَأَوَّلَ مِنْ أَمْسِ تَجْعَلُونَ عَلَيْهِمْ. لَا تَنْقُصُوا مِنْهُ، فَإِنَّهُمْ مُتَكَاسِلُونَ، لِذَلِكَ يَصْرُخُونَ قَائِلِينَ: نَذْهَبُ وَنَذْبَحُ لِإِلَهِنَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","لِيُثَقَّلِ ٱلْعَمَلُ عَلَى ٱلْقَوْمِ حَتَّى يَشْتَغِلُوا بِهِ وَلَا يَلْتَفِتُوا إِلَى كَلَامِ ٱلْكَذِبِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","فَخَرَجَ مُسَخِّرُو ٱلشَّعْبِ وَمُدَبِّرُوهُ وَكَلَّمُوا ٱلشَّعْبَ، قَائِلِينَ: «هَكَذَا يَقُولُ فِرْعَوْنُ: لَسْتُ أُعْطِيكُمْ تِبْنًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ٱذْهَبُوا أَنْتُمْ وَخُذُوا لِأَنْفُسِكُمْ تِبْنًا مِنْ حَيْثُ تَجِدُونَ. إِنَّهُ لَا يُنْقَصُ مِنْ عَمَلِكُمْ شَيْءٌ». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","فَتَفَرَّقَ ٱلشَّعْبُ فِي كُلِّ أَرْضِ مِصْرَ لِيَجْمَعُوا قَشًّا عِوَضًا عَنِ ٱلتِّبْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","وَكَانَ ٱلْمُسَخِّرُونَ يُعَجِّلُونَهُمْ قَائِلِينَ: «كَمِّلُوا أَعْمَالَكُمْ، أَمْرَ كُلِّ يَوْمٍ بِيَوْمِهِ، كَمَا كَانَ حِينَمَا كَانَ ٱلتِّبْنُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","فَضُرِبَ مُدَبِّرُو بَنِي إِسْرَائِيلَ ٱلَّذِينَ أَقَامَهُمْ عَلَيْهِمْ مُسَخِّرُو فِرْعَوْنَ، وَقِيلَ لَهُمْ: «لِمَاذَا لَمْ تُكَمِّلُوا فَرِيضَتَكُمْ مِنْ صُنْعِ ٱللِّبْنِ أَمْسِ وَٱلْيَوْمَ كَٱلْأَمْسِ وَأَوَّلَ مِنْ أَمْسِ؟». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","فَأَتَى مُدَبِّرُو بَنِي إِسْرَائِيلَ وَصَرَخُوا إِلَى فِرْعَوْنَ قَائِلِينَ: «لِمَاذَا تَفْعَلُ هَكَذَا بِعَبِيدِكَ؟ ");
INSERT INTO arb_vd_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","اَلتِّبْنُ لَيْسَ يُعْطَى لِعَبِيدِكَ، وَٱللِّبْنُ يَقُولُونَ لَنَا: ٱصْنَعُوهُ! وَهُوَذَا عَبِيدُكَ مَضْرُوبُونَ، وَقَدْ أَخْطَأَ شَعْبُكَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","فَقَالَ: «مُتَكَاسِلُونَ أَنْتُمْ، مُتَكَاسِلُونَ! لِذَلِكَ تَقُولُونَ: نَذْهَبُ وَنَذْبَحُ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","فَٱلْآنَ ٱذْهَبُوا ٱعْمَلُوا. وَتِبْنٌ لَا يُعْطَى لَكُمْ وَمِقْدَارَ ٱللِّبْنِ تُقَدِّمُونَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","فَرَأَى مُدَبِّرُو بَنِي إِسْرَائِيلَ أَنْفُسَهُمْ فِي بَلِيَّةٍ إِذْ قِيلَ لَهُمْ لَا تُنَقِّصُوا مِنْ لِبْنِكُمْ أَمْرَ كُلِّ يَوْمٍ بِيَوْمِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","وَصَادَفُوا مُوسَى وَهَارُونَ وَاقِفَيْنِ لِلِقَائِهِمْ حِينَ خَرَجُوا مِنْ لَدُنْ فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","فَقَالُوا لَهُمَا: «يَنْظُرُ ٱلرَّبُّ إِلَيْكُمَا وَيَقْضِي، لِأَنَّكُمَا أَنْتَنْتُمَا رَائِحَتَنَا فِي عَيْنَيْ فِرْعَوْنَ وَفِي عُيُونِ عَبِيدِهِ حَتَّى تُعْطِيَا سَيْفًا فِي أَيْدِيهِمْ لِيَقْتُلُونَا». ");
INSERT INTO arb_vd_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","فَرَجَعَ مُوسَى إِلَى ٱلرَّبِّ وَقَالَ: «يَا سَيِّدُ، لِمَاذَا أَسَأْتَ إِلَى هَذَا ٱلشَّعْبِ؟ لِمَاذَا أَرْسَلْتَنِي؟ ");
INSERT INTO arb_vd_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","فَإِنَّهُ مُنْذُ دَخَلْتُ إِلَى فِرْعَوْنَ لِأَتَكَلَّمَ بِٱسْمِكَ، أَسَاءَ إِلَى هَذَا ٱلشَّعْبِ. وَأَنْتَ لَمْ تُخَلِّصْ شَعْبَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","فَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱلْآنَ تَنْظُرُ مَا أَنَا أَفْعَلُ بِفِرْعَوْنَ. فَإِنَّهُ بِيَدٍ قَوِيَّةٍ يُطْلِقُهُمْ، وَبِيَدٍ قَوِيَّةٍ يَطْرُدُهُمْ مِنْ أَرْضِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ثُمَّ كَلَّمَ ٱللهُ مُوسَى وَقَالَ لَهُ: «أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","وَأَنَا ظَهَرْتُ لِإِبْرَاهِيمَ وَإِسْحَاقَ وَيَعْقُوبَ بِأَنِّي ٱلْإِلَهُ ٱلْقَادِرُ عَلَى كُلِّ شَيْءٍ. وَأَمَّا بِٱسْمِي «يَهْوَهْ» فَلَمْ أُعْرَفْ عِنْدَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","وَأَيْضًا أَقَمْتُ مَعَهُمْ عَهْدِي: أَنْ أُعْطِيَهُمْ أَرْضَ كَنْعَانَ أَرْضَ غُرْبَتِهِمِ ٱلَّتِي تَغَرَّبُوا فِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","وَأَنَا أَيْضًا قَدْ سَمِعْتُ أَنِينَ بَنِي إِسْرَائِيلَ ٱلَّذِينَ يَسْتَعْبِدُهُمُ ٱلْمِصْرِيُّونَ، وَتَذَكَّرْتُ عَهْدِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","لِذَلِكَ قُلْ لِبَنِي إِسْرَائِيلَ: أَنَا ٱلرَّبُّ. وَأَنَا أُخْرِجُكُمْ مِنْ تَحْتِ أَثْقَالِ ٱلْمِصْرِيِّينَ وَأُنْقِذُكُمْ مِنْ عُبُودِيَّتِهِمْ وَأُخَلِّصُكُمْ بِذِرَاعٍ مَمْدُودَةٍ وَبِأَحْكَامٍ عَظِيمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","وَأَتَّخِذُكُمْ لِي شَعْبًا، وَأَكُونُ لَكُمْ إِلَهًا. فَتَعْلَمُونَ أَنِّي أَنَا ٱلرَّبُّ إِلَهُكُمُ ٱلَّذِي يُخْرِجُكُمْ مِنْ تَحْتِ أَثْقَالِ ٱلْمِصْرِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","وَأُدْخِلُكُمْ إِلَى ٱلْأَرْضِ ٱلَّتِي رَفَعْتُ يَدِي أَنْ أُعْطِيَهَا لِإِبْرَاهِيمَ وَإِسْحَاقَ وَيَعْقُوبَ. وَأُعْطِيَكُمْ إِيَّاهَا مِيرَاثًا. أَنَا ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","فَكَلَّمَ مُوسَى هَكَذَا بَنِي إِسْرَائِيلَ، وَلَكِنْ لَمْ يَسْمَعُوا لِمُوسَى مِنْ صِغَرِ ٱلنَّفْسِ، وَمِنَ ٱلْعُبُودِيَّةِ ٱلْقَاسِيَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ثُمَّ كَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«اُدْخُلْ قُلْ لِفِرْعَوْنَ مَلِكِ مِصْرَ أَنْ يُطْلِقَ بَنِي إِسْرَائِيلَ مِنْ أَرْضِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","فَتَكَلَّمَ مُوسَى أَمَامَ ٱلرَّبِّ قَائِلًا: «هُوَذَا بَنُو إِسْرَائِيلَ لَمْ يَسْمَعُوا لِي، فَكَيْفَ يَسْمَعُنِي فِرْعَوْنُ وَأَنَا أَغْلَفُ ٱلشَّفَتَيْنِ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","فَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ، وَأَوْصَى مَعَهُمَا إِلَى بَنِي إِسْرَائِيلَ وَإِلَى فِرْعَوْنَ مَلِكِ مِصْرَ فِي إِخْرَاجِ بَنِي إِسْرَائِيلَ مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","هَؤُلَاءِ رُؤَسَاءُ بُيُوتِ آبَائِهِمْ: بَنُو رَأُوبَيْنَ بِكْرِ إِسْرَائِيلَ: حَنُوكُ وَفَلُّو وَحَصْرُونُ وَكَرْمِي. هَذِهِ عَشَائِرُ رَأُوبَيْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","وَبَنُو شِمْعُونَ: يَمُوئِيلُ وَيَامِينُ وَأُوهَدُ وَيَاكِينُ وَصُوحَرُ وَشَأُولُ ٱبْنُ ٱلْكَنْعَانِيَّةِ. هَذِهِ عَشَائِرُ شِمْعُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","وَهَذِهِ أَسْمَاءُ بَنِي لَاوِي بِحَسَبِ مَوَالِيدِهِمْ: جِرْشُونُ وَقَهَاتُ وَمَرَارِي. وَكَانَتْ سِنُو حَيَاةِ لَاوِي مِئَةً وَسَبْعًا وَثَلَاثِينَ سَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","اِبْنَا جِرْشُونَ: لِبْنِي وَشِمْعِي بِحَسَبِ عَشَائِرِهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","وَبَنُو قَهَاتَ: عَمْرَامُ وَيِصْهَارُ وَحَبْرُونُ وَعُزِّيئِيلُ. وَكَانَتْ سِنُو حَيَاةِ قَهَاتَ مِئَةً وَثَلَاثًا وَثَلَاثِينَ سَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","وَٱبْنَا مَرَارِي: مَحْلِي وَمُوشِي. هَذِهِ عَشَائِرُ ٱللَّاوِيِّينَ بِحَسَبِ مَوَالِيدِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","وَأَخَذَ عَمْرَامُ يُوكَابَدَ عَمَّتَهُ زَوْجَةً لَهُ. فَوَلَدَتْ لَهُ هَارُونَ وَمُوسَى. وَكَانَتْ سِنُو حَيَاةِ عَمْرَامَ مِئَةً وَسَبْعًا وَثَلَاثِينَ سَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","وَبَنُو يِصْهَارَ: قُورَحُ وَنَافَجُ وَذِكْرِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","وَبَنُو عُزِّيئِيلَ: مِيشَائِيلُ وَأَلْصَافَانُ وَسِتْرِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","وَأَخَذَ هَارُونُ أَلِيشَابَعَ بِنْتَ عَمِّينَادَابَ أُخْتَ نَحْشُونَ زَوْجَةً لَهُ، فَوَلَدَتْ لَهُ نَادَابَ وَأَبِيهُوَ وَأَلِعَازَارَ وَإِيثَامَارَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","وَبَنُو قُورَحَ: أَسِّيرُ وَأَلْقَانَةُ وَأَبِيَأَسَافُ. هَذِهِ عَشَائِرُ ٱلْقُورَحِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","وَأَلِعَازَارُ بْنُ هَارُونَ أَخَذَ لِنَفْسِهِ مِنْ بَنَاتِ فُوطِيئِيلَ زَوْجَةً، فَوَلَدَتْ لَهُ فِينَحَاسَ. هَؤُلَاءِ هُمْ رُؤَسَاءُ آبَاءِ ٱللَّاوِيِّينَ بِحَسَبِ عَشَائِرِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","هَذَانِ هُمَا هَارُونُ وَمُوسَى ٱللَّذَانِ قَالَ ٱلرَّبُّ لَهُمَا: «أَخْرِجَا بَنِي إِسْرَائِيلَ مِنْ أَرْضِ مِصْرَ» بِحَسَبِ أَجْنَادِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","هُمَا ٱللَّذَانِ كَلَّمَا فِرْعَوْنَ مَلِكَ مِصْرَ فِي إِخْرَاجِ بَنِي إِسْرَائِيلَ مِنْ مِصْرَ. هَذَانِ هُمَا مُوسَى وَهَارُونُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","وَكَانَ يَوْمَ كَلَّمَ ٱلرَّبُّ مُوسَى فِي أَرْضِ مِصْرَ ");
INSERT INTO arb_vd_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","أَنَّ ٱلرَّبَّ كَلَّمَهُ قَائِلًا: «أَنَا ٱلرَّبُّ. كَلِّمْ فِرْعَوْنَ مَلِكَ مِصْرَ بِكُلِّ مَا أَنَا أُكَلِّمُكَ بِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","فَقَالَ مُوسَى أَمَامَ ٱلرَّبِّ: «هَا أَنَا أَغْلَفُ ٱلشَّفَتَيْنِ. فَكَيْفَ يَسْمَعُ لِي فِرْعَوْنُ؟». ");
INSERT INTO arb_vd_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","فَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱنْظُرْ! أَنَا جَعَلْتُكَ إِلَهًا لِفِرْعَوْنَ. وَهَارُونُ أَخُوكَ يَكُونُ نَبِيَّكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","أَنْتَ تَتَكَلَّمُ بِكُلِّ مَا آمُرُكَ، وَهَارُونُ أَخُوكَ يُكَلِّمُ فِرْعَوْنَ لِيُطْلِقَ بَنِي إِسْرَائِيلَ مِنْ أَرْضِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","وَلَكِنِّي أُقَسِّي قَلْبَ فِرْعَوْنَ وَأُكَثِّرُ آيَاتِي وَعَجَائِبِي فِي أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","وَلَا يَسْمَعُ لَكُمَا فِرْعَوْنُ حَتَّى أَجْعَلَ يَدِي عَلَى مِصْرَ، فَأُخْرِجَ أَجْنَادِي، شَعْبِي بَنِي إِسْرَائِيلَ مِنْ أَرْضِ مِصْرَ بِأَحْكَامٍ عَظِيمَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","فَيَعْرِفُ ٱلْمِصْرِيُّونَ أَنِّي أَنَا ٱلرَّبُّ حِينَمَا أَمُدُّ يَدِي عَلَى مِصْرَ وَأُخْرِجُ بَنِي إِسْرَائِيلَ مِنْ بَيْنِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","فَفَعَلَ مُوسَى وَهَارُونُ كَمَا أَمَرَهُمَا ٱلرَّبُّ. هَكَذَا فَعَلَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","وَكَانَ مُوسَى ٱبْنَ ثَمَانِينَ سَنَةً، وَهَارُونُ ٱبْنَ ثَلَاثٍ وَثَمَانِينَ سَنَةً حِينَ كَلَّمَا فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«إِذَا كَلَّمَكُمَا فِرْعَوْنُ قَائِلًا: هَاتِيَا عَجِيبَةً، تَقُولُ لِهَارُونَ: خُذْ عَصَاكَ وَٱطْرَحْهَا أَمَامَ فِرْعَوْنَ فَتَصِيرَ ثُعْبَانًا». ");
INSERT INTO arb_vd_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","فَدَخَلَ مُوسَى وَهَارُونُ إِلَى فِرْعَوْنَ وَفَعَلَا هَكَذَا كَمَا أَمَرَ ٱلرَّبُّ. طَرَحَ هَارُونُ عَصَاهُ أَمَامَ فِرْعَوْنَ وَأَمَامَ عَبِيدِهِ فَصَارَتْ ثُعْبَانًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","فَدَعَا فِرْعَوْنُ أَيْضًا ٱلْحُكَمَاءَ وَٱلسَّحَرَةَ، فَفَعَلَ عَرَّافُو مِصْرَ أَيْضًا بِسِحْرِهِمْ كَذَلِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","طَرَحُوا كُلُّ وَاحِدٍ عَصَاهُ فَصَارَتِ ٱلْعِصِيُّ ثَعَابِينَ. وَلَكِنْ عَصَا هَارُونَ ٱبْتَلَعَتْ عِصِيَّهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","فَٱشْتَدَّ قَلْبُ فِرْعَوْنَ فَلَمْ يَسْمَعْ لَهُمَا، كَمَا تَكَلَّمَ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «قَلْبُ فِرْعَوْنَ غَلِيظٌ. قَدْ أَبَى أَنْ يُطْلِقَ ٱلشَّعْبَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","اِذْهَبْ إِلَى فِرْعَوْنَ فِي ٱلصَّبَاحِ. إِنَّهُ يَخْرُجُ إِلَى ٱلْمَاءِ، وَقِفْ لِلِقَائِهِ عَلَى حَافَةِ ٱلنَّهْرِ. وَٱلْعَصَا ٱلَّتِي تَحَوَّلَتْ حَيَّةً تَأْخُذُهَا فِي يَدِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","وَتَقُولُ لَهُ: ٱلرَّبُّ إِلَهُ ٱلْعِبْرَانِيِّينَ أَرْسَلَنِي إِلَيْكَ قَائِلًا: أَطْلِقْ شَعْبِي لِيَعْبُدُونِي فِي ٱلْبَرِّيَّةِ. وَهُوَذَا حَتَّى ٱلْآنَ لَمْ تَسْمَعْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","هَكَذَا يَقُولُ ٱلرَّبُّ: بِهَذَا تَعْرِفُ أَنِّي أَنَا ٱلرَّبُّ: هَا أَنَا أَضْرِبُ بِٱلْعَصَا ٱلَّتِي فِي يَدِي عَلَى ٱلْمَاءِ ٱلَّذِي فِي ٱلنَّهْرِ فَيَتَحَوَّلُ دَمًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","وَيَمُوتُ ٱلسَّمَكُ ٱلَّذِي فِي ٱلنَّهْرِ وَيَنْتِنُ ٱلنَّهْرُ. فَيَعَافُ ٱلْمِصْرِيُّونَ أَنْ يَشْرَبُوا مَاءً مِنَ ٱلنَّهْرِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «قُلْ لِهَارُونَ: خُذْ عَصَاكَ وَمُدَّ يَدَكَ عَلَى مِيَاهِ ٱلْمِصْرِيِّينَ، عَلَى أَنْهَارِهِمْ وَعَلَى سَوَاقِيهِمْ، وَعَلَى آجَامِهِمْ، وَعَلَى كُلِّ مُجْتَمَعَاتِ مِيَاهِهِمْ لِتَصِيرَ دَمًا. فَيَكُونَ دَمٌ فِي كُلِّ أَرْضِ مِصْرَ فِي ٱلْأَخْشَابِ وَفِي ٱلْأَحْجَارِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","فَفَعَلَ هَكَذَا مُوسَى وَهَارُونُ كَمَا أَمَرَ ٱلرَّبُّ. رَفَعَ ٱلْعَصَا وَضَرَبَ ٱلْمَاءَ ٱلَّذِي فِي ٱلنَّهْرِ أَمَامَ عَيْنَيْ فِرْعَوْنَ وَأَمَامَ عُيُونِ عَبِيدِهِ، فَتَحَوَّلَ كُلُّ ٱلْمَاءِ ٱلَّذِي فِي ٱلنَّهْرِ دَمًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","وَمَاتَ ٱلسَّمَكُ ٱلَّذِي فِي ٱلنَّهْرِ وَأَنْتَنَ ٱلنَّهْرُ، فَلَمْ يَقْدِرِ ٱلْمِصْرِيُّونَ أَنْ يَشْرَبُوا مَاءً مِنَ ٱلنَّهْرِ. وَكَانَ ٱلدَّمُ فِي كُلِّ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","وَفَعَلَ عَرَّافُو مِصْرَ كَذَلِكَ بِسِحْرِهِمْ. فَٱشْتَدَّ قَلْبُ فِرْعَوْنَ فَلَمْ يَسْمَعْ لَهُمَا، كَمَا تَكَلَّمَ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ثُمَّ ٱنْصَرَفَ فِرْعَوْنُ وَدَخَلَ بَيْتَهُ وَلَمْ يُوَجِّهْ قَلْبَهُ إِلَى هَذَا أَيْضًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","وَحَفَرَ جَمِيعُ ٱلْمِصْرِيِّينَ حَوَالَيِ ٱلنَّهْرِ لِأَجْلِ مَاءٍ لِيَشْرَبُوا، لِأَنَّهُمْ لَمْ يَقْدِرُوا أَنْ يَشْرَبُوا مِنْ مَاءِ ٱلنَّهْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","وَكَمُلَتْ سَبْعَةُ أَيَّامٍ بَعْدَ مَا ضَرَبَ ٱلرَّبُّ ٱلنَّهْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","قَالَ ٱلرَّبُّ لِمُوسَى: «ٱدْخُلْ إِلَى فِرْعَوْنَ وَقُلْ لَهُ: هَكَذَا يَقُولُ ٱلرَّبُّ: أَطْلِقْ شَعْبِي لِيَعْبُدُونِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","وَإِنْ كُنْتَ تَأْبَى أَنْ تُطْلِقَهُمْ فَهَا أَنَا أَضْرِبُ جَمِيعَ تُخُومِكَ بِٱلضَّفَادِعِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","فَيَفِيضُ ٱلنَّهْرُ ضَفَادِعَ. فَتَصْعَدُ وَتَدْخُلُ إِلَى بَيْتِكَ وَإِلَى مِخْدَعِ فِرَاشِكَ وَعَلَى سَرِيرِكَ وَإِلَى بُيُوتِ عَبِيدِكَ وَعَلَى شَعْبِكَ وَإِلَى تَنَانِيرِكَ وَإِلَى مَعَاجِنِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","عَلَيْكَ وَعَلَى شَعْبِكَ وَعَبِيدِكَ تَصْعَدُ ٱلضَّفَادِعُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","فَقَالَ ٱلرَّبُّ لِمُوسَى: «قُلْ لِهَارُونَ: مُدَّ يَدَكَ بِعَصَاكَ عَلَى ٱلْأَنْهَارِ وَٱلسَّوَاقِي وَٱلْآجَامِ، وَأَصْعِدِ ٱلضَّفَادِعَ عَلَى أَرْضِ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","فَمَدَّ هَارُونُ يَدَهُ عَلَى مِيَاهِ مِصْرَ، فَصَعِدَتِ ٱلضَّفَادِعُ وَغَطَّتْ أَرْضَ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","وَفَعَلَ كَذَلِكَ ٱلْعَرَّافُونَ بِسِحْرِهِمْ وَأَصْعَدُوا ٱلضَّفَادِعَ عَلَى أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","فَدَعَا فِرْعَوْنُ مُوسَى وَهَارُونَ وَقَالَ: «صَلِّيَا إِلَى ٱلرَّبِّ لِيَرْفَعَ ٱلضَّفَادِعَ عَنِّي وَعَنْ شَعْبِي فَأُطْلِقَ ٱلشَّعْبَ لِيَذْبَحُوا لِلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","فَقَالَ مُوسَى لِفِرْعَوْنَ: «عَيِّنْ لِي مَتَى أُصَلِّي لِأَجْلِكَ وَلِأَجْلِ عَبِيدِكَ وَشَعْبِكَ لِقَطْعِ ٱلضَّفَادِعِ عَنْكَ وَعَنْ بُيُوتِكَ. وَلَكِنَّهَا تَبْقَى فِي ٱلنَّهْرِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","فَقَالَ: «غَدًا». فَقَالَ: «كَقَوْلِكَ. لِكَيْ تَعْرِفَ أَنْ لَيْسَ مِثْلُ ٱلرَّبِّ إِلَهِنَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","فَتَرْتَفِعُ ٱلضَّفَادِعُ عَنْكَ وَعَنْ بُيُوتِكَ وَعَبِيدِكَ وَشَعْبِكَ، وَلَكِنَّهَا تَبْقَى فِي ٱلنَّهْرِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ثُمَّ خَرَجَ مُوسَى وَهَارُونُ مِنْ لَدُنْ فِرْعَوْنَ، وَصَرَخَ مُوسَى إِلَى ٱلرَّبِّ مِنْ أَجْلِ ٱلضَّفَادِعِ ٱلَّتِي جَعَلَهَا عَلَى فِرْعَوْنَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","فَفَعَلَ ٱلرَّبُّ كَقَوْلِ مُوسَى. فَمَاتَتِ ٱلضَّفَادِعُ مِنَ ٱلْبُيُوتِ وَٱلدُّورِ وَٱلْحُقُولِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","وَجَمَعُوهَا كُوَمًا كَثِيرَةً حَتَّى أَنْتَنَتِ ٱلْأَرْضُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","فَلَمَّا رَأَى فِرْعَوْنُ أَنَّهُ قَدْ حَصَلَ ٱلْفَرَجُ أَغْلَظَ قَلْبَهُ وَلَمْ يَسْمَعْ لَهُمَا، كَمَا تَكَلَّمَ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «قُلْ لِهَارُونَ: مُدَّ عَصَاكَ وَٱضْرِبْ تُرَابَ ٱلْأَرْضِ لِيَصِيرَ بَعُوضًا فِي جَمِيعِ أَرْضِ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","فَفَعَلَا كَذَلِكَ. مَدَّ هَارُونُ يَدَهُ بِعَصَاهُ وَضَرَبَ تُرَابَ ٱلْأَرْضِ، فَصَارَ ٱلْبَعُوضُ عَلَى ٱلنَّاسِ وَعَلَى ٱلْبَهَائِمِ. كُلُّ تُرَابِ ٱلْأَرْضِ صَارَ بَعُوضًا فِي جَمِيعِ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","وَفَعَلَ كَذَلِكَ ٱلْعَرَّافُونَ بِسِحْرِهِمْ لِيُخْرِجُوا ٱلْبَعُوضَ فَلَمْ يَسْتَطِيعُوا. وَكَانَ ٱلْبَعُوضُ عَلَى ٱلنَّاسِ وَعَلَى ٱلْبَهَائِمِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","فَقَالَ ٱلْعَرَّافُونَ لِفِرْعَوْنَ: «هَذَا إِصْبَعُ ٱللهِ». وَلَكِنِ ٱشْتَدَّ قَلْبُ فِرْعَوْنَ فَلَمْ يَسْمَعْ لَهُمَا، كَمَا تَكَلَّمَ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «بَكِّرْ فِي ٱلصَّبَاحِ وَقِفْ أَمَامَ فِرْعَوْنَ. إِنَّهُ يَخْرُجُ إِلَى ٱلْمَاءِ. وَقُلْ لَهُ: هَكَذَا يَقُولُ ٱلرَّبُّ: أَطْلِقْ شَعْبِي لِيَعْبُدُونِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","فَإِنَّهُ إِنْ كُنْتَ لَا تُطْلِقُ شَعْبِي، هَا أَنَا أُرْسِلُ عَلَيْكَ وَعَلَى عَبِيدِكَ وَعَلَى شَعْبِكَ وَعَلَى بُيُوتِكَ ٱلذُّبَّانَ، فَتَمْتَلِئُ بُيُوتُ ٱلْمِصْرِيِّينَ ذُبَّانًا. وَأَيْضًا ٱلْأَرْضُ ٱلَّتِي هُمْ عَلَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","وَلَكِنْ أُمَيِّزُ فِي ذَلِكَ ٱلْيَوْمِ أَرْضَ جَاسَانَ حَيْثُ شَعْبِي مُقِيمٌ حَتَّى لَا يَكُونُ هُنَاكَ ذُبَّانٌ. لِكَيْ تَعْلَمَ أَنِّي أَنَا ٱلرَّبُّ فِي ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","وَأَجْعَلُ فَرْقًا بَيْنَ شَعْبِي وَشَعْبِكَ. غَدًا تَكُونُ هَذِهِ ٱلْآيَةُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","فَفَعَلَ ٱلرَّبُّ هَكَذَا، فَدَخَلَتْ ذُبَّانٌ كَثِيرَةٌ إِلَى بَيْتِ فِرْعَوْنَ وَبُيُوتِ عَبِيدِهِ. وَفِي كُلِّ أَرْضِ مِصْرَ خَرِبَتِ ٱلْأَرْضُ مِنَ ٱلذُّبَّانِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","فَدَعَا فِرْعَوْنُ مُوسَى وَهَارُونَ وَقَالَ: «ٱذْهَبُوا ٱذْبَحُوا لِإِلَهِكُمْ فِي هَذِهِ ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","فَقَالَ مُوسَى: «لَا يَصْلَحُ أَنْ نَفْعَلَ هَكَذَا، لِأَنَّنَا إِنَّمَا نَذْبَحُ رِجْسَ ٱلْمِصْرِيِّينَ لِلرَّبِّ إِلَهِنَا. إِنْ ذَبَحْنَا رِجْسَ ٱلْمِصْرِيِّينَ أَمَامَ عُيُونِهِمْ أَفَلَا يَرْجُمُونَنَا؟ ");
INSERT INTO arb_vd_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","نَذْهَبُ سَفَرَ ثَلَاثَةِ أَيَّامٍ فِي ٱلْبَرِّيَّةِ وَنَذْبَحُ لِلرَّبِّ إِلَهِنَا كَمَا يَقُولُ لَنَا». ");
INSERT INTO arb_vd_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","فَقَالَ فِرْعَوْنُ: «أَنَا أُطْلِقُكُمْ لِتَذْبَحُوا لِلرَّبِّ إِلَهِكُمْ فِي ٱلْبَرِّيَّةِ، وَلَكِنْ لَا تَذْهَبُوا بَعِيدًا. صَلِّيَا لِأَجْلِي». ");
INSERT INTO arb_vd_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","فَقَالَ مُوسَى: «هَا أَنَا أَخْرُجُ مِنْ لَدُنْكَ وَأُصَلِّي إِلَى ٱلرَّبِّ، فَتَرْتَفِعُ ٱلذُّبَّانُ عَنْ فِرْعَوْنَ وَعَبِيدِهِ وَشَعْبِهِ غَدًا. وَلَكِنْ لَا يَعُدْ فِرْعَوْنُ يُخَاتِلُ حَتَّى لَا يُطْلِقَ ٱلشَّعْبَ لِيَذْبَحَ لِلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","فَخَرَجَ مُوسَى مِنْ لَدُنْ فِرْعَوْنَ وَصَلَّى إِلَى ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","فَفَعَلَ ٱلرَّبُّ كَقَوْلِ مُوسَى، فَٱرْتَفَعَ ٱلذُّبَّانُ عَنْ فِرْعَوْنَ وَعَبِيدِهِ وَشَعْبِهِ. لَمْ تَبْقَ وَاحِدَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","وَلَكِنْ أَغْلَظَ فِرْعَوْنُ قَلْبَهُ هَذِهِ ٱلْمَرَّةَ أَيْضًا فَلَمْ يُطْلِقِ ٱلشَّعْبَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «ٱدْخُلْ إِلَى فِرْعَوْنَ وَقُلْ لَهُ: هَكَذَا يَقُولُ ٱلرَّبُّ إِلَهُ ٱلْعِبْرَانِيِّينَ: أَطْلِقْ شَعْبِي لِيَعْبُدُونِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","فَإِنَّهُ إِنْ كُنْتَ تَأْبَى أَنْ تُطْلِقَهُمْ وَكُنْتَ تُمْسِكُهُمْ بَعْدُ، ");
INSERT INTO arb_vd_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","فَهَا يَدُ ٱلرَّبِّ تَكُونُ عَلَى مَوَاشِيكَ ٱلَّتِي فِي ٱلْحَقْلِ، عَلَى ٱلْخَيْلِ وَٱلْحَمِيرِ وَٱلْجِمَالِ وَٱلْبَقَرِ وَٱلْغَنَمِ، وَبَأً ثَقِيلًا جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","وَيُمَيِّزُ ٱلرَّبُّ بَيْنَ مَوَاشِي إِسْرَائِيلَ وَمَوَاشِي ٱلْمِصْرِيِّينَ. فَلَا يَمُوتُ مِنْ كُلِّ مَا لِبَنِي إِسْرَائِيلَ شَيْءٌ». ");
INSERT INTO arb_vd_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","وَعَيَّنَ ٱلرَّبُّ وَقْتًا قَائِلًا: «غَدًا يَفْعَلُ ٱلرَّبُّ هَذَا ٱلْأَمْرَ فِي ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","فَفَعَلَ ٱلرَّبُّ هَذَا ٱلْأَمْرَ فِي ٱلْغَدِ. فَمَاتَتْ جَمِيعُ مَوَاشِي ٱلْمِصْرِيِّينَ. وَأَمَّا مَوَاشِي بَنِي إِسْرَائِيلَ فَلَمْ يَمُتْ مِنْهَا وَاحِدٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","وَأَرْسَلَ فِرْعَوْنُ وَإِذَا مَوَاشِي إِسْرَائِيلَ لَمْ يَمُتْ مِنْهَا وَلَا وَاحِدٌ. وَلَكِنْ غَلُظَ قَلْبُ فِرْعَوْنَ فَلَمْ يُطْلِقِ ٱلشَّعْبَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى وَهَارُونَ: «خُذَا مِلْءَ أَيْدِيكُمَا مِنْ رَمَادِ ٱلأَتُونِ، وَلْيُذَرِّهِ مُوسَى نَحْوَ ٱلسَّمَاءِ أَمَامَ عَيْنَيْ فِرْعَوْنَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","لِيَصِيرَ غُبَارًا عَلَى كُلِّ أَرْضِ مِصْرَ. فَيَصِيرَ عَلَى ٱلنَّاسِ وَعَلَى ٱلْبَهَائِمِ دَمَامِلَ طَالِعَةً بِبُثُورٍ فِي كُلِّ أَرْضِ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","فَأَخَذَا رَمَادَ ٱلْأَتُونِ وَوَقَفَا أَمَامَ فِرْعَوْنَ، وَذَرَّاهُ مُوسَى نَحْوَ ٱلسَّمَاءِ، فَصَارَ دَمَامِلَ بُثُورٍ طَالِعَةً فِي ٱلنَّاسِ وَفِي ٱلْبَهَائِمِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","وَلَمْ يَسْتَطِعِ ٱلْعَرَّافُونَ أَنْ يَقِفُوا أَمَامَ مُوسَى مِنْ أَجْلِ ٱلدَّمَامِلِ، لِأَنَّ ٱلدَّمَامِلَ كَانَتْ فِي ٱلْعَرَّافِينَ وَفِي كُلِّ ٱلْمِصْرِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","وَلَكِنْ شَدَّدَ ٱلرَّبُّ قَلْبَ فِرْعَوْنَ فَلَمْ يَسْمَعْ لَهُمَا، كَمَا كَلَّمَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «بَكِّرْ فِي ٱلصَّبَاحِ وَقِفْ أَمَامَ فِرْعَوْنَ وَقُلْ لَهُ: هَكَذَا يَقُولُ ٱلرَّبُّ إِلَهُ ٱلْعِبْرَانِيِّينَ: أَطْلِقْ شَعْبِي لِيَعْبُدُونِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","لِأَنِّي هَذِهِ ٱلْمَرَّةَ أُرْسِلُ جَمِيعَ ضَرَبَاتِي إِلَى قَلْبِكَ وَعَلَى عَبِيدِكَ وَشَعْبِكَ، لِكَيْ تَعْرِفَ أَنْ لَيْسَ مِثْلِي فِي كُلِّ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","فَإِنَّهُ ٱلْآنَ لَوْ كُنْتُ أَمُدُّ يَدِي وَأَضْرِبُكَ وَشَعْبَكَ بِٱلْوَبَإِ، لَكُنْتَ تُبَادُ مِنَ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","وَلَكِنْ لِأَجْلِ هَذَا أَقَمْتُكَ، لِكَيْ أُرِيَكَ قُوَّتِي، وَلِكَيْ يُخْبَرَ بِٱسْمِي فِي كُلِّ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","أَنْتَ مُعَانِدٌ بَعْدُ لِشَعْبِي حَتَّى لَا تُطْلِقَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","هَا أَنَا غَدًا مِثْلَ ٱلْآنَ أُمْطِرُ بَرَدًا عَظِيمًا جِدًّا لَمْ يَكُنْ مِثْلُهُ فِي مِصْرَ مُنْذُ يَوْمِ تَأْسِيسِهَا إِلَى ٱلْآنَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","فَٱلْآنَ أَرْسِلِ ٱحْمِ مَوَاشِيَكَ وَكُلَّ مَا لَكَ فِي ٱلْحَقْلِ. جَمِيعُ ٱلنَّاسِ وَٱلْبَهَائِمِ ٱلَّذِينَ يُوجَدُونَ فِي ٱلْحَقْلِ وَلَا يُجْمَعُونَ إِلَى ٱلْبُيُوتِ، يَنْزِلُ عَلَيْهِمِ ٱلْبَرَدُ فَيَمُوتُونَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","فَٱلَّذِي خَافَ كَلِمَةَ ٱلرَّبِّ مِنْ عَبِيدِ فِرْعَوْنَ هَرَبَ بِعَبِيدِهِ وَمَوَاشِيهِ إِلَى ٱلْبُيُوتِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","وَأَمَّا ٱلَّذِي لَمْ يُوَجِّهْ قَلْبَهُ إِلَى كَلِمَةِ ٱلرَّبِّ فَتَرَكَ عَبِيدَهُ وَمَوَاشِيَهُ فِي ٱلْحَقْلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «مُدَّ يَدَكَ نَحْوَ ٱلسَّمَاءِ لِيَكُونَ بَرَدٌ فِي كُلِّ أَرْضِ مِصْرَ: عَلَى ٱلنَّاسِ وَعَلَى ٱلْبَهَائِمِ وَعَلَى كُلِّ عُشْبِ ٱلْحَقْلِ فِي أَرْضِ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","فَمَدَّ مُوسَى عَصَاهُ نَحْوَ ٱلسَّمَاءِ، فَأَعْطَى ٱلرَّبُّ رُعُودًا وَبَرَدًا، وَجَرَتْ نَارٌ عَلَى ٱلْأَرْضِ، وَأَمْطَرَ ٱلرَّبُّ بَرَدًا عَلَى أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","فَكَانَ بَرَدٌ، وَنَارٌ مُتَوَاصِلَةٌ فِي وَسَطِ ٱلْبَرَدِ. شَيْءٌ عَظِيمٌ جِدًّا لَمْ يَكُنْ مِثْلُهُ فِي كُلِّ أَرْضِ مِصْرَ مُنْذُ صَارَتْ أُمَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","فَضَرَبَ ٱلْبَرَدُ فِي كُلِّ أَرْضِ مِصْرَ جَمِيعَ مَا فِي ٱلْحَقْلِ مِنَ ٱلنَّاسِ وَٱلْبَهَائِمِ. وَضَرَبَ ٱلْبَرَدُ جَمِيعَ عُشْبِ ٱلْحَقْلِ وَكَسَّرَ جَمِيعَ شَجَرِ ٱلْحَقْلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","إِلَّا أَرْضَ جَاسَانَ حَيْثُ كَانَ بَنُو إِسْرَائِيلَ، فَلَمْ يَكُنْ فِيهَا بَرَدٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","فَأَرْسَلَ فِرْعَوْنُ وَدَعَا مُوسَى وَهَارُونَ وَقَالَ لَهُمَا: «أَخْطَأْتُ هَذِهِ ٱلْمَرَّةَ. ٱلرَّبُّ هُوَ ٱلْبَارُّ وَأَنَا وَشَعْبِي ٱلْأَشْرَارُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","صَلِّيَا إِلَى ٱلرَّبِّ، وَكَفَى حُدُوثُ رُعُودِ ٱللهِ وَٱلْبَرَدُ، فَأُطْلِقَكُمْ وَلَا تَعُودُوا تَلْبَثُونَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","فَقَالَ لَهُ مُوسَى: «عِنْدَ خُرُوجِي مِنَ ٱلْمَدِينَةِ أَبْسِطُ يَدَيَّ إِلَى ٱلرَّبِّ، فَتَنْقَطِعُ ٱلرُّعُودُ وَلَا يَكُونُ ٱلْبَرَدُ أَيْضًا، لِكَيْ تَعْرِفَ أَنَّ لِلرَّبِّ ٱلْأَرْضَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","وَأَمَّا أَنْتَ وَعَبِيدُكَ فَأَنَا أَعْلَمُ أَنَّكُمْ لَمْ تَخْشَوْا بَعْدُ مِنَ ٱلرَّبِّ ٱلْإِلَهِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","فَٱلْكَتَّانُ وَٱلشَّعِيرُ ضُرِبَا. لِأَنَّ ٱلشَّعِيرَ كَانَ مُسْبِلًا وَٱلْكَتَّانُ مُبْزِرًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","وَأَمَّا ٱلْحِنْطَةُ وَٱلْقَطَانِيُّ فَلَمْ تُضْرَبْ لِأَنَّهَا كَانَتْ مُتَأَخِّرَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","فَخَرَجَ مُوسَى مِنَ ٱلْمَدِينَةِ مِنْ لَدُنْ فِرْعَوْنَ وَبَسَطَ يَدَيْهِ إِلَى ٱلرَّبِّ، فَٱنْقَطَعَتِ ٱلرُّعُودُ وَٱلْبَرَدُ وَلَمْ يَنْصَبَّ ٱلْمَطَرُ عَلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","وَلَكِنْ فِرْعَوْنُ لَمَّا رَأَى أَنَّ ٱلْمَطَرَ وَٱلْبَرَدَ وَٱلرُّعُودَ ٱنْقَطَعَتْ، عَادَ يُخْطِئُ وَأَغْلَظَ قَلْبَهُ هُوَ وَعَبِيدُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","فَٱشْتَدَّ قَلْبُ فِرْعَوْنَ فَلَمْ يُطْلِقْ بَنِي إِسْرَائِيلَ، كَمَا تَكَلَّمَ ٱلرَّبُّ عَنْ يَدِ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «ٱدْخُلْ إِلَى فِرْعَوْنَ، فَإِنِّي أَغْلَظْتُ قَلْبَهُ وَقُلُوبَ عَبِيدِهِ لِكَيْ أَصْنَعَ آيَاتِي هَذِهِ بَيْنَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","وَلِكَيْ تُخْبِرَ فِي مَسَامِعِ ٱبْنِكَ وَٱبْنِ ٱبْنِكَ بِمَا فَعَلْتُهُ فِي مِصْرَ، وَبِآيَاتِي ٱلَّتِي صَنَعْتُهَا بَيْنَهُمْ، فَتَعْلَمُونَ أَنِّي أَنَا ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","فَدَخَلَ مُوسَى وَهَارُونُ إِلَى فِرْعَوْنَ وَقَالَا لَهُ: «هَكَذَا يَقُولُ ٱلرَّبُّ إِلَهُ ٱلْعِبْرَانِيِّينَ: إِلَى مَتَى تَأْبَى أَنْ تَخْضَعَ لِي؟ أَطْلِقْ شَعْبِي لِيَعْبُدُونِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","فَإِنَّهُ إِنْ كُنْتَ تَأْبَى أَنْ تُطْلِقَ شَعْبِي هَا أَنَا أَجِيءُ غَدًا بِجَرَادٍ عَلَى تُخُومِكَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","فَيُغَطِّي وَجْهَ ٱلْأَرْضِ حَتَّى لَا يُسْتَطَاعَ نَظَرُ ٱلْأَرْضِ. وَيَأْكُلُ ٱلْفَضْلَةَ ٱلسَّالِمَةَ ٱلْبَاقِيَةَ لَكُمْ مِنَ ٱلْبَرَدِ. وَيَأْكُلُ جَمِيعَ ٱلشَّجَرِ ٱلنَّابِتِ لَكُمْ مِنَ ٱلْحَقْلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","وَيَمْلَأُ بُيُوتَكَ وَبُيُوتَ جَمِيعِ عَبِيدِكَ وَبُيُوتَ جَمِيعِ ٱلْمِصْرِيِّينَ، ٱلْأَمْرُ ٱلَّذِي لَمْ يَرَهُ آبَاؤُكَ وَلَا آبَاءُ آبَائِكَ مُنْذُ يَوْمَ وُجِدُوا عَلَى ٱلْأَرْضِ إِلَى هَذَا ٱلْيَوْمِ». ثُمَّ تَحَوَّلَ وَخَرَجَ مِنْ لَدُنْ فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","فَقَالَ عَبِيدُ فِرْعَوْنَ لَهُ: «إِلَى مَتَى يَكُونُ هَذَا لَنَا فَخًّا؟ أَطْلِقِ ٱلرِّجَالَ لِيَعْبُدُوا ٱلرَّبَّ إِلَهَهُمْ. أَلَمْ تَعْلَمْ بَعْدُ أَنَّ مِصْرَ قَدْ خَرِبَتْ؟». ");
INSERT INTO arb_vd_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","فَرُدَّ مُوسَى وَهَارُونُ إِلَى فِرْعَوْنَ، فَقَالَ لَهُمَا: «ٱذْهَبُوا ٱعْبُدُوا ٱلرَّبَّ إِلَهَكُمْ. وَلَكِنْ مَنْ وَمَنْ هُمُ ٱلَّذِينَ يَذْهَبُونَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","فَقَالَ مُوسَى: «نَذْهَبُ بِفِتْيَانِنَا وَشُيُوخِنَا. نَذْهَبُ بِبَنِينَا وَبَنَاتِنَا، بِغَنَمِنَا وَبَقَرِنَا، لِأَنَّ لَنَا عِيدًا لِلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","فَقَالَ لَهُمَا: «يَكُونُ ٱلرَّبُّ مَعَكُمْ هَكَذَا كَمَا أُطْلِقُكُمْ وَأَوْلَادَكُمُ. ٱنْظُرُوا، إِنَّ قُدَّامَ وُجُوهِكُمْ شَرًّا. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","لَيْسَ هَكَذَا. اِذْهَبُوا أَنْتُمُ ٱلرِّجَالَ وَٱعْبُدُوا ٱلرَّبَّ. لِأَنَّكُمْ لِهَذَا طَالِبُونَ». فَطُرِدَا مِنْ لَدُنْ فِرْعَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «مُدَّ يَدَكَ عَلَى أَرْضِ مِصْرَ لِأَجْلِ ٱلْجَرَادِ، لِيَصْعَدَ عَلَى أَرْضِ مِصْرَ وَيَأْكُلَ كُلَّ عُشْبِ ٱلْأَرْضِ، كُلَّ مَا تَرَكَهُ ٱلْبَرَدُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","فَمَدَّ مُوسَى عَصَاهُ عَلَى أَرْضِ مِصْرَ، فَجَلَبَ ٱلرَّبُّ عَلَى ٱلْأَرْضِ رِيحًا شَرْقِيَّةً كُلَّ ذَلِكَ ٱلنَّهَارِ وَكُلَّ ٱللَّيْلِ. وَلَمَّا كَانَ ٱلصَّبَاحُ، حَمَلَتِ ٱلرِّيحُ ٱلشَّرْقِيَّةُ ٱلْجَرَادَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","فَصَعِدَ ٱلْجَرَادُ عَلَى كُلِّ أَرْضِ مِصْرَ، وَحَلَّ فِي جَمِيعِ تُخُومِ مِصْرَ. شَيْءٌ ثَقِيلٌ جِدًّا لَمْ يَكُنْ قَبْلَهُ جَرَادٌ هَكَذَا مِثْلَهُ، وَلَا يَكُونُ بَعْدَهُ كَذَلِكَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","وَغَطَّى وَجْهَ كُلِّ ٱلْأَرْضِ حَتَّى أَظْلَمَتِ ٱلْأَرْضُ. وَأَكَلَ جَمِيعَ عُشْبِ ٱلْأَرْضِ وَجَمِيعَ ثَمَرِ ٱلشَّجَرِ ٱلَّذِي تَرَكَهُ ٱلْبَرَدُ، حَتَّى لَمْ يَبْقَ شَيْءٌ أَخْضَرُ فِي ٱلشَّجَرِ وَلَا فِي عُشْبِ ٱلْحَقْلِ فِي كُلِّ أَرْضِ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","فَدَعَا فِرْعَوْنُ مُوسَى وَهَارُونَ مُسْرِعًا وَقَالَ: «أَخْطَأْتُ إِلَى ٱلرَّبِّ إِلَهِكُمَا وَإِلَيْكُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","وَٱلْآنَ ٱصْفَحَا عَنْ خَطِيَّتِي هَذِهِ ٱلْمَرَّةَ فَقَطْ، وَصَلِّيَا إِلَى ٱلرَّبِّ إِلَهِكُمَا لِيَرْفَعَ عَنِّي هَذَا ٱلْمَوْتَ فَقَطْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","فَخَرَجَ مُوسَى مِنْ لَدُنْ فِرْعَوْنَ وَصَلَّى إِلَى ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","فَرَدَّ ٱلرَّبُّ رِيحًا غَرْبِيَّةً شَدِيدَةً جِدًّا، فَحَمَلَتِ ٱلْجَرَادَ وَطَرَحَتْهُ إِلَى بَحْرِ سُوفَ. لَمْ تَبْقَ جَرَادَةٌ وَاحِدَةٌ فِي كُلِّ تُخُومِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","وَلَكِنْ شَدَّدَ ٱلرَّبُّ قَلْبَ فِرْعَوْنَ فَلَمْ يُطْلِقْ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «مُدَّ يَدَكَ نَحْوَ ٱلسَّمَاءِ لِيَكُونَ ظَلَامٌ عَلَى أَرْضِ مِصْرَ، حَتَّى يُلْمَسُ ٱلظَّلَامُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","فَمَدَّ مُوسَى يَدَهُ نَحْوَ ٱلسَّمَاءِ فَكَانَ ظَلَامٌ دَامِسٌ فِي كُلِّ أَرْضِ مِصْرَ ثَلَاثَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","لَمْ يُبْصِرْ أَحَدٌ أَخَاهُ، وَلَا قَامَ أَحَدٌ مِنْ مَكَانِهِ ثَلَاثَةَ أَيَّامٍ. وَلَكِنْ جَمِيعُ بَنِي إِسْرَائِيلَ كَانَ لَهُمْ نُورٌ فِي مَسَاكِنِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","فَدَعَا فِرْعَوْنُ مُوسَى وَقَالَ: «ٱذْهَبُوا ٱعْبُدُوا ٱلرَّبَّ. غَيْرَ أَنَّ غَنَمَكُمْ وَبَقَرَكُمْ تَبْقَى. أَوْلَادُكُمْ أَيْضًا تَذْهَبُ مَعَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","فَقَالَ مُوسَى: «أَنْتَ تُعْطِي أَيْضًا فِي أَيْدِينَا ذَبَائِحَ وَمُحْرَقَاتٍ لِنَصْنَعَهَا لِلرَّبِّ إِلَهِنَا، ");
INSERT INTO arb_vd_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","فَتَذْهَبُ مَوَاشِينَا أَيْضًا مَعَنَا. لَا يَبْقَى ظِلْفٌ. لِأَنَّنَا مِنْهَا نَأْخُذُ لِعِبَادَةِ ٱلرَّبِّ إِلَهِنَا. وَنَحْنُ لَا نَعْرِفُ بِمَاذَا نَعْبُدُ ٱلرَّبَّ حَتَّى نَأْتِيَ إِلَى هُنَاكَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","وَلَكِنْ شَدَّدَ ٱلرَّبُّ قَلْبَ فِرْعَوْنَ فَلَمْ يَشَأْ أَنْ يُطْلِقَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","وَقَالَ لَهُ فِرْعَوْنُ: «ٱذْهَبْ عَنِّي. اِحْتَرِزْ. لَا تَرَ وَجْهِي أَيْضًا. إِنَّكَ يَوْمَ تَرَى وَجْهِي تَمُوتُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","فَقَالَ مُوسَى: «نِعِمَّا قُلْتَ. أَنَا لَا أَعُودُ أَرَى وَجْهَكَ أَيْضًا». ");
INSERT INTO arb_vd_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «ضَرْبَةً وَاحِدَةً أَيْضًا أَجْلِبُ عَلَى فِرْعَوْنَ وَعَلَى مِصْرَ. بَعْدَ ذَلِكَ يُطْلِقُكُمْ مِنْ هُنَا. وَعِنْدَمَا يُطْلِقُكُمْ يَطْرُدُكُمْ طَرْدًا مِنْ هُنَا بِٱلتَّمَامِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","تَكَلَّمْ فِي مَسَامِعِ ٱلشَّعْبِ أَنْ يَطْلُبَ كُلُّ رَجُلٍ مِنْ صَاحِبِهِ، وَكُلُّ ٱمْرَأَةٍ مِنْ صَاحِبَتِهَا أَمْتِعَةَ فِضَّةٍ وَأَمْتِعَةَ ذَهَبٍ». ");
INSERT INTO arb_vd_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","وَأَعْطَى ٱلرَّبُّ نِعْمَةً لِلشَّعْبِ فِي عُيُونِ ٱلْمِصْرِيِّينَ. وَأَيْضًا ٱلرَّجُلُ مُوسَى كَانَ عَظِيمًا جِدًّا فِي أَرْضِ مِصْرَ فِي عُيُونِ عَبِيدِ فِرْعَوْنَ وَعُيُونِ ٱلشَّعْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","وَقَالَ مُوسَى: «هَكَذَا يَقُولُ ٱلرَّبُّ: إِنِّي نَحْوَ نِصْفِ ٱللَّيْلِ أَخْرُجُ فِي وَسَطِ مِصْرَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","فَيَمُوتُ كُلُّ بِكْرٍ فِي أَرْضِ مِصْرَ، مِنْ بِكْرِ فِرْعَوْنَ ٱلْجَالِسِ عَلَى كُرْسِيِّهِ إِلَى بِكْرِ ٱلْجَارِيَةِ ٱلَّتِي خَلْفَ ٱلرَّحَى، وَكُلُّ بِكْرِ بَهِيمَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","وَيَكُونُ صُرَاخٌ عَظِيمٌ فِي كُلِّ أَرْضِ مِصْرَ لَمْ يَكُنْ مِثْلُهُ وَلَا يَكُونُ مِثْلُهُ أَيْضًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","وَلَكِنْ جَمِيعُ بَنِي إِسْرَائِيلَ لَا يُسَنِّنُ كَلْبٌ لِسَانَهُ إِلَيْهِمْ، لَا إِلَى ٱلنَّاسِ وَلَا إِلَى ٱلْبَهَائِمِ. لِكَيْ تَعْلَمُوا أَنَّ ٱلرَّبَّ يُمَيِّزُ بَيْنَ ٱلْمِصْرِيِّينَ وَإِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","فَيَنْزِلُ إِلَيَّ جَمِيعُ عَبِيدِكَ هَؤُلَاءِ، وَيَسْجُدُونَ لِي قَائِلِينَ: ٱخْرُجْ أَنْتَ وَجَمِيعُ ٱلشَّعْبِ ٱلَّذِينَ فِي أَثَرِكَ. وَبَعْدَ ذَلِكَ أَخْرُجُ». ثُمَّ خَرَجَ مِنْ لَدُنْ فِرْعَوْنَ فِي حُمُوِّ ٱلْغَضَبِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","وَقَالَ ٱلرَّبُّ لِمُوسَى: «لَا يَسْمَعُ لَكُمَا فِرْعَوْنُ لِكَيْ تَكْثُرَ عَجَائِبِي فِي أَرْضِ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","وَكَانَ مُوسَى وَهَارُونُ يَفْعَلَانِ كُلَّ هَذِهِ ٱلْعَجَائِبِ أَمَامَ فِرْعَوْنَ، وَلَكِنْ شَدَّدَ ٱلرَّبُّ قَلْبَ فِرْعَوْنَ، فَلَمْ يُطْلِقْ بَنِي إِسْرَائِيلَ مِنْ أَرْضِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ فِي أَرْضِ مِصْرَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«هَذَا ٱلشَّهْرُ يَكُونُ لَكُمْ رَأْسَ ٱلشُّهُورِ. هُوَ لَكُمْ أَوَّلُ شُهُورِ ٱلسَّنَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","كَلِّمَا كُلَّ جَمَاعَةِ إِسْرَائِيلَ قَائِلَيْنِ: فِي ٱلْعَاشِرِ مِنْ هَذَا ٱلشَّهْرِ يَأْخُذُونَ لَهُمْ كُلُّ وَاحِدٍ شَاةً بِحَسَبِ بُيُوتِ ٱلْآبَاءِ، شَاةً لِلْبَيْتِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","وَإِنْ كَانَ ٱلْبَيْتُ صَغِيرًا عَنْ أَنْ يَكُونَ كُفْوًا لِشَاةٍ، يَأْخُذُ هُوَ وَجَارُهُ ٱلْقَرِيبُ مِنْ بَيْتِهِ بِحَسَبِ عَدَدِ ٱلنُّفُوسِ. كُلُّ وَاحِدٍ عَلَى حَسَبِ أُكْلِهِ تَحْسُبُونَ لِلشَّاةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","تَكُونُ لَكُمْ شَاةً صَحِيحَةً ذَكَرًا ٱبْنَ سَنَةٍ، تَأْخُذُونَهُ مِنَ ٱلْخِرْفَانِ أَوْ مِنَ ٱلْمَوَاعِزِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","وَيَكُونُ عِنْدَكُمْ تَحْتَ ٱلْحِفْظِ إِلَى ٱلْيَوْمِ ٱلرَّابِعَ عَشَرَ مِنْ هَذَا ٱلشَّهْرِ. ثُمَّ يَذْبَحُهُ كُلُّ جُمْهُورِ جَمَاعَةِ إِسْرَائِيلَ فِي ٱلْعَشِيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","وَيَأْخُذُونَ مِنَ ٱلدَّمِ وَيَجْعَلُونَهُ عَلَى ٱلْقَائِمَتَيْنِ وَٱلْعَتَبَةِ ٱلْعُلْيَا فِي ٱلْبُيُوتِ ٱلَّتِي يَأْكُلُونَهُ فِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","وَيَأْكُلُونَ ٱللَّحْمَ تِلْكَ ٱللَّيْلَةَ مَشْوِيًّا بِٱلنَّارِ مَعَ فَطِيرٍ. عَلَى أَعْشَابٍ مُرَّةٍ يَأْكُلُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","لَا تَأْكُلُوا مِنْهُ نِيئًا أَوْ طَبِيخًا مَطْبُوخًا بِٱلْمَاءِ، بَلْ مَشْوِيًّا بِٱلنَّارِ. رَأْسَهُ مَعَ أَكَارِعِهِ وَجَوْفِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","وَلَا تُبْقُوا مِنْهُ إِلَى ٱلصَّبَاحِ. وَٱلْبَاقِي مِنْهُ إِلَى ٱلصَّبَاحِ، تُحْرِقُونَهُ بِٱلنَّارِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","وَهَكَذَا تَأْكُلُونَهُ: أَحْقَاؤُكُمْ مَشْدُودَةٌ، وَأَحْذِيَتُكُمْ فِي أَرْجُلِكُمْ، وَعِصِيُّكُمْ فِي أَيْدِيكُمْ. وَتَأْكُلُونَهُ بِعَجَلَةٍ. هُوَ فِصْحٌ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","فَإِنِّي أَجْتَازُ فِي أَرْضِ مِصْرَ هَذِهِ ٱللَّيْلَةَ، وَأَضْرِبُ كُلَّ بِكْرٍ فِي أَرْضِ مِصْرَ مِنَ ٱلنَّاسِ وَٱلْبَهَائِمِ. وَأَصْنَعُ أَحْكَامًا بِكُلِّ آلِهَةِ ٱلْمِصْرِيِّينَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","وَيَكُونُ لَكُمُ ٱلدَّمُ عَلَامَةً عَلَى ٱلْبُيُوتِ ٱلَّتِي أَنْتُمْ فِيهَا، فَأَرَى ٱلدَّمَ وَأَعْبُرُ عَنْكُمْ، فَلَا يَكُونُ عَلَيْكُمْ ضَرْبَةٌ لِلْهَلَاكِ حِينَ أَضْرِبُ أَرْضَ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","وَيَكُونُ لَكُمْ هَذَا ٱلْيَوْمُ تَذْكَارًا فَتُعَيِّدُونَهُ عِيدًا لِلرَّبِّ. فِي أَجْيَالِكُمْ تُعَيِّدُونَهُ فَرِيضَةً أَبَدِيَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«سَبْعَةَ أَيَّامٍ تَأْكُلُونَ فَطِيرًا. ٱلْيَوْمَ ٱلْأَوَّلَ تَعْزِلُونَ ٱلْخَمِيرَ مِنْ بُيُوتِكُمْ، فَإِنَّ كُلَّ مَنْ أَكَلَ خَمِيرًا مِنَ ٱلْيَوْمِ ٱلْأَوَّلِ إِلَى ٱلْيَوْمِ ٱلسَّابِعِ تُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","وَيَكُونُ لَكُمْ فِي ٱلْيَوْمِ ٱلْأَوَّلِ مَحْفَلٌ مُقَدَّسٌ، وَفِي ٱلْيَوْمِ ٱلسَّابِعِ مَحْفَلٌ مُقَدَّسٌ. لَا يُعْمَلُ فِيهِمَا عَمَلٌ مَا إِلَّا مَا تَأْكُلُهُ كُلُّ نَفْسٍ، فَذَلِكَ وَحْدَهُ يُعْمَلُ مِنْكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","وَتَحْفَظُونَ ٱلْفَطِيرَ لِأَنِّي فِي هَذَا ٱلْيَوْمِ عَيْنِهِ أَخْرَجْتُ أَجْنَادَكُمْ مِنْ أَرْضِ مِصْرَ، فَتَحْفَظُونَ هَذَا ٱلْيَوْمَ فِي أَجْيَالِكُمْ فَرِيضَةً أَبَدِيَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","فِي ٱلشَّهْرِ ٱلْأَوَّلِ، فِي ٱلْيَوْمِ ٱلرَّابِعَ عَشَرَ مِنَ ٱلشَّهْرِ، مَسَاءً، تَأْكُلُونَ فَطِيرًا إِلَى ٱلْيَوْمِ ٱلْحَادِي وَٱلْعِشْرِينَ مِنَ ٱلشَّهْرِ مَسَاءً. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","سَبْعَةَ أَيَّامٍ لَا يُوجَدْ خَمِيرٌ فِي بُيُوتِكُمْ. فَإِنَّ كُلَّ مَنْ أَكَلَ مُخْتَمِرًا تُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ جَمَاعَةِ إِسْرَائِيلَ، ٱلْغَرِيبُ مَعَ مَوْلُودِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","لَا تَأْكُلُوا شَيْئًا مُخْتَمِرًا. فِي جَمِيعِ مَسَاكِنِكُمْ تَأْكُلُونَ فَطِيرًا». ");
INSERT INTO arb_vd_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","فَدَعَا مُوسَى جَمِيعَ شُيُوخِ إِسْرَائِيلَ وَقَالَ لَهُمُ: «ٱسْحَبُوا وَخُذُوا لَكُمْ غَنَمًا بِحَسَبِ عَشَائِرِكُمْ وَٱذْبَحُوا ٱلْفِصْحَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","وَخُذُوا بَاقَةَ زُوفَا وَٱغْمِسُوهَا فِي ٱلدَّمِ ٱلَّذِي فِي ٱلطَّسْتِ وَمُسُّوا ٱلْعَتَبَةَ ٱلْعُلْيَا وَٱلْقَائِمَتَيْنِ بِٱلدَّمِ ٱلَّذِي فِي ٱلطَّسْتِ. وَأَنْتُمْ لَا يَخْرُجْ أَحَدٌ مِنْكُمْ مِنْ بَابِ بَيْتِهِ حَتَّى ٱلصَّبَاحِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","فَإِنَّ ٱلرَّبَّ يَجْتَازُ لِيَضْرِبَ ٱلْمِصْرِيِّينَ. فَحِينَ يَرَى ٱلدَّمَ عَلَى ٱلْعَتَبَةِ ٱلْعُلْيَا وَٱلْقَائِمَتَيْنِ يَعْبُرُ ٱلرَّبُّ عَنِ ٱلْبَابِ وَلَا يَدَعُ ٱلْمُهْلِكَ يَدْخُلُ بُيُوتَكُمْ لِيَضْرِبَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","فَتَحْفَظُونَ هَذَا ٱلْأَمْرَ فَرِيضَةً لَكَ وَلِأَوْلَادِكَ إِلَى ٱلْأَبَدِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","وَيَكُونُ حِينَ تَدْخُلُونَ ٱلْأَرْضَ ٱلَّتِي يُعْطِيكُمُ ٱلرَّبُّ كَمَا تَكَلَّمَ، أَنَّكُمْ تَحْفَظُونَ هَذِهِ ٱلْخِدْمَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","وَيَكُونُ حِينَ يَقُولُ لَكُمْ أَوْلَادُكُمْ: مَا هَذِهِ ٱلْخِدْمَةُ لَكُمْ؟ ");
INSERT INTO arb_vd_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","أَنَّكُمْ تَقُولُونَ: هِيَ ذَبِيحَةُ فِصْحٍ لِلرَّبِّ ٱلَّذِي عَبَرَ عَنْ بُيُوتِ بَنِي إِسْرَائِيلَ فِي مِصْرَ لَمَّا ضَرَبَ ٱلْمِصْرِيِّينَ وَخَلَّصَ بُيُوتَنَا». فَخَرَّ ٱلشَّعْبُ وَسَجَدُوا. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","وَمَضَى بَنُو إِسْرَائِيلَ وَفَعَلُوا كَمَا أَمَرَ ٱلرَّبُّ مُوسَى وَهَارُونَ. هَكَذَا فَعَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","فَحَدَثَ فِي نِصْفِ ٱللَّيْلِ أَنَّ ٱلرَّبَّ ضَرَبَ كُلَّ بِكْرٍ فِي أَرْضِ مِصْرَ، مِنْ بِكْرِ فِرْعَوْنَ ٱلْجَالِسِ عَلَى كُرْسِيِّهِ إِلَى بِكْرِ ٱلْأَسِيرِ ٱلَّذِي فِي ٱلسِّجْنِ، وَكُلَّ بِكْرِ بَهِيمَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","فَقَامَ فِرْعَوْنُ لَيْلًا هُوَ وَكُلُّ عَبِيدِهِ وَجَمِيعُ ٱلْمِصْرِيِّينَ. وَكَانَ صُرَاخٌ عَظِيمٌ فِي مِصْرَ، لِأَنَّهُ لَمْ يَكُنْ بَيْتٌ لَيْسَ فِيهِ مَيْتٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","فَدَعَا مُوسَى وَهَارُونَ لَيْلًا وَقَالَ: «قُومُوا ٱخْرُجُوا مِنْ بَيْنِ شَعْبِي أَنْتُمَا وَبَنُو إِسْرَائِيلَ جَمِيعًا، وَٱذْهَبُوا ٱعْبُدُوا ٱلرَّبَّ كَمَا تَكَلَّمْتُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","خُذُوا غَنَمَكُمْ أَيْضًا وَبَقَرَكُمْ كَمَا تَكَلَّمْتُمْ وَٱذْهَبُوا. وَبَارِكُونِي أَيْضًا». ");
INSERT INTO arb_vd_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","وَأَلَحَّ ٱلْمِصْرِيُّونَ عَلَى ٱلشَّعْبِ لِيُطْلِقُوهُمْ عَاجِلًا مِنَ ٱلْأَرْضِ، لِأَنَّهُمْ قَالُوا: «جَمِيعُنَا أَمْوَاتٌ». ");
INSERT INTO arb_vd_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","فَحَمَلَ ٱلشَّعْبُ عَجِينَهُمْ قَبْلَ أَنْ يَخْتَمِرَ، وَمَعَاجِنُهُمْ مَصْرُورَةٌ فِي ثِيَابِهِمْ عَلَى أَكْتَافِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","وَفَعَلَ بَنُو إِسْرَائِيلَ بِحَسَبِ قَوْلِ مُوسَى. طَلَبُوا مِنَ ٱلْمِصْرِيِّينَ أَمْتِعَةَ فِضَّةٍ وَأَمْتِعَةَ ذَهَبٍ وَثِيَابًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","وَأَعْطَى ٱلرَّبُّ نِعْمَةً لِلشَّعْبِ فِي عُيُونِ ٱلْمِصْرِيِّينَ حَتَّى أَعَارُوهُمْ. فَسَلَبُوا ٱلْمِصْرِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","فَٱرْتَحَلَ بَنُو إِسْرَائِيلَ مِنْ رَعَمْسِيسَ إِلَى سُكُّوتَ، نَحْوَ سِتِّ مِئَةِ أَلْفِ مَاشٍ مِنَ ٱلرِّجَالِ عَدَا ٱلْأَوْلَادِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","وَصَعِدَ مَعَهُمْ لَفِيفٌ كَثِيرٌ أَيْضًا مَعَ غَنَمٍ وَبَقَرٍ، مَوَاشٍ وَافِرَةٍ جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","وَخَبَزُوا ٱلْعَجِينَ ٱلَّذِي أَخْرَجُوهُ مِنْ مِصْرَ خُبْزَ مَلَّةٍ فَطِيرًا، إِذْ كَانَ لَمْ يَخْتَمِرْ. لِأَنَّهُمْ طُرِدُوا مِنْ مِصْرَ وَلَمْ يَقْدِرُوا أَنْ يَتَأَخَّرُوا، فَلَمْ يَصْنَعُوا لِأَنْفُسِهِمْ زَادًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","وَأَمَّا إِقَامَةُ بَنِي إِسْرَائِيلَ ٱلَّتِي أَقَامُوهَا فِي مِصْرَ فَكَانَتْ أَرْبَعَ مِئَةٍ وَثَلَاثِينَ سَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","وَكَانَ عِنْدَ نِهَايَةِ أَرْبَعِ مِئَةٍ وَثَلَاثِينَ سَنَةً، فِي ذَلِكَ ٱلْيَوْمِ عَيْنِهِ، أَنَّ جَمِيعَ أَجْنَادِ ٱلرَّبِّ خَرَجَتْ مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","هِيَ لَيْلَةٌ تُحْفَظُ لِلرَّبِّ لِإِخْرَاجِهِ إِيَّاهُمْ مِنْ أَرْضِ مِصْرَ. هَذِهِ ٱللَّيْلَةُ هِيَ لِلرَّبِّ. تُحْفَظُ مِنْ جَمِيعِ بَنِي إِسْرَائِيلَ فِي أَجْيَالِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","وَقَالَ ٱلرَّبُّ لِمُوسَى وَهَارُونَ: «هَذِهِ فَرِيضَةُ ٱلْفِصْحِ: كُلُّ ٱبْنِ غَرِيبٍ لَا يَأْكُلُ مِنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","وَلَكِنْ كُلُّ عَبْدِ رَجُلٍ مُبْتَاعٍ بِفِضَّةٍ تَخْتِنُهُ ثُمَّ يَأْكُلُ مِنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ٱلنَّزِيلُ وَٱلْأَجِيرُ لَا يَأْكُلَانِ مِنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","فِي بَيْتٍ وَاحِدٍ يُؤْكَلُ. لَا تُخْرِجْ مِنَ ٱللَّحْمِ مِنَ ٱلْبَيْتِ إِلَى خَارِجٍ، وَعَظْمًا لَا تَكْسِرُوا مِنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","كُلُّ جَمَاعَةِ إِسْرَائِيلَ يَصْنَعُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","وَإِذَا نَزَلَ عِنْدَكَ نَزِيلٌ وَصَنَعَ فِصْحًا لِلرَّبِّ، فَلْيُخْتَنْ مِنْهُ كُلُّ ذَكَرٍ، ثُمَّ يَتَقَدَّمُ لِيَصْنَعَهُ، فَيَكُونُ كَمَوْلُودِ ٱلْأَرْضِ. وَأَمَّا كُلُّ أَغْلَفَ فَلَا يَأْكُلُ مِنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","تَكُونُ شَرِيعَةٌ وَاحِدَةٌ لِمَوْلُودِ ٱلْأَرْضِ وَلِلنَّزِيلِ ٱلنَّازِلِ بَيْنَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","فَفَعَلَ جَمِيعُ بَنِي إِسْرَائِيلَ كَمَا أَمَرَ ٱلرَّبُّ مُوسَى وَهَارُونَ. هَكَذَا فَعَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","وَكَانَ فِي ذَلِكَ ٱلْيَوْمِ عَيْنِهِ أَنَّ ٱلرَّبَّ أَخْرَجَ بَنِي إِسْرَائِيلَ مِنْ أَرْضِ مِصْرَ بِحَسَبِ أَجْنَادِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«قَدِّسْ لِي كُلَّ بِكْرٍ، كُلَّ فَاتِحِ رَحِمٍ مِنْ بَنِي إِسْرَائِيلَ، مِنَ ٱلنَّاسِ وَمِنَ ٱلْبَهَائِمِ. إِنَّهُ لِي». ");
INSERT INTO arb_vd_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","وَقَالَ مُوسَى لِلشَّعْبِ: «ٱذْكُرُوا هَذَا ٱلْيَوْمَ ٱلَّذِي فِيهِ خَرَجْتُمْ مِنْ مِصْرَ مِنْ بَيْتِ ٱلْعُبُودِيَّةِ، فَإِنَّهُ بِيَدٍ قَوِيَّةٍ أَخْرَجَكُمُ ٱلرَّبُّ مِنْ هُنَا. وَلَا يُؤْكَلُ خَمِيرٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","اَلْيَوْمَ أَنْتُمْ خَارِجُونَ فِي شَهْرِ أَبِيبَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","وَيَكُونُ مَتَى أَدْخَلَكَ ٱلرَّبُّ أَرْضَ ٱلْكَنْعَانِيِّينَ وَٱلْحِثِّيِّينَ وَٱلْأَمُورِيِّينَ وَٱلْحِوِّيِّينَ وَٱلْيَبُوسِيِّينَ ٱلَّتِي حَلَفَ لِآبَائِكَ أَنْ يُعْطِيَكَ، أَرْضًا تَفِيضُ لَبَنًا وَعَسَلًا، أَنَّكَ تَصْنَعُ هَذِهِ ٱلْخِدْمَةَ فِي هَذَا ٱلشَّهْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","سَبْعَةَ أَيَّامٍ تَأْكُلُ فَطِيرًا، وَفِي ٱلْيَوْمِ ٱلسَّابِعِ عِيدٌ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","فَطِيرٌ يُؤْكَلُ ٱلسَّبْعَةَ ٱلْأَيَّامِ، وَلَا يُرَى عِنْدَكَ مُخْتَمِرٌ، وَلَا يُرَى عِنْدَكَ خَمِيرٌ فِي جَمِيعِ تُخُومِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","«وَتُخْبِرُ ٱبْنَكَ فِي ذَلِكَ ٱلْيَوْمِ قَائِلًا: مِنْ أَجْلِ مَا صَنَعَ إِلَيَّ ٱلرَّبُّ حِينَ أَخْرَجَنِي مِنْ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","وَيَكُونُ لَكَ عَلَامَةً عَلَى يَدِكَ، وَتَذْكَارًا بَيْنَ عَيْنَيْكَ، لِكَيْ تَكُونَ شَرِيعَةُ ٱلرَّبِّ فِي فَمِكَ. لِأَنَّهُ بِيَدٍ قَوِيَّةٍ أَخْرَجَكَ ٱلرَّبُّ مِنْ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","فَتَحْفَظُ هَذِهِ ٱلْفَرِيضَةَ فِي وَقْتِهَا مِنْ سَنَةٍ إِلَى سَنَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«وَيَكُونُ مَتَى أَدْخَلَكَ ٱلرَّبُّ أَرْضَ ٱلْكَنْعَانِيِّينَ كَمَا حَلَفَ لَكَ وَلِآبَائِكَ، وَأَعْطَاكَ إِيَّاهَا، ");
INSERT INTO arb_vd_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","أَنَّكَ تُقَدِّمُ لِلرَّبِّ كُلَّ فَاتِحِ رَحِمٍ، وَكُلَّ بِكْرٍ مِنْ نِتَاجِ ٱلْبَهَائِمِ ٱلَّتِي تَكُونُ لَكَ. ٱلذُّكُورُ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","وَلَكِنَّ كُلَّ بِكْرِ حِمَارٍ تَفْدِيهِ بِشَاةٍ. وَإِنْ لَمْ تَفْدِهِ فَتَكْسِرُ عُنُقَهُ. وَكُلُّ بِكْرِ إِنْسَانٍ مِنْ أَوْلَادِكَ تَفْدِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","«وَيَكُونُ مَتَى سَأَلَكَ ٱبْنُكَ غَدًا قَائِلًا: مَا هَذَا؟ تَقُولُ لَهُ: بِيَدٍ قَوِيَّةٍ أَخْرَجَنَا ٱلرَّبُّ مِنْ مِصْرَ مِنْ بَيْتِ ٱلْعُبُودِيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","وَكَانَ لَمَّا تَقَسَّى فِرْعَوْنُ عَنْ إِطْلَاقِنَا أَنَّ ٱلرَّبَّ قَتَلَ كُلَّ بِكْرٍ فِي أَرْضِ مِصْرَ، مِنْ بِكْرِ ٱلنَّاسِ إِلَى بِكْرِ ٱلْبَهَائِمِ. لِذَلِكَ أَنَا أَذْبَحُ لِلرَّبِّ ٱلذُّكُورَ مِنْ كُلِّ فَاتِحِ رَحِمٍ، وَأَفْدِي كُلَّ بِكْرٍ مِنْ أَوْلَادِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","فَيَكُونُ عَلَامَةً عَلَى يَدِكَ، وَعِصَابَةً بَيْنَ عَيْنَيْكَ. لِأَنَّهُ بِيَدٍ قَوِيَّةٍ أَخْرَجَنَا ٱلرَّبُّ مِنْ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","وَكَانَ لَمَّا أَطْلَقَ فِرْعَوْنُ ٱلشَّعْبَ أَنَّ ٱللهَ لَمْ يَهْدِهِمْ فِي طَرِيقِ أَرْضِ ٱلْفِلِسْطِينِيِّينَ مَعَ أَنَّهَا قَرِيبَةٌ، لِأَنَّ ٱللهَ قَالَ: «لِئَلَّا يَنْدَمَ ٱلشَّعْبُ إِذَا رَأَوْا حَرْبًا وَيَرْجِعُوا إِلَى مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","فَأَدَارَ ٱللهُ ٱلشَّعْبَ فِي طَرِيقِ بَرِّيَّةِ بَحْرِ سُوفٍ. وَصَعِدَ بَنُو إِسْرَائِيلَ مُتَجَهِّزِينَ مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","وَأَخَذَ مُوسَى عِظَامَ يُوسُفَ مَعَهُ، لِأَنَّهُ كَانَ قَدِ ٱسْتَحْلَفَ بَنِي إِسْرَائِيلَ بِحَلْفٍ قَائِلًا: «إِنَّ ٱللهَ سَيَفْتَقِدُكُمْ فَتُصْعِدُونَ عِظَامِي مِنْ هُنَا مَعَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","وَٱرْتَحَلُوا مِنْ سُكُّوتَ وَنَزَلُوا فِي إِيثَامَ فِي طَرَفِ ٱلْبَرِّيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","وَكَانَ ٱلرَّبُّ يَسِيرُ أَمَامَهُمْ نَهَارًا فِي عَمُودِ سَحَابٍ لِيَهْدِيَهُمْ فِي ٱلطَّرِيقِ، وَلَيْلًا فِي عَمُودِ نَارٍ لِيُضِيءَ لَهُمْ. لِكَيْ يَمْشُوا نَهَارًا وَلَيْلًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","لَمْ يَبْرَحْ عَمُودُ ٱلسَّحَابِ نَهَارًا وَعَمُودُ ٱلنَّارِ لَيْلًا مِنْ أَمَامِ ٱلشَّعْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","وَكَلَّمَ ٱلرَّبُ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ أَنْ يَرْجِعُوا وَيَنْزِلُوا أَمَامَ فَمِ ٱلْحِيرُوثِ بَيْنَ مَجْدَلَ وَٱلْبَحْرِ، أَمَامَ بَعْلَ صَفُونَ. مُقَابِلَهُ تَنْزِلُونَ عِنْدَ ٱلْبَحْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","فَيَقُولُ فِرْعَوْنُ عَنْ بَنِي إِسْرَائِيلَ: هُمْ مُرْتَبِكُونَ فِي ٱلْأَرْضِ. قَدِ ٱسْتَغْلَقَ عَلَيْهِمِ ٱلْقَفْرُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","وَأُشَدِّدُ قَلْبَ فِرْعَوْنَ حَتَّى يَسْعَى وَرَاءَهُمْ، فَأَتَمَجَّدُ بِفِرْعَوْنَ وَبِجَمِيعِ جَيْشِهِ، وَيَعْرِفُ ٱلْمِصْرِيُّونَ أَنِّي أَنَا ٱلرَّبُّ». فَفَعَلُوا هَكَذَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","فَلَمَّا أُخْبِرَ مَلِكُ مِصْرَ أَنَّ ٱلشَّعْبَ قَدْ هَرَبَ، تَغَيَّرَ قَلْبُ فِرْعَوْنَ وَعَبِيدِهِ عَلَى ٱلشَّعْبِ. فَقَالُوا: «مَاذَا فَعَلْنَا حَتَّى أَطْلَقْنَا إِسْرَائِيلَ مِنْ خِدْمَتِنَا؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","فَشَدَّ مَرْكَبَتَهُ وَأَخَذَ قَوْمَهُ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","وَأَخَذَ سِتَّ مِئَةِ مَرْكَبَةٍ مُنْتَخَبَةٍ وَسَائِرَ مَرْكَبَاتِ مِصْرَ وَجُنُودًا مَرْكَبِيَّةً عَلَى جَمِيعِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","وَشَدَّدَ ٱلرَّبُّ قَلْبَ فِرْعَوْنَ مَلِكِ مِصْرَ حَتَّى سَعَى وَرَاءَ بَنِي إِسْرَائِيلَ، وَبَنُو إِسْرَائِيلَ خَارِجُونَ بِيَدٍ رَفِيعَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","فَسَعَى ٱلْمِصْرِيُّونَ وَرَاءَهُمْ وَأَدْرَكُوهُمْ. جَمِيعُ خَيْلِ مَرْكَبَاتِ فِرْعَوْنَ وَفُرْسَانِهِ وَجَيْشِهِ، وَهُمْ نَازِلُونَ عِنْدَ ٱلْبَحْرِ عِنْدَ فَمِ ٱلْحِيرُوثِ، أَمَامَ بَعْلَ صَفُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","فَلَمَّا ٱقْتَرَبَ فِرْعَوْنُ رَفَعَ بَنُو إِسْرَائِيلَ عُيُونَهُمْ، وَإِذَا ٱلْمِصْرِيُّونَ رَاحِلُونَ وَرَاءَهُمْ. فَفَزِعُوِا جِدًّا، وَصَرَخَ بَنُو إِسْرَائِيلَ إِلَى ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","وَقَالُوا لِمُوسَى: «هَلْ لِأَنَّهُ لَيْسَتْ قُبُورٌ فِي مِصْرَ أَخَذْتَنَا لِنَمُوتَ فِي ٱلْبَرِّيَّةِ؟ مَاذَا صَنَعْتَ بِنَا حَتَّى أَخْرَجْتَنَا مِنْ مِصْرَ؟ ");
INSERT INTO arb_vd_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","أَلَيْسَ هَذَا هُوَ ٱلْكَلَامُ ٱلَّذِي كَلَّمْنَاكَ بِهِ فِي مِصْرَ قَائِلِينَ: كُفَّ عَنَّا فَنَخْدِمَ ٱلْمِصْرِيِّينَ؟ لِأَنَّهُ خَيْرٌ لَنَا أَنْ نَخْدِمَ ٱلْمِصْرِيِّينَ مِنْ أَنْ نَمُوتَ فِي ٱلْبَرِّيَّةِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","فَقَالَ مُوسَى لِلشَّعْبِ: «لَا تَخَافُوا. قِفُوا وَٱنْظُرُوا خَلَاصَ ٱلرَّبِّ ٱلَّذِي يَصْنَعُهُ لَكُمُ ٱلْيَوْمَ. فَإِنَّهُ كَمَا رَأَيْتُمُ ٱلْمِصْرِيِّينَ ٱلْيَوْمَ، لَا تَعُودُونَ تَرَوْنَهُمْ أَيْضًا إِلَى ٱلْأَبَدِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ٱلرَّبُّ يُقَاتِلُ عَنْكُمْ وَأَنْتُمْ تَصْمُتُونَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","فَقَالَ ٱلرَّبُّ لِمُوسَى: «مَا لَكَ تَصْرُخُ إِلَيَّ؟ قُلْ لِبَنِي إِسْرَائِيلَ أَنْ يَرْحَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","وَٱرْفَعْ أَنْتَ عَصَاكَ وَمُدَّ يَدَكَ عَلَى ٱلْبَحْرِ وَشُقَّهُ، فَيَدْخُلَ بَنُو إِسْرَائِيلَ فِي وَسَطِ ٱلْبَحْرِ عَلَى ٱلْيَابِسَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","وَهَا أَنَا أُشَدِّدُ قُلُوبَ ٱلْمِصْرِيِّينَ حَتَّى يَدْخُلُوا وَرَاءَهُمْ، فَأَتَمَجَّدُ بِفِرْعَوْنَ وَكُلِّ جَيْشِهِ، بِمَرْكَبَاتِهِ وَفُرْسَانِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","فَيَعْرِفُ ٱلْمِصْرِيُّونَ أَنِّي أَنَا ٱلرَّبُّ حِينَ أَتَمَجَّدُ بِفِرْعَوْنَ وَمَرْكَبَاتِهِ وَفُرْسَانِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","فَٱنْتَقَلَ مَلَاكُ ٱللهِ ٱلسَّائِرُ أَمَامَ عَسْكَرِ إِسْرَائِيلَ وَسَارَ وَرَاءَهُمْ، وَٱنْتَقَلَ عَمُودُ ٱلسَّحَابِ مِنْ أَمَامِهِمْ وَوَقَفَ وَرَاءَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","فَدَخَلَ بَيْنَ عَسْكَرِ ٱلْمِصْرِيِّينَ وَعَسْكَرِ إِسْرَائِيلَ، وَصَارَ ٱلسَّحَابُ وَٱلظَّلَامُ وَأَضَاءَ ٱللَّيْلَ. فَلَمْ يَقْتَرِبْ هَذَا إِلَى ذَاكَ كُلَّ ٱللَّيْلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","وَمَدَّ مُوسَى يَدَهُ عَلَى ٱلْبَحْرِ، فَأَجْرَى ٱلرَّبُّ ٱلْبَحْرَ بِرِيحٍ شَرْقِيَّةٍ شَدِيدَةٍ كُلَّ ٱللَّيْلِ، وَجَعَلَ ٱلْبَحْرَ يَابِسَةً وَٱنْشَقَّ ٱلْمَاءُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","فَدَخَلَ بَنُو إِسْرَائِيلَ فِي وَسَطِ ٱلْبَحْرِ عَلَى ٱلْيَابِسَةِ، وَٱلْمَاءُ سُورٌ لَهُمْ عَنْ يَمِينِهِمْ وَعَنْ يَسَارِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","وَتَبِعَهُمُ ٱلْمِصْرِيُّونَ وَدَخَلُوا وَرَاءَهُمْ. جَمِيعُ خَيْلِ فِرْعَوْنَ وَمَرْكَبَاتِهِ وَفُرْسَانِهِ إِلَى وَسَطِ ٱلْبَحْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","وَكَانَ فِي هَزِيعِ ٱلصُّبْحِ أَنَّ ٱلرَّبَّ أَشْرَفَ عَلَى عَسْكَرِ ٱلْمِصْرِيِّينَ فِي عَمُودِ ٱلنَّارِ وَٱلسَّحَابِ، وَأَزْعَجَ عَسْكَرَ ٱلْمِصْرِيِّينَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","وَخَلَعَ بَكَرَ مَرْكَبَاتِهِمْ حَتَّى سَاقُوهَا بِثَقْلَةٍ. فَقَالَ ٱلْمِصْرِيُّونَ: «نَهْرُبُ مِنْ إِسْرَائِيلَ، لِأَنَّ ٱلرَّبَّ يُقَاتِلُ ٱلْمِصْرِيِّينَ عَنْهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","فَقَالَ ٱلرَّبُّ لِمُوسَى: «مُدَّ يَدَكَ عَلَى ٱلْبَحْرِ لِيَرْجِعَ ٱلْمَاءُ عَلَى ٱلْمِصْرِيِّينَ، عَلَى مَرْكَبَاتِهِمْ وَفُرْسَانِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","فَمَدَّ مُوسَى يَدَهُ عَلَى ٱلْبَحْرِ فَرَجَعَ ٱلْبَحْرُ عِنْدَ إِقْبَالِ ٱلصُّبْحِ إِلَى حَالِهِ ٱلدَّائِمَةِ، وَٱلْمِصْرِيُّونَ هَارِبُونَ إِلَى لِقَائِهِ. فَدَفَعَ ٱلرَّبُّ ٱلْمِصْرِيِّينَ فِي وَسَطِ ٱلْبَحْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","فَرَجَعَ ٱلْمَاءُ وَغَطَّى مَرْكَبَاتِ وَفُرْسَانَ جَمِيعِ جَيْشِ فِرْعَوْنَ ٱلَّذِي دَخَلَ وَرَاءَهُمْ فِي ٱلْبَحْرِ. لَمْ يَبْقَ مِنْهُمْ وَلَا وَاحِدٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","وَأَمَّا بَنُو إِسْرَائِيلَ فَمَشَوْا عَلَى ٱلْيَابِسَةِ فِي وَسَطِ ٱلْبَحْرِ، وَٱلْمَاءُ سُورٌ لَهُمْ عَنْ يَمِينِهِمْ وَعَنْ يَسَارِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","فَخَلَّصَ ٱلرَّبُّ فِي ذَلِكَ ٱلْيَوْمِ إِسْرَائِيلَ مِنْ يَدِ ٱلْمِصْرِيِّينَ. وَنَظَرَ إِسْرَائِيلُ ٱلْمِصْرِيِّينَ أَمْوَاتًا عَلَى شَاطِئِ ٱلْبَحْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","وَرَأَى إِسْرَائِيلُ ٱلْفِعْلَ ٱلْعَظِيمَ ٱلَّذِي صَنَعَهُ ٱلرَّبُّ بِٱلْمِصْرِيِّينَ، فَخَافَ ٱلشَّعْبُ ٱلرَّبَّ وَآمَنُوا بِٱلرَّبِّ وَبِعَبْدِهِ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","حِينَئِذٍ رَنَّمَ مُوسَى وَبَنُو إِسْرَائِيلَ هَذِهِ ٱلتَّسْبِيحَةَ لِلرَّبِّ وَقَالُوا: «أُرَنِّمُ لِلرَّبِّ فَإِنَّهُ قَدْ تَعَظَّمَ. ٱلْفَرَسَ وَرَاكِبَهُ طَرَحَهُمَا فِي ٱلْبَحْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ٱلرَّبُّ قُوَّتِي وَنَشِيدِي، وَقَدْ صَارَ خَلَاصِي. هَذَا إِلَهِي فَأُمَجِّدُهُ، إِلَهُ أَبِي فَأُرَفِّعُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ٱلرَّبُّ رَجُلُ ٱلْحَرْبِ. ٱلرَّبُّ ٱسْمُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","مَرْكَبَاتُ فِرْعَوْنَ وَجَيْشُهُ أَلْقَاهُمَا فِي ٱلْبَحْرِ، فَغَرِقَ أَفْضَلُ جُنُودِهِ ٱلْمَرْكَبِيَّةِ فِي بَحْرِ سُوفَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","تُغَطِّيهِمُ ٱللُّجَجُ. قَدْ هَبَطُوا فِي ٱلْأَعْمَاقِ كَحَجَرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","يَمِينُكَ يَا رَبُّ مُعْتَزَّةٌ بِٱلْقُدْرَةِ. يَمِينُكَ يَا رَبُّ تُحَطِّمُ ٱلْعَدُوَّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","وَبِكَثْرَةِ عَظَمَتِكَ تَهْدِمُ مُقَاوِمِيكَ. تُرْسِلُ سُخْطَكَ فَيَأْكُلُهُمْ كَٱلْقَشِّ، ");
INSERT INTO arb_vd_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","وَبِرِيحِ أَنْفِكَ تَرَاكَمَتِ ٱلْمِيَاهُ. ٱنْتَصَبَتِ ٱلْمَجَارِيَ كَرَابِيَةٍ. تَجَمَّدَتِ ٱللُّجَجُ فِي قَلْبِ ٱلْبَحْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","قَالَ ٱلْعَدُوُّ: أَتْبَعُ، أُدْرِكُ، أُقَسِّمُ غَنِيمَةً. تَمْتَلِئُ مِنْهُمْ نَفْسِي. أُجَرِّدُ سَيْفِي. تُفْنِيهِمْ يَدِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","نَفَخْتَ بِرِيحِكَ فَغَطَّاهُمُ ٱلْبَحْرُ. غَاصُوا كَٱلرَّصَاصِ فِي مِيَاهٍ غَامِرَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","مَنْ مِثْلُكَ بَيْنَ ٱلْآلِهَةِ يَا رَبُّ؟ مَنْ مِثْلُكَ مُعْتَزًّا فِي ٱلْقَدَاسَةِ، مَخُوفًا بِٱلتَّسَابِيحِ، صَانِعًا عَجَائِبَ؟ ");
INSERT INTO arb_vd_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","تَمُدُّ يَمِينَكَ فَتَبْتَلِعُهُمُ ٱلْأَرْضُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","تُرْشِدُ بِرَأْفَتِكَ ٱلشَّعْبَ ٱلَّذِي فَدَيْتَهُ. تَهْدِيهِ بِقُوَّتِكَ إِلَى مَسْكَنِ قُدْسِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","يَسْمَعُ ٱلشُّعُوبُ فَيَرْتَعِدُونَ. تَأْخُذُ ٱلرَّعْدَةُ سُكَّانَ فِلِسْطِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","حِينَئِذٍ يَنْدَهِشُ أُمَرَاءُ أَدُومَ. أَقْوِيَاءُ مُوآبَ تَأْخُذُهُمُ ٱلرَّجْفَةُ. يَذُوبُ جَمِيعُ سُكَّانِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","تَقَعُ عَلَيْهِمِ ٱلْهَيْبَةُ وَٱلرُّعْبُ. بِعَظَمَةِ ذِرَاعِكَ يَصْمُتُونَ كَٱلْحَجَرِ حَتَّى يَعْبُرَ شَعْبُكَ يَا رَبُّ. حَتَّى يَعْبُرَ ٱلشَّعْبُ ٱلَّذِي ٱقْتَنَيْتَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","تَجِيءُ بِهِمْ وَتَغْرِسُهُمْ فِي جَبَلِ مِيرَاثِكَ، ٱلْمَكَانِ ٱلَّذِي صَنَعْتَهُ يَا رَبُّ لِسَكَنِكَ ٱلْمَقْدِسِ ٱلَّذِي هَيَّأَتْهُ يَدَاكَ يَا رَبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ٱلرَّبُّ يَمْلِكُ إِلَى ٱلدَّهْرِ وَٱلْأَبَدِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","فَإِنَّ خَيْلَ فِرْعَوْنَ دَخَلَتْ بِمَرْكَبَاتِهِ وَفُرْسَانِهِ إِلَى ٱلْبَحْرِ، وَرَدَّ ٱلرَّبُّ عَلَيْهِمْ مَاءَ ٱلْبَحْرِ. وَأَمَّا بَنُو إِسْرَائِيلَ فَمَشَوْا عَلَى ٱلْيَابِسَةِ فِي وَسَطِ ٱلْبَحْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","فَأَخَذَتْ مَرْيَمُ ٱلنَّبِيَّةُ أُخْتُ هَارُونَ ٱلدُّفَّ بِيَدِهَا، وَخَرَجَتْ جَمِيعُ ٱلنِّسَاءِ وَرَاءَهَا بِدُفُوفٍ وَرَقْصٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","وَأَجَابَتْهُمْ مَرْيَمُ: «رَنِّمُوا لِلرَّبِّ فَإِنَّهُ قَدْ تَعَظَّمَ. ٱلْفَرَسَ وَرَاكِبَهُ طَرَحَهُمَا فِي ٱلْبَحْرِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ثُمَّ ٱرْتَحَلَ مُوسَى بِإِسْرَائِيلَ مِنْ بَحْرِ سُوفَ وَخَرَجُوا إِلَى بَرِّيَّةِ شُورٍ. فَسَارُوا ثَلَاثَةَ أَيَّامٍ فِي ٱلْبَرِّيَّةِ وَلَمْ يَجِدُوا مَاءً. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","فَجَاءُوا إِلَى مَارَّةَ، وَلَمْ يَقْدِرُوا أَنْ يَشْرَبُوا مَاءً مِنْ مَارَّةَ لِأَنَّهُ مُرٌّ. لِذَلِكَ دُعِيَ ٱسْمُهَا «مَارَّةَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","فَتَذَمَّرَ ٱلشَّعْبُ عَلَى مُوسَى قَائِلِينَ: «مَاذَا نَشْرَبُ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","فَصَرَخَ إِلَى ٱلرَّبِّ. فَأَرَاهُ ٱلرَّبُّ شَجَرَةً فَطَرَحَهَا فِي ٱلْمَاءِ فَصَارَ ٱلْمَاءُ عَذْبًا. هُنَاكَ وَضَعَ لَهُ فَرِيضَةً وَحُكْمًا، وَهُنَاكَ ٱمْتَحَنَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","فَقَالَ: «إِنْ كُنْتَ تَسْمَعُ لِصَوْتِ ٱلرَّبِّ إِلَهِكَ، وَتَصْنَعُ ٱلْحَقَّ فِي عَيْنَيْهِ، وَتَصْغَى إِلَى وَصَايَاهُ وَتَحْفَظُ جَمِيعَ فَرَائِضِهِ، فَمَرَضًا مَا مِمَّا وَضَعْتُهُ عَلَى ٱلْمِصْرِيِّينَ لَا أَضَعُ عَلَيْكَ. فَإِنِّي أَنَا ٱلرَّبُّ شَافِيكَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ثُمَّ جَاءُوا إِلَى إِيلِيمَ وَهُنَاكَ ٱثْنَتَا عَشْرَةَ عَيْنَ مَاءٍ وَسَبْعُونَ نَخْلَةً. فَنَزَلُوا هُنَاكَ عِنْدَ ٱلْمَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ثُمَّ ٱرْتَحَلُوا مِنْ إِيلِيمَ. وَأَتَى كُلُّ جَمَاعَةِ بَنِي إِسْرَائِيلَ إِلَى بَرِّيَّةِ سِينٍ، ٱلَّتِي بَيْنَ إِيلِيمَ وَسِينَاءَ فِي ٱلْيَوْمِ ٱلْخَامِسَ عَشَرَ مِنَ ٱلشَّهْرِ ٱلثَّانِي بَعْدَ خُرُوجِهِمْ مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","فَتَذَمَّرَ كُلُّ جَمَاعَةِ بَنِي إِسْرَائِيلَ عَلَى مُوسَى وَهَارُونَ فِي ٱلْبَرِّيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","وَقَالَ لَهُمَا بَنُو إِسْرَائِيلَ: «لَيْتَنَا مُتْنَا بِيَدِ ٱلرَّبِّ فِي أَرْضِ مِصْرَ، إِذْ كُنَّا جَالِسِينَ عِنْدَ قُدُورِ ٱللَّحْمِ نَأْكُلُ خُبْزًا لِلشَّبَعِ. فَإِنَّكُمَا أَخْرَجْتُمَانَا إِلَى هَذَا ٱلْقَفْرِ لِكَيْ تُمِيتَا كُلَّ هَذَا ٱلْجُمْهُورِ بِٱلْجُوعِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","فَقَالَ ٱلرَّبُّ لِمُوسَى: «هَا أَنَا أُمْطِرُ لَكُمْ خُبْزًا مِنَ ٱلسَّمَاءِ. فَيَخْرُجُ ٱلشَّعْبُ وَيَلْتَقِطُونَ حَاجَةَ ٱلْيَوْمِ بِيَوْمِهَا. لِكَيْ أَمْتَحِنَهُمْ، أَيَسْلُكُونَ فِي نَامُوسِي أَمْ لَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","وَيَكُونُ فِي ٱلْيَوْمِ ٱلسَّادِسِ أَنَّهُمْ يُهَيِّئُونَ مَا يَجِيئُونَ بِهِ فَيَكُونُ ضِعْفَ مَا يَلْتَقِطُونَهُ يَوْمًا فَيَوْمًا». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","فَقَالَ مُوسَى وَهَارُونُ لِجَمِيعِ بَنِي إِسْرَائِيلَ: «فِي ٱلْمَسَاءِ تَعْلَمُونَ أَنَّ ٱلرَّبَّ أَخْرَجَكُمْ مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","وَفِي ٱلصَّبَاحِ تَرَوْنَ مَجْدَ ٱلرَّبِّ لِٱسْتِمَاعِهِ تَذَمُّرَكُمْ عَلَى ٱلرَّبِّ. وَأَمَّا نَحْنُ فَمَاذَا حَتَّى تَتَذَمَّرُوا عَلَيْنَا؟». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","وَقَالَ مُوسَى: «ذَلِكَ بِأَنَّ ٱلرَّبَّ يُعْطِيكُمْ فِي ٱلْمَسَاءِ لَحْمًا لِتَأْكُلُوا، وَفِي ٱلصَّبَاحِ خُبْزًا لِتَشْبَعُوا، لِٱسْتِمَاعِ ٱلرَّبِّ تَذَمُّرَكُمُ ٱلَّذِي تَتَذَمَّرُونَ عَلَيْهِ. وَأَمَّا نَحْنُ فَمَاذَا؟ لَيْسَ عَلَيْنَا تَذَمُّرُكُمْ بَلْ عَلَى ٱلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","وَقَالَ مُوسَى لِهَارُونَ: «قُلْ لِكُلِّ جَمَاعَةِ بَنِي إِسْرَائِيلَ: ٱقْتَرِبُوا إِلَى أَمَامِ ٱلرَّبِّ لِأَنَّهُ قَدْ سَمِعَ تَذَمُّرَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","فَحَدَثَ إِذْ كَانَ هَارُونُ يُكَلِّمُ كُلَّ جَمَاعَةِ بَنِي إِسْرَائِيلَ أَنَّهُمُ ٱلْتَفَتُوا نَحْوَ ٱلْبَرِّيَّةِ، وَإِذَا مَجْدُ ٱلرَّبِّ قَدْ ظَهَرَ فِي ٱلسَّحَابِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","فَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«سَمِعْتُ تَذَمُّرَ بَنِي إِسْرَائِيلَ. كَلِّمْهُمْ قَائِلًا: فِي ٱلْعَشِيَّةِ تَأْكُلُونَ لَحْمًا، وَفِي ٱلصَّبَاحِ تَشْبَعُونَ خُبْزًا، وَتَعْلَمُونَ أَنِّي أَنَا ٱلرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","فَكَانَ فِي ٱلْمَسَاءِ أَنَّ ٱلسَّلْوَى صَعِدَتْ وَغَطَّتِ ٱلْمَحَلَّةَ. وَفِي ٱلصَّبَاحِ كَانَ سَقِيطُ ٱلنَّدَى حَوَالَيِ ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","وَلَمَّا ٱرْتَفَعَ سَقِيطُ ٱلنَّدَى إِذَا عَلَى وَجْهِ ٱلْبَرِّيَّةِ شَيْءٌ دَقِيقٌ مِثْلُ قُشُورٍ. دَقِيقٌ كَٱلْجَلِيدِ عَلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","فَلَمَّا رَأَى بَنُو إِسْرَائِيلَ قَالُوا بَعْضُهُمْ لِبَعْضٍ: «مَنْ هُوَ؟» لِأَنَّهُمْ لَمْ يَعْرِفُوا مَا هُوَ. فَقَالَ لَهُمْ مُوسَى: «هُوَ ٱلْخُبْزُ ٱلَّذِي أَعْطَاكُمُ ٱلرَّبُّ لِتَأْكُلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","هَذَا هُوَ ٱلشَّيْءُ ٱلَّذِي أَمَرَ بِهِ ٱلرَّبُّ. اِلْتَقِطُوا مِنْهُ كُلُّ وَاحِدٍ عَلَى حَسَبِ أُكْلِهِ. عُمِرًا لِلرَّأْسِ عَلَى عَدَدِ نُفُوسِكُمْ تَأْخُذُونَ، كُلُّ وَاحِدٍ لِلَّذِينَ فِي خَيْمَتِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","فَفَعَلَ بَنُو إِسْرَائِيلَ هَكَذَا، وَٱلْتَقَطُوا بَيْنَ مُكَثِّرٍ وَمُقَلِّلٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","وَلَمَّا كَالُوا بِٱلْعُمِرِ، لَمْ يُفْضِلِ ٱلْمُكَثِّرُ وَٱلْمُقَلِّلُ لَمْ يُنْقِصْ. كَانُوا قَدِ ٱلْتَقَطُوا كُلُّ وَاحِدٍ عَلَى حَسَبِ أُكْلِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","وَقَالَ لَهُمْ مُوسَى: «لَا يُبْقِ أَحَدٌ مِنْهُ إِلَى ٱلصَّبَاحِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","لَكِنَّهُمْ لَمْ يَسْمَعُوا لِمُوسَى، بَلْ أَبْقَى مِنْهُ أُنَاسٌ إِلَى ٱلصَّبَاحِ، فَتَوَلَّدَ فِيهِ دُودٌ وَأَنْتَنَ. فَسَخَطَ عَلَيْهِمْ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","وَكَانُوا يَلْتَقِطُونَهُ صَبَاحًا فَصَبَاحًا كُلُّ وَاحِدٍ عَلَى حَسَبِ أُكْلِهِ. وَإِذَا حَمِيَتِ ٱلشَّمْسُ كَانَ يَذُوبُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ثُمَّ كَانَ فِي ٱلْيَوْمِ ٱلسَّادِسِ أَنَّهُمُ ٱلْتَقَطُوا خُبْزًا مُضَاعَفًا، عُمِرَيْنِ لِلْوَاحِدِ. فَجَاءَ كُلُّ رُؤَسَاءِ ٱلْجَمَاعَةِ وَأَخْبَرُوا مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","فَقَالَ لَهُمْ: «هَذَا مَا قَالَ ٱلرَّبُّ: غَدًا عُطْلَةٌ، سَبْتٌ مُقَدَّسٌ لِلرَّبِّ. ٱخْبِزُوا مَا تَخْبِزُونَ وَٱطْبُخُوا مَا تَطْبُخُونَ. وَكُلُّ مَا فَضِلَ ضَعُوهُ عِنْدَكُمْ لِيُحْفَظَ إِلَى ٱلْغَدِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","فَوَضَعُوهُ إِلَى ٱلْغَدِ كَمَا أَمَرَ مُوسَى، فَلَمْ يُنْتِنْ وَلَا صَارَ فِيهِ دُودٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","فَقَالَ مُوسَى: «كُلُوهُ ٱلْيَوْمَ، لِأَنَّ لِلرَّبِّ ٱلْيَوْمَ سَبْتًا. ٱلْيَوْمَ لَا تَجِدُونَهُ فِي ٱلْحَقْلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","سِتَّةَ أَيَّامٍ تَلْتَقِطُونَهُ، وَأَمَّا ٱلْيَوْمُ ٱلسَّابِعُ فَفِيهِ سَبْتٌ، لَا يُوجَدُ فِيهِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","وَحَدَثَ فِي ٱلْيَوْمِ ٱلسَّابِعِ أَنَّ بَعْضَ ٱلشَّعْبِ خَرَجُوا لِيَلْتَقِطُوا فَلَمْ يَجِدُوا. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","فَقَالَ ٱلرَّبُّ لِمُوسَى: «إِلَى مَتَى تَأْبَوْنَ أَنْ تَحْفَظُوا وَصَايَايَ وَشَرَائِعِي؟ ");
INSERT INTO arb_vd_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","اُنْظُرُوا! إِنَّ ٱلرَّبَّ أَعْطَاكُمُ ٱلسَّبْتَ. لِذَلِكَ هُوَ يُعْطِيكُمْ فِي ٱلْيَوْمِ ٱلسَّادِسِ خُبْزَ يَوْمَيْنِ. ٱجْلِسُوا كُلُّ وَاحِدٍ فِي مَكَانِهِ. لَا يَخْرُجْ أَحَدٌ مِنْ مَكَانِهِ فِي ٱلْيَوْمِ ٱلسَّابِعِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","فَٱسْتَرَاحَ ٱلشَّعْبُ فِي ٱلْيَوْمِ ٱلسَّابِعِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","وَدَعَا بَيْتُ إِسْرَائِيلَ ٱسْمَهُ «مَنًّا». وَهُوَ كَبِزْرِ ٱلْكُزْبَرَةِ، أَبْيَضُ، وَطَعْمُهُ كَرِقَاقٍ بِعَسَلٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","وَقَالَ مُوسَى: «هَذَا هُوَ ٱلشَّيْءُ ٱلَّذِي أَمَرَ بِهِ ٱلرَّبُّ. مِلْءُ ٱلْعُمِرِ مِنْهُ يَكُونُ لِلْحِفْظِ فِي أَجْيَالِكُمْ. لِكَيْ يَرَوْا ٱلْخُبْزَ ٱلَّذِي أَطْعَمْتُكُمْ فِي ٱلْبَرِّيَّةِ حِينَ أَخْرَجْتُكُمْ مِنْ أَرْضِ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","وَقَالَ مُوسَى لِهَارُونَ: «خُذْ قِسْطًا وَاحِدًا وَٱجْعَلْ فِيهِ مِلْءَ ٱلْعُمِرِ مَنًّا، وَضَعْهُ أَمَامَ ٱلرَّبِّ لِلْحِفْظِ فِي أَجْيَالِكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","كَمَا أَمَرَ ٱلرَّبُّ مُوسَى وَضَعَهُ هَارُونُ أَمَامَ ٱلشَّهَادَةِ لِلْحِفْظِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","وَأَكَلَ بَنُو إِسْرَائِيلَ ٱلْمَنَّ أَرْبَعِينَ سَنَةً حَتَّى جَاءُوا إِلَى أَرْضٍ عَامِرَةٍ. أَكَلُوا ٱلْمَنَّ حَتَّى جَاءُوا إِلَى طَرَفِ أَرْضِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","وَأَمَّا ٱلْعُمِرُ فَهُوَ عُشْرُ ٱلْإِيفَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ثُمَّ ٱرْتَحَلَ كُلُّ جَمَاعَةِ بَنِي إِسْرَائِيلَ مِنْ بَرِّيَّةِ سِينٍ بِحَسَبِ مَرَاحِلِهِمْ عَلَى مُوجِبِ أَمْرِ ٱلرَّبِّ، وَنَزَلُوا فِي رَفِيدِيمَ. وَلَمْ يَكُنْ مَاءٌ لِيَشْرَبَ ٱلشَّعْبُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","فَخَاصَمَ ٱلشَّعْبُ مُوسَى وَقَالُوا: «أَعْطُونَا مَاءً لِنَشْرَبَ». فَقَالَ لَهُمْ مُوسَى: «لِمَاذَا تُخَاصِمُونَنِي؟ لِمَاذَا تُجَرِّبُونَ ٱلرَّبَّ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","وَعَطِشَ هُنَاكَ ٱلشَّعْبُ إِلَى ٱلْمَاءِ، وَتَذَمَّرَ ٱلشَّعْبُ عَلَى مُوسَى وَقَالُوا: «لِمَاذَا أَصْعَدْتَنَا مِنْ مِصْرَ لِتُمِيتَنَا وَأَوْلَادَنَا وَمَوَاشِيَنَا بِٱلْعَطَشِ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","فَصَرَخَ مُوسَى إِلَى ٱلرَّبِّ قَائِلًا: «مَاذَا أَفْعَلُ بِهَذَا ٱلشَّعْبِ؟ بَعْدَ قَلِيلٍ يَرْجُمُونَنِي». ");
INSERT INTO arb_vd_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","فَقَالَ ٱلرَّبُّ لِمُوسَى: «مُرَّ قُدَّامَ ٱلشَّعْبِ، وَخُذْ مَعَكَ مِنْ شُيُوخِ إِسْرَائِيلَ. وَعَصَاكَ ٱلَّتِي ضَرَبْتَ بِهَا ٱلنَّهْرَ خُذْهَا فِي يَدِكَ وَٱذْهَبْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","هَا أَنَا أَقِفُ أَمَامَكَ هُنَاكَ عَلَى ٱلصَّخْرَةِ فِي حُورِيبَ، فَتَضْرِبُ ٱلصَّخْرَةَ فَيَخْرُجُ مِنْهَا مَاءٌ لِيَشْرَبَ ٱلشَّعْبُ». فَفَعَلَ مُوسَى هَكَذَا أَمَامَ عُيُونِ شُيُوخِ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","وَدَعَا ٱسْمَ ٱلْمَوْضِعِ «مَسَّةَ وَمَرِيبَةَ» مِنْ أَجْلِ مُخَاصَمَةِ بَنِي إِسْرَائِيلَ، وَمِنْ أَجْلِ تَجْرِبَتِهِمْ لِلرَّبِّ قَائِلِينَ: «أَفِي وَسَطِنَا ٱلرَّبُّ أَمْ لَا؟». ");
INSERT INTO arb_vd_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","وَأَتَى عَمَالِيقُ وَحَارَبَ إِسْرَائِيلَ فِي رَفِيدِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","فَقَالَ مُوسَى لِيَشُوعَ: «ٱنْتَخِبْ لَنَا رِجَالًا وَٱخْرُجْ حَارِبْ عَمَالِيقَ. وَغَدًا أَقِفُ أَنَا عَلَى رَأْسِ ٱلتَّلَّةِ وَعَصَا ٱللهِ فِي يَدِي». ");
INSERT INTO arb_vd_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","فَفَعَلَ يَشُوعُ كَمَا قَالَ لَهُ مُوسَى لِيُحَارِبَ عَمَالِيقَ. وَأَمَّا مُوسَى وَهَارُونُ وَحُورُ فَصَعِدُوا عَلَى رَأْسِ ٱلتَّلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","وَكَانَ إِذَا رَفَعَ مُوسَى يَدَهُ أَنَّ إِسْرَائِيلَ يَغْلِبُ، وَإِذَا خَفَضَ يَدَهُ أَنَّ عَمَالِيقَ يَغْلِبُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","فَلَمَّا صَارَتْ يَدَا مُوسَى ثَقِيلَتَيْنِ، أَخَذَا حَجَرًا وَوَضَعَاهُ تَحْتَهُ فَجَلَسَ عَلَيْهِ. وَدَعَمَ هَارُونُ وَحُورُ يَدَيْهِ، ٱلْوَاحِدُ مِنْ هُنَا وَٱلْآخَرُ مِنْ هُنَاكَ. فَكَانَتْ يَدَاهُ ثَابِتَتَيْنِ إِلَى غُرُوبِ ٱلشَّمْسِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","فَهَزَمَ يَشُوعُ عَمَالِيقَ وَقَوْمَهُ بِحَدِّ ٱلسَّيْفِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","فَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱكْتُبْ هَذَا تَذْكَارًا فِي ٱلْكِتَابِ، وَضَعْهُ فِي مَسَامِعِ يَشُوعَ. فَإِنِّي سَوْفَ أَمْحُو ذِكْرَ عَمَالِيقَ مِنْ تَحْتِ ٱلسَّمَاءِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","فَبَنَى مُوسَى مَذْبَحًا وَدَعَا ٱسْمَهُ «يَهْوَهْ نِسِّي». ");
INSERT INTO arb_vd_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","وَقَالَ: «إِنَّ ٱلْيَدَ عَلَى كُرْسِيِّ ٱلرَّبِّ. لِلرَّبِّ حَرْبٌ مَعَ عَمَالِيقَ مِنْ دَوْرٍ إِلَى دَوْرٍ». ");
INSERT INTO arb_vd_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","فَسَمِعَ يَثْرُونُ كَاهِنُ مِدْيَانَ، حَمُو مُوسَى، كُلَّ مَا صَنَعَ ٱللهُ إِلَى مُوسَى وَإِلَى إِسْرَائِيلَ شَعْبِهِ: أَنَّ ٱلرَّبَّ أَخْرَجَ إِسْرَائِيلَ مِنْ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","فَأَخَذَ يَثْرُونُ حَمُو مُوسَى صِفُّورَةَ ٱمْرَأَةَ مُوسَى بَعْدَ صَرْفِهَا ");
INSERT INTO arb_vd_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","وَٱبْنَيْهَا، ٱللَّذَيْنِ ٱسْمُ أَحَدِهِمَا جِرْشُومُ، لِأَنَّهُ قَالَ: «كُنْتُ نَزِيلًا فِي أَرْضٍ غَرِيبَةٍ». ");
INSERT INTO arb_vd_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","وَٱسْمُ ٱلْآخَرِ أَلِيعَازَرُ، لِأَنَّهُ قَالَ: «إِلَهُ أَبِي كَانَ عَوْنِي وَأَنْقَذَنِي مِنْ سَيْفِ فِرْعَوْنَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","وَأَتَى يَثْرُونُ حَمُو مُوسَى وَٱبْنَاهُ وَٱمْرَأَتُهُ إِلَى مُوسَى إِلَى ٱلْبَرِّيَّةِ حَيْثُ كَانَ نَازِلًا عِنْدَ جَبَلِ ٱللهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","فَقَالَ لِمُوسَى: «أَنَا حَمُوكَ يَثْرُونُ، آتٍ إِلَيْكَ وَٱمْرَأَتُكَ وَٱبْنَاهَا مَعَهَا». ");
INSERT INTO arb_vd_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","فَخَرَجَ مُوسَى لِٱسْتِقْبَالِ حَمِيهِ وَسَجَدَ وَقَبَّلَهُ. وَسَأَلَ كُلُّ وَاحِدٍ صَاحِبَهُ عَنْ سَلَامَتِهِ، ثُمَّ دَخَلَا إِلَى ٱلْخَيْمَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","فَقَصَّ مُوسَى عَلَى حَمِيهِ كُلَّ مَا صَنَعَ ٱلرَّبُّ بِفِرْعَوْنَ وَٱلْمِصْرِيِّينَ مِنْ أَجْلِ إِسْرَائِيلَ، وَكُلَّ ٱلْمَشَقَّةِ ٱلَّتِي أَصَابَتْهُمْ فِي ٱلطَّرِيقِ فَخَلَّصَهُمُ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","فَفَرِحَ يَثْرُونُ بِجَمِيعِ ٱلْخَيْرِ ٱلَّذِي صَنَعَهُ إِلَى إِسْرَائِيلَ ٱلرَّبُّ، ٱلَّذِي أَنْقَذَهُ مِنْ أَيْدِي ٱلْمِصْرِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","وَقَالَ يَثْرُونُ: «مُبَارَكٌ ٱلرَّبُّ ٱلَّذِي أَنْقَذَكُمْ مِنْ أَيْدِي ٱلْمِصْرِيِّينَ وَمِنْ يَدِ فِرْعَوْنَ. اَلَّذِي أَنْقَذَ ٱلشَّعْبَ مِنْ تَحْتِ أَيْدِي ٱلْمِصْرِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ٱلْآنَ عَلِمْتُ أَنَّ ٱلرَّبَّ أَعْظَمُ مِنْ جَمِيعِ ٱلْآلِهَةِ، لِأَنَّهُ فِي ٱلشَّيْءِ ٱلَّذِي بَغَوْا بِهِ كَانَ عَلَيْهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","فَأَخَذَ يَثْرُونُ حَمُو مُوسَى مُحْرَقَةً وَذَبَائِحَ لِلهِ. وَجَاءَ هَارُونُ وَجَمِيعُ شُيُوخِ إِسْرَائِيلَ لِيَأْكُلُوا طَعَامًا مَعَ حَمِي مُوسَى أَمَامَ ٱللهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","وَحَدَثَ فِي ٱلْغَدِ أَنَّ مُوسَى جَلَسَ لِيَقْضِيَ لِلشَّعْبِ. فَوَقَفَ ٱلشَّعْبُ عِنْدَ مُوسَى مِنَ ٱلصَّبَاحِ إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","فَلَمَّا رَأَى حَمُو مُوسَى كُلَّ مَا هُوَ صَانِعٌ لِلشَّعْبِ، قَالَ: «مَا هَذَا ٱلْأَمْرُ ٱلَّذِي أَنْتَ صَانِعٌ لِلشَّعْبِ؟ مَا بَالُكَ جَالِسًا وَحْدَكَ وَجَمِيعُ ٱلشَّعْبِ وَاقِفٌ عِنْدَكَ مِنَ ٱلصَّبَاحِ إِلَى ٱلْمَسَاءِ؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","فَقَالَ مُوسَى لِحَمِيهِ: «إِنَّ ٱلشَّعْبَ يَأْتِي إِلَيَّ لِيَسْأَلَ ٱللهَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","إِذَا كَانَ لَهُمْ دَعْوَى يَأْتُونَ إِلَيَّ فَأَقْضِي بَيْنَ ٱلرَّجُلِ وَصَاحِبِهِ، وَأُعَرِّفُهُمْ فَرَائِضَ ٱللهِ وَشَرَائِعَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","فَقَالَ حَمُو مُوسَى لَهُ: «لَيْسَ جَيِّدًا ٱلْأَمْرُ ٱلَّذِي أَنْتَ صَانِعٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","إِنَّكَ تَكِلُّ أَنْتَ وَهَذَا ٱلشَّعْبُ ٱلَّذِي مَعَكَ جَمِيعًا، لِأَنَّ ٱلْأَمْرَ أَعْظَمُ مِنْكَ. لَا تَسْتَطِيعُ أَنْ تَصْنَعَهُ وَحْدَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","اَلْآنَ ٱسْمَعْ لِصَوْتِي فَأَنْصَحَكَ. فَلْيَكُنِ ٱللهُ مَعَكَ. كُنْ أَنْتَ لِلشَّعْبِ أَمَامَ ٱللهِ، وَقَدِّمْ أَنْتَ ٱلدَّعَاوِيَ إِلَى ٱللهِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","وَعَلِّمْهُمُ ٱلْفَرَائِضَ وَٱلشَّرَائِعَ، وَعَرِّفْهُمُ ٱلطَّرِيقَ ٱلَّذِي يَسْلُكُونَهُ، وَٱلْعَمَلَ ٱلَّذِي يَعْمَلُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","وَأَنْتَ تَنْظُرُ مِنْ جَمِيعِ ٱلشَّعْبِ ذَوِي قُدْرَةٍ خَائِفِينَ ٱللهَ، أُمَنَاءَ مُبْغِضِينَ ٱلرَّشْوَةَ، وَتُقِيمُهُمْ عَلَيْهِمْ رُؤَسَاءَ أُلُوفٍ، وَرُؤَسَاءَ مِئَاتٍ، وَرُؤَسَاءَ خَمَاسِينَ، وَرُؤَسَاءَ عَشَرَاتٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","فَيَقْضُونَ لِلشَّعْبِ كُلَّ حِينٍ. وَيَكُونُ أَنَّ كُلَّ ٱلدَّعَاوِي ٱلْكَبِيرَةِ يَجِيئُونَ بِهَا إِلَيْكَ، وَكُلَّ ٱلدَّعَاوِي ٱلصَّغِيرَةِ يَقْضُونَ هُمْ فِيهَا. وَخَفِّفْ عَنْ نَفْسِكَ، فَهُمْ يَحْمِلُونَ مَعَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","إِنْ فَعَلْتَ هَذَا ٱلْأَمْرَ وَأَوْصَاكَ ٱللهُ تَسْتَطِيعُ ٱلْقِيَامَ. وَكُلُّ هَذَا ٱلشَّعْبِ أَيْضًا يَأْتِي إِلَى مَكَانِهِ بِٱلسَّلَامِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","فَسَمِعَ مُوسَى لِصَوْتِ حَمِيهِ وَفَعَلَ كُلَّ مَا قَالَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","وَٱخْتَارَ مُوسَى ذَوِي قُدْرَةٍ مِنْ جَمِيعِ إِسْرَائِيلَ وَجَعَلَهُمْ رُؤُوسًا عَلَى ٱلشَّعْبِ، رُؤَسَاءَ أُلُوفٍ، وَرُؤَسَاءَ مِئَاتٍ، وَرُؤَسَاءَ خَمَاسِينَ، وَرُؤَسَاءَ عَشَرَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","فَكَانُوا يَقْضُونَ لِلشَّعْبِ كُلَّ حِينٍ. ٱلدَّعَاوِي ٱلْعَسِرَةُ يَجِيئُونَ بِهَا إِلَى مُوسَى، وَكُلُّ ٱلدَّعَاوِي ٱلصَّغِيرَةِ يَقْضُونَ هُمْ فِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ثُمَّ صَرَفَ مُوسَى حَمَاهُ فَمَضَى إِلَى أَرْضِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","فِي ٱلشَّهْرِ ٱلثَّالِثِ بَعْدَ خُرُوجِ بَنِي إِسْرَائِيلَ مِنْ أَرْضِ مِصْرَ، فِي ذَلِكَ ٱلْيَوْمِ جَاءُوا إِلَى بَرِّيَّةِ سِينَاءَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ٱرْتَحَلُوا مِنْ رَفِيدِيمَ وَجَاءُوا إِلَى بَرِّيَّةِ سِينَاءَ فَنَزَلُوا فِي ٱلْبَرِّيَّةِ. هُنَاكَ نَزَلَ إِسْرَائِيلُ مُقَابِلَ ٱلْجَبَلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","وَأَمَّا مُوسَى فَصَعِدَ إِلَى ٱللهِ. فَنَادَاهُ ٱلرَّبُّ مِنَ ٱلْجَبَلِ قَائِلًا: «هَكَذَا تَقُولُ لِبَيْتِ يَعْقُوبَ، وَتُخْبِرُ بَنِي إِسْرَائِيلَ: ");
INSERT INTO arb_vd_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","أَنْتُمْ رَأَيْتُمْ مَا صَنَعْتُ بِٱلْمِصْرِيِّينَ. وَأَنَا حَمَلْتُكُمْ عَلَى أَجْنِحَةِ ٱلنُّسُورِ وَجِئْتُ بِكُمْ إِلَيَّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","فَٱلْآنَ إِنْ سَمِعْتُمْ لِصَوْتِي، وَحَفِظْتُمْ عَهْدِي تَكُونُونَ لِي خَاصَّةً مِنْ بَيْنِ جَمِيعِ ٱلشُّعُوبِ. فَإِنَّ لِي كُلَّ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","وَأَنْتُمْ تَكُونُونَ لِي مَمْلَكَةَ كَهَنَةٍ وَأُمَّةً مُقَدَّسَةً. هَذِهِ هِيَ ٱلْكَلِمَاتُ ٱلَّتِي تُكَلِّمُ بِهَا بَنِي إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","فَجَاءَ مُوسَى وَدَعَا شُيُوخَ ٱلشَّعْبِ وَوَضَعَ قُدَّامَهُمْ كُلَّ هَذِهِ ٱلْكَلِمَاتِ ٱلَّتِي أَوْصَاهُ بِهَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","فَأَجَابَ جَمِيعُ ٱلشَّعْبِ مَعًا وَقَالُوا: «كُلُّ مَا تَكَلَّمَ بِهِ ٱلرَّبُّ نَفْعَلُ». فَرَدَّ مُوسَى كَلَامَ ٱلشَّعْبِ إِلَى ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","فَقَالَ ٱلرَّبُّ لِمُوسَى: «هَا أَنَا آتٍ إِلَيْكَ فِي ظَلَامِ ٱلسَّحَابِ لِكَيْ يَسْمَعَ ٱلشَّعْبُ حِينَمَا أَتَكَلَّمُ مَعَكَ، فَيُؤْمِنُوا بِكَ أَيْضًا إِلَى ٱلْأَبَدِ». وَأَخْبَرَ مُوسَى ٱلرَّبَّ بِكَلَامِ ٱلشَّعْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","فَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱذْهَبْ إِلَى ٱلشَّعْبِ وَقَدِّسْهُمُ ٱلْيَوْمَ وَغَدًا، وَلْيَغْسِلُوا ثِيَابَهُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","وَيَكُونُوا مُسْتَعِدِّينَ لِلْيَوْمِ ٱلثَّالِثِ. لِأَنَّهُ فِي ٱلْيَوْمِ ٱلثَّالِثِ يَنْزِلُ ٱلرَّبُّ أَمَامَ عْيُونِ جَمِيعِ ٱلشَّعْبِ عَلَى جَبَلِ سِينَاءَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","وَتُقِيمُ لِلشَّعْبِ حُدُودًا مِنْ كُلِّ نَاحِيَةٍ، قَائِلًا: ٱحْتَرِزُوا مِنْ أَنْ تَصْعَدُوا إِلَى ٱلْجَبَلِ أَوْ تَمَسُّوا طَرَفَهُ. كُلُّ مَنْ يَمَسُّ ٱلْجَبَلَ يُقْتَلُ قَتْلًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","لَا تَمَسُّهُ يَدٌ بَلْ يُرْجَمُ رَجْمًا أَوْ يُرْمَى رَمْيًا. بَهِيمَةً كَانَ أَمْ إِنْسَانًا لَا يَعِيشُ. أَمَّا عِنْدَ صَوْتِ ٱلْبُوقِ فَهُمْ يَصْعَدُونَ إِلَى ٱلْجَبَلِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","فَٱنْحَدَرَ مُوسَى مِنَ ٱلْجَبَلِ إِلَى ٱلشَّعْبِ، وَقَدَّسَ ٱلشَّعْبَ وَغَسَلُوا ثِيَابَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","وَقَالَ لِلشَّعْبِ: «كُونُوا مُسْتَعِدِّينَ لِلْيَوْمِ ٱلثَّالِثِ. لَا تَقْرُبُوا ٱمْرَأَةً». ");
INSERT INTO arb_vd_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","وَحَدَثَ فِي ٱلْيَوْمِ ٱلثَّالِثِ لَمَّا كَانَ ٱلصَّبَاحُ أَنَّهُ صَارَتْ رُعُودٌ وَبُرُوقٌ وَسَحَابٌ ثَقِيلٌ عَلَى ٱلْجَبَلِ، وَصَوْتُ بُوقٍ شَدِيدٌ جِدًّا. فَٱرْتَعَدَ كُلُّ ٱلشَّعْبِ ٱلَّذِي فِي ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","وَأَخْرَجَ مُوسَى ٱلشَّعْبَ مِنَ ٱلْمَحَلَّةِ لِمُلَاقَاةِ ٱللهِ، فَوَقَفُوا فِي أَسْفَلِ ٱلْجَبَلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","وَكَانَ جَبَلُ سِينَاءَ كُلُّهُ يُدَخِّنُ مِنْ أَجْلِ أَنَّ ٱلرَّبَّ نَزَلَ عَلَيْهِ بِٱلنَّارِ، وَصَعِدَ دُخَانُهُ كَدُخَانِ ٱلْأَتُونِ، وَٱرْتَجَفَ كُلُّ ٱلْجَبَلِ جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","فَكَانَ صَوْتُ ٱلْبُوقِ يَزْدَادُ ٱشْتِدَادًا جِدًّا، وَمُوسَى يَتَكَلَّمُ وَٱللهُ يُجِيبُهُ بِصَوْتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","وَنَزَلَ ٱلرَّبُّ عَلَى جَبَلِ سِينَاءَ، إِلَى رَأْسِ ٱلْجَبَلِ، وَدَعَا ٱللهُ مُوسَى إِلَى رَأْسِ ٱلْجَبَلِ. فَصَعِدَ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","فَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱنْحَدِرْ حَذِّرِ ٱلشَّعْبَ لِئَلَّا يَقْتَحِمُوا إِلَى ٱلرَّبِّ لِيَنْظُرُوا، فَيَسْقُطَ مِنْهُمْ كَثِيرُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","وَلْيَتَقَدَّسْ أَيْضًا ٱلْكَهَنَةُ ٱلَّذِينَ يَقْتَرِبُونَ إِلَى ٱلرَّبِّ لِئَلَّا يَبْطِشَ بِهِمِ ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","فَقَالَ مُوسَى لِلرَّبِّ: «لَا يَقْدِرُ ٱلشَّعْبُ أَنْ يَصْعَدَ إِلَى جَبَلِ سِينَاءَ، لِأَنَّكَ أَنْتَ حَذَّرْتَنَا قَائِلًا: أَقِمْ حُدُودًا لِلْجَبَلِ وَقَدِّسْهُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","فَقَالَ لَهُ ٱلرَّبُّ: «ٱذْهَبِ ٱنْحَدِرْ ثُمَّ ٱصْعَدْ أَنْتَ وَهَارُونُ مَعَكَ. وَأَمَّا ٱلْكَهَنَةُ وَٱلشَّعْبُ فَلَا يَقْتَحِمُوا لِيَصْعَدُوا إِلَى ٱلرَّبِّ لِئَلَّا يَبْطِشَ بِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","فَٱنْحَدَرَ مُوسَى إِلَى ٱلشَّعْبِ وَقَالَ لَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ثُمَّ تَكَلَّمَ ٱللهُ بِجَمِيعِ هَذِهِ ٱلْكَلِمَاتِ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«أَنَا ٱلرَّبُّ إِلَهُكَ ٱلَّذِي أَخْرَجَكَ مِنْ أَرْضِ مِصْرَ مِنْ بَيْتِ ٱلْعُبُودِيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","لَا يَكُنْ لَكَ آلِهَةٌ أُخْرَى أَمَامِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","لَا تَصْنَعْ لَكَ تِمْثَالًا مَنْحُوتًا، وَلَا صُورَةً مَا مِمَّا فِي ٱلسَّمَاءِ مِنْ فَوْقُ، وَمَا فِي ٱلْأَرْضِ مِنْ تَحْتُ، وَمَا فِي ٱلْمَاءِ مِنْ تَحْتِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","لَا تَسْجُدْ لَهُنَّ وَلَا تَعْبُدْهُنَّ، لِأَنِّي أَنَا ٱلرَّبَّ إِلَهَكَ إِلَهٌ غَيُورٌ، أَفْتَقِدُ ذُنُوبَ ٱلْآبَاءِ فِي ٱلْأَبْنَاءِ فِي ٱلْجِيلِ ٱلثَّالِثِ وَٱلرَّابِعِ مِنْ مُبْغِضِيَّ، ");
INSERT INTO arb_vd_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","وَأَصْنَعُ إِحْسَانًا إِلَى أُلُوفٍ مِنْ مُحِبِّيَّ وَحَافِظِي وَصَايَايَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","لَا تَنْطِقْ بِٱسْمِ ٱلرَّبِّ إِلَهِكَ بَاطِلًا، لِأَنَّ ٱلرَّبَّ لَا يُبْرِئُ مَنْ نَطَقَ بِٱسْمِهِ بَاطِلًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","اُذْكُرْ يَوْمَ ٱلسَّبْتِ لِتُقَدِّسَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","سِتَّةَ أَيَّامٍ تَعْمَلُ وَتَصْنَعُ جَمِيعَ عَمَلِكَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","وَأَمَّا ٱلْيَوْمُ ٱلسَّابِعُ فَفِيهِ سَبْتٌ لِلرَّبِّ إِلَهِكَ. لَا تَصْنَعْ عَمَلًا مَّا أَنْتَ وَٱبْنُكَ وَٱبْنَتُكَ وَعَبْدُكَ وَأَمَتُكَ وَبَهِيمَتُكَ وَنَزِيلُكَ ٱلَّذِي دَاخِلَ أَبْوَابِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","لِأَنْ فِي سِتَّةِ أَيَّامٍ صَنَعَ ٱلرَّبُّ ٱلسَّمَاءَ وَٱلْأَرْضَ وَٱلْبَحْرَ وَكُلَّ مَا فِيهَا، وَٱسْتَرَاحَ فِي ٱلْيَوْمِ ٱلسَّابِعِ. لِذَلِكَ بَارَكَ ٱلرَّبُّ يَوْمَ ٱلسَّبْتِ وَقَدَّسَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","أَكْرِمْ أَبَاكَ وَأُمَّكَ لِكَيْ تَطُولَ أَيَّامُكَ عَلَى ٱلْأَرْضِ ٱلَّتِي يُعْطِيكَ ٱلرَّبُّ إِلَهُكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","لَا تَقْتُلْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","لَا تَزْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","لَا تَسْرِقْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","لَا تَشْهَدْ عَلَى قَرِيبِكَ شَهَادَةَ زُورٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","لَا تَشْتَهِ بَيْتَ قَرِيبِكَ. لَا تَشْتَهِ ٱمْرَأَةَ قَرِيبِكَ، وَلَا عَبْدَهُ، وَلَا أَمَتَهُ، وَلَا ثَوْرَهُ، وَلَا حِمَارَهُ، وَلَا شَيْئًا مِمَّا لِقَرِيبِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","وَكَانَ جَمِيعُ ٱلشَّعْبِ يَرَوْنَ ٱلرُّعُودَ وَٱلْبُرُوقَ وَصَوْتَ ٱلْبُوقِ، وَٱلْجَبَلَ يُدَخِّنُ. وَلَمَّا رَأَى ٱلشَّعْبُ ٱرْتَعَدُوا وَوَقَفُوا مِنْ بَعِيدٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","وَقَالُوا لِمُوسَى: «تَكَلَّمْ أَنْتَ مَعَنَا فَنَسْمَعَ. وَلَا يَتَكَلَّمْ مَعَنَا ٱللهُ لِئَلَّا نَمُوتَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","فَقَالَ مُوسَى لِلشَّعْبِ: «لَا تَخَافُوا. لِأَنَّ ٱللهَ إِنَّمَا جَاءَ لِكَيْ يَمْتَحِنَكُمْ، وَلِكَيْ تَكُونَ مَخَافَتُهُ أَمَامَ وُجُوهِكُمْ حَتَّى لَا تُخْطِئُوا». ");
INSERT INTO arb_vd_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","فَوَقَفَ ٱلشَّعْبُ مِنْ بَعِيدٍ، وَأَمَّا مُوسَى فَٱقْتَرَبَ إِلَى ٱلضَّبَابِ حَيْثُ كَانَ ٱللهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","فَقَالَ ٱلرَّبُّ لِمُوسَى: «هَكَذَا تَقُولُ لِبَنِي إِسْرَائِيلَ: أَنْتُمْ رَأَيْتُمْ أَنَّنِي مِنَ ٱلسَّمَاءِ تَكَلَّمْتُ مَعَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","لَا تَصْنَعُوا مَعِي آلِهَةَ فِضَّةٍ، وَلَا تَصْنَعُوا لَكُمْ آلِهَةَ ذَهَبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","مَذْبَحًا مِنْ تُرَابٍ تَصْنَعُ لِي وَتَذْبَحُ عَلَيْهِ مُحْرَقَاتِكَ وَذَبَائِحَ سَلَامَتِكَ، غَنَمَكَ وَبَقَرَكَ. فِي كُلِّ ٱلْأَمَاكِنِ ٱلَّتِي فِيهَا أَصْنَعُ لِٱسْمِي ذِكْرًا آتِي إِلَيْكَ وَأُبَارِكُكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","وَإِنْ صَنَعْتَ لِي مَذْبَحًا مِنْ حِجَارَةٍ فَلَا تَبْنِهِ مِنْهَا مَنْحُوتَةً. إِذَا رَفَعْتَ عَلَيْهَا إِزْمِيلَكَ تُدَنِّسُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","وَلَا تَصْعَدْ بِدَرَجٍ إِلَى مَذْبَحِي كَيْلَا تَنْكَشِفَ عَوْرَتُكَ عَلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«وَهَذِهِ هِيَ ٱلْأَحْكَامُ ٱلَّتِي تَضَعُ أَمَامَهُمْ: ");
INSERT INTO arb_vd_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","إِذَا ٱشْتَرَيْتَ عَبْدًا عِبْرَانِيًّا، فَسِتَّ سِنِينَ يَخْدِمُ، وَفِي ٱلسَّابِعَةِ يَخْرُجُ حُرًّا مَجَّانًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","إِنْ دَخَلَ وَحْدَهُ فَوَحْدَهُ يَخْرُجُ. إِنْ كَانَ بَعْلَ ٱمْرَأَةٍ، تَخْرُجُ ٱمْرَأَتُهُ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","إِنْ أَعْطَاهُ سَيِّدُهُ ٱمْرَأَةً وَوَلَدَتْ لَهُ بَنِينَ أَوْ بَنَاتٍ، فَٱلْمَرْأَةُ وَأَوْلَادُهَا يَكُونُونَ لِسَيِّدِهِ، وَهُوَ يَخْرُجُ وَحْدَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","وَلَكِنْ إِنْ قَالَ ٱلْعَبْدُ: أُحِبُّ سَيِّدِي وَٱمْرَأَتِي وَأَوْلَادِي، لَا أَخْرُجُ حُرًّا، ");
INSERT INTO arb_vd_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","يُقَدِّمُهُ سَيِّدُهُ إِلَى ٱللهِ، وَيُقَرِّبُهُ إِلَى ٱلْبَابِ أَوْ إِلَى ٱلْقَائِمَةِ، وَيَثْقُبُ سَيِّدُهُ أُذْنَهُ بِٱلْمِثْقَبِ، فَيَخْدِمُهُ إِلَى ٱلْأَبَدِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","وَإِذَا بَاعَ رَجُلٌ ٱبْنَتَهُ أَمَةً، لَا تَخْرُجُ كَمَا يَخْرُجُ ٱلْعَبِيدُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","إِنْ قَبُحَتْ فِي عَيْنَيْ سَيِّدِهَا ٱلَّذِي خَطَبَهَا لِنَفْسِهِ، يَدَعُهَا تُفَكُّ. وَلَيْسَ لَهُ سُلْطَانٌ أَنْ يَبِيعَهَا لِقَوْمٍ أَجَانِبَ لِغَدْرِهِ بِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","وَإِنْ خَطَبَهَا لِٱبْنِهِ فَبِحَسَبِ حَقِّ ٱلْبَنَاتِ يَفْعَلُ لَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","إِنِ ٱتَّخَذَ لِنَفْسِهِ أُخْرَى، لَا يُنَقِّصُ طَعَامَهَا وَكِسْوَتَهَا وَمُعَاشَرَتَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","وَإِنْ لَمْ يَفْعَلْ لَهَا هَذِهِ ٱلثَّلَاثَ تَخْرُجُ مَجَّانًا بِلَا ثَمَنٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«مَنْ ضَرَبَ إِنْسَانًا فَمَاتَ يُقْتَلُ قَتْلًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","وَلَكِنَّ ٱلَّذِي لَمْ يَتَعَمَّدْ، بَلْ أَوْقَعَ ٱللهُ فِي يَدِهِ، فَأَنَا أَجْعَلُ لَكَ مَكَانًا يَهْرُبُ إِلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","وَإِذَا بَغَى إِنْسَانٌ عَلَى صَاحِبِهِ لِيَقْتُلَهُ بِغَدْرٍ فَمِنْ عِنْدِ مَذْبَحِي تَأْخُذُهُ لِلْمَوْتِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","وَمَنْ ضَرَبَ أَبَاهُ أَوْ أُمَّهُ يُقْتَلُ قَتْلًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","وَمَنْ سَرَقَ إِنْسَانًا وَبَاعَهُ، أَوْ وُجِدَ فِي يَدِهِ، يُقْتَلُ قَتْلًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","وَمَنْ شَتَمَ أَبَاهُ أَوْ أُمَّهُ يُقْتَلُ قَتْلًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","وَإِذَا تَخَاصَمَ رَجُلَانِ فَضَرَبَ أَحَدُهُمَا ٱلْآخَرَ بِحَجَرٍ أَوْ بِلَكْمَةٍ وَلَمْ يُقْتَلْ بَلْ سَقَطَ فِي ٱلْفِرَاشِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","فَإِنْ قَامَ وَتَمَشَّى خَارِجًا عَلَى عُكَّازِهِ يَكُونُ ٱلضَّارِبُ بَرِيئًا. إِلَّا أَنَّهُ يُعَوِّضُ عُطْلَتَهُ، وَيُنْفِقُ عَلَى شِفَائِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","وَإِذَا ضَرَبَ إِنْسَانٌ عَبْدَهُ أَوْ أَمَتَهُ بِٱلْعَصَا فَمَاتَ تَحْتَ يَدِهِ يُنْتَقَمُ مِنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","لَكِنْ إِنْ بَقِيَ يَوْمًا أَوْ يَوْمَيْنِ لَا يُنْتَقَمُ مِنْهُ لِأَنَّهُ مَالُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","وَإِذَا تَخَاصَمَ رِجَالٌ وَصَدَمُوا ٱمْرَأَةً حُبْلَى فَسَقَطَ وَلَدُهَا وَلَمْ تَحْصُلْ أَذِيَّةٌ، يُغَرَّمُ كَمَا يَضَعُ عَلَيْهِ زَوْجُ ٱلْمَرْأَةِ، وَيَدْفَعُ عَنْ يَدِ ٱلْقُضَاةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","وَإِنْ حَصَلَتْ أَذِيَّةٌ تُعْطِي نَفْسًا بِنَفْسٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","وَعَيْنًا بِعَيْنٍ، وَسِنًّا بِسِنٍّ، وَيَدًا بِيَدٍ، وَرِجْلًا بِرِجْلٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","وَكَيًّا بِكَيٍّ، وَجُرْحًا بِجُرْحٍ، وَرَضًّا بِرَضٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","وَإِذَا ضَرَبَ إِنْسَانٌ عَيْنَ عَبْدِهِ، أَوْ عَيْنَ أَمَتِهِ فَأَتْلَفَهَا، يُطْلِقُهُ حُرًّا عِوَضًا عَنْ عَيْنِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","وَإِنْ أَسْقَطَ سِنَّ عَبْدِهِ أَوْ سِنَّ أَمَتِهِ يُطْلِقُهُ حُرًّا عِوَضًا عَنْ سِنِّهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«وَإِذَا نَطَحَ ثَوْرٌ رَجُلًا أَوِ ٱمْرَأَةً فَمَاتَ، يُرْجَمُ ٱلثَّوْرُ وَلَا يُؤْكَلُ لَحْمُهُ. وَأَمَّا صَاحِبُ ٱلثَّوْرِ فَيَكُونُ بَرِيئًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","وَلَكِنْ إِنْ كَانَ ثَوْرًا نَطَّاحًا مِنْ قَبْلُ، وَقَدْ أُشْهِدَ عَلَى صَاحِبِهِ وَلَمْ يَضْبِطْهُ، فَقَتَلَ رَجُلًا أَوِ ٱمْرَأَةً، فَٱلثَّوْرُ يُرْجَمُ وَصَاحِبُهُ أَيْضًا يُقْتَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","إِنْ وُضِعَتْ عَلَيْهِ فِدْيَةٌ، يَدْفَعُ فِدَاءَ نَفْسِهِ كُلُّ مَا يُوضَعُ عَلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","أَوْ إِذَا نَطَحَ ٱبْنًا أَوْ نَطَحَ ٱبْنَةً فَبِحَسَبِ هَذَا ٱلْحُكْمِ يُفْعَلُ بِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","إِنْ نَطَحَ ٱلثَّوْرُ عَبْدًا أَوْ أَمَةً، يُعْطِي سَيِّدَهُ ثَلَاثِينَ شَاقِلَ فِضَّةٍ، وَٱلثَّوْرُ يُرْجَمُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","وَإِذَا فَتَحَ إِنْسَانٌ بِئْرًا، أَوْحَفَرَ إِنْسَانٌ بِئْرًا وَلَمْ يُغَطِّهِ، فَوَقَعَ فِيهِ ثَوْرٌ أَوْ حِمَارٌ، ");
INSERT INTO arb_vd_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","فَصَاحِبُ ٱلْبِئْرِ يُعَوِّضُ وَيَرُدُّ فِضَّةً لِصَاحِبِهِ، وَٱلْمَيْتُ يَكُونُ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","وَإِذَا نَطَحَ ثَوْرُ إِنْسَانٍ ثَوْرَ صَاحِبِهِ فَمَاتَ، يَبِيعَانِ ٱلثَّوْرَ ٱلْحَيَّ وَيَقْتَسِمَانِ ثَمَنَهُ. وَٱلْمَيْتُ أَيْضًا يَقْتَسِمَانِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","لَكِنْ إِذَا عُلِمَ أَنَّهُ ثَوْرٌ نَطَّاحٌ مِنْ قَبْلُ وَلَمْ يَضْبِطْهُ صَاحِبُهُ، يُعَوِّضُ عَنِ ٱلثَّوْرِ بِثَوْرٍ، وَٱلْمَيْتُ يَكُونُ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«إِذَا سَرَقَ إِنْسَانٌ ثَوْرًا أَوْ شَاةً فَذَبَحَهُ أَوْ بَاعَهُ، يُعَوِّضُ عَنِ ٱلثَّوْرِ بِخَمْسَةِ ثِيرَانٍ، وَعَنِ ٱلشَّاةِ بِأَرْبَعَةٍ مِنَ ٱلْغَنَمِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","إِنْ وُجِدَ ٱلسَّارِقُ وَهُوَ يَنْقُبُ، فَضُرِبَ وَمَاتَ، فَلَيْسَ لَهُ دَمٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","وَلَكِنْ إِنْ أَشْرَقَتْ عَلَيْهِ ٱلشَّمْسُ، فَلَهُ دَمٌ. إِنَّهُ يُعَوِّضُ. إِنْ لَمْ يَكُنْ لَهُ يُبَعْ بِسَرِقَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","إِنْ وُجِدَتِ ٱلسَّرِقَةُ فِي يَدِهِ حَيَّةً، ثَوْرًا كَانَتْ أَمْ حِمَارًا أَمْ شَاةً، يُعَوِّضُ بِٱثْنَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«إِذَا رَعَى إِنْسَانٌ حَقْلًا أَوْ كَرْمًا وَسَرَّحَ مَوَاشِيَهُ فَرَعَتْ فِي حَقْلِ غَيْرِهِ، فَمِنْ أَجْوَدِ حَقْلِهِ، وَأَجْوَدِ كَرْمِهِ يُعَوِّضُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","إِذَا خَرَجَتْ نَارٌ وَأَصَابَتْ شَوْكًا فَٱحْتَرَقَتْ أَكْدَاسٌ أَوْ زَرْعٌ أَوْ حَقْلٌ، فَٱلَّذِي أَوْقَدَ ٱلْوَقِيدَ يُعَوِّضُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","إِذَا أَعْطَى إِنْسَانٌ صَاحِبَهُ فِضَّةً أَوْ أَمْتِعَةً لِلْحِفْظِ، فَسُرِقَتْ مِنْ بَيْتِ ٱلْإِنْسَانِ، فَإِنْ وُجِدَ ٱلسَّارِقُ، يُعَوِّضُ بِٱثْنَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","وَإِنْ لَمْ يُوجَدِ ٱلسَّارِقُ يُقَدَّمُ صَاحِبُ ٱلْبَيْتِ إِلَى ٱللهِ لِيَحْكُمَ هَلْ لَمْ يَمُدَّ يَدَهُ إِلَى مُلْكِ صَاحِبِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","فِي كُلِّ دَعْوَى جِنَايَةٍ، مِنْ جِهَةِ ثَوْرٍ أَوْ حِمَارٍ أَوْ شَاةٍ أَوْ ثَوْبٍ أَوْ مَفْقُودٍ مَا، يُقَالُ: إِنَّ هَذَا هُوَ، تُقَدَّمُ إِلَى ٱللهِ دَعْوَاهُمَا. فَٱلَّذِي يَحْكُمُ ٱللهُ بِذَنْبِهِ، يُعَوِّضُ صَاحِبَهُ بِٱثْنَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","إِذَا أَعْطَى إِنْسَانٌ صَاحِبَهُ حِمَارًا أَوْ ثَوْرًا أَوْ شَاةً أَوْ بَهِيمَةً مَّا لِلْحِفْظِ، فَمَاتَ أَوِ ٱنْكَسَرَ أَوْ نُهِبَ وَلَيْسَ نَاظِرٌ، ");
INSERT INTO arb_vd_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","فَيَمِينُ ٱلرَّبِّ تَكُونُ بَيْنَهُمَا، هَلْ لَمْ يَمُدَّ يَدَهُ إِلَى مُلْكِ صَاحِبِهِ. فَيَقْبَلُ صَاحِبُهُ. فَلَا يُعَوِّضُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","وَإِنْ سُرِقَ مِنْ عِنْدِهِ يُعَوِّضُ صَاحِبَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","إِنِ ٱفْتُرِسَ يُحْضِرُهُ شَهَادَةً. لَا يُعَوِّضُ عَنِ ٱلْمُفْتَرَسِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","وَإِذَا ٱسْتَعَارَ إِنْسَانٌ مِنْ صَاحِبِهِ شَيْئًا فَٱنْكَسَرَ أَوْ مَاتَ، وَصَاحِبُهُ لَيْسَ مَعَهُ، يُعَوِّضُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","وَإِنْ كَانَ صَاحِبُهُ مَعَهُ لَا يُعَوِّضُ. إِنْ كَانَ مُسْتَأْجَرًا أَتَى بِأُجْرَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","«وَإِذَا رَاوَدَ رَجُلٌ عَذْرَاءَ لَمْ تُخْطَبْ، فَٱضْطَجَعَ مَعَهَا يَمْهُرُهَا لِنَفْسِهِ زَوْجَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","إِنْ أَبَى أَبُوهَا أَنْ يُعْطِيَهُ إِيَّاهَا، يَزِنُ لَهُ فِضَّةً كَمَهْرِ ٱلْعَذَارَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","لَا تَدَعْ سَاحِرَةً تَعِيشُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","كُلُّ مَنِ ٱضْطَجَعَ مَعَ بَهِيمَةٍ يُقْتَلُ قَتْلًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","مَنْ ذَبَحَ لِآلِهَةٍ غَيْرِ ٱلرَّبِّ وَحْدَهُ، يُهْلَكُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","«وَلَا تَضْطَهِدِ ٱلْغَرِيبَ وَلَا تُضَايِقْهُ، لِأَنَّكُمْ كُنْتُمْ غُرَبَاءَ فِي أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","لَا تُسِيءْ إِلَى أَرْمَلَةٍ مَّا وَلَا يَتِيمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","إِنْ أَسَأْتَ إِلَيْهِ فَإِنِّي إِنْ صَرَخَ إِلَيَّ أَسْمَعُ صُرَاخَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","فَيَحْمَى غَضَبِي وَأَقْتُلُكُمْ بِٱلسَّيْفِ، فَتَصِيرُ نِسَاؤُكُمْ أَرَامِلَ، وَأَوْلَادُكُمْ يَتَامَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","إِنْ أَقْرَضْتَ فِضَّةً لِشَعْبِي ٱلْفَقِيرِ ٱلَّذِي عِنْدَكَ فَلَا تَكُنْ لَهُ كَٱلْمُرَابِي. لَا تَضَعُوا عَلَيْهِ رِبًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","إِنِ ٱرْتَهَنْتَ ثَوْبَ صَاحِبِكَ فَإِلَى غُرُوبِ ٱلشَّمْسِ تَرُدُّهُ لَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","لِأَنَّهُ وَحْدَهُ غِطَاؤُهُ، هُوَ ثَوْبُهُ لِجِلْدِهِ، فِي مَاذَا يَنَامُ؟ فَيَكُونُ إِذَا صَرَخَ إِلَيَّ أَنِّي أَسْمَعُ، لِأَنِّي رَؤُوفٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«لَا تَسُبَّ ٱللهَ، وَلَا تَلْعَنْ رَئِيسًا فِي شَعْبِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","لَا تُؤَخِّرْ مِلْءَ بَيْدَرِكَ، وَقَطْرَ مِعْصَرَتِكَ، وَأَبْكَارَ بَنِيكَ تُعْطِينِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","كَذَلِكَ تَفْعَلُ بِبَقَرِكَ وَغَنَمِكَ. سَبْعَةَ أَيَّامٍ يَكُونُ مَعَ أُمِّهِ، وَفِي ٱلْيَوْمِ ٱلثَّامِنِ تُعْطِينِي إِيَّاهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","وَتَكُونُونَ لِي أُنَاسًا مُقَدَّسِينَ. وَلَحْمَ فَرِيسَةٍ فِي ٱلصَّحْرَاءِ لَا تَأْكُلُوا. لِلْكِلَابِ تَطْرَحُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«لَا تَقْبَلْ خَبَرًا كَاذِبًا، وَلَا تَضَعْ يَدَكَ مَعَ ٱلْمُنَافِقِ لِتَكُونَ شَاهِدَ ظُلْمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","لَا تَتْبَعِ ٱلْكَثِيرِينَ إِلَى فِعْلِ ٱلشَّرِّ، وَلَا تُجِبْ فِي دَعْوَى مَائِلًا وَرَاءَ ٱلْكَثِيرِينَ لِلتَّحْرِيفِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","وَلَا تُحَابِ مَعَ ٱلْمِسْكِينِ فِي دَعْوَاهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","إِذَا صَادَفْتَ ثَوْرَ عَدُوِّكَ أَوْ حِمَارَهُ شَارِدًا، تَرُدُّهُ إِلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","إِذَا رَأَيْتَ حِمَارَ مُبْغِضِكَ وَاقِعًا تَحْتَ حِمْلِهِ وَعَدَلْتَ عَنْ حَلِّهِ، فَلَا بُدَّ أَنْ تَحُلَّ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","لَا تُحَرِّفْ حَقَّ فَقِيرِكَ فِي دَعْوَاهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","اِبْتَعِدْ عَنْ كَلَامِ ٱلْكَذِبِ، وَلَا تَقْتُلِ ٱلْبَرِيءَ وَٱلْبَارَّ، لِأَنِّي لَا أُبَرِّرُ ٱلْمُذْنِبَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","وَلَا تَأْخُذْ رَشْوَةً، لِأَنَّ ٱلرَّشْوَةَ تُعْمِي ٱلْمُبْصِرِينَ، وَتُعَوِّجُ كَلَامَ ٱلْأَبْرَارِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","وَلَا تُضَايِقِ ٱلْغَرِيبَ فَإِنَّكُمْ عَارِفُونَ نَفْسَ ٱلْغَرِيبِ، لِأَنَّكُمْ كُنْتُمْ غُرَبَاءَ فِي أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«وَسِتَّ سِنِينَ تَزْرَعُ أَرْضَكَ وَتَجْمَعُ غَلَّتَهَا، ");
INSERT INTO arb_vd_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","وَأَمَّا فِي ٱلسَّابِعَةِ فَتُرِيحُهَا وَتَتْرُكُهَا لِيَأْكُلَ فُقَرَاءُ شَعْبِكَ. وَفَضْلَتُهُمْ تَأْكُلُهَا وُحُوشُ ٱلْبَرِّيَّةِ. كَذَلِكَ تَفْعَلُ بِكَرْمِكَ وَزَيْتُونِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","سِتَّةَ أَيَّامٍ تَعْمَلُ عَمَلَكَ. وَأَمَّا ٱلْيَوْمُ ٱلسَّابِعُ فَفِيهِ تَسْتَرِيحُ، لِكَيْ يَسْتَرِيحَ ثَوْرُكَ وَحِمَارُكَ، وَيَتَنَفَّسَ ٱبْنُ أَمَتِكَ وَٱلْغَرِيبُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","وَكُلُّ مَا قُلْتُ لَكُمُ ٱحْتَفِظُوا بِهِ، وَلَا تَذْكُرُوا ٱسْمَ آلِهَةٍ أُخْرَى، وَلَا يُسْمَعْ مِنْ فَمِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«ثَلَاثَ مَرَّاتٍ تُعَيِّدُ لِي فِي ٱلسَّنَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","تَحْفَظُ عِيدَ ٱلْفَطِيرِ. تَأْكُلُ فَطِيرًا سَبْعَةَ أَيَّامٍ كَمَا أَمَرْتُكَ فِي وَقْتِ شَهْرِ أَبِيبَ، لِأَنَّهُ فِيهِ خَرَجْتَ مِنْ مِصْرَ. وَلَا يَظْهَرُوا أَمَامِي فَارِغِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","وَعِيدَ ٱلْحَصَادِ أَبْكَارِ غَلَّاتِكَ ٱلَّتِي تَزْرَعُ فِي ٱلْحَقْلِ. وَعِيدَ ٱلْجَمْعِ فِي نِهَايَةِ ٱلسَّنَةِ عِنْدَمَا تَجْمَعُ غَلَّاتِكَ مِنَ ٱلْحَقْلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ثَلَاثَ مَرَّاتٍ فِي ٱلسَّنَةِ يَظْهَرُ جَمِيعُ ذُكُورِكَ أَمَامَ ٱلسَّيِّدِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","لَا تَذْبَحْ عَلَى خَمِيرٍ دَمَ ذَبِيحَتِي، وَلَا يَبِتْ شَحْمُ عِيدِي إِلَى ٱلْغَدِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","أَوَّلَ أَبْكَارِ أَرْضِكَ تُحْضِرُهُ إِلَى بَيْتِ ٱلرَّبِّ إِلَهِكَ. لَا تَطْبُخْ جَدْيًا بِلَبَنِ أُمِّهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«هَا أَنَا مُرْسِلٌ مَلَاكًا أَمَامَ وَجْهِكَ لِيَحْفَظَكَ فِي ٱلطَّرِيقِ، وَلِيَجِيءَ بِكَ إِلَى ٱلْمَكَانِ ٱلَّذِي أَعْدَدْتُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","اِحْتَرِزْ مِنْهُ وَٱسْمَعْ لِصَوْتِهِ وَلَا تَتَمَرَّدْ عَلَيْهِ، لِأَنَّهُ لَا يَصْفَحُ عَنْ ذُنُوبِكُمْ، لِأَنَّ ٱسْمِي فِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","وَلَكِنْ إِنْ سَمِعْتَ لِصَوْتِهِ وَفَعَلْتَ كُلَّ مَا أَتَكَلَّمُ بِهِ، أُعَادِي أَعْدَاءَكَ، وَأُضَايِقُ مُضَايِقِيكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","فَإِنَّ مَلَاكِي يَسِيرُ أَمَامَكَ وَيَجِيءُ بِكَ إِلَى ٱلْأَمُورِيِّينَ وَٱلْحِثِّيِّينَ وَٱلْفِرِزِّيِّينَ وَٱلْكَنْعَانِيِّينَ وَٱلْحِوِّيِّينَ وَٱلْيَبُوسِيِّينَ، فَأُبِيدُهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","لَا تَسْجُدْ لِآلِهَتِهِمْ، وَلَا تَعْبُدْهَا، وَلَا تَعْمَلْ كَأَعْمَالِهِمْ، بَلْ تُبِيدُهُمْ وَتَكْسِرُ أَنْصَابَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","وَتَعْبُدُونَ ٱلرَّبَّ إِلَهَكُمْ، فَيُبَارِكُ خُبْزَكَ وَمَاءَكَ، وَأُزِيلُ ٱلْمَرَضَ مِنْ بَيْنِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","لَا تَكُونُ مُسْقِطَةٌ وَلَا عَاقِرٌ فِي أَرْضِكَ، وَأُكَمِّلُ عَدَدَ أَيَّامِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","أُرْسِلُ هَيْبَتِي أَمَامَكَ، وَأُزْعِجُ جَمِيعَ ٱلشُّعُوبِ ٱلَّذِينَ تَأْتِي عَلَيْهِمْ، وَأُعْطِيكَ جَمِيعَ أَعْدَائِكَ مُدْبِرِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","وَأُرْسِلُ أَمَامَكَ ٱلزَّنَابِيرَ. فَتَطْرُدُ ٱلْحِوِّيِّينَ وَٱلْكَنْعَانِيِّينَ وَٱلْحِثِّيِّينَ مِنْ أَمَامِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","لَا أَطْرُدُهُمْ مِنْ أَمَامِكَ فِي سَنَةٍ وَاحِدَةٍ، لِئَلَّا تَصِيرَ ٱلْأَرْضُ خَرِبَةً، فَتَكْثُرَ عَلَيْكَ وُحُوشُ ٱلْبَرِّيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","قَلِيلًا قَلِيلًا أَطْرُدُهُمْ مِنْ أَمَامِكَ إِلَى أَنْ تُثْمِرَ وَتَمْلِكَ ٱلْأَرْضَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","وَأَجْعَلُ تُخُومَكَ مِنْ بَحْرِ سُوفٍ إِلَى بَحْرِ فِلِسْطِينَ، وَمِنَ ٱلْبَرِّيَّةِ إِلَى ٱلنَّهْرِ. فَإِنِّي أَدْفَعُ إِلَى أَيْدِيكُمْ سُكَّانَ ٱلْأَرْضِ، فَتَطْرُدُهُمْ مِنْ أَمَامِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","لَا تَقْطَعْ مَعَهُمْ وَلَا مَعَ آلِهَتِهِمْ عَهْدًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","لَا يَسْكُنُوا فِي أَرْضِكَ لِئَلَّا يَجْعَلُوكَ تُخْطِئُ إِلَيَّ. إِذَا عَبَدْتَ آلِهَتَهُمْ فَإِنَّهُ يَكُونُ لَكَ فَخًّا». ");
INSERT INTO arb_vd_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","وَقَالَ لِمُوسَى: «ٱصْعَدْ إِلَى ٱلرَّبِّ أَنْتَ وَهَارُونُ وَنَادَابُ وَأَبِيهُو، وَسَبْعُونَ مِنْ شُيُوخِ إِسْرَائِيلَ، وَٱسْجُدُوا مِنْ بَعِيدٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","وَيَقْتَرِبُ مُوسَى وَحْدَهُ إِلَى ٱلرَّبِّ، وَهُمْ لَا يَقْتَرِبُونَ. وَأَمَّا ٱلشَّعْبُ فَلَا يَصْعَدْ مَعَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","فَجَاءَ مُوسَى وَحَدَّثَ ٱلشَّعْبَ بِجَمِيعِ أَقْوَالِ ٱلرَّبِّ وَجَمِيعِ ٱلْأَحْكَامِ، فَأَجَابَ جَمِيعُ ٱلشَّعْبِ بِصَوْتٍ وَاحِدٍ وَقَالُوا: «كُلُّ ٱلْأَقْوَالِ ٱلَّتِي تَكَلَّمَ بِهَا ٱلرَّبُّ نَفْعَلُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","فَكَتَبَ مُوسَى جَمِيعَ أَقْوَالِ ٱلرَّبِّ. وَبَكَّرَ فِي ٱلصَّبَاحِ وَبَنَى مَذْبَحًا فِي أَسْفَلِ ٱلْجَبَلِ، وَٱثْنَيْ عَشَرَ عَمُودًا لِأَسْبَاطِ إِسْرَائِيلَ ٱلِٱثْنَيْ عَشَرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","وَأَرْسَلَ فِتْيَانَ بَنِي إِسْرَائِيلَ، فَأَصْعَدُوا مُحْرَقَاتٍ، وَذَبَحُوا ذَبَائِحَ سَلَامَةٍ لِلرَّبِّ مِنَ ٱلثِّيرَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","فَأَخَذَ مُوسَى نِصْفَ ٱلدَّمِ وَوَضَعَهُ فِي ٱلطُّسُوسِ. وَنِصْفَ ٱلدَّمِ رَشَّهُ عَلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","وَأَخَذَ كِتَابَ ٱلْعَهْدِ وَقَرَأَ فِي مَسَامِعِ ٱلشَّعْبِ، فَقَالُوا: «كُلُّ مَا تَكَلَّمَ بِهِ ٱلرَّبُّ نَفْعَلُ وَنَسْمَعُ لَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","وَأَخَذَ مُوسَى ٱلدَّمَ وَرَشَّ عَلَى ٱلشَّعْبِ وَقَالَ: «هُوَذَا دَمُ ٱلْعَهْدِ ٱلَّذِي قَطَعَهُ ٱلرَّبُّ مَعَكُمْ عَلَى جَمِيعِ هَذِهِ ٱلْأَقْوَالِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ثُمَّ صَعِدَ مُوسَى وَهَارُونُ وَنَادَابُ وَأَبِيهُو وَسَبْعُونَ مِنْ شُيُوخِ إِسْرَائِيلَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","وَرَأَوْا إِلَهَ إِسْرَائِيلَ، وَتَحْتَ رِجْلَيْهِ شِبْهُ صَنْعَةٍ مِنَ ٱلْعَقِيقِ ٱلْأَزْرَقِ ٱلشَّفَّافِ، وَكَذَاتِ ٱلسَّمَاءِ فِي ٱلنَّقَاوَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","وَلَكِنَّهُ لَمْ يَمُدَّ يَدَهُ إِلَى أَشْرَافِ بَنِي إِسْرَائِيلَ. فَرَأَوْا ٱللهَ وَأَكَلُوا وَشَرِبُوا. ");
INSERT INTO arb_vd_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","وَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱصْعَدْ إِلَيَّ إِلَى ٱلْجَبَلِ، وَكُنْ هُنَاكَ، فَأُعْطِيَكَ لَوْحَيِ ٱلْحِجَارَةِ وَٱلشَّرِيعَةِ وَٱلْوَصِيَّةِ ٱلَّتِي كَتَبْتُهَا لِتَعْلِيمِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","فَقَامَ مُوسَى وَيَشُوعُ خَادِمُهُ. وَصَعِدَ مُوسَى إِلَى جَبَلِ ٱللهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","وَأَمَّا ٱلشُّيُوخُ فَقَالَ لَهُمُ: «ٱجْلِسُوا لَنَا هَهُنَا حَتَّى نَرْجِعَ إِلَيْكُمْ. وَهُوَذَا هَارُونُ وَحُورُ مَعَكُمْ. فَمَنْ كَانَ صَاحِبَ دَعْوَى فَلْيَتَقَدَّمْ إِلَيْهِمَا». ");
INSERT INTO arb_vd_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","فَصَعِدَ مُوسَى إِلَى ٱلْجَبَلِ، فَغَطَّى ٱلسَّحَابُ ٱلْجَبَلَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","وَحَلَّ مَجْدُ ٱلرَّبِّ عَلَى جَبَلِ سِينَاءَ، وَغَطَّاهُ ٱلسَّحَابُ سِتَّةَ أَيَّامٍ. وَفِي ٱلْيَوْمِ ٱلسَّابِعِ دُعِيَ مُوسَى مِنْ وَسَطِ ٱلسَّحَابِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","وَكَانَ مَنْظَرُ مَجْدِ ٱلرَّبِّ كَنَارٍ آكِلَةٍ عَلَى رَأْسِ ٱلْجَبَلِ أَمَامَ عُيُونِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","وَدَخَلَ مُوسَى فِي وَسَطِ ٱلسَّحَابِ وَصَعِدَ إِلَى ٱلْجَبَلِ. وَكَانَ مُوسَى فِي ٱلْجَبَلِ أَرْبَعِينَ نَهَارًا وَأَرْبَعِينَ لَيْلَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ أَنْ يَأْخُذُوا لِي تَقْدِمَةً. مِنْ كُلِّ مَنْ يَحِثُّهُ قَلْبُهُ تَأْخُذُونَ تَقْدِمَتِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","وَهَذِهِ هِيَ ٱلتَّقْدِمَةُ ٱلَّتِي تَأْخُذُونَهَا مِنْهُمْ: ذَهَبٌ وَفِضَّةٌ وَنُحَاسٌ، ");
INSERT INTO arb_vd_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","وَأَسْمَانْجُونِيٌّ وَأُرْجُوَانٌ وَقِرْمِزٌ وَبُوصٌ وَشَعْرُ مِعْزَى، ");
INSERT INTO arb_vd_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","وَجُلُودُ كِبَاشٍ مُحَمَّرَةٌ وَجُلُودُ تُخَسٍ وَخَشَبُ سَنْطٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","وَزَيْتٌ لِلْمَنَارَةِ وَأَطْيَابٌ لِدُهْنِ ٱلْمَسْحَةِ وَلِلْبَخُورِ ٱلْعَطِرِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","وَحِجَارَةُ جَزْعٍ وَحِجَارَةُ تَرْصِيعٍ لِلرِّدَاءِ وَٱلصُّدْرَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","فَيَصْنَعُونَ لِي مَقْدِسًا لِأَسْكُنَ فِي وَسَطِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","بِحَسَبِ جَمِيعِ مَا أَنَا أُرِيكَ مِنْ مِثَالِ ٱلْمَسْكَنِ، وَمِثَالِ جَمِيعِ آنِيَتِهِ هَكَذَا تَصْنَعُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«فَيَصْنَعُونَ تَابُوتًا مِنْ خَشَبِ ٱلسَّنْطِ، طُولُهُ ذِرَاعَانِ وَنِصْفٌ، وَعَرْضُهُ ذِرَاعٌ وَنِصْفٌ، وَٱرْتِفَاعُهُ ذِرَاعٌ وَنِصْفٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","وَتُغَشِّيهِ بِذَهَبٍ نَقِيٍّ. مِنْ دَاخِلٍ وَمِنْ خَارِجٍ تُغَشِّيهِ، وَتَصْنَعُ عَلَيْهِ إِكْلِيلًا مِنْ ذَهَبٍ حَوَالَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","وَتَسْبِكُ لَهُ أَرْبَعَ حَلَقَاتٍ مِنْ ذَهَبٍ، وَتَجْعَلُهَا عَلَى قَوَائِمِهِ ٱلْأَرْبَعِ. عَلَى جَانِبِهِ ٱلْوَاحِدِ حَلْقَتَانِ، وَعَلَى جَانِبِهِ ٱلثَّانِي حَلْقَتَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","وَتَصْنَعُ عَصَوَيْنِ مِنْ خَشَبِ ٱلسَّنْطِ وَتُغَشِّيهِمَا بِذَهَبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","وَتُدْخِلُ ٱلْعَصَوَيْنِ فِي ٱلْحَلَقَاتِ عَلَى جَانِبَيِ ٱلتَّابُوتِ لِيُحْمَلَ ٱلتَّابُوتُ بِهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","تَبْقَى ٱلْعَصَوَانِ فِي حَلَقَاتِ ٱلتَّابُوتِ. لَا تُنْزَعَانِ مِنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","وَتَضَعُ فِي ٱلتَّابُوتِ ٱلشَّهَادَةَ ٱلَّتِي أُعْطِيكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«وَتَصْنَعُ غِطَاءً مِنْ ذَهَبٍ نَقِيٍّ طُولُهُ ذِرَاعَانِ وَنِصْفٌ، وَعَرْضُهُ ذِرَاعٌ وَنِصْفٌ، ");
INSERT INTO arb_vd_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","وَتَصْنَعُ كَرُوبَيْنِ مِنْ ذَهَبٍ. صَنْعَةَ خِرَاطَةٍ تَصْنَعُهُمَا عَلَى طَرَفَيِ ٱلْغِطَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","فَٱصْنَعْ كَرُوبًا وَاحِدًا عَلَى ٱلطَّرَفِ مِنْ هُنَا، وَكَرُوبًا آخَرَ عَلَى ٱلطَّرَفِ مِنْ هُنَاكَ. مِنَ ٱلْغِطَاءِ تَصْنَعُونَ ٱلْكَرُوبَيْنِ عَلَى طَرَفَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","وَيَكُونُ ٱلْكَرُوبَانِ بَاسِطَيْنِ أَجْنِحَتَهُمَا إِلَى فَوْقُ، مُظَلِّلَيْنِ بِأَجْنِحَتِهِمَا عَلَى ٱلْغِطَاءِ، وَوَجْهَاهُمَا كُلُّ وَاحِدٍ إِلَى ٱلْآخَرِ. نَحْوَ ٱلْغِطَاءِ يَكُونُ وَجْهَا ٱلْكَرُوبَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","وَتَجْعَلُ ٱلْغِطَاءَ عَلَى ٱلتَّابُوتِ مِنْ فَوْقُ، وَفِي ٱلتَّابُوتِ تَضَعُ ٱلشَّهَادَةَ ٱلَّتِي أُعْطِيكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","وَأَنَا أَجْتَمِعُ بِكَ هُنَاكَ وَأَتَكَلَّمُ مَعَكَ، مِنْ عَلَى ٱلْغِطَاءِ مِنْ بَيْنِ ٱلْكَرُوبَيْنِ ٱللَّذَيْنِ عَلَى تَابُوتِ ٱلشَّهَادَةِ، بِكُلِّ مَا أُوصِيكَ بِهِ إِلَى بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«وَتَصْنَعُ مَائِدَةً مِنْ خَشَبِ ٱلسَّنْطِ طُولُهَا ذِرَاعَانِ، وَعَرْضُهَا ذِرَاعٌ، وَٱرْتِفَاعُهَا ذِرَاعٌ وَنِصْفٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","وَتُغَشِّيهَا بِذَهَبٍ نَقِيٍّ، وَتَصْنَعُ لَهَا إِكْلِيلًا مِنْ ذَهَبٍ حَوَالَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","وَتَصْنَعُ لَهَا حَاجِبًا عَلَى شِبْرٍ حَوَالَيْهَا، وَتَصْنَعُ لِحَاجِبِهَا إِكْلِيلًا مِنْ ذَهَبٍ حَوَالَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","وَتَصْنَعُ لَهَا أَرْبَعَ حَلَقَاتٍ مِنْ ذَهَبٍ، وَتَجْعَلُ ٱلْحَلَقَاتِ عَلَى ٱلزَّوَايَا ٱلْأَرْبَعِ ٱلَّتِي لِقَوَائِمِهَا ٱلْأَرْبَعِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","عِنْدَ ٱلْحَاجِبِ تَكُونُ ٱلْحَلَقَاتُ بُيُوتًا لِعَصَوَيْنِ لِحَمْلِ ٱلْمَائِدَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","وَتَصْنَعُ ٱلْعَصَوَيْنِ مِنْ خَشَبِ ٱلسَّنْطِ وَتُغَشِّيهِمَا بِذَهَبٍ، فَتُحْمَلُ بِهِمَا ٱلْمَائِدَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","وَتَصْنَعُ صِحَافَهَا وَصُحُونَهَا وَكَأْسَاتِهَا وَجَامَاتِهَا ٱلَّتِي يُسْكَبُ بِهَا. مِنْ ذَهَبٍ نَقِيٍّ تَصْنَعُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","وَتَجْعَلُ عَلَى ٱلْمَائِدَةِ خُبْزَ ٱلْوُجُوهِ أَمَامِي دَائِمًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«وَتَصْنَعُ مَنَارَةً مِنْ ذَهَبٍ نَقِيٍّ. عَمَلَ ٱلْخِرَاطَةِ تُصْنَعُ ٱلْمَنَارَةُ، قَاعِدَتُهَا وَسَاقُهَا. تَكُونُ كَأْسَاتُهَا وَعُجَرُهَا وَأَزْهَارُهَا مِنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","وَسِتُّ شُعَبٍ خَارِجَةٌ مِنْ جَانِبَيْهَا. مِنْ جَانِبِهَا ٱلْوَاحِدِ ثَلَاثُ شُعَبِ مَنَارَةٍ، وَمِنْ جَانِبِهَا ٱلثَّانِي ثَلَاثُ شُعَبِ مَنَارَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","فِي ٱلشُّعْبَةِ ٱلْوَاحِدَةِ ثَلَاثُ كَأْسَاتٍ لَوْزِيَّةٍ بِعُجْرَةٍ وَزَهْرٍ، وَفِي ٱلشُّعْبَةِ ٱلثَّانِيَةِ ثَلَاثُ كَأْسَاتٍ لَوْزِيَّةٍ بِعُجْرَةٍ وَزَهْرٍ، وَهَكَذَا إِلَى ٱلسِّتِّ ٱلشُّعَبِ ٱلْخَارِجَةِ مِنَ ٱلْمَنَارَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","وَفِي ٱلْمَنَارَةِ أَرْبَعُ كَأْسَاتٍ لَوْزِيَّةٍ بِعُجَرِهَا وَأَزْهَارِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","وَتَحْتَ ٱلشُّعْبَتَيْنِ مِنْهَا عُجْرَةٌ، وَتَحْتَ ٱلشُّعْبَتَيْنِ مِنْهَا عُجْرَةٌ، وَتَحْتَ ٱلشُّعْبَتَيْنِ مِنْهَا عُجْرَةٌ إِلَى ٱلسِّتِّ ٱلشُّعَبِ ٱلْخَارِجَةِ مِنَ ٱلْمَنَارَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","تَكُونُ عُجَرُهَا وَشُعَبُهَا مِنْهَا. جَمِيعُهَا خِرَاطَةٌ وَاحِدَةٌ مِنْ ذَهَبٍ نَقِيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","وَتَصْنَعُ سُرُجَهَا سَبْعَةً، فَتُصْعَدُ سُرُجُهَا لِتُضِيءَ إِلَى مُقَابِلِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","وَمَلَاقِطُهَا وَمَنَافِضُهَا مِنْ ذَهَبٍ نَقِيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","مِنْ وَزْنَةِ ذَهَبٍ نَقِيٍّ تُصْنَعُ مَعَ جَمِيعِ هَذِهِ ٱلْأَوَانِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","وَٱنْظُرْ فَٱصْنَعْهَا عَلَى مِثَالِهَا ٱلَّذِي أُظْهِرَ لَكَ فِي ٱلْجَبَلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«وَأَمَّا ٱلْمَسْكَنُ فَتَصْنَعُهُ مِنْ عَشَرِ شُقَقِ بُوصٍ مَبْرُومٍ وَأَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ. بِكَرُوبِيمَ صَنْعَةَ حَائِكٍ حَاذِقٍ تَصْنَعُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","طُولُ ٱلشُّقَّةِ ٱلْوَاحِدَةِ ثَمَانٍ وَعِشْرُونَ ذِرَاعًا، وَعَرْضُ ٱلشُّقَّةِ ٱلْوَاحِدَةِ أَرْبَعُ أَذْرُعٍ. قِيَاسًا وَاحِدًا لِجَمِيعِ ٱلشُّقَقِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","تَكُونُ خَمْسٌ مِنَ ٱلشُّقَقِ بَعْضُهَا مَوْصُولٌ بِبَعْضٍ، وَخَمْسُ شُقَقٍ بَعْضُهَا مَوْصُولٌ بِبَعْضٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","وَتَصْنَعُ عُرًى مِنْ أَسْمَانْجُونِيٍّ عَلَى حَاشِيَةِ ٱلشُّقَّةِ ٱلْوَاحِدَةِ فِي ٱلطَّرَفِ مِنَ ٱلْمُوَصَّلِ ٱلْوَاحِدِ. وَكَذَلِكَ تَصْنَعُ فِي حَاشِيَةِ ٱلشُّقَّةِ ٱلطَّرَفِيَّةِ مِنَ ٱلْمُوَصَّلِ ٱلثَّانِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","خَمْسِينَ عُرْوَةً تَصْنَعُ فِي ٱلشُّقَّةِ ٱلْوَاحِدَةِ، وَخَمْسِينَ عُرْوَةً تَصْنَعُ فِي طَرَفِ ٱلشُّقَّةِ ٱلَّذِي فِي ٱلْمُوَصَّلِ ٱلثَّانِي. تَكُونُ ٱلْعُرَى بَعْضُهَا مُقَابِلٌ لِبَعْضٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","وَتَصْنَعُ خَمْسِينَ شِظَاظًا مِنْ ذَهَبٍ، وَتَصِلُ ٱلشُّقَّتَيْنِ بَعْضَهُمَا بِبَعْضٍ بِٱلْأَشِظَّةِ. فَيَصِيرُ ٱلْمَسْكَنُ وَاحِدًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«وَتَصْنَعُ شُقَقًا مِنْ شَعْرِ مِعْزَى خَيْمَةً عَلَى ٱلْمَسْكَنِ. إِحْدَى عَشْرَةَ شُقَّةً تَصْنَعُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","طُولُ ٱلشُّقَّةِ ٱلْوَاحِدَةِ ثَلَاثُونَ ذِرَاعًا، وَعَرْضُ ٱلشُّقَّةِ ٱلْوَاحِدَةِ أَرْبَعُ أَذْرُعٍ. قِيَاسًا وَاحِدًا لِلْإِحْدَى عَشْرَةَ شُقَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","وَتَصِلُ خَمْسًا مِنَ ٱلشُّقَقِ وَحْدَهَا، وَسِتًّا مِنَ ٱلشُّقَقِ وَحْدَهَا. وَتَثْنِي ٱلشُّقَّةَ ٱلسَّادِسَةَ فِي وَجْهِ ٱلْخَيْمَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","وَتَصْنَعُ خَمْسِينَ عُرْوَةً عَلَى حَاشِيَةِ ٱلشُّقَّةِ ٱلْوَاحِدَةِ ٱلطَّرَفِيَّةِ مِنَ ٱلْمُوَصَّلِ ٱلْوَاحِدِ، وَخَمْسِينَ عُرْوَةً عَلَى حَاشِيَةِ ٱلشُّقَّةِ مِنَ ٱلْمُوَصَّلِ ٱلثَّانِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","وَتَصْنَعُ خَمْسِينَ شِظَاظًا مِنْ نُحَاسٍ، وَتُدْخِلُ ٱلْأَشِظَّةَ فِي ٱلْعُرَى، وَتَصِلُ ٱلْخَيْمَةَ فَتَصِيرُ وَاحِدَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","وَأَمَّا ٱلْمُدَلَّى ٱلْفَاضِلُ مِنْ شُقَقِ ٱلْخَيْمَةِ، نِصْفُ ٱلشُّقَّةِ ٱلْمُوَصَّلَةِ ٱلْفَاضِلُ، فَيُدَلَّى عَلَى مُؤَخَّرِ ٱلْمَسْكَنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","وَٱلذِّرَاعُ مِنْ هُنَا وَٱلذِّرَاعُ مِنْ هُنَاكَ، مِنَ ٱلْفَاضِلِ فِي طُولِ شُقَقِ ٱلْخَيْمَةِ، تَكُونَانِ مُدَلَّاتَيْنِ عَلَى جَانِبَيِ ٱلْمَسْكَنِ مِنْ هُنَا وَمِنْ هُنَاكَ لِتَغْطِيَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","وَتَصْنَعُ غِطَاءً لِلْخَيْمَةِ مِنْ جُلُودِ كِبَاشٍ مُحَمَّرَةٍ، وَغِطَاءً مِنْ جُلُودِ تُخَسٍ مِنْ فَوْقُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«وَتَصْنَعُ ٱلْأَلْوَاحَ لِلْمَسْكَنِ مِنْ خَشَبِ ٱلسَّنْطِ قَائِمَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","طُولُ ٱللَّوْحِ عَشَرُ أَذْرُعٍ، وَعَرْضُ ٱللَّوْحِ ٱلْوَاحِدِ ذِرَاعٌ وَنِصْفٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","وَلِلَّوْحِ ٱلْوَاحِدِ رِجْلَانِ مَقْرُونَةٌ إِحْدَاهُمَا بِٱلْأُخْرَى. هَكَذَا تَصْنَعُ لِجَمِيعِ أَلْوَاحِ ٱلْمَسْكَنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","وَتَصْنَعُ ٱلْأَلْوَاحَ لِلْمَسْكَنِ عِشْرِينَ لَوْحًا إِلَى جِهَةِ ٱلْجَنُوبِ نَحْوَ ٱلتَّيْمَنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","وَتَصْنَعُ أَرْبَعِينَ قَاعِدَةً مِنْ فِضَّةٍ تَحْتَ ٱلْعِشْرِينَ لَوْحًا. تَحْتَ ٱللَّوْحِ ٱلْوَاحِدِ قَاعِدَتَانِ لِرِجْلَيْهِ، وَتَحْتَ ٱللَّوْحِ ٱلْوَاحِدِ قَاعِدَتَانِ لِرِجْلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","وَلِجَانِبِ ٱلْمَسْكَنِ ٱلثَّانِي إِلَى جِهَةِ ٱلشِّمَالِ عِشْرِينَ لَوْحًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","وَأَرْبَعِينَ قَاعِدَةً لَهَا مِنْ فِضَّةٍ. تَحْتَ ٱللَّوْحِ ٱلْوَاحِدِ قَاعِدَتَانِ، وَتَحْتَ ٱللَّوْحِ ٱلْوَاحِدِ قَاعِدَتَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","وَلِمُؤَخَّرِ ٱلْمَسْكَنِ نَحْوَ ٱلْغَرْبِ تَصْنَعُ سِتَّةَ أَلْوَاحٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","وَتَصْنَعُ لَوْحَيْنِ لِزَاوِيَتَيِ ٱلْمَسْكَنِ فِي ٱلْمُؤَخَّرِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","وَيَكُونَانِ مُزْدَوِجَيْنِ مِنْ أَسْفَلُ. وَعَلَى سَوَاءٍ يَكُونَانِ مُزْدَوِجَيْنِ إِلَى رَأْسِهِ إِلَى ٱلْحَلْقَةِ ٱلْوَاحِدَةِ. هَكَذَا يَكُونُ لِكِلَيْهِمَا. يَكُونَانِ لِلزَّاوِيَتَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","فَتَكُونُ ثَمَانِيَةَ أَلْوَاحٍ، وَقَوَاعِدُهَا مِنْ فِضَّةٍ سِتَّ عَشْرَةَ قَاعِدَةً. تَحْتَ ٱللَّوْحِ ٱلْوَاحِدِ قَاعِدَتَانِ، وَتَحْتَ ٱللَّوْحِ ٱلْوَاحِدِ قَاعِدَتَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«وَتَصْنَعُ عَوَارِضَ مِنْ خَشَبِ ٱلسَّنْطِ، خَمْسًا لِأَلْوَاحِ جَانِبِ ٱلْمَسْكَنِ ٱلْوَاحِدِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","وَخَمْسَ عَوَارِضَ لِأَلْوَاحِ جَانِبِ ٱلْمَسْكَنِ ٱلثَّانِي، وَخَمْسَ عَوَارِضَ لِأَلْوَاحِ جَانِبِ ٱلْمَسْكَنِ فِي ٱلْمُؤَخَّرِ نَحْوَ ٱلْغَرْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","وَٱلْعَارِضَةُ ٱلْوُسْطَى فِي وَسَطِ ٱلْأَلْوَاحِ تَنْفُذُ مِنَ ٱلطَّرَفِ إِلَى ٱلطَّرَفِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","وَتُغَشِّي ٱلْأَلْوَاحَ بِذَهَبٍ، وَتَصْنَعُ حَلَقَاتِهَا مِنْ ذَهَبٍ بُيُوتًا لِلْعَوَارِضِ، وَتُغَشِّي ٱلْعَوَارِضَ بِذَهَبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","وَتُقِيمُ ٱلْمَسْكَنَ كَرَسْمِهِ ٱلَّذِي أُظْهِرَ لَكَ فِي ٱلْجَبَلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«وَتَصْنَعُ حِجَابًا مِنْ أَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ. صَنْعَةَ حَائِكٍ حَاذِقٍ يَصْنَعُهُ بِكَرُوبِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","وَتَجْعَلُهُ عَلَى أَرْبَعَةِ أَعْمِدَةٍ مِنْ سَنْطٍ مُغَشَّاةٍ بِذَهَبٍ. رُزَزُهَا مِنْ ذَهَبٍ. عَلَى أَرْبَعِ قَوَاعِدَ مِنْ فِضَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","وَتَجْعَلُ ٱلْحِجَابَ تَحْتَ ٱلْأَشِظَّةِ. وَتُدْخِلُ إِلَى هُنَاكَ دَاخِلَ ٱلْحِجَابِ تَابُوتَ ٱلشَّهَادَةِ، فَيَفْصِلُ لَكُمُ ٱلْحِجَابُ بَيْنَ ٱلْقُدْسِ وَقُدْسِ ٱلْأَقْدَاسِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","وَتَجْعَلُ ٱلْغِطَاءَ عَلَى تَابُوتِ ٱلشَّهَادَةِ فِي قُدْسِ ٱلْأَقْدَاسِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","وَتَضَعُ ٱلْمَائِدَةَ خَارِجَ ٱلْحِجَابِ، وَٱلْمَنَارَةَ مُقَابِلَ ٱلْمَائِدَةِ عَلَى جَانِبِ ٱلْمَسْكَنِ نَحْوَ ٱلتَّيْمَنِ، وَتَجْعَلُ ٱلْمَائِدَةَ عَلَى جَانِبِ ٱلشِّمَالِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«وَتَصْنَعُ سَجْفًا لِمَدْخَلِ ٱلْخَيْمَةِ مِنْ أَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ صَنْعَةَ ٱلطَّرَّازِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","وَتَصْنَعُ لِلسَّجْفِ خَمْسَةَ أَعْمِدَةٍ مِنْ سَنْطٍ وَتُغَشِّيهَا بِذَهَبٍ. رُزَزُهَا مِنْ ذَهَبٍ، وَتَسْبِكُ لَهَا خَمْسَ قَوَاعِدَ مِنْ نُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«وَتَصْنَعُ ٱلْمَذْبَحَ مِنْ خَشَبِ ٱلسَّنْطِ، طُولُهُ خَمْسُ أَذْرُعٍ، وَعَرْضُهُ خَمْسُ أَذْرُعٍ. مُرَبَّعًا يَكُونُ ٱلْمَذْبَحُ. وَٱرْتِفَاعُهُ ثَلَاثُ أَذْرُعٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","وَتَصْنَعُ قُرُونَهُ عَلَى زَوَايَاهُ ٱلْأَرْبَعِ. مِنْهُ تَكُونُ قُرُونُهُ، وَتُغَشِّيهِ بِنُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","وَتَصْنَعُ قُدُورَهُ لِرَفْعِ رَمَادِهِ، وَرُفُوشَهُ وَمَرَاكِنَهُ وَمَنَاشِلَهُ وَمَجَامِرَهُ. جَمِيعَ آنِيَتِهِ تَصْنَعُهَا مِنْ نُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","وَتَصْنَعُ لَهُ شُبَّاكَةً صَنْعَةَ ٱلشَّبَكَةِ مِنْ نُحَاسٍ، وَتَصْنَعُ عَلَى ٱلشَّبَكَةِ أَرْبَعَ حَلَقَاتٍ مِنْ نُحَاسٍ عَلَى أَرْبَعَةِ أَطْرَافِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","وَتَجْعَلُهَا تَحْتَ حَاجِبِ ٱلْمَذْبَحِ مِنْ أَسْفَلُ، وَتَكُونُ ٱلشَّبَكَةُ إِلَى نِصْفِ ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","وَتَصْنَعُ عَصَوَيْنِ لِلْمَذْبَحِ، عَصَوَيْنِ مِنْ خَشَبِ ٱلسَّنْطِ وَتُغَشِّيهِمَا بِنُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","وَتُدْخَلُ عَصَوَاهُ فِي ٱلْحَلَقَاتِ، فَتَكُونُ ٱلْعَصَوَانِ عَلَى جَانِبَيِ ٱلْمَذْبَحِ حِينَمَا يُحْمَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","مُجَوَّفًا تَصْنَعُهُ مِنْ أَلْوَاحٍ، كَمَا أُظْهِرَ لَكَ فِي ٱلْجَبَلِ هَكَذَا يَصْنَعُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«وَتَصْنَعُ دَارَ ٱلْمَسْكَنِ. إِلَى جِهَةِ ٱلْجَنُوبِ نَحْوَ ٱلتَّيْمَنِ لِلدَّارِ أَسْتَارٌ مِنْ بُوصٍ مَبْرُومٍ مِئَةُ ذِرَاعٍ طُولًا إِلَى ٱلْجِهَةِ ٱلْوَاحِدَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","وَأَعْمِدَتُهَا عِشْرُونَ، وَقَوَاعِدُهَا عِشْرُونَ مِنْ نُحَاسٍ. رُزَزُ ٱلْأَعْمِدَةِ وَقُضْبَانُهَا مِنْ فِضَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","وَكَذَلِكَ إِلَى جِهَةِ ٱلشِّمَالِ فِي ٱلطُّولِ أَسْتَارٌ مِئَةُ ذِرَاعٍ طُولًا. وَأَعْمِدَتُهَا عِشْرُونَ، وَقَوَاعِدُهَا عِشْرُونَ مِنْ نُحَاسٍ. رُزَزُ ٱلْأَعْمِدَةِ وَقُضْبَانُهَا مِنْ فِضَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","وَفِي عَرْضِ ٱلدَّارِ إِلَى جِهَةِ ٱلْغَرْبِ أَسْتَارٌ خَمْسُونَ ذِرَاعًا. أَعْمِدَتُهَا عَشْرَةٌ، وَقَوَاعِدُهَا عَشْرٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","وَعَرْضُ ٱلدَّارِ إِلَى جِهَةِ ٱلشَّرْقِ نَحْوَ ٱلشُّرُوقِ خَمْسُونَ ذِرَاعًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","وَخَمْسَ عَشْرَةَ ذِرَاعًا مِنَ ٱلْأَسْتَارِ لِلْجَانِبِ ٱلْوَاحِدِ. أَعْمِدَتُهَا ثَلَاثَةٌ وَقَوَاعِدُهَا ثَلَاثٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","وَلِلْجَانِبِ ٱلثَّانِي خَمْسَ عَشْرَةَ ذِرَاعًا مِنَ ٱلْأَسْتَارِ. أَعْمِدَتُهَا ثَلَاثَةٌ وَقَوَاعِدُهَا ثَلَاثٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","وَلِبَابِ ٱلدَّارِ سَجْفٌ عِشْرُونَ ذِرَاعًا مِنْ أَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ صَنْعَةَ ٱلطَّرَّازِ. أَعْمِدَتُهُ أَرْبَعَةٌ، وَقَوَاعِدُهَا أَرْبَعٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","لِكُلِّ أَعْمِدَةِ ٱلدَّارِ حَوَالَيْهَا قُضْبَانٌ مِنْ فِضَّةٍ. رُزَزُهَا مِنْ فِضَّةٍ، وَقَوَاعِدُهَا مِنْ نُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","طُولُ ٱلدَّارِ مِئَةُ ذِرَاعٍ، وَعَرْضُهَا خَمْسُونَ فَخَمْسُونَ، وَٱرْتِفَاعُهَا خَمْسُ أَذْرُعٍ مِنْ بُوصٍ مَبْرُومٍ، وَقَوَاعِدُهَا مِنْ نُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","جَمِيعُ أَوَانِي ٱلْمَسْكَنِ فِي كُلِّ خِدْمَتِهِ وَجَمِيعُ أَوْتَادِهِ وَجَمِيعُ أَوْتَادِ ٱلدَّارِ مِنْ نُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«وَأَنْتَ تَأْمُرُ بَنِي إِسْرَائِيلَ أَنْ يُقَدِّمُوا إِلَيْكَ زَيْتَ زَيْتُونٍ مَرْضُوضٍ نَقِيًّا لِلضَّوْءِ لِإِصْعَادِ ٱلسُّرُجِ دَائِمًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","فِي خَيْمَةِ ٱلِٱجْتِمَاعِ، خَارِجَ ٱلْحِجَابِ ٱلَّذِي أَمَامَ ٱلشَّهَادَةِ، يُرَتِّبُهَا هَارُونُ وَبَنُوهُ مِنَ ٱلْمَسَاءِ إِلَى ٱلصَّبَاحِ أَمَامَ ٱلرَّبِّ. فَرِيضَةً دَهْرِيَّةً فِي أَجْيَالِهِمْ مِنْ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«وَقَرِّبْ إِلَيْكَ هَارُونَ أَخَاكَ وَبَنِيهِ مَعَهُ مِنْ بَيْنِ بَنِي إِسْرَائِيلَ لِيَكْهَنَ لِي. هَارُونَ نَادَابَ وَأَبِيهُوَ أَلِعَازَارَ وَإِيثَامَارَ بَنِي هَارُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","وَٱصْنَعْ ثِيَابًا مُقَدَّسَةً لِهَارُونَ أَخِيكَ لِلْمَجْدِ وَٱلْبَهَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","وَتُكَلِّمُ جَمِيعَ حُكَمَاءِ ٱلْقُلُوبِ ٱلَّذِينَ مَلَأْتُهُمْ رُوحَ حِكْمَةٍ، أَنْ يَصْنَعُوا ثِيَابَ هَارُونَ لِتَقْدِيسِهِ لِيَكْهَنَ لِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","وَهَذِهِ هِيَ ٱلثِّيَابُ ٱلَّتِي يَصْنَعُونَهَا: صُدْرَةٌ وَرِدَاءٌ وَجُبَّةٌ وَقَمِيصٌ مُخَرَّمٌ وَعِمَامَةٌ وَمِنْطَقَةٌ. فَيَصْنَعُونَ ثِيَابًا مُقَدَّسَةً لِهَارُونَ أَخِيكَ وَلِبَنِيهِ لِيَكْهَنَ لِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","وَهُمْ يَأْخُذُونَ ٱلذَّهَبَ وَٱلْأَسْمَانْجُونِيَّ وَٱلْأُرْجُوَانَ وَٱلْقِرْمِزَ وَٱلْبُوصَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«فَيَصْنَعُونَ ٱلرِّدَاءَ مِنْ ذَهَبٍ وَأَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ صَنْعَةَ حَائِكٍ حَاذِقٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","يَكُونُ لَهُ كَتِفَانِ مَوْصُولَانِ فِي طَرَفَيْهِ لِيَتَّصِلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","وَزُنَّارُ شَدِّهِ ٱلَّذِي عَلَيْهِ يَكُونُ مِنْهُ كَصَنْعَتِهِ. مِنْ ذَهَبٍ وَأَسْمَانْجُونِيٍّ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","وَتَأْخُذُ حَجَرَيْ جَزْعٍ وَتُنَقِّشُ عَلَيْهِمَا أَسْمَاءَ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","سِتَّةً مِنْ أَسْمَائِهِمْ عَلَى ٱلْحَجَرِ ٱلْوَاحِدِ، وَأَسْمَاءَ ٱلسِّتَّةِ ٱلْبَاقِينَ عَلَى ٱلْحَجَرِ ٱلثَّانِي حَسَبَ مَوَالِيدِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","صَنْعَةَ نَقَّاشِ ٱلْحِجَارَةِ نَقْشَ ٱلْخَاتِمِ تُنَقِّشُ ٱلْحَجَرَيْنِ عَلَى حَسَبِ أَسْمَاءِ بَنِي إِسْرَائِيلَ. مُحَاطَيْنِ بِطَوْقَيْنِ مِنْ ذَهَبٍ تَصْنَعُهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","وَتَضَعُ ٱلْحَجَرَيْنِ عَلَى كَتِفَيِ ٱلرِّدَاءِ حَجَرَيْ تَذْكَارٍ لِبَنِي إِسْرَائِيلَ. فَيَحْمِلُ هَارُونُ أَسْمَاءَهُمْ أَمَامَ ٱلرَّبِّ عَلَى كَتِفَيْهِ لِلتَّذْكَارِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","وَتَصْنَعُ طَوْقَيْنِ مِنْ ذَهَبٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","وَسِلْسِلَتَيْنِ مِنْ ذَهَبٍ نَقِيٍّ. مَجْدُولَتَيْنِ تَصْنَعُهُمَا صَنْعَةَ ٱلضَّفْرِ، وَتَجْعَلُ سِلْسِلَتَيِ ٱلضَّفَائِرِ فِي ٱلطَّوْقَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«وَتَصْنَعُ صُدْرَةَ قَضَاءٍ. صَنْعَةَ حَائِكٍ حَاذِقٍ كَصَنْعَةِ ٱلرِّدَاءِ تَصْنَعُهَا. مِنْ ذَهَبٍ وَأَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ تَصْنَعُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","تَكُونُ مُرَبَّعَةً مَثْنِيَّةً، طُولُهَا شِبْرٌ وَعَرْضُهَا شِبْرٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","وَتُرَصِّعُ فِيهَا تَرْصِيعَ حَجَرٍ أَرْبَعَةَ صُفُوفِ حِجَارَةٍ. صَفُّ: عَقِيقٍ أَحْمَرَ وَيَاقُوتٍ أَصْفَرَ وَزُمُرُّدٍ، ٱلصَّفُّ ٱلْأَوَّلُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","وَٱلصَّفُّ ٱلثَّانِي: بَهْرَمَانٌ وَيَاقُوتٌ أَزْرَقُ وَعَقِيقٌ أَبْيَضُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","وَٱلصَّفُّ ٱلثَّالِثُ: عَيْنُ ٱلْهِرِّ وَيَشْمٌ وَجَمَشْتٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","وَٱلصَّفُّ ٱلرَّابِعُ: زَبَرْجَدٌ وَجَزْعٌ وَيَشْبٌ. تَكُونُ مُطَوَّقَةً بِذَهَبٍ فِي تَرْصِيعِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","وَتَكُونُ ٱلْحِجَارَةُ عَلَى أَسْمَاءِ بَنِي إِسْرَائِيلَ، ٱثْنَيْ عَشَرَ عَلَى أَسْمَائِهِمْ. كَنَقْشِ ٱلْخَاتِمِ كُلُّ وَاحِدٍ عَلَى ٱسْمِهِ تَكُونُ لِلِٱثْنَيْ عَشَرَ سِبْطًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«وَتَصْنَعُ عَلَى ٱلصُّدْرَةِ سَلَاسِلَ مَجْدُولَةً صَنْعَةَ ٱلضَّفْرِ مِنْ ذَهَبٍ نَقِيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","وَتَصْنَعُ عَلَى ٱلصُّدْرَةِ حَلْقَتَيْنِ مِنْ ذَهَبٍ، وَتَجْعَلُ ٱلْحَلْقَتَيْنِ عَلَى طَرَفَيِ ٱلصُّدْرَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","وَتَجْعَلُ ضَفِيرَتَيِ ٱلذَّهَبِ فِي ٱلْحَلْقَتَيْنِ عَلَى طَرَفَيِ ٱلصُّدْرَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","وَتَجْعَلُ طَرَفَيِ ٱلضَّفِيرَتَيْنِ ٱلْآخَرَيْنِ فِي ٱلطَّوْقَيْنِ، وَتَجْعَلُهُمَا عَلَى كَتِفَيِ ٱلرِّدَاءِ إِلَى قُدَّامِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","وَتَصْنَعُ حَلْقَتَيْنِ مِنْ ذَهَبٍ وَتَضَعُهُمَا عَلَى طَرَفَيِ ٱلصُّدْرَةِ عَلَى حَاشِيَتِهَا ٱلَّتِي إِلَى جِهَةِ ٱلرِّدَاءِ مِنْ دَاخِلٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","وَتَصْنَعُ حَلْقَتَيْنِ مِنْ ذَهَبٍ، وَتَجْعَلُهُمَا عَلَى كَتِفَيِ ٱلرِّدَاءِ مِنْ أَسْفَلُ مِنْ قُدَّامِهِ عِنْدَ وَصْلِهِ مِنْ فَوْقِ زُنَّارِ ٱلرِّدَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","وَيَرْبُطُونَ ٱلصُّدْرَةَ بِحَلْقَتَيْهَا إِلَى حَلْقَتَيِ ٱلرِّدَاءِ بِخَيْطٍ مِنْ أَسْمَانْجُونِيٍّ لِتَكُونَ عَلَى زُنَّارِ ٱلرِّدَاءِ، وَلَا تُنْزَعُ ٱلصُّدْرَةُ عَنِ ٱلرِّدَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","فَيَحْمِلُ هَارُونُ أَسْمَاءَ بَنِي إِسْرَائِيلَ فِي صُدْرَةِ ٱلْقَضَاءِ عَلَى قَلْبِهِ عِنْدَ دُخُولِهِ إِلَى ٱلْقُدْسِ لِلتَّذْكَارِ أَمَامَ ٱلرَّبِّ دَائِمًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","وَتَجْعَلُ فِي صُدْرَةِ ٱلْقَضَاءِ ٱلْأُورِيمَ وَٱلتُّمِّيمَ لِتَكُونَ عَلَى قَلْبِ هَارُونَ عِنْدَ دُخُولِهِ أَمَامَ ٱلرَّبِّ. فَيَحْمِلُ هَارُونُ قَضَاءَ بَنِي إِسْرَائِيلَ عَلَى قَلْبِهِ أَمَامَ ٱلرَّبِّ دَائِمًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«وَتَصْنَعُ جُبَّةَ ٱلرِّدَاءِ كُلَّهَا مِنْ أَسْمَانْجُونِيٍّ، ");
INSERT INTO arb_vd_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","وَتَكُونُ فَتْحَةُ رَأْسِهَا فِي وَسَطِهَا، وَيَكُونُ لِفَتْحَتِهَا حَاشِيَةٌ حَوَالَيْهَا صَنْعَةَ ٱلْحَائِكِ. كَفَتْحَةِ ٱلدِّرْعِ يَكُونُ لَهَا. لَا تُشَقُّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","وَتَصْنَعُ عَلَى أَذْيَالِهَا رُمَّانَاتٍ مِنْ أَسْمَانْجُونِيٍّ وَأُرْجُوانٍ وَقِرْمِزٍ، عَلَى أَذْيَالِهَا حَوَالَيْهَا، وَجَلَاجِلَ مِنْ ذَهَبٍ بَيْنَهَا حَوَالَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","جُلْجُلَ ذَهَبٍ وَرُمَّانَةً، جُلْجُلَ ذَهَبٍ وَرُمَّانَةً، عَلَى أَذْيَالِ ٱلْجُبَّةِ حَوَالَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","فَتَكُونُ عَلَى هَارُونَ لِلْخِدْمَةِ لِيُسْمَعَ صَوْتُهَا عِنْدَ دُخُولِهِ إِلَى ٱلْقُدْسِ أَمَامَ ٱلرَّبِّ، وَعِنْدَ خُرُوجِهِ، لِئَلَّا يَمُوتَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«وَتَصْنَعُ صَفِيحَةً مِنْ ذَهَبٍ نَقِيٍّ، وَتُنَقِّشُ عَلَيْهَا نَقْشَ خَاتِمٍ: «قُدْسٌ لِلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","وَتَضَعُهَا عَلَى خَيْطٍ أَسْمَانْجُونِيٍّ لِتَكُونَ عَلَى ٱلْعِمَامَةِ. إِلَى قُدَّامِ ٱلْعِمَامَةِ تَكُونُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","فَتَكُونُ عَلَى جِبْهَةِ هَارُونَ، فَيَحْمِلُ هَارُونُ إِثْمَ ٱلْأَقْدَاسِ ٱلَّتِي يُقَدِّسُهَا بَنُو إِسْرَائِيلَ، جَمِيعِ عَطَايَا أَقْدَاسِهِمْ. وَتَكُونُ عَلَى جِبْهَتِهِ دَائِمًا لِلرِّضَا عَنْهُمْ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","وَتُخَرِّمُ ٱلْقَمِيصَ مِنْ بُوصٍ، وَتَصْنَعُ ٱلْعِمَامَةَ مِنْ بُوصٍ، وَٱلْمِنْطَقَةُ تَصْنَعُهَا صَنْعَةَ ٱلطَّرَّازِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","«وَلِبَنِي هَارُونَ تَصْنَعُ أَقْمِصَةً، وَتَصْنَعُ لَهُمْ مَنَاطِقَ، وَتَصْنَعُ لَهُمْ قَلَانِسَ لِلْمَجْدِ وَٱلْبَهَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","وَتُلْبِسُ هَارُونَ أَخَاكَ إِيَّاهَا وَبَنِيهِ مَعَهُ، وَتَمْسَحُهُمْ، وَتَمْلَأُ أَيَادِيهِمْ، وَتُقَدِّسُهُمْ لِيَكْهَنُوا لِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","وَتَصْنَعُ لَهُمْ سَرَاوِيلَ مِنْ كَتَّانٍ لِسَتْرِ ٱلْعَوْرَةِ. مِنَ ٱلْحَقَوَيْنِ إِلَى ٱلْفَخْذَيْنِ تَكُونُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","فَتَكُونُ عَلَى هَارُونَ وَبَنِيهِ عِنْدَ دُخُولِهِمْ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ، أَوْ عِنْدَ ٱقْتِرَابِهِمْ إِلَى ٱلْمَذْبَحِ لِلْخِدْمَةِ فِي ٱلْقُدْسِ، لِئَلَّا يَحْمِلُوا إِثْمًا وَيَمُوتُوا. فَرِيضَةً أَبَدِيَّةً لَهُ وَلِنَسْلِهِ مِنْ بَعْدِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«وَهَذَا مَا تَصْنَعُهُ لَهُمْ لِتَقْدِيسِهِمْ لِيَكْهَنُوا لِي: خُذْ ثَوْرًا وَاحِدًا ٱبْنَ بَقَرٍ، وَكَبْشَيْنِ صَحِيحَيْنِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","وَخُبْزَ فَطِيرٍ، وَأَقْرَاصَ فَطِيرٍ مَلْتُوتَةً بِزَيْتٍ، وَرُقَاقَ فَطِيرٍ مَدْهُونَةً بِزَيْتٍ. مِنْ دَقِيقِ حِنْطَةٍ تَصْنَعُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","وَتَجْعَلُهَا فِي سَلَّةٍ وَاحِدَةٍ، وَتُقَدِّمُهَا فِي ٱلسَّلَّةِ مَعَ ٱلثَّوْرِ وَٱلْكَبْشَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","«وَتُقَدِّمُ هَارُونَ وَبَنِيهِ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ وَتَغْسِلُهُمْ بِمَاءٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","وَتَأْخُذُ ٱلثِّيَابَ وَتُلْبِسُ هَارُونَ ٱلْقَمِيصَ وَجُبَّةَ ٱلرِّدَاءِ وَٱلرِّدَاءَ وَٱلصُّدْرَةَ، وَتَشُدُّهُ بِزُنَّارِ ٱلرِّدَاءِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","وَتَضَعُ ٱلْعِمَامَةَ عَلَى رَأْسِهِ، وَتَجْعَلُ ٱلْإِكْلِيلَ ٱلْمُقَدَّسَ عَلَى ٱلْعِمَامَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","وَتَأْخُذُ دُهْنَ ٱلْمَسْحَةِ وَتَسْكُبُهُ عَلَى رَأْسِهِ وَتَمْسَحُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","وَتُقَدِّمُ بَنِيهِ وَتُلْبِسُهُمْ أَقْمِصَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","وَتُنَطِّقُهُمْ بِمَنَاطِقَ، هَارُونَ وَبَنِيهِ، وَتَشُدُّ لَهُمْ قَلَانِسَ. فَيَكُونُ لَهُمْ كَهَنُوتٌ فَرِيضَةً أَبَدِيَّةً. وَتَمْلَأُ يَدَ هَارُونَ وَأَيْدِيَ بَنِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«وَتُقَدِّمُ ٱلثَّوْرَ إِلَى قُدَّامِ خَيْمَةِ ٱلِٱجْتِمَاعِ، فَيَضَعُ هَارُونُ وَبَنُوهُ أَيْدِيَهُمْ عَلَى رَأْسِ ٱلثَّوْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","فَتَذْبَحُ ٱلثَّوْرَ أَمَامَ ٱلرَّبِّ عِنْدَ بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","وَتَأْخُذُ مِنْ دَمِ ٱلثَّوْرِ وَتَجْعَلُهُ عَلَى قُرُونِ ٱلْمَذْبَحِ بِإِصْبِعِكَ، وَسَائِرَ ٱلدَّمِ تَصُبُّهُ إِلَى أَسْفَلِ ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","وَتَأْخُذُ كُلَّ ٱلشَّحْمِ ٱلَّذِي يُغَشِّي ٱلْجَوْفَ، وَزِيَادَةَ ٱلْكَبِدِ وَٱلْكُلْيَتَيْنِ وَٱلشَّحْمَ ٱلَّذِي عَلَيْهِمَا، وَتُوقِدُهَا عَلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","وَأَمَّا لَحْمُ ٱلثَّوْرِ وَجِلْدُهُ وَفَرْثُهُ فَتَحْرِقُهَا بِنَارٍ خَارِجَ ٱلْمَحَلَّةِ. هُوَ ذَبِيحَةُ خَطِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«وَتَأْخُذُ ٱلْكَبْشَ ٱلْوَاحِدَ، فَيَضَعُ هَارُونُ وَبَنُوهُ أَيْدِيَهُمْ عَلَى رَأْسِ ٱلْكَبْشِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","فَتَذْبَحُ ٱلْكَبْشَ وَتَأْخُذُ دَمَهُ وَتَرُشُّهُ عَلَى ٱلْمَذْبَحِ مِنْ كُلِّ نَاحِيَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","وَتَقْطَعُ ٱلْكَبْشَ إِلَى قِطَعِهِ، وَتَغْسِلُ جَوْفَهُ وَأَكَارِعَهُ وَتَجْعَلُهَا عَلَى قِطَعِهِ وَعَلَى رَأْسِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","وَتُوقِدُ كُلَّ ٱلْكَبْشِ عَلَى ٱلْمَذْبَحِ. هُوَ مُحْرَقَةٌ لِلرَّبِّ. رَائِحَةُ سَرُورٍ، وَقُودٌ هُوَ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«وَتَأْخُذُ ٱلْكَبْشَ ٱلثَّانِي، فَيَضَعُ هَارُونُ وَبَنُوهُ أَيْدِيَهُمْ عَلَى رَأْسِ ٱلْكَبْشِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","فَتَذْبَحُ ٱلْكَبْشَ وَتَأْخُذُ مِنْ دَمِهِ وَتَجْعَلُ عَلَى شَحْمَةِ أُذُنِ هَارُونَ، وَعَلَى شَحْمِ آذَانِ بَنِيهِ ٱلْيُمْنَى، وَعَلَى أَبَاهِمِ أَيْدِيهِمِ ٱلْيُمْنَى، وَعَلَى أَبَاهِمِ أَرْجُلِهِمِ ٱلْيُمْنَى. وَتَرُشُّ ٱلدَّمَ عَلَى ٱلْمَذْبَحِ مِنْ كُلِّ نَاحِيَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","وَتَأْخُذُ مِنَ ٱلدَّمِ ٱلَّذِي عَلَى ٱلْمَذْبَحِ وَمِنْ دُهْنِ ٱلْمَسْحَةِ، وَتَنْضِحُ عَلَى هَارُونَ وَثِيَابِهِ، وَعَلَى بَنِيهِ وَثِيَابِ بَنِيهِ مَعَهُ، فَيَتَقَدَّسُ هُوَ وَثِيَابُهُ وَبَنُوهُ وَثِيَابُ بَنِيهِ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ثُمَّ تَأْخُذُ مِنَ ٱلْكَبْشِ: ٱلشَّحْمَ وَٱلْإِلْيَةَ وَٱلشَّحْمَ ٱلَّذِي يُغَشِّي ٱلْجَوْفَ، وَزِيَادَةَ ٱلْكَبِدِ وَٱلْكُلْيَتَيْنِ، وَٱلشَّحْمَ ٱلَّذِي عَلَيْهِمَا، وَٱلسَّاقَ ٱلْيُمْنَى. فَإِنَّهُ كَبْشُ مِلْءٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","وَرَغِيفًا وَاحِدًا مِنَ ٱلْخُبْزِ، وَقُرْصًا وَاحِدًا مِنَ ٱلْخُبْزِ بِزَيْتٍ، وَرُقَاقَةً وَاحِدَةً مِنْ سَلَّةِ ٱلْفَطِيرِ ٱلَّتِي أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","وَتَضَعُ ٱلْجَمِيعَ فِي يَدَيْ هَارُونَ وَفِي أَيْدِي بَنِيهِ، وَتُرَدِّدُهَا تَرْدِيدًا أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ثُمَّ تَأْخُذُهَا مِنْ أَيْدِيهِمْ وَتُوقِدُهَا عَلَى ٱلْمَذْبَحِ فَوْقَ ٱلْمُحْرَقَةِ رَائِحَةَ سَرُورٍ أَمَامَ ٱلرَّبِّ. وَقُودٌ هُوَ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","«ثُمَّ تَأْخُذُ ٱلْقَصَّ مِنْ كَبْشِ ٱلْمِلْءِ ٱلَّذِي لِهَارُونَ، وَتُرَدِّدُهُ تَرْدِيدًا أَمَامَ ٱلرَّبِّ، فَيَكُونُ لَكَ نَصِيبًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","وَتُقَدِّسُ قَصَّ ٱلتَّرْدِيدِ وَسَاقَ ٱلرَّفِيعَةِ ٱلَّذِي رُدِّدَ وَٱلَّذِي رُفِعَ مِنْ كَبْشِ ٱلْمِلْءِ مِمَّا لِهَارُونَ وَلِبَنِيهِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","فَيَكُونَانِ لِهَارُونَ وَبَنِيهِ فَرِيضَةً أَبَدِيَّةً مِنْ بَنِي إِسْرَائِيلَ لِأَنَّهُمَا رَفِيعَةٌ. وَيَكُونَانِ رَفِيعَةً مِنْ بَنِي إِسْرَائِيلَ مِنْ ذَبَائِحِ سَلَامَتِهِمْ، رَفِيعَتَهُمْ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«وَٱلثِّيَابُ ٱلْمُقَدَّسَةُ ٱلَّتِي لِهَارُونَ تَكُونُ لِبَنِيهِ بَعْدَهُ، لِيُمْسَحُوا فِيهَا، وَلِتُمْلَأَ فِيهَا أَيْدِيهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","سَبْعَةَ أَيَّامٍ يَلْبَسُهَا ٱلْكَاهِنُ ٱلَّذِي هُوَ عِوَضٌ عَنْهُ مِنْ بَنِيهِ، ٱلَّذِي يَدْخُلُ خَيْمَةَ ٱلِٱجْتِمَاعِ لِيَخْدِمَ فِي ٱلْقُدْسِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«وَأَمَّا كَبْشُ ٱلْمِلْءِ فَتَأْخُذُهُ وَتَطْبُخُ لَحْمَهُ فِي مَكَانٍ مُقَدَّسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","فَيَأْكُلُ هَارُونُ وَبَنُوهُ لَحْمَ ٱلْكَبْشِ وَٱلْخُبْزَ ٱلَّذِي فِي ٱلسَّلَّةِ عِنْدَ بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","يَأْكُلُهَا ٱلَّذِينَ كُفِّرَ بِهَا عَنْهُمْ لِمِلْءِ أَيْدِيهِمْ لِتَقْدِيسِهِمْ. وَأَمَّا ٱلْأَجْنَبِيُّ فَلَا يَأْكُلُ لِأَنَّهَا مُقَدَّسَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","وَإِنْ بَقِيَ شَيْءٌ مِنْ لَحْمِ ٱلْمِلْءِ أَوْ مِنَ ٱلْخُبْزِ إِلَى ٱلصَّبَاحِ، تُحْرِقُ ٱلْبَاقِيَ بِٱلنَّارِ. لَا يُؤْكَلُ لِأَنَّهُ مُقَدَّسٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","وَتَصْنَعُ لِهَارُونَ وَبَنِيهِ هَكَذَا بِحَسَبِ كُلِّ مَا أَمَرْتُكَ. سَبْعَةَ أَيَّامٍ تَمْلَأُ أَيْدِيَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","وَتُقَدِّمُ ثَوْرَ خَطِيَّةٍ كُلَّ يَوْمٍ لِأَجْلِ ٱلْكَفَّارَةِ. وَتُطَهِّرُ ٱلْمَذْبَحَ بِتَكْفِيرِكَ عَلَيْهِ، وَتَمْسَحُهُ لِتَقْدِيسِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","سَبْعَةَ أَيَّامٍ تُكَفِّرُ عَلَى ٱلْمَذْبَحِ وَتُقَدِّسُهُ، فَيَكُونُ ٱلْمَذْبَحُ قُدْسَ أَقْدَاسٍ. كُلُّ مَا مَسَّ ٱلْمَذْبَحَ يَكُونُ مُقَدَّسًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«وَهَذَا مَا تُقَدِّمُهُ عَلَى ٱلْمَذْبَحِ: خَرُوفَانِ حَوْلِيَّانِ كُلَّ يَوْمٍ دَائِمًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ٱلْخَرُوفُ ٱلْوَاحِدُ تُقَدِّمُهُ صَبَاحًا، وَٱلْخَرُوفُ ٱلثَّانِي تُقَدِّمُهُ فِي ٱلْعَشِيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","وَعُشْرٌ مِنْ دَقِيقٍ مَلْتُوتٍ بِرُبْعِ ٱلْهِينِ مِنْ زَيْتِ ٱلرَّضِّ، وَسَكِيبٌ رُبْعُ ٱلْهِينِ مِنَ ٱلْخَمْرِ لِلْخَرُوفِ ٱلْوَاحِدِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","وَٱلْخَرُوفُ ٱلثَّانِي تُقَدِّمُهُ فِي ٱلْعَشِيَّةِ. مِثْلَ تَقْدِمَةِ ٱلصَّبَاحِ وَسَكِيبِهِ تَصْنَعُ لَهُ. رَائِحَةُ سَرُورٍ، وَقُودٌ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","مُحْرَقَةٌ دَائِمَةٌ فِي أَجْيَالِكُمْ عِنْدَ بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ أَمَامَ ٱلرَّبِّ، حَيْثُ أَجْتَمِعُ بِكُمْ لِأُكَلِّمَكَ هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","وَأَجْتَمِعُ هُنَاكَ بِبَنِي إِسْرَائِيلَ فَيُقَدَّسُ بِمَجْدِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","وَأُقَدِّسُ خَيْمَةَ الِٱجْتِمَاعِ وَٱلْمَذْبَحَ، وَهَارُونُ وَبَنُوهُ أُقَدِّسُهُمْ لِكَيْ يَكْهَنُوا لِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","وَأَسْكُنُ فِي وَسَطِ بَنِي إِسْرَائِيلَ وَأَكُونُ لَهُمْ إِلَهًا، ");
INSERT INTO arb_vd_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","فَيَعْلَمُونَ أَنِّي أَنَا ٱلرَّبُّ إِلَهُهُمُ ٱلَّذِي أَخْرَجَهُمْ مِنْ أَرْضِ مِصْرَ لِأَسْكُنَ فِي وَسْطِهِمْ. أَنَا ٱلرَّبُّ إِلَهُهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«وَتَصْنَعُ مَذْبَحًا لِإِيقَادِ ٱلْبَخُورِ. مِنْ خَشَبِ ٱلسَّنْطِ تَصْنَعُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","طُولُهُ ذِرَاعٌ وَعَرْضُهُ ذِرَاعٌ. مُرَبَّعًا يَكُونُ. وَٱرْتِفَاعُهُ ذِرَاعَانِ. مِنْهُ تَكُونُ قُرُونُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","وَتُغَشِّيهِ بِذَهَبٍ نَقِيٍّ: سَطْحَهُ وَحِيطَانَهُ حَوَالَيْهِ وَقُرُونَهُ. وَتَصْنَعُ لَهُ إِكْلِيلًا مِنْ ذَهَبٍ حَوَالَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","وَتَصْنَعُ لَهُ حَلْقَتَيْنِ مِنْ ذَهَبٍ تَحْتَ إِكْلِيلِهِ عَلَى جَانِبَيْهِ. عَلَى ٱلْجَانِبَيْنِ تَصْنَعُهُمَا، لِتَكُونَا بَيْتَيْنِ لِعَصَوَيْنِ لِحَمْلِهِ بِهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","وَتَصْنَعُ ٱلْعَصَوَيْنِ مِنْ خَشَبِ ٱلسَّنْطِ وَتُغَشِّيهِمَا بِذَهَبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","وَتَجْعَلُهُ قُدَّامَ ٱلْحِجَابِ ٱلَّذِي أَمَامَ تَابُوتِ ٱلشَّهَادَةِ. قُدَّامَ ٱلْغِطَاءِ ٱلَّذِي عَلَى ٱلشَّهَادَةِ حَيْثُ أَجْتَمِعُ بِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","فَيُوقِدُ عَلَيْهِ هَارُونُ بَخُورًا عَطِرًا كُلَّ صَبَاحٍ، حِينَ يُصْلِحُ ٱلسُّرُجَ يُوقِدُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","وَحِينَ يُصْعِدُ هَارُونُ ٱلسُّرُجَ فِي ٱلْعَشِيَّةِ يُوقِدُهُ. بَخُورًا دَائِمًا أَمَامَ ٱلرَّبِّ فِي أَجْيَالِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","لَا تُصْعِدُوا عَلَيْهِ بَخُورًا غَرِيبًا وَلَا مُحْرَقَةً أَوْ تَقْدِمَةً، وَلَا تَسْكُبُوا عَلَيْهِ سَكِيبًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","وَيَصْنَعُ هَارُونُ كَفَّارَةً عَلَى قُرُونِهِ مَرَّةً فِي ٱلسَّنَةِ. مِنْ دَمِ ذَبِيحَةِ ٱلْخَطِيَّةِ ٱلَّتِي لِلْكَفَّارَةِ مَرَّةً فِي ٱلسَّنَةِ يَصْنَعُ كَفَّارَةً عَلَيْهِ فِي أَجْيَالِكُمْ. قُدْسُ أَقْدَاسٍ هُوَ لِلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«إِذَا أَخَذْتَ كَمِّيَّةَ بَنِي إِسْرَائِيلَ بِحَسَبِ ٱلْمَعْدُودِينَ مِنْهُمْ، يُعْطُونَ كُلُّ وَاحِدٍ فِدْيَةَ نَفْسِهِ لِلرَّبِّ عِنْدَمَا تَعُدُّهُمْ، لِئَلَّا يَصِيرَ فِيهِمْ وَبَأٌ عِنْدَمَا تَعُدُّهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","هَذَا مَا يُعْطِيهِ كُلُّ مَنِ ٱجْتَازَ إِلَى ٱلْمَعْدُودِينَ: نِصْفُ ٱلشَّاقِلِ بِشَاقِلِ ٱلْقُدْسِ. ٱلشَّاقِلُ هُوَ عِشْرُونَ جِيرَةً. نِصْفُ ٱلشَّاقِلِ تَقْدِمَةً لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","كُلُّ مَنِ ٱجْتَازَ إِلَى ٱلْمَعْدُودِينَ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا يُعْطِي تَقْدِمَةً لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","اَلْغَنِيُّ لَا يُكَثِّرُ وَٱلْفَقِيرُ لَا يُقَلِّلُ عَنْ نِصْفِ ٱلشَّاقِلِ حِينَ تُعْطُونَ تَقْدِمَةَ ٱلرَّبِّ لِلتَّكْفِيرِ عَنْ نُفُوسِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","وَتَأْخُذُ فِضَّةَ ٱلْكَفَّارَةِ مِنْ بَنِي إِسْرَائِيلَ، وَتَجْعَلُهَا لِخِدْمَةِ خَيْمَةِ ٱلِٱجْتِمَاعِ. فَتَكُونُ لِبَنِي إِسْرَائِيلَ تَذْكَارًا أَمَامَ ٱلرَّبِّ لِلتَّكْفِيرِ عَنْ نُفُوسِكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","وَكَلَّمْ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«وَتَصْنَعُ مِرْحَضَةً مِنْ نُحَاسٍ، وَقَاعِدَتَهَا مِنْ نُحَاسٍ، لِلِٱغْتِسَالِ. وَتَجْعَلُهَا بَيْنَ خَيْمَةِ ٱلِٱجْتِمَاعِ وَٱلْمَذْبَحِ، وَتَجْعَلُ فِيهَا مَاءً. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","فَيَغْسِلُ هَارُونُ وَبَنُوهُ أَيْدِيَهُمْ وَأَرْجُلَهُمْ مِنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","عِنْدَ دُخُولِهِمْ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ يَغْسِلُونَ بِمَاءٍ لِئَلَّا يَمُوتُوا، أَوْ عِنْدَ ٱقْتِرَابِهِمْ إِلَى ٱلْمَذْبَحِ لِلْخِدْمَةِ لِيُوقِدُوا وَقُودًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","يَغْسِلُونَ أَيْدِيَهُمْ وَأَرْجُلَهُمْ لِئَلَّا يَمُوتُوا. وَيَكُونُ لَهُمْ فَرِيضَةً أَبَدِيَّةً لَهُ وَلِنَسْلِهِ فِي أَجْيَالِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«وَأَنْتَ تَأْخُذُ لَكَ أَفْخَرَ ٱلْأَطْيَابِ: مُرًّا قَاطِرًا خَمْسَ مِئَةِ شَاقِلٍ، وَقِرْفَةً عَطِرَةً نِصْفَ ذَلِكَ: مِئَتَيْنِ وَخَمْسِينَ، وَقَصَبَ ٱلذَّرِيرَةِ مِئَتَيْنِ وَخَمْسِينَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","وَسَلِيخَةً خَمْسَ مِئَةٍ بِشَاقِلِ ٱلْقُدْسِ، وَمِنْ زَيْتِ ٱلزَّيْتُونِ هِينًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","وَتَصْنَعُهُ دُهْنًا مُقَدَّسًا لِلْمَسْحَةِ. عِطْرَ عِطَارَةٍ صَنْعَةَ ٱلْعَطَّارِ. دُهْنًا مُقَدَّسًا لِلْمَسْحَةِ يَكُونُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","وَتَمْسَحُ بِهِ خَيْمَةَ ٱلِٱجْتِمَاعِ، وَتَابُوتَ ٱلشَّهَادَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","وَٱلْمَائِدَةَ وَكُلَّ آنِيَتِهَا، وَٱلْمَنَارَةَ وَآنِيَتَهَا، وَمَذْبَحَ ٱلْبَخُورِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","وَمَذْبَحَ ٱلْمُحْرَقَةِ وَكُلَّ آنِيَتِهِ، وَٱلْمِرْحَضَةَ وَقَاعِدَتَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","وَتُقَدِّسُهَا فَتَكُونُ قُدْسَ أَقْدَاسٍ. كُلُّ مَا مَسَّهَا يَكُونُ مُقَدَّسًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","وَتَمْسَحُ هَارُونَ وَبَنِيهِ وَتُقَدِّسُهُمْ لِيَكْهَنُوا لِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","وَتُكَلِّمُ بَنِي إِسْرَائِيلَ قَائِلًا: يَكُونُ هَذَا لِي دُهْنًا مُقَدَّسًا لِلْمَسْحَةِ فِي أَجْيَالِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","عَلَى جَسَدِ إِنْسَانٍ لَا يُسْكَبُ، وَعَلَى مَقَادِيرِهِ لَا تَصْنَعُوا مِثْلَهُ. مُقَدَّسٌ هُوَ، وَيَكُونُ مُقَدَّسًا عِنْدَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","كُلُّ مَنْ رَكَّبَ مِثْلَهُ وَمَنْ جَعَلَ مِنْهُ عَلَى أَجْنَبِيٍّ يُقْطَعُ مِنْ شَعْبِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","وَقَالَ ٱلرَّبُّ لِمُوسَى: «خُذْ لَكَ أَعْطَارًا: مَيْعَةً وَأَظْفَارًا وَقِنَّةً عَطِرَةً وَلُبَانًا نَقِيًّا. تَكُونُ أَجْزَاءً مُتَسَاوِيَةً، ");
INSERT INTO arb_vd_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","فَتَصْنَعُهَا بَخُورًا عَطِرًا صَنْعَةَ ٱلْعَطَّارِ، مُمَلَّحًا نَقِيًّا مُقَدَّسًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","وَتَسْحَقُ مِنْهُ نَاعِمًا، وَتَجْعَلُ مِنْهُ قُدَّامَ ٱلشَّهَادَةِ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ حَيْثُ أَجْتَمِعُ بِكَ. قُدْسَ أَقْدَاسٍ يَكُونُ عِنْدَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","وَٱلْبَخُورُ ٱلَّذِي تَصْنَعُهُ عَلَى مَقَادِيرِهِ لَا تَصْنَعُوا لِأَنْفُسِكُمْ. يَكُونُ عِنْدَكَ مُقَدَّسًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","كُلُّ مَنْ صَنَعَ مِثْلَهُ لِيَشُمَّهُ يُقْطَعُ مِنْ شَعْبِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«اُنْظُرْ. قَدْ دَعَوْتُ بَصَلْئِيلَ بْنَ أُورِي بْنَ حُورَ مِنْ سِبْطِ يَهُوذَا بِٱسْمِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","وَمَلَأْتُهُ مِنْ رُوحِ ٱللهِ بِٱلْحِكْمَةِ وَٱلْفَهْمِ وَٱلْمَعْرِفَةِ وَكُلِّ صَنْعَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","لِٱخْتِرَاعِ مُخْتَرَعَاتٍ لِيَعْمَلَ فِي ٱلذَّهَبِ وَٱلْفِضَّةِ وَٱلنُّحَاسِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","وَنَقْشِ حِجَارَةٍ لِلتَّرْصِيعِ، وَنِجَارَةِ ٱلْخَشَبِ، لِيَعْمَلَ فِي كُلِّ صَنْعَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","وَهَا أَنَا قَدْ جَعَلْتُ مَعَهُ أُهُولِيآبَ بْنَ أَخِيسَامَاكَ مِنْ سِبْطِ دَانَ. وَفِي قَلْبِ كُلِّ حَكِيمِ ٱلْقَلْبِ جَعَلْتُ حِكْمَةً، لِيَصْنَعُوا كُلَّ مَا أَمَرْتُكَ: ");
INSERT INTO arb_vd_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","خَيْمَةَ ٱلِٱجْتِمَاعِ، وَتَابُوتَ ٱلشَّهَادَةِ، وَٱلْغِطَاءَ ٱلَّذِي عَلَيْهِ، وَكُلَّ آنِيَةِ ٱلْخَيْمَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","وَٱلْمَائِدَةَ وَآنِيَتَهَا، وَٱلْمَنَارَةَ ٱلطَّاهِرَةَ وَكُلَّ آنِيَتِهَا، وَمَذْبَحَ ٱلْبَخُورِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","وَمَذْبَحَ ٱلْمُحْرَقَةِ وَكُلَّ آنِيَتِهِ، وَٱلْمِرْحَضَةَ وَقَاعِدَتَهَا، ");
INSERT INTO arb_vd_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","وَٱلثِّيَابَ ٱلْمَنْسُوجَةَ، وَٱلثِّيَابَ ٱلْمُقَدَّسَةَ لِهَارُونَ ٱلْكَاهِنِ وَثِيَابَ بَنِيهِ لِلْكَهَانَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","وَدُهْنَ ٱلْمَسْحَةِ وَٱلْبَخُورَ ٱلْعَطِرَ لِلْقُدْسِ. حَسَبَ كُلِّ مَا أَمَرْتُكَ بِهِ يَصْنَعُونَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«وَأَنْتَ تُكَلِّمُ بَنِي إِسْرَائِيلَ قَائِلًا: سُبُوتِي تَحْفَظُونَهَا، لِأَنَّهُ عَلَامَةٌ بَيْنِي وَبَيْنَكُمْ فِي أَجْيَالِكُمْ لِتَعْلَمُوا أَنِّي أَنَا ٱلرَّبُّ ٱلَّذِي يُقَدِّسُكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","فَتَحْفَظُونَ ٱلسَّبْتَ لِأَنَّهُ مُقَدَّسٌ لَكُمْ. مَنْ دَنَّسَهُ يُقْتَلُ قَتْلًا. إِنَّ كُلَّ مَنْ صَنَعَ فِيهِ عَمَلًا تُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ بَيْنِ شَعْبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","سِتَّةَ أَيَّامٍ يُصْنَعُ عَمَلٌ، وَأَمَّا ٱلْيَوْمُ ٱلْسَّابِعُ فَفِيهِ سَبْتُ عُطْلَةٍ مُقَدَّسٌ لِلرَّبِّ. كُلُّ مَنْ صَنَعَ عَمَلًا فِي يَوْمِ ٱلسَّبْتِ يُقْتَلُ قَتْلًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","فَيَحْفَظُ بَنُو إِسْرَائِيلَ ٱلسَّبْتَ لِيَصْنَعُوا ٱلسَّبْتَ فِي أَجْيَالِهِمْ عَهْدًا أَبَدِيًّا. ");
INSERT INTO arb_vd_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","هُوَ بَيْنِي وَبَيْنَ بَنِي إِسْرَائِيلَ عَلَامَةٌ إِلَى ٱلْأَبَدِ. لِأَنَّهُ فِي سِتَّةِ أَيَّامٍ صَنَعَ ٱلرَّبُّ ٱلسَّمَاءَ وَٱلْأَرْضَ، وَفِي ٱلْيَوْمِ ٱلسَّابِعِ ٱسْتَرَاحَ وَتَنَفَّسَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ثُمَّ أَعْطَى مُوسَى عِنْدَ فَرَاغِهِ مِنَ ٱلْكَلَامِ مَعَهُ فِي جَبَلِ سِينَاءَ لَوْحَيِ ٱلشَّهَادَةِ: لَوْحَيْ حَجَرٍ مَكْتُوبَيْنِ بِإِصْبِعِ ٱللهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","وَلَمَّا رَأَى ٱلشَّعْبُ أَنَّ مُوسَى أَبْطَأَ فِي ٱلنُّزُولِ مِنَ ٱلْجَبَلِ، ٱجْتَمَعَ ٱلشَّعْبُ عَلَى هَارُونَ وَقَالُوا لَهُ: «قُمِ ٱصْنَعْ لَنَا آلِهَةً تَسِيرُ أَمَامَنَا، لِأَنَّ هَذَا مُوسَى ٱلرَّجُلَ ٱلَّذِي أَصْعَدَنَا مِنْ أَرْضِ مِصْرَ، لَا نَعْلَمُ مَاذَا أَصَابَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","فَقَالَ لَهُمْ هَارُونُ: «ٱنْزِعُوا أَقْرَاطَ ٱلذَّهَبِ ٱلَّتِي فِي آذَانِ نِسَائِكُمْ وَبَنِيكُمْ وَبَنَاتِكُمْ وَآتُونِي بِهَا». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","فَنَزَعَ كُلُّ ٱلشَّعْبِ أَقْرَاطَ ٱلذَّهَبِ ٱلَّتِي فِي آذَانِهِمْ وَأَتَوْا بِهَا إِلَى هَارُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","فَأَخَذَ ذَلِكَ مِنْ أَيْدِيهِمْ وَصَوَّرَهُ بِٱلْإِزْمِيلِ، وَصَنَعَهُ عِجْلًا مَسْبُوكًا. فَقَالُوا: «هَذِهِ آلِهَتُكَ يَا إِسْرَائِيلُ ٱلَّتِي أَصْعَدَتْكَ مِنْ أَرْضِ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","فَلَمَّا نَظَرَ هَارُونُ بَنَى مَذْبَحًا أَمَامَهُ، وَنَادَى هَارُونُ وَقَالَ: «غَدًا عِيدٌ لِلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","فَبَكَّرُوا فِي ٱلْغَدِ وَأَصْعَدُوا مُحْرَقَاتٍ وَقَدَّمُوا ذَبَائِحَ سَلَامَةٍ. وَجَلَسَ ٱلشَّعْبُ لِلْأَكْلِ وَٱلشُّرْبِ ثُمَّ قَامُوا لِلَّعِبِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","فَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱذْهَبِ ٱنْزِلْ. لِأَنَّهُ قَدْ فَسَدَ شَعْبُكَ ٱلَّذِي أَصْعَدْتَهُ مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","زَاغُوا سَرِيعًا عَنِ ٱلطَّرِيقِ ٱلَّذِي أَوْصَيْتُهُمْ بِهِ. صَنَعُوا لَهُمْ عِجْلًا مَسْبُوكًا، وَسَجَدُوا لَهُ وَذَبَحُوا لَهُ وَقَالُوا: هَذِهِ آلِهَتُكَ يَا إِسْرَائِيلُ ٱلَّتِي أَصْعَدَتْكَ مِنْ أَرْضِ مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","وَقَالَ ٱلرَّبُّ لِمُوسَى: «رَأَيْتُ هَذَا ٱلشَّعْبَ وَإِذَا هُوَ شَعْبٌ صُلْبُ ٱلرَّقَبَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","فَٱلْآنَ ٱتْرُكْنِي لِيَحْمَى غَضَبِي عَلَيْهِمْ وَأُفْنِيَهُمْ، فَأُصَيِّرَكَ شَعْبًا عَظِيمًا». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","فَتَضَرَّعَ مُوسَى أَمَامَ ٱلرَّبِّ إِلَهِهِ، وَقَالَ: «لِمَاذَا يَا رَبُّ يَحْمَى غَضَبُكَ عَلَى شَعْبِكَ ٱلَّذِي أَخْرَجْتَهُ مِنْ أَرْضِ مِصْرَ بِقُوَّةٍ عَظِيمَةٍ وَيَدٍ شَدِيدَةٍ؟ ");
INSERT INTO arb_vd_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","لِمَاذَا يَتَكَلَّمُ ٱلْمِصْرِيُّونَ قَائِلِينَ: أَخْرَجَهُمْ بِخُبْثٍ لِيَقْتُلَهُمْ فِي ٱلْجِبَالِ، وَيُفْنِيَهُمْ عَنْ وَجْهِ ٱلْأَرْضِ؟ اِرْجِعْ عَنْ حُمُوِّ غَضَبِكَ، وَٱنْدَمْ عَلَى ٱلشَّرِّ بِشَعْبِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","اُذْكُرْ إِبْرَاهِيمَ وَإِسْحَاقَ وَإِسْرَائِيلَ عَبِيدَكَ ٱلَّذِينَ حَلَفْتَ لَهُمْ بِنَفْسِكَ وَقُلْتَ لَهُمْ: أُكَثِّرُ نَسْلَكُمْ كَنُجُومِ ٱلسَّمَاءِ، وَأُعْطِي نَسْلَكُمْ كُلَّ هَذِهِ ٱلْأَرْضِ ٱلَّتِي تَكَلَّمْتُ عَنْهَا فَيَمْلِكُونَهَا إِلَى ٱلْأَبَدِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","فَنَدِمَ ٱلرَّبُّ عَلَى ٱلشَّرِّ ٱلَّذِي قَالَ إِنَّهُ يَفْعَلُهُ بِشَعْبِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","فَٱنْصَرَفَ مُوسَى وَنَزَلَ مِنَ ٱلْجَبَلِ وَلَوْحَا ٱلشَّهَادَةِ فِي يَدِهِ: لَوْحَانِ مَكْتُوبَانِ عَلَى جَانِبَيْهِمَا. مِنْ هُنَا وَمِنْ هُنَا كَانَا مَكْتُوبَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","وَٱللَّوْحَانِ هُمَا صَنْعَةُ ٱللهِ، وَٱلْكِتَابَةُ كِتَابَةُ ٱللهِ مَنْقُوشَةٌ عَلَى ٱللَّوْحَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","وَسَمِعَ يَشُوعُ صَوْتَ ٱلشَّعْبِ فِي هُتَافِهِ فَقَالَ لِمُوسَى: «صَوْتُ قِتَالٍ فِي ٱلْمَحَلَّةِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","فَقَالَ: «لَيْسَ صَوْتَ صِيَاحِ ٱلنُّصْرَةِ وَلَا صَوْتَ صِيَاحِ ٱلْكَسْرَةِ، بَلْ صَوْتَ غِنَاءٍ أَنَا سَامِعٌ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","وَكَانَ عِنْدَمَا ٱقْتَرَبَ إِلَى ٱلْمَحَلَّةِ أَنَّهُ أَبْصَرَ ٱلْعِجْلَ وَٱلرَّقْصَ، فَحَمِيَ غَضَبُ مُوسَى، وَطَرَحَ ٱللَّوْحَيْنِ مِنْ يَدَيْهِ وَكَسَّرَهُمَا فِي أَسْفَلِ ٱلْجَبَلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ثُمَّ أَخَذَ ٱلْعِجْلَ ٱلَّذِي صَنَعُوا وَأَحْرَقَهُ بِٱلنَّارِ، وَطَحَنَهُ حَتَّى صَارَ نَاعِمًا، وَذَرَّاهُ عَلَى وَجْهِ ٱلْمَاءِ، وَسَقَى بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","وَقَالَ مُوسَى لِهَارُونَ: «مَاذَا صَنَعَ بِكَ هَذَا ٱلشَّعْبُ حَتَّى جَلَبْتَ عَلَيْهِ خَطِيَّةً عَظِيمَةً؟» ");
INSERT INTO arb_vd_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","فَقَالَ هَارُونُ: «لَا يَحْمَ غَضَبُ سَيِّدِي. أَنْتَ تَعْرِفُ ٱلشَّعْبَ أَنَّهُ فِي شَرٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","فَقَالُوا لِيَ: ٱصْنَعْ لَنَا آلِهَةً تَسِيرُ أَمَامَنَا، لِأَنَّ هَذَا مُوسَى ٱلرَّجُلَ ٱلَّذِي أَصْعَدَنَا مِنْ أَرْضِ مِصْرَ، لَا نَعْلَمُ مَاذَا أَصَابَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","فَقُلْتُ لَهُمْ: مَنْ لَهُ ذَهَبٌ فَلْيَنْزِعْهُ وَيُعْطِنِي. فَطَرَحْتُهُ فِي ٱلنَّارِ فَخَرَجَ هَذَا ٱلْعِجْلُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","وَلَمَّا رَأَى مُوسَى ٱلشَّعْبَ أَنَّهُ مُعَرًّى لِأَنَّ هَارُونَ كَانَ قَدْ عَرَّاهُ لِلْهُزْءِ بَيْنَ مُقَاوِمِيهِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","وَقَفَ مُوسَى فِي بَابِ ٱلْمَحَلَّةِ، وَقَالَ: «مَنْ لِلرَّبِّ فَإِلَيَّ». فَٱجْتَمَعَ إِلَيْهِ جَمِيعُ بَنِي لَاوِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","فَقَالَ لَهُمْ: «هَكَذَا قَالَ ٱلرَّبُّ إِلَهُ إِسْرَائِيلَ: ضَعُوا كُلُّ وَاحِدٍ سَيْفَهُ عَلَى فَخْذِهِ وَمُرُّوا وَٱرْجِعُوا مِنْ بَابٍ إِلَى بَابٍ فِي ٱلْمَحَلَّةِ، وَٱقْتُلُوا كُلُّ وَاحِدٍ أَخَاهُ وَكُلُّ وَاحِدٍ صَاحِبَهُ وَكُلُّ وَاحِدٍ قَرِيبَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","فَفَعَلَ بَنُو لَاوِي بِحَسَبِ قَوْلِ مُوسَى. وَوَقَعَ مِنَ ٱلشَّعْبِ فِي ذَلِكَ ٱلْيَوْمِ نَحْوُ ثَلَاثَةِ آلَافِ رَجُلٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","وَقَالَ مُوسَى: «ٱمْلَأُوا أَيْدِيَكُمُ ٱلْيَوْمَ لِلرَّبِّ، حَتَّى كُلُّ وَاحِدٍ بِٱبْنِهِ وَبِأَخِيهِ، فَيُعْطِيَكُمُ ٱلْيَوْمَ بَرَكَةً». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","وَكَانَ فِي ٱلْغَدِ أَنَّ مُوسَى قَالَ لِلشَّعْبِ: «أَنْتُمْ قَدْ أَخْطَأْتُمْ خَطِيَّةً عَظِيمَةً، فَأَصْعَدُ ٱلْآنَ إِلَى ٱلرَّبِّ لَعَلِّي أُكَفِّرُ خَطِيَّتَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","فَرَجَعَ مُوسَى إِلَى ٱلرَّبِّ، وَقَالَ: «آهِ، قَدْ أَخْطَأَ هَذَا ٱلشَّعْبُ خَطِيَّةً عَظِيمَةً وَصَنَعُوا لِأَنْفُسِهِمْ آلِهَةً مِنْ ذَهَبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","وَٱلْآنَ إِنْ غَفَرْتَ خَطِيَّتَهُمْ، وَإِلَّا فَٱمْحُنِي مِنْ كِتَابِكَ ٱلَّذِي كَتَبْتَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","فَقَالَ ٱلرَّبُّ لِمُوسَى: «مَنْ أَخْطَأَ إِلَيَّ أَمْحُوهُ مِنْ كِتَابِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","وَٱلْآنَ ٱذْهَبِ ٱهْدِ ٱلشَّعْبَ إِلَى حَيْثُ كَلَّمْتُكَ. هُوَذَا مَلَاكِي يَسِيرُ أَمَامَكَ. وَلَكِنْ فِي يَوْمِ ٱفْتِقَادِي أَفْتَقِدُ فِيهِمْ خَطِيَّتَهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","فَضَرَبَ ٱلرَّبُّ ٱلشَّعْبَ، لِأَنَّهُمْ صَنَعُوا ٱلْعِجْلَ ٱلَّذِي صَنَعَهُ هَارُونُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","وَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱذْهَبِ ٱصْعَدْ مِنْ هُنَا أَنْتَ وَٱلشَّعْبُ ٱلَّذِي أَصْعَدْتَهُ مِنْ أَرْضِ مِصْرَ إِلَى ٱلْأَرْضِ ٱلَّتِي حَلَفْتُ لِإِبْرَاهِيمَ وَإِسْحَاقَ وَيَعْقُوبَ قَائِلًا: لِنَسْلِكَ أُعْطِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","وَأَنَا أُرْسِلُ أَمَامَكَ مَلَاكًا، وَأَطْرُدُ ٱلْكَنْعَانِيِّينَ وَٱلْأَمُورِيِّينَ وَٱلْحِثِّيِّينَ وَٱلْفِرِزِّيِّينَ وَٱلْحِوِّيِّينَ وَٱلْيَبُوسِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","إِلَى أَرْضٍ تَفِيضُ لَبَنًا وَعَسَلًا. فَإِنِّي لَا أَصْعَدُ فِي وَسَطِكَ لِأَنَّكَ شَعْبٌ صُلْبُ ٱلرَّقَبَةِ، لِئَلَّا أُفْنِيَكَ فِي ٱلطَّرِيقِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","فَلَمَّا سَمِعَ ٱلشَّعْبُ هَذَا ٱلْكَلَامَ ٱلسُّوءَ نَاحُوا وَلَمْ يَضَعْ أَحَدٌ زِينَتَهُ عَلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","وَكَانَ ٱلرَّبُّ قَدْ قَالَ لِمُوسَى: «قُلْ لِبَنِي إِسْرَائِيلَ: أَنْتُمْ شَعْبٌ صُلْبُ ٱلرَّقَبَةِ. إِنْ صَعِدْتُ لَحْظَةً وَاحِدَةً فِي وَسَطِكُمْ أَفْنَيْتُكُمْ. وَلَكِنِ ٱلْآنَ ٱخْلَعْ زِينَتَكَ عَنْكَ فَأَعْلَمَ مَاذَا أَصْنَعُ بِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","فَنَزَعَ بَنُو إِسْرَائِيلَ زِينَتَهُمْ مِنْ جَبَلِ حُورِيبَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","وَأَخَذَ مُوسَى ٱلْخَيْمَةَ وَنَصَبَهَا لَهُ خَارِجَ ٱلْمَحَلَّةِ، بَعِيدًا عَنِ ٱلْمَحَلَّةِ، وَدَعَاهَا «خَيْمَةَ ٱلِٱجْتِمَاعِ». فَكَانَ كُلُّ مَنْ يَطْلُبُ ٱلرَّبَّ يَخْرُجُ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ ٱلَّتِي خَارِجَ ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","وَكَانَ جَمِيعُ ٱلشَّعْبِ إِذَا خَرَجَ مُوسَى إِلَى ٱلْخَيْمَةِ يَقُومُونَ وَيَقِفُونَ كُلُّ وَاحِدٍ فِي بَابِ خَيْمَتِهِ وَيَنْظُرُونَ وَرَاءَ مُوسَى حَتَّى يَدْخُلَ ٱلْخَيْمَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","وَكَانَ عَمُودُ ٱلسَّحَابِ إِذَا دَخَلَ مُوسَى ٱلْخَيْمَةَ، يَنْزِلُ وَيَقِفُ عِنْدَ بَابِ ٱلْخَيْمَةِ. وَيَتَكَلَّمُ ٱلرَّبُّ مَعَ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","فَيَرَى جَمِيعُ ٱلشَّعْبِ عَمُودَ ٱلسَّحَابِ، وَاقِفًا عِنْدَ بَابِ ٱلْخَيْمَةِ، وَيَقُومُ كُلُّ ٱلشَّعْبِ وَيَسْجُدُونَ كُلُّ وَاحِدٍ فِي بَابِ خَيْمَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","وَيُكَلِّمُ ٱلرَّبُّ مُوسَى وَجْهًا لِوَجْهٍ، كَمَا يُكَلِّمُ ٱلرَّجُلُ صَاحِبَهُ. وَإِذَا رَجَعَ مُوسَى إِلَى ٱلْمَحَلَّةِ كَانَ خَادِمُهُ يَشُوعُ بْنُ نُونَ ٱلْغُلَامُ، لَا يَبْرَحُ مِنْ دَاخِلِ ٱلْخَيْمَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","وَقَالَ مُوسَى لِلرَّبِّ: «ٱنْظُرْ. أَنْتَ قَائِلٌ لِي: أَصْعِدْ هَذَا ٱلشَّعْبَ، وَأَنْتَ لَمْ تُعَرِّفْنِي مَنْ تُرْسِلُ مَعِي. وَأَنْتَ قَدْ قُلْتَ: عَرَفْتُكَ بِٱسْمِكَ، وَوَجَدْتَ أَيْضًا نِعْمَةً فِي عَيْنَيَّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","فَٱلْآنَ إِنْ كُنْتُ قَدْ وَجَدْتُ نِعْمَةً فِي عَيْنَيْكَ فَعَلِّمْنِي طَرِيقَكَ حَتَّى أَعْرِفَكَ لِكَيْ أَجِدَ نِعْمَةً فِي عَيْنَيْكَ. وَٱنْظُرْ أَنَّ هَذِهِ ٱلْأُمَّةَ شَعْبُكَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","فَقَالَ: «وَجْهِي يَسِيرُ فَأُرِيحُكَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","فَقَالَ لَهُ: «إِنْ لَمْ يَسِرْ وَجْهُكَ فَلَا تُصْعِدْنَا مِنْ هَهُنَا، ");
INSERT INTO arb_vd_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","فَإِنَّهُ بِمَاذَا يُعْلَمُ أَنِّي وَجَدْتُ نِعْمَةً فِي عَيْنَيْكَ أَنَا وَشَعْبُكَ؟ أَلَيْسَ بِمَسِيرِكَ مَعَنَا؟ فَنَمْتَازَ أَنَا وَشَعْبُكَ عَنْ جَمِيعِ ٱلشُّعُوبِ ٱلَّذِينَ عَلَى وَجْهِ ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","فَقَالَ ٱلرَّبُّ لِمُوسَى: «هَذَا ٱلْأَمْرُ أَيْضًا ٱلَّذِي تَكَلَّمْتَ عَنْهُ أَفْعَلُهُ، لِأَنَّكَ وَجَدْتَ نِعْمَةً فِي عَيْنَيَّ، وَعَرَفْتُكَ بِٱسْمِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","فَقَالَ: «أَرِنِي مَجْدَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","فَقَالَ: «أُجِيزُ كُلَّ جُودَتِي قُدَّامَكَ. وَأُنَادِي بِٱسْمِ ٱلرَّبِّ قُدَّامَكَ. وَأَتَرَاءَفُ عَلَى مَنْ أَتَرَاءَفُ، وَأَرْحَمُ مَنْ أَرْحَمُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","وَقَالَ: «لَا تَقْدِرُ أَنْ تَرَى وَجْهِي، لِأَنَّ ٱلْإِنْسَانَ لَا يَرَانِي وَيَعِيشُ». ");
INSERT INTO arb_vd_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","وَقَالَ ٱلرَّبُّ: «هُوَذَا عِنْدِي مَكَانٌ، فَتَقِفُ عَلَى ٱلصَّخْرَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","وَيَكُونُ مَتَى ٱجْتَازَ مَجْدِي، أَنِّي أَضَعُكَ فِي نُقْرَةٍ مِنَ ٱلصَّخْرَةِ، وَأَسْتُرُكَ بِيَدِي حَتَّى أَجْتَازَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ثُمَّ أَرْفَعُ يَدِي فَتَنْظُرُ وَرَائِي، وَأَمَّا وَجْهِي فَلَا يُرَى». ");
INSERT INTO arb_vd_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ثُمَّ قَالَ ٱلرَّبُّ لِمُوسَى: «ٱنْحَتْ لَكَ لَوْحَيْنِ مِنْ حَجَرٍ مِثْلَ ٱلْأَوَّلَيْنِ، فَأَكْتُبَ أَنَا عَلَى ٱللَّوْحَيْنِ ٱلْكَلِمَاتِ ٱلَّتِي كَانَتْ عَلَى ٱللَّوْحَيْنِ ٱلْأَوَّلَيْنِ ٱللَّذَيْنِ كَسَرْتَهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","وَكُنْ مُسْتَعِدًّا لِلصَّبَاحِ. وَٱصْعَدْ فِي ٱلصَّبَاحِ إِلَى جَبَلِ سِينَاءَ، وَقِفْ عِنْدِي هُنَاكَ عَلَى رَأْسِ ٱلْجَبَلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","وَلَا يَصْعَدْ أَحَدٌ مَعَكَ، وَأَيْضًا لَا يُرَ أَحَدٌ فِي كُلِّ ٱلْجَبَلِ. ٱلْغَنَمُ أَيْضًا وَٱلْبَقَرُ لَا تَرْعَ إِلَى جِهَةِ ذَلِكَ ٱلْجَبَلِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","فَنَحَتَ لَوْحَيْنِ مِنْ حَجَرٍ كَٱلْأَوَّلَيْنِ. وَبَكَّرَ مُوسَى فِي ٱلصَّبَاحِ وَصَعِدَ إِلَى جَبَلِ سِينَاءَ كَمَا أَمَرَهُ ٱلرَّبُّ، وَأَخَذَ فِي يَدِهِ لَوْحَيِ ٱلْحَجَرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","فَنَزَلَ ٱلرَّبُّ فِي ٱلسَّحَابِ، فَوَقَفَ عِنْدَهُ هُنَاكَ وَنَادَى بِٱسْمِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","فَٱجْتَازَ ٱلرَّبُّ قُدَّامَهُ، وَنَادَى ٱلرَّبُّ: «ٱلرَّبُّ إِلَهٌ رَحِيمٌ وَرَؤُوفٌ، بَطِيءُ ٱلْغَضَبِ وَكَثِيرُ ٱلْإِحْسَانِ وَٱلْوَفَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","حَافِظُ ٱلْإِحْسَانِ إِلَى أُلُوفٍ. غَافِرُ ٱلْإِثْمِ وَٱلْمَعْصِيَةِ وَٱلْخَطِيَّةِ. وَلَكِنَّهُ لَنْ يُبْرِئَ إِبْرَاءً. مُفْتَقِدٌ إِثْمَ ٱلْآبَاءِ فِي ٱلْأَبْنَاءِ، وَفِي أَبْنَاءِ ٱلْأَبْنَاءِ، فِي ٱلْجِيلِ ٱلثَّالِثِ وَٱلرَّابِعِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","فَأَسْرَعَ مُوسَى وَخَرَّ إِلَى ٱلْأَرْضِ وَسَجَدَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","وَقَالَ: «إِنْ وَجَدْتُ نِعْمَةً فِي عَيْنَيْكَ أَيُّهَا ٱلسَّيِّدُ فَلْيَسِرِ ٱلسَّيِّدُ فِي وَسَطِنَا، فَإِنَّهُ شَعْبٌ صُلْبُ ٱلرَّقَبَةِ. وَٱغْفِرْ إِثْمَنَا وَخَطِيَّتَنَا وَٱتَّخِذْنَا مُلْكًا». ");
INSERT INTO arb_vd_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","فَقَالَ: «هَا أَنَا قَاطِعٌ عَهْدًا. قُدَّامَ جَمِيعِ شَعْبِكَ أَفْعَلُ عَجَائِبَ لَمْ تُخْلَقْ فِي كُلِّ ٱلْأَرْضِ وَفِي جَمِيعِ ٱلْأُمَمِ، فَيَرَى جَمِيعُ ٱلشَّعْبِ ٱلَّذِي أَنْتَ فِي وَسَطِهِ فِعْلَ ٱلرَّبِّ. إِنَّ ٱلَّذِي أَنَا فَاعِلُهُ مَعَكَ رَهِيبٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","«اِحْفَظْ مَا أَنَا مُوصِيكَ ٱلْيَوْمَ. هَا أَنَا طَارِدٌ مِنْ قُدَّامِكَ ٱلْأَمُورِيِّينَ وَٱلْكَنْعَانِيِّينَ وَٱلْحِثِّيِّينَ وَٱلْفِرِزِّيِّينَ وَٱلْحِوِّيِّينَ وَٱلْيَبُوسِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","اِحْتَرِزْ مِنْ أَنْ تَقْطَعَ عَهْدًا مَعَ سُكَّانِ ٱلْأَرْضِ ٱلَّتِي أَنْتَ آتٍ إِلَيْهَا لِئَلَّا يَصِيرُوا فَخًّا فِي وَسَطِكَ، ");
INSERT INTO arb_vd_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","بَلْ تَهْدِمُونَ مَذَابِحَهُمْ، وَتُكَسِّرُونَ أَنْصَابَهُمْ، وَتَقْطَعُونَ سَوَارِيَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","فَإِنَّكَ لَا تَسْجُدُ لِإِلَهٍ آخَرَ، لِأَنَّ ٱلرَّبَّ ٱسْمُهُ غَيُورٌ. إِلَهٌ غَيُورٌ هُوَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","اِحْتَرِزْ مِنْ أَنْ تَقْطَعَ عَهْدًا مَعَ سُكَّانِ ٱلْأَرْضِ، فَيَزْنُونَ وَرَاءَ آلِهَتِهِمْ وَيَذْبَحُونَ لِآلِهَتِهِمْ، فَتُدْعَى وَتَأْكُلُ مِنْ ذَبِيحَتِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","وَتَأْخُذُ مِنْ بَنَاتِهِمْ لِبَنِيكَ، فَتَزْنِي بَنَاتُهُمْ وَرَاءَ آلِهَتِهِنَّ، وَيَجْعَلْنَ بَنِيكَ يَزْنُونَ وَرَاءَ آلِهَتِهِنَّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«لَا تَصْنَعْ لِنَفْسِكَ آلِهَةً مَسْبُوكَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","تَحْفَظُ عِيدَ ٱلْفَطِيرِ. سَبْعَةَ أَيَّامٍ تَأْكُلُ فَطِيرًا كَمَا أَمَرْتُكَ فِي وَقْتِ شَهْرِ أَبِيبَ، لِأَنَّكَ فِي شَهْرِ أَبِيبَ خَرَجْتَ مِنْ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","لِي كُلُّ فَاتِحِ رَحِمٍ، وَكُلُّ مَا يُولَدُ ذَكَرًا مِنْ مَوَاشِيكَ بِكْرًا مِنْ ثَوْرٍ وَشَاةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","وَأَمَّا بِكْرُ ٱلْحِمَارِ فَتَفْدِيهِ بِشَاةٍ، وَإِنْ لَمْ تَفْدِهِ تَكْسِرُ عُنُقَهُ. كُلُّ بِكْرٍ مِنْ بَنِيكَ تَفْدِيهِ، وَلَا يَظْهَرُوا أَمَامِي فَارِغِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","سِتَّةَ أَيَّامٍ تَعْمَلُ، وَأَمَّا ٱلْيَوْمُ ٱلسَّابِعُ فَتَسْتَرِيحُ فِيهِ. فِي ٱلْفَلَاحَةِ وَفِي ٱلْحَصَادِ تَسْتَرِيحُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","وَتَصْنَعُ لِنَفْسِكَ عِيدَ ٱلْأَسَابِيعِ أَبْكَارِ حِصَادِ ٱلْحِنْطَةِ. وَعِيدَ ٱلْجَمْعِ فِي آخِرِ ٱلسَّنَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ثَلَاثَ مَرَّاتٍ فِي ٱلسَّنَةِ يَظْهَرُ جَمِيعُ ذُكُورِكَ أَمَامَ ٱلسَّيِّدِ ٱلرَّبِّ إِلَهِ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","فَإِنِّي أَطْرُدُ ٱلْأُمَمَ مِنْ قُدَّامِكَ وَأُوَسِّعُ تُخُومَكَ، وَلَا يَشْتَهِي أَحَدٌ أَرْضَكَ حِينَ تَصْعَدُ لِتَظْهَرَ أَمَامَ ٱلرَّبِّ إِلَهِكَ ثَلَاثَ مَرَّاتٍ فِي ٱلسَّنَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","لَا تَذْبَحْ عَلَى خَمِيرٍ دَمَ ذَبِيحَتِي، وَلَا تَبِتْ إِلَى ٱلْغَدِ ذَبِيحَةُ عِيدِ ٱلْفِصْحِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","أَوَّلُ أَبْكَارِ أَرْضِكَ تُحْضِرُهُ إِلَى بَيْتِ ٱلرَّبِّ إِلَهِكَ. لَا تَطْبُخْ جَدْيًا بِلَبَنِ أُمِّهِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","وَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱكْتُبْ لِنَفْسِكَ هَذِهِ ٱلْكَلِمَاتِ، لِأَنَّنِي بِحَسَبِ هَذِهِ ٱلْكَلِمَاتِ قَطَعْتُ عَهْدًا مَعَكَ وَمَعَ إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","وَكَانَ هُنَاكَ عِنْدَ ٱلرَّبِّ أَرْبَعِينَ نَهَارًا وَأَرْبَعِينَ لَيْلَةً، لَمْ يَأْكُلْ خُبْزًا وَلَمْ يَشْرَبْ مَاءً. فَكَتَبَ عَلَى ٱللَّوْحَيْنِ كَلِمَاتِ ٱلْعَهْدِ، ٱلْكَلِمَاتِ ٱلْعَشَرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","وَكَانَ لَمَّا نَزَلَ مُوسَى مِنْ جَبَلِ سِينَاءَ وَلَوْحَا ٱلشَّهَادَةِ فِي يَدِ مُوسَى، عِنْدَ نُزُولِهِ مِنَ ٱلْجَبَلِ، أَنَّ مُوسَى لَمْ يَعْلَمْ أَنَّ جِلْدَ وَجْهِهِ صَارَ يَلْمَعُ فِي كَلَامِهِ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","فَنَظَرَ هَارُونُ وَجَمِيعُ بَنِي إِسْرَائِيلَ مُوسَى وَإِذَا جِلْدُ وَجْهِهِ يَلْمَعُ، فَخَافُوا أَنْ يَقْتَرِبُوا إِلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","فَدَعَاهُمْ مُوسَى. فَرَجَعَ إِلَيْهِ هَارُونُ وَجَمِيعُ ٱلرُّؤَسَاءِ فِي ٱلْجَمَاعَةِ، فَكَلَّمَهُمْ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","وَبَعْدَ ذَلِكَ ٱقْتَرَبَ جَمِيعُ بَنِي إِسْرَائِيلَ، فَأَوْصَاهُمْ بِكُلِّ مَا تَكَلَّمَ بِهِ ٱلرَّبُّ مَعَهُ فِي جَبَلِ سِينَاءَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","وَلَمَّا فَرَغَ مُوسَى مِنَ ٱلْكَلَامِ مَعَهُمْ، جَعَلَ عَلَى وَجْهِهِ بُرْقُعًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","وَكَانَ مُوسَى عِنْدَ دُخُولِهِ أَمَامَ ٱلرَّبِّ لِيَتَكَلَّمَ مَعَهُ يَنْزِعُ ٱلْبُرْقُعَ حَتَّى يَخْرُجَ، ثُمَّ يَخْرُجُ وَيُكَلِّمُ بَنِي إِسْرَائِيلَ بِمَا يُوصَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","فَإِذَا رَأَى بَنُو إِسْرَائِيلَ وَجْهَ مُوسَى أَنَّ جِلْدَهُ يَلْمَعُ كَانَ مُوسَى يَرُدُّ ٱلْبُرْقُعَ عَلَى وَجْهِهِ حَتَّى يَدْخُلَ لِيَتَكَلَّمَ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","وَجَمَعَ مُوسَى كُلَّ جَمَاعَةِ بَنِي إِسْرَائِيلَ وَقَالَ لَهُمْ: «هَذِهِ هِيَ ٱلْكَلِمَاتُ ٱلَّتِي أَمَرَ ٱلرَّبُّ أَنْ تُصْنَعَ: ");
INSERT INTO arb_vd_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","سِتَّةَ أَيَّامٍ يُعْمَلُ عَمَلٌ، وَأَمَّا ٱلْيَوْمُ ٱلْسَّابِعُ فَفِيهِ يَكُونُ لَكُمْ سَبْتُ عُطْلَةٍ مُقَدَّسٌ لِلرَّبِّ. كُلُّ مَنْ يَعْمَلُ فِيهِ عَمَلًا يُقْتَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","لَا تُشْعِلُوا نَارًا فِي جَمِيعِ مَسَاكِنِكُمْ يَوْمَ ٱلسَّبْتِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","وَكَلَّمَ مُوسَى كُلَّ جَمَاعَةِ بَنِي إِسْرَائِيلَ قَائِلًا: «هَذَا هُوَ ٱلشَّيْءُ ٱلَّذِي أَمَرَ بِهِ ٱلرَّبُّ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","خُذُوا مِنْ عِنْدِكُمْ تَقْدِمَةً لِلرَّبِّ. كُلُّ مَنْ قَلْبُهُ سَمُوحٌ فَلْيَأْتِ بِتَقْدِمَةِ ٱلرَّبِّ: ذَهَبًا وَفِضَّةً وَنُحَاسًا، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","وَأَسْمَانْجُونِيًّا وَأُرْجُوَانًا وَقِرْمِزًا وَبُوصًا وَشَعْرَ مِعْزًى، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","وَجُلُودَ كِبَاشٍ مُحَمَّرَةً وَجُلُودَ تُخَسٍ وَخَشَبَ سَنْطٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","وَزَيْتًا لِلضَّوْءِ وَأَطْيَابًا لِدُهْنِ ٱلْمَسْحَةِ وَلِلْبَخُورِ ٱلْعَطِرِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","وَحِجَارَةَ جَزْعٍ وَحِجَارَةَ تَرْصِيعٍ لِلرِّدَاءِ وَٱلصُّدْرَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","وَكُلُّ حَكِيمِ ٱلْقَلْبِ بَيْنَكُمْ فَلْيَأْتِ وَيَصْنَعْ كُلَّ مَا أَمَرَ بِهِ ٱلرَّبُّ: ");
INSERT INTO arb_vd_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ٱلْمَسْكَنَ وَخَيْمَتَهُ وَغِطَاءَهُ وَأَشِظَّتَهُ وَأَلْوَاحَهُ وَعَوَارِضَهُ وَأَعْمِدَتَهُ وَقَوَاعِدَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","وَٱلتَّابُوتَ وَعَصَوَيْهِ، وَٱلْغِطَاءَ وَحِجَابَ ٱلسَّجْفِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","وَٱلْمَائِدَةَ وَعَصَوَيْهَا وَكُلَّ آنِيَتِهَا، وَخُبْزَ ٱلْوُجُوهِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","وَمَنَارَةَ ٱلضَّوْءِ وَآنِيَتَهَا وَسُرُجَهَا وَزَيْتَ ٱلضَّوْءِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","وَمَذْبَحَ ٱلْبَخُورِ وَعَصَوَيْهِ، وَدُهْنَ ٱلْمَسْحَةِ وَٱلْبَخُورَ ٱلْعَطِرَ، وَسَجْفَ ٱلْبَابِ لِمَدْخَلِ ٱلْمَسْكَنِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","وَمَذْبَحَ ٱلْمُحْرَقَةِ وَشُبَّاكَةَ ٱلنُّحَاسِ ٱلَّتِي لَهُ وَعَصَوَيْهِ وَكُلَّ آنِيَتِهِ، وَٱلْمِرْحَضَةَ وَقَاعِدَتَهَا، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","وَأَسْتَارَ ٱلدَّارِ وَأَعْمِدَتَهَا وَقَوَاعِدَهَا، وَسَجْفَ بَابِ ٱلدَّارِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","وَأَوْتَادَ ٱلْمَسْكَنِ، وَأَوْتَادَ ٱلدَّارِ وَأَطْنَابَهَا، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","وَٱلثِّيَابَ ٱلْمَنْسُوجَةَ لِلْخِدْمَةِ فِي ٱلْمَقْدِسِ، وَٱلثِّيَابَ ٱلْمُقَدَّسَةَ لِهَارُونَ ٱلْكَاهِنِ، وَثِيَابَ بَنِيهِ لِلْكَهَانَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","فَخَرَجَ كُلُّ جَمَاعَةِ بَنِي إِسْرَائِيلَ مِنْ قُدَّامِ مُوسَى، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ثُمَّ جَاءَ كُلُّ مَنْ أَنْهَضَهُ قَلْبُهُ، وَكُلُّ مَنْ سَمَّحَتْهُ رُوحُهُ. جَاءُوا بِتَقْدِمَةِ ٱلرَّبِّ لِعَمَلِ خَيْمَةِ ٱلِٱجْتِمَاعِ وَلِكُلِّ خِدْمَتِهَا وَلِلثِّيَابِ ٱلْمُقَدَّسَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","وَجَاءَ ٱلرِّجَالُ مَعَ ٱلنِّسَاءِ، كُلُّ سَمُوحِ ٱلْقَلْبِ، جَاءَ بِخَزَائِمَ وَأَقْرَاطٍ وَخَوَاتِمَ وَقَلَائِدَ، كُلِّ مَتَاعٍ مِنَ ٱلذَّهَبِ. وَكُلُّ مَنْ قَدَّمَ تَقْدِمَةَ ذَهَبٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","وَكُلُّ مَنْ وُجِدَ عِنْدَهُ أَسْمَانْجُونِيٌّ وَأُرْجُوانٌ وَقِرْمِزٌ وَبُوصٌ وَشَعْرُ مِعْزًى وَجُلُودُ كِبَاشٍ مُحَمَّرَةٌ وَجُلُودُ تُخَسٍ، جَاءَ بِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","كُلُّ مَنْ قَدَّمَ تَقْدِمَةَ فِضَّةٍ وَنُحَاسٍ جَاءَ بِتَقْدِمَةِ ٱلرَّبِّ. وَكُلُّ مَنْ وُجِدَ عِنْدَهُ خَشَبُ سَنْطٍ لِصَنْعَةٍ مَا مِنَ ٱلْعَمَلِ جَاءَ بِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","وَكُلُّ ٱلنِّسَاءِ ٱلْحَكِيمَاتِ ٱلْقَلْبِ غَزَلْنَ بِأَيْدِيهِنَّ وَجِئْنَ مِنَ ٱلْغَزْلِ بِٱلْأَسْمَانْجُونِيِّ وَٱلْأُرْجُوَانِ وَٱلْقِرْمِزِ وَٱلْبُوصِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","وَكُلُّ ٱلنِّسَاءِ ٱللَّوَاتِي أَنْهَضَتْهُنَّ قُلُوبُهُنَّ بِٱلْحِكْمَةِ غَزَلْنَ شَعْرَ ٱلْمِعْزَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","وَٱلرُّؤَسَاءُ جَاءُوا بِحِجَارَةِ ٱلْجَزْعِ وَحِجَارَةِ ٱلتَّرْصِيعِ لِلرِّدَاءِ وَٱلصُّدْرَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","وَبِٱلطِّيبِ وَٱلزَّيْتِ لِلضَّوْءِ وَلِدُهْنِ ٱلْمَسْحَةِ وَلِلْبَخُورِ ٱلْعَطِرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","بَنُو إِسْرَائِيلَ، جَمِيعُ ٱلرِّجَالِ وَٱلنِّسَاءِ ٱلَّذِينَ سَمَّحَتْهُمْ قُلُوبُهُمْ أَنْ يَأْتُوا بِشَيْءٍ لِكُلِّ ٱلْعَمَلِ ٱلَّذِي أَمَرَ ٱلرَّبُّ أَنْ يُصْنَعَ عَلَى يَدِ مُوسَى، جَاءُوا بِهِ تَبَرُّعًا إِلَى ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","وَقَالَ مُوسَى لِبَنِي إِسْرَائِيلَ: «ٱنْظُرُوا. قَدْ دَعَا ٱلرَّبُّ بَصَلْئِيلَ بْنَ أُورِي بْنَ حُورَ مِنْ سِبْطِ يَهُوذَا بِٱسْمِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","وَمَلَأَهُ مِنْ رُوحِ ٱللهِ بِٱلْحِكْمَةِ وَٱلْفَهْمِ وَٱلْمَعْرِفَةِ وَكُلِّ صَنْعَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","وَلِٱخْتِرَاعِ مُخْتَرَعَاتٍ، لِيَعْمَلَ فِي ٱلذَّهَبِ وَٱلْفِضَّةِ وَٱلنُّحَاسِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","وَنَقْشِ حِجَارَةٍ لِلتَّرْصِيعِ، وَنِجَارَةِ ٱلْخَشَبِ، لِيَعْمَلَ فِي كُلِّ صَنْعَةٍ مِنَ ٱلْمُخْتَرَعَاتِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","وَجَعَلَ فِي قَلْبِهِ أَنْ يُعَلِّمَ هُوَ وَأُهُولِيآبُ بْنَ أَخِيسَامَاكَ مِنْ سِبْطِ دَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","قَدْ مَلَأَهُمَا حِكْمَةَ قَلْبٍ لِيَصْنَعَا كُلَّ عَمَلِ ٱلنَّقَّاشِ وَٱلْحَائِكِ ٱلْحَاذِقِ وَٱلطَّرَّازِ فِي ٱلْأَسْمَانْجُونِيِّ وَٱلْأُرْجُوَانِ وَٱلْقِرْمِزِ وَٱلْبُوصِ وَكُلَّ عَمَلِ ٱلنَّسَّاجِ. صَانِعِي كُلِّ صَنْعَةٍ وَمُخْتَرِعِي ٱلْمُخْتَرَعَاتِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«فَيَعْمَلُ بَصَلْئِيلُ وَأُهُولِيآبُ وَكُلُّ إِنْسَانٍ حَكِيمِ ٱلْقَلْبِ، قَدْ جَعَلَ فِيهِ ٱلرَّبُّ حِكْمَةً وَفَهْمًا لِيَعْرِفَ أَنْ يَصْنَعَ صَنْعَةً مَّا مِنْ عَمَلِ ٱلْمَقْدِسِ، بِحَسَبِ كُلِّ مَا أَمَرَ ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","فَدَعَا مُوسَى بَصَلْئِيلَ وَأُهُولِيآبَ وَكُلَّ رَجُلٍ حَكِيمِ ٱلْقَلْبِ، قَدْ جَعَلَ ٱلرَّبُّ حِكْمَةً فِي قَلْبِهِ، كُلَّ مَنْ أَنْهَضَهُ قَلْبُهُ أَنْ يَتَقَدَّمَ إِلَى ٱلْعَمَلِ لِيَصْنَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","فَأَخَذُوا مِنْ قُدَّامِ مُوسَى كُلَّ ٱلتَّقْدِمَةِ ٱلَّتِي جَاءَ بِهَا بَنُو إِسْرَائِيلَ لِصَنْعَةِ عَمَلِ ٱلْمَقْدِسِ لِكَيْ يَصْنَعُوهُ. وَهُمْ جَاءُوا إِلَيْهِ أَيْضًا بِشَيْءٍ تَبَرُّعًا كُلَّ صَبَاحٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","فَجَاءَ كُلُّ ٱلْحُكَمَاءِ ٱلصَّانِعِينَ كُلَّ عَمَلِ ٱلْمَقْدِسِ، كُلُّ وَاحِدٍ مِنْ عَمَلِهِ ٱلَّذِي هُمْ يَصْنَعُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","وَكَلَّمُوا مُوسَى قَائِلِينَ: «يَجِيءُ ٱلشَّعْبُ بِكَثِيرٍ فَوْقَ حَاجَةِ ٱلْعَمَلِ لِلصَّنْعَةِ ٱلَّتِي أَمَرَ ٱلرَّبُّ بِصُنْعِهَا». ");
INSERT INTO arb_vd_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","فَأَمَرَ مُوسَى أَنْ يُنْفِذُوا صَوْتًا فِي ٱلْمَحَلَّةِ قَائِلِينَ: «لَا يَصْنَعْ رَجُلٌ أَوِ ٱمْرَأَةٌ عَمَلًا أَيْضًا لِتَقْدِمَةِ ٱلْمَقْدِسِ». فَٱمْتَنَعَ ٱلشَّعْبُ عَنِ ٱلْجَلَبِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","وَٱلْمَوَادُّ كَانَتْ كِفَايَتَهُمْ لِكُلِّ ٱلْعَمَلِ لِيَصْنَعُوهُ وَأَكْثَرَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","فَصَنَعُوا كُلُّ حَكِيمِ قَلْبٍ مِنْ صَانِعِي ٱلْعَمَلِ ٱلْمَسْكَنَ عَشَرَ شُقَقٍ مِنْ بُوصٍ مَبْرُومٍ وَأَسْمَانْجُونِيٍّ وَأُرْجُوانٍ وَقِرْمِزٍ بِكَرُوبِيمَ، صَنْعَةَ حَائِكٍ حَاذِقٍ صَنَعَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","طُولُ ٱلشُّقَّةِ ٱلْوَاحِدَةِ ثَمَانٍ وَعِشْرُونَ ذِرَاعًا، وَعَرْضُ ٱلشُّقَّةِ ٱلْوَاحِدَةِ أَرْبَعُ أَذْرُعٍ. قِيَاسًا وَاحِدًا لِجَمِيعِ ٱلشُّقَقِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","وَوَصَلَ خَمْسًا مِنَ ٱلشُّقَقِ بَعْضَهَا بِبَعْضٍ. وَوَصَلَ خَمْسًا مِنَ ٱلشُّقَقِ بَعْضَهَا بِبَعْضٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","وَصَنَعَ عُرًى مِنْ أَسْمَانْجُونِيٍّ عَلَى حَاشِيَةِ ٱلشُّقَّةِ ٱلْوَاحِدَةِ فِي ٱلطَّرَفِ مِنَ ٱلْمُوَصَّلِ ٱلْوَاحِدِ. كَذَلِكَ صَنَعَ فِي حَاشِيَةِ ٱلشُّقَّةِ ٱلطَّرَفِيَّةِ مِنَ ٱلْمُوَصَّلِ ٱلثَّانِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","خَمْسِينَ عُرْوَةً صَنَعَ فِي ٱلشُّقَّةِ ٱلْوَاحِدَةِ، وَخَمْسِينَ عُرْوَةً صَنَعَ فِي طَرَفِ ٱلشُّقَّةِ ٱلَّذِي فِي ٱلْمُوَصَّلِ ٱلثَّانِي. مُقَابِلَةً كَانَتِ ٱلْعُرَى بَعْضُهَا لِبَعْضٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","وَصَنَعَ خَمْسِينَ شِظَاظًا مِنْ ذَهَبٍ، وَوَصَلَ ٱلشُّقَّتَيْنِ بَعْضَهُمَا بِبَعْضٍ بِٱلْأَشِظَّةِ، فَصَارَ ٱلْمَسْكَنُ وَاحِدًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","وَصَنَعَ شُقَقًا مِنْ شَعْرِ مِعْزًى خَيْمَةً فَوْقَ ٱلْمَسْكَنِ. إِحْدَى عَشْرَةَ شُقَّةً صَنَعَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","طُولُ ٱلشُّقَّةِ ٱلْوَاحِدَةِ ثَلَاثُونَ ذِرَاعًا، وَعَرْضُ ٱلشُّقَّةِ ٱلْوَاحِدَةِ أَرْبَعُ أَذْرُعٍ. قِيَاسًا وَاحِدًا لِلْإِحْدَى عَشْرَةَ شُقَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","وَوَصَلَ خَمْسًا مِنَ ٱلشُّقَقِ وَحْدَهَا، وَسِتًّا مِنَ ٱلشُّقَقِ وَحْدَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","وَصَنَعَ خَمْسِينَ عُرْوَةً عَلَى حَاشِيَةِ ٱلشُّقَّةِ ٱلطَّرَفِيَّةِ مِنَ ٱلْمُوَصَّلِ ٱلْوَاحِدِ. وَصَنَعَ خَمْسِينَ عُرْوَةً عَلَى حَاشِيَةِ ٱلشُّقَّةِ ٱلْمُوَصَّلَةِ ٱلثَّانِيَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","وَصَنَعَ خَمْسِينَ شِظَاظًا مِنْ نُحَاسٍ لِيَصِلَ ٱلْخَيْمَةَ لِتَصِيرَ وَاحِدَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","وَصَنَعَ غِطَاءً لِلْخَيْمَةِ مِنْ جُلُودِ كِبَاشٍ مُحَمَّرَةً، وَغِطَاءً مِنْ جُلُودِ تُخَسٍ مِنْ فَوْقُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","وَصَنَعَ ٱلْأَلْوَاحَ لِلْمَسْكَنِ مِنْ خَشَبِ ٱلسَّنْطِ قَائِمَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","طُولُ ٱللَّوْحِ عَشْرُ أَذْرُعٍ، وَعَرْضُ ٱللَّوْحِ ٱلْوَاحِدِ ذِرَاعٌ وَنِصْفٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","وَلِلَّوْحِ ٱلْوَاحِدِ رِجْلَانِ، مَقْرُونَةٌ إِحْدَاهُمَا بِٱلْأُخْرَى. هَكَذَا صَنَعَ لِجَمِيعِ أَلْوَاحِ ٱلْمَسْكَنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","وَصَنَعَ ٱلْأَلْوَاحَ لِلْمَسْكَنِ عِشْرِينَ لَوْحًا إِلَى جِهَةِ ٱلْجَنُوبِ نَحْوَ ٱلتَّيْمَنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","وَصَنَعَ أَرْبَعِينَ قَاعِدَةً مِنْ فِضَّةٍ تَحْتَ ٱلْعِشْرِينَ لَوْحًا، تَحْتَ ٱللَّوْحِ ٱلْوَاحِدِ قَاعِدَتَانِ لِرِجْلَيْهِ، وَتَحْتَ ٱللَّوْحِ ٱلْوَاحِدِ قَاعِدَتَانِ لِرِجْلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","وَلِجَانِبِ ٱلْمَسْكَنِ ٱلثَّانِي إِلَى جِهَةِ ٱلشِّمَالِ صَنَعَ عِشْرِينَ لَوْحًا، ");
INSERT INTO arb_vd_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","وَأَرْبَعِينَ قَاعِدَةً لَهَا مِنْ فِضَّةٍ. تَحْتَ ٱللَّوْحِ ٱلْوَاحِدِ قَاعِدَتَانِ، وَتَحْتَ ٱللَّوْحِ ٱلْوَاحِدِ قَاعِدَتَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","وَلِمُؤَخَّرِ ٱلْمَسْكَنِ نَحْوَ ٱلْغَرْبِ صَنَعَ سِتَّةَ أَلْوَاحٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","وَصَنَعَ لَوْحَيْنِ لِزَاوِيَتَيِ ٱلْمَسْكَنِ فِي ٱلْمُؤَخَّرِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","وَكَانَا مُزْدَوِجَيْنِ مِنْ أَسْفَلُ، وَعَلَى سَوَاءٍ كَانَا مُزْدَوِجَيْنِ إِلَى رَأْسِهِ إِلَى ٱلْحَلْقَةِ ٱلْوَاحِدَةِ. هَكَذَا صَنَعَ لِكِلْتَيْهِمَا، لِكِلْتَا ٱلزَّاوِيَتَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","فَكَانَتْ ثَمَانِيَةَ أَلْوَاحٍ وَقَوَاعِدُهَا مِنْ فِضَّةٍ سِتَّ عَشْرَةَ قَاعِدَةً. قَاعِدَتَيْنِ قَاعِدَتَيْنِ تَحْتَ ٱللَّوْحِ ٱلْوَاحِدِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","وَصَنَعَ عَوَارِضَ مِنْ خَشَبِ ٱلسَّنْطِ، خَمْسًا لِأَلْوَاحِ جَانِبِ ٱلْمَسْكَنِ ٱلْوَاحِدِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","وَخَمْسَ عَوَارِضَ لِأَلْوَاحِ جَانِبِ ٱلْمَسْكَنِ ٱلثَّانِي، وَخَمْسَ عَوَارِضَ لِأَلْوَاحِ ٱلْمَسْكَنِ فِي ٱلْمُؤَخَّرِ نَحْوَ ٱلْغَرْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","وَصَنَعَ ٱلْعَارِضَةَ ٱلْوُسْطَى لِتَنْفُذَ فِي وَسَطِ ٱلْأَلْوَاحِ مِنَ ٱلطَّرَفِ إِلَى ٱلطَّرَفِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","وَغَشَّى ٱلْأَلْوَاحَ بِذَهَبٍ. وَصَنَعَ حَلَقَاتِهَا مِنْ ذَهَبٍ بُيُوتًا لِلْعَوَارِضِ، وَغَشَّى ٱلْعَوَارِضَ بِذَهَبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","وَصَنَعَ ٱلْحِجَابَ مِنْ أَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ. صَنْعَةَ حَائِكٍ حَاذِقٍ صَنَعَهُ بِكَرُوبِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","وَصَنَعَ لَهُ أَرْبَعَةَ أَعْمِدَةٍ مِنْ سَنْطٍ، وَغَشَّاهَا بِذَهَبٍ. رُزَزُهَا مِنْ ذَهَبٍ. وَسَبَكَ لَهَا أَرْبَعَ قَوَاعِدَ مِنْ فِضَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","وَصَنَعَ سَجْفًا لِمَدْخَلِ ٱلْخَيْمَةِ مِنْ أَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ صَنْعَةَ ٱلطَّرَّازِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","وَأَعْمِدَتَهُ خَمْسَةً وَرُزَزَهَا. وَغَشَّى رُؤُوسَهَا وَقُضْبَانَهَا بِذَهَبٍ، وَقَوَاعِدَهَا خَمْسًا مِنْ نُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","وَصَنَعَ بَصَلْئِيلُ ٱلتَّابُوتَ مِنْ خَشَبِ ٱلسَّنْطِ، طُولُهُ ذِرَاعَانِ وَنِصْفٌ، وَعَرْضُهُ ذِرَاعٌ وَنِصْفٌ، وَٱرْتِفَاعُهُ ذِرَاعٌ وَنِصْفٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","وَغَشَّاهُ بِذَهَبٍ نَقِيٍّ مِنْ دَاخِلٍ وَمِنْ خَارِجٍ. وَصَنَعَ لَهُ إِكْلِيلًا مِنْ ذَهَبٍ حَوَالَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","وَسَبَكَ لَهُ أَرْبَعَ حَلَقَاتٍ مِنْ ذَهَبٍ عَلَى أَرْبَعِ قَوَائِمِهِ. عَلَى جَانِبِهِ ٱلْوَاحِدِ حَلْقَتَانِ، وَعَلَى جَانِبِهِ ٱلثَّانِي حَلْقَتَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","وَصَنَعَ عَصَوَيْنِ مِنْ خَشَبِ ٱلسَّنْطِ وَغَشَّاهُمَا بِذَهَبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","وَأَدْخَلَ ٱلْعَصَوَيْنِ فِي ٱلْحَلَقَاتِ عَلَى جَانِبَيِ ٱلتَّابُوتِ، لِحَمْلِ ٱلتَّابُوتِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","وَصَنَعَ غِطَاءً مِنْ ذَهَبٍ نَقِيٍّ، طُولُهُ ذِرَاعَانِ وَنِصْفٌ، وَعَرْضُهُ ذِرَاعٌ وَنِصْفٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","وَصَنَعَ كَرُوبَيْنِ مِنْ ذَهَبٍ صَنْعَةَ ٱلْخِرَاطَةِ، صَنَعَهُمَا عَلَى طَرَفَيِ ٱلْغِطَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","كَرُوبًا وَاحِدًا عَلَى ٱلطَّرَفِ مِنْ هُنَا، وَكَرُوبًا وَاحِدًا عَلَى ٱلطَّرَفِ مِنْ هُنَاكَ. مِنَ ٱلْغِطَاءِ صَنَعَ ٱلْكَرُوبَيْنِ عَلَى طَرَفَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","وَكَانَ ٱلْكَرُوبَانِ بَاسِطَيْنِ أَجْنِحَتَهُمَا إِلَى فَوْقُ، مُظَلِّلَيْنِ بِأَجْنِحَتِهِمَا فَوْقَ ٱلْغِطَاءِ، وَوَجْهَاهُمَا كُلُّ ٱلْوَاحِدِ إِلَى ٱلْآخَرِ. نَحْوَ ٱلْغِطَاءِ كَانَ وَجْهَا ٱلْكَرُوبَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","وَصَنَعَ ٱلْمَائِدَةَ مِنْ خَشَبِ ٱلسَّنْطِ، طُولُهَا ذِرَاعَانِ، وَعَرْضُهَا ذِرَاعٌ، وَٱرْتِفَاعُهَا ذِرَاعٌ وَنِصْفٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","وَغَشَّاهَا بِذَهَبٍ نَقِيٍّ، وَصَنَعَ لَهَا إِكْلِيلًا مِنْ ذَهَبٍ حَوَالَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","وَصَنَعَ لَهَا حَاجِبًا عَلَى شِبْرٍ حَوَالَيْهَا، وَصَنَعَ لِحَاجِبِهَا إِكْلِيلًا مِنْ ذَهَبٍ حَوَالَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","وَسَبَكَ لَهَا أَرْبَعَ حَلَقَاتٍ مِنْ ذَهَبٍ، وَجَعَلَ ٱلْحَلَقَاتِ عَلَى ٱلزَّوَايَا ٱلْأَرْبَعِ ٱلَّتِي لِقَوَائِمِهَا ٱلْأَرْبَعِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","عِنْدَ ٱلْحَاجِبِ كَانَتِ ٱلْحَلَقَاتُ بُيُوتًا لِلْعَصَوَيْنِ لِحَمْلِ ٱلْمَائِدَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","وَصَنَعَ ٱلْعَصَوَيْنِ مِنْ خَشَبِ ٱلسَّنْطِ، وَغَشَّاهُمَا بِذَهَبٍ لِحَمْلِ ٱلْمَائِدَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","وَصَنَعَ ٱلْأَوَانِيَ ٱلَّتِي عَلَى ٱلْمَائِدَةِ، صِحَافَهَا وَصُحُونَهَا وَجَامَاتِهَا وَكَأْسَاتِهَا ٱلَّتِي يُسْكَبُ بِهَا مِنْ ذَهَبٍ نَقِيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","وَصَنَعَ ٱلْمَنَارَةَ مِنْ ذَهَبٍ نَقِيٍّ. صَنْعَةَ ٱلْخِرَاطَةِ صَنَعَ ٱلْمَنَارَةَ، قَاعِدَتَهَا وَسَاقَهَا. كَانَتْ كَأْسَاتُهَا وَعُجَرُهَا وَأَزْهَارُهَا مِنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","وَسِتُّ شُعَبٍ خَارِجَةٌ مِنْ جَانِبَيْهَا. مِنْ جَانِبِهَا ٱلْوَاحِدِ ثَلَاثُ شُعَبِ مَنَارَةٍ، وَمِنْ جَانِبِهَا ٱلثَّانِي ثَلَاثُ شُعَبِ مَنَارَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","فِي ٱلشُّعْبَةِ ٱلْوَاحِدَةِ ثَلَاثُ كَأْسَاتٍ لَوْزِيَّةٍ بِعُجْرَةٍ وَزَهْرٍ، وَفِي ٱلشُّعْبَةِ ٱلثَّانِيَةِ ثَلَاثُ كَأْسَاتٍ لَوْزِيَّةٍ بِعُجْرَةٍ وَزَهْرٍ، وَهَكَذَا إِلَى ٱلسِّتِّ ٱلشُّعَبِ ٱلْخَارِجَةِ مِنَ ٱلْمَنَارَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","وَفِي ٱلْمَنَارَةِ أَرْبَعُ كَأْسَاتٍ لَوْزِيَّةٍ بِعُجَرِهَا وَأَزْهَارِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","وَتَحْتَ ٱلشُّعْبَتَيْنِ مِنْهَا عُجْرَةٌ، وَتَحْتَ ٱلشُّعْبَتَيْنِ مِنْهَا عُجْرَةٌ، وَتَحْتَ ٱلشُّعْبَتَيْنِ مِنْهَا عُجْرَةٌ. إِلَى ٱلسِّتِّ ٱلشُّعَبِ ٱلْخَارِجَةِ مِنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","كَانَتْ عُجَرُهَا وَشُعَبُهَا مِنْهَا، جَمِيعُهَا خِرَاطَةٌ وَاحِدَةٌ مِنْ ذَهَبٍ نَقِيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","وَصَنَعَ سُرُجَهَا سَبْعَةً، وَمَلَاقِطَهَا وَمَنَافِضَهَا مِنْ ذَهَبٍ نَقِيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","مِنْ وَزْنَةِ ذَهَبٍ نَقِيٍّ صَنَعَهَا وَجَمِيعَ أَوَانِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","وَصَنَعَ مَذْبَحَ ٱلْبَخُورِ مِنْ خَشَبِ ٱلسَّنْطِ، طُولُهُ ذِرَاعٌ، وَعَرْضُهُ ذِرَاعٌ، مُرَبَّعًا. وَٱرْتِفَاعُهُ ذِرَاعَانِ. مِنْهُ كَانَتْ قُرُونُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","وَغَشَّاهُ بِذَهَبٍ نَقِيٍّ: سَطْحَهُ وَحِيطَانَهُ حَوَالَيْهِ وَقُرُونَهُ. وَصَنَعَ لَهُ إِكْلِيلًا مِنْ ذَهَبٍ حَوَالَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","وَصَنَعَ لَهُ حَلْقَتَيْنِ مِنْ ذَهَبٍ تَحْتَ إِكْلِيلِهِ عَلَى جَانِبَيْهِ، عَلَى ٱلْجَانِبَيْنِ بَيْتَيْنِ لِعَصَوَيْنِ لِحَمْلِهِ بِهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","وَصَنَعَ ٱلْعَصَوَيْنِ مِنْ خَشَبِ ٱلسَّنْطِ وَغَشَّاهُمَا بِذَهَبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","وَصَنَعَ دُهْنَ ٱلْمَسْحَةِ مُقَدَّسًا، وَٱلْبَخُورَ ٱلْعَطِرَ نَقِيًّا صَنْعَةَ ٱلْعَطَّارِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","وَصَنَعَ مَذْبَحَ ٱلْمُحْرَقَةِ مِنْ خَشَبِ ٱلسَّنْطِ، طُولُهُ خَمْسُ أَذْرُعٍ، وَعَرْضُهُ خَمْسُ أَذْرُعٍ، مُرَبَّعًا. وَٱرْتِفَاعُهُ ثَلَاثُ أَذْرُعٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","وَصَنَعَ قُرُونَهُ عَلَى زَوَايَاهُ ٱلْأَرْبَعِ. مِنْهُ كَانَتْ قُرُونُهُ. وَغَشَّاهُ بِنُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","وَصَنَعَ جَمِيعَ آنِيَةِ ٱلْمَذْبَحِ: ٱلْقُدُورَ وَٱلرُّفُوشَ وَٱلْمَرَاكِنَ وَٱلْمَنَاشِلَ وَٱلْمَجَامِرَ، جَمِيعَ آنِيَتِهِ صَنَعَهَا مِنْ نُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","وَصَنَعَ لِلْمَذْبَحِ شُبَّاكَةً صَنْعَةَ ٱلشَّبَكَةِ مِنْ نُحَاسٍ، تَحْتَ حَاجِبِهِ مِنْ أَسْفَلُ إِلَى نِصْفِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","وَسَبَكَ أَرْبَعَ حَلَقَاتٍ فِي ٱلْأَرْبَعَةِ ٱلْأَطْرَافِ لِشُبَّاكَةِ ٱلنُّحَاسِ بُيُوتًا لِلْعَصَوَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","وَصَنَعَ ٱلْعَصَوَيْنِ مِنْ خَشَبِ ٱلسَّنْطِ وَغَشَّاهُمَا بِنُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","وَأَدْخَلَ ٱلْعَصَوَيْنِ فِي ٱلْحَلَقَاتِ عَلَى جَانِبَيِ ٱلْمَذْبَحِ لِحَمْلِهِ بِهِمَا. مُجَوَّفًا صَنَعَهُ مِنْ أَلْوَاحٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","وَصَنَعَ ٱلْمِرْحَضَةَ مِنْ نُحَاسٍ وَقَاعِدَتَهَا مِنْ نُحَاسٍ. مِنْ مَرَائِي ٱلْمُتَجَنِّدَاتِ ٱللَّوَاتِي تَجَنَّدْنَ عِنْدَ بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","وَصَنَعَ ٱلدَّارَ: إِلَى جِهَةِ ٱلْجَنُوبِ نَحْوَ ٱلتَّيْمَنِ، أَسْتَارُ ٱلدَّارِ مِنْ بُوصٍ مَبْرُومٍ مِئَةُ ذِرَاعٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","أَعْمِدَتُهَا عِشْرُونَ، وَقَوَاعِدُهَا عِشْرُونَ مِنْ نُحَاسٍ. رُزَزُ ٱلْأَعْمِدَةِ وَقُضْبَانُهَا مِنْ فِضَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","وَإِلَى جِهَةِ ٱلشِّمَالِ، مِئَةُ ذِرَاعٍ، أَعْمِدَتُهَا عِشْرُونَ وَقَوَاعِدُهَا عِشْرُونَ مِنْ نُحَاسٍ. رُزَزُ ٱلْأَعْمِدَةِ وَقُضْبَانُهَا مِنْ فِضَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","وَإِلَى جِهَةِ ٱلْغَرْبِ أَسْتَارٌ، خَمْسُونَ ذِرَاعًا، أَعْمِدَتُهَا عَشَرَةٌ وَقَوَاعِدُهَا عَشْرٌ. رُزَزُ ٱلْأَعْمِدَةِ وَقُضْبَانُهَا مِنْ فِضَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","وَإِلَى جِهَةِ ٱلشَّرْقِ نَحْوَ ٱلشُّرُوقِ، خَمْسُونَ ذِرَاعًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","لِلْجَانِبِ ٱلْوَاحِدِ أَسْتَارٌ خَمْسَ عَشْرَةَ ذِرَاعًا، أَعْمِدَتُهَا ثَلَاثَةٌ وَقَوَاعِدُهَا ثَلَاثٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","وَلِلْجَانِبِ ٱلثَّانِي مِنْ بَابِ ٱلدَّارِ إِلَى هُنَا وَإِلَى هُنَا أَسْتَارٌ خَمْسَ عَشَرَةَ ذِرَاعًا، أَعْمِدَتُهَا ثَلَاثَةٌ وَقَوَاعِدُهَا ثَلَاثٌ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","جَمِيعُ أَسْتَارِ ٱلدَّارِ حَوَالَيْهَا مِنْ بُوصٍ مَبْرُومٍ، ");
INSERT INTO arb_vd_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","وَقَوَاعِدُ ٱلْأَعْمِدَةِ مِنْ نُحَاسٍ. رُزَزُ ٱلْأَعْمِدَةِ وَقُضْبَانُهَا مِنْ فِضَّةٍ وَتَغْشِيَةُ رُؤُوسِهَا مِنْ فِضَّةٍ وَجَمِيعُ أَعْمِدَةِ ٱلدَّارِ مَوْصُولَةٌ بِقُضْبَانٍ مِنْ فِضَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","وَسَجْفُ بَابِ ٱلدَّارِ صَنْعَةَ ٱلطَّرَّازِ مِنْ أَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ، وَطُولُهُ عِشْرُونَ ذِرَاعًا، وَٱرْتِفَاعُهُ بِٱلْعَرْضِ خَمْسُ أَذْرُعٍ بِسَوِيَّةِ أَسْتَارِ ٱلدَّارِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","وَأَعْمِدَتُهَا أَرْبَعَةٌ، وَقَوَاعِدُهَا أَرْبَعٌ مِنْ نُحَاسٍ. رُزَزُهَا مِنْ فِضَّةٍ، وَتَغْشِيَةُ رُؤُوسِهَا وَقُضْبَانِهَا مِنْ فِضَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","وَجَمِيعُ أَوْتَادِ ٱلْمَسْكَنِ وَٱلدَّارِ حَوَالَيْهَا مِنْ نُحَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","هَذَا هُوَ ٱلْمَحْسُوبُ لِلْمَسْكَنِ، مَسْكَنِ ٱلشَّهَادَةِ ٱلَّذِي حُسِبَ بِمُوجَبِ أَمْرِ مُوسَى بِخِدْمَةِ ٱللَّاوِيِّينَ عَلَى يَدِ إِيثَامَارَ بْنِ هَارُونَ ٱلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","وَبَصَلْئِيلُ بْنُ أُورِي بْنِ حُورَ مِنْ سِبْطِ يَهُوذَا صَنَعَ كُلَّ مَا أَمَرَ بِهِ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","وَمَعَهُ أُهُولِيآبُ بْنُ أَخِيسَامَاكَ مِنْ سِبْطِ دَانَ، نَقَّاشٌ وَمُوَشٍّ وَطَرَّازٌ بِٱلْأَسْمَانْجُونِيِّ وَٱلْأُرْجُوَانِ وَٱلْقِرْمِزِ وَٱلْبُوصِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","كُلُّ ٱلذَّهَبِ ٱلْمَصْنُوعِ لِلْعَمَلِ فِي جَمِيعِ عَمَلِ ٱلْمَقْدِسِ، وَهُوَ ذَهَبُ ٱلتَّقْدِمَةِ: تِسْعٌ وَعِشْرُونَ وَزْنَةً وَسَبْعُ مِئَةِ شَاقِلٍ وَثَلَاثُونَ شَاقِلًا بِشَاقِلِ ٱلْمَقْدِسِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","وَفِضَّةُ ٱلْمَعْدُودِينَ مِنَ ٱلْجَمَاعَةِ مِئَةُ وَزْنَةٍ وَأَلْفٌ وَسَبْعُ مِئَةِ شَاقِلٍ وَخَمْسَةٌ وَسَبْعُونَ شَاقِلًا بِشَاقِلِ ٱلْمَقْدِسِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","لِلرَّأْسِ نِصْفٌ، نِصْفُ ٱلشَّاقِلِ بِشَاقِلِ ٱلْمَقْدِسِ. لِكُلِّ مَنِ ٱجْتَازَ إِلَى ٱلْمَعْدُودِينَ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، لِسِتِّ مِئَةِ أَلْفٍ وَثَلَاثَةِ آلَافٍ وَخَمْسِ مِئَةٍ وَخَمْسِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","وَكَانَتْ مِئَةُ وَزْنَةٍ مِنَ ٱلْفِضَّةِ لِسَبْكِ قَوَاعِدِ ٱلْمَقْدِسِ وَقَوَاعِدِ ٱلْحِجَابِ. مِئَةُ قَاعِدَةٍ لِلْمِئَةِ وَزْنَةٍ. وَزْنَةٌ لِلْقَاعِدَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","وَٱلْأَلْفُ وَٱلسَّبْعُ مِئَةِ شَاقِلٍ وَٱلْخَمْسَةُ وَٱلسَّبْعُونَ شَاقِلًا صَنَعَ مِنْهَا رُزَزًا لِلْأَعْمِدَةِ وَغَشَّى رُؤُوسَهَا وَوَصَلَهَا بِقُضْبَانٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","وَنُحَاسُ ٱلتَّقْدِمَةِ سَبْعُونَ وَزْنَةً وَأَلْفَانِ وَأَرْبَعُ مِئَةِ شَاقِلٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","وَمِنْهُ صَنَعَ قَوَاعِدَ بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ وَمَذْبَحَ ٱلنُّحَاسِ وَشُبَّاكَةَ ٱلنُّحَاسِ ٱلَّتِي لَهُ وَجَمِيعَ آنِيَةِ ٱلْمَذْبَحِ ");
INSERT INTO arb_vd_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","وَقَوَاعِدَ ٱلدَّارِ حَوَالَيْهَا وَقَوَاعِدَ بَابِ ٱلدَّارِ وَجَمِيعَ أَوْتَادِ ٱلْمَسْكَنِ وَجَمِيعَ أَوْتَادِ ٱلدَّارِ حَوَالَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","وَمِنَ ٱلْأَسْمَانْجُونِيِّ وَٱلْأُرْجُوَانِ وَٱلْقِرْمِزِ صَنَعُوا ثِيَابًا مَنْسُوجَةً لِلْخِدْمَةِ فِي ٱلْمَقْدِسِ، وَصَنَعُوا ٱلثِّيَابَ ٱلْمُقَدَّسَةَ ٱلَّتِي لِهَارُونَ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","فَصَنَعَ ٱلرِّدَاءَ مِنْ ذَهَبٍ وَأَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","وَمَدُّوا ٱلذَّهَبَ صَفَائِحَ وَقَدُّوهَا خُيُوطًا لِيَصْنَعُوهَا فِي وَسَطِ ٱلْأَسْمَانْجُونِيِّ وَٱلْأُرْجُوَانِ وَٱلْقِرْمِزِ وَٱلْبُوصِ، صَنْعَةَ ٱلْمُوَشِّي. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","وَصَنَعُوا لَهُ كَتِفَيْنِ مَوْصُولَيْنِ. عَلَى طَرَفَيْهِ ٱتَّصَلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","وَزُنَّارُ شَدِّهِ ٱلَّذِي عَلَيْهِ كَانَ مِنْهُ كَصَنْعَتِهِ مِنْ ذَهَبٍ وَأَسْمَانْجُونِيٍّ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","وَصَنَعُوا حَجَرَيِ ٱلْجَزْعِ مُحَاطَيْنِ بِطَوْقَيْنِ مِنْ ذَهَبٍ مَنْقُوشَيْنِ نَقْشَ ٱلْخَاتِمِ عَلَى حَسَبِ أَسْمَاءِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","وَوَضَعَهُمَا عَلَى كَتِفَيِ ٱلرِّدَاءِ حَجَرَيْ تَذْكَارٍ لِبَنِي إِسْرَائِيلَ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","وَصَنَعَ ٱلصُّدْرَةَ صَنْعَةَ ٱلْمُوَشِّي كَصَنْعَةِ ٱلرِّدَاءِ مِنْ ذَهَبٍ وَأَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ وَبُوصٍ مَبْرُومٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","كَانَتْ مُرَبَّعَةً. مَثْنِيَّةً صَنَعُوا ٱلصُّدْرَةَ. طُولُهَا شِبْرٌ وَعَرْضُهَا شِبْرٌ مَثْنِيَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","وَرَصَّعُوا فِيهَا أَرْبَعَةَ صُفُوفِ حِجَارَةٍ. صَفُّ: عَقِيقٌ أَحْمَرُ وَيَاقُوتٌ أَصْفَرُ وَزُمُرُّدٌ، ٱلصَّفُّ ٱلْأَوَّلُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","وَٱلصَّفُّ ٱلثَّانِي: بَهْرَمَانُ وَيَاقُوتٌ أَزْرَقُ وَعَقِيقٌ أَبْيَضُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","وَٱلصَّفُّ ٱلثَّالِثُ: عَيْنُ ٱلْهِرِّ وَيَشْمٌ وَجَمَسْتُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","وَٱلصَّفُّ ٱلرَّابِعُ: زَبَرْجَدٌ وَجَزْعٌ وَيَشْبٌ. مُحَاطَةٌ بِأَطْوَاقٍ مِنْ ذَهَبٍ فِي تَرْصِيعِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","وَٱلْحِجَارَةُ كَانَتْ عَلَى أَسْمَاءِ بَنِي إِسْرَائِيلَ، ٱثْنَيْ عَشَرَ عَلَى أَسْمَائِهِمْ كَنَقْشِ ٱلْخَاتِمِ. كُلُّ وَاحِدٍ عَلَى ٱسْمِهِ لِلِٱثْنَيْ عَشَرَ سِبْطًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","وَصَنَعُوا عَلَى ٱلصُّدْرَةِ سَلَاسِلَ مَجْدُولَةً صَنْعَةَ ٱلضَّفْرِ مِنْ ذَهَبٍ نَقِيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","وَصَنَعُوا طَوْقَيْنِ مِنْ ذَهَبٍ وَحَلْقَتَيْنِ مِنْ ذَهَبٍ، وَجَعَلُوا ٱلْحَلْقَتَيْنِ عَلَى طَرَفَيِ ٱلصُّدْرَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","وَجَعَلُوا ضَفِيرَتَيِ ٱلذَّهَبِ فِي ٱلْحَلْقَتَيْنِ عَلَى طَرَفَيِ ٱلصُّدْرَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","وَطَرَفَا ٱلضَّفِيرَتَيْنِ جَعَلُوهُمَا فِي ٱلطَّوْقَيْنِ، وَجَعَلُوهُمَا عَلَى كَتِفَيِ ٱلرِّدَاءِ إِلَى قُدَّامِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","وَصَنَعُوا حَلْقَتَيْنِ مِنْ ذَهَبٍ وَوَضَعُوهُمَا عَلَى طَرَفَيِ ٱلصُّدْرَةِ. عَلَى حَاشِيَتِهَا ٱلَّتِي إِلَى جِهَةِ ٱلرِّدَاءِ مِنْ دَاخِلٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","وَصَنَعُوا حَلْقَتَيْنِ مِنْ ذَهَبٍ وَجَعَلُوهُمَا عَلَى كَتِفَيِ ٱلرِّدَاءِ مِنْ أَسْفَلُ مِنْ قُدَّامِهِ عِنْدَ وَصْلِهِ فَوْقَ زُنَّارِ ٱلرِّدَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","وَرَبَطُوا ٱلصُّدْرَةَ بِحَلْقَتَيْهَا إِلَى حَلْقَتَيِ ٱلرِّدَاءِ بِخَيْطٍ مِنْ أَسْمَانْجُونِيٍّ لِيَكُونَ عَلَى زُنَّارِ ٱلرِّدَاءِ، وَلَا تُنْزَعُ ٱلصُّدْرَةُ عَنِ ٱلرِّدَاءِ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","وَصَنَعَ جُبَّةَ ٱلرِّدَاءِ صَنْعَةَ ٱلنَّسَّاجِ، كُلَّهَا مِنْ أَسْمَانْجُونِيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","وَفَتْحَةُ ٱلْجُبَّةِ فِي وَسَطِهَا كَفَتْحَةِ ٱلدِّرْعِ، وَلِفَتْحَتِهَا حَاشِيَةٌ حَوَالَيْهَا. لَا تَنْشَقُّ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","وَصَنَعُوا عَلَى أَذْيَالِ ٱلْجُبَّةِ رُمَّانَاتٍ مِنْ أَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ مَبْرُومٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","وَصَنَعُوا جَلَاجِلَ مِنْ ذَهَبٍ نَقِيٍّ، وَجَعَلُوا ٱلْجَلَاجِلَ فِي وَسَطِ ٱلرُّمَّانَاتِ عَلَى أَذْيَالِ ٱلْجُبَّةِ حَوَالَيْهَا فِي وَسَطِ ٱلرُّمَّانَاتِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","جُلْجُلٌ وَرُمَّانَةٌ. جُلْجُلٌ وَرُمَّانَةٌ. عَلَى أَذْيَالِ ٱلْجُبَّةِ حَوَالَيْهَا لِلْخِدْمَةِ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","وَصَنَعُوا ٱلْأَقْمِصَةَ مِنْ بُوصٍ صَنْعَةَ ٱلنَّسَّاجِ لِهَارُونَ وَبَنِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","وَٱلْعِمَامَةَ مِنْ بُوصٍ، وَعَصَائِبَ ٱلْقَلَانِسِ مِنْ بُوصٍ، وَسَرَاوِيلَ ٱلْكَتَّانِ مِنْ بُوصٍ مَبْرُومٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","وَٱلْمِنْطَقَةَ مِنْ بُوصٍ مَبْرُومٍ وَأَسْمَانْجُونِيٍّ وَأُرْجُوَانٍ وَقِرْمِزٍ صَنْعَةَ ٱلطَّرَّازِ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","وَصَنَعُوا صَفِيحَةَ ٱلْإِكْلِيلِ ٱلْمُقَدَّسِ مِنْ ذَهَبٍ نَقِيٍّ، وَكَتَبُوا عَلَيْهَا كِتَابَةَ نَقْشِ ٱلْخَاتِمِ: «قُدْسٌ لِلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","وَجَعَلُوا عَلَيْهَا خَيْطَ أَسْمَانْجُونِيٍّ لِتُجْعَلَ عَلَى ٱلْعِمَامَةِ مِنْ فَوْقُ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","فَكَمُلَ كُلُّ عَمَلِ مَسْكَنِ خَيْمَةِ ٱلِٱجْتِمَاعِ. وَصَنَعَ بَنُو إِسْرَائِيلَ بِحَسَبِ كُلِّ مَا أَمَرَ ٱلرَّبُّ مُوسَى. هَكَذَا صَنَعُوا. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","وَجَاءُوا إِلَى مُوسَى بِٱلْمَسْكَنِ: ٱلْخَيْمَةِ وَجَمِيعِ أَوَانِيهَا، أَشِظَّتِهَا وَأَلْوَاحِهَا وَعَوَارِضِهَا وَأَعْمِدَتِهَا وَقَوَاعِدِهَا، ");
INSERT INTO arb_vd_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","وَٱلْغِطَاءِ مِنْ جُلُودِ ٱلْكِبَاشِ ٱلْمُحَمَّرَةِ، وَٱلْغِطَاءِ مِنْ جُلُودِ ٱلتُّخَسِ، وَحِجَابِ ٱلسَّجْفِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","وَتَابُوتِ ٱلشَّهَادَةِ وَعَصَوَيْهِ، وَٱلْغِطَاءِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","وَٱلْمَائِدَةِ وَكُلِّ آنِيَتِهَا، وَخُبْزِ ٱلْوُجُوهِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","وَٱلْمَنَارَةِ ٱلطَّاهِرَةِ وَسُرُجِهَا: ٱلسُّرُجِ لِلتَّرْتِيبِ، وَكُلِّ آنِيَتِهَا وَٱلزَّيْتِ لِلضَّوْءِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","وَمَذْبَحِ ٱلذَّهَبِ، وَدُهْنِ ٱلْمَسْحَةِ، وَٱلْبَخُورِ ٱلْعَطِرِ، وَٱلسَّجْفِ لِمَدْخَلِ ٱلْخَيْمَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","وَمَذْبَحِ ٱلنُّحَاسِ، وَشُبَّاكَةِ ٱلنُّحَاسِ ٱلَّتِي لَهُ وَعَصَوَيْهِ وَكُلِّ آنِيَتِهِ، وَٱلْمِرْحَضَةِ وَقَاعِدَتِهَا، ");
INSERT INTO arb_vd_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","وَأَسْتَارِ ٱلدَّارِ وَأَعْمِدَتِهَا وَقَوَاعِدِهَا، وَٱلسَّجْفِ لِبَابِ ٱلدَّارِ وَأَطْنَابِهَا وَأَوْتَادِهَا، وَجَمِيعِ أَوَانِي خِدْمَةِ ٱلْمَسْكَنِ لِخَيْمَةِ ٱلِٱجْتِمَاعِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","وَٱلثِّيَابِ ٱلْمَنْسُوجَةِ لِلْخِدْمَةِ فِي ٱلْمَقْدِسِ، وَٱلثِّيَابِ ٱلْمُقَدَّسَةِ لِهَارُونَ ٱلْكَاهِنِ وَثِيَابِ بَنِيهِ لِلْكَهَانَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","بِحَسَبِ كُلِّ مَا أَمَرَ ٱلرَّبُّ مُوسَى هَكَذَا صَنَعَ بَنُو إِسْرَائِيلَ كُلَّ ٱلْعَمَلِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","فَنَظَرَ مُوسَى جَمِيعَ ٱلْعَمَلِ، وَإِذَا هُمْ قَدْ صَنَعُوهُ كَمَا أَمَرَ ٱلرَّبُّ. هَكَذَا صَنَعُوا. فَبَارَكَهُمْ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«فِي ٱلشَّهْرِ ٱلْأَوَّلِ، فِي ٱلْيَوْمِ ٱلْأَوَّلِ مِنَ ٱلشَّهْرِ، تُقِيمُ مَسْكَنَ خَيْمَةِ ٱلِٱجْتِمَاعِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","وَتَضَعُ فِيهِ تَابُوتَ ٱلشَّهَادَةِ. وَتَسْتُرُ ٱلتَّابُوتَ بِٱلْحِجَابِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","وَتُدْخِلُ ٱلْمَائِدَةَ وَتُرَتِّبُ تَرْتِيبَهَا. وَتُدْخِلُ ٱلْمَنَارَةَ وَتُصْعِدُ سُرُجَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","وَتَجْعَلُ مَذْبَحَ ٱلذَّهَبِ لِلْبَخُورِ أَمَامَ تَابُوتِ ٱلشَّهَادَةِ. وَتَضَعُ سَجْفَ ٱلْبَابِ لِلْمَسْكَنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","وَتَجْعَلُ مَذْبَحَ ٱلْمُحْرَقَةِ قُدَّامَ بَابِ مَسْكَنِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","وَتَجْعَلُ ٱلْمِرْحَضَةَ بَيْنَ خَيْمَةِ ٱلِٱجْتِمَاعِ وَٱلْمَذْبَحِ، وَتَجْعَلُ فِيهَا مَاءً. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","وَتَضَعُ ٱلدَّارَ حَوْلَهُنَّ، وَتَجْعَلُ ٱلسَّجْفَ لِبَابِ ٱلدَّارِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","وَتَأْخُذُ دُهْنَ ٱلْمَسْحَةِ وَتَمْسَحُ ٱلْمَسْكَنَ وَكُلَّ مَا فِيهِ، وَتُقَدِّسُهُ وَكُلَّ آنِيَتِهِ لِيَكُونَ مُقَدَّسًا. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","وَتَمْسَحُ مَذْبَحَ ٱلْمُحْرَقَةِ وَكُلَّ آنِيَتِهِ، وَتُقَدِّسُ ٱلْمَذْبَحَ لِيَكُونَ ٱلْمَذْبَحُ قُدْسَ أَقْدَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","وَتَمْسَحُ ٱلْمِرْحَضَةَ وَقَاعِدَتَهَا وَتُقَدِّسُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","وَتُقَدِّمُ هَارُونَ وَبَنِيهِ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ وَتَغْسِلُهُمْ بِمَاءٍ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","وَتُلْبِسُ هَارُونَ ٱلثِّيَابَ ٱلْمُقَدَّسَةَ وَتَمْسَحُهُ وَتُقَدِّسُهُ لِيَكْهَنَ لِي. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","وَتُقَدِّمُ بَنِيهِ وَتُلْبِسُهُمْ أَقْمِصَةً. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","وَتَمْسَحُهُمْ كَمَا مَسَحْتَ أَبَاهُمْ لِيَكْهَنُوا لِي. وَيَكُونُ ذَلِكَ لِتَصِيرَ لَهُمْ مَسْحَتُهُمْ كَهَنُوتًا أَبَدِيًّا فِي أَجْيَالِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","فَفَعَلَ مُوسَى بِحَسَبِ كُلِّ مَا أَمَرَهُ ٱلرَّبُّ. هَكَذَا فَعَلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","وَكَانَ فِي ٱلشَّهْرِ ٱلْأَوَّلِ مِنَ ٱلسَّنَةِ ٱلثَّانِيَةِ فِي أَوَّلِ ٱلشَّهْرِ أَنَّ ٱلْمَسْكَنَ أُقِيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","أَقَامَ مُوسَى ٱلْمَسْكَنَ، وَجَعَلَ قَوَاعِدَهُ وَوَضَعَ أَلْوَاحَهُ وَجَعَلَ عَوَارِضَهُ وَأَقَامَ أَعْمِدَتَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","وَبَسَطَ ٱلْخَيْمَةَ فَوْقَ ٱلْمَسْكَنِ، وَوَضَعَ غِطَاءَ ٱلْخَيْمَةِ عَلَيْهَا مِنْ فَوْقُ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","وَأَخَذَ ٱلشَّهَادَةَ وَجَعَلَهَا فِي ٱلتَّابُوتِ، وَوَضَعَ ٱلْعَصَوَيْنِ عَلَى ٱلتَّابُوتِ مِنْ فَوْقُ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","وَأَدْخَلَ ٱلتَّابُوتَ إِلَى ٱلْمَسْكَنِ، وَوَضَعَ حِجَابَ ٱلسَّجْفِ وَسَتَرَ تَابُوتَ ٱلشَّهَادَةِ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","وَجَعَلَ ٱلْمَائِدَةَ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ فِي جَانِبِ ٱلْمَسْكَنِ نَحْوَ ٱلشِّمَالِ خَارِجَ ٱلْحِجَابِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","وَرَتَّبَ عَلَيْهَا تَرْتِيبَ ٱلْخُبْزِ أَمَامَ ٱلرَّبِّ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","وَوَضَعَ ٱلْمَنَارَةَ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ مُقَابِلَ ٱلْمَائِدَةِ فِي جَانِبِ ٱلْمَسْكَنِ نَحْوَ ٱلْجَنُوبِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","وَأَصْعَدَ ٱلسُّرُجَ أَمَامَ ٱلرَّبِّ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","وَوَضَعَ مَذْبَحَ ٱلذَّهَبِ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ قُدَّامَ ٱلْحِجَابِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","وَبَخَّرَ عَلَيْهِ بِبَخُورٍ عَطِرٍ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","وَوَضَعَ سَجْفَ ٱلْبَابِ لِلْمَسْكَنِ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","وَوَضَعَ مَذْبَحَ ٱلْمُحْرَقَةِ عِنْدَ بَابِ مَسْكَنِ خَيْمَةِ ٱلِٱجْتِمَاعِ، وَأَصْعَدَ عَلَيْهِ ٱلْمُحْرَقَةَ وَٱلتَّقْدِمَةَ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","وَوَضَعَ ٱلْمِرْحَضَةَ بَيْنَ خَيْمَةِ ٱلِٱجْتِمَاعِ وَٱلْمَذْبَحِ وَجَعَلَ فِيهَا مَاءً لِلِٱغْتِسَالِ، ");
INSERT INTO arb_vd_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","لِيَغْسِلَ مِنْهَا مُوسَى وَهَارُونُ وَبَنُوهُ أَيْدِيَهُمْ وَأَرْجُلَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","عِنْدَ دُخُولِهِمْ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ وَعِنْدَ ٱقْتِرَابِهِمْ إِلَى ٱلْمَذْبَحِ يَغْسِلُونَ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","وَأَقَامَ ٱلدَّارَ حَوْلَ ٱلْمَسْكَنِ وَٱلْمَذْبَحِ وَوَضَعَ سَجْفَ بَابِ ٱلدَّارِ. وَأَكْمَلَ مُوسَى ٱلْعَمَلَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ثُمَّ غَطَّتِ ٱلسَّحَابَةُ خَيْمَةَ ٱلِٱجْتِمَاعِ وَمَلَأَ بَهَاءُ ٱلرَّبِّ ٱلْمَسْكَنَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","فَلَمْ يَقْدِرْ مُوسَى أَنْ يَدْخُلَ خَيْمَةَ ٱلِٱجْتِمَاعِ، لِأَنَّ ٱلسَّحَابَةَ حَلَّتْ عَلَيْهَا وَبَهَاءُ ٱلرَّبِّ مَلَأَ ٱلْمَسْكَنَ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","وَعِنْدَ ٱرْتِفَاعِ ٱلسَّحَابَةِ عَنِ ٱلْمَسْكَنِ كَانَ بَنُو إِسْرَائِيلَ يَرْتَحِلُونَ فِي جَمِيعِ رِحْلَاتِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","وَإِنْ لَمْ تَرْتَفِعِ ٱلسَّحَابَةُ لَا يَرْتَحِلُونَ إِلَى يَوْمِ ٱرْتِفَاعِهَا، ");
INSERT INTO arb_vd_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","لِأَنَّ سَحَابَةَ ٱلرَّبِّ كَانَتْ عَلَى ٱلْمَسْكَنِ نَهَارًا. وَكَانَتْ فِيهَا نَارٌ لَيْلًا أَمَامَ عُيُونِ كُلِّ بَيْتِ إِسْرَائِيلَ فِي جَمِيعِ رِحْلَاتِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","وَدَعَا ٱلرَّبُّ مُوسَى وَكَلَّمَهُ مِنْ خَيْمَةِ ٱلِٱجْتِمَاعِ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: إِذَا قَرَّبَ إِنْسَانٌ مِنْكُمْ قُرْبَانًا لِلرَّبِّ مِنَ ٱلْبَهَائِمِ، فَمِنَ ٱلْبَقَرِ وَٱلْغَنَمِ تُقَرِّبُونَ قَرَابِينَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","إِنْ كَانَ قُرْبَانُهُ مُحْرَقَةً مِنَ ٱلْبَقَرِ، فَذَكَرًا صَحِيحًا يُقَرِّبُهُ. إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ يُقَدِّمُهُ لِلرِّضَا عَنْهُ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","وَيَضَعُ يَدَهُ عَلَى رَأْسِ ٱلْمُحْرَقَةِ، فَيُرْضَى عَلَيْهِ لِلتَّكْفِيرِ عَنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","وَيَذْبَحُ ٱلْعِجْلَ أَمَامَ ٱلرَّبِّ، وَيُقَرِّبُ بَنوُ هَارُونَ ٱلْكَهَنَةُ ٱلدَّمَ، وَيَرُشُّونَ ٱلدَّمَ مُسْتَدِيرًا عَلَى ٱلْمَذْبَحِ ٱلَّذِي لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","وَيَسْلُخُ ٱلْمُحْرَقَةَ وَيُقَطِّعُهَا إِلَى قِطَعِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","وَيَجْعَلُ بَنُو هَارُونَ ٱلْكَاهِنِ نَارًا عَلَى ٱلْمَذْبَحِ، وَيُرَتِّبُونَ حَطَبًا عَلَى ٱلنَّارِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","وَيُرَتِّبُ بَنُو هَارُونَ ٱلْكَهَنَةُ ٱلْقِطَعَ مَعَ ٱلرَّأْسِ وَٱلشَّحْمِ فَوْقَ ٱلْحَطَبِ ٱلَّذِي عَلَى ٱلنَّارِ ٱلَّتِي عَلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","وَأَمَّا أَحْشَاؤُهُ وَأَكَارِعُهُ فَيَغْسِلُهَا بِمَاءٍ، وَيُوقِدُ ٱلْكَاهِنُ ٱلْجَمِيعَ عَلَى ٱلْمَذْبَحِ مُحْرَقَةً، وَقُودَ رَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«وَإِنْ كَانَ قُرْبَانُهُ مِنَ ٱلْغَنَمِ ٱلضَّأْنِ أَوِ ٱلْمَعْزِ مُحْرَقَةً، فَذَكَرًا صَحِيحًا يُقَرِّبُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","وَيَذْبَحُهُ عَلَى جَانِبِ ٱلْمَذْبَحِ إِلَى ٱلشِّمَالِ أَمَامَ ٱلرَّبِّ، وَيَرُشُّ بَنُو هَارُونَ ٱلْكَهَنَةُ دَمَهُ عَلَى ٱلْمَذْبَحِ مُسْتَدِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","وَيُقَطِّعُهُ إِلَى قِطَعِهِ، مَعَ رَأْسِهِ وَشَحْمِهِ. وَيُرَتِّبُهُنَّ ٱلْكَاهِنُ فَوْقَ ٱلْحَطَبِ ٱلَّذِي عَلَى ٱلنَّارِ ٱلَّتِي عَلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","وَأَمَّا ٱلْأَحْشَاءُ وَٱلْأَكَارِعُ فَيَغْسِلُهَا بِمَاءٍ، وَيُقَرِّبُ ٱلْكَاهِنُ ٱلْجَمِيعَ، وَيُوقِدُ عَلَى ٱلْمَذْبَحِ. إِنَّهُ مُحْرَقَةٌ، وَقُودُ رَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«وَإِنْ كَانَ قُرْبَانُهُ لِلرَّبِّ مِنَ ٱلطَّيْرِ مُحْرَقَةً، يُقَرِّبُ قُرْبَانَهُ مِنَ ٱلْيَمَامِ أَوْ مِنْ أَفْرَاخِ ٱلْحَمَامِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","يُقَدِّمُهُ ٱلْكَاهِنُ إِلَى ٱلْمَذْبَحِ، وَيَحُزُّ رَأْسَهُ، وَيُوقِدُ عَلَى ٱلْمَذْبَحِ، وَيُعْصَرُ دَمُهُ عَلَى حَائِطِ ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","وَيَنْزِعُ حَوْصَلَتَهُ بِفَرْثِهَا وَيَطْرَحُهَا إِلَى جَانِبِ ٱلْمَذْبَحِ شَرْقًا إِلَى مَكَانِ ٱلرَّمَادِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","وَيَشُقُّهُ بَيْنَ جَنَاحَيْهِ. لَا يَفْصِلُهُ. وَيُوقِدُهُ ٱلْكَاهِنُ عَلَى ٱلْمَذْبَحِ فَوْقَ ٱلْحَطَبِ ٱلَّذِي عَلَى ٱلنَّارِ. إِنَّهُ مُحْرَقَةٌ، وَقُودُ رَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«وَإِذَا قَرَّبَ أَحَدٌ قُرْبَانَ تَقْدِمَةٍ لِلرَّبِّ، يَكُونُ قُرْبَانُهُ مِنْ دَقِيقٍ. وَيَسْكُبُ عَلَيْهَا زَيْتًا، وَيَجْعَلُ عَلَيْهَا لُبَانًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","وَيَأْتِي بِهَا إِلَى بَنِي هَارُونَ ٱلْكَهَنَةِ، وَيَقْبِضُ مِنْهَا مِلْءَ قَبْضَتِهِ مِنْ دَقِيقِهَا وَزَيْتِهَا مَعَ كُلِّ لُبَانِهَا، وَيُوقِدُ ٱلْكَاهِنُ تَذْكَارَهَا عَلَى ٱلْمَذْبَحِ، وَقُودَ رَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","وَٱلْبَاقِي مِنَ ٱلتَّقْدِمَةِ هُوَ لِهَارُونَ وَبَنِيهِ، قُدْسُ أَقْدَاسٍ مِنْ وَقَائِدِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«وَإِذَا قَرَّبْتَ قُرْبَانَ تَقْدِمَةٍ مَخْبُوزَةٍ فِي تَنُّورٍ، تَكُونُ أَقْرَاصًا مِنْ دَقِيقٍ، فَطِيرًا مَلْتُوتَةً بِزَيْتٍ، وَرِقَاقًا فَطِيرًا مَدْهُونَةً بِزَيْتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","وَإِنْ كَانَ قُرْبَانُكَ تَقْدِمَةً عَلَى ٱلصَّاجِ، تَكُونُ مِنْ دَقِيقٍ مَلْتُوتَةً بِزَيْتٍ، فَطِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","تَفُتُّهَا فُتَاتًا وَتَسْكُبُ عَلَيْهَا زَيْتًا. إِنَّهَا تَقْدِمَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","«وَإِنْ كَانَ قُرْبَانُكَ تَقْدِمَةً مِنْ طَاجِنٍ، فَمِنْ دَقِيقٍ بِزَيْتٍ تَعْمَلُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","فَتَأْتِي بِٱلتَّقْدِمَةِ ٱلَّتِي تُصْطَنَعُ مِنْ هَذِهِ إِلَى ٱلرَّبِّ وَتُقَدِّمُهَا إِلَى ٱلْكَاهِنِ، فَيَدْنُو بِهَا إِلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","وَيَأْخُذُ ٱلْكَاهِنُ مِنَ ٱلتَّقْدِمَةِ تَذْكَارَهَا وَيُوقِدُ عَلَى ٱلْمَذْبَحِ وَقُودَ رَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","وَٱلْبَاقِي مِنَ ٱلتَّقْدِمَةِ هُوَ لِهَارُونَ وَبَنِيهِ، قُدْسُ أَقْدَاسٍ مِنْ وَقَائِدِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«كُلُّ ٱلتَّقْدِمَاتِ ٱلَّتِي تُقَرِّبُونَهَا لِلرَّبِّ لَا تُصْطَنَعُ خَمِيرًا، لِأَنَّ كُلَّ خَمِيرٍ، وَكُلَّ عَسَلٍ لَا تُوقِدُوا مِنْهُمَا وَقُودًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","قُرْبَانَ أَوَائِلَ تُقَرِّبُونَهُمَا لِلرَّبِّ. لَكِنْ عَلَى ٱلْمَذْبَحِ لَا يَصْعَدَانِ لِرَائِحَةِ سَرُورٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","وَكُلُّ قُرْبَانٍ مِنْ تَقْدِمَاتِكَ بِٱلْمِلْحِ تُمَلِّحُهُ، وَلَا تُخْلِ تَقْدِمَتَكَ مِنْ مِلْحِ عَهْدِ إِلَهِكَ. عَلَى جَمِيعِ قَرَابِينِكَ تُقَرِّبُ مِلْحًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«وَإِنْ قَرَّبْتَ تَقْدِمَةَ بَاكُورَاتٍ لِلرَّبِّ، فَفَرِيكًا مَشْوِيًّا بِٱلنَّارِ. جَرِيشًا سَوِيقًا تُقَرِّبُ تَقْدِمَةَ بَاكُورَاتِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","وَتَجْعَلُ عَلَيْهَا زَيْتًا وَتَضَعُ عَلَيْهَا لُبَانًا. إِنَّهَا تَقْدِمَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","فَيُوقِدُ ٱلْكَاهِنُ تَذْكَارَهَا مِنْ جَرِيشِهَا وَزَيْتِهَا مَعَ جَمِيعِ لُبَانِهَا وَقُودًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«وَإِنْ كَانَ قُرْبَانُهُ ذَبِيحَةَ سَلَامَةٍ، فَإِنْ قَرَّبَ مِنَ ٱلْبَقَرِ ذَكَرًا أَوْ أُنْثَى، فَصَحِيحًا يُقَرِّبُهُ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","يَضَعُ يَدَهُ عَلَى رَأْسِ قُرْبَانِهِ وَيَذْبَحُهُ لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ، وَيَرُشُّ بَنُو هَارُونَ ٱلْكَهَنَةُ ٱلدَّمَ عَلَى ٱلْمَذْبَحِ مُسْتَدِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","وَيُقَرِّبُ مِنْ ذَبِيحَةِ ٱلسَّلَامَةِ وَقُودًا لِلرَّبِّ: ٱلشَّحْمَ ٱلَّذِي يُغَشِّي ٱلْأَحْشَاءَ، وَسَائِرَ ٱلشَّحْمِ ٱلَّذِي عَلَى ٱلْأَحْشَاءِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","وَٱلْكُلْيَتَيْنِ، وَٱلشَّحْمَ ٱلَّذِي عَلَيْهِمَا ٱلَّذِي عَلَى ٱلْخَاصِرَتَيْنِ، وَزِيَادَةَ ٱلْكَبِدِ مَعَ ٱلْكُلْيَتَيْنِ يَنْزِعُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","وَيُوقِدُهَا بَنُو هَارُونَ عَلَى ٱلْمَذْبَحِ عَلَى ٱلْمُحْرَقَةِ ٱلَّتِي فَوْقَ ٱلْحَطَبِ ٱلَّذِي عَلَى ٱلنَّارِ، وَقُودَ رَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«وَإِنْ كَانَ قُرْبَانُهُ مِنَ ٱلْغَنَمِ ذَبِيحَةَ سَلَامَةٍ لِلرَّبِّ ذَكَرًا أَوْ أُنْثَى، فَصَحِيحًا يُقَرِّبُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","إِنْ قَرَّبَ قُرْبَانَهُ مِنَ ٱلضَّأْنِ يُقَدِّمُهُ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","يَضَعُ يَدَهُ عَلَى رَأْسِ قُرْبَانِهِ وَيَذْبَحُهُ قُدَّامَ خَيْمَةِ ٱلِٱجْتِمَاعِ. وَيَرُشُّ بَنُو هَارُونَ دَمَهُ عَلَى ٱلْمَذْبَحِ مُسْتَدِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","وَيُقَرِّبُ مِنْ ذَبِيحَةِ ٱلسَّلَامَةِ شَحْمَهَا وَقُودًا لِلرَّبِّ: ٱلْأَلْيَةَ صَحِيحَةً مِنْ عِنْدِ ٱلْعُصْعُصِ يَنْزِعُهَا، وَٱلشَّحْمَ ٱلَّذِي يُغَشِّي ٱلْأَحْشَاءَ، وَسَائِرَ ٱلشَّحْمِ ٱلَّذِي عَلَى ٱلْأَحْشَاءِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","وَٱلْكُلْيَتَيْنِ، وَٱلشَّحْمَ ٱلَّذِي عَلَيْهِمَا ٱلَّذِي عَلَى ٱلْخَاصِرَتَيْنِ، وَزِيَادَةَ ٱلْكَبِدِ مَعَ ٱلْكُلْيَتَيْنِ يَنْزِعُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","وَيُوقِدُهَا ٱلْكَاهِنُ عَلَى ٱلْمَذْبَحِ طَعَامَ وَقُودٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«وَإِنْ كَانَ قُرْبَانُهُ مِنَ ٱلْمَعْزِ يُقَدِّمُهُ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","يَضَعُ يَدَهُ عَلَى رَأْسِهِ وَيَذْبَحُهُ قُدَّامَ خَيْمَةِ ٱلِٱجْتِمَاعِ، وَيَرُشُّ بَنُو هَارُونَ دَمَهُ عَلَى ٱلْمَذْبَحِ مُسْتَدِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","وَيُقَرِّبُ مِنْهُ قُرْبَانَهُ وَقُودًا لِلرَّبِّ: ٱلشَّحْمَ ٱلَّذِي يُغَشِّي ٱلْأَحْشَاءَ، وَسَائِرَ ٱلشَّحْمِ ٱلَّذِي عَلَى ٱلْأَحْشَاءِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","وَٱلْكُلْيَتَيْنِ وَٱلشَّحْمَ ٱلَّذِي عَلَيْهِمَا ٱلَّذِي عَلَى ٱلْخَاصِرَتَيْنِ، وَزِيَادَةَ ٱلْكَبِدِ مَعَ ٱلْكُلْيَتَيْنِ يَنْزِعُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","وَيُوقِدُهُنَّ ٱلْكَاهِنُ عَلَى ٱلْمَذْبَحِ طَعَامَ وَقُودٍ لِرَائِحَةِ سَرُورٍ. كُلُّ ٱلشَّحْمِ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","فَرِيضَةً دَهْرِيَّةً فِي أَجْيَالِكُمْ فِي جَمِيعِ مَسَاكِنِكُمْ: لَا تَأْكُلُوا شَيْئًا مِنَ ٱلشَّحْمِ وَلَا مِنَ ٱلدَّمِ». ");
INSERT INTO arb_vd_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ قَائِلًا: إِذَا أَخْطَأَتْ نَفْسٌ سَهْوًا فِي شَيْءٍ مِنْ جَمِيعِ مَنَاهِي ٱلرَّبِّ ٱلَّتِي لَا يَنْبَغِي عَمَلُهَا، وَعَمِلَتْ وَاحِدَةً مِنْهَا: ");
INSERT INTO arb_vd_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","إِنْ كَانَ ٱلْكَاهِنُ ٱلْمَمْسُوحُ يُخْطِئُ لِإِثْمِ ٱلشَّعْبِ، يُقَرِّبُ عَنْ خَطِيَّتِهِ ٱلَّتِي أَخْطَأَ ثَوْرًا ٱبْنَ بَقَرٍ صَحِيحًا لِلرَّبِّ، ذَبِيحَةَ خَطِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","يُقَدِّمُ ٱلثَّوْرَ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ أَمَامَ ٱلرَّبِّ، وَيَضَعُ يَدَهُ عَلَى رَأْسِ ٱلثَّوْرِ، وَيَذْبَحُ ٱلثَّوْرَ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","وَيَأْخُذُ ٱلْكَاهِنُ ٱلْمَمْسُوحُ مِنْ دَمِ ٱلثَّوْرِ وَيَدْخُلُ بِهِ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","وَيَغْمِسُ ٱلْكَاهِنُ إِصْبَعَهُ فِي ٱلدَّمِ وَيَنْضِحُ مِنَ ٱلدَّمِ سَبْعَ مَرَّاتٍ أَمَامَ ٱلرَّبِّ لَدَى حِجَابِ ٱلْقُدْسِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","وَيَجْعَلُ ٱلْكَاهِنُ مِنَ ٱلدَّمِ عَلَى قُرُونِ مَذْبَحِ ٱلْبَخُورِ ٱلْعَطِرِ ٱلَّذِي فِي خَيْمَةِ ٱلِٱجْتِمَاعِ أَمَامَ ٱلرَّبِّ، وَسَائِرُ دَمِ ٱلثَّوْرِ يَصُبُّهُ إِلَى أَسْفَلِ مَذْبَحِ ٱلْمُحْرَقَةِ ٱلَّذِي لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","وَجَمِيعُ شَحْمِ ثَوْرِ ٱلْخَطِيَّةِ يَنْزِعُهُ عَنْهُ. ٱلشَّحْمَ ٱلَّذِي يُغَشِّي ٱلْأَحْشَاءَ، وَسَائِرَ ٱلشَّحْمِ ٱلَّذِي عَلَى ٱلْأَحْشَاءِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","وَٱلْكُلْيَتَيْنِ وَٱلشَّحْمَ ٱلَّذِي عَلَيْهِمَا ٱلَّذِي عَلَى ٱلْخَاصِرَتَيْنِ، وَزِيَادَةَ ٱلْكَبِدِ مَعَ ٱلْكُلْيَتَيْنِ يَنْزِعُهَا، ");
INSERT INTO arb_vd_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","كَمَا تُنْزَعُ مِنْ ثَوْرِ ذَبِيحَةِ ٱلسَّلَامَةِ. وَيُوقِدُهُنَّ ٱلْكَاهِنُ عَلَى مَذْبَحِ ٱلْمُحْرَقَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","وَأَمَّا جِلْدُ ٱلثَّوْرِ وَكُلُّ لَحْمِهِ مَعَ رَأْسِهِ وَأَكَارِعِهِ وَأَحْشَائِهِ وَفَرْثِهِ ");
INSERT INTO arb_vd_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","فَيُخْرِجُ سَائِرَ ٱلثَّوْرِ إِلَى خَارِجِ ٱلْمَحَلَّةِ إِلَى مَكَانٍ طَاهِرٍ، إِلَى مَرْمَى ٱلرَّمَادِ، وَيُحْرِقُهَا عَلَى حَطَبٍ بِٱلنَّارِ. عَلَى مَرْمَى ٱلرَّمَادِ تُحْرَقُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«وَإِنْ سَهَا كُلُّ جَمَاعَةِ إِسْرَائِيلَ، وَأُخْفِيَ أَمْرٌ عَنْ أَعْيُنِ ٱلْمَجْمَعِ، وَعَمِلُوا وَاحِدَةً مِنْ جَمِيعِ مَنَاهِي ٱلرَّبِّ ٱلَّتِي لَا يَنْبَغِي عَمَلُهَا، وَأَثِمُوا، ");
INSERT INTO arb_vd_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ثُمَّ عُرِفَتِ ٱلْخَطِيَّةُ ٱلَّتِي أَخْطَأُوا بِهَا، يُقَرِّبُ ٱلْمَجْمَعُ ثَوْرًا ٱبْنَ بَقَرٍ ذَبِيحَةَ خَطِيَّةٍ. يَأْتُونَ بِهِ إِلَى قُدَّامِ خَيْمَةِ ٱلِٱجْتِمَاعِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","وَيَضَعُ شُيُوخُ ٱلْجَمَاعَةِ أَيْدِيَهُمْ عَلَى رَأْسِ ٱلثَّوْرِ أَمَامَ ٱلرَّبِّ، وَيَذْبَحُ ٱلثَّوْرَ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","وَيُدْخِلُ ٱلْكَاهِنُ ٱلْمَمْسُوحُ مِنْ دَمِ ٱلثَّوْرِ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","وَيَغْمِسُ ٱلْكَاهِنُ إِصْبَعَهُ فِي ٱلدَّمِ، وَيَنْضِحُ سَبْعَ مَرَّاتٍ أَمَامَ ٱلرَّبِّ لَدَى ٱلْحِجَابِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","وَيَجْعَلُ مِنَ ٱلدَّمِ عَلَى قُرُونِ ٱلْمَذْبَحِ ٱلَّذِي أَمَامَ ٱلرَّبِّ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ، وَسَائِرَ ٱلدَّمِ يَصُبُّهُ إِلَى أَسْفَلِ مَذْبَحِ ٱلْمُحْرَقَةِ ٱلَّذِي لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","وَجَمِيعَ شَحْمِهِ يَنْزِعُهُ عَنْهُ وَيُوقِدُهُ عَلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","وَيَفْعَلُ بِٱلثَّوْرِ كَمَا فَعَلَ بِثَوْرِ ٱلْخَطِيَّةِ. كَذَلِكَ يَفْعَلُ بِهِ. وَيُكَفِّرُ عَنْهُمُ ٱلْكَاهِنُ، فَيُصْفَحُ عَنْهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ثُمَّ يُخْرِجُ ٱلثَّوْرَ إِلَى خَارِجِ ٱلْمَحَلَّةِ وَيُحْرِقُهُ كَمَا أَحْرَقَ ٱلثَّوْرَ ٱلْأَوَّلَ. إِنَّهُ ذَبِيحَةُ خَطِيَّةِ ٱلْمَجْمَعِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«إِذَا أَخْطَأَ رَئِيسٌ وَعَمِلَ بِسَهْوٍ وَاحِدَةً مِنْ جَمِيعِ مَنَاهِي ٱلرَّبِّ إِلَهِهِ ٱلَّتِي لَا يَنْبَغِي عَمَلُهَا، وَأَثِمَ، ");
INSERT INTO arb_vd_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ثُمَّ أُعْلِمَ بِخَطِيَّتِهِ ٱلَّتِي أَخْطَأَ بِهَا، يَأْتِي بِقُرْبَانِهِ تَيْسًا مِنَ ٱلْمَعْزِ ذَكَرًا صَحِيحًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","وَيَضَعُ يَدَهُ عَلَى رَأْسِ ٱلتَّيْسِ وَيَذْبَحُهُ فِي ٱلْمَوْضِعِ ٱلَّذِي يَذْبَحُ فِيهِ ٱلْمُحْرَقَةَ أَمَامَ ٱلرَّبِّ. إِنَّهُ ذَبِيحَةُ خَطِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","وَيَأْخُذُ ٱلْكَاهِنُ مِنْ دَمِ ذَبِيحَةِ ٱلْخَطِيَّةِ بِإِصْبَعِهِ وَيَجْعَلُ عَلَى قُرُونِ مَذْبَحِ ٱلْمُحْرَقَةِ، ثُمَّ يَصُبُّ دَمَهُ إِلَى أَسْفَلِ مَذْبَحِ ٱلْمُحْرَقَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","وَجَمِيعَ شَحْمِهِ يُوقِدُهُ عَلَى ٱلْمَذْبَحِ كَشَحْمِ ذَبِيحَةِ ٱلسَّلَامَةِ، وَيُكَفِّرُ ٱلْكَاهِنُ عَنْهُ مِنْ خَطِيَّتِهِ فَيُصْفَحُ عَنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«وَإِنْ أَخْطَأَ أَحَدٌ مِنْ عَامَّةِ ٱلْأَرْضِ سَهْوًا، بِعَمَلِهِ وَاحِدَةً مِنْ مَنَاهِي ٱلرَّبِّ ٱلَّتِي لَا يَنْبَغِي عَمَلُهَا، وَأَثِمَ، ");
INSERT INTO arb_vd_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ثُمَّ أُعْلِمَ بِخَطِيَّتِهِ ٱلَّتِي أَخْطَأَ بِهَا، يَأْتِي بِقُرْبَانِهِ عَنْزًا مِنَ ٱلْمَعْزِ أُنْثَى صَحِيحَةً عَنْ خَطِيَّتِهِ ٱلَّتِي أَخْطَأَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","وَيَضَعُ يَدَهُ عَلَى رَأْسِ ذَبِيحَةِ ٱلْخَطِيَّةِ، وَيَذْبَحُ ذَبِيحَةَ ٱلْخَطِيَّةِ فِي مَوْضِعِ ٱلْمُحْرَقَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","وَيَأْخُذُ ٱلْكَاهِنُ مِنْ دَمِهَا بِإِصْبَعِهِ وَيَجْعَلُ عَلَى قُرُونِ مَذْبَحِ ٱلْمُحْرَقَةِ، وَيَصُبُّ سَائِرَ دَمِهَا إِلَى أَسْفَلِ ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","وَجَمِيعَ شَحْمِهَا يَنْزِعُهُ كَمَا نُزِعَ ٱلشَّحْمُ عَنْ ذَبِيحَةِ ٱلسَّلَامَةِ، وَيُوقِدُ ٱلْكَاهِنُ عَلَى ٱلْمَذْبَحِ رَائِحَةَ سَرُورٍ لِلرَّبِّ وَيُكَفِّرُ عَنْهُ ٱلْكَاهِنُ فَيُصْفَحُ عَنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«وَإِنْ أَتَى بِقُرْبَانِهِ مِنَ ٱلضَّأْنِ ذَبِيحَةَ خَطِيَّةٍ، يَأْتِي بِهَا أُنْثَى صَحِيحَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","وَيَضَعُ يَدَهُ عَلَى رَأْسِ ذَبِيحَةِ ٱلْخَطِيَّةِ، وَيَذْبَحُهَا ذَبِيحَةَ خَطِيَّةٍ فِي ٱلْمَوْضِعِ ٱلَّذِي يَذْبَحُ فِيهِ ٱلْمُحْرَقَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","وَيَأْخُذُ ٱلْكَاهِنُ مِنْ دَمِ ذَبِيحَةِ ٱلْخَطِيَّةِ بِإِصْبَعِهِ وَيَجْعَلُ عَلَى قُرُونِ مَذْبَحِ ٱلْمُحْرَقَةِ، وَيَصُبُّ سَائِرَ ٱلدَّمِ إِلَى أَسْفَلِ ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","وَجَمِيعَ شَحْمِهِ يَنْزِعُهُ كَمَا يُنْزَعُ شَحْمُ ٱلضَّأْنِ عَنْ ذَبِيحَةِ ٱلسَّلَامَةِ، وَيُوقِدُهُ ٱلْكَاهِنُ عَلَى ٱلْمَذْبَحِ عَلَى وَقَائِدِ ٱلرَّبِّ. وَيُكَفِّرُ عَنْهُ ٱلْكَاهِنُ مِنْ خَطِيَّتِهِ ٱلَّتِي أَخْطَأَ فَيُصْفَحُ عَنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«وَإِذَا أَخْطَأَ أَحَدٌ وَسَمِعَ صَوْتَ حَلْفٍ وَهُوَ شَاهِدٌ يُبْصِرُ أَوْ يَعْرِفُ، فَإِنْ لَمْ يُخْبِرْ بِهِ حَمَلَ ذَنْبَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","أَوْ إِذَا مَسَّ أَحَدٌ شَيْئًا نَجِسًا: جُثَّةَ وَحْشٍ نَجِسٍ، أَوْ جُثَّةَ بَهِيمَةٍ نَجِسَةٍ، أَوْ جُثَّةَ دَبِيبٍ نَجِسٍ، وَأُخْفِيَ عَنْهُ، فَهُوَ نَجِسٌ وَمُذْنِبٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","أَوْ إِذَا مَسَّ نَجَاسَةَ إِنْسَانٍ مِنْ جَمِيعِ نَجَاسَاتِهِ ٱلَّتِي يَتَنَجَّسُ بِهَا، وَأُخْفِيَ عَنْهُ ثُمَّ عُلِمَ، فَهُوَ مُذْنِبٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","أَوْ إِذَا حَلَفَ أَحَدٌ مُفْتَرِطًا بِشَفَتَيْهِ لِلْإِسَاءَةِ أَوْ لِلْإِحْسَانِ مِنْ جَمِيعِ مَا يَفْتَرِطُ بِهِ ٱلْإِنْسَانُ فِي ٱلْيَمِينِ، وَأُخْفِيَ عَنْهُ، ثُمَّ عُلِمَ، فَهُوَ مُذْنِبٌ فِي شَيْءٍ مِنْ ذَلِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","فَإِنْ كَانَ يُذْنِبُ فِي شَيْءٍ مِنْ هَذِهِ، يُقِرُّ بِمَا قَدْ أَخْطَأَ بِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","وَيَأْتِي إِلَى ٱلرَّبِّ بِذَبِيحَةٍ لِإِثْمِهِ عَنْ خَطِيَّتِهِ ٱلَّتِي أَخْطَأَ بِهَا: أُنْثَى مِنَ ٱلْأَغْنَامِ نَعْجَةً أَوْ عَنْزًا مِنَ ٱلْمَعْزِ، ذَبِيحَةَ خَطِيَّةٍ، فَيُكَفِّرُ عَنْهُ ٱلْكَاهِنُ مِنْ خَطِيَّتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","وَإِنْ لَمْ تَنَلْ يَدُهُ كِفَايَةً لِشَاةٍ، فَيَأْتِي بِذَبِيحَةٍ لِإِثْمِهِ ٱلَّذِي أَخْطَأَ بِهِ: يَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ إِلَى ٱلرَّبِّ، أَحَدُهُمَا ذَبِيحَةُ خَطِيَّةٍ وَٱلْآخَرُ مُحْرَقَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","يَأْتِي بِهِمَا إِلَى ٱلْكَاهِنِ، فَيُقَرِّبُ ٱلَّذِي لِلْخَطِيَّةِ أَوَّلًا. يَحُزُّ رَأْسَهُ مِنْ قَفَاهُ وَلَا يَفْصِلُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","وَيَنْضِحُ مِنْ دَمِ ذَبِيحَةِ ٱلْخَطِيَّةِ عَلَى حَائِطِ ٱلْمَذْبَحِ، وَٱلْبَاقِي مِنَ ٱلدَّمِ يُعْصَرُ إِلَى أَسْفَلِ ٱلْمَذْبَحِ. إِنَّهُ ذَبِيحَةُ خَطِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","وَأَمَّا ٱلثَّانِي فَيَعْمَلُهُ مُحْرَقَةً كَٱلْعَادَةِ، فَيُكَفِّرُ عَنْهُ ٱلْكَاهِنُ مِنْ خَطِيَّتِهِ ٱلَّتِي أَخْطَأَ، فَيُصْفَحُ عَنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","وَإِنْ لَمْ تَنَلْ يَدُهُ يَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ فَيَأْتِي بِقُرْبَانِهِ عَمَّا أَخْطَأَ بِهِ عُشْرَ ٱلْإِيفَةِ مِنْ دَقِيقٍ، قُرْبَانَ خَطِيَّةٍ. لَا يَضَعُ عَلَيْهِ زَيْتًا، وَلَا يَجْعَلُ عَلَيْهِ لُبَانًا لِأَنَّهُ قُرْبَانُ خَطِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","يَأْتِي بِهِ إِلَى ٱلْكَاهِنِ فَيَقْبِضُ ٱلْكَاهِنُ مِنْهُ مِلْءَ قَبْضَتِهِ تَذْكَارَهُ، وَيُوقِدُهُ عَلَى ٱلْمَذْبَحِ عَلَى وَقَائِدِ ٱلرَّبِّ. إِنَّهُ قُرْبَانُ خَطِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","فَيُكَفِّرُ عَنْهُ ٱلْكَاهِنُ مِنْ خَطِيَّتِهِ ٱلَّتِي أَخْطَأَ بِهَا فِي وَاحِدَةٍ مِنْ ذَلِكَ، فَيُصْفَحُ عَنْهُ. وَيَكُونُ لِلْكَاهِنِ كَٱلتَّقْدِمَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«إِذَا خَانَ أَحَدٌ خِيَانَةً وَأَخْطَأَ سَهْوًا فِي أَقْدَاسِ ٱلرَّبِّ، يَأْتِي إِلَى ٱلرَّبِّ بِذَبِيحَةٍ لِإِثْمِهِ: كَبْشًا صَحِيحًا مِنَ ٱلْغَنَمِ بِتَقْوِيمِكَ مِنْ شَوَاقِلِ فِضَّةٍ عَلَى شَاقِلِ ٱلْقُدْسِ، ذَبِيحَةَ إِثْمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","وَيُعَوِّضُ عَمَّا أَخْطَأَ بِهِ مِنَ ٱلْقُدْسِ، وَيَزِيدُ عَلَيْهِ خُمْسَهُ، وَيَدْفَعُهُ إِلَى ٱلْكَاهِنِ، فَيُكَفِّرُ ٱلْكَاهِنُ عَنْهُ بِكَبْشِ ٱلْإِثْمِ، فَيُصْفَحُ عَنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«وَإِذَا أَخْطَأَ أَحَدٌ وَعَمِلَ وَاحِدَةً مِنْ جَمِيعِ مَنَاهِي ٱلرَّبِّ ٱلَّتِي لَا يَنْبَغِي عَمَلُهَا، وَلَمْ يَعْلَمْ، كَانَ مُذْنِبًا وَحَمَلَ ذَنْبَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","فَيَأْتِي بِكَبْشٍ صَحِيحٍ مِنَ ٱلْغَنَمِ بِتَقْوِيمِكَ، ذَبِيحَةَ إِثْمٍ، إِلَى ٱلْكَاهِنِ، فَيُكَفِّرُ عَنْهُ ٱلْكَاهِنُ مِنْ سَهْوِهِ ٱلَّذِي سَهَا وَهُوَ لَا يَعْلَمُ، فَيُصْفَحُ عَنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","إِنَّهُ ذَبِيحَةُ إِثْمٍ. قَدْ أَثِمَ إِثْمًا إِلَى ٱلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«إِذَا أَخْطَأَ أَحَدٌ وَخَانَ خِيَانَةً بِٱلرَّبِّ، وَجَحَدَ صَاحِبَهُ وَدِيعَةً أَوْ أَمَانَةً أَوْ مَسْلُوبًا، أَوِ ٱغْتَصَبَ مِنْ صَاحِبِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","أَوْ وَجَدَ لُقَطَةً وَجَحَدَهَا، وَحَلَفَ كَاذِبًا عَلَى شَيْءٍ مِنْ كُلِّ مَا يَفْعَلُهُ ٱلْإِنْسَانُ مُخْطِئًا بِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","فَإِذَا أَخْطَأَ وَأَذْنَبَ، يَرُدُّ ٱلْمَسْلُوبَ ٱلَّذِي سَلَبَهُ، أَوِ ٱلْمُغْتَصَبَ ٱلَّذِي ٱغْتَصَبَهُ، أَوِ ٱلْوَدِيعَةَ ٱلَّتِي أُودِعَتْ عِنْدَهُ، أَوِ ٱللُّقَطَةَ ٱلَّتِي وَجَدَهَا، ");
INSERT INTO arb_vd_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","أَوْ كُلَّ مَا حَلَفَ عَلَيْهِ كَاذِبًا. يُعَوِّضُهُ بِرَأْسِهِ، وَيَزِيدُ عَلَيْهِ خُمْسَهُ. إِلَى ٱلَّذِي هُوَ لَهُ يَدْفَعُهُ يَوْمَ ذَبِيحَةِ إِثْمِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","وَيَأْتِي إِلَى ٱلرَّبِّ بِذَبِيحَةٍ لِإِثْمِهِ: كَبْشًا صَحِيحًا مِنَ ٱلْغَنَمِ بِتَقْوِيمِكَ، ذَبِيحَةَ إِثْمٍ إِلَى ٱلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","فَيُكَفِّرُ عَنْهُ ٱلْكَاهِنُ أَمَامَ ٱلرَّبِّ، فَيُصْفَحُ عَنْهُ فِي ٱلشَّيْءِ مِنْ كُلِّ مَا فَعَلَهُ مُذْنِبًا بِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«أَوْصِ هَارُونَ وَبَنِيهِ قَائِلًا: هَذِهِ شَرِيعَةُ ٱلْمُحْرَقَةِ: هِيَ ٱلْمُحْرَقَةُ تَكُونُ عَلَى ٱلْمَوْقِدَةِ فَوْقَ ٱلْمَذْبَحِ كُلَّ ٱللَّيْلِ حَتَّى ٱلصَّبَاحِ، وَنَارُ ٱلْمَذْبَحِ تَتَّقِدُ عَلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ثُمَّ يَلْبَسُ ٱلْكَاهِنُ ثَوْبَهُ مِنْ كَتَّانٍ، وَيَلْبَسُ سَرَاوِيلَ مِنْ كَتَّانٍ عَلَى جَسَدِهِ، وَيَرْفَعُ ٱلرَّمَادَ ٱلَّذِي صَيَّرَتِ ٱلنَّارُ ٱلْمُحْرَقَةَ إِيَّاهُ عَلَى ٱلْمَذْبَحِ، وَيَضَعُهُ بِجَانِبِ ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ثُمَّ يَخْلَعُ ثِيَابَهُ وَيَلْبَسُ ثِيَابًا أُخْرَى، وَيُخْرِجُ ٱلرَّمَادَ إِلَى خَارِجِ ٱلْمَحَلَّةِ، إِلَى مَكَانٍ طَاهِرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","وَٱلنَّارُ عَلَى ٱلْمَذْبَحِ تَتَّقِدُ عَلَيْهِ. لَا تَطْفَأُ. وَيُشْعِلُ عَلَيْهَا ٱلْكَاهِنُ حَطَبًا كُلَّ صَبَاحٍ، وَيُرَتِّبُ عَلَيْهَا ٱلْمُحْرَقَةَ، وَيُوقِدُ عَلَيْهَا شَحْمَ ذَبَائِحِ ٱلسَّلَامَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","نَارٌ دَائِمَةٌ تَتَّقِدُ عَلَى ٱلْمَذْبَحِ. لَا تَطْفَأُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","«وَهَذِهِ شَرِيعَةُ ٱلتَّقْدِمَةِ: يُقَدِّمُهَا بَنُو هَارُونَ أَمَامَ ٱلرَّبِّ إِلَى قُدَّامِ ٱلْمَذْبَحِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","وَيَأْخُذُ مِنْهَا بِقَبْضَتِهِ بَعْضَ دَقِيقِ ٱلتَّقْدِمَةِ وَزَيْتِهَا وَكُلَّ ٱللُّبَانِ ٱلَّذِي عَلَى ٱلتَّقْدِمَةِ، وَيُوقِدُ عَلَى ٱلْمَذْبَحِ رَائِحَةَ سَرُورٍ تَذْكَارَهَا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","وَٱلْبَاقِي مِنْهَا يَأْكُلُهُ هَارُونُ وَبَنُوهُ. فَطِيرًا يُؤْكَلُ فِي مَكَانٍ مُقَدَّسٍ. فِي دَارِ خَيْمَةِ ٱلِٱجْتِمَاعِ يَأْكُلُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","لَا يُخْبَزُ خَمِيرًا. قَدْ جَعَلْتُهُ نَصِيبَهُمْ مِنْ وَقَائِدِي. إِنَّهَا قُدْسُ أَقْدَاسٍ كَذَبِيحَةِ ٱلْخَطِيَّةِ وَذَبِيحَةِ ٱلْإِثْمِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","كُلُّ ذَكَرٍ مِنْ بَنِي هَارُونَ يَأْكُلُ مِنْهَا. فَرِيضَةً دَهْرِيَّةً فِي أَجْيَالِكُمْ مِنْ وَقَائِدِ ٱلرَّبِّ. كُلُّ مَنْ مَسَّهَا يَتَقَدَّسُ». ");
INSERT INTO arb_vd_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","وكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«هَذَا قُرْبَانُ هَارُونَ وَبَنِيهِ ٱلَّذِي يُقَرِّبُونَهُ لِلرَّبِّ يَوْمَ مَسْحَتِهِ: عُشْرُ ٱلْإِيفَةِ مِنْ دَقِيقٍ تَقْدِمَةً دَائِمَةً، نِصْفُهَا صَبَاحًا، وَنِصْفُهَا مَسَاءً. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","عَلَى صَاجٍ تُعْمَلُ بِزَيْتٍ، مَرْبُوكَةً تَأْتِي بِهَا. ثَرَائِدَ تَقْدِمَةٍ، فُتَاتًا تُقَرِّبُهَا رَائِحَةَ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","وَٱلْكَاهِنُ ٱلْمَمْسُوحُ عِوَضًا عَنْهُ مِنْ بَنِيهِ يَعْمَلُهَا فَرِيضَةً دَهْرِيَّةً لِلرَّبِّ. تُوقَدُ بِكَمَالِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","وَكُلُّ تَقْدِمَةِ كَاهِنٍ تُحْرَقُ بِكَمَالِهَا. لَا تُؤْكَلُ». ");
INSERT INTO arb_vd_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«كَلِّمْ هَارُونَ وَبَنِيهِ قَائِلًا: هَذِهِ شَرِيعَةُ ذَبِيحَةِ ٱلْخَطِيَّةِ: فِي ٱلْمَكَانِ ٱلَّذِي تُذْبَحُ فِيهِ ٱلْمُحْرَقَةُ، تُذْبَحُ ذَبِيحَةُ ٱلْخَطِيَّةِ أَمَامَ ٱلرَّبِّ. إِنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ٱلْكَاهِنُ ٱلَّذِي يَعْمَلُهَا لِلْخَطِيَّةِ يَأْكُلُهَا. فِي مَكَانٍ مُقَدَّسٍ تُؤْكَلُ فِي دَارِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","كُلُّ مَنْ مَسَّ لَحْمَهَا يَتَقَدَّسُ. وَإِذَا ٱنْتَثَرَ مِنْ دَمِهَا عَلَى ثَوْبٍ تَغْسِلُ مَا ٱنْتَثَرَ عَلَيْهِ فِي مَكَانٍ مُقَدَّسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","وَأَمَّا إِنَاءُ ٱلْخَزَفِ ٱلَّذِي تُطْبَخُ فِيهِ فَيُكْسَرُ. وَإِنْ طُبِخَتْ فِي إِنَاءِ نُحَاسٍ، يُجْلَى وَيُشْطَفُ بِمَاءٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","كُلُّ ذَكَرٍ مِنَ ٱلْكَهَنَةِ يَأْكُلُ مِنْهَا. إِنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","وَكُلُّ ذَبِيحَةِ خَطِيَّةٍ يُدْخَلُ مِنْ دَمِهَا إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ لِلتَّكْفِيرِ فِي ٱلْقُدْسِ، لَا تُؤْكَلُ. تُحْرَقُ بِنَارٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«وَهَذِهِ شَرِيعَةُ ذَبِيحَةِ ٱلْإِثْمِ: إِنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","فِي ٱلْمَكَانِ ٱلَّذِي يَذْبَحُونَ فِيهِ ٱلْمُحْرَقَةَ، يَذْبَحُونَ ذَبِيحَةَ ٱلْإِثْمِ، وَيَرُشُّ دَمَهَا عَلَى ٱلْمَذْبَحِ مُسْتَدِيرًا، ");
INSERT INTO arb_vd_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","وَيُقَرِّبُ مِنْهَا كُلَّ شَحْمِهَا: ٱلْأَلْيَةَ، وَٱلشَّحْمَ ٱلَّذِي يُغَشِّي ٱلْأَحْشَاءَ، ");
INSERT INTO arb_vd_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","وَٱلْكُلْيَتَيْنِ وَٱلشَّحْمَ ٱلَّذِي عَلَيْهِمَا، ٱلَّذِي عَلَى ٱلْخَاصِرَتَيْنِ، وَزِيَادَةَ ٱلْكَبِدِ مَعَ ٱلْكُلْيَتَيْنِ يَنْزِعُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","وَيُوقِدُهُنَّ ٱلْكَاهِنُ عَلَى ٱلْمَذْبَحِ وَقُودًا لِلرَّبِّ. إِنَّهَا ذَبِيحَةُ إِثْمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","كُلُّ ذَكَرٍ مِنَ ٱلْكَهَنَةِ يَأْكُلُ مِنْهَا. فِي مَكَانٍ مُقَدَّسٍ تُؤْكَلُ. إِنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","ذَبِيحَةُ ٱلْإِثْمِ كَذَبِيحَةِ ٱلْخَطِيَّةِ، لَهُمَا شَرِيعَةٌ وَاحِدَةٌ. الْكَاهِنُ ٱلَّذِي يُكَفِّرُ بِهَا تَكُونُ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","وَٱلْكَاهِنُ ٱلَّذِي يُقَرِّبُ مُحْرَقَةَ إِنْسَانٍ فَجِلْدُ ٱلْمُحْرَقَةِ ٱلَّتِي يُقَرِّبُهَا يَكُونُ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","وَكُلُّ تَقْدِمَةٍ خُبِزَتْ فِي ٱلتَّنُّورِ، وَكُلُّ مَا عُمِلَ فِي طَاجِنٍ أَوْ عَلَى صَاجٍ يَكُونُ لِلْكَاهِنِ ٱلَّذِي يُقَرِّبُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","وَكُلُّ تَقْدِمَةٍ مَلْتُوتَةٍ بِزَيْتٍ أَوْ نَاشِفَةٍ تَكُونُ لِجَمِيعِ بَنِي هَارُونَ، كُلِّ إِنْسَانٍ كَأَخِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«وَهَذِهِ شَرِيعَةُ ذَبِيحَةِ ٱلسَّلَامَةِ. ٱلَّذِي يُقَرِّبُهَا لِلرَّبِّ: ");
INSERT INTO arb_vd_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","إِنْ قَرَّبَهَا لِأَجْلِ ٱلشُّكْرِ، يُقَرِّبُ عَلَى ذَبِيحَةِ ٱلشُّكْرِ أَقْرَاصَ فَطِيرٍ مَلْتُوتَةً بِزَيْتٍ، وَرِقَاقَ فَطِيرٍ مَدْهُونَةً بِزَيْتٍ، وَدَقِيقًا مَرْبُوكًا أَقْرَاصًا مَلْتُوتَةً بِزَيْتٍ، ");
INSERT INTO arb_vd_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","مَعَ أَقْرَاصِ خُبْزٍ خَمِيرٍ يُقَرِّبُ قُرْبَانَهُ عَلَى ذَبِيحَةِ شُكْرِ سَلَامَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","وَيُقَرِّبُ مِنْهُ وَاحِدًا مِنْ كُلِّ قُرْبَانٍ رَفِيعَةً لِلرَّبِّ، يَكُونُ لِلْكَاهِنِ ٱلَّذِي يَرُشُّ دَمَ ذَبِيحَةِ ٱلسَّلَامَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","وَلَحْمُ ذَبِيحَةِ شُكْرِ سَلَامَتِهِ يُؤْكَلُ يَوْمَ قُرْبَانِهِ. لَا يُبْقِي مِنْهُ شَيْئًا إِلَى ٱلصَّبَاحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","وَإِنْ كَانَتْ ذَبِيحَةُ قُرْبَانِهِ نَذْرًا أَوْ نَافِلَةً، فَفِي يَوْمِ تَقْرِيبِهِ ذَبِيحَتَهُ تُؤْكَلُ. وَفِي ٱلْغَدِ يُؤْكَلُ مَا فَضَلَ مِنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","وَأَمَّا ٱلْفَاضِلُ مِنْ لَحْمِ ٱلذَّبِيحَةِ فِي ٱلْيَوْمِ ٱلثَّالِثِ فَيُحْرَقُ بِٱلنَّارِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","وَإِنْ أُكِلَ مِنْ لَحْمِ ذَبِيحَةِ سَلَامَتِهِ فِي ٱلْيَوْمِ ٱلثَّالِثِ لَا تُقْبَلُ. ٱلَّذِي يُقَرِّبُهَا لَا تُحْسَبُ لَهُ، تَكُونُ نَجَاسَةً، وَٱلنَّفْسُ ٱلَّتِي تَأْكُلُ مِنْهَا تَحْمِلُ ذَنْبَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","وَٱللَّحْمُ ٱلَّذِي مَسَّ شَيْئًا مَا نَجِسًا لَا يُؤْكَلُ. يُحْرَقُ بِٱلنَّارِ. وَٱللَّحْمُ يَأْكُلُ كُلُّ طَاهِرٍ مِنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","وَأَمَّا ٱلنَّفْسُ ٱلَّتِي تَأْكُلُ لَحْمًا مِنْ ذَبِيحَةِ ٱلسَّلَامَةِ ٱلَّتِي لِلرَّبِّ وَنَجَاسَتُهَا عَلَيْهَا فَتُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ شَعْبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","وَٱلنَّفْسُ ٱلَّتِي تَمَسُّ شَيْئًا مَّا نَجِسًا نَجَاسَةَ إِنْسَانٍ أَوْ بَهِيمَةً نَجِسَةً أَوْ مَكْرُوهًا مَّا نَجِسًا، ثُمَّ تَأْكُلُ مِنْ لَحْمِ ذَبِيحَةِ ٱلسَّلَامَةِ ٱلَّتِي لِلرَّبِّ، تُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ شَعْبِهَا». ");
INSERT INTO arb_vd_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«كَلِّمْ بَنِي إِسْرَائِيلَ قَائِلًا: كُلَّ شَحْمِ ثَوْرٍ أَوْ كَبْشٍ أَوْ مَاعِزٍ لَا تَأْكُلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","وَأَمَّا شَحْمُ ٱلْمَيْتَةِ وَشَحْمُ ٱلْمُفْتَرَسَةِ فَيُسْتَعْمَلُ لِكُلِّ عَمَلٍ، لَكِنْ أَكْلًا لَا تَأْكُلُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","إِنَّ كُلَّ مَنْ أَكَلَ شَحْمًا مِنَ ٱلْبَهَائِمِ ٱلَّتِي يُقَرِّبُ مِنْهَا وَقُودًا لِلرَّبِّ تُقْطَعُ مِنْ شَعْبِهَا، ٱلنَّفْسُ ٱلَّتِي تَأْكُلُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","وَكُلَّ دَمٍ لَا تَأْكُلُوا فِي جَمِيعِ مَسَاكِنِكُمْ مِنَ ٱلطَّيْرِ وَمِنَ ٱلْبَهَائِمِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","كُلُّ نَفْسٍ تَأْكُلُ شَيْئًا مِنَ ٱلدَّمِ تُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ شَعْبِهَا». ");
INSERT INTO arb_vd_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«كَلِّمْ بَنِي إِسْرَائِيلَ قَائِلًا: ٱلَّذِي يُقَرِّبُ ذَبِيحَةَ سَلَامَتِهِ لِلرَّبِّ، يَأْتِي بِقُرْبَانِهِ إِلَى ٱلرَّبِّ مِنْ ذَبِيحَةِ سَلَامَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","يَدَاهُ تَأْتِيَانِ بِوَقَائِدِ ٱلرَّبِّ. ٱلشَّحْمُ يَأْتِي بِهِ مَعَ ٱلصَّدْرِ. أَمَّا ٱلصَّدْرُ فَلِكَيْ يُرَدِّدَهُ تَرْدِيدًا أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","فَيُوقِدُ ٱلْكَاهِنُ ٱلشَّحْمَ عَلَى ٱلْمَذْبَحِ، وَيَكُونُ ٱلصَّدْرُ لِهَارُونَ وَبَنِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","وَٱلسَّاقُ ٱلْيُمْنَى تُعْطُونَهَا رَفِيعَةً لِلْكَاهِنِ مِنْ ذَبَائِحِ سَلَامَتِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","اَلَّذِي يُقَرِّبُ دَمَ ذَبِيحَةِ ٱلسَّلَامَةِ وَٱلشَّحْمَ مِنْ بَنِي هَارُونَ، تَكُونُ لَهُ ٱلسَّاقُ ٱلْيُمْنَى نَصِيبًا، ");
INSERT INTO arb_vd_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","لِأَنَّ صَدْرَ ٱلتَّرْدِيدِ وَسَاقَ ٱلرَّفِيعَةِ قَدْ أَخَذْتُهُمَا مِنْ بَنِي إِسْرَائِيلَ مِنْ ذَبَائِحِ سَلَامَتِهِمْ وَأَعْطَيْتُهُمَا لِهَارُونَ ٱلْكَاهِنِ وَلِبَنِيهِ فَرِيضَةً دَهْرِيَّةً مِنْ بَنِي إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","تِلْكَ مَسْحَةُ هَارُونَ وَمَسْحَةُ بَنِيهِ مِنْ وَقَائِدِ ٱلرَّبِّ يَوْمَ تَقْدِيمِهِمْ لِيَكْهَنُوا لِلرَّبِّ، ");
INSERT INTO arb_vd_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ٱلَّتِي أَمَرَ ٱلرَّبُّ أَنْ تُعْطَى لَهُمْ يَوْمَ مَسْحِهِ إِيَّاهُمْ مِنْ بَنِي إِسْرَائِيلَ، فَرِيضَةً دَهْرِيَّةً فِي أَجْيَالِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","تِلْكَ شَرِيعَةُ ٱلْمُحْرَقَةِ، وَٱلتَّقْدِمَةِ، وَذَبِيحَةِ ٱلْخَطِيَّةِ، وَذَبِيحَةِ ٱلْإِثْمِ، وَذَبِيحَةِ ٱلْمِلْءِ، وَذَبِيحَةِ ٱلسَّلَامَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ٱلَّتِي أَمَرَ ٱلرَّبُّ بِهَا مُوسَى فِي جَبَلِ سِينَاءَ، يَوْمَ أَمْرِهِ بَنِي إِسْرَائِيلَ بِتَقْرِيبِ قَرَابِينِهِمْ لِلرَّبِّ فِي بَرِّيَّةِ سِينَاءَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«خُذْ هَارُونَ وَبَنِيهِ مَعَهُ، وَٱلثِّيَابَ وَدُهْنَ ٱلْمَسْحَةِ وَثَوْرَ ٱلْخَطِيَّةِ وَٱلْكَبْشَيْنِ وَسَلَّ ٱلْفَطِيرِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","وَٱجْمَعْ كُلَّ ٱلْجَمَاعَةِ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ». ");
INSERT INTO arb_vd_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","فَفَعَلَ مُوسَى كَمَا أَمَرَهُ ٱلرَّبُّ. فَٱجْتَمَعَتِ ٱلْجَمَاعَةُ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ثُمَّ قَالَ مُوسَى لِلْجَمَاعَةِ: «هَذَا مَا أَمَرَ ٱلرَّبُّ أَنْ يُفْعَلَ». ");
INSERT INTO arb_vd_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","فَقَدَّمَ مُوسَى هَارُونَ وَبَنِيهِ وَغَسَّلَهُمْ بِمَاءٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","وَجَعَلَ عَلَيْهِ ٱلْقَمِيصَ وَنَطَّقَهُ بِٱلْمِنْطَقَةِ وَأَلْبَسَهُ ٱلْجُبَّةَ وَجَعَلَ عَلَيْهِ ٱلرِّدَاءَ، وَنَطَّقَهُ بِزُنَّارِ ٱلرِّدَاءِ وَشَدَّهُ بِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","وَوَضَعَ عَلَيْهِ ٱلصُّدْرَةَ وَجَعَلَ فِي ٱلصُّدْرَةِ ٱلْأُورِيمَ وَٱلتُّمِّيمَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","وَوَضَعَ ٱلْعِمَامَةَ عَلَى رَأْسِهِ، وَوَضَعَ عَلَى ٱلْعِمَامَةِ إِلَى جِهَةِ وَجْهِهِ صَفِيحَةَ ٱلذَّهَبِ، ٱلْإِكْلِيلَ ٱلْمُقَدَّسَ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ثُمَّ أَخَذَ مُوسَى دُهْنَ ٱلْمَسْحَةِ وَمَسَحَ ٱلْمَسْكَنَ وَكُلَّ مَا فِيهِ وَقَدَّسَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","وَنَضَحَ مِنْهُ عَلَى ٱلْمَذْبَحِ سَبْعَ مَرَّاتٍ، وَمَسَحَ ٱلْمَذْبَحَ وَجَمِيعَ آنِيَتِهِ، وَٱلْمِرْحَضَةَ وَقَاعِدَتَهَا لِتَقْدِيسِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","وَصَبَّ مِنْ دُهْنِ ٱلْمَسْحَةِ عَلَى رَأْسِ هَارُونَ وَمَسَحَهُ لِتَقْدِيسِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ثُمَّ قَدَّمَ مُوسَى بَنِي هَارُونَ وَأَلْبَسَهُمْ أَقْمِصَةً وَنَطَّقَهُمْ بِمَنَاطِقَ وَشَدَّ لَهُمْ قَلَانِسَ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ثُمَّ قَدَّمَ ثَوْرَ ٱلْخَطِيَّةِ، وَوَضَعَ هَارُونُ وَبَنُوهُ أَيْدِيَهُمْ عَلَى رَأْسِ ثَوْرِ ٱلْخَطِيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","فَذَبَحَهُ، وَأَخَذَ مُوسَى ٱلدَّمَ وَجَعَلَهُ عَلَى قُرُونِ ٱلْمَذْبَحِ مُسْتَدِيرًا بِإِصْبَعِهِ، وَطَهَّرَ ٱلْمَذْبَحَ. ثُمَّ صَبَّ ٱلدَّمَ إِلَى أَسْفَلِ ٱلْمَذْبَحِ وَقَدَّسَهُ تَكْفِيرًا عَنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","وَأَخَذَ كُلَّ ٱلشَّحْمِ ٱلَّذِي عَلَى ٱلْأَحْشَاءِ وَزِيَادَةَ ٱلْكَبِدِ وَٱلْكُلْيَتَيْنِ وَشَحْمَهُمَا، وَأَوْقَدَهُ مُوسَى عَلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","وَأَمَّا ٱلثَّوْرُ: جِلْدُهُ وَلَحْمُهُ وَفَرْثُهُ، فَأَحْرَقَهُ بِنَارٍ خَارِجَ ٱلْمَحَلَّةِ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ثُمَّ قَدَّمَ كَبْشَ ٱلْمُحْرَقَةِ، فَوَضَعَ هَارُونُ وَبَنُوهُ أَيْدِيَهُمْ عَلَى رَأْسِ ٱلْكَبْشِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","فَذَبَحَهُ، وَرَشَّ مُوسَى ٱلدَّمَ عَلَى ٱلْمَذْبَحِ مُسْتَدِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","وَقَطَّعَ ٱلْكَبْشَ إِلَى قِطَعِهِ. وَأَوْقَدَ مُوسَى ٱلرَّأْسَ وَٱلْقِطَعَ وَٱلشَّحْمَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","وَأَمَّا ٱلْأَحْشَاءُ وَٱلْأَكَارِعُ فَغَسَلَهَا بِمَاءٍ، وَأَوْقَدَ مُوسَى كُلَّ ٱلْكَبْشِ عَلَى ٱلْمَذْبَحِ. إِنَّهُ مُحْرَقَةٌ لِرَائِحَةِ سَرُورٍ. وَقُودٌ هُوَ لِلرَّبِّ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ثُمَّ قَدَّمَ ٱلْكَبْشَ ٱلثَّانِي، كَبْشَ ٱلْمَلْءِ، فَوَضَعَ هَارُونُ وَبَنُوهُ أَيْدِيَهُمْ عَلَى رَأْسِ ٱلْكَبْشِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","فَذَبَحَهُ، وَأَخَذَ مُوسَى مِنْ دَمِهِ وَجَعَلَ عَلَى شَحْمَةِ أُذُنِ هَارُونَ ٱلْيُمْنَى، وَعَلَى إِبْهَامِ يَدِهِ ٱلْيُمْنَى، وَعَلَى إِبْهَامِ رِجْلِهِ ٱلْيُمْنَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ثُمَّ قَدَّمَ مُوسَى بَنِي هَارُونَ وَجَعَلَ مِنَ ٱلدَّمِ عَلَى شَحْمِ آذَانِهِمِ ٱلْيُمْنَى، وَعَلَى أَبَاهِمِ أَيْدِيهِمِ ٱلْيُمْنَى، وَعَلَى أَبَاهِمِ أَرْجُلِهِمِ ٱلْيُمْنَى، ثُمَّ رَشَّ مُوسَى ٱلدَّمَ عَلَى ٱلْمَذْبَحِ مُسْتَدِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ثُمَّ أَخَذَ ٱلشَّحْمَ: ٱلْأَلْيَةَ وَكُلَّ ٱلشَّحْمِ ٱلَّذِي عَلَى ٱلْأَحْشَاءِ، وَزِيَادَةَ ٱلْكَبِدِ وَٱلْكُلْيَتَيْنِ وَشَحْمَهُمَا، وَٱلسَّاقَ ٱلْيُمْنَى، ");
INSERT INTO arb_vd_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","وَمِنْ سَلِّ ٱلْفَطِيرِ ٱلَّذِي أَمَامَ ٱلرَّبِّ، أَخَذَ قُرْصًا وَاحِدًا فَطِيرًا، وَقُرْصًا وَاحِدًا مِنَ ٱلْخُبْزِ بِزَيْتٍ، وَرُقَاقَةً وَاحِدَةً، وَوَضَعَهَا عَلَى ٱلشَّحْمِ وَعَلَى ٱلسَّاقِ ٱلْيُمْنَى، ");
INSERT INTO arb_vd_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","وَجَعَلَ ٱلْجَمِيعَ عَلَى كَفَّيْ هَارُونَ وَكُفُوفِ بَنِيهِ، وَرَدَّدَهَا تَرْدِيدًا أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ثُمَّ أَخَذَهَا مُوسَى عَنْ كُفُوفِهِمْ، وَأَوْقَدَهَا عَلَى ٱلْمَذْبَحِ فَوْقَ ٱلْمُحْرَقَةِ. إِنَّهَا قُرْبَانُ مَلْءٍ لِرَائِحَةِ سَرُورٍ. وَقُودٌ هِيَ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ثُمَّ أَخَذَ مُوسَى ٱلصَّدْرَ وَرَدَّدَهُ تَرْدِيدًا أَمَامَ ٱلرَّبِّ مِنْ كَبْشِ ٱلْمَلْءِ. لِمُوسَى كَانَ نَصِيبًا، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ثُمَّ أَخَذَ مُوسَى مِنْ دُهْنِ ٱلْمَسْحَةِ وَمِنَ ٱلدَّمِ ٱلَّذِي عَلَى ٱلْمَذْبَحِ، وَنَضَحَ عَلَى هَارُونَ وَعَلَى ثِيَابِهِ، وَعَلَى بَنِيهِ وَعَلَى ثِيَابِ بَنِيهِ مَعَهُ. وَقَدَّسَ هَارُونَ وَثِيَابَهُ وَبَنِيهِ وَثِيَابَ بَنِيهِ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ثُمَّ قَالَ مُوسَى لِهَارُونَ وَبَنِيهِ: «ٱطْبُخُوا ٱللَّحْمَ لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ، وَهُنَاكَ تَأْكُلُونَهُ وَٱلْخُبْزَ ٱلَّذِي فِي سَلِّ قُرْبَانِ ٱلْمَلْءِ، كَمَا أَمَرْتُ قَائِلًا: هَارُونُ وَبَنُوهُ يَأْكُلُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","وَٱلْبَاقِي مِنَ ٱللَّحْمِ وَٱلْخُبْزِ تُحْرِقُونَهُ بِٱلنَّارِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","وَمِنْ لَدُنْ بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ، لَا تَخْرُجُونَ سَبْعَةَ أَيَّامٍ إِلَى يَوْمِ كَمَالِ أَيَّامِ مَلْئِكُمْ، لِأَنَّهُ سَبْعَةَ أَيَّامٍ يَمْلَأُ أَيْدِيَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","كَمَا فَعَلَ فِي هَذَا ٱلْيَوْمِ، قَدْ أَمَرَ ٱلرَّبُّ أَنْ يُفْعَلَ لِلتَّكْفِيرِ عَنْكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","وَلَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ تُقِيمُونَ نَهَارًا وَلَيْلًا سَبْعَةَ أَيَّامٍ، وَتَحْفَظُونَ شَعَائِرَ ٱلرَّبِّ فَلَا تَمُوتُونَ، لِأَنِّي هَكَذَا أُمِرْتُ». ");
INSERT INTO arb_vd_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","فَعَمِلَ هَارُونُ وَبَنُوهُ كُلَّ مَا أَمَرَ بِهِ ٱلرَّبُّ عَلَى يَدِ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","وَفِي ٱلْيَوْمِ ٱلثَّامِنِ دَعَا مُوسَى هَارُونَ وَبَنِيهِ وَشُيُوخَ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","وَقَالَ لِهَارُونَ: «خُذْ لَكَ عِجْلًا ٱبْنَ بَقَرٍ لِذَبِيحَةِ خَطِيَّةٍ، وَكَبْشًا لِمُحْرَقَةٍ صَحِيحَيْنِ، وَقَدِّمْهُمَا أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","وَكَلِّمْ بَنِي إِسْرَائِيلَ قَائِلًا: خُذُوا تَيْسًا مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، وَعِجْلًا وَخَرُوفًا حَوْلِيَّيْنِ صَحِيحَيْنِ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","وَثَوْرًا وَكَبْشًا لِذَبِيحَةِ سَلَامَةٍ لِلذَّبْحِ أَمَامَ ٱلرَّبِّ، وَتَقْدِمَةً مَلْتُوتَةً بِزَيْتٍ. لِأَنَّ ٱلرَّبَّ ٱلْيَوْمَ يَتَرَاءَى لَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","فَأَخَذُوا مَا أَمَرَ بِهِ مُوسَى إِلَى قُدَّامِ خَيْمَةِ ٱلِٱجْتِمَاعِ. وَتَقَدَّمَ كُلُّ ٱلْجَمَاعَةِ وَوَقَفُوا أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","فَقَالَ مُوسَى: «هَذَا مَا أَمَرَ بِهِ ٱلرَّبُّ. تَعْمَلُونَهُ فَيَتَرَاءَى لَكُمْ مَجْدُ ٱلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ثُمَّ قَالَ مُوسَى لِهَارُونَ: «تَقَدَّمْ إِلَى ٱلْمَذْبَحِ وَٱعْمَلْ ذَبِيحَةَ خَطِيَّتِكَ وَمُحْرَقَتَكَ، وَكَفِّرْ عَنْ نَفْسِكَ وَعَنِ ٱلشَّعْبِ. وَٱعْمَلْ قُرْبَانَ ٱلشَّعْبِ وَكَفِّرْ عَنْهُمْ كَمَا أَمَرَ ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","فَتَقَدَّمَ هَارُونُ إِلَى ٱلْمَذْبَحِ وَذَبَحَ عِجْلَ ٱلْخَطِيَّةِ ٱلَّذِي لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","وَقَدَّمَ بَنُو هَارُونَ إِلَيْهِ ٱلدَّمَ، فَغَمَسَ إِصْبَعَهُ فِي ٱلدَّمِ وَجَعَلَ عَلَى قُرُونِ ٱلْمَذْبَحِ، ثُمَّ صَبَّ ٱلدَّمَ إِلَى أَسْفَلِ ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","وَٱلشَّحْمَ وَٱلْكُلْيَتَيْنِ وَزِيَادَةَ ٱلْكَبِدِ مِنْ ذَبِيحَةِ ٱلْخَطِيَّةِ أَوْقَدَهَا عَلَى ٱلْمَذْبَحِ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","وَأَمَّا ٱللَّحْمُ وَٱلْجِلْدُ فَأَحْرَقَهُمَا بِنَارٍ خَارِجَ ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ثُمَّ ذَبَحَ ٱلْمُحْرَقَةَ، فَنَاوَلَهُ بَنُو هَارُونَ ٱلدَّمَ، فَرَشَّهُ عَلَى ٱلْمَذْبَحِ مُسْتَدِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ثُمَّ نَاوَلُوهُ ٱلْمُحْرَقَةَ بِقِطَعِهَا وَٱلرَّأْسَ، فَأَوْقَدَهَا عَلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","وَغَسَّلَ ٱلْأَحْشَاءَ وَٱلْأَكَارِعَ وَأَوْقَدَهَا فَوْقَ ٱلْمُحْرَقَةِ عَلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ثُمَّ قَدَّمَ قُرْبَانَ ٱلشَّعْبِ، وَأَخَذَ تَيْسَ ٱلْخَطِيَّةِ ٱلَّذِي لِلشَّعْبِ وَذَبَحَهُ وَعَمِلَهُ لِلْخَطِيَّةِ كَٱلْأَوَّلِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ثُمَّ قَدَّمَ ٱلْمُحْرَقَةَ وَعَمِلَهَا كَٱلْعَادَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ثُمَّ قَدَّمَ ٱلتَّقْدِمَةَ وَمَلَأَ كَفَّهُ مِنْهَا، وَأَوْقَدَهَا عَلَى ٱلْمَذْبَحِ، عَدَا مُحْرَقَةِ ٱلصَّبَاحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ثُمَّ ذَبَحَ ٱلثَّوْرَ وَٱلْكَبْشَ ذَبِيحَةَ ٱلسَّلَامَةِ ٱلَّتِي لِلشَّعْبِ. وَنَاوَلَهُ بَنُو هَارُونَ ٱلدَّمَ فَرَشَّهُ عَلَى ٱلْمَذْبَحِ مُسْتَدِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","وَٱلشَّحْمَ مِنَ ٱلثَّوْرِ وَمِنَ ٱلْكَبْشِ: ٱلْأَلْيَةَ وَمَا يُغَشِّي، وَٱلْكُلْيَتَيْنِ وَزِيَادَةَ ٱلْكَبِدِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","وَوَضَعُوا ٱلشَّحْمَ عَلَى ٱلصَّدْرَيْنِ، فَأَوْقَدَ ٱلشَّحْمَ عَلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","وَأَمَّا ٱلصَّدْرَانِ وَٱلسَّاقُ ٱلْيُمْنَى فَرَدَّدَهَا هَارُونُ تَرْدِيدًا أَمَامَ ٱلرَّبِّ، كَمَا أَمَرَ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ثُمَّ رَفَعَ هَارُونُ يَدَهُ نَحْوَ ٱلشَّعْبِ وَبَارَكَهُمْ، وَٱنْحَدَرَ مِنْ عَمَلِ ذَبِيحَةِ ٱلْخَطِيَّةِ وَٱلْمُحْرَقَةِ وَذَبِيحَةِ ٱلسَّلَامَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","وَدَخَلَ مُوسَى وَهَارُونُ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ، ثُمَّ خَرَجَا وَبَارَكَا ٱلشَّعْبَ، فَتَرَاءَى مَجْدُ ٱلرَّبِّ لِكُلِّ ٱلشَّعْبِ ");
INSERT INTO arb_vd_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","وَخَرَجَتْ نَارٌ مِنْ عِنْدِ ٱلرَّبِّ وَأَحْرَقَتْ عَلَى ٱلْمَذْبَحِ ٱلْمُحْرَقَةَ وَٱلشَّحْمَ. فَرَأَى جَمِيعُ ٱلشَّعْبِ وَهَتَفُوا وَسَقَطُوا عَلَى وُجُوهِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","وَأَخَذَ ٱبْنَا هَارُونَ: نَادَابُ وَأَبِيهُو، كُلٌّ مِنْهُمَا مِجْمَرَتَهُ وَجَعَلَا فِيهِمَا نَارًا وَوَضَعَا عَلَيْهَا بَخُورًا، وَقَرَّبَا أَمَامَ ٱلرَّبِّ نَارًا غَرِيبَةً لَمْ يَأْمُرْهُمَا بِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","فَخَرَجَتْ نَارٌ مِنْ عِنْدِ ٱلرَّبِّ وَأَكَلَتْهُمَا، فَمَاتَا أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","فَقَالَ مُوسَى لِهَارُونَ: «هَذَا مَا تَكَلَّمَ بِهِ ٱلرَّبُّ قَائِلًا: فِي ٱلْقَرِيبِينَ مِنِّي أَتَقَدَّسُ، وَأَمَامَ جَمِيعِ ٱلشَّعْبِ أَتَمَجَّدُ». فَصَمَتَ هَارُونُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","فَدَعَا مُوسَى مِيشَائِيلَ وَأَلْصَافَانَ ٱبْنَيْ عُزِّيئِيلَ عَمِّ هَارُونَ، وَقَالَ لَهُمَا: «تَقَدَّمَا ٱرْفَعَا أَخَوَيْكُمَا مِنْ قُدَّامِ ٱلْقُدْسِ إِلَى خَارِجِ ٱلْمَحَلَّةِ». ");
INSERT INTO arb_vd_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","فَتَقَدَّمَا وَرَفَعَاهُمَا فِي قَمِيصَيْهِمَا إِلَى خَارِجِ ٱلْمَحَلَّةِ، كَمَا قَالَ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","وَقَالَ مُوسَى لِهَارُونَ وَأَلِعَازَارَ وَإِيثَامَارَ ٱبْنَيْهِ: «لَا تَكْشِفُوا رُؤُوسَكُمْ وَلَا تَشُقُّوا ثِيَابَكُمْ لِئَلَّا تَمُوتُوا، وَيُسْخَطَ عَلَى كُلِّ ٱلْجَمَاعَةِ. وَأَمَّا إِخْوَتُكُمْ كُلُّ بَيْتِ إِسْرَائِيلَ فَيَبْكُونَ عَلَى ٱلْحَرِيقِ ٱلَّذِي أَحْرَقَهُ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","وَمِنْ بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ لَا تَخْرُجُوا لِئَلَّا تَمُوتُوا، لِأَنَّ دُهْنَ مَسْحَةِ ٱلرَّبِّ عَلَيْكُمْ». فَفَعَلُوا حَسَبَ كَلَامِ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","وَكَلَّمَ ٱلرَّبُّ هَارُونَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«خَمْرًا وَمُسْكِرًا لَا تَشْرَبْ أَنْتَ وَبَنُوكَ مَعَكَ عِنْدَ دُخُولِكُمْ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ لِكَيْ لَا تَمُوتُوا. فَرْضًا دَهْرِيًّا فِي أَجْيَالِكُمْ ");
INSERT INTO arb_vd_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","وَلِلتَّمْيِيزِ بَيْنَ ٱلْمُقَدَّسِ وَٱلْمُحَلَّلِ وَبَيْنَ ٱلنَّجِسِ وَٱلطَّاهِرِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","وَلِتَعْلِيمِ بَنِي إِسْرَائِيلَ جَمِيعَ ٱلْفَرَائِضِ ٱلَّتِي كَلَّمَهُمُ ٱلرَّبُّ بِهَا بِيَدِ مُوسَى». ");
INSERT INTO arb_vd_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","وَقَالَ مُوسَى لِهَارُونَ وَأَلِعَازَارَ وَإِيثَامَارَ ٱبْنَيْهِ ٱلْبَاقِيَيْنِ: «خُذُوا ٱلتَّقْدِمَةَ ٱلْبَاقِيَةَ مِنْ وَقَائِدِ ٱلرَّبِّ وَكُلُوهَا فَطِيرًا بِجَانِبِ ٱلْمَذْبَحِ لِأَنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","كُلُوهَا فِي مَكَانٍ مُقَدَّسٍ لِأَنَّهَا فَرِيضَتُكَ وَفَرِيضَةُ بَنِيكَ مِنْ وَقَائِدِ ٱلرَّبِّ، فَإِنَّنِي هَكَذَا أُمِرْتُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","وَأَمَّا صَدْرُ ٱلتَّرْدِيدِ وَسَاقُ ٱلرَّفِيعَةِ فَتَأْكُلُونَهُمَا فِي مَكَانٍ طَاهِرٍ أَنْتَ وَبَنُوكَ وَبَنَاتُكَ مَعَكَ، لِأَنَّهُمَا جُعِلَا فَرِيضَتَكَ وَفَرِيضَةَ بَنِيكَ مِنْ ذَبَائِحِ سَلَامَةِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","سَاقُ ٱلرَّفِيعَةِ وَصَدْرُ ٱلتَّرْدِيدِ يَأْتُونَ بِهِمَا مَعَ وَقَائِدِ ٱلشَّحْمِ لِيُرَدَّدَا تَرْدِيدًا أَمَامَ ٱلرَّبِّ، فَيَكُونَانِ لَكَ وَلِبَنِيكَ مَعَكَ فَرِيضَةً دَهْرِيَّةً، كَمَا أَمَرَ ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","وَأَمَّا تَيْسُ ٱلْخَطِيَّةِ فَإِنَّ مُوسَى طَلَبَهُ فَإِذَا هُوَ قَدِ ٱحْتَرَقَ. فَسَخِطَ عَلَى أَلِعَازَارَ وَإِيثَامَارَ، ٱبْنَيْ هَارُونَ ٱلْبَاقِيَيْنِ، وَقَالَ: ");
INSERT INTO arb_vd_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«مَا لَكُمَا لَمْ تَأْكُلَا ذَبِيحَةَ ٱلْخَطِيَّةِ فِي ٱلْمَكَانِ ٱلْمُقَدَّسِ؟ لِأَنَّهَا قُدْسُ أَقْدَاسٍ، وَقَدْ أَعْطَاكُمَا إِيَّاهَا لِتَحْمِلَا إِثْمَ ٱلْجَمَاعَةِ تَكْفِيرًا عَنْهُمْ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","إِنَّهُ لَمْ يُؤْتَ بِدَمِهَا إِلَى ٱلْقُدْسِ دَاخِلًا. أَكْلًا تَأْكُلَانِهَا فِي ٱلْقُدْسِ كَمَا أَمَرْتُ». ");
INSERT INTO arb_vd_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","فَقَالَ هَارُونُ لِمُوسَى: «إِنَّهُمَا ٱلْيَوْمَ قَدْ قَرَّبَا ذَبِيحَةَ خَطِيَّتِهِمَا وَمُحْرَقَتَهُمَا أَمَامَ ٱلرَّبِّ، وَقَدْ أَصَابَنِي مِثْلُ هَذِهِ. فَلَوْ أَكَلْتُ ذَبِيحَةَ ٱلْخَطِيَّةِ ٱلْيَوْمَ، هَلْ كَانَ يَحْسُنُ فِي عَيْنَيِ ٱلرَّبِّ؟». ");
INSERT INTO arb_vd_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","فَلَمَّا سَمِعَ مُوسَى حَسُنَ فِي عَيْنَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ قَائِلًا لَهُمَا: ");
INSERT INTO arb_vd_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«كَلِّمَا بَنِي إِسْرَائِيلَ قَائِلَيْنِ: هَذِهِ هِيَ ٱلْحَيَوَانَاتُ ٱلَّتِي تَأْكُلُونَهَا مِنْ جَمِيعِ ٱلْبَهَائِمِ ٱلَّتِي عَلَى ٱلْأَرْضِ: ");
INSERT INTO arb_vd_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","كُلُّ مَا شَقَّ ظِلْفًا وَقَسَمَهُ ظِلْفَيْنِ، وَيَجْتَرُّ مِنَ ٱلْبَهَائِمِ، فَإِيَّاهُ تَأْكُلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","إِلَّا هَذِهِ فَلَا تَأْكُلُوهَا مِمَّا يَجْتَرُّ وَمِمَّا يَشُقُّ ٱلظِّلْفَ: ٱلْجَمَلَ، لِأَنَّهُ يَجْتَرُّ لَكِنَّهُ لَا يَشُقُّ ظِلْفًا، فَهُوَ نَجِسٌ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","وَٱلْوَبْرَ، لِأَنَّهُ يَجْتَرُّ لَكِنَّهُ لَا يَشُقُّ ظِلْفًا، فَهُوَ نَجِسٌ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","وَٱلْأَرْنَبَ، لِأَنَّهُ يَجْتَرُّ لَكِنَّهُ لَا يَشُقُّ ظِلْفًا، فَهُوَ نَجِسٌ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","وَٱلْخِنْزِيرَ، لِأَنَّهُ يَشُقُّ ظِلْفًا وَيَقْسِمُهُ ظِلْفَيْنِ، لَكِنَّهُ لَا يَجْتَرُّ، فَهُوَ نَجِسٌ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","مِنْ لَحْمِهَا لَا تَأْكُلُوا وَجُثَثَهَا لَا تَلْمِسُوا. إِنَّهَا نَجِسَةٌ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«وَهَذَا تَأْكُلُونَهُ مِنْ جَمِيعِ مَا فِي ٱلْمِيَاهِ: كُلُّ مَا لَهُ زَعَانِفُ وَحَرْشَفٌ فِي ٱلْمِيَاهِ، فِي ٱلْبِحَارِ وَفِي ٱلْأَنْهَارِ، فَإِيَّاهُ تَأْكُلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","لَكِنْ كُلُّ مَا لَيْسَ لَهُ زَعَانِفُ وَحَرْشَفٌ فِي ٱلْبِحَارِ وَفِي ٱلْأَنْهَارِ، مِنْ كُلِّ دَبِيبٍ فِي ٱلْمِيَاهِ وَمِنْ كُلِّ نَفْسٍ حَيَّةٍ فِي ٱلْمِيَاهِ، فَهُوَ مَكْرُوهٌ لَكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","وَمَكْرُوهًا يَكُونُ لَكُمْ. مِنْ لَحْمِهِ لَا تَأْكُلُوا، وَجُثَّتَهُ تَكْرَهُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","كُلُّ مَا لَيْسَ لَهُ زَعَانِفُ وَحَرْشَفٌ فِي ٱلْمِيَاهِ فَهُوَ مَكْرُوهٌ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«وَهَذِهِ تَكْرَهُونَهَا مِنَ ٱلطُّيُورِ. لَا تُؤْكَلْ. إِنَّهَا مَكْرُوهَةٌ: اَلنَّسْرُ وَٱلْأَنُوقُ وَٱلْعُقَابُ ");
INSERT INTO arb_vd_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","وَٱلْحِدَأَةُ وَٱلْبَاشِقُ عَلَى أَجْنَاسِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","وَكُلُّ غُرَابٍ عَلَى أَجْنَاسِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","وَٱلنَّعَامَةُ وَٱلظَّلِيمُ وَٱلسَّأَفُ وَٱلْبَازُ عَلَى أَجْنَاسِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","وَٱلْبُومُ وَٱلْغَوَّاصُ وَٱلْكُرْكِيُّ ");
INSERT INTO arb_vd_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","وَٱلْبَجَعُ وَٱلْقُوقُ وَٱلرَّخَمُ ");
INSERT INTO arb_vd_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","وَٱللَّقْلَقُ وَٱلْبَبْغَا عَلَى أَجْنَاسِهِ، وَٱلْهُدْهُدُ وَٱلْخُفَّاشُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","وَكُلُّ دَبِيبِ ٱلطَّيْرِ ٱلْمَاشِي عَلَى أَرْبَعٍ. فَهُوَ مَكْرُوهٌ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","إِلَّا هَذَا تَأْكُلُونَهُ مِنْ جَمِيعِ دَبِيبِ ٱلطَّيْرِ ٱلْمَاشِي عَلَى أَرْبَعٍ: مَا لَهُ كُرَاعَانِ فَوْقَ رِجْلَيْهِ يَثِبُ بِهِمَا عَلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","هَذَا مِنْهُ تَأْكُلُونَ: ٱلْجَرَادُ عَلَى أَجْنَاسِهِ، وَٱلدَّبَا عَلَى أَجْنَاسِهِ، وَٱلْحَرْجُوانُ عَلَى أَجْنَاسِهِ، وَٱلْجُنْدُبُ عَلَى أَجْنَاسِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","لَكِنْ سَائِرُ دَبِيبِ ٱلطَّيْرِ ٱلَّذِي لَهُ أَرْبَعُ أَرْجُلٍ فَهُوَ مَكْرُوهٌ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","مِنْ هَذِهِ تَتَنَجَّسُونَ. كُلُّ مَنْ مَسَّ جُثَثَهَا يَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","وَكُلُّ مَنْ حَمَلَ مِنْ جُثَثِهَا يَغْسِلُ ثِيَابَهُ وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","وَجَمِيعُ ٱلْبَهَائِمِ ٱلَّتِي لَهَا ظِلْفٌ وَلَكِنْ لَا تَشُقُّهُ شَقًّا أَوْ لَا تَجْتَرُّ، فَهِيَ نَجِسَةٌ لَكُمْ. كُلُّ مَنْ مَسَّهَا يَكُونُ نَجِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","وَكُلُّ مَا يَمْشِي عَلَى كُفُوفِهِ مِنْ جَمِيعِ ٱلْحَيَوَانَاتِ ٱلْمَاشِيَةِ عَلَى أَرْبَعٍ، فَهُوَ نَجِسٌ لَكُمْ. كُلُّ مَنْ مَسَّ جُثَثَهَا يَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","وَمَنْ حَمَلَ جُثَثَهَا يَغْسِلُ ثِيَابَهُ وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. إِنَّهَا نَجِسَةٌ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«وَهَذَا هُوَ ٱلنَّجِسُ لَكُمْ مِنَ ٱلدَّبِيبِ ٱلَّذِي يَدِبُّ عَلَى ٱلْأَرْضِ: اِبْنُ عِرْسٍ وَٱلْفَأْرُ وَٱلضَّبُّ عَلَى أَجْنَاسِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","وَٱلْحِرْذَوْنُ وَٱلْوَرَلُ وَٱلْوَزَغَةُ وَٱلْعِظَايَةُ وَٱلْحِرْبَاءُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","هَذِهِ هِيَ ٱلنَّجِسَةُ لَكُمْ مِنْ كُلِّ ٱلدَّبِيبِ. كُلُّ مَنْ مَسَّهَا بَعْدَ مَوْتِهَا يَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","وَكُلُّ مَا وَقَعَ عَلَيْهِ وَاحِدٌ مِنْهَا بَعْدَ مَوْتِهَا يَكُونُ نَجِسًا. مِنْ كُلِّ مَتَاعِ خَشَبٍ أَوْ ثَوْبٍ أَوْ جِلْدٍ أَوْ بَلَاسٍ. كُلُّ مَتَاعٍ يُعْمَلُ بِهِ عَمَلٌ يُلْقَى فِي ٱلْمَاءِ وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ ثُمَّ يَطْهُرُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","وَكُلُّ مَتَاعِ خَزَفٍ وَقَعَ فِيهِ مِنْهَا، فَكُلُّ مَا فِيهِ يَتَنَجَّسُ، وَأَمَّا هُوَ فَتَكْسِرُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","مَا يَأْتِي عَلَيْهِ مَاءٌ مِنْ كُلِّ طَعَامٍ يُؤْكَلُ يَكُونُ نَجِسًا. وَكُلُّ شَرَابٍ يُشْرَبُ فِي كُلِّ مَتَاعٍ يَكُونُ نَجِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","وَكُلُّ مَا وَقَعَ عَلَيْهِ وَاحِدَةٌ مِنْ جُثَثِهَا يَكُونُ نَجِسًا. اَلتَّنُّورُ وَٱلْمَوْقِدَةُ يُهْدَمَانِ. إِنَّهَا نَجِسَةٌ وَتَكُونُ نَجِسَةً لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","إِلَّا ٱلْعَيْنَ وَٱلْبِئْرَ، مُجْتَمَعَيِ ٱلْمَاءِ، تَكُونَانِ طَاهِرَتَيْنِ. لَكِنْ مَا مَسَّ جُثَثَهَا يَكُونُ نَجِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","وَإِذَا وَقَعَتْ وَاحِدَةٌ مِنْ جُثَثِهَا عَلَى شَيْءٍ مِنْ بِزْرِ زَرْعٍ يُزْرَعُ فَهُوَ طَاهِرٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","لَكِنْ إِذَا جُعِلَ مَاءٌ عَلَى بِزْرٍ فَوَقَعَ عَلَيْهِ وَاحِدَةٌ مِنْ جُثَثِهَا، فَإِنَّهُ نَجِسٌ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","وَإِذَا مَاتَ وَاحِدٌ مِنَ ٱلْبَهَائِمِ ٱلَّتِي هِيَ طَعَامٌ لَكُمْ، فَمَنْ مَسَّ جُثَّتَهُ يَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","وَمَنْ أَكَلَ مِنْ جُثَّتِهِ يَغْسِلُ ثِيَابَهُ وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. وَمَنْ حَمَلَ جُثَّتَهُ يَغْسِلُ ثِيَابَهُ وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«وَكُلُّ دَبِيبٍ يَدِبُّ عَلَى ٱلْأَرْضِ فَهُوَ مَكْرُوهٌ لَا يُؤْكَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","كُلُّ مَا يَمْشِي عَلَى بَطْنِهِ، وَكُلُّ مَا يَمْشِي عَلَى أَرْبَعٍ مَعَ كُلِّ مَا كَثُرَتْ أَرْجُلُهُ مِنْ كُلِّ دَبِيبٍ يَدِبُّ عَلَى ٱلْأَرْضِ، لَا تَأْكُلُوهُ لِأَنَّهُ مَكْرُوهٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","لَا تُدَنِّسُوا أَنْفُسَكُمْ بِدَبِيبٍ يَدِبُّ، وَلَا تَتَنَجَّسُوا بِهِ، وَلَا تَكُونُوا بِهِ نَجِسِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","إِنِّي أَنَا ٱلرَّبُّ إِلَهُكُمْ فَتَتَقَدَّسُونَ وَتَكُونُونَ قِدِّيسِينَ، لِأَنِّي أَنَا قُدُّوسٌ. وَلَا تُنَجِّسُوا أَنْفُسَكُمْ بِدَبِيبٍ يَدِبُّ عَلَى ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","إِنِّي أَنَا ٱلرَّبُّ ٱلَّذِي أَصْعَدَكُمْ مِنْ أَرْضِ مِصْرَ لِيَكُونَ لَكُمْ إِلَهًا. فَتَكُونُونَ قِدِّيسِينَ لِأَنِّي أَنَا قُدُّوسٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","هَذِهِ شَرِيعَةُ ٱلْبَهَائِمِ وَٱلطُّيُورِ وَكُلِّ نَفْسٍ حَيَّةٍ تَسْعَى فِي ٱلْمَاءِ وَكُلِّ نَفْسٍ تَدِبُّ عَلَى ٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","لِلتَّمْيِيزِ بَيْنَ ٱلنَّجِسِ وَٱلطَّاهِرِ، وَبَيْنَ ٱلْحَيَوَانَاتِ ٱلَّتِي تُؤْكَلُ، وَٱلْحَيَوَانَاتِ ٱلَّتِي لَا تُؤْكَلُ». ");
INSERT INTO arb_vd_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ قَائِلًا: إِذَا حَبِلَتِ ٱمْرَأَةٌ وَوَلَدَتْ ذَكَرًا، تَكُونُ نَجِسَةً سَبْعَةَ أَيَّامٍ. كَمَا فِي أَيَّامِ طَمْثِ عِلَّتِهَا تَكُونُ نَجِسَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","وَفِي ٱلْيَوْمِ ٱلثَّامِنِ يُخْتَنُ لَحْمُ غُرْلَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ثُمَّ تُقِيمُ ثَلَاثَةً وَثَلَاثِينَ يَوْمًا فِي دَمِ تَطْهِيرِهَا. كُلَّ شَيْءٍ مُقَدَّسٍ لَا تَمَسَّ، وَإِلَى ٱلْمَقْدِسِ لَا تَجِئْ حَتَّى تَكْمُلَ أَيَّامُ تَطْهِيرِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","وَإِنْ وَلَدَتْ أُنْثَى، تَكُونُ نَجِسَةً أُسْبُوعَيْنِ كَمَا فِي طَمْثِهَا. ثُمَّ تُقِيمُ سِتَّةً وَسِتِّينَ يَوْمًا فِي دَمِ تَطْهِيرِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","وَمَتَى كَمُلَتْ أَيَّامُ تَطْهِيرِهَا لِأَجْلِ ٱبْنٍ أَوِ ٱبْنَةٍ، تَأْتِي بِخَرُوفٍ حَوْلِيٍّ مُحْرَقَةً، وَفَرْخِ حَمَامَةٍ أَوْ يَمَامَةٍ ذَبِيحَةَ خَطِيَّةٍ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ، إِلَى ٱلْكَاهِنِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","فَيُقَدِّمُهُمَا أَمَامَ ٱلرَّبِّ وَيُكَفِّرُ عَنْهَا، فَتَطْهُرُ مِنْ يَنْبُوعِ دَمِهَا. هَذِهِ شَرِيعَةُ ٱلَّتِي تَلِدُ ذَكَرًا أَوْ أُنْثَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","وَإِنْ لَمْ تَنَلْ يَدُهَا كِفَايَةً لِشَاةٍ تَأْخُذُ يَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ، ٱلْوَاحِدَ مُحْرَقَةً، وَٱلْآخَرَ ذَبِيحَةَ خَطِيَّةٍ، فَيُكَفِّرُ عَنْهَا ٱلْكَاهِنُ فَتَطْهُرُ». ");
INSERT INTO arb_vd_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«إِذَا كَانَ إِنْسَانٌ فِي جِلْدِ جَسَدِهِ نَاتِئٌ أَوْ قُوبَاءُ أَوْ لُمْعَةٌ تَصِيرُ فِي جِلْدِ جَسَدِهِ ضَرْبَةَ بَرَصٍ، يُؤْتَى بِهِ إِلَى هَارُونَ ٱلْكَاهِنِ أَوْ إِلَى أَحَدِ بَنِيهِ ٱلْكَهَنَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","فَإِنْ رَأَى ٱلْكَاهِنُ ٱلضَّرْبَةَ فِي جِلْدِ ٱلْجَسَدِ، وَفِي ٱلضَّرْبَةِ شَعَرٌ قَدِ ٱبْيَضَّ، وَمَنْظَرُ ٱلضَّرْبَةِ أَعْمَقُ مِنْ جِلْدِ جَسَدِهِ، فَهِيَ ضَرْبَةُ بَرَصٍ. فَمَتَى رَآهُ ٱلْكَاهِنُ يَحْكُمُ بِنَجَاسَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","لَكِنْ إِنْ كَانَتِ ٱلضَّرْبَةُ لُمْعَةً بَيْضَاءَ فِي جِلْدِ جَسَدِهِ، وَلَمْ يَكُنْ مَنْظَرُهَا أَعْمَقَ مِنَ ٱلْجِلْدِ، وَلَمْ يَبْيَضَّ شَعْرُهَا، يَحْجُزُ ٱلْكَاهِنُ ٱلْمَضْرُوبَ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","فَإِنْ رَآهُ ٱلْكَاهِنُ فِي ٱلْيَوْمِ ٱلسَّابِعِ وَإِذَا فِي عَيْنِهِ ٱلضَّرْبَةُ قَدْ وَقَفَتْ، وَلَمْ تَمْتَدَّ ٱلضَّرْبَةُ فِي ٱلْجِلْدِ، يَحْجُزُهُ ٱلْكَاهِنُ سَبْعَةَ أَيَّامٍ ثَانِيَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","فَإِنْ رَآهُ ٱلْكَاهِنُ فِي ٱلْيَوْمِ ٱلسَّابِعِ ثَانِيَةً وَإِذَا ٱلضَّرْبَةُ كَامِدَةُ ٱللَّوْنِ، وَلَمْ تَمْتَدَّ ٱلضَّرْبَةُ فِي ٱلْجِلْدِ، يَحْكُمُ ٱلْكَاهِنُ بِطَهَارَتِهِ. إِنَّهَا حَزَازٌ. فَيَغْسِلُ ثِيَابَهُ وَيَكُونُ طَاهِرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","لَكِنْ إِنْ كَانَتِ ٱلْقُوبَاءُ تَمْتَدُّ فِي ٱلْجِلْدِ بَعْدَ عَرْضِهِ عَلَى ٱلْكَاهِنِ لِتَطْهِيرِهِ، يُعْرَضُ عَلَى ٱلْكَاهِنِ ثَانِيَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","فَإِنْ رَأَى ٱلْكَاهِنُ وَإِذَا ٱلْقُوبَاءُ قَدِ ٱمْتَدَّتْ فِي ٱلْجِلْدِ، يَحْكُمُ ٱلْكَاهِنُ بِنَجَاسَتِهِ. إِنَّهَا بَرَصٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«إِنْ كَانَتْ فِي إِنْسَانٍ ضَرْبَةُ بَرَصٍ فَيُؤْتَى بِهِ إِلَى ٱلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","فَإِنْ رَأَى ٱلْكَاهِنُ وَإِذَا فِي ٱلْجِلْدِ نَاتِئٌ أَبْيَضُ، قَدْ صَيَّرَ ٱلشَّعْرَ أَبْيَضَ، وَفِي ٱلنَّاتِئِ وَضَحٌ مِنْ لَحْمٍ حَيٍّ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","فَهُوَ بَرَصٌ مُزْمِنٌ فِي جِلْدِ جَسَدِهِ. فَيَحْكُمُ ٱلْكَاهِنُ بِنَجَاسَتِهِ. لَا يَحْجُزُهُ لِأَنَّهُ نَجِسٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","لَكِنْ إِنْ كَانَ ٱلْبَرَصُ قَدْ أَفْرَخَ فِي ٱلْجِلْدِ، وَغَطَّى ٱلْبَرَصُ كُلَّ جِلْدِ ٱلْمَضْرُوبِ مِنْ رَأْسِهِ إِلَى قَدَمَيْهِ حَسَبَ كُلِّ مَا تَرَاهُ عَيْنَا ٱلْكَاهِنِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","وَرَأَى ٱلْكَاهِنُ وَإِذَا ٱلْبَرَصُ قَدْ غَطَّى كُلَّ جِسْمِهِ، يَحْكُمُ بِطَهَارَةِ ٱلْمَضْرُوبِ. كُلُّهُ قَدِ ٱبْيَضَّ. إِنَّهُ طَاهِرٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","لَكِنْ يَوْمَ يُرَى فِيهِ لَحْمٌ حَيٌّ يَكُونُ نَجِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","فَمَتَى رَأَى ٱلْكَاهِنُ ٱللَّحْمَ ٱلْحَيَّ يَحْكُمُ بِنَجَاسَتِهِ. ٱللَّحْمُ ٱلْحَيُّ نَجِسٌ. إِنَّهُ بَرَصٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ثُمَّ إِنْ عَادَ ٱللَّحْمُ ٱلْحَيُّ وَٱبْيَضَّ يَأْتِي إِلَى ٱلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","فَإِنْ رَآهُ ٱلْكَاهِنُ وَإِذَا ٱلضَّرْبَةُ قَدْ صَارَتْ بَيْضَاءَ، يَحْكُمُ ٱلْكَاهِنُ بِطَهَارَةِ ٱلْمَضْرُوبِ. إِنَّهُ طَاهِرٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«وَإِذَا كَانَ ٱلْجِسْمُ فِي جِلْدِهِ دُمَّلَةٌ قَدْ بَرِئَتْ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","وَصَارَ فِي مَوْضِعِ ٱلدُّمَّلَةِ نَاتِئٌ أَبْيَضُ، أَوْ لُمْعَةٌ بَيْضَاءُ ضَارِبَةٌ إِلَى ٱلْحُمْرَةِ، يُعْرَضُ عَلَى ٱلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","فَإِنْ رَأَى ٱلْكَاهِنُ وَإِذَا مَنْظَرُهَا أَعْمَقُ مِنَ ٱلْجِلْدِ وَقَدِ ٱبْيَضَّ شَعْرُهَا، يَحْكُمُ ٱلْكَاهِنُ بِنَجَاسَتِهِ. إِنَّهَا ضَرْبَةُ بَرَصٍ أَفْرَخَتْ فِي ٱلدُّمَّلَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","لَكِنْ إِنْ رَآهَا ٱلْكَاهِنُ وَإِذَا لَيْسَ فِيهَا شَعْرٌ أَبْيَضُ، وَلَيْسَتْ أَعْمَقَ مِنَ ٱلْجِلْدِ، وَهِيَ كَامِدَةُ ٱللَّوْنِ، يَحْجُزُهُ ٱلْكَاهِنُ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","فَإِنْ كَانَتْ قَدِ ٱمْتَدَّتْ فِي ٱلْجِلْدِ يَحْكُمُ ٱلْكَاهِنُ بِنَجَاسَتِهِ. إِنَّهَا ضَرْبَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","لَكِنْ إِنْ وَقَفَتِ ٱللُّمْعَةُ مَكَانَهَا وَلَمْ تَمْتَدَّ، فَهِيَ أَثَرُ ٱلدُّمَّلَةِ. فَيَحْكُمُ ٱلْكَاهِنُ بِطَهَارَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«أَوْ إِذَا كَانَ ٱلْجِسْمُ فِي جِلْدِهِ كَيُّ نَارٍ، وَكَانَ حَيُّ ٱلْكَيِّ لُمْعَةً بَيْضَاءَ ضَارِبَةً إِلَى ٱلْحُمْرَةِ أَوْ بَيْضَاءَ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","وَرَآهَا ٱلْكَاهِنُ وَإِذَا ٱلشَّعْرُ فِي ٱللُّمْعَةِ قَدِ ٱبْيَضَّ، وَمَنْظَرُهَا أَعْمَقُ مِنَ ٱلْجِلْدِ، فَهِيَ بَرَصٌ قَدْ أَفْرَخَ فِي ٱلْكَيِّ. فَيَحْكُمُ ٱلْكَاهِنُ بِنَجَاسَتِهِ. إِنَّهَا ضَرْبَةُ بَرَصٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","لَكِنْ إِنْ رَآهَا ٱلْكَاهِنُ وَإِذَا لَيْسَ فِي ٱللُّمْعَةِ شَعْرٌ أَبْيَضُ، وَلَيْسَتْ أَعْمَقَ مِنَ ٱلْجِلْدِ، وَهِيَ كَامِدَةُ ٱللَّوْنِ، يَحْجُزُهُ ٱلْكَاهِنُ سَبْعَةَ أَيَّامٍ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ثُمَّ يَرَاهُ ٱلْكَاهِنُ فِي ٱلْيَوْمِ ٱلسَّابِعِ. فَإِنْ كَانَتْ قَدِ ٱمْتَدَّتْ فِي ٱلْجِلْدِ، يَحْكُمُ ٱلْكَاهِنُ بِنَجَاسَتِهِ. إِنَّهَا ضَرْبَةُ بَرَصٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","لَكِنْ إِنْ وَقَفَتِ ٱللُّمْعَةُ مَكَانَهَا، لَمْ تَمْتَدَّ فِي ٱلْجِلْدِ، وَكَانَتْ كَامِدَةَ ٱللَّوْنِ، فَهِيَ نَاتِئُ ٱلْكَيِّ، فَٱلْكَاهِنُ يَحْكُمُ بِطَهَارَتِهِ لِأَنَّهَا أَثَرُ ٱلْكَيِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«وَإِذَا كَانَ رَجُلٌ أَوِ ٱمْرَأَةٌ فِيهِ ضَرْبَةٌ فِي ٱلرَّأْسِ أَوْ فِي ٱلذَّقَنِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","وَرَأَى ٱلْكَاهِنُ ٱلضَّرْبَةَ وَإِذَا مَنْظَرُهَا أَعْمَقُ مِنَ ٱلْجِلْدِ، وَفِيهَا شَعْرٌ أَشْقَرُ دَقِيقٌ، يَحْكُمُ ٱلْكَاهِنُ بِنَجَاسَتِهِ. إِنَّهَا قَرَعٌ. بَرَصُ ٱلرَّأْسِ أَوِ ٱلذَّقَنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","لَكِنْ إِذَا رَأَى ٱلْكَاهِنُ ضَرْبَةَ ٱلْقَرَعِ وَإِذَا مَنْظَرُهَا لَيْسَ أَعْمَقَ مِنَ ٱلْجِلْدِ، لَكِنْ لَيْسَ فِيهَا شَعْرٌ أَسْوَدُ، يَحْجُزُ ٱلْكَاهِنُ ٱلْمَضْرُوبَ بِٱلْقَرَعِ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","فَإِنْ رَأَى ٱلْكَاهِنُ ٱلضَّرْبَةَ فِي ٱلْيَوْمِ ٱلسَّابِعِ وَإِذَا ٱلْقَرَعُ لَمْ يَمْتَدَّ، وَلَمْ يَكُنْ فِيهِ شَعْرٌ أَشْقَرُ، وَلَا مَنْظَرُ ٱلْقَرَعِ أَعْمَقُ مِنَ ٱلْجِلْدِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","فَلْيَحْلِقْ. لَكِنْ لَا يَحْلِقِ ٱلْقَرَعَ. وَيَحْجُزُ ٱلْكَاهِنُ ٱلْأَقْرَعَ سَبْعَةَ أَيَّامٍ ثَانِيَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","فَإِنْ رَأَى ٱلْكَاهِنُ ٱلْأَقْرَعَ فِي ٱلْيَوْمِ ٱلسَّابِعِ وَإِذَا ٱلْقَرَعُ لَمْ يَمْتَدَّ فِي ٱلْجِلْدِ، وَلَيْسَ مَنْظَرُهُ أَعْمَقَ مِنَ ٱلْجِلْدِ، يَحْكُمُ ٱلْكَاهِنُ بِطَهَارَتِهِ، فَيَغْسِلُ ثِيَابَهُ وَيَكُونُ طَاهِرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","لَكِنْ إِنْ كَانَ ٱلْقَرَعُ يَمْتَدُّ فِي ٱلْجِلْدِ بَعْدَ ٱلْحُكْمِ بِطَهَارَتِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","وَرَآهُ ٱلْكَاهِنُ وَإِذَا ٱلْقَرَعُ قَدِ ٱمْتَدَّ فِي ٱلْجِلْدِ، فَلَا يُفَتِّشُ ٱلْكَاهِنُ عَلَى ٱلشَّعْرِ ٱلْأَشْقَرِ. إِنَّهُ نَجِسٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","لَكِنْ إِنْ وَقَفَ فِي عَيْنَيْهِ وَنَبَتَ فِيهِ شَعْرٌ أَسْوَدُ، فَقَدْ بَرِئَ ٱلْقَرَعُ. إِنَّهُ طَاهِرٌ فَيَحْكُمُ ٱلْكَاهِنُ بِطَهَارَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«وَإِذَا كَانَ رَجُلٌ أَوِ ٱمْرَأَةٌ فِي جِلْدِ جَسَدِهِ لُمَعٌ، لُمَعٌ بِيضٌ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","وَرَأَى ٱلْكَاهِنُ وَإِذَا فِي جِلْدِ جَسَدِهِ لُمَعٌ كَامِدَةُ ٱللَّوْنِ بَيْضَاءُ، فَذَلِكَ بَهَقٌ قَدْ أَفْرَخَ فِي ٱلْجِلْدِ. إِنَّهُ طَاهِرٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«وَإِذَا كَانَ إِنْسَانٌ قَدْ ذَهَبَ شَعْرُ رَأْسِهِ فَهُوَ أَقْرَعُ. إِنَّهُ طَاهِرٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","وَإِنْ ذَهَبَ شَعْرُ رَأْسِهِ مِنْ جِهَةِ وَجْهِهِ فَهُوَ أَصْلَعُ. إِنَّهُ طَاهِرٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","لَكِنْ إِذَا كَانَ فِي ٱلْقَرَعَةِ أَوْ فِي ٱلصَّلْعَةِ ضَرْبَةٌ بَيْضَاءُ ضَارِبَةٌ إِلَى ٱلْحُمْرَةِ، فَهُوَ بَرَصٌ مُفْرِخٌ فِي قَرَعَتِهِ أَوْ فِي صَلْعَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","فَإِنْ رَآهُ ٱلْكَاهِنُ وَإِذَا نَاتِئُ ٱلضَّرْبَةِ أَبْيَضُ ضَارِبٌ إِلَى ٱلْحُمْرَةِ فِي قَرَعَتِهِ أَوْ فِي صَلْعَتِهِ، كَمَنْظَرِ ٱلْبَرَصِ فِي جِلْدِ ٱلْجَسَدِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","فَهُوَ إِنْسَانٌ أَبْرَصُ. إِنَّهُ نَجِسٌ. فَيَحْكُمُ ٱلْكَاهِنُ بِنَجَاسَتِهِ. إِنَّ ضَرْبَتَهُ فِي رَأْسِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","وَٱلْأَبْرَصُ ٱلَّذِي فِيهِ ٱلضَّرْبَةُ، تَكُونُ ثِيَابُهُ مَشْقُوقَةً، وَرَأْسُهُ يَكُونُ مَكْشُوفًا، وَيُغَطِّي شَارِبَيْهِ، وَيُنَادِي: نَجِسٌ، نَجِسٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","كُلَّ ٱلْأَيَّامِ ٱلَّتِي تَكُونُ ٱلضَّرْبَةُ فِيهِ يَكُونُ نَجِسًا. إِنَّهُ نَجِسٌ. يُقِيمُ وَحْدَهُ. خَارِجَ ٱلْمَحَلَّةِ يَكُونُ مُقَامُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«وَأَمَّا ٱلثَّوْبُ فَإِذَا كَانَ فِيهِ ضَرْبَةُ بَرَصٍ، ثَوْبُ صُوفٍ أَوْ ثَوْبُ كَتَّانٍ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","فِي ٱلسَّدَى أَوِ ٱللُّحْمَةِ مِنَ ٱلصُّوفِ أَوِ ٱلْكَتَّانِ، أَوْ فِي جِلْدٍ أَوْ فِي كُلِّ مَصْنُوعٍ مِنْ جِلْدٍ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","وَكَانَتِ ٱلضَّرْبَةُ ضَارِبَةً إِلَى ٱلْخُضْرَةِ أَوْ إِلَى ٱلْحُمْرَةِ فِي ٱلثَّوْبِ أَوْ فِي ٱلْجِلْدِ، فِي ٱلسَّدَى أَوِ ٱللُّحْمَةِ أَوْ فِي مَتَاعٍ مَا مِنْ جِلْدٍ، فَإِنَّهَا ضَرْبَةُ بَرَصٍ، فَتُعْرَضُ عَلَى ٱلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","فَيَرَى ٱلْكَاهِنُ ٱلضَّرْبَةَ وَيَحْجُزُ ٱلْمَضْرُوبَ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","فَمَتَى رَأَى ٱلضَّرْبَةَ فِي ٱلْيَوْمِ ٱلسَّابِعِ إِذَا كَانَتِ ٱلضَّرْبَةُ قَدِ ٱمْتَدَّتْ فِي ٱلثَّوْبِ، فِي ٱلسَّدَى أَوِ ٱللُّحْمَةِ أَوْ فِي ٱلْجِلْدِ مِنْ كُلِّ مَا يُصْنَعُ مِنْ جِلْدٍ لِلْعَمَلِ، فَٱلضَّرْبَةُ بَرَصٌ مُفْسِدٌ. إِنَّهَا نَجِسَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","فَيُحْرِقُ ٱلثَّوْبَ أَوِ ٱلسَّدَى أَوِ ٱللُّحْمَةَ مِنَ ٱلصُّوفِ أَوِ ٱلْكَتَّانِ أَوْ مَتَاعِ ٱلْجِلْدِ ٱلَّذِي كَانَتْ فِيهِ ٱلضَّرْبَةُ، لِأَنَّهَا بَرَصٌ مُفْسِدٌ. بِٱلنَّارِ يُحْرَقُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","لَكِنْ إِنْ رَأَى ٱلْكَاهِنُ وَإِذَا ٱلضَّرْبَةُ لَمْ تَمْتَدَّ فِي ٱلثَّوْبِ فِي ٱلسَّدَى أَوِ ٱللُّحْمَةِ أَوْ فِي مَتَاعِ ٱلْجِلْدِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","يَأْمُرُ ٱلْكَاهِنُ أَنْ يَغْسِلُوا مَا فِيهِ ٱلضَّرْبَةُ، وَيَحْجُزُهُ سَبْعَةَ أَيَّامٍ ثَانِيَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","فَإِنْ رَأَى ٱلْكَاهِنُ بَعْدَ غَسْلِ ٱلْمَضْرُوبِ وَإِذَا ٱلضَّرْبَةُ لَمْ تُغَيِّرْ مَنْظَرَهَا، وَلَا ٱمْتَدَّتِ ٱلضَّرْبَةُ، فَهُوَ نَجِسٌ. بِٱلنَّارِ تُحْرِقُهُ. إِنَّهَا نُخْرُوبٌ فِي جُرْدَةِ بَاطِنِهِ أَوْ ظَاهِرِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","لَكِنْ إِنْ رَأَى ٱلْكَاهِنُ وَإِذَا ٱلضَّرْبَةُ كَامِدَةُ ٱللَّوْنِ بَعْدَ غَسْلِهِ، يُمَزِّقُهَا مِنَ ٱلثَّوْبِ أَوِ ٱلْجِلْدِ مِنَ ٱلسَّدَى أَوِ ٱللُّحْمَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ثُمَّ إِنْ ظَهَرَتْ أَيْضًا فِي ٱلثَّوْبِ فِي ٱلسَّدَى أَوِ ٱللُّحْمَةِ أَوْ فِي مَتَاعِ ٱلْجِلْدِ فَهِيَ مُفْرِخَةٌ. بِٱلنَّارِ تُحْرِقُ مَا فِيهِ ٱلضَّرْبَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","وَأَمَّا ٱلثَّوْبُ، ٱلسَّدَى أَوِ ٱللُّحْمَةُ أَوْ مَتَاعُ ٱلْجِلْدِ ٱلَّذِي تَغْسِلُهُ وَتَزُولُ مِنْهُ ٱلضَّرْبَةُ، فَيُغْسَلُ ثَانِيَةً فَيَطْهُرُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","«هَذِهِ شَرِيعَةُ ضَرْبَةِ ٱلْبَرَصِ فِي ٱلصُّوفِ أَوِ ٱلْكَتَّانِ، فِي ٱلسَّدَى أَوِ ٱللُّحْمَةِ أَوْ فِي كُلِّ مَتَاعٍ مِنْ جِلْدٍ، لِلْحُكْمِ بِطَهَارَتِهِ أَوْ نَجَاسَتِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«هَذِهِ تَكُونُ شَرِيعَةَ ٱلْأَبْرَصِ: يَوْمَ طُهْرِهِ، يُؤْتَى بِهِ إِلَى ٱلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","وَيَخْرُجُ ٱلْكَاهِنُ إِلَى خَارِجِ ٱلْمَحَلَّةِ، فَإِنْ رَأَى ٱلْكَاهِنُ وَإِذَا ضَرْبَةُ ٱلْبَرَصِ قَدْ بَرِئَتْ مِنَ ٱلْأَبْرَصِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","يَأْمُرُ ٱلْكَاهِنُ أَنْ يُؤْخَذَ لِلْمُتَطَهِّرِ عُصْفُورَانِ حَيَّانِ طَاهِرَانِ، وَخَشَبُ أَرْزٍ وَقِرْمِزٌ وَزُوفَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","وَيَأْمُرُ ٱلْكَاهِنُ أَنْ يُذْبَحَ ٱلْعُصْفُورُ ٱلْوَاحِدُ فِي إِنَاءِ خَزَفٍ عَلَى مَاءٍ حَيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","أَمَّا ٱلْعُصْفُورُ ٱلْحَيُّ فَيَأْخُذُهُ مَعَ خَشَبِ ٱلْأَرْزِ وَٱلْقِرْمِزِ وَٱلزُّوفَا وَيَغْمِسُهَا مَعَ ٱلْعُصْفُورِ ٱلْحَيِّ فِي دَمِ ٱلْعُصْفُورِ ٱلْمَذْبُوحِ عَلَى ٱلْمَاءِ ٱلْحَيِّ، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","وَيَنْضِحُ عَلَى ٱلْمُتَطَهِّرِ مِنَ ٱلْبَرَصِ سَبْعَ مَرَّاتٍ فَيُطَهِّرُهُ، ثُمَّ يُطْلِقُ ٱلْعُصْفُورَ ٱلْحَيَّ عَلَى وَجْهِ ٱلصَّحْرَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","فَيَغْسِلُ ٱلْمُتَطَهِّرُ ثِيَابَهُ وَيَحْلِقُ كُلَّ شَعْرِهِ وَيَسْتَحِمُّ بِمَاءٍ فَيَطْهُرُ. ثُمَّ يَدْخُلُ ٱلْمَحَلَّةَ، لَكِنْ يُقِيمُ خَارِجَ خَيْمَتِهِ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","وَفِي ٱلْيَوْمِ ٱلسَّابِعِ يَحْلِقُ كُلَّ شَعْرِهِ: رَأْسَهُ وَلِحْيَتَهُ وَحَوَاجِبَ عَيْنَيْهِ وَجَمِيعَ شَعْرِهِ يَحْلِقُ. وَيَغْسِلُ ثِيَابَهُ وَيَرْحَضُ جَسَدَهُ بِمَاءٍ فَيَطْهُرُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","ثُمَّ فِي ٱلْيَوْمِ ٱلثَّامِنِ يَأْخُذُ خَرُوفَيْنِ صَحِيحَيْنِ وَنَعْجَةً وَاحِدَةً حَوْلِيَّةً صَحِيحَةً وَثَلَاثَةَ أَعْشَارِ دَقِيقٍ تَقْدِمَةً مَلْتُوتَةً بِزَيْتٍ وَلُجَّ زَيْتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","فَيُوقِفُ ٱلْكَاهِنُ ٱلْمُطَهِّرُ ٱلْإِنْسَانَ ٱلْمُتَطَهِّرَ وَإِيَّاهَا أَمَامَ ٱلرَّبِّ لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ثُمَّ يَأْخُذُ ٱلْكَاهِنُ ٱلْخَرُوفَ ٱلْوَاحِدَ وَيُقَرِّبُهُ ذَبِيحَةَ إِثْمٍ مَعَ لُجِّ ٱلزَّيْتِ. يُرَدِّدُهُمَا تَرْدِيدًا أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","وَيَذْبَحُ ٱلْخَرُوفَ فِي ٱلْمَوْضِعِ ٱلَّذِي يَذْبَحُ فِيهِ ذَبِيحَةَ ٱلْخَطِيَّةِ وَٱلْمُحْرَقَةَ فِي ٱلْمَكَانِ ٱلْمُقَدَّسِ، لِأَنَّ ذَبِيحَةَ ٱلْإِثْمِ كَذَبِيحَةِ ٱلْخَطِيَّةِ لِلْكَاهِنِ. إِنَّهَا قُدْسُ أَقْدَاسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","وَيَأْخُذُ ٱلْكَاهِنُ مِنْ دَمِ ذَبِيحَةِ ٱلْإِثْمِ وَيَجْعَلُ ٱلْكَاهِنُ عَلَى شَحْمَةِ أُذُنِ ٱلْمُتَطَهِّرِ ٱلْيُمْنَى، وَعَلَى إِبْهَامِ يَدِهِ ٱلْيُمْنَى، وَعَلَى إِبْهَامِ رِجْلِهِ ٱلْيُمْنَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","وَيَأْخُذُ ٱلْكَاهِنُ مِنْ لُجِّ ٱلزَّيْتِ وَيَصُبُّ فِي كَفِّ ٱلْكَاهِنِ ٱلْيُسْرَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","وَيَغْمِسُ ٱلْكَاهِنُ إِصْبَعَهُ ٱلْيُمْنَى فِي ٱلزَّيْتِ ٱلَّذِي عَلَى كَفِّهِ ٱلْيُسْرَى، وَيَنْضِحُ مِنَ ٱلزَّيْتِ بِإِصْبَعِهِ سَبْعَ مَرَّاتٍ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","وَمِمَّا فَضِلَ مِنَ ٱلزَّيْتِ ٱلَّذِي فِي كَفِّهِ يَجْعَلُ ٱلْكَاهِنُ عَلَى شَحْمَةِ أُذُنِ ٱلْمُتَطَهِّرِ ٱلْيُمْنَى، وَعَلَى إِبْهَامِ يَدِهِ ٱلْيُمْنَى، وَعَلَى إِبْهَامِ رِجْلِهِ ٱلْيُمْنَى، عَلَى دَمِ ذَبِيحَةِ ٱلْإِثْمِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","وَٱلْفَاضِلُ مِنَ ٱلزَّيْتِ ٱلَّذِي فِي كَفِّ ٱلْكَاهِنِ يَجْعَلُهُ عَلَى رَأْسِ ٱلْمُتَطَهِّرِ، وَيُكَفِّرُ عَنْهُ ٱلْكَاهِنُ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ثُمَّ يَعْمَلُ ٱلْكَاهِنُ ذَبِيحَةَ ٱلْخَطِيَّةِ وَيُكَفِّرُ عَنِ ٱلْمُتَطَهِّرِ مِنْ نَجَاسَتِهِ. ثُمَّ يَذْبَحُ ٱلْمُحْرَقَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","وَيُصْعِدُ ٱلْكَاهِنُ ٱلْمُحْرَقَةَ وَٱلتَّقْدِمَةَ عَلَى ٱلْمَذْبَحِ وَيُكَفِّرُ عَنْهُ ٱلْكَاهِنُ فَيَطْهُرُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«لَكِنْ إِنْ كَانَ فَقِيرًا وَلَا تَنَالُ يَدُهُ، يَأْخُذُ خَرُوفًا وَاحِدًا ذَبِيحَةَ إِثْمٍ لِتَرْدِيدٍ، تَكْفِيرًا عَنْهُ، وَعُشْرًا وَاحِدًا مِنْ دَقِيقٍ مَلْتُوتٍ بِزَيْتٍ لِتَقْدِمَةٍ، وَلُجَّ زَيْتٍ، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","وَيَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ كَمَا تَنَالُ يَدُهُ، فَيَكُونُ ٱلْوَاحِدُ ذَبِيحَةَ خَطِيَّةٍ، وَٱلْآخَرُ مُحْرَقَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","وَيَأْتِي بِهَا فِي ٱلْيَوْمِ ٱلثَّامِنِ لِطُهْرِهِ إِلَى ٱلْكَاهِنِ، إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","فَيَأْخُذُ ٱلْكَاهِنُ كَبْشَ ٱلْإِثْمِ وَلُجَّ ٱلزَّيْتِ، وَيُرَدِّدُهُمَا ٱلْكَاهِنُ تَرْدِيدًا أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ثُمَّ يَذْبَحُ كَبْشَ ٱلْإِثْمِ، وَيَأْخُذُ ٱلْكَاهِنُ مِنْ دَمِ ذَبِيحَةِ ٱلْإِثْمِ وَيَجْعَلُ عَلَى شَحْمَةِ أُذُنِ ٱلْمُتَطَهِّرِ ٱلْيُمْنَى، وَعَلَى إِبْهَامِ يَدِهِ ٱلْيُمْنَى، وَعَلَى إِبْهَامِ رِجْلِهِ ٱلْيُمْنَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","وَيَصُبُّ ٱلْكَاهِنُ مِنَ ٱلزَّيْتِ فِي كَفِّ ٱلْكَاهِنِ ٱلْيُسْرَى، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","وَيَنْضِحُ ٱلْكَاهِنُ بِإِصْبَعِهِ ٱلْيُمْنَى مِنَ ٱلزَّيْتِ ٱلَّذِي فِي كَفِّهِ ٱلْيُسْرَى سَبْعَ مَرَّاتٍ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","وَيَجْعَلُ ٱلْكَاهِنُ مِنَ ٱلزَّيْتِ ٱلَّذِي فِي كَفِّهِ عَلَى شَحْمَةِ أُذُنِ ٱلْمُتَطَهِّرِ ٱلْيُمْنَى، وَعَلَى إِبْهَامِ يَدِهِ ٱلْيُمْنَى، وَعَلَى إِبْهَامِ رِجْلِهِ ٱلْيُمْنَى، عَلَى مَوْضِعِ دَمِ ذَبِيحَةِ ٱلْإِثْمِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","وَٱلْفَاضِلُ مِنَ ٱلزَّيْتِ ٱلَّذِي فِي كَفِّ ٱلْكَاهِنِ يَجْعَلُهُ عَلَى رَأْسِ ٱلْمُتَطَهِّرِ تَكْفِيرًا عَنْهُ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ثُمَّ يَعْمَلُ وَاحِدَةً مِنَ ٱلْيَمَامَتَيْنِ أَوْ مِنْ فَرْخَيِ ٱلْحَمَامِ، مِمَّا تَنَالُ يَدُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","مَا تَنَالُ يَدُهُ: ٱلْوَاحِدَ ذَبِيحَةَ خَطِيَّةٍ، وَٱلْآخَرَ مُحْرَقَةً مَعَ ٱلتَّقْدِمَةِ. وَيُكَفِّرُ ٱلْكَاهِنُ عَنِ ٱلْمُتَطَهِّرِ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","هَذِهِ شَرِيعَةُ ٱلَّذِي فِيهِ ضَرْبَةُ بَرَصٍ ٱلَّذِي لَا تَنَالُ يَدُهُ فِي تَطْهِيرِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«مَتَى جِئْتُمْ إِلَى أَرْضِ كَنْعَانَ ٱلَّتِي أُعْطِيكُمْ مُلْكًا، وَجَعَلْتُ ضَرْبَةَ بَرَصٍ فِي بَيْتٍ فِي أَرْضِ مُلْكِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","يَأْتِي ٱلَّذِي لَهُ ٱلْبَيْتُ، وَيُخبِرُ ٱلْكَاهِنَ قَائِلًا: قَدْ ظَهَرَ لِي شِبْهُ ضَرْبَةٍ فِي ٱلْبَيْتِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","فَيَأْمُرُ ٱلْكَاهِنُ أَنْ يُفْرِغُوا ٱلْبَيْتَ قَبْلَ دُخُولِ ٱلْكَاهِنِ لِيَرَى ٱلضَّرْبَةَ، لِئَلَّا يَتَنَجَّسَ كُلُّ مَا فِي ٱلْبَيْتِ. وَبَعْدَ ذَلِكَ يَدْخُلُ ٱلْكَاهِنُ لِيَرَى ٱلْبَيْتَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","فَإِذَا رَأَى ٱلضَّرْبَةَ، وَإِذَا ٱلضَّرْبَةُ فِي حِيطَانِ ٱلْبَيْتِ نُقَرٌ ضَارِبَةٌ إِلَى ٱلْخُضْرَةِ أَوْ إِلَى ٱلْحُمْرَةِ، وَمَنْظَرُهَا أَعْمَقُ مِنَ ٱلْحَائِطِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","يَخْرُجُ ٱلْكَاهِنُ مِنَ ٱلْبَيْتِ إِلَى بَابِ ٱلْبَيْتِ، وَيُغْلِقُ ٱلْبَيْتَ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","فَإِذَا رَجَعَ ٱلْكَاهِنُ فِي ٱلْيَوْمِ ٱلسَّابِعِ وَرَأَى وَإِذَا ٱلضَّرْبَةُ قَدِ ٱمْتَدَّتْ فِي حِيطَانِ ٱلْبَيْتِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","يَأْمُرُ ٱلْكَاهِنُ أَنْ يَقْلَعُوا ٱلْحِجَارَةَ ٱلَّتِي فِيهَا ٱلضَّرْبَةُ وَيَطْرَحُوهَا خَارِجَ ٱلْمَدِينَةِ فِي مَكَانٍ نَجِسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","وَيُقَشِّرُ ٱلْبَيْتَ مِنْ دَاخِلٍ حَوَالَيْهِ، وَيَطْرَحُونَ ٱلتُّرَابَ ٱلَّذِي يُقَشِّرُونَهُ خَارِجَ ٱلْمَدِينَةِ فِي مَكَانٍ نَجِسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","وَيَأْخُذُونَ حِجَارَةً أُخْرَى وَيُدْخِلُونَهَا فِي مَكَانِ ٱلْحِجَارَةِ، وَيَأْخُذُ تُرَابًا آخَرَ وَيُطَيِّنُ ٱلْبَيْتَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","فَإِنْ رَجَعَتِ ٱلضَّرْبَةُ وَأَفْرَخَتْ فِي ٱلْبَيْتِ بَعْدَ قَلْعِ ٱلْحِجَارَةِ وَقَشْرِ ٱلْبَيْتِ وَتَطْيِينِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","وَأَتَى ٱلْكَاهِنُ وَرَأَى وَإِذَا ٱلضَّرْبَةُ قَدِ ٱمْتَدَّتْ فِي ٱلْبَيْتِ، فَهِيَ بَرَصٌ مُفْسِدٌ فِي ٱلْبَيْتِ. إِنَّهُ نَجِسٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","فَيَهْدِمُ ٱلْبَيْتَ: حِجَارَتَهُ وَأَخْشَابَهُ وَكُلَّ تُرَابِ ٱلْبَيْتِ، وَيُخْرِجُهَا إِلَى خَارِجِ ٱلْمَدِينَةِ إِلَى مَكَانٍ نَجِسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","وَمَنْ دَخَلَ إِلَى ٱلْبَيْتِ فِي كُلِّ أَيَّامِ ٱنْغِلَاقِهِ، يَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","وَمَنْ نَامَ فِي ٱلْبَيْتِ يَغْسِلُ ثِيَابَهُ. وَمَنْ أَكَلَ فِي ٱلْبَيْتِ يَغْسِلُ ثِيَابَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","لَكِنْ إِنْ أَتَى ٱلْكَاهِنُ وَرَأَى وَإِذَا ٱلضَّرْبَةُ لَمْ تَمْتَدَّ فِي ٱلْبَيْتِ بَعْدَ تَطْيِينِ ٱلْبَيْتِ، يُطَهِّرُ ٱلْكَاهِنُ ٱلْبَيْتَ. لِأَنَّ ٱلضَّرْبَةَ قَدْ بَرِئَتْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","فَيَأْخُذُ لِتَطْهِيرِ ٱلْبَيْتِ عُصْفُورَيْنِ وَخَشَبَ أَرْزٍ وَقِرْمِزًا وَزُوفَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","وَيَذْبَحُ ٱلْعُصْفُورَ ٱلْوَاحِدَ فِي إِنَاءِ خَزَفٍ عَلَى مَاءٍ حَيٍّ، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","وَيَأْخُذُ خَشَبَ ٱلْأَرْزِ وَٱلزُّوفَا وَٱلْقِرْمِزَ وَٱلْعُصْفُورَ ٱلْحَيَّ وَيَغْمِسُهَا فِي دَمِ ٱلْعُصْفُورِ ٱلْمَذْبُوحِ وَفِي ٱلْمَاءِ ٱلْحَيِّ، وَيَنْضِحُ ٱلْبَيْتَ سَبْعَ مَرَّاتٍ، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","وَيُطَهِّرُ ٱلْبَيْتَ بِدَمِ ٱلْعُصْفُورِ وَبِٱلْمَاءِ ٱلْحَيِّ وَبِٱلْعُصْفُورِ ٱلْحَيِّ وَبِخَشَبِ ٱلْأَرْزِ وَبِالزُّوفَا وَبِالْقِرْمِزِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ثُمَّ يُطْلِقُ ٱلْعُصْفُورَ ٱلْحَيَّ إِلَى خَارِجِ ٱلْمَدِينَةِ عَلَى وَجْهِ ٱلصَّحْرَاءِ وَيُكَفِّرُ عَنِ ٱلْبَيْتِ فَيَطْهُرُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","«هَذِهِ هِيَ ٱلشَّرِيعَةُ لِكُلِّ ضَرْبَةٍ مِنَ ٱلْبَرَصِ وَلِلْقَرَعِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","وَلِبَرَصِ ٱلثَّوْبِ وَٱلْبَيْتِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","وَلِلنَّاتِئِ وَلِلْقُوبَاءِ وَلِلُّمْعَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","لِلتَّعْلِيمِ فِي يَوْمِ ٱلنَّجَاسَةِ وَيَوْمِ ٱلطَّهَارَةِ. هَذِهِ شَرِيعَةُ ٱلْبَرَصِ». ");
INSERT INTO arb_vd_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«كَلِّمَا بَنِي إِسْرَائِيلَ وَقُولَا لَهُمْ: كُلُّ رَجُلٍ يَكُونُ لَهُ سَيْلٌ مِنْ لَحْمِهِ، فَسَيْلُهُ نَجِسٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","وَهَذِهِ تَكُونُ نَجَاسَتُهُ بِسَيْلِهِ: إِنْ كَانَ لَحْمُهُ يَبْصُقُ سَيْلَهُ، أَوْ يَحْتَبِسُ لَحْمُهُ عَنْ سَيْلِهِ، فَذَلِكَ نَجَاسَتُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","كُلُّ فِرَاشٍ يَضْطَجِعُ عَلَيْهِ ٱلَّذِي لَهُ ٱلسَّيْلُ يَكُونُ نَجِسًا، وَكُلُّ مَتَاعٍ يَجْلِسُ عَلَيْهِ يَكُونُ نَجِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","وَمَنْ مَسَّ فِرَاشَهُ يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","وَمَنْ جَلَسَ عَلَى ٱلْمَتَاعِ ٱلَّذِي يَجْلِسُ عَلَيْهِ ذُو ٱلسَّيْلِ، يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","وَمَنْ مَسَّ لَحْمَ ذِي ٱلسَّيْلِ يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","وَإِنْ بَصَقَ ذُو ٱلسَّيْلِ عَلَى طَاهِرٍ، يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","وَكُلُّ مَا يَرْكَبُ عَلَيْهِ ذُو ٱلسَّيْلِ يَكُونُ نَجِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","وَكُلُّ مَنْ مَسَّ كُلَّ مَا كَانَ تَحْتَهُ يَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ، وَمَنْ حَمَلَهُنَّ يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","وَكُلُّ مَنْ مَسَّهُ ذُو ٱلسَّيْلِ وَلَمْ يَغْسِلْ يَدَيْهِ بِمَاءٍ، يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","وَإِنَاءُ ٱلْخَزَفِ ٱلَّذِي يَمَسُّهُ ذُو ٱلسَّيْلِ يُكْسَرُ. وَكُلُّ إِنَاءِ خَشَبٍ يُغْسَلُ بِمَاءٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","وَإِذَا طَهُرَ ذُو ٱلسَّيْلِ مِنْ سَيْلِهِ، يُحْسَبُ لَهُ سَبْعَةُ أَيَّامٍ لِطُهْرِهِ، وَيَغْسِلُ ثِيَابَهُ وَيَرْحَضُ جَسَدَهُ بِمَاءٍ حَيٍّ فَيَطْهُرُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","وَفِي ٱلْيَوْمِ ٱلثَّامِنِ يَأْخُذُ لِنَفْسِهِ يَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ، وَيَأْتِي إِلَى أَمَامِ ٱلرَّبِّ، إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ، وَيُعْطِيهِمَا لِلْكَاهِنِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","فَيَعْمَلُهُمَا ٱلْكَاهِنُ: ٱلْوَاحِدَ ذَبِيحَةَ خَطِيَّةٍ، وَٱلْآخَرَ مُحْرَقَةً. وَيُكَفِّرُ عَنْهُ ٱلْكَاهِنُ أَمَامَ ٱلرَّبِّ مِنْ سَيْلِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«وَإِذَا حَدَثَ مِنْ رَجُلٍ ٱضْطِجَاعُ زَرْعٍ، يَرْحَضُ كُلَّ جَسَدِهِ بِمَاءٍ، وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","وَكُلُّ ثَوْبٍ وَكُلُّ جِلْدٍ يَكُونُ عَلَيْهِ ٱضْطِجَاعُ زَرْعٍ يُغْسَلُ بِمَاءٍ، وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","وَٱلْمَرْأَةُ ٱلَّتِي يَضْطَجِعُ مَعَهَا رَجُلٌ ٱضْطِجَاعَ زَرْعٍ، يَسْتَحِمَّانِ بِمَاءٍ، وَيَكُونَانِ نَجِسَيْنِ إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«وَإِذَا كَانَتِ ٱمْرَأَةٌ لَهَا سَيْلٌ، وَكَانَ سَيْلُهَا دَمًا فِي لَحْمِهَا، فَسَبْعَةَ أَيَّامٍ تَكُونُ فِي طَمْثِهَا. وَكُلُّ مَنْ مَسَّهَا يَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","وَكُلُّ مَا تَضْطَجِعُ عَلَيْهِ فِي طَمْثِهَا يَكُونُ نَجِسًا، وَكُلُّ مَا تَجْلِسُ عَلَيْهِ يَكُونُ نَجِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","وَكُلُّ مَنْ مَسَّ فِرَاشَهَا يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","وَكُلُّ مَنْ مَسَّ مَتَاعًا تَجْلِسُ عَلَيْهِ، يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","وَإِنْ كَانَ عَلَى ٱلْفِرَاشِ أَوْ عَلَى ٱلْمَتَاعِ ٱلَّذِي هِيَ جَالِسَةٌ عَلَيْهِ عِنْدَمَا يَمَسُّهُ، يَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","وَإِنِ ٱضْطَجَعَ مَعَهَا رَجُلٌ فَكَانَ طَمْثُهَا عَلَيْهِ يَكُونُ نَجِسًا سَبْعَةَ أَيَّامٍ. وَكُلُّ فِرَاشٍ يَضْطَجِعُ عَلَيْهِ يَكُونُ نَجِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«وَإِذَا كَانَتِ ٱمْرَأَةٌ يَسِيلُ سَيْلُ دَمِهَا أَيَّامًا كَثِيرَةً فِي غَيْرِ وَقْتِ طَمْثِهَا، أَوْ إِذَا سَالَ بَعْدَ طَمْثِهَا، فَتَكُونُ كُلَّ أَيَّامِ سَيَلَانِ نَجَاسَتِهَا كَمَا فِي أَيَّامِ طَمْثِهَا. إِنَّهَا نَجِسَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","كُلُّ فِرَاشٍ تَضْطَجِعُ عَلَيْهِ كُلَّ أَيَّامِ سَيْلِهَا يَكُونُ لَهَا كَفِرَاشِ طَمْثِهَا. وَكُلُّ ٱلْأَمْتِعَةِ ٱلَّتِي تَجْلِسُ عَلَيْهَا تَكُونُ نَجِسَةً كَنَجَاسَةِ طَمْثِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","وَكُلُّ مَنْ مَسَّهُنَّ يَكُونُ نَجِسًا، فَيَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","وَإِذَا طَهُرَتْ مِنْ سَيْلِهَا تَحْسُبُ، لِنَفْسِهَا سَبْعَةَ أَيَّامٍ ثُمَّ تَطْهُرُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","وَفِي ٱلْيَوْمِ ٱلثَّامِنِ تَأْخُذُ لِنَفْسِهَا يَمَامَتَيْنِ أَوْ فَرْخَيْ حَمَامٍ، وَتَأْتِي بِهِمَا إِلَى ٱلْكَاهِنِ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","فَيَعْمَلُ ٱلْكَاهِنُ: ٱلْوَاحِدَ ذَبِيحَةَ خَطِيَّةٍ، وَٱلْآخَرَ مُحْرَقَةً. وَيُكَفِّرُ عَنْهَا ٱلْكَاهِنُ أَمَامَ ٱلرَّبِّ مِنْ سَيْلِ نَجَاسَتِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","فَتَعْزِلَانِ بَنِي إِسْرَائِيلَ عَنْ نَجَاسَتِهِمْ لِئَلَّا يَمُوتُوا فِي نَجَاسَتِهِمْ بِتَنْجِيسِهِمْ مَسْكَنِيَ ٱلَّذِي فِي وَسَطِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","«هَذِهِ شَرِيعَةُ ذِي ٱلسَّيْلِ، وَٱلَّذِي يَحْدُثُ مِنْهُ ٱضْطِجَاعُ زَرْعٍ فَيَتَنَجَّسُ بِهَا، ");
INSERT INTO arb_vd_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","وَٱلْعَلِيلَةِ فِي طَمْثِهَا، وَٱلسَّائِلِ سَيْلُهُ: ٱلذَّكَرِ وَٱلْأُنْثَى، وَٱلرَّجُلِ ٱلَّذِي يَضْطَجِعُ مَعَ نَجِسَةٍ». ");
INSERT INTO arb_vd_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى بَعْدَ مَوْتِ ٱبْنَيْ هَارُونَ عِنْدَمَا ٱقْتَرَبَا أَمَامَ ٱلرَّبِّ وَمَاتَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","وَقَالَ ٱلرَّبُّ لِمُوسَى: «كَلِّمْ هَارُونَ أَخَاكَ أَنْ لَا يَدْخُلَ كُلَّ وَقْتٍ إِلَى ٱلْقُدْسِ دَاخِلَ ٱلْحِجَابِ أَمَامَ ٱلْغِطَاءِ ٱلَّذِي عَلَى ٱلتَّابُوتِ لِئَلَّا يَمُوتَ، لِأَنِّي فِي ٱلسَّحَابِ أَتَرَاءَى عَلَى ٱلْغِطَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","بِهَذَا يَدْخُلُ هَارُونُ إِلَى ٱلْقُدْسِ: بِثَوْرِ ٱبْنِ بَقَرٍ لِذَبِيحَةِ خَطِيَّةٍ، وَكَبْشٍ لِمُحْرَقَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","يَلْبَسُ قَمِيصَ كَتَّانٍ مُقَدَّسًا، وَتَكُونُ سَرَاوِيلُ كَتَّانٍ عَلَى جَسَدِهِ، وَيَتَنَطَّقُ بِمِنْطَقَةِ كَتَّانٍ، وَيَتَعَمَّمُ بِعِمَامَةِ كَتَّانٍ. إِنَّهَا ثِيَابٌ مُقَدَّسَةٌ. فَيَرْحَضُ جَسَدَهُ بِمَاءٍ وَيَلْبَسُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","وَمِنْ جَمَاعَةِ بَنِي إِسْرَائِيلَ يَأْخُذُ تَيْسَيْنِ مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، وَكَبْشًا وَاحِدًا لِمُحْرَقَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","وَيُقَرِّبُ هَارُونُ ثَوْرَ ٱلْخَطِيَّةِ ٱلَّذِي لَهُ، وَيُكَفِّرُ عَنْ نَفْسِهِ وَعَنْ بَيْتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","وَيَأْخُذُ ٱلتَّيْسَيْنِ وَيُوقِفُهُمَا أَمَامَ ٱلرَّبِّ لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","وَيُلْقِي هَارُونُ عَلَى ٱلتَّيْسَيْنِ قُرْعَتَيْنِ: قُرْعَةً لِلرَّبِّ وَقُرْعَةً لِعَزَازِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","وَيُقَرِّبُ هَارُونُ ٱلتَّيْسَ ٱلَّذِي خَرَجَتْ عَلَيْهِ ٱلْقُرْعَةُ لِلرَّبِّ وَيَعْمَلُهُ ذَبِيحَةَ خَطِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","وَأَمَّا ٱلتَّيْسُ ٱلَّذِي خَرَجَتْ عَلَيْهِ ٱلْقُرْعَةُ لِعَزَازِيلَ فَيُوقَفُ حَيًّا أَمَامَ ٱلرَّبِّ، لِيُكَفِّرَ عَنْهُ لِيُرْسِلَهُ إِلَى عَزَازِيلَ إِلَى ٱلْبَرِّيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«وَيُقَدِّمُ هَارُونُ ثَوْرَ ٱلْخَطِيَّةِ ٱلَّذِي لَهُ وَيُكَفِّرُ عَنْ نَفْسِهِ وَعَنْ بَيْتِهِ، وَيَذْبَحُ ثَوْرَ ٱلْخَطِيَّةِ ٱلَّذِي لَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","وَيَأْخُذُ مِلْءَ ٱلْمَجْمَرَةِ جَمْرَ نَارٍ عَنِ ٱلْمَذْبَحِ مِنْ أَمَامِ ٱلرَّبِّ، وَمِلْءَ رَاحَتَيْهِ بَخُورًا عَطِرًا دَقِيقًا، وَيَدْخُلُ بِهِمَا إِلَى دَاخِلِ ٱلْحِجَابِ ");
INSERT INTO arb_vd_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","وَيَجْعَلُ ٱلْبَخُورَ عَلَى ٱلنَّارِ أَمَامَ ٱلرَّبِّ، فَتُغَشِّي سَحَابَةُ ٱلْبَخُورِ ٱلْغِطَاءَ ٱلَّذِي عَلَى ٱلشَّهَادَةِ فَلَا يَمُوتُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ثُمَّ يَأْخُذُ مِنْ دَمِ ٱلثَّوْرِ وَيَنْضِحُ بِإِصْبَعِهِ عَلَى وَجْهِ ٱلْغِطَاءِ إِلَى ٱلشَّرْقِ. وَقُدَّامَ ٱلْغِطَاءِ يَنْضِحُ سَبْعَ مَرَّاتٍ مِنَ ٱلدَّمِ بِإِصْبَعِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«ثُمَّ يَذْبَحُ تَيْسَ ٱلْخَطِيَّةِ ٱلَّذِي لِلشَّعْبِ، وَيَدْخُلُ بِدَمِهِ إِلَى دَاخِلِ ٱلْحِجَابِ. وَيَفْعَلُ بِدَمِهِ كَمَا فَعَلَ بِدَمِ ٱلثَّوْرِ: يَنْضِحُهُ عَلَى ٱلْغِطَاءِ وَقُدَّامَ ٱلْغِطَاءِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","فَيُكَفِّرُ عَنِ ٱلْقُدْسِ مِنْ نَجَاسَاتِ بَنِي إِسْرَائِيلَ وَمِنْ سَيِّئَاتِهِمْ مَعَ كُلِّ خَطَايَاهُمْ. وَهَكَذَا يَفْعَلُ لِخَيْمَةِ ٱلِٱجْتِمَاعِ ٱلْقَائِمَةِ بَيْنَهُمْ فِي وَسَطِ نَجَاسَاتِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","وَلَا يَكُنْ إِنْسَانٌ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ مِنْ دُخُولِهِ لِلتَّكْفِيرِ فِي ٱلْقُدْسِ إِلَى خُرُوجِهِ، فَيُكَفِّرُ عَنْ نَفْسِهِ وَعَنْ بَيْتِهِ وَعَنْ كُلِّ جَمَاعَةِ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ثُمَّ يَخْرُجُ إِلَى ٱلْمَذْبَحِ ٱلَّذِي أَمَامَ ٱلرَّبِّ وَيُكَفِّرُ عَنْهُ. يَأْخُذُ مِنْ دَمِ ٱلثَّوْرِ وَمِنْ دَمِ ٱلتَّيْسِ وَيَجْعَلُ عَلَى قُرُونِ ٱلْمَذْبَحِ مُسْتَدِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","وَيَنْضِحُ عَلَيْهِ مِنَ ٱلدَّمِ بِإِصْبَعِهِ سَبْعَ مَرَّاتٍ، وَيُطَهِّرُهُ وَيُقَدِّسُهُ مِنْ نَجَاسَاتِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«وَمَتَى فَرَغَ مِنَ ٱلتَّكْفِيرِ عَنِ ٱلْقُدْسِ وَعَنْ خَيْمَةِ ٱلِٱجْتِمَاعِ وَعَنِ ٱلْمَذْبَحِ، يُقَدِّمُ ٱلتَّيْسَ ٱلْحَيَّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","وَيَضَعُ هَارُونُ يَدَيْهِ عَلَى رَأْسِ ٱلتَّيْسِ ٱلْحَيِّ وَيُقِرُّ عَلَيْهِ بِكُلِّ ذُنُوبِ بَنِي إِسْرَائِيلَ، وَكُلِّ سَيِّئَاتِهِمْ مَعَ كُلِّ خَطَايَاهُمْ، وَيَجْعَلُهَا عَلَى رَأْسِ ٱلتَّيْسِ، وَيُرْسِلُهُ بِيَدِ مَنْ يُلَاقِيهِ إِلَى ٱلْبَرِّيَّةِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","لِيَحْمِلَ ٱلتَّيْسُ عَلَيْهِ كُلَّ ذُنُوبِهِمْ إِلَى أَرْضٍ مُقْفِرَةٍ، فَيُطْلِقُ ٱلتَّيْسَ فِي ٱلْبَرِّيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","ثُمَّ يَدْخُلُ هَارُونُ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ وَيَخْلَعُ ثِيَابَ ٱلْكَتَّانِ ٱلَّتِي لَبِسَهَا عِنْدَ دُخُولِهِ إِلَى ٱلْقُدْسِ وَيَضَعُهَا هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","وَيَرْحَضُ جَسَدَهُ بِمَاءٍ فِي مَكَانٍ مُقَدَّسٍ، ثُمَّ يَلْبَسُ ثِيَابَهُ وَيَخْرُجُ وَيَعْمَلُ مُحْرَقَتَهُ وَمُحْرَقَةَ ٱلشَّعْبِ، وَيُكَفِّرُ عَنْ نَفْسِهِ وَعَنِ ٱلشَّعْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","وَشَحْمُ ذَبِيحَةِ ٱلْخَطِيَّةِ يُوقِدُهُ عَلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","وَٱلَّذِي أَطْلَقَ ٱلتَّيْسَ إِلَى عَزَازِيلَ يَغْسِلُ ثِيَابَهُ وَيَرْحَضُ جَسَدَهُ بِمَاءٍ، وَبَعْدَ ذَلِكَ يَدْخُلُ إِلَى ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","وَثَوْرُ ٱلْخَطِيَّةِ وَتَيْسُ ٱلْخَطِيَّةِ ٱللَّذَانِ أُتِيَ بِدَمِهِمَا لِلتَّكْفِيرِ فِي ٱلْقُدْسِ يُخْرِجُهُمَا إِلَى خَارِجِ ٱلْمَحَلَّةِ، وَيُحْرِقُونَ بِٱلنَّارِ جِلْدَيْهِمَا وَلَحْمَهُمَا وَفَرْثَهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","وَٱلَّذِي يُحْرِقُهُمَا يَغْسِلُ ثِيَابَهُ وَيَرْحَضُ جَسَدَهُ بِمَاءٍ، وَبَعْدَ ذَلِكَ يَدْخُلُ إِلَى ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«وَيَكُونُ لَكُمْ فَرِيضَةً دَهْرِيَّةً، أَنَّكُمْ فِي ٱلشَّهْرِ ٱلسَّابِعِ فِي عَاشِرِ ٱلشَّهْرِ تُذَلِّلُونَ نُفُوسَكُمْ، وَكُلَّ عَمَلٍ لَا تَعْمَلُونَ: ٱلْوَطَنِيُّ وَٱلْغَرِيبُ ٱلنَّازِلُ فِي وَسَطِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","لِأَنَّهُ فِي هَذَا ٱلْيَوْمِ يُكَفِّرُ عَنْكُمْ لِتَطْهِيرِكُمْ. مِنْ جَمِيعِ خَطَايَاكُمْ أَمَامَ ٱلرَّبِّ تَطْهُرُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","سَبْتُ عُطْلَةٍ هُوَ لَكُمْ، وَتُذَلِّلُونَ نُفُوسَكُمْ فَرِيضَةً دَهْرِيَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","وَيُكَفِّرُ ٱلْكَاهِنُ ٱلَّذِي يَمْسَحُهُ، وَٱلَّذِي يَمْلَأُ يَدَهُ لِلْكَهَانَةِ عِوَضًا عَنْ أَبِيهِ. يَلْبَسُ ثِيَابَ ٱلْكَتَّانِ، ٱلثِّيَابَ ٱلْمُقَدَّسَةَ، ");
INSERT INTO arb_vd_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","وَيُكَفِّرُ عَنْ مَقْدِسِ ٱلْقُدْسِ. وَعَنْ خَيْمَةِ ٱلِٱجْتِمَاعِ وَٱلْمَذْبَحِ يُكَفِّرُ. وَعَنِ ٱلْكَهَنَةِ وَكُلِّ شَعْبِ ٱلْجَمَاعَةِ يُكَفِّرُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","وَتَكُونُ هَذِهِ لَكُمْ فَرِيضَةً دَهْرِيَّةً لِلتَّكْفِيرِ عَنْ بَنِي إِسْرَائِيلَ مِنْ جَمِيعِ خَطَايَاهُمْ مَرَّةً فِي ٱلسَّنَةِ». فَفَعَلَ كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«كَلِّمْ هَارُونَ وَبَنِيهِ وَجَمِيعَ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: هَذَا هُوَ ٱلْأَمْرُ ٱلَّذِي يُوصِي بِهِ ٱلرَّبُّ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","كُلُّ إِنْسَانٍ مِنْ بَيْتِ إِسْرَائِيلَ يَذْبَحُ بَقَرًا أَوْ غَنَمًا أَوْ مِعْزًى فِي ٱلْمَحَلَّةِ، أَوْ يَذْبَحُ خَارِجَ ٱلْمَحَلَّةِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","وَإِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ لَا يَأْتِي بِهِ لِيُقَرِّبَ قُرْبَانًا لِلرَّبِّ أَمَامَ مَسْكَنِ ٱلرَّبِّ، يُحْسَبُ عَلَى ذَلِكَ ٱلْإِنْسَانِ دَمٌ. قَدْ سَفَكَ دَمًا. فَيُقْطَعُ ذَلِكَ ٱلْإِنْسَانُ مِنْ شَعْبِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","لِكَيْ يَأْتِيَ بَنُو إِسْرَائِيلَ بِذَبَائِحِهِمِ ٱلَّتِي يَذْبَحُونَهَا عَلَى وَجْهِ ٱلصَّحْرَاءِ وَيُقَدِّمُوهَا لِلرَّبِّ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ إِلَى ٱلْكَاهِنِ، وَيَذْبَحُوهَا ذَبَائِحَ سَلَامَةٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","وَيَرُشُّ ٱلْكَاهِنُ ٱلدَّمَ عَلَى مَذْبَحِ ٱلرَّبِّ لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ، وَيُوقِدُ ٱلشَّحْمَ لِرَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","وَلَا يَذْبَحُوا بَعْدُ ذَبَائِحَهُمْ لِلتُّيُوسِ ٱلَّتِي هُمْ يَزْنُونَ وَرَاءَهَا. فَرِيضَةً دَهْرِيَّةً تَكُونُ هَذِهِ لَهُمْ فِي أَجْيَالِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«وَتَقُولُ لَهُمْ: كُلُّ إِنْسَانٍ مِنْ بَيْتِ إِسْرَائِيلَ وَمِنَ ٱلْغُرَبَاءِ ٱلَّذِينَ يَنْزِلُونَ فِي وَسَطِكُمْ يُصْعِدُ مُحْرَقَةً أَوْ ذَبِيحَةً، ");
INSERT INTO arb_vd_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","وَلَا يَأْتِي بِهَا إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ لِيَصْنَعَهَا لِلرَّبِّ، يُقْطَعُ ذَلِكَ ٱلْإِنْسَانُ مِنْ شَعْبِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","وَكُلُّ إِنْسَانٍ مِنْ بَيْتِ إِسْرَائِيلَ وَمِنَ ٱلْغُرَبَاءِ ٱلنَّازِلِينَ فِي وَسَطِكُمْ يَأْكُلُ دَمًا، أَجْعَلُ وَجْهِي ضِدَّ ٱلنَّفْسِ ٱلْآكِلَةِ ٱلدَّمِ وَأَقْطَعُهَا مِنْ شَعْبِهَا، ");
INSERT INTO arb_vd_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","لِأَنَّ نَفْسَ ٱلْجَسَدِ هِيَ فِي ٱلدَّمِ، فَأَنَا أَعْطَيْتُكُمْ إِيَّاهُ عَلَى ٱلْمَذْبَحِ لِلتَّكْفِيرِ عَنْ نُفُوسِكُمْ، لِأَنَّ ٱلدَّمَ يُكَفِّرُ عَنِ ٱلنَّفْسِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","لِذَلِكَ قُلْتُ لِبَنِي إِسْرَائِيلَ: لَا تَأْكُلْ نَفْسٌ مِنْكُمْ دَمًا، وَلَا يَأْكُلِ ٱلْغَرِيبُ ٱلنَّازِلُ فِي وَسَطِكُمْ دَمًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","وَكُلُّ إِنْسَانٍ مِنْ بَنِي إِسْرَائِيلَ وَمِنَ ٱلْغُرَبَاءِ ٱلنَّازِلِينَ فِي وَسَطِكُمْ يَصْطَادُ صَيْدًا، وَحْشًا أَوْ طَائِرًا يُؤْكَلُ، يَسْفِكُ دَمَهُ وَيُغَطِّيهِ بِٱلتُّرَابِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","لِأَنَّ نَفْسَ كُلِّ جَسَدٍ دَمُهُ هُوَ بِنَفْسِهِ، فَقُلْتُ لِبَنِي إِسْرَائِيلَ: لَا تَأْكُلُوا دَمَ جَسَدٍ مَّا، لِأَنَّ نَفْسَ كُلِّ جَسَدٍ هِيَ دَمُهُ. كُلُّ مَنْ أَكَلَهُ يُقْطَعُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","وَكُلُّ إِنْسَانٍ يَأْكُلُ مَيْتَةً أَوْ فَرِيسَةً، وَطَنِيًّا كَانَ أَوْ غَرِيبًا، يَغْسِلُ ثِيَابَهُ وَيَسْتَحِمُّ بِمَاءٍ، وَيَبْقَى نَجِسًا إِلَى ٱلْمَسَاءِ ثُمَّ يَكُونُ طَاهِرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","وَإِنْ لَمْ يَغْسِلْ وَلَمْ يَرْحَضْ جَسَدَهُ يَحْمِلْ ذَنْبَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","مِثْلَ عَمَلِ أَرْضِ مِصْرَ ٱلَّتِي سَكَنْتُمْ فِيهَا لَا تَعْمَلُوا، وَمِثْلَ عَمَلِ أَرْضِ كَنْعَانَ ٱلَّتِي أَنَا آتٍ بِكُمْ إِلَيْهَا لَا تَعْمَلُوا، وَحَسَبَ فَرَائِضِهِمْ لَا تَسْلُكُوا. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","أَحْكَامِي تَعْمَلُونَ، وَفَرَائِضِي تَحْفَظُونَ لِتَسْلُكُوا فِيهَا. أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","فَتَحْفَظُونَ فَرَائِضِي وَأَحْكَامِي، ٱلَّتِي إِذَا فَعَلَهَا ٱلْإِنْسَانُ يَحْيَا بِهَا. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«لَا يَقْتَرِبْ إِنْسَانٌ إِلَى قَرِيبِ جَسَدِهِ لِيَكْشِفَ ٱلْعَوْرَةَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","عَوْرَةَ أَبِيكَ وَعَوْرَةَ أُمِّكَ لَا تَكْشِفْ. إِنَّهَا أُمُّكَ لَا تَكْشِفْ عَوْرَتَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","عَوْرَةَ ٱمْرَأَةِ أَبِيكَ لَا تَكْشِفْ. إِنَّهَا عَوْرَةُ أَبِيكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","عَوْرَةَ أُخْتِكَ بِنْتِ أَبِيكَ أَوْ بِنْتِ أُمِّكَ، ٱلْمَوْلُودَةِ فِي ٱلْبَيْتِ أَوِ ٱلْمَوْلُودَةِ خَارِجًا، لَا تَكْشِفْ عَوْرَتَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","عَوْرَةَ ٱبْنَةِ ٱبْنِكَ، أَوِ ٱبْنَةِ بِنْتِكَ لَا تَكْشِفْ عَوْرَتَهَا. إِنَّهَا عَوْرَتُكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","عَوْرَةَ بِنْتِ ٱمْرَأَةِ أَبِيكَ ٱلْمَوْلُودَةِ مِنْ أَبِيكَ لَا تَكْشِفْ عَوْرَتَهَا. إِنَّهَا أُخْتُكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","عَوْرَةَ أُخْتِ أَبِيكَ لَا تَكْشِفْ. إِنَّهَا قَرِيبَةُ أَبِيكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","عَوْرَةَ أُخْتِ أُمِّكَ لَا تَكْشِفْ. إِنَّهَا قَرِيبَةُ أُمِّكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","عَوْرَةَ أَخِي أَبِيكَ لَا تَكْشِفْ. إِلَى ٱمْرَأَتِهِ لَا تَقْتَرِبْ. إِنَّهَا عَمَّتُكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","عَوْرَةَ كَنَّتِكَ لَا تَكْشِفْ. إِنَّهَا ٱمْرَأَةُ ٱبْنِكَ. لَا تَكْشِفْ عَوْرَتَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","عَوْرَةَ ٱمْرَأَةِ أَخِيكَ لَا تَكْشِفْ. إِنَّهَا عَوْرَةُ أَخِيكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","عَوْرَةَ ٱمْرَأَةٍ وَبِنْتِهَا لَا تَكْشِفْ. وَلَا تَأْخُذِ ٱبْنَةَ ٱبْنِهَا، أَوِ ٱبْنَةَ بِنْتِهَا لِتَكْشِفَ عَوْرَتَهَا. إِنَّهُمَا قَرِيبَتَاهَا. إِنَّهُ رَذِيلَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","وَلَا تَأْخُذِ ٱمْرَأَةً عَلَى أُخْتِهَا لِلضِّرِّ لِتَكْشِفَ عَوْرَتَهَا مَعَهَا فِي حَيَاتِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«وَلَا تَقْتَرِبْ إِلَى ٱمْرَأَةٍ فِي نَجَاسَةِ طَمْثِهَا لِتَكْشِفَ عَوْرَتَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","وَلَا تَجْعَلْ مَعَ ٱمْرَأَةِ صَاحِبِكَ مَضْجَعَكَ لِزَرْعٍ، فَتَتَنَجَّسَ بِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","وَلَا تُعْطِ مِنْ زَرْعِكَ لِلْإِجَازَةِ لِمُولَكَ لِئَلَّا تُدَنِّسَ ٱسْمَ إِلَهِكَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","وَلَا تُضَاجِعْ ذَكَرًا مُضَاجَعَةَ ٱمْرَأَةٍ. إِنَّهُ رِجْسٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","وَلَا تَجْعَلْ مَعَ بَهِيمَةٍ مَضْجَعَكَ فَتَتَنَجَّسَ بِهَا. وَلَا تَقِفِ ٱمْرَأَةٌ أَمَامَ بَهِيمَةٍ لِنِزَائِهَا. إِنَّهُ فَاحِشَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«بِكُلِّ هَذِهِ لَا تَتَنَجَّسُوا، لِأَنَّهُ بِكُلِّ هَذِهِ قَدْ تَنَجَّسَ ٱلشُّعُوبُ ٱلَّذِينَ أَنَا طَارِدُهُمْ مِنْ أَمَامِكُمْ ");
INSERT INTO arb_vd_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","فَتَنَجَّسَتِ ٱلْأَرْضُ. فَأَجْتَزِي ذَنْبَهَا مِنْهَا، فَتَقْذِفُ ٱلْأَرْضُ سُكَّانَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","لَكِنْ تَحْفَظُونَ أَنْتُمْ فَرَائِضِي وَأَحْكَامِي، وَلَا تَعْمَلُونَ شَيْئًا مِنْ جَمِيعِ هَذِهِ ٱلرَّجَسَاتِ، لَا ٱلْوَطَنِيُّ وَلَا ٱلْغَرِيبُ ٱلنَّازِلُ فِي وَسَطِكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","لِأَنَّ جَمِيعَ هَذِهِ ٱلرَّجَسَاتِ قَدْ عَمِلَهَا أَهْلُ ٱلْأَرْضِ ٱلَّذِينَ قَبْلَكُمْ فَتَنَجَّسَتِ ٱلْأَرْضُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","فَلَا تَقْذِفُكُمُ ٱلْأَرْضُ بِتَنْجِيسِكُمْ إِيَّاهَا كَمَا قَذَفَتِ ٱلشُّعُوبَ ٱلَّتِي قَبْلَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","بَلْ كُلُّ مَنْ عَمِلَ شَيْئًا مِنْ جَمِيعِ هَذِهِ ٱلرَّجَسَاتِ تُقْطَعُ ٱلْأَنْفُسُ ٱلَّتِي تَعْمَلُهَا مِنْ شَعْبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","فَتَحْفَظُونَ شَعَائِرِي لِكَيْ لَا تَعْمَلُوا شَيْئًا مِنَ ٱلرُّسُومِ ٱلرَّجِسَةِ ٱلَّتِي عُمِلَتْ قَبْلَكُمْ وَلَا تَتَنَجَّسُوا بِهَا. أَنَا ٱلرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«كَلِّمْ كُلَّ جَمَاعَةِ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: تَكُونُونَ قِدِّيسِينَ لِأَنِّي قُدُّوسٌ ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","تَهَابُونَ كُلُّ إِنْسَانٍ أُمَّهُ وَأَبَاهُ، وَتَحْفَظُونَ سُبُوتِي. أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","لَا تَلْتَفِتُوا إِلَى ٱلْأَوْثَانِ، وَآلِهَةً مَسْبُوكَةً لَا تَصْنَعُوا لِأَنْفُسِكُمْ. أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","وَمَتَى ذَبَحْتُمْ ذَبِيحَةَ سَلَامَةٍ لِلرَّبِّ فَلِلرِّضَا عَنْكُمْ تَذْبَحُونَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","يَوْمَ تَذْبَحُونَهَا تُؤْكَلُ، وَفِي ٱلْغَدِ. وَٱلْفَاضِلُ إِلَى ٱلْيَوْمِ ٱلثَّالِثِ يُحْرَقُ بِٱلنَّارِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","وَإِذَا أُكِلَتْ فِي ٱلْيَوْمِ ٱلثَّالِثِ فَذَلِكَ نَجَاسَةٌ لَا يُرْضَى بِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","وَمَنْ أَكَلَ مِنْهَا يَحْمِلُ ذَنْبَهُ لِأَنَّهُ قَدْ دَنَّسَ قُدْسَ ٱلرَّبِّ. فَتُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ شَعْبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«وَعِنْدَمَا تَحْصُدُونَ حَصِيدَ أَرْضِكُمْ لَا تُكَمِّلْ زَوَايَا حَقْلِكَ فِي ٱلْحَصَادِ. وَلُقَاطَ حَصِيدِكَ لَا تَلْتَقِطْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","وَكَرْمَكَ لَا تُعَلِّلْهُ، وَنِثَارَ كَرْمِكَ لَا تَلْتَقِطْ. لِلْمِسْكِينِ وَٱلْغَرِيبِ تَتْرُكُهُ. أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«لَا تَسْرِقُوا، وَلَا تَكْذِبُوا، وَلَا تَغْدُرُوا أَحَدُكُمْ بِصَاحِبِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","وَلَا تَحْلِفُوا بِٱسْمِي لِلْكَذِبِ، فَتُدَنِّسَ ٱسْمَ إِلَهِكَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«لَا تَغْصِبْ قَرِيبَكَ وَلَا تَسْلُبْ، وَلَا تَبِتْ أُجْرَةُ أَجِيرٍ عِنْدَكَ إِلَى ٱلْغَدِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","لَا تَشْتِمِ ٱلْأَصَمَّ، وَقُدَّامَ ٱلْأَعْمَى لَا تَجْعَلْ مَعْثَرَةً، بَلِ ٱخْشَ إِلَهَكَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","لَا تَرْتَكِبُوا جَوْرًا فِي ٱلْقَضَاءِ. لَاتَأْخُذُوا بِوَجْهِ مِسْكِينٍ وَلَا تَحْتَرِمْ وَجْهَ كَبِيرٍ. بِٱلْعَدْلِ تَحْكُمُ لِقَرِيبِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","لَا تَسْعَ فِي ٱلْوِشَايَةِ بَيْنَ شَعْبِكَ. لَا تَقِفْ عَلَى دَمِ قَرِيبِكَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","لَا تُبْغِضْ أَخَاكَ فِي قَلْبِكَ. إِنْذَارًا تُنْذِرُ صَاحِبَكَ، وَلَا تَحْمِلْ لِأَجْلِهِ خَطِيَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","لَا تَنْتَقِمْ وَلَا تَحْقِدْ عَلَى أَبْنَاءِ شَعْبِكَ، بَلْ تُحِبُّ قَرِيبَكَ كَنَفْسِكَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","فَرَائِضِي تَحْفَظُونَ. لَا تُنَزِّ بَهَائِمَكَ جِنْسَيْنِ، وَحَقْلَكَ لَا تَزْرَعْ صِنْفَيْنِ، وَلَا يَكُنْ عَلَيْكَ ثَوْبٌ مُصَنَّفٌ مِنْ صِنْفَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","وَإِذَا ٱضْطَجَعَ رَجُلٌ مَعَ ٱمْرَأَةٍ ٱضْطِجَاعَ زَرْعٍ وَهِيَ أَمَةٌ مَخْطُوبَةٌ لِرَجُلٍ، وَلَمْ تُفْدَ فِدَاءً وَلَا أُعْطِيَتْ حُرِّيَّتَهَا، فَلْيَكُنْ تَأْدِيبٌ. لَا يُقْتَلَا لِأَنَّهَا لَمْ تُعْتَقْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","وَيَأْتِي إِلَى ٱلرَّبِّ بِذَبِيحَةٍ لِإِثْمِهِ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ: كَبْشًا، ذَبِيحَةَ إِثْمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","فَيُكَفِّرُ عَنْهُ ٱلْكَاهِنُ بِكَبْشِ ٱلْإِثْمِ أَمَامَ ٱلرَّبِّ مِنْ خَطِيَّتِهِ ٱلَّتِي أَخْطَأَ، فَيُصْفَحُ لَهُ عَنْ خَطِيَّتِهِ ٱلَّتِي أَخْطَأَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«وَمَتَى دَخَلْتُمُ ٱلْأَرْضَ وَغَرَسْتُمْ كُلَّ شَجَرَةٍ لِلطَّعَامِ، تَحْسِبُونَ ثَمَرَهَا غُرْلَتَهَا. ثَلَاثَ سِنِينَ تَكُونُ لَكُمْ غَلْفَاءَ. لَا يُؤْكَلْ مِنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","وَفِي ٱلسَّنَةِ ٱلرَّابِعَةِ يَكُونُ كُلُّ ثَمَرِهَا قُدْسًا لِتَمْجِيدِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","وَفِي ٱلسَّنَةِ ٱلْخَامِسَةِ تَأْكُلُونَ ثَمَرَهَا، لِتَزِيدَ لَكُمْ غَلَّتَهَا. أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«لَا تَأْكُلُوا بِٱلدَّمِ. لَا تَتَفَاءَلُوا وَلَا تَعِيفُوا. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","لَا تُقَصِّرُوا رُؤُوسَكُمْ مُسْتَدِيرًا، وَلَا تُفْسِدْ عَارِضَيْكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","وَلَا تَجْرَحُوا أَجْسَادَكُمْ لِمَيْتٍ. وَكِتَابَةَ وَسْمٍ لَا تَجْعَلُوا فِيكُمْ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","لَا تُدَنِّسِ ٱبْنَتَكَ بِتَعْرِيضِهَا لِلزِّنَى لِئَلَّا تَزْنِيَ ٱلْأَرْضُ وَتَمْتَلِئَ ٱلْأَرْضُ رَذِيلَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","سُبُوتِي تَحْفَظُونَ، وَمَقْدِسِي تَهَابُونَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","لَا تَلْتَفِتُوا إِلَى ٱلْجَانِّ وَلَا تَطْلُبُوا ٱلتَّوَابِعَ، فَتَتَنَجَّسُوا بِهِمْ. أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","مِنْ أَمَامِ ٱلْأَشْيَبِ تَقُومُ وَتَحْتَرِمُ وَجْهَ ٱلشَّيْخِ، وَتَخْشَى إِلَهَكَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«وَإِذَا نَزَلَ عِنْدَكَ غَرِيبٌ فِي أَرْضِكُمْ فَلَا تَظْلِمُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","كَٱلْوَطَنِيِّ مِنْكُمْ يَكُونُ لَكُمُ ٱلْغَرِيبُ ٱلنَّازِلُ عِنْدَكُمْ، وَتُحِبُّهُ كَنَفْسِكَ، لِأَنَّكُمْ كُنْتُمْ غُرَبَاءَ فِي أَرْضِ مِصْرَ. أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","لَا تَرْتَكِبُوا جَوْرًا فِي ٱلْقَضَاءِ، لَا فِي ٱلْقِيَاسِ، وَلَا فِي ٱلْوَزْنِ، وَلَا فِي ٱلْكَيْلِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","مِيزَانُ حَقٍّ، وَوَزْنَاتُ حَقٍّ، وَإِيفَةُ حَقٍّ، وَهِينُ حَقٍّ تَكُونُ لَكُمْ. أَنَا ٱلرَّبُّ إِلَهُكُمُ ٱلَّذِي أَخْرَجَكُمْ مِنْ أَرْضِ مِصْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","فَتَحْفَظُونَ كُلَّ فَرَائِضِي، وَكُلَّ أَحْكَامِي، وَتَعْمَلُونَهَا. أَنَا ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«وَتَقُولُ لِبَنِي إِسْرَائِيلَ: كُلُّ إِنْسَانٍ مِنْ بَنِي إِسْرَائِيلَ وَمِنَ ٱلْغُرَبَاءِ ٱلنَّازِلِينَ فِي إِسْرَائِيلَ أَعْطَى مِنْ زَرْعِهِ لِمُولَكَ فَإِنَّهُ يُقْتَلُ. يَرْجُمُهُ شَعْبُ ٱلْأَرْضِ بِٱلْحِجَارَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","وَأَجْعَلُ أَنَا وَجْهِي ضِدَّ ذَلِكَ ٱلْإِنْسَانِ، وَأَقْطَعُهُ مِنْ شَعْبِهِ، لِأَنَّهُ أَعْطَى مِنْ زَرْعِهِ لِمُولَكَ لِكَيْ يُنَجِّسَ مَقْدِسِي، وَيُدَنِّسَ ٱسْمِيَ ٱلْقُدُّوسَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","وَإِنْ غَمَّضَ شَعْبُ ٱلْأَرْضِ أَعْيُنَهُمْ عَنْ ذَلِكَ ٱلْإِنْسَانِ عِنْدَمَا يُعْطِي مِنْ زَرْعِهِ لِمُولَكَ، فَلَمْ يَقْتُلُوهُ، ");
INSERT INTO arb_vd_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","فَإِنِّي أَضَعُ وَجْهِي ضِدَّ ذَلِكَ ٱلْإِنْسَانِ، وَضِدَّ عَشِيرَتِهِ، وَأَقْطَعُهُ وَجَمِيعَ ٱلْفَاجِرِينَ وَرَاءَهُ، بِٱلزِّنَى وَرَاءَ مُولَكَ مِنْ شَعْبِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","وَٱلنَّفْسُ ٱلَّتِي تَلْتَفِتُ إِلَى ٱلْجَانِّ، وَإِلَى ٱلتَّوَابِعِ لِتَزْنِيَ وَرَاءَهُمْ، أَجْعَلُ وَجْهِي ضِدَّ تِلْكَ ٱلنَّفْسِ وَأَقْطَعُهَا مِنْ شَعْبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","فَتَتَقَدَّسُونَ وَتَكُونُونَ قِدِّيسِينَ، لِأَنِّي أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","وَتَحْفَظُونَ فَرَائِضِي وَتَعْمَلُونَهَا. أَنَا ٱلرَّبُّ مُقَدِّسُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«كُلُّ إِنْسَانٍ سَبَّ أَبَاهُ أَوْ أُمَّهُ فَإِنَّهُ يُقْتَلُ. قَدْ سَبَّ أَبَاهُ أَوْ أُمَّهُ. دَمُهُ عَلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","وَإِذَا زَنَى رَجُلٌ مَعَ ٱمْرَأَةٍ، فَإِذَا زَنَى مَعَ ٱمْرَأَةِ قَرِيبِهِ، فَإِنَّهُ يُقْتَلُ ٱلزَّانِي وَٱلزَّانِيَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","وَإِذَا ٱضْطَجَعَ رَجُلٌ مَعَ ٱمْرَأَةِ أَبِيهِ، فَقَدْ كَشَفَ عَوْرَةَ أَبِيهِ. إِنَّهُمَا يُقْتَلَانِ كِلَاهُمَا. دَمُهُمَا عَلَيْهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","وَإِذَا ٱضْطَجَعَ رَجُلٌ مَعَ كَنَّتِهِ، فَإِنَّهُمَا يُقْتَلَانِ كِلَاهُمَا. قَدْ فَعَلَا فَاحِشَةً. دَمُهُمَا عَلَيْهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","وَإِذَا ٱضْطَجَعَ رَجُلٌ مَعَ ذَكَرٍ ٱضْطِجَاعَ ٱمْرَأَةٍ، فَقَدْ فَعَلَا كِلَاهُمَا رِجْسًا. إِنَّهُمَا يُقْتَلَانِ. دَمُهُمَا عَلَيْهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","وَإِذَا ٱتَّخَذَ رَجُلٌ ٱمْرَأَةً وَأُمَّهَا فَذَلِكَ رَذِيلَةٌ. بِٱلنَّارِ يُحْرِقُونَهُ وَإِيَّاهُمَا، لِكَيْ لَا يَكُونَ رَذِيلَةٌ بَيْنَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","وَإِذَا جَعَلَ رَجُلٌ مَضْجَعَهُ مَعَ بَهِيمَةٍ، فَإِنَّهُ يُقْتَلُ، وَٱلْبَهِيمَةُ تُمِيتُونَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","وَإِذَا ٱقْتَرَبَتِ ٱمْرَأَةٌ إِلَى بَهِيمَةٍ لِنِزَائِهَا، تُمِيتُ ٱلْمَرْأَةَ وَٱلْبَهِيمَةَ. إِنَّهُمَا يُقْتَلَانِ. دَمُهُمَا عَلَيْهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","وَإِذَا أَخَذَ رَجُلٌ أُخْتَهُ بِنْتَ أَبِيهِ أَوْ بِنْتَ أُمِّهِ، وَرَأَى عَوْرَتَهَا وَرَأَتْ هِيَ عَوْرَتَهُ، فَذَلِكَ عَارٌ. يُقْطَعَانِ أَمَامَ أَعْيُنِ بَنِي شَعْبِهِمَا. قَدْ كَشَفَ عَوْرَةَ أُخْتِهِ. يَحْمِلُ ذَنْبَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","وَإِذَا ٱضْطَجَعَ رَجُلٌ مَعَ ٱمْرَأَةٍ طَامِثٍ وَكَشَفَ عَوْرَتَهَا، عَرَّى يَنْبُوعَهَا وَكَشَفَتْ هِيَ يَنْبُوعَ دَمِهَا، يُقْطَعَانِ كِلَاهُمَا مِنْ شَعِبْهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","عَوْرَةَ أُخْتِ أُمِّكَ، أَوْ أُخْتِ أَبِيكَ لَا تَكْشِفْ. إِنَّهُ قَدْ عَرَّى قَرِيبَتَهُ. يَحْمِلَانِ ذَنْبَهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","وَإِذَا ٱضْطَجَعَ رَجُلٌ مَعَ ٱمْرَأَةِ عَمِّهِ فَقَدْ كَشَفَ عَوْرَةَ عَمِّهِ. يَحْمِلَانِ ذَنْبَهُمَا. يَمُوتَانِ عَقِيمَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","وَإِذَا أَخَذَ رَجُلٌ ٱمْرَأَةَ أَخِيهِ، فَذَلِكَ نَجَاسَةٌ. قَدْ كَشَفَ عَوْرَةَ أَخِيهِ. يَكُونَانِ عَقِيمَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«فَتَحْفَظُونَ جَمِيعَ فَرَائِضِي وَجَمِيعَ أَحْكَامِي، وَتَعْمَلُونَهَا لِكَيْ لَا تَقْذِفَكُمُ ٱلْأَرْضُ ٱلَّتِي أَنَا آتٍ بِكُمْ إِلَيْهَا لِتَسْكُنُوا فِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","وَلَا تَسْلُكُونَ فِي رُسُومِ ٱلشُّعُوبِ ٱلَّذِينَ أَنَا طَارِدُهُمْ مِنْ أَمَامِكُمْ. لِأَنَّهُمْ قَدْ فَعَلُوا كُلَّ هَذِهِ، فَكَرِهْتُهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","وَقُلْتُ لَكُمْ: تَرِثُونَ أَنْتُمْ أَرْضَهُمْ، وَأَنَا أُعْطِيكُمْ إِيَّاهَا لِتَرِثُوهَا، أَرْضًا تَفِيضُ لَبَنًا وَعَسَلًا. أَنَا ٱلرَّبُّ إِلَهُكُمُ ٱلَّذِي مَيَّزَكُمْ مِنَ ٱلشُّعُوبِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","فَتُمَيِّزُونَ بَيْنَ ٱلْبَهَائِمِ ٱلطَّاهِرَةِ وَٱلنَّجِسَةِ، وَبَيْنَ ٱلطُّيُورِ ٱلنَّجِسَةِ وَٱلطَّاهِرَةِ. فَلَا تُدَنِّسُوا نُفُوسَكُمْ بِٱلْبَهَائِمِ وَٱلطُّيُورِ، وَلَا بِكُلِّ مَا يَدِبُّ عَلَى ٱلْأَرْضِ مِمَّا مَيَّزْتُهُ لَكُمْ لِيَكُونَ نَجِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","وَتَكُونُونَ لِي قِدِّيسِينَ لِأَنِّي قُدُّوسٌ أَنَا ٱلرَّبُّ، وَقَدْ مَيَّزْتُكُمْ مِنَ ٱلشُّعُوبِ لِتَكُونُوا لِي. ");
INSERT INTO arb_vd_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«وَإِذَا كَانَ فِي رَجُلٍ أَوِ ٱمْرَأَةٍ جَانٌّ أَوْ تَابِعَةٌ فَإِنَّهُ يُقْتَلُ. بِٱلْحِجَارَةِ يَرْجُمُونَهُ. دَمُهُ عَلَيْهِ». ");
INSERT INTO arb_vd_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","وَقَالَ ٱلرَّبُّ لِمُوسَى: «كَلِّمِ ٱلْكَهَنَةَ بَنِي هَارُونَ وَقُلْ لَهُمْ: لَا يَتَنَجَّسْ أَحَدٌ مِنْكُمْ لِمَيْتٍ فِي قَوْمِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","إِلَّا لِأَقْرِبَائِهِ ٱلْأَقْرَبِ إِلَيْهِ: أُمِّهِ وَأَبِيهِ وَٱبْنِهِ وَٱبْنَتِهِ وَأَخِيهِ ");
INSERT INTO arb_vd_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","وَأُخْتِهِ ٱلْعَذْرَاءِ ٱلْقَرِيبَةِ إِلَيْهِ ٱلَّتِي لَمْ تَصِرْ لِرَجُلٍ. لِأَجْلِهَا يَتَنَجَّسُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","كَزَوْجٍ لَا يَتَنَجَّسْ بِأَهْلِهِ لِتَدْنِيسِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","لَا يَجْعَلُوا قَرْعَةً فِي رُؤُوسِهِمْ، وَلَا يَحْلِقُوا عَوَارِضَ لِحَاهُمْ، وَلَا يَجْرَحُوا جِرَاحَةً فِي أَجْسَادِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","مُقَدَّسِينَ يَكُونُونَ لِإِلَهِهِمْ، وَلَا يُدَنِّسُونَ ٱسْمَ إِلَهِهِمْ، لِأَنَّهُمْ يُقَرِّبُونَ وَقَائِدَ ٱلرَّبِّ طَعَامَ إِلَهِهِمْ، فَيَكُونُونَ قُدْسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","اِمْرَأَةً زَانِيَةً أَوْ مُدَنَّسَةً لَا يَأْخُذُوا، وَلَا يَأْخُذُوا ٱمْرَأَةً مُطَلَّقَةً مِنْ زَوْجِهَا. لِأَنَّهُ مُقَدَّسٌ لِإِلَهِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","فَتَحْسِبُهُ مُقَدَّسًا لِأَنَّهُ يُقَرِّبُ خُبْزَ إِلَهِكَ. مُقَدَّسًا يَكُونُ عِنْدَكَ لِأَنِّي قُدُّوسٌ أَنَا ٱلرَّبُّ مُقَدِّسُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","وَإِذَا تَدَنَّسَتِ ٱبْنَةُ كَاهِنٍ بِٱلزِّنَى فَقَدْ دَنَّسَتْ أَبَاهَا. بِٱلنَّارِ تُحْرَقُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«وَٱلْكَاهِنُ ٱلْأَعْظَمُ بَيْنَ إِخْوَتِهِ ٱلَّذِي صُبَّ عَلَى رَأْسِهِ دُهْنُ ٱلْمَسْحَةِ، وَمُلِئَتْ يَدُهُ لِيَلْبَسَ ٱلثِّيَابَ، لَا يَكْشِفُ رَأْسَهُ، وَلَا يَشُقُّ ثِيَابَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","وَلَا يَأْتِي إِلَى نَفْسٍ مَيْتَةٍ، وَلَا يَتَنَجَّسُ لِأَبِيهِ أَوْ أُمِّهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","وَلَا يَخْرُجُ مِنَ ٱلْمَقْدِسِ لِئَلَّا يُدَنِّسَ مَقْدِسَ إِلَهِهِ، لِأَنَّ إِكْلِيلَ دُهْنِ مَسْحَةِ إِلَهِهِ عَلَيْهِ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","هَذَا يَأْخُذُ ٱمْرَأَةً عَذْرَاءَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","أَمَّا ٱلْأَرْمَلَةُ وَٱلْمُطَلَّقَةُ وَٱلْمُدَنَّسَةُ وَٱلزَّانِيَةُ فَمِنْ هَؤُلَاءِ لَا يَأْخُذُ، بَلْ يَتَّخِذُ عَذْرَاءَ مِنْ قَوْمِهِ ٱمْرَأَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","وَلَا يُدَنِّسُ زَرْعَهُ بَيْنَ شَعْبِهِ لِأَنِّي أَنَا ٱلرَّبُّ مُقَدِّسُهُ». ");
INSERT INTO arb_vd_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«كَلِّمْ هَارُونَ قَائِلًا: إِذَا كَانَ رَجُلٌ مِنْ نَسْلِكَ فِي أَجْيَالِهِمْ فِيهِ عَيْبٌ فَلَا يَتَقَدَّمْ لِيُقَرِّبَ خُبْزَ إِلَهِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","لِأَنَّ كُلَّ رَجُلٍ فِيهِ عَيْبٌ لَا يَتَقَدَّمْ. لَا رَجُلٌ أَعْمَى وَلَا أَعْرَجُ، وَلَا أَفْطَسُ وَلَا زَوَائِدِيٌّ، ");
INSERT INTO arb_vd_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","وَلَا رَجُلٌ فِيهِ كَسْرُ رِجْلٍ أَوْ كَسْرُ يَدٍ، ");
INSERT INTO arb_vd_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","وَلَا أَحْدَبُ وَلَا أَكْشَمُ، وَلَا مَنْ فِي عَيْنِهِ بَيَاضٌ، وَلَا أَجْرَبُ وَلَا أَكْلَفُ، وَلَا مَرْضُوضُ ٱلْخُصَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","كُلُّ رَجُلٍ فِيهِ عَيْبٌ مِنْ نَسْلِ هَارُونَ ٱلْكَاهِنِ لَا يَتَقَدَّمْ لِيُقَرِّبَ وَقَائِدَ ٱلرَّبِّ. فِيهِ عَيْبٌ لَا يَتَقَدَّمْ لِيُقَرِّبَ خُبْزَ إِلَهِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","خُبْزَ إِلَهِهِ مِنْ قُدْسِ ٱلْأَقْدَاسِ وَمِنَ ٱلْقُدْسِ يَأْكُلُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","لَكِنْ إِلَى ٱلْحِجَابِ لَا يَأْتِي، وَإِلَى ٱلْمَذْبَحِ لَا يَقْتَرِبُ، لِأَنَّ فِيهِ عَيْبًا، لِئَلَّا يُدَنِّسَ مَقْدِسِي، لِأَنِّي أَنَا ٱلرَّبُّ مُقَدِّسُهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","فَكَلَّمَ مُوسَى هَارُونَ وَبَنِيهِ وَكُلَّ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«كَلِّمْ هَارُونَ وَبَنِيهِ أَنْ يَتَوَقَّوْا أَقْدَاسَ بَنِي إِسْرَائِيلَ ٱلَّتِي يُقَدِّسُونَهَا لِي وَلَا يُدَنِّسُوا ٱسْمِي ٱلْقُدُّوسَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","قُلْ لَهُمْ: فِي أَجْيَالِكُمْ كُلُّ إِنْسَانٍ مِنْ جَمِيعِ نَسْلِكُمُ ٱقْتَرَبَ إِلَى ٱلْأَقْدَاسِ ٱلَّتِي يُقَدِّسُهَا بَنُو إِسْرَائِيلَ لِلرَّبِّ، وَنَجَاسَتُهُ عَلَيْهِ، تُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ أَمَامِي. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","كُلُّ إِنْسَانٍ مِنْ نَسْلِ هَارُونَ وَهُوَ أَبْرَصُ أَوْ ذُو سَيْلٍ، لَا يَأْكُلْ مِنَ ٱلْأَقْدَاسِ حَتَّى يَطْهُرَ. وَمَنْ مَسَّ شَيْئًا نَجِسًا لِمَيْتٍ، أَوْ إِنْسَانٌ حَدَثَ مِنْهُ ٱضْطِجَاعُ زَرْعٍ، ");
INSERT INTO arb_vd_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","أَوْ إِنْسَانٌ مَسَّ دَبِيبًا يَتَنَجَّسُ بِهِ، أَوْ إِنْسَانًا يَتَنَجَّسُ بِهِ لِنَجَاسَةٍ فِيهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","فَٱلَّذِي يَمَسُّ ذَلِكَ يَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ، وَلَا يَأْكُلْ مِنَ ٱلْأَقْدَاسِ، بَلْ يَرْحَضُ جَسَدَهُ بِمَاءٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","فَمَتَى غَرَبَتِ ٱلشَّمْسُ يَكُونُ طَاهِرًا، ثُمَّ يَأْكُلُ مِنَ ٱلْأَقْدَاسِ لِأَنَّهَا طَعَامُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","مِيْتَةً أَوْ فَرِيسَةً لَا يَأْكُلْ فَيَتَنَجَّسَ بِهَا. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","فَيَحْفَظُونَ شَعَائِرِي لِكَيْ لَا يَحْمِلُوا لِأَجْلِهَا خَطِيَّةً يَمُوتُونَ بِهَا لِأَنَّهُمْ يُدَنِّسُونَهَا. أَنَا ٱلرَّبُّ مُقَدِّسُهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«وَكُلُّ أَجْنَبِيٍّ لَا يَأْكُلُ قُدْسًا. نَزِيلُ كَاهِنٍ وَأَجِيرُهُ لَا يَأْكُلُونَ قُدْسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","لَكِنْ إِذَا ٱشْتَرَى كَاهِنٌ أَحَدًا شِرَاءَ فِضَّةٍ، فَهُوَ يَأْكُلُ مِنْهُ، وَٱلْمَوْلُودُ فِي بَيْتِهِ. هُمَا يَأْكُلَانِ مِنْ طَعَامِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","وَإِذَا صَارَتِ ٱبْنَةُ كَاهِنٍ لِرَجُلٍ أَجْنَبِيٍّ لَا تَأْكُلُ مِنْ رَفِيعَةِ ٱلْأَقْدَاسِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","وَأَمَّا ٱبْنَةُ كَاهِنٍ قَدْ صَارَتْ أَرْمَلَةً أَوْ مُطَلَّقَةً، وَلَمْ يَكُنْ لَهَا نَسْلٌ، وَرَجَعَتْ إِلَى بَيْتِ أَبِيهَا كَمَا فِي صِبَاهَا، فَتَأْكُلُ مِنْ طَعَامِ أَبِيهَا. لَكِنَّ كُلَّ أَجْنَبِيٍّ لَا يَأْكُلُ مِنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","وَإِذَا أَكَلَ إِنْسَانٌ قُدْسًا سَهْوًا، يَزِيدُ عَلَيْهِ خُمْسَهُ وَيَدْفَعُ ٱلْقُدْسَ لِلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","فَلَا يُدَنِّسُونَ أَقْدَاسَ بَنِي إِسْرَائِيلَ ٱلَّتِي يَرْفَعُونَهَا لِلرَّبِّ، ");
INSERT INTO arb_vd_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","فَيُحَمِّلُونَهُمْ ذَنْبَ إِثْمٍ بِأَكْلِهِمْ أَقْدَاسَهُمْ. لِأَنِّي أَنَا ٱلرَّبُّ مُقَدِّسُهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«كَلِّمْ هَارُونَ وَبَنِيهِ وَجَمِيعَ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: كُلُّ إِنْسَانٍ مِنْ بَيْتِ إِسْرَائِيلَ وَمِنَ ٱلْغُرَبَاءِ فِي إِسْرَائِيلَ، قَرَّبَ قُرْبَانَهُ مِنْ جَمِيعِ نُذُورِهِمْ وَجَمِيعِ نَوَافِلِهِمِ ٱلَّتِي يُقَرِّبُونَهَا لِلرَّبِّ مُحْرَقَةً، ");
INSERT INTO arb_vd_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","فَلِلرِّضَا عَنْكُمْ يَكُونُ ذَكَرًا صَحِيحًا مِنَ ٱلْبَقَرِ أَوِ ٱلْغَنَمِ أَوِ ٱلْمَعْزِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","كُلُّ مَا كَانَ فِيهِ عَيْبٌ لَا تُقَرِّبُوهُ لِأَنَّهُ لَا يَكُونُ لِلرِّضَا عَنْكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","وَإِذَا قَرَّبَ إِنْسَانٌ ذَبِيحَةَ سَلَامَةٍ لِلرَّبِّ وَفَاءً لِنَذْرٍ، أَوْ نَافِلَةً مِنَ ٱلْبَقَرِ أَوِ ٱلْأَغْنَامِ، تَكُونُ صَحِيحَةً لِلرِّضَا. كُلُّ عَيْبٍ لَا يَكُونُ فِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ٱلْأَعْمَى وَٱلْمَكْسُورُ وَٱلْمَجْرُوحُ وَٱلْبَثِيرُ وَٱلْأَجْرَبُ وَٱلْأَكْلَفُ، هَذِهِ لَا تُقَرِّبُوهَا لِلرَّبِّ، وَلَا تَجْعَلُوا مِنْهَا وَقُودًا عَلَى ٱلْمَذْبَحِ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","وَأَمَّا ٱلثَّوْرُ أَوِ ٱلشَّاةُ ٱلزَّوَائِدِيُّ أَوِ ٱلْقُزُمُ فَنَافِلَةً تَعْمَلُهُ، وَلَكِنْ لِنَذْرٍ لَا يُرْضَى بِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","وَمَرْضُوضَ ٱلْخِصْيَةِ وَمَسْحُوقَهَا وَمَقْطُوعَهَا لَا تُقَرِّبُوا لِلرَّبِّ. وَفِي أَرْضِكُمْ لَا تَعْمَلُوهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","وَمِنْ يَدِ ٱبْنِ ٱلْغَرِيبِ لَا تُقَرِّبُوا خُبْزَ إِلَهِكُمْ مِنْ جَمِيعِ هَذِهِ، لِأَنَّ فِيهَا فَسَادَهَا. فِيهَا عَيْبٌ لَا يُرْضَى بِهَا عَنْكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«مَتَى وُلِدَ بَقَرٌ أَوْ غَنَمٌ أَوْ مِعْزًى يَكُونُ سَبْعَةَ أَيَّامٍ تَحْتَ أُمِّهِ، ثُمَّ مِنَ ٱلْيَوْمِ ٱلثَّامِنِ فَصَاعِدًا يُرْضَى بِهِ قُرْبَانَ وَقُودٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","وَأَمَّا ٱلْبَقَرَةُ أَوِ ٱلشَّاةُ فَلَا تَذْبَحُوهَا وَٱبْنَهَا فِي يَوْمٍ وَاحِدٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","وَمَتَى ذَبَحْتُمْ ذَبِيحَةَ شُكْرٍ لِلرَّبِّ، فَلِلرِّضَا عَنْكُمْ تَذْبَحُونَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","فِي ذَلِكَ ٱلْيَوْمِ تُؤْكَلُ. لَا تُبْقُوا مِنْهَا إِلَى ٱلْغَدِ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","فَتَحْفَظُونَ وَصَايَايَ وَتَعْمَلُونَهَا. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","وَلَا تُدَنِّسُونَ ٱسْمِي ٱلْقُدُّوسَ، فَأَتَقَدَّسُ فِي وَسَطِ بَنِي إِسْرَائِيلَ. أَنَا ٱلرَّبُّ مُقَدِّسُكُمُ ");
INSERT INTO arb_vd_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ٱلَّذِي أَخْرَجَكُمْ مِنْ أَرْضِ مِصْرَ لِيَكُونَ لَكُمْ إِلَهًا. أَنَا ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: مَوَاسِمُ ٱلرَّبِّ ٱلَّتِي فِيهَا تُنَادُونَ مَحَافِلَ مُقَدَّسَةً. هَذِهِ هِيَ مَوَاسِمِي: ");
INSERT INTO arb_vd_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","سِتَّةَ أَيَّامٍ يُعْمَلُ عَمَلٌ، وَأَمَّا ٱلْيَوْمُ ٱلسَّابِعُ فَفِيهِ سَبْتُ عُطْلَةٍ مَحْفَلٌ مُقَدَّسٌ. عَمَلًا مَّا لَا تَعْمَلُوا. إِنَّهُ سَبْتٌ لِلرَّبِّ فِي جَمِيعِ مَسَاكِنِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«هَذِهِ مَوَاسِمُ ٱلرَّبِّ، ٱلْمَحَافِلُ ٱلْمُقَدَّسَةُ ٱلَّتِي تُنَادُونَ بِهَا فِي أَوْقَاتِهَا: ");
INSERT INTO arb_vd_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","فِي ٱلشَّهْرِ ٱلْأَوَّلِ، فِي ٱلرَّابِعَ عَشَرَ مِنَ ٱلشَّهْرِ، بَيْنَ ٱلْعِشَاءَيْنِ فِصْحٌ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","وَفِي ٱلْيَوْمِ ٱلْخَامِسَ عَشَرَ مِنْ هَذَا ٱلشَّهْرِ عِيدُ ٱلْفَطِيرِ لِلرَّبِّ. سَبْعَةَ أَيَّامٍ تَأْكُلُونَ فَطِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","فِي ٱلْيَوْمِ ٱلْأَوَّلِ يَكُونُ لَكُمْ مَحْفَلٌ مُقَدَّسٌ. عَمَلًا مَّا مِنَ ٱلشُّغْلِ لَا تَعْمَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","وَسَبْعَةَ أَيَّامٍ تُقَرِّبُونَ وَقُودًا لِلرَّبِّ. فِي ٱلْيَوْمِ ٱلسَّابِعِ يَكُونُ مَحْفَلٌ مُقَدَّسٌ. عَمَلًا مَّا مِنَ ٱلشُّغْلِ لَا تَعْمَلُوا». ");
INSERT INTO arb_vd_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","وكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: مَتَى جِئْتُمْ إِلَى ٱلْأَرْضِ ٱلَّتِي أَنَا أُعْطِيكُمْ وَحَصَدْتُمْ حَصِيدَهَا، تَأْتُونَ بِحُزْمَةِ أَوَّلِ حَصِيدِكُمْ إِلَى ٱلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","فَيُرَدِّدُ ٱلْحُزْمَةَ أَمَامَ ٱلرَّبِّ لِلرِّضَا عَنْكُمْ. فِي غَدِ ٱلسَّبْتِ يُرَدِّدُهَا ٱلْكَاهِنُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","وَتَعْمَلُونَ يَوْمَ تَرْدِيدِكُمُ ٱلْحُزْمَةَ خَرُوفًا صَحِيحًا حَوْلِيًّا مُحْرَقَةً لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","وَتَقْدِمَتَهُ عُشْرَيْنِ مِنْ دَقِيقٍ مَلْتُوتٍ بِزَيْتٍ، وَقُودًا لِلرَّبِّ رَائِحَةَ سَرُورٍ، وَسَكِيبَهُ رُبْعَ ٱلْهِينِ مِنْ خَمْرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","وَخُبْزًا وَفَرِيكًا وَسَوِيقًا لَا تَأْكُلُوا إِلَى هَذَا ٱلْيَوْمِ عَيْنِهِ، إِلَى أَنْ تَأْتُوا بِقُرْبَانِ إِلَهِكُمْ، فَرِيضَةً دَهْرِيَّةً فِي أَجْيَالِكُمْ فِي جَمِيعِ مَسَاكِنِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«ثُمَّ تَحْسُبُونَ لَكُمْ مِنْ غَدِ ٱلسَّبْتِ مِنْ يَوْمِ إِتْيَانِكُمْ بِحُزْمَةِ ٱلتَّرْدِيدِ سَبْعَةَ أَسَابِيعَ تَكُونُ كَامِلَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","إِلَى غَدِ ٱلسَّبْتِ ٱلسَّابِعِ تَحْسُبُونَ خَمْسِينَ يَوْمًا، ثُمَّ تُقَرِّبُونَ تَقْدِمَةً جَدِيدَةً لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","مِنْ مَسَاكِنِكُمْ تَأْتُونَ بِخُبْزِ تَرْدِيدٍ، رَغِيفَيْنِ عُشْرَيْنِ يَكُونَانِ مِنْ دَقِيقٍ، وَيُخْبَزَانِ خَمِيرًا بَاكُورَةً لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","وَتُقَرِّبُونَ مَعَ ٱلْخُبْزِ سَبْعَةَ خِرَافٍ صَحِيحَةٍ حَوْلِيَّةٍ، وَثَوْرًا وَاحِدًا ٱبْنَ بَقَرٍ، وَكَبْشَيْنِ مُحْرَقَةً لِلرَّبِّ مَعَ تَقْدِمَتِهَا وَسَكِيبِهَا وَقُودَ رَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","وَتَعْمَلُونَ تَيْسًا وَاحِدًا مِنَ ٱلْمَعْزِ ذَبِيحَةَ خَطِيَّةٍ، وَخَرُوفَيْنِ حَوْلِيَّيْنِ ذَبِيحَةَ سَلَامَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","فَيُرَدِّدُهَا ٱلْكَاهِنُ مَعَ خُبْزِ ٱلْبَاكُورَةِ تَرْدِيدًا أَمَامَ ٱلرَّبِّ مَعَ ٱلْخَرُوفَيْنِ، فَتَكُونُ لِلْكَاهِنِ قُدْسًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","وَتُنَادُونَ فِي ذَلِكَ ٱلْيَوْمِ عَيْنِهِ مَحْفَلًا مُقَدَّسًا يَكُونُ لَكُمْ. عَمَلًا مَّا مِنَ ٱلشُّغْلِ لَا تَعْمَلُوا. فَرِيضَةً دَهْرِيَّةً فِي جَمِيعِ مَسَاكِنِكُمْ فِي أَجْيَالِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","وَعِنْدَمَا تَحْصُدُونَ حَصِيدَ أَرْضِكُمْ، لَا تُكَمِّلْ زَوَايَا حَقْلِكَ فِي حَصَادِكَ، وَلُقَاطَ حَصِيدِكَ لَا تَلْتَقِطْ. لِلْمِسْكِينِ وَٱلْغَرِيبِ تَتْرُكُهُ. أَنَا ٱلرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«كَلِّمْ بَنِي إِسْرَائِيلَ قَائِلًا: فِي ٱلشَّهْرِ ٱلسَّابِعِ، فِي أَوَّلِ ٱلشَّهْرِ يَكُونُ لَكُمْ عُطْلَةٌ، تَذْكَارُ هُتَافِ ٱلْبُوقِ، مَحْفَلٌ مُقَدَّسٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","عَمَلًا مَّا مِنَ ٱلشُّغْلِ لَا تَعْمَلُوا، لَكِنْ تُقَرِّبُونَ وَقُودًا لِلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«أَمَّا ٱلْعَاشِرُ مِنْ هَذَا ٱلشَّهْرِ ٱلسَّابِعِ، فَهُوَ يَوْمُ ٱلْكَفَّارَةِ. مَحْفَلًا مُقَدَّسًا يَكُونُ لَكُمْ. تُذَلِّلُونَ نُفُوسَكُمْ وَتُقَرِّبُونَ وَقُودًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","عَمَلًا مَّا لَا تَعْمَلُوا فِي هَذَا ٱلْيَوْمِ عَيْنِهِ، لِأَنَّهُ يَوْمُ كَفَّارَةٍ لِلتَّكْفِيرِ عَنْكُمْ أَمَامَ ٱلرَّبِّ إِلَهِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","إِنَّ كُلَّ نَفْسٍ لَا تَتَذَلَّلُ فِي هَذَا ٱلْيَوْمِ عَيْنِهِ تُقْطَعُ مِنْ شَعْبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","وَكُلَّ نَفْسٍ تَعْمَلُ عَمَلًا مَّا فِي هَذَا ٱلْيَوْمِ عَيْنِهِ أُبِيدُ تِلْكَ ٱلنَّفْسَ مِنْ شَعْبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","عَمَلًا مَّا لَا تَعْمَلُوا. فَرِيضَةً دَهْرِيَّةً فِي أَجْيَالِكُمْ فِي جَمِيعِ مَسَاكِنِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","إِنَّهُ سَبْتُ عُطْلَةٍ لَكُمْ، فَتُذَلِّلُونَ نُفُوسَكُمْ. فِي تَاسِعِ ٱلشَّهْرِ عِنْدَ ٱلْمَسَاءِ. مِنَ ٱلْمَسَاءِ إِلَى ٱلْمَسَاءِ تَسْبِتُونَ سَبْتَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«كَلِّمْ بَنِي إِسْرَائِيلَ قَائِلًا: فِي ٱلْيَوْمِ ٱلْخَامِسَ عَشَرَ مِنْ هَذَا ٱلشَّهْرِ ٱلسَّابِعِ عِيدُ ٱلْمَظَالِّ سَبْعَةَ أَيَّامٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","فِي ٱلْيَوْمِ ٱلْأَوَّلِ مَحْفَلٌ مُقَدَّسٌ. عَمَلًا مَّا مِنَ ٱلشُّغْلِ لَا تَعْمَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","سَبْعَةَ أَيَّامٍ تُقَرِّبُونَ وَقُودًا لِلرَّبِّ. فِي ٱلْيَوْمِ ٱلثَّامِنِ يَكُونُ لَكُمْ مَحْفَلٌ مُقَدَّسٌ تُقَرِّبُونَ وَقُودًا لِلرَّبِّ. إِنَّهُ ٱعْتِكَافٌ. كُلُّ عَمَلِ شُغْلٍ لَا تَعْمَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«هَذِهِ هِيَ مَوَاسِمُ ٱلرَّبِّ ٱلَّتِي فِيهَا تُنَادُونَ مَحَافِلَ مُقَدَّسَةً لِتَقْرِيبِ وَقُودٍ لِلرَّبِّ، مُحْرَقَةً وَتَقْدِمَةً وَذَبِيحَةً وَسَكِيبًا أَمْرَ ٱلْيَوْمِ بِيَوْمِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","عَدَا سُبُوتِ ٱلرَّبِّ، وَعَدَا عَطَايَاكُمْ وَجَمِيعِ نُذُورِكُمْ، وَجَمِيعِ نَوَافِلِكُمُ ٱلَّتِي تُعْطُونَهَا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","أَمَّا ٱلْيَوْمُ ٱلْخَامِسَ عَشَرَ مِنَ ٱلشَّهْرِ ٱلسَّابِعِ فَفِيهِ، عِنْدَمَا تَجْمَعُونَ غَلَّةَ ٱلْأَرْضِ، تُعَيِّدُونَ عِيدًا لِلرَّبِّ سَبْعَةَ أَيَّامٍ. فِي ٱلْيَوْمِ ٱلْأَوَّلِ عُطْلَةٌ وَفِي ٱلْيَوْمِ ٱلثَّامِنِ عُطْلَةٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","وَتَأْخُذُونَ لِأَنْفُسِكُمْ فِي ٱلْيَوْمِ ٱلْأَوَّلِ ثَمَرَ أَشْجَارٍ بَهِجَةٍ وَسَعَفَ ٱلنَّخْلِ وَأَغْصَانَ أَشْجَارٍ غَبْيَاءَ وَصَفْصَافَ ٱلْوَادِي، وَتَفْرَحُونَ أَمَامَ ٱلرَّبِّ إِلَهِكُمْ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","تُعَيِّدُونَهُ عِيدًا لِلرَّبِّ سَبْعَةَ أَيَّامٍ فِي ٱلسَّنَةِ فَرِيضَةً دَهْرِيَّةً فِي أَجْيَالِكُمْ. فِي ٱلشَّهْرِ ٱلسَّابِعِ تُعَيِّدُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","فِي مَظَالَّ تَسْكُنُونَ سَبْعَةَ أَيَّامٍ. كُلُّ ٱلْوَطَنِيِّينَ فِي إِسْرَائِيلَ يَسْكُنُونَ فِي ٱلْمَظَالِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","لِكَيْ تَعْلَمَ أَجْيَالُكُمْ أَنِّي فِي مَظَالَّ أَسْكَنْتُ بَنِي إِسْرَائِيلَ لَمَّا أَخْرَجْتُهُمْ مِنْ أَرْضِ مِصْرَ. أَنَا ٱلرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","فَأَخْبَرَ مُوسَى بَنِي إِسْرَائِيلَ بِمَوَاسِمِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ أَنْ يُقَدِّمُوا إِلَيْكَ زَيْتَ زَيْتُونٍ مَرْضُوضٍ نَقِيًّا لِلضَّوْءِ لِإِيقَادِ ٱلسُّرُجِ دَائِمًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","خَارِجَ حِجَابِ ٱلشَّهَادَةِ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ يُرَتِّبُهَا هَارُونُ مِنَ ٱلْمَسَاءِ إِلَى ٱلصَّبَاحِ أَمَامَ ٱلرَّبِّ دَائِمًا فَرِيضَةً دَهْرِيَّةً فِي أَجْيَالِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","عَلَى ٱلْمَنَارَةِ ٱلطَّاهِرَةِ يُرَتِّبُ ٱلسُّرُجَ أَمَامَ ٱلرَّبِّ دَائِمًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«وَتَأْخُذُ دَقِيقًا وَتَخْبِزُهُ ٱثْنَيْ عَشَرَ قُرْصًا. عُشْرَيْنِ يَكُونُ ٱلْقُرْصُ ٱلْوَاحِدُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","وَتَجْعَلُهَا صَفَّيْنِ، كُلَّ صَفٍّ سِتَّةً عَلَى ٱلْمَائِدَةِ ٱلطَّاهِرَةِ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","وَتَجْعَلُ عَلَى كُلِّ صَفٍّ لُبَانًا نَقِيًّا فَيَكُونُ لِلْخُبْزِ تَذْكَارًا وَقُودًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","فِي كُلِّ يَوْمِ سَبْتٍ يُرَتِّبُهُ أَمَامَ ٱلرَّبِّ دَائِمًا، مِنْ عِنْدِ بَنِي إِسْرَائِيلَ مِيثَاقًا دَهْرِيًّا. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","فَيَكُونُ لِهَارُونَ وَبَنِيهِ، فَيَأْكُلُونَهُ فِي مَكَانٍ مُقَدَّسٍ، لِأَنَّهُ قُدْسُ أَقْدَاسٍ لَهُ مِنْ وَقَائِدِ ٱلرَّبِّ فَرِيضَةً دَهْرِيَّةً». ");
INSERT INTO arb_vd_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","وَخَرَجَ ٱبْنُ ٱمْرَأَةٍ إِسْرَائِيلِيَّةٍ، وَهُوَ ٱبْنُ رَجُلٍ مِصْرِيٍّ، فِي وَسَطِ بَنِي إِسْرَائِيلَ. وَتَخَاصَمَ فِي ٱلْمَحَلَّةِ ٱبْنُ ٱلْإِسْرَائِيلِيَّةِ وَرَجُلٌ إِسْرَائِيلِيٌّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","فَجَدَّفَ ٱبْنُ ٱلْإِسْرَائِيلِيَّةِ عَلَى ٱلِٱسْمِ وَسَبَّ. فَأَتَوْا بِهِ إِلَى مُوسَى. وَكَانَ ٱسْمُ أُمِّهِ شَلُومِيَةَ بِنْتَ دِبْرِي مِنْ سِبْطِ دَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","فَوَضَعُوهُ فِي ٱلْمَحْرَسِ لِيُعْلَنَ لَهُمْ عَنْ فَمِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","فَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«أَخْرِجِ ٱلَّذِي سَبَّ إِلَى خَارِجِ ٱلْمَحَلَّةِ، فَيَضَعَ جَمِيعُ ٱلسَّامِعِينَ أَيْدِيَهُمْ عَلَى رَأْسِهِ، وَيَرْجُمَهُ كُلُّ ٱلْجَمَاعَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","وَكَلِّمْ بَنِي إِسْرَائِيلَ قَائِلًا: كُلُّ مَنْ سَبَّ إِلَهَهُ يَحْمِلُ خَطِيَّتَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","وَمَنْ جَدَّفَ عَلَى ٱسْمِ ٱلرَّبِّ فَإِنَّهُ يُقْتَلُ. يَرْجُمُهُ كُلُّ ٱلْجَمَاعَةِ رَجْمًا. ٱلْغَرِيبُ كَٱلْوَطَنِيِّ عِنْدَمَا يُجَدِّفُ عَلَى ٱلِٱسْمِ يُقْتَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","وَإِذَا أَمَاتَ أَحَدٌ إِنْسَانًا فَإِنَّهُ يُقْتَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","وَمَنْ أَمَاتَ بَهِيمَةً يُعَوِّضُ عَنْهَا نَفْسًا بِنَفْسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","وَإِذَا أَحْدَثَ إِنْسَانٌ فِي قَرِيبِهِ عَيْبًا، فَكَمَا فَعَلَ كَذَلِكَ يُفْعَلُ بِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","كَسْرٌ بِكَسْرٍ، وَعَيْنٌ بِعَيْنٍ، وَسِنٌّ بِسِنٍّ. كَمَا أَحْدَثَ عَيْبًا فِي ٱلْإِنْسَانِ كَذَلِكَ يُحْدَثُ فِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","مَنْ قَتَلَ بَهِيمَةً يُعَوِّضُ عَنْهَا، وَمَنْ قَتَلَ إِنْسَانًا يُقْتَلْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","حُكْمٌ وَاحِدٌ يَكُونُ لَكُمْ. ٱلْغَرِيبُ يَكُونُ كَٱلْوَطَنِيِّ. إِنِّي أَنَا ٱلرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","فَكَلَّمَ مُوسَى بَنِي إِسْرَائِيلَ أَنْ يُخْرِجُوا ٱلَّذِي سَبَّ إِلَى خَارِجِ ٱلْمَحَلَّةِ وَيَرْجُمُوهُ بِٱلْحِجَارَةِ. فَفَعَلَ بَنُو إِسْرَائِيلَ كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى فِي جَبَلِ سِينَاءَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: مَتَى أَتَيْتُمْ إِلَى ٱلْأَرْضِ ٱلَّتِي أَنَا أُعْطِيكُمْ تَسْبِتُ ٱلْأَرْضُ سَبْتًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","سِتَّ سِنِينَ تَزْرَعُ حَقْلَكَ، وَسِتَّ سِنِينَ تَقْضِبُ كَرْمَكَ وَتَجْمَعُ غَلَّتَهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","وَأَمَّا ٱلسَّنَةُ ٱلسَّابِعَةُ فَفِيهَا يَكُونُ لِلْأَرْضِ سَبْتُ عُطْلَةٍ، سَبْتًا لِلرَّبِّ. لَا تَزْرَعْ حَقْلَكَ وَلَا تَقْضِبْ كَرْمَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","زِرِّيعَ حَصِيدِكَ لَا تَحْصُدْ، وَعِنَبَ كَرْمِكَ ٱلْمُحْوِلِ لَا تَقْطِفْ. سَنَةَ عُطْلَةٍ تَكُونُ لِلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","وَيَكُونُ سَبْتُ ٱلْأَرْضِ لَكُمْ طَعَامًا. لَكَ وَلِعَبْدِكَ وَلِأَمَتِكَ وَلِأَجِيرِكَ وَلِمُسْتَوْطِنِكَ ٱلنَّازِلِينَ عِنْدَكَ، ");
INSERT INTO arb_vd_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","وَلِبَهَائِمِكَ وَلِلْحَيَوَانِ ٱلَّذِي فِي أَرْضِكَ تَكُونُ كُلُّ غَلَّتِهَا طَعَامًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«وَتَعُدُّ لَكَ سَبْعَةَ سُبُوتِ سِنِينَ. سَبْعَ سِنِينَ سَبْعَ مَرَّاتٍ. فَتَكُونُ لَكَ أَيَّامُ ٱلسَّبْعَةِ ٱلسُّبُوتِ ٱلسَّنَوِيَّةِ تِسْعًا وَأَرْبَعِينَ سَنَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ثُمَّ تُعَبِّرُ بُوقَ ٱلْهُتَافِ فِي ٱلشَّهْرِ ٱلسَّابِعِ فِي عَاشِرِ ٱلشَّهْرِ. فِي يَوْمِ ٱلْكَفَّارَةِ تُعَبِّرُونَ ٱلْبُوقَ فِي جَمِيعِ أَرْضِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","وَتُقَدِّسُونَ ٱلسَّنَةَ ٱلْخَمْسِينَ، وَتُنَادُونَ بِٱلْعِتْقِ فِي ٱلْأَرْضِ لِجَمِيعِ سُكَّانِهَا. تَكُونُ لَكُمْ يُوبِيلًا، وَتَرْجِعُونَ كُلٌّ إِلَى مُلْكِهِ، وَتَعُودُونَ كُلٌّ إِلَى عَشِيرَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","يُوبِيلًا تَكُونُ لَكُمُ ٱلسَّنَةُ ٱلْخَمْسُونَ. لَا تَزْرَعُوا وَلَا تَحْصُدُوا زِرِّيعَهَا، وَلَا تَقْطِفُوا كَرْمَهَا ٱلْمُحْوِلَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","إِنَّهَا يُوبِيلٌ. مُقَدَّسَةً تَكُونُ لَكُمْ. مِنَ ٱلْحَقْلِ تَأْكُلُونَ غَلَّتَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","فِي سَنَةِ ٱلْيُوبِيلِ هَذِهِ تَرْجِعُونَ كُلٌّ إِلَى مُلْكِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","فَمَتَى بِعْتَ صَاحِبَكَ مَبِيعًا، أَوِ ٱشْتَرَيْتَ مِنْ يَدِ صَاحِبِكَ، فَلَا يَغْبِنْ أَحَدُكُمْ أَخَاهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","حَسَبَ عَدَدِ ٱلسِّنِينَ بَعْدَ ٱلْيُوبِيلِ تَشْتَرِي مِنْ صَاحِبِكَ، وَحَسَبَ سِنِي ٱلْغَلَّةِ يَبِيعُكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","عَلَى قَدْرِ كَثْرَةِ ٱلسِّنِينَ تُكَثِّرُ ثَمَنَهُ، وَعَلَى قَدْرِ قِلَّةِ ٱلسِّنِينَ تُقَلِّلُ ثَمَنَهُ، لِأَنَّهُ عَدَدَ ٱلْغَلَّاتِ يَبِيعُكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","فَلَا يَغْبِنْ أَحَدُكُمْ صَاحِبَهُ، بَلِ ٱخْشَ إِلَهَكَ. إِنِّي أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","فَتَعْمَلُونَ فَرَائِضِي وَتَحْفَظُونَ أَحْكَامِي وَتَعْمَلُونَهَا لِتَسْكُنُوا عَلَى ٱلْأَرْضِ آمِنِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","وَتُعْطِي ٱلْأَرْضُ ثَمَرَهَا فَتَأْكُلُونَ لِلشِّبَعِ، وَتَسْكُنُونَ عَلَيْهَا آمِنِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","وَإِذَا قُلْتُمْ: مَاذَا نَأْكُلُ فِي ٱلسَّنَةِ ٱلسَّابِعَةِ إِنْ لَمْ نَزْرَعْ وَلَمْ نَجْمَعْ غَلَّتَنَا؟ ");
INSERT INTO arb_vd_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","فَإِنِّي آمُرُ بِبَرَكَتِي لَكُمْ فِي ٱلسَّنَةِ ٱلسَّادِسَةِ، فَتَعْمَلُ غَلَّةً لِثَلَاثِ سِنِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","فَتَزْرَعُونَ ٱلسَّنَةَ ٱلثَّامِنَةَ وَتَأْكُلُونَ مِنَ ٱلْغَلَّةِ ٱلْعَتِيقَةِ إِلَى ٱلسَّنَةِ ٱلتَّاسِعَةِ. إِلَى أَنْ تَأْتِيَ غَلَّتُهَا تَأْكُلُونَ عَتِيقًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«وَٱلْأَرْضُ لَا تُبَاعُ بَتَّةً، لِأَنَّ لِيَ ٱلْأَرْضَ، وَأَنْتُمْ غُرَبَاءُ وَنُزَلَاءُ عِنْدِي. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","بَلْ فِي كُلِّ أَرْضِ مُلْكِكُمْ تَجْعَلُونَ فِكَاكًا لِلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","إِذَا ٱفْتَقَرَ أَخُوكَ فَبَاعَ مِنْ مُلْكِهِ، يَأْتِي وَلِيُّهُ ٱلْأَقْرَبُ إِلَيْهِ وَيَفُكُّ مَبِيعَ أَخِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","وَمَنْ لَمْ يَكُنْ لَهُ وَلِيٌّ، فَإِنْ نَالَتْ يَدُهُ وَوَجَدَ مِقْدَارَ فِكَاكِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","يَحْسُبُ سِنِي بَيْعِهِ، وَيَرُدُّ ٱلْفَاضِلَ لِلْإِنْسَانِ ٱلَّذِي بَاعَ لَهُ، فَيَرْجِعُ إِلَى مُلْكِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","وَإِنْ لَمْ تَنَلْ يَدُهُ كِفَايَةً لِيَرُدَّ لَهُ، يَكُونُ مَبِيعُهُ فِي يَدِ شَارِيهِ إِلَى سَنَةِ ٱلْيُوبِيلِ، ثُمَّ يَخْرُجُ فِي ٱلْيُوبِيلِ فَيَرْجِعُ إِلَى مُلْكِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«وَإِذَا بَاعَ إِنْسَانٌ بَيْتَ سَكَنٍ فِي مَدِينَةٍ ذَاتِ سُورٍ، فَيَكُونُ فِكَاكُهُ إِلَى تَمَامِ سَنَةِ بَيْعِهِ. سَنَةً يَكُونُ فِكَاكُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","وَإِنْ لَمْ يُفَكَّ قَبْلَ أَنْ تَكْمُلَ لَهُ سَنَةٌ تَامَّةٌ، وَجَبَ ٱلْبَيْتُ ٱلَّذِي فِي ٱلْمَدِينَةِ ذَاتِ ٱلسُّورِ بَتَّةً لِشَارِيهِ فِي أَجْيَالِهِ. لَا يَخْرُجُ فِي ٱلْيُوبِيلِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","لَكِنَّ بُيُوتَ ٱلْقُرَى ٱلَّتِي لَيْسَ لَهَا سُورٌ حَوْلَهَا، فَمَعَ حُقُولِ ٱلْأَرْضِ تُحْسَبُ. يَكُونُ لَهَا فِكَاكٌ، وَفِي ٱلْيُوبِيلِ تَخْرُجُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","وَأَمَّا مُدُنُ ٱللَّاوِيِّينَ، بُيُوتُ مُدُنِ مُلْكِهِمْ، فَيَكُونُ لَهَا فِكَاكٌ مُؤَبَّدٌ لِلَّاوِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","وَٱلَّذِي يَفُكُّهُ مِنَ ٱللَّاوِيِّينَ ٱلْمَبِيعَ مِنْ بَيْتٍ أَوْ مِنْ مَدِينَةِ مُلْكِهِ يَخْرُجُ فِي ٱلْيُوبِيلِ، لِأَنَّ بُيُوتَ مُدُنِ ٱللَّاوِيِّينَ هِيَ مُلْكُهُمْ فِي وَسَطِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","وَأَمَّا حُقُولُ ٱلْمَسَارِحِ لِمُدُنِهِمْ فَلَا تُبَاعُ، لِأَنَّهَا مُلْكٌ دَهْرِيٌّ لَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«وَإِذَا ٱفْتَقَرَ أَخُوكَ وَقَصُرَتْ يَدُهُ عِنْدَكَ، فَٱعْضُدْهُ غَرِيبًا أَوْ مُسْتَوْطِنًا فَيَعِيشَ مَعَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","لَا تَأْخُذْ مِنْهُ رِبًا وَلَا مُرَابَحَةً، بَلِ ٱخْشَ إِلَهَكَ، فَيَعِيشَ أَخُوكَ مَعَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","فِضَّتَكَ لَا تُعْطِهِ بِٱلرِّبَا، وَطَعَامَكَ لَا تُعْطِ بِٱلْمُرَابَحَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","أَنَا ٱلرَّبُّ إِلَهُكُمُ ٱلَّذِي أَخْرَجَكُمْ مِنْ أَرْضِ مِصْرَ لِيُعْطِيَكُمْ أَرْضَ كَنْعَانَ، فَيَكُونَ لَكُمْ إِلَهًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«وَإِذَا ٱفْتَقَرَ أَخُوكَ عِنْدَكَ وَبِيعَ لَكَ، فَلَا تَسْتَعْبِدْهُ ٱسْتِعْبَادَ عَبْدٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","كَأَجِيرٍ، كَنَزِيلٍ يَكُونُ عِنْدَكَ. إِلَى سَنَةِ ٱلْيُوبِيلِ يَخْدِمُ عِنْدَكَ، ");
INSERT INTO arb_vd_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ثُمَّ يَخْرُجُ مِنْ عِنْدِكَ هُوَ وَبَنُوهُ مَعَهُ وَيَعُودُ إِلَى عَشِيرَتِهِ، وَإِلَى مُلْكِ آبَائِهِ يَرْجِعُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","لِأَنَّهُمْ عَبِيدِي ٱلَّذِينَ أَخْرَجْتُهُمْ مِنْ أَرْضِ مِصْرَ، لَا يُبَاعُونَ بَيْعَ ٱلْعَبِيدِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","لَا تَتَسَلَّطْ عَلَيْهِ بِعُنْفٍ، بَلِ ٱخْشَ إِلَهَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","وَأَمَّا عَبِيدُكَ وَإِمَاؤُكَ ٱلَّذِينَ يَكُونُونَ لَكَ، فَمِنَ ٱلشُّعُوبِ ٱلَّذِينَ حَوْلَكُمْ. مِنْهُمْ تَقْتَنُونَ عَبِيدًا وَإِمَاءً. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","وَأَيْضًا مِنْ أَبْنَاءِ ٱلْمُسْتَوْطِنِينَ ٱلنَّازِلِينَ عِنْدَكُمْ، مِنْهُمْ تَقْتَنُونَ وَمِنْ عَشَائِرِهِمِ ٱلَّذِينَ عِنْدَكُمُ ٱلَّذِينَ يَلِدُونَهُمْ فِي أَرْضِكُمْ، فَيَكُونُونَ مُلْكًا لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","وَتَسْتَمْلِكُونَهُمْ لِأَبْنَائِكُمْ مِنْ بَعْدِكُمْ مِيرَاثَ مُلْكٍ. تَسْتَعْبِدُونَهُمْ إِلَى ٱلدَّهْرِ. وَأَمَّا إِخْوَتُكُمْ بَنُو إِسْرَائِيلَ فَلَا يَتَسَلَّطْ إِنْسَانٌ عَلَى أَخِيهِ بِعُنْفٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«وَإِذَا طَالَتْ يَدُ غَرِيبٍ أَوْ نَزِيلٍ عِنْدَكَ، وَٱفْتَقَرَ أَخُوكَ عِنْدَهُ وَبِيعَ لِلْغَرِيبِ ٱلْمُسْتَوْطِنِ عِنْدَكَ أَوْ لِنَسْلِ عَشِيرَةِ ٱلْغَرِيبِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","فَبَعْدَ بَيْعِهِ يَكُونُ لَهُ فِكَاكٌ. يَفُكُّهُ وَاحِدٌ مِنْ إِخْوَتِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","أَوْ يَفُكُّهُ عَمُّهُ أَوِ ٱبْنُ عَمِّهِ، أَوْ يَفُكُّهُ وَاحِدٌ مِنْ أَقْرِبَاءِ جَسَدِهِ مِنْ عَشِيرَتِهِ، أَوْ إِذَا نَالَتْ يَدُهُ يَفُكُّ نَفْسَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","فَيُحَاسِبُ شَارِيَهُ مِنْ سَنَةِ بَيْعِهِ لَهُ إِلَى سَنَةِ ٱلْيُوبِيلِ، وَيَكُونُ ثَمَنُ بَيْعِهِ حَسَبَ عَدَدِ ٱلسِّنِينَ. كَأَيَّامِ أَجِيرٍ يَكُونُ عِنْدَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","إِنْ بَقِيَ كَثِيرٌ مِنَ ٱلسِّنِينِ فَعَلَى قَدْرِهَا يَرُدُّ فِكَاكَهُ مِنْ ثَمَنِ شِرَائِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","وَإِنْ بَقِيَ قَلِيلٌ مِنَ ٱلسِّنِينَ إِلَى سَنَةِ ٱلْيُوبِيلِ يَحْسُبُ لَهُ وَعَلَى قَدْرِ سِنِيهِ يَرُدُّ فِكَاكَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","كَأَجِيرٍ مِنْ سَنَةٍ إِلَى سَنَةٍ يَكُونُ عِنْدَهُ. لَا يَتَسَلَّطْ عَلَيْهِ بِعُنْفٍ أَمَامَ عَيْنَيْكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","وَإِنْ لَمْ يُفَكَّ بِهَؤُلَاءِ، يَخْرُجُ فِي سَنَةِ ٱلْيُوبِيلِ هُوَ وَبَنُوهُ مَعَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","لِأَنَّ بَنِي إِسْرَائِيلَ لِي عَبِيدٌ. هُمْ عَبِيدِي ٱلَّذِينَ أَخْرَجْتُهُمْ مِنْ أَرْضِ مِصْرَ. أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«لَا تَصْنَعُوا لَكُمْ أَوْثَانًا، وَلَا تُقِيمُوا لَكُمْ تِمْثَالًا مَنْحُوتًا أَوْ نَصَبًا، وَلَا تَجْعَلُوا فِي أَرْضِكُمْ حَجَرًا مُصَوَّرًا لِتَسْجُدُوا لَهُ. لِأَنِّي أَنَا ٱلرَّبُّ إِلَهُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","سُبُوتِي تَحْفَظُونَ وَمَقْدِسِي تَهَابُونَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«إِذَا سَلَكْتُمْ فِي فَرَائِضِي وَحَفِظْتُمْ وَصَايَايَ وَعَمِلْتُمْ بِهَا، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","أُعْطِي مَطَرَكُمْ فِي حِينِهِ، وَتُعْطِي ٱلْأَرْضُ غَلَّتَهَا، وَتُعْطِي أَشْجَارُ ٱلْحَقْلِ أَثْمَارَهَا، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","وَيَلْحَقُ دِرَاسُكُمْ بِٱلْقِطَافِ، وَيَلْحَقُ ٱلْقِطَافُ بِٱلزَّرْعِ، فَتَأْكُلُونَ خُبْزَكُمْ لِلشِّبَعِ وَتَسْكُنُونَ فِي أَرْضِكُمْ آمِنِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","وَأَجْعَلُ سَلَامًا فِي ٱلْأَرْضِ، فَتَنَامُونَ وَلَيْسَ مَنْ يُزْعِجُكُمْ. وَأُبِيدُ ٱلْوُحُوشَ ٱلرَّدِيئَةَ مِنَ ٱلْأَرْضِ، وَلَا يَعْبُرُ سَيْفٌ فِي أَرْضِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","وَتَطْرُدُونَ أَعْدَاءَكُمْ فَيَسْقُطُونَ أَمَامَكُمْ بِٱلسَّيْفِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","يَطْرُدُ خَمْسَةٌ مِنْكُمْ مِئَةً، وَمِئَةٌ مِنْكُمْ يَطْرُدُونَ رَبْوَةً، وَيَسْقُطُ أَعْدَاؤُكُمْ أَمَامَكُمْ بِٱلسَّيْفِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","وَأَلْتَفِتُ إِلَيْكُمْ وَأُثْمِرُكُمْ وَأُكَثِّرُكُمْ وَأَفِي مِيثَاقِي مَعَكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","فَتَأْكُلُونَ ٱلْعَتِيقَ ٱلْمُعَتَّقَ، وَتُخْرِجُونَ ٱلْعَتِيقَ مِنْ وَجْهِ ٱلْجَدِيدِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","وَأَجْعَلُ مَسْكَنِي فِي وَسَطِكُمْ، وَلَا تَرْذُلُكُمْ نَفْسِي. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","وَأَسِيرُ بَيْنَكُمْ وَأَكُونُ لَكُمْ إِلَهًا وَأَنْتُمْ تَكُونُونَ لِي شَعْبًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","أَنَا ٱلرَّبُّ إِلَهُكُمُ ٱلَّذِي أَخْرَجَكُمْ مِنْ أَرْضِ مِصْرَ مِنْ كَوْنِكُمْ لَهُمْ عَبِيدًا، وَقَطَّعَ قُيُودَ نِيرِكُمْ وَسَيَّرَكُمْ قِيَامًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«لَكِنْ إِنْ لَمْ تَسْمَعُوا لِي وَلَمْ تَعْمَلُوا كُلَّ هَذِهِ ٱلْوَصَايَا، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","وَإِنْ رَفَضْتُمْ فَرَائِضِي وَكَرِهَتْ أَنْفُسُكُمْ أَحْكَامِي، فَمَا عَمِلْتُمْ كُلَّ وَصَايَايَ، بَلْ نَكَثْتُمْ مِيثَاقِي، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","فَإِنِّي أَعْمَلُ هَذِهِ بِكُمْ: أُسَلِّطُ عَلَيْكُمْ رُعْبًا وَسِلًّا وَحُمَّى تُفْنِي ٱلْعَيْنَيْنِ وَتُتْلِفُ ٱلنَّفْسَ. وَتَزْرَعُونَ بَاطِلًا زَرْعَكُمْ فَيَأْكُلُهُ أَعْدَاؤُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","وَأَجْعَلُ وَجْهِي ضِدَّكُمْ فَتَنْهَزِمُونَ أَمَامَ أَعْدَائِكُمْ، وَيَتَسَلَّطُ عَلَيْكُمْ مُبْغِضُوكُمْ، وَتَهْرُبُونَ وَلَيْسَ مَنْ يَطْرُدُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«وَإِنْ كُنْتُمْ مَعَ ذَلِكَ لَا تَسْمَعُونَ لِي، أَزِيدُ عَلَى تَأْدِيبِكُمْ سَبْعَةَ أَضْعَافٍ حَسَبَ خَطَايَاكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","فَأُحَطِّمُ فَخَارَ عِزِّكُمْ، وَأُصَيِّرُ سَمَاءَكُمْ كَٱلْحَدِيدِ، وَأَرْضَكُمْ كَٱلنُّحَاسِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","فَتُفْرَغُ بَاطِلًا قُوَّتُكُمْ، وَأَرْضُكُمْ لَا تُعْطِي غَلَّتَهَا، وَأَشْجَارُ ٱلْأَرْضِ لَا تُعْطِي أَثْمَارَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«وَإِنْ سَلَكْتُمْ مَعِي بِٱلْخِلَافِ، وَلَمْ تَشَاءُوا أَنْ تَسْمَعُوا لِي، أَزِيدُ عَلَيْكُمْ ضَرْبَاتٍ سَبْعَةَ أَضْعَافٍ حَسَبَ خَطَايَاكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","أُطْلِقُ عَلَيْكُمْ وُحُوشَ ٱلْبَرِّيَّةِ فَتُعْدِمُكُمُ ٱلْأَوْلَادَ، وَتَقْرِضُ بَهَائِمَكُمْ، وَتُقَلِّلُكُمْ فَتُوحَشُ طُرُقُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«وَإِنْ لَمْ تَتَأَدَّبُوا مِنِّي بِذَلِكَ، بَلْ سَلَكْتُمْ مَعِي بِٱلْخِلَافِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","فَإِنِّي أَنَا أَسْلُكُ مَعَكُمْ بِٱلْخِلَافِ، وَأَضْرِبُكُمْ سَبْعَةَ أَضْعَافٍ حَسَبَ خَطَايَاكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","أَجْلِبُ عَلَيْكُمْ سَيْفًا يَنْتَقِمُ نَقْمَةَ ٱلْمِيثَاقِ، فَتَجْتَمِعُونَ إِلَى مُدُنِكُمْ وَأُرْسِلُ فِي وَسَطِكُمُ ٱلْوَبَأَ فَتُدْفَعُونَ بِيَدِ ٱلْعَدُوِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","بِكَسْرِي لَكُمْ عَصَا ٱلْخُبْزِ. تَخْبِزُ عَشَرُ نِسَاءٍ خُبْزَكُمْ فِي تَنُّورٍ وَاحِدٍ، وَيَرْدُدْنَ خُبْزَكُمْ بِٱلْوَزْنِ، فَتَأْكُلُونَ وَلَا تَشْبَعُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«وَإِنْ كُنْتُمْ بِذَلِكَ لَا تَسْمَعُونَ لِي بَلْ سَلَكْتُمْ مَعِي بِٱلْخِلَافِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","فَأَنَا أَسْلُكُ مَعَكُمْ بِٱلْخِلَافِ سَاخِطًا، وَأُؤَدِّبُكُمْ سَبْعَةَ أَضْعَافٍ حَسَبَ خَطَايَاكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","فَتَأْكُلُونَ لَحْمَ بَنِيكُمْ، وَلَحْمَ بَنَاتِكُمْ تَأْكُلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","وَأُخْرِبُ مُرْتَفَعَاتِكُمْ، وَأَقْطَعُ شَمْسَاتِكُمْ، وَأُلْقِي جُثَثَكُمْ عَلَى جُثَثِ أَصْنَامِكُمْ، وَتَرْذُلُكُمْ نَفْسِي. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","وَأُصَيِّرُ مُدُنَكُمْ خَرِبَةً، وَمَقَادِسَكُمْ مُوحِشَةً، وَلَا أَشْتَمُّ رَائِحَةَ سَرُورِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","وَأُوحِشُ ٱلْأَرْضَ فَيَسْتَوْحِشُ مِنْهَا أَعْدَاؤُكُمُ ٱلسَّاكِنُونَ فِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","وَأُذَرِّيكُمْ بَيْنَ ٱلْأُمَمِ، وَأُجَرِّدُ وَرَاءَكُمُ ٱلسَّيْفَ فَتَصِيرُ أَرْضُكُمْ مُوحَشَةً، وَمُدُنُكُمْ تَصِيرُ خَرِبَةً. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","حِينَئِذٍ تَسْتَوْفِي ٱلْأَرْضُ سُبُوتَهَا كُلَّ أَيَّامِ وَحْشَتِهَا وَأَنْتُمْ فِي أَرْضِ أَعْدَائِكُمْ. حِينَئِذٍ تَسْبِتُ ٱلْأَرْضُ وَتَسْتَوْفِي سُبُوتَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","كُلَّ أَيَّامِ وَحْشَتِهَا تَسْبِتُ مَا لَمْ تَسْبِتْهُ مِنْ سُبُوتِكُمْ فِي سَكَنِكُمْ عَلَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","وَٱلْبَاقُونَ مِنْكُمْ أُلْقِي ٱلْجَبَانَةَ فِي قُلُوبِهِمْ فِي أَرَاضِي أَعْدَائِهِمْ، فَيَهْزِمُهُمْ صَوْتُ وَرَقَةٍ مُنْدَفِعَةٍ، فَيَهْرُبُونَ كَٱلْهَرَبِ مِنَ ٱلسَّيْفِ، وَيَسْقُطُونَ وَلَيْسَ طَارِدٌ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","وَيَعْثُرُ بَعْضُهُمْ بِبَعْضٍ كَمَا مِنْ أَمَامِ ٱلسَّيْفِ وَلَيْسَ طَارِدٌ، وَلَا يَكُونُ لَكُمْ قِيَامٌ أَمَامَ أَعْدَائِكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","فَتَهْلِكُونَ بَيْنَ ٱلشُّعُوبِ وَتَأْكُلُكُمْ أَرْضُ أَعْدَائِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","وَٱلْبَاقُونَ مِنْكُمْ يَفْنَوْنَ بِذُنُوبِهِمْ فِي أَرَاضِي أَعْدَائِكُمْ. وَأَيْضًا بِذُنُوبِ آبَائِهِمْ مَعَهُمْ يَفْنَوْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","لَكِنْ إِنْ أَقَرُّوا بِذُنُوبِهِمْ وَذُنُوبِ آبَائِهِمْ فِي خِيَانَتِهِمِ ٱلَّتِي خَانُونِي بِهَا، وَسُلُوكِهِمْ مَعِيَ ٱلَّذِي سَلَكُوا بِٱلْخِلَافِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","وَإِنِّي أَيْضًا سَلَكْتُ مَعَهُمْ بِٱلْخِلَافِ وَأَتَيْتُ بِهِمْ إِلَى أَرْضِ أَعْدَائِهِمْ. إِلَّا أَنْ تَخْضَعَ حِينَئِذٍ قُلُوبُهُمُ ٱلْغُلْفُ، وَيَسْتَوْفُوا حِينَئِذٍ عَنْ ذُنُوبِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","أَذْكُرُ مِيثَاقِي مَعَ يَعْقُوبَ، وَأَذْكُرُ أَيْضًا مِيثَاقِي مَعَ إِسْحَاقَ، وَمِيثَاقِي مَعَ إِبْرَاهِيمَ، وَأَذْكُرُ ٱلْأَرْضَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","وَٱلْأَرْضُ تُتْرَكُ مِنْهُمْ وَتَسْتَوْفِي سُبُوتَهَا فِي وَحْشَتِهَا مِنْهُمْ، وَهُمْ يَسْتَوْفُونَ عَنْ ذُنُوبِهِمْ لِأَنَّهُمْ قَدْ أَبَوْا أَحْكَامِي وَكَرِهَتْ أَنْفُسُهُمْ فَرَائِضِي. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","وَلَكِنْ مَعَ ذَلِكَ أَيْضًا مَتَى كَانُوا فِي أَرْضِ أَعْدَائِهِمْ، مَا أَبَيْتُهُمْ وَلَا كَرِهْتُهُمْ حَتَّى أُبِيدَهُمْ وَأَنْكُثَ مِيثَاقِي مَعَهُمْ، لِأَنِّي أَنَا ٱلرَّبُّ إِلَهُهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","بَلْ أَذْكُرُ لَهُمْ ٱلْمِيثَاقَ مَعَ ٱلْأَوَّلِينَ ٱلَّذِينَ أَخْرَجْتُهُمْ مِنْ أَرْضِ مِصْرَ أَمَامَ أَعْيُنِ ٱلشُّعُوبِ لِأَكُونَ لَهُمْ إِلَهًا. أَنَا ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","هَذِهِ هِيَ ٱلْفَرَائِضُ وَٱلْأَحْكَامُ وَٱلشَّرَائِعُ ٱلَّتِي وَضَعَهَا ٱلرَّبُّ بَيْنَهُ وَبَيْنَ بَنِي إِسْرَائِيلَ فِي جَبَلِ سِينَاءَ بِيَدِ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: إِذَا أَفْرَزَ إِنْسَانٌ نَذْرًا حَسَبَ تَقْوِيمِكَ نُفُوسًا لِلرَّبِّ، ");
INSERT INTO arb_vd_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","فَإِنْ كَانَ تَقْوِيمُكَ لِذَكَرٍ مِنِ ٱبْنِ عِشْرِينَ سَنَةً إِلَى ٱبْنِ سِتِّينَ سَنَةً، يَكُونُ تَقْوِيمُكَ خَمْسِينَ شَاقِلَ فِضَّةٍ عَلَى شَاقِلِ ٱلْمَقْدِسِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","وَإِنْ كَانَ أُنْثَى يَكُونُ تَقْوِيمُكَ ثَلَاثِينَ شَاقِلًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","وَإِنْ كَانَ مِنِ ٱبْنِ خَمْسِ سِنِينَ إِلَى ٱبْنِ عِشْرِينَ سَنَةً يَكُونُ تَقْوِيمُكَ لِذَكَرٍ عِشْرِينَ شَاقِلًا، وَلِأُنْثَى عَشَرَةَ شَوَاقِلَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","وَإِنْ كَانَ مِنِ ٱبْنِ شَهْرٍ إِلَى ٱبْنِ خَمْسِ سِنِينَ يَكُونُ تَقْوِيمُكَ لِذَكَرٍ خَمْسَةَ شَوَاقِلِ فِضَّةٍ، وَلِأُنْثَى يَكُونُ تَقْوِيمُكَ ثَلَاثَةَ شَوَاقِلِ فِضَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","وَإِنْ كَانَ مِنِ ٱبْنِ سِتِّينَ سَنَةً فَصَاعِدًا فَإِنْ كَانَ ذَكَرًا يَكُونُ تَقْوِيمُكَ خَمْسَةَ عَشَرَ شَاقِلًا، وَأَمَّا لِلْأُنْثَى فَعَشَرَةَ شَوَاقِلَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","وَإِنْ كَانَ فَقِيرًا عَنْ تَقْوِيمِكَ يُوقِفُهُ أَمَامَ ٱلْكَاهِنِ فَيُقَوِّمُهُ ٱلْكَاهِنُ. عَلَى قَدْرِ مَا تَنَالُ يَدُ ٱلنَّاذِرِ يُقَوِّمُهُ ٱلْكَاهِنُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«وَإِنْ كَانَ بَهِيمَةً مِمَّا يُقَرِّبُونَهُ قُرْبَانًا لِلرَّبِّ، فَكُلُّ مَا يُعْطِي مِنْهُ لِلرَّبِّ يَكُونُ قُدْسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","لَا يُغَيِّرُهُ وَلَا يُبْدِلُهُ جَيِّدًا بِرَدِيءٍ، أَوْ رَدِيئًا بِجَيِّدٍ. وَإِنْ أَبْدَلَ بَهِيمَةً بِبَهِيمَةٍ تَكُونُ هِيَ وَبَدِيلُهَا قُدْسًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","وَإِنْ كَانَ بَهِيمَةً نَجِسَةً مِمَّا لَا يُقَرِّبُونَهُ قُرْبَانًا لِلرَّبِّ يُوقِفُ ٱلْبَهِيمَةَ أَمَامَ ٱلْكَاهِنِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","فَيُقَوِّمُهَا ٱلْكَاهِنُ جَيِّدَةً أَمْ رَدِيئَةً. فَحَسَبَ تَقْوِيمِكَ يَا كَاهِنُ هَكَذَا يَكُونُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","فَإِنْ فَكَّهَا يَزِيدُ خُمْسَهَا عَلَى تَقْوِيمِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«وَإِذَا قَدَّسَ إِنْسَانٌ بَيْتَهُ قُدْسًا لِلرَّبِّ، يُقَوِّمُهُ ٱلْكَاهِنُ جَيِّدًا أَمْ رَدِيئًا. وَكَمَا يُقَوِّمُهُ ٱلْكَاهِنُ هَكَذَا يَقُومُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","فَإِنْ كَانَ ٱلْمُقَدِّسُ يَفُكُّ بَيْتَهُ، يَزِيدُ خُمْسَ فِضَّةِ تَقْوِيمِكَ عَلَيْهِ فَيَكُونُ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","وَإِنْ قَدَّسَ إِنْسَانٌ بَعْضَ حَقْلِ مُلْكِهِ لِلرَّبِّ، يَكُونُ تَقْوِيمُكَ عَلَى قَدَرِ بِذَارِهِ. بِذَارُ حُومَرٍ مِنَ ٱلشَّعِيرِ بِخَمْسِينَ شَاقِلِ فِضَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","إِنْ قَدَّسَ حَقْلَهُ مِنْ سَنَةِ ٱلْيُوبِيلِ فَحَسَبَ تَقْوِيمِكَ يَقُومُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","وَإِنْ قَدَّسَ حَقْلَهُ بَعْدَ سَنَةِ ٱلْيُوبِيلِ يَحْسُبُ لَهُ ٱلْكَاهِنُ ٱلْفِضَّةَ عَلَى قَدَرِ ٱلسِّنِينَ ٱلْبَاقِيَةِ إِلَى سَنَةِ ٱلْيُوبِيلِ، فَيُنَقَّصُ مِنْ تَقْوِيمِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","فَإِنْ فَكَّ ٱلْحَقْلَ مُقَدِّسُهُ، يَزِيدُ خُمْسَ فِضَّةِ تَقْوِيمِكَ عَلَيْهِ فَيَجِبُ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","لَكِنْ إِنْ لَمْ يَفُكَّ ٱلْحَقْلَ وَبِيعَ ٱلْحَقْلُ لِإِنْسَانٍ آخَرَ لَا يُفَكُّ بَعْدُ، ");
INSERT INTO arb_vd_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","بَلْ يَكُونُ ٱلْحَقْلُ عِنْدَ خُرُوجِهِ فِي ٱلْيُوبِيلِ قُدْسًا لِلرَّبِّ كَٱلْحَقْلِ ٱلْمُحَرَّمِ. لِلْكَاهِنِ يَكُونُ مُلْكُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«وَإِنْ قَدَّسَ لِلرَّبِّ حَقْلًا مِنْ شِرَائِهِ لَيْسَ مِنْ حُقُولِ مُلْكِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","يَحْسُبُ لَهُ ٱلْكَاهِنُ مَبْلَغَ تَقْوِيمِكَ إِلَى سَنَةِ ٱلْيُوبِيلِ، فَيُعْطِي تَقْوِيمَكَ فِي ذَلِكَ ٱلْيَوْمِ قُدْسًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","وَفِي سَنَةِ ٱلْيُوبِيلِ يَرْجِعُ ٱلْحَقْلُ إِلَى ٱلَّذِي ٱشْتَرَاهُ مِنْهُ، إِلَى ٱلَّذِي لَهُ مُلْكُ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","وَكُلُّ تَقْوِيمِكَ يَكُونُ عَلَى شَاقِلِ ٱلْمَقْدِسِ. عِشْرِينَ جِيرَةً يَكُونُ ٱلشَّاقِلُ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«لَكِنَّ ٱلْبِكْرَ ٱلَّذِي يُفْرَزُ بِكْرًا لِلرَّبِّ مِنَ ٱلْبَهَائِمِ فَلَا يُقَدِّسُهُ أَحَدٌ. ثَوْرًا كَانَ أَوْ شَاةً فَهُوَ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","وَإِنْ كَانَ مِنَ ٱلْبَهَائِمِ ٱلنَّجِسَةِ يَفْدِيهِ حَسَبَ تَقْوِيمِكَ وَيَزِيدُ خُمْسَهُ عَلَيْهِ. وَإِنْ لَمْ يُفَكَّ، فَيُبَاعُ حَسَبَ تَقْوِيمِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","أَمَّا كُلُّ مُحَرَّمٍ يُحَرِّمُهُ إِنْسَانٌ لِلرَّبِّ مِنْ كُلِّ مَا لَهُ مِنَ ٱلنَّاسِ وَٱلْبَهَائِمِ وَمِنْ حُقُولِ مُلْكِهِ فَلَا يُبَاعُ وَلَا يُفَكُّ. إِنَّ كُلَّ مُحَرَّمٍ هُوَ قُدْسُ أَقْدَاسٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","كُلُّ مُحَرَّمٍ يُحَرَّمُ مِنَ ٱلنَّاسِ لَا يُفْدَى. يُقْتَلُ قَتْلًا. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«وَكُلُّ عُشْرِ ٱلْأَرْضِ مِنْ حُبُوبِ ٱلْأَرْضِ وَأَثْمَارِ ٱلشَّجَرِ فَهُوَ لِلرَّبِّ. قُدْسٌ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","وَإِنْ فَكَّ إِنْسَانٌ بَعْضَ عُشْرِهِ يَزِيدُ خُمْسَهُ عَلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","وَأَمَّا كُلُّ عُشْرِ ٱلْبَقَرِ وَٱلْغَنَمِ فَكُلُّ مَا يَعْبُرُ تَحْتَ ٱلْعَصَا يَكُونُ ٱلْعَاشِرُ قُدْسًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","لَا يُفْحَصُ أَجَيِّدٌ هُوَ أَمْ رَدِيءٌ، وَلَا يُبْدِلُهُ. وَإِنْ أَبْدَلَهُ يَكُونُ هُوَ وَبَدِيلُهُ قُدْسًا. لَا يُفَكُّ». ");
INSERT INTO arb_vd_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","هَذِهِ هِيَ ٱلْوَصَايَا ٱلَّتِي أَوْصَى ٱلرَّبُّ بِهَا مُوسَى إِلَى بَنِي إِسْرَائِيلَ فِي جَبَلِ سِينَاءَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى فِي بَرِّيَّةِ سِينَاءَ، فِي خَيْمَةِ ٱلِٱجْتِمَاعِ، فِي أَوَّلِ ٱلشَّهْرِ ٱلثَّانِي فِي ٱلسَّنَةِ ٱلثَّانِيَةِ لِخُرُوجِهِمْ مِنْ أَرْضِ مِصْرَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«أَحْصُوا كُلَّ جَمَاعَةِ بَنِي إِسْرَائِيلَ بِعَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ، كُلَّ ذَكَرٍ بِرَأْسِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلَّ خَارِجٍ لِلْحَرْبِ فِي إِسْرَائِيلَ. تَحْسُبُهُمْ أَنْتَ وَهَارُونُ حَسَبَ أَجْنَادِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","وَيَكُونُ مَعَكُمَا رَجُلٌ لِكُلِّ سِبْطٍ، رَجُلٌ هُوَ رَأْسٌ لِبَيْتِ آبَائِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","وَهَذِهِ أَسْمَاءُ ٱلرِّجَالِ ٱلَّذِينَ يَقِفُونَ مَعَكُمَا: لِرَأُوبَيْنَ أَلِيصُورُ بْنُ شَدَيْئُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","لِشِمْعُونَ شَلُومِيئِيلُ بْنُ صُورِيشَدَّاي. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","لِيَهُوذَا نَحْشُونُ بْنُ عَمِّينَادَابَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","لِيَسَّاكَرَ نَثَنَائِيلُ بْنُ صُوغَرَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","لِزَبُولُونَ أَلِيآبُ بْنُ حِيلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","لِٱبْنَيْ يُوسُفَ: لِأَفْرَايِمَ أَلِيشَمَعُ بْنُ عَمِّيهُودَ، وَلِمَنَسَّى جَمْلِيئِيلُ بْنُ فَدَهْصُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","لِبَنْيَامِينَ أَبِيدَنُ بْنُ جِدْعُونِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","لِدَانَ أَخِيعَزَرُ بْنُ عَمِّيشَدَّاي. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","لِأَشِيرَ فَجْعِيئِيلُ بْنُ عُكْرَنَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","لِجَادَ أَلِيَاسَافُ بْنُ دَعُوئِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","لِنَفْتَالِي أَخِيرَعُ بْنُ عِينَنَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","هَؤُلَاءِ هُمْ مَشَاهِيرُ ٱلْجَمَاعَةِ، رُؤَسَاءُ أَسْبَاطِ آبَائِهِمْ. رُؤُوسُ أُلُوفِ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","فَأَخَذَ مُوسَى وَهَارُونُ هَؤُلَاءِ ٱلرِّجَالَ ٱلَّذِينَ تَعَيَّنُوا بِأَسْمَائِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","وَجَمَعَا كُلَّ ٱلْجَمَاعَةِ فِي أَوَّلِ ٱلشَّهْرِ ٱلثَّانِي، فَٱنْتَسَبُوا إِلَى عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ بِعَدَدِ ٱلْأَسْمَاءِ، مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا بِرُؤُوسِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. فَعَدَّهُمْ فِي بَرِّيَّةِ سِينَاءَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","فَكَانَ بَنُو رَأُوبَيْنَ بِكْرِ إِسْرَائِيلَ، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ بِرُؤُوسِهِمْ، كُلُّ ذَكَرٍ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","كَانَ ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ رَأُوبَيْنَ سِتَّةً وَأَرْبَعِينَ أَلْفًا وَخَمْسَ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","بَنُو شِمْعُونَ، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمِ، ٱلْمَعْدُودُونَ مِنْهُمْ بِعَدَدِ ٱلْأَسْمَاءِ بِرُؤُوسِهِمْ، كُلُّ ذَكَرٍ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ شِمْعُونَ تِسْعَةٌ وَخَمْسُونَ أَلْفًا وَثَلَاثُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","بَنُو جَادَ، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ جَادَ خَمْسَةٌ وَأَرْبَعُونَ أَلْفًا وَسِتُّ مِئَةٍ وَخَمْسُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","بَنُو يَهُوذَا، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ يَهُوذَا أَرْبَعَةٌ وَسَبْعُونَ أَلْفًا وَسِتُّ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","بَنُو يَسَّاكَرَ، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ يَسَّاكَرَ أَرْبَعَةٌ وَخَمْسُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","بَنُو زَبُولُونَ، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ زَبُولُونَ سَبْعَةٌ وَخَمْسُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","بَنُو يُوسُفَ: بَنُو أَفْرَايِمَ، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ أَفْرَايِمَ أَرْبَعُونَ أَلْفًا وَخَمْسُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","بَنُو مَنَسَّى، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ مَنَسَّى ٱثْنَانِ وَثَلَاثُونَ أَلْفًا وَمِئَتَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","بَنُو بَنْيَامِينَ، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ بَنْيَامِينَ خَمْسَةٌ وَثَلَاثُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","بَنُو دَانَ، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ دَانَ ٱثْنَانِ وَسِتُّونَ أَلْفًا وَسَبْعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","بَنُو أَشِيرَ، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ أَشِيرَ وَاحِدٌ وأَرْبَعُونَ أَلْفًا وَخَمْسُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","بَنُو نَفْتَالِي، تَوَالِيدُهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، بِعَدَدِ ٱلْأَسْمَاءِ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ٱلْمَعْدُودُونَ مِنْهُمْ لِسِبْطِ نَفْتَالِي ثَلَاثَةٌ وَخَمْسُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","هَؤُلَاءِ هُمُ ٱلْمَعْدُودُونَ ٱلَّذِينَ عَدَّهُمْ مُوسَى وَهَارُونُ وَرُؤَسَاءُ إِسْرَائِيلَ، ٱثْنَا عَشَرَ رَجُلًا، رَجُلٌ وَاحِدٌ لِبَيْتِ آبَائِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","فَكَانَ جَمِيعُ ٱلْمَعْدُودِينَ مِنْ بَنِي إِسْرَائِيلَ حَسَبَ بُيُوتِ آبَائِهِمْ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، كُلُّ خَارِجٍ لِلْحَرْبِ فِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","كَانَ جَمِيعُ ٱلْمَعْدُودِينَ سِتَّ مِئَةِ أَلْفٍ وَثَلَاثَةَ آلَافٍ وَخَمْسَ مِئَةٍ وَخَمْسِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","وَأَمَّا ٱللَّاوِيُّونَ حَسَبَ سِبْطِ آبَائِهِمْ فَلَمْ يُعَدُّوا بَيْنَهُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","إِذْ كَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«أَمَّا سِبْطُ لَاوِي فَلَا تَحْسُبُهُ وَلَا تَعُدَّهُ بَيْنَ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","بَلْ وَكِّلِ ٱللَّاوِيِّينَ عَلَى مَسْكَنِ ٱلشَّهَادَةِ وَعَلَى جَمِيعِ أَمْتِعَتِهِ وَعَلَى كُلِّ مَا لَهُ. هُمْ يَحْمِلُونَ ٱلْمَسْكَنَ وَكُلَّ أَمْتِعَتِهِ، وَهُمْ يَخْدِمُونَهُ، وَحَوْلَ ٱلْمَسْكَنِ يَنْزِلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","فَعِنْدَ ٱرْتِحَالِ ٱلْمَسْكَنِ يُنَزِّلُهُ ٱللَّاوِيُّونَ وَعِنْدَ نُزُولِ ٱلْمَسْكَنِ يُقِيمُهُ ٱللَّاوِيُّونَ. وَٱلْأَجْنَبِيُّ ٱلَّذِي يَقْتَرِبُ يُقْتَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","وَيَنْزِلُ بَنُو إِسْرَائِيلَ كُلٌّ فِي مَحَلَّتِهِ وَكُلٌّ عِنْدَ رَايَتِهِ بِأَجْنَادِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","وَأَمَّا ٱللَّاوِيُّونَ فَيَنْزِلُونَ حَوْلَ مَسْكَنِ ٱلشَّهَادَةِ لِكَيْ لَا يَكُونَ سَخَطٌ عَلَى جَمَاعَةِ بَنِي إِسْرَائِيلَ، فَيَحْفَظُ ٱللَّاوِيُّونَ شَعَائِرَ مَسْكَنِ ٱلشَّهَادَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","فَفَعَلَ بَنُو إِسْرَائِيلَ حَسَبَ كُلِّ مَا أَمَرَ ٱلرَّبُّ مُوسَى كَذَلِكَ فَعَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ َقَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«يَنْزِلُ بَنُو إِسْرَائِيلَ كُلٌّ عِنْدَ رَايَتِهِ بِأَعْلَامٍ لِبُيُوتِ آبَائِهِمْ. قُبَالَةَ خَيْمَةِ ٱلِٱجْتِمَاعِ حَوْلَهَا يَنْزِلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","فَٱلنَّازِلُونَ إِلَى ٱلشَّرْقِ، نَحْوَ ٱلشُّرُوقِ، رَايَةُ مَحَلَّةِ يَهُوذَا حَسَبَ أَجْنَادِهِمْ، وَٱلرَّئِيسُ لِبَنِي يَهُوذَا نَحْشُونُ بْنُ عَمِّينَادَابَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُمْ أَرْبَعَةٌ وَسَبْعُونَ أَلْفًا وَسِتُّ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","وَٱلنَّازِلُونَ مَعَهُ سِبْطُ يَسَّاكَرَ، وَٱلرَّئِيسُ لِبَنِي يَسَّاكَرَ نَثَنَائِيلُ بْنُ صُوغَرَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُ أَرْبَعَةٌ وَخَمْسُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","وَسِبْطُ زَبُولُونَ، وَٱلرَّئِيسُ لِبَنِي زَبُولُونَ أَلِيآبُ بْنُ حِيلُونَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُ سَبْعَةٌ وَخَمْسُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","جَمِيعُ ٱلْمَعْدُودِينَ لِمَحَلَّةِ يَهُوذَا مِئَةُ أَلْفٍ وَسِتَّةٌ وَثَمَانُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ بِأَجْنَادِهِمْ. يَرْتَحِلُونَ أَوَّلًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","«رَايَةُ مَحَلَّةِ رَأُوبَيْنَ إِلَى ٱلتَّيْمَنِ حَسَبَ أَجْنَادِهِمْ، وَٱلرَّئِيسُ لِبَنِي رَأُوبَيْنَ أَلِيصُورُ بْنُ شَدَيْئُورَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُ سِتَّةٌ وَأَرْبَعُونَ أَلْفًا وَخَمْسُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","وَٱلنَّازِلُونَ مَعَهُ سِبْطُ شِمْعُونَ، وَٱلرَّئِيسُ لِبَنِي شِمْعُونَ شَلُومِيئِيلُ بْنُ صُورِيشَدَّاي، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُمْ تِسْعَةٌ وَخَمْسُونَ أَلْفًا وَثَلَاثُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","وَسِبْطُ جَادَ، وَٱلرَّئِيسُ لِبَنِي جَادْ أَلِيَاسَافُ بْنُ رَعُوئِيلَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُمْ خَمْسَةٌ وَأَرْبَعُونَ أَلْفًا وَسِتُّ مِئَةٍ وَخَمْسُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","جَمِيعُ ٱلْمَعْدُودِينَ لِمَحَلَّةِ رَأُوبَيْنَ مِئَةُ أَلْفٍ وَوَاحِدٌ وَخَمْسُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ وَخَمْسُونَ بِأَجْنَادِهِمْ، وَيَرْتَحِلُونَ ثَانِيَةً. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","«ثُمَّ تَرْتَحِلُ خَيْمَةُ ٱلِٱجْتِمَاعِ. مَحَلَّةُ ٱللَّاوِيِّينَ فِي وَسَطِ ٱلْمَحَلَّاتِ. كَمَا يَنْزِلُونَ كَذَلِكَ يَرْتَحِلُونَ. كُلٌّ فِي مَوْضِعِهِ بِرَايَاتِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","«رَايَةُ مَحَلَّةِ أَفْرَايِمَ حَسَبَ أَجْنَادِهِمْ إِلَى ٱلْغَرْبِ، وَٱلرَّئِيسُ لِبَنِي أَفْرَايِمَ أَلِيشَمَعُ بْنُ عَمِّيهُودَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُمْ أَرْبَعُونَ أَلْفًا وَخَمْسُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","وَمَعَهُ سِبْطُ مَنَسَّى، وَٱلرَّئِيسُ لِبَنِي مَنَسَّى جَمْلِيئِيلُ بْنُ فَدَهْصُورَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُمُ ٱثْنَانِ وَثَلَاثُونَ أَلْفًا وَمِئَتَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","وَسِبْطُ بَنْيَامِينَ، وَٱلرَّئِيسُ لِبَنِي بَنْيَامِينَ أَبِيدَنُ بْنُ جِدْعُونِي، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُمْ خَمْسَةٌ وَثَلَاثُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","جَمِيعُ ٱلْمَعْدُودِينَ لِمَحَلَّةِ أَفْرَايِمَ مِئَةُ أَلْفٍ وَثَمَانِيَةُ آلَافٍ وَمِئَةٌ بِأَجْنَادِهِمْ، وَيَرْتَحِلُونَ ثَالِثَةً. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","«رَايَةُ مَحَلَّةِ دَانَ إِلَى ٱلشِّمَالِ حَسَبَ أَجْنَادِهِمْ، وَٱلرَّئِيسُ لِبَنِي دَانَ أَخِيعَزَرُ بْنُ عَمِّيشَدَّاي، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُمُ ٱثْنَانِ وَسِتُّونَ أَلْفًا وَسَبْعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","وَٱلنَّازِلُونَ مَعَهُ سِبْطُ أَشِيرَ، وَٱلرَّئِيسُ لِبَنِي أَشِيرَ فَجْعِيئِيلُ بْنُ عُكْرَنَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُمْ وَاحِدٌ وَأَرْبَعُونَ أَلْفًا وَخَمْسُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","وَسِبْطُ نَفْتَالِي، وَٱلرَّئِيسُ لِبَنِي نَفْتَالِي أَخِيرَعُ بْنُ عِينَنَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","وَجُنْدُهُ ٱلْمَعْدُودُونَ مِنْهُمْ ثَلَاثَةٌ وَخَمْسُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","جَمِيعُ ٱلْمَعْدُودِينَ لِمَحَلَّةِ دَانَ مِئَةُ أَلْفٍ وَسَبْعَةٌ وَخَمْسُونَ أَلْفًا وَسِتُّ مِئَةٍ. يَرْتَحِلُونَ أَخِيرًا بِرَايَاتِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","هَؤُلَاءِ هُمُ ٱلْمَعْدُودُونَ مِنْ بَنِي إِسْرَائِيلَ حَسَبَ بُيُوتِ آبَائِهِمْ. جَمِيعُ ٱلْمَعْدُودِينَ مِنَ ٱلْمَحَلَّاتِ بِأَجْنَادِهِمْ سِتُّ مِئَةِ أَلْفٍ وَثَلَاثَةُ آلَافٍ وَخَمْسُ مِئَةٍ وَخَمْسُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","وَأَمَّا ٱللَّاوِيُّونَ فَلَمْ يُعَدُّوا بَيْنَ بَنِي إِسْرَائِيلَ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","فَفَعَلَ بَنُو إِسْرَائِيلَ حَسَبَ كُلِّ مَا أَمَرَ بِهِ ٱلرَّبُّ مُوسَى. هَكَذَا نَزَلُوا بِرَايَاتِهِمْ، وَهَكَذَا ٱرْتَحَلُوا. كُلٌّ حَسَبَ عَشَائِرِهِ مَعَ بَيْتِ آبَائِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","وَهَذِهِ تَوَالِيدُ هَارُونَ وَمُوسَى يَوْمَ كَلَّمَ ٱلرَّبُّ مُوسَى فِي جَبَلِ سِينَاءَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","وَهَذِهِ أَسْمَاءُ بَنِي هَارُونَ: نَادَابُ ٱلْبِكْرُ، وَأَبِيهُو وَأَلِعَازَارُ وَإِيثَامَارُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","هَذِهِ أَسْمَاءُ بَنِي هَارُونَ ٱلْكَهَنَةِ ٱلْمَمْسُوحِينَ ٱلَّذِينَ مَلَأَ أَيْدِيَهُمْ لِلْكَهَانَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","وَلَكِنْ مَاتَ نَادَابُ وَأَبِيهُو أَمَامَ ٱلرَّبِّ عِنْدَمَا قَرَّبَا نَارًا غَرِيبَةً أَمَامَ ٱلرَّبِّ فِي بَرِّيَّةِ سِينَاءَ، وَلَمْ يَكُنْ لَهُمَا بَنُونَ. وَأَمَّا أَلِعَازَارُ وَإِيثَامَارُ فَكَهَنَا أَمَامَ هَارُونَ أَبِيهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«قَدِّمْ سِبْطَ لَاوِي وَأَوْقِفْهُمْ قُدَّامَ هَارُونَ ٱلْكَاهِنِ وَلْيَخْدِمُوهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","فَيَحْفَظُونَ شَعَائِرَهُ وَشَعَائِرَ كُلِّ ٱلْجَمَاعَةِ قُدَّامَ خَيْمَةِ ٱلِٱجْتِمَاعِ، وَيَخْدِمُونَ خِدْمَةَ ٱلْمَسْكَنِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","فَيَحْرُسُونَ كُلَّ أَمْتِعَةِ خَيْمَةِ ٱلِٱجْتِمَاعِ، وَحِرَاسَةِ بَنِي إِسْرَائِيلَ وَيَخْدِمُونَ خِدْمَةَ ٱلْمَسْكَنِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","فَتُعْطِي ٱللَّاوِيِّينَ لِهَارُونَ وَلِبَنِيهِ. إِنَّهُمْ مَوْهُوبُونَ لَهُ هِبَةً مِنْ عِنْدِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","وَتُوَكِّلُ هَارُونَ وَبَنِيهِ فَيَحْرُسُونَ كَهَنُوتَهُمْ، وَٱلْأَجْنَبِيُّ ٱلَّذِي يَقْتَرِبُ يُقْتَلُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«وَهَا إِنِّي قَدْ أَخَذْتُ ٱللَّاوِيِّينَ مِنْ بَيْنِ بَنِي إِسْرَائِيلَ، بَدَلَ كُلِّ بِكْرٍ فَاتِحِ رَحِمٍ مِنْ بَنِي إِسْرَائِيلَ فَيَكُونُ ٱللَّاوِيُّونَ لِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","لِأَنَّ لِي كُلَّ بِكْرٍ. يَوْمَ ضَرَبْتُ كُلَّ بِكْرٍ فِي أَرْضِ مِصْرَ قَدَّسْتُ لِي كُلَّ بِكْرٍ فِي إِسْرَائِيلَ مِنَ ٱلنَّاسِ وَٱلْبَهَائِمِ. لِي يَكُونُونَ. أَنَا ٱلرَّبُّ». ");
INSERT INTO arb_vd_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","وَكَلَّمَ ٱلرَّبُّ مُوسَى فِي بَرِّيَّةِ سِينَاءَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«عُدَّ بَنِي لَاوِي حَسَبَ بُيُوتِ آبَائِهِمْ وَعَشَائِرِهِمْ. كُلَّ ذَكَرٍ مِنِ ٱبْنِ شَهْرٍ فَصَاعِدًا تَعُدُّهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","فَعَدَّهُمْ مُوسَى حَسَبَ قَوْلِ ٱلرَّبِّ كَمَا أُمِرَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","وَكَانَ هَؤُلَاءِ بَنِي لَاوِي بِأَسْمَائِهِمْ: جَرْشُونُ وَقَهَاتُ وَمَرَارِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","وَهَذَانِ ٱسْمَا ٱبْنَيْ جَرْشُونَ حَسَبَ عَشَائِرِهِمَا: لِبْنِي وَشِمْعِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","وَبَنُو قَهَاتَ حَسَبَ عَشَائِرِهِمْ: عَمْرَامُ وَيِصْهَارُ وَحَبْرُونُ وَعُزِّيئِيلُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","وَٱبْنَا مَرَارِي حَسَبَ عَشَائِرِهِمَا: مَحْلِي وَمُوشِي. هَذِهِ هِيَ عَشَائِرُ ٱللَّاوِيِّينَ حَسَبَ بُيُوتِ آبَائِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","لِجَرْشُونَ عَشِيرَةُ ٱللِّبْنِيِّينَ وَعَشِيرَةُ ٱلشِّمْعِيِّينَ. هَذِهِ هِيَ عَشَائِرُ ٱلْجَرْشُونِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ٱلْمَعْدُودُونَ مِنْهُمْ بِعَدَدِ كُلِّ ذَكَرٍ مِنِ ٱبْنِ شَهْرٍ فَصَاعِدًا، ٱلْمَعْدُودُونَ مِنْهُمْ سَبْعَةُ آلَافٍ وَخَمْسُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","عَشَائِرُ ٱلْجَرْشُونِيِّينَ يَنْزِلُونَ وَرَاءَ ٱلْمَسْكَنِ إِلَى ٱلْغَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","وَٱلرَّئِيسُ لِبَيْتِ أَبِي ٱلْجَرْشُونِيِّينَ أَلِيَاسَافُ بْنُ لَايِلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","وَحِرَاسَةُ بَنِي جَرْشُونَ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ: ٱلْمَسْكَنُ، وَٱلْخَيْمَةُ وَغِطَاؤُهَا، وَسَجْفُ بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","وَأَسْتَارُ ٱلدَّارِ وَسَجْفُ بَابِ ٱلدَّارِ ٱللَّوَاتِي حَوْلَ ٱلْمَسْكَنِ وَحَوْلَ ٱلْمَذْبَحِ مُحِيطًا وَأَطْنَابُهُ مَعَ كُلِّ خِدْمَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","وَلِقَهَاتَ عَشِيرَةُ ٱلْعَمْرَامِيِّينَ وَعَشِيرَةُ ٱلْيِصْهَارِيِّينَ وَعَشِيرَةُ ٱلْحَبْرُونِيِّينَ وَعَشِيرَةُ ٱلْعُزِّيئِيلِيِّينَ. هَذِهِ عَشَائِرُ ٱلْقَهَاتِيِّينَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","بِعَدَدِ كُلِّ ذَكَرٍ مِنِ ٱبْنِ شَهْرٍ فَصَاعِدًا ثَمَانِيَةُ آلَافٍ وَسِتُّ مِئَةٍ حَارِسِينَ حِرَاسَةَ ٱلْقُدْسِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","وَعَشَائِرُ بَنِي قَهَاتَ يَنْزِلُونَ عَلَى جَانِبِ ٱلْمَسْكَنِ إِلَى ٱلتَّيْمَنِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","وَٱلرَّئِيسُ لِبَيْتِ أَبِي عَشِيرَةِ ٱلْقَهَاتِيِّينَ أَلِيصَافَانُ بْنُ عُزِّيئِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","وَحِرَاسَتُهُمُ ٱلتَّابُوتُ وَٱلْمَائِدَةُ وَٱلْمَنَارَةُ وَٱلْمَذْبَحَانِ وَأَمْتِعَةُ ٱلْقُدْسِ ٱلَّتِي يَخْدِمُونَ بِهَا، وَٱلْحِجَابُ وَكُلُّ خِدْمَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","وَلِرَئِيسِ رُؤَسَاءِ ٱللَّاوِيِّينَ أَلِعَازَارَ بْنِ هَارُونَ ٱلْكَاهِنِ وَكَالَةُ حُرَّاسِ حِرَاسَةِ ٱلْقُدْسِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","وَلِمَرَارِي عَشِيرَةُ ٱلْمَحْلِيِّينَ وَعَشِيرَةُ ٱلْمُوشِيِّينَ. هَذِهِ هِيَ عَشَائِرُ مَرَارِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","وَٱلْمَعْدُودُونَ مِنْهُمْ بِعَدَدِ كُلِّ ذَكَرٍ مِنِ ٱبْنِ شَهْرٍ فَصَاعِدًا سِتَّةُ آلَافٍ وَمِئَتَانِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","وَٱلرَّئِيسُ لِبَيْتِ أَبِي عَشَائِرِ مَرَارِي صُورِيئِيلُ بْنُ أَبِيَحَايِلَ. يَنْزِلُونَ عَلَى جَانِبِ ٱلْمَسْكَنِ إِلَى ٱلشِّمَالِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","وَوَكَالَةُ حِرَاسَةِ بَنِي مَرَارِي: أَلْوَاحُ ٱلْمَسْكَنِ وَعَوَارِضُهُ وَأَعْمِدَتُهُ وَفُرَضُهُ وَكُلُّ أَمْتِعَتِهِ وَكُلُّ خِدْمَتِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","وَأَعْمِدَةُ ٱلدَّارِ حَوَالَيْهَا وَفُرَضُهَا وَأَوْتَادُهَا وَأَطْنَابُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","وَٱلنَّازِلُونَ قُدَّامَ ٱلْمَسْكَنِ إِلَى ٱلشَّرْقِ قُدَّامَ خَيْمَةِ ٱلِٱجْتِمَاعِ، نَحْوَ ٱلشُّرُوقِ، هُمْ مُوسَى وَهَارُونُ وَبَنُوهُ، حَارِسِينَ حِرَاسَةَ ٱلْمَقْدِسِ لِحِرَاسَةِ بَنِي إِسْرَائِيلَ، وَٱلْأَجْنَبِيُّ ٱلَّذِي يَقْتَرِبُ يُقْتَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","جَمِيعُ ٱلْمَعْدُودِينَ مِنَ ٱللَّاوِيِّينَ ٱلَّذِينَ عَدَّهُمْ مُوسَى وَهَارُونُ حَسَبَ قَوْلِ ٱلرَّبِّ بِعَشَائِرِهِمْ، كُلُّ ذَكَرٍ مِنِ ٱبْنِ شَهْرٍ فَصَاعِدًا، ٱثْنَانِ وَعِشْرُونَ أَلْفًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","وَقَالَ ٱلرَّبُّ لِمُوسَى: «عُدَّ كُلَّ بِكْرٍ ذَكَرٍ مِنْ بَنِي إِسْرَائِيلَ مِنِ ٱبْنِ شَهْرٍ فَصَاعِدًا، وَخُذْ عَدَدَ أَسْمَائِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","فَتَأْخُذُ ٱللَّاوِيِّينَ لِي. أَنَا ٱلرَّبُّ. بَدَلَ كُلِّ بِكْرٍ فِي بَنِي إِسْرَائِيلَ. وَبَهَائِمَ ٱللَّاوِيِّينَ بَدَلَ كُلِّ بِكْرٍ فِي بَهَائِمِ بَنِي إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","فَعَدَّ مُوسَى كَمَا أَمَرَهُ ٱلرَّبُّ كُلَّ بِكْرٍ فِي بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","فَكَانَ جَمِيعُ ٱلْأَبْكَارِ ٱلذُّكُورِ بِعَدَدِ ٱلْأَسْمَاءِ مِنِ ٱبْنِ شَهْرٍ فَصَاعِدًا، ٱلْمَعْدُودِينَ مِنْهُمُ ٱثْنَيْنِ وَعِشْرِينَ أَلْفًا وَمِئَتَيْنِ وَثَلَاثَةً وَسَبْعِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«خُذِ ٱللَّاوِيِّينَ بَدَلَ كُلِّ بِكْرٍ فِي بَنِي إِسْرَائِيلَ، وَبَهَائِمَ ٱللَّاوِيِّينَ بَدَلَ بَهَائِمِهِمْ، فَيَكُونَ لِيَ ٱللَّاوِيُّونَ. أَنَا ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","وَأَمَّا فِدَاءُ ٱلْمِئَتَيْنِ وَٱلثَّلَاثَةِ وَٱلسَّبْعِينَ ٱلزَّائِدِينَ عَلَى ٱللَّاوِيِّينَ مِنْ أَبْكَارِ بَنِي إِسْرَائِيلَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","فَتَأْخُذُ خَمْسَةَ شَوَاقِلَ لِكُلِّ رَأْسٍ. عَلَى شَاقِلِ ٱلْقُدْسِ تَأْخُذُهَا. عِشْرُونَ جِيرَةً ٱلشَّاقِلُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","وَتُعْطِي ٱلْفِضَّةَ لِهَارُونَ وَبَنِيهِ فِدَاءَ ٱلزَّائِدِينَ عَلَيْهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","فَأَخَذَ مُوسَى فِضَّةَ فِدَائِهِمْ مِنَ ٱلزَّائِدِينَ عَلَى فِدَاءِ ٱللَّاوِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","مِنْ أَبْكَارِ بَنِي إِسْرَائِيلَ أَخَذَ ٱلْفِضَّةَ أَلْفًا وَثَلَاثَ مِئَةٍ وَخَمْسَةً وَسِتِّينَ عَلَى شَاقِلِ ٱلْقُدْسِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","وَأَعْطَى مُوسَى فِضَّةَ ٱلْفِدَاءِ لِهَارُونَ وَبَنِيهِ حَسَبَ قَوْلِ ٱلرَّبِّ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«خُذْ عَدَدَ بَنِي قَهَاتَ مِنْ بَيْنِ بَنِي لَاوِي حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","مِنِ ٱبْنِ ثَلَاثِينَ سَنَةً فَصَاعِدًا إِلَى ٱبْنِ خَمْسِينَ سَنَةً، كُلِّ دَاخِلٍ فِي ٱلْجُنْدِ لِيَعْمَلَ عَمَلًا فِي خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","هَذِهِ خِدْمَةُ بَنِي قَهَاتَ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ: قُدْسُ ٱلْأَقْدَاسِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","يَأْتِي هَارُونُ وَبَنُوهُ عِنْدَ ٱرْتِحَالِ ٱلْمَحَلَّةِ وَيُنَزِّلُونَ حِجَابَ ٱلسَّجْفِ وَيُغَطُّونَ بِهِ تَابُوتَ ٱلشَّهَادَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","وَيَجْعَلُونَ عَلَيْهِ غِطَاءً مِنْ جِلْدِ تُخَسٍ، وَيَبْسُطُونَ مِنْ فَوْقُ ثَوْبًا كُلُّهُ أَسْمَانْجُونِيٌّ، وَيَضَعُونَ عِصِيَّهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","وَعَلَى مَائِدَةِ ٱلْوُجُوهِ يَبْسُطُونَ ثَوْبَ أَسْمَانْجُونٍ، وَيَضَعُونَ عَلَيْهِ ٱلصِّحَافَ وَٱلصُّحُونَ وَٱلْأَقْدَاحَ وَكَاسَاتِ ٱلسَّكِيبِ، وَيَكُونُ ٱلْخُبْزُ ٱلدَّائِمُ عَلَيْهِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","وَيَبْسُطُونَ عَلَيْهَا ثَوْبَ قِرْمِزٍ وَيُغَطُّونَهُ بِغِطَاءٍ مِنْ جِلْدِ تُخَسٍ وَيَضَعُونَ عِصِيَّهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","وَيَأْخُذُونَ ثَوْبَ أَسْمَانْجُونٍ وَيُغَطُّونَ مَنَارَةَ ٱلضَّوْءِ وَسُرُجَهَا وَمَلَاقِطَهَا وَمَنَافِضَهَا وَجَمِيعَ آنِيَةِ زَيْتِهَا ٱلَّتِي يَخْدِمُونَهَا بِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","وَيَجْعَلُونَهَا وَجَمِيعَ آنِيَتَهَا فِي غِطَاءٍ مِنْ جِلْدِ تُخَسٍ، وَيَجْعَلُونَهُ عَلَى ٱلْعَتَلَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","وَعَلَى مَذْبَحِ ٱلذَّهَبِ يَبْسُطُونَ ثَوْبَ أَسْمَانْجُونٍ، وَيُغَطُّونَهُ بِغِطَاءٍ مِنْ جِلْدِ تُخَسٍ وَيَضَعُونَ عِصِيَّهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","وَيَأْخُذُونَ جَمِيعَ أَمْتِعَةِ ٱلْخِدْمَةِ ٱلَّتِي يَخْدِمُونَ بِهَا فِي ٱلْقُدْسِ، وَيَجْعَلُونَهَا فِي ثَوْبِ أَسْمَانْجُونٍ وَيُغَطُّونَهَا بِغِطَاءٍ مِنْ جِلْدِ تُخَسٍ، وَيَجْعَلُونَهَا عَلَى ٱلْعَتَلَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","وَيَرْفَعُونَ رَمَادَ ٱلْمَذْبَحِ، وَيَبْسُطُونَ عَلَيْهِ ثَوْبَ أُرْجُوانٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","وَيَجْعَلُونَ عَلَيْهِ جَمِيعَ أَمْتِعَتِهِ ٱلَّتِي يَخْدِمُونَ عَلَيْهِ بِهَا: ٱلْمَجَامِرَ وَٱلْمَنَاشِلَ وَٱلرُّفُوشَ وَٱلْمَنَاضِحَ، كُلَّ أَمْتِعَةِ ٱلْمَذْبَحِ، وَيَبْسُطُونَ عَلَيْهِ غِطَاءً مِنْ جِلْدِ تُخَسٍ، وَيَضَعُونَ عِصِيَّهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","وَمَتَى فَرَغَ هَارُونُ وَبَنُوهُ مِنْ تَغْطِيَةِ ٱلْقُدْسِ وَجَمِيعِ أَمْتِعَةِ ٱلْقُدْسِ عِنْدَ ٱرْتِحَالِ ٱلْمَحَلَّةِ، يَأْتِي بَعْدَ ذَلِكَ بَنُو قَهَاتَ لِلْحَمْلِ وَلَكِنْ لَا يَمَسُّوا ٱلْقُدْسَ لِئَلَّا يَمُوتُوا. ذَلِكَ حِمْلُ بَنِي قَهَاتَ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","وَوِكَالَةُ أَلِعَازَارَ بْنِ هَارُونَ ٱلْكَاهِنِ هِيَ زَيْتُ ٱلضَّوْءِ وَٱلْبَخُورُ ٱلْعَطِرُ وَٱلتَّقْدِمَةُ ٱلدَّائِمَةُ وَدُهْنُ ٱلْمَسْحَةِ، وَوِكَالَةُ كُلِّ ٱلْمَسْكَنِ وَكُلِّ مَا فِيهِ بِٱلْقُدْسِ وَأَمْتِعَتِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«لَا تَقْرِضَا سِبْطَ عَشَائِرِ ٱلْقَهَاتِيِّينَ مِنْ بَيْنِ ٱللَّاوِيِّينَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","بَلِ ٱفْعَلَا لَهُمْ هَذَا فَيَعِيشُوا وَلَا يَمُوتُوا عِنْدَ ٱقْتِرَابِهِمْ إِلَى قُدْسِ ٱلْأَقْدَاسِ: يَدْخُلُ هَارُونُ وَبَنُوهُ وَيُقِيمُونَهُمْ كُلَّ إِنْسَانٍ عَلَى خِدْمَتِهِ وَحِمْلِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","وَلَا يَدْخُلُوا لِيَرَوْا ٱلْقُدْسَ لَحْظَةً لِئَلَّا يَمُوتُوا». ");
INSERT INTO arb_vd_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«خُذْ عَدَدَ بَنِي جَرْشُونَ أَيْضًا حَسَبَ بُيُوتِ آبَائِهِمْ وَعَشَائِرِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","مِنِ ٱبْنِ ثَلَاثِينَ سَنَةً فَصَاعِدًا إِلَى ٱبْنِ خَمْسِينَ سَنَةً تَعُدُّهُمْ، كُلَّ ٱلدَّاخِلِينَ لِيَتَجَنَّدُوا أَجْنَادًا، لِيَخْدِمُوا خِدْمَةً فِي خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","هَذِهِ خِدْمَةُ عَشَائِرِ ٱلْجَرْشُونِيِّينَ مِنَ ٱلْخِدْمَةِ وَٱلْحِمْلِ: ");
INSERT INTO arb_vd_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","يَحْمِلُونَ شُقَقَ ٱلْمَسْكَنِ، وَخَيْمَةَ ٱلِٱجْتِمَاعِ وَغِطَاءَهَا، وَغِطَاءَ ٱلتُّخَسِ ٱلَّذِي عَلَيْهَا مِنْ فَوْقُ، وَسَجْفَ بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","وَأَسْتَارَ ٱلدَّارِ وَسَجْفَ مَدْخَلِ بَابِ ٱلدَّارِ ٱللَّوَاتِي حَوْلَ ٱلْمَسْكَنِ وَحَوْلَ ٱلْمَذْبَحِ مُحِيطَةً، وَأَطْنَابَهُنَّ وَكُلَّ أَمْتِعَةِ خِدْمَتِهِنَّ. وَكُلُّ مَا يُعْمَلُ لَهُنَّ فَهُمْ يَصْنَعُونَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","حَسَبَ قَوْلِ هَارُونَ وَبَنِيهِ تَكُونُ جَمِيعُ خِدْمَةِ بَنِي ٱلْجَرْشُونِيِّينَ مِنْ كُلِّ حَمْلِهِمْ وَمِنْ كُلِّ خِدْمَتِهِمْ. وَتُوَكِّلُهُمْ بِحِرَاسَةِ كُلِّ أَحْمَالِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","هَذِهِ خِدْمَةُ عَشَائِرِ بَنِي ٱلْجَرْشُونِيِّينَ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ، وَحِرَاسَتُهُمْ بِيَدِ إِيثَامَارَ بْنِ هَارُونَ ٱلكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«بَنُو مَرَارِي حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ تَعُدُّهُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","مِنِ ٱبْنِ ثَلَاثِينَ سَنَةً فَصَاعِدًا إِلَى ٱبْنِ خَمْسِينَ سَنَةً تَعُدُّهُمْ، كُلَّ ٱلدَّاخِلِينَ فِي ٱلْجُنْدِ لِيَخْدِمُوا خِدْمَةَ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","وَهَذِهِ حِرَاسَةُ حَمْلِهِمْ وَكُلُّ خِدْمَتِهِمْ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ: أَلْوَاحُ ٱلْمَسْكَنِ وَعَوَارِضُهُ وَأَعْمِدَتُهُ وَفُرَضُهُ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","وَأَعْمِدَةُ ٱلدَّارِ حَوَالَيْهَا وَفُرَضُهَا وَأَوْتَادُهَا وَأَطْنَابُهَا مَعَ كُلِّ أَمْتِعَتِهَا وَكُلِّ خِدْمَتِهَا. وَبِٱلْأَسْمَاءِ تَعُدُّونَ أَمْتِعَةَ حِرَاسَةِ حَمْلِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","هَذِهِ خِدْمَةُ عَشَائِرِ بَنِي مَرَارِي. كُلُّ خِدْمَتِهِمْ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ بِيَدِ إِيثَامَارَ بْنِ هَارُونَ ٱلْكَاهِنِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","فَعَدَّ مُوسَى وَهَارُونُ وَرُؤَسَاءُ ٱلْجَمَاعَةِ بَنِي ٱلْقَهَاتِيِّينَ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","مِنِ ٱبْنِ ثَلَاثِينَ سَنَةً فَصَاعِدًا إِلَى ٱبْنِ خَمْسِينَ سَنَةً، كُلَّ ٱلدَّاخِلِينَ فِي ٱلْجُنْدِ لِلْخِدْمَةِ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","فَكَانَ ٱلْمَعْدُودُونَ مِنْهُمْ حَسَبَ عَشَائِرِهِمْ أَلْفَيْنِ وَسَبْعَ مِئَةٍ وَخَمْسِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","هَؤُلَاءِ هُمُ ٱلْمَعْدُودُونَ مِنْ عَشَائِرِ ٱلْقَهَاتِيِّينَ، كُلُّ ٱلْخَادِمِينَ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ ٱلَّذِينَ عَدَّهُمْ مُوسَى وَهَارُونُ حَسَبَ قَوْلِ ٱلرَّبِّ عَنْ يَدِ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","وَٱلْمَعْدُودُونَ مِنْ بَنِي جَرْشُونَ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","مِنِ ٱبْنِ ثَلَاثِينَ سَنَةً فَصَاعِدًا إِلَى ٱبْنِ خَمْسِينَ سَنَةً، كُلُّ ٱلدَّاخِلِينَ فِي ٱلْجُنْدِ لِلْخِدْمَةِ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","كَانَ ٱلْمَعْدُودُونَ مِنْهُمْ حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ أَلْفَيْنِ وَسِتَّ مِئَةٍ وَثَلَاثِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","هَؤُلَاءِ هُمُ ٱلْمَعْدُودُونَ مِنْ عَشَائِرِ بَنِي جَرْشُونَ، كُلُّ ٱلْخَادِمِينَ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ ٱلَّذِينَ عَدَّهُمْ مُوسَى وَهَارُونُ حَسَبَ قَوْلِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","وَٱلْمَعْدُودُونَ مِنْ عَشَائِرِ بَنِي مَرَارِي حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","مِنِ ٱبْنِ ثَلَاثِينَ سَنَةً فَصَاعِدًا إِلَى ٱبْنِ خَمْسِينَ سَنَةً، كُلُّ ٱلدَّاخِلْينَ فِي ٱلْجُنْدِ لِلْخِدْمَةِ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","كَانَ ٱلْمَعْدُودُونَ مِنْهُمْ حَسَبَ عَشَائِرِهِمْ ثَلَاثَةَ آلَافٍ وَمِئَتَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","هَؤُلَاءِ هُمُ ٱلْمَعْدُودُونَ مِنْ عَشَائِرِ بَنِي مَرَارِي ٱلَّذِينَ عَدَّهُمْ مُوسَى وَهَارُونُ حَسَبَ قَوْلِ ٱلرَّبِّ عَنْ يَدِ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","جَمِيعُ ٱلْمَعْدُودِينَ ٱللَّاوِيِّينَ ٱلَّذِينَ عَدَّهُمْ مُوسَى وَهَارُونُ وَرُؤَسَاءُ إِسْرَائِيلَ، حَسَبَ عَشَائِرِهِمْ وَبُيُوتِ آبَائِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","مِنِ ٱبْنِ ثَلَاثِينَ سَنَةً فَصَاعِدًا إِلَى ٱبْنِ خَمْسِينَ سَنَةً، كُلُّ ٱلدَّاخِلِينَ لِيَعْمَلُوا عَمَلَ ٱلْخِدْمَةِ وَعَمَلَ ٱلْحَمْلِ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","كَانَ ٱلْمَعْدُودُونَ مِنْهُمْ ثَمَانِيَةَ آلَافٍ وَخَمْسَ مِئَةٍ وَثَمَانِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","حَسَبَ قَوْلِ ٱلرَّبِّ عَنْ يَدِ مُوسَى عُدَّ كُلُّ إِنْسَانٍ عَلَى خِدْمَتِهِ وَعَلَى حَمْلِهِ، ٱلَّذِينَ عَدَّهُمْ مُوسَى كَمَا أَمَرَهُ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ أَنْ يَنْفُوا مِنَ ٱلْمَحَلَّةِ كُلَّ أَبْرَصَ، وَكُلَّ ذِي سَيْلٍ، وَكُلَّ مُتَنَجِّسٍ لِمَيْتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ٱلذَّكَرَ وَٱلْأُنْثَى تَنْفُونَ. إِلَى خَارِجِ ٱلْمَحَلَّةِ تَنْفُونَهُمْ لِكَيْلَا يُنَجِّسُوا مَحَلَّاتِهِمْ حَيْثُ أَنَا سَاكِنٌ فِي وَسَطِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","فَفَعَلَ هَكَذَا بَنُو إِسْرَائِيلَ وَنَفَوْهُمْ إِلَى خَارِجِ ٱلْمَحَلَّةِ. كَمَا كَلَّمَ ٱلرَّبُّ مُوسَى هَكَذَا فَعَلَ بَنُو إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«قُلْ لِبَنِي إِسْرَائِيلَ: إِذَا عَمِلَ رَجُلٌ أَوِ ٱمْرَأَةٌ شَيْئًا مِنْ جَمِيعِ خَطَايَا ٱلْإِنْسَانِ، وَخَانَ خِيَانَةً بِٱلرَّبِّ، فَقَدْ أَذْنَبَتْ تِلْكَ ٱلنَّفْسُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","فَلْتُقِرَّ بِخَطِيَّتِهَا ٱلَّتِي عَمِلَتْ، وَتَرُدَّ مَا أَذْنَبَتْ بِهِ بِعَيْنِهِ، وَتَزِدْ عَلَيْهِ خُمْسَهُ، وَتَدْفَعْهُ لِلَّذِي أَذْنَبَتْ إِلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","وَإِنْ كَانَ لَيْسَ لِلرَّجُلِ وَلِيٌّ لِيَرُدَّ إِلَيْهِ ٱلْمُذْنَبَ بِهِ، فَٱلْمُذْنَبُ بِهِ ٱلْمَرْدُودُ يَكُونُ لِلرَّبِّ لِأَجْلِ ٱلْكَاهِنِ، فَضْلًا عَنْ كَبْشِ ٱلْكَفَّارَةِ ٱلَّذِي يُكَفِّرُ بِهِ عَنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","وَكُلُّ رَفِيعَةٍ مَعَ كُلِّ أَقْدَاسِ بَنِي إِسْرَائِيلَ ٱلَّتِي يُقَدِّمُونَهَا لِلْكَاهِنِ تَكُونُ لَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","وَٱلْإِنْسَانُ أَقْدَاسُهُ تَكُونُ لَهُ. إِذَا أَعْطَى إِنْسَانٌ شَيْئًا لِلْكَاهِنِ فَلَهُ يَكُونُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: إِذَا زَاغَتِ ٱمْرَأَةُ رَجُلٍ وَخَانَتْهُ خِيَانَةً، ");
INSERT INTO arb_vd_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","وَٱضْطَجَعَ مَعَهَا رَجُلٌ ٱضْطِجَاعَ زَرْعٍ، وَأُخْفِيَ ذَلِكَ عَنْ عَيْنَيْ رَجُلِهَا، وَٱسْتَتَرَتْ وَهِيَ نَجِسَةٌ وَلَيْسَ شَاهِدٌ عَلَيْهَا، وَهِيَ لَمْ تُؤْخَذْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","فَٱعْتَرَاهُ رُوحُ ٱلْغَيْرَةِ وَغَارَ عَلَى ٱمْرَأَتِهِ وَهِيَ نَجِسَةٌ، أَوِ ٱعْتَرَاهُ رُوحُ ٱلْغَيْرَةِ وَغَارَ عَلَى ٱمْرَأَتِهِ وَهِيَ لَيْسَتْ نَجِسَةً، ");
INSERT INTO arb_vd_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","يَأْتِي ٱلرَّجُلُ بِٱمْرَأَتِهِ إِلَى ٱلْكَاهِنِ، وَيَأْتِي بِقُرْبَانِهَا مَعَهَا: عُشْرِ ٱلْإِيفَةِ مِنْ طَحِينِ شَعِيرٍ، لَا يَصُبُّ عَلَيْهِ زَيْتًا وَلَا يَجْعَلُ عَلَيْهِ لُبَانًا، لِأَنَّهُ تَقْدِمَةُ غَيْرَةٍ، تَقْدِمَةُ تَذْكَارٍ تُذَكِّرُ ذَنْبًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","فَيُقَدِّمُهَا ٱلْكَاهِنُ وَيُوقِفُهَا أَمَامَ ٱلرَّبِّ، ");
INSERT INTO arb_vd_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","وَيَأْخُذُ ٱلْكَاهِنُ مَاءً مُقَدَّسًا فِي إِنَاءِ خَزَفٍ، وَيَأْخُذُ ٱلْكَاهِنُ مِنَ ٱلْغُبَارِ ٱلَّذِي فِي أَرْضِ ٱلْمَسْكَنِ وَيَجْعَلُ فِي ٱلْمَاءِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","وَيُوقِفُ ٱلْكَاهِنُ ٱلْمَرْأَةَ أَمَامَ ٱلرَّبِّ، وَيَكْشِفُ رَأْسَ ٱلْمَرْأَةِ، وَيَجْعَلُ فِي يَدَيْهَا تَقْدِمَةَ ٱلتَّذْكَارِ ٱلَّتِي هِيَ تَقْدِمَةُ ٱلْغَيْرَةِ، وَفِي يَدِ ٱلْكَاهِنِ يَكُونُ مَاءُ ٱللَّعْنَةِ ٱلْمُرُّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","وَيَسْتَحْلِفُ ٱلْكَاهِنُ ٱلْمَرْأَةَ وَيَقُولُ لَهَا: إِنْ كَانَ لَمْ يَضْطَجِعْ مَعَكِ رَجُلٌ، وَإِنْ كُنْتِ لَمْ تَزِيغِي إِلَى نَجَاسَةٍ مِنْ تَحْتِ رَجُلِكِ، فَكُونِي بَرِيئَةً مِنْ مَاءِ ٱللَّعْنَةِ هَذَا ٱلْمُرِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","وَلَكِنْ إِنْ كُنْتِ قَدْ زُغْتِ مِنْ تَحْتِ رَجُلِكِ وَتَنَجَّسْتِ، وَجَعَلَ مَعَكِ رَجُلٌ غَيْرُ رَجُلِكِ مَضْجَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","يَسْتَحْلِفُ ٱلْكَاهِنُ ٱلْمَرْأَةَ بِحَلْفِ ٱللَّعْنَةِ، وَيَقُولُ ٱلْكَاهِنُ لِلْمَرْأَةِ: يَجْعَلُكِ ٱلرَّبُّ لَعْنَةً وَحَلْفًا بَيْنَ شَعْبِكِ، بِأَنْ يَجْعَلَ ٱلرَّبُّ فَخْذَكِ سَاقِطَةً وَبَطْنَكِ وَارِمًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","وَيَدْخُلُ مَاءُ ٱللَّعْنَةِ هَذَا فِي أَحْشَائِكِ لِوَرَمِ ٱلْبَطْنِ، وَلِإِسْقَاطِ ٱلْفَخْذِ. فَتَقُولُ ٱلْمَرْأَةُ: آمِينَ، آمِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","وَيَكْتُبُ ٱلْكَاهِنُ هَذِهِ ٱللَّعْنَاتِ فِي ٱلْكِتَابِ ثُمَّ يَمْحُوهَا فِي ٱلْمَاءِ ٱلْمُرِّ، ");
INSERT INTO arb_vd_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","وَيَسْقِي ٱلْمَرْأَةَ مَاءَ ٱللَّعْنَةِ ٱلْمُرَّ، فَيَدْخُلُ فِيهَا مَاءُ ٱللَّعْنَةِ لِلْمَرَارَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","وَيَأْخُذُ ٱلْكَاهِنُ مِنْ يَدِ ٱلْمَرْأَةِ تَقْدِمَةَ ٱلْغَيْرَةِ، وَيُرَدِّدُ ٱلتَّقْدِمَةَ أَمَامَ ٱلرَّبِّ وَيُقَدِّمُهَا إِلَى ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","وَيَقْبِضُ ٱلْكَاهِنُ مِنَ ٱلتَّقْدِمَةِ تَذْكَارَهَا وَيُوقِدُهُ عَلَى ٱلْمَذْبَحِ، وَبَعْدَ ذَلِكَ يَسْقِي ٱلْمَرْأَةَ ٱلْمَاءَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","وَمَتَى سَقَاهَا ٱلْمَاءَ، فَإِنْ كَانَتْ قَدْ تَنَجَّسَتْ وَخَانَتْ رَجُلَهَا، يَدْخُلُ فِيهَا مَاءُ ٱللَّعْنَةِ لِلْمَرَارَةِ، فَيَرِمُ بَطْنُهَا وَتَسْقُطُ فَخْذُهَا، فَتَصِيرُ ٱلْمَرْأَةُ لَعْنَةً فِي وَسَطِ شَعْبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","وَإِنْ لَمْ تَكُنِ ٱلْمَرْأَةُ قَدْ تَنَجَّسَتْ بَلْ كَانَتْ طَاهِرَةً، تَتَبَرَّأُ وَتَحْبَلُ بِزَرْعٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«هَذِهِ شَرِيعَةُ ٱلْغَيْرَةِ، إِذَا زَاغَتِ ٱمْرَأَةٌ مِنْ تَحْتِ رَجُلِهَا وَتَنَجَّسَتْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","أَوْ إِذَا ٱعْتَرَى رَجُلًا رُوحُ غَيْرَةٍ فَغَارَ عَلَى ٱمْرَأَتِهِ، يُوقِفُ ٱلْمَرْأَةَ أَمَامَ ٱلرَّبِّ، وَيَعْمَلُ لَهَا ٱلْكَاهِنُ كُلَّ هَذِهِ ٱلشَّرِيعَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","فَيَتَبَرَّأُ ٱلرَّجُلُ مِنَ ٱلذَّنْبِ، وَتِلْكَ ٱلْمَرْأَةُ تَحْمِلُ ذَنْبَهَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: إِذَا ٱنْفَرَزَ رَجُلٌ أَوِ ٱمْرَأَةٌ لِيَنْذُرَ نَذْرَ ٱلنَّذِيرِ، لِيَنْتَذِرَ لِلرَّبِّ، ");
INSERT INTO arb_vd_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","فَعَنِ ٱلْخَمْرِ وَٱلْمُسْكِرِ يَفْتَرِزُ، وَلَا يَشْرَبْ خَلَّ ٱلْخَمْرِ وَلَا خَلَّ ٱلْمُسْكِرِ، وَلَا يَشْرَبْ مِنْ نَقِيعِ ٱلْعِنَبِ، وَلَا يَأْكُلْ عِنَبًا رَطْبًا وَلَا يَابِسًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","كُلَّ أَيَّامِ نَذْرِهِ لَا يَأْكُلْ مِنْ كُلِّ مَا يُعْمَلُ مِنْ جَفْنَةِ ٱلْخَمْرِ مِنَ ٱلْعَجَمِ حَتَّى ٱلْقِشْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","كُلَّ أَيَّامِ نَذْرِ ٱفْتِرَازِهِ لَا يَمُرُّ مُوسَى عَلَى رَأْسِهِ. إِلَى كَمَالِ ٱلْأَيَّامِ ٱلَّتِي ٱنْتَذَرَ فِيهَا لِلرَّبِّ يَكُونُ مُقَدَّسًا، وَيُرَبِّي خُصَلَ شَعْرِ رَأْسِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","كُلَّ أَيَّامِ ٱنْتِذَارِهِ لِلرَّبِّ لَا يَأْتِي إِلَى جَسَدِ مَيْتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","أَبُوهُ وَأُمُّهُ وَأَخُوهُ وَأُخْتُهُ لَا يَتَنَجَّسْ مِنْ أَجْلِهِمْ عِنْدَ مَوْتِهِمْ، لِأَنَّ ٱنْتِذَارَ إِلَهِهِ عَلَى رَأْسِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","إِنَّهُ كُلَّ أَيَّامِ ٱنْتِذَارِهِ مُقَدَّسٌ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","وَإِذَا مَاتَ مَيْتٌ عِنْدَهُ بَغْتَةً عَلَى فَجْأَةٍ فَنَجَّسَ رَأْسَ ٱنْتِذَارِهِ، يَحْلِقُ رَأْسَهُ يَوْمَ طُهْرِهِ. فِي ٱلْيَوْمِ ٱلسَّابِعِ يَحْلِقُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","وَفِي ٱلْيَوْمِ ٱلثَّامِنِ يَأْتِي بِيَمَامَتَيْنِ أَوْ بِفَرْخَيْ حَمَامٍ إِلَى ٱلْكَاهِنِ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","فَيَعْمَلُ ٱلْكَاهِنُ وَاحِدًا ذَبِيحَةَ خَطِيَّةٍ، وَٱلْآخَرَ مُحْرَقَةً وَيُكَفِّرُ عَنْهُ مَا أَخْطَأَ بِسَبَبِ ٱلْمَيْتِ، وَيُقَدِّسُ رَأْسَهُ فِي ذَلِكَ ٱلْيَوْمِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","فَمَتَى نَذَرَ لِلرَّبِّ أَيَّامَ ٱنْتِذَارِهِ يَأْتِي بِخَرُوفٍ حَوْلِيٍّ ذَبِيحَةَ إِثْمٍ، وَأَمَّا ٱلْأَيَّامُ ٱلْأُولَى فَتَسْقُطُ لِأَنَّهُ نَجَّسَ ٱنْتِذَارَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«وَهَذِهِ شَرِيعَةُ ٱلنَّذِيرِ: يَوْمَ تَكْمُلُ أَيَّامُ ٱنْتِذَارِهِ يُؤْتَى بِهِ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","فَيُقَرِّبُ قُرْبَانَهُ لِلرَّبِّ خَرُوفًا وَاحِدًا حَوْلِيًّا صَحِيحًا مُحْرَقَةً، وَنَعْجَةً وَاحِدَةً حَوْلِيَّةً صَحِيحَةً ذَبِيحَةَ خَطِيَّةٍ، وَكَبْشًا وَاحِدًا صَحِيحًا ذَبِيحَةَ سَلَامَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","وَسَلَّ فَطِيرٍ مِنْ دَقِيقٍ أَقْرَاصًا مَلْتُوتَةً بِزَيْتٍ، وَرِقَاقَ فَطِيرٍ مَدْهُونَةً بِزَيْتٍ مَعَ تَقْدِمَتِهَا وَسَكَائِبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","فَيُقَدِّمُهَا ٱلْكَاهِنُ أَمَامَ ٱلرَّبِّ وَيَعْمَلُ ذَبِيحَةَ خَطِيَّتِهِ وَمُحْرَقَتَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","وَٱلْكَبْشُ يَعْمَلُهُ ذَبِيحَةَ سَلَامَةٍ لِلرَّبِّ مَعَ سَلِّ ٱلْفَطِيرِ، وَيَعْمَلُ ٱلْكَاهِنُ تَقْدِمَتَهُ وَسَكِيبَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","وَيَحْلِقُ ٱلنَّذِيرُ لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ رَأْسَ ٱنْتِذَارِهِ، وَيَأْخُذُ شَعْرَ رَأْسِ ٱنْتِذَارِهِ وَيَجْعَلُهُ عَلَى ٱلنَّارِ ٱلَّتِي تَحْتَ ذَبِيحَةِ ٱلسَّلَامَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","وَيَأْخُذُ ٱلْكَاهِنُ ٱلسَّاعِدَ مَسْلُوقًا مِنَ ٱلْكَبْشِ، وَقُرْصَ فَطِيرٍ وَاحِدًا مِنَ ٱلسَّلِّ، وَرُقَاقَةَ فَطِيرٍ وَاحِدَةً، وَيَجْعَلُهَا فِي يَدَيِ ٱلنَّذِيرِ بَعْدَ حَلْقِهِ شَعْرَ ٱنْتِذَارِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","وَيُرَدِّدُهَا ٱلْكَاهِنُ تَرْدِيدًا أَمَامَ ٱلرَّبِّ. إِنَّهُ قُدْسٌ لِلْكَاهِنِ مَعَ صَدْرِ ٱلتَّرْدِيدِ وَسَاقِ ٱلرَّفِيعَةِ. وَبَعْدَ ذَلِكَ يَشْرَبُ ٱلنَّذِيرُ خَمْرًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","هَذِهِ شَرِيعَةُ ٱلنَّذِيرِ ٱلَّذِي يَنْذُرُ، قُرْبَانُهُ لِلرَّبِّ عَنِ ٱنْتِذَارِهِ فَضْلًا عَمَّا تَنَالُ يَدُهُ. حَسَبَ نَذْرِهِ ٱلَّذِي نَذَرَ كَذَلِكَ يَعْمَلُ حَسَبَ شَرِيعَةِ ٱنْتِذَارِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«كَلِّمْ هَارُونَ وَبَنِيهِ قَائِلًا: هَكَذَا تُبَارِكُونَ بَنِي إِسْرَائِيلَ قَائِلِينَ لَهُمْ: ");
INSERT INTO arb_vd_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","يُبَارِكُكَ ٱلرَّبُّ وَيَحْرُسُكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","يُضِيءُ ٱلرَّبُّ بِوَجْهِهِ عَلَيْكَ وَيَرْحَمُكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","يَرْفَعُ ٱلرَّبُّ وَجْهَهُ عَلَيْكَ وَيَمْنَحُكَ سَلَامًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","فَيَجْعَلُونَ ٱسْمِي عَلَى بَنِي إِسْرَائِيلَ، وَأَنَا أُبَارِكُهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","وَيَوْمَ فَرَغَ مُوسَى مِنْ إِقَامَةِ ٱلْمَسْكَنِ، وَمَسَحَهُ وَقَدَّسَهُ وَجَمِيعَ أَمْتِعَتِهِ، وَٱلْمَذْبَحَ وَجَمِيعَ أَمْتِعَتِهِ وَمَسَحَهَا وَقَدَّسَهَا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","قَرَّبَ رُؤَسَاءُ إِسْرَائِيلَ، رُؤُوسُ بُيُوتِ آبَائِهِمْ، هُمْ رُؤَسَاءُ ٱلْأَسْبَاطِ ٱلَّذِينَ وَقَفُوا عَلَى ٱلْمَعْدُودِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","أَتَوْا بِقَرَابِينِهِمْ أَمَامَ ٱلرَّبِّ: سِتَّ عَجَلَاتٍ مُغَطَّاةً، وَٱثْنَيْ عَشَرَ ثَوْرًا. لِكُلِّ رَئِيسَيْنِ عَجَلَةٌ، وَلِكُلِّ وَاحِدٍ ثَوْرٌ، وَقَدَّمُوهَا أَمَامَ ٱلْمَسْكَنِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","فَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«خُذْهَا مِنْهُمْ فَتَكُونَ لِعَمَلِ خِدْمَةِ خَيْمَةِ ٱلِٱجْتِمَاعِ، وَأَعْطِهَا لِلَّاوِيِّينَ، لِكُلِّ وَاحِدٍ حَسَبَ خِدْمَتِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","فَأَخَذَ مُوسَى ٱلْعَجَلَاتِ وَٱلثِّيرَانَ وَأَعْطَاهَا لِلَّاوِيِّينَ: ");
INSERT INTO arb_vd_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ٱثْنَتَانِ مِنَ ٱلْعَجَلَاتِ وَأَرْبَعَةٌ مِنَ ٱلثِّيرَانِ أَعْطَاهَا لِبَنِي جَرْشُونَ حَسَبَ خِدْمَتِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","وَأَرْبَعٌ مِنَ ٱلْعَجَلَاتِ وَثَمَانِيَةٌ مِنَ ٱلثِّيرَانِ أَعْطَاهَا لِبَنِي مَرَارِي حَسَبَ خِدْمَتِهِمْ بِيَدِ إِيثَامَارَ بْنِ هَارُونَ ٱلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","وَأَمَّا بَنُو قَهَاتَ فَلَمْ يُعْطِهِمْ، لِأَنَّ خِدْمَةَ ٱلْقُدْسِ كَانَتْ عَلَيْهِمْ، عَلَى ٱلْأَكْتَافِ كَانُوا يَحْمِلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","وَقَرَّبَ ٱلرُّؤَسَاءُ لِتَدْشِينِ ٱلْمَذْبَحِ يَوْمَ مَسْحِهِ. وَقَدَّمَ ٱلرُّؤَسَاءُ قَرَابِينَهُمْ أَمَامَ ٱلْمَذْبَحِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","فَقَالَ ٱلرَّبُّ لِمُوسَى: «رَئِيسًا رَئِيسًا فِي كُلِّ يَوْمٍ يُقَرِّبُونَ قَرَابِينَهُمْ لِتَدْشِينِ ٱلْمَذْبَحِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","وَٱلَّذِي قَرَّبَ قُرْبَانَهُ فِي ٱلْيَوْمِ ٱلْأَوَّلِ نَحْشُونُ بْنُ عَمِّينَادَابَ، مِنْ سِبْطِ يَهُوذَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","وَقُرْبَانُهُ طَبَقٌ وَاحِدٌ مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا، وَمِنْضَحَةٌ وَاحِدَةٌ مِنْ فِضَّةٍ سَبْعُونَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","وَصَحْنٌ وَاحِدٌ عَشَرَةُ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوءٌ بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","وَثَوْرٌ وَاحِدٌ ٱبْنُ بَقَرٍ وَكَبْشٌ وَاحِدٌ وَخَرُوفٌ وَاحِدٌ حَوْلِيٌّ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","وَتَيْسٌ وَاحِدٌ مِنَ ٱلْمَعَزِ لِذَبِيحَةِ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةُ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ نَحْشُونَ بْنِ عَمِّينَادَابَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","وَفِي ٱلْيَوْمِ ٱلثَّانِي قَرَّبَ نَثَنَائِيلُ بْنُ صُوغَرَ رَئِيسُ يَسَّاكَرَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","قَرَّبَ قُرْبَانَهُ طَبَقًا وَاحِدًا مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا، وَمِنْضَحَةً وَاحِدَةً مِنْ فِضَّةٍ سَبْعِينَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","وَصَحْنًا وَاحِدًا عَشَرَةَ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوًّا بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","وَثَوْرًا وَاحِدًا ٱبْنَ بَقَرٍ وَكَبْشًا وَاحِدًا وَخَرُوفًا وَاحِدًا حَوْلِيًّا لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","وَتَيْسًا وَاحِدًا مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةَ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ نَثَنَائِيلَ بْنِ صُوغَرَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","وَفِي ٱلْيَوْمِ ٱلثَّالِثِ رَئِيسُ بَنِي زَبُولُونَ أَلِيآبُ بْنُ حِيلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","قُرْبَانُهُ طَبَقٌ وَاحِدٌ مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا وَمِنْضَحَةٌ وَاحِدَةٌ مِنْ فِضَّةٍ سَبْعُونَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","وَصَحْنٌ وَاحِدٌ عَشَرَةُ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوءٌ بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","وَثَوْرٌ وَاحِدٌ ٱبْنُ بَقَرٍ وَكَبْشٌ وَاحِدٌ وَخَرُوفٌ وَاحِدٌ حَوْلِيٌّ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","وَتَيْسٌ وَاحِدٌ مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةُ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ أَلِيآبَ بْنِ حِيلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","وَفِي ٱلْيَوْمِ ٱلرَّابِعِ رَئِيسُ بَنِي رَأُوبَيْنَ أَلِيصُورُ بْنُ شَدَيْئُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","قُرْبَانُهُ طَبَقٌ وَاحِدٌ مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا، وَمِنْضَحَةٌ وَاحِدَةٌ مِنْ فِضَّةٍ سَبْعُونَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","وَصَحْنٌ وَاحِدٌ عَشَرَةُ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوءٌ بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","وَثَوْرٌ وَاحِدٌ ٱبْنُ بَقَرٍ وَكَبْشٌ وَاحِدٌ وَخَرُوفٌ وَاحِدٌ حَوْلِيٌّ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","وَتَيْسٌ وَاحِدٌ مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةُ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ أَلِيصُورَ بْنِ شَدَيْئُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","وَفِي ٱلْيَوْمِ ٱلْخَامِسِ رَئِيسُ بَنِي شِمْعُونَ شَلُومِيئِيلُ بْنُ صُورِيشَدَّاي. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","قُرْبَانُهُ طَبَقٌ وَاحِدٌ مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا، وَمِنْضَحَةٌ وَاحِدَةٌ مِنْ فِضَّةٍ سَبْعُونَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","وَصَحْنٌ وَاحِدٌ عَشَرَةُ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوءٌ بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","وَثَوْرٌ وَاحِدٌ ٱبْنُ بَقَرٍ وَكَبْشٌ وَاحِدٌ وَخَرُوفٌ وَاحِدٌ حَوْلِيٌّ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","وَتَيْسٌ وَاحِدٌ مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةُ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ شَلُومِيئِيلَ بْنِ صُورِيشَدَّاي. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","وَفِي ٱلْيَوْمِ ٱلسَّادِسِ رَئِيسُ بَنِي جَادَ أَلِيَاسَافُ بْنُ دَعُوئِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","قُرْبَانُهُ طَبَقٌ وَاحِدٌ مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا، وَمِنْضَحَةٌ وَاحِدَةٌ مِنْ فِضَّةٍ سَبْعُونَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","وَصَحْنٌ وَاحِدٌ عَشَرَةُ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوءٌ بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","وَثَوْرٌ وَاحِدٌ ٱبْنُ بَقَرٍ وَكَبْشٌ وَاحِدٌ وَخَرُوفٌ وَاحِدٌ حَوْلِيٌّ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","وَتَيْسٌ وَاحِدٌ مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةُ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ أَلِيَاسَافَ بْنِ دَعُوئِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","وَفِي ٱلْيَوْمِ ٱلسَّابِعِ رَئِيسُ بَنِي أَفْرَايِمَ أَلِيشَمَعُ بْنُ عَمِّيهُودَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","قُرْبَانُهُ طَبَقٌ وَاحِدٌ مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا، وَمِنْضَحَةٌ وَاحِدَةٌ مِنْ فِضَّةٍ سَبْعُونَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","وَصَحْنٌ وَاحِدٌ عَشَرَةُ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوءٌ بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","وَثَوْرٌ وَاحِدٌ ٱبْنُ بَقَرٍ وَكَبْشٌ وَاحِدٌ وَخَرُوفٌ وَاحِدٌ حَوْلِيٌّ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","وَتَيْسٌ وَاحِدٌ مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةُ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ أَلِيشَمَعَ بْنِ عَمِّيهُودَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","وَفِي ٱلْيَوْمِ ٱلثَّامِنِ رَئِيسُ بَنِي مَنَسَّى جَمْلِيئِيلُ بْنُ فَدَهْصُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","قُرْبَانُهُ طَبَقٌ وَاحِدٌ مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا، وَمِنْضَحَةٌ وَاحِدَةٌ مِنْ فِضَّةٍ سَبْعُونَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","وَصَحْنٌ وَاحِدٌ عَشَرَةُ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوءٌ بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","وَثَوْرٌ وَاحِدٌ ٱبْنُ بَقَرٍ وَكَبْشٌ وَاحِدٌ وَخَرُوفٌ وَاحِدٌ حَوْلِيٌّ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","وَتَيْسٌ وَاحِدٌ مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةُ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ جَمْلِيئِيلَ بْنِ فَدَهْصُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","وَفِي ٱلْيَوْمِ ٱلتَّاسِعِ رَئِيسُ بَنِي بَنْيَامِينَ أَبِيدَنُ بْنُ جِدْعُونِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","قُرْبَانُهُ طَبَقٌ وَاحِدٌ مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا، وَمِنْضَحَةٌ وَاحِدَةٌ مِنْ فِضَّةٍ سَبْعُونَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","وَصَحْنٌ وَاحِدٌ عَشَرَةُ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوءٌ بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","وَثَوْرٌ وَاحِدٌ ٱبْنُ بَقَرٍ وَكَبْشٌ وَاحِدٌ وَخَرُوفٌ وَاحِدٌ حَوْلِيٌّ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","وَتَيْسٌ وَاحِدٌ مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةُ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ أَبِيدَنَ بْنِ جِدْعُونِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","وَفِي ٱلْيَوْمِ ٱلْعَاشِرِ رَئِيسُ بَنِي دَانَ أَخِيعَزَرُ بْنُ عَمِّيشَدَّاي. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","قُرْبَانُهُ طَبَقٌ وَاحِدٌ مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا، وَمِنْضَحَةٌ وَاحِدَةٌ مِنْ فِضَّةٍ سَبْعُونَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","وَصَحْنٌ وَاحِدٌ عَشَرَةُ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوءٌ بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","وَثَوْرٌ وَاحِدٌ ٱبْنُ بَقَرٍ وَكَبْشٌ وَاحِدٌ وَخَرُوفٌ وَاحِدٌ حَوْلِيٌّ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","وَتَيْسٌ وَاحِدٌ مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةُ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ أَخِيعَزَرَ بْنِ عَمِّيشَدَّاي. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","وَفِي ٱلْيَوْمِ ٱلحَادِي عَشَرَ رَئِيسُ بَنِي أَشِيرَ فَجْعِيئِيلُ بْنُ عُكْرَنَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","قُرْبَانُهُ طَبَقٌ وَاحِدٌ مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا، وَمِنْضَحَةٌ وَاحِدَةٌ مِنْ فِضَّةٍ سَبْعُونَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","وَصَحْنٌ وَاحِدٌ عَشَرَةُ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوءٌ بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","وَثَوْرٌ وَاحِدٌ ٱبْنُ بَقَرٍ وَكَبْشٌ وَاحِدٌ وَخَرُوفٌ وَاحِدٌ حَوْلِيٌّ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","وَتَيْسٌ وَاحِدٌ مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةُ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ فَجْعِيئِيلَ بْنِ عُكْرَنَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","وَفِي ٱلْيَوْمِ الثَّانِي عَشَرَ رَئِيسُ بَنِي نَفْتَالِي أَخِيرَعُ بْنُ عِينَنَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","قُرْبَانُهُ طَبَقٌ وَاحِدٌ مِنْ فِضَّةٍ وَزْنُهُ مِئَةٌ وَثَلَاثُونَ شَاقِلًا، وَمِنْضَحَةٌ وَاحِدَةٌ مِنْ فِضَّةٍ سَبْعُونَ شَاقِلًا عَلَى شَاقِلِ ٱلْقُدْسِ، كِلْتَاهُمَا مَمْلُوءَتَانِ دَقِيقًا مَلْتُوتًا بِزَيْتٍ لِتَقْدِمَةٍ ");
INSERT INTO arb_vd_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","وَصَحْنٌ وَاحِدٌ عَشَرَةُ شَوَاقِلَ مِنْ ذَهَبٍ مَمْلُوءٌ بَخُورًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","وَثَوْرٌ وَاحِدٌ ٱبْنُ بَقَرٍ وَكَبْشٌ وَاحِدٌ وَخَرُوفٌ وَاحِدٌ حَوْلِيٌّ لِمُحْرَقَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","وَتَيْسٌ وَاحِدٌ مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","وَلِذَبِيحَةِ ٱلسَّلَامَةِ ثَوْرَانِ وَخَمْسَةُ كِبَاشٍ وَخَمْسَةُ تُيُوسٍ وَخَمْسَةُ خِرَافٍ حَوْلِيَّةٍ. هَذَا قُرْبَانُ أَخِيرَعَ بْنِ عِينَنَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","هَذَا تَدْشِينُ ٱلْمَذْبَحِ يَوْمَ مَسْحِهِ مِنْ رُؤَسَاءِ إِسْرَائِيلَ. أَطْبَاقُ فِضَّةٍ ٱثْنَا عَشَرَ، وَمَنَاضِحُ فِضَّةٍ ٱثْنَتَا عَشرَةَ، وَصُحُونُ ذَهَبٍ ٱثْنَا عَشَرَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","كُلُّ طَبَقٍ مِئَةٌ وَثَلَاثُونَ شَاقِلَ فِضَّةٍ، وَكُلُّ مِنْضَحَةٍ سَبْعُونَ. جَمِيعُ فِضَّةِ ٱلْآنِيَةِ أَلْفَانِ وَأَرْبَعُ مِئَةٍ عَلَى شَاقِلِ ٱلْقُدْسِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","وَصُحُونُ ٱلذَّهَبِ ٱثْنَا عَشَرَ مَمْلُوءَةٌ بَخُورًا، كُلُّ صَحْنٍ عَشَرَةٌ عَلَى شَاقِلِ ٱلْقُدْسِ. جَمِيعُ ذَهَبِ ٱلصُّحُونِ مِئَةٌ وَعِشْرُونَ شَاقِلًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","كُلُّ ٱلثِّيرَانِ لِلْمُحْرَقَةِ ٱثْنَا عَشَرَ ثَوْرًا، وَٱلْكِبَاشُ ٱثْنَا عَشَرَ، وَٱلْخِرَافُ ٱلْحَوْلِيَّةُ ٱثْنَا عَشَرَ مَعَ تَقْدِمَتِهَا، وَتُيُوسُ ٱلْمَعْزِ ٱثْنَا عَشَرَ لِذَبِيحَةِ ٱلْخَطِيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","وَكُلُّ ٱلثِّيرَانِ لِذَبِيحَةِ ٱلسَّلَامَةِ أَرْبَعَةٌ وَعِشْرُونَ ثَوْرًا، وَٱلْكِبَاشُ سِتُّونَ، وَٱلتُّيُوسُ سِتُّونَ، وَٱلْخِرَافُ ٱلْحَوْلِيَّةُ سِتُّونَ. هَذَا تَدْشِينُ ٱلْمَذْبَحِ بَعْدَ مَسْحِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","فَلَمَّا دَخَلَ مُوسَى إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ لِيَتَكَلَّمَ مَعَهُ، كَانَ يَسْمَعُ ٱلصَّوْتَ يُكَلِّمُهُ مِنْ عَلَى ٱلْغِطَاءِ ٱلَّذِي عَلَى تَابُوتِ ٱلشَّهَادَةِ مِنْ بَيْنِ ٱلْكَرُوبَيْنِ، فَكَلَّمَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«كَلِّمْ هَارُونَ وَقُلْ لَهُ: مَتَى رَفَعْتَ ٱلسُّرُجَ فَإِلَى قُدَّامِ ٱلْمَنَارَةِ تُضِيءُ ٱلسُّرُجُ ٱلسَّبْعَةُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","فَفَعَلَ هَارُونُ هَكَذَا. إِلَى قُدَّامِ ٱلْمَنَارَةِ رَفَعَ سُرُجَهَا كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","وَهَذِهِ هِيَ صَنْعَةُ ٱلْمَنَارَةِ: مَسْحُولَةٌ مِنْ ذَهَبٍ. حَتَّى سَاقُهَا وَزَهْرُهَا هِيَ مَسْحُولَةٌ. حَسَبَ ٱلْمَنْظَرِ ٱلَّذِي أَرَاهُ ٱلرَّبُّ مُوسَى هَكَذَا عَمِلَ ٱلْمَنَارَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«خُذِ ٱللَّاوِيِّينَ مِنْ بَيْنِ بَنِي إِسْرَائِيلَ وَطَهِّرْهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","وَهَكَذَا تَفْعَلُ لَهُمْ لِتَطْهِيرِهِمِ: ٱنْضِحْ عَلَيْهِمْ مَاءَ ٱلْخَطِيَّةِ، وَلْيُمِرُّوا مُوسَى عَلَى كُلِّ بَشَرِهِمْ، وَيَغْسِلُوا ثِيَابَهُمْ فَيَتَطَهَّرُوا. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ثُمَّ يَأْخُذُوا ثَوْرًا ٱبْنَ بَقَرٍ وَتَقْدِمَتَهُ دَقِيقًا مَلْتُوتًا بِزَيْتٍ. وَثَوْرًا آخَرَ ٱبْنَ بَقَرٍ تَأْخُذُ لِذَبِيحَةِ خَطِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","فَتُقَدِّمُ ٱللَّاوِيِّينَ أَمَامَ خَيْمَةِ ٱلِٱجْتِمَاعِ، وَتَجْمَعُ كُلَّ جَمَاعَةِ بَنِي إِسْرَائِيلَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","وَتُقَدِّمُ ٱللَّاوِيِّينَ أَمَامَ ٱلرَّبِّ، فَيَضَعُ بَنُو إِسْرَائِيلَ أَيْدِيَهُمْ عَلَى ٱللَّاوِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","وَيُرَدِّدُ هَارُونُ ٱللَّاوِيِّينَ تَرْدِيدًا أَمَامَ ٱلرَّبِّ مِنْ عِنْدِ بَنِي إِسْرَائِيلَ فَيَكُونُونَ لِيَخْدِمُوا خِدْمَةَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ثُمَّ يَضَعُ ٱللَّاوِيُّونَ أَيْدِيَهُمْ عَلَى رَأْسَيِ ٱلثَّوْرَيْنِ، فَتُقَرِّبُ ٱلْوَاحِدَ ذَبِيحَةَ خَطِيَّةٍ، وَٱلْآخَرَ مُحْرَقَةً لِلرَّبِّ، لِلتَّكْفِيرِ عَنِ ٱللَّاوِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","فَتُوقِفُ ٱللَّاوِيِّينَ أَمَامَ هَارُونَ وَبَنِيهِ وَتُرَدِّدُهُمْ تَرْدِيدًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","وَتُفْرِزُ ٱللَّاوِيِّينَ مِنْ بَيْنِ بَنِي إِسْرَائِيلَ فَيَكُونُ ٱللَّاوِيُّونَ لِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","وَبَعْدَ ذَلِكَ يَأْتِي ٱللَّاوِيُّونَ لِيَخْدِمُوا خَيْمَةَ ٱلِٱجْتِمَاعِ فَتُطَهِّرُهُمْ وَتُرَدِّدُهُمْ تَرْدِيدًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","لِأَنَّهُمْ مَوْهُوبُونَ لِي هِبَةً مِنْ بَيْنِ بَنِي إِسْرَائِيلَ. بَدَلَ كُلِّ فَاتِحِ رَحِمٍ، بِكْرِ كُلٍّ مِنْ بَنِي إِسْرَائِيلَ قَدِ ٱتَّخَذْتُهُمْ لِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","لِأَنَّ لِي كُلَّ بِكْرٍ فِي بَنِي إِسْرَائِيلَ مِنَ ٱلنَّاسِ وَمِنَ ٱلْبَهَائِمِ. يَوْمَ ضَرَبْتُ كُلَّ بِكْرٍ فِي أَرْضِ مِصْرَ قَدَّسْتُهُمْ لِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","فَٱتَّخَذْتُ ٱللَّاوِيِّينَ بَدَلَ كُلِّ بِكْرٍ فِي بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","وَوَهَبْتُ ٱللَّاوِيِّينَ هِبَةً لِهَارُونَ وَبَنِيهِ مِنْ بَيْنِ بَنِي إِسْرَائِيلَ، لِيَخْدِمُوا خِدْمَةَ بَنِي إِسْرَائِيلَ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ، وَلِلتَّكْفِيرِ عَنْ بَنِي إِسْرَائِيلَ، لِكَيْ لَا يَكُونَ فِي بَنِي إِسْرَائِيلَ وَبَأٌ عِنْدَ ٱقْتِرَابِ بَنِي إِسْرَائِيلَ إِلَى ٱلْقُدْسِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","فَفَعَلَ مُوسَى وَهَارُونُ وَكُلُّ جَمَاعَةِ بَنِي إِسْرَائِيلَ لِلَّاوِيِّينَ حَسَبَ كُلِّ مَا أَمَرَ ٱلرَّبُّ مُوسَى عَنِ ٱللَّاوِيِّينَ. هَكَذَا فَعَلَ لَهُمْ بَنُو إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","فَتَطَهَّرَ ٱللَّاوِيُّونَ وَغَسَّلُوا ثِيَابَهُمْ، وَرَدَّدَهُمْ هَارُونُ تَرْدِيدًا أَمَامَ ٱلرَّبِّ، وَكَفَّرَ عَنْهُمْ هَارُونُ لِتَطْهِيرِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","وَبَعْدَ ذَلِكَ أَتَى ٱللَّاوِيُّونَ لِيَخْدِمُوا خِدْمَتَهُمْ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ أَمَامَ هَارُونَ وَأَمَامَ بَنِيهِ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى عَنِ ٱللَّاوِيِّينَ هَكَذَا فَعَلُوا لَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«هَذَا مَا لِلَّاوِيِّينَ: مِنِ ٱبْنِ خَمْسٍ وَعِشْرِينَ سَنَةً فَصَاعِدًا يَأْتُونَ لِيَتَجَنَّدُوا أَجْنَادًا فِي خِدْمَةِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","وَمِنِ ٱبْنِ خَمْسِينَ سَنَةً يَرْجِعُونَ مِنْ جُنْدِ ٱلْخِدْمَةِ وَلَا يَخْدِمُونَ بَعْدُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","يُوازِرُونَ إِخْوَتَهُمْ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ لِحَرَسِ حِرَاسَةٍ، لَكِنْ خِدْمَةً لَا يَخْدِمُونَ. هَكَذَا تَعْمَلُ لِلَّاوِيِّينَ فِي حِرَاسَاتِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى فِي بَرِّيَّةِ سِينَاءَ، فِي ٱلسَّنَةِ ٱلثَّانِيَةِ لِخُرُوجِهِمْ مِنْ أَرْضِ مِصْرَ فِي ٱلشَّهْرِ ٱلْأَوَّلِ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«وَلْيَعْمَلْ بَنُو إِسْرَائِيلَ ٱلْفِصْحَ فِي وَقْتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","فِي ٱلْيَوْمِ ٱلرَّابِعَ عَشَرَ مِنْ هَذَا ٱلشَّهْرِ بَيْنَ ٱلْعَشَاءَيْنِ تَعْمَلُونَهُ فِي وَقْتِهِ. حَسَبَ كُلِّ فَرَائِضِهِ وَكُلِّ أَحْكَامِهِ تَعْمَلُونَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","فَكَلَّمَ مُوسَى بَنِي إِسْرَائِيلَ أَنْ يَعْمَلُوا ٱلْفِصْحَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","فَعَمِلُوا ٱلْفِصْحَ فِي ٱلشَّهْرِ ٱلْأَوَّلِ فِي ٱلْيَوْمِ ٱلرَّابِعَ عَشَرَ مِنَ ٱلشَّهْرِ بَيْنَ ٱلْعَشَاءَيْنِ فِي بَرِّيَّةِ سِينَاءَ، حَسَبَ كُلِّ مَا أَمَرَ ٱلرَّبُّ مُوسَى هَكَذَا فَعَلَ بَنُو إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","لَكِنْ كَانَ قَوْمٌ قَدْ تَنَجَّسُوا لِإِنْسَانٍ مَيْتٍ، فَلَمْ يَحِلَّ لَهُمْ أَنْ يَعْمَلُوا ٱلْفِصْحَ فِي ذَلِكَ ٱلْيَوْمِ. فَتَقَدَّمُوا أَمَامَ مُوسَى وَهَارُونَ فِي ذَلِكَ ٱلْيَوْمِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","وَقَالَ لَهُ أُولَئِكَ ٱلنَّاسُ: «إِنَّنَا مُتَنَجِّسُونَ لِإِنْسَانٍ مَيِّتٍ. لِمَاذَا نُتْرَكُ حَتَّى لَا نُقَرِّبَ قُرْبَانَ ٱلرَّبِّ فِي وَقْتِهِ بَيْنَ بَنِي إِسْرَائِيلَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","فَقَالَ لَهُمْ مُوسَى: «قِفُوا لِأَسْمَعَ مَا يَأْمُرُ بِهِ ٱلرَّبُّ مِنْ جِهَتِكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","فَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«كَلِّمْ بَنِي إِسْرَائِيلَ قَائِلًا: كُلُّ إِنْسَانٍ مِنْكُمْ أَوْ مِنْ أَجْيَالِكُمْ كَانَ نَجِسًا لِمَيْتٍ، أَوْ فِي سَفَرٍ بَعِيدٍ، فَلْيَعْمَلِ ٱلْفِصْحَ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","فِي ٱلشَّهْرِ ٱلثَّانِي، فِي ٱلْيَوْمِ ٱلرَّابِعَ عَشَرَ بَيْنَ ٱلْعَشَاءَيْنِ يَعْمَلُونَهُ. عَلَى فَطِيرٍ وَمُرَارٍ يَأْكُلُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","لَا يُبْقُوا مِنْهُ إِلَى ٱلصَّبَاحِ وَلَا يَكْسِرُوا عَظْمًا مِنْهُ. حَسَبَ كُلِّ فَرَائِضِ ٱلْفِصْحِ يَعْمَلُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","لَكِنْ مَنْ كَانَ طَاهِرًا وَلَيْسَ فِي سَفَرٍ، وَتَرَكَ عَمَلَ ٱلْفِصْحِ، تُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ شَعْبِهَا، لِأَنَّهَا لَمْ تُقَرِّبْ قُرْبَانَ ٱلرَّبِّ فِي وَقْتِهِ. ذَلِكَ ٱلْإِنْسَانُ يَحْمِلُ خَطِيَّتَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","وَإِذَا نَزَلَ عِنْدَكُمْ غَرِيبٌ فَلْيَعْمَلْ فِصْحًا لِلرَّبِّ. حَسَبَ فَرِيضَةِ ٱلْفِصْحِ وَحُكْمِهِ كَذَلِكَ يَعْمَلُ. فَرِيضَةٌ وَاحِدَةٌ تَكُونُ لَكُمْ لِلْغَرِيبِ وَلِوَطَنِيِّ ٱلْأَرْضِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","وَفِي يَوْمِ إِقَامَةِ ٱلْمَسْكَنِ، غَطَّتِ ٱلسَّحَابَةُ ٱلْمَسْكَنَ، خَيْمَةَ ٱلشَّهَادَةِ. وَفِي ٱلْمَسَاءِ كَانَ عَلَى ٱلْمَسْكَنِ كَمَنْظَرِ نَارٍ إِلَى ٱلصَّبَاحِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","هَكَذَا كَانَ دَائِمًا. ٱلسَّحَابَةُ تُغَطِّيهِ وَمَنْظَرُ ٱلنَّارِ لَيْلًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","وَمَتَى ٱرْتَفَعَتِ ٱلسَّحَابَةُ عَنِ ٱلْخَيْمَةِ كَانَ بَعْدَ ذَلِكَ بَنُو إِسْرَائِيلَ يَرْتَحِلُونَ، وَفِي ٱلْمَكَانِ حَيْثُ حَلَّتِ ٱلسَّحَابَةُ هُنَاكَ كَانَ بَنُو إِسْرَائِيلَ يَنْزِلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","حَسَبَ قَوْلِ ٱلرَّبِّ كَانَ بَنُو إِسْرَائِيلَ يَرْتَحِلُونَ، وَحَسَبَ قَوْلِ ٱلرَّبِّ كَانُوا يَنْزِلُونَ. جَمِيعَ أَيَّامِ حُلُولِ ٱلسَّحَابَةِ عَلَى ٱلْمَسْكَنِ كَانُوا يَنْزِلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","وَإِذَا تَمَادَتِ ٱلسَّحَابَةُ عَلَى ٱلْمَسْكَنِ أَيَّامًا كَثِيرَةً كَانَ بَنُو إِسْرَائِيلَ يَحْرُسُونَ حِرَاسَةَ ٱلرَّبِّ وَلَا يَرْتَحِلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","وَإِذَا كَانَتِ ٱلسَّحَابَةُ أَيَّامًا قَلِيلَةً عَلَى ٱلْمَسْكَنِ، فَحَسَبَ قَوْلِ ٱلرَّبِّ كَانُوا يَنْزِلُونَ، وَحَسَبَ قَوْلِ ٱلرَّبِّ كَانُوا يَرْتَحِلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","وَإِذَا كَانَتِ ٱلسَّحَابَةُ مِنَ ٱلْمَسَاءِ إِلَى ٱلصَّبَاحِ، ثُمَّ ٱرْتَفَعَتِ ٱلسَّحَابَةُ فِي ٱلصَّبَاحِ، كَانُوا يَرْتَحِلُونَ. أَوْ يَوْمًا وَلَيْلَةً ثُمَّ ٱرْتَفَعَتِ ٱلسَّحَابَةُ كَانُوا يَرْتَحِلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","أَوْ يَوْمَيْنِ أَوْ شَهْرًا أَوْ سَنَةً، مَتَى تَمَادَتِ ٱلسَّحَابَةُ عَلَى ٱلْمَسْكَنِ حَالَّةً عَلَيْهِ، كَانَ بَنُو إِسْرَائِيلَ يَنْزِلُونَ وَلَا يَرْتَحِلُونَ. وَمَتَى ٱرْتَفَعَتْ كَانُوا يَرْتَحِلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","حَسَبَ قَوْلِ ٱلرَّبِّ كَانُوا يَنْزِلُونَ، وَحَسَبَ قَوْلِ ٱلرَّبِّ كَانُوا يَرْتَحِلُونَ. وَكَانُوا يَحْرُسُونَ حِرَاسَةَ ٱلرَّبِّ حَسَبَ قَوْلِ ٱلرَّبِّ بِيَدِ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«ٱصْنَعْ لَكَ بُوقَيْنِ مِنْ فِضَّةٍ. مَسْحُولَيْنِ تَعْمَلُهُمَا، فَيَكُونَانِ لَكَ لِمُنَادَاةِ ٱلْجَمَاعَةِ وَلِٱرْتِحَالِ ٱلْمَحَلَّاتِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","فَإِذَا ضَرَبُوا بِهِمَا يَجْتَمِعُ إِلَيْكَ كُلُّ ٱلْجَمَاعَةِ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","وَإِذَا ضَرَبُوا بِوَاحِدٍ يَجْتَمِعُ إِلَيْكَ ٱلرُّؤَسَاءُ، رُؤُوسُ أُلُوفِ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","وَإِذَا ضَرَبْتُمْ هُتَافًا تَرْتَحِلُ ٱلْمَحَلَّاتُ ٱلنَّازِلَةُ إِلَى ٱلشَّرْقِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","وَإِذَا ضَرَبْتُمْ هُتَافًا ثَانِيَةً تَرْتَحِلُ ٱلْمَحَلَّاتُ ٱلنَّازِلَةُ إِلَى ٱلْجَنُوبِ. هُتَافًا يَضْرِبُونَ لِرِحْلَاتِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","وَأَمَّا عِنْدَمَا تَجْمَعُونَ ٱلْجَمَاعَةَ فَتَضْرِبُونَ وَلَا تَهْتِفُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","وَبَنُو هَارُونَ ٱلْكَهَنَةُ يَضْرِبُونَ بِٱلْأَبْوَاقِ. فَتَكُونُ لَكُمْ فَرِيضَةً أَبَدِيَّةً فِي أَجْيَالِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","وَإِذَا ذَهَبْتُمْ إِلَى حَرْبٍ فِي أَرْضِكُمْ عَلَى عَدُوٍّ يَضُرُّ بِكُمْ، تَهْتِفُونَ بِٱلْأَبْوَاقِ، فَتُذْكَرُونَ أَمَامَ ٱلرَّبِّ إِلَهِكُمْ، وَتُخَلَّصُونَ مِنْ أَعْدَائِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","وَفِي يَوْمِ فَرَحِكُمْ، وَفِي أَعْيَادِكُمْ وَرُؤُوسِ شُهُورِكُمْ، تَضْرِبُونَ بِٱلْأَبْوَاقِ عَلَى مُحْرَقَاتِكُمْ وَذَبَائِحِ سَلَامَتِكُمْ، فَتَكُونُ لَكُمْ تَذْكَارًا أَمَامَ إِلَهِكُمْ. أَنَا ٱلرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","وَفِي ٱلسَّنَةِ ٱلثَّانِيَةِ فِي ٱلشَّهْرِ ٱلثَّانِي، فِي ٱلْعِشْرِينَ مِنَ ٱلشَّهْرِ، ٱرْتَفَعَتِ ٱلسَّحَابَةُ عَنْ مَسْكَنِ ٱلشَّهَادَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","فَٱرْتَحَلَ بَنُو إِسْرَائِيلَ فِي رِحْلَاتِهِمْ مِنْ بَرِّيَّةِ سِينَاءَ، فَحَلَّتِ ٱلسَّحَابَةُ فِي بَرِّيَّةِ فَارَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ٱرْتَحَلُوا أَوَّلًا حَسَبَ قَوْلِ ٱلرَّبِّ عَنْ يَدِ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","فَٱرْتَحَلَتْ رَايَةُ مَحَلَّةِ بَنِي يَهُوذَا أَوَّلًا حَسَبَ أَجْنَادِهِمْ، وَعَلَى جُنْدِهِ نَحْشُونُ بْنُ عَمِّينَادَابَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","وَعَلَى جُنْدِ سِبْطِ بَنِي يَسَّاكَرَ نَثَنَائِيلُ بْنُ صُوغَرَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","وَعَلَى جُنْدِ سِبْطِ بَنِي زَبُولُونَ أَلِيآبُ بْنُ حِيلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ثُمَّ أُنْزِلَ ٱلْمَسْكَنُ فَٱرْتَحَلَ بَنُو جَرْشُونَ وَبَنُو مَرَارِي حَامِلِينَ ٱلْمَسْكَنَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ثُمَّ ٱرْتَحَلَتْ رَايَةُ مَحَلَّةِ رَأُوبَيْنَ حَسَبَ أَجْنَادِهِمْ، وَعَلَى جُنْدِهِ أَلِيصُورُ بْنُ شَدَيْئُورَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","وَعَلَى جُنْدِ سِبْطِ بَنِي شِمْعُونَ شَلُومِيئِيلُ بْنُ صُورِيشَدَّاي، ");
INSERT INTO arb_vd_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","وَعَلَى جُنْدِ سِبْطِ بَنِي جَادَ أَلِيَاسَافُ بْنُ دَعُوئِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ثُمَّ ٱرْتَحَلَ ٱلْقَهَاتِيُّونَ حَامِلِينَ ٱلْمَقْدِسَ. وَأُقِيمَ ٱلْمَسْكَنُ إِلَى أَنْ جَاءُوا ");
INSERT INTO arb_vd_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ثُمَّ ٱرْتَحَلَتْ رَايَةُ مَحَلَّةِ بَنِي أَفْرَايِمَ حَسَبَ أَجْنَادِهِمْ، وَعَلَى جُنْدِهِ أَلِيشَمَعُ بْنُ عَمِّيهُودَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","وَعَلَى جُنْدِ سِبْطِ بَنِي مَنَسَّى جَمْلِيئِيلُ بْنُ فَدَهْصُورَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","وَعَلَى جُنْدِ سِبْطِ بَنِي بَنْيَامِينَ أَبِيدَنُ بْنُ جِدْعُونِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ثُمَّ ٱرْتَحَلَتْ رَايَةُ مَحَلَّةِ بَنِي دَانَ سَاقَةِ جَمِيعِ ٱلْمَحَلَّاتِ حَسَبَ أَجْنَادِهِمْ، وَعَلَى جُنْدِهِ أَخِيعَزَرُ بْنُ عَمِّيشَدَّاي، ");
INSERT INTO arb_vd_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","وَعَلَى جُنْدِ سِبْطِ بَنِي أَشِيرَ فَجْعِيئِيلُ بْنُ عُكْرَنَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","وَعَلَى جُنْدِ سِبْطِ بَنِي نَفْتَالِي أَخِيرَعُ بْنُ عِينَنَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","هَذِهِ رِحْلَاتُ بَنِي إِسْرَائِيلَ بِأَجْنَادِهِمْ حِينَ ٱرْتَحَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","وَقَالَ مُوسَى لِحُوبَابَ بْنِ رَعُوئِيلَ ٱلْمِدْيَانِيِّ حَمِي مُوسَى: «إِنَّنَا رَاحِلُونَ إِلَى ٱلْمَكَانِ ٱلَّذِي قَالَ ٱلرَّبُّ أُعْطِيكُمْ إِيَّاهُ. اِذْهَبْ مَعَنَا فَنُحْسِنَ إِلَيْكَ، لِأَنَّ ٱلرَّبَّ قَدْ تَكَلَّمَ عَنْ إِسْرَائِيلَ بِٱلْإِحْسَانِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","فَقَالَ لَهُ: «لَا أَذْهَبُ، بَلْ إِلَى أَرْضِي وَإِلَى عَشِيرَتِي أَمْضِي». ");
INSERT INTO arb_vd_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","فَقَالَ: «لَا تَتْرُكْنَا، لِأَنَّهُ بِمَا أَنَّكَ تَعْرِفُ مَنَازِلَنَا فِي ٱلْبَرِّيَّةِ تَكُونُ لَنَا كَعُيُونٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","وَإِنْ ذَهَبْتَ مَعَنَا فَبِنَفْسِ ٱلْإِحْسَانِ ٱلَّذِي يُحْسِنُ ٱلرَّبُّ إِلَيْنَا نُحْسِنُ نَحْنُ إِلَيْكَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","فَٱرْتَحَلُوا مِنْ جَبَلِ ٱلرَّبِّ مَسِيرَةَ ثَلَاثَةِ أَيَّامٍ، وَتَابُوتُ عَهْدِ ٱلرَّبِّ رَاحِلٌ أَمَامَهُمْ مَسِيرَةَ ثَلَاثَةِ أَيَّامٍ لِيَلْتَمِسَ لَهُمْ مَنْزِلًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","وَكَانَتْ سَحَابَةُ ٱلرَّبِّ عَلَيْهِمْ نَهَارًا فِي ٱرْتِحَالِهِمْ مِنَ ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","وَعِنْدَ ٱرْتِحَالِ ٱلتَّابُوتِ كَانَ مُوسَى يَقُولُ: «قُمْ يَا رَبُّ، فَلْتَتَبَدَّدْ أَعْدَاؤُكَ وَيَهْرُبْ مُبْغِضُوكَ مِنْ أَمَامِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","وَعِنْدَ حُلُولِهِ كَانَ يَقُولُ: «ٱرْجِعْ يَا رَبُّ إِلَى رِبَوَاتِ أُلُوفِ إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","وَكَانَ ٱلشَّعْبُ كَأَنَّهُمْ يَشْتَكُونَ شَرًّا فِي أُذُنَيِ ٱلرَّبِّ. وَسَمِعَ ٱلرَّبُّ فَحَمِيَ غَضَبُهُ، فَٱشْتَعَلَتْ فِيهِمْ نَارُ ٱلرَّبِّ وَأَحْرَقَتْ فِي طَرَفِ ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","فَصَرَخَ ٱلشَّعْبُ إِلَى مُوسَى، فَصَلَّى مُوسَى إِلَى ٱلرَّبِّ فَخَمَدَتِ ٱلنَّارُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","فَدُعِيَ ٱسْمُ ذَلِكَ ٱلْمَوْضِعِ «تَبْعِيرَةَ» لِأَنَّ نَارَ ٱلرَّبِّ ٱشْتَعَلَتْ فِيهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","وَٱللَّفِيفُ ٱلَّذِي فِي وَسَطِهِمِ ٱشْتَهَى شَهْوَةً. فَعَادَ بَنُو إِسْرَائِيلَ أَيْضًا وَبَكَوْا وَقَالُوا: «مَنْ يُطْعِمُنَا لَحْمًا؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","قَدْ تَذَكَّرْنَا ٱلسَّمَكَ ٱلَّذِي كُنَّا نَأْكُلُهُ فِي مِصْرَ مَجَّانًا، وَٱلْقِثَّاءَ وَٱلْبَطِّيخَ وَٱلْكُرَّاثَ وَٱلْبَصَلَ وَٱلثُّومَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","وَٱلْآنَ قَدْ يَبِسَتْ أَنْفُسُنَا. لَيْسَ شَيْءٌ غَيْرَ أَنَّ أَعْيُنَنَا إِلَى هَذَا ٱلْمَنِّ!». ");
INSERT INTO arb_vd_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","وَأَمَّا ٱلْمَنُّ فَكَانَ كَبِزْرِ ٱلْكُزْبَرَةِ، وَمَنْظَرُهُ كَمَنْظَرِ ٱلْمُقْلِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","كَانَ ٱلشَّعْبُ يَطُوفُونَ لِيَلْتَقِطُوهُ، ثُمَّ يَطْحَنُونَهُ بِٱلرَّحَى أَوْ يَدُقُّونَهُ فِي ٱلْهَاوَنِ وَيَطْبُخُونَهُ فِي ٱلْقُدُورِ وَيَعْمَلُونَهُ مَلَّاتٍ. وَكَانَ طَعْمُهُ كَطَعْمِ قَطَائِفَ بِزَيْتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","وَمَتَى نَزَلَ ٱلنَّدَى عَلَى ٱلْمَحَلَّةِ لَيْلًا كَانَ يَنْزِلُ ٱلْمَنُّ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","فَلَمَّا سَمِعَ مُوسَى ٱلشَّعْبَ يَبْكُونَ بِعَشَائِرِهِمْ، كُلَّ وَاحِدٍ فِي بَابِ خَيْمَتِهِ، وَحَمِيَ غَضَبُ ٱلرَّبِّ جِدًّا، سَاءَ ذَلِكَ فِي عَيْنَيْ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","فَقَالَ مُوسَى لِلرَّبِّ: «لِمَاذَا أَسَأْتَ إِلَى عَبْدِكَ؟ وَلِمَاذَا لَمْ أَجِدْ نِعْمَةً فِي عَيْنَيْكَ حَتَّى أَنَّكَ وَضَعْتَ ثِقْلَ جَمِيعِ هَذَا ٱلشَّعْبِ عَلَيَّ؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","أَلَعَلِّي حَبِلْتُ بِجَمِيعِ هَذَا ٱلشَّعْبِ؟ أَوْ لَعَلِّي وَلَدْتُهُ، حَتَّى تَقُولَ لِي ٱحْمِلْهُ فِي حِضْنِكَ كَمَا يَحْمِلُ ٱلْمُرَبِّي ٱلرَّضِيعَ، إِلَى ٱلْأَرْضِ ٱلَّتِي حَلَفْتَ لِآبَائِهِ؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","مِنْ أَيْنَ لِي لَحْمٌ حَتَّى أُعْطِيَ جَمِيعَ هَذَا ٱلشَّعْبِ؟ لِأَنَّهُمْ يَبْكُونَ عَلَيَّ قَائِلِينَ: أَعْطِنَا لَحْمًا لِنَأْكُلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","لَا أَقْدِرُ أَنَا وَحْدِي أَنْ أَحْمِلَ جَمِيعَ هَذَا ٱلشَّعْبِ لِأَنَّهُ ثَقِيلٌ عَلَيَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","فَإِنْ كُنْتَ تَفْعَلُ بِي هَكَذَا، فَٱقْتُلْنِي قَتْلًا إِنْ وَجَدْتُ نِعْمَةً فِي عَيْنَيْكَ، فَلَا أَرَى بَلِيَّتِي». ");
INSERT INTO arb_vd_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","فَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱجْمَعْ إِلَيَّ سَبْعِينَ رَجُلًا مِنْ شُيُوخِ إِسْرَائِيلَ ٱلَّذِينَ تَعْلَمُ أَنَّهُمْ شُيُوخُ ٱلشَّعْبِ وَعُرَفَاؤُهُ، وَأَقْبِلْ بِهِمْ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ فَيَقِفُوا هُنَاكَ مَعَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","فَأَنْزِلَ أَنَا وَأَتَكَلَّمَ مَعَكَ هُنَاكَ، وَآخُذَ مِنَ ٱلرُّوحِ ٱلَّذِي عَلَيْكَ وَأَضَعَ عَلَيْهِمْ، فَيَحْمِلُونَ مَعَكَ ثِقْلَ ٱلشَّعْبِ، فَلَا تَحْمِلُ أَنْتَ وَحْدَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","وَلِلشَّعْبِ تَقُولُ: تَقَدَّسُوا لِلْغَدِ فَتَأْكُلُوا لَحْمًا، لِأَنَّكُمْ قَدْ بَكَيْتُمْ فِي أُذُنَيِ ٱلرَّبِّ قَائِلِينَ: مَنْ يُطْعِمُنَا لَحْمًا؟ إِنَّهُ كَانَ لَنَا خَيْرٌ فِي مِصْرَ. فَيُعْطِيكُمُ ٱلرَّبُّ لَحْمًا فَتَأْكُلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","تَأْكُلُونَ لَا يَوْمًا وَاحِدًا، وَلَا يَوْمَيْنِ، وَلَا خَمْسَةَ أَيَّامٍ، وَلَا عَشَرَةَ أَيَّامٍ، وَلَا عِشْرِينَ يَوْمًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","بَلْ شَهْرًا مِنَ ٱلزَّمَانِ، حَتَّى يَخْرُجَ مِنْ مَنَاخِرِكُمْ، وَيَصِيرَ لَكُمْ كَرَاهَةً، لِأَنَّكُمْ رَفَضْتُمُ ٱلرَّبَّ ٱلَّذِي فِي وَسَطِكُمْ وَبَكَيْتُمْ أَمَامَهُ قَائِلِينَ: لِمَاذَا خَرَجْنَا مِنْ مِصْرَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","فَقَالَ مُوسَى: «سِتُّ مِئَةِ أَلْفِ مَاشٍ هُوَ ٱلشَّعْبُ ٱلَّذِي أَنَا فِي وَسَطِهِ، وَأَنْتَ قَدْ قُلْتَ: أُعْطِيهِمْ لَحْمًا لِيَأْكُلُوا شَهْرًا مِنَ ٱلزَّمَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","أَيُذْبَحُ لَهُمْ غَنَمٌ وَبَقَرٌ لِيَكْفِيَهُمْ؟ أَمْ يُجْمَعُ لَهُمْ كُلُّ سَمَكِ ٱلْبَحْرِ لِيَكْفِيَهُمْ؟» ");
INSERT INTO arb_vd_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","فَقَالَ ٱلرَّبُّ لِمُوسَى: «هَلْ تَقْصُرُ يَدُ ٱلرَّبِّ؟ ٱلْآنَ تَرَى أَيُوافِيكَ كَلَامِي أَمْ لَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","فَخَرَجَ مُوسَى وَكَلَّمَ ٱلشَّعْبَ بِكَلَامِ ٱلرَّبِّ، وَجَمَعَ سَبْعِينَ رَجُلًا مِنْ شُيُوخِ ٱلشَّعْبِ وَأَوْقَفَهُمْ حَوَالَيِ ٱلْخَيْمَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","فَنَزَلَ ٱلرَّبُّ فِي سَحَابَةٍ وَتَكَلَّمَ مَعَهُ، وَأَخَذَ مِنَ ٱلرُّوحِ ٱلَّذِي عَلَيْهِ وَجَعَلَ عَلَى ٱلسَّبْعِينَ رَجُلًا ٱلشُّيُوخَ. فَلَمَّا حَلَّتْ عَلَيْهِمِ ٱلرُّوحُ تَنَبَّأُوا، وَلَكِنَّهُمْ لَمْ يَزِيدُوا. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","وَبَقِيَ رَجُلَانِ فِي ٱلْمَحَلَّةِ، ٱسْمُ ٱلْوَاحِدِ أَلْدَادُ، وَٱسْمُ ٱلْآخَرِ مِيدَادُ، فَحَلَّ عَلَيْهِمَا ٱلرُّوحُ. وَكَانَا مِنَ ٱلْمَكْتُوبِينَ، لَكِنَّهُمَا لَمْ يَخْرُجَا إِلَى ٱلْخَيْمَةِ، فَتَنَبَّآ فِي ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","فَرَكَضَ غُلَامٌ وَأَخْبَرَ مُوسَى وَقَالَ: «أَلْدَادُ وَمِيدَادُ يَتَنَبَّآنِ فِي ٱلْمَحَلَّةِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","فَأَجَابَ يَشُوعُ بْنُ نُونَ خَادِمُ مُوسَى مِنْ حَدَاثَتِهِ وَقَالَ: «يَا سَيِّدِي مُوسَى، ٱرْدَعْهُمَا!» ");
INSERT INTO arb_vd_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","فَقَالَ لَهُ مُوسَى: «هَلْ تَغَارُ أَنْتَ لِي؟ يَا لَيْتَ كُلَّ شَعْبِ ٱلرَّبِّ كَانُوا أَنْبِيَاءَ إِذَا جَعَلَ ٱلرَّبُّ رُوحَهُ عَلَيْهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ثُمَّ ٱنْحَازَ مُوسَى إِلَى ٱلْمَحَلَّةِ هُوَ وَشُيُوخُ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","فَخَرَجَتْ رِيحٌ مِنْ قِبَلِ ٱلرَّبِّ وَسَاقَتْ سَلْوَى مِنَ ٱلْبَحْرِ وَأَلْقَتْهَا عَلَى ٱلْمَحَلَّةِ، نَحْوَ مَسِيرَةِ يَوْمٍ مِنْ هُنَا وَمَسِيرَةِ يَوْمٍ مِنْ هُنَاكَ، حَوَالَيِ ٱلْمَحَلَّةِ، وَنَحْوَ ذِرَاعَيْنِ فَوْقَ وَجْهِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","فَقَامَ ٱلشَّعْبُ كُلَّ ذَلِكَ ٱلنَّهَارِ، وَكُلَّ ٱللَّيْلِ وَكُلَّ يَوْمِ ٱلْغَدِ وَجَمَعُوا ٱلسَّلْوَى. ٱلَّذِي قَلَّلَ جَمَعَ عَشَرَةَ حَوَامِرَ. وَسَطَّحُوهَا لَهُمْ مَسَاطِحَ حَوَالَيِ ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","وَإِذْ كَانَ ٱللَّحْمُ بَعْدُ بَيْنَ أَسْنَانِهِمْ قَبْلَ أَنْ يَنْقَطِعَ، حَمِيَ غَضَبُ ٱلرَّبِّ عَلَى ٱلشَّعْبِ، وَضَرَبَ ٱلرَّبُّ ٱلشَّعْبَ ضَرْبَةً عَظِيمَةً جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","فَدُعِيَ ٱسْمُ ذَلِكَ ٱلْمَوْضِعِ «قَبَرُوتَ هَتَّأَوَةَ» لِأَنَّهُمْ هُنَاكَ دَفَنُوا ٱلْقَوْمَ ٱلَّذِينَ ٱشْتَهَوْا. ");
INSERT INTO arb_vd_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","وَمِنْ قَبَرُوتَ هَتَّأَوَةَ ٱرْتَحَلَ ٱلشَّعْبُ إِلَى حَضَيْرُوتَ، فَكَانُوا فِي حَضَيْرُوتَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","وَتَكَلَّمَتْ مَرْيَمُ وَهَارُونُ عَلَى مُوسَى بِسَبَبِ ٱلْمَرْأَةِ ٱلْكُوشِيَّةِ ٱلَّتِي ٱتَّخَذَهَا، لِأَنَّهُ كَانَ قَدِ ٱتَّخَذَ ٱمْرَأَةً كُوشِيَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","فَقَالَا: «هَلْ كَلَّمَ ٱلرَّبُّ مُوسَى وَحْدَهُ؟ أَلَمْ يُكَلِّمْنَا نَحْنُ أَيْضًا؟» فَسَمِعَ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","وَأَمَّا ٱلرَّجُلُ مُوسَى فَكَانَ حَلِيمًا جِدًّا أَكْثَرَ مِنْ جَمِيعِ ٱلنَّاسِ ٱلَّذِينَ عَلَى وَجْهِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","فَقَالَ ٱلرَّبُّ حَالًا لِمُوسَى وَهَارُونَ وَمَرْيَمَ: «ٱخْرُجُوا أَنْتُمُ ٱلثَّلَاثَةُ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ». فَخَرَجُوا هُمُ ٱلثَّلَاثَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","فَنَزَلَ ٱلرَّبُّ فِي عَمُودِ سَحَابٍ وَوَقَفَ فِي بَابِ ٱلْخَيْمَةِ، وَدَعَا هَارُونَ وَمَرْيَمَ فَخَرَجَا كِلَاهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","فَقَالَ: «ٱسْمَعَا كَلَامِي. إِنْ كَانَ مِنْكُمْ نَبِيٌّ لِلرَّبِّ، فَبِالرُّؤْيَا أَسْتَعْلِنُ لَهُ. فِي ٱلْحُلْمِ أُكَلِّمُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","وَأَمَّا عَبْدِي مُوسَى فَلَيْسَ هَكَذَا، بَلْ هُوَ أَمِينٌ فِي كُلِّ بَيْتِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","فَمًا إِلَى فَمٍ وَعَيَانًا أَتَكَلَّمُ مَعَهُ، لَا بِٱلْأَلْغَازِ. وَشِبْهَ ٱلرَّبِّ يُعَايِنُ. فَلِمَاذَا لَا تَخْشَيَانِ أَنْ تَتَكَلَّمَا عَلَى عَبْدِي مُوسَى؟». ");
INSERT INTO arb_vd_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","فَحَمِيَ غَضَبُ ٱلرَّبِّ عَلَيْهِمَا وَمَضَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","فَلَمَّا ٱرْتَفَعَتِ ٱلسَّحَابَةُ عَنِ ٱلْخَيْمَةِ إِذَا مَرْيَمُ بَرْصَاءُ كَٱلثَّلْجِ. فَٱلْتَفَتَ هَارُونُ إِلَى مَرْيَمَ وَإِذَا هِيَ بَرْصَاءُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","فَقَالَ هَارُونُ لِمُوسَى: «أَسْأَلُكَ يَا سَيِّدِي، لَا تَجْعَلْ عَلَيْنَا ٱلْخَطِيَّةَ ٱلَّتِي حَمِقْنَا وَأَخْطَأْنَا بِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","فَلَا تَكُنْ كَٱلْمَيْتِ ٱلَّذِي يَكُونُ عِنْدَ خُرُوجِهِ مِنْ رَحِمِ أُمِّهِ قَدْ أُكِلَ نِصْفُ لَحْمِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","فَصَرَخَ مُوسَى إِلَى ٱلرَّبِّ قَائِلًا: «ٱللَّهُمَّ ٱشْفِهَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","فَقَالَ ٱلرَّبُّ لِمُوسَى: «وَلَوْ بَصَقَ أَبُوهَا بَصْقًا فِي وَجْهِهَا، أَمَا كَانَتْ تَخْجَلُ سَبْعَةَ أَيَّامٍ؟ تُحْجَزُ سَبْعَةَ أَيَّامٍ خَارِجَ ٱلْمَحَلَّةِ، وَبَعْدَ ذَلِكَ تُرْجَعُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","فَحُجِزَتْ مَرْيَمُ خَارِجَ ٱلْمَحَلَّةِ سَبْعَةَ أَيَّامٍ، وَلَمْ يَرْتَحِلِ ٱلشَّعْبُ حَتَّى أُرْجِعَتْ مَرْيَمُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","وَبَعْدَ ذَلِكَ ٱرْتَحَلَ ٱلشَّعْبُ مِنْ حَضَيْرُوتَ وَنَزَلُوا فِي بَرِّيَّةِ فَارَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ثُمَّ كَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«أَرْسِلْ رِجَالًا لِيَتَجَسَّسُوا أَرْضَ كَنْعَانَ ٱلَّتِي أَنَا مُعْطِيهَا لِبَنِي إِسْرَائِيلَ. رَجُلًا وَاحِدًا لِكُلِّ سِبْطٍ مِنْ آبَائِهِ تُرْسِلُونَ. كُلُّ وَاحِدٍ رَئِيسٌ فِيهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","فَأَرْسَلَهُمْ مُوسَى مِنْ بَرِّيَّةِ فَارَانَ حَسَبَ قَوْلِ ٱلرَّبِّ. كُلُّهُمْ رِجَالٌ هُمْ رُؤَسَاءُ بَنِي إِسْرَائِيلَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","وَهَذِهِ أَسْمَاؤُهُمْ: مِنْ سِبْطِ رَأُوبَيْنَ شَمُّوعُ بْنُ زَكُّورَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","مِنْ سِبْطِ شِمْعُونَ شَافَاطُ ٱبْنُ حُورِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","مِنْ سِبْطِ يَهُوذَا كَالِبُ بْنُ يَفُنَّةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","مِنْ سِبْطِ يَسَّاكَرَ يَجْآلُ بْنُ يُوسُفَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","مِنْ سِبْطِ أَفْرَايِمَ هُوشَعُ بْنُ نُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","مِنْ سِبْطِ بَنْيَامِينَ فَلْطِي بْنُ رَافُو. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","مِنْ سِبْطِ زَبُولُونَ جَدِّيئِيلُ بْنُ سُودِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","مِنْ سِبْطِ يُوسُفَ مِنْ سِبْطِ مَنَسَّى جِدِّي بْنُ سُوسِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","مِنْ سِبْطِ دَانَ عَمِّيئِيلُ بْنُ جَمَلِّي. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","مِنْ سِبْطِ أَشِيرَ سَتُورُ بْنُ مِيخَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","مِنْ سِبْطِ نَفْتَالِي نَحْبِي بْنُ وَفْسِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","مِنْ سِبْطِ جَادَ جَأُوئِيلُ بْنُ مَاكِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","هَذِهِ أَسْمَاءُ ٱلرِّجَالِ ٱلَّذِينَ أَرْسَلَهُمْ مُوسَى لِيَتَجَسَّسُوا ٱلْأَرْضَ. وَدَعَا مُوسَى هُوشَعَ بْنَ نُونَ «يَشُوعَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","فَأَرْسَلَهُمْ مُوسَى لِيَتَجَسَّسُوا أَرْضَ كَنْعَانَ، وَقَالَ لَهُمُ: «ٱصْعَدُوا مِنْ هُنَا إِلَى ٱلْجَنُوبِ وَٱطْلَعُوا إِلَى ٱلْجَبَلِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","وَٱنْظُرُوا ٱلْأَرْضَ، مَا هِيَ: وَٱلشَّعْبَ ٱلسَّاكِنَ فِيهَا، أَقَوِيٌّ هُوَ أَمْ ضَعِيفٌ؟ قَلِيلٌ أَمْ كَثِيرٌ؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","وَكَيْفَ هِيَ ٱلْأَرْضُ ٱلَّتِي هُوَ سَاكِنٌ فِيهَا، أَجَيِّدَةٌ أَمْ رَدِيَّةٌ؟ وَمَا هِيَ ٱلْمُدُنُ ٱلَّتِي هُوَ سَاكِنٌ فِيهَا، أَمُخَيَّمَاتٌ أَمْ حُصُونٌ؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","وَكَيْفَ هِيَ ٱلْأَرْضُ، أَسَمِينَةٌ أَمْ هَزِيلَةٌ؟ أَفِيهَا شَجَرٌ أَمْ لَا؟ وَتَشَدَّدُوا فَخُذُوا مِنْ ثَمَرِ ٱلْأَرْضِ». وَأَمَّا ٱلْأَيَّامُ فَكَانَتْ أَيَّامَ بَاكُورَاتِ ٱلْعِنَبِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","فَصَعِدُوا وَتَجَسَّسُوا ٱلْأَرْضَ مِنْ بَرِّيَّةِ صِينَ إِلَى رَحُوبَ فِي مَدْخَلِ حَمَاةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","صَعِدُوا إِلَى ٱلْجَنُوبِ وَأَتَوْا إِلَى حَبْرُونَ. وَكَانَ هُنَاكَ أَخِيمَانُ وَشِيشَايُ وَتَلْمَايُ بَنُو عَنَاقٍ. وَأَمَّا حَبْرُونُ فَبُنِيَتْ قَبْلَ صُوعَنِ مِصْرَ بِسَبْعِ سِنِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","وَأَتَوْا إِلَى وَادِي أَشْكُولَ، وَقَطَفُوا مِنْ هُنَاكَ زَرَجُونَةً بِعُنْقُودٍ وَاحِدٍ مِنَ ٱلْعِنَبِ، وَحَمَلُوهُ بِٱلدُّقْرَانَةِ بَيْنَ ٱثْنَيْنِ، مَعَ شَيْءٍ مِنَ ٱلرُّمَّانِ وَٱلتِّينِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","فَدُعِيَ ذَلِكَ ٱلْمَوْضِعُ «وَادِيَ أَشْكُولَ» بِسَبَبِ ٱلْعُنْقُودِ ٱلَّذِي قَطَعَهُ بَنُو إِسْرَائِيلَ مِنْ هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ثُمَّ رَجَعُوا مِنْ تَجَسُّسِ ٱلْأَرْضِ بَعْدَ أَرْبَعِينَ يَوْمًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","فَسَارُوا حَتَّى أَتَوْا إِلَى مُوسَى وَهَارُونَ وَكُلِّ جَمَاعَةِ بَنِي إِسْرَائِيلَ، إِلَى بَرِّيَّةِ فَارَانَ، إِلَى قَادَشَ، وَرَدُّوا إِلَيْهِمَا خَبَرًا وَإِلَى كُلِّ ٱلْجَمَاعَةِ وَأَرَوْهُمْ ثَمَرَ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","وَأَخْبَرُوهُ وَقَالُوا: «قَدْ ذَهَبْنَا إِلَى ٱلْأَرْضِ ٱلَّتِي أَرْسَلْتَنَا إِلَيْهَا، وَحَقًّا إِنَّهَا تَفِيضُ لَبَنًا وَعَسَلًا، وَهَذَا ثَمَرُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","غَيْرَ أَنَّ ٱلشَّعْبَ ٱلسَّاكِنَ فِي ٱلْأَرْضِ مُعْتَزٌّ، وَٱلْمُدُنُ حَصِينَةٌ عَظِيمَةٌ جِدًّا. وَأَيْضًا قَدْ رَأَيْنَا بَنِي عَنَاقَ هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ٱلْعَمَالِقَةُ سَاكِنُونَ فِي أَرْضِ ٱلْجَنُوبِ، وَٱلْحِثِّيُّونَ وَٱلْيَبُوسِيُّونَ وَٱلْأَمُورِيُّونَ سَاكِنُونَ فِي ٱلْجَبَلِ، وَٱلْكَنْعَانِيُّونَ سَاكِنُونَ عِنْدَ ٱلْبَحْرِ وَعَلَى جَانِبِ ٱلْأُرْدُنِّ». ");
INSERT INTO arb_vd_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","لَكِنْ كَالِبُ أَنْصَتَ ٱلشَّعْبَ إِلَى مُوسَى وَقَالَ: «إِنَّنَا نَصْعَدُ وَنَمْتَلِكُهَا لِأَنَّنَا قَادِرُونَ عَلَيْهَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","وَأَمَّا ٱلرِّجَالُ ٱلَّذِينَ صَعِدُوا مَعَهُ فَقَالُوا: «لَا نَقْدِرْ أَنْ نَصْعَدَ إِلَى ٱلشَّعْبِ، لِأَنَّهُمْ أَشَدُّ مِنَّا». ");
INSERT INTO arb_vd_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","فَأَشَاعُوا مَذَمَّةَ ٱلْأَرْضِ ٱلَّتِي تَجَسَّسُوهَا، فِي بَنِي إِسْرَائِيلَ قَائِلِينَ: «ٱلْأَرْضُ ٱلَّتِي مَرَرْنَا فِيهَا لِنَتَجَسَّسَهَا هِيَ أَرْضٌ تَأْكُلُ سُكَّانَهَا، وَجَمِيعُ ٱلشَّعْبِ ٱلَّذِي رَأَيْنَا فِيهَا أُنَاسٌ طِوَالُ ٱلْقَامَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","وَقَدْ رَأَيْنَا هُنَاكَ ٱلْجَبَابِرَةَ، بَنِي عَنَاقٍ مِنَ ٱلْجَبَابِرَةِ. فَكُنَّا فِي أَعْيُنِنَا كَٱلْجَرَادِ، وَهَكَذَا كُنَّا فِي أَعْيُنِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","فَرَفَعَتْ كُلُّ ٱلْجَمَاعَةِ صَوْتَهَا وَصَرَخَتْ، وَبَكَى ٱلشَّعْبُ تِلْكَ ٱللَّيْلَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","وَتَذَمَّرَ عَلَى مُوسَى وَعَلَى هَارُونَ جَمِيعُ بَنِي إِسْرَائِيلَ، وَقَالَ لَهُمَا كُلُّ ٱلْجَمَاعَةِ: «لَيْتَنَا مُتْنَا فِي أَرْضِ مِصْرَ، أَوْ لَيْتَنَا مُتْنَا فِي هَذَا ٱلْقَفْرِ! ");
INSERT INTO arb_vd_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","وَلِمَاذَا أَتَى بِنَا ٱلرَّبُّ إِلَى هَذِهِ ٱلْأَرْضِ لِنَسْقُطَ بِٱلسَّيْفِ؟ تَصِيرُ نِسَاؤُنَا وَأَطْفَالُنَا غَنِيمَةً. أَلَيْسَ خَيْرًا لَنَا أَنْ نَرْجِعَ إِلَى مِصْرَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","فَقَالَ بَعْضُهُمْ لِبَعْضٍ: «نُقِيمُ رَئِيسًا وَنَرْجِعُ إِلَى مِصْرَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","فَسَقَطَ مُوسَى وَهَارُونُ عَلَى وَجْهَيْهِمَا أَمَامَ كُلِّ مَعْشَرِ جَمَاعَةِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","وَيَشُوعُ بْنُ نُونَ وَكَالِبُ بْنُ يَفُنَّةَ، مِنَ ٱلَّذِينَ تَجَسَّسُوا ٱلْأَرْضَ، مَزَّقَا ثِيَابَهُمَا ");
INSERT INTO arb_vd_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","وَكَلَّمَا كُلَّ جَمَاعَةِ بَنِي إِسْرَائِيلَ قَائِلَيْنِ: «ٱلْأَرْضُ ٱلَّتِي مَرَرْنَا فِيهَا لِنَتَجَسَّسَهَا ٱلأَرْضُ جَيِّدَةٌ جِدًّا جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","إِنْ سُرَّ بِنَا ٱلرَّبُّ يُدْخِلْنَا إِلَى هَذِهِ ٱلْأَرْضِ وَيُعْطِينَا إِيَّاهَا، أَرْضًا تَفِيضُ لَبَنًا وَعَسَلًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","إِنَّمَا لَا تَتَمَرَّدُوا عَلَى ٱلرَّبِّ، وَلَا تَخَافُوا مِنْ شَعْبِ ٱلْأَرْضِ لِأَنَّهُمْ خُبْزُنَا. قَدْ زَالَ عَنْهُمْ ظِلُّهُمْ، وَٱلرَّبُّ مَعَنَا. لَا تَخَافُوهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","وَلَكِنْ قَالَ كُلُّ ٱلْجَمَاعَةِ أَنْ يُرْجَمَا بِٱلْحِجَارَةِ. ثُمَّ ظَهَرَ مَجْدُ ٱلرَّبِّ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ لِكُلِّ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","وَقَالَ ٱلرَّبُّ لِمُوسَى: «حَتَّى مَتَى يُهِينُنِي هَذَا ٱلشَّعْبُ؟ وَحَتَّى مَتَى لَا يُصَدِّقُونَنِي بِجَمِيعِ ٱلْآيَاتِ ٱلَّتِي عَمِلْتُ فِي وَسَطِهِمْ؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","إِنِّي أَضْرِبُهُمْ بِٱلْوَبَإِ وَأُبِيدُهُمْ، وَأُصَيِّرُكَ شَعْبًا أَكْبَرَ وَأَعْظَمَ مِنْهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","فَقَالَ مُوسَى لِلرَّبِّ: «فَيَسْمَعُ ٱلْمِصْرِيُّونَ ٱلَّذِينَ أَصْعَدْتَ بِقُوَّتِكَ هَذَا ٱلشَّعْبَ مِنْ وَسَطِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","وَيَقُولُونَ لِسُكَّانِ هَذِهِ ٱلْأَرْضِ ٱلَّذِينَ قَدْ سَمِعُوا أَنَّكَ يَا رَبُّ فِي وَسَطِ هَذَا ٱلشَّعْبِ، ٱلَّذِينَ أَنْتَ يَا رَبُّ قَدْ ظَهَرْتَ لَهُمْ عَيْنًا لِعَيْنٍ، وَسَحَابَتُكَ وَاقِفَةٌ عَلَيْهِمْ، وَأَنْتَ سَائِرٌ أَمَامَهُمْ بِعَمُودِ سَحَابٍ نَهَارًا وَبِعَمُودِ نَارٍ لَيْلًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","فَإِنْ قَتَلْتَ هَذَا ٱلشَّعْبَ كَرَجُلٍ وَاحِدٍ، يَتَكَلَّمُ ٱلشُّعُوبُ ٱلَّذِينَ سَمِعُوا بِخَبَرِكَ قَائِلِينَ: ");
INSERT INTO arb_vd_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","لِأَنَّ ٱلرَّبَّ لَمْ يَقْدِرْ أَنْ يُدْخِلَ هَذَا ٱلشَّعْبَ إِلَى ٱلْأَرْضِ ٱلَّتِي حَلَفَ لَهُمْ، قَتَلَهُمْ فِي ٱلْقَفْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","فَٱلْآنَ لِتَعْظُمْ قُدْرَةُ سَيِّدِي كَمَا تَكَلَّمْتَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","ٱلرَّبُّ طَوِيلُ ٱلرُّوحِ كَثِيرُ ٱلْإِحْسَانِ، يَغْفِرُ ٱلذَّنْبَ وَٱلسَّيِّئَةَ، لَكِنَّهُ لَا يُبْرِئُ. بَلْ يَجْعَلُ ذَنْبَ ٱلْآبَاءِ عَلَى ٱلْأَبْنَاءِ إِلَى ٱلْجِيلِ ٱلثَّالِثِ وَٱلرَّابِعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","اِصْفَحْ عَنْ ذَنْبِ هَذَا ٱلشَّعْبِ كَعَظَمَةِ نِعْمَتِكَ، وَكَمَا غَفَرْتَ لِهَذَا ٱلشَّعْبِ مِنْ مِصْرَ إِلَى هَهُنَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","فَقَالَ ٱلرَّبُّ: «قَدْ صَفَحْتُ حَسَبَ قَوْلِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","وَلَكِنْ حَيٌّ أَنَا فَتُمْلَأُ كُلُّ ٱلْأَرْضِ مِنْ مَجْدِ ٱلرَّبِّ، ");
INSERT INTO arb_vd_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","إِنَّ جَمِيعَ ٱلرِّجَالِ ٱلَّذِينَ رَأَوْا مَجْدِي وَآيَاتِي ٱلَّتِي عَمِلْتُهَا فِي مِصْرَ وَفِي ٱلْبَرِّيَّةِ، وَجَرَّبُونِي ٱلْآنَ عَشَرَ مَرَّاتٍ، وَلَمْ يَسْمَعُوا لِقَوْلِي، ");
INSERT INTO arb_vd_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","لَنْ يَرَوْا ٱلْأَرْضَ ٱلَّتِي حَلَفْتُ لِآبَائِهِمْ. وَجَمِيعُ ٱلَّذِينَ أَهَانُونِي لَا يَرَوْنَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","وَأَمَّا عَبْدِي كَالِبُ فَمِنْ أَجْلِ أَنَّهُ كَانَتْ مَعَهُ رُوحٌ أُخْرَى، وَقَدِ ٱتَّبَعَنِي تَمَامًا، أُدْخِلُهُ إِلَى ٱلْأَرْضِ ٱلَّتِي ذَهَبَ إِلَيْهَا، وَزَرْعُهُ يَرِثُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","وَإِذِ ٱلْعَمَالِقَةُ وَٱلْكَنْعَانِيُّونَ سَاكِنُونَ فِي ٱلْوَادِي، فَٱنْصَرِفُوا غَدًا وَٱرْتَحِلُوا إِلَى ٱلْقَفْرِ فِي طَرِيقِ بَحْرِ سُوفَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«حَتَّى مَتَى أَغْفِرُ لِهَذِهِ ٱلْجَمَاعَةِ ٱلشِّرِّيرَةِ ٱلْمُتَذَمِّرَةِ عَلَيَّ؟ قَدْ سَمِعْتُ تَذَمُّرَ بَنِي إِسْرَائِيلَ ٱلَّذِي يَتَذَمَّرُونَهُ عَلَيَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","قُلْ لَهُمْ: حَيٌّ أَنَا يَقُولُ ٱلرَّبُّ، لَأَفْعَلَنَّ بِكُمْ كَمَا تَكَلَّمْتُمْ فِي أُذُنَيَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","فِي هَذَا ٱلْقَفْرِ تَسْقُطُ جُثَثُكُمْ، جَمِيعُ ٱلْمَعْدُودِينَ مِنْكُمْ حَسَبَ عَدَدِكُمْ مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا ٱلَّذِينَ تَذَمَّرُوا عَلَيَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","لَنْ تَدْخُلُوا ٱلْأَرْضَ ٱلَّتِي رَفَعْتُ يَدِي لِأُسْكِنَنَّكُمْ فِيهَا، مَا عَدَا كَالِبَ بْنَ يَفُنَّةَ وَيَشُوعَ بْنَ نُونٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","وَأَمَّا أَطْفَالُكُمُ ٱلَّذِينَ قُلْتُمْ يَكُونُونَ غَنِيمَةً فَإِنِّي سَأُدْخِلُهُمْ، فَيَعْرِفُونَ ٱلْأَرْضَ ٱلَّتِي ٱحْتَقَرْتُمُوهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","فَجُثَثُكُمْ أَنْتُمْ تَسْقُطُ فِي هَذَا ٱلْقَفْرِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","وَبَنُوكُمْ يَكُونُونَ رُعَاةً فِي ٱلْقَفْرِ أَرْبَعِينَ سَنَةً، وَيَحْمِلُونَ فُجُورَكُمْ حَتَّى تَفْنَى جُثَثُكُمْ فِي ٱلْقَفْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","كَعَدَدِ ٱلْأَيَّامِ ٱلَّتِي تَجَسَّسْتُمْ فِيهَا ٱلْأَرْضَ أَرْبَعِينَ يَوْمًا، لِلسَّنَةِ يَوْمٌ. تَحْمِلُونَ ذُنُوبَكُمْ أَرْبَعِينَ سَنَةً فَتَعْرِفُونَ ٱبْتِعَادِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","أَنَا ٱلرَّبُّ قَدْ تَكَلَّمْتُ. لَأَفْعَلَنَّ هَذَا بِكُلِّ هَذِهِ ٱلْجَمَاعَةِ ٱلشِّرِّيرَةِ ٱلْمُتَّفِقَةِ عَلَيَّ. فِي هَذَا ٱلْقَفْرِ يَفْنَوْنَ، وَفِيهِ يَمُوتُونَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","أَمَّا ٱلرِّجَالُ ٱلَّذِينَ أَرْسَلَهُمْ مُوسَى لِيَتَجَسَّسُوا ٱلْأَرْضَ، وَرَجَعُوا وَسَجَّسُوا عَلَيْهِ كُلَّ ٱلْجَمَاعَةِ بِإِشَاعَةِ ٱلْمَذَمَّةِ عَلَى ٱلْأَرْضِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","فَمَاتَ ٱلرِّجَالُ ٱلَّذِينَ أَشَاعُوا ٱلْمَذَمَّةَ ٱلرَّدِيئَةَ عَلَى ٱلْأَرْضِ بِٱلْوَبَإِ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","وَأَمَّا يَشُوعُ بْنُ نُونَ وَكَالِبُ بْنُ يَفُنَّةَ، مِنْ أُولَئِكَ ٱلرِّجَالِ ٱلَّذِينَ ذَهَبُوا لِيَتَجَسَّسُوا ٱلْأَرْضَ، فَعَاشَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","وَلَمَّا تَكَلَّمَ مُوسَى بِهَذَا ٱلْكَلَامِ إِلَى جَمِيعِ بَنِي إِسْرَائِيلَ بَكَى ٱلشَّعْبُ جِدًّا. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ثُمَّ بَكَّرُوا صَبَاحًا وَصَعِدُوا إِلَى رَأْسِ ٱلْجَبَلِ قَائِلِينَ: «هُوَذَا نَحْنُ! نَصْعَدُ إِلَى ٱلْمَوْضِعِ ٱلَّذِي قَالَ ٱلرَّبُّ عَنْهُ، فَإِنَّنَا قَدْ أَخْطَأْنَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","فَقَالَ مُوسَى: «لِمَاذَا تَتَجَاوَزُونَ قَوْلَ ٱلرَّبِّ؟ فَهَذَا لَا يَنْجَحُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","لَا تَصْعَدُوا، لِأَنَّ ٱلرَّبَّ لَيْسَ فِي وَسَطِكُمْ لِئَلَّا تَنْهَزِمُوا أَمَامَ أَعْدَائِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","لِأَنَّ ٱلْعَمَالِقَةَ وَٱلْكَنْعَانِيِّينَ هُنَاكَ قُدَّامَكُمْ تَسْقُطُونَ بِٱلسَّيْفِ. إِنَّكُمْ قَدِ ٱرْتَدَدْتُمْ عَنِ ٱلرَّبِّ، فَٱلرَّبُّ لَا يَكُونُ مَعَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","لَكِنَّهُمْ تَجَبَّرُوا وَصَعِدُوا إِلَى رَأْسِ ٱلْجَبَلِ. وَأَمَّا تَابُوتُ عَهْدِ ٱلرَّبِّ وَمُوسَى فَلَمْ يَبْرَحَا مِنْ وَسَطِ ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","فَنَزَلَ ٱلْعَمَالِقَةُ وَٱلْكَنْعَانِيُّونَ ٱلسَّاكِنُونَ فِي ذَلِكَ ٱلْجَبَلِ وَضَرَبُوهُمْ وَكَسَّرُوهُمْ إِلَى حُرْمَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: مَتَى جِئْتُمْ إِلَى أَرْضِ مَسْكَنِكُمُ ٱلَّتِي أَنَا أُعْطِيكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","وَعَمِلْتُمْ وَقُودًا لِلرَّبِّ، مُحْرَقَةً أَوْ ذَبِيحَةً، وَفَاءً لِنَذْرٍ أَوْ نَافِلَةً أَوْ فِي أَعْيَادِكُمْ، لِعَمَلِ رَائِحَةِ سَرُورٍ لِلرَّبِّ مِنَ ٱلْبَقَرِ أَوْ مِنَ ٱلْغَنَمِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","يُقَرِّبُ ٱلَّذِي قَرَّبَ قُرْبَانَهُ لِلرَّبِّ تَقْدِمَةً مِنْ دَقِيقٍ، عُشْرًا مَلْتُوتًا بِرُبْعِ ٱلْهِينِ مِنَ ٱلزَّيْتِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","وَخَمْرًا لِلسَّكِيبِ رُبْعَ ٱلْهِينِ. تَعْمَلُ عَلَى ٱلْمُحْرَقَةِ أَوِ ٱلذَّبِيحَةِ لِلْخَرُوفِ ٱلْوَاحِدِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","لَكِنْ لِلْكَبْشِ تَعْمَلُ تَقْدِمَةً مِنْ دَقِيقٍ عُشْرَيْنِ مَلْتُوتَيْنِ بِثُلْثِ ٱلْهِينِ مِنَ ٱلزَّيْتِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","وَخَمْرًا لِلسَّكِيبِ ثُلْثَ ٱلْهِينِ تُقَرِّبُ لِرَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","وَإِذَا عَمِلْتَ ٱبْنَ بَقَرٍ مُحْرَقَةً أَوْ ذَبِيحَةً وَفَاءً لِنَذْرٍ أَوْ ذَبِيحَةَ سَلَامَةٍ لِلرَّبِّ، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","تُقَرِّبُ عَلَى ٱبْنِ ٱلْبَقَرِ تَقْدِمَةً مِنْ دَقِيقٍ ثَلَاثَةَ أَعْشَارٍ مَلْتُوتَةً بِنِصْفِ ٱلْهِينِ مِنَ ٱلزَّيْتِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","وَخَمْرًا تُقَرِّبُ لِلسَّكِيبِ نِصْفَ ٱلْهِينِ وَقُودَ رَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","هَكَذَا يُعْمَلُ لِلثَّوْرِ ٱلْوَاحِدِ أَوْ لِلْكَبْشِ ٱلْوَاحِدِ أَوْ لِلشَّاةِ مِنَ ٱلضَّأْنِ أَوْ مِنَ ٱلْمَعْزِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","كَٱلْعَدَدِ ٱلَّذِي تَعْمَلُونَ هَكَذَا تَعْمَلُونَ لِكُلِّ وَاحِدٍ حَسَبَ عَدَدِهِنَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","كُلُّ وَطَنِيٍّ يَعْمَلُ هَذِهِ هَكَذَا، لِتَقْرِيبِ وَقُودِ رَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","وَإِذَا نَزَلَ عِنْدَكُمْ غَرِيبٌ، أَوْ كَانَ أَحَدٌ فِي وَسَطِكُمْ فِي أَجْيَالِكُمْ وَعَمِلَ وَقُودَ رَائِحَةِ سُرُورٍ لِلرَّبِّ، فَكَمَا تَفْعَلُونَ كَذَلِكَ يَفْعَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","أَيَّتُهَا ٱلْجَمَاعَةُ، لَكُمْ وَلِلْغَرِيبِ ٱلنَّازِلِ عِنْدَكُمْ فَرِيضَةٌ وَاحِدَةٌ دَهْرِيَّةٌ فِي أَجْيَالِكُمْ. مَثَلُكُمْ يَكُونُ مَثَلَ ٱلْغَرِيبِ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","شَرِيعَةٌ وَاحِدَةٌ وَحُكْمٌ وَاحِدٌ يَكُونُ لَكُمْ وَلِلْغَرِيبِ ٱلنَّازِلِ عِنْدَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: مَتَى دَخَلْتُمُ ٱلْأَرْضَ ٱلَّتِي أَنَا آتٍ بِكُمْ إِلَيْهَا، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","فَعِنْدَمَا تَأْكُلُونَ مِنْ خُبْزِ ٱلْأَرْضِ تَرْفَعُونَ رَفِيعَةً لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","أَوَّلَ عَجِينِكُمْ تَرْفَعُونَ قُرْصًا رَفِيعَةً، كَرَفِيعَةِ ٱلْبَيْدَرِ هَكَذَا تَرْفَعُونَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","مِنْ أَوَّلِ عَجِينِكُمْ تُعْطُونَ لِلرَّبِّ رَفِيعَةً فِي أَجْيَالِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«وَإِذَا سَهَوْتُمْ وَلَمْ تَعْمَلُوا جَمِيعَ هَذِهِ ٱلْوَصَايَا ٱلَّتِي كَلَّمَ بِهَا ٱلرَّبُّ مُوسَى، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","جَمِيعَ مَا أَمَرَكُمْ بِهِ ٱلرَّبُّ عَنْ يَدِ مُوسَى، مِنَ ٱلْيَوْمِ ٱلَّذِي أَمَرَ فِيهِ ٱلرَّبُّ فَصَاعِدًا فِي أَجْيَالِكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","فَإِنْ عُمِلَ خُفْيَةً عَنْ أَعْيُنِ ٱلْجَمَاعَةِ سَهْوًا، يَعْمَلُ كُلُّ ٱلْجَمَاعَةِ ثَوْرًا وَاحِدًا ٱبْنَ بَقَرٍ مُحْرَقَةً لِرَائِحَةِ سَرُورٍ لِلرَّبِّ، مَعَ تَقْدِمَتِهِ وَسَكِيبِهِ كَٱلْعَادَةِ، وَتَيْسًا وَاحِدًا مِنَ ٱلْمَعْزِ ذَبِيحَةَ خَطِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","فَيُكَفِّرُ ٱلْكَاهِنُ عَنْ كُلِّ جَمَاعَةِ بَنِي إِسْرَائِيلَ، فَيُصْفَحُ عَنْهُمْ لِأَنَّهُ كَانَ سَهْوًا. فَإِذَا أَتَوْا بِقُرْبَانِهِمْ وَقُودًا لِلرَّبِّ، وَبِذَبِيحَةِ خَطِيَّتِهِمْ أَمَامَ ٱلرَّبِّ لِأَجْلِ سَهْوِهِمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","يُصْفَحُ عَنْ كُلِّ جَمَاعَةِ بَنِي إِسْرَائِيلَ وَٱلْغَرِيبِ ٱلنَّازِلِ بَيْنَهُمْ، لِأَنَّهُ حَدَثَ لِجَمِيعِ ٱلشَّعْبِ بِسَهْوٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«وَإِنْ أَخْطَأَتْ نَفْسٌ وَاحِدَةٌ سَهْوًا، تُقَرِّبْ عَنْزًا حَوْلِيَّةً ذَبِيحَةَ خَطِيَّةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","فَيُكَفِّرُ ٱلْكَاهِنُ عَنِ ٱلنَّفْسِ ٱلَّتِي سَهَتْ عِنْدَمَا أَخْطَأَتْ بِسَهْوٍ أَمَامَ ٱلرَّبِّ لِلتَّكْفِيرِ عَنْهَا، فَيُصْفَحُ عَنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","لِلْوَطَنِيِّ فِي بَنِي إِسْرَائِيلَ وَلِلْغَرِيبِ ٱلنَّازِلِ بَيْنَهُمْ تَكُونُ شَرِيعَةٌ وَاحِدَةٌ لِلْعَامِلِ بِسَهْوٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","وَأَمَّا ٱلنَّفْسُ ٱلَّتِي تَعْمَلُ بِيَدٍ رَفِيعَةٍ مِنَ ٱلْوَطَنِيِّينَ أَوْ مِنَ ٱلْغُرَبَاءِ فَهِيَ تَزْدَرِي بِٱلرَّبِّ. فَتُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ بَيْنِ شَعْبِهَا، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","لِأَنَّهَا ٱحْتَقَرَتْ كَلَامَ ٱلرَّبِّ وَنَقَضَتْ وَصِيَّتَهُ. قَطْعًا تُقْطَعُ تِلْكَ ٱلنَّفْسُ. ذَنْبُهَا عَلَيْهَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","وَلَمَّا كَانَ بَنُو إِسْرَائِيلَ فِي ٱلْبَرِّيَّةِ وَجَدُوا رَجُلًا يَحْتَطِبُ حَطَبًا فِي يَوْمِ ٱلسَّبْتِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","فَقَدَّمَهُ ٱلَّذِينَ وَجَدُوهُ يَحْتَطِبُ حَطَبًا إِلَى مُوسَى وَهَارُونَ وَكُلِّ ٱلْجَمَاعَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","فَوَضَعُوهُ فِي ٱلْمَحْرَسِ لِأَنَّهُ لَمْ يُعْلَنْ مَاذَا يُفْعَلُ بِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","فَقَالَ ٱلرَّبُّ لِمُوسَى: «قَتْلًا يُقْتَلُ ٱلرَّجُلُ. يَرْجُمُهُ بِحِجَارَةٍ كُلُّ ٱلْجَمَاعَةِ خَارِجَ ٱلْمَحَلَّةِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","فَأَخْرَجَهُ كُلُّ ٱلْجَمَاعَةِ إِلَى خَارِجِ ٱلْمَحَلَّةِ وَرَجَمُوهُ بِحِجَارَةٍ، فَمَاتَ كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: أَنْ يَصْنَعُوا لَهُمْ أَهْدَابًا فِي أَذْيَالِ ثِيَابِهِمْ فِي أَجْيَالِهِمْ، وَيَجْعَلُوا عَلَى هُدْبِ ٱلذَّيْلِ عِصَابَةً مِنْ أَسْمَانْجُونِيٍّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","فَتَكُونُ لَكُمْ هُدْبًا، فَتَرَوْنَهَا وَتَذْكُرُونَ كُلَّ وَصَايَا ٱلرَّبِّ وَتَعْمَلُونَهَا، وَلَا تَطُوفُونَ وَرَاءَ قُلُوبِكُمْ وَأَعْيُنِكُمُ ٱلَّتِي أَنْتُمْ فَاسِقُونَ وَرَاءَهَا، ");
INSERT INTO arb_vd_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","لِكَيْ تَذْكُرُوا وَتَعْمَلُوا كُلَّ وَصَايَايَ، وَتَكُونُوا مُقَدَّسِينَ لِإِلَهِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","أَنَا ٱلرَّبُّ إِلَهُكُمُ ٱلَّذِي أَخْرَجَكُمْ مِنْ أَرْضِ مِصْرَ لِيَكُونَ لَكُمْ إِلَهًا. أَنَا ٱلرَّبُّ إِلَهُكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","وَأَخَذَ قُورَحُ بْنُ يِصْهَارَ بْنِ قَهَاتَ بْنِ لَاوِي، وَدَاثَانُ وَأَبِيرَامُ ٱبْنَا أَلِيآبَ، وَأُونُ بْنُ فَالَتَ، بَنُو رَأُوبَيْنَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","يُقَاوِمُونَ مُوسَى مَعَ أُنَاسٍ مِنْ بَنِي إِسْرَائِيلَ، مِئَتَيْنِ وَخَمْسِينَ رُؤَسَاءِ ٱلْجَمَاعَةِ مَدْعُوِّينَ لِلِٱجْتِمَاعِ ذَوِي ٱسْمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","فَٱجْتَمَعُوا عَلَى مُوسَى وَهَارُونَ وَقَالُوا لَهُمَا: «كَفَاكُمَا! إِنَّ كُلَّ ٱلْجَمَاعَةِ بِأَسْرِهَا مُقَدَّسَةٌ وَفِي وَسَطِهَا ٱلرَّبُّ. فَمَا بَالُكُمَا تَرْتَفِعَانِ عَلَى جَمَاعَةِ ٱلرَّبِّ؟». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","فَلَمَّا سَمِعَ مُوسَى سَقَطَ عَلَى وَجْهِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ثُمَّ كَلَّمَ قُورَحَ وَجَمِيعَ قَوْمِهِ قَائِلًا: «غَدًا يُعْلِنُ ٱلرَّبُّ مَنْ هُوَ لَهُ، وَمَنِ ٱلْمُقَدَّسُ حَتَّى يُقَرِّبَهُ إِلَيْهِ. فَٱلَّذِي يَخْتَارُهُ يُقَرِّبُهُ إِلَيْهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","اِفْعَلُوا هَذَا: خُذُوا لَكُمْ مَجَامِرَ. قُورَحُ وَكُلُّ جَمَاعَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","وَٱجْعَلُوا فِيهَا نَارًا، وَضَعُوا عَلَيْهَا بَخُورًا أَمَامَ ٱلرَّبِّ غَدًا. فَٱلرَّجُلُ ٱلَّذِي يَخْتَارُهُ ٱلرَّبُّ هُوَ ٱلْمُقَدَّسُ. كَفَاكُمْ يَا بَنِي لَاوِي!». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","وَقَالَ مُوسَى لِقُورَحَ: «ٱسْمَعُوا يَا بَنِي لَاوِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","أَقَلِيلٌ عَلَيْكُمْ أَنَّ إِلَهَ إِسْرَائِيلَ أَفْرَزَكُمْ مِنْ جَمَاعَةِ إِسْرَائِيلَ لِيُقَرِّبَكُمْ إِلَيْهِ لِكَيْ تَعْمَلُوا خِدْمَةَ مَسْكَنِ ٱلرَّبِّ، وَتَقِفُوا قُدَّامَ ٱلْجَمَاعَةِ لِخِدْمَتِهَا؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","فَقَرَّبَكَ وَجَمِيعَ إِخْوَتِكَ بَنِي لَاوِي مَعَكَ، وَتَطْلُبُونَ أَيْضًا كَهَنُوتًا! ");
INSERT INTO arb_vd_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","إِذَنْ أَنْتَ وَكُلُّ جَمَاعَتِكَ مُتَّفِقُونَ عَلَى ٱلرَّبِّ. وَأَمَّا هَارُونُ فَمَا هُوَ حَتَّى تَتَذَمَّرُوا عَلَيْهِ؟» ");
INSERT INTO arb_vd_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","فَأَرْسَلَ مُوسَى لِيَدْعُوَ دَاثَانَ وَأَبِيرَامَ ٱبْنَيْ أَلِيآبَ. فَقَالَا: «لَا نَصْعَدُ! ");
INSERT INTO arb_vd_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","أَقَلِيلٌ أَنَّكَ أَصْعَدْتَنَا مِنْ أَرْضٍ تَفِيضُ لَبَنًا وَعَسَلًا لِتُمِيتَنَا فِي ٱلْبَرِّيَّةِ حَتَّى تَتَرَأَسَ عَلَيْنَا تَرَؤُّسًا؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","كَذَلِكَ لَمْ تَأْتِ بِنَا إِلَى أَرْضٍ تَفِيضُ لَبَنًا وَعَسَلًا، وَلَا أَعْطَيْتَنَا نَصِيبَ حُقُولٍ وَكُرُومٍ. هَلْ تَقْلَعُ أَعْيُنَ هَؤُلَاءِ ٱلْقَوْمِ؟ لَا نَصْعَدُ!». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","فَٱغْتَاظَ مُوسَى جِدًّا وَقَالَ لِلرَّبِّ: «لَا تَلْتَفِتْ إِلَى تَقْدِمَتِهِمَا. حِمَارًا وَاحِدًا لَمْ آخُذْ مِنْهُمْ، وَلَا أَسَأْتُ إِلَى أَحَدٍ مِنْهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","وَقَالَ مُوسَى لِقُورَحَ: «كُنْ أَنْتَ وَكُلُّ جَمَاعَتِكَ أَمَامَ ٱلرَّبِّ، أَنْتَ وَهُمْ وَهَارُونُ غَدًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","وَخُذُوا كُلُّ وَاحِدٍ مِجْمَرَتَهُ، وَٱجْعَلُوا فِيهَا بَخُورًا، وَقَدِّمُوا أَمَامَ ٱلرَّبِّ كُلُّ وَاحِدٍ مِجْمَرَتَهُ. مِئَتَيْنِ وَخَمْسِينَ مِجْمَرَةً. وَأَنْتَ وَهَارُونُ كُلُّ وَاحِدٍ مِجْمَرَتَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","فَأَخَذُوا كُلُّ وَاحِدٍ مِجْمَرَتَهُ وَجَعَلُوا فِيهَا نَارًا وَوَضَعُوا عَلَيْهَا بَخُورًا، وَوَقَفُوا لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ مَعَ مُوسَى وَهَارُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","وَجَمَعَ عَلَيْهِمَا قُورَحُ كُلَّ ٱلْجَمَاعَةِ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ، فَتَرَاءَى مَجْدُ ٱلرَّبِّ لِكُلِّ ٱلْجَمَاعَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«ٱفْتَرِزَا مِنْ بَيْنِ هَذِهِ ٱلْجَمَاعَةِ فَإِنِّي أُفْنِيهِمْ فِي لَحْظَةٍ». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","فَخَرَّا عَلَى وَجْهَيْهِمَا وَقَالَا: «ٱللَّهُمَّ، إِلَهَ أَرْوَاحِ جَمِيعِ ٱلْبَشَرِ، هَلْ يُخْطِئُ رَجُلٌ وَاحِدٌ فَتَسْخَطَ عَلَى كُلِّ ٱلْجَمَاعَةِ؟» ");
INSERT INTO arb_vd_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","فَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«كَلِّمِ ٱلْجَمَاعَةَ قَائِلًا: ٱطْلَعُوا مِنْ حَوَالَيْ مَسْكَنِ قُورَحَ وَدَاثَانَ وَأَبِيرَامَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","فَقَامَ مُوسَى وَذَهَبَ إِلَى دَاثَانَ وَأَبِيرَامَ، وَذَهَبَ وَرَاءَهُ شُيُوخُ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","فَكَلَّمَ ٱلْجَمَاعَةَ قَائِلًا: «ٱعْتَزِلُوا عَنْ خِيَامِ هَؤُلَاءِ ٱلْقَوْمِ ٱلْبُغَاةِ، وَلَا تَمَسُّوا شَيْئًا مِمَّا لَهُمْ لِئَلَّا تَهْلَكُوا بِجَمِيعِ خَطَايَاهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","فَطَلَعُوا مِنْ حَوَالَيْ مَسْكَنِ قُورَحَ وَدَاثَانَ وَأَبِيرَامَ، وَخَرَجَ دَاثَانُ وَأَبِيرَامُ وَوَقَفَا فِي بَابِ خَيْمَتَيْهِمَا مَعَ نِسَائِهِمَا وَبَنِيهِمَا وَأَطْفَالِهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","فَقَالَ مُوسَى: «بِهَذَا تَعْلَمُونَ أَنَّ ٱلرَّبَّ قَدْ أَرْسَلَنِي لِأَعْمَلَ كُلَّ هَذِهِ ٱلْأَعْمَالِ، وَأَنَّهَا لَيْسَتْ مِنْ نَفْسِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","إِنْ مَاتَ هَؤُلَاءِ كَمَوْتِ كُلِّ إِنْسَانٍ، وَأَصَابَتْهُمْ مَصِيبَةُ كُلِّ إِنْسَانٍ، فَلَيْسَ ٱلرَّبُّ قَدْ أَرْسَلَنِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","وَلَكِنْ إِنِ ٱبْتَدَعَ ٱلرَّبُّ بِدْعَةً وَفَتَحَتِ ٱلْأَرْضُ فَاهَا وَٱبْتَلَعَتْهُمْ وَكُلَّ مَا لَهُمْ، فَهَبَطُوا أَحْيَاءً إِلَى ٱلْهَاوِيَةِ، تَعْلَمُونَ أَنَّ هَؤُلَاءِ ٱلْقَوْمَ قَدِ ٱزْدَرَوْا بِٱلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","فَلَمَّا فَرَغَ مِنَ ٱلتَّكَلُّمِ بِكُلِّ هَذَا ٱلْكَلَامِ، ٱنْشَقَّتِ ٱلْأَرْضُ ٱلَّتِي تَحْتَهُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","وَفَتَحَتِ ٱلْأَرْضُ فَاهَا وَٱبْتَلَعَتْهُمْ وَبُيُوتَهُمْ وَكُلَّ مَنْ كَانَ لِقُورَحَ مَعَ كُلِّ ٱلْأَمْوَالِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","فَنَزَلُوا هُمْ وَكُلُّ مَا كَانَ لَهُمْ أَحْيَاءً إِلَى ٱلْهَاوِيَةِ، وَٱنْطَبَقَتْ عَلَيْهِمِ ٱلْأَرْضُ، فَبَادُوا مِنْ بَيْنِ ٱلْجَمَاعَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","وَكُلُّ إِسْرَائِيلَ ٱلَّذِينَ حَوْلَهُمْ هَرَبُوا مِنْ صَوْتِهِمْ، لِأَنَّهُمْ قَالُوا: «لَعَلَّ ٱلْأَرْضَ تَبْتَلِعُنَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","وَخَرَجَتْ نَارٌ مِنْ عِنْدِ ٱلرَّبِّ وَأَكَلَتِ ٱلْمِئَتَيْنِ وَٱلْخَمْسِينَ رَجُلًا ٱلَّذِينَ قَرَّبُوا ٱلْبَخُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ثُمَّ كَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«قُلْ لِأَلِعَازَارَ بْنِ هَارُونَ ٱلْكَاهِنِ أَنْ يَرْفَعَ ٱلْمَجَامِرَ مِنَ ٱلْحَرِيقِ، وَٱذْرِ ٱلنَّارَ هُنَاكَ فَإِنَّهُنَّ قَدْ تَقَدَّسْنَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","مَجَامِرَ هَؤُلَاءِ ٱلْمُخْطِئِينَ ضِدَّ نُفُوسِهِمْ، فَلْيَعْمَلُوهَا صَفَائِحَ مَطْرُوقَةً غِشَاءً لِلْمَذْبَحِ، لِأَنَّهُمْ قَدْ قَدَّمُوهَا أَمَامَ ٱلرَّبِّ فَتَقَدَّسَتْ. فَتَكُونُ عَلَامَةً لِبَنِي إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","فَأَخَذَ أَلِعَازَارُ ٱلْكَاهِنُ مَجَامِرَ ٱلنُّحَاسِ ٱلَّتِي قَدَّمَهَا ٱلْمُحْتَرِقُونَ، وَطَرَقُوهَا غِشَاءً لِلْمَذْبَحِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","تَذْكَارًا لِبَنِي إِسْرَائِيلَ، لِكَيْ لَا يَقْتَرِبَ رَجُلٌ أَجْنَبِيٌّ لَيْسَ مِنْ نَسْلِ هَارُونَ لِيُبَخِّرَ بَخُورًا أَمَامَ ٱلرَّبِّ، فَيَكُونَ مِثْلَ قُورَحَ وَجَمَاعَتِهِ، كَمَا كَلَّمَهُ ٱلرَّبُّ عَنْ يَدِ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","فَتَذَمَّرَ كُلُّ جَمَاعَةِ بَنِي إِسْرَائِيلَ فِي ٱلْغَدِ عَلَى مُوسَى وَهَارُونَ قَائِلِينَ: «أَنْتُمَا قَدْ قَتَلْتُمَا شَعْبَ ٱلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","وَلَمَّا ٱجْتَمَعَتِ ٱلْجَمَاعَةُ عَلَى مُوسَى وَهَارُونَ ٱنْصَرَفَا إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ وَإِذَا هِيَ قَدْ غَطَّتْهَا ٱلسَّحَابَةُ وَتَرَاءَى مَجْدُ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","فَجَاءَ مُوسَى وَهَارُونُ إِلَى قُدَّامِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","فَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«اِطْلَعَا مِنْ وَسَطِ هَذِهِ ٱلْجَمَاعَةِ، فَإِنِّي أُفْنِيهِمْ بِلَحْظَةٍ». فَخَرَّا عَلَى وَجْهَيْهِمَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ثُمَّ قَالَ مُوسَى لِهَارُونَ: «خُذِ ٱلْمِجْمَرَةَ وَٱجْعَلْ فِيهَا نَارًا مِنْ عَلَى ٱلْمَذْبَحِ، وَضَعْ بَخُورًا، وَٱذْهَبْ بِهَا مُسْرِعًا إِلَى ٱلْجَمَاعَةِ وَكَفِّرْ عَنْهُمْ، لِأَنَّ ٱلسَّخَطَ قَدْ خَرَجَ مِنْ قِبَلِ ٱلرَّبِّ. قَدِ ٱبْتَدَأَ ٱلْوَبَأُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","فَأَخَذَ هَارُونُ كَمَا قَالَ مُوسَى، وَرَكَضَ إِلَى وَسَطِ ٱلْجَمَاعَةِ، وَإِذَا ٱلْوَبَأُ قَدِ ٱبْتَدَأَ فِي ٱلشَّعْبِ. فَوَضَعَ ٱلْبَخُورَ وَكَفَّرَ عَنِ ٱلشَّعْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","وَوَقَفَ بَيْنَ ٱلْمَوْتَى وَٱلْأَحْيَاءِ فَٱمْتَنَعَ ٱلْوَبَأُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","فَكَانَ ٱلَّذِينَ مَاتُوا بِٱلْوَبَإِ أَرْبَعَةَ عَشَرَ أَلْفًا وَسَبْعَ مِئَةٍ، عَدَا ٱلَّذِينَ مَاتُوا بِسَبَبِ قُورَحَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ثُمَّ رَجَعَ هَارُونُ إِلَى مُوسَى إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ وَٱلْوَبَأُ قَدِ ٱمْتَنَعَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«كَلِّمْ بَنِي إِسْرَائِيلَ وَخُذْ مِنْهُمْ عَصًا عَصًا لِكُلِّ بَيْتِ أَبٍ مِنْ جَمِيعِ رُؤَسَائِهِمْ حَسَبَ بُيُوتِ آبَائِهِمِ. ٱثْنَتَيْ عَشَرَةَ عَصًا. وَٱسْمُ كُلِّ وَاحِدٍ تَكْتُبُهُ عَلَى عَصَاهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","وَٱسْمُ هَارُونَ تَكْتُبُهُ عَلَى عَصَا لَاوِي، لِأَنَّ لِرَأْسِ بَيْتِ آبَائِهِمْ عَصًا وَاحِدَةً. ");
INSERT INTO arb_vd_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","وَضَعْهَا فِي خَيْمَةِ ٱلِٱجْتِمَاعِ أَمَامَ ٱلشَّهَادَةِ حَيْثُ أَجْتَمِعُ بِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","فَٱلرَّجُلُ ٱلَّذِي أَخْتَارُهُ تُفْرِخُ عَصَاهُ، فَأُسَكِّنُ عَنِّي تَذَمُّرَاتِ بَنِي إِسْرَائِيلَ ٱلَّتِي يَتَذَمَّرُونَهَا عَلَيْكُمَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","فَكَلَّمَ مُوسَى بَنِي إِسْرَائِيلَ، فَأَعْطَاهُ جَمِيعُ رُؤَسَائِهِمْ عَصًا عَصًا لِكُلِّ رَئِيسٍ حَسَبَ بُيُوتِ آبَائِهِمِ. ٱثْنَتَيْ عَشَرَةَ عَصًا. وَعَصَا هَارُونَ بَيْنَ عِصِيِّهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","فَوَضَعَ مُوسَى ٱلْعِصِيَّ أَمَامَ ٱلرَّبِّ فِي خَيْمَةِ ٱلشَّهَادَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","وَفِي ٱلْغَدِ دَخَلَ مُوسَى إِلَى خَيْمَةِ ٱلشَّهَادَةِ، وَإِذَا عَصَا هَارُونَ لِبَيْتِ لَاوِي قَدْ أَفْرَخَتْ. أَخْرَجَتْ فُرُوخًا وَأَزْهَرَتْ زَهْرًا وَأَنْضَجَتْ لَوْزًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","فَأَخْرَجَ مُوسَى جَمِيعَ ٱلْعِصِيِّ مِنْ أَمَامِ ٱلرَّبِّ إِلَى جَمِيعِ بَنِي إِسْرَائِيلَ، فَنَظَرُوا وَأَخَذَ كُلُّ وَاحِدٍ عَصَاهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","وَقَالَ ٱلرَّبُّ لِمُوسَى: «رُدَّ عَصَا هَارُونَ إِلَى أَمَامِ ٱلشَّهَادَةِ لِأَجْلِ ٱلْحِفْظِ، عَلَامَةً لِبَنِي ٱلتَّمَرُّدِ، فَتَكُفَّ تَذَمُّرَاتُهُمْ عَنِّي لِكَيْ لَا يَمُوتُوا». ");
INSERT INTO arb_vd_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","فَفَعَلَ مُوسَى كَمَا أَمَرَهُ ٱلرَّبُّ. كَذَلِكَ فَعَلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","فَكَلَّمَ بَنُو إِسْرَائِيلَ مُوسَى قَائِلِينَ: «إِنَّنَا فَنِينَا وَهَلَكْنَا. قَدْ هَلَكْنَا جَمِيعًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","كُلُّ مَنِ ٱقْتَرَبَ إِلَى مَسْكَنِ ٱلرَّبِّ يَمُوتُ. أَمَا فَنِيْنَا تَمَامًا؟». ");
INSERT INTO arb_vd_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","وَقَالَ ٱلرَّبُّ لِهَارُونَ: «أَنْتَ وَبَنُوكَ وَبَيْتُ أَبِيكَ مَعَكَ تَحْمِلُونَ ذَنْبَ ٱلْمَقْدِسِ، وَأَنْتَ وَبَنُوكَ مَعَكَ تَحْمِلُونَ ذَنْبَ كَهَنُوتِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","وَأَيْضًا إِخْوَتُكَ سِبْطُ لَاوِي، سِبْطُ أَبِيكَ، قَرِّبْهُمْ مَعَكَ فَيَقْتَرِنُوا بِكَ وَيُوازِرُوكَ، وَأَنْتَ وَبَنُوكَ قُدَّامَ خَيْمَةِ ٱلشَّهَادَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","فَيَحْفَظُونَ حِرَاسَتَكَ وَحِرَاسَةَ ٱلْخَيْمَةِ كُلِّهَا. وَلَكِنْ إِلَى أَمْتِعَةِ ٱلْقُدْسِ وَإِلَى ٱلْمَذْبَحِ لَا يَقْتَرِبُونَ، لِئَلَّا يَمُوتُوا هُمْ وَأَنْتُمْ جَمِيعًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","يَقْتَرِنُونَ بِكَ وَيَحْفَظُونَ حِرَاسَةَ خَيْمَةِ ٱلِٱجْتِمَاعِ مَعَ كُلِّ خِدْمَةِ ٱلْخَيْمَةِ. وَٱلْأَجْنَبِيُّ لَا يَقْتَرِبْ إِلَيْكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","بَلْ تَحْفَظُونَ أَنْتُمْ حِرَاسَةَ ٱلْقُدْسِ وَحِرَاسَةَ ٱلْمَذْبَحِ، لِكَيْ لَا يَكُونَ أَيْضًا سَخَطٌ عَلَى بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","هَأَنَذَا قَدْ أَخَذْتُ إِخْوَتَكُمُ ٱللَّاوِيِّينَ مِنْ بَيْنِ بَنِي إِسْرَائِيلَ عَطِيَّةً لَكُمْ مُعْطَيْنَ لِلرَّبِّ، لِيَخْدِمُوا خِدْمَةَ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","وَأَمَّا أَنْتَ وَبَنُوكَ مَعَكَ فَتَحْفَظُونَ كَهَنُوتَكُمْ مَعَ مَا لِلْمَذْبَحِ وَمَا هُوَ دَاخِلَ ٱلْحِجَابِ، وَتَخْدِمُونَ خِدْمَةً. عَطِيَّةً أَعْطَيْتُ كَهَنُوتَكُمْ. وَٱلْأَجْنَبِيُّ ٱلَّذِي يَقْتَرِبُ يُقْتَلُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","وَقَالَ ٱلرَّبُّ لِهَارُونَ: «وَهَأَنَذَا قَدْ أَعْطَيْتُكَ حِرَاسَةَ رَفَائِعِي، مَعَ جَمِيعِ أَقْدَاسِ بَنِي إِسْرَائِيلَ لَكَ أَعْطَيْتُهَا، حَقَّ ٱلْمَسْحَةِ وَلِبَنِيكَ فَرِيضَةً دَهْرِيَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","هَذَا يَكُونُ لَكَ مِنْ قُدْسِ ٱلْأَقْدَاسِ مِنَ ٱلنَّارِ، كُلُّ قَرَابِينِهِمْ مَعَ كُلِّ تَقْدِمَاتِهِمْ وَكُلِّ ذَبَائِحِ خَطَايَاهُمْ وَكُلِّ ذَبَائِحِ آثَامِهِمْ ٱلَّتِي يَرُدُّونَهَا لِي. قُدْسُ أَقْدَاسٍ هِيَ لَكَ وَلِبَنِيكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","فِي قُدْسِ ٱلْأَقْدَاسِ تَأْكُلُهَا. كُلُّ ذَكَرٍ يَأْكُلُهَا. قُدْسًا تَكُونُ لَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","وَهَذِهِ لَكَ: ٱلرَّفِيعَةُ مِنْ عَطَايَاهُمْ مَعَ كُلِّ تَرْدِيدَاتِ بَنِي إِسْرَائِيلَ. لَكَ أَعْطَيْتُهَا وَلِبَنِيكَ وَبَنَاتِكَ مَعَكَ فَرِيضَةً دَهْرِيَّةً. كُلُّ طَاهِرٍ فِي بَيْتِكَ يَأْكُلُ مِنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","كُلُّ دَسَمِ ٱلزَّيْتِ وَكُلُّ دَسَمِ ٱلْمِسْطَارِ وَٱلْحِنْطَةِ، أَبْكَارُهُنَّ ٱلَّتِي يُعْطُونَهَا لِلرَّبِّ، لَكَ أَعْطَيْتُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","أَبْكَارُ كُلِّ مَا فِي أَرْضِهِمِ ٱلَّتِي يُقَدِّمُونَهَا لِلرَّبِّ لَكَ تَكُونُ. كُلُّ طَاهِرٍ فِي بَيْتِكَ يَأْكُلُهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","كُلُّ مُحَرَّمٍ فِي إِسْرَائِيلَ يَكُونُ لَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","كُلُّ فَاتِحِ رَحِمٍ مِنْ كُلِّ جَسَدٍ يُقَدِّمُونَهُ لِلرَّبِّ، مِنَ ٱلنَّاسِ وَمِنَ ٱلْبَهَائِمِ، يَكُونُ لَكَ. غَيْرَ أَنَّكَ تَقْبَلُ فِدَاءَ بِكْرِ ٱلْإِنْسَانِ. وَبِكْرُ ٱلْبَهِيمَةِ ٱلنَّجِسَةِ تَقْبَلُ فِدَاءَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","وَفِدَاؤُهُ مِنِ ٱبْنِ شَهْرٍ تَقْبَلُهُ حَسَبَ تَقْوِيمِكَ فِضَّةً، خَمْسَةَ شَوَاقِلَ عَلَى شَاقِلِ ٱلْقُدْسِ. هُوَ عِشْرُونَ جِيرَةً. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","لَكِنْ بِكْرُ ٱلْبَقَرِ أَوْ بِكْرُ ٱلضَّأْنِ أَوْ بِكْرُ ٱلْمَعْزِ لَا تَقْبَلْ فِدَاءَهُ. إِنَّهُ قُدْسٌ. بَلْ تَرُشُّ دَمَهُ عَلَى ٱلْمَذْبَحِ، وَتُوقِدُ شَحْمَهُ وَقُودًا رَائِحَةَ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","وَلَحْمُهُ يَكُونُ لَكَ، كَصَدْرِ ٱلتَّرْدِيدِ وَٱلسَّاقِ ٱلْيُمْنَى يَكُونُ لَكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","جَمِيعُ رَفَائِعِ ٱلْأَقْدَاسِ ٱلَّتِي يَرْفَعُهَا بَنُو إِسْرَائِيلَ لِلرَّبِّ أَعْطَيْتُهَا لَكَ وَلِبَنِيكَ وَبَنَاتِكَ مَعَكَ حَقًّا دَهْرِيًّا. مِيثَاقَ مِلْحٍ دَهْرِيًّا أَمَامَ ٱلرَّبِّ لَكَ وَلِزَرْعِكَ مَعَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","وَقَالَ ٱلرَّبُّ لِهَارُونَ: «لَا تَنَالُ نَصِيبًا فِي أَرْضِهِمْ، وَلَا يَكُونُ لَكَ قِسْمٌ فِي وَسَطِهِمْ. أَنَا قِسْمُكَ وَنَصِيبُكَ فِي وَسَطِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","«وَأَمَّا بَنُو لَاوِي، فَإِنِّي قَدْ أَعْطَيْتُهُمْ كُلَّ عُشْرٍ فِي إِسْرَائِيلَ مِيرَاثًا عِوَضَ خِدْمَتَهِمْ ٱلَّتِي يَخْدِمُونَهَا، خِدْمَةِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","فَلَا يَقْتَرِبُ أَيْضًا بَنُو إِسْرَائِيلَ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ لِيَحْمِلُوا خَطِيَّةً لِلْمَوْتِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","بَلِ ٱللَّاوِيُّونَ يَخْدِمُونَ خِدْمَةَ خَيْمَةِ ٱلِٱجْتِمَاعِ، وَهُمْ يَحْمِلُونَ ذَنْبَهُمْ فَرِيضَةً دَهْرِيَّةً فِي أَجْيَالِكُمْ. وَفِي وَسَطِ إِسْرَائِيلَ لَا يَنَالُونَ نَصِيبًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","إِنَّ عُشُورَ بَنِي إِسْرَائِيلَ ٱلَّتِي يَرْفَعُونَهَا لِلرَّبِّ رَفِيعَةً قَدْ أَعْطَيْتُهَا لِلَّاوِيِّينَ نَصِيبًا. لِذَلِكَ قُلْتُ لَهُمْ: فِي وَسَطِ بَنِي إِسْرَائِيلَ لَا يَنَالُونَ نَصِيبًا». ");
INSERT INTO arb_vd_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«وَٱللَّاوِيُّونَ تُكَلِّمُهُمْ وَتَقُولُ لَهُمْ: مَتَى أَخَذْتُمْ مِنْ بَنِي إِسْرَائِيلَ ٱلْعُشْرَ ٱلَّذِي أَعْطَيْتُكُمْ إِيَّاهُ مِنْ عِنْدِهِمْ نَصِيبًا لَكُمْ، تَرْفَعُونَ مِنْهُ رَفِيعَةَ ٱلرَّبِّ: عُشْرًا مِنَ ٱلْعُشْرِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","فَيُحْسَبُ لَكُمْ. إِنَّهُ رَفِيعَتُكُمْ كَٱلْحِنْطَةِ مِنَ ٱلْبَيْدَرِ، وَكَالْمِلْءِ مِنَ ٱلْمِعْصَرَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","فَهَكَذَا تَرْفَعُونَ أَنْتُمْ أَيْضًا رَفِيعَةَ ٱلرَّبِّ مِنْ جَمِيعِ عُشُورِكُمُ ٱلَّتِي تَأْخُذُونَ مِنْ بَنِي إِسْرَائِيلَ. تُعْطُونَ مِنْهَا رَفِيعَةَ ٱلرَّبِّ لِهَارُونَ ٱلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","مِنْ جَمِيعِ عَطَايَاكُمْ تَرْفَعُونَ كُلَّ رَفِيعَةِ ٱلرَّبِّ مِنَ ٱلْكُلِّ، دَسَمَهُ ٱلْمُقَدَّسَ مِنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","وَتَقُولُ لَهُمْ: حِينَ تَرْفَعُونَ دَسَمَهُ مِنْهُ يُحْسَبُ لِلَّاوِيِّينَ كَمَحْصُولِ ٱلْبَيْدَرِ وَكَمَحْصُولِ ٱلْمِعْصَرَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","وَتَأْكُلُونَهُ فِي كُلِّ مَكَانٍ أَنْتُمْ وَبُيُوتُكُمْ، لِأَنَّهُ أُجْرَةٌ لَكُمْ عِوَضَ خِدْمَتِكُمْ فِي خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","وَلَا تَتَحَمَّلُونَ بِسَبَبِهِ خَطِيَّةً إِذَا رَفَعْتُمْ دَسَمَهُ مِنْهُ. وَأَمَّا أَقْدَاسُ بَنِي إِسْرَائِيلَ فَلَا تُدَنِّسُوهَا لِئَلَّا تَمُوتُوا». ");
INSERT INTO arb_vd_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«هَذِهِ فَرِيضَةُ ٱلشَّرِيعَةِ ٱلَّتِي أَمَرَ بِهَا ٱلرَّبُّ قَائِلًا: كَلِّمْ بَنِي إِسْرَائِيلَ أَنْ يَأْخُذُوا إِلَيْكَ بَقَرَةً حَمْرَاءَ صَحِيحَةً لَا عَيْبَ فِيهَا، وَلَمْ يَعْلُ عَلَيْهَا نِيرٌ، ");
INSERT INTO arb_vd_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","فَتُعْطُونَهَا لِأَلِعَازَارَ ٱلْكَاهِنِ، فَتُخْرَجُ إِلَى خَارِجِ ٱلْمَحَلَّةِ وَتُذْبَحُ قُدَّامَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","وَيَأْخُذُ أَلِعَازَارُ ٱلْكَاهِنُ مِنْ دَمِهَا بِإِصْبِعِهِ وَيَنْضِحُ مِنْ دَمِهَا إِلَى جِهَةِ وَجْهِ خَيْمَةِ ٱلِٱجْتِمَاعِ سَبْعَ مَرَّاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","وَتُحْرَقُ ٱلْبَقَرَةُ أَمَامَ عَيْنَيْهِ. يُحْرَقُ جِلْدُهَا وَلَحْمُهَا وَدَمُهَا مَعَ فَرْثِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","وَيَأْخُذُ ٱلْكَاهِنُ خَشَبَ أَرْزٍ وَزُوفَا وَقِرْمِزًا وَيَطْرَحُهُنَّ فِي وَسَطِ حَرِيقِ ٱلْبَقَرَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ثُمَّ يَغْسِلُ ٱلْكَاهِنُ ثِيَابَهُ وَيَرْحَضُ جَسَدَهُ بِمَاءٍ، وَبَعْدَ ذَلِكَ يَدْخُلُ ٱلْمَحَلَّةَ. وَيَكُونُ ٱلْكَاهِنُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","وَٱلَّذِي أَحْرَقَهَا يَغْسِلُ ثِيَابَهُ بِمَاءٍ وَيَرْحَضُ جَسَدَهُ بِمَاءٍ وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","وَيَجْمَعُ رَجُلٌ طَاهِرٌ رَمَادَ ٱلْبَقَرَةِ وَيَضَعُهُ خَارِجَ ٱلْمَحَلَّةِ فِي مَكَانٍ طَاهِرٍ، فَتَكُونُ لِجَمَاعَةِ بَنِي إِسْرَائِيلَ فِي حِفْظٍ، مَاءَ نَجَاسَةٍ. إِنَّهَا ذَبِيحَةُ خَطِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","وَٱلَّذِي جَمَعَ رَمَادَ ٱلْبَقَرَةِ يَغْسِلُ ثِيَابَهُ وَيَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. فَتَكُونُ لِبَنِي إِسْرَائِيلَ وَلِلْغَرِيبِ ٱلنَّازِلِ فِي وَسَطِهِمْ فَرِيضَةً دَهْرِيَّةً. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«مَنْ مَسَّ مَيْتًا مَيْتَةَ إِنْسَانٍ مَّا، يَكُونُ نَجِسًا سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","يَتَطَهَّرُ بِهِ فِي ٱلْيَوْمِ ٱلثَّالِثِ، وَفِي ٱلْيَوْمِ ٱلسَّابِعِ يَكُونُ طَاهِرًا. وَإِنْ لَمْ يَتَطَهَّرْ فِي ٱلْيَوْمِ ٱلثَّالِثِ فَفِي ٱلْيَوْمِ ٱلسَّابِعِ لَا يَكُونُ طَاهِرًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","كُلُّ مَنْ مَسَّ مَيْتًا مَيْتَةَ إِنْسَانٍ قَدْ مَاتَ وَلَمْ يَتَطَهَّرْ، يُنَجِّسُ مَسْكَنَ ٱلرَّبِّ. فَتُقْطَعُ تِلْكَ ٱلنَّفْسُ مِنْ إِسْرَائِيلَ. لِأَنَّ مَاءَ ٱلنَّجَاسَةِ لَمْ يُرَشَّ عَلَيْهَا تَكُونُ نَجِسَةً. نَجَاسَتُهَا لَمْ تَزَلْ فِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«هَذِهِ هِيَ ٱلشَّرِيعَةُ: إِذَا مَاتَ إِنْسَانٌ فِي خَيْمَةٍ، فَكُلُّ مَنْ دَخَلَ ٱلْخَيْمَةَ، وَكُلُّ مَنْ كَانَ فِي ٱلْخَيْمَةِ يَكُونُ نَجِسًا سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","وَكُلُّ إِنَاءٍ مَفْتُوحٍ لَيْسَ عَلَيْهِ سِدَادٌ بِعِصَابَةٍ فَإِنَّهُ نَجِسٌ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","وَكُلُّ مَنْ مَسَّ عَلَى وَجْهِ ٱلصَّحْرَاءِ قَتِيلًا بِٱلسَّيْفِ أَوْ مَيْتًا أَوْ عَظْمَ إِنْسَانٍ أَوْ قَبْرًا، يَكُونُ نَجِسًا سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","فَيَأْخُذُونَ لِلنَّجِسِ مِنْ غُبَارِ حَرِيقِ ذَبِيحَةِ ٱلْخَطِيَّةِ وَيَجْعَلُ عَلَيْهِ مَاءً حَيًّا فِي إِنَاءٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","وَيَأْخُذُ رَجُلٌ طَاهِرٌ زُوفَا وَيَغْمِسُهَا فِي ٱلْمَاءِ وَيَنْضِحُهُ عَلَى ٱلْخَيْمَةِ، وَعَلَى جَمِيعِ ٱلْأَمْتِعَةِ وَعَلَى ٱلْأَنْفُسِ ٱلَّذِينَ كَانُوا هُنَاكَ، وَعَلَى ٱلَّذِي مَسَّ ٱلْعَظْمَ أَوِ ٱلْقَتِيلَ أَوِ ٱلْمَيْتَ أَوِ ٱلْقَبْرَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","يَنْضِحُ ٱلطَّاهِرُ عَلَى ٱلنَّجِسِ فِي ٱلْيَوْمِ ٱلثَّالِثِ وَٱلْيَوْمِ ٱلسَّابِعِ. وَيُطَهِّرُهُ فِي ٱلْيَوْمِ ٱلسَّابِعِ، فَيَغْسِلُ ثِيَابَهُ وَيَرْحَضُ بِمَاءٍ، فَيَكُونُ طَاهِرًا فِي ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","وَأَمَّا ٱلْإِنْسَانُ ٱلَّذِي يَتَنَجَّسُ وَلَا يَتَطَهَّرُ، فَتُبَادُ تِلْكَ ٱلنَّفْسُ مِنْ بَيْنِ ٱلْجَمَاعَةِ لِأَنَّهُ نَجَّسَ مَقْدِسَ ٱلرَّبِّ. مَاءُ ٱلنَّجَاسَةِ لَمْ يُرَشَّ عَلَيْهِ. إِنَّهُ نَجِسٌ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","فَتَكُونُ لَهُمْ فَرِيضَةً دَهْرِيَّةً. وَٱلَّذِي رَشَّ مَاءَ ٱلنَّجَاسَةِ يَغْسِلُ ثِيَابَهُ، وَٱلَّذِي مَسَّ مَاءَ ٱلنَّجَاسَةِ يَكُونُ نَجِسًا إِلَى ٱلْمَسَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","وَكُلُّ مَا مَسَّهُ ٱلنَّجِسُ يَتَنَجَّسُ، وَٱلنَّفْسُ ٱلَّتِي تَمَسُّ تَكُونُ نَجِسَةً إِلَى ٱلْمَسَاءِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","وَأَتَى بَنُو إِسْرَائِيلَ، ٱلْجَمَاعَةُ كُلُّهَا، إِلَى بَرِّيَّةِ صِينَ فِي ٱلشَّهْرِ ٱلْأَوَّلِ. وَأَقَامَ ٱلشَّعْبُ فِي قَادَشَ. وَمَاتَتْ هُنَاكَ مَرْيَمُ وَدُفِنَتْ هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","وَلَمْ يَكُنْ مَاءٌ لِلْجَمَاعَةِ فَٱجْتَمَعُوا عَلَى مُوسَى وَهَارُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","وَخَاصَمَ ٱلشَّعْبُ مُوسَى وَكَلَّمُوهُ قَائِلِينَ: «لَيْتَنَا فَنِينَا فَنَاءَ إِخْوَتِنَا أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","لِمَاذَا أَتَيْتُمَا بِجَمَاعَةِ ٱلرَّبِّ إِلَى هَذِهِ ٱلْبَرِّيَّةِ لِكَيْ نَمُوتَ فِيهَا نَحْنُ وَمَوَاشِينَا؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","وَلِمَاذَا أَصْعَدْتُمَانَا مِنْ مِصْرَ لِتَأْتِيَا بِنَا إِلَى هَذَا ٱلْمَكَانِ ٱلرَّدِيءِ؟ لَيْسَ هُوَ مَكَانَ زَرْعٍ وَتِينٍ وَكَرْمٍ وَرُمَّانٍ، وَلَا فِيهِ مَاءٌ لِلشُّرْبِ!». ");
INSERT INTO arb_vd_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","فَأَتَى مُوسَى وَهَارُونُ مِنْ أَمَامِ ٱلْجَمَاعَةِ إِلَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ وَسَقَطَا عَلَى وَجْهَيْهِمَا، فَتَرَاءَى لَهُمَا مَجْدُ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«خُذِ ٱلْعَصَا وَٱجْمَعِ ٱلْجَمَاعَةَ أَنْتَ وَهَارُونُ أَخُوكَ، وَكَلِّمَا ٱلصَّخْرَةَ أَمَامَ أَعْيُنِهِمْ أَنْ تُعْطِيَ مَاءَهَا، فَتُخْرِجُ لَهُمْ مَاءً مِنَ ٱلصَّخْرَةِ وَتَسْقِي ٱلْجَمَاعَةَ وَمَوَاشِيَهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","فَأَخَذَ مُوسَى ٱلْعَصَا مِنْ أَمَامِ ٱلرَّبِّ كَمَا أَمَرَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","وَجَمَعَ مُوسَى وَهَارُونُ ٱلْجُمْهُورَ أَمَامَ ٱلصَّخْرَةِ، فَقَالَ لَهُمُ: «ٱسْمَعُوا أَيُّهَا ٱلْمَرَدَةُ، أَمِنْ هَذِهِ ٱلصَّخْرَةِ نُخْرِجُ لَكُمْ مَاءً؟». ");
INSERT INTO arb_vd_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","وَرَفَعَ مُوسَى يَدَهُ وَضَرَبَ ٱلصَّخْرَةَ بِعَصَاهُ مَرَّتَيْنِ، فَخَرَجَ مَاءٌ غَزِيرٌ، فَشَرِبَتِ ٱلْجَمَاعَةُ وَمَوَاشِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","فَقَالَ ٱلرَّبُّ لِمُوسَى وَهَارُونَ: «مِنْ أَجْلِ أَنَّكُمَا لَمْ تُؤْمِنَا بِي حَتَّى تُقَدِّسَانِي أَمَامَ أَعْيُنِ بَنِي إِسْرَائِيلَ، لِذَلِكَ لَا تُدْخِلَانِ هَذِهِ ٱلْجَمَاعَةَ إِلَى ٱلْأَرْضِ ٱلَّتِي أَعْطَيْتُهُمْ إِيَّاهَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","هَذَا مَاءُ مَرِيبَةَ، حَيْثُ خَاصَمَ بَنُو إِسْرَائِيلَ ٱلرَّبَّ، فَتَقَدَّسَ فِيهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","وَأَرْسَلَ مُوسَى رُسُلًا مِنْ قَادَشَ إِلَى مَلِكِ أَدُومَ: «هَكَذَا يَقُولُ أَخُوكَ إِسْرَائِيلُ: قَدْ عَرَفْتَ كُلَّ ٱلْمَشَقَّةِ ٱلَّتِي أَصَابَتْنَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","إِنَّ آبَاءَنَا ٱنْحَدَرُوا إِلَى مِصْرَ، وَأَقَمْنَا فِي مِصْرَ أَيَّامًا كَثِيرَةً وَأَسَاءَ ٱلْمِصْرِيُّونَ إِلَيْنَا وَإِلَى آبَائِنَا، ");
INSERT INTO arb_vd_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","فَصَرَخْنَا إِلَى ٱلرَّبِّ فَسَمِعَ صَوْتَنَا، وَأَرْسَلَ مَلَاكًا وَأَخْرَجَنَا مِنْ مِصْرَ. وَهَا نَحْنُ فِي قَادَشَ، مَدِينَةٍ فِي طَرَفِ تُخُومِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","دَعْنَا نَمُرَّ فِي أَرْضِكَ. لَا نَمُرُّ فِي حَقْلٍ وَلَا فِي كَرْمٍ، وَلَا نَشْرَبُ مَاءَ بِئْرٍ. فِي طَرِيقِ ٱلْمَلِكِ نَمْشِي، لَا نَمِيلُ يَمِينًا وَلَا يَسَارًا حَتَّى نَتَجَاوَزَ تُخُومَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","فَقَالَ لَهُ أَدُومُ: «لَا تَمُرُّ بِي لِئَلَّا أَخْرُجَ لِلِقَائِكَ بِٱلسَّيْفِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","فَقَالَ لَهُ بَنُو إِسْرَائِيلَ: «فِي ٱلسِّكَّةِ نَصْعَدُ، وَإِذَا شَرِبْنَا أَنَا وَمَوَاشِيَّ مِنْ مَائِكَ أَدْفَعُ ثَمَنَهُ. لَا شَيْءَ. أَمُرُّ بِرِجْلَيَّ فَقَطْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","فَقَالَ: «لَا تَمُرُّ». وَخَرَجَ أَدُومُ لِلِقَائِهِ بِشَعْبٍ غَفِيرٍ وَبِيَدٍ شَدِيدَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","وَأَبَى أَدُومُ أَنْ يَسْمَحَ لِإِسْرَائِيلَ بِٱلْمُرُورِ فِي تُخُومِهِ، فَتَحَوَّلَ إِسْرَائِيلُ عَنْهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","فَٱرْتَحَلَ بَنُو إِسْرَائِيلَ، ٱلْجَمَاعَةُ كُلُّهَا، مِنْ قَادَشَ وَأَتَوْا إِلَى جَبَلِ هُورٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","وَكَلَّمَ ٱلرَّبُّ مُوسَى وَهَارُونَ فِي جَبَلِ هُورٍ عَلَى تُخُمِ أَرْضِ أَدُومَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«يُضَمُّ هَارُونُ إِلَى قَوْمِهِ لِأَنَّهُ لَا يَدْخُلُ ٱلْأَرْضَ ٱلَّتِي أَعْطَيْتُ لِبَنِي إِسْرَائِيلَ، لِأَنَّكُمْ عَصَيْتُمْ قَوْلِي عِنْدَ مَاءِ مَرِيبَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","خُذْ هَارُونَ وَأَلِعَازَارَ ٱبْنَهُ وَٱصْعَدْ بِهِمَا إِلَى جَبَلِ هُورٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","وَٱخْلَعْ عَنْ هَارُونَ ثِيَابَهُ، وَأَلْبِسْ أَلِعَازَارَ ٱبْنَهُ إِيَّاهَا. فَيُضَمُّ هَارُونُ وَيَمُوتُ هُنَاكَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","فَفَعَلَ مُوسَى كَمَا أَمَرَ ٱلرَّبُّ، وَصَعِدُوا إِلَى جَبَلِ هُورٍ أَمَامَ أَعْيُنِ كُلِّ ٱلْجَمَاعَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","فَخَلَعَ مُوسَى عَنْ هَارُونَ ثِيَابَهُ وَأَلْبَسَ أَلِعَازَارَ ٱبْنَهُ إِيَّاهَا. فَمَاتَ هَارُونُ هُنَاكَ عَلَى رَأْسِ ٱلْجَبَلِ، ثُمَّ ٱنْحَدَرَ مُوسَى وَأَلِعَازَارُ عَنِ ٱلْجَبَلِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","فَلَمَّا رَأَى كُلُّ ٱلْجَمَاعَةِ أَنَّ هَارُونَ قَدْ مَاتَ، بَكَى جَمِيعُ بَيْتِ إِسْرَائِيلَ عَلَى هَارُونَ ثَلَاثِينَ يَوْمًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","وَلَمَّا سَمِعَ ٱلْكَنْعَانِيُّ مَلِكُ عَرَادَ ٱلسَّاكِنُ فِي ٱلْجَنُوبِ أَنَّ إِسْرَائِيلَ جَاءَ فِي طَرِيقِ أَتَارِيمَ، حَارَبَ إِسْرَائِيلَ وَسَبَى مِنْهُمْ سَبْيًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","فَنَذَرَ إِسْرَائِيلُ نَذْرًا لِلرَّبِّ وَقَالَ: «إِنْ دَفَعْتَ هَؤُلَاءِ ٱلْقَوْمَ إِلَى يَدِي أُحَرِّمُ مُدُنَهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","فَسَمِعَ ٱلرَّبُّ لِقَوْلِ إِسْرَائِيلَ، وَدَفَعَ ٱلْكَنْعَانِيِّينَ، فَحَرَّمُوهُمْ وَمُدُنَهُمْ. فَدُعِيَ ٱسْمُ ٱلْمَكَانِ «حُرْمَةَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","وَٱرْتَحَلُوا مِنْ جَبَلِ هُورٍ فِي طَرِيقِ بَحْرِ سُوفٍ لِيَدُورُوا بِأَرْضِ أَدُومَ، فَضَاقَتْ نَفْسُ ٱلشَّعْبِ فِي ٱلطَّرِيقِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","وَتَكَلَّمَ ٱلشَّعْبُ عَلَى ٱللهِ وَعَلَى مُوسَى قَائِلِينَ: «لِمَاذَا أَصْعَدْتُمَانَا مِنْ مِصْرَ لِنَمُوتَ فِي ٱلْبَرِّيَّةِ؟ لِأَنَّهُ لَا خُبْزَ وَلَا مَاءَ، وَقَدْ كَرِهَتْ أَنْفُسُنَا ٱلطَّعَامَ ٱلسَّخِيفَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","فَأَرْسَلَ ٱلرَّبُّ عَلَى ٱلشَّعْبِ ٱلْحَيَّاتِ ٱلْمُحْرِقَةَ، فَلَدَغَتِ ٱلشَّعْبَ، فَمَاتَ قَوْمٌ كَثِيرُونَ مِنْ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","فَأَتَى ٱلشَّعْبُ إِلَى مُوسَى وَقَالُوا: «قَدْ أَخْطَأْنَا إِذْ تَكَلَّمْنَا عَلَى ٱلرَّبِّ وَعَلَيْكَ، فَصَلِّ إِلَى ٱلرَّبِّ لِيَرْفَعَ عَنَّا ٱلْحَيَّاتِ». فَصَلَّى مُوسَى لِأَجْلِ ٱلشَّعْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","فَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱصْنَعْ لَكَ حَيَّةً مُحْرِقَةً وَضَعْهَا عَلَى رَايَةٍ، فَكُلُّ مَنْ لُدِغَ وَنَظَرَ إِلَيْهَا يَحْيَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","فَصَنَعَ مُوسَى حَيَّةً مِنْ نُحَاسٍ وَوَضَعَهَا عَلَى ٱلرَّايَةِ، فَكَانَ مَتَى لَدَغَتْ حَيَّةٌ إِنْسَانًا وَنَظَرَ إِلَى حَيَّةِ ٱلنُّحَاسِ يَحْيَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","وَٱرْتَحَلَ بَنُو إِسْرَائِيلَ وَنَزَلُوا فِي أُوبُوتَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","وَٱرْتَحَلُوا مِنْ أُوبُوتَ وَنَزَلُوا فِي عَيِّي عَبَارِيمَ فِي ٱلْبَرِّيَّةِ، ٱلَّتِي قُبَالَةَ مُوآبَ إِلَى شُرُوقِ ٱلشَّمْسِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","مِنْ هُنَاكَ ٱرْتَحَلُوا وَنَزَلُوا فِي وَادِي زَارَدَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","مِنْ هُنَاكَ ٱرْتَحَلُوا وَنَزَلُوا فِي عَبْرِ أَرْنُونَ ٱلَّذِي فِي ٱلْبَرِّيَّةِ، خَارِجًا عَنْ تُخُمِ ٱلْأَمُورِيِّينَ. لِأَنَّ أَرْنُونَ هُوَ تُخْمُ مُوآبَ، بَيْنَ مُوآبَ وَٱلْأَمُورِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","لِذَلِكَ يُقَالُ فِي كِتَابِ «حُرُوبِ ٱلرَّبِّ»: «وَاهِبٌ فِي سُوفَةَ وَأَوْدِيَةِ أَرْنُونَ ");
INSERT INTO arb_vd_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","وَمَصَبِّ ٱلْأَوْدِيَةِ ٱلَّذِي مَالَ إِلَى مَسْكَنِ عَارَ، وَٱسْتَنَدَ إِلَى تُخُمِ مُوآبَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","وَمِنْ هُنَاكَ إِلَى بِئْرٍ. وَهِيَ ٱلْبِئْرُ حَيْثُ قَالَ ٱلرَّبُّ لِمُوسَى: «ٱجْمَعِ ٱلشَّعْبَ فَأُعْطِيَهُمْ مَاءً». ");
INSERT INTO arb_vd_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","حِينَئِذٍ تَرَنَّمَ إِسْرَائِيلُ بِهَذَا ٱلنَّشِيدِ: «اِصْعَدِي أَيَّتُهَا ٱلْبِئْرُ! أَجِيبُوا لَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","بِئْرٌ حَفَرَهَا رُؤَسَاءُ، حَفَرَهَا شُرَفَاءُ ٱلشَّعْبِ، بِصَوْلَجَانٍ، بِعِصِيِّهِمْ». وَمِنَ ٱلْبَرِّيَّةِ إِلَى مَتَّانَةَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","وَمِنْ مَتَّانَةَ إِلَى نَحْلِيئِيلَ، وَمِنْ نَحْلِيئِيلَ إِلَى بَامُوتَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","وَمِنْ بَامُوتَ إِلَى ٱلْجِوَاءِ ٱلَّتِي فِي صَحْرَاءِ مُوآبَ عِنْدَ رَأْسِ ٱلْفِسْجَةِ ٱلَّتِي تُشْرِفُ عَلَى وَجْهِ ٱلْبَرِّيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","وَأَرْسَلَ إِسْرَائِيلُ رُسُلًا إِلَى سِيحُونَ مَلِكِ ٱلْأَمُورِيِّينَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«دَعْنِي أَمُرَّ فِي أَرْضِكَ. لَا نَمِيلُ إِلَى حَقْلٍ وَلَا إِلَى كَرْمٍ وَلَا نَشْرَبُ مَاءَ بِئْرٍ. فِي طَرِيقِ ٱلْمَلِكِ نَمْشِي حَتَّى نَتَجَاوَزَ تُخُومَكَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","فَلَمْ يَسْمَحْ سِيحُونُ لِإِسْرَائِيلَ بِٱلْمُرُورِ فِي تُخُومِهِ، بَلْ جَمَعَ سِيحُونُ جَمِيعَ قَوْمِهِ وَخَرَجَ لِلِقَاءِ إِسْرَائِيلَ إِلَى ٱلْبَرِّيَّةِ، فَأَتَى إِلَى يَاهَصَ وَحَارَبَ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","فَضَرَبَهُ إِسْرَائِيلُ بِحَدِّ ٱلسَّيْفِ وَمَلَكَ أَرْضَهُ مِنْ أَرْنُونَ إِلَى يَبُّوقَ إِلَى بَنِي عَمُّونَ. لِأَنَّ تُخُمَ بَنِي عَمُّونَ كَانَ قَوِيًّا. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","فَأَخَذَ إِسْرَائِيلُ كُلَّ هَذِهِ ٱلْمُدُنِ، وَأَقَامَ إِسْرَائِيلُ فِي جَمِيعِ مُدُنِ ٱلْأَمُورِيِّينَ فِي حَشْبُونَ وَفِي كُلِّ قُرَاهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","لِأَنَّ حَشْبُونَ كَانَتْ مَدِينَةَ سِيحُونَ مَلِكِ ٱلْأَمُورِيِّينَ، وَكَانَ قَدْ حَارَبَ مَلِكَ مُوآبَ ٱلْأَوَّلَ وَأَخَذَ كُلَّ أَرْضِهِ مِنْ يَدِهِ حَتَّى أَرْنُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","لِذَلِكَ يَقُولُ أَصْحَابُ ٱلْأَمْثَالِ: «اِيتُوا إِلَى حَشْبُونَ فَتُبْنَى، وَتُصْلَحَ مَدِينَةُ سِيحُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","لِأَنَّ نَارًا خَرَجَتْ مِنْ حَشْبُونَ، لَهِيبًا مِنْ قَرْيَةِ سِيحُونَ. أَكَلَتْ عَارَ مُوآبَ. أَهْلَ مُرْتَفَعَاتِ أَرْنُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","وَيْلٌ لَكَ يَا مُوآبُ. هَلَكْتِ يَا أُمَّةَ كَمُوشَ. قَدْ صَيَّرَ بَنِيهِ هَارِبِينَ وَبَنَاتِهِ فِي ٱلسَّبْيِ لِمَلِكِ ٱلْأَمُورِيِّينَ سِيحُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","لَكِنْ قَدْ رَمَيْنَاهُمْ. هَلَكَتْ حَشْبُونُ إِلَى دِيبُونَ. وَأَخْرَبْنَا إِلَى نُوفَحَ ٱلَّتِي إِلَى مِيدَبَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","فَأَقَامَ إِسْرَائِيلُ فِي أَرْضِ ٱلْأَمُورِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","وَأَرْسَلَ مُوسَى لِيَتَجَسَّسَ يَعْزِيرَ، فَأَخَذُوا قُرَاهَا وَطَرَدُوا ٱلْأَمُورِيِّينَ ٱلَّذِينَ هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ثُمَّ تَحَوَّلُوا وَصَعِدُوا فِي طَرِيقِ بَاشَانَ. فَخَرَجَ عُوجُ مَلِكُ بَاشَانَ لِلِقَائِهِمْ هُوَ وَجَمِيعُ قَوْمِهِ إِلَى ٱلْحَرْبِ فِي إِذْرَعِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","فَقَالَ ٱلرَّبُّ لِمُوسَى: «لَا تَخَفْ مِنْهُ لِأَنِّي قَدْ دَفَعْتُهُ إِلَى يَدِكَ مَعَ جَمِيعِ قَوْمِهِ وَأَرْضِهِ، فَتَفْعَلُ بِهِ كَمَا فَعَلْتَ بِسِيحُونَ مَلِكِ ٱلْأَمُورِيِّينَ ٱلسَّاكِنِ فِي حَشْبُونَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","فَضَرَبُوهُ وَبَنِيهِ وَجَمِيعَ قَوْمِهِ حَتَّى لَمْ يَبْقَ لَهُ شَارِدٌ، وَمَلَكُوا أَرْضَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","وَٱرْتَحَلَ بَنُو إِسْرَائِيلَ وَنَزَلُوا فِي عَرَبَاتِ مُوآبَ مِنْ عَبْرِ أُرْدُنِّ أَرِيحَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","وَلَمَّا رَأَى بَالَاقُ بْنُ صِفُّورَ جَمِيعَ مَا فَعَلَ إِسْرَائِيلُ بِٱلْأَمُورِيِّينَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","فَزِعَ مُوآبُ مِنَ ٱلشَّعْبِ جِدًّا لِأَنَّهُ كَثِيرٌ، وَضَجِرَ مُوآبُ مِنْ قِبَلَ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","فَقَالَ مُوآبُ لِشُيُوخِ مِدْيَانَ: «ٱلْآنَ يَلْحَسُ ٱلْجُمْهُورُ كُلَّ مَا حَوْلَنَا كَمَا يَلْحَسُ ٱلثَّوْرُ خُضْرَةَ ٱلْحَقْلِ». وَكَانَ بَالَاقُ بْنُ صِفُّورَ مَلِكًا لِمُوآبَ فِي ذَلِكَ ٱلزَّمَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","فَأَرْسَلَ رُسُلًا إِلَى بَلْعَامَ بْنِ بَعُورَ، إِلَى فَتُورَ ٱلَّتِي عَلَى ٱلنَّهْرِ فِي أَرْضِ بَنِي شَعْبِهِ لِيَدْعُوَهُ قَائِلًا: «هُوَذَا شَعْبٌ قَدْ خَرَجَ مِنْ مِصْرَ. هُوَذَا قَدْ غَشَّى وَجْهَ ٱلْأَرْضِ، وَهُوَ مُقِيمٌ مُقَابِلِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","فَٱلْآنَ تَعَالَ وَٱلْعَنْ لِي هَذَا ٱلشَّعْبَ، لِأَنَّهُ أَعْظَمُ مِنِّي، لَعَلَّهُ يُمْكِنُنَا أَنْ نَكْسِرَهُ فَأَطْرُدَهُ مِنَ ٱلْأَرْضِ، لِأَنِّي عَرَفْتُ أَنَّ ٱلَّذِي تُبَارِكُهُ مُبَارَكٌ وَٱلَّذِي تَلْعَنُهُ مَلْعُونٌ». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","فَٱنْطَلَقَ شُيُوخُ مُوآبَ وَشُيُوخُ مِدْيَانَ، وَحُلْوَانُ ٱلْعِرَافَةِ فِي أَيْدِيهِمْ، وَأَتَوْا إِلَى بَلْعَامَ وَكَلَّمُوهُ بِكَلَامِ بَالَاقَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","فَقَالَ لَهُمْ: «بِيتُوا هُنَا ٱللَّيْلَةَ فَأَرُدَّ عَلَيْكُمْ جَوَابًا كَمَا يُكَلِّمُنِي ٱلرَّبُّ». فَمَكَثَ رُؤَسَاءُ مُوآبَ عِنْدَ بَلْعَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","فَأَتَى ٱللهُ إِلَى بَلْعَامَ وَقَالَ: «مَنْ هُمْ هَؤُلَاءِ ٱلرِّجَالُ ٱلَّذِينَ عِنْدَكَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","فَقَالَ بَلْعَامُ لِلهِ: «بَالَاقُ بْنُ صِفُّورَ مَلِكُ مُوآبَ قَدْ أَرْسَلَ إِلَيَّ يَقُولُ: ");
INSERT INTO arb_vd_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","هُوَذَا ٱلشَّعْبُ ٱلْخَارِجُ مِنْ مِصْرَ قَدْ غَشَّى وَجْهَ ٱلْأَرْضِ. تَعَالَ ٱلْآنَ ٱلْعَنْ لِي إِيَّاهُ، لَعَلِّي أَقْدِرُ أَنْ أُحَارِبَهُ وَأَطْرُدَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","فَقَالَ ٱللهُ لِبَلْعَامَ: «لَا تَذْهَبْ مَعَهُمْ وَلَا تَلْعَنِ ٱلشَّعْبَ، لِأَنَّهُ مُبَارَكٌ». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","فَقَامَ بَلْعَامُ صَبَاحًا وَقَالَ لِرُؤَسَاءِ بَالَاقَ: «ٱنْطَلِقُوا إِلَى أَرْضِكُمْ لِأَنَّ ٱلرَّبَّ أَبَى أَنْ يَسْمَحَ لِي بِٱلذَّهَابِ مَعَكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","فَقَامَ رُؤَسَاءُ مُوآبَ وَأَتَوْا إِلَى بَالَاقَ وَقَالُوا: «أَبَى بَلْعَامُ أَنْ يَأْتِيَ مَعَنَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","فَعَادَ بَالَاقُ وَأَرْسَلَ أَيْضًا رُؤَسَاءَ أَكْثَرَ وَأَعْظَمَ مِنْ أُولَئِكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","فَأَتَوْا إِلَى بَلْعَامَ وَقَالُوا لَهُ: «هَكَذَا قَالَ بَالَاقُ بْنُ صِفُّورَ: لَا تَمْتَنِعْ مِنَ ٱلْإِتْيَانِ إِلَيَّ، ");
INSERT INTO arb_vd_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","لِأَنِّي أُكْرِمُكَ إِكْرَامًا عَظِيمًا، وَكُلَّ مَا تَقُولُ لِي أَفْعَلُهُ. فَتَعَالَ ٱلْآنَ ٱلْعَنْ لِي هَذَا ٱلشَّعْبَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","فَأَجَابَ بَلْعَامُ وَقَالَ لِعَبِيدِ بَالَاقَ: «وَلَوْ أَعْطَانِي بَالَاقُ مِلْءَ بَيْتِهِ فِضَّةً وَذَهَبًا لَا أَقْدِرُ أَنْ أَتَجَاوَزَ قَوْلَ ٱلرَّبِّ إِلَهِي لِأَعْمَلَ صَغِيرًا أَوْ كَبِيرًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","فَٱلْآنَ ٱمْكُثُوا هُنَا أَنْتُمْ أَيْضًا هَذِهِ ٱللَّيْلَةَ لِأَعْلَمَ مَاذَا يَعُودُ ٱلرَّبُّ يُكَلِّمُنِي بِهِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","فَأَتَى ٱللهُ إِلَى بَلْعَامَ لَيْلًا وَقَالَ لَهُ: «إِنْ أَتَى ٱلرِّجَالُ لِيَدْعُوكَ فَقُمِ ٱذْهَبْ مَعَهُمْ، إِنَّمَا تَعْمَلُ ٱلْأَمْرَ ٱلَّذِي أُكَلِّمُكَ بِهِ فَقَطْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","فَقَامَ بَلْعَامُ صَبَاحًا وَشَدَّ عَلَى أَتَانِهِ وَٱنْطَلَقَ مَعَ رُؤَسَاءِ مُوآبَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","فَحَمِيَ غَضَبُ ٱللهِ لِأَنَّهُ مُنْطَلِقٌ، وَوَقَفَ مَلَاكُ ٱلرَّبِّ فِي ٱلطَّرِيقِ لِيُقَاوِمَهُ وَهُوَ رَاكِبٌ عَلَى أَتَانِهِ وَغُلَامَاهُ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","فَأَبْصَرَتِ ٱلْأَتَانُ مَلَاكَ ٱلرَّبِّ وَاقِفًا فِي ٱلطَّرِيقِ وَسَيْفُهُ مَسْلُولٌ فِي يَدِهِ، فَمَالَتِ ٱلْأَتَانُ عَنِ ٱلطَّرِيقِ وَمَشَتْ فِي ٱلْحَقْلِ. فَضَرَبَ بَلْعَامُ ٱلْأَتَانَ لِيَرُدَّهَا إِلَى ٱلطَّرِيقِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ثُمَّ وَقَفَ مَلَاكُ ٱلرَّبِّ فِي خَنْدَقٍ لِلْكُرُومِ، لَهُ حَائِطٌ مِنْ هُنَا وَحَائِطٌ مِنْ هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","فَلَمَّا أَبْصَرَتِ ٱلْأَتَانُ مَلَاكَ ٱلرَّبِّ زَحَمَتِ ٱلْحَائِطَ، وَضَغَطَتْ رِجْلَ بَلْعَامَ بِٱلْحَائِطِ، فَضَرَبَهَا أَيْضًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ثُمَّ ٱجْتَازَ مَلَاكُ ٱلرَّبِّ أَيْضًا وَوَقَفَ فِي مَكَانٍ ضَيِّقٍ حَيْثُ لَيْسَ سَبِيلٌ لِلنُّكُوبِ يَمِينًا أَوْ شِمَالًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","فَلَمَّا أَبْصَرَتِ ٱلْأَتَانُ مَلَاكَ ٱلرَّبِّ، رَبَضَتْ تَحْتَ بَلْعَامَ. فَحَمِيَ غَضَبُ بَلْعَامَ وَضَرَبَ ٱلْأَتَانَ بِٱلْقَضِيبِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","فَفَتَحَ ٱلرَّبُّ فَمَ ٱلْأَتَانِ، فَقَالَتْ لِبَلْعَامَ: «مَاذَا صَنَعْتُ بِكَ حَتَّى ضَرَبْتَنِي ٱلْآنَ ثَلَاثَ دَفَعَاتٍ؟». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","فَقَالَ بَلْعَامُ لِلْأَتَانِ: «لِأَنَّكِ ٱزْدَرَيْتِ بِي. لَوْ كَانَ فِي يَدِي سَيْفٌ لَكُنْتُ ٱلْآنَ قَدْ قَتَلْتُكِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","فَقَالَتِ ٱلْأَتَانُ لِبَلْعَامَ: «أَلَسْتُ أَنَا أَتَانَكَ ٱلَّتِي رَكِبْتَ عَلَيْهَا مُنْذُ وُجُودِكَ إِلَى هَذَا ٱلْيَوْمِ؟ هَلْ تَعَوَّدْتُ أَنْ أَفْعَلَ بِكَ هَكَذَا؟» فَقَالَ: «لَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ثُمَّ كَشَفَ ٱلرَّبُّ عَنْ عَيْنَيْ بَلْعَامَ، فَأَبْصَرَ مَلَاكَ ٱلرَّبِّ وَاقِفًا فِي ٱلطَّرِيقِ وَسَيْفُهُ مَسْلُولٌ فِي يَدِهِ، فَخَرَّ سَاجِدًا عَلَى وَجْهِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","فَقَالَ لَهُ مَلَاكُ ٱلرَّبِّ: «لِمَاذَا ضَرَبْتَ أَتَانَكَ ٱلْآنَ ثَلَاثَ دَفَعَاتٍ؟ هَأَنَذَا قَدْ خَرَجْتُ لِلْمُقَاوَمَةِ لِأَنَّ ٱلطَّرِيقَ وَرْطَةٌ أَمَامِي، ");
INSERT INTO arb_vd_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","فَأَبْصَرَتْنِي ٱلْأَتَانُ وَمَالَتْ مِنْ قُدَّامِي ٱلْآنَ ثَلَاثَ دَفَعَاتٍ. وَلَوْ لَمْ تَمِلْ مِنْ قُدَّامِي لَكُنْتُ ٱلْآنَ قَدْ قَتَلْتُكَ وَٱسْتَبْقَيْتُهَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","فَقَالَ بَلْعَامُ لِمَلَاكِ ٱلرَّبِّ: «أَخْطَأْتُ. إِنِّي لَمْ أَعْلَمْ أَنَّكَ وَاقِفٌ تِلْقَائِي فِي ٱلطَّرِيقِ. وَٱلْآنَ إِنْ قَبُحَ فِي عَيْنَيْكَ فَإِنِّي أَرْجِعُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","فَقَالَ مَلَاكُ ٱلرَّبِّ لِبَلْعَامَ: «ٱذْهَبْ مَعَ ٱلرِّجَالِ، وَإِنَّمَا تَتَكَلَّمُ بِٱلْكَلَامِ ٱلَّذِي أُكَلِّمُكَ بِهِ فَقَطْ». فَٱنْطَلَقَ بَلْعَامُ مَعَ رُؤَسَاءِ بَالَاقَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","فَلَمَّا سَمِعَ بَالَاقُ أَنَّ بَلْعَامَ جَاءَ، خَرَجَ لِٱسْتِقْبَالِهِ إِلَى مَدِينَةِ مُوآبَ ٱلَّتِي عَلَى تَخْمِ أَرْنُونَ ٱلَّذِي فِي أَقْصَى ٱلتُّخُومِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","فَقَالَ بَالَاقُ لِبَلْعَامَ: «أَلَمْ أُرْسِلْ إِلَيْكَ لِأَدْعُوَكَ؟ لِمَاذَا لَمْ تَأْتِ إِلَيَّ؟ أَحَقًّا لَا أَقْدِرُ أَنْ أُكْرِمَكَ؟» ");
INSERT INTO arb_vd_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","فَقَالَ بَلْعَامُ لِبَالَاقَ: «هَأَنَذَا قَدْ جِئْتُ إِلَيْكَ. أَلَعَلِّي ٱلْآنَ أَسْتَطِيعُ أَنْ أَتَكَلَّمَ بِشَيْءٍ؟ اَلْكَلَامُ ٱلَّذِي يَضَعُهُ ٱللهُ فِي فَمِي بِهِ أَتَكَلَّمُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","فَٱنْطَلَقَ بَلْعَامُ مَعَ بَالَاقَ وَأَتَيَا إِلَى قَرْيَةِ حَصُوتَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","فَذَبَحَ بَالَاقُ بَقَرًا وَغَنَمًا، وَأَرْسَلَ إِلَى بَلْعَامَ وَإِلَى ٱلرُّؤَسَاءِ ٱلَّذِينَ مَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","وَفِي ٱلصَّبَاحِ أَخَذَ بَالَاقُ بَلْعَامَ وَأَصْعَدَهُ إِلَى مُرْتَفَعَاتِ بَعْلٍ، فَرَأَى مِنْ هُنَاكَ أَقْصَى ٱلشَّعْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","فَقَالَ بَلْعَامُ لِبَالَاقَ: «ٱبْنِ لِي هَهُنَا سَبْعَةَ مَذَابِحَ وَهَيِّئْ لِي هَهُنَا سَبْعَةَ ثِيرَانٍ وَسَبْعَةَ كِبَاشٍ». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","فَفَعَلَ بَالَاقُ كَمَا تَكَلَّمَ بَلْعَامُ. وَأَصْعَدَ بَالَاقُ وَبَلْعَامُ ثَوْرًا وَكَبْشًا عَلَى كُلِّ مَذْبَحٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","فَقَالَ بَلْعَامُ لِبَالَاقَ: «قِفْ عِنْدَ مُحْرَقَتِكَ، فَأَنْطَلِقَ أَنَا لَعَلَّ ٱلرَّبَّ يُوافِي لِلِقَائِي، فَمَهْمَا أَرَانِي أُخْبِرْكَ بِهِ». ثُمَّ ٱنْطَلَقَ إِلَى رَابِيَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","فَوَافَى ٱللهُ بَلْعَامَ، فَقَالَ لَهُ: «قَدْ رَتَّبْتُ سَبْعَةَ مَذَابِحَ وَأَصْعَدْتُ ثَوْرًا وَكَبْشًا عَلَى كُلِّ مَذْبَحٍ». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","فَوَضَعَ ٱلرَّبُّ كَلَامًا فِي فَمِ بَلْعَامَ وَقَالَ: «ٱرْجِعْ إِلَى بَالَاقَ وَتَكَلَّمْ هَكَذَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","فَرَجَعَ إِلَيْهِ وَإِذَا هُوَ وَاقِفٌ عِنْدَ مُحْرَقَتِهِ هُوَ، وَجَمِيعُ رُؤَسَاءِ مُوآبَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","فَنَطَقَ بِمَثَلِهِ وَقَالَ: «مِنْ أَرَامَ أَتَى بِي بَالَاقُ مَلِكُ مُوآبَ، مِنْ جِبَالِ ٱلْمَشْرِقِ: تَعَالَ ٱلْعَنْ لِي يَعْقُوبَ، وَهَلُمَّ ٱشْتِمْ إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","كَيْفَ أَلْعَنُ مَنْ لَمْ يَلْعَنْهُ ٱللهُ؟ وَكَيْفَ أَشْتِمُ مَنْ لَمْ يَشْتِمْهُ ٱلرَّبُّ؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","إِنِّي مِنْ رَأْسِ ٱلصُّخُورِ أَرَاهُ، وَمِنَ ٱلْآكَامِ أُبْصِرُهُ. هُوَذَا شَعْبٌ يَسْكُنُ وَحْدَهُ، وَبَيْنَ ٱلشُّعُوبِ لَا يُحْسَبُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","مَنْ أَحْصَى تُرَابَ يَعْقُوبَ وَرُبْعَ إِسْرَائِيلَ بِعَدَدٍ؟ لِتَمُتْ نَفْسِي مَوْتَ ٱلْأَبْرَارِ، وَلْتَكُنْ آخِرَتِي كَآخِرَتِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","فَقَالَ بَالَاقُ لِبَلْعَامَ: «مَاذَا فَعَلْتَ بِي؟ لِتَشْتِمَ أَعْدَائِي أَخَذْتُكَ، وَهُوَذَا أَنْتَ قَدْ بَارَكْتَهُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","فَأَجَابَ وَقَالَ: «أَمَا ٱلَّذِي يَضَعُهُ ٱلرَّبُّ فِي فَمِي أَحْتَرِصُ أَنْ أَتَكَلَّمَ بِهِ؟». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","فَقَالَ لَهُ بَالَاقُ: «هَلُمَّ مَعِي إِلَى مَكَانٍ آخَرَ تَرَاهُ مِنْهُ. إِنَّمَا تَرَى أَقْصَاءَهُ فَقَطْ، وَكُلَّهُ لَا تَرَى. فَٱلْعَنْهُ لِي مِنْ هُنَاكَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","فَأَخَذَهُ إِلَى حَقْلِ صُوفِيمَ إِلَى رَأْسِ ٱلْفِسْجَةِ، وَبَنَى سَبْعَةَ مَذَابِحَ، وَأَصْعَدَ ثَوْرًا وَكَبْشًا عَلَى كُلِّ مَذْبَحٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","فَقَالَ لِبَالَاقَ: «قِفْ هُنَا عِنْدَ مُحْرَقَتِكَ وَأَنَا أُوافِي هُنَاكَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","فَوَافَى ٱلرَّبُّ بَلْعَامَ وَوَضَعَ كَلَامًا فِي فَمِهِ وَقَالَ: «ٱرْجِعْ إِلَى بَالَاقَ وَتَكَلَّمْ هَكَذَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","فَأَتَى إِلَيْهِ وَإِذَا هُوَ وَاقِفٌ عِنْدَ مُحْرَقَتِهِ، وَرُؤَسَاءُ مُوآبَ مَعَهُ. فَقَالَ لَهُ بَالَاقُ: «مَاذَا تَكَلَّمَ بِهِ ٱلرَّبُّ؟» ");
INSERT INTO arb_vd_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","فَنَطَقَ بِمَثَلِهِ وَقَالَ: «قُمْ يَا بَالَاقُ وَٱسْمَعْ. اِصْغَ إِلَيَّ يَا ٱبْنَ صِفُّورَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","لَيْسَ ٱللهُ إِنْسَانًا فَيَكْذِبَ، وَلَا ٱبْنَ إِنْسَانٍ فَيَنْدَمَ. هَلْ يَقُولُ وَلَا يَفْعَلُ؟ أَوْ يَتَكَلَّمُ وَلَا يَفِي؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","إِنِّي قَدْ أُمِرْتُ أَنْ أُبَارِكَ. فَإِنَّهُ قَدْ بَارَكَ فَلَا أَرُدُّهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","لَمْ يُبْصِرْ إِثْمًا فِي يَعْقُوبَ، وَلَا رَأَى تَعَبًا فِي إِسْرَائِيلَ. ٱلرَّبُّ إِلَهُهُ مَعَهُ، وَهُتَافُ مَلِكٍ فِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ٱللهُ أَخْرَجَهُ مِنْ مِصْرَ. لَهُ مِثْلُ سُرْعَةِ ٱلرِّئْمِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","إِنَّهُ لَيْسَ عِيَافَةٌ عَلَى يَعْقُوبَ، وَلَا عِرَافَةٌ عَلَى إِسْرَائِيلَ. فِي ٱلْوَقْتِ يُقَالُ عَنْ يَعْقُوبَ وَعَنْ إِسْرَائِيلَ مَا فَعَلَ ٱللهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","هُوَذَا شَعْبٌ يَقُومُ كَلَبْوَةٍ، وَيَرْتَفِعُ كَأَسَدٍ. لَا يَنَامُ حَتَّى يَأْكُلَ فَرِيسَةً وَيَشْرَبَ دَمَ قَتْلَى». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","فَقَالَ بَالَاقُ لِبَلْعَامَ: «لَا تَلْعَنْهُ لَعْنَةً وَلَا تُبَارِكْهُ بَرَكَةً». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","فَأَجَابَ بَلْعَامُ وَقَالَ لِبَالَاقَ: «أَلَمْ أُكَلِّمْكَ قَائِلًا: كُلُّ مَا يَتَكَلَّمُ بِهِ ٱلرَّبُّ فَإِيَّاهُ أَفْعَلُ؟». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","فَقَالَ بَالَاقُ لِبَلْعَامَ: «هَلُمَّ آخُذْكَ إِلَى مَكَانٍ آخَرَ، عَسَى أَنْ يَصْلُحَ فِي عَيْنَيِ ٱللهِ أَنْ تَلْعَنَهُ لِي مِنْ هُنَاكَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","فَأَخَذَ بَالَاقُ بَلْعَامَ إِلَى رَأْسِ فَغُورَ ٱلْمُشْرِفِ عَلَى وَجْهِ ٱلْبَرِّيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","فَقَالَ بَلْعَامُ لِبَالَاقَ: «ٱبْنِ لِي هَهُنَا سَبْعَةَ مَذَابِحَ، وَهَيِّئْ لِي هَهُنَا سَبْعَةَ ثِيرَانٍ وَسَبْعَةَ كِبَاشٍ». ");
INSERT INTO arb_vd_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","فَفَعَلَ بَالَاقُ كَمَا قَالَ بَلْعَامُ، وَأَصْعَدَ ثَوْرًا وَكَبْشًا عَلَى كُلِّ مَذْبَحٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","فَلَمَّا رَأَى بَلْعَامُ أَنَّهُ يَحْسُنُ فِي عَيْنَيِ ٱلرَّبِّ أَنْ يُبَارِكَ إِسْرَائِيلَ، لَمْ يَنْطَلِقْ كَٱلْمَرَّةِ ٱلْأُولَى وَٱلثَّانِيَةِ لِيُوافِيَ فَأْلًا، بَلْ جَعَلَ نَحْوَ ٱلْبَرِّيَّةِ وَجْهَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","وَرَفَعَ بَلْعَامُ عَيْنَيْهِ وَرَأَى إِسْرَائِيلَ حَالًّا حَسَبَ أَسْبَاطِهِ، فَكَانَ عَلَيْهِ رُوحُ ٱللهِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","فَنَطَقَ بِمَثَلِهِ وَقَالَ: «وَحْيُ بَلْعَامَ بْنِ بَعُورَ. وَحْيُ ٱلرَّجُلِ ٱلْمَفْتُوحِ ٱلْعَيْنَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","وَحْيُ ٱلَّذِي يَسْمَعُ أَقْوَالَ ٱللهِ. ٱلَّذِي يَرَى رُؤْيَا ٱلْقَدِيرِ، مَطْرُوحًا وَهُوَ مَكْشُوفُ ٱلْعَيْنَيْنِ: ");
INSERT INTO arb_vd_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","مَا أَحْسَنَ خِيَامَكَ يَا يَعْقُوبُ، مَسَاكِنَكَ يَا إِسْرَائِيلُ! ");
INSERT INTO arb_vd_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","كَأَوْدِيَةٍ مُمْتَدَّةٍ. كَجَنَّاتٍ عَلَى نَهْرٍ، كَشَجَرَاتِ عُودٍ غَرَسَهَا ٱلرَّبُّ. كَأَرْزَاتٍ عَلَى مِيَاهٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","يَجْرِي مَاءٌ مِنْ دِلَائِهِ، وَيَكُونُ زَرْعُهُ عَلَى مِيَاهٍ غَزِيرَةٍ، وَيَتَسَامَى مَلِكُهُ عَلَى أَجَاجَ وَتَرْتَفِعُ مَمْلَكَتُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ٱللهُ أَخْرَجَهُ مِنْ مِصْرَ. لَهُ مِثْلُ سُرْعَةِ ٱلرِّئْمِ. يَأْكُلُ أُمَمًا، مُضَايِقِيهِ، وَيَقْضِمُ عِظَامَهُمْ وَيُحَطِّمُ سِهَامَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","جَثَمَ كَأَسَدٍ. رَبَضَ كَلَبْوَةٍ. مَنْ يُقِيمُهُ؟ مُبَارِكُكَ مُبَارَكٌ، وَلَاعِنُكَ مَلْعُونٌ». ");
INSERT INTO arb_vd_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","فَٱشْتَعَلَ غَضَبُ بَالَاقَ عَلَى بَلْعَامَ، وَصَفَّقَ بِيَدَيْهِ وَقَالَ بَالَاقُ لِبَلْعَامَ: «لِتَشْتِمَ أَعْدَائِي دَعَوْتُكَ، وَهُوَذَا أَنْتَ قَدْ بَارَكْتَهُمُ ٱلْآنَ ثَلَاثَ دَفَعَاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","فَٱلْآنَ ٱهْرُبْ إِلَى مَكَانِكَ. قُلْتُ أُكْرِمُكَ إِكْرَامًا، وَهُوَذَا ٱلرَّبُّ قَدْ مَنَعَكَ عَنِ ٱلْكَرَامَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","فَقَالَ بَلْعَامُ لِبَالَاقَ: «أَلَمْ أُكَلِّمْ أَيْضًا رُسُلَكَ ٱلَّذِينَ أَرْسَلْتَ إِلَيَّ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","وَلَوْ أَعْطَانِي بَالَاقُ مِلْءَ بَيْتِهِ فِضَّةً وَذَهَبًا لَا أَقْدِرُ أَنْ أَتَجَاوَزَ قَوْلَ ٱلرَّبِّ لِأَعْمَلَ خَيْرًا أَوْ شَرًّا مِنْ نَفْسِي. ٱلَّذِي يَتَكَلَّمُهُ ٱلرَّبُّ إِيَّاهُ أَتَكَلَّمُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","وَٱلْآنَ هُوَذَا أَنَا مُنْطَلِقٌ إِلَى شَعْبِي. هَلُمَّ أُنْبِئْكَ بِمَا يَفْعَلُهُ هَذَا ٱلشَّعْبُ بِشَعْبِكَ فِي آخِرِ ٱلْأَيَّامِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ثُمَّ نَطَقَ بِمَثَلِهِ وَقَالَ: «وَحْيُ بَلْعَامَ بْنِ بَعُورَ. وَحْيُ ٱلرَّجُلِ ٱلْمَفْتُوحِ ٱلْعَيْنَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","وَحْيُ ٱلَّذِي يَسْمَعُ أَقْوَالَ ٱللهِ وَيَعْرِفُ مَعْرِفَةَ ٱلْعَلِيِّ. ٱلَّذِي يَرَى رُؤْيَا ٱلْقَدِيرِ سَاقِطًا وَهُوَ مَكْشُوفُ ٱلْعَيْنَيْنِ: ");
INSERT INTO arb_vd_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","أَرَاهُ وَلَكِنْ لَيْسَ ٱلْآنَ. أُبْصِرُهُ وَلَكِنْ لَيْسَ قَرِيبًا. يَبْرُزُ كَوْكَبٌ مِنْ يَعْقُوبَ، وَيَقُومُ قَضِيبٌ مِنْ إِسْرَائِيلَ، فَيُحَطِّمُ طَرَفَيْ مُوآبَ، وَيُهْلِكُ كُلَّ بَنِي ٱلْوَغَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","وَيَكُونُ أَدُومُ مِيرَاثًا، وَيَكُونُ سِعِيرُ أَعْدَاؤُهُ مِيرَاثًا. وَيَصْنَعُ إِسْرَائِيلُ بِبَأْسٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","وَيَتَسَلَّطُ ٱلَّذِي مِنْ يَعْقُوبَ، وَيَهْلِكُ ٱلشَّارِدُ مِنْ مَدِينَةٍ». ");
INSERT INTO arb_vd_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ثُمَّ رَأَى عَمَالِيقَ فَنَطَقَ بِمَثَلِهِ وَقَالَ: «عَمَالِيقُ أَوَّلُ ٱلشُّعُوبِ، وَأَمَّا آخِرَتُهُ فَإِلَى ٱلْهَلَاكِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ثُمَّ رَأَى ٱلْقِينِيَّ فَنَطَقَ بِمَثَلِهِ وَقَالَ: «لِيَكُنْ مَسْكَنُكَ مَتِينًا، وَعُشُّكَ مَوْضُوعًا فِي صَخْرَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","لَكِنْ يَكُونُ قَايِنُ لِلدَّمَارِ. حَتَّى مَتَى يَسْتَأْسِرُكَ أَشُّورُ؟». ");
INSERT INTO arb_vd_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ثُمَّ نَطَقَ بِمَثَلِهِ وَقَالَ: «آهْ! مَنْ يَعِيشُ حِينَ يَفْعَلُ ذَلِكَ؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","وَتَأْتِي سُفُنٌ مِنْ نَاحِيَةِ كِتِّيمَ وَتُخْضِعُ أَشُّورَ، وَتُخْضِعُ عَابِرَ، فَهُوَ أَيْضًا إِلَى ٱلْهَلَاكِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ثُمَّ قَامَ بَلْعَامُ وَٱنْطَلَقَ وَرَجَعَ إِلَى مَكَانِهِ. وَبَالَاقُ أَيْضًا ذَهَبَ فِي طَرِيقِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","وَأَقَامَ إِسْرَائِيلُ فِي شِطِّيمَ، وَٱبْتَدَأَ ٱلشَّعْبُ يَزْنُونَ مَعَ بَنَاتِ مُوآبَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","فَدَعَوْنَ ٱلشَّعْبَ إِلَى ذَبَائِحِ آلِهَتِهِنَّ، فَأَكَلَ ٱلشَّعْبُ وَسَجَدُوا لِآلِهَتِهِنَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","وَتَعَلَّقَ إِسْرَائِيلُ بِبَعْلِ فَغُورَ. فَحَمِيَ غَضَبُ ٱلرَّبِّ عَلَى إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","فَقَالَ ٱلرَّبُّ لِمُوسَى: «خُذْ جَمِيعَ رُؤُوسِ ٱلشَّعْبِ وَعَلِّقْهُمْ لِلرَّبِّ مُقَابِلَ ٱلشَّمْسِ، فَيَرْتَدَّ حُمُوُّ غَضَبِ ٱلرَّبِّ عَنْ إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","فَقَالَ مُوسَى لِقُضَاةِ إِسْرَائِيلَ: «ٱقْتُلُوا كُلُّ وَاحِدٍ قَوْمَهُ ٱلْمُتَعَلِّقِينَ بِبَعْلِ فَغُورَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","وَإِذَا رَجُلٌ مِنْ بَنِي إِسْرَائِيلَ جَاءَ وَقَدَّمَ إِلَى إِخْوَتِهِ ٱلْمِدْيَانِيَّةَ، أَمَامَ عَيْنَيْ مُوسَى وَأَعْيُنِ كُلِّ جَمَاعَةِ بَنِي إِسْرَائِيلَ، وَهُمْ بَاكُونَ لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","فَلَمَّا رَأَى ذَلِكَ فِينْحَاسُ بْنُ أَلِعَازَارَ بْنِ هَارُونَ ٱلْكَاهِنِ، قَامَ مِنْ وَسَطِ ٱلْجَمَاعَةِ وَأَخَذَ رُمْحًا بِيَدِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","وَدَخَلَ وَرَاءَ ٱلرَّجُلِ ٱلْإِسْرَائِيلِيِّ إِلَى ٱلْقُبَّةِ وَطَعَنَ كِلَيْهِمَا، ٱلرَّجُلَ ٱلْإِسْرَائِيلِيَّ وَٱلْمَرْأَةَ فِي بَطْنِهَا. فَٱمْتَنَعَ ٱلْوَبَأُ عَنْ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","وَكَانَ ٱلَّذِينَ مَاتُوا بِٱلْوَبَإِ أَرْبَعَةً وَعِشْرِينَ أَلْفًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","فَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«فِينْحَاسُ بْنُ أَلِعَازَارَ بْنِ هَارُونَ ٱلْكَاهِنِ قَدْ رَدَّ سَخَطِي عَنْ بَنِي إِسْرَائِيلَ بِكَوْنِهِ غَارَ غَيْرَتِي فِي وَسَطِهِمْ حَتَّى لَمْ أُفْنِ بَنِي إِسْرَائِيلَ بِغَيْرَتِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","لِذَلِكَ قُلْ: هَأَنَذَا أُعْطِيهِ مِيثَاقِي مِيثَاقَ ٱلسَّلَامِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","فَيَكُونُ لَهُ وَلِنَسْلِهِ مِنْ بَعْدِهِ مِيثَاقَ كَهَنُوتٍ أَبَدِيٍّ، لِأَجْلِ أَنَّهُ غَارَ لِلهِ وَكَفَّرَ عَنْ بَنِي إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","وَكَانَ ٱسْمُ ٱلرَّجُلِ ٱلْإِسْرَائِيلِيِّ ٱلْمَقْتُولِ ٱلَّذِي قُتِلَ مَعَ ٱلْمِدْيَانِيَّةِ، زِمْرِيَ بْنَ سَالُو، رَئِيسَ بَيْتِ أَبٍ مِنَ ٱلشِّمْعُونِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","وَٱسْمُ ٱلْمَرْأَةِ ٱلْمِدْيَانِيَّةِ ٱلْمَقْتُولَةِ كُزْبِيَ بِنْتَ صُورٍ، هُوَ رَئِيسُ قَبَائِلِ بَيْتِ أَبٍ فِي مِدْيَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ثُمَّ كَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«ضَايِقُوا ٱلْمِدْيَانِيِّينَ وَٱضْرِبُوهُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","لِأَنَّهُمْ ضَايَقُوكُمْ بِمَكَايِدِهِمِ ٱلَّتِي كَادُوكُمْ بِهَا فِي أَمْرِ فَغُورَ وَأَمْرِ كُزْبِي أُخْتِهِمْ بِنْتِ رَئِيسٍ لِمِدْيَانَ، ٱلَّتِي قُتِلَتْ يَوْمَ ٱلْوَبَإِ بِسَبَبِ فَغُورَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ثُمَّ بَعْدَ ٱلْوَبَإِ كَلَّمَ ٱلرَّبُّ مُوسَى وَأَلِعَازَارَ بْنَ هَارُونَ ٱلْكَاهِنِ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«خُذَا عَدَدَ كُلِّ جَمَاعَةِ بَنِي إِسْرَائِيلَ، مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا حَسَبَ بُيُوتِ آبَائِهِمْ، كُلِّ خَارِجٍ لِلْجُنْدِ فِي إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","فَكَلَّمَهُمْ مُوسَى وَأَلِعَازَارُ ٱلْكَاهِنُ فِي عَرَبَاتِ مُوآبَ عَلَى أُرْدُنِّ أَرِيحَا قَائِلَيْنِ: ");
INSERT INTO arb_vd_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا. كَمَا أَمَرَ ٱلرَّبُّ مُوسَى». وَبَنِي إِسْرَائِيلَ ٱلْخَارِجِينَ مِنْ أَرْضِ مِصْرَ: ");
INSERT INTO arb_vd_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","رَأُوبَيْنُ بِكْرُ إِسْرَائِيلَ، بَنُو رَأُوبَيْنَ: لِحَنُوكَ عَشِيرَةُ ٱلْحَنُوكِيِّينَ. لِفَلُّو عَشِيرَةُ ٱلْفَلُّوِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","لِحَصْرُونَ عَشِيرَةُ ٱلْحَصْرُونِيِّينَ. لِكَرْمِي عَشِيرَةُ ٱلْكَرْمِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","هَذِهِ عَشَائِرُ ٱلرَّأُوبَيْنِيِّينَ، وَكَانَ ٱلْمَعْدُودُونَ مِنْهُمْ ثَلَاثَةً وَأَرْبَعِينَ أَلْفًا وَسَبْعَ مِئَةٍ وَثلَاثِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","وَٱبْنُ فَلُّو أَلِيآبُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","وَبَنُو أَلِيآبَ: نَمُوئِيلُ وَدَاثَانُ وَأَبِيرَامُ، وَهُمَا دَاثَانُ وَأَبِيرَامُ ٱلْمَدْعُوَّانِ مِنَ ٱلْجَمَاعَةِ ٱللَّذَانِ خَاصَمَا مُوسَى وَهَارُونَ فِي جَمَاعَةِ قُورَحَ حِينَ خَاصَمُوا ٱلرَّبَّ، ");
INSERT INTO arb_vd_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","فَفَتَحَتِ ٱلْأَرْضُ فَاهَا وَٱبْتَلَعَتْهُمَا مَعَ قُورَحَ حِينَ مَاتَ ٱلْقَوْمُ بِإِحْرَاقِ ٱلنَّارِ، مِئَتَيْنِ وَخَمْسِينَ رَجُلًا. فَصَارُوا عِبْرَةً. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","وَأَمَّا بَنُو قُورَحَ فَلَمْ يَمُوتُوا. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","بَنُو شِمْعُونَ حَسَبَ عَشَائِرِهِمْ: لِنَمُوئِيلَ عَشِيرَةُ ٱلنَّمُوئِيلِيِّينَ. لِيَامِينَ عَشِيرَةُ ٱلْيَامِينِيِّينَ. لِيَاكِينَ عَشِيرَةُ ٱلْيَاكِينِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","لِزَارَحَ عَشِيرَةُ ٱلزَّارَحِيِّينَ. لِشَأُولَ عَشِيرَةُ ٱلشَّأُولِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","هَذِهِ عَشَائِرُ ٱلشِّمْعُونِيِّينَ، ٱثْنَانِ وَعِشْرُونَ أَلْفًا وَمِئَتَانِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","بَنُو جَادَ حَسَبَ عَشَائِرِهِمْ: لِصِفُونَ عَشِيرَةُ ٱلصِّفُونِيِّينَ. لِحَجِّي عَشِيرَةُ ٱلْحَجِّيِّينَ. لِشُونِي عَشِيرَةُ ٱلشُّونِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","لِأُزْنِي عَشِيرَةُ ٱلْأُزْنِيِّينَ. لِعِيرِي عَشِيرَةُ ٱلْعِيرِيِّينَ ");
INSERT INTO arb_vd_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","لِأَرُودَ عَشِيرَةُ ٱلْأَرُودِيِّينَ. لِأَرْئِيلِي عَشِيرَةُ ٱلْأَرْئِيلِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","هَذِهِ عَشَائِرُ بَنِي جَادَ حَسَبَ عَدَدِهِمْ، أَرْبَعُونَ أَلْفًا وَخَمْسُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","اِبْنَا يَهُوذَا: عِيرُ وَأُونَانُ، وَمَاتَ عِيرُ وَأُونَانُ فِي أَرْضِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","فَكَانَ بَنُو يَهُوذَا حَسَبَ عَشَائِرِهِمْ: لِشِيلَةَ عَشِيرَةُ ٱلشِّيلِيِّينَ. وَلِفَارَصَ عَشِيرَةُ ٱلْفَارَصِيِّينَ. وَلِزَارَحَ عَشِيرَةُ ٱلزَّارَحِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","وَكَانَ بَنُو فَارَصَ: لِحَصْرُونَ عَشِيرَةُ ٱلْحَصْرُونِيِّينَ. وَلِحَامُولَ عَشِيرَةُ ٱلْحَامُولِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","هَذِهِ عَشَائِرُ يَهُوذَا حَسَبَ عَدَدِهِمْ، سِتَّةٌ وَسَبْعُونَ أَلْفًا وَخَمْسُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","بَنُو يَسَّاكَرَ حَسَبَ عَشَائِرِهِمْ: لِتُولَاعَ عَشِيرَةُ ٱلتُّولَاعِيِّينَ. وَلِفُوَّةَ عَشِيرَةُ ٱلْفُوِّيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","وَلِيَاشُوبَ عَشِيرَةُ ٱلْيَاشُوبِيِّينَ. وَلِشِمْرُونَ عَشِيرَةُ ٱلشِّمْرُونِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","هَذِهِ عَشَائِرُ يَسَّاكَرَ حَسَبَ عَدَدِهِمْ، أَرْبَعَةٌ وَسِتُّونَ أَلْفًا وَثَلَاثُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","بَنُو زَبُولُونَ حَسَبَ عَشَائِرِهِمْ: لِسَارَدَ عَشِيرَةُ ٱلسَّارَدِيِّينَ. وَلإِيلُونَ عَشِيرَةُ ٱلْإِيلُونِيِّينَ. وَلِيَاحِلْئِيلَ عَشِيرَةُ ٱلْيَاحِلْئِيلِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","هَذِهِ عَشَائِرُ ٱلزَّبُولُونِيِّينَ حَسَبَ عَدَدِهِمْ، سِتُّونَ أَلْفًا وَخَمْسُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","اِبْنَا يُوسُفَ حَسَبَ عَشَائِرِهِمَا مَنَسَّى وَأَفْرَايِمُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","بَنُو مَنَسَّى: لِمَاكِيرَ عَشِيرَةُ ٱلْمَاكِيرِيِّينَ. وَمَاكِيرُ وَلَدَ جِلْعَادَ. وَلِجِلْعَادَ عَشِيرَةُ ٱلْجِلْعَادِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","هَؤُلَاءِ بَنُو جِلْعَادَ: لِإِيعَزَرَ عَشِيرَةُ ٱلْإِيعَزَرِيِّينَ. لِحَالَقَ عَشِيرَةُ ٱلْحَالَقِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","لِأَسْرِيئِيلَ عَشِيرَةُ ٱلْأَسْرِيئِيلِيِّينَ. لِشَكَمَ عَشِيرَةُ ٱلشَّكَمِيِّينَ ");
INSERT INTO arb_vd_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","لِشَمِيدَاعَ عَشِيرَةُ ٱلشَّمِيدَاعِيِّينَ. لِحَافَرَ عَشِيرَةُ ٱلْحَافَرِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","وَأَمَّا صَلُفْحَادُ بْنُ حَافَرَ فَلَمْ يَكُنْ لَهُ بَنُونَ بَلْ بَنَاتٌ. وَأَسْمَاءُ بَنَاتِ صَلُفْحَادَ: مَحْلَةُ وَنُوعَةُ وَحُجْلَةُ وَمِلْكَةُ وَتِرْصَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","هَذِهِ عَشَائِرُ مَنَسَّى، وَٱلْمَعْدُودُونَ مِنْهُمُ ٱثْنَانِ وَخَمْسُونَ أَلْفًا وَسَبْعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","وَهَؤُلَاءِ بَنُو أَفْرَايِمَ حَسَبَ عَشَائِرِهِمْ: لِشُوتَالَحَ عَشِيرَةُ ٱلشُّوتَالَحِيِّينَ. لِبَاكَرَ عَشِيرَةُ ٱلْبَاكَرِيِّينَ. لِتَاحَنَ عَشِيرَةُ ٱلتَّاحَنِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","وَهَؤُلَاءِ بَنُو شُوتَالَحَ: لِعِيرَانَ عَشِيرَةُ ٱلْعِيرَانِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","هَذِهِ عَشَائِرُ بَنِي أَفْرَايِمَ حَسَبَ عَدَدِهِمِ، ٱثْنَانِ وَثَلَاثُونَ أَلْفًا وَخَمْسُ مِئَةٍ. هَؤُلَاءِ بَنُو يُوسْفَ حَسَبَ عَشَائِرِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","بَنُو بَنْيَامِينَ حَسَبَ عَشَائِرِهِمْ: لِبَالَعَ عَشِيرَةُ ٱلْبَالَعِيِّينَ. لِأَشْبِيلَ عَشِيرَةُ ٱلْأَشْبِيلِيِّينَ. لِأَحِيرَامَ عَشِيرَةُ ٱلْأَحِيرَامِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","لِشَفُوفَامَ عَشِيرَةُ ٱلشَّفُوفَامِيِّينَ. لِحُوفَامَ عَشِيرَةُ ٱلْحُوفَامِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","وَكَانَ ٱبْنَا بَالَعَ: أَرْدَ وَنُعْمَانَ. لِأَرْدَ عَشِيرَةُ ٱلْأَرْدِيِّينَ، وَلِنُعْمَانَ عَشِيرَةُ ٱلنُّعْمَانِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","هَؤُلَاءِ بَنُو بَنْيَامِينَ حَسَبَ عَشَائِرِهِمْ، وَٱلْمَعْدُودُونَ مِنْهُمْ خَمْسَةٌ وَأَرْبَعُونَ أَلْفًا وَسِتُّ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","هَؤُلَاءِ بَنُو دَانَ حَسَبَ عَشَائِرِهِمْ: لِشُوحَامَ عَشِيرَةُ ٱلشُّوحَامِيِّينَ. هَذِهِ قَبَائِلُ دَانَ حَسَبَ عَشَائِرِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","جَمِيعُ عَشَائِرِ ٱلشُّوحَامِيِّينَ حَسَبَ عَدَدِهِمْ، أَرْبَعَةٌ وَسِتُّونَ أَلْفًا وَأَرْبَعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","بَنُو أَشِيرَ حَسَبَ عَشَائِرِهِمْ: لِيِمْنَةَ عَشِيرَةُ ٱلْيِمْنِيِّينَ. لِيِشْوِي عَشِيرَةُ ٱلْيِشْوِيِّينَ. لِبَرِيعَةَ عَشِيرَةُ ٱلْبَرِيعِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","لِبَنِي بَرِيعَةَ: لِحَابَرَ عَشِيرَةُ ٱلْحَابَرِيِّينَ. لِمَلْكِيئِيلَ عَشِيرَةُ ٱلْمَلْكِيئِيلِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","وَٱسْمُ ٱبْنَةِ أَشِيرَ سَارَحُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","هَذِهِ عَشَائِرُ بَنِي أَشِيرَ حَسَبَ عَدَدِهِمْ، ثَلَاثَةٌ وَخَمْسُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","بَنُو نَفْتَالِي حَسَبَ عَشَائِرِهِمْ: لِيَاحَصْئِيلَ عَشِيرَةُ ٱلْيَاحَصْئِيلِيِّينَ. لِجُونِي عَشِيرَةُ ٱلْجُونِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","لِيِصِرَ عَشِيرَةُ ٱلْيِصِرِيِّينَ. لِشِلِّيمَ عَشِيرَةُ ٱلشِّلِّيمِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","هَذِهِ قَبَائِلُ نَفْتَالِي حَسَبَ عَشَائِرِهِمْ، وَٱلْمَعْدُودُونَ مِنْهُمْ خَمْسَةٌ وَأَرْبَعُونَ أَلْفًا وَأَرْبَعُ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","هَؤُلَاءِ ٱلْمَعْدُودُونَ مِنْ بَنِي إِسْرَائِيلَ سِتُّ مِئَةِ أَلْفٍ وَأَلْفٌ وَسَبْعُ مِئَةٍ وَثَلَاثُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ثُمَّ كَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«لِهَؤُلَاءِ تُقْسَمُ ٱلْأَرْضُ نَصِيبًا عَلَى عَدَدِ ٱلْأَسْمَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","اَلْكَثِيرُ تُكَثِّرُ لَهُ نَصِيبَهُ، وَٱلْقَلِيلُ تُقَلِّلُ لَهُ نَصِيبَهُ. كُلُّ وَاحِدٍ حَسَبَ ٱلْمَعْدُودِينَ مِنْهُ يُعْطَى نَصِيبَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","إِنَّمَا بِٱلْقُرْعَةِ تُقْسَمُ ٱلْأَرْضُ. حَسَبَ أَسْمَاءِ أَسْبَاطِ آبَائِهِمْ يَمْلِكُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","حَسَبَ ٱلْقُرْعَةِ يُقْسَمُ نَصِيبُهُمْ بَيْنَ كَثِيرٍ وَقَلِيلٍ». ");
INSERT INTO arb_vd_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","وَهَؤُلَاءِ ٱلْمَعْدُودُونَ مِنَ ٱللَّاوِيِّينَ حَسَبَ عَشَائِرِهِمْ: لِجِرْشُونَ عَشِيرَةُ ٱلْجِرْشُونِيِّينَ. لِقَهَاتَ عَشِيرَةُ ٱلْقَهَاتِيِّينَ. لِمَرَارِي عَشِيرَةُ ٱلْمَرَارِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","هَذِهِ عَشَائِرُ لَاوِي: عَشِيرَةُ ٱللِّبْنِيِّينَ وَعَشِيرَةُ ٱلْحَبْرُونِيِّينَ وَعَشِيرَةُ ٱلْمَحْلِيِّينَ وَعَشِيرَةُ ٱلْمُوشِيِّينَ وَعَشِيرَةُ ٱلْقُورَحِيِّينَ. وَأَمَّا قَهَاتُ فَوَلَدَ عَمْرَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","وَٱسْمُ ٱمْرَأَةِ عَمْرَامَ يُوكَابَدُ بِنْتُ لَاوِي ٱلَّتِي وُلِدَتْ لِلَاوِي فِي مِصْرَ، فَوَلَدَتْ لِعَمْرَامَ هَارُونَ وَمُوسَى وَمَرْيَمَ أُخْتَهُمَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","وَلِهَارُونَ وُلِدَ نَادَابُ وَأَبِيهُو وَأَلِعَازَارُ وَإِيثَامَارُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","وَأَمَّا نَادَابُ وَأَبِيهُو فَمَاتَا عِنْدَمَا قَرَّبَا نَارًا غَرِيبَةً أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","وَكَانَ ٱلْمَعْدُودُونَ مِنْهُمْ ثَلَاثَةً وَعِشْرِينَ أَلْفًا، كُلَّ ذَكَرٍ مِنِ ٱبْنِ شَهْرٍ فَصَاعِدًا. لِأَنَّهُمْ لَمْ يُعَدُّوا بَيْنَ بَنِي إِسْرَائِيلَ، إِذْ لَمْ يُعْطَ لَهُمْ نَصِيبٌ بَيْنَ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","هَؤُلَاءِ هُمُ ٱلَّذِينَ عَدَّهُمْ مُوسَى وَأَلِعَازَارُ ٱلْكَاهِنُ حِينَ عَدَّا بَنِي إِسْرَائِيلَ فِي عَرَبَاتِ مُوآبَ عَلَى أُرْدُنِّ أَرِيحَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","وَفِي هَؤُلَاءِ لَمْ يَكُنْ إِنْسَانٌ مِنَ ٱلَّذِينَ عَدَّهُمْ مُوسَى وَهَارُونُ ٱلْكَاهِنُ حِينَ عَدَّا بَنِي إِسْرَائِيلَ فِي بَرِّيَّةِ سِينَاءَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","لِأَنَّ ٱلرَّبَّ قَالَ لَهُمْ إِنَّهُمْ يَمُوتُونَ فِي ٱلْبَرِّيَّةِ، فَلَمْ يَبْقَ مِنْهُمْ إِنْسَانٌ إِلَا كَالِبُ بْنُ يَفُنَّةَ وَيَشُوعُ بْنُ نُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","فَتَقَدَّمَتْ بَنَاتُ صَلُفْحَادَ بْنِ حَافَرَ بْنِ جِلْعَادَ بْنِ مَاكِيرَ بْنِ مَنَسَّى، مِنْ عَشَائِرِ مَنَسَّى بْنِ يُوسُفَ. وَهَذِهِ أَسْمَاءُ بَنَاتِهِ: مَحْلَةُ وَنُوعَةُ وَحُجْلَةُ وَمِلْكَةُ وَتِرْصَةُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","وَوَقَفْنَ أَمَامَ مُوسَى وَأَلِعَازَارَ ٱلْكَاهِنِ وَأَمَامَ ٱلرُّؤَسَاءِ وَكُلِّ ٱلْجَمَاعَةِ لَدَى بَابِ خَيْمَةِ ٱلِٱجْتِمَاعِ قَائِلَاتٍ: ");
INSERT INTO arb_vd_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«أَبُونَا مَاتَ فِي ٱلْبَرِّيَّةِ، وَلَمْ يَكُنْ فِي ٱلْقَوْمِ ٱلَّذِينَ ٱجْتَمَعُوا عَلَى ٱلرَّبِّ فِي جَمَاعَةِ قُورَحَ، بَلْ بِخَطِيَّتِهِ مَاتَ وَلَمْ يَكُنْ لَهُ بَنُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","لِمَاذَا يُحْذَفُ ٱسْمُ أَبِينَا مِنْ بَيْنِ عَشِيرَتِهِ لِأَنَّهُ لَيْسَ لَهُ ٱبْنٌ؟ أَعْطِنَا مُلْكًا بَيْنَ إِخْوةِ أَبِينَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","فَقَدَّمَ مُوسَى دَعْوَاهُنَّ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","فَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«بِحَقٍّ تَكَلَّمَتْ بَنَاتُ صَلُفْحَادَ، فَتُعْطِيهِنَّ مُلْكَ نَصِيبٍ بَيْنَ إِخْوَةِ أَبِيهنَّ، وَتَنْقُلُ نَصِيبَ أَبِيهِنَّ إِلَيْهِنَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","وَتُكَلِّمُ بَنِي إِسْرَائِيلَ قَائِلًا: أَيُّمَا رَجُلٍ مَاتَ وَلَيْسَ لَهُ ٱبْنٌ، تَنْقُلُونَ مُلْكَهُ إِلَى ٱبْنَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","وَإِنْ لَمْ تَكُنْ لَهُ ٱبْنَةٌ، تُعْطُوا مُلْكَهُ لِإِخْوَتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","وَإِنْ لَمْ يَكُنْ لَهُ إِخْوَةٌ، تُعْطُوا مُلْكَهُ لِإِخوَةِ أَبِيهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","وَإِنْ لَمْ يَكُنْ لِأَبِيهِ إِخْوَةٌ، تُعْطُوا مُلْكَهُ لِنَسِيبِهِ ٱلْأَقْرَبِ إِلَيْهِ مِنْ عَشِيرَتِهِ فَيَرِثُهُ». فَصَارَتْ لِبَنِي إِسْرَائِيلَ فَرِيضَةَ قَضَاءٍ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","وَقَالَ ٱلرَّبُّ لِمُوسَى: «ٱصْعَدْ إِلَى جَبَلِ عَبَارِيمَ هَذَا وَٱنْظُرِ ٱلْأَرْضَ ٱلَّتِي أَعْطَيْتُ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","وَمَتَى نَظَرْتَهَا، تُضَمُّ إِلَى قَوْمِكَ أَنْتَ أَيْضًا كَمَا ضُمَّ هَارُونُ أَخُوكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","لِأَنَّكُمَا فِي بَرِّيَّةِ صِينَ، عِنْدَ مُخَاصَمَةِ ٱلْجَمَاعَةِ، عَصَيْتُمَا قَوْلِي أَنْ تُقَدِّسَانِي بِٱلْمَاءِ أَمَامَ أَعْيُنِهِمْ». ذَلِكَ مَاءُ مَرِيبَةِ قَادَشَ فِي بَرِّيَّةِ صِينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","فَكَلَّمَ مُوسَى ٱلرَّبِّ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«لِيُوَكِّلِ ٱلرَّبُّ إِلَهُ أَرْوَاحِ جَمِيعِ ٱلْبَشَرِ رَجُلًا عَلَى ٱلْجَمَاعَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","يَخْرُجُ أَمَامَهُمْ وَيَدْخُلُ أَمَامَهُمْ وَيُخْرِجُهُمْ وَيُدْخِلُهُمْ، لِكَيْلَا تَكُونَ جَمَاعَةُ ٱلرَّبِّ كَٱلْغَنَمِ ٱلَّتِي لَا رَاعِيَ لَهَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","فَقَالَ ٱلرَّبُّ لِمُوسَى: «خُذْ يَشُوعَ بْنَ نُونَ، رَجُلًا فِيهِ رُوحٌ، وَضَعْ يَدَكَ عَلَيْهِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","وَأَوْقِفْهُ قُدَّامَ أَلِعَازَارَ ٱلْكَاهِنِ وَقُدَّامَ كُلِّ ٱلْجَمَاعَةِ، وَأَوْصِهِ أَمَامَ أَعْيُنِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","وَٱجْعَلْ مِنْ هَيْبَتِكَ عَلَيْهِ لِكَيْ يَسْمَعَ لَهُ كُلُّ جَمَاعَةِ بَنِي إِسْرَائِيلَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","فَيَقِفَ أَمَامَ أَلِعَازَارَ ٱلْكَاهِنِ فَيَسْأَلُ لَهُ بِقَضَاءِ ٱلْأُورِيمِ أَمَامَ ٱلرَّبِّ. حَسَبَ قَوْلِهِ يَخْرُجُونَ، وَحَسَبَ قَوْلِهِ يَدْخُلُونَ، هُوَ وَكُلُّ بَنِي إِسْرَائِيلَ مَعَهُ، كُلُّ ٱلْجَمَاعَةِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","فَفَعَلَ مُوسَى كَمَا أَمَرَهُ ٱلرَّبُّ. أَخَذَ يَشُوعَ وَأَوْقَفَهُ قُدَّامَ أَلِعَازَارَ ٱلْكَاهِنِ وَقُدَّامَ كُلِّ ٱلْجَمَاعَةِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","وَوَضَعَ يَدَيْهِ عَلَيْهِ وَأَوْصَاهُ كَمَا تَكَلَّمَ ٱلرَّبُّ عَنْ يَدِ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: قُرْبَانِي، طَعَامِي مَعَ وَقَائِدِي رَائِحَةُ سَرُورِي، تَحْرِصُونَ أَنْ تُقَرِّبُوهُ لِي فِي وَقْتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","وَقُلْ لَهُمْ: هَذَا هُوَ ٱلْوَقُودُ ٱلَّذِي تُقَرِّبُونَ لِلرَّبِّ: خَرُوفَانِ حَوْلِيَّانِ صَحِيحَانِ لِكُلِّ يَوْمٍ مُحْرَقَةً دَائِمَةً. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ٱلْخَرُوفُ ٱلْوَاحِدُ تَعْمَلُهُ صَبَاحًا، وَٱلْخَرُوفُ ٱلثَّانِي تَعْمَلُهُ بَيْنَ ٱلْعَشَاءَيْنِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","وَعُشْرَ ٱلْإِيفَةِ مِنْ دَقِيقٍ مَلْتُوتٍ بِرُبْعِ ٱلْهِينِ مِنْ زَيْتِ ٱلرَّضِّ تَقْدِمَةً. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","مُحْرَقَةٌ دَائِمَةٌ. هِيَ ٱلْمَعْمُولَةُ فِي جَبَلِ سِينَاءَ. لِرَائِحَةِ سَرُورٍ، وَقُودًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","وَسَكِيبُهَا رُبْعُ ٱلْهِينِ لِلْخَرُوفِ ٱلْوَاحِدِ. فِي ٱلْقُدْسِ ٱسْكُبْ سَكِيبَ مُسْكِرٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","وَٱلْخَرُوفُ ٱلثَّانِي تَعْمَلُهُ بَيْنَ ٱلْعَشَاءَيْنِ كَتَقْدِمَةِ ٱلصَّبَاحِ، وَكَسَكِيبِهِ تَعْمَلُهُ وَقُودَ رَائِحَةِ سَرُورٍ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«وَفِي يَوْمِ ٱلسَّبْتِ خَرُوفَانِ حَوْلِيَّانِ صَحِيحَانِ، وَعُشْرَانِ مِنْ دَقِيقٍ مَلْتُوتٍ بِزَيْتٍ تَقْدِمَةً مَعَ سَكِيبِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","مُحْرَقَةُ كُلِّ سَبْتٍ، فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَسَكِيبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«وَفِي رُؤُوسِ شُهُورِكُمْ تُقَرِّبُونَ مُحْرَقَةً لِلرَّبِّ: ثَوْرَيْنِ ٱبْنَيْ بَقَرٍ، وَكَبْشًا وَاحِدًا، وَسَبْعَةَ خِرَافٍ حَوْلِيَّةٍ صَحِيحَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","وَثَلَاثَةَ أَعْشَارٍ مِنْ دَقِيقٍ مَلْتُوتٍ بِزَيْتٍ تَقْدِمَةً لِكُلِّ ثَوْرٍ. وَعُشْرَيْنِ مِنْ دَقِيقٍ مَلْتُوتٍ بِزَيْتٍ تَقْدِمَةً لِلْكَبْشِ ٱلْوَاحِدِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","وَعُشْرًا وَاحِدًا مِنْ دَقِيقٍ مَلْتُوتٍ بِزَيْتٍ تَقْدِمَةً لِكُلِّ خَرُوفٍ. مُحْرَقَةً رَائِحَةَ سَرُورٍ وَقُودًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","وَسَكَائِبُهُنَّ تَكُونُ نِصْفَ ٱلْهِينِ لِلثَّوْرِ، وَثُلْثَ ٱلْهِينِ لِلْكَبْشِ، وَرُبْعَ ٱلْهِينِ لِلْخَرُوفِ مِنْ خَمْرٍ. هَذِهِ مُحْرَقَةُ كُلِّ شَهْرٍ مِنْ أَشْهُرِ ٱلسَّنَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","وَتَيْسًا وَاحِدًا مِنَ ٱلْمَعْزِ ذَبِيحَةَ خَطِيَّةٍ لِلرَّبِّ. فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ يُقَرَّبُ مَعَ سَكِيبِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«وَفِي ٱلشَّهْرِ ٱلْأَوَّلِ، فِي ٱلْيَوْمِ ٱلرَّابِعَ عَشَرَ مِنَ ٱلشَّهْرِ فِصْحٌ لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","وَفِي ٱلْيَوْمِ ٱلْخَامِسَ عَشَرَ مِنْ هَذَا ٱلشَّهْرِ عِيدٌ. سَبْعَةَ أَيَّامٍ يُؤْكَلُ فَطِيرٌ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","فِي ٱلْيَوْمِ ٱلْأَوَّلِ مَحْفَلٌ مُقَدَّسٌ. عَمَلًا مَّا مِنَ ٱلشُّغْلِ لَا تَعْمَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","وَتُقَرِّبُونَ وَقُودًا مُحْرَقَةً لِلرَّبِّ: ثَوْرَيْنِ ٱبْنَيْ بَقَرٍ، وَكَبْشًا وَاحِدًا، وَسَبْعَةَ خِرَافٍ حَوْلِيَّةٍ. صَحِيحَةً تَكُونُ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","وَتَقْدِمَتُهُنَّ مِنْ دَقِيقٍ مَلْتُوتٍ بِزَيْتٍ: ثَلَاثَةَ أَعْشَارٍ تَعْمَلُونَ لِلثَّوْرِ، وَعُشْرَيْنِ لِلْكَبْشِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","وَعُشْرًا وَاحِدًا تَعْمَلُ لِكُلِّ خَرُوفٍ مِنَ ٱلسَّبْعَةِ ٱلْخِرَافِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","وَتَيْسًا وَاحِدًا ذَبِيحَةَ خَطِيَّةٍ لِلتَّكْفِيرِ عَنْكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","فَضْلًا عَنْ مُحْرَقَةِ ٱلصَّبَاحِ ٱلَّتِي لِمُحْرَقَةٍ دَائِمَةٍ تَعْمَلُونَ هَذِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","هَكَذَا تَعْمَلُونَ كُلَّ يَوْمٍ، سَبْعَةَ أَيَّامٍ طَعَامَ وَقُودِ رَائِحَةِ سَرُورٍ لِلرَّبِّ، فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ يُعْمَلُ مَعَ سَكِيبِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","وَفِي ٱلْيَوْمِ ٱلسَّابِعِ يَكُونُ لَكُمْ مَحْفَلٌ مُقَدَّسٌ. عَمَلًا مَّا مِنَ ٱلشُّغْلِ لَا تَعْمَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«وَفِي يَوْمِ ٱلْبَاكُورَةِ، حِينَ تُقَرِّبُونَ تَقْدِمَةً جَدِيدَةً لِلرَّبِّ فِي أَسَابِيعِكُمْ، يَكُونُ لَكُمْ مَحْفَلٌ مُقَدَّسٌ. عَمَلًا مَّا مِنَ ٱلشُّغْلِ لَا تَعْمَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","وَتُقَرِّبُونَ مُحْرَقَةً لِرَائِحَةِ سَرُورٍ لِلرَّبِّ: ثَوْرَيْنِ ٱبْنَيْ بَقَرٍ، وَكَبْشًا وَاحِدًا، وَسَبْعَةَ خِرَافٍ حَوْلِيَّةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","وَتَقْدِمَتُهُنَّ مِنْ دَقِيقٍ مَلْتُوتٍ بِزَيْتٍ: ثَلَاثَةَ أَعْشَارٍ لِكُلِّ ثَوْرٍ، وَعُشْرَيْنِ لِلْكَبْشِ ٱلْوَاحِدِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","وَعُشْرًا وَاحِدًا لِكُلِّ خَرُوفٍ مِنَ ٱلسَّبْعَةِ ٱلْخِرَافِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","وَتَيْسًا وَاحِدًا مِنَ ٱلْمَعْزِ لِلتَّكْفِيرِ عَنْكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَتَقْدِمَتِهَا تَعْمَلُونَ. مَعَ سَكَائِبِهِنَّ صَحِيحَاتٍ تَكُونُ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«وَفِي ٱلشَّهْرِ ٱلسَّابِعِ، فِي ٱلْأَوَّلِ مِنَ ٱلشَّهْرِ، يَكُونُ لَكُمْ مَحْفَلٌ مُقَدَّسٌ. عَمَلًا مَّا مِنَ ٱلشُّغْلِ لَا تَعْمَلُوا. يَوْمَ هُتَافِ بُوقٍ يَكُونُ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","وَتَعْمَلُونَ مُحْرَقَةً لِرَائِحَةِ سَرُورٍ لِلرَّبِّ: ثَوْرًا وَاحِدًا ٱبْنَ بَقَرٍ، وَكَبْشًا وَاحِدًا، وَسَبْعَةَ خِرَافٍ حَوْلِيَّةٍ صَحِيحَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","وَتَقْدِمَتَهُنَّ مِنْ دَقِيقٍ مَلْتُوتٍ بِزَيْتٍ: ثَلَاثَةَ أَعْشَارٍ لِلثَّوْرِ، وَعُشْرَيْنِ لِلْكَبْشِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","وَعُشْرًا وَاحِدًا لِكُلِّ خَرُوفٍ مِنَ ٱلسَّبْعَةِ ٱلْخِرَافِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","وَتَيْسًا وَاحِدًا مِنَ ٱلْمَعْزِ ذَبِيحَةَ خَطِيَّةٍ لِلتَّكْفِيرِ عَنْكُمْ، ");
INSERT INTO arb_vd_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","فَضْلًا عَنْ مُحْرَقَةِ ٱلشَّهْرِ وَتَقْدِمَتِهَا وَٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَتَقْدِمَتِهَا مَعَ سَكَائِبِهِنَّ كَعَادَتِهِنَّ رَائِحَةَ سَرُورٍ وَقُودًا لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«وَفِي عَاشِرِ هَذَا ٱلشَّهْرِ ٱلسَّابِعِ، يَكُونُ لَكُمْ مَحْفَلٌ مُقَدَّسٌ، وَتُذَلِّلُونَ أَنْفُسَكُمْ. عَمَلًا مَّا لَا تَعْمَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","وَتُقَرِّبُونَ مُحْرَقَةً لِلرَّبِّ رَائِحَةَ سَرُورٍ: ثَوْرًا وَاحِدًا ٱبْنَ بَقَرٍ، وَكَبْشًا وَاحِدًا، وَسَبْعَةَ خِرَافٍ حَوْلِيَّةٍ. صَحِيحَةً تَكُونُ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","وَتَقْدِمَتُهُنَّ مِنْ دَقِيقٍ مَلْتُوتٍ بِزَيْتٍ: ثَلَاثَةُ أَعْشَارٍ لِلثَّوْرِ، وَعُشْرَانِ لِلْكَبْشِ ٱلْوَاحِدِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","وَعُشْرٌ وَاحِدٌ لِكُلِّ خَرُوفٍ مِنَ ٱلسَّبْعَةِ ٱلْخِرَافِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","وَتَيْسًا وَاحِدًا مِنَ ٱلْمَعْزِ ذَبِيحَةَ خَطِيَّةٍ، فَضْلًا عَنْ ذَبِيحَةِ ٱلْخَطِيَّةِ لِلْكَفَّارَةِ وَٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَتَقْدِمَتِهَا مَعَ سَكَائِبِهِنَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«وَفِي ٱلْيَوْمِ ٱلْخَامِسَ عَشَرَ مِنَ ٱلشَّهْرِ ٱلسَّابِعِ، يَكُونُ لَكُمْ مَحْفَلٌ مُقَدَّسٌ. عَمَلًا مَّا مِنَ ٱلشُّغْلِ لَا تَعْمَلُوا. وَتُعَيِّدُونَ عِيدًا لِلرَّبِّ سَبْعَةَ أَيَّامٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","وَتُقَرِّبُونَ مُحْرَقَةً، وَقُودَ رَائِحَةِ سَرُورٍ لِلرَّبِّ: ثَلَاثَةَ عَشَرَ ثَوْرًا أَبْنَاءَ بَقَرٍ، وَكَبْشَيْنِ، وَأَرْبَعَةَ عَشَرَ خَرُوفًا حَوْلِيًّا. صَحِيحَةً تَكُونُ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","وَتَقْدِمَتُهُنَّ مِنْ دَقِيقٍ مَلْتُوتٍ بِزَيْتٍ: ثَلَاثَةُ أَعْشَارٍ لِكُلِّ ثَوْرٍ مِنَ ٱلثَّلَاثَةَ عَشَرَ ثَوْرًا، وَعُشْرَانِ لِكُلِّ كَبْشٍ مِنَ ٱلْكَبْشَيْنِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","وَعُشْرٌ وَاحِدٌ لِكُلِّ خَرُوفٍ مِنَ ٱلْأَرْبَعَةَ عَشَرَ خَرُوفًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","وَتَيْسًا وَاحِدًا مِنَ ٱلْمَعْزِ ذَبِيحَةَ خَطِيَّةٍ، فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَتَقْدِمَتِهَا وَسَكِيبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«وَفِي ٱلْيَوْمِ ٱلثَّانِي: ٱثْنَيْ عَشَرَ ثَوْرًا أَبْنَاءَ بَقَرٍ، وَكَبْشَيْنِ، وَأَرْبَعَةَ عَشَرَ خَرُوفًا حَوْلِيًّا صَحِيحًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","وَتَقْدِمَتَهُنَّ وَسَكَائِبَهُنَّ لِلثِّيرَانِ وَٱلْكَبْشَيْنِ وَٱلْخِرَافِ حَسَبَ عَدَدِهِنَّ كَٱلْعَادَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","وَتَيْسًا وَاحِدًا مِنَ ٱلْمَعْزِ ذَبِيحَةَ خَطِيَّةٍ، فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَتَقْدِمَتِهَا مَعَ سَكَائِبِهِنَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«وَفِي ٱلْيَوْمِ ٱلثَّالِثِ: أَحَدَ عَشَرَ ثَوْرًا، وَكَبْشَيْنِ، وَأَرْبَعَةَ عَشَرَ خَرُوفًا حَوْلِيًّا صَحِيحًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","وَتَقْدِمَتَهُنَّ وَسَكَائِبَهُنَّ لِلثِّيرَانِ وَٱلْكَبْشَيْنِ وَٱلْخِرَافِ حَسَبَ عَدَدِهِنَّ كَٱلْعَادَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","وَتَيْسًا وَاحِدًا لِذَبِيحَةِ خَطِيَّةٍ، فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَتَقْدِمَتِهَا وَسَكِيبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«وَفِي ٱلْيَوْمِ ٱلرَّابِعِ: عَشَرَةَ ثِيرَانٍ، وَكَبْشَيْنِ، وَأَرْبَعَةَ عَشَرَ خَرُوفًا حَوْلِيًّا صَحِيحًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","وَتَقْدِمَتَهُنَّ وَسَكَائِبَهُنَّ لِلثِّيرَانِ وَٱلْكَبْشَيْنِ وَٱلْخِرَافِ حَسَبَ عَدَدِهِنَّ كَٱلْعَادَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","وَتَيْسًا وَاحِدًا مِنَ ٱلْمَعْزِ لِذَبِيحَةِ خَطِيَّةٍ، فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَتَقْدِمَتِهَا وَسَكِيبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«وَفِي ٱلْيَوْمِ ٱلْخَامِسِ: تِسْعَةَ ثِيرَانٍ، وَكَبْشَيْنِ، وَأَرْبَعَةَ عَشَرَ خَرُوفًا حَوْلِيًّا صَحِيحًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","وَتَقْدِمَتَهُنَّ وَسَكَائِبَهُنَّ لِلثِّيرَانِ وَٱلْكَبْشَيْنِ وَٱلْخِرَافِ حَسَبَ عَدَدِهِنَّ كَٱلْعَادَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","وَتَيْسًا وَاحِدًا لِذَبِيحَةِ خَطِيَّةٍ، فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَتَقْدِمَتِهَا وَسَكِيبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«وَفِي ٱلْيَوْمِ ٱلسَّادِسِ: ثَمَانِيَةَ ثِيرَانٍ، وَكَبْشَيْنِ، وَأَرْبَعَةَ عَشَرَ خَرُوفًا حَوْلِيًّا صَحِيحًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","وَتَقْدِمَتَهُنَّ وَسَكَائِبَهُنَّ لِلثِّيرَانِ وَٱلْكَبْشَيْنِ وَٱلْخِرَافِ حَسَبَ عَدَدِهِنَّ كَٱلْعَادَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","وَتَيْسًا وَاحِدًا لِذَبِيحَةِ خَطِيَّةٍ، فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَتَقْدِمَتِهَا وَسَكِيبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«وَفِي ٱلْيَوْمِ ٱلسَّابِعِ: سَبْعَةَ ثِيرَانٍ، وَكَبْشَيْنِ، وَأَرْبَعَةَ عَشَرَ خَرُوفًا حَوْلِيًّا صَحِيحًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","وَتَقْدِمَتَهُنَّ وَسَكَائِبَهُنَّ لِلثِّيرَانِ وَٱلْكَبْشَيْنِ وَٱلْخِرَافِ حَسَبَ عَدَدِهِنَّ كَعَادَتِهِنَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","وَتَيْسًا وَاحِدًا لِذَبِيحَةِ خَطِيَّةٍ، فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَتَقْدِمَتِهَا وَسَكِيبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«فِي ٱلْيَوْمِ ٱلثَّامِنِ: يَكُونُ لَكُمُ ٱعْتِكَافٌ. عَمَلًا مَّا مِنَ ٱلشُّغْلِ لَا تَعْمَلُوا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","وَتُقَرِّبُونَ مُحْرَقَةً وَقُودًا رَائِحَةَ سَرُورٍ لِلرَّبِّ: ثَوْرًا وَاحِدًا، وَكَبْشًا وَاحِدًا، وَسَبْعَةَ خِرَافٍ حَوْلِيَّةٍ صَحِيحَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","وَتَقْدِمَتَهُنَّ وَسَكَائِبَهُنَّ لِلثَّوْرِ وَٱلْكَبْشِ وَٱلْخِرَافِ حَسَبَ عَدَدِهِنَّ كَٱلْعَادَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","وَتَيْسًا وَاحِدًا لِذَبِيحَةِ خَطِيَّةٍ، فَضْلًا عَنِ ٱلْمُحْرَقَةِ ٱلدَّائِمَةِ وَتَقْدِمَتِهَا وَسَكِيبِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","هَذِهِ تُقَرِّبُونَهَا لِلرَّبِّ فِي مَوَاسِمِكُمْ، فَضْلًا عَنْ نُذُورِكُمْ وَنَوَافِلِكُمْ مِنْ مُحْرَقَاتِكُمْ وَتَقْدِمَاتِكُمْ وَسَكَائِبِكُمْ وَذَبَائِحِ سَلَامَتِكُمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","فَكَلَّمَ مُوسَى بَنِي إِسْرَائِيلَ حَسَبَ كُلِّ مَا أَمَرَ بِهِ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","وَكَلَّمَ مُوسَى رُؤُوسَ أَسْبَاطِ بَنِي إِسْرَائِيلَ قَائِلًا: «هَذَا مَا أَمَرَ بِهِ ٱلرَّبُّ: ");
INSERT INTO arb_vd_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","إِذَا نَذَرَ رَجُلٌ نَذْرًا لِلرَّبِّ، أَوْ أَقْسَمَ قَسَمًا أَنْ يُلْزِمَ نَفْسَهُ بِلَازِمٍ، فَلَا يَنْقُضْ كَلَامَهُ. حَسَبَ كُلِّ مَا خَرَجَ مِنْ فَمِهِ يَفْعَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","وَأَمَّا ٱلْمَرْأَةُ فَإِذَا نَذَرَتْ نَذْرًا لِلرَّبِّ وَٱلْتَزَمَتْ بِلَازِمٍ فِي بَيْتِ أَبِيهَا فِي صِبَاهَا، ");
INSERT INTO arb_vd_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","وَسَمِعَ أَبُوهَا نَذْرَهَا وَٱللَّازِمَ ٱلَّذِي أَلْزَمَتْ نَفْسَهَا بِهِ، فَإِنْ سَكَتَ أَبُوهَا لَهَا، ثَبَتَتْ كُلُّ نُذُورِهَا. وَكُلُّ لَوَازِمِهَا ٱلَّتِي أَلْزَمَتْ نَفْسَهَا بِهَا تَثْبُتُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","وَإِنْ نَهَاهَا أَبُوهَا يَوْمَ سَمْعِهِ، فَكُلُّ نُذُورِهَا وَلَوَازِمِهَا ٱلَّتِي أَلْزَمَتْ نَفْسَهَا بِهَا لَا تَثْبُتُ، وَٱلرَّبُّ يَصْفَحُ عَنْهَا لِأَنَّ أَبَاهَا قَدْ نَهَاهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","وَإِنْ كَانَتْ لِزَوْجٍ وَنُذُورُهَا عَلَيْهَا أَوْ نُطْقُ شَفَتَيْهَا ٱلَّذِي أَلْزَمَتْ نَفْسَهَا بِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","وَسَمِعَ زَوْجُهَا، فَإِنْ سَكَتَ فِي يَوْمِ سَمْعِهِ ثَبَتَتْ نُذُورُهَا. وَلَوَازِمُهَا ٱلَّتِي أَلْزَمَتْ نَفْسَهَا بِهَا تَثْبُتُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","وَإِنْ نَهَاهَا رَجُلُهَا فِي يَوْمِ سَمْعِهِ، فَسَخَ نَذْرَهَا ٱلَّذِي عَلَيْهَا وَنُطْقَ شَفَتَيْهَا ٱلَّذِي أَلْزَمَتْ نَفْسَهَا بِهِ، وَٱلرَّبُّ يَصْفَحُ عَنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","وَأَمَّا نَذْرُ أَرْمَلَةٍ أَوْ مُطَلَّقَةٍ، فَكُلُّ مَا أَلْزَمَتْ نَفْسَهَا بِهِ يَثْبُتُ عَلَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","وَلَكِنْ إِنْ نَذَرَتْ فِي بَيْتِ زَوْجِهَا أَوْ أَلْزَمَتْ نَفْسَهَا بِلَازِمٍ بِقَسَمٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","وَسَمِعَ زَوْجُهَا، فَإِنْ سَكَتَ لَهَا وَلَمْ يَنْهَهَا ثَبَتَتْ كُلُّ نُذُورِهَا. وَكُلُّ لَازِمٍ أَلْزَمَتْ نَفْسَهَا بِهِ يَثْبُتُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","وَإِنْ فَسَخَهَا زَوْجُهَا فِي يَوْمِ سَمْعِهِ، فَكُلُّ مَا خَرَجَ مِنْ شَفَتَيْهَا مِنْ نُذُورِهَا أَوْ لَوَازِمِ نَفْسِهَا لَا يَثْبُتُ. قَدْ فَسَخَهَا زَوْجُهَا. وَٱلرَّبُّ يَصْفَحُ عَنْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","كُلُّ نَذْرٍ وَكُلُّ قَسَمِ ٱلْتِزَامٍ لِإِذْلَالِ ٱلنَّفْسِ، زَوْجُهَا يُثْبِتُهُ وَزَوْجُهَا يَفْسَخُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","وَإِنْ سَكَتَ لَهَا زَوْجُهَا مِنْ يَوْمٍ إِلَى يَوْمٍ فَقَدْ أَثْبَتَ كُلَّ نُذُورِهَا أَوْ كُلَّ لَوَازِمِهَا ٱلَّتِي عَلَيْهَا. أَثْبَتَهَا لِأَنَّهُ سَكَتَ لَهَا فِي يَوْمِ سَمْعِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","فَإِنْ فَسَخَهَا بَعْدَ سَمْعِهِ فَقَدْ حَمَلَ ذَنْبَهَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","هَذِهِ هِيَ ٱلْفَرَائِضُ ٱلَّتِي أَمَرَ بِهَا ٱلرَّبُّ مُوسَى، بَيْنَ ٱلزَّوْجِ وَزَوْجَتِهِ، وَبَيْنَ ٱلْأَبِ وَٱبْنَتِهِ فِي صِبَاهَا فِي بَيْتِ أَبِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«اِنْتَقِمْ نَقْمَةً لِبَنِي إِسْرَائِيلَ مِنَ ٱلْمِدْيَانِيِّينَ، ثُمَّ تُضَمُّ إِلَى قَوْمِكَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","فَكَلَّمَ مُوسَى ٱلشَّعْبَ قَائِلًا: «جَرِّدُوا مِنْكُمْ رِجَالًا لِلْجُنْدِ، فَيَكُونُوا عَلَى مِدْيَانَ لِيَجْعَلُوا نَقْمَةَ ٱلرَّبِّ عَلَى مِدْيَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","أَلْفًا وَاحِدًا مِنْ كُلِّ سِبْطٍ مِنْ جَمِيعِ أَسْبَاطِ إِسْرَائِيلَ تُرْسِلُونَ لِلْحَرْبِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","فَٱخْتِيرَ مِنْ أُلُوفِ إِسْرَائِيلَ أَلْفٌ مِنْ كُلِّ سِبْطٍ. ٱثْنَا عَشَرَ أَلْفًا مُجَرَّدُونَ لِلْحَرْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","فَأَرْسَلَهُمْ مُوسَى أَلْفًا مِنْ كُلِّ سِبْطٍ إِلَى ٱلْحَرْبِ، هُمْ وَفِينْحَاسَ بْنَ أَلِعَازَارَ ٱلْكَاهِنِ إِلَى ٱلْحَرْبِ، وَأَمْتِعَةُ ٱلْقُدْسِ وَأَبْوَاقُ ٱلْهُتَافِ فِي يَدِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","فَتَجَنَّدُوا عَلَى مِدْيَانَ كَمَا أَمَرَ ٱلرَّبُّ وَقَتَلُوا كُلَّ ذَكَرٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","وَمُلُوكُ مِدْيَانَ قَتَلُوهُمْ فَوْقَ قَتْلَاهُمْ: أَوِيَ وَرَاقِمَ وَصُورَ وَحُورَ وَرَابِعَ. خَمْسَةَ مُلُوكِ مِدْيَانَ. وَبَلْعَامَ بْنَ بَعُورَ قَتَلُوهُ بِٱلسَّيْفِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","وَسَبَى بَنُو إِسْرَائِيلَ نِسَاءَ مِدْيَانَ وَأَطْفَالَهُمْ، وَنَهَبُوا جَمِيعَ بَهَائِمِهِمْ، وَجَمِيعَ مَوَاشِيهِمْ وَكُلَّ أَمْلَاكِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","وَأَحْرَقُوا جَمِيعَ مُدُنِهِمْ بِمَسَاكِنِهِمْ، وَجَمِيعَ حُصُونِهِمْ بِٱلنَّارِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","وَأَخَذُوا كُلَّ ٱلْغَنِيمَةِ وَكُلَّ ٱلنَّهْبِ مِنَ ٱلنَّاسِ وَٱلْبَهَائِمِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","وَأَتَوْا إِلَى مُوسَى وَأَلِعَازَارَ ٱلْكَاهِنِ وَإِلَى جَمَاعَةِ بَنِي إِسْرَائِيلَ بِٱلسَّبْيِ وَٱلنَّهْبِ وَٱلْغَنِيمَةِ إِلَى ٱلْمَحَلَّةِ إِلَى عَرَبَاتِ مُوآبَ ٱلَّتِي عَلَى أُرْدُنِّ أَرِيحَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","فَخَرَجَ مُوسَى وَأَلِعَازَارُ ٱلْكَاهِنُ وَكُلُّ رُؤَسَاءِ ٱلْجَمَاعَةِ لِٱسْتِقْبَالِهِمْ إِلَى خَارِجِ ٱلْمَحَلَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","فَسَخَطَ مُوسَى عَلَى وُكَلَاءِ ٱلْجَيْشِ، رُؤَسَاءِ ٱلْأُلُوفِ وَرُؤَسَاءِ ٱلْمِئَاتِ ٱلْقَادِمِينَ مِنْ جُنْدِ ٱلْحَرْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","وَقَالَ لَهُمْ مُوسَى: «هَلْ أَبْقَيْتُمْ كُلَّ أُنْثَى حَيَّةً؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","إِنَّ هَؤُلَاءِ كُنَّ لِبَنِي إِسْرَائِيلَ، حَسَبَ كَلَامِ بَلْعَامَ، سَبَبَ خِيَانَةٍ لِلرَّبِّ فِي أَمْرِ فَغُورَ، فَكَانَ ٱلْوَبَأُ فِي جَمَاعَةِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","فَٱلْآنَ ٱقْتُلُوا كُلَّ ذَكَرٍ مِنَ ٱلْأَطْفَالِ. وَكُلَّ ٱمْرَأَةٍ عَرَفَتْ رَجُلًا بِمُضَاجَعَةِ ذَكَرٍ ٱقْتُلُوهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","لَكِنْ جَمِيعُ ٱلْأَطْفَالِ مِنَ ٱلنِّسَاءِ ٱللَّوَاتِي لَمْ يَعْرِفْنَ مُضَاجَعَةَ ذَكَرٍ أَبْقُوهُنَّ لَكُمْ حَيَّاتٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","وَأَمَّا أَنْتُمْ فَٱنْزِلُوا خَارِجَ ٱلْمَحَلَّةِ سَبْعَةَ أَيَّامٍ، وَتَطَهَّرُوا كُلُّ مَنْ قَتَلَ نَفْسًا، وَكُلُّ مَنْ مَسَّ قَتِيلًا، فِي ٱلْيَوْمِ ٱلثَّالِثِ وَفِي ٱلسَّابِعِ، أَنْتُمْ وَسَبْيُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","وَكُلُّ ثَوْبٍ، وَكُلُّ مَتَاعٍ مِنْ جِلْدٍ، وَكُلُّ مَصْنُوعٍ مِنْ شَعْرِ مَعْزٍ، وَكُلُّ مَتَاعٍ مِنْ خَشَبٍ، تُطَهِّرُونَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","وَقَالَ أَلِعَازَارُ ٱلْكَاهِنُ لِرِجَالِ ٱلْجُنْدِ ٱلَّذِينَ ذَهَبُوا لِلْحَرْبِ: «هَذِهِ فَرِيضَةُ ٱلشَّرِيعَةِ ٱلَّتِي أَمَرَ بِهَا ٱلرَّبُّ مُوسَى: ");
INSERT INTO arb_vd_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","اَلذَّهَبُ وَٱلْفِضَّةُ وَٱلنُّحَاسُ وَٱلْحَدِيدُ وَٱلْقَصْدِيرُ وَٱلرَّصَاصُ، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","كُلُّ مَا يَدْخُلُ ٱلنَّارَ، تُجِيزُونَهُ فِي ٱلنَّارِ فَيَكُونُ طَاهِرًا، غَيْرَ أَنَّهُ يَتَطَهَّرُ بِمَاءِ ٱلنَّجَاسَةِ. وَأَمَّا كُلُّ مَا لَا يَدْخُلُ ٱلنَّارَ فَتُجِيزُونَهُ فِي ٱلْمَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","وَتَغْسِلُونَ ثِيَابَكُمْ فِي ٱلْيَوْمِ ٱلسَّابِعِ فَتَكُونُونَ طَاهِرِينَ، وَبَعْدَ ذَلِكَ تَدْخُلُونَ ٱلْمَحَلَّةَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«أَحْصِ ٱلنَّهْبَ ٱلْمَسْبِيَّ مِنَ ٱلنَّاسِ وَٱلْبَهَائِمِ، أَنْتَ وَأَلِعَازَارُ ٱلْكَاهِنُ وَرُؤُوسُ آبَاءِ ٱلْجَمَاعَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","وَنَصِّفِ ٱلنَّهْبَ بَيْنَ ٱلَّذِينَ بَاشَرُوا ٱلْقِتَالَ ٱلْخَارِجِينَ إِلَى ٱلْحَرْبِ، وَبَيْنَ كُلِّ ٱلْجَمَاعَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","وَٱرْفَعْ زَكَاةً لِلرَّبِّ. مِنْ رِجَالِ ٱلْحَرْبِ ٱلْخَارِجِينَ إِلَى ٱلْقِتَالِ وَاحِدَةً. نَفْسًا مِنْ كُلِّ خَمْسِ مِئَةٍ مِنَ ٱلنَّاسِ وَٱلْبَقَرِ وَٱلْحَمِيرِ وَٱلْغَنَمِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","مِنْ نِصْفِهِمْ تَأْخُذُونَهَا وَتُعْطُونَهَا لِأَلِعَازَارَ ٱلْكَاهِنِ رَفِيعَةً لِلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","وَمِنْ نِصْفِ بَنِي إِسْرَائِيلَ تَأْخُذُ وَاحِدَةً مَأْخُوذَةً مِنْ كُلِّ خَمْسِينَ مِنَ ٱلنَّاسِ وَٱلْبَقَرِ وَٱلْحَمِيرِ وَٱلْغَنَمِ مِنْ جَمِيعِ ٱلْبَهَائِمِ، وَتُعْطِيهَا لِلَّاوِيِّينَ ٱلْحَافِظِينَ شَعَائِرَ مَسْكَنِ ٱلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","فَفَعَلَ مُوسَى وَأَلِعَازَارُ ٱلْكَاهِنُ كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","وَكَانَ ٱلنَّهْبُ فَضْلَةُ ٱلْغَنِيمَةِ ٱلَّتِي ٱغْتَنَمَهَا رِجَالُ ٱلْجُنْدِ: مِنَ ٱلْغَنَمِ سِتَّ مِئَةٍ وَخَمْسَةً وَسَبْعِينَ أَلْفًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","وَمِنَ ٱلْبَقَرِ ٱثْنَيْنِ وَسَبْعِينَ أَلْفًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","وَمِنَ ٱلْحَمِيرِ وَاحِدًا وَسِتِّينَ أَلْفًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","وَمِنْ نُفُوسِ ٱلنَّاسِ مِنَ ٱلنِّسَاءِ ٱللَّوَاتِي لَمْ يَعْرِفْنَ مُضَاجَعَةَ ذَكَرٍ، جَمِيعِ ٱلنُّفُوسِ ٱثْنَيْنِ وَثَلَاثِينَ أَلْفًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","وَكَانَ ٱلنِّصْفُ نَصِيبُ ٱلْخَارِجِينَ إِلَى ٱلْحَرْبِ: عَدَدُ ٱلْغَنَمِ ثَلَاثَ مِئَةٍ وَسَبْعَةً وَثَلَاثِينَ أَلْفًا وَخَمْسَ مِئَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","وَكَانَتِ ٱلزَّكَاةُ لِلرَّبِّ مِنَ ٱلْغَنَمِ سِتَّ مِئَةٍ وَخَمْسَةً وَسَبْعِينَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","وَٱلْبَقَرُ سِتَّةً وَثَلَاثِينَ أَلْفًا، وَزَكَاتُهَا لِلرَّبِّ ٱثْنَيْنِ وَسَبْعِينَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","وَٱلْحَمِيرُ ثَلَاثِينَ أَلْفًا وَخَمْسَ مِئَةٍ، وَزَكَاتُهَا لِلرَّبِّ وَاحِدًا وَسِتِّينَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","وَنُفُوسُ ٱلنَّاسِ سِتَّةَ عَشَرَ أَلْفًا، وَزَكَاتُهَا لِلرَّبِّ ٱثْنَيْنِ وَثَلَاثِينَ نَفْسًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","فَأَعْطَى مُوسَى ٱلزَّكَاةَ رَفِيعَةَ ٱلرَّبِّ لِأَلِعَازَارَ ٱلْكَاهِنِ كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","وَأَمَّا نِصْفُ إِسْرَائِيلَ ٱلَّذِي قَسَمَهُ مُوسَى مِنَ ٱلرِّجَالِ ٱلْمُتَجَنِّدِينَ: ");
INSERT INTO arb_vd_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","فَكَانَ نِصْفُ ٱلْجَمَاعَةِ مِنَ ٱلْغَنَمِ ثَلَاثَ مِئَةٍ وَسَبْعَةً وَثَلَاثِينَ أَلْفًا وَخَمْسَ مِئَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","وَمِنَ ٱلْبَقَرِ سِتَّةً وَثَلَاثِينَ أَلْفًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","وَمِنَ ٱلْحَمِيرِ ثَلَاثِينَ أَلْفًا وَخَمْسَ مِئَةٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","وَمِنْ نُفُوسِ ٱلنَّاسِ سِتَّةَ عَشَرَ أَلْفًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","فَأَخَذَ مُوسَى مِنْ نِصْفِ بَنِي إِسْرَائِيلَ ٱلْمَأْخُوذِ وَاحِدًا مِنْ كُلِّ خَمْسِينَ مِنَ ٱلنَّاسِ وَمِنَ ٱلْبَهَائِمِ، وَأَعْطَاهَا لِلَّاوِيِّينَ ٱلْحَافِظِينَ شَعَائِرَ مَسْكَنِ ٱلرَّبِّ، كَمَا أَمَرَ ٱلرَّبُّ مُوسَى. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ثُمَّ تَقَدَّمَ إِلَى مُوسَى ٱلْوُكَلَاءُ ٱلَّذِينَ عَلَى أُلُوفِ ٱلْجُنْدِ، رُؤَسَاءُ ٱلْأُلُوفِ وَرُؤَسَاءُ ٱلْمِئَاتِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","وَقَالُوا لِمُوسَى: «عَبِيدُكَ قَدْ أَخَذُوا عَدَدَ رِجَالِ ٱلْحَرْبِ ٱلَّذِينَ فِي أَيْدِينَا فَلَمْ يُفْقَدْ مِنَّا إِنْسَانٌ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","فَقَدْ قَدَّمْنَا قُرْبَانَ ٱلرَّبِّ، كُلُّ وَاحِدٍ مَا وَجَدَهُ، أَمْتِعَةَ ذَهَبٍ: حُجُولًا وَأَسَاوِرَ وَخَوَاتِمَ وَأَقْرَاطًا وَقَلَائِدَ، لِلتَّكْفِيرِ عَنْ أَنْفُسِنَا أَمَامَ ٱلرَّبِّ». ");
INSERT INTO arb_vd_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","فَأَخَذَ مُوسَى وَأَلِعَازَارُ ٱلْكَاهِنُ ٱلذَّهَبَ مِنْهُمْ، كُلَّ أَمْتِعَةٍ مَصْنُوعَةٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","وَكَانَ كُلُّ ذَهَبِ ٱلرَّفِيعَةِ ٱلَّتِي رَفَعُوهَا لِلرَّبِّ سِتَّةَ عَشَرَ أَلْفًا وَسَبْعَ مِئَةٍ وَخَمْسِينَ شَاقِلًا مِنْ عِنْدِ رُؤَسَاءِ ٱلْأُلُوفِ وَرُؤَسَاءِ ٱلْمِئَاتِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","أَمَّا رِجَالُ ٱلْجُنْدِ فَٱغْتَنَمُوا كُلُّ وَاحِدٍ لِنَفْسِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","فَأَخَذَ مُوسَى وَأَلِعَازَارُ ٱلْكَاهِنُ ٱلذَّهَبَ مِنْ رُؤَسَاءِ ٱلْأُلُوفِ وَٱلْمِئَاتِ وَأَتَيَا بِهِ إِلَى خَيْمَةِ ٱلِٱجْتِمَاعِ تَذْكَارًا لِبَنِي إِسْرَائِيلَ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","وَأَمَّا بَنُو رَأُوبَيْنَ وَبَنُو جَادَ فَكَانَ لَهُمْ مَوَاشٍ كَثِيرَةٌ وَافِرَةٌ جِدًّا. فَلَمَّا رَأَوْا أَرْضَ يَعْزِيرَ وَأَرْضَ جِلْعَادَ، وَإِذَا ٱلْمَكَانُ مَكَانُ مَوَاشٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","أَتَى بَنُو جَادَ وَبَنُو رَأُوبَيْنَ وَكَلَّمُوا مُوسَى وَأَلِعَازَارَ ٱلْكَاهِنَ وَرُؤَسَاءَ ٱلْجَمَاعَةِ قَائِلِينَ: ");
INSERT INTO arb_vd_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«عَطَارُوتُ وَدِيبُونُ وَيَعْزِيرُ وَنِمْرَةُ وَحَشْبُونُ وَأَلِعَالَةُ وَشَبَامُ وَنَبُو وَبَعُونُ، ");
INSERT INTO arb_vd_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ٱلْأَرْضُ ٱلَّتِي ضَرَبَهَا ٱلرَّبُّ قُدَّامَ بَنِي إِسْرَائِيلَ، هِيَ أَرْضُ مَوَاشٍ، وَلِعَبِيدِكَ مَوَاشٍ». ");
INSERT INTO arb_vd_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ثُمَّ قَالُوا: «إِنْ وَجَدْنَا نِعْمَةً فِي عَيْنَيْكَ فَلْتُعْطَ هَذِهِ ٱلْأَرْضُ لِعَبِيدِكَ مُلْكًا، وَلَا تُعَبِّرْنَا ٱلْأُرْدُنَّ». ");
INSERT INTO arb_vd_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","فَقَالَ مُوسَى لِبَنِي جَادٍ وَبَنِي رَأُوبَيْنَ: «هَلْ يَنْطَلِقُ إِخْوَتُكُمْ إِلَى ٱلْحَرْبِ، وَأَنْتُمْ تَقْعُدُونَ هَهُنَا؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","فَلِمَاذَا تَصُدُّونَ قُلُوبَ بَنِي إِسْرَائِيلَ عَنِ ٱلْعُبُورِ إِلَى ٱلْأَرْضِ ٱلَّتِي أَعْطَاهُمُ ٱلرَّبُّ؟ ");
INSERT INTO arb_vd_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","هَكَذَا فَعَلَ آبَاؤُكُمْ حِينَ أَرْسَلْتُهُمْ مِنْ قَادَشَ بَرْنِيعَ لِيَنْظُرُوا ٱلْأَرْضَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","صَعِدُوا إِلَى وَادِي أَشْكُولَ وَنَظَرُوا ٱلْأَرْضَ وَصَدُّوا قُلُوبَ بَنِي إِسْرَائِيلَ عَنْ دُخُولِ ٱلْأَرْضِ ٱلَّتِي أَعْطَاهُمُ ٱلرَّبُّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","فَحَمِيَ غَضَبُ ٱلرَّبِّ فِي ذَلِكَ ٱلْيَوْمِ وَأَقْسَمَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","لَنْ يَرَى ٱلنَّاسُ ٱلَّذِينَ صَعِدُوا مِنْ مِصْرَ، مِنِ ٱبْنِ عِشْرِينَ سَنَةً فَصَاعِدًا، ٱلْأَرْضَ ٱلَّتِي أَقْسَمْتُ لِإِبْرَاهِيمَ وَإِسْحَاقَ وَيَعْقُوبَ، لِأَنَّهُمْ لَمْ يَتَّبِعُونِي تَمَامًا، ");
INSERT INTO arb_vd_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","مَا عَدَا كَالِبَ بْنَ يَفُنَّةَ ٱلْقِنِزِّيَّ وَيَشُوعَ بْنَ نُونَ، لِأَنَّهُمَا ٱتَّبَعَا ٱلرَّبَّ تَمَامًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","فَحَمِيَ غَضَبُ ٱلرَّبِّ عَلَى إِسْرَائِيلَ وَأَتَاهَهُمْ فِي ٱلْبَرِّيَّةِ أَرْبَعِينَ سَنَةً، حَتَّى فَنِيَ كُلُّ ٱلْجِيلِ ٱلَّذِي فَعَلَ ٱلشَّرَّ فِي عَيْنَيِ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","فَهُوَذَا أَنْتُمْ قَدْ قُمْتُمْ عِوَضًا عَنْ آبَائِكُمْ، تَرْبِيَةَ أُنَاسٍ خُطَاةٍ، لِكَيْ تَزِيدُوا أَيْضًا حُمُوَّ غَضَبِ ٱلرَّبِّ عَلَى إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","إِذَا ٱرْتَدَدْتُمْ مِنْ وَرَائِهِ، يَعُودُ يَتْرُكُهُ أَيْضًا فِي ٱلْبَرِّيَّةِ، فَتُهْلِكُونَ كُلَّ هَذَا ٱلشَّعْبِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","فَٱقْتَرَبُوا إِلَيْهِ وَقَالُوا: «نَبْنِي صِيَرَ غَنَمٍ لِمَوَاشِينَا هَهُنَا وَمُدُنًا لِأَطْفَالِنَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","وَأَمَّا نَحْنُ فَنَتَجَرَّدُ مُسْرِعِينَ قُدَّامَ بَنِي إِسْرَائِيلَ حَتَّى نَأْتِيَ بِهِمْ إِلَى مَكَانِهِمْ، وَيَلْبَثُ أَطْفَالُنَا فِي مُدُنٍ مُحَصَّنَةٍ مِنْ وَجْهِ سُكَّانِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","لَا نَرْجِعُ إِلَى بُيُوتِنَا حَتَّى يَقْتَسِمَ بَنُو إِسْرَائِيلَ كُلُّ وَاحِدٍ نَصِيبَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","إِنَّنَا لَا نَمْلِكُ مَعَهُمْ فِي عَبْرِ ٱلْأُرْدُنِّ وَمَا وَرَاءَهُ، لِأَنَّ نَصِيبَنَا قَدْ حَصَلَ لَنَا فِي عَبْرِ ٱلْأُرْدُنِّ إِلَى ٱلشَّرْقِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","فَقَالَ لَهُمْ مُوسَى: «إِنْ فَعَلْتُمْ هَذَا ٱلْأَمْرَ، إِنْ تَجَرَّدْتُمْ أَمَامَ ٱلرَّبِّ لِلْحَرْبِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","وَعَبَرَ ٱلْأُرْدُنَّ كُلُّ مُتَجَرِّدٍ مِنْكُمْ أَمَامَ ٱلرَّبِّ حَتَّى طَرَدَ أَعْدَاءَهُ مِنْ أَمَامِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","وَأُخْضِعَتِ ٱلْأَرْضُ أَمَامَ ٱلرَّبِّ، وَبَعْدَ ذَلِكَ رَجَعْتُمْ، فَتَكُونُونَ أَبْرِيَاءَ مِنْ نَحْوِ ٱلرَّبِّ وَمِنْ نَحْوِ إِسْرَائِيلَ، وَتَكُونُ هَذِهِ ٱلْأَرْضُ مُلْكًا لَكُمْ أَمَامَ ٱلرَّبِّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","وَلَكِنْ إِنْ لَمْ تَفْعَلُوا هَكَذَا، فَإِنَّكُمْ تُخْطِئُونَ إِلَى ٱلرَّبِّ، وَتَعْلَمُونَ خَطِيَّتَكُمُ ٱلَّتِي تُصِيبُكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","اِبْنُوا لِأَنْفُسِكُمْ مُدُنًا لِأَطْفَالِكُمْ وَصِيَرًا لِغَنَمِكُمْ. وَمَا خَرَجَ مِنْ أَفْوَاهِكُمُ ٱفْعَلُوا». ");
INSERT INTO arb_vd_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","فَكَلَّمَ بَنُو جَادَ وَبَنُو رَأُوبَيْنَ مُوسَى قَائِلِينَ: «عَبِيدُكَ يَفْعَلُونَ كَمَا أَمَرَ سَيِّدِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","أَطْفَالُنَا وَنِسَاؤُنَا وَمَوَاشِينَا وَكُلُّ بَهَائِمِنَا تَكُونُ هُنَاكَ فِي مُدُنِ جِلْعَادَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","وَعَبِيدُكَ يَعْبُرُونَ، كُلُّ مُتَجَرِّدٍ لِلْجُنْدِ أَمَامَ ٱلرَّبِّ لِلْحَرْبِ كَمَا تَكَلَّمَ سَيِّدِي». ");
INSERT INTO arb_vd_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","فَأَوْصَى بِهِمْ مُوسَى أَلِعَازَارَ ٱلْكَاهِنَ وَيَشُوعَ بْنَ نُونَ وَرُؤُوسَ آبَاءِ ٱلْأَسْبَاطِ مِنْ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","وَقَالَ لَهُمْ مُوسَى: «إِنْ عَبَرَ ٱلْأُرْدُنَّ مَعَكُمْ بَنُو جَادَ وَبَنُو رَأُوبَيْنَ، كُلُّ مُتَجَرِّدٍ لِلْحَرْبِ أَمَامَ ٱلرَّبِّ، فَمَتَى أُخْضِعَتِ ٱلْأَرْضُ أَمَامَكُمْ، تُعْطُونَهُمْ أَرْضَ جِلْعَادَ مُلْكًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","وَلَكِنْ إِنْ لَمْ يَعْبُرُوا مُتَجَرِّدِينَ مَعَكُمْ، يَتَمَلَّكُوا فِي وَسَطِكُمْ فِي أَرْضِ كَنْعَانَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","فَأَجَابَ بَنُو جَادٍ وَبَنُو رَأُوبَيْنَ قَائِلِينَ: «ٱلَّذِي تَكَلَّمَ بِهِ ٱلرَّبُّ عَنْ عَبِيدِكَ كَذَلِكَ نَفْعَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","نَحْنُ نَعْبُرُ مُتَجَرِّدِينَ أَمَامَ ٱلرَّبِّ إِلَى أَرْضِ كَنْعَانَ، وَلَكِنْ نُعْطَى مُلْكَ نَصِيبِنَا فِي عَبْرِ ٱلْأُرْدُنِّ». ");
INSERT INTO arb_vd_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","فَأَعْطَى مُوسَى لَهُمْ، لِبَنِي جَادٍ وَبَنِي رَأُوبَيْنَ وَنِصْفِ سِبْطِ مَنَسَّى بْنِ يُوسُفَ، مَمْلَكَةَ سِيحُونَ مَلِكِ ٱلْأَمُورِيِّينَ وَمَمْلَكَةَ عُوجٍ مَلِكِ بَاشَانَ، ٱلْأَرْضَ مَعَ مُدُنِهَا بِتُخُومِ مُدُنِ ٱلْأَرْضِ حَوَالَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","فَبَنَى بَنُو جَادَ: دِيبُونَ وَعَطَارُوتَ وَعَرُوعِيرَ ");
INSERT INTO arb_vd_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","وَعَطْرُوتَ شُوفَانَ وَيَعْزِيرَ وَيُجْبَهَةَ ");
INSERT INTO arb_vd_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","وَبَيْتَ نِمْرَةَ وَبَيْتَ هَارَانَ مُدُنًا مُحَصَّنَةً مَعَ صِيَرِ غَنَمٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","وَبَنَى بَنُو رَأُوبَيْنَ: حَشْبُونَ وَأَلِعَالَةَ وَقَرْيَتَايِمَ ");
INSERT INTO arb_vd_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","وَنَبُوَ وَبَعْلَ مَعُونَ، مُغَيَّرَتَيِ ٱلِٱسْمِ، وَسَبْمَةَ، وَدَعَوْا بِأَسْمَاءٍ أَسْمَاءَ ٱلْمُدُنِ ٱلَّتِي بَنَوْا. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","وَذَهَبَ بَنُو مَاكِيرَ بْنِ مَنَسَّى إِلَى جِلْعَادَ وَأَخَذُوهَا وَطَرَدُوا ٱلْأَمُورِيِّينَ ٱلَّذِينَ فِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","فَأَعْطَى مُوسَى جِلْعَادَ لِمَاكِيرَ بْنِ مَنَسَّى فَسَكَنَ فِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","وَذَهَبَ يَائِيرُ ٱبْنُ مَنَسَّى وَأَخَذَ مَزَارِعَهَا وَدَعَاهُنَّ: حَوُّوثَ يَائِيرَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","وَذَهَبَ نُوبَحُ وَأَخَذَ قَنَاةَ وَقُرَاهَا وَدَعَاهَا نُوبَحَ بِٱسْمِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","هَذِهِ رِحْلَاتُ بَنِي إِسْرَائِيلَ ٱلَّذِينَ خَرَجُوا مِنْ أَرْضِ مِصْرَ بِجُنُودِهِمْ عَنْ يَدِ مُوسَى وَهَارُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","وَكَتَبَ مُوسَى مَخَارِجَهُمْ بِرِحْلَاتِهِمْ حَسَبَ قَوْلِ ٱلرَّبِّ. وَهَذِهِ رِحْلَاتُهُمْ بِمَخَارِجِهِمْ: ");
INSERT INTO arb_vd_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","اِرْتَحَلُوا مِنْ رَعَمْسِيسَ فِي ٱلشَّهْرِ ٱلْأَوَّلِ، فِي ٱلْيَوْمِ ٱلْخَامِسَ عَشَرَ مِنَ ٱلشَّهْرِ ٱلْأَوَّلِ، فِي غَدِ ٱلْفِصْحِ. خَرَجَ بَنُو إِسْرَائِيلَ بِيَدٍ رَفِيعَةٍ أَمَامَ أَعْيُنِ جَمِيعِ ٱلْمِصْرِيِّينَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","إِذْ كَانَ ٱلْمِصْرِيُّونَ يَدْفِنُونَ ٱلَّذِينَ ضَرَبَ مِنْهُمُ ٱلرَّبُّ مِنْ كُلِّ بِكْرٍ، وَٱلرَّبُّ قَدْ صَنَعَ بِآلِهَتِهِمْ أَحْكَامًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","فَٱرْتَحَلَ بَنُو إِسْرَائِيلَ مِنْ رَعَمْسِيسَ وَنَزَلُوا فِي سُكُّوتَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ثُمَّ ٱرْتَحَلُوا مِنْ سُكُّوتَ وَنَزَلُوا فِي إِيثَامَ ٱلَّتِي فِي طَرَفِ ٱلْبَرِّيَّةِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ثُمَّ ٱرْتَحَلُوا مِنْ إِيثَامَ وَرَجَعُوا عَلَى فَمِ ٱلْحِيرُوثِ ٱلَّتِي قُبَالَةَ بَعْلَ صَفُونَ وَنَزَلُوا أَمَامَ مَجْدَلٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ثُمَّ ٱرْتَحَلُوا مِنْ أَمَامِ ٱلْحِيرُوثِ وَعَبَرُوا فِي وَسَطِ ٱلْبَحْرِ إِلَى ٱلْبَرِّيَّةِ، وَسَارُوا مَسِيرَةَ ثَلَاثَةِ أَيَّامٍ فِي بَرِّيَّةِ إِيثَامَ وَنَزَلُوا فِي مَارَّةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ثُمَّ ٱرْتَحَلُوا مِنْ مَارَّةَ وَأَتَوْا إِلَى إِيلِيمَ. وَكَانَ فِي إِيلِيمَ ٱثْنَتَا عَشَرَةَ عَيْنَ مَاءٍ، وَسَبْعُونَ نَخْلَةً. فَنَزَلُوا هُنَاكَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ثُمَّ ٱرْتَحَلُوا مِنْ إِيلِيمَ وَنَزَلُوا عَلَى بَحْرِ سُوفَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ثُمَّ ٱرْتَحَلُوا مِنْ بَحْرِ سُوفَ وَنَزَلُوا فِي بَرِّيَّةِ سِينٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ثُمَّ ٱرْتَحَلُوا مِنْ بَرِّيَّةِ سِينٍ وَنَزَلُوا فِي دُفْقَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ثُمَّ ٱرْتَحَلُوا مِنْ دُفْقَةَ وَنَزَلُوا فِي أَلُوشَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ثُمَّ ٱرْتَحَلُوا مِنْ أَلُوشَ وَنَزَلُوا فِي رَفِيدِيمَ، وَلَمْ يَكُنْ هُنَاكَ مَاءٌ لِلشَّعْبِ لِيَشْرَبَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ثُمَّ ٱرْتَحَلُوا مِنْ رَفِيدِيمَ وَنَزَلُوا فِي بَرِّيَّةِ سِينَاءَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ثُمَّ ٱرْتَحَلُوا مِنْ بَرِّيَّةِ سِينَاءَ وَنَزَلُوا فِي قَبَرُوتَ هَتَّأَوَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ثُمَّ ٱرْتَحَلُوا مِنْ قَبَرُوتَ هَتَّأَوَةَ وَنَزَلُوا فِي حَضَيْرُوتَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ثُمَّ ٱرْتَحَلُوا مِنْ حَضَيْرُوتَ وَنَزَلُوا فِي رِثْمَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ثُمَّ ٱرْتَحَلُوا مِنْ رِثْمَةَ وَنَزَلُوا فِي رِمُّونَ فَارِصَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ثُمَّ ٱرْتَحَلُوا مِنْ رِمُّونَ فَارِصَ وَنَزَلُوا فِي لِبْنَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ثُمَّ ٱرْتَحَلُوا مِنْ لِبْنَةَ وَنَزَلُوا فِي رِسَّةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ثُمَّ ٱرْتَحَلُوا مِنْ رِسَّةَ وَنَزَلُوا فِي قُهَيْلَاتَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ثُمَّ ٱرْتَحَلُوا مِنْ قُهَيْلَاتَةَ وَنَزَلُوا فِي جَبَلِ شَافَرَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ثُمَّ ٱرْتَحَلُوا مِنْ جَبَلِ شَافَرَ وَنَزَلُوا فِي حَرَادَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ثُمَّ ٱرْتَحَلُوا مِنْ حَرَادَةَ وَنَزَلُوا فِي مَقْهَيْلُوتَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ثُمَّ ٱرْتَحَلُوا مِنْ مَقْهَيْلُوتَ وَنَزَلُوا فِي تَاحَتَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ثُمَّ ٱرْتَحَلُوا مِنْ تَاحَتَ وَنَزَلُوا فِي تَارَحَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ثُمَّ ٱرْتَحَلُوا مِنْ تَارَحَ وَنَزَلُوا فِي مِثْقَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ثُمَّ ٱرْتَحَلُوا مِنْ مِثْقَةَ وَنَزَلُوا فِي حَشْمُونَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ثُمَّ ٱرْتَحَلُوا مِنْ حَشْمُونَةَ وَنَزَلُوا فِي مُسِيرُوتَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ثُمَّ ٱرْتَحَلُوا مِن مُسِيرُوتَ وَنَزَلُوا فِي بَنِي يَعْقَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ثُمَّ ٱرْتَحَلُوا مِنْ بَنِي يَعْقَانَ وَنَزَلُوا فِي حُورِ ٱلْجِدْجَادِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ثُمَّ ٱرْتَحَلُوا مِنْ حُورِ ٱلْجِدْجَادِ وَنَزَلُوا فِي يُطْبَاتَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ثُمَّ ٱرْتَحَلُوا مِنْ يُطْبَاتَ وَنَزَلُوا فِي عَبْرُونَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ثُمَّ ٱرْتَحَلُوا مِنْ عَبْرُونَةَ وَنَزَلُوا فِي عِصْيُونَ جَابَرَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ثُمَّ ٱرْتَحَلُوا مِنْ عِصْيُونَ جَابَرَ وَنَزَلُوا فِي بَرِّيّةِ صِينٍ وَهِيَ قَادَشُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ثُمَّ ٱرْتَحَلُوا مِنْ قَادَشَ وَنَزَلُوا فِي جَبَلِ هُورٍ فِي طَرَفِ أَرْضِ أَدُومَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","فَصَعِدَ هَارُونُ ٱلْكَاهِنُ إِلَى جَبَلِ هُورٍ حَسَبَ قَوْلِ ٱلرَّبِّ، وَمَاتَ هُنَاكَ فِي ٱلسَّنَةِ ٱلْأَرْبَعِينَ لِخُرُوجِ بَنِي إِسْرَائِيلَ مِنْ أَرْضِ مِصْرَ، في ٱلشَّهْرِ ٱلخَامِسِ فِي ٱلْأَوَّلِ مِنَ ٱلشَّهْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","وَكَانَ هَارُونُ ٱبْنَ مِئَةٍ وثَلَاثٍ وَعِشْرِينَ سَنَةً حِينَ مَاتَ فِي جَبَلِ هُورٍ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","وَسَمِعَ ٱلْكَنْعَانِيُّ مَلِكُ عَرَادَ وَهُوَ سَاكِنٌ فِي ٱلْجَنُوبِ فِي أَرْضِ كَنْعَانَ بِمَجِيءِ بَنِي إِسْرَائِيلَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ثُمَّ ٱرْتَحَلُوا مِنْ جَبَلِ هُورٍ وَنَزَلُوا فِي صَلْمُونَةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ثُمَّ ٱرْتَحَلُوا مِنْ صَلْمُونَةَ وَنَزَلُوا فِي فُونُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ثُمَّ ٱرْتَحَلُوا مِنْ فُونُونَ وَنَزَلُوا فِي أُوبُوتَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ثُمَّ ٱرْتَحَلُوا مِنْ أُوبُوتَ وَنَزَلُوا فِي عَيِّي عَبَارِيمَ فِي تُخْمِ مُوآبَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ثُمَّ ٱرْتَحَلُوا مِنْ عَيِّيمَ وَنَزَلُوا فِي دِيبُونَ جَادَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ثُمَّ ٱرْتَحَلُوا مِنْ دِيبُونَ جَادَ وَنَزَلُوا فِي عَلْمُونَ دِبْلَاتَايِمَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","ثُمَّ ٱرْتَحَلُوا مِنْ عَلْمُونَ دِبْلَاتَايِمَ وَنَزَلُوا فِي جِبَالِ عَبَارِيمَ أَمَامَ نَبُو. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ثُمَّ ٱرْتَحَلُوا مِنْ جِبَالِ عَبَارِيمَ وَنَزَلُوا فِي عَرَبَاتِ مُوآبَ عَلَى أُرْدُنِّ أَرِيحَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","نَزَلُوا عَلَى ٱلْأُرْدُنِّ مِنْ بَيْتِ يَشِيمُوتَ إِلَى آبَلِ شِطِّيمَ فِي عَرَبَاتِ مُوآبَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","وَكَلَّمَ ٱلرَّبُّ مُوسَى فِي عَرَبَاتِ مُوآبَ عَلَى أُرْدُنِّ أَرِيحَا قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: إِنَّكُمْ عَابِرُونَ ٱلْأُرْدُنَّ إِلَى أَرْضِ كَنْعَانَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","فَتَطْرُدُونَ كُلَّ سُكَّانِ ٱلْأَرْضِ مِنْ أَمَامِكُمْ، وَتَمْحُونَ جَمِيعَ تَصَاوِيرِهِمْ، وَتُبِيدُونَ كُلَّ أَصْنَامِهِمِ ٱلْمَسْبُوكَةِ وَتُخْرِبُونَ جَمِيعَ مُرْتَفَعَاتِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","تَمْلِكُونَ ٱلْأَرْضَ وَتَسْكُنُونَ فِيهَا لِأَنِّي قَدْ أَعْطَيْتُكُمُ ٱلْأَرْضَ لِكَيْ تَمْلِكُوهَا، ");
INSERT INTO arb_vd_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","وَتَقْتَسِمُونَ ٱلْأَرْضَ بِٱلْقُرْعَةِ حَسَبَ عَشَائِرِكُمْ. اَلْكَثِيرُ تُكَثِّرُونَ لَهُ نَصِيبَهُ وَٱلْقَلِيلُ تُقَلِّلُونَ لَهُ نَصِيبَهُ. حَيْثُ خَرَجَتْ لَهُ ٱلْقُرْعَةُ فَهُنَاكَ يَكُونُ لَهُ. حَسَبَ أَسْبَاطِ آبَائِكُمْ تَقْتَسِمُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","وَإِنْ لَمْ تَطْرُدُوا سُكَّانَ ٱلْأَرْضِ مِنْ أَمَامِكُمْ يَكُونُ ٱلَّذِينَ تَسْتَبْقُونَ مِنْهُمْ أَشْوَاكًا فِي أَعْيُنِكُمْ، وَمَنَاخِسَ فِي جَوَانِبِكُمْ، وَيُضَايِقُونَكُمْ عَلَى ٱلْأَرْضِ ٱلَّتِي أَنْتُمْ سَاكِنُونَ فِيهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","فَيَكُونُ أَنِّي أَفْعَلُ بِكُمْ كَمَا هَمَمْتُ أَنْ أَفْعَلَ بِهِمْ». ");
INSERT INTO arb_vd_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: إِنَّكُمْ دَاخِلُونَ إِلَى أَرْضِ كَنْعَانَ. هَذِهِ هِيَ ٱلْأَرْضُ ٱلَّتِي تَقَعُ لَكُمْ نَصِيبًا. أَرْضُ كَنْعَانَ بِتُخُومِهَا: ");
INSERT INTO arb_vd_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","تَكُونُ لَكُمْ نَاحِيَةُ ٱلْجَنُوبِ مِنْ بَرِّيَّةِ صِينَ عَلَى جَانِبِ أَدُومَ، وَيَكُونُ لَكُمْ تُخْمُ ٱلْجَنُوبِ مِنْ طَرَفِ بَحْرِ ٱلْمِلْحِ إِلَى ٱلشَّرْقِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","وَيَدُورُ لَكُمُ ٱلتَّخْمُ مِنْ جَنُوبِ عَقَبَةِ عَقْرِبِّيمَ، وَيَعْبُرُ إِلَى صِينَ، وَتَكُونُ مَخَارِجُهُ مِنْ جَنُوبِ قَادَشَ بَرْنِيعَ، وَيَخْرُجُ إِلَى حَصَرِ أَدَّارَ، وَيَعْبُرُ إِلَى عَصْمُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ثُمَّ يَدُورُ ٱلتَّخْمُ مِنْ عَصْمُونَ إِلَى وَادِي مِصْرَ، وَتَكُونُ مَخَارِجُهُ عِنْدَ ٱلْبَحْرِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","وَأَمَّا تُخْمُ ٱلْغَرْبِ فَيَكُونُ ٱلْبَحْرُ ٱلْكَبِيرُ لَكُمْ تُخْمًا. هَذَا يَكُونُ لَكُمْ تُخْمُ ٱلْغَرْبِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","وَهَذَا يَكُونُ لَكُمْ تُخْمُ ٱلشِّمَالِ. مِنَ ٱلْبَحْرِ ٱلْكَبِيرِ تَرْسُمُونَ لَكُمْ إِلَى جَبَلِ هُورَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","وَمِنْ جَبَلِ هُورَ تَرْسُمُونَ إِلَى مَدْخَلِ حَمَاةَ، وَتَكُونُ مَخَارِجُ ٱلتَّخْمِ إِلَى صَدَدَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ثُمَّ يَخْرُجُ ٱلتَّخْمُ إِلَى زِفْرُونَ، وَتَكُونُ مَخَارِجُهُ عِنْدَ حَصَرِ عِينَانَ. هَذَا يَكُونُ لَكُمْ تُخْمُ ٱلشِّمَالِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","وَتَرْسُمُونَ لَكُمْ تَخْمًا إِلَى ٱلشَّرْقِ مِنْ حَصَرِ عِينَانَ إِلَى شَفَامَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","وَيَنْحَدِرُ ٱلتَّخْمُ مِنْ شَفَامَ إِلَى رَبْلَةَ شَرْقِيَّ عَيْنٍ. ثُمَّ يَنْحَدِرُ ٱلتَّخْمُ وَيَمَسُّ جَانِبَ بَحْرِ كِنَّارَةَ إِلَى ٱلشَّرْقِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ثُمَّ يَنْحَدِرُ ٱلتَّخْمُ إِلَى ٱلْأُرْدُنِّ، وَتَكُونُ مَخَارِجُهُ عِنْدَ بَحْرِ ٱلْمِلْحِ. هَذِهِ تَكُونُ لَكُمُ ٱلْأَرْضُ بِتُخُومِهَا حَوَالَيْهَا». ");
INSERT INTO arb_vd_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","فَأَمَرَ مُوسَى بَنِي إِسْرَائِيلَ قَائِلًا: «هَذِهِ هِيَ ٱلْأَرْضُ ٱلَّتِي تَقْتَسِمُونَهَا بِٱلْقُرْعَةِ، ٱلَّتِي أَمَرَ ٱلرَّبُّ أَنْ تُعْطَى لِلتِّسْعَةِ ٱلْأَسْبَاطِ وَنِصْفِ ٱلسِّبْطِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","لِأَنَّهُ قَدْ أَخَذَ سِبْطُ بَنِي رَأُوبَيْنَ حَسَبَ بُيُوتِ آبَائِهِمْ، وَسِبْطُ بَنِي جَادَ حَسَبَ بُيُوتِ آبَائِهِمْ، وَنِصْفُ سِبْطِ مَنَسَّى. قَدْ أَخَذُوا نَصِيبَهُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","اَلسِّبْطَانِ وَنِصْفُ ٱلسِّبْطِ قَدْ أَخَذُوا نَصِيبَهُمْ فِي عَبْرِ أُرْدُنِّ أَرِيحَا شَرْقًا، نَحْوَ ٱلشُّرُوقِ». ");
INSERT INTO arb_vd_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«هَذَانِ ٱسْمَا ٱلرَّجُلَيْنِ ٱللَّذَيْنِ يَقْسِمَانِ لَكُمُ ٱلْأَرْضَ: أَلِعَازَارُ ٱلْكَاهِنُ وَيَشُوعُ بْنُ نُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","وَرَئِيسًا وَاحِدًا مِنْ كُلِّ سِبْطٍ تَأْخُذُونَ لِقِسْمَةِ ٱلْأَرْضِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","وَهَذِهِ أَسْمَاءُ ٱلرِّجَالِ: مِنْ سِبْطِ يَهُوذَا كَالِبُ بْنُ يَفُنَّةَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","وَمِنْ سِبْطِ بَنِي شِمْعُونَ شَمُوئِيلُ بْنُ عَمِّيهُودَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","وَمِنْ سِبْطِ بَنْيَامِينَ أَلِيدَادُ بْنُ كَسْلُونَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","وَمِنْ سِبْطِ بَنِي دَانَ ٱلرَّئِيسُ بُقِّي بْنُ يُجْلِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","وَمِنْ بَنِي يُوسُفَ: مِنْ سِبْطِ بَنِي مَنَسَّى ٱلرَّئِيسُ حَنِّيئِيلُ بْنُ إِيفُودَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","وَمِنْ سِبْطِ بَنِي أَفْرَايِمَ ٱلرَّئِيسُ قَمُوئِيلُ بْنُ شِفْطَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","وَمِنْ سِبْطِ بَنِي زَبُولُونَ ٱلرَّئِيسُ أَلِيصَافَانُ بْنُ فَرْنَاخَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","وَمِنْ سِبْطِ بَنِي يَسَّاكَرَ ٱلرَّئِيسُ فَلْطِيئِيلُ بْنُ عَزَّانَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","وَمِنْ سِبْطِ بَنِي أَشِيرَ ٱلرَّئِيسُ أَخِيهُودُ بْنُ شَلُومِي. ");
INSERT INTO arb_vd_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","وَمِنْ سِبْطِ بَنِي نَفْتَالِي ٱلرَّئِيسُ فَدَهْئِيلُ بْنُ عَمِّيهُودَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","هَؤُلَاءِ هُمُ ٱلَّذِينَ أَمَرَهُمُ ٱلرَّبُّ أَنْ يَقْسِمُوا لِبَنِي إِسْرَائِيلَ فِي أَرْضِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ثُمَّ كَلَّمَ ٱلرَّبُّ مُوسَى فِي عَرَبَاتِ مُوآبَ عَلَى أُرْدُنِّ أَرِيحَا قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«أَوْصِ بَنِي إِسْرَائِيلَ أَنْ يُعْطُوا ٱللَّاوِيِّينَ مِنْ نَصِيبِ مُلْكِهِمْ مُدُنًا لِلسَّكَنِ، وَمَسَارِحَ لِلْمُدُنِ حَوَالَيْهَا تُعْطُونَ ٱللَّاوِيِّينَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","فَتَكُونُ ٱلْمُدُنُ لَهُمْ لِلسَّكَنِ وَمَسَارِحُهَا تَكُونُ لِبَهَائِمِهِمْ وَأَمْوَالِهِمْ وَلِسَائِرِ حَيَوَانَاتِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","وَمَسَارِحُ ٱلْمُدُنِ ٱلَّتِي تُعْطُونَ ٱللَّاوِيِّينَ تَكُونُ مِنْ سُورِ ٱلْمَدِينَةِ إِلَى جِهَةِ ٱلْخَارِجِ أَلْفَ ذِرَاعٍ حَوَالَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","فَتَقِيسُونَ مِنْ خَارِجِ ٱلْمَدِينَةِ جَانِبَ ٱلشَّرْقِ أَلْفَيْ ذِرَاعٍ، وَجَانِبَ ٱلْجَنُوبِ أَلْفَيْ ذِرَاعٍ، وَجَانِبَ ٱلْغَرْبِ أَلْفَيْ ذِرَاعٍ، وَجَانِبَ ٱلشِّمَالِ أَلْفَيْ ذِرَاعٍ، وَتَكُونُ ٱلْمَدِينَةُ فِي ٱلْوَسَطِ. هَذِهِ تَكُونُ لَهُمْ مَسَارِحَ ٱلْمُدُنِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","«وَٱلْمُدُنُ ٱلَّتِي تُعْطُونَ ٱللَّاوِيِّينَ تَكُونُ سِتٌّ مِنْهَا مُدُنًا لِلْمَلْجَإِ. تُعْطُونَهَا لِكَيْ يَهْرُبَ إِلَيْهَا ٱلْقَاتِلُ. وَفَوْقَهَا تُعْطُونَ ٱثْنَتَيْنِ وَأَرْبَعِينَ مَدِينَةً. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","جَمِيعُ ٱلْمُدُنِ ٱلَّتِي تُعْطُونَ ٱللَّاوِيِّينَ ثَمَانِي وَأَرْبَعُونَ مَدِينَةً مَعَ مَسَارِحِهَا. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","وَٱلْمُدُنُ ٱلَّتِي تُعْطُونَ مِنْ مُلْكِ بَنِي إِسْرَائِيلَ، مِنَ ٱلْكَثِيرِ تُكَثِّرُونَ، وَمِنَ ٱلْقَلِيلِ تُقَلِّلُونَ. كُلُّ وَاحِدٍ حَسَبَ نَصِيبِهِ ٱلَّذِي مَلَكَهُ يُعْطِي مِنْ مُدُنِهِ لِلَّاوِيِّينَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","وَكَلَّمَ ٱلرَّبُّ مُوسَى قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«كَلِّمْ بَنِي إِسْرَائِيلَ وَقُلْ لَهُمْ: إِنَّكُمْ عَابِرُونَ ٱلْأُرْدُنَّ إِلَى أَرْضِ كَنْعَانَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","فَتُعَيِّنُونَ لِأَنْفُسِكُمْ مُدُنًا تَكُونُ مُدُنَ مَلْجَإٍ لَكُمْ، لِيَهْرُبَ إِلَيْهَا ٱلْقَاتِلُ ٱلَّذِي قَتَلَ نَفْسًا سَهْوًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","فَتَكُونُ لَكُمُ ٱلْمُدُنُ مَلْجَأً مِنَ ٱلْوَلِيِّ، لِكَيْلَا يَمُوتَ ٱلْقَاتِلُ حَتَّى يَقِفَ أَمَامَ ٱلْجَمَاعَةِ لِلْقَضَاءِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","وَٱلْمُدُنُ ٱلَّتِي تُعْطُونَ تَكُونُ سِتَّ مُدُنِ مَلْجَإٍ لَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ثَلَاثًا مِنَ ٱلْمُدُنِ تُعْطُونَ فِي عَبْرِ ٱلْأُرْدُنِّ، وَثَلَاثًا مِنَ ٱلْمُدُنِ تُعْطُونَ فِي أَرْضِ كَنْعَانَ. مُدُنَ مَلْجَإٍ تَكُونُ ");
INSERT INTO arb_vd_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","لِبَنِي إِسْرَائِيلَ وَلِلْغَرِيبِ وَلِلْمُسْتَوْطِنِ فِي وَسَطِهِمْ تَكُونُ هَذِهِ ٱلسِّتُّ ٱلْمُدُنِ لِلْمَلْجَإِ، لِكَيْ يَهْرُبَ إِلَيْهَا كُلُّ مَنْ قَتَلَ نَفْسًا سَهْوًا. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","«إِنْ ضَرَبَهُ بِأَدَاةِ حَدِيدٍ فَمَاتَ، فَهُوَ قَاتِلٌ. إِنَّ ٱلْقَاتِلَ يُقْتَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","وَإِنْ ضَرَبَهُ بِحَجَرِ يَدٍ مِمَّا يُقْتَلُ بِهِ فَمَاتَ، فَهُوَ قَاتِلٌ. إِنَّ ٱلْقَاتِلَ يُقْتَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","أَوْ ضَرَبَهُ بِأَدَاةِ يَدٍ مِنْ خَشَبٍ مِمَّا يُقْتَلُ بِهِ، فَهُوَ قَاتِلٌ. إِنَّ ٱلْقَاتِلَ يُقْتَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","وَلِيُّ ٱلدَّمِ يَقْتُلُ ٱلْقَاتِلَ. حِينَ يُصَادِفُهُ يَقْتُلُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","وَإِنْ دَفَعَهُ بِبُغْضَةٍ أَوْ أَلْقَى عَلَيْهِ شَيْئًا بِتَعَمُّدٍ فَمَاتَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","أَوْ ضَرَبَهُ بِيَدِهِ بِعَدَاوَةٍ فَمَاتَ، فَإِنَّهُ يُقْتَلُ ٱلضَّارِبُ لِأَنَّهُ قَاتِلٌ. وَلِيُّ ٱلدَّمِ يَقْتُلُ ٱلْقَاتِلَ حِينَ يُصَادِفُهُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","وَلَكِنْ إِنْ دَفَعَهُ بَغْتَةً بِلَا عَدَاوَةٍ، أَوْ أَلْقَى عَلَيْهِ أَدَاةً مَّا بِلَا تَعَمُّدٍ، ");
INSERT INTO arb_vd_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","أَوْ حَجَرًا مَّا مِمَّا يُقْتَلُ بِهِ بِلَا رُؤْيَةٍ. أَسْقَطَهُ عَلَيْهِ فَمَاتَ، وَهُوَ لَيْسَ عَدُوًّا لَهُ وَلَا طَالِبًا أَذِيَّتَهُ، ");
INSERT INTO arb_vd_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","تَقْضِي ٱلْجَمَاعَةُ بَيْنَ ٱلْقَاتِلِ وَبَيْنَ وَلِيِّ ٱلدَّمِ، حَسَبَ هَذِهِ ٱلْأَحْكَامِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","وَتُنْقِذُ ٱلْجَمَاعَةُ ٱلْقَاتِلَ مِنْ يَدِ وَلِيِّ ٱلدَّمِ، وَتَرُدُّهُ ٱلْجَمَاعَةُ إِلَى مَدِينَةِ مَلْجَئِهِ ٱلَّتِي هَرَبَ إِلَيْهَا، فَيُقِيمُ هُنَاكَ إِلَى مَوْتِ ٱلْكَاهِنِ ٱلْعَظِيمِ ٱلَّذِي مُسِحَ بِٱلدُّهْنِ ٱلْمُقَدَّسِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","وَلَكِنْ إِنْ خَرَجَ ٱلْقَاتِلُ مِنْ حُدُودِ مَدِينَةِ مَلْجَئِهِ ٱلَّتِي هَرَبَ إِلَيْهَا، ");
INSERT INTO arb_vd_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","وَوَجَدَهُ وَلِيُّ ٱلدَّمِ خَارِجَ حُدُودِ مَدِينَةِ مَلْجَئِهِ، وَقَتَلَ وَلِيُّ ٱلدَّمِ ٱلْقَاتِلَ، فَلَيْسَ لَهُ دَمٌ، ");
INSERT INTO arb_vd_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","لِأَنَّهُ فِي مَدِينَةِ مَلْجَئِهِ يُقِيمُ إِلَى مَوْتِ ٱلْكَاهِنِ ٱلْعَظِيمِ. وَأَمَّا بَعْدَ مَوْتِ ٱلْكَاهِنِ ٱلْعَظِيمِ فَيَرْجِعُ ٱلْقَاتِلُ إِلَى أَرْضِ مُلْكِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","«فَتَكُونُ هَذِهِ لَكُمْ فَرِيضَةَ حُكْمٍ إِلَى أَجْيَالِكُمْ فِي جَمِيعِ مَسَاكِنِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","كُلُّ مَنْ قَتَلَ نَفْسًا فَعَلَى فَمِ شُهُودٍ يُقْتَلُ ٱلْقَاتِلُ. وَشَاهِدٌ وَاحِدٌ لَا يَشْهَدْ عَلَى نَفْسٍ لِلْمَوْتِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","وَلَا تَأْخُذُوا فِدْيَةً عَنْ نَفْسِ ٱلْقَاتِلِ ٱلْمُذْنِبِ لِلْمَوْتِ، بَلْ إِنَّهُ يُقْتَلُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","وَلَا تَأْخُذُوا فِدْيَةً لِيَهْرُبَ إِلَى مَدِينَةِ مَلْجَئِهِ، فَيَرْجِعَ وَيَسْكُنَ فِي ٱلْأَرْضِ بَعْدَ مَوْتِ ٱلْكَاهِنِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","لَا تُدَنِّسُوا ٱلْأَرْضَ ٱلَّتِي أَنْتُمْ فِيهَا، لِأَنَّ ٱلدَّمَ يُدَنِّسُ ٱلْأَرْضَ. وَعَنِ ٱلْأَرْضِ لَا يُكَفَّرُ لِأَجْلِ ٱلدَّمِ ٱلَّذِي سُفِكَ فِيهَا، إِلَا بِدَمِ سَافِكِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","وَلَا تُنَجِّسُوا ٱلْأَرْضَ ٱلَّتِي أَنْتُمْ مُقِيمُونَ فِيهَا ٱلَّتِي أَنَا سَاكِنٌ فِي وَسَطِهَا. إِنِّي أَنَا ٱلرَّبُّ سَاكِنٌ فِي وَسَطِ بَنِي إِسْرَائِيلَ». ");
INSERT INTO arb_vd_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","وَتَقَدَّمَ رُؤُوسُ ٱلْآبَاءِ مِنْ عَشِيرَةِ بَنِي جِلْعَادَ بْنِ مَاكِيرَ بْنِ مَنَسَّى مِنْ عَشَائِرِ بَنِي يُوسُفَ، وَتَكَلَّمُوا قُدَّامَ مُوسَى وَقُدَّامَ ٱلرُّؤَسَاءِ رُؤُوسِ ٱلْآبَاءِ مِنْ بَنِي إِسْرَائِيلَ، ");
INSERT INTO arb_vd_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","وَقَالُوا: «قَدْ أَمَرَ ٱلرَّبُّ سَيِّدِي أَنْ يُعْطِيَ ٱلْأَرْضَ بِقِسْمَةٍ بِٱلْقُرْعَةِ لِبَنِي إِسْرَائِيلَ. وَقَدْ أُمِرَ سَيِّدِي مِنَ ٱلرَّبِّ أَنْ يُعْطِيَ نَصِيبَ صَلُفْحَادَ أَخِينَا لِبَنَاتِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","فَإِنْ صِرْنَ نِسَاءً لِأَحَدٍ مِنْ بَنِي أَسْبَاطِ بَنِي إِسْرَائِيلَ، يُؤْخَذُ نَصِيبُهُنَّ مِنْ نَصِيبِ آبَائِنَا وَيُضَافُ إِلَى نَصِيبِ ٱلسِّبْطِ ٱلَّذِي صِرْنَ لَهُ. فَمِنْ قُرْعَةِ نَصِيبِنَا يُؤْخَذُ. ");
INSERT INTO arb_vd_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","وَمَتَى كَانَ ٱلْيُوبِيلُ لِبَنِي إِسْرَائِيلَ يُضَافُ نَصِيبُهُنَّ إِلَى نَصِيبِ ٱلسِّبْطِ ٱلَّذِي صِرْنَ لَهُ، وَمِنْ نَصِيبِ سِبْطِ آبَائِنَا يُؤْخَذُ نَصِيبُهُنَّ». ");
INSERT INTO arb_vd_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","فَأَمَرَ مُوسَى بَنِي إِسْرَائِيلَ حَسَبَ قَوْلِ ٱلرَّبِّ قَائِلًا: «بِحَقٍّ تَكَلَّمَ سِبْطُ بَنِي يُوسُفَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","هَذَا مَا أَمَرَ بِهِ ٱلرَّبُّ عَنْ بَنَاتِ صَلُفْحَادَ قَائِلًا: مَنْ حَسُنَ فِي أَعْيُنِهِنَّ يَكُنَّ لَهُ نِسَاءً، وَلَكِنْ لِعَشِيرَةِ سِبْطِ آبَائِهِنَّ يَكُنَّ نِسَاءً. ");
INSERT INTO arb_vd_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","فَلَا يَتَحَوَّلُ نَصِيبٌ لِبَنِي إِسْرَائِيلَ مِنْ سِبْطٍ إِلَى سِبْطٍ، بَلْ يُلَازِمُ بَنُو إِسْرَائِيلَ كُلُّ وَاحِدٍ نَصِيبَ سِبْطِ آبَائِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","وَكُلُّ بِنْتٍ وَرَثَتْ نَصِيبًا مِنْ أَسْبَاطِ بَنِي إِسْرَائِيلَ تَكُونُ ٱمْرَأَةً لِوَاحِدٍ مِنْ عَشِيرَةِ سِبْطِ أَبِيهَا، لِكَيْ يَرِثَ بَنُو إِسْرَائِيلَ كُلُّ وَاحِدٍ نَصِيبَ آبَائِهِ، ");
INSERT INTO arb_vd_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","فَلَا يَتَحَوَّلْ نَصِيبٌ مِنْ سِبْطٍ إِلَى سِبْطٍ آخَرَ، بَلْ يُلَازِمُ أَسْبَاطُ بَنِي إِسْرَائِيلَ كُلُّ وَاحِدٍ نَصِيبَهُ». ");
INSERT INTO arb_vd_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","كَمَا أَمَرَ ٱلرَّبُّ مُوسَى كَذَلِكَ فَعَلَتْ بَنَاتُ صَلُفْحَادَ. ");
INSERT INTO arb_vd_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","فَصَارَتْ مَحْلَةُ وَتِرْصَةُ وَحَجْلَةُ وَمِلْكَةُ وَنُوعَةُ بَنَاتُ صَلُفْحَادَ نِسَاءً لِبَنِي أَعْمَامِهِنَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","صِرْنَ نِسَاءً مِنْ عَشَائِرِ بَنِي مَنَسَّى بْنِ يُوسُفَ، فَبَقِيَ نَصِيبُهُنَّ فِي سِبْطِ عَشِيرَةِ أَبِيهِنَّ. ");
INSERT INTO arb_vd_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","هَذِهِ هِيَ ٱلْوَصَايَا وَٱلْأَحْكَامُ ٱلَّتِي أَوْصَى بِهَا ٱلرَّبُّ إِلَى بَنِي إِسْرَائِيلَ عَنْ يَدِ مُوسَى، فِي عَرَبَاتِ مُوآبَ عَلَى أُرْدُنِّ أَرِيحَا. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","هَذَا هُوَ ٱلْكَلَامُ ٱلَّذِي كَلَّمَ بِهِ مُوسَى جَمِيعَ إِسْرَائِيلَ فِي عَبْرِ ٱلْأُرْدُنِّ، فِي ٱلْبَرِّيَّةِ فِي ٱلْعَرَبَةِ، قُبَالَةَ سُوفَ، بَيْنَ فَارَانَ وَتُوفَلَ وَلَابَانَ وَحَضَيْرُوتَ وَذِي ذَهَبٍ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","أَحَدَ عَشَرَ يَوْمًا مِنْ حُورِيبَ عَلَى طَرِيقِ جَبَلِ سِعِيرَ إِلَى قَادَشَ بَرْنِيعَ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","فَفِي ٱلسَّنَةِ ٱلْأَرْبَعِينَ، فِي ٱلشَّهْرِ ٱلْحَادِي عَشَرَ فِي ٱلْأَوَّلِ مِنَ ٱلشَّهْرِ، كَلَّمَ مُوسَى بَنِي إِسْرَائِيلَ حَسَبَ كُلِّ مَا أَوْصَاهُ ٱلرَّبُّ إِلَيْهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","بَعْدَ مَا ضَرَبَ سِيحُونَ مَلِكَ ٱلْأَمُورِيِّينَ ٱلسَّاكِنَ فِي حَشْبُونَ، وَعُوجَ مَلِكَ بَاشَانَ ٱلسَّاكِنَ فِي عَشْتَارُوثَ فِي إِذْرَعِي. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","فِي عَبْرِ ٱلْأُرْدُنِّ، فِي أَرْضِ مُوآبَ، ٱبْتَدَأَ مُوسَى يَشْرَحُ هَذِهِ ٱلشَّرِيعَةَ قَائِلًا: ");
INSERT INTO arb_vd_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«اَلرَّبُّ إِلَهُنَا كَلَّمَنَا فِي حُورِيبَ قَائِلًا: كَفَاكُمْ قُعُودٌ فِي هَذَا ٱلْجَبَلِ، ");
INSERT INTO arb_vd_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","تَحَوَّلُوا وَٱرْتَحِلُوا وَٱدْخُلُوا جَبَلَ ٱلْأَمُورِيِّينَ وَكُلَّ مَا يَلِيهِ مِنَ ٱلْعَرَبَةِ وَٱلْجَبَلِ وَٱلسَّهْلِ وَٱلْجَنُوبِ وَسَاحِلِ ٱلْبَحْرِ، أَرْضَ ٱلْكَنْعَانِيِّ وَلُبْنَانَ إِلَى ٱلنَّهْرِ ٱلْكَبِيرِ، نَهْرِ ٱلْفُرَاتِ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","اُنْظُرْ. قَدْ جَعَلْتُ أَمَامَكُمُ ٱلْأَرْضَ. ٱدْخُلُوا وَتَمَلَّكُوا ٱلْأَرْضَ ٱلَّتِي أَقْسَمَ ٱلرَّبُّ لِآبَائِكُمْ إِبْرَاهِيمَ وَإِسْحَاقَ وَيَعْقُوبَ أَنْ يُعْطِيَهَا لَهُمْ وَلِنَسْلِهِمْ مِنْ بَعْدِهِمْ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","«وَكَلَّمْتُكُمْ فِي ذَلِكَ ٱلْوَقْتِ قَائِلًا: لَا أَقْدِرُ وَحْدِي أَنْ أَحْمِلَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","اَلرَّبُّ إِلَهُكُمْ قَدْ كَثَّرَكُمْ. وَهُوَذَا أَنْتُمُ ٱلْيَوْمَ كَنُجُومِ ٱلسَّمَاءِ فِي ٱلْكَثْرَةِ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ٱلرَّبُّ إِلَهُ آبَائِكُمْ يَزِيدُ عَلَيْكُمْ مِثْلَكُمْ أَلْفَ مَرَّةٍ، وَيُبَارِكُكُمْ كَمَا كَلَّمَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","كَيْفَ أَحْمِلُ وَحْدِي ثِقْلَكُمْ وَحِمْلَكُمْ وَخُصُومَتَكُمْ؟ ");
INSERT INTO arb_vd_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","هَاتُوا مِنْ أَسْبَاطِكُمْ رِجَالًا حُكَمَاءَ وَعُقَلَاءَ وَمَعْرُوفِينَ، فَأَجْعَلُهُمْ رُؤُوسَكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","فَأَجَبْتُمُونِي وَقُلْتُمْ: حَسَنٌ ٱلْأَمْرُ ٱلَّذِي تَكَلَّمْتَ بِهِ أَنْ يُعْمَلَ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","فَأَخَذْتُ رُؤُوسَ أَسْبَاطِكُمْ رِجَالًا حُكَمَاءَ وَمَعْرُوفِينَ، وَجَعَلْتُهُمْ رُؤُوسًا عَلَيْكُمْ، رُؤَسَاءَ أُلُوفٍ، وَرُؤَسَاءَ مِئَاتٍ، وَرُؤَسَاءَ خَمَاسِينَ، وَرُؤَسَاءَ عَشَرَاتٍ، وَعُرَفَاءَ لِأَسْبَاطِكُمْ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","وَأَمَرْتُ قُضَاتَكُمْ فِي ذَلِكَ ٱلْوَقْتِ قَائِلًا: ٱسْمَعُوا بَيْنَ إِخْوَتِكُمْ وَٱقْضُوا بِٱلْحَقِّ بَيْنَ ٱلْإِنْسَانِ وَأَخِيهِ وَنَزِيلِهِ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","لَا تَنْظُرُوا إِلَى ٱلْوُجُوهِ فِي ٱلْقَضَاءِ. لِلصَّغِيرِ كَٱلْكَبِيرِ تَسْمَعُونَ. لَا تَهَابُوا وَجْهَ إِنْسَانٍ لِأَنَّ ٱلْقَضَاءَ لِلهِ. وَٱلْأَمْرُ ٱلَّذِي يَعْسُرُ عَلَيْكُمْ تُقَدِّمُونَهُ إِلَيَّ لِأَسْمَعَهُ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","وَأَمَرْتُكُمْ فِي ذَلِكَ ٱلْوَقْتِ بِكُلِّ ٱلْأُمُورِ ٱلَّتِي تَعْمَلُونَهَا. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","«ثُمَّ ٱرْتَحَلْنَا مِنْ حُورِيبَ، وَسَلَكْنَا كُلَّ ذَلِكَ ٱلْقَفْرِ ٱلْعَظِيمِ ٱلْمَخُوفِ ٱلَّذِي رَأَيْتُمْ فِي طَرِيقِ جَبَلِ ٱلْأَمُورِيِّينَ، كَمَا أَمَرَنَا ٱلرَّبُّ إِلَهُنَا. وَجِئْنَا إِلَى قَادَشَ بَرْنِيعَ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","فَقُلْتُ لَكُمْ: قَدْ جِئْتُمْ إِلَى جَبَلِ ٱلْأَمُورِيِّينَ ٱلَّذِي أَعْطَانَا ٱلرَّبُّ إِلَهُنَا. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","اُنْظُرْ. قَدْ جَعَلَ ٱلرَّبُّ إِلَهُكَ ٱلْأَرْضَ أَمَامَكَ. ٱصْعَدْ تَمَلَّكْ كَمَا كَلَّمَكَ ٱلرَّبُّ إِلَهُ آبَائِكَ. لَا تَخَفْ وَلَا تَرْتَعِبْ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","فَتَقَدَّمْتُمْ إِلَيَّ جَمِيعُكُمْ وَقُلْتُمْ: دَعْنَا نُرْسِلْ رِجَالًا قُدَّامَنَا لِيَتَجَسَّسُوا لَنَا ٱلْأَرْضَ، وَيَرُدُّوا إِلَيْنَا خَبَرًا عَنِ ٱلطَّرِيقِ ٱلَّتِي نَصْعَدُ فِيهَا وَٱلْمُدُنِ ٱلَّتِي نَأْتِي إِلَيْهَا. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","فَحَسُنَ ٱلْكَلَامُ لَدَيَّ، فَأَخَذْتُ مِنْكُمُ ٱثْنَيْ عَشَرَ رَجُلًا. رَجُلًا وَاحِدًا مِنْ كُلِّ سِبْطٍ. ");
INSERT INTO arb_vd_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","فَٱنْصَرَفُوا وَصَعِدُوا إِلَى ٱلْجَبَلِ وَأَتَوْا إِلَى وَادِي أَشْكُولَ وَتَجَسَّسُوهُ، ");
INSERT INTO arb_vd_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","وَأَخَذُوا فِي أَيْدِيهِمْ مِنْ أَثْمَارِ ٱلْأَرْضِ وَنَزَلُوا بِهِ إِلَيْنَا، وَرَدُّوا لَنَا خَبَرًا وَقَالُوا: جَيِّدَةٌ هِيَ ٱلْأَرْضُ ٱلَّتِي أَعْطَانَا ٱلر