﻿USE sofia;
DROP TABLE IF EXISTS sofia.apz_vpl;
CREATE TABLE apz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES apz_vpl WRITE;
INSERT INTO apz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Olo aꞌamu lohwa Jisas Kɨlaisɨye hofiyakwosafoho. Jisas kako hwe yofe engoꞌnjo Ntefit sohwoꞌnji Apɨlohamꞌnjiye temtitofo mtaꞌango hweho. ");
INSERT INTO apz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Apɨloham sohwo Aisakɨye kanɨngkwohweho. Aisak sohwo Jekoupɨye kanɨngkwohweho. Jekoup sohwo Jutaꞌnji homnɨngkwaꞌwehwosanjiye kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juta sohwo kako Pelesɨꞌnji Selaꞌnjiye kanɨngkwohweho. Sikoe konaꞌwohisi Temafoho. Peles sohwo Hesɨlounɨye kanɨngkwohweho. Hesɨloun sohwo Lamɨye kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lam sohwo Aminotapɨye kanɨngkwohweho. Aminotap sohwo Nasounɨye kanɨngkwohweho. Nasoun sohwo Salɨmounɨye kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salɨmoun sohwo Mpouasɨye kanɨngkwohweho. Mpouasɨye konaꞌwohisi Lehapɨyoho. Mpouas sohwo Oupetɨye kanɨngkwohweho. Oupetɨye konaꞌwohisi Lutɨyoho. Oupet sohwo Jesiye kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi sohwo hwe yofe engoꞌnjo Ntefitɨye kanɨngkwohweho. Ntefit sohwo Yulaiyafe ape nomanto Soulomoun tɨpemaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soulomoun sohwo Leyapouamɨye kanɨngkwohweho. Leyapouam sohwo Apiyafe kanɨngkwohweho. Apiya sohwo Asafe kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa sohwo Jehousofatɨye kanɨngkwohweho. Jehousofat sohwo Joulamɨye kanɨngkwohweho. Joulam sohwo Usiyafe kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiya sohwo Joutamɨye kanɨngkwohweho. Joutam sohwo Ehasɨye kanɨngkwohweho. Ehas sohwo Hesekiyafe kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiya sohwo Monaseye kanɨngkwohweho. Monase sohwo Emounɨye kanɨngkwohweho. Emoun sohwo Jousaiyafe kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jousaiya sohwo Jekounaiyaꞌnji homnɨngkwaꞌwehwosanjiye kanɨngkwohweho. Hohosohonta aꞌamu Mpapilounntaꞌangoso aꞌamu Isɨlael somo impe intofontɨfi ango Mpapiloun neꞌno motawoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mpapiloun neꞌno motawoꞌmentohofo sohonta Jekounaiya sohwo Siyalɨtiyelɨye kanɨngkwohwo imoꞌnɨmentisofoho. Siyalɨtiyel sohwo Selopapelɨye kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selepapel sohwo Apiyoutɨfe kanɨngkwohweho. Apiyout sohwo Elaiyakimɨye kanɨngkwohweho. Elaiyakim sohwo Esoufe kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esou sohwo Satoukɨye kanɨngkwohweho. Satouk sohwo Ekimɨye kanɨngkwohweho. Ekim sohwo Elaiyatɨye kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaiyat sohwo Eleyasafe kanɨngkwohweho. Eleyasa sohwo Matanɨye kanɨngkwohweho. Matan sohwo Jekoupɨye kanɨngkwohweho. ");
INSERT INTO apz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekoup sohwo Jousepɨye kanɨngkwohweho. Jousep sohwo Maliyafe hwe hweho. Maliya Jisasɨmo maꞌmentisofoho. Jisas huhwo sohwo hofɨko yofe Kɨlaisɨyoho mulɨmentohofofoho. Hwe huhwo sohumo Anɨtu uhwosopento nakwoe hwaho lopono uhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Apɨloham kakoe imuso hofɨkoꞌmontohwa aho hufaꞌu hopiꞌnono nomꞌne sɨfe mtaꞌni osofosofahuꞌno mjimoꞌnɨmɨwahonɨngkofi Ntefit imoꞌnɨmentisofoho. Ntefitɨye imuso hofɨkoꞌmontohwa aho hufaꞌu hopiꞌnono nomꞌne sɨfe mtaꞌni osofosofahuꞌno mjimoꞌnɨmɨwahonɨngkofi aꞌamu Isɨlael somo ango Mpapiloun neꞌno motawoꞌmentohofofoho. Osohonta hofɨkoꞌmontohwa aho hufaꞌu hopiꞌnono nomꞌne sɨfe mtaꞌni osofosofahuꞌno mjimoꞌnɨmɨwahonɨngkofi Jisas Kɨlais imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Olo hungkuno Jisas Kɨlais imoꞌnɨmentiso soꞌnoyolohoso ole, Jousep Jisasɨye konaꞌwohi Maliya simo kakoꞌne ape nto ufohotoꞌmentohofofoho. I osoꞌno Jousep Maliyamo momaso sohonta Maliya sɨmeho Anɨtuye Towahuno mtaꞌango imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maliyafe hwehwo Jousep kako hwe wopɨngoꞌnohino hweho. Jousep ole syafɨhuꞌmento, Maliya wonɨmango unonoho. Ose syafɨsyonto olo hungkuno hiloso hiyaso waweno syafɨhuꞌmentisofoho. Osoꞌno ngko hungkuno ape mayoꞌne wamtɨhupoꞌmo. ");
INSERT INTO apz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Oso hisoꞌno ko syafɨsyonto wojo honɨngkanɨmentisoso aꞌamu Anɨtu mtaꞌango sohwo kakimo uꞌmanto ulɨmento, Jousep, Ntefitɨye imu sohwosi, kɨko ape Maliya mayosoꞌno iyoho kinɨngkuhwoloho. Upaꞌnyo. Maliyafe sɨmehomo mehomi nto imoꞌnɨmaho. Oso hiso Anɨtuye Towahuno uyɨmaso hweho. ");
INSERT INTO apz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maliya hwomu nomahwosoꞌno kɨko yofe ole muso, Jisasɨyoho. Yofe hwapɨngoso ole, olo hwe lohwo kako aꞌamufe wonyoso wae yaofɨhwosi asomo utɨmayoꞌne hweho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Hohonta Anɨtu hwe Aisaiya sohumo hungkuno uyahonɨngki kako aꞌamumo ulɨmojo sohwo kako hungkuno hiso mtɨꞌmokumentisofoho. Olo hiloso ne imoꞌnyo soꞌno Maliya mehomiꞌnji imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ole mtɨꞌmokumento, Upaꞌnɨmno. Ape sijo wopɨngosi hwehwo momasosi kako sɨmeho imoꞌnɨngkuhwosi hwomu nomaniyoho. Hwomu huhwo sohwo ole mulɨfitnnefo Imanɨwel. Yofe hwapɨngoso ole, Mpohwo Anɨtu nakwoꞌnji humayoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jousep oso wojo hiso honɨngkanonto nolɨkafonto aꞌamu Anɨtu mtaꞌango sohwoe hungkunomo haloho pento kako Maliyamo maꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","I osoꞌno siko afapo ko humanji afa saho mofosyawosofoho. Ose humamojiyofoho. Osoꞌno ose humamojiye sohonta Maliya kako hwomu maꞌmentisofoho. Nomahonɨngki Jousep hwomu huhwo sohumo yofe Jisasɨyoho mulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Hwe yofe engoꞌnjo Helout kako hwaho Jutiya mokosyohumamojo sohonta oso hwaho ango Mpetɨlehem sopo Maliya Jisasɨmo aswo maꞌmentisofoho. Hwangku sohonta aꞌamu temtitofo kengo mtaꞌango fihwa hofɨko hwaho mofehiꞌnyo sɨꞌmofapiso mtaꞌango sohwa hntokwaliyo uhwonontɨfi huno engo tɨpemaꞌmentohofo sohwa Jelusalem siꞌmofapontɨfi aꞌamu sohwamo ulɨmentohofi, ");
INSERT INTO apz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mehomi milongo aꞌamu Jutafe hwe yofe engoꞌnjo hwaho mokosyohumayoꞌne sohwo imoꞌnɨngkohoho. Oso huhwo sohwo ntɨꞌmo humaho. Kakoe sɨkuno imoꞌnyoꞌne soꞌno hntokwaliyo mofehiꞌnyo sɨꞌmofapiso sohohntaꞌni ahwomo somo uhwonontani nakwo kakineꞌno hwomtame ulohofoꞌne pɨhwono. ");
INSERT INTO apz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ose ulahonɨngkofi hwe yofe engoꞌnjo Helout nupaꞌnonto yomo engo imentisofoho. Aꞌamu Jelusalem humamotofoso nupaꞌnontɨfi yomo engo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hwe engo Helout kako aꞌamu yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanjimo joho ulonto ulohonɨmento, Kɨlais hwe Anɨtu uhwosopento nakwoe hwahopono uhwatɨmentiso sohuneꞌno nakwo aꞌamu Juta soꞌnwi uhwontohumayo sohwo ango ntɨpo uꞌmofapmmontolo. ");
INSERT INTO apz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ose ulahonɨngki ulɨmentohofi, Hwaho Jutiya ango Mpetɨlehemnoho. Aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo sohwa ole mtɨꞌmokumentohofi, ");
INSERT INTO apz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","U, Mpetɨlehem, sekwo ango weꞌe soku, sekwo hwaho Jutiya sopo ango yofe weꞌe paꞌnyoꞌmaho. Oꞌo, hwe yofe engoꞌnjo nje aꞌamu Isɨlael somo mokosyohumane sohwo sekwoe angopo imoꞌnonefoho. Hohonta ose mtɨꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Osoꞌno Helout aꞌamu mofehiꞌnyo sɨꞌmofapiso hohntaꞌango sohwamneꞌno joho hiyaso lutɨmanto Heloutɨꞌnji uhuꞌmokontɨfi Helout hwe huhwo sohwamo hntokwaliyo hiso iꞌmofapmmentiso sɨkuno soꞌno ulohonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ulohonɨngkahonɨngki hofɨko Heloutɨmo hungkuno asomo ulahonɨngkofi Helout ulɨmento, Sekwo ango Mpetɨlehem sopo nowekuji hafɨhafe fɨtɨpmno. Sekwo notɨpemafɨkuji hungkuno hiso ngkiyepono wapono. Ngko nupaꞌnɨꞌmo kakineꞌno hwomtame ulohoꞌmneꞌno selohono. Oso hwasyo hungkuno hiso ulonto Mpetɨlehemneꞌno luhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Oseso hofɨko Heloutɨye hungkuno upaꞌnontɨfi umentohofofoho. Nowentanɨngkofi hntokwaliyoso hofɨkoe angopo uhwonɨmentohofo hiso apaꞌno iꞌmofaponto hofɨkimo sɨmoꞌmo upeehonɨngki hofɨko tɨfi inɨngkamentohofofoho. Oso hntokwaliyoso nowento ango hwomu wentanjo antɨfe sopo lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hofɨko hntokwaliyo hiso uhwonontɨfi yomo yontɨfi sɨmeho wopɨngo umoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sɨmeho wopɨngo umoꞌnɨngkahonɨngki hofɨko ango homo somo noswontɨfi hwomu konaꞌwohi Maliyaꞌnji sikoꞌintaꞌimo uhwonɨmentohofofoho. Nuhwonontɨfi hwomtame ulohofontɨfi kakoe yofe hoꞌnomaꞌmentohofofoho. Hofɨkoe ipofo nofijontɨfi yoꞌmayo wonyoangkafo hamniyoho engo mpe iyo soꞌno uyɨmentohofofoho. Sojo wonyoangkafo soꞌnji nomꞌneso hwamno paꞌnyo akino wopɨngoꞌne soꞌnji hwone mijo wonyohofiyoꞌnji uyɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Oso hohosohonta hofɨko wojo honɨngkanɨmentohofoso Anɨtu ulɨmento, Sekwo Heloutɨyepono asomo nukutoho. Ose honɨngkanontɨfi hofɨko honɨngkano nomꞌnemo ikitokwawentɨfi hofɨkoe angopono umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nohumpeehonɨngkofi Jousep huhwo kako wojo honɨngkanɨmentisoso aꞌamu ahwomo mtaꞌango Jousepɨmo uꞌmanto ulɨmento, Kɨko hwomuꞌnji konaꞌwohiꞌnji nomahoji hwaho Ijipmneꞌno hiyaso motawe. Ijip sopo nohumentanɨngkiji nomꞌne ango soponeꞌno hano iyo soꞌno hwangku hungkuno apaꞌno wakilɨmonnoho. Hwapɨngoso Helout jɨje hwomu sohumo wofonjahumonto tɨpeelofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ose ulahonɨngki Jousep oso sɨkwoꞌmiyo somo kako Maliyaꞌnji kakoe hwomuꞌnji nomanto Ijipmneꞌno womentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jousep hwaho Ijip sopo nohumentanɨngki Helout poyo peꞌnɨmentisofoho. Oseso hungkuno hohontajo hwe fihumo Anɨtu uyahonɨngki lɨmojo sohwo mtɨꞌmokumentiso hiso ne imoꞌnɨmentisofoho. Hungkuno ole, Nje hwomu Ijip nohumentanɨngki lutɨmaꞌmentohefoho. Oso hohosohonta oso hungkunoso ne imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aꞌamu mofehiꞌnyo sɨꞌmofapiso hohntaꞌnɨngo sohwa Heloutɨye hungkuno mehomi songo imoꞌnɨngkisoꞌenoho ngkimo ntohapmno, ose ulɨmentiso somo hwe huhwo sohwa tɨfi minɨngkayoꞌnjo yahonɨngkofi Helout nupaꞌnonto sɨmeho tohino umnɨmentisofoho. Sɨmeho tohino umnɨmentiso soꞌno kako aꞌamu itokusoꞌnjo sohwamo ango Mpetɨlehemꞌnji ango mofone soponeꞌno uhwojahonɨngki hofɨko hwomu hopiꞌnono soswo hufaꞌu muyakolofeꞌnjo sohwamo fongkumeeoꞌmentohofofoho. Hwapɨngoso hwe hntokwaliyo uhwonɨmentohofo sohwa ole ulɨmentohofi, Hntokwaliyo hiso sɨmoꞌmo imoꞌnɨngkahonɨngki soswo hufaꞌu uyakoloꞌmentiso soꞌno ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Helout oso wonyo hiso imentiso sohonta hungkuno hohontajo hwe Jelemaiya sohumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwo mtɨꞌmokumentisoso ne imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Hungkuno hiloso ole, Ango Lama Mpetɨlehem mofone sopo mampaho hoꞌnɨmentisofoho. Mampaho hiloso humotaho weꞌe hoꞌnɨmentisoꞌmaho. Jekoupɨye ape Lesel kakoe imuso hofɨkoe mehomi sohwamneꞌno humotaho lalokwofo. Hofɨkoe sɨmeho wopɨngo apaꞌno mmoꞌnonehoho. Hofɨkoe mehomi nɨhuꞌnahone poyo imoꞌnɨngkahonɨngki humotaho neꞌno lalokwofo. Ose mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hwangku Helout poyo peꞌnɨngkahonɨngki aꞌamu Anɨtu mtaꞌango sohwo Jousep hwaho Ijip nohumentanɨngki iꞌmofaponto Jousepɨmo wojoꞌmo ulɨmento. ");
INSERT INTO apz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nolɨkafohoji kɨko hwomuꞌnji konaꞌwohiꞌnji nomahoji hwaho Isɨlael soponeꞌno asomo fɨwanɨmno. Aꞌamu hopiꞌnono mehomi wofonjosyantɨfi imentohofo sohwa poyo moiꞌwonoho. ");
INSERT INTO apz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ose ulahonɨngki Jousep nolɨkafonto hwomuꞌnji konaꞌwohiꞌnji nomanto hwaho Isɨlael sopo neꞌno asomo womentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Jousepɨꞌmontohwa nowentɨfi upaꞌnɨmentohofoso hwe Akelaus sohwo kanɨngkwohwo Heloutɨye yofe engo nto maꞌmaho. Ose upaꞌnonto iyoho unɨngkahonɨngki olo hwaho lopo mohumamonehono nolonto apaꞌno wojo honɨngkanɨmentisoso Anɨtu Jousepɨmo hungkuno nomꞌne ulahonɨngki kako hwaho Ngkalilineꞌno umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kako hwaho hopo sopo ango Nasalet sopo humamentisofoho. Oso hisoꞌno hungkuno hohontajo nomꞌne hwe sohumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwo mtɨꞌmokumentisoso ne imoꞌnɨmentisofoho. Hungkuno hiso ole, Hwe Nasaletnntaꞌango hweho wolantɨfeho, lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Oso hohosohonta Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwo iꞌmofaponto hwaho Jutiya aꞌamu mohumunyo sopo nohumanto hungkuno lomaꞌmentisofoho mohumunyo sopo. ");
INSERT INTO apz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ole ulɨmento, Sekwoe honɨngkano wonyoso hohujo fikinjaopmno. Sɨmeho fɨwoloꞌmokumno. Anɨtuye sɨkuno nakumo yokumpohnꞌnyo nemokosyohumayoꞌne mofoneponoho. Ose lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Hwe Aisaiya sohumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwo Jounɨmneꞌno olo hungkuno hohonta mtɨꞌmokumentisofoho. Hungkuno hiso ole, Upaꞌnɨmno. Hwaho aꞌamu mohumunyo fiꞌmo hwe fihwoe mampaho engo ole hoꞌnɨmento, Hwe Engo sohumneꞌno honɨngkano itoꞌno fesyohumamno. Kakoe hano emoyoꞌne soꞌno honɨngkano hiso itoꞌno mɨhwatɨmno. ");
INSERT INTO apz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jounɨye nemꞌno manjiꞌmofo hwaho fiꞌnyohwe yahu kamel lohwa soꞌnji mtɨꞌmokumentisofoho. Yahu paho ahulohoso lohoꞌnɨmentisofoho. Kako kusɨmoꞌnji wosopayo tɨme mijoꞌntnnohini nɨmojo hweho. ");
INSERT INTO apz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hohosohonta aꞌamu pone engo Jelusalem mtaꞌango soꞌnji aꞌamu hwaho Jutiya mtaꞌango soꞌnji aꞌamu hopiꞌnonohino Mijo Joutan tɨfo nesoponjo soꞌnji hofɨko Jounɨmo uꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Aꞌamu hiso hofɨkoe wonyo yoloho lɨjwaofahonɨngkofi Joun hofɨkimo Mijo Joutan sohumo kiyomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aꞌamu Falisi piꞌnɨngo sohwanji aꞌamu Satɨyusi sohwanji hofɨko mijo wokiyonemano lontɨfi nopahonɨngkofi Joun nuhwononto ulɨmento, Sekwo homa mehomi soku, tɨhwo selɨmasoto. Anɨtu aꞌamufe wonyo honɨngkano somneꞌno tohino mɨkunɨmposo uyo somneꞌno iꞌwaho fiyɨmno. Ose tɨhwo selahonɨngki nɨꞌmahofo kulo. ");
INSERT INTO apz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sekwoe honɨngkano wonyo somneꞌno hohujo ukinjaofano lɨfijoꞌmanji eꞌwano wopɨngoꞌnohini utɨhwaꞌnyopo fiyɨmno. ");
INSERT INTO apz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Sekwoe sɨmeho moꞌmo ole syafɨsyɨkutoho. Nakwo Apɨlohamɨye imu hnꞌnɨmo oso tohino engo hiso moneꞌmanehoho. Oseso nohnnɨngkutoho. Ngko hungkuno nehopiꞌnohino waselɨmonneꞌno yohono. Olo sojo loso Anɨtu kako Apɨlohamɨye imuhwa wamtɨꞌmokumo losoꞌmanji kako hopoeno wamtɨꞌmokumontonoho. ");
INSERT INTO apz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Anɨtu kako iyomo mɨngo lofoꞌne iwaꞌmɨngo ikafeꞌmo mokosyalohofoho. Iyo ipisayo wopɨngo mintoꞌnyoꞌnjo somo nolofehwosi tohomo wolofaeꞌmtonoho. ");
INSERT INTO apz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aꞌamuso hofɨkoe honɨngkano wonyomneꞌno sɨmeho tango umnɨngkahonɨngki nɨhuꞌnahone hohujo ikinjaofo somo ngko sekumo mijoꞌnohini kiyosemawoꞌnɨngkohe hwoꞌnyoho. I osoꞌno nje yofe weꞌe hwaho lopo weho. Hwe tɨfinjo sohwo kakoe yofe engo yokintahopo nje yofemo nɨyakolofonefoho. Kakoe yofe engo mɨkunɨmposo soꞌno ngko sohwoꞌni kakimo momayo ulohofiyoꞌne hwoꞌnyoho. Hwangku oso hwe huhwo sohwo kako aꞌamu sekumo Anɨtuye Towahuno Wopɨngo sohwoꞌnji tohoꞌnji wokiyosemaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kako hwahomo mno ijiyoꞌneso mokosyohumunyo hweho. Kako hwahomo mno ijɨhwosi neso ijomahwosi pahoso wae yaofɨhwosi wosopayo neso kakoe angomo wohoꞌnahumontonoho. Pahoso toho masɨmpeꞌnyo neꞌno sijɨwoꞌnɨngkiso somo wohoꞌnaeꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Oso hohosohonta Jisas hwaho Ngkalili ulɨkoꞌmanto Mijo Joutan neꞌno nowento Joun mijo wokiyonɨmano lonto Jounɨmo uꞌmaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nuꞌmahonɨngki Joun ulɨmento, Oꞌo, kɨko ngkimo mijo kiyonɨmayoso hoponoho. Ngkiyepono pipineꞌno pohino. ");
INSERT INTO apz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ose ulahonɨngki Jisas ulɨmento, Oꞌo, kɨko mijo kiyonɨmayo soꞌno nekwo ole yasoso Anɨtuye honɨngkano lakisiyo imentohofo somo imokiyoso hoponoho. Oseso Joun kakoe hungkunomo tɨfi inɨngkawento mijo kiyomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mijo kiyomahonɨngki Jisas mijomo kuntoꞌno ulɨkoꞌmanto sɨmentisofoho. Nosahonɨngki ahwomo mtampo lohofahonɨngki uhwonɨmentisoso Anɨtuye Towahuno yɨhufo ntolofiyo hopa imoꞌnonto Jisasɨmo wekehumapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mampaho ahwomo mtaꞌni hoꞌnɨmento, Olo nje Hwomu hweho. Ngko sɨmeho wopɨngo mɨkunɨmposo uyɨwoꞌnɨngkohe hweho. Kakineꞌno yoꞌmayo wopɨngo iwoꞌnɨngkiso soꞌno nje sɨmeho wopɨngo nɨmoꞌnantofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Oso hohosohonta Anɨtuye Towahuno Wopɨngo Jisasɨmo hwaho aꞌamu mohumunyopono ipemotasɨmentisofoho. Osopo Seten Jisasɨmo honɨngkano wonyo imokiyoꞌne yamofo ulohoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jisas kako Mpohumo jomo ulɨmo lonto wopayo manyoꞌnjo nohumentanɨngki mofehiꞌnyo fouti (40) sɨkuno fouti (40) uyakolofahonɨngki Jisas mijoho engo umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jisas mijohoꞌno nohumentanɨngki Seten iꞌmofaponto ulɨmento, Kɨko Anɨtuye Hwomu Nehwosɨꞌmanji olo sojo piꞌnɨngo lomo hungkuno ulohojoꞌno wosopayo umoꞌnono. ");
INSERT INTO apz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ose ulahonɨngki Jisas ulɨmento, Anɨtuye hungkuno ole nalɨwoꞌnɨngki, Aꞌamu wosopayoꞌnohini nɨngkuhwoso sohwo kako itoꞌno mohumanohoho. Oꞌo, aꞌamu Anɨtuye hungkuno hopiꞌnonohinomneꞌno syafɨsyɨwoꞌnɨngkohofoso oso hofɨkoe huyoꞌmango songo humayoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ose ulahonɨngki Seten Jisasɨmo pone wopɨngo poneꞌno ipemotasonto Anɨtuye tajo ango engo antɨfe yokintahopo uhumajonto ");
INSERT INTO apz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ulɨmento, Kɨko Anɨtuye Hwomu hwosɨꞌmanji kɨko olopo ntaꞌni filɨkofamofo. Ose ulɨkwato lohofonto ulɨmento, Anɨtuye hungkuno nalɨwoꞌnɨngki, Anɨtu kakoe aꞌamu ahwomomjo sohwamo kikimneꞌno ulɨhwosoꞌno hofɨko jɨje ahomo kumakukuji jɨje sɨfemo sojo mentofomatnnehino. Tohino momatnnohino. ");
INSERT INTO apz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Seten ose ulahonɨngki Jisas ulɨmento, Nomꞌne ifalifaliyo mtɨꞌmokumentohofoso ole, Kɨko jɨje Hwe Engo Anɨtu sohumo yamofo nulohofohotoho. Kɨko jɨje hunomnohini inɨngkusoꞌmanji ole syafɨsyɨkutoho. Anɨtu wonɨmokosyohumamtonoho. Ose syafɨsyɨkutoho. ");
INSERT INTO apz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ose ulahonɨngki Seten Jisasɨmo hwofɨkiꞌnyo yokintaho engo soponeꞌno utɨmotasonto olo hwaho hopiꞌnonohino aꞌamu soꞌnji yoꞌmayo hwahoponjo yokumpohnꞌnyo soꞌntnno Jisasɨmo utɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ose utɨhwanto ulɨmento, Kɨko ngkineꞌno hwomtame ntohofohoji jɨje sɨmeho ntapisoso yoꞌmayo uhwonalokunoso wokijapmmonnoho. ");
INSERT INTO apz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ose ulahonɨngki Jisas ulɨmento, Kɨko iꞌwaho ntohofo. Kengopono fɨwano. Anɨtuye hungkuno ole nalɨwoꞌnɨngki, Kɨko jɨje Hwe Engo Anɨtu kakineꞌnohini hwomtame ulohofo. Kakineꞌnohini syoho ulohofiyo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ose ulahonɨngki Seten Jisasɨmo ulɨkoꞌmahonɨngki aꞌamu ahwomo mtaꞌangoso nuꞌmantɨfi Jisasɨmo ufoꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aꞌamu fihwa hofɨko Jounɨmo impoꞌangomo intofahumentohofo soꞌno Jisas kako nupaꞌnonto kako hwaho Ngkalilineꞌno umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kako ango Nasalet ulɨkoꞌmanto ango Koponeyam osopo humamentisofoho. Oso ango hopo sopo Mijo Ngkalili mitɨmomɨngoponoho. Aꞌamu Sepɨyulanꞌnji Napɨtalaiꞌnjiye imu sofe hwahoponoho. ");
INSERT INTO apz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hwe Aisaiya sohumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwo hohonta ifalifaliyo mtɨꞌmokumentisoso hohosohonta ne imoꞌnɨmentisofoho. Ole mtɨꞌmokumento, ");
INSERT INTO apz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Mijo Joutan nongkihntaꞌni mijo ayo momɨngopo hwaho Sepɨyulanꞌnji Napɨtalaiꞌnji hiꞌnjoponoho. Aꞌamu temtitofo kengo Anɨtuye hungkuno mupaꞌnɨmmotofo sofeponoho. ");
INSERT INTO apz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hofɨko sɨkwoꞌmjohoꞌmo humafijoso pomponaho engo uhwonɨfitnnefoho. Aꞌamu sɨkwoꞌmjoho soꞌmo weꞌenepi nɨhuꞌnahone wapeꞌnano lɨkuji yontanɨngkuji pomponaho engo wonyoangkafoso uꞌmofapmmontonoho. Ose mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Oso hohosohonta Jisas kakoe hungkuno lomaꞌmentisofoho. Ole ulɨmento, Sekwoe honɨngkano wonyo somtaꞌni fɨwoloꞌmokumno. Anɨtu nemokosyohumayo sohwoe sɨkuno mofoneponoho. ");
INSERT INTO apz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas Mijo Ayo Ngkalili momɨngo sopo nowento hwe hufaꞌu inanɨku syohoꞌnjo sikoꞌnɨkwaꞌimo uhwonɨmentisofoho. Sikoe yofeso Saimounꞌnji Entɨluꞌnjoho. Saimounɨye yofe nomꞌneso Pitafoho. Siko inanɨku hoꞌyo mijomo hoꞌnaofontanɨngki uꞌmaꞌmentisofoho. Inanɨku ifamiyoso sikoe hamniyoho syohofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nuꞌmanto ulɨmento, Siko tɨfi nnɨngkapinyo. Siko inanɨku mawoꞌnɨngkisiye paꞌnɨngoso Anɨtumneꞌno aꞌamu mayoꞌne wolosetɨhwamo. ");
INSERT INTO apz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ose ulahonɨngki sikoe inanɨku hoꞌyo komoꞌno nulɨkoꞌmanji Jisasɨꞌnji umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nowentɨfi Sepetiye hwomu sohwaꞌu Jemɨsɨꞌnji Jounꞌnjimo uhwonɨmentisoso siko hamnɨngkwohwo Sepetiꞌnji yofayokinomo nohumantɨfi inanɨku hoꞌyo itoꞌno esyohumentanɨngki uhwononto joho ulahonɨngki ");
INSERT INTO apz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","siko homnɨngkwohwoꞌnji yofayokinoꞌnji komoꞌno ulɨkoꞌmanji Jisasɨꞌnji umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas hwaho Ngkalili hoꞌmo soꞌmeemo emoyonto hwe moyaꞌmi somo hofɨkoe tajo ango somo Anɨtuye hungkuno soꞌnji Anɨtu wonyoangkafo nemokosyohumayo soꞌntnno lutɨhwamojofoho. Kako nolutɨhwanto aꞌamu mnokino kengo kengoꞌnjo aꞌapaho wonyo umokumojo somo wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jisas olo wonyoangkafo hiloso imentiso soꞌno hwaho Siliya hoꞌmo soꞌmeemo hoꞌnɨmentisofoho. Aꞌamu hiso nupaꞌnontɨfi aꞌamu yoꞌmayo tangoꞌnjo mnokinoꞌnjo somo Jisasɨyepono ipemotapmmentohofofoho. Aꞌamu towahuno wonyoꞌnjo soꞌnji aꞌamu nopɨwasyontɨfi yomo yomo iwoꞌnɨngkohofo soꞌnji aꞌamu sɨfe aho peꞌnnyoꞌnjo soꞌnji hopiꞌnonohino somo ipemotopahonɨngkofi Jisas wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wopɨngo umokahonɨngki aꞌamu piꞌnɨngo engo Jisasɨmo inɨngkamentohofofoho. Aꞌamu Ngkalili, Ntekapolis, Jelusalem, Jutiya, Mijo Joutan nongkihntaꞌango aꞌamu piꞌnɨngoso inɨngkamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aꞌamu piꞌnɨngo engo uhuꞌmokontanɨngkofi Jisas nuhwononto yafe weꞌe soꞌmo nosonto humamentisofoho. Osopo nohumentanɨngki inomokomoyo sohwa nuꞌmahonɨngkofi ");
INSERT INTO apz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jisas kakoe hungkuno ole lutɨhwamento, Anɨtu aꞌamumo mokosyohumayoso olenoho. ");
INSERT INTO apz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Aꞌamu fiso Anɨtuneꞌno huno engo muyoꞌnjoso hofɨko Anɨtumneꞌno huno wopɨngo wotɨpemano lɨfijoꞌmanji hofɨko sɨmeho wopɨngo umoꞌnono. Anɨtu hofɨkimo umokosyohumayo hweho. ");
INSERT INTO apz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Aꞌamu sɨmeho tangoꞌnjo humalofoso sɨmeho wopɨngo umoꞌnono Anɨtu kako oso aꞌamu somo sɨmeho wopɨngo umokumontonoho. ");
INSERT INTO apz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aꞌamu fiso hofɨkoe yofemo monje yahinontɨfi Anɨtuye yofe hoꞌnomalokwofoso sɨmeho wopɨngo umoꞌnono. Yoꞌmayo wopɨngo Anɨtu wosejapmmo ulɨmentisoso hofɨkoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aꞌamu wopayo mijoho peꞌnyoso wopayoꞌno hi umoꞌnyo hopaso aꞌamu Anɨtuye honɨngkano wopɨngomneꞌno hi umoꞌnosoꞌmanji oso hisomo Anɨtu kakoe hungkuno hisofe sɨmehomo wopayo sɨmeho hopaso uhnnɨmontonoho. Oseso hofɨkoe sɨmeho wopɨngo umoꞌnono. ");
INSERT INTO apz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aꞌamu fiso nomꞌne aꞌamu hofɨkimo wonyo ulohofɨwoꞌnɨngkohofo somneꞌno hitoho ulofahonɨngki wopɨngoꞌnohini ulohofɨwoꞌnɨngkohofoso sɨmeho wopɨngo umoꞌnono. Osoꞌno Anɨtu hofɨkimo wopɨngo ulohoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aꞌamu sɨfe aho tɨmo sɨmeho haloho angaꞌnohinoꞌnjoso hofɨko sɨmeho wopɨngo umoꞌnono. Oso aꞌamu hiso Anɨtumo uhwonantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aꞌamu sɨmano hintotohinoꞌnjo somo nɨhoholofɨwoꞌnɨngkohofoso sɨmeho pompenjiyo umoꞌnoneꞌentɨfi iwoꞌnɨngkohofoso sɨmeho wopɨngo umoꞌnono. Anɨtu ulɨmontonoho, Nje mehomi kuyoho. ");
INSERT INTO apz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aꞌamu Anɨtuye hungkunomo inɨngkayoꞌno syoho wopɨngo yontanɨngki aꞌamu nomꞌneso oso aꞌamu somo sɨtofo ujo soꞌnji wonyo ulohofo soꞌno kako sɨmeho wopɨngo umoꞌnono. Anɨtu umokosyohumamontonoho. ");
INSERT INTO apz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Sekwo aꞌamu soku ngkimo tɨfi nnɨngkawowoꞌnɨngkohofo soꞌno aꞌamu nomꞌneso sekumo wonyo hungkunoꞌnji hwasyo hungkunoꞌnji sejo soꞌnji sefotofo selohofɨkujoꞌno sekwo sɨmeho wopɨngo wasemoꞌnono. ");
INSERT INTO apz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sekwo sɨmeho wopɨngo semoꞌnɨngkuhwosoꞌno sɨmonyo fiyɨmno. Sekwoe yahino wopɨngo olo hwaho lopo iwoꞌnɨngkohofo loꞌnji ngkimo tɨfi nnɨngkape loꞌnji mpe iyo paꞌnyoso hoꞌyango ahwomomo weho. Oso sefotofɨwoꞌnɨngkohofo hopaso hofɨko hohonta aꞌamumo Anɨtu hungkuno uyahonɨngki ulɨmotofo somo ufotoꞌmotofofoho. Oso aꞌamu hiso hofɨkoe yahino wopɨngo soꞌno mpe iyo hopaso ahwomomo maꞌmentohofo hopaso sekwo womantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Sekwo olo hwaho loponjo sa paꞌnyo kuyoho. I osoꞌno sa fosyo mijoꞌnohino imoꞌnɨngkuhwosi kakoe yokumpohnꞌnyo nonto wonyo imoꞌnososo apaꞌno sa hiso wopɨngo imoꞌnyoso pipi uyantanto. Awonoho. Nɨhuꞌnahone wonyo umoꞌnɨmotonoho. Aꞌamu sa hiso mopijoso me-e miyonehoho. ");
INSERT INTO apz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Sekwo hwahoponjo pomponaho paꞌnyo kuyoho. Antɨme engo hwofɨkiꞌnyo soponjo molinyoso oso hiyaeꞌmꞌmaho. Oꞌo, utɨhwaꞌnyoponoho. ");
INSERT INTO apz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aꞌamu sikiloho mongkujontɨfeso ahwonteꞌmo kipitofahinyoꞌmaho. Oꞌo, hofɨko ijempohopo hoꞌnahinyofoho. Oso aꞌamu ango somo humafijo somo pomponaho ulohofono. ");
INSERT INTO apz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Olo hiloso sekwo hmmoꞌnɨmno. Sekwoe pomponahoso aꞌamufe tɨmopo wolasyono. Aꞌamu hofɨko sekwoe honɨngkano wopɨngomo uhwonɨfijoso hofɨko Mpohwo Anɨtu ahwomomo humaso sohwoe yofe wohoꞌnomantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Sekwo ngkineꞌno huno ole seyɨhwoloho. Ngko Mousesɨye honɨngkano hungkunoꞌnji aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo sohwafe hungkuno ntnneꞌno wae yaoꞌmneꞌnji pmmentohe hwoꞌnyoho. Oꞌo ngkineꞌno huno ose seyɨhwoloho. Ngko hungkuno hiloso wae yaꞌmneꞌenji pmmentohe hwonɨꞌmaho. Oꞌo, ngko hungkuno hiloso ne utɨhwayoꞌne pmmentohefoho. ");
INSERT INTO apz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Hungkuno nehopi waselɨmonneꞌno yohono. Aꞌamu fiso oso honɨngkano hungkuno ifalifaliyo weꞌe somo wae meeofonehoho. Oꞌo, olo hwaho loꞌnji ahwomo loꞌnji moiꞌwo imoꞌnoso sohonta olo hungkuno hopiꞌnonohino hiloso nowentanɨngkuhwosi hungkuno hopiꞌnonohino ne imoꞌnonefoho. ");
INSERT INTO apz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Aꞌamu fihwo Mousesɨye honɨngkano hungkunoꞌnji aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo sohwafe hungkunoꞌnji angaꞌnohinoso mtɨhupesoso aꞌamu nomꞌne somo oso honɨngkano mtɨhupe soꞌno lutɨhwasoꞌmanji oso aꞌamuso Anɨtuye angomo sɨꞌmofoso sohonta Anɨtu ulonefoho. Jɨje yofe monje innyo hwosoho. Aꞌamu fiso Anɨtuye hungkuno hopiꞌnonohino loso inɨngkawesoso aꞌamu nomꞌne somo oso honɨngkano wopɨngomo inɨngkayoꞌne lutɨhwasoꞌmanji oso aꞌamuso Anɨtuye angomo sɨꞌmofoso sohonta Anɨtu ulonefoho. Kɨko yofe engoꞌnjo hwosoho. Ose ulonefoho. ");
INSERT INTO apz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sekwo upaꞌnɨmno. Sekwoe honɨngkano wopɨngoso aꞌamu Falisi sohwanji aꞌamu Mousesɨye hungkuno lutɨhwayo syohoꞌnjo sohwanjiye honɨngkano wopɨngomo muyakolofeꞌmanji sekwo Anɨtuye angopo kako yokumpohnꞌnyo semokosyohumayoꞌne muꞌmapitnnehofo. Oꞌo, mango mtaꞌnnohini lɨwoꞌnɨngkohofo soku honɨngkano wopɨngo somo humayoso hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mousesɨye honɨngkano hungkuno ole nto upaꞌnɨwoꞌnɨngkohofo, Aꞌamumo fonjasiyoꞌeno. Aꞌamu nomꞌnehumo fonjasyoso sohwo kakoe hungkuno ikwolofoneso woꞌnnyo hweho. ");
INSERT INTO apz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","I oso hisoꞌno nje hungkuno waselɨmonneꞌno yohono. Aꞌamu fihwo kakoe aꞌamumneꞌno sɨmeho tohino umnyoꞌeno. Aꞌamu sɨmeho tohino umnoso sohwo kako tɨfi noꞌmo Anɨtuꞌnji hungkuno ikwolofoneso woꞌnnyo hweho. Aꞌamu fihwo kakoe aꞌamu sohumneꞌno sɨtofo ujoꞌeno. Sɨtofo uloso sohwo kako Anɨtuꞌnji hungkuno ikwolofoneso woꞌnnyo hweho. Aꞌamu fihwo nomꞌnehumo iloꞌnnyo hwosoho ujoꞌeno. Oꞌo, oso aꞌamu huhwo sohwo kako tɨkanomo wene hweho. ");
INSERT INTO apz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kɨko tajo ango somo noswohoji jɨje wonyo wae yaofoꞌne Anɨtumo jomo ulɨmo lohoji kɨko nomꞌne sohumneꞌno kikineꞌno sɨmano hintotohino umnoso soꞌno syafɨsyohoji ");
INSERT INTO apz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","u, kɨko tajo ango somo ulɨkoꞌmahoji oso aꞌamu huhwo sohwoepono komoꞌno uhuji hungkuno itoꞌno mɨhwajo. Hungkuno itoꞌno mɨhwajohosɨsi sɨmeho pompengo inɨngkahosɨsi tajo ango somo asomo fusyo. Osopo Anɨtumo jɨje wonyo wae yaofoꞌne jomo uso. ");
INSERT INTO apz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Aꞌamu fihwo kikimneꞌno sɨmeho tohino umnoso soꞌno kɨko komoꞌno sɨmeho wopɨngo hmninyo. Aꞌamu hungkunomo itoꞌno efisopɨhwajiyo sopo nokumotawenoho. Kako aꞌamu hungkunomo itoꞌno efisopɨhwajiyoꞌnjofepono kumotawesoꞌmanji osopo aꞌamu hwapɨfe tɨfoꞌnjo sohwa nokitɨmafɨkuji impoꞌangomo intofakohufitnnoho. ");
INSERT INTO apz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ngko nehopi waselɨmonneꞌno yohono. Kɨko impoꞌangoso kuntoꞌno ulɨkoꞌmaꞌmne hwosɨꞌmaho. Oꞌo, sɨmoꞌmo kɨko jɨje yahino somneꞌno yoꞌmayo hamniyoho hopiꞌnonohinoso wohoꞌnahumonnoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Hungkuno nomꞌne nto upaꞌnɨwoꞌnɨngkohofoso ole, aꞌmohufo iyoꞌeno. ");
INSERT INTO apz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","I oso hisoꞌno nje hungkuno waselɨmonneꞌno yohono. Hwe fihwo nomꞌne aꞌmu fisimo uhwononto hufo womaꞌmo lonto aꞌmu simneꞌno kakoe sɨmeho fefoyo uyahonɨngki oso hwe huhwo sohwo aꞌmu siꞌnji kakoe hunomo hufo nto iso hweho. ");
INSERT INTO apz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tɨmo aho angahohntaꞌangoso honɨngkano wonyo kumokososo yoꞌmayo somo tɨmo uhwonɨngkohoji huno wonyo syafɨhujoꞌmanji oso hiso nɨhuꞌno yohotoho. Kɨko wonyo isoꞌnoꞌmanji tɨmo angaꞌno fitɨhwotofaofo. Tɨmo wopɨngo hufaꞌuꞌnjo sohwosi tɨkanomo uhnnoho. Oꞌo tɨmo angaꞌnohinoꞌnji honɨngkano wopɨngomo fiso. ");
INSERT INTO apz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jɨje aho angahohntaꞌni honɨngkano wonyo kumokososo aho hiso hntofamo lohofohoji fohoꞌnaofo. Aho wopɨngo hufaꞌu hiꞌnjo hwosi tɨkanomo uhnnoho. Oꞌo, aho angaꞌnohinoꞌnji honɨngkano wopɨngomo fiso. ");
INSERT INTO apz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Hungkuno nomꞌne nupaꞌnɨwoꞌnɨngkohofoso ole, Hwe fihwo kako kakoe ape wohoꞌnahumo lɨhwosi ape hoꞌnasiyoꞌneso iyoswo mtɨꞌmokuhwosi uyono. ");
INSERT INTO apz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","I oso hisoꞌno nje hungkuno waselɨmonneꞌno yohono. Hwe fihwo kakoe ape honɨngkano wonyo mmofeꞌnjo simo hoꞌnasyoso sohwo kakoe apefe honɨngkano wonyo umokumontonoho. Hwapɨngoso ape hisi nomꞌne hwe sohumo umaꞌnososo Anɨtu kako tɨmo uhwonyoso hwe hufaꞌuꞌnjiyoho. I nomꞌnihwo kako ape nomꞌnihwo hoꞌnasyoso somo maso sohwo kako huhwo ape itoꞌno mayo honɨngkano somo mtɨhuposo soꞌno kako huhwo honɨngkano wonyoꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Hungkuno nomꞌne upaꞌnɨwoꞌnɨngkohofoso ole, Hwasyo hungkuno nomꞌneꞌno yokintahopo ne-eso nolɨkutoho. Hwe fihwo ole lososo, Ngko nehopi hufaꞌu sɨhune hwamneꞌno lohono. Ngko yoꞌmayo yoꞌmayo uyɨmo. Ose loso sohwo kako itoꞌno uyono. Hwe Engo sohwo olo hisoꞌno nuhwonɨngkuhwosi itoꞌnohini wosyafɨhuꞌmontonoho. Ose nto upaꞌnɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","I oso hisoꞌno nje hungkuno waselɨmonneꞌno yohono. Sekwoe hungkuno nehopi imoꞌnyoꞌne soꞌno hungkuno piꞌnɨngo nolɨkutoho. Oꞌo, hungkuno neꞌnjoꞌnohino filɨmno. Sekwo aꞌamu yokintahoponjo sohwamneꞌno jɨje hungkuno nehopi imoꞌnyoꞌne nulɨkutoho. Nɨhuꞌno nɨjwoꞌeno. Oꞌo, yoꞌmayo ahwomomjo sohwamneꞌno nolɨkutoho. Ahwomoso Anɨtuye epohumayofoho. Osopo yoꞌmayoso mokosyohumawoꞌnɨngkisoponoho. ");
INSERT INTO apz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Sekwo yoꞌmayo hwahoponjo somneꞌno sekwoe hungkuno nehopi imoꞌnyoꞌne nolɨkutoho. Oꞌo, hwahoso Anɨtuye epohumayo sɨfe hoꞌnasiyoꞌnefoho. Olopo yoꞌmayoso mokosyohumawoꞌnɨngkisoponoho. Sekwo Jelusalemneꞌno sekwoe hungkuno nehopi imoꞌnyoꞌne nolɨkutoho. Oꞌo, Jelusalem sopo Anɨtuye angoponoho. ");
INSERT INTO apz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Sekwo sekwoe mnokinomneꞌno sekwoe hungkuno nehopi imoꞌnyoꞌne soꞌno nolɨkutoho. Oꞌo, sekwoe mijiyo halojo wofokafono. Sɨkwoꞌmno wofokafono, lisoso halojo wofokaꞌmontolaho. Sɨkwoꞌmno wofokaꞌmontolaho. Awonoho. ");
INSERT INTO apz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Osoꞌno sekwo hungkuno neꞌnjoꞌnohino ulɨmno. Eno, esoꞌnji Awonoho, esoꞌnji osoꞌnohinoho. Hungkuno nomꞌneso hwe wonyo Seten mtaꞌango linyofoho. ");
INSERT INTO apz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Hungkuno nomꞌne nto upaꞌnɨwoꞌnɨngkohofoso ole, Hwe fihwo jɨje tɨmomo wonyo kumokososo kɨko kakoe tɨmo wonyo umojo. Hwe fihwo jɨje mango fonjokujakumofososo kɨko kakoe mangomo fonjokulɨpijaofo. ");
INSERT INTO apz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","I oso hisoꞌno nje hungkuno waselɨmonneꞌno yohono. Hwe fihwo kikimo wonyo kilohofososo kɨko kakimo ilojɨmofeꞌeno. Oꞌo, awonoho. Hwe fihwo kako jɨje manjijohopo kuposososo manjijoho fehohnjo utɨhwaho. Osopo wakuposono. ");
INSERT INTO apz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hwe fihwo kikineꞌno hungkuno hiꞌnjo sohwo jɨje manjiꞌmofo womaꞌmo lososo osohumo jɨje manjiꞌmofoꞌnji sɨfe manjiꞌmofo ntnneꞌno uyo. ");
INSERT INTO apz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Hwe yofe engoꞌnjo fihwo kako sekwoꞌnji hano hoꞌyangoꞌnji tɨfo lopo wemoyano selososo sekwo hano sawemo sopono fisɨmno. ");
INSERT INTO apz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hwe fihwo ole seloso, Sekwo yoꞌmayoso ntapmno. Ose selososo sekwoe yoꞌmayoso uyɨmno. Hwe fihwo ole seloso, Sekwoe hoꞌyango yoꞌmayoso nokiso ntapmno. Ose selososo sekwo hohujo ikinjɨmofɨkutoho. ");
INSERT INTO apz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Hungkuno nomꞌne nto upaꞌnɨwoꞌnɨngkohofoso ole, Aꞌamu sekwoꞌnjo mofone sopo humalofo somo sɨmeho umoꞌnyoꞌne uyɨmno. I osoꞌno sekwo mango hwamo sɨmeho umoꞌnyoꞌne ukutoho. ");
INSERT INTO apz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","I oso hisoꞌno nje hungkuno waselɨmonneꞌno yohono. Sekwoe mango hwamo sɨmeho umoꞌnyoꞌne ufijoso aꞌamu wonyo selohofɨwoꞌnɨngkohofo somneꞌno Mpohumo jomo ulɨmno. ");
INSERT INTO apz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ose ifijo soꞌno sekwoe Mpohwo ahwomomo humaso sohwoe yahinomo unɨngkowantɨfeho. Anɨtu kakoe mofehiꞌnyoso aꞌamu wopɨngoꞌnji wonyoꞌnji humalofo somo ulono lonto uyɨwoꞌnɨngkiso hweho. Aꞌamu honɨngkano wopɨngoꞌnjo honɨngkano itoꞌno minɨngkayoꞌnjo somo ifoyo wosapijono lahonɨngki syuwoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sekwo aꞌamu sɨmeho umoꞌnyoꞌne sejapɨwoꞌnɨngkohofo osomneꞌnohini sɨmeho umoꞌnyoꞌne uyɨfijoso Anɨtu kako wopɨngo pehoꞌno wosejapmmontolo. Awonoho. Aꞌamu honɨngkano wonyoꞌnjoso ose iwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Sekwo sekwoe aꞌamuꞌnohino somo wopɨngo uwoꞌnɨngkohofo soꞌno sekwoe honɨngkano nomꞌne somo uhwofilofoso pipilo. Awonoho. Aꞌamumo Mpohwo Anɨtumo minɨngkayoꞌnjo hi ose iwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","I osoꞌno sekwoe Mpohwo Anɨtu ahwomomo humaso sohwo paꞌnyo hmmoꞌnɨmno. Sekwo aꞌamu wopɨngoꞌnji wonyoꞌnjo somo wopɨngo ulohofɨkujoꞌno Anɨtu kako humaso hopa fehumamno. ");
INSERT INTO apz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Sekwo olo yahino losoꞌno iꞌwaho fiyɨmno. Sekwo yahino wopɨngo wopɨngoso aꞌamu wonahonɨfe lɨkuji ikutoho. Oꞌo, ose ifijoso sekwoe Mpohwo Anɨtu ahwomomo humaso sohwo sekumo oso hisoꞌno wopɨngo mosejapeꞌnjo uyɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Sekwo aꞌamu umofonyo iwoꞌnɨngkohofo somo yoꞌmayo uyano lɨfijoꞌmanji eꞌwano, hiyaso uyɨmno. Aꞌamu mangoꞌnohinoso wonahonɨfe lontɨfi Anɨtuye tajo angoꞌnjo sopo honɨngkano utɨhwaꞌnyopo iwoꞌnɨngkohofofoho. Hofɨko hwe moyaꞌmi nakwoe yofe wohoꞌnonemapɨfe lontɨfi iwoꞌnɨngkohofofoho. Upaꞌnɨmno. Oso aꞌamu hiso nomꞌne wopɨngoso Anɨtu mtaꞌango momasofoho. Oꞌo, aꞌamu hwahoponjoso hofɨkoe yofe hoꞌnomaꞌnyoso oso mpe hopaso nto mahofo. Hofɨkoe nomꞌne mpe iyo hopaso ahwomomo mauyoho. ");
INSERT INTO apz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sekwo aꞌamu nomꞌne somo ufoꞌmano lɨfijoꞌmanji eꞌwano noho ufoꞌmapmno. I osoꞌno aꞌamu nomꞌneso sekwoe yofe nohoꞌnosemapitnnoho. Masehonɨfitnnehofo. ");
INSERT INTO apz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Oꞌo, hiyaso fiyɨmno. Yoꞌmayo wopɨngo hiyaso iwoꞌnɨngkohofo soꞌno Mpohwo Anɨtu kako nosehonɨngkuhwosi wopɨngo wosejapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sekwo Mpohumo jomo ulano lɨkuji sekwo aꞌamu mangoꞌnohinosofe yahinomo inɨngkakutoho. Oꞌo, hofɨko aꞌamu wonepaꞌnɨfe lontɨfi Anɨtuye tajo angoꞌnjo honɨngkano momɨngo engo sopo lohofontɨfi ulɨwoꞌnɨngkohofofoho. Upaꞌnɨmno. Oso hisoꞌno aꞌamuso hofɨkoe yofe hoꞌnomayoso mpe paꞌnyoso nto mahofo. ");
INSERT INTO apz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","I oseso kɨko sohwosi Anɨtumo jomo ulɨmo lohoji kɨkoꞌnohini jɨje angomo swohoji ango hokuꞌyoso pɨjwasyohoji jɨje Mpohumo jomo uso. Kako oso ango hiyaso soꞌmo kɨkoꞌnji humaho. Jɨje Mpohwo osopo kohonɨngkuhwosi yoꞌmayoso wokijapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kɨko Mpohumo jomo ulɨmo lohoji osohonta hungkuno piꞌnɨngo engo lɨwoꞌnɨngkohofoso paꞌnyo ujoꞌeno. Aꞌamu Anɨtu ne sohuneꞌno huno muyoꞌnjoso hofɨkoe hwasyo anɨtu sohwamo hungkuno piꞌnɨngo engo ulɨwoꞌnɨngkohofofoho. Hofɨko huno ole, Nakwo hungkuno piꞌnɨngo engo ulɨhwasi nakwoe anɨtu sohwo kako nonepaꞌnɨngkuhwosi wonejapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Oso paꞌnyo sekwo ikutoho. Oꞌo, yoꞌmayo umofonyo yohojo soꞌno Mpohwo kako huno nto uyohoho. ");
INSERT INTO apz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sekwo Mpohumo ole ulɨmno. Nakwoe Mpohwo sohwosi, kɨko ahwomomo humahnno. Nakwo jɨje yofe wopɨngoꞌnohinoso neꞌno nowentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Oso sɨkuno kɨko yoꞌmayo hopiꞌnono yokumpohnꞌnyo nemokosyohumayoso komoꞌno umoꞌnono. Jɨje hungkunomo aꞌamu ahwomomjo soꞌnji yoꞌmayo soꞌnji kinɨngkawowoꞌnɨngkohofo hopaso nakwo aꞌamu hwahoponjo hnꞌnwi ose wokinɨngkopano. ");
INSERT INTO apz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Olo sɨkuno lomneꞌno nakwoe wosopayo fonejape. ");
INSERT INTO apz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nomꞌne aꞌamu nakumo wonyo nalohofɨwoꞌnɨngkohofo sofe wonyo wae yaoꞌmalohwone hopaso nakwoe wonyoso wae fenamofo. ");
INSERT INTO apz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kɨko nakumo yamofo nalohofo somo nonehumajohotoho. Oꞌo, Hwe wonyo sohwoe yoꞌmayoso neꞌmahwosoꞌno yoꞌmayo wonyo somo uyakolofoꞌne fonejape. Enemokosyohumayo hwosoho. Yokumpohnꞌnyo ne hwapɨngo hwosoho. Pomponaho ne somo humahnno hwosoho. Neꞌnohino nowentɨhwonefoho. Hungkuno nehopeho. ");
INSERT INTO apz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Upaꞌnɨmno. Sekwo aꞌamu wonyo selohofo sofe wonyoso nɨhuꞌnahone hohujo hohntaꞌne mehoꞌnafɨkujoꞌno sekwoe Mpohwo ahwomomo humaso sohwo kako sekwoe wonyo hiso wae weesemoꞌmtonoho. ");
INSERT INTO apz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","I osoꞌno sekwo aꞌamu wonyo selohofosofe wonyoso hohujo hohntaꞌni momehoꞌnasiyoꞌmanji sekwoe Mpohwo Anɨtu sohwo kako sekwoe wonyo wae meesemofonehoho. ");
INSERT INTO apz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sekwo Mpohumo jomo ulano lɨkuji Mpohuneꞌno huno angaꞌnohino soꞌno wopayo manyoꞌnjo nohumentanɨngkuji sekwo aꞌamu mangoꞌnohinoso sɨmano wonyo ikinɨwoꞌnɨngkohofo hopa humafɨkutoho. Oꞌo, hofɨkoe sɨmano wonyo ikinyoso aꞌamu wonahonɨfentɨfi aꞌamu wopɨngofoho wonalɨfe nolontɨfi iwoꞌnɨngkohofofoho. Mpohuneꞌmaho. Oꞌo, hofɨkoe yofeꞌnohini hoꞌnomayoꞌne iwoꞌnɨngkohofofoho. Osoꞌno hofɨkoe yofe nto hoꞌnomaꞌmentohofo soꞌno hofɨkoe mpe paꞌnyofoho. Mpe paꞌnyo nomꞌneso ahwomomo mauyoho. ");
INSERT INTO apz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Oꞌo, sekwo Mpohuneꞌno wopayo manyoꞌnjo humafɨkuji sekwoe mijiyomo hwone mijo ehalohoꞌnɨngkuji sekwoe sɨmanomo mijo fiyatɨkuꞌnɨmno. ");
INSERT INTO apz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ose ikuji aꞌamu nomꞌneso kɨko manyoꞌnjo humentanɨngkijo soꞌno hofɨko huno muyonehoho. Oꞌo, kɨko yoꞌmayo hiyasoꞌmo iwoꞌnɨngkinoso jɨje Mpohwo aꞌamu muhwonyoꞌnjo sohwo kakoꞌnohini kohonɨngkuhwosi mpe hopa wokijapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Olo hwaho lopo sekwoe yoꞌmayo yoꞌmayo hoꞌyango wopɨngoso nohuꞌmeesyɨkutoho. Oꞌo, olo hwaho loponjo nangkumeho syuhwosi hwaho ifulohofɨhwosi hoꞌyangoso wonyo umoꞌnɨmontonoho. Oseso aꞌamu hufoꞌnohino yɨwoꞌnɨngkohofoso tojo nowonampekuji hufo uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Osoꞌno sekwoe hoꞌyango ahwomomo fohuꞌmeehumno. Oso hopo sopo nangkumeho maswonehoho. Hwaho mɨfulohofonehoho. Aꞌamu hufo mifitnnehofo. ");
INSERT INTO apz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ango jɨje hoꞌyango yoꞌmayo wopɨngo wojo sopo jɨje sɨmeho hi oso hopo weho. ");
INSERT INTO apz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Sekwoe tɨmoso sekwoe huyoꞌmangofe pomponaho paꞌnyofoho. Tɨmo angaꞌnohinoꞌmanji sekwo pomponahopo humalofo. ");
INSERT INTO apz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tɨmo piꞌnɨngoꞌmanji sɨkwoꞌmjohoꞌmo humalofo. Sekwo pompohahopo humalofo soku yahino piꞌnɨngo piꞌnɨngo mafɨkuji apaꞌno sɨkwoꞌmjohoꞌmo fosyohumafɨkutoho. Ose ifijoꞌmanji jɨje hunomo nɨhuꞌno sɨkwoꞌmjoho engo mjaofoho. ");
INSERT INTO apz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Hwe fihwo kako hwe engo hufaꞌu sohwaꞌumo syoho ulohofiyoso hopoꞌmaho. Oꞌo, hwe engo hufaꞌu sohwaꞌumo syoho ulohofiyo soꞌmanji syoho ulohofiyo sohwo kako hwe engo fihumo sɨmeho wopɨngo uyɨhwosi nomꞌnihuneꞌno sɨmeho wonyo uyɨmontonoho. U, angaꞌnohino sohwoe syoho somneꞌno hi umoꞌnɨngkuhwosoꞌno nomꞌnihumneꞌno ngkilaho unɨmontonoho. Kɨko Anɨtuye syoho soꞌnji yoꞌmayo hwahoponjo yahino soꞌnji oso hufaꞌuyo sohwaꞌumo kemokosyohumahojoso kɨko syoho itoꞌno mihnnehino. ");
INSERT INTO apz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Osoꞌno ngko ole selalokweno. Sekwo sekwoe fosyohumayo soꞌno huno piꞌnɨngo engo syafɨsyɨkuji ole nolɨkutoho. Nakwo peho wosopayo wonantanto. Nakwo mijo peho nanehwono. Sekwo sekwoe aꞌapahomneꞌno huno piꞌnɨngo engo syafɨsyɨkuji ole nolɨkutoho. Ngko nje aꞌapahomo peho wekojisyahinɨmonnto. Nakwo songo humalohwoneso wopayoꞌnohini nyoꞌnetaho. Nakwo aꞌapaho hiꞌnjoꞌnwi nemꞌno manjiꞌmofo iyoꞌneꞌnohinotaho. Awonoho. ");
INSERT INTO apz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sekwo yɨhufo somo uhwonɨmno. Hofɨko wopuyo hulɨwoꞌnɨngkohofoꞌmaho. Hofɨko wopayo ango somo wopayo momehuꞌmeesyɨwoꞌnɨngkoho yohofofoho. Oꞌo, senɨngkwohwo Anɨtu ahwomomo humaso sohwo kako hofɨkimo wosopayo yoꞌmayoso uyɨwoꞌnɨngkohoho. Sekwo Mpohwo Anɨtu yɨhufo sikinjo somneꞌno wonyoho fiyo mokosyohumaho. I aꞌamu sokumo Mpohwo wopɨngo wosemokosyohumamtolaho. Ou, ikono. ");
INSERT INTO apz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hwe fihwo sekumtaꞌni kako huno piꞌnɨngo piꞌnɨngo syafɨsyɨhwosi nje soswo sawemo umokinɨmneꞌno yohoho lososo ne umoꞌnɨmontolo. Awonoho. ");
INSERT INTO apz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Oseso sekwo hwapɨfe nemꞌno manjiꞌmofo yoꞌmayo somneꞌno huno piꞌnɨngo engo pehoꞌne syafɨsyɨwoꞌnɨngkohofo. Sekwo wokoso fofo soꞌno huno fɨsyafɨhupmno. Hofɨko yoꞌmayo syoho anefoho. Hofɨko ne yoꞌmayoso mojiyofɨwoꞌnɨngkiyohofo. ");
INSERT INTO apz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","I osoꞌno ole woselɨmonneꞌno yohono. Hohonta hwe engo Soulomoun hamniyoho hwapɨngoꞌnjo sohwo kako kakoe hwapɨfe wonyoangkofo yoꞌmayo wokoso naꞌnohino soꞌnji inonteso kako olo wokoso fofo weꞌe somo muyakolofonehoho. ");
INSERT INTO apz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ou, oso wokoso fofo sɨkuno fihumo syohopo lohofososo moꞌnɨngkanta aꞌamu nolofekuji tohomo wolofefantɨfeho. I osoꞌno oso wokoso fofo Anɨtu wonyoangkafo mtɨꞌmokuwoꞌnɨngkiso somo uhwonontaneso wopɨngofoho lɨwoꞌnɨngkuhwono. Oseso sekwo soku wokoso fofomo yakoloꞌnnyo hokumo Anɨtu kako hofiyo wosemokosyohumamontonoho. Sekwo Anɨtumo sɨmeho hiꞌntnnono weꞌeꞌnohinoso pehoꞌno uyalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Osoꞌno sekwo huno piꞌnɨngo engo syafɨsyɨkutoho. Sekwo ole lɨkutoho, Nakwo wopayo peho wonantanto. Mijo peho nanehwono. Hwapɨfe peho yanehwono. Ose lɨkutoho. ");
INSERT INTO apz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Awonoho. Aꞌamu kengo hopiꞌnohinoso hofɨko yoꞌmayo yoꞌmayo mayoꞌne huno piꞌnɨngo piꞌnɨngo syafɨsyɨwoꞌnɨngkohofo. I osoꞌno sekwoe Mpohwo Anɨtu ahwomomo humaso sohwo kako yoꞌmayo soꞌno sekwo umofonyo yahonɨngkohofoso kako huno nto uyohoho. Kako wopɨngo wosemokosyohumamontonoho. ");
INSERT INTO apz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","I sɨmoꞌmo Anɨtu semokosyohumayo soꞌnji kakoe honɨngkano wopɨngoꞌntnno huno fɨsyafɨsyɨwoꞌnɨngkuno. Osoꞌno syafɨsyɨwoꞌnɨngkuji Anɨtu kako yoꞌmayo yoꞌmayo umofonyo ifijoso wosejapmmontono. ");
INSERT INTO apz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Osoꞌno yoꞌmayo moꞌnɨngkajo somneꞌno huno syafɨsiyeꞌeno. Sɨkuno huhwo huhwi yoꞌmayo tango iꞌmofapɨwoꞌnɨngkisofoho. Moꞌnɨngkajo sɨkuno sohwoe tangoso moꞌnɨngkaꞌnefoho. Olo sɨkuno lomo iꞌmofaposo tangoso olo sɨkuno lomnefoho. ");
INSERT INTO apz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Sekwo nomꞌne aꞌamufe hunomo yano ilofɨkuji wonyofoho nulɨkutoho. Ose ifijoꞌmanji Anɨtu huhwo sekwoe huno somneꞌno wonyofoho maselonehoho. ");
INSERT INTO apz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sekwo nomꞌne somo yoꞌmayo ulohofɨwoꞌnɨngkohofo soꞌno oso paꞌnyoso Anɨtu waselohoꞌmontonoho. Sekwo yoꞌmayo aꞌamumneꞌno yano uyɨwoꞌnɨngkohofo hopaso Anɨtu kakoe yoꞌmayoso aku wosejapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kɨko jɨje hnnɨngkwaꞌwehwoe tɨmomjo hintalinyo wojo somo pehoꞌno uhwonalokuno. I jɨje tɨmomjo iyo feejo engoso hofokiꞌnawojo soꞌno kɨko huno makiyotaho. Kɨko jɨje tɨmomjo iyo feejo engoso hofokiꞌnakuwojoso momehoꞌnamoꞌnyo sohwosi ");
INSERT INTO apz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","kɨko jɨje hnnɨngkwaꞌwehumo ole poneꞌno ulalokuno. Ngko jɨje tɨmomo hintalinyo wojo weꞌeso wae weekumoꞌmneꞌno yohono. Ose ulohoji pipi uyɨmonto. ");
INSERT INTO apz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kɨko mangoꞌnohino hwosoho. Sɨmoꞌmo kɨko jɨje tɨmomjo iyo feejo engoso hofokiꞌnakuwojoso wae kakiꞌno feemoꞌnyo. Ose yohoji kɨko tɨmo itoꞌno uhwonɨngkohoji hwangku jɨje hnnɨngkwaꞌwehwoe tɨmomjo hintalinyo weꞌeso wae fiyo. ");
INSERT INTO apz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Aꞌamu honɨngkano wonyoꞌnjo sɨwojo paꞌnyo somo Anɨtuye hungkuno wopɨngoso nolutɨhwafɨkutoho. Lutɨhwafijoꞌmanji hofɨko ikinjaofɨkuji woselantɨfeho. Sekwo sekwoe nɨjwo yoꞌmayo wopɨngoso hwahomo hoꞌnahufijoꞌmanji yahu hwotoho hulɨmo lɨfɨfitnnoho. Oso paꞌnyo aꞌamu Anɨtuye hungkunomo hwotoho fewoꞌnɨngkohofo somo Anɨtuye hungkuno nulɨkutoho. ");
INSERT INTO apz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Sekwo Mpohumo jomo neꞌno ulɨfijoso kako yoꞌmayo wosejapmmontonoho. Sekwo yoꞌmayo soꞌno hafɨhafe tɨpentanɨngkuji sekwo oso hiso uhwonantɨfeho. Sekwo hokuꞌyopo hwanɨngo fonjɨkujoꞌno Anɨtu kako sekumo wosehwosampoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aꞌamu hopiꞌnonohinoso Anɨtumo yoꞌmayo soꞌno jomo ulɨkujoꞌno Anɨtu uyɨmontonoho. Aꞌamu yoꞌmayo soꞌno hofɨko hafɨhafe tɨpɨfijoso wotɨpemantɨfeho. Aꞌamu hokuꞌyopo hwanɨngo fongkupijoso Anɨtu kako wosehwosampoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ou, sekwoe hwe fihwoe mehomi kanɨngkwohumo wopayo ntape ulososo kanɨngkwohwo sojo uyɨmtolaho. Awonoho. ");
INSERT INTO apz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ou, hwomu fihwo kanɨngkwohumo inanɨku ntape ulososo kanɨngkwohwo homa wonyo umtolaho. Oꞌo awonoho. ");
INSERT INTO apz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Oseso sekwo honɨngkano wonyoꞌnjo huhwasi sekwoe mehomimo yoꞌmayo wopɨngoꞌnohini uyɨwoꞌnɨngkohofo soꞌno sekwo huno ole waseyono. Sekwo sekwoe senɨngkwohwo Anɨtu ahwomomo humaso sohumo jomo ulɨkujoꞌno kako kakoe Towahuno wopɨngoso yoꞌmayo hwahoponjomo yakoloꞌnnyoso wosejapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Aꞌamu nomꞌneso sekumo wopɨngo wonalohopɨfe semoꞌnɨngkisoꞌmanji eꞌwa, sekwo sɨmoꞌmo oso yahino hiso hofɨkimo ulohopmno. Sekwo oso hiso ifijoso Mousesɨye honɨngkano hungkuno soꞌnji aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo sohwanjiye hungkuno hwapɨngo somo unɨngkowantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sekwo soku hokuꞌyo weꞌe somo fohumno. Aꞌamu tohino mayoꞌne honɨngkanoso engofoho. Oso honɨngkano engo homo somo aꞌamu piꞌnɨngo engoso tɨfi inɨngkowalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Honɨngkano songo neꞌno humayoꞌneso weꞌefoho. Hokuꞌyoso engoꞌmaho. Olo honɨngkano homo somo yafe engo paꞌnyo soꞌmo syoho engo woꞌnnyofoho. Aꞌamu angaꞌno angaꞌno oso honɨngkano somo wotɨpemantɨfeꞌno yalokwofoso tɨfi inɨngkowalokwofo. Oso hokuꞌyo weꞌe homo somo sekwo fohumno. ");
INSERT INTO apz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sekwo Aꞌamu Anɨtuye hungkunoꞌnji hwasyo hungkunoꞌnji mesyɨlutɨhwayo somneꞌno iꞌwaho itoꞌno fiyɨmno. Oso aꞌamu hiso hofɨkoe aꞌapaho sohohntaꞌni wopɨngofoho. I sɨmeho ajwomoꞌmo pisakinoꞌnjofoho. Oso aꞌamu hiso hofɨko sɨwojo paꞌnyofoho. Sekumo wonyo wosemokantɨfeꞌno yalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yoꞌmayo honɨngkano imofɨwoꞌnɨngkohofoso sekwo uhwonɨfijoso hofɨkoe hwapɨngoso huno waseyono. Kɨko iyo hiyayo yongoꞌnjo nontɨmjoso ipisayo meꞌwampeꞌnjo wamjɨmtaho. Awonoho. Solongkoyo sayo paꞌnyoso kakoe iyo nontɨmo untoꞌnawoꞌmtonoho. Oso iyo hiyayo ipisayo aneꞌnjo paꞌnyoso aꞌamu honɨngkano wonyoꞌnjo somtaꞌni hungkuno wopɨngo upoꞌnantantaho. Awonoho. ");
INSERT INTO apz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Oso paꞌnyoso iyo wopɨngoso ipisayo wopɨngo untoꞌnɨmontonoho. Iyo wonyoso ipisayo wonyo untoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Iyo wopɨngoso ipisayo wonyo untoꞌnɨmontoꞌmaho. Iyo wonyoso ipisayo wopɨngo untoꞌnɨmontoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ou, iyo ipisayo wonyo intoꞌnyoso hofɨko nolofekuji tohomo wolofefantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Osoꞌno aꞌamu hwasyo hungkunoꞌnjosofe honɨngkanomo uhwonɨngkuji hofɨkoe hwapɨngoso sekwo huno waseyono. Setenɨyefoho. ");
INSERT INTO apz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sekwo huno ole syafɨsyɨkutoho. Hwe moyaꞌmi hopiꞌnonohinoso hofɨko ngkimo ole ntɨwoꞌnɨngkohofi, Hwe Engofo, Hwe Engofo, ose ntɨwoꞌnɨngkohofoso Anɨtu mokosyohumaso ango sopo nohufitnnefoho. Ose syafɨsyɨkutoho. Nɨhuꞌno awonoho. Aꞌamu fihwo kako nje Mpohwo ahwomomo humaso sohwoe hungkunomo tɨfi inɨngkaweso sohwo kako Anɨtu mokosyohumaso angoso notɨpɨhwononefoho. ");
INSERT INTO apz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Oso Sɨkuno Engo hungkuno ikwolofoꞌne somo hwe moyaꞌmi piꞌnɨngo engoso ole ntɨfitnnefoho, Hwe Engo sohwosi, nakwo aꞌamu somo jɨje hungkuno wopɨngo lutɨhwawoꞌnɨngkuhwoneꞌnwoho. Aꞌamu towahuno wonyo ehuhnnamoꞌnnyo somo jɨje yofe lontaneso towahuno wonyo somo wae yaofɨwoꞌnɨngkuhwonefoho. Nakwo jɨje yofe lontaneso yoꞌmayo wonyoangkafoso aꞌamumo utɨhwayoꞌne iwoꞌnɨngkuhwoneꞌnwoho. ");
INSERT INTO apz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ose ntɨfijoso ole ulɨmnefoho. Ngko sekumneꞌno huno maniyohoyohoho. Oꞌo wonyo imotofo kuyoho. Ngkoꞌnjopo nohumafɨkutoho. Noho fohumpopmno. ");
INSERT INTO apz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Aꞌamu fihwo olo nje hungkunolo nupaꞌnɨngkuhwosi tɨfi inɨngkaweso sohwo kako hwe huno wopɨngoꞌnjo hweho. Oso hwe huhwo sohwo kako ango hwaho wopɨngopo molinyo hweho. ");
INSERT INTO apz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ango wopɨngopo nomolahonɨngki ifoyo syonto mijo ifofayo yonto tɨꞌmayo yokumpohnꞌnyo yonto oso ango homo somo ifofo mojwohojwafefoho. Oꞌo, ango hiso hwaho wopɨngopo molinyo soꞌno mopɨwasyonehoho. ");
INSERT INTO apz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aꞌamu nomꞌnihwo olo nje hungkunolo nupaꞌnɨngkuhwosi tɨfi monnɨngkaposo sohwo hwe hunoꞌmaso sohwo ango wosohopo molinyo sohweho. Hwe huhwo sohwo mijo tafepo kakoe ango nomolahonɨngki ");
INSERT INTO apz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ifoyo engo syonto mijo ifofayo yonto tɨꞌmayo ikwato lohofonto ango nontɨmo jwohojwohoꞌnamo lohoꞌmentisoso pɨwahuꞌmentisofoho. Oso ango nopɨwasyonto pomuyo engo hoꞌnɨmentisofoho. Nje hungkuno osohopeho. ");
INSERT INTO apz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas ose ulahonɨngki aꞌamu nupaꞌnontɨfi kakoe hungkuno soꞌno yomo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Hwapɨngoso hofɨko aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwa oso paꞌnyo hwaꞌmaho. Oꞌo, Jisas sohwo kako hungkuno hwapɨngo woꞌnnyo hweho. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas kako hwofɨkiꞌnyo sopo nulɨkoꞌmanto womentisoso aꞌamu piꞌnɨngo engo kakimo tɨfi inɨngkawomentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Osohonta hwe fihwo aꞌapaho uyo wonyoꞌnjo sohwo Jisasɨmo nuꞌmanto hwomtame ulohofonto ulɨmento, Hwe Engofo, kɨko ngkimo wopɨngo wanɨmokumo lisoꞌmanji jɨje yokumpohnꞌnyoso hoponoho. ");
INSERT INTO apz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ose ulahonɨngki Jisas kako aho kisusyonto hwe sohumo ulɨmento, Ou, wopɨngo wakumokumonneꞌno yohono. Kɨko wopɨngo hmmoꞌnyo. Ose ulahonɨngki hwe huhwo sohwo wopɨngo komoꞌno imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Wopɨngo imoꞌnɨngkahonɨngki Jisas ulɨmento, Upaꞌnyo. Kɨko olo hilo soꞌno nomꞌne aꞌamu somo nulohotoho. Oꞌo, komoꞌno nuhuji aꞌamu tajo ango syohoꞌnjo sohumo jɨje aꞌapaho wopɨngo loso utɨhwaho. Nokohonɨngkuhwosi kɨko hohonta Mouses yoꞌmayoso lɨmentiso hopaso Anɨtumo uyohojayo. Jɨje mnokino moiꞌwo imoꞌnyo soꞌno isamoyokafoho. Oso hisoꞌno aꞌamuso uhwonɨngkuji jɨje aꞌapaho uyo wonyoso wopɨngo imoꞌnɨngkiso soꞌno huno wosyofisyantɨfeho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas hwaho Koponeyamneꞌno womentisoso oso hopo sopo hwe fihwo yofe engoꞌnjo aꞌamu Loum sofe aꞌamu itokusoꞌnjo sohwamo mokosyohumayo sohwo Jisasɨmo nuꞌmanto hungkuno yokumpohnꞌnyo ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Hwe Engofo, nje syoho ntohofiyo sohwo kako mnokino uyahonɨngki angoꞌmo fosyohumaho. Kakoe aꞌapaho songo songo miyoꞌnjo yonto tohino mɨkunɨmposo umnalofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ose ulahonɨngki Jisas ulɨmento, Ngko nuꞌmo wopɨngo umokumo. ");
INSERT INTO apz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ose ulahonɨngki ulɨmento, Hwe Engofo, osoꞌneꞌmaho. Oꞌo, kɨko nje angomo ko swapihnneso ngko hwe wopɨngo hwoꞌnnye angoꞌmaho. Oꞌo, kɨko hungkunoꞌnohini lisoso nje syoho ntohofiyo sohwo kako wopɨngo umoꞌnono. ");
INSERT INTO apz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ihwoni. Ngko huhwoꞌni hwe engo sohwamo enjwaꞌmo humale soꞌno ngko hofɨkoe hungkunomo tɨfi itoꞌno inɨngkawoꞌnɨngkohe hwoꞌnyoho. U, hofɨko ngko huhwoꞌnɨmo nomꞌnihwa enjwaꞌmo humalofo. Oseso ngko hwe fihumo Mpano ulɨꞌmeꞌno kako wamtonoho. U, nomꞌne sohumo oyomo ulɨꞌmeꞌno kako wapmmontonoho. U, ngko nje syoho ntohofiyo fihumo, Olo syoho fiyo ulɨꞌmeꞌno kako syoho uyɨmontohono. Oseso kɨko hungkunoꞌnohini ulohojoꞌno ngko huno niyohoho. Nje syoho ntohofiyo sohwo wopɨngo umoꞌnɨmontonoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ose ulahonɨngki Jisas yomo yonto kakoe inomokomoyo sohwamo ulɨmento, Hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Ngko aꞌamu Isɨlael sofe sɨmeho hiꞌntnnono ntapinyo yahinoso oso hwe huhwo sohwoe paꞌnyoso muhwonyoꞌnjo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Upaꞌnɨmno. Hwe moyaꞌmi hungkuno kengo kengoꞌnjoso Anɨtu aꞌamumo esemokosyohumayo sopo nosyukuji hofɨko sekwoe seyakwosa Apɨlohamɨyo Aisakɨyo Jekoupɨyo oso hwanji nohumafɨkujoso wopayo nonɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","I, Aꞌamu Isɨlael Apɨlohamɨye imu fehohnjo soku esemokosyohumayo sopo ntaꞌni Anɨtu kako sekumo wae yasemofososo sekwo sɨkwoꞌmjohoꞌmo fosyohumantokutnne kuyoho. Oso hopo sopo fosyohumafɨkuji sekwo hulɨngkwajingo ifalohoꞌnɨngkuji humotaho engo lɨfitnne kuyoho. ");
INSERT INTO apz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kakoe inomokomoyo sohwamo ose ulonto hwe yofe engoꞌnjo sohumo ulɨmento, Kɨko sɨmeho hiꞌntnnono ngkimo ntape soꞌno yoꞌmayo soꞌno kumoꞌnɨngkisoso wakilohoꞌmonnoho. Ose ulahonɨngki oso hohosohonta syoho ulohofiyo sohwo wopɨngo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Oseso Jisas Pitafe angomo noswonto uhwonɨmentisoso Pitafe konemi aꞌapaho tohomtnnoꞌnjosi saho fosyowentanɨngki uhwononto ");
INSERT INTO apz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","kakoe ahomo nupmꞌmokahonɨngki aꞌmusi kakoe aꞌapaho toho mtnnoso moiꞌwo imoꞌnɨngkahonɨngki aꞌmusi kako nolɨkafonto aꞌamumne wopayo iloho humisyofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Oso sɨkuno ne soꞌnji aꞌamuso hofɨko hwe moyaꞌmi towahuno wonyo ehuhnnamoꞌnnyo somo Jisas nohumentanjopo motapmmentohofofoho. Nomotopahonɨngkofi Jisas hungkuno lonteso towahuno wonyo somo wae yaofonto aꞌamu mnokinoꞌnjo hopiꞌnonohino somo wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Oso hohosohonta oso hungkuno Anɨtu Aisaiya sohumo uyahonɨngki lutɨhwamojo sohwoe hungkunoso ne imoꞌnɨmentisofoho. Hungkuno hiloso ole, Kako nakwoe mnokino wonyoso wae enaoꞌmentisofoho. Nakwoe yoꞌmayo tangoso kako maꞌmentisofoho. Oso hungkunoso Aisaiya hohonta lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas kako aꞌamu piꞌnɨngo engo kakimo ifeehuꞌmo yɨmahonɨngkofi uhwononto kakoe inomokomoyo sohwamo ulɨmento, Nakwo mijo lomo nongkihntaꞌnneꞌno wowekehwano. ");
INSERT INTO apz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ose ulahonɨngki hwe fihwo honɨngkano hungkuno lutɨhwayo syohoꞌnjo sohwo Jisasɨmo uꞌmanto ulɨmento, Nje Lontɨhwayo sohwosi, kɨko ango ntɨꞌmno usoso ngko tɨfi wokinɨngkamonnoho. ");
INSERT INTO apz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ose ulahonɨngki Jisas ulɨmento, Sikisɨwojo sohwa hofɨko hofɨkoe sokimo hiꞌnjo hwafoho. Yɨhufo sohwa hofɨko hofɨkoe aifoso hiꞌnjo hwafoho. I osoꞌno ngko Aꞌamufe Hwomu sohwoꞌni ngko ango saho fosyaweꞌneso ane hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ose ulahonɨngki nomꞌne hwe Jisasɨmo inɨngkawowoꞌnɨngkiso sohwo Jisasɨmo ulɨmento, Hwe Engofo, ngko huhwoꞌni tɨfi wokinɨngkapmmonnoho. I osoꞌno sɨmoꞌmo ngko nje mpohwo kakiꞌno piꞌnɨmomo ijopijɨsyasiꞌmo pe-eso. Wopɨngotaho. ");
INSERT INTO apz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ose ulahonɨngki Jisas ulɨmento, Awonoho. Aꞌamu ngkimo tɨfi monnɨngkapɨfijoso hofɨko ujopijisyahufe. Kɨko neꞌno nnɨngkape. ");
INSERT INTO apz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ose ulonto Jisas yofayokinomo nokotosahonɨngki kakoe inomokomoyo sohwa tɨfi inɨngkamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yofayokinoso mijopo nowentanɨngki mijo ayoso hwofɨkiꞌnyo paꞌnyo imoꞌnonto yofayokinomo ufehuꞌmokahumonto yahonɨngki Jisas kako saho humofosyawentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","I inomokomoyo sohwa hofɨko Jisasɨmo komoꞌno ulɨkafontɨfi ulɨmentohofi, Hwe Engofo, fonefoꞌmaho. Weꞌenepi nakwoe yofe moiꞌwo umoꞌnantaneꞌno yalokuhwono. ");
INSERT INTO apz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo iyoho pehoꞌno senɨngkohoho. Sekwoe sɨmeho hiꞌntnnonoso weꞌeꞌnjo hwasoho. Ose ulonto nolɨkafonto ifofo soꞌnji mijo soꞌnjimo hungkuno ulahonɨngki mijo apaꞌno songo songo miyoꞌnjo nɨhuꞌnahone lɨfawoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Inomokomoyo sohwa ose uhwonontɨfi yomo yontɨfi hnnɨmentohofi, Olo hwe lohwo peho sohwolo. Ifofoꞌnji mijoꞌnji kakoe hungkunomo halohoꞌnohini yohoho. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas mijo ayo somo nongkihntaꞌni hwaho Ngkatola sopo iꞌmofamentisofoho. Oso hohosohonta hwe towahuno wonyo ehuhnnamoꞌnnyo sohwaꞌu uꞌmaꞌmentisiyefoho. Oso hwe sohwaꞌu hiko aꞌmopijohino sopo humohumantisiyo hwaꞌu pmmentisiyefoho. Oseso oso hwe sohwaꞌu towahuno nɨhuꞌno wonyo ehuhnnamoꞌnnyo sohwaꞌu aꞌmopijohino honɨngkano somo wopanjitɨkenontɨfi aꞌamuso iyoho unɨmojofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Osohonta siko Jisasɨmo joho mohmꞌno lonji ulɨmentisiyo, Kɨko Anɨtuye Hwomu Ne hwosoho. Kɨko nekumo peho welohoꞌmneꞌelo. Nekwoe sɨkuno mmoꞌnyofoho. Kɨko nekumo tohino wejapmmonneꞌno lapohino. Ose ulɨmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hopo soponjo yahu piꞌnɨngo engoso kengo nompo humantɨfi mno humijohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Oseso towahuno wonyo sohwa Jisasɨmo ulɨmentohofi, Kɨko wae wenaoꞌmjiꞌmanji kɨko oso yahu piꞌnɨngo engo nongkwanjo nompono fonehwajo. Nakwo yahu somo wehuhnnaofano. ");
INSERT INTO apz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ose ulahonɨngkofi Jisas ulɨmento, Eꞌwa, sekwo mpanɨmno. Ose ulahonɨngki towahuno wonyo hiso oso hwe hufaꞌuyo sohwaꞌumo ulɨkoꞌmantɨfi yahu somo ehuhnnaoꞌmentohofofoho. Ehuhnnaofahonɨngkofi yahu hiso hofɨko hano kunto kuntoꞌno wentɨfe iwoꞌmangomo mtɨkuꞌnontɨfi mijo ayomo nɨhuꞌnahone mehuloꞌmentisofoho. Nomehulofahonɨngki mijomo poyo imoꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Oso yahu mokosyohumayo sohwa angopono komoꞌno wentɨfi oso hungkuno hopiꞌnonohinoso ulɨmentohofofoho. Hofɨko mpoyo hwe hufaꞌu towahuno wonyo ehuhnnamoꞌnnyo sohwaꞌumo yoꞌmayo uꞌmaꞌmentiso soꞌno humalohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Osohonta aꞌamu ango hopo soponjoso hofɨko Jisas humentanjopo noswoꞌnontɨfi Jisasɨmo nuhwonontɨfi hungkuno ole ulɨmentohofi, Kɨko nakwoe hwaho lopo nofosyohumahofoho. Nomꞌne angopono fɨwano. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas yofayokinomo kotasonto ayo momɨngo somo kuꞌmokwawento kakoe ango hwapɨngo sopo iꞌmofamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Iꞌmofaohwahonɨngki aꞌamuso hofɨko hwe nomꞌne sɨfe aho peꞌnnyo sohwo kakoe ijempohopoꞌnohini saho fosyawowoꞌnɨngkiso sohumo Jisasɨyepono itokwopmmentohofofoho. Itokwopahonɨngkofi Jisas kako uhwonɨmentisoso hofɨko kakineꞌno sɨmeho hiꞌntnnono yokumpohnꞌnyo uyohonɨngkofi uhwononto Jisas oso aꞌamu mnokinoꞌnjo sohumo ulɨmento, Nje hwomu sohwosi, kɨko iyoho kinɨngkuhwoloho. Ngko jɨje honɨngkano wonyoso wae nto yakumofohono. ");
INSERT INTO apz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ose ulahonɨngki aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwa nohumantɨfi ole hnnɨmentohofi, Olo hwe lohwo sohwo kako Anɨtu paꞌnyo pojiyalofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ose hnnɨngkahonɨngkofi, hofɨkoe hunoso Jisas kako huno moiꞌwonoho. Osoꞌno Jisas ulɨmento, Sekwoe sɨmeho moꞌmo huno wonyoso pehoꞌno syonɨfɨsyantokwofo. Ole losyonɨfɨsyantɨkwofo, ngko aꞌamufe wonyo wae meeofonehoho losyonɨfɨsyantɨkwofo. ");
INSERT INTO apz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Anɨtu kako ngkimo aꞌamumo ufoꞌmayoꞌne nɨhwatɨmentiso sohwoꞌni olo hwaho lopo aꞌamufe honɨngkano wonyo wae yaofoꞌne yokumpohnꞌnyoso hiꞌnjo hwoꞌnyoho. I osoꞌno aꞌamu fihwo jɨje honɨngkano wonyo wae weekumoꞌmo loso sohwoe hungkuno somo ne imoꞌnyo soꞌno sekwo sɨmeho moꞌmo muhwonɨfitnne kuyoho. Oso yokumpohnꞌnyo ngko seloheso hiꞌnjo sohwoꞌni utɨhwaꞌnyopo setɨhwahmꞌmeꞌno hungkuno nomꞌne kengoso hwe lohumo ulɨmonneꞌno yohono. Hofɨkimo ose ulonto kako hwe mnokinoꞌnjo sohumo ulɨmento, kɨko nolɨkafohoji jɨje ijempohoso nomahoji jɨje angopo neꞌno mpano. ");
INSERT INTO apz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ose ulahonɨngki hwe huhwo sohwo nolɨkafonto kakoe angomno umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nowahonɨngki hwe moyaꞌmiso nuhwonontɨfi iyoho unɨngkahonɨngki hofɨko ole lɨmentohofi, Anɨtu kakoe yokumpohnꞌnyo engoso olo paꞌnyo loso hwe lohumo uyohoho. Huno ose uyahonɨngki hofɨko Anɨtuye yofe hoꞌnomaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Oseso Jisas hano wento uhwonɨmentisoso hwe fihwo hamniyoho mayo syohoꞌnjo sohwo kakoe ango somo humamentisofoho. Oso hwe huhwo sohwo kakoe yofe Matɨyu. Oso hwe huhwo sohumo Jisas nuhwononto ulɨmento, Kɨko ngkimo tɨfi nnɨngkape. Ose ulahonɨngki Matɨyu nolɨkafonto tɨfi inɨngkamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas Matɨyuye angomo nohumentanɨngki aꞌamu nomꞌne hamniyoho mayo syohoꞌnjo honɨngkano wonyoꞌnjo sohwanji aꞌamu wonyo honɨngkanoꞌnjo nomꞌne soꞌnji nohumentanɨngkofi hofɨko Jisasɨꞌnji kakoe inomokomoyo sohwanji wopayo nɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nonontanɨngkofi aꞌamu Falisi fehohnjo sohwa nuhwonontɨfi Jisasɨye inomokomoyo sohwamo ulɨmentohofi, Sekwoe Hwe Engo lohwo kako aꞌamu hamniyoho mayo syohoꞌnjo lohwanji aꞌamu wonyo honɨngkanoꞌnjo loꞌnji wopayo pehoꞌno nalofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ose ulahonɨngkofi Jisas nupaꞌnonto pahnnɨmo hungkuno ulɨmento upaꞌnɨmno. Aꞌamu mnokino aneꞌnjo wopɨngo humalofoso hofɨko aꞌamu uyohofahosiyoꞌnjo sohumo muꞌmapitnnehofo. Oꞌo, aꞌamu mnokinoꞌnjo soꞌnohini uꞌmantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oso paꞌnyoso ngko aꞌamu honɨngkano wopɨngoꞌnjo hwonaꞌnyoho lɨwoꞌnɨngkohofo somneꞌno joho lutɨmayoꞌne pmmentohe hwonɨꞌmaho. Oꞌo, ngko aꞌamu honɨngkano wonyoꞌnjo somneꞌno pmmentohe hwoꞌnyoho. Sekwo Anɨtuye hungkuno somneꞌno huno waseyono. Hungkuno ole, Sekwo nomꞌne somneꞌno hitoho ulofo soꞌno nɨmoꞌnɨngkohoho. I sekwo ngkineꞌno hwomtame ko ntohofontɨfi nomꞌne aꞌamu somneꞌno hitoho mulofeꞌnjoꞌmanji ngkilaho. Oso hungkuno somneꞌno huno waseyono. ");
INSERT INTO apz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Oso hohosohonta Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwoe inomokomoyo sohwa Jisasɨmo uꞌmaꞌmentohofofoho. Nuꞌmantɨfi ulɨmentohofi, Nakwoꞌnji aꞌamu Falisi sohwanji wopayo manyoꞌnjo humayoso Anɨtumo jomo ujoꞌne yahinoso inɨngkawowoꞌnɨngkuhwonefoho. I osoꞌno jɨje inomokomoyo sohwa hofɨko wosopayo manyoꞌnjo humayo yahino somo minɨngkayoꞌnjo pehoꞌno yalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ose ulohonɨngkahonɨngkofi Jisas pahnnɨmo hungkuno ulɨmento, Hwe fihwo kako ape songo mayo sohonta osohwo kakoe aꞌamuꞌnji nohumahwosi hofɨko sɨmeho tangoꞌnji wohumantɨfi taho. Awonoho. Hofɨko sɨmeho wopɨngoꞌnji wopayo engo wonantɨfeho. I osoꞌno hwangku oso hwe ape maso huhwo sohumo aꞌamu nomꞌne sohwa hofɨko kakoe aꞌamu mtaꞌni kompemafɨkuji fonjasyɨkujoꞌno kakoe aꞌamu hiso kako ane humafɨkujoso sɨmeho tangoꞌnjo humafɨkuji wosopayo manyoꞌnjo uyantɨfeho. Ose ulonto pahnnɨmo hungkuno nomꞌne ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hwe fihwo manjiꞌmofo tontamo imoꞌnnyo sohwo kako hwapɨfe nomꞌne songo weꞌeso nomahwosi tontamo somo lojwohofojasi lohofɨhwosi yakɨfe uyɨmtolaho. Awonoho. Engo womnahotɨꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ose ulonto pahnnɨmo hungkuno tɨfinjoso ole ulɨmento, Ou, aꞌamu fihwo kako mijo iloho uyɨmo lɨhwosi te fisɨyo womaꞌmontolaho. Oꞌo, awonoho. Kako te fisɨyo mahwosi mijo ihmꞌmofɨhwosi iloho yososo mijo wahumpoꞌmontonoho. Te fisɨyoso nɨhuꞌnahone wonyo umoꞌnɨmontonoho. U, hwe huhwo sohwo kako te songoso mahwosi mijo ihmꞌmofɨhwosi iloho yososo mijo itoꞌno wolɨfawoꞌmontonoho. Ihwoni. Yahino hohontajo soꞌnji songo soꞌnji nemꞌno huꞌmɨngoso itoꞌnohinoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas oso hungkuno hiso ulontanɨngki hwe yofe engoꞌnjo sohwo Jisasɨmo uꞌmanto hwomtame ulohofonto ulɨmento, Nje mu olohonta nto peꞌnɨngkohoho. I osoꞌno kɨko nopohoji kakimo jɨje ahoso fɨkisyusyo. Kako apaꞌno songo wolɨkafono. ");
INSERT INTO apz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ose ulahonɨngki Jisas nolɨkafonto kakoe inomokomoyo sohwanji hwe huhwo sohumo tɨfi inɨngkamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Nowentanɨngkofi nomꞌne aꞌmusi Jisasɨmo inɨngkawomentisofoho. Aꞌmusi imoiho neꞌno yontanɨngki soswo aho hufaꞌu hopiꞌnono sɨfe mtaꞌni hufaꞌu uyakoloꞌmojofoho. Oso aꞌmu hisi kako Jisasɨmneꞌno hnnɨmento, Ngko olo hwe lohwoe manjiꞌmofo somo aho kisahumeso ngko wopɨngo umoꞌnɨmonnoho. Ose hnnonto kako Jisasɨye hohujo hohntaꞌni uꞌmanto kako Jisasɨye hwapɨfe tokwajo somo aho upmꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nopmꞌmokahonɨngki Jisas ikinjamo lohofonto aꞌmu simo nuhwononto ulɨmento, Nje mufo, jɨje sɨmeho wopɨngo wakumoꞌnono. Kɨko ngkimo sɨmeho hiꞌntnnono ntapohino soꞌno wopɨngo nto imoꞌnɨngkino kiyoho. Ose ulahonɨngki oso hohosohonta aꞌmusi wopɨngo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Oseso Jisas kako nowento hwe engo sohwoe angomo swonto uhwonɨmentisoso aꞌamu hofɨko te somo hmpehmpe lontanɨngkofi aꞌamu wosofe hoꞌnowentanɨngki nuhwononto ");
INSERT INTO apz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jisas ulɨmento, Sekwo mpanɨmno. Mu weꞌesi poyoꞌmaho. Kako saho fosyaweho. Ose ulahonɨngki hofɨko Jisasɨmneꞌno tɨkafo ujɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tɨkafo ujɨmentohofoso Jisas hofɨkimo mempo hohntaꞌni uhwajonto humentisofoho. Noswonto oso mu sopiye ahomo nomahonɨngki mu sopi lɨkaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lɨkaꞌmentiso soꞌno oso hungkuno hiso angoꞌmeemo hoꞌnɨmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas oso ango hopo sopo nulɨkoꞌmanto nowentanɨngki hwe tɨmpiꞌnyo sohwaꞌu Jisasɨmo tɨfi inɨngkawenji joho ole ulɨmentisi, Ntefitɨye Imu sohwosi, nekumneꞌno hitoho wakilofono. ");
INSERT INTO apz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ose ulahonɨngki Jisas kako angomo swahonɨngki oso hwe tɨmpiꞌnyo sohwaꞌu Jisasɨmo uꞌmahonɨngki Jisas ulɨmento, Ngko sikimo wopɨngo semokiyo soꞌno sɨmeho hiꞌntnnono lontapisiyo. Ose ulohonɨngkahonɨngki ulɨmentisi, Ou, Hwe Engofo, eno. ");
INSERT INTO apz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ose ulahonɨngki Jisas sikoe tɨmopo aho kisasyonto ulɨmento, Siko ngkimo sikoe sɨmeho hiꞌntnnono ntapisiyoꞌmanji yoꞌmayo siko nosemoꞌnɨngkisoso woseꞌmano. ");
INSERT INTO apz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ose ulahonɨngki sikoe tɨmo honɨmentisiyefoho. Oseso Jisas sikimo hungkuno yokumpohnꞌnyo ole ulɨmento, Upaꞌninyo. Wopɨngo semokohe soꞌno nomꞌne aꞌamu fihumo nulohosiloho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","I osoꞌno siko mempo hohntaꞌni noswonji yoꞌmayo Jisas imentiso soꞌno hwaho aeꞌmo aꞌamu somo ulɨmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Oso hwe huhwo sohwaꞌu nosontanɨngki aꞌamu nomꞌne sohwa hofɨko hwe ilohoꞌnnyo towahuno wonyo ehuhnnamoꞌnnyo sohumo ipemotapontɨfi Jisasɨyepono umentohofofoho. Oso towahuno wonyo huhwo sohwo hwe sohumo mampiꞌnyo mesyɨmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Oseso Jisas oso hwe sohwoe towahuno wonyo wae yaofahonɨngki kako hungkuno lɨmentisofoho. Hungkuno lahonɨngki hwe moyaꞌmi hofɨko yomo yontɨfi huno piꞌnɨngo syafɨhuꞌmentohofi, Hohonta olo yahino loso aꞌamu Isɨlael hnꞌnɨmo mꞌmofapeꞌnjo imojofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ose lahonɨngkofi aꞌamu Falisi sohwa ole lɨmentohofi, Towahuno wonyo hopiꞌnohino sohwafe hwe engoso Setenɨyoho. Oso humtaꞌni Jisas kako yokumpohnꞌnyo nomanto towahuno wonyo homo somo wae yaofalofoho. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Oseso Jisas angoꞌmeemo nowento aꞌamu sofe tajo ango somo kakoe hungkuno Anɨtu aꞌamumo umokosyohumayo soꞌno lutɨhwanto aꞌamu wonyoꞌwonyo mnokinoꞌnjo somo wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jisas hwe moyaꞌmi piꞌnɨngo engo somo uhwonɨmentisoso yoꞌmayo tango engoꞌnjo aꞌamu somo uꞌmahonɨngki yokumpohnꞌnyo ufoꞌmaꞌnyoꞌneso anefoho. Yahu kakwoꞌyohwo ane paꞌnyofoho. Ose uhwononto kako hitoho uloꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hitoho ulofahonɨngki Jisas kakoe inomokomoyo sohwamo pahnnɨmo hungkuno ulɨmento, Wopayo syoho soponjo piꞌnɨngo engoso toyo nto imaho. I oso hisoꞌno aꞌamu wopayo toyo mjiyoꞌne syohoꞌnjo sohwa hopoenohino hwaꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Oseso sekwo olo syoho loso mokosyohumawoꞌnɨngkiso kakwoꞌyohumo jomo ulɨkujoꞌno kako oso wopayo toyo homo somo mjiyoꞌne aꞌamumo lɨhwajiyoꞌne jomo ulɨmno. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Oseso Jisas kakoe inomokomoyo aho hopiꞌnonohino sɨfe mtaꞌni hufaꞌu sohwamo joho ulahonɨngki hofɨko nuhuꞌmokahonɨngkofi Jisas kakoe yokumpohnꞌnyoso yano uyɨmentisofoho. Oso yokumpohnꞌnyoso aꞌapahomjo towahuno wonyo wae yaofoꞌne soꞌnji aꞌamu mnokinoꞌnjo soꞌntnneꞌno wopɨngo umokiyoꞌne soꞌnji uyɨmentisofoho ");
INSERT INTO apz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Oso inomokomoyo (apousel) aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sohwafe yofe olenoho. Sɨmoꞌmjoso Saimounɨyoho. Saimoun huhwo kakoe nomꞌne yofe olenoho. Pitafoho. Nomꞌnihwo Entɨlu, Saimoun Pitafe konɨngkwaꞌwe hweho. Nomꞌne sohwaꞌu Jemɨsɨꞌnji konɨngkwaꞌwehwo Jounɨyoho. Oso huhwo sohwaꞌu Sepetiye hwomu hwaꞌuyoho. ");
INSERT INTO apz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nomꞌnihwaꞌu ole, Filipɨꞌnji Mpatoulomɨyuꞌnjoho. Nomꞌnihwaꞌu Toumasɨꞌnji hamniyoho mayo syohoꞌnjo sohwo Matɨyuꞌnjoho. Nomꞌne Tatiyosɨꞌnji Alɨfiyosɨye hwomu Jemɨsɨꞌnjoho. ");
INSERT INTO apz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nomꞌnihwaꞌu Saimoun Seloutɨꞌnji Jutas Isɨkaliyoutɨꞌnjoho. Jutas huhwo sohwo Jisasɨmneꞌno tokoyoꞌofo yonto aꞌamu Jisasɨmo fonjasiyoꞌne sohwafe ahomo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas oso hwe aho hopiꞌnonohino sɨfe mtaꞌni hufaꞌu huhwo sohwamo hungkuno ulonto uhwatɨmentisofoho. Hungkuno hiso olenoho. Sekwo aꞌamu temtitofo kengo sofe ango soponeꞌno ango Someliya soponeꞌno nukutoho. ");
INSERT INTO apz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Oꞌo, aꞌamu Isɨlaelɨꞌnohino sofepono fɨwanɨmno. Aꞌamu Isɨlaelɨso hofɨko yahu isɨpeemofo paꞌnyo honɨngkanoꞌno tɨpeelokwofo. ");
INSERT INTO apz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sekwo nukuji hungkuno ole soꞌno ulɨmno. Anɨtu aꞌamumo yokumpohnꞌnyo mokosyohumayo sɨkuno mofonepo nto imoꞌnɨmaho. Osoꞌno ulɨmno. ");
INSERT INTO apz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sekwo aꞌamu mnokinoꞌnjo somo wopɨngo umokukuji aꞌamu poyo peꞌnyo somo songo ulɨkafɨkuji oso mnokino uyo wonyoꞌnjo (lepɨla) wopɨngo imoꞌnɨngkujoꞌno towahuno wonyoso wae hmmopmno. Olo yokumpohnꞌnyo loso hamniyohoꞌnjo mahofoꞌmaho. Oꞌo, ngko sejapohefoho. Osoꞌno sekwo olo yokumpohnꞌnyo loꞌnji yoꞌmayo uyɨfijoso hamniyoho momasoꞌnjo uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sekwo hamniyoho kiꞌyoꞌnji nomokahoꞌnɨngkutoho. ");
INSERT INTO apz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Sekwo yoꞌmayo hoꞌyo nomokahoꞌnɨngkutoho. Oꞌo, manjiꞌmofo nomꞌneso sɨfɨkwongo fosyo nomꞌne soꞌnji mno hwanji nomokahoꞌnɨngkutoho. Awonoho. Aꞌamu syoho yoso sohwo kakoe wopayo nyoso wotɨpemaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Oseso sekwo ango engo fipo ufijoꞌmanji ou, ango weꞌe fipo ufijoꞌmanji osopo sekwo tɨmo itoꞌno uhwonɨngkuji oso ango hopo sopo hwe wopɨngo itoꞌnohinoso tɨhwo kofosyohumaho, uhwonɨfijoso oso hwe wopɨngo sohwoe angomo fosyohumamno. Oso ango hopo sopo neꞌno nohumafɨkuji wohumpeeno lɨkujoso oso hwe huhwo sohwoꞌnji fosyawentɨfijo sohwasi fohumpopmno. ");
INSERT INTO apz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Oseso oso ango homo somo hufijoso sekwo oso hwe moyaꞌmi angomjo somo ole ulɨmno. Nakwoe aꞌamu soku Anɨtu wopɨngo waselohofono. ");
INSERT INTO apz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ose ulahonɨngkuji hofɨko Anɨtuye hungkuno upoꞌnano lɨfijoꞌmanji hofɨkoe sɨmehoso itoꞌnohiniꞌmanji sekwo sɨmeho pompenjiyoso oso aꞌamu somo uyɨfijoso hungkuno sɨmoꞌmo nto ulɨfijoso nehopi umoꞌnɨmontonoho. I oso hisoꞌno hofɨko Anɨtuye hungkuno nakwolaho lɨfijoꞌmanji sekwoe hungkuno wopɨngoso nomꞌne ango poneꞌno motawomno. ");
INSERT INTO apz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hwe fihwo kako kakoe angomno mipesemotayoꞌnjo yɨhwosi Anɨtuye hungkunomo haloho maseposoꞌnjo ifijoꞌmanji oso hopo sopo nulɨkoꞌmafɨkuji hopo soponjo hwaho semongkiꞌnososo hofɨko nosehontohumentanɨngkuji oso hintalinyo hiso wae feemoꞌnɨmno. Oso homo somo sehonɨfijoso huno ole uyɨmontonoho. Hungkuno haloho maposoꞌneso hungkuno tangoꞌnjo weho. ");
INSERT INTO apz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Upaꞌnɨmno. Nje aꞌamu sohwasi, ngko hungkuno waselɨmonneꞌno yohono. Sɨkuno aeꞌuyo somo aꞌamuso yahino wonyo soꞌne hungkuno ikwolofoꞌne sohonta oso ango hufaꞌu sopo Soutomꞌnji Ngkumoulaꞌnji aꞌamuso hofɨkoe yahino pisakinoꞌnjo somneꞌno tohino engo wotɨpemantɨfeho. I osoꞌno aꞌamu sekumneꞌno hohujo ikinjasemofoso hofɨkoe tohinoso Soutomꞌnji Ngkumoulaꞌnji aꞌamufe tohino somo yakoloꞌnnyofoho. ");
INSERT INTO apz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Upaꞌnɨmno. Ngko sekumo sehwojalokweso sekwo yahu osyuyo paꞌnyo hwasoho. Aꞌamu sikisɨwojo paꞌnyoso wonyo wosemokantɨfeꞌno yalokwofo. Osoꞌno sekwo yoꞌmayo ifijo soꞌno huno itoꞌno syafɨsyɨkuji nomꞌne somo wonyo mulohofeꞌnjo fiyɨmno. ");
INSERT INTO apz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sekwo yoꞌmayo yoꞌmayo aꞌamu selohofoꞌne noselɨkujoꞌno huno itoꞌno fɨsyafɨhupmno. Kaunɨsolɨꞌnjopo ipesemotafitnnoho. Hofɨko tajo ango somo hwanɨngo sefongkupitnnoho. ");
INSERT INTO apz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hofɨko ngkimo sɨmeho monje wenisyano lɨkuji hofɨko sekumo hwe yofe engoꞌnjo hwaho mokosyohumayo sohwafepono upesemotowantɨfeho. Osoꞌno sekwo aꞌamu yofe engoꞌnjo sohwanji aꞌamu temtitofo kengo soꞌnjimo nje hungkuno wolutɨhwantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hofɨko sekumo hungkunoꞌno ipemotasewofijo sohonta sekwo iyoho senɨngkuhwaloho. Huno ole syafɨsyɨkutoho. Hofɨko hungkuno nalohonɨngkujoꞌno nakwo peho hungkuno ulantanto. Ose syafɨsyɨkutoho. Oꞌo, ofaholohumo Anɨtu hungkuno nolɨfitnneso wolosetɨhwamtonoho. ");
INSERT INTO apz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sekwoe hungkunoꞌmaho. Oꞌo, sekwoe Mpohwoe Towahuno sohwo sekwoe mango mtaꞌni hungkuno walɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Hwangku sohonta aꞌamuso konɨngkwaꞌwehumo hungkuno lɨwoꞌnɨngkohofo sopono ipemotakuji osopo hungkuno lɨkuji nofonjahufitnnefoho. Hwe fihwo kakoe mehomimneꞌno oso paꞌnyo ulohofonefoho. Mehomiso kanɨngkwohwoꞌyaꞌumneꞌno mangohwa imoꞌnɨngkuji fonjahufitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Oseso aꞌamu hopinono sekumneꞌno sɨmeho tohino mɨkunɨmposo umnonefoho. Hwapɨngoso nje yofeso sekumo weho. Osoꞌno aꞌamu fihwo yokumpohnꞌnyo neꞌno lohofontanɨngkuhwosi sɨkuno aeꞌuyo sohonta Anɨtu kako oso hwe sohwo utɨmaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ango fipo hofɨko fonjofepmnasemofɨkujoꞌno sekwo nomꞌne angopo hiyaso fɨwanɨmno. Ngko nehopi waselɨmonneꞌno yohono. Sekwo aꞌamu Isɨlael sofepono nowentanɨngkuji syoho moiꞌwo mmoꞌnyoꞌnjo yontanɨngkuhwosi Aꞌamufe Hwomu wapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Hwomu sɨkule syoho iwoꞌnɨngkiso sohwo kako aꞌamu kakimo lutɨhwawoꞌnɨngkiso sohumo uyakoloꞌmontolaho. Aꞌamu nomꞌne somo umokosyohumayoso kakoe syoho ulohofiyoso kakimo muyakolofonehoho. ");
INSERT INTO apz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yoꞌmayo lutɨhwayo sohumo iꞌmofapososo oso paꞌnyo kakoe sɨkule syoho iwoꞌnɨngkohofo sohwamo umoꞌnɨmontonoho. Yoꞌmayo hwe nomꞌne sohwamo umokosyohumayo sohumo iꞌmofapososo oso paꞌnyo kakoe syoho ulohofiyo sohwamo umoꞌnɨmontonoho. Hofɨko ango kakwoꞌyohwo sohumo sitofo ole ulɨmentohofi, Jɨje yokumpohnꞌnyo Seten mtaꞌango hwosoho. Ose ulɨmentohofo soꞌno hofɨko kakoe mehomi sohwamo hungkuno wonyoso yakolo ulohofonefoho. ");
INSERT INTO apz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Oso hisoꞌno sekwo hofɨkineꞌno iyoho senɨngkuhwoloho. Yoꞌmayo hiyasoꞌmo wojoso hwangku utɨhwaꞌnyopo uꞌmofapmmontonoho. Yoꞌmayo sekwo hiyaso mokosyohumawoꞌnɨngkohofo hungkuno hiyasoꞌmo lontɨfeso yahino wonyo hiyasoꞌmo yontɨfi tɨfi noꞌmo utɨhwaꞌnyopo iꞌmofapɨhwosoꞌno aꞌamu tɨmo uhwonantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hungkuno hiyasoꞌmo selɨmaleso sekwo mofehiꞌnyo lahonɨngkuhwosi filɨkuno. Hungkuno hofiyoka upaꞌnɨngkohofoso sekwo utɨhwaꞌnyopo mango engoꞌnji filɨkuno. ");
INSERT INTO apz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aꞌamu jɨje aꞌapahomo kufongkiyo soꞌno iyoho kinɨngkuhwoloho. Hofɨko jɨje aꞌapahoꞌnohini wokufonjantɨfeho. Jɨje huyoꞌmangoso mofonjakohufitnnehofo. Oꞌo, Anɨtuneꞌno iyoho wakinono. Kako jɨje aꞌapahoꞌnji jɨje huyoꞌmangoꞌnji tɨkanomo mɨhwajososo hoponoho. ");
INSERT INTO apz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yɨhufo weꞌe sohwaꞌumneꞌno aꞌamu hamniyoho touya angaꞌno mpe iwoꞌnɨngkohofofoho. I oso yɨhufo hisoꞌno kako poyo peꞌnyo soꞌno sekwoe Mpohwo Anɨtu kako huno uyohoho. Mpohwo kako yɨhufo soꞌno nopeꞌnɨngkuhwoloho lososo yɨhufo huhwo sohwo mapeꞌnonehoho. ");
INSERT INTO apz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Sekwo soku, Anɨtu kako yoꞌmayo hopiꞌnonohinoso hunoꞌnjo hweho. Kako jɨje mnokinomjo mijiyo kengaꞌno kengaꞌnohinoso Anɨtu kako atofo nto lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Osoꞌno sekwo poyo semokiyo sohwamneꞌno iyoho senɨngkuhwaloho. Oꞌo, oso yɨhufo nɨhuꞌno weꞌe Anɨtu inɨngo mamofeꞌnjo hofiyo mokosyohumawoꞌnɨngkiso somo sekwo yakoloꞌnnyo kuyoho. ");
INSERT INTO apz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Aꞌamu fihwo kako aꞌamufe tɨmopo ngkineꞌno hungkuno lɨjwaofoso sohwo oso humneꞌno ngko nje Mpohwo ahwomomo humaso sohwoe tɨmopo hungkuno wolijwaoꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","I osoꞌno aꞌamu fihwo kako aꞌamufe tɨmo sopo ngkineꞌno hohujo ikinjanɨmofoso sohwo oso humneꞌno ngko huhwoꞌni nje Mpohwo ahwomomo humaso sohwoe tɨmopo hohujo ikinjɨmoꞌmnefoho. ");
INSERT INTO apz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ole losyonɨfɨsyantɨkwofo. Olo hwaho loponjo ikujoho yoꞌmayo yahinoso moiꞌwo esojwaofoꞌne pmmentiso hweho. Oꞌo, ngko ikujoho moiꞌwo imoꞌnyoꞌne pmmentohe hwonɨꞌmaho. Awonoho. Ngko aꞌamu husilofoꞌne pmmentohefoho. ");
INSERT INTO apz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ngko olo hwaho loponeꞌno pe-eso ikujoho ulɨkafoꞌne pmmentohefoho. Hwomu fihwo kako ngkimo nnɨngkapɨhwosoꞌno kakoe kanɨngkwohwo ngkineꞌno ngkilaho walɨmontonoho. I mu fisi kako ngkimo nnɨngkapɨhwosoꞌno konaꞌwohi ngkilaho wantɨmontonoho. U, aꞌmu fisi kako ngkimo nonɨngkapɨhwosoꞌno kakoe hwomufe ape mangohwo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Oso ango afa somjo soꞌnji oso hopa imoꞌnɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Hwe fihwo kanɨngkwohwoꞌyaꞌumneꞌno umoꞌnɨwoꞌnɨngkiso sohwo kako ngkineꞌno umoꞌnyoso yakoloꞌnnyo mumoꞌnyoꞌnjo yososo nje aꞌamu nehwoꞌmaho. Hwe fihwo kakoe hwomuꞌnji mu sopi ntnneꞌno sɨmeho umoꞌnyoso yakoloꞌnnyo umoꞌnyo sohwo kako ngkineꞌno mumoꞌnyoꞌnjo yososo nje aꞌamu ne hwoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hwe fihwo kako kikimo wokinɨngkapmmo ntoso sohwo kako nje yofeꞌno poyo imoꞌnyo soꞌno iyoho unoso sohwo kako nje aꞌamu ne imoꞌnyoso hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Hwe fihwo olo hwaho lopo humahwosi kako kakoe yahino yokumpohnꞌnyo kesyohumaso sohwo kako songo humayoso motɨpɨhwonone hweho. Hwe nomꞌnehwo ngkimo tɨfi nnɨngkaponto kakoe yahino hoꞌnaofalokunjo sohwo kako songo humayoꞌne notɨpemane hweho. ");
INSERT INTO apz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Aꞌamu wopɨngo selohofoso sohwo kako ngkimo wopɨngo ose ntohofantofoho. Oso aꞌamu wopɨngo ntohofantofonjo sohwo nje Mpohwo nɨhwatɨmentiso sohumo oso wopɨngo hiso oseꞌnohini uyalofoho. ");
INSERT INTO apz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hwe fihwo Anɨtu kakoe hungkunoꞌno uhwatɨmentiso sohwo aꞌamu nomꞌne oso hwe huhwo sohumo uhwononto syafɨhuꞌmento, Olo hwe lohumo Anɨtumneꞌno wopɨngo ulohoꞌmo loso sohwo kakoe angomo hwe huhwo sohumo wopɨngo umokosyohumasoso oso hwe huhwo sohwo hwe Anɨtu uhwatɨmentiso hopa wopɨngo nomane hweho. Ou, hwe nomꞌne kako hwe wopɨngo sohumo uhwononto hwe wopɨngo sohumo wopɨngo ulohoꞌmo loso sohwo wopɨngo sohwo paꞌnyoso kako wopɨngo nomanefoho. ");
INSERT INTO apz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ou, hungkuno nomꞌne upaꞌnɨmno. Hwe fihwo kako aꞌamu yofe engo ane paꞌnyoꞌnjo ngkimo nnɨngkawowoꞌnɨngkiso sohwo nonɨwoyo sosayo usontanɨngkuhwoso osohumo uhwonɨngkuhwosi Jisasɨye aꞌamumo ufoꞌmaꞌmo loso sohwo pompenjiyo mijo noswanyo soponjoso uyoso sohwo kako wopɨngo nomane hweho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas kakoe inomokomoyo aho hopiꞌnonohino sɨfe mtaꞌni hufaꞌu sohwamo hungkuno moiꞌwo ulonto kako oso ango hopo sopo ulɨkoꞌmanto nowento antɨme piꞌnɨngo mofone hopo soponjo hwe moyaꞌmimo lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Joun impoꞌangomo nohumanto yoꞌmayo Jisas imentiso soꞌno nupaꞌnonto Joun kako kakoe inomokomoyo sohwamo Jisasɨyepono lɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Luhwojahonɨngki hofɨko Jisasɨmo ulɨmentohofi, Joun ole nalɨmaho, Hwe tɨfi wapmmontonoho hoꞌnɨmentiso sohwosilaho. I, nakwo nomꞌnihuneꞌno wohontohumantantaho. ");
INSERT INTO apz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo nukuji yoꞌmayo uhwonɨngkohofo soꞌnji nupaꞌnɨngkohofo soꞌntnno Jounɨmo ulɨmno. ");
INSERT INTO apz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Uhwonɨmno. Aꞌamu tɨmpiꞌnyoso tɨmo apaꞌno honalokwofo. Aꞌamu sɨfe wonyoꞌnjoso apaꞌno hano itoꞌno walokwofo. Aꞌamu aꞌapaho uyo nɨhuꞌno wonyoꞌnjoso (lepɨla) hofɨkoe aꞌapahoso wopɨngo imoꞌnɨngkohoho. Aꞌamu haloho pɨkuꞌnnyoso apaꞌno itoꞌno haloho upoꞌnalokwofo. Aꞌamu poyo peꞌnyoso apaꞌno songo lɨkofalokwofo. Aꞌamu yoꞌmayo soꞌno umofonyo iyoso Anɨtuye hungkuno wopɨngo upoꞌnalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aꞌamu ngkineꞌno hwahopontaꞌango hwolɨkeno Anɨtuye hwolɨkeno, ose mosyafɨsiyoꞌnjo yontɨfi hofɨko sɨmeho hiꞌntnnono kengaꞌno ntopantokwofoso hofɨko sɨmonyo uyɨfe. Sekwo nukuji oso hungkuno hiso Jounɨmo ulɨmno. ");
INSERT INTO apz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ose ulahonɨngki Jounɨmo inomokomoyo sohwa nuhwahonɨngkofi Jisas hwe moyaꞌmi somo Joun neꞌno hungkuno ole ulɨmento, Hohonta sekwo hwaho aꞌamu anepono hano umentohofo sohonta sekwo pehomo uhwonano lontɨfi umentohofoto. Sekwo hwe mohufiyo paꞌnɨngo sohwo ifofo ilojaoꞌmentiso sohumo uhwonano lontɨfi umentohofotaho. Oꞌo, oseꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Sekwo pehomo uhwonano lontɨfi umentohofo. Sekwo hwe fihwo hwapɨfe yoꞌmayo wonyoangafo huꞌmeesisyoso uhwonano lontɨfi umentohofotaho. Oꞌo, aꞌamu hofɨko hwapɨfe wopɨngo wopɨngoꞌnohini yalokwofoso hwe engo sohwoe angomo humalofo. ");
INSERT INTO apz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Oseso sekwo pehoꞌno umentohofo. Aꞌamumo Anɨtu hungkuno uyahonɨngki hungkuno najo sohumo uhwonano lontɨfi imentohofotaho. Ou, osohifoho. Upaꞌnɨmno. Oso hwe sekwo uhwonɨmentohofo sohwo kako aꞌamu hopiꞌnonohinomo Anɨtu hungkuno uyahonɨngki nalɨwoꞌnɨngkohofo somo yakoloꞌnnyo hweho. ");
INSERT INTO apz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Oso hwe huhwo sohumneꞌno Anɨtuye hungkuno Kakoe Hwomumo ole nalohi, Upaꞌnyo. Ngko hwe fihumo nje hungkuno motaweꞌne wolɨhwatɨmonnoho. Oso huhwo sohwo kako kikimo sɨmoꞌmo kupe-eꞌne hweho. Kako jɨje honɨngkano itoꞌno esyohumayoꞌne hweho. Ose nalohoho. ");
INSERT INTO apz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngko nehopi selohono. Joun aꞌamumo mijo kiyomaꞌmojo sohwo kako olo hwaho loponjo imoꞌnɨmentohofo somo yakolonoho. I oso hisoꞌno aꞌamu yofe ane paꞌnyoꞌnjo Anɨtu aꞌamumo yokumpohnꞌnyo mokosyohumayo sopo humaso sohwo kako Jounɨmo nuyakolofonefoho. ");
INSERT INTO apz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwoe sɨkuno syoho emaꞌmentiso sohonta oso mtaꞌango olohontajoꞌnji aꞌamu ahwomomo Anɨtu mokosyohumayo sopo wohotoswano lontɨfi yohoto yohotofo yalokwofo. Aꞌamu yokumpohnꞌnyo ikujohoꞌnjoso oso hisoꞌno womano lalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo hopiꞌnonohino sohwanji Mouses kakoe honɨngkano hungkunoꞌnji Anɨtu ahwomomo mokosyohumayo sopone soꞌno neꞌno lɨmɨwahonɨngkofi Joun imoꞌnonto oso hungkuno hiso neꞌno lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Hohonta aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo sohwa ole ulɨmentohofi, Hwe Ilaija paꞌnyo sohwo asomo noponefoho. Oso hungkuno somo sɨmeho wopɨngo semoꞌnosoꞌmanji ole upaꞌnɨmno. Joun sohwo kako Ilaija paꞌnyo hweho. ");
INSERT INTO apz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aꞌamu halohoꞌnjo hwoꞌmanji upaꞌnono. ");
INSERT INTO apz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Aꞌamu olohonta humalofoso peho paꞌnyo lɨmnehono. Hofɨko mehomi paꞌnyofoho. Kako ose ulonto pahnnɨmo hungkuno Jounꞌnji kakineꞌntnno ulɨmentisofoho. Ole ulɨmento, Mehomiso hofɨko angopo nohumantɨfi nomꞌne mehomi syohiꞌnyo hutonɨwoꞌnɨngkohofo sohwanjineꞌno joho lalokwofo, ");
INSERT INTO apz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nakwo hmpehmpe yoka sɨmonyoꞌne kulɨmokahonɨngkuhwoni sekwo sɨmonyo miyo kuyoho. Nakwo wosafe lahonɨngkuhwoni sekwo humotaho majofoho. ");
INSERT INTO apz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Joun noponto wosopayo manyoꞌnjo humaho humanto ipisayo mijo (wain) manyo hweho. Oseso hofɨko sitofo lɨmentohofi, Towahuno wonyo Jounɨmo ehuhnnamoꞌnnyo hweho. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Oseso Aꞌamufe Hwomu hwoꞌni noponji ahuꞌmo wosopayoꞌnji ipisayo mijo pompenjiyo soꞌnji nɨwoꞌnɨngkohe soꞌno hofɨko ngkineꞌno ole lalokwofo. Ihwoni. Hwe wopayo piꞌnɨngo engo nyoꞌnjo hweho. Ipisayo mijo pompenjiyo piꞌnɨngo engo nyoꞌnjo hweho. Kako aꞌamu hamniyoho mayo syohoꞌnjo sohwanji aꞌamu honɨngkano wonyoꞌnjo soꞌnjiye aꞌamu hweho. Ose ngkineꞌno lɨwoꞌnɨngkohofɨhwashoho. I oso hisoꞌno Anɨtuye hunoso neꞌnjofoho. Aꞌamu Anɨtuye yahinomo inɨngkawoꞌnɨngkohofoso huno ole uyonefoho. Yoꞌmayo Anɨtu iwoꞌnɨngkisoso itoꞌnohinoho. ");
INSERT INTO apz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ango hopiꞌnonohino somo Jisas yoꞌmayo kengo wonyoangkafoso aꞌamu miyɨwoꞌnɨngkiyohofoso imentisoso aꞌamu sɨmeho mɨwoloꞌmokiyoꞌnjo somneꞌno Jisas yoka ulɨmentisofoho. Hwapɨngoso hofɨkoe honɨngkano wonyo somneꞌno hohujo mikinjaofeꞌnjofoho. ");
INSERT INTO apz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Jisas ole ulɨmento, U, aꞌamu Koulasin sokunonji aꞌamu Mpetɨsaita sokunonji sekwo Anɨtuye tohino somneꞌno iꞌwaho itoꞌno fiyɨmno. Ngko sekwoe angopo yoꞌmayo wonyoangkafoso aꞌamu miyɨwoꞌnɨngkiyohofoso esetɨhwamentohe somo aꞌamu ango Taiyaꞌnji ango Saitounꞌnji hohonta humamotofoso hofɨko hofɨkoe yahino wonyo somneꞌno hulɨngkwajingo aꞌapahopo lohoꞌnɨngkuji hofɨkoe honɨngkano wonyo somo hohujo nto ikinjaofɨkutnnesohilo. I sekwo yoꞌmayo wopɨngo ngko imalesomo ko uhwonontɨfi sekwoe yahino wonyo somneꞌno hohujo mikinjaoꞌmmalofo kuyoho. ");
INSERT INTO apz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Osoꞌno ngko sekumo hungkuno selalokweno. Sɨkuno aeꞌuyo somo Anɨtu kako aꞌamufe honɨngkano wonyo somneꞌno yano ilofoso sohonta Taiyajo aꞌamu soꞌnji Saitounjo aꞌamu soꞌnji hofɨko Anɨtuye tohino engo tɨpemapitnnefoho. I osoꞌno sekwoe tohinoso yakoloꞌnnyo kuyoho. ");
INSERT INTO apz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","I, oso sɨkuno homo somo ango Koponeyamjo aꞌamu humawoꞌnɨngkohofo soku ngko sekumneꞌno pehofo selɨmnehono. Sekwo sekwoe yofe yokintahopo ko hoꞌnomaꞌnɨwoꞌnɨngkohofo soku, sekwo tɨkanomo ufitnne kuyoho. U, aꞌamu fihwo yoꞌmayo sekwoe angopo esetɨhwamale hopaso aꞌamu ango Soutom honɨngkano wonyoꞌnjo somo utɨhwantentesi hofɨkoe honɨngkano wonyo somo hohujo ikinjaofɨkuji hofɨkoe ango neꞌno nowentɨhwonesohilo. ");
INSERT INTO apz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","U, ngko sekumo waselɨmonneꞌno yohono. Sɨkuno aeꞌuyo somo aꞌamufe yahino wonyo soꞌne hungkuno ikwolofoꞌne sohonta oso ango Soutommjo aꞌamuso hofɨkoe yahino pisakinoꞌnjo somneꞌno tohino engo wotɨpemantɨfeho. I osoꞌno aꞌamu hohujo ikinjasemofoso hofɨkoe tohinoso Soutommjo aꞌamufe tohino somo yakoloꞌnnyofoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Oso hohosohonta Jisas ole ulɨmento, U, Mpohwo, kɨko ahwomomjo yoꞌmayo soꞌnji hwahoponjo yoꞌmayo soꞌnji hwapɨngo hwosoho. Ngko ole soꞌno isamoyoka kilalokweno. Yoꞌmayo iwoꞌnɨngkinoso kɨko aꞌamu hwahoponjo huno engo tɨpemaꞌmentohofo somtaꞌni hiyaso hoꞌnahumentohinofoho. I aꞌamu hofɨko mehomimneꞌno sɨmeho kanɨngkwohwoꞌyaꞌumo uyɨwoꞌnɨngkohofo hopa kijopontanɨngkofi kɨko ujo ehontojwahumahnnofoho. ");
INSERT INTO apz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ou, Mpohwo, kɨko ose imoꞌnoneꞌenji imentohinoso olohopeho. ");
INSERT INTO apz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ose ulonto kakoe inomokomoyo sohwamo ulɨmento, Nje Mpohwo kako yoꞌmayo hopiꞌnonohinoso nje ahomo hoꞌnanɨhumentisofoho. Olo hwaho loponjo aꞌamu fihwo kako nje hwapɨngo soponeꞌno huno inyoso tɨhwolo. Awonoho. Nje Mpohwo kakoꞌnohini huno uyohoho. U, Mpohwoe hwapɨngo soponeꞌno huno tɨhwolo. Oꞌo, ngko kakoe Hwomu hwoꞌnnohini huno niyohoho. U, ngko Mpohumo wasetɨhwamo ulɨwoꞌnɨngkohe aꞌamuso hofɨko hiꞌnji ngkoꞌntnnohini huno nayohoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Aꞌamu tango engoꞌnjo mokohoꞌnawentɨfi usijoꞌno wohumano lalokwofo soku sekwo ngkimo nɨꞌmapmno. Ngko usijoꞌno wosehumatɨꞌmo. ");
INSERT INTO apz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nje hungkunomo nnɨngkafijoso ngko wolosetɨhwahmꞌmo. Ngko aꞌamumo wopɨngo ulohofɨwoꞌnɨngkohe hwoꞌnyoho. Nje yofemo mohoꞌnomaꞌnɨwoꞌnɨngkiyohefoho. Oꞌo, ngko nje yofe monje yasyɨwoꞌnɨngkohefoho. Osoꞌno sekwo nje pompenjiyo soꞌno wotɨpemantɨfi yalokwofoso wonyo pompenjiyomo wohumantanoho. ");
INSERT INTO apz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Syoho sejapontnneso engoꞌmaho. Oꞌo, nosefoꞌmawoꞌnɨngkohe hwoꞌnyoho. Tango mokohoꞌnyo soꞌno sejapmmeso tango engoꞌnjoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nomꞌne sohonta sɨkuno iyoho humayo Salole somo Jisas kakoe inomokomoyo sohwanji syohoꞌmo emoyontɨfi inomokomoyo sohwa mijoho uyahonɨngki ipisayo mjanɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nomjonɨngkahonɨngkofi aꞌamu Falisi sohwa nuhwonontɨfi Jisasɨmo ulɨmentohofi, Ihwoni, jɨje inomokomoyo sohwa olo sɨkuno iyoho humayo lomo wopayo mjanɨngkohofo soꞌno nakwoe honɨngkano hungkunoso mtɨhupehofo. ");
INSERT INTO apz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo Ntefit imentiso soꞌno iyoswo mtɨꞌmokumentohofoso atofo majo hwasilaho. Oso sɨkuno kakoe aꞌamu soꞌnji mijoho engo humamentohofo sohontaꞌneꞌno selohonɨngkono. ");
INSERT INTO apz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ntefit kako Anɨtumneꞌno hwapɨfe ango molinyo somo swonto wosopayo Anɨtuneꞌno hoꞌnahumotofoso nɨmentohofofoho. Oso wosopayo hiso aꞌamu sikinjo somneꞌmaho. Oꞌo, aꞌamu Anɨtuye tajo ango syohoꞌnjo sohwamneꞌnohinofoho. I osoꞌno Ntefit kako nonto kakoe aꞌamu sohwamo nuyɨmentisofoho. Sekwo oso hungkuno homo somo atofo majoꞌnjo imentohofo soꞌno sekwo nje inomokomoyo sohwamo oso hungkuno hiso ulohonɨngkohofotaho. ");
INSERT INTO apz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nomꞌne honɨngkano hungkuno somjo soꞌno huno maseyoꞌnjotaho. Hungkuno ole, aꞌamu Anɨtuye tajo ango syohoꞌnjo sohwa hofɨkoe syoho somneꞌno sɨkuno iyoho humayo somo honɨngkano hungkuno somo mtɨhupewoꞌnɨngkohofoso wonyoꞌmaho. Oꞌo Anɨtuye syoho wopɨngofoho. Oso hungkuno soꞌno huno maseyoꞌnjotaho. ");
INSERT INTO apz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ose ulonto pahnnɨmo hungkuno kakineꞌno hnnɨmentisofoho. Nje hungkuno waselɨmonneꞌno yohono. Anɨtuye ango engo olo hwaho loponjo somo angaꞌnohinohwo yakolonoho. ");
INSERT INTO apz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Anɨtuye hungkunomo ole woꞌnnyoponoho. Sekwo nomꞌne somneꞌno hitoho ulofo soꞌno nɨmoꞌnɨngkohoho. Sekwo yahu iloho yontɨfeso ntapɨwoꞌnɨngkohofo soꞌno nomꞌne somneꞌno hitoho mulofeꞌnjoꞌmanji ngkilaho. Oso hungkuno neso huno itoꞌno seyontentesi aꞌamu wonyo miyɨwoꞌnɨngkiyohofo somo tango muyɨkutnnesohilo. ");
INSERT INTO apz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngko Aꞌamufe Hwomu sohwoꞌni sɨkuno iyoho humayoꞌne somo hwapɨngo hwoꞌnyoho. Osoꞌno ulɨmentisofo. ");
INSERT INTO apz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","10","Oso syoho hopo sopo Jisas nulɨkoꞌmanto tajo ango weꞌe somo hwe aho songo songo miyo poyo hopa woꞌnnyo sohwo humunyo sopo Jisas humentisofoho. Oso hopo sopo aꞌamu Jisasɨmo hungkuno itoꞌno mɨhwajiyo ango somo ipemotowaneꞌentɨfi ole ulɨmentohofi, Sɨkuno iyoho humayo somo aꞌamu mnokinoꞌnjo sohumo wopɨngo umokiyoso wopɨngotaho. ");
INSERT INTO apz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ose ulahonɨngkofi Jisas hofɨkimo ulɨmento, Sekwoe yahu sɨkuno iyoho humayo somo piꞌnɨmomo usɨꞌmofawesoso asomo womantɨfetaho. ");
INSERT INTO apz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ou, womantɨfeho. Oseso sɨkuno iyoho humayo somo yoꞌmayo wopɨngo ulohofoso itoꞌnohinoho. Osoꞌno sekwo yahu sohumo ufoꞌmapijo soꞌno aꞌamu mnokinoꞌnjo wopɨngo umokufitnneꞌelaho. Ou, ikono. Aꞌamufoho. ");
INSERT INTO apz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ose ulonto hwe aho wonyoꞌnjo sohumo ulɨmento, Jɨje ahoso sɨhwaho fɨsɨpofo. Ose ulahonɨngki aho sɨhwoho sɨpento aho wopɨngo imoꞌnonto nomꞌne aho fehohnjo paꞌnyo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aꞌamu Falisi sohwa nuhwonontɨfi ango homo somo nulɨkoꞌmantɨfi Jisasɨmo fonjosyaneꞌentɨfi hungkuno lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas kakimo fonjosiyoꞌne huno uyahonɨngki ango homo somo nulɨkoꞌmahonɨngki aꞌamu piꞌnɨngo engo Jisasɨmo inɨngkowahonɨngkofi Jisas aꞌamu mnokinoꞌnjo somo wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Wopɨngo umokonto ulɨmento, Olo hilo soꞌno aꞌamumo nulɨkutoho. ");
INSERT INTO apz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Osoꞌno hwe Aisaiya sohumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwoe hungkuno oso sɨkuno somo ne imoꞌnɨmentisofoho. Hungkuno hiloso ole mtɨꞌmokumento, ");
INSERT INTO apz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Olo hwe lohwo sohwo uhwosopoꞌmentoheso nje syoho ntohofiyo ne hweho. Ngko sɨmeho wopɨngo uyɨwoꞌnɨngkohe hweho. Nje sɨmeho kakineꞌno wopɨngo nɨmoꞌnɨwoꞌnɨngkisofoho. Nje Towahuno kakimo uyɨꞌmeꞌno kako aꞌamu temtitofo kengo somo honɨngkano itoꞌnohinoso uyonefoho. ");
INSERT INTO apz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kako yoka hungkuno mohmꞌno malonefoho. Kako honɨngkano engo somo hungkuno yokumpohnꞌnyo malonefoho. ");
INSERT INTO apz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aꞌamu yokumpohnꞌnyo ane somo hwotoho mafenefoho. Nje hungkuno aꞌamufe sɨmeho moꞌmo toho weꞌe sijalofonjo paꞌnyoꞌnjoso toho hiso masɨmpilofasyonefoho. Kako syoho mjɨmɨhwosi yahino wopɨngo neso uꞌmofapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nomꞌne aꞌamu temtitofo kengo kengoso kakimo sɨmeho hiꞌntnnono uyɨkuji kakineꞌno wohontohumantɨfeho. Oso hungkunoso Aisaiya mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hohosohonta aꞌamu hofɨko hwe nomꞌne towahuno wonyo ehuhnnamoꞌnnyo sohumo Jisasɨyepono ipemotapmmentohofofoho. Oso hwe huhwo sohwo hungkuno majoꞌnjo mampiꞌnyo hweho. Tɨmo tɨmpiꞌnyo hweho. Jisas kako wopɨngo umokahonɨngki hungkuno lonto tɨmo wopɨngo honɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Oso hisoꞌno aꞌamu nuhwonontɨfi yomo yomo yontɨfi hnnɨmentohofi, Olo hwe lohwo Ntefitɨye Imu hwolɨkeno, tɨhwolɨkeno. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","I osoꞌno aꞌamu Falisi sohwa nupaꞌnontɨfi lɨmentohofi, Mpelɨsepul towahuno hopiꞌnonohino somo mokosyohumayo sohwo kakoe yokumpohnꞌnyoso Jisasɨmo uyahonɨngki Jisas towahuno wonyo somo wae yaofalofoho. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aꞌamu Falisi sohwafe huno somo Jisas huno moiꞌwo uyahonɨngki ole ulɨmento, Hwaho fiponjo aꞌamu hopiꞌnonohino humawoꞌnɨngkohofoso hofɨko hotitopijo sohonta ikujoho fongkiꞌnɨngkuji hofɨkoe hwaho wopɨngo fosyohumayoꞌneso wonyo umoꞌnɨmontonoho. Ango fipo aꞌamuso husilo lohofɨkuji ikujoho fongkiꞌnɨfijoso oso angoso wonyo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sekwo ole ntohofo, Seten kakoe yokumpohnꞌnyo kijopahonɨngki towahuno wonyo somo wae yaofɨwoꞌningkino hwosoho. Ose ntohofo. I oseꞌmanji Seten kakoe towahuno wonyo somo wae yamoꞌnyontentesi kakoe yokumpohnꞌnyo pipi imoꞌnɨngkuhwonesohilo. ");
INSERT INTO apz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","I Seten kako towahuno wonyo wae yaofoꞌne ngkimo nɨfoꞌmantokusoꞌmanji sekwoe inomokomoyo towahuno wonyo wae yaofɨwoꞌnɨngkohofo somo tɨhwo ufoꞌmahwosoꞌno weeofantɨfeto. Oꞌo sekwoe inomokomoyo huhwa towahuno wonyo somo wae yaofalokwofo soꞌno nakwo huno ole nayohoho, Sekwo ngkineꞌno hwasyo hungkuno lalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","I oseso Anɨtuye Towahuno sohwo towahuno wonyo wae yaofo soꞌno ngkimo nɨfoꞌmasoꞌmanji oso sɨkuno Anɨtu wosemokosyohumamonto isoso nto seꞌmahonɨngki sekwo hisoꞌno hohujo ikinjaofalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Hwe fihwo hwe yokumpohnꞌnyo sohwoe angomo hufo umo lɨhwosi swososo sɨmoꞌmo oso hwe yokumpohnꞌnyo huhwo sohwi nano kilofasyɨhwosi i kako oso ango homo somjo kakoe yoꞌmayoso womaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Aꞌamu fihwo kako nje aꞌamu mmoꞌnyoꞌnjo yoso sohwo kako nje mango hweho. Aꞌamu nje syoho somneꞌno nɨfoꞌmaso sohwo kako homo somo fonɨfonyo imokalofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Oseso ngko sekumo waselɨmonneꞌno yohono. Yoꞌmayo honɨngkano wonyo soꞌnji sitofo soꞌnji Anɨtu kako wae yaofonefoho. I osoꞌno aꞌamu fihwo Anɨtuye Towahuno Wopɨngo sohumo sitofo uloso sohwo oso wonyoso Anɨtu wae meeofonefoho. ");
INSERT INTO apz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aꞌamu fihwo ngkineꞌno sitofo ntososo kako oso wonyo hisoꞌno Anɨtumo wae yaofoꞌne jomo ulososo Anɨtu kako wae weeoꞌmontonoho. I osoꞌno aꞌamu fihwo Anɨtuye Towahuno sohumneꞌno sitofo uloso sohwo oso wonyo hiso Anɨtu wae meeofonehoho. Oꞌo, wonyo hiso neꞌno wawoꞌmontonoho. Olohontajoꞌnji hwangkunjoꞌnji oseꞌnohinofoho. Yoꞌmayoso Anɨtuye Towahuno iwoꞌnɨngkiso soꞌno aꞌamu sitofo ole lososo Setenɨyefoho ose lososo oso wonyo hiso Anɨtu wae meeofonefoho. ");
INSERT INTO apz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ipisayo wonyoso iyo wonyo mtaꞌangofoho. Aꞌamu ipisayo wopɨngo somo uhwonɨfijosoꞌmanji huno ole umontonoho. Olo iyo wopɨngofoho. Aꞌamu ipisayo wonyo somo uhwonɨfijoso wolantɨfeho. Iyo wonyofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sekwo homa mehomi soku sekwo hungkuno wopɨngo pipi lɨfitnnehofo. Aꞌamufe hungkunoso yoꞌmayo sɨmeho moꞌmo mnawojo somtaꞌangofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hwe wopɨngo sohwo kakoe hunomo wopɨngoꞌnohino mnawojo soꞌno kakoe hungkunoso wopɨngoꞌnohino hweho. Hwe wonyo sohwo kakoe hunomo huno wonyo mnawojo soꞌno kakoe hungkunoso wonyoꞌnohino hweho. ");
INSERT INTO apz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Upaꞌnɨmno. Nje hungkuno waselɨmonneꞌno yohono. Hwangku sohonta sɨkuno hungkuno ikwolofoꞌne somo yoꞌmayo hungkuno sikinjo wonyo yoꞌmayo soꞌno Anɨtu selohononefoho. ");
INSERT INTO apz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Jɨje hungkuno wopɨngoꞌnohino somneꞌno Anɨtu hwe wopɨngo hwosoho kilonefoho. Hungkuno wopɨngo ane sohwosimo hwe wonyo hwosoho kilonefoho. ");
INSERT INTO apz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Oso hohosohonta aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji aꞌamu Falisi sohwanji Jisasɨmo ulɨmentohofi, Hwe Engofo, yoꞌmayo kengo wonyoangkafo aꞌamu miyɨwoꞌningkiyohofo somo uhwonano. Kɨko fonetɨhwaho. ");
INSERT INTO apz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ose ulahonɨngkofi Jisas ulɨmento, Aꞌamu olohonta humalofo soku, honɨngkano wonyo imofɨwoꞌnɨngkohofoso yoꞌmayo wonyoangkafoso netɨhwayoꞌne jomo lɨwoꞌnɨngkohofofoho. Osoꞌno mosetɨhwamnehono. Oꞌo, ngko yoꞌmayo hwe Jouna sohumo Anɨtu hungkuno uyahonɨngki lɨmojo sohumo iꞌmofapmmentiso osoꞌnohino wosetɨhwamonneꞌno yohono. ");
INSERT INTO apz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Hohonta Jouna inanɨku mɨkunɨmposo sohwoe sɨmehomo humentanɨngki sɨkuno hufaꞌu sɨhune memjaoꞌmentisofoho. Oso paꞌnyoso ngko Aꞌamufe Hwomu sohwoꞌni hwaho ajwomoꞌmo humentanɨꞌmo sɨkuno hufaꞌu sɨhune womemjanɨmoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Anɨtu kako aꞌamufe wonyo somjo tohinoso yano ilofiyoꞌne sɨkuno somo aꞌamu ango Ninifontaꞌangoso nolɨkafɨkuji sekwo olohonta humalofo sokumo ole selɨfitnnefoho. Sekwo sekwoe honɨngkano wonyo somneꞌno sɨmeho mɨwoloꞌmokiyoꞌnjo pehoꞌno imentohofokulo. Ose selɨfitnnefoho. Hwapɨngoso aꞌamu Ninifoso hofɨko oso hungkuno Jouna lɨjwaoꞌmentiso somo upaꞌnontɨfi hofɨkoe honɨngkano wonyo somneꞌno sɨmeho iwoloꞌmokumentohofofoho. I olo soꞌno olohonta hwe fihwo Jounamo yakoloꞌnnyo sohwo sekwoꞌnjo olopo ko humasoso sekwo sekwoe honɨngkano wonyomneꞌno sɨmeho mɨwoloꞌmokiyofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hwangku aꞌamufe yahino wonyo somneꞌno Anɨtu kako yano ilofoꞌne sɨkuno somo iꞌmofapɨhwosoꞌno oso aꞌmu yofe engo hwaho mokosyohumayoꞌnesi kako hwaho mongkihntaꞌni mokosyohumamojosi kako nolɨkafɨhwosi sekwo olohonta humalofo sokumo ole selonefoho. Sekwo Anɨtumo minɨngkayoso pehoꞌnekulo. Ose selonefoho. Hwapɨngoso hohonta hwe yofe engoꞌnjo Soulomoun humamojo sohonta oso aꞌmusi kako hwaho ikanopo mtaꞌangosi kako Soulomoun Anɨtuye hungkuno wolontɨhwano lonto kako sapmmentisofoho. I osoꞌno olohonta hwe nomꞌne Soulomounɨmo yakoloꞌnnyo sohwo sekwoꞌnji olopo ko humaso sohumo sekwo kakimo minɨngkowalokuyohofo. ");
INSERT INTO apz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Towahuno wonyo kako aꞌamufe sɨmeho moꞌmo humamojo sohumo oso ango somtaꞌni ulɨkoꞌmahwosi nomꞌne hwaho aꞌamu mohumunyopo usijoꞌno humayoꞌne hafɨhafe wonyopi tɨpehwosi ");
INSERT INTO apz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kakoe ango sɨmoꞌmjo somneꞌno asomo wapmmontonoho. Asomo nopɨhwosi aꞌamufe sɨmeho homo somo towahuno nomꞌne sohwo anepo uhwonɨngkuhwosi sɨmeho hiso kihoꞌmaso, hintalinyo yoꞌmayo wae nto yososo wopɨngomo uhwonɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ose uhwonɨngkuhwosi kako nuhwosi nomꞌne towahuno wonyo aho fehohnjo hopiꞌnono fehohnjo nomꞌne mtaꞌni hufaꞌuyoso hofɨko hofɨkoe wonyoso sɨmoꞌmjo sohwoe yakoloꞌnnyo somo kako utɨmahwosi kakoe ango homo somo humayoꞌne upemotawomontonoho. Oseso oso hwe huhwo sohwo sɨmoꞌmo kakoe wonyo humamojo sohwo kako olohonta wonyo mɨkunɨmposo somo humaho. Oso paꞌnyo aꞌamu olohonta honɨngkano wonyomo humawoꞌnɨngkohofo somo uꞌmofapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas aꞌamu somo hungkuno ulontanɨngki Jisasɨye konaꞌwohiꞌnji hamnɨngkwaꞌwehwosanji iꞌmofapontɨfi yolohoꞌmo lohofapontɨfi Jisasɨꞌnji hungkuno wolantaneꞌyɨhwono ulɨmentohofofoho.  ");
INSERT INTO apz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ose ulahonɨngkofi hwe fihwo Jisasɨmo ulɨmento, Hnnaꞌwohiꞌnji hnnɨngkwaꞌwehwosanji hofɨko yolohoꞌmo lohofontɨfi kɨkoꞌnji hungkuno wolantɨfeꞌno yalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ose ulahonɨngki Jisas ulɨmento, Nje naꞌu tɨhwolo. Nje nɨngkwahwosa tɨhwalo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jisas ose ulonto kakoe inomokomoyo sohwamo aho upiyofonto ulɨmento, Uhwonɨmno. Olo nje naꞌuja, nje nɨngkwahwosa, olohohwa humalofo. ");
INSERT INTO apz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aꞌamu nje Mpohwo ahwomomo humaso sohwoe hungkunomo tɨfi inɨngkawoꞌnɨngkohofoso nje nɨngkwahwosanji, nje nampohwosanji, naꞌujanjoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Oso hohosohonta Jisas angomo nulɨkoꞌmanto mempo hohntaꞌni humentisofoho. Noswonto kako ayo momɨngo sopo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Osopo nohumentanɨngki aꞌamu piꞌnɨngo engo uhuꞌmakohonɨngkofi uhwononto Jisas yofayokinopo kotasonto osopo humamentisoso hwe moyaꞌmiso ayo momɨngo sopo lohoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Oseso Jisas pahnnɨmo hungkuno piꞌnɨngoso aꞌamu somo ulɨmentisofoho. Ole ulɨmento, Hwe fihwo kakoe syohopo ufongoyo fisosomokaoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Fisosomokofahonɨngki ufongoyo fehohnjoso honɨngkanopo pɨwesyahonɨngki yɨhufo sohwa nopontɨfi manɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","U, ufongoyo fehohnjoso hwaho sojoꞌnjo sopo pɨwahuꞌmentisofoho. Oso hwaho hiso engo moꞌmjoꞌmaho. Osoꞌno oso ufongoeso komoꞌno fokaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Oseso mofehiꞌnyo ulonto ufongoyo pmpongo hwahomoꞌmo munjilofeꞌnjo yonto yofoho imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","U, ufongoyo fehohnjoso nantɨpe yongoꞌnjo sopo pɨwesyahonɨngki nantɨpe yongoꞌnjoso komoꞌno fokofɨkwato lohofonto ufongoyo nontɨmo kingkuloꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","U, ufongoyo fehohnjo hwaho afofoꞌnjopo pɨwahuꞌmentisoso ne wopɨngo intoꞌnɨmentisofoho. Ipisayo fehohnjoso piꞌnɨngo engo (wan hantɨlet, 100), ipisayo nomꞌneso engo weꞌe (sikɨsɨti, 60), nomꞌne weꞌeꞌnohino (teti, 30), ose intoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jisas ose ulonto ulɨmento, Aꞌamu halohoꞌnjo hwoꞌmanji haloho upaꞌnono. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Oseso Jisasɨye inomokomoyo sohwa Jisasɨmo uꞌmantɨfi ulɨmentohofi, Yoloho mujoso pahnnɨmo hungkunoꞌnohini pehoꞌno ulalokuno. ");
INSERT INTO apz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ose ulahonɨngkofi Jisas ulɨmento, Anɨtu kako yoꞌmayo ahwomomjo soꞌno hiyaso woꞌmojoso sekwo sohwasimo nto setɨhwamentisofoho. I olo aꞌamu lomneꞌno Anɨtu huno muyoꞌnjo uyono ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","U, hwe fihwo ngkineꞌno huno engo syafɨsyoso sohumo ngko huno nomꞌne wopɨngo piꞌnɨngo engo uyɨmnefoho. I hwe nomꞌne sohwo ngkineꞌno huno mosyafɨsiyoꞌnjo sohumo ngko huno nomꞌne wopɨngoso muyɨmnefoho. ");
INSERT INTO apz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Osoꞌno pahnnɨmo hungkunoꞌnohini ulalokweno. Hofɨko yoꞌmayo somo uhwonontɨfeso hwapɨngoso yofe mɨhwofeꞌnjo iwoꞌnɨngkohofofoho. Yoꞌmayo soꞌno upaꞌnontɨfeso neso huno muyofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Hwe Aisaiya sohumo Anɨtu hungkuno uyahonɨngki lutɨhwamojo sohwo kako olo hungkunolo aꞌamu lomneꞌno mtɨꞌmokumentisoso ne imoꞌnalofoho. Kako ole mtɨꞌmokumento, U, sekwo haloho upaꞌnɨfijoso sekwo oso hwapɨngo hiso huno maseyonehoho. U, sekwo yoꞌmayo somo uhwonɨfijo kohi sekwo yofeso mɨhwopitnnehofo. ");
INSERT INTO apz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Oso aꞌamu hiso hofɨko huno anefoho. Hofɨkoe haloho pɨjwomokosyohumunɨmentohofofoho. Hofɨko tɨmo pijiyoꞌnnyofoho. Ose miyoꞌnjo yontɨfijontentesi itoꞌno nuhwonɨngkutnnesohilo. Hofɨko haloho mopɨjwomokosyohumunyoꞌnjo yontɨfijontentesi nupaꞌnɨngkutnnesohilo. Oseso hofɨkoe huno itoꞌno uyɨhwonesohilo. Hofɨko ikinjaofɨkuji ngkiyepono pontɨfijontentesi ngko wopɨngo umokuꞌmnesohilo. Aisaiya ose mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","I sekwo soku, sekwo sɨmonyo fiyɨmno. Sekwoe tɨmoso yoꞌmayomo yofe uhwofɨwoꞌnɨngkohofofoho. Sekwoe halohoso sefojɨwoꞌnɨngkisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngko nehopi waselɨmonneꞌno yohono. Hohonta aꞌamu Anɨtuye hungkuno lutɨhwamotofo sohwanji aꞌamu nomꞌne honɨngkano wopɨngoꞌnohini sohwanji yoꞌmayo sekwo uhwonɨwoꞌnɨngkohofo somo uhwonano lontɨfi yontɨfeso muhwonɨmmentohofofoho. Yoꞌmayo sekwo upaꞌnɨwoꞌnɨngkohofo soꞌno upoꞌnano lontɨfi yontifeso mupaꞌnɨmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Sekwo pahnnɨmo hungkuno fisosomokaoꞌmentiso soꞌno hwapɨngoso upaꞌnɨmno. ");
INSERT INTO apz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aꞌamuso Anɨtu aꞌamumo mokosyohumayo soꞌno upaꞌnontɨfi huno muyoso hofɨko ufongoyo honɨngkanopo pɨwasyonte paꞌnyofoho. Hwe wonyo Seten noponto aꞌamufe hunomjo Anɨtu hoꞌnasyonteso wae yaofɨwoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ufongoyo hwaho sojo sopo pɨwasyonteso oso paꞌnyoso aꞌamu kako hungkunomo upaꞌnonto kako komoꞌno sɨmeho moꞌmo mehoꞌnasyonto sɨmonyo iwoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","I osoꞌno kakoe pmpongo anefoho. Oꞌo, kako weꞌenepi nolohofontanɨngki aꞌamu nomꞌneso Anɨtuye hungkunomo hwotoho wahmmo lososo oso aꞌamu nolohofontanjo huhwo sohumo tango engo uyahonɨngki kakoe pmpongo ane soꞌno pɨwasyɨwoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","U, fehohnjo nantɨpe yongoꞌnjo sopo pɨwahiꞌnyoso ole, aꞌamu Anɨtuye hungkunomo upaꞌnonteso i, yoꞌmayo hwahoponjo somneꞌno huno syafɨsyonto hamniyoho engo womaꞌmo lonto yahonɨngki oso hiso Anɨtuye hungkunomo kingkulofɨwoꞌnɨngkohoho. Oso huhwo sohwo ne ane hweho. ");
INSERT INTO apz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ufongoyo hwaho wopɨngo sopo pɨwahiꞌnyoso oso aꞌamu haloho pento huno itoꞌno unyosofoho. Oso huhwo sohwo ne intoꞌnɨwoꞌnɨngkohoho. Ne hiso ole, fiso piꞌnɨngo engo (wan hantɨlet, 100), fiso engo weꞌe (sikɨsɨti, 60), fiso weꞌeꞌnohino (teti, 30). Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas pahnnɨmo hungkuno nomꞌne ulɨmento, Anɨtu aꞌamumo mokosyohumayoso olo paꞌnyofoho. Aꞌamu fihwo kako uyo wopɨngoso syohopo hoꞌnaofɨwoꞌnɨngkisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Oso hwe huhwo sohwo kakoe aꞌamuꞌnji saho fosyowentanɨngkofi kakoe mango sohwo noponto hoja wonyo yongoꞌnjoso uyo wopɨngoꞌnjo sopo hoꞌnasyonto womentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Osoꞌno uyo wopɨngoso ne untoꞌnɨmo lonto yahonɨngki aꞌamuso uhwonɨmentohofoso hoja wonyo yongoꞌnjo nolohofontanɨngki uhwonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Uhwonontɨfi syoho ulohofiyoso syoho kakwoepono nowentɨfi ulɨmentohofi, Hwe engofo, kɨko uyo wopɨngoso jɨje syohopo fisosomokaoꞌmentohinofoho. I olo hoja wonyo yongoꞌnjo loso ntɨꞌmtaꞌangoto. Pipi yonto fokofalofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ose ulahonɨngkofi ulɨmento, Mango fihwo olo hiloso imentisofoho. Ose ulahonɨngki syoho ulohofiyo sohwa ulɨmentohofi, Oso hoja wonyoso nakwo wae yaofoꞌne lakumoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ose ulohonɨngkahonɨngkofi ulɨmento, Awonoho. Sekwo hoja wonyoso wae yaopɨfijoso uyo wopɨngo soꞌnji sokapitnnoho. ");
INSERT INTO apz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Oꞌo, waweno. Uyo wopɨngo soꞌnji hoja wonyo soꞌnji wofokafiyo. Hwangku ne mayo sohonta ngko aꞌamu syoho hiloꞌnjo somo ulɨmo. Sekwo hoja wonyo kakiꞌno mɨhwofɨkupmno. Oso fosyo engoso toho nyoꞌnefoho. I, uyo wopɨngo neso nje angomo mehuꞌmeehumno. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Ose ulonto pahnnɨmo hungkuno nomꞌne ulɨmento, Anɨtu aꞌamumo mokosyohumayoso olo paꞌnyofoho. Iyo fiso kakoe yofe masɨtet. Kakoe neso nomꞌne iyo ipisayo paꞌnyoꞌmaho. Oꞌo, nɨhuꞌno weꞌefoho. Hwe fihwo oso weꞌe hiso kakoe syohopo hulahonɨngki engo imoꞌnonto nomꞌne iyo syoho soponjo somo yakolonoho. Engo imoꞌnɨngkahonɨngki yɨhufoso nopontɨfi kakoe pamo sopo hofɨkoe aifo syontɨfi osopo kehumawoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ose ulonto Jisas pahnnɨmo hungkuno nomꞌne ulɨmento, Anɨtu aꞌamumo mokosyohumayoso oso yis paꞌnyofoho. U, aꞌmu fisi kako wosopayo polowaꞌnji oso wosopayo polowa homo somo engo imokiyoꞌne hwamno paꞌnyo kakoe yofe yis, osoꞌnji iwoloꞌmokososo oso polowa hiso engo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas yoꞌmayo yoꞌmayo soꞌno pahnnɨmo hungkunoꞌnohini aꞌamu piꞌnɨngo engo somo ulɨmentisofoho. Kako yolohoꞌnji ulɨmentisoꞌmaho. Oꞌo, kako pahnnɨmo hungkunoꞌnohino ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Hwapɨngoso ole, hwe fihumo Anɨtu hungkuno uyahonɨngki lutɨhwamojo sohwo hohonta hungkuno mtɨꞌmokumentisoso oso hohosohonta ne imoꞌnɨmentisofoho. Hungkuno ole, Ngko aꞌamu somo hungkuno ulɨmo lɨꞌmo pahnnɨmo hungkuno ulɨmo. Yoꞌmayo hwaho songo imoꞌnɨmentiso mtaꞌango hiyaso mokosyohumayo soꞌno ngko wolɨjwaoꞌmneꞌno yohono. Ose mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Oseso Jisas aꞌamu piꞌnɨngo engo somo nulɨkoꞌmanto angomno humentisofoho. Kakoe inomokomoyo sohwa kakimo nuꞌmantɨfi ulɨmentohofi, Oso pahnnɨmo hungkuno hoja yongoꞌnjo syohoponjo soꞌno yolohoso fonaso. ");
INSERT INTO apz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ose ulahonɨngkofi Jisas ulɨmento, Hwe kako uyo wopɨngo fisosomokaofo sohwo Aꞌamufe Hwomu hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Syohoso oso olo hwaho humalohwone loponoho. Uyo wopɨngoso oso hwe moyaꞌmiso Anɨtuye aꞌamu nefoho. Oso hoja wonyo yongoꞌnjo paꞌnyoso Setenɨye aꞌamufoho. ");
INSERT INTO apz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Oso hwe wonyo mango sohwo hoja wonyo uyo mofɨwoꞌnɨngkiso sohwo Setenɨyoho. Sɨkuno wosopayo mayo sohonta olo hwaho loponjo sɨkuno moiꞌwo imoꞌnoso sohonta oso aꞌamu syoho ulohofiyo sohwa aꞌamu ahwomomjofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","U, hofɨko hoja wonyoso nomɨhwofɨjɨkuji tohomo hoꞌnayopitnnefoho. Oso paꞌnyoso hwangku sɨkuno moiꞌwo imoꞌnoso sohonta imoꞌnonefoho. ");
INSERT INTO apz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ou, Aꞌamufe Hwomu sohwoꞌni nje ahwomomjo aꞌamu syoho ulohofiyo somo uhwojahonɨꞌmo hofɨko olo hwaho loponjo aꞌamu nomꞌne somo wonyo imokuwoꞌnɨngkohofo soꞌnji aꞌamu honɨngkano wonyoꞌnjo somo nomɨhuꞌmokukuji ");
INSERT INTO apz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","toho engo nontɨmo nohoꞌnaopitnnefoho. Aꞌamu wonyoso tohomo nohumafɨkuji tohino engo umnɨngkuhwosoꞌno humotaho engo lɨkuji hofɨkoe mango toho loꞌnɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Oso hohosohonta Anɨtuye aꞌamuso hofɨko Anɨtuꞌnjopo nohumafɨkuji mofehiꞌnyo liso hopa imoꞌnɨfitnnefoho. Jisas ose ulonto ulɨmento, Aꞌamu halohoꞌnjo hwoꞌmanji kako upaꞌnono. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Anɨtu aꞌamumo mokosyohumayoso olo paꞌnyofoho. Hwe fihwo nomꞌne sohwoe hwahopo nohumanto hamniyoho ipofo yoꞌmayo wonyoangkafo hiꞌnjoso ijopijisyahumentohofoso uhwononto sɨmonyo yonto apaꞌno hiyaso ekojɨsyahumentisofoho. Ekojisyasyonto kakoe hoꞌyango hwaho yoꞌmayoso nomꞌne somo uyahonɨngki oso hisoꞌno hamniyoho uyahonɨngkofi kako hamniyoho hisoꞌnji oso hwaho hamniyoho ipofoꞌnjo sopono mpe imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Hungkuno nomꞌne ole, Anɨtu aꞌamumo mokosyohumayoso olo paꞌnyofoho. Hwe fihwo kako nɨkuyoho wopɨngoꞌne syoho imojo hweho. Kako nɨkuyoho wonyoangkafoꞌnohinoso wotɨpemaꞌmo lonto imojo hweho. ");
INSERT INTO apz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Oso hwe huhwo sohwo nɨkuyoho nomꞌne somo hwofiloꞌnnyo sohumo uhwononto mpe uyɨmo lɨmentisofoho. Oseso kakoe hoꞌyango yoꞌmayoso nomꞌne somo uyonto oso homo somtaꞌni hamniyoho nomanto nɨkuyoho hwofiloꞌnnyo somo mpoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Hungkuno nomꞌne ole, Anɨtu aꞌamumo mokosyohumayoso olo paꞌnyofoho. Aꞌamu inanɨku hoꞌyo mijo ayomo motaswontɨfeso yoꞌmayo yoꞌmayo inanɨku pasyɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hoꞌyo mangonepo yonto aꞌamuso hofɨko hojiyopono ifohusɨmpemotawentɨfi osopo nohumantɨfi hojiyopo ifaofontɨfi inanɨku wopɨngoso ikuꞌyopo nomehoꞌnasyontɨfi inanɨku wonyoso nɨhuꞌnahone wae yaofɨwoꞌnɨngkohofofoho. Ose ulonto ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Olo hwaho moiꞌwo imoꞌnoso sohonta oso hopa ifitnnefoho. Aꞌamu ahwomomjoso nopɨkuji aꞌamu wonyoso aꞌamu wopɨngoꞌnjo lopo humalofo osomo wae yaopitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Hofɨko nomafɨkuji tohomo hoꞌnayopitnnefoho. Oso aꞌamu wonyoso tohomo nohumafɨkuji humotaho engo lɨkuji tohino engo umnɨngkuhwosoꞌno hofɨkoe mango toho loꞌnefitnnefoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Oso hungkuno moiꞌwo lonto inomokomoyo sohwamo ulohonɨmento, Yoꞌmayo hungkuno seloheso hwapɨngoso huno itoꞌno laseyohoho. Ose ulahonɨngki ulɨmentohofi, Eno. Huno nayohoho. ");
INSERT INTO apz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ose ulahonɨngkofi ulɨmento, Huno itoꞌno seisosoꞌno aꞌamu honɨngkano hungkuno lutɨhwawoꞌnɨngkiso sohwo kako nje inomokomoyo imoꞌnosoꞌmanji oso hwe huhwo sohwo ango engo kakwoꞌyohwo paꞌnyo hweho. Kako kakoe hoꞌyango ango mtaꞌni yoꞌmayo songoꞌnji yofohoꞌnji womotoswapmmontonoho. Honɨngkano hungkuno wopɨngo soꞌnji nje hungkuno songo soꞌnji huno uyohoho. ");
INSERT INTO apz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas oso pahnnɨmo hungkunoso moiꞌwo ulonto kako oso ango sopo ulɨkoꞌmaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nulɨkoꞌmanto kako kakoe ango hwapɨngopono umentisofoho. Osopo nowento hofɨkoe tajo angomo Anɨtuye hungkuno lutɨhwahonɨngki aꞌamuso nupaꞌnontɨfi yomo yontɨfi lɨmentohofi, Kakoe huno hwapɨngoꞌnjo loso kakoe yokumpohnꞌnyo yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofo umokiyoꞌne loso ntɨꞌmtaꞌni maꞌmasoto. ");
INSERT INTO apz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","U, olo hwe lohwo sohwo kako ango molɨmojo sohwoe hwomuhwolaho. Kakoe konaꞌwohisi Maliyataho. Ou, Jemɨs, Jousep, Saimoun, Jutas oso homnɨngkwaꞌwehwo sohwaloho. ");
INSERT INTO apz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ou, kakoe nampohwosa nakwoꞌnji humalofo. I oso yoꞌmayo hopiꞌnonohino loso ntɨꞌmtaꞌni maꞌmasoto. ");
INSERT INTO apz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hofɨko ose lontɨfi kakineꞌno sɨmeho wonyo umoꞌnɨmentisofoho. I osoꞌno Jisas ulɨmento, Aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwo ango kengo hopiꞌnonohinopo kakoe yofe engo hoꞌnomawoꞌnɨngkohofofoho. I kakoe ango neso yofe ane hweho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Oseso Jisas oso ango hopo sopo aꞌamumneꞌno yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso piꞌnɨngo imentisoꞌmaho. Oꞌo, hwapɨngoso hofɨko sɨmeho hiꞌntnnono muyoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hohosohonta hwe yofe engoꞌnjo hwaho mokosyohumayo Helout osohwo yoꞌmayo Jisas imentiso soꞌno upaꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nupaꞌnonto kakoe syoho ulohofiyo sohwamo ulɨmento, Olo hwe lohwo sohwo Joun Aꞌamumo Mijo Kiyomaꞌmojo hweho. Kako poyo imoꞌnɨmentiso sohwo apaꞌno songo lɨkaꞌmentisofoho. Osoꞌno yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso kako iwoꞌnɨngkiso soꞌne yokumpohnꞌnyo iꞌmofapmmentisofoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Helout kako oso hunoso pehoꞌno syafɨhuꞌmentisoto. Hwapɨngoso Helout kako Jounɨmo impoꞌangomo muhumajonto ahwomo nano kilofahumentisofoho. Helout Jounɨmo impoꞌangomo pehoꞌne muhumatɨꞌmentisoto. Hwapɨngoso kolaꞌwehwoe Filipɨye ape Heloutiyasɨmneꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Hohonta Joun Heloutɨmo ulɨmento, Kɨko olo ape mahino loso hopoꞌmaho. Oꞌo, oso honɨngkano pisakinoꞌnjofoho. Ose ulɨwoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ose ulahonɨngki Helout Jounɨmo wofonjahumo lonto yonteso kako aꞌamumneꞌno iyoho unɨmojo hweho. Hwapɨngoso aꞌamuso Jounɨmneꞌno ole syafɨhuꞌmentohofi, Joun sohumo Anɨtu hungkuno uyahonɨngki lutɨhwamojo hweho. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sɨkuno nomꞌnehwi Helout konaꞌwohi aswo maꞌmentiso sɨkuno somneꞌno huno syafɨsiyoꞌne aꞌamu piꞌnɨngo engo soꞌnji Heloutɨꞌnji uhuꞌmokahonɨngkofi Heloutiyasɨye mu kako aꞌamu somneꞌno sɨmonyo yahonɨngki Helout sɨmeho wopɨngo umoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sɨmeho wopɨngo umoꞌnyo soꞌno kako aꞌmu simo ulɨmento, Yokintahoponeꞌno wakilɨmo. Ou, kɨko ngkimo yoꞌmayo soꞌno ntisoso wokijapmmonnoho. ");
INSERT INTO apz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ose ulahonɨngki aꞌmu simo konaꞌwohi huno uyɨmentisoso aꞌmu hisi Heloutɨmo ulɨmento, Kɨko Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwoe mnokino noswanopo yɨwojwosyalokumpehoji ntape. ");
INSERT INTO apz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ose ulahonɨngki Helout kakoe sɨmeho tango umentisofoho. I osoꞌno aꞌamu hopiꞌnonohino nje hungkuno yokintahopone soꞌno upaꞌnɨngkohofo soꞌno syafɨsyonto ulɨmento, Oso aꞌmusi nto lisofoho. Noho fiyɨmno. ");
INSERT INTO apz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ose ulahonɨngki aꞌamu syoho ulohofiyo sohwa impoꞌangomo noswontɨfi Jounɨye tɨꞌwango iwofitoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Oseso Jounɨye mnokinoso noswanopo iwojwosyalokumpentɨfi aꞌmu sijo simo nuyahonɨngkofi nomotawento konaꞌwohimo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Oseso Joun kakoe inomokomoyo sohwa kakoe pijafoso nomantɨfi ijopijisyasyontɨfi Jisasɨyepono nowentɨfi Joun neꞌno ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas kako Jounɨye hungkunoso upaꞌnonto oso ango hopo sopo nulɨkoꞌmanto yofayokino manto hwaho aꞌamu anepono kakoꞌnohino umentisofoho. Aꞌamuso Jisas osopo humaho upaꞌnontɨfi hofɨkoe ango sopo nulɨkoꞌmantɨfi Jisas womentiso somo hofɨko hwakano womentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas kakoe yofayokino ifohohosasyonto uhwonɨmentisoso hwe moyaꞌmi piꞌnɨngo engo somo uhwononto hitoho ulofahonɨngki hofɨkoe aꞌamu mnokinoꞌnjo somo wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Oso hohosohonta sɨkunoꞌnji kakoe inomokomoyo sohwa nopontɨfi ulɨmentohofi, Olo hwaho hopo lopo sopo aꞌamu aneponoho. Mofehiꞌnyo moiꞌwonoho. Kɨko olo hwe hwoyaꞌmi lomo fɨluhwajo. Hofɨko nukuji wosopayo mpe uyɨfe. ");
INSERT INTO apz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ose ulahonɨngkofi Jisas ulɨmento, Pehoꞌno ufitnnehofo. Sekwo huhwasi wosopayo uyɨmno. ");
INSERT INTO apz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ose ulahonɨngki ulɨmentohofi, Nakwo wopayo ane hwonaꞌnyoho. Oꞌo, wopayo aho fehohnjo hopiꞌnonohinoꞌnji inanɨku hufaꞌuꞌnji osoꞌnohino weho. ");
INSERT INTO apz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ose ulahonɨngkofi ulɨmento, Ngkiyepono wopayoso motapmno. ");
INSERT INTO apz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ose ulonto aꞌamu somo ulɨmento, Sekwo hoja lopo fosyohumamno. Ose ulonto oso wosopayo aho fehohnjo hopiꞌnohino soꞌnji inanɨku hufaꞌuꞌnji nomanto kako ahwomomo tɨmo uhwontohumanto Anɨtumo isamoyoka ulɨmentisofoho. Isamoyoka nto ulonto kako wopayo hiso kutɨkujo lohofonto kakoe inomokomoyo sohwamo nuyahonɨngki hofɨko aꞌamu somo uyɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aꞌamu hopiꞌnonohinoso wopayo hiso moiꞌwo nontɨfi sɨmeho uhnnɨngkahonɨngki hofɨko wosopayo nulɨfonaoꞌmentohofoso nuhuꞌmokontɨfi sohwo hoꞌyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌu mohuꞌmemeehumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Oso hwe oso wosopayo nɨmentohofo sohwa faif tausen (5000) hwafoho. Moyaꞌmi mehomiso atofo majofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas kakoe inomokomoyo sohwamo ulɨmento, Sekwo yofayokino nomafɨkuji oso hwaho nongkihntaꞌni sekwo sɨmoꞌmo mpanɨmno. Ose ulonto aꞌamu nomꞌne somo hofɨkoe ango poneꞌno luhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nolɨhwajonto ngkoꞌnohini humahmꞌmo Mpohumo jomo ulɨmo lonto hwofɨkiꞌnyo weꞌe sopono kotasɨmentisofoho. Sɨkunoꞌnji kakoꞌnohini hwofɨkiꞌnyo sopo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hohosohonta yofayokino mijo ajwo nompo nowahonɨngki ifofo yonto mijo engo ikwato lohofonto yofayokinomo ilokilojo mjolohoꞌmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Iyoho wolongkonɨmonto yahonjosoꞌnji Jisas mijo yokintahopo hano wento inomokomoyo sohwamo uꞌmaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nowentanɨngki inomokomoyo sohwa nuhwonontɨfi iyoho unɨngkahonɨngki lɨmentohofi, Mewosofoho. Ose lontɨfi iyoho yontɨfi youwo youwo lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Oseso Jisas hofɨkimo komoꞌno joho ulɨmento, Sekwo yokumpohnꞌnyo hmmoꞌnɨmno. Ngkonoho. Sekwo iyoho ikutoho. ");
INSERT INTO apz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ose ulahonɨngki Pita ulɨmento, Hwe Engofo, Kɨko Jisas kiꞌmanji ngkimo ole njo, Mijopo lɨkofaofohoji ngkiyepono fɨpe. Ose njo. ");
INSERT INTO apz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ose ulahonɨngki Jisas ulɨmento, Oyomo. Ose ulahonɨngki Pita yofayokinomo nulɨkoꞌmanto mijo yokintahopo Jisasɨmo uꞌmaꞌmo lonto umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nowento ifofo somo nuhwononto iyoho unɨngkahonɨngki kako mijo womihuloꞌmto imentisofoho. Osoꞌno Pita Jisasɨmo joho ulɨmento, Hwe Engofo, nɨfoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ose ulahonɨngki Jisas komoꞌno Pitamo aho umakonto ulɨmento, Pita, jɨje sɨmeho hiꞌntnnonohinoso weꞌeꞌnjo hwosoho. Kɨko ngko hopolɨkeno eso pehoꞌno hnnɨngkino. ");
INSERT INTO apz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ose ulonto siko yofayokinomo kotosahonɨngki ifofo moiꞌwo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Oseso aꞌamu yofayokinomo humohumantohofo sohwa nuhwonontɨfi hwomtame ulohofontɨfi ulɨmentohofi, Kɨko Anɨtuye Hwomu Ne hwosoho. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hofɨko mijopo nowakentɨfi Ngkenesalet nongkihntaꞌni ifohohosahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Oso aꞌamu hopo sopontaꞌangoso hofɨko yofe uhwofontɨfi lɨmentohofi, Jisasɨyoho. Ose lontɨfi ango hofɨkoꞌnjo mofone soponjo aꞌamu mnokinoꞌnjo somneꞌno joho ulɨmentohofoso hofɨko aꞌamu mnokinoꞌnjo somo kakiyepono itokwapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Itokwapontɨfi Jisasɨmo ulɨmentohofi, Hwe Engofo, nakwo jɨje manjiꞌmofomo aho wokupmꞌmokano. Ose ulontɨfi hofɨko kakoe manjiꞌmofomo aho upmꞌmokumentohofoso hofɨkoe mnokino moiꞌwo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Oso hohosohonta aꞌamu Falisi sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji hofɨko Jelusalem ulɨkoꞌmantɨfi hofɨko Jisasɨyepono pmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Nuꞌmantɨfi ulɨmentohofi, Jɨje inomokomoyo lohwa nakwoe neyakwosafe yahino somo minɨngkayoꞌnjo pehoꞌno yalokwofo. Hofɨko wosopayo wonantɨfeso hofɨko aho mijo itoꞌno miyatɨkuꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ose ulahonɨngkofi Jisas ulɨmento, I sekwo sekwoe yahinomnohini inɨngkayoꞌne Anɨtuye hungkunomo hwotoho pehoꞌno feelokwofo. ");
INSERT INTO apz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anɨtu ole lɨmento, Kɨko jɨje mpohwo naꞌumo tɨfi finɨngkayo. U, aꞌamu fihwo kako hungkuno wonyo kanɨngkwohwo konaꞌwohimo uloso osohwo kako poyo wapeꞌnono. Anɨtu ose lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","I sekwo ole lɨwoꞌnɨngkohofo, Hwe fihwo kako hamniyoho hiꞌnjo sohwo kanɨngkwohwo konaꞌwohimo ufoꞌmayo soꞌno, i kako sikimo ulɨmontonoho. Ngko hamniyoho yoꞌmayoso wosejapmmonji ko yoheso ngko ole nto lɨmalefoho. Ngko Anɨtumo uyɨmneꞌno yohono. Ose lososo kako kanɨngkwohwo yaꞌumo mufoꞌmanehoho. Ose lɨwoꞌnɨngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Osoꞌno sekwo oso yahino homo somo inɨngkawowoꞌnɨngkohofo soꞌno sekwo Anɨtuye hungkunomo hwotoho fewoꞌnɨngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sekwo aꞌamu mangoꞌnohino hwasoho. Hohonta hwe Aisaiya sekumneꞌno hungkuno nehopi lɨmentisofoho. Ole nalɨmento, ");
INSERT INTO apz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Olo aꞌamu loso hofɨko hofɨkoe mango mtaꞌni nje yofe hoꞌnonɨmawoꞌnɨngkohofofoho. I, hofɨkoe sɨmehoso ngkimo mantapeꞌnjo iwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hofɨko aꞌamu hwahoponjo sofe hunoso nomantɨfi Anɨtu mtaꞌangofoho lontɨfi aꞌamu somo lutɨhwawoꞌnɨngkohofofoho. Osoꞌno hofɨko ngkimo wonyopi jomo ntɨwoꞌnɨngkohofofoho. Aisaiya ose lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas hwe moyaꞌmimo ngkiyepono wapɨfento joho ulɨmentisofoho. Nopahonɨngkofi ulɨmento, Sekwo itoꞌno nɨpaꞌnɨngkuji huno fɨsyafɨhupmno. ");
INSERT INTO apz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yoꞌmayo jɨje mangomo johufaseꞌmofososo oso jɨje honɨngkanomo wonyo imoꞌnnyoꞌneꞌmaho. Oꞌo, yoꞌmayo jɨje mango mtaꞌni lisoso oso jɨje honɨngkanomo wonyo imokiyoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ose ulahonɨngki kakoe inomokomoyo sohwa Jisasɨmo nuꞌmantɨfi ulɨmentohofi, Oso hungkuno lohinoso aꞌamu Falisi sohwa nupaꞌnontɨfi sɨmeho wonyo umoꞌnɨngkohoho. Oso hisoꞌno kɨko huno lakiyohoho. ");
INSERT INTO apz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ose ulahonɨngkofi Jisas ulɨmento, Yoꞌmayo ipisayo uyoꞌneso nje Mpohwo ahwomomo humaso sohwo kako mahulinyoso siki fokafoso somo Mpohwo kako pmpongo hiꞌnji wae yaofonefoho. ");
INSERT INTO apz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sekwo aꞌamu Falisi sohwamneꞌno uhwontohumamno. Hofɨkoe syohofoho. Hofɨko tɨmpiꞌnyo hwafoho. Aꞌamu tɨmpiꞌnyo huhwo sohwa nomꞌne aꞌamu tɨmpiꞌnyo somo honɨngkano iputɨhwawoꞌnɨngkohofɨhwafoho. Hwe tɨmpiꞌnyo sohwo nomꞌne tɨmpiꞌnyo sohumo honɨngkano iputɨhwasoso oso hwaꞌu piꞌnɨmomo wopɨwesyanjiyoho. ");
INSERT INTO apz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ose ulahonɨngki Pita ulɨmento, Oso pahnnɨmo hungkuno nto lohinoso yoloho fonaso. ");
INSERT INTO apz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ose ulahonɨngki Jisas ulɨmento, Sekwo hoku huno ane kulaho. ");
INSERT INTO apz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ihwoni, yoꞌmayo hopiꞌnono mangomo josyohumawoꞌnɨngkiso oso hiso sɨmehomo wowoꞌnɨngkohoho. Sɨmeho mtaꞌangoso monje noswaponto iꞌango piꞌnɨmomo wowoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","I, yoꞌmayo mango mtaꞌni swapɨwoꞌnɨngkisoso aꞌamufe huno mtaꞌni swapɨwoꞌnɨngkohoho. Oso hiso aꞌamufe honɨngkano wonyo imoꞌnɨwoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yoꞌmayo huno mtaꞌni swaponteso ole, huno wonyo syafɨsiyo, aꞌamumo fonjasiyo, nomꞌne hwafe ape hufo iyo, ape sikinjomo wonyo ulohofo, yoꞌmayoso hufo iyo, hwasyo hungkunojo, sitofo hungkunojo, ");
INSERT INTO apz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","oso yoꞌmayo hiso aꞌamufe honɨngkano wonyo imokiyoꞌnefoho. Ou, aꞌamu fihwo kako kakoe aho mijo miyatɨkuꞌnyoꞌnjo ilohofɨhwosi wosopayo nososo oso hiso kakoe honɨngkano wonyo mmokonehoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Oseso Jisas oso ango hopo sopo nulɨkoꞌmanto nomꞌne hwaho pone hufaꞌu Taiyaꞌnji Saitounꞌnji osopono umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aꞌmu temtitofo kengosi hwaho Kenanntaꞌango noponto Jisasɨmo nuꞌmanto joho ulɨmento, U, Hwe Engofo, kɨko Ntefitɨye imu hwosoho. Kɨko ngkineꞌno hitoho wakilofono. Towahuno wonyo sohwo nje mumo humaho. Nɨhuꞌno wonyo ulohofalofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ose ulahonɨngki Jisas kako oso aꞌmu siye hungkunomo asomo mujoꞌnjo imentisofoho. Oseso kakoe inomokomoyo sohwa Jisasɨmo nuꞌmantɨfi ulɨmentohofi, Olo aꞌmu losi kako joho lonto lonto tɨfi kinɨngkopalofoho. Kɨko asomo filɨhwajo. ");
INSERT INTO apz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ose ulahonɨngkofi Jisas ulɨmento, Aꞌamu Isɨlaelɨso honɨngkanoꞌno tɨpeelokwofo. Oso aꞌamu somneꞌno Anɨtu lonuhwojahonɨngki pmmentohe hwoꞌnyoho. Aꞌmusi kako aꞌamu Isɨlael mtaꞌangiꞌmaho. Kako temtitofo kengiyoho. ");
INSERT INTO apz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ose ulahonɨngki aꞌmusi kako noponto Jisasɨꞌnjo ne lopo hwomtame ulohofonto ulɨmento, Hwe Engofo, kɨko ngkimo nɨfoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ose ulahonɨngki Jisas aꞌamu Isɨlael soꞌntnno aꞌamu temtitofo kengo soꞌntnno pahnnɨmo hungkuno ulɨmento, U, nakwo mehomife wosopayo mehwasi sɨwojomo wohoꞌnɨmofantantaho. Oꞌo, awonoho. Oso wonyofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ose ulahonɨngki aꞌmusi syafɨhuꞌmento, Ngko aꞌamu Isɨlaelɨnɨꞌmaho. Oꞌo, sɨwojo paꞌnyiꞌnyoho. Ose syafɨsyonto ulɨmento, Hwe Engofo, kɨko nehopi lohino. I sɨwojoso hofɨko ilɨfiso hofekwoꞌyohwosa wosopayo nonontɨfi huꞌmumokwojahonɨngkofi nɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ose ulahonɨngki Jisas ulɨmento, U, aꞌmu losiyo, jɨje sɨmeho hiꞌntnnohinoso engoꞌnjo kiyoho. Kɨko pehoꞌno kumoꞌnoso oso kɨko wotɨpemaꞌmonnoho. Ose ulahonɨngki oso hohosohonta oso aꞌmu siye mu wopɨngo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas oso ango hopo sopo nulɨkoꞌmanto Mijo Ayo Ngkalili momɨngo mofone sopo nowento hwofɨkiꞌnyo weꞌe sopo nosonto osopo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nohumentanɨngki hwe hwoyaꞌmi piꞌnɨngoso nuꞌmantɨfi aꞌamu sɨfe wonyoꞌnjo soꞌnji aꞌamu tɨmpiꞌnyo soꞌnji yokino kokatoꞌnnyo soꞌnji aꞌamu mampiꞌnyo soꞌnji wonyoꞌwonyo mnokinoꞌnjo soꞌnji oso piꞌnɨngo engo somo Jisasɨye sɨfɨkiꞌnyoꞌmo uhumatɨꞌmentohofofoho. Uhumojahonɨngkofi Jisas wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Oseso aꞌamuso uhwonɨmentohofoso aꞌamu mampiꞌnyoso hungkuno nɨhuꞌno itoꞌno lahonɨngkofi aꞌamu yokino kokatoꞌnnyoꞌnjoso wopɨngo imoꞌnɨngkahonɨngkofi, aꞌamu sɨfe wonyoꞌnjoso hano uhwanɨngkofi aꞌamu tɨmpiꞌnyoso tɨmo honɨngkahonɨngkofi osomo uhwonontɨfi pisopisaho mjalɨmɨwentɨfi hofɨko Isɨlaelɨfe Anɨtu kakoe yofe hoꞌnoma lohoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas kakoe inomokomoyo sohwamo joho ulonto ulɨmento, Ngko olo hwe hwoyaꞌmi lomneꞌno hitoho ntokwoho. Sɨkuno hufaꞌu sɨhune ngkoꞌnji humantohofofoho. Hofɨko wosopayo anefoho. Mijohoꞌnohinofoho. Ngko lɨhwatɨmeꞌmanji u, hofɨko honɨngkanopo tɨmo sɨkunoꞌno ikuji nopɨwahupitnnoho. ");
INSERT INTO apz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ose ulahonɨngki kakoe inomokomoyo sohwa ulɨmentohofi, Olo hwaho lopo aꞌamu mohumunyoponoho. Nakwo olo aꞌamu piꞌnɨngo engo somneꞌno wosopayo ntɨꞌmtaꞌni manehwono. ");
INSERT INTO apz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo wopayo alale weho. Ose ulahonɨngki ulɨmentohofi, Nakwoe wosopayoso aho fehohntaꞌni hopiꞌnono fehohntaꞌni hufaꞌuyoho. Osoꞌnji inanɨku weꞌeso angaꞌno angaꞌnohinoho. ");
INSERT INTO apz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ose ulahonɨngkofi Jisas hwe moyaꞌmi somo ulɨmento, Sekwo hwaho lopo fosyohumamno. ");
INSERT INTO apz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ose ulonto kako wopayo aho fehohnjo hopiꞌnono fehohntaꞌni hufaꞌuyo osoꞌnji inanɨkuꞌnji nomanto Anɨtumo isamoyoka ulonto wopayoso kutɨkujo lohofonto kakoe inomokomoyo sohwamo uyɨmentisofoho. Nomantɨfi oso hwe moyaꞌmi somo uyɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Aꞌamuso wopayo nontɨfi sɨmeho uhnnɨngkahonɨngki nulɨfeeꞌmentohofoso mɨhuꞌmokumentohofofoho. Nomɨhuꞌmokontɨfi hoꞌyo aho fehohnjo hopiꞌnonohino fehohntaꞌni hufaꞌu mehuꞌmemeehumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hwe sohwa oso wosopayo nɨmentohofoso foua tausen (4000) hwafoho. Oseso moyaꞌmi mehomi soꞌno hofɨko atofo malɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisas oso hwe moyaꞌmi somo noluhwajonto yofayokinomo nokotasontɨfi hwaho Makatan nongkihntaꞌni wakoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aꞌamu Falisi sohwanji Satɨyusi sohwanji Jisasɨmo uꞌmantɨfi Jisasɨmo yamofo ulohofano lontɨfi ulɨmentohofi, Yoꞌmayo kengo wonyoangkafo aꞌamu miyɨwoꞌnɨngki yohofoso fonetɨhwaho. ");
INSERT INTO apz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ose ulahonɨngkofi Jisas ulɨmento, Mofehiꞌnyo wonɨngkuꞌnɨmonto yahonɨngki ole lɨwoꞌnɨngkohofi, Ahwomo honɨjwo imoꞌnɨngkisoso moꞌnɨngka jefo umontonoho. Ose lɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Imɨngoꞌnji sekwo himo sɨkwoꞌmnoꞌnji ahwomo honɨyoꞌnohinomo uhwonontɨfi ole lɨwoꞌnɨngkohofi, Ifoyo wahuꞌmontonoho lɨwoꞌnɨngkohofofoho. Sekwo ahwomomo uhwonontɨfi ifoyo yoꞌmayoso huno seyɨwoꞌnɨngkisofoho. I osoꞌno yoꞌmayo olohontajo imoꞌnalokunjoso Anɨtu uhwosopoꞌmentiso sohwo sekuye pono uhwatɨmentiso sohumo uhwonontɨfeso yofe mɨhwofeꞌnjo yalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aꞌamu olohonta humalofo soku honɨngkano wonyoꞌnjo kuyoho. Sekwo ngkineꞌno yoꞌmayo wonyoangkafo somo uhwonano ntontɨfi lontantokwofo. Ose ko ntɨwoꞌnɨngkohofoso ngko oso hiso mutɨhwamonnehono. Oꞌo, Jouna hohonta humamojo sohwo ulohoꞌmentiso hopaso osoꞌnohini wosetɨhwamonnoho. Ose ulonto Jisas hofɨkimo nulɨkoꞌmanto umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisasɨye inomokomoyo sohwa mijo nongkihntaꞌni iꞌmofawentɨfi wopayo motayo soꞌno inɨngo moꞌmentohofo soꞌno uhwonɨngkahonɨngkofi ");
INSERT INTO apz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisas pahnnɨmo hungkuno ulɨmento, Upaꞌnɨmno. Sekwo aꞌamu Falisi sohwanji Satɨyusi sohwanjiye yahino somneꞌno iꞌwaho fiyɨmno. Itoꞌno uhwontohumamno. ");
INSERT INTO apz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ose nupaꞌnontɨfi inomokomoyo sohwa ole hnnɨmentohofi, Nakwo wopayo momotapeꞌnjo ihwone soꞌno lohoho. ");
INSERT INTO apz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ose hnnɨmentohofo soꞌno Jisas huno uyahonɨngki hofɨkimo ulohonɨmento, Wopayo umofonyo iyo soꞌno pehoꞌno hnnalokwofo. Sekwo ngkimo sɨmeho hiꞌntnnono mantapeꞌnjo pehoꞌno iwoꞌnɨngkohofɨhwasilo. ");
INSERT INTO apz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Huno neꞌno maseyoho liyohoho. Ngko aꞌamu faif tausen (5000) sohwamneꞌno wopayo aho fehohnjo hopiꞌnonohino somo kutɨkujo ulohohmmale soꞌno inɨngo laseyohoho. Sohwo hoꞌyo alale huꞌmeemmalofoto ");
INSERT INTO apz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","I nomꞌne sɨkuno somo wopayo aho fehohnjo hopiꞌnono nomꞌne mtaꞌni hufaꞌuyoso hwe foua tausen (4000) sohwamnekofo. Osohonta hoꞌyo alale huꞌmeemmalofoto. ");
INSERT INTO apz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngko wosopayo soꞌno masejoꞌnjo yalokwe soꞌno huno maseyoꞌnjo pehoꞌneto. Oꞌo, aꞌamu Falisi sohwanji Satɨyusi sohwanjiye wopayo sa somneꞌno iꞌwaho fiyɨmno. ");
INSERT INTO apz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ose ulahonɨngki inomokomoyo sohwa hofɨko huno itoꞌno syafɨhuꞌmentohofofoho. Jisas wosopayo soꞌno hungkuno mujoꞌnjo imentisofoho. Oꞌo, aꞌamu Falisi sohwanji Satɨyusi sohwanjiye hungkuno kokatoꞌnnyo lutɨhwawoꞌnɨngkohofo soꞌno iꞌwaho fiyɨmno ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas kako ango Sisaliya Filipai osopono wento kakoe inomokomoyo sohwamo ulɨmento, Aꞌamuso nohumantɨfi Aꞌamufe Hwomu sohuneꞌno pehofo mjolɨmɨwalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ose ulohonɨngkahonɨngki ulɨmentohofi, Aꞌamu fehohnjo ole lalokwofo, Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwolɨkeno. Aꞌamu nomꞌne fehohnjo ole lalokwofo, Ilaijatɨkeno. Nomꞌnihwa ole lalokwofi, Jelemaiyatɨkeno. Nomꞌne aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwolɨkeno. Ose mjolɨmɨwalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo sohwasi ngkineꞌno pehofo ntɨwoꞌnɨngkohofɨhwasilo. ");
INSERT INTO apz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ose ulohonɨngkahonɨngki Saimoun Pita ulɨmento, Kɨko Kɨlais Anɨtu kuhwosopoꞌmentiso hwosoho. Anɨtu songo humaso sohwoe Hwomu Ne hwosoho. ");
INSERT INTO apz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ose ulahonɨngki Jisas ulɨmento, Saimoun Jounɨye hwomu sohwosi, kɨko sɨmonyo uyɨmonnoho. Ou, olo hilo soꞌno aꞌamu hwahoponjo fihwo mokitɨhwaho yohoho. Oꞌo, awonoho. Olo hungkuno ntohino loso nje Mpohwo ahwomomo humaso sohwo kitɨhwahoho. ");
INSERT INTO apz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Osoꞌno wakilɨmo. Kɨko Pita kiyoho. Oso engkwosaho huhwo sohwoꞌni hopo sopo ngko nje ango wamolɨnnoho. Setenꞌnji yoꞌmayo hwahoponjo yokumpohnꞌnyo soꞌnji ngko iyo kopmmoꞌmeehume somo milojaofonehoho. ");
INSERT INTO apz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Anɨtu aꞌamumo mokosyohumayo soꞌno hwosampe-eꞌneso wokijapmmonnoho. Yoꞌmayo hwaho lopo kɨko wonyofoho lohoji nano mtitojoso i, oso hisoꞌno Anɨtu ahwomomo nto mtitokwoho. Yoꞌmayo hwaho lopo kɨko wopɨngofoho lohoji oso hisoꞌno Anɨtu kako ahwomomo wopɨngofoho nto lohoho. ");
INSERT INTO apz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ose ulonto inomokomoyo sohwamo ulɨmento, Sekwo nomꞌne aꞌamu somo olo Kɨlais Anɨtu uhwosopoꞌmentiso lohweho ulɨkutoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Oso hohosohonta inomokomoyo sohwamo Jisas kako poyo imoꞌnyo soꞌne yoloho ulomaꞌmentisofoho. Ole ulɨmento, Ngko Jelusalemneꞌno uhwahonɨꞌmo hwe engo sohwanji aꞌamu tajo ango syohoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji ngkimo tohino engo ntapɨkuji fonjanɨhufitnnefoho. I osoꞌno sɨkuno hufaꞌu sɨhune memjanɨmofɨhwosoꞌno ngko apaꞌno songo wolɨkaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ose ulahonɨngki Pita Jisasɨmo weꞌenepi ipemotawento yoka ole ulomaꞌmento, Hwe Engofo, olo nalohino loso Anɨtu ihwoloho. Oꞌo, osohiso kikimo mokuꞌmanehoho. ");
INSERT INTO apz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ose ulahonɨngki Jisas ikinjonto Pitamo ulɨmento, Pita, jɨje hungkunoso ngkilaho. Anɨtuyeꞌmaho. Oꞌo, Setenɨye hungkunofoho. Kɨko Seten sohwosi iꞌwaho ntohofo. Jɨje hungkunomo ngko haloho mokupaꞌnɨmnehono. Kɨko nje hohujo loꞌmo filohoꞌnawofo. ");
INSERT INTO apz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ose ulonto inomokomoyo nomꞌne sohwamo Jisas ulɨmento, U, aꞌamu fisoku ngkimo wonnɨngkopano lɨfijoꞌmanji sekwo sekwoe yoꞌmayo hi semoꞌnɨwoꞌnɨngkiso soꞌnji sekwoe yofe soꞌnji monje yahinɨngkuji sekwo nje yofeꞌno poyo peꞌnyo soꞌno iyoho miyoꞌnjo ifijoso ngkimo mofone sopo tɨfi nnɨngkapmno. ");
INSERT INTO apz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aꞌamu fihwo kakoe songo humayoso yokumpohnꞌnyo womokosyohumamo lososo kakoe songo neꞌno humayoso wopɨwahuꞌmtonoho. Osoꞌno aꞌamu fihwo ngkineꞌno huno uyahonɨngkuhwosi kakoe humayoso pɨwasyososo hwangku kakoe humayoso wotɨpemaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Aꞌamu fihwo kako Anɨtumneꞌno hohujo ikinjaofɨhwosi kako olo hwaho loponjo hoꞌyango hamniyoho yoꞌmayoso engo huꞌmeesyontoso sohwo kako tɨkanomo wesoꞌmanji oso hoꞌyango yoꞌmayoso pipi ufoꞌmaneto. Awonoho. I, kakoe songo humayoso ne aneꞌmanji kako pipi yoneꞌelo. Awonoho. Kako songo humayoꞌne neso mpe pipi uyɨmtolo. ");
INSERT INTO apz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aꞌamufe Hwomu sohwo kanɨngkwohwoe yokumpohnꞌnyo soꞌnji aꞌamu ahwomomjo soꞌnji pososohonta aꞌamu olo hwaho lopo humalofo somo yoꞌmayo yahino iwoꞌnɨngkohofo soꞌno yano ulofiyonefoho. ");
INSERT INTO apz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ose ulonto ole ulɨmento, Ngko hungkuno nehopi waselɨmonneꞌno yohono. Aꞌamu olo hwaho lopo nakwoꞌnji olohonta humalofo fehohnjoso mapeꞌnontanɨngkuji Aꞌamufe Hwomu kako hwe yofe engoꞌnjo sohwo aꞌamu mokosyohumayoꞌne pososohonta nuhwonɨfitnnefoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sɨkuno aho fehohnjo hopiꞌnono fehohntaꞌne angaꞌno memjaofahonɨngki Jisas kako Pitaꞌnji sikoꞌnɨkwaꞌi Jemɨsɨꞌnji Jounja oso hwa nutɨmanto hofɨko hwofɨkiꞌnyo sawemo engo sopono kotasɨmentohofofoho. Hofɨkoꞌnohini humamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nohumantɨfi Jisasɨye aꞌapahoso nomꞌne ulohopisahonjoso uhwonɨmentohofofoho. Kakoe sɨmoꞌmangoso mofehiꞌnyo lawoꞌnnyo imoꞌnɨmentisofoho. Kakoe manjiꞌmofo yoꞌmayo hopiꞌnono nɨhuꞌno halojo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ose uhwonontɨfi uhwonɨmentohofoso hwe hufaꞌu ahwomo mtaꞌango sohwaꞌu Mousesɨꞌnji Ilaijaꞌnji siko noponji Jisasɨꞌnji hungkuno hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita kako huno piꞌnɨngo syofɨsikaofonto Jisasɨmo ulɨmento, Hwe Engofo, nakwo olopo humentani sehonɨngkuhwoneso wopɨngofoho. U, ngko olopo ango hufaꞌu sɨhune molɨmeso wopɨngotaho. Angaꞌno kɨkoꞌne, nomꞌne Mousesɨmne, nomꞌne Ilaijamnefoho. ");
INSERT INTO apz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ose ulontanɨngki himo engo pomponaho paꞌnyoso hofɨkimo ifeehuꞌmo kohumentisofoho. Oso himo homo somtaꞌni ole hoꞌnɨmento, Olohwo nje Hwomufoho. Ngko kakineꞌno hi nɨmoꞌnɨwoꞌnɨngkiso hweho. Kakoe yahino soꞌno nje sɨmeho wopɨngo nɨmoꞌnɨngkohoho. Kakoe hungkunomo sekwo haloho upaꞌnɨmno. ");
INSERT INTO apz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ose hoꞌnɨngkahonɨngki Jisasɨye inomokomoyo sohwa nupaꞌnontɨfi iyoho unɨngkahonɨngki hofɨkoe sɨmano hwahomo mongkutoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ose nohumentanɨngkofi Jisas hofɨkoꞌnjo tɨfone lopo noponto aho umakumentisofoho. Numakonto ulɨmento, Sekwo filɨkapmno. Iyoho ikutoho. ");
INSERT INTO apz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ose ulahonɨngki hofɨko tɨmo honontɨfi nomꞌne aꞌamumo muhwonyofoho. Oꞌo, hofɨko Jisas kakoꞌnohini humentanɨngki uhwonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hofɨko oso hwofɨkiꞌnyo hopo sopo nokotapontɨfi Jisas hungkuno yokumpohnꞌnyo ulɨmento, Olo hiloso nuhwonɨngkohofo losoꞌno nomꞌne aꞌamumo olohonta nulɨkutoho. Oꞌo, hwangku Aꞌamufe Hwomu sohwo poyo imoꞌnɨngkuhwosi apaꞌno songo lɨkafoso sohonta ou, sekwo filutɨhwanɨngkuno. ");
INSERT INTO apz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ose ulahonɨngki kakoe inomokomoyo sohwa ulɨmentohofi, Aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwa ole lɨwoꞌnɨngkohofi, Ilaija kakiꞌno wapmmontonoho. Tɨfi sohonta Kɨlais hwe Anɨtu uhwosopoꞌmentiso sohwo wapmmontonoho. Oso hiso pehoꞌno lalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ose ulahonɨngkofi Jisas ulɨmento, Ou, hungkuno nehopi lalokwofo. Ilaija kako nopɨhwosi yoꞌmayo hopiꞌnono itoꞌno wesyohumamtonoho. ");
INSERT INTO apz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","I, ngko waselɨmonneꞌno yohono. Ilaija kako nto pmmentisofoho. Osohuneꞌno aꞌamuso yofe mɨhwofeꞌnjo yontɨfi hofɨko hofɨkoe hwahoponjo hunomnohini inɨngkawentɨfi yoꞌmayo wonyo ulohoꞌmentohofofoho. Oso paꞌnyo hwangku Aꞌamufe Hwomu sohumo tohino engo uyɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas ose ulahonɨngki kakoe inomokomoyo sohwa huno ole uyɨmentisofo kako Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwo Ilaija paꞌnyo sohuneꞌno nalohoho. Ose syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Oseso hwofɨkiꞌnyopo ntaꞌni nokotapontɨfi aꞌamu piꞌnɨngo engoꞌnjo sopo ifɨwahonɨngkofi hwe fihwo kako Jisasɨmo nuꞌmanto hwomtame ulohofonto ulɨmento, Hwe Engofo, kɨko nje hwomumneꞌno hitoho wakilofono. Kako nopɨwasyonteso yomo yomo iwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Kakoe aꞌapahoso nɨhuꞌno wonyofoho. Sɨkuno piꞌnɨngo somo kako tohomo hwafɨwoꞌnɨngkiso hweho. U, sɨkuno fehohnjo kako mijomo hwafitohmꞌmofɨwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ngko jɨje inomokomoyo sohwamo nje hwomumo uhwojahohweso. I, hofɨko wopɨngo mmokoho yohofo. Hofɨko hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ose ulahonɨngki Jisas ulɨmento, Hwe moyaꞌmi olohonta humalofo soku, sekwo Anɨtu sɨmeho hiꞌntnnono muyo kuyoho. Sekwoe honɨngkano itoꞌnohinoꞌmaho. Oso yahino hiso neꞌno wesoꞌmanji ngko sekwoꞌnji humayoso sɨkuno alale womemjanɨmoꞌmontolɨkeno. Ngko sekwoe tango ngkimo nɨꞌmayoso sɨkuno alale womemjanɨmoꞌmontolɨkeno. Ngkoꞌnjo lopo hwomu huhwo sohwo uhwojapmno. ");
INSERT INTO apz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ose ulonto Jisas oso towahuno wonyo sohumo yoka ulahonɨngki towahuno wonyo sohwo oso hwomu sohumo ulɨkoꞌmaꞌmentisofoho. Hwomu huhwo sohwo wopɨngo komoꞌno imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Oseso kakoe inomokomoyo sohwa Jisasɨyepono nopontɨfi hofɨkoꞌnohini nohumantɨfi ulɨmentohofi, Pipilo. Nakwo oso towahuno wonyoso wae meeofesofo. ");
INSERT INTO apz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ose ulahonɨngkofi Jisas ulɨmento, Ou, ngko nehopi waselɨmonneꞌno yohono. Sekwo ngkimo sɨmeho hiꞌntnnonohinoso montopantokuyohofo. Sekwo ngkimo nnɨngkape-eso nɨhuꞌno weꞌe patnnyo uyo paꞌnɨngoꞌmanji u, sekwo olo hwofɨkiꞌnyo lomo kɨko nolɨkafohoji fɨwano, ose ulɨkujoꞌno hwofɨkiꞌnyo sohwo wamtonoho. Sekwoe sɨmeho hiꞌntnnonohinoso oso patnnyo uyo weꞌeso paꞌnyo hiꞌnjo hwasɨꞌmanji u, sekwo yoꞌmayo hopiꞌnonohinoso ikutnne hwasoho. ");
INSERT INTO apz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","I oso hisoꞌno olo towahuno wonyo losoꞌno wae yaofoꞌneso honɨngkano angaꞌnohino weho. Oso honɨngkanoso olenoho. Sekwo Mpohumo jomoꞌnohino ujoꞌmanji wosopayo manyoꞌnjo humayo soꞌntnno ifijoso olo towahuno wonyo loso aꞌamumo ulɨkoꞌmayoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas kakoe inomokomoyo sohwanji hwaho Ngkalili iꞌmofawentɨfi Jisas ulɨmento, Ngko Aꞌamufe Hwomu sohwoꞌnɨmo nje mango sohwafe ahomo hoꞌnanɨsyɨkujoꞌno ");
INSERT INTO apz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","hofɨko wofonjonɨsyantɨfeho. I oso huhwo sohwo sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno Anɨtu apaꞌno songo ulɨkaꞌmontonoho. Ose ulahonɨngki inomokomoyo sohwa sɨmeho tango engo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas kakoe inomokomoyo sohwanji ango Koponeyam iꞌmofɨwahonɨngkofi aꞌamu tajo angomneꞌno hamniyoho mawoꞌnɨngkohofo sohwa Pitamo nuꞌmantɨfi ulɨmentohofi, Sekwoe hwe engo sohwo kako tajo angomneꞌno hamniyoho hoꞌnaofɨwoꞌnɨngkiso hwolaho. ");
INSERT INTO apz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ose ulahonɨngkofi Pita ulɨmento, Ikofo. Ose ulonto Pita angomo noswahonɨngki Jisas Pitamo kakiꞌno ulɨmento, Saimoun, kɨko huno pehoꞌno kiyohoho. Olo hwaho loponjo hwe yofe engoꞌnjo hwaho mokosyohumayo sohwa hofɨko hamniyoho yoꞌmayoso tɨhumtaꞌni mawoꞌnɨngkohofoto. Hofɨkoꞌmontohwa mtaꞌnɨngotaho. Aꞌamu kengo sohwa mtaꞌangotaho. ");
INSERT INTO apz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ose ulohonɨngkahonɨngki Pita ulɨmento, Aꞌamu kengo sohwa mtaꞌango mawoꞌnɨngkohofofoho. Ose ulahonɨngki Jisas ulɨmento, I, oseꞌmanji hofɨkoꞌmontohwa hamniyoho mohoꞌnaopitnnehofo. Osoꞌno ngko Anɨtuye hwomu sohwoꞌni pehoꞌno uyɨmonnto. ");
INSERT INTO apz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","I oso hisoꞌno hofɨko nakumneꞌno huno wonyo nosyonafɨhupitnnoho. Kɨko mijo momɨngopono uhuji ingkuso finjasyo. Inanɨku sɨmoꞌmjo injwapojoso kakoe mangomo kɨko hamniyoho tajo angomneꞌno hopaso wotɨpemaꞌmonnoho. Oso hamniyohoso nomahoji nekumneꞌno tajo angomneꞌno fohoꞌnamofo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hohosohonta Jisasɨye inomokomoyo sohwa kakimo nuꞌmantɨfi ulɨmentohofi, Anɨtu aꞌamumo mokosyohumayo soꞌno nakwo sohwonaꞌni yofe engo hwofiloꞌnnyoso tɨhwolo. ");
INSERT INTO apz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ose ulohonɨngkahonɨngkofi Jisas mehomi fihumneꞌno joho ulonto kakoꞌnjo lopo mɨhumajonto ");
INSERT INTO apz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ulɨmento, Hungkuno nehopi waselɨmonneꞌno yohono. Sekwo honɨngkano wonyo somneꞌno sɨmeho mɨwoloꞌmokiyoꞌnjo ifijoso olo mehomi lohwo paꞌnyo mmoꞌnyꞌnjoꞌmanji sekwo Anɨtumo mohumafitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Anɨtu aꞌamumo mokomosyohumayo soꞌno aꞌamu fihwo ngko yoꞌmɨngohwonɨꞌmaho loso oso humo Anɨtu ole ulonefoho. Kɨko yofe engoꞌnjo hwosoho. Ose ulonefoho. ");
INSERT INTO apz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aꞌamu fihwo kako olo mehomi lopaꞌnyo sohumo nje yofe hoꞌnonɨmayoꞌne ufoꞌmaso sohwo kako ngkimo nɨfoꞌmakwoho. ");
INSERT INTO apz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Olo mehomi ngkimo sɨmeho hiꞌntnnono ntapɨwoꞌnyo sohumo aꞌamu huno wonyoꞌnjo fihwo ulososo, Jisasɨmo hohujo fikinjaofo. Honɨngkano wonyo lomo tɨfi finɨngkayo. Ose uloso sohwo mehomi huhwo sohwo honɨngkano wonyomo inɨngkayo soꞌno oso hwe huno wonyoꞌnjo huhwo sohumo Anɨtu tohino mɨkunɨmposo uyonefoho. Osoꞌno oso hwe huhwo sohwo wonyo hiso miyo sohonta sojo mɨkunɨmposo engo soꞌnji kakoe tɨꞌwangomo impe ifakojujɨkuji mijomo hoꞌnaofontɨfitentesi wopɨngoꞌnesohilo. ");
INSERT INTO apz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Aꞌamu nomꞌne sohwoe honɨngkano wonyo umokiyo sohumneꞌno hitoho ntokwoho. I oso yahino imoꞌnyoso aꞌamu huhwo sohwo tohino mɨkunɨmposo nomane hweho. Osoꞌno kakineꞌno hitoho ntofantofoho. ");
INSERT INTO apz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jɨje sɨfe aho honɨngkano wonyo imokososo sɨfe aho hiso nohwempehoji fohoꞌnamofo. Aꞌamu sɨfe aho angaꞌnohinoꞌnjo sohwo honɨngkano wopɨngo tɨpemayoso wopɨngofoho. U, sɨfe aho hufaꞌuꞌnjo honɨngkano wonyo imokuhwosoꞌno nɨhuꞌnahone tɨkanomo wenefoho. ");
INSERT INTO apz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jɨje tɨmo honɨngkano wonyo imokososo tɨmoso fitɨhwotofaofo. Aꞌamu tɨmo angaꞌnohinoꞌnjo sohwo honɨngkano wopɨngo tɨpemayoso wopɨngofoho. U, tɨmo hufaꞌuꞌnjo sohwo honɨngkano wonyo imokuhwosoꞌno nɨhuꞌnahone tɨkanomo wenefoho. ");
INSERT INTO apz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Olo mehomi lomneꞌno sekwo yoꞌmɨngohwasɨꞌmaho ulɨkutoho. Oꞌo, sekwo upaꞌnɨmno. Aꞌamu ahwomomjoso mehomi lomo itoꞌno mokosyohumawoꞌnɨngkohofofoho. Yoꞌmayoso mehomi lomo uꞌmaso soꞌno Mpohumo ulɨwoꞌnɨngkohofofoho.  ");
INSERT INTO apz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Hwapɨngoso Aꞌamufe Hwomu sohwoꞌni aꞌamu wonyo honɨngkanomo humentanɨngkuji somneꞌno utɨmayoꞌne pmmentohefoho. ");
INSERT INTO apz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Huno pipi seyohoho. Hwe fihwo kako yahu sipsip wan hantɨletɨꞌnjo (100) sohwo yahu angaꞌnohino sohwo isɨpeeofoso sohuneꞌno hafɨhafe motɨpemasoꞌnjo umontolaho. Awonoho. Oso yahu nainti nain (99) sohwa hofɨko wopayo nontanɨngkuji kakwoꞌyohwo sohwo nulɨkoꞌmahwosi yahu isɨpeeofo sohuneꞌno notɨpehwosi wotɨpemaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Notɨpemahwosi kako yahu angaꞌnohino isɨpeeofo sohuneꞌno sɨmonyo umontonoho. Nomꞌne yahu nainti-nain (99) misɨpeefeꞌnjo soꞌno huno mosyafɨsyonehoho. ");
INSERT INTO apz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Oso paꞌnyo sekwoe Mpohwo ahwomomo humaso sohwo kako weꞌe lomneꞌno ole lalofi, Ngko mehomi lomneꞌno misɨpeefeꞌnjo yohono. Ose lalofoho. ");
INSERT INTO apz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jɨje aꞌamu kikimo wonyo kilohofososo kɨko kakimo uꞌmahoji sikoꞌnohini humahosɨsi kakoe wonyoꞌno yoloho uso. Kako jɨje hungkunomo nupaꞌnɨngkuhwosɨꞌmanji u, jɨje aꞌamu ne apaꞌno umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kako Jɨje hungkunomo haloho maposoꞌnjoꞌmanji kɨko nomꞌne aꞌamu angaꞌnohinotɨkeno hufaꞌulɨkeno oso hwa tɨpemahoji hwe wonyo kilohofoso sohwoepono fɨwanɨmno. Osopo iꞌmofakuji aꞌamu hufaꞌulɨkeno hufaꞌu sɨhunetɨkeno oso hwa wolɨjwaopɨfe. ");
INSERT INTO apz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kako hofɨkoe hungkunomo haloho maposoꞌnjoꞌmanji eꞌwa, aꞌamu hopiꞌnonohino sekwoꞌnji Anɨtumneꞌno uhuꞌmokuwoꞌnɨngkohofo sokumo ulɨmno. I aꞌamu hopiꞌnonohino sofe hungkunomo haloho maposoꞌnjoꞌmanji, eꞌwa kako aꞌamu kengo paꞌnyo hweho. Oso aꞌamu huhwo sohwo kengopo uhumajipijo osopo wohumamontonoho. ");
INSERT INTO apz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Hungkuno nehopi waselɨmo. Yoꞌmayo olo hwaho lopo sekwo wonyofoho lɨkuji nano mtitojoso i, oso hisoꞌno Anɨtu ahwomomo nto mtitokwoho. Yoꞌmayo olo hwaho lopo sekwo wopɨngofoho lɨkuji oso hisoꞌno Anɨtu kako ahwomomo wopɨngofoho nto lohoho. ");
INSERT INTO apz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Hungkuno nomꞌne waselɨmo. Olo hwaho lopo aꞌamu hufaꞌu hwaꞌu yoꞌmayo soꞌno sɨmeho afa inɨngkohosɨsi Mpohumo oso hisoꞌno jomo ulisoso nje Mpohwo ahwomomo humaso sohwo wosejapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Aꞌamu hufaꞌu sohwaꞌu sɨhune sohwa hofɨko nje yofemneꞌno uhuꞌmokukuji nohumentanɨngkuji ngko hofɨkoꞌnjo ajwoꞌmo wohumamonnoho. ");
INSERT INTO apz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Oso hohosohonta Pita Jisasɨmo uꞌmanto ulɨmento, Hwe Engofo, nje aꞌamu sohwo wonyo ntohofɨwoꞌnɨngkiso soꞌno ngko oso wonyo soꞌno wae alale uyɨmonnto. Wayo yaoꞌmneso aho fehohnjo hopiꞌnono nomꞌne mtaꞌni hufaꞌu oso hopolaho. ");
INSERT INTO apz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ose Ulohonɨngkahonɨngki Jisas ulɨmento, Ngko aho fehohnjo hopiꞌnono nomꞌne mtaꞌni hufaꞌuyo makilohoyohono. Oꞌo, wae iyoso neꞌnohini sefenti (70) ne tɨpemayo aho hopiꞌnono nomꞌne hufaꞌuyo fiyohoho kilohono. ");
INSERT INTO apz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Osoꞌno Anɨtu aꞌamumo mokosyohumayo soꞌno kako aꞌamufe wonyo wae yaofoꞌne yahinoso olenoho. Hwe yofe engoꞌnjo sohwo kakoe syoho ulohofiyo sohwa yoꞌmayo siki mawoꞌnɨngkohofo soꞌno hamniyoho hwangku hoꞌnasiyoꞌne hungkuno mɨhwajiyoꞌne uyɨmo lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Osoꞌno kako syoho emanto syoho ulohofiyo angaꞌnohino fihwo kakoe yoꞌmayo siki mawoꞌnɨngkiso sohwo kakoe hamniyoho mohoꞌnaofeꞌnjoso olenoho. Ten miliyon (10,000,000) kinafoho. ");
INSERT INTO apz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kakoe hamniyoho nɨhuꞌno ane hweho. Osoꞌno hwe engo sohwo ulɨmento, Olo hwe lohwoꞌnji kakoe apeꞌnji mehomꞌnji yoꞌmayo hopiꞌnonohino soꞌnji nomꞌne sohwa hofɨkoe siki syoho ulohofiyo soꞌno mpe uyɨfe. Hamniyoho mpe ifijoso kako mohoꞌnaofeꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ose ulahonɨngki hwe huhwo sohwo kakoe hwe engo sohwoe sɨfe kiꞌnyoꞌmo hwomtame ulohofonto humotaho lonto ulɨmento, Nje hwe engofo, weꞌenepi nohontohumaho. Nohontohumahoji ngko hamniyoho hopiꞌɨnono wokijapmmonnoho. ");
INSERT INTO apz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ose ulahonɨngki hwe engo huhwo sohwo kakineꞌno hitoho ulofahonɨngki hamniyoho mohoꞌnasiyoꞌnjo imentiso soꞌno wae yaofahonɨngki hwe sohwo yoꞌmayo siki mawoꞌnɨngkiso soꞌno hamniyoho nɨhuꞌnahone muyonehoho. ");
INSERT INTO apz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","I osoꞌno syoho ulohofiyo sohwo noswolɨkofaponto uhwonɨmentisoso kakoe syoho afaꞌnono iyo sohumo uhwonɨmentisofoho. Osohwa kakintaꞌni yoꞌmayo siki maꞌnnyoso wan hantɨlet (100) kina mohoꞌnasiyoꞌnjo sohumo uhwononto tɨꞌwangomo aho pmpilɨꞌmokonto ulɨmento, Nje hamniyoho mohoꞌnanɨsyohinoso komoꞌno ntape. ");
INSERT INTO apz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ose ulahonɨngki hwe syoho afaꞌnono iyo sohwo hwomtame pɨwehumawento ulɨmento, Ngkineꞌno hitoho kilofɨhwosoꞌno nohontohumaho. Jɨje hamniyoho wokijapmmo. ");
INSERT INTO apz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ose ulahonɨngki ngkilaho ulonto impoꞌangomo intofahumentisofoho. Osopo intofasyonto ulɨmento, Kɨko osopo nohumahoji nje hamniyoho ntapohojoꞌno ngko wakisɨhutoꞌmnoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ose yahonɨngki syoho afaꞌnono nomꞌne sohwa yoꞌmayoso uhwonontɨfi sɨmeho tohino umnɨmentisofoho. Sɨmeho tohino umnɨngkahonɨngki hwe yofe engoꞌnjo sohumo oso hisoꞌno ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ose nupaꞌnonto syoho ulohofiyo huhwo sohuneꞌno joho ulonto ulɨmento, Kɨko syoho ntohofiyo wonyo hwosoho. Ose ulonto ulɨmento, Sɨmoꞌmo kɨko ngkimo humotaho sontahonɨngkini hamniyoho hopiꞌnono montapeꞌnjo imentohino soꞌno ngko wae yakumoꞌmale hwosoho. ");
INSERT INTO apz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngko kikineꞌno hitoho ntofiso hopaso kɨko nomꞌne aꞌamu syoho afaꞌnono iyo sohumneꞌno hitoho makilofeꞌnjo pehoꞌneto. ");
INSERT INTO apz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ose ulonto sɨmeho tohino umnɨngkahonɨngki tohino engo uyɨwoꞌnɨngkohofo sohwafe ahomo hoꞌnahumentisofoho. Hoꞌnasyonto ulɨmento, Kɨko osopo humahoji nje hamniyoho hopiꞌnonohinoso ntapohojoꞌno wakisɨhutoꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Oso pahnnɨmo hungkunoso Jisas nulonto ulɨmento, Sekwo nomꞌne sofe wonyo selohopijoso wae meefeꞌnjo ifijoꞌmanji u, oso paꞌnyo nje Mpohwo waselohoꞌmontonoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas oso hungkunoso hopiꞌnono losojwaofonto kako Ngkalili nulɨkoꞌmanto kako hwaho Jutiya Mijo Joutan nongkihntaꞌni wakoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Oso hopo sopo aꞌamu piꞌnɨngo engoso Jisasɨmo tɨfi inɨngkamotofofoho. Aꞌamu mnokinoꞌnjo somo Jisas wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Oseso aꞌamu Falisi sohwa Jisasɨmo yamofo ulohofano lontɨfi nuꞌmantɨfi ole ulohonɨmentohofi, Honɨngkano hungkunoso ole woꞌnnyotaho. Hwe fihwo yoꞌmayo wonyoꞌwonyo soꞌno kakoe ape wae yaofoso wopɨngotaho. ");
INSERT INTO apz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Sekwo Anɨtuye hungkuno olo soꞌno huno maseyoꞌnjo liyohoho. Anɨtuye yoꞌmayo hopiꞌnono mtɨꞌmokumentiso sohonta kako hweꞌnji apeꞌnji mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nomtɨꞌmokonto ole lɨmento, Olo hilo soꞌno fihwo kanɨngkwohwo konaꞌwohimo ulɨkoꞌmahwosi kakoe apeꞌnji nemꞌno makotoku wolohoꞌnanjiyoho. Sikoꞌyaꞌu angaꞌnohino umoꞌnanjiyoho. ");
INSERT INTO apz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Oseso siko aꞌamu hufaꞌu umoꞌnanjiꞌmaho. Oꞌo, sikoe aꞌapahoso angaꞌnohino umoꞌnanjiyoho. Osoꞌno Anɨtu osiyaꞌumo nto mekotɨjwahumasofoho. U, oloso nomtɨhuposoꞌeno. ");
INSERT INTO apz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ose ulahonɨngki aꞌamu Falisi sohwa ulɨmentohofi, I osoꞌno Mouses kako olo hungkunolo pehoꞌno mtɨꞌmokumentisoto. Aꞌamu kako ape wohoꞌnahumo lɨhwosi oso hisoꞌno iyoswomo mtɨꞌmokuhwosi aꞌmu simo uyahojɨhwosi wohoꞌnahumontonoho. Oso pipilo. ");
INSERT INTO apz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Aꞌamu yokumpohnꞌnyo imoꞌnɨmentohofo soꞌno Mouses olo hungkunolo mtɨꞌmokumentisofoho. I sɨmoꞌmo neꞌmo olo yahino loso mmoꞌnɨmmojofoho. ");
INSERT INTO apz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ngko nje hungkuno waselɨmonneꞌno yohono. Hwe fihwo kakoe ape honɨngkano wonyo mmofeꞌnjo simo hwehwo kako wae yaofɨhwosi nomꞌne ape masoso oso hwe sohwo kako ape itoꞌno mayo honɨngkano somo mtɨhupeso sohwo kako ose yososo kako honɨngkano wonyoꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ose ulahonɨngki kakoe inomokomoyo sohwa ulɨmentohofi, Hwe kakoe apeꞌnji fosyohumayo yahinoso oseꞌmanji i, hwe songo ape momaso sohwo kako hwosijo lohofoso wopɨngofoho. ");
INSERT INTO apz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ose ulahonɨngkofi Jisas ulɨmento, Hwe moyaꞌmi olo hungkuno hwosijo sohwafe honɨngkano somo inɨngkayo soꞌno fehohnjo hopoꞌmaho. Oꞌo, Anɨtu aꞌamu angaꞌno angaꞌnohino somo kakoe yokumpohnꞌnyo uyososo oso aꞌamuso hofɨko olo hungkuno lomo unɨngkafe. ");
INSERT INTO apz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ihwoni. Hwe angaꞌno angaꞌnohino sohwa hofɨko ape momapitnne hwafoho. Aꞌamu fehohnjo konaꞌwohi aswo maꞌnyo somtaꞌni ape mayosoꞌno hofɨkoe aꞌapaho itoꞌnohinoꞌmaho. Aꞌamu fehohnjo nomꞌne sohwamo ape momasoꞌnjo iyoꞌne ipisayo sɨhu peetɨmotofofoho. Aꞌamu fehohnjo Anɨtuye syoho somneꞌno syafɨsyonte soꞌno hofɨko ape mayo honɨngkano hano pitofahinɨwoꞌnɨngkohofofoho. Olo hungkuno losoꞌno hwe fihwo oloso uyɨmo loso sohwo kako uyono. ");
INSERT INTO apz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Oso hohosohonta aꞌamu fehohnjo hofɨkoe mehomi weꞌeso Jisas kako aho ulonjimokono lontɨfi Jisasɨyepono mehomi somo uhwatɨmentohofofoho. Nuhwojahonɨngkofi kakoe inomokomoyo sohwa yoka ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisas ulɨmento, Sekwo mehomi somo nopɨjumofɨkutoho. Oꞌo, hofɨko ngkiyepono wapɨfe. Anɨtu aꞌamumo mokosyohumayoso mehomi paꞌnyomnoho. ");
INSERT INTO apz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ose ulonto kako mehomi somo mnokinopo aho ulonjimokumentisofoho. Kako moiꞌwo ulonjimokonto oso hopo sopo nilɨkoꞌmanto umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hwe fihwo Jisasɨmo uꞌmanto ulɨmento, Nje Lontɨhwayo sohwosi, ngko songo neꞌno humayoꞌneso yoꞌmayo wopɨngoso pipi iꞌmo maꞌmnehono. ");
INSERT INTO apz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ose ulohonɨngkahonɨngki Jisas Ulɨmento, Kɨko yoꞌmayo wopɨngo soꞌno pehoꞌno ntohonɨngkino. Nɨhuꞌno angaꞌnohino sohwo wopɨngo hweho. Mpohwo kakoꞌnohinoho. U, kɨko songo neꞌno humayoꞌneso womaꞌmo lohoji kɨko honɨngkano hungkuno hopiꞌnonohino somo tɨfi finɨngkahwoho. ");
INSERT INTO apz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ose ulahonɨngki ulɨmento, Honɨngkano hungkuno ntisoto. Ose ulahonɨngki Jisas ulɨmento, Hungkuno ole, Kɨko nomꞌnihumo nofonjasiyoꞌeno. Kɨko ape itoꞌno mayoꞌne yahino somo nomtɨhuposoꞌeno. Yoꞌmayoso hufo iyoꞌeno. Nomꞌnehumo hwasyo hungkuno ujoꞌeno. ");
INSERT INTO apz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Jɨje mpohwoꞌnji naꞌuꞌnjiye hungkunomo tɨfi finɨngkayo. Sikoe yofe fohoꞌnomaho. Kɨko kikineꞌno kuꞌmoꞌnɨwonɨngkiso hopa aꞌamu kɨkoꞌnjopo humalofo somneꞌno wakumoꞌnono. ");
INSERT INTO apz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ose ulahoningki hwe huhwo sohwo ulɨmento, Oso hungkunoso ngko inɨngkowalokweno. Nomꞌneso peho imnehono. ");
INSERT INTO apz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ose ulahonɨngki Jisas ulɨmento, Jɨje honɨngkano wopɨngo hwofiloꞌnnyo umoꞌnɨmo lohojɨꞌmanji jɨje hoꞌyango yoꞌmayo hopiꞌnonohinoso aꞌamu mpe wakilohopɨfe. U, kɨko hamniyoho maho oso hiso nomahoji aꞌamu yoꞌmayoso umofonyo iwoꞌnɨngkohofo somo uyo. Kɨko ose isoso kɨko ahwomomjo hoꞌyango neso womaꞌmonnoho. Ose yohoji kɨko ngkimo tɨfi nnɨngkape. ");
INSERT INTO apz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ose ulahonɨngki oso hwe songo sohwo nupaꞌnonto sɨmeho tango uyahonɨngki kakoe angopono umentisofoho. Hwapɨngoso kakoe hoꞌyango yoꞌmayoso piꞌnɨngoꞌnjo aꞌamu somo muyɨmnehono lonto umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nowahonɨngki Jisas kakoe inomokomoyo sohwamo ulɨmento, Ngko hungkuno nehopi waselɨmonneꞌno yohono. Aꞌamu hamniyoho yoꞌmayoso engoꞌnjo yokumpohnꞌnyo kemokosyohumaso sohwo kako ahwomomo Anɨtu umokosyohumayo soponeꞌno ijijoyonefoho. ");
INSERT INTO apz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ngko apaꞌno waselɨmonneꞌno yohono. Yahu fihwo kako yongo imo paꞌnyo soꞌmo wahumo lɨhwosi yososo wonyopi umontonoho. Oso paꞌnyoso hwe hoꞌyango hamniyoho yoꞌmayoso aho yokumpohnꞌnyo kemokosyohumantoso sohwo Anɨtumo enjwaꞌmo wohumamo lɨhwosi yososo hopoꞌmaho. Oꞌo, kako yahu sohwo yongo imo paꞌnyo soꞌmo wahumo lɨhwosi ijijo wonyopi yoso hopaso oso hwe hoꞌyango engoꞌnjo sohwo oseno yonefoho. ");
INSERT INTO apz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ose ulahonɨngki kakoe inomokomoyo sohwa oso hungkunoso nupaꞌnontɨfi yomo imentohofofoho. Hofɨko lɨmentohofi, Oseꞌmanji aꞌamu Anɨtuꞌnji ango wopɨngo sopo songo neꞌno humayoꞌneso tɨhwo womaꞌmontolo. ");
INSERT INTO apz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ose ulahonɨngkofi Jisas hofɨkimo tɨmo uhwononto ulɨmento, Aꞌamuso hopoꞌmaho. Oso hiso Anɨtu yososo hoponoho. ");
INSERT INTO apz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ose ulahonɨngki Pita ulɨmento, Ihwoni, nakwo yoꞌmayo hopiꞌnonohinoso hoꞌnasyontani kikimo tɨfi kinɨngkopalokuhwono. Osoꞌno nakwo peho manehwono. ");
INSERT INTO apz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ose ulahonɨngkofi Jisas ulɨmento, Ngko nehopi waselɨmonneꞌno yohono. Hwangku yoꞌmayo songo iꞌmofaposo sohonta Aꞌamufe Hwomu sohwo kakoe yokumpohnꞌnyoꞌnji hwe engo sohwoe epohumayo wonyoangkafo sopo nohumentanɨngkuhwosi ou, sekwo oso hohosohonta sekwo ngkimo tɨfi nnɨngkapɨwoꞌnɨngkohofo sohwasi sekwo hwe engo sohwoe epohumayo aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sopo nohumatɨkutnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hwe moyaꞌmi hopiꞌnonohinoso hofɨko hofɨkoe ango homnɨngkwaꞌwehwosanji hapiyosɨjanji mpohwo naꞌu mehomi hwaho yoꞌmayoso ngkineꞌno nje hungkunomneꞌno ulɨkoꞌmapijoso i, oso aꞌamu oso hisoꞌno yoꞌmayo piꞌnɨngo engo wopɨngoso mapitnnefoho. Osoꞌnji hofɨko songo neꞌno humayoꞌneso notɨpemapitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Hwe fihwo kako olo hwaho lopo nohumanto hwe engo hwoꞌnyoho syofɨsyalokusoso oso hwe huhwo sohwo Anɨtuye ponemo soso sohwo kako hwe engoꞌmaho. Weꞌyo hweho. Hwe nomꞌnihwo kako olo hwaho lopo nohumanto hwe engo hwoꞌnɨmaho. Weꞌyo hwoꞌnyoho syofɨsyalokuso sohwo oso hwe huhwo sohwo kako Anɨtuye ponemo soso sohwo kako hwe engo imoꞌnone hweho. ");
INSERT INTO apz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Anɨtu aꞌamumo mokosyohumayo soꞌno pahnnɨmo hungkunoso olenoho. Hwe ipisayo syoho kakwo sohwo kako imɨngoꞌnji nowento aꞌamu kakoe ipisayo syoho ulohofiyoꞌne utɨmaꞌmentisofono. ");
INSERT INTO apz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nowento aꞌamu syoho ulohofiyo soꞌnji hungkuno lontɨfi sɨmeho afa inontɨfi olo sɨkuno lomneꞌno hamniyoho kina angaꞌno angaꞌno nano mtitofontɨfi ipisayo syoho hwapɨngo sohwo syoho ulohofiyo somo kakoe syohopono luhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mofehiꞌnyoꞌnji ipisayo syoho hwapɨngo sohwo apaꞌno nowento aꞌamu uhuꞌmokiyo sopo uhwonɨmentisoso aꞌamu fihwa syoho ane sohwa siki humolowentanɨngkofi uhwononto ");
INSERT INTO apz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ulɨmento, Sekwo soku nje ipisayo syohopo syoho ntohofiyɨmno. Ngko hamniyoho itoꞌno wosejapmmonnoho. ");
INSERT INTO apz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ose ulahonɨngki hofɨko umentohofofoho. Ipisae syoho hwapɨngo sohwo syoho ulohofiyo somneꞌento uhwonamo lonto hinjopo umentiso sohwo apaꞌno akupoꞌnyoꞌnji umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mofehiꞌnyo ukwoꞌmokumonto yahonjosoꞌnji ipisayo syoho hwapɨngo sohwo apaꞌno nowento aꞌamu siki humentanɨngkofo somo uhwononto ulɨmento, Olo mofehiꞌnyo noposahonɨngki sekwo syoho miyo pehoꞌno humalofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ose ulahonɨngki ulɨmentohofi, Aꞌamu syoho monejape hnꞌnwi humalohwono. Ose ulahonɨngkofi ulɨmento, Sekwo hisoku nje ipisayo syohoꞌno fɨwanɨmno. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Oseso mofehiꞌnyo moiꞌwo imoꞌnɨngkahonɨngki ipisayo syoho hwapɨngo sohwo kakoe syohomo uhwontohumayo sohumo ulɨmento, Syoho ntohofiyo somo joho ulohoji tɨfinjo pohofo soꞌnji sɨmoꞌmjo pohofo soꞌnjimo hamniyoho uyo. ");
INSERT INTO apz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ose ulahonɨngki aꞌamu sɨkunoꞌnji pmmentohofo somo kina angaꞌno angaꞌno uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aꞌamu sɨmoꞌmjo pmmentohofoso ose uhwonontɨfi ole hnnɨmentohofi, U, nakwo hamniyoho engo womantanoho. Ose hnnɨngkahonɨngkofi hofɨko huhwa kina angaꞌno angaꞌno maꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nomantɨfi ipisayo syoho hwapɨngo sohumo yoka ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ole ulɨmentohofi, Aꞌamu tɨfinjoso syoho weꞌenehwo yahonɨngkofi kɨko hamniyoho nakumo nejapohino hopaso uyohino. Nakwo imɨngoꞌnji ntaꞌnɨngo soꞌnwi syoho tangoꞌnjo yontanɨngkuhwoni mofehiꞌnyo weꞌe nalɨmasoꞌnɨmaho. ");
INSERT INTO apz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ose ulahonɨngkofi ipisayo syoho hwapɨngo sohwo hwe angaꞌno ajwopo lohofontanjo sohumo ulɨmento, Nje aꞌamuhwe, ngko kikimo wonyo makilohofe hwoꞌnyoho. Kɨko ngkoꞌnji hamniyoho kina angaꞌno mayosoꞌno sɨmeho afa minyohwoyaꞌilaho. ");
INSERT INTO apz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Osoꞌno hamniyoho mahoji mpano. Ngko hamniyoho kijapohe paꞌnyoso aꞌamu tɨfinjo somo uyoꞌmanji ");
INSERT INTO apz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","nje syohofoho. Nje hamniyoho soꞌnji yoꞌmayo imeso wopɨngotaho. Ngko hwapɨngo hwoꞌnyoho. Ngko aꞌamumo wopɨngo ulohofo soꞌno sɨmeho wonyo ntapɨwoꞌnɨngkino hwosilaho. Oso hungkunoso syoho hwapɨngo sohwo ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jisas ose ulonto ulɨmento, Aꞌamu tɨfinjo soꞌnji sɨmoꞌmjo soꞌnjimo Anɨtu afaꞌnohino uyɨmo lososo uyɨmontonoho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas Jelusalemneꞌno wasɨmo lonto kakoe inomokomoyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌu sohwa hofɨkoꞌnohino nosontɨfi Jisas ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Upaꞌnɨmno. Olohonta nakwo Jelusalemneꞌno wosantaneꞌno yɨhwono. Osopo Aꞌamufe Hwomu sohumo aꞌamu yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji hofɨkoe ahomo hofɨko hoꞌnasyɨkuji kakineꞌno hungkuno lɨkuji kako poyo umoꞌnono lɨkuji nano wamtitofantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Oseso hofɨko nomꞌne aꞌamu sohwamo uyahonɨngkuji hofɨko sɨtofo ulɨkuji sohwolontamoꞌnji hwanɨngo fonjɨkuji iyo hwajiyofokuꞌnnyo sopo wofonjintoꞌofosyantɨfeho. Sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno kako apaꞌno lɨkafonefono. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Oso hohosohonta Sepetiye apeꞌnji kakoe hwomu sohwaꞌuꞌnji Jisasɨmo uꞌmantɨfi aꞌmusi hwomtame ulohofonto Jisasɨmo hungkuno angaꞌnohino soꞌno ulohonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Oseso Jisas ulɨmento, Pehoꞌno kumoꞌnɨngkohoho. Ose ulahonɨngki ulɨmento, Hwangku sohonta kɨko yofe engo nomahoji aꞌamu hopiꞌnonohinomo mokosyohumuso sohonta kɨko nje hwomu sohwaꞌumo ole ulohoho. Nje aho angahohntaꞌni nje aho hwonamonyo hohntaꞌni fosyohumunyo. Ngko aꞌamu hopiꞌnonohinomo mokosyohumayo soꞌno siko nonɨfoꞌmasyɨhnne hwahusoho. Ose ulohoho. ");
INSERT INTO apz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ose ulahonɨngki Jisas ulɨmento, Oso hungkuno ntohino neso kɨko huno makiyohoyohoho. Tohino ngkimo nɨmnoso hopaso masɨsoso siko hopolaho. Nje aꞌapahomo tohino ifeehuꞌmo yanisyoso hopaso sikoe aꞌapahomo tohino ifeehuꞌmo yasesyososo siko hopolaho. Ose ulahonɨngki ulɨmentisi, Nekwo hoponoho. ");
INSERT INTO apz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ou, nehopeho. Tohino ngko maꞌmeso fehohnjo siko womanjiyoho. Tohino ngkimo ifeehuꞌmokonisyoso paꞌnyoso sikoe aꞌapahomo ifehuꞌmokasesyonefoho. I, oso hisoꞌno ngkoꞌnji aꞌamumo mokosyohumayo soꞌno nje aho angahohntaꞌni nje aho hwonamonyo nohntaꞌni fosyohumayo soꞌno aꞌamu nomꞌne somo muhwosopoꞌmnehono. Oꞌo, oso hopo sopo nje Mpohwo kako aꞌamumneꞌno esyohumaho. ");
INSERT INTO apz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ose ulɨmentisoso inomokomoyo nomꞌne sohwa nupaꞌnontɨfi hofɨko Jemɨsɨꞌnji Jounꞌntnneꞌno sɨmeho tohino umnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","I oso hisoꞌno Jisas kakoe inomokomoyo sohwamneꞌno ngkiyepono wapɨfento joho ulonto ulɨmento, Olo soꞌno sekwo huno seyohoho. Olo hwaho lopo aꞌamu nomꞌne somo mokosyohumayoso hofɨko hofɨkoe aꞌamu enjwaꞌmjo somo syoho tangoꞌnjo uyontɨfeso aꞌamu enjwaꞌmjoso syoho hiso itoꞌno miyoꞌnjo ifijoꞌmanji hwe mokosyohumayo sohwa ikujoho woposantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sekwoe aꞌamu fihwo yofe engo womaꞌmo loso sohwo kako aꞌamufe syoho ulohofiyo umoꞌnono. ");
INSERT INTO apz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Sekwoe aꞌamu fihwo ngko nomꞌne somo womokosyohumamo loso sohwo kako nomꞌne somneꞌno siki syoho ulohofiyo paꞌnyo umoꞌnono. ");
INSERT INTO apz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Oso paꞌnyo Aꞌamufe Hwomu sohwo kako aꞌamu nomꞌneso kakimo syoho ufoꞌmayoꞌne pmmentisoꞌmaho. Oꞌo, hofɨkoe syoho ulohofiyoꞌne pmmentiso hweho. Kako aꞌamu sɨkwoꞌmjohohosi humentanɨngkofo somo uhwononto asomo utɨmayoꞌne kakoe honɨyo usohumaꞌmneꞌento pmmentiso hweho. ");
INSERT INTO apz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas kakoe inomokomoyo sohwanji ango Jelikou ulɨkoꞌmantɨfi pahonɨngkofi aꞌamu piꞌnɨngo engo Jisasɨmo tɨfi inɨngkapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hwe tɨmpiꞌnyo hufaꞌu sohwaꞌu Jisas palofoho upaꞌnonji honɨngkano momɨngopo nohumanji Jisasɨneꞌno joho ole ulɨmentisi, Ntefitɨye Imu hwosoho. Kɨko nekumneꞌno hitoho wakilofono. ");
INSERT INTO apz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ose ulahonɨngki aꞌamuso yoka ulɨmentohofi, Siko mampiꞌnyo fosyohumunyo, Ose ko ulahonɨngkofi oso huhwo sohwaꞌu joho engo ulɨmentisi, Hwe Engofo, Ntefitɨye Imu sohwosi, nekumneꞌno hitoho wakilofono. ");
INSERT INTO apz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ose ulahonɨngki Jisas nolohofonto sikineꞌno joho ulonto ulɨmento, Ngko sikimo pipi selohoꞌmnehono. ");
INSERT INTO apz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ose ulohonɨngkahonɨngki siko ulɨmentisi, Hwe Engofo, kɨko nekwoe tɨmo wopɨngo wemokonontayoꞌno kilalokuhwoyo. ");
INSERT INTO apz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ose ulahonɨngki Jisas sikineꞌno hitoho ulofahonɨngki sikoe tɨmopo aho kisosyahonɨngki tɨmoso komoꞌno itoꞌno hononji Jisasɨmo tɨfi inɨngkamentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hofɨko Jelusalem mofone sopo iꞌmofapontɨfi ango Mpetɨfase hwofɨkiꞌnyo Oulif osopo humamentohofofoho. Osopo Jisas nohumanto kakoe inomokomoyo sohwaꞌumo ole lɨhwatɨmento, ");
INSERT INTO apz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Siko oso ango weꞌe nonjo lopo nuhusɨsi oso hopo sopo siko ahwomo yahu toungki hofɨko impe intofahumalofoso kakoe mu hiꞌnji wotɨpemanjiyoho. Oso yahu sohwaꞌu ikwolofo mahosɨsi ngkiyepono motapinyo. ");
INSERT INTO apz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","I hwe fihwo sikimo hungkuno selɨhwosoꞌnoꞌmanji ole ulinyo. Nakwoe Hwe Engo sohwo kako olo yahu lohumneꞌno syoho weho. Ose ulahosisyoꞌno kako komoꞌno uhwojapmmontonoho. Ose lɨhwajɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Oso hiso imoꞌnɨngkahonɨngki oso aꞌamu sohumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwoe hungkuno ne imoꞌnɨmentisofoho. Hungkunoso olenoho. ");
INSERT INTO apz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Aꞌamu ango Saiyon sopo humalofo somo ole ulɨmno. Uhwonɨmno. Sekwoe Hwe Engo sekuyepono ntopohoho. Kako hwe yofe ane paꞌnyo ahwomo yahupo kehumaho. Oso yahu hiso hoꞌyango mokahoꞌnyoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Oseso inomokomoyo hufaꞌu sohwaꞌu nowenji yoꞌmayo Jisas ulɨmentiso hopa imentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Siko yahu konaꞌwohiꞌnji kakoe muꞌnji nomotaponji sikoe manjiꞌmofoso yahupo miyopeehumentisiye sopo Jisas kehumamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hwe moyaꞌmi piꞌnɨngo engoso hofɨko hofɨkoe hwapɨfe Jisas kako hano wene honɨngkano sopo huꞌmeehumentohofofoho. Aꞌamu fehohnjo ipamo lopoꞌmemantɨfi Jisasɨye yofe hoꞌnomayoꞌne honɨngkanopo huꞌmeehumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hwe hwoyaꞌmi sɨmoꞌmjo soꞌnji tɨfinjo soꞌnji hofɨko joho ole lɨmentohofi Ntefitɨye Imu sohwoe yofe wohoꞌnomano. Kako wopɨngoꞌnohini hweho. Olo hwe lohumo nakwoe Hwe Engo Anɨtu sohwo nakwoe hwahoponeꞌno uhwatɨmentiso hweho. Kakoe yofe wohoꞌnomano. Anɨtu ahwomomo humaso sohumo isamoyoka ulano. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas Jelusalemno noswahonɨngki oso hopo soponjo hwe moyaꞌmi hofɨko yomo yontɨfi ulɨmentohofi, Olo hwe lohwo tɨhwolo. ");
INSERT INTO apz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ose ulohonɨngkahonɨngkofi hwe moyaꞌmi Jisasɨꞌnji pmmentohofoso ulɨmentohofi, Olo Jisas Anɨtuye hungkuno lɨwoꞌnɨngkiso hweho. Ango Nasalet hwaho Ngkalilintaꞌango hweho. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas Anɨtuye tajo ango engo somjo mempo ango somo noswonto aꞌamu yoꞌmayo mpe yontanɨngkofo somo wae yaoꞌmentisofoho. Hofɨkoe ijempoho hamniyoho iwoloꞌmokomayo yontɨfe hoꞌnasiyoꞌne soꞌnji aꞌamu yɨhufo mpe uyantɨfi epohumayo yɨwoꞌnɨngkohofoso Jisas kako mehuꞌmeeꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wayo yaofonto Jisas ulɨmento, Aꞌamu Anɨtuye hungkuno mtɨꞌmokumento sohwa ole mtɨꞌmokumentohofi, Olo nje ango somneꞌno ole lɨfitnnefoho. Mpohumo jomo ujoꞌne angofoho. I oso hisoꞌno nje ango loso sekwo aꞌamu hamniyoho hiyasoꞌmo hufo mawoꞌnɨngkohofo sohwafe ango hopa imokalokwofo. Ose mtɨꞌmokumentohofofoho ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas tajo angomo nohumentanɨngki aꞌamu tɨmpiꞌnyo soꞌnji sɨfe wonyoꞌnjo soꞌnji kakimo uꞌmaꞌmentohofofoho. Nuꞌmahonɨngkofi Jisas wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Oseso hwe yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwayo syohoꞌnjo sohwanji hofɨko uhwonɨmentohofoso Jisas aꞌamu wopɨngo umokumentisoso uhwonontɨfi upaꞌnɨmentohofoso mehomi tajo ango somo Jisasɨmneꞌno joho ulɨmentohofi, Ntefitɨye Imu sohwoe yofe wohoꞌnomano. Ose lontanɨngkofi nupaꞌnontɨfi hofɨko sɨmano hintotohino umnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sɨmano hintotohino umnɨngkahonɨngki Jisasɨmo ulɨmentohofi, Olo hungkuno mehomi lohwa lalokwofo loso nto lupaꞌnɨngkino. Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Ou, upoꞌnalokweno. Sekwo olo hungkuno losoꞌno huno maseyoꞌnjotaho. Hungkuno ole, Mehomi engo soꞌnji mehomi milongo soꞌnji jɨje yofe wohoꞌnokumapɨfe. ");
INSERT INTO apz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ose ulonto, nuhwotɨꞌmofonto Jelusalem mtaꞌni noswaponto ango Mpetaniꞌno nowento osopo saho fosyawoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Imɨngoꞌnji Jisas Jelusalemno asomo sɨmentisoso mijoho engo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kako uhwonɨmentisoso ikwongo honɨngkano lopo lohofontanɨngki uhwononto oso hopo sopono umentisofoho. U, oso homo somo ikwonjayo anefoho. Swoꞌnohinofoho. Ose uhwononto Jisas iyo somo ulɨmento, Kɨko ne apaꞌno mintoꞌnɨngkohotnnehino. Nɨhuꞌnahone hwosoho. Ose ulahonɨngki iyoso yofoho komoꞌno imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kakoe inomokomoyo sohwa oso hiso nuhwonontɨfi hofɨko yomo imentohofofoho. Yomo yontɨfi lɨmentohofi, Oso iyo yofoho komoꞌno isoso pipilo. ");
INSERT INTO apz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ose ulahonɨngkofi Jisas ulɨmento, Ngko nehopi waselɨmonneꞌno yohono. Sekwoe sɨmeho hiꞌntnnono nehopi ufijoso u, sekwo sɨmeho hufaꞌu ane hwasɨꞌmanji sekwo ngko iyo lomo ulohe hopaso uyantɨfeho. Osoꞌnohinɨꞌmaho. Oꞌo, sekwo sɨmeho hiꞌntnnono nehopi ufijoꞌmanji sekwo olo hwofɨkiꞌnyo lohumo ole ulɨfijoso, Kɨko nolɨkafohoji oso mijo ayo mompo fɨlɨkofaofo. Ose ulɨfijoso hwofɨkiꞌnyo sohwo wawontonoho. ");
INSERT INTO apz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","U, sekwo sɨmeho hiꞌntnnono nehopi uyɨkuji yoꞌmayo soꞌno Mpohumo jomo ulɨfijoso womantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas tajo angomo asomo swonto aꞌamumo lutɨhwentanɨngki aꞌamu yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji Isɨlaelɨfe hwe engo sohwanji hofɨko nuꞌmantɨfi ulɨmentohofi, Kɨko olo syoho iwoꞌnɨngkino loso tɨhwo kilɨmasoꞌno iwoꞌnɨngkinoto. Yokumpohnꞌnyoso tɨhwo kijapmmasoꞌnji iwoꞌnɨngkinoto. ");
INSERT INTO apz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ose ulahonɨngkofi Jisas ulɨmento, Ngko huhwoꞌnyi hungkuno angaꞌno waselohonɨmneꞌno yohono. Olo hungkuno hiloso sekwo asomo ntɨfijoꞌmanji eꞌwa, yoꞌmayo yalokwe soꞌno hwapɨngo waselɨmo. ");
INSERT INTO apz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Joun aꞌamumo mijo kiyomaꞌmojo sohwo kakoe yokumpohnꞌnyo hwapɨngoso ntɨꞌmtaꞌangoto. Anɨtu mtaꞌangotaho. Hwahoponjo aꞌamu mtaꞌangotaho. Ose ulohonɨngkahonɨngki hofɨko ole hnnɨmentohofi, Joun kakoe yokumpohnꞌnyo Anɨtu mtaꞌni maꞌmentisofoho ulasoꞌmanji ole wonalɨmontonoho. Oseꞌmanji sekwo Jounɨye hungkunomo sɨmeho hiꞌntnnono muyoꞌnjo pehoꞌneto. ");
INSERT INTO apz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","I, Joun kakoe yokumpohnꞌnyo hwahoponjo aꞌamu mtaꞌni maꞌmentisofoho ulasoꞌmanji hwe moyaꞌmi peho nalohopitnnehofo. Osoꞌno iyoho nenalofoho. Hwe moyaꞌmi hiso ole syafɨsyɨwoꞌnɨngkohofi, Anɨtu kako Jounɨmo hungkuno uyahonɨngki nalɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ose hnnontɨfi Jisasɨmo ulɨmentohofi, Nakwo huno monayohoyohoho. Ose ulahonɨngkofi Jisas hofɨkimo ulɨmento, Oseꞌmanji ngko huhwoꞌni nje yokumpohnꞌnyo yoꞌmayo iwoꞌnɨngkohe hwapɨngo soꞌno maselɨmnehono. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Olo hungkuno selohe soꞌno sekwo huno pipi seyohoho. Hwe fihwo kako hwomu hufaꞌuꞌnjo hweho. Kako hwomu tisɨmaso sohumo ulɨmento, Nje hwomufo, olohonta nuhuji ipisayo syohomo syoho ntohofiyo. ");
INSERT INTO apz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ose ulahonɨngki kakoe hwomu sohwo ulɨmento, Ngkilaho. Ose ko ulonto hwangku kako huno esyafɨsyonto syoho ulohofimentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Oseso kanɨngkwohwo nomꞌne hwomu sohwoepono nowento oso hungkuno tisɨmaso sohumo ulɨmentisoso apaꞌno, Ulahonɨngki hwomu sohwo ulɨmento, Ou, Mpohwo, ngko syoho wakilohofimo. Ose ko ulonto kako syoho somneꞌno mawommentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Osoꞌno huno pipi seyohoho. Oso hwomu sohwaꞌu kanɨngkwohwoe hungkuno somo tɨhwo inɨngkamentono. Ose ulohonɨngkahonɨngki, Sɨmoꞌmjo sohweho ulɨmentohofofoho. I, Jisas ulɨmento, Ngko hungkuno hisoꞌno yolohoꞌnohini waselɨmonneꞌno yohono. Aꞌamu honɨngkano wonyoꞌnjo hamniyoho mayo syohoꞌnjo sohwanji moyaꞌmi hwaꞌnte sofa honɨngkano wonyo imofɨwoꞌnɨngkohofo sofanji hofɨko sɨmoꞌmo Anɨtuye honɨngkano soꞌno nakwolaho lontɨfi olohonta sɨmeho yɨwoloꞌmokalokwofo. Osoꞌno Anɨtuye ango soponeꞌno sɨmoꞌmo sepopitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Hwapɨngoso Joun aꞌamumo mijo kiyomaꞌmojo sohwo sekuyepono pmmentisofoho. Kako honɨngkano wopɨngo imofo setɨhwamentiso soꞌno i, sekwo sɨmeho hiꞌntnnono muyo hwasoho. I, aꞌamu hamniyoho mayo syohoꞌnjo sohwanji moyaꞌmi honɨngkano wonyo imofɨwoꞌnɨngkohofo sofanji hofɨko Jounɨye hungkunomo sɨmeho hiꞌntinnono uyɨmentohofofoho. Sekwo oso hisoꞌno ko uhwonontɨfi sekwo huno mɨkwesyafɨsiyoꞌnjo yontɨfi sɨmeho hiꞌntnnono muyo hwasoho. ");
INSERT INTO apz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas ulɨmento, Sekwo pahnnɨmo hungkuno nomꞌne upaꞌnɨmno. Hwe fihwo hwaho engoꞌnjo sohwo kako ipisayo syoho hulonto tojo emontofasyonto syoho ajwomoꞌmo ipisayo mijoꞌne kompusyoho mtɨꞌmokumentisofoho. Ose yonto ango yokintahopo ipisayo syoho somo uhwontohumayoꞌne molɨmentisofoho. Ose imentisoso kako oso syoho homo somo mokosyohumayoꞌne kako aꞌamu hamniyoho syoho emawoꞌnɨngkohofo sohwafe ahomo hoꞌnosyonto kako ango ikanopo nawento osopo neꞌno humamojofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Hwangku ipisayo ne mayo sohonta kakoe syoho ulohofiyo sohwamo kakoe ipisayo fehohnjoꞌne kakoe ipisayo syoho poneꞌno uhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Uhwojahonɨngki aꞌamu ipisayo syoho mokosyohumayo sohwa kakwoꞌyohwoe syoho ulohofiyo sohwamo maꞌmentohofofoho. Angaꞌnohino sohumo hwanɨngo fonjontɨfi nomꞌne sohumo sojoꞌnji fongkuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ose ulohofahonɨngkofi kakwoꞌyohwo nomꞌne syoho ulohofiyo piꞌnɨngo sohwamo uhwatɨmentisofoho. Sɨmoꞌmjo uhwatɨmentiso sohwa piꞌnɨngoꞌmaho. Oso aꞌamu ipisayo syoho mokosyohumayo huhwo sohwa syoho ulohofiyo sɨmoꞌmjo hopaso tɨfinjo sohwamo wonyo ulohoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hwangku sohonta kakwoꞌyohwo kakoe hwomu sohumo uhwatɨmentisofoho. Uhwajonto lɨmento, Hofɨko nje hwomufe hungkunomo haloho upeentɨfeho. Ose lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","I, aꞌamu ipisayo syoho mokosyohumayo sohwa kakoe hwomu huhwo sohumo uhwonutɨmantɨfi ole hnnɨmentohofi, Olo aꞌamu lonwo sohwo kako hwangku sohonta kanɨngkwohwoe yoꞌmayoso nomane hweho. Komoꞌnohino nakwo kakimo poyo wofonjosyano. Oseso olo kakoe syoholo maneꞌeno. ");
INSERT INTO apz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ose hnnontɨfi hwomu sohumo nutɨmantɨfi mempo hohntaꞌni ipisayo syoho sopo swohoꞌnaofontɨfi osopo poyo nɨhuꞌnohone fonjahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Sekwo huno pipi seyohoho. Hwangku oso ipisayo syoho kakwoꞌyohwo sohwo kako nopɨhwosi aꞌamu syoho mokosyohumayo huhwamo pipi ulohoꞌmontolo. ");
INSERT INTO apz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ose ulohonɨngkahonɨngki aꞌamu sohwa Jisasɨmo ulɨmentohofi, Kako nopɨhwosi aꞌamu huhwo sohwamo nɨhuꞌno wonyo ulohofɨhwosi poyo umokumontonoho. I ose yososo kako kakoe ipisayo syohoso nomꞌne aꞌamu mokosyohumayo sohwamo umontonoho. Osohwa sɨkuno ipisayo ne mjiyo sohonta hofɨko kakwoꞌyohumo neso uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ose ulahonɨngkofi Jisas ulɨmento, Anɨtuye hungkuno losoꞌno sekwo huno maseyoꞌnjotaho. Hungkuno ole, Olo sojo engkwosaho paꞌnyo aꞌamu ango injuwoꞌnɨngkohofo sohwa wae yaoꞌmentohofo loso, olohontajo engkwosaho loso angomo sosofitofoꞌne hwapɨngohwo imoꞌnɨngkohoho. Nakwoe Hwe Engo sohwo ole lɨmentisoso imoꞌnɨmentisofoho. Nakwo olo soꞌno uhwonontaneso wonyoangkafofoho lalokuhwono. Oso pahnnɨmo hungkunoso Anɨtu lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Oseso ngko sekumo waselɨmonnꞌno yohono. Anɨtu kako aꞌamumo mokosyohumayo sopo sekwoe angoso sekumtaꞌni semahwosi nomꞌne aꞌamu ne wopɨngo itoꞌnohino somo umontonoho. Ose ulonto pahnnɨmo hungkuno aꞌamu kakimneꞌno minɨngkayoꞌnjo somneꞌno ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Olo engkwosaho losoꞌno seloheso aꞌamu fihwo oso sojo engkwosaho paꞌnyo homo somo entofomahwosi pɨwasyososo oso aꞌamu hiso kakoe aꞌapaho kempi mtɨꞌmtɨꞌme lohofɨhwosi wahuꞌmehinawoꞌmontonoho. I, osoꞌno oso engkwosaho huhwo sohwo kako aꞌamu fihwoe aꞌapahopo pɨwasyososo fonjomtɨhupeeofososo oso hwe huhwo sohwo kakoe aꞌapahoso hintalinyo piꞌnɨngo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aꞌamu yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji aꞌamu Falisi sohwanji Jisasɨye pahnnɨmo hungkunomo upaꞌnontɨfi hofɨkineꞌno hungkuno hiloso lɨmentiso soꞌno huno umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Oseso hofɨko kakimo aho wokantɨfi ko imentohofoso hofɨko hwe moyaꞌmimneꞌno iyoho unɨmentisofoho. Hwapɨngoso hwe moyaꞌmi ole syafisyɨwoꞌnɨmentohofi, Jisas sohwo Anɨtuye hungkuno lɨmojo hweho. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas pahnnɨmo hungkuno apaꞌno aꞌamu somo ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Anɨtu aꞌamumo mokosyohumayo soꞌno olo paꞌnyofoho. Hwe yofe engoꞌnjo kakoe hwomu ape mante elɨjwanɨwoꞌnɨngkohofo paꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Sɨmoꞌmo kako aꞌamu piꞌnɨngo engo elɨjwanyo wosopayo nɨfitnneꞌento uhwosopoꞌmentisofoho. Oso hohosohonta wopayo elɨjwanyo sɨkuno somo kakoe syoho ulohofiyo sohwamo aꞌamu uhwosopoꞌmentiso sohwa pɨfitnneꞌento utɨmayoꞌne lɨhwatɨmentisoso hofɨko nakwolaho ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Osoꞌno syoho ulohofiyo nomꞌne sohwamo lɨhwajonto ulɨmento, Aꞌamu uhwosopoꞌmentohe somo ole ulɨmno. Wopayo nto lɨkuꞌmaho. Nje yahuꞌnji tongoꞌnji fonjasyontɨfi lɨkuꞌmaho. Sekwo oyonɨmno. Ose ulɨmno. ");
INSERT INTO apz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ose ulahonɨngki nowahonɨngkofi aꞌamu uhwosopoꞌmentisoso hahnꞌnyo yontɨfi hofɨko hofɨkoepi syohoꞌmno humpoꞌmentohofofoho. Nomꞌnihwo kakoe wopayo syohomno umentisofoho. Nomꞌnihwo kakoe kwope syohomno umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nomꞌneso hwe engo sohwoe syoho ulohofiyo sohwamo wonyo ulohofontɨfi fehohnjo sohwamo hwanɨngo fonjahonɨngkofi nomꞌne sohwamo fonjahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Oseso hwe engo sohwo sɨmeho tohino umnɨngkahonɨngki kakoe aꞌamu itokusoꞌnjo sohwamo luhwatɨmento, Sekwo aꞌamu nje syoho ntohofiyo sohwamo fonjahumalofo somo nofonjasyɨkuji hofɨkoe ango toho fɨhmꞌmopmno. Ose luhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ose yahonɨngkofi hwe engo sohwo kakoe syoho ulohofiyo sohwamo ulɨmento, Nje wosopayo nto lɨkuꞌmaleno. I, aꞌamu uhwosopoꞌmentohe sohwafe yahino hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Osoꞌno sekwo honɨngkanoꞌmeemo humpekuji aꞌamu nuhwonɨngkuji nje wosopayoꞌne ulɨmno. Sekwo nakwoꞌnji wohwano. Ose ulɨmno. ");
INSERT INTO apz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ose ulahonɨngki syoho ulohofiyo sohwa honɨngkanoꞌmeemo nohumpentɨfi aꞌamu hopiꞌnono wopɨngoꞌnji wonyoꞌnji uhwonɨmentohofo somo lɨtɨmantɨfi utɨmotapmmentohofofoho. Osoꞌno hwe yofe engoꞌnjo sohwoe ango somo uhuꞌmokumentohofofoho. Ango hiso aꞌamu hopo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Hwe moyaꞌmi angomo nohumentanɨngkofi hwe yofe engoꞌnjo sohwo kako aꞌamu swahopohofo somo uhwonɨmo lonto noswonto uhwonɨmentisoso hwe fihwo kako manjiꞌmofo wonyoꞌnjo sohwo nohumentanɨngki uhwononto, ");
INSERT INTO apz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ulɨmento, Nje aꞌamu sohwosi, olo sɨkuno lomo nje hwomu ape masoloꞌno welɨjwonantaneꞌno yalokuhwono. Osoꞌno kɨko manjiꞌmofo songo miyoꞌnjo yonji pehoꞌno swaponji humahnno. Ose ulahonɨngki hwe huhwo sohwo mampinyo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Oseso hwe engo sohwo kakoe syoho ulohofiyo sohwamo ulɨmento, Olo hwe lohwo kakoe sɨfe aho nano mtitofɨkuji mempo hohntaꞌni sɨkwoꞌmjoho soꞌmo fohoꞌnaopmno. Osopo aꞌamu humotaho engo lɨkuji hulɨngkwajingo ifalohoꞌnɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ose ulonto Jisas ulɨmento, Anɨtu aꞌamu piꞌnɨngo engo somneꞌno woswapɨfe lonto joho ko ulonteso i, aꞌamu angaꞌno angaꞌnohino somo uhwosopoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Aꞌamu Falisi sohwa nuhuꞌmokontɨfi hungkuno hnnɨmentohofi, Jisas nakumo hwasyo hungkuno naloneꞌno pipi ulohofanehwono. Hwasyo hungkuno nalɨhwosoꞌno impoꞌangomo untofosyano. Osoꞌno nohnnontɨfi ");
INSERT INTO apz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","hofɨko hofɨkoe inomokomoyo fehohnjo sohwanji Helout kakoe inomokomoyo fehohnjo sohwanjimo luhwo jahonɨngkofi Jisasɨmo nuꞌmantɨfi ulɨmentohofi, Nakwoe Lonetɨhwayo sohwosi, kɨko hungkuno nehopiꞌnohini lɨwoꞌnɨngkino soꞌno nakwo huno nayohoho. Kɨko Anɨtuye yahino soꞌno aꞌamu somo itoꞌnohini lutɨhwawoꞌnɨngkino hwosoho. Aꞌamu kikineꞌno huno wonyo syakufɨsiyo soꞌno kɨko iyoho makinyofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Osoꞌno kɨko olo hilo soꞌno jɨje huno mtaꞌango fonaso. Nakwo hwe yofe engoꞌnjo Sisa kako hwaho mokosyohumayo sohumneꞌno hamniyoho (takis) hoꞌnasiyoso wopɨngotaho. ");
INSERT INTO apz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ose ulahonɨngkofi Jisas kako hofɨkoe yahino kakimo yamofo ulohofoꞌne soꞌno huno uyahonɨngki ulɨmento, Sekwo hwasyo hungkuno hwapɨngoꞌnjo hwasoho. Sekwo ngkimo yamofo pehoꞌno ntohofalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sekwo ngkimo hamniyoho angaꞌno ntɨhwamno. Ose ulahonɨngki hofɨko hamniyoho angaꞌno kakiyepono motapontɨfi utɨhwamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Oseso Jisas hamniyoho somo uhwononto ulɨmento, Olo huyoꞌmango loꞌnji yofe loꞌnji tɨhwoeto. ");
INSERT INTO apz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ose ulahonɨngki ulɨmentohofi, Sisafefoho. Ose ulahonɨngkofi Jisas ulɨmento, Eꞌwano, Sisafe yoꞌmayo soꞌmanji Sisamo uyimno. I Anɨtuye yoꞌmayo soꞌmanji Anɨtumo uyɨmno. ");
INSERT INTO apz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ose ulahonɨngki nupaꞌnontɨfi hofɨko yomo yontɨfi Jisasɨmo ulɨkoꞌmantɨfi umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Oso sɨkuno homo somo aꞌamu Satɨyusi fehohnjo Jisasɨmo uꞌmaꞌmentohofofoho. Oso aꞌamu huhwo sohwa ole lutɨhwawoꞌnɨngkohofi, Aꞌamu poyo peꞌnyo sohwa hofɨko nɨhuꞌnahone peꞌnɨwoꞌnɨngkohofo. Apaꞌno songo molɨkafeꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Oso aꞌamu Satɨyusi Jisasɨmo ulɨmentohofi, Nakwoe Lonetɨhwayo sohwosi, Mouses ole lutɨhwamentono. Hwe fihwo mehomi ane sohwo poyo peꞌnososo konɨngkwaꞌwehwo kakoe apemo womaꞌmontonoho. Oso hwe huhwo sohwo kolaꞌwehwoe pijohinomneꞌno konɨngkwaꞌwehwo mehomi wotɨpemaꞌmtonoho. Ose lutɨhwamentono. ");
INSERT INTO apz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oseso hwe aho fehohnjo hopiꞌnono nomꞌni mtaꞌni hufaꞌu sohwa humamotofofoho. Tisɨmaso sohwo ape maꞌmentisofoho. Nomanto mehomi motɨpemasoꞌnjo peꞌnɨmentisofoho. Nopeꞌnɨngkahonɨngki konɨngkwaꞌwehwoe apeso maꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Oseso akuꞌmu sohwo ose imentiso soꞌno oseꞌnohini mjɨmɨwentɨfi ae usaho sohwo peꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Oso hwe hopiꞌnono peꞌnɨngkahonɨngkofi ape hiso kako tɨfi peꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eꞌwano. Ole fonaso. Aꞌamu poyo peꞌnɨfijoso songo lɨkapijo sohonta oso homnɨngkwaꞌwehwo sohwa olo ape losi tɨhwo womaꞌmontolo. Hwaho lopo hopiꞌnono maꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo Anɨtuye hungkuno soꞌnji Anɨtuye yokumpohnꞌnyo soꞌntnneꞌno huno maseyohoyohoho. Osoꞌno hwasyo hungkuno ntohofo. ");
INSERT INTO apz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aꞌamu poyo peꞌnɨmentohofoso lɨkapijo sohonta hwe moyaꞌmi ape momasoꞌnjo ifitnnefoho. Oꞌo, hofɨko aꞌamu ahwomomjo ape momasoꞌnjo paꞌnyo imoꞌnɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","I, aꞌamu poyo peꞌnyoso songo lɨkapitnne soꞌno Anɨtu nalɨmentiso soꞌno huno maseyoꞌnjotaho. ");
INSERT INTO apz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Anɨtu ole nalɨmento, Ngko Apɨlohamja Aisakɨja Jekoupɨjafe Anɨtu hwoꞌnyoho. Ose nalɨmentisofoho. Oso aꞌamu hiso ahwomomo songo humalofo. Anɨtu kako poyo peꞌnyo sofe Anɨtu hwoꞌmaho. Oꞌo, kako aꞌamu songo humalofo sofe Anɨtuyoho. ");
INSERT INTO apz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Olo hungkuno loso ulahonɨngki hwe moyaꞌmi hofɨko yomo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Olo hungkuno Jisas aꞌamu Satɨyusi sohwamo ulahonɨngki hofɨko hungkuno nomꞌne majo. Mampiꞌnyo humamentohofofoho. Aꞌamu Falisi upaꞌnɨmentohofoso aꞌamu Satɨyusi mampiꞌnyo humamentohofoso nupaꞌnontɨfi Jisasɨꞌnjopo uhuꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Hofɨkoꞌnjo ajwo lopo hwe fihwo honɨngkano hungkuno lutɨhwayo syohoꞌnjo sohwo Jisasɨmo yamofo ulohoꞌmo lonto ole ulohonɨmento, ");
INSERT INTO apz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Anɨtuye hungkunomo inɨngkayoso nomꞌne hungkuno somo yakoloꞌnnyoso ntisoto. ");
INSERT INTO apz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ose ulohonɨngkahonɨngki Jisas ulɨmento, Hungkuno ole, Kɨko jɨje Hwe Engo Anɨtu sohuneꞌno sɨmeho uyohoji jɨje sɨmeho hopiꞌnonohinoso kakimo uyo. Kɨko jɨje Hwe Engo sohuneꞌno jɨje sɨmeho uyohoji jɨje huyoꞌmango hopiꞌnonohinoso kakimo uyo. Kɨko jɨje Hwe Engo Anɨtu sohuneꞌno jɨje sɨmeho uyohoji jɨje huno hopiꞌnonohinoso kakimo uyo. ");
INSERT INTO apz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Olo hungkuno loso inɨngkayoso nomꞌne somo hwofiloꞌnnyofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hungkuno tɨfinjoso sɨmoꞌmjo paꞌnyofoho. Ole, kɨko hi kumoꞌnonto sɨmeho kumoꞌnɨwoꞌnɨngkiso paꞌnyoso aꞌamu nomꞌnemneꞌno kɨkoꞌnjo mofone sopo humalofo somo uyo. ");
INSERT INTO apz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Oso hungkuno sofaꞌu honɨngkano hungkuno soꞌnji aꞌamu Anɨtu hungkuno uyahonɨngki lutɨhwamotofo sohwafe hungkuno soꞌnjimo hwapɨngo woꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Aꞌamu Falisi nuhuꞌmokontɨfi nohumentanɨngkofi Jisas ulohonɨmento, ");
INSERT INTO apz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Sekwo Kɨlais Anɨtu uhwosopoꞌmentiso sohumneꞌno huno pipi seyohoho. Tɨhwoe imu hwolo. Ose ulohonɨngkahonɨngki hofɨko ulɨmentohofi, Ntefitɨye imu hweho. ");
INSERT INTO apz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ose ulahonɨngkofi Jisas ulɨmento, I, Ntefit Kɨlais sohumneꞌno nje Hwe Engofo lɨmentiso sohonta olo hungkuno hilo soꞌno Anɨtuye Towahuno Ntefitɨye hunomo pehoꞌno hoꞌnahumentono. Ntefit ole ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Anɨtu kako nje Hwe Engo Kɨlais. Anɨtu nakwoe hwahopo lɨhwatɨmentiso sohumo ole ulɨmento, Kɨko nje aho anga sohohntaꞌni fosyohumaho. Osopo kɨko nohumahoji ngko jɨje mango sohwamo jɨje sɨfɨkiꞌnyoꞌmo enjwaꞌmo wokuhumatɨꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Oso Hwe Engo huhwo sohuneꞌno Ntefit nje imu hweho mulɨmmentono. Oꞌo, nje Hwe Engofo ulɨmentisofoho. Osoꞌno oso hwe huhwo sohwo Ntefitɨye imuꞌnohino hwolaho. ");
INSERT INTO apz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ose ulohonɨngkahonɨngki hwe nomꞌne Jisasɨye hungkunomo asomo mujoꞌnjo imentisofoho. Oso sɨkuno somo oso aꞌamu Falisi sohwa Jisasɨmneꞌno iyoho unomaꞌmentisofoho. Osoꞌno hofɨko Jisasɨmo hungkuno nomꞌneꞌno mujoꞌnjo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hwangku sohonta Jisas kako hwe moyaꞌmi soꞌnji kakoe inomokomoyo sohwanjimo hungkuno lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kako ole ulɨmento, Aꞌamu honɨngkano hungkuno lutɨhwamotofo syohoꞌnjo sohwanji aꞌamu Falisi sohwanji hofɨko hofɨkoe yofemnohini hoꞌnomaꞌnyoꞌne Mousesɨye hungkuno yoloho losetɨhwawoꞌnɨngkohofɨhwafoho. ");
INSERT INTO apz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Osoꞌno oso hungkuno hofɨko losetɨhwawoꞌnɨngkohofoso sekwo haloho nopekuji tɨfi finɨngkamno. I osoꞌno yoꞌmayo hungkuno hofɨkoe huno mtaꞌangoso hofɨkoe yoꞌmayo yahino hofɨko iwoꞌnɨngkohofoso sekwo ikutoho. Oso hungkuno lutɨhwawoꞌnɨngkohofo somo hofɨko koko tɨfi minɨngkayoꞌnjo iwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ose ulonto Jisas aꞌamu huhwo sohwafe hungkunomo inɨngkayoꞌne pahnnɨmo hungkuno ulɨmentisofoho. Aꞌamu huhwo sohwa yoꞌmayo honɨngkano hungkuno hofɨkoe huno mtaꞌangoso hoꞌyango kiꞌyo tangoꞌnjo paꞌnyo imoꞌnyoso hofɨko esyohumantɨfi aꞌamufe hohujopo intofasyɨwoꞌnɨngkohofofoho. I osoꞌno hofɨko aꞌamu hoꞌyango kiꞌyo tangoꞌnjo somo ufoꞌmayoꞌneso ajoꞌmiyoponjo hoꞌyango weꞌe momokahoꞌnyoꞌnjo iwoꞌnɨngkohofofoho. Oꞌo, aneꞌnjo wowoꞌnɨngkohofofoho. Yolohoso ole, oso hungkuno ko lutɨhwantɨfi hofɨko minɨngkayoꞌnjo iwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yoꞌmayo iwoꞌnɨngkohofoso hofɨkoe yofe hoꞌnomayoꞌne aꞌamu wonahonɨfe lontɨfi iwoꞌnɨngkohofofoho. Anɨtuye hungkuno hoꞌyo weꞌe somo hoꞌnasyontɨfi yomohuꞌnyopo ahopo utɨhwaꞌnyopo intofasyɨwoꞌnɨngkohofofoho. Hofɨkoe manjiꞌmofo momɨngo lopo wokoso sawemo engo mtɨꞌmokuwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aꞌamu elɨjwanyoꞌne soꞌnji tajo angomjo soꞌnji nuhuꞌmokuwoꞌnɨngkohofo sopo hofɨko epohumayo sɨmoꞌmjo wopɨngoꞌnohino soꞌno umoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hofɨko antɨme engo ajwo lopo aꞌamu piꞌnɨngo engo uhuꞌmokuwoꞌnɨngkohofo sopo lohofontanɨngkofi aꞌamu hofɨkoe yofe hoꞌnomayo soꞌno umoꞌnɨngkohoho. U, hofɨko nakwoe lonetɨhwayo hwosoho ujoꞌnjo soꞌno umoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Oseso aꞌamu sekumo ole selɨkutoho. Nakwoe lonetɨhwayo hwosoho. Ose selɨkutoho. Oꞌo, Anɨtu angaꞌnohino sohwo sekwoe Hwe Losetɨhwayoꞌne hweho. Sekwo hopiꞌnono afaꞌnohino kuyoho. ");
INSERT INTO apz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Olo hwaho lopo sekwo hwe nomꞌne sohuneꞌno ole lɨkutoho. Olo hwe nakwoe hwe engo lohwo nakwoe mpohweho eso nolɨkutoho. Oꞌo, angaꞌnohino sohwo ahwomomo humaso sohwo sekwoe Mpohweho. ");
INSERT INTO apz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","U, aꞌamu hofɨko ole selɨkutoho. Nakwoe Hwe Engo hwasoho. Ose selɨkutoho. Awonoho. Sekwoe hwe engo angaꞌnohinoꞌnjo kuyoho. Oso huhwo sohwo Kɨlais Anɨtu uhwosopoꞌmentiso hweho. ");
INSERT INTO apz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Oseso sekwoe hwe engo neso kako sekwoe syoho selohofiyo paꞌnyo hweho. ");
INSERT INTO apz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","U, aꞌamu fihwo kako kakoe yofeꞌnohini hoꞌnomaꞌnɨwoꞌnontoso sohumo Anɨtu kako monje weehumontonoho. I, aꞌamu fihwo kakoe yofe somo monje yahinɨngkuhwoso sohumo Anɨtu wopɨngo wonyoangkafo ulohofɨhwosi kakoe yofeso wohoꞌnɨmaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Sekwo aꞌamu honɨngkano hungkuno lutɨhwayo syohoꞌnjo sohwa hnnonji aꞌamu Falisi sohwanji sekwo yoꞌmayo tango seꞌmayo soꞌno iꞌwaho fiyɨmno. Sekwo mangoꞌnohino hwasoho. Sekwo Anɨtu aꞌamumo mokosyohumayo soponeꞌno aꞌamu sofe sɨmanopo honɨngkano pɨjwamo ulohofontɨfeso sekwo soku masyuyoꞌnjo hwasoho. Hwe moyaꞌmi hofɨko woswantɨfi yahonɨngkofi sekwo pɨjumofalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Sekwo aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwa hnnonji aꞌamu Falisi sohwanji sekwo yoꞌmayo tango seꞌmane soꞌno iꞌwaho fiyɨmno. Sekwo mangoꞌnohino hwasoho. Sekwo Anɨtumo hungkuno sawemo engo jomo ulontɨfi sekwo apɨwojo sofafe ango yoꞌmayo soꞌno wosemokosyohumano poji ulontɨfi ango hiso sekwo nɨhuꞌnahone emawoꞌnɨngkohofɨhwasoho. Oseso hwangku sekwo tohino engo notɨpemapitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Sekwo aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwa hnnonji aꞌamu Falisi sohwanji sekwo yoꞌmayo tango seꞌmae soꞌno iꞌwaho fiyɨmno. Sekwo mangoꞌnohino hwasoho. Sekwo mijopo hwahopo angoꞌmeemo emoyɨwoꞌnontɨfi aꞌamu tɨfi senɨngkayoꞌne tɨpewoꞌnɨngkohofofoho. Notɨpemantɨfi sekwoe inomokomoyo imokuwoꞌnɨngkohofɨhwasoho. Oseso kako Setenɨye mehomi sekwo hopa imoꞌnonto kakoe yahino wonyoso sekumo yakolonoho. ");
INSERT INTO apz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Aꞌamu Falisi sohwa Anɨtumneꞌno huno itoꞌno mosyafɨsiyoꞌnjo yontɨfi yoꞌmayo wonyoꞌwonyo yahino yontɨfe soꞌno Jisas yoka ulɨmentisofoho. Sekwo tɨmpiꞌnyo sohwasi sekwo aꞌamu nomꞌne somo honɨngkano utɨhwano lɨwoꞌnɨngkohofɨhwasoho. Sekwo yoꞌmayo tango seꞌmae soꞌno iꞌwaho fiyɨmno. Ole lutɨhwawoꞌnɨngkohofi, Hwe fihwo kakoe hungkuno nehopi syafɨsiyoꞌneꞌento kako Anɨtuye tajo ango engo somne lohono loso sohwo, u, kakoe hungkuno ne mmoꞌnyo soꞌno sekwo ole lɨwoꞌnɨngkohofi, Kakoe syohofoho. Hungkuno anefoho. I, hwe fihwo kako sojo wonyoangkafoso Anɨtuye tajo ango engo somo wojo soꞌno nehopi lohono loso sohwo u, kakoe hungkuno nehopi umokono. Nehopi mmoꞌnyoꞌnjo yahonɨngki sekwo oso hwe huhwo sohumo lintofasyɨwoꞌnɨngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sekwo aꞌamu huno ane sohwasi tɨmpiꞌnyo paꞌnyo hwasoho. Hungkuno yokumpohnꞌnyo yakoloꞌnnyoso ntisoto. Oso sojo wonyoangkafoso Anɨtuye angomo wojoso yakoloꞌnnyotaho. U, Anɨtuye angoso sojo wopɨngo imokiyoso yakoloꞌnnyo ntisoto. Anɨtuye angokofo. ");
INSERT INTO apz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Sekwo ole lutɨhwawoꞌnɨngkohofi, Hwe fihwo kakoe hungkuno soꞌno aꞌamu nehopi syafɨsiyoꞌneso ole lososo. Oso ijempoho yoꞌmayo Anɨtumneꞌno hoꞌnasiyo soponeꞌno hungkuno nehopi lohono. Ose loso sohwo ou, kakoe hungkuno ne mmoꞌnyoso kakoe syohofoho. Hungkuno anefoho. I, hwe fihwo kakoe hungkuno soꞌno aꞌamu nehopi syafɨsiyoꞌneso ole lososo, Oso yano iyoso Anɨtuye ijempoho hoꞌnasyɨwoꞌnɨngkohofo soꞌno hungkuno nehopi lohono. Ose loso sohwo u, kakoe hungkuno nehopi umoꞌnono. Nehopi mmoꞌnyoꞌnjo yahonɨngki sekwo oso hwe huhwo sohumo lintofasyɨwoꞌnɨngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sekwo aꞌamu huno ane sohwasi tɨmpiꞌnyo paꞌnyo hwasoho. Hungkuno yokumpohnꞌnyo yakoloꞌnnyoso ntisoto. Aꞌamu oso yoꞌmayo Anɨtumo yano uyotaho. Oso ijempoho yoꞌmayo Anɨtumo yano uyo somo wopɨngo umokiyosotaho. Ntisoto. Anɨtuye ijempohokofo. ");
INSERT INTO apz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Oseso hwe fihwo kako Anɨtuye ijempoho soꞌno lohono loso sohwo kako yoꞌmayo soponjo hoꞌnasyɨwoꞌnɨngkohofo soꞌntnne lalofoho. ");
INSERT INTO apz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Oseso hwe fihwo kako Anɨtuye ango engo soꞌno lohono loso sohwo kako Anɨtuye ango soꞌnji Anɨtu oso ango somo humaso soꞌntnne lalofoho. ");
INSERT INTO apz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Oseso hwe fihwo kako ahwomomneꞌno lohono loso sohwo kako ahwomoꞌnji Anɨtuye epohumayoꞌnji Anɨtu osopo humaso soꞌntnne lalofoho. ");
INSERT INTO apz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Sekwo honɨngkano hungkuno lutɨhwamotofo syohoꞌnjo sohwa hnnonji aꞌamu Falisi sohwanji, sekwo tohino tɨpemapitnne soꞌno ngko hitoho ntokwoho. Sekwo mangoꞌnohino hwasoho. Sekwo hamniyoho wosopayo kaꞌnyo, sopopayo, ampuꞌwe yoꞌmayo mawoꞌnɨngkohofoso sekwo hotitofontɨfi aho hufaꞌu hopiꞌnono imoꞌnɨngkahonɨngki angaꞌno Anɨtumneꞌno ko hoꞌnasyantɨfeso sekwo oso honɨngkano hungkuno weꞌe somo itoꞌno inɨngkawowoꞌnɨngkohofɨhwasoho. I, honɨngkano hungkuno engoso aꞌamufe hungkuno itoꞌno mɨhwajiyoso, aꞌamumo hitoho ulofoso, Anɨtumo sɨmeho hiꞌntnnono uyoso, oso hungkuno engo wonyoangkafoso sekwo minɨngkayoꞌnjo hwotoho fewoꞌnɨngkohofɨhwasoho. Oso yahino yoꞌmayo aho hopiꞌnonohino wojo soꞌno angaꞌnohino Anɨtumneꞌno hoꞌnasiyoso nohoꞌnafɨkutoho. I oso honɨngkano hungkuno engo soꞌntnneꞌno finɨngkamno. ");
INSERT INTO apz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Anɨtuye hungkuno weꞌe somo ko inɨngkawentɨfi Anɨtuye hungkuno engo somo hwotoho fewoꞌnɨngkohofo soꞌno sekwo aꞌamu tɨmpiꞌnyo paꞌnyo nomꞌne somo honɨngkano utɨhwawoꞌnɨngkohofɨhwasoho. Sekwo mijo nyoꞌne somjo wopmpeso weꞌeso wae yontɨfi soku i, humpotofo engo sohwo sekwo wosopayo mijo sopo kehumanteso muhwonyoꞌnjo yontɨfeso hiꞌnji nɨwoꞌnɨngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Sekwo aꞌamu honɨngkano hungkuno lutɨhwamotofo syohoꞌnjo hnꞌnnonji aꞌamu Falisi sohwanji sekwo yoꞌmayo tango seꞌmane soꞌno iꞌwaho fiyɨmno. Sekwo mangoꞌnohino hwasoho. Sekwoe noswanyo yoꞌmayo somo ko yajɨjwontɨfeso sekwo humayoso kihoꞌnjo hwasoho. I ajwomoꞌmo hufo yahino osoꞌnji sekwoe aꞌapahomneꞌnohini syafɨsyontɨfeso weho. ");
INSERT INTO apz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kɨko Falisi tɨmpiꞌnyo sohwosi, noswanyo ajwomoꞌmo yoꞌmayo wojoso kakiꞌno mijo yajɨjwohoji paho hohntaꞌni kihoꞌmaso umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Sekwo aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwa hnnonji aꞌamu Falisi sohwanji sekwo yoꞌmayo tango seꞌmae soꞌno iꞌwaho fiyɨmno. Sekwo mangoꞌnohino hwasoho. Sekwo aꞌamu poyo peꞌnɨngkahonɨngkofi hoꞌnasyɨwoꞌnɨngkohofo paꞌnyo hwasoho. Hwaho tojwa lopo wokoso wonyoangkafoꞌnjoponoho. I, hwaho ajwomoꞌmo poyo peꞌnyo sohwafe yokinoꞌnji yoꞌmayo pisakinoꞌnjo woꞌnnyoponoho. ");
INSERT INTO apz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Oso paꞌnyo kuyoho. Sekwoe aꞌapaho hohntaꞌni aꞌamu uhwonɨfijoso wopɨngo uhwonantɨfeho. I, sɨmeho ajwomoꞌmo hwasyo hungkunoꞌnji yoꞌmayo wonyoso engo yamoꞌnnyoponoho. ");
INSERT INTO apz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Sekwo aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwa hnnonji aꞌamu Falisi sohwanji sekwo yoꞌmayo tohino mayoꞌne soꞌno iꞌwaho itoꞌno fiyɨmno. Sekwo mangoꞌnohino hwasoho. Aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo sohwamneꞌno oso hwamo huno syafɨsiyoꞌno hofɨkoe pijafo hoꞌnahumentohofo sopo ango wopɨngo molɨwoꞌnɨngkohofɨhwasoho. Sekwo aꞌmopijohino sopo wokoso wopɨngo hulɨwoꞌnɨngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","I osoꞌno ole lɨwoꞌnɨngkohofɨhwasoho. Nakwo nanɨngkwohwosafe sɨkuno somo humentontasi nakwo aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo sohwamo fonjasiyo soꞌne mufoꞌmehwanesohilo. ");
INSERT INTO apz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sekwo oso lɨfitnne soꞌno ole lonetɨhwalokwofo, Aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo sohwamo fonjahumentohofo sohwafe imuhwasoho. Oso sekwoe hwapɨngo soꞌno lonetɨhwalokwofo. ");
INSERT INTO apz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Osoꞌno yoꞌmayo seyakwosa emaꞌmentohofoso sekwo wesejwaofantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sekwo homa mehomi hwasoho. Sekwo wonyo sohwafe mehomi hwasoho. Sekwoe honɨngkano wonyo somneꞌno tohino mayo soꞌno sekwo hiyaso leꞌmofoso pipilo. Awonoho. Sekwo hiyaso maleꞌmopitnnehofo. ");
INSERT INTO apz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Oseso sekwo upaꞌnɨmno. Sekuyepono olo hwamo uhwatɨmo. Aꞌamumo Anɨtu hungkuno uyahonɨngki lɨwoꞌnɨngkohofo sohwanji aꞌamu hunoꞌnjo sohwanji Anɨtuye honɨngkano hungkuno lutɨhwawoꞌnɨngkohofo sohwanji sekuyepono uhwatɨmo. Sekwoꞌnjopo nohumentanɨngkuji sekwo aꞌamu fehohnjo sohwamo fonjasyɨkuji nomꞌne sohwamo iyo hwojiyafɨkuꞌnnyo sopo fonjintoꞌofasyɨkuji nomꞌne sohwamo sekwoe ango uhuꞌmokiyo somo hwanɨngo fonjɨkuji nomꞌne angopono wofonjofepmnaofantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ose ifijo soꞌno aꞌamu honɨngkano wonyo ane somo siki fonjahumentohofo soꞌno sekwo tohino engo nomapitnnefoho. Aꞌamu Apelɨmo fonjahumentiso somtaꞌango neꞌno fonjahumɨwentɨfi fonjahumɨwentɨfi ayoso Pelekaiyafe hwomu Sekolaiya oso humo sekwo Anɨtuye tajo ango engo somo oso ijempoho yoꞌmayo Anɨtumneꞌno hoꞌnasyɨwoꞌnɨngkohofoꞌnjo sopo fonjahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ngko nehopi waselɨmonneꞌno yohono. Oso aꞌamu hopiꞌnonohino somo fonjahumentohofo sofe tohinoso sekwo olohonta humalofo sohwasi tohino hiloso nomapitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","U, nje aꞌamu Jelusalem humamopmmotofo sokunonji olohonta humalofo sokunonji sekwo aꞌamumo Anɨtu hungkuno uyahonɨngki selɨmotofo sohwamo fonjasyontɨfi aꞌamu sekumo sefoꞌmayoꞌne Anɨtu uhwojɨwoꞌnɨngkiso sohwamo sojoꞌnji fonjɨwoꞌnɨngkohofo kuyoho. Sɨkuno piꞌnɨngo engo somo ngko sekumo ole hopa womasemokuꞌmonji imalefoho. Yɨhufoso hofɨkoe polonyo somo muhuꞌmokontɨfi efemokosyawowoꞌnɨngkohofo hopaso ngko sekumo wosemokosyohumamonji ko imaleso sekwo nakwolaho lɨmalofofoho. ");
INSERT INTO apz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sekwo upaꞌnɨmo. Sekwoe ango Jelusalem sopo Anɨtu kako nto ulɨkoꞌmaꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Hungkuno nehopi waselɨmonneꞌno yohono. Olohonta sekwo ngkimo apaꞌno manohonyoꞌnjo neꞌno yontanɨngkuji sɨkuno piꞌnɨngo woseyakoloꞌmontonoho. Tɨfi noꞌmo sekwo nakwo oso aꞌamu Anɨtu uhwatɨmentiso sohumneꞌno yofe wohoꞌnomano lɨfijo sohonta sekwo ngkimo apaꞌno wonehonantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas Anɨtuye tajo ango engo somo nulɨkoꞌmahonɨngki kakoe inomokomoyo sohwa kakimo nuꞌmantɨfi Jisasɨmo ango hiloso utɨhwano lontɨfi yahonɨngkofi ");
INSERT INTO apz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jisas ulɨmento, Olo ango homo losomo sekwo lɨhwonalokwofo. Hungkuno nehopi waselɨmonneꞌno yohono. Olo ango lomjo sojo angaꞌnohinoso nomꞌnepo kihnꞌnawesoso awonoho. Oꞌo, hofɨko olo ango wopɨngo losomo mtɨhupekuji womehuꞌmmokwojantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas hwofɨkiꞌnyo Oulif sopo nohumentanɨngki kakoe inomokomoyo sohwa nuꞌmantɨfi hofɨkoꞌnohini nohumantɨfi ulɨmentohofi, Oso hungkuno nalohinoso sɨkuno ntisomo iꞌmofaponeto. Kɨko asomo piso sohontalaho. Sɨkuno moiꞌwo imoꞌnone soꞌnji sɨmoꞌmo peho imoꞌnoneto. Nakwo oso sɨkuno soꞌno huno pipi nayoneto. ");
INSERT INTO apz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Itoꞌno uhwontohumamno. Aꞌamu sekumo hwasyo honɨngkanomo ipemotasewofitoho. ");
INSERT INTO apz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Hwangku aꞌamu piꞌnɨngo engo iꞌmofapɨkuji hofɨko nje yofe ntɨkuji ole selɨfitnnefoho. Ngko Kɨlais hwoꞌnyoho. Anɨtu nɨhwosopoꞌmentiso hwoꞌnyoho. Ose selɨfijoso aꞌamu piꞌnɨngo hofɨkoe hungkunomo inɨngkafitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Sekwo ikujoho fongkiꞌnyoꞌne hungkuno upaꞌnɨngkuji iyoho senyoꞌeno. Ikujoho fongkiꞌnyoso iꞌmofapososo sɨkuno moiꞌwo mmoꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hwangku aꞌamu temtitofo kengo sohwanji temtitofo nomꞌne sohwanji hofɨko ikujoho fongkiꞌnɨfitnnefoho. I, aꞌamu hwaho kengopontaꞌango sohwa nomꞌne hwaho kengoponjo sohwanji ikujoho fongkiꞌnɨfitnnefoho. Ango kengo kengo sopo mijoho engo iꞌmofapososo nomꞌne ango kengo kengo sopo hwaho hwomɨhwo mjɨmɨwenefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Olo tango weꞌeso emayofoho. Tango mɨkunɨmpososo tɨfi noꞌmo weho. ");
INSERT INTO apz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Osohonta aꞌamuso nosetɨmafɨkuji tohino nosejapɨkuji nofonjasehufitnnefoho. Hwe moyaꞌmi hopiꞌnono sekumneꞌno sɨmeho tohino mɨkunɨmposo umnonefoho. Hwapɨngoso sekwo nje aꞌamu sokuneꞌefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hohosohonta hwe moyaꞌmi piꞌnɨngo engo Anɨtumneꞌno sɨmeho hiꞌntnnono unyoso nohoꞌnaofɨkuji hofɨkoe aꞌamu somneꞌno hungkuno wonyoso tokoyoꞌofo ifitnnefoho. Hofɨko hi hofɨkoe aꞌamumneꞌno mangohwa imoꞌnɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Osohonta aꞌamu piꞌnɨngo hwasyo hungkunoꞌnjo lutɨhwafɨkuji aꞌamu honɨngkano hwasyomo ipemotawofitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yahino wonyo mɨkunɨmposo imoꞌnɨngkuhwosi aꞌamu nomꞌne somneꞌno hitoho ulofoso nohoꞌnapitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","I, aꞌamu fihwo yokumpohnꞌnyo neꞌno lohofontanɨngkuhwosi sɨkuno aeꞌuyo imoꞌnososo Anɨtu kako oso huhwo sohumo utɨmanefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anɨtu aꞌamumo mokosyohumayo hungkuno wopɨngoso angoꞌmeemo lutɨhwafijoso aꞌamu hopiꞌnono nupaꞌnɨngkuji humentanɨngkuji sɨkuno moiꞌwo imoꞌnyoso iꞌmofaponefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Hohosohonta sekwo hwahoponjo anɨtu hwasyo sohwoe huyoꞌmango nɨhuꞌno wonyo sohwo Anɨtuye tajo ango engo Jelusalem sopo uhwonɨfitnnefoho. Nuhwonɨngkuji yomo engo ikuji youwo youwo lɨfitnnefoho. Olo hilo soꞌno hohonta Ntaniyel hwe fihumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwo lɨmentisofoho. Aꞌamu olo hungkuno loso atofo loso sohwo huno itoꞌno wosyafɨsyono. ");
INSERT INTO apz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ose uhwonɨngkuji youwo lɨkuji aꞌamu hwaho Jutiya sopo humunyoso hofɨko hwofɨkiꞌnyopono hiyaso komoꞌnosɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hwe fihwo antɨfepo humaso sohwo kako hwahopo pɨwelɨkofaohwosi kakoe hoꞌyango ango mtaꞌni moswomanehoho. ");
INSERT INTO apz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aꞌamu syohoꞌmo lohofontoso sohwo kakoe angopo ntaꞌni ife womamo lososo momawenefoho. Oꞌo, leꞌmoꞌnohini lohofonefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Oso sɨkuno somo moyaꞌmi sɨmehoꞌnjo sofanji mehomi weꞌe amno unyo sofantnneꞌno ngko hitoho ntokwoho. Hwapɨngoso oso sɨkuno homo somo olo hwaho lopo tango mɨkunɨmposo iꞌmofapɨhwosi Anɨtuye sɨmeho tohinoso oso hwe moyaꞌmi somo uꞌmanefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Olo sɨkuno hiyaso leꞌmofoꞌne wojoso sɨkuno meeofoso soꞌnji iꞌmofaposoꞌmanji sekwo leꞌmofoso pipilo. Sɨkuno iyoho humayo soꞌnji iꞌmofaposoꞌmanji leꞌmofoso pipilo. Osoꞌno sekwo Mpohumo jomo ulɨkuno. Sɨkuno meeofosomo iyoho humayo somo imoꞌnɨngkuhwoloho. Osoꞌno Mpohumo jomo ulɨkuno. ");
INSERT INTO apz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Oso sɨkuno somo tango mɨkunɨmposo woꞌnnyofoho. Hwaho songo imoꞌnɨmentiso sohonta mjɨmoꞌnɨmɨwento olohonta tango oso paꞌnyoso mmoꞌnyofoho. Hwangku tango apaꞌnohinoso oseꞌneꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Oso sɨkuno tohino mayo somo Anɨtu kako tɨfo mmokiyoꞌmanji aꞌamu hopiꞌnono poyo nto imoꞌnɨfijoꞌnesohilo. I, osoꞌno Anɨtu kakoe aꞌamu uhwosopoꞌmentiso somneꞌno huno syafɨsyɨhwosi sɨkuno oso tohino mayo soꞌno tɨfo imokonefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Hohosohonta hwe fihwo ole noselonefoho. Uhwonɨmno. Kɨlais olopo humaho. Ou, Kɨlais oso nompo humaho. Ose selɨkujoꞌno sekwo hofɨkoe hungkunomo tɨfi inɨngkayoꞌeno. ");
INSERT INTO apz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Osohonta aꞌamu fihwa ngko Kɨlais hwoꞌnyoho loso sohwanji aꞌamu Anɨtuye hungkuno hwasyo lutɨhwayo sohwanji iꞌmofapɨkuji yoꞌmayo wonyoangkafoso yamofo sekumo esetɨhwafitnnefoho. Aꞌamu Anɨtuye hungkunomo minɨngkayoꞌnjo hopiꞌnonohinoso oso hisofe hungkunomo inɨngkafitnnefoho. I, Anɨtuye aꞌamu neso hungkuno hwasyomo unɨngkowantɨfitɨkeno lɨkuji yoꞌmayo wonyoangkafoso yamofo esetɨhwafitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Olo yoꞌmayo hilo soꞌno nto selohefoho. Osoꞌno yoꞌmayo uhwonɨfijo soꞌno huno itoꞌno seyonefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Oseso hofɨko sekumo ole selɨfitnnefoho. Uhwonɨmno. Kɨlais kako aꞌamu ane nompo humaso lohunonoho. Ose selɨkujoꞌneso sekwo muhwonafitnnehofo. Ou, hofɨko ole selɨfitnnefoho. Uhwonɨmno. Kɨlais kako olo ango lomo humaho. Ose selɨkujoꞌneso oso hungkuno somo sekwo inɨngkakutoho. ");
INSERT INTO apz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Emtaꞌmɨngo mofehiꞌnyo sapiso moꞌmtaꞌni yonteso mofehiꞌnyo nɨngkuꞌnɨngkiso soꞌmo posomjiyohosawowoꞌnɨngkiso hopaso Aꞌamufe Hwomu sohwo oso paꞌnyo noponefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ose ulonto pahnnɨmo hungkuno ulɨmento, Aꞌamu poyo peꞌnyo sohwoe pijafo woꞌnnyo sopo yɨhufo ajiꞌmango oso hopo sopo nopɨkuji uhuꞌmokufitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Oso tango hiso moiꞌwo imoꞌnɨngkuhwosoꞌno mofehiꞌnyo nɨhuꞌno komoꞌno sɨkwoꞌmno imoꞌnɨngkuhwosoꞌno hamno majoꞌnjo ihwosi hntokwaliyo notɨhwoꞌmeeofonefoho. Yoꞌmayo ahwomomjo hntokwaliyo yomo yomo yahonɨngkuhwosi uhwonɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aꞌamufe Hwomu sohwo pone soꞌno ahwomomo yamofo iꞌmofapɨhwosoꞌno aꞌamu hwahoponjo humalofoso nuhwonɨngkuji humotaho lɨfitnnefoho. Osohonta uhwonɨfijoso Aꞌamufe Hwomu sohwo kako himopo kakoe yokumpohnꞌnyo engoꞌnji pomponaho engoꞌnji pontanɨngkuhwosi uhwonɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hohosohonta kounoho yoka engo hoꞌnɨngkuhwosi Anɨtu kakoe aꞌamu ahwomomjo somo uhwajɨhwosi angoꞌmeemjo aꞌamu uhwosopoꞌmentiso somo nuhuꞌmokonefoho. Hwaho ae efohotoꞌnawojoꞌmeemjo mɨhwofojonefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sekwo iyo mijisiyo somo uhwonɨmno. Uyonɨmofoso uhwonɨngkuji jefo uyɨmonteꞌnefoho wolantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Oso paꞌnyo yoꞌmayo soꞌno seloheso uhwonɨngkuji huno ole waseyono. Kakoe sɨkuno nto iꞌmofapohoho. Kako hokuꞌyopo lohokwoho. Huno ose waseyono. ");
INSERT INTO apz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Hungkuno nehopi waselɨmonneꞌno yohono. Hwe moyaꞌmi olo hwaho lopo neꞌno nohumentanɨngkuji yoꞌmayo hiso imoꞌnonefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Olo ahwomoꞌnji hwahoꞌnji moiꞌwo imoꞌnoso sohonta nje hungkunoso moiꞌwo mmoꞌnyoꞌnjo. Neꞌno nowentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Oso sɨkuno somneꞌno nakwo huno monayofoho. Aꞌamu ahwomomjo sohwanji ngkoꞌnji huno monayofoho. Oꞌo, Mpohwo Anɨtu kakoꞌnohini huno uyalofoho. ");
INSERT INTO apz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Oso aꞌamu hohonta Nɨwaꞌnji humamotofoso kako yofayokinomo humentiso sohonta yoꞌmayo yahino imotofo paꞌnɨngoso sekwo yontanɨngkuji Aꞌamufe Hwomu sohwo noponefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hohonta mijo aꞌamu somo muhuloꞌmentiso sohonta hofɨko wopayoꞌnji mijoꞌnji nɨfitnneso ape mapitnneso mjɨmɨwentanɨngkofi Nɨwa kako yofayokinomo humentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Aꞌamu hiso yoꞌmayo soꞌno huno mosyafɨsiyoꞌnjo yontɨfi nohumentanɨngkofi mijo muhulofahonɨngki peꞌnɨmentohofofoho. Oso paꞌnyoso aꞌamu huno mosyafɨsiyoꞌnjo yontanɨngkuji Aꞌamufe Hwomu komoꞌno noponefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Oso hohosohonta hwe hufaꞌu syohopo lohofontanɨngkohosɨsi Anɨtu angaꞌnohinohumo nutɨmahwosi nomꞌnehumo nulɨkoꞌmanefoho. ");
INSERT INTO apz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aꞌmu hufaꞌu faꞌu wopayo sɨhu kolofontanɨngkohosɨsi Anɨtu nomꞌnimo utɨmahwosi nomꞌnisi wohumamontonoho. ");
INSERT INTO apz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Osoꞌno sekwo itoꞌno fohontohumantokuno. Oso sɨkuno sekwoe Hwe Engo sohuneꞌno itoꞌno fohontohumantokuno. Oso sɨkuno sekwoe Hwe Engo sohwo pone soꞌno sekwo huno maseyofoho. ");
INSERT INTO apz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sekwo olo soꞌno huno fɨsyafɨhupmno. Hwe fihwo kakoe angomo humahwosi aꞌamu nomꞌneso kakoe hoꞌyango hufo iyoꞌneꞌentɨfi sɨkuno somneꞌno huno uyɨhwosoꞌno kako tɨmo wohontohumantonoho. Nohontohumentanɨngkuhwosi aꞌamu kakoe angomo maswonehoho. ");
INSERT INTO apz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Osoꞌno sekwo soku sɨkuno engolopohamo itoꞌno fesyohumantokuno. Ngko Aꞌamufe Hwomu sohwoꞌni sɨkuno sekwo huno mosyofɨsyomokosyohumentanɨngkujo somo wopmmonnoho. ");
INSERT INTO apz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Syoho ulohofiyo huno wopɨngoꞌjo sohwo tɨhwolo. Olenoho. Oso hwe huhwo sohumo kakoe hwe engo sohwo ulonteso, Kɨko nje aꞌamu syoho ntohofiyo somo uhwontohumaho. Ose lonto uhwosopeehonɨngki kako aꞌamu somo mokosyohumanto wopayo uyɨmojo hweho. ");
INSERT INTO apz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tɨfi sohonta syoho ulohofiyo wopɨngo sohwoe hwe engo asomo poso sohonta kako syoho wopɨngo mokosyohumentanɨngkuhwosi uhwonɨngkuhwosi oso syoho ulohofiyo sohwo sɨmeho wopɨngo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ngko hungkuno nehopi waselɨmonneꞌno yohono. Oso hwe engo huhwo sohwo kako kakoe yoꞌmayo hopiꞌnonohinoso olo syoho ulohofiyo huhwo sohumo enjwaꞌmo wohoꞌnahumontonoho. ");
INSERT INTO apz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","I osoꞌno, oso syoho ulohofiyo huhwo sohwo kakoe huno ole wosyafɨhuꞌmontonoho. Nje hwe engo sohwo kako asomo komoꞌno maponehoho. ");
INSERT INTO apz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ose syafɨsyahonɨngkuhwosi kakoe syoho ulohofiyo sohumo uhwontohumayo ikujoho fonjɨhwosi aꞌamu mijo yokumpohnꞌnyo nontɨfi nonilohofɨwoꞌnɨngkohofo soꞌnji wopayoꞌnji mijoꞌnji wanɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Oso syoho ulohofiyo sohwo ose yosoꞌmanji kakoe hwe engo sohwo sɨkuno fihumo syoho ulohofiyo sohwo kako huno mosyofɨsiyoꞌnjo yoꞌmayo itoꞌno mesyohontohumentanɨngkuhwosi asomo wapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Poso sohonta syoho ulohofiyo huhwo sohumo tohino mɨkunɨmposo uyɨhwosi aꞌamu hwasyo hungkunoꞌnjo soꞌnji uhumajoso sopo hofɨko hulɨngkwajingo ifalohoꞌnɨngkuji humotaho engo lɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisas kako aꞌamu somo ole ulɨmento, Hohosohonta Anɨtu aꞌamumo mokosyohumayo soꞌno olo paꞌnyofoho. Hwe fihwo kako ape womaꞌmo lonto pmmentisofoho. Moyaꞌmi aho hopiꞌnonohino sofa wopayo engo nyoꞌneꞌentɨfi hofɨkoe sikiloho nomantɨfi hwe sohumo ufohonɨtɨmano lontɨfi umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Oso moyaꞌmi aho hopiꞌnonohino hofo sofa aho fehohnjo huno anefafoho. Aho fehohnjo hunoꞌnjofafoho. ");
INSERT INTO apz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Oso moyaꞌmi hunoꞌmaso sofa hofɨko sikilohoꞌnohini motawentɨfi mijoꞌnji momotawommentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Moyaꞌmi hunoꞌnjo sofa hofɨko sikiloho motawentɨfi mijo nomꞌne soꞌnji motawomentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Oso hwe ape mayoꞌne sohwo komoꞌno mapeꞌnjo yahonɨngki saho fosyawoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Saho fosyowentanɨngkofi kuntoliyo sopo joho ole hoꞌnɨmento, Hwe ape mayo sohwo nto pohoho. Sekwo tohoꞌnji ufohonɨtɨmamno. ");
INSERT INTO apz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ose hoꞌnɨngkahonɨngki moyaꞌmi hopiꞌnonohino sofa nolɨkafontɨfi hofɨkoe sikiloho itoꞌno esyohumamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Moyaꞌmi hunoꞌmaso sofa moyaꞌmi hunoꞌnjo sofamo ulɨmentohofi, Sekwo sikiloho mijo hmnonejapmno. Nakwoe sikiloho sɨmpeꞌnalofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ose ulahonɨngkofi moyaꞌmi hunoꞌnjo sofa ole ulɨmentohofi, Nakwoe sikilohoꞌnji sekwoeꞌnji mijo hopoꞌmaho. Oꞌo sekwo nowekuji hoꞌyango ango mtaꞌni sekwoꞌne mijo mpopmno. ");
INSERT INTO apz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ose ulahonɨngkofi moyaꞌmi hunoꞌmaso sofa mijo mpeꞌno wentanɨngkofi oso hwe ape mayo sohwo nopahonɨngki moyaꞌmi itoꞌno humesyohumantohofo sofanji angomo wopayo engo wonano lontɨfi swontɨfi hokuꞌyo nɨhuꞌnahone pɨjwahumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hwangku sohonta moyaꞌmi nomꞌne sofa iꞌmofapontɨfi ulɨmentohofi, Hwe Engofo, hano fonehwosampofo. ");
INSERT INTO apz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ose ulahonɨngkofi hwe ape mayo sohwo ulɨmento, Ngko sekuneꞌno huno maniyohoyohoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisas ose ulonto ulɨmento, Sekwo itoꞌno fohontohumamno. Sekwo oso sɨkuno somneꞌno huno maseyohoyohoho. ");
INSERT INTO apz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Anɨtu aꞌamumo mokosyohumayo sohonta olo paꞌnyofoho. Hwe fihwo hano emayoꞌne kakoe ango ulɨkoꞌmaꞌmo lonto kakoe syoho ulohofiyo somo kakoe hoꞌyango yoꞌmayoso mokosyohumayoꞌne umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hofɨkoe yahino soꞌno syafɨsyonto kakoe hamniyoho yano ulohmmentisofoho. Nomꞌnehumo faif tausen (5,000) kina uyɨmentisofoho. Nomꞌne sohumo tu tausen (2,000) kina uyɨmentisofoho. Nomꞌnehumo wan tausen (1,000) kina uyɨmentisofoho. Ose uyonto umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Oso syoho ulohofiyo faif tausen (5,000) kina maꞌmentiso sohwo komoꞌno nowento oso hamniyoho soꞌnji syoho engo yonto faif tausen (5,000) kina nomꞌne maꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Syoho ulohofiyo nomꞌne tu tausen (2,000) kina maꞌmentiso sohwo kakoe hamniyoho nomanto osoꞌnji syoho engo yonto nomꞌne tu tausen (2,000) kina maꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","I, osoꞌno oso hwe wan tausen (1,000) kina maꞌmentiso sohwo kako hamniyoho nomanto piꞌnɨmomo ijopijijasyonto kakoe hwe engo sohwoe hamniyoho hwahomo hiyaso hoꞌnahumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Sɨkuno piꞌnɨngo engo memjaofahonɨngki oso syoho ulohofiyo sofe hwe engo sohwo asomo noponto oso hamniyoho umentiso soꞌno hungkuno ulɨmo lonto pmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Syoho ulohofiyo faif tausen (5,000) kina maꞌmentiso sohwo nomꞌne faif tausen (5,000) kina soꞌnji motaponto ulɨmento, Hwe engofo, oso faif tausen (5,000) kina ntapmmentohino soꞌnji ngko syoho engo yonji nomꞌne faif tausen (5,000) kina maꞌmentohefoho. Osoꞌno ten tausen (10,000) kina olopo weho. ");
INSERT INTO apz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ose ulahonɨngki hwe engo sohwo ulɨmento, Kɨko nje syoho ntohofiyo wopɨngo hwosoho. Kɨko syoho wopɨngo yonji syoho itoꞌnohini mokosyohumawoꞌnɨngkino hwosoho. Kɨko olo syoho weꞌe lomo wopɨngo mokosyohumawoꞌnɨngkino soꞌno ngko nomꞌne syoho engo mokosyohumayoꞌne wokijapmmonnoho. Kɨko ngkoꞌnjopo nopohoji ngkoꞌnji sɨmonyo uyaho. ");
INSERT INTO apz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ose ulahonɨngki syoho ulohofiyo tu tausen (2,000) kina maꞌmentiso sohwo nomꞌne tu tausen (2000) kina soꞌnji motaponto ulɨmento, Hwe engofo, oso tu tausen (2,000) kina ntapmmentohino soꞌnji ngko syoho engo yonji nomꞌne tu tausen (2,000) kina maꞌmentohefoho. Osoꞌno foua tausen (4,000) kina olopo weho. ");
INSERT INTO apz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ose ulahonɨngki hwe engo sohwo ulɨmento, Kɨko nje syoho ntohofiyo wopɨngo hwosoho. Kɨko syoho wopɨngo yonji syoho itoꞌnohini mokosyohumawoꞌnɨngkino soꞌno ngko nomꞌne syoho engo mokosyohumayoꞌne wokijapmmonnoho. Kɨko ngkoꞌnjopo nopohoji ngkoꞌnji sɨmonyo uyaho. ");
INSERT INTO apz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ose ulahonɨngki syoho ulohofiyo wan tausen (1,000) kina maꞌmentiso sohwo noponto ulɨmento, Hwe engofo, ngko huno moiꞌwonoho. Kɨko hwe yokumpohnꞌnyo hwosoho. Nomꞌne sohwa syoho hulontɨfe somtaꞌni wopayo mawoꞌnɨngkino hwosoho. Nomꞌne sohwa ufongoe fisosomokaofontɨfeso kɨko neso nomehuꞌmeesyonji mawoꞌnɨngkino hwosoho. ");
INSERT INTO apz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Oso hisoꞌno huno niyahonɨngki iyoho nnɨngkahonɨngki jɨje hamniyoho nomotawenji hwahomo hiyaso mokosyohumamentohefoho. Uhwonyo. Olo jɨje hiloso kakwosi maho. ");
INSERT INTO apz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ose ulahonɨngki hwe engo sohwo ulɨmento, Kɨko nje syoho ntohofiyo wonyo hwosoho. Kɨko pisoꞌmoꞌnyoꞌnjo hwosoho. Ngko nomꞌne sohwa syoho hulontɨfe soꞌnji nomꞌne sohwa fisosomokaofontɨfe somtaꞌni mawoꞌnɨngkohe soꞌno huno nto kiyohoho eso nto ntohino. ");
INSERT INTO apz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","I, osoꞌno nje hamniyohoso kako aꞌamu hamniyoho mokosyohumayo sohwafe angomo mohoꞌnanɨsiyoꞌnjo pehoꞌno imentohinoto. Hoꞌnosyontentesi nopmꞌmo nje hamniyoho soꞌnji nomꞌne weꞌe soꞌnji nomahmꞌmnesohilo. ");
INSERT INTO apz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ose ulonto ulɨmento, Olo hwe lohwoe wan tausen (1,000) kina nomafɨkuji oso hwe ten tausen (10,000) kina mokosyohumasoso sohumo umasyɨmno. ");
INSERT INTO apz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Hwapɨngoso ole, aꞌamu yoꞌmayoso itoꞌno mokosyohumawoꞌnɨngkohofo somo ngko nomꞌne piꞌnɨngo engoso uyɨmonnoho. Aꞌamu yoꞌmayoso itoꞌno momokosyohumayoꞌnjo yontoso sohumtaꞌni oso yoꞌmayo weꞌe kako mokosyohumasoso ngko womaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Olo syoho ntohofiyo wonyo sohumo sɨkwoꞌmjoho hohntaꞌni mehoꞌnaopmno. Osopo aꞌamu hulɨngkwajingo ifalohoꞌnɨngkuji humotaho engo lɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Aꞌamufe Hwomu sohwo yofe engo hwofiloꞌnnyoꞌnjo sohwo kakoe aꞌamu ahwomomjo soꞌnji poso sohonta kako hwe engo sohwoe epohumayo wonyoangkafo sopo humanefoho. ");
INSERT INTO apz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Osopo nohumahwosi aꞌamu hopiꞌnonohinoso uhuꞌmokahonɨngkuji kako hwe yahu mokosyohumayo paꞌnyo sohwo aꞌamu somo yano ilofonefoho. Aꞌamu yahu sipsip paꞌnyo somo kengopo uhwajɨhwosi aꞌamu yahu meme paꞌnyo somo kengopo uhwajonefoho. ");
INSERT INTO apz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yahu sipsip somo kakoe aho angahohntaꞌni uhumajɨhwosi yahu meme somo kakoe aho hwonamonyo hohntaꞌni uhumajonefoho. ");
INSERT INTO apz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Oso hohosohonta hwe yofe hwofiloꞌnnyoꞌnjo sohwo aꞌamu aho angahohntaꞌni humalofo somo ole ulonefoho. Nje Mpohwo yoꞌmayo wopɨngo sejape soꞌno sehwosopoꞌmentiso soku, hohonta hwaho songo mtɨꞌmokumentiso sohonta olo ango yoꞌmayoso Mpohwo sekumneꞌno yahumentisoso nopɨkuji mapmno. ");
INSERT INTO apz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Hwapɨngoso ngko mijoho niyahonɨngki wopayo ntapmmentohofofoho. Ngko mijoꞌno nɨmoꞌnɨngkahonɨngki mijo ntapmmentohofofoho. Ngko ango kengopo ntaꞌni pahonɨngko sekwo ngkimo sekwoe angomo ipenɨmotapontɨfi wopɨngo nɨmokosyohumamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngko hwapɨfe ane nohumentanɨngko sekwo yoꞌmayoso ntapmmentohofofoho. Ngko mnokinoꞌnji nohumentanɨngko sekwo wopɨngo nɨmokosyohumamentohofofoho. Ngko impoꞌangomo nohumentanɨngko sekwo nohonapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ose ulahonɨngkuhwosi aꞌamu wopɨngoso ole ulɨfitnnefoho. Hwe Engofo, ntohontalo. Kɨko wosopayo mijoho kiyahonɨngki nakwo wosopayo kijapmmentɨhwoneso, ntohontalo. Kɨko mijoꞌno kumoꞌnɨngkahonɨngki nakwo mijo kijapmmentɨhwoneso. ");
INSERT INTO apz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ntohontalo. Nakwo ango kengopontaꞌango hwosimo kohonontani nakwoe angomneꞌno ipekumotamentɨhwoneso, kɨko hwapɨfe yoꞌmayoso ane nohumentanɨngkini ntohonta kijapmmentɨhwoneto. ");
INSERT INTO apz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ntohontalo. Kɨko mnokinoꞌnji impoꞌangomo humentanɨngkinoso ntohonta kohonɨmentɨhwoneto. Ose ulohonɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Hwe yofe engoꞌnjo sohwo ulonefoho. Ngko nehopi waselɨmonneꞌno yohono. Yoꞌmayoso nje aꞌamu yofe engo aneꞌnjo somneꞌno ulohoꞌmentohinoso ngkineꞌno imentohinofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ose ulɨhwosi aꞌamu hwonamonyo hohntaꞌnɨngo somo ulonefoho. Sekwo wonyo soku, mpanɨmno. Anɨtu sekumneꞌno sɨmano hintotohino umnalofoho. Sekwo ngkimo ntɨkoꞌmafɨkuji oso toho neꞌno sijalokunjoso Mpohwo kako Setenꞌnji kakoe aꞌamu soꞌntnneꞌno hoꞌnahumentiso somo fɨwanɨmno. ");
INSERT INTO apz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Hwapɨngoso hohonta ngko mijoho niyahonɨngki wopayo montapeꞌnjo imentohofofoho. Mijoꞌno nɨmoꞌnɨngkahonɨngki mijo montapeꞌnjo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngko ango kengopo ntaꞌni pahonɨngko sekwo ngkimo ango mantapeꞌnjo imentohofofoho. Ngko hwapɨfe manjiꞌmofo ane nohumentanɨngko sekwo sekwoe yoꞌmayoso montapmmentohofofoho. Mnokinoꞌnjo nohumentanɨngko impoꞌangomo nohumentanɨngko sekwo monohonayoꞌnjo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ose ulahonɨngkuhwosi ulɨfitnnefo, Hwe engofo, Ntohontalo. Kɨko mijohoꞌnji mijoꞌtnno nokumoꞌnɨngkahonɨngki, kɨko nomꞌne angopo ntaꞌni ponji, kɨko hwapɨfe ane hwosi, mnokinoꞌnjo hwosi, kɨko impoꞌangomo nohumentanɨngkini nakwo wopɨngo makilohofeꞌnjo ntohonta imentɨhwoneto. ");
INSERT INTO apz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ose ulohonɨngkahonɨngkuji ole ulonefoho. Ngko nehopi waselɨmonneꞌno yohono. Nje aꞌamu yofe engo aneꞌnjo somneꞌno yoꞌmayoso mulohofeꞌnjo imentohofoso ngkineꞌno mantohofeꞌnjo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ose ulahonɨngkuhwosi aꞌamu hiso nukuji hofɨkoe wonyomneꞌno tohino engo neꞌno nomapitnnefoho. I aꞌamu wopɨngoso hofɨko ango wopɨngo sopo iꞌmofahokuji engolopohamo songo neꞌno nohumantokutnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas oso hungkuno hopiꞌnono moiꞌwo ulonto kakoe inomokomoyo sohwamo ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Sekwo huno moiꞌwonoho. Sɨkuno hufaꞌu memjaofɨhwosoꞌno Anɨtu Kako Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo Sɨkuno Engo iꞌmofaposo sohonta Aꞌamufe Hwomu sohumo iyo hwojiyafɨkuꞌnnyo somo wofonjintoꞌofosyantɨfeho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hohosohonta hwe yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji aꞌamu Isɨlael sohwafe hwe engo sohwanji hwe yofe hwofiloꞌnnyo tajo ango syohoꞌnjo Kaiyofas oso hwoe ango somo uhuꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Osopo nuhuꞌmokontɨfi Jisasɨmo hiyasoꞌmo aho kehwasi wofonjosyano lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ole hnnɨmentohofi, Olo hiloso Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo Sɨkuno Engo osomo wopayo engo nontanɨngkuji Jisasɨmo aho kehwasoꞌno nonahonɨngkuji aꞌamu hofɨko nakumo ikujoho nafongkupitnnoho. Oso hisoꞌno Sɨkuno Engo homo somo nakwo Jisasɨmo aho mokanehwono. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas kako Saimounɨye ango Mpetani osopo humamentisofoho. Saimoun huhwo sohwo aꞌapaho uyo wonyoꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Osopo Jisas nohumentanɨngki aꞌmu angaꞌnohinisi Jisasɨmo nuꞌmanto kako sojo ahwonte hwone mijo akino wonyoangkafoꞌnjo hamniyoho yokintahopoꞌnjoso nomotaponto Jisas epohumayo sopo nohumentanɨngki kakoe mnokinopo mijoso usohumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ose yahonɨngki inomokomoyo sohwa nuhwonontɨfi sɨmeho tohino umnɨngkahonɨngki hnnɨmentohofi, Olo aꞌmu losi mijo siki pehoꞌno sisyohoho. ");
INSERT INTO apz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Oso mijo wonyoangkafoso aꞌamu nakumtaꞌni mpe nalohofontɨfijontentesi nakwo hamniyoho engo nomehwasi aꞌamu hoꞌyango umofonyo iwoꞌnɨngkohofo somo uyɨhwanesohilo. ");
INSERT INTO apz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ose hnnɨngkahonɨngkofi Jisas hofɨkoe hungkunomo huno uyahonɨngki ulɨmento, Sekwo aꞌmu losimo sɨmeho tango pehoꞌno uyalokwofo. Kako ngkimo wopɨngo ntohokwoho. ");
INSERT INTO apz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aꞌamu umofonyo iwoꞌnɨngkohofoso sekwoꞌnji engolopohamo neꞌno humawoꞌnɨngkohofofoho. I, osoꞌno ngko sekwoꞌnji humaleso sɨkuno moiꞌwo weꞌenepi umoꞌnɨmontonoho. Osoꞌno aꞌamu ngkimo wopɨngo ntohofoꞌne sɨkuno piꞌnɨngo mauyoho. ");
INSERT INTO apz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Oso aꞌmusi kako nje aꞌapahopo hwone mijo ehantohofisoso kako nakwoe yahino aꞌamufe pijafo itoꞌno yasyɨwoꞌnɨngkuhwone hopaso ehantohokwoho. ");
INSERT INTO apz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Hungkuno nehopi waselɨmo, Ango yawojoꞌmeemo nje hungkuno wopɨngo aꞌamu somo ulɨfijo soꞌno olo aꞌmu losi ntohofiso soꞌnji ulɨfitnnefoho. Osoꞌno aꞌamu piꞌnɨngo engo olo aꞌmu losimneꞌno syafɨhupitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jisasɨye inomokomoyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌu sohwa angaꞌnohino sohwo kakoe yofe Jutas Isɨkaliyout. Oso hwe huhwo sohwo hwe yofe engoꞌnjo tajo ango syohoꞌnjo sohwamo nuꞌmanto ");
INSERT INTO apz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ulɨmento, Ngko sekumo Jisas sejapmme soꞌno sekwo peho wontopantɨfito. Ose ulohonɨngkahonɨngki ulɨmentohofi, Nakwo hamniyoho sojo teti (30) wokijopantanoho. Ose ulontɨfi hamniyoho uyɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Oso hohosohonta Jutas Jisasɨmo utɨhwamneꞌento honɨngkano imofoꞌne syofɨsyomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sɨkuno Engo uhwonɨmotofo sɨmoꞌmjo somo aꞌamu Juta wopayo nomꞌne kengo nɨwoꞌnɨngkohofo soꞌno Jisasɨye inomokomoyo sohwa kakimo nuꞌmantɨfi ulɨmentohofi, Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo Sɨkuno Engo osomneꞌno wopayo naneso ntɨꞌmo esyohumanehwono. ");
INSERT INTO apz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Sekwo antɨme engo somo nukuji hwe fihumo nuꞌmafɨkuji ulɨmno. Nakwoe hwe engo hungkuno mesyolonetɨhwawoꞌnɨngkiso sohwo ole nalohoho. Nje sɨkuno mofoneponoho. Ngko nje inomokomoyo sohwanji Sɨkuno Engo somneꞌno wosopayo jɨje angomo wonontaneꞌno yɨhwono. ");
INSERT INTO apz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ose ulahonɨngki inomokomoyo sohwa Jisasɨye hungkunomo inɨngkawentɨfi Sɨkuno Engo soꞌno wosopayo itoꞌno esyohumamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sɨkunoꞌnji Jisas kakoe inomokomoyo sohwanji nohumantɨfi Jisas ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hungkuno nehopi waselɨmo. Hwe fihwo kako olo ango lomo sekwoꞌnji humaso sohwo kako mango sohwafe ahomo wohoꞌnanɨhumonte hweho. Tokoyoꞌofo wantohoꞌmtonoho. ");
INSERT INTO apz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ose ulahonɨngki inomokomoyo sohwafe sɨmeho tango uyahonɨngki aꞌamu angaꞌno angaꞌnohino sohwa Jisasɨmo ulɨmentohofi, Hwe Engofo, ngkolaho. ");
INSERT INTO apz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Hwe fihwo ngkoꞌnji wopayo noswanomo yomaso sohwo kako ngkineꞌno aꞌamumo tokoyoꞌofo uyɨmte hweho. ");
INSERT INTO apz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Aꞌamu Anɨtuye hungkuno lutɨhwamotofo sohwa iyoswomo mtɨꞌmokumentohofo paꞌnyoso Aꞌamufe Hwomu sohwo poyo umoꞌnɨmontonoho. I osoꞌno oso hwe ngkineꞌno nje mango sohwamo tokoyoꞌofo ntohofone sohuneꞌno hitoho ntokwoho. Tohino engoso nomane hweho. Konaꞌwohi aswo momasoꞌnjo yontentesi wopɨngoꞌnesohilo. ");
INSERT INTO apz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ose ulahonɨngki Jutas oso hwe Jisasɨmo tokoyoꞌofo imentiso sohwo Jisasɨmo ulɨmento, Hwe Engofo, ngkolaho. Ose ulohonɨngkahonɨngki ulɨmento, Kɨko nto lohino. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hofɨko wopayo nontanɨngkofi Jisas wopayo nomanto Anɨtumo isamoyoka ulonto kutɨkujo lohofonto inomokomoyo sohwamo uyonto ulɨmento, Oloso nje aꞌapahofoho. Sekwo nomafɨkuji hmnɨmno. ");
INSERT INTO apz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ose ulonto kako noswanyo ipisayo mijoꞌnji nomanto Anɨtumo isamoyoka ulonto hofɨkimo uyonto ulɨmento, Olo mijo loso sekwo hopiꞌnonohino sohwasi hmnaopmno. ");
INSERT INTO apz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Olo nje honɨyo loso aꞌamu piꞌnɨngo sofe wonyo wae yasemofoꞌne usohumahono. Honɨyo loso Anɨtuꞌnji sekwoꞌnji makotɨkuꞌnyoꞌne usɨhumahono. Nje honɨyo losomo Anɨtu uhwonɨngkuhwosi sekwo Anɨtuꞌnji makotɨkuꞌnyoso ne imoꞌnyoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Hungkuno waselɨmo. Nomꞌne sɨkuno somo olo ipisayo mijo apaꞌno manɨmnehono. Manyoꞌnjo nohumentanɨꞌmo sɨkuno memjaofɨhwosoꞌno ngko sekwoꞌnji nje Mpohwoe ango aꞌamumo mokosyohumayo sopo mijo songo nonanefoho. ");
INSERT INTO apz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ose ulahonɨngki hofɨko ta angaꞌno lontɨfi noswapontɨfi hwofɨkiꞌnyo Oulifɨneꞌno kotasɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas ulɨmento, Olo sɨkwoꞌmiyo lomo sekwo ngkimo nɨhwajɨkuji hiyaso wahumpeentɨfeho. Anɨtuye hungkuno mtɨꞌmokumentohofo sohwa ole mtɨꞌmokumentohofi, Aꞌamu yahu mokosyohumayo sohumo fonjasyɨkujoꞌno yahu sohwa hiyaso wahumpeentɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","I, osoꞌno songo lɨkahmꞌmo Ngkalilineꞌno sɨmoꞌmo sepoꞌmnefoho. ");
INSERT INTO apz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ose ulahonɨngki Pita ulɨmento, Nomꞌne sohwa hofɨko ko kuhwotɨꞌmopijoso ngko makuhwotɨꞌmoꞌmnehono. ");
INSERT INTO apz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ose ulahonɨngki Jisas ulɨmento, Ngko hungkuno nehopi wakilɨmonneꞌno yohono. Olo sɨkwoꞌmiyo lomo yɨhufo tosɨka yoka malontanɨngkuhwoso sohonta kɨko ngkineꞌno hwasyo hungkuno hufaꞌu sɨhune ole ulɨmonnoho. Ngko Jisasɨmneꞌno huno maniyohoyohoho. Ose ulohojoꞌno yɨhufo sohwo yoka walɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ose ulahonɨngki Pita ulɨmento, Ngko kikimneꞌno huno maniyohoyohoho eso mulɨmnehono. Oꞌo, ngko kɨkoꞌnji ko fonjanɨsiyoꞌmanji oso hungkunoso mulɨmnehono. Ose ulahonɨngki inomokomoyo hopiꞌnonohino sohwa oso hopa ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas kakoe inomokomoyo sohwanji Ngketɨsemani iyo uyo syoho sopono umentohofofoho. Osopo nohumanto kakoe inomokomoyo sohwamo ulɨmento, Sekwo olopo fosyohumamno. Ngko oso nompono uꞌmo Mpohumo jomo ulɨmo. ");
INSERT INTO apz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ose ulonto kako Pitaꞌnji Sepetiye hwomu sohwaꞌuꞌnji utɨmanto umentohofofoho. Nowentɨfi Jisas sɨmeho tango mɨkunɨmposo umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Osoꞌno ulɨmento, Nje sɨmeho tango mɨkunɨmposoꞌnjo hwoꞌnyoho. Tango hiloso poyo wanɨmokumtolɨkeno. Ngkoꞌnjopo fosyohumafɨkuji ngkimo nohontohumamno. ");
INSERT INTO apz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ose ulonto weꞌenehwo nowento sɨmano hwaho hohntaꞌni ipitofawento Anɨtumo ulɨmento, U, nje Mpohwo, olo tohino loso nonɨꞌmahwosi woniyakolofono. I oso hisoꞌno nje hunomo nnɨngkahutoho. Oꞌo, jɨje hunomnohino hmnɨngkayo. ");
INSERT INTO apz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ose ulonto kakoe inomokomoyo sohwafepono umentisofoho. Kako nuꞌmanto uhwonɨmentisoso kakoe inomokomoyo sohwa saho nofosyowentanɨngkofi uhwononto Pitamo ulɨmento, Kɨko ngkimo monohontohumayo pehoꞌneto. ");
INSERT INTO apz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sekwo ngkineꞌno nohontohumafɨkuji Mpohumo jomo ulɨmno. Seten sekumo yamofo selohofonoho. Sekwo wopɨngoꞌnohini uyano ko lɨfijoso sekwoe yokumpohnꞌnyo hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ose ulonto Jisas apaꞌno weꞌenehwo nowento ulɨmento, Nje Mpohwo, olo tohino loso ngkimo manɨmnonehoho nnɨngkohoho. I, osoꞌno nje hunomo minɨngkomnehono. Oꞌo, jɨje hunomnohini unɨngkapmmonnoho. ");
INSERT INTO apz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ose ulonto asomo ponto uhwonɨmentisoso inomokomoyo sohwa tɨmo saho unɨngkahonɨngki saho fosyowentanɨngkofi uhwonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ose uhwononto apaꞌno nulɨkoꞌmanto Mpohumo jomo sɨmoꞌmjo ulɨmentiso hopaso apaꞌno nowento ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ose ulonto kakoe inomokomoyo sohwanjo sopo noponto ulɨmento, Sekwo saho neꞌno lofosyawotofo. Upaꞌnɨmno. Nje sɨkuno nto iꞌmofapmmaho. Aꞌamufe Hwomu sohumneꞌno aꞌamu wonyo sohwamo tokoyoꞌofo nto imasofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sekwo filɨkapmno. Wohwano. Uhwonɨmno. Oso hwe ngkineꞌno tokoyoꞌofo ntohoꞌmaso sohwo nto pohoho. ");
INSERT INTO apz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas oso hungkuno ulontanɨngki Jutas Jisasɨye inomokomoyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌu sohwo iꞌmofapmmentisofoho. Aꞌamu yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji aꞌamu Isɨlael hwe engo sohwanji aꞌamu piꞌnɨngo engo itokusoꞌnjo hosɨmnoꞌnjo sohwamo lutɨhwahonɨngkofi Jutas kako Jisasɨyepono ipemotasɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jutas oso aꞌamu sohwamo yaofo itɨhwayoꞌne ole ulɨmento, Hwe sohumo nuꞌmahmꞌmo hinjoho huꞌnɨmeso oso hwe huhwo sohwo Jisasɨyoho. Osohumo sekwo aho fɨkopmno. Ose nto ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Osoꞌno Jutas Jisasɨmo komoꞌno nuꞌmanto ulɨmento, Nje Hwe Engofo. Ose ulonto hinjoho huꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ose yahonɨngki Jisas ulɨmento, Kɨko umonji pohino sohwosi komoꞌno fiyo. Ose ulahonɨngki hofɨko Jisasɨmo uꞌmantɨfi aho yokumpohnꞌnyo koꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hwe fihwo Jisasɨꞌnji humamentiso sohwo kakoe hwakuhwajo nomanto hwe yofe engoꞌnjo tajo ango syohoꞌnjo sohwoe syoho ulohofiyo sohumo haloho lokuꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ose yahonɨngki Jisas ulɨmento, Jɨje hwakuhwajo asomo fohoꞌnasyo. Aꞌamu fihwo kako hwakuhwajoꞌnji nomꞌne sohwamo lofososo oso hwe huhwo sohumo hwakuhwajoꞌnji wolofosyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kɨko huno makiyoho liyohoho. Ngko nje Mpohumo jomo ulɨꞌmeꞌno kako ahwomomjo aꞌamu piꞌnɨngo engo nɨfoꞌmayoꞌne nɨhwajɨhwonesohilo. ");
INSERT INTO apz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","I oso hisoꞌno ngko ose iꞌmeꞌno aꞌamu Anɨtuye hungkuno nje poyo imoꞌnyo soꞌno mtɨꞌmokumentohofo oso hungkunoso ne pipi imoꞌnɨngkuhwonesohilo. Oꞌo, nje poyo imoꞌnyoso oso paꞌnyo umoꞌnɨmontonoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Oso hohosohonta Jisas aꞌamu itokusoꞌnjo somo ulɨmento, Sekwo aꞌamu hufo iwoꞌnɨngkiso sohuneꞌno aho wokano lontɨfi hwakuhwajoꞌnji itokusoꞌnji lomotopalokwofo. Sɨkuno engolopohamo ngko Anɨtuye tajo ango engo somo humanji aꞌamu somo Anɨtuye hungkuno lutɨhwahonɨngko sekwo ngkimo osopo manɨkosoꞌnjo iwoꞌnɨngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","I osoꞌno aꞌamumo Anɨtu hungkuno uyahonɨngki lutɨhwamotofo sohwafe hungkuno ne imoꞌnyoꞌne soꞌno yoꞌmayo imoꞌnɨngkohoho. Ose ulahonɨngki inomokomoyo sohwa Jisasɨmo ulɨkoꞌmantɨfi hiyaso humpoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Oso aꞌamu sohwa Jisasɨmo aho kentɨfi hwe yofe engoꞌnjo tajo ango syohoꞌnjo Kaiyofas oso hwoe angomneꞌno kemotamentohofofoho. Aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji aꞌamu Isɨlaelɨfe hwe engo sohwanji osopo uhuꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita Jisasɨmo ko inɨngkawomentisoso kakimo mufantohiꞌnyofoho. Oꞌo, kako poꞌmtopoꞌmtisyo humulohoꞌmɨwesofoho. Kako Kaiyofasɨye tojo somo noswonto aꞌamu uhwontohumayo sohwanjo sopo yoꞌmayo imoꞌnyo soꞌno uhwontohumamo lonto humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aꞌamu tajo ango syohoꞌnjo sohwanji aꞌamu kaunɨsol syohoꞌnjo sohwanji hofɨko aꞌamu Jisasɨmneꞌno hwasyo hungkuno ujɨsoꞌne Jisasɨmo fonjosyaneꞌentɨfi wotɨpemantɨfi imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Aꞌamu piꞌnɨngo hwasyo hungkunoꞌnjo sohwa ko iꞌmofopahonɨngkofi nofonjosyaneꞌentɨfi hungkunoso wonyopi tɨpmmentohofofoho. Hwangku aeꞌuyo sohwaꞌu iꞌmofaponji ");
INSERT INTO apz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ulɨmentisiyo, Olo hwe lohwo ole lɨmaso hweho. Anɨtuye ango engoso ngko wae yahmꞌmo songo molɨmeso sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno ango moiꞌwo umoꞌnɨmontonoho. Ose lɨmaso hweho. ");
INSERT INTO apz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ose ulahonɨngki hwe yofe engoꞌnjo tajo ango syohoꞌnjo sohwo nolɨkofalohofonto Jisasɨmo ulɨmento, Kɨko hungkuno asomo mujoꞌnjo pehoꞌno yalokuno. Pipilo. Olo hungkuno kikimo kilalokusiyo losofo. ");
INSERT INTO apz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ose ulahonɨngki Jisas mampiꞌnyo humentanɨngki hwe yofe engoꞌnjo sohwo ulɨmento, Anɨtu songo neꞌno humayo sohwo jɨje hungkuno kupoꞌnalofoho. Kɨko hungkuno nehopiꞌnohini fonaso. Kɨko Kɨlais, Anɨtu kuhwosopoꞌmentiso Anɨtuye Hwomu Ne hwosilaho. ");
INSERT INTO apz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ose ulohonɨngkahonɨngki Jisas ulɨmento, Kɨko nehopi ntohino. I wakilɨmonneꞌno yohono. Hwangku sohonta sekwo Aꞌamufe Hwomu sohwo Anɨtu Yoꞌmayo Yokumpohnꞌnyo Hwapɨngo sohwoe aho anga sohohntaꞌni humentanɨngkuhwosi uhwonɨfitnnefoho. Kako himo ahwomo mtaꞌango sopo nohumahwosi pɨhwosoꞌno uhwonɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas ose ulahonɨngki oso hwe tajo ango syohoꞌnjo sohwo sɨmano hintotohino umnɨmentiso soꞌno kakoe manjiꞌmofo weꞌene sɨsɨmpento ulɨmento, Kako Anɨtuneꞌno sitofo ulohoho. Nakwo nomꞌne aꞌamu Jisasɨmneꞌno hungkuno joꞌneso joho pehoꞌno ulanehwono. Oꞌo, sekwo kakoe hungkuno somo nto upaꞌnɨngkohofo. ");
INSERT INTO apz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sekwo huno pipi seyohoho. Ose ulohonɨngkahonɨngki ulɨmentohofi, Kako wonyo imaso hweho. Kako poyo umoꞌnono. ");
INSERT INTO apz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ose ulontɨfi Jisasɨye sɨmoꞌmangopo me mijo uyatɨꞌmofontɨfi fongkuꞌmentohofofoho. Aꞌamu fehohnjo nufonjontɨfi ");
INSERT INTO apz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ulɨmentohofi, Kɨko Kɨlais sohwosi Anɨtu hungkuno kijopahonɨngki lɨwoꞌnɨngkino hwosi, tɨhwo kufonjohoho. Noho fonaso. Sitofo ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita angkuhwafo ponjo tojo somo nohumentanɨngki hwe yofe engoꞌnjo sohwoe syoho ulohofiyosi nuꞌmanto ulɨmento, Kɨko huhwosi Jisas hwaho Ngkalili mtaꞌango sohwoꞌnji humawoꞌnɨngkino hwosoho. ");
INSERT INTO apz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ose ulahonɨngki aꞌamu hopiꞌnono nuhwonɨngkahonɨngkofi Pita ulɨmento, Awonoho. Olo hungkuno ntohino losoꞌno ngko huno maniyohoyohoho. ");
INSERT INTO apz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ose ulonto kako noswonto kontolompoꞌango somo nohumentanɨngki nomꞌne aꞌmu syoho ulohofiyosi Pitamo uhwononto hwe sohwamo ulɨmento, Olo hwe lohwo Jisas ango Nasaletnntaꞌango sohwoꞌnji humawoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ose ulahonɨngki Pita apaꞌno yofe hiyaso yonto ulɨmento, Nehopi yokintahopono lohono. Ngko oso hwe sohumo huno maniyohoyohoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Weꞌenepi aꞌamu fehohnjo lɨkofohumamentohofo osohwa Pitamo nuꞌmantɨfi ulɨmentohofi, Nehopi kilɨhwono. Kɨko hofɨkoꞌnjo mtaꞌango hwosoho. Jɨje mampahoso Ngkalilintaꞌango paꞌnɨngo hoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ose ulahonɨngkofi Pita hungkuno yokumpohnꞌnyo ulɨmento, Ngko hwasyo hungkuno selɨꞌmeso Anɨtu tohino wontapono. Oso hwe sohumo ngko huno maniyohoyohoho. Nɨhuꞌno nehopi lohono. Ose ulɨmentisoso tosɨka yoka lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yoka lahonɨngki nupaꞌnonto Pita hungkuno Jisas ulɨmentiso soꞌno huno syafɨhuꞌmentisofoho. Hungkuno ole ulɨmento, Yɨhufo tosɨka yoka molontanɨngkuhwoso sohonta kɨko ngkineꞌno mango hufaꞌu sɨhune ole walɨmonnoho. Ngko Jisasɨmneꞌno huno maniyohoyohoho. Ose ulohojoꞌno yɨhufo sohwo yoka walɨmontonoho. Pita kako huno ose syafɨsyonto mempono swonto kakoe yahino wonyo soꞌno sɨmeho tango mɨkunɨmposo uyahonɨngki humotaho engo neꞌno lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Imɨngo ne soꞌnji aꞌamu tajo ango syohoꞌnjo sohwanji aꞌamu Juta sofe hwe engo sohwanji Jisasɨmo fonjosyaneꞌentɨfi hungkuno lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jisasɨmo aho kentɨfi ahwomo nano kilofontɨfi hwe engo hwaho mokosyohumayo Pailot oso hwoepono ipemotawomentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jutas kako Jisasɨmo tokoyoꞌofo ulohoꞌmentiso sohwo uhwonɨmentisoso hofɨko Jisasɨmo tohino uyantɨfi yahonɨngkofi uhwononto kako sɨmeho tango uyahonɨngki huno ole syafɨhuꞌmento, Wonyo imalefoho. Ngko oso hamniyoho sojo teti (30) maꞌmaleso asomo uyɨmo. Ose ulonto kako aꞌamu tajo ango syohoꞌnjo sohwanji aꞌamu Juta sofe hwe engo sohwanjimo uyonto ");
INSERT INTO apz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ulɨmento, Ngko wonyo imalefoho. Ngko hwe wonyo ane sohumo setɨhwamale sohwo wapeꞌnɨmontonoho. Ose ulahonɨngki ulɨmentohofi, Nakwoeꞌmaho. Jɨjeꞌnohinofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ose ulahonɨngkofi Jutas oso hamniyohoso Anɨtuye ango engo somo noswohoꞌnofawento nowento nano hmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hwe yofe engoꞌnjo tajo ango syohoꞌnjo sohwa hamniyoho hiso nomantɨfi hnnɨmentohofi, Olo hamniyoho hiloso aꞌamumo fonjasiyoꞌne mpeꞌnefoho. Nakwo olo hamniyoho loꞌnji tajo angomjo hamniyoho nemꞌno hoꞌnasiyoso wopɨngoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ose lontɨfi hungkuno nomꞌne ole kotɨkuꞌmentohofi, Nakwo aꞌamu hwontoho mtɨꞌmokuwoꞌnɨngkohofo sohwa mtaꞌni olo hamniyoho losoꞌnji hwaho mpe uyano. Hwaho hiloso aꞌamu kengo mtaꞌni nopɨkuji poyo peꞌnɨngkujoꞌno pijafo hoꞌnasiyoꞌnefoho. Ose kotɨjwontɨfi imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Osoꞌno hwaho hopo sopo hwaho honɨyo lɨfawojoponoho lɨwoꞌnɨngkohofofoho. Oso yofe hiso olohonta weho. ");
INSERT INTO apz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Oso hohosohonta hwe Jelemaiya sohumo Anɨtu hungkuno uyahonɨngki lutɨhwamojo sohwoe hungkuno ne imoꞌnɨmentisofoho. Hungkuno ole, Aꞌamu Isɨlaelɨso oso hamniyohoso kakineꞌno mpe uyano lontɨfi imentohofofoho oso hamniyoho hiso nomantɨfi ");
INSERT INTO apz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","aꞌamu hwontoho mtɨꞌmokuwoꞌnɨngkiso sohwoe hwaho mpe imentohofofoho. Oso hwe engo ntɨmentiso paꞌnyofoho. Oso hungkunoso hohonta Jelemaiya ose lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hwe yofe engoꞌnjo hwaho mokosyohumayo sohwoꞌnjo sopo Jisas lohoꞌmentisofoho. Oso hwe engo huhwo sohwo Jisasɨmo ulohonɨmento, Kɨko aꞌamu Jutafe Hwe Engo sohwosilaho. Ose ulahonɨngki Jisas ulɨmento, Hungkuno hiso kɨko nehopi lohino. ");
INSERT INTO apz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hwe yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji Juta sohwafe hwe engo sohwanji hofɨko Jisasɨmneꞌno hungkuno ulahonɨngkofi Jisas hungkuno asomo mujoꞌnjo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Oseso Pailot Jisasɨmo ulɨmento, Oso hungkuno kikineꞌno ntohofoso kɨko mupaꞌnyotaho. ");
INSERT INTO apz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ose ulohonɨngkahonɨngki Jisas hungkuno mujoꞌnjo yahonɨngki Pailot yomo yonto huno piꞌnɨngo engo syafɨhuꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Oso Sɨkuno Engo wopayo iloho yanɨmotofo sɨkuno somo soswo huhwo huhwi hwe engo hwaho mokosyohumayo sohwo kako hwe impoꞌangomjo fihumo isɨhutofɨhwajɨmojo hweho. Aꞌamu sohwa oso hwe impoꞌangomjo sohuneꞌno yofe hwe engo sohumo ulɨwoꞌnɨngkahonɨngkofi oso hwe huhwo sohumo isɨhutofɨhwajɨmojo hweho. ");
INSERT INTO apz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Oso hohosohonta hwe wonyo Mpolapas kako impoꞌangomo humohumantisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hwe moyaꞌmi nuhuꞌmokahonɨngkofi Pailot ulɨmento, Ngko sekuyepono tɨhumo isɨhutofɨhwajɨmnehono. Ngko Mpolapas isɨhutofɨhwajɨmnehono. Ngko Jisas aꞌamu Kɨlaisɨyoho ulɨwoꞌnɨngkohofo sohumo isɨhutofɨhwajɨmnehono. Ose ulohonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailot olo soꞌno huno moiꞌwonoho. Aꞌamu piꞌnɨngo engoso Jisasɨmo inɨngkamotofo soꞌno aꞌamu Juta sofe hwe engo sohwa sɨmano hintotohino umnɨmentisofoho. Osoꞌno kakiyepono hungkuno hiso ipemotapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailot kako hungkuno joꞌne ango sopo humentanɨngki kakoe ape hungkuno ole lɨhwatɨmento, Kɨko oso hwe wopɨngo sohumo kɨko wonyo ulohofohotoho. Ngko sɨkwoꞌmiyomo oso hwe sohuneꞌno wojo uhwonɨngkoheso ngko sɨmeho tango nisofoho. Ose lɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hwe yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji Juta sofe hwe yofe engoꞌnjo sohwanji hofɨko hwe moyaꞌmi somo ulɨmentohofi, Sekwo Mpolapasɨmneꞌno jomo ulɨmno. Jisas kako poyo umoꞌnono. Ose humulohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hwe yofe engoꞌnjo sohwo aꞌamu somo ulohonɨmento, Olo hwe lohwaꞌu osopo humasiyo loso tɨhumo usɨhutoꞌmnehono. Ose ulahonɨngki hofɨko ulɨmentohofi, Mpolapasɨmo usɨhutofo. ");
INSERT INTO apz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ose ulahonɨngkofi Pailot ulɨmento, Ngko Jisas aꞌamu Kɨlais hwosoho ulɨwoꞌnɨngkohofo sohumo pipi imnehono. Ose ulahonɨngki aꞌamuso ulɨmentohofi, Iyopo fonjintoꞌofasyo. ");
INSERT INTO apz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ose ulahonɨngkofi Pailot ulɨmento, Pehoꞌneto. Olo hwe lohwo peho wonyo imaso hwolo. Ose ulahonɨngki aꞌamuso mohmꞌno ulɨwoꞌnɨmentohofi, Iyopo fonjintoꞌofasyo. Iyopo fonjintoꞌofasyo. ");
INSERT INTO apz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ose lontanɨngkofi Pailot huno umento, kakoe hungkunoso hopa mmoꞌnɨngkahonɨngki ikujoho uꞌmofapmmonto yahonɨngki Pailot kako aꞌamu wanohonɨfento mijo nomanto aꞌamuso uhwontohumentanɨngkofi kakoe ahomo mijo yatɨkuꞌnonto ulɨmento, Olo hwe lohumo fonjasiyoꞌneso nje hunoꞌmaho. Oꞌo, sekwo hwapɨngo kuyoho. Osoꞌno nje aho mijo yatɨkuꞌnɨngkohono. ");
INSERT INTO apz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ose ulahonɨngki aꞌamuso ulɨmentohofi, Olo hwe lohumo poyo fonjasiyoꞌne tohino nakumo neꞌmasoso nakwoe mehomi ntnneꞌno woneꞌmaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ose ulahonɨngkofi Pailot Mpolapasɨmo isɨhutofɨhwajonto kakoe hwe itokusoꞌnjo sohwamo ulɨmento, Jisasɨmo impeꞌnji fonjɨkuji iyopo fonjintoꞌofahumno. ");
INSERT INTO apz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Oseso Pailotɨye aꞌamu itokusoꞌnjo sohwa hwe yofe engoꞌnjo sohwafe angomo ipemotaswontɨfi osopo hwe itokusoꞌnjo hopiꞌnonohino sohwa Jisasɨmo uꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hofɨko kakoe manjiꞌmofo yajontɨfi hofɨko manjiꞌmofo nomꞌne honɨyoꞌnohinoso ulohoꞌmentohofofoho. Oso manjiꞌmofo honɨyoꞌnohinoso aꞌamu yofe engo hwaho mokosyohumayo sohwafe manjiꞌmofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ose yontɨfi hofɨko impe yongoꞌnjo nomantɨfi nopopojontɨfi hnnɨmentohofi, Olo hwe yofe engoꞌnjo hwaho mokosyohumayo sohwoe mnokino manjiꞌmofo paꞌnyofoho. Ose lontɨfi Jisasɨye mnokinopo monjiꞌmofahumentohofofoho. Hofɨko foꞌme nomantɨfi kakoe aho angahohntaꞌni umanjontɨfi ulɨmentohofi, Olo foꞌme loso hwe engo hwaho mokosyohumayo sohwoe paꞌnɨngo sohwosiye ahomo kumanjɨhwono. Ose lontɨfi kakoꞌnjopo hwomtame poji ulohofontɨfi sitofo ulɨmentohofi, Ou Hwe Engo sohwosi, kɨko aꞌamu Juta somo mokosyohumawoꞌnɨngkino sohwosilaho. ");
INSERT INTO apz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ose ulontɨfi kakoe sɨmoꞌmango sopo memijo uyatɨꞌmofontɨfi oso foꞌme ahomo umangkuꞌmentohofoso nomantɨfi mnokinopo fongkuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hofɨko sitofo moiꞌwo ulontɨfi oso manjiꞌmofo honɨyoꞌnohinoso yojasyontɨfi kakoe manjiꞌmofo ulohoꞌmentohofofoho. Ose yontɨfi kakimo fonjintoꞌofasiyoꞌne sopono ipemotasɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ipemotasontɨfi hwe fihwo Sailinintaꞌango kakoe yofe Saimoun osohumo nuꞌmantɨfi kwokwe umofontɨfi kako Jisasɨye iyo hwojiyafɨkuꞌnnyo intofoꞌneꞌentɨfi ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kako intofahonɨngki hofɨko hwaho Ngkoulɨkota sɨꞌmoꞌmentohofofoho. Oso hwaho hopo sopone yofe hiso hwapɨngo olenoho. Mnokino yokino huyoꞌmango paꞌnyo ponoho. ");
INSERT INTO apz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Osopo nohumantɨfi hofɨko ipisayo mijoꞌnji nomꞌne molasin tohino mumnyoꞌnjo soꞌne soꞌnji iwoloꞌmokontɨfi Jisasɨmo uyahonɨngkofi kako yamofo imentisoso manɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Oseso hofɨko Jisasɨmo iyopo fonjintoꞌofasyontɨfi kakoe manjiꞌmofo yoꞌmayoso tɨhwo womaꞌmontolɨkeno lontɨfi syohiꞌnyo imentohofofoho. Hwe sohwa syohiꞌnyo hiso yakolo ulohofontɨfi yoꞌmayoso huꞌmemaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ose yontɨfi osopo nohumantɨfi Jisasɨmo uhwontohumamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kakoe iyo hwojiyafɨkuꞌnnyo yokintaho sopono olo hungkunolo kakineꞌno mtɨꞌmokumentohofi, OLO HWE LOHWO JISASƗYOHO. AꞌAMU JUTAFE HWE ENGO HWEHO. Ose mtɨꞌmokontɨfi iyoswo hofojahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jisasɨꞌnjopo hwe hufaꞌu hufoꞌnji ikujohoꞌnji imojiyo sohwaꞌumo fonjintoꞌofahumentohofofoho. Nomꞌnihwo Jisasɨye aho angahohntaꞌni, nomꞌnihwo aho hwonamonyo hohntaꞌni fonjintoꞌofahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hwe moyaꞌmiso nopohotawentɨfi mnokɨngkwaꞌnɨngkwaꞌnnyo yontɨfi sitofo ulɨmentohofi, ");
INSERT INTO apz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kɨko ole lɨwoꞌnɨngkini, Anɨtuye tajo ango engoso ngko wae yaohmꞌmo apaꞌno songo molɨmeso sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno ango moiꞌwo umoꞌnɨmontonoho. Ose lɨwoꞌnɨngkino hwosoho. Kɨko Anɨtuye Hwomu Ne hwosɨꞌmanji kɨko foꞌmaꞌnyo. Iyopo ntaꞌni fɨkotape. ");
INSERT INTO apz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hwe yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji aꞌamu Jutafe hwe engo sohwanji oso paꞌnyo sitofo ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ole ulɨmentohofi, Kako aꞌamu nomꞌnemo ufoꞌmawoꞌnɨngkiso sohwo kakimo mufoꞌmaꞌnonehoho. Kako Isɨlael sofe hwe engo hwolaho. Kako iyopo ntaꞌni kotapɨhwosoꞌno uhwonɨngkuhwasi nakwo sɨmeho hiꞌntnnono uyano. ");
INSERT INTO apz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kako Anɨtumo sɨmeho hiꞌntnnono uyonto ole lɨmento, Ngko Anɨtuye Hwomu hwoꞌnyoho. Ose lɨmentiso hweho. Anɨtu kakineꞌno umoꞌnɨngkuhwosoꞌnoꞌmanji kako olohonta ufoꞌmano. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Oso hwe wonyo Jisasɨꞌnjopo fonjintoꞌofahumentohofo huhwaꞌu Jisasɨmo sitofo ulɨmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hinjo ajwo kuntoliyopo oso sɨkuno mjaofonto mofehiꞌnyomo hoholo yasyonto akupoꞌnyoꞌnji tɨli (3) kɨlouk osoꞌnji apaꞌno longkonɨngkahonɨngki mofehiꞌnyo lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sɨkuno wammonto yahonɨngki Jisas joho mohmꞌno lɨmento, Eli Eli lema sapakɨtani. Oso hungkuno hiso neso ole, Nje Mpohwo Anɨtu, pehoꞌno nɨsɨkwojantokuno. ");
INSERT INTO apz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ose lahonɨngki aꞌamu kakoꞌnjopo humamentohofoso upaꞌnontɨfi huno muyahonɨngki lɨmentohofi, Olo hwe lohwo kako Ilaija osohumo Anɨtu hungkuno uyahonɨngki lɨmojo sohumneꞌno joho lalofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ose ulahonɨngkofi hofɨkoꞌnjopo aꞌamu humunyo sohwo komoꞌno Jisasɨmo uꞌmanto hwapɨfe weꞌe mijo yokumpohnꞌnyo mangkinyoꞌnjo yomanto oso hiso tokemo yamjonto Jisas wanononto uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","I oso hisoꞌno nomꞌneso ole ulɨmentohofi, Hofahiyo. Nakwo uhwontohumano. Ilaija nopɨhwosi ufoꞌmaꞌmtolɨkeno. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisas apaꞌno joho mohmꞌno lonto kakoe huyoꞌmango uhwajonto poyo peꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Oso hohosohonta Anɨtuye tajo ango engo somjo hwapɨfe engo oso ajwoponjo ango weꞌe Anɨtu humayoꞌnefoho lɨmotofo sopo hokuꞌyopo pmpilɨpeehinyoso yokintahopo ntaꞌni tomonte sɨsɨmpo lohofonto hofaꞌu imoꞌnɨmentisofoho. Hwaho hwomɨhwo yonto sojo engoso tɨhwoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Oso hwaho aꞌmopijafo hoꞌnahinyo sopo hwaho hwosampo lohofahonɨngki Anɨtuye aꞌamu piꞌnɨngo peꞌnɨmentohofoso songo lɨkaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nolɨkafontɨfi sɨkuno nomꞌnemo Jisas peꞌnonto songo lɨkaꞌmentiso somo hofɨko ango Jelusalem wopɨngo somo noswahonɨngkofi aꞌamu piꞌnɨngo engo oso aꞌamu somo uhwonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hwe aꞌamu itokusoꞌnjo sohwamo mokosyohumayo sohwo kakoe aꞌamuꞌnji nohumantɨfi Jisasɨmo uhwontohumantɨfi hwomɨhwo yoꞌmayo soꞌnji imoꞌnɨngkahonɨngki uhwonontɨfi iyoho unɨmentisofoho. Ole ulɨmentohofi, Olo hwe lohwo Anɨtuye Hwomu Ne hweho. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Moyaꞌmi piꞌnɨngo engo Ngkalilintaꞌango Jisasɨmo tɨfi inɨngkamotofo sofa Jisasɨmo ufoꞌmano lontɨfi Ngkalili ulɨkoꞌmantɨfi Jisasɨꞌnji Jelusalemno pmmentohofofoho. Osofa nohumantɨfi Jisasɨmo uhwonɨhwojamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Aꞌmu hofɨkoꞌnjo lopontaꞌangosi Maliya Makɨtola ntaꞌangiyoho. Aꞌmu nomꞌnesi kakoe yofe Maliya Jemɨsɨꞌnji Jousepɨꞌnjiye konaꞌwohiyoho. Aꞌmu nomꞌnesi Sepetiye hwomu sohwaꞌuye konaꞌwohiyoho. ");
INSERT INTO apz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sɨkunoꞌnji hwe hamniyoho engoꞌnjo Alimateyantaꞌango sohwo iꞌmofapmmentisofoho. Kakoe yofe Jousepɨyoho. Kako Jisasɨmo inɨngkamojo hweho. ");
INSERT INTO apz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kako hwe engo Pailot osohumo uꞌmanto, Jisasɨye pijafo mayoꞌne ulohonɨmentisofoho. Ose ulahonɨngki Pailot ulɨmento, Jisasɨye pijafoso olo hwe lohumo uyɨmno. ");
INSERT INTO apz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ose ulahonɨngki Jousep pijafoso nomanto hwapɨfe songo halojo somo ifohumpento ");
INSERT INTO apz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kakoe sokimo songomo hoꞌnahumentisofoho. Oso sokimoso kako sojo engo somo imo engo ilɨꞌmentisofoho. Osopo hoꞌnasyonto sojo engo yɨwoloꞌmo yɨwoloꞌmo lohofonto sokimo hokuꞌyo somo pɨjwahumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya Makɨtolantaꞌangosɨꞌnji nomꞌne Maliyasɨꞌnji sokimo momɨngo sopo humanji humɨhwontohumantisiyofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Moꞌnɨngka honta sɨkuno iyoho humayoꞌne yoꞌmayo itoꞌno esyohumayo sohwi nuyokolofahonɨngki hwe yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji aꞌamu Falisi sohwanji Pailotɨmo uꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nuꞌmantɨfi ulɨmentohofi, Hwe engo oso hwe hwasyo hungkunoꞌnjo sohwo songo humamentiso sohonta ole lɨmento, Sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno ngko songo nolɨkaꞌmnefoho lɨmentisoso huno nayohoho. ");
INSERT INTO apz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Oso hisoꞌno kɨko jɨje aꞌamu sohwamo ole uso, Jisasɨye pijafo somo sekwo pɨkupɨjo esyontanɨngkujoso sɨkuno hufaꞌu sɨhune womemjaofono. Ose uso. Kakoe inomokomoyo sohwa nukuji kakoe pijafoso hufo ikuji hwe moyaꞌmi somo hwasyo ole ulɨfitnnoho, Jisas songo nto lɨkoꞌmaho. Oso hwasyo hungkunoso hwasyo hungkuno sɨmoꞌmjo somo nuyakolofonoho. ");
INSERT INTO apz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ose ulahonɨngkofi Pailot ulɨmento, Sekwo sekwoe aꞌamu uhwontohumayoꞌne sohwamo uhwajɨfijoso hofɨko sokimo somo yokumpohnꞌnyo wopɨjwosyafe. ");
INSERT INTO apz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ose ulahonɨngki hofɨko nowentɨfi pɨjwahumentohofofoho. Oso hiso hano pitofasiyo soꞌno sohe hoꞌnahumentohofofoho. Oseso hofɨko aꞌamu itokusoꞌnjo sohwa sokimo homo somo uhwontohumayoꞌne uhwatɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sɨkuno iyoho humayoso moiꞌwo imoꞌnɨngkahonɨngki Sante imɨngoꞌnji mofehiꞌnyo wosɨꞌmofapmmonto yahonjo soꞌnji Maliya Makɨtolantaꞌangosi Maliya nomꞌnesiꞌnji siko Jisas hoꞌnahumalofo sopo uhwonaho lonji pmmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Oso hohosohonta hwaho hwomɨhwo yahonɨngki aꞌamu ahwomomjo sohwo nulɨkoꞌmanto noponto sojomo iwoloꞌmo iwoloꞌmɨngo lohofonto sojo nomehoꞌnaofonto sojo yokintahopo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aꞌamu ahwomomjo sohwoe sɨmano emtaꞌmɨngo yonte paꞌnyo kakoe manjiꞌmofoso nɨhuꞌno halojoꞌnohinofoho. ");
INSERT INTO apz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aꞌamu itokusoꞌnjo sohwa osohumo uhwonontɨfi yomo yontɨfi iyoho unɨngkahonɨngki poyo hopa woꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","I osoꞌno aꞌamu ahwomomjo sohwo aꞌmu sofaꞌumo ulɨmento, Siko iyoho senɨngkuhwoloho. Ngko huno ole niyohi, Siko Jisas aꞌamu iyopo fonjintoꞌofahumalofo sohuneꞌno tɨpeelokusiyo. Ose ulonto ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kako olopo mohumuyoho. Hohonta kako lɨmentiso hopa nto lɨkaꞌmaho. Oyoninyo. Hofɨko Jisasɨmo nohoꞌnahumalofo lopo uhwoninyo. ");
INSERT INTO apz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Siko komoꞌno uhusɨsi kakoe inomokomoyo sohwamo hwe poyo imoꞌnɨmaso sohwo piꞌnɨmo mtaꞌni nto lɨkaꞌmaho. Ose ulinyo. Kako Ngkalilineꞌno sɨmoꞌmo nto sepoꞌmaho. Sekwo osopo nosokuji uhwonɨmno. Hungkuno seloheso inɨngo seyoꞌeno. ");
INSERT INTO apz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ose ulahonɨngki aꞌmu sofaꞌu iyoho unɨmentisoso siko sɨmeho wopɨngo umoꞌnɨngkahonɨngki piꞌnɨmomo nulɨkoꞌmanji komoꞌno nowenji kakoe inomokomoyo sohwamo olo hungkuno loso ulohonanji umentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nowentanɨngki Jisas honɨngkanopo uswoꞌnonto ulɨmento, Nje nampohwo faꞌuyo. Ose ulahonɨngki tɨfonepo nowenji Jisasɨye sɨfe hwompahomo aho upmꞌmokonji Jisasɨmo hwomtame ulohoꞌmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisas ulɨmento, Siko iyoho senɨngkuhwoloho. Siko nuhusɨsi nje nɨngkwahwosamo ulinyo. Hofɨko hwaho Ngkalili nosokuji osopo wanohonɨfe. Ose ulinyo ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Oso aꞌmu sofaꞌu nowentanɨngki aꞌamu fehohnjo itokusoꞌnjo sokimo somo uhwontohumayo sohwa hofɨko angopo iꞌmofawentɨfi aꞌamu yofe engoꞌnjo tajo ango syohoꞌnjo sohwamo yoꞌmayo imoꞌnɨmentiso soꞌno ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ose ulahonɨngkofi aꞌamu huhwo sohwanji aꞌamu Jutafe hwe engo sohwanji uhuꞌmokontɨfi yoꞌmayo yaneꞌentɨfi hungkuno mtitoꞌmentohofofoho. Hofɨko hamniyoho engo aꞌamu itokusoꞌnjo sohwamo uyontɨfi ulɨmentohofi, ");
INSERT INTO apz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Sekwo aꞌamu somo ole ulɨmno. Kakoe inomokomoyo sohwa hofɨko sɨkwoꞌmiyomo nopontɨfi nakwo saho fosyowentanɨngkuhwoni kakoe pijafoso hufo maꞌmalofofoho. Ose ulɨmno. ");
INSERT INTO apz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hwe engo hwaho mokosyohumayo sohwo olo soꞌno upaꞌnɨngkuhwosɨꞌmanji nakwo kakimo afofo umokantanoho. Kako sekumo yoka masejoꞌnjo uyɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ose ulahonɨngkofi aꞌamu itokusoꞌnjo sohwa hamniyoho nomantɨfi hofɨkoe hungkunomo inɨngkamentohofofoho. Olo hungkuno Jisasɨye pijafoso hufo mayo loso aꞌamu Jutafe angoꞌmeemo hoꞌnɨngkowahonɨngki neꞌno lontɨfeso olohonta ose weho. ");
INSERT INTO apz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Inomokomoyo aho hopiꞌnono sɨfe mtaꞌni angaꞌnohino sohwa oso hwofɨkiꞌnyo hwaho Ngkalili sopo Jisas nto ulɨmentiso sopono sɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hofɨko Jisasɨmo uhwonontɨfi hwomtame ulohoꞌmentohofofoho. I osoꞌno aꞌamu angaꞌno angaꞌno Jisasɨtɨkeno nomꞌne hwolɨkeno lontɨfi huno piꞌnɨngo syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas hofɨkimo tɨfonepo uꞌmanto ulɨmento, Anɨtu yoꞌmayo yokumpohnꞌnyo ahwomoꞌnji hwahoꞌntnneꞌno mokosyohumayoꞌne ntapisofoho. ");
INSERT INTO apz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Osoꞌno sekwo nowekuji hwaho hopiꞌnono angoꞌmeemjo aꞌamu somo nje hungkuno lutɨhwafɨkujoꞌno nje inomokomoyo umoꞌnɨfe. Sekwo hofɨkimo mijo kiyomayoso Mpohwoe yofeꞌnji kakoe hwomufe yofeꞌnji kakoe Towahunofe yofeꞌnji lɨkuji fɨkiyomapmno. ");
INSERT INTO apz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ngko hungkuno hopiꞌnono sejapontnneso aꞌamuso hungkuno hiloso inɨngkape-eꞌne filutɨhwamno. Upaꞌnɨmno. Ngko sekwoꞌnji engolopohamo nohumentanɨꞌmo sɨkuno moiꞌwo imoꞌnɨngkuhwosoꞌno neꞌno humentɨhwanefoho. ");
INSERT INTO apz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ngko Makꞌni Anɨtuye Hwomu Jisas Kɨlais sohuneꞌno hungkuno wopɨngo wamtɨꞌmokumonneꞌno yohono. ");
INSERT INTO apz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hungkuno ae lomayoso ole. Hohonta Anɨtu kako Aisaiya sohumo hungkuno uyahonɨngki iyoswo ole mtɨꞌmokumento, Anɨtu kakoe hwomumo ulɨmento, Upaꞌnyo. Ngko hwe fihumo nje hungkuno motaweꞌne wolɨhwatɨmonnoho. Oso huhwo sohwo kako kikimo sɨmoꞌmo kupe-eꞌne hweho. Kako jɨje honɨngkano itoꞌno esyohumayoꞌne hweho. ");
INSERT INTO apz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Olo hwe huhwo lohwo hwaho aꞌamumo humunyo fiꞌmo hwe fihwoe mampaho engo ole hoꞌnɨmento, Hwe Engo sohumneꞌno honɨngkano itoꞌno fehumamno. Kakoe hano emoyoꞌne soꞌno honɨngkano hiso itoꞌno mɨhwatɨmno. Oso hungkunoso Aisaiya mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Oseso Joun aꞌamumo mijo kiyomaꞌmojo sohwo hwaho aꞌamu mohumunyopo iꞌmofaponto aꞌamu piꞌnɨngo uhuꞌmokahonɨngkofi ole lutɨhwamento, Sekwo sekwoe honɨngkano wonyo somneꞌno hohujo ikinjaofɨkujoꞌno Anɨtu kako sekwoe wonyo hiso wae yasemofɨhwasoꞌno ngko mijo wokiyosemaꞌmo. Ose ulɨmentisofoho. Aꞌamumo sekwoe honɨngkano songoso utɨhwayoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aꞌamu hwaho Jutiyantaꞌango soꞌnji pone engo Jelusalem mtaꞌango piꞌnɨngo engo soꞌnji Jounɨmo uꞌmantɨfi kakoe hungkuno upaꞌnontɨfi hofɨkoe wonyo yoloho lɨjwaofahonɨngkofi Joun hofɨkimo Mijo Joutan sohumo kiyomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jounɨye nemꞌno manjiꞌmofo hwaho fiꞌnjohwe yahu kamel lohwaꞌnji mtɨꞌmokumentisofoho. Yahu paho ahulohoso lohoꞌnɨmentisofoho. Kako kusɨmoꞌnji tɨme mijoꞌnji nɨmojo hweho. ");
INSERT INTO apz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Joun aꞌamumo ole lutɨhwamojofoho. Hwe nomꞌnehwo tɨfi noponefoho. Oso hwe huhwo sohwo kakoe yokumpohnꞌnyoso nje yokumpohnꞌnyomo nɨyakolofonefoho. Ngko sohwoꞌni oso hwe huhwo sohwoe yofe engo soꞌno ngko kakimo momayo ulohofiyoꞌne hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngko sekumo mijoꞌnohino kiyosemawoꞌnɨngkono. Hwe tɨfinjo sohwo kako Anɨtuye Towahuno Wopɨngonjo sohwo wokiyosemaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Osohonta Jisas pone Nasalet hwaho Ngkalili ulɨkoꞌmanto Jounɨmo nuꞌmahonɨngki Joun kakimo Mijo Joutan sohumo kiyomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisas mijo mtaꞌango nosɨꞌmofaponto uhwonɨmentisoso ahwomo mtampo lohofahonɨngki Anɨtuye Towahuno yɨhufo ntolofiyo paꞌnyo sohwo Jisasɨmo wekehumapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Oso hohosohonta ahwomo mtaꞌni ole hoꞌnɨmento, Kɨko nje Hwomu sohwohnneꞌno, ngko sɨmeho wopɨngo mɨkunɨmposo kijapalokweno. Kɨko yoꞌmayo wopɨngo iwoꞌnɨngkino soꞌno nje sɨmeho wopɨngo nɨmoꞌnantofoho. Ose hoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ose hoꞌnɨngkahonɨngki Mijo Joutanntaꞌango Anɨtuye Towahuno Wopɨngo sohwo Jisasɨmo nomꞌne hwaho aꞌamu mohumunyo iyo yoꞌmayo ane sopono uhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Osopo Jisas nohumentanɨngki sɨkuno fouti (40) memjaofahonɨngki Seten Jisasɨmo wonyo umokumo lonto Jisasɨmo yamofo ulohoꞌmentisofoho. Oso hwaho sopo sikisɨwojo yoꞌmayoso nohumentanɨngkofi aꞌamu ahwomomjo sohwa Jisasɨmo ufoꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hwangku sohonta Helout hwe yofe engoꞌnjo hwaho mokosyohumayo sohwo kako Jounɨmo impoꞌangomo intofahumentisoso Jisas hwaho Ngkalili sopo nowento Anɨtuye hungkuno lutɨhwomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ole ulɨmento, Upaꞌnɨmno. Olohonta Anɨtuye sɨkuno mofoneponoho. Weꞌenepi Anɨtu kako kakoe aꞌamu soꞌnyumo yokumpohnꞌnyo enemokosyohumanefoho. Sekwoe honɨngkano wonyo somneꞌno hohujo ikinjaofɨkuji Anɨtumo sɨmeho hiꞌntnnono uyɨmno. Ose lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sɨkuno fihwi Jisas Mijo Ayo Ngkalili momɨngopo hano emoyonto uhwonɨmentisoso Saimoun konɨngkwaꞌwehwo Entɨluꞌnji siko inanɨku hoꞌyo mijomo hoꞌnaofontanɨngki uhwonɨmentisofoho. Inanɨku ifamiyoso sikoe hamniyoho syohofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas nuhwononto ulɨmento, Siko ngkimo tɨfi nnɨngkapinyo. Siko inanɨku mawoꞌnɨngkisiye paꞌnɨngoso Anɨtumneꞌno aꞌamu mayoꞌne wolosetɨhwamo. ");
INSERT INTO apz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ose ulahonɨngki sikoe inanɨku hoꞌyo komoꞌno nulɨkoꞌmanji Jisasɨꞌnji umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Hofɨko weꞌenepi mitɨmomɨngo somo nokuꞌmokwawentɨfi Jisas uhwonɨmentisoso Sepetiye hwomu sohwaꞌu Jemɨsɨꞌnji Jounꞌnji siko yofayokinomo nohumanji inanɨku hoꞌyo itoꞌno esyohumentanɨngki uhwonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisas nuhwononto sikineꞌno komoꞌno joho ulɨmento, Oyoninyo. Ose ulahonɨngki Jemɨsɨꞌnji Jounꞌnji siko komoꞌno kanɨngkwohumo ulɨkoꞌmaꞌmentisiyefoho. Kanɨngkwohwo Sepeti kakoe aꞌamu syoho ulohofiyo sohwanji hofɨkoe yofayokinomo nohumentanɨngkofi Jemɨsɨꞌnji Jounꞌnji siko ulɨkoꞌmanji Jisasɨꞌnji umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisasɨꞌnji kakoe inomokomoyo sohwanji nowentɨfi pone Koponeyam iꞌmofawentɨfi sɨkuno Salolemo aꞌamu iyoho fosyohumayoꞌne sɨkuno somo hofɨko aꞌamu Jutafe tajo angomo noswontɨfi Jisas hwe moyaꞌmimo hungkuno lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aꞌamuso hofɨko kakoe hungkunomo upaꞌnontɨfi yomo imentohofofoho. Hwapɨngoso hofɨko aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwa paꞌnyo hwoꞌmaho. Oꞌo, Jisas sohwo kako hungkuno hwapɨngo woꞌnnyo hweho. ");
INSERT INTO apz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Osohonta hwe towahuno wonyoꞌnjo sohwo tajo ango homo somo joho mohmꞌno ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Jisas Nasaletnntaꞌango sohwosi kɨko nakumo peho wonalohoꞌmneꞌno sopalokuno. Kɨko nakumo wonyo wonamokumonneꞌno losopalokuno. Ngko kikineꞌno huno niyohoho. Kɨko Anɨtuye Hwomu Wopɨngo Ne hwosoho. ");
INSERT INTO apz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ose ulahonɨngki Jisas kako towahuno wonyo sohumo yoka ulɨmento, Mampiꞌnyo fosyohumaho. Kɨko olo hwe lohumo ulɨkoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ose ulahonɨngki towahuno wonyo huhwo sohwo joho mohmꞌno lonto hwe sohumo yomo yomo engo umasiyonto ulɨkoꞌmaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aꞌamuso ose uhwonontɨfi yomo engo yontɨfi hnnɨmentohofi, Olo pehotɨkeno. Olo hungkuno nomꞌne songofoho. Olo hwe lohwo yokumpohnꞌnyoꞌnjo lohwo hungkuno lahonɨngki towahuno wonyo sohwa kakoe hungkunomo haloho pentɨfi tɨfi inɨngkahwofo. Ose hnnontɨfi ");
INSERT INTO apz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","olo yoꞌmayo Jisas imentiso soꞌno hwaho Ngkalili sopo mjahoꞌnɨmɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas tajo ango mtaꞌni noswaponto kako Saimounꞌnji Entɨluꞌnji sikoꞌnɨkwaꞌiye angomo humentohofofoho. Jemɨsɨꞌnji Jounꞌnji hofɨkoꞌnji humentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimoun konemi siye aꞌapaho tohohmtnno uhnnɨngkahonɨngki kako ijempohopo humamentisofoho. Osoꞌno Jisas noswopahonɨngki oso hungkuno hiso komoꞌno ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ose ulahonɨngkofi aꞌmusi mnokinoꞌnji nohumentanjopo uꞌmanto Jisas kakoe aho nomanto aꞌmu simo nulɨkofahonɨngki aꞌapaho tohohmtnno moiꞌwo imoꞌnɨngkahonɨngki kako wopɨngo imoꞌnɨmentisofoho. Wopɨngo imoꞌnonto kako aꞌamumne wopayo iloho humisyofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Oso sɨkuno somo aꞌamuso hofɨko aꞌamu nomꞌne yoꞌmayo yoꞌmayo mnokinoꞌnjo soꞌnji aꞌamu towahuno wonyoꞌnjo soꞌnji ipemotapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aꞌamu hopiꞌnono oso ango Jisas humentanjo hokuꞌyo sopo uhuꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Aꞌamu yoꞌmayo yoꞌmayo mnokinoꞌnjo soꞌnji towahuno wonyoꞌnjo soꞌnji wopɨngo umokumentisofoho. Towahuno wonyo huhwo sohwa Jisas Anɨtuye hwomu sohumo yofe uhwoꞌmentohofo soꞌno Jisas hofɨkimo hungkunojo soꞌne mampiꞌnyo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Iyohohweꞌnji Jisas nolɨkafonto kengopo aꞌamu mohumunyo sopo nowento osopo kako Anɨtumo jomo ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimoun kakoe aꞌamuꞌnji Jisasɨneꞌno tɨpeentɨfi ");
INSERT INTO apz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jisasɨmo tɨpɨhwonontɨfi ulɨmentohofi, Aꞌamu hopiꞌnono kikineꞌno wotɨpekohonɨmoꞌnantɨfi yalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ose ulahonɨngkofi Jisas ulɨmento, Hofɨkoe syohofoho. Nomꞌne ango mofone sopo wohwano. Nomꞌne aꞌamumo hungkuno wopɨngo wolutɨhwamneꞌno yohono. Osoꞌne pmmentohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ose ulahonɨngki nowentɨfi hwaho Ngkalili hoꞌmo soꞌmo tajo ango somo lutɨhwanto towahuno wonyo somo wae yaoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Hwe aꞌapaho sompoteꞌnjo sohwo Jisasɨmo humotaho sulonto hwahopo hwomtame ulohofonto jomo yokumpohnꞌnyo ulɨmento, Kɨko ngkimo wopɨngo wanɨmokumo lisoꞌmanji, jɨje yokumpohnꞌnyoso hoponoho. ");
INSERT INTO apz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisas nupaꞌnonto hitoho ulofahonɨngki aho kisusyonto hwe sohumo ulɨmento, Ou wopɨngo wakumokumonneꞌno yohono. Kɨko wopɨngo hmmoꞌnyo. ");
INSERT INTO apz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ose ulɨmentiso soꞌno oso uyo wonyo huhwo sohwo moiꞌwo komoꞌno iꞌmoꞌnɨkahonɨngki kako wopɨngo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Wopɨngo humentanɨngki Jisas hwe sohumo yoka yokumpohnꞌnyo ulɨmento, Olo yoheso nomꞌne aꞌamumo nulohotoho. Oꞌo, kɨko komoꞌno nowehoji oso aꞌamu tajo ango syohoꞌnjo sohumo jɨje aꞌapaho utɨhwahoji yoꞌmayo Mouses selɨmentiso soꞌno Anɨtumo yano uyo. Oseso aꞌamu hopiꞌnonohinoso uhwonɨngkuji jɨje aꞌapaho uyo wonyoso wopɨngo imoꞌnɨngkiso soꞌno huno wosyofɨsyantafeho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lɨhwojahonɨngki hwe huhwo sohwo kako aꞌamu hopiꞌnonohinomo oso Jisas kakoe aꞌapaho wopɨngo umokumentiso soꞌno ulɨmentisoso oso hungkuno hiso angoꞌmeemo hoꞌnɨmentisofoho. Osoꞌno Jisas kako nomꞌne angkuhwafopo mꞌmofayofoho. Kako mempo hohntaꞌni humentanɨngki aꞌamu ango kengo kengopontaꞌni kakimo uꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sɨkuno nomꞌne memjaofahonɨngki Jisas Koponeyam asomo nopahonɨngki aꞌamuso Jisas kakoe angopo humaho upaꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Aꞌamu hopiꞌnono ango Jisas humentanjopo uhuꞌmokontɨfi angomo angiyohoꞌmo aꞌamu piꞌnɨngo engo uhulaꞌmoꞌmentohofofoho. Uhuꞌmokahonɨngkofi Jisas Anɨtuye hungkuno lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hwe osofosofahuꞌnohino sohwa hwe mnokinoꞌnjo sohumo ijempoho emotapmmentohofofoho. Oso mnokinoso sɨfe aho songo miyofoho. Pompenjiyoꞌnohinofoho. Osohwa Jisasɨꞌnjopo iꞌmofapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Aꞌamu piꞌnɨngo uhulaꞌmoꞌmentohofo soꞌno uhwonontɨfi hofɨko Jisasɨꞌnjopo mitofasiyofoho. Osoꞌno sokango antɨfepo kotasontɨfi ikuꞌyo nofentɨfi aꞌamu mnokinoꞌnjo sohwo kakoe ijempoho hiꞌnji Jisas humentanjo mompo impe intofuyohoꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas kako uhwonɨmentisoso oso aꞌamu itokwapmmentohofo sohwa hofɨko Jisasɨmo sɨmeho hiꞌntnnono yokumpohnꞌnyo uyahonɨngkofi Jisas uhwononto hwe mnokinoꞌnjo sohumo ulɨmento, Olo hwomu lohwosi, ngko jɨje honɨngkano wonyoso wae nto yakumofohono. Ose ulahonɨngki ");
INSERT INTO apz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","aꞌamu Jutafe honɨngkano hungkuno lutɨhwamotofo sohwa humupoꞌntohumantohofofoho. Hofɨkoe sɨmeho moꞌmnohini ole syafɨhuꞌmentohofi, ");
INSERT INTO apz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Oso pipilo Anɨtu angaꞌno kakoꞌnohino aꞌamufe wonyo wae iyoso hoponoho. Hwe hwahoponjo sohwo aꞌamufe wonyoso wae miyonohoho. Olo hwe lohwo Anɨtumo sitofo ulalofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ose syofɨsyahonɨngkofi hofɨkoe huno somo Jisas huno uyahonɨngki ulɨmento, Sekwoe sɨmeho moꞌmo oso hunoso pehoꞌno syofɨsikomoꞌnalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Olo hwe mnokinoꞌnjo lohumo pehofo ulɨmneꞌelo. Hungkuno nohayo ntisoto. Jɨje honɨngkano wonyo wae weekumoꞌmo ulɨmnehono. Nomꞌne hungkuno ole, Filɨkaho. Jɨje ijempoho nomahoji mpano. Pehofo ulɨmnehono. ");
INSERT INTO apz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Oseso sekwo huno waseyono. Ngko Aꞌamufe Hwomu sohwoꞌni olo hwaho lopo aꞌamufe wonyo wae yaofoꞌne yokumpohnꞌnyo hinjo hwoꞌnyoho. Ose ulonto hwe mnokinoꞌnjo sohumo ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Wakilɨmo. Filɨkaho. Jɨje ijempoho nomahoji jɨje angopono fɨwano. ");
INSERT INTO apz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ose ulahonɨngki hwe sohwo nolɨkafonto kakoe ijempoho nomanto, noswopahonɨngki aꞌamuso nuhwonontɨfi yomo yontɨfi Anɨtuye yofe hoꞌnomantɨfi ulɨmentohofi, Hohonta nakwo oleso muhwonyofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas apaꞌno Mijo Ayo Ngkalili momɨngo sopo kuꞌmokuwahonɨngki osopo aꞌamu piꞌnɨngo engo nuꞌmahonɨngkofi kako aꞌamumo Anɨtuye hungkuno lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jisas hano nowento Lifai Alɨfiyosɨye hwomu sohwo aꞌamu hamniyoho mayo syohoꞌnjo sohwo kakoe ango somo nohumentanɨngki Jisas Lifaimo nuhwononto ulɨmento, Kɨko ngkimo tɨfi nnɨngkape. Ose ulahonɨngki Lifai nolɨkafonto Jisasɨmo tɨfi inɨngkamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tɨfi sohonta Jisas kakoe aꞌamuꞌnji Lifaiye angomo wopayo nontanɨngkofi osopo nomꞌne aꞌamu hamniyoho hoꞌnaofo syohoꞌnjo sohwanji aꞌamu wonyo honɨngkanoꞌnjo soꞌnji hofɨko Jisasɨmo tɨfi inɨngkunyo huhwanji humohumantohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aꞌamu Falisi sohwa hofɨko Jutafe honɨngkano hungkuno hunoꞌnjo fehohnjo sohwa hofɨko Jisasɨꞌnji aꞌamu wonyo soꞌnji wopayo nontanɨngkofi uhwonontɨfi Jisasɨye inomokomoyo sohwamo ulɨmentohofi, Aꞌamu hamniyoho hoꞌnaofo syohoꞌnjo sohwanji aꞌamu wonyo honɨngkanoꞌnjo soꞌnji Jisasɨꞌnji wopayo pehoꞌno nalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Olo hungkuno loso Jisas nupaꞌnonto ulɨmento, Aꞌamu mnokino aneꞌnjo wopɨngo humalofoso hofɨko aꞌamu uyohofaho siyoꞌnjo sohumo muꞌmapitnnehofo. Oꞌo, aꞌamu mnokinoꞌnjo soꞌnohini uꞌmantɨfeho. Oso paꞌnyoso ngko aꞌamu honɨngkano wopɨngoꞌnjo hwonaꞌnyoho lɨwoꞌnɨngkohofo somneꞌno joho lutɨmayoꞌne pmmentohe hwonɨꞌmaho. Oꞌo ngko aꞌamu honɨngkano wonyoꞌnjo somneꞌno pmmentohe hwoꞌnyoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sɨkuno nomꞌne fihwi Joun aꞌamumo mijo kiyomaꞌmojo sohwoe inomokomoyo sohwanji aꞌamu Falisi sohwanji Anɨtuye yofe hoꞌnomayoꞌne wopayo humaho humentanɨngkofi aꞌamu nomꞌne sohwa Jisasɨmo uꞌmantɨfi ulɨmentohofi, Jounɨye inomokomoyo sohwanji Falisiye inomokomoyo sohwanji hofɨko wopayo manyoꞌnjo humayoso Anɨtumo jomo ujoꞌne yahinoso inɨngkawowoꞌnɨngkohofofoho. I osoꞌno jɨje inomokomoyo sohwa hofɨko wosopayo manyoꞌnjo humayo yahino somo minɨngkayoꞌnjo pehoꞌno yalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Upaꞌnɨmno. Hwe ape songo mayo sohwo kako kakoe aꞌamuꞌnji wopayo iloho engo yontɨfeso hofɨko wopayo humaho wohumantɨfitaho. Oꞌo sɨmeho wopɨngoꞌnjo wonantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","I oseso hwangku sohonta oso hwe ape maso huhwo sohumo aꞌamu nomꞌne sohwa hofɨkoe aꞌamu mtaꞌni kompemafɨkuji fonjasyɨkujoꞌno kakoe aꞌamu hiso kako ane humafɨkujoso sɨmeho tangoꞌnjo humafɨkuji wosopayo manyoꞌnjo uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ihwoni. Hwe fihwo manjiꞌmofo tontamo imoꞌnnyo sohwo kako hwapɨfe nomꞌne songo weꞌe nomahwosi tontamo somo lojwohofojasɨhwosi yakɨfe uyɨmtolaho. Awonoho. Engo womnahotɨꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ose ulonto Jisas pahnnɨmo hungkuno tɨfinjoso ole ulɨmento, Aꞌamu fihwo kako mijo iloho uyɨmo lɨhwosi te fɨsiyo womaꞌmontolaho. Oꞌo, awonoho. kako te fɨsiyo mahwosi mijo ihmꞌmofɨhwosi iloho yososo mijo wahumpoꞌmontonoho. Te fɨsiyoso nɨhuꞌnahone wonyo umoꞌnɨmontonoho. U, hwe huhwo sohwo kako te songoso mahwosi mijo ihmꞌmofɨhwosi iloho yososo mijo itoꞌno wolɨfawoꞌmontonoho. Oso paꞌnyoso hohontajo yahino soꞌnji yahino songo soꞌnji nemꞌno huꞌmokomokosyohumayoso hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Salolemo iyoho humayoꞌne sohonta Jisas kakoe inomokomoyo sohwanji hofɨko syohoꞌmo nowentɨfi mijoho uyahonɨngki wopayo weꞌe songoso nomantɨfi aho hwosoꞌmokontɨfi pahoso fuyo lontɨfi neso nɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nontanɨngkofi aꞌamu Falisi sohwa uhwonontɨfi Jisasɨmo ulɨmentohofi, Ihwoni. Nakwoe honɨngkano hungkunoso yoꞌmayo syoho sɨkuno iyoho humayo somo iyoꞌneso hano pitofahinyofoho. Oso hisoꞌno sekwo sɨkuno iyoho humayo losomo wopayo pehoꞌne mantɨfi nɨngkohofoto. ");
INSERT INTO apz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Sekwo Ntefit imentiso soꞌno iyoswo mtɨꞌmokumentohofoso atofo majo hwasilaho. Oso sɨkuno Ntefit kakoe aꞌamuꞌnji hofɨko wopayo umofonyo yontɨfi mijoho engo humamentohofo sohonta neꞌno selohonɨngkohono. ");
INSERT INTO apz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Osohonta Apiyata hwe engo tajo ango syohoꞌnjo sohwo nohumentanɨngki Ntefit kako Anɨtumneꞌno hwapɨfe ango molinyo somo swonto wosopayo Anɨtuye sɨmanopo hoꞌnahinyoso swomaꞌmentisofoho. Oso wopayo hiso aꞌamu sikinjo somneꞌnoꞌmaho. Oꞌo aꞌamu Anɨtuye tajo ango syohoꞌnjo sohwamneꞌnohinofoho. I osoꞌno Ntefit kako nomanto kakoe aꞌamu sohwamo nuyɨmentisofoho. Sekwo oso hungkuno homo somo atofo majoꞌnjo imentohofo soꞌno sekwo nje inomokomoyo sohwamo oso hungkuno hiso ulohonɨngkohofotaho. ");
INSERT INTO apz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ose ulonto Jisas nomꞌne hungkuno Falisi sohwamo ulɨmento Anɨtu kako sɨkuno iyoho humayoso pehoꞌne mtɨꞌmokumentisoto. Kako hwe moyaꞌmi ufoꞌmayoꞌne mtɨꞌmokumentisofoho. I aꞌamufe honɨngkanomo hano pitofasyo iyoꞌne mtɨꞌmokumentisofoho. I sɨkuno iyoho humayo homo aꞌamumo ufoꞌmayoꞌne mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Oseso ngko Aꞌamufe Hwomu sohwoꞌni ngko sɨkuno iyoho humayoꞌneso hwapɨngo hwoꞌnyoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisas aꞌamu Jutafe tajo ango somo apaꞌno swahonɨngki osopo hwe fihwo aho songo songo miyo poyo hopa woꞌnnyo sohwo humunyoponoho. ");
INSERT INTO apz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aꞌamu Falisi sohwa hofɨko nohumantɨfi Jisasɨmo hungkuno itoꞌno mɨhwajiyo ango somo ipemotowaneꞌentɨfi ole syafɨhuꞌmentohofi, Jisas kako sɨkuno iyoho humayo lomo hwe aho wonyoꞌnjo sohumo wopɨngo umokumontolɨkeno. Ose syafɨsyontɨfi Jisasɨmo uhwontohumamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisas hwe aho wonyoꞌnjo sohumo ulɨmento, Kɨko ajwo lopo filohofape. ");
INSERT INTO apz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ose ulonto hofɨkimo ulɨmento, Oso honɨngkano hungkuno Mouses neyakwosamo uyɨmentisoso sɨkuno iyoho humayo lomneꞌno pehofo nalohoho. Nakwo olo sɨkuno lomo yahino wopɨngo uyantantaho. Wonyo uyantantaho. I nomꞌne aꞌamu somo wopɨngo umokantantaho. Wonyo umokantantaho. Ose ulohonɨngkahonɨngki hofɨko mampiꞌnyo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas hofɨkimo feꞌnɨhwononto sɨmeho tohino umnɨngkahonɨngki aꞌamu Falisiye sɨmehomo uhwonɨmentisoso hofɨko aꞌamumo hitoho mu lofe soꞌno sɨmeho tango uyɨmentisofoho. Jisas aꞌamu aho wonyoꞌnjo sohumo ulɨmento, Jɨje ahoso sɨhwaho fisɨpofo. Ose ulahonɨngki kako halohoꞌno yonto aho sɨhwaho sɨpoꞌmentisoso kakoe aho wopɨngo umoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aꞌamu Falisi sohwa uhwonontɨfi komoꞌno nowentɨfi Heloutɨye aꞌamu sohwanji uhuꞌmokontɨfi Jisasɨmo poyo fonjosyaneꞌentɨfi honɨngkano tɨpmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas kakoe inomokomoyo sohwanji oso ango sopo nulɨkoꞌmantɨfi mijo ayopo nohumentanɨngkofi aꞌamu piꞌnɨngo engo Jisasɨmo uꞌmaꞌmentohofofoho. Oso aꞌamu hiso ango kengo kengopontaꞌangofoho. Hwaho Ngkalili, hwaho Jutiya, ");
INSERT INTO apz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","pone Jelusalem, Itumeya, Mijo Joutan nongkihntaꞌni, Taiya pone engo nongkihntaꞌni Saitoun pone hiso nongkihntaꞌni oso aꞌamu piꞌnɨngo engo hiso yoꞌmayo Jisas imentiso osoꞌno upaꞌnontɨfi Jisasɨmo uꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jisas inomokomoyo sohwamo ulɨmento, Sekwo yofayokino itoꞌno fesyohumamno. Aꞌamu weꞌyo mohumuyoho. Hofɨko hwotoho nɨfɨfitnnoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Hwapɨngo ole, Jisas aꞌamu piꞌnɨngo engo somo aꞌapaho wopɨngo umokumentiso soꞌno aꞌamu mnokinoꞌnjo hopiꞌnonohinoso aꞌamu yohoto yohotofo mjolohoꞌnɨmɨwentɨfi Jisasɨmo upmꞌmokantaneꞌno yɨhwono ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aꞌamu towahuno wonyoꞌnjoso Jisasɨmo uhwonɨtɨmantɨfi hwahopo ipitofawentɨfi joho ulɨmentohofi, Kɨko Anɨtuye Hwomu Ne hwosoho. ");
INSERT INTO apz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ose ulahonɨngkofi Jisas hofɨkimo hungkuno yokumpohnꞌnyo ulɨmento, Olo hilo soꞌno aꞌamumo nulɨkutoho. ");
INSERT INTO apz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Oso hohosohonta Jisas hwofɨkiꞌnyopo nosonto kakoe inomokomoyoꞌne uhwosopoꞌmo lonto aꞌamu somo joho ulahonɨngki hofɨko sapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jisas aꞌamu aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sohwamo kakoe inomokomoyoꞌne uhwosopento ulɨmento, Ngkoꞌnji fosyohumayoꞌne sehwosopehe sohwasi, Hwangku aꞌamu nomꞌne somo sekwo lutɨhwayoꞌne wolosetɨhwamo. ");
INSERT INTO apz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nolosetɨhwahmꞌmo nje yakumpohnꞌnyo towahuno wonyo wayoꞌne wosejapmmo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hwe fihwo uhwosopoꞌmentisoso Saimounɨyoho. Oso hwe huhwo sohumo Jisas kako Pitafoho mulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jemɨsɨꞌnji konɨngkwaꞌwehwo Joun Sepetiye hwomu sohwaꞌumo Jisas nomꞌne yofe mulɨmentiso Mpouaneses. Oso yofe hwapɨngo ole hwe yokumpohnꞌnyo ahwomo lɨwoꞌnɨngkiso paꞌnyo hwaꞌuyoho. ");
INSERT INTO apz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nomꞌnihwa Entɨluꞌnji Filipɨꞌnji Mpatoulomɨyuꞌnjoho. Nomꞌnihwaꞌu Matɨyuꞌnji Toumasɨꞌnjoho. Nomꞌnihwo Jemɨs osohwo kako Alɨfiyosɨye hwomu hweho. Nomꞌnihwaꞌu Tatiyosɨꞌnji Saimoun Seloutɨꞌnjoho. ");
INSERT INTO apz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nomꞌnihwo Jutas Isɨkaliyoutɨꞌnjoho. Jutas huhwo sohwo Jisasɨmneꞌno tokoyoꞌofo yonto aꞌamu Jisasɨmo fonjasiyoꞌne sohwafe ahomo uyɨmentisofoho. Oso aꞌamu huhwo sohwo Jisas uhwosopento, kakoe angopo umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisas kakoe Nasalet osopono wahonɨngki aꞌamu piꞌnɨngo engo osopo uhuꞌmokumentohofofoho. Angomo uhuꞌmokumentohofo soꞌno Jisas kakoe aꞌamuꞌnji hofɨko wopayo manyoꞌnjo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jisasɨye temtitofo sohwa oso hiso nupaꞌnontɨfi, Jisasɨye hunoso itoꞌnoꞌmaho. Kakoe hunoso iloꞌnnyo hwolɨkeno. Ose lontɨfi kakimo utɨmano lontɨfi pmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aꞌamu Jutafe honɨngkano hungkuno lutɨhwamotofo sohwa Jelusalem mtaꞌni nopontɨfi lɨmentohofi, Mpelɨsepul oso towahuno wonyo hopiꞌnohino sohwafe hwe engo sohwo Jisasɨye sɨmeho moꞌmo humaho. Towahuno wonyo somo wae yaofɨwoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ose lahonɨngkofi Jisas hofɨkineꞌno joho lutɨmanto pahnnɨmo hungkuno ulɨmento, Seten kako wae yamoꞌnyoso pipilo. ");
INSERT INTO apz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Hwaho fiponjo aꞌamu hopiꞌnonohino huꞌmawoꞌnɨngkohofoso hotitopijo sohonta ikujoho fongkiꞌnɨngkuji hofɨkoe wopɨngo fosyohumayoso wonyo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aꞌamu ango angaꞌnohinomo fosyawe sohwa hofɨko ehusilofo humafɨkuji ikujoho fongkiꞌnɨfijoso hofɨko yosesamo wohumpeentɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Oseso Seten kakoe towahuno wonyoꞌnjo sohwa hofɨko ehusilofo humafɨkuji ikujoho fongkiꞌnɨfijoso hofɨkoe yokumpohnꞌnyo ane umoꞌnantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Hwe fihwo hwe yokumpohnꞌnyo sohwoe angomo hufo umo lɨhwosi swososo sɨmoꞌmo oso hwe yokumpohnꞌnyo huhwo sohwi nano kilofasyɨhwosi i kako oso ango homo somjo kakoe yoꞌmayoso womaꞌmontonoho. Oso paꞌnyoso ngko Setenɨmo uyakoloꞌmentohe soꞌno ngko kakoe towahuno wonyo sohwamo wae yaofalokweno. ");
INSERT INTO apz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Olo hungkunolo inɨngo seyoꞌeno. Aꞌamu hopiꞌnonohino hofɨkoe wonyoso sɨfajo hungkunoso wonyo hungkunoso Anɨtumo jomo ulɨfijoꞌmanji kako wae weesemoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","I osoꞌno aꞌamu kako Anɨtuye Towahuno Wopɨngo soꞌno sitofo lososo oso wonyo hiso Anɨtu kako wae meeofonehoho. Oso wonyo hiso kakoe sɨmehoꞌmo neꞌno nowentɨhwonefoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas kako Anɨtuye Towahunofe yokumpohnꞌnyo soꞌnji towahuno wonyo somo wae yaoꞌmentiso soꞌno hofɨko Jisasɨmo kɨko towahuno wonyoꞌnjo hwosoho ulɨmentohofofoho. Osoꞌno Jisas oso hungkuno tangoꞌnjo ulɨmentono. ");
INSERT INTO apz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Oso hohosohonta Jisasɨye konaꞌwohiꞌnji konɨngkwaꞌwehwosanji iꞌmofapontɨfi ango mempo hohntaꞌni humantɨfi Jisasɨneꞌno lɨhwatɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aꞌamu piꞌnɨngo engo Jisasɨꞌnji humantɨfi Jisas ajwopo nohumentanɨngki aꞌamu kakimo ulɨmentohofi, Upaꞌnyo. Jɨje naꞌu hnnɨngkwaꞌwehwosanji hnnampoꞌwohijanji humantɨfi kikineꞌno joho kilalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisas nupaꞌnonto ulɨmento, Nje naꞌu nɨngkwahwosa tɨhwalo. ");
INSERT INTO apz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jisas aꞌamu nohumentanɨngkofi feꞌnɨhwononto ulɨmento, Uhwonɨmno. Olo nje naꞌuja nje nɨngkwahwosa, olohi humalofo. ");
INSERT INTO apz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aꞌamu Anɨtuye hungkunomo tɨfi inɨngkawowoꞌnɨngkohofoso nje nɨngkwahwosa nje nampohwosa naꞌujafoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas kako Mijo Ayo Ngkalili sopo nohumanto aꞌamumo apaꞌno lutɨhwamentisofoho. Osopo nohumentanɨngki aꞌamu weꞌyo uhuꞌmokumentohofoꞌmaho. Osoꞌno Jisas yofayokinopo kotasonto osopo humamentisoso hwe moyaꞌmiso momɨngo sopo lohoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kako pahnnɨmo hungkuno piꞌnɨngo engo hofɨkoe huno ufohotofoꞌne lutɨhwamentisofoho. Ole ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Sekwo upaꞌnɨmno. Hwe fihwo kako kakoe syohopo ufongoyo fisosomokaoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Fisosomokofahonɨngki ufongoyo fehohnjoso honɨngkanopo pɨwesyahonɨngki yɨhufo sohwa nopontɨfi manɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","U, ufongoyo fehohnjoso hwaho sojoꞌnjo sopo pɨwahuꞌmentisofoho. Oso hwaho hiso engo moꞌmjoꞌmaho. Osoꞌno oso ufongoyoso komoꞌno fokaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Oseso mofehiꞌnyo ulonto ufongoyo pmpongo hwahomoꞌmo munjilofeꞌnjo yonto yofoho imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","U, ufongoyo fehohnjoso nantɨpe yongoꞌnjo sopo pɨwahuꞌmentisoso nantɨpe yongoꞌnjo sohwo komoꞌno fokofɨkwato lohofonto ufongoyo nontɨmo kingkulofonto oso ufongoyo hiso ne mintoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","U, ufongoyo fehohnjo hwaho afofoꞌnjopo pɨwahuꞌmentisoso engo fokafonto ne piꞌnɨngo intoꞌnɨmentisofoho. Ne fiso weꞌe (teti, 30), fiso engo (sikɨsɨti, 60), fiso piꞌnɨngo engofoho (wan hantɨlet, 100). ");
INSERT INTO apz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisas ose ulonto ulɨmento, Aꞌamu fihwo nje hungkuno upaꞌnyoꞌne haloho hiꞌnjo hwoꞌmanji kako upaꞌnono. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hwangku inomokomoyo sohwanji nomꞌne aꞌamu fihwa kakoe hungkunomo upaꞌnɨmentohofo sohwanji Jisasɨꞌnji nohumantɨfi pahnnɨmo ulohonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jisas ulɨmento, Anɨtu sohuneꞌno kako aꞌamumo mokosyohumayo yahino hungkuno hiyasoꞌmo woꞌmojoso sekwo sohwasimo nto setɨhwamentisofoho. I osoꞌno aꞌamu kengo sohwa hofɨko pahnnɨmo hungkunoꞌnohini upaꞌnɨfe. Sekumo yoloho waselɨmo. ");
INSERT INTO apz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hohonta Aisaiya ole mtɨmokumento, Hofɨko nuhwonɨngkuji neso nuhwonɨfitnneꞌmaho. Hofɨko nupaꞌnɨngkuji oso hungkunoso huno itoꞌno uyoneꞌmaho. Hofɨko honɨngkano wonyo somo hohujo mikinjaopijoso Anɨtu hofɨkoe wonyo wae mmofonehoho. Ose mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisas ose ulonto ulɨmento, olo pahnnɨmo hungkuno hwe ufongoyo fisosɨmokaꞌmentisoso sekwo huno maseyoho liyohoho. I pahnnɨmo hungkuno nomꞌne songoso sekwo huno pipi seyohoho. ");
INSERT INTO apz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Upaꞌnɨmno. Hwapɨngoso olenoho. Hwe ufongoyoꞌnjo sohwo Anɨtuye hungkuno aꞌamumo lutɨhwayo paꞌnɨngofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Fiso ufongoyo honɨngkanopo pɨwahuꞌmentisoso oso hwe moyaꞌmi hofɨko hungkuno wopɨngo upaꞌnɨwoꞌnɨngkohofo paꞌnyofoho. I osoꞌno Seten kako noponto oso hungkuno wopɨngo sɨmeho moꞌmo hoꞌnosyahonɨngki Seten wae yamoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nomꞌne aꞌamuso ufongoyo hwaho sojoꞌnjopo pɨwahuꞌmentiso paꞌnyo hwafoho. Oso aꞌamu hiso Anɨtuye hungkuno upaꞌnontɨfi hofɨko komoꞌno sɨmeho moꞌmo mehoꞌnasyontɨfi sɨmonyo iwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","I osoꞌno hofɨkoe pmpongo anefoho. Oꞌo, hofɨko weꞌenepi nolohofontanɨngkofi aꞌamu nomꞌneso Anɨtuye hungkuno hwotoho wahmmo lososo oso aꞌamu nolohofontanjo huhwo sohwamo tango engo uyahonɨngki hofɨkoe pmpongo ane soꞌno pɨwasyɨwoꞌningkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nomꞌne aꞌamu ufongo hwaho nantɨpe yongoꞌnjo paꞌnyofoho. Hofɨko Anɨtuye hungkuno upaꞌnɨmentohofoso ");
INSERT INTO apz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","i, yoꞌmayo hwaho loponjo somneꞌno huno engo syafɨsyontɨfi hamniyoho engo womano lontɨfi yahonɨngkofi hofɨko hoꞌyango yoꞌmayo soꞌno hi umoꞌnyoso oso hiso Anɨtuye hungkunomo kingkulofɨwoꞌnɨngkohofofoho. Oso huhwo sohwa ne ane hwafoho. ");
INSERT INTO apz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nomꞌne aꞌamuso hofɨko ufongoyo hwaho afofoꞌnjo paꞌnyofoho. Hofɨko Anɨtuye hungkuno upaꞌnontɨfi oso hungkuno hiso inɨngkawentɨfi hofɨko Anɨtumneꞌno yoꞌmayo syoho wopɨngo yɨwoꞌnɨngkohofofoho. Oso ne intoꞌnnyofoho. Ne fiso weꞌe (teti, 30), nomꞌne engo (sikɨsɨti, 60), fiso piꞌnɨngo engofoho (wan hantɨlet 100). Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas nomꞌne pahnnɨmo hungkuno ulɨmento, Aꞌamu fihwo sikiloho mongkujɨhwosi oso pomponaho hiso ahwonteꞌmo kipitofasiyoꞌeno. Epohumayo enjwaꞌmo hoꞌnasiyoꞌeno. Awonoho. Kako ijempohopo ufohoꞌofahumontonoho. ");
INSERT INTO apz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yoꞌmayo olohonta aꞌamu hiyaso mokosyohumawoꞌnɨngkohofoso hwangku aꞌamu hopiꞌnono pomponahopo uhwonantɨfeho. Yoꞌmayo olohonta pahnnɨmo hungkuno lɨwoꞌnɨngkoheso hwangku aꞌamu neso upoꞌnantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sekwo halohoꞌnjo kuꞌmanji nje hungkunomo haloho popmno. ");
INSERT INTO apz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ose ulonto nomꞌne hungkuno ulɨmento, Yoꞌmayo pahnnɨmo hungkuno upoꞌnalokwofoso hwapɨngo ne ngko selalokwe soꞌno huno itoꞌno fɨsyafɨhupmno. Sekwo nomꞌne aꞌamumo hofɨkimo ufoꞌmayoꞌne Anɨtuye hungkuno ulɨkuno. Sekwo aꞌamumo Anɨtuye hungkuno ufijo hopaso Anɨtu kako sekumo wosejapmmontonoho. Sekwo ose ifijoꞌmanji sekwo Anɨtumneꞌno huno engo wotɨpemantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hwe fihwo Anɨtuye hungkuno sɨmeho moꞌmo mnawoꞌnnyo sohwo oso hungkuno hiso kako itoꞌno inɨngku lohofososo Anɨtu kako huno engo umontonoho. Hwe nomꞌnehwo Anɨtuye hungkuno weꞌenohini sɨmeho moꞌmo mnawoꞌnnyo sohwo oso hungkuno weꞌeso itoꞌno minɨngkayoꞌnjoso oso hungkuno weꞌeso moiꞌwo umoꞌmtonoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas nomꞌne pahnnɨmo hungkuno ulɨmento, Hwe fihwo olo hwaho lopo kakoe syohoꞌmo ipisayo hulɨmentisofoho. Oso hiso Anɨtu kakoe aꞌamumo emokosyohumayo paꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Hwe huhwo sohwo nohulonto kakoe angopono nowento sɨkuno piꞌnɨngo fosyowelɨkafo imojo hweho. Ipisayo hiso pipi fokaꞌmentisoto. Fokafo hwapɨngoso hwe sohwo huno muyofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hwahomjo afofoso ipisayo engo imokiyofoho. Sɨmoꞌmo swo inɨkwato lohofɨhwosi osopo sɨmoꞌme ipehwosi tɨfi ipisayo untoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ipisayo mojo ihwosoꞌno hwe huhwo sohwo kako nolofamjonefoho. ");
INSERT INTO apz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nomꞌne hungkuno Jisas ulɨmento Anɨtu kakoe aꞌamumo mokosyohumayoso ngko pehofo losetɨhwamnehono. Osoꞌno pahnnɨmo hungkunoso pehofo selɨmnehono. ");
INSERT INTO apz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Olenoho. Iyo fihwo kakoe yofe masɨtet kakoe neso nomꞌne iyo ipisayo paꞌnyoꞌmaho. Oꞌo, nɨhuꞌno weꞌefoho. Oso neso aꞌamu syohopo hulɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Syohopo hulahonɨngkofi oso ipisayo hiso engo imoꞌnonto nomꞌne iyo syoho soponjo somo yakolonoho. Kakoe pamo sopo yɨhuꞌaifo syuhwosi pompenjiyo hofiyo wonyoangkafopo wokehumantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas pahnnɨmo hungkuno piꞌnɨngo engo ulɨmentisoso hofɨko huno syafɨhupitnneꞌento ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kako aꞌamu somo pahnnɨmo hungkunoꞌnohini ulɨmentisofoho. Kako kakoe inomokomoyo sohwantnnohini humantɨfi kako yoloho ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Oso sɨkuno hiso mofehiꞌnyo ntonɨngkuꞌnɨngkahonɨngki Jisas kakoe inomokomoyo sohwamo ulɨmento, Mijo nongkihntaꞌni woekehwano. ");
INSERT INTO apz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ose ulahonɨngki hofɨko aꞌamu piꞌnɨngo engo uhuꞌmokumentohofo somo ulɨkoꞌmantɨfi yofayokinomo Jisas humamentiso somo kotasontɨfi hofɨko mijo ayopo wakoꞌmentohofofoho. Wakoꞌmentohofoso nomꞌne aꞌamu hofɨko hofɨkoe yofayokinomo hofɨkoꞌnji wakoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nowekentanɨngkofi ifofo engo ikwato lohofonto mijo yofayokinomo ifeehuꞌmo lohofonto mijo yofayokinomo engo weeoꞌmto imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas yofayokinomo fehohntaꞌni mnokino ikwoꞌofo yasyonto saho fosyowentanɨngki hofɨko Jisasɨmo ulɨkafontɨfi ulɨmentohofi, Lonetɨhwayo sohwosi tɨfonepo nakwoe yofe moiꞌwo umoꞌnantanoho. Kɨko nakuneꞌno huno mosyafɨsiyoꞌnjo liyalokuno. ");
INSERT INTO apz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ose ulahonɨngkofi Jisas nolɨkafonto ifofomo yoka ulɨmento, Moiꞌwo hmmoꞌnyo. Ose ulonto mijomo ulɨmento, Ntaꞌnoho. Itoꞌno fɨlufawofo. Ose ulahonɨngki ifofo moiꞌwo imoꞌnɨngkahonɨngki mijo apaꞌno songo songo miyoꞌnjo nɨhuꞌnahone lɨfawoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Itoꞌno lɨfawoꞌmentisoso inomokomoyo sohwamo ulɨmento, Sekwo iyoho pehoꞌno senɨngkohoho. Sekwo Anɨtumo sɨmeho hiꞌntnnono muyoꞌnjo liyalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ose ulahonɨngki hofɨko iyoho engo unɨngkahonɨngki hnnɨmentohofi, Olo hwe lohwo ifofoꞌnji mijoꞌnji kakimo halohoꞌnohini upesolo tɨhwoe huhwolo. ");
INSERT INTO apz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas kakoe inomokomoyo sohwanji mijo nongkihntaꞌni aꞌamu Ngkelasafe hwahopo iꞌmofapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Hwe towahuno wonyoꞌnjo sohwo hwaho hopo sopo humunyoponoho. Oso hwe huhwo sohwo kako aꞌmopijohino sokimo somo humunyoponoho. Aꞌamu angoponjo sohwa kakimo impe intoꞌmentohofofoho. Hofɨko ahwomo nano yokumpohnꞌnyo nomantɨfi hwe sohwoe sɨfe aho ahwomo nano kilofɨwoꞌnɨngkahonɨngkofi kako nano hotitoꞌmentisofoho. Kakoe yokumpohnꞌnyo hofɨkimo uyakolofɨwoꞌnɨmentisofoho. Sɨkuno huhwo huhwi oso hwe huhwo sohwo aꞌmopijohinopo hwofɨkiꞌnyopo humemayonto joho mohmꞌmo lɨmojo hweho. Kako sokisɨhuꞌnji kakoe aꞌapahomo fongkinɨwoꞌnɨmojofoho. Oso hwe huhwo sohwo ikanopo ntaꞌni Jisasɨmo uhwonɨhwojawento, kako hano komoꞌno nowento, Jisas yofayokino mtaꞌni swapmmentisoso hwe sohwo iꞌmofaponto, Jisasɨye sɨfekiꞌnyoꞌmo ipitofawoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jisas towahuno wonyo sohumo ulɨmento, Kɨko towahuno wonyo sohwosi olo hwe lohumo ulɨkoꞌmaho. Ose ulontanɨngki towahuno wonyo sohwo joho mohmꞌno ulɨmento, Jisas, kɨko Anɨtu Yokintahoponjo sohwoe Hwomu Ne hwosoho. Kɨko ngkimo peho wantohoꞌmonneꞌelo. Anɨtu nupaꞌnɨngkuhwosoꞌno ngko jomo wakilɨmonneꞌno yohono. Kɨko ngkimo tohino nontapohotoho. ");
INSERT INTO apz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ose ulahonɨngki ulɨmento, Nje yofe Ami hwonaꞌnyoho. Nakwoe hungkuno ole: Aꞌamu sɨsɨhwayo apaꞌno, piꞌnɨngo engofoho. Nakwo towahuno wonyo weꞌe mohumulohwono. ");
INSERT INTO apz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Towahuno wonyo huhwo sohwo Jisasɨmo joho yokumpohnꞌnyo ulɨmento, Kɨko ango ikanoꞌmno lonehwajohotoho. ");
INSERT INTO apz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Oso hwofɨkiꞌnyo mofone sopo yahu piꞌnɨngo engoso hofɨko mno ijontanɨngkofo somneꞌno ");
INSERT INTO apz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","towahuno wonyo sohwa Jisasɨmo yokumpohnꞌnyo ulɨmentohofi, Kɨko nakumo oso yahu piꞌnɨngo engo nongkwanjo nomponeꞌno filonehwajo. Nakwo yahu somo wehuhnnofano. ");
INSERT INTO apz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ose ulahonɨngkofi Jisas hofɨkimo tɨmo honɨhwajɨmentisofoho. Oseso oso towahuno wonyo hiso hwe sohumo nulɨkoꞌmantɨfi yahu somo ehuhnawoꞌmentohofofoho. Ehuhnnaofahonɨngkofi yahu hiso tu tausenɨso (2000) hofɨko hano kunto kuntoꞌno wentɨfi iwoꞌmangomo mtɨkuꞌnontɨfi mijo ayomo mihulofahonɨngki nɨhuꞌnahone poyo peꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hwe yahu mokosyohumayo sohwa komoꞌno nowentɨfi hwe moyaꞌmi ango soponjo soꞌnji osoꞌmo soꞌmeemjo soꞌntnneꞌno oso hungkuno hiso lɨjwaofahonɨngkofi hoꞌnɨmmentisofoho. Oso hungkuno hiso hoꞌnɨngkahonɨngki hwe moyaꞌmi hopiꞌnonohinoso uhwonano lontɨfi imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hofɨko Jisasɨmo nuꞌmantɨfi hwe towahuno wonyo humamojo sohumo uhwonɨmentohofoso kako he yofonto kako huno wopɨngoꞌnjo imoꞌnɨmentisofoho. Ose uhwonontɨfi hwe moyaꞌmi iyoho imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aꞌamu yoꞌmayo uhwonɨmentohofoso hofɨko iꞌmofapmmentohofo somo yoꞌmayo hwe iloꞌnnyo sohwo imentiso soꞌno yahu poyo imoꞌnɨmentiso soꞌno ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ose ulontɨfi hofɨko Jisasɨmo hungkuno yokumpohnꞌnyo ulɨmentohofi, Kɨko nakwoe hwahopo humahnnoso wopɨngoꞌmaho. Mpano. ");
INSERT INTO apz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ose ulahonɨngkofi hwe towahuno wonyo wae imentiso sohwo Jisasɨmo jomo yokumpohnꞌnyo ulɨmento, Ngko kɨkoꞌnji wowantayoꞌno yohono. ");
INSERT INTO apz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ose ulahonɨngki Jisas ulɨmento, Oꞌo jɨje aꞌamufe angopo nowehoji yoꞌmayo wonyoangkafo Anɨtu kilohoꞌmaso soꞌno fɨlutɨhwaho. Anɨtu hitoho engo kikimo kufoꞌmaꞌmaso soꞌno aꞌamumo uso. ");
INSERT INTO apz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ose ulahonɨngki hwe sohwo nowento oso hwaho Ntekapolis ango aho hufaꞌu hopiꞌnono sopmmeemo yoꞌmayo Jisas ulohoꞌmentiso soꞌno lutɨhwomentisoso aꞌamu hopiꞌnono nupaꞌnontɨfi huno piꞌnɨngo syafɨsyontɨfi pisopisaho mjalɨmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas hofɨkoꞌnji yofayokinopo mijo ayo somo apaꞌno wakentɨfi nongkihntaꞌni kiꞌmofɨwahonɨngkofi osopo aꞌamu piꞌnɨngo engo uhuꞌmokahonɨngkofi Jisas mitɨmomɨngopo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hwe yofe engoꞌnjo tajo ango mokosyohumayo sohwo kakoe yofe Jailos. Osohwo noponto Jisasɨmo uhwononto kako hwomtame ehumanto ");
INSERT INTO apz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","sɨmeho tangoꞌnjo humanto jomo yokumpohnꞌnyo ulɨmento, Nje mu wapeꞌnɨmonteꞌno yalofoho. Kɨko nopohoji kakimo jɨje ahoso fɨkisyusyo. Kako wopɨngo imoꞌnɨngkuhwosi kako songo wohumano. ");
INSERT INTO apz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ose ulahonɨngki Jisas hwe sohwoꞌnji womentisiyefoho. Womentisiyeso aꞌamu piꞌnɨngo engo sikoꞌnji nowentɨfi hofɨko yohoto yohotofo lohoꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aꞌmu fisi mnokino engoꞌnjosi humunyoponoho. Oso hisi kako engolopohamo imoihoso neꞌno yontanɨngki soswo aho hopiꞌnono sɨfe mtaꞌni hufaꞌu uyakoloꞌmojofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Aꞌamu uyo hofaho syohoꞌnjoso hofɨko kakineꞌno molasin ko uyahonɨngkofi kako tohino engo maꞌmojofoho. Kakoe hamniyoho hoꞌyango hopiꞌnono moiꞌwo ihnꞌnamoꞌnɨmojofoho. Oseso wopɨngo mmoꞌnyofoho. Oꞌo, mnokino engo umojofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Oso aꞌmu hisi yoꞌmayo Jisas imentiso soꞌno upaꞌnonto kako huno ole syafɨhuꞌmento, Ngko olo hwe lohwoe manjiꞌmofo somo aho kisahumeso ngko wopɨngo umoꞌnɨmonnoho. Ose lonto oso aꞌmusi Jisasɨye hohujo hohntaꞌni uꞌmanto kakoe hwapɨfemo aho upmꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Upmꞌmokumentisoso kakoe mnokinoso moiꞌwo imoꞌnɨngkahonɨngki kakoe aꞌapaho wopɨngo imoꞌnɨmentisofoho. Wopɨngo imoꞌnonto sɨmeho wopɨngo komoꞌno umoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jisas aꞌamumo wopɨngo imokonto huno uyɨmentisoso komoꞌno ikinjamo lohofonto ulɨmento, Tɨhwo nɨpmꞌmokohoho. ");
INSERT INTO apz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ose ulahonɨngki kakoe inomokomoyo sohwa ulɨmentohofi, Hwe moyaꞌmi piꞌnɨngo ifehuꞌmokokumaso soꞌno kɨko tɨhwo nɨpmꞌmokohoho eso pehoꞌno lohino. Nakwo huno monayofoho. Tɨhwolɨkeno. ");
INSERT INTO apz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jisas aꞌamu upmꞌmokiyo soꞌno feꞌnɨhwonɨngkahonɨngki ");
INSERT INTO apz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","aꞌmusi aꞌapaho wopɨngo imoꞌnɨngkohoho huno uyahonɨngki iyoho unɨngkahonɨngki yomo yomo yonto Jisasɨye sɨfɨkiꞌnyoꞌmo hwomtame ulohoꞌmentisofoho. Yoꞌmayo hopiꞌnonohino soꞌno Jisasɨmo ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisas kakimo ulɨmento, Nje mupe, Kɨko ngkimo sɨmeho hiꞌntnnono ntapohino soꞌno olohonta kɨko wopɨngo imoꞌnɨngkino. Kɨko sɨmeho wopɨngoꞌnjo uhuji fohumantono. Jɨje aꞌapaho nɨhuꞌnahone wopɨngo kumoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ose ulontanɨngki hwe fihwo Jailosɨye angopo ntaꞌni noponto Jailosɨmo uꞌmantɨfi ulɨmentohofi, U, nakwoe hwe engofo, jɨje mu poyo nto peꞌnɨngkohoho. Oseso kɨko olo Lutɨhwayo lohumo jɨje ango poneꞌno pehoꞌno ipemotowalokuno. Kako wohumano. ");
INSERT INTO apz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ose ulohonɨngkofi Jisas upaꞌnonto Jailosɨmo ulɨmento, Kɨko iyoho yohotoho. Kɨko ngkimo jɨje sɨmeho hiꞌntnnono ntape. ");
INSERT INTO apz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ose ulonto Jisas kako hwe moyaꞌmi hopiꞌnonohinomo angomo lɨhumajonto Pitaꞌnji Jemɨsɨꞌnji konɨngkwaꞌwehwo Jounꞌnji hofɨkoꞌnohini Jisasɨꞌnji nowentɨfi ");
INSERT INTO apz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","hofɨko Jailosɨye angomo iꞌmofawentɨfi Jisas aꞌamu piꞌnɨngo uhwonɨmentisoso hofɨko humotahoꞌnji wosofe angiyo husontanɨngki ");
INSERT INTO apz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","kako noswonto ulɨmento Pehoꞌno wosofe lalokwofo. Mu lopi poyoꞌmaho. Oꞌo saho fosyaweho. ");
INSERT INTO apz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ose ulahonɨngki hofɨko kakimneꞌno sitofo ulontɨfi tɨkafo ujɨmentohofofoho. Oseso Jisas hofɨkimo mempo hohntaꞌni wae sweefaopmmentisoso Jisas mu lopiye kanɨngkwohwoꞌyaꞌuꞌnji inomokomoyo sohwanji ango mu sopi fosyowentanjo somo humentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jisas mu poyo simo aho manto kakimo aꞌamu Jutafe hungkunomo ulɨmento, Talita kumi, Oso hungkunoso ole, Olo mu lopi, filɨkaho. ");
INSERT INTO apz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ose ulahonɨngki mu lopi nolɨkafonto hano umentisofoho. Mu lopiye soswoso aho hufaꞌu hopiꞌnono sɨfe mtaꞌni hufaꞌu uyakoloꞌniyoho. Aꞌamuso homo somo uhwonontɨfi yomo engo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisas kanɨngkwohwoꞌyaꞌumo hungkuno yokumpohnꞌnyo ulɨmento, Ngko mu songo umokohe soꞌno siki nohoꞌnomɨhwoloho. Mu lopimo wopayo unyo. Ose ulonto umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Osopo ntaꞌni Jisas kakoe inomokomoyo sohwanji nowentɨfi Jisasɨye ango Nasalet uꞌmofamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Salolemo aꞌamu Juta sofe iyoho humayo sɨkuno somo Jisas tajo angomo lutɨhwahonɨngki aꞌamuso piꞌnɨngo nohumantɨfi upaꞌnontɨfi Jisasɨye huno engo soꞌno yomo yontɨfi ulɨmentohofi, Olo hwe lohwoe hungkuno ntɨꞌmtaꞌangoto. Oso huno engoꞌnji pipi imoꞌnɨngkohoho. Yoꞌmayo wonyoangkafoꞌnjo aꞌamu miyoso olo hwe lohwo yɨwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Olo hwe lohwo kako ango molɨmojo lohwolaho. Maliyafe hwomufoho. Jemɨs, Jousep, Jutas, Saimoun hofɨkoe hofilaꞌwehweho. Homnampija olo ango lopo nakwoꞌnji humalofo. Ose ulontɨfi hofɨko sɨmano hintotohino umnɨngkahonɨngki nakwolaho lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisas ulɨmento, Aꞌamumo hwe fihumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwo ango kengo hopiꞌnonohinopo kakoe yofe engo hoꞌnomowoꞌnɨngkohofofoho. I osoꞌno osohwo kakoe temtitofo kakoe kanɨngkwohwoꞌyaꞌu hamnɨngkwohwosa hofɨko kakoe yofe mohoꞌnomasofoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Aꞌamu hiso hofɨko Anɨtu Jisasɨmo oso syoho hisoꞌno uhwosopoꞌmentiso soꞌno sɨmeho hiꞌntnnono muyoꞌnjo imentohofo soꞌno Jisas osopo yoꞌmayo wonyoangkafoso piꞌnɨngo mimmentisoso aꞌamu mnokinoꞌnjo angaꞌno angaꞌnohinomo kako aho kisasyonto wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hofɨko Jisasɨmo sɨmeho hiꞌntnnono muyo soꞌno yomo imentisofoho. Oso hwaho sopo kako angkuhwafo sohwaꞌi emayonto, Anɨtuye hungkuno lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisas kakoe inomokomoyo sɨfe mtaꞌni hufaꞌuyo sohwamneꞌno joho ulahonɨngki hofɨko nuhuꞌmokahonɨngkofi Jisas kakoe yokumpohnꞌnyo yano uyɨmentisofoho. Oso yokumpohnꞌnyoso aꞌamufe aꞌapahoꞌmjo towahuno wonyo wae yaofoꞌne umentisofoho. Umentisoso hwe sohwamo hufaꞌu hufaꞌu lɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jisas hofɨkimo ulɨmento sekwo hoꞌyango ane fɨwanɨmno. Mnoꞌnohini mtamno. Wopayo, hoꞌyo, hamniyoho, oso nomotakutoho. ");
INSERT INTO apz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Manjiꞌmofo hufaꞌu nomafɨkutoho. Oꞌo, manjiꞌmofo angaꞌnohinoꞌnji sekwoe sɨfɨkwongofosyoꞌnji manjiꞌmoꞌnɨngkuji fɨwanɨmno. ");
INSERT INTO apz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sekwo ango fipo iꞌmofahokuji ango angaꞌnohino somo saho fosyawopijo. Oseso sekwo oso ango somo nulɨkoꞌmafɨkuji nomꞌne angopono fɨwanɨmno. ");
INSERT INTO apz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nomꞌne angopo sekwoꞌne ango mosejapeꞌmanji i sekwo oso ango hopo sopo nulɨkoꞌmafɨkuji hopo sopo hwaho semongkiꞌnososo hofɨko nosehontohumentanɨngkuji oso hintalinyo hiso wae feehumno. Oso homo somo uhwonɨngkuji hofɨko hofɨkoe yahino somneꞌno huno ole wosyafɨhupɨfe. U, nakwo wonyo yɨhwono. Ose syafɨsyɨkuji iyoho unono. ");
INSERT INTO apz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ose ulahonɨngki inomokomoyo sohwa nowentɨfi aꞌamu somo hungkuno ole ulɨmentohofi, Sekwo sɨmeho fɨwoloꞌmokumno. ");
INSERT INTO apz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ose ulontɨfi towahuno wonyoso wae yaofontɨfi aꞌamu mnokinoꞌnjo somo hofɨko hwone mijo mnokinopo usisyontɨfi wopɨngo umokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yoꞌmayo Jisas imentiso soꞌno aꞌamu piꞌnɨngo engo lɨmotofoso hwe yofe engoꞌnjo Helout kako upaꞌnɨmentisofoho. Fiso aꞌamu Jisasɨneꞌno ole ulɨmentohofi, Olo hwe lohwo Jounɨyoho. Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwo poyo peꞌnonto apaꞌno lɨkaꞌmaso hwolɨkeno. Osoꞌno yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso kako iwoꞌnɨngkiso soꞌno yokumpohnꞌnyo iꞌmofapohoho. ");
INSERT INTO apz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aꞌamu nomꞌneso Jisasɨneꞌno ole ulɨmentohofi, Olo hwe lohwo Ilaija hohonta peꞌnɨmentiso hweho. Nomꞌne aꞌamuso ole ulɨmentohofi, Olo hwe lohwo aꞌamu hohonta Anɨtu hungkuno uyahonɨngki lɨmojo paꞌnɨngo hweho. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Oseso Helout nupaꞌnonto ulɨmento, Olo Jounɨyoho. Hwe aꞌamumo mijo kiyomaꞌmojo hweho. Ngko aꞌamu kakoe tɨꞌwango fɨwofitofosyamno ulɨmentoheso nto yɨwafitoꞌmentohofo sohwo apaꞌno lɨkaꞌmaso hwolɨkeno. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hwapɨngoso hohonta Helout kako Jounɨmo impoꞌangomo mɨhumajonto ahwomo nano kilofahumentisofoho. Helout Jounɨmo impoꞌangomo pehoꞌne mɨhumatɨꞌmentisoto. Hwapɨngoso kolaꞌwehwoe Filipɨye ape Heloutiyasɨmnefoho. Helout olo simo maꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Hohonta Joun Heloutɨmo ulɨmento, Kɨko hnnɨkwaꞌwehwoe ape mahino loso hopoꞌmaho. Oꞌo oso honɨngkano pisakinoꞌnjofoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Impe intofahonɨngkofi Heloutiyas sɨmano lɨkumpo lohofonto Jounɨmo poyo umokumonto ko imentisoso ");
INSERT INTO apz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helout Jounɨye yofe hoꞌnomaꞌmentisofoho. Joun kakoe honɨngkano itoꞌnohino hwe wonyoangkafo hweho. Osoꞌno Helout huno uyahinɨngki, Heloutiyas Jounɨmo poyo koimokumneꞌento Helout kako Jounɨmo impoꞌangomo itoꞌno mokosyohumamentisofoho. Helout Jounɨye hungkuno upaꞌnɨwoꞌnɨngkiso soꞌno yomo ko yonto huno piꞌnɨngo engo syafɨsyonto nomꞌne hungkuno upaꞌnɨmo lɨmentisofoho. Osoꞌno Heloutiyas Jounɨmo fonjasyɨhwoloho. ");
INSERT INTO apz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Oseso hwangku sohonta Heloutiyas Jounɨmo fonjasiyoꞌneꞌento honɨngkano tɨpemaꞌmentisofoho. Osohonta Helout kakoe sɨkuno konaꞌwohi aswo maꞌmentiso somneꞌno huno syafɨsyonto aꞌamu syoho ulohofiyo sohwa wopayo iloho yahonɨngkofi hwe engo aꞌamumo mokosyohumayo sohwanji nɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Heloutiyasɨye mu sijosi noswaponto hofɨkoe sɨmeho wopɨngo umoꞌnono lonto sɨmonyo imentisofoho. Aꞌamu sohwanji Heloutɨꞌnji nuhwonontɨfi sɨmeho wopɨngo umoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Osoꞌno Helout musopimo ulɨmento, Kɨko yoꞌmayo pehoꞌno kumoꞌnososo ou kɨko njo. Ngko wokijapmmo. Yoꞌmayo piꞌnɨngo engo hiꞌnjo hwoꞌnyoho. Kɨko fehohnjoꞌno njisoso ou ngko fehohnjoso wokijapmnoho. Nehopi kilohono. ");
INSERT INTO apz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ose ulahonɨngki mu sopi noswonto konaꞌwohimo ulɨmento, Pehoꞌno ulɨmnehono. Ose ulahonɨngki Heloutiyas ulɨmento, Ole uso. Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwoe mnokinoꞌno nɨmoꞌnɨngkohoho. Kakoe mnokinoso ikuꞌyopo hoꞌnasyohoji komoꞌno ntape. Ose uso. ");
INSERT INTO apz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ose ulahonɨngki mu lopi komoꞌno asomo noswonto Heloutɨmo ulɨmento, Kɨko Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwoe mnokinoso noswonyopo yɨwojosyalokumpehoji olopo ntape. ");
INSERT INTO apz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ose ulahonɨngki Helout kakoe sɨmeho tango mɨkunɨmposo umnɨmentisofoho. I osoꞌno aꞌamu hopiꞌnono kakoe hungkuno, Nehopi kilohono, ose nto upaꞌnɨngkohofo soꞌno kako aꞌmu simo eno ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Oseso Helout komoꞌno hwe Jounɨye mnokinoꞌno uhwojahonɨngki hwe huhwo sohwo impoꞌangomo nowento osopo Jounɨye tɨꞌwango iwofitofonto ");
INSERT INTO apz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jounɨye mnokinoso noswanyopo iwojwosyalokumpentɨfi aꞌmu sijo simo nuyahonɨngkofi nomotawento konaꞌwohimo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jounɨye inomokomoyo sohwa yoꞌmayo soꞌno upaꞌnontɨfi hofɨko nopontɨfi kakoe pijafoso nomantɨfi sokimomo hoꞌnahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisasɨye inomokomoyo kako lɨhwatɨmentiso oso hwa asomo uꞌmantɨfi yoꞌmayo hofɨko imentohofo soꞌno hungkuno aꞌamumo lutɨhwamentohofo soꞌno Jisasɨmo ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Osopo aꞌamu piꞌnɨngo engo nowentɨfi nopontɨfi nohnnawe yahonɨngkofi osoꞌno Jisasɨye inomokomoyo (apousel) sohwa wopayo manyofoho. Osoꞌno Jisas ulɨmento, Nakwo aꞌamu ane sopono nowekehwasi osopo sekwo usijoꞌno fosyohumamno. ");
INSERT INTO apz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ose ulahonɨngki hofɨkoꞌnohini yofayokinopo aꞌamu ane sopono wowanontɨfi imentohofo soponeꞌno. ");
INSERT INTO apz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Aꞌamu piꞌnɨngoso uhwonontɨfi hofɨkimo yofe uhwofontɨfi aꞌamu ango hopiꞌnonohino mtaꞌangoso komoꞌno honɨngkanopo nowentɨfi Jisas kakoe aꞌamu yofayokinoꞌnjo sohwamo uyakolofontɨfi aꞌamu ane sopo sɨmoꞌmo uꞌmofamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisas mitɨmomɨngopo iꞌmofaponto uhwonɨmentisoso hwe moyaꞌmi piꞌnɨngo engo somo uhwononto hofɨko yahwohofekwosa ane paꞌnyo hwafoho. Osoꞌno kako hitoho uloꞌmentiso soꞌno hungkuno piꞌnɨngo engo lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mofehiꞌnyo ukwoꞌmokumonto yahonjo soꞌnji Jisasɨye inomokomoyo sohwa nopontɨfi ulɨmentohofi, Olo hwaho hopo lopo sopo aꞌamu aneponoho. Weꞌenepi mofehiꞌnyo ukwoꞌmokumontonoho. ");
INSERT INTO apz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kɨko oso hwe moyaꞌmi somo ango somneꞌno lɨhwajohojoꞌno hofɨko nukuji wosopayo mpe uyɨfe. ");
INSERT INTO apz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ose ulahonɨngkofi Jisas ulɨmento, Oꞌo, sekwo huhwasi wosopayo uyɨmno. Ose ulahonɨngki ulɨmentohofi, Nakwo pipilo. Hamniyoho syoho sɨkuno tu hantɨlet (200) memjaofoso aꞌamumneꞌno wopayo mpe iyoꞌneso hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ose ulahonɨngkofi Jisas ulɨmento, Wopayo alalelo weho. Tɨmo uhwonamno. Ose ulahonɨngki hofɨko nowentɨfi uhwonowentɨfi ulɨmentohofi, Nakwoe wosopayo aho angaꞌno hopiꞌnonohinofoho. Inanɨku hufaꞌu weho. ");
INSERT INTO apz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ose upaꞌnonto Jisas kakoe inomokomoyo sohwamo ulɨmento, Sekwo aꞌamu somo ulɨmno, Hoja lopo fosyohumamno. ");
INSERT INTO apz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ose ulohonɨngki hofɨko nohumantɨfi fipo aꞌamu wan hantɨlet (100), nomꞌnepo aꞌamu fifɨti (50), oseꞌno oseꞌno lɨhumajɨꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jisas kako oso wosopayo aho fehohnjo hopiꞌnonohino soꞌnji inanɨku hufaꞌu soꞌnji nomanto kako ahwomomo tɨmo uhwontohumanto Anɨtumo isamoyoka ulɨmentisofoho. Isamoyoka nto ulonto kako wopayoꞌnji inanɨkuꞌnji kutɨkujo lohofonto kakoe inomokomoyo sohwamo aꞌamu somo yano ulofiyoꞌne huꞌmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Aꞌamu hopiꞌnonohinoso wopayo hiso moiꞌwo nontɨfi sɨmeho uhnnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sɨmeho uhnnɨngkahonɨngki hofɨko wosopayo nɨlɨfonaoꞌmentohofoso nuhuꞌmokontɨfi sohwo hoꞌyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo somo mohuꞌmemeehumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Aꞌamu oso wosopayo hiso Jisasɨye aho mtaꞌni nɨmentohofoso hwe weꞌe humamentohofoꞌmaho. Hweꞌnohini oso wosopayo nɨmentohofo sohwa faif tausen (5000) humamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Osohonta Jisas kakoe inomokomoyo sohwamo ulɨmento, Sekwo yofayokino nomafɨkuji oso hwaho nongkihntaꞌni Mpetɨsaitaꞌno sɨmoꞌmo mpanɨmno. Ose ulonto aꞌamu nomꞌne somo hofɨkoe ango pone lɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ose ulonto aꞌamu somo ulɨkoꞌmanto kako hwofɨkiꞌnyo weꞌe sopo Anɨtumo jomo ulɨmo lonto sɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sɨkunoꞌnji inomokomoyo yofayokinoꞌnjo sohwa mijo ajwopo nohumentanɨngkofi Jisas kakoꞌnohini mitɨmomɨngopo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jisas uhwonɨmentisoso yofayokino hono honi wahonɨngki hofɨko yokino wonyopi imentohofofoho. Hwapɨngoso ole, ifofo engo pahonɨngki wonyopi imentohofofoho. Iyoho walongkonɨmonto yahonjo soꞌnji Jisas mijo yokintahopo hano wento inomokomoyo sohwamo uꞌmaꞌmentisofoho. Ngko hofɨkimo uyakoloꞌmo nolonto ");
INSERT INTO apz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jisas mijopo hano sontanɨngki inomokomoyo sohwa hofɨko nuhwonontɨfi yomo yomo yontɨfi huno ole syafɨhuꞌmentohofi, Mewosofoho. Ose syafɨsyontɨfi youwo lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Inomokomoyo hopiꞌnonohino sohwa Jisasɨmo uhwonontɨfi iyoho engo unɨmentisofoho. Oseso Jisas hofɨkimo komoꞌno joho ulɨmento, Sekwo yokumpohnꞌnyo hmmoꞌnɨmno. Ngkonoho. Sekwo iyoho ikutoho. ");
INSERT INTO apz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ose ulonto kako yofayokinomo kotasahonɨngki ifofo moiꞌwo imoꞌnɨmentisofoho. Inomokomoyo sohwa yomo yontɨfi sɨmeho ulɨkofahonɨngki huno piꞌnɨngo syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jisasɨye yokumpohnꞌnyo hwapɨngo soꞌno huno muyofoho. Jisas kako wosopayo aꞌamu piꞌnɨngo engomo umentiso soꞌno inomokomoyo sohwa huno itoꞌno mosyafɨsiyofoho. Osoꞌno yomo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hofɨko mijopo nowakentɨfi Ngkenesalet nongkihntaꞌni ifohohosyahumentohofofoho. Ifohohosyasyontɨfi osopo yofayokino hoꞌnahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hofɨko yofayokino hoꞌnosyahonɨngkofi hwe moyaꞌmi hopo sopontaꞌangoso hofɨko yofe komoꞌno uhwofontɨfi lɨmentohofi, Jisasɨyoho. ");
INSERT INTO apz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Hofɨko yofe uhwofontɨfi hopo sopo hano komoꞌno nowentɨfi Jisas ntopohoho lahonɨngkofi aꞌamu nupaꞌnontɨfi hofɨko aꞌamu mnokinoꞌnjo somo Jisasɨyepono itokwapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jisas hoꞌmo soꞌmo nowahonɨngki aꞌmokuso aꞌamu mnokinoꞌnjo somo intokwapontɨfi wopayo mpe yɨwoꞌnɨngkohofo sopo itofasyontɨfi Jisasɨmo ulɨmentohofi, Hwe Engofo, nakwo jɨje manjiꞌmofomo aho wakupmꞌmokano. Ose ulontɨfi hofɨko kakoe manjiꞌmofomo aho upmꞌmokumentohofoso hofɨkoe mnokino moiꞌwo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Aꞌamu Falisi sohwanji aꞌamu Mousesɨye honɨngkano hungkunoso lutɨhwamotofo Jelusalem mtaꞌango sohwanji Jisas nohumentanjopo uhuꞌmokontɨfi ");
INSERT INTO apz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jisasɨye inomokomoyo sohwamo uhwonɨmentohofoso hofɨko aho mijo miyotɨkuꞌnyoꞌnjo wopayo nɨwoꞌnɨngkohofofoho. Falisi sohwafe yahinoso momasoꞌnjo hwafoho. ");
INSERT INTO apz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Aꞌamu Falisi sohwa aꞌamu Juta hopiꞌnonohino soꞌnji hofɨkoe yahino ole, Nakwo wopayo wonano lontɨfeso sɨmoꞌmo aho mijo yotɨkuꞌnontɨfi nɨwoꞌnɨngkohofɨhwafoho. Hohonta homnɨngkwohwosafe yahino oloso tɨpemaꞌmentohofofoho. Hofɨko huno ole aho miyotɨkuꞌnyoꞌnjo wopayo nososo ou sɨmeho moꞌmo wonyo mnaweho. Ose syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aꞌamu huhwo sohwa wosopayo mpe yɨwoꞌnɨngkohofo sopo ntaꞌni nopontɨfi aho mijo miyotɨkuꞌnyoꞌnjoꞌmanji hofɨko wopayo manyofoho. Nomꞌne yahino oso paꞌnyoso piꞌnɨngo weho. Hofɨkoe noswanyo, ikuꞌyo, hwontoho yoꞌmayoso mijo itoꞌno yajɨjɨwoꞌnɨngkohofoso kihoꞌneꞌmaho. Oꞌo hofɨkoe yahinofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Oseso aꞌamu Falisi sohwanji Jutafe hwe engo sohwanji Jisasɨmo ulohonɨmentohofi, Jɨje inomokomoyo sohwa neyakwosafe yahinomo minɨngkayoꞌnjo pehoꞌno yalokwofo. Hofɨko aho mijo miyotɨkuꞌnyoꞌnjo wopayo nɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Hohonta Aisaiya hwe Anɨtu hungkuno ulahonɨngki aꞌamumo lutɨhwamojo sohwo sekwo aꞌamu mangoꞌnohino hwasyo nehopi mtɨꞌmokumento, Olo aꞌamu loso hofɨko mango mtaꞌnohini hoꞌnonɨmawoꞌnɨngkohofofoho. I, hofɨko ngkimo sɨmeho montapefoho. ");
INSERT INTO apz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Hofɨko aꞌamu hwahoponjo sofe hunoso nomantɨfi Anɨtu mtaꞌangofoho lontɨfi aꞌamu hwaho ayoꞌmjo somo lutɨhwawoꞌnɨngkohofofoho. Osoꞌno hofɨko ngkimo wonyopi jomo ntɨwoꞌnɨngkohofofoho. Aisaiya ose mtɨꞌmokumtisofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Sekwo Anɨtuye hungkunomo haloho maposoꞌnjo yontɨfi seyakwosafe yahinomnohini inɨngkawowoꞌnɨngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ou, sekwo huno ole syafɨsyɨwoꞌnɨngkohofi, Nakwo hunoꞌnjo hwonaꞌnyoho. Ose lɨwoꞌnɨngkohofɨhwasoho. Sekwo Anɨtuye hungkunomo hwotoho fewoꞌnɨngkohofoso seyakwosafe yahino somo yɨwoꞌnngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mouses hohonta ole lɨmento, Kɨko jɨje mpohwo naꞌumo tɨfi finɨngkayo. U, aꞌamu fihwo kako hungkuno wonyo kanɨngkwohwo konaꞌwohimo uloso osohwo kako poyo wapeꞌnono. ");
INSERT INTO apz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","I, sekwo ole lɨwoꞌnɨngkohofo, Hwe fihwo kako hamniyoho hiꞌnjo sohwo kanɨngkwohwo konaꞌwohimo ufoꞌmayo soꞌno, i kako sikimo ulɨmontonoho. Ngko hamniyoho yoꞌmayoso wosejapmmonji ko yoheso ngko ole nto lɨmalefoho. Ngko Anɨtumo uyɨmneꞌno yohono. ");
INSERT INTO apz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Oso hwe huhwo sohwo ose ulonto kanɨngkwohwo konaꞌwohimo mufoꞌmasoꞌnjo yɨwoꞌnɨngkiso hweho. Osoꞌno sekwo Falisi sohwasi wopɨngofoho lontɨfi lɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ose ulontɨfi Anɨtuye hungkunomo hwotoho fewoꞌnɨngkohofofo. Seyakwosafe hunomnohini inɨngkawoꞌnɨngkohofofoho. Oso yahinoso angaꞌnohinofoho. Piꞌnɨngo oso paꞌnyoso weho. ");
INSERT INTO apz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas hwe moyaꞌmimo ngkiyepono wapɨfento joho ulɨmentisofoho. Nopahonɨngkofi ulɨmento, Sekwo hopiꞌnono itoꞌno nupaꞌnɨngkuji huno fɨsyafɨhupmno. ");
INSERT INTO apz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yoꞌmayo nyoꞌneso aꞌamufe honɨngkano wonyo umoꞌnɨmonteꞌmaho. Oꞌo yoꞌmayo sɨmeho mtaꞌangoso aꞌamufe hunoso wonyo hungkunoꞌnjoso honɨngkano wonyo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Sekwo halohoꞌnjokuꞌmanji nje hungkunomo haloho popmno. ");
INSERT INTO apz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas oso aꞌamu huhwo sohwamo ulɨkoꞌmanto ango nomꞌnemo swahonɨngki kakoe inomokomoyo sohwa ulɨmentohofi, Oso pahnnɨmo hungkuno lohinoso ne pipilo. ");
INSERT INTO apz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo huhwasi ngkineꞌno huno maseyoholiyohoho. Upaꞌnɨmno. Yoꞌmayo toho nyoꞌneso honɨngkano wonyo imokiyoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Oꞌo wosopayo hiso sɨmehomneꞌno nɨkwato nɨhuꞌnahone hoꞌnamo. Wopayo hiso jɨje hunomneꞌmaho. Ose ulɨmentisofoho. Osoꞌno Jisas yoꞌmayo hopiꞌnono nyoꞌneso hano mopitofasiyoꞌnjofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jisas nomꞌne hungkuno ulɨmento, Yoꞌmayo aꞌamufe huno mtaꞌangoso Anɨtuye tɨmo sopo oso hiso aꞌamufe honɨngkano wonyo imokiyofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yoꞌmayo huno mtaꞌni swaponteso ole, huno wonyo syafɨsiyo ape sikinjomo wonyo ulohofo, yoꞌmayoso hufo iyo, aꞌamumo fonjasiyo, nomꞌne hwafe ape hufo iyo ");
INSERT INTO apz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aꞌamumo yoꞌmayo soꞌno hi umoꞌnyo, yoꞌmayo wonyo honɨngkano, hwasyo hungkunojo, yokumpohnꞌnyo, sɨmeho wonyo, sitofo hungkunojo, ngko aꞌamu wopɨngoꞌnohino syafɨsiyoꞌne, yoꞌmayo fonɨfonyo. ");
INSERT INTO apz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Oso hopiꞌnono aꞌamufe hunomo mnaweho. Aꞌamu fihwo oso wonyoso huno syafɨsyɨhwosi kako yɨhwosoꞌno, kakoe honɨngkano wonyo imoꞌnonefoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Osopo ntaꞌni Jisas nolɨkafonto, hwaho pone Taiya mofone sopo nowento osopo aꞌamu fihwoe angomo nohumanto aꞌamu ngkimo yofe manɨhwofeꞌnjo yohofo ose kolonto aꞌamu Jisas humentanjoso poneꞌno huno moiꞌwo umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aꞌmu fisi oso ango sopo ntaꞌni kakoe mu weꞌe towahuno wonyoꞌnjosi Jisas humaho upaꞌnonto komoꞌno noponto Jisasɨye sɨfɨlakuꞌnyoꞌmo hwomtame ehumamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Olo aꞌmu losi kako Juta aꞌmuꞌmaho. Oꞌo, kakoe aꞌamu Founisiya, hwaho Siliya ntaꞌangiyoho. Kako Jisasɨmo jomo ulɨmento, Towahuno wonyo nje mumo humasolo wae ntohofiyo. ");
INSERT INTO apz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ose ulahonɨngki Jisas aꞌamu Juta somo ufoꞌmayoꞌnehwo pahnnɨmo hungkuno ulɨmento, U, nakwo mehomife wosopayo mehwasi sɨwojomo wohoꞌnɨmofantontaho. Oꞌo, awonoho. Aꞌamu sohwo mehomi somo kakiꞌno wopayo uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","I ose ulahonɨngki aꞌmusi syafɨhuꞌmento, Ngko aꞌamu Isɨlaelɨꞌmaho. Oꞌo, sɨwojo paꞌniyoho. Ose syafɨsyonto ulɨmento, Hwe Engofo, kɨko nehopi lohino. Oseso mehomiso wopayo paho yoꞌmayoso umokwajɨfijoso sɨwojo wanɨmontonoho. Osoꞌno kɨko ngkimo nɨfoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ose ulahonɨngki Jisas yomo yonto ulɨmento, Oso hungkuno wopɨngo lohino soꞌno jɨje angopo nowehoji jɨje mumo uhwonjoso towahuno wonyo sohwo nto ulɨkoꞌmaso uhwonɨmonnoho. ");
INSERT INTO apz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ose ulahonɨngki aꞌmusi kakoe angopo nowento uhwonɨmentisoso kakoe mu saho fosyowentanɨngki uhwonɨmentisoso towahuno wonyo nto ulɨkoꞌmaꞌmentisofoho. Hofiyo fosyowentanɨngki uhwonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas ango Taiya sopo ntaꞌni nulɨkoꞌmanto hwaho Saitoun uyakolofonto ango pone engo aho hufaꞌu hopiꞌnonohino Ntekapolis sopo uyakolofonto Mijo Ayo Ngkalili sopo iꞌmofapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Osopo aꞌamu nomꞌneso Jisasɨmo aꞌamu haloho pɨkuꞌnnyo melanyo tangoꞌnjo sohumo ipemotapontɨfi jomo ulɨmentohofi, Jɨje aho olo hwe lohumo fɨkisasyo. ");
INSERT INTO apz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ose ulahonɨngkofi oso hwe huhwo sohumo Jisas utɨmanto Jisasɨꞌnji weꞌenepi nowenji sikoꞌnohini nohumanji Jisas kako ajoꞌmiyoso hwe sohwoe halohomo kisahumentisofoho. Kisasyonto memijo ajoꞌmiyomo emjomaꞌnonto hwe sohwoe melanyopo kisahumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jisas kako ahwomomo uhwononto sɨmano esyaofonto ulɨmento, Efata. Hwapɨngoso ole, Haloho wokuhwosampeno. ");
INSERT INTO apz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ose ulahonɨngki hwe sohwoe haloho komoꞌno hwosampo lohofahonɨngki kakoe melanyo wopɨngo imoꞌnɨngkahonɨngki hungkuno itoꞌno lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Oseso Jisas aꞌamumo apaꞌno iꞌmofaponto ulɨmento, Olo yohe losoꞌno sekwo nulɨkutoho. Ose ko ulahonɨngki hofɨko hahnꞌnyo yontɨfi aꞌamumo ulɨwoꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yoꞌmayo Jisas imentiso soꞌno hofɨko pisopisaho mjalɨmɨwentɨfi hofɨko ulɨmentohofi, Yoꞌmayo Jisas yɨwoꞌnɨngkisoso wonyoangkafoꞌnohinofoho. Aꞌamu haloho pɨkuꞌnnyoso upoꞌnalokwofo. Aꞌamu iloꞌnnyoso hungkuno itoꞌno lalokwofo. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nomꞌne sɨkuno somo aꞌamu piꞌnɨngo engo apaꞌno Jisas nohumentanjopo uhuꞌmokumentohofofoho. Hofɨko nohumantɨfi hwe moyaꞌmi wosopayo moiꞌwo imoꞌnɨngkahonɨngki Jisas kakoe inomokomoyo sohwamneꞌno joho ulonto, ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ngko olo hwe moyaꞌmi lomneꞌno hitoho ntokwoho. Sɨkuno hufaꞌu sɨhune ngkoꞌnji humantohofofoho. Hofɨko wosopayo anefoho. ");
INSERT INTO apz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mijohoꞌnohino hofɨkoe ango poneꞌno lɨhwatɨmeso hofɨko honɨngkanopo tɨmo sɨkunoꞌno ulohofontɨfeho. Aꞌamu fiso ikanopo ntaꞌni pmmalofofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ose ulahonɨngki kakoe inonokomayo sohwa ulɨmentohofi, Olopo aꞌamu mohumunyoponoho. Wosopayo hwe moyaꞌmi somneꞌno ntɨꞌmtaꞌni tɨpemanehwono. Awonoho. ");
INSERT INTO apz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ose ulahonɨngkofi Jisas ulohonɨmento, Sekwo wopayo alale weho. Ose ulahonɨngki ulɨmentohofi, Wopayo aho hopiꞌnono nomꞌne mtaꞌni hufaꞌu weho. ");
INSERT INTO apz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ose ulahonɨngkofi Jisas hwe moyaꞌmi somo ulɨmento, Sekwo hwaho lopo fosyohumamno. Ose ulonto, kako wopayo aho fehohnjo hopiꞌnono fehohntaꞌni hufaꞌuyoso nomanto Anɨtumo isamoyoka ulonto wopayoso kutɨkujo lohofonto, kakoe inomokomoyo sohwamo uyahonɨngki hofɨko aꞌamumo huꞌmuyɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Inanɨku weꞌe tɨpemaꞌmentohofoso Jisas nomanto Anɨtumo isamoyoka ulonto inomokomoyo sohwamo ulɨmento, Oloꞌnji aꞌamumo fohuꞌmuyɨmno. ");
INSERT INTO apz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Hofɨko wopayo nonontɨfi sɨmeho uhnnɨngkahonɨngki wopayo nɨlɨfeeoꞌmentohofoso inomokomoyo sohwa sohwo hoꞌyo aho fehohnjo hopiꞌnono nomꞌne ntaꞌni hufaꞌuyo somo mehuꞌmemeehumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Aꞌamu hiso weꞌe humamentohofoꞌmaho. Aꞌamu foua tausen (4000) humamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jisas aꞌamu homo somo wopayo moiꞌwo uyonto hofɨkoe angopo neꞌno lɨhwatɨmentisofoho. Kako kakoe inomokomoyo sohwanji yofayokinopo kotasontɨfi hwaho Ntalɨmanutaꞌno wakoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Osopo aꞌamu Falisi sohwa Jisasɨmo uꞌmantɨfi kakimo yamofo ulohofoneꞌentɨfi yoka hnnomaꞌmentohofofoho. Kɨko yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso fonetɨhwaho. Ose uhwonɨngkuhwasi Anɨtu kɨkoꞌnji humaho wolano. Ose lontɨfi huno syafɨhuꞌmentohofi, Olo hwe lohwo Anɨtuye Hwe Ne hwolɨkeno. ");
INSERT INTO apz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ose ulahonɨngkofi Jisas sɨmeho tango uyahonɨngki sɨmano esyamo lohofonto, ulɨmento, Sekwo yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso pehoꞌno uhwonantɨfeꞌne lohofo. Hungkuno nehopi waselɨmo. Aꞌamu olo hwaho lopo olohonta humalofoso hofɨko oso yoꞌmayo hiso muhwonɨfitnnehofo. Nɨhuꞌno awonoho. ");
INSERT INTO apz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ose ulonto oso aꞌamu somo ulɨkoꞌmanto Jisasɨꞌnji kakoe inomokomoyo sohwaꞌnji hofɨko yofayokinopo apaꞌno kotasontɨfi asomo wakoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nowakentɨfi inomokomoyo sohwa wopayoꞌno inɨngo mofontɨfi momasofoho. Wopayo kengaꞌnohini yofayokinomo woꞌnnyofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nowekontanɨngkofi Jisas sɨmano pento pahnnɨmo hungkuno ulɨmento, Upaꞌnɨmo. Sekwo aꞌamu Falisi sohwanji Heloutɨꞌnji hofɨkoe yahino somneꞌno iꞌwaho fiyɨmno. ");
INSERT INTO apz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Inomokomoyo sohwa nupaꞌnontɨfi hnnɨmentohofi, Nakwo wopayo inɨngo mofɨhwone soꞌno hungkuno nalohoho. ");
INSERT INTO apz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ose hnnɨngkahonɨngkofi olo hiloso Jisas huno uyahonɨngki hofɨkimo ulohonɨmento, Wopayo umofonyo iyo soꞌno pehoꞌno hnnalokwofo. Sekwo hunoꞌmaseyotaho. Sekwo huno mosyafɨsiyoꞌnjo liyohofo. ");
INSERT INTO apz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Sekwo tɨmo hiꞌnjo hwasoho. Muhwonalokuliyohofo. Sekwo haloho hiꞌnjo hwasoho. Mupoꞌnalokuliyohofo. Sekwo inɨngo loseyalofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ngko wopayo aho fehohnjo hopiꞌnono kutɨkujo lohofonji aꞌamu faif tausen (5000) sohwamo umaleso oso wopayo nɨlɨfeeoꞌmalofoso sekwo hoꞌyo alale huꞌmemeehumalofo. Inomokomoyo sohwa ulɨmentohofi, Aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyoho. ");
INSERT INTO apz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ose ulahonɨngkofi Jisas ulɨmento, Nomꞌne sohonta ngko wopayo aho fehohnjo hapiꞌnono nomꞌne mtaꞌni hufaꞌu kutɨkujo lohofonji aꞌamu foua tausen (4000) sohwamo umaleso oso wosopayo nɨlɨfeeoꞌmalofoso sekwo hoꞌyo alale huꞌmemeehumalofo. Inomokomoyo sohwa ulɨmentohofi, Aho fehohnjo hopiꞌnono nomꞌne mtaꞌni hufaꞌuyoho. ");
INSERT INTO apz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ose ulahonɨngkofi Jisas ulɨmento, Oseso sekwo nje yokumpohnꞌnyo soꞌno huno maseyoholiyohoho. Wosopayo soꞌno huno piꞌnɨngo pehoꞌno syofɨsyalokwofo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jisas kakoe inomokomoyo sohwanji ango Mpetɨsaita iꞌmofopahonɨngkofi aꞌamuso hwe tɨmpiꞌnyo sohumo ipemotapontɨfi Jisasɨmo jomo ulɨmentohofi, Olo hwe lohumo kɨko aho tɨmopo fɨkisyusyo. ");
INSERT INTO apz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Oseso Jisas kako hwe tɨpiꞌnyo sohwoe aho nomanto angkuhwafopo mempo hohntaꞌni ipemotoswaponto kakoe tɨmomo memijo uyatɨꞌmofonto aho kisusyonto ulɨmento, Kɨko yoꞌmayoso nto lɨhwonɨngkino muhwonɨngkoho liyohino. ");
INSERT INTO apz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ose ulahonɨngki hwe sohwo feꞌnɨhwononto ulɨmento, Ngko aꞌamumo uhwonɨngkohono. Hofɨko iyo hopa pohotowalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ose ulahonɨngki Jisas hwe huhwo sohwoe tɨmomo aho apaꞌno kisusyahonɨngki kako tɨmo yokumpohnꞌnyo uhwononto tɨmo wopɨngo imoꞌnɨmentisoso, yoꞌmayo itoꞌno uhwonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Itoꞌno uhwonɨngkahonɨngki Jisas ulɨmento, Jɨje angopono fɨwano. Olo angkuhwafo lopono asomo nopohotoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas kakoe inomokomoyo sohwanji hwaho Ngkalili ulɨkoꞌmantɨfi hwaho Sisaliya Filipai nowentɨfi Jisas hofɨkimo ulohonɨmento, Aꞌamuso ngkineꞌno pehofo mjolɨmɨwalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ose ulahonɨngki hofɨko ulɨmentohofi, Aꞌamu fehohnjoso kikineꞌno ole lalokwofi, Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwolɨkeno. Aꞌamu nomꞌne fehohnjoso ole lalokwofi, Ilaijakulɨkeno. Nomꞌnehwa aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwolɨkeno. Kikineꞌno ose mjokilɨmɨwalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ose ulahonɨngkofi Jisas ulohonɨmento, Sekwo sohwasi ngkineꞌno pehofo ntɨwoꞌnɨngkohofɨhwasilo. Ose ulahonɨngki Pita ulɨmento, Kɨko Kɨlais kiyoho. Anɨtu nakwo aꞌamu Jutasɨꞌnɨmo nefoꞌmayoꞌne kuhwotɨmentiso hwosoho. ");
INSERT INTO apz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ose ulahonɨngki Jisas ulɨmento, Oso hiso ntohinoso aꞌamumo nulohotoho. ");
INSERT INTO apz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas kakoe inomokomoyo sohwamo lutɨhwomaꞌmento, Aꞌamufe Hwomu sohwoꞌni ngko tohino engo nomaꞌmne hwoꞌnyoho. Aꞌamu Jutafe hwe engo sohwanji aꞌamu tajo ango syohoꞌnjo sohwanji Jutafe honɨngkano hungkuno lutɨhwawoꞌnɨngkohofo sohwanji hofɨko ngkineꞌno nakwolaho ntɨkuji hohujo ikenjanɨmofɨkuji nofonjanɨhufitnnefoho. Nofonjanisyɨkuji sɨkuno hufaꞌu sɨhune memjanɨmofɨhwosoꞌno ngko apaꞌno songo wolɨkaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ose ulonto olo hungkuno yoloho neso ulɨmentisofoho. Seten kako Pitamo huno ufohotofahonɨngki Pita kako Jisasɨmo weꞌenepi ipemotawento yoka ulomaꞌmento, Jisas, oso hungkunoso wopɨngoꞌmaho. Oso hunoso nosyafɨsyohotoho. ");
INSERT INTO apz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ose ulahonɨngki Jisas ikinjamo lohofonto kakoe inomokomoyo nomꞌne sohwamo uhwononto Pitamo yoka ole ulɨmento, Pita, jɨje hungkunoso ngkilaho. Anɨtuyeꞌmaho. Oꞌo, Setenɨye hungkunofoho. Kɨko Seten sohwosi iꞌwaho ntohofo. Kɨko nje hohujo loꞌmo filohoꞌnawofo. ");
INSERT INTO apz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ose ulonto kako nomꞌne hwe moyaꞌmi soꞌnji inomokomoyo sohwanjimo joho ulonto ulɨmento, U, aꞌamu fisoku ngkimo wonnɨngkopano lɨfijoꞌmanji sekwo sekwoe semoꞌnɨwoꞌnɨngkiso soꞌnji sekwoe yofe soꞌnji monje yahinɨngkuji sekwo nje yofeꞌno poyo peꞌnyo soꞌno iyoho miyoꞌnjo ifijoso ngkimo mofone sopo tɨfi nnɨngkapmno. ");
INSERT INTO apz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aꞌamu fihwo kakoe songo humayoso yokumpohnꞌnyo womokosyohumamo lososo, Kakoe songo neꞌno humayoso wopɨwahuꞌmtonoho. Osoꞌno aꞌamu fihwo ngkoꞌnji nje hungkunoꞌntnneꞌno huno uyahonɨngkuhwosi kakoe humayoso pɨwasyososo hwangku kakoe humayoso wotɨpemaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aꞌamu fihwo kako Anɨtumneꞌno hohujo ikinjaofɨhwosi kako olo hwaho loponjo hoꞌyango hamniyoho yoꞌmayoso engo huꞌmeesyontoso sohwo kako tɨkanomo wesoꞌmanji oso hoꞌyango yoꞌmayoso pipi ufoꞌmaneto. Awonoho. ");
INSERT INTO apz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","I, kakoe songo humayoso ne aneꞌmanji kako pipi yoneꞌelo. Awonoho. ");
INSERT INTO apz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aꞌamu fihwo olo hwaho lopo aꞌamu honɨngkano wonyoꞌnjo humaso sohwo kako nje hungkuno soꞌnji ngkoꞌntnneꞌno hohujo ikinjanɨmofoso sohwo ngko oso huhwo sohumneꞌno tɨfi noꞌmo hohujo ikinjɨmoꞌmnefoho. Ou, osohonta ngko nje Mpohwoe yokumpohnꞌnyo soꞌnji aꞌamu ahwomomjo wopɨngoꞌnohino sohwafe yokumpohnꞌnyoꞌnji olo hwaho lopo asomo pmme sohonta aꞌamu ngkineꞌno hohujo ikinjanɨmofoso sohuneꞌno ngko hohujo ukinjɨmoꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisas kako oso aꞌamu somo ulɨmento, Ngko hungkuno nehopi waselɨmonneꞌno yohono. Aꞌamu olo hwaho lopo nakwoꞌnji olohonta humalofo fehohnjoso mapeꞌnontanɨngkuji Anɨtu kakoe yokumpohnꞌnyoꞌnji aꞌamumo wopɨngo wonyoangkafo mokosyohumayo somo uhwonantɨfeho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sɨkuno aho fehohnjo hopiꞌnono fehohntaꞌni angaꞌno memjaofahonɨngki Jisas kako Pitaꞌnji Jemɨsɨꞌnji Jounja oso hwamo nutɨmanto hofɨko hwofɨkiꞌnyo sawemo engo sopono nokotasontɨfi hofɨkoꞌnohini nohumentanɨngkofi Jisasɨye aꞌapaho nomꞌne kengo imoꞌnɨngkahonɨngki hofɨko uhwonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jisasɨye manjiꞌmofo nɨhuꞌno halojo imoꞌnonto mofehiꞌnyo paꞌnyo imoꞌnɨmentisofoho. Oso manjiꞌmofo halojoso aꞌamu olo hwaho lopo oso halojo paꞌnyoso mamtɨꞌmokufitnnehofo. ");
INSERT INTO apz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Inomokomoyo sohwa uhwonɨmentohofoso Ilaijaꞌnji Mousesɨꞌnji ahwomo mtaꞌango sohwaꞌu Jisasɨmo uꞌmanji hungkuno hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita kako huno piꞌnɨngo syofɨsikaofonto Jisasɨmo ulɨmento, Nakwoe Lonetɨhwayohwosi, nakwo olopo humentani sehonɨngkuhwoneso wopɨngofoho. Olo hilo soꞌno syafɨsiyoꞌneso ango hufaꞌu sɨhune womolantaneꞌno yɨhwono. Angaꞌno kɨkoꞌnefoho. Angaꞌno Mousesɨmnefoho. Nomꞌneso Ilaijamnefoho. ");
INSERT INTO apz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita kako oso hisoꞌno huno itoꞌno muyahonɨngki ose ulɨmentisofoho. Inomokomoyo sohwa iyoho weꞌe unɨmentisoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Osohonta himo hofɨkimo ifeehuꞌmokosyahonɨngki mampaho himo mtaꞌango ole hoꞌnɨmento, Olohwo nje Hwomufoho. Ngko sɨmeho uyɨwoꞌnɨngkohe hweho. Kakoe hungkunomo sekwo upaꞌnɨmno. ");
INSERT INTO apz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ose upaꞌnontɨfi feꞌnɨhwonɨmentohofoso hwe ahwomo mtaꞌango sohwaꞌu neꞌno anepo uhwonɨmentohofofoho. Jisasɨꞌnohini humentanɨngki uhwonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jisasɨꞌnji inomokomoyo sohwanji hwofɨkiꞌnyo hopo sopo nokotapontɨfi Jisas ulɨmento, Olo sekwo uhwonɨngkohofo losoꞌno olohonta aꞌamumo nulɨkutoho. I, hwangku ngko Aꞌamufe Hwomu sohwoꞌni poyo imoꞌnɨꞌmeꞌno Anɨtu apaꞌno ntokafoso sohonta sekwo aꞌamumo olo uhwonɨngkohofo losoꞌno ulɨfijo. ");
INSERT INTO apz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ose ulahonɨngki hofɨko aꞌamu nomꞌne somo ulɨmentohofoꞌmaho. I, osoꞌno ole hnnɨmentohofi, Kako poyo peꞌnɨngkuhwosi apaꞌno songo lɨkafoꞌne hungkuno hwapɨngoso pipilo. ");
INSERT INTO apz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwa ole lɨwoꞌnɨngkohofi, Ilaija kakiꞌno wapmmontonoho. Tɨfi sohonta Kɨlais hwe Anɨtu uhwosopoꞌmentiso sohwo wapmmontonoho. Oso hiso pehoꞌno lalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ose ulahonɨngkofi Jisas ulɨmento, Ou, hungkuno nehopi lalokwofo. Ilaija kako sɨmoꞌmo nopɨhwosi yoꞌmayo hopiꞌnono itoꞌno wesyohumamtonoho. Hungkuno nomꞌne mtɨꞌmokumentohofoso ole, Hwe Anɨtu uhwosopoꞌmentiso sohwo olo hwaho lopo tohino engo tɨpemanefoho. Aꞌamu sohwa oso hwe sohumo nakwolaho ulɨfitnnefoho. Osoꞌno sekwo huno fɨsyafɨhupmno. Ole selalokweno Hwe Ilaija kako pmmentisofoho. Nopahonɨngki aꞌamu hofɨkoe huno hwahoponjo tɨpemantɨfi hwe huhwo sohumo wonyo umokumentohofofoho. Aꞌamu Anɨtuye hungkuno mtɨꞌmokumentohofoso oso hisoꞌno hohonta mtɨꞌmokumentohofoso olohonta ne imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hofɨko nomꞌne inomokomoyo sohwamo uꞌmantɨfi uhwonɨmentohofoso aꞌamu piꞌnɨngo engo nohumentanɨngkofi aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji inomokomoyo sohwanji yoka hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aꞌamu piꞌnɨngo engoso Jisas nopontanɨngki uhwonontɨfi yomo yontɨfi hano komoꞌno wentɨfi Jisasɨmo uꞌmantɨfi, Nakwoe hwe engo hwosoho ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisas inomokomoyo sohwamo ulɨmento, Sekwo yoka pehoꞌno hnnalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ose ulahonɨngki hwe fihwo aꞌamuꞌnji ajwo soꞌmo humohumatiso sohwo ulɨmento, Nje Lontɨhwayo sohwosi, towahuno wonyo nje hwomumo mango mampiꞌnyo mesimokinyo. Osoꞌno kikiyepono ipemotapohono. ");
INSERT INTO apz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Towahuno wonyo sohwo nje hwomumo humanto wonyo kimokuwoꞌnɨngkisofoho. Kako hwomumo hwahopo kumokwojahonɨngki hwomu sohwo makutotafo sapɨwoꞌnɨngkisofoho. Saponto mango kilompusyɨwoꞌnɨngkisofoho. Kako aꞌapaho melohofafɨwoꞌnɨngkiso hweho. Oseso ngko jɨje inomokomoyo sohwamo ulohonɨngko, Towahuno wonyo lohumo wae feeopmno. I hofɨko hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisas ose nupaꞌnonto inomokomoyo sohwamo ulɨmento, Hwe moyaꞌmi olohonta humalofo soku, sekwo Anɨtumo sɨmeho hiꞌntnnono muyo kuyoho. Ngko sekwoꞌnji humayoso sɨkuno alale womemjanɨmoꞌmontolɨkeno. Ngko sekwoe tango ngkimo nɨꞌmaneso sɨkunoso alale womemjanɨmoꞌmontolɨkeno. Hwomu huhwo sohwo ngkiye poneꞌno utɨmotapmno. ");
INSERT INTO apz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ose ulahonɨngki hofɨko hwomu ipemotopahonɨngkofi towahuno wonyo sohwo Jisasɨmo uhwononto kako hwomumo yomo yomo yokumpohnꞌnyo umokahonɨngki hwomu hwahopo pɨwasyonto, yɨwoloꞌmo yɨwoloꞌmɨngo lohofonto makutotafo halojoꞌnohino swapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisas kanɨngkwohumo ulohonɨmento, Sɨkuno alale yɨwoꞌnɨngkisoto. Ose ulahonɨngki ulɨmento hwomu weꞌe sohwo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Fehonta tohomo kehwofitofasyonto fehonta mijomo kehwofitofasyonto wofonjahumonto iwoꞌnɨngkisofoho. Kɨko hopoꞌmanji kɨko nakumo hitoho kilofɨhwosoꞌno, Fonefoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ose ulahonɨngki Jisas ulɨmento, Ou, nehopi, jɨje sɨmeho hiꞌntnnonohinoso hopoꞌmanji yoꞌmayoso kɨko womaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ose ulahonɨngki kanɨngkwohwo komoꞌno ulɨmento, Sɨmeho hiꞌntnnono kijopalokweno. Oseso nje sɨmeho hiꞌntnnonohinoso weꞌefoho. Nɨfoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ose ulahonɨngki Jisas aꞌamu piꞌnɨngo engo uhuꞌmokontanɨngkofi uhwononto, towahuno wonyo sohumo yoka ulonto ulɨmento, Towahuno wonyo sohwosi hwomu lohumo mampiꞌnyo imokuwoꞌnɨngkino hwosoho. Olo hwomu lohumo nɨhuꞌnahone ulɨkoꞌmaho. Apaꞌno nopaswohotoho. ");
INSERT INTO apz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ose ulahonɨngki towahuno huhwo sohwo joho mohmꞌno lonto, hwomumo hwahopo kumokwajonto yomo yomo yokumpohnꞌnyo imokonto nɨhuꞌnahone ulɨkoꞌmaꞌmentisoso hwomu sohwo poyo paꞌnyo imoꞌnɨngkahonɨngki aꞌamu fiso ulɨmentohofi, Poyo peꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Oseso Jisas hwomu sohwoe aho nomanto ulɨkofahonɨngki hwomu sohwo lɨkaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jisas kakoe inomokomoyo sohwanji angomo noswontɨfi hofɨkoꞌnohini nohumantɨfi Jisasɨmo ulɨmentohofi, Pipilo. Nakwo towahuno wonyo wae meeofesofo. ");
INSERT INTO apz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo Anɨtumo jomo ulɨfijoso sekwo oso towahuno huhwo sohwo wae yaopitnnehofo. Nomꞌne honɨngkano awonoho. ");
INSERT INTO apz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Oso ango hopo sopo ulɨkoꞌmantɨfi hofɨko hwaho Ngkalili ajwo sopo umentohofofoho. Jisas kako aꞌamu yofe manɨhwo soꞌnjo uyɨfe lonto imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Hwapɨngoso ole, kakoe inomokomoyo sohwamo lutɨhwamneꞌento imentisofoho. Kako ulɨmento, Ngko Aꞌamufe Hwomu sohwoꞌnɨmo nje mango sohwafe aho somo hoꞌnonɨsyahonɨngkuji hofɨko wofonjonɨsyantɨfeho. Poyo imoꞌnɨmo sɨkuno hufaꞌu sɨhune memjanɨfɨhwosoꞌno Anɨtu apaꞌno ntokafonefoho. ");
INSERT INTO apz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ose lutɨhwahonɨngki inomokomoyo sohwa hofɨko huno itoꞌno syafɨhuꞌmentohofoꞌmaho. I osoꞌno Jisasɨmo ulohonyo soꞌno hofɨko iyoho imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hofɨko pone Koponeyam iꞌmofapontɨfi osopo Jisas angomo nohumanto ulohonɨmento, Sekwo honɨngkanopo pehofo hnnɨngkohofo. ");
INSERT INTO apz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Inomokomoyo sohwa hofɨko wonɨmango unɨngkahonɨngki mampiꞌnyo humamentohofofoho. Hwapɨngoso honɨngkanopo ole hnnɨmentohofi, Nakwo sohwonaꞌni nakwoe hwe yofeꞌnjo sɨmoꞌmjo tɨhwolo. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisas ampo humanto inomokomoyo sohwamo joho lutɨmanto ulɨmento, Sekwo hinjo hwasoho oyonɨmno. Upaꞌnɨmo. Hwe fihwo kako Anɨtuye tɨmopo hwe engo umoꞌnɨmo loso sohwo kako aꞌamufe tɨmopo hwe yofe ane paꞌnyo imoꞌnoso sohwo aꞌamumneꞌno momayo ulohofiyo hweho. Osohwo kako yofe engoꞌnjo imoꞌnone hweho. ");
INSERT INTO apz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ose ulonto, mehomi fihwo utɨmanto, kakoe popapo momokosyohumanto inomokomoyo sohwamo ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Aꞌamu fihwo kako olo mehomi lopaꞌnyo sohumo nje yofe hoꞌnonɨmayoꞌne ufoꞌmaso sohwo kako ngkimo nɨfoꞌmantofoho. Aꞌamu fihwo ngkimo nɨfoꞌmayo oso paꞌnɨngoso nje mpohwo ngkimo nɨhwatɨmentiso sohwo huhumo ufoꞌmakwoho. ");
INSERT INTO apz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ose ulahonɨngki Joun ulɨmento, Nakwoe Lonetɨhwayo sohwosi, nakwo uhwonɨmalohwoneso hwe fihwo kako jɨje yofe lonto, towahuno wonyo wae yaofontanɨngki uhwonɨmalohwonefoho. I osoꞌno kako nakwo kikimo tɨfi mokinɨngkowaloku yɨhwone soꞌno nakwo kakimo ulɨmalohwono, Kɨko Jisasɨye yofeꞌnji towahuno wonyo wae yaofohotoho. ");
INSERT INTO apz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo ose ulohoꞌmalofoso wonyofoho. Sekwo kakoe honɨngkanomo nopɨjumofɨkutoho. Aꞌamu nje yofe lososo yoꞌmayo wonyoangkafo yososo kako ngkimo sitofo komoꞌno mantonehoho. ");
INSERT INTO apz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aꞌamu nakwoe syoho somo mohwempenamofehwoꞌmanji nakwoe aꞌamu hweho. ");
INSERT INTO apz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Hungkuno nehopi selalokweno, Hwe fihwo sehonasoso huno ole wosyafɨhuꞌmontono, Anɨtuye aꞌamu hwafoho. Ose syafɨsyɨhwosi mijo nyoꞌne sejapososo, oso hwe sohumo Anɨtu wopɨngo ulohoꞌmtonoho. ");
INSERT INTO apz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Olo mehomi sɨmeho hiꞌntnnono ntapɨwoꞌnyo sohumo aꞌamu huno wonyoꞌnjo fihwo ulososo, Jisasɨmo hohujo fɨkinjaofo. Honɨngkano wonyo lomo tɨfi finɨngkayo. Ose uloso sohwo mehomi huhwo sohwo honɨngkano wonyomo inɨngkayo soꞌno oso hwe huno wonyoꞌnjo huhwo sohumo Anɨtu tohino mɨkunɨmposo uyonefoho. Oso aꞌamu huhwo sohumo sojo mɨkunɨmposo engo soꞌnji kakoe tɨꞌwangomo impe ifakojujɨkuji mijomo hoꞌnaofontɨfijontentesi wopɨngoꞌnesohilo. ");
INSERT INTO apz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jisas ose ulonto pahnnɨmo hungkuno ulɨmento, Osoꞌno jɨje aho honɨngkano wonyo imofonoho lohoji ahoso hwempeemo lohofohoji aho angaꞌnohonoꞌnji honɨngkano wopɨngomo inɨngkahuji Anɨtuye angopo sohoji wopɨngo wohumamonnoho. Ou kɨko aho hufaꞌuꞌnjo honɨngkano wonyo imojoso toho neꞌno sijalokunjo somo uhnnefoho. Wonyo wohumamonnoho. ");
INSERT INTO apz_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Oso hopo sopo pihnnyo mapeꞌnyofoho. Tohino neꞌno woꞌnnyoponoho. Toho hiso masɨmpeꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jɨje sɨfe honɨngkano wonyo imofonoho lohoji sɨfeso hwempeemo lohofohoji sɨfe angaꞌnohinoꞌnji honɨngkano wopɨngomo inɨngkahuji Anɨtuye angopo sohoji wopɨngo wohumamonnoho. Ou kɨko sɨfe hufaꞌuꞌnjo honɨngkano wonyo imojoso toho neꞌno sijalokusomo uhnnefoho. Oso wonyofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Oso hopo sopo pihnnyo mapeꞌnyofoho. Tohino neꞌno woꞌnnyoponoho. Toho hiso masɨmpeꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jɨje tɨmo honɨngkano wonyo imofonoho lohoji tɨhwotofamo lohofohoji tɨmo angaꞌnohinoꞌnjo honɨngkano wopɨngomo inɨngkahuji Anɨtuye angopo sisoso wopɨngofoho. Ou kɨko tɨmo hufaꞌuꞌnjo honɨngkano wonyo imojoso toho neꞌno sijalokunjo somo uhnnefoho. Oso wonyofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Oso hopo sopo pihnnyo mapeꞌnyofoho. Tohino neꞌno woꞌnnyoponoho. Toho hiso masɨmpeꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Aꞌamu wopayopo sa mofɨkuji nɨfijoso me-eso wopɨngo uyɨmtonoho. Oso paꞌnyo tohino yoꞌmayo tango neꞌmahwosoꞌno yamofo nalohofonefoho. Yamofo hiso wopɨngo namokonefoho. ");
INSERT INTO apz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nakwo wosopayo saꞌnji nɨwoꞌnɨngkuhwoneso wopɨngofoho. I osoꞌno sa fosyo mijoꞌnohino imoꞌnɨngkuhwosi kakoe yokumpohnꞌnyo nonto wonyo imoꞌnososo apaꞌno sa hiso wopɨngo imoꞌnyoso pipi uyantanto. Awonoho. I osoꞌno sa wopɨngo paꞌnyo hmmoꞌnɨmno. Sekwo aꞌamu nomꞌne soꞌnji pompenjiyomo fohumantokuno. ");
INSERT INTO apz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Osopo ntaꞌni Jisas nowento hwaho Jutiya uyakolofonto Mijo Joutan sohumo nongkihntaꞌni wakoꞌmentisofoho. Osopo aꞌamu piꞌnɨngo engo apaꞌno uꞌmahonɨngkofi kako hungkuno lutɨhwamojo paꞌnyo lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aꞌamu Falisi fihwa hofɨko Jisasɨmo nuꞌmantɨfi kakimo yamofo ulohofono lontɨfi ulɨmentohofi, Nakwoe honɨngkano hungkunoso ape hoꞌnasiyo soꞌno pehofo nalɨmotofo. Hwe fihwo kako kakoe ape hoꞌnasiyoso oso wopɨngotaho. ");
INSERT INTO apz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ose ulohonɨngkofi Jisas ulɨmento, Mouses seyakwosamo olo soꞌno pehofo ulɨmojoto. ");
INSERT INTO apz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ose ulahonɨngki hofɨko ulɨmentohofi, Mouses ole ulɨmento, Hwe kako nje ape wohoꞌnahumo lososo sohwo kako oso hungkuno hiso ifalifaliyo wamtɨꞌmokono. Oseso kako kakoe apemo nɨhuꞌnahone wohoꞌnasyono. ");
INSERT INTO apz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ose ulahonɨngkofi Jisas ulɨmento, Mouses kako sekwoe yokumpohnꞌnyo soꞌno oso hungkuno hiso mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","I osoꞌno sɨmoꞌmo neꞌmo Anɨtu yoꞌmayo hopiꞌnono mtɨꞌmokumentiso sohonta hweꞌnji apeꞌnji mtɨꞌmokumentisofoho. Oso hungkuno hiso Mouses mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Olo hilo soꞌno hwe fihwo kanɨngkwohwo konaꞌwohimo ulɨkoꞌmahwosi kakoe apeꞌnji nemꞌno makotoku wolohoꞌnanjiyoho. ");
INSERT INTO apz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Sikoꞌyaꞌu angaꞌnohino umoꞌnanjiyoho. Oseso siko aꞌamu hufaꞌu umoꞌnanjiꞌmaho. Oꞌo, sikoe aꞌapahoso angaꞌnohino umoꞌnanjiyoho. ");
INSERT INTO apz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Osoꞌno Anɨtu osiyaꞌumo nto mokotɨjwohumasofoho. U, oloso nomtɨhuposoꞌeno. ");
INSERT INTO apz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Oso hungkunoso ulahonɨngki Jisas kakoe inomokomoyo sohwanji angomo noswontɨfi hofɨko Jisasɨmo ape hoꞌnasiyo hungkuno hisoꞌno ulohonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jisas ulɨmento, Hwe fihwo kako kakoe ape hoꞌnasyoso sohwo kako nomꞌne ape masoso oso hwe huhwo sohwo ape hufo iyo honɨngkano imokwoho. Olo hwe huhwo sohwo kakoe ape sɨmoꞌmjo simo honɨngkano wonyo imokiyofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Oseso ape kakoe hwehumo nulɨkoꞌmahwosi nomꞌnehumo umaꞌnyoso kako honɨngkano wonyo imokonefoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Aꞌamu piꞌnɨngoso hofɨkoe mehomi Jisas mnokinopo aho ulonjimokonontɨfi motopahonɨngkofi Jisasɨye inomokomoyo sohwa hofɨkimo yoka ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisas nupaꞌnonto kakoe sɨmeho tohino umnɨngkahonɨngki ulɨmento, Sekwo mehomi somo nopɨjumofɨkutoho. Oꞌo, hofɨko ngkiyepono wapɨfe. Aꞌamu olo mehomi lohwa paꞌnyo imoꞌnɨfijoꞌmanji hofɨko Anɨtumo enjwaꞌmo itoꞌno wohumantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","I, hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Aꞌamu olo mehomi lohwa paꞌnyo mmoꞌnyonjoꞌmanji hofɨko Anɨtumo enjwaꞌmo humayoso hopaꞌmaho. Nɨhuꞌno awonoho. ");
INSERT INTO apz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ose ulonto kako mehomi somo huꞌmema lohofonto kakoe huyoꞌmo memokosyohumanto kako aho mnokinopo kisasyonto Anɨtumo jomo ulɨmentisofoho. Mehomi itoꞌno mokosyohumayoꞌneꞌento ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas honɨngkanomo nowentanɨngki hwe nomꞌnehwo Jisas nohumentanjopo komoꞌno iꞌmofawento hwomtame ulohoꞌmentisofoho. Kako Jisasɨmo yokumpohnꞌnyo ulɨmento, Kɨko Anɨtuye yahino wopɨngo netɨhwawoꞌnɨngkohino hwosoho. Ngko engolopohamo songo neꞌno humayoso pipi tɨpemaꞌmnehono. ");
INSERT INTO apz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ose ulahonɨngki Jisas ulɨmento, Kɨko wopɨngo hwosoho eso pehoꞌne ntohino Anɨtu kakoꞌnohino wopɨngo hweho. ");
INSERT INTO apz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kɨko honɨngkano hungkuno huno moiꞌwonoho. Kɨko nomꞌnihumo nofonjasiyoꞌeno. Kɨko ape itoꞌno mayoꞌne yahino somo nomtɨhuposoꞌeno. Kɨko yoꞌmayoso hufo iyoꞌeno. Nomꞌnehumo hwasyo hungkuno ujoꞌeno. Kɨko jɨje mpohwoꞌnji naꞌuꞌnjiye hungkunomo tɨfi finɨngkayo. ");
INSERT INTO apz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ose ulahonɨngki hwe huhwo sohwo Jisasɨmo ulɨmento, Hwe Engofo, ngko hungkuno homo somo upaꞌnɨmopmmote sohwoꞌni olohonta neꞌno oseꞌnohini inɨngkowalokweno. ");
INSERT INTO apz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ose ulahonɨngki Jisas kakoe sɨmoꞌmangopo tɨmo uhwononto sɨmeho uyonto ulɨmento, Nomꞌne syoho angaꞌno fiyo. Jɨje hoꞌyango yoꞌmayo hopiꞌnonohinoso aꞌamu mpe wakilohopɨfe. U, kɨko hamniyoho matnneꞌeno oso hiso nomahoji aꞌamu yoꞌmayoso umofonyo iwoꞌnɨngkohofo somo uyo. ");
INSERT INTO apz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ose ulahonɨngki kako sɨmano pento sɨmeho tango uyahonɨngki kakoe angopono umentisofoho. Hwapɨngoso kakoe hoꞌyango yoꞌmayoso piꞌnɨngoꞌnjo hweho. Aꞌamu somo muyɨmnehono lonto umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisas tɨmo feꞌnɨhwononto inomokomoyo sohwamo ulɨmento, Hwe kako hoꞌyango engoꞌnjo yokumpohnꞌnyo mokosyohumaso sohwo kako Anɨtuye yokumpohnꞌnyo mokosyohumayo sopo pipi swonehwolo. Hamniyoho hoꞌyangoso hofɨkoe hunomo wonyo umokuwoꞌnɨngkisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ose ulahonɨngki inomokomoyo sohwa hofɨko yomo imentohofofoho. Jisas apaꞌno ulɨmento, Hwomo lohwafo hwe kakoe hoꞌyango hwaho loponjoꞌno neꞌnohini syafɨsyɨwoꞌnɨngkiso sohwo kako Anɨtuye yokumpohnꞌnyo mokosyohumayo sopo pipi swoneto. ");
INSERT INTO apz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yahu fihwo kako yongo imo paꞌnyo soꞌmo wahumo lɨhwasi yososo wonyopi umontonoho. Oso paꞌnyo hwe hoꞌyango hamniyoho yoꞌmayoso aho yokumpohnꞌnyo kemokosyohumunyo sohwo Anɨtumo enjwaꞌmo wohumamo lɨhwosi yososo hopoꞌmaho. Oꞌo, kako yahu yongo imo paꞌnyo soꞌmo wahumo lɨhwasi ijijo wonyopi yoso hopaso oso hwe hoꞌyango engoꞌnjo sohwo ose yonefoho. ");
INSERT INTO apz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ose ulahonɨngki inomokomoyo sohwa hofɨko yomo engo mɨkunɨmposo yontɨfi ulɨmentohofi, Oseꞌmanji aꞌamu Anɨtuꞌnji ango wopɨngo sopo songo neꞌno humayoꞌneso tɨhwo womaꞌmontolo. ");
INSERT INTO apz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ose ulahonɨngkofi Jisas hofɨkimo uhwononto ulɨmento, Aꞌamu Anɨtuye yokumpohnꞌnyo mokosyohumayo sopo aꞌamufe yokumpohnꞌnyoꞌnji wahumo loso sohwo kako hopoꞌmaho. I osoꞌno Anɨtu yoꞌmayo hopiꞌnono hwapɨngo sohwo iyoso hoponoho. ");
INSERT INTO apz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita Jisasɨmo ulɨmento, Ihwoni nakwo yoꞌmayo hopiꞌnono hoꞌnasyontani kikimo tɨfi kinɨngkopalokuhwono. ");
INSERT INTO apz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ose ulahonɨngki Jisas ulɨmento, Ngko hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Aꞌamu fihwo kako kakoe angoꞌnjo konɨngkwaꞌwehwo kolaꞌwehwo, kaisi, konaꞌwohi, mehomi kakoe hwahoꞌnji yoꞌmayo hopiꞌnono ngkineꞌno nje hungkunomneꞌno hoꞌnasyososo ");
INSERT INTO apz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","osohwo kako umofonyo miyonehoho. Oꞌo, yoꞌmayo piꞌnɨngo engo nomane hweho. Yoꞌmayo hoꞌnasiyoꞌne aꞌamu kakimo sitofo ulɨwoꞌnɨfitnnefoho. I osoꞌno kako ango songo neꞌnohini humayoꞌneso nomane hweho. ");
INSERT INTO apz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hwe fihwo kako olo hwaho lopo nohumanto hwe engo hwoꞌnyoho syofɨsyalokusoso oso hwe huhwo sohwo Anɨtuye ponemo soso sohwo kako hwe engoꞌmaho. Weꞌe hweho. Hwe nomꞌnihwo kako olo hwaho lopo nohumanto hwe engo hwoꞌnɨꞌmaho. Weꞌe hwoꞌnyoho syofɨsyalokuso sohwo oso hwe huhwo sohwo kako Anɨtuye ponemo soso sohwo kako hwe engo imoꞌnone hweho. ");
INSERT INTO apz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jelusalem honɨngkanomo nosontɨfi Jisas kako sɨmoꞌmo kuntoꞌno sahonɨngki kakoe inomokomoyo sohwo poyo imoꞌnyo soꞌno ulɨmentiso soꞌno huno piꞌnɨngo engo syafɨsyontɨfi tɨfi inɨngkasɨmentohofofoho. Aꞌamu nomꞌneso hofɨkimo inɨngkasɨmentohofo hiꞌnji imentohofofoho. Jisas kakoe inomokomoyo sohwamneꞌento hontohumentanɨngki hofɨko nuꞌmahonɨngkofi kakimo yoꞌmayo uꞌmane soꞌno hungkuno ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Hungkuno ole, Upaꞌnɨmno. Olohonta nakwo Jelusalemneꞌno wosontaneꞌno yɨhwono. Osopo Aꞌamufe Hwomu sohumo aꞌamu yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji hofɨkoe ahomo hofɨko hoꞌnasyɨkuji kakineꞌno hungkuno lɨkuji kako poyo umoꞌnono lɨkuji nano wamtitofantɨfeho. Oseso aꞌamu hofɨko nomꞌne aꞌamu sohwamo uyahonɨngkuji ");
INSERT INTO apz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","hofɨko kakimo sitofo ulɨkuji memijo nɨyatɨꞌmofɨkuji impe yongoꞌnjo fonjɨkuji wofonjosyantɨfeho. I osoꞌno sɨkuno hufaꞌu sɨhune mjaofɨhwosoꞌno kako apaꞌno songo wolɨkaꞌmontonoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepetiye hwomu sohwaꞌu Jemɨsɨꞌnji Jounꞌnji siko Jisasɨmo uꞌmanji ulɨmentisiyo, Nekwo kikimo jomo wokilohonontayoꞌne yɨhwayo. Kɨko welohoꞌmtaho. ");
INSERT INTO apz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ose ulahonɨngki Jisas ulɨmento, Ngko pipi selohoꞌmneꞌno njisiyo. Nohonjinyo. ");
INSERT INTO apz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ose ulahonɨngki siko ulɨmentisiyo, Hwangku sohonta jɨje pone mtaꞌni aꞌamu hopiꞌnono mokosyohumuso sohonta nekwo kɨkoꞌnji hwe engo imoꞌnɨngkuhwosi aꞌamu hopiꞌnohinomo mokosyohumasoso wopɨngotaho. ");
INSERT INTO apz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ose ulahonɨngki Jisas ulɨmento, Oso hungkuno ntɨsiye neso siko huno moseyohoyohoho. Tohino ngkimo nɨmnoso hopaso masɨsoso siko hopolaho. Nje aꞌapahomo tohino ifeehuꞌmo yanisyoso hopaso sikoe aꞌapahomo ifeehuꞌmo yasesyososo siko hopolaho. ");
INSERT INTO apz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ose ulahonɨngki siko ulɨmentisiyo, Ou, nekwo hoponoho. Ose ulahonɨngki Jisas ulɨmento, Tohino ngko maꞌme paꞌnɨngoso siko nomasihnnefoho. Tohino ngkimo ifeehuꞌmokonisyoso paꞌnyoso sikoe aꞌapahomo ifehuꞌmokasyosonefoho. ");
INSERT INTO apz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","I oso hisoꞌno ngko aꞌamumo mokosyohumayo soꞌno nje aho angahohntaꞌni nje aho hwonamonyo hohntani fosyohumayo soꞌno aꞌamu nomꞌne somo muhwosopoꞌmnehono. Oꞌo, Anɨtu kakoꞌnohino oso itoꞌno esyohumaho. Kakoe hunofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ose ulɨmentisoso inomokomoyo nomꞌne sohwa oso hungkuno hiso upaꞌnontɨfi hofɨko Jemɨsɨꞌnji Jounꞌnjineꞌno sɨmeho tohino umnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jisas hofɨkimo joho ulɨmento, Sekwo huno seyohoho. Hwe engo hofɨko aꞌamumo mokosyohumayo sohwa hofɨko hofɨkoe aꞌamu enjwaꞌmjo somo syoho tangoꞌnji uyontɨfeso aꞌamu enjwaꞌmjoso syoho hiso itoꞌno miyoꞌnjo ifijoꞌmanji hwe mokosyohumayo sohwa ikujoho woposantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","I osoꞌno sekwo oso hopa ikutoho. Sekwoe aꞌamu fihwo yofe engo womaꞌmo loso sohwo kako aꞌamufe syoho ulohofiyo umoꞌnono. ");
INSERT INTO apz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Sekwoe aꞌamu fihwo ngko nomꞌne somo womokosyohumamo loso sohwo kako nomꞌne hopiꞌnonohino somneꞌno siki syoho ulohofiyo paꞌnyo umoꞌnono. ");
INSERT INTO apz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Oseso Aꞌamufe Hwomu sohwo kako aꞌamu nomꞌneso kakimo syoho ufoꞌmayoꞌne pmmentiso hwoꞌmaho. Oꞌo, hofɨkoe syoho somo ulohofiyoꞌne pmmentiso hweho. Kako aꞌamu sɨkwoꞌmjohohosi humentanɨngkofo somo uhwononto asomo utɨmayoꞌne kakoe honɨyo usɨhumaꞌmneꞌento pmmentiso hweho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hofɨko Jelikou iꞌmofapontɨfi Jisas kakoe inomokomoyo sohwanji aꞌamu nomꞌne piꞌnɨngo engo soꞌnji Jelikou ulɨkoꞌmantɨfi wentanɨngkofi hwe tɨmpiꞌnyo sohwo honɨngkanopo humohumantisofoho. Oso hwe huhwo sohwoe yofe Mpatimeyosɨyoho, Timeyosɨye hwomufoho. Mpatimeyos kako wosopayoꞌnji hamniyohoꞌntnneꞌno jomo lɨmojo hweho. ");
INSERT INTO apz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mpatimeyos nohumanto Jisas ango Nasaletnntaꞌango sohwo palofoho upaꞌnonto joho ulɨmento, Jisas, Ntefitɨye Imu sohwosi, kɨko ngkineꞌno hitoho wakilofono. ");
INSERT INTO apz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ose ulahonɨngki aꞌamu nomꞌneso yoka ulɨmentohofi, Mampiꞌnyo fosyohumaho. Ose ko ulahonɨngkofi oso huhwo sohwo joho engo lonto apaꞌno ulɨmento, Ntefitɨye Imu sohwosi ngkineꞌno hitoho wakilofono. ");
INSERT INTO apz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ose ulahonɨngki Jisas kako nolohofaponto ulɨmento, Oso hwe huhwo sohumo joho filutɨmapmno. Wapono. Ose ulahonɨngki hwe huhwo sohumo ulɨmentohofi, Kɨko sɨmonyo fiyo. Filɨkaho. Kikineꞌno joho kilalofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ose ulahonɨngkofi kako upaꞌnonto kakoe manjiꞌmofo yojamo lohofonto, nolɨkafonto Jisasɨmo uꞌmaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisas ulɨmento, Ngko kikimo pipi wantohofono kinɨngkohoho. Ose ulahonɨngki hwe tɨmpiꞌnyo sohwo ulɨmento. Hwe Engofo, ngko apaꞌno tɨmo wahonɨmo. ");
INSERT INTO apz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ose ulahonɨngki Jisas ulɨmento, Kɨko mpano. Jɨje sɨmeho hiꞌntnnonohinoso wopɨngo wakumoꞌnono. Jisas ose ulahonɨngki hwe huhwo sohwo tɨmo komoꞌno hononto kako honɨngkanopo Jisasɨmo aꞌamu soꞌnji tɨfi inɨngkapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hofɨko Jelusalem mofone sopo iꞌmofapontɨfi ango Mpetɨfaseꞌnji Mpetaniꞌnji nuhwontawentɨfi osopo hwofɨkiꞌnyo weꞌe yofe Oulif uꞌmofawentɨfi Jisas inomokomoyo hufaꞌu sohwaꞌumo lɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jisas oso huhwo sohwaꞌumo ulɨmento, Siko oso ango ne sopo uꞌmofahusɨsi siko oso kuso somo noswohosɨsi tɨmo uhwonisoso ahwomo yahu toungki yokaꞌno hoꞌnawoꞌnyoso impe intoꞌnowentanɨngkuhwosi uhwonanjiyoho. Oso yahu songo imoꞌnɨmasoso aꞌamu mokehumunyofoho. Oso yahu hiso fisɨhutofomotapinyo. ");
INSERT INTO apz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Siko oso yahu hiso isɨhutofomotapohosisoꞌno aꞌamuso ole selɨkujoꞌno, Siko peho yalokusiyo. Ose selɨkujoꞌno siko ole ulinyo, Nakwoe Hwe Engo sohwo kako olo yahu losoꞌno syoho weho. Kako moiꞌwo emoyɨhwosoꞌno komoꞌno womotopontayoho. Ose ulinyo. ");
INSERT INTO apz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Siko nowenji yahu mu honɨngkano hokuꞌyopo impe intofahinyoso nohumentanɨngki nuhwonɨmaꞌnonji italofomaꞌmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Italofomaꞌmentisiyoso aꞌamu nomꞌne sohwa ulɨmentohofi, Siko peho yalokusiyo. Yahu pehoꞌno isɨhutofomalokusiyo ");
INSERT INTO apz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ose ulahonɨngkofi hwe sohwaꞌu Jisasɨye hungkuno ulahonɨngki ulɨmentohofi, Wopɨngofoho. Noho motahnnyo. ");
INSERT INTO apz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nomotasonji sikoe manjiꞌmofoso yahupo kisosyahonɨngki Jisas sokehumamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aꞌamu piꞌnɨngo engoso hofɨkoe hwapɨfe ife yoꞌmayoso Jisas wene honɨngkanomo hoꞌnosyahonɨngkofi aꞌamu nomꞌneso ipamo swoꞌnjo lofontɨfi honɨngkanopo hoꞌnahumentohofofoho. Oso hiso Jisasɨye yofe hoꞌnomayoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jisas kako aꞌamu piꞌnɨngo ajwomo yahupo kehumentanɨngki aꞌamu sɨmoꞌmjo soꞌnji tɨfinjo soꞌnji mohmꞌno ole lɨmentohofi, Anɨtumo isamoyoka ulano. Kako wopɨngoꞌnohino hweho. Olo hwe lohumo nakwo Hwe Engo Anɨtu sohwo nakwoe hwahoponeꞌno uhwatɨmentiso hweho. Kakoe yofe wohoꞌnomano. ");
INSERT INTO apz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hwe engo Ntefit neyakwosamo hohonta mokosyohumamojo hopaso olo hwe lohwo wonemokosyohumano. Anɨtu ahwomomo humaso sohumo isamoyoka ulano. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas Jelusalem iꞌmofaponto Anɨtuye ango engo somo swonto yoꞌmayo somo feꞌnɨhwononto weꞌenepi mofehiꞌnyo ukwoꞌmokumonto yahonɨngki Jisas inomokomoyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sohwanji Mpetani fosyowaneꞌentɨfi sɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Imɨngoꞌnji nolɨkafontɨfi Mpetani ulɨkoꞌmantɨfi Jelusalemneꞌno nosontɨfi osopo Jisas mijoho engo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jisas iyo fesayo swo langoꞌnjo somo uhwonɨhwojawento ipisayo hiꞌnjotɨkeno lonto iyo huhwo sohwoꞌnjo sopo iꞌmofawento uhwonɨmentisoso ne ane swoꞌnohino uhwonɨmentisofoho. Oso iyo hiso ipisayo intoꞌnyo sɨkunommꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jisas iyomo ulɨmento, Aꞌamu ipisayo apaꞌno momjakinyoꞌne hwosoho. Ose ulahonɨngki inomokomoyo sohwa upaꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hofɨko Jelusalem iꞌmofapontɨfi Jisas kako Anɨtuye tajo ango engo somo noswonto aꞌamu hamniyoho syohoꞌnjo aꞌamu yoꞌmayoso humesyahonɨngkofi mpe ulohofo syohoꞌnjo sohwanjimo Jisas kako wae yaofo syoho emamentisofoho. Hofɨkoe ijempoho hamniyoho iwoloꞌmokumayo yontɨfe hoꞌnasiyoꞌne soꞌnji aꞌamu yɨhufo mpe uyantɨfi epohumayo yɨwoꞌnɨngkohofo soꞌnji Jisas kako mehuꞌmeeꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wayo yaofonto, Jisas ulɨmento, Olo ango lomo yoꞌmayoso apaꞌno nomotoswapɨkutoho. ");
INSERT INTO apz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ose ulonto lutɨhwamento, Anɨtuye hungkuno mtɨꞌmokumentohofo sohwa ole mtɨꞌmokumentohofi, Nje ango loso aꞌamu hopiꞌnono Anɨtumo isamoyoka ujoꞌne angofoho. Ose mtɨꞌmokumentohofofoho. I osoꞌno nje ango loso sekwo aꞌamu hamniyoho hiyasoꞌmo hufo mawoꞌnɨngkohofo sohwafe ango hopa imokalokwofo. Ose mtɨꞌmokumentohofofoho ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ose ulahonɨngki aꞌamu hopiꞌnonohini Jisasɨye hungkuno upaꞌnontɨfi pisopisaho mjalomɨwentɨfi hungkuno hiso wonyoangkafofoho syafɨhuꞌmentohofofoho. Aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji aꞌamu tajo ango syohoꞌnjo sohwanji hofɨko Jisasɨmo nofonjosyaneꞌentɨfi honɨngkano tɨpmmentohofoso hofɨko hwe moyaꞌmi somneꞌno iyoho unɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mofehiꞌnyo nɨngkuꞌnɨngkahonɨngki Jisas kakoe inomokomoyo sohwanji Jelusalem ulɨkoꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Imɨngoꞌnji honɨngkanomo apaꞌno nowentɨfi uhwonɨmentohofoso oso iyo yofe fesayo sohwo nɨhuꞌnahone yofoho imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita huno syafɨsyonto Jisasɨmo ulɨmento, Nakwoe Lonetɨhwayofo, uhwonyo. Oso iyo kɨko fosi aꞌamuso apaꞌno momjakinyoꞌne hwosoho ulɨmahnnoso yofohofoho. Jɨje hungkunoso ne imoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ose ulahonɨngki Jisas ulɨmento, Oso lɨmayoso syoho weꞌefoho. ");
INSERT INTO apz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Hungkuno nehopi waselɨmo. Hwe fihwo kako Anɨtumo sɨmeho hiꞌntnnono uyoso sohwo kako olo hwofɨkiꞌnyo lomo ole ulososo, Olo hwofɨkiꞌnyo lohwo, kɨko nolɨkafohoji oso mijo ayo mompo fɨlɨkofaofo. Ose ulososo kakoe huno angaꞌnohino mnaweho. Hwofɨkiꞌnyo wawomtolɨkeno oso hunoso mosyafɨsiyoꞌnjo. Oꞌo, oleꞌnohinoho huno syafɨsyososo. Ou, hwofɨkiꞌnyo sohwo kako nehopi wamontonoho. Oso hwe huhwo sohwo oso hungkuno olo soꞌmanji ou oso hungkunoso ne imoꞌnonefoho. Nehopi selohono. ");
INSERT INTO apz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Upaꞌnɨmno. Yoꞌmayo kɨko Anɨtumo jomo ulisoso sɨmeho momꞌmo huno ole, Anɨtu wontapmmontonoho. Ose syafɨhujoso, ou kako wokijapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sekwo sɨmano hintotohino semnosoꞌmanji sɨmoꞌmo sekwo oso aꞌamu wonyo selohofoso sohwoe wonyoso wae hmmopmno. Ose isoꞌmanji, Mpohwo ahwomomo humaso sohwo kako sekwoe wonyoso wae weesemofono.  ");
INSERT INTO apz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","I osoꞌno sekwo aꞌamu wonyo selohofo sofe wonyoso hohujo hohntaꞌni momehoꞌnasiyoꞌmanji sekwoe Mpohwo ahwomomo humaso sohwo kako sekwoe wonyoso wae meesemofonehoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hofɨko Jelusalem apaꞌno iꞌmofapontɨfi Jisas Anɨtuye tajo ango engo somo ajwoꞌmo emoyontanɨngki aꞌamu tajo ango syohoꞌnjo sohwanji, aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji, Jutafe hwe engo sohwanji Jisasɨmo uꞌmantɨfi ");
INSERT INTO apz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ulohonɨmentohofi, Kɨko olo syoho iwoꞌnɨngkino loso tɨhwo kilɨmasoꞌno iwoꞌnɨngkinoto. Yokumpohnꞌnyoso tɨhwo kijapmmasoꞌnji iwoꞌnɨngkinoto. ");
INSERT INTO apz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Ngko huhwoꞌni hungkuno waselohonɨmneꞌno yohono. Olo hungkuno hiloso sekwo ntɨfijoꞌmanji eꞌwa, yoꞌmayo yalokwe soꞌno hwapɨngo waselɨmo. ");
INSERT INTO apz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ole ntɨmno. Joun kako aꞌamumo mijo kiyomaꞌmojo yokumpohnꞌnyoso Anɨtu mtaꞌango maꞌmentisotaho. Hwahoponjo aꞌamu mtaꞌango maꞌmentisotaho. ");
INSERT INTO apz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sekwo ntɨmno. Ose ulohonɨngkahonɨngki hofɨko ole hnnɨmaꞌmentohofi, I Joun kakoe yokumpohnꞌnyo Anɨtu mtaꞌni maꞌmentisofoho ulosoꞌmanji ole wonalɨmontonoho, Oseꞌmanji sekwo Jounɨye hungkunomo sɨmeho hiꞌntnnono muyoꞌnjo pehoꞌneto. ");
INSERT INTO apz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","I, nakwo ole lasoso, Joun kakoe huno mtaꞌni syoho imentisofoho lasoꞌmanji aꞌamu sohwa hofɨko nolɨkafɨkuji ikujoho wonefonjantɨfeho. Hwapɨngoso hofɨko aꞌamumneꞌno iyoho unɨmentisofoho. Aꞌamu huhwo sohwafe huno ole, Joun sohumo Anɨtu hungkuno uyahonɨngki lɨmojo hweho. ");
INSERT INTO apz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ose hnnontɨfi Jisasɨmo ulɨmentohofi, Nakwo huno monayohoyohoho. Ose ulohonɨngkofi Jisas ulɨmento, Oseꞌmanji ngko huhwoꞌni nje yokumpohnꞌnyo yoꞌmayo iwoꞌnɨngkohe hwapɨngo soꞌno maselɨmnehono. ");
INSERT INTO apz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ose ulonto Jisas pahnnɨmo hungkuno lomaꞌmento, Hwe fihwo kako ipisayo syoho hulonto, tojo emontofasyonto syoho ajwomoꞌmo ipisayo mijoꞌne kompusoho mtɨꞌmokumentisofoho. Ose yonto ango yokintahopo ipisayo syoho somo uhwontohumayoꞌne molɨmentisofoho. Ose imentisoso kako oso syoho homo somo mokosyohumayoꞌne kako aꞌamu hamniyoho syoho emawoꞌnɨngkohofo sohwafe ahomo hoꞌnasyonto kako ango ikanopono nowento osopo kako neꞌno humamojofoho ");
INSERT INTO apz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ipisayo syoho ulohofiyo sohumo ipisayoꞌne kakoe ipisayo syohopono lɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hwe syoho mokosyohumayo sohwa kakoe syoho ulohofiyo sohumo uhwonontɨfi aho kemokosyohumantɨfi, ikujoho fonjontɨfi, ipisayo muyoꞌnjo yontɨfi wae yaoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Oseso kakwoꞌyohwo sohwo nomꞌne syoho ulohofiyo sohumo ipisayoꞌne lɨhwojahonɨngki hofɨko oso hwe sohwe mnokinopo ikujoho fonjontɨfi wonyo umokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nomꞌne syoho ulohofiyo sohumo lɨhwojahonɨngki aꞌamu ipisayo syoho mokosyohumayo sohwa hofɨko fonjahumentohofofoho. Kakwoꞌyohwo nomꞌne syoho ulohofiyo sohwamo lɨhwajɨwoꞌnontanɨngki fehohnjo ikujoho fonjontɨfi fehohnjo fonjahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Oseso syoho ulohofiyo nomꞌneso mohumayofoho. Moiꞌwonoho. Osoꞌno kakoe hwomu angaꞌnohino sohumo aeꞌuyo lɨhwajonto lɨmento, Hofɨko nje hwomufe hungkunomo haloho wopeentɨfeho. Ose lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Hwomu huhwo sohwo nuꞌmahonɨngki hwe syoho mokosyohumayo sohwa uhwonontɨfi hnnɨmentohofi, Oso hwe sohwo kako hwangku sohonta kanɨngkwohwoe yoꞌmayoso nomane hweho. Oyonɨmno. Nakwo komoꞌno kakimo poyo nofonjosyɨhwasi nakwo kakoe syohoso nɨhuꞌnahone womantanoho. ");
INSERT INTO apz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ose hnnontɨfi hwomu sohumo aho kentɨfi fonjahumentohofofoho. Nofonjasyontɨfi kakoe pijafo mempo swohoꞌnaoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kakwoꞌyohwo sohwo aꞌamu wonyo huhwo sohwamo pipi ulohoꞌmontolo. Hwangku kako nopɨhwosi aꞌamu wonyo sohwamo nofonjasyɨhwosi kako nomꞌne aꞌamu sohwamo syoho hiso mokosyohumayoꞌne uyɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Olo Anɨtuye hungkuno losoꞌno sekwo huno maseyoꞌnjotaho. Hungkuno ole, Oso sojo engkwosaho paꞌnyo aꞌamu ango injuwoꞌnɨngkohofo sohwa wae yaoꞌmentohofo loso olohontajo engkwosaho loso angomo sosofitofoꞌne hwapɨngohwo imoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nakwoe Hwe Engo sohwo ole lɨmentisoso imoꞌnɨmentisofoho. Nakwo olo soꞌno uhwonontaneso wonyoangkafofoho. Oso pahnnɨmo hungkunoso lalokuhwono Anɨtu lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jutafe hwe engo sohwa nupaꞌnontɨfi oso pahnnɨmo hungkunoso aꞌamu syoho mokosyohumayoꞌno nto ulɨmentiso soꞌno nto lohoho hofɨkineꞌno huno uyahonɨngki hofɨko Jisasɨmo aho wokantɨfi ko imentohofoso aꞌamumneꞌno iyoho unɨmentisofoho. Oseso hofɨko Jisasɨmo ulɨkoꞌmantɨfi umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nowentɨfi hofɨko aꞌamu Falisi fihwanji aꞌamu Heloutɨmo uhwontohofo sohwanji Jisasɨye hungkunomo yamofo ulohofoꞌne lɨhwatɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jisasɨmo nuꞌmantɨfi afofo umokontɨfi ulɨmentohofi, Nakwoe Lonetɨhwayo sohwosi, kɨko hwe hungkuno nehopiꞌnohino lɨwoꞌnɨngkino sohwohnneꞌno huno nayohoho. Kɨko aꞌamumneꞌno iyoho makinɨwoꞌnɨngkiso hwosoho. Osoꞌno aꞌamu yofe engoꞌnjo sohwanji aꞌamu yofe ane sohwantnneꞌno kɨko huno piꞌnɨngo mokiyahonɨngki Anɨtuye honɨngkano nehopiꞌnohino lutɨhwawoꞌnɨngkino hwosoho. Osoꞌno hungkuno angaꞌno wakilohonantaneꞌno yɨhwono. Nakwoe hwe yofe engoꞌnjo Sisa kako hwaho mokosyohumayo sohumneꞌno hamniyoho (takis) hoꞌnasiyoso wopɨngotaho. Wonyotaho. Nakwoe honɨngkano hungkunoso pehofo nalohoho. ");
INSERT INTO apz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ose ulahonɨngkofi Jisas hofɨkoe sɨmeho hufaꞌuꞌnjo soꞌno huno uyahonɨngki ulɨmento, Sekwo ngkimo yamofo pehoꞌno ntohofalokwofo. Hamniyoho angaꞌno ntapmno. Uhwonɨmo. ");
INSERT INTO apz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ose ulahonɨngki nuyahonɨngkofi Jisas ulɨmento, Olo huyoꞌmango loꞌnji yofe loꞌnji tɨhwoeto. Ose ulahonɨngki ulɨmentohofi, Sisafefoho. ");
INSERT INTO apz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ose ulahonɨngkofi Jisas ulɨmento, Sisafe yoꞌmayo soꞌmanji Sisamo uyɨmno. I, Anɨtuye yoꞌmayo soꞌmanji Anɨtumo uyɨmno. Ose ulahonɨngki hofɨko huno piꞌnɨngo engo syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Aꞌamu nomꞌnihwa hofɨkoe yofe Satɨyusi Jisasɨmo uꞌmaꞌmentohofofoho. Oso aꞌamu huhwa sohwa hofɨkoe huno ole uyɨwoꞌnɨngkohi, Aꞌamu poyo peꞌnyo sohwa nɨhuꞌnahone peꞌnɨwoꞌnɨngkohofo apaꞌno songo molɨkafeꞌnefoho. Ose syafɨsyɨwoꞌnɨngkohofofoho. Jisasɨmo uꞌmantɨfi ole ulohonɨmentohofi, ");
INSERT INTO apz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Nakwoe Lonetɨhwayo sohwosi, Mouses nakumneꞌno hungkuno ole mtɨꞌmokumento, Hwe fihwo kako ape nomahwosi kako mehomi motɨpemayoꞌnjo sohwo poyo peꞌnɨngkuhwosoꞌno oso ape hisimo konɨngkwaꞌwehwo nomahwosi kolaꞌwehumneꞌno mehomi wotɨpemano. Mouses ose mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oseso hwe aho fehohnjo hopiꞌnono nomnꞌi mtaꞌni hufaꞌu hwaꞌu humamojiyefoho. Tisɨmaso sohwo ape nomanto mehomi ane poyo peꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Oseso konɨngkwaꞌwehwo oso ape hisimo nomanto mehomi ane poyo peꞌnɨmentisofoho. Oseso konɨngkwaꞌwehwo oso paꞌnyo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Oseꞌno oseꞌnohinofoho. Homnɨngkwaꞌwehwosa hopiꞌnono mehomi ane poyo peꞌnɨmentohofofoho. Tɨfi sohonta oso aꞌmu hi oseꞌnohini peꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Oseso aꞌamu poyo peꞌnyo sohwa lɨkapijo sohonta tɨhwoe ape umoꞌnɨmontolo. Hofɨkoꞌnɨkwehwa aho fehohnjo hopiꞌnono nomꞌni mtaꞌni hufaꞌu sohwa ape hisimo nto maꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Sekwo Anɨtuye hungkuno soꞌnji Anɨtuye yokumpohnꞌnyo soꞌntnneꞌno huno maseyoho yohoho. Osoꞌno sekwo hwasyo hungkuno lalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Upaꞌnɨmno. Aꞌamu poyo peꞌnɨmentohofo sohwa nolɨkafɨkuji hofɨko ape momaꞌnɨfitnnefoho. Oꞌo hofɨko aꞌamu ahwomomjo ape momasoꞌnjo paꞌnyo imoꞌnɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Oso hungkunoso aꞌamu poyo peꞌnɨmentohofo sohwa apaꞌno lɨkapitnneꞌno sekwo Mousesɨye hungkuno atofo majotaho. Iyo tɨfo somtaꞌni toho sijontanɨngki Anɨtuye mampaho hoꞌnɨmentisofoho. Apɨlohamjanji Jekoup Aisakɨjanji hofɨko poyo peꞌnɨmentohofofoho. I osoꞌno Anɨtu Mousesɨmo ulɨmento, Ngko Apɨlohamja Aisakɨja Jekoupɨjafe Anɨtuꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mouses kako ole syafɨhuꞌmento, Apɨlohamja Aisakɨja Jekoupɨja hofɨko hohonta poyo ko peꞌnɨmentohofo sohwa songo humalofo soꞌno syafɨsyonto oso hungkuno hiso lutɨhwamentisofoho. Anɨtu kako poyo peꞌnyo sofe Anɨtu hwoꞌmaho. Oꞌo, kako aꞌamu songo humalofo sofe Anɨtuyoho. Sekwoe hungkunoso hwayo hohnjofoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hwe fihwo Jutafe honɨngkano hungkuno lutɨhwamojo sohwo hofɨko oso hungkuno hnnontanɨngkofi upaꞌnɨmentisofoho. Jisasɨye hungkuno hunoꞌnjoso nupaꞌnonto Jisasɨmo nuꞌmanto ulɨmento, Anɨtuye honɨngkano hungkunoso nomꞌne somo yakoloꞌnnyoso ntisoto. ");
INSERT INTO apz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ose ulahonɨngki Jisas ulɨmento, Honɨngkano hungkuno engo sɨmoꞌmjo yakoloꞌnnyoso olenoho. Aꞌamu Isɨlael soku sekwo upaꞌnɨmno. Anɨtu sohwo kakoꞌnohini nakwoe Anɨtuyoho. ");
INSERT INTO apz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kɨko jɨje Hwe Engo Anɨtu sohuneꞌno jɨje sɨmeho uyohoji jɨje sɨmeho hopiꞌnonohinoso kakimo uyo. Kɨko jɨje Hwe Engo Anɨtu sohuneꞌno jɨje sɨmeho uyohoji jɨje huyoꞌmango hopiꞌnonohinoso kakimo uyo. Kɨko jɨje Hwe Engo Anɨtu sohuneꞌno jɨje sɨmeho uyohoji jɨje huno hopiꞌnonohinoso kakimo uyo. Kɨko jɨje Hwe Engo Anɨtu sohuneꞌno jɨje sɨmeho uyohoji jɨje yokumpohnꞌnyo hopiꞌnohinoso kakimo uyo. ");
INSERT INTO apz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Honɨngkano hungkuno tɨfinjoso olenoho. Kɨko hi kumoꞌnonto sɨmeho kumoꞌnɨngkiso paꞌnyoso aꞌamu nomꞌnemneꞌno kɨkoꞌnjo mofone sopo humalofo somo uyo. Oso honɨngkano hungkuno hufaꞌu sohwaꞌu hungkuno hopiꞌnohinomo yakoloꞌnnyofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ose ulahonɨngki hwe honɨngkano hungkuno lutɨhwamojo sohwo Jisasɨmo ulɨmento, Ou Nakwoe Lonetɨhwayo sohwosi, nehopi lohino. Anɨtu kakoꞌnohini nakwoe Anɨtuyoho. Anɨtu nomꞌnehwo mohumuyoho. ");
INSERT INTO apz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ou, jɨje sɨmeho, jɨje huno, jɨje yokumpohnꞌnyo Anɨtumo hopiꞌnono uyo. Kɨko kikineꞌno kumoꞌnyo hopaso kɨko nomꞌne aꞌamuneꞌno wakumoꞌnono. Nakwo oso honɨngkano hufaꞌumo inɨngkowasoꞌmanji oso yahinoso nakwoe wonyo wae yaofoꞌne yahu fonjokisasiyo yoꞌmayo Anɨtumo uyosoꞌno yakoloꞌnnyofoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Oso hwe huhwo sohwoe hungkunoso Jisas nupaꞌnonto huno wonyoangkafofoho syafɨsyonto ulɨmento, Kikineꞌno Anɨtu yoꞌmayo yokumpohnꞌnyo mokosyohumayoso mofoneponoho. Ose ulahonɨngki aꞌamu nomꞌne sohwa nomꞌne hungkuno Jisasɨmo ulohonyo soꞌno iyoho imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas Anɨtuye ango engomo hwe moyaꞌmi piꞌnɨngo engomo lutɨhwamentisoso ulɨmento, Aꞌamu Jutafe honɨngkano hungkuno lutɨhwamotofo sohwa olo hungkunolo pehoꞌno lutɨhwaꞌwoꞌnɨngkohofo. Kɨlais kako oso Anɨtu nakwoe hwahopo uhwatɨmentiso sohwo Ntefit hwe yofe engoꞌnjo hohonta hwaho mokosyohumamojo sohwoe imu hweho. Oseso pipi lɨwoꞌnɨngkohofo. ");
INSERT INTO apz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Anɨtuye Towahuno Wopɨngo hohonta olo hungkunolo Ntefitɨye sɨmeho moꞌmo hoꞌnasyohonɨngki Ntefit ole mtɨꞌmokumento, Anɨtu kako nje Hwe Engo Kɨlais, Anɨtu nakwoe hwahopo uhwatɨmentiso sohumo ole ulɨmento, Kɨko nje aho anga sohohntaꞌni fosyohumaho. Osopo kɨko nohumahoji ngko jɨje mango sohwamo jɨje sɨfɨkiꞌnyoꞌmo enjwaꞌmo wakuhumotɨꞌmonnoho. Oso hungkunoso Ntefit mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ihwoni. Oseso Ntefit kako oso hwe Anɨtu nakwoe hwahopo uhwatɨꞌmentiso Kɨlais sohuneꞌno nje Hwe Engo hweho lɨmentiso soꞌno Kɨlais sohwo kako Ntefitɨye imuhwo imoꞌnyoso pipilo. Ose ulahonɨngki aꞌamu nupaꞌnontɨfi hungkuno wonyoangkafofoho syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas nomꞌne hungkuno lutɨhwamento, Sekwo aꞌamu honɨngkano hungkuno lutɨhwawoꞌnɨngkohofo hunoꞌnjo sohwafe yahino somneꞌne iꞌwaho itoꞌno fiyɨmno. Hofɨko hofɨkoe yofe engo somneꞌno hwapɨfe sawemo yontɨfi honɨngkanopo emoyɨwoꞌnɨngkohofofoho. Osopo emoyontanɨngkofi hwe moyaꞌmi hofɨkimo uhwonontɨfi nakwoe hwe engo hwasoho ulɨwoꞌnɨngkohofo soꞌno umoꞌnɨwoꞌnɨngkisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Osoꞌnji hofɨko tajo ango somo aꞌamufe sɨmanopo humayoꞌno umoꞌnɨwoꞌnɨngkisofoho. Osoꞌnji hofɨko aꞌamu wopayo engo iloho yano sohonta epohumayo sɨmoꞌmjo soꞌno umoꞌnɨwoꞌnɨngkiso hwafoho. ");
INSERT INTO apz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hofɨko Anɨtumo hungkuno sawemo engo jomo ko ulontɨfi hofɨko apɨwojo sofafe ango yoꞌmayo soꞌno wosemokosyohumano poji ulontɨfi ango hiso hofɨkoꞌne nɨhuꞌnahone emawoꞌnɨngkohofɨhwafoho. Ose hwe huhwo sohwo tohino engo notɨpemapitnnefoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas kako Anɨtuye tajo ango engo somo aꞌamu Anɨtumneꞌno hamniyoho hoꞌnasiyo sopo nohumanto hofɨko ipofomo hoꞌnosyontanɨngkofi uhwonɨmentisofoho. Aꞌamu hamniyoho engoꞌnjo sohwa hamniyoho piꞌnɨngo hoꞌnahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Apɨwojo hoꞌyango anesi noponto hamniyoho weꞌe hufaꞌu hoꞌnahumentisofoho. Oso hamniyohoso touya angaꞌnohino paꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jisas uhwononto kakoe inomokomoyo sohwamneꞌno joho lutɨmanto ulɨmento, Hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Sekwo upaꞌnɨmno. Olo apɨwojo losi kako hamniyoho hoꞌnasiyoso nomꞌne aꞌamu hopiꞌnono Anɨtumneꞌno hoꞌnasyohofo somo kakoe weꞌeso uyakolokwoho. ");
INSERT INTO apz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nomꞌne aꞌamu hamniyoho hoꞌnosyalokwofoso hofɨko hamniyoho engo mokosyohumunyofoho. Osoꞌno hofɨko oso hamniyoho engo somtaꞌni Anɨtumneꞌno weꞌeꞌnohini hoꞌnosyalokwofoho. Olo apɨwojo losi kako hamniyoho mokosyohumunyoso hopiꞌnonohino Anɨtumneꞌno hoꞌnasyohoho. Kako nomꞌne hoꞌyangoso nomꞌne hamniyohoso nɨhuꞌno aniyoho. ");
INSERT INTO apz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas kako Anɨtuye tajo ango engo mtaꞌango sohwo noswopahonɨngki inomokomoyo fihwo ulɨmento, Nakwoe Lonetɨhwayo sohwosi, tɨmo uhwonyo. Olo ango wonyoangkafofoho. Sojo wopɨngoꞌnji molinyofoho. ");
INSERT INTO apz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ose ulahonɨngki Jisas ulɨmento, Olo ango engo lomo luhwonalokuno. Hwangku olo ango lomjo sojo angaꞌnohinoso nomꞌnepo kihnꞌnawesoso awonoho. Oꞌo hofɨko olo ango wopɨngo losomo mtɨhupekuji womehuꞌmmokwojantɨfeho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas kako hwofɨkiꞌnyo Oulif sopo nosonto osopo ntaꞌni Anɨtuye tajo ango engo somo uhwononto ampo humamentisofoho. Pita, Jemɨs, Joun, Entɨlu hofɨkoꞌnohini Jisasɨmo uꞌmantɨfi ulohonɨmentohofi, ");
INSERT INTO apz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Oso hungkuno ntonalohinoso sɨkuno ntisomo imoꞌnoneto. Oso sɨkuno somo nakwo pipi yaneto. Weꞌenepi uꞌmofapmmontolaho. ");
INSERT INTO apz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ose ulohonɨngkahonɨngkohofi Jisas ulomaꞌmento. Aꞌamu, sekwo hwasyo hungkuno sejo soꞌno sekwo iꞌwaho itoꞌno fiyɨmno. ");
INSERT INTO apz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aꞌamu piꞌnɨngo engo iꞌmofapɨkuji hofɨko nje yofe ntɨkuji ole selɨfitnnefoho, Ngko Kɨlais hwoꞌnyoho. Anɨtu nɨhwosopoꞌmentiso hwoꞌnyoho. Ose selɨfijoso aꞌamu piꞌnɨngo hofɨkoe hungkunomo inɨngkafitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Hwangku aꞌamu hwaho kengoponjo sohwa hofɨko nomꞌne hwahoponjo sohwanji ikujoho fongkiꞌnyoꞌne soꞌnji aꞌamu hwaho afaponjo sohwa ikujoho fongkiꞌnyoꞌne soꞌntnne oso hungkunoso nupaꞌnɨngkuji iyoho senyoꞌeno. Oꞌo oso yoꞌmayoso iꞌmofapɨhwosoꞌno i ikujoho fongkiꞌnyoso iꞌmofapososo sɨkuno moiꞌwo mmoꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Hwangku aꞌamu temtitofo kengo sohwanji temtitofo nomꞌne sohwanji hofɨko ikujoho fongkiꞌnɨfitnnefoho. I aꞌamu hwaho kengopontaꞌango sohwa nomꞌne hwaho kengoponjo sohwanji ikujoho fongkiꞌnɨfitnnefoho. Hwaho angoꞌmeemo hwomɨhwo yɨhwosi wopayo ane mijoho engo iꞌmofaponefoho. Oseso olo tango weꞌeso emayofoho. Tango mɨkunɨmposo tɨfi noꞌmo weho. ");
INSERT INTO apz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yoꞌmayoso uhwonɨngkuji sekwo iꞌwaho itoꞌno fiyɨmno. Kaunɨsolɨꞌnjopo ipesemotafitnnefoho. Hofɨko tajo ango somo sekumo ikujoho nosefongkupitnnefoho. Hofɨko ngkimo monje wenisyano lɨkuji hofɨko sekumo hwe yofe engoꞌnjo hwaho mokosyohumayo sohwafepono upesemotowantɨfeho. Osoꞌno sekwo aꞌamu yofe engoꞌnjo sohwamo nje hungkuno wolutɨhwantɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","I, sɨmoꞌmo aꞌamu hopiꞌnono angoꞌmeemjoso nje hungkuno wopɨngo upaꞌnɨngkujoꞌno tɨfi sɨkuno moiꞌwo imoꞌnonefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hofɨko nosetɨmafɨkuji hungkuno mɨhwajiyo ango somo mesehumatɨpijo sohonta selohonɨfitnnefoho. Sekwo hungkuno ujosoꞌno huno piꞌnɨngo syafɨsiyoꞌeno. Oꞌo, osohonta Anɨtu sekwoe sɨmehomo hungkuno hoꞌnasesyɨhwosoꞌno sekwo ulɨfitnnefoho. Oso hungkuno hiso sekwoeꞌmaho. Oꞌo Anɨtuye Towahuno Wopɨngo oso hungkunoso lonefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Osohonta aꞌamuso konɨngkwaꞌwehumo hungkuno lɨwoꞌnɨngkohofo sopono ipemotakuji osopo hungkuno lɨkuji nofonjasehufitnnefoho. Hwe fihwo kakoe mehomimneꞌno oso paꞌnyo ulohofonefoho. Mehomiso kanɨngkwohwoꞌyaꞌumneꞌno mangohwa imoꞌnɨngkuji fonjahufitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Oseso hwe moyaꞌmi hopiꞌnono sekumneꞌno sɨmeho tohino mɨkunɨmposo umnonefoho. Hwapɨngoso nje yofeso sekumo weho. I, aꞌamu fihwo yokumpohnꞌnyo neꞌno lohofontanɨngkuhwosi sɨkuno aeꞌuyo imoꞌnososo Anɨtu oso huhwo sohumo utɨmanefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Hohosohonta yoꞌmayo nɨhuꞌno wonyo hwapɨngoso ango kakineꞌno masyuyoꞌne somo hwasyoponoho linyo sopo lohofɨhwosoꞌno uhwonɨfitnnefoho. Ose uhwonɨngkuji youwo lɨkuji aꞌamu Jutiya humalofoso hwofɨkiꞌnyo poneꞌno hiyaso sɨfitnnefoho. Aꞌamu olo hungkuno loso atofo loso sohwo huno itoꞌno wosyafɨsyono. ");
INSERT INTO apz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Hwe fihwo antɨfepo humaso sohwo kako hwahopo pɨwelɨkofaohwosi olo wonyo hiso uhwonɨngkuhwosi kakoe hoꞌyango yoꞌmayo soꞌno kakoe angomo maswonehoho. ");
INSERT INTO apz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aꞌamu syohoꞌmo lohofontoso sohwo kakoe angopo ntaꞌni ife womaꞌmo lososo momawenefoho. Oꞌo, leꞌmoꞌnohini lohofonefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Oso sɨkuno somo moyaꞌmi sɨmehoꞌnjo sofanji mehomi weꞌe amno unyo sofantnneꞌno ngko hitoho ntokwoho. Hofɨko hiyaso komoꞌno leꞌmofoso pipilo. ");
INSERT INTO apz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Olo sɨkuno hiyaso leꞌmofoꞌne wojoso sɨkuno meeofoso soꞌnji iꞌmofaposoꞌmanji sekwo leꞌmofoso pipilo. Osoꞌno sekwo Mpohumo jomo ulɨkuno. ");
INSERT INTO apz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Olo tohino tɨpemayo sohontaꞌneꞌno selalokweso mɨkunɨmposofoho. Anɨtu sɨmoꞌmo yoꞌmayo mtɨꞌmokumentiso sohonta ajuyohwosa humapmmotofo sohonta, olohonta, olo hwaho lopo oso tohino paꞌnyoso mꞌmofapefoho. Olo tohino engo tɨpemayo lohonta yakoloꞌnnyofoho. Tɨfi noꞌmo tango apaꞌnohinoso oseꞌneꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Oso sɨkuno tohino mayo somo Anɨtu kako tɨfo mmokiyoꞌmanji aꞌamu nɨhuꞌno hopiꞌnono poyo nto imoꞌnɨfijoꞌnesohilo. I osoꞌno Anɨtu kakoe aꞌamu uhwosopoꞌmentiso somneꞌno huno syafɨsyɨhwosi sɨkuno oso tohino mayo soꞌno tɨfo imokumneꞌento imentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Osohonta hwe fihwo ole noselonefoho, Olopo uhwonɨmno. Kɨlais olopo humaho. Ou, aꞌamu nomꞌnihwo selososo, Uhwonɨmno. Kɨlais oso nompo humaho. Ose selɨkujoꞌno sekwo hofɨkoe hungkunomo tɨfi inɨngkayoꞌeno. ");
INSERT INTO apz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Osohonta aꞌamu fihwo ole selososo, Ngko Kɨlais hwoꞌnyoho. Nomꞌnihwo Anɨtuye hungkuno hwasyo lutɨhwayo sohwa iꞌmofapɨkuji yoꞌmayo wonyoangkafo yamofo sekumo esetɨhwafitnnefoho. Aꞌamu Anɨtuye hungkunomo esetɨhwafitnnefoho. Aꞌamu Anɨtuye hungkunomo minɨngkayoꞌnjo hopiꞌnohinoso oso hisofe hungkunomo inɨngkafitnnefoho. I, Anɨtuye aꞌamu neso hungkuno hwasyomo unɨngkowantɨfitɨkeno lɨkuji yoꞌmayo wonyoangkafoso yamofo esetɨhwafitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Osoꞌno sekwo tɨmo itoꞌno uhwontohumamno. Olo yoꞌmayo hilo soꞌno nto selohefoho. Osoꞌno yoꞌmayo uhwonɨfijo soꞌno huno itoꞌno seyonefoho ");
INSERT INTO apz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Oso tango hiso moiꞌwo imoꞌnɨngkuhwosoꞌno mofehiꞌnyo sɨkwoꞌmno imoꞌnɨngkuhwosoꞌno hamno majoꞌnjo ihwosi ");
INSERT INTO apz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","hntokwaliyo ahwomontaꞌango nopɨwasyonefoho. Yoꞌmayo ahwomomjo yokumpohnꞌnyo yomo yomo ifitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Oso hiso iꞌmofopahonɨngkuhwosi Aꞌamufe Hwomu sohwo kako himopo kakoe yokumpohnꞌnyo engo mɨkunɨmposoꞌnji kakoe pomponaho engoꞌnji noponefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hohosohonta Anɨtu kakoe aꞌamu ahwomomjo somo uhwajɨhwosi angoꞌmeemjo aꞌamu uhwosopoꞌmentiso somo nuhuꞌmokonefoho. Hwaho ae efohotoꞌnawojoꞌmeemjo somo mɨhwofojonefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sekwo iyo mijisiyo somo uhwonɨmno. Uyonɨmofoso uhwonɨngkuji jefo uyɨmonteꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Oseso oso paꞌnyoso yoꞌmayo somneꞌno selohe somo uhwonɨngkuji huno ole waseyono. Kakoe sɨkuno nto iꞌmofapohoho. Kako hokuꞌyopo lohokwoho. Huno ose waseyono. ");
INSERT INTO apz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Hungkuno nehopi waselɨmonneꞌno yohono. Hwe moyaꞌmi olopo hwaho lopo nohumentanɨngkuji yoꞌmayo hiso imoꞌnonefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ahwomoꞌnji hwahoꞌnji moiꞌwo imoꞌnoso sohonta nje hungkunoso moiꞌwo mmoꞌnonefoho. Neꞌno nowentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Oso sɨkuno somneꞌno nakwo huno monayofoho. Aꞌamu ahwomoꞌmjo sohwanji ngkoꞌnji huno monayofoho. Oꞌo, Mpohwo Anɨtu kakoꞌnohini huno uyalofoho. ");
INSERT INTO apz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Oso sɨkuno hiso sekwo huno maseyɨhwosoꞌno sekwo itoꞌno fohontohumamno. ");
INSERT INTO apz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pisoꞌmoꞌnyo ikutoho. Pahnnɨmo hungkuno upaꞌnɨmno. Ngko olo paꞌnyo hwoꞌnyoho. Hwe engo sohwo hano ikanopo waꞌmo lonto kako kakoe syoho ulohofiyo angaꞌno angaꞌnohino sohwamo syoho yano ulofihwosi hwe hokuꞌyo mokosyohumayo sohumo ole ulɨmontono, Itoꞌno uhwontohumaho. Ose ulɨhwosi wamontonoho. Ose ulonto, ulɨmento, ");
INSERT INTO apz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sekwo olo hwe huhwo sohwo pone sohonta huno maseyonefoho. Sɨkunoꞌnjilɨkeno. Sɨkwoꞌmiyomtɨkeno. Yɨhufo yokajoꞌnjilɨkeno. Imɨngo neꞌnjilɨkeno. Oseꞌmanji tɨmo itoꞌno fohontohumamno. ");
INSERT INTO apz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Sekwo saho fosyowentanɨngkuji kako komoꞌnoponoho lɨkuji itoꞌno fohontohumamno. ");
INSERT INTO apz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Oso hungkuno seloheso aꞌamu hopiꞌnonohinomo ulalokweno. Itoꞌno fohontohumamno. ");
INSERT INTO apz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aꞌamu Jutafe Sɨkuno Engo imoꞌnyo sopo iꞌmofayoꞌne sɨkuno hufaꞌu wentanɨngki oso sɨkuno sɨmoꞌmjoso Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyofoho. Sɨkuno nomꞌnehwi hofɨko wopayo engo mokamoꞌnnyoso nɨmotofofoho. Oso sɨkuno engo hufaꞌu mꞌmofape sohonta sɨkuno hufaꞌu nowentanɨngki oso hwe tajo ango syohoꞌnjo yofe engoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwayo syohoꞌnjo sohwanji uhuꞌmokontɨfi, Hofɨko Jisasɨmo aho hiyasoꞌmo kehwasi nofonjosyaneꞌentɨfi honɨngkanoꞌno tɨpmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ole hnnɨmentohofi, olo hiloso Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo Sɨkuno Engo osomo wopayo engo nontanɨngkuji aho kehwasoꞌno nonahonɨngkuji, aꞌamu hofɨko nakumo ikujoho nafongkupitnnoho. Oso hisoꞌno Sɨkuno Engo homo somo nakwo Jisasɨmo aho kehwaloho. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas kako Saimounɨye ango Mpetani sopo humamentisofoho. Saimoun huhwo sohwo aꞌapaho uyo wonyoꞌnjo hweho. Jisas hofɨkoꞌnji wopayo nontanɨngkofi aꞌmu fisi sojo ahwonte weꞌe hwone mijo akino wonyoangkafoꞌnjoso motoswapmmentisofoho. Oso mijo soꞌno hamniyoho mpe weꞌeꞌmaho. Nomotoswaponto ahwonte maneso hohwanɨpo lohofonto Jisasɨye mnokinopo mijo sohumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nosɨsyontanɨngki aꞌamu fihwa uhwonontɨfi sɨmano hintotohino umnɨngkahonɨngki hnnɨmentohofi, Oloso wopɨngoꞌmaho. Hwone mijo wonyoangkafoso siki sɨsiyoso pehoꞌneto. ");
INSERT INTO apz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Olo mijo losoꞌno aꞌamu fihwo hamniyoho mɨkunɨmposo (300 tenaliyo) nejapontentesi oso hamniyoho aꞌamu wopayo umofonyo iyo neꞌno uyɨhwanesohilo. Ose hnnontɨfi aꞌmu simo yoka ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yoka ulahonɨngkofi Jisas ulɨmento, Kakoe syohofoho. Sekwo pehoꞌno olosimo sɨmeho tango uyalokwofo. Kako ngkimo wopɨngo ntohokwoho. ");
INSERT INTO apz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aꞌamu yoꞌmayo umofonyo iwoꞌnɨngkohofoso sekwoꞌnji neꞌnohino humawoꞌnɨngkohofofoho. Sekwo hofɨkimo ufoꞌmantɨfiꞌmanji nohono ufoꞌmapmno. I osoꞌno ngko sekwoꞌnji olo hwaho lopo neꞌno nohumantɨꞌmne hwonɨꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Olo hiso ntohofisoso wopɨngofoho. Kako nakwo aꞌamufe pijafo piꞌnɨmomo wohoꞌnosyano lontani ehulohofɨwoꞌnɨngkuhwone hopaso ehontohokwoho. ");
INSERT INTO apz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Hungkuno nehopi waselɨmo. Ango yawojoꞌmeemo nje hungkuno wopɨngo aꞌamu somo ulɨkujoso olo aꞌmu losi ntohofiso sotnneꞌno ulɨfitnnefoho. Osoꞌno aꞌamu piꞌnɨngo engo olo aꞌmu losimneꞌno syafɨhupitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Osohonta Jutas Isɨkaliyout kako Jisasɨye inomokomoyo aꞌamu aho hopiꞌnono sɨfe mtaꞌni hufaꞌu uhwosopoꞌmentiso sohwo kako oso aꞌamu tajo ango syohoꞌnjo yofe engoꞌnjo sohwamo Jisasɨneꞌno aho kopitnneꞌno ufoꞌmaꞌmo lonto hofɨkoe angopo uꞌmaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hofɨko nupaꞌnontɨfi sɨmeho wopɨngo umoꞌnɨngkahonɨngki oso hisoꞌno hamniyoho wokijopano ulɨmentohofofoho. Oseso Jutas Jisasɨmo utɨhwamneꞌento honɨngkano imofoꞌne syofɨsyomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sɨkuno Engo sɨmoꞌmjo Wopayo Feejo Lohonɨmotofo Sɨkuno somo hofɨko yahu fonjahumotofo sohonta Jisasɨye inomokomoyo sohwa Jisasɨmo ulɨmentohofi, Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo Sɨkuno Engo osomneꞌno wopayo naneso ntɨꞌmo ntɨꞌmo esyohumanehwono. ");
INSERT INTO apz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ose ulahonɨngkofi Jisas inomokomoyo hufaꞌu sohwaꞌumo ulɨmento, Siko antɨme engo sopo nowehosɨsi osopo hwe fihwo kako mitɨhwontohoꞌnjo sohumo uswoꞌnɨngkohosɨsi kakimo tɨfi finɨngkunyo. ");
INSERT INTO apz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kako angomo syuhwosoꞌno oso ango kakwoꞌyohwo sohumo ole ulinyo, Hwe Engo sohwo kako hungkuno ole lehwajohoho. Ngkoꞌne ango nje inomokomoyo sohwanji Sɨkuno Engo iyoho humayo somo wopayoso ntɨpo wonantaneto. Ose lehwajohoho. ");
INSERT INTO apz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ose ulohosɨsoꞌno kako ango tokilonjwaꞌmo molinyo yokintahoponjo somo wosetɨhwamontonoho. Ango somo epohumayo ijempoho yoꞌmayoso hiꞌnjomnoho. Osopo wopayo nakuneꞌno itoꞌno fesyohumunyo. Ose ulonto uhwantɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Uhwatɨmentisoso siko nowenji antɨme engo sopo iꞌmofaponji yoꞌmayo Jisas ulɨmentiso hopaso tɨpemaꞌmentisiyefoho. Notɨpemanji siko wosopayo itoꞌno yahumentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sɨkunoꞌnji Jisas kakoe inomokomoyo nomꞌne sohwanji iꞌmofapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hofɨko epohumayopo wopayo nopemoꞌnowentɨfi nonontanɨngkofi Jisas ulɨmento, Hungkuno nehopi waselɨmonneꞌno yohono. Hwe fihwo nakwoꞌnji wopayo nalokuhwone sohwo kako mango sohwafe ahomo wohoꞌnanɨhumonte hweho. ");
INSERT INTO apz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ose ulahonɨngki hofɨko sɨmeho tango uyɨmentisofoho. Hwe angaꞌno angaꞌnohino sohwa Jisasɨmo ulɨmentohofi, Nakwolaho. Nakwolaho. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ose ulahonɨngkofi Jisas ulɨmento, Nje inomokomoyo sohwasi hwe angaꞌno sekwoꞌnjo mtaꞌangohwo ngkoꞌnji wopayo mijomo yomahwe oso hunonoho. ");
INSERT INTO apz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Aꞌamu Anɨtuye hungkuno lutɨhwamotofo sohwa iyoswomo mtɨꞌmokumentohofo paꞌnyoso Aꞌamufe Hwomu sohwo poyo umoꞌnɨmontonoho. I osoꞌno oso hwe ngkineꞌno nje mango sohwamo tokoyoꞌofo ntohofone sohuneꞌno hitoho ntokwoho. Tohino engoso nomane hweho. Konaꞌwohi aswo momasoꞌnjo yontentesi wopɨngoꞌnesohilo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hofɨko nontanɨngkofi Jisas wopayo nomanto Anɨtumo isamoyoka ulonto kutɨkujo lohofonto hofɨkimo uyonto ulɨmento, Sekwo mapmno. Olo wosopayo loso nje aꞌapahofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ose ulonto kako noswanyo ipisayo mijoꞌnjoso nomanto Anɨtumo isamoyoka ulonto inomokomoyo sohwamo uyahonɨngki hofɨko mijo nɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jisas ulɨmento, Oloso nje honɨyofoho. Aꞌamukuneꞌno usɨhumahono. Olo honɨyoso ngko Anɨtuꞌnji sekwoꞌnji makotɨkuꞌnyoꞌne usɨhumahono. Nje honɨyo losomo Anɨtu uhwonɨngkuhwosi sekwo Anɨtuꞌnji makotɨkuꞌnyoso ne imoꞌnyoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Upaꞌnɨmno. Hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Nomꞌne sɨkuno somo olo ipisayo mijo apaꞌno manɨmnehono. Manyoꞌnjo uyɨmnoho. Oꞌo Anɨtu yokumpohnꞌnyo mokosyohumaso sopo ipisayo mijo songo nɨmnefoho. ");
INSERT INTO apz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ose ulohonɨngki hofɨko ta angaꞌno lontɨfi noswapontɨfi hwofɨkiꞌnyo Oulifɨneꞌno kotasɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas ulɨmento, Sekwo ngkimo nɨhwajɨkuji hiyaso wohumpeentɨfeho. Anɨtuye hungkuno mtɨꞌmokumentohofo sohwa ole mtɨꞌmokumentohofi, Aꞌamu yahu sipsip mokosyohumayo sohumo fonjasyɨkujoꞌno yahu sohwa hiyaso wohumpeentɨfeho. ");
INSERT INTO apz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","I osoꞌno songo lɨkahmꞌmo Ngkalilineꞌno sɨmoꞌmo sepoꞌmnefoho. ");
INSERT INTO apz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ose ulahonɨngki Pita ulɨmento, Nomꞌne hopiꞌnonohino sohwa hofɨko ko kuhwotɨꞌmopijoso ngko mokuhwotɨꞌmoꞌmnehono. ");
INSERT INTO apz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ose ulahonɨngki Jisas ulɨmento, Ngko hungkuno nehopi wakilɨmonneꞌno yohono. Olo sɨkwoꞌmiyo lomo yɨhufo tosɨka yoka hufaꞌu malontanɨngkuhwosi kɨko ngkineꞌno hwasyo hungkuno hufaꞌu sɨhune ole ulɨmonnoho. Ngko Jisasɨmneꞌno huno maniyohoyohoho. Ose ulohojoꞌno yɨhufo sohwo yoka walɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ose ulahonɨngki Pita nɨhuꞌno yokumpohnꞌnyo ulɨmento, Awonoho. Oseꞌmaho. Ngko kikimneꞌno huno maniyohoyohoho eso mulɨmnehono. Oꞌo ngko kɨkoꞌnji fonjanɨsiyo soꞌmanji oso hungkunoso mulɨmnehono. Ose ulahonɨngki inomokomoyo hopiꞌnonohino sohwa Jisasɨmo osenohino mjulɨmɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hofɨko Ngketɨsemani iyo uyo syoho sopono umentohofofoho. Osopo nohumanto kakoe inomokomoyo sohwamo ulɨmento, Olopo fosyohumamno. Ngko nuꞌmo Mpohumo jomo ulɨmo. ");
INSERT INTO apz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ose ulonto, kako Pita, Jemɨs, Jounꞌnji nutɨmanto weꞌenepi nowentɨfi Jisas sɨmeho tango mɨkunɨmoposo umentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Osoꞌno Jisas ulɨmento, Nje sɨmeho tango mokunɨmposoꞌnjo hwoꞌnyoho. Tango hiloso poyo wanɨmokumtolɨkeno. Olopo sekwo itoꞌno fosyohumafɨkuji nohontohumamno. ");
INSERT INTO apz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ose ulonto weꞌenehwo nowento hwahopo ipitofawento kako Anɨtumo oso tohino hiso iꞌmofapososo uyakolofoꞌne jomo ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ole ulɨmento, Mpohwo, kɨko yoꞌmayo hopiꞌnono ihnnehino. Olo tango nɨꞌmasoso wae feenɨmofo. I osoꞌno nje nɨmoꞌnyo somo inɨngkahutoho. Oꞌo jɨje kumoꞌnyo somo tɨfi finɨngkayo. ");
INSERT INTO apz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ose ulonto nolɨkokwaponto inomokomoyo sohwa uhumojohamentiso sopo saho fosyowentanɨngkofi uꞌmanto Pitamo ulɨmento, Saimoun, saho pehoꞌno fosyawotnno. Kɨko weꞌenehwo monohontohumayoꞌnjotaho. ");
INSERT INTO apz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Seten sekumo yamofo selohofonoho. Sekwo ngkineꞌno nohontohumafɨkuji sekwo yamofo neꞌmasoso yahino wonyo somo nopɨwesyanoho lɨkuji Mpohumo jomo ulɨmno. Sekwo wopɨngoꞌnohini uyano ko lɨfijoso sekwoe yokumpohnꞌnyo hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ose ulonto, weꞌenepo nowento hungkuno Anɨtumo nto ulɨmentisoso apaꞌno ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ose ulonto asomo ponto uhwonɨmentisoso inomokomoyo sohwa tɨmosaho engo unɨngkahonɨngki saho fosyowentanɨngkofi uꞌmahonɨngki hofɨko wonɨmangoꞌno yontɨfi nakwo pehofo ulanehwono lontɨfi imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jisas Mpohumo apaꞌno jomo ulonto asomo noponto ulɨmento, Sekwo saho neꞌno lofosyawotofo. Ntaꞌnoho. Nje sɨkuno moiꞌwonoho. Ihwoni, Aꞌamufe Hwomu sohumneꞌno aꞌamu wonyo sohwamo tokoyoꞌofo nto imasofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sekwo filɨkapmno. Wohwano. Uhwonɨmno. Oso hwe ngkineꞌno tokoyoꞌofo ntohoꞌmaso sohwo nto pohoho. ");
INSERT INTO apz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ose lontanɨngki Jutas Jisasɨye inomokomoyo aho hufaꞌu hopinono sɨfe mtaꞌni hufaꞌu sohwo komoꞌno iꞌmofapmmentisofoho. Aꞌamu yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji aꞌamu Isɨlaelɨfe hwe engo sohwanji aꞌamu piꞌnɨngo engo itokusoꞌnjo hosɨmnoꞌnjo sohwamo lutɨmahonɨngkofi Jutas kako Jisasɨyepono ipemotasɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jutas oso aꞌamu sohwamo yamofo itɨhwayoꞌne ole ulɨmento, Hwe sohumo nuꞌmahmꞌmo hinjoho huꞌnɨmeso oso hwe huhwo sohwo Jisasɨyoho. Osohumo sekwo aho kekuji fɨpemotawomno. Ose nto ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Oseso Jutas Jisasɨmo uꞌmanto ulɨmento, Nje Lontɨhwayohwo, ulonto hinjoho huꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aꞌamu sohwa ose uhwonontɨfi Jisasɨmo aho yokumpohnꞌnyo koꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jisasɨye inomokomoyo fihwo kakoe hwakuhwajo iwasɨpento kako oso tajo ango syohoꞌnjo sohwafe hwe yofe engoꞌnjo sohwo kakoe syoho ulohofiyo sohwoe halohomo lokuꞌmentisofoho. Lojwahonɨngki halohoso pɨwahuꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jisas ulohonɨmento, Sekwo aꞌamu hufo iwoꞌnɨngkiso sohuneꞌno aho wokano lontɨfi hwakuhwajoꞌnji itokusoꞌnji lomotopalokwofo. ");
INSERT INTO apz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sɨkuno engolopohamo ngko sekwoꞌnji Anɨtuye tajo ango engo somo Anɨtuye hungkuno lutɨhwahonɨngko sekwo osopo manɨkosoꞌnjo iwoꞌnɨngkohofɨhwasoho. I osoꞌno hungkuno hohonta mtɨꞌmokumentohofoso olohonta nehopi imoꞌnalofoho. Osoꞌno olo hiloso ntohofohofo. ");
INSERT INTO apz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Inomokomoyo hopiꞌnonohino sohwa Jisasɨmo ulɨkoꞌmantɨfi hiyaso humpoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hwomu fihwo kako hwapɨfeꞌnohini inyohwo Jisasɨmo tɨfi inɨngkowahonɨngki aꞌamu sohwa hwomu sohumo aho wokano lontɨfi imentohofoso ");
INSERT INTO apz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","hwomu sohwoe hwapɨfe mokoloswomaꞌmentohofoso aꞌapahoꞌnohino leꞌmaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hofɨko Jisasɨmo aꞌamu tajo ango syohoꞌnjo sohwafe hwe yofe engoꞌnjo hwe engo sohwoe pone Anɨtumneꞌno jomo lɨmojo sohwoepono ipemotapontɨfi angopo uꞌmofopahonɨngkofi aꞌamu tajo ango syohoꞌnjo yofe engoꞌnjo sohwanji, aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji hofɨko kaunɨsol syoho soꞌno uhuꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita Jisasɨmo ko inɨngkawomentisoso kakimo mufantohiꞌnyofoho. Oꞌo, kako poꞌmtopoꞌmtisyo humulohoꞌmɨwesofoho. Kako hwe engo tajo ango syohoꞌnjo mokosyohumayo sohwafe angkuhwafopo iꞌmofawento osopo aꞌamu uhwontohumayo syohoꞌnjo sohwanji toho imokinɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pita nohumentanɨngki angomno aꞌamu tajo ango syohoꞌnjo yofe engoꞌnjo sohwanji aꞌamu kaunɨsol syohoꞌnjo hopiꞌnonohino sohwanji Jisasɨmneꞌno hungkuno tangoꞌnjo poyo imoꞌnyoꞌne wotɨpeentɨfi ko imentohofoso ");
INSERT INTO apz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","aꞌamu piꞌnɨngo Jisas yoꞌmayo imentiso soꞌno hwasyo hwasyo lontɨfi hofɨkoe hungkunoso kengo kengo lɨmentohofofoho. Aꞌamu hufaꞌu hungkuno afa majofoho. Aꞌamu fihwa nolɨkafontɨfi hwasyo hungkuno ulɨmentohofi, ");
INSERT INTO apz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Olo hungkunoso upaꞌnɨmalohwonefoho. ");
INSERT INTO apz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Jisas ole lɨmasofoho. Anɨtuye tajo ango engoso aꞌamu ahoꞌnji molɨmentohofo somo ngko wae weeoꞌmnoho. Sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno nomꞌne ango engo wamolɨmonnoho. Ahoꞌnji wamolɨmontɨꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ose lontɨfi, Hwasyo hungkuno piꞌnɨngo lokwoposɨwatɨꞌmentohofoso ne mmoꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Osoꞌno hofɨko Jisasɨye hungkuno tangoꞌnjo soꞌno wonyopi tɨpeehonɨngkofi hwe yofe engoꞌnjo tajo ango syohoꞌnjo sohwo ajwopo nolɨkofalohofonto, Jisasɨmo ulɨmento, Kɨko hungkuno asomo mujoꞌnjo pehoꞌno yalokuno. Pipilo. Olo hungkuno kikimo kilalokwofo losofo. ");
INSERT INTO apz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ose ulahonɨngki Jisas hungkuno majofoho. Mampiꞌnyo humamentisofoho. Hwe yofe engoꞌnjo sohwo apaꞌno ulohonɨmento, Anɨtu nakwo aꞌamu Juta hnꞌnɨmo nefoꞌmayoꞌne lokuhwatɨmentiso hwosilaho. Anɨtu nakwo kakoe yofe hoꞌnomawoꞌnɨngkuhwone sohwoe Hwomu Ne hwosilaho. Awolaho. ");
INSERT INTO apz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ose ulahonɨngki Jisas ulɨmento, Ou, osoho hwoꞌnyoho. Sekwo Aꞌamufe Hwomu sohwo Anɨtu Yoꞌmayo Yokumpohnꞌnyo Hwapɨngo sohwoe aho anga sohohntaꞌni humentanɨngkuhwosi uhwonɨfitnnefoho. Kako himo ahwomo mtaꞌango sopo pontanɨngkuhwosi uhwonɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jisas ose ulahonɨngki oso hwe tajo ango syohoꞌnjo sohwa sɨmano hintotohino umnɨmentiso soꞌno kakoe hwapɨfe manjiꞌmofo weꞌenehwo sɨsɨmpento ulɨmento, Nakwo nomꞌne aꞌamu Jisasɨmneꞌno hungkuno joꞌneso joho pehoꞌno ulanehwono. ");
INSERT INTO apz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Oꞌo sekwo kakoe hungkuno somo nto upaꞌnɨngkohofo. Kakimo pipi ulohofanehwono. Sekwo huno pipi seyohoho. Ose ulahonɨngki hofɨko ulɨmentohofi, Hwe wonyo imaso hweho. Kako poyo umoꞌnono. ");
INSERT INTO apz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ose lontɨfi aꞌamu fehohnjo sohwa Jisasɨmo memijo uyatɨꞌmofontɨfi Jisasɨmo ikujoho fonjontɨfi ulɨmentohofi, Tɨhwo kufonjohoho. Yofeso fonaso. Ose ulahonɨngkofi aꞌamu mekinoꞌnjo sohwa Jisasɨye sɨmoꞌmango sopo aho pehusɨꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nofonjontanɨngkofi Pita angkuhwafopo nohumentanɨngki aꞌmusi hwe yofe engoꞌnjo tajo ango syohoꞌnjo mokosyohumayo sohwoe syoho ulohofiyosi uꞌmanto, ");
INSERT INTO apz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita toho imokinontanɨngki uhwononto ulɨmento, Kɨko Jisas Nasalet ntaꞌango sohwonji emoimotnno hwosoho. ");
INSERT INTO apz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ose ulahonɨngki Pita ulɨmento, Hwasyo lohino, Oso hwe sohuneꞌno ngko huno maniyohoyohoho. Ose ulonto nolɨkafonto kusopo koꞌmoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Osopo nohumentanɨngki aꞌmusi apaꞌno Pitamo uhwononto aꞌamu mofoponjo sohwamo ulɨmento, Oso hwe nongkwo sohwo Jisasɨmo tɨfi inomokomoyɨwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ose ulahonɨngki Pita apaꞌno awonoho ulɨmentisofoho. Hwangku weꞌe nehwo aꞌamu mofopo humalohofontohofo sohwa Pitamo apaꞌno ulɨmentohofi, Nehopeho. Kɨko hofɨkoꞌnji emoimotnno hwosoho. Kɨko Ngkalilintaꞌango hwosoho. ");
INSERT INTO apz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ose ulahonɨngkofi Pita hungkuno yokumpohnꞌnyo ulɨmento, Ngko hwasyo hungkuno selɨmeso Anɨtu tohino wontapono. Oso hwe sekwo ntohofo sohwo ngko yofe mɨhwofeꞌnjo hweho. Nehopi lohono. ");
INSERT INTO apz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ose ulahonɨngki komoꞌno tosɨka yoka apaꞌno lɨmentisofoho. Pita nupaꞌnonto Jisas hungkuno ulɨmentiso soꞌno huno syafɨhuꞌmentisofoho. Jisas ose nto ulɨmentisofoho. Yɨhufo tosɨkaso yoka hufaꞌu lososo sohonta Pita kɨko ngkineꞌno mango hufaꞌu sɨhune ole walɨmonnoho. Ngko Jisasɨmneꞌno huno maniyohoyohoho. Oso hungkuno Jisas ulɨmentiso soꞌno Pita syafɨsyonto humotaho engo lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Imɨngo neꞌnji aꞌamu tajo ango syohoꞌnjo yofe engoꞌnjo sohwanji aꞌamu Jutafe hwe engo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji kaunɨsol aꞌamu hopiꞌnono nuhuꞌmokontɨfi Jisasɨmneꞌno hnnɨmentohofofoho. Nohnnontɨfi Jisasɨmo aho kentɨfi ahwomo nano kilofontɨfi Pailot hwe yofe engoꞌnjo hwaho mokosyohumayo sohwoepono Jisasɨmo ipemotapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ipemotopahonɨngkofi Pailot Jisasɨmo ulohonɨmento, Kɨko aꞌamu Jutafe hwe engo hwosilaho. Ose ulahonɨngki Jisas ulɨmento. Hungkuno hiso kɨko nehopi lohino. ");
INSERT INTO apz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Aꞌamu tajo ango syohoꞌnjo yofe engoꞌnjo sohwa Pailotɨmo hwasyo hungkuno Jisasɨmneꞌno mjalɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailot Jisasɨmo apaꞌno ulohonɨmento, Oso hungkuno piꞌnɨngo kikineꞌno mjakilɨmɨhwofo upaꞌnɨngkinoso kɨko aku hungkuno pehofo ulɨmto. ");
INSERT INTO apz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ose ulahonɨngki Jisas nomꞌne hungkuno mujoꞌnjo yahonɨngki Pailot yomo yonto huno piꞌnɨngo syafɨhuꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Soswo huhwo huhwi oso sɨkuno iyoho humayo engo somo Pailot kako hwe fihumo impoꞌango mtaꞌangohwo nɨhuꞌnahone isɨhutofɨhwatɨmojofoho. Aꞌamu Jutaso hofɨko hwe fihwoe yofe ulahonɨngkofi Pailot hofɨkoe hungkunomo tɨfi inɨngkamojofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Oso hohosohonta hwe fihwa yokumpohnꞌnyo sohwa hofɨko hofɨkoe hwe engo aꞌamumo mokosyohumayoꞌnjo sohwamo ikujoho nofonjontɨfi aꞌamu fehohnjo somo fonjosyahonɨngkofi impoꞌangomo intofahumentohofofoho. Oso hwe huhwo sohwo impoꞌangomo humamentiso sohwo angaꞌno hwe kakoe yofe Mpolapas. ");
INSERT INTO apz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Hwe moyaꞌmi piꞌnɨngo engo uhuꞌmokontɨfi Pailotɨmo uꞌmantɨfi ulɨmentohofi, Olo Sɨkuno Engo lomo kɨko hwe angaꞌno impoꞌango mtaꞌni usɨhutofɨhwatɨmonntaho. Oso yahinoso apaꞌno fiyo. ");
INSERT INTO apz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Osoꞌno Pailot kako hwe moyaꞌmi hopiꞌnonohino somo ulɨmento, Olo hwe lohwo yofe engoꞌnjo semokosyohumayoꞌne sohumo ngko usɨhutofono lasenɨngkohoho. Pailot kako huno moiꞌwonoho. Aꞌamu piꞌnɨngo engo Jisasɨmo isɨhutofɨhwajiyoꞌne ulɨmentohofo soꞌno aꞌamu tajo ango syohoꞌnjo sohwa Jisas neꞌno sɨmano hintotohino umnɨngkahonɨngki Jisasɨmo aho koꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ose ulahonɨngki aꞌamu tajo ango syohoꞌnjo sohwa hofɨko aꞌamu ajwo sopo lohofontɨfi aꞌamufe sɨmehomo ulɨkofantɨfi ulɨmentohofi, Mpolapasɨneꞌno ulɨmno. Jisas nakwolaho. Mpolapas usɨhutofo. Ose ulɨmno. ");
INSERT INTO apz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ose ulahonɨngkofi Pailot apaꞌno ulohonɨmento, Olo hwe yofe engoꞌnjo semokosyohumayoꞌne lohumo ngko pipi ulohoꞌmnehono. ");
INSERT INTO apz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ose ulahonɨngki aꞌamu hopiꞌnono joho lɨmentohofi, Iyomo fonjintoꞌofahumno. ");
INSERT INTO apz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ose ulahonɨngkofi Pailot ulohonɨmento, Pehoꞌneto. Olo hwe lohwo peho wonyo imaso hwolo. Ose ulahonɨngkofi aꞌamu joho mohmꞌno lɨwoꞌnɨmentohofi, Iyomo fonjintoꞌofahumno. ");
INSERT INTO apz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ose ulahonɨngkofi Pailot hofɨkoe sɨmeho wopɨngo umoꞌnono lonto Mpolapasɨmo isɨhutofɨhwajonto, kakoe hwe itokusoꞌnjo sohwamo ulɨmento, Jisasɨmo impeꞌnji fonjɨkuji iyopo fonjintoꞌofahumno. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aꞌamu huhwo sohwa Jisasɨmo aꞌamu mokosyohumayo sohwoe tojo somo ipemotaswontɨfi nomꞌne hwe itokusoꞌnjo hopiꞌnonohino sohwamneꞌno joho lutɨmantɨfi uhwonɨmno ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nuhuꞌmokontɨfi manjiꞌmofo miyoꞌnohino soꞌnji Jisasɨye sangopo hoꞌnasyontɨfi impe yongoꞌnjoso nokikisontɨfi Jisasɨye mnokinopo monjiꞌmofahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ose imentohofoso, Jisasɨmo atɨfe itɨhwantɨfi sitofo ulɨmentohofi, Ou hwe engo sohwosi kɨko aꞌamu Juta somo mokosyohumawoꞌnɨngkino sohwosilaho. ");
INSERT INTO apz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ose ulontɨfi nomꞌnehwa foꞌmeꞌnji mnokinopo hwanɨngo fonjontɨfi memijo sɨmanopo yatuꞌmo lohofontɨfi Jisasɨye yofe hoꞌnomayoꞌno hwomtame poji ulohoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hofɨko sitofo moiꞌwo ulontɨfi manjiꞌmofo miyoꞌnohinoso yojasyontɨfi kakoe manjiꞌmofo ulohoꞌmentohofofoho. Ose yontɨfi kakimo mempo hohontaꞌni iyomo fonjintoꞌofasiyoꞌne sopono ipemotasɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nosontɨfi hwe nomꞌnehumo uswoꞌnɨmentohofofoho. Oso hwe huhwo sohwoe yofe Saimoun, Sailinintaꞌango hweho. Alekɨsantaꞌnji Lufosɨyo kanɨngkwohweho. Saimoun kako syoho mtaꞌango sohwo Jelusalemmneꞌno wasɨmo lonto ko yahonɨngki hwe itokusoꞌnjo sohwa yokumpohnꞌnyo ulɨmentohofi, Jisasɨye iyo hwojiyafujiyo mokahoꞌnyo. ");
INSERT INTO apz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ose ulontɨfi Jisasɨmo hwofɨkiꞌnyo weꞌe Ngkoulɨkota sopo ipemotasɨmentohofofoho. Oso yofe Ngkoulɨkota hwapɨngo olenoho. Aꞌmomnokino yokino huyoꞌmango paꞌnyoponoho. ");
INSERT INTO apz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Osopo sɨꞌmofontɨfi tohino umnonoho lontɨfi hofɨko ipisayo mijo iyohoꞌnjo Jisasɨmo uyahonɨngkofi kako nɨmentisoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Manyoꞌnjo yohonɨngki hofɨko Jisasɨmo iyomo fonjintoꞌofahumentohofofoho. Nofonjintoꞌofosyantɨfi hofɨko syohiꞌnyo yontɨfi Jisasɨye manjiꞌmofo yoꞌmayo soꞌno tɨhwo womaꞌmtolɨkeno lontɨfi yamofo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mofehiꞌnyo imɨngoꞌnji (9 kɨlouk) Jisasɨmo iyopo fonjintoꞌofahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jisas kako poyo imoꞌnyo soꞌno iyoswomo mtɨꞌmokumentohofi, AꞌAMU JUTAFE HWE ENGO HWEHO. Oso iyoswo hiso Jisasɨye iyo mnokino sopo hofojahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hwe hufaꞌu ikujohoꞌnji hufoꞌnji imojiyo sohwaꞌumo fonjintoꞌofahumentohofofoho. Hwe nomꞌnihwo Jisasɨye aho angahohntaꞌni, hwe nomꞌnihwo Jisasɨye aho hwonamonyo hohntaꞌni fonjintoꞌofahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hohonta hungkuno mtɨꞌmokumentohofoso oso sɨkuno somo ne imoꞌnɨmentisoso ole, Kako aꞌamu wonyoꞌnjopo nohumentanɨngki aꞌamu huhwo wonyo hweho lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hwe moyaꞌmiso nopohotawentɨfi mnokɨngkwaꞌnɨngkwaꞌnnyo yontɨfi sitofo ulɨmentohofi, Kɨko ole lɨwoꞌnɨngkini, Anɨtuye tajo ango engoso ngko wae yaohmꞌmo apaꞌno songo molɨmeso sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno ango moiꞌwo umoꞌnɨmontonoho. Ose ulontɨfi tɨkafo jɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kɨko foꞌmaꞌnyo. Ose ulontɨfi ulɨmentohofo, Iyopo ntaꞌni fɨkotape. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aꞌamu tajo ango syohoꞌnjo yofe engoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji hofɨko aꞌamu ajwo somo lohofontɨfi Jisasɨmo sitofo mohmꞌno hnnɨmentohofi, Kako aꞌamu nomꞌnemo ufoꞌmawoꞌnɨngkiso sohwo kakimo mufoꞌmaꞌnonehoho. ");
INSERT INTO apz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kako Kɨlais Anɨtu uhwatɨmentiso hweho. Aꞌamu Isɨlaelɨfe yofe engoꞌnjo mokosyohumayoꞌne hweho. Osoꞌno kako iyopo ntaꞌni kotapɨhwosoꞌno uhwonɨngkuhwasi nakwo sɨmeho hiꞌntnnono uyantanoho. Ose lontɨfi tɨkafo jɨmentohofofoho. Oso hwe wonyo Jisasɨꞌnjopo fonjintoꞌofahumentohofo huhwaꞌuꞌntnneꞌno Jisasɨmo sitofo ulɨmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hinjo ajwo kuntoliyopo sɨkuno mjaofonto mofehiꞌnyomo hoholo yasyonto akupoꞌnyoꞌnji (3 kɨlouk) osoꞌnji apaꞌno longkonɨngkahonɨngki mofehiꞌnyo lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sɨkuno moiꞌwo imoꞌnɨngkahonɨngki Jisas joho mohmꞌno lɨmento, Eloui, Eloui, lama sapakɨtani. Oso hungkuno iwoloꞌmo ole, Nje Anɨtu, nje Anɨtu, pehoꞌno nɨsɨkwojantokuno. ");
INSERT INTO apz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ose lahonɨngki aꞌamu kakoꞌnjopo humamentohofoso upaꞌnontɨfi huno muyahonɨngki lɨmentohofi, Upaꞌnɨmno. Olo hwe lohwo kako Ilaija osohumo Anɨtu hungkuno uyahonɨngki lɨmojo sohumneꞌno joho lalofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hwe fihwo komoꞌno nowento hwapɨfe weꞌe mijo mangkinyoꞌnjo yomanto oso hiso tokemo yamjonto Jisas wanononto nuyonto ulɨmento, Hofahiyo. Nakwo uhwontohumano. Ilaija nopɨhwosi iyo mtaꞌni ufoꞌmaꞌmtolɨkeno. ");
INSERT INTO apz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ose ulahonɨngki Jisas joho mohmꞌno lonto poyo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Poyo imoꞌnɨngkahonɨngki hohosohonta Anɨtuye tajo ango engo somjo hwapɨfe engo oso ajwopo ango weꞌe Anɨtu humayoꞌnefoho lɨmotofo sopo hokuꞌyopo pmpilɨpeehinyoso yokintahopo ntaꞌni tomonte sɨsɨmpo lohofonto hufaꞌu imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aꞌamu itokusoꞌnjo sohwafe hwe engo sohwo Jisasɨye sɨmanopo lohofonto, Jisas poyo imoꞌnɨngkahonɨngki uhwononto ulɨmento, Olo hwe lohwo Anɨtuye Hwomu Ne hweho. ");
INSERT INTO apz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Moyaꞌmi sofa ikano nonje sopo lohofontɨfi Jisasɨmo tɨmo humuhwontohumantohofofoho. Moyaꞌmi fifa yofe ole, Maliya Makɨtola ntaꞌangiyoho. Aꞌmu nomꞌnesi kakoe yofe Maliya Jemɨs hwe songo sohwoꞌnji Jousepɨꞌnjiye konaꞌwohiyoho. Aꞌmu nomꞌnesi Saloumiyoho. ");
INSERT INTO apz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Oso fanji nomꞌne moyaꞌmi sofa Jisas hwaho Ngkalili emoimojo sohonta hofɨko tɨfi inɨngkawentɨfi ufoꞌmaꞌmentohofofoho. Oso moyaꞌmi sofa Jisasɨꞌnji Jelusalemneꞌno pmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Oso sɨkuno Fɨlaite somo mofehiꞌnyo ukwoꞌmokumto iyosoꞌnji Jousep ango Alimateyantaꞌango sohwo iꞌmofapmmentisofoho. Kako kaunɨsol syohoꞌnjo hweho. Kako hwe wopɨngo hweho. Aꞌamu hopiꞌnono kakoe yofe hoꞌnomaꞌmotofofoho. Kako oso hwe Anɨtu uhwatɨmo lɨmentiso sohwe pe-eꞌne sɨkuno soꞌno hontohumamojo hweho. Kako sɨkuno iyoho humayoꞌne yoꞌmayo itoꞌno esyohumayo soꞌno syafɨsyonto kako iyoho weꞌe ko unɨngkahonɨngki yokumpohnꞌnyo imoꞌnonto Pailotɨmo uꞌmanto Jisasɨye pijafo mayoꞌne ulohonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ose ulohonɨmentisoso Pailot yomo yonto syafɨhuꞌmento nto kapeꞌnɨngkohoho. Ose syafɨsyonto hwe engo itokusoꞌnjo sohumo joho lutɨmanto ulɨmento, Jisas poyo nto limoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ose ulahonɨngki eno ulahonɨngki Pailot Jousepɨmo ulɨmento, Eꞌwano. Pijafoso maho. ");
INSERT INTO apz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ose ulahonɨngki Jousep hwapɨfe halojo wonyoangkafo mpe yonto Jisasɨye pijafoso iyo mtaꞌni nomanto hwapɨfe somo ifohumpento sokimomo hoꞌnahumentisofoho. Oso sokimoso kako sojo engo somo imo engo ilɨꞌmentisofoho. Osopo hoꞌnasyonto sojo engo yɨwoloꞌmo lohofonto sokimo hokuꞌyo somo pɨjwahumentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya ango Makɨtolantaꞌangosiꞌnji Maliya Jousisɨye konaꞌwohiꞌnji siko Jisas hoꞌnahumentohofo sopo uhwonɨmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sɨkuno iyoho humayoꞌneso nto memjaofahonɨngki Maliya ango Makɨtola ntaꞌangosi, Maliya Jemɨsɨye konaꞌwohisiꞌnji Saloumiꞌnji hofɨko hwone mijo akinoꞌnjo Jisasɨye pijafomo ehulohofoꞌne mpe imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Moꞌnɨngka Sante imɨngoꞌnji iyoho longkonɨngkahonɨngki hofɨko nolɨkafontɨfi Jisasɨmo hoꞌnahumentohofo sopo umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nowentɨfi hnnɨmentohofi, Oso sojo mɨkunɨmposo hofɨkuꞌyopo pɨjwahumalofoso tɨhwo womehoꞌnonaofimontolo. ");
INSERT INTO apz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ose hnnontɨfi uhwonɨmentohofoso sojo mɨkunɨmpososo nto mehoꞌnaꞌmentohofo uhwonɨmentohofofoho. Nto hwosompeehumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Oseso sokimo somo noswontɨfi uhwonɨmentohofoso hwe songo hwapɨfe halojo sawemoꞌnjo sohwo moyaꞌmi sofafe aho angahohntaꞌni nohumentanɨngki uhwonontɨfi hofɨko yomo yomo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Oso hwe huhwo sohwo ulɨmento, Sekwo yomo ikutoho. Ngko huno niyohoho. Sekwo Jisas Nasaletnntaꞌango aꞌamu fonjintoꞌofohumalofo sohuneꞌno tɨpeelokwofo. Kako nto likakwoho. Olopo mohumuyoho. Uhwonɨmno. Nohoꞌnohumalofo sopo aneponoho. ");
INSERT INTO apz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Oseso sekwo nowekuji Pitaꞌnji inomokomoyo nomꞌne sohwamo ulɨmno. Jisas Ngkalilineꞌno sɨmoꞌmo nto sepoꞌmaho. Ose ulɨmno. ");
INSERT INTO apz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ose ulahonɨngki noswapontɨfi yomo yomo yontɨfi komoꞌno umentohofoso iyoho unɨmentiso soꞌno aꞌamu nomꞌnemo yoꞌmayo uhwonɨmentohofo soꞌno mulɨmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Santemo iyohohweꞌnji Jisas lɨkofahonɨngki Maliya ango Makɨtolantaꞌangosi Jisasɨmo kakiꞌno uhwonɨmentisofoho. Oso hisimo Jisas hohonta towahuno wonyo aho angaꞌno hopiꞌnono nomꞌne hntaꞌni hufaꞌu sohwa wae yaoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliya nowento aꞌamu Jisasɨꞌnji emmotofo sohwamo uꞌmanto hofɨko sɨmeho tangoꞌnji humotaho lontanɨngkofi, ");
INSERT INTO apz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maliya ulɨmento, Jisas songo humaho. Nuhwonɨngokohiꞌnyoho. Ose ulahonɨngki nupaꞌnontɨfi huno syafɨhuꞌmentohofi, Hwasyo nalohoho syafɨsyontɨfi aꞌmu hisiye hungkunomo sɨmeho hiꞌntnnono muyofoho. ");
INSERT INTO apz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hwangku hwe hufaꞌu hwaꞌu ango Jelusalem ulɨkoꞌmanji honɨngkanopo nowentanɨngki Jisas aꞌamu nomꞌne paꞌnɨngohwo uꞌmahonɨngki ");
INSERT INTO apz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","siko yofe uhwoꞌmentisiyo soꞌno asomo noponji inomokomoyo nomꞌne sohwamo ulahonɨngki hofɨko haloho miyoꞌnjo yontɨfi sɨmeho hiꞌntnnono muyofoho. ");
INSERT INTO apz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hwangku inomokomoyo aho hopiꞌnono sɨfe mtaꞌni angaꞌno sohwa angomo nohumantɨfi wopayo nontanɨngkofi Jisas nuꞌmanto yoka ulɨmentisofoho. Hwapɨngoso ole hofɨko sɨmeho hiꞌntnnono muyoꞌnefoho. Aꞌamu nomꞌne sohwa inomokomoyo sohwamo Jisas nto lɨkaꞌmaho. Nakwo uhwonɨngkuhwono ulahonɨngkofi hofɨko hwasyo hungkunofoho huno syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jisas ulɨmento, Sekwo angoꞌmeemo humpekuji aꞌamu hopiꞌnonohino somo nje hungkuno wopɨngoso filutɨhwafɨkuno. ");
INSERT INTO apz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aꞌamu oso hungkuno hiso nupaꞌnɨngkuji sɨmeho hiꞌntnnono sejapɨkuji mijo mapijoso Anɨtuye aꞌamu ne imoꞌnɨfitnnefoho. Aꞌamu oso hungkuno somo sɨmeho hiꞌntnnono muyoꞌnjo somo Anɨtu hofɨkoe honɨngkano wonyoꞌne hungkuno tango uyonefoho. ");
INSERT INTO apz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aꞌamu ngkimo sɨmeho hiꞌntnnono ntapifijoso ole ifitnnefoho. Nje yokumpohnꞌnyoꞌnji towahuno wonyo wae ifitnnefoho. Aꞌamu kengofe hungkunoso lɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hofɨko homa aho kapijoso mijo peꞌnyoꞌne nɨfijoso poyo mmoꞌnɨfitnnefoho. Hofɨko aꞌamu mnokinoꞌnjo somo aho kisasyɨkuji ngkimo jomo ntɨkujoꞌno wopɨngo imoꞌnɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Hwe Engo Jisas sohwo hungkuno moiꞌwo nto losojwaofahonɨngki Anɨtu Jisasɨmo utɨmaꞌmentisofoho. Nosonto Anɨtuye aho angahohntaꞌni humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Inomokomoyo sohwa angoꞌmeemo nowentɨfi Anɨtuye hungkuno lutɨhwentanɨngkofi Jisas ufoꞌmaꞌmentisofoho. Nufoꞌmahonɨngki hofɨko yoꞌmayo wonyoangkafo yahonɨngkofi aꞌamu uhwonontɨfi ou, olo hungkunoso Anɨtuye hungkuno nehopeho lɨmentohofofoho. Hungkuno osohopeho. ");
INSERT INTO apz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nje hwe engo Tiyoufilos sohwosi, kɨko nje hungkuno upaꞌnyo. Kɨlais kako olo hwaho lopo humamojo sohonta yoꞌmayo imoꞌnɨmentiso somneꞌno aꞌamu piꞌnɨngo engo sohwa hofɨko nakwo ifalifaliyo womtɨꞌmokano lontɨfi yamofo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jisasɨye inomokomoyo sohwanji nomꞌne aꞌamu soꞌnji hofɨko yoꞌmayo Jisas imentiso sɨmoꞌmtaꞌango somo tɨmo uhwonontɨfi aꞌamu nomꞌne somo ulahonɨngkofi hofɨko mtɨꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","I, ngko huhwoꞌni Jisasɨye mpoyoso kikiyepono wolɨhwatɨmo lonji mtɨꞌmokalokweno. Sɨkuno piꞌnɨngo engo ngko syoho yokumpohnꞌnyo yonji hungkuno hisoꞌno itoꞌno yasiyoꞌne aꞌamu piꞌnɨngo engo somo yoꞌmayo sɨmoꞌmtaꞌango somneꞌno ulohononji hungkuno hwapɨngo neso tɨpemanji hungkuno itoꞌnohini kikineꞌno mtɨꞌmokalokweno. ");
INSERT INTO apz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Oseso yoꞌmayo hungkuno nto lokitɨhwawoꞌnɨngkohofo somneꞌno nehopitɨkeno hwasyotɨkeno syafɨsyohojɨꞌmanji olo hungkuno kikineꞌno kumtɨꞌmokiyalokwe losomo atofo lohoji hungkuno neso wotɨpemaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nje mpoyo lomayoso olenoho. Hwe engo Helout sohwo kako hwaho Jutiya mokosyohumamentiso sohonta hwe fihwo kakoe yofe Sekolaiya sohwo kako nohumanto kako tajo ango syohoꞌnjo hweho. Oso syoho imotofo huhwo sohwa hotitoꞌmentohofoso aꞌamu fehohnjoso Apaija mokosyohumamentisofoho. Sekolaiya hofɨkoꞌnji syoho imojo hweho. Sekolaiyafe ape hiye temtitofo huhwa oso syoho imotofofoho. Kako Mousesɨye kolaꞌwehwo Elounɨye imuyoho. Aꞌmu hisi yofe Elisapetɨyoho. ");
INSERT INTO apz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hisiyaꞌu siko Anɨtuye tɨmo sopo wonyohofiyo humamojiyeyaꞌuyoho. Siko Anɨtuye honɨngkano hungkuno itoꞌnohino somo inɨngkawenji honɨngkano wonyo ane humamojiyeyaꞌuyoho. ");
INSERT INTO apz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Siko mehomi nɨhuꞌno ane yaswoho. Hwapɨngoso Elisapet kako hwonjo ape humanto siko aꞌmane imoꞌnɨmentisiyeyaꞌuyoho. ");
INSERT INTO apz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Sekolaiyafe aꞌamu hotitoꞌmentohofo sohwa hofɨkoe sɨkuno Anɨtuye ango engo somo syoho iyoꞌne iꞌmofopahonɨngki hofɨko aꞌamu uhwosope yahinoso yontɨfi Sekolaiya sohumo Anɨtuye sɨmano sopo lohofoꞌne uhwosopoꞌmentohofofoho. Oseso kako oso ango ajwo soꞌmo Anɨtuye angofoho lɨwoꞌnɨngkohofo sopo noswonto hwamno paꞌnyo akino wopɨngoꞌnjoso Anɨtumneꞌno tɨkayo usɨmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sekolaiya kako oso tɨkayo usɨmokontanɨngki aꞌamu piꞌnɨngo engo sohwa hofɨko mempo hohntaꞌni nohumantɨfi Mpohumo jomo ulɨmentohofofoho. Hofɨkoe yahino ose imotofofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sekolaiya osopo nohumanto uhwonɨmentisoso Anɨtuye aꞌamu ahwomomjo sohwo kako oso epohumayo tɨkayo usɨmokiyo aho anga sohohntaꞌni lohofontanɨngki uhwononto ");
INSERT INTO apz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","yomo engo yonto iyoho unɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","I osoꞌno aꞌamu ahwomomjo sohwo kakimo ulɨmento, Sekolaiya, kɨko iyoho yohotoho. Anɨtu kako jɨje jomo ujo somo nto kupaꞌnɨmaho. Jɨje ape Elisapetɨsi kako hwomu womaꞌmontonoho. Notɨpemahosɨsi kɨko yofe ole muso Jounɨyoho. ");
INSERT INTO apz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Hwomu huhwo sohwo iꞌmofopahonɨngkuhwosi siko sɨmonyo engo uyanjiyoho. I aꞌamu piꞌnɨngo engo hiꞌnji sɨmonyo engo uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Hwomu huhwo sohumo Anɨtu kako yofe engo mulonefoho. Kako yoꞌmayo mijo yokumpohnꞌnyoso nonɨngkuhwoloho. Kako konaꞌwohiye sɨmeho moꞌmo mnawentanɨngkuhwoso sohonta Anɨtuye Towahuno Wopɨngo uhulaꞌofonefoho. ");
INSERT INTO apz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kako Anɨtuye hungkuno aꞌamu Juta somo ulɨhwosoꞌno hofɨko hofɨkoe honɨngkano wonyo somneꞌno hohujo ikinjaofɨkuji hofɨko hofɨkoe Hwe Engo Anɨtu sohumo apaꞌno unɨngkowantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kako oso aꞌamu sohumo Ilaija hohonta Anɨtu hungkuno uyahonɨngki lɨmojo sohwoe yokumpohnꞌnyo paꞌnyo sohwo nohumahwosi kako oso hwe Anɨtu nakwoe hwahopo uhwatɨmonteꞌno yoso sohumneꞌno aꞌamufe honɨngkano itoꞌno esyohumayoꞌne hweho. Kako Anɨtuye hungkuno ulɨhwosoꞌno hwe sohwa upaꞌnɨngkuji hofɨko hofɨkoe mehomi sɨmeho afa apaꞌno wepufisyantɨfeho. Aꞌamu sɨmeho afa minyoꞌnjoso Anɨtuye hungkunomo hwotoho fewoꞌnɨngkohofoso hofɨko aꞌamu honɨngkano wopɨngoꞌnjo sofe huno apaꞌno wotɨpemantɨfeho. Oseso kako Hwe Engo sohumneꞌno aꞌamu itoꞌno wesyohumamontonoho. ");
INSERT INTO apz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aꞌamu ahwomomjo sohwo ose ulahonɨngki Sekolaiya ulɨmento, I, pipineto. Ngko aꞌmane moiꞌwonoho. Nje ape hi aꞌmane moiꞌwonoho. Jɨje hungkuno ne imoꞌnyoso ngko huno pipi wanimontolo. ");
INSERT INTO apz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ose ulahonɨngki aꞌamu ahwomomjo sohwo ulɨmento, Ngko Ngkepɨliyel hwoꞌnyoho. Ngko Anɨtuye sɨmanopo lohofɨwoꞌnɨngkohe hwoꞌnyoho. Olo hungkuno wopɨngoꞌne kilohe losoꞌno Anɨtu kako lonɨhwatɨmasoꞌno pmmale hwoꞌni kuꞌmahono. ");
INSERT INTO apz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","I, kɨko upaꞌnyo. Nje hungkuno hilo somo kɨko sɨmeho hiꞌntnnono mantape soꞌno jɨje mango pɨkuꞌnnyo imoꞌnɨngkohoji kɨko hungkuno majoꞌnjo uyɨmonnoho. Oso hopa nohumentanɨngkohoji yoꞌmayo kiloheso ne umoꞌnɨmontonoho. Yoꞌmayo nje hungkuno kiloheso kakoe sɨkuno somo ne imoꞌnɨngkuhwosoꞌno kɨko hungkuno apaꞌno walɨmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Oso hungkuno hiso hnnontanɨngki aꞌamu mempo hohntaꞌni uhwontohumantɨfi huno piꞌnɨngo engo syafɨsyontɨfi ole hnnɨmentohofi, Peho uꞌmahonɨngki kiyalofoho. Sekolaiya kako Anɨtuꞌnjopo nohumanto kuntoꞌno moswapeꞌnjo yalofoho. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hwangku kako noswaponto kako hungkuno hwe moyaꞌmi somo mujoꞌnjo imentisofoho. Oꞌo kako iloꞌnnyo hopa imoꞌnonto kako kakoe ahoꞌnjiꞌnohini itɨhwahonɨngki uhwonontɨfi ole syafɨhuꞌmentohofi, Sekolaiya kako Anɨtuye ango weꞌe soꞌmo nohumanto yoꞌmayo wonyoangkafoso uhwonɨngkiso hwolɨkeno. Ose syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kakoe syoho iyo soꞌno sɨkuno moiꞌwo imoꞌnɨngkahonɨngki kako kakoe angopono asomo umentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tɨfi sohonta kakoe ape Elisapet sɨmeho ihnꞌnonto kako hiyasoꞌmo humentanɨngki hamno aho fehohnjo hopiꞌnono uyakoloꞌmentisofoho. Ilisapet kako sɨmehoꞌnjo honɨngkanonto ole hnnɨmento, ");
INSERT INTO apz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nje Hwe Engo Anɨtu kako ngkimo wopɨngo ntohokwoho. Ngko mehomi mmoꞌnyo soꞌno wonɨmango nnontanjopo Anɨtu aꞌamufe tɨmopo oso tango hiso wae yanɨmokwoho. Ose hnnonto sɨmonyo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisapet sɨmehoꞌnjosi humentanɨngki hamno aho fehohnjo hopiꞌnono nomꞌne mtaꞌni angaꞌnohinoso uyokolofahonɨngki Anɨtu kako kakoe aꞌamu ahwomomjo Ngkepɨliyel sohumo hwaho Ngkalili ango weꞌe Nasalet soponeꞌno lɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Oseso kako ape sijo siyepono umentisofoho. Oso aꞌmu hisimo kakoe hwehuneꞌno uhwojano lontɨfi hwosopeehiniyoho. Oso hwe huhwo sohwo kakoe yofeso Jousepɨyoho. Hofiyakwosa hwe engo Ntefitɨye temtitofo mtaꞌango hweho. Oso aꞌmu siye yofeso Maliyafoho. ");
INSERT INTO apz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ngkepɨliyel kako oso hisiꞌnjo sopo iꞌmofawento ulɨmento, Nje mupe mofehiꞌnyoꞌnjoho. Anɨtu kako wopɨngo kilohofalofoho. Kako kɨkoꞌnji humaho. ");
INSERT INTO apz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliya oso hungkunoso nupaꞌnonto kako huno piꞌnɨngo engo syafɨhuꞌmentisofoho. Oso hungkuno njiso hiso hwapɨngo neso pipineto. ");
INSERT INTO apz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ose syofɨsyahonɨngki aꞌamu ahwomomjo sohwo ulɨmento, Maliya, kɨko huno piꞌnɨngo syafɨsyohotoho. Iyoho kinyoꞌeno. Anɨtu kako kikineꞌno sɨmeho wopɨngo umoꞌnalofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Upaꞌnyo. Kɨko sɨmeho ihnꞌnɨngkiji hwomu aswo womaꞌmonnoho. Hwomu huhwo sohumo kakoe yofeso Jisasɨyo muso. ");
INSERT INTO apz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kako hwe engo umoꞌnɨmontonoho. Aꞌamu kakineꞌno ole wolantɨfeho. Olo hwe lohwo yoꞌmayo hopiꞌnonohino somo hwofiloꞌnnyo Anɨtuye Hwomu hweho. Ose wolantɨfeho. Olo hwe lohumo kakoe ajuyohwo Ntefit yofe engoꞌnjo hwaho mokosyohumamojo hopo sopo Anɨtu uhumatɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kako aꞌamu Juta somo neꞌno mokosyohumantɨhwone hweho. Kakoe sɨkuno mokosyohumayoꞌneso moiꞌwo mmoꞌnonehoho. Engolopohamo wawoꞌmtonoho. ");
INSERT INTO apz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ose ulahonɨngki Maliya ulɨmento, Oso hiso pipi umoꞌnɨmontolo. Ngko hwehwo manɨmahnꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ose ulahonɨngki aꞌamu ahwomomjo sohwo ulɨmento, Hwangku Anɨtuye Towahuno Wopɨngo kikiyepono pɨhwosi Anɨtu yoꞌmayo somo hwofiloꞌnnyo sohwoe yokumpohnꞌnyoso ufehuꞌmokakohumontonoho. Oseso hwangku oso hwomu aswo majo huhwo sohuneꞌno aꞌamu ole wolantɨfeho. Hwomu wopɨngo sohwo Anɨtuye Hwomu Ne hweho wolantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ose ulɨkwato lohofonto ole ulɨmento, Upaꞌnyo. Jɨje aꞌamu Elisapet aꞌmanesi kako sɨmehoꞌnjoho. Aꞌamu kakineꞌno hwonjo apefoho lɨmotofosi kako sɨmeho ihnꞌnɨngkahonɨngki hamno aho fehohnjo hopiꞌnono nomꞌni mtaꞌni angaꞌnohinoso uyakoloꞌmasofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yoꞌmayo hopiꞌnono aꞌamu miyɨwoꞌnɨngkiyohofoso Anɨtu kako yoꞌmayo hwapɨngo sohwo yososo ne umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ose ulahonɨngki Maliya ulɨmento, Ihwoni, ngko Anɨtuye syoho ulohofiꞌnyoho. Kɨko ngkimo hungkuno ntohinoso nolohino hopaso Anɨtu kako ngkimo wantohofono. Ose ulahonɨngki aꞌamu ahwomomjo sohwo kako Maliyamo ulɨkoꞌmaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Oso hohosohonta Maliya kako yoꞌmayoso itoꞌno esyohumanto nolɨkafonto kako hwofɨkiꞌnyo poneꞌno komoꞌno sɨmentisofoho. Oso hwaho Jutiya ango weꞌe sopo sɨꞌmofapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sɨꞌmofaponto Sekolaiya sohwoe angomo noswonto Elisapetɨmo nje aꞌamuyo ulonto hinjoho huꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisapet Maliyafe mampaho upaꞌnonto kakoe mehomi sɨmeho moꞌmo mnawoꞌnnyo sohwo kako yomo imentisofoho. Oso hohosohonta Anɨtuye Towahuno Wopɨngo Elisapetɨmo uhulaꞌmoꞌmentisoso ");
INSERT INTO apz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisapet kako mango engo ole ulɨmento, Anɨtu kako moyaꞌmi hopiꞌnonohino sofamo wopɨngo ulohofɨwoꞌnɨngkiso somo kako kikimo wopɨngo kilohofoso yakoloꞌnnyo kiyoho. Oso mehomi jɨje sɨmeho moꞌmo mnawojo sohumo Anɨtu kako wopɨngo ulohoꞌnnyo hweho. ");
INSERT INTO apz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nje Hwe Engofe naꞌu siki ngkiyepono pehoꞌno pohino. Ngko yoꞌmɨngiꞌnɨꞌmaho. Anɨtu kako wonyoangkafo ntohofantofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Upaꞌnyo. Ngko jɨje mampaho ngkineꞌno ntohinoso upaꞌnonji nje sɨmehomjo mehomi mnawojo sohwo nolɨkafonto sɨmonyo yohoho. ");
INSERT INTO apz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Oso hungkuno Anɨtu kilɨmaso somo kɨko sɨmeho hiꞌntnnono uyɨmahnno soꞌno sɨmonyo fiyo. Oseso Hwe Engo sohwo nokilɨmaso hopaso wakilohoꞌmontonoho. Elisapet ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maliya ulɨmento, Nje mampahoso Anɨtuye yofe hoꞌnomalokweno. ");
INSERT INTO apz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nje huyoꞌmango Anɨtu nefoꞌmawoꞌnɨngkiso sohuneꞌno sɨmonyo yalokwemo. ");
INSERT INTO apz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ngko Anɨtuye syoho ulohofiyohnꞌni yoꞌmɨngiꞌnɨꞌmaho. I osoꞌno kako ngkimo wonyoangkafo ntohofantofoho. Olohonta nɨhu hwangku noꞌmo nɨhu aꞌamu Anɨtu kako ngkimo sɨmeho wonyoangkafo ntape soꞌno wolantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Anɨtu kako Yokumpohnꞌnyo Hwofiloꞌnnyo sohwo kako ngkimo wopɨngo ntohofo soꞌno ngko kakoe yofe wopɨngoꞌnohinoso wohoꞌnɨmaꞌmo. ");
INSERT INTO apz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Anɨtu kako aꞌamumneꞌno hitoho ulofahonɨngki aꞌamu kakoe hungkunomo enjwaꞌmo humawoꞌnɨngkohofoso hofɨko Anɨtu kakoe hitohomo humalofo. Hofɨkoꞌnohinɨꞌmaho. Oꞌo, hofɨkoe imu hwanji neꞌno imu hwanjimo neꞌnohini wentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Anɨtuye yokumpohnꞌnyo itɨhwahonɨngki aꞌamu kakineꞌno yokumpohnꞌnyo imoꞌnɨwoꞌnɨngkohofo somo Anɨtu kakoe aho yokumpohnꞌnyo engo soꞌnji ilojaofososo hofɨko kengoꞌmo humpopitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Anɨtu kako hwe yofe engo hwaho mokosyohumamotofo sohwamo monje yasyɨhwosi aꞌamu yofe engo ane somo hoꞌnomawoꞌnɨngkisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aꞌamu mijoho unyo somo Anɨtu kako yoꞌmayo wopɨngo wonyoangkafo uyɨmontonoho. Aꞌamu yoꞌmayo hoꞌyango piꞌnɨngoꞌnjo somo kako nomꞌne wopɨngoso muyonehoho. ");
INSERT INTO apz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kako kakoe aꞌamu Juta hnꞌnɨmo hofiyo nefoꞌmawoꞌnɨngkiso hweho. Oso hungkuno wopɨngo Anɨtu hitoho ulofoꞌne hofɨkimo uyɨmentiso soꞌno kako inɨngo momofalofiyoho. ");
INSERT INTO apz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kako neyakwosamo Apɨloham sohwoꞌnji kakoe imu sohwatnneꞌno hitoho ulofahonɨngki oso hitoho hiso engolopohamo neꞌno nowentɨhwonefoho. Maliya ose lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliya kako Elisapetɨꞌnji nohumentanɨngki hamno hufaꞌu sɨhune memjaofahonɨngki kakoe angopo neꞌno asomo umentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisapet kakoe sɨkuno moiꞌwo imoꞌnɨngkahonɨngki kako hwomu aswo maꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Anɨtu kako oso wopɨngo hiso Elisapetɨmo ulohoꞌmentiso soꞌno hoꞌnɨngkahonɨngki aꞌamu ango afaponjo soꞌnji Elisapetɨye temtitofo soꞌnji hofɨko Elisapetɨꞌnji sɨmonyo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sɨkuno aho fehohnjo hopiꞌnono fehohntaꞌni hufaꞌu sɨhune memjaofahonɨngki aꞌamu huhwo sohwa hofɨko hwomu sohwoe aꞌapahomo sɨhu kolofoꞌneꞌentɨfi uhuꞌmokumentohofofoho. Hofɨko kanɨngkwohwoe yofe Sekolaiyafeso womelompulano lontɨfi imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ose yahonɨngkofi konaꞌwohi ulɨmento, Oꞌo, awonoho. Nakwo kakoe yofeso ole womulano. Jounɨyoho. ");
INSERT INTO apz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ose ulahonɨngki hofɨko ulɨmentohofi, I, sikoe aꞌamu sohwa oso yofe Jounɨyo eso hiꞌnjo hwaꞌmaho. Nɨhuꞌno awonoho. ");
INSERT INTO apz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ose ulontɨfi hofɨko kanɨngkwohumo hungkuno mujoꞌnjo mehomife yofeꞌno ahoꞌnohini upiyoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Upiyofahonɨngkofi Sekolaiya kako iyo feejo soꞌno ipiyofahonɨngki umentohofoso kako ole mtɨꞌmokumento, Kakoe yofeso Jounɨyoho. Aꞌamuso ose uhwonontɨfi hofɨko yomo yontɨfi huno piꞌnɨngo engo syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Oso hohosohonta Sekolaiyafe mango hwosampo lohofonto melanyo itoꞌno imoꞌnɨngkahonɨngki kako hungkuno lonto kako Anɨtuye yofe hoꞌnomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Oso aꞌamu ango afaponjoso hofɨko yoꞌmayo homo somo uhwonontɨfi yomo yontɨfi iyoho unɨngkahonɨngki pisopisaho lɨmentohofofoho. Oso yoꞌmayo imoꞌnɨmentiso hisoꞌno oso hwaho Jutiya hwofɨkiꞌnyoꞌmeemjo ango somo hoꞌnomɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aꞌamu hopiꞌnonohino oso hungkuno homo somo upaꞌnontɨfi huno piꞌnɨngo engo syafɨsyontɨfi hofɨkoe sɨmeho moꞌmo ole hnnɨmentohofi, Oso hwomu huhwo sohwo kako hwangku pipi wehumamontehwolo. Ose hnnontɨfi huno ole umento, Anɨtuye yokumpohnꞌnyoso kakimo umokosyohumaho. Huno ose umentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jounɨye kanɨngkwohwo Sekolaiya sohumo Anɨtuye Towahuno Wopɨngo ehuhnnaofahonɨngki Sekolaiya kako hungkuno Anɨtu uyɨmentisoso ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ole ulɨmento, Nakwo aꞌamu Isɨlael hnꞌnwiye Hwe Engo Anɨtu sohwoe yofe wohoꞌnomano. Kako kakoe aꞌamu hnꞌnwiyepono nefoꞌmayoꞌne neꞌmanto kako honɨngkano wonyo somtaꞌni isɨhutofonemalofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kako kakoe syoho ulohofiyo Ntefitɨye temtitofo mtaꞌango hwe yokumpohnꞌnyo engo nefoꞌmayoꞌne nejapohoho. ");
INSERT INTO apz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Olo hilo soꞌno Anɨtu hohonta kakoe aꞌamumo hungkuno uyahonɨngki lɨmotofo sohwa nakumo nalɨmotofofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ole nalɨmentohofi, Hwangku kako nakwoe mango sohwafe aho mtaꞌni wonetɨmaꞌmontonoho. Aꞌamu nakumneꞌno sɨmeho wonyo umoꞌnɨwoꞌnɨngkiso sofe aho mtaꞌni wonetɨmaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ose nalonto nomꞌnepo ole nalɨmento, Kako neyakwosamneꞌno hitoho engo neꞌno ulofɨwoꞌnalofoho. Oso hungkuno yokumpohnꞌnyo hohonta neyakwosamo uyɨmentiso somneꞌno kako huno akweꞌno syafɨsyɨwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Anɨtu neyakwo Apɨloham sohumo ulɨmento, Ngko hungkuno nehopiꞌnohini yokintahoponeꞌno wakilɨmonneꞌno yohono. ");
INSERT INTO apz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ngko sekwoe mango sohwafe aho somtaꞌni nosetɨmahmꞌmo sekwo iyoho masenyoꞌnjo nje syoho wontohofiyantɨfeho ");
INSERT INTO apz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Sekwo sɨkuno huhwo huhwi songo nohumafɨkuji sekwo nje tɨmopo sekwo honɨngkano wonyo aneꞌnjo wopɨngoꞌnohini fohumantokuno. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nje hwomu sohwosi, aꞌamuso ole kilɨfitnnefoho. Kɨko Anɨtu yokumpohnꞌnyo hwofiloꞌnnyo sohwoe hungkuno lutɨhwayoꞌne hwosoho. Oso hwe Anɨtu nakuyepono uhwatɨmonteꞌno yalokuso sohumneꞌno kɨko aꞌamu somo itoꞌno wesyohumamonnoho. ");
INSERT INTO apz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kɨko Anɨtuye hungkuno aꞌamu somo ulohojoꞌno hofɨko huno ole uyɨmtonoho. Anɨtu kako nakwoe wonyo wae enaofɨhwosi asomo wonetɨmaꞌmonteꞌne yohoho. Huno ose uyɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anɨtu nakumneꞌno hitoho engo ulofɨwoꞌnɨngkiso sohwo sɨmeho neꞌnjo nejapɨwoꞌnɨngkiso soꞌno pomponaho ahwomo mtaꞌni iyoho longkonɨwoꞌnɨngkiso hopaso nejapososo nakumo wonalongkonɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Oso pomponaho hiso kako aꞌamu sɨkwoꞌmjohoꞌmo humalofo soꞌnji aꞌamu hofɨko poyo peꞌnyo soꞌno iyoho unyo somo wolahumontonoho. Oso pomponaho hiso honɨngkano wopɨngoꞌnohini itoꞌno humayoꞌne somo womikinjonehwatɨmontonoho. Sekolaiya ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Oso hwomu Joun huhwo sohwo kako engo wento Anɨtumneꞌno sɨmeho uyonto kako hwaho aꞌamu mohumunyo sopo neꞌno humamojoso kako aꞌamu Isɨlael somneꞌno Anɨtuye hungkuno lutɨhwamneꞌento Anɨtuye syoho wemaꞌmo lonto hofɨkoꞌnjopo utɨhwaꞌnyopo iꞌmofapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Oso hohosohonta hwe yofe engoꞌnjo hwaho Loum mokosyohumayo sohwo Sisa Oukasɨtos, kako honɨngkano songo imofonto ulɨmento, Aꞌamu angoꞌmeemjo sofe yofe nakwoe iyoswomo wamtɨꞌmokano. ");
INSERT INTO apz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ose ulahonɨngki oso soswo sɨmoꞌmjo somo aꞌamufe yofe ifalifaliyo mtɨꞌmokumentohofofoho. Oso hohosohonta hwe yofe engoꞌnjo hwaho Siliya mokosyohumayo sohwo Kwiliniyosɨyoho. ");
INSERT INTO apz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Oseso hwe moyaꞌmi hopiꞌnonohino hofɨkoe ango hwapɨngopono hofɨkoe yofe mtɨꞌmokiyoꞌne humpoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jousep sohwo kako Ntefitɨye imu hweho. Osoꞌno kako ango Nasalet hwaho Ngkalili nulɨkoꞌmanto hwaho Jutiya Ntefitɨye pone Mpetɨlehemneꞌno umentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jousep kako kakoe ape ufohotoꞌmentohofosi Maliya sɨmehoꞌnjosiꞌnji nekwoe yofe wemapɨfe lonji umentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Oso hopo sopo nohumanji Maliyafe sɨkuno mehomi aswo mayoꞌne iꞌmofapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kako hwomu tisɨmaso aswo manto hwapɨfe ekojɨsasyonto yahu wopayo uyo kompuso soꞌmo uwotɨmentisofoho. Hwapɨngoso aꞌamu fosyawowoꞌnɨngkohofo angoso aꞌamu nto uhulaꞌmoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Oso hwaho hopo sopo ango pone engo momɨngo sohohntaꞌni aꞌamu ahwomo yahu mokosyohumayo sohwa hofɨkoe yahu oso sɨkwoꞌmiyo somo mokosyohumentanɨngkofi ");
INSERT INTO apz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","aꞌamu ahwomomjoso nuꞌmahonɨngki ahwomo mtaꞌango pomponaho engo losyahonɨngki aꞌamu yahu mokosyohumayo sohwa iyoho unɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Iyoho yahonɨngkofi aꞌamu ahwomomjo fihwo ulɨmento, Sekwo iyoho ikutoho. Upaꞌnɨmno. Ngko hungkuno wopɨngo aꞌamu hopiꞌnonohino somneꞌno sɨmeho wopɨngo umoꞌnyoꞌneꞌnji motapohefoho. ");
INSERT INTO apz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Olo sɨkuno lomo Ntefitɨye pone engo Mpetɨlehem sopo aꞌmu fisi hwomu aswo makwoho. Olo mehomi lohwo aꞌamu sokumo asomo setɨmayoꞌne hweho. Kako Kɨlais Hwe Engo huhwo sohumo Anɨtu uhwosopoꞌmentiso hweho. ");
INSERT INTO apz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sekwo nowekuji wotɨpemantɨfeho. Hwomu huhwo sohumo hwapɨfemo ifohumpento yahu wopayo uyo kompusoho somo hoꞌnasyohoho. Oso hiso nuhwonɨngkuji sekwo huno ole waseyono. Olohohweho. ");
INSERT INTO apz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ose ulahonɨngki nɨhuꞌno komoꞌno aꞌamu ahwomo mtaꞌango piꞌnɨngo engoso sɨmoꞌmjo soꞌnji utɨhwaꞌnyopo iꞌmofapontɨfi Anɨtuye yofe hoꞌnomayoꞌne ole ulɨmentohofi, ");
INSERT INTO apz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Anɨtu ahwomo yokintahopo humaso sohumneꞌno isamoyoka ulano. Kakoe yofe wohoꞌnomano. Aꞌamu hwahoponjo humalofoso Anɨtuye sɨmeho wopɨngo umokalokwofoso hofɨko sɨmeho wopɨngoꞌnji wohumantɨfeho. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aꞌamu ahwomomjoso nulɨkoꞌmantɨfi ahwomomo asomo sɨmentohofo sohonta aꞌamu yahu mokosyohumayo sohwa ole hnnɨmentohofi, Nakwo Mpetɨlehem neꞌno kuntoꞌno wohwano. Olo hiloso nakwoe Hwe Engo sohwo nto lonetɨhwaso soꞌno uhwonowano. ");
INSERT INTO apz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ose hnnontɨfi komoꞌno nowentɨfi hofɨko Jousepɨꞌnji Maliyaꞌnji sikoe hwomu yahu wopayo uyo kompusoho somo wentanɨngki tɨpɨhwonɨmaꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hofɨko nuhwonontɨfi hofɨko olo hwomu lohumneꞌno yoꞌmayo hungkuno aꞌamu ahwomo mtaꞌni upaꞌnɨmentohofo soꞌno lɨjwaoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aꞌamu hopiꞌnonohino oso hungkuno aꞌamu yahu mokosyohumayo sohwa ulɨmentohofoso upaꞌnɨmentohofo soꞌno huno piꞌnɨngo engo syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Olo hungkuno aꞌamu ahwomomjoso yahu mokosyohumayo sohwamo ulɨmentohofo soꞌno Maliya nupaꞌnonto kakoe sɨmehomo memeesyonto hunomo mohoꞌnahuꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Oso aꞌamu yahu mokosyohumayo sohwa asomo nowentɨfi Anɨtuye yofe hoꞌnomaꞌmentohofofoho. Yoꞌmayo upaꞌnɨmentohofo soꞌnji yoꞌmayo aꞌamu ahwomomjoso nto ulɨmentohofo hopaso uhwonɨmentohofo soꞌntnneꞌno Anɨtumo isamoyoka ulontɨfi sɨmonyo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hwangku sɨkuno aho fehohnjo hopiꞌnono nomꞌne mtaꞌni hufaꞌu sɨhune memjaofahonɨngki mehomi huhwo sohwoe aꞌapahomo sɨhu kolofontɨfi hofɨko yofe ole mulɨmentohofi Jisasɨyoho. Oso yofe hiso mehomi huhwo sohwoe konaꞌwohi sɨmeho mmoꞌnnyo sohonta aꞌamu ahwomomjo sohwo Maliyamo ulapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Oso honɨngkano hungkuno Mouses aꞌamu somo uyɨmentisoso olenoho. Moyaꞌmi sofa hofɨko aswo mayo sohonta sɨkuno fouti (40) memjaofɨhwosoꞌno hofɨko Anɨtuye tajo ango engo somo mahufitnnehofo. Sɨkuno hiso moiꞌwo imoꞌnɨngkuhwosoꞌno hofɨko Anɨtumneꞌno yoꞌmayoso wofonjokisosyantɨfeho. Honɨngkano hungkunoso osenoho. Oseso Maliyafe sɨkuno moiꞌwo imoꞌnɨngkahonɨngki kako kakoe mehomiꞌnji Jousepɨꞌnji ango Jelusalem sopo Anɨtumo mehomi utɨhwayoꞌne sɨmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Hwapɨngoso Hwe Engofe hungkuno ole woꞌnnyofoho. Mehomi tisɨmasoso hwomuꞌmanji sekwo Anɨtumo uyɨmono. Hofɨko Anɨtuye hwafoho. ");
INSERT INTO apz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hungkuno nomꞌneso olenoho. Mehomi songo utɨhwayo sohonta yɨhufo ntolofiyo faꞌutɨkeno kumakumuyo polonyo hufaꞌutɨkeno osofaꞌu Anɨtumneꞌno fonjokisasyo. Oseso siko oso hiso Anɨtumneꞌno fonjokisasiyoꞌne sɨmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oso hohosohonta hwe fihwo ango Jelusalem humamojo sohwo kakoe yofeso Simeyounɨyoho. Oso hwe huhwo sohwo kako hwe wopɨngoꞌnohino hweho. Kako sɨkuno huhwo huhwi Anɨtumneꞌno hwomtame ulohofɨwoꞌnɨngkiso hweho. Kako oso hwe Anɨtu aꞌamu Isɨlael somneꞌno uhwatɨmonnoho lɨmentiso sohuneꞌno sɨkuno huhwo huhwi oso hwomu huhwo sohumo uhwonyoꞌne hontohumayo imojo hweho. Anɨtuye Towahuno Wopɨngo sohwo Simeyounɨmo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Anɨtuye Towahuno Wopɨngo sohwo kako Simeyounɨmo ole nto ulɨmentisofoho. Kɨko komoꞌno poyo mapeꞌntnne hwosoho. Oꞌo, sɨmoꞌmo kɨko oso hwe Anɨtu uhwatɨmonnoho selɨmentiso sohumo kakiꞌno uhwonɨngkohoji kɨko tɨfi wapeꞌnɨmonnoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Oseso oso sɨkuno Jisasɨye kanɨngkwohwoꞌyaꞌu siko Mousesɨye honɨngkano hungkuno somo itoꞌno inɨngkayoꞌne Jisasɨmo Anɨtuye tajo ango engo somo motahumentisiyo sɨkuno somo Anɨtuye towahuno sohwo kako Simeyounɨmo Anɨtuye tajo ango engo somo syuyoꞌne lɨkofɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyoun oso hwomu huhwo sohumo uhwononto nutɨmanto Anɨtuye yofe hoꞌnomayoꞌne ole ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","U, Hwe Engofo, kɨko hungkuno ntɨmentohinoso olohonta ne imokohino. Osoꞌno ngko jɨje syoho kilohofiyo sohwoꞌni hungkuno sɨmoꞌmo ntɨmentohino hopaso ngko sɨmeho wopɨngoꞌnjo hwoꞌni wapeꞌnɨmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Hwapɨngoso ngko nje tɨmoꞌnji oso hwomu nakumo asomo netɨmayoꞌne kɨko uhwosopoꞌmentohino sohumo nto uhwonɨngkohono. ");
INSERT INTO apz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kɨko olo huhwo lohumo emokosyohumanji hwe moyaꞌmi temtitofo kengo kengo hopiꞌnonohino somneꞌno utɨhwaꞌnyopo ujo nto ehontojwasyohino. ");
INSERT INTO apz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kako huhwo sohwo pomponaho hopa aꞌamu hopiꞌnonohino somo lɨsyɨhwosi kako jɨje yahino wopɨngoso utɨhwamte hweho. Jɨje yofe engo soꞌnji jɨje yokumpohnꞌnyo engo soꞌnji aꞌamu Isɨlael somo utɨhwamontonoho. ");
INSERT INTO apz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeyoun ose ulahonɨngki Jisasɨye kanɨngkwohwoꞌyaꞌu yoꞌmayo Jisasɨmneꞌno ulɨmentiso soꞌno upaꞌnonji yomo yonji huno piꞌnɨngo engo syafɨhuꞌmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Simeyoun Jisasɨye kanɨngkwohwoꞌyaꞌumo hungkuno wopɨngoꞌnjo aho ulonjimokonto osopo kako konaꞌwohi Maliyamo ole ulɨmento, Olo hwomu lohumneꞌno kɨko tango mɨkunɨmposo wotɨpemaꞌmonnoho. Hwapɨngoso aꞌamu Isɨlael piꞌnɨngoso hwomu lohumo uhwonɨngkuji nakwolaho wolantɨfeho. Ose lɨfijo soꞌno hofɨko nɨhuꞌnahone nowahupitnnefoho. I oseso aꞌamu nomꞌne piꞌnɨngoso hofɨko olo hwomu lohumneꞌno yokumpohnꞌnyo lohofɨkuji sɨmonyo ifitnnefoho. Kako aꞌamufe sɨmeho moꞌmo yoꞌmayo huno mnawojoso utɨhwaꞌnyopo ujo wehontojwahumontonoho. Maliyamo ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Aꞌmu fisimo Anɨtu hungkuno uyahonɨngki lɨmojosi osopo humamentisofoho. Kakoe yofeso Anafoho. Kanɨngkwohwoe yofeso olenoho. Feenuelɨyoho. Kako Asyafe temtitofo mtaꞌangiyoho. Kako nɨhuꞌno aꞌmaniyoho. Hohonta kako hwehumo umaꞌnonto hwehwoꞌnji soswo aho fehohnjo hopinono nomꞌne mtaꞌni hufaꞌu humamentisiyo sohonta hwehwo poyo peꞌnɨngkahonɨngki aꞌmusi kakoꞌnohini nohumentanɨngki soswo eti-foua (84) uyakoloꞌmentisofoho. Kako Anɨtuye tajo ango engo somtaꞌni noswapɨwoꞌnɨngkisiꞌmaho. Oꞌo, osopo neꞌno humamojiyoho. Sɨkunoꞌnji imɨngoꞌnji hinjopo sɨkwoꞌmiyomo kako Anɨtumneꞌno hwomtame ulohoꞌmojiyoho. Sɨkuno fisomo kako wosopayo manyo humanto Mpohumo jomoꞌnohino ulɨmojiyoho. ");
INSERT INTO apz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Oso hohosohonta kako hisi Jisasɨmo uꞌmanto Anɨtumo isamoyoka ulɨmentisofoho. Kako aꞌamu ango Jelusalem humamotofoso Anɨtu kako ngko hwe angaꞌno sekumo asomo setɨmayoꞌne uhwatɨmonnoho lɨmentiso sohumneꞌno hontohumentanɨngkofo somo oso hwomu huhwo sohumneꞌno hungkuno lujɨmoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yoꞌmayo honɨngkano hungkuno woꞌnnyo somo itoꞌno nto inɨngkawenji Jousepɨꞌyaꞌu siko hwaho Ngkalili sikoe ango weꞌe Nasaletnneꞌno umentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Hwomu sohwo kako engo wento yokumpohnꞌnyo manto kako huno engo tɨpemaꞌmentisoso hiꞌnjo hweho. Anɨtuye hitoho engoso kakimo woꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Soswo huhwo huhwi Jisasɨye kanɨngkwohwoꞌyaꞌu siko ango Jelusalem sopo oso Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo sɨkuno engo somneꞌno sɨmojiyofoho. Oso sɨkuno hiso aꞌamu Jutafe hofiyakwosamo Anɨtu kako hofɨkoe mango sohwafe aho mtaꞌni isɨhutofomayoꞌne huno syafɨsiyoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas kakoe soswo aho hufaꞌu hopiꞌnono sɨfe mtaꞌni hufaꞌu uyokolofahonɨngki kako hofɨkoꞌnji oso Sɨkuno Engo somneꞌno sɨmotofo hopaso sɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Oso Sɨkuno Engoso moiꞌwo imoꞌnɨngkahonɨngki hofɨkoe ango poneꞌno asomo womentohofofoho. Kanɨngkwohwoꞌyaꞌu ango poneꞌno ko wahonɨngki Jisas kako Jelusalem humohumantisofoho. Osohonta kanɨngkwohwoꞌyaꞌu Jisas sikoꞌnji mohumayo soꞌno huno mosyafɨhuꞌmmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Oꞌo, huno ole syafɨhuꞌmentisi, Jisas kako nomꞌne hwomu hwanji emoyalokwofo syafɨsyonji mofehiꞌnyo angaꞌno Jisas ane sikoꞌnohini emoyɨmentisiyefoho. Mofehiꞌnyo moiꞌwo imoꞌnɨngkahonɨngki kanɨngkwohwoꞌyaꞌu siko Jisasɨmneꞌno sikoe aꞌamuꞌnjo soꞌmo hafɨhafe wonyopi tɨpementisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Siko motɨpemayoꞌnjo yonji siko ango Jelusalemneꞌno asomo nosonji hafɨhafe neꞌno tɨpmmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sɨkuno hufaꞌu sɨhune memjaofahonɨngki Jisas kako Anɨtuye tajo ango engo somo nohumentanɨngki uhwonɨmaꞌnɨmentisiyefoho. Kako aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji humamentohofofoho. Jisas hofɨkoe hungkunomo upaꞌnonto yoꞌmayo hofɨko ulɨmentohofo soꞌno hofɨkimo kako aku ulohonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aꞌamu huhwo sohwa hofɨko Jisasɨye hungkunomo upoꞌnontɨfi yomo yontɨfi kakoe huno engo somneꞌno pisopisaho lɨmentohofofoho. Yoꞌmayo hungkuno Jisas hofɨkimo aku ulɨmentiso soꞌno hofɨko wonyoangkafofoho syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kanɨngkwohwoꞌyaꞌu siko Jisasɨmo notɨpɨhwononji kakoe hungkunomo upaꞌnonji siko hiyaꞌu yomo yonji pisopisaho lɨmentisiyefoho. Maliya Jisasɨmo ulɨmento, Olo hwomu lohwo sohwosi pehoꞌno humahnno. Nekwo kikineꞌno hafɨhafe weꞌe motɨpeeloku yɨhwoyo. Kɨko nekumo me-ejoꞌnjo imahnno soꞌno nekwoe sɨmeho tango weꞌyoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ose ulahonɨngki kako ulɨmento, Siko ngkineꞌno pehoꞌno ntopeentɨkusiyo. Ngko nje Mpohwoe ango lomo humayoso hoponoho. Siko huno ose maseyotaho. ");
INSERT INTO apz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ose ulahonɨngki siko oso hungkuno hwapɨngo ne soꞌno huno mosyafɨhuꞌmmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Oseso Jisas kako kanɨngkwohwoꞌyaꞌuꞌnji asomo nowentɨfi hofɨkoe ango Nasalet uꞌmofamentohofofoho. Osopo Jisas kako nohumanto kanɨngkwohwoꞌyaꞌuye hungkunomo halohoꞌno upoꞌmojo hweho. Maliyasi kako oso yoꞌmayo hisoꞌno kakoe sɨmeho moꞌmo mnawoꞌmojofoho. ");
INSERT INTO apz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas kako engo wento kakoe huno wopɨngoso engo imoꞌnɨmentisofoho. Aꞌamu hopiꞌnonohino soꞌnji Anɨtu huhwoꞌnji Jisasɨmo uhwonɨmentohofoso wopɨngo uhwonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Hwe engo yofe hwofiloꞌnnyoꞌnjo Taipeliyos Sisa sohwo kako hwaho hopiꞌnono mokosyohumentanɨngki soswo aho hopiꞌnono sɨfe nomꞌne mtaꞌni osofosofahuꞌno uyakoloꞌmentiso sohonta olo aꞌamu hwaho weꞌe weꞌe mokosyohumamojo sohwa kakimo enjwaꞌmo humamotofofoho. Pountiyos Pailot kako hwaho Jutiya sopo mokosyohumamojo hweho. Oso hohosohonta Helout kako hwaho Ngkalili mokosyohumamojofoho. Kolaꞌwehwo Filip sohwo hwaho Ituliyaꞌnji Tɨlakounitisɨꞌnjimo mokosyohumamojo hweho. Osohonta Laiseniyas kako hwaho Apilene mokosyohumamojo hweho. ");
INSERT INTO apz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Oso hohosohonta Anasɨꞌnji Kaiyofasɨꞌnji siko aꞌamu Anɨtuye tajo ango engo mokosyohumayo syoho somneꞌno yofe engoꞌnjo imoꞌnɨmentisiyefoho. Oso hohosohonta Joun, Sekolaiya sohwoe hwomu sohwo, kako aꞌamu mohumunyopo humamojo sohumo Anɨtu kakoe hungkuno uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Oseso Joun kako oso hwaho Mijo Joutan ajwo sopo nowakento nowekaponto yonto kako aꞌamu oso hopo soponjo somo Anɨtuye hungkuno lutɨhukuꞌmoꞌmentisofoho. Ole ulɨmento, Sekwo sekwoe honɨngkano wonyo somneꞌno hohujo ikinjaofɨkujoꞌno Anɨtu kako sekwoe wonyo hiso wae yasemofɨhwosoꞌno ngko mijo wakiyosemaꞌmo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Joun ose imentiso paꞌnyoso hohonta Anɨtu kako Aisaiyamo hungkuno uyahonɨngki iyoswomo ole mtɨꞌmokumento, Hwaho aꞌamu mohumunyo fiꞌmo hwe fihwoe mampaho engo ole hoꞌnɨmento, Hwe Engo sohumneꞌno honɨngkano itoꞌno fehumamno. Kakoe hano emoyoꞌne soꞌno honɨngkano hiso itoꞌno mɨhwatɨmno. ");
INSERT INTO apz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Huyo soꞌmo ijakipokipe walohopɨfe. Hwofɨkiꞌnyo engo soꞌnji mno ijisangkisanjo weehufe. Honɨngkano ikitoꞌnnyo somo itoꞌno womuhwatɨfe. Honɨngkanopo sojo ipmpɨngo woꞌnnyoso womehuꞌmeeopɨfe. ");
INSERT INTO apz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ose ikujoꞌno hwe moyaꞌmi hopiꞌnono hofɨko oso hwe Anɨtu asomo netɨmayoꞌne uhwatɨmonteꞌno yalokunjo sohumo uhwonantɨfeho. Aisaiya oso hungkuno mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hwe moyaꞌmi piꞌnɨngo engo mijo wokiyonemano lontɨfi hofɨko Jounɨmo uꞌmaꞌmentohofofoho. Iꞌmofopahonɨngkofi Joun hofɨkimo ulɨmento, Sekwo homa mehomi soku tɨhwo selɨmasoto. Anɨtu aꞌamufe wonyo honɨngkano somneꞌno tohino mɨkunɨmposo uyo somneꞌno iꞌwaho fiyɨmno. Ose tɨhwo selahonɨngki nɨꞌmahofo kulo. ");
INSERT INTO apz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sekwoe honɨngkano wonyo somneꞌno hohujo ukinjaofano lɨfijoꞌmanji eꞌwano yahino wopɨngoꞌnohini utɨhwaꞌnyopo fiyɨmno. Sekwo ole nohnnɨngkutoho. Nakwo Apɨlohamɨye imu hnꞌnɨmo oso tohino engo hiso moneꞌmanehoho. Ose nohnnɨngkutoho. Ngko hungkuno nehopiꞌnohino waselɨmonneꞌno yohono. Olo sojo loso Anɨtu kako Apɨlohamɨye imuhwa wamtɨꞌmokumo losoꞌmanji kako hopoeno wamtɨꞌmokumontonoho. ");
INSERT INTO apz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Anɨtu kako iyomo mɨngo lofoꞌne iwaꞌmɨngo ikafeꞌmo mokosyalohofoho. Iyo ipisayo wopɨngo mintoꞌnyoꞌnjo somo nolofehwosi tohomo wolofaeꞌmtonoho. ");
INSERT INTO apz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ose ulahonɨngki hofɨko Jounɨmo ulohonɨmentohofi, Oso hungkuno nalohino hisoꞌno nakwo pipi yanehwono. ");
INSERT INTO apz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ose ulahonɨngkofi kako ulɨmento, Hwe manjiꞌmofo hufaꞌuꞌnjo sohwo kako hwe fihwo manjiꞌmofoꞌneꞌno umofonyo inyo sohumo angaꞌno uyono. Oso paꞌnyoso aꞌamu wosopayo woꞌnnyo sohwo kako nomꞌni hwamo uyono. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aꞌamu hamniyoho hoꞌnasyontɨfe mawoꞌnɨngkohofo aꞌamu fehohnjo sohwa mijo wokiyonemano lontɨfi Jounɨmo uꞌmantɨfi ulɨmentohofi, Nakwoe Lonetɨhwayo sohwosi nakwo sohwonaꞌni pipi yanehwono. ");
INSERT INTO apz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ose ulahonɨngkofi ulɨmento, Aꞌamu nakwoe hwaho mokosyohumayo sohwa hamniyoho mayoꞌne hungkuno yano sejapɨwoꞌnɨngkohofo soponohini aꞌamu mtaꞌni mapmno. Sekwo nomꞌne hamniyoho nakwoꞌne womano ose syafɨsyɨkutoho. ");
INSERT INTO apz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aꞌamu itokusoꞌnjo fehohnjo sohwa Jounɨmo ulɨmentohofi, I, nakwo pipilo. Nakwo peho uyantanto. Ose ulahonɨngkofi kako ulɨmento, Sekwo aꞌamu mtaꞌni hamniyoho mayoꞌne hwasyo hungkuno mjɨlɨkutoho. Sekwo aꞌamu somo siki ikujoho ufonjɨkutoho. Sekwoe hwe engo sohwo hamniyoho sejapɨwoꞌnɨngkiso somneꞌnohini sekwo sɨmeho wopɨngo wasemoꞌnono. Nomꞌne hamniyoho soꞌneꞌno jomo ulɨkutoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aꞌamuso Jounɨye hungkunomo upaꞌnontɨfi hofɨko hofɨkoe hi ulɨkofahonɨngki huno piꞌnɨngo syafɨsyontɨfi ole hnnɨmentohofi, Olo hwe lohwo Anɨtu olo hwaho loponeꞌno uhwatɨmo lɨmentiso sohwolɨkeno. ");
INSERT INTO apz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ose hnnɨngkahonɨngkofi Joun ulɨmento, Ngko sekumo mijoꞌnohini kiyosemawoꞌnɨngkohono. Hwangku hwe nomꞌne fihwo kakoe yokumpohnꞌnyoso nje yokumpohnꞌnyomo yakoloꞌnnyo sohwo wapmmontonoho. Ngko sohwoꞌni oso hwe huhwo sohwoe yofe engo soꞌno ngko kakimo momayo ulohofiyo hwoꞌnyoho. Kako nopɨhwosi kako sekumo mijoꞌnohini makiyosemanehoho. Oꞌo, kako Anɨtuye Towahuno Wopɨngo sohwoꞌnji tohoꞌnji wokiyosemaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kako hwaho mno ijiyoꞌneso mokosyohumunyo hweho. Kako hwaho mno ijɨhwosi wosopayoso ijomahwosi pahoso wae yaofɨhwosi wosopayo neso kakoe angomo wohoꞌnahumontonoho. Pahoso toho masɨmpeꞌnyo neꞌno sijɨwoꞌnɨngkiso somo wohoꞌnaeꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Oso pahnnɨmo hungkuno ulonto kako nomꞌne hungkuno piꞌnɨngo engo oso paꞌnyoso aꞌamufe hunomo ufohotofoꞌne Anɨtuye hungkuno wopɨngoso lutɨhwamojo hweho. ");
INSERT INTO apz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tɨfi noꞌmo nomꞌne sɨkuno somo hwe yofe engoꞌnjo Helout kako hwaho mokosyohumayo sohwo kako konɨngkwaꞌwehwoe ape Heloutiyasɨmo hufo maꞌmentiso soꞌnji nomꞌne honɨngkano wonyo piꞌnɨngo engo imentiso soꞌntnneꞌno Joun kako Heloutɨmo yoka hungkuno ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Oso hisoꞌno Helout kako nomꞌne wonyo engo imentisoso olenoho. Kako Jounɨmo impoꞌangomo impe intofahumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sɨkuno fihwi hwe moyaꞌmi piꞌnɨngo engo somo Joun kako mijo nto kiyomanto humohumantohofofoho. Osohonta Jisas kako Jounɨmo uꞌmahonɨngki Joun Jisasɨmo mijo kiyomaꞌmentisofoho. Moiꞌwo nto kiyomahonɨngki Jisas kako Mpohumo jomo ulontanɨngki ahwomo mtampoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ahwomo nomtompeehonɨngki Anɨtuye Towahuno Wopɨngo sohwo yɨhufo ntolofiyo hopa ponto Jisasɨmo wekehumapmmentisofoho. Oso hohosohonta ahwomo mtaꞌni ole hoꞌnɨmento, Kɨko nje Hwomu sohwohnneꞌno ngko sɨmeho wopɨngo mɨkunɨmposo kijopalokweno. Kɨko yoꞌmayo wopɨngo iwoꞌnɨngkino soꞌno nje sɨmeho wopɨngo nɨmoꞌnantofoho. ");
INSERT INTO apz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas kakoe soswo teti (30) uyakolofahonɨngki kako kakoe syoho neso emaꞌmentisofoho. Hwe moyaꞌmi hofɨko huno ole syafɨhuꞌmentohofofoho. Jisas kako Jousepɨye hwomu hweho. Ose syafɨhuꞌmentohofofoho. Jousepɨye kanɨngkwohwoe yofeso Heliyoho. ");
INSERT INTO apz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heliye kanɨngkwohwo sohwo Motatɨyoho. Motatɨye kanɨngkwohwo sohwo Lifaiyoho. Lifaiye kanɨngkwohwo sohwo Melɨkiyoho. Melɨkiye kanɨngkwohwo sohwo Janaiyoho. Janaiye kanɨngkwohwo sohwo Jousepɨyoho. ");
INSERT INTO apz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jousepɨye kanɨngkwohwo sohwo Mototiyasɨyoho. Mototiyasɨye kanɨngkwohwo sohwo Amousɨyoho. Amousɨye kanɨngkwohwo sohwo Nahomɨyoho. Nahomɨye kanɨngkwohwo sohwo Esɨliyoho. Esɨliye kanɨngkwohwo sohwo Nakaiyoho. ");
INSERT INTO apz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakaiye kanɨngkwohwo sohwo Matɨyoho. Matɨye kanɨngkwohwo sohwo Mototiyasɨyoho. Mototiyasɨye kanɨngkwohwo sohwo Semenɨyoho Semenɨye kanɨngkwohwo sohwo Jousekɨyoho. Jousekɨye kanɨngkwohwo sohwo Joutafoho ");
INSERT INTO apz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joutafe kanɨngkwohwo sohwo Jouananyoho. Jouananye kanɨngkwohwo sohwo Lesafoho. Lesafe kanɨngkwohwo sohwo Selepapelɨyoho. Selepapelɨye kanɨngkwohwo sohwo Siyalɨtiyelɨyoho. Siyalɨtiyelɨye kanɨngkwohwo sohwo Neliyoho. ");
INSERT INTO apz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neliye kanɨngkwohwo sohwo Melɨkiyoho. Melɨkiye kanɨngkwohwo sohwo Atiyoho. Atiye kanɨngkwohwo sohwo Kousamɨyoho. Kousamɨye kanɨngkwohwo sohwo Elɨmotamɨyoho. Elɨmotamɨye kanɨngkwohwo sohwo Elɨfoho. ");
INSERT INTO apz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Elɨfe kanɨngkwohwo sohwo Jousyɨwafoho. Jousyɨwafe kanɨngkwohwo sohwo Eliyesafoho. Eliyesafe kanɨngkwohwo sohwo Joulimɨyoho. Joulimɨye kanɨngkwohwo sohwo Matatɨyoho. Matatɨye kanɨngkwohwo sohwo Lifaiyoho. ");
INSERT INTO apz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lifaiye kanɨngkwohwo sohwo Simeyounyoho. Simeyounɨye kanɨngkwohwo sohwo Jutafoho. Jutafe kanɨngkwohwo sohwo Jousepɨyoho. Jousepɨye kanɨngkwohwo sohwo Jounamɨyoho. Jounamɨye kanɨngkwohwo sohwo Elaiyakimɨyoho. ");
INSERT INTO apz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiyakimɨye kanɨngkwohwo sohwo Meleyafoho. Meleyafe kanɨngkwohwo sohwo Menafoho. Menafe kanɨngkwohwo sohwo Matotafoho. Matotafe kanɨngkwohwo sohwo Natanɨyoho. Natanɨye kanɨngkwohwo sohwo Ntefitɨyoho. ");
INSERT INTO apz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ntefitɨye kanɨngkwohwo sohwo Jesiyoho. Jesiye kanɨngkwohwo sohwo Oupetɨyoho. Oupetɨye kanɨngkwohwo sohwo Mpouasɨyoho. Mpouasɨye kanɨngkwohwo sohwo Salɨmounɨyoho. Salɨmounɨye kanɨngkwohwo sohwo Nasounyoho. ");
INSERT INTO apz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasounɨye kanɨngkwohwo sohwo Aminotapɨyoho. Aminotapɨye kanɨngkwohwo sohwo Atɨminɨyoho. Atɨminɨye kanɨngkwohwo sohwo Aniyoho. Aniye kanɨngkwohwo sohwo Hesɨlounɨyoho. Hesɨlounɨye kanɨngkwohwo sohwo Pelesɨyoho. Pelesɨye kanɨngkwohwo sohwo Jutafoho. ");
INSERT INTO apz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jutafe kanɨngkwohwo sohwo Jekoupɨyoho. Jekoupɨye kanɨngkwohwo sohwo Aisakɨyoho. Aisakɨye kanɨngkwohwo sohwo Apɨlohamɨyoho. Apɨlohamɨye kanɨngkwohwo sohwo Tilafoho. Tilafe kanɨngkwohwo sohwo Nahoulɨyoho. ");
INSERT INTO apz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahoulɨye kanɨngkwohwo sohwo Selokɨyoho. Selokɨye kanɨngkwohwo sohwo Leuyoho. Leuye kanɨngkwohwo sohwo Pelekɨyoho. Pelekɨye kanɨngkwohwo sohwo Epafoho. Epafe kanɨngkwohwo sohwo Syelafoho. ");
INSERT INTO apz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Syelafe kanɨngkwohwo sohwo Kainanɨyoho. Kainanɨye kanɨngkwohwo sohwo Apakɨsatɨyoho. Apakɨsatɨye kanɨngkwohwo sohwo Syemɨyoho. Syemɨye kanɨngkwohwo sohwo Nɨwafoho. Nɨwafe kanɨngkwohwo sohwo Lamekɨyoho. ");
INSERT INTO apz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekɨye kanɨngkwohwo sohwo Metuselafoho. Metuselafe kanɨngkwohwo sohwo Inoukɨyoho. Inoukɨye kanɨngkwohwo sohwo Jaletɨyoho. Jaletɨye kanɨngkwohwo sohwo Mahololelɨyoho. Mahololelɨye kanɨngkwohwo sohwo Kainanɨyoho. ");
INSERT INTO apz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainanɨye kanɨngkwohwo sohwo Enousɨyoho. Enousɨye kanɨngkwohwo sohwo Setɨyoho. Setɨye kanɨngkwohwo sohwo Atamɨyoho. Atamɨye kanɨngkwohwo sohwo Anɨtuyoho. ");
INSERT INTO apz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Anɨtuye Towahuno Wopɨngo sohwo Jisasɨye sɨmehomo uhumahonɨngki Jisas kako oso Mijo Joutan nulɨkoꞌmahonɨngki Anɨtuye Towahuno Wopɨngo sohwo Jisasɨmo hwaho wonyo aꞌamu mohumunyo soponeꞌno ipemotawomentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Oso hopo sopo Jisas kako neꞌno nohumentanɨngki Seten kako Jisasɨmo yamofo ulohofontanɨngki sɨkuno fouti (40) memjaoꞌmentisofoho. Oso hohosohonta Jisas kako wosopayo manyoꞌnjo humamojo sohwo kako mijoho engo peꞌnɨmojofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Seten kako Jisasɨmo uꞌmanto ulɨmento, Kɨko Anɨtuye Hwomu Nehwosɨꞌmanji olo sojo lomo hungkuno ulohojoꞌno wopayo umoꞌnono. ");
INSERT INTO apz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ose ulahonɨngki Jisas ulɨmento, Anɨtuye hungkuno ole nalɨwoꞌnɨngki, Aꞌamu wosopayoꞌnohini nɨngkuhwoso sohwo kako itoꞌno mohumanehoho. ");
INSERT INTO apz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ose ulahonɨngki Seten kako Jisasɨmo hwofɨkiꞌnyo poneꞌno sɨhwojamentisofoho. Osopo ntaꞌni Seten kako hwaho hopiꞌnonohino aꞌamu yofe engoꞌnjo sohwa mokosyohumawoꞌnɨngkohofoso Jisas uhwonono lonto nɨhuꞌno komoꞌno ujo ehontojwahumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Oseso Seten Jisasɨmo ulɨmento, Kɨko ngkineꞌno hwomtame ntohofohojoꞌno ngko oso hwaho hopiꞌnonohino somo mokosyohumayoꞌne yokumpohnꞌnyo soꞌnji yofe engo soꞌnji kikimo wokijapmmonneꞌno yohono. Yoꞌmayo uhwonɨngkohino loso njeꞌnohinofoho. Ngko hwe fihumo uyɨmo lɨmeꞌmanji ngko huhwo sohumo uyɨmo lɨmeso hoponoho. Kɨko ngkineꞌno hwomtame wantohoꞌmonntaho. ");
INSERT INTO apz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ose ulahonɨngki Jisas ulɨmento, Anɨtuye hungkuno ole nalɨwoꞌnɨngki, Kɨko jɨje Hwe Engo Anɨtu kakineꞌnohini hwomtame ulohofo. Kakineꞌnohini syoho ulohofiyɨmno. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Osohonta Seten kako Jisasɨmo Jelusalemmjo Anɨtuye tajo ango engo yokintaho sopo sɨhumojawento ulɨmento, Kɨko Anɨtuye Hwomu hwosɨꞌmanji kɨko olopo ntaꞌni filɨkofamofo. ");
INSERT INTO apz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ose ulɨkwato lohofonto ulɨmento, Anɨtuye hungkuno ole nalɨwoꞌnɨngki, Anɨtu kako kakoe aꞌamu ahwomomjo somo uluhwosoꞌno hofɨko kikimo hofiyo wokufoꞌmantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Hofɨko jɨje ahomo aho kumakukuji jɨje sɨfemo sojo mentofomatnnohino. Tohinoso nɨhuꞌno momatnnohino. ");
INSERT INTO apz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ose ulahonɨngki Jisas ulɨmento, Anɨtuye hungkuno ole woꞌnnyofoho. Kɨko jɨje Hwe Engo Anɨtu sohumo yamofo nulohofohotoho. ");
INSERT INTO apz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ose ulahonɨngki Seten kako Jisasɨmo yoꞌmayo yamofoso moiꞌwo ulohofonto kako nomꞌne sɨkunomo Jisasɨmo apaꞌno yamofo ulohoꞌmneꞌento uhwatɨꞌmoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisas kako hwaho Ngkalili soponeꞌno asomo umentisoso kako Anɨtuye Towahuno Wopɨngofe yokumpohnꞌnyoso hiꞌnjohwo umentisofoho. Oso hwaho Ngkalili hopo soponjo ango soꞌmeemneꞌno yoꞌmayo hungkuno Jisasɨneꞌno hoꞌnɨngkamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jisas kako tajo ango weꞌe somo humanto Anɨtuye hungkuno lutɨhwawoꞌnɨngkahonɨngki hofɨko oso hungkuno homo somo upaꞌnontɨfi kakoe yofe hoꞌnomaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas kako weꞌe sohwo humamojo ango Nasalet sopo kako engo wento oso hopo sopo humamentisofoho. Jisas kako oso ango weꞌe sopo asomo wento kako sɨkuno iyoho humayo somo Anɨtuye tajo ango weꞌe somo syuwoꞌnɨmojo somneꞌno humentisofoho. Oso ango homo somo aꞌamu humentohofo somneꞌno Anɨtuye hungkuno atofo ujoꞌne Jisas lɨkofa lohoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nolohofahonɨngki hofɨko oso hungkuno Anɨtu Aisaiyamo uyahonɨngki iyoswomo mtɨꞌmokumentisoso Jisasɨmo uyɨmentohofofoho. Jisas kako iyoswo hiso nomanto fisakuꞌmentisoso kako hungkuno ole mtɨꞌmokinyoso tɨpemaꞌmento, ");
INSERT INTO apz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Anɨtuye Towahuno sohwo kako ngkimo nɨhumanto ngkimo Anɨtuye hungkuno wopɨngo aꞌamu yoꞌmayo somneꞌno umofonyo iwoꞌnɨngkohofo somo ujoꞌne nɨhwosopoꞌmentisofoho. Olo kakoe hungkuno hiloso ujoꞌne nɨhwatɨmentiso hwoꞌnyoho. Sekwo aꞌamu impoꞌangomo intoꞌnawotofo soku sekumo impoꞌango somtaꞌni ngko isɨhutofosemahmꞌmeꞌno sekwo fohumpopmno. Sekwo aꞌamu tɨmpiꞌnyo soku apaꞌno tɨmo fohonɨmno. Aꞌamu yoꞌmayo tango uꞌmantesomo ngko sekwoe syoho nohayo semokiyoꞌne lonɨhwatɨmentiso hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Anɨtu kako kakoe aꞌamu ne somo asomo utɨmayoꞌne sɨkuno somneꞌno ujoꞌne lonɨhwatɨmentiso hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas ose ulonto kako iyoswo homo somo popojonto hwe iyoswo hiso mokosyohumawoꞌnɨngkiso sohumo uyonto kako ampo humamentisofoho. Tajo ango weꞌe somjo aꞌamuso hofɨko Jisasɨmo tɨmo yokumpohnꞌnyo humuhwontohumantohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Oseso Jisas kako kakoe hungkuno lutɨhwayoso lomaꞌmentisofoho. Ole ulɨmento, Oso Anɨtuye hungkuno mtɨꞌmokinyo somjo seloheso sekwo nupaꞌnɨngkohofoso ne imoꞌnalofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jisasɨye hungkuno homo somo upaꞌnontɨfi yomo yontɨfi hofɨko kakoe hungkuno wonyoangkafo somneꞌno huno piꞌnɨngo syafɨsyontɨfi kakoe yofe hoꞌnomantɨfi hnnɨmentohofi, Olo huno wopɨngo loso pipi tɨpemaꞌmasoto. Kako Jousepɨye hwomu hwolaho. ");
INSERT INTO apz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ose hnnɨngkahonɨngkofi Jisas hofɨkimo ulɨmento, Ngko huno niyohoho. Sekwo olo hungkuno hohonta lɨmotofo loso ngkimo wontantɨfeho. Aꞌamu somo wopɨngo imokuhwajɨwoꞌnɨngkino sohwosi kɨko kakwoꞌyohwo sohwosi wopɨngo hmmokinyo. Hungkuno yolohoso ole wontantɨfeho. Yoꞌmayo yahino wonyoangkafo kɨko ango Koponeyam humanji imotnno soꞌno nakwo nto upaꞌnɨmalohwone hopaso kɨko olo jɨje hwapɨngo loponjo aꞌamu hnꞌnɨmo fonalohofo. ");
INSERT INTO apz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ose ulonto ulɨmento, Ngko hungkuno nehopiꞌnohino waselɨmonneꞌno yohono. Aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwoe aꞌamu hwapɨngoponjoso hofɨko kakoe hungkuno somo itoꞌno minɨngkawoꞌnɨngkiyohofo. ");
INSERT INTO apz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","U, nehopi. Hohonta Ilaija kako hwaho Isɨlael humamojo sohonta ifoyo masiyoꞌnjo neꞌno nohumentanɨngkofi soswo hufaꞌu sɨhune hamno aho fehohnjo hopiꞌnonohino nomꞌne mtaꞌni angaꞌno uyakoloꞌmentisofoho. Oso hohosohonta mijoho mɨkunɨmposo iꞌmofopahonɨngki apɨwojo sofa piꞌnɨngo oso hwaho Isɨlael sopo humamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","I osoꞌno Anɨtu kako Ilaija sohumo kako kakoe hwapɨngo Isɨlael sopo apɨwojo fisimo ufoꞌmayoꞌne uhwatɨmentisoꞌmaho. Oꞌo, Anɨtu kako hwaho Saitoun ango Salefat oso ponjo apɨwojo angaꞌnohino simneꞌno yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngki yohofoso ulohofoneꞌento uhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","U, nomꞌne hungkuno mneꞌno fɨsyafɨsyo. Hohonta Ilaisa Anɨtu mtaꞌni hungkuno lutɨhwaꞌmojo sohwo humamojo sohonta oso hwaho Isɨlael sopo aꞌamu uyo nɨhuꞌno wonyoso piꞌnɨngo engoꞌnjo humamotofofoho. I osoꞌno Ilaisa kako kakoe hwapɨngoponjo aꞌamu somo wopɨngo umokumentisoꞌmaho. Oꞌo, kako hwe angaꞌno hwaho Siliyantaꞌango Naman sohumnohini wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jisas ose ulahonɨngki aꞌamu oso tajo ango homo somo humohumantohofo aꞌamuso hungkuno hiso upoꞌnantɨfi sɨmeho tohino umnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hofɨko nolɨkafontɨfi Jisasɨmo aho kompemotawentɨfi ango pone engo somo Jisasɨmo momonyomo uyohotofano lontɨfi kompemotawomentohofofoho. Oso ango antɨme hiso hwofɨkiꞌnyo yokintahopo molinyofoho. Oso hwofɨkiꞌnyo sopo nohumantɨfi Jisasɨmo hoꞌnomehwasi wohoꞌnaofano lontɨfi ko imentohofoso ");
INSERT INTO apz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jisas kako hofɨkoꞌnjo ajwoꞌmo womentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas kako hwaho Ngkalili ango Koponeyam neꞌno umentisofoho. Osopo nohumanto kako sɨkuno iyoho humayo somo aꞌamu piꞌnɨngo somo Anɨtuye hungkuno lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aꞌamuso hofɨko kakoe hungkunomo upaꞌnontɨfi yomo imentohofofoho. Hwapɨngoso aꞌamu sɨkuno iyoho humayo homo somo hungkuno lɨmotofoso hofɨkoe huno mtaꞌni majofoho. Oꞌo, nomꞌne aꞌamu ulɨmotofoso ulɨmotofofoho. I, Jisas Anɨtuye huno ne somtaꞌni hungkuno wopɨngo tɨpemanto yokumpohnꞌnyo soꞌnohini lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Oso tajo ango weꞌe homo somo hwe towahuno wonyoꞌnjo fihwo nohumanto kako mango mohmꞌno ole ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Hoe, Jisas Nasaletnntaꞌango sohwosi, kɨko nakumo peho wonalohoꞌmneꞌno sopalokuno. Kɨko nakumo wonyo wonamokumonneꞌno losopalokuno. Ngko kikineꞌno huno niyohoho. Kɨko Anɨtuye Hwomu Wopɨngo Ne hwosoho. ");
INSERT INTO apz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ose ulahonɨngki Jisas kako towahuno wonyo sohumo yoka ulɨmento, Mampiꞌnyo fosyohumaho. Kɨko olo hwe lohumo ulɨkoꞌmaho. Ose ulahonɨngki towahuno wonyo huhwo sohwo kako hwe sohumo aꞌamu piꞌnɨngoꞌnjo sopo hwahopo yohotofasyonto ulɨkoꞌmanto hwe sohumo nomꞌne tohino muyoꞌnjo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Aꞌamu ose uhwonontɨfi yomo engo yontɨfi hofɨko mjahnnɨmmentohofi, Olo hungkuno yokumpohnꞌnyo hiloso peho hungkuno ulahonɨngki humpehofo towahuno wonyo sohwafo. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Oseso Jisasɨmneꞌno hungkunoso angoꞌmeemneꞌno hoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas kako oso tajo ango somtaꞌni swaponto Saimounɨye angomo humentisofoho. Saimounɨye konemi siye aꞌapahoso tohohmtnno mɨkunɨmposoꞌnjoho. Oso hisoꞌno hofɨko Jisas oso aꞌmu simo ufoꞌmayoꞌno joho lutɨmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jisas kako aꞌmusi fosyowentanjo sopo lohofawento kako aꞌapaho tohohmtnno hwapɨngo sohumo yoka ulɨmento, Kɨko mpano. Ose ulahonɨngki kakoe aꞌapaho tohohmtnnoso moiꞌwo imoꞌnɨmentisofoho. Moiꞌwo imoꞌnɨngkahonɨngki aꞌmusi kako komoꞌno nolɨkafonto aꞌamumne wopayo iloho humisyofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mofehiꞌnyo ikwoꞌmokahonɨngki hwe moyaꞌmi hofɨkoe aꞌamu mnokinoꞌnjo somo Jisasɨꞌnjo soponeꞌno motɨhuꞌmokumentohofofoho. Kako aꞌamu angaꞌno angaꞌnohino homo somo aho kisasyonto kako hwe moyaꞌmi hopiꞌnonohino somo wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jisas kako hwe moyaꞌmi piꞌnɨngo engo somtaꞌni towahuno wonyo wae yaoꞌmentisofoho. Oso towahuno wonyo hiso hofɨko joho mohmꞌno ole ulɨmentohofi, Kɨko Anɨtuye Hwomu Ne hwosoho. Ose ulɨmentohofofoho. Hofɨko Jisas Kɨlais sohwo ahwomo mtaꞌni Anɨtu uhwatɨmentiso hweho huno umentiso soꞌno Jisas hofɨkimo yoka ulɨmento, Sekwo nomꞌne hungkuno ulɨkutoho. Ose ulahonɨngki hofɨko mampiꞌnyo humamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Imɨngo ne soꞌnji Jisas oso ango hopo sopo nulɨkoꞌmanto hwaho aꞌamu mohumunyo soponeꞌno ngkoꞌnohini weꞌenehwo wohumamo lonto umentisofoho. I osoꞌno hwe moyaꞌmi hofɨko hafɨhafe tɨpmꞌmantɨfi uꞌmaꞌmentohofofoho. Uꞌmantɨfi yokumpohnꞌnyo ulɨmentohofi, Kɨko nakumo nonahwotɨꞌmofohotoho. Kɨko nakwo Koponeyam lopo wohumentɨhwano. ");
INSERT INTO apz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ose ulahonɨngkofi kako ulɨmento, Aꞌamu angoꞌmeemjo somo Anɨtu kako wopɨngo wosemokosyohumamteꞌno yalokunjo soꞌno ngko hofɨkimo hungkuno wopɨngo hiso wolɨjumoꞌmonneꞌno yohono. Anɨtu kako oso syoho hisoꞌno nɨhwatɨmentiso hwoꞌnyoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Oseso Jisas kako Anɨtuye hungkuno wopɨngoso hwaho Jutiya soponjo tajo ango angaꞌno angaꞌnohino somo humolutɨhukuꞌmofisofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sɨkuno nomꞌnemo Jisas kako mijo ayo Ngkenesalet momɨngo sopo nohumentanɨngki hwe moyaꞌmi piꞌnɨngo engoso Anɨtuye hungkuno upoꞌnano lontɨfi hofɨko Jisasɨꞌnjo mofonepo wohumano lontɨfi yohoto yohotofo mjalohoꞌnɨmopmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jisas kako aꞌamu homo somo uhwononto uhwonɨmentisoso yofayokino weꞌe hufaꞌu sohwaꞌu ifohohosasyonji nowentanɨngki hofekwosa sohwa hofɨko inanɨku ifamiyo hoꞌyoso mijo yojɨjwontanɨngkofi uhwonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas kako Saimounɨye yofayokino somo kotasonto Saimounɨmo ulɨmento, Yofayokinoso nonje weꞌenehwo usitofo. Ose ulonto Jisas kako aꞌamu somo yofayokino mijo sopo wentanjo sopo ampo humanto Anɨtuye hungkuno lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Aꞌamu somo lutɨhwa lohofonto Jisas kako Saimounɨmo ulɨmento, Yofayokino mijo ajwo nomponeꞌno motayo. Osopo kɨko jɨje aꞌamu sohwanji inanɨku ifamiyo hoꞌyoso mijo ajwo nompo fohoꞌnaopmno. ");
INSERT INTO apz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ose ulahonɨngki Saimoun ulɨmento, Hwe Engofo, olo sɨkwoꞌmiyo lomo nakwo inanɨku ufomeeno lontani syoho yokumpohnꞌnyo ko yɨhwoneso wonyopi ihwonefoho. Siki iyoho lonkononasiso hwonaꞌnyoho. I osoꞌno kɨko ntohino soꞌno ngko inanɨku ifamiyo hoꞌyoso wohoꞌnaoꞌmne yohono. ");
INSERT INTO apz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ose ulahonɨngki hofɨko hoꞌnaoꞌmentohofo hiso inanɨku piꞌnɨngo engo ifammentohofoso inanɨku ifamiyo hoꞌyoso weꞌenepi wamtɨhupoꞌmonto imentiso soꞌno ");
INSERT INTO apz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","hofɨko nomꞌne yofayokino soponjo aꞌamu sohwamneꞌno hofɨkimo ufoꞌmayoꞌne joho lutɨmaꞌmentohofofoho. Hofɨko mofone lopo nopontɨfi inanɨku ifamiyo hoꞌyoso hoꞌnomaꞌmentohofoso oso yofayokino hufaꞌu sohwaꞌumo inanɨku nojaofonto yofayokino sohwaꞌu mijomo wemotoswamonto imentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimoun Pita kako yoꞌmayo iꞌmofapmmentiso somo uhwononto kako Jisasɨye sɨfɨkiꞌnyo soꞌmo hwomtame ulohofonto ulɨmento, Hwe Engofo, kɨko ngkimo nɨhwotɨꞌmofohoji mpano. Ngko hwe wopɨngohwonɨꞌmaho. Wonyo hwoꞌnyoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Hwapɨngoso kako oso inanɨku ifammentohofo somo uhwononto iyoho unɨngkahonɨngki ulɨmentisofoho. Kakoꞌnohinɨꞌmaho. Oꞌo, aꞌamu yofayokinopo humohumantohofo huhwanji iyoho imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sepetiye hwomu sohwaꞌu Jemɨsɨꞌnji Jounꞌnji siko Saimounꞌnji syoho afaꞌno imotofo sohwaꞌu siko huhwaꞌu uhwononji iyoho imentisiyefoho. Oseso Jisas kako Saimounɨmo ulɨmento, Kɨko iyoho yohotoho. Olo inanɨku ifamehino hopaso kɨko hwangku hwe moyaꞌmi ngkoꞌnji songo neꞌno humayoꞌne somo utɨmatnne hwosoho. ");
INSERT INTO apz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ose ulahonɨngki hofɨko yofayokino mitɨmomɨngo noꞌmo ifohohosasyontɨfi hofɨkoe hoꞌyango yoꞌmayoso ulɨkoꞌmantɨfi Jisasɨmo inɨngkamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisas kako ango fipo nohumanto uhwonɨmentisoso hwe fihwo aꞌapaho uyo wonyoꞌnjo sohwo nohumentanɨngki uhwonɨmentisofoho. Oso hwe huhwo sohwo kako Jisasɨmo uhwononto kako Jisasɨye sɨfɨkiꞌnyoꞌmo ipitofawento hungkuno yokumpohnꞌnyo ulɨmento, Hwe Engofo, Kɨko ngkimo wopɨngo wanɨmokumo lisoꞌmanji jɨje yokumpohnꞌnyoso hoponoho. ");
INSERT INTO apz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ose ulahonɨngki Jisas kako aho kisusyonto hwe sohumo ulɨmento, Ou wopɨngo wakumokumonneꞌno yohono. Kɨko wopɨngo hmmoꞌnyo. Ose ulɨmentiso soꞌno oso uyo wonyo huhwo sohwo moiꞌwo komoꞌno imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Oso moiꞌwo imoꞌnɨngkahonɨngki Jisas hungkuno yokumpohnꞌnyo ulɨmento, Ngko jɨje aꞌapaho wopɨngo kumokohe soꞌno kɨko nomꞌne aꞌamu somo nulohotoho. Oꞌo, kɨko komoꞌno nowehoji oso aꞌamu tajo angomjo syohoꞌnjo sohumo jɨje aꞌapahoso utɨhwaho. Utɨhwahojoꞌno kɨko oso yahino Mouses netɨhwamentisoso ose hopa fiyo. Kɨko wosopayo yoꞌmayoso nomahoji hwe huhwo sohumo uyohojoꞌno kako Anɨtumneꞌno wohoꞌnasyono. Aꞌamu oso homo somo uhwonɨngkuji jɨje aꞌapaho uyo wonyoso wopɨngo imoꞌnɨngkiso soꞌno huno wosyofɨsyantɨfeho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","I Jisas kako ose imentiso hisoꞌno angoꞌmeemo hoꞌnɨmmentisofoho. Aꞌamu piꞌnɨngo engo oso hungkuno hisoꞌno upaꞌnontɨfi ole syafɨhuꞌmentohofi, Nakwo kakoe hungkuno upoꞌnɨngkuhwasoꞌno kako nakumo wopɨngo wonamokumontonoho. Ose syafɨsyontɨfi hofɨko Jisasɨmo uꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","I osoꞌno Jisas kako sɨkuno piꞌnɨngo engo somo hwaho aꞌamu mohumunyo sopo nowento kanɨngkwohwo Anɨtumo jomo ulɨmojofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sɨkuno fihumo Jisas kako hwe moyaꞌmi somo Anɨtuye hungkuno lutɨhwentanɨngki aꞌamu Falisi sohwanji aꞌamu Jutafe honɨngkano hungkuno lutɨhwamotofo sohwanji hofɨko huhwa humunyoponoho. Oso aꞌamu huhwo sohwa hofɨko hwaho Ngkalili ango hopo sopontaꞌango sohwanji hwaho Jutiya ango hopo sopontaꞌango sohwanji ango Jelusalem soponjo sohwanji hofɨko Jisasɨꞌnjopo uꞌmantɨfi humamentohofofoho. Anɨtuye yokumpohnꞌnyo engoso aꞌamu mnokinoꞌnjo somo wopɨngo umokiyoꞌne Jisasɨmo woꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aꞌamu fehohnjoso hofɨko hwe fihwo sɨfe aho peꞌnnyo sohumo ijempohopo Jisasɨyepono itokwapmmentohofofoho. Itokwapontɨfi ango ne moꞌmo Jisas humentanjo sopo utofosyano lontɨfi ko imentohofoso ");
INSERT INTO apz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","hwe moyaꞌmi piꞌnɨngo engo ango huhwo sohwi nto uhuloꞌofahonɨngkofi hofɨko mitofomojiꞌmofayoꞌnjo imentohofofoho. Oseso hofɨko ango antɨfepo kotosantɨfi ikuꞌyo fehohnjo nofentɨfi hwe mnokinoꞌnjo huhwo sohumo kakoe ijempoho hiꞌnji antɨfepo ntaꞌni ango moꞌmneꞌno impe monje intofuyohoꞌmokumentohofofoho. Oso hwe huhwo sohumo Jisasɨye sɨmanopo mehoꞌnahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisas kako uhwonɨmentisoso oso aꞌamu itokwapmmentohofo sohwa hofɨko Jisasɨmo sɨmeho hiꞌntnnono yokumpohnꞌnyo uyahonɨngkofi Jisas uhwononto hwe mnokinoꞌnjo sohumo ulɨmento, Nje aꞌamu sohwosi ngko jɨje honɨngkano wonyoso wae nto yakumofohono. ");
INSERT INTO apz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ose ulahonɨngki aꞌamu Jutafe honɨngkano hungkuno lutɨhwamotofo sohwanji aꞌamu Falisi sohwanji Jisasɨye hungkunomo upaꞌnontɨfi hungkuno piꞌnɨngo hnnɨmentohofi, Olo hwe lohwo Anɨtumneꞌno sitofo ulalokunjo lohwo sohwo tɨhwolo. Nakwo aꞌamu hwahoponjo hnꞌnwi aꞌamufe honɨngkano wonyo wae yɨmofoꞌneso hopoꞌmaho. Oꞌo, Anɨtu kakoꞌnohino hoponoho. ");
INSERT INTO apz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ose hnnontanɨngkofi Jisas kako hofɨkoe huno somjo hungkuno soꞌno huno uyahonɨngki ulɨmento, Ngko Anɨtumneꞌno sitofo ulalokwe somneꞌno sekwo huno pehoꞌno syofɨsikomoꞌnalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Anɨtu kako ngkimo aꞌamumo ufoꞌmayoꞌne nɨhwatɨmentiso sohwoꞌni olo hwaho lopo aꞌamufe honɨngkano wonyo wae yaofoꞌne yokumpohnꞌnyoso hiꞌnjo hwoꞌnyoho. I osoꞌno aꞌamu fihwo jɨje honɨngkano wonyo wae weekumoꞌmo loso sohwoe hungkuno somo ne imoꞌnyo soꞌno sekwo sɨmeho moꞌmo muhwonɨfitnne kuyoho. Oso yokumpohnꞌnyo ngko seloheso hiꞌnjo sohwoꞌni utɨhwaꞌnyopo setɨhwahmꞌmeꞌno hungkuno nomꞌne kengoso hwe lohumo ulɨmonneꞌno yohono. Hofɨkimo ose ulonto kako hwe mnokinoꞌnjo sohumo ulɨmento, Kɨko nolɨkafohoji jɨje ijempohoso nomahoji jɨje angopo neꞌno mpano. ");
INSERT INTO apz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jisas ose ulahonɨngki aꞌamu tɨmo uhwontohumentanɨngkofi oso hwe huhwo sohwo kako komoꞌno nolɨkafonto kakoe ijempohoso nomanto kakoe ango poneꞌno nowento kako Anɨtuye yofe engoso hoꞌnomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Oso ango hopo soponjo aꞌamuso hofɨko uhwonontɨfi hi umoꞌnɨngkahonɨngki hofɨkoe sɨmeho moꞌmo yomo yomo uꞌmahonɨngki hofɨko Anɨtuye yofe engoso hoꞌnomaꞌmentohofofoho. Ole lɨmentohofi, Olo wonyoangkafo uhwonɨngkuhwone loso yahino nɨhuꞌno wonyoangkafofoho. Ose mjalɨmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tɨfi sohonta Jisas kako hano emoyonto uhwonɨmentisoso hwe fihwo aꞌamu mtaꞌni hamniyoho mayo syohoꞌnjo sohwo kakoe yofe Lifaiyo sohwo nohumentanɨngki uhwononto ulɨmento, Kɨko ngkimo tɨfi nnɨngkape. ");
INSERT INTO apz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ose ulahonɨngki Lifaiyo nolɨkafonto kakoe yoꞌmayoso ulɨkoꞌmanto Jisasɨmo tɨfi inɨngkamentisoso kakoe inomokomoyo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lifai kako Jisasɨmneꞌno kakoe angomo wopayo iloho engo imentisofoho. Oso wosopayo engo hisoꞌno aꞌamu mtaꞌni hamniyoho mayo syohoꞌnjo sohwanji aꞌamu nomꞌne sohwanji Jisas kakoe inomokomoyo huhwanji oso hopo sopo nohumantɨfi wopayo nɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aꞌamu Falisi sohwanji nomꞌne aꞌamu Falisi huhwa honɨngkano hungkuno lutɨhwayo syoho imotofo sohwanji hofɨko nohumantɨfi aꞌamu wopayo nontanɨngkofo sohwamo uhwonontɨfi Jisasɨye inomokomoyo sohwamo ulɨmentohofi, Sekwo aꞌamu mtaꞌni hamniyoho fehohnjo siki mayo syohoꞌnjo sohwanji aꞌamu honɨngkano wonyoꞌnjo soꞌnji wopayoso pehoꞌno nalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ose ulahonɨngkofi Jisas ulɨmento, Aꞌamu mnokino aneꞌnjo wopɨngo humalofoso hofɨko aꞌamu uyohofahosiyoꞌnjo sohumo muꞌmapitnnehofo. Oꞌo, aꞌamu mnokinoꞌnjo soꞌnohini uꞌmantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Oso paꞌnyoso ngko aꞌamu honɨngkano wopɨngoꞌnjo hwonaꞌnyoho lɨwoꞌnɨngkohofo somneꞌno joho ujoꞌne lutɨmayoꞌne pmmentohe hwonɨꞌmaho. Oꞌo, ngko aꞌamu honɨngkano wonyoꞌnjoso hofɨkoe wonyo somneꞌno hohujo ikinjaofɨkuji ngkimo nnɨngkape-eꞌne joho ujoꞌne pmmentohe hwoꞌnyoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ose ulɨmentisoso hofɨko Jisasɨmo ulɨmentohofi, Jounɨye inomokomoyo sohwa hofɨko sɨkuno fehohnjo somo hofɨko Mpohumo jomoꞌnohini ulɨwoꞌnontɨfi wosopayo hopiꞌnonohinoso manɨwoꞌnɨngkiyohofɨhwafoho. I aꞌamu Falisi sohwafe honɨngkanomo inɨngkawowoꞌnɨngkohofo huhwanji oso yahinoso iwoꞌnɨngkohofɨhwafoho. I osoꞌno jɨje inomokomoyo sohwa hofɨko wosopayo soꞌnji mijo soꞌnji nonje nonjeꞌnohino nɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ose ulahonɨngkofi Jisas kakineꞌno olo pahnnɨmo hungkuno loso ulɨmento, Hwe fihwo kako ape maso sohonta kako kakoe aꞌamuꞌnji nohumantɨfi hofɨko kakineꞌno sɨmonyo iyo soꞌno wosopayo manyoꞌnjo iwoꞌnɨngkohofotaho. Oꞌo, awonoho. Hofɨko kakineꞌno sɨmonyo engo yontɨfi wopayo engo nɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","I oseso hwangku sohonta oso hwe ape maso huhwo sohumo aꞌamu nomꞌne sohwa hofɨko kakoe aꞌamu mtaꞌni kompemafɨkuji fonjasyɨkujoꞌno kakoe aꞌamu hiso kako ane humafɨkujoso sɨmeho tangoꞌnjo humafɨkuji wosopayo manyoꞌnjo uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ose ulonto Jisas kako kakoe yahino songo somneꞌno pahnnɨmo hungkuno hufaꞌu ole ulɨmento, Hwe fihwo kako manjiꞌmofo tontamo imoꞌnnyo somo wopɨngo wamtɨꞌmokumo lɨhwosi kako hwapɨfe yokumpohnꞌnyo songo somtaꞌni tɨfonehwo sɨsɨmpehwosi lojwoma lohofɨhwosi manjiꞌmofo tontamo somo lojwohofojasyososo wopɨngo umoꞌnɨmontolaho. Oꞌo, oso hwapɨfe songoso manjiꞌmofo yofoho somo wohofojahumo lɨhwosi sɨsɨmpemaso somtaꞌni wonyo umoꞌnɨmontonoho. Manjiꞌmofo tontamo huhwo sohumo lojwohofojasyoso hiꞌnji apaꞌno wonyo wasɨsɨmpoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ose ulonto Jisas pahnnɨmo hungkuno tɨfinjoso ole ulɨmento, Aꞌamu fihwo kako mijo iloho uyɨmo lɨhwosi te fɨsiyo womaꞌmontolaho. Oꞌo, awonoho. Kako te fɨsiyo mahwosi mijo ihmꞌmofɨhwosi iloho yososo mijo wahumpoꞌmontonoho. Te fɨsiyoso nɨhuꞌnahone wonyo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","U, hwe huhwo sohwo kako te songoso mahwosi mijo ihmꞌmofɨhwosi iloho yososo mijo itoꞌno wolɨfawoꞌmontonoho. Oso paꞌnyoso hohontajo yahino soꞌnji yahino songo soꞌnji nemꞌno huꞌmokomokosyohumayoso hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aꞌamu fehohnjo hofɨko hohontajo yahino soꞌno hi umoꞌnɨngkahonɨngki hofɨko yahino songoso nakwolaho lontɨfi hohontajo somo yokumpohnꞌnyo mokosyohumawoꞌnɨngkohofofoho. Oso paꞌnyoso aꞌamu hohontajo yahino wopayo manyo humayo iwoꞌnɨngkohofoso hofɨko nje yahino songo losetɨhwalokwe somneꞌno nakwolaho wolantɨfeho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sɨkuno iyoho humayo fihumo Jisas kakoe inomokomoyo sohwanji hofɨko syohopo hano humemoyohofofoho. Inomokomoyo huhwo sohwa mijoho uyahonɨngki wopayo weꞌe songoso nomantɨfi aho hwosoꞌmokontɨfi pahoso fuyo laofontɨfi neso nɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ose yahonɨngkofi aꞌamu Falisi fehohnjo sohwa uhwonontɨfi ulɨmentohofi, Nakwoe honɨngkano hungkunoso yoꞌmayo syoho sɨkuno iyoho humayo somo iyoꞌneso hano pitofahinyofoho. Oso hisoꞌno sekwo olo sɨkuno iyoho humayo losomo wopayo pehoꞌne mantɨfi nɨngkohofoto. ");
INSERT INTO apz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Sekwo Ntefit imentiso soꞌno iyoswo mtɨꞌmokumentohofoso atofo majo hwasilaho. Oso sɨkuno Ntefit kakoe aꞌamu soꞌnji mijoho engo humamentohofo sohontaꞌneꞌno selohonɨngkono. ");
INSERT INTO apz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ntefit kako Anɨtumneꞌno hwapɨfe ango molinyo somo swonto wosopayo Anɨtuye sɨmanopo hoꞌnahinyoso swomaꞌmentisofoho. Oso wosopayo hiso aꞌamu sikinjo somneꞌmaho. Oꞌo, aꞌamu Anɨtuye tajo ango syohoꞌnjo sohwamneꞌnohinofoho. I osoꞌno Ntefit kako nononto kakoe aꞌamu sohwamo nuyɨmentisofoho. Sekwo oso hungkuno homo somo atofo majoꞌnjo imentohofo soꞌno sekwo nje inomokomoyo sohwamo oso hungkuno hiso ulohonɨngkohofotaho. ");
INSERT INTO apz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jisas ose ulohononto ole ulɨmento, Ngko Aꞌamufe Hwomu sohwoꞌni ngko sɨkuno iyoho humayoꞌneso hwapɨngo hwoꞌnyoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sɨkuno iyoho humayo nomꞌne somo Jisas kako Anɨtuye tajo ango weꞌe sohumo noswonto hwe moyaꞌmi somo Anɨtuye hungkuno ulɨmentisofoho. Osopo nohumentanɨngki hwe fihwo aho angahohnjoso songo songo miyo poyo hopa woꞌnnyo sohwo humunyoponoho. ");
INSERT INTO apz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aꞌamu fehohnjo aꞌamu Jutafe honɨngkano hungkuno lutɨhwayo syohoꞌnjo sohwanji aꞌamu Falisi sohwanji hofɨko nohumantɨfi Jisasɨmo hungkuno itoꞌno muhwajiyo ango somo ipemotowaneꞌentɨfi ole syafɨhuꞌmentohofi, Jisas kako sɨkuno iyoho humayo lomo hwe aho wonyoꞌnjo sohumo wopɨngo umokumontolɨkeno. Ose syafɨsyontɨfi Jisasɨmo uhwontohumamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jisas hofɨkoe huno soꞌmjo yahino soꞌno huno uyahonɨngki hwe aho wonyoꞌnjo sohumo ulɨmento, Kɨko nolɨkafohoji olo ajwo lopo filohofo. Ose ulahonɨngki kako nolɨkafonto ajwopo lohoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Oseso Jisas kako aꞌamu huhwo sohwamo ulɨmento, Ngko sekumo waselohonɨmonneꞌno yohono. Oso honɨngkano hungkuno Mouses neyakwosamo uyɨmentisoso sɨkuno iyoho humayo lomneꞌno pehofo nalohoho. Nakwo olo sɨkuno lomo yahino wopɨngo uyantantaho. Wonyo uyantantaho. I nomꞌne aꞌamu somo wopɨngo umokantantaho. Wonyo umokantantaho. ");
INSERT INTO apz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ose ulonto aꞌamuꞌnjo soꞌmo tɨmo feꞌnɨhwononto hwe aho wonyoꞌnjo sohumo ulɨmento, Jɨje ahoso sɨhwaho fisɨpofo. Ose ulahonɨngki hwe huhwo sohwo kako kakoe aho sɨhwaho sɨpeehonɨngki wopɨngo umoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aꞌamu huhwo sohwa ose uhwonontɨfi sɨmano hntotohino umnɨngkahonɨngki hofɨko ole hnnɨmentohofi, Nakwo Jisasɨmo pipi ulohofanehwono. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Oso hohosohonta Jisas kako Mpohumo jomo ulɨmo lonto kako hwofɨkiꞌnyo weꞌe soponeꞌno sɨmentisofoho. Osopo nohumanto Anɨtuneꞌno jomo neꞌno ulontanɨngki iyoho longkonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mofehiꞌnyo sɨꞌmofopahonɨngki Jisas kakoe inomokomoyo sohwamneꞌno joho ulonto oso hwa mtaꞌni kako hwe aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo uhwosopoꞌmentiso sohwamo kako yofe mulɨmentisoso apouselɨyoho mulɨmentisofoho. Oso yofe apouselɨso hungkuno hwapɨngoso olenoho. Anɨtuye hungkuno lɨkuꞌmofo syohoꞌnjo hwafoho. ");
INSERT INTO apz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Hwe fihwo uhwosopoꞌmentisoso Saimounɨyoho. Oso hwe huhwo sohumo Jisas kako nomꞌne yofe Pitafoho mulɨmentisofoho. Nomꞌnihwo Entɨlu Saimoun Pitafe konɨngkwaꞌwe hweho. Nomꞌnihwaꞌu Jemɨsɨꞌnji Jounꞌnjoho. Nomꞌnihwaꞌu Filipɨꞌnji Mpatoulomɨyuꞌnjoho. ");
INSERT INTO apz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Nomꞌnihwaꞌu Matɨyuꞌnji Toumasɨꞌnjoho. Nomꞌnihwo Jemɨs Alɨfiyosɨye hwomu hweho. Nomꞌnihwo Saimounɨyoho. Kakoe yofe nomꞌneso Seloutɨyoho. ");
INSERT INTO apz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Nomꞌnihwo Jutas Jemɨsɨye hwomu hweho. Nomꞌnihwo Jutas Isɨkaliyoutɨyoho. Kako Jisasɨmneꞌno kakoe mango sohwamo tokoyoꞌofo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Oseso Jisas kako hwofɨkiꞌnyopo ntaꞌni kakoe inomokomoyo sohwanji nowentɨfi hintafo somo uꞌmofawentɨfi osopo inomokomoyo piꞌnɨngo engo sohwanji lohoꞌmentohofofoho. Oso hopo sopo nomꞌne hwe moyaꞌmi piꞌnɨngo engoso hwaho Jutiyantaꞌango soꞌnji ango Jelusalem soꞌnji oso ango hufaꞌu mitɨmomɨngo soponjo molinyo sohwaꞌu Taiyaꞌnji Saitounꞌnjontaꞌango uhuꞌmokontɨfi humamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Aꞌamu hiso nakwo Jisasɨye hungkuno upoꞌnɨngkuhwasi aꞌamu mnokinoꞌnjo hnꞌnɨmo wopɨngo wonamokono lontɨfi uhuꞌmokumentohofofoho. Aꞌamu towahuno wonyo ehuhnnamoꞌnnyoꞌnjo soꞌnji Jisasɨmo uꞌmahonɨngkofi kako wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Oseso hwe moyaꞌmi hopiꞌnono hofɨko Jisasɨmo aho wokisyusyano lontɨfi imentohofofoho. Hwapɨngoso hofɨko Jisasɨmo aho kisusyahonɨngkofi yokumpohnꞌnyo Jisas mtaꞌni hofɨkimo umentisoso hofɨkoe aꞌapahoso wopɨngo imoꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas kakoe inomokomoyo sohwamo uhwononto ole ulɨmento, Sekwo Anɨtuneꞌno huno engo maseyoꞌnjo soku sekwo Anɨtumneꞌno huno wopɨngo wotɨpemano lɨfijoꞌmanji sekwo sɨmeho wopɨngo wasemoꞌnono. Anɨtu sekumo semokosyohumayo hweho. ");
INSERT INTO apz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sekwo wopayo mijoho peꞌnyo soku wopayoꞌno hi semoꞌnyo hopaso sekwo Anɨtuye honɨngkano wopɨngo mneꞌno hi semoꞌnosoꞌmanji Anɨtu kakoe hungkuno sekwoe sɨmehomo wopayo sɨmeho hopaso wosehnnɨmontonoho. Oseso sekwoe sɨmeho wopɨngo wasemoꞌnono. Sekwo aꞌamu olohonta humotaho lalokwofo soku sekwo sɨmonyo fiyɨmno. Hwangku sekwo tɨkafo wojantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Hwangku sekwo ngko Aꞌamufe Hwomu sohwoꞌnɨmneꞌno nnɨngkopalokwofo soꞌno aꞌamu nomꞌneso sehonɨngkuji hofɨko sekuneꞌno sɨmeho nɨhuꞌno wonyo umoꞌnɨmontonoho. Osoꞌno hofɨko sekumneꞌno hohujo ikinjasemofɨkuji sitofo woselantɨfeho. Hofɨko sekuneꞌno hungkuno nɨhuꞌno wonyo selɨkujoꞌno sekwoe yofeso wopɨwahuꞌmontonoho. Yoꞌmayoso ose selohofɨkujoꞌno sekwo sɨmonyo fiyɨmno. Hwapɨngoso sekwo upaꞌnɨmno. Sekwo nje yofe somneꞌno yoꞌmayo tango olo seꞌmante soꞌno sekwoe hoꞌyango engo yoꞌmayoso ahwomomo weho. Oso aꞌamu sekumo wonyo selohofalokwofo hofɨkoe ajuyohwosa huhwa hohonta aꞌamumo Anɨtu kakoe hungkuno uyahonɨngki lɨmotofo sohwa huhwamo wonyo ulohoꞌmotofɨhwafoho. ");
INSERT INTO apz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","I osoꞌno sekwo aꞌamu hamniyoho hoꞌyango yoꞌmayoso engo yokumpohnꞌnyo mokosyohumunyo soku Anɨtu tohino nejaponoho lɨkuji sekwo iyoho wasenono. Sekwoe sɨmeho wopɨngo semokiyoꞌne yoꞌmayoso olo hwaho lopo nto moꞌmalofo kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Sekwo aꞌamu olohonta wosopayo engo nonontɨfi sɨmeho nohnnalokwofo soku sekwo Anɨtumneꞌno inɨngo nayonoho lɨkuji iyoho wasenono. Hwangku sekwo mijoho engo nopeꞌnɨfitnne kuyoho. Sekwo aꞌamu olohonta tɨkafo jalokwofo soku hwangku nakwo humotaho engo lɨhwasi tɨmijo engo neswaponoho lɨkuji sekwo iyoho wasenono. ");
INSERT INTO apz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Sekwo aꞌamu soku aꞌamu nomꞌne piꞌnɨngoso hofɨko sekwoe yofe hoꞌnosemawoꞌnɨngkohofo soꞌmanji Anɨtu nakwoe yofe mohoꞌnonemanoho lɨkuji sekwo iyoho wasenono. Hohonta oso aꞌamu huhwo sohwafe ajuyohwosa huhwa aꞌamu Anɨtuye hungkuno hwasyo lɨmotofo sohwafe yofe hi hoꞌnomaꞌmotofofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Sekwo nje hungkunomo haloho pewoꞌnɨngkohofo soku sekwo upaꞌnɨmno. Sekwo sekwoe mango sohwamneꞌno wasemoꞌnono. Aꞌamu sekumo sɨmeho wonyo sejapɨwoꞌnɨngkohofo somo sekwo hofɨkimo wopɨngoꞌnohini ulohopmno. ");
INSERT INTO apz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aꞌamu fehohnjoso hofɨko sekumo wonyo wosemokano lontɨfi sɨfajo selɨkujoꞌno sekwo oso aꞌamu homo somo Anɨtu kako wopɨngo ulohofoꞌne jomo ulɨmno. Aꞌamu sitofo selɨkujoꞌno sekwo aꞌamu homo somneꞌno Anɨtu ufoꞌmayoꞌne jomo ulɨmno. ");
INSERT INTO apz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aꞌamu fihwo jɨje manjijohopo kuposɨhwosoꞌno jɨje manjijoho fehohntaꞌni utɨhwaho osopo wakuposono. Hwe fihwo kako jɨje manjiꞌmofo soꞌno hi umoꞌnɨngkuhwosoꞌno kumahwosoꞌno kɨko yoka ulohotoho. Oꞌo, jɨje hwapɨfe hiꞌnji uyo. ");
INSERT INTO apz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","U, hwe fihwo kako yoꞌmayo soꞌno jomo kilɨhwosoꞌno kɨko yanoꞌnohino uyo. U, hwe fihwo kako jɨje yoꞌmayoso wae yakumofɨhwosoꞌno kɨko apaꞌno aku kijape-eꞌne hungkuno ulohotoho. ");
INSERT INTO apz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sekwo yoꞌmayo yahino aꞌamu sekumo woselohofantɨfeꞌno yalokwofo hopaso sekwo sɨmoꞌmo oso yahino hiso hofɨkimo ulohopmno. ");
INSERT INTO apz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Aꞌamu sekumneꞌno umoꞌnɨwoꞌnɨngkohofo osomnohini sekwo hofɨkineꞌno semoꞌnɨngkuwo soꞌno Anɨtu kako peho wopɨngo waselohoꞌmontolo. Awonoho. Aꞌamu honɨngkano wonyoꞌnjo Anɨtumneꞌno mosyafɨsiyo hi oso hopa yɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aꞌamu sekumo wopɨngo selohofɨwoꞌnɨngkohofo osomnohini sekwo wopɨngo ulohofɨkujɨꞌmanji oso hisoꞌno Anɨtu kako peho wopɨngo waselohoꞌmontolo. Awonoho. Aꞌamu honɨngkano wonyoꞌnjo Anɨtumneꞌno mosyafɨsiyoꞌnjo hi oso hopa yɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sekwo sekwoe yoꞌmayo soꞌno hwangku aku nejapɨfitnneꞌentɨfi uyɨwoꞌnɨngkohofoꞌmanji Anɨtu kako peho wopɨngo waselohoꞌmontolo. Awonoho. Aꞌamu honɨngkano wonyoꞌnjo Anɨtumneꞌno mosyafɨsiyoꞌnjo hi oso hopa yɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Oꞌo, sekwo olo yahino loso fiyɨmno. Sekwo sekwoe mango sohwamneꞌno wasemoꞌnono. Hofɨkimo wopɨngo ulohopmno. Aꞌamu sekumo yoꞌmayo soꞌno jomo selɨkujoꞌno nakumo aku wonejapɨfe sekwo huno nosyafɨsyɨkutoho. Sekwo oso yahino somo inɨngkafijoꞌmanji Anɨtu kako yoꞌmayo wonyoangkafoso sejapɨhwosi sekwo Anɨtu Yokintahopo Humaso sohwoe Mehomi Ne umoꞌnantɨfeho. Hwapɨngoso Anɨtu kako aꞌamu kakineꞌno isamoyoka mujoꞌnjo soꞌnji aꞌamu honɨngkano nɨhuꞌno wonyoꞌnjo soꞌnjimo wopɨngo ulohofɨwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Senɨngkwohwo Anɨtu sohwo kako aꞌamu hopiꞌnonohino somneꞌno hitoho ulofɨwoꞌnɨngkiso hopaso sekwo aꞌamu hopiꞌnonohino somneꞌno hitoho waselofono. ");
INSERT INTO apz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Sekwo nomꞌne aꞌamufe hunomo yano ilofɨkuji wonyofoho nulɨkutoho. Ose ifijoꞌmanji Anɨtu huhwo sekwoe huno somneꞌno wonyofoho maselonehoho. Sekwo nomꞌne aꞌamufe yahino somneꞌno tohino uyɨkutoho. Ose ifijoꞌmanji Anɨtu huhwo sekwoe yahino somneꞌno tohino mosejaponehoho. Aꞌamu sekumo wonyo selohopijosofe wonyoso sekwo wae feeopmno. Oso wonyo hisoꞌno apaꞌno huno nosyafɨsyɨkutoho. Ose ifijoꞌmanji Anɨtu huhwo sekwoe wonyoso wae yasemofɨhwosi oso hisoꞌno kako apaꞌno huno mosyafɨsyonehoho. ");
INSERT INTO apz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Sekwo yoꞌmayoso aꞌamumo uyɨkujoꞌno Anɨtu huhwo kako sekumo yoꞌmayoso wosejapmmontonoho. Sekwo aꞌamu nomꞌnemo yoꞌmayoso uyɨkujoꞌno Anɨtu kako sekumo yoꞌmayoso sejapososo mangonepo ihwosi nohuꞌmepɨwesyahonɨngkuhwosi kipo kipo lohofɨhwosi wosejapmmontonoho. Sekwo yoꞌmayo aꞌamumneꞌno yano uyɨwoꞌnɨngkohofo hopaso Anɨtu kakoe yoꞌmayoso aku wosejapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisas kako pahnnɨmo hungkunoꞌnji ulɨmentisoso ole ulɨmento, Aꞌamu tɨmpiꞌnyo sohwo kako nomꞌne aꞌamu tɨmpiꞌnyo sohumo honɨngkano utɨhwamtolaho. Awonoho. Siko huhwaꞌu piꞌnɨmomo wohoꞌnɨꞌmofanjiyoho. ");
INSERT INTO apz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hwomu sɨkule syoho iwoꞌnɨngkiso sohwo kako aꞌamu kakimo lutɨhwawoꞌnɨngkiso sohumo uyakoloꞌmontolaho. Awonoho. I osoꞌno kako syoho yokumpohnꞌnyo engo ihwosi hwangku kako syoho lutɨhwayo paꞌnyo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kɨko jɨje hnnɨngkwaꞌwehwoe tɨmomjo hintalinyo wojo somo pehoꞌno uhwonalokuno. I, jɨje tɨmomjo iyo feejo engoso hofokiꞌnawojo soꞌno kɨko huno makiyotaho. Kɨko jɨje tɨmomjo iyo feejo engoso hofokiꞌnakuwojo soꞌno manohonyoꞌnjo sohwosi ");
INSERT INTO apz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","kɨko jɨje hnnɨngkwaꞌwehumo ole pehoꞌne ulalokuno. Nɨngkwahwo jɨje tɨmomjo hintalinyo wojo weꞌeso wae weekumoꞌmo. Ose pehoꞌno ulalokuno. Kɨko mangoꞌnohino hwosoho. Sɨmoꞌmo kɨko jɨje tɨmomjo iyo feejo engoso hofokiꞌnakuwojoso wae kakiꞌno feemoꞌnyo. Ose yohoji kɨko tɨmo itoꞌno uhwonɨngkohoji hwangku jɨje hnnɨngkwaꞌwehwoe tɨmomjo hintalinyo weꞌeso wae fiyo. ");
INSERT INTO apz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Iyo wopɨngoso ipisayo wonyoso mintoꞌnonehoho. Oso paꞌnyoso iyo wonyoso ipisayo wopɨngo mintoꞌnonehoho. ");
INSERT INTO apz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nakwo iyomjo ipisayo somo uhwonɨngkuhwasi nakwo huno wonayono. Iyo wopɨngotaho, iyo wonyotaho. Huno ose wonayono. Nakwo hiyaso somtaꞌni ikwonjayo momjonanehwono. I nakwo wampeso iyo hiyae somtaꞌni momjonanehwono. ");
INSERT INTO apz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hwe wopɨngo sohwo kakoe sɨmeho moꞌmo huno wopɨngoꞌnjo hweho. Oseso kako yahino wopɨngoꞌnohini wotɨpemaꞌmonte hweho. Hwe wonyo sohwo kakoe sɨmeho moꞌmo huno wonyoꞌnjo hweho. Oseso kako yahino wonyoꞌnohini wotɨpemaꞌmonte hweho. Yoꞌmayo huno sɨmeho moꞌmo engo yamoꞌnnyoso mango mtaꞌni lɨwoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","I, sekwo ngkimo Hwe Engofo, Hwe Engofo, pehoꞌne ntɨwoꞌnɨngkohofo. Sekwo Hwe Engofo ko ntontɨfeso sekwo nje hungkunomo tɨfi monnɨngkayoꞌnjo kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aꞌamu ngkimo nɨꞌmanto nje hungkunomo haloho pento tɨfi nnɨngkawoꞌnɨngkiso sohwo kako olo pahnnɨmo hungkuno loso paꞌnyoso wolosetɨhwamneꞌno yohono. ");
INSERT INTO apz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Oso hwe huhwo sohwo kako aꞌamu fihwo ango wopɨngo wamolɨmo loso sohwo paꞌnyo hweho. Kako hwosaꞌimo mno kengomoꞌmo ijɨhwosi hwosaho nɨhuꞌno yokumpohnꞌnyo wawontɨmontonoho. Osopo ango yokumpohnꞌnyo molososo ango huhwo sohwo wonyo mmoꞌnonehoho. Oꞌo, ifofo engo ihwosi oso ango huhwo sohumo mojwohafonehoho. Hwapɨngoso kakwoꞌyohwo sohwo hwosaho yokumpohnꞌnyo molinyofoho. ");
INSERT INTO apz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","I osoꞌno aꞌamu fihwo kako nje hungkunomo ko nupaꞌnɨngkuhwosi ngkimo monnɨngkapeꞌnjo sohwo kako aꞌamu ango siki molahinyo paꞌnyo hweho. Kako ango hwosaho ne moꞌmo mawonjiyoꞌnjo yososo iyo poꞌnɨfoꞌnohini hwaho tojwaponohini wawontɨmontonoho. Oso hopo sopo ango molɨhwosoꞌno ifofo engo ihwosi oso ango moloso hiso wojohaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas kako oso hungkuno hiso hwe moyaꞌmi somo moiꞌwo ulonto kako ango Koponeyamneꞌno umentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hwe fihwo kako aꞌamu itokusoꞌnjo sohwamo mokosyohumayo sohwo kakoe syoho ulohofiyo fihwo kako mnokino engo tɨpemanto poyo mofonepo wopeꞌnɨmonto imentisofoho. Oso hwe engo huhwo sohwo kako kakoe syoho ulohofiyo sohumneꞌno sɨmeho uyɨmojo hweho. ");
INSERT INTO apz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kako Jisas mofonepo humaho upaꞌnonto kako Jutafe hwe engo fehohnjo sohwamo Jisas aꞌamu mnokinoꞌnjo sohumo wopɨngo umokiyoꞌno utɨmayoꞌne lɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lɨhwojahonɨngki hofɨko Jisasɨmo uꞌmantɨfi hungkuno yokumpohnꞌnyo akweꞌno ulɨmentohofi, Olo hwe wopɨngoꞌnohini lohwo kako honɨngkano itoꞌnohino iwoꞌnɨngkiso hweho. Oseso kɨko kakimo ufoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kako aꞌamu Loum ko huhwo kako nakwo aꞌamu Juta sohwonaꞌnɨmneꞌno hitoho ulofɨwoꞌnɨngkiso hweho. Kako nakuneꞌno Anɨtuye tajo ango weꞌeso molɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ose ulahonɨngkofi Jisas hofɨkoꞌnji umentohofofoho. Kako angoꞌnjo tɨfonepo iꞌmofowahonɨngki hwe yofe engoꞌnjo sohwo kako kakoe aꞌamu nomꞌne sohwamo Jisasɨyepono lɨhwatɨmentisofoho. Hofɨko Jisasɨmo uꞌmantɨfi hwe huhwo sohwoe hungkuno motapontɨfi ulɨmentohofi, Nje ango ne sopo nɨꞌmayo soꞌno syoho engo ihnnoho. Hwe Engofo, kɨko nje angomo ko swapihnneso ngko hwe wopɨngo hwoꞌnnye angoꞌmꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Osoꞌno ngko kikiyepono ko pmneso ngko hwe wopɨngo hwonɨꞌmaho. I osoꞌno kɨko osopo nohumahoji hungkunoꞌnohini lisoso nje syoho ntohofiyo sohwo wopɨngo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ihwoni. Ngko huhwoꞌni hwe engo sohwamo enjwaꞌmo humale soꞌno ngko hofɨkoe hungkunomo tɨfi itoꞌno inɨngkawoꞌnɨngkohe hwoꞌnyoho. U, hofɨko ngko huhwoꞌnɨmo nomꞌnihwa enjwaꞌmo humalofo. Oseso ngko hwe fihumo Mpano ulɨꞌmeꞌno kako wamtonoho. U, nomꞌne sohumo Oyomo ulɨꞌmeꞌno kako wapmmontonoho. U ngko nje syoho ntohofiyo fihumo, Olo syoho fiyo ulɨꞌmeꞌno kako syoho uyɨmontonoho. Oseso kɨko hungkunoꞌnohini ulohojoꞌno ngko huno niyohoho. Nje syoho ntohofiyo sohwo wopɨngo umoꞌnɨmontonoho. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas kako oso hungkuno hofɨko motapmmentohofo homo somo upaꞌnonto kako yomo yonto kako oso hwe engo huhwo sohumneꞌno huno piꞌnɨngo engo syafɨhuꞌmentisofoho. Oso hwe moyaꞌmi piꞌnɨngo engo kakimo inɨngkamentohofo somneꞌno Jisas kako ikinjamo lohofonto pisopisaho lonto ulɨmento, Ngko oso hwe engo huhwo sohumneꞌno hungkuno waselɨmonneꞌno yohono. Ngko aꞌamu Isɨlael sofe sɨmeho hiꞌntnnono ntapinyo yahinoso oso hwe huhwo sohwoe paꞌnyoso muhwonyoꞌnjo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ose ulahonɨngki oso aꞌamu hwe yofe engoꞌnjo sohwo luhwatɨmentiso sohwa hofɨko hofɨkoe ango poneꞌno asomo nowentɨfi uhwonɨmentohofoso syoho ulohofiyo sohwo kako wopɨngo nohumentanɨngki uhwonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Sɨkuno fehohnjo memjaofahonɨngki Jisas kako ango Nain soponeꞌno umentisofoho. Kakoe inomokomoyo sohwanji nomꞌne hwe moyaꞌmi piꞌnɨngo engo hiꞌnji umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Oso ango hopo soponjo kuso engo somo iꞌmofawentɨfi uhwonɨmentohofoso aꞌamu sohwa hofɨko aꞌamu poyo peꞌnnyo sohwo itokwapmmentohofofoho. Poyo peꞌnnyo sohwoe konaꞌwohisi kako oso hwomu huhwo sohumnohini maꞌmentisofoho. Kakoe hwehwo sohwo hohonta poyo peꞌnɨmentisosiyoho. Oso ango hopo soponjo hwe moyaꞌmi piꞌnɨngo engoso aꞌmusiꞌnji nopontanɨngkofi Jisas uhwonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jisas uhwononto aꞌmu simneꞌno hitoho engo ulofahonɨngki aꞌmu simo ulɨmento, Kɨko humotaho lohotoho. ");
INSERT INTO apz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ose ulonto mofonepo lohofawento aꞌamu poyo peꞌnnyo sohwoe ijempoho sopo aho kisesyahonɨngki aꞌamu itokwapmmentohofo sohwa lohoꞌmentohofofoho. Jisas ulɨmento, Olo hwomo lohwosi, ngko wakilɨmonneꞌno yohono. Filɨkaho. ");
INSERT INTO apz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ose ulahonɨngki oso hwomu huhwo sohwo songo lɨkafonto hungkuno lɨmentisofoho. Oseso Jisas kako konaꞌwohimo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ose uhwonontɨfi hwe moyaꞌmi hopiꞌnono iyoho yontɨfi hofɨko Anɨtuye yofe hoꞌnomaꞌmentohofofoho. Ole ulɨmentohofi, Hwe Engo lohumo Anɨtu hungkuno uyahonɨngki najoꞌne sohwo nto ifawotoho. Anɨtu kakoe aꞌamu ne somo ufoꞌmayoꞌne nto ifawotoho. ");
INSERT INTO apz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Oso Jisas imentiso soꞌno hwaho Jutiya osoꞌmo hoꞌnomɨwento hwaho angoꞌmeemo hoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yoꞌmayo hungkuno Jisasɨmneꞌno hoꞌnɨngkiso soꞌno Jounɨye inomokomoyo sohwa upaꞌnontɨfi Jounɨmo ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Joun kako upaꞌnonto kakoe inomokomoyo hufaꞌu hwaꞌumo Jisasɨyepono hungkuno lɨhwatɨmentisofoho. Hungkunoso olenoho. Hwe tɨfi wapmmontonoho hoꞌnɨmentiso sohwosilaho. I, nakwo nomꞌnihuneꞌno wohontohumantantaho. ");
INSERT INTO apz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ose lɨhwojahonɨngki siko Jisasɨmo uꞌmanji ulɨmentisiyo, Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwo kikimo ole kilahonɨngkohoho. Kɨko hwe tɨfi wapmmontonoho lɨmentohe sohwosilaho. I, nakwo nomꞌnihuneꞌno wohontohumantantaho. Jounɨye hungkuno ose ulohonɨmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Oso hohosohonta Jisas kako hwe moyaꞌmi mnokino kengo kengoꞌnjo somo wopɨngo umokumentisofoho. Aꞌamu towahuno wonyo ehuhnnamoꞌnnyo somo wae yaoꞌmentisofoho. Aꞌamu tɨmpiꞌnyoso apaꞌno tɨmo honɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jisas kako Jounɨye inomokomoyo sohwaꞌumo ole ulɨmento, Siko nuhusɨsi yoꞌmayo nuhwonalokusiyo soꞌnji yoꞌmayo upoꞌnalokusiyo soꞌntnneꞌno Jounɨmo ulohunyo. Aꞌamu tɨmpiꞌnyoso tɨmo apaꞌno honalokwofo. Aꞌamu sɨfe wonyoꞌnjoso apaꞌno hano itoꞌno walokwofo. Aꞌamu aꞌapaho uyo nɨhuꞌno wonyoꞌnjoso (lepɨla) hofɨkoe aꞌapahoso wopɨngo imoꞌnɨngkohoho. Aꞌamu haloho pɨkuꞌnnyoso apaꞌno itoꞌno upoꞌnalokwofo. Aꞌamu poyo peꞌnnyoso apaꞌno songo lɨkofalokwofo. Aꞌamu yoꞌmayo soꞌno umofonyo iyoso Anɨtuye hungkuno wopɨngoso upoꞌnalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aꞌamu ngkineꞌno hwahopontaꞌango hwolɨkeno, Anɨtuye hwolɨkeno, huno ose mosyafɨsiyoꞌnjo yontɨfi hofɨko sɨmeho hiꞌntnnono kengaꞌno ntopantokwofoso hofɨko sɨmonyo uyɨfe. Siko nuhusɨsi oso hungkuno hiso Jounɨmo ulinyo. ");
INSERT INTO apz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ose ulahonɨngki oso hwe Joun lɨhwatɨmentiso sohwaꞌu nto wahonɨngki Jisas kako hwe moyaꞌmi somo Jounɨmneꞌno hungkuno ulɨmentisofoho. Ole ulɨmento, Hohonta sekwo oso hwaho aꞌamu mohumunyo sopo umentohofo sohonta pehomo uhwonano lontɨfi umentohofoto. Sekwo hwe mohufiyo paꞌnɨngo sohwo ifofo ilojaoꞌmentiso sohumo uhwonano lontɨfi umentohofotaho. Oꞌo, oseꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pehohumo uhwonano lontɨfi umentohofoto. Hwe fihwo hwapɨfe yoꞌmayo wonyoangkafo huꞌmeesisyoso uhwonano lontɨfi umentohofotaho. Oꞌo, aꞌamu hwapɨfe yoꞌmayo wokosoꞌnjo wonyoangkafo sohwa hofɨko hwe yofe engoꞌnjo hwaho mokosyohumayo sohwoe angomo humawoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","I, osoꞌno sekwo pehohumo uhwonano lontɨfi, umentohofoto. Aꞌamumo Anɨtu hungkuno uyahonɨngki hungkuno najo sohumo uhwonano lontɨfi imentohofotaho. Ou, osohifoho. Upaꞌnɨmno. Oso hwe sekwo uhwonɨmentohofo sohwo kako aꞌamu hopiꞌnonohinomo Anɨtu hungkuno uyahonɨngki nalɨwoꞌnɨngkohofo somo yakoloꞌnnyo hweho. ");
INSERT INTO apz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Oso hwe huhwo sohumneꞌno Anɨtuye hungkuno kakoe hwomumo ole nalohi, Upaꞌnyo. Ngko hwe fihumo nje hungkuno motaweꞌne wolɨhwatɨmonnoho. Oso huhwo sohwo kako kikimo sɨmoꞌmo kupe-eꞌne hweho. Kako jɨje honɨngkano itoꞌno esyohumayoꞌne hweho. Ose nalohoho. ");
INSERT INTO apz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ngko hungkuno waselɨmonneꞌno yohono. Hwe moyaꞌmi hopiꞌnono olo hwaho lopo humalofoso hofɨko Jounɨmo muyakolopitnnehofo. I, osoꞌno aꞌamu yofe engo ane sohwo Anɨtumo enjwaꞌmo humaso sohumo Joun kako osohumo muyakolofonefoho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hwe moyaꞌmi piꞌnɨngo soꞌnji aꞌamu hamniyoho mayo syohoꞌnjo sohwanji hofɨko Jounɨye hungkunomo upaꞌnontɨfi hnnɨmentohofi, Anɨtuye yahino ntoꞌnohino somo unɨngkowano lahonɨngkofi Joun hofɨkimo mijo kiyomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","I osoꞌno aꞌamu Falisi sohwanji aꞌamu Jutafe honɨngkano hungkuno lutɨhwamotofo sohwanji hofɨko Jounɨye mijo kiyomayo soꞌno nakwolaho lɨmentohofo soꞌno hofɨko oso honɨngkano wopɨngo Anɨtu utɨhwamentiso somneꞌno hohujo ikinjaoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Oso aꞌamu huhwo sohwamneꞌno Jisas ole ulɨmento, Oso aꞌamu olohonta humalofo sohwa peho paꞌnyo hwasimo waselɨmonnto. Aꞌamu peho hwalo. ");
INSERT INTO apz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hofɨko olo paꞌnyo hwafoho. Mehomiso hofɨko angopo humantɨfi nomꞌne mehomi somneꞌno joho ole lɨmofɨwoꞌnɨngkohofo paꞌnyo hwafoho. Nakwo hmpehmpe yoka sɨmonyoꞌne kulɨmokahonɨngkuhwoni sekwo sɨmonyo miyo kuyoho. Nakwo wosofe lahonɨngkuhwoni sekwo humotaho majofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ihwoni. Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwo kako iꞌmofaponto wosopayoꞌnji ipisayo mijo pompenjiyo soꞌnji manyo humohumantiso hweho. Osohumo sekwo uhwonontɨfi lɨmentohofi, Towahuno wonyo ehuhnnamoꞌnnyo hweho. ");
INSERT INTO apz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","I, ngko Aꞌamufe Hwomu sohwoꞌni iꞌmofaponji ngko ahuꞌmo wosopayoꞌnji ipisae mijo pompenjiyo soꞌnji nɨwoꞌnɨngkohe soꞌno sekwo ngkineꞌno ole lalokwofo. Uhwonɨmno. Hwe wopayo piꞌnɨngo engo nyoꞌnjo hweho. Ipisae mijo pomenjiyo piꞌnɨngo engo nyoꞌnjo hweho. Kako aꞌamu hamniyoho mayo syohoꞌnjo sohwanji aꞌamu honɨngkano wonyoꞌnjo soꞌnjiye aꞌamu hweho. Oso ngkineꞌno lɨwoꞌnɨngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","I osoꞌno hwe moyaꞌmi hofɨko Anɨtuye huno engo mawoꞌnɨngkohofoso hofɨkoe honɨngkano wopɨngo somo hofɨkoe itoꞌno humayo somo aꞌamu uhwonɨngkuji neꞌnjofoho wolantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Falisi fihwo kako ngkoꞌnji wosopayo wonaho lonto Jisasɨmo joho ulɨmentisofoho. Jisas kako oso Falisi sohwoe angomo noswonto wosopayo nyoꞌne humohumantisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Oso hopo sopo aꞌmu honɨngkano wonyoꞌnjosi humunyoponoho. Kako Jisas Falisiye angomo wosopayo nalofoho upaꞌnonto kako ahwonte hofiyo hwone mijo akino wonyoangkafoꞌnjoso nomanto Falisi huhwo sohwoe angomo humentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kako noswonto Jisasɨye hohujo hntaꞌni sɨfepo hwomtame ehumanto humotaho sulɨmentisofoho. Kakoe tɨmijoso Jisasɨye sɨfepo loꞌnɨngkahonɨngki kako kakoe mijiyoꞌnji Jisasɨye sɨfemjo yokoꞌnyoso sosayo usɨpoꞌmentisofoho. Ose yonto aꞌmusi kako Jisasɨye sɨfemo hinjoho huꞌnonto hwone mijo akino wopɨngoꞌnjoso ehulohoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Oseso oso Falisi Jisasɨmneꞌno wapono lɨmentiso sohwo oso hisimo uhwononto Jisasɨmneꞌno huno ole syafɨhuꞌmento, Olo hwe lohumo Anɨtu hungkuno uyahonɨngki nalɨmojo ne hwoꞌmanji kako oso aꞌmu siye yahinoso huno uyɨhwonesohilo. Oso aꞌmusi nɨhuꞌno wonyiyoho. Oseso ngko huno niyohoho. Kakimo Anɨtu hungkuno uyahonɨngki nalɨmojo ne hwoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Oso hwe huhwo sohwoe hunomjo Jisas kako huno uyahonɨngki ulɨmento, Saimoun, ngko kikineꞌno hungkuno wakilɨmonneꞌno yohono. Ose ulahonɨngki Saimoun ulɨmento, Nakwoe Lonetɨhwayo sohwosi, Nohonjo. Ose ulahonɨngki ");
INSERT INTO apz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisas ulɨmento, Hwe fihwo hamniyoho mokosyohumayo sohwo kako hwe hufaꞌu hwaꞌumo hamniyoho aku mayoꞌne nokiso uyɨmentisofoho. Hwe fihumo kako faif hantɨlet (500) kina uyonto nomꞌnehumo fifɨti (50) kina uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Oso hwe hufaꞌu huhwo sohwaꞌu siko aku uyoso hopoꞌmaho. Oseso hwe hamniyoho mokosyohumayo sohwo kako hamniyoho hiso aku mayosoꞌno sikoe syohofoho lonto sikoꞌne nɨhuꞌnahonefoho, ulɨmentisofoho. Ose ulɨmentiso soꞌno oso hwe hufaꞌuyo huhwo sohwaꞌu siko oso hwe hamniyoho mokosyohumayo sohumneꞌno sɨmeho umoꞌnyo engoso tɨhwolo. ");
INSERT INTO apz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ose ulohonɨngkahonɨngki Saimoun ulɨmento, Ngko huno ole syofɨsyalokweno. Oso hwe faif hantɨlet (500) kina maꞌmentiso sohwo kako hwe sohumneꞌno sɨmeho umoꞌnyoso engo umoꞌnɨmentisofoho. I oso hwe fifɨti (50) kinaꞌnohini maꞌmentiso sohwo kako sɨmeho weꞌeꞌnohoni uyɨmentisofoho. Ose ulahonɨngki Jisas ulɨmento, Jɨje huno nehopi kiyohoho. ");
INSERT INTO apz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ose ulonto kako aꞌmu simneꞌno ikinjamo lohofonto Saimounɨmo ulɨmento, Kɨko olo aꞌmu losimo uhwonyo. Ngko jɨje angomo swapohe sohonta kɨko nje sɨfemo mijo yatɨkuꞌnyoꞌneso montapefoho. I osoꞌno olo aꞌmu losi kako kakoe tɨmijoꞌnji nje sɨfemo nɨyotɨjwantofoho. Kakoe mijiyoꞌnji sosayo nisɨpeentofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ngko noswopahonɨngko kɨko ngkimo hinjoho manɨhuꞌnyofoho. I ngko kahopi swapohe sohonta olo aꞌmu losi kako nje sɨfemo hinjoho neꞌnohini nɨhuꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ngko noswopahonɨngko kɨko nje mnokinopo hwone mijo mehantohofefoho. I osoꞌno olo aꞌmu losi kako nje sɨfemo hwone mijo akino wopɨngoꞌnjoso ehontohokwoho. ");
INSERT INTO apz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Osoꞌno Saimounɨkimo, ngko ole wakilɨmonneꞌno yohono. Olo aꞌmu losi kako ose ntohofantokuso soꞌno kɨko huno ole wakiyono. Kakoe honɨngkano wonyo piꞌnɨngo engoꞌnjo ko hisi olohonta ngko wae nto yaofohono. Oseso kako ngkineꞌno sɨmeho mɨkunɨmposo engo umoꞌnalofoho. U hwe fihwo kako kakoe yokumpohnꞌnyo soꞌnji honɨngkano wopɨngo iwoꞌnɨngkiso sohumo Anɨtu kakoe wonyo weꞌeso wae yaofososo oso hwe huhwo sohwo kako Anɨtumo sɨmeho weꞌene uyɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ose ulonto Jisas kako aꞌmu simo ulɨmento, Ngko jɨje wonyoso wae nto yakumofohono. ");
INSERT INTO apz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ose ulahonɨngki oso aꞌamu kakoꞌnji humohumantohofoso hofɨko hofɨkoe hungkuno ole hnnɨꞌmentohofi, Olo hwe lohwo aꞌamufe wonyo wae yaofɨwoꞌnɨngkiso lohwo sohwo tɨhwolo. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jisas kako aꞌmu simo ulɨmento, Kɨko ngkimo sɨmeho hiꞌntnnono ntapohino soꞌno kɨko Anɨtuye aꞌamu ne imoꞌnɨngkohino. Oseso kɨko sɨmeho wopɨngoꞌnji fosyohumantono. ");
INSERT INTO apz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hwangku sohonta Jisas kako ango hoꞌmo hoꞌmeemo ukuꞌmoꞌmentisofoho. Oso aꞌamu homo somo Anɨtu aꞌamu kakimo enjwaꞌmo humawoꞌnɨngkohofo somo hofiyo umokosyohumawoꞌnɨngkiso soꞌno lɨkuꞌmoꞌmentisofoho. Jisasɨye inomokomoyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌu sohwa kakoꞌnji hano umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","I, hwoyaꞌmi fifa hofɨko tɨfi inɨngkamentohofofoho. Oso hwoyaꞌmi fehohnjo sofa Jisas kako towahuno wonyo ehuhnnamoꞌnnyo somo wae yaoꞌmentisofoho. Fifa mnokinoꞌnjo sofamo wopɨngo umokumentisofoho. Aꞌmu fisi kakoe yofe Maliya. Oso hihnneꞌno Maliya Makɨtola ntaꞌangiyoho lɨmentohofofoho. Hohonta oso aꞌmu simo towahuno wonyo aho fehohnjo hopiꞌnono nomꞌne mtaꞌni hufaꞌuyoso ehuhnnamoꞌnnyo simo Jisas kako wae yaoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nomꞌnesi Jouanafoho. Oso aꞌmu siye hwehwo sohwo kakoe yofe Husafoho. Kako hwe engo Heloutɨye angomo mokosyohumayo syohoꞌnjo hweho. Nomꞌnesi Susanofoho. Oso fanji nomꞌne moyaꞌmi piꞌnɨngo sofanji hofɨko Jisasɨmo tɨfi inɨngkamentohofofoho. Oso moyaꞌmi hofo sofa hofɨko Jisasɨꞌnji kakoe inomokomoyo sohwanjimo ufoꞌmano lontɨfi hofɨkoe hamniyoho yoꞌmayoso uyɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Hwe moyaꞌmi piꞌnɨngo engo Jisasɨꞌnji nohumantɨfi nomꞌne hwe moyaꞌmi ango hoꞌmo soꞌmtaꞌni hofɨkoꞌnji uhuꞌmokahonɨngkofi Jisas olo pahnnɨmo hungkuno ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Hwe fihwo kako kakoe syohopo ufongoyo fisosomokaoꞌmentisofoho. Fisosomokofahonɨngki ufongoyo neso fehohnjoso honɨngkanopo pɨwahuꞌmentisofoho. Oso homo somo aꞌamu nopontɨfi hwotoho hmmentohofofoho. Fehohnjoso yɨhufo sohwa nɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ufongoyo fehohnjoso hwaho sojoꞌnjopo pɨwahuꞌmentisofoho. Oso hiso nofokafonto hwaho mijo ane imoꞌnonto oso ufongoyo hiso yofoho imentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ufongoyo fehohnjoso nantɨpe yongoꞌnjopo pɨwahuꞌmentisofoho. Nantɨpe hiso ufongo hisoꞌnji sofokaꞌmentisoso nantɨpe sohwo kako ufongomo kingkuloꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ufongoyo fehohnjoso hwaho afofoꞌnjopo pɨwahuꞌmentisoso nofokafonto ipisayo ne piꞌnɨngo engo intoꞌnɨmentisofoho. Ufongoyo angaꞌnohino somtaꞌni piꞌnɨngo engo imoꞌnɨmentisofoho. Jisas ose ulonto kako mohmꞌno ole ulɨmento, Aꞌamu fihwo nje hungkuno upaꞌnyoꞌne haloho hiꞌnjo hwoꞌmanji kako upaꞌnono. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisasɨye inomokomoyo sohwa oso pahnnɨmo hungkuno homo somneꞌno hwapɨngo soꞌno Jisasɨmo ulohonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jisas ulɨmento, Anɨtu kako aꞌamumo mokosyohumayo yahino somneꞌno hiyaso woꞌmojoso sekwo sohwasimo nto setɨhwamentisofoho. I osoꞌno hwe moyaꞌmi nomꞌniso hofɨko pahnnɨmo hungkunoꞌnohini upaꞌnɨwoꞌnɨngkofofoho. Oseso hofɨko yoꞌmayo somo tɨmo ko uhwonantɨfeso yofe mɨhwofeꞌnjofoho. Hofɨko yoꞌmayo somo haloho ko upaꞌnontɨfeso hofɨko hwapɨngo neso huno muyofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ose ulonto Jisas ole ulɨmento, Oso pahnnɨmo hungkuno seloheso olenoho. Oso ufongoyo hiso Anɨtuye hungkunofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Oso ufongoyo honɨngkanopo pɨwahuꞌmentisoso olo paꞌnyofoho. Aꞌamu fehohnjoso Anɨtuye hungkuno upoꞌnɨngkahonɨngkofi tɨfi Seten hwe wonyo sohwo hofɨkoe sɨmehomjo hungkuno somo wae yaofɨwoꞌnɨngkiso hweho. Seten kako huno ole syofɨsyalofoho. Aꞌamu Anɨtuye hungkuno sɨmehomo mnaweꞌmanji hofɨko kakimo sɨmeho hiꞌntnnono uyɨkujoꞌno Anɨtu hofɨkimo asomo utɨmanoho. Ose syafɨsyonto wae yaofɨwoꞌnɨngkisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Oso ufongoyo hwaho sojoꞌnjopo pɨwahuꞌmentisoso olo paꞌnyofoho. Aꞌamu fehohnjoso hofɨko Anɨtuye hungkuno upaꞌnontɨfi sɨmeho moꞌmo mehoꞌnasyontɨfi sɨmonyo iwoꞌnɨngkohofofoho. I osoꞌno oso hungkuno mehoꞌnasiyoso pmpongo muhwatnnyo paꞌnyofoho. Oso aꞌamu hiso hofɨko Anɨtumo sɨmeho hiꞌntnnono weꞌenehwo uyontɨfi yoꞌmayo tango uꞌmante soꞌno hofɨko iyoho unɨngkahonɨngki hofɨkoe sɨmeho hiꞌntnnono uyo weꞌeso hoꞌnaofɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Oso ufongoe nantɨpe yongoꞌnjopo pɨwahuꞌmentisoso olo paꞌnyofoho. Aꞌamu fehohnjoso hofɨko Anɨtuye hungkuno upaꞌnontɨfi Anɨtumo ko inɨngkowahonɨngkofi yoꞌmayo hwahoponjo tangoso uꞌmanteso hofɨko hamniyoho soꞌno huno piꞌnɨngo engo syafɨsyontɨfi hofɨko hofɨkoe aꞌapahomnohini syafɨsyahonɨngkofi oso yoꞌmayo hiso hofɨkoe sɨmeho umoꞌnyo kingkulofɨwoꞌnɨngkisofoho. Osoꞌno hofɨkoe ipisayoso mojo miyonefoho. Hofɨko nomꞌne aꞌamu somo Anɨtuye honɨngkano tɨpemayoꞌne mufoꞌmapitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","I osoꞌno oso ufongoe hwaho afofoꞌnjopo pɨwahuꞌmentisoso olo paꞌnyofoho. Aꞌamuso hofɨko Anɨtuye hungkuno upaꞌnontɨfi sɨmeho moꞌmo mehoꞌnasyontɨfi yokumpohnꞌnyo mokosyohumawoꞌnɨngkohofofoho. Oso aꞌamu hiso hofɨkoe humayoso itoꞌnohinofoho. Hofɨko nomꞌne aꞌamumo Anɨtuye hungkunomo inɨngkafitnneꞌentɨfi lutɨhwawoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Aꞌamu sikilohoꞌnjoso hofɨko nomongkujɨkuji ahwonteꞌmo wokipitofosyantɨhmꞌmaho. Epohumayo enjwaꞌmo wohoꞌnosyantɨhmꞌmaho. Awonoho. Hofɨko ijempoho tojwapo ifohoꞌofahufijoso aꞌamu oso ango homo somo swapɨfijo somo oso pomponahoso hofɨkimo walohumontonoho. ");
INSERT INTO apz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Oso pahnnɨmo hungkunoso oleneꞌno lonetɨhwalofoho. Yoꞌmayo hiyaso wojoso hwangku utɨhwaꞌnyopo iꞌmofapɨhwosoꞌno uhwonantanoho. Yoꞌmayo sɨmeho moꞌmjo hiyaso mokosyohumalohwoneso hwangku utɨhwaꞌnyopo iꞌmofapɨhwosoꞌno aꞌamu hopiꞌnono uhwonantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Sekwo Anɨtumo inɨngkawentɨfi aho yokumpohnꞌnyo kemokosyohumalofo sokumo, Anɨtu kako engoꞌno engoꞌno wosejapmmontonoho. I osoꞌno hwe fihwo kako Anɨtumo sɨmeho weꞌe uyo sohwo, Ngko Anɨtuye hungkuno nomꞌne upaꞌnyoso pehoꞌneto. Ntaꞌnoho, loso sohwo oso sɨmeho weꞌe uyalokuso somo wae weeoꞌmtonoho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Oso hohosohonta Jisasɨye konaꞌwohiꞌnji konɨngkwaꞌwehwosanji kakiye pono pmmentohofofoho. I osoꞌno hwe moyaꞌmi piꞌnɨngo engo Jisasɨꞌnjopo uhuꞌmokumentohofo soꞌno hofɨko Jisas pone neso mꞌmofapɨfitnnehofo. ");
INSERT INTO apz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oseso hwe fihwo Jisasɨmo ulɨmento, Hnnaꞌwohiꞌnji hnnɨngkwaꞌwehwosanji hofɨko yolohoꞌmo lohofontɨfi kikimo wokuꞌmano lontɨfi humohumantohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ose ulahonɨngki Jisas ulɨmento, Aꞌamu Anɨtuye hungkunomo haloho pentɨfi inɨngkawoꞌnɨngkohofoso hofɨko nje naꞌuja nje nɨngkwahwosafoho. ");
INSERT INTO apz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sɨkuno fihumo Jisas kakoe inomokomoyo sohwanji hofɨko yofayokinomo kotasontɨfi Jisas ulɨmento, Nakwo mijo lomo nongkihntaꞌni woekano. Ose ulahonɨngki nɨhuꞌnahone yofayokino hano imentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nowekontanɨngkofi Jisas kako saho fosyawoꞌmentisofoho. Nofosyowentanɨngki ifofo engo nto yahonɨngki oso yofayokino homo somo mijo ufehuꞌmokahumonto yahonɨngki yofayokino hiso mijo womuhuloꞌmto imentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Inomokomoyo sohwa hofɨko Jisasɨmo komoꞌno ulɨkafontɨfi ulɨmentohofi, Hwe Engofo, Hwe Engofo, weꞌenepi nakwoe yofe moiꞌwo umoꞌnontaneꞌno yalokuhwono. Ose ulahonɨngkofi Jisas nolɨkafonto ifofo soꞌnji mijo soꞌnjimo hungkuno ulahonɨngki ifofoꞌnji mijoꞌnji moiꞌwo imoꞌnɨngkahonɨngki mijo apaꞌno songo songo miyoꞌnjo nɨhuꞌnahone lofawoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Oseso Jisas kakoe inomokomoyo sohwamo ulɨmento, Sekwoe sɨmeho hiꞌntnnohinoso ntɨꞌmo weho. Ose ulahonɨngki hofɨko yomo yontɨfi iyoho yontɨfi ole hnnɨmentohofi, Olo hwe lohwo kako ifofoꞌnji mijoꞌnjimo yoka ulisolo halohoꞌnohini isolo tɨhwoe huhwolo. ");
INSERT INTO apz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hofɨko hwaho Ngkalili sopo ntaꞌni mijo ayo somo nowakentɨfi hwaho Ngkekesa sopo kiꞌmofamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Oso hopo sopo Jisas kako yofayokino mtaꞌni ifohohosyosyahonɨngki oso ango soponjo hwe fihwo uꞌmaꞌmentisofoho. Oso hwe huhwo sohumo towahuno wonyo sohwa kakimo ehuhnnamoꞌnnyo hweho. Sɨkuno piꞌnɨngo engo somo kako he ane hweho. Kako ango ne soꞌmo mohumayo hweho. Oꞌo, kako aꞌamufe pijafo sokimomo hoꞌnasiyo sopo humemmojo hweho. Sɨkuno piꞌnɨngo engo somo oso towahuno wonyoso oso hwe huhwo sohumo yokumpohnꞌnyo mokosyohumawoꞌnɨngkohofo sohonta aꞌamu angoponjoso aho kesyohumantɨfi ahwomo nano soꞌnji kakoe sɨfe ahomo ko kilofontɨfe sohwo kako ahwomo nano hiso mtɨhupewoꞌnɨngkisofoho. Towahuno wonyo homo somo hwaho aꞌamu ane soponeꞌno ipemotawowoꞌnɨngkohofofoho. Oso hwe huhwo sohwo kako Jisasɨmo uhwononto joho mohmꞌno lamofonto Jisasɨye sɨfe kiꞌnyoꞌmo pɨwasyonto mango engo ulɨmento, Jisas kɨko Anɨtu Yokintahoponjo sohwoe Hwomu Ne hwosoho. Kɨko ngkimo peho wontohoꞌmonneꞌnelo. Hungkuno yokumpohnꞌnyo wakilɨmonneꞌno yohono. Kɨko ngkimo tohino nontapohotoho. Oso hungkuno ulɨmentiso hwapɨngoso olenoho. Jisas kako oso towahuno wonyo sohumo ulɨmento, Kɨko olo hwe lohumo ulɨkoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ose ulonto nomꞌne hungkuno ulɨmento, Jɨje yofe pɨhwoꞌnyo hwosilo. Ose ulahonɨngki ulɨmento, Nje yofeso Ami hwoꞌnyoho. (Nakwoe hungkuno ole, Sɨsɨhwayo paꞌnɨngo, piꞌnɨngo engofoho.) Hwapɨngoso towahuno wonyo piꞌnɨngoso oso hwe huhwo sohumo ehuhnnamoꞌnnyofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Towahuno huhwo sohwo hofɨko Jisasɨmo yokumpohnꞌnyo ulɨmentohofi, Kɨko tohino mayo soꞌno tɨkano somneꞌno nolonehwajohotoho. ");
INSERT INTO apz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Oso hwofɨkiꞌnyo mofone sopo yahu piꞌnɨngo engoso hofɨko mno ijontanɨngkofo somneꞌno towahuno wonyo sohwa Jisasɨmo yokumpohnꞌnyo ulɨmentohofi, Kɨko tɨmoꞌnohino fohononehwajo. Nakwo oso yahu nongkwafe poneꞌno wohwontaneꞌno yɨhwono. Ose ulahonɨngkofi Jisas hofɨkimo tɨmo honohwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Oseso oso towahuno wonyo hiso hwe sohumo nulɨkoꞌmantɨfi yahu somo ehuhnnaoꞌmentohofofoho. Ehuhnnaofahonɨngkofi yahu hiso hofɨko hano kunto kuntoꞌno wentɨfi iwoꞌmangomo mtɨkuꞌnontɨfi mijomo nɨhuꞌnahono mihuloꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Oso yahu mokosyohumayo sohwa yoꞌmayo somo uhwonontɨfi hano kunto kuntoꞌno wentɨfi hwe moyaꞌmi ango engo soponjo soꞌnji osoꞌmo soꞌmeemjo soꞌntnneꞌno oso hungkuno hiso lɨjwaofahonɨngkofi hoꞌnɨmɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Oso hungkuno hiso hoꞌnɨngkahonɨngki hwe moyaꞌmi hopiꞌnonohinoso uhwonano lontɨfi imentohofofoho. Hofɨko Jisasɨꞌnji iꞌmofapontɨfi uhwonɨmentohofoso oso hwe towahuno wonyo ulɨkomaꞌmentohofo sohwo kako he yofonto kako huno wopɨngoꞌnjo imoꞌnonto kako Jisasɨye sɨfɨkiꞌnyoꞌmo nohumentanɨngki uhwonɨmentohofofoho. Ose uhwonontɨfi iyoho imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","39","Oso aꞌamu tɨfinjo iꞌmofapmmentohofo somo aꞌamu hofɨko Jisas oso hwe towahuno wonyo ulɨkoꞌmaꞌmentohofo sohumo wopɨngo umokumentiso somo uhwonɨmentohofo soꞌno mpoyo lutɨhwamentohofofoho. Ose upaꞌnontɨfi oso hwe moyaꞌmi hopiꞌnono oso hwaho Ngkekeso soꞌmeem mtaꞌangoso hofɨko Jisasɨmo ulɨmentohofi, Kɨko nakumo nonelɨkoꞌmahoji nomꞌne angopono mpano. Ose ulɨmentohofo hwapɨngoso oleꞌnefoho. Hofɨko iyoho mɨkunɨmposo unɨngkahonɨngki ulɨmentohofofoho. Oseso Jisas kako yofayokinopo nokotosahonɨngki oso hwe towahuno wonyoso ulɨkoꞌmaꞌmentohofo sohwo kako Jisasɨmo yokumpohnꞌnyo ulɨmento, Ngko kɨkoꞌnji wowahontnneꞌno yohono. Ose ko ulahonɨngki Jisas ulɨmento, Kɨko jɨje angopono asomo uhuji yoꞌmayo wonyoangkafo Anɨtu kilohoꞌmaso soꞌno jɨje aꞌamu somo filutɨhwaho. Ose lɨhwajonto Jisas kako nɨhuꞌnahone asomo wakoꞌmentisofoho. Oseso oso hwe huhwo sohwo kako kakoe ango poneꞌno asomo nowento hwe moyaꞌmi hopiꞌnonohinomo yoꞌmayo Jisas ulohoꞌmentiso soꞌno lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas kako mijo ayo nongkihntaꞌni asomo wakoꞌmentiso sohonta hwe moyaꞌmi hopiꞌnono kakineꞌno humohontohumantohofoso Jisasɨmo uhwonontɨfi sɨmonyo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Osohonta hwe fihwo kakoe yofe Jailos sohwo kako Jisasɨmo uꞌmaꞌmentisofoho. Oso hwe Jailos huhwo sohwo kako Anɨtuye tajo ango weꞌe somo mokosyohumayoꞌne yofe engoꞌnjo hweho. Kako mu angaꞌnohinoꞌnjo hweho. Kakoe mu siye soswoso aho hopiꞌnono sɨfe mtaꞌni hufaꞌu uyakoloꞌnnyosi kako poyo wopeꞌnɨmonto mofone sopo kanɨngkwohwo Jisasɨmo uꞌmanto Jisasɨye sɨfɨkiꞌnyoꞌmo hwomtame ehumanto Jisasɨmo yokumpohnꞌnyo ulɨmento, Kɨko nje ango poneꞌno wowaho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Oso aꞌamuꞌnjo hopo sopo aꞌmu fisi kako humunyoponoho. Oso hisi kako engolopohamo imoihoso neꞌno yontanɨngki soswo aho hopiꞌnono sɨfe mtaꞌni hufaꞌu uyakoloꞌmojofoho. Aꞌamu fihwo kako oso aꞌmu hisiye mnokino homo somo wopɨngo umokone sohwo mohumunyoponoho. Kakoe hamniyoho hopiꞌnono aꞌamu mnokinoꞌnjo somo wopɨngo umokiyo sohwamo nto umojiyoho. ");
INSERT INTO apz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Oso aꞌmu hisi kako Jisasɨye hohujo hohntaꞌni uꞌmanto kako Jisasɨye hwapɨfe tokwajo somo aho upmꞌmokahonɨngki aꞌmusi kakoe honɨyoso sosayo komoꞌno saꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Oso hohosohonta Jisas ulɨmento, Ngkimo aho tɨhwo nɨpmꞌmokantofoho. Ose ulahonɨngki hofɨko angaꞌno angaꞌno ulɨmentohofi, Ngkoꞌmaho. Ngko makupmꞌmokoho yohono. Ose lontanɨngkofi Pita Jisasɨmo ulɨmento, Hwe Engofo, hwe moyaꞌmi piꞌnɨngo engo kikimo ifehuꞌmokokumantɨfi kakupmꞌmokohofo. ");
INSERT INTO apz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ose ulahonɨngki Jisas ulɨmento, Aꞌamu angaꞌno kako ngkimo aho kisanisyohoho. Nje aꞌapaho somtaꞌni yokumpohnꞌnyo fehohnjoso uhwohoe huno niyohoho. ");
INSERT INTO apz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ose ulahonɨngki oso aꞌmu hisi kako Jisas ngkineꞌno huno nto uyohoho syafɨsyonto yomo yomo yonto Jisasɨye sɨfɨkiꞌnyoꞌmo hwomtame ulohofonto aꞌamu hopiꞌnonohinofe tɨmopo kako Jisasɨmo aho kisuhumentiso hwapɨngo soꞌno lutɨhwanto ole ulɨmento, Nje mnokinoso nɨhuꞌno komoꞌno moiꞌwo imoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ose ulahonɨngki Jisas ulɨmento, Nje mupe, kɨko ngkimo sɨmeho hiꞌntnnono ntapohino soꞌno olohonta kɨko wopɨngo imoꞌnɨngkino. Kɨko sɨmeho wopɨngoꞌnjo siki uhuji fohumantono. ");
INSERT INTO apz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ose ulontanɨngki hwe fihwo Jailosɨye angopo ntaꞌni noponto Jailosɨmo uꞌmanto ulɨmento, Jɨje mu poyo nto peꞌnɨngkohoho. Oseso kɨko olo hwe engo lohumo jɨje ango poneꞌno pehoꞌno ipemotowalokuno. Kako wohumano. ");
INSERT INTO apz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ose ulahonɨngki Jisas kako upaꞌnonto Jailosɨmo ulɨmento, Kɨko iyoho yohotoho. Kɨko ngkimo sɨmeho hiꞌntnnono ntahopohojoꞌno jɨje mu wopɨngo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ose ulonto Jisas kako Jailosɨye angopo iꞌmofawento oso hopo sopo Jisas kako Pita, Joun, Jemɨs oso hwanji kanɨngkwohwoꞌyaꞌuꞌnjimo utɨmanto hofɨkoꞌnohini angomo humentohofofoho. Nomꞌne aꞌamu somo ole ulɨmento, Sekwo noswapɨkutoho. ");
INSERT INTO apz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ose ulahonɨngki hwe moyaꞌmi piꞌnɨngo engoso hofɨko mu hisineꞌno humotaho lopemoꞌnowentanɨngkofi Jisas ulɨmento, Sekwo humotaho lɨkutoho. Kako poyoꞌmaho. Saho fosyaweho. ");
INSERT INTO apz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ose ulahonɨngki aꞌamu hiso hofɨko mu poyo nto peꞌnɨmentiso soꞌno huno uyahonɨngki hofɨko Jisasɨmneꞌno sitofo ulontɨfi tɨkafo ujɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","I osoꞌno Jisas kako mu poyo peꞌnɨmentiso siye aho manto mango mohmꞌno ole ulɨmento, Mupe, kɨko filɨkaho. ");
INSERT INTO apz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ose ulahonɨngki oso mu hisiye huyoꞌmangoso nto umentisoso asomo ponto kaꞌwohimo uhuloꞌofahonɨngki mu sopi lɨkaꞌmentisofoho. Nolɨkofahonɨngki Jisas kanɨngkwohwoꞌyaꞌumo ulɨmento, Wosopayo uyinyo. ");
INSERT INTO apz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ose ulahonɨngki kanɨngkwohwoꞌyaꞌu siko yoꞌmayo somo uhwononji yomo engo imentisiyefoho. Jisas kako kanɨngkwohwoꞌyaꞌumo hungkuno yokumpohnꞌnyo ulɨmento, Olo hilo soꞌno siko yolohoso nomꞌne aꞌamumo nulohosiloho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas kako kakoe inomokomoyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sohwamo lutɨmanto yoꞌmayo mnokinoꞌnjo soꞌnji aꞌamu towahuno wonyo ehuhnnamoꞌnnyo soꞌnjimo wae yaofɨkuji wopɨngo umokiyoꞌne kakoe yokumpohnꞌnyo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jisas hofɨkimo ulɨmento, Sekwo angoꞌmeemne humpekuji Anɨtu kako aꞌamu somo umokosyohumamonto yalokunjo soꞌno lutɨhwafɨkuji aꞌamu mnokinoꞌnjo somo wopɨngo umokumno. ");
INSERT INTO apz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ose ulonto ulɨmento, Sekwo yoꞌmayo hano emoyo soꞌneꞌno mno, hoꞌyo, wopayo, hamniyoho manjiꞌmofo nomꞌneso nomotawekutoho. Oꞌo, hanoꞌnohino fiyɨkuno. ");
INSERT INTO apz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sekwo nomꞌne angopo iꞌmofahokuji aꞌamu fihwo sekumo kakoe angomneꞌno setɨmaso sohwoe angomnohini fosyawentɨfijo sohwasi oso ango hopo sopo nulɨkoꞌmafɨkuji ango nomꞌnepono nje hungkuno lutɨhwayoꞌne fɨhwanɨmno. ");
INSERT INTO apz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ango fipo iꞌmofafijoso aꞌamu mosetɨmasoꞌnjo mikujɨꞌmanji oso ango hopo sopo nulɨkoꞌmafɨkuji hopo soponjo hwaho semongkiꞌnososo hofɨko nosehontohumentanɨngkuji oso hintalinyo hiso wae feehumno. Oso homo somo uhwonɨngkuji hofɨko hofɨkoe yahino somneꞌno huno ole wosyafɨhupɨfe. U, nakwo wonyo yɨhwono. Ose syafɨsyɨkuji iyoho unono. ");
INSERT INTO apz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ose ulonto hofɨkimo uhwojahonɨngki hofɨko angoꞌmeemneꞌno humpoꞌmentohofofoho. Ango hoꞌmo hoꞌmmeemo Anɨtuye hungkuno wopɨngoso lɨkuꞌmofontɨfi aꞌamu mnokinoꞌnjo somo wopɨngo umokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hwe yofe engoꞌnjo hwaho Ngkalili sopo mokosyohumayo sohwo kakoe yofe Heloutɨyoho. Oso huhwo sohwo yoꞌmayo wonyoangkafo Jisas imentiso soꞌno upaꞌnonto kako huno piꞌnɨngo syafɨhuꞌmentisofoho. Hwapɨngoso aꞌamu fehohnjoso Jisasɨmneꞌno ole ulɨmentohofi, Joun poyo peꞌnɨmentiso sohwo kako piꞌnɨmo mtaꞌni apaꞌno songo nto lɨkakwoho. ");
INSERT INTO apz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nomꞌne aꞌamuso ole ulɨmentohofi, Ilaija sohumo Anɨtu hungkuno uyahonɨngki kako neyakwosamo hohonta lutɨhwamojo sohwo kako poyo peꞌnɨmentiso sohwo apaꞌno nto lɨkakwoho. Nomꞌne aꞌamuso ole ulɨmentohofi, U, nomꞌne aꞌamu hohonta humamojo sohumo Anɨtu hungkuno uyahonɨngki lutɨhwamojo sohwo nto lɨkakwoho. ");
INSERT INTO apz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helout oso hungkuno upaꞌnonto kako syafɨhuꞌmento, Nje aꞌamu lɨhwatɨmentoheso hofɨko Jounɨye tɨꞌwangomo mɨngo ntofilɨjwamokwofɨhweho. Oseso olo hwe lohwo Jounɨꞌmanji pipilo. I osoꞌno ngko pipineꞌno upaꞌnɨngkohono oso huhweho eso, hungkuno upaꞌnɨmaleso tɨhwolo. Ose syafɨsyonto kako Jisasɨmo uhwonɨmonto imentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jisas kakoe inomokomoyo (apousel) uhwatɨmentiso sohwa asomo nopontɨfi hofɨko yoꞌmayo imentohofo soꞌno Jisasɨmo ulɨmentohofofoho. Nto ulahonɨngkofi Jisas kako hofɨkoꞌnji aꞌamu nomꞌne hopiꞌnonohino somo uhwatɨꞌmofontɨfi hofɨkoꞌnohini ango Mpetɨsaita neꞌno umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hwe moyaꞌmi hopiꞌnonohinoso oso hisoꞌno huno uyahonɨngki hofɨko umentohofo somo inɨngkamentohofofoho. Jisas kako oso hwe moyaꞌmi hiso kakimo nto inɨngkowahonɨngkofi uhwononto ulɨmento, Sekwo oyonɨmno. Jisas kako Anɨtu hwe moyaꞌmi somo wopɨngo umokosyohumamonto iwoꞌnɨngkiso soꞌno hungkuno ulonto aꞌamu mnokinoꞌnjo somo wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Osoꞌno sɨkunoꞌnji kakoe inomokomoyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sohwa Jisasɨmo uꞌmantɨfi ulɨmentohofi, Kɨko oso hwe moyaꞌmi somo ango soꞌmneꞌno lɨhwajohojoꞌno hofɨko osopo fosyawekuji wosopayo wotɨpemapɨfe. Olo humalohwone lopo aꞌamu ango yoꞌmayoso aneponoho. ");
INSERT INTO apz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ose ko ulahonɨngkofi Jisas ulɨmento, Oꞌo, sekwo huhwasi wosopayo uyɨmno. Ose ulahonɨngki hofɨko ulɨmentohofi, Nakwo wosopayo piꞌnɨngoꞌnjo hwonanɨꞌmaho. Wopayo aho fehohnjo hopiꞌnonohinoꞌnji inanɨku hufaꞌuyo soꞌntnnohini mokosyohumalohwono. I kɨko ole losyofɨsyalokuno. Sekwo nowekuji hoꞌyango ango mtaꞌni aꞌamu hopiꞌnonohino somneꞌno wosopayo mpe uyamno. Ose losyofɨsyalokuno. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Oso aꞌamu hiso faif tausen (5000) hwafoho. Jisas kako kakoe inomokomoyo sohwamo ulɨmento, Sekwo hofɨkimo ulɨmno. Aꞌamu fifɨti (50), fifɨti (50) mɨhuꞌmokinɨngkuji wohumafe. ");
INSERT INTO apz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ose ulahonɨngki inomokomoyo sohwa hofɨko Jisas ulɨmentiso hopa mɨhuꞌmohuꞌmɨngo yɨhuꞌmatɨꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisas kako oso wosopayo aho fehohnjo hopiꞌnonohino soꞌnji inanɨku hufaꞌuyo soꞌnji nomanto kako ahwomomo tɨmo uhwontohumanto Anɨtumo isamoyoka ulɨmentisofoho. Isamoyoka nto ulonto kako wopayo hiso kutɨkujo lohofonto kakoe inomokomoyo sohwamo aꞌamu somo yano ulofiyoꞌne huꞌmuyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Aꞌamu hopiꞌnonohinoso wopayo hiso moiꞌwo nontɨfi sɨmeho uhnnɨngkahonɨngki hofɨko wosopayo nɨlɨfonaoꞌmentohofoso nuhuꞌmokontɨfi sohwo hoꞌyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo somo mohuꞌmemeehumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sɨkuno fihumo Jisas kakoꞌnohini kanɨngkwohumo jomo ulontanɨngki kakoe inomokomoyo sohwa mofonepo humohumantohofofoho. Jisas kakoe inomokomoyo sohwamo ulohonɨmento, Aꞌamu ngkineꞌno pehofo mjolɨmɨwalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ose ulahonɨngki hofɨko ulɨmentohofi, Aꞌamu fehohnjo kikineꞌno ole lalokwofo, Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwolɨkeno. Aꞌamu nomꞌne fehohnjo ole lalokwofo, Ilaijatɨkeno. I nomꞌnihwa aꞌamumo Anɨtu hungkuno uyahonɨngki lutɨhwanto peꞌnɨmentiso sohwo apaꞌno songo lɨkaꞌmaso hwolɨkeno. Kikineꞌno ose mjolɨmɨwalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo sohwasi, ngkineꞌno pehofo ntɨwoꞌnɨngkohofɨhwasilo. Ose ulahonɨngki Pita ulɨmento, Kɨko sohwosi Anɨtuye Kɨlaisɨkiyoho. Anɨtu nakwoe hwaho loponeꞌno kuhwotɨmentiso hwosoho. ");
INSERT INTO apz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita ose ulahonɨngki Jisas kako inomokomoyo sohwamo hungkuno yokumpohnꞌnyo ole ulɨmento, Sekwo oso hisoꞌno nomꞌnemo lujɨmofɨkutoho. ");
INSERT INTO apz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ose ulonto ole ulɨmento, Aꞌamufe Hwomu sohwoꞌni ngko tohino engo nomaꞌmne hwoꞌnyoho. Aꞌamu Jutafe hwe engo sohwanji aꞌamu tajo ango syohoꞌnjo sohwanji aꞌamu Jutafe honɨngkano hungkuno lutɨhwawoꞌnɨngkohofo sohwanji hofɨko ngkineꞌno nakwolaho ntɨkuji hohujo ikinjanɨmofɨkuji nofonjanɨhufitnnefoho. I osoꞌno sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno ngko apaꞌno songo wolɨkaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ose ulonto hwe moyaꞌmi hopiꞌnono Jisasɨmo inɨngkamentohofo somo ole ulɨmento, U, aꞌamu fisoku ngkimo wonnɨngkopano lɨfijoꞌmanji sekwo sekwoe yoꞌmayo hi semoꞌnɨwoꞌnɨngkiso soꞌnji sekwoe yofe soꞌnji monje yahinɨngkuji sekwo sɨkuno huhwo huhwi nje yofeꞌno poyo peꞌnyo soꞌno iyoho miyoꞌnjo ifijoso ngkimo mofo ne sopo tɨfi nnɨngkapmno. ");
INSERT INTO apz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Aꞌamu fihwo kakoe songo humayoso yokumpohnꞌnyo womokosyohumamo lososo kakoe songo neꞌno humayoso wopɨwahuꞌmontonoho. Osoꞌno aꞌamu fihwo ngkineꞌno huno uyahonɨngkuhwosi kakoe humayoso pɨwasyososo hwangku kakoe humayoso wotɨpemaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Aꞌamu fihwo kako Anɨtumneꞌno hohujo ikinjaofɨhwosi kako olo hwaho loponjo hoꞌyango hamniyoho yoꞌmayoso engo huꞌmeesyontoso sohwo kako tɨkanomo wesoꞌmanji oso hoꞌyango yoꞌmayoso pipi ufoꞌmaneto. Awonoho. ");
INSERT INTO apz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Aꞌamu fihwo kako nje hungkuno soꞌnji ngkoꞌntnneꞌno hohujo ikinjanɨmofoso sohwo ngko oso huhwo sohumneꞌno tɨfi noꞌmo hohujo ikinjɨmoꞌmnefoho. Ou, osohonta ngko nje Mpohwoe yokumpohnꞌnyo soꞌnji aꞌamu ahwomomjo wopɨngoꞌnohini sohwafe yokumpohnꞌnyoꞌnji nje yofe engoꞌnji olo hwaho lopo asomo pmme sohonta aꞌamu ngkineꞌno hohujo ikinjanɨmofoso sohuneꞌno ngko hohujo ukinjɨmoꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngko hungkuno nehopi waselɨmonneꞌno yohono. Aꞌamu olo hwaho lopo nakwoꞌnji olohonta humalofo fehohnjoso mapeꞌnontanɨngkuji Anɨtu aꞌamumo wopɨngo wonyoangkafo mokosyohumayo somo uhwonantɨfeho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sɨkuno aho fehohnjo hopiꞌnono nomꞌne mtaꞌni hufaꞌu sɨhune memjaofahonɨngki Jisas kako Pitaja Jounja Jemɨsɨjamo utɨmanto kako Mpohumo jomo ulɨmo lonto hwofɨkiꞌnyo weꞌe soponeꞌno kotasɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kako Mpohumo jomo ulontanɨngki kakoe sɨmoꞌmangoso mofehiꞌnyo paꞌnyo imoꞌnonto kakoe manjiꞌmofo sawemoso nɨhuꞌno halojo pomponaho paꞌnyo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Oso hohosohonta hwe hufaꞌu hohonta peꞌnɨmentisiye sohwaꞌu kakoꞌnjopo iꞌmofaponji hungkuno hnnɨmentohofoso Mousesɨꞌnji Ilaijaꞌnjoho. ");
INSERT INTO apz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Siko ahwomomjo yokumpohnꞌnyo soꞌnji uꞌmanji siko Jisas kako ango Jelusalem sopo yoꞌmayo Anɨtu kako Jisas yoneꞌento uyohotɨmentiso somo ne imoꞌnyoꞌne poyo umoꞌnɨmontonoho, hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitajanji nomꞌne sohwanji saho humofosyawentohofo sohwa nolɨkafontɨfi uhwonɨmentohofoso Jisasɨye pomponaho soꞌnji hwe hufaꞌu sohwaꞌuꞌnjimo uhwonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Oso hwe hufaꞌu sohwaꞌu Jisasɨmo uhwotɨꞌmofaho lonji imentisiyoso Pita kako huno piꞌnɨngo syofɨsikaofonto Jisasɨmo ulɨmento, Hwe Engofo, nakwo olopo humentani sehonɨngkuhwoneso wopɨngofoho. Olo hilo soꞌno syafɨsiyoꞌneso ango hufaꞌu sɨhune womolantaneꞌno yɨhwono. Angaꞌno kɨkoꞌnefoho. Angaꞌno Mousesɨmnefoho. Nomꞌneso Ilaijamnefoho. Pita kako oso hisoꞌno huno itoꞌno muyahonɨngki ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita ose ulontanɨngki himo hwahonepo kepijiyofasyonto hofɨkimo ifeehuꞌmokosyahonɨngki inomokomoyo sohwa hofɨko iyoho imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Oso himo hoꞌmo soꞌmtaꞌni mampaho ole hoꞌnɨmento, Olo hwe lohwo sekumneꞌno uhwosopoꞌmentohe sohwo nje Hwomufoho. Kakoe hungkunomo sekwo upaꞌnɨmno. ");
INSERT INTO apz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Oso mampaho hiso moiꞌwo hoꞌnɨkwato lohofahonɨngki inomokomoyo sohwa uhwonɨmentohofoso Jisas kakoꞌnohini lohofontanɨngki uhwonɨmentohofofoho. Inomokomoyo huhwo sohwa yoꞌmayo uhwonɨmentohofo sohonta hofɨko nomꞌne sohwamo hungkuno mulɨmmentohofofoho. Oꞌo, mampiꞌnyo humohumantohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Moꞌnɨngkanta hofɨko hwofɨkiꞌnyo weꞌe sopo ulɨkoꞌmantɨfi nowentɨfi hwe moyaꞌmi piꞌnɨngo engo honɨngkanopo Jisasɨmo uswoꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hwe fihwo kako oso hwe moyaꞌmi piꞌnɨngo engo somtaꞌni Jisasɨmo joho ulɨmento, Hwe Engofo, ngko kikimo jomo wakilɨmonneꞌno yohono. Kɨko nje hwomu lohumo tɨmo uhwonyo. Ngko olo hwomu angaꞌnohinoꞌnjo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Towahuno wonyo sohwo kako hwomu sohumo uꞌmanto aho yokumpohnꞌnyo kemokosyohumahonɨngki hwomu sohwo kako joho mohmꞌno lɨwoꞌnɨngkisofoho. Towahuno wonyo huhwo sohwo kako hwomu sohumo wonyo kimokonto mohmꞌno mohmꞌno ulohofahonɨngki hwomu sohwoe mango mtaꞌni makwoangoso sapɨwoꞌnɨngkisofoho. Towahuno wonyo huhwo sohwo kako hwomu sohwoe aꞌapaho wonyo neꞌno umokonto komoꞌno musyaꞌofeꞌnjo yonteso hwomu sohwo kakoe aꞌapahoso kangotnnyo imoꞌnɨmojofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Oseso ngko jɨje inomokomoyo sohwa hofɨko towahuno wonyo hiso wae weenɨmofife lonji humotaho ko loheso hofɨko hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ose ulahonɨngki Jisas ulɨmento, Hwe moyaꞌmi olohonta humalofo soku, sekwo Anɨtumo sɨmeho hiꞌntnnono muyo kuyoho. Sekwo honɨngkano itoꞌnohinoꞌmaho. Oso yahino hiso neꞌno wesoꞌmanji ngko sekwoꞌnji humayoso sɨkuno alale womemjanɨmoꞌmontolɨkeno. Ngko sekwoe tango ngkimo nɨꞌmayoso sɨkuno alale womemjanɨmoꞌmontolɨkeno. Jɨje hwomuso ngkoꞌnjo loponeꞌno motape. ");
INSERT INTO apz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nomotowentanɨngki towahuno wonyo sohwo kako hwomu huhwo sohumo hwahopo kelopmmokwajonto mohmꞌno hnnojwaoꞌmentisofoho. Jisas kako towahuno wonyo huhwo sohumo yoka ulonto wae yɨmofonto hwomu sohumo wopɨngo umokumentisofoho. Wopɨngo umokonto kanɨngkwohumo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hwe moyaꞌmi hopiꞌnonohinoso hofɨko Anɨtuye yokumpohnꞌnyoso utɨhwaꞌnyopo uhwonontɨfi hi ulɨkofahonɨngki hofɨko yomo imentohofofoho. Hofɨko Jisas kako imentiso soꞌno huno piꞌnɨngo engo syofɨsyontanɨngkofi Jisas kakoe inomokomoyo sohwamo ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Sekwo olo hungkuno loso selɨꞌmeꞌno haloho itoꞌno upaꞌnɨmno. Sekwo inɨngo mofɨkutoho. Hwangku weꞌenepi ngko Aꞌamufe Hwomu sohwoꞌnɨmo nje mango sohwafe aho somo hofɨko ngkimo wohoꞌnonɨsyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ose ulahonɨngki hofɨko oso hungkuno ulɨmentiso soꞌno huno mummentisofoho. Hwapɨngoso oso hungkuno hiso hofɨkineꞌno hiyaso woꞌnnyo soꞌno hofɨko huno mosyafɨsiyoꞌnjo yontɨfi hofɨko hwapɨngo ne soꞌno Jisasɨmo ujosoꞌno iyoho unɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Inomokomoyo sohwa hofɨko nakwoe hwe yofe engoꞌnjo sɨmoꞌmo yakoloso, tɨhwolɨkeno sohnnohojikamoꞌnontɨfi ikujoho wofongkiꞌnantɨfi imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisas kako hofɨkoe huno somjo huno woꞌnnyo soꞌno huno uyahonɨngki kako mehomi weꞌeso utɨmanto, momemokosyohumamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Oseso inomokomoyo sohwamo ulɨmento, Aꞌamu fihwo kako olo mehomi lohumo nje yofe hoꞌnonɨmayoꞌne ufoꞌmaso sohwo kako ngkimo nɨfoꞌmakwoho. Aꞌamu ngkimo nɨfoꞌmaso sohwo kako hwe engo ngkimo nɨhwatɨmentiso sohwo huhumo ufoꞌmakwoho. Hwe fihwo kako kakoe yofe engo somneꞌno huno mosyafɨsiyoꞌnjo aꞌamu nomꞌnimo ufoꞌmayoꞌnohini sohwo kako Anɨtuye tɨmopo hwe engo ne sɨmoꞌmjo hweho. ");
INSERT INTO apz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jisasɨye inomokomoyo Joun sohwo kako Jisasɨmo ulɨmento, Hwe Engofo, Nakwo uhwonɨmalohwoneso hwe fihwo kako jɨje yofe ulonto towahuno wonyo wae yaofontanɨngki uhwonɨmalohwonefoho. I osoꞌno kako nakwoꞌnji kikimo mokinɨngkowaloku yɨhwono i osoꞌno nakwo kakimo ulɨmalohwono, Kɨko Jisasɨye yofeꞌnji towahuno wonyoso wae yaofohotoho. ");
INSERT INTO apz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ose ulahonɨngki Jisas ulɨmento, Sekwo ose ulohoꞌmalofoso wonyofoho. Sekwo kakoe honɨngkanomo nopɨjumofɨkutoho. Aꞌamu sekwoe syoho somo mohwempeesemofe hwoꞌmanji sekwoe aꞌamu hweho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisasɨmo Anɨtu ahwomomne asomo utɨmayo sɨkuno mofonepo imoꞌnɨngkahonɨngki Jisas kako Jelusalemneꞌno we-eꞌneso huno yokumpohnꞌnyo syofɨsyomanto Jelusalemneꞌno wawomo lonto hano sɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jisas kakoe inomokomoyo sohwanji Jelusalemneꞌno nowentanɨngkofi kako kakoe inomokomoyo fihwamo aꞌamu Someliyafe ango fiponeꞌno Jisas kakineꞌno ango itoꞌno esyohumayoꞌne ulohasiyoꞌne lɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","I osoꞌno oso ango hopo soponjo aꞌamuso hofɨko Jisasɨmo hofɨkoe angomo ipemotasyuyo soꞌno nakwolaho lontɨfi mutɨmmasoꞌnjo imentohofofoho. Hwapɨngoso kako Jelusalemne hweho lontɨfi mutɨmaꞌmmentohofofoho. Hofɨko Anɨtumneꞌno hwomtame ulohofo yahinoso Jelusalemnohini uhwonyoso nakwolaho linyofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jisasɨye inomokomoyo hufaꞌu sohwaꞌu Jemɨsɨꞌnji Jounꞌnji siko yoꞌmayo yoꞌmayo yahino somo uhwononji ulɨmentisiyo, Hwe Engofo, nakwo ahwomomjo toho soꞌno joho lutɨmehwasi olo aꞌamu lomo nasiyoso wopɨngotaho. ");
INSERT INTO apz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Ose ulahonɨngki Jisas kako sikimo yoka ulɨmento, Siko sikoe sɨmeho moꞌmjo huno wonyoso huno maseyohi yohoho. Ngko Aꞌamufe Hwomu sohwoꞌni ngko aꞌamumo wonyo imokiyoꞌne pmmentohe hwonɨꞌmaho. Oꞌo, aꞌamumo ufoꞌmayoꞌne pmmentohe hwoꞌnyoho. Ose ulahonɨngki hofɨko nomꞌne ango poneꞌno womentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hofɨko honɨngkanopo nolohoꞌnowentanɨngkofi hwe fihwo Jisasɨmo ulɨmento, Kɨko ango ntɨꞌmno usoso ngko tɨfi wokinɨngkamonnoho. ");
INSERT INTO apz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ose ulahonɨngki Jisas ulɨmento, Sikisɨwojo sohwa hofɨko hofɨkoe sokimoso hiꞌnjo hwafoho. Yɨhufo sohwa hofɨko hofɨkoe aifoso hiꞌnjo hwafoho. I osoꞌno ngko Aꞌamufe Hwomu sohwoꞌni ngko ango saho fosyaweꞌneso ane hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ose ulonto kako nomꞌne hwe sohumo ulɨmento, Kɨko ngkimo tɨfi nnɨngkape. Ose ko ulahonɨngki hwe sohwo kako ulɨmento, Kɨko ngkimo tɨfi nnɨngkape ntohino soꞌno ngko kikimo wokinɨngkapmmonnoho. I osoꞌno sɨmoꞌmo ngko nje mpohumo kakiꞌno piꞌnɨmoꞌmo ijopijisyasiꞌmo peso. Wopɨngotaho. ");
INSERT INTO apz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ose ulahonɨngki Jisas ulɨmento, Aꞌamu ngkimo tɨfi monnɨngkapɨfijoso hofɨko ujopijisyahufe. Hofɨkoe syohofoho. I kɨko sohwosi ngkimo nnɨngkapohoji Anɨtu aꞌamumo wopɨngo umokosyohumamonto yalokunjo soꞌno kɨko aꞌamu somo Anɨtu kakoe hungkunoso filɨjɨmofo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hwe nomꞌnihwo Jisasɨmo ulɨmento, Hwe Engofo, ngko kikimo tɨfi wokinɨngkamonnoho. I osoꞌno ngko sɨmoꞌmo nje aꞌamumo aho nɨhuꞌno upeemeso wopɨngotaho. ");
INSERT INTO apz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ose ulahonɨngki Jisas ulɨmento, Aꞌamu ngkimo tɨfi ko nnɨngkapɨhwosi kako tɨfi noꞌmo yoꞌmayo ulɨkoꞌmaso soꞌno ikintɨmantɨmo mjɨmɨweꞌnjo sohwo kako Anɨtu aꞌamumo mokosyohumayo sopono syoho iyo soꞌno hopoꞌmaho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Oso hohosohonta Jisas kako nomꞌne aꞌamu sefenti-tu (72) sohwamo kakoe syoho somneꞌno uhwosopoꞌmentisofoho. Kako aꞌamufe ango hoꞌmo hoꞌmeemo tɨfi ngko nuꞌmaꞌmneꞌento ango hoꞌmo hoꞌmneꞌno hwe hufaꞌu hufaꞌu lɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Sɨmoꞌmo hungkuno ole ulɨmento, Pahnnɨmo hungkuno waselɨmonneꞌno yohono. Wopayo syoho soponjo piꞌnɨngo engoso toyo nto imaho. I osoꞌno aꞌamu wopayo toyo mjiyoꞌne syohoꞌnjo sohwa hopoenohino hwaꞌmaho. Oseso sekwo olo syoho loso mokosyohumawoꞌnɨngkiso kakwoꞌyohumo jomo ulɨkujoꞌno kako oso wopayo toyo homo somo mjiyoꞌne aꞌamumo lɨhwajiyoꞌne jomo ulɨmno. ");
INSERT INTO apz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sekwo upaꞌnɨmno. Ngko sekumo yahu mu hopa sikisɨwojo sohwafe angoꞌmneꞌno wokasemoꞌmji yalokweno. Hofɨko sekumo wonyo woselohofantɨfeꞌno yalokwofo. Sekwo yahu mu hopa yokumpohnꞌnyo aneꞌnjo sohwahnneꞌno huno ose ko niyahonɨngki losehwojalokweno. Osoꞌno mpanɨmno. ");
INSERT INTO apz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sekwo hamniyoho soꞌnji yoꞌmayo hoꞌyango memokomayoꞌne soꞌnji sɨfɨkwongofosyo nomꞌne soꞌnji nohuꞌmemokahoꞌnɨngkutoho. Sekwo honɨngkanomo wekuji uhwonɨfijoso hwe fihwo honɨngkanopo nohumentanɨngkuhwosi uhwonɨngkuji nɨjwokohumafɨkutoho. Oꞌo, sekwo kakimo yakoloꞌnohini ulohofefoho. ");
INSERT INTO apz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Sekwo aꞌamufe ango sopo iꞌmofahokuji ole ulɨmno. Anɨtu kako sekumo wopɨngo waselohomonto iwoꞌnɨngkiso soꞌno sekwo sɨmeho wopɨngoꞌnji fosyohumamno. Ose ulɨmno. ");
INSERT INTO apz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Hwe fihwo kako yahino wopɨngo iwoꞌnɨngkiso sohwoe angopo iꞌmofafijoso kako sekumo wopɨngo selohofɨhwosoꞌno Anɨtu oso aꞌamu huhwo sohumo wopɨngo ulohoꞌmontonoho. I osoꞌno aꞌamu fihwo yahino wonyo iwoꞌnɨngkiso sohwoe angopo iꞌmofafijoso sekwo Anɨtu wopɨngo ulohoꞌmonto iwoꞌnɨngkiso soꞌno sɨmeho wopɨngoꞌnjo fosyohumamno, ulɨfijoso hwe huhwo sohwo ngkilaho selɨhwosi mosefoꞌmasoꞌnjo ihwosoꞌno sekwo nomꞌne angopo neꞌno sɨmeho wopɨngoꞌnjo hwasi fohumpopmno. Anɨtu kako sekumo wopɨngo sefoꞌmahwosi oso aꞌamu huhwo sohumo mufoꞌmanehoho. ");
INSERT INTO apz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aꞌamu fihwo kakoe angommneꞌno setɨmahwosoꞌno sekwo oso ango homo somnohini humafɨkuji yoꞌmayo wosopayoꞌnji mijoꞌnji sejapɨkujoꞌno sekwo hmnɨmno. Hwapɨngoso aꞌamu kakoe syoho somneꞌno kako yoꞌmayo mayoso yahino itoꞌnohinofoho. Sekwo ango angaꞌnohino somo fosyawekuji nomꞌne angomno nonje nonje uyoꞌeno. Oꞌo, oso ango angaꞌnohino somtaꞌni nje hungkuno filɨkuꞌmopmno. ");
INSERT INTO apz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Sekwo ango fipo iꞌmofahokujoꞌno aꞌamu hofɨko sekumo setɨmafɨkuji yoꞌmayo mijo wosopayo soꞌnji sekuneꞌno lɨkuji yano selofifijoso sekwo umapmno. ");
INSERT INTO apz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Sekwo oso ango hopo soponjo aꞌamu mnokinoꞌnjo somo wopɨngo umokukuji hofɨkimo ole ulɨmno, Anɨtu sekumo wopɨngo semokosyohumayoꞌne mofonepo nto iꞌmofapohoho. ");
INSERT INTO apz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","I osoꞌno sekwo ango fipo iꞌmofahokujoꞌno aꞌamuso sekumo mosetɨmasoꞌnjo miyɨkuji sekwo oso ango hopo soponjo honɨngkano sopo lohofɨkuji ole ulɨmno, ");
INSERT INTO apz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Sekwoe ango loponjo hwaho hintalinyo namongkiꞌnɨngkisoso sekwo sekwoe yahino somneꞌno huno syafɨsiyoꞌno nakwo hintalinyo hiso wae yasyɨhwoneso sekwoꞌnefoho. Sekwo olo soꞌno huno itoꞌno fɨsyafɨhupmno. Anɨtu kako sekumo wopɨngo wosemokosyohumamonto ko yahonɨngki osoꞌno sekwo hohujo ikinjaofɨwoꞌnɨngkohofo kuyoho. Oseso nakwo tohino manoho lɨkuji Anɨtu semokosyohumayo soꞌno huno itoꞌno fɨsyafɨhupmno. Nto iꞌmofapohoho. ");
INSERT INTO apz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ose ulonto ole ulɨmento, Nje aꞌamu sohwasi ngko hungkuno waselɨmonneꞌno yohono. Sɨkuno aeꞌuyo somo aꞌamufe yahino wonyo soꞌne hungkuno ikwolofoꞌne sohonta oso ango Soutommjo aꞌamuso hofɨkoe yahino pisakinoꞌnjo somneꞌno tohino engo wotɨpemantɨfeho. I osoꞌno aꞌamu sekumneꞌno hohujo ikinjasemofoso hofɨkoe tohinoso Soutomjo aꞌamufe tohino somo yakoloꞌnnyofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","U, aꞌamu Koulasin sokunonji aꞌamu Mpetɨsaitajo sokunonji sekwo Anɨtuye tohino somneꞌno iꞌwaho itoꞌno fiyɨmno. Ngko sekwoe angopo yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngki yohofoso esetɨhwamentohe somo aꞌamu ango Taiyaꞌnji ango Saitounꞌnji hohonta humamotofoso hofɨko uhwonontɨfijontentesi hofɨko hofɨkoe yahino wonyo somneꞌno hulɨngkwajingo aꞌapahopo lohoꞌnɨngkuji hofɨkoe honɨngkano wonyo somo hohujo nto ikinjaofɨkutnnesohilo. I sekwo yoꞌmayo wopɨngo ngko imalesomo ko uhwonontɨfi sekwoe yahino wonyo somneꞌno hohujo mikinjaoꞌmmalofo kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Anɨtu kako aꞌamufe honɨngkano wonyo somneꞌno yano ilofoso sohonta Taiyajo aꞌamu soꞌnji Saitounjo aꞌamu soꞌnji hofɨko Anɨtuye tohino engo tɨpemapitnnefoho. I osoꞌno sekwoe tohinoso yakoloꞌnnyo kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","I oso sɨkuno homo somo ango Koponeyamjo aꞌamu humawoꞌnɨngkohofo soku ngko sekumneꞌno pehofo selɨmnehono. Sekwo sekwoe yofe yokintahopo ko hoꞌnomaꞌnɨwoꞌnɨngkohofo soku sekwo tɨkanomo ufitnne kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisas ose ulonto kako kakoe inomokomoyo sohwamo ulɨmento, Aꞌamu sekwoe hungkuno halohoꞌno sepewoꞌnɨngkiso sohwo nje hungkuno homo halohoꞌno nɨpewoꞌnɨngkisofoho. Aꞌamu sekumo hohujo ikinjasemofɨwoꞌnɨngkiso sohwo ngko huhwoꞌnɨmo hohujo ikinjanɨmofɨwoꞌnɨngkiso hweho. Aꞌamu ngkimo hohujo ikinjanɨmofɨwoꞌnɨngkiso sohwo kako Anɨtu nɨhwatɨmentiso sohwo huhumo hohujo ikinjɨmofalofoho. Jisas ose moiꞌwo ulonto kako aꞌamu huhwo sohwamo uhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hwangku noꞌmo aꞌamu sefenti-tu (72) Jisas kakoe syoho somneꞌno uhwatɨmentiso sohwa hofɨko asomo iꞌmɨwentɨfi sɨmonyo imentohofofoho. Sɨmonyo yontɨfi Jisasɨmo ulɨmentohofi, Hwe Engofo, nakwo towahuno wonyo somo jɨje yofe ulɨmalohwone soꞌno hofɨko jɨje yofe somneꞌno enjwaꞌmo paswontɨfi hiyaso humpoꞌmalofofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ose ulahonɨngkofi Jisas ulɨmento, Ngko Seten ahwomo mtaꞌni emtaꞌmɨngo hopa yonto pɨwesyahonɨngki uhwonɨmentohefoho. ");
INSERT INTO apz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sekwo upaꞌnɨmno. Ngko nje yokumpohnꞌnyo sejapmmentohe soꞌno sekwo homa wonyo soꞌnji aꞌnantɨhwoyo soꞌnjimo sekwo hwotoho fɨfijoso hopoenohino hwasoho. Sekwo Setenɨye yokumpohnꞌnyo somo uyakolofoꞌne yokumpohnꞌnyo hiꞌnjo hwasoho. Yoꞌmayoso sekumo wonyo semokoneso awonoho. ");
INSERT INTO apz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","I oseso sekwo olo soꞌno sɨmonyo ikuji huno ole syafɨsyɨkutoho. Towahuno wonyo sohwa nakwoe hungkunomo enjwaꞌmo humalofo. Osoꞌno sekwo sɨmonyo ikutoho. Oꞌo, Anɨtu sekwoe yofe ahwomomo mtɨꞌmokasehumentiso soꞌno sɨmonyo fiyɨmno. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Oso hohosohonta Anɨtuye Towahuno Wopɨngo sohwo Jisasɨye sɨmeho wopɨngo umokahonɨngki Jisas kako sɨmonyo yonto Mpohumo ulɨmento, U, Mpohwoe, kɨko ahwomomjo yoꞌmayo soꞌnji hwahoponjo yoꞌmayo soꞌnji hwapɨngo hwosoho. Ngko ole soꞌno isamoyoka kilalokweno. Yoꞌmayo iwoꞌnɨngkinoso kɨko aꞌamu hwahoponjo huno engo tɨpemaꞌmentohofo somtaꞌni hiyaso hoꞌnahumentohinofoho. I aꞌamu hofɨko mehomimneꞌno sɨmeho kanɨngkwohwoꞌyaꞌumo uyɨwoꞌnɨngkohofo hopa kijopontanɨngkofi kɨko ujo ehontojwahumahnnofoho. Ou, Mpohwo, kɨko ose imoꞌnoneꞌenji imentohinoso olohopeho. ");
INSERT INTO apz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ose ulonto kakoe inomokomoyo sohwamo ulɨmento, Nje Mpohwo kako yoꞌmayo hopiꞌnonohinoso nje ahomo hoꞌnanɨhumentisofoho. Olo hwaho loponjo aꞌamu fihwo kako nje hwapɨngo soponeꞌno huno inyoso tɨhwolo. Awonoho. Nje Mpohwo kakoꞌnohini huno uyohoho. U, Mpohwoe hwapɨngo soponeꞌno huno inyoso tɨhwolo. Oꞌo, ngko kakoe Hwomu hwoꞌnnohini huno niyohoho. U, ngko Mpohumo wosetɨhwamo ulɨwoꞌnɨngkohe aꞌamuso hofɨko hiꞌnji ngkoꞌntnnohini huno nayohoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jisas kako kakoe inomokomoyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sohwantnnohini humantɨfi Jisas hofɨkimnohini ulɨmento, Aꞌamu yoꞌmayo yoꞌmayo sekwo uhwonɨwoꞌnɨngkohofo somo uhwonɨngkuji sɨmonyo uyɨfe. ");
INSERT INTO apz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ngko hungkuno waselɨmonneꞌno yohono. Hohontajo aꞌamu somo Anɨtu hungkuno uyahonɨngki lɨmotofo sohwanji aꞌamu yofe engoꞌnjo hwaho mokosyohumayo piꞌnɨngo sohwanji hofɨko yoꞌmayo sekwo uhwonalokwofo somo uhwonano lontɨfi ko imentohofoso muhwonɨmmentohofofoho. Yoꞌmayo sekwo upoꞌnalokwofo loso hofɨko upoꞌnano lontɨfi ko imentohofoso hofɨko mupaꞌnɨmmentohofofoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Aꞌamu Jutafe honɨngkano hungkuno lutɨhwamojo sohwo kako Jisasɨmo yamofo ulohoꞌmo lonto nuꞌmanto ulɨmento, Nje Lontɨhwayo sohwosi, ngko songo neꞌno humayoꞌne yoꞌmayoso pipi iꞌmo womaꞌmonnto. ");
INSERT INTO apz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ose ulahonɨngki Jisas ulɨmento, Mousesɨye honɨngkano hungkuno nejapmmentisoso hungkuno pehofo woꞌnnyoto. Atofo lonji huno pipi kiyohoho. ");
INSERT INTO apz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ose ulahonɨngki kako ulɨmento, Kɨko jɨje Hwe Engo Anɨtu sohuneꞌno sɨmeho uyohoji jɨje sɨmeho hopiꞌnonohinoso kakimo uyo. Kɨko jɨje Hwe Engo Anɨtu sohuneꞌno jɨje sɨmeho uyohoji jɨje huyoꞌmango hopiꞌnonohinoso kakimo uyo. Kɨko jɨje Hwe Engo Anɨtu sohuneꞌno sɨmeho uyohoji jɨje yokumpohnꞌnyo hopiꞌnonohinoso kakimo uyo. Kɨko jɨje Hwe Engo Anɨtu sohuneꞌno jɨje sɨmeho uyohoji jɨje huno hopiꞌnonohinoso kakimo uyo. Ose yohoji aꞌamu kɨkoꞌnjopo mofonepo humawoꞌnɨngkohofo somo kɨko kikineꞌno kumoꞌnɨwoꞌnɨngkiso hopaso nomꞌne aꞌamu somneꞌno oseno wakumoꞌnono. ");
INSERT INTO apz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ose ulahonɨngki Jisas ulɨmento, Hopi lohino. Kɨko oso hungkuno ntoꞌnohino losomo inɨngkafijoꞌmanji kɨko songo neꞌno humayoꞌneso watɨpɨhwonɨmonnoho. Noho fɨtɨpemaho. ");
INSERT INTO apz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ose ulahonɨngki hwe huhwo sohwo kako kakoe yofe wopɨngo umokinɨmonto yonto ole ulɨmento, Nomꞌne aꞌamu ngkoꞌnjo mofonepo humawoꞌnɨngkohofo somo ngko hofɨkineꞌno nɨmoꞌnyoso pipilo. ");
INSERT INTO apz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ose ulahonɨngki Jisas pahnnɨmo hungkuno ole ulɨmento, Hwe fihwo kako ango Jelusalem ulɨkoꞌmanto ango Jelikou soponeꞌno womaso hweho. Aꞌamu wonyo hufoꞌnohino sohwa honɨngkanopo uhwonɨmaꞌnontɨfi hofɨko kakoe hoꞌyango yoꞌmayoso moiꞌwo lonteꞌmemantɨfi kakimo ikujoho fongkuꞌmentohofofoho. Ose ulohofontɨfi humpoꞌmentohofofoho. Oso hwe huhwo sohwo kako honɨngkanopo nohumanto kako weꞌenepi poyo wapeꞌnɨmonto imentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Oso hohosohonta hwe fihwo kako tajo ango syohoꞌnjo sohwo kako honɨngkano homo somo womentisofoho. Kako nowento hwe huhwo sohumo uhwononto kako ikitofonto uyakoloꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nto uyokolofahonɨngki hwe nomꞌne Lifaiye temtitofo mtaꞌango sohwo kako aꞌamu tajo ango syohoꞌnjo sohwamo enjwaꞌmo syoho iwoꞌnɨngkiso sohwo kako hwe huhwo sohumo uhwononto kako huhwo ikitofonto uyakoloꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","I osoꞌno oso hohosohonta hwe nomꞌne hwaho Someliyantaꞌango sohwo kako oso Jelikou honɨngkano homo somo nowento uhwonɨmentisoso hwe huhwo sohwo nohumentanɨngki uhwononto hitoho uloꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kako hwe huhwo sohwoꞌnjo mofone sopo nowento hwe ikujoho fongkuꞌmentohofo sohumo ulɨkafonto mijo iloho emanto yopoꞌnyo fesyomaꞌmentisofoho. Fesyomanto kakoe uyo somo fosyo ufohumentisofoho. Nto ufosyonto kako hwe sohumo nohoꞌnomanto kakoe yahupo mɨhumajonto ango fosyaweꞌne somo motawento wopɨngo umokosyohumamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Moꞌnɨngkanta kako oso ango engoso mokosyohumawoꞌnɨngkiso kakwoꞌyohwo sohumo sɨfe aho hopiꞌnonohino kina uyonto ulɨmento, Kɨko olo hwe huhwo lohumo hamniyoho kijapoheso kakineꞌno yoꞌmayo mpe yohoji itoꞌno mokosyohumaho. Hamniyoho hiso moiꞌwo imoꞌnɨngkuhwosoꞌno jɨje hamniyoho ihnꞌnamoꞌnjoꞌmanji ngko hwangku asomo pmme sohonta ngko kikimo aku wokijapmmonnoho. Ose ulonto umentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas kako oso hungkuno hiso ulonto kako ulɨmento, Kɨko huno pipi kiyohoho. Aꞌamu hufaꞌu sɨhune sohwa oso hwe fonjahumentohofo sohumo uhwontopahonɨngkofi oso aꞌamumo sɨmeho nehopi aꞌamu mofonepo humawoꞌnɨngkohofo hopaso tɨhwo uꞌmasohwolo. ");
INSERT INTO apz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ose ulahonɨngki oso aꞌamu honɨngkano hungkuno lutɨhwamojo sohwo ulɨmento, Olo aꞌamu lohwo kako kakoe mangohwo ko huhumneꞌno hitoho ulofahonɨngki ufoꞌmaꞌmaso hweho. Ose ulahonɨngki Jisas ulɨmento, Kɨko nuhuji aꞌamu somo oseꞌnohini ulohofo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisasɨꞌnji kakoe inomokomoyo sohwanji hofɨko Jelusalemneꞌno hano neꞌno nosontɨfi ango fipo iꞌmofamentohofoso osopo aꞌmu fisi kakoe yofe Mota kako uhwonɨmentisoso kako Jisasɨꞌnji kakoe inomokomoyo sohwanjimo uhwononto kakoe angomno ipemotawomentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Motafe konampiye yofeso Maliyafoho. Jisas kako angomo noswopahonɨngki Maliya kako Jisasɨye sɨfɨkiꞌnyoꞌmo humanto kakoe hungkunomo haloho humupoꞌntohumantisofoho. ");
INSERT INTO apz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maliya osopo nohumentanɨngki Mota kako wosopayo ntoꞌno esyohumayo syoho engo yonto kako yoꞌmayo soꞌno huno piꞌnɨngo piꞌnɨngo syofɨsikaofonto Jisasɨmo ulɨmento, Hwe Engofo, nje nampohwo kako ngkimo monɨfoꞌmasoꞌnjo ngkoꞌnohini wopayo iloho yoꞌmayoso yalokweno. Oso yahinoso wopɨngotaho. Kɨko nje nampohumo filɨhwajo. Ngkimo wonɨfoꞌmano. ");
INSERT INTO apz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ose ulahonɨngki Jisas ulɨmento, Motafo, Motafo, kɨko huno piꞌnɨngo engo syafɨsyonji jɨje sɨmeho yoꞌmayo piꞌnɨngo engo somneꞌno pehoꞌno kilɨkakwoho. ");
INSERT INTO apz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Angaꞌnohino wonyoangkafoso yoꞌmayo hwahoponjo somo yakoloꞌnnyoso woꞌnnyofoho. Kɨko oso hisomneꞌno umofonyo yalokuno. Maliya kako oso wopɨngo hiso womaꞌmonto nje hungkunomo upoꞌnalofoho. Oso wopɨngoso kakintaꞌni wae meeofanehwono. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sɨkuno fihumo Jisas kako Mpohumo jomo moiꞌwo ulahonɨngki kakoe inomokomoyo fihwo kakimo ulɨmento, Hwe Engofo, hohonta Joun kako kakoe inomokomoyo sohwamo Mpohumo jomo ujoꞌne itɨhwamentisofoho. Oso hopa kɨko olohonta fonetɨhwaho. ");
INSERT INTO apz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ose ulahonɨngki Jisas ulɨmento, Sekwo Mpohumo jomo ulano lɨkujoso sekwo olo paꞌnyoso ulɨmno. Mpohwo jɨje yofe wopɨngoꞌnohinoso neꞌnohini wohoꞌnɨwoꞌnɨngkuhwono. Oso sɨkuno kɨko yoꞌmayo hopiꞌnono yokumpohnꞌnyo nemokosyohumayoso komoꞌno umoꞌnono ");
INSERT INTO apz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Sɨkuno huhwo huhwi nakwoe wosopayo fonejape. ");
INSERT INTO apz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nomꞌne aꞌamu nakumo wonyo nalohofosofe wonyo somo nakwo wae yaoꞌmalohwone hopaso kɨko nakwoe wonyoso wae fenamofo. Kɨko nakumo yamofo nalohofo somo nonehumajohotoho. ");
INSERT INTO apz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ose lutɨhwanto kako Mpohumo jomo ujoꞌne nomꞌne hungkuno lutɨhwamento, Sekwo angaꞌnohini fihwosi kɨko sɨkwoꞌmiyo kuntoliyopo aꞌamu kɨkoꞌnjo mofone sopo humawoꞌnɨngkiso sohwoe angomo uꞌmahoji ulɨmnoho. Kɨko wosopayo hufaꞌu sɨhune ntape. ");
INSERT INTO apz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nje aꞌamu kako honɨngkanomo noponto ngkimo nɨꞌmaso sohwo ngko wopayo nuyɨmneso ane hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ose ulohojoꞌno kako oso hwe ango homo somjo sohwo kako ole wakilɨmontonoho. Kɨko ngkimo syoho engo pehoꞌno ntopantokuno. Hokuꞌyo nto pɨjwasyonji nje mehomiꞌnji nakwo saho fosyawotohwono. Ngko yoꞌmayoso nolɨkahmꞌmo mokijapmnehono. ");
INSERT INTO apz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ose kilɨhwosoꞌno kɨko pipi uyɨmonnto. Ngko sekumo waselɨmonneꞌno yohono. Oso hwe ango somjo sohwo kako ole wosyafɨhuꞌmontonoho. Oso hwe huhwo sohwo kako nje aꞌamu ko huhuneꞌno ngko molɨkafeꞌnjo iꞌmo ngko muyoꞌnjo uyɨmonnoho. Ose ko syafɨsyɨhwosi kɨko joho neꞌno lɨwoꞌnontanɨngkohoji oso aꞌamu ango somjo sohwo kako nolɨkafɨhwosi yoꞌmayo hopiꞌnonohino kɨko umofonyo inyoso wokijapmmontonoho. Hwapɨngoso kɨko kakimo jomo neꞌno ulɨwoꞌnɨngkohino soꞌno wonɨmango munyofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Oso paꞌnyoso Mpohumo jomo ujoꞌne yahino woꞌnnyofoho. Sekwo Mpohumo jomo neꞌno ulɨfijoso kako yoꞌmayoso wosejapmmontonoho. Sekwo yoꞌmayo soꞌno hafɨhafe tɨpentanɨngkuji sekwo oso hiso uhwonantɨfeho. Sekwo hokuꞌyopo hwanɨngo fonjɨkujoꞌno Anɨtu kako sekumo wosehwosampoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aꞌamu hopiꞌnonohino hofɨko Mpohumo yoꞌmayo soꞌno jomo ulɨkujoꞌno Anɨtu uyɨmontonoho. Aꞌamu yoꞌmayo soꞌno hofɨko hafɨhafe tɨpɨfijoso wotɨpemantɨfeho. Aꞌamu hokuꞌyopo hwanɨngo fongkupijoso Anɨtu kako wosehwosampoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sekwo mpohwosa sohwasi sekwoe hwomu sohwa inanɨkuꞌne selɨfijoso sekwo homa wonyoso uyantɨfetaho. Awonoho. ");
INSERT INTO apz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","I yɨhuꞌmno soꞌno selɨfijoso sekwo aꞌnantɨhwoyo uyantɨfetaho. Awonoho. ");
INSERT INTO apz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Oseso sekwo honɨngkano wonyoꞌnjo ko huhwasi sekwo sekwoe mehomimo yoꞌmayo wopɨngoꞌnohini uyɨwoꞌnɨngkohofo soꞌno sekwo huno ole waseyono. Sekwo sekwoe senɨngkwohwo Anɨtu ahwomomo humaso sohumo jomo ulɨkujoꞌno kako kakoe Towahuno Wopɨngoso yoꞌmayo hwahoponjomo yakoloꞌnnyoso wosejapmmontonoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sɨkuno nomꞌnehwi Jisas kako hwe iloꞌnnyo sohumtaꞌni towahuno wonyo wae yaofahonɨngki towahuno wonyo sohwo nto lɨꞌmofahonɨngki hwe huhwo sohwo hungkuno itoꞌno lɨmentisofoho. Aꞌamu piꞌnɨngo engoso oso homo somo uhwonontɨfi yomo yontɨfi pisopisaho mjalɨmɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","I osoꞌno aꞌamu fehohnjo sohwa ole lɨmentohofi, Towahuno wonyo hopiꞌnonohino sohwafe hwe engoso Setenɨyoho. Oso hwe huhwo sohwo kakoe yofe nomꞌneso Mpelɨsepulɨyoho. Oso humtaꞌni Jisas kako yokumpohnꞌnyo nomanto towahuno wonyo homo somo wae yaofalofoho. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aꞌamu nomꞌne sohwa hofɨko Jisasɨmo yamofo uyano lontɨfi ulɨmentohofi, Kɨko yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso fonetɨhwaho. Ose uhwonɨngkuhwasi Anɨtu kɨkoꞌnji humaho wolano. ");
INSERT INTO apz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ose ulahonɨngkofi Jisas kako hofɨkoe huno somo huno moiꞌwo uyahonɨngki ole ulɨmento, Hwaho fiponjo aꞌamu hopiꞌnonohino humawoꞌnɨngkohofoso hofɨko hotitopijo sohonta ikujoho fongkiꞌnɨngkuji hofɨkoe wopɨngo fosyohumayoꞌneso wonyo umoꞌnɨmontonoho. I oso paꞌnyoso aꞌamu hofɨkoꞌmontohwa hofɨko yoka hnnɨngkuji hofɨkoe fosyohumayoso wonyo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Oseso sekwo olo soꞌno pehoꞌne lalokwofo. Ngko Seten mtaꞌango yakumpohnꞌnyo towahuno wonyo wae yaofoꞌne mantɨꞌmtentesi Setenɨye aꞌamu sohwa hotitofɨkuji ikujoho fongkiꞌnɨngkutnnesohilo. Oseꞌmanji Setenɨye yokumpohnꞌnyoso pipi umoꞌnɨmontolo. ");
INSERT INTO apz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","I Seten kako towahuno wonyo wae yaofoꞌne ngkimo nɨfoꞌmantokusoꞌmanji sekwoe inomokomoyo towahuno wonyo wae yaofɨwoꞌnɨngkohofo somo tɨhwo ufoꞌmahwosoꞌno weeofantɨfeto. Oꞌo, sekwoe inomokomoyo huhwa towahuno wonyo somo wae yaofalokwofo soꞌno nakwo huno ole nayohoho. Sekwo ngkineꞌno hwasyo hungkuno lalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","I osoꞌno ngko Anɨtu mtaꞌango towahuno wonyo wae yaofoꞌne yokumpohnꞌnyo malokweꞌmanji oso sɨkuno Anɨtu wosemokosyohumamonto isoso nto seꞌmahonɨngki sekwo oso hisoꞌno hohujo ikinjaofalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Seten kako kakoe yoꞌmayo yoꞌmayo somo kako kakoe mekino sampe yoꞌmayo soꞌnji yohofɨhwontohumawoꞌnɨngkisoso nomꞌnihwo kako yoꞌmayoso wae meeofonehoho. ");
INSERT INTO apz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","I osoꞌno hwe nomꞌne Setenɨye yokumpohnꞌnyo yakoloꞌnnyo sohwo nopɨhwosi kako Setenɨye mekino sampe yoꞌmayoso kakimo yokumpohnꞌnyo imokinyoꞌne mokosyohumantoso somo wae yaofɨhwosi kakoe yoꞌmayoso womaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Aꞌamu fihwo kako nje aꞌamu mmoꞌnyoꞌnjo yoso sohwo kako nje mango hweho. Aꞌamu nje syoho somneꞌno monɨfoꞌmaso sohwo kako syoho homo somo fonɨfonyo imokalofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Towahuno wonyo kako aꞌamufe sɨmeho moꞌmo humamojo sohwo oso ango somtaꞌni ulɨkoꞌmahwosi nomꞌne hwaho aꞌamu mohumunyopo usijoꞌno humayoꞌne hafɨhafe wonyopi tɨpehwosi kakoe ango sɨmoꞌmjo somneꞌno asomo wapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Asomo nopɨhwosi oso ango homo somo uhwonososo ango homo somo hintalinyo wae nto yososo wopɨngomo uhwonɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ose uhwonɨngkuhwosi kako nuhwosi nomꞌne towahuno wonyo aho fehohnjo hopiꞌnono nomꞌne mtaꞌni hufaꞌuyoso hofɨko hofɨkoe wonyoso sɨmoꞌmjo sohwoe yakoloꞌnnyo somo kako utɨmahwosi kakoe ango homo somo humayoꞌne upemotawomontonoho. Oseso oso hwe huhwo sohwo sɨmoꞌmo kako wonyo humamojo sohwo kako olohonta wonyo mɨkunɨmposo somo humaho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Oso hohosohonta hwe moyaꞌmi piꞌnɨngo engo nohumentanɨngkofi aꞌmu fisi nohumanto Jisasɨmneꞌno joho ulonto ulɨmento, Hnnaꞌwohi kikimo kumanto amno kijapmmentisosi kako kikineꞌno sɨmonyo uyono. ");
INSERT INTO apz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ose ko ulahonɨngki Jisas ulɨmento, Oꞌo, sɨmonyo iyo yahino neso olenoho. Hwe moyaꞌmi hofɨko Anɨtuye hungkunomo upaꞌninyoso inɨngkafijoꞌmanji hofɨko sɨmonyo nehopi uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hwe moyaꞌmi piꞌnɨngo engoso Jisasɨꞌnjopo uhuꞌmokontanɨngkofi Jisas kako olo hungkuno loso ulɨmento, Hwe moyaꞌmi olohonta humalofo soku wopɨngo kuꞌmaho. Hwapɨngoso sekwo ole ntɨwoꞌnalokwofo, Kɨko yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso yohojoꞌnoꞌmanji nakwo nokohonɨngkuhwasi nakwo huno wonayono. Kɨko Anɨtuye Hwomu Ne hwosoho. Ose ko ntɨwoꞌnɨngkohofoso ngko oso hiso mutɨhwamonnehono. Oꞌo, Jouna hohonta humamojo sohwo ulohoꞌmentiso hopaso osoꞌnohini wosetɨhwamonnoho. ");
INSERT INTO apz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Hohonta yoꞌmayo Jounamo uꞌmaꞌmentiso somo aꞌamu Ninifoso uhwonontɨfi hofɨko huno ole umento, Anɨtu Jounamo lonehwatɨmentisofoho. Oso hopaso yoꞌmayo ngko Aꞌamufe Hwomu sohwoꞌnɨmo nɨꞌmante soꞌno olohonta aꞌamu humawoꞌnɨngkohofoso nohonɨngkujoꞌno hofɨko huno ole uyono. Anɨtu ngkimo nɨhwatɨmentiso hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Hwangku aꞌamufe yahino wonyo somneꞌno Anɨtu kako yano ilofoꞌne sɨkuno somo iꞌmofapɨhwosoꞌno oso aꞌmu yofe engo hwaho mokosyohumayoꞌnesi kako hwaho mongkihntaꞌni mokosyohumamojosi kako nolɨkafɨhwosi sekwo olohonta humalofo sokumo ole selonefoho. Sekwo Anɨtumo minɨngkayoso pehoꞌnekulo. Ose selonefoho. Hwapɨngoso hohonta hwe yofe engoꞌnjo Soulomoun humamojo sohonta oso aꞌmusi kako hwaho ikanopontaꞌangosi kako Soulomoun Anɨtuye hungkuno wolontɨhwano lonto kako sapmmentisofoho. I osoꞌno olohonta hwe nomꞌne Soulomounɨmo yakoloꞌnnyo sohwo sekwoꞌnji olopo ko humaso sohumo sekwo kakimo minɨngkowalokuyohofo. ");
INSERT INTO apz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Anɨtu kako aꞌamufe wonyo somjo tohinoso yano ilofiyoꞌne sɨkuno somo aꞌamu ango Ninifontaꞌangoso nolɨkafɨkuji sekwo olohonta humalofo sokumo ole selɨfitnnefoho. Sekwo sekwoe honɨngkano wonyo somneꞌno sɨmeho mɨwoloꞌmokiyoꞌnjo pehoꞌno imentohofokulo. Ose selɨfitnnefoho. Hwapɨngoso aꞌamu Ninifoso hofɨko oso hungkuno Jouna lɨjwaoꞌmentiso somo upaꞌnontɨfi hofɨkoe honɨngkano wonyo somneꞌno sɨmeho iwoloꞌmokumentohofofoho. I olo soꞌno olohonta hwe fihwo Jounamo yakoloꞌnnyo sohwo sekwoꞌnjo olopo ko humasoso sekwo sekwoe honɨngkano wonyomneꞌno sɨmeho mɨwoloꞌmokiyofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Aꞌamu fihwa sikiloho mongkujontɨfi hiyasoꞌmo u, ahwonte enjwaꞌmo mohoꞌnasiyoꞌnjo hwafoho. Oꞌo, hofɨko ijempoho tojwa sopo hoꞌnasyontɨfeso aꞌamu ango homo somo nosyukuji pomponaho hiso uhwonantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sekwoe tɨmoso sekwoe huyoꞌmangofe pomponaho paꞌnyofoho. Tɨmo angaꞌnohinoꞌmanji sekwo pomponahopo humalofo. Tɨmo piꞌnɨngoꞌmanji sɨkwoꞌmjohoꞌmo humalofo. ");
INSERT INTO apz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Oseso sekwo huno itoꞌno fɨsyafɨhupmno. Sekwo pomponahopo humalofo soku yahino piꞌnɨngo piꞌnɨngo mafɨkuji apaꞌno sɨkwoꞌmjohoꞌmo fosyohumafɨkutoho. ");
INSERT INTO apz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sekwoe sɨmeho moꞌmo sɨkwoꞌmjoho ane hwasɨꞌmanji pomponahoꞌnohinopoꞌmanji sekwoe sɨmoꞌmangoso nomꞌne aꞌamu somo pomponaho hopaso ulohoꞌmontonoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas kako oso hungkuno ulɨkwato lohofahonɨngki aꞌamu Falisi fihwo kako kakoꞌnji wopayo wonaho lonto Jisasɨmo joho lutɨmaꞌmentisofoho. Oseso Jisas kako oso hwe huhwo sohwoe angomo noswonto wosopayo nɨwoꞌnɨngkohofo sopo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Oso aꞌamu Falisi huhwo sohwo kako Jisas aho mijo miyatɨkuꞌnyoꞌnjo yonto wosopayo nyoꞌne humahonɨngki uhwononto yomo yonto huno piꞌnɨngo engo syafɨhuꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jisas oso hwe huhwo sohwoe hunomo huno uyahonɨngki ole ulɨmento, Sekwo aꞌamu Falisi sohwasi sekwoe noswanyo yoꞌmayo somo ko yajɨjwontɨfeso sekwoe humayoso kihoꞌnjo hwasoho. Yoꞌmayo uhwonontɨfeso hi semoꞌnɨwoꞌnɨngkohoho. Osoꞌnji sɨmeho moꞌmo yoꞌmayo honɨngkano wonyo nomꞌne woꞌnnyo hwasoho. ");
INSERT INTO apz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sekwo huno ane hwasoho. Sekwo mijo yatɨkuꞌnyoꞌneꞌnohini syofɨsyalokwofo. Anɨtu kako sekwoe paho hohntaꞌnnohini mtɨꞌmokumentisoꞌmaho. Oꞌo, kako sekwoe sɨmeho moꞌmo sekwoe huno soꞌnji mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sekwo sekwoe yoꞌmayo soꞌno aho yokumpohnꞌnyo kesyohumafɨkutoho. Oꞌo, sekwo aꞌamu umofonyo iwoꞌnɨngkohofo somo yoꞌmayoso uyɨkujoꞌno sekwoe sɨmeho moꞌmo kiho ane umoꞌnɨmontonoho. Ose ifijoꞌmanji aꞌamu uhwonɨfijoso hofɨko sekwoe sɨmeho moꞌmo kiho ane soꞌno huno uyɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Sekwo aꞌamu Falisi sohwasi sekwo tohino tɨpemapitnne soꞌno ngko hitoho ntokwoho. Sekwo hamniyoho wosopayo yoꞌmayo mawoꞌnɨngkohofoso sekwo hotitofontɨfi aho hufaꞌu hopiꞌnono imoꞌnɨngkahonɨngki angaꞌno Anɨtumneꞌno ko hoꞌnosyantɨfeso sekwo honɨngkano itoꞌnohino somneꞌno huno mosyafɨsiyoꞌnjo yontɨfeso Anɨtumneꞌno masemoꞌnyoꞌnjo hwasoho. U, sekwo sekwoe yoꞌmayo wopɨngo fehohnjoso Anɨtumneꞌno hoꞌnasyɨwoꞌnɨngkohofoso wopɨngofoho. I osoꞌno oso hungkuno selohe somo minɨngkayoꞌmanji yahinoso wopɨngoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Sekwo aꞌamu Falisi sohwasi sekwo Anɨtuye tohino engo somneꞌno iꞌwaho itoꞌno fiyɨmno. Sekwo huno ole seinyo hwasoho. Aꞌamu tajo angomo humawoꞌnɨngkohofo sofe sɨmanopo hwe engo sohwoe epohumayo wopɨngo sopo wohumentanoho semoꞌnnyo hwasoho. Sekwo hwe moyaꞌmi uhuꞌmokiyo sopo nje hwe engofo selontɨfeꞌno yɨwoꞌnɨngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Sekwo Anɨtuye tohino engo somneꞌno iꞌwaho itoꞌno fiyɨmno. Sekwo olo paꞌnyo hwasoho. Aꞌmopijohinomoꞌmo hoꞌnasyɨwoꞌnɨngkohofo sopo iyo mowontɨmofasiyo sopaꞌnyo hwasoho. Tojwa lopo wopɨngo sopo aꞌamu hano emoyontɨfi hwaho ajwomoꞌmo pisakinoꞌnjo wojo soꞌno huno muyofoho. Sekwo oso paꞌnyo hwasoho. ");
INSERT INTO apz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jisas ose ulahonɨngki hwe fihwo kako honɨngkano hungkuno lutɨhwayo syohoꞌnjo sohwo Jisasɨmo ulɨmento, Nakwoe Lonetɨhwayo sohwosi, oso hungkuno tangoꞌnjo Falisi sohwamo ulohinoso nakwo huhwo naꞌnnonjimo nelalokuno. ");
INSERT INTO apz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ose ulahonɨngki Jisas ulɨmento, Sekwo aꞌamu honɨngkano hungkuno lutɨhwawoꞌnɨngkohofo huhwo sohwasi sekwo huhwasi Anɨtuye tohino engo somneꞌno iꞌwaho itoꞌno fiyɨmno. Aꞌamu sekwoe honɨngkano hungkunomo itoꞌno inɨngkayoꞌne syoho mɨkunɨmposo uyɨwoꞌnɨngkohofɨhwasoho. Sekwo aꞌamufe hohujopo tango mɨkunɨmposo kisasyohonɨngkofi hofɨko mokohoꞌnyoꞌne syoho yokumpohnꞌnyo yɨwoꞌnɨngkohofofoho. I osoꞌno sekwo hofɨkimo ufoꞌmayoꞌne sekwoe ajoꞌmiyopo tango mokihnꞌnasewoso hwasoho. ");
INSERT INTO apz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Sekwo Anɨtuye tohino engo somneꞌno iꞌwaho itoꞌno fiyɨmno. Seyakwosa hohonta humamotofo sohwa hofɨko aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo sohwamo fonjahumentohofofoho. Aꞌamumo fonjahumentohofo huhwo sohwafe pijohino sopo sekwo wokosuyo yoꞌmayoso hulɨmotofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sekwo ose iwoꞌnɨngkohofo soꞌno ole itɨhwalokwofo. Neyakwosa hofɨko aꞌamu huhwo sohwamo fonjahumentohofo yahinoso wopɨngofoho. Ose lontɨfi sekwo wokosuyo hulɨmotofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Anɨtu kako huno hwapɨngoꞌnjo sohwo sekumneꞌno ole selalofi, Ngko aꞌamu fihwamo nje hungkuno uyahonɨngko lɨjwaofo syohoꞌnjo (apousel) sohwanji sekuyepono lɨhwatɨmeso sekwo aꞌamu fihwamo fonjasyɨkuji nomꞌni hwamo wonyo ulohofantɨfeho. Ose selalofoho. ");
INSERT INTO apz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Oseso aꞌamu fihwamo Anɨtu kakoe hungkuno uyahonɨngki hungkuno hiso lɨjwaofoꞌne syohoꞌnjo sohwamo fonjahumentohofoso Anɨtu nakwoe hwaho mtɨꞌmokumentiso sɨmoꞌmtaꞌango soꞌntnneꞌno olohonta fonjahumomopmmalofo soꞌntnne tohinoso olohontajo hwe moyaꞌmi humalofo soku womantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kein kako Apelɨmo fonjahumentiso somtaꞌni aꞌamu hofɨko Sekolaiya sohumo Anɨtumneꞌno yoꞌmayo hoꞌnasyɨwoꞌnɨngkohofo sopo oso ango Anɨtu humaho lɨmotofo ajwo sopo fonjahumentohofo osoꞌntnne tohinoso aꞌamu olohontajo humalofo soku womantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Sekwo honɨngkano hungkuno lutɨhwawoꞌnɨngkohofo sohwasi sekwo Anɨtuye tohino engo somneꞌno iꞌwaho itoꞌno fiyɨmno. Sekwo Anɨtuye hungkuno neꞌnjo somo minɨngkayoꞌnjo yontɨfi hiyasoꞌmo hoꞌnahumentohofo soꞌno aꞌamu nomꞌneso hungkuno homo somo unɨngkowano ko lahonɨngkofi sekwo hofɨkoe honɨngkanomo pɨjumokosyohumawoꞌnɨngkohofɨhwasoho. ");
INSERT INTO apz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jisas ose ulonto oso homo somo ulɨkoꞌmahonɨngki oso aꞌamu honɨngkano hungkuno lutɨhwayo syohoꞌnjo sohwanji aꞌamu Falisi sohwanji hofɨko sɨmano lɨkumpentɨfi oso sɨkuno homo somtaꞌni impoꞌangomo womuhwojano lontɨfi hungkuno mtitofahumentohofofoho. Oso hisoꞌno nakwo Jisasɨye hunomo yamofo uyano lontɨfi hwasyo hungkuno wonalono lontɨfi hofɨko yoꞌmayo soꞌno Jisasɨmo ulohonɨwoꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hwe moyaꞌmi nɨhuꞌno piꞌnɨngo engo uhuꞌmokumentohofoso hofɨko itoꞌno humamentohofoꞌmaho. Oꞌo, hofɨko nomꞌne aꞌamu sofe sɨfemo hwotoho wosolongkufinantɨfi imentohofofoho. Oso hohosohonta Jisas kakoe inomokomoyo sohwamo ikinjamo lohofonto hofɨkimo sɨmoꞌmo ole ulɨmento, Sekwo aꞌamu Falisi sohwafe yahino somneꞌno iꞌwaho itoꞌno fiyɨmno. Yahino hiso olenoho. Hofɨko hofɨkoe yahino wonyo utɨhwaꞌnyopo mꞌmofape soꞌno hwasyo hungkuno selɨwoꞌnɨngkohofɨhwafoho. Oso yahino soꞌno selalokweno. ");
INSERT INTO apz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yoꞌmayo hiyasoꞌmo wojoso hwangku utɨhwaꞌnyopo uꞌmofapmmontonoho. Yoꞌmayo sekwo hiyaso mokosyohumawoꞌnɨngkohofo hungkuno hiyasoꞌmo lontɨfeso yahino wonyo hiyasoꞌmo yontɨfi tɨfi noꞌmo utɨhwaꞌnyopo iꞌmofapɨhwosoꞌno aꞌamu tɨmo uhwonantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Oseso yoꞌmayo hungkuno sekwo sɨkwoꞌmjohoꞌmo lontɨfeso hwangku mofehiꞌnyoꞌnji wohoꞌnɨmontonoho. Yoꞌmayo hungkuno sekwo hiyasoꞌmo hofiyoka lontɨfeso hwangku utɨhwaꞌnyopo mango engoꞌnji wamjɨlɨmɨwantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ose ulonto ole ulɨmento, U, nje aꞌamu soku, sekwo upaꞌnɨmno. Sekwo aꞌamu poyo semokiyo somneꞌno sekwo iyoho senɨngkuhwaloho. Oꞌo, hofɨko sekwoe aꞌapaho poyo semokukuji osopo pipi selohopitnnehofo. Oꞌo, awonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","I olo humneꞌno sekwo iyoho senyoꞌneꞌno waselɨmonneꞌno yohono. Anɨtu kako sekwoe aꞌapaho poyo semokuhwosi sekwoe huyoꞌmangoso nɨhuꞌnahone tɨkanomo uhwajiyoꞌne yokumpohnꞌnyo hiꞌnjo hweho. Osohumneꞌnohini iyoho wasenono. ");
INSERT INTO apz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Sekwo huno seyohoho. Yɨhufo nɨhuꞌno weꞌe popijamo paꞌnyoso aꞌamu yɨhufo hiso aho fehohnjo hopiꞌnonohino somo touya hufaꞌu somneꞌno mpe yɨwoꞌnɨngkohofofoho. I osoꞌno oso yɨhufo nɨhuꞌno weꞌe somneꞌno Anɨtu kako inɨngo mamofɨwoꞌnɨngkiyohoho. ");
INSERT INTO apz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Anɨtu kako yoꞌmayo hopiꞌnonohinoso hunoꞌnjo hweho. Kako jɨje mnokinomjo mijiyo kengaꞌno kengaꞌnohinoso Anɨtu kako atofo nto lɨmentisofoho. Oseso sekwo aꞌamu poyo semokiyo sohwamneꞌno iyoho senɨngkuhwaloho. Oꞌo, oso yɨhufo nɨhuꞌno weꞌe Anɨtu inɨngo mamofeꞌnjo hofiyo mokosyohumawoꞌnɨngkiso somo sekwo yakoloꞌnnyo kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Olo soꞌno waselɨmonneꞌno yohono. Aꞌamu fihwo kako aꞌamufe tɨmopo ngkineꞌno hungkuno lɨjwaofoso sohwo oso humneꞌno ngko Aꞌamufe Hwomu sohwoꞌni aꞌamu ahwomomjo sofe tɨmopo hungkuno wolɨjwaoꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","I osoꞌno aꞌamu fihwo kako aꞌamufe tɨmo sopo ngkineꞌno hohujo ikinjanɨmofoso sohwo oso humneꞌno ngko huhwoꞌni aꞌamu ahwomomjo sofe tɨmopo hohujo ikinjɨmoꞌmnefoho. ");
INSERT INTO apz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","I aꞌamu fihwo ngkineꞌno sitofo ntososo kako oso wonyo hisoꞌno Anɨtumo wae yaofoꞌne jomo ulososo Anɨtu kako wae weeoꞌmontonoho. I osoꞌno aꞌamu Anɨtuye Towahuno Wopɨngo sohumneꞌno sitofo ulososo oso wonyo hiso Anɨtu kako wae meeofonehoho. Oꞌo, wonyo hiso neꞌno wawoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Aꞌamu hofɨko tajo ango weꞌe soꞌmo aꞌamu hwaho mokosyohumayo sohwanji aꞌamu yofe engoꞌnjo sofe tɨmopo ipesemotasokujoꞌno sekwo iyoho senɨngkuhwaloho. Huno ole syafɨsyɨkutoho. Hofɨko hungkuno nalohonɨngkujoꞌno nakwo peho hungkuno ulantanto. Ose syafɨsyɨkutoho. ");
INSERT INTO apz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Oꞌo, olo hoholohonta Anɨtuye Towahuno Wopɨngo kako yoꞌmayo hungkuno sekwo ujoꞌne soꞌno waselɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hwe moyaꞌmi piꞌnɨngo engo nohumentanɨngkofi hwe angaꞌnohino sohwo Jisasɨmo ole ulɨmento, Nje Lontɨhwayo sohwosi, nje mpohwo poyo peꞌnɨngkahonɨngki nje tatohwo kako hoꞌyango hopiꞌnonohinoso maꞌmentisofoho. Oseso olo hilo soꞌno kɨko nje tatohumo uso. Hoꞌyango hiso yano ilofɨhwosi fehohnjo ngkimo wontapono. Ose lonɨhwajohoho uso. ");
INSERT INTO apz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ose ulahonɨngki Jisas ulɨmento, I pipilo. Senɨngkwohwoe hoꞌyango yoꞌmayoso yano ilofoꞌne syohoso tɨhwo ntapmmentisoto. Awonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ose ulonto aꞌamu hopiꞌnonohino somo ole ulɨmento, Sekwo huno itoꞌno fɨsyafɨhupmno. Nomꞌne aꞌamufe yoꞌmayo somneꞌno hi semoꞌnyo soꞌno yahino soꞌno iꞌwaho fiyɨmno. Aꞌamu hoꞌyango piꞌnɨngo engo yokumpohnꞌnyo mokosyohumayo sohwo kako oso hoꞌyango somtaꞌni sɨmeho wopɨngo neso motɨpuhwonyo hweho. ");
INSERT INTO apz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ose ulonto kako pahnnɨmo hungkuno ole ulɨmento, Hwe hamniyoho engoꞌnjo fihwo kakoe wopasyoho somtaꞌni yoꞌmayo piꞌnɨngo engo maꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ose uhwononto oso hwe hamniyoho engoꞌnjo sohwo hnnɨmento, Ngko pipi imnehono. Yoꞌmayo wosopayo hoꞌnasiyoꞌne angoso hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ose syafɨsyonto ole lɨmento, U, ole uyɨmonnoho. Nje wosopayo hoꞌnasiyoꞌne ango weꞌeso wae yahmꞌmo nomꞌne engo mɨkunɨmposo wamolɨmo. Ose molɨꞌmo ngko wopayo yoꞌmayoso oso ango songomo wohoꞌnahumonnoho. ");
INSERT INTO apz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ose iꞌmeꞌno ngko nje huyoꞌmangomneꞌno ole wahnnɨmo, Jɨje yoꞌmayo wopɨngoso piꞌnɨngo weho. Soswo piꞌnɨngo engoso kiyakolofɨhwosoꞌno hoꞌyango yoꞌmayoso neꞌnohino wakuwentɨꞌmtefoho. Oseso syoho engo yohotoho. Oꞌo, iyoho humahoji yoꞌmayo mijo wosopayo nɨngkohoji sɨmeho wopɨngoꞌnjo fosyohumaho. ");
INSERT INTO apz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ose ko hnnɨngkahonɨngki Anɨtu hwe huhwo sohumo ulɨmento, Kɨko huno ane hwosoho. Olo sɨkwoꞌmiyo lomo kɨko poyo wapeꞌnɨmonnoho. Jɨje hoꞌyango engo itoꞌno esyohumahnnoso tɨhwo womaꞌmteto. ");
INSERT INTO apz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Oso pahnnɨmo hungkunoso ulonto ole ulɨmento, Oso paꞌnyoso aꞌamu hoꞌyango yoꞌmayoso piꞌnɨngo engo elofisosyalofonjo sohwo kako Anɨtuye tɨmopo ne soꞌno umofonyo yone hweho. Osoꞌno sekwo huno itoꞌno fɨsyafɨhupmno. ");
INSERT INTO apz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ose ulonto Jisas kakoe inomokomoyo sohwamo ole ulɨmento, Osoꞌno ole selalokweno. Sekwo sekwoe fosyohumayo soꞌno huno piꞌnɨngo engo syafɨsyɨkuji ole nolɨkutoho. Nakwo peho wosopayo wonantanto. Sekwo sekwoe aꞌapahomneꞌno huno piꞌnɨngo engo syafɨsyɨkuji ole nolɨkutoho. Ngko nje aꞌapahomo peho wekojisyahinɨmonnto. Ose syafɨsyɨkutoho. ");
INSERT INTO apz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hwapɨngoso nakwo pehoꞌne humolawotohwono. Wosopayoꞌnetaho. Hwapɨfeꞌnetaho. Oꞌo, osoꞌneꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sekwo yɨhufoꞌne fɨsyafɨhupmno. Hofɨko wopuyo hulɨwoꞌnɨngkohofoꞌmaho. Hofɨko wopayo mehuꞌmeesyɨwoꞌnɨngkohofoꞌmaho. Hofɨko wopayo angoso yoꞌmayo hoꞌnasiyoꞌne ango hiꞌnjoꞌmaho. I osoꞌno Anɨtu kako hofɨkimo wosopayo yoꞌmayoso uyɨwoꞌnɨngkohoho. Sekwo hwe moyaꞌmi soku Anɨtu kako sekumo sehononteso sekwo yɨhufo somo yakoloꞌnnyo kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hwe fihwo sekumtaꞌni kako huno piꞌnɨngo piꞌnɨngo syafɨsyɨhwosi nje soswo sawemo umokinɨmneꞌno yohono lososo ne umoꞌnɨmontolo. Awonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","I sekwo oso weꞌe hiso ifitnneso hopoenohini mmoꞌnyohwasɨꞌmanji sekwo nomꞌne yoꞌmayo piꞌnɨngo engo somneꞌno huno piꞌnɨngo piꞌnɨngo pehoꞌne syofɨsyalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sekwo wokoso fofo soꞌno huno fɨsyafɨhupmno. Hofɨko yoꞌmayo syoho anefoho. Hofɨko he yoꞌmayoso mojiyofɨwoꞌnɨngkiyohofo. I osoꞌno ole waselɨmonneꞌno yohono. Hohonta hwe engo Soulomoun hamniyoho hwapɨngoꞌnjo sohwo kako kakoe hwapɨfe wonyoangkafo yoꞌmayo wokoso naꞌnohino soꞌnji inonteso kako olo wokoso fofo weꞌe somo muyakolofonehoho. ");
INSERT INTO apz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ou oso wokoso fofo sɨkuno fihumo syohopo lohofososo moꞌnɨngkanta aꞌamu nolofekuji tohomo wolofefantɨfeho. I osoꞌno oso wokoso fofo Anɨtu wonyoangkafo mtɨꞌmokuwoꞌnɨngkiso somo uhwonontaneso wopɨngofoho lɨwoꞌnɨngkuhwono. Oseso sekwo soku wokoso fofomo yakoloꞌnnyo hokumo Anɨtu kako hofiyo wosemokosyohumamontonoho. Sekwo Anɨtumo sɨmeho hiꞌntnnono weꞌeꞌnohinoso pehoꞌno uyalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Oseso sekwo wopayo yoꞌmayo mijo soꞌno peho wonantaneꞌnunto Ose syafɨsyɨkutoho. Huno piꞌnɨngo piꞌnɨngo seyoꞌeno. ");
INSERT INTO apz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Aꞌamu olo hwaho lopo Anɨtumo minɨngkayoꞌnjo hofɨko yoꞌmayo yoꞌmayo mayoꞌne huno piꞌnɨngo piꞌnɨngo syafɨsyɨwoꞌnɨngkohofo. I osoꞌno senɨngkwohwo Anɨtu sohwo kako yoꞌmayo soꞌno sekwo umofonyo yahonɨngkohofoso kako huno nto uyohoho. Kako wopɨngo wosemokosyohumamontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Oseso sɨmoꞌmo sekwo Anɨtumo enjwaꞌmo humayoꞌne hi semoꞌnɨngkuhwosoꞌno Anɨtu kako yoꞌmayo yoꞌmayo umofonyo ifijoso wosejapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nje yahu mehomi soku sekwo yoꞌmayo soꞌno iyoho senɨngkuhwoloho. Anɨtu kako kakimo enjwaꞌmo humayoꞌne mesehumajiyoꞌneso hungkuno nto mtitoꞌmentisofoho. Anɨtu kako sekumo semokosyohumayo soꞌno sɨmeho wopɨngo umoꞌnalofoho. ");
INSERT INTO apz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sekwoe hoꞌyango yoꞌmayoso aꞌamu mpe waselohopɨfe. Sekwo oso hamniyoho hiso aꞌamu umofonyo iyo somo uyɨmno. Ose ifijo soꞌno sekwoe hoꞌyango neso ahwomomo weho. Ahwomomjo hoꞌyango wonyo mmoꞌnonehoho. Osoꞌno sekwo sekwoe hoꞌyango engo ahwomomo fohuꞌmeehumno. Oso hopo soponjo hoꞌyangoso mpoꞌnaofeꞌnefoho. Aꞌamu hoꞌyango hufo iyoso aneponoho. Namo, mote, yoꞌmayoso hoꞌyangomo wonyo mmokonehoho. ");
INSERT INTO apz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ango jɨje hoꞌyango yoꞌmayo wopɨngo wojo sopo jɨje sɨmeho hi oso hopo weho. ");
INSERT INTO apz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Sekwo sekwoe he itoꞌno yofɨkuji sikiloho mongkujɨkuji itoꞌno fesyohumamno. ");
INSERT INTO apz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ose ifijoꞌmanji sekwo olo paꞌnyo wohontohumantɨfeho. Aꞌamufe hwe engo sohwo kako ape mayoꞌne wopayo iloho engo somtaꞌni asomo poso sohonta kako hokuꞌyopo hwanɨngo fonjɨhwosoꞌno syoho ulohofiyo sohwa hano komoꞌno wohwosampɨtɨmantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Oso syoho ulohofiyo huhwo sohwa hofɨko saho mofosyawoso uyantɨfeho. Oꞌo, hofɨko hofɨkoe hwe engo sohumneꞌno yoꞌmayo itoꞌno esyohumentanɨngkuji hwe engo sohwo poso sohonta hofɨko sɨmonyo engo uyantɨfeho. Hungkuno nehopi waselɨmonneꞌno yohono. Oso hwe engo huhwo sohwo kako uhwonososo yoꞌmayo itoꞌno esyohumayo somo uhwonɨngkuhwosi kako huhwo kakoe syoho ulohofiyo sohwamo wopayo nɨwoꞌnɨngkohofo epohumayo sopo uhumajɨhwosi kako wopayo uyɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","I kako sɨkwoꞌmiyo kuntoliyopo posoꞌmanji u kako yɨhufo yoka sɨmoꞌmjo hoꞌnɨwoꞌnɨngkiso soꞌnji posoꞌmanji kako kakoe syoho ulohofiyo sohwamo uhwonososo hofɨko saho mofosyowentanɨngkuji uhwonɨngkuhwosoꞌno hofɨko sɨmonyo uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Hwe engo sohwo kako asomo pe-eꞌne mofehiꞌnyo sɨmoꞌme soꞌno huno itoꞌno seyosoꞌmanji sekwo hopiꞌnonohino soku itoꞌno wesyohumantɨfeho. U, oso hopaso hwe ango mokosyohumayo sohwo kako nomꞌne aꞌamu kakoe ango hopo sopo ntaꞌni yoꞌmayo hufo womaꞌmo lontesoꞌno sɨkuno huno uyontentesi kakwoꞌyohwo oso sɨkuno somneꞌno hontohumentanɨngkuhwosi aꞌamu hufo imojo sohwo kako yoꞌmayoso momahwonesohilo. ");
INSERT INTO apz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Oseso sekwo soku sɨkuno engolopohamo itoꞌno fesyohumantokuno. Ngko Aꞌamufe Hwomu sohwoꞌni sɨkuno sekwo huno mosyofɨsyomokosyohumentanɨngkuji asomo wapmmonnoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita ose upaꞌnonto Jisasɨmo ulɨmento, Hwe engofo, oso pahnnɨmo hungkuno nalohinoso nakumnohini lonalohino. Hwe moyaꞌmi hopiꞌnonohinoꞌnyumo lonalohino. ");
INSERT INTO apz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","43","Ose ulohonɨngkahonɨngki Jisas kako nomꞌne pahnnɨmo hungkuno ole ulɨmento, Hungkuno selalokwe loso olo humnefoho. Aꞌamu fihwo huno wopɨngoꞌnjo sohwo kakoe hwe engo sohwo osohumo nomꞌne syoho ulohofiyo sohwamo umokosyohumayo syohoso uyahonɨngkuhwosi syoho hiso itoꞌno inyo sohumneꞌno selalokweno. Oso hwe engo huhwo sohwo kako asomo pɨhwosi uhwonososo kakoe syoho ulohofiyo sohwamo mokosyohumayo syohoꞌnjo sohwo wosopayo uyontanɨngkuhwosi uhwonɨngkuhwosoꞌno oso syoho ulohofiyo sohwo sɨmonyo uyɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ngko hungkuno nehopi waselɨmonneꞌno yohono. Oso hwe engo huhwo sohwo kako kakoe yoꞌmayo hopiꞌnonohinoso oso syoho ulohofiyo huhwo sohumo enjwaꞌmo wohoꞌnahumontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","I osoꞌno oso syoho ulohofiyo huhwo sohwo kako huno ole wosyafɨhuꞌmontonoho. Nje hwe engo sohwo kako asomo komoꞌno maponehoho. Ose syafɨsyɨhwosiꞌmanji kako nomꞌne syoho ulohofiyo hwe moyaꞌmi sofanjimo ikujoho fonjomasoso kako yoꞌmayo wosopayo tohoꞌnohini nɨngkuhwosi kako mijo yokumpohnꞌnyo nɨngkuhwosi wonilohofaoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Syoho ulohofiyo sohwo ose yosoꞌmanji kakoe hwe engo sohwo sɨkuno fihumo syoho ulohofiyo sohwo kako huno mosyofɨsiyoꞌnjo yoꞌmayo itoꞌno mesyohontohumentanɨngkuhwosi asomo wapmmontonoho. Oso hwe engo sohwo kako syoho ulohofiyo huhwo sohumo tohino engo uyɨhwosi aꞌamu kakoe hungkunomo haloho maposoꞌnjo sopo uhumatɨꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Syoho ulohofiyo sohwo kakoe hwe engo yoꞌmayo syoho yoneꞌento ulisoso kako huno ko uyahonɨngkuhwosi hungkuno homo somo minɨngkayoꞌnjo yoꞌmayoso itoꞌno mesyohumayoꞌnjo oso hwe huhwo sohwo tohino engo womaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Syoho ulohofiyo nomꞌnehwo kakwoꞌyohwo sohwoe huno somo huno muyoꞌnjo soꞌno kako yahino wonyo ko ihwosi kakuneꞌno huno mosyafɨsiyoꞌnjo yososo kakwoꞌyohwo sohwo tohino weꞌeꞌnohini uyonefoho. Anɨtuye syoho ulohofiyo fisomo yoꞌmayo wopɨngo piꞌnɨngo engo uꞌmante soꞌno kako Anɨtumneꞌno syoho piꞌnɨngo engo uyono. Aꞌamu yoꞌmayo yoꞌmayo piꞌnɨngo engo mokosyohumunyo sohwo Anɨtu kako osohumo nomꞌne aꞌamumo ufoꞌmayoꞌne yoꞌmayo soꞌno jomo ulɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ngko olo hwaho lopo ahwomo mtaꞌango toho womotapmmo lonji pmꞌmentohe hwoꞌnyoho. Oso toho hiso olohonta sijontentesi wopɨngoꞌnesohilo. ");
INSERT INTO apz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Oso toho hiso mosijontanɨngkuhwoso sohonta ngko tohino engo womaꞌmonnoho. Oso tohino engo mayo hisoꞌno nje hi tango mjonɨmopɨhwosi oso tohino moiꞌwo umoꞌnosojwaoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ole losyonɨfɨsyantɨkwofo. Olo hwaho loponjo ikujoho yoꞌmayo yahinoso moiꞌwo esojwaofoꞌne pmmentiso hweho. Ngkineꞌno ose losyonɨfɨsyantɨkwofo. Oꞌo, sekwo upaꞌnɨmno. Ngko aꞌamu hotitofoꞌne pmmentohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Olohontajoꞌnji hwangku nomꞌneꞌntnneꞌno hofɨkoꞌmontohwa aꞌamu aho fehohnjo hopiꞌnonohinoso nohotitofahonɨngkuji aꞌamu hufaꞌuso siko aꞌamu hufaꞌu sɨhune sohwafe mangohwa umoꞌnanjiyoho. I aꞌamu hufaꞌu siko ngkimo nnɨngkapohosɨsoꞌno oso aꞌamu hufaꞌu sɨhune sohwa sikoe mangohwa umoꞌnantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","I kanɨngkwohwo kako ngkimo nnɨngkapɨhwosoꞌno kakoe hwomu ngkineꞌno ngkilaho walɨmontonoho. I mu fisi kako ngkimo nnɨngkapɨhwosoꞌno konaꞌwohi ngkilaho wantɨmontonoho. U, aꞌmu fisi kako ngkimo nnɨngkapɨhwosoꞌno kakoe hwomufe ape mangohwo umoꞌnɨmontonoho. Oso hopaso aꞌamu piꞌnɨngoso hofɨko wohotitofantɨfeho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Olo hungkuno hilo soꞌnji aꞌamu homo somo ulɨmento, Sekwo mofehiꞌnyo ikwoꞌmokuwoꞌnɨngkiso sohohntaꞌni himo uhwonɨngkuji ole wolantɨfeho. Ifoyo wahuꞌmontonoho. Ose lɨkuji ou, nehopi wahuꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","U, sekwo ifofo yokumpohnꞌnyo mongkihntaꞌni sopahonɨngkuhwosi uhwonɨngkuji ole wolantɨfeho. Mofehiꞌnyo yokumpohnꞌnyo walɨmontonoho. Ose lɨkuji ou, nehopi walɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sekwo yoꞌmayo hwahoponjo soꞌnji ahwomomjo soꞌnji uhwonantɨfi sekwo huno itoꞌno syafɨsyɨwoꞌnɨngkohofo kuyoho. I osoꞌno yoꞌmayo olohonta imoꞌnalokuso somo ko uhwonontɨfi sekwo sekwoe yahino wonyo somneꞌno tohino mayosoꞌno huno maseyoꞌnjo iꞌwaho itoꞌno miyalokuyohofo. Hwapɨngoso pehoꞌneto. Sekwo mangoꞌnohino kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sekwo huno wopɨngo syafɨsyɨkuji yahino itoꞌnohino somneꞌno yano milofahinyoso pehoꞌneto. ");
INSERT INTO apz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Hwe fihwo kako kikimo impoꞌangomo wolintofakohumo lɨhwosi ipekumotowahonɨngkuhwosi honɨngkanopo humahosɨsi osopo sikoꞌnohini hungkuno itoꞌno filinyo. Majoꞌmanji hwe engo hungkuno itoꞌno mɨhwajiyo syohoꞌnjo sohwo kako impoꞌangomo womekuhumatɨꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ose yosoꞌmanji kɨko impoꞌangoso kuntoꞌno ulɨkoꞌmaꞌmne hwosɨꞌmaho. Oꞌo, sɨmoꞌmo kɨko jɨje yahino somneꞌno yoꞌmayo hamniyohoso wohoꞌnahumonnoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Oso hohosohonta aꞌamu fehohnjo hofɨko nohumantɨfi Jisasɨmo ulɨmentohofi, Aꞌamu Ngkalilintaꞌango fehohnjoso hofɨko Anɨtuye tajo ango engo Jelusalem sopo nohumantɨfi hofɨko Anɨtumneꞌno yahu fonjokisyosyontanɨngkofi hwe yofe engoꞌnjo hwaho mokosyohumayo sohwo kako kakoe aꞌamu itokusoꞌnjo sohwamo lɨhwojahonɨngki hofɨko aꞌamu Ngkalilintaꞌango somo fonjahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ose ulahonɨngkofi Jisas ulɨmento, Ose ntohofo soꞌno sekwo huno ole losyofɨsyalokwofo. Oso aꞌamu Ngkalilinjo hiso hofɨkoe honɨngkano wonyoso nomꞌne aꞌamu Ngkalilintaꞌango somo yakoloꞌnnyo soꞌno oso tango mɨkunɨmposo tɨpemaꞌmentohofofoho. Ose losyofɨsyalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Oꞌo, sekwo ose syafɨsyɨkutoho. Ngko hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Sekwo hopiꞌnono sekwoe yahino wonyo somneꞌno hohujo mikinjaopijoꞌmanji sekwo hopiꞌnono oso tango hopaso notɨpemapitnne kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","I oso ango Silouam sopo aꞌamu aho hufaꞌu sɨfe fehohnjoho hopiꞌnono nomꞌne sɨfe mtaꞌni hufaꞌu sɨhune nohumentanɨngkofi ango yokintahoponjo sawemo engo sohwo pɨwasyonto aꞌamu homo somo kilopoꞌmentisofoho. Oso hwe moyaꞌmi hofo sofe yahino wonyoso Jelusalemmjo aꞌamu somo yakoloꞌnnyo soꞌno huno losyofɨsyalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Oꞌo, osoꞌneꞌmaho. Hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Sekwo hopiꞌnono sekwoe yahino wonyo somneꞌno hohujo ikinjaofɨkuji Anɨtumne sɨmeho mɨwoloꞌmo kiyoꞌmanji sekwo hopiꞌnono oso tango hiso paꞌnyoso notɨpemapitnne kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jisas kako pahnnɨmo hungkuno ole ulɨmento, Hwe fihwo kakoe impojohopo iyo ikwongo hulɨmentiso soꞌno kako ikwonjayo ne intoꞌnyo soꞌno wonyopi uhwonomahoso imojofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Oseso kako syoho mokosyohumayo sohumo ulɨmento, Kɨko upaꞌnyo. Soswo hufaꞌu sɨhune ngko oso ikwonjayo hiso womjɨmonji potnneso huno uhwonapɨwoꞌnɨngkohefoho. Oseso oso iyo huhwo sohwo olohonta kɨko mɨngo filofeeofo. Kako hwahomjo afofo siki mayoso wopɨngoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ose ulahonɨngki syoho mokosyohumayo sohwo ulɨmento, Hwe engofo, olo iyo huhwo lohwo sohwo olo soswo lohumo walohofono. Hwangku ngko kakoe pmpongomo mno ijɨꞌmo yahwoyoho koꞌmeehmꞌmeꞌno ne itoꞌno untoꞌnɨmontolɨkeno. ");
INSERT INTO apz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nomꞌne soswomo ne mintoꞌnɨngkuhwosi wopɨngofoho. Awoꞌmanji ngko wolofeeoꞌmonnoho. Jisas kako oso pahnnɨmo hungkunoso ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sɨkuno iyoho humayo fisomo Jisas kako tajo ango weꞌe somo hwe moyaꞌmimo Anɨtuye hungkuno lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Oso tajo ango homo somo aꞌmu fisi towahuno wonyo ehuhnnamoꞌnnyosi kako mnokinoꞌnji neꞌno nohumentanɨngki soswo aho hufaꞌu sɨfe fehohnjo hopiꞌnono nomꞌne sɨfe mtaꞌni hufaꞌu sɨhune uyakoloꞌmentiso soꞌno kakoe hohujoso fahuloꞌmojiyoho. Oseso kako itoꞌno lɨkofohumayoso miyommojofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas kako aꞌmu hisimo uhwononto joho lutɨmanto ulɨmento, Aꞌmu losiyo ngko jɨje mnokino engo kiwoꞌnɨngkiso somtaꞌni nto isɨhutofokumahono. ");
INSERT INTO apz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ose ulonto Jisas kako aꞌmu hisimo aho kisuhumentisoso aꞌmu hisiye hohujo fahuloꞌnnyoso nɨhuꞌno komoꞌno itoꞌno mulohokumentisofoho. Jisas kako aꞌmu simo wopɨngo ose umokahonɨngki aꞌmu hisi kako Anɨtuye yofe hoꞌnomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Oso sɨkuno iyoho humayo homo somo Jisas kako aꞌmu simo wopɨngo imokumentiso soꞌno hwe engo oso tajo ango weꞌe somo mokosyohumayo sohwo kako sɨmeho tohino umnɨngkahonɨngki aꞌamu piꞌnɨngo engo somo ulɨmento, Sɨkuno aho fehohnjo hopiꞌnono aho nomꞌne mtaꞌni angaꞌnohino somo yoꞌmayo syoho iyoꞌne sɨkunofoho. Sekwo soku aꞌamu sohwo wopɨngo wonamokɨfe lɨkujɨꞌmanji sekwo soku sɨkuno syoho iyo somo hmꞌmofapmno. Sekwoe aꞌapaho wopɨngo semokiyoꞌne sɨkuno iyoho humayo losomo nopɨkutoho. ");
INSERT INTO apz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ose ulahonɨngki Jisas ulɨmento, Sekwo mangoꞌnohino lɨwoꞌnɨngkohofo kuyoho. Sɨkuno iyoho humayo homo somo sekwo sekwoe yahu somo hofɨkoe ango somtaꞌni mawentɨfi mijomneꞌno ipemotapɨwoꞌnɨngkohofo kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Oseso ngko olo Apɨlohamɨye imu simo Setenɨye towahunoso kakimo neꞌno ehuhnnaofontanɨngki soswo aho hufaꞌu sɨfe fehohnjo hopiꞌnono nomꞌne sɨfe mtaꞌni hufaꞌu sɨhune uyakoloꞌnnyo simo olo sɨkuno iyoho humayo lomo wopɨngo umokoheso wonyotaho. ");
INSERT INTO apz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisas ose ulahonɨngki Jisasɨye mango sohwa upaꞌnontɨfi wonɨmango engo unɨmentisofoho. I hwe moyaꞌmi piꞌnɨngoso hofɨko yoꞌmayo yoꞌmayo wonyoangkafo Jisas imentiso soꞌno sɨmonyo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisas kako pahnnɨmo hungkuno nomꞌne ulɨmento, Anɨtumo enjwaꞌmo humayo yahinoso peho paꞌnyoto. Ngko yamofoso pehomneꞌno esetɨhwamnehono. ");
INSERT INTO apz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Olenoho. Iyo fihwo kakoe yofe masɨtet. Kakoe neso nomꞌne iyo ipisayo paꞌnyoꞌmaho. Oꞌo, nɨhuꞌno weꞌefoho. Hwe fihwo oso weꞌe hiso kakoe syohopo hulahonɨngki engo imoꞌnonto nomꞌne iyo syoho soponjo somo yakolonoho. Engo imoꞌnɨngkahonɨngki yɨhufoso nopontɨfi kakoe pamo sopo hofɨkoe aifo syontɨfi osopo kehumawoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ose ulonto ole ulɨmento, Pahnnɨmo hungkuno nomꞌne Anɨtumo enjwaꞌmo humayo yahino soꞌno ngko yamofoso pehomo esetɨhwamnehono. ");
INSERT INTO apz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oso hiso olo paꞌnyofoho. Aꞌmu fisi kako wosopayo polowaꞌnji oso wosopayo polowa homo somo engo imokiyoꞌne hwamno paꞌnyo kakoe yofe yis, osoꞌnji iwoloꞌmokososo oso polowa hiso engo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas kako Jelusalemne wasɨmonto imentisoso honɨngkano momɨngo somo ango pone mjamolɨmohnnyo soponjo aꞌamu somo kakoe hungkuno lutɨhwamosimentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Oso hohosohonta hwe fihwo ulɨmento, Hwe Engofo, Aꞌamu Anɨtumo uꞌmayoꞌneso aꞌamu angaꞌno angaꞌno sifitnnetaho. Hopiꞌnono sɨfitnnetaho. ");
INSERT INTO apz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ose ulahonɨngkahonɨngki Jisas ulɨmento, Anɨtumo uꞌmayoꞌne hokuꞌyoso weꞌefoho. I sekwo oso hokuꞌyo weꞌe homo somo syuyoꞌne syoho yokino fiyohoꞌnɨmno. Hwapɨngo soꞌno yolohoso waselɨmonneꞌno yohono. Aꞌamu piꞌnɨngo engoso hofɨko oso hokuꞌyo homo somo woswano lifijoso hofɨko yamofo ko ifijoso hofɨko hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Hwangku oso ango homo somjo kakwoꞌyohwo sohwo nolɨkafɨhwosi hokuꞌyo weꞌe homo somo wopɨjwahumontonoho. Nɨhuꞌnahone nto pɨjwasyɨhwosoꞌno sekwo mempo hohntaꞌni lohofɨkuji hokuꞌyopo hwanɨngo fonjɨkuji joho ole ulɨfitnnefoho. Hwe Engofo, hokuꞌyo fonehwosampofo. Ose ulɨfijoso kako ole waselɨmontonoho. Sekwo ntɨꞌmtaꞌango kulo. Ngko sekumneꞌno huno maniyohoyohoho. ");
INSERT INTO apz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ose selɨhwosoꞌno sekwo ole ulɨfitnnefoho. Nakwo kɨkoꞌnji wopayoꞌnji mijoꞌnji nɨmentɨhwone lokono. Kɨko nakwoe honɨngkanopo lohofonji nakumo hungkuno lonetɨhwamentohino lokono. ");
INSERT INTO apz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ose ulahonɨngkuji kako apaꞌno ole waselɨmontonoho. Sekwo ntɨꞌmtaꞌango kulo. Ngko sekuneꞌno huno maniyohoyohoho. Sekwo honɨngkano wonyo yɨwoꞌnɨngkohofo kuyoho. Sekwo ngkimo iꞌwaho ntohopmno. Sekwo mpanɨmno. ");
INSERT INTO apz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ose selɨhwosi kako sekumo wae yasemofɨhwosoꞌno sekwo mempo hohntaꞌni humafɨkuji uhwonɨfijoso aꞌamu Anɨtumo enjwaꞌmo humalofoso Apɨloham, Aisak, Jekoup sohwanji aꞌamu Anɨtuye hungkuno lutɨhwamotofo sohwanjimo wosyɨhwonɨhwojowantɨfeho. Sekwo ose uhwonɨngkuji sekwo hulɨngkwajingo ifalohoꞌnɨngkuji humotaho engo lɨfitnne kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Hwe moyaꞌmi hofɨko mofehiꞌnyo sɨꞌmofapiso mtaꞌni sahopɨkuji mofehiꞌnyo nɨngkuꞌnɨwoꞌnɨngkiso mtaꞌni uꞌmofapɨkuji aꞌamu yaposiyo yohosi yohohntaꞌni iꞌmofapɨkuji hofɨko Anɨtumo enjwaꞌmo nohumafɨkuji Anɨtuye angomo wosopayo nɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Oso hohosohonta aꞌamu fehohnjo somneꞌno sitofo ulɨwoꞌnɨngkohofoso hofɨko yofe engo womantɨfeho. I aꞌamu fehohnjo hofɨkoe yofe olopo hoꞌnomawoꞌnɨngkohofoso hofɨko yofe engo ane paꞌnyo wohumantɨfeho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Oso hohosohonta aꞌamu Falisi fehohnjo sohwa hofɨko Jisasɨmo uꞌmantɨfi ulɨmentohofi, Kɨko olo ango lopo ulɨkoꞌmahoji nomꞌne angopono fɨwano. Hwe yofe engoꞌnjo Helout sohwo kako kikimo wofonjakohumonto yalofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo nukuji oso hwe wonyo sohwo, Helout, osohumo ngkineꞌno ole ulɨmno. Olohontajoꞌnji moꞌnɨngkajoꞌnji ngko aꞌamu towahuno wonyo ehuhnnamoꞌnnyo somo wae yaohmꞌmo aꞌamu mnokinoꞌnjo somo wopɨngo umokumonnoho. Noꞌno moꞌnɨngka sɨkuno hufaꞌu sɨhune sohonta ngko nje syohoso moiꞌwo wesojwaoꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Osoꞌno olohontajoꞌnji moꞌnɨngkajoꞌnji neꞌno moꞌnɨngkajoꞌnji nje syoho moiꞌwo iꞌmo ngko hano Jelusalemneꞌno wosyɨꞌmoꞌmonnoho. Hwapɨngoso aꞌamumo Anɨtu hungkuno uyahonɨngki lutɨhwayo sohwamo ango nomꞌnepo fonjasyɨwoꞌnɨngkohofopoꞌmaho. Oꞌo, ango Jelusalemnohini fonjasyɨwoꞌnɨngkohofoponoho. ");
INSERT INTO apz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","U, nje aꞌamu Jelusalem humamopmmotofo sokunonji olohonta humalofo sokunonji sekwo aꞌamumo Anɨtu hungkuno uyahonɨngki selɨmotofo sohwamo fonjasyontɨfi aꞌamu sekumo sefoꞌmayoꞌne Anɨtu uhwojɨwoꞌnɨngkiso sohwamo sojoꞌnji fonjɨwoꞌnɨngkohofo kuyoho. Sɨkuno piꞌnɨngo engo somo ngko sekumo ole hopa womasemokuꞌmonji imalefoho. Yɨhufoso hofɨkoe polonyo somo mɨhuꞌmokontɨfi efemokosyawowoꞌnɨngkohofo hopaso ngko sekumo wosemokosyohumamonji ko imaleso sekwo nakwolaho lɨmalofofoho. ");
INSERT INTO apz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sekwo upaꞌnɨmno. Sekwoe ango Jelusalem sopo Anɨtu kako nto ulɨkoꞌmaꞌmaho. Hungkuno nehopi waselɨmonneꞌno yohono. Sekwo ngkimo manohonyoꞌnjo neꞌno yontanɨngkuji sɨkuno piꞌnɨngo woseyakoloꞌmontonoho. Tɨfi noꞌmo sekwo nakwo oso aꞌamu Anɨtu uhwatɨmentiso sohumneꞌno yofe wohoꞌnomano lɨfijo sohonta sekwo ngkimo apaꞌno wonehonantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Sɨkuno iyoho humayo fihwi Jisas kako hwe fihwoe angomo wopayo nɨmentisofoho. Oso hwe huhwo sohwo kako aꞌamu Falisi sohwafe hwe engo hweho. Oso hopo sopo hwe fihwo kako aꞌapaho engo kamkamnnyo sohwo Jisasɨmo mofonepo humunyo hweho. Aꞌamu Falisi sohwa hofɨko Jisas sohwo kako hwe aꞌapaho wonyoꞌnjo sohumo pipi ulohofone kiyohoho lontɨfi humuhwontohumantohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisas kako oso hwe mnokinoꞌnjo sohumo uhwononto kako aꞌamu honɨngkano hungkuno lutɨhwawoꞌnɨngkohofo sohwanji aꞌamu Falisi sohwanjimo ulɨmento, Nakwoe honɨngkano hungkuno sɨkuno iyoho humayo somneꞌno nakwo aꞌamu mnokinoꞌnjo somo wopɨngo umokiyoso wopɨngotaho. ");
INSERT INTO apz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ose ulahonɨngki hofɨko mampiꞌnyo humamentohofofoho. Oseso Jisas kako oso hwe sohwoe ahomo nomanto wopɨngo umokonto, kakoe ango poneꞌno uhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ose ulohofonto kako aꞌamu nomꞌne sohwamo ulɨmento, Sekwo sɨkuno iyoho humayo somo syoho miwoꞌnɨngkiyohofɨhwasilaho. I sekwoe hwomutaho yahu mutaho sɨkuno iyoho humayo somo mijo kilofawoso somo usɨꞌmofawesoso sekwo komoꞌno ukuji utɨmantɨfitaho. Ou, utɨmantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ose ulahonɨngki hofɨko kakimo aku hungkuno mulɨmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas kako oso ango hopo sopo nohumanto uhwonɨmentisoso aꞌamu fehohnjoso oso ango homo somo swontɨfi hofɨko epohumayo wopɨngoꞌnohini soꞌno hafɨhafe tɨpeehonɨngkofi uhwononto kako aꞌamu huhwo sohwamneꞌno pahnnɨmo hungkuno ole ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Aꞌamu fihwo kako ape maꞌnyo soponjo wopayo engo soꞌneꞌne kikineꞌno joho kilososo kɨko nuhuji epohumayo wopɨngo sopo nohumayoꞌeno. Kɨko epohumayo wopɨngopo humusoꞌmanji ango kakwoꞌyohwo sohwo kako nomꞌne aꞌamu jɨje yofe engo somo kiyakoloꞌnnyo sohumo joho ulosoꞌmanji jɨje yofe engoso monje weekohumontonoho. ");
INSERT INTO apz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kɨko jɨje yofe weꞌeꞌnjo sohwosi kɨko epohumayo wopɨngopo kakiꞌno humentanɨngkiji kohonɨngkuhwosi oso ango kakwoꞌyohwo sohwo kako ole wakilɨmontonoho. Kɨko olo epohumayo wopɨngo loso olo aꞌamu lohumo uyo. Ose kilɨhwosoꞌno kɨko wonɨmango engo kinɨngkuhwosoꞌno momɨngo soꞌmjo epohumayo sopo wohumamontnnoho. ");
INSERT INTO apz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","I hwe fihwo kako kikimo kakoe angomo wosopayo nyoꞌne joho kilosoꞌmanji kɨko noswohoji epohumayo nɨhuꞌno momɨngo soponjo sopo fosyohumaho. Kɨko ose humusoꞌmanji oso aꞌamu huhwo sohwo kako kikimo nokohonɨngkuhwosi ole wakilɨmontonoho, Nje aꞌamuhwe, kɨko olopo fisohumape. Ose kilɨhwosoꞌno oso ango homo somjo aꞌamu wosopayo nontɨfijo aꞌamuso nokohonɨngkujoꞌno jɨje yofe engo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aꞌamu kakoe yofeꞌnohini hoꞌnomaꞌnɨwoꞌnontoso sohumo Anɨtu kako monje weehumontonoho. I aꞌamu kakoe yofe somo monje yahinɨngkuhwoso sohumo Anɨtu kako wopɨngo wonyoangkafo ulohofɨhwosi kakoe yofeso wohoꞌnɨmaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Oseso Jisas kakimo wopayo nyoꞌne joho lutɨmaꞌmentiso sohumo ulɨmento, Kɨko aꞌamumne wosopayo iloho iyo sohonta jɨje aꞌamu soꞌntnne, jɨje temtitofo soꞌntnne, jɨje angoponjo aꞌamu hamniyoho engoꞌnjo soꞌntnneꞌno joho lutɨmahotoho. Kɨko ose isoso nomꞌne sɨkunomo jɨje wosopayo somneꞌno hofɨkoe angomneꞌno joho kilɨkuji hofɨko aku wokijopantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Oꞌo, kɨko aꞌamumneꞌno wosopayo iloho yohojoso kɨko aꞌamu yoꞌmayo umofonyo inyo soꞌnji aꞌamu aꞌapaho wonyoꞌnjo soꞌnji sɨfe kokatoꞌnnyo soꞌnji aꞌamu tɨmpiꞌnyo soꞌnjimo joho lutɨmahoji uyo. ");
INSERT INTO apz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Oso aꞌamu homo somo hofɨko jɨje wosopayo somneꞌno aku kijapeso hopoenohinɨꞌmaho. Oseso kɨko sɨmonyo uyɨmonnoho. Hwapɨngoso aꞌamu Anɨtuye hungkunomo inɨngkawentɨfe peꞌnɨmentohofoso lɨkapijo sohonta Anɨtu kako kikimo jɨje yahino wopɨngo somneꞌno yoꞌmayo wopɨngoso nokijaponefoho. ");
INSERT INTO apz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Oso aꞌamu Jisasɨꞌnjopo wopayo nontanɨngkofi hwe fihwo nohumanto Jisasɨye hungkunomo upaꞌnonto ulɨmento, Aꞌamu Anɨtumo enjwaꞌmo humasoso kako Anɨtuꞌnji humayo soꞌno sɨmonyo uyono. ");
INSERT INTO apz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ose ulahonɨngki Jisas kako pahnnɨmo hungkuno ole ulɨmento, Hwe fihwo kako wosopayo engo iloho umonto imentisofoho. Oseso oso sɨkuno wopayo iloho iyoꞌne somo pe-eꞌne kako aꞌamu piꞌnɨngo engo somo joho lutɨmaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Oso sɨkuno neso iꞌmofopahonɨngki kako kakoe syoho ulohofiyo sohumo lɨhwojahonɨngki kako aꞌamu sɨmoꞌmo nto lutɨmaꞌmentiso somo ole ulɨmento, Sekwo oyonɨmno. Wosopayoso itoꞌno nto esyohumantono. ");
INSERT INTO apz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ose ko ulahonɨngki aꞌamu angaꞌno angaꞌnohinoso mape-eꞌne hungkuno ulɨmentohofo. Aꞌamu angaꞌno kako ole ulɨmento, Ngko hwaho songo mpe nto imale hwoꞌnyoho. Ngko oso homo somo uhwonamneꞌno yohono. Kɨko nje aꞌamu sohumo ole uso, Ngko mapmnehono. Ose ntohoho uso. ");
INSERT INTO apz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","U, nomꞌnihwo ole ulɨmento, Ngko mpulɨmokau yahu aho hufaꞌu hopiꞌnonohino nje hwaho ijɨwoloꞌmokiyoꞌno mpoꞌmaeso yamofo ulohoꞌmonneꞌno yohono. Oseso kɨko nje aꞌamuhumo ole uso, Ngko mapmnehono. Ose ntohoho uso. ");
INSERT INTO apz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nomꞌnihwo ole ulɨmento, ngko olohonta ape songo mahe sohwoꞌni mapmnehono. ");
INSERT INTO apz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ose ulahonɨngkofi aꞌamu syoho ulohofiyo sohwo kakoe hwe engo sohumo hungkuno mopanehwono ulɨmentohofo soꞌno ulahonɨngki hwe engo sohwo sɨmeho tohino umnɨmentisofoho. Sɨmeho tohino umnɨngkahonɨngki kako kakoe syoho ulohofiyo sohumo ulɨmento, Kɨko komoꞌno uhuji oso ango soponjo honɨngkano engo soponjo soꞌnji honɨngkano weꞌe weꞌe soponjo soꞌnjimo nje wosopayo nyoꞌne joho filutɨmaho. Aꞌamu yoꞌmayo umofonyo inyo soꞌnji aꞌapaho wonyoꞌnjo soꞌnji tɨmpiꞌnyo soꞌnji sɨfe wonyoꞌnjo soꞌnjimo lutɨmahoji nje ango lomo fɨpemotoswape. ");
INSERT INTO apz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ose ulahonɨngki syoho ulohofiyo sohwo aꞌamu homo somo ipemotaponto ulɨmento, Hwe engofo, jɨje hungkunomo inɨngkawenji epohumayo fehohnjoso siki weho. ");
INSERT INTO apz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ose ulahonɨngki hwe engo sohwo ulɨmento, Kɨko honɨngkano engo somo uhuji syohoponjo tokuꞌmango somo kuꞌmokwakuji oso ponjo hwe moyaꞌmi piꞌnɨngo engo somo utɨmahoji fɨpemotoswape. Ngko nje ango somo aꞌamu uhulaꞌmopɨfe nnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngko kikimo wakilɨmo, Oso aꞌamu ngko sɨmoꞌmo joho lutɨmaꞌmaleso hofɨko nje wosopayoso nɨhuꞌno momapitnnehofo. Oso pahnnɨmo hungkunoso Jisas ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hwe moyaꞌmi piꞌnɨngo engo hofɨko Jisasɨꞌnji hano wentanɨngkofi Jisas kako ikinjamo lohofonto ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Aꞌamu fihwo kako ngkimo wonnɨngkapmmo loso sohwo sɨmoꞌmo kako huno itoꞌno uyono. Yoꞌmayo aꞌamumo kako sɨmeho uyɨwoꞌnɨngkisoso kanɨngkwohwo konaꞌwohi kakoe ape kakoe mehomi konɨngkwaꞌwehwo kaisi i, kakoe wopɨngo humayo hi oso homo somo kako sɨmeho uyɨwoꞌnɨngkisoso sɨmeho ntapɨwoꞌnɨngkiso somo yakoloꞌnnyoꞌmanji kako nje inomokomoyo imoꞌnyoso hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aꞌamu nje syoho somneꞌno yoꞌmayo tango ngkimo nɨꞌmante hopaso uꞌmayo soꞌno wopɨngofoho loso sohwo kako nje inomokomoyo ne umoꞌnɨmontonoho. I tango hiso ngkilaho losoꞌmanji kako ngkimo monnɨngkapeꞌnjo hweho. Oseso kakiꞌno kako huno itoꞌno ukwesyafɨsyono. ");
INSERT INTO apz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Sekwo olo pahnnɨmo hungkuno soꞌno fɨsyafɨhupmno. Aꞌamu fihwo kako ango sawemo engo wamolɨmo loso sohwo kako kakiꞌno nofosyohumahwosi oso ango huhwo sohune yoꞌmayo mpe iyoꞌne hamniyoho soꞌno huno itoꞌno ukwesyafɨhuꞌmontonoho. Olo soꞌno wosyafɨsyono, Nje hamniyoho olo ango lomneꞌno moiꞌwo esojwaofoꞌneso hopolɨkeno. Awoꞌmanji mamolomnehono. ");
INSERT INTO apz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kako oso hopa huno mosyafɨsiyoꞌmanji kako hwosaho nto wonjososo ango neso moiꞌwo momolosojwaofeꞌnjoꞌmanji aꞌamu ango homo somo uhwonɨngkuji tɨkafo jɨkuji sitofo ulantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ole wolantɨfeho. Oso hwe sohwo kako ango molomoꞌmaso sohwo kako momolosojwamofe hweho. ");
INSERT INTO apz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","I nomꞌne pahnnɨmo hungkuno fɨsyafɨhupmno. Hwe yofe engoꞌnjo hwaho mokosyohumayo sohwo kako nomꞌne hwe engo sohumo wofongkiꞌnaho lonto inyo sohwo kako kakiꞌno huno itoꞌno ukwesyafɨhuꞌmontonoho. I nje aꞌamu itokusoꞌnjo sohwa ten tausen (10,000) hwafoho. I nomꞌnihwo kakoeso tɨwenti tausen (20,000) hwafoho. I osoꞌno nakwo hofɨkoꞌnji ikujoho fongkiꞌnɨngkuhwasi nakwo hofɨkimo wae weeofantantɨkeno. Hofɨko nakumo wenaofantɨfetɨkeno. ");
INSERT INTO apz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kako mango sohwamo muyakolofone soꞌno syafɨsyɨhwosi kakoe mango sohwa ikanopo nohumentanɨngkuji aꞌamu sɨmeho pompengo isyɨmofoꞌne wolɨhwatɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Oso hopaso aꞌamu fihwo kako ngkimo wakinɨngkamo ntoso sohwo kako kakiꞌno huno itoꞌno ukwesyafɨsyono. Kako yoꞌmayo yoꞌmayo mokosyohumayoso Anɨtuyefoho lɨhwosi kako Anɨtumneꞌno syoho yokumpohnꞌnyo uyɨmontonoho. Kako nje inomokomoyo ne hweho. ");
INSERT INTO apz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nakwo wosopayo saꞌnji nɨwoꞌnɨngkuhwoneso wopɨngofoho. I osoꞌno sa fosyo mijoꞌnohino imoꞌnɨngkuhwosi kakoe yokumpohnꞌnyo nonto wonyo imoꞌnososo apaꞌno sa hiso wopɨngo imoꞌnyoso pipi uyantanto. Awonoho. ");
INSERT INTO apz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Oso sa hiso nakwo syohopo hoꞌnosyasyoso hwaho afofoꞌnjo umoꞌnɨmontolaho. Oꞌo, sa hiso nɨhuꞌnahone siki hoꞌnaofɨwoꞌnɨngkuhwonefoho. Aꞌamu fihwo nje hungkunomo haloho upaꞌnɨmo lɨhwosiꞌmanji halohoꞌnjo hwoꞌmanji haloho upaꞌnono. ");
INSERT INTO apz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Aꞌamu mtaꞌni hamniyoho huꞌmemayo syohoꞌnjo sohwanji aꞌamu honɨngkano wonyoꞌnjo soꞌnji hofɨko Jisasɨye hungkunomo upoꞌnano lontɨfi kakimo uꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Aꞌamu Falisi sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji ose uhwonontɨfi Jisasɨmo sitofo ulɨmentohofi, Olo hwe lohwo kako aꞌamu honɨngkano wonyo imofɨwoꞌnɨngkohofo soꞌnji majopohiꞌnonto wopayo nɨwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jisas oso hisoꞌno huno uyahonɨngki olo pahnnɨmo hungkuno ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Kɨko yahu sipsip wan hantɨlet (100) mokosyohumunyo sohwosi yahu kengaꞌno isɨpeeofɨhwosoꞌno kɨko oso yahu nainti-nain (99) hiso hoja nontanɨnkuji ulɨkoꞌmahoji isɨpeeofoso sohuneꞌno hafɨhafe wotɨpmmonnoho. Hafɨhafe neꞌnohini tɨpehoji wotɨpemaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Notɨpemahoji yahu hiso jɨje sangopo saꞌni kitofohoji sɨmonyoꞌnji hofiyo womotawomonnoho. ");
INSERT INTO apz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kɨko jɨje angopo iꞌmofahoji jɨje aꞌamu soꞌnji jɨje aꞌamu afaponjo soꞌntnneꞌno joho lutɨmahojoꞌno hofɨko nuhuꞌmokukujoꞌno kɨko ole ulɨmontnnoho. Nakwo sɨmonyo uyano. Nje yahu sipsip isopeeoꞌmaso sohwo nto tɨpemahono. Ose ulɨmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jisas ose ulonto ole ulɨmento, Oso hopaso aꞌamu nainti-nain (99) honɨngkano wopɨngo inɨngkuwoꞌnɨngkohofoso hofɨko sɨmeho mɨwoloꞌmokiyoꞌnjo humentanɨngkofi aꞌamu ahwomomjoso uhwonontɨfi sɨmonyo miyofoho. I osoꞌno aꞌamu angaꞌno honɨngkano nɨhuꞌno wonyoꞌnjoso kako honɨngkano wonyo homo somo hohujo ikinjaofɨhwosi Anɨtumneꞌno sɨmonyo mɨkunɨmposo uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Aꞌmu fisi kako hamniyoho aho hufaꞌu hopiꞌnono mokosyohumunyosi kako angaꞌnohino impoꞌnaofososo kako sikiloho mongkujɨhwosi angomjo hintalinyo hulɨjusyɨhwosi tɨmo itoꞌno feꞌnɨhwonɨngkuhwosi neꞌno tɨpemɨhwosi wotɨpemaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Notɨpemahwosi kako kakoe aꞌamu soꞌnji ango hopo soponjo humawoꞌnɨngkohofo soꞌnjimo joho lutɨmahwosoꞌno hofɨko kakoe angopo iꞌmofapɨkujoꞌno ole ulɨmontonoho. Nakwo sɨmonyo uyano. Nje hamniyoho impoꞌnaoꞌmayoso olohonta ngko tɨpemanji nje sɨmeho wopɨngo nɨmoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Oso paꞌnyoso ngko hungkuno waselɨmonneꞌno yohono. Aꞌamu fihwo honɨngkano wonyoꞌnjo sohwo kako kakoe wonyo somneꞌno hohujo ikinjaofɨhwosi Anɨtumneꞌno sɨmeho uyahonɨngkuhwosi aꞌamu ahwomomjoso hofɨko sɨmonyo engo uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas ose ulonto nomꞌne pahnnɨmo hungkuno ulɨmento, Hwe fihwo kako hwomu hufaꞌuꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Akuꞌmu sohwo kanɨngkwohumo ulɨmento, Mpohwo, yoꞌmayo hoꞌyangoso hamniyohoso tɨfi noꞌmo ejapmmneꞌenji elofisasyɨwoꞌnɨngkinoso njeso olohonta ntape. Ose ulahonɨngki kanɨngkwohwo eno ulonto kakoe hwomu hufaꞌu hwaꞌune hoꞌyangoso yano ulofiyonto akuꞌmu sohumo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Sɨkuno weꞌenehwo memjaofahonɨngki akuꞌmu sohwo kako hamniyoho yoꞌmayo hoꞌyango nomɨhuꞌmokonto kako ango ikano engo soponeꞌno umentisofoho. Oso hopo sopo nohumanto nomꞌne aꞌamuꞌnji syohiꞌnyo yonto mijo yokumpohnꞌnyo nonilohofonto kako kakoe aꞌapahomneꞌno hamniyoho hopiꞌnonohinoso huꞌmeeoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kakoe hamniyoho yoꞌmayoso nto huꞌmeeofahonɨngki oso ango hopo sopo mijoho engo iꞌmofapmmentisofoho. Iꞌmofopahonɨngki kako honɨngkanɨmentisoso kakoe yoꞌmayoso huno honɨngkanɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ose yonto kako hamniyoho syoho umo lonto tɨpmmentisoso syoho tɨpemaꞌmentisofoho. Oso hwaho hopo soponjo hwe fihwoe yahu somo wosopayo uyo syohoso tɨpemaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kakoe yahu sohwa oso jopahoso menontanɨngkofi uhwononto kako huno ole syafɨhuꞌmento, Ngko huhwoꞌni womanɨmo. Ose syofɨsyahonɨngki aꞌamu kakimo mufoꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Oso hohosohonta kako huno itoꞌno ikwesyafɨsyonto kakoe hunoso ehohosɨsyahonɨngki ole hnnɨmento, Nje mpohwoe syoho ulohofiyo sohwa wosopayo engo nalokwofo. Ngko kakoe hwomu sohwoꞌni olopo nohumanji mijoho weꞌe mopeꞌnalɨkuyohono. ");
INSERT INTO apz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngkilaho. Ngko nolɨkahmꞌmo nje mpohwoepono asomo uꞌmo ole ulɨmo, Mpohwo, ngko honɨngkano wonyo imote soꞌno ngko Anɨtuꞌnji kɨkoꞌnjimo wonyo selohoꞌmalefoho. ");
INSERT INTO apz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Oseso olohonta ngko hwe wopɨngo hwonɨꞌmaho. Kɨko ngkimo apaꞌno nje hwomufo nontohotoho. Oꞌo, kikimo syoho kilohofiyo hwoꞌni manɨmokufo. ");
INSERT INTO apz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ose hnnonto kako kanɨngkwohwoepono asomo umentisofoho. Kanɨngkwohwo kakoe hwomu nopontanɨngki ikanopo ntaꞌni uhwonɨhwojawento kanɨngkwohwo kakineꞌno hitoho uloꞌmentisofoho. Oseso kako hano kunto kuntoꞌno nowento kakoe hwomumo kapopotohumo lohofonto hinjoho huꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ose ulohofahonɨngki hwomu sohwo ulɨmento, Mpohwo, ngko honɨngkano wonyo imentohe soꞌno ngko Anɨtuꞌnji kɨkoꞌnjimo wonyo selohoꞌmalefoho. Oseso ngko hwomu wopɨngo hwonɨꞌmaho. Kɨko ngkimo apaꞌno nje hwomufo nontohotoho. ");
INSERT INTO apz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ose ko ulahonɨngki kanɨngkwohwo kakoe syoho ulohofiyo sohwamo ulɨmento, Sekwo nowekuji manjiꞌmofo sawemo wonyoangkafoso komoꞌno motapɨkuji nje hwomumo ulohofano. Ajoꞌmiyomjo wokoso wonyoangkafosoꞌnji ulohofano. Sɨfɨkwongofosyoꞌnji ulohofano. ");
INSERT INTO apz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sekwo mpulɨmokau yahu isɨkuꞌnnyo engoso fonjasyɨkuji iloho enɨngkuhwasi sɨmonyo uyano. ");
INSERT INTO apz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hwapɨngoso olo nje hwomu lohwo kako poyo nto peꞌnɨmentononji yɨwoꞌnɨngkohe sohwo olohonta kako apaꞌno songo iꞌmofapohoho. Kako nto isɨpeeoꞌmaso sohwo ngko apaꞌno tɨpemahono. Ose ulahonɨngki nɨhuꞌnahone sɨmonyo emaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ose yontanɨngkofi hwomu tisɨmaso sohwo kako syohoꞌmo humamentisofoho. Osopo ntaꞌni kako asomo noponto ango ne soꞌmo iꞌmofaponto upaꞌnɨmentisoso taꞌnji sɨmonyoꞌnji hoꞌnowentanɨngki upaꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Oseso tisɨmaso sohwo kako syoho ulohofiyo fihumo joho lutɨmanto ulɨmento, Hofɨko peho yalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ose ulahonɨngki ulɨmento, hnnɨngkwaꞌwehwo sohwo nto iꞌmofapohoho. Oseso jɨje mpohwoe mpulɨmokau yahu isɨkuꞌnnyo engoso fonjiyontɨfi sɨmonyo yalokwofo. Hwapɨngoso hnnɨngkwohwo kakoe hwomu huhwo sohumo apaꞌno mayoso wonyo mmoꞌnyoꞌnjo itoꞌno fosyohumayoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tisɨmaso sohwo ose upaꞌnonto sɨmeho tohino umnɨngkahonɨngki kako angomo masyuyofoho. Oseso kanɨngkwohwo mempo noswaponto tisɨmaso sohumo angomo woswapononto hungkuno hofiyo ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ose ko ulahonɨngki tisɨmaso sohwo ulɨmento, Soswo huhwo huhwi ngko kɨkoꞌnji nohumanji kikimo syoho kilohofiyo sikiꞌnjo paꞌnyo imoꞌnɨwoꞌnɨngkohe hwoꞌnyoho. Ngko jɨje hungkunomo yokumpohnꞌnyo mmoꞌnyo kitɨhwayo hwoꞌnyoho. I osoꞌno nje aꞌamu soꞌnji sɨmonyo niyoꞌne kɨko yahu meme weꞌeso me aneso ntopahonɨngkini nje aꞌamuꞌnji sɨmonyo nimentɨhwonetaho. Oꞌo, awonoho. ");
INSERT INTO apz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","I osoꞌno jɨje hwomu akuꞌmu lohwo kako jɨje hamniyoho hoꞌyango yoꞌmayoso hwoyaꞌmi hwaꞌnte sofamo ihnꞌnakumoꞌmaho. I olohonta kako apaꞌno kuꞌmahonɨngki kɨko sɨmonyo iyoꞌne yahu isɨkuꞌnnyo meꞌwampeꞌnjolo fonjiyalokuno. ");
INSERT INTO apz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ose ulahonɨngki kanɨngkwohwo ulɨmento, Nje hwomu sohwosi, sɨkuno huhwo huhwi nekwo majopohiꞌnɨwoꞌnɨngkuhwoyo montosaꞌyoho. Nje yoꞌmayo hopiꞌnonohinoso kɨkoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","I osoꞌno hnnɨngkwaꞌwehwo sohwo kako poyo nto peꞌnɨmentononji iwoꞌnɨngkohehwo ifɨwalofoho. Oseso nakwo sɨmonyo engo ihwasi sɨmeho wopɨngoꞌnjo wohumano. Kako moiꞌwo nto imoꞌnɨmentiso ko huhwo sohwo nakwo olohonta apaꞌno tɨpemahwono. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas kakoe inomokomoyo sohwamo pahnnɨmo hungkuno ole ulɨmento, Hwe hamniyoho engoꞌnjo sohwo kakoe yoꞌmayo syoho umokosyohumayoꞌne sohwo humunyo hweho. Oso hwe syoho umokosyohumayo huhwo sohuneꞌno aꞌamu fehohnjo sohwa hwe engo sohumo ole ulɨmentohofi, Jɨje syoho kilohofiyo sohwo kako jɨje hamniyoho yoꞌmayoso fonɨfonyo kilohofɨwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ose ulahonɨngki hwe engo sohwo kakoe syoho ulohofiyo sohumo joho lutɨmanto ulɨmento, Oso hungkuno kikineꞌno upaꞌnɨngkoheso pipi imahnneꞌelo. Kɨko nje syoho ntohofiyoso hopoenohinɨꞌmaho. Jɨje syoho moiꞌwonoho. Kɨko nje yoꞌmayo syoho mokosyohumawoꞌnɨngkino soꞌno ngkineꞌno hungkuno yolohoso iyoswomo mtɨꞌmojo. ");
INSERT INTO apz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ose ulahonɨngki hwe huhwo sohwo kako ole hnnɨmento, Nje hwe engo sohwo kako ngkimo yoꞌmayo syoho mokosyohumayoso wae weenɨmoꞌmteꞌno yohoho. Ngko pipi imnehono. Nomꞌni hwoe syoho tohohmtnnoꞌnjo somneꞌno ulohofiyo soꞌno yokumpohnꞌnyo ane hwoꞌnyoho. Ngko nomꞌni hwamo wopayo yoꞌmayo soꞌne jomo ujo soꞌno wonɨmangoꞌnjo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nje hwe engo ngkimo wae yanɨmofososo aꞌamu hofɨkoe angomo ntɨmapijo soꞌno ngko pipi imnehono. Huno piꞌnɨngo syofɨsikaofonto huno wopɨngo tɨpemanto ");
INSERT INTO apz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","kako kakoe hwe engo sohwoe yoꞌmayo yoꞌmayo siki maꞌmentohofo sohwamo joho lutɨmaꞌmentisofoho. Sɨmoꞌmjo sohwo uꞌmahonɨngki ulɨmento kɨko nje hwe engo sohumtaꞌni yoꞌmayo yoꞌmayo siki maꞌmentohino soꞌno aku uyɨhnneso alalelo. ");
INSERT INTO apz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ose ulahonɨngki kako ulɨmento, Ngko sikilɨꞌmijo ipofoso wan hantɨlet (100) siki maꞌmentohefoho. Ose ulahonɨngki syoho mokosyohumayo sohwo ulɨmento, Kɨko olopo komoꞌno fosyohumahoji olo iyoswo wan hantɨlet (100) mtɨꞌmokinyo lomo fifɨtiꞌnohini (50) mtɨꞌmojo. ");
INSERT INTO apz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ose ulontanɨngki nomꞌnihwo tɨfi iꞌmofopahonɨngki osohumo ulɨmento, Kɨko nje hwe engo sohumtaꞌni yoꞌmayo siki maꞌmentohino soꞌno aku uyɨhnneso alalelo. Ose ulahonɨngki ulɨmento wopakiꞌyo wan hantɨlet (100) maꞌmentohefoho. Ose ulahonɨngki hwe mokosyohumayo sohwo ulɨmento, Kɨko jɨje aku uhnne soꞌno iyoswo nomahoji etiꞌnohino (80) mtɨꞌmojo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Oso hwe huhwo sohwo ose imentiso soꞌno kakoe hwe engo sohwo ole hnnɨmento, Nje syoho ntohofiyo hwe wonyo sohwo kako hunoꞌnjo hweho. Jisas oso pahnnɨmo hungkuno ulonto, kakoe inomokomoyo sohwamo ulɨmento, Aꞌamu hwahoponjo yahinomo inɨngkawowoꞌnɨngkohofoso hofɨko hofɨkoe hofiyo humayo soꞌno yoꞌmayo hoꞌyango engo mayoꞌne hunoꞌnjofoho. Oso huno engo tɨpemawoꞌnɨngkohofoso aꞌamu Anɨtumneꞌno syafɨsyɨwoꞌnɨngkohofo somo uyakoloꞌnnyofoho. ");
INSERT INTO apz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Oseso sekwo sekwoe hamniyoho hoꞌyango yoꞌmayo soꞌnji nomꞌni hwamo wopɨngoꞌnohini ulohopijoso hwangku sekwoe sɨkuno moiꞌwo imoꞌnoso sohonta hamniyoho yoꞌmayoso ulɨkoꞌmajo sohonta Anɨtu kako kikimo wokitɨmaꞌmontonoho. Osopo wopɨngo neꞌnohino nohumantohotnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kɨko yoꞌmayo weꞌe somo itoꞌno mokosyohumayoꞌmanji yoꞌmayo engo somo itoꞌno womokosyohumamonnoho. I hwe fihwo kako yoꞌmayo weꞌe somo syoho itoꞌno miyoꞌmanji kako yoꞌmayo engo homo syoho itoꞌno miyonehoho. ");
INSERT INTO apz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kɨko hwahoponjo hamniyoho hoꞌyango yoꞌmayo somo itoꞌno momokosyohumayoꞌnjo isoso ahwomomjo hoꞌyango neso mokosyohumayo syoho ne tɨhwo wokijapmmontolo. ");
INSERT INTO apz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kɨko nomꞌnihwoe yoꞌmayo somo itoꞌno momokosyohumayoꞌnjo isoso kɨkoꞌne hoꞌyango yoꞌmayoso tɨhwo wokijapmmontolo. ");
INSERT INTO apz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Jisas ose ulonto ulɨmento, Hwe fihwo kako hwe engo hufaꞌu sohwaꞌumo syoho ulohofiyoso hopoꞌmaho. Oꞌo, hwe engo hufaꞌu sohwaꞌumo syoho ulohofiyo soꞌmanji syoho ulohofiyo sohwo kako hwe engo fihumo sɨmeho uyɨhwosi nomꞌnihuneꞌno sɨmeho wonyo uyɨmontonoho. U, angaꞌnohino sohwoe syoho somneꞌno hi umoꞌnɨngkuhwosoꞌno nomꞌnihumneꞌno ngkilaho unɨmontonoho. Kɨko Anɨtuye syoho soꞌnji yoꞌmayo hwahoponjo yahino soꞌnji oso hufaꞌuyo sohwaꞌumo mokosyohumayoso syoho itoꞌno mihnnehino. ");
INSERT INTO apz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aꞌamu Falisi hofɨko hamniyohoꞌno hi umoꞌnyo sohwa Jisasɨye hungkuno homo somo upaꞌnontɨfi hofɨko Jisasɨmneꞌno sɨmano wonyo ikinontɨfi sitofo ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisas hofɨkimo ulɨmento, Sekwo aꞌamufe tɨmopo yahino wopɨngoꞌnjo hwafoho nalɨfitnneꞌentɨfi yahino itoꞌnohino iwoꞌnɨngkohofɨhwasoho. I osoꞌno Anɨtu kako sekwoe sɨmeho moꞌmjo soꞌno huno uyohoho. Sekwo yoꞌmayo iwoꞌnɨngkohofosomo aꞌamu uhwonontɨfi sekwoe yofe ko hoꞌnosemahonɨngkofi Anɨtu kako sekwoe sɨmeho moꞌmjo soꞌno huno unyo soꞌno kako wonyofoho selalofoho. ");
INSERT INTO apz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mousesɨye honɨngkano hungkuno soꞌnji aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo soꞌnji neꞌno nowentanɨngki Joun aꞌamumo mijo kiyomaꞌmojo sohwo iꞌmofapmmentisofoho. Mꞌmofape sohonta Anɨtu kako oso hungkuno sɨmoꞌmjo somo nnɨngkapɨfitnneꞌento lɨmentisofoho. I osoꞌno Joun iꞌmofapmmentiso sohonta kako Anɨtumo enjwaꞌmo itoꞌno humayo soꞌno hungkuno wopɨngo lomaꞌmentisofoho. Oseso olohonta aꞌamu piꞌnɨngo engo Anɨtumo uꞌmano lontɨfi mjiyohoto yohotofo ko mjolohoꞌnɨmopahonɨngkofi sekwo aꞌamu Falisi sohwasi tɨmoꞌnohini uhwontohumawoꞌnɨngkohofo hwasoho. ");
INSERT INTO apz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Hungkuno songo ko lomaꞌmentisoso nakwoe hwahoꞌnji ahwomoꞌnji moiꞌwo ko imoꞌnɨngkuhwosi Anɨtuye honɨngkano hungkunoso moiꞌwo mmoꞌnyo neꞌno nowentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Hwe fihwo kako kakoe ape hoꞌnasyɨhwosi nomꞌne ape maso sohwo kako ape itoꞌno mayo honɨngkano somo mtɨhupeso sohwo kako ose yososo kako honɨngkano wonyoꞌnjo hweho. I nomnꞌihwo kako ape nomꞌnihwo hoꞌnasyoso somo maso sohwo kako huhwo ape itoꞌno mayo honɨngkano somo mtɨhupeso soꞌno kako huhwo honɨngkano wonyoꞌnjo hweho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisas kako ole ulɨmento, Hwe fihwo kako hamniyoho yoꞌmayo hoꞌyango engoꞌnjo sohwo nohumanto he wopɨngo wopɨngoꞌnohinoso yonto wosopayo wonyoangkafoꞌnohini nɨmojo hweho. ");
INSERT INTO apz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Oso hwe huhwo sohwoe hokuꞌyo sopo aꞌamu fehohnjo sohwa hwe hoꞌyango ane fihumo motasontɨfi uhumatɨꞌmotofofoho. Oso hwe huhwo sohwoe yofe Lasalosɨyoho. Kakoe aꞌapaho uyo engoꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Oso hwe hamniyoho engoꞌnjo sohwoe ijempoho sopo ntaꞌni yoꞌmayo wosopayo mɨkufo pɨwasyonteso womanɨmo lonto humamojofoho. Osopo nohumentanɨngki sɨwojoso kakoe uyomo melanyo kotoꞌmotofofoho. ");
INSERT INTO apz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hwangku sohonta oso hwe hoꞌyango ane sohwo poyo peꞌnɨngkahonɨngki aꞌamu ahwomomjoso utɨmotasontɨfi Apɨlohamꞌnjopo uhumatɨꞌmentohofofoho. Hwe hoꞌyango engoꞌnjo huhwo poyo peꞌnɨngkahonɨngki aꞌamu sohwa hwahomo ijopijisyahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Oso hwe hoꞌyango engoꞌnjo sohwo kako tɨkanomo nohumanto aꞌapaho tohino mɨkunɨmposoꞌnji humanto tɨmo yokintahopo uhwonɨmentisoso Apɨloham kengo nohopo nohumentanɨngki uhwononto Lasalosoꞌnji nohumentanɨngki uhwonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Oso hwe hoꞌyango engoꞌnjo sohwo ose uhwononto joho mohmꞌno ulɨmento, Mpohwo Apɨloham sohwosi, kɨko ngkineꞌno hitoho wakilofono. Kɨko Lasalos ngkiyepono filɨhwajo. Kako nopɨhwosi kakoe ajoꞌmiyo mijo yomahwosi nje melanyopo ingo wantɨpeno. Ngko olohonta tohomo humanji tohino engo nɨmnantofoho. ");
INSERT INTO apz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ose ulahonɨngki Apɨloham ulɨmento, Hwomuhwo, kɨko huno wakiyono. Hohonta kɨko songo humanji kɨko yoꞌmayo yoꞌmayo wopɨngoꞌnohini tɨpemaꞌmotnno hwosoho. I, Lasalos sohwo kako yoꞌmayo wonyoꞌnohino tɨpemaꞌmojo hweho. I olohonta Lasalos kako wopɨngo humentanɨngki kɨko tohinoꞌnji fosyohumahnno. ");
INSERT INTO apz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Osoꞌnji nomꞌne huno ole wakiyono. Nakwoꞌnji sekwoꞌnji ajwo lopo Anɨtu kako momonyo mɨkunɨmposo hoꞌnahumentiso weho. Aꞌamu olo hohntaꞌni humalofoso sekuyepono woseꞌmano lɨkuji oso momonyo somo nomtɨhupekuji moseꞌmapitnnehofo. Aꞌamu sekwoꞌnji humalofoso oso momonyo homo somo nomtɨhupekuji hofɨko nakuyepono mowekapɨfitnnehofo. ");
INSERT INTO apz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ose ulahonɨngki hwe hoꞌyango engoꞌnjo sohwo ulɨmento, Mpohwo hungkuno yokumpohnꞌnyo wakilɨmonneꞌno yohono. Kɨko Lasalos sohumo nje mpohwoepono filɨhwajo. ");
INSERT INTO apz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Oso hopo sopo nje nɨngkwahwosa aho fehohnjo hopiꞌnonohino sohwa humalofo. Lasalos kako nje aꞌamu huhwo sohwamo olo ango tohinoꞌnjo lopono iꞌwaho itoꞌno iyoꞌno hungkuno yokumpohnꞌnyo ulono. Hofɨko olopo nopɨfitnnoho. ");
INSERT INTO apz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ose ulahonɨngki Apɨloham ulɨmento, Hofɨko Mousesɨye hungkunoꞌnji aꞌamumo Anɨtu hungkuno uyahonɨngki lɨmotofo sohwafe hungkuno hiꞌnjo hwafoho. Oso hungkuno homo somo haloho upaꞌnɨfe. ");
INSERT INTO apz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ose ulahonɨngki aꞌamu hoꞌyangoꞌnjo sohwo ulɨmento, Oꞌo, Mpohwo Apɨloham sohwosi, hungkuno homo somo mupaꞌnɨfitnnehofo. I osoꞌno aꞌamu poyo sohwo songo nolɨkafɨhwosi hofɨkimo uꞌmahwosoꞌno hofɨko sɨmeho yɨwoloꞌmo kukuji honɨngkano wonyomo hohujo ukinjaofantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ose ulahonɨngki Apɨloham ulɨmento, Hofɨko Mousesɨye hungkuno soꞌnji aꞌamu Anɨtu hungkuno uyahonɨngki lɨmotofo sohwafe hungkuno soꞌnji mupaꞌnɨfijoꞌmanji aꞌamu poyo fihwo songo lɨkafɨhwosi uꞌmahwosi hungkuno ulɨhwosoꞌno hofɨko kakoe hungkuno homo sɨmeho hiꞌntnnono muyɨfitnnehofo. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas kakoe inomokomoyo sohwamo ulɨmento, Aꞌamu Anɨtuye hungkunomo sɨmeho uyɨwoꞌnɨngkohofo somo yoꞌmayo yahino wonyo yamofo ulohofoꞌneso nehopi iꞌmofaponefoho. Iꞌmofapɨhwosoꞌno aꞌamu piꞌnɨngoso wopɨwesyantɨfeho. I osoꞌno oso aꞌamu nomꞌnihwo pɨwasiyoꞌne yamofo ulohofoso sohwo tohino engo manefoho. Osoꞌno kako huno itoꞌno wasyofɨsyono. ");
INSERT INTO apz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Oso hwe huhwo sohwo kako nje mehomi weꞌe sohumo yamofo mulohofeꞌnjo sohonta aꞌamu kakoe tɨꞌwangomo sojo mɨkunɨmposo ifakojujɨkuji mijo ayomo hoꞌnaofontɨfijontesi wopɨngoꞌnesohilo. Hwapɨngoso aꞌamu nje mehomi lohwamo pɨwasiyoꞌne imokoso sohwo tohino mɨkunɨmposo manefoho. ");
INSERT INTO apz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Oso yahino hisoꞌno sekwo iꞌwaho itoꞌno fiyɨmno. Jɨje nɨngkwahwo wonyo kilohofo soꞌmanji kɨko oso yahino wonyo somneꞌno yoka uso. Ulohojoꞌno kako kakoe yahino wonyo somneꞌno sɨmeho tango tɨpemahwosi oso wonyo somo wae yaofo soꞌno kilɨhwosoꞌno kɨko oso wonyo hiso wae hmmofo. ");
INSERT INTO apz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sɨkuno angaꞌnohino fihumo kako kikimo wonyo neꞌno kilohofontanɨngkuhwosi aho fehohnjo hopiꞌnono nomꞌni mtaꞌni hufaꞌu ko imoꞌnɨngkuhwosoꞌno kako wonyo angaꞌno angaꞌno yoso somneꞌno, Tatohwo kɨko nje wonyo wae feenɨmofo, oseso neꞌno kilontanɨngkuhwosi kɨko kakoe wonyoso wae neꞌno hmmofo. ");
INSERT INTO apz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aꞌamu Anɨtuye hungkuno lutɨhumɨkuꞌmofo syohoꞌnjo (apousel) sohwa Jisasɨmo ulɨmentohofi, Nakwo sɨmeho hiꞌntnnono kijopalokuhwone somo kɨko engo fonamojo. ");
INSERT INTO apz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo ngkimo sɨmeho hiꞌntnnono montopantokuyohofo. Sekwo ngkimo nnɨngkape-eso nɨhuꞌno weꞌe patnnyo uyo paꞌnɨngoꞌmanji sekwo oso iyo ipisayoꞌnjo sohumo ole ulɨfijoso, Pmpongo hiꞌnji sokato lohofohoji mijo ayo nompo filohofayo. Ose ulɨfijoꞌmanji iyo huhwo sohwo kako sekwoe mangomo haloho wasepoꞌmontonoho. I osoꞌno sekwo ngkimo moꞌnnɨngkapohiyohofo. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Hwe fihwo sekwoꞌnjopo humaso sohwo kako syoho ulohofiyo hiꞌnjo hwoꞌmanji oso syoho ulohofiyo sohwo kako syohopo hwaho mno ijiyotaho, yahu mokosyohumayotaho, u kako moiꞌwo ihwosi kako kakoe hwe engo sohwoꞌnjopo iꞌmofaponto kako wopayo mijoho ko uyahonɨngki kako komoꞌno humahopɨhwosi wopayo manonehoho. ");
INSERT INTO apz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Oꞌo, sɨmoꞌmo kako kakoe hwe engo sohwoe wosopayo itoꞌno esyohumahwosi kakoe he wopɨngo ihwosi wosopayo hiso ikuꞌyopo ifosyalokumpehwosi hwe engo sohumo wosopayo uyɨmtonoho. Kakoe hwe engo sohumo wopayo moiꞌwo kakiꞌno uyɨhwosi kako tɨfi wanɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Oso hwe engo huhwo sohwo kako kakoe syoho ulohofiyo huhwo sohumo kakoe syoho itoꞌno imentiso soꞌno isamoyoka ulɨmontolaho. Oꞌo, awonoho. Hwapɨngoso kakoe syohoꞌnohinofoho lɨhwosi isamoyoka mujoꞌnjo uyɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Oseso sekwo hoku yoꞌmayo hungkuno Anɨtu seloso somo sekwo itoꞌno ko inɨngkafijoso sekwo huno ole fɨsyafɨhupmno. Nakwo Anɨtuye syoho ulohofiyo hnꞌnwi nakwo itoꞌnohinonɨꞌmaho. Kakoe syoho iwoꞌnɨngkuhwone soꞌno nakwoe yofe hoꞌnonemayoso pehoꞌneto. Oꞌo, nakwoe syohofoho. ");
INSERT INTO apz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas kako Jelusalemne honɨngkano hwaho Someliyaꞌnji Ngkaliliꞌnji neꞌno ajwopo sɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kako ango fipo iꞌmofopahonɨngki hwe aho hufaꞌu hopiꞌnono uyo wonyo engoꞌnjo sohwa Jisasɨmo honɨngkanopo uswoꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Hofɨko ikanopo lohofontɨfi Jisasɨmo joho mohmꞌno ulɨmentohofi, Jisas Hwe Engo sohwosi, kɨko nakumneꞌno hitoho wakilofono. ");
INSERT INTO apz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ose ulahonɨngki Jisas hofɨkimo uhwononto ulɨmento, Sekwo nukuji aꞌamu tajo ango syohoꞌnjo sohwamo sekwoe aꞌapaho motakuji utɨhwamno. Ose ulahonɨngki halohoꞌno yontɨfi hofɨko nowentɨfi hofɨkoe aꞌapahoso honɨngkano ajwopo wopɨngo umoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hwe fihwo hofɨkoꞌnjo ajwo sopo humaso sohwo kakoe aꞌapaho wopɨngo honɨngkononto kako Jisasɨyepono asomo umentisofoho. Kako mango engo lonto Anɨtuye yofe hoꞌnomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kako Jisasɨmo uꞌmanto hwahopo pɨwasyonto kako Jisasɨye sɨfɨkiꞌnyoꞌmo sɨmano mongkutofosyohumanto Jisasɨmo isamoyoka engo ulɨmentisofoho. Oso hwe huhwo sohwo kako hwaho Someliyantaꞌango hweho. ");
INSERT INTO apz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisas osohumo uhwononto ulɨmento, Aꞌamu aho hufaꞌu hopiꞌnono sohwamo wopɨngo umokohono. Kɨkoꞌnohini nɨꞌmahinoso nomꞌnihwa ntɨꞌmo humalofo. ");
INSERT INTO apz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Olo hwe lohwo kako aꞌamu Juta hwoꞌmaho. Oꞌo, temtitofo kengo mtaꞌango hweho. Kakoꞌnohini Anɨtumo isamoyoka ujoꞌne asomo pisoso pehoꞌneto. ");
INSERT INTO apz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ose lonto ulɨmento, kɨko nolɨkafohoji mpano. Kɨko sɨmeho hiꞌntnnono ntapohino soꞌno jɨje aꞌapaho wopɨngo kumoꞌnɨngkohoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aꞌamu Falisi fehohnjo sohwa Jisasɨmo ulɨmentohofi, Anɨtu kakoe aꞌamumo yokumpohnꞌnyo emokosyohumayoꞌne sɨkunoso ntohonta uꞌmofapmmontolo. Ose ulahonɨngkofi Jisas ulɨmento, Anɨtu kakoe aꞌamumo emokosyohumayoso aꞌamu tɨmoꞌnji muhwonɨfitnnehofo. ");
INSERT INTO apz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Sekwo ole malɨfitnnehofo. Ihwoni, Anɨtu kako kakoe aꞌamumo emokosyohumayoso olopo weho. U, nompo weho. Ose malɨfitnnehofo. Oꞌo, Anɨtu kakoe aꞌamumo emokosyohumayoso sɨmeho moꞌmo woꞌnnyoponoho. Sekwoe tɨmoꞌnji muhwonɨfitnnehofo. ");
INSERT INTO apz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jisas ose ulonto kakoe inomokomoyo sohwamo ulɨmento, Hwangku nomꞌne sɨkuno iꞌmofapɨhwosoꞌno sekwo ole wohnnantɨfeho. Nakwo oso Hwomu Anɨtu uhwosopoꞌmentiso sohumo uhwonontaneꞌno yɨhwono. Ose ko hnnɨngkuji sekwo muhwonɨfitnnehofo. ");
INSERT INTO apz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Oso hohosohonta aꞌamu fehohnjoso ole woselantɨfeho, Ihwoni, oso hwomu Anɨtu uhwosopoꞌmentiso sohwo oso nompo humaho. U, olopo humaho. Ose selɨkujoꞌno sekwo haloho upekutoho. Aꞌamu huhwo sohumo nuhwonɨngkakutoho. ");
INSERT INTO apz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sekwo emtaꞌmɨngo soꞌno huno seyohoho. Emtaꞌmɨngo kako oso nompo ntaꞌni yonto kako ahwomomo ifehuꞌmokosyahonɨngki aꞌamu hopiꞌnono tɨmo uhwonɨwoꞌnɨngkohofofoho. Oso paꞌnyoso oso Hwomu Anɨtu uhwosopoꞌmentiso sohwo kakoe pe-eso emtaꞌmɨngo uhwonɨwoꞌnɨngkuhwone paꞌnyoso iꞌmofapɨhwosoꞌno sekwo uhwonɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","I osoꞌno sɨmoꞌmo oso Hwomu huhwo sohwo kako tohino engo umnososo aꞌamu olohonta humalofoso kakineꞌno hohujo ukinjɨmofantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Oso aꞌamu hohonta Nɨwaꞌnji humamotofoso kako yofayokinomo humentiso sohonta yoꞌmayo yahino imotofo paꞌnɨngoso oso Hwomu Anɨtu uhwosopoꞌmentiso sohwo poso sohonta aꞌamu humalofoso uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Hofɨko humamotofo sohonta hofɨko wosopayoꞌnji mijoꞌnji nonontɨfi ape maꞌnɨmotofofoho. Oso yahino hiso neꞌno mjɨmɨwentanɨngkofi Nɨwa kako yofayokinomo noswahonɨngki mijo ifofayo engo yonto hwe hwoyaꞌmi hopiꞌnonohinoso mijo mihuloꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Apɨlohamɨye kami Lout sohwo humamojo sohonta aꞌamu humamentohofo oso hiso paꞌnyo imotofofoho. Hofɨko nohumantɨfi yoꞌmayo wopayo mijo nontɨfi yoꞌmayo hoꞌyango mpe yontɨfi nomꞌni hwamo hamniyoho mayoꞌne hoꞌyango uyontɨfi hofɨko wopayo syoho yontɨfi ango molɨmotofofoho. ");
INSERT INTO apz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ose yontanɨngkofo sohonta Lout kako ango Soutom ulɨkoꞌmanto ango kengopo nowahonɨngki tohoꞌnji sojo hwoyango hnnyo soꞌnji ahwomo mtaꞌni ifoyo hopa syonto hwe hwoyaꞌmi hopiꞌnonohino somo wonyo imokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aꞌamu oso paꞌnɨngo yontanɨngkuji oso hwomu Anɨtu uhwosopoꞌmentiso sohwo utɨhwaꞌnyopo iꞌmofape soꞌno Anɨtu ujo wehontojwahumontonoho. ");
INSERT INTO apz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Oso sɨkuno homo somo utɨhwaꞌnyopo iꞌmofaposo sohonta aꞌamu fihwo kako angkuhwafopo humaso hwoꞌmanji kako hwomu huhwo sohumo uhwonɨngkuhwosi kakoe angomjo hoꞌyango yoꞌmayoso mayosoꞌno huno mosyafɨsyonehoho. Oso paꞌnyoso hwe fihwo syohoꞌmo humaso hwoꞌmanji kako hwomu huhwo sohumo uhwonɨngkuhwosi kakoe angoponjo yoꞌmayoso mayosoꞌno huno mosyafɨsyonehoho. ");
INSERT INTO apz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Oꞌo, sekwo Loutɨye ape simneꞌno fɨsyafɨhupmno. Kako kakoe angoponjo yoꞌmayo soꞌno syafɨsyonto ikinjaoꞌmentisoso sojo imoꞌnɨmentiso somneꞌno fɨsyafɨhupmno. ");
INSERT INTO apz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aꞌamu olo hwaho loponjo humayo somo aho yokumpohnꞌnyo kemokosyohumunyo sohwo kakoe fosyohumayoso moiꞌwo umoꞌnɨmontonoho. Aꞌamu olo hwaho loponjo humayo somo aho mokemokosyohumunyo sohwo kakoe fosyohumayo neso wotɨpemaꞌmonte hweho. ");
INSERT INTO apz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ngko waselɨmonneꞌno yohono. Sekwo itoꞌno upaꞌnɨmno. Oso sɨkuno Hwomu sohwo poso sohonta hwe hufaꞌu hwaꞌu saho afapo fosyowentanɨngkohosɨsi Anɨtu nomꞌnihumo utɨmahwosi nomꞌnihwo wohumamontonoho. ");
INSERT INTO apz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","I aꞌmu hufaꞌu faꞌu wopayo sɨhu kolofontanɨngkohosɨsi Anɨtu nomꞌnimo utɨmahwosi nomꞌnisi wohumamontonoho.  ");
INSERT INTO apz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","I hwe hufaꞌu hwaꞌu syohopo lohofontanɨngkohosɨsi Anɨtu nomꞌnihumo utɨmahwosi nomꞌnihwo wohumamontonoho. ");
INSERT INTO apz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jisas ose ulahonɨngki inomokomoyo sohwa nupaꞌnontɨfi Jisasɨmo ulɨmentohofi, Hwe Engofo ose nalohinoso imoꞌnyoso ntɨpo umoꞌnɨmontolo. Ose ulahonɨngkofi Jisas pahnnɨmo hungkuno ole ulɨmento, Aꞌamu poyo peꞌnyo sohwoe pijafo woꞌnnyo sopo yɨhufo ajiꞌmango oso hopo sopo uhuꞌmokufitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas kako aꞌamuso Mpohumo jomo neꞌno ulɨkuji pisoꞌmoꞌnyo mmunyoꞌnjo iyoꞌne pahnnɨmo hungkuno ole ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ango fipo aꞌamufe hungkuno mɨhwajiyoꞌne hwe engo sohwo humunyofoho. Kako Anɨtu sohumneꞌno iyoho munyoꞌnjo yonto aꞌamu somneꞌno hwotoho fewoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Oso hopo sopo apɨwojo fisi kako humunyoponoho. Sɨkuno engo sopamo kako oso hwe hungkuno itoꞌno mɨhwajiyo iyo sohwoepono pɨwoꞌnɨngkisiyoho. Ole ulɨmojo, Nje mango sohwa hofɨko ngkimo wonyo wonɨmokantɨfeꞌno yalokwofo. Osoꞌno kɨko ngkineꞌno hungkuno itoꞌno menɨhwajo. ");
INSERT INTO apz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ose ko ulahonɨngki sɨmoꞌmo hwe engo huhwo sohwo oso apɨwojo simo ufoꞌmayoso ngkilaho ko lonto tɨfi noꞌmo ole syafɨhuꞌmento, Ngko Anɨtumneꞌno iyoho ko miyonji aꞌamumneꞌno huno mosyafɨsiyoꞌnjo ko yonji ");
INSERT INTO apz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","i oseso olo apɨwojo losi kako ngkimo neꞌno nɨꞌmawoꞌnyosi syoho engo ntopantokuso soꞌno ngko kakimo ufoꞌmaꞌmo. Kakoe hungkunomo itoꞌno womɨhwatɨmonnoho. Kako ngkimo sɨkuno huhwo huhwi nɨꞌmawoꞌnyo ihwosi nje aꞌapaho wonyo nɨmokonoho. ");
INSERT INTO apz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jisas ose ulonto ulɨmento, Oso hwe engo hungkuno mɨhwajiyo syohoꞌnjo wonyo sohwoe hungkuno haloho nto upaꞌnɨngkohofo soꞌno sekwo huno fɨsyafɨhupmno. ");
INSERT INTO apz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Oso hwe wonyo sohwo ose imentiso soꞌno sekwo huno pipi seyohoho. Anɨtu kako kakoe aꞌamu uhwosopoꞌmentisoso hofɨko kakineꞌno jomo sɨkuno huhwo huhwi imɨngoꞌnji sɨkunoꞌnji ulɨwoꞌnɨngkohofo soꞌno kako hofɨkimo momuhwajiyo uyɨmontolaho. I komoꞌno womuhwatɨmontolaho. ");
INSERT INTO apz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngko sekumo waselɨmonneꞌno yohono. Anɨtu kakoe aꞌamumo komoꞌno womɨhwatɨmontonoho. I osoꞌno oso Hwomu Anɨtu nɨhwosopoꞌmentiso sohwoꞌni nopmꞌmo aꞌamu ngkineꞌno sɨmeho hiꞌntnnono ntopontanɨngkujo wasehonɨmonntaho. ");
INSERT INTO apz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aꞌamu fehohnjo hofɨko hofɨkoe yahino wopɨngo somneꞌno hofɨkoe yofe hoꞌnomaꞌnontɨfi aꞌamu nomꞌne sohwamneꞌno wonyofoho lɨwoꞌnɨngkohofo somneꞌno Jisas kako olo pahnnɨmo hungkunolo ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Hwe hufaꞌu hwaꞌu siko Anɨtumo jomo ulaho lonji Anɨtuye tajo ango engo somo humentisiyefoho. Hwe fihwo kako aꞌamu Falisi hweho. Nomꞌnihwo kako hamniyoho mayo syohoꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Aꞌamu Falisi huhwo sohwo kako nolohofonto kakoe sɨmeho moꞌmo ole hnnɨmento, Mpohwo Anɨtu, ngko nomꞌne aꞌamu paꞌnyo hwonɨꞌmaho. Osoꞌno ngko isamoyoka kilalokweno. Hofɨko yoꞌmayo hufo yontɨfi yoꞌmayo yahino itoꞌnohino somo miyontɨfi hofɨko ape itoꞌno maꞌnyo honɨngkano somo mtɨhupewoꞌnɨngkohofɨhwafoho. Ngko oso paꞌnyo hwonɨꞌmaho. I ngko olo hwe hamniyoho mayo syohoꞌnjo sohwo paꞌnyo hwonɨꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Oꞌo, ngko Sante huhwo huhwi sɨkuno hufaꞌu somo ngko wopayo manyoꞌnjo humawoꞌnɨngkohe hwoꞌnyoho. Yoꞌmayo hopiꞌnonohino nomantnneso ngko aho hofohuꞌnono hopiꞌnonohinoso mtɨhupo mtɨhupe lohofonji kengaꞌno kikineꞌno hoꞌnakisyɨwoꞌnɨngkohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ose ulontanɨngki oso hwe hamniyoho mayo syohoꞌnjo sohwo kako kengopo lohofonto kako ahwomomo tɨmo uhwonyoso wonɨmangoꞌno ingkuꞌno humanto kakoe swokinopo hwanɨngo pohnꞌnonto ulɨmento, Anɨtu ngko hwe wonyo sohwoꞌnneꞌno kɨko hitoho wakilofono. ");
INSERT INTO apz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jisas oso pahnnɨmo hungkuno ulonto aꞌamu homo somo ole ulɨmento, Ngko waselɨmonneꞌno yohono. Oso hwe hamniyoho mayo syohoꞌnjo sohwo kako Anɨtumo ose ulɨmentiso soꞌno Anɨtu kako uhwononto hwe wopɨngo hweho ulahonɨngki hwe huhwo sohwo kako kakoe ango poneꞌno asomo umentisofoho. I oso aꞌamu nomꞌne Falisi sohwo oseꞌnjo hwoꞌmaho. Oꞌo, aꞌamu kakoe yofe hoꞌnomaꞌnɨwoꞌnɨngkiso sohumo Anɨtu kako monje ulohoꞌmontonoho. I osoꞌno aꞌamu kako kakoe yofe monje yahinuwoꞌnɨngkiso sohwoe yofeso Anɨtu kako wohoꞌnɨmaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aꞌamu piꞌnɨngo engoso hofɨko hofɨkoe mehomi weꞌe somo Jisas mnokinopo aho ulonjimokonontɨfi motapmmentohofofoho. I osoꞌno Jisasɨye inomokomoyo sohwa hofɨkimo ose uhwonontɨfi yoka ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yoka ulahonɨngkofi Jisas kako mehomi somo joho lutɨmanto inomokomoyo sohwamo ole ulɨmento, Sekwo mehomi somo nopɨjumofɨkutoho. Oꞌo, hofɨko ngkiye pono wapɨfe. Aꞌamu olo mehomi lohwa paꞌnyo imoꞌnɨfijoꞌmanji hofɨko Anɨtumo enjwaꞌmo itoꞌno wohumantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","I hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Aꞌamu olo mehomi lohwa paꞌnyo mmoꞌnyoꞌnjoꞌmanji hofɨko Anɨtumo enjwaꞌmo humayoso hopaꞌmaho. Nɨhuꞌno awonoho. ");
INSERT INTO apz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Hwe fihwo yofe engoꞌnjo sohwo kako Jisasɨmo ole ulɨmento, Kɨko Anɨtuye yahino netɨhwawoꞌnɨngkohino wopɨngo hwosoho. Ngko engolopohamo songo neꞌno humayo yahinoso pipi tɨpemaꞌmnehono. ");
INSERT INTO apz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ose ulahonɨngki Jisas ulɨmento, Kɨko wopɨngo hwosoho eso pehoꞌne ntohino. Anɨtu kakoꞌnohini wopɨngo hweho. ");
INSERT INTO apz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kɨko honɨngkano hungkuno soꞌno huno moiꞌwonoho. Ole nalohi, Kɨko ape itoꞌno mayoꞌne yahino somo nomtɨhuposoꞌeno. Kɨko nomꞌnihumo nofonjasiyoꞌeno. Kɨko yoꞌmayoso hufo iyoꞌeno. Nomꞌnehumo hwasyo hungkuno ujoꞌeno. Kɨko jɨje mpohwoꞌnji naꞌuꞌnjiye hungkunomo tɨfi finɨngkayo. ");
INSERT INTO apz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ose ulahonɨngki hwe yofe engoꞌnjo sohwo ole ulɨmento, Ngko hungkuno homo somo upaꞌnɨmopmmote sohwoꞌni olohonta neꞌno ose nohini inɨngkowalokweno. ");
INSERT INTO apz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas oso hungkuno upaꞌnonto ole ulɨmento, Yahino angaꞌnohino somneꞌno kɨko umofonyo yalokuno. Ole fiyo. Kɨko jɨje hoꞌyango yoꞌmayoso aꞌamu mpe kilohofɨkujoꞌno kɨko oso hamniyohoso nomahoji aꞌamu hoꞌyango ane somo yano ulofiyo. Kɨko ose isoso kɨko ahwomomjo hoꞌyango neso womaꞌmonnoho. Ose yohoji kɨko ngkimo tɨfi nnɨngkape. ");
INSERT INTO apz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ose ulahonɨngki hwe engo huhwo sohwo kako nupaꞌnonto sɨmeho tango umentisofoho. Hwapɨngoso kako hamniyoho hoꞌyango yoꞌmayoso mɨkunɨmposoꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas kako oso hwe huhwo sohwoe sɨmeho tango uhwononto nomꞌne aꞌamu somo ulɨmento, Aꞌamu hamniyoho yoꞌmayo hoꞌyango aho yokumpohnꞌnyo kemokosyohumawoꞌnɨngkohofoso hofɨko Anɨtumo enjwaꞌmo humayoꞌneso syoho engo ifitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yahu fihwo kako yongo imo paꞌnyo soꞌmo wahumo lɨhwosi yososo wonyopi umontonoho. Oso paꞌnyoso hwe hoꞌyango hamniyoho yoꞌmayoso aho yokumpohnꞌnyo kemokosyohumantoso sohwo Anɨtumo enjwaꞌmo wohumamo lɨhwosi yososo hopoꞌmaho. Oꞌo, kako yahu sohwo yongo imo paꞌnyo soꞌmo wahumo lɨhwosi ijijo wonyopi yoso hopaso oso hwe hoꞌyango engoꞌnjo sohwo oseno yonefoho. ");
INSERT INTO apz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ose ulahonɨngki oso aꞌamu oso hungkuno hiso upaꞌnɨmentohofo soꞌno hofɨko yomo yontɨfi ole ulohonɨmentohofi, Oseꞌmanji aꞌamu Anɨtuꞌnji ango wopɨngo sopo songo neꞌno humayoꞌneso tɨhwo womaꞌmontolo. ");
INSERT INTO apz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ose ulahonɨngkofi Jisas ulɨmento, Yoꞌmayo hopiꞌnono aꞌamu miyɨwoꞌnɨngkiyohofoso Anɨtu yososo hoponoho. ");
INSERT INTO apz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ose ulahonɨngki Pita ulɨmento, Nakwo nakwoe angopo yoꞌmayo yoꞌmayoso ulɨkoꞌmentani kikimo kinɨngkopalokuhwono. ");
INSERT INTO apz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ose ulahonɨngki Jisas ulɨmento, Ngko hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Aꞌamu hofɨko Anɨtumo enjwaꞌmo wohumano hnnontɨfe soꞌno hofɨko hofɨkoe angoꞌnji apeꞌnji hamnɨngkwaꞌwehwosanji, kanɨngkwohwoꞌyaꞌuꞌnji kakoe mehomiꞌnji ulɨkoꞌmapijo soꞌno ");
INSERT INTO apz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Anɨtu kako hofɨko ose ulɨkoꞌmapijoso hofɨkimo yoꞌmayoso piꞌnɨngo engo aku uyɨhwosi tɨfi noꞌmo kako hofɨkimo songo neꞌno humayoso uyonefoho. ");
INSERT INTO apz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas kako kakoe inomokomoyo aho hufaꞌu hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sohwamo lutɨmanto ulɨmento, Upaꞌnɨmno. Olohonta nakwo Jelusalemneꞌno wosontaneꞌno yɨhwono. Oso hopo sopo yoꞌmayo hungkuno Anɨtu aꞌamumo uyahonɨngki lɨmotofo sohwa ngko oso Hwomu Anɨtu nɨhwosopoꞌmentiso sohwoꞌnneꞌno mtɨꞌmokumentohofoso olohonta ne umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Oso hohosohonta aꞌamu Jutaso hofɨko ngkimo aꞌamu temtitofo kengo sofe ahomo hoꞌnanɨhufitnnefoho. Hofɨko ngkimo sitofo ntɨkuji ngkimo wonyo ntohofɨkuji memijo nɨyatɨꞌmopitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hofɨko ngkimo impojonyo nɨfonjɨkuji wofonjonɨsyantɨfeho. Nofonjonɨsyɨkujoꞌno sɨkuno hufaꞌu sɨhune memjanɨmofɨhwosoꞌno ngko apaꞌno songo wolɨkaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ose ulahonɨngki inomokomoyo sohwa oso hungkuno somneꞌno huno mummentisofoho. Hungkuno hwapɨngo ne soꞌno huno muyahonɨngki hnnɨmentohofi, Olo hungkuno loso fahosɨhwoyo hungkuno konelalofoho. Ose hnnontɨfi hofɨkoe hunoso mehohosusɨhumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas kako ango Jelikou mofonepo iꞌmofɨwahonɨngki hwe tɨmpiꞌnyo sohwo oso honɨngkano momɨngopo humanto aꞌamu mtaꞌni hamniyoho yoꞌmayoso wolomaꞌmo lonto joho humalisofoho. ");
INSERT INTO apz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Osopo humanto upaꞌnɨmentisoso aꞌamu piꞌnɨngo engo ntohumpotopahonɨngkofi upaꞌnonto aꞌamu kakoꞌnjopo solohofamentohofo somo ulɨmento, Hofɨko peho yalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ose ulahonɨngki hofɨko ulɨmentohofi, Jisas ango Nasaletnntaꞌango sohwo kako posalofoho. ");
INSERT INTO apz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ose ulahonɨngkofi kako joho mohmꞌno ulɨmento, Jisas, Ntefitɨye Imu sohwosi, kɨko ngkineꞌno hitoho wakilofono. ");
INSERT INTO apz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ose ulahonɨngki aꞌamu sɨmoꞌmo sapmmentohofoso hofɨko kakimo yoka ulontɨfi ulɨmentohofi, Mampiꞌnyo fosyohumaho. Ose ko ulahonɨngkofi oso huhwo sohwo joho engo lonto apaꞌno ulɨmento, Ntefitɨye Imu sohwosi, ngkineꞌno hitoho wakilofono. ");
INSERT INTO apz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ose ulahonɨngki Jisas kako nolohofaponto hofɨkimo ulɨmento, Oso hwe sohwo ngkiyepono fɨpemotapmno. Ose ulahonɨngki oso hwe tɨmpiꞌnyo huhwo sohumo mofonepo uhwojowahonɨngkofi Jisas ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ngko kikimo pipi ntohofo kinɨngkohoho. Ose ulahonɨngki kako ulɨmento, Hwe Engofo, ngko apaꞌno tɨmo wahonɨmo. ");
INSERT INTO apz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ose ulahonɨngki Jisas ulɨmento, Kɨko tɨmo fohonyo. Kɨko ngkimo sɨmeho hiꞌntnnono ntapohino soꞌno jɨje sɨmeho hiꞌntnnonohinoso wopɨngo kumokohoho. ");
INSERT INTO apz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jisas ose ulahonɨngki hwe huhwo sohwo tɨmo komoꞌno hononto Jisasɨmo inɨngkawento Anɨtumo isamoyoka engo ulɨmentisofoho. Hwe hwoyaꞌmi ose uhwonontɨfi hofɨko hopiꞌnonohinoso Anɨtuye yofe hoꞌnomaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas kako ango Jelikou sopo noswonto nomꞌne ango poneꞌento angkuhwafo ajwo sopo pasɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Hwe fihwo kakoe yofe Sakiyos sohwo humunyoponoho. Kako hwe mnokino engoꞌnjo hamniyoho mayo syohoꞌnjo sohwo hamniyoho engoꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kako Jisasɨmo uhwonɨmo lonto ko imentisoso hwe moyaꞌmi piꞌnɨngo engo hwe tɨfo huhwo sohumo hoholo hoholofo ulohofahonɨngkofi kako Jisasɨmo muhwonyoꞌnjo yonto ");
INSERT INTO apz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","kako aꞌamu piꞌnɨngo homo somo nuyakolofonto hano kunto kuntoꞌno fekwasi lohofonto iyo milontontanyomo kotasonto Jisas olopo pɨhwosoꞌno uhwonɨmo lonto humokehumantisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas oso hopo sopo iꞌmofawento tɨmo yokintahopo uhwonɨngkisoso Sakiyos nohumentanɨngki uhwononto ulɨmento, Sakiyos, kɨko komoꞌno fɨkotape. Ngko olohonta jɨje angomo wohumamonneꞌno yohono. ");
INSERT INTO apz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ose ulahonɨngki Sakiyos kako komoꞌno welɨkofapi lohofonto sɨmonyo yonto Jisasɨmo utɨmanto kakoe angomneꞌno ipemotawomentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hwe moyaꞌmi ose ipemotowahonɨngki uhwonontɨfi sitofo ole mjalɨmɨmentohofi, Olo hwe lohwo kako aꞌamu honɨngkano wonyoꞌnjo lohwoe angomo wofosyawomonteꞌno yohoho. ");
INSERT INTO apz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakiyos kako Jisasɨꞌnjopo lohofonto ulɨmento, Hwe Engofo, kɨko upaꞌnyo. Nje hamniyoho yoꞌmayo hoꞌyango soꞌnji ajwopo hotitohmꞌmo fehohnjo ngko mokosyohumahmꞌmo fehohnjo ngko aꞌamu umofonyo yalokwofo somo uyɨmonnoho. U, ngko aꞌamu fihumo hwasyo hungkuno lutɨmaꞌmentoheꞌmanji olohumo ngko hwasyo hungkuno lutɨmaꞌmentohe soꞌno yoꞌmayoso kakimo osofosofahuꞌno uyɨmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ose ulahonɨngki Jisas ulɨmento, Ose lohino soꞌno nakwo huno ole nayohoho. Olo sɨkuno lomo olo ango loponjo hwe moyaꞌmilofe honɨngkano wonyo somtaꞌni Anɨtu kako hofɨkimo nto isɨhutofomakwoho. Sakiyos huhwo Apɨlohamɨye imu hweho. ");
INSERT INTO apz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aꞌamufe Hwomu sohwoꞌni olo aꞌamu olo paꞌnyo wonyo honɨngkanomo humentanɨngkujo somneꞌno notɨpemahmꞌmo utɨmayoꞌne pmmentohe hwoꞌnyoho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Oso hungkuno hiso nto upoꞌnɨngkahonɨngkofi Jisas kako ango Jelusalem mofonepo uꞌmofapmmonto yahonɨngki aꞌamu hopo soponjoso ole syafɨhuꞌmentohofi, Oso sɨkuno Anɨtu kakoe aꞌamumo yokumpohnꞌnyo mokosyohumayo somo utɨhwaꞌnyopo ujo wehontojwahumonteꞌno yohoho. Ose syafɨhuꞌmentohofo soꞌno Jisas kako pahnnɨmo hungkuno ole ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hwe engo fihwo kako ango ikano fipo uhwosi osopo aꞌamumo mokosyohumayoꞌne yofe engo mahwosi kakoe angopo asomo wapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Oso hwe huhwo sohwo kako ango ikanopo wamonto imentiso sohonta kako kakoe syoho ulohofiyo aho hufaꞌu hopiꞌnonohino sohwamo joho lutɨmanto hamniyoho aho sɨfe hopiꞌnono kina aho sɨfe hopiꞌnono kina huꞌmuyonto ulɨmento, Sekwo olo hamniyoho sejapohe losoꞌnji ngko nomꞌne angopo nohumentanɨꞌmo sekwo nomꞌne hamniyoho engo emafɨkujoso ngko hwangku wopɨhwonɨmo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Oso hwe huhwo sohwoe angoponjo aꞌamu fehohnjoso hofɨko kakineꞌno nakwolaho lontɨfi kako nto womentisopo hwe fihwamo tɨfi inɨngkayoꞌne olo hungkuno motayoꞌne lɨhwatɨmentohofoso olenoho. Olo hwe lohwo nakwoe hwe engo humayoso nakwolaho. ");
INSERT INTO apz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ose ko lɨhwojahonɨngkofi hwe huhwo sohwo yofe engo manto hofɨkimo mokosyohumayoꞌne asomo pmmentisofoho. Asomo noponto kako hamniyoho uyohojohamentiso syoho ulohofiyo sohwamo hamniyoho alale kemaꞌmalofo uhwonɨmo lonto joho lutɨmaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hwe nomꞌnehwo sɨmoꞌmo uꞌmanto ulɨmento, Hwe engofo, oso aho sɨfe hopiꞌnono kina ntapmmentohino somtaꞌni ngko tu hantɨlet (200) kina emaꞌmalefoho. ");
INSERT INTO apz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ose ulahonɨngki hwe engo sohwo ulɨmento, Kɨko syoho nɨmokosyohumayo wopɨngo hwosoho. Kɨko oso syoho kijapmmentohe somo itoꞌno mokosyohumamahnno soꞌno ngko syoho engo wokijapmmo. Kɨko ango aho hufaꞌu hopiꞌnonohino somo mokosyohumaho. ");
INSERT INTO apz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ose ulahonɨngki nomꞌne syoho ulohofiyo osofeponjo sohwo uꞌmanto ulɨmento, Hwe engofo, kɨko oso aho sɨfe hopiꞌnono kina ntapmmentohino somtaꞌni ngko wan hantɨlet (100) kina emaꞌmalefoho. ");
INSERT INTO apz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ose ulahonɨngki hwe engo sohwo ulɨmento, Ngko kikimo ango aho fehohnjo hopiꞌnonohinoso mokosyohumuhnneꞌno syoho wokijapmmo. ");
INSERT INTO apz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ose ulahonɨngki syoho ulohofiyo nomꞌnehwo uꞌmanto ulɨmento, Hwe engofo, oso aho sɨfe hopiꞌnono kina ntapmmentohinoso oloꞌmo weho. Ngko hwapɨfe weꞌe somo fosyofosyonji hiyasoꞌmo hoꞌnahumentohe wojoloꞌnoho. ");
INSERT INTO apz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Hwapɨngoso ngko jɨje yahino soꞌno ngko huno niyohoho. Kɨko hwe yokumpohnꞌnyo hwosoho. Yoꞌmayo nomꞌne aꞌamu hoꞌnasyontɨfeso kɨko mawoꞌnɨngkino hwosoho. Wosopayo nomꞌne aꞌamu mofontɨfeso kɨko ijɨwoꞌnɨngkino. Osoꞌno ngko kikineꞌno iyoho nnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ose ulahonɨngki hwe engo sohwo kako kakoe syoho ulohofiyo sohumo ulɨmento, Kɨko syoho nɨmokosyohumayoso wonyo hwosoho. Kɨko nje yahino soꞌno huno ko kiyahonɨngki kɨko ngkimo itoꞌno mantohoꞌmmahnno soꞌno ngko wonyo hwosoho kilalokweno. Ou, nehopi. Ngko hwe yokumpohnꞌnyo hwoꞌnyoho. Yoꞌmayo aꞌamu hoꞌnasyontɨfeso ngko mawoꞌnɨngkohono. Wosopayo nomꞌnihwa hulontɨfe somtaꞌni ngko ijɨwoꞌnɨngkohono. ");
INSERT INTO apz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kɨko nje yahino soꞌno huno itoꞌno ko kiyahonɨngki kɨko aꞌamu hamniyoho mokosyohumayo sohwafe angomo mohoꞌnanɨsiyoso pehoꞌno imahnnoto. Kɨko osopo nje hamniyohoso hoꞌnasyontentesi ngko asomo pmꞌmo nje hamniyoho somtaꞌni nomꞌne hamniyoho honje iꞌmofaposo soꞌnji nto mahmꞌmnesohilo. ");
INSERT INTO apz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ose ulonto kako nomꞌne aꞌamu kakoꞌnjopo humalohofontohofo sohwamo ulɨmento, Sekwo oso aho sɨfe hopiꞌnono kina olo hwe lohumo uyɨmentoheso nomafɨkuji oso hwe tu hantɨlet (200) kina mokosyohumaso sohumo umasimno.  ");
INSERT INTO apz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ose ulahonɨngki hofɨko ulɨmentohofi, Hwe engofo, kako tu hantɨlet (200) kina hiꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ose ulahonɨngkofi hwe engo sohwo ulɨmento, Nje hungkuno waselɨmonneꞌno yohono. Sekwo itoꞌno upaꞌnɨmno. Aꞌamu yoꞌmayoso itoꞌno mokosyohumawoꞌnɨngkohofo somo ngko yoꞌmayo nomꞌneso uyɨmonnoho. Aꞌamu yoꞌmayoso itoꞌno momokosyohumayoꞌnjo yontoso sohumtaꞌni oso yoꞌmayo weꞌe kako mokosyohumasoso ngko womaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ose ulonto ulɨmento, Nje aꞌamu fehohnjo olo ango loponjoso ngko hofɨkimo umokosyohumayoꞌneso nakwolaho ntontɨfi nje mangohwa imoꞌnalokwofo soꞌno sekwo oso aꞌamu somo nutɨmotapɨkuji nje tɨmo lopo fonjahumno. Jisas oso pahnnɨmo hungkunoso ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas oso hungkunoso moiꞌwo ulonto Jisas Jelusalemne honɨngkano siyo somo kako sɨmoꞌmo nto sɨmentisomo hofɨko tɨfi inɨngkasɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jisas kako oso hwofɨkiꞌnyo Oulifɨno lɨwoꞌnɨngkohofo sopo ango hufaꞌu Mpetɨfaseꞌnji Mpetaniꞌnji mofone sopo nosɨꞌmofonto kakoe inomokomoyo hufaꞌu sohwaꞌumo ole lɨhwatɨmento, ");
INSERT INTO apz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Siko oso ango ne sopo uꞌmofahusɨsi siko oso kuso somo noswohosɨsi tɨmo uhwonisoso ahwomo yahu toungki yokaꞌno hoꞌnawoꞌnyoso impe intoꞌnowentanɨngkuhwosi uhwonanjiyoho. Oso yahu songo imoꞌnɨmasoso aꞌamu mokehumunyofoho. Oso yahu hiso fisɨhutofomotapinyo. ");
INSERT INTO apz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Siko oso yahu hiso isɨhutofomahosɨsoꞌno aꞌamuso ole selɨkujoꞌno siko pehoꞌno isɨhutofomasiyeto. Ose selɨkujoꞌno siko ole ulinyo. Nekwoe Hwe Engo sohwo kako olo yahu lohumneꞌno syoho weho, ose ulinyo. ");
INSERT INTO apz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jisas ose lɨhwojahonɨngki siko nowenji yoꞌmayo Jisas luhwatɨmentisoso tɨpemaꞌmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Siko oso yahu huhwo sohunjo impe itolofontanɨngki oso yahu hofekwosa sohwa uhwonontɨfi ulɨmentohofi, Siko peho uyanjiyoꞌno itolofalokusiyo. ");
INSERT INTO apz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ose ulahonɨngkofi siko ulɨmentisiyo, Nakwoe Hwe Engo kako olo yahu lohuno syoho weho. ");
INSERT INTO apz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ose ulonji siko oso yahu huhwo sohwoꞌnji Jisasɨyepono motasɨmentisiyefoho. Siko sikoe manjiꞌmofoso yahufe hohujopo pojisyosyahonɨngki Jisas oso hopo sopo kehumamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Noposokehumawento nowentanɨngki hwe moyaꞌmi hofɨkoe hwapɨfe Jisas kako hano wene honɨngkano sopo Jisasɨye yofe hoꞌnomayoꞌne huꞌmeehumentohofofoho. Osopo Jisas kehumentanjo yahu sohwo hwotoho mjahmmɨwomentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jisas kako hwofɨkiꞌnyo Oulif Jelusalem mofone sopo iꞌmofaponto oso honɨngkano monje we sopo hwe moyaꞌmi hofɨko Jisasɨmo inomokohoꞌnawoꞌmentohofoso yoꞌmayo syoho wonyoangkafo Jisas imojo soꞌno syafɨsyontɨfi hofɨko sɨmonyo yontɨfi mango engo lontɨfi Anɨtuye yofe hoꞌnomaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mango mohmꞌno ole lɨmentohofi, Olo Hwe lohwo nakumo nemokosyohumayoꞌne Anɨtuye yokumpohnꞌnyoꞌnji palokuso lohwoe yofe wohoꞌnomano. Anɨtu kako nakwo hwahoponjo hwe moyaꞌmi hnꞌnneꞌno sɨmeho wopɨngo nejahopohoho. Anɨtu yokintahopo humaso sohuneꞌno yofe engo wohoꞌnomano. ");
INSERT INTO apz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ose lontanɨngkofi aꞌamu Falisi fehohnjo sohwa hwe moyaꞌmi piꞌnɨngoꞌnjo sopo lohofontɨfi Jisasɨmo ulɨmentohofi, Nakwoe Lonetɨhwayo sohwosi, oso hwe moyaꞌmi kikimo inomokohoꞌnakuwotofo somo kɨko yoka uso. ");
INSERT INTO apz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo upaꞌnɨmno. Hungkuno waselɨmonneꞌno yohono. Olo aꞌamulo hofɨko mampiꞌnyo humantɨfijontentesi olo honɨngkano loponjo sojolo mango engo lɨkuji nje yofe hoꞌnonɨmafɨkutnnesohilo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas kako Jelusalem uꞌmofawento pone hopo sopo kako uhwononto humotaho lɨmentisoso ");
INSERT INTO apz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ole lɨmento, Aꞌamu Jelusalemmjo soku, sekumo itoꞌno esehumajiyoꞌne yahinoso ko seꞌmahonɨngki sekwo hohujo ikinjaofalokwofo. Osoꞌno yahino wopɨngo hiso hiyasoꞌmo wentanɨngkuhwosi sekwo motɨpɨhwonɨfitnnehofo. ");
INSERT INTO apz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sekwo upaꞌnɨmno. Hwangku sɨkuno nomꞌne iꞌmofaposo somo sekwoe mango sohwa sekumo wosefonjano lɨkuji sekikitofɨkuji mekuꞌmofasi lohofɨkuji hofɨko tojopo koꞌmokwasokuji nolɨkofaofɨkuji ");
INSERT INTO apz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","sekwoe ango fonjowonampekuji sekwo sekwoe mehomi hiꞌnji hokunonji nɨhuꞌnahone poyo moiꞌwo imoꞌnɨfitnnefoho. Sekwoe sokango soꞌnji sokilojo soꞌnji weꞌe huhwo kihnꞌnaweso mokihnꞌnawenefoho. Hwapɨngoso oso sɨkuno Anɨtu sefoꞌmayoꞌne seꞌmaꞌmaso sohonta sekwo yofe mɨhwofeꞌnjo imalofo kuyoho. ");
INSERT INTO apz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas kako Anɨtuye tajo ango engo somo noswonto aꞌamu hoꞌyango yoꞌmayoso huꞌmeesyontɨfi hamniyoho mentanɨngkofo somo wae yaofo syohoso emaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kako hofɨkimo ole ulɨmento, Aꞌamu Anɨtuye hungkuno mtɨꞌmokumentohofo sohwa ole mtɨꞌmokumentohofi, Olo nje ango loso Mpohumo jomo ujoꞌne angofoho. I osoꞌno nje ango loso sekwo aꞌamu hamniyoho hiyasoꞌmo hufo mawoꞌnɨngkohofo sohwafe ango hopa imokalokwofo. Ose mtɨꞌmokumentohofofoho ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ose imoꞌnɨmentiso soꞌno sɨkuno huhwo huhwi Jisas kako hwe moyaꞌmimo Anɨtuye tajo ango engo somo kakoe hungkuno lutɨhwamojofoho. Aꞌamu tajo ango syohoꞌnjo yofe engoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji aꞌamu Jutafe hwe engo sohwanji hofɨko Jisasɨmo fonjasiyoꞌne honɨngkano wotɨpemantɨfeꞌno imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ose ko yahonɨngkofi hwe moyaꞌmi hofɨko Jisasɨye hungkunomo upoꞌnano mjalɨmumentohofo soꞌno hwe engo sohwa hofɨko Jisasɨmo fonjasiyoꞌne honɨngkanoso motɨpemaꞌmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sɨkuno fihumo Jisas kako Anɨtuye tajo ango engo somo nohumanto hwe moyaꞌmi somo kako Anɨtumo uꞌmayo yahino soꞌno hungkuno lutɨhwamentisofoho. Aꞌamu tajo ango syohoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamentohofo hunoꞌnjo sohwanji aꞌamu Jutafe hwe engo sohwanji hofɨko Jisasɨmo uꞌmaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Uꞌmantɨfi ulɨmentohofi, Olo soꞌno fonaso. Kɨko olo syoho iwoꞌnɨngkino loso tɨhwo kilɨmasoꞌno iwoꞌnɨngkinoto. Yokumpohnꞌnyoso tɨhwo kijapmmasoꞌnji iwoꞌnɨngkinoto. ");
INSERT INTO apz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ose ulahonɨngkofi Jisas ulɨmento, Ngko huhwoꞌni hungkuno angaꞌno waselohonɨmonneꞌno yohono. Sekwo olo soꞌno ngkimo ntohonɨngkofo soꞌno ngko sekumo waselɨmonneꞌno yohono. ");
INSERT INTO apz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Joun kako aꞌamumo mijo kiyomaꞌmojo yokumpohnꞌnyoso Anɨtu mtaꞌango maꞌmentisotaho. Hwahoponjo aꞌamu mtaꞌango maꞌmentisotaho. ");
INSERT INTO apz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hofɨko ose upaꞌnontɨfi ole hnnɨmentohofi, Joun kakoe yokumpohnꞌnyo Anɨtu mtaꞌni maꞌmentisofoho ulasoꞌmanji ole wonalɨmontonoho. Oseꞌmanji sekwo Jounɨye hungkunomo sɨmeho hiꞌntnnono muyoꞌnjo pehoꞌneto. ");
INSERT INTO apz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","I Joun kakoe yokumpohnꞌnyo hwahoponjo aꞌamu mtaꞌni maꞌmentisofoho ulasoꞌmanji hwe moyaꞌmi upaꞌnɨngkuji hofɨko sojo wonefonjantɨfeho. Hwapɨngoso aꞌamu loso hofɨko huno ole syofɨsyalokwofo, Anɨtu kako Jounɨmo hungkuno uyahonɨngki nalɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ose hnnontɨfi Jisasɨmo ole ulɨmentohofi, Nakwo huno monayofoho. Joun kako aꞌamumo mijo kiyomaꞌmojo yokumpohnꞌnyoso ntɨꞌmtoꞌangotɨkeno. ");
INSERT INTO apz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ose ulahonɨngkofi Jisas ulɨmento, Oseꞌmanji ngko huhwoꞌni nje yokumpohnꞌnyo yoꞌmayo iwoꞌnɨngkohe hwapɨngo soꞌno maselɨmnehono. ");
INSERT INTO apz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ose ulonto kako olo pahnnɨmo hungkuno oso aꞌamu homo somo ulɨmento, Hwe fihwo kako ipisayo syoho hulɨmentisofoho. Oso syoho homo somo mokosyohumayoꞌne kako aꞌamu hamniyoho syoho emawoꞌnɨngkohofo sohwafe ahomo hoꞌnasyonto kako ango ikanopo nowento osopo kako neꞌno humamojofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Osopo nohumanto oso syoho homo somjo ipisayo mayoꞌne sɨkuno iꞌmofape somo kako kakoe syoho ulohofiyo fihumo ipisayo fehohnjo mayoꞌneꞌento kako oso aꞌamu kakoe syoho mokosyohumayo sohwamo uꞌmahwosi ipisayo mayoꞌne lɨhwatɨmentisofoho. Oso aꞌamu syoho mokosyohumayo sohwa syoho ulohofiyo huhwo sohumo ikujoho fonjontɨfi ipisayo muyoꞌnjo yontɨfi wae yaoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Osohonta kakwoꞌyohwo sohwo kako nomꞌne syoho ulohofiyo fihumo lɨhwatɨmentisofoho. Osohumo hofɨko ikujoho fonjontɨfi yahino wonyo umtɨꞌmokontɨfi ipisayo muyoꞌnjo yontɨfi wae yaoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kakwoꞌyohwo kako syoho ulohofiyo hufaꞌu sɨhune sohumo lɨhwojahonɨngki kako nowento aꞌamuꞌnjopo iꞌmofowahonɨngki hofɨko osohumo ikujoho wonyo fonjimokontɨfi mempo hohntaꞌni swohoꞌnofapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Oseso syoho kakwoꞌyohwo sohwo ole hnnɨmento, Ngko pipi imnehono. Ngko nje hwomu lohuno ngko sɨmeho uyalokwe lohumo luhwatɨmeso hofɨko kakoe hungkunomo haloho upeentɨfetɨkeno. Ose syafɨsyonto hwomu huhwo sohumo lɨhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aꞌamu syoho homo somo mokosyohumayo sohwa hwomu huhwo sohumo uhwonɨtumantɨfi ole hnnɨmentohofi, Oso hwe sohwo kako hwangku sohonta kanɨngkwohwoe yoꞌmayoso nomane hweho. Komoꞌnohino, nakwo kakimo poyo wofonjosyano. Ose fonjosyɨhwasi nakwo kakoe syohoso nɨhuꞌnahone womantanoho. ");
INSERT INTO apz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ose hnnontɨfi hofɨko hwomu huhwo sohumo nokentɨfi mempo hohntaꞌni ipisayo syoho sopo swohoꞌnaofontɨfi osopo poyo nɨhuꞌnahone fonjahumentohofofoho. Jisas ose ulonto kako aꞌamu homo somo ulohonɨmento, Ose imentohofo soꞌno ipisayo syoho kakwoꞌyohwo sohwo aꞌamu wonyo huhwo sohwamo pipi ulohoꞌmontolo. ");
INSERT INTO apz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hwangku kako nopɨhwosi oso aꞌamu wonyo sohwamo nofonjasyɨhwosi kako nomꞌne aꞌamu sohwamo syoho hiso mokosyohumayoꞌne uyɨmontonoho. Jisas ose ulahonɨngki aꞌamuso upaꞌnontɨfi ulɨmentohofi, U, kako oso hwolaho. ");
INSERT INTO apz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ose ulahonɨngkofi Jisas hofɨkimo tɨmo uhwononto ulɨmento, Olo Anɨtuye hungkuno iyoswomo mtɨꞌmokumentohofo loso hwapɨngo neso huno pipi seyohoho. Olo sojo engkwosaho paꞌnyo aꞌamu ango injuwoꞌnɨngkohofo sohwa wae yaoꞌmentohofo loso olohontajo engkwosaho loso angomo sosofitofoꞌne hwapɨngohwo imoꞌnɨngkohoho. Ose mtɨꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nomꞌnepo Anɨtuye hungkuno mtɨꞌmokumentohofoso olenoho. Aꞌamu hopiꞌnono oso sojo engkwosaho paꞌnyo homo somo entofomafɨkuji pɨwahupijoso hofɨko hofɨkoe aꞌapaho kempi mtɨꞌmtɨꞌme lohofɨhwosi wohuꞌmehinawoꞌmontonoho. I osoꞌno oso engkwosaho huhwo sohwo kako aꞌamu fihwoe aꞌapahopo pɨwasyososo fonjomtɨhupeeofososo oso hwe huhwo sohwo kakoe aꞌapahoso hintalinyo paꞌnɨngo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisas oso pahnnɨmo hungkuno ulahonɨngki aꞌamu honɨngkano hungkuno lutɨhwawoꞌnɨngkohofo hunoꞌnjo sohwanji aꞌamu tajo ango syohoꞌnjo yofe engoꞌnjo sohwanji hofɨko huno ole uyɨmento, Jisas oso pahnnɨmo hungkuno nakumneꞌno lohoho. Nakwoe sɨmeho moꞌmo me hopa nafeꞌno nalohoho. Huno ose syafɨsyontɨfi oso hohosohonta hofɨko Jisasɨmo aho kehwasi wofonjosyano lontɨfi imentohofoso hofɨko hwe moyaꞌmi somneꞌno iyoho unɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Oseso hofɨko Jisasɨmo fonjasiyoꞌneꞌentɨfi honɨngkano wotɨpemano lontɨfi Jisasɨmo humuhwontohumantohofofoho. Hofɨko Jisasɨyepono aꞌamu fehohnjo sohwamo luhwojahonɨngkofi oso aꞌamu sohwa hofɨko aꞌamu Jisasɨye hungkunomo wopɨngo hwofoho wonalono lontɨfe hwasyo humupoꞌnontohumantohofofoho. Ose ko imoꞌnontɨfi hofɨko pojiyontɨfi hofɨko Jisasɨye hungkunomo yamofo ulohoꞌmentohofofoho. Ole hnnɨmentohofi, Jisas kako aꞌamu hwaho mokosyohumayo huhwo sohwamneꞌno hungkuno wonyo losoꞌmanji nakwo aho kehwasi oso aꞌamu hwaho mokosyohumayo sohwafe ahopo nohoꞌnosyɨhwasoꞌno hofɨko Jisasɨmo tohino uyantɨfeho. Ose hnnontɨfi Jisasɨmo humuhwontohumantohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Oseso hofɨko Jisasɨmo ole ulohonɨmentohofi, Nakwoe Lonetɨhwayo sohwosi, nakwo huno nayohoho. Kɨko hwe moyaꞌmimo Anɨtuye yahino soꞌno hungkuno lutɨhwawoꞌnɨngkinoso nehopiꞌnohini lutɨhwawoꞌnɨngkino hwosoho. Kɨko aꞌamu yofe engoꞌnjo sohwamneꞌno iyoho makinyoꞌnjo hwosoho. Nakwo hopiꞌnonohinoso afaponohinoho. Hungkuno itoꞌnohino lɨwoꞌnɨngkino hwosoho. ");
INSERT INTO apz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Oseso nakwo olo soꞌno wakilohonantaneꞌno yɨhwono. Kɨko huno pipi kiyohoho. Nakwo hwe engo Sisa sohuneꞌno hamniyoho wohoꞌnosyano lakinɨngkohoho. Mohoꞌnasiyoꞌnjo uyano lakinɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ose ulahonɨngkofi Jisas kako hofɨko poji yamofo ulohofano lontɨfi imentohofo soꞌno hwasyo yahino soꞌno huno uyahonɨngki ole ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Hamniyoho angaꞌno ntɨhwaho. Olo hamniyoho losomjo huyoꞌmango soꞌnji yofe soꞌnji tɨhwoeto. Ose ulahonɨngki ulɨmentohofi, Sisafefoho. ");
INSERT INTO apz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ose ulahonɨngkofi Jisas ulɨmento, Eꞌwano. Sisafe yoꞌmayo soꞌmanji Sisamo uyɨmno. I Anɨtuye yoꞌmayo soꞌmanji Anɨtumo uyɨmno. ");
INSERT INTO apz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jisas ose ulahonɨngki aꞌamu huhwo sohwa hungkuno wopɨngo somneꞌno hofɨkoe sɨmeho moꞌmo pisopisaho lontɨfi mampiꞌnyo humamentohofofoho. Oseso oso aꞌamu hofɨkimo lɨhwatɨmentohofo sohwa hofɨko Jisasɨye hungkuno somneꞌno hungkuno itoꞌno mɨhwajiyoꞌne hwe moyaꞌmife tɨmopo makekutnnesohilo. ");
INSERT INTO apz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Aꞌamu Satɨyusi fehohnjo sohwa Jisasɨmo uꞌmaꞌmentohofofoho. Aꞌamu Satɨyusi huhwo sohwa hofɨko huno ole uyɨwoꞌnɨngkohi, Aꞌamu poyo peꞌnyo sohwa hofɨko nɨhuꞌnahone peꞌnɨwoꞌnɨngkohofo. Apaꞌno songo molɨkafeꞌnefoho. Ose syafɨsyɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Hofɨko Jisasɨmo uꞌmantɨfi ole ulohonɨmentohofi, Nakwoe Lonetɨhwayo hwosi, Mouses nakumneꞌno hungkuno ole motɨꞌmokumentono. Hwe fihwo kako ape nomahwosi kako mehomi motɨpemayoꞌnjo sohwo poyo peꞌnɨngkuhwosoꞌno oso ape hisimo konɨngkwaꞌwehwo nomahwosi kolaꞌwehumneꞌno mehomi wotɨpemano. Mouses ose mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oseso hwe aho fehohnjo hopiꞌnono nomꞌni mtaꞌni hufaꞌu sohwa humamotofofoho. Tisɨmaso sohwo kako ape manto mehomi motɨpemaso sohwo poyo peꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Oseso konɨngkwaꞌwehwo akuꞌmu sohwo oso ape hisimo maꞌmentisoso kako huhwo mehomi aneꞌnjo peꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Oseso oso ape hisimo hinjo huhwa oseꞌnohini maꞌmentohofoso mehomi ane peꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hwangku oso ape hisi poyo peꞌnɨmentono. ");
INSERT INTO apz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Oseso aꞌamu poyo peꞌnyo sohwa lɨkapijo sohonta tɨhwoe ape umoꞌnɨmontolo. Hofɨkoꞌnɨkwehwa aho fehohnjo hopiꞌnono nomꞌne mtaꞌni hufaꞌuyo sohwa ape hisimo nto maꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Hwe moyaꞌmi olohonta humalofoso hofɨko ape maꞌnɨwoꞌnɨngkohofo. ");
INSERT INTO apz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","I osoꞌno oso hwe moyaꞌmi poyo peꞌnɨfijoso apaꞌno songo lɨkapijo hopaso apaꞌno lɨkafɨkuji songo neꞌnohino humafijo sohonta hofɨko apaꞌno ape momaꞌnɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Hofɨko aꞌamu ahwomomjo paꞌnyo nohumafɨkuji apaꞌno poyo mapeꞌnɨfitnnehofo. Anɨtu hofɨkimo poyo peꞌnyo somtaꞌni ulɨkafoso soꞌno hofɨko kakoe mehomi umoꞌnantɨfeho. ");
INSERT INTO apz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mouses huhwo kako aꞌamu poyo peꞌnyo sohwa apaꞌno songo lɨkafoso soꞌne huno nafohotoꞌmentisofoho. Mouses kako oso iyo weꞌe toho ko nɨmentisoso yofoho miyo lohoꞌnnyo somo uhwononto ulɨmento, Hwe Engo hwofiloꞌnnyo ne sohwo kako Apɨlohamɨye Anɨtuyoho. Kako Aisakɨye Anɨtuyoho. Kako Jekoupɨye Anɨtuyoho. ");
INSERT INTO apz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ihwoni. Mouses kako ole syafɨhuꞌmento, Apɨlohamja Aisakɨja Jekoupɨja hofɨko hohonta poyo ko peꞌnɨmentohofo sohwa songo humalofo soꞌno syafɨsyonto oso hungkuno hiso lɨmentisofoho. Anɨtu kako poyo peꞌnyo sofe Anɨtu hwoꞌmaho. Oꞌo, songo humalofo sofe Anɨtuyoho. Anɨtu kakoe tɨmopo aꞌamu hopiꞌnonohinoso songo humalofo. ");
INSERT INTO apz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jisas ose ulahonɨngki aꞌamu fehohnjo honɨngkano hungkuno lɨwoꞌnɨngkohofo hunoꞌnjo sohwa Jisasɨmo ulɨmentohofi, Nakwoe Lonetɨhwayo sohwosi, hungkuno wopɨngo nalohino. ");
INSERT INTO apz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ose ulontɨfi hofɨko nomꞌne hungkuno Jisasɨmo ulohonyo soꞌno iyoho imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisas aꞌamu Falisi sohwamo ulɨmento, Aꞌamu ole lɨwoꞌnɨngkohofo Kɨlais kako oso aꞌamu Anɨtu nakwoe hwahopo uhwatɨꞌmentiso sohwo Ntefit hwe yofe engoꞌnjo hohonta hwaho mokosyohumamojo sohwoe imu hweho. Oseso pipi lɨwoꞌnɨngkohofo. ");
INSERT INTO apz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Oso Taꞌnjo Iyoswo somo Ntefit ole lɨmento, Anɨtu kako nje Hwe Engo Kɨlais, Anɨtu nakwoe hwahopo uhwatɨꞌmentiso sohumo ole ulɨmento, Kɨko nje aho anga sohohntaꞌni fosyohumaho. ");
INSERT INTO apz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Osopo kɨko nohumahoji ngko jɨje mango sohwamo jɨje sɨfɨkiꞌnyoꞌmo enjwaꞌmo wakuhumotɨꞌmonnoho. Ntefit ose lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Oseso Ntefit kako oso hwe Anɨtu nakwoe hwahopo uhwatɨꞌmentiso Kɨlais sohuneꞌno nje Hwe Engo hweho lɨmentiso soꞌno Kɨlais sohwo kako Ntefitɨye imuhwo imoꞌnyoso pipilo. ");
INSERT INTO apz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Hwe moyaꞌmi hopiꞌnonohinoso hofɨko Jisasɨye hungkuno upaꞌnontɨfi nohumentanɨngkofi Jisas kakoe inomokomoyo sohwamo ole ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Sekwo aꞌamu honɨngkano hungkuno lutɨhwawoꞌnɨngkohofo hunoꞌnjo sohwafe yahino somneꞌno iꞌwaho itoꞌno fiyɨmno. Hofɨko hofɨkoe yofe engo somneꞌno hwapɨfe sawemo yontɨfi honɨngkanopo emoyɨwoꞌnɨngkohofofoho. Osopo emoyontanɨngkofi hwe moyaꞌmi hofɨkimo uhwonontɨfi nakwoe hwe engo hwasoho ulɨwoꞌnɨngkohofo soꞌno umoꞌnɨwoꞌnɨngkisofoho. Osoꞌnji hofɨko tajo ango somo aꞌamufe sɨmanopo humayoꞌno umoꞌnɨwoꞌnɨngkisofoho. Osoꞌnji hofɨko aꞌamu wopayo engo iloho yano sohonta epohumayo sɨmoꞌmjo soꞌno umoꞌnɨwoꞌnɨngkiso hwafoho. ");
INSERT INTO apz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Hofɨko Anɨtumo hungkuno sawemo engo jomo ko ulontɨfi hofɨko apɨwojo sofafe ango yoꞌmayo soꞌno wosemokosyohumano poji ulontɨfi ango hiso hofɨkoꞌne nɨhuꞌnahone emawoꞌnɨngkohofɨhwafoho. Hwangku oso hwe huhwo sohwo tohino engo notɨpemapitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas kako Anɨtuye tajo ango engo somo neꞌno nohumanto tɨmo uhwonɨmentisoso hwe moyaꞌmi hamniyoho engoꞌnjoso hofɨko Anɨtumneꞌno hamniyoho hoꞌnasiyo ipofo soꞌmo hoꞌnosyontanɨngkofi uhwonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Osopo uhwonɨmentisoso apɨwojosi hoꞌyango anesi kako Anɨtuneꞌno touya hufaꞌuꞌnohino hoꞌnosyahonɨngki uhwononto ");
INSERT INTO apz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jisas kako aꞌamu kakoꞌnjopo lohofo somo ole ulɨmento, Hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Sekwo upaꞌnɨmno. Olo apɨwojo losi kako hamniyoho hoꞌnasiyoso nomꞌne aꞌamu hoꞌnasyohofo somo kakoe weꞌeso uyakolokwoho. ");
INSERT INTO apz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nomꞌne aꞌamu hamniyoho hoꞌnosyalokwofoso hofɨko hamniyoho engo mokosyohumunyofoho. Osoꞌno hofɨko oso hamniyoho engo somtaꞌni Anɨtumneꞌno weꞌeꞌnohini hoꞌnosyalokwofo. Olo apɨwojo losi kako hamniyohomo yoꞌmayo soꞌno nɨhuꞌno umofonyo inyosi kako hamniyoho mokosyohumunyosi hopiꞌnonohino Anɨtumneꞌno hoꞌnasyohoho. Kako nomꞌne hamniyoho wosopayo mpe-eꞌne aniyoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aꞌamu fehohnjoso hofɨko tajo ango engo somneꞌno ole lɨmentohofi, Olo tajo ango engo somjo sojo wonyoangkafoso hofiyofoho. Hwe moyaꞌmi hofɨko wokoso wonyoangkafo loso Anɨtuye yofe hoꞌnomayoꞌne yahumentohofo somo uhwonontɨfi pisopisaho lɨmentohofofoho. Ose lahonɨngkofi Jisas ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Hwangku olo yoꞌmayo wopɨngo uhwonalokwofo loso wonyo umoꞌnɨmontonoho. Sojo angaꞌnohinoso nomꞌnepo kihnꞌnawesoso awonoho. Oꞌo, hofɨko olo ango wopɨngo losomo mtɨhupekuji womehuꞌmmokwojantɨfeho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hofɨko Jisasɨmo ole ulohonɨmentohofi, Nakwoe Lonetɨhwayo sohwosi, oso yoꞌmayo hungkuno nalohinoso ntohonta umoꞌnɨmontolo. Sɨmoꞌmo peho iꞌmofapɨhwosoꞌno huno wonayɨmontolo. Oso yoꞌmayoso iꞌmofape-eꞌne sɨkunoso weꞌeneponoho eso. Fonaso. ");
INSERT INTO apz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ose ulahonɨngkofi Jisas ulɨmento, Aꞌamu sekumo hwasyo hungkuno sejo soꞌno sekwo iꞌwaho itoꞌno fiyɨmno. Aꞌamu piꞌnɨngo engo iꞌmofapɨkuji, hofɨko nje yofe ntɨkuji ole selɨfitnnefoho. Ngko Kɨlais hwoꞌnyoho. Anɨtuye sɨkuno mofonepo nto iꞌmofapohoho. Ose selɨkujoꞌno sekwo hofɨkoe hungkunomo inɨngkakutoho. ");
INSERT INTO apz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hwangku aꞌamu hwaho kengoponjo sohwa hofɨko nomꞌne hwahoponjo sohwanji ikujoho fongkiꞌnyoꞌne soꞌnji aꞌamu hwaho afaponjo sohwa ikujoho fongkiꞌnyoꞌne soꞌntnneꞌno upaꞌnɨngkuji sekwo yomo ikutoho. Oso yoꞌmayoso sɨmoꞌmo iꞌmofapɨhwosoꞌno sɨkuno aeꞌuyo imoꞌnyoso komoꞌno mmoꞌnonehoho. ");
INSERT INTO apz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ose ulonto ulɨmento, Hwangku aꞌamu temtitofo kengo sohwanji temtitofo nomꞌne sohwanji hofɨko ikujoho fongkiꞌnɨfitnnefoho. I aꞌamu hwaho kengopontaꞌango sohwa nomꞌne hwaho kengoponjo sohwanji ikujoho fongkiꞌnɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hwangku hwaho lopo hwomɨhwo mɨkunɨmposo piꞌnɨngo engo iꞌmofaponefoho. Hwaho kengo kengo sopo mijoho engo iꞌmofapɨhwosi mnokino engo wotɨpemantɨfeho. Ahwomo sopo yoꞌmayo wonyo imoꞌnɨngkuhwosi nomꞌne yoꞌmayoso ahwomo sopo iꞌmofapɨhwosoꞌno uhwonɨngkuji sekwo iyoho senonefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Oso yoꞌmayo noselohe sɨkuno somo mꞌmofopontanɨngkuhwoso sohonta sekwo nje yofe ulɨkujoꞌno hofɨko sekumo aho sekekuji wonyo selohopitnnefoho. Hofɨko tajo ango somo mesehumajɨkuji hungkuno mjaselɨkuji impoꞌangomo mintofasehufitnnefoho. Hofɨko nje yofe monje yasiyoꞌne aꞌamu hwaho mokosyohumayo yofe engoꞌnjo sohwafe sɨmanopono ipesemotawofitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Oso nje yofe monje yasiyoꞌne ko selohofahonɨngkuji sekwo hwe engo sohwafe sɨmanopo lohofɨkuji ngko aꞌamu wonyo honɨngkano somtaꞌni isɨhutofomayoꞌne pmmentohe sohwoꞌniye hungkuno sekwo ulɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Oso hohosohonta oso hungkuno hofɨko mjaselɨkujoꞌno sekwo aku hungkuno ulɨfitnne soꞌno huno piꞌnɨngo seyɨhwoloho. ");
INSERT INTO apz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Oꞌo, ngkoꞌnohini sekwoe mangomo sekwoe hunomo hungkuno wopɨngo wosejapmmonnefoho. Oso hungkuno sejapmme homo somo sekwoe mango sohwa hofɨko nohnnajɨkuji sekwoe hungkunomo monje maselohopitnnehofo. ");
INSERT INTO apz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Sekwoe aꞌamu soꞌnji selosenɨngkwejamo nje yofe ulɨkujoꞌno hofɨko sekwoe mango sohwafe ahopo mosehumojɨpitnnefoho. Aꞌamu fehohnjo sekwoꞌnjo hohntaꞌni humalofo somo poyo semokufitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Oseso hwe moyaꞌmi hopiꞌnono sekumneꞌno sɨmeho tohino mɨkunɨmposo umnonefoho. Hwapɨngoso nje yofeso sekumo weho. ");
INSERT INTO apz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Oso hohosohonta ngko hofiyo semokosyohumameso sekwoe mnokino mtaꞌni mijiyo angaꞌnohino fihwo yofomahwosi moiꞌwo mmoꞌnonefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yoꞌmayo tangoso seꞌmahwosoꞌno sekwo ngkineꞌno yokumpohnꞌnyo neꞌno lohopijoso sekwo songo neꞌno humayoꞌne neso notɨpemapitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Aꞌamu ikujohoꞌnjo sohwa hofɨko ango Jelusalem sopo hofoyo syukujoꞌno sekwo uhwonɨngkuji huno ole seyonefoho. Ango Jelusalem wonyo imoꞌnyoꞌne sɨkunoso mofone nto imoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Oso hohosohonta aꞌamu hwaho Jutiya sopo humunyoso hofɨko hwofɨkiꞌnyopono hiyaso komoꞌno sɨfitnnefoho. Aꞌamu ango Jelusalem ne sopo humalofo soku sekwo nulɨkoꞌmafɨkuji kengopono kuntoꞌno ufitnnefoho. Aꞌamu ango Jelusalem mempo hohntaꞌni humafijoso hofɨko apaꞌno ango ne montɨmo mahufitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Oso sɨkuno somo aꞌamufe honɨngkano wonyo somneꞌno Anɨtu kako tohino uyone sɨkunofoho. Anɨtuye hungkuno aꞌamu oso hisoꞌno mtɨꞌmokumentohofoso oso sɨkuno somo ne imoꞌnonefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Oso sɨkuno somo moyaꞌmi sɨmehoꞌnjo sofanji mehomi weꞌe amno unyo sofantnneꞌno ngko hitoho ntokwoho. Hwapɨngoso oso sɨkuno homo somo olo hwaho lopo tango mɨkunɨmposo iꞌmofapɨhwosi Anɨtuye sɨmeho tohinoso oso hwe moyaꞌmi somo uꞌmanefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aꞌamu fehohnjo hwakuhwajoꞌnji poyo imokuhwosi aꞌamu fehohnjo somo hofɨkoe mangohwa impe intofomotakuji ango kengo kengopo uhumajonefoho. Aꞌamu Anɨtumneꞌno nakwolaho lalokwofoso hofɨko ango Jelusalem somo hwotoho fɨfitnnefoho. Hofɨko hwotoho neꞌno fentanɨngkuji hofɨkoe sɨkuno moiꞌwo imoꞌnonefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jisas ose ulonto ole ulɨmento, Sekwo ahwomomo uhwonɨfijoso mofehiꞌnyo hamno hntokwaliyo sohwamo yoꞌmayo kengo kengo iꞌmofapɨhwasoꞌno uhwonɨfitnnefoho. Olo hwaho lopo mijo ayo engoso yoka engo hoꞌnɨngkuhwosi mtɨhupo mtɨhupe lohofahonɨngkuhwosi aꞌamu hwaho hoꞌmo hoꞌmtoꞌango oso hiso uhwonɨngkuji hofɨko iyoho mɨkunɨmposo unonefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hwe moyaꞌmi piꞌnɨngo engoso hofɨko olo hwaho lopo yoꞌmayo imoꞌnone soꞌno huno syafɨsyɨkuji hofɨkoe sɨmeho moꞌmo iyoho mɨkunɨmposo ehumanɨngkuji tɨmo hwafɨhwafe mokomayonefoho. Yoꞌmayo ahwomomjo hntokwaliyo yomo yomo yahonɨngkuhwosi uhwonɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Oso hiso iꞌmofopahonɨngkuhwosi Aꞌamufe Hwomu sohwo kako himopo kakoe yokumpohnꞌnyo engoꞌnji kako pomponaho engoꞌnji noponefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hwangku oso yoꞌmayoso iꞌmofape-eꞌne mofone imoꞌnɨngkuhwosoꞌno osohonta sekwo lɨkafɨkuji sekwo sekwoe mnokino lɨkojwamo lohofɨkuji ahwomomo uhwonɨmno. Sekwo honɨngkano wonyo somtaꞌni isɨhutofosemayo sohwo asomo setɨmayoꞌne sohwo mofoneponoho. ");
INSERT INTO apz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ose ulonto Jisas kako olo pahnnɨmo hungkuno ulɨmento Sekwo iyo mijisiyo somo uhwonɨmno. ");
INSERT INTO apz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Iyoswo songo inɨngkiso loso uhwonɨngkuji ifoyo wahuꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Oseso oso paꞌnyoso yoꞌmayo somneꞌno selohe somo uhwonɨngkuji sekwo huno ole waseyono. Oso sɨkuno Anɨtu kako yoꞌmayo somo yokumpohnꞌnyo mokosyohumayoꞌne sɨkunoso mofonepo nto iꞌmofapohoho. ");
INSERT INTO apz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Hungkuno nehopi waselɨmonneꞌno yohono. Hwe moyaꞌmi olo hwaho lopo neꞌno nohumentanɨngkuji yoꞌmayo hiso imoꞌnonefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ahwomoꞌnji hwahoꞌnji moiꞌwo imoꞌnoso sohonta nje hungkunoso moiꞌwo mmoꞌnonefoho. Neꞌno nowentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","I osoꞌno sekwo itoꞌno fohontohumamno. Sekwo yoꞌmayo hwahoponjo soꞌno huno piꞌnɨngo syafɨsyɨkutoho. Sekwo wosopayo engo nɨngkuji mijo yokumpohnꞌnyo nɨngkuji nonilohofɨkutoho. Oꞌo, ngkineꞌno huno fisyafɨsyɨkuno. Sekwo siki humayoso wopɨngoꞌmaho. Oꞌo, sekwo oso paꞌnyo humafijoꞌmanji nje sɨkuno engo asomo pe-eꞌneso me tongo somneꞌno hmnɨwoꞌnɨngkiso hopaso wosemaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Oso sɨkuno iꞌmofapeso hwe moyaꞌmi hopiꞌnono angoꞌmeemjo humalowotofo somo iꞌmofaponefoho. ");
INSERT INTO apz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Sɨkuno engolopohamo sekwo neꞌno fohontohumantokuno. Sekwo Anɨtumneꞌno yokumpohnꞌnyo sejaponeꞌno jomo engolopohamo ulɨkuno. Sekwo ose ifijoꞌmanji yoꞌmayo tango iꞌmofaposo somo uyakolofɨkuji Aꞌamufe Hwomu sohwoe sɨmanopo lohopitnnefoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sɨkuno huhwo huhwi Jisas kako Anɨtuye tajo ango engo somo hwe moyaꞌmimo Anɨtuye hungkuno lutɨhwamojofoho. Oseso sɨkwoꞌmiyomo kako oso hwofɨkiꞌnyo Oulif lɨwoꞌnɨngkohofo sopo saho fosyawoꞌmojofoho. ");
INSERT INTO apz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hwe moyaꞌmi hopiꞌnonohinoso hofɨko kakoe hungkuno upoꞌnano lontɨfeso imɨngo neꞌnji lɨkafontɨfi Anɨtuye tajo ango engo somo humotofofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oso Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo sɨkuno iyoho humayo engoso umoꞌnɨmonteꞌno yohoho. Oso sɨkuno homo somo aꞌamu Jutaso hofɨko wopayo iloho iyoso engo kaofoꞌne soꞌnji miyoꞌnjo yontɨfeso wopayo feejoꞌnohini nɨmotofofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Oso hwe tajo ango syohoꞌnjo yofe engoꞌnjo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji hofɨko Jisasɨmo fonjasiyoꞌne honɨngkanoso ko tɨpeentɨfi hofɨko hwe hwoyaꞌmi ikujoho nafongkupitnnoho syafɨsyontɨfi iyoho unɨngkahonɨngki ole hnnɨmentohofi, Nakwo Jisasɨmo pipi fonjosyanehwono. ");
INSERT INTO apz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Oso sɨkuno somo Seten kako Jutas Isɨkaliyoutɨye sɨmeho moꞌmo paswonto huno uyɨmentisofoho. Jutas huhwo sohwo kako Jisasɨye inomokomoyo aho hufaꞌu hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sohwa mtaꞌango hweho. ");
INSERT INTO apz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jutas kako nowento oso aꞌamu yofe engoꞌnjo tajo ango syoho imotofo sohwanji aꞌamu hwapɨfe tɨfoꞌnjo Anɨtuye tajo ango engo somo uhwontohumamotofo yofe engoꞌnjo sohwanjimo uꞌmanto Jisasɨmneꞌno tokoyoꞌofo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Oso aꞌamu huhwo sohwa Jutasɨye hungkuno upaꞌnontɨfi sɨmonyo yontɨfi hofɨko hamniyoho uyoꞌneꞌentɨfi hungkuno mtitoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jutas kako eno ulonto kako Jisasɨmo hofɨkoe ahomo kumangkiyoꞌne aꞌamu piꞌnɨngo mohumunyo sohonta honɨngkano tɨpeehumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oso hohosohonta oso sɨkuno engo iyoho humayoꞌne aꞌamu Juta hofɨko wosopayo iloho inyoso engo mokamoꞌnnyo feejoꞌnohini nɨmotofo sɨkunoso iꞌmofapmmentisofoho. Oso sɨkuno homo somo hofɨko yahu sipsip honɨyo hokuꞌyopo ulohofoꞌne fonjohumotofo sɨkunofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Oseso Jisas kako Pitaꞌnji Jounꞌnjimo lɨhwajonto ulɨmento, Siko nowehosɨsi sɨkuno engo iyoho humayoꞌne somjo wosopayoso itoꞌno yasyohosi soꞌno nakwo wonano. ");
INSERT INTO apz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ose ulahonɨngki siko ulɨmentisiyo, Nekwo ntɨꞌmo wesyohumantayoꞌno kumoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ose ulahonɨngki ulɨmento, Upaꞌninyo. Ango engo sopono nowehosɨsi hwe fihwo kako mitɨhwontohoꞌnjo sohumo uswoꞌnɨngkohosɨsi siko kakimo inɨngkasohosɨsi ango kako swoso somo finɨngkasyɨnnyo. ");
INSERT INTO apz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Siko noswohosɨsi ango kakwoꞌyohwo sohumo ole ulinyo. Nekwoe Lonetɨhwayo sohwo kako kikineꞌno hungkuno ole lehwajohoho. Ngkoꞌne ango nje inomokomoyo sohwanji sɨkuno engo somjo wosopayo ntɨpo wonantaneto. Ose lehwajohoho. ");
INSERT INTO apz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ose ulohosɨsoꞌno kako ango tokilonjwaꞌmo molinyo yokintahoponjo somo wosetɨhwamontonoho. Oso homo somo nakwoe wosopayo itoꞌno feesinyo. Ango homo somo epohumayo ijempoho yoꞌmayoso hiꞌnjomnoho. ");
INSERT INTO apz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jisas ose ulahonɨngki siko nowenji yoꞌmayo Jisas ulɨmentiso hopaso tɨpemaꞌmentisiyefoho. Notɨpemanji siko wosopayo itoꞌno yahumentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Oso wosopayo nyoꞌne sɨkunoso nto iꞌmofopahonɨngki Jisas kako wosopayo nyoꞌne ijempoho soponjo epohumayo sopo kakoe inomokomoyo apousel sohwanji humamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jisas nohumanto ulɨmento, Ngko oleꞌno nɨmoꞌnɨmojofoho. Ngko sekwoꞌnji olo Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo Sɨkuno Engo wosopayo wonantaneꞌno yohono. Wosopayo nonɨngkuhwasi tɨfi tohino engo womaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sekwo nje hungkuno upaꞌnɨmno. Olo sɨkuno engo lomjo wosopayo nɨwoꞌnɨngkuhwone loso nɨngkuhwasi ngko olo hwaho lopo apaꞌno manɨmnehono. Oꞌo, ngko poyo imoꞌnɨꞌmeꞌno olo sɨkuno engo lomjo wosopayo nɨngkuhwoneso ne uꞌmofapmmontonoho. Tɨfi noꞌmo Anɨtuye aꞌamu kakimo enjwaꞌmo humafijo sohonta ngko olo sɨkuno lomjo wosopayo nɨngkuhwone hopa apaꞌno nonontɨꞌmnefoho. ");
INSERT INTO apz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ose ulonto kako mijo nyoꞌne noswanyo ipisayo mijoꞌnjoso nomanto Anɨtumo isamoyoka ulonto ulɨmento, Sekwo olo mijolo nomafɨkuji yano filofanɨmno. Ose ulonto ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sekwo nje hungkuno upaꞌnɨmno. Olo mijo loso ngko manɨmnehono. Ngko neꞌno manyoꞌnjo humantɨꞌme sohwoꞌni hwangku Anɨtuye aꞌamu kakimo enjwaꞌmo humafijo sohonta ngko apaꞌno nonontɨꞌmne hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jisas ose ulonto kako wopayo nomanto Anɨtumo isamoyoka ulonto kutɨkujo lohofonto kakoe inomokomoyo sohwamo huꞌmuyonto ulɨmento, Olo wosopayo loso nje aꞌapahofoho. Sekumo sefoꞌmayoꞌne mtɨhupenji sejapohono. Tɨfi noꞌmo sekwo ole mjanɨmɨkuji ngkineꞌno fisyanɨfɨsyɨkuno. ");
INSERT INTO apz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wosopayo moiꞌwo nɨngkahonɨngkofi kako wosopayo uyɨmentiso hopaso kako mijo homo oseꞌnohini uyɨmentisofoho. Kako mijo uyonto ulɨmento, Olo ipisayo mijo noswanyo loꞌmjo loso nje honɨyofoho. Sekwo Anɨtuꞌnji mokotɨkuꞌnyoꞌne yahino songo lomneꞌno sekwoe wonyomneꞌno mpe iyoꞌne usɨhumahefoho. ");
INSERT INTO apz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","I uhwonɨmni. Olo aꞌamu nje mango sohwamo ngkineꞌno tokoyoꞌofo yone lohwoꞌnji olo ijempoho lopo humalohwono. ");
INSERT INTO apz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","I Anɨtu kako hohonta hungkuno mtɨtoꞌmentiso hopaso ngko poyo umoꞌnɨmonneꞌno yohono. I osoꞌno oso hwe ngkineꞌno nje mango sohwamo tokoyoꞌofo ntohofone sohuneꞌno hitoho ntokwoho. ");
INSERT INTO apz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ose ulahonɨngki hofɨko angaꞌno angaꞌnohino sohwa humahnnɨngkofi, Oso yahino wonyo hiso tɨhwo ulohoꞌmonteto. Ose humahnnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jisasɨye inomokomoyo sohwa hofɨko oso hungkunoso hnnontɨfi hofɨkoe hungkunoso toho paꞌnyo imoꞌnɨngkahonɨngki ole soꞌno yoka hungkuno hnnɨmentohofi, Nakwo yofe engoꞌnjo nomɨhwamo yakoloꞌnnyoso tɨhwolo. ");
INSERT INTO apz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ose hnnɨngkahonɨngkofi Jisas ulɨmento, Hwe yofe engoꞌnjo olo hwaho lopo aꞌamumo mokosyohumayo sohwa hofɨko hofɨkoe aꞌamu somo syoho engo ko uyahonɨngkofi aꞌamu huhwo sohwa hofɨko nakumo nefoꞌmayoꞌnefoho lɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","I osoꞌno sekwo oso hopa ikutoho. Oꞌo, aꞌamu ngko yofe engo womaꞌmo loso sohwo kako nomꞌne aꞌamumo enjwaꞌmnohini wohumano. I kako nomꞌne hwamo womokosyohumamo loso sohwo kako oso huhwo sohwafe syoho ulohofiyo hopaso umoꞌnono. ");
INSERT INTO apz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hwe engo sɨmoꞌmjoso tɨhwolo. Aꞌamu ijempohopo wosopayo nɨwoꞌnɨngkiso sohwolaho. Aꞌamu wosopayo iloho yonto uyɨwoꞌnɨngkiso sohwolaho. I aꞌamu ijempohopo humanto wosopayo nɨwoꞌnɨngkiso oso hweho. I osoꞌno ngko yofe engoꞌnjo huhwoꞌni oso hopa miyalokuyohono. Oꞌo, ngko sekwoe syoho selohofiyo paꞌnyo hwoꞌni humaleno. ");
INSERT INTO apz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Sekwo ngkoꞌnji nohumentanɨngkofi yoꞌmayo tangoso ngkimo yamofo ntohofoꞌneso nuꞌmahonɨngki sekwo ngkimo manɨhwatɨꞌmofefoho. ");
INSERT INTO apz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","I osoꞌno nje Mpohwo kako ngkimo yoꞌmayo hopiꞌnonohino enjwaꞌmo hoꞌnanɨhumentiso soꞌno ngko huhwoꞌni yoꞌmayoso sekumo enjwaꞌmo hoꞌnosesyalokweno. ");
INSERT INTO apz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Oseso ngko yoꞌmayo somo mokosyohumentahonɨꞌme sohonta sekwo nje epohumayo sopo nohumafɨkuji nje wosopayoꞌnji mijoꞌnji nɨfitnnefoho. Sekwo ngkoꞌnji nohumafɨkuji oso aꞌamu Isɨlael hofɨkoe temtitofo aho hufaꞌu hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sofe hwe engo umoꞌnantɨfeho. Ose imoꞌnɨngkuhwosoꞌno sekwo hofɨkimo mokosyohumantokutnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas Pitamo ulɨmento, Saimoun, Saimoun, kɨko upaꞌnyo. Seten kako sekumo wonyo wasemokumonto yalofoho. Kako sekwoe huno wopɨngo somo kehilo ehilofo waselohoꞌmonte-eꞌno joho losetɨmalofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Seten ose ko yontanɨngki ngko jɨje sɨmeho hiꞌntnnono ntopantokunoso poyo mapeꞌnyoꞌnjo yoneꞌenji Mpohumo kikineꞌno jomo nto ulɨmaleno. Oseso kɨko apaꞌno ngkimo nnɨngkapohoji kɨko jɨje nɨngkwahwosamo nɨfoꞌmahoji yokumpohnꞌnyo usosofitofo. ");
INSERT INTO apz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ose ulahonɨngki Pita ulɨmento, Hwe Engofo, hofɨko kikimo impoꞌangomo intofakohufijoꞌmanji ngko huhwoꞌnnonji untofaehufe. I hofɨko kikimo poyo kumokufijoꞌmanji ngko huhwoꞌnnonji wemokufe. ");
INSERT INTO apz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ose ulahonɨngki Jisas ulɨmento, Pita, ngko olo hungkuno wakilɨmonneꞌno yohono. Olo sɨkwoꞌmiyo lomo tosɨka yoka mohoꞌnyo kuntoliyopo kɨko ngkineꞌno mango hufaꞌu sɨhune ole ulɨmonnoho. Ngko Jisasɨmneꞌno huno maniyohoyohoho. ");
INSERT INTO apz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hohonta sekwo nje hungkuno lutɨhwayoꞌne losehwatɨmentohe sohonta sekwo hamniyoho kiꞌyoꞌnji ifɨkiꞌyoꞌnji sɨfɨkwongofosyohwanji momotayoꞌnjo imentohofofoho. Oso hohosohonta sekwo yoꞌmayo soꞌno umofonyo imentohofotaho. Ose ulahonɨngki hofɨko ulɨmentohofi, Awonoho. Umofonyo mimmentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ose ulahonɨngkofi Jisas ulɨmento, I olohonta kɨko hamniyoho hoꞌyo hiꞌnjo hwosɨꞌmanji maho. I aꞌamu ifɨkiꞌyo hiꞌnjo hwoꞌmanji osenohini womano. I aꞌamu hwakuhwajo ane hwoꞌmanji kako kakoe manjiꞌmofo yajɨhwosi nomꞌne aꞌamu mpe ikujoꞌno kako hwakuhwajo mpe uyono. ");
INSERT INTO apz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hwapɨngoso aꞌamu Anɨtuye hungkuno mtɨꞌmokumentohofo sohwa hofɨko ngkineꞌno hungkuno ole mtɨꞌmokumentohofi, Hofɨko kakimo utɨmafɨkuji aꞌamu wonyo hwanji mɨhumatɨpitnne hweho. Oso hungkuno ngkineꞌno mtɨꞌmokumentohofoso ne umoꞌnɨmontonoho. Yoꞌmayo ngkineꞌno Anɨtuye hungkuno mtɨꞌmokumentohofoso olohonta ne umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ose ulahonɨngki hofɨko ulɨmentohofi, Hwe Engofo, kɨko uhwonyo. Nakwo hwakuhwajo hufaꞌu mokosyohumalohwono. Ose ulahonɨngkofi Jisas ulɨmento, Hoponoho, ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas noswaponto kako oso hwofɨkiꞌnyo Oulif sɨmojo sopo sahonɨngki kakoe inomokomoyo sohwa inɨngkamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jisas kako oso hopo sopo iꞌmofawento kakoe inomokomoyo sohwamo ole ulɨmento, Yamofo seꞌmaso sohonta wonyo pɨwesyanoho lɨkuji Anɨtumo jomo yokumpohnꞌnyo ulɨmno. ");
INSERT INTO apz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ose ulonto Jisas hofɨkimo weꞌenepi nonje ulɨkoꞌmotamentisofoho. Sawemopoꞌmaho. Oꞌo, aꞌamu sojo fonjontɨfi pɨwasyɨwoꞌnɨngkiso hopa sopole humawento Anɨtumneꞌno hwomtame ulohofonto ole ulɨmento, ");
INSERT INTO apz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Mpohwo, kɨko huno ole kiyosoꞌmanji olo tango uꞌmasoso ngko wae umoꞌmo. Huno ose kiyosoꞌmanji olo tango nɨꞌmasoso wae feenɨmofo. I, huno ose makiyoꞌmanji wae yanɨmofohotoho. Jɨje hunomnohini finɨngkayo. Nje hunomo inɨngkahutoho. ");
INSERT INTO apz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ose ulahonɨngki aꞌamu ahwomo mtaꞌango sohwo uꞌmanto Jisasɨmo yokumpohnꞌnyo usosofitoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisas kako tango mɨkunɨmposo engo uyahonɨngki kako Mpohumo jomo yokumpohnꞌnyo neꞌnohini ulontanɨngki kakoe aꞌapaho mtaꞌni wokino honɨyo paꞌnɨngo hwahopo loꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jisas kako Mpohumneꞌno jomo moiꞌwo ulosojwamofonto nolɨkafonto kakoe inomokomoyo sohwafepono umentisofoho. Kako nuꞌmanto uhwonɨmentisoso kakoe inomokomoyo sohwa saho fosyowentanɨngkofi uhwonɨmentisofoho. Hofɨkoe sɨmeho tango ifisyɨmofahonɨngki poꞌnɨfo imoꞌnontɨfi saho fosyawoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ose uhwononto ulɨmento, Sekwo saho pehoꞌno fosyawotofo. Filɨkapmno. Sekwo yamofo neꞌmasoso yahino wonyoso nopɨwesyanoho lɨkuji Mpohumo jomo ulɨmno. ");
INSERT INTO apz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas ose ulontanɨngki hwe piꞌnɨngo engo sohwa Jisasɨmo uꞌmaꞌmentohofofoho. Oso hwe Jutas Jisasɨye inomokomoyo aho hufaꞌu hopiꞌnono sɨfe mtaꞌni hufaꞌuyo somtaꞌango sohwo kako aꞌamu piꞌnɨngo engo huhwo sohwamo ipemotaponto Jisasɨye huyoꞌmo nuꞌmanto hinjoho uhuꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ose uhuꞌnɨngkahonɨngki Jisas ulɨmento, Jutas, kɨko Aꞌamufe Hwomu sohwoꞌnɨmo hinjoho nɨhuꞌnɨngkinoso nje mango hwamo ujo wehontojwanɨhumneꞌno lantohofohino. ");
INSERT INTO apz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ose ulahonɨngki Jisasɨye inomokomoyo kakoꞌnji humunyo sohwa yoꞌmayo imoꞌnone soꞌno nuhwonontɨfi hofɨko ulɨmentohofi, Hwe Engofo, kɨko huno ole lakiyohoho. Nakwo olo aꞌamu lohwamo hwakuhwajoꞌnji wofonjosyano. Huno ose lakiyohoho. ");
INSERT INTO apz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ose ulontanɨngkofi inomokomoyo fihwo kako oso hwe tajo ango syohoꞌnjo sohwafe hwe yofe engoꞌnjo sohwo kakoe syoho ulohofiyo sohwoe aho anga sohohnjo haloho somo hwakuhwajoꞌnji lokuꞌmentisofoho. Lojwahonɨngki halohoso pɨwahuꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jisas ose uhwononto ulɨmento, Oso yahino wonyoso olohonta fohoꞌnamopmno. Ose ulonto oso hwe huhwo sohwoe halohopo aho upmꞌmokahonɨngki halohoso wopɨngo umoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jisas wopɨngo ose umokonto kako aꞌamu tajo ango syohoꞌnjo sohwanji aꞌamu Anɨtuye tajo ango engo somo uhwontohumayo fefo tokusoꞌnjo sohwafe hwe engo sohwanji aꞌamu Jutafe hwe engo sohwanji hofɨko kakimo aho ke-eꞌne pmmentohofo sohwamo ole ulɨmento, Sekwo aꞌamu hufo iwoꞌnɨngkiso sohuneꞌno aho wokano lontɨfi hwakuhwajoꞌnji itokusoꞌnji lomotopalokwofo. ");
INSERT INTO apz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sɨkuno piꞌnɨngo engo somo Anɨtuye tajo ango engo somo ngko sekwoꞌnji nohumentanɨngko sekwo ngkimo aho manɨkoꞌmmentohofofoho. I osoꞌno olohonta Setenɨye yokumpohnꞌnyo engo imoꞌnɨngkohoho. Osoꞌno sekwoe sɨkunofoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas ose ulahonɨngki hofɨko Jisasɨmo aho kentɨfi ipemotawomentohofofoho. Ipemotawentɨfi hofɨko oso aꞌamu tajo ango syohoꞌnjo sohwafe hwe engo sohwoe angomo motahumentohofofoho. Pita hofɨkimo ko inɨngkawomentisoso hofɨkimo mufantohiꞌnyofoho. Oꞌo, kako poꞌmtopoꞌmtisyo humulohoꞌmɨwesyofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Oso ango hopo soponjo aꞌamuso tojo ajwo somo toho intofontɨfi humohumantohofofoho. Osopo Pita hofɨkoꞌnji humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pita kako tɨpomponaho sopo nohumentanɨngki aꞌmu syoho ulohofiyo fisi kako Pitamo uhwononto ulɨmento, Olo hwe lohwo huhwo Jisasɨꞌnji humawoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ose ulahonɨngki Pita ulɨmento, Olo aꞌmu losijo awonoho. Ngko kakineꞌno huno maniyofoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hwangku weꞌenepi nohumantɨfi hwe fihwo kako Pitamo uhwononto ulɨmento, Kɨko huhwosi kakoe aꞌamu hwosoho. Ose ulahonɨngki Pita ulɨmento, Olo hwe lohwo ngko kakoe aꞌamu hwonɨꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pita ose ulonto oso hopo sopo neꞌno nohumentanɨngki mofehiꞌnyo sɨmoꞌme angaꞌnohino uyakolofo somo hwe fihwo Pitamneꞌno hungkuno yokumpohnꞌnyo ole ulɨmento, Hungkuno nehopiꞌnohini walɨmonneꞌno yohono. Olo hwe lohwo huhwo kako Jisasɨꞌnji humawoꞌnɨngkiso lohwolɨkeno. Kako Ngkalilintaꞌango hweho. ");
INSERT INTO apz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ose ko ulahonɨngki Pita ulɨmento, Olo hwe lohwo kɨko hungkuno lohinoso ngko huno manyoꞌnjo yohoho. Ose ulontanɨngki tosɨka yoka kuntoꞌno hoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ose hoꞌnɨngkahonɨngki Jisas kako Pitamneꞌno ikinjamo lohofonto Pitamo uhwonɨmentisofoho. Pita kako Jisasɨye sɨmanomo uhwononto oso hungkuno Jisas Pitamo ulɨmentiso soꞌno huno ikwesyafɨhuꞌmentisoso olenoho. Olo sɨkwoꞌmiyo lomo yɨhufo tosɨka yoka malontanɨngkuhwoso sohonta kɨko Pita ngkineꞌno mango hufaꞌu sɨhune ole walɨmonnoho. Ngko Jisasɨmneꞌno huno maniyofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita kako huno ose syafɨsyonto kako mempo swonto kakoe yahino wonyo soꞌno sɨmeho tango mɨkunɨmposo uyahonɨngki humotaho engo lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aꞌamu Jisasɨmo aho koꞌmentohofo sohwa hofɨko Jisasɨmneꞌno sitofo ulontɨfi ikujoho fongkuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Hofɨko Jisasɨye tɨmomo hwapɨfe kotɨjɨswontɨfi ikujoho fonjontɨfi ulɨmentohofi, Kɨko huno hwapɨngoꞌnjo sohwosi tɨhwo kufonjohoho. Kɨko huno kisyoꞌmanji oso hweho fonaso. ");
INSERT INTO apz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ose ulontɨfi hofɨko sitofo mjalomumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Imɨngo ne mofehiꞌnyo sɨꞌmofape soꞌnji aꞌamu kaunɨsol sohwa uhuꞌmokumentohofofoho. Oso aꞌamu huhwo sohwa fehohnjoso hofɨko tajo ango syohoꞌnjo sohwafe hwe engo hwafoho. Fehohnjoso honɨngkano hungkuno lutɨhwawoꞌnɨngkohofɨhwafoho. Aꞌamu sohwa hofɨko hofɨkoe kaunɨsol sohwafe pono Jisasɨmo ipemotasontɨfi ole ulɨmentohofi, ");
INSERT INTO apz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kɨko yoloho fonaso. Kɨko Kɨlais Anɨtu lokuhwatɨmentiso sohwosilaho. Ose ulahonɨngkofi Jisas ulɨmento, Ngko selɨmeso sekwo ngkimo sɨmeho hiꞌntnnono montapɨfitnnehofo. ");
INSERT INTO apz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","U, ngko sekumo nomꞌne hungkuno selohonɨmeso sekwo nje hungkunomo aku mantɨfitnnehofo. ");
INSERT INTO apz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","I osoꞌno olohontaꞌnji sɨkuno engolopohamo memjaofɨhwoso sohonta Aꞌamufe Hwomu sohwoꞌni Anɨtu yoꞌmayo hopiꞌnonohino somne yokumpohnꞌnyo hwapɨngoꞌnjo sohwoe aho anga sohohntaꞌni wohumamonnoho. ");
INSERT INTO apz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ose ulahonɨngki ulɨmentohofi, Kɨko sohwosi, kɨko Anɨtuye Hwomu Nehwosilaho. Ose ulahonɨngkofi Jisas ulɨmento, Sekwo ose lohofoso ngko olo huhwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ose ulahonɨngki hofɨko hnnɨmentohofi, Kakoe mango mtaꞌni nto upaꞌnɨngkuhwono. Nomꞌne hungkuno pehofo upoꞌnanehwono. Awonoho. Ntaꞌnoho. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Oseso aꞌamu hopiꞌnonohinoso nolɨkafontɨfi Pailotɨyepono Jisasɨmo ipemotawomentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ipemotawentɨfi hofɨko Jisasɨmneꞌno olo hwasyo hungkuno lomantɨfi mjalomumentohofi, Nakwo olo hwe lohumo uhwonɨwoꞌnɨngkuhwoneso kako nakwoe aꞌamu somo hwasyo honɨngkanomo ipemotawowoꞌnɨngkiso hweho. Nakwoe hwe engo Sisa sohuneꞌno hamniyoho hoꞌnasyɨwoꞌnɨngkuhwone honɨngkano somo wopɨjwonaoꞌmto iwoꞌnɨngkiso hweho. Kako ole hnnɨwoꞌnɨngkiso hweho. Ngko Kɨlais hwoꞌnyoho. Ngko aꞌamu Jutafe Hwe Engo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ose ulahonɨngkofi Pailot Jisasɨmo ulohonɨmento, Kɨko aꞌamu Jutafe Hwe Engo hwosilaho. Ose ulahonɨngki Jisas ulɨmento, Hungkuno hiso kɨko nehopi lohino. ");
INSERT INTO apz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ose ulahonɨngki Pailot kako aꞌamu tajo ango syohoꞌnjo sohwafe hwe engo sohwanji hwe hwoyaꞌmi hopiꞌnonohino soꞌnjimo ole ulɨmento, Ngko olo hwe lohuntaꞌni honɨngkano wonyo motɨpemahoyohono. ");
INSERT INTO apz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ose ulahonɨngki hofɨko mohmꞌno olo hwasyo hungkuno ulɨmentohofi, Olo hwe lohwo kako hwaho Jutiya soꞌmeemjo hwe moyaꞌmimo hungkuno ulahonɨngki hofɨko aꞌamu nakwoe hwaho mokosyohumayo sohwamo wae weeofantɨfeꞌno yalokwofo. Kako oso hungkunoso Ngkalilintaꞌangoso neꞌno hwasyo mjalɨmopmmojoso ae oloponoho. Hwasyo ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailot kako oso hungkuno upaꞌnonto hofɨkimo ulohonɨmento, Olo hwe lohwo Ngkalilintaꞌango hwolaho. ");
INSERT INTO apz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ose ulahonɨngki hofɨko hungkuno ulɨmentohofoso Pailot kako huno ole uyɨmento, Jisas kako oso hwaho Helout mokosyohumamojo sopontaꞌango hweho. Huno ose uyahonɨngki kako Heloutɨyepono Jisasɨmo lɨhwatɨmentisofoho. Oso hohosohonta Helout huhwoꞌnji ango Jelusalem humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helout kako Jisasɨmo uhwononto sɨmonyo imentisofoho. Hwapɨngoso kako Jisasɨmneꞌno yoꞌmayo hungkuno upaꞌnonto kako Jisas yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso ihwosoꞌno uhwonɨmo lɨmojo hweho. ");
INSERT INTO apz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Oseso Helout kako yoꞌmayo hungkuno piꞌnɨngo Jisasɨmo ko ulohonɨngkahonɨngki Jisas kako hungkuno mujofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aꞌamu tajo ango syohoꞌnjo sohwafe hwe engo sohwanji aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji hofɨko Jisasɨmneꞌno hungkuno yokumpohnꞌnyo mjalɨmɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helout kakoe aꞌamu itokusoꞌnjo sohwanji hofɨko Jisasɨmo wonyo umtɨꞌmokontɨfi sitofo ulɨmentohofofoho. Osoꞌno hofɨko hwe yofe engoꞌnjo hwaho mokosyohumayo sohwafe manjiꞌmofo wonyoangkafoso aꞌamu oso homo somo uhwonɨngkuji tɨkafo ujiyoꞌne ulohofɨhwajontɨfi Pailotɨyepono asomo lɨhwatɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hohonta Heloutɨꞌnji Pailotɨꞌnji siko mangohwo paꞌnyo humamojiyoso oso sɨkuno homo somo siko sɨmeho afa inonji nje aꞌamuhwe hnnɨmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Osoꞌno Pailot kako aꞌamu tajo ango syohoꞌnjo sohwafe hwe engo sohwanji aꞌamu Jutafe hwe engo sohwanji hwe moyaꞌmi hopiꞌnonohino somneꞌno lutɨmanto ");
INSERT INTO apz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ulɨmento, Sekwo olo hwe lohumo ngkiyepono ipemotapohofo lohuneꞌno sekwo ntohofi, Kako hwe moyaꞌmife hunomo wonyo umokalofoho. Ose ntohofo soꞌno ngko oso hungkuno soꞌneꞌno sekwoe tɨmopo ulohonɨngkeso ngko kakoe honɨngkano wonyoso motɨpemahoyohono. Oꞌo, sekwo upaꞌnɨmno. Sekwoe hungkunoso ne anefoho. ");
INSERT INTO apz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Helout kako ngkiyepono olo hwe lohumo asomo lɨhwatɨmaso soꞌno ngko huno niyohoho. Kako huhwo olo hwe lohwoe honɨngkano wonyoso motɨpemuyonto lɨhwatɨmaso hweho. Upaꞌnɨmno. Olo hwe lohwo peho wonyo imaso huneꞌno wofonjosyantanto. Awonoho. Wonyo ane hweho. ");
INSERT INTO apz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Osoꞌno ngko kakimo sohweꞌnji ikujoho fonjiꞌmo usɨhutofɨhwatɨmonneꞌno yohono. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Oso humamotofo sohonta yahino oleso woꞌnnyoponoho. Oso Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo sɨkuno iyoho humayo engo uhwonɨmotofo homo somo Pailot kako aꞌamu impoꞌangomjo fihumo isɨhutofɨhwatɨmojofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pailot kako Jisasɨmo usɨhutofɨhwatɨmo lɨmentiso soꞌno hwe moyaꞌmi hopiꞌnonohino mango mohmꞌno ole ulɨmentohofi, Oso hwe sohumo fonjasyɨkuji Mpolapas nakuyepono fisɨhutofɨhwatɨmno. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Oso hwe Mpolapas huhwo sohwo kako aꞌamu hwaho mokosyohumayo sohwanji ikujoho fongkiꞌnontɨfi hwe fihumo fonjahumentiso soꞌno hofɨko impoꞌangomo uhumatɨꞌmentohofo hweho. ");
INSERT INTO apz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailot kako Jisasɨmo usɨhutofɨhwatɨmo lonto hungkuno apaꞌno ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","I osoꞌno hofɨko mango mohmꞌno ulɨwoꞌnɨmentohofi, Iyopo fonjintoꞌofahumno. Iyopo fonjintoꞌofahumno. ");
INSERT INTO apz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ose ulahonɨngkofi Pailot kako hungkuno hufaꞌu sɨhune umoꞌnono lonto ulɨmento, Pehoꞌneto. Olo hwe lohwo peho wonyo imaso hwolo. Ngko olo hwe lohwoe wonyoso motɨpemahoyohono. Kako poyoso pehoꞌno umoꞌnɨmontolo. Oꞌo, ngko kakimo sohweꞌnji ikujoho fonjiꞌmo usɨhutofɨhwatɨmonneꞌno yohono. ");
INSERT INTO apz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ose ko ulahonɨngki hofɨko nɨhuꞌno yokumpohnꞌnyo imoꞌnontɨfi fonjintoꞌofasiyoꞌne apaꞌno mango mohmꞌno ulɨmentohofofoho. Osoꞌno hofɨkoe mangoso Pailotɨye mangomo hwotoho hmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Oseso Pailot hofɨkoe hungkunomo halohoꞌno yonto Jisasɨmo fonjasiyoꞌne hungkuno ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Oso hwe kako aꞌamu hwaho mokosyohumayo sohwanji ikujoho fongkiꞌnontɨfi hwe fihumo fonjahumentiso soꞌno hofɨko impoꞌangomo uhumatɨꞌmentohofo sohumo Pailot kako isɨhutofɨhwatɨmentisofoho. I Jisas sohuneꞌno hofɨkoe hungkunomo inɨngkawento Pailot kako kakoe aꞌamu itokusoꞌnjo sohwafe ahomo hoꞌnahumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hofɨko Jisasɨmo ipemotawentɨfi hwe fihwo Saimoun ango Sailinintaꞌango sohumo aho kaꞌmentohofofoho. Saimoun huhwo sohwo kako syoho mtaꞌango sohwo angopono pontanɨngki hofɨko Jisasɨye iyo hwojiyafɨkuꞌnnyoso Saimounɨye sangopo nɨtofiyahonɨngkofi kako intofonto Jisasɨmo tɨfi intofɨmjɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nto wahonɨngkofi hwe moyaꞌmi piꞌnɨngo engo hofɨko Jisasɨmo inɨngkawentɨfi moyaꞌmi fifa hofɨko Jisasɨmneꞌno hitoho ulofahonɨngki humotaho lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ose lontanɨngkofi Jisas kako ikinjamo lohofonto ulɨmento, Sekwo Jelusalemmjo moyaꞌmi sofasi sekwo ngkineꞌno humotaho pehoꞌno ntantɨkwofo. Oꞌo, sekwo sekwoꞌntnneꞌno sekwoe mehomiꞌntnneꞌno humotaho engo filɨmno. ");
INSERT INTO apz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Upaꞌnɨmno. Hwangku sɨkuno wonyo iꞌmofapɨhwosoꞌno ole lɨfitnnefoho. Moyaꞌmi hwonjo sofanji, moyaꞌmi yawoso mmoꞌnyoꞌnjo sofanji, moyaꞌmi mehomi amno manyo sofanji, hofɨko sɨmonyo uyɨfe. ");
INSERT INTO apz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Oso sɨkuno homo somo hwe moyaꞌmi hwofɨkiꞌnyo engo somo ole ulɨfitnnefoho. Sekwo nakumo fɨkilopenahumno. I hwofɨkiꞌnyo weꞌe somo ole ulɨfitnnefoho. Sekwo nakumo fɨfehuꞌmokonesyohumamno. Ose ulɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hungkuno ole lɨwoꞌnɨngkohofo, Aꞌamu olo wonyo loso iyo mijoꞌnjo tɨpemapijo sohonta ifijoꞌmanji iyo yofoho imoꞌnɨngkuhwosoꞌno pipi uyantɨfeto. Jisas kakineꞌno ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hwe hufaꞌu honɨngkano wonyo imoꞌmojiyo sohwaꞌu Jisasɨꞌnji fonjintoꞌofasiyoꞌne ipemotawomentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Oso hwofɨkiꞌnyo weꞌe yofe ole, Aꞌmomnokino Yokino Huyoꞌmango Paꞌnyoponoho lɨwoꞌnɨngkohofo sopo iꞌmofawentɨfi osopo Jisasɨmo fonjintoꞌofahumentohofofoho. Oso hwe wonyo imojiyo sohwaꞌuꞌnji angaꞌnohino sohwo Jisasɨye aho angahohntaꞌni fonjintoꞌofasyontɨfi nomꞌne humo Jisasɨye aho hwonamonyo hohntaꞌni fonjintoꞌofahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Hofɨko Jisasɨmo fonjintoꞌofosyahonɨngkofi Jisas kako Anɨtumo ulɨmento, Mpohwo sohwosi olo wonyo ntohofantɨkwofo losoꞌno hofɨko huno itoꞌno muyo hwafoho. Osoꞌno kɨko hofɨkoe wonyoso wae yɨmofohoji hofɨkimo ufoꞌmaho. Ose ulɨmentisofoho. Hwe itokusoꞌnjo sohwa hofɨko Jisasɨye manjiꞌmofo yoꞌmayoso tɨhwo tɨhwo manekiyohoho lontɨfi syohiꞌnyo yontɨfi oso syohiꞌnyo homo somo uyakoloꞌmentiso aꞌamu sohwo maꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hwe moyaꞌmi hopiꞌnono hofɨko nolohofontɨfi humuhwontohumantohofofoho. Hwe yofe engoꞌnjo sohwa hofɨko Jisasɨmneꞌno sitofo ole ulɨmentohofi, Kako aꞌamu nomꞌnemo ufoꞌmawoꞌnɨngkiso hweho. Osoꞌno kako Kɨlais Anɨtu uhwosopoꞌmentiso ne hwoꞌmanji kako ufoꞌmaꞌnono. ");
INSERT INTO apz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ose lahonɨngkofi aꞌamu itokusoꞌnjo huhwa sitofo ulontɨfi hofɨko Jisasɨꞌnjo mofone sopo wentɨfi mijo yokumpohnꞌnyo mangkinyoꞌnjo ifomokosyohumantɨfi, Mono. Mijo hmnyo, ulontɨfi ");
INSERT INTO apz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ulɨmentohofi, Kɨko aꞌamu Juta somo mokosyohumawoꞌnɨngkino nehwosɨꞌmanji kɨko foꞌmaꞌnyo. Sitofo ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jisasɨye iyo hwojiyafɨkuꞌnnyo kakoe mnokinoꞌnjo tojwa sopo iyoswo hofojahumentohofofoho. Oso iyoswo homo somjo ifalifaliyoso olenoho. OLO HWE LOHWO AꞌAMU JUTAFE HWE ENGO HWEHO. ");
INSERT INTO apz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Oso aꞌamu wonyo sohwaꞌu Jisasɨꞌnji fonjintoꞌofahumentohofo sohwaꞌu nomꞌnehwo Jisasɨmo sitofo ole ulɨmento, Kɨko Kɨlais nehwosɨꞌmanji kɨko foꞌmaꞌnɨngkohoji nekumo fefoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Ose ulahonɨngki nomꞌnehwo upaꞌnonto yoka ulɨmento, Kɨko peꞌnɨngkino losoꞌno Anɨtumneꞌno iyoho makinɨngkoho liyohoho. Nekwoe yahino wonyo imotohwayo lomneꞌno tohino mahwoyo loso itoꞌnohinofoho. Olo hwe lohwo kako honɨngkano wonyo ane hweho. I osoꞌno nekwo tohino mahwoyeso kakoꞌnji afaꞌno mahwono. ");
INSERT INTO apz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ose ulonto kako Jisasɨmo ulɨmento, Hwangku kɨko aꞌamumo mokosyohumayoꞌne yofe engo majo sohonta kɨko ngkineꞌno huno asyanɨfohujo. ");
INSERT INTO apz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ose ulahonɨngki Jisas ulɨmento, Ngko hungkuno nehopiꞌnohini wakilɨmonneꞌno yohono. Olo sɨkuno lomo kɨko ngkoꞌnji ahwomomjo ango wopɨngo Palatais sopo wohumantayoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hinjo ajwo kuntoliyopo sɨkuno mjaofonto mofehiꞌnyomo hoholo yasyonto akupoꞌnyoꞌnji (3 kɨlouk) osoꞌnji apaꞌno longkonɨngkahonɨngki mofehiꞌnyo lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sɨkuno mjaoꞌmentiso hohosohonta Anɨtuye tajo ango engo somjo hwapɨfe engo oso ajwoponjo ango weꞌe Anɨtu humayoꞌnefoho lɨmotofo sopo hokuꞌyopo pmpilɨpeehinyoso yokintahopo ntaꞌni tomonte sɨsɨmpo lohofonto hufaꞌu imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sɨsɨmpeehonɨngki Jisas kako mango mohmꞌno ole ulɨmento, Mpohwo, nje huyoꞌmangoso jɨje ahomo wohoꞌnakohumneꞌno yohono. Ose ulonto kako poyo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Poyo imoꞌnɨngkahonɨngki aꞌamu itokusoꞌnjo sohwafe hwe engo sohwo oso homo somo uhwononto Anɨtuye yofe hoꞌnomanto ulɨmento, Ou, nehopi. Olo hwe lohwo kako honɨngkano wonyo ane hweho. Kako itoꞌnohino hweho. Ose lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Hwe moyaꞌmi hopiꞌnono oso hopo sopo lohofontɨfi yoꞌmayo imoꞌnɨmentiso somo tɨmo humuhwontohumantohofoso sɨmeho tango mɨkunɨmposo uyahonɨngki hofɨkoe ango poneꞌno humpoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jisasɨye aꞌamu soꞌnji moyaꞌmi Ngkalili ntaꞌni Jisasɨmo inɨngkamotofo sofanji kengo nompo lohofontɨfi yoꞌmayo imoꞌnɨmentiso somo humuhwontohumantohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Hwe fihwo kakoe yofe Jousepɨyoho. Oso hwe huhwo sohwo kako aꞌamu Jutafe ango Alimateyantaꞌango hweho. Kako hwe wopɨngoꞌnohini hweho. Kako kaunɨsol syohoꞌnjo ko huhwo ");
INSERT INTO apz_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","kako oso wonyo hofɨko Jisasɨmo ulohoꞌmentohofo soꞌno eno mujoꞌnjo imentisofoho. Oꞌo, kako oso hwe Anɨtu uhwatɨmo lɨmentiso sohwoe pe-eꞌne sɨkuno soꞌno hontohumamojo hweho. ");
INSERT INTO apz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Oso hwe huhwo sohwo kako Pailotɨmo uꞌmanto Jisasɨye pijafo mayoꞌne ulohonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Oseso kako Jisasɨye pijafoso iyopo ntaꞌni nomanto hwapɨfe halojo somo ifohumpo lohofonto sokimo aꞌamuhwa hofɨko mtɨꞌmokumentohofo somo hoꞌnahumentisofoho. Oso sokimo homo somo nomꞌne aꞌamu poyo peꞌnnyoso mohoꞌnasiyomnoho. Oꞌo, songofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Oso sɨkuno Fɨlaite somo hofɨko sɨkuno iyoho humayoꞌne yoꞌmayoso itoꞌno yasiyoꞌne sɨkunofoho. Sɨkuno iyoho humayoso umoꞌnɨmonteꞌno yohoho. ");
INSERT INTO apz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Oso moyaꞌmi Ngkalili ntaꞌni Jisasɨmo inɨngkapmmentohofo sofa hofɨko Jousepɨꞌnji nowentɨfi Jousep Jisasɨye pijafo sokimomo hoꞌnosyahonɨngki humuhwontohumantohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Osofa hofɨkoe ango poneꞌno humpoꞌmentohofofoho. Nowentɨfi yoꞌmayo yoꞌmayo akinoꞌnjoso Jisasɨye pijafomo ehulohofaneꞌentɨfi itoꞌno esyohumamentohofofoho. Oso sɨkuno iyoho humayo somjo honɨngkano hungkuno lɨmotofo hopaso hofɨko iyoho humamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Santemo nɨhuꞌno imɨngo neꞌnji oso moyaꞌmi hofo sofa hofɨko Jisasɨye pijafomo hwone mijo yoꞌmayo akinoꞌnjoso ehulohofoꞌne itoꞌno nto esyohumamentohofoso huꞌmemantɨfi sokimo Jisas wentanjo soponeꞌno umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Oso sojo ewafoso sokimo mango sopo pɨjwahumentohofoso nohwosompoꞌnowentanɨngki uhwonontɨfi ");
INSERT INTO apz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","sokimomo swontɨfi uhwonɨmentohofoso Jisasɨye pijafoso motɨpɨhwonɨmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Oso hisoꞌno hofɨko huno piꞌnɨngo engo syafɨsyontɨfi humentanɨngkofi hwe hufaꞌu hwaꞌu manjiꞌmofo mofehiꞌnyo lawoꞌnnyo sohwaꞌu hofɨkoꞌnjopo lohofahonɨngki ");
INSERT INTO apz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","moyaꞌmi sofa iyoho unɨngkahonɨngki hofɨko ingkuꞌni ingkuꞌni lohofontɨfi humamentohofofoho. Hwe huhwo sohwaꞌu ulɨmentisiyo, Sekwo aꞌamu songo humaso sohuneꞌno aꞌamu poyo peꞌnɨmentohofo lohwafepono pehoꞌne tɨpmmopalokwofo. Kako olopo mohumuyoho. Anɨtu nto ulɨkoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kako hwaho Ngkalili humanto selɨmentiso hungkuno soꞌno huno apaꞌno fɨkwesyafɨhupmno. ");
INSERT INTO apz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ole soꞌno selɨmento, Aꞌamufe Hwomu sohumo aꞌamu honɨngkano wonyoꞌnjo sohwafe ahomo hoꞌnasyɨkujoꞌno hofɨko iyo hwojiyafɨkuꞌnnyo somo fonjintoꞌofasyɨkujoꞌno sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno apaꞌno songo lɨkafone hweho. ");
INSERT INTO apz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ose ulahonɨngki hofɨko Jisas hofɨkimo hohonta ulɨmentiso soꞌno syafɨsyontɨfi ");
INSERT INTO apz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","oso sokimo homo somo ulɨkoꞌmaꞌmentohofofoho. Nulɨkoꞌmantɨfi hofɨko Jisasɨye inomokomoyo aho hufaꞌu hopiꞌnono sɨfe mtaꞌni angaꞌnohino sohwanji nomꞌne aꞌamu soꞌnjimo yoꞌmayo soꞌno ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Oso moyaꞌmi hofo sofa ole fafoho. Maliya ango Makɨtolantaꞌango siꞌnji Jouanaꞌnji Maliya Jemɨsɨye konaꞌwohisiꞌnji nomꞌne moyaꞌmi sofanji oso hungkuno hiso aꞌamu apousel sohwamo ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Oso aꞌamu apousel sohwa hofɨko moyaꞌmi sofafe hungkuno somo upaꞌnontɨfi ifofo hungkuno lohapohofo ose syafɨsyontɨfi hofɨko sɨmeho hiꞌntnnono mummentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","I osoꞌno Pita kako nolɨkafonto sokimomo uhwonɨmo lonto hano kunto kuntoꞌno ufeeloꞌmꞌmentisofoho. Iꞌmofawento mempo hohntaꞌni hwomtame ehumu lohofonto tɨmo sokimomoꞌmo monje syuhwonɨhwojahusyoso hwapɨfe halojo soꞌnohini wentanɨngki syuhwonɨhwojawento kakoe ango poneꞌno asomo ponto yoꞌmayo imoꞌnɨmentiso soꞌno huno piꞌnɨngo engo humosyafɨsisofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Oso sɨkuno homo somo hwe hufaꞌu hwaꞌu siko ango Emeyosɨneꞌno hano umentisiyefoho. Oso honɨngkano Jelusalem mtaꞌni ango ne sopo iꞌmofae soꞌno hano uyoso aho hufaꞌu hopiꞌnono sɨfe mtaꞌni angaꞌno kiloumitafoho. ");
INSERT INTO apz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Siko hano nowenji yoꞌmayo imoꞌnɨmentiso soꞌno humomjahnnɨmɨhusiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Siko hungkuno mjohnnɨmɨwentanɨngki Jisas kako huhwo sikoꞌnjo mofonepo ntaꞌni imoꞌnoma lohofonto sikoꞌnji humahwofofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jisas sikoꞌnji ko wentɨfi siko Jisasɨmo yofe mɨhwofeꞌnjo imentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisas sikimo ulɨmento, Siko peho hungkuno mjolɨmɨwalokusiyo. Ose ulahonɨngki siko lohofu lohofonji sɨmeho tangoꞌnjo sohwaꞌu sɨmano upoꞌmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Hwe nomꞌnihwo kakoe yofe Kɨliyoupas sohwo kako Jisasɨmo ulɨmento, Aꞌamu ango kengo kengopontaꞌangoso Jelusalem uhuꞌmokumalofo sohonta humamahnno sohwosi yoꞌmayo imoꞌnɨmaso soꞌno kɨko huno makiyoho liyohoho. ");
INSERT INTO apz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ose ulahonɨngki Jisas ulɨmento, Peho imoꞌnɨmasoto. Ose ulahonɨngki siko ulɨmentisi, Oso yoꞌmayo hopiꞌnonohino imoꞌnɨmaso soꞌno lalokuhwayoso Jisas ango Nasaletnntaꞌango sohumo imoꞌnɨmasofoho. Anɨtu kakimo hungkuno uyahonɨngki nalɨmojo hweho. Yoꞌmayo imojo soꞌnji hungkuno lɨmojo soꞌnji wonyoangkafofoho. Nakwo aꞌamu huhwo sohwi uhwonɨmentɨhwone hnꞌnnonji Anɨtu huhwoꞌnji wopɨngo hweho lalokuhwono. ");
INSERT INTO apz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nakwoe aꞌamu tajo ango syohoꞌnjo sohwafe hwe engo sohwanji nakwoe hwe engo sohwanji hofɨko hwe engo nakwoe hwaho mokosyohumayo sohwafe ahomo hoꞌnohumalofɨhweho. Nohoꞌnosyahonɨngkofi hofɨko poyo umoꞌnono lontɨfi kakimo iyopo fonjintoꞌofahumalofo hweho. ");
INSERT INTO apz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","I osoꞌno nakwo huno ole: Oso hwe sohwo kako aꞌamu Juta hnꞌnɨmo aꞌamu aho yokumpohnꞌnyo nemokosyohumentanɨngkujo sohwa mtaꞌni isɨhutofonemayoꞌne hweho. I osohonta oso yoꞌmayo imoꞌnɨmasoso sɨkuno hufaꞌu sɨhune memjaoꞌmasofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Osoꞌno olo imɨngo loꞌnji moyaꞌmi fehohnjo nakwoꞌnji Jisasɨmo inɨngkamotofo sofa hungkuno nelahonɨngkofi nakwo yomo engo ihwonefoho. Hofɨko olo imɨngo loꞌnji Jisasɨye pijafo hoꞌnohumalofo sopo ");
INSERT INTO apz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","huno uhwonawentɨfi asomo nopontɨfi ole nalohofi, Nakwo aꞌamu ahwomo mtaꞌango sohwaꞌumo uhwonɨngkahonɨngkuhwoni siko ole nalisiyo, Kako songo humaho. Ose nalohofo. ");
INSERT INTO apz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aꞌamu fehohnjo nakwoꞌnji humantɨhwone sohwa hofɨko Jisasɨye pijafo hoꞌnohumalofo sopo uhwonowano lontɨfi umentohofoso moyaꞌmi sofa uhwonɨngkahwofo hopa hofɨko uhwonɨngkohofofoho. I osoꞌno hofɨko Jisas sohumo muhwonɨngkiyohofo. ");
INSERT INTO apz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ose ulahonɨngki Jisas ulɨmento, Siko huno ane hwahusoho. Siko aꞌamu Anɨtu hungkuno uyahonɨngki lɨmotofo sohwafe hungkunomo sɨmeho hiꞌntnnono muyoꞌnjo pehoꞌno imasiyoto. ");
INSERT INTO apz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Hofɨko ole nalɨmotofi, Kɨlais kako sɨmoꞌmo yoꞌmayo soꞌno tohino mahwosi tɨfi noꞌmo kako yofe engoꞌnji yokumpohnꞌnyo engoꞌnji mane hweho. Ose nalɨmotofofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ose ulonto Jisas kako Mousesɨye hungkuno mtaꞌni lomanto aꞌamu Anɨtu hungkuno uyahonɨngki lɨmotofo sohwafe hungkuno soꞌnji ulɨmentisofoho. Yoꞌmayo hungkuno kakineꞌno mtɨꞌmokumentohofoso Jisas sikimo lɨjumoꞌmentisofoho. Osoꞌno kako yoloho neso lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jisas kako neꞌno lutɨhumuhwahonɨngki oso ango Emeyos siko wowanji imentisiyo sopo mofonepo iꞌmofawentɨfi Jisas kako hano neꞌno wamonto ko yahonɨngki ");
INSERT INTO apz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","siko hungkuno yokumpohnꞌnyo ulɨmentisi kɨko nekwoꞌnji fosyohumaho. Mofehiꞌnyo wanɨngkuꞌnɨmonto isoso weꞌenepi sɨkuno wonammontonoho. Ose ulahonɨngki Jisas sikoꞌnji ango fihumo noswontɨfi humamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Oseso hofɨko wosopayo nyoꞌne epohumayo sopo humantɨfi Jisas kako wopayo nomanto Anɨtumo isamoyoka ulonto wosopayo hiso nokujonto sikimo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ose uyahonɨngki sikoe tɨmo ehohosɨsyahonɨngki Jisasɨmo yofe uhwoꞌmentisiyefoho. Yofe uhwofahonɨngki Jisas kako imoꞌnaoꞌmentisofoho. Nto imoꞌnaofahonɨngki siko kakimo apaꞌno muhwonɨmmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ose yonji ole hnnɨmentisi, Nekwo kakoꞌnji honɨngkanopo nopontani kako Anɨtuye hungkuno yoloho neso le-etɨhwamopiso soꞌno nekwoe sɨmeho wonyoangkafo emoꞌnɨngkisofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ose hnnɨmentisiyo sohonta siko nolɨkafonji Jelusalemneꞌno asomo umentisiyefoho. Nowenji siko Jisasɨye inomokomoyo aho hufaꞌu hopiꞌnono sɨfe mtaꞌni angaꞌnohino sohwanji nomꞌne aꞌamu hofɨkoꞌnji humamotofo soꞌnjimo uꞌmahonɨngki ");
INSERT INTO apz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","hofɨko sikimo ulɨmentohofi, Ou, nehopi. Nakwoe Hwe Engo nto lɨkoꞌmaho. Kako Saimounɨmo uꞌmahonɨngki Saimoun uhwonɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ose ulahonɨngkofi oso hwe hufaꞌu sohwaꞌu sikimo yoꞌmayo honɨngkanopo uꞌmaꞌmentiso soꞌno ulonji ole ulɨmentisi, Jisas kako wopayo kujonto ejopahonɨngki nekwo kakineꞌno huno eisofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hofɨko oso hungkunoso hnnontanɨngkofi Jisas kako ajwo lopo ntaꞌni imoꞌnoma lohofonto hofɨkoꞌnjo ajwo sopo lohofonto ulɨmento, Sɨmeho wopɨngoꞌnjo fosyohumamno. ");
INSERT INTO apz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ose ulahonɨngki hofɨko yomo yontɨfi iyoho unɨngkanɨngki hnnɨmentohofi, Pehotɨkeno. Mewosotɨkeno. ");
INSERT INTO apz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ose hnnɨngkahonɨngkofi Jisas ulɨmento, Sekwo yomo pehoꞌno epemoꞌnawehofo. Sekwoe sɨmeho moꞌmo huno piꞌnɨngo pehoꞌno seyohoho. ");
INSERT INTO apz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nje sɨfe aho nohonɨngkuji sekwo aho nɨpmmokumno. Ngkonoho. Ngko songo humaleno. Ihwoni. Mewoso sohwa hofɨko aꞌapahoꞌnji yokino soꞌnji ngkimo nohonɨngkohofo paꞌnyoꞌmaho. Oꞌo, mewoso yokino soꞌnji mɨkufo soꞌnji anefoho. ");
INSERT INTO apz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ose ulonto kako kakoe sɨfeꞌnji ahoꞌnji hofɨkimo utɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ose uhwonontɨfi hofɨko kakimo sɨmeho hiꞌntnnono muyilohwono ko syofɨsyontɨfi hofɨko sɨmonyo yontɨfi pisopisaho mjalɨmɨhwanɨngkofi Jisas ulɨmento, Sekwo wosopayo fiso olopo woꞌnnyo hwasilaho. ");
INSERT INTO apz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ose ulahonɨngki hofɨko inanɨku iloho yahumentohofoso umosiyahonɨngkofi ");
INSERT INTO apz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","nomanto nonɨngkahonɨngki hofɨko kakimo tɨmo uhwonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ose uhwonɨngkahonɨngkofi kako hofɨkimo ulɨmento, Hohonta ngko sekwoꞌnji humanji ole selɨmentoho, Yoꞌmayo hungkuno Mouses ngkineꞌno mtɨꞌmokumentiso soꞌnji aꞌamu Anɨtu hungkuno uyahonɨngki ngkineꞌno lɨmotofo sohwafe hungkuno soꞌnji aꞌamu ngkineꞌno Taꞌnjo Iyoswomo mtɨꞌmokumentohofo soꞌnji oso hungkuno hopiꞌnonohino ngkineꞌno mtɨꞌmokumentohofoso ne imoꞌnone soꞌno nto selɨmentohefoho. ");
INSERT INTO apz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ose ulonto hofɨkoe hunomo ehohosɨsyahonɨngki hofɨko Anɨtuye hungkuno ne soꞌno huno itoꞌno umentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ole ulɨmento, Anɨtuye hungkunoso ole nalohi, Kɨlais oso hwe Anɨtu uhwatɨmentiso sohwo tohino engo nomahwosi sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno kako poyo imoꞌnyoso sohwo songo wolɨkaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Oso hungkuno wopɨngoso aꞌamufe honɨngkano wonyo somtaꞌni isɨhutofomayoꞌne hungkuno loso ango Jelusalem sopo ntaꞌni angoꞌmeemo motahumpekuji wolutɨhwafɨkufe. Hungkuno hiso olenoho. Anɨtu kako aꞌamumo wopɨngo ulohoꞌmentiso soꞌno aꞌamu hofɨkoe honɨngkano wonyo somneꞌno nɨhuꞌnahone hohujo ikinjaofɨkujoꞌno Anɨtu hofɨkoe wonyoso wae umoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Sekwo yoꞌmayo homo somo uhwonɨmotofo sohwasi oso hisoꞌno sekwo aꞌamu nomꞌnemo filutɨhwafɨkuno. ");
INSERT INTO apz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Upaꞌnɨmno. Ngko sohwoꞌni oso nje Mpohwo wosejapmmonnoho selɨmentisoso sekuyepono wolɨhwatɨmonnoho. Sekwo olo ango Jelusalem lopo nohumentanɨngkuji ahwomomjo yokumpohnꞌnyoso sekumo woseꞌmaꞌmontonoho. Noseꞌmahwosoꞌno oso hisoꞌnji nakwo nomꞌne angopono wohumpehwano lɨfijoꞌmanji noho fohumpekuno. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Oseso Jisas kako hofɨkimo ipemotawento ango Mpetani sopo uhwojamentisofoho. Oso hopo sopo kakoe aꞌamu somo aho ulonjimokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ulonjimokukwato lohofonto hofɨkimo uhwotɨꞌmofahonɨngki Anɨtu Jisasɨmo ahwomomneꞌno motasɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hofɨko Jisasɨmneꞌno hwomtame nto ulohofontɨfi hofɨkoe sɨmeho wonyoangkafoꞌnjohwa Jelusalemneꞌno asomo pontɨfi sɨmonyo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hofɨko sɨkuno huhwo huhwi Anɨtuye tajo ango engo somo humantɨfi Anɨtuye yofe hoꞌnomaꞌmotofofoho. Lukɨye hungkunoso osohoponoho. ");
INSERT INTO apz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Sɨmoꞌmo neꞌmo nakwoe hwahoꞌnji yoꞌmayo soꞌnji ane sohonta Kɨlais, Anɨtuye hungkuno sohwo kako Anɨtuꞌnji humamentisofoho. Kako songo neꞌno humawoꞌnɨngkiso hweho. Kako huhwo Anɨtuyoho. ");
INSERT INTO apz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Anɨtu kakoe hungkuno sohwoꞌnji kako yoꞌmayo yoꞌmayo hopiꞌnonohinoso mtɨꞌmokumentisofoho. Yoꞌmayo yoꞌmayoso nomꞌne hwapɨngo mtaꞌangoꞌmaho. Oꞌo, kakoꞌnohini yoꞌmayoso hwapɨngo hweho. ");
INSERT INTO apz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kɨlais kako songo neꞌno humayo hwapɨngo sohwo kako songo humayo honɨngkano nejapmmentiso soꞌno kako nakwoe pomponaho hweho. ");
INSERT INTO apz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Oso pomponaho huhwo sohwo kako nakwo aꞌamu hopiꞌnonohino sɨkwoꞌmjohoꞌmo humentanɨngkuhwaso hnꞌnɨmo lonasiyoꞌne hweho. Oso sɨkwoꞌmjoho hiso pomponaho huhwo sohumo mifehuꞌmokonasyonehoho. Oꞌo, oso pomponaho huhwo sohwo neꞌno nolɨwoꞌnɨngkuhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anɨtu kako hwe fihumo uhwatɨmentiso sohwo kakoe yofeso Jounɨyoho. ");
INSERT INTO apz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Joun kako oso pomponaho hisoꞌne aꞌamu hopiꞌnonohino somo ujoꞌne pmmentiso hweho. Aꞌamu hopiꞌnonohinoso oso hungkuno homo somo upaꞌnɨngkuji sɨmeho hiꞌntnnono uyɨfitnneꞌento pmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Joun huhwo sohwo kako pomponaho hwoꞌmaho. Oꞌo, Anɨtu kako oso pomponaho hisoꞌno aꞌamu somo utɨhwayoꞌne Jounɨmo uhwatɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Pomponaho ne hiso kako aꞌamu hopiꞌnonohino hnꞌnɨmo honɨngkano netɨhwayoꞌne lonasiyoꞌnefoho. Oseso Joun kako nohumentanɨngki oso pomponaho ne sohwo imoꞌnonto kako aꞌamumo honɨngkano wopɨngo utɨhwayo hweho. ");
INSERT INTO apz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Anɨtu kakoe hungkuno sohwoꞌnji olo hwaho loso mtɨꞌmokumentiso sohwo olopo nopahonɨngki aꞌamu olo hwaho loponjoso kakimo yofe muhwoꞌmmentohofofoho. Oꞌo, muhwosoꞌnjo yontɨfi monje yahumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kako kakoe hwapɨngopo iꞌmofɨwahonɨngki kakoe temtitofo aꞌamu Jutaso hofɨko kakimo sɨmeho muyoꞌnjo yontɨfi hwotoho hmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","I osoꞌno aꞌamu fehohnjo sohwa hofɨko Kɨlaisɨmo yofe uhwofontɨfi kakoe hungkunomo sɨmeho hiꞌntnnono uyɨmentohofofoho. I aꞌamu hopiꞌnonohinoso hofɨko Kɨlaisɨmo sɨmeho unyo somo Kɨlais kako kakoe yokumpohnꞌnyo uyɨmentiso soꞌno Anɨtuye aꞌamu ne umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Moyaꞌmi sofa hofɨko mehomi aswo mawoꞌnɨngkohofo hopaso aꞌamu Anɨtuye mehomi mmoꞌnɨfitnnehofo. Oꞌo, aꞌamufe yokumpohnꞌnyo mtaꞌni u, aꞌamufe huno mtaꞌni aꞌamu Anɨtuye mehomi ne imoꞌnyoso mmoꞌnɨfitnnefoho. Oꞌo, Anɨtu kako huno ole syafɨhuꞌmento, Aꞌamuso nje hwomumo sɨmeho uyɨkujoꞌmanji hofɨko nje mehomi ne imoꞌnɨfitnnefoho. Ose syafɨhuꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Anɨtuye hungkuno hweho lɨwoꞌnɨngkuhwone sohwo kako aꞌamu imoꞌnonto Kɨlais huhwo sohwo nakwoꞌnjo ajwo lopo humamentisofoho. Nohumanto kako aꞌamu hnꞌnɨmo wopɨngoꞌnohini nalohofonto kako hungkuno neꞌnjoꞌnohini lonetɨhwamentiso hweho. Nakwo aꞌamu fehohnjo hnꞌnwi nakwo Kɨlaisɨye yokumpohnꞌnyo engo somo uhwonontani kakoe yofe engo uhwoꞌmentɨhwonefoho. Oso yofe engoso yokumpohnꞌnyo engoso Anɨtu kakoe Hwomumo uyahonɨngki uhwonontani Anɨtuye Hwomu angaꞌnohino hweho uhwoꞌmentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Joun kako iꞌmofaponto Kɨlais huhwo sohumneꞌno lɨjwaoꞌmentisofoho. Ole lɨjwaoꞌmento, Olo hwe lohumneꞌno ole nto selɨmentohefoho. Ngko sɨmoꞌmo sekumo nto seꞌmaꞌmentohefoho. Tɨfi hwe nomꞌne sohwo noseꞌmahwosi kako nje yofe engomo woniyakoloꞌmontonoho. Hwapɨngoso ngko nje naꞌu aswo monɨmaso sohonta kako songo humamojo hweho. Kakoe yofe engoso ngkimo noniyakolofonefoho. ");
INSERT INTO apz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kako nakumo wopɨngo nalohofoso hwapɨngo hweho. Osoꞌno nakwo wonyoꞌnohino ko hnꞌnɨmo kakoe wopɨngoꞌnohinoso nakumo wopɨngo neꞌno neꞌno nalohofɨwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Hohonta Anɨtu kako neyakwo Mousesɨmo kakoe honɨngkano hungkuno uyɨmentisofoho. Oso honɨngkano hungkuno homo somo aꞌamu ntoꞌno minɨngkammentohofoso hofɨko tohino engo tɨpemaꞌmentohofofoho. I osoꞌno olohonta Jisas Kɨlais kako noneꞌmahonɨngki kako honɨngkano neso nonetɨhwanto kako nakwoe wonyo somjo tohino nomanto kako wopɨngoꞌnohini nalohofɨwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nakwo aꞌamu hwahoponjo hnꞌnwi nakwo Anɨtumo muhwonyoꞌneꞌnwoho. I osoꞌno Anɨtuye Hwomu Angaꞌnohino sohwo kanɨngkwohwoꞌnji nohumanji kako Anɨtuye yahino ne soꞌno nakumo netɨhwawoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Aꞌamu Jutafe hwe engo Jelusalem humamotofo sohwa hofɨko aꞌamu fihwamo Jounɨmneꞌno uhwatɨmentohofofoho. Oso aꞌamu huhwo sohwa hofɨko tajo ango syohoꞌnjo sohwanji aꞌamu tajo ango syohoꞌnjo sohwamo enjwaꞌmo syoho yɨwoꞌnɨngkohofo oso huhwo sohwa Lifaiyoho lɨwoꞌnɨngkohofo, oso hwanji hofɨko Jounɨmo nuꞌmantɨfi ulohonɨmentohofi, Kɨko tɨhwosilo. Anɨtu kako kuhwosopoꞌmentiso sohwosilaho. ");
INSERT INTO apz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ose ulohonɨngkahonɨngkofi Joun kako hungkunoso hiyaso hoꞌnahumentisoꞌmaho. Oꞌo, kako yolohoso ole ulɨmento. Oso hwe Anɨtu aꞌamu Juta sohwonaꞌnɨmo nefoꞌmayoꞌne nɨhwosopoꞌmentiso sohwonɨꞌmaho. Ngko Kɨlaisɨnɨꞌmaho. ");
INSERT INTO apz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ose ulahonɨngki hofɨko ulɨmentohofi, I oseꞌmanji kɨko tɨhwosilo. Kɨko neyakwo Ilaija kulaho. Oꞌo, Ilaijanɨꞌmaho. Ose ulahonɨngki apaꞌno ulɨmentohofi, I kɨko oso hwe engo sohumo Anɨtu hungkuno uyahonɨngkuhwosi wonalɨmonteꞌno hontohumalohwone sohwosilaho. Ose ulahonɨngkahonɨngkofi ulɨmento, Oꞌo, ngko osoho hwoꞌnɨꞌmaho. ");
INSERT INTO apz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ose ulahonɨngki hofɨko ulɨmentohofi, I kɨko tɨhwosilo. Noho fonaso. Oso aꞌamu nonehwatɨmalofo sohwamo kikineꞌno pehofo ulanehwono. Kɨko kikineꞌno pehofo hnnalokuno. ");
INSERT INTO apz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ose ulahonɨngkofi ulɨmento, Hohonta Aisaiya sohumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwo ole lɨmento, Hwaho aꞌamu mohumunyo sopo mampaho engo oleso nohoꞌnonefoho. Nakwoe Hwe Engo sohwo woneꞌmaꞌmontonoho. Kakineꞌno honɨngkano ntoꞌno hmmopmno. Oso hungkuno honɨngkano imofoꞌne sohuneꞌno Aisaiya hohonta lɨmentisoso ngkineꞌno lɨmentisofoho. Joun ose lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Oso aꞌamu Jounɨmo hungkuno ulohonɨmentohofo huhwo sohwamo aꞌamu Falisi sohwa lɨhwatɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Hofɨko Jounɨmo nomꞌne hungkuno ulɨmentohofi, Anɨtu aꞌamu fihumo nefoꞌmayoꞌne uhwosopoꞌmentiso Kɨlais sohwo kɨko oso hwosɨꞌmaho. Kɨko Ilaija kiꞌmaho. Kɨko oso hwe engo sohumo Anɨtu hungkuno uyahonɨngkuhwosi wonalɨmonteꞌne hontohumalohwone sohwosɨꞌmaho. Oseꞌmanji kɨko hwe moyaꞌmi somo mijo pehoꞌne kiyomalokuno. ");
INSERT INTO apz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ose ulohonɨngkahonɨngkofi Joun ulɨmento, Ngko aꞌamu somo mijoꞌnohini kiyomawoꞌnɨngkohono. I osoꞌno hwe fihwo kako sekwoꞌnjo ajwo lopo humaso sohuneꞌno sekwo huno maseyo hweho. ");
INSERT INTO apz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ngko sɨmoꞌmo seꞌmaꞌmentohefoho. Oso hwe tɨfinjo yofe engoꞌnjo sohwo kako nje yofe somo yakoloꞌnnyo hweho. Ngko hwe wonyo sohwoꞌni oso hwe yofe engoꞌnjo yokintahoponjo sohwoe yoꞌmayo momayo ulohofiyoꞌnohino hwoꞌnyoho. Joun ose ulonto kakoe yofe somo monje yahinɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Joun kako oso Mijo Joutan hopo sopo aꞌamu mijo kiyomaꞌmojo sopo oso hungkuno hiso ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Moꞌnɨngkanta Joun kako uhwonɨngkisoso Jisas kako nto pahonɨngki uhwononto aꞌamu kakoꞌnjoponjo somo ulɨmento, Sekwo uhwonɨmno. Olo hwe lohwo Anɨtuye Yahu Sipsip Paꞌnyo hweho. Hwapɨngoso kako nakwo hwe moyaꞌmi hwahoponjo hnꞌnwiye yahino wonyo somjo tohino mayoꞌne poyo imoꞌnyoꞌne hweho. ");
INSERT INTO apz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Olo hwe lohumneꞌno ngko ole nto selɨmalefoho. Ngko sɨmoꞌmo sekumo nto seꞌmaꞌmentohefoho. Tɨfi hwe nomꞌne sohwo noseꞌmahwosi kako ngkimo woniyakoloꞌmontonoho. Hwapɨngoso ngko nje naꞌu aswo monɨmaso sohonta kako songo humamojo hweho. Kakoe yofe engoso ngkimo noniyakolofonefoho. Ose nto selɨmalefoho. ");
INSERT INTO apz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Hohonta olo hwe Anɨtu nakwoe hwahopo nefoꞌmayoꞌne uhwatɨmentiso lohumo ngko huhwoꞌni yofe mɨhwoꞌmmalefoho. I osoꞌno kakoe honɨngkano itoꞌno esyohumayo soꞌno ngko aꞌamu Juta somo mijo kiyomawoꞌnɨngkohe hwoꞌnyoho. Osoꞌno olo hwe lohwo iꞌmofapɨhwosoꞌno hofɨko kakimo yofe uhwofantɨfeho. Hofɨkimo itɨhwayoꞌne hwoꞌnyoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Joun kako uhwonɨmentiso soꞌno oso aꞌamu huhwo sohwamo ole ulɨmento, Ngko nuhwononji ole uhwonɨmalefoho. Anɨtuye ango ahwomo mtaꞌni kakoe Towahuno Wopɨngo yɨhufo ntolofiyo paꞌnyoso noponto olo hwe lohumo nto kehumahoho. ");
INSERT INTO apz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Oso hohosohonta ngko oso hwe huhwo sohumneꞌno huno manimmasofoho. I osoꞌno Anɨtu kako aꞌamumo mijo kiyomayoꞌne lonɨhwatɨmentiso sohwo ole ntɨmento, Hwangku kɨko Anɨtuye Towahuno Wopɨngo ahwomo mtaꞌango nopɨhwosi hwe fihumo kehumaso sohumo uhwonɨngkohoji kɨko huno ole wakiyono. Kɨko aꞌamumo mijo kiyomamꞌntnno hopaso oso hwe huhwo sohwo kako nje Towahuno aꞌamumo uhulaꞌmoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ose ntɨmentiso soꞌno olohonta ngko nuhwononji ole selalokweno. Olo hwe lohwo kako Anɨtuye Hwomu hweho. Joun ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Moꞌnɨngkanta Jounjanji kakoe inomokomoyo hufaꞌu sohwaꞌuꞌnji nohumantɨfi Jisasɨmo uhwonɨmentohofofoho. Jisas kako hano emoyontanɨngki Joun kakoe inomokomoyo sohwaꞌumo ole ulɨmento, Siko uhwoninyo. Oso hwe sohwo kako Anɨtuye Yahu Sipsip Paꞌnyo sohwo aꞌamufe wonyo somjo tohino mayoꞌne poyo imoꞌnyoꞌne hweho. ");
INSERT INTO apz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Joun ose ulahonɨngki siko oso hungkunoso upaꞌnonji Jisasɨmo tɨfi inɨngkamentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas kako ikinjaofonto uhwonɨngkisoso siko nto inɨngkopahonɨngki uhwononto ulɨmento, Siko pehoꞌno wotɨpeenji hwahusilo. Ose ulohonɨngkahonɨngki siko ulɨmentisiyo, Hwe Engofo, kɨko Anɨtuye hungkuno nalɨwoꞌnɨngkino sohwosi, kɨko ango ntɨpo humawoꞌnɨngkino hwosilo. ");
INSERT INTO apz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ose ulahonɨngki Jisas ulɨmento, Siko uhwonanjiꞌmanji eꞌwano. Noho fɨpinyo. Ose ulonto Jisas kako sikimo ipemotowahonɨngki siko Jisas humawoꞌnɨngkiso ango somo uhwonɨmentisiyoso osopo kakoꞌnji humamentisiyefoho. Hwapɨngoso mofehiꞌnyo akupoꞌnyo (4 kɨlouk) sɨkuno soꞌnjoho. ");
INSERT INTO apz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Oso hwe hufaꞌu sohwaꞌu Jounɨye hungkunomo upaꞌnonji Jisasɨmo inɨngkawomentisiyo sohwaꞌu angaꞌnohino sohwo kakoe yofeso Entɨluyoho. Saimoun Pitafe konɨngkwaꞌwehweho. Nomꞌnihwo ngko Jounꞌni olo hungkuno loso mtɨꞌmokalokweno. ");
INSERT INTO apz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Entɨlu kako komoꞌno nowento kolaꞌwehwo Saimounɨmo tɨpɨhwononto ulɨmento, Nakwo oso hwe Anɨtu nefoꞌmayoꞌne uhwosopoꞌmentiso sohumo nto tɨpɨhwonɨngkuhwono. Kako Kɨlaisɨyoho. ");
INSERT INTO apz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Entɨlu ose ulonto kako Saimounɨmo Jisasɨyepono ipemotowahonɨngki Jisas kako nuhwononto Saimounɨmo ulɨmento, Kɨko Saimoun sohwosi Jounɨye hwomu hwosoho. Yofe songo womeekilɨmo. Sifas kiyoho. Ose ulɨmentisofoho. Oso Juta sohwafe hungkuno Sifasɨyoho Ngkɨlik hungkunoso ole Pitafoho. Hungkuno hwapɨngo neso sojo hweho. ");
INSERT INTO apz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Moꞌnɨngkanta Jisas kako hwaho Ngkalilineꞌno wamonto kako Filipɨmo uswoꞌnonto ulɨmento, Kɨko ngkimo nnɨngkape. ");
INSERT INTO apz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip kakoe pone Mpetɨsaitantaꞌango hweho. Oso ango hopo sopo sikoꞌnɨkwaꞌi Entɨluꞌnji Saimounꞌnji humamojiyoponoho. ");
INSERT INTO apz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip kako Notaniyelɨmo tɨpɨhwononto ulɨmento, Oyomo. Hohonta Mouses kako Anɨtuye honɨngkano hungkuno mtɨꞌmokonto kako hwe fihwo Anɨtu nefoꞌmayoꞌne uhwosopoꞌmentiso soꞌno mtɨꞌmokumentisofoho. Aꞌamu Anɨtu hungkuno uyahonɨngki lɨmotofo sohwantnneꞌno olo hwe huhwo sohumneꞌno ifalifaliyo mtɨꞌmokumentohofofoho. Oso hwe huhwo sohumo ngko nto tɨpɨhwonɨngkohono. Kako Jisas sohwo pone Nasaletnntaꞌango hweho. Jousepɨye hwomu hweho. Oyomo. Uhwonayo. ");
INSERT INTO apz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ose ulahonɨngki Notaniyel ulɨmento, Oꞌo, aꞌamu Nasalet sohwa wopɨngo hwaꞌmaho. Hwe wopɨngo oso ango sopo ntaꞌni pipi imoꞌnoneto. Ose ulahonɨngki Filip ulɨmento, Oyomo. Hungkuno nehopi kilalokweno. Kɨko uhwonae. ");
INSERT INTO apz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Notaniyel kako Jisasɨyepono pontahonɨngki Jisas kakimo uhwononto nomꞌne aꞌamu somo kakineꞌno ulɨmento, Sekwo oso hwe sopalokunjo sohumo uhwonɨmno. Oso aꞌamu Isɨlael sohwo wopɨngoꞌnohini hweho. Kako hwasyo honɨngkanoso ane hweho. ");
INSERT INTO apz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jisas ose ulahonɨngki Notaniyel kako nupaꞌnonto Jisasɨmo ulohonɨmento, Kɨko ngkineꞌno huno pipi kiyahonɨngki nohonɨmaꞌnɨngkohino. Ose ulohonɨngkahonɨngki Jisas ulɨmento, Jɨje angomoꞌmo kɨko iyo fisayo pmpongo somo nohumentanɨngkini Filip kako mokohonontanɨngki ngko kakiꞌno kohonɨmaꞌnɨngkohefoho. ");
INSERT INTO apz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ose ulahonɨngki Notaniyel ulɨmento, Nje Lontɨhwayo sohwosi, hungkuno lonetɨhwayo sohwosi, kɨko Anɨtuye Hwomu hwosoho. Kɨko nakwo Isɨlael sohwonaꞌniye Hwe Engo Ne hwosoho. ");
INSERT INTO apz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ose ulahonɨngki Jisas ulɨmento, Kɨko fisayo pmpongo somo nohumentanɨngkini kohononji kilohe soꞌno kɨko sɨmeho hiꞌntnnono ntapohino soꞌno hwangku yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso ngko iꞌmeꞌno kɨko uhwonɨmonnoho. ");
INSERT INTO apz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ose ulonto aꞌamu hopiꞌnonohino somo ulɨmento, Hungkuno nehopi selalokweno. Ahwomo nohwosompoꞌnawehwosi Anɨtuye aꞌamu ahwomomjo sohwa Ngko Aꞌamufe Hwomu nɨhwosopoꞌmentiso sohwoꞌniyepono nopɨkuji nosɨkuji yontanɨngkuji sekwo uhwonɨfitnnefoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Sɨkuno hufaꞌu sɨhune memjaofahonɨngki oso hwaho Ngkalili ango Kana sopo hwe fihwo kako ape mayoꞌne sɨkuno somo kakoe aꞌamu uhuꞌmokufitnneꞌento joho ulɨmentisofoho. Oso ape mayoꞌne ango homo somo Jisasɨye konaꞌwohi humamentisofoho. Jisas kakoꞌnji kakoe inomokomoyo sohwanji hofɨkoꞌnji uhuꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Oso hopo sopo aꞌamu piꞌnɨngo engo uhuꞌmokumentohofoso hofɨko oso ape mayo somjo ipisayo mijo pompenjiyo wainɨso moiꞌwo nto naofahonɨngkofi Jisasɨye konaꞌwohi Jisasɨmo ulɨmento, Hofɨkoe mijoso moiꞌwonoho. ");
INSERT INTO apz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ose ulahonɨngki Jisas ulɨmento, Naꞌu, kɨko ngkimo pehoꞌno ntohino. Nje yokumpohnꞌnyo aꞌamu somo ujo ehontojwasiyoꞌne sɨkunoso mmoꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ose ulahonɨngki konaꞌwohi oso aꞌamu ango homo somjo syoho ulohofiyo sohwamo ulɨmento, Jisas kako sekumo yoꞌmayo peho pehoꞌne selɨhwosoꞌno u, sekwo halohoꞌno fiyɨmno. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Oso ango hopo sopo hwakwontoho engo aho fehohntaꞌni hopiꞌnono nomꞌne mtaꞌni angaꞌnohino woꞌnnyoponoho. Oso hwakwontoho engo hiso aꞌamu Jutaso hofɨkoe yahinoso ole aho mijo yatɨjuyoꞌne hungkuno woꞌnnyofoho. Oso hiso olenoho. Nakwo oso honɨngkano hungkuno homo somo itoꞌno inɨngkowalokuhwone soꞌno nakwo hnꞌnwi honɨngkano wonyo aneꞌnwoho. Ose syafɨhuꞌmentohofofoho. Osoꞌno hwakwontoho mijo ihmꞌmofahinyoso oso ango homo somo woꞌnnyoponoho. Oso hwakwontoho mɨkunɨmposofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas kako syoho ulohofiyo sohwamo ulɨmento, Sekwo hwakwontoho somo mijo mangonepo fihmꞌmopmno. Ose ulahonɨngki aꞌamu huhwo sohwa hofɨko mijo mangonepo ihmꞌmoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Moiꞌwo ihmꞌmofahonɨngkofi Jisas ulɨmento nosisyasyɨkuji nomotakuji oso wosopayo mokosyohumayo nongkumo uyɨmno. Ose ulahonɨngki hofɨko sohumemotamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Oso hwe engo wosopayo mokosyohumayo sohwo oso mijo hiso munɨngkonɨmentisoso mijo meꞌwampeꞌnjo wain munɨngkonɨmentisofoho. Oso hiso hwapɨngo soꞌno kako huno mummentisofoho. Oseso oso syoho ulohofiyo sohwa hofɨko ahuꞌmo mijo ihmꞌmoꞌmentohofo soꞌno huno umentisofoho. Oseso oso hwe engo wosopayo mokosyohumayo sohwo kako oso hwe ape mayoꞌne sohuneꞌno joho ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Oseso olo hwe engo sohwo ape mayo sohumo ulɨmento, Aꞌamu hofɨko wopayo engo iloho yanɨwoꞌnɨngkohofo sohwa hofɨko aꞌamu hopiꞌnonohino somo mijo meꞌwampeꞌnjo wainɨso kakiꞌno uyɨkuji hwangku hofɨko oso mijoso sɨmeho uhnnɨngkuhwosoꞌno oso mijo wain wonyo weꞌeso tɨfi wanɨfe. I osoꞌno kɨko oso yahinoso momahoyohino. Oꞌo, kɨko mijo meꞌwampeꞌnjo wonyoangkafoso nowentanɨngki sɨmoꞌmo mijo wonyo weꞌe motapohinoso nto nɨngkuhwonefoho. I moiꞌwo nontani humentanɨngkuhwoni kɨko mijo wonyoangkafo meꞌwampeꞌnjo motaponji nejapohino. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Oso syoho sɨmoꞌmjo Jisas imentiso paꞌnyoso aꞌamu hwahoponjo sohwa mifitnnefoho. Oso syoho sɨmoꞌmjo hiso Jisas kako hwaho Ngkalili anga Kana hopo sopo imentisofoho. Oseso Jisas kakoe yokumpohnꞌnyo soꞌnji kakoe yofe engoꞌnji aꞌamu somo ujo ehontojwahumentisofoho. Jisas kakoe inomokomoyo sohwa oso homo somo uhwonontɨfi hofɨko Jisasɨmo sɨmeho hiꞌntnnono umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Oso hiso moiꞌwo imoꞌnɨngkahonɨngki Jisas ango Koponeyam soponeꞌno homnɨngkwaꞌwehwosanji konaꞌwohijanji kakoe inomokomoyo sohwanji womentohofofoho. Osopo sɨkuno fehohnjo somo humamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Oso Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo sɨkuno engo lɨwoꞌnɨngkohofoso mofonepo umoꞌnɨmonto yahonɨngki Jisas kako ango Jelusalem soponeꞌno sɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Osopo iꞌmofawento kako tajo ango angiyohoꞌmo uhwonɨmentisoso yahu mpulɨmokau sipsipɨꞌnji yɨhufo oso huꞌmesyontanɨngkofi uhwonɨmentisofoho. Osoꞌnji aꞌamu ahuꞌmo hamniyoho uyontɨfi nomꞌne hamniyoho kengoso asomo ikuwoloꞌmokomayo yontɨfi hofɨkoe ijempoho sopo nohumentanɨngkofi uhwonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jisas oso homo somo nuhwononto yahino wonyofoho lonto impe nomanto nopopojonto sipsipɨꞌnji mpulɨmokau osoꞌnji mofonjiyohotoꞌmɨhwatɨꞌmentisofoho. Nomꞌne aꞌamu hamniyoho ikuwoloꞌmokomayo syohoꞌnjo sohwafe hamniyohoso iwontoꞌmeeofonto ijempoho soꞌnji fonjojohokuꞌmeeoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ose yonto Jisas oso aꞌamu yɨhufomneꞌno hamniyoho aꞌamu mtaꞌni mawoꞌnɨngkohofo sohwamo ulɨmento, Sekwoe yɨhufo nomafɨkuji mpanɨmno. Sekwo olo nje Mpohwoe ango loso sekwoe hoꞌyango ango imofoꞌneꞌmaho. Mpanɨmno. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Hwangku sohonta Jisas ose imentiso soꞌno kakoe inomokomoyo sohwa hofɨko huno ikwesyafɨhuꞌmentohofo sohonta hungkuno angaꞌno Ntefit Jisasɨmneꞌno mtɨꞌmokumentiso Anɨtuye hungkunomo woꞌnnyo soꞌneꞌno syafɨhuꞌmentohofofoho. Hungkuno hiso olenoho. Ngko oleneꞌno nɨmoꞌnɨngkohoho. Jɨje ango kiho ane wopɨngoꞌnohini wentɨhwone soꞌno nɨmoꞌnɨngkohoho. Oso hisoꞌno ngko yokumpohnꞌnyo kemokosyohumamesoꞌno wonyo nɨmokufitnnefoho. Inomokomoyo sohwa oso hungkuno homo somneꞌno huno syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jisas kako yoꞌmayo yoꞌmayo Anɨtuye ango mtaꞌni wae yaoꞌmentiso somo aꞌamu Juta sohwafe hwe engo sohwa uhwonontɨfi sɨmeho tohino umnɨngkahonɨngki Jisasɨmo ulɨmentohofi, Olo hiloso tɨhwo kilisomo yohinoto. Kɨko yoꞌmayo wonyoangkafo nakwo miyɨwoꞌnɨngkuhwoneso uyɨmneꞌnoꞌmanji u, nakwo huno wonayono. Olo yokumpohnꞌnyo loso Anɨtu mtaꞌni maꞌmasofoho huno wonaimontonoho. ");
INSERT INTO apz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ose ulahonɨngkofi Jisas ulɨmento, Oloꞌnohini wosetɨhwamonneꞌno yohono. Sekwo olo Anɨtuye ango lomo wae yaopijoꞌmanji sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno ngko apaꞌno ango hiso nulɨkoꞌmnefoho. ");
INSERT INTO apz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ose ulahonɨngki aꞌamu Juta sohwa ulɨmentohofi, Olo ango syoho neꞌno yontanɨngkuhwoni soswo fouti-sikɨs (46) neyakoloꞌmentisofoho. I osoꞌno kɨko sɨkuno hufaꞌu sɨhune memjaofɨhwosoꞌno kɨko apaꞌno mojoso hopolaho. Awonoho. Kɨko hopoꞌmaho. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","I osoꞌno oso ango hisoꞌno Jisas ulɨmentisoso kakoe aꞌapahomneꞌno pahnnɨmo hungkuno hnnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hwangku sohonta Jisas kako poyo imoꞌnɨngkahonɨngki Anɨtu apaꞌno songo ulɨkaꞌmentiso sohonta Jisasɨye inomokomoyo sohwonaꞌni olo hungkuno Jisas nalɨmentiso somneꞌno huno ikwesyafɨsyontani yoꞌmayo hungkuno Anɨtuye iyoswo somo aꞌamu mtɨꞌmokumentohofo soꞌnji yoꞌmayo hungkuno Jisas nalɨmentiso somneꞌno sɨmeho hiꞌntnnonohino umentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Oso Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo sɨkuno engo somo hofɨko elɨjwonontanɨngkofi Jisas kako ango Jelusalem sopo nohumentanɨngki aꞌamu piꞌnɨngo sohwa uhwonɨmentohofoso Jisas yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso yontanɨngki uhwonontɨfi ole hnnɨmentohofi, Olo hwe lohwo Anɨtu mtaꞌango ne hweho. ");
INSERT INTO apz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ose ko hnnɨngkahonɨngkofi Jisas kako huno ole syafɨhuꞌmento, Aꞌamu fehohnjoso hofɨko sɨmeho hiꞌntnnono nehopi montapeꞌnjo yalokwofo. Ose syafɨhuꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hwapɨngoso Jisas kako aꞌamu hopiꞌnonohino sofe sɨmeho ne moꞌmo huno unyo hweho. Aꞌamufe yahino somneꞌno nomꞌnihwa Jisasɨmo mulɨfitnnefoho. Oꞌo, kako aꞌamufe huno ikwesyafɨsyɨwoꞌnɨngkohofo soꞌno kako huno unyo hweho. Oseso hofɨko olo hwe lohwo Anɨtu mtaꞌango ne hweho, ko hnnɨngkahonɨngkofi Jisas kako sɨmonyo miyofoho. Hwapɨngoso hofɨko huno ukwesyafɨsyontɨfeho unɨngkanɨngki kako tɨmoꞌnohini uhwonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hwe fihwo kakoe yofe Nikoutemos kako aꞌamu Falisi sohwafe honɨngkanomo inɨngkamojo hweho. Kako aꞌamu Jutafe hwe engo hweho. ");
INSERT INTO apz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sɨkuno fihumo sɨkwoꞌmiyomo Nikoutemos kako Jisasɨmo nuꞌmanto ulɨmento, Nje Lontɨhwayo sohwosi, Anɨtu kako kikimo kakoe hungkuno lonetɨhwayoꞌne lokuhwatɨmentiso hwosoho. Oso hisoꞌno nakwo huno nayohoho. Anɨtu kako kɨkoꞌnji mohumayontentesi kɨko yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso miyohotnnesohilo. Oꞌo, Anɨtu kɨkoꞌnji humaho. ");
INSERT INTO apz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ose ulahonɨngki Jisas ulɨmento, Hungkuno nɨhuꞌno nehopi wakilɨmonneꞌno yohono. Kɨko upaꞌnyo. Aꞌamu fihwo konaꞌwohi aswo maꞌmentiso hopaso kako songo apaꞌno mmoꞌno soꞌmanji kako Mpohwo Anɨtumo enjwaꞌmo humayo somo motɨpɨhwononefoho. ");
INSERT INTO apz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ose ulahonɨngki Nikoutemos ulɨmento, I, aꞌamu fihwo kako aꞌmane nto imoꞌnnyo sohwo kako apaꞌno songo imoꞌnyoso pipilo. Kako konaꞌwohiye aswo moꞌmo swomnawesoso apaꞌno aswo mayoso pipilo. Osoꞌno kɨko filontɨhwaho. ");
INSERT INTO apz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Ose ulahonɨngki Jisas ulɨmento, Hwe fihwo konaꞌwohi aswo mayo sohonta kako aꞌapahoꞌnjo imoꞌnnyo hweho. I oso hwe huhwo sohumo Anɨtuye Towahuno Wopɨngo ehuhnnamoꞌnnyo sohwo kako towahuno songoꞌnjo hweho. Kako aꞌamu songo paꞌnyo imoꞌnnyo hweho. Hungkuno nehopi wakilɨmneꞌno yohono. Aꞌamu mijoꞌnji towahunoꞌnji songo mumokoso sohwo kako Anɨtumo enjwaꞌmo humayoso motɨpɨhwononefoho. ");
INSERT INTO apz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kɨko songo apaꞌno hmmoꞌnyo kilohe soꞌno yomo yohotoho. ");
INSERT INTO apz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ihwoni. Ifofoso kakoe yahinomnohini inɨngkawowoꞌnɨngkisofoho. Oso ifofo huhwo sohwo kengo kengo noꞌmeemo mjɨmɨwowoꞌnɨngkohoho. Kɨko ifofo neso muhwonhnnehino. Oꞌo, moꞌmayoꞌnohini uhwonɨhwajɨwoꞌnɨngkino. Ifofo hiso ntɨꞌmtaꞌni iꞌmofapinyoto. Ntonte ehusasyɨwoꞌnɨngkohoho. Oꞌo, kɨko huno makiyonehoho. Oso hopaso Anɨtuye Towahuno sohwo kako aꞌamu fihumo songo apaꞌno umokiyoso pipi imoꞌnoneto. Oꞌo, kɨko huno makiyofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ose ulahonɨngki Nikoutemos Jisasɨmo ulɨmento, Olo ntohino loso pipi iꞌmofaponeto. ");
INSERT INTO apz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ose ulahonɨngki Jisas ulɨmento, Kɨko aꞌamu Juta somo Anɨtuye hungkuno lutɨhwayo yofe engoꞌnjo sohwosi olo hungkuno losomneꞌno kɨko huno ntoꞌno mehohosakisiyotaho. ");
INSERT INTO apz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Hungkuno nehopi kilalokweno. Aꞌamumo hungkuno lutɨhwawoꞌnɨngkuhwone hnꞌnwi nakwo yoꞌmayo huno nayo soꞌnji yoꞌmayo tɨmo uhwonyo soꞌntnneꞌno ulɨwoꞌnɨngkuhwone hwonaꞌnyoho. I osoꞌno aꞌamu Jutaso yoꞌmayo hungkuno ulontane somo sɨmeho muyoꞌnjo yontɨfi hohujo ikinjaofalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","I ngko yoꞌmayo olo hwaho loponjo iꞌmofopalokunjo soꞌno selahonɨngko sekwo oso hungkuno homo somo sɨmeho hiꞌntnnono muyoꞌnjo yalokwofoꞌmanji ngko yoꞌmayo yoꞌmayo ahwomomjo iꞌmofopalokunjo soꞌno selɨꞌmeꞌno sekwo huno pipi waseimontolo. ");
INSERT INTO apz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aꞌamu hwahoponjo fihwo kako ahwomomo masiyofoho. Osoꞌno aꞌamu tɨhwo waselɨmontolo. Ngko yoꞌmayo yoꞌmayo ahwomo somjo wojoso uhwonɨngkohono eso tɨhwo waselɨmontolo. Osenoho esofo. Oꞌo, awonoho. Ngkoꞌnohini Aꞌamufe Hwomu sohwoꞌni ahwomomo humanji pmmentohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hohonta neyakwosa sohwa hwaho wonyo aꞌamu mohumunyopo nohumentanɨngkofi Mouses kako homa huyoꞌmango mtɨꞌmokonto tokemo montitofosyahonɨngki aꞌamuso oso homa somo uhwonontɨfi Anɨtuye yofe hoꞌnomaꞌmentohofoso songo humamentohofofoho. Oso paꞌnyoso hwangku ngko Aꞌamufe Hwomu sohwoꞌnɨmo iyo hwojiyahofɨkuꞌnnyo sopo fonjintoꞌofanɨhufitnnefoho. ");
INSERT INTO apz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Aꞌamu hopiꞌnonohinoso ngkimo sɨmeho hiꞌntnnono ntapɨfijoso hofɨko songo wopɨngo neꞌno nohumantokutnnefoho. ");
INSERT INTO apz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ose ulɨkwato lohofonto ulɨmento, Anɨtu kakoe Hwomu nɨhuꞌno angaꞌnohino sohwoꞌni humaleno. I osoꞌno Anɨtu kako sekwo aꞌamu hwahoponjo hopiꞌnonohino sokuneꞌno sɨmeho mɨkunɨmposo sejapmmentiso soꞌno kako ngkimo sekuyepono lonuhwatɨmentisofoho. Oseso aꞌamu ngkimo sɨmeho hiꞌntnnono ntapɨfijoso hofɨko hofɨkoe wonyomneꞌno tohino mayoꞌneꞌmaho. Oꞌo, hofɨko songo neꞌno engolopohamo humayoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anɨtu kako ngkineꞌno ole mosyanɨfɨsiyoꞌnjo yonto olo hwaho loponeꞌno lonɨhwatɨmentono. Nje Hwomu sohwo kako aꞌamufe honɨngkano wonyoꞌne tohino engo uhumnɨmontonoho. Oso hunoso mosyanɨfɨsiyoꞌnjo imentisofoho. Oꞌo, aꞌamu hofɨkoe honɨngkano wonyo somo humentanɨngkuji hofɨkoe wonyomjo tohino mafɨkutnnehonto kako hofɨkimo isɨhutofomayoꞌne ngkimo lonɨhwatɨmentiso hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aꞌamu ngkimo sɨmeho hiꞌntnnono ntapinyoso hofɨko tohino hofɨkoe wonyomneꞌno mayoꞌneꞌmaho. I osoꞌno aꞌamu ngkimo tɨfi monnɨngkapeꞌnjo yontoso sohwo kakoe tohinoso mayoꞌne hweho. Hwapɨngoso kako Anɨtuye Hwomu Angaꞌnohino sohwoꞌnneꞌno sɨmeho hiꞌntnnono montapmmojo hweho. ");
INSERT INTO apz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Oso tohino mayo hwapɨngoso olenoho. Pomponaho honɨngkano wopɨngo wonyoangkafo somo utɨhwayoꞌne nto pmmentisofoho. I osoꞌno aꞌamu fehohnjo hofɨkoe honɨngkano wonyo soꞌnji hwahoponjo yahino wonyo soꞌntnneꞌno umoꞌnɨngkahonjoso ole lɨwoꞌnɨngkohofofoho. Nakwo pomponaho somo inɨngkayoso nakwolaho. Oꞌo, sɨkwoꞌmjohoꞌmo wohumentɨhwano lontɨfi iwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Aꞌamu honɨngkano wonyomo aho yokumpohnꞌnyo kemokosyohumalofoso hofɨko pomponaho hisoꞌno mangohwa imoꞌnɨwoꞌnɨngkohofofoho. Hofɨkoe yahino wonyoso pomponahoꞌnjo sopo aꞌamu uhwonɨfitnnohontɨfi pomponaho soꞌno iꞌwaho yontɨfi sɨkwoꞌmjohoꞌmo humawoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","I osoꞌno aꞌamu Anɨtuye honɨngkanomo tɨfi nehopiꞌnohini inɨngkuwalokwofoso hofɨko pomponaho hopo sopo nto iꞌmofapontɨfi osopo humolawotofo. Hofɨko oso pomponaho sopo nohumentanɨngkofi aꞌamu hofɨkoe yahino soꞌnji yoꞌmayo syoho iwoꞌnɨngkohofo soꞌntnneꞌno uhwonontɨfi Anɨtuye yokumpohnꞌnyoꞌnji yalokwofo hnnɨmentohofofoho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Oso hohosohonta Jisas kakoe inomokomoyo sohwonaꞌnnonji nakwo oso hwaho Jutiya soponeꞌno umentɨhwonefoho. Oso hopo sopo Jisas nakwoꞌnji nohumentani nakwo hwe moyaꞌmi somo mijo kiyomaꞌmentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Joun kako pone Ainoun Salimmjo mofone sopo humanto kako huhwo aꞌamu somo mijo kiyomaꞌmentisofoho. Oso ango hopo sopo mijo engoso hiꞌnjoponoho. Aꞌamu sohwa kakimo uꞌmahonɨngkofi kako mijo kiyomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Oso hohosohonta hwe engo hwaho mokosyohumayo sohwo Helout kako Jounɨmo impoꞌango somo impe mintofasiyofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sɨkuno fihwi Joun kakoe inomokomoyo sohwanji pone Ainoun nohumentanɨngkofi aꞌamu Juta angaꞌnohino sohwo hofɨkimo uꞌmanto aꞌamu Jutafe honɨngkano wopɨngo imokinyoꞌne yoꞌmayoso mijo yatɨkuꞌnyo yahino soꞌno yoka hungkuno hosi Jounɨye inomokomoyo sohwanji hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Oseso Jounɨye inomokomoyo sohwa hofɨko Jounɨmo uꞌmantɨfi ulɨmentohofi, Nakwoe lonetɨhwayo sohwosi, kɨko upaꞌnyo. Oso hwe Mijo Joutan nongkihntaꞌni kɨkoꞌnji humamentiso sohuneꞌno kɨko kakineꞌno hungkuno lɨjwaoꞌmentohino sohwo kako huhwo aꞌamumo mijo kiyomalofoho. Osoꞌno aꞌamu hopiꞌnonohinoso kakiyepono walokwofo. ");
INSERT INTO apz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ose ulahonɨngkofi Joun ulɨmento, Anɨtu ahwomomo humaso sohwo kako aꞌamu angaꞌno angaꞌnohino somo hofɨkoe syohoso muyoꞌnjo yontentesi hofɨko syoho aneꞌnjoꞌnesohilo. Aꞌamu Jisasɨyepono walokwofo soꞌno nakwo huno nayohoho. Anɨtu kako Jisasɨmo oso syoho hiso uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Olo hungkuno hohonta selɨmentohe loso nto upaꞌnɨmentohofo, Ngko Kɨlais oso hwe Anɨtu nakwoe hwahopo aꞌamumo ufoꞌmayoꞌne lɨhwajone sohwonɨꞌmaho. Oꞌo, aꞌamu oso hwe huhwo sohwoepono ufitnne honɨngkanoso itoꞌno esyohumayoꞌneso Anɨtu lonɨhwatɨmentiso hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ose ulonto pahnnɨmo hungkuno ulɨmento, Hwe fihwo kako ape songo maso sohonta apesi kakoe hwehwoepono uhwosoꞌno oso hwe huhwo sohwoe aꞌamuso hofɨko kakineꞌno sɨmeho wopɨngo wonyoangkafo umoꞌnɨmontonoho. Oso paꞌnyoso ngko Jisasɨye aꞌamu sohwoꞌni uhwonɨngkoheso aꞌamu piꞌnɨngo Jisasɨyepono walokwofo soꞌno uhwononji nje sɨmeho wopɨngo wonyoangkafo nto nɨmoꞌnɨmaho. ");
INSERT INTO apz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jisasɨye yofeso engo imoꞌnonefoho. Ngko kakimo enjwaꞌmo humahonɨꞌmo nje yofeso monje wantohoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ose ulɨkwato lohofonto ole ulɨmento, Hwe ahwomo mtaꞌango sohwo kako nakwo aꞌamu hwahoponjo hopiꞌnonohino hnꞌnɨmo yakoloꞌnnyo hweho. Aꞌamu olo hwaho lopontaꞌangoso olo hwaho loponefoho. Hofɨko yoꞌmayo olo hwaho loponjo soꞌno lɨwoꞌnɨngkohofofoho. Hwe ahwomo mtaꞌango sohwo kakoe yofe engoso yoꞌmayo hwahoponjo somo hwofiloꞌnnyo hweho. ");
INSERT INTO apz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Oso hwe huhwo sohwo kako yoꞌmayo yahino wopɨngo kanɨngkwohwoe ango wopɨngo sopo uhwonɨmentiso soꞌnji yoꞌmayo upaꞌnɨmentiso soꞌntnneꞌno lonetɨhwawoꞌnɨngkiso hweho. I osoꞌno aꞌamu fehohnjo sohwa oso hungkuno lonetɨhwawoꞌnɨngkiso homo somo nupaꞌnontɨfi aho yokumpohnꞌnyo mokemokosyohumayoꞌnjo iwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Aꞌamu oso hungkuno homo somo aho yokumpohnꞌnyo kemokosyohumunyo sohwo kako hungkuno homo somo sɨmeho uyonto Anɨtu kako nehopeho linyo hweho. ");
INSERT INTO apz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Oso aꞌamu nakwoe hwaho loponeꞌno Anɨtu lɨhwatɨmentiso sohwo kako Anɨtuye hungkuno nalɨwoꞌnɨngkiso hweho. Hwapɨngoso Anɨtuye Towahuno Wopɨngo sohwo oso hwe huhwo sohumo ifehuꞌmokahumentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mpohwo Anɨtu kako kakoe Hwomu huhwo sohumo sɨmeho uyonto yoꞌmayo hopiꞌnonohinoso kakimo enjwaꞌmo hoꞌnahumentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aꞌamu fihwo kako Anɨtuye Hwomu sohumo sɨmeho hiꞌntnnono uyoso sohwo kako songo neꞌno wonyoangkafo humayoꞌne hweho. I aꞌamu Anɨtuye Hwomu sohwoe hungkunomo tɨfi minɨngkayoꞌnjoso hofɨko Anɨtumo enjwaꞌmo humayo somo motɨpɨhwonɨfitnnefoho. Oꞌo, hofɨkoe wonyomneꞌno tohino mayoꞌnefoho. Hofɨkineꞌno Anɨtuye sɨmeho tohino uhmnonefoho. Joun ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Oso hohosohonta aꞌamu Falisi sohwa hofɨko olo hungkuno upaꞌnɨmentohofi, Aꞌamu piꞌnɨngo engo Jisasɨye inomokomoyo imoꞌnɨngkahonɨngkofi Jisas hofɨkimo mijo kiyomaꞌmentisofoho. Oso inomokomoyo huhwo sohwa Jounɨye inomokomoyo sohwamo yakoloꞌnnyo hwafoho. Ose upaꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ose ko upaꞌnɨmentohofoso Jisas huhwo kako aꞌamu somo mijo makiyomasoꞌnjo hweho. Oꞌo, kakoe inomokomoyo sohwonaꞌni aꞌamu somo mijo kiyomaꞌmentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Oso hungkuno homo somo aꞌamu Falisi sohwa upaꞌnɨmentohofo soꞌno Jisas kako huno uyahonɨngki kako oso hwaho Jutiya hopo sopo ulɨkoꞌmanto kako hwaho Ngkalilineꞌno wawomneꞌno yohono lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ose lonto kako honɨngkano somo nowento kako hwaho Someliya sopoe umentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Oso hopo sopo nowento kako ango Saika sopo iꞌmofamentisofoho. Oso ango hiso hohonta Jekoup kako kakoe hwomu Jousepɨmo hwaho umentisoso mofoneponoho. ");
INSERT INTO apz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Oso hopo sopo mijimo Jekoup nɨhuꞌno hohonta ijɨmentisoso woꞌnnyoponoho. Jisas kako osopo hano nowento oso mijimoꞌnjo hopo sopo mofehiꞌnyo mijiyo kwaꞌofiyo ne lopo lohofontanɨngki (12 kɨlouk somo) Jisas kakoe aꞌapaho usijoꞌno oso hopo sopo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Aꞌmu Someliyantaꞌangosi mijo uꞌmonto pmmentisofoho. Oso aꞌmu hisi nopahonɨngki Jisas ulɨmento, Mijo ntape. Ngko wanɨmo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Jisas kakoe inomokomoyo sohwonaꞌni nakwo wosopayo mpe uyontaneꞌno ango ne sopo nto umentɨhwoneponoho. ");
INSERT INTO apz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jisas kakoꞌnohini nohumentanɨngki oso aꞌmu Someliyantaꞌangosi Jisasɨmo ulɨmento, Kɨko aꞌamu Juta hwosoho. Ngko Someliya aꞌmuꞌnyoho. Osoꞌno kɨko mijo ntape. Ngko wanɨmo eso pehoꞌno ntohino. Ose ulɨmentisofoho. Hwapɨngoso aꞌamu Juta soꞌnji aꞌamu Someliya soꞌnji hofɨko hungkuno molanɨmotofofoho. Jomo muꞌmaꞌnyoꞌnjo imotofofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisas kako oso aꞌmu simo ulɨmento, Anɨtu kako aꞌamumo yoꞌmayo wopɨngoso uyone soꞌntnneꞌno, Ngko mijo ntape. Wanɨmo kiloheso sohwoꞌnnontnneꞌno kɨko huno ntoꞌno kiyontentesi kɨko ngkimo mijoꞌno jomo ntohojoꞌno ngko mijo songo neꞌno humayoꞌne kijapmꞌmnesohilo. ");
INSERT INTO apz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ose ulahonɨngki aꞌmusi ulɨmento, Hwe Engofo, kɨko mijo ifanyoso ane hwosoho. Olo mijimo loso kengo moꞌmtaꞌangofoho. Oseso oso mijo songo neꞌno humayoso ntɨꞌmtaꞌni womaꞌmonnto. ");
INSERT INTO apz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Neyakwo Jekoup sohwo kako nakumo kakoe mehomi sohwanjimo olo mijimo loso nejapmmentisofoho. Jekoup kakoꞌnji kakoe mehomi sohwanji hofɨkoe yahuꞌnji olo mijimo lomtaꞌni hohonta nɨmotofofoho. Oseso nakwo jɨje mijoso pehoꞌno womantantoho. Jɨje yofe engoso neyakwo Jekoup sohwoe yofe engo somo yakoloꞌnnyo hwosilaho. ");
INSERT INTO apz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ose ulahonɨngkahonɨngki Jisas ulɨmento, Aꞌamu olo mijo loso nɨwoꞌnɨngkohofoso hofɨko nomꞌne sɨkunomo mijoꞌne apaꞌno umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","I osoꞌno aꞌamu fihwo kako olo mijo uyɨme loso nosoꞌmanji kako apaꞌno mijoꞌno mumoꞌnonehoho. Oꞌo, olo mijo uyɨme loso nonɨngkuhwosi kakoe sɨmeho moꞌmo mijolɨmo hopa imoꞌnɨngkuhwosoꞌno oso mijo hiso neꞌno swapɨwoꞌnɨngkuhwosi kakoe songo neꞌno humayoso neꞌnohino hweho. ");
INSERT INTO apz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ose ulahonɨngki aꞌmusi ulɨmento, Hwe Engofo, oso mijo hiso ngkimo ntape. Oseso hwangku ngko mijoꞌno mijoho mapeꞌnɨmnehono. Oseso ngko olo mijo hiloso apaꞌno mifapmnehono. ");
INSERT INTO apz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ose ulahonɨngki Jisas ulɨmento, Kɨko jɨje angopo nowehoji jɨje hwehumo utɨmahoji olopo asomo fɨpe. ");
INSERT INTO apz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ose ulahonɨngki aꞌmusi ulɨmento, Ngko hwehwo aniꞌnyoho. Ose ulahonɨngki Jisas ulɨmento, Ou, kɨko hwehwo aniꞌnyoho ntohinoso nɨhuꞌno nehopi lohino. ");
INSERT INTO apz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kɨko hohonta hwehwa aho hopiꞌnonohino sohwamo umaꞌnɨmentohino kiyoho. I, olo hwe lohwo olohonta kɨkoꞌnjo humasiyoso jɨje hwehwoꞌmaho. Oso jɨje hungkuno nehopi lohino. ");
INSERT INTO apz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ose ulahonɨngki aꞌmusi yomo yonto ulɨmento, Hwe Engofo, ngko kikineꞌno huno niyohoho. Kikimo Anɨtu hungkuno kijopahonɨngki lɨmotnno hwosoho. ");
INSERT INTO apz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nakwo aꞌamu Someliya hnꞌnwiye neyakwosa hofɨko olo hwofɨkiꞌnyo lopo Anɨtuye yofe hoꞌnomayoꞌne uhuꞌmokumotofofoho. I osoꞌno sekwo aꞌamu Juta soku ole lɨwoꞌnɨngkohofi, Aꞌamu hopiꞌnono ango Jelusalem soponohini Anɨtuye yofe hoꞌnomayoꞌne uhuꞌmokukuno. ");
INSERT INTO apz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ose ulahonɨngki Jisas ulɨmento, Aꞌmu losi, nje hungkuno ne somo kɨko sɨmeho hiꞌntnnono uyo. Sɨkuno fihwi umoꞌnɨmonto yalokunjo somo sekwo olo hwofɨkiꞌnyo lopo Mpohwoe yofe hoꞌnomayoꞌne muhuꞌmokufitnnehofo. I aꞌamu ango Jelusalem hopo oso hisoꞌne muhuꞌmokufitnnehofo. Oꞌo, aꞌamu angoꞌmeemjoso hofɨkoe hwapɨngopo Anɨtuye yofe hoꞌnomayoꞌne uhuꞌmokantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","I osoꞌno sekwo aꞌamu Someliya soku sekwo Mpohwoe yofe hoꞌnomayoꞌne hwapɨngo neso huno maseyofoho. Nakwo aꞌamu Juta hnꞌnwi nakwo Anɨtuye yofe hoꞌnomawoꞌnɨngkuhwone ne sohumo nakwo huno nayohoho. Hwapɨngoso nakwo aꞌamu Juta hnꞌnɨmtaꞌni Anɨtu kako hwe fihumo uhwosopeehonɨngki oso hwe huhwo sohwo kako aꞌamufe wonyomjo tohino somo isɨhutofomayoꞌne hweho. Osoꞌno hwapɨngo neso huno nayohoho. ");
INSERT INTO apz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Oso sɨkuno hiso umoꞌnɨmonteꞌno kilohe hiso olohonta nto iꞌmofapohoho. Aꞌamu fihwo kako ngko Anɨtuye yofe wohoꞌnomaꞌmo nehopi loso sohwo kako ole uyɨmontonoho. Kako Anɨtuye Towahunoꞌnji nohumahwosi Towahuno huhwo sohwo Anɨtuye yofe hoꞌnomayoꞌne honɨngkano neso utɨhwahonɨngkuhwosi oso hwo inɨngkohwosoꞌno kako Anɨtuye yofe nehopi wohoꞌnomaꞌmontonoho. Nje Mpohwo kako aꞌamu oso yahino soꞌnjo somneꞌno umoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anɨtu kako Towahuno hweho. Osoꞌno aꞌamu Anɨtuye yofe wohoꞌnomaꞌmo loso sohwo kako Anɨtuye Towahunoꞌnji nohumahwosi kako honɨngkano ntoꞌnohinomo unɨngkamontonoho. Oso yahinoso Anɨtuye yofe hoꞌnomayoꞌne nefoho. ");
INSERT INTO apz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ose ulahonɨngki aꞌmusi ulɨmento, Ngko huno ole niyohoho. Anɨtu kako ole nalɨmento, Ngko sekumo sefoꞌmayoꞌne uhwosopoꞌmentohe sohumo sekuyepono uhwatɨmonnoho. Oso aꞌamu huhwo sohumneꞌno Kɨlaisɨyoho lɨwoꞌnɨngkuhwonefoho. Kako nopɨhwosoꞌno kako yoꞌmayo yoꞌmayo soꞌno wolonetɨhwamontonoho. ");
INSERT INTO apz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ose ulahonɨngki Jisas ulɨmento, Olo ngko olo huhwoꞌnyoho. Ngko kɨkoꞌnji hungkuno lalokuhwoyosofo. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ose ulɨkwato lohofahonɨngki Jisasɨye inomokomoyo sohwonaꞌni uꞌmentani uhwonɨmentɨhwoneso Jisas oso aꞌmusiꞌnji hungkuno hnnontanɨngki uhwonontani yomo yontani nakwo huno piꞌnɨngo syafɨhuꞌmentɨhwonefoho. I osoꞌno nakwo aꞌmu simo ole mujofoho. Kɨko pehoꞌno kumoꞌnɨngkohoho. I Jisasɨmo ole mujofoho. Aꞌmu simo pehoꞌno ulalokuno. Oꞌo, ose mujofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Oseso aꞌmusi kako kakoe mijɨpoꞌnyoso nulɨkoꞌmanto kakoe angopono asomo umentisofoho. Iꞌmofawento aꞌamu hopiꞌnonohino somo ulɨmento, ");
INSERT INTO apz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Sekwo nopɨkuji olo hwe lohwo uhwonɨmno. Kako yoꞌmayo yoꞌmayo ngko hohonta imote soꞌno ntohoho. Oso hwe Anɨtu uhwatɨmnoho nalɨmentiso Kɨlais sohwolɨkeno. ");
INSERT INTO apz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ose ulahonɨngki hofɨko hofɨkoe angopo ulɨkoꞌmantɨfi Jisasɨmo uhwonano lontɨfi pmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Oso hohosohonta Jisasɨye inomokomoyo sohwonaꞌni Jisasɨmo ulɨmentɨhwoni, Nakwoe Lonetɨhwayo sohwosi, kɨko wopayoꞌne mijoho kiyonoho. Wopayo hmnyo. ");
INSERT INTO apz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ose ulahonɨngkuhwoni Jisas nalɨmento, Ngko wosopayo sekwo huno maseyoso ngko hiꞌnjo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ose nelahonɨngki inomokomoyo sohwonaꞌni ole hnnɨmentɨhwoni, Aꞌamu fihwo kako Jisasɨmo wopayo nto uyisohwolɨkeno. ");
INSERT INTO apz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ose syofɨsyahonɨngkɨhwoni Jisas nalɨmento, Nje wosopayoso olenoho. Nje Mpohwo nɨhwatɨmentiso sohwoe hunomo tɨfi inɨngkayoꞌne syohoso nje wosopayofoho. Oso syoho hiso wesojwaoꞌmonnoho. Oso syohoso wosopayo paꞌnyo yokumpohnꞌnyo ntapɨwoꞌnɨngkisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ose nalonto ole nalɨmento, Sekwo ole lɨwoꞌnɨngkohofi, Hamno osofosofahuꞌno neyakolofɨhwosoꞌno wosopayo toyo ihwosoꞌno womantanoho. Ose lɨwoꞌnɨngkohofo kuyoho. I osoꞌno ngko ole selalokweno. Sekwo wosopayo somo feꞌnɨhwonɨmno. Toyo nto imaho. ");
INSERT INTO apz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","I oso wosopayo selalokweso aꞌamumneꞌno selalokweno. Wopayo toyoso aꞌamu hofɨko nje hungkunomo upaꞌnɨngkuji sɨmeho komoꞌno wontapɨfe ntnneꞌno selalokweno. Hwe fihwo kako wosopayo hujo sohwo tɨfi noꞌmo kako wopayo toyo emahwosoꞌno oso wosopayo hiso kakoe hoꞌyango paꞌnyofoho. Oso hopaso aꞌamu Anɨtuye hungkuno nomꞌne aꞌamumo ulɨwoꞌnɨngkohofoso hofɨkoe hoꞌyangoso olenoho. Hofɨkoe hungkunomo nomꞌne aꞌamu upaꞌnɨngkuji Anɨtumo sɨmeho uyɨfijoꞌmanji oso aꞌamu hiso hofɨkoe hoꞌyangofoho. Hofɨko oso hoꞌyango hisoꞌnji engolopohamo nohumantokutnnefoho. Oseso oso wosopayo hulɨwoꞌnɨngkiso soꞌnji kakoe aꞌamu wopayo toyo emawoꞌnɨngkohofo soꞌnji hofɨko sɨmonyo afaꞌno afaꞌno uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Oseso oso hungkuno lɨwoꞌnɨngkohofo loso nehopeho. Hwe fihwo kako wopuyo hulahonɨngki nomꞌnihwo wosopayo toyoso emawoꞌnɨngkisofoho. Ose lɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Sekwo wopuyo ko mahulɨmmalofoso sekwo wopayo toyo femapmno selohe soꞌno sekwo aꞌamu nomꞌne sofe syoho yokumpohnꞌnyo imalofo somtaꞌni wopayo toyo emalokwofo. Sɨmoꞌmo aꞌamu nomꞌneso hofɨko Anɨtuye hungkuno nomꞌne aꞌamumo lutɨhwawoꞌnɨngkohofo soꞌno sekwo oso aꞌamu hisomo nje hungkuno ulɨkujoꞌno hofɨko nje aꞌamu ne umoꞌnantɨfeho. Oso hisoꞌno sekwo wopayo toyo paꞌnyo emalokwofo. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Oso aꞌmusi Jisasɨꞌnji hungkuno hnnɨmentisiyosi kako aꞌamu Someliya somo kako yoꞌmayo yoꞌmayo ngko hohonta imote soꞌno ntohoho ulɨmentiso soꞌno aꞌamu piꞌnɨngo engoso Jisasɨmo sɨmeho hiꞌntnnono uyɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Oso aꞌamu hiso Jisasɨꞌnjopo iꞌmofapontɨfi Jisasɨmo hungkuno yokumpohnꞌnyo ulɨmentohofi, Kɨko nakwoꞌnjo lopo fosyohumaho. Ose ulahonɨngkofi Jisas hofɨkoꞌnji sɨkuno hufaꞌu humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Osopo nohumentanɨngki aꞌamu piꞌnɨngo engoso kakoe hungkunomo haloho upaꞌnontɨfi sɨmeho hiꞌntnnono umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hofɨko sɨmeho hiꞌntnnono uyontɨfi hofɨko oso aꞌmu simo ulɨmentohofi, Sɨmoꞌmo jɨje hungkunomo upoꞌnontani nakwo huno ole syafɨhuꞌmalohwoni, Olo hwe lohwo hungkuno neꞌnjo hweho. I osoꞌno olohonta kakintaꞌni kakoe hungkuno neso nakwo huno ole nayohoho. Olo hwe lohwo kako aꞌamu hwahoponjo hnꞌnwiye wonyo somjo tohino somtaꞌni isɨhutofonemayoꞌne hweho. Huno ose nayohoho. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Oso sɨkuno hufaꞌu sohwaꞌu moiꞌwo imoꞌnɨngkahonɨngki Jisas oso ango hopo sopo nulɨkoꞌmanto Ngkalilino umentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nomꞌne sohonta Jisas olo hungkuno loso lɨmentisofoho. Aꞌamu fihumo Anɨtu hungkuno uyahonɨngki lɨmojo sohwo kako kakoe hwapɨngo sopo yofe engo ane hweho. Ose lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","I osoꞌno Jisas kako kakoe hwapɨngopo Ngkalili iꞌmofopahonɨngki aꞌamu hopo soponjoso hofɨko Jisas pmmentiso soꞌno sɨmonyo imentohofofoho. Hwapɨngoso hofɨko hi ango Jelusalem Sɨkuno Engo iyoho humayo uhwonyo somo sɨmentohofofoho. Osopo nohumantɨfi yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofo Jisas yahonɨngki uhwonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Oso hwaho Ngkalili ango weꞌe Kana osopo Jisas asomo umentisofoho. Nomꞌne sɨkuno somo oso ango hopo sopo Jisas humamentiso sohonta kako hungkuno lahonɨngki ahuꞌmo mijoso ipisayo mijo pompenjiyo wain imoꞌnɨmentisofoho. Jisas kako oso ango Kana sopo nohumentanɨngki hwe nomꞌne ango Koponeyam humamojo sohwo kako Jisas hwaho Jutiya sopo ntaꞌni hwaho Ngkalilineꞌno sopalofoho upaꞌnɨmentisofoho. Oso hwe huhwo sohwo kako hwe engo hwaho mokosyohumayo sohwoe syoho fehohnjo somo mokosyohumamojo hweho. Kakoe hwomu mnokino engo tɨpemaꞌmentisofoho. Osoꞌno hwe huhwo sohwo ango Kana sopo nowento Jisasɨmo tɨpɨhwononto hungkuno yokumpohnꞌnyo ulɨmento, Nje hwomu kako poyo wapeꞌnɨmonteꞌno mofoneponoho. Osoꞌno kɨko ngkoꞌnji ango Koponeyam nowehwasi nje hwomumo wopɨngo nɨmokiyo. ");
INSERT INTO apz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ose ulahonɨngki Jisas ulɨmento, Ngko yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso miyomeꞌmanji sekwo ngkineꞌno masemoꞌnyoꞌnjo kuyoho, sɨmeho hiꞌntnnono montapeꞌnjo hwasoho. ");
INSERT INTO apz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ose ulahonɨngki oso hwe engo sohwoe syoho ulohofiyo sohwo ulɨmento, Hwe Engofo, kɨko komoꞌno fɨpe. Nje hwomu poyo peꞌnoloho. ");
INSERT INTO apz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ose ulahonɨngki Jisas ulɨmento, Kɨko jɨje angopono asomo fɨwe. Jɨje hwomu sohwo wopɨngo wohumamontonoho. Ose ulahonɨngki oso hwe huhwo sohwo kako Jisasɨye hungkunomo sɨmeho hiꞌntnnono uyonto kakoe ango poneꞌno asomo umentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nowentanɨngki kakoe syoho ulohofiyo sohwa honɨngkanopo uswoꞌnontɨfi ulɨmentohofi, Jɨje hwomu sohwo wopɨngo humaho. ");
INSERT INTO apz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ose ulahonɨngkofi kako ulohonɨmento, Nje hwomu sohwo wopɨngo mofehiꞌnyo ntisohumo imoꞌnɨmaho. Ose ulahonɨngki hofɨko ulɨmentohofi, Fosi mofehiꞌnyo soumjiyo sohonta kakoe aꞌapaho tohohmtnnoso moiꞌwo imoꞌnɨngkahonɨngki wopɨngo humaho. ");
INSERT INTO apz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ose ulahonɨngkofi kanɨngkwohwo huno ole uyɨmento, Fosi mofehiꞌnyo soumjiyo sohonta Jisas kakimo ulɨmento, Jɨje hwomu wopɨngo wahumamontonoho. Ose ikwesyafɨsyonto kako kakoe aꞌamu hopiꞌnonohino sonji Jisasɨmo sɨmeho hiꞌntnnono umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Oso wonyoangkafoso aꞌamu miyɨwoꞌnɨngkiyohofoso Jisas hwaho Ngkalili sopo imentisoso sɨmoꞌmo ahuꞌmo mijomo wain imoꞌnɨmentisofoho. Osofepo hwomu mnokinoꞌnjo sohumo wopɨngo umokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Oso moiꞌwo imoꞌnɨngkahonɨngki aꞌamu Jutafe Sɨkuno Engo iyoho humayoꞌne iꞌmofopahonɨngki Jisas Jelusalemneꞌno sɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Oso ango Jelusalem sokilojo kuso angaꞌno yahu sipsipmnefoho lɨmotofofoho. Oso hopo sopo mijo ayo weꞌe woꞌnnyoponoho. Aꞌamu Jutafe hungkuno ole Mpetesɨta. Oso hopo sopo ango aho angaꞌno hopiꞌnono swoho ane ikuꞌyoꞌnohinomoꞌnnyoso lohoꞌnnyoponoho. ");
INSERT INTO apz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Oso ango hopo sopo aꞌamu piꞌnɨngo engo mnokinoꞌnjoso humamotofofoho. Fehohnjoso tɨmpiꞌnyo fehohnjo sɨfe wonyoꞌnjo fehohnjo aꞌapaho poyo peꞌnnyoꞌnjo oso aꞌamuso humamotofofoho. Hofɨko oso mijo ayo weꞌe huhwo sohwo songo songo iyoꞌne hontohumamotofofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Hwapɨngoso sɨkuno fehohnjo Anɨtuye aꞌamu ahwomomjo fihwo noponto mijo ajwomoꞌmo songo songo imokahonɨngki uhwonontɨfi aꞌamu mnokinoꞌnjo sohwo kako oso mijo somo sɨmoꞌmo hoꞌnɨmaꞌmentiso osohwo kakoe mnokinoso moiꞌwo imoꞌnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Oso hopo sopo hwe mnokinoꞌnjo fihwo nohumentanɨngki soswo teti-et (38) uyakoloꞌmojo hweho. ");
INSERT INTO apz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas noponto oso hwe huhwo sohwo fosyowentanɨngki uhwononto huno ole umento, olo hwe lohwo mnokino hohonta umojo hweho. Ose syafɨsyonto ulɨmento, Kɨko nje aꞌapaho wopɨngo wanɨmoꞌnono lakinɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ose ulohonɨngkahonɨngki aꞌamu mnokinoꞌnjo sohwo ulɨmento, Ou, hwe engofo, oso mijo songo songo yahonjo sohonta ngko aꞌamu nontomafɨkuji mijomo menɨhumajone aꞌamuso ane hwoꞌnyoho. Ngko wahoꞌnuꞌmoꞌmo ko lontnneso nomꞌne aꞌamuso niyakolofɨwoꞌnɨngkohofo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ose ulahonɨngki Jisas ulɨmento, kɨko nolɨkafohoji jɨje ife hoꞌyango yoꞌmayoso huꞌmemahoji hano mpano. ");
INSERT INTO apz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ose ulahonɨngki nɨhuꞌno komoꞌno oso hwe sohwoe aꞌapaho wopɨngo imoꞌnɨngkahonɨngki kako nolɨkafonto kakoe ife yoꞌmayoso nohuꞌmemanto kako hano umentisofoho. Oso sɨkuno hiso sɨkuno iyoho humayomnoho. ");
INSERT INTO apz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Oseso aꞌamu Jutafe hwe engo sohwa hofɨko oso hwe wopɨngo umokumentiso sohumo ulɨmentohofi, Olo sɨkuno loso iyoho humayoꞌnefoho. Jɨje ife yoꞌmayoso mokohoꞌnaweꞌne sɨkuno mꞌmaho. Kɨko nakwoe honɨngkano hungkunomo mtɨhupeelokuno. ");
INSERT INTO apz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ose ulahonɨngkofi kako ole ulɨmento, Oso hwe kako wopɨngo nɨmokonto ntohoho, Kɨko nolɨkafohoji jɨje ife yoꞌmayoso huꞌmemahoji hano mpano. Ose ntisoꞌnefoho. ");
INSERT INTO apz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ose ulahonɨngki hofɨko ulohonɨmentohofi, Tɨhwoe aꞌamuhwo kilisoto. Jɨje ife yoꞌmayoso mahoji mpano eso. ");
INSERT INTO apz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ose ulahonɨngkofi oso hwe wopɨngo imoꞌnɨmentiso sohwo kako Jisas kakoe yofeso huno muyo hweho. Hwapɨngoso oso hopo sopo Jisas kako oso hwe huhwo sohumo wopɨngo umokonto aꞌamu piꞌnɨngo engo somo uhwononto kako komoꞌno ulɨkoꞌmaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hwangku sohonta Jisas kako oso hwe huhwo sohumo Anɨtuye tajo ango engo somo tɨpɨhwononto ulɨmento, Kɨko upaꞌnyo. Wopɨngo nto imoꞌnɨngkino hwosoho. I kɨko honɨngkano wonyoso apaꞌno yohotoho. Nomꞌne tango engo mɨkunɨmposo kuꞌmanoho. ");
INSERT INTO apz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ose ulahonɨngki oso hwe huhwo sohwo kako nowento aꞌamu Jutafe hwe engo sohwamo ulɨmento, Oso hwe ngkimo wopɨngo nɨmokumaso sohwo Jisasɨyoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Oso hohosohonta aꞌamu Jutaso hofɨko Jisasɨmneꞌno wonyo ulohofano lontɨfi oso hisoꞌno hungkuno lomaꞌmentohofofoho. Hwapɨngoso Jisas kako oso hwe wopɨngo umokumentisoso sɨkuno iyoho humayo somo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Hofɨko Jisasɨmo yoka hungkuno ulahonɨngkofi Jisas ulɨmento, I nje Mpohwo kako sɨkuno huhwo huhwi aꞌamumo wopɨngoꞌnohini neꞌno ulohofɨwoꞌnɨngkiso hweho. Kako usijoꞌno mofosyohumayo hweho. Oso paꞌnyo sɨkuno huhwo huhwi ngko huhwoꞌni aꞌamumo wopɨngo ulohofɨwoꞌnɨngkohe hwoꞌnyoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jisas ose ulɨmentiso soꞌno aꞌamu Jutaso hofɨko Jisasɨmo wofonjosyano lontɨfi imentohofofoho. Hwapɨngoso hofɨko huno ole syafɨhuꞌmentohofi, Jisas kako sɨkuno iyoho humayo somo syoho iwoꞌnɨngkiso hweho. Osoꞌnohiniꞌmaho. Oꞌo, kako Anɨtu nje Mpohweho nalisoꞌmanji kako huno ole syofɨsyalofoho. Ngko Anɨtuꞌnji afa hwoꞌnyoho. Ose syafɨsyontɨfi hofɨko Jisasɨmo wofonjosyano lontɨfi imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisas aꞌamu Juta huhwa sohwamo ulɨmento, Hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Ngko Anɨtuye Hwomu sohwoꞌni nje huno mtaꞌni ngko yoꞌmayoso siki mimnehono. Oꞌo, yoꞌmayo nje Mpohwo yalokunjo somo uhwononji ngko yalokweno. Yoꞌmayo Mpohwo yonteso Hwomu sohwo kako iwoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nje Mpohwo kako sɨmeho engo mɨkunɨmposo Ngkimo ntapɨwoꞌnɨngkiso soꞌno kako yoꞌmayo hopiꞌnonohino yalokusoso ntɨhwawoꞌnɨngkisofoho. Oseso yoꞌmayo ntɨwoꞌnɨngkisoso ngko yalokweno. Olo syoho weꞌe imale somo sekwo tɨmo uhwonɨmalofo sohwasi hwangku Anɨtu kako syoho engo olo syoho weꞌe homo lomo hwofiloꞌnnyoso ntapɨhwosoꞌno sekwo uhwonɨngkuji sekwo yomo uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mpohwo kako aꞌamu poyo peꞌnyo somo ulɨkafonte sohwo songo apaꞌno umokuwoꞌnɨngkiso hweho. Oseso Ngko huhwoꞌni aꞌamu fehohnjo poyo peꞌnyo somo ulɨkaꞌmo lɨmeso i ulɨkaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Olohonta Mpohwo Anɨtu kako aꞌamufe honɨngkano somneꞌno wopɨngofoho wonyofoho mujo hweho. Oꞌo, kako oso syoho hiso kakoe Hwomu sohwoꞌnɨmo ntapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Oseso hwe moyaꞌmi hopiꞌnonohinoso hofɨko Mpohwoe yofe hoꞌnomawoꞌnɨngkohofo hopaso hofɨko kakoe Hwomu sohwoꞌniye yofe hi hoꞌnonɨmapitnneꞌento syoho hiso ntapmmentisofoho. I osoꞌno aꞌamu nje yofe mohoꞌnonɨmayoꞌnjo hwoꞌmanji hofɨko nje Mpohwo nɨhwatɨmentiso sohwoe yofe hi mohoꞌnomayoꞌnjofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ose ulɨkwato lohofonto ole ulɨmento, Ngko nehopiꞌnohino waselɨmonneꞌno yohono. Aꞌamu hofɨko nje hungkunomo upaꞌnɨngkuji Anɨtu nɨhwatɨmentiso sohumo sɨmeho hiꞌntnnono uyɨkuji hofɨko songo neꞌno wopɨngo humayoꞌne hiꞌnjofoho. Hwangku hofɨkoe yahino somneꞌno hungkuno ikwolofo angkuhwafo sopo mꞌmofapitnnefoho. Hofɨko poyo peꞌnyo yahino somo hwotoho fentɨfi songo neꞌno humayo yahinoso nto tɨpemaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Hungkuno nehopiꞌnohini selalokweno. Oso sɨkuno uꞌmofapmmonto imentiso sohwi nto iꞌmofapohoho. Osoꞌno olohonta aꞌamu poyo peꞌnɨmentohofoso hofɨko Anɨtuye Hwomu sohwoꞌniye mango mtaꞌni nje hungkuno upoꞌnantɨfeho. Oso aꞌamu hiso oso hungkuno homo somo sɨmeho uyɨkujiꞌmanji hofɨko songo neꞌno nohumantokutnnefoho. ");
INSERT INTO apz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nje Mpohwo kako songo humayo hwapɨngo sohwo kako kakoe Hwomu sohwoꞌnnonji songo fosyohumayoꞌne hwapɨngo nɨmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Oseso Anɨtu kakoe Hwomu sohwoꞌnɨmo oso syoho aꞌamufe yahino somneꞌno wopɨngofoho wonyofoho ujoso ntapmmentisofoho. Hwapɨngoso Ngko Aꞌamufe Hwomu nɨhwosopoꞌmentiso hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Sekwo olo hungkuno lomneꞌno yomo ikutoho. Hwangku nomꞌne sɨkuno imoꞌnyo sohwi iꞌmofapɨhwosoꞌno aꞌamu poyo nto peꞌnontɨfi piꞌnɨmomo wotofoso hofɨko nje mampaho wonupoꞌnantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Hofɨko nupaꞌnɨngkuji apaꞌno songo wolɨkofantɨfeho. Aꞌamu yahino wopɨngo imotofoso songo neꞌno nohumantokutnnefoho. Aꞌamu yahino wonyo imotofoso tohino engo tɨpemapitnnefoho. ");
INSERT INTO apz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ngko aꞌamufe yahino somneꞌno yano milofɨhwajiyo syoho imeso nje huno mtaꞌni mimnehono. Oꞌo, ngko nje Mpohwoe hungkunomo upaꞌnɨꞌmo osomnohini ngko tɨfi inɨngkaꞌmo ngko aꞌamumo yano milofɨhwajiyoso ntoꞌnohino uyɨmonnoho. Hwapɨngoso ngko nje huno mtaꞌni uyɨmonjiꞌmaho. Oꞌo, nɨhwatɨmentiso sohwo yoꞌmayo umoꞌnososo uyɨmonnoho. ");
INSERT INTO apz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ngko sekumo ngkineꞌno hungkuno selɨꞌmeꞌno sekwo huno ole wosyofɨsyantɨfeho. Kakoe hungkuno nehopitɨkeno. Hwasyo kolalofoho. Ose wosyofɨsyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","I osoꞌno nomꞌnihwo nje Mpohwo oso hungkuno ngkineꞌno selokweso kako huhwo nje hwapɨngo soꞌno setɨhwalofoho. Oso ngkineꞌno setɨhwalokusoso ngko huno niyohoho, nehopeho. ");
INSERT INTO apz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","I nomꞌne hungkuno upaꞌnyo. Oso hwe Joun Aꞌamumo Mijo Kiyomaꞌmojo sohwoe hungkunomo sekwo upoꞌnaneꞌentɨfi kakiyepono sekwoe aꞌamumo uhwatɨmentohofofoho. Oso hwe huhwoꞌnji nje hwapɨngo soꞌno hungkuno nehopi nto selɨmojofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ngko hwaho loponjo hwe sohwoe hungkuno ngkineꞌno nje hwapɨngo soꞌno selɨmentiso soꞌno ngko huno piꞌnɨngo maniyantofiyoho. I osoꞌno sekwo ngkimo sɨmeho ntapɨfitnneꞌno sekwoe wonyomjo tohino somtaꞌni isɨhutofosemayoꞌne Jounɨye hungkunoso huno sefohotofoꞌne selalokweno. ");
INSERT INTO apz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Joun sohwo kako sikiloho hopo imoꞌnonto sekumneꞌno pomponaho losesiyoꞌne hweho. Sekwo kakoe pomponahopo weꞌenepi wohumano lontɨfi sɨmonyo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","I osoꞌno olohonta nomꞌne wopɨngo Jounɨmo hwofiloꞌnnyoso nje hwapɨngo soꞌno losetɨhwalofoho. Oso hiso nje syoho wopɨngo Mpohwo ntapmmentiso aꞌamu miyɨwoꞌnɨngkiyohofoso yalokweno. Oso syoho hiso sekwo uhwonɨngkuji nje hwapɨngo soꞌno huno waseyono. Mpohwo Anɨtu lɨhwatɨmentiso hweho waseyono. ");
INSERT INTO apz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nje Mpohwo nɨhwatɨmentiso sohwo sekwo kakimo muhwonyoꞌnjo ko yontɨfi kakoe mampaho somo mupaꞌnyoꞌnjo ko yahonɨngkofi kako huhwo nje hwapɨngo soꞌno nto setɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kakoe hungkunoso sekwoe sɨmeho moꞌmo maseuyoho. Hwapɨngoso sekwo Anɨtu nɨhwatɨmentiso sohwoꞌnɨmo sɨmeho hiꞌntnnono montape kuyoho. ");
INSERT INTO apz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Sekwo huno ole syofɨsyalokwofo. Nakwo Anɨtuye hungkunomo sɨkuno huhwo huhwi atofo lɨwoꞌnasoso nakwo songo neꞌno humayoꞌne wotɨpemantanoho. Ose syafɨsyontɨfi sekwo oso hungkuno homo somo hafɨhafe tɨpewoꞌnɨngkohofofoho. I osoꞌno oso hungkuno hiso nje hwapɨngo soꞌno ko lɨjwaofɨwoꞌnɨngkisoso ");
INSERT INTO apz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","sekwo ngko songo neꞌno wonyoangkafo humayo hwapɨngo sohwoꞌnɨmo nɨꞌmayo soꞌno nakwolaho lɨwoꞌnɨngkohofofoho. Osoꞌno sekwo songo neꞌno humayoso matɨpmmopiyo hwasoho. ");
INSERT INTO apz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Olo hungkuno loso sekwo nje yofe wohoꞌnonɨmantɨfeꞌno maselalokuyohono. ");
INSERT INTO apz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Oꞌo, ngko sekwoe yahino somneꞌno huno niyohoho. Sekwo Anɨtumneꞌno Nakwolaho lalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ngko nje Mpohwoe yokumpohnꞌnyoꞌnji noponji seꞌmaꞌmentoheso, Ngko Anɨtu mtaꞌango hwoꞌnyoho selɨmentohefoho. I osoꞌno sekwo nje hungkunomo mohoꞌnonɨmaso hwasoho. I hwe nomꞌnehwo kakoe huno mtaꞌni seꞌmahwosi kakoe yokumpohnꞌnyoꞌnji yoꞌmayoso ihwosoꞌno sekwo kakoe hungkunomo wohoꞌnomantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sekwo sekwoe yofe hoꞌnomaꞌnɨwoꞌnɨngkohofofoho. I osoꞌno sekwo sekwoe yahino somneꞌno Anɨtu kako huno pipi kuyalofoho eso huno mosyafɨsiyoꞌnjo liyalokwofo. Oꞌo, kakoe syohofoho lalokwofo. Oso hisoꞌno sekwo Anɨtu ne angaꞌnohino sohumo sɨmeho hiꞌntnnono muyɨfitnnehofo. ");
INSERT INTO apz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tɨfi noꞌmo sekwoe honɨngkano somneꞌno hungkuno ikwolofoꞌne sopo ngko nje Mpohumo sekumneꞌno mulɨmnehono. Oꞌo, Mouses sekwoe hungkuno ikwolofoꞌne sopo sekwoe wonyo somneꞌno Mpohumo ulonefoho. Hwapɨngoso sekwo huno ole syofɨsyalokwofo. Nakwo Mousesɨye honɨngkano hungkunomo itoꞌno inɨngkowalokuhwono. Osoꞌno nakwo songo neꞌno wonyoangkafo humayo soꞌno wotɨpemantanoho. Ose syofɨsyalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","I osoꞌno sekwo Mousesɨye hungkunomo sɨmeho hiꞌntnnono nehopi uyontɨfijontentesi sekwo nje hungkuno homo somo sɨmeho hiꞌntnnono nontapɨkutnnesohilo. Hwapɨngoso Mouses kako ngkineꞌno hungkuno mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Oso hungkuno Mouses ifalifaliyo mtɨtmokumentiso somo sekwo ntoꞌno minɨngkayo hwasɨꞌmanji sekwo nje hungkunomo sɨmeho hiꞌntnnono pipi wotɨpeentɨfito. Awonoho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Oso hohosohonta Jisas kako mijo ayo Ngkalili nongkihntaꞌni wakoꞌmentisofoho. Oso mijo ayo yofe nomꞌneso Taipeliyasɨyoho. ");
INSERT INTO apz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Osopo Jisas nowahonɨngki hwe moyaꞌmi piꞌnɨngo engoso Jisasɨmo tɨfi inɨngkapmmentohofofoho. Hwapɨngoso yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso Jisas yahonɨngki uhwonɨmentohofofoho. Aꞌamu mnokinoꞌnjo piꞌnɨngo somo Jisas kako wopɨngo umokahonɨngki uhwonontɨfi inɨngkapmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisasɨꞌnji kakoe inomokomoyo sohwonaꞌnnonji nakwo oso hopo sopo hwofɨkiꞌnyo weꞌe sopo kotosontani osopo humamentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Oso aꞌamu Jutafe Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo Sɨkuno Engo sohwi weꞌenepi umoꞌnɨmonteꞌno imentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas oso hwofɨkiꞌnyo hopo sopo nohumanto tɨmo feꞌnɨhwonɨmentisoso hwe moyaꞌmi piꞌnɨngo engoso Jisasɨyepono sapontanɨngkofi uhwononto kako Filipɨmo ulɨmento, Olo hwe moyaꞌmi lomneꞌno nakwo wosopayo mpe mtɨꞌmtaꞌni yanehwono. ");
INSERT INTO apz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Oso hungkuno hiso Jisas Filipɨmo ko ulɨmentisoso Jisas kako yoꞌmayo yone soꞌno huno nto syafɨhuꞌmentisofoho. I osoꞌno kako Filipɨye hunomo yamofo ulohoꞌmo lonto oso hungkunoso ulohonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jisas ose ulahonɨngki Filip kako ulɨmento, I, nakwo hamniyoho syoho iyo sɨkuno tu hantɨlet (200) memjaofoso hiꞌnjoꞌntontentesi nakwo wosopayo mpe yɨhwasi aꞌamu fehohnjo sohwa wopayo weꞌeꞌnohini nɨngkuji aꞌamu fehohnjoso manyoꞌnjo ikutnnesohilo. ");
INSERT INTO apz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ose ulahonɨngki Jisasɨye inomokomoyo nomꞌne sohwo kakoe yofe Entɨlu, Saimoun Pitafe konɨngkwaꞌwehwo sohwo Jisasɨmo ulɨmento, ");
INSERT INTO apz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Olo hwomu lohwo kakoe wosopayo aho fehohnjo hopiꞌnonohino soꞌnji inanɨku kempinjo hufaꞌuyo soꞌnji mokosyohumunyo hweho. I osoꞌno olo aꞌamu piꞌnɨngo engo lomneꞌno wopayo loso pipi uyanehwono. Oꞌo, hopoꞌmaho. ");
INSERT INTO apz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ose ulahonɨngki Jisas kakoe inomokomoyo sohwonaꞌnɨmo nalɨmento, Sekwo hwe moyaꞌmi somo ampo fosyohumamno ulɨmno. Ose nalɨmentisofoho. Oso hopo sopo hoja piꞌnɨngoꞌnjoponoho. Aꞌamu hiso hojapo nohumantɨfi hweꞌnohino sohwa faif tausen (5,000) humamentohofofoho. Moyaꞌmi sofamo atofo majofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ose humentanɨngkofi Jisas kako oso wosopayo hiso nomanto Anɨtumo isamoyoka ulonto oso aꞌamu hwe moyaꞌmi hopiꞌnonohino somo yano ulofimentisofoho. Ose uyonto kako inanɨku kempinjo hufaꞌuyo soꞌnji yano ulofimentisofoho. Oso wosopayo soꞌnji inanɨku soꞌnji uyahonɨngki aꞌamu hofɨko nonontɨfi sɨmeho uhnnɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hofɨko wosopayoso nto nɨngkahonɨngkofi Jisas kakoe inomokomoyo sohwonaꞌnɨmo nalɨmento, Sekwo oso wosopayo nonontɨfi nilɨfeefohofoso apaꞌno mɨhuꞌmokumno. Fehohnjo siki wehwoloho. ");
INSERT INTO apz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ose nelahonɨngki oso wosopayo aho fehohnjo hopiꞌnonohino somtaꞌnɨngo nilɨfeeꞌmentohofoso sohwo hoꞌyo aho hopiꞌnonohino sɨfe mtaꞌni hufaꞌuyo somo mehuꞌmeeꞌmmentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Oso wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso Jisas imentiso soꞌno hwe moyaꞌmi hofɨko nuhwonontɨfi ole hnnɨmentohofi, Oso hwe sohumo Anɨtu hungkuno uyahonɨngki naloneꞌno hontohumalohwoneso olo huhweho. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ose hnnontanɨngkofi Jisas kako huno uyɨmento, Hofɨko ngkimo aho yokumpohnꞌnyo nɨkekuji hofɨkoe hwe engomo menɨhumatɨpitnnoho lonto kakoꞌnohini hwofɨkiꞌnyopono kotasɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sɨkunoꞌnji Jisas kakoe inomokomoyo sohwonaꞌni nakwo mijo ayo momɨngo soꞌmneꞌno womentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Osopo nohumentani Jisasɨmneꞌno wonyopi hontohumentani nakwo yofayokinomo kotasontani nakwo oso mijo ayo sopo Koponeyamneꞌno wokaꞌmentɨhwonefoho. Nowekontanɨngkuhwoni ajwopo sɨkuno nto meehonɨngki Jisas nakumo komoꞌno moneꞌmaꞌmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Oso hohosohonta ifofo engo yahonɨngki mijo songo songo engo yonto mijo engo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Inomokomoyo sohwonaꞌni nakwo mijopo neꞌno jonjempo jonjempe mjɨmɨwakoꞌmentɨhwoneso nakwo mijo ajwopo neꞌno humentani uhwonɨmentɨhwoneso Jisas kako mijo ayo yofayokinoꞌnjo sopo hano nowentanɨngki uhwonɨmentɨhwonefoho. Ose uhwonontani iyoho engo nanɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","I osoꞌno Jisas nakumo nalɨmento, Ngkonoho. Sekwo iyoho senɨngkuhwoloho. ");
INSERT INTO apz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ose nelahonɨngki nakwo utɨmano lontani imentɨhwoneso kako nakwoꞌnjo ajwomoꞌmo humahonɨngki yofayokino hiso nakwo wowantani humiyɨhwone soponeꞌno komoꞌno umentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Moꞌnɨngkanta hwe moyaꞌmi mijo ayo momɨngo nongkihntaꞌni humamentohofoso Jisasɨmo uhwonano lontɨfi hnnɨmentohofi, Fosi yofayokino angaꞌno wentono. I, oso homo somo kakoe inomokomoyo sohwanohini kotasɨmalofofoho. Jisasɨꞌnjiꞌmaho hofɨkoꞌnohini kotasontɨfi humpoꞌmalofofoho. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Oso hopo sopo Jisas kako wosopayoꞌno Anɨtumo isamoyoka ulonto aꞌamu homo somo yano ulofimentiso hopo sopo aꞌamuso nohumantɨfi uhwonɨmentohofoso yofayokino fiso Taipeliyasntaꞌango iꞌmofopahonɨngki uhwonontɨfi ");
INSERT INTO apz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jisasɨꞌnji kakoe inomokomoyo sohwonaꞌnnonji mohumunyo uhwonontɨfi hofɨko Jisasɨmo wotɨpemano lontɨfi yofayokinomo kotasontɨfi Koponeyamneꞌno wakoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nowakentɨfi mijo ayo nongkihntaꞌni Jisasɨmo nto tɨpɨhwonɨmentohofo sohonta Jisasɨmo ulɨmentohofi, Nakwoe Lonetɨhwayo sohwosi, kɨko olopo neꞌno ntohonta pmmahnno hwosilo. ");
INSERT INTO apz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ose ulahonɨngkofi kako ulɨmento, Hungkuno nehopi waselɨmonneꞌno yohono. Fosi ngko syoho wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofo imale soꞌno sekwo nje hwapɨngo neso huno ehohosasesiyoꞌneso montɨpeentɨkuyohofo. Oꞌo, ngko wosopayo sejapmmale soꞌno apaꞌno wonejapono lontɨfi ntopeentɨkwofo. ");
INSERT INTO apz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ose ulonto ulɨmento, Sekwo wosopayo piso imoꞌnyoꞌne syoho tohohmtnnoꞌnjo ikutoho. Oꞌo, oso wosopayo songo neꞌno humayoꞌne soꞌno syoho tohohmtnnoꞌnjo fiyɨkuno. Oso wosopayo hiso piso miyonehoho. Oso wosopayo hiso Ngko Aꞌamufe Hwomu sohwoꞌni wosejapmmonnoho. Ngko Anɨtuye yokumpohnꞌnyoꞌnji yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofo yalokwe soꞌno Anɨtu kako ngkineꞌno ole setɨhwalofoho, Ngko songo neꞌno humayoꞌne hwapɨngo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ose ulahonɨngki hofɨko Jisasɨmo ulɨmentohofi, Nakwo pipi ihwasi yanehwono Anɨtuye syohosofo. ");
INSERT INTO apz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo Anɨtuye sɨmeho wopɨngo umokano lɨfijoꞌmanji sekwo olo syoho sejapmmentisoso fiyɨkuno. Sekwo oso hwe Anɨtu sekuyepono nɨhwatɨmentiso sohwoꞌnɨmo sɨmeho hiꞌntnnono ntapmno. ");
INSERT INTO apz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ose ulahonɨngki ulɨmentohofi, I kɨko nomꞌne wopɨngo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso yohojoꞌnoꞌmanji ou, nakwo ole wosyokufɨsyantanoho. Anɨtu kuhwotɨmentiso nehwosoho. Ose wosyokufɨsyantanoho. Osoꞌno pipi ihnnehino. ");
INSERT INTO apz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Neyakwosa sohwa aꞌamu mohumunyo sopo hofɨko nohumantɨfi hofɨko wosopayo ahwomo mtaꞌnɨngoso (mona) nɨmotofofoho. Aꞌamu Anɨtuye hungkuno mtɨꞌmokumentohofo sohwa ole mtɨꞌmokumentohofi, Kako wosopayo ahwomo mtaꞌangoso aꞌamumo uyɨmojofoho. Ose mtɨꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ose ulahonɨngkofi Jisas ulɨmento, Hungkuno nehopiꞌnohino waselɨmonneꞌno yohono. Mouses kako oso wosopayo ahwomo mtaꞌangoso muyɨmmojofoho. Oꞌo, nje Mpohwo uyɨmojo hweho. I olohonta kako ahwomo mtaꞌango wosopayo neso wosejapmmonteꞌno yalofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Oso wosopayo neso aꞌamufoho. Anɨtu kako ahwomo mtaꞌni hwaho lopo uhwatɨmentiso sohwo kako hwe moyaꞌmi hopiꞌnonohino somo songo neꞌno humayoꞌne unyo hweho. ");
INSERT INTO apz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ose ulahonɨngki ulɨmentohofi, Hwe engofo, oso wosopayo neso sɨkuno huhwo huhwi engolopohamo kɨko fonejapohoho. ");
INSERT INTO apz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ose ulahonɨngkofi Jisas hofɨkimo ulɨmento, Ngko songo neꞌno humayoꞌne wosopayo ne hwoꞌnyoho. Aꞌamu hwahoponjo wosopayo nɨwoꞌnɨngkohofoso hofɨko mijoho apaꞌno uyɨmontonoho. I osoꞌno aꞌamu ngkimo nɨꞌmasoso mijoho apaꞌno muyonefoho. Aꞌamu ngkimo sɨmeho hiꞌntnnono ntapososo kako mijoꞌne apaꞌno mumoꞌnonehoho. ");
INSERT INTO apz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","I osoꞌno nje hwapɨngo ne soꞌno nto setɨhwamalefoho. Sekwo ngkimo ko nohonontɨfi sɨmeho hiꞌntnnono mantapeꞌnjo imalofofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Aꞌamu fehohnjoso Anɨtu ngkimo ntapmmentisoso hofɨko ngkineꞌno wonnɨngkopantɨfeho. Oso aꞌamu homo somneꞌno wae meeoꞌmnehono. Ngkilaho mulɨmnehono. ");
INSERT INTO apz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hwapɨngoso ngko ahwomo mtaꞌni pmmentoheso nje huno mtaꞌni pmmentohe hwonɨꞌmaho. Oꞌo, Anɨtu nɨhwatɨmentiso sohwoe hunomnohini inɨngkayoꞌne pmmentohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Anɨtu kako nɨhwatɨmentiso sohwo oleꞌneꞌno umoꞌnɨngkohoho. Hwe moyaꞌmi hopiꞌnonohinoso Anɨtu ngkimo nto ntapmmentiso kalohi ngko angaꞌno musɨkwajɨmnehono. Oꞌo, ngko hofɨkimo aho yokumpohnꞌnyo kemokosyohumantɨꞌmeso hwangku noꞌmo sɨkuno aeꞌuyo somo ngko hofɨkimo nulɨkahmꞌmeꞌno hofɨko songo neꞌno nohumantokutnnefoho. ");
INSERT INTO apz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ou, olo soꞌno Mpohwo kako umoꞌnɨngkohoho. Hwe moyaꞌmi hopiꞌnonohino Kakoe Hwomu sohwoꞌnɨmo nohonɨngkuji nje hwapɨngo ne soꞌno sɨmeho hiꞌntnnono ntapɨfijoꞌmanji hofɨko songo neꞌno humayoꞌneso nomafɨkujoꞌno sɨkuno aeꞌuyo somo ngko hofɨkimo songo nulɨkaꞌmnefoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jisas kako ngko wosopayo ne ahwomo mtaꞌango hwoꞌnyoho ulɨmentiso soꞌno hofɨko hofɨkoe sɨmeho wonyo umoꞌnɨngkahonɨngki Jisasɨmneꞌno sitofo hungkuno hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ole hnnɨmentohofi, Pipineto. Olo hwe lohwo kako Jousepɨye hwomu Jisasɨyoho. Kanɨngkwohwoꞌyaꞌuneꞌno nakwo huno nayohoho. Ngko ahwomo mtaꞌni pmmentohe hwoꞌnyoho eso hwasyoso pehoꞌno nelalofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ose hnnɨngkahonɨngkofi Jisas ulɨmento, Sekwo ngkineꞌno sitofo hungkuno hofiyoka pehoꞌno hnnalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Aꞌamu fihwo kako ngkimo tɨfi nnɨngkaposo sohwo kakoe huno mtaꞌni monɨꞌmanehoho. Oꞌo, nje Mpohwo ngkimo nɨhwatɨmentiso sohwo kako aꞌamu sohumo ngkiyepono mikinjɨhwajiyoso kako ngkimo wonɨꞌmaꞌmontonoho. Oseso oso hwe ngkiyepono Anɨtu lɨhwajoso sohumo ngko sɨkuno aeꞌuyo somo ulɨkaꞌmnefoho. ");
INSERT INTO apz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Aꞌamu Anɨtu hungkuno uyahonɨngki lɨmotofo sohwa ole mtɨꞌmokumentohofi, Hwe moyaꞌmi hopiꞌnonohino somo Anɨtu kako hofɨkimo huno uyoꞌne itɨhwanefoho. Ose mtɨꞌmokumentohofofoho. Aꞌamu hopiꞌnono Anɨtuye hungkuno upaꞌnɨngkuji kakineꞌno huno ntoꞌno syafɨsyɨkujoꞌno hofɨko ngkimo wonɨꞌmantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","I aꞌamu hopiꞌnonohinoso hofɨko nje Mpohwo Anɨtu sohumo muhwonyoꞌnjofoho. Oꞌo, ngkoꞌnohini Mpohwoꞌnji humunyo sohwoꞌnnohini kakimo uhwononji kakoe pone somtaꞌni pmmentohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Hungkuno nehopiꞌnohini selalokweno. Aꞌamu ngkimo sɨmeho hiꞌntnnono ntaposo sohwo kako songo neꞌno humayoꞌneso hiꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ou, ngko songo neꞌno humayoꞌne wosopayo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","I seyakwosa sohwa hofɨko oso hwaho aꞌamu mohumunyo sopo nohumantɨfi wosopayo ahwomo mtaꞌni (mona) nɨmotofo sohwa hofɨko hohonta nto peꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","I osoꞌno oso wosopayo ne ahwomo mtaꞌni aꞌamu nosohwoꞌmanji kako songo neꞌno nohumantɨhwone hweho. ");
INSERT INTO apz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngko oso wosopayo ne songo neꞌno humayoꞌne sohwoꞌni ngko ahwomomo ulɨkoꞌmanji pmmentohe hwoꞌnyoho. Oseso aꞌamu fihwo kako oso wosopayo neso nosoꞌmanji kako songo neꞌno humantɨhwonefoho. Oso wosopayo soꞌneꞌno ngko sekumo selalokweso nje aꞌapahomneꞌno selalokweno. Hwapɨngoso ngko aꞌamu hwahoponjo somneꞌno poyo imoꞌnɨꞌmeꞌno aꞌamu ngkineꞌno sɨmeho ntapɨfijoꞌmanji hofɨko songo neꞌno nohumantokutnnefoho. ");
INSERT INTO apz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ose ulahonɨngki aꞌamu Juta hofɨko yoka hungkuno engo lomaꞌmentohofofoho. Ole hnnɨmentohofi, Olo hwe lohwo kakoe aꞌapaho nejapososo pipi nanehwono. ");
INSERT INTO apz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ose ulahonɨngki Jisas ulɨmento, Ngko hungkuno nehopi selalokweno. Sekwo nje aꞌapaho soꞌnji nje honɨyo soꞌnji manɨfijoꞌmanji sekwo songo neꞌno humayoso motɨpɨhwonɨfitnnefoho. ");
INSERT INTO apz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aꞌamu nje aꞌapaho soꞌnji nje honɨyo soꞌnji nnososo kako songo neꞌno humayoꞌneso hiꞌnjofoho. Oso sɨkuno aeꞌuyo somo oso aꞌamu homo somo ulɨkaꞌmnefoho. ");
INSERT INTO apz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Hwapɨngoso nje aꞌapahoso wopayo ne paꞌnyofoho. Nje honɨyoso mijo ne paꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aꞌamu kako nje aꞌapaho soꞌnji nje honɨyo soꞌnji nnososo ngko kakimo humahmꞌmeꞌno kako ngkimo wonɨhumamontonoho. Oso aꞌamu hiso kako nje hungkunomo aho yokumpohnꞌnyo kemokosyohumunyofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nje Mpohwo songo neꞌno humaso sohwo kako nɨhwatɨmentiso soꞌno ngko nje Mpohwoe yokumpohnꞌnyo soꞌnji songo humaleno. Oso paꞌnyoso aꞌamu fihwo kako sɨkuno huhwo huhwi wosopayoꞌnji mijoꞌnji nɨwoꞌnɨngkiso hopaso kako ngkineꞌno sɨkuno huhwo huhwi huno syanɨfɨsyɨwoꞌnɨngkuhwosoꞌmanji kako nje yokumpohnꞌnyo nomahwosi songo wohumamontonoho. ");
INSERT INTO apz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Olo wosopayo ahwomo mtaꞌango lohwoꞌni oso wosopayo seyakwosa sohwa hofɨko aꞌamu mohumunyo sopo nɨmotofo paꞌnyo hwoꞌnɨꞌmaho. Oꞌo, oso wosopayo hiso mantɨfi nontɨfeso hofɨko poyo napeꞌnɨmotofofoho. I osoꞌno olo wosopayo lohwoꞌnɨmo aꞌamu fihwo nnososo kako songo neꞌno nohumantɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas kako oso ango Koponeyammjo tajo ango somo humanto oso hungkuno hiso lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Oso hungkuno homo somo Jisasɨye inomokomoyo piꞌnɨngo sohwonaꞌni nupoꞌnontani fehohnjoso hnnɨmentohofi, Olo hungkuno loso tango weꞌeꞌnjo hwoꞌmaho. Hungkuno hwapɨngo neso nakwo huno monayohiyohoho. Haloho tɨhwo upoꞌmonteto. ");
INSERT INTO apz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisas kakoe inomokomoyo fehohnjoso oso hungkuno mjahnnɨmentohofoso Jisas kakimo ko mulahonɨngkofi kako oso hisoꞌno huno uyahonɨngki hofɨkimo ulɨmento, Olo hungkuno ngko seloheso sekwoe hunomo wonyo lasemokohoho. Sekwo ngkimo wonɨhwotɨꞌmofantɨfetaho. ");
INSERT INTO apz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","I ngko Aꞌamufe Hwomu sohwoꞌni ngko nje ango ne soponeꞌno asomo sɨme sohonta sekwo ngkimo nonohonɨfitnneꞌmanji sekwo huno pipi seyoneto. ");
INSERT INTO apz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anɨtuye Towahuno sohwo kakoꞌnohini songo neꞌno humayoꞌneso hwapɨngo hweho. Sekwo oso hwe huhwo sohumtaꞌni womantɨfeho. Sekwoe aꞌapahomjo yokumpohnꞌnyo mosefoꞌmanehoho. Oꞌo, aꞌamu Anɨtuye Towahuno momasoꞌnjo sohwo kako songo neꞌno humayoso motɨpemanehoho. I osoꞌno sekwo Anɨtuye Towahuno mayo soꞌno nto selohefoho. Nje hungkunomo inɨngkafijoso sekwo songo neꞌno humafitnnefoho. ");
INSERT INTO apz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Aꞌamu fehohnjo sekwoꞌnjo ajwo soꞌmo humalofoso hofɨko ngkineꞌno sɨmeho hiꞌntnnono montapeꞌnjo yalokwofo. Ose nalɨmentisofoho. Hwapɨngoso sɨmoꞌmtaꞌango Jisas kako oso aꞌamu kakimo sɨmeho hiꞌntnnono muyɨfitnne somneꞌno kako huno nto syafɨhuꞌmentisofoho. Osoꞌnji kako oso aꞌamu kakineꞌno tokoyoꞌofo ulohofone sohuneꞌno huno umentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jisas aꞌamu huhwo sohwamo nomꞌne hungkuno ulɨmento, Sekwo fehohnjo soku ngkimo sɨmeho montapeꞌnjo yalokwofo soꞌno ngko olo hungkuno hiloso nto seloheso olenoho. Nje Mpohwo kako aꞌamu somo momikinjosehwajiyoꞌnjo yosoꞌmanji sekwo ngkiyepono mapofitnnehofo. ");
INSERT INTO apz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Oso hungkuno hiso Jisas kako ulahonɨngki kakoe inomokomoyo piꞌnɨngoso kakimo uhwatɨꞌmofontɨfi humpoꞌmentohofofoho. Hofɨko kakoꞌnji hano apaꞌno memayofoho. Nɨhuꞌnahone uhwatɨꞌmoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Oseso Jisas kako kakoe inomokomoyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sohwonaꞌnɨmo nalɨmento, Sekwo huhwasi wonɨhwotɨꞌmofantɨfetaho. ");
INSERT INTO apz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ose nelohonɨngkahonɨngki, Saimoun Pita ulɨmento, Hwe Engofo, Nakwo tɨhwoepono humpeenehwono. Oꞌo, kɨkoꞌnohini songo neꞌno humayoꞌne hungkunoso hiꞌnjo hwosoho. ");
INSERT INTO apz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Jɨje hungkuno homo somo sɨmeho hiꞌntnnono kijopalokuhwono. Nakwo huno ole nayohoho. Kɨko Anɨtuye hwomu ne sohwosi wopɨngoꞌnohini hwosoho. ");
INSERT INTO apz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ose ulahonɨngki Jisas nalɨmento, Nje inomokomoyo aho hopiꞌnono sɨfe mtaꞌni hufaꞌuyo sohwasi ngko sehwosopoꞌmentohe hwasoho. I osoꞌno ngko sehononji angaꞌnohino sohwosi towahuno wonyo Seten mtaꞌangoso hiꞌnjo hwosoho. Ose nalɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Oso hungkuno Jisas nalɨmentisoso kako Jutas, Saimoun Isɨkaliyoutɨye hwomumneꞌno nalɨmentisofoho. Hwapɨngoso Jutas huhwo sohwo kako Jisasɨye inomokomoyo ko inomokomojo sohwo kako aku ikinji ehumanto Jisasɨmneꞌno tokoyoꞌofo ulohoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Oso hohosohonta Jisas kako hwaho Ngkalili sopo nowento hano emoimentisofoho. Aꞌamu Jutafe hwe engo sohwa Jisasɨmo wofonjosyano lontɨfi yahonɨngkofi kako hwaho Jutiya sopo hano memoyoꞌnjo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Oso aꞌamu Jutaso hofɨkoe sɨkuno iyoho humayo nomꞌne engoso mofonepo umoꞌnɨmonto imentisofoho. Oso sɨkuno hiso aꞌamu Jutafe hofiyakwosa hofɨko hwapɨfe ango molontɨfi humamotofo sohonta Anɨtu hofɨkimo hofiyo mokosyohumamojo soꞌno huno syafɨsiyoꞌne sɨkunofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Oseso Jisas kakoe homnɨngkwaꞌwehwosa kakimo sitofo hungkuno ulɨmentohofi, Kɨko olo hwaho Ngkalili lopo sopo nohumahotoho. Oꞌo, kɨko hwaho Jutiyaꞌneꞌno sohoji osopo yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso kɨko yohojoꞌno aꞌamu piꞌnɨngoso kikimo kohonɨngkuji jɨje yofe engo umoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kɨko yofe engo womaꞌmo lohojɨꞌmanji olo hiyaso loꞌmo pehoꞌno humahnno. Kɨko yofe engo ne hiꞌnjo hwosɨꞌmanji kɨko yoꞌmayo wonyoangkafoso aꞌamu hopiꞌnonohino somo fitɨhwaho. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hwapɨngoso homnɨngkwaꞌwehwosa huhwanji Jisasɨmo sɨmeho hiꞌntnnono mummentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisas hofɨkimo ulɨmento, Ngko ango Jelusalemneꞌno utɨhwaꞌnyopo sɨmne sɨkunoso mꞌmofapefoho. I sekwo yoꞌmayoso uyano lɨkujɨꞌmanji sekwo aꞌamu hwahoponjo soku sɨkuno engolopohamo sekwoe sɨkunofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Olo hwaho loponjo hwe moyaꞌmi hopiꞌnonohinoso hofɨko sekumneꞌno sɨmeho tohino mosejopalokuyohofo. Oꞌo, sɨmeho tohino ngkimnohini ntopantokwofo. Hwapɨngoso yoꞌmayo yahino wonyo hofɨko iwoꞌnɨngkohofo soꞌno ngko lɨjwaofɨwoꞌnɨngkohe soꞌno sɨmeho tohino ntapɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nje nɨngkwahwoso sohwasi sekwo nosɨkuji sekwo oso sɨkuno iyoho humayo engo somo fisɨhwonamno. I, ngko oso sɨkuno iyoho humayo engo somo mosɨhwonamnehono. Nje sɨkuno ngko siyoꞌneso ntoꞌno mmoꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jisas kako ose ulonto oso hwaho Ngkalili sopo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jisas homnɨngkwaꞌwehwosa sohwa hofɨko oso Sɨkuno Engo somneꞌno sɨkwato lohofahonɨngkofi Jisas kako huhwo sɨmentisofoho. I osoꞌno kako utɨhwaꞌnyopo sɨmentisoꞌmaho. Oꞌo, hiyasoꞌmo sɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aꞌamu Jutafe hwe engo sohwa hofɨko oso Sɨkuno Engo somo humawoꞌnɨngkohofo sopo humantɨfi Jisasɨmneꞌno hafɨhafe tɨpentɨfi aꞌamu somo ulohonɨmentohofi, Jisas kako ntɨꞌmo humaho. ");
INSERT INTO apz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hwe moyaꞌmi piꞌnɨngo engoso hofɨko mtitofo mtitofo syohumolawentɨfi aꞌamu fehohnjoso ole lɨmentohofi, Jisas kako wopɨngo hweho. Aꞌamu fehohnjoso ole lɨmentohofi, Jisas kako aꞌamumo hwasyo hungkuno lɨkuꞌmofɨwoꞌnɨngkiso hweho. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","I osoꞌno aꞌamu hopiꞌnonohino hofɨko hwe engo sohwamneꞌno iyoho unɨngkahonɨngki hofɨko hungkuno utɨhwaꞌnyopo mahnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Oso Sɨkuno Engo iyoho humayo ajwo sopo Jisas kako Anɨtuye tajo ango engo somo noswonto aꞌamu somo utɨhwaꞌnyopo hungkuno lomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aꞌamu Jutafe hwe engo sohwa hofɨko Jisasɨye hungkunomo upoꞌnantɨfi yomo yontɨfi ole hnnɨmentohofi, Olo hwe lohwo kako huno engo loso ntɨꞌmtaꞌni tɨpemaꞌmasoto. Kako nakwoe sɨkule ango hungkuno atofo lutɨhwawoꞌnɨngkuhwone somo masyuyo hweho. ");
INSERT INTO apz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ose hnnɨngkahonɨngkofi Jisas kako hofɨkimo ulɨmento, Olo hungkuno selalokwe loso nje huno mtaꞌango moselalokuyohono. Oꞌo, Anɨtu kako ngkimo nɨhwatɨmentiso sohwo ntahonɨngki selalokweno. ");
INSERT INTO apz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Aꞌamu fihwo kako Anɨtuye hungkunomo unɨngkamo loso sohwo kako olo nje hungkuno lomneꞌno kako huno ole uyono. Hungkuno loso kakoe huno mtaꞌnɨngoꞌmaho. Oꞌo, Anɨtuye huno mtaꞌnɨngofoho. Kako huno ose uyono. ");
INSERT INTO apz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Hwe fihwo kako kakoe huno mtaꞌni yoꞌmayo loso yoso sohwo kako yofe engo womaꞌmo lɨhwosi walɨmontonoho. I aꞌamu fihwo kako oso aꞌamu lɨhwatɨmentiso sohwoe yofe engoso sekwo nohoꞌnomapitnneꞌento selalokusoꞌmanji kako hwasyo hungkuno moselalofiyoho. Honɨngkano wonyo ane hweho. ");
INSERT INTO apz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Jisas ose ulonto ole ulɨmento, Hohonta Mouses kako seyakwosamo Anɨtuye honɨngkano hungkuno uyɨmentisofoho. I osoꞌno sekwo hopiꞌnonohino soku oso honɨngkano hungkuno somo hwotoho fentɨfi ntoꞌno minɨngkayoꞌnjo imotofokuyoho. Sekwo ose imentohofo soꞌno sekwo ngkimo pehoꞌno wofonjonisyantɨfeꞌno yalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ose ulahonɨngki hwe moyaꞌmi hopiꞌnonohinoso hofɨko Jisasɨmo ulɨmentohofi, Kikimo tɨhwo wofonjakohumontolo. Awonoho. Kɨko towahuno wonyo Seten mtaꞌangoso hiꞌnjo hwosoho. ");
INSERT INTO apz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","23","Hofɨko ose ulahonɨngkofi Jisas ulɨmento, Sɨkuno iyoho humayo fihumo ngko hwe mnokinoꞌnjo sohumo wopɨngo umokumentohe soꞌno sekwo sɨmeho tohino ntapɨwoꞌnɨngkohofofoho. I osoꞌno sekwo soku sɨkuno iyoho humayo somo syoho iwoꞌnɨngkohofokuyoho. Seyakwo Mouses sohwo honɨngkano hungkuno ole sejapmmento, Sekwo sɨkuno aho fehohnjo hopiꞌnonohino aho nomꞌne mtaꞌni hufaꞌu memjaofɨhwosoꞌno moꞌnɨngkanta hwomu milongo sohwamo aꞌapaho somo sɨhu fɨkolopmno. I Mouses oso hungkuno somneꞌno hwapɨngo hwoꞌmaho. Oꞌo, seyakwosa mtaꞌangofoho. I osoꞌno oso sɨkunoso memjaofɨhwosoꞌno sɨkuno iyoho humayo soꞌmanji sekwo oso sɨkuno somo syoho iwoꞌnɨngkohofɨhwasoho. Sekwo oso ko iwoꞌnɨngkohofo soꞌno ngko hwe sohumo wopɨngo umokumentohe oso sɨkuno somo sekwo ngkineꞌno sɨmeho tohino pehoꞌne ntopantokwofo. ");
INSERT INTO apz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sekwo yoꞌmayo yahino somo uhwonɨngkuji wonyofoho eso komoꞌno lɨkutoho. Oꞌo, sekwo sɨmoꞌmo hwapɨngo ne soꞌno huno ntoꞌno ikwesyafɨsyɨkuji sekwoe hunoso yano ntoꞌno mpopmno. Ose ikujoꞌno sekwo yahino wonyo soꞌnji wopɨngo soꞌnji huno ntoꞌno wotɨpemantɨfeho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hwe moyaꞌmi fehohnjo Jelusalem sopo humamotofoso ole hnnɨmentohofi, Olo hwe lohumo aꞌamu hwe engo sohwa wofonjosyano lontɨfi iwoꞌnɨngkohofo lohwolaho. ");
INSERT INTO apz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","I uhwonɨmno. Kako utɨhwaꞌnyopo lohofonto kakoe hungkuno lontanɨngki hofɨko yoka hungkuno mulalokuyohofo. I nakwoe hwe engo sohwa hofɨko olo hwe lohumneꞌno Anɨtu uhwatɨmentiso hweho ose kosyofɨsyalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ose hnnontɨfi nomꞌniso ole hnnɨmentohofi, I osoꞌno olo hwe lohwoe hwaho loponjo ango ne soꞌno nakwo huno nayohoho. Oso hwe Anɨtu uhwatɨmonnoho nalɨmentiso soꞌno kako iꞌmofape sohonta kakoe hwapɨngo soꞌno nakwo huno ntoꞌno monayonefoho. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisas kako Anɨtuye ango engo somo ajwoꞌmo nohumanto aꞌamu somo mango engo ulɨmento, Sekwo ngkineꞌno huno seyohoho. I sekwo nje ango soponeꞌno huno moiꞌwonoho. I osoꞌno nje hwapɨngo neso nje Mpohwo ngkimo nɨhwatɨmentiso sohuneꞌno sekwo huno ntoꞌno maseyohiyohoho. Ngko nje huno mtaꞌni pmmentohe hwonɨꞌmaho. Oꞌo, nje Mpohwo kako nɨhwatɨmentiso sohwo kako yoꞌmayo yahino ne soꞌno hwapɨngo hweho. I sekwo kakimo huno itoꞌno maseyokuyoho. ");
INSERT INTO apz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngkoꞌnohini kakineꞌno huno moiꞌwonoho. Hwapɨngoso ngko kakoꞌnji nohumentai kako huhwo ngkimo lonɨhwatɨmentiso soꞌno pmmentohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ose ulahonɨngki hofɨko kakimo impe untofantɨfi ko imentohofoso aꞌamu fihwo kakimo aho mokisahumentisofoho. Hwapɨngoso Jisas kakoe sɨkunoso mmoꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hwe moyaꞌmi piꞌnɨngoso hofɨko Jisasɨmo sɨmeho hiꞌntnnono uyontɨfi ole hnnɨmentohofi, Oso hwe sohumo Anɨtu uhwatɨmentiso sohwo nopɨhwosoꞌno kako olo hwe lohwoe yokumpohnꞌnyo somo uyakoloꞌmontolaho. Oꞌo, awonoho. Olo hwe oloho hweho. Ose hnnontɨfi tɨfi inɨngkamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aꞌamu Falisi sohwa oso hungkuno aꞌamu Jisasɨmneꞌno hnnɨmentohofo homo somo upaꞌnontɨfi hofɨkoꞌnji aꞌamu tajo ango syohoꞌnjo yofe engoꞌnjo sohwantnneꞌno hofɨko Anɨtuye ango engo somjo aꞌamu hwapɨfe tɨfoꞌnjo sohwamo Jisasɨmo impe intofoꞌne lɨhwatɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Lɨhwatɨmentohofo soꞌno Jisas kako huno uyahonɨngki kako aꞌamu kakoꞌnjoponjo somo ulɨmento, Sɨkuno weꞌenehwo ngko sekwoꞌnji wosɨmonnoho. Nohumahmꞌmo ngko nɨhwatɨmentiso sohwoepono asomo wawomonnoho. ");
INSERT INTO apz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Oso hohosohonta sekwo ngkineꞌno hafɨhafe ko tɨpɨfijoso manohonɨfitnnehofo. Hwapɨngoso oso ango ngko nuꞌmo humame sopo sekwo monɨꞌmapitnnefoho. ");
INSERT INTO apz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ose ulahonɨngki aꞌamu Juta sohwafe hwe engo sohwa ole hnnɨmentohofi, Oseso olo hwe lohwo kako ntente we sopo uhwonantanto nakwo huno uhwonyosofo. Kako aꞌamu Ngkɨlik sohwafe hwaho sopo nowehwosi aꞌamu Juta oso hopo sopo humawoꞌnɨngkohofo soꞌnji aꞌamu temtitofo kengo Ngkɨlik soꞌnjimo kakoe hungkunoso wolutɨhwamtolɨkeno. ");
INSERT INTO apz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ole nalohi, Sekwo ngkineꞌno hafɨhafe ko tɨpɨfijoso manohonɨfitnnehofo. Ose nalonto ole nalohi, Sekwo ango ngko humame sopo sekwo monɨꞌmapitnnefoho. Oso hungkuno nalisoso hwapɨngo neso pehomto. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Oso sɨkuno nɨhuꞌno engo iyoho humayo aeꞌuyo sohonta Jisas nolɨkafonto mango engo ole ulɨmento, Aꞌamu mijoꞌno umoꞌnoso sohwo kako ngkiyepono nopɨhwosi ngkintaꞌni wannono. ");
INSERT INTO apz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Aꞌamu Anɨtuye hungkuno mtɨꞌmokumentohofo sohwa ole mtɨꞌmokumentohofi, Aꞌamu ngkineꞌno sɨmeho hiꞌntnnono ntaposo sohwo kakoe sɨmeho soꞌmo mijolɨmo hopa imoꞌnɨngkuhwosi oso mijo songo neꞌno humayoꞌneso hano lohoꞌnawoꞌnnyofoho. Ose mtɨꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mijoꞌno Jisas ulɨmentisoso Anɨtuye Towahuno Wopɨngo somneꞌno ulɨmentisofoho. Aꞌamu sɨmeho hiꞌntnnono unyo sohwa hofɨko Anɨtuye Towahuno mapitnneꞌno ulɨmentisofoho. I osoꞌno Jisas kakoe yofe engo soꞌnji kakoe yokumpohnꞌnyo hwofiloꞌnnyo soꞌnji momasoꞌnjo osoꞌno Anɨtu kakoe Towahuno aꞌamu homo somo muyoꞌnjo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hwe moyaꞌmi fehohnjo sofanji Jisasɨye hungkuno upaꞌnontɨfi ole hnnɨmentohofi, Ou, nehopeho. Oso hwe sohumo Anɨtu hungkuno uyahonɨngki nalone sohuneꞌno hontohumawoꞌnɨngkuhwoneso olo huhweho. ");
INSERT INTO apz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ose hnnɨngkahonɨngkofi nomꞌne aꞌamuso ole hnnɨmentohofi, Olo Kɨlaisɨyoho. Anɨtu kako ahwomo mtaꞌni uhwatɨmentiso hweho. Ose lahonɨngkofi nomꞌneso ole hnnɨmentohofi, Oꞌo, Kɨlais kako hwaho Ngkalili sopo mꞌmofaponehoho. ");
INSERT INTO apz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","I aꞌamu Anɨtuye hungkuno mtɨꞌmokumentohofo sohwa olo hisoꞌno yoloho mtɨꞌmokumentohofofoho. Kɨlais kako hwe engo Ntefitɨye temtitofo iꞌmofapɨhwosi oso ango Mpetɨlehem Ntefit humamojo hopo sopo uꞌmofapmmontonoho. Olo hwe lohwo kako Ngkalili sopo iꞌmofapmmentisofoho. Oso huno hwasyo syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Oseso aꞌamu Jisasɨmneꞌno huno kengo kengo syafɨsyontɨfi hwe moyaꞌmi hofɨko Jisasɨmneꞌno hotitoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aꞌamu fehohnjo sohwa hofɨko Jisasɨmo impe untofosyano lontɨfi ko imentohofoso aꞌamu fihwo Jisasɨmo aho mokisahumentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Oseso aꞌamu hwapɨfe tɨfoꞌnjo sohwa hofɨko aꞌamu Falisi sohwanji aꞌamu tajo ango syohoꞌnjo yofe engoꞌnjo sohwafe poneꞌno asomo nopahonɨngkofi hwe engo sohwa yoka ulɨmentohofi, Sekwo Jisasɨmo impe mintokwape pipi yohofo. ");
INSERT INTO apz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ose ulahonɨngkofi hwapɨfe tɨfoꞌnjo sohwa ulɨmentohofi, Jisas kako hungkuno wonyoangkafo lisoso nakwo hungkuno oso paꞌnyoso nakwo mupaꞌnɨngkohoyɨhwono. ");
INSERT INTO apz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ose ulahonɨngkofi aꞌamu Falisi sohwa ulɨmentohofi, I sekwo huhwahnnji Jisasɨmo sɨmeho uyahonɨngkofi hwasyo honɨngkanomo ipesemotasewesotaho. ");
INSERT INTO apz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","I nakwo hwe engo sohwonaꞌnnonji aꞌamu Falisi sohwonaꞌnnontnne hwe fihwo kako Jisasɨmo sɨmeho hiꞌntnnono unyo sohumo lɨhwonalokwofo. Nɨhuꞌno awonoho. ");
INSERT INTO apz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Olo aꞌamulo Jisasɨmo sɨmeho uyalokwofo sohwa hofɨko Mousesiye honɨngkano hungkuno somo huno muyofoho. Osoꞌno Anɨtu aꞌamu homo somo tohino uyɨmontonoho. Oso hwasyo hungkuno ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikoutimos kako hohonta Jisasɨmo uꞌmaꞌmentiso sohwo kako huhwo aꞌamu Falisi hweho. Kako hofɨkoꞌnji nohumanto ulɨmento, ");
INSERT INTO apz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Nakwoe honɨngkano hungkunoso ole nalɨwoꞌnɨngkisotaho. Aꞌamufe hungkuno mupaꞌnyoꞌmtaꞌni tohino siki uyo. Ose nalɨwoꞌnɨngkisotaho. Oꞌo, sɨmoꞌmo kakoe hungkuno yoloho neso upaꞌnɨngkuhwasi yoꞌmayo iwoꞌnɨngkiso soꞌno huno ntoꞌno nayɨhwasoꞌno u, osohonta kakoꞌne hungkuno nano womtitofantanoho. ");
INSERT INTO apz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ose ulahonɨngki hofɨko ulɨmentohofi, I kɨko huhwo hnnonji Ngkalili ntaꞌango hwosilaho. Anɨtuye hungkunomo atofo fiso. Atofo lohoji olo soꞌno huno wotɨpemaꞌmonnoho. Aꞌamu Anɨtu hungkuno uyɨhwosoꞌno nalone sohwo hwaho Ngkalili sopo mꞌmofaponehoho. Oseso kɨko huno wotɨpemaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ose ulahonɨngkofi hofɨko hofɨkoe angopono humpoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Oso sɨkwoꞌmiyo somo Jisas kako hwofɨkiꞌnyo Oulif sopo sɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Moꞌnɨngka sohonta imɨngoꞌnji Jisas apaꞌno Anɨtuye tajo ango engo somo asomo noponto sɨmentisofoho. Hwe moyaꞌmi hopiꞌnonohino Jisasɨmo uꞌmahonɨngkofi Jisas kako ampo nohumanto kakoe hungkunoso lutɨhwamentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ose lutɨhwentanɨngki aꞌamu honɨngkano hungkuno lutɨhwamotofo sohwanji aꞌamu Falisi sohwanji hofɨko ape hwaꞌntesimo ipemotasontɨfi Jisasɨꞌnjo ajwopo uhumatɨmentohofofoho. Oso apesi kako nomꞌne hweꞌnji saho fosyowentanɨngki hwe engo sohwa uhwonɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Oseso hofɨko Jisasɨmo ulɨmentohofi, Nakwoe Lonetɨhwayo sohwosi, olo ape losi hufo yontanɨngki uhwonɨmalohwoniyoho. ");
INSERT INTO apz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mousesɨye honɨngkano hungkunoso ole nalɨmento, Hwoyaꞌmi yahino wonyoꞌnjo ose somo sojo mehwasi wofonjosyano. Ose nalɨmentisofoho. I osoꞌno kɨko huno pipi kiyohoho. Pipi yanehwono. ");
INSERT INTO apz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Hofɨko Jisasɨye hunomo yamofo ulohofoꞌne oso ulohonɨmentohofofoho. Huno ole syafɨhuꞌmentohofi, Jisas kako Mousesɨye honɨngkano hungkunomo mtɨhupe soꞌmanji nomꞌne hungkuno kengo nalosoꞌmanji nakwo kakimo impe untofantanoho. Ose syofɨsyahonɨngki Jisas kako ingkuꞌnohumanto kako kakoe ajoꞌmiyoꞌnji hwahomo ifalifaliyo mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hofɨko Jisasɨmo neꞌno neꞌno ulohonɨngkahonɨngkofi Jisas kako nolɨkafonto ulɨmento, Aꞌamu fihwo honɨngkano wonyo nɨhuꞌno aneso sekwoꞌnjo ajwo lopo sojo sɨmoꞌmjoso aꞌmu simo wohoꞌnamofono. ");
INSERT INTO apz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ose ulonto kako apaꞌno ingkuꞌnohumu lohofonto hwahomo apaꞌno ajoꞌmiyoꞌnji ifalifaliyo mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hofɨko Jisasɨye hungkunomo upaꞌnontɨfi aꞌamu angaꞌno angaꞌno hotahumentohofofoho. Hwe yofe engoꞌnjo sohwa sɨmoꞌmo hotoswopahonɨngkofi hwe nomꞌne sohwa hofɨko tɨfi hotahumentohofofoho. Aꞌamu hopiꞌnonohinoso Jisasɨmo ulɨkoꞌmahonɨngkofi Jisas kakoꞌnohini nohumentanɨngki oso aꞌmusi kako Jisasɨye sɨmanopo neꞌno lohoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas nolɨkafonto aꞌmu simo ulɨmento, Olo aꞌmu losi, aꞌamuso ntɨꞌmo humalofo. Aꞌamu angaꞌnohinoso kikimo poyo wokumokano makiloho liyohofo. ");
INSERT INTO apz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jisas ose ulahonɨngki aꞌmusi ulɨmento, Hwe Engofo, aꞌamu ose manjofoho. Hopiꞌnono nto humpehofo. Ose ulahonɨngki Jisas ulɨmento, Ngko huhwoꞌni poyo makumokohoyohono. Kɨko nowehoji oso wonyo hiso apaꞌno iyoꞌeno. Oꞌo, honɨngkano wopɨngoꞌnohini fiyohoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas aꞌamu somo hungkuno apaꞌno ulɨmento, Ngko olo hwaho lopone pomponaho hwoꞌnyoho. Aꞌamu ngkimo tɨfi nnɨngkaposo sohwo kako sɨkwoꞌmjohoꞌmo memoyonehoho. Oꞌo, kako songo neꞌno humayoꞌne pomponaho hiꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ose ulahonɨngki aꞌamu Falisi sohwa ulɨmentohofi, Kɨko kikineꞌno hnnɨwoꞌnɨngkino hwosoho. Oseso nakwo huno monayohoyohoho. Jɨje hungkuno nehopitɨkeno, hwasyotɨkeno. Nakwo huno monayohoyohoho. ");
INSERT INTO apz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ose ulahonɨngkofi Jisas ulɨmento, Ngko ngkineꞌno hnnalokweno. I osoꞌno nje hungkuno neꞌnjofoho. Hwapɨngoso ngko nje hwapɨngo ne pmmentohe sopono huno niyohoho. Osoꞌno ngko ango nosɨmne soponeꞌno huno niyohoho. I osoꞌno sekwo nje hwapɨngo ne sopono huno maseyohoyohoho. Ngko hano umne soponeꞌno sekwo huno maseyohoyohoho. ");
INSERT INTO apz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Sekwo aꞌamu hwahoponjofe yahinomo yano ilofɨwoꞌningkohofɨhwasoho. I ngko aꞌamufe yahino somo oso hopa yano milofɨwoꞌnɨngkiyohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","I osoꞌno ngko nomꞌne aꞌamumneꞌno yano iloꞌmeꞌmanji ngko ntoꞌnohino uloꞌmnoho. Hwapɨngoso ngkoꞌnohinɨꞌmaho. Oꞌo, nje Mpohwo nɨhwatɨmentiso sohwoꞌnji nohumentai yalokuhwoyo. ");
INSERT INTO apz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sekwoe honɨngkano hungkuno somo ole woꞌnnyofoho. Aꞌamu hufaꞌu hwaꞌu hungkuno afaꞌnohini lisoso nakwo huno ole wonayono, Sikoe hungkunoso neꞌnjofoho. Ose woꞌnnyofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngko ngkineꞌno hungkuno hnnɨwoꞌnɨngkohefoho. I nje Mpohwo nɨhwatɨmentiso sohwo kako huhwo nje hwapɨngo soꞌno lɨwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ose ulahonɨngki hofɨko ulɨmentohofi, Jɨje Mpohwo ntɨꞌmo humaho. Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Sekwo ngkineꞌno huno ntoꞌno mosyafɨsiyoꞌnjohwasi kalohi sekwo nje Mpohwo huhuneꞌno huno mosyafɨsiyo hwasoho. Sekwo ngkineꞌno huno ntoꞌno seinyohwasɨꞌmanji ou sekwo nje Mpohwo huhuneꞌno huno ntoꞌno waseyɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Oso hungkuno hiso Jisas kako Anɨtuye tajo ango engo hamniyohoꞌnjo ango ajwo sopo lohofonto hwe moyaꞌmi somo hungkuno lutɨhwamentisofoho. Kako utɨhwaꞌnyopo ko humentanɨngki aꞌamu kakimo impe mintafeꞌnjo imentohofofoho. Hwapɨngoso kakoe sɨkuno poyo imoꞌnyoꞌne sɨkunoso mmoꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas kako nomꞌne hungkuno apaꞌno ulɨmento, Ngko ume sohonta sekwo ngkineꞌno hafɨhafe wonyopi wonyopi wotɨpeentɨfeho. Sekwo sekwoe honɨngkano wonyo somo poyo nopeꞌnɨngkuji sekwoe wonyo somjo tohino somo neꞌno humantokutnnefoho. Osoꞌno sekwo ngkimo monɨꞌmapitnnehofo. ");
INSERT INTO apz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ose ulahonɨngki aꞌamu Juta sohwa hnnɨmentohofi, Oso hungkuno nelalokunjoso hwapɨngo neso pehoto. Ole nelalofoho. Oso ango ngko uꞌmo humame sopo sekwo mafitnnehofo. Pipineto. Kako kakimo wofonjahinɨmtolɨkeno. ");
INSERT INTO apz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ose hnnɨngkahonɨngkofi Jisas ulɨmento, Sekwo enjwaꞌmtaꞌango kuyoho. Ngko yokintahopontaꞌango hwoꞌnyoho. Sekwo olo hwaho lopontaꞌango kuyoho. Ngko ahwomo mtaꞌango hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Osoꞌno ngko ole nto selohefoho. Sekwo poyo peꞌnɨngkuji sekwoe wonyoso wawoꞌmontonoho. Mpohwo kako ngkimo nɨhwatɨmentiso soꞌno sekwo sɨmeho hiꞌntnnono montapeꞌnjo ifijoꞌmanji sekwoe wonyoso wawoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ose ulahonɨngki hofɨko ulɨmentohofi, Kɨko tɨhwosilo. Ose ulohonɨngkahonɨngkofi Jisas ulɨmento, Ngko oso hwe so hwoꞌnyoho. Sɨmoꞌmo nto selɨmentohe so hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","I sekwoe yahino wonyo somneꞌno hungkuno piꞌnɨngo hiꞌnjo hwoꞌnyoho. I osoꞌno hwangku oso yahino somneꞌno hungkuno yano selofimnefoho. I olohonta yoꞌmayo nɨhwatɨmentiso sohwo ntɨmentiso soꞌnohini waselɨmonneꞌno yohono. Kakoe yahinoso neꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisas ose ulahonɨngki hofɨko Jisas Anɨtumneꞌno hofɨkimo ulɨmentiso soꞌno huno muyoꞌnjo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Oseso Jisas hofɨkimo ulɨmento, Hwangku sekwo ngko Aꞌamufe Hwomu sohwoꞌni fonjanɨsyɨkuji oso hohosohonta sekwo ngkineꞌno huno ole seyonefoho. U, oso hwe Anɨtu uhwatɨmentiso sohweho. Sekwo huno ose wotɨpemantɨfeho. Ngko nje huno mtaꞌni yoꞌmayo syohoso imentoheꞌmaho. Oꞌo, yoꞌmayo hungkuno nje Mpohwo ntɨmentiso soꞌnohini selɨmentohefoho. ");
INSERT INTO apz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mpohwo kako nɨhwotɨmentiso sohwo kako ngkoꞌnji humaho. Yoꞌmayo iwoꞌnɨngkoheso Mpohwo kakoe sɨmeho wopɨngo umokiyoꞌne iwoꞌnɨngkohe hwoꞌnyoho. Kako monɨsɨkwajonehoho. ");
INSERT INTO apz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ose ulahonɨngki hwe moyaꞌmi piꞌnɨngo engoso oso hungkunoso upaꞌnontɨfi Jisasɨmo sɨmeho hiꞌntnnono umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Aꞌamu Juta fehohnjoso Jisasɨmo sɨmeho hiꞌntnnono umentohofo somo Jisas ole ulɨmento, Sekwo sɨmeho nehopi ntapɨkujoꞌno sekwo nje hungkunomo tɨfi nehopi inɨngkafijo kuꞌmanji sekwo nje inomokomoyo ne kuyoho. ");
INSERT INTO apz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nje hungkuno nehopi somo huno seyosoꞌmanji oso hungkuno hiso sekwoe yahino wonyoso kiloꞌmokomokosyehumamojo somtaꞌni usɨhutofosemaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ose ulahonɨngki hofɨko Jisasɨmo ulɨmentohofi, Nakwoe neyakwo Apɨloham sohwoe imu hwonaꞌnyoho. Nomꞌnihwo nakumo ntohonta kiloꞌmokomokonesyohumamojoto. Awonoho. Osoꞌno kɨko pehoꞌno nalohino, Nje hungkunoso sekumo usɨhutofasemaꞌmontonoho. Pipineto. ");
INSERT INTO apz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ose ulahonɨngkofi Jisas ulɨmento, Hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Aꞌamu hopiꞌnonohino honɨngkano wonyoꞌnjo somo oso honɨngkano wonyo hiso hofɨkimo kiloꞌmokomokosyohumamojofoho. Osoꞌno oso aꞌamu hiso hofɨko oso honɨngkano wonyo sohwoe syoho ulohofiyo paꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aꞌamu syoho ulohofiyo sohwo kako kakwoꞌyohwoe syohoso ulohofisoso kakoe hwe engoꞌnjo nɨhuꞌnahone humayoꞌne hwoꞌmaho. Oꞌo, kako syoho ulohofiyoꞌnohino hweho. I osoꞌno hwe engo sohwoe hwomu sohwoꞌnohini engolopohamo humawoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Osoꞌno Anɨtuye Hwomu sohwoꞌni ngko sekumo honɨngkano wonyo somtaꞌni isɨhutofasemaꞌmeso nomꞌnihwo sekumo mokiloꞌmokomokosesyohumanehoho. Oꞌo, nɨhuꞌno awonoho. Nje aꞌamu ne nto imoꞌnɨngkohofo. ");
INSERT INTO apz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Sekwo Apɨlohamɨye imu sohwonaꞌnyoho lɨwoꞌnɨngkohofo soꞌno ngko huno niyohoho. Apɨloham sohwo kako Anɨtuye aꞌamu ne hweho. I osoꞌno nje hungkuno soꞌno nakwolaho lontɨfeso sekwo ngkimo wofonjonɨsyantɨfeꞌno yalokwofo soꞌno sekwo Apɨlohamɨye imu ne hwasɨꞌmaho. ");
INSERT INTO apz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngko nje Mpohwoꞌnji nohumanji yoꞌmayo ntahonɨngki losetɨhwawoꞌnɨngkohe hwoꞌnyoho. I osoꞌno sekwo sekwoe senɨngkwohwo ne sohwoe yahino somo nomantɨfi yalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jisas ose ulahonɨngki hofɨko ulɨmentohofi, Nakwoe mpohwo sohwo Apɨlohamɨyoho. Ose ulahonɨngkofi Jisas ulɨmento, I sekwo Apɨlohamɨye imu ne hwasɨꞌmanji sekwo Apɨloham imojo yahinoso sekwo ikutnnesohilo. ");
INSERT INTO apz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yoꞌmayo hungkuno nehopi Anɨtu ntahonɨngki ngko selɨwoꞌnɨngkohe hwoꞌnyoho. Oso hungkuno homo somo sekwo nakwolaho lontɨfi wofonjonisyatɨfeꞌno yalokwofo. Apɨloham kako aꞌamumo wofonjahumonto miyommentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Oꞌo, sekwo sekwoe senɨngkwohwo ne sohwoe yahinomo inɨngkowalokwofo. Ose ulahonɨngki ulɨmentohofi, Nenaꞌwohisi hwaꞌnyo yonto nakumo tɨpenemaꞌmentiso hwonanɨꞌmaho. Nanɨngkwohwo angaꞌnohino sohwo Anɨtuyoho. ");
INSERT INTO apz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo Anɨtu senɨngkwohwo ntentesi sekwo ngkimo sɨmeho ntapɨkutnnesohilo. Hwapɨngoso ngko Anɨtuꞌnji nofosyohumanji pmmentohe hwoꞌnyoho. Nje huno mtaꞌni pmmentohe hwonɨꞌmaho. Oꞌo, Anɨtu kako nɨhwojahonɨngki pmmentohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Sekwo nje hungkunomo huno ntoꞌno mosyafɨsiyoꞌnjo pehoꞌneto. Hwapɨngoso sekwo nje hungkunomo upaꞌnontɨfeso nakwolaho lontɨfeso haloho maposoꞌnjo hwasoho. ");
INSERT INTO apz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sekwoe senɨngkwohwo sohwo Setenɨyoho. Sekwo yokumpohnꞌnyo yohoꞌnontɨfi sekwoe senɨngkwohwoe yahinomo tɨfi inɨngkowalokwofo. Kako sɨmoꞌmtaꞌango aꞌamumo wofonjahumo lɨmojo hweho. Kako hungkuno neꞌnjo somno ngkilaho lɨmojo hweho. Hwapɨngoso yahino neso kakoe sɨmeho moꞌmo momnauyoho. Kako hwasyo hungkunoꞌnohini lɨmojo hweho. Kako yoꞌmayo hwasyo hungkunoso hwapɨngo hweho. ");
INSERT INTO apz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","I ngko sekumo hungkuno nehopi ko selahonɨngko sekwo nje hungkuno homo somo sɨmeho hiꞌntnnono montopalokuyohofo. ");
INSERT INTO apz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ngko honɨngkano wonyo yohesoꞌno tɨhwo wantɨmontolo. Awonoho. I osoꞌno ngko hungkuno nehopiꞌnohini selɨwoꞌnɨngkoheꞌmanji sekwo nje hungkunomo sɨmeho hiꞌntnnono montapeꞌnjo pehoꞌne yalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Anɨtuye mehomi ne sohwa hofɨko Anɨtuye hungkunomo haloho pewoꞌnɨngkohofofoho. I sekwo Anɨtuye mehomi hwasɨꞌmaho. Osoꞌno sekwo kakoe hungkunomo haloho maposoꞌnjo hwasoho. Jisas ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ose ulahonɨngki aꞌamu Jutafe hwe engo sohwa Jisasɨmo sitofo ulɨmentohofi, Ihwoni, nakwo kikineꞌno hungkuno nehopi lɨwoꞌnɨngkuhwono. Kɨko aꞌamu Someliya paꞌnyo hwosoho. Kɨko mewoso hwosoho. Setenɨye towahuno wonyoso kikimo ehuhnnakumoꞌnyo hwosoho. Nehopi lɨwoꞌnɨngkuhwono. ");
INSERT INTO apz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ose ulahonɨngkofi Jisas ulɨmento, Ngko towahuno wonyo ane hwoꞌnyoho. Oꞌo, ngko nje Mpohwoe yofe engo hoꞌnomalokweno. I sekwo nje yofemo hwotoho nɨfeentokwofo. ");
INSERT INTO apz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nje yofe hoꞌnomaꞌnyoꞌne ngko syoho miyalokuyohono. Oꞌo, Anɨtu kako nje yofe engo umokumontonoho. I aꞌamu yoꞌmayo wonyo ngkineꞌno huno syafɨsyɨwoꞌnɨngkohofo soꞌno Anɨtu kako tohino yano ulofiyonefoho. ");
INSERT INTO apz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Aꞌamu fihwo nje hungkunomo ntoꞌno inɨngkawesoꞌmanji kako poyo mapeꞌnyoꞌnjo songo neꞌno nohumantɨhwone hweho. ");
INSERT INTO apz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ose ulahonɨngki aꞌamu Jutaso Jisasɨmo ulɨmentohofi, Ihwoni, kɨko towahuno wonyoso nehopi hiꞌnjo hwosoho. Apɨloham kako poyo peꞌnɨmentiso hweho. I aꞌamu Anɨtu hungkuno uyahonɨngki lɨmotofo huhwanji peꞌnɨmentohofofoho. I osoꞌno oleso pehoꞌno lalokuno. Aꞌamu fihwo nje hungkunomo ntoꞌno inɨngkawesoꞌmanji kako poyo mapeꞌnyoꞌnjo songo neꞌno nohumantɨhwone hweho. Oso hiso pehoꞌno lohino. ");
INSERT INTO apz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kɨko neyakwo Apɨloham poyo peꞌnɨmentiso sohumo yakoloꞌnnyo hwosilaho. I kɨko oso aꞌamu Anɨtu hungkuno uyahonɨngki lontɨfi peꞌnɨmentohofo sohwamo uyakoloꞌnnyo hwosilaho. Kɨko tɨhwo paꞌnyo umoꞌnɨmonji lalokuno. ");
INSERT INTO apz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ose ulahonɨngkofi Jisas ulɨmento, I ngko nje yofe engo imokinantɨꞌmtentesi nje yofeso engoꞌmaho weꞌeꞌnohinesohilo. I osoꞌno sekwo nanɨngkwohwo Anɨtuyoho lɨwoꞌnɨngkohofo sohwo kako nje yofe engo nɨmokalofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","I osoꞌno sekwo Anɨtu ne sohumo huno maseyo hwasoho. Ngko kakineꞌno huno niyohoho. Ngko ole lontɨꞌmtentesi, Ngko Anɨtu sohumo huno maniyohoyohoho. Ngko ose lontɨꞌmtentesi ngko sekwo hopa hwasyo hungkunoꞌnjo hwoꞌnnesohilo. I osoꞌno ngko Anɨtu ne sohumo huno niyahonɨngki kakoe hungkunomo tɨfi inɨngkowalokweno. ");
INSERT INTO apz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Senɨngkwohwo Apɨloham sohwo kako Anɨtuye hungkunomo haloho poꞌmentiso soꞌno kako ngko olo hwaho lopo pmneꞌno huno uyahonɨngki soꞌno kako ngkimo tɨmo nehopi nohonɨmentisofoho. Osoꞌno kako ngkineꞌno sɨmonyo imentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ose ulahonɨngki aꞌamu Jutaso ulɨmentohofi, Soswo fifɨti (50) mokiyakolofe hwosoho. Kɨko Apɨlohammo tɨmo uhwonɨmentohino hwosilaho. Hungkuno hwasyo lalokuno. ");
INSERT INTO apz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ose ulahonɨngkofi Jisas ulɨmento, Hungkuno nehopi waselɨmonneꞌno yohono. Apɨloham kako mmoꞌnyo sohonta ngko humamote hwoꞌnyoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Oseso hofɨko sojo nomantɨfi Jisasɨmo wofonjosyano lontɨfi ko imentohofoso Jisas kako aꞌamu piꞌnɨngo engoꞌnjo soꞌmo hiyaso ifohuni ifohuni lohofonto mempono swapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas kako hano emoyonto hwe tɨmpiꞌnyo fihumo uhwonɨmentisofoho. Oso hwe huhwo sohwo konaꞌwohi aswo mayoso tɨmpiꞌnyo humomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jisas oso hwe huhwo sohumo uhwonɨngkahonɨngki Jisasɨye inomokomoyo sohwonaꞌni kakimo ulohonɨmentɨhwoni, Nakwoe Lonetɨhwayo sohwosi, oso hwe sohwo tɨmpiꞌnyoso pehoꞌne imoꞌnnyoto. Kako honɨngkano wonyo imofonto imoꞌnɨmentisotaho. Kanɨngkwohwoꞌyaꞌu honɨngkano wonyo imoꞌmentisiyomo imoꞌnnyotaho. ");
INSERT INTO apz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Inomokomoyo sohwonaꞌni ose ulahonɨngkuhwoni Jisas nalɨmento, Oꞌo, olo hwe lohwoe tɨmpiꞌnyo imoꞌnyo hwapɨngoso kakoe honɨngkano wonyo mtaꞌangoꞌmaho. Kanɨngkwohwoꞌyaꞌuye honɨngkano wonyo mtaꞌangoꞌmaho. Oꞌo, olo tɨmpiꞌnyo imoꞌnyo hwapɨngoso Anɨtu kako olo hwe lohumo kakoe yokumpohnꞌnyo utɨhwaꞌnyopo uyɨmo lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ose ulonto kako pahnnɨmo hungkuno ole ulɨmento, Mofehiꞌnyo neꞌno lohofontanɨngkuhwosi nakwo yoꞌmayo syoho Anɨtu ngkimo nɨhwatɨmentiso sohwo nejapmmentisoso komoꞌno uyano. Sɨkuno mehwosoꞌno nakwo syoho miyanehwono. ");
INSERT INTO apz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ngko olo hwaho lopo nohumentanɨꞌmo olo hwaho loponjo pomponaho paꞌnyo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ose nalonto kako hwaho weꞌeso nomanto memijo hwahomo uyatɨꞌmofonto yokoꞌnyo imokonto tɨmpiꞌnyo sohwoe tɨmopo ulohoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ose ulohofonto ulɨmento, Kɨko nowehoji oso mijo ayo Silouam soponjo somo mijo fiyomaꞌnyo. Ose ulɨmentisofoho. Oso mijo yofe Silouamɨyoso hwapɨngoso olenoho, Lɨhwajiyofeꞌnefoho. Oseso oso hwe huhwo sohwo kako mijopo nowento mijomo yomaꞌnonto asomo nosaponto kako tɨmo wopɨngo honɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hohonta oso hwe huhwo sohwo kako tɨmpiꞌnyo nohumanto honɨngkano momɨngo sopo nohumentanɨngki aꞌamu nopasontɨfi nopawentɨfi yontanɨngkofi kako hofɨkintaꞌni hamniyoho yoꞌmayo soꞌno jomo ulɨmojo hweho. Oso aꞌamu huhwo sohwanji oso aꞌamu hwe tɨmpiꞌnyo sohwo kakoe ango afapontaꞌango sohwanji hofɨko hnnɨmentohofi, Pipilo. Olo hwe lohwo kako honɨngkano lopo nofosyohumanto nakumo hamniyoho yoꞌmayo soꞌno jomo nalɨwoꞌnɨngkiso lohwolaho. ");
INSERT INTO apz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ose hnnɨngkahonɨngkofi aꞌamu fehohnjoso ole lɨmentohofi, Ou, olo hwe lohwo sohwo olo huhweho. I nomꞌnihwo ole lɨmentohofi, Oꞌo, awonoho. Oso hwe huhwo sohwo paꞌnyo hwolɨkeno. Ose lahonɨngkofi oso hwe tɨmpiꞌnyo wopɨngo umokumentiso huhwo sohwo ole ulɨmento, Ngko olo huhwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ose ulahonɨngki hofɨko ulɨmentohofi, Jɨje tɨmo wopɨngo kumoꞌnɨngkisoso pipi yohinoto. ");
INSERT INTO apz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ose ulohonɨngkahonɨngkofi kako ulɨmento, Oso hwe Jisasɨyoho lɨwoꞌnɨngkohofo sohwo kako hwahoꞌnji memijoꞌnji iwoloꞌmokonto kako nje tɨmopo ntohofisofoho. Kako nantohofonto ntohi. Kɨko nowehoji mijo ayo Silouam mtaꞌni mijo fiyomaꞌnyo. Ose ntahonɨngki ngko nowenji mijo yomaꞌnɨngkoheso nje tɨmo wopɨngo nɨmoꞌnɨngkohoho. Tɨmo yoꞌmayo somo uhwonɨngkohono. ");
INSERT INTO apz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ose ulahonɨngki hofɨko ulɨmentohofi, Oso hwe huhwo sohwo ntɨꞌmo humaho. Ose ulahonɨngkofi kako ulɨmento, Kakoe humayo soponeꞌno ngko huno maniyohoyohoho. ");
INSERT INTO apz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ose ulahonɨngki hofɨko oso hwe tɨmpiꞌnyo emmojo sohumo aꞌamu Falisi sohwafepono ipemotamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Hwapɨngoso oso sɨkuno somo Jisas kako oso hwaho memijoꞌnji iwoloꞌmokonto hwe sohwoe tɨmo wopɨngo umokumentisoso sɨkuno iyoho humayo somnoho. ");
INSERT INTO apz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Hofɨkoe ango sopo iꞌmofapontɨfi hofɨko kakimo apaꞌno ulohonɨmentohofi, Jɨje tɨmo wopɨngo imoꞌnyoso pipi yonji honɨmahnnoto. Ose ulahonɨngkofi kako ulɨmento, Kako hwaho yokoꞌnyoso nomanto nje tɨmopo ntohofahonɨngki ngko mijo yomaꞌnɨmaleso ngko tɨmo honɨmalefoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Aꞌamu Falisi fehohnjo sohwa ole lɨmentohofi, Oso Jisas huhwo sohwo kako sɨkuno iyoho humayo somo syoho iwoꞌnɨngkiso soꞌno nakwo huno ole nayohoho. Kako Anɨtu mtaꞌango hwoꞌmaho. Ose lahonɨngkofi nomꞌnihwa ulɨmentohofi, I kako nakwoe honɨngkano wonyoꞌmtaꞌango hwoꞌmanji kako olo wonyoangkafo nakwo miyɨwoꞌnɨngkuhwone loso pipi imasoto. Ose lontɨfi hofɨko hwasyopo hotitofontɨfi yoka hungkuno hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Oseso aꞌamu Falisi sohwa hofɨko oso hwe huhwo sohumo apaꞌno ulohonɨmentohofi, Oso hwe jɨje tɨmo wopɨngo kumokumaso sohumneꞌno kɨko huno pipi kiyohoho. Ose ulohonɨngkahonɨngkofi kako ulɨmento, Oso hwe huhwo sohumo Anɨtu hungkuno uyahonɨngki nalɨwoꞌnɨngkiso hweho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Oso aꞌamu Jutafe hwe engo sohwa hofɨko oso hwe tɨmpiꞌnyo emmojo sohwoe hungkunomo sɨmeho hiꞌntnnono mummentohofo soꞌno hofɨko huno ole syafɨhuꞌmentohofi, Olo hwe lohwo kako tɨmpiꞌnyo memmojo hweho. Oꞌo, nomꞌni hweho. Ose syafɨsyontɨfi kanɨngkwohwoꞌyaꞌumneꞌno joho ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Joho ulontɨfi ulɨmentohofi, Oloso sikoe hwomutaho. Konaꞌwohi aswo maꞌmentiso sohonta tɨmpiꞌnyo maꞌmentiso hwoꞌmanji i olohonta kakoe tɨmo wopɨngo pipi imoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ose ulohonɨngkahonɨngkofi kanɨngkwohwoꞌyaꞌu siko ulɨmentisiyo, Nekwo huno ole eyohoho. Oloso nekwoe hwomu hweho. Konaꞌwohi aswo maꞌmentiso sohonta kako tɨmpiꞌnyo maꞌmentiso hweho. Osoꞌntnne nekwo huno eyohoho. ");
INSERT INTO apz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","I osoꞌno olohonta kako tɨmo pipi yonto honɨngkohoho. Osoꞌno nekwo huno meyohoyohoho. I oso aꞌamu kakoe tɨmo wopɨngo umokumaso sohuneꞌno osoꞌntnne nekwo huno meyohoyohoho. I sekwo nekwoe hwomu sohumo ulohonɨmno. Kako engo nto imoꞌnɨmentono. Kako kakineꞌno sekumo hungkuno waselono. ");
INSERT INTO apz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Oso hungkuno kanɨngkwohwoꞌyaꞌu ulɨmentisiyo hwapɨngoso hofɨko Jutafe hwe engo sohwamneꞌno iyoho unɨmentisofoho. Hwapɨngoso oso hwe engo sohwa olo hungkuno nto kotɨkuꞌmentohofo, Aꞌamu fihwo kako Jisasɨmneꞌno kako Kɨlaisɨyoho. Anɨtu uhwatɨmentiso hweho lɨjwaofosoꞌmanji hofɨko oso aꞌamu huhwo sohumo tajo ango mtaꞌni wae yaopitnnefoho. ");
INSERT INTO apz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Oso hungkuno nto kotɨkuꞌmentohofo soꞌno kanɨngkwohwoꞌyaꞌu ulɨmentisiyo, Nekwoe hwomu engo nto imoꞌnɨmentiso hweho. Kakimo ulohonɨmno. ");
INSERT INTO apz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ose ulɨmentisiyo soꞌno hwe engo sohwa hofɨko oso hwe tɨmpiꞌnyo emmojo sohuneꞌno apaꞌno joho ulontɨfi ulɨmentohofi, Olo wonyoangkafo imoꞌnɨmaso soꞌno kɨko Anɨtuye yofeꞌnohini fohoꞌnomaho. Jisasɨye yofe nohoꞌnomahotoho. Kako hwe honɨngkano wonyoꞌnjo hweho. ");
INSERT INTO apz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ose ulahonɨngkofi kako ulɨmento, Jisas kako honɨngkano wonyoꞌnjo hwolɨkeno. Ngko huno maniyohoyohoho. I osoꞌno ngko oloꞌnohini huno niyohoho. Hohonta ngko tɨmpiꞌnyo humamote hwoꞌnyoho. Olohonta ngko tɨmo ntoꞌno honalokweno. ");
INSERT INTO apz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ose ulahonɨngki hofɨko ulɨmentohofi, Kako kikimo pipi kilohoꞌmasoto. Kako jɨje tɨmo wopɨngo pipi kumokumasoto. ");
INSERT INTO apz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ose ulahonɨngkofi ulɨmento, Oso hungkuno hiso ngko nto selɨmalefoho. Sekwo nje hungkunomo haloho maposoꞌnjo imalofɨhwasoho. Sekwo apaꞌno upoꞌnantɨfiꞌno lolalokwofo. Sekwo kakoe inomokomoyo umoꞌnantɨfiꞌno lolalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ose ulahonɨngki hofɨko hungkuno wonyo ulɨmentohofi, Kɨko kɨkoꞌnohini kakoe inomokomoyo hwosoho. I osoꞌno nakwo Mousesɨye inomokomoyo hwonaꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anɨtu kako Mousesɨmo hungkuno ulɨmentiso soꞌno nakwo huno nayohoho. I osoꞌno olo Jisas lohwo kako ntɨꞌmo iꞌmofapmmentiso hwolo. Nakwo huno monayohoyohoho. ");
INSERT INTO apz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ose ulahonɨngkofi kako pisopisaho lonto ulɨmento, Oso hwe sohwo kako nje tɨmo wopɨngo nɨmokumaso lohuneꞌno sekwo kakoe hwapɨngo iꞌmofapmmentiso soꞌno sekwo huno maseyoho hwasoho. ");
INSERT INTO apz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","I olo soꞌno nakwo huno nayohoho. Anɨtu kako aꞌamu honɨngkano wonyoꞌnjo sohwafe hungkunoso mupoꞌnalofiyoho. I osoꞌno aꞌamu fihwo kako Anɨtumo hwomtame ulofɨwoꞌnɨngkiso sohwo kako Anɨtuye hungkunomo tɨfi inɨngkayo soꞌno kako Anɨtuye sɨmeho wopɨngo imokuwoꞌnɨngkiso osohumo Anɨtu kakoe hungkunomo haloho upoꞌnalofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sɨmoꞌmtaꞌango sɨkuno memjaoꞌmoponto mpoyo olo paꞌnyoso mawoꞌnnyoponoho. Hwe fihwo konaꞌwohi maꞌmentiso sohonta tɨmpiꞌnyo meesyoso sohwoe tɨmoso hwangku hwe nomꞌnihwo wopɨngo umokonefoho eso mupaꞌnyofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","I Anɨtu oso hwe huhwo sohumo mɨhwatɨmentisoꞌmanji kako oso wonyoangkafo ntohoꞌmasoso miyɨhwonesohilo. ");
INSERT INTO apz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ose ulahonɨngki hofɨko ulɨmentohofi, Kɨko tohwoꞌnanjwo mehomi hwosoho. Nɨhuꞌno wonyo hwosoho. Kɨko Anɨtuye hungkuno wolonetɨhwamonntaho. Mpano. Ose yokumpohnꞌnyo ulontɨfi kakimo wae yaoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Oso hwe tɨmpiꞌnyo emmojo sohumo hwe engo sohwa tajo ango somtaꞌni wae yaoꞌmentohofo soꞌno Jisas upaꞌnonto oso hwe sohumneꞌno tɨpɨhwononto ulɨmento, Kɨko Aꞌamufe Hwomu sohumo sɨmeho hiꞌntnnono luyalokuno. ");
INSERT INTO apz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ose ulahonɨngki ulɨmento, U, Hwe Engofo, oso Aꞌamufe Hwomu sohwo tɨhwolo. Kɨko yoloho ntohojoꞌno ngko kakimo sɨmeho hiꞌntnnono uyɨmonnoho. ");
INSERT INTO apz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ose ulahonɨngki Jisas ulɨmento, Kɨko nto nohonɨngkohino. Ngko olo huhwoꞌni kilalokweno. ");
INSERT INTO apz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ose ulahonɨngki kako Jisasɨmo ulɨmento, Hwe Engofo, ngko sɨmeho hiꞌntnnono kijopalokweno. Ose ulonto kako hwomtame ehumanto Jisasɨye yofe hoꞌnomaꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Oseso Jisas nohumanto aꞌamu hopiꞌnonohino somo ulɨmento, Ngko olo hwaho lopo pmmentoheso aꞌamu olo hwaho loponjofe yahino somo yano ilofoꞌne pmmentohe hwoꞌnyoho. Oseso aꞌamu Anɨtuye yahino yoꞌmayo soꞌno nto tɨpemaꞌmentɨhwone soꞌno nakwo huno hwapɨngoꞌnjɨꞌnwoho. Nomꞌne huno songo tɨpemayoꞌne syoho engo pehoꞌne yanehwono. Nakwo tɨmpiꞌnyoꞌnɨꞌmaho. Ose lɨwoꞌnɨngkohofoso hofɨko tɨmpiꞌnyo hwafoho. Hofɨkoe tɨmpiꞌnyo hisomo ujo wehontojwahumonji pmmentohono. I aꞌamu Anɨtuye yahino yoꞌmayo soꞌno nakwo hunoꞌnjɨꞌmaho lontɨfe oso aꞌamu hofɨko tɨmpiꞌnyo paꞌnyo ko huhwo hofɨko huno wopɨngo tɨpemayoꞌne syoho engo yalokwofo. I ngko honɨngkano itoꞌnohino somo hofɨkimo utɨhwamonji pmmentoho soꞌno hofɨko huno wopɨngo tɨpemayoꞌne syoho engo yalokwofo soꞌno hofɨko tɨmo honyofoho. ");
INSERT INTO apz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ose ulahonɨngkofi aꞌamu Falisi fehohnjo sohwa Jisasɨꞌnjo mofonepo humamentohofo sohwa oso hungkuno hisomo upaꞌnontɨfi Jisasɨmo ulɨmentohofi, Nakwo sohwonaꞌni tɨmpiꞌnyo hwonaꞌntaho. Ose lolalokuno. ");
INSERT INTO apz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ose ulahonɨngkofi Jisas ulɨmento, Sekwo ole lontɨfijontentesi, Nakwo Anɨtumneꞌno huno ntoꞌnohino nainyo hwonaꞌnɨꞌmaho. Oꞌo, nakwo aꞌamu tɨmpiꞌnyo paꞌnyo hwonaꞌnyoho. Ose lontɨfijontentesi sekwo sekwoe honɨngkano wonyo somneꞌno tohino momapitnnesohilo. I osoꞌno sekwo ole lalokwofo. Nakwo Anɨtuye yahino somneꞌno huno hwapɨngoꞌnjo hwonaꞌnyoho. Nakwo tɨmo honyo hwonaꞌnyoho. Oseso sekwoe honɨngkano wonyo somneꞌno tohino nomapitnne hwasoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas nohumanto ulɨmento, Ngko hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Aꞌamu fihwo kako yahwolojo kuso sopo masyuyoꞌnjo sohwo kako nomꞌnepo kotasyɨhwosi swoso sohwo kako hufoꞌne hweho. ");
INSERT INTO apz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Oso yahu kakwoꞌyohwo ne sohwo kako kuso ne sopo syuwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Aꞌamu kuso sopo mokosyohumawoꞌnɨngkiso sohwo kakwoꞌyohwo ne sohumo uhwonɨngkuhwosi wohwosampoꞌmontonoho. Kakwoꞌyohwo nosyuhwosi yahu mehomi hopiꞌnonohinoso hofɨkoe yofe angaꞌno angaꞌno ulɨhwosoꞌno kakwoꞌyohwo sohwoe mampaho upaꞌnɨngkuji kakwoꞌyohwo sohumo tɨfi unɨngkoswantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kakwoꞌyohwo sohwo yahu somo mempono ipemotaswonto kako sɨmoꞌmo upeehonɨngkuhwosi yahuso kakoe mampahomo upaꞌnɨngkuji tɨfi unɨngkowantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yahu hiso hofɨko aꞌamu nomꞌnehumo minɨngkafitnnehofo. Hwapɨngoso hofɨko mampaho nomꞌne kengo upaꞌnɨngkuji hiyasoꞌmo wowantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas oso pahnnɨmo hungkuno ko ulahonɨngki aꞌamuso hofɨko hwapɨngo ne soꞌno huno mosyafɨsiyoꞌnjo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Oseso Jisas kako hungkuno homo somjo yolohoso ulɨmento, Ngko hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Ngko yahu mehomife hokuꞌyo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Aꞌamu ngko mꞌmofape sohontajo iꞌmofapmmentohofoso hofɨko hufoꞌne iꞌmofapmmentohofofoho. I osoꞌno nje yahu mehomi neso osohwafe mampaho somo haloho maposoꞌnjofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngko Jisas sohwoꞌni hokuꞌyo hwoꞌnyoho. Aꞌamu ngkimo nuꞌmanto kako hokuꞌyo sohwoꞌnɨmo noswahonɨngki ngko oso aꞌamu somo wopɨngo nomokosyohumahmꞌmeꞌno kako wopɨngo neꞌno nohumantɨhwonefoho. Oso aꞌamu somo kakoe wonyo somjo tohino somtaꞌni usɨhutofomaꞌmonnoho. Oseso oso aꞌamuso kako nosyuhwosi noswapɨhwosi ihwosi wosopayo wanɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Aꞌamu hufoꞌnohinoso hofɨko siki mapɨfitnnehofo. Oꞌo, hofɨko yahu hufo ikuji wofonjosyantɨfeꞌnofoho. Nɨhuꞌno wonyo umokantɨfe. I osoꞌno ngko nje yahu mehomi somo songo neꞌno humayoso uyɨmonji pmmentohe hwoꞌnyoho. Yoꞌmayo tango nje mehomi somo ko uꞌmasoso hofɨko nje ahomo humawoꞌnɨngkohofo soꞌno hofɨko sɨmeho wopɨngo engo yamoꞌnnyofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ngko yahu mehomi mokosyohumayo wopɨngo hwoꞌnyoho. Aꞌamu yahu mehomi mokosyohumayo wopɨngo sohwo huno ole syafɨsyɨwoꞌnɨngkiso, Nje mehomi poyo nopeꞌnɨfitnnoho lonji ngko hofɨkimo ufoꞌmayoꞌne wapeꞌnɨmonnoho. ");
INSERT INTO apz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Aꞌamu hamniyoho syohoꞌnohini iwoꞌnɨngkiso sohwo kako yahu somo nomokosyohumentanɨngki sikijo nopahonɨngki aꞌamu huhwo sohwo kako hiyaso lɨꞌmofɨwoꞌnɨngkiso hweho. Hwapɨngoso kako yahu mokosyohumayo hwapɨngo hwoꞌmaho. Kakwoꞌyohwo hwoꞌmaho. Osoꞌno sikisɨwojo sohwo kako yahu somo toho lofototoꞌmeefahonɨngki yahuso hiyaso humpewoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Hwapɨngoso oso aꞌamu huhwo sohwo kako hamniyohoꞌnohini syoho iwoꞌnɨngkiso hweho. Kako yahu somneꞌno huno mosyafɨsiyoꞌnji iwoꞌnɨngkiso hweho. ");
INSERT INTO apz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ngko yahu mehomi mokosyohumayo wopɨngo hwoꞌnyoho. Nje Mpohwo kako ngkineꞌno huno uyalokunjoso ngko kakineꞌno huno nɨyohoho. Oso paꞌnyoso ngko nje mehomi ne somneꞌno huno ntoꞌno niyohoho. Hofɨko ngkimo huno ntoꞌno uyohoho. Nje mehomi somo ufoꞌmayoꞌne ngko poyo wapeꞌnɨmonnoho. ");
INSERT INTO apz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nje mehomi fehohnjoso olo tojo somo mohumunyoponoho. Oso hisoꞌnji ngko utɨmaꞌmo hofɨko nje mampaho somo haloho wopeentɨfeho. Oseso oso yahu nomꞌne soꞌnji nemꞌno afaꞌno umoꞌnantɨfeho. Hofɨkoe mokosyohumayo sohwo kengaꞌnohino hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ngko nje yahu mehomi somneꞌno poyo peꞌnɨꞌmo ngko apaꞌno songo wolɨkaꞌmonnoho. Ose yalokwe soꞌno nje Mpohwo kako sɨmeho engo ntopalofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Aꞌamu fihwo kakoe huno mtaꞌni mofonjonɨsyanehoho. Oꞌo, ngko nje mehomi lomo ufoꞌmayoꞌne poyo wapeꞌnɨmonneꞌno yohono lɨmentohe soꞌno hofɨko ngkimo wofonjonɨsyantɨfeho. Nje Mpohwo kako olo hilo soꞌno ntonto kakoe yokumpohnꞌnyo ntapmmentiso soꞌno ngko poyo peꞌnyoꞌneso yokumpohnꞌnyo hiꞌnjo hwoꞌnyoho. Ngko apaꞌno songo lɨkafoꞌneso yokumpohnꞌnyo hiꞌnjo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ose ulahonɨngki aꞌamu Jutaso oso hungkuno homo somo upaꞌnontɨfi apaꞌno hotitoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aꞌamu fehohnjo piꞌnɨngoso ole hnnɨmentohofi, Towahuno wonyoso kakimo ehuhnnamofisoꞌno kako ilohofalofoho. Kakoe hungkunomo pehoꞌno upoꞌnalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","I osoꞌno aꞌamu fehohnjoso ole hnnɨmentohofi, Olo hungkuno Jisas liso loso aꞌamu towahuno wonyoꞌnjo oso hwa mtaꞌangoꞌmaho. U, towahuno wonyoso hofɨko aꞌamu tɨmpiꞌnyo somo wopɨngo umokumontolaho. Awonoho. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Oso ango Jelusalem sopo nomꞌne Sɨkuno Engo iyoho humayoꞌne iꞌmofapmmentisofoho. Oso Sɨkuno Engoso hofɨko hohonta Anɨtuye tajo ango engo somo hano hwosayoꞌne huno syafɨsiyoꞌnefoho. Oso hohosohonta kwongkwongonjohontanoho. ");
INSERT INTO apz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisas kako osopo nohumanto kako tajo ango engo somjo mempo ango hiso Soulomounɨyefoho lɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jisas osopo hano emoyontanɨngki aꞌamu Jutafe hwe engo sohwa hofɨko Jisasɨmo ehofoꞌmokomantɨfi ulɨmentohofi, Nakwo jɨje hwapɨngo soꞌno huno akweꞌno syafɨsyɨhwoneso yolohoso ntohonta wonalɨmonnto. Anɨtu ngko hwe uhwatɨmonnoho nalɨmentiso sohwosilaho. Yoloho fonaso. ");
INSERT INTO apz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ose ulahonɨngkofi Jisas ulɨmento, Yolohoso nto selɨmentohefoho. I osoꞌno sekwo nje hungkuno homo somo sɨmeho hiꞌntnnono montapeꞌnjo hwasoho. Yoꞌmayo syoho wopɨngo nje Mpohwoe yokumpohnꞌnyo soꞌnji iwoꞌnɨngkohe somo sekwo nuhwonɨngkuji Anɨtu uhwatɨmentiso lohweho lɨkutnnesohilo. ");
INSERT INTO apz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","I osoꞌno sekwo nje yahu mehomi hwasɨꞌmaho. Osoꞌno sekwo ngkimo sɨmeho hiꞌntnnono montapeꞌnjo hwasoho. ");
INSERT INTO apz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nje yahu mehomiso hofɨko nje mampaho nupaꞌnontɨfeso ngko hofɨkineꞌno huno niyahonɨngki hofɨko ngkimo tɨfi nnɨngkapɨwoꞌnɨngkohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nje mehomi homo somo ngko songo neꞌno humayoso uyɨmentohefoho. Osoꞌno hofɨko tɨkanomo mafitnnefoho. Oꞌo, aꞌamu fihwo nje aho somtaꞌni nje mehomi hisomo wae meenɨmofonefoho. ");
INSERT INTO apz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Hwapɨngoso mehomi hiso nje Mpohwo Anɨtu sohwo kako ngkimo ntapmmentisofoho. Mpohwo kakoe yokumpohnꞌnyoso yoꞌmayo somo hwofiloꞌnnyo hweho. Osoꞌno aꞌamu fihwo kako oso mehomi homo somo Mpohwoe aho somtaꞌni wae meeofonefoho. ");
INSERT INTO apz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ngko huhwoꞌni nje Mpohwoꞌnji afa hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ose ulahonɨngki aꞌamu Jutafe hwe engo sohwa hofɨko Jisasɨmo wofonjosyano lontɨfi sojo maꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Sojo nomahonɨngkofi Jisas ulɨmento, Nje Mpohwoe yokumpohnꞌnyo soꞌnji ngko syoho wopɨngo piꞌnɨngo iwoꞌnɨngkohe somo sekwo uhwonɨwoꞌnɨngkohofo soꞌno syoho ntisomneꞌno wofonjonɨsyantɨfeꞌno yohofo. ");
INSERT INTO apz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ose ulahonɨngkahonɨngki hofɨko ulɨmentohofi, Nakwo jɨje syoho wopɨngo soꞌne wofonjokisyantaneꞌno miyalokuyɨhwono. Oꞌo, kɨko Anɨtuneꞌno sitofo ulalokuno soꞌno nakwo wofonjokisyantanoho. Kɨko aꞌamu olo hwaho lopo ntaꞌnɨngo hwosoho. I osoꞌno kɨko ole nalohino, Ngko Anɨtu hwoꞌnyoho nalohino hwosoho. ");
INSERT INTO apz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ose ulahonɨngki Jisas ulɨmento, Sekwoe honɨngkano hungkuno somo anɨtu kako nomꞌne hwe engo sohwamneꞌno ole ulɨmento, Sekwo anɨtu hwasoho. ");
INSERT INTO apz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","I nakwo huno ole nayohoho. Anɨtuye hungkunoso neꞌnjofoho. Oseso Anɨtu kako oso aꞌamu kakoe hungkuno uyɨmentiso huhwo sohwamo sekwo anɨtu hwasoho ulɨmentisoso hungkuno nehopeho. ");
INSERT INTO apz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","I osoꞌno ngko Anɨtu nɨhwatɨmentiso sohwoꞌni ngko Anɨtuye hwomu hwoꞌnyoho selɨmentohe soꞌno sekwo Anɨtumo sitofo ulalokuno eso pehoꞌne ntantɨkwofo. ");
INSERT INTO apz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sekwo soku, ngko nje Mpohwoe syoho miyo nohonɨngkujɨꞌmanji sekwo ngkimo sɨmeho hiꞌntnnono montapeꞌnjo uyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","I osoꞌno ngko nje Mpohwo Anɨtuye syoho yalokweno. Oseso nje hungkuno selalokwe losomo sekwo ngkineꞌno sɨmeho hiꞌntnnono montapeꞌnjo ifijoꞌmanji yoꞌmayo syoho wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso ngko iꞌmeꞌno oso syoho homo somo nohonɨngkuji oso syoho imesomo sɨmeho hiꞌntnnono uyɨfitnnefoho. Ose ifijoꞌmanji sekwo huno wopɨngo ole wosyofɨsyantɨfeho. Ngkoꞌnji nje Mpohwoꞌnji siko afafoho. Ngko huhwoꞌnneꞌno Anɨtuyoho wosyonɨfɨsyantɨfeho. Mpohwo ngkimo nɨhumaho. Ngko Mpohumo humaleno. ");
INSERT INTO apz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ose ulahonɨngki hofɨko Jisasɨmo impe untofano lontɨfi ko imentohofoso Jisas kako hofɨkimo ulɨkoꞌmanto umentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisas kako asomo wento Mijo Joutan nongkihntaꞌni wakoꞌmentisofoho. Joun kako hohonta syoho yonto aꞌamumo mijo kiyomaꞌmojo sopo kiꞌmofamentisofoho. Kako nokiꞌmofawento osopo humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Osopo Jisas kako nohumentanɨngki hwe moyaꞌmi piꞌnɨngo engo hofɨko kakimo uꞌmantɨfi hnnɨmentohofi, Joun kako yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso miyoꞌnjo hweho. I osoꞌno yoꞌmayo hungkuno olo hwe lohuneꞌno nalɨmentisoso ne imoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ose hnnontɨfi hwe moyaꞌmi piꞌnɨngo engoso hofɨko oso hisoꞌno Jisasɨmo sɨmeho hiꞌntnnono umentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Hwe fihwo kakoe yofe Lasalos. Kako ango Mpetani sopo nohumanto mnokino engo tɨpemaꞌmentisofoho. Oso ango hopo sopo Maliyaꞌnji Motaꞌnji sikoꞌnopeeꞌi sikoe angoponoho. ");
INSERT INTO apz_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Oso aꞌmu Maliya hisi kako tɨfi noꞌmo nakwoe hwe engo Jisasɨye sɨfemo hwonemijo usisyonto kakoe mijiyo sawemo soꞌnji sosayo usɨpoꞌmentisofoho. Oso hwe Lasalos kako mnokinoꞌnjo sohwo kako Maliyafe konɨngkwaꞌwehweho. ");
INSERT INTO apz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Oseso Lasalos kako mnokino tɨpemahonɨngki kaisifaꞌu siko Jisasɨmneꞌno hungkuno ole lɨhwatɨmentisi, Hwe Engofo, jɨje nɨngkwahwo Lasalos sohwo mnokinoꞌnjo hweho. Ose lɨhwatɨmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Lɨhwojahonɨngki Jisas kako hungkuno homo somo nupaꞌnonto aꞌamu somo ulɨmento, Olo mnokino loso nɨhuꞌnahone poyo peꞌnyoꞌneꞌmaho. Oꞌo, Anɨtuye yokumpohnꞌnyoso utɨhwaꞌnyopo uhwonyoꞌnefoho. Anɨtuye Hwomu sohwoꞌni yofe engo mayoꞌnefoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas kako Motaꞌnji konampi Maliyaꞌnji Lasalosɨjontnneꞌno sɨmeho engo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jisas kako Lasalos mnokinoꞌnjo hweho ko upaꞌnonto kako oso ango humamentiso sopo nomꞌne sɨkuno hufaꞌu humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sɨkuno hufaꞌu memjaofahonɨngki Jisas kakoe inomokomoyo sohwonaꞌnɨmo nalɨmento, Nakwo hwaho Jutiya Lasalosɨye ango sopo asomo wosɨhwano. ");
INSERT INTO apz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ose nelahonɨngki kakoe inomokomoyo sohwonaꞌni ulɨmentɨhwoni, Nakwoe Lonetɨhwayo sohwosi, aꞌamu Jutiya soponjo hwe engo sohwa hofɨko kikimo sojo wokufonjantɨfi imalofo soponeꞌno kɨko asomo wosɨhwantaneꞌno lonalohino. ");
INSERT INTO apz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ose ulahonɨngkuhwoni Jisas kako pahnnɨmo hungkuno kakoe sɨkuno syoho iyoꞌne ole nalɨmento, Mofehiꞌnyo lonto pomponaho yonte sopo aꞌamu hofɨko hano emoyɨkujoso mopɨwahupitnnehofo. Hwapɨngoso hofɨko olo hwaho loponjo pomponaho somo yoꞌmayo yoꞌmayo uhwonalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","I osoꞌno aꞌamu hofɨko sɨkwoꞌmjohoꞌmo hano emoyontɨfi hofɨko pɨwasyɨwoꞌnɨngkohofofoho. Hwapɨngoso pomponaho anefoho. Oseso nje syohomneꞌno Anɨtu pomponaho ntopalokuso somo sɨmeso mopɨwahuꞌmnehono. ");
INSERT INTO apz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ose nalonto tɨfi ole nalɨmento, Sekwo upaꞌnɨmno. Nakwoe aꞌamu Lasalos sohwo saho nto fosyawentono. I osoꞌno ngko nuꞌmo kakimo ulɨkofamne hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ose nelahonɨngki kakoe inomokomoyo sohwonaꞌni ulɨmentɨhwoni, Hwe Engofo, kako saho nehopi fosyawesoꞌmanji kako wopɨngo umoꞌnɨmontonoho. Ose ulɨmentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas kako Lasalos poyo nto peꞌnɨmaho huno ose ko uyahonɨngki saho fosyaweho nalɨmentiso soꞌno inomokomoyo sohwonaꞌni nakwo nakwoe hunoso ole syafɨhuꞌmentɨhwoni, Lasalos sohwo kako saho nehopi fosyowentanɨngki nalohoho syafɨhuꞌmentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Osoꞌno Jisas kako yoloho ole nalɨmento, Lasalos sohwo poyo nto peꞌnɨmaho. ");
INSERT INTO apz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","I sekwo ngkimo sɨmeho hiꞌntnnono ntapɨfitnneꞌnji Lasalos kako poyo peꞌnɨmaso sopo ngko mohumayoso wopɨngofoho nnɨngkohoho. I osoꞌno olohonta kako poyo peꞌnɨmaso soponeꞌno wosɨhwano. ");
INSERT INTO apz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ose nelahonɨngki Toumas hufaꞌu mehomi imoꞌnɨmentiso sohwo kako nomꞌne inomokomoyo sohwonaꞌnɨmo nalɨmento, Nakwo hwaho Jutiya sopo aꞌamu Jisasɨmo sojoꞌnji wofonjosyano lontɨfi yalokwofo sopono noho wosɨhwano. Nakwo Jisasɨꞌnji poyo umoꞌnano. Ose nelahonɨngki nakwo Jisasɨꞌnji sɨmentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Oseso Jisas kako ango Mpetani sopo sɨꞌmofonto kako honɨngkanopo lohofahonɨngki aꞌamuso hofɨko ulɨmentohofi, Lasalosɨye pijafoso sokimomo neꞌno nowentanɨngki sɨkuno osofosofahuꞌno memjaoꞌmasofoho. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Oso ango Mpetani sopo ango Jelusalem mofoneponoho. Honɨngkanoso sawemopoꞌmaho, hufaꞌu sɨhune kiloumitaponoho. ");
INSERT INTO apz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Aꞌamu Juta piꞌnɨngoso ango Jelusalem mtaꞌangoso hofɨko Motaꞌnji Maliyaꞌnjiyepono konɨngkwaꞌwehwo peꞌnɨmentiso soꞌno hofɨko sikoe sɨmeho wopɨngo umoꞌnyoꞌne humotahoꞌne womentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mota kako hungkuno ole upaꞌnɨmento, Jisas ntopohoho. Ose upaꞌnonto komoꞌno nowento Jisasɨmo honɨngkanopo uswoꞌnɨngkahonɨngki Maliya kako angomo humohumantisofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mota Jisasɨmo uswoꞌnonto Jisasɨmo ulɨmento, Hwe Engofo, kɨko olopo humantontentesi nje nɨngkwahwo poyo mapeꞌnɨngkuhwonesohilo. ");
INSERT INTO apz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","I osoꞌno ngko huno niyohoho. Kɨko yoꞌmayo soꞌno Anɨtumo jomo ulisoso kako yoꞌmayo kɨko ihnneso wokijapmmontonoho huno niyohoho. ");
INSERT INTO apz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ose ulahonɨngki Jisas ulɨmento, Osoꞌno jɨje nɨngkwahwo apaꞌno songo wolɨkaꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ose ulahonɨngki Mota ulɨmento, Ngko huno ole niyohoho, Sɨkuno aeꞌuyo somo aꞌamu lɨkapijo sohonta Lasalos huhwo nolɨkafone hweho. ");
INSERT INTO apz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ose ulahonɨngki Jisas ulɨmento, Ngko aꞌamumo apaꞌno songo ulɨkafo soꞌnji songo neꞌno humayo soꞌnji ngko hwapɨngo hwoꞌnyoho. Aꞌamu ngkimo sɨmeho hiꞌntnnono ntapinyoso kako poyo ko peꞌnoso sohwo kako songo neꞌno wohumamontonoho. ");
INSERT INTO apz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aꞌamu hofɨko olo hwaho lopo songo humalofoso hofɨko ngkimo sɨmeho hiꞌntnnono ntapɨfijoꞌmanji hofɨko poyo mapeꞌnɨfitnnehofo. Olo hungkuno kilalokwe losomo sɨmeho hiꞌntnnono luyalokuno. ");
INSERT INTO apz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ose ulahonɨngki Mota kako Jisasɨmo ulɨmento, Ou Hwe Engofo, kɨko Kɨlais sohwosi, Anɨtu kako olo hwaho loponeꞌno hwe fihwo sefoꞌmayoꞌne uhwosopoꞌmonnoho nalɨmentiso sohwohnneꞌno ngko kikineꞌno sɨmeho hiꞌntnnono kijahopohono. Kɨko Anɨtuye Hwomu Kɨlais hwosoho. ");
INSERT INTO apz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mota ose ulonto kakoe angopo asomo nowento konampi Maliyamo joho ulahonɨngki Maliya kakimo uꞌmahonɨngki Mota hofiyoka ulɨmento, Nekwoe Letɨhwayo sohwo kako noponto kikineꞌno joho kilalofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maliya ose upaꞌnonto komoꞌno mokolɨkapo lohofonto Jisasɨyepono umentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas kako ango ne sopo mꞌmofapmmentisofoho. Oꞌo, Mota uswoꞌnɨmentiso sopo humohumantisofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Aꞌamu Jutaso hofɨko Maliyaꞌnji angoꞌmo nohumantɨfi Maliyamo sɨmeho tango uyosoꞌno kakoꞌnji humohumantohofoso hofɨko kakimo uhwonɨngkohofoso kako komoꞌno lɨkafonto mempono nto poswahonɨngki uhwonontɨfi hofɨko kakimo uhwonontɨfi hofɨko huno ole syafɨhuꞌmentohofi, Kako konɨngkwaꞌwehwoe pijafo hoꞌnahumalofo sopono humotaho walɨmonjitɨkeno ose syafɨhuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maliya kako Jisas humentahonjo soꞌmneꞌno wento Jisasɨmo uhwononto kako Jisasɨye sɨfɨkiꞌnyoꞌmo hwomtame ehumanto ulɨmento, Hwe Engofo, kɨko olopo humantontentesi nje nɨngkwahwo sohwo poyo mapeꞌnɨngkuhwonesohilo. ");
INSERT INTO apz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas kako Maliya humotaho lontanɨngki uhwononto uhwonɨngkisoso aꞌamu Juta kakoꞌnji humahwofoso humotaho nto mjolɨmɨwahonɨngkofi uhwononto kako kakoe sɨmeho tango uyahonɨngki ");
INSERT INTO apz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ulɨmento, Sekwo ntɨꞌmo hoꞌnahumalofo. Ose ulohonɨngkahonɨngki ulɨmentohofi, Hwe Engofo, kɨko nopohoji uhwonae. ");
INSERT INTO apz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ose ulahonɨngkofi Jisas kako humotaho lɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Aꞌamu Juta fehohnjoso Jisas kako huhwo humotaho lontanɨngki uhwonontɨfi hnnɨmentohofi, Ihwoni, kako Lasalos sohumo sɨmeho mɨkunɨmposo uyɨmojo hweho. ");
INSERT INTO apz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","I aꞌamu nomꞌnihwa ole hnnɨmentohofi, Olo hwe lohwo kako aꞌamu tɨmpiꞌnyo somo wopɨngo umokumentiso hopaso kako Lasalosɨmo ufoꞌmantontentesi Lasalos kako poyo mapeꞌnɨngkuhwonesohilo. Sitofo hungkuno ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Oseso Jisas kako sɨmeho tango engo apaꞌno uyahonɨngki Lasalosɨye pijafo hoꞌnahumentohofo sopo umentisofoho. Oso hopo sopo Lasalosɨye pijafo hoꞌnahumentohofo sokimo hokuꞌyo sopo sojo ewafo engoso nomantɨfi pɨjwahuꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisas oso hopo sopo nohumanto ulɨmento, Olo sojo pɨjwohumalofo loso wae feeopmno. Ose ulahonɨngki hwe poyo peꞌnɨmentiso sohwoe konanisi Mota ulɨmento, Hwe Engofo, kakoe pijafo hoꞌnahumalohwoneso oso sɨkuno osofosofahuꞌno nto memjaoꞌmasoso kakoe pijafoso pisakinoꞌnjofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ose ulahonɨngki Jisas ulɨmento, Olohonta nto kilohefoho. Kɨko ngkineꞌno sɨmeho hiꞌntnnono ntapisoꞌmanji kɨko Anɨtuye yokumpohnꞌnyoso uhwonɨmonnoho. Ose nto kilohefoho. ");
INSERT INTO apz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Motamo ose ulahonɨngki hofɨko sojo ewafo engo mehwosompeehumentohofofoho. Nomehwosompesyahonɨngkofi Jisas kako ahwomomo uhwononto aꞌamu kakoe mampaho upaꞌnyoꞌne ole ulɨmento, Nje Mpohwo sohwosi kɨko nje hungkunomo haloho nɨpewoꞌnɨngkino sohwohnneꞌno ngko isamoyoka kilalokweno. ");
INSERT INTO apz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ngko huno niyohoho. Kɨko engolopohamo nje hungkuno jomo kilɨwoꞌnɨngkohe somo nupaꞌnɨwoꞌnɨngkino hwosoho. I osoꞌno olo aꞌamu oloponjo lohokwofo lohwa kɨko ngkimo olo hwaho loponeꞌno nɨhwatɨmentohino soꞌno sɨmeho hiꞌntnnono uyɨfitnneꞌenji kilalokweno. ");
INSERT INTO apz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ose ulɨkwato lohofonto joho mohmꞌno ulɨmento, Lasalos kɨko noho fusyape. ");
INSERT INTO apz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ose ulahonɨngki aꞌamu poyo peꞌnyo sohwo nolɨkafonto swapmmentisofoho. Kakoe sɨfe aho hwapɨfe nano popojontɨfi kakoe sɨmoꞌmango hi hwapɨfe ifohumpeehumentohofo sohwo hiꞌnji swopahonɨngki Jisas ulɨmento, Yoꞌmayoso misɨhutoꞌmeefɨkujoꞌno wopaweno. Ose ulahonɨngki hofɨko kakoe hungkunomo inɨngkamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Aꞌamu Juta hwe moyaꞌmi piꞌnɨngo fehohnjoso Maliyaꞌnji humamentohofoso Jisas kako oso hiso imentiso somo uhwonontɨfi hofɨko kakimo sɨmeho hiꞌntnnono uyɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","I osoꞌno aꞌamu fehohnjo sohwa hofɨko aꞌamu Falisi sohwafe angopono asomo nowentɨfi yoꞌmayo Jisas imentiso soꞌno aꞌamu Falisi sohwamo tokoyoꞌofo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ose yahonɨngkofi aꞌamu Falisi sohwanji aꞌamu yofe engoꞌnjo tajo ango syohoꞌnjo sohwanji hofɨko aꞌamu kaunɨsol syohoꞌnjo sohwamo uswoꞌnontɨfi hnnɨmentohofi, Nakwo pipi yanehwono. Olo hwe lohwo yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso yalofoho. Pipi pɨjwaofanehwono. ");
INSERT INTO apz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nakwo kakoe yahino losomo mopɨjwaofeꞌmanji aꞌamu hopiꞌnonohinoso hofɨko kakimo sɨmeho hiꞌntnnono uyɨkuji kakimo tɨfi inɨngkafitnnoho. Ose ikujoꞌnoꞌmanji aꞌamu Loum nakwoe hwaho nemokosyohumawoꞌnɨngkohofo sohwa nonahonɨngkuji huno ole wosyofɨsyantɨfeho. Aꞌamu Juta hofɨko nakwoe hungkunomo enjwaꞌmo mohumunyofoho. Ose syafɨsyɨkuji hofɨko nakwoe tajo ango engo somo wonyo umokantɨfeho. Nakwo aꞌamu Juta hopiꞌnonohino hnꞌnɨmo wonyo wonemokantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ose hnnontɨfi hwe fihwo hofɨkoꞌnji humamentiso sohwo kakoe yofeso Kaiyofasɨyoho. Oso soswo somo aꞌamu tajo ango syohoꞌnjo sohwamo umokosyohumayoꞌne hweho. Kaiyofas huhwo sohwo kako nolɨkafonto ulɨmento, Sekwo huno mosyafɨsiyoꞌnjo liyalokwofo. ");
INSERT INTO apz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sekwo olo aꞌamu losoku hunoꞌmaso kuyoho. Nakwo aꞌamu Juta hopiꞌnonohino hnꞌnɨmo aꞌamu Loum sohwa wonyo pehoꞌno wonemokantɨfito. Oꞌo, yahino itoꞌnohinoso olenoho. Olo hwe angaꞌnohino lohwo kako hwe moyaꞌmi hopiꞌnonohino somneꞌno ufoꞌmayoꞌne poyo wapeꞌnono. ");
INSERT INTO apz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Oso hungkuno ulɨmentisoso kakoe huno mtaꞌangoꞌmaho. Oꞌo, Kaiyofas kako oso soswo somo aꞌamu tajo ango syoho soꞌno yofe engo maꞌmentiso soꞌno Anɨtu oso huno hiso uyɨmentisofoho. Osoꞌno kako Jisas aꞌamu Juta somneꞌno ufoꞌmayoꞌne poyo umoꞌnɨmontonoho eso ulɨmentisofoho. Ose ko ulɨmentisoso oso hungkuno Kaiyofas ulɨmentisoso aꞌamu angoꞌmeemjo somneꞌno ufoꞌmayoꞌne Jisas poyo imoꞌnone soꞌno huno muyo hweho. ");
INSERT INTO apz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Oꞌo, Anɨtu kakoe mehomi angoꞌmeemjo hnꞌnwi temtitofo angaꞌnohino hopa imoꞌnɨfitnneꞌno peꞌnoneꞌento Anɨtu oso hunoso Kaiyofasɨmo uyahonɨngki ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Oso aꞌamu huhwo sohwa Kaiyofas ulɨmentiso sɨkuno somtaꞌni oso hungkuno Jisasɨmo fonjasiyoꞌne hungkuno lomaꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Oseso Jisas kako oso hwaho Jutiya sopo aꞌamu Jutafe tɨmo sopo hano memmentisofoho. Oꞌo, kako oso hwaho hopo sopo ulɨkoꞌmanto kako nomꞌne ango Efɨlaim soponeꞌno kakoe inomokomoyo sohwonaꞌnnonji umentɨhwonefoho. Oso ango Efɨlaim aꞌamu mohumunyo mofone sopo molinyoponoho. Oso ango hopo sopo kakoe inomokomoyo sohwonaꞌnnonji humamentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Oso hohosohonta aꞌamu Jutafe Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo Sɨkuno Engof mofonepo umoꞌnɨmonto imentisofoho. Osoꞌno oso Sɨkuno Engo mmoꞌnyo sohonta aꞌamu angoꞌmeemjoso ango Jelusalemneꞌno wopayo engo nyoꞌne hofɨko hofɨkoe honɨngkano hungkuno itoꞌno inɨngkayo soꞌno hofɨkoe he yoꞌmayo mijo yojujosyɨhwasi ntoꞌno wehumano lontɨfi ole syafɨhuꞌmentohofi, Nakwo ose ihwasɨꞌmanji nakwoe honɨngkano kihoꞌmaso umoꞌnantanoho. Ose syafɨsyontɨfi sɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Hofɨko nosɨꞌmofontɨfi Jisasɨmneꞌno tɨpeentɨfi tajo ango engo somo uhuꞌmokontɨfi hofɨko ole hnnɨmentohofi, Olo Sɨkuno Engo lomneꞌno Jisas kako wosapmmontolɨkeno. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hwapɨngoso aꞌamu Falisi sohwanji hwe engo sohwanji hofɨko aꞌamu hisomo hungkuno yokumpohnꞌnyo ole lontɨfi, Sekwo Jisas humentahonɨngkuhwosi uhwonɨngkuji nowenetɨmapɨkujoꞌno nakwo huhwo sohumo impe untofano. Ose ulɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Oso Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo sɨkuno engo mmoꞌnyo aho fehohnjo hopiꞌnono nomꞌni mtaꞌni angaꞌno nowentanɨngki Jisas kako ango Mpetani sopo umentisofoho. Oso ango hopo sopo Lasalos kako poyo peꞌnɨngkahonɨngki Jisas kako ulɨkaꞌmentiso sopono umentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Oso ango Mpetani hopo sopo iꞌmofɨwahonɨngki Jisasɨmneꞌno wosopayo engo iloho yontɨfi Mota kako wosopayo ikuꞌyopo polofosyalokumpento huꞌmmentisofoho. Jisasɨꞌnji aꞌamu nomꞌne soꞌnji Lasalos kako huhwoꞌnji hofɨko nohumantɨfi wopayo nɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Oso hohosohonta Maliya kako hwone mijo hamniyoho engo mpe imentisoso nomanto Jisasɨye sɨfemo sisyonto kakoe mijiyo sawemo soꞌnji sɨfemo sosayo usɨpoꞌmentisofoho. Oso hwone mijo sohwoe akino wopɨngoso ango homo somo ehuhnnalohoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jisasɨye inomokomoyo fihwo kakoe yofe Jutas Isɨkaliyout kako Jisasɨmo fonjasiyoꞌne tokoyoꞌofo iyoꞌne sohwo oso homo somo uhwononto ulɨmento, ");
INSERT INTO apz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Oso mijo wonyoangkafoso kako pehoꞌno sisyohoho. Olo mijo hiloso nomꞌne aꞌamuso mpe yontɨfijontentesi hamniyoho mɨkunɨmposo aꞌamu hamniyoho syohoꞌnjo sohwo soswo angaꞌnohino somjo hamniyoho hopiꞌnono nejapɨkuji nakwo aꞌamu umofonyo iwoꞌnɨngkohofo somo uyɨhwanesohilo. ");
INSERT INTO apz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ose ulɨmentisoso kako aꞌamu umofonyo iwoꞌnɨngkohofo somneꞌno huno nehopi syafɨsyonto ulɨmentisoꞌmaho. Oꞌo, kako hamniyoho hufo imojo soꞌno ulɨmentisofoho. Jisasɨꞌnji kakoe inomokomoyo sohwonaꞌnnonji nakwo hano emoyontanɨngkukwone Jutas Isɨkaliyout sohwo kako nakwoe hamniyoho ipofo mokosyohumante somtaꞌni hufo imojo hweho. ");
INSERT INTO apz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Oseso Jisas ulɨmento, Olo aꞌmusi kako olo ntohofiso losoꞌno kakoe syohofoho. Sekwo tɨmoꞌnohino uhwontohumamno. Kako hwone mijo hiloso nomokosyohumentanɨngkuhwosi. Ngko poyo imoꞌnɨme sohonta nje pijafomo ntoꞌno enɨsyohumaniyoho. ");
INSERT INTO apz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","I aꞌamu umofonyo iwoꞌnɨngkohofoso sekwoꞌnji engolopohamo neꞌno humawoꞌnɨngkohofofoho. I osoꞌno ngko sekwoꞌnji humaleso sɨkuno moiꞌwo weꞌenepi umoꞌnɨmontonoho. Osoꞌno aꞌamu ngkimo wopɨngo ntohofoꞌne sɨkuno piꞌnɨngo mauyoho. ");
INSERT INTO apz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Aꞌamu Juta hwe moyaꞌmi piꞌnɨngoso Jisas ango Mpetani sopo humaho upaꞌnontɨfi oso poneꞌno womentohofofoho. Hofɨko Jisasɨmnenohini uhwonantɨfi womentohofoꞌmaho. Oꞌo, Jisas kako Lasalos poyo peꞌnɨmentiso sohumo ulɨkaꞌmentiso sohwo huhwoꞌnjimo uhwonano lontɨfi womentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Oso aꞌamu tajo ango syohoꞌnjo sohwa hofɨko oso hiso uhwonontɨfi hofɨko Jisasɨmneꞌnohini mtitoꞌmentohofoꞌmaho. Oꞌo, Lasalos huhwoꞌnjimo fonjosiyoꞌne mtitoꞌmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Hwapɨngoso aꞌamu Juta hwe moyaꞌmi piꞌnɨngoso hofɨko Lasalosɨmneꞌno huno piꞌnɨngo syafɨsyontɨfi aꞌamu tajo ango syohoꞌnjo sohwamo ulɨkoꞌmantɨfi Jisasɨmo sɨmeho hiꞌntnnono uyɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Oso ango Jelusalem hwe moyaꞌmi piꞌnɨngo engoso oso Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo Sɨkuno Engo somo uhwonano lontɨfi sɨmentohofofoho. Oso hopo sopo nohumantɨfi upaꞌnɨmentohofoso Jisas kako moꞌnɨngkanta Jelusalemneꞌno wapmmontonoho upaꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Oseso hofɨko yoꞌmayo wokoso wopɨngo wopɨngoso nomotawentɨfi Jisasɨmneꞌno honɨngkanopo hontohumamentohofofoho. Nohontohumantɨfi Jisasɨmneꞌno joho ole lɨmentohofi, Anɨtumo isamoyoka ulano. Kako wopɨngoꞌnohino hweho. Olo hwe lohumo nakwoe Hwe Engo Anɨtu sohwo nakwoe hwahoponeꞌno uhwatɨmentiso hweho. Kakoe yofe wohoꞌnomano. Nakwo aꞌamu Isɨlael hnꞌnwiye hwe yofe engoꞌnjo nakumo nemokosyohumayoꞌne hweho. Ose lɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas kako yahu osyuyo toungki angaꞌno notɨpemanto yahu sohwoe hohujopo kehumanto sɨmentisofoho. Oso hisoꞌno ifalifaliyo ole woꞌnnyofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Sekwo aꞌamu ango Saiyon sopo humalofo soku sekwo iyoho senɨngkuhwoloho. Uhwonɨmno. Sekwoe Hwe Engo sohwo kako ntosapohoho. Kako yahu toungkipo nokehumanto sopalofoho. Oso ifalifaliyo hohonta mtɨꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Oso hohosohonta Jisasɨye inomokomoyo sohwonaꞌni nakwo oso hungkuno ifalifaliyo mtɨꞌmokumentohofo soꞌno huno monayo hwonaꞌnyoho. I osoꞌno tɨfi noꞌmo Jisas kako ahwomomo sɨmentiso sohonta nakwo oso ifalifaliyo hisoꞌno huno syafɨhuꞌmentɨhwoni yoꞌmayo wopɨngoso Jisasɨmneꞌno oso sɨkuno homo somo aꞌamu ulohoꞌmentohofo soꞌno huno ikwesyafɨhuꞌmentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Hohonta Lasalos poyo peꞌnonto kakoe pijafoso piꞌnɨmomo woꞌmentiso sohonta aꞌamu Juta piꞌnɨngo engoso Jisasɨꞌnji humamentohofofoho. Jisas kako Lasalosɨmo joho ulonto nulɨkofahonjoso hofɨko uhwonɨmentohofofoho. Oso aꞌamu huhwo sohwa hofɨko nomꞌne aꞌamu piꞌnɨngoꞌnjo sopo Jisas kako yoꞌmayo imentiso soꞌno lutɨhwamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Oseso hwe moyaꞌmi piꞌnɨngo engoso yoꞌmayo wonyoangkafo Jisas imentiso soꞌno upaꞌnontɨfi oso aꞌamu hiso Jisasɨmo honɨngkanopo uswoꞌnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Uswoꞌnɨngkahonɨngkofi aꞌamu Falisi sohwa hofɨko nuhwonontɨfi sɨmeho tango uyahonɨngki ole hnnɨmentohofi, Ihwoni, aꞌamuso hofɨko nakumneꞌno huno mosyonefɨsyalokuyohofo. Oꞌo, aꞌamu angoꞌmeemjo hopiꞌnonohinoso hofɨko nakumo nosɨkwojonaofontɨfi Jisasɨmnohini inomokohoꞌnawotofo. Ose hnnɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Aꞌamu piꞌnɨngo engoso sɨkuno iyoho humayo engoso uhwonano lontɨfi ango Jelusalemneꞌno Anɨtuye yofe hoꞌnomayoꞌne sɨmentohofofoho. Aꞌamu Jutaꞌnohiniꞌmaho. Oꞌo, aꞌamu Ngkɨlik fehohnjo hiꞌnji sɨmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Oso aꞌamu Ngkɨlik huhwo sohwa hofɨko Filipɨmo uꞌmantɨfi ulɨmentohofi, Hwe engofo, nakwo Jisasɨmo uhwonano lontani sahopɨhwone hwonaꞌnyoho. Ose ulɨmentohofofoho. Filip huhwo sohwo kako hwaho Ngkalili ango Mpetɨsaita mtaꞌango hweho. ");
INSERT INTO apz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip kako hofɨkoe hungkuno hiso upaꞌnonto nowento Entɨlumo ulahonɨngki siko Jisasɨmo uꞌmanji oso hungkuno hiso ulɨmentisiyefoho. ");
INSERT INTO apz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisas kako sikimo ulɨmento, Ngko Aꞌamufe Hwomu sohwoꞌni poyo imoꞌnɨꞌmo apaꞌno songo lɨkahmꞌmo nje yofe engo mayoꞌne sɨkunoso mofonepo nto iꞌmofapohoho. ");
INSERT INTO apz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ose ulɨkwato lohofonto kako poyo imoꞌnyoꞌne pahnnɨmo hungkuno ole ulɨmento, Hwe fihwo kako hamoyo mofososo hami hiso siki wehwosi piso nɨhuꞌnahone uyɨmontonoho. I osoꞌno hwe fihwo kako hami mofososo hami hiso piso ihwosoꞌno nomꞌne tɨmo sahopɨhwosi ne piꞌnɨngo umoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Oso paꞌnyoso aꞌamu fihwo kako kakineꞌnohini huno syafɨhuꞌnonto kakoe yofeꞌnohini hoꞌnomaꞌnɨwoꞌnɨngkiso sohwo kakoe humayoso aho yokumpohnꞌnyo kemokosyohumanto poyo peꞌnɨngkuhwosi tohino engo nomane hweho. I osoꞌno hwe nomꞌnihwo kako kakineꞌno huno mosyafɨhuꞌnyoꞌnjo yonto nomꞌne aꞌamu somneꞌno ufoꞌmawoꞌnyoꞌneꞌnohini syafɨsyɨwoꞌnɨngkiso sohwo kako poyo peꞌnɨngkuhwosi songo neꞌno wonyoangkafo humayoꞌneso notɨpemane hweho. ");
INSERT INTO apz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Oso aꞌamu Ngkɨlik huhwo sohwa hofɨko nje inomokomoyo umoꞌnano lɨfijoꞌmanji siko nuhusɨsi hofɨkimo ole ulinyo. Hofɨko ngkimo wonnɨngkopantɨfiꞌmanji oyonɨmno lalofoho ulinyo. Aꞌamu nje syoho ntohofiyoso hofɨko ngkimo tɨfi nnɨngkapɨwoꞌnɨngkohofofoho. Oseso ngko nje syoho ntohofiyoso ngko humame sopo hofɨko wohumapɨfe. Nje syoho ntohofiyo ne somo Mpohwo Anɨtu sohwo kako hofɨkimo uhwonɨngkuhwosi kako hofɨkoe yofeso wohoꞌnomaꞌmontonoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jisas kako nohumanto ulɨmento, Nje sɨmeho tango mɨkunɨmposo niyohoho. Ngko Mpohumo jomo pehofo ulɨmnehono. Nje Mpohwo sohwosi olo tango engo ngkimo wonɨꞌmaꞌmonto iso losomo kɨko wae yanɨmotnnehino. Ose ulɨmnehono. Oꞌo, olo tango hiloso ngko mayoꞌne pmmentohono. ");
INSERT INTO apz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Oso hisoꞌno ngko nje Mpohumo hungkuno ole ulɨmo, Mpohwo sohwosi olo aꞌamu hopiꞌnonohino loso hofɨko jɨje yofe engo wojo soꞌno huno uyoneꞌno yoꞌmayo wonyoso hofɨko ngkimo ntapɨfijoꞌmanji noho wontapɨfe. Jisas ose ulahonɨngki mampaho ahwomo mtaꞌango ole hoꞌnɨmento, Ngko oso hwaho soponeꞌno kuhwotɨmentohe sohonta aꞌamuso nje yokumpohnꞌnyo engo somo uhwonontɨfi nje yofe hoꞌnonɨmaꞌmentohofofoho. I kɨko poyo imoꞌnɨngkohojoꞌno ngko apaꞌno songo kilɨkaꞌme sohonta hofɨko nje yokumpohnꞌnyomo apaꞌno uhwonɨngkuji nje yofe apaꞌno nohoꞌnonɨmapitnnefoho. ");
INSERT INTO apz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ose hoꞌnɨngkahonɨngki hwe moyaꞌmi kakoꞌnjo mofonepo humohumantohofoso oso mampaho hiso upaꞌnontɨfi aꞌamu fehohnjoso ole hnnɨmentohofi, Ahwomo yoka hoꞌnɨngkohoho. Aꞌamu fehohnjoso ole hnnɨmentohofi, Aꞌamu ahwomomjo sohwo kakimo hungkuno ulohoho. ");
INSERT INTO apz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ose hnnɨngkahonɨngkofi Jisas hofɨkimo ulɨmento, Olo mampaho hoꞌnɨngkiso loso ngko upaꞌnyoꞌne hoꞌnɨngkisoꞌmaho. Oꞌo, sekwo upaꞌnyoꞌne hoꞌnɨngkisofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Osoꞌno olohonta Anɨtu kako yoꞌmayo yahino wonyo aꞌamu hwahoponjo yɨwoꞌnɨngkohofo soꞌno yano ulofihwosoꞌno hofɨko hofɨkoe wonyo somjo tohino mayoꞌnefoho. Olohonta Anɨtu kako hwe wonyo Seten olo hwaho mokosyohumaso sohwoe yokumpohnꞌnyoso wae weeoꞌmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ngko olo hwaho lopo nohumentanɨꞌmo aꞌamu hofɨko ngkimo iyo hwojiyahofɨkuꞌnnyo yokintaho sopo monɨhumatɨpijo sohonta ngko aꞌamumo wohuꞌmemaꞌmonnoho. ");
INSERT INTO apz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Oso hungkuno ulɨmentisoso aꞌamu somo ngko poyo imoꞌnɨmneꞌno honɨngkano umofɨtɨhwamo lonto kako oso hungkunoso ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Aꞌamu huhwo sohwa upaꞌnontɨfi Jisasɨmo ulɨmentohofi, Kɨko poyo umoꞌnɨmonnoho lalohino. Nakumo Anɨtuye hungkuno ole nalɨmento, Oso hwe Anɨtu aꞌamu ufoꞌmayoꞌne uhwosopoꞌmentiso sohwo kako songo neꞌno nohumantɨhwone hweho. I osoꞌno kɨko Aꞌamufe Hwomu sohwosɨꞌmanji iyo hwojiyahofɨkuꞌnnyo sopo womonɨhumojantɨfeho eso pehoꞌno lohino. Oso Aꞌamufe Hwomuso tɨhwolo. ");
INSERT INTO apz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ose ulahonɨngkofi Jisas kako pomponaho paꞌnyohwo kakineꞌno pahnnɨmo hungkuno ole ulɨmento, Sekwo olopo nohumentanɨngkuji pomponaho weꞌenehwo sekwoꞌnjo lopo wolasehumontonoho. Nolasesyɨhwosoꞌno sɨkuno wammontonoho. Oseso pomponaho lasesyohwosoꞌno pomponahopo fosyohumamno. Sɨkuno semenoho. Aꞌamu sɨkwoꞌmjohoꞌmjo hano wentoso sohwo kakoe humayoso ntontelo. Awonoho. Huno muyo hweho. ");
INSERT INTO apz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","I ngko pomponaho sohwoꞌni sekwoꞌnjopo nohumentanɨꞌmo sekwo sɨmeho hiꞌntnnono ntapmno. Sekwo nje hungkunomo tɨfi nnɨngkapɨfijoꞌmanji ngko sekwoe pomponaho sohwoꞌniye mehomi umoꞌnantɨfeho. Ose ulɨkwato lohofonto Jisas kako hofɨkimo ulɨkoꞌmanto hiyaso humamentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jisas kako yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso ko yahonɨngki aꞌamu Juta piꞌnɨngoso sɨmeho hiꞌntnnono muyɨmmentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Oseso oso hungkuno hohonta Aisaiya sohumo Anɨtu uyahonɨngki lɨmojo sohwo mtɨꞌmokumentisoso ne imoꞌnɨmentisofoho. Hungkuno hiso olenoho. Hwe Engofo, nakwoe hungkuno somo sɨmeho hiꞌntnnono tɨhwo wonejapmmontolo. Yoꞌmayo wonyoangkafo aꞌamu miyɨwoꞌnɨngkiyohofoso Hwe Engo ihwosoꞌno neꞌnjofoho eso tɨhwo wonalɨmontolo. Aisaiya hohonta ose mtɨꞌmokumentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Oseso aꞌamuso hofɨko Jisasɨmo sɨmeho hiꞌntnnono uyoso hopoꞌmaho. Olo hiloso hwapɨngo soꞌno Aisaiya kako hungkuno nomꞌne mtɨꞌmokumentisoso olenoho. ");
INSERT INTO apz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Anɨtu kako aꞌamuso nohonɨfitnnoho syafɨsyonto hofɨkoe tɨmo upijiyoꞌmentisofoho. Anɨtu ngkineꞌno huno ntoꞌno ikwesyafɨhupitnnoho syafɨsyonto hofɨkoe hunoso hwayohosile umasimentisofoho. Anɨtu ose ulohoꞌmentiso soꞌno hofɨko hofɨkoe honɨngkano wonyo somtaꞌni ikinjaofɨkuji ngkiyepono pontɨfijontentesi ngko hofɨkimo wopɨngo umokuꞌmnesohilo. ");
INSERT INTO apz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiya hohonta kako wojo hopa uhwonɨmentisoso Kɨlaisiye yokumpohnꞌnyo soꞌnji kakoe yofe engo soꞌnji uhwononto kako oso hungkunoso Kɨlaisɨmneꞌno lɨmentono. ");
INSERT INTO apz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Aꞌamu Jutafe hwe engo piꞌnɨngo sohwa hofɨko Jisasɨmneꞌno sɨmeho hiꞌntnnono ko uyahonɨngkofi hofɨko aꞌamu Falisi sohwamneꞌno iyoho unɨngkahonɨngki hofɨko Jisasɨmneꞌno hungkuno yolohoso molɨjwaofeꞌnjo imentohofofoho. Hwapɨngoso ole syafɨhuꞌmentohofi, Aꞌamu Falisi sohwa hofɨko nakumo Anɨtuye tajo ango somtaꞌni wae enamopitnnoho lontɨfi molɨjwaofeꞌnjo imentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Anɨtu hofɨkineꞌno yoꞌmayo soꞌno huno syafɨsyonte soꞌno hofɨko huno mosyafɨhuꞌmmentohofofoho. Oꞌo, aꞌamu hwahoponjoso hofɨkineꞌno yoꞌmayo soꞌno huno syafɨsyontɨfe so osomnohini syafɨsyontɨfi inɨngkamentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas kako hungkuno yokumpohnꞌnyo ole ulɨmento, Aꞌamu fihwo sɨmeho hiꞌntnnono ntopantokunjo sohwo kako ngkineꞌnohino montopantofiyoho. Oꞌo, kako nje Mpohwo olo hwaho loponeꞌno lonɨhwatɨmentiso osohwo huhwoꞌntnneꞌno ntopantofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aꞌamu ngkimo tɨmo nohonantokunjo sohwo kako ngkimnohino monehonantofiyoho. Oꞌo, kako nje Mpohwo ngkimo nɨhwatɨmentiso oso hwo huhwoꞌnjimo ehonalofoho. ");
INSERT INTO apz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ngko olo hwaho loponjo pomponaho sohwoꞌni aꞌamu ngkimo sɨmeho hiꞌntnnono ntapɨfijoꞌmanji hofɨko sɨkwoꞌmjohoꞌmo mohumafitnne soꞌno pmmentohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Aꞌamu fihwo kako nje hungkunomo haloho ko upaꞌnɨngkuhwosi hungkuno homo somo tɨfi minɨngkayoꞌnjo sohumo ngko kakoe yahino somneꞌno tohino muyɨmnehono. Oꞌo, ngko aꞌamufe yahino somneꞌno tohino yano uyoꞌne pmmentohe hwonɨꞌmaho. Ngko aꞌamufe wonyomjo tohino mtaꞌni isɨhutofomayoꞌno pmmentohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","I aꞌamu ngkimo hwotoho nifekuji nje hungkunomo tɨfi minɨngkayoꞌnjoso hofɨko hofɨkimo hofɨkoe yahino wonyo somneꞌno tohino yano ulofiyo sohwo hiꞌnjofoho. Oso sɨkuno aeꞌuyo somo yoꞌmayo hungkuno nto lɨjwasemoꞌmentohe hiso hofɨkoe yahino wonyo somneꞌno tohino yano ulofiyonefoho. ");
INSERT INTO apz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Hwapɨngoso yoꞌmayo hungkuno selɨwoꞌnɨngkoheso nje huno mtaꞌangoꞌmaho. Oꞌo, nje Mpohwo kako nɨhwatɨmentiso sohwo kako yoꞌmayo hungkuno hopiꞌnonohinoso lɨjwasemofoꞌne ntahonɨngki selalokweno. ");
INSERT INTO apz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ngko huno ole niyohi, Aꞌamu nje Mpohwoe hungkunomo tɨfi inɨngkaweso sohwo kako songo neꞌno humantɨhwone hweho. Oseso yoꞌmayo hungkuno hopiꞌnonohinoso Mpohwo ntɨwoꞌnɨngkisoso ngko sekumo ntoꞌnohini selalokweno. ");
INSERT INTO apz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Oso Anɨtu Aꞌamu Isɨlael somo Uyakoloꞌmentiso somneꞌne Syafɨsiyo sɨkuno engo iyoho humayoꞌne noꞌno moꞌnɨngka imoꞌnone sohonta Jisas kako huno ole uyɨmento, Moꞌnɨngka ngko olo hwaho lopo ulɨkoꞌmahmꞌmo nje Mpohwoe angopono wasɨmne hwoꞌnyoho. Ose huno umentisofoho. Olo hwaho loponjo hwe moyaꞌmi kakineꞌno hitoho ulofɨwoꞌnɨngkohofo somo Jisas kako hitoho mɨkunɨmposo uloꞌmentisofoho. Kako kakoe aꞌamu ne somneꞌno hitoho neꞌno ulofontanɨngki kakoe poyo imoꞌnyo sɨkunoso iꞌmofapmmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisasɨꞌnji kakoe inomokomoyo sohwonaꞌnnonji nohumentani sɨkunoꞌnji wopayo nontanɨngkuhwoni Seten kako Jutas Isɨkaliyout Saimounɨye hwomu sohumo olo hunolo nto uyɨmento, Kɨko Jisasɨmneꞌno tokoyoꞌofo uyɨmonji yalokunoso olohonta olo sɨkwoꞌmiyo lomo noho fiyo. Oso hunoso Seten umentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Oso hohosohonta Jisas kako huno ole uyɨmento, Anɨtu kako yoꞌmayo hopiꞌnonohinoso ngkimo enjwaꞌmo nto hoꞌnanɨhumasofoho. Huno nomꞌne olo soꞌnji huno uyɨmento, Nje Mpohwo kako olo hwaho lopo nɨhwatɨmentiso sohwoꞌni ngko apaꞌno kakiyepono asomo nosɨmnefoho. Huno ose uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Oseso Jisas kako wopayo fehohnjo moiꞌwo manyohwo kako nolɨkafonto kakoe nemꞌno manjiꞌmofo wae yaofonto kako sosayo sɨpoꞌnyo nomanto kakoe sɨmehopo nano mtitofahinɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ose mtitofahinonto kako mijo nomanto noswanopo sisasyonto kako kakoe inomokomoyo sohwonaꞌniye sɨfemo mijo yonemaꞌmentisofoho. Ose yonemanto kakoe sosayo sɨpoꞌnyo kakoe sɨmehopo mtitofahinɨmentiso soꞌnji sosayo nasɨpoꞌmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Oseso Jisas kako Saimoun Pitamo uꞌmahonɨngki Pita ulɨmento, Hwe Engofo, kɨko nje sɨfemo mijo uyonɨmaꞌmonntaho. ");
INSERT INTO apz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ose ulohonɨngkahonɨngki Jisas ulɨmento, Olohonta olo kilohofalokwe loso kɨko huno makiyohoyohoho. I osoꞌno hwangku kɨko huno wakiyɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ose ulahonɨngki Pita ulɨmento, Nje sɨfeso mijo niyanɨmahotoho. Nɨhuꞌno ngkilaho. Ose ulahonɨngki Jisas ulɨmento, Ngko jɨje sɨfemo mijo miyokumasoꞌmanji kɨko ngkoꞌnji mohumayoꞌne hwosoho. Kɨko nje syoho mantohofiyoꞌne hwosoho. ");
INSERT INTO apz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ose ulahonɨngki Saimoun Pita komoꞌno ulɨmento, Hwe Engofo, oseꞌmanji nje sɨfemnohini yonɨmahotoho. Oꞌo, nje aho mnokino hopiꞌnonohino lomo fiyonɨmaho. ");
INSERT INTO apz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ose ulahonɨngki Jisas ulɨmento, Aꞌamu fihwo kakoe aꞌapaho hiꞌnji mijo nto yomoꞌnɨngkiso sohwo kako kiho ane imoꞌnyo soꞌno syoho engoꞌnjo hwoꞌmaho. Oꞌo, kakoe sɨfemnohini mijo yomoꞌnɨngkuhwosi kiho aneꞌnjo wohumamontonoho. Olo ango lomo humalohwone sohwasi angaꞌnohinohwo kihoꞌnjohwo humaho. Nomꞌne sohwasi kiho ane hwasoho. Ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Hwapɨngoso Jisas kako Jutas kakineꞌno tokoyoꞌofo yone sohuneꞌno huno uyahonɨngki, Angaꞌnohinohwo kihoꞌnjohwo humaho eso ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Oseso Jisas hofɨkoe sɨfemo mijo moiꞌwo esojwamofonto kakoe nemꞌnomanjiꞌmofo apaꞌno yonto nakwoꞌnji apaꞌno ampo humamentisofoho. Nohumanto nalɨmento, Ngko sekwoe sɨfemo mijo yosemahe soꞌno huno itoꞌno nto laseyohoho. ");
INSERT INTO apz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ose ulonto ulɨmento, Sekwo ngkineꞌno Hungkuno Mesyolonetɨhwayo hwosoho. Nakwoe Hwe Engo hwosoho ntɨwoꞌnɨngkohofɨhwasoho. Oso hungkuno ntɨwoꞌnɨngkohofoso ntoꞌnohinoho. Ngko huhwoꞌne osenohinoho. ");
INSERT INTO apz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ngko sekwoe hwe engo sohwoꞌni sekumo hungkuno meselutɨhwayo sohwoꞌni ngko sekwoe sɨfemo mijo yosemahono. Sekwo nakwo hwe engo hwonaꞌnyoho lɨkuji nomꞌne aꞌamu sofe sɨfemo mijo miyomapitnnoho lonji selohofohono. Oseso sekwo sohwasi sekwo nomꞌni hwafe sɨfemo mijo yɨmaofɨkujoꞌno hofɨko sekwoe sɨfemo uyosemapɨfe. ");
INSERT INTO apz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Olo selohofohe yahino loso nto setɨhwaheso sekwo nomꞌni hwamo ose ulohopmno. ");
INSERT INTO apz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ose ulonto ole ulɨmento, Ngko hungkuno nehopiꞌnohini waselɨmonneꞌno yohono. Upaꞌnɨmno. Aꞌamu fihwa hofɨko nomꞌnihwoe syoho ulohofiyɨwoꞌnɨngkohofo sohwa hofɨko hofɨkoe hwe engomo muyakolopitnne hwafoho. Aꞌamu fihwa hungkuno motawowoꞌnɨngkohofo sohwa hofɨko aꞌamu lɨhwatɨmentiso sohumo muyakolopitnne hwafoho. ");
INSERT INTO apz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ngko sekwoe hwe engo sohwoꞌni ngko olo hiloso selohofohe soꞌno sekwo olo hungkuno selalokwe hwapɨngoso huno waseyono. Sekwo nomꞌne hwamo ulohofoso ngko selohofohe hopaso ifijoꞌmanji sekwo sɨmeho wopɨngo wasemoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ose ulonto ole ulɨmento, Olo hungkuno selalokwe loso sekwo hopiꞌnonohino sohwahnneꞌmaho. Ngko sehwosopoꞌmentohe sohwahnneꞌno sekwoe yahino humayo soꞌno ngko huno niyohoho. I osoꞌno Anɨtuye hungkuno aꞌamu mtɨꞌmokumentohofoso ne umoꞌnɨmontonoho. Hungkuno angaꞌnohinoso olenoho. Hwe fihwo ngkoꞌnji wosopayo nososohwo kako ngkineꞌno hohujo ikinjanɨmofɨhwosi nje mangohwo umoꞌnɨmontonoho. Ifalifaliyo ose mtɨꞌmokumentohofofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Oso hungkuno hiso ne imoꞌnoso sohontaꞌneꞌno selalokweno. Ne imoꞌnɨngkuhwosoꞌno sekwo huno ole wosyonɨfɨsyantɨfeho. Jisas kako neꞌnjo hweho. Ose wosyonɨfɨsyantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ngko hungkuno nehopi waselɨmonneꞌno yohono. Ngko aꞌamu fihumo uhwojahonɨꞌmo aꞌamuso osohumo utɨmafɨkuji wopɨngo ulohopɨfijoꞌmanji hofɨko ngko huhwoꞌnɨmo ntɨmafɨkuji wopɨngo wontohofantɨfeho. Aꞌamu ngkimo ntɨmalokwofo sohwa hofɨko nje Mpohwo Anɨtu huhumo utɨmalokwofo. Ose nalɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Oso hohosohonta Jisas kako hi tango mɨkunɨmposo uyahonɨngki kako hungkuno yolohoso ole lɨjwaoꞌmento, Hungkuno nehopi waselɨmonneꞌno yohono. Hwe fihwo kako olo ango lomo sekwoꞌnji humaso sohwo kako mango sohwafe ahomo wohoꞌnanɨhumonte hweho. ");
INSERT INTO apz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ose nelahonɨngki kakoe inomokomoyo angaꞌno angaꞌnohino sohwonaꞌni honɨngkonontani tɨhuneꞌno kalohoho huno syafɨhuꞌmentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ngko Joun olo hungkuno ifalifaliyo mtɨꞌmokalokwe sohwoꞌni Jisas kako ngkimo sɨmeho engo ntapɨwoꞌnɨngkiso soꞌno ngko Jisasɨꞌnji afapo humohumantohe hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Oseso Saimoun Pita kako ngko Jounꞌni uhwonyoꞌne aho songo songo yahonɨngki ngko kakimo uhwonɨngkahonɨngko Pita ole ntɨmento, Kɨko Jisasɨmo ulohonyo. Tɨhuneꞌno kolalofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ose ntahonɨngki ngko Jisasɨmo ikinjamo lohofonji ulɨmentoho, Hwe Engofo, kɨko tɨhuneꞌno lalokuno. ");
INSERT INTO apz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ose ulahonɨngko Jisas nalɨmento, Ngko wosopayo kutnnyoso mijomo yomahmꞌmo aꞌamu fihumo uyɨmonnoho. Oso huhweho. Jisas ose nalonto kako wosopayo kutnnyoso mijo yomanto Jutas, Saimoun Isɨkaliyoutɨye hwomumo uyɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ose uyahonɨngki Jutas nɨmentisofoho. Oso hohosohonta Seten kako Jutasɨmo ehuhnnaoꞌmentisofoho. Jisas Jutasɨmo ulɨmento, Kɨko yoꞌmayo umonji yohinoso olohonta komoꞌno fiyo. ");
INSERT INTO apz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Oso hungkuno Jisas Jutasɨmo ulɨmentisoso kakoe inomokomoyo sohwonaꞌni osopo humohumantɨhwone sohwonaꞌni hwapɨngo neso huno monayo hwonaꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Oꞌo, fehohnjo sohwonaꞌni nakwo Jutas nakwoe hamniyoho ipofo mokosyohumawoꞌnɨngkiso soꞌno huno ole syafɨhuꞌmentɨhwoni, Jisas kako oso Sɨkuno Engo iyoho humayo soꞌne yoꞌmayo mpe-eꞌne lɨhwatɨmentiso soꞌno syafɨhuꞌmentɨhwonefoho. Fehohnjo sohwonaꞌni huno ole syafɨhuꞌmentɨhwoni, Jisas kako aꞌamu umofonyo iyo somo hamniyoho uyoꞌno lɨhwajɨmentiso soꞌno syafɨhuꞌmentɨhwonefoho. ");
INSERT INTO apz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jutas kako oso wosopayo nomanonto mempono komoꞌno humentisofoho. Noswonto uhwonɨmentisoso sɨkuno nto mjaoꞌmentisoso uhwonɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jutas kako syukwato lohofahonɨngki Jisas kakoe inomokomoyo nomꞌne sohwonaꞌnɨmo nalɨmento, Olohonta Aꞌamufe Hwomu sohwoꞌniye yofe engo utɨhwaꞌnyopo uꞌmofapmmontonoho. Oso hisoꞌno Anɨtuye yokumpohnꞌnyo engo somo aꞌamu tɨmo uhwonɨngkuji hofɨko kakoe yofe engo wohoꞌnomantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ngko nje Mpohwoe yofe engo imokuꞌmeꞌno Mpohumo kakoe yofe engoso kakoe Hwomu sohwoꞌnɨmo komoꞌno wontapmmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ose nelɨkwato lohofonto ole nalɨmento, Nje mehomi sohwasi ngko sekwoꞌnji weꞌenepi nohumahmꞌmo woselɨkoꞌmaꞌmonnoho. Oso hohosohonta sekwo ngkineꞌno hafɨhafe wonyopi wotɨpeentɨfeho. Ngko aꞌamu Juta sohwamo hungkuno nto ulɨmaleso olohonta sekwo huhwahnnonji selalokweno. Ngko ume sopo sekwo olohonta ngkimo monɨꞌmapitnnohofo. ");
INSERT INTO apz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Oseso ngko honɨngkano hungkuno songo sejopalokweno. Sekwo sekwoe aꞌamu somneꞌno sɨmeho wosemaꞌnono. Ngko sekumo sɨmeho sejopalokwe paꞌnyoso sekwo sekwoe aꞌamu somo sɨmeho uyɨmno. ");
INSERT INTO apz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sekwo oso hopa aꞌamu somo sɨmeho uyɨkujoꞌno nomꞌne aꞌamuso sehonɨngkuji ole waselɨfe, Jisasɨye inomokomoyo hwasoho. Ose woselantɨfeho. ");
INSERT INTO apz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimoun Pita kako Jisasɨmo ulɨmento, Hwe Engofo kɨko ntɨꞌmne hwosilo. Ose ulohonɨngkahonɨngki Jisas ulɨmento, Ngko ume soponeꞌno kɨko olohonta mannɨngkapihnnohino. I osoꞌno hwangku sohonta kɨko ngkimo nɨꞌmatnne hwosoho. ");
INSERT INTO apz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ose ulahonɨngki Pita ulɨmento, Hwe Engofo, olohonta ngko kikimo mokinɨngkapeso pipineꞌelo. Aꞌamu sohwa hofɨko kikimo fonjakohufijoꞌmanji hofɨko ngkimo fonjanisiyoso wopɨngofoho. Ngko kikimo kufoꞌmayoꞌne peꞌnɨmeso wopɨngofoho. Wapeꞌnɨmo. ");
INSERT INTO apz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ose ulahonɨngki Jisas ulɨmento, Kɨko ngkimo nɨfoꞌmayoꞌne wapeꞌnɨmo lalohino. Hungkuno nehopiꞌnohini wakilɨmonneꞌno yohono. Olohonta tosɨka yoka mahoꞌnyo sohonta kɨko mango hufaꞌu sɨhune ole walɨmonnoho, Ngko Jisas sohuneꞌno huno maniyo hwoꞌnyoho. Aꞌamu somo ose ulɨmonnoho. Jisas Pitamo ose ulɨmentisofoho. ");
INSERT INTO apz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas kakoe inomokomoyo sohwonaꞌnnonji nohumentani nakumo nalɨmento, Sekwo sekwoe sɨmeho wonyo semoꞌnɨngkuhwoloho. Oꞌo, sekwo Anɨtumo sɨmeho hiꞌntnnono neꞌno uyɨmno. Osoꞌno sekwo ngko huhwoꞌnɨmo sɨmeho hiꞌntnnono ntapmno. ");
INSERT INTO apz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nje Mpohwoe angoso sohe piꞌnɨngoꞌnjoponoho. Oso hungkuno hiso ne aneꞌnjontentesi ngko sekumo hohonta selɨꞌmnesohilo. Ngko sekwoe ango itoꞌno wesyohumamne hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ngko sekwoe ango itoꞌno yasesɨꞌmo ngko sekumo setɨmayoꞌne asomo wapmne hwoꞌnyoho. Osoꞌno sekwo ngkoꞌnjo afa nohopo humentɨhwanefoho. ");
INSERT INTO apz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ngko sɨmne honɨngkano somneꞌno sekwo huno seyohoho. ");
INSERT INTO apz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ose nelahonɨngki Toumas ulɨmento, Hwe Engofo, kɨko ntɨꞌmne hwosilo. Nakwo huno monayohoyohoho. Nakwo oso honɨngkano somneꞌno hunoso pipi ihwasi syofɨsyanehwono. ");
INSERT INTO apz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ose ulahonɨngki Jisas ulɨmento, Ngko sohwoꞌni Mpohumo uꞌmayoꞌne honɨngkano hwoꞌnyoho. Ngko hungkuno nehopiꞌnohino hwapɨngo hwoꞌnyoho. Ngko songo neꞌno humayoꞌne hwapɨngo hwoꞌnyoho. Aꞌamu fihwo kako Anɨtumo uꞌmayoꞌne honɨngkano nomꞌneso mauyoho. Oꞌo, ngkoꞌnohini Mpohumo uꞌmayoꞌne honɨngkano hwapɨngo hwoꞌnyoho. ");
INSERT INTO apz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sekwo nje hwapɨngo ne soꞌno huno ntoꞌno seyontentesi sekwo nje Mpohwo huhuneꞌno huno seyɨhwonesohilo. Olohonta sekwo Anɨtuneꞌno huno nto seyohoho. Sekwo kakimo nto uhwonɨngkohofo. Sekwo ngkimo nohonɨngkohofo soꞌno sekwo Anɨtu huhumo uhwonontɨfi kakineꞌno huno ntoꞌno seyohoho. ");
INSERT INTO apz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ose ulahonɨngki Filip ulɨmento, Hwe Engofo, kɨko Mpohumo fonetɨhwaho. Nonetɨhwahojoꞌno nakwo sɨmeho wopɨngo wonamoꞌnɨmontonoho. ");
INSERT INTO apz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ose ulahonɨngki Jisas kako ulɨmento, Filip ngko sekwoꞌnji sɨkuno piꞌnɨngo engo nto humantohe hwoꞌnyoho. I osomo kɨko ngkineꞌno huno itoꞌno makiyoꞌnjo hwosilaho. Aꞌamu ngkimo nohonɨwoꞌnɨngkiso sohwo kako nje Mpohwo Anɨtumo uhwonalofoho. Osoꞌno pipineꞌno lohino. Kɨko Mpohumo fonetɨhwaho lohinosofo. ");
INSERT INTO apz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kɨko ole losyofɨsyalokuno. Jisasɨꞌnji kanɨngkwohwoꞌnji siko afaꞌmaho. Oꞌo, Jisas kako kengo hweho. Kanɨngkwohwo kengo hweho. Ose losyofɨsyalokuno. Hungkuno ngko sekumo selinyoso nje huno mtaꞌangoꞌmaho. Oꞌo, Mpohwo Anɨtu kako ngkimo humaso sohwo kako yoꞌmayo syoho iwoꞌnɨngkohoho. ");
INSERT INTO apz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Sekwo olo hungkuno homo somo sɨmeho hiꞌntnno