﻿USE sofia;
DROP TABLE IF EXISTS sofia.apyNT_vpl;
CREATE TABLE apyNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES apyNT_vpl WRITE;
INSERT INTO apyNT_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Apitoryme kapu tyrise Ritonõpo a, nono roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Sero sã pyra, typõke pyra sero nono kynexine, onokyro pyra, otyro pyra, tuna rokene. Xinukutume rokẽ kynexine tuna konõto po, Ritonõpo Zuzenu toytose tuna epozakuroko. ");
INSERT INTO apyNT_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","— Saereme exiko! tykase Ritonõpo. Mame tõmehpitose, saereme toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Saerehkatoh tonese Ritonõpo a, kure rokene, xinukutumã sã pyra. ");
INSERT INTO apyNT_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Moro tosehpase eya saeremãme, moro xinukutumã tosehpase eya “kokome”. Morarame tõmehse rahkene, moro aẽmehpitory osemazupu kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Mame ynara tykase Ritonõpo: — Tuna atapiakako, zokonaka onuhtohme! ");
INSERT INTO apyNT_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Morarame tuna tãtapiakase zokonaka zopino ehtohme te, zokonaka kakoxi onuhtohme, amerehmã moinakoxi. ");
INSERT INTO apyNT_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Moro tosehpase eya “kapume”. Xinukutu, sã, moro asakoro aẽmehtoh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Morarame tõmiry ke tuna amerehmã zopino tapiakase Ritonõpo a, esaka tyripose, nono osenetohme! Mame moro sã toehse, nono tonore! ");
INSERT INTO apyNT_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Moro “nonome” tosehpase Ritonõpo a. “Tuna konõto” me moro tuna tõ tosehpase eya. Mame morohne eneryke tyya Ritonõpo zamaro inyrityã kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Morarame ynara tykase ynororo: — Awahtako emero rokene, tykase otytyko a, topere exiko tupuhtuke roropa oehtohme! Mame morara toehse kehko. ");
INSERT INTO apyNT_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nono po otyro tõkehko tahtase emero porehme: tupuhtuke exiketomo te, wewe tõkehko, topere exiketomo. Mame morohne eneryke tyya Ritonõpo zamaro inyrityã kynexine kure exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Xinukutu, sã tõmehse oseruao aehtopo. ");
INSERT INTO apyNT_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Morarame ynara tykase Ritonõpo: — Ezurume exiko kapu poko saerehkaneme, ẽmepyry apiakatohme, koko apiakaneme te, jeimamyry apiakaneme te, ikonopory, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Moro ezuru tõ saereh ãko mã kehko sero nono po, tykase Ritonõpo. Mame morara toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Asakoro ezuru konõto tõ tyrise eya: zumono saerehkatohme saereme te, zumo hkopyra exikety saerehkatohme koko. Xirikuato tõ tyrise roropa eya. ");
INSERT INTO apyNT_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kapu poko morohne tyrise eya saerehkatohme nono pona, ");
INSERT INTO apyNT_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","saerehkane tuisaryme xixi, koko tuisaryme nuno. Ritonõpo zamaro kynexine inyrityamo. ");
INSERT INTO apyNT_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Xinukutu, sã tõmehse, 4me aehtopo. ");
INSERT INTO apyNT_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Morarame ynara tykase Ritonõpo: — Nakuaõkõme ehtoko, kana tomo pehme tuna ehtohme isene exiketõ ke, torõ tõme roropa ehtoko taporihkãme kae ytoketõme! ");
INSERT INTO apyNT_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Moro sã isene exiketõ konõto tõ, nakuaõkõ tyrise Ritonõpo a, isene exiketomo, kana tomo emero tyrise eya nakuae ytoketomo, torõ tõkehko roropa emero tyotyoro exiketõ tyrise eya. Mame tynyrityã eneryhtao tyya Ritonõpo zamaro inyrityã kynexine, kure exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Mame kure tynyrityã tyripose eya, ynara tykase ynororo: — Oemãtoko, tuhke oehtohkõme, pehme tuna konõto ehtohme! Torõ tõ roropa oemãtoko tuhke oehtohkõme sero nono po! ");
INSERT INTO apyNT_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Xinukutu, sã tõmehse, 5me ehtopo. ");
INSERT INTO apyNT_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Morarame ynara tykase Ritonõpo: — Nono poro ytoketõme ehtoko, onokyro tomo, okyno tõkehko, zakare tõkehko, tykase. Morara exiryke moro sã toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Onokyro tõkehko tyrise Ritonõpo a inunomo te, pisararano, emero rokẽ tyrise eya, okyno tõkehko roropa, isene exiketõ emero. Mame tynyrityã eneryke tyya Ritonõpo zamaro inyrityã kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Mame ynara tykase ynororo: — Eropa, ahno syritase kysã exikety. Mame kana esẽme exĩko mã toto te, torõ tõ esẽme te, okyno tõ esẽme te, onokyro tõ esẽme, emero nono poro ytoytoketõ esẽme roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Moro sã ahno tyrise Ritonõpo a; tysã tyrise toto eya. Tyrise toto eya orutuame, nohpome, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mame kure rokẽ tyripose toto eya, ynara tykase: — Emũkuatoko, tuhke oemãtohkõme, sapararahme oehtohkõme sero nono poro, emero esẽme oehtohkõme. Kana esẽme ehtoko tunakuaõkõ emero te, torõ tõ esẽme roropa te, onokyro tõ esẽme okyno tõ esẽme, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Anapyrykõme otyro ekarõko ase tupuhtuke exiketomo te, wewe epery roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Yrome onokyro tõkehko a, torõ tomo a, nono poro ytoketomo a roropa onahpoty ekarõko ase toto napyryme, otyro ary roropa. Mame moro sã toehse rahkene. ");
INSERT INTO apyNT_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Morara exiryke tynyrityã eneryhtao tyya Ritonõpo zamaro inyrityã kynexine. Kure rokẽ kynexine. Xinukutu, sã tõmehse, 6mano. ");
INSERT INTO apyNT_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Morarame tõtyhkase Ritonõpo tynyrityã poko: kapu te, nono te, emero epõkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","7me tõmehse ahtao tõtyhkase ynororo tynyriry tõ riry poko, mame tõseremase ynororo, toerohkehxĩpo. ");
INSERT INTO apyNT_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Mame moro ẽmepyry tyripose eya ẽmepyry kurãme, tõtyhkase toexiryke toerohtoh poko te, tõseremase roropa ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Moro sã kapu tyrise kehko, nono maro. Kapu tõkehko tyrise ahtao Ritonõpo a, sero nono maro, ");
INSERT INTO apyNT_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","otyro pyra, onahpoty pyra roropa kynexine, konopo onenehpopitopyra ro Ritonõpo exiryke. Tupito arykananõ pyra roropa kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Yrome nono ae tuna tutũtase nono ehxikatohme. ");
INSERT INTO apyNT_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Morarame nono tapoise Ritonõpo a ahnome apuhtohme. Tynyrihpyry tounapũmase eya isene aehtohme, moro sã ahno toehse isene exiketyme. ");
INSERT INTO apyNT_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Moromeĩpo tupito tarykase Ritonõpo a, Etẽ nonory po, xixi tũtatoh wino. Morotona tynyrihpyry ahnome tyrise eya. ");
INSERT INTO apyNT_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Moro po wewe kurãkõ tyrise Ritonõpo a emero rokẽ aeperytatohme. Epery kure toperytase kehko. Moroto tupito rãnao eperytakety kynexine isene jũme orihpyra ehtopo. Imepỹ zoko roropa moroto kynexine kure ehtoh poko tuarõtatopo, popyra ehtoh poko tuarõtatopo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Moro Etẽ po iporiry tutũtase otyro ehxikaneme. Morotoino tapiakase moro iporiry 4me tuna ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Toiro tuna esety kynexine Pisõ, Hawira nonory zomye ytokety. Moroto uuru nae kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Moro uuru kure kynexine. Moroto ixtaratu kurã roropa kynexine, topu kurã roropa moroto kynexine joiame exikety. ");
INSERT INTO apyNT_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Mame imepỹ tuna esety kynexine Kiõme. Moro rãnakuroko kynexine Kuxe nonory po. ");
INSERT INTO apyNT_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","3me aehtoh kynexine tuna Tikere mano. Moro kynexine Axiria ehpikuroko xixi tũtatoh wino. Mame tuna kynexine 4me aehtopo Eupyrati esety kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Naeroro tynarykahpyry po Etẽ po mokyro orutua tyrise Ritonõpo a tupito poko aerohtohme otyro arykatohme. ");
INSERT INTO apyNT_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mame ynara tyripose ynororo eya: — Wewe epery emero ekarõko ase oya anapyryme, ");
INSERT INTO apyNT_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","toiro wewe epery rokẽ tuarõtatoh zae ehtoh poko te, popyra ehtoh poko roropa, moro epery rokẽ osenahno. Moro epery onenahpyra exiko, ynara exiryke, tonahse oya ahtao moro ae ro orihnõko mase. ");
INSERT INTO apyNT_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Moromeĩpo ynara tykase Ritonõpo: — Toiroro mose ehtoh popyra nase. Imepỹ rĩko ase imarõme aehtohme, akorehmaneme, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Apitoryme nono tapuhse Ritonõpo a emero rokẽ onokyrome, torõ tõkehkome roropa. Mokaro tarose eya toto esehpatohme orutua a. Tosehpase toto eya. ");
INSERT INTO apyNT_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Torõ tõ tosehpase eya, okyno tomo, onokyro tõ roropa emero tosehpase toh eya. Yrome toto maro akorehmane onenepyra kynexine imaro exiketyme. ");
INSERT INTO apyNT_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Naeroro mokyro tynyhmapose Ritonõpo a ironaka. Tynyhse ynororo ahtao aoropary zehpyry toiro touse Ritonõpo a. Mame ipũ tapuruse ropa eya. ");
INSERT INTO apyNT_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Moro aoropary zehpyry tyrise nohpome Ritonõpo a. Tarose ynororo eya orutua a. ");
INSERT INTO apyNT_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","— To! Mose kure ipunaka! Upũ mose ro, yzehpyry roropa. “Nohpome” mose esehpãko ase upũ risẽme exiryke, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Morara exiryke orutua kõ tumy rumekãko, tyse rumekãko roropa mã toto typyty maro rokẽ toehtohme. Mokaro asakoro toiro pũme exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mokyro orutua nohpo maro, asakoro ro tupoke pyra toh kynexine. Yrome ihximyra toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Morarame okoi tuarohxo kynexine, imehnõ onokyro tõ motye, onekunohtõme kynexine. Tõturupose ynororo nohpo a: — Ajohpe pyra “Tupito põ wewe epery osenahno,” naseh oya Ritonõpo? ");
INSERT INTO apyNT_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","— Ỹ, wewe tõ epery enahnõko ynanase emero repe, tykase, tozuhse nohpo a. — Tupito rãnaõ epery rokẽ onenahpyra ynanase. Moro epery rokẽ: “Osenahtou, anapoipyra ehtoko oorikyrykõino,” nase Ritonõpo yna a, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","5","— Ajohpe! tykase okoi eya. — Orihpyra mase. Morara tykase Ritonõpo zuaro toexiryke, moro wewe epery enapyryhtao oya xine tuaro exĩko matose Ritonõpo ehtoh samo, kure ehtoh waro exĩko matose, popyra ehtoh waro exĩko roropa matose, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mame moro wewe kure tonese nohpo a, epery roropa kure potu tonese eya, tonahsẽme. Tõsenetupuhse ynororo: “Kure exiry emero zuaro toehse jahtao,” tykase ynororo tyya rokene. Naeroro moro wewe epery tapoise eya, tonahse roropa eya; tokarose eya tynio a, tonahse eya roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Morara ahtao enurukõ tãtapuruhmakase. Iirypyryme toehtohkõ poko tuarõtase toto. Ihxipỹke toehse toto, tymetyke pyra toexirykõke. Naeroro ituary ke toemetyhtose toto ihxipỹke toexirykõke. ");
INSERT INTO apyNT_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Moro ae ro tyryry tykase ahtao kokonie pukuro Ritonõpo omiry totase orutua a ipyty a roropa, aytoryhtao tynarykahpyry poro. Tõtonẽse toto wewe mitaka. ");
INSERT INTO apyNT_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yrome orutua tykohmase Ritonõpo a ekaropotohme: — Otokoh ma? ");
INSERT INTO apyNT_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ynara tykase orutua: — Õmiry etã osemazuhme oytoryhtao anarykatyã poro, yrome enaromỹke akene, tupoke pyra jexiryke. Naeroro otonẽno, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","— Onoky poe tupoke pyra oehtoh waro mexino? Enahpỹ epery menahno? tykase Ritonõpo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ynara tykase orutua: — Mose nohpo onekarohpyry ya ypytyme, mose ro a epery tonahpose ya, mame enahno rahkene. ");
INSERT INTO apyNT_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mame Ritonõpo tõturupose nohpo a: — Oty katoh morara myrino? tykase. — Okoi jenekunohno, tykase nohpo, — morara exiryke enahno, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Morarame ynara tykase Ritonõpo okoi a: — Onyrihpyry pokoino tuãnohsẽme exĩko mase. Taroino onokyro tõ rãnao omoro rokẽ ynara exĩko: arary po ytoketyme exĩko mase nono poro. Nono enahnõko roropa mase. ");
INSERT INTO apyNT_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Oxiehno nohpo maro orĩko ase. Ipoenõ oxiehno rĩko roropa ase opoenõ maro, jũme. Mame opuhpyry akurihmõko mana. Omoro ihtainy esekãko mase. ");
INSERT INTO apyNT_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Nohpo a ynara tykase Ritonõpo: — Itamurumehxo etuarimãko mase poetoẽme awahtao, opoenõ enururuhtao oxietũtõko mase. Morara ahtao ro onio poko penetãko ro mase. Oesẽme exĩko roropa mana. ");
INSERT INTO apyNT_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Mame Atão a ynara tykase Ritonõpo: — Omoro Atão azahkuru makene jomipona pyra makene, opyty omi poe moro wewe epery menahno. Naeroro zae pyra toehse oexiryke popyra nono ripõko ase. Naeroro yronymyryme erohnõko mase otyro arykary poko tynahke oehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ãtaryka ahtanohpõko ase, omoxino tõkehko. Mame tykyrysã enahnõko roropa mase. ");
INSERT INTO apyNT_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Yronymyryme erohnõko mase, enãkutãko roropa mase otupi poko tỹkyryneke oehtohme, oorikyry ponãmero. Mame nonome exĩko ropa mase. Nono apuhsẽme oexiryke nonome exĩko ropa mase toorihse awahtao, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mame typyty tosehpase eya Ewame emero ahno ẽme toehse aexiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mame upo tyrise Ritonõpo a okyno pihpyry: Atão zupõme te, ipyty zupõme roropa amurutohme eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mame ynara tykase Ritonõpo: — Seromaroro mokyro toehse yna samo, tutuarõtase aexiryke zae ehtoh poko te, zae pyra ehtoh poko roropa. Jũme isene ehtoh wewe epery enapyryhtao eya orihpỹme exĩko mana, popyra morara exiry eya. ");
INSERT INTO apyNT_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Naeroro Etẽ poe, tupito kurã poe orutua tonyohse Ritonõpo a ipyty maro osa menekatohme eya itu htao tutupime, nono poko aerohtohme, nono risẽme aexiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Morotoino orutua taropose Ritonõpo a. Mame osema tao xixi tũtatoh wino kerupĩ tõ tyrise eya typyreke, tytapemake apoto sã exikety ke. Eraseme toto ehtohme mokaro tyrise omõpyra ropa ahno ehtohme, moro wewe, jũme isene tyripotoh pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Morarame typyty Ewa maro toehse Atão, poetoẽme toehse ipyty. Mame toemũkuase orutuame, ynara tykase ynororo: — Takorehmase Ritonõpo a jexiryke toemũkuase ywy, tykase. Tumũkuru tosehpase eya Kaĩme. ");
INSERT INTO apyNT_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Imeĩpo toemũkuase ropa Apeume, Kaĩ akorony. Apeu toerohse kaneru tõ poko, Kaĩ kynexine tupito poko erohketyme. ");
INSERT INTO apyNT_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Moromeĩpo tỹkyryry tapoise Kaĩ a jahkatohme tynekaroryme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Apeu a toky poenõ osemazuhme aenuruhpyry tapoise, kaneru pitiko totapase eya, ipũ kurã tyahkase eya tynekaroryme Ritonõpo a. Ritonõpo zamaro Apeu kynexine, inekarohpyry roropa, ");
INSERT INTO apyNT_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","yrome Ritonõpo zamaro pyra Kaĩ kynexine, inekarohpyry se pyra kynexine. Mame Kaĩ tyekĩtapãse, tohne toehse ynororo ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Naeroro ynara tykase Ritonõpo eya: — Oty katohme ataekymãko mah? Oty katohme karime rokẽ ytoytõko mah? ");
INSERT INTO apyNT_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Zae ehtoh tyrise oya ahtao, tãkye mexiry; yrome zae pyra toehse oexiryke oorypyry oeraximãko oporemãkatohme. Naeroro tomeseke exiko orẽpyra oehtohme oorypyry poremãkatohme oya. ");
INSERT INTO apyNT_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Mame ynara tykase Kaĩ takorõ Apeu a: — Eropa tupito pona. Toeporehkase tahtao xine tupito pona, takorõ totapase eya. Toorihse Apeu. ");
INSERT INTO apyNT_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mame Ritonõpo tõturupose Kaĩ a: — Otoko ãkorõ Apeu nae? tykase. — Zuaro pyra ase, tykase Kaĩ, — jakorõ eraseme tokoh a? tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mame ynara tykase Ritonõpo eya: — Oty katoh sẽ sã mano? Ãkorõ metapano? Nono ae imunuru xitãko mana ynetaryme. Kui ãko sã ya mana tymỹpotohme. ");
INSERT INTO apyNT_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Naeroro osanume exĩko mase etuarimãko, tupito po anarykasaromepyra exĩko mase, ãkorõ munuru tomõse nono aka exiryke, totapase oya exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tupito poko oerokuruhtao anarykatyã ahtara mana, eperytara roropa. Tosake pyra exikety sã ytoytõko mase nono poro, epakety samo. ");
INSERT INTO apyNT_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Morarame Kaĩ a Ritonõpo tozuhse: — Õmiry oneanahtopyra ase. Jetũ ya mana. Juãnohtoh omoxinety sã ya, typoremãse jexiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Seroae jysyryhmapõko mase jesary poe, owinoino. Tosake pyra exiketyme jehtohme ytoytõko rokẽ ase sero nono poro. Imehnõ kurũke epãko ase otonẽnõko. Tonese jahtao imepyny a jetapary se exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yrome ynara tykase Ritonõpo eya: — Arypyra, morara exipyra mana. Imepyny a oetaparyhtao, 7me jekyrykõ orihnõko mana oemỹpotohme. Mame ewomatohme enetupuhpotoh tyrise Ritonõpo a Kaĩ poko. Tonohse eya tuaro imehnõ ehtohme onetapara toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Mame toytose Kaĩ Ritonõpo winoino imepỹ pona osesarise. “Ytoytotoh” pona toytose ynororo Etẽ poe xixi tũtatoh winakoxi. ");
INSERT INTO apyNT_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Mame typyty maro Kaĩ toemũkuase, esety Enoke. Imeĩpo pata tyrise Kaĩ a, moro pata tosehpase eya Enokeme tumũkuru esety ae ro. ");
INSERT INTO apyNT_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoke toemũkuase Irateme. Irate toemũkuase Meujaeume. Meujaeu toemũkuase Metusaeume. Metusaeu toemũkuase Ramekeme. ");
INSERT INTO apyNT_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Rameke typytase asakoro nohpo tõ maro: Ata te, Zira, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ata toemũkuase Japaume. Japau pakõ pui tõ poko erohketõme toehse, tapyi tõ pisarara tao toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Japau akorõ tõ kynexine Jupau. Jupau pakõ rue etonanõme toh kynexine, rira maro. ");
INSERT INTO apyNT_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Mame Zira toemũkuase Tupaukaĩme. Tupaukaĩ toerohse kurimene riry poko te, metau riry poko roropa. Aoryxiry kynexine Naama. ");
INSERT INTO apyNT_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Morarame Rameke a typyxiã turuse: — Ata, Zira maro jomiry ke etatoko, orutua nuasemã etapano totapase jexiryke eya. ");
INSERT INTO apyNT_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","7me Kaĩ etapahpõ ekyry taorihmapose ahtao Kaĩ etapatopõpyry emetakame, morara ahtao imepyny a jetaparyhtao, 77me jetapahpõ ekyry tõ orihnõko mã toto jetapatopõpyry emetakame, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Mame Ewa maro toemũkuase ropa Atão. Ynara tykase Ewa: — Imepỹ umũkuru tokarose Ritonõpo a ya, Apeu myakãme, totapase exiryke Kaĩ a. Tosehpase ynororo eya Seteme. ");
INSERT INTO apyNT_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sete toemũkuase Enome. Morara ahtao Ritonõpo esety kure tyripitose eya xine, Ritonõpo toahmapitose, tõseahmarykohtao eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ynara mã Atão pakomotyã esetykomo. Ahno tyrise ahtao Ritonõpo a tysã tyrise toto eya. ");
INSERT INTO apyNT_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Orutua te, nohpo roropa tyrise toto eya, kure rokẽ tyrise toto eya, mame “ahnome” tosehpase toto eya. ");
INSERT INTO apyNT_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Mame 130me jeimamyry taropose Atão ahtao toemũkuase ynororo tysã exiketyme, esety Sete. ");
INSERT INTO apyNT_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Moromeĩpo 800me jeimamyry taropose Atão a. Toemũkuase ropa imehnõ mũkuru tomo, ẽxiry tõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Mame toorihse ynororo 930me jeimamyry taropose ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Mame 105me jeimamyry taropose Sete ahtao toemũkuase Enome. ");
INSERT INTO apyNT_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Moromeĩpo 807me jeimamyry taropose Sete a. Toemũkuase ynororo imũkuru tomo te, ẽxiry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Mame toorihse ynororo 912me jeimamyry taropose ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Mame 90me jeimamyry Eno nae ahtao toemũkuase ynororo Kainãme. ");
INSERT INTO apyNT_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Moromeĩpo 815me jeimamyry taropose eya, toemũkuase orutua kõme, nohpo tõme, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Mame toorihse ynororo 905me jeimamyry taropose ahtao eya. ");
INSERT INTO apyNT_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Mame 70me jeimamyry nae Kainã ahtao toemũkuase Maarareume. ");
INSERT INTO apyNT_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Morotoino 840me jeimamyry taropose Kainã a. Toemũkuase ropa orutua kõme nohpo tõme, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Mame toorihse ynororo 910me jeimamyry taropose ahtao eya. ");
INSERT INTO apyNT_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mame 65me jeimamyry Maarareu nae ahtao toemũkuase Jareteme. ");
INSERT INTO apyNT_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Morotoino 830me jeimamyry taropose Maarareu a. Toemũkuase orutua kõme nohpo tõme, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mame toorihse ynororo 895me jeimamyry taropose ahtao eya. ");
INSERT INTO apyNT_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Mame 162me jeimamyry taropose Jarete a ahtao toemũkuase Enokeme. ");
INSERT INTO apyNT_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Morotoino 800me jeimamyry taropose eya. Toemũkuase ropa ipoenõme. ");
INSERT INTO apyNT_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Mame toorihse ynororo 962me jeimamyry taropose ahtao eya. ");
INSERT INTO apyNT_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Mame 65me jeimamyry taropose Enoke a ahtao toemũkuase Matuzarẽme. ");
INSERT INTO apyNT_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Morotoino 300me jeimamyry taropose eya Ritonõpo omipona yronymyryme, toemũkuase ropa ynororo orutua komo, nohpo tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","365me jeimamyry isene kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ritonõpo maro osepeme exikehpyra kynexine, imaro oturũko kynexine. Mame osenepyra toehse ynororo, tarose Ritonõpo a exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Morarame 187me jeimamyry taropose Matuzarẽ a ahtao toemũkuase Ramekeme. ");
INSERT INTO apyNT_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Morotoino 782me jeimamyry taropose ahtao eya, toemũkuase ropa ynororo orutua komo, nohpo tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mame toorihse ynororo 969me jeimamyry taropose ahtao eya. ");
INSERT INTO apyNT_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Mame 182me jeimamyry taropose Rameke a ahtao toemũkuase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Mame ynara tykase ynororo: — Sero nono popyra tyripose Ritonõpo a, morara exiryke kuerohtohkõ tupime toehse kyya xine; yrome mose, aimo oserematoh enehnõko ropa mana kyya xine. Tumũkuru tosehpase Rameke a Noeme. ");
INSERT INTO apyNT_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Moromeĩpo 595me jeimamyry taropose eya, toemũkuase imehnõ mũkuru tomo, ẽxiry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Mame toorihse ynororo 777me jeimamyry taropose ahtao eya. ");
INSERT INTO apyNT_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Mame 500me jeimamyry taropose ahtao Noe a toemũkuase ynororo oseruao: Sem te, Kam te, Jape, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Morarame ahno tãtahpahpitose ahtao sero nono poro, ẽxiry tõ tonuruse ahtao roropa, ");
INSERT INTO apyNT_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","mokaro nohpo tõ oryxime exiketõ tonese orutua komo a, Ritonõpo poetory tomo a. Tynymenekahpyry tõ tapoise eya xine typyxiãkõme toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Naeroro ynara tykase Ritonõpo: — Moxiã ahno jũme isene onyripopyra ase, orihketõme mã toto. Taroino 120me jeimamyry onymotyẽkara exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Moro zano ahno konõto kynexine moroto. Imeĩpo roropa, ahno ẽxiry tõ tapoise ahtao Ritonõpo poetory tomo a typyxiãkõme, toemũkuase toto. Mokaro ahno konõto tõ, orẽpyra exiketõme toh kynexine pake ahtao, imehxo toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mame popyra ahno ehtoh eneryke tyya, popyra rokẽ aosenetupuhtohkõ eneryke roropa tyya, ");
INSERT INTO apyNT_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","tãtasamase Ritonõpo kynexine ahno ritopõpyry poko tyya. Toemynyhmase ynororo, ");
INSERT INTO apyNT_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ynara tykase: — Mokaro enahkapõko ase, nono põkomo, ynyrityã emero, ahno te, onokyro tõkehko te, torõ tomo te nono poro ytoytoketomo. Yzamaro pyra ynyrityã toehse, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Yrome Noe nyriry Ritonõpo zamaro kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Sero nase Noe ehtopõpyry poko. Toemũkuase ynororo oseruao: Sem te, Kam te, Jape, enara. Zae exiketyme Noe kynexine, Ritonõpo omipona. Sero nono põkõ rãnao, Noe rokẽ Ritonõpo maro oturuketyme kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ritonõpo neneryme imehnõ emero popyra rokẽ toh kynexine, imeimehnõ ryhmãko toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Sero nono põkõ tonese Ritonõpo a, tyyrypyrykõ poko rokẽ toh kynexine emero porehme, popyra ehtoh poko rokẽ toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Mame ynara tykase Ritonõpo Noe a: — Osenetupuhno: ahno enahkapõko ase emero porehme. Toto orihmapõko ase emero, esarykõ roropa zumyhkapõko ase, pehme exiryke oxiehno exiketõ ke. ");
INSERT INTO apyNT_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Wewe kurã akohko kanawa konõto ritohme oya. Osa tõ tyriko zao, ikurihpako azawa ke erurukara ehtohme, zao te, jarao, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Zumo ehtoh ynara tyriko: 133 meturume mosa exiry te, 22 meturume ipurorony, 13 meturume kakoxi ehtopo. ");
INSERT INTO apyNT_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tapyi sã tyriko eworiko kae, apurume. Mame amohpyry zopino ynara tyriko: ½ meturume anapurupyra exiko ehpiryme wino tyryrykane omõtohme. Oseruao zara apõ tyriko, oseose poe, omõtoh tyriko ehpiry poko. ");
INSERT INTO apyNT_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Tuna kumanohpõko ase sero nono po isene exiketõ enahkatohme emero porehme. Sero nono põkõ emero orihnõko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Yrome oya ãkorehmatoh ekarõko ase. Naeroro omõtoko kanawa aka opyty maro te, omũkuru tõ maro, opoenõ pyxiamo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Tyriko roropa kanawa aka onokyro typytypye asasakoro emero, nono poro ytoketõ maro, toto osepynanohtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Tonahsẽ apoiko roropa anapyrykõme te, mokaro onokyro tõ napyryme roropa, okyno tõkehko emero napyryme, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Mame moro tymoise Noe a, Ritonõpo omihpyry ae porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Morarame ynara tykase Ritonõpo Noe a: — Omõtoko kanawa aka, omoro atapyĩ taõkõ maro emero. Omoro rokẽ zae exiketyme mase yneneryme. ");
INSERT INTO apyNT_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Aroko amaro onokyro tõkehko okyno tõkehko roropa. 7me aroko nuriamãkõkara, asakoro aroko nuriamãkomo orutua, nohpo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Torõ tõ roropa emero rokẽ 7me aroko amaro, toto emãtohme ropa sero nono po. ");
INSERT INTO apyNT_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ynara exiryke; taroino 7me ẽmepyry taropose ahtao konopo enehpõko ase, 40me ẽmepyry pona, saereme, koko, enara. Moro ke isene exiketõ enahkapõko ase, emero ynyrityamo. ");
INSERT INTO apyNT_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Mame Ritonõpo nyripohpyry emero tyrise Noe a, aomipona. ");
INSERT INTO apyNT_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","600me jeimamyry nae Noe kynexine tuna konõto tukumase ahtao nono zumyhkatohme porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tõsepynanohtohme kanawa konõto aka tõtyrise Noe, typyty maro, typoenõ maro, tumũkuru tõ pyxiã maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Onokyro tõkehko maro te, okyno tõ maro te, nuriamãkõ maro, nuriamãkõkara maro nono poro ytoytoketõ maro te, torõ tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Tõtyrise toto Noe tõ maro kanawa aka asasakoro, orutua te, nohpo, enara, Ritonõpo nyripohpyry omipona. ");
INSERT INTO apyNT_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Mame 7me ẽmepyry taropose ahtao nono tumyhpitose, tuna konõto kumaryke. ");
INSERT INTO apyNT_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Moro zano 600me jeimamyry Noe nae kynexine. Mame ẽmepyry 17mã po, nuno asakoro ehtoh po, tuna eutary tõ tuna konõto poe, nono zopino, toehmose kehko. Konopo konõto tooehse roropa kapu ae, osenuhmatoh konõto tõ tãtapuruhmakase samo. ");
INSERT INTO apyNT_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Konopo tooehse itamurume nono pona 40me ẽmepyry, koko saereme, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mame moro ẽmepyry ae Noe tõ typyty maro tõtyrise kanawa konõto aka tumũkuru tõ oseruao maro Sem, Kam, Jape te, ipyxiãkõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Toto maro onokyro tõkehko tõtyrise roropa, okyno tõkehko roropa te, nono po ytoytoketõ roropa, torõ tõ roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Emero tomõse toto Noe maro, kanawa aka asasakorone rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Tõtyrise toto orutua te, nohpo roropa, emero tyotyoro toto: onokyro tõkehko, okyno tõkehko Ritonõpo nyripohpyry ae ro Noe a. Mame Ritonõpo a omõtoh tapuruse, kanawa aka omõtopo. ");
INSERT INTO apyNT_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Morarame konopo konõto oehkehpyra nexiase 40me ẽmepyry pona. Itamurume xiriri tykase, sã katohro, sã katohro, sã katohro, zueme toehse tuna, mame kanawa tanỹse tuna a. ");
INSERT INTO apyNT_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Zueme toehse tuna exiryke kanawa tanỹse. ");
INSERT INTO apyNT_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Zuemehxo toehse tuna, ypy tõ tumyhkase emero kaetoko exiketõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Mame ypy tõ emero tymyhse ahtao tukumase ro tuna, 7 meturume. ");
INSERT INTO apyNT_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Toorihse emero isene exiketomo, nono põkomo: torõ tomo te, okyno tõkehko te, onokyro tõkehko te, nono poro ytoytoketomo te, ahno, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Toorihse emero toto nono põkomo, isene exiketomo, oseremaketomo. ");
INSERT INTO apyNT_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Noe rokẽ, tymaro exiketõ maro isene ro toh kynexine. Imehnõ emero tonahkapose Ritonõpo a, ahno te, okyno tõkehko te, onokyro tõkehko te, nono poro ytoytoketomo te, torõ tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mame 150me ẽmepyry taropose ahtao rokẽ tuna tãpaipitose ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Mame wenikehpyra Noe poko Ritonõpo kynexine, Noe maro exiketõ poko roropa, onokyro tõ poko te, okyno tõ poko kanawa aõkõ poko wenikehpyra kynexine. Tyryrykane tonyohse Ritonõpo a sero nono pona, mame tãpaipitose ropa tuna. ");
INSERT INTO apyNT_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tuna eutary roropa nono zopino nakuao, soesoekane tapuruse ropa Ritonõpo a, kapu tapuruse roropa Ritonõpo a konopo oehpyra ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","150me ẽmepyry ae tuna tãpaipitose ropa, axĩ pyra, pitiko, pitiko, tãpaise tuna. ");
INSERT INTO apyNT_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Mame 7me nuno ehtoh po 17me ẽmepyry aehtoh po totypohse moro kanawa ypy tõ Ararate po. ");
INSERT INTO apyNT_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Apaĩko ro tuna kynexine, 10me nuno ehtoh pona toehse kynexine. Morara ahtao ypy tõ emory tõsenepitose ropa kehko. ");
INSERT INTO apyNT_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","40me ẽmepyry taropose ahtao osenuhmatoh totapuruhmakase Noe a, tynyrihpyry kanawa ao. ");
INSERT INTO apyNT_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Atõko tonyohse eya. Mame oehpyra ropa mokyro tokurehse. Xiaxiake toytose ynororo tuna apaisã pona. ");
INSERT INTO apyNT_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Moromeĩpo utuku tonyohse eya tuna apaisẽ waro toehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Yrome toeramase ropa utuku, zueme ro tuna exiryke. Tuna etyhpyry onenepyra tokurehse ynororo. Morara exiryke toeramase ropa ynororo. Naeroro mokyro tapoise ropa Noe a tomary ke ẽmatohme ropa kanawa aka. ");
INSERT INTO apyNT_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Toraximase ropa Noe a 7me ẽmepyry pona. Mame saeremã pona utuku tonyohse ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tooehse ropa ynororo kokonie pukuro, wewe, oriwera ary, tonehse eya tỹtao. Moro eneryke tyya tuaro toehse Noe tuna apaisẽ poko. ");
INSERT INTO apyNT_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Naeroro toraximase ropa mya roropa 7me ẽmepyry pona utuku enyohtohme ropa. Tonyohse ropa ahtao utuku eramara ropa toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","601me jeimamyry nae Noe ahtao moro tuna konõto tãpaise ropa, nono tanoryse ropa. Mame ẽmepyry apitorymã po, nuno apitorymã po kanawa totapuruhmakase ropa eya, nono tonese eya tonore pohto. ");
INSERT INTO apyNT_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mame ẽmepyry 27mã po, nuno asakoro ehtoh po nono tanoryse kure. ");
INSERT INTO apyNT_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Naeroro ynara tykase Ritonõpo Noe a: ");
INSERT INTO apyNT_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","— Otũtatoko ropa kanawae opyty maro, opoenõ maro opoenõ pyxiamo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Onokyro tõkehko roropa, okyno tõ roropa itũtanohpoko ropa toto, torõ tomo te, nono poro ytoytoketomo, enara. Sapararahme aropoko toto nono poro toto emãtohme ropa, pehme nono ehtohme ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Morara exiryke Noe tutũtase ropa kanawae typyty maro, typoenõ maro, ipoenõ pyxiã maro. ");
INSERT INTO apyNT_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tutũtase roropa onokyro tõkehko te, okyno tõkehko te, torõ tõkehko, enara. Oximaro tutũtase ropa toto. ");
INSERT INTO apyNT_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Morarame apoto apõ tyrise Noe a okyno zahkatohme tynekaroryme Ritonõpo a. Torõ tõ tapoise eya okyno tõ maro, toitoine imeimehnõ okyno toh tae. Tyahkase toto eya tynekaroryme apoto apõ po Ritonõpo eahmatohme. ");
INSERT INTO apyNT_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mame Ritonõpo zamaro Noe nyahkahpyry kynexine. Typoxine inekarohpyry kynexine eya. Ynara tõsenetupuhse Ritonõpo: taroino sero nono põkõ onenahkapozomopyra ase te, popyra ehtoh onenehpopyra ropa ase sero nono pona ahno pokoino. Zuaro ase, typoetõkõ ae ro tyyrypyrykõ poko rokẽ osenetupuhnõko ahno tõ mana. ");
INSERT INTO apyNT_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Taroino isene exiketõ onenahkapozomopyra ase. Sero nono nae ahtao otyro arykatoh nae exĩko te, apoitoh roropa exĩko te, kuenime ehtopo te, axitũ ehtopo te, jeimamyry te, ikonopory te, ẽmepyry te, koko, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Mame ynara tykase Ritonõpo Noe a: — Kure rokẽ orĩko ase omũkuru tõ maro. Emũkuatoko oemãtohkõme sero nono po, sapararahme apakomotyãkõ ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Onokyro tõ emero te, torõ tomo te, nono poro ytoketomo te, kana tõkehko ouno xine exĩko mã toto. Toto esẽme exĩko matose. ");
INSERT INTO apyNT_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Onokyro tõ õnõko matose. Otyro enahnõko roropa matose. Morohne ekarõko ase oya xine anapyrykõme te, õtykõme, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Yrome toiro rokẽ onõpyra ehtoko, tõsemy imunuru maro, munu ao isene ehtoh exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Imehnõ onetapara ehtoko. Etaparyhtao, etapahpõ tuãnohsẽme exĩko mana. Ahno tosekase ahtao onokyro a mokyro tuãnohsẽme exĩko mana, orihnõko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ritonõpo ehtoh sã ahno tyrise exiryke ahno etapahpõ, totapaposẽme exĩko roropa mana imehnomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","— Emũkuatoko oemãtohkõme ropa, sapararahme apakomotyãkõ ehtohme sero nono poro. ");
INSERT INTO apyNT_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ynara tykase roropa Ritonõpo Noe tomo a, imũkuru tomo a roropa: ");
INSERT INTO apyNT_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","— Seromaroro jomiry etapõko ase oya xine te, opoenomo a te, apakomotyamo a te, ");
INSERT INTO apyNT_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","isene exiketomo a te, amaro xine kanawae itũtatyã ropa a, torõ tomo a te, okyno tõkehko te, onokyro tõkehko te, emero sero nono põkomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ynara jomiry etapõko ase oya xine, jũme jomiry onytyoromara ase: Taroino tuna onukumanohpozomopyra ase isene exiketõ enahkapotohme. Taroino sero nono onynerymapopyra ropa ase. ");
INSERT INTO apyNT_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Mame jũme jomiry oya xine, onytyoromara ropa ase. Zae jehtoh enetupuhpotoh ekarõko ase oya xine; ");
INSERT INTO apyNT_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","okohkuri rĩko ase akurũ pokona. Moro okohkuri eneryhtao enetupuhnõko matose jomihpyry poko, ynekarohpyry poko sero nono põkomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Akurũ tõ riryhtao ya kapu poko, okohkuri eneryhtao ya, ");
INSERT INTO apyNT_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","akurũ poko wenikehpyra ase jomihpyry poko oya xine, onokyro tõkehko a te, isene exiketomo a emero. Morara exiryke imepỹ tuna konõto kumara ropa mana isene exiketõ emero enahkatohme. ");
INSERT INTO apyNT_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Taroino okohkuri oseneporyhtao akuru poko, enẽko ase. Mame wenikehpyra ase jomihpyry poko oya xine, emero isene exiketomo a sero nono põkomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Moro okohkuri enetupuhpotohme mana, jũme jomihpyry poko, emero isene exiketomo a sero nono po. ");
INSERT INTO apyNT_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Mame Noe mũkuru tomo, kanawae itũtatyã ropa ynara kynexine: Sem te, Kam te, Jape, enara (Kam toemũkuase Kanaãme). ");
INSERT INTO apyNT_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Mokaro oseruao Noe mũkuru tõ kynexine. Noe pakomotyã tãtahpahse toto, sero nono poro porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Mame Noe tupito poko erohketyme kynexine. Apitorymãme kynexine tupito esẽme, uwa zoko tuhke tupito po nexiase. ");
INSERT INTO apyNT_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Morarame uwa eukuru jehnahpyry tyrise eya, tõse eya pitiko rokẽ pyra, toetỹse ynororo. Mame tohrame toehse ynororo tupoke pyra tytapyĩ tao. ");
INSERT INTO apyNT_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Moro tao tumy tupoke pyra tonese Kam a, Kanaã zumy a, tutũtase ynororo ekãtotohme turui tomo a, tumykõ tupoke pyra ehtoh poko. ");
INSERT INTO apyNT_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Naeroro kopeta tapoise Sem a, Jape maro, tymotary po kopeta tyrise ahtao tanue tomõse toto, tumykõ tyõtose eya xine kopeta ke, tupoke pyra aexiryke. Tupoke pyra tumykõ enery se pyra toexirykõke morara tyrise eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Moromeĩpo typakase ropa tahtao toetỹkehxĩpo, tutuarõtase ynororo Kam, tumũkuru akomihpyry nyrihpyry poko. ");
INSERT INTO apyNT_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Naeroro ynara tykase Noe: — Popyra ehtoh ripõko ase Kanaã pona. Irui tõ namotome exĩko mana myarotokorome. ");
INSERT INTO apyNT_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ynara tykase roropa Noe: — Kure rokẽ Ritonõpo mana, Sem Esemy, ipoetoryme zakorõ Kanaã ripory se ase. ");
INSERT INTO apyNT_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ritonõpo poe, tuhke nono esẽme Jape ripõko ase. Ipakomotyã Sem pakomotyã maro toto ripõko ase. Yrome Jape poetoryme, Kanaã tõ ripõko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Morarame zueme tuna konõto kumatopõpyry poe 350me jeimamyry taropose Noe a. ");
INSERT INTO apyNT_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Mame toorihse ynororo 950 anome toehse tahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noe mũkuru tõ oseruao: Sem te, Kam te, Jape, enara toh kynexine. Mame tuna kumatopõpyry poe, imeĩpo toemũkuase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jape poenõ ynara kynexine: Komea, Makoke, Matai, Jawã, Tupau, Meseke, Tira, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Komea pakomotyã Axikenaze tomo te, Ripate tomo te, Tokarama tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Jawã pakomotyã Erisa tomo te, Expania tomo te, Xipere tomo te, Rote tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Mokaro kynexine Jape pakomotyamo. Tuna ehpio toh kynexine, ahmõta po roropa. Tosatosake toh kynexine tynonoke te, ataomiry ae ro toh kynexine, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kam poenõ ynara kynexine: Kuxe te, Ejitu te, Ripia te, Kanaã, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuxe poenõ kynexine Sepa, Hawira, Sapata, Raama, Sapateka, enara. Raama poenõ kynexine Sepa te, Tetã, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuxe kynexine Ninirote zumy. Ninirote orẽpyra kynexine, apitoryme imehnõ poremãkaponeme kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Takorehmase Ritonõpo a exiryke, orẽpyra urakanaketyme kynexine. Imehxo aexiry waro imehnõ kynexine, tuhkãkomo. Morara exiryke ynara tykase imehnõ ipoko: “Ninirote sã exiko. Takorehmase Ritonõpo a exiryke orẽpyra toehse ynororo urakanaketyme.” ");
INSERT INTO apyNT_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Apitoryme pata tõ esẽme toehse ynororo Papironia pata te, Ereke pata te, Akate pata, enara. Moroto pata tõ oseruao Xinara po. ");
INSERT INTO apyNT_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Moro nono poe toytose Ninirote, Axiria nonory pona. Pata tõ tyrise eya moroto: Niniwe te, Reopote-Ia, Kara te, ");
INSERT INTO apyNT_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resẽ, enara. Resẽ pata irãnao kynexine Niniwe poe, pata konõto Kara pona. ");
INSERT INTO apyNT_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ejitu pakomotyã kynexine Ritia te, Anã te, Reape te, Napatu te, ");
INSERT INTO apyNT_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pataru te, Kasaru te, Kereta (pirixteu tõ tamuru kynexine), enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaã kynexine Xitõ zumy osemazupu, Hete zumy roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Imehnõ Kanaã poenõ roropa kynexine: jepuseu tomo te, amoreu tomo te, kirikaseu tomo te, ");
INSERT INTO apyNT_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heweu tomo te, arakita tomo te, xineu tomo te, ");
INSERT INTO apyNT_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arawatita tomo te, zemareu tomo te, hamateu tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Mame Kanaã pakomotyã sapararahme toytose toto. Toto nonory kynexine Xitõ patary poe Jeraa pona, Kaza pũto. Xixi tũtatoh wino toto nonory kynexine Sotoma po te, Komora po te, Atama po te, Zepoĩ po, Rasa pũto, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Mokaro kynexine Kam pakomotyamo. Oxiekyry tõ tosake toh kynexine te, ataomiry ae, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, Jape rui epereu tõ tamurume kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem poenõ ynara kynexine: Erão te, Asua te, Arapaxate te, Rute te, Arã, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arã pakomotyã ynara kynexine: Uze te, Huru te, Ketea te, Masa, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arapaxate kynexine Sera zumy. Sera kynexine Epea zumy. ");
INSERT INTO apyNT_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Epea tumũkue asakoro kynexine: Perekeme tosehpase apitorymã, sero nono põkõ tãtapiakase exiryke tonuruse ynororo ahtao. Zakorõ esety kynexine Jokotã. ");
INSERT INTO apyNT_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jokotã pakomotyã ynara kynexine: Aramota tomo te, Serepe tomo te, Hazaa-Mawe tomo te, Jera tomo te, ");
INSERT INTO apyNT_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Atonirão tomo te, Uzau tomo te, Tikira tomo te, ");
INSERT INTO apyNT_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Opau tomo te, Apimaeu tomo te, Sapa tomo te, ");
INSERT INTO apyNT_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opia tomo te, Hawira tomo te, Jopape tomo, enara. Mokaro emero Jokotã pakomotyã kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Toto esaryme kynexine Meza nonory poe Sepaa pona, ypy tõ poro xixi tũtatoh wino. ");
INSERT INTO apyNT_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Mokaro Sem pakomotyã kynexine. Oxiekyry tõ tosake toh kynexine te, ataomiry ae, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ynara kynexine Noe pakomotyamo, ahno tomo. Tuna kumatopõpyry poe tarona tuhke tomãse toto Noe pakomotyamo. ");
INSERT INTO apyNT_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Apitoryme sero nono põkõ ataomiry ae toh kynexine. Toiro rokẽ aomirykõ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Morarame toytorykohtao xixi tũtatoh wino toeporehkase toto nono konõto jakuraramã pona Papironia pona, Sinaa nonory po, moroto ehse toto. ");
INSERT INTO apyNT_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Mame tõturuse toto oxime: — Ehmaropa! Tijoro tõ syritone; syahkatone tũpore ehtohme! Naeroro tijoro nae toehse, tyrise eya xine exiryke, topu samo. Azawa panõ ke tyrise eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Mame ynara tykase toto: — Seromaroro pata syritone, tapyi kaetokohxo exikety roropa, akurũ pona ehtohme. Morara kuahtao xine orẽpyra exĩko sytatose kuaro xine exĩko imehnõ mana emero. Atahpahpyra roropa sytatose sero nono poro. ");
INSERT INTO apyNT_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mame tyhtose Ritonõpo, toto nyrihpyry enese. Ipatarykõ tonese eya, tapyi kaetokõ roropa tonese eya. ");
INSERT INTO apyNT_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ynara tykase Ritonõpo: — Moxiã oximõme mã toto. Aomirykõ toiro rokene. Sero tyrise eya xine apitorymãme. Taroino okynã pyra typenetatohkõ rĩko mã toto emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Eropa, aomirykõ sytyorõmapotase. Aomirykõ tytyoromapose ahtao osetara exĩko mã toto aotururukohtao oseya. ");
INSERT INTO apyNT_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Morarame sapararahme tyripose toto Ritonõpo a sero nono poro emero. Mame moro pata riry turumekase eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Mame moro pata esety Papeume toehse, moroto ahno omiry tytyoromapose Ritonõpo a exiryke. Mame moro poe tãtahpahse toto nono poro emero. ");
INSERT INTO apyNT_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ynara Sem pakomotyã kynexine. Asakoro jeimamyry taropose Sem ahtao, tuna kumatopõpyry poe 100me jeimamyry Sem nae ahtao toemũkuase ynororo Arapaxateme. ");
INSERT INTO apyNT_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Moromeĩpo 500me jeimamyry taropose Sem a. Toemũkuase ropa ynororo imũkuru tomo te, ẽxiry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Mame 35me jeimamyry taropose ahtao Arapaxate a toemũkuase Serame. ");
INSERT INTO apyNT_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Moromeĩpo 403me jeimamyry taropose eya. Toemũkuase ropa ynororo imũkuru tomo te, ẽxiry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Mame Sera, 30me jeimamyry taropose ahtao toemũkuase Epeame. ");
INSERT INTO apyNT_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Moromeĩpo 403me jeimamyry taropose eya. Toemũkuase ynororo imũkuru tomo te, ẽxiry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Mame Epea, 34me jeimamyry taropose ahtao toemũkuase Perekeme. ");
INSERT INTO apyNT_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Moromeĩpo 430me jeimamyry taropose eya. Toemũkuase ynororo imũkuru tomo te, ẽxiry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Mame Pereke, 30me jeimamyry taropose ahtao, toemũkuase Reume. ");
INSERT INTO apyNT_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Moromeĩpo 209me jeimamyry taropose eya. Toemũkuase ynororo imũkuru tomo te, ẽxiry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Mame Reu 32me jeimamyry taropose ahtao toemũkuase Serukeme. ");
INSERT INTO apyNT_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Moromeĩpo 207me jeimamyry taropose eya. Toemũkuase ynororo imũkuru tomo te, ẽxiry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Mame Seruke 30me jeimamyry taropose ahtao toemũkuase Naoame. ");
INSERT INTO apyNT_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Moromeĩpo 200me jeimamyry taropose eya. Toemũkuase ynororo imũkuru tomo te, ẽxiry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Mame Naoa 29me jeimamyry taropose ahtao toemũkuase Terame. ");
INSERT INTO apyNT_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Moromeĩpo 119me jeimamyry taropose eya. Toemũkuase ynororo imũkuru tomo te, ẽxiry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Mame Tera 70me jeimamyry taropose ahtao toemũkuase: Aparãme te, Naoa te, Harã, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ynara kynexine Tera mũkuru tomo: Aparã te, Naoa te, Harã, enara. Harã toemũkuase Rome. ");
INSERT INTO apyNT_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tera isene ro kynexine imũkuru Harã toorihse ahtao Papironia po, pata Ua po, tonurutopõpyry po. ");
INSERT INTO apyNT_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aparã typytase Sarai maro. Naoa typytase Miuka maro. Miuka te, Ixika maro Harã ẽxiry tõ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai emũkuasaromepyra kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Typatary Ua, Papironia põ turumekase Tera a, Kanaã pona toytotohme. Tymaro tumũkuru Aparã tarose te, typary Ro, Harã mũkuru te, typary ẽ Sarai, Aparã pyty, enara. Toeporehkase toto pata Harã pona, moroto tõsesarise toto. ");
INSERT INTO apyNT_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Moroto Tera toorihse, pata Harã po, 205me jeimamyry taropose ahtao eya. ");
INSERT INTO apyNT_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Morarame ynara tykase Ritonõpo Aparã a: — Ononory irumekako, oekyry tõ roropa, omy tapyĩ roropa. Imepỹ pona ytokose. Moro enepõko ase oya. ");
INSERT INTO apyNT_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Apakomotyã mã tuhke emãnõko mana. Kure rokẽ orĩko ase, tuhkãkõ awaro exĩko mã toto, kure rokẽ imehnõ rĩko roropa mase. ");
INSERT INTO apyNT_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Kure orinanõ rĩko ase kure. Yrome popyra orinanõ rĩko ase popyra. Mame opoe kure ehtoh enehpõko ase imehnomo a, sero nono põkomo a emero. ");
INSERT INTO apyNT_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","75me jeimamyry nae Aparã kynexine Harã nonory turumekase ahtao eya, Ritonõpo omi poe. Imaro Ro toytose roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Typyty tarose Aparã a tymaro te, turui mũkuru Ro te, imõkomory roropa te, ipoetory komo, Harã po tynapoityã tarose tymaro. Mame Kanaã pona toeporehkase tahtao xine, ");
INSERT INTO apyNT_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","toytose Aparã Kanaã nonory kuroko Xikẽ pona, Ritonõpo eahmatoh esary pona. Moroto wewe kurã kynexine More po, Ritonõpo eahmatopo. Morara ahtao kananeu tõ moroto kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Moroto tõsenepose Ritonõpo Aparã a. Ynara tykase ynororo eya: — Sero nono ekarõko ase apakomotyamo a. Moroto apoto apõ tyrise Aparã a, Ritonõpo eahmatohme, moroto tõsenepose eya exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Moromeĩpo ypy tõ nonory pona toytose Aparã, Peteu pata poe xixi tũtatoh winakoxi. Moroto tõsesarise ynororo. Peteu kynexine xixi omõtoh wino. Pata Ae kynexine xixi tũtatoh wino. Moroto roropa apoto apõ tyrise Aparã a Ritonõpo eahmatohme, toahmase eya moroto. ");
INSERT INTO apyNT_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Morotoino, xiaxiake toytose ynororo, ikurenaka rokẽ toytoryme Kanaã nonory poro. ");
INSERT INTO apyNT_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Morara ahtao konopo toehkehse Kanaã po. Tynahke pyra toehse toto, tomirykõ tyrohse eya xine. Naeroro Ejitu pona toytose Aparã okynã toehtohme moroto. ");
INSERT INTO apyNT_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Morarame eporehkasasaka Aparã tõ ahtao Ejitu pona, ynara tykase ynororo typyty Sarai a: — Etako pahne! Nohpo enekurã mase, oryxime ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Oeneryhtao tyya xine Ejitu põkõ opoko penetãko mã toto. Ynara ãko mã toto: “Mokyro pyty mose ro!” ãko mã toto opoko. Naeroro jetapãko mã toto, opokoino. ");
INSERT INTO apyNT_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Morara exiryke “Ypiry mose ro” kaxiko eya xine jetapara toto ehtohme. Mame kure jyrĩko mã toto, tykase Aparã. ");
INSERT INTO apyNT_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Mame toeporehkase Aparã tõ ahtao Ejitu pona, ipyty Sarai tonese moro põkomo a, nohpo oryxime nymyry. ");
INSERT INTO apyNT_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Tuisa a tokãtose ynororo, Ejitu esẽ akorehmananomo a. Tosẽkõ turuse eya xine mokyro nohpo kurã, oryxime ehtoh poko. Morarame tarose ynororo tuisa tapyĩ konõto taka. ");
INSERT INTO apyNT_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Mame nohpo se toexiryke kure rokẽ Aparã tyrise tuisa a. Kaneru tõ tokarose eya te, pui tomo te, jumẽtu tomo te, orutua komo ahno, nohpo tõ maro ipoetoryme toto ehtohme te, jumẽtu nohpory tomo te, kameru tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Yrome Sarai pokoino tuisa tuãnohse Ritonõpo a, itapyĩ taõkõ maro tyrohsẽ xihpyrymã ke, jetũ exikety ke. ");
INSERT INTO apyNT_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Mame tuisa a Aparã tonehpose tyya, tuisa a tõturupotohme. Ynara tykase ynororo eya: — Oty katohme jurupyra mexiase opytyme aexiry poko? Oty katoh “Ypyty mose ro” kara mexiase? ");
INSERT INTO apyNT_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ajohpe mexiase. “Woryxiry mose ro,” mase ya, wenekunopyase. Morara exiryke tapoise ynororo ya, ypytyme aehtohme repe. Naeroro mose, opyty aroko ropa; ytoko ropa taroino mose maro! ");
INSERT INTO apyNT_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Morarame tuisa omi poe, soutatu tomo a Aparã tarose ropa Ejitu poe ipyty maro ipoetory tõ maro, imõkomory tõkehko maro. ");
INSERT INTO apyNT_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Mame Ejitu poe Aparã toytose typyty maro, typoetory tõ maro roropa, tymõkomorykõ maro, Kanaã nonory pona ikurenaka. Jũ pary Ro imaro toytose. ");
INSERT INTO apyNT_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Itamurume tymõkomoke Aparã kynexine: pui tomo te, parata te, uuru, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Xiaxiake toytose ynororo eporehkatohme Peteu pona. Morotoino tosahpyry pona toytose ropa ynororo, irãnaka Peteu poe Ae pona. ");
INSERT INTO apyNT_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Toeporehkase Aparã tynyrihpyry pona, apoto apõme. Moroto Ritonõpo toahmase eya Tosẽme. ");
INSERT INTO apyNT_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ro, Aparã maro ytokety, tymõkomoke kynexine roropa. Tymaro kaneru tõ tarose eya, poti tomo te, pui tomo te, ipoetory tomo te, tytapyĩ taõkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Mame onahpoty ipune pyra toehse mokaro asakoro oximaro ahtao, ekykõ tuhke toehse exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Naeroro Aparã poetory tõ tõsetõsezuhse Ro poetory tõ maro. Morara ahtao kananeu tomo te, perizeu tõ roropa moroto ro toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Mame ynara tykase Aparã Ro a: — Oxiekyryme sytase. Zae pyra sytase kuakuatapoiryhtao, ypoetory tõ atatapoiry roropa opoetory tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Morara exiryke satapiakane. Omoro imenekako! Opozery wino oytory se awahtao, apotunuru wino ytõko ase; apotunuru wino oytoryhtao, ywy opozery wino ytõko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Mame Ro tõsenuhmase jakanahmã Joatão wino emero, tymenekase eya mya pata Zoa pona, tuna nae kynexine itamurume, Ritonõpo narykahpyry sã kynexine, Ejitu nonory sã roropa kynexine. Moro jakanahmã po pata tõ kynexine, Sotoma, Komora roropa, moro pata tõ onenahkapopyra ro Ritonõpo ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Moro jakanahmã Joatão emero tymenekase Ro a tosaryme. Mame toytose ynororo xixi tũtatoh winakoxi. Moro sã tãtapiakase mokaro asakorõkomo. ");
INSERT INTO apyNT_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Moroto Aparã kynexine Kanaã nonory po, mame Ro toytose osesarise pata tõ pona jakanahmã pona. Toytose ynororo osesarise ropa Sotoma pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Moroto ahno kynexine, popyra exiketomo. Tyyrypyry xihpyry poko toh kynexine. Ritonõpo zamaro pyra toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Moromeĩpo toytose Ro ahtao, ynara tykase Ritonõpo Aparã a: — Oesary poe osenuhmako mya inikahpozakoxi te, ikurenaka roropa te, xixi tũtatoh wino te, xixi omõtoh wino, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Sero nono emero onenehpyry ekarõko ase oya, apakomotyamo a roropa jũme oesarykõme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Apakomotyã rĩko ase tuhke, ekuhpỹme, isawã samo sero nono po. Isawã onukuhsaromepyra. Moro sã apakomotyã tuhke exiry onukuhsaromepyra exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Seromaroro ytoko sero nono poro porehme inikahpozakoxi, ikurenaka, osenuhmase, xixi tũtatoh wino xixi omõtoh wino roropa. Emero sero ekarõko ase oya. ");
INSERT INTO apyNT_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Morarame tãtakimase ropa Aparã ahtao toytose ynororo osesarise wewe kurã pũtokoxi Mãre pona, pata Eperõ pona. Moroto apoto apõ tyrise Aparã a, Ritonõpo eahmatopo. ");
INSERT INTO apyNT_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Morarame asakoropane tuisa tõ: Anarapeu, Sinaa tuisary, Arioke, Erasaa tuisary, Ketoaraomea, Erão tuisary, Titau, Koĩ tuisary, enara ");
INSERT INTO apyNT_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","toytose toto etonase imehnõ 5mãkõ tuisa tõ maro: Pera, Sotoma tuisaryme te; Pirisa, Komora tuisaryme te; Xinape, Atama tuisaryme te; Semepea, Zepoĩ tuisaryme te; Pera, Zoa tuisaryme, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Mokaro 5mãkõ tõximõse toto tysoutatu tõ maro jakanahmã Xitĩ po, tuna konõto Aorikyhpyry moroto kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Tuisa Ketoaraomea mokaro esẽme kynexine 12me jeimamyry. Yrome jeimamyry 13mã toehse ahtao, tutuisarykõme mokyro se pyra toehse toto. ");
INSERT INTO apyNT_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mame jeimamyry 14me ehtoh po imehnõ typoremãkapose Ketoaraomea tomo a takorehmananõ maro: repaĩ tomo, Axiterote-Karanaĩ po te, zuzĩ tõ Hã po te, emĩ tõ, Sawe-Kiriataĩ po te, ");
INSERT INTO apyNT_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","horeu tõ, Seia ypy tõ po, enara. Mokaro tokahmase eya xine, totapase toto osema ae Eu-Parã pona, ona ehpio pona, ahno esaka pyra. ");
INSERT INTO apyNT_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Morotoino toeramase ropa toto Kate pona (Morara ahtao Ẽ-Mixpate moro pata esety kynexine). Amarekita tõ porehme typoremãkase eya xine te, amoreu tõ, Hazazão-Tamara põkõ typoremãkase roropa eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Mame 5me tuisa tõ: Sotoma esemy, Komora esemy, Atama esemy, Zepoĩ esemy, Pera esẽ maro toytose toto tysoutatu tõ maro jakanahmã Sitĩ pona osetapase ");
INSERT INTO apyNT_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","mokaro 4mãkõ tuisa tõ maro: Erão esemy te, Koĩ esemy te, Sinaa esemy te, Erasaa esẽ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Moro jakanahmã Sitĩ tuhke eutary nae, azawa panõ eutary ao kynexine. Toepary se toehse toto ahtao toepukase toto eutary aka Sotoma esemy, Komora esemy, enara. Imehnõ tuisa tõ oseruao toepase ypy tõ pona. ");
INSERT INTO apyNT_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Mame toto mõkomory tapoise mokaro tuisa tõ 4mãkomo a, tonahsemy te, toto kyryry typyne exiketomo emero Sotoma põkõ kyryry te, Komora põkõ kyryry, mame toytose toto. ");
INSERT INTO apyNT_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ro, Aparã rui mũkuru moroto kynexine, Sotoma po. Naeroro tarose roropa ynororo eya xine typoetoryme, imõkomory maro, emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Yrome toiro orutua toepase. Toytose ynororo Aparã, epereu a zuruse emero. Aparã esary wewe kurã pũto kynexine, Mãre, amoreu esary pũto. Mãre tõ zakorõ tõ maro Exikou te, Anea maro Aparã epeme toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Mame zuaro toehse Aparã ahtao jũ pary, Ro arotopõpyry poko, oximõme typoetory tõ tykohmase tyya, amorepatyamo etonatoh poko, aenurutyamo itapyĩ tao. 318me toh kynexine atapona. Toto maro toytose Aparã mokaro 4mãkõ tuisa tõ ekahmase, pata Tã pona. ");
INSERT INTO apyNT_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Moroto typoetory tõ tapiakase Aparã a asakoro oximõmãkõ ehtohme. Koko tõsetapase toto topetõkara maro, typoremãkase toto Aparã a. Mame tokahmase roropa eya toto ryhmaryme Hopa pona, Tamaxiku poe inikahpozakoxi. ");
INSERT INTO apyNT_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Mame mõkomo tonehse ropa eya xine emero, epetõkara narohpyry. Tumy pary roropa, Ro tonehse ropa Aparã a, imõkomory maro, ipyxiamo, ipoetory tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Moromeĩpo Ketoaraomea tõ typoremãkapokehse Aparã a ahtao, aepyry ropa ahtao, tõsẽpatakãmase imaro Sotoma tuisary jakanahmã Sawe po, esety akorõ jakanahmã Tuisa esary. ");
INSERT INTO apyNT_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Mame Meukizeteke, Sarẽ tuisary, Ritonõpo Imehxo Exikety poe oturuketyme kynexine. Eya wyi tonehse, uwa eukuru jehnahpyry maro. ");
INSERT INTO apyNT_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Kure rokẽ Aparã tyripose Meukizeteke a, ynara tykase ynororo: — Kure rokẽ Aparã ripõko ase Ritonõpo Imehxo Exikety a, kapu Rihpõme nono roropa Rihpõme mã ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ritonõpo eahmatoko, Imehxo Exiketyme aexiryke, oepetõkara typoremãkapose eya, orẽpyra oriase. Mame mõkomo zokonaka tynenepyhpyry ropa tokarose Aparã a Meukizeteke a 10me aehtoh, toiro touse ekarotohme eya, akoĩpyry tõxinamase 9me kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Morarame ynara tykase Sotoma tuisary Aparã a: — Mõkomo apoiko emero omõkomoryme. Ahno rokẽ ekaroko ya tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Yrome Aparã a tozuhse ynororo: — Omõkomory se pyra ase. Amaro xine omõkomorykõ arotoko ropa porehme. Morara ãko ase Ritonõpo Imehxo Exikety netaryme, kapu Rihpõme nono roropa Rihpõme mã ynororo. Jemary anỹnõko ase zae jomiry enetupuhtohme oya. ");
INSERT INTO apyNT_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ajohpe pyra omõkomory anapoipyra ase ipunaka. Upo eary rokẽ ahtao ro, sãtaja myhtoh roropa anapoipyra ase: “Ypoe Aparã tymõkomoke toehse” karyino imehnomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Epehpyry se pyra ase ykyryryme. Tonahsẽ rokẽ ekaroko ypoetory tõ napyryme. Yrome jakorehmananõ Anea te, Exikou te, Mãre maro, moxiamo a omõkomorykõ apiakako apiakary se awahtao xine, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Moromeĩpo tõsenepose Ritonõpo Aparã a, ynara tykase ynororo eya: — Aparã, enaromyra exiko. Oewomãko ase oryhmara oepetõkara ehtohme, kurã ke rokẽ oepehmãko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Aparã a tozuhse, ynara tykase: — Ritonõpo, Jesemy! Otyme kure onekarory kurã ya, tumũkue pyra ase. Erieze rokẽ ynamoto Tamaxiku pono, mokyro rokẽ mã ymõkomohpyry esẽme exĩko toorihse jahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Umũkuru onekaropyra ro mase ya. Naeroro ypoetory rokẽ, ytapyĩ tao aenuruhpyry ymyakãme exĩko ymõkomory esẽme. ");
INSERT INTO apyNT_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Mame ynara tykase ropa Ritonõpo eya: — Omũkuru nymyry mã omyakãme exĩko omõkomohpyry esẽme, mokyro opoetory Erieze kara. ");
INSERT INTO apyNT_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Mame itapyĩ tae Aparã tarose Ritonõpo a jarãnaka, ynara tykase eya: — Kapu eneko xirikuato ikuhko tuhke exiry waro oehtohme. Moro sã apakomotyã tuhke emãnõko mana, ekuhpỹme exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Mame zae Ritonõpo omiry ehtoh tonetupuhse Aparã a. Naeroro Ritonõpo zamaro Aparã kynexine, zae Aparã tokarose eya. ");
INSERT INTO apyNT_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ynara tykase roropa Ritonõpo eya: — Ywy ase Ritonõpo Oesemy. Kuenehne Papironia nonory poe, pata Ua poe xiaro, sero nono ekarotohme oya, ononoryme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","— Ritonõpo Jesemy! tykase Aparã. — Otãto zuaro exĩko ywy, sero nono esẽme jexiry poko? ");
INSERT INTO apyNT_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ynara tykase Ritonõpo: — Pui nohpo enehta xiaro, poti maro te, kaneru maro, emero oseruao jeimamyry pune exiketomo. Enehta roropa toiro utukuimo te, toiro utuku roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Mame mokaro okyno tõ tonehse Aparã a tynekaroryme Ritonõpo a. Mame mokaro tyrakase toto eya. Irakahpyry tõ tyrise eya ososẽpataka asakoro atakenaka, yrome torõ tõ onysahkara kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Mame kurumu tõ tyhtose okyno ekepyry pona repe, yrome torehse toto Aparã a. ");
INSERT INTO apyNT_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mame kohmãsasaka ahtao, Aparã tynyhse tyrõnaka. Mõtoino rokẽ tõserehse ynororo, enaromỹke toehse, tykytyky tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Mame ynara tykase Ritonõpo eya: — Tuaro exiko, apakomotyã mã katonõme exĩko imehnõ nonory po. Moroto topehke pyra erohnõko mã toto imehnõ poetoryme. Toto ryhmãko mã toto 400me jeimamyry pona. ");
INSERT INTO apyNT_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Yrome mokaro apakomotyã ryhmahpõkõ wãnohnõko ase, toto tyrohmanohpose eya xine exiryke topehke pyra. Mame apakomotyã moro nono poe oehnõko ropa mã toto tymõkomoke, pitiko rokẽ pyra. ");
INSERT INTO apyNT_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mame tamuhpõme awahtao kure rokẽ orĩko ase. Torẽtyke pyra orihnõko mase. Oekepyry zonẽnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Moromeĩpo 400me jeimamyry taropose ahtao apakomotyã mã oehnõko ropa xiaro; mokaro amoreu tõ anaropopyra ase aporo, iirypyryme toehse toto ahtao rokẽ ipunaka, toto wãnohnõko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Mame tykohmãse rahkene, xinukutume toehse koko. Mõtoino rokẽ apoto ẽ tõsenepose orexĩto maro te, apoto maro. Moro apoto toytose moro okyno tõ, irakahpyry tõ rãnakuroko. ");
INSERT INTO apyNT_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Morara toehse ahtao tõmiry totapose Ritonõpo a Aparã a, ynara tykase eya: — Ajohpe pyra, jomihpyry ae ro sero nono ekarõko ase apakomotyamo a, Ejitu ehpio poe tuna Eupyrati pona, ");
INSERT INTO apyNT_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","keneu tõ nonory maro te, kenezeu tõ nonory maro, katamoneu tõ nonory maro te, ");
INSERT INTO apyNT_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","heteu tõ nonory maro, perizeu tõ nonory maro te, repaĩ tõ nonory maro, ");
INSERT INTO apyNT_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amoreu tõ nonory maro te, kananeu tõ nonory maro, kirikaseu tõ nonory maro te, jepuseu tõ nonory maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Morarame Aparã pyty, Sarai emũkuara ro kynexine. Tynamotoke kynexine ynororo, nohpo, Ejitu pono, topehke pyra erohketyme itapyĩ tao, esety Akara. ");
INSERT INTO apyNT_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Mame ynara tykase Sarai tynio, Aparã a: — Umũkuru onekaropyra Ritonõpo ya tokurehse. Naeroro ypoetory maro exiko. Otarame mose ae tumũkue exĩko ase, tykase. Aparã ỹme kynexine Sarai omiry tymoise eya, ");
INSERT INTO apyNT_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","mame typoetory tokarose Sarai a, tynio a ipytyme ehtohme. Morara toehse 10me jeimamyry taropose ahtao Aparã a Kanaã nonory po. ");
INSERT INTO apyNT_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Akara maro toehse Aparã, poetoẽme toehse nohpo. Mame poetoẽme toexiry waro toehse Akara ahtao, tosẽ Sarai tyhtomapitose eya. ");
INSERT INTO apyNT_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Naeroro ynara tykase Sarai tynio a: — Onyrihpyry pokoino jyhtomãko Akara nase. Ywy roro mose ekaroase oya ipoko oehtohme repe; seromaroro poetoẽme toehse toexiryke ymotye kure osekarõko nase, jyhtomãko. Naeroro Ritonõpo a kuapiakary se ase onoky tyyrypyhpyke: ywy, omoro? ");
INSERT INTO apyNT_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","— Kure, tykase Aparã. — Opoetoryme Akara mana, ituisaryme mase. Tyriry se oehtoh tyriko ipoko. Morara exiryke yronymyryme typoetory tyrohmanohpose Sarai a, ajoajohpã samo. Naeroro tosẽ tapyĩ tae toepase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Yrome Ritonõpo nenyokyhpyry tõsenepose eya, ona po, tuna eutary pũto osema tao Sua po, ");
INSERT INTO apyNT_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","tõturupose ynororo eya: — Akara, Sarai poetory, ozeino moehno? Aza ytõko mah? — Jesẽ winoino epãko ase, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mame ynara tykase Ritonõpo nenyokyhpyry eya: — Ytoko ropa oesemy a. Aomipona exiko emero poko. ");
INSERT INTO apyNT_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ynara tykase roropa Ritonõpo nenyokyhpyry eya: — Ypoe, apakomotyã tuhke exĩko, ekuhpỹme tuhke toto exiry exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Poetoẽme mase. Emũkuãko mase omũkurume. Mokyro esehpãko mase Iximaeume, oxitary, oetuarimary, totase Ritonõpo a exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mokyro omũkuru, jumẽtu tosẽke pyra exikety sã exĩko mana; etonãko mana imehnõ maro emero porehme, imehnõ mã emero etonãko roropa imaro. Morararo esary moe exĩko mana, ameke exĩko mana tyekyry tomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Mame tyorõme Ritonõpo tosehpase Akara a: “Mã jeneneme Ritonõpo”. Ynara exiryke imaro tõturuse Ritonõpo nenyokyhpyry, tõturupose roropa ynororo tyya rokene: “Ajohpe pyra nae, Mokyro eneno, Jeneneme?” tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Morara exiryke moro tuna eutary irãnao Kate poe Perete pona tosehpase “Isene Exikety tuna eutary, Jeneneme” tosehpase eya. ");
INSERT INTO apyNT_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Mame Akara toemũkuase Aparã mũkurume. Tosehpase ynororo eya Iximaeume. ");
INSERT INTO apyNT_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","86me jeimamyry Aparã nae kynexine, tonuruse Iximaeu ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Morarame 99me jeimamyry taropose Aparã ahtao tõsenepose ropa Ritonõpo eya, ynara tykase ynororo eya: — Ywy ase Ritonõpo Jamihmehxo Exikety. Jomiry omipona exiko, zae ehtoh poko rokẽ exiko roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Jomiry etapõko ase oya, tuhke apakõ ekarõko ase oya. ");
INSERT INTO apyNT_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Mame tosekumuru po typorohse Aparã Ritonõpo ẽpataka, tõmyty roropa tyrise nono pokoxi. Mame ynara tykase Ritonõpo eya: ");
INSERT INTO apyNT_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","— Jomiry etapõko ase oya: Ajohpe pyra, ahno imoihmãkõ tamurume orĩko ase, tuhke tyotyorõkõ tamurume exĩko mase. ");
INSERT INTO apyNT_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Taroino oesety Aparãome exĩko, Aparã kara, tuhkãkõ tamurume oriryke ya. ");
INSERT INTO apyNT_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Apakõ emãkapõko ase imoihme toto ehtohme, toitoine tuisamehxo exĩko roropa mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ynara mã jomiry oya, opoenomo a, apakomotyamo a roropa, jũme etyorõmara mana: jũme ywy, Ritonõpo Oesẽkõme exĩko ase apakomotyã Esẽme roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Sero nono ekarõko ase oya, apakomotyamo a roropa. Seromaroro katonõme rokẽ matose taro. Sero nono Kanaã emero ekarõko ase jũme apakomotyã esaryme ehtohme, mame ywy toto Esẽme exĩko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ynara tykase ropa Ritonõpo eya: — Omoro Aparão ỹme exĩko mase Jomihpyry omipona, omoro, apakomotyã roropa, ỹme exĩko matose jũme. ");
INSERT INTO apyNT_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Sero jomiry omipona oehtohkõme, apakomotyã maro, ynara tyrĩko matose: Orutua kõ emero, amarokõ aipotapihpyry tysahkasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Moro aipotapihpyry sahkary enetupuhtohme exĩko mana jomipona oexirykõ ehtoh poko. ");
INSERT INTO apyNT_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Taroino opoenõkõ aipotapihpyry isahkatoko, enurusenã, 8me ẽmepyry taropose ahtao aipotapihpyry isahkatoko. Opoetory poenõ tonuruse ahtao isahkatoko roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Mokaro aipotapihpyry tysahkasẽme exĩko mana emero. Moro enetupuhtohme exĩko õkokõ poko jũme jomihpyry ehtoh poko. ");
INSERT INTO apyNT_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Orutua aipotapihpyry onysahkara ahtao ypoetoryme pyra exĩko mana, amaro xine ehsaromepyra mana jomihpyry omipona pyra toehse exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Moromeĩpo ynara tykase Ritonõpo Aparão a: — Taroino opyty esety Saraime pyra mana. Sarame esehpãko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Kure rokẽ opyty rĩko ase. Tumũkue orĩko ase, opyty Sara mũkurume. Kure rokẽ mose rĩko ase, tuhkãkõ ẽme exĩko mana imehnõ ahno tõ ẽme, tuisa tõ ẽme roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Tosekumuru po typorohse Aparão tõmyty po nono pokoxi roropa eya Ritonõpo ẽpataka. Toexianapitose ynororo moro poko tõsenetuputyry ke: — Orutua emũkuasaromepyra 100me jeimamyry nae ahtao. Sara roropa emũkuasaromepyra mana 90me jeimamyry nae ahtao? ");
INSERT INTO apyNT_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ynara tykase Aparão Ritonõpo a: — Kure rokẽ Iximaeu tyriko, ymyakãme ehtohme, emãtohme roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Yrome Ritonõpo a tozuhse ynororo, ynara tykase: — Arypyra, opyty Sara emũkuãko mana. Mokyro esehpãko mase Izakeme. Jomihpyry, ynekarohpyry oya ekarõko ase roropa eya ipakomotyamo a roropa, jũme. ");
INSERT INTO apyNT_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Õmiry roropa Iximaeu poko etano; kure rokẽ mokyro rĩko ase roropa, tuhke tumũkue exĩko mana, tuhke typakõke roropa. 12me tuisamãkõ zũme exĩko mã ynororo, mame ipakomotyã ahno imoihme exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Yrome jomiry etapõko ase omũkuru, Izake a. Taroino toiro jeimamyry Sara emũkuãko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mame tõturukehse Ritonõpo ahtao Aparão maro tõnuhse ropa ynororo. Aparão tynomose eya. ");
INSERT INTO apyNT_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Mame moro ae ro Ritonõpo nyripohpyry tyrise Aparão a. Tumũkuru, Iximaeu aipotapihpyry tysahkase eya, orutua kõ emero tytapyĩ taõkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","99me jeimamyry Aparão nae kynexine aĩpotapihpyry tysahkase ahtao, ");
INSERT INTO apyNT_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","imũkuru, Iximaeu 13me jeimamyry nae kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Mororo ae ro, mokaro asakoro aĩkõpotapihpyry tysahkase. ");
INSERT INTO apyNT_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Morararo emero Aparão poetory tõ aipotapihpyry tysahkase itapyĩ tao aenurutyamo te, imehnõ patary poe epekahtyã maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Morarame tõsenepose Ritonõpo Aparão a wewe kurã zopino, pata Mãre po. Moroto xixi jetũ ahtao Aparão typorohse tytapyĩ pota tao. ");
INSERT INTO apyNT_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Mame tõsenuhmase ynororo. Oseruao orutua kõ tonese eya xikihme osema tao. Toto eneryhtao tururume toytose ynororo toto ẽpatakãmase. Tosekumuru po typorohse ynororo, tõmyty po nono pona toto ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ynara tykase ynororo: — Moehtou? Ajohpãme sã ehmaropa ytapyĩ taka oseremase pitiko. ");
INSERT INTO apyNT_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Tuna enehpõko ase opupurukõ kurikatohme. Moromeĩpo oseremãko matose taro wewe zopino. ");
INSERT INTO apyNT_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tonahsẽ pixo enehnõko ase. Mame ẽtaikaxĩpo, jamihmehxo ytõko ropa matose. Jãkyemãko matose tooehse tarona oexirykõke. Anapyrykõ pixo enehtã aporo, tykase. — Kure, tykase toto, — ẽtaikãko ynanase amaro, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Axĩ toytose Aparão tapyi taka Sara zuruse: — Axĩ ke tiriiku apoiko kurano wyi ritohme axitunety. ");
INSERT INTO apyNT_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Moromeĩpo tururume toytose ynororo pui tõ esaka, pui mũkuru kurã menekase. Mokyro tokarose eya typoetory a etapatohme te, ipurutohme, tõsẽme. ");
INSERT INTO apyNT_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Mame pui suhsuru akyhsemy tapoise Aparão a pui suhsuru roropa te tõsẽ maro. Morohne typorohkase eya toto napyryme. Moroto, wewe zopino moro tonahsẽ tokarose eya toto otuhtohme, toto enẽko kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Mame tõturupose ynaroro: — Otoko na Sara, opyty? — Tapyi tao, tykase Aparão. ");
INSERT INTO apyNT_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Toiro orutua ynara tykase: — Taroino toiro jeimamyry taropose ahtao oenese oehnõko ropa ase. Morara ahtao opyty Sara emũkuãko mana, tykase. Sara tapyi tao kynexine toto mykae, tapyi pota tao, toto omiry etãko. ");
INSERT INTO apyNT_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Aparão tamuhpõme kynexine, Sara kunumuxime roropa, pake tumũkehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Naeroro toto omiry etaryhtao tyya toexianase tukurohtao, tounohse toto eya: — Nary! Emũkuapỹme toehse ase ipunaka. Ypoko pyra roropa ynio toehse mana tamuhpõme toexiryke, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Mame ynara tykase Ritonõpo Aparão a: — Oty katohme jomiry eunohnõko opyty nahe? “Emũkuapỹme ase ipunaka, kunumuxime,” ãko oty katohme? ");
INSERT INTO apyNT_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Oty tupime nae Ritonõpo a? Arypyra, emero tupime pyra ya. Naeroro morara ykano: “Taroino jeimamyry taropose ahtao oehnõko ropa ase. Mame morara ahtao Sara emũkuãko mana.” ");
INSERT INTO apyNT_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Moro etaryke tyya, ihxipỹke toehse ynororo, ynara tykase: — Õmiry oneunohpyra akene, exianara akene. Yrome ynara tykase Ritonõpo: — Arypyra, ajohpe pyra jomiry meunohno; mexianano. ");
INSERT INTO apyNT_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Morarame toytose toto orutua komo Sotoma osenetoh pona. Toto maro toytose Aparão toto esemary ae toto aropotohme. ");
INSERT INTO apyNT_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mame ynara tykase Ritonõpo tyya rokene: “Josenetupuhtoh ononẽpyra ase Aparão wino. Ynyriry poko zurũko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ipakomotyã mã imoihme exĩko mã toto, ahno imehxo exĩko mã toto. Mose pokoino kure rokẽ imehnõ ahno rĩko ase, emero. ");
INSERT INTO apyNT_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Mose tymenekase ya jomiry omipona typoenõ ripotohme, typakomotyã roropa jomipona ripotohme, zae toto ehtohme. Morara toto ahtao, zae rokẽ ehtoh riryhtao eya xine, jomihpyry ae ro kure rokẽ mose rĩko ase.” ");
INSERT INTO apyNT_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Mame ynara tykase Ritonõpo Aparão a: — Iirypyryme xihpyryme Sotoma põkõ toehse, Komora põkõ roropa, ãko mã imehnomo toto poko. ");
INSERT INTO apyNT_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Naeroro morotona ytõko ase toto enese, ajohpe pyra toto ekãtotoh waro jehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Mame asakoro mokaro toytose Sotoma pata esemary ae. Yrome Ritonõpo maro ro Aparão kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ameke pyra toehse Aparão eya tõturupotohme. — Yrome ahno kurãkõ nae ahtao Sotoma po, mokaro wãnohnõko mah popyra exiketõ mahro? ");
INSERT INTO apyNT_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Otarame 50me ahno kurã nae moro pata po ahtao, morara ahtao pata enahkapõko mah? Pata onypynanohpyra hma mokaro kurãkõ 50mãkõ moroto ahtao? ");
INSERT INTO apyNT_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ahno kurã onetapasaromepyra mase pohnõ maro, iirypyryme pyra toto ahtao. Morara onyripyra exiko. Omoro rokẽ zae sero nono põkõ apiakaneme mase. Zae rokẽ ahno apiakãko mase. ");
INSERT INTO apyNT_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ynara tykase Ritonõpo eya: — 50me ahno kurã eneryhtao ya Sotoma po, moro pata pynanohnõko ase tytororo mokaro pokoino, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Mame Aparão ynara tykase ropa: — Ajohpãme sã yzehno pyra exiko jomiry poko. Omoro mase Ritonõpo, ywy ase ahnome rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Otarame 45me rokẽ kurãkõ nae ahtao, pata enahkãko ma 5me pyra ahtao 50me ehtohme? Tozuhse ropa Ritonõpo a: — 45me kurãkõ eneryhtao ya pata onenahkara ase. ");
INSERT INTO apyNT_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Mame Aparão tõturupose ropa mya roropa eya: — 40me rokẽ kurãkõ nae ahtao, otara exĩko? tykase. — Mokaro 40mãkõ, kurãkõ pyno jexiryke morotõkõ onenahkara ase, tykase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Mame ynara tykase Aparão: — Yzehno pyra exiko, Ritonõpo, ajohpãme samo ynara karyhtao, 30me kurãkõ nae ahtao, otara exĩko? toto enahkapõko mah? Ynara tykase Ritonõpo eya: — 30me nae ahtao pata põkõ pynanohnõko ase. Iirypyrykõ korokãko ase, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ynara tykase Aparão: — Ehxirõko ase, yrome zae pyra jahtao yyrypyry ikorokako: 20me rokẽ kurãkõ ahtao otara ãko mah moro põkõ enahkãko ro mahno? — Mokaro 20mãkõ pyno jexiryke pata põkõ onenahkara ase, tykase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Etyhpyryme ynara tykase Aparão: — Ajohpãme sã yzehno pyra exiko ynara ekaroporyhtao etyhpyryme rahkene. Otarame 10me rokẽ kurãkõ enẽko mase moroto, tykase. — Mokaro 10mãkõ pokoino moro pata põkõ onenahkara ase, tykase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mame tõturukehse Ritonõpo ahtao Aparão maro toytose ynororo. Aparão toytose ropa tytapyĩ taka. ");
INSERT INTO apyNT_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Morarame kohmãnõko kynexine, mokaro Ritonõpo nenyohtyã asakoro toeporehkase ahtao Sotoma pona. Typorohse Ro kynexine pata omõtoh pũto. Mame mokaro Ritonõpo nenyohtyã tonese tyya ahtao towõse ynororo toto omikase. Tosekumuru po typorohse ynororo toto ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ynara tykase ynororo eya xine: — Moehtou? Taro ase ãkorehmatohkõme. Ajohpãme sã ehmaropa ytapyĩ taka. Moroto opupurukõ kurikãko matose oytotohkõme ropa. — Arypyra, tykase toto, jarãnao, pata rãnao ẽmehnõko ynanase, tykase toto eya. ");
INSERT INTO apyNT_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Yrome otuhparo Ro exiryke tymoise eya xine. Imaro toytose toto Ro tapyĩ taka. Mame otuhtoh tyripose Ro a wyi ekeisenã maro. Tõtuhse toto. ");
INSERT INTO apyNT_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Yrome ataxikara ro mokaro ahtao, Sotoma põkõ, emero orutua kõ tooehse poetohtimãkomo, tamuhpomãkõ maro, Ro tapyĩ tapurupose eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ro tykohmase eya xine: — Otoko toh nae mokaro orutua komo, amaro exiketomo? Toto enehko xiaro jarãnaka. Mokaro poko se ynanase, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Tytapyĩ tae tutũtase Ro, orutua kõ zurutohme. Kure omõtoh tapuruse eya, ynara tykase: ");
INSERT INTO apyNT_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","— Jepe tomo, ajohpãme sã morohne xihpyry poko pyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Etatoko pahne, asakoro tõxike ase, orutua poko exipitopyra exiketomo. Toto enehnõko ase jarãnaka oya xine. Jẽxiry tõ poko ehtoko ise awahtao xine. Yrome mokaro orutua kõ poko pyra ehtoko. Tooehse toto ytapyĩ taka ẽmehtohme, naeroro toto ewomãko ase toto onyryhmara imehnõ ehtohme, tykase Ro. ");
INSERT INTO apyNT_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Yrome tozuhse ynororo eya xine: — Ytoko taroino, yna wapo pyra exiko! Oseya ynara tykase toto: — Imepỹ nono poe aepyhpyry mose ro. Tõmipona kyrirykõ se ynororo tuisame exikety samo! Oty katohme? Mame toeramase toto Ro a ynara katohme: — Seromaroro mokaro oepe tõ ryhmary se yna ehtopõpyry motye oryhmãko ynanase. Ro tupurohmase Sotoma põkomo a. Toeporehkase toto tapyi omõtoh pona tapyi etapuruhmakatohme repe, omõtohme repe. ");
INSERT INTO apyNT_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Yrome mokaro a Ro tapoise asakoro aehtyamo a, tytywyhmase tapyi taka. Mame omõtoh tapuruse eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Morarame jarãnao exiketõ emero tonukehkapose toto omõtoh onenepyra toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mame ynara tykase mokaro asakorõkõ Ro a: — Oekyry tõ imehnõ nae hma taro? Omũkuru tõ aroko te, oẽxiry tõ maro te, oẽxiry tõ nio tõ maro te, imehnõ oekyry tõ maro, toto arotohme emero sero pata poe. ");
INSERT INTO apyNT_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ynara exiryke: sero pata põkõ enahkãko Ritonõpo mana. Sero pata põkõ ehtoh xihpyry poko totase eya. Naeroro yna tonehpose eya Sotoma enahkatohme. ");
INSERT INTO apyNT_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Mame Ro tutũtase oturutohme typaniry tõ maro. Ẽxiry tõ eraximãko toh kynexine pytatohme repe toto maro. Ynara tykase ynororo eya xine: — Atakimatoko axiny sero rumekatohme. Sero pata enahkãko Ritonõpo mana! Yrome Ro atahmãkaryme rokẽ tokarose eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mame ẽmehsasaka ahtao atarypõko Ritonõpo nenyohtyã kynexine. Ynara tykase toto Ro a: — Axiny! tykase toto. — Opyty aroko, oẽxiry tõ aroko amaro asakoro ro. Axĩ ke ytotoko taroino, oorikyrykõino pata enahkaryhtao. ");
INSERT INTO apyNT_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mame axĩ pyra Ro exiryke emary tapoise Ritonõpo nenyohtyamo a, Ro te, ipyty te, ẽxiry tõ maro. Tarose toto pata poe Ro pynanopyry se Ritonõpo exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Mame toiro Ritonõpo nenyokyhpyry ynara tykase Ro a: — Seromaroro tururume ytoko õsepynanohtohme! Õkakoxi xine osenuhmara ehtoko. Sero jakanahmã wino roropa osenuhmara ehtoko. Epatoko ypy pona; epara awahtao xine orihnõko matose. ");
INSERT INTO apyNT_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Yrome tozuhse ynororo Ro a: — Tuisa, morara jyripopyra exiko, ajohpãme samo! ");
INSERT INTO apyNT_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Kure make ya seroae. Typynanohse ywy oya orihpyra jehtohme. Yrome moro ypy moe mana, eporehkara ro jahtao yyryhmatoh jetapãko nase. ");
INSERT INTO apyNT_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Moroto pata pitiko enẽko mah? Moe hkopyra mana morotona epatohme. Ytoxi morotona osepynanohtohme. Enẽko mah? Pata pitiko nase. ");
INSERT INTO apyNT_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mame ynara tykase Ritonõpo nenyokyhpyry eya: — Ỹ, kure mana. Moro pata onenahkara ase. ");
INSERT INTO apyNT_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Axĩ ke ytoko tururume. Onenahkapopyra ase eporehkara ro awahtao xine morotona. Moro “pata pitiko” tykase Ro exiryke, esety Zoame toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Xixi tõnuhse pixo ahtao, Ro toeporehkase Zoa pona. ");
INSERT INTO apyNT_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Mame mõtoino rokẽ apoto tonehpose Ritonõpo a konopo samo, sautu panõ orihmatõ maro kapu ae pata Sotoma pona, Komora maro. ");
INSERT INTO apyNT_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Moro pata tõ asakoro tonahkase Ritonõpo a jakanahmã maro, moro põkõ maro, otyro tõkehko maro, wewe tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ynara toehse roropa, tỹkakoxi tõsenuhmase Ro pyty ahtao sautume, xikihme exiketyme toeramase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Yrokokoro towõse Aparão, pakeimo. Toytose ynororo tõturutopõpyry pona Ritonõpo maro. ");
INSERT INTO apyNT_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Tõsenuhmase ynororo Sotoma wino te, Komora wino roropa jakanahmã pona roropa. Orexĩto konõto tonese eya onuhnõko nono poe, apoto konõto erexĩtory samo. ");
INSERT INTO apyNT_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Moro sã pata tõ tonahkase Ritonõpo a jakanahmã po. Mame tõsenetupuhse roropa ynororo Aparão poko. Naeroro Ro takorehmase eya epatohme, orihpyra aehtohme ipatary tonahkase ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Mame Zoa po Ro ahtao enaromỹke toehse ynororo. Naeroro ypy tõ pona toytose ynororo tõxiry tõ maro. Moroto tõsesarise toto oramao, asakorõkõ tõxiry maro. ");
INSERT INTO apyNT_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mame ẽxiry apitorymã ynara tykase takorony a: — Papa tamuhpõme toehse. Imepỹ orutua pyra roropa taro. Morara exiryke niotasaromepyra sytase. Emũkuasaromepyra sytase, imehnõ saaro emero nono po. ");
INSERT INTO apyNT_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Eropa papa sauhpane aetỹtohme. Mame toetỹse ahtao imaro exĩko sytase, emũkuatohme imũkurume. ");
INSERT INTO apyNT_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Naeroro moro kohmamyry ae eukuru tokarose eya xine tumykomo a. Mame ẽxiry osemazupu tumy maro toehse. Yrome toetỹse exiryke tuaro pyra kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Yrokokoro ynara tykase ẽxiry apitorymã takorony a: — Kokonie papa maro akene. Seroae sauhpane ropa etỹtohme ropa, imaro oehtohme koko. Morarame emũkuãko sytase typakõke papa ehtohme, tykase ynaroro. ");
INSERT INTO apyNT_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Mame tykohmãse ahtao eukuru tokarose ropa, tumykõ tauhpase ropa. Mame ẽxiry etyhpyrymano tumy maro toehse. Yrome tuaro pyra ynororo kynexine toetỹse exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Morara exiryke ẽxiry tõ asakoro poetoẽme toehse tumykõ mũkuru ẽme. ");
INSERT INTO apyNT_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mokyro ẽxiry apitorymã toemũkuase Moapeme. Moape tõ tamurume toehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mokyro Ro ẽxiry etyhpyrymã roropa toemũkuase orutuame, tumũkuru tosehpase eya Pẽ-Amime. Amonita tõ tamurume toehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Mame Aparão toytose Mãre poe ikurenaka Kanaã nonory poro. Tõsesarise ynororo irãnao pata Kate poe pata Sua pona. Moromeĩpo Jeraa po tõsesarise Aparão ahtao, ");
INSERT INTO apyNT_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","toryxiryme Sara tokarose eya. Mame Sara tonehpose Apimereke, Jeraa tuisary a tytapyĩ konõto taka. ");
INSERT INTO apyNT_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Yrome koko tõsenepose Ritonõpo Apimereke a aosenety. Ynara tykase ynororo eya: — Oorikyry ke awãnohnõko ase, mokyro nohpo onenepyhpyry pokoino atapyĩ taka, imepỹ pytyme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mokyro Apimereke Sara poko pyra ro kynexine. Naeroro ynara tykase ynororo: — Ritonõpo, mokyro poko pyra akene! Yna enahkãko mah ypatary põkõ maro? ");
INSERT INTO apyNT_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Mokyro ro, Aparão morara tykase: “Woryxiry mose ro, Sara,” tykase ynororo. Morara tykase roropa nohpo. Zae rokẽ se exiase. Imepỹ pyty apoiry se pyra akene ipunaka, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Aosenety ynara tykase sã Ritonõpo eya: — Zuaro ase, ajoajohpe se pyra mexiase. Morara exiryke iirypyryme pyra oehtohme yneneryme, nohpo towomase ya ipoko pyra oehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Seromaroro nohpo ekaroko ropa inio a. Morararo urutõme aexiryke oturũko ya mana opoko orihpyra oehtohme. Yrome nohpo onekaropyra ropa awahtao ourũko ase, orihnõko mase rahkene oekyry tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Yrokokoro towõse ropa Apimereke pakeimo. Typoetory tõ tykohmase tyya osekarotohme eya xine. Enaromỹke toehse toto itamurume. ");
INSERT INTO apyNT_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Moromeĩpo Aparão tykohmase Apimereke a. Ynara tykase ynororo eya: — Oty myri yna a? Oty popyra yrino oya? Opokoino yna wãnohsasaka Ritonõpo toehse, iirypyryme ehtoh poko exisasaka toehse jexiryke. Moro sã tyriry popyra mana ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Oty katoh sẽ poko mosenetupuhno sẽ sã tyritohme ypohko? tykase ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ynara tykase Aparão eya: — Sero nono põkõ Ritonõpo omipona pyra emero ekaroase repe, jetapãko mã toto ypyty apoitohme typytyme, ekaroase repe. ");
INSERT INTO apyNT_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ajohpe pyra ro mana, woryxiryme Sara mana, papa ẽxihpyryme exiryke, aja ẽxiryme pyra rokene. Naeroro tapoise ya ypytyme. ");
INSERT INTO apyNT_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mame papa tapyĩ tae taropose jahtao Ritonõpo a imehnõ nonory poro jytotohme, ynara ase Sara a: “Imehnõ nonory po kuahtao, woryxiryme osekaroko jewomatohme,” ase eya. ");
INSERT INTO apyNT_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Mame Sara tokarose ropa Apimereke a Aparão a. Imaro kaneru tõ tokarose eya pui tõ maro te, orutua komo te, nohpo tõ maro ipoetoryme. ");
INSERT INTO apyNT_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ynara tykase ynororo eya: — Eneko ke, Aparão, sero ynonoryme mana emero. Ise oehtoh imenekako oesaryme. ");
INSERT INTO apyNT_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Mame ynara tykase Apimereke Sara a: — Parata ekarõko ase opiry a, 11me kiru zokonaka zuaro imehnõ amaro xine exiketõ ehtohme zae oehtoh poko. Ynara zuaro exĩko mã toto azahkuru pyra mexiase ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Morara toehse Sara exiryke, Aparão pyty, tyrohsẽ tonehpose Ritonõpo a Apimereke tapyĩ taõkõ pona. Nohpo tõ emero emũkuasaromepyra tyripose toto Ritonõpo a. Mame Aparão tõturuse Ritonõpo a Apimereke tõ poko, tukurãkase ropa toto Ritonõpo a, Apimereke te, ipyty te, ipoetory tõ maro emero, toto emũkuatohme ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mame tõmihpyry ae ro kure rokẽ Sara tyrise Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Poetoẽme toehse ynororo. Mame tamuhpõme Aparão toehse ahtao toemũkuase ynororo. Morara toehse aenurutoh po, Ritonõpo omihpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Tumũkuru tosehpase Aparão a Izakeme. ");
INSERT INTO apyNT_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Mame 8me ẽmepyry taropose ahtao tumũkuru aĩpotapihpyry tysahkase Aparão a, Ritonõpo omihpyry omi poe. ");
INSERT INTO apyNT_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","100me jeimamyry Aparão nae kynexine, Izake tonuruse ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Morarame ynara tykase Sara: — Ritonõpo nekarohpyry poko tãkye toehse ywy. Exianãko ase. Moro poko etaryhtao imehnomo a ymaro exianãko roropa mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ynara tykase roropa ynororo: — Morara kasaromepyra imehnõ nexiase Aparão a: “Opyty emũkuãko mana. Suhsu ekarõko roropa mana omũkuru a. Mame tamuhpõme toehse ynororo ahtao emũkuase rahkene, imũkurume.” ");
INSERT INTO apyNT_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mame tuãtase aimo pitiko. Mame suhsu tõkehse eya ahtao otuhtoh konõto tyrise Aparão a. ");
INSERT INTO apyNT_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Morarame Iximaeu, Akara mũkuru osemeikãko kynexine Izake maro, Sara mũkuru maro. ");
INSERT INTO apyNT_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Mokaro eneryke tyya ynara tykase Sara Aparão a: — Mose ypoetory aropoko ywinoino imũkuru maro. Ypoetory mũkuru omõkomohpyry anapiakara mana umũkuru Izake maro. ");
INSERT INTO apyNT_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Torẽtyke toehse Aparão morara kary etaryke tyya, Iximaeu tumũkurume roropa exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Yrome ynara tykase Ritonõpo eya: — Aparão, torẽtyke pyra exiko poeto poko, opoetory Akara poko roropa. Tyriko emero, Sara omi poe. Typakõke exĩko mase Izake poenõ ke. ");
INSERT INTO apyNT_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Opoetory mũkuru omũkurume roropa mana. Naeroro ipakomotyã roropa ripõko ase imoihmãkõme. ");
INSERT INTO apyNT_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Yrokokoro towõse Aparão pakeimo. Tonahsẽ tapoise eya tuna maro ẽ ao, eukuru. Morohne tokarose eya Akara a poeto maro. Mame taropose ynororo eya mya aytotohme. Akara toytose. Xiaxiake toytose ynororo ona poro ahno esary poro pyra Peresepa nonory poro. ");
INSERT INTO apyNT_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mame tuna tonahse ahtao, tumũkuru tynomose eya wewe zopino. ");
INSERT INTO apyNT_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Myahme sã pitiko 100 meturume toytose nohpo porohse nono pona. Tõsenetupuhse ynororo “Umũkuru orikyry enery se pyra ase”. Toraximase sokohme moroto. Imũkuru tyxitase. ");
INSERT INTO apyNT_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mame poeto xitary totase Ritonõpo a. Kapu ae tõturuse Akara a Ritonõpo nenyokyhpyry, ynara tykase ynororo: — Oty poko torẽtyke mahno? Enaromyra exiko, poeto xitary totase Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Eropa! Poeto anỹko xikihme, emary apoiko, ipoenõ rĩko ase imoihme, tykase ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Mame pimỹme pyra Akara enuru tyripose Ritonõpo a, tuna eutary tonese eya. Toytose ynororo, tuna ẽ typehkase eya, tuna ke tumũkuru Iximaeu tauhpase eya. ");
INSERT INTO apyNT_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Towomase Iximaeu Ritonõpo a, tuãtase ynororo ona Parã po. Emese kure toehse ynororo. Morararo tykarimotary waro toehse pyrou ke. ");
INSERT INTO apyNT_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Mame jeny a nohpo tymenekase, Ejitu pono, ipytyme. ");
INSERT INTO apyNT_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Morarame Apimereke toytose oturuse Aparão maro. Tymaro takorehmane Pikou tarose, soutatu tõ tuisary. Ynara tykase Apimereke Aparão a: — Ritonõpo amaro mana. Ãkorehmãko mana onyriry tõ poko emero. ");
INSERT INTO apyNT_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Naeroro õmiry etapory se ase, Ritonõpo netaryme, yna onenekunohpyra oexiry poko te, umũkuru tõ roropa, ypakomotyã roropa. Zae rokẽ exiase amaro. Naeroro zae rokẽ exiko yna maro, sero nono põkõ maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","— Ỹ, jomiry etapõko ase oya, tykase Aparão. ");
INSERT INTO apyNT_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mame Apimereke turuse Aparão a tuna eutary poko, tapoise exiryke Apimereke poetory tomo a jamihme toexirykõke, tuna anapoipyra Aparão poetory tõ ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ynara tykase Apimereke: — Onoky a morara tyrise? Zuaro pyra akene. Jurupyra mexiase. Seromaroro rokẽ moro poko etãko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Mame kaneru tõ tapoise Aparão a pui tõ maro, toky tõ ekarotohme Apimereke a. Tõturuse toto oseya tõmirykõ totapose eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Mame 7me kaneru tõ tymenekase Aparão a toky toh tae, ekarotohme eya. ");
INSERT INTO apyNT_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Apimereke a tõturupose, ynara tykase eya: — Oty katoh moxiã tapiakase oya, 7me kaneru tomo? ");
INSERT INTO apyNT_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","— Moxiã mã ynekaroryme oya, tykase Aparão. — Moxiã 7me kaneru tõ apoiryhtao oya, ynara ãko mase: “Ỹ, zuaro ase: sero tuna eutary tahkase Aparão a,” ãko mase, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Morara exiryke moroto tosehpase Peresepame eya xine, moroto tõmirykõ totapose oseya exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Moromeĩpo Peresepa po tõmirykõ etapoxĩpo Apimereke toytose ropa takorehmane Pikou maro pirixteu tõ nonory pona ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Mame moroto Peresepa po wewe tarykase Aparão a, moroto roropa Ritonõpo toahmase Aparão a, Jũme Exiketyme aexiry poko. ");
INSERT INTO apyNT_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Mame okynahxo Aparão moroto ehse pirixteu tõ nonory po. ");
INSERT INTO apyNT_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Morarame Aparão tukuhse Ritonõpo a. Esety ae tykohmase ynororo: — Aparão! tykase eya. — Taro ase, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ynara tykase Ritonõpo eya: — Omũkuru apoiko, Izake, omũkuru toirono, ipyno oehtopo, mame ytoko mya Moria nonory pona. Moroto ypy po, ynenepory oya, omũkuru iahkako onekaroryme ya, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Yrokokoro towõse Aparão pakeimo, apotopokõ tyrakase eya, jumẽtu pona tyrise eya, mame toytopitose Ritonõpo a katopõpyry pona. Imaro Izake toytose, asakoro ipoetory tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Oseruao tõmehse toytorykõ poko, mame osa tonese Aparão a amekeino. ");
INSERT INTO apyNT_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ynara tykase ynororo typoetory tomo a: — Taro rokẽ ehtoko jumẽtu maro, yna eraximatoko. Ytõko ynanase mõtona Ritonõpo eahmase. Okynã pyra oehnõko ropa ynanase, tykase Aparão eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Apotopokõ tyrise Aparão a tumũkuru motary pona. Rato tapoise eya apoto ẽ maro, toytose toto asakoro rokene oximaro. ");
INSERT INTO apyNT_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Okynã pyra ynara tykase imũkuru tumy a: — Papa! tykase. — Otara aimo? tykase jumy. Tõturupose Izake tumy a: — Apotopokõ seny, apoto roropa, yrome otoko kaneru nah tyahkasehmy? tykase imũkuru eya. ");
INSERT INTO apyNT_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Aparão a tozuhse, ynara tykase ynororo: — Ritonõpo ro mokyro ekarõko mana totapasẽme, tykase jumy eya. Toytose ro toto myahme samo asakoro rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Toeporehkase tahtao xine Ritonõpo nenepohpyry pona, apoto apõ tyrise Aparão a, epona apotopokõ tyrise eya. Moromeĩpo Izake tymyhse eya apoto apõ pona tyritohme, apotopokõ pona. ");
INSERT INTO apyNT_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Mame rato tapoise eya tuotohme. ");
INSERT INTO apyNT_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Yrome kapu ae tõmitase Ritonõpo nenyokyhpyry: — Aparão! Aparão! — Taro ase, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","— Omũkuru onuopyra exiko, onyryhmara exiko, tykase Ritonõpo nenyokyhpyry eya. — Zuaro ase seromaroro ypyno oexiry poko, jomipona oexiry waro ase, omũkuru ekarory se make ya jomi poe, omũkuru toirono. ");
INSERT INTO apyNT_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Mame tỹkakoxi tõsenuhmase ahtao Aparão a kaneru tonese eya tyryhse tyretyry ae wewe ehmatao. Toytose Aparão mokyro apoise, totapase eya jahkatohme, apoto apõ pona tyrise eya tumũkuru myakãme. ");
INSERT INTO apyNT_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Moroto tosehpase Aparão a “Ekarõko Ritonõpo mana” me tosehpase eya. Morara exiryke seroae ro ynara ãko moro põkõ mana: “Ypy po, tosary po tokarosẽ ekarõko Ritonõpo mana.” ");
INSERT INTO apyNT_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Morarame Aparão tykohmase ropa Ritonõpo nenyokyhpyry a kaino. ");
INSERT INTO apyNT_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Ynara tykase ynororo eya: — Omũkuru toirõ ekarory se ya oexiryke, jomiry omipona, ynara ãko ase oya: Ywy roro jomiry etapõko ase oya, jesety mã Ritonõpo Oesemy, kure rokẽ orĩko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Apakomotyã tuhke emãnõko mã toto ypoe, ikuhpỹme toto ehtohme xirikuato ikuhpỹme ehtoh samo kapu ao te, isawã ikuhpỹme ehtoh sã roropa tuna konõto ehpio. Topetõkara poremãkapõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Apakõ ae kure rokẽ imehnõ rĩko ase emero nonory po jomihpyry omipona toehse oexiryke, ynyripohpyry tyrise oya exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Mame toytose ropa Aparão morotona ropa typoetory tomo a, mame oximaro toytose toto Peresepa pona, Aparão tapyĩ taka ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Moromeĩpo Aparão turuse zakorõ Naoa poko. Imũkuru tõ tonuruse 8me, ipyty Miuka poenõme. ");
INSERT INTO apyNT_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Apitorymã kynexine Uze; imeĩpo Puze te, mame Kemueu, Arã zũme; ");
INSERT INTO apyNT_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","imeĩpo tonuruse Kesete te, Hazo te, Piuta te, Jitirape te, Petueu, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Mokyro Petueu tõxike toehse Repekame. Mokaro kynexine Miuka poenomo Naoa maro, Aparão akorony. ");
INSERT INTO apyNT_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Reuma maro Naoa pyty roropa, tonuruse: Tepa te, Kaã te, Taasa te, Maaka, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Mame 127me jeimamyry taropose Sara a. ");
INSERT INTO apyNT_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Toorihse ynororo pata Eperõ po. Moroto esety akorõ Kiriate-Arapa kynexine, Kanaã nonory po. Tyhnamose ynororo Aparão a. ");
INSERT INTO apyNT_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Moroto typyty ekepyry tynomose aporo, toytose ynororo heteu tõ maro oturuse. ");
INSERT INTO apyNT_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Ynara tykase ynororo eya xine: — Katonõme ase ononorykõ po. Naeroro oya xine osa pitiko epekatyry se ase ypyty ekepyry zonẽtohme, tykase Aparão. ");
INSERT INTO apyNT_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Mame tozuhse ynororo heteu tomo a: ");
INSERT INTO apyNT_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","— Etako pahne, tuisa! Yna a omoro mase tamuximehxo exiketyme. Osa imenekako nono kurano aorihtyã zonẽtohme. Yna esary pyno pyra ynanase. Ise oehtoh ekarõko ynanase oya, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Mame towõse Aparão. Toepuise ynororo heteu tõ ẽpataka. Ynara tykase ynororo: ");
INSERT INTO apyNT_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","— Kure oya xine ahtao ypyty ekepyry zonemyry taro ononory po ekaropoko Eporõ a, Zoa mũkuru, ");
INSERT INTO apyNT_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","topu eutary, Makapera ekarotohme ya. Moroto mana esary ehpio. Tineru ke zae epehmãko ase epehpyry tytororo. Morarame zonẽtopõpyry esẽme exĩko ase taro. ");
INSERT INTO apyNT_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eporõ moroto kynexine typorohse oximõmãkõ maro, pata omõtoh pũto. Opore tõturuse ynororo imehnõ emero netaryme. ");
INSERT INTO apyNT_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","— Arypyra, tam. Etako pahne, moro nono ekarõko ase oya topehke pyra oesaryme ehtohme, topu ao eutary maro. Wekyry tõ neneryme morohne ekarõko ase oya topehke pyra opyty ekepyry zonẽtohme oya. ");
INSERT INTO apyNT_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Yrome toepuise ropa Aparão heteu tõ ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Eporõ a ynara tykase ynororo opore pitiko mokaro emero netaryme: — Etako ke, ajohpãme samo! Tineru ke moro nono epekatyry se ase. Kaxiko otãto epehpyry se hmahno, oepehmãko ase. Moromeĩpo ypyty ekepyry zonẽnõko ase moroto. ");
INSERT INTO apyNT_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Tozuhse ynororo Eporõ a: ");
INSERT INTO apyNT_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","— Etako ke, Pãna! Moro nono epehpyry 400me parata mana. Yrome epehpyry poko torẽtyke pyra exiko, osepeme sytase. Opyty ekepyry zonẽta morotona. ");
INSERT INTO apyNT_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","— Ỹ zae mase, moro epehmãko ase, tykase Aparão oximõmãkõ netaryme. Moro epehpyry, Eporõ a ekarohpyry, 4 kiru zokonaka kynexine, parata tukuhse ahtao, mõkomo ekamonanõ nukuhtoh po. ");
INSERT INTO apyNT_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Morarame moro nono esẽme toehse Aparão, Eporõ tupĩpyry Makapera po, Mãre poe xixi tũtatoh wino. Tupito topekahse eya topu eutary maro, wewe tõ maro mya esary ehpio pona. ");
INSERT INTO apyNT_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Mokaro heteu tõ emero moroto oximõmãkõ moro nono epekatyry enene toto. ");
INSERT INTO apyNT_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Moromeĩpo typyty Sara ekepyry tonẽse Aparão a topu eutary ao Makapera nonory po, Mãre poe xixi tũtatoh wino. Moro nono esety Eperõme, Kanaã nonory po. ");
INSERT INTO apyNT_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Morara exiryke heteu tõ nonory topu eutary maro Aparão nonoryme toehse, esaryme, okepy zonẽtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Morarame tamuhpõme Aparão kynexine. Kure rokẽ tyrise ynororo Ritonõpo a, takorehmase eya inyriry poko emero. ");
INSERT INTO apyNT_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Mame typoetory tykohmase tyya. Mokyro imõkomory eraseme kynexine emero porehme. Ynara tykase Aparão eya: — Oemary tyriko waxiry zopikoxi, Ritonõpo netaryme õmiry etapoko ya: ");
INSERT INTO apyNT_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ritonõpo kapu Esemy, sero nono Esẽme roropa mana. Mokyro netaryme kaxiko ya umũkuru Izake pytyme tarõkõ, Kanaã põkõ onymenekara exiko. ");
INSERT INTO apyNT_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ytoko ynonory pona wekyry tõ esaka, nohpo menekatohme oya Izake pytyme. ");
INSERT INTO apyNT_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tõturupose ipoetory: — Oty rĩko ywy mokyro nohpo toepyry se pyra ahtao ymaro. Omũkuru arõko ha ymahro, oesahpyry pona ropa? ");
INSERT INTO apyNT_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","— Arypyra, tykase Aparão. — Umũkuru anaropopyra ase myaro ipunaka! ");
INSERT INTO apyNT_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ritonõpo, Kapu Esemy a tonehse ywy papa tapyĩ tae, wekyry tõ nonory poe. Tõmiry totapose ya: sero nono ekarõko ase apakomotyamo a, tykase ynororo ya. Tynenyokyhpyry aropõko mana oesemary enepotohme oya, naeroro ekurehpyra mase, nohpo epekahnõko mase umũkuru pytyme. ");
INSERT INTO apyNT_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mãpyra nohpo toepyry se pyra ahtao, tymyhpokasẽme exĩko ropa sã mase. Yrome umũkuru anaropyra mase myaro ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Mame tomary tyrise ipoetory a Aparão axiry zopikoxi, tõmiry totapose eya tosẽ nyripory ritohme tyya. ");
INSERT INTO apyNT_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Morarame Aparão poetory a tosẽ eky kameru tõ tapoise, 10me, mõkomo maro, tynekaroryme. Mame toytose ynororo Naoa patahpyry pona, Mesopotamia pona. ");
INSERT INTO apyNT_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Toeporehkase tahtao, kameru tõ tosekumurukõ po typorohkapose eya tuna eutary myhtokoxi, pata pũtokoxi. Kokonie pukuro kynexine, tuna puimatoh po nohpo tomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ynara Ritonõpo a tõturuse ynororo: — Ritonõpo, jesẽ Aparão Esemy, emero zae ehtoh tyripoko, kure rokẽ jesẽ tõ tyriko roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Taro ase pẽkamã pũto, nohpo tõ oryximãkõ tuna enehse oehketõ eraximãko. ");
INSERT INTO apyNT_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ynara ãko ase toiro nohpo a: “Ajohpãme sã tuna pixo jokuru ekaroko,” ãko ase eya. Mame johpãko mana: “Oeky tõ roropa ohpãko ase,” karyhtao ya, mokyro onymenekahpyryme opoetory Izake pytyme aehtoh waro exĩko ase. Moro tonese ya exiryke tuaro exĩko ase kure oehtoh poko jesẽ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Aotururuhtao ro Ritonõpo a, Repeka tooehse, tuna ẽ ke tymotapõ ke. Petueu ẽxiry kynexine ynororo, Miuka pary Naoa pary, enara. Aparão akorõ kynexine Naoa. ");
INSERT INTO apyNT_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nohpo oryxime kynexine, orutua poko exipitopỹ kynexine; ipoko exipitopyra orutua kõ kynexine. Tyhtose ynororo tuna anỹse, mame tõnuhse ropa ynororo tuna anỹxĩpo. ");
INSERT INTO apyNT_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Tururume Aparão poetory toytose eya, ynara tykase ynororo eya: — Ajohpãme sã jokuru tuna pitiko ekaroko ya, tykase eya. ");
INSERT INTO apyNT_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","— Ỹ, ẽkose, tykase nohpo eya. Axĩ tuna ẽ typorohkase eya. Tuna ẽ tapoise ro eya enyryhtao eya. ");
INSERT INTO apyNT_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mame tuna ekarokehxĩpo eya, ynara tykase oryximã eya: — Tuna anỹnõko ase roropa oeky tõ ohpatohme. ");
INSERT INTO apyNT_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Axĩ tarykase tuna eya okyno tõ okuru ẽ aka. Mame toytose ropa ynororo tuna anỹse ropa tuna pẽkamãka kameru tõ okurume. Tauhpase toto ise pyrah katoh pona. ");
INSERT INTO apyNT_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Moro eneryke tyya: “Tyk,” tykase Aparão poetory. Mokyro nohpo enẽko rokẽ kynexine, tuaro toehtohme, Ritonõpo nymenekahpyryme nymyry ynororo exiry poko. ");
INSERT INTO apyNT_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Mame kameru tomo a tõkehse ahtao, uuru tapoise eya ounasere, 6 karama mano, tyritohme oryximã eunary pokona. Wãsere roropa asakoro tokarose eya uuru risemy, 100 karama motye. ");
INSERT INTO apyNT_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Mame tõturupose ynororo eya: — Onoky mokyro omy? tykase tõturupose eya. Osa nae nah atapyĩkõ tao ynanyhtohme ypoetory tõ maro? tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","— Ywy Petueu ẽxiry ase, Miuka pary Naoa pary, enara, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Yna tapyĩ tao nyhtoh nae. Nae roropa onahpoty oeky tõ napyryme. ");
INSERT INTO apyNT_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mame tosekumuru po typorohse ynororo Ritonõpo ẽpataka, Tosẽ toahmase eya. ");
INSERT INTO apyNT_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ynara tykase ynororo: — Kure mase Ritonõpo, jesẽ Aparão Esemy! Kure rokẽ tonehpose ywy Oya topohme Aparão ekyry tapyĩ taka, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tururume toytose nohpo oryximã tyse tapyĩ taka toto zuruse Aparão poetory oehtopõpyry poko. ");
INSERT INTO apyNT_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Typiry ke Repeka kynexine, esety Rapão. Moro ounasere uuru risemy te, wãsere tõ maro toryxiry emekũ poko eneryke tyya te, toryxiry otururu etaryke roropa tyya, toytose Rapão tururume Aparão poetory enehse. Moroto ro kynexine toky tõ maro, pẽkamã pũto. ");
INSERT INTO apyNT_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ynara tykase Rapão eya: — Osehko, ymaro eropa! Kure rokẽ tyrise mase Ritonõpo a. Oty katohme taro rokẽ mah jarao? Oesary nae tapyi tao, osa nae roropa oeky tõ esaryme, tykase ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Mame tapyi taka tomõse ynororo. Kameru tõ narotyã typorohkapose Rapão a. Onahpoty tokarose eya toto napyryme. Moromeĩpo tuna tonehse eya Aparão poetory a, imaro exiketomo a roropa, tupupurukõ ikurikatohme. ");
INSERT INTO apyNT_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Morarame tonahsẽ tonehse ahtao eya xine, ynara tykase Aparão poetory: — Otuhpyra ase aporo oturupyra ro jexiryke, tykase. — Ỹ kaxiko, oturuko tykase Rapão eya. ");
INSERT INTO apyNT_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Mame ynara tykase ynororo: — Ywy ase Aparão poetory. ");
INSERT INTO apyNT_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Kure rokẽ jesẽ tyrise Ritonõpo a. Itamurume tymõkomoke toehse ynororo Ritonõpo nekarotyã eya kaneru tõ tuhke te, poti tõ roropa te, pui tomo te, parata te, uuru maro te, ipoetory tomo, orutua komo te, nohpo tomo te, kameru tomo te, jumẽtu tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ipyty Sara toemũkuase kunumuxime tahtao jesẽ mũkurume. Tumy mõkomohpyry esẽme exĩko mana emero. ");
INSERT INTO apyNT_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tõmihpyry omipona tyripose ywy jesemy a Ritonõpo netaryme. Ynara tyripose ywy eya: “Umũkuru Izake pytyme nohpo onymenekara exiko Kanaã pono, tarono. ");
INSERT INTO apyNT_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Mya ytoko papa ekyry tõ esaka. Moroto wekyry tõ maro nohpo menekãko mase ipytyme,” tykase ");
INSERT INTO apyNT_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Mame ekaropoase eya: “Oty rĩko ah mokyro nohpo oryximã toepyry se pyra ahtao ymaro?” ");
INSERT INTO apyNT_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ynara tykase ynororo ya: “Ritonõpo omipona exikehpyra ase. Tynenyokyhpyry aropõko mana amaro oesemary enepotohme oya. Wekyry tõ rãnao, papa ekyry tõ maro nohpo oryximã menekãko mase umũkuru pytyme. ");
INSERT INTO apyNT_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Wekyry tõ maro õtururuhtao, mame tõxirykõ ekarory se pyra toto ahtao, morara ahtao tymyhpokase ropa sã mase. Torẽtyke pyra exiko,” tykase Aparão ya. ");
INSERT INTO apyNT_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","— Morarame toeporehkase jahtao tuna pẽkamã pona oturuno Ritonõpo a: “Ritonõpo, jesẽ Esemy kuakorehmako zae jesẽ nyripohpyry ritohme ya. ");
INSERT INTO apyNT_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Taro ase pẽkamã pũto. Nohpo oryximã tooehse ahtao tuna anỹse, tuna ekaropõko ase eya, jokurume. ");
INSERT INTO apyNT_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ỹme ynororo ahtao tuna ekarõko ya mana. Mame tuna ekarory se ynororo ahtao jeky tomo a, ah onymenekahpyryme mokyro nexi, jesẽ mũkuru pytyme,” ãko akene. ");
INSERT INTO apyNT_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Oturukehpyra ro jahtao Ritonõpo a ukurohtao, tooehse Repeka tuna ẽ ke tymotapõ ke. Tyhtose ynororo tuna anỹse pẽkamã aka. Mame ynara yka eya: “Jokuru pixo ekaroko ya otunary ẽ poe, ajohpãme samo,” ykano. ");
INSERT INTO apyNT_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Axĩ tuna ẽ typorohkase eya. Ynara nykano: “Ẽko. Tuna anỹnõko ase roropa oeky tõ okurume, kameru tõ okurume.” ");
INSERT INTO apyNT_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Morarame ekaropõ eya: “Onoky mokyro omy?” ykano. Mame jezuhno ynororo: “Petueu ẽxiry ase, Miuka pary Naoa pary roropa ase,” nykano. Mame ounasere yrino eunary pokona te, wãsere roropa yrino emekũ pokona. ");
INSERT INTO apyNT_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Jesekumuru po yporohno Ritonõpo eahmatohme. “Kure mase, Ritonõpo jesẽ Aparão Esemy,” ykã eya. “Kuenehno topohme xiaro jekyry tomo a, ẽxiry enetohme, jesẽ mũkuru pytyme.” ");
INSERT INTO apyNT_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Seromaroro kahtoko ya kure jesẽ maro se awahtao xine. “Arypyra,” kahtoko jũme rokene, moro kary se awahtao xine zuaro jehtohme, ynyriry waro jehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ynara tykase Rapão tomo, jũ maro: — Sero emero Ritonõpo poe nase. Naeroro oezuhsaromepyra ynanase. ");
INSERT INTO apyNT_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Mose Repeka; aroko amaro. Ritonõpo poe, ah oesẽ mũkuru pytyme nexino. Ritonõpo omihpyry ae ro, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Morara kary etaryke tyya, Aparão poetory toepuise Ritonõpo eahmatohme, “Kure mase” katohme. ");
INSERT INTO apyNT_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Mame upo tõkehko touse eya, parata roropa te, uuru risẽ roropa ekarotohme Repeka a. Mõkomo typyne exiketõ tokarose roropa eya, ipiry a te, jeny a, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Morarame tõtuhse ynororo imarõkõ maro, eukuru tõse eya xine, tõmehse toto moroto. Yrokokoro towõse ropa tahtao xine, ynara tykase Aparão poetory: — Ytoxi ropa jesẽ tapyĩ taka ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Yrome Repeka piry tõ, jẽ maro ynara tykase: — Kurehxo taro oexiry aporo, otarame 10me ẽmepyry. Moromeĩpo ytõko ropa matose, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Yrome ynara tykase Aparão poetory: — “Taro exiko aporo” kara ehtoko ya. Zae rokẽ tonehse ywy Ritonõpo a xiaro jesẽ ekyry tomo a, tynymenekahpyry enepotohme ya. Naeroro ytoxi ropa jesemy a ropa, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","— Repeka kohmãko ynanase, tykase toto, — ekaropotohme eya. Otara ãko mã ynororo tarame? ");
INSERT INTO apyNT_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Tykohmase ynororo eya xine oturupotohme: — Oytory se hma mose maro? tykase. — Ỹ, ytõko ase, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Mame Repeka taropose eya xine, kunumuximehxo exikety maro, akorehmaneme te, Aparão poetory maro imaro ytoketõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Kure rokẽ Repeka tyripose eya xine Ritonõpo a. Ynara tykase toto: — Omoro, yna oryxiry, tuhkãkõ ẽme oripory se ynanase Ritonõpo a tuhke miujãome exiketõ ẽme. Apakomotyã orẽpyra tyripory se ynanase eya tyzehnotokõ patary tõ poremãkatohme eya xine, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Mame Repeka tõ typoetory maro, tãtakimase toto. Tõtyrise ynaroro kameru tõ pona. Aparão poetory maro toytose toto. ");
INSERT INTO apyNT_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Mame Izake tooehse ona pona, tuna eutary pona. Moro pẽkamã esety “Isene Exikety Jenene tunary” kynexine. Moroto esary kynexine ikurenae Kanaã po. ");
INSERT INTO apyNT_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ytoytõko osenetupuhnõko kynexine, kohmãsasaka ahtao, ona po. Mame kameru tõ oepyry tonese eya. ");
INSERT INTO apyNT_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Repeka roropa tõsenuhmase. Izake eneryhtao, tyhtose ynororo kameru poe. ");
INSERT INTO apyNT_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Tõturupose ynororo Aparão poetory a: — Onoky mokyro orutua ytoytokety ona po, xiaro oehnõko? — Jesẽ mũkuru mokyro, tykase ynororo. Mame kamisa tapoise eya tõmyty apurutohme. ");
INSERT INTO apyNT_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Mame Izake turuse Aparão poetory a tynyrityã poko emero. ");
INSERT INTO apyNT_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Morarame Repeka tarose Izake a tytapyĩ taka, tyse tapyinỹpyry taka, Izake pytyme toehse ynororo. Repeka pyno toehse ynororo ipunaka, torẽnase toto, tãkye toehse ynororo, tomukehse roropa tyse orihtopõpyry poko. ");
INSERT INTO apyNT_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Mame imepỹ nohpo maro typytase ropa Aparão, esety Ketura. ");
INSERT INTO apyNT_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Toemũkuase ynororo 6me: Zinirã te, Jokosã te, Metã te, Mitiã te, Ixipake te, Sua, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokosã toemũkuase asakoro: Sepa te, Tetã, enara. Tetã pakomotyã ynara kynexine: asureu tomo te, retuseu tomo te, remueu tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Mitiã toemũkuase: Epame te, Epeame te, Enokeme te, Apitame te, Eretame, enara. Mokaro emero Ketura pakomotyãme toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Tymõkomory emero tokarose Aparão a Izake mõkomoryme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Yrome mõkomo pitiko tokarose eya typyxiã poenomo a. Mame orihpyra ro tahtao taropose toto eya Izake winoino xixi tũtatoh wino, Oriẽte nonory pona. ");
INSERT INTO apyNT_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","175me jeimamyry taropose Aparão a. ");
INSERT INTO apyNT_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Mame toorihse ynororo tamuhpõme toehse ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ekepyry tonẽse imũkuru tomo a: Izake te, Iximaeu, enara. Tonẽse ynororo oramãka topu aka, Makapera po, Mãre wino xixi tũtatoh wino, Eporõ tupi po. Eporõ, Zoa mũkurume kynexine, heteume exikety. ");
INSERT INTO apyNT_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Moro tupito kynexine Aparão nepekatyhpyry heteu tõ wino; moroto Aparão ekepyry tonẽse ipyty ekepyry maro. ");
INSERT INTO apyNT_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Moromeĩpo toorihse Aparão ahtao, kure rokẽ imũkuru Izake tyrise Ritonõpo a. Moroto esary kynexine, Isene Exikety Jeneneme Pẽkamã po. ");
INSERT INTO apyNT_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Iximaeu, Aparão mũkurume kynexine Akara mũkurume roropa, Sara poetory, Ejitu pono. Mame Iximaeu toemũkuase, imũkuru tõ ");
INSERT INTO apyNT_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ynara kynexine: osemazupu Nepaiote te, imeĩpo Ketaa te, Atapeeu te, Mipisão te ");
INSERT INTO apyNT_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mixima te, Tuma te, Masa te, ");
INSERT INTO apyNT_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hatate te, Tema te, Jetua te, Napi te, Ketema, enara toh kynexine, ");
INSERT INTO apyNT_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Iximaeu mũkuru tomo, 12mãkomo. Toto nonory tosehke toehse, esẽ esety ae ro. Tyekyry tõ tuisaryme toehse toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","137me jeimamyry nae Iximaeu kynexine toorihse ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Iximaeu pakomotyã moroto kynexine Hawira wino Sua pona, Ejitu poe xixi tũtatoh wino, Axiria esemary ehpio. Atameke toto esary kynexine imehnõ Aparão pakomotyã maro. ");
INSERT INTO apyNT_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Sero nase Izake, Aparão mũkuru ehtopõpyry poko. ");
INSERT INTO apyNT_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","40me jeimamyry nae Izake ahtao typytase ynororo Repeka ke, Petueu ẽxiry, Rapão oryxiry. Arameume toh kynexine Mesopotamia po. ");
INSERT INTO apyNT_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Mame emũkuasaromepyra Repeka kynexine, naeroro tõturuse Izake Ritonõpo a typyty poko. Aomiry totase Ritonõpo a, mame poetoẽme toehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Zuakuru ao kamarame poeto tõ kynexine, atatapoĩko toh kynexine tysekõ wakuru ao. Jẽkõ ynara tõsenetupuhse: “Oty katohme paupauãko itamurume, jerekohmãko umũkuru tõ nae?” tykase. Tõturupose ynororo Ritonõpo a, ");
INSERT INTO apyNT_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","mame ynara tykase Ritonõpo eya: “Awakuru ao opoenõ kamaramãkõ ahno tamurume exĩko mã toto. Emũkuãko mase kamarame, oxise pyra exĩko mã toto. Toiro omũkuru orẽpyra exĩko mana. Osemazupuru poremãkapõko akomihpyry mana,” tykase Ritonõpo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Morarame toemũkuase Repeka ahtao kamarame imũkuru tõ tonuruse. ");
INSERT INTO apyNT_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Osemazupu tonuruse kamirarame samo, ipihpyry tuhpose, upo samo, okyno pihpyry risẽ samo. Naeroro tosehpase ynororo Ezaume. ");
INSERT INTO apyNT_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Zakorõ tonuruse ahtao turui ihtaĩ tapoise eya tomary ke. Naeroro Jakome tosehpase ynororo eya xine. 60me jeimamyry nae Izake kynexine toemũkuase Repeka ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Mame tuãtase toto aimo tomo. Emese kure toehse Ezau urakanaketyme. Torẽnase ynororo toytory poko ona poro. Mãpyra Jako tyoro, tehme kynexine tapyi tao. ");
INSERT INTO apyNT_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ezau sehxo Izake kynexine, tõsẽ enepyryke eya. Yrome Jako sehxo Repeka kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Morarame kumataimo ahnõko Jako kynexine oripo ao. Ezau tooehse ropa urakanaxĩpo, totaehse kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ynara tykase ynororo: — Orihnõko ase omise jexiryke. Kynahpako pixo onyrihpyry kamiraramã ke. (Naeroro Etõme Ezau tosehpase eya xine.) ");
INSERT INTO apyNT_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","— Ỹ, seny ekarõko ase oya, yrome imehxo oehtoh ekaroko ya, osemazupume oexiryke, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","— Kure, omorohko, tykase Ezau. — Orihnõko ase jemiryke; Otyme kure imehxo jehtopõpyry nae, osemazuhme jenurutopõpyry nah, toorihse jahtao? Arypyra ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","— Ahtao, jũme rokẽ õmiry etapoko ya: “Ime jehtoh ekarõko ase jakorony a imehxo aehtohme,” kaxiko, tykase. Tõmiry totapose Ezau a takorony a. Naeroro ime toehtoh tokarose Ezau a imehxo Jako ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Mame tonahsẽ tokarose Jako a turui a, wyi maro, kumataimo tõkehko. Mame tõtuhkehse Ezau ahtao, eukuru tõse ahtao roropa eya, towõse ynororo. Jarãnaka toytose ropa. Morara exiryke ime toehtopõpyry se hkopyra Ezau kynexine, tokarose tyya exiryke tonahsẽ poko rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Morarame moro nonory po tonahsẽ pyrahme sã toehse, konopo oehpyra exiryke, pake ehtopõpyry saaro, Aparão orihpyra ro ehtopõpyry saaro. Morara exiryke pata Jeraa pona toytose Izake, Apimereke, pirixteu tõ tuisary esaka. ");
INSERT INTO apyNT_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Moroto Ritonõpo tõsenepose Izake a. Ynara tykase ynororo eya: — Ejitu pona ytopyra exiko. Taro rokẽ exiko, oesary enepõko ase oya. ");
INSERT INTO apyNT_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Tehme rokẽ exiko sero nono po, amaro exikehpyra exĩko ase, kure rokẽ orĩko ase. Apakomotyamo a sero nono ekarõko ase porehme, jomihpyry ae ro omy, Aparão a. ");
INSERT INTO apyNT_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Tuhke apakõ rĩko ase ikuhpỹme, xirikuato ikuhpỹme ehtoh samo kapu poko, mame eya xine sero nono ekarõko ase porehme. Apakõ ke kure rokẽ emero sero nono põkõ rĩko ase kure. ");
INSERT INTO apyNT_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ynara exiryke: Jomipona Aparão kynexine, ynyripohpyry tyrise eya, jomiry omipona kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Naeroro moroto Izake kynexine Jeraa po. ");
INSERT INTO apyNT_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Mame morotõkõ tõturupose ahtao ipyty poko, toryxiryme tyrise eya. Oryxime Repeka kynexine. Enaromỹke Izake kynexine typytyme Repeka ekarory poko. Ynara tõsenetupuhse ynororo: Otarame jetapãko tarõkõ mana ypyty apoitohme tyya xine imaro toehtohkõme, tykase ynororo tyya rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Moroto Izake ehse rahkene okynahxo. Mame tytapyĩ tae, osenuhmatoh ae Izake tonese tuisa Apimereke a. Typyty Repeka eahmãko Izake kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Mame Izake tykohmapose Apimereke a ekaropotohme eya. Ynara tykase ynororo eya: — Opytyme mokyro nae? Ajohpe pyra hnae? Oty katoh “Woryxiry mose ro,” mase opyty poko? tykase ynororo Izake a. — Imehnomo a jetaparyino, mokyro poko ypyty mose ro, kara exiase, tykase Izake. ");
INSERT INTO apyNT_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Morarame ynara tykase Apimereke eya: — Oty katohme morara mase yna a? Popyra mexiase. Zuaro pyra yna ahtao opytyme mose exiry poko, tupime pyra yna a opyty apoiry yna a ipoko yna ehtohme. Morara ahtao, ipoko toehse toiro orutua ahtao, iirypyryme konõto ynanexiry Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Morarame tõmiry taropose Apimereke a tuaro emero toto ehtohme. Ynara tykase ynororo: — Popyra mose orutua riryhtao oya xine te, ipyty riryhtao popyra roropa, awãnohtorỹko ase oorihtohkõ ke, tykase Apimereke. ");
INSERT INTO apyNT_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Morarame moro jeimamyry ae otyro tarykase Izake a, mame otyro tapoise eya itamurume, 100me inarykahpyry motye tapoise eya, kure rokẽ tyrise ynororo Ritonõpo a exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Imõkomory tõkehko, eky tõ roropa tomãse itamurume, imehxo toehse ynororo tymõkomoke, tytineruke, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Kaneru tõ tuhke nae te, poti tuhke roropa te, pui tõ tuhke te, typoetoke roropa tuhke nae kynexine, naeroro zumoxike toehse pirixteu tomo. ");
INSERT INTO apyNT_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Nono ke pẽkamã tapuruse ropa eya xine emero, Aparão poetory tõ nahkatyamo, isene ro Aparão, Izake zũ ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Moromeĩpo ynara tykase Apimereke Izake a: — Yna esary irumekako. Yna motye jamihme toehse mase. ");
INSERT INTO apyNT_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Moroto turumekase Izake a, tõsesarise ropa ynororo jakanahmã Jeraa po. Moroto ehse. Moroto ehse okynano. ");
INSERT INTO apyNT_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Tuna eutary tõ totapuruhmakase ropa eya, Aparão nahkatyamo, isene ro tahtao. Morohne tapuruse ropa kehko toorihse Aparão ahtao, pirixteu tomo a. Mame moro pẽkamã tosehpase ropa Izake a tumy a esehpatopõpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Morarame pẽkamã tahkase Izake poetory tomo a, tuna kurã tonese eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Yrome toky tõ poko erohketõ, morotõkõ tõsezusezuhse Izake poetory tõ maro. “Yna tunary sero,” tykase toto. Morara exiryke moro pẽkamã tosehpase Izake a “Oseosezuhtopõpo” me tosehpase eya. ");
INSERT INTO apyNT_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Moromeĩpo imepỹ tuna eutary tahkase Izake poetory tomo a, moro poko roropa tõsezusezuhse morotõkomo. Naeroro moro pẽkamã tosehpase Izake a “Osepeme pyra Ehtopõpo” me tosehpase eya. ");
INSERT INTO apyNT_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Morotoino toytose Izake. Imepỹ pẽkamã tahkase ropa eya. Moro poko oseosezuhpyra toh kynexine. Morara exiryke moro tosehpase “Osa Zumohxo” me tosehpase eya. Ynara tykase ynororo: — Seromaroro osa zumohxo tokarose Ritonõpo a kyya xine. Naeroro osesarĩko sytatose taro. Emãnõko roropa sytatose, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Morotoino toytose Izake Peresepa pona. ");
INSERT INTO apyNT_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Moroto ahtao koko tõsenepose Ritonõpo eya, ynara tykase ynororo eya: — Ywy ase Ritonõpo omy Aparão esemy. Enaromyra exiko amaro jexiryke. Ypoetory Aparão pokoino kure rokẽ orĩko ase, apakõ rĩko ase tuhke. ");
INSERT INTO apyNT_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Moroto apoto apõ tyrise Izake a tynekarory zahkatohme Ritonõpo eahmatohme. Moroto tõsesarise roropa ynororo, mame ipoetory tomo a imepỹ tuna eutary tahkase. ");
INSERT INTO apyNT_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Morarame Jeraa poe Apimereke toytose oturuse Izake maro. Imaro akorehmane toytose Auzate te, Pikou roropa, soutatu tõ tuisary. ");
INSERT INTO apyNT_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Tõturupose Izake eya xine: — Oty kase moehtou? tykase. — Yzehno mexiatose, oesarykõ poe kuenyokyatose xiaro, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ynara tykase toto eya: — Seromaroro zuaro ynanase Ritonõpo amaro mana. Ynara osenetupuhnõko ynanase: kure exiry amaro yna otururu, õmiry etapotohme Ritonõpo netaryme ");
INSERT INTO apyNT_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","yna onyryhmapopyra oehtohme. Morararo yna oryhmara exĩko ynanase. Zae ynanexiase amaro, yna wino toytose awahtao. Kure rokẽ toytose omoro osepeme ro. Seromaroro tuaro ynanase Ritonõpo kure rokẽ orĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Morarame otuhtoh konõto tyrise Izake a. Tõtuhse toto, eukuru tõse roropa eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Yrokokoro towõse ropa toto pakeimo, tõmirykõ totapose eya xine jũme osepeme toehtohkõme. “Ritonõpo netaryme jomiry ekarõko ase oya,” tykase toto oseya. Mame, “Kure rokẽ ytotoko ropa,” tykase Izake eya xine. Naeroro osepeme toehse toto. Mame toytose ropa toto tosaka xine. ");
INSERT INTO apyNT_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Morarame moro ae ro Izake turuse ipoetory tomo a, tuna nae toehse yna nahkahpyry ao. ");
INSERT INTO apyNT_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Moro pẽkamã tosehpase Izake a Sepame “Osepeme oturutopõpo” me tosehpase. Morara exiryke moro pata esety Peresepame toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","40me jeimamyry taropose ahtao Ezau a typytase ynororo Jutite maro, Peeri ẽxiry te, Pasemate maro roropa, Erõ ẽxiry. Mokaro asakoro heteu tõ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Mokaro nohpo tõ poko tãkye pyra Izake tõ toehse Repeka maro, tyamaro pyra toto exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Morarame tamuhpõme toehse Izake ahtao tonukehse ynororo. Mame morara ahtao tumũkuru Ezau tykohmase tyya, ynara tykase ynororo eya: — Aimo, umũkuru! — Taro ase, papa, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","— Tamuhpõme jexiry enẽko mase. Okynã pyra orihnõko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Naeroro ourakanata joh tuota. ");
INSERT INTO apyNT_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Morarame tomepore ahnoko yzamaro, moro enehko ya. Tõtuhkehse jahtao kure rokẽ oripõko ase Ritonõpo a orihpyra ro jahtao, tykase Izake Ezau a. ");
INSERT INTO apyNT_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Yrome tumũkuru a Izake otururu totase Repeka a. Naeroro urakanase toytose Ezau ahtao, ");
INSERT INTO apyNT_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ynara tykase jeny tumũkuru Jako a: — Omy omiry etano seromaroro orui Ezau a. Ynara nykano eya: ");
INSERT INTO apyNT_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Urakanase ytoko, joh tuota. Mame ahnoko tomepore. Tõtuhse jahtao kure rokẽ oripõko ase Ritonõpo a orihpyra ro jahtao,” nykano. ");
INSERT INTO apyNT_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Seromaroro, aimo, tykase Repeka, — etako pahne, ynara tyrĩko sytase, ");
INSERT INTO apyNT_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ytoko kuekykõ esaka, asakoro poti kurã enehta. Ywy roro tõsẽ ahnõko ase tomepore, omy zohme. ");
INSERT INTO apyNT_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Mame moro tõsẽ arõko mase omy zohme, autuhtohme. Imeĩpo kure oripõko mana Ritonõpo a orihpyra ro tahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yrome ynara tykase Jako tyse a: — Urui tuhpose itamurume, ywy arypyra. ");
INSERT INTO apyNT_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tapose jahtao papa a, tuaro exĩko mana ywy ase. Ya tonekunopyry waro exĩko mana. Mame popyra jyripõko mana. Kure jyripopyra ekurehnõko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Yrome ynara tykase jeny eya: — Morara ahtao popyra oriporyhtao ypokona exĩko mana, ypoe exiryke. Aimo, jomipona exiko: poti tõ enehta ya, tykase jeny. ");
INSERT INTO apyNT_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Toytose Jako, poti tõ tapoise eya, tarose toto tyse a, ipũ tahnose tomepore eya Izake zamaro aexihpyry samo. ");
INSERT INTO apyNT_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Mame Ezau zupõ kurã tapoise jeny a, tapyi tao ikurãkahpyry Jako a amurutohme. ");
INSERT INTO apyNT_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Mame poti pihpyry ke emary tyõtose, ipymyry tyõtose roropa eya Jako tuhpose pyra exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Moromeĩpo tõsẽ tomepore exikety tokarose eya wyi maro, tynyrihpyry. ");
INSERT INTO apyNT_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Mame toytose Jako tumy a. Ynara tykase: — Papa! — Taro ase, tykase jumy. — Onoky mahno, aimo? tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","— Ywy ase omũkuru Ezau, osemazupu, tykase Jako. — Õty mose, onyripohpyry. Owõko, ajohpãme samo; oporohko õtuhtohme. Mame kure jyripõko mase Ritonõpo a, tykase ynororo tumy a. ");
INSERT INTO apyNT_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","— Axĩ rukuh moehno ropa, aimo. Otara mexino? tykase Izake. — Ritonõpo Oesemy a takorehmase ywy, tykase ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ynara tykase Izake Jako a: — Osehko xiaro ya, ãpory se ase. Zuaro exĩko ase Ezau nymyry mahno? tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ameke pyra toehse Jako tumy a, tapose ahtao eya ynara tykase jumy: — Õmiry Jako omiry sã nase yrome ãpory Ezau apory sã nase, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Morara exiryke Jako onenetupuhpyra Izake kynexine emary tyhpotyke exiryke Ezau emary samo. Naeroro kure rokẽ tyripose ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Yrome tõturupose ropa toiro, kure onyripopyra ahtao ro: — Omoro hma umũkuru Ezau nymyry? tykase. — Ywy ase, tykase Jako. ");
INSERT INTO apyNT_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Mame ynara tykase jumy eya: — Joty enehko, onyrihpyry, jotuhtohme. Imeĩpo kure oripõko ase. Moro ahnohpyry tokarose Jako a tumy a. Eukuru tokarose roropa eya. Mame tõtuhse Izake, eukuru tõse roropa eya. ");
INSERT INTO apyNT_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Mame ynara tykase ynororo: — Osehko, aimo, kueahmakose. ");
INSERT INTO apyNT_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Tumy typohse ahtao Jako a zupõ typohse Izake a, Ezau zupony. Mame kure rokẽ Jako tyripose eya. Ynara tykase ynororo: — Aimo, typoxine mase, umũkuru mase jaraõ tupito sã mase, onahpoty typoxine ehtoh samo, kure tyripose ahtao Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kure rokẽ oripory se ase Ritonõpo a. Konopo enehpory se ase otupi tõ pona tynahke oehtohme itamurume, tiriiku itamurume, eukuru roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ahno tõ tuisaryme oripory se ase imehxo oexiry enetupuhtohme imeimehnomo a. Oekyry tõ esẽme oehtohme, oekyry tomo a kure oritohme. Popyra oripory se exiketõ popyra roropa exĩko mã toto. Kure exĩko mã toto kure oripory se exiketomo, tykase ynororo Jako a. ");
INSERT INTO apyNT_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Mame tõturukehse Izake ahtao kure Jako ripory poko Ritonõpo a, Jako tũtaryhtao ro Ezau toehse ropa urakanaxĩpo. ");
INSERT INTO apyNT_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Tõsẽ tomepore tahnose eya ekarotohme tumy a, ynara tykase ynororo: — Owõko ty! Ajohpãme sã otuhkose õty mose, unuohpyry. Imeĩpo kure rokẽ kyripoko. ");
INSERT INTO apyNT_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Mame tõturupose Izake a, ynara tykase: — Onokyh koh mano? tykase. — Ywy, Ezau, omũkuru osemazupu. ");
INSERT INTO apyNT_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aomiry etaryke tõserehse Izake. Tykytyky tykapitose itamurume, ynara tykase ynororo: — Onoky koh, joh enehno osemazuhme? Otuhno seromaroro oehpyra ro awahtao. Mokyro kure rokẽ yripono Ritonõpo a. Kure mokyro rĩko Ritonõpo mana. ");
INSERT INTO apyNT_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Morara kary etaryke tyya kui tykase Ezau opore tãtasamaryke. Ynara tykase ynororo: — Papa, kure kyripoko roropa, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Yrome ynara tykase Izake eya: — Ãkorõ tooehse, tonekunohse ywy eya, naeroro kure rokẽ ynororo tyripose ya Ritonõpo a, kure oripory se jehtopõpyry samo. ");
INSERT INTO apyNT_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ynara tykase Ezau: — Ỹ sero maro asakoro tonekunohse ywy eya. Zae tosehpase ynororo Jakome. Apitoryme ime jehtoh tapoise eya osemazuhme jenurutopõpyry. Seromaroro kure jyripotoh tomatonanohse eya. Papa, kure jyripotoh akoĩpyry onukurãkara make, toiro rokehxo jyripotohme roropa? ");
INSERT INTO apyNT_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ynara tykase Izake: — Jako tyripose ya otuisaryme. Jekyry tõ emero tyripose ya inamotome. Itamurume tiriiku, eukuru roropa ekaropõ eya. Seromaroro kure oriposaromepyra ase, aimo, tykase Izake. ");
INSERT INTO apyNT_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Yrome otuhparo Ezau kynexine: — Toiro rokẽ kure tyripotoh nae hma? Kure kyripoko roropa, papa, tykase. Mame tyxitapitose ynororo opore samo. ");
INSERT INTO apyNT_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Naeroro ynara tykase Izake: — Ameke nono kurã poe osesarĩko mase. Ameke roropa konopo wino exĩko mase. ");
INSERT INTO apyNT_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Atatapoĩko mase imehnõ maro osewomatohme, isene oehtohme. Ãkorõ poetoryme exĩko mase. Morararo typenekehse awahtao ãkorõ namotome oehtoh rumekãko mase. ");
INSERT INTO apyNT_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Morarame takorõ zehno toehse Ezau, kure Jako tyripose jũkomo a exiryke. Mame ynara tõsenetupuhse ynororo: “Okynã pyra papa orihnõko mana. Moromeĩpo tyhnamokehse ahtao jakorõ etapãko ase.” ");
INSERT INTO apyNT_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Mame tuaro Repeka kynexine takorõ zehno Ezau ehtoh poko. Jako tykohmase eya, ynara tykase ynororo eya: — Etako pahne! Orui ozehno toexiryke, toemỹpory se ynororo; oetapary se mana. ");
INSERT INTO apyNT_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Morara exiryke, etako pahne, aimo. Ytoko seromaroro ypiry Rapão tapyĩ taka, Harã pona. ");
INSERT INTO apyNT_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Moroto exiko orui ekurãkatohme ropa, ozehno pyra aehtohme ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Wenikehnõko ynororo onyrihpyry poko. Morara toehse ahtao omi arone enyohnõko ase oenehtohme ropa moro poe. Umũkuru tõ asakoro natokõ osetapary se pyra ase toiro ẽmepyry ae, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Mame tõturuse Repeka Izake maro, ynara tykase ynororo eya: — Typenekehse ywy mokaro Ezau pyxiã heteu tõ poko. Typytase Jako ahtao nohpo heteu maro, kurehxo ya jorikyry, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Morarame Jako tykohmase Izake a, taomikase eya. Mame ynara tykase ynororo eya: — Nohpo tarõ maro pytara exiko, Kanaã pono. ");
INSERT INTO apyNT_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Atakimako oytotohme Mesopotamia pona, atamuru Petueu tapyĩ taka. Rapão, asa piry, ẽxiry imenekako opytyme. ");
INSERT INTO apyNT_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ritonõpo, Jamihmehxo Exikety a, kure rokẽ oripõko ase opoenõ tuhke ehtohme, apakomotyã roropa, tuhke toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Eya kure rokẽ oripõko ase, apakomotyã roropa, kure Aparão ritopõpyry samo, sero nono esẽme toto ehtohme, Ritonõpo nekarohpyry Aparão a. Moroto katonõme sã rokẽ ytoytoketyme nexiase. ");
INSERT INTO apyNT_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Morarame Jako taropose Izake a Mesopotamia pona Rapão tapyĩ taka. Rapão kynexine Petueu mũkuru, arameu, Repeka piry, Ezau tõ eny, Jako maro. ");
INSERT INTO apyNT_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Mame zuaro toehse Ezau kure Jako ripotopõpyry poko Izake a, Jako aropotopõpyry poko roropa Mesopotamia pona ipytatohme. Zuaro toehse roropa ynororo tumy omihpyry poko Jako a pytara ehtohme Kanaã põkõ nohpory maro. ");
INSERT INTO apyNT_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Zuaro toehse roropa ynororo Jako ytotopõpyry poko, tumy tõ omi poe, Mesopotamia pona. ");
INSERT INTO apyNT_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Morara exiryke tonetupuhse ynororo tumy zamaro pyra Kanaã põkõ nohpory exiry poko. ");
INSERT INTO apyNT_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Naeroro toytose ynororo Iximaeu tapyĩ taka, Aparão mũkuru a. Typytase ynororo Maarate ke, Iximaeu ẽxiry, Nepaiote oryxiry ke. ");
INSERT INTO apyNT_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Mame Jako toytose Peresepa poe osema ae Harã pona toytotohme. ");
INSERT INTO apyNT_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Tykohmãse ahtao toeporehkase ynororo osa kurã pona. Tõmehse moroto ynororo. Topu tapoise eya moroto tupuhpyry apõme, tohrame toehse ynororo, tynyhse. ");
INSERT INTO apyNT_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Mame tõsenehse ynororo. Opyi sã tonese eya aosenety nono poe kapu pona. Ritonõpo nenyohtyã tonese eya onuhnõko, yhtõko roropa eporo. ");
INSERT INTO apyNT_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Moroto Ritonõpo panõ tonese eya xikihme, ynara tykase ynororo eya: — Ywy ase Ritonõpo, atamuru Aparão Esemy, omy Izake Esẽ roropa. Oya, apakomotyamo a roropa sero nono, ekarõko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Apakomotyã roropa tuhke exĩko mã toto, ikuhpỹme isawã samo sero nono po. Sapararahme exĩko mã toto inikahpozakoxi te, ikurenaka te, xixi tũtatoh wino te, xixi omõtoh wino, enara. Mame opokoino xine apakomotyã maro, kure rokẽ imehnõ rĩko ase emero nono põkomo. ");
INSERT INTO apyNT_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Amaro exikehpyra ase. Oewomãko ase emero pata pona oytoryhtao. Mame oenehnõko ropa ase xiaro sero nonory pona ropa. Orumekara ase. Jomihpyry ae ro kure rokẽ oritorỹko ase, myarotokorome. ");
INSERT INTO apyNT_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Mame typakase ropa Jako ahtao ynara tykase: “Ajohpe pyra Ritonõpo nase taro. Zuaro pyra akene.” ");
INSERT INTO apyNT_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Enaromỹke toehse ynororo, ynara tykase: “Enaromỹke ase taro. Otarame Ritonõpo tapyĩ sero. Otarame omõtoh sero kapu aka,” tykase ynororo tyya rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yrokokoro pakeimo towõse Jako. Moro topu, tupuhpyry aponỹpyry tanỹse eya sokohme wenikehpyra ehtohme. Mame azeite tukuãse eya moro topu pona tynekaroryme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Moro pũto pata kynexine, esety Ruze. Yrome moro tosehpase eya Peteume. ");
INSERT INTO apyNT_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Moroto tõturuse Jako Ritonõpo a. Ynara tykase ynororo: — Ymaro exikehpyra awahtao, jewomaryhtao oya jesemary ae jytoryhtao, tonahsẽ ekaroryhtao ya, upo roropa, ");
INSERT INTO apyNT_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","mame kure rokẽ joepyry ropa ahtao papa tapyĩ taka ropa, omoro, Ritonõpo, Jesẽme exĩko mase. ");
INSERT INTO apyNT_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Sero topu ynyrihpyry xikihme wenikehpyra jehtohme oesaryme, oeahmatohme exĩko mana. Mame onekarohpyry ya apiakãko ase, 10me ahtao toiro tousẽme ekarõko ase oya, tykase ynororo Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Mame Jako toytose, toeporehkase ynororo Oriẽte pona. ");
INSERT INTO apyNT_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Mame tõsenuhmase ahtao, ona rãnao, nono ahkahpyry tonese eya. Moro tuna eutary zomye tokykõ enenanõ oseruao tonese eya, tokykõ maro, kaneru tomo, poti tõ maro. Moro tuna eutary tapuruse kynexine topu konõto ke. Naeroro tuna ananỹsaromepyra enenanõ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tõximõse tokykõ enenanõ emero tahtao, topu tanỹse eya xine tuna anỹtohme tokykõ ohpatohme. Mame tõtyhkase tahtao xine topu tyrise ropa apuru. ");
INSERT INTO apyNT_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Tõturupose Jako eya xine, ynara tykase: — Oty pata põkõ hmatou, jepe tomo? tykase. — Harã põkõ ynanase, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","— Rapão waro hmatou, Naoa mũkuru? tykase Jako. — Ỹ, mokyro waro ynanase, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","— Kure hnae ynororo? tykase Jako, tõturupose. — Ỹ, kure mana, tykase toto. — Eneko ke! Mokyro ẽxiry, Rakeu oehnõko mana toky tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Mame ynara tykase Jako: — Kohmãpyra ro nase, kaneru tõ apurutoh popyra ro. Oty katoh tuna onekaropyra hmatou oekykomo a, toto arotohme ropa ona pona ropa? tykase Jako eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ynara tykase toto: — Tuna ananỹsaromepyra ynanase anapuruhmakara ro ahtao. Tysyryhmase topu ahtao rokẽ yna eky tõ ohpãko ynanase. ");
INSERT INTO apyNT_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Toto maro Jako otururuhtao ro Rakeu tooehse toky tõ maro, toky tõ eneneme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Mokyro eneryhtao Jako a kaneru tõ maro poti tõ maro, tyse piry ẽxiry tonese eya. Mame topu tysyryhmase eya pẽkamã eutary poe, eky tõ ohpatohme. ");
INSERT INTO apyNT_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Imeĩpo Rakeu typohse eya. Tyxitapitose ynororo tãkye toexiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ynara tykase ynororo eya: — Omy ekyryme ase. Repeka mũkuru ase, tykase ynororo eya. Tururume toytose Rakeu tumy zuruse, emero. ");
INSERT INTO apyNT_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Mame typatũ poko zuaro toehse Rapão ahtao, toytose ynororo tururume. Jako eneryhtao toahmase ynororo eya. Typohse eya roropa. Mame tarose ynororo tytapyĩ taka. Mame tory turuse Jako a emero toehtopõpyry poko. ");
INSERT INTO apyNT_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Mame ynara tykase Rapão: — Aõ! Ajohpe pyra. Wekyry nymyry mase, tykase Rapão eya. Toiro nuno taropose ahtao Jako a tory tapyĩ tao, ");
INSERT INTO apyNT_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ynara tykase Rapão eya: — Zae pyra nase oerokuru ypoetoryme topehke pyra, wekyryme oexiryke. Otãto epehpyry apoiry se hma oerohtamitume? ");
INSERT INTO apyNT_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Asakoro tõxike Rapão kynexine. Osemazupu esety kynexine Reia, zakorony Rakeu. ");
INSERT INTO apyNT_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Reia enuru kure potu kynexine. Yrome Rakeu ẽmyty oryxime kuhse kynexine. Zoko roropa enekure kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Mame Rakeu pynohxo Jako exiryke ynara tykase ynororo: — Erohnõko ase 7me jeimamyry Rakeu apoitohme ypytyme. ");
INSERT INTO apyNT_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ynara tykase Rapão: — Kure ya jẽxiry ekarory oya opytyme. Popyrahxo imepyny a, mose ekarory. Taro exiko ymaro, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Naeroro toerohse Jako 7me jeimamyry Rakeu apoitohme typytyme. Yrome ise toexiryke 7me jeimamyry tuhke pyra saerehkatoh sã kynexine eya. ");
INSERT INTO apyNT_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Morarame 7me jeimamyry taropose ahtao, ynara tykase Jako Rapão a: — Ypyty se ase rahkene 7me jeimamyry taropose ya exiryke, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Mame otuhtoh konõto tyrise Rapão a Jako pytatoh po. Morotõkõ emero toahmase eya. ");
INSERT INTO apyNT_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Yrome moro kohmamyry ae Reia tapoise Rapão a. Tokarose ynororo Jako a. Imaro toehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ipoetory Ziupa tokarose Rapão a, Reia a ipoetoryme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Tõmehse ahtao tonetupuhse Reia eya. Naeroro tõturuse ynororo Rapão a. Ynara tykase ynororo eya: — Oty katohme sẽ sã make ymaro? Toerohse ywy 7me jeimamyry Rakeu apoitohme ya. Oty katohme kuenekunohno, eo? tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ynara tykase Rapão: — Taro yna nonory po, toipe ynanase. Yna ẽxiry okominoto onekaropyra ynanase osemazuhme. Osemazupu rokẽ ekarõko ynanase osemazuhme. ");
INSERT INTO apyNT_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Eraximako. Sero 7me ẽmepyry oseahmatoh erẽnatoh poko rokẽ sytatose aporo. Tõtyhkase ahtao õmiry etary se ase: “Imepỹ 7me jeimamyry erohnõko ase amaro,” karyhtao oya, Rakeu ekarõko ase oya, tykase Rapão Jako a. ");
INSERT INTO apyNT_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ỹme Jako kynexine. Naeroro moro otuhtoh konõto tõtyhkase ahtao Reia maro erẽnatoh poko, Rakeu tokarose roropa Rapão a Jako pytyme. ");
INSERT INTO apyNT_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Ipoetory Pira tokarose Rapão a Rakeu maro ehtohme ipoetoryme). ");
INSERT INTO apyNT_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Typyty Rakeu sehxo Jako kynexine, Reia se toehtoh motye. Mame toerohse ynororo Rapão poetoryme 7me jeimamyry ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Reia se hkopyra Jako ehtoh tonese Ritonõpo a. Naeroro Reia takorehmase Ritonõpo a aemũkuatohme. Yrome Rakeu tumũkue pyra tyripose Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Poetoẽme toehse Reia, toemũkuase Rupẽme. Ynara tykase ynororo: — Tãkye pyra jehtopõpyry tonese Ritonõpo a, yrome taroino ypyno exĩko ynio mana. ");
INSERT INTO apyNT_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Mame poetoẽme toehse ropa Reia, toemũkuase ropa ynororo, esety Ximeão. Ynara tykase ynororo: — Jatasamary tonese Ritonõpo a, naeroro umũkuru tokarose eya. ");
INSERT INTO apyNT_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Mame poetoẽme toehse ropa Reia, toemũkuase ropa Rewime. Ynara tykase ynororo: — Taroino ysehxo ynio exĩko mana toemũkuase oseruao jexiryke, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Mame poetoẽme toehse ropa Reia, toemũkuase ropa, esety Jutame. Ynara tykase ynororo: — Taroino Ritonõpo eahmãko ase, tykase ynororo. Mame emũkuara ropa kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Morarame tuaro Rakeu toehse ahtao emũkuasaromepyra toexiry poko typaxiry Reia zumoxike toehse ynororo. Ynara tykase ynororo tynio a: — Umũkuru tõ ekaroko ya, jorikyryino, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Morara kary etaryke tyya tohne toehse Jako, Rakeu zehno. Ynara tykase ynororo eya: — Ritonõpome jekarõko mah? Ynoro rokẽ omũkuapopyra mana. ");
INSERT INTO apyNT_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Mame ynara tykase Rakeu eya: — Mose ypoetory Pira maro exiko. Toemũkuase ynororo ahtao umũkurume exĩko mana. Morara ahtao tumũkue exĩko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Naeroro typoetory tokarose Rakeu a tynio a ipytyme ynororo ehtohme, imaro toehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Mame Pira poetoẽme toehse, toemũkuase orutuame. ");
INSERT INTO apyNT_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Mame ynara tykase Rakeu. — Mose esety Tãme exĩko, zae toehse Ritonõpo exiryke ymaro. Jomiry totase eya, poeto pitiko tokarose eya umũkurume ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Mame poetoẽme toehse ropa Pira, toemũkuase ropa ynororo Jako mũkurume ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Naeroro ynara tykase Rakeu: — Mose esehpãko ase Napatarime tãtatapoise jexiryke ypaxiry maro, mame orẽpyra toehse ywy. ");
INSERT INTO apyNT_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Mame zuaro toehse Reia ahtao emũkuara ropa toehse toexiry poko, typoetory Ziupa tokarose eya tynio a, ipytyme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Mame toemũkuase Ziupa Jako mũkurume. ");
INSERT INTO apyNT_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ynara tykase Reia: — Ohkato ywy! Mose esehpãko ase Kateme. ");
INSERT INTO apyNT_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Imeĩpo toemũkuase ropa Ziupa Jako mũkurume ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ynara tykase Reia: — Tãkye rokẽ ase! Taroino imehnõ nohpo tõ tãkye jekarõko mã toto. Tumũkuru tosehpase eya Aseame. ");
INSERT INTO apyNT_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Morarame tiriiku apoitoh toehse ahtao tupito pona toytose Rupẽ. Moroto otyro, mãtarakora tõ tonese eya, mame tarose eya tyse, Reia a. Morohne tonese ahtao Rakeu a tokaropose typaxiry a: — Ajohpãme sã morohne mãtarakora ekaroko ya, omũkuru nenepyhpyry. ");
INSERT INTO apyNT_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ynara tykase Reia: — Epo pyra hnae oya ywino ynio apoiry oya? Seromaroro umũkuru nekarohpyry ya mãtarakora tõ apoiry se roropa hma? tykase. Ynara tykase Rakeu: — Morohne omũkuru mãtarakora tõ ekaroryhtao ya ynio ekarõko ase oya imaro oẽmehtohme, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Mame kokonie pukuro tooehse Jako ahtao tupito poe, tõseporyse Reia imaro. Ynara tykase ynororo eya: — Seroae ẽmehnõko mase ymaro, jakorõ topehmase ya exiryke umũkuru nenepyhpyry ke, mãtarakora tõ ke, tykase. Mame typyty Reia maro toehse Jako. Ipoko toehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Reia otururu totase Ritonõpo a, poetoẽme toehse ropa ynororo, mame toemũkuase 5me ehtopo. ");
INSERT INTO apyNT_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Mame ynara tykase Reia: — Mose esehpãko ase Isakaame, umũkuru ke topehmase ywy Ritonõpo a, ypoetory tokarose ya exiryke ynio Jako pytyme. ");
INSERT INTO apyNT_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Imeĩpo poetoẽme toehse ropa Reia, 6me ehtopo toemũkuase ynororo Jako mũkurume. ");
INSERT INTO apyNT_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ynara tykase ynororo: — Ritonõpo nekarohpyry kurã mose ro. Taroino ymaro ynio exĩko mana 6me tumũkuapose ya exiryke, tykase ynororo. Morara exiryke tumũkuru tosehpase eya Zepurõme. ");
INSERT INTO apyNT_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Mame etyhpyryme Reia toemũkuase nohpome, esety Tina. ");
INSERT INTO apyNT_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Mame wenikehpyra Ritonõpo kynexine Rakeu poko. Aotururu tyya totase Ritonõpo a, takorehmase ynororo emũkuatohme. ");
INSERT INTO apyNT_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Poetoẽme toehse ynororo, toemũkuase orutuame. Mame ynara tykase ynororo: — Ritonõpo poe ehxiropyra toehse ywy toemũkuase jexiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ritonõpo a ise ro ase toiro. Naeroro tumũkuru tosehpase Jozeme eya. ");
INSERT INTO apyNT_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Mame tonuruse Joze ahtao ynara tykase Jako Rapão a: — Ytoxi ropa ynonory pona. ");
INSERT INTO apyNT_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Umũkuru tõ ekaroko ya ypyxiã maro. Topekahse toto ya jerohtoh ke opoetoryme. Naeroro ytõko ropa ase. Tuaro mase itamurume erokuase amaro. ");
INSERT INTO apyNT_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","— Jurumekara exiko, tykase Rapão. — Tuaro toehse ywy kure rokẽ jyrĩko Ritonõpo mana opokoino ymaro oexiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kaxiko, otãto se hma oerohtamitume. Oepehmãko ase, tykase Rapão eya. ");
INSERT INTO apyNT_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ynara tykase Jako eya: — Zuaro mase emese kure jerohtopõpyry poko oeky tõ poko. ");
INSERT INTO apyNT_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Oehpyra ro jahtao oeky tõ tuhke pyra nexiase. Yrome seromaroro tuhke tomãse toto. Kure rokẽ tyrise omoro Ritonõpo a yneneryme emero pona toytose jahtao. Seromaroro jytory se ropa ase ypoenõ akorehmatohme, tykase Jako eya. ");
INSERT INTO apyNT_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","— Oty se hma epehpyryme. Oepehmãko ase, tykase Rapão eya. Ynara tykase Jako Rapão a: — Epehpyry se pyra reh ase. Erohnõko ro ase oeky tõ poko josenetupuhtoh kure oya ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Seroae oeky tõ enẽko ase. Mame toto apiakãko ase kaneru tõ xinukutumãkõ rokẽ jekyme ehtohme, poti tõ roropa pitahpitahmãkõ rokẽ jekyme exĩko mã toto. Mokaro rokẽ se ase jerohtamitume. ");
INSERT INTO apyNT_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Taroino tupime pyra exĩko zae jehtoh enetuputyry. Jepehpyry enery se awahtao, jeky tõ maro imepỹ kaneru nae ahtao, xinukutumã kara te, poti tõ nae ahtao pitahpitahmãkõ kara tuaro exĩko mase, “Mokyro tomatonanohse Jako a” kara ehtohme. Morara exiryke xinukutumãkõ se rokẽ ase pitahpitahmãkõ maro, tykase Jako eya. ");
INSERT INTO apyNT_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","— Ỹ kure, tykase Rapão, repe. — Õmiry zae mana ya, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mame moro ae ro toky tõ tapiakase eya: poti tõ pitahpitahmãkomo te, xinukutumãkomo te, kaneru xinukutumãkomo, enara. Mya taropose toto Rapão a typoenomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Mame Jako maroino toytose toto oseruao ẽmepyry pune. Imehnõ akoĩpyry tõxinamase Jako maro. ");
INSERT INTO apyNT_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Mame wewe amoriry tapoise Jako a, typikase eya ipũ karimutume ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Moro amoriry tyrise eya tuna ẽtoh po, okyno tõ ẽpataka. Morara tyrise eya pitahpitahmãkõ toehse ahtao ");
INSERT INTO apyNT_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","mokaro emãtohme xinukutumãkõ emãtohme roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Morarame kaneru tõ tapiakase Jako a poti toh tae. Tyripose toto ẽkõ aka. Moromeĩpo tapiakase toto eya, toky tõ Rapão eky toh tae. ");
INSERT INTO apyNT_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Mame okyno jamihme ahtao morara tyrise Jako a jamihmãkõ emũkuatohme tokyme. Wewe amoriry tyrise eya toto ẽpataka, tuna ẽtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Yrome jamihme pyra toto ahtao moro amoriry onyripyra kynexine. Morara exiryke Rapão eky tõ jamihme pyra toehse. Yrome Jako eky tõ jamihme toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Morara exiryke tymõkomoke itamurume toehse Jako te, tuhke kaneru tomo te, poti tõ maro te, tuhke ipoetory tomo, orutua komo te, nohpo tõ maro te, kameru tomo te, jumẽtu tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Mame tykerekeremary Rapão mũkuru tomo a totase Jako a, ynara tykase toto ipoko: — Papa mõkomory apoĩko Jako nase tymõkomoryme. Tokyke tuhke exĩko roropa mana papa eky tõ ke. ");
INSERT INTO apyNT_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Osepeme hkopyra Rapão ehtoh tonetupuhse roropa Jako a. ");
INSERT INTO apyNT_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Mame ynara tykase Ritonõpo Jako a: — Ytoko ropa omy tõ nonory pona oekyry tomo a ropa. Amaro ase exĩko. ");
INSERT INTO apyNT_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Naeroro Jako a typyxiã tykohmase tyya, Rakeu te, Reia, enara, toto oehtohme tyya ona pona, okyno tõ esaka. ");
INSERT INTO apyNT_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ynara tykase ynororo eya xine: — Omy osepeme hkopyra toehse ymaro pake apitoryme toehtopõpyry sã pyra. Moro enẽko ywy. Yrome Ritonõpo, papa Esẽ, ymaro toehse mana. ");
INSERT INTO apyNT_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Zuaro matose jerohtopõpyry poko yronymyryme omy poetoryme. ");
INSERT INTO apyNT_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Yrome tonekunohse ywy eya. Jerohtamitu tyotyoro tyrise eya tuhke, omame porehme. Yrome towomase ywy Ritonõpo a yyryhmara aehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ynara tykase ynororo ahtao: “Poti tõ oepehpyryme exĩko mana oerohtamitume pitahpitahmãkomo,” tykase ahtao, toemũkuase toto pitahpitahmãkõ rokene. Mame ynara tykase ynororo ahtao: “Poti tõ karimutumãkõ rokẽ oepehpyryme exĩko mana,” tykase ahtao toemũkuase toto karimutumãkõ rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Moro sã tyrise Ritonõpo a omy eky tõ poe tuhkehxo, ekarotohme ya. ");
INSERT INTO apyNT_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Morarame okyno tõ emũkuatoh po toehse ahtao tõsenehse ywy. Poti orutua kõ poti tõ poko exiketõ emero pitahpitahme toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mame tykohmase ywy Ritonõpo nenyokyhpyry a jesety ae. “Taro ase,” ase eya. ");
INSERT INTO apyNT_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Mame ynara nase ynororo ya: “Eneko ke! Poti orutua kõ poti tõ poko exiketõ emero pitahpitahme mã toto. Moro sã tyripõko ase, Rapão nyrihpyry oya tonese ya exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ywy ase Ritonõpo, osenepoase oya Peteu po awahtao. Moroto topu tanỹse oya xikihme. Oriu tukuãse oya moro topu pona onekaroryme ya, õmiry metapoase ya. Seromaroro atakimako sero nonory poe oytotohme ropa oenurutopõpyry pona ropa.” ");
INSERT INTO apyNT_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Mame ynara tykase Rakeu tõ eya, Reia maro: — Papa mõkomory tonahse, tokarosẽ pyra toehse yna a. ");
INSERT INTO apyNT_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Katonõme sã toehse ynanase eya. Yna tokamose eya tineru poko. Mame moro tineru tonahkase eya emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Imõkomohpyry, Ritonõpo napoihpyry yna mõkomoryme toehse yna poenõ mõkomoryme roropa. Naeroro tyriko kẽty emero Ritonõpo nyripohpyry oya, tykase toto eya. ");
INSERT INTO apyNT_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Naeroro tãtakimase Jako toytotohme ropa Kanaã pona, tumy Izake esaka. Typyxiã tyripose eya kameru tõ pona, typoenõ maro. Tymõkomory emero tapoise eya. Mame toytopitose rahkene toky tõ maro emero, tynapoityamo toerohtamitume, Mesopotamia po. ");
INSERT INTO apyNT_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Mokyro Rakeu tõ zumy imepỹ po kynexine erohnõko toky tõ poko kaneru tõ hpoty sahkãko. Mokyro esahpyo tomõse Rakeu itapyĩ taka tumy neponãmarykõ ematonanohse. ");
INSERT INTO apyNT_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Moro sã kynexine Jako ytotopõpyry ropa Kanaã pona, tokare pyra, Rapão, arameu tonekunohse eya. ");
INSERT INTO apyNT_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Toepase Jako tymõkomory maro emero. Tuna Eupyrati takuohse eya, mame toytose ynororo ypy tõ Kireate nonory wino. ");
INSERT INTO apyNT_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Mame oseruao tõmehse ahtao tuaro toehse Rapão Jako ytotopõpyry ropa poko omatome. ");
INSERT INTO apyNT_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Toky tõ tynomose eya Jako tõ ekahmatohme tyya. Mame 7me ẽmepyry taropose ahtao tõseporyse ynororo Jako tõ maro ypy tõ po Kireate nonory po. ");
INSERT INTO apyNT_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Moro kohmamyry ae tõsenepose Ritonõpo Rapão a, arameume exikety. Ynara tykase ynororo eya: — Tomeseke exiko! Apatũ onyenonohpyra ke exiko. Zae rokẽ exiko imaro. ");
INSERT INTO apyNT_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Tõseporyse Rapão Jako tõ maro ypy tõ po Kireate nonory po. Moroto tõsesarise ynororo kynexine. Naeroro Rapão roropa tõsesarise moroto tyekyry tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Mame tõturupose Rapão Jako a: — Oty katoh kuenekunopyase? Jẽxiry tõ arõko mase juruxĩpo pyra. ");
INSERT INTO apyNT_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Oty katoh kuenekunopyase? Mepase rokene osekazumara mexiase ya? Turuse jahtao oya otuhtoh konõto yriry atãkyematohme, õsekazumatohme, eremiatoh ke, etotoh maro, rue tõ etory ke, pãteru te, rira tõ maro. Morohne yriry turuse jahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ypakõ onypohpopyra mexiase ya, jẽxiry tõ onypohpopyra roropa mexiase ya toto osekazumaryme. Zae pyra mexiase ymaro. ");
INSERT INTO apyNT_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Awãnopyry se jahtao, kuãnopyry. Yrome koko turuse ywy Ritonõpo, omy Esemy a. Ynara nase ya: “Tomeseke exiko! Apatũ onyenonohpyra exiko. Zae rokẽ exiko imaro,” nase ya. ");
INSERT INTO apyNT_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Zuaro ase: omuhpe oexiryke omy tõ poko, toytose omoro. Yrome oty katohme yneponãmary tomatonanohse roropa oya, ytapyĩ taono? tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ynara tykase Jako eya: — Enaromỹke exiase, oẽxiry tõ puxihkary ropa oya zuno exiase, jamihmehxo oexiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Yrome oneponãmary eneryhtao oya yna maro, mokyro, omato etapako. Wekyry tõ neneryme omõkomory eneryhtao oya yna maro, aroko ropa. Tuaro pyra Jako kynexine, Rapão neponãmary enehtopõpyry poko Rakeu a. ");
INSERT INTO apyNT_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tomõse Rapão Jako tapyĩ taka, Reia tapyĩ taka, toto poetory tapyĩ taka roropa, yrome tyneponãmarykõ onenepyra kynexine. Mame Rakeu tapyĩ taka tomõse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Tupise eya repe. Yrome tykyryry onenepyra tokurehse ynororo. Ineponãmary tonẽse Rakeu a kameru kyryry aka, epona typorohse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Tumy a ynara tykase Rakeu: — Yzehno pyra exiko, owõsaromepyra ase oẽpataka; munume ase. Moro sã tykyryry tupise Rapão a repe. Yrome onenepyra tokurehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Mame tyenonohse Jako, ynara tykase ynororo Rapão a: — Oty azahkuru ehtoh tyrise ya? Oty yriase popyra, jekahmatohme oya yzehno exikety samo? ");
INSERT INTO apyNT_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Seromaroro ykyryry tõ poko mexi emero porehme. Okyryry meneno jemah po? Okyryry tonese oya ahtao, tyriko kehko jarãnaka imehnõ neneryme emero porehme. Kuapiakãko mã toto: onoky zae pyra hnae omoro? Ywy? Onoky zae nae? ");
INSERT INTO apyNT_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","20me jeimamyry toerohse jahtao opoetoryme oeky tõ emũkuakehpyra kynexine, kaneru tomo te, poti tõ roropa. Oeky tõ onõpyra exiase roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Tosekase oeky tõ ahtao onokyro a ekepyry akoĩpyry onenehpyra exiase oya. Yrome ya rokẽ topehmase mokyro epehpyryme. Oeky tõ tomatonanohse ahtao, ya rokẽ topehmase toto oya tarose ahtao koko te, saereme, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ynara sã exiase: saereme ahtao xixi jetũ toehse ya, koko roropa tykõxitapãse exiase. Tuhke tõmehse ywy nyhpyra rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","20me jeimamyry taropose ya atapyĩ tao. 14me jeimamyry toerohse ywy oẽxiry tõ asakorõkõ apoitohme ya. Mame 6me jeimamyry aropoase oeky tõ apoitohme. Moro poko jahtao jerohtoh tuhponamazomose ropa oya 10me. ");
INSERT INTO apyNT_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ritonõpo ytamuru tõ Esẽ ymaro pyra ahtao, Aparão Esemy te, Izake Esẽ roropa, oya tonehpose jahtao tymõkomoke pyra jexiry ipunaka. Yrome jetuarimatopõpyry tonese Ritonõpo a, jerohtopõpyry roropa, naeroro kokonie koko õsenety ae zae ehtoh tonepose oya. ");
INSERT INTO apyNT_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ynara tykase Rapão Jako a: — Moxiã jẽxiryme mã toto. Ipoenõ roropa wekyryme mã toto. Moxiã kaneru tõ te, poti tõkehko jekyme mã toto. Ajohpe pyra senohne emero ymõkomoryme nase. Yrome seromaroro jẽxiry tõ anarosaromepyra ropa jexiryke ytapyĩ taka, moroto toto ehtohme toto poenõ maro, ");
INSERT INTO apyNT_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","soturune zae rokẽ kuehtohme oseya. Topu tõ syrine otuotuhpokoxi wenikehpyra kuehtohme kuomihpyry poko. ");
INSERT INTO apyNT_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Mame topu tapoise Jako a xikihme tyritohme. ");
INSERT INTO apyNT_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jekyry tomo a topu tõ tonehse, epona tyritohme. Mame moro kaetoko tyrikehse ahtao eya xine tõtuhse toto moroto topu tõ myhto. ");
INSERT INTO apyNT_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Moro tosehpase Rapão a Jekaa-Saatutame. Jako a tosehpase Kareeteme. ");
INSERT INTO apyNT_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Mame ynara tykase Rapão: — Sero kaetokõ, topu tõ kutuarõtanohpõko mana wenikehpyra kuehtohme kuomihpyry poko oseya. Morara exiryke moro esety Kareeteme toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Tosehpase roropa Mixipame, ynara tykase Rapão exiryke: — Ritonõpo kuenẽko ro mana tãtapiakase kuahtao! ");
INSERT INTO apyNT_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Jẽxiry tõ ryhmaryhtao oya te, imehnõ nohpo apoiryhtao oya opytyme, zuaro pyra jahtao ro wenikehpyra exiko Ritonõpo kuenẽko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Sero nase kaetokõ topu tomo, sero topu xikihmã roropa kynyrihpyry kyrãnao. ");
INSERT INTO apyNT_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Sero kaetokõ maro, xikihmã maro kutuarõtanohpõko mana wenikehpyra kuehtohme kuomihpyry poko oseya. Mya ytopyra ase oryhmase te, omoro roropa xiaro oehpyra etonatohme ymaro. ");
INSERT INTO apyNT_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ritonõpo, Aparão Esemy, Naoa Esẽ roropa Kuapiakaneme mana. Mame Ritonõpo, tumy Izake Esẽ netaryme, tõmiry totapose Jako a moro omipona ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Toky toiro totapase eya tynekaroryme, moroto ypy po. Mame tyekyry tõ tykohmase eya otuhtohme tymaro. Tõtuhse toto, tõmehse toto moroto ypy po. ");
INSERT INTO apyNT_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Yrokokoro towõse ropa Rapão pakeimo, tõxiry tõ typohse typakõ maro. Kure rokẽ tyripose toto eya Ritonõpo a. Mame toytose ropa ynororo tynonory pona ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Mame toesyryhmase roropa Jako toytotohme. Tõseporyse ynororo Ritonõpo nenyohtyã maro. ");
INSERT INTO apyNT_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Tonese toto ahtao, ynara tykase ynororo tyya rokene: — Sero, Ritonõpo esaryme taro nah? Naeroro moroto tosehpase eya Maanaĩme. ");
INSERT INTO apyNT_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Mame tõmiry aronanõ tonyohse Jako a Seia pona (moroto esety akorõ Etõme kynexine) oseporyse Ezau maro, ");
INSERT INTO apyNT_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ynara katohme eya: “Ywy, Jako, opoetoryme ase. Eo, Rapão, maro exiase. ");
INSERT INTO apyNT_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Pui tõ nae ase te, jumẽtu tomo te, kaneru tomo te, poti tomo te, ahno roropa ypoetory tõ nae orutua komo te, nohpo tomo, enara. Morara exiryke jomiry enehnanõ enyohno oya ourutohme osepeme kuehtohme.” ");
INSERT INTO apyNT_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tooehse ropa aomihpyry aronanomo. Ynara tykase toto: — Orui, Ezau maro ynanexiase. Oehnõko mana oeporyse. 400me orutua kõ maro oehnõko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Mokaro omiry etaryke tyya enaromỹke toehse Jako, torẽtyke ipunaka. Naeroro tymaro exiketõ tapiakase eya asakoro oximõme toto ehtohme. Ahno te, kaneru tomo te, poti tomo, pui tomo, kameru tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ynara tõsenetupuhse ynororo: osetapary se Ezau ahtao, toiro oximõmãkõ totapase ahtao eya, otarame zakorõ oximõmãkõ epãko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Moromeĩpo tõturuse ynororo Ritonõpo a: — Jomiry etako Ritonõpo, Tam Aparão Esemy, Papa Izake Esẽ roropa! Oya tonehpose ywy, oehtohme ropa xiaro, ynonory pona ropa, wekyry tomo a. Õmiry metapoase ya, ynara mase: “Kure rokẽ orĩko ase,” mase ya. ");
INSERT INTO apyNT_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ywy popyra rokẽ exiase oneneryme, yrome kure mexiase ya, opoetoryme ase, õmihpyry ae ro. Tuna Joatão takuohse ya ahtao ymyxiry rokẽ nae exine. Seromaroro oehnõko ropa ase moxiã oximõmãkõ asakoro maro; ahno tomo te, okyno tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ritonõpo, kuewomako jetapara urui Ezau ehtohme. Enaromỹke ase, jetapary zuno ase eya, nohpo tõ maro, ypoenõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Wenikehpyra exiko õmihpyry poko: “Kure rokẽ orĩko ase te, apakomotyã tuhke exĩko, ekuhpỹme isawã samo tuna konõto ehpio,” katopõpyry. ");
INSERT INTO apyNT_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Moroto tõmehse ynororo. Moromeĩpo okyno tymenekase eya ekarotohme tynekaroryme Ezau a. ");
INSERT INTO apyNT_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200me poti nohpo tõ tymenekase eya, 20me poti orutua kõ maro, 200me kaneru nohpo tomo te, 20me kaneru orutua kõ maro, ");
INSERT INTO apyNT_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30me kamera nohpo tomo, tumũkue exiketomo, ipoenõ suhsu ẽnõko ro exiketomo te, 40me pui nohpo tomo te, 10me pui orutua kõ maro, 20me jumẽta tomo te, 10me jumẽtu tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Mokaro tapiakase Jako a oximõme tyrise toto. Mame typoetory toiro tyrise eya oximõmãkõ eneneme. Ynara tykase ynororo typoetory tomo a: — Ytotoko osemazuhme, atakenaka, atamekehme sã ehtoko, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ynara tykase Jako typoetory osemazupu a: — Tooehse Ezau ahtao oya, ekaropõko mana oya: “Onoky mokyro oesemy? Aza ytõko mah? Onoky moxiã esemy?” ãko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ynara ãko mase eya: “Moxiamo opoetory Jako eky tomo. Inekarory tosemy a Ezau a,” kaxiko eya. “Oehnõko mã ynororo okomino,” kaxiko eya, tykase ynororo typoetory tõ osemazupu a. ");
INSERT INTO apyNT_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Oximomãkõ ĩkaponato komo a roropa, ynara tykase: — Ezau eneryhtao oya, morararo kaxiko eya, oxisamo. ");
INSERT INTO apyNT_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Wenikehpyra ehtoko. Ynara kahtoko: “Opoetory Jako oehnõko okomino,” kahtoko eya. Ynara osenetupuhnõko Jako kynexine: “Urui kuremãko ropa ase ynekarory tõ ke, osemazuhme ynaropotyã ke. Tõseporyse jahtao imaro otarame azahkuru jehtopõpyry korokapõko mana.” ");
INSERT INTO apyNT_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Moro sã toky tõ tonyohse Jako a osemazuhme, tõmehse ynororo moroto tosary po. ");
INSERT INTO apyNT_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Moro kohmamyry ae ro towõse ropa Jako, iporiry Japoke akuohtohme. Tymaro typyxiã asakoro tarose eya, ipoetory tõ typyxiãme aexityã maro, toto mũkuru tõ 11mãkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Mame moro iporiry takuohse ahtao ahno a emero, toky tõ emero taropose eya tymõkomory maro. ");
INSERT INTO apyNT_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yrome ynororo rokẽ tõxinomose toiroro. Mame orutua tooehse eya. Tãtatapoise imaro ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Jako onyporemãkaposaromepyra toexiry waro toehse ynororo ahtao, ipety tytemuhmase eya, tysokorohmase eya. ");
INSERT INTO apyNT_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","— Kurumekakoh jepe! Ẽmehnõko nase, tykase mokyro Jako a. — Arypyra, orumekara ase kure jyripopyra ro awahtao, tykase Jako. ");
INSERT INTO apyNT_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mame tõturupose eya: — Onoky oesety? tykase. — Ywy ase Jako, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","— Taroino tyoro oesehpãko ase, Jakome pyra, tykase ynororo. Tãtatapoise oexiryke Ritonõpo maro te, ahno maro roropa, orẽpyra mexino. Naeroro oesety Izyraeume exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","— Kuruko, onoky oesety? tykase Jako. — Oty katoh jesety poko ekaropõko mah? tykase ynororo. Mame kure rokẽ tyripose ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ynara tykase Jako: “Ritonõpo eneno osẽpataka. Yrome orihpyra ywy, isene ro ase.” Naeroro moro tosehpase eya Penieume. ");
INSERT INTO apyNT_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Xixi tutũtase, Penieu poe Jako toytose ahtao. Sekunahme toytose ynororo ipety tytemuhmase Ritonõpo nenyokyhpyry a exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Seroae ro okyno pety pũ onõpyra Izyraeu pakomotyamo, moro poko tytamurukõ tytemuhmase Ritonõpo nenyokyhpyry a exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ezau oepyry eneryhtao Jako a, 400mãkõ maro, typoenõ tapiakase eya oxioximõme toh tyrise eya Reia maro te, Rakeu maro te, inamoto nohpo tõ asakoro maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Inamoto tõ typoenõ maro tyrise eya osemazuhme. Imeĩpo Reia typoenõ maro. Mame etyhpyryme Rakeu tumũkuru Joze maro. ");
INSERT INTO apyNT_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Imeĩpo mokaro kuroko toytose Jako osemazuhme ehtohme. Tosekumuru po typorohse ynororo tõmyty po nono pokoxi. 7me moro sã typorohse ynororo Ezau ẽpataka oseporytohme turui maro. ");
INSERT INTO apyNT_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Yrome tururume toytose Ezau oseporyse Jako maro. Atapory ae tãtapoise toto tõseahmatohkõme. Takorõ typohse roropa eya. Tyxitase toto asakoro ro. ");
INSERT INTO apyNT_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Mame tomye tõsenuhmase Ezau ahtao, nohpo tõ eneryke tyya ipoenõ maro tõturupose ynororo: — Onokãkõ moxiamo amaro exiketomo? tykase Ezau. — Umũkuru tõ moxiamo Ritonõpo nekarohpyry opoetory a, tykase Jako. ");
INSERT INTO apyNT_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Mame ipyxiã namoto tõ asakoro toeporehkase typoenõ maro, toepuise toto Ezau ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Imeĩpo Reia tooehse typoenõ maro, toepuise roropa toto. Etyhpyryme Rakeu tooehse Joze maro, toepuise roropa toto Ezau ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Mame tõturupose Ezau: — Otara mokaro okyno tõ oximõme exiketomo, enẽ toto osema tao? Ynara tykase Jako: — Mokaro oya ynekarory tomo. Ynara tõsenetupuhse ywy. Mokaro ke ynekaroryme osepeme exĩko ropa ase urui maro. ");
INSERT INTO apyNT_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ynara tykase Ezau: — Ymõkomory ipune nase ya, aimo. Omõkomory ikurãkako omõkomoryme. ");
INSERT INTO apyNT_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yrome Jako otuhparo kynexine. Ynara tykase: — Ajohpãme sã, apoiko toto oekyme. Ynekaroryme mã toto tãkye jexiryke oẽmyty enery poko ya. Tonese ywy oya yrome yzehno pyra mase. Naeroro oẽmyty eneryke ya Ritonõpo ẽmyty enery samo typynanohse oya jexiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ajohpãme sã ynenepyhpyry apoiko ynekarory oya. Kure rokẽ tyrise ywy Ritonõpo a. Emero ise jehtoh tokarose ya, tykase ynororo. Otuhparo Jako exiryke inekarohpyry tapoise Ezau a. ");
INSERT INTO apyNT_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","— Kure, ehmaropa, tykase Ezau. — Ywy ytõko ase osemazuhme. ");
INSERT INTO apyNT_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yrome ynara tykase Jako eya: — Tuisa, tuaro mase moxiã poetohti jamihme pyra mã toto. Osenetupuhnõko ase roropa kaneru tõ poko, pui tõ poko roropa typoenoke exiketomo. Axĩ toto taropose ahtao, toiro ẽmepyry rokẽ ahtao ro, otarame orihnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kurehxo osemazuhme oytory. Ywy opoetoryme okomino ytõko, axĩ pyra okyno tõ ekahmãko poetohti maro, eporehkatoh pona, Etõ pona, oesaka, tykase Jako Ezau a. ");
INSERT INTO apyNT_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Mame ynara tykase Ezau: — Morara ahtao ah ypoetory tõ amaro nytõ toto, ãkorehmatohme, tykase Ezau. Yrome Jako a tozuhse: — Takorehmanekõ se nymyry pyra mã toto. Toiro se rokẽ ase oya. Osepeme se rokẽ ase amaro, tuisa. ");
INSERT INTO apyNT_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Mame moro ae ro toytose ropa Ezau tosemary ae ropa Etõ nonory pona. ");
INSERT INTO apyNT_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yrome Jako toytose Sukote pona. Moroto tõsesarise ynororo. Tapyi tyrise eya tytapyĩme. Tapyi tõ tyrise roropa eya toky tõ tapyĩme. Morara exiryke moroto tosehpase eya xine Sukoteme. ");
INSERT INTO apyNT_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Moro sã kynexine Jako oehtopõpyry ropa Mesopotamia poe Kanaã pona. Kure rokẽ toeporehkase ynororo pata Xikẽ pona, osesarise moro pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Mame tupito topekahse eya Hamoa mũkuru tõ wino, Xikẽ zumy. 100me parata ke topehmase eya moro tupito tosaryme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Moroto apoto apõ tyrise eya, ipoko tymerose Ritonõpo esety, Izyraeu tõ Esemy. ");
INSERT INTO apyNT_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Morarame Tina Jako ẽxiryme kynexine Reia maro. Toytose ynororo pata pona imehnõ oryximãkõ enese. ");
INSERT INTO apyNT_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Moroto Hamoa, heweume exikety, tuisame kynexine. Tumũkue kynexine ynororo esety Xikẽ. Tina tonese eya, tapoise eya, ipoko toehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mame ise moino toehse ynororo, typenetase ynororo ipoko. Morara exiryke typytyme apoiry se kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ynara tykase ynororo tumy a: — Mokyro oryximã ekaropoko, papa, ypytyme aehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jako tuaro toehse tõxiry maro Xikẽ ehtoh poko. Yrome ipoenõ kynexine ona po erohnõko, pui tõkehko poko. Morara exiryke “Teh” tykase rokẽ ynororo, toto oehtoh ropa eraximãko. ");
INSERT INTO apyNT_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Mame oehpyra ro toto ahtao toytose Hamoa, Xikẽ zumy, oturuse Jako maro. ");
INSERT INTO apyNT_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Morarame toeporehkase Jako mũkuru tõ ahtao, tuaro toehse toto toryxirykõ poko Hamoa mũkuru maro ehtoh poko. Tyekĩtapãse toto yronymyryme. Xikẽ zehno toehse toto inyrihpyry xihpyry poko. Popyra kynexine eya xine Jako ẽxiry maro aehtopo. Moro zae pyra kynexine ipunaka eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Yrome ynara tykase Hamoa eya xine: — Oẽxiry se umũkuru Xikẽ mana. Typytyme se mã ynororo. Ajohpãme sã ah nerẽnã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Morara ahtao oxiekyryme exĩko sytatose. Erẽnãko ynanase oẽxiry tõ maro. Amarokõ roropa pytãko yna ẽxiry tõ maro matose. ");
INSERT INTO apyNT_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Taro ehtoko yna maro, yna nonory po. Oesarykõ menekãko matose ise oehtohkõ menekãko. Osepekahnõko matose yna a. Tupito esẽme exĩko roropa matose. ");
INSERT INTO apyNT_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Mame ynara tykase Xikẽ Tina zumy a, ipiry tomo a roropa: — Ajohpãme sã mose ekaroko ya. Oepehmatorỹko ase ise oehtohkõ ekarõko ase oya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ekaropotoko ya: Oty se hmatou? Oepehmatorỹko ase mose epehpyryme, mame mose ekaroko ya ypytyme. ");
INSERT INTO apyNT_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Morarame toryxirykõ tyyryhmase Xikẽ a exiryke, ipoko toehse exiryke, azahkuru tozuhse jumy Hamoa eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ynara tykase toto eya: — Yna oryxiry onekarosaromepyra ynanase orutua a jaĩpotapihpyry onysahkapyny a, yna ehxiroryino. ");
INSERT INTO apyNT_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Yna omiry etapõko ynanase oya xine ynara toehse awahtao xine. Amarokõ orutua kõ yna sã toehse awahtao xine, ãĩkõpotapihpyry tysahkase oya xine ahtao yna samo. ");
INSERT INTO apyNT_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Morara awahtao xine yna ẽxiry tõ maro pytãko matose. Oẽxirykõ maro pytãko ynanase. Osesarĩko ynanase oesao xine. Oximaro exĩko sytatose oxiekyryme roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Yrome morara se pyra awahtao xine, ãĩkõpotapihpyry onysahkara awahtao xine ytõko ynanase taroino. Yna oryxiry arõko ynanase, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Morara kary etaryke tyya xine, ỹme toehse Hamoa, imũkuru Xikẽ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Okynã pyra tyaĩpotapihpyry tysahkapose Xikẽ a, typenetase toexiryke Jako ẽxiry poko, imaro torẽnary se roropa toexiryke. Hamoa tapyĩ tao imũkuru Xikẽ imehxo exiketyme kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Moromeĩpo Hamoa toytose tumũkuru Xikẽ maro pata omõtoh pona. Moroto oximõtoh kynexine oturutohme, osepekahtohme, enara. Ynara tykase toto pata põkomo a: ");
INSERT INTO apyNT_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","— Mokaro yna epeme mã toto. Ah tytapyĩkõ rĩ toto taro, osepekahnõko te, kuesarykõ mã ipune toto esaryme roropa. Pytãko sytatose toto ẽxiry tõ maro. Pytãko roropa mã toto kuẽxirykõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mame tõmirykõ etapõko mã toto kyya xine oxiekyryme kuehtohkõ poko kuaĩkõpotapihpyry tysahkase ahtao rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mame mokaro ekykõ, pui tõkehko emero kuekykõme roropa exĩko mã toto. Naeroro ỹme kuahtao xine toto nyripohpyry poko osesarĩko mã toto kymaro xine ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Morara kary etaryhtao tyya xine, ỹme toehse toto, Hamoa tõ omiry etaryke tyya xine. Mame tyaĩkõpotapihpyry tysahkase eya xine porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Morarame oseruao tõmehse ahtao, mokaro orutua kõ jetũ ahtao itamurume, Jako mũkuru tõ asakoro toytose, Ximeão te, Rewi, enara. Tina piry tõ toytose, tytapemã tarose eya xine tokare pyra pata pona. Orutua kõ totapase eya xine emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamoa te, imũkuru Xikẽ roropa totapase. Moromeĩpo toryxiry tarose Ximeão a Rewi maro Xikẽ tapyĩ tae, mame toytose ropa toto. ");
INSERT INTO apyNT_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Imeĩpo totapase mokaro ahtao imehnõ Jako mũkuru tõ toytose mokaro mõkomohpyry ematonanohse, mõkomo kurã tapoise eya xine, toryxirykõ ryhmatopõpyry emetakame samo. ");
INSERT INTO apyNT_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Kaneru tõ tarose eya xine te, poti tõ maro te, pui tomo te, jumẽtu tomo te, mõkomo kurã emero, pata poe te, tupito tõ poe, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Toto tapyĩ tae mõkomo kurã tarose eya xine. Typoetoryme nohpo tõ tarose eya xine poetohti tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Mame ynara tykase Jako tumũkuru tomo a, Ximeão te, Rewi maro: — Opokoino xine tupime toehse ya. Imeimehnõ yzehno exĩko mã toto, Kanaã põkomo te, perizeu tomo te, sero nono põkõ emero. Tuhke pyra sytatose, tuhke pyra orutua komo. Yzehnotokõ tõximõse ahtao etonatohme ymaro, kyporemãkapotorỹko mã toto, kuenahkatorỹko mã toto kypoenõkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Yrome tumykõ tozuhse eya xine: — Yna oryxiry onyriposaromepyra ynanexiase emero rokẽ poko aehtohme, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Morarame ynara tykase Ritonõpo Jako a: — Atakimako oytotohkõme Peteu pona. Moroto Peteu po apoto apõ tyriko jeahmatohme. Ywy ase Ritonõpo, osenepoase oya orui, Ezau poe oeparyhtao. ");
INSERT INTO apyNT_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Naeroro ynara tykase Jako tytapyĩ taõkomo a, tymarõkõ maro emero: — Neponãmary ipahtoko, imeimehnõ neponãmarykõ, amaro xine ahtao. Oorypyrykõ ikorokapotoko te, epytoko te, upo amurutoko, ikurikasenano. ");
INSERT INTO apyNT_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Atakimatoko, Peteu pona ytõko sytatose. Moroto apoto apõ rĩko ase Ritonõpo eahmatohme kyya xine. Typynanohse ywy eya etuarimaryhtao. Morararo ymaro exikehpyra toehse ynororo emero pona toytose jahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Mame tyneponãmarykõ tokarose eya xine, panasere tõkehko tokarose roropa eya xine. Mame Jako a morohne tonẽse wewe karawario zopikoxi, pata Xikẽ pũto. ");
INSERT INTO apyNT_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Morotoino toytose toto ahtao Jako tõ zuno toehse toto, moe pyra roropa imehnõ patary kynexine, Ritonõpo poe toto zuno toehse toto. Morara exiryke Jako tõ onekahmara toh kynexine emỹpotohme. ");
INSERT INTO apyNT_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Morarame toeporehkase Jako tomo, imarõkõ maro emero Ruze pona. Moro pata esety akorõ Peteume kynexine, Kanaã nonory po. ");
INSERT INTO apyNT_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Moroto apoto apõ tyrise Jako a Ritonõpo eahmatohme. Moroto tosehpase eya “Ritonõpo, Peteu Esemy” me. Moroto tõsenepose Ritonõpo exiryke eya toepase ynororo ahtao turui kurũke. ");
INSERT INTO apyNT_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Moroto kynexine Repeka akorehmahpõ Tepora orihtopõpyry. Ekepyry tonẽse kynexine wewe kurã zopikoxi ikurenaka Peteu wino. Moroto tosehpase “Wewe Karawario Xitatohme”. ");
INSERT INTO apyNT_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Moromeĩpo toehse ropa Jako ahtao Mesopotamia poe, tõsenepose ropa Ritonõpo eya. Kure tyripose roropa ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ynara tykase ynororo eya: — Oesety Jakome mana, yrome oesety myakamãko ase; taroino Jakome pyra mase, Izyraeume oesehpãko ase. Naeroro tosehpase ynororo Ritonõpo a Izyraeume. ");
INSERT INTO apyNT_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ynara tykase roropa Ritonõpo eya: — Ywy ase Ritonõpo Jamihmehxo Exikety. Emũkuako tuhke, typakõke tuhke oehtohme. Ahno imoihme, apakõ emãnõko mã toto, tuhke exiketõme exĩko mã toto, toitoine tuisa tõme exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Sero nono ynekarohpyry Aparão a, Izake a roropa ekarõko ase oya roropa, apakomotyamo a roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Mame tõturukehse Ritonõpo ahtao Jako maro tõnuhse ynororo, moro poe toesyryhmase ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Mame topu tapoise Jako a xikihme tyritohme, moroto tymaro Ritonõpo oturutopõpyry po. Moro topu po oriu tukuãse Jako a eukuru jehnahpyry maro tynekaroryme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Moro tosehpase eya Peteume. ");
INSERT INTO apyNT_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Morarame Peteu poe toytose Jako tytapyĩ taõkõ maro, mame moe pyra toehse toto ahtao Epyrata pona, Rakeu enurutoh toehse, toxietũtose ynororo. Yrome tupime kynexine eya, okyna enurupopyra toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Morarame sam tykase itamurume ahtao, imaro exikety, nohpo ynara tykase: — Enaromyra exiko; emũkuãko mase orutuame. ");
INSERT INTO apyNT_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Yrome orihnõko Rakeu kynexine. Orihsasaka ahtao ynara tykase: — Mose esehpãko ase Penonime, tykase. Yrome jumy a tosehpase ynororo Pẽjamĩme. ");
INSERT INTO apyNT_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Moro sã toorihse Rakeu, ekepyry tonẽse Epyrata esemary ehpio. Imeĩpo Perẽme toehse moro pata. ");
INSERT INTO apyNT_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Zonẽtoh pona topu tyrise Jako a xikihme, wenikehpyra ehtohme, Rakeu ekepyry zonẽtopõpyry poko. Moroto ro mana seroae ro. ");
INSERT INTO apyNT_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Morotoino toytose Jako osesarise tapyi kaetokõ Etea esary mõpozakoxi. ");
INSERT INTO apyNT_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Morarame moroto Jako tõ toehse ahtao, imũkuru Rupẽ Pira poko toehse tumy pyty poetory, yrome ipytyme ro. Moro waro toehse Jako ahtao tyekĩtapãse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Typyty Reia maro toemũkuase 6me: Rupẽ osemazupu te, Ximeão te, Rewi te, Juta te, Isakaa te, Zepurõ, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rakeu maro toemũkuase asakoro: Joze te, Pẽjamĩ, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Pira maro Rakeu poetory toemũkuase asakoro: Tã te, Napatari, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ziupa maro Reia poetory toemũkuase asakoro: Kate te, Asea, enara. Mokaro Jako mũkuru tõ tonuruse Mesopotamia po. ");
INSERT INTO apyNT_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jako toytose tumy Izake maro ehse Mãre pona, esety akorõ Arapame kynexine, Eperõ pũto. Moroto Aparão esahpyry kynexine Izake maro. ");
INSERT INTO apyNT_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Mame 180 jeimamyry taropose Izake ahtao, ");
INSERT INTO apyNT_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","tamuhpõme toehse ynororo ahtao toorihse ynororo. Mame ekepyry tonẽse imũkuru tomo a, Ezau, Jako, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Sero Ezau pakomotyã poko, esety akorõ Etõ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezau typytase Kanaã põ maro asakoro: Ata, Erõ ẽxiry, heteume exikety te, Ooripama, Ana ẽxiry, Zipeão pary, heweume exikety roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ezau typytase ropa Pasemate maro, Iximaeu ẽxiry, Nepaiote oryxiry. ");
INSERT INTO apyNT_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ata toemũkuase Eripazeme. Pasemate toemũkuase Reueume. ");
INSERT INTO apyNT_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ooripama toemũkuase oseruao: Jeu te, Jarã te, Kora, enara. Ezau mũkuru tõ mokaro kynexine, tonuruse toto Kanaã po, moroto ynororo ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Morotoino toytose Ezau typyxiã maro, tumũkuru tõ maro, tõxiry tõ maro, tytapyĩ taõkõ maro, atameke toehtohkõme takorõ Jako maro. Tymaro toky tõ tarose Ezau a: kaneru tomo te, poti tomo te, pui tomo emero tynapoityã Kanaã nonory po. ");
INSERT INTO apyNT_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Moro turumekase Ezau a. Mokaro asakoro natokõ esaryme pune pyra Jako esary kynexine. Tokyke tuhke toto exiryke oximaro ehsaromepyra toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Morara exiryke toytose Ezau osesarise ypy tõ pona, Seia nonory po, esety akorõ Etõ. ");
INSERT INTO apyNT_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ynara Ezau pakomotyã kynexine, Etõ põkõ tamurume, moroto ypy tõ Etõ po, Seia po. ");
INSERT INTO apyNT_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Ata, Ezau pyty toemũkuase Eripazeme. Eripaze toemũkuase 5me: Temã te, Omara te, Zepo te, Kaetã te, Kenaza, enara. Typyty Timina maro toemũkuase Eripaze Amarekeme. Typyty Pasemate maro Ezau toemũkuase Reueume. Reueu toemũkuase 4me: Naate te, Zera te, Sama te, Miza, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Imepỹ nohpo maro typye Ezau kynexine Ooripama, Ana ẽxiry, Zipeão pary. Oseruao mũkuru nae ynororo kynexine: Jeu te, Jarã te, Kora, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ezau pakomotyã tuhke tomãse toto. Ezau mũkuru osemazupu, Eripaze toemũkuase ynara: Temã te, Omara te, Zepo te, Kenaza te, ");
INSERT INTO apyNT_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora te, Kaetã te, Amareke, enara. Mokaro emero Ata poenõme kynexine, Ezau pyty poenomo. ");
INSERT INTO apyNT_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Reueu toemũkuase ynara: Naate te, Zera te, Sama te, Miza, enara. Mokaro Pasemate poenõme toh kynexine, Ezau pyty poenomo. ");
INSERT INTO apyNT_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Typyty Ooripama maro, Ana ẽxiry, Ezau toemũkuase: Jeu te, Jarã te, Kora, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Mokaro emero Ezau pakomotyãme toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Mame Etõ põkõ osemazupu tõ Seia mũkuru tõ pakomotyã kynexine: Rotã te, Sopau te, Zipeão te, Ana te, Tisõ te, Esea te, Tisã, enara. Mokaro emero Seia, horeume exikety mũkurume tõ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Rotã ahno tõ tamuxiry kynexine: Hori tomo te, Homã tomo, enara. Rotã toryxike kynexine, esety Timina. ");
INSERT INTO apyNT_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sopau ahno tõ tamuxiry kynexine: Awã tomo te, Manaate tomo te, Epau tomo te, Sepo tomo te, Onã tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zipeão tumũkue asakoro kynexine: Aia te, Ana, enara. Mokyro Ana kynexine pẽkamã axitunety enehpono ona po, tumy eky, jumẽtu tõ poko aerokuruhtao. ");
INSERT INTO apyNT_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Ana toemũkuase Tisõme. Tisõ toemũkuase: Hẽtã te, Exipã te, Itirã te, Kerã, enara. Ana tõxike kynexine, esety Ooripama. ");
INSERT INTO apyNT_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esea toemũkuase: Pirã te, Zaawã te, Akã, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Tisã toemũkuase: Uze te, Arã, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Mokaro kynexine horeu tõ oxiekyryme exiketomo Etõ nonory po: Rotã tomo te, Sopau tomo te, Zipeão tomo te, Ana tomo te, Tisõ tomo te, Esea tomo te, Tisã tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ynara tuisa tõ kynexine Etõ nonory põkõ esamo. Atakenaka tuisame toh kynexine tuisa pyra Izyraeu tõ ahtao ro: ");
INSERT INTO apyNT_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Pera, Peoa mũkuru, pata Tinapa pono. ");
INSERT INTO apyNT_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Pera toorihse ahtao imyakãme Jopape, Zera mũkuru, Posora pono tuisame toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jopape myakãme Husã, Temã pono tuisame toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husã mykapo Hatate, Petate mũkuru, Awite pono tuisame toehse. Mitiã tõ typoremãkase eya Moape nonory po. ");
INSERT INTO apyNT_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hatate mykapo Samara, Masareka pono tuisame toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samara mykapo Sauu, pata Reopote-Tuna-Eupyrati pono tuisame toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sauu mykapo Paau-Hanã, Akapoa mũkuru tuisame toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Paau-Hanã, Akapoa mũkuru mykapo Hatate, Pau pono tuisame toehse (ipyty Meetapeu kynexine Matarete ẽxiry, Me-Zaape paryme). ");
INSERT INTO apyNT_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ezau pakomotyã tomãse tuhke, etomita tomo: Timina tomo, Arawa tomo, Jetete tomo, ");
INSERT INTO apyNT_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ooripama tomo, Era tomo, Pinõ tomo, ");
INSERT INTO apyNT_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaza tomo, Temã tomo, Mipisara tomo, ");
INSERT INTO apyNT_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Makatieu tomo, Irão tomo, enara. Morotõkõ esary tosehpase toto tosetykõ ae. ");
INSERT INTO apyNT_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Mame moroto toehse Jako Kanaã po, tumy esary po. ");
INSERT INTO apyNT_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Sero nase Jako tõ ehtopõpyry poko. 17me jeimamyry nae Joze ahtao, toerohse ynororo turui tõ maro kaneru tõ poko poti tõ maro. Irui tomo Pira mũkuru tõ kynexine Ziupa mũkuru tõ roropa, jũ pyxiamo. Mame tumy turuse Joze a, turui tõ nyrityã poko, azahkuru toto ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Tamuhpõme Jako kynexine tonuruse Joze ahtao. Naeroro ipynohxo kynexine irui tõ pyno ehtoh motye. Upo kurã tyripose Jako a Joze zupõme, upo mosano, apory mosano sỹsỹkamã potu. ");
INSERT INTO apyNT_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tumũkuru Joze pynohxo Jako ehtoh tonese irui tomo a, naeroro takorõkõ zumoxike toehse toto. Zehno toexirykõke xihpyryme tõturuse toto, imaro aotururuhtao. ");
INSERT INTO apyNT_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Mame tõsenehse Joze, tõsenehtopõpyry tokarose eya turui tomo a. Moro pokoino itamurumehxo takorõkõ zehno toehse toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ynara tykase exiryke eya xine: — Etatoko pahne, josenehtopõpyry poko ourutorỹko ase. ");
INSERT INTO apyNT_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Erohnõko sã exiase tupito po tiriiku myhnõko. Mõtoino rokẽ tamoreme ynymykyhpyry towõse xikihme. Zomye onymykyhpyrykõ toepuise kehko ynymykyhpyry ẽpataka, tykase ynororo turui tomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Mame tõturupose irui tomo: — Oty kary moro? Yna tuisaryme exĩko mah? Õmiry omipona exĩko ynanae? Takorõkõ zehnohxo toehse toh kynexine aosenehtopõpyry pokoino, epyrypakety sã aexiry poko roropa tõsenehtopõpyry ekaroryhtao eya. ");
INSERT INTO apyNT_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Mame tõsenehse ropa Joze, moro tõsenehtopõpyry tokarose roropa turui tomo a. Ynara tykase ynororo eya xine: — Tõsenehse ropa ywy. Morarame xixi sã enease, nuno maro, xirikuato tõ 11mãkõ maro. Mame nepuiase kehko ykyryry xirikuato ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tõsenehtopõpyry tokarose ahtao Joze a tumy a, turui tomo a roropa, tõturupose jũ eya. Ynara tykase: — Oty kary se õsenehtopõpyry nae? Asa maro ywy oẽpataka yna esekumuru po porohnõko ynanae, orui tõ maro, tuisamehxo oekarotohme? ");
INSERT INTO apyNT_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Yrome irui tõ Joze zumoxike toehse toto. Yrome jũkõ “Teh,” tykase rokene. Tõsenetupuhse rokẽ tukurohtao. ");
INSERT INTO apyNT_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Mame kaneru tõ tarose, poti tõ maro, Joze rui tomo a, ona pona pata Xikẽ pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Mame ynara tykase Jako tumũkuru Joze a: — Osehko. Aaropory se ase Xikẽ pona. Moroto orui tõ kaneru tõ otuhmapõko, poti tõ maro. — Taro ase, tãtakimase, tykase Joze. ");
INSERT INTO apyNT_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ynara tykase Jako: — Ytoko morotona orui tõ eneta, okyno tõ roropa kure toto ehtoh eneta, mame osehko ropa jurutohme toto ehtoh poko. Mame moro poe, Eperõ jakanahmã poe tumũkuru Joze taropose Jako a Xikẽ pona. Toytose ynororo. Toeporehkase ahtao morotona, ");
INSERT INTO apyNT_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ytoytõko kynexine ona poro. Moroto orutua a tonese ynororo, tõturupose eya: — Oty zupĩko hma? tykase eya. ");
INSERT INTO apyNT_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","— Urui tõ zupĩko ase. Ona po toky tõ arõko mã toto kaneru tõ nahpãko poti tõ maro. Zuaro hma, aza nytõ toto? tykase Joze. ");
INSERT INTO apyNT_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mokyro orutua ynara tykase: — Taroino toytose toto. “Ytõko ynanase Totã pona,” kary totase ya. Mame toytose Joze turui tõ zupise. Tonese toto eya Totã po. ");
INSERT INTO apyNT_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Joze tonese eya xine moino aepyryhtao. Eporehkara ro ynororo ahtao tõturupitose toto etapary poko. ");
INSERT INTO apyNT_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ynara tykase toto: — Mokyro oehnõko, osenehkety! ");
INSERT INTO apyNT_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ehmaropa, setapatone seromaroro. Imeĩpo ekepyry sẽmatone oramãka. “Tosekase onokyro a,” ãko sytatose. Morarame aosenehtopõpyry enatyry enẽko sytatose. ");
INSERT INTO apyNT_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Yrome mokaro omiry etaryke tyya, takorõ ewomary se Rupẽ toehse. Ynara tykase ynororo takorõ tomo a: — Onetapara sehtone. ");
INSERT INTO apyNT_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Sero eutary aka mokyro tyritoko, yrome onyryhmara ehtoko. Morara tykase Rupẽ, takorõ ewomary se toexiryke aropotohme ropa tumy a. ");
INSERT INTO apyNT_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Toeporehkase Joze ahtao turui tomo a, zupõ mosã tyxihkase eya xine, apory mosa exikety. ");
INSERT INTO apyNT_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Moromeĩpo takorõkõ tapoise eya xine, tõmase ynororo eya xine oramãka. Moro ao tuna pyra kynexine, tonore rokẽ zao. ");
INSERT INTO apyNT_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mame typorohse toto tõtuhtohkõme. Tõtukurukohtao tõsenuhmase toto. Iximaeu tõ tonese eya xine ytoketomo. Kireate poe toehse toto, Ejitu pona ytõko toh kynexine. Mõkomo arõko kameru tõ kynexine, ixtaratu te, kanera tõkehko. ");
INSERT INTO apyNT_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ynara tykase Juta takorõ tomo a: — Otyme kure kuakorõkõ totapase ahtao kyya xine? Imeĩpo ajohpãme exĩko sytatose onekunohtõme aorihtopõpyry poko? ");
INSERT INTO apyNT_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Sekarotone mose mokaro Iximaeu tomo a parata apoitohme kyya xine. Morarame kuakorõkõ onetapara sehtone kuakorõkõme ro exiryke. Atae toehse toto Juta maro. ");
INSERT INTO apyNT_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Mame osepekahketõ, mitianita tõ tooehse ahtao Joze touse ropa irui tomo a oramae. Tokarose ynororo eya xine 20me parata apoitohme. Mame Joze tarose Iximaeu tomo a Ejitu pona. ");
INSERT INTO apyNT_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Tooehse ropa Rupẽ tahtao oramãka tonese eya repe. Joze onenepyra moro tao. Tupõ tyxihkase eya tãtasamaryke ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Takorõ tomo a toytose ynororo. Ynara tykase: — Mokyro, aimo arypyra toehse. Seromaroro oty rĩko ywy? ");
INSERT INTO apyNT_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Mame poti totapase eya xine. Munu tyrise eya xine Joze zuponỹpyry pokona munuhpe ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Moromeĩpo zuponỹpyry sỹsỹkamã potu tarose Jako a. Ynara tykase toto eya: — Sero upo tonese yna a. Omũkuru zuponỹpyry otarame nae? ");
INSERT INTO apyNT_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Zuponỹpyry tonetupuhse Jako a. Ynara tykase ynororo: — Ỹ umũkuru zuponỹpyry sero! Tosekase otarame onokyro a, otarame tõse. ");
INSERT INTO apyNT_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Mame toemynyhmaryke yronymyryme tupõ tyxihkase Jako a, saku risẽ tamuruse eya. Tumũkuru orihtopõpyry tyhnamose eya okynano. ");
INSERT INTO apyNT_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Imũkuru tõ emero toytose Jako a, ẽxiry tõ roropa akorehmatohme omuhpe pyra aehtohme repe. Yrome tyxitary se rokẽ kynexine. — Umũkuru hnamõko ase. Onyhnamokehpyra ase joorihtoh pona ro. Morara ahtao imaro exĩko ropa ase, tykase ynororo. Xitakehpyra kynexine tumũkuru Joze poko. ");
INSERT INTO apyNT_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Morarame Joze tarose Ejitu pona. Tokarose ynororo mitianita tomo a Potipaa a, ipoetoryme aehtohme. Ejitu tuisary konõto akorehmaneme Potipaa kynexine, tapyi konõto erase tõ tuisaryme. ");
INSERT INTO apyNT_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Morara ahtao takorõ tõ turumekase Juta a, imepỹ tapyĩ taka toytotohme, mokyro esety Hira, pata Aturã pono. ");
INSERT INTO apyNT_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Moroto Juta ahtao kananeu ẽxiry waro toehse, jũ esety Sua kynexine. Typytase Juta imaro, ");
INSERT INTO apyNT_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","toemũkuase ynororo, esety Ereme. ");
INSERT INTO apyNT_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Mame poetoẽme toehse ropa ynororo, toemũkuase ropa, tosehpase Onãme. ");
INSERT INTO apyNT_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Imeĩpo toemũkuase ropa ynororo, tosehpase Serame. Kezipe po Juta kynexine tonuruse imũkuru ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Mame nohpo tymenekase Juta a tumũkuru Ere pytyme, esety Tamara. ");
INSERT INTO apyNT_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yrome Ritonõpo zamaro pyra Ere kynexine popyra exiryke, naeroro taorihmapose ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Mame ynara tykase Juta tumũkuru Onã a: — Orui pytỹpyry apoiko opytyme, emũkuatohme orui poenõme. Morara awahtao zae exĩko mase, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Yrome tuaro Onã kynexine, toemũkuase ahtao tumũkurume pyra ehtoh waro kynexine, turui mũkurume aehtoh waro. Morara exiryke turui pytỹpyry maro tahtao jeipyry tukuãse eya nono pona rokene, emũkuara toehtohme turui mũkurume. ");
INSERT INTO apyNT_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Moro poko typenekehse Ritonõpo, Onã nyrihpyry poko, naeroro totapase ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Mame ynara tykase Juta typary eny a: — Ytoko ropa omy tapyĩ taka, pytỹpome rokẽ exiko umũkuru Sera eraximatohme, tuãtase ahtao ipytyme oehtohme, tykase. Morara tykase ynororo, Sera orikyry zuno toexiryke, irui tõ samo. Naeroro toytose Tamara tumy tapyĩ taka ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Mame okynahtao Juta pyty toorihse. Tyhnamokehse ahtao toytose Juta Timinate pona toky tõ kaneru tõ hpoty sahkary enese. Tope Hira, Aturã põ maro toytose ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamara turuse imehnomo a: “Onio zũ toytose Timinate pona toky tõ kaneru tõ hpoty sahkase.” ");
INSERT INTO apyNT_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Naeroro tupõ tymyakãmase eya, pytỹpome toehtoh zupõ turumekase, tõmyty tapuruse eya kamisa ke tonetupuhpyra imehnõ ehtohme. Mame toytose ynororo porohse pata Enaĩ omõtoh pũtokoxi, Timinate esemary ae. Morara tyrise eya tuaro toexiryke Sera tuãtase repe, yrome mokyro onekaropyra Juta kynexine iniome. ");
INSERT INTO apyNT_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Mokyro eneryke Juta a tõsenetupuhse ynororo: “Mose nohpo poko se exikety mã epehpyry ekarõko imaro ehtohme, ẽmyty tapuruse exiryke.” ");
INSERT INTO apyNT_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Toytose ynororo oturuse imaro osema ehpikoxi, tuaro pyra ynororo kynexine typary ẽme aehtoh poko. Ynara tykase ynororo eya: — Otãto se hma epehpyryme ymaro oehtohme? tykase. — Oty ekarõko mah ya? tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","— Poti enehpõko ase oya, jeky tõ poe, tykase ynororo. — Ỹ, kure, tykase nohpo. — Yrome okyryry inomoko ymaro, poti enehpotohto oya. ");
INSERT INTO apyNT_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","— Oty se hma ykyryryme inomotohme amaro? tykase Juta. — Sinete te, korotão maro te, omyxiry maro, enara, tykase ynororo. Morohne tokarose Juta a eya. Imaro toehse ynororo, poetoẽme toehse nohpo. ");
INSERT INTO apyNT_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mame toytose ropa Tamara tytapyĩ taka, tupõ tymyakãmase ropa eya, pytỹpo zupõ tamuruse ropa eya, kamisa touse tõmyty poe. ");
INSERT INTO apyNT_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Moromeĩpo tope, Hira taropose Juta a poti ekarotohme nohpo a tykyryry tõ enehtohme ropa, yrome nohpo onenepyra tokurehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Tõturupose ahtao orutua komo, Enaĩ põkomo a: “Otoko na mokyro nohpo, topehke imehnõ maro exikety, taro osema ehpio kohrame exikety?” — Taro arypyra, orutua kõ poko exikety pyra taro nase, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Naeroro Hira toeramase ropa, ynara tykase ynororo Juta a: — Mokyro nohpo onenepyra tokurehse ywy. Morotõkõ orutua kõ ynara tykase ya: “Orutua kõ poko exikety pyra taro nase,” nykã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Mame ynara tykase Juta: — Ah ykyryry tõ imaro nexino. Morararo kykerekeremara imehnõ mana. Poti aropono eya repe, yrome nohpo onenepyra mexiase. ");
INSERT INTO apyNT_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Morotoino oseruao nuno taropose ahtao toytose imehnõ Juta zuruse: — Apary eny, Tamara poetoẽme mana. Otarame imeimehnõ orutua kõ mũkuru ẽme toehse ynororo, tykase toto. Ynara tykase Juta: — Mokyro nohpo enehko jarãnaka, jahkatohme! ");
INSERT INTO apyNT_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Morara exiryke enehse toytose toto ahtao itapyĩ tae, ynara tykase nohpo tymeretamuru zurutohme: “Mokyro, senohne esẽ poe poetoẽme ase. Ynoro rokẽ ypoko toehse. Senohne eneko zuaro oehtohme sinete te, korotão te, myxiry, enara.” ");
INSERT INTO apyNT_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Tonetupuhse Juta a tykyryryme morohne exiry poko. Ynara tykase ynororo: — Zae rokẽ mã ynororo; zae pyra toehse ywy. Ynara tykase ywy repe: “Umũkuru, Sera ekarõko ase oya oniome,” tykase ywy repe yrome onekaropyra tokurehse ywy. Mame ipoko exizomopyra ropa toehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Morarame enurutoh po nohpo toehse ahtao kamarame poeto ehtoh waro toehse toto. ");
INSERT INTO apyNT_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tonurupitose toto ahtao toiro emary tutũtase. Axĩ moro emary tymyhse eary tahpiremã ke. Ynara tykase mokyro enurumapone: — Mose tutũtase osemazuhme. ");
INSERT INTO apyNT_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Yrome tomary tutuyhmase ropa eya. Mokyro kamaramã tonuruse rahkene apitorymãme. Naeroro ynara tykase mokyro enurumapone: — To! Oya oesemary totapuruhmakase. Mame tosehpase ynororo Perezeme. ");
INSERT INTO apyNT_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Imeĩpo zakorõ tonuruse, emary tymyhse exikety eary tahpiremã ke, tosehpase ynororo Zerame. ");
INSERT INTO apyNT_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Mame Joze tarose Ejitu pona. Moroto tokamose ynororo iximaeu tomo a Ejitu pono a, esety Potipaa. Tuisa konõto akorehmaneme Potipaa kynexine, erase tõ tuisaryme tuisa tapyĩ konõto tao. ");
INSERT INTO apyNT_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Kure rokẽ Joze tyrise Ritonõpo a, imaro exiryke. Tosẽ Potipaa tapyĩ tao Joze kynexine, emero poko emese kure kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mame Joze maro Ritonõpo ehtoh tonese esemy a, emero poko kure rokẽ tyrise ynororo Ritonõpo a exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potipaa zamaro Joze kynexine, naeroro takorehmaneme tyrise ynororo eya. Tytapyĩ eraseme te, tymõkomory emero eraseme roropa tyrise ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Morara exiryke, Joze pokoino, kure rokẽ Potipaa tapyĩ tyrise Ritonõpo a, imõkomory maro te, itupi tõkehko maro. ");
INSERT INTO apyNT_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tykyryry tõ emero tynomose Potipaa a Joze maro ipoko erohtohme, torẽtyke pyra toehtohme morohne poko, tynapyry poko rokẽ osenetupuhno. Joze kynexine orutua kuranoryme, enekure kynexine, nuaseme roropa kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Morarame okynahtao Joze poko typenetapitose Potipaa pyty. Ynara tykase ynororo eya: — Jenaka osehko, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","— Arypyra, tykase ynororo eya. — Etako pahne. Torẽtyke pyra jesẽ mana tykyryry tõ poko, sero itapyĩ tao taro jexiryke. Tyrise ywy eya tykyryry emero eraseme, zae rokẽ erohtohme ikyryry tõ poko. ");
INSERT INTO apyNT_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Sero itapyĩ tao tuisame ase isaaro. Taro emero ise jahtao apoĩko ase. Omoro rokẽ poko pyra ase, ipytyme oexiryke. Naeroro opoko ehsaromepyra ase. Opoko jahtao zae pyra jexiry, iirypyryme jexiry roropa Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Kokoro rokẽ Joze tukuhse nohpo a repe: — Jenaka osehko, tykase ynororo eya. Yrome nohpo omiry onetapỹ sã Joze kynexine. Ameke rokẽ toehse ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Morarame ẽmepyryme tomõse Joze tosẽ tapyĩ taka erohse, kokoro rokẽ saaro, yrome imehnõ erohketõ pyra kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Zupõ tapoise nohpo a, ynara tykase: — Osehko jenaka, tykase. Yrome toepase ynororo, jarãnaka. Tupõ rokẽ tynomose eya. ");
INSERT INTO apyNT_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Moro eneryke nohpo a, toeparyme zupõ tynomose Joze a tomary ao, ");
INSERT INTO apyNT_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","typoetory tõ tykohmase tyya, ynara tykase ynororo eya xine: “Enetoko ke! Mokyro epereu, ynio nenepyhpyry tapyi taka, yna osanumary se mana. Jynyhtoh taka nomõno ypoko toehtohme repe, yrome kui tykase ywy opore. ");
INSERT INTO apyNT_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Mame kui tykase jahtao toepase ynororo, tupõ rokẽ tynomose eya,” tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Joze zupõ tukurãkase nohpo a tynio oehtoh pona ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Mame tooehse ropa inio ahtao turuse ynororo morararo ajohpe rokene. Joze tyhxirose eya, ynara tykase: “Mokyro opoetory epereu, onenepyhpyry tapyi taka, nomõno jynyhtoh taka ypoko ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Yrome kui tykase ywy opore. Naeroro toepase jarãnaka ynororo. Tupõ rokẽ tynomose eya jynyhtoh tao,” tykase ynororo tynio a. ");
INSERT INTO apyNT_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mame typyty omiry etaryke tyya tyekĩtapãse Joze esemy. ");
INSERT INTO apyNT_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Joze tapoise eya, tõmase ynororo eya ãpuruhpyry taka, tuisa konõto nẽmapotyã maro ehtohme, moroto Joze toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yrome Ritonõpo imaro kynexine, kure rokẽ tyrise ynororo eya, ãpuruhpyry esẽ zamaro toehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Joze tyrise eya mokaro ãpuruhpyry taõkõ tuisaryme. Ãpuruhpyry esẽ akorehmaneme toehse ynororo emero poko ãpuruhpyry tao. ");
INSERT INTO apyNT_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mokyro ãpuruhpyry esẽ torẽtyke pyra toehse, emero tokarose eya Joze a tyritohme, Ritonõpo imaro exiryke. Kure rokẽ Joze tyrise Ritonõpo a emero poko aerohtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Morarame okynahtao typoetory tõ asakoro natokõ zehno toehse Ejitu tuisary. Tõkuru rinanõ tuisary te, turu rinanõ tuisary, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Mokaro poko tyekĩtapãse tuisa konõto kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Tõmase toto eya ãpuruhpyry taka, soutatu tõ tuisary tapyĩ tao. Moro tao roropa Joze kynexine ãpuruhpyry tao. ");
INSERT INTO apyNT_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Moroto tapuruse okynahxo mokaro asakoro kynexine. Toto eraseme Joze tyrise tapyi esemy a. ");
INSERT INTO apyNT_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Mame moroto ãpuruhpyry tao, koko tõsenehse eukuru rihpono, morararo wyi rihpono roropa tõsenehse. “Oty kary se hnae josenety?” tykase toto tyya xine rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Tõmehse ahtao mokaro asakoro tonese Joze a. Torẽtyke toehse toto tõsenehtopõpyrykõ poko. ");
INSERT INTO apyNT_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","— Oty katohme karime hmatou seroae? tykase ynororo eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","— Tõsenehse yna koko. Yrome tuaro exikety pyra nase yna amorepatohme yna osenehtopõpyry poko, tykase toto eya. — Ritonõpo mã tuaro, õsenehtopõpyry enetupuhpõko mana, tykase Joze eya xine. — Kurutoko õsenehtopõpyrykõ poko, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Mame mokyro eukuru rihpono a tõsenehtopõpyry tokarose eya. Ynara tykase ynororo: — Osenehno ynara, uwa zoko sã nexiase jẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Oseruao amoriry sã nexiase zoko poko. Tarỹtase ahtao tokutase, toperytase roropa, uwa epery toehsehxo exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Jemah po eukuru ẽ sã nexiase, tuisa kyryry, kopu; naeroro uwa eukuru euhkase kopu aka ekarotohme tuisa a. ");
INSERT INTO apyNT_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ynara tykase Joze: — Ynara enetupuhnõko ase, moro uwa amoriry oseruao ẽmepyry oseruao ehtoh enetupuhtohme mana. ");
INSERT INTO apyNT_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Taroino oseruao tõmehse ahtao tũtãko ropa mase sero ãpuruhpyry tae. Oerohtoh pona ytõko ropa mase, eukuru ekarõko ropa mase tuisa a apitoryme oehtopõpyry saaro. ");
INSERT INTO apyNT_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Yrome kure toehse oya ahtao wenikehpyra exiko ypoko. Ajohpãme sã oturuko ypoko tuisa konõto a. Kuakorehmako jutũtatohme ropa sero ãpuruhpyry tae. ");
INSERT INTO apyNT_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tapoise ywy imehnomo a jesary po jahtao. Tonehse ywy xiaro Ejitu pona. Taro Ejitu po azahkuru exipitopyra exiase. Zae pyra nase juãnopyry sero ãpuruhpyry tao, tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Morara kary etaryke tyya wyi rinanõ tuisary kure Joze otururu totase tyya ahtao, tõsenehtopõpyry tokarose eya. — Ywy roropa tõsenehse koko. Jupuhpyry po ruto oseruao puimãko sã exiase, wyi ke pehme. ");
INSERT INTO apyNT_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Toiro ruto ao, kae exikety ao, tyotyoro pão tõkehko nexiase zao tuisa konõto zuru panono. Mame morohne enahnõko sã torõ tõ kynexine josenety, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Morarame ynara tykase Joze: — Ynara kary se õsenehtopõpyry mana: moro oseruao ruto ẽmepyry oseruao ehtoh enetupuhtoh moro. ");
INSERT INTO apyNT_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Taroino oseruao tõmehse ahtao tuisa konõto aarõko sero ãpuruhpyry tae. Opuhpyry kohpõko mana. Oekepyry rĩko mana wewe pona. Opũ enahnõko torõ tõ mana. ");
INSERT INTO apyNT_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Morarame oseruao tõmehse ahtao otuhtoh tyrise tuisa konõto a aniwesario poko oseahmatohme. Typoetory tõ emero toahmase eya. Mokaro asakoro tutũtanohpose eya ãpuruhpyry tae: eukuru rinanõ tuisary te, wyi rinanõ tuisary maro otuhtoh pona toto ytotohme. ");
INSERT INTO apyNT_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","22","Mame morara toehse Joze omihpyry ae ro: eukuru rinanõ tuisary taropose eya aerohtoh pona ropa uwa eukuru ke tuisa ohpatohme ropa. Yrome mokyro wyi poko erohketõ tuisary taorihmapose eya. ");
INSERT INTO apyNT_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yrome Joze poko tuenikehse mokyro eukuru poko erohketõ tuisary. Tuenikehse ynororo ipoko ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Morarame asakoro ikonopory taropose ahtao tõsenehse Ejitu tuisary. Aosenety xikihme sã kynexine tuna Niro ehpio. ");
INSERT INTO apyNT_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Mõtoino rokẽ tuisa osenuhmaryhtao pui tõ 7me tokuõse nakuae tupune exiketomo. Mame onahpoty tonahpitose sã eya xine tuna ehpikuroko. ");
INSERT INTO apyNT_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Moromeĩpo tutũtase tuna kuae imehnõ 7me pui tomo xihpyryme tupune pyra exiketomo. Toytose toto, oximaro toehtohkõme, osemazuhme aekuõtyã maro, tuna ehpio. ");
INSERT INTO apyNT_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Mame mokaro pui tõ 7mãkõ tupune exiketõ tõse tupunãkara a, xihpyrymãkomo a. Mame typakase ropa tuisa. ");
INSERT INTO apyNT_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Yrome tynyhse ropa mya roropa ynororo. Mame tõsenehse ropa ynororo, 7me oxinase epery poko; oxinase kurãkomo, pehme ipuhturu ke. ");
INSERT INTO apyNT_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Moromeĩpo 7me oxinase epery xihpyry sã tonese eya tonore, tyahse tyryrykane axitunety ke. ");
INSERT INTO apyNT_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Mame moro 7mãkõ oxinase kurã tonahse moro 7me xihpyrymãkomo a. Typakase ropa tuisa: osenehnõko kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Tõmehse ahtao torẽtyke toehse ynororo. Naeroro tuaro exiketõ tykohmapose eya, Ejitu põkomo, oximõme toto oehtohme. Tõsenehtopõpyry tokarose eya xine repe. Yrome zuaro pyra toh kynexine emero. Oty moro? Zuaro pyra ynanase ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Mame tuisa okuru rinanõ tuisary tutuarõtase ropa Joze poko. Ynara tykase ynororo tuisa konõto a: — Seromaroro zae pyra jehtopõpyry ekarõko ase oya. ");
INSERT INTO apyNT_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pake yzehno toehse mexiase, wyi rinanõ tuisary roropa zehno mexiase. Yna maropoase ãpuruhpyry taka, soutatu tõ tuisary tapyĩ tao. ");
INSERT INTO apyNT_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Moro tao jahtao tõsenehse yna koko. Yrome yna osenehtopõpyry oxisã pyra nexiase. ");
INSERT INTO apyNT_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Moroto ãpuruhpyry tao yna maro nuasemã epereu nexiase, ãpuruhpyry esẽ namotome. Yna osenehtopõpyry poko turuse yna eya. Mame yna osenehtopõpyry tonetupuhse eya. ");
INSERT INTO apyNT_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Zae toehse aomiry: toytose ropa ywy jerohtoh pona ropa aomihpyry ae ro. Mokyro wyi rinanõ tuisary taorihmapose aomihpyry ae ro, ouhkapõko ma oesemy, katopõpyry ae ro eya. ");
INSERT INTO apyNT_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Mame Joze tykohmapose tuisa a. Toytose toto taryporyke enehse ãpuruhpyry tae. Tõsetypokase ynororo, upo kurã tamuruse eya. Toehse ynororo tuisa ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ynara tykase tuisa eya: — Tõsenehse ywy. Yrome josenehtopõpyry waro pyra mokaro kynako emero. Mokyro osenehtopõpo waro mana, ãko mã toto opoko. ");
INSERT INTO apyNT_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","— Ywy kara, tykase Joze. — Ritonõpo tuaro ehtoh ekarõko mana, kure rokẽ oritohme, tykase Joze. ");
INSERT INTO apyNT_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Mame ynara tykase tuisa eya: — Tõsenehse ywy: Xikihme sã exiase tuna Niro ehpio. ");
INSERT INTO apyNT_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","7me pui nohpo kurãkõ enease josenety, tupune exiketomo. Tokuõse toto nakuae. Onahpoty tonahpitose eya xine tuna ehpikuroko. ");
INSERT INTO apyNT_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Moromeĩpo imehnõ 7me pui tõ xihpyrymãkomo tokuõse, tupune pyra exiketomo. Mokaro panõ onenepitopyra ywy Ejitu po. Imehnõ motye emero xihpyrymehxo toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Mame mokaro pui 7mãkõ kurãkõ tõse sã mokaro pui xihpyrymãkomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Yrome etyorõmara nexiase toto xihpyrymãkomo. Tupune pyra xihpyryme ro toh nexiase, apitorymã saaro nexiase toto. Mame typakase ropa ywy. ");
INSERT INTO apyNT_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Moromeĩpo tõsenehse ropa ywy. 7me oxinase enease topere tyerẽ kurã samo, toiro zoko poko. ");
INSERT INTO apyNT_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Imeĩpo nutũtase oxinase, moro saaro 7me. Yrome tysapakãse nexiase epery ehmataono. ");
INSERT INTO apyNT_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Moro oxinase 7me toporemy tonahse moro 7mãkõ xihpyrymãkomo a. Josenehtopõpyry ekaroase tuaro exiketomo a, yrome onenetupuhpyra nexiase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Mame ynara tykase Joze tuisa a: — Õsenehtopõpyry asakoro oxisã mã kehko. Tuaro oehtohme tynyriry tonepose oya Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Mokaro 7me pui nohpo kurã, tupune exiketõ mã 7me jeimamyry enetupuhtohme mã toto. Moro 7me oxinase kurãkomo morararo mana. Õsenehtopõpyry asakoro oxisã mã kehko. ");
INSERT INTO apyNT_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Mokaro pui tõ tupune pyra, xihpyryme exiketõ tokuõse nakuae mokaro 7mãkõ kurãkõ mykapo te, moro oxinase roropa isapakamyhpyry 7mãkomo 7me jeimamyry enetupuhtoh moro, tonahsã pyra exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Morara ykã oya: Ritonõpo a tynyriry tonepose oya, tuisa, tuaro oehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","7me jeimamyry exĩko mana: itamurume tonahsã nae exĩko mana Ejitu po. ");
INSERT INTO apyNT_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Moromeĩpo 7me jeimamyry ehtopo tonahsã pyra exĩko mana konopo pyra exiryke. Morara toehse ahtao apotũkehnõko mã toto sero põkomo tomirykõke. ");
INSERT INTO apyNT_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Mame wenikehnõko mã toto tonahsã itamurume nae toehtopõpyrykõ poko Ejitu po. ");
INSERT INTO apyNT_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Taosenehkazomopose omoro ynara katohme: moro sã tyrĩko Ritonõpo mana, katohme oya tuaro oehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tõturuse ro Joze: — Morara exiryke kure orutua menekary oya, tuisa, ãkorehmaneme tuaro exikety. ");
INSERT INTO apyNT_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kure roropa imehnõ menekary ytotohme sero nono poro tonahsẽ apoitohme, 5me saku ahtao toiro apoitohme ikurãkatohme, sero 7me jeimamyry tonahsẽ nae ro ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Sero 7me jeimamyry kurã po tonahsã kurãkãko mokaro mana, tiriiku te, oxinase tõkehko, itamurumehxo nae ahtao, osa kurã taka pata tõ poro; emero õmiry omi poe tyrĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Morara ahtao tonahsẽ nae exĩko mana tokamosẽme ise exiketomo a. Mame orihpyra exĩko sytatose. ");
INSERT INTO apyNT_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Tuisa zamaro Joze omiry kynexine ipoetory tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Mame ynara tykase tuisa konõto eya xine: — Imepỹ pyra mana Joze panõ pyra kowenatume ehtohme ymaro. Imaro Ritonõpo Zuzenu mana. ");
INSERT INTO apyNT_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Mame ynara tykase tuisa Joze a: — Senohne tonepose oya Ritonõpo a, naeroro ynara enetupuhnõko ase, imehnõ motye emese kure mase, imehnõ motye tuarohxo mase. ");
INSERT INTO apyNT_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tuisame exĩko mase ytapyĩ konõto tao. Mame õmiry omipona exĩko ypoetory tõ mana emero. Ywy rokẽ omotye ase tuisame jexiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Seromaroro orĩko ase Ejitu kowenatume. ");
INSERT INTO apyNT_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Tomary poe omahtao touse tuisa a, Joze emary aka tõmase omahtao eya. Moromeĩpo upo kurã tamurupose eya, mauru panono risemy. Keti uuru risẽ tyrise eya ipymyry ae. ");
INSERT INTO apyNT_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Mame Joze tyrise tuisa konõto a tykanary aka. Typoetory tõ tonyohse eya osemazuhme, opore oturutohme: “Osema apuruhmakatoko, osema apuruhmakatoko tuisa esemaryme,” tykase toto. Moro sã Joze toehse kowenatume, Ejitu tuisaryme. ");
INSERT INTO apyNT_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ynara tykase tuisa Joze a: — Ywy tuisame ase Ejitu esemy. Taroino õmiry omipona tarõkõ exĩko mana emero, Ejitu nonory po. ");
INSERT INTO apyNT_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Joze tosehpase tuisa a Zapenate Paneiame. Potipera ẽxiry Asenate tokarose eya ipytyme. Oturuketyme Potipera kynexine pata Heriopori po. 30me jeimamyry nae Joze ahtao Ejitu tuisary akorehmaneme toehse ynororo. Mame toytose ynororo tuisa tapyĩ tae Ejitu poro emero. ");
INSERT INTO apyNT_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Morarame 7me jeimamyry itamurume tonahsã toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Morohne tapoise Joze a ikurãkatohme esary kurã taka pata tõ punero. Emero pata tõ po tapyi konõto tyripose eya tonahsã kurãkatopo tapoise ahtao tupito tõ po. ");
INSERT INTO apyNT_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Itamurume tonahsã tapoise ahtao Joze a, onukuhpyra toehse. Itamurume toehse, isawã tuhke ehtoh samo. ");
INSERT INTO apyNT_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Mame moro jeimamyry tõ etuarimatoh exipyra ro ahtao toemũkuase Joze asakoro typyty Asenate maro. ");
INSERT INTO apyNT_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Osemazupu tosehpase eya Manaseme, ynara karyke: “Ritonõpo poe tuenikehse ywy jetuarimatopõpyry poko, papa tapyĩ taõkõ poko roropa.” ");
INSERT INTO apyNT_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Zakorõ tosehpase eya Eparaĩme, ynara tykase: “Umũkuru tõ ekaroase Ritonõpo ya sero pata po, jetuarimatoh po.” ");
INSERT INTO apyNT_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Morarame tonahse moro 7me jeimamyry itamurume tonahsã nae toehse Ejitu po. ");
INSERT INTO apyNT_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Mame Joze omihpyry ae ro omise ehtoh toehse, 7me jeimamyry pune. Imehnõ nonory po tomitapãpitose toto tonahsã pyra exiryke. Yrome Ejitu po tonahsẽ nae kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Morarame mokaro Ejitu põkõ omise toehse ahtao toytose toto tuisa a tonahsẽ ekaropose. Ynara tykase ynororo eya xine: — Ytotoko oturuse Joze maro. Inyripohpyry tyritoko. ");
INSERT INTO apyNT_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Morarame tomitapãse toto ahtao yronymyryme, tonahsã tapyĩ totapuruhmakase Joze a, tonahsã ekamotohme Ejitu põkomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Imehnõ nonory poe toehse ahno Ejitu pona, tonahsã epekahtohme Joze a, tonahsã pyra toehse exiryke emero nonory po. ");
INSERT INTO apyNT_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Morarame zuaro toehse Jako ahtao tonahsã nae exiry poko Ejitu po, ynara tykase ynororo tumũkuru tomo a: — Oty katoh otupĩko matou? ");
INSERT INTO apyNT_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Tonahsã nae Ejitu po, ãko toto. Ytotoko morotona, kynapyrykõ epekahtatoko orihpyra kuehtohkõme kuemirykõke. ");
INSERT INTO apyNT_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Naeroro toytose Joze rui tomo Ejitu pona tonahsẽ epekahse. ");
INSERT INTO apyNT_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yrome Joze akorõ, Pẽjamĩ, anaropopyra Jako kynexine irui tõ maro. Tumũkuru akomihpyry ryhmary zuno kynexine irui tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Mame tonahsẽ epekahse toytose Jako mũkuru tomo, imehnõ ahno maro. Konopo oehpyra exiryke Kanaã nonory po, tomitapãse toto. ");
INSERT INTO apyNT_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Kowenatume Joze exiryke Ejitu po, tonahsã ekamoneme kynexine ynororo imeimehnomo a, tooehse toto ahtao imehnõ nonory poe. Toeporehkase Joze rui tõ ahtao tosekumurukõ po typorohse toto Joze ẽpataka, tõmytykõ nono pokoxi tyrise roropa eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Turui tõ eneryhtao tyya, tonetupuhse toto Joze a, yrome toto waro pyra exikety sã toehse ynororo. Tõturupose ynororo eya xine zehnoto samo: — Oty nonory poe moehtou? tykase. — Kanaã nonory poe, tykase toto. — Tonahsã epekahse ynanoehno. ");
INSERT INTO apyNT_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Turui tõ tonetupuhse Joze a, yrome takorõkõ onenetupuhpyra toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Wenikehpyra kynexine Joze tõsenehtopõpyry poko toto poko. Ynara tykase ynororo eya xine: — Yna epekara matose. Yna enese moehtou, jamihme pyra yna ehtoh waro oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","— Arypyra tuisa, tykase toto. — Opoetoryme ynanase. Tonahsẽ epekahse rokẽ ynanoehno. ");
INSERT INTO apyNT_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Atakorõme ynanase. Yna zumy toiro mana. Imehnõ etapary se pyra ynanase, tuisa! Zae exiketyme ynanase. ");
INSERT INTO apyNT_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","— Ajohpe matose, tykase Joze. — Yna enese moehtou jamihme pyra yna ehtoh waro oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","— Kanaã põkõme ynanase, tykase toto. — 12me ynanase, papa mũkuru tomo. Yrome toiro yna akorõ toorihse, mokyro akomihpyry papa maro mana. ");
INSERT INTO apyNT_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","— Morara yka, tykase Joze. — Yna enese moehtou, jamihme pyra yna ehtoh waro oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Okuhtorỹko ase ajohpe pyra oehtohkõ waro jehtohme: ãkorõkõ akomihpyry onenehpyra awahtao xine xiaro, ytopyra ropa matose taroino. Ajohpe pyra ase, morara ãko ase isene ro Ejitu tuisary ahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Toiro ytõko amarokomo mokyro enehse xiaro. Yrome amarokomo ãpuruhpyry taka ytõko, mokyro oehtoh pona ro, ajohpe pyra oexirykõ waro jehtohme. Zae pyra awahtao xine yna enese moehtou jamihme pyra yna ehtoh waro oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Mame tõmapose toto eya ãpuruhpyry taka oseruao ẽmepyry pune. ");
INSERT INTO apyNT_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mame oseruao tõmehse ahtao ynara tykase Joze turui tomo a: — Ritonõpo enetupuhneme ase. Opynanohtorỹko ase orihpyra oehtohkõme ynara ahtao: ");
INSERT INTO apyNT_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ajohpe pyra awahtao xine, toiro amarokõ ãpuruhpyry tao exĩko. Imehnomo mã ytõko ropa atapyĩkõ taka ropa, tonahsẽ arose oekyry tomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Imeĩpo ãkorõkõ akomihpyry enehtoko xiaro. Ahtao zuaro exĩko ase zae õmirykõ ehtoh poko. Ajohpe pyra õmirykõ ahtao orihpyra matose. — Ỹ, zae mase, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Oseya rokẽ ynara tykase toto: — Ajohpe pyra. Etuarimãko sytatose seromaroro, kynyrihpyrykõ poko kuakorõkõ poko. Aetuarimary tonese kyya xine, taosanumase kyya xine, aomiry onetapỹ sã toehse kymarokomo. Morara exiryke etuarimãko sytatose seromaroro. ");
INSERT INTO apyNT_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ynara tykase Rupẽ: — Kuurutone: “Aimo onyryhmara ehtoko,” ake oya xine repe. Yrome jomiry onetapỹ sã mexiatose. Morara exiryke seromaroro aorihtopõpyry epehmãko sytatose. ");
INSERT INTO apyNT_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Tuaro pyra toh kynexine, tõmirykõ onetara Joze ekarõko toh kynexine, ynara exiryke, imepỹ epereu omiry waro exikety ae rokẽ tõturuse Joze toto maro. ");
INSERT INTO apyNT_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Mokaro maro ehxĩpo tutũtase Joze xitase. Mame tyxitakehse tahtao toeramase ropa ynororo toto a. Mame Ximeão tymenekase eya imyhtohme toto neneryme. ");
INSERT INTO apyNT_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Mame typoetory tomo a turui tõ sakũ typehkapose tonahsã ke te, itinerũkõ tokarose ropa eya. Saku tõ aka toto tinerũ tyripose eya. Tonahsẽ tokarose roropa eya xine osema ae toto napyryme toto ytory ropa ahtao. Morara tyrise eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Mame tãtakimase Joze rui tomo. Tynepekatyhpyrykõ tyrise toky tõ jumẽtu tõ pona. Mame toytose toto. ");
INSERT INTO apyNT_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Toeporehkase tahtao xine, etypohtoh pona, nyhtoh pona toiro mokaro a tykyryry tymyhpokase saku tonahsẽ outohme toky nahpatohme. Moroto tysaku ao tytinerũ tonese eya. ");
INSERT INTO apyNT_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ynara tykase ynororo imehnomo a: — Enetoko ke! Ytinerũ taro mana saku ao tonahsẽ maro! Tokarose ropa eya xine! Mame tõserehse toto. Tykytyky tykase toto enaromỹke toehse toexirykõke. Tõturuse toto oseya rokene: — Otara ãko Ritonõpo nae kyya xine? ");
INSERT INTO apyNT_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Toeporehkase ropa tahtao xine Kanaã pona, tumykõ turuse emero toehtopõpyrykõ poko. Ynara tykase toto: ");
INSERT INTO apyNT_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","— Mokyro Ejitu kowenatu zehno exikety sã tõturuse yna maro. Ynara tykase ynororo yna a: “Yna epekara matose. Yna enese moehtou jamihme pyra yna ehtoh waro oehtohkõme,” nase yna a. ");
INSERT INTO apyNT_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","“Arypyra,” tykase yna. “Zae exiketõme ynanase. Imehnõ ryhmary se pyra ynanase. ");
INSERT INTO apyNT_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","12me ynanase papa mũkuru tomo. Yrome toiro arypyra toehse. Yna akorõ akomihpyry seromaroro papa maro Kanaã po,” tykase yna. ");
INSERT INTO apyNT_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ynara tykase mokyro kowenatu: “Okuhtorỹko ase zae nymyry oehtohkõ waro jehtohme. Toiro amarokõ oxinomõko mana, taro ymaro. Amarokõ rokẽ ytõko ropa matose anapyrykõ arose oekyry tomo a omise toto exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Yrome ãkorõkõ akomihpyry enehtoko ya. Morara ahtao tuaro exĩko ase, yna etapary se pyra oexirykõ poko, zae exiketõme oexirykõke. Morarame ãkorõkõ ekarõko ropa ase oya xine. Osepekahnõko roropa matose.” ");
INSERT INTO apyNT_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mame tonahsã touse eya xine ahtao tykyryry tõ saku tõ ae tytinerũkõ tonese eya xine emero porehme. Moro tineru eneryhtao tyya xine, jũkõ roropa, enaromỹke toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Mame ynara tykase Jako: — Ypoenõ enahkãko matose emero? Joze arypyra. Ximeão roropa arypyra toehse. Ãko ropa mya roropa amarokomo. Seromaroro Pẽjamĩ arory se amarokomo. Onoky sam ãkohxo? Ywy! ");
INSERT INTO apyNT_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","— Pẽjamĩ ewomãko ase, tykase Rupẽ tumy a. — Ywy mose enehnõko ropa oya. Onenehpyra ropa jahtao, umũkuru tõ asakoro etapako, tykase ynororo tumy a. ");
INSERT INTO apyNT_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ynara tykase Jako: — Ytopyra mã umũkuru amaro xine ipunaka. Irui, Joze toorihse. Pẽjamĩ rokẽ tõxinamase. Otara tyko toehse ynororo ahtao, oytorykohtao, otara ãko matou? Morara awahtao xine jorihmapõko matose jatasamaryke, tamuhpõme jexiryke, tykase ynororo eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Morarame omise ehtoh mynyhpãpyra ro kynexine Kanaã po. ");
INSERT INTO apyNT_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Mame toto napyry tonahkase Jako ekyry tomo a Ejitu po inepekatyhpyrykomo. Mame ynara tykase Jako tumũkuru tomo a: — Ytotoko ropa Ejitu pona ropa tonahsã pitiko epekahtatoko ropa kynapyrykomo. ");
INSERT INTO apyNT_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yrome wenikehpyra Juta. Ynara tykase ynororo: — Mokyro Ejitu kowenatu tõturuse topohme yna a: “Yna akorõ anaropyra yna maro ahtao yna onẽmapopyra mana tõpataka.” ");
INSERT INTO apyNT_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Naeroro mokyro aroporyhtao oya, yna maro ytotohme, ytõko ynanase kynapyrykõ epekahse. ");
INSERT INTO apyNT_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mokyro anaropopyra awahtao, ytopyra ynanase. Mokyro kowenatu ynara tykase: “Omõnõko matose jẽpataka ãkorõkõ akomihpyry enepyryhtao amaro xine.” ");
INSERT INTO apyNT_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","— Oty katoh sẽ sã matou yyryhmãko? Oty katohme mokyro turuse oya xine imepỹ ãkorõkõ poko? tykase Jako. ");
INSERT INTO apyNT_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ynara tykase toto: — Mokyro tõturupose itamurume yna ehtoh poko te, yna ekyry tõ poko te, opoko. Ynara tykase ynororo: “Omykõ isene ro nae? Nae ro matou imepỹ ãkorõkomo?” Tozuhse rokẽ yna a. Tuaro pyra ynanexiase: “Ãkorõkõ enehtoko xiaro,” katoh poko eya. ");
INSERT INTO apyNT_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ynara tykase Juta tumy a: — Aimo aropoko ymaro. Axĩ ytõko ynanase seromaroro. Mame orihpyra sytatose; yna, omoro, yna poenomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","10","Ywy tomeseke ase Pẽjamĩ poko, ewomãko ase. Kure onenehpyra ropa jahtao, jyhxirõko mase iirypyryme jexiryke. Kyryh kara oexiryke taro ro yna, mãpyra kywyh tykase awahtao, pake toytose ynanexiry, tooehse ropa ynanexiry roropa, tykase Juta tumy a. ");
INSERT INTO apyNT_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Mame ynara tykase jũkomo: — Imenekatoh pyra exiryke ynara tyritoko. Kynekarorykõ arotoko saku ao ekarotohme eya. Kykyryrykõ kurã aroko taroino: pausamu pitiko te, ano zeni pitiko te, ixtaratu kehko te, noze tõkehko te, amẽtoa, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Tineru roropa arotoko asakoro, otinerũkõ apitorymã ekarotohme ropa, onenepyhpyrykõ saku ao, tonahsẽ maro. Otarame tõsenekunohse rokẽ ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ãkorõkõ arotoko amaro xine. Axĩ ytotoko mokyro a. ");
INSERT INTO apyNT_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ritonõpo Jamihme Exikety amaro xine mana, ãkorehmatorỹko mokyro opyno xine ehtohme, oruikõ enehpotohme ropa Pẽjamĩ maro tapyi taka ropa. Otara ãko ywy? Ypoenõ tonahse ahtao? Toto onewomasaromepyra ase. ");
INSERT INTO apyNT_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Morara exiryke tynekarorykõ tapoise Jako mũkuru tomo a, tineru maro asakoro, toytotohkõme ropa Ejitu pona, takorõkõ Pẽjamĩ maro. Toeporehkase tahtao xine toytose toto oturuse Joze maro. ");
INSERT INTO apyNT_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Takorõ Pẽjamĩ tonese ahtao Joze a irui tõ maro ynara tykase ynororo typoetory a tytapyĩ erase a: — Moxiã aroko ytapyĩ taka. Okyno etapako otuhtoh ritohme. Otuhnõko mã toto ymaro tãxiahtao, tykase ynororo typoetory a. ");
INSERT INTO apyNT_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Moro sã tyrise itapyĩ erase a. Mame irui tõ tarose eya Joze tapyĩ taka. ");
INSERT INTO apyNT_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Morotona tarose tahtao xine enaromỹke toehse toto. Oseya ynara tykase toto: — Tonehse kymarokõ xiaro moro tineru pokoino, tonehse ropa kyya xine exiryke saku ao tonahsã maro kynarohpyrykomo. Kyporemãkatorỹko mã toto. Kuekykõ apoĩko mã toto. Tynamotome kyritorỹko roropa mã toto. ");
INSERT INTO apyNT_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Naeroro toeporehkase tahtao xine tapyi omõtoh taka ynara tykase toto tapyi erase a: ");
INSERT INTO apyNT_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","— Ajohpãme sã! Pake pixo ynanoepuase xiaro tonahsẽ epekahse. ");
INSERT INTO apyNT_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Mame yna ytory ropa ahtao, totypohse yna ahtao nyhse, saku tõ tymyhpokase ahtao yna a, yna tinerũ ynanenease emero. Naeroro moro tineru ynanenepyase ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nae ynanase tineru tonahsẽ epekahtohme ropa. Onoky a yna tinerũ tyrise ropa saku tõ aka tonahsẽ maro? Zuaro pyra ynanase. ");
INSERT INTO apyNT_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ynara tykase tapyi erase eya xine: — Torẽtyke pyra ehtoko. Enaromyra ehtoko. Ritonõpo Oesẽkomo, omykõ Esẽme roropa mana, kure rokẽ oritorỹko mana. Eya otarame otinerũkõ tyrise saku tõ aka tonahsã maro. Ya otinerũkõ tapoise topehmase oya xine ahtao. Mame Ximeão tonehse tapyi erase a eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Tapyi taka tarose toto eya. Tuna tokarose eya xine ipupurukõ kurikatohme. Tonahsẽ tokarose eya jumẽtu tomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Mame tynekarorykõ touse eya xine ekarotohme Joze a tooehse ropa ahtao tãxiahtao zuaro toehse toexirykõke tõtukurukõ poko moroto. ");
INSERT INTO apyNT_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Mame tooehse Joze ahtao tytapyĩ taka tynekarorykõ tokarose eya. Tosekumurukõ po typorohse toto Joze ẽpataka nono pokoxi tõmytykõ tyrise roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Tõturupose ynororo toto ehtoh poko. Mame ynara tykase: — Otãto pãna omykõ nae, tamuxi? Kuruatose ipoko. Isene ro hna? ");
INSERT INTO apyNT_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","— Ỹ, opoetory, yna zumy, papa isene ro mana. Kure ro mana. ");
INSERT INTO apyNT_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tõsenuhmase Joze. Takorõ Pẽjamĩ tonese ahtao ynara tykase: — Mose ãkorõ akomihpyry, moturuatose ipoko? Kure rokẽ orĩko Ritonõpo mana, aimo! ");
INSERT INTO apyNT_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Takorõ eneryke tyya, omuhpe toexiryke, tosenakunuhse tyxitary se toehse. Turumekase toto eya tynyhtoh taka toytotohme xitase. ");
INSERT INTO apyNT_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tyxitakehse tahtao tõmyty tukurikase eya. Tutũtase ropa ynororo. Ynara tykase: — Otuhtoh enehtoko rahkene, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Mame imepỹ meza po Joze otuhtoh tyrise eya xine. Imepỹ po irui tõ otuhtoh tyrise eya xine. Mame imepỹ meza po roropa Ejitu põkõ otuhtoh tyrise eya xine, epereu tõ maro otuhpyra Ejitu põkõ exiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Irui tõ typorohkapose toto Joze ẽpataka. Atakenaka tyrise toto eya xine; Rupẽ apitoryme aenuruhpyry osemazupume tyrise eya xine. Pẽjamĩ etyhpyryme okominotome. Morara tonese tyya xine ahtao tõsenuruhkase toto, osenẽko rokẽ toh kynexine. “Te,” ãko rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Oxisã zohkõ tyrise Joze zoh samo, yrome Pẽjamĩ zoty 5me paratu ao tyrise eya xine. Eukuru tõse roropa eya xine Joze maro. Tãkye toehse toto. ");
INSERT INTO apyNT_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Mame ynara tykase Joze tytapyĩ erase a: — Mokaro saku aka tonahsã tyriko. Itinerũkõ tyriko roropa toto saku aka emero. ");
INSERT INTO apyNT_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mame toto akorõ akomihpyry saku aka ykyryry, kopu, parata risẽ tyriko itinerũ maro, inapyry epehpyry maro. Moro tyrise eya emero Joze omi poe. ");
INSERT INTO apyNT_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mame tõmehse tahtao xine pakeimo toytose toto Joze rui tomo, Pẽjamĩ maro, jumẽtu tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Mame mya ytopyra ro toto ahtao, ynara tykase Joze tytapyĩ erase a: — Ytoko axiny mokaro orutua kõ ekahmata. Tõseporyse ropa toto ahtao oya ynara kaxiko eya xine: “Oty katoh kure ehtoh epehmãko matou popỹ ke? ");
INSERT INTO apyNT_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Oty katoh jesẽ kopu mematonanopyatose, parata risemy? Ikopũ moro eukuru ẽtohme te, zae pyra ehtoh apiakatohme roropa eya. Zae pyra matoke ipunaka imaro,” kaxiko eya xine, tykase Joze tytapyĩ erase a. ");
INSERT INTO apyNT_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mame toytose tapyi erase rahkene. Joze omihpyry tokarose eya xine ahtao, ");
INSERT INTO apyNT_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","tozuhse ynororo eya xine. Ynara tykase toto: — Oty katoh morara ãko mah yna a? Oesẽ kyryry onematonanohsaromepyra ynanase. ");
INSERT INTO apyNT_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Moro tineru ynanenepyase ropa ynanarohpyry ropa saku ao. Mororo tonehse ropa yna a saku ao. Naeroro oty katohmehxo parata te, uuru roropa ematonanohnõko ynanah oesẽ tapyĩ tao? tykase toto eya. ");
INSERT INTO apyNT_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Oesẽ kyryry eneryhtao oya yna maro, ah norihno mokyro enepyhpono. Yna emero opoetoryme exĩko ynanase. ");
INSERT INTO apyNT_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","— Ỹ, kure, tykase ynororo. — Mokyro rokẽ ypoetoryme exĩko mana, jesẽ kopu apoihpono. Yrome amarokõ ytõko ropa matose. ");
INSERT INTO apyNT_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Naeroro axĩ saku tõ typorohkase eya xine nono pona. Tykyryrykõ tymyhpokase eya xine porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Toto saku ao tupise Joze poetory a. Tamuhpõmehxo exikety saku ao tupise eya osemazuhme. Mame atakenaka tupise eya, akomihpyry saku ao etyhpyryme. Moro kopu tonese eya Pẽjamĩ saku ao tonahsã maro. ");
INSERT INTO apyNT_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Moro eneryke tyya xine tupõ tyxihkase irui tomo a tãkye pyra toexirykõke. Saku tõ tyrise ropa eya xine jumẽtu tõ pona, toytotohkõme ropa mya roropa Joze tapyĩ taka ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Toeporehkase Juta tõ ahtao Joze tapyĩ taka, moroto ro kynexine ynororo. Tosekumuru po typorohse toto Joze ẽpataka, tõmytykõ tyrise eya xine nono pokoxi. ");
INSERT INTO apyNT_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Mame tõturupose Joze. Ynara tykase eya xine: — Oty katoh sẽ sã matou? Tuaro pyra hmatou? Tuisamehxo ywy. Otyro poko zuaro se jahtao zuaro exĩko ase rahkene, tykase ynororo eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ynara tykase Juta: — Tuisa, otara ãko yna oya? Oty ekarõko ynanah oya zae rokẽ yna ehtoh waro oehtohme. Ritonõpo a yna rypyry tumakapose. Taro ynanase emero opoetoryme yna, mose roropa okopũ imaro enehpyry. ");
INSERT INTO apyNT_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","— Arypyra, tykase Joze. — Moro sã onyripyra ase! Mose rokẽ imaro ykyryry tonese exiryke ypoetoryme exĩko mana. Amarõkõ ytõko ropa matose omykõ tapyĩ taka ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Mame eponaro toytose Juta, Joze maro oturuse: — Tuisa, ajohpãme sã oturuxi amaro. Yzehno pyra exiko. Sero nonory esẽme mase. ");
INSERT INTO apyNT_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mekaropoase yna a: “Omykõ nae ro nah? Ãkorõkõ nae roropa hmatou?” ");
INSERT INTO apyNT_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Tokarose emero yna a: “Papa nae ro mana, tamuhpõme exikety. Yna akorõ akomihpyry tonuruse tamuhpõme nymyry papa ahtao. Mose rui toorihse. Seromaroro toiroro mose ro nase jẽ ekepyry mũkuhpyry. Ipynohxo mã jumy ipunaka.” ");
INSERT INTO apyNT_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Mokyro tonehpose oya xiaro aenery se oexiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Mame ynara ynanase oya: “Jũ mã enehpory se pyra aeatamyryino.” ");
INSERT INTO apyNT_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Yrome ynara mase yna a: “Oehpyra ãkorõkõ akomihpyry ahtao omõpyra ropa matose jẽpataka,” mase yna a. ");
INSERT INTO apyNT_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","— Mame toeporehkase yna ahtao tapyi taka, papa turuse yna a, õmihpyry tokarose yna a emero. ");
INSERT INTO apyNT_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Imeĩpo yna tonyohse ropa eya tonahsã epekahtohme ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tozuhse ynororo yna a: “Ytosaromepyra ynanase mokyro ẽpataka yna akorõ akomihpyry anaropyra yna ahtao. Ytõko ynanase mose ytoryhtao rokene yna maro.” ");
INSERT INTO apyNT_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Mame ynara tykase papa: “Zuaro matose ypyty Rakeu toemũkuase asakoro. ");
INSERT INTO apyNT_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Toiro ywinoino toytose. Mame onenepyra ropa tokurehse ywy. Otarame toatãse ynororo, onokyro a tosekase otarame. ");
INSERT INTO apyNT_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Seromaroro mose aroryhtao oya xine, mame tyyryhmase ynororo ahtao, joorihmapõko matose, sam karyke tamuhpõme toehse jexiryke,” tykase papa yna a. ");
INSERT INTO apyNT_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","— Seromaroro, tuisa, tõturuse ro Juta, — jytory ropa ahtao tapyi taka mose anaropyra ropa jahtao, oorihnõko papa mana. Mame isene aehtoh tõsexihse sã mana tumũkuru isene ehtoh maro. Tãkye pyra oorihnõko mana ynanyrihpyry pokoino. ");
INSERT INTO apyNT_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ynara ase papa a, aimo enehnõko ropa ase oya. Ynara ase: “Mose omũkuru onenehpyra ropa jahtao oya, tyyrypyhpyke exĩko ase jũme, joorihtoh ponãmero.” ");
INSERT INTO apyNT_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Morara exiryke ajohpãme sã opoetoryme ehxi mose myakãme. Ah mose nyto ropa turui tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ytosaromepyra ase tapyi taka mose anaropyra ropa jahtao. Papa enery se pyra ase, mose anaropyra ropa jahtao, tykase Juta. ");
INSERT INTO apyNT_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Mame Joze tosenakunuhse yronymyryme. Morara exiryke typoetory tõ taropose eya, toiroro tyekyry tõ maro toehtohme. Opore ynara tykase: — Otũtatoko emero porehme sero tae! Naeroro Joze poetory tõ pyra toehse moro tao. Tutũtase toto ahtao porehme tõsekarose Joze turui tomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Tyxitapitose ynororo opore. Ixitary totase Ejitu põkomo a. Moro tokãtose imehnomo a tuisa konõto tapyĩ tao. ");
INSERT INTO apyNT_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Mame ynara tykase Joze turui tomo a: — Ywy ase Joze, ãkorõkomo. Papa isene ro hnae? Morara kary etaryke tyya xine tõserehse toto yronymyryme. Onezuhsaromepyra toehse toto. ");
INSERT INTO apyNT_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ynara tykase Joze eya xine: — Osehtoko xiaro ya, ajohpãme samo. Ameke hkopyra toehse toto eya, mame tõturuse ro ynororo eya xine: — Ywy ase Joze, ãkorõkomo, onekarohpyrykomo, Ejitu pona onenehpohpyrykõ ase. ");
INSERT INTO apyNT_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Seromaroro emynyhmara ehtoko. Ehxiropyra roropa ehtoko jekarotopõpyry poko oya xine jenehtohme xiaro. Orihpyra oehtohkõme tonehpose ywy Ritonõpo a xiaro. ");
INSERT INTO apyNT_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Asakoro jeimamyry pune toehse, tonahsẽ ahtara sero nono po. Ãko ro mana 5me jeimamyry pune tonahsẽ ahtara ehtopo. ");
INSERT INTO apyNT_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ritonõpo a tonehpose ywy osemazuhme opynanohtohkõme, orihpyra oehtohkõme, opoenõkõ maro. Emese kure Ritonõpo mana. ");
INSERT INTO apyNT_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Naeroro oya xine pyra tonehpose ywy xiaro. Ritonõpo a tonehse ywy. Eya tyripose ywy tuisamehxo, tuisa konõto akorehmaneme. Tuisamehxo tyrise ywy eya tytapyĩ tao te, tynonory kowenatume roropa, Ejitu nonory esẽme porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","— Seromaroro ytotoko ropa axiny tapyi taka, papa zurutatoko: “Omũkuru, Joze a tõmiry tonehpose oya, ynara ãko: ‘Ritonõpo a Ejitu kowenatume tyrise ywy porehme. Axĩ ke osehko xiaro; ekurehpyra exiko. ");
INSERT INTO apyNT_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Oesary Kosẽ po exĩko mana, moe pyra ytapyĩ poko, omoro te, omũkuru tomo te, apakomo te, oeky tomo kaneru tomo te, poti tõ maro te, pui tomo te, emero. ");
INSERT INTO apyNT_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Tonahsẽ pyra ro exĩko mana 5me jeimamyry pona. Kosẽ po awahtao tonahsẽ ekarõko ase oya xine; atapyĩ taõkomo a te, oeky tomo a, enara. Morara ahtao etuarimara matose.’ ” ");
INSERT INTO apyNT_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","— Jenẽko matose, jakorõ Pẽjamĩ roropa jenẽko. Ywy ase Joze, amaro xine oturukety, tykase Joze. ");
INSERT INTO apyNT_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","— Papa zurutoko tuisamehxo jehtoh poko taro Ejitu po. Zurutoko emero onenehpyrykõ poko. Axĩ ke ytotoko papa tõ enehse xiaro. ");
INSERT INTO apyNT_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Takorõ toahmase Joze a, tyxitapitose ynororo. Pẽjamĩ roropa tyxitase turui eahmaryhtao. ");
INSERT INTO apyNT_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Mame ixitaryhtao ro turui tõ toahmase Joze a, typohse roropa toto eya atakenaka. Moromeĩpo tõturupitose toto imaro. ");
INSERT INTO apyNT_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mame Ejitu tuisary turuse imehnomo a itapyĩ konõto tao: “Joze rui tõ tooehse,” tykase toto. Tuisa zamaro toehse, imarõkõ maro, morara kary etaryke tyya. ");
INSERT INTO apyNT_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Joze a ynara tykase ynororo: — Kaxiko orui tomo a: “Tonahsẽ tyritoko oeky tõ pona, arotohme Kanaã pona. ");
INSERT INTO apyNT_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Omykõ enehtatoko xiaro, ipoenõ maro, itapyĩ taõkõ maro. Nono kurã ekarõko ase eya xine. Kure rokẽ otuhnõko mã toto taro Ejitu po. ");
INSERT INTO apyNT_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Kahosa tõ aropoko orui tomo a typyxiãkõ enehtohme te, typoenõkõ maro te, tumykõ maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Torẽtyke pyra ehtoko moero onynomohpyrykõ poko. Taro Ejitu po kurã ke imyakamãko exino mana,” kaxiko eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Morara tykase aexiryke, moro sã tyrise eya xine aomi poe. Kahosa tõ tokarose eya xine Joze a tuisa omi poe, tonahsẽ maro toto napyryme osema ae. ");
INSERT INTO apyNT_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Upo kasenato tokarose roropa eya xine. Yrome Pẽjamĩ a 300me parata tokarose eya, upo tytororo 5me roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Tumy a tonahsã kurã Ejitu põkõ kyryry, 10me jumẽtu po taropose eya, imehnõ 10me jumẽtu tõ maro tiriiku ke pehme te, pão te, imehnõ tonahsã maro otuhtohme osema tao aytorykohtao. ");
INSERT INTO apyNT_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Tõsekazumase toto irui tomo. Mame toto ytotoh toehse ahtao ynara tykase Joze eya xine: — Atatapoipyra ehtoko osema ae oytorykohtao. ");
INSERT INTO apyNT_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Toytose toto Ejitu poe. Mame toeporehkase toto ahtao Kanaã pona tumykõ Jako tapyĩ taka toytose toto, ");
INSERT INTO apyNT_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ynara tykase toto eya: — Joze isene ro mana! Kowenatume mana Ejitu tõ esẽme porehme! — Ajohpe! Atahmãkara ehtoko, tõserehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mame turuse ynororo ahtao Joze omihpyry tokarose eya xine. Kahosa tõ eneryke tyya roropa Joze nenehpohpyry aarotohme Ejitu pona, sekese toehse ropa ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ynara tykase ynororo: — Epo hnae! Umũkuru Joze isene ro mana. Enery se ropa ase orihpyra ro jahtao. ");
INSERT INTO apyNT_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Morarame Jako toytose tytapyĩ taõkõ maro, tykyryry tõ maro emero Peresepa pona. Moroto tynekarory tyahkase eya Ritonõpo eahmatohme, tumy Izake Esẽ eahmatohme. ");
INSERT INTO apyNT_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Morarame moro koko tao tõsenepose Ritonõpo eya, tõturuse ynororo eya, ynara tykase: — Jako, Jako! — Taro ase, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ynara tykase Ritonõpo: — Ywy ase Ritonõpo, omy Esemy. Enaromyra exiko oytory poko Ejitu pona. Moroto opoenõ emãkapõko ase tuhkehxo toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Amaro xine ytõko ase Ejitu pona. Imeĩpo apakomotyã enehnõko ropa ase xiaro sero nonory pona ropa. Mame oorikyryhtao omũkuru Joze amaro exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Mame Peresepa poe Jako toytose. Kahosa tõ ae, Ejitu tuisary nenehpohpyry ae Jako tõ tarose imũkuru tomo a te, typyxiãkõ maro te, typoenõkõ maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Jako tõ toytose typoenõ maro, toky tõ maro emero, tymõkomory maro tynapoityã Kanaã po porehme Ejitu pona. ");
INSERT INTO apyNT_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Typoenõ tarose Jako a, typakomotyã maro emero, orutua komo, nohpo tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ynara Izyraeu tõ toytose Ejitu pona: Jako tomo: Rupẽ, imũkuru osemazupu te ");
INSERT INTO apyNT_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rupẽ mũkuru tomo: Enoke te, Paru te, Ezerõ te, Karami, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ximeão, imũkuru tõ maro: Jemueu te, Jamĩ te, Oate te, Jakĩ te, Zoa te, Sauu, enara. Sauu eny Kanaã põ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Rewi, imũkuru tõ maro: Jeresõ te, Koate te, Merari, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Juta, imũkuru tõ maro: Sera te, Pereze te, Zera, enara. (Imehnõ imũkuru tõ asakoro toorihse Kanaã po: Ere te, Onã, enara.) Pereze mũkuru tõ: Ezerõ te, Hamuu, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakaa, imũkuru tõ maro: Tora te, Pua te, Jasupe te, Xinorõ, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zepurõ, imũkuru tõ maro: Serete te, Erõ te, Jareeu, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Mokaro kynexine Reia mũkuru tõ Jako maro Mesopotamia po aenurutyamo. Mokaro maro ẽxirykõ Tina kynexine. Atapona 33me toh kynexine Jako poenomo Reia maro. ");
INSERT INTO apyNT_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Kate, imũkuru tõ maro: Zipião te, Haki te, Suni te, Exipom te, Eri te, Aroti te, Areri, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asea, imũkuru tõ maro: Imina te, Ixiwa te, Ixiwi te, Peria te, aoryxirykõ Sera, enara. Peria mũkuru tõ kynexine: Hepea te, Maukieu, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Mokaro 16mãkõ Jako poenõ kynexine Ziupa maro, Rapão nekarohpyry Reia poetoryme. ");
INSERT INTO apyNT_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rakeu, Jako pyty toemũkuase asakoro: Joze te, Pẽjamĩ, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Joze mũkuru tõ Asenate maro ynara kynexine: Manase te, Eparaĩ, enara, tonuruse toto Ejitu po. Potipera ẽxiryme Asenate kynexine, oturukety Heriopori po. ");
INSERT INTO apyNT_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Pẽjamĩ mũkuru tõ ynara kynexine: Pera te, Pekea te, Asapeu te, Jera te, Naamã te, Ei te, Roso te, Mupĩ te, Hupĩ te Arate, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Mokaro 14mãkõ Jako poenõ kynexine Rakeu maro. ");
INSERT INTO apyNT_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Tã, imũkuru maro Huxĩ. ");
INSERT INTO apyNT_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napatari imũkuru tõ maro: Jazeeu te, Kuni te, Jezea te, Xirẽ, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Mokaro 7mãkõ Jako poenõ kynexine Pira maro, Rapão nekarohpyry Rakeu a, ipoetoryme. ");
INSERT INTO apyNT_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Atapona 66mãkõ Jako poenomo te, ipakomotyã maro, toytose Ejitu pona. (Imũkuru tõ pyxiã onukuhpyra kynexine.) ");
INSERT INTO apyNT_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Joze mũkuru tõ asakoro tonuruse Ejitu po. Naeroro atapona 70mãkõ Jako tõ toytose Ejitu pona. ");
INSERT INTO apyNT_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Mame tumũkuru Juta tonyohse Jako a osemazuhme ytotohme Joze enehpotohme oseporytohme Kosẽ po. Mame toeporehkase toto ahtao, ");
INSERT INTO apyNT_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","tykanary tukurãkapose Joze a toytotohme Kosẽ pona oseporyse tumy maro. Tõseporyse tahtao xine tumy tapoise Joze a okynano. Tyxitase ynororo tumy maro, tumy apoiryhtao tyya. ");
INSERT INTO apyNT_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Mame ynara tykase Jako: — Seromaroro tãkye rokẽ oorihnõko ase, tonese ropa ya oexiryke. Isene ro oexiry waro ase rahkene! ");
INSERT INTO apyNT_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Moromeĩpo ynara tykase Joze turui tomo a, tumy tomo a roropa: — Ytõko ase oturuse Ejitu tuisary maro. Zurũko ase oehtopõpyrykõ poko Kanaã poe xiaro ymaro ehse. ");
INSERT INTO apyNT_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mokyro zurũko ase oerokurukõ poko pui tõ poko te, kaneru tõ maro te, poti tõ maro. Zurũko roropa ase, oeky tõ enehtopõpyry poko oya xine porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mame mokyro tuisa konõto ekaroporyhtao oya xine oerohtoh poko, ");
INSERT INTO apyNT_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ynara kahtoko eya: “Moino ro ynanerokuase kaneru tõ poko yna tamuru tõ saaro.” Morarame osesarĩko matose Kosẽ po, atameke imehnõ Ejitu põkõ wino, ynara exiryke, okyno poko erohketõ se pyra Ejitu põkõ mana ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Morarame tuisa zuruse toytose Joze. Ynara tykase ynororo: — Papa tõ toeporehkase urui tõ maro, Kanaã poe Kosẽ pona, toky tõ maro, kaneru tomo te, poti tõ maro te, pui tõ maro te, tymõkomorykõ maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Imeĩpo turui tõ 5me tarose eya enepotohme tuisa a. ");
INSERT INTO apyNT_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","— Oty poko erohketyme hmatou? tykase tuisa tõturupose eya xine. Tozuhse ynororo eya xine: — Kaneru poko erohketyme ynanase, yna tamuru tõ saaro. ");
INSERT INTO apyNT_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Tooehse ynanase tarona osesarise, Kanaã po onahpoty tonahse exiryke moroto omirohtoh rokene. Ajohpãme sã ynanehxi Kosẽ po. ");
INSERT INTO apyNT_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ynara tykase tuisa Joze a: — Tooehse omy exiryke orui tõ maro, amaro toto ehtohme, ");
INSERT INTO apyNT_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ejitu nonory emero toto esaryme nase. Osa ekaroko eya xine Kosẽ po kure exiryke, moroto toto ehtohme. Mame tuaro mase, orui tõ maro emese kure exiketõ nae ahtao, tyriko toto jeky tõ pui poko erohketõ tuisaryme. ");
INSERT INTO apyNT_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Imeĩpo tumy Jako tarose Joze a enepotohme tuisa a. Kure rokẽ tyripose ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","— Otãto jeimamyry nae hma? tykase tõturupose tuisa Jako a. ");
INSERT INTO apyNT_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","— 130me jeimamyry nae ase xiaxiake jytoytoh poko rokẽ tytãhpopãse ywy. Tupime roropa nexiase ya, ytamuru tõ ehtopõpyry sã pyra exiase. Tuhke roropa jeimamyry taropose eya xine. Yrome tupime ro nexiase eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kure rokẽ tuisa tyripose Jako a, mame toytose ropa ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Mame tumy esaryme turui tõ esaryme roropa, nono tokarose Joze a, osa kurã po Ejitu po, pata Ramese pũto, tuisa omi poe. Moro nono esẽme toehse toto, moroto toehse toto. ");
INSERT INTO apyNT_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Tonahsẽ tokarose Joze a tumy a te, turui tomo a, tyekyry tomo a emero, ise toto ehtoh tokarose eya. ");
INSERT INTO apyNT_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Mame tonahsẽ pyra toehse pata tõ po porehme. Tãtaosanumase toto tomirykõke, tapotũkehse toto yronymyryme. Ejitu põkõ tyjamihkehse, Kanaã põkõ roropa, tonahsẽ pyra exiryke tapotũkehse toto. ");
INSERT INTO apyNT_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Tytineru ke tonahsẽ topekahse ahno a. Moro tineru tapoise Joze a, tarose eya tuisa tapyĩ konõto taka. ");
INSERT INTO apyNT_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Morarame tineru tonahse ahtao Ejitu po, Kanaã po roropa oturuse toytose Ejitu põkõ Joze a. Ynara tykase toto: — Ajohpãme sã tonahsẽ ekaroko yna a. Tineru pyra ynanase toehse. Orihnõko ynanase yna emiryke, tykase toto Joze a. ");
INSERT INTO apyNT_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ynara tykase Joze eya xine: — Tineru pyra awahtao xine oeky tõ pui tõkehko enehtoko, ike anapyrykõ epehmatohme. ");
INSERT INTO apyNT_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Naeroro toky tõ tonehse Ejitu põkomo a Joze a: kawaru tomo te, kaneru tomo te, poti tomo te, pui tomo te, jumẽtu tomo, enara, tynapyrykõ epehpyryme moro jeimamyry ae porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mame moro jeimamyry tonahse. Yro jeimamyry ae toytose ropa toto Joze a ynara kase: ");
INSERT INTO apyNT_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","— Tuisa, oenekunohsaromepyra ynanase. Yna tineru tonahse, yna eky tõ roropa oekyme toehse. Oty ke yna napyry epekahnõko ynanah? Yna zoko epekahko yna nonory roropa yna napyry epehpyryme. Tuisa poetoryme exĩko ynanase. Yna nonory esẽme exĩko roropa mana. Tonahsẽ ekaroko yna a isene ro yna ehtohme, ipuhturu roropa tupito tõ arykatohme ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ejitu põkõ nonory topekahse Joze a tuisa nonoryme ehtohme. Tutupikõ tokarose eya emero porehme omise konõto exiryke. Morara exiryke tupito tõ porehme tuisa nonoryme toehse. ");
INSERT INTO apyNT_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Tuisa poetoryme Ejitu põkõ tyripose Joze a porehme. ");
INSERT INTO apyNT_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ritonõpo a oturuketõ tupi anapoipyra Joze kynexine. Tutupikõ onekaropyra toh kynexine, tonahsẽ ekaroryke tuisa a toto napyryme. ");
INSERT INTO apyNT_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Mame ynara tykase Joze ahno a: — Seromaroro tuisa poetoryme matose, otupikõ roropa inonoryme toehse, topekahse ya exiryke ikyryryme. Ipuhturu apoitoko arykatohme tupito tõ po. ");
INSERT INTO apyNT_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Morarame apoitoh toehse ahtao, 5me ahtao toiro ekarotoko tuisa a. 4me okyryryme exĩko ipuhturu arykatohme ropa te, anapyrykõme, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ynara tykase toto eya: — Tuisa, kure mexiase yna a. Yna typynanohse oya orihpyra yna ehtohme. Tuisa poetoryme ynanase rahkene. ");
INSERT INTO apyNT_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Naeroro tõmihpyry omipona toto tyripose Joze a. Seroae aomihpyry nae ro mana. Ynara tyripose ynororo: Ejitu po tonahsẽ apoiryhtao 5me ahtao, toiro tuisa napyryme exĩko mana. Ritonõpo poko oturuketõ nonory rokẽ tuisa nonoryme pyra mana. ");
INSERT INTO apyNT_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Moroto Ejitu po Izyraeu tõ ehse rahkene Kosẽ po. Moroto nono topekahse eya xine. Toemũkuase roropa toto tuhke. ");
INSERT INTO apyNT_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","17me jeimamyry taropose Jako a moroto Ejitu po. 147me jeimamyryme toehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Morarame toorikyry moe pyra toehse ahtao tumũkuru Joze tonehpose tyya. Ynara tykase ynororo eya: — Ajohpãme sã oemary tyriko waxiry zopikoxi õmiry etapotohme ya: Ynara tyripory se ase oya, jekepyry ononẽpyra exiko taro Ejitu po. ");
INSERT INTO apyNT_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Toorihse jahtao, jekepyry aroko ropa taroino, Ejitu poe zonẽtohme kytamurukõ zonẽtopõpyry pona. Ynara tykase Joze: — Ỹ, kure, tyrĩko ase omi poe. ");
INSERT INTO apyNT_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","— Ahtao õmiry etapoko ya: ynara kaxiko: “Ritonõpo netaryme tyrĩko ase õmihpyry ae ro,” kaxiko tykase Jako. — Ỹ, Ritonõpo netaryme, morara tyrĩko ase, tykase Joze. Mame tõturuse Jako Ritonõpo a: “Kure mase, Ritonõpo,” tykase. ");
INSERT INTO apyNT_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Morarame Joze turuse jumy kure pyra ehtoh poko. Naeroro toytose Joze tumy enese, tumũkuru tõ asakorõkõ tarose eya, Manase te, Eparaĩ, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Mame Jako turuse imepyny a: — Omũkuru Joze noehno oenese. Tyjamihtase ropa pitiko sẽpe towõse ynororo tynyhtoh po. ");
INSERT INTO apyNT_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ynara tykase ynororo Joze a: — Ritonõpo Jamihmehxo Exikety a, tõsenepose ya pata Ruze po, Kanaã nonory po. Kure rokẽ tyripose ywy eya moroto. ");
INSERT INTO apyNT_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ynara tykase ynororo ya: “Tuhke opoenõ rĩko ase; apakomotyã roropa. Sero nono ekarõko ase apakomotyamo a toto esaryme ehtohme jũme.” ");
INSERT INTO apyNT_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Mame ynara tykase roropa Jako Joze a: — Seromaroro omũkuru tõ Eparaĩ te, Manase maro, taro Ejitu po aenurutyamo oehpyra ro jahtao, umũkurume mã toto. Eparaĩ te, Manase maro umũkurume mã toto, umũkuru Rupẽ ehtoh samo te, Ximeão sã roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Toemũkuase ropa awahtao mokyro omũkurume mana. Mame atakorõme toto exiryke Eparaĩ maro, Manase maro tumykõ mõkomohpyry apiakãko mã toto tymõkomorykõme. ");
INSERT INTO apyNT_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Moro sã tyrĩko ase, asa Rakeu pokoino. Joepyry ropa ahtao Mesopotamia poe sam tykase ywy, asa toorihse ahtao Kanaã po eporehkasasaka kuahtao xine Epyrata pona. Moroto ekepyry tonẽse ya osema ehpio. (Seromaroro Epyrata Perẽme toehse.) ");
INSERT INTO apyNT_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Mame Joze mũkuru tõ tonese ahtao Jako a, tõturupose ynororo: — Onokãkõ moxiamo? ");
INSERT INTO apyNT_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","— Moxiã umũkuru tomo, Ritonõpo nekarotyã ya Ejitu po, tykase Joze. — Enehko toto xiaro ya, tykase Jako, — kure rokẽ toto ripotohme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Tamuhpõme Jako toehse exiryke jamihme pyra enuru toehse kynexine. Popyrahme sã tõsenuhmase ynororo. Tumũkuru tõ tarose Joze a eya. Toahmase toto Jako a. Typohse toto eya. ");
INSERT INTO apyNT_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ynara tykase Jako Joze a: — Oenepyra ropa ekaroase jũme repe, yrome seromaroro Ritonõpo poe opoenõ enẽko ase roropa. ");
INSERT INTO apyNT_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Mame tumũkuru tõ tapoise Joze a tumy enaino. Morotoino tosekumuru po typorohse ynororo tõmyty tyrise nono pokoxi. ");
INSERT INTO apyNT_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Mame tumũkuru Eparaĩ tapoise tapotunuru wino exikety ke Jako pozery winakoxi tyritohme. Tumũkuru Manase tapoise eya typozery wino Jako emary apotunuru wino pũtokoxi tyritohme. ");
INSERT INTO apyNT_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mame Jako a tomary tapotunuru wino exikety tyrise Eparaĩ zupuhpyry pona, poetomehxo ynororo ahtao ro. Tomary typozery wino tyrise eya Manase zupuhpyry pona, osemazupume ahtao ro. ");
INSERT INTO apyNT_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Morarame kure rokẽ Joze tyripose eya Ritonõpo a. Ynara tykase ynororo: “Ritonõpo, tam Aparão Esemy, papa Izake Esẽ roropa, kure rokẽ moxiã aimo tõ tyriko. Jesemary eneponeme mase, Ritonõpo, moe poetome jehtopõpyry poe tarona tamuhpõme jehtoh pona ro. ");
INSERT INTO apyNT_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Kure rokẽ toto tyripoko onenyokyhpyry a, ypynanohtopõpyry samo, moro sã moxiã ewomako. Ypoko wenikehpyra tyripoko toto, tam Aparão poko te, papa Izake poko roropa wenikehpyra toto ehtohme. Tumũkue tuhke tyriko toto, typakõke roropa sero nono po,” tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Joze zamaro pyra Jako nyrihpyry, tomary apotunuru wino riryhtao eya Eparaĩ zupuhpyry pona. Naeroro tumy emary tapoise eya toutohme Eparaĩ zupuhpyry poe tyritohme Manase zupuhpyry pona. ");
INSERT INTO apyNT_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","— Arypyra, papa, tykase Joze. — Moro sã pyra exiko. Mose osemazupu seino, ãpotunuru winõ oemary tyriko zupuhpyry pona. ");
INSERT INTO apyNT_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Moro sã se pyra Jako kynexine. Ynara tykase ynororo: — Zuaro ase, aimo. Zuaro ase. Manase pakomotyã tuhkãkõme exĩko roropa. Yrome zakorõ tuisamehxo exĩko mana, ipakomotyã tuhkehxo exĩko, tuhke imoihmãkõme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kure rokẽ toto tyripose Jako a, ynara tykase: — Oesetykõ ae kure imehnõ tyripõko Izyraeu tomo a. Ynara ãko mã toto: “Kure rokẽ oripõko ase Ritonõpo a, inyrihpyry sã Eparaĩ poko, Manase poko roropa.” Morara Eparaĩ tyrise Jako a osemazuhme, imeĩpo Manase. ");
INSERT INTO apyNT_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Tumũkuru Joze a ynara tykase ynororo: — Jenẽko mase tamuhpõme, orihnõko ase. Yrome Ritonõpo amaro xine exikehpyra mana. Aarotorỹko ropa mana atamuru tõ nonory pona ropa. ");
INSERT INTO apyNT_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Xikẽ nonory ekarõko ase oya, orui tomo a pyra. Xikẽ tõ nonory tapoise ya amoreu tõ wino, atatapoiry ke ya ypyre ke, taky ke te, tapema ke, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Mame tumũkuru tõ tykohmase tyya Jako a. Ynara tykase ynororo: — Jomye ehtoko, imeĩpo ehtoh ekarõko ase oya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Oximõme ehtoko jomye jomiry etatohme, umũkuru tomo, etatoko omykõ, Izyraeu omiry. ");
INSERT INTO apyNT_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rupẽ, umũkuru mase osemazupu. Yjamitunuru mase, jeperyme mase, omoro mase epery osemazupu, jamihme ro jahtao. Ãkorõ tõ motye epyrypaketyme mase, imehnõ motye jamihme exikety mase. ");
INSERT INTO apyNT_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Orẽpyra mase iporiry samo, zueme ahtao, yrome imehxo exiketyme pyra mase, ypyty poko toehse oexiryke. Zae pyra mexiase omy pyty poko toehse oexiryke. ");
INSERT INTO apyNT_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Atakorõme mã toto Ximeão te, Rewi maro, typyrekõ ke imehnõ tyyryhmase eya xine. ");
INSERT INTO apyNT_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Toto maro oximõpyra ase, atamoreparyhtao tynyrirykõ poko. Oseme toto otururuhtao toto maro pyra ase. Imehnõ totapase eya xine exiryke, toto zehno toehse toto ahtao. Pui tõ axiry tysahkase eya xine osemeikatoh samo. ");
INSERT INTO apyNT_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Zehno toto ehtoh popyra tyriposẽme exĩko yronymyrymehxo exiryke! Tohne toto ehtoh popyra tyriposẽme exĩko iirypyryme exiryke. Tãtapiakasẽme exĩko mã toto Izyraeu nonory po, sapararahme toto ripõko ase jekyry tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Juta eahmãko zakorõ tõ mana, irui tõ maro. Tupue exĩko mã toto oẽpataka. Oepetõkara pymyry apoĩko mase. ");
INSERT INTO apyNT_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Aimo Juta, reão mũkurume sã mase, tõsẽ tosekase ahtao, mame tosaka ytõko ropa mana. Tohrame exĩko reão samo, reão nohpory sã roropa. Ipoko toexiry zuno imehnõ mana emero. ");
INSERT INTO apyNT_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Juta tuisame exĩko mana. Ipakomotyã tuisame exikehpyra mana. Imehnõ ahno tynekarory enehnõko eya. Aomipona exĩko imehnõ nonory põkõ mana. ");
INSERT INTO apyNT_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Toky jumẽtu myhnõko mana, uwa zoko pokona, uwa zoko kurã pokona. Zupõ kurikãko mã eukuru ke, tupõ jaraõ kurikãko roropa mana eukuru tahpiremã ke, munu panõ ke. ");
INSERT INTO apyNT_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Enuru kamirarame mana eukuru enyryke eya. Jery karimutume mana pui suhsuru enyryke eya. ");
INSERT INTO apyNT_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zepurõ esary exĩko mana tuna konõto ehpio. Moroto wapu tõ opyime exĩko, esary ehpio exĩko Xitõ po. ");
INSERT INTO apyNT_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakaa jumẽtu jamihme exikety sã mana, typorohse tynarotyã asakoro rãnao. ");
INSERT INTO apyNT_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Nono kurã tonese ahtao eya, tosaryme kurã oserematohme, toraximase ynororo imehnomo a omoxinety ritohme ĩpatarãnaka. Onykerekeremara erohnõko mana imehnõ namotome. ");
INSERT INTO apyNT_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Tã tyekyry tõ tuisaryme exĩko mana. Imehnõ oxiekyry tõ sã exĩko mana, Izyraeu tõ ekyry samo. ");
INSERT INTO apyNT_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Okoi sã exĩko mana osema ehpio, orihmatõ samo osema ehpio exikety, kawaruhtainy esekane samo; Mokyro kawaru po ytokety emapotohme ĩkakoxi. ");
INSERT INTO apyNT_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Ritonõpo Jesemy, ypynanopyry oya eraximãko ase! ");
INSERT INTO apyNT_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Kate tõ maro atatapoĩko omato kõ mana. Yrome imeĩpo toto ekahmãko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asea nonory po tykyrysã kurã exĩko mana, tonahsẽme. Tuisa tõ napyryme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Napatari kapau sã exĩko mana, jarao tururume ytokety samo, tumũkue nupunato exikety samo. ");
INSERT INTO apyNT_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Joze, wewe eperytakety sã mana tuna enatyry pũto. Itamurume eperytãko mana. Amoriry apuru motye exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Epetõkara iiryhmãko mã toto zehnotokõ samo. Typyre ke ekahmãko mã toto, taky tõ pyrou tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Yrome poremãpyra mana. Ipyre jamihme emary po mana. Aporykõ jamihme ro tyjamihtanohse Ritonõpo a, jamihme Exikety a, Jako Esemy a; Esety Topuimo, Izyraeu Ewomane. ");
INSERT INTO apyNT_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ritonõpo, omy Esẽ, ãkorehmãko mana, jamihmehxo Exikety kure rokẽ orĩko mana. Kapu ae kurãkõ ekarõko mana. Tuna kurohtae kurãkõ ekarõko mana. Oeky tõ tuhke ekarõko mana. Opoenõ roropa ekarõko mana tuhke. ");
INSERT INTO apyNT_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Tonahsã itamurume ekarõko mana, ekuru tõkehko roropa, kurãkõ ypy tõ poe moino ro exikety poe kurãkõ ekarõko mana. Otyro tõkehko, kurãkõ ypy tõkehko po exiketomo. Emero kurãkõ exĩko Joze zupuhpyry pona parimã sã zupuhpyry po, exĩko mana tymenekase ynororo irui toh tae. ");
INSERT INTO apyNT_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Pẽjamĩ kaikuximome exĩko mana, kaikuxi sã exĩko, zehno exikety samo. Ẽmepyryme toh apoĩko mana. Kokonie pukuro zoh nae ro mana ekamotohme.” ");
INSERT INTO apyNT_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Moxiã mã 12mãkõ oxiekyry tõme Izyraeu poenomo. Morara tykase jũkõ tumũkuru tomo a kure tyripose toto ahtao. Atatakomino typoenomo a tõturuse tõsekazumaryme. ");
INSERT INTO apyNT_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Morarame ynara tykase Jako tumũkuru tomo a: — Orihnõko ase. Ytõko ase wekyry tomo a. Jekepyry zonẽtoko papa tõ esaka oramãka, Eporõ, heteu tupĩpyry po, ");
INSERT INTO apyNT_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Makapera po, Mãre poe xixi tũtatoh wino, Kanaã nonory po. Moro Aparão nepekatyhpyry Eporõ wino, oramã topu, tupito maro tyekyry ekepyry zonẽtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Moroto Aparão ekepyry tonẽse, ipyty Sara maro; Izake roropa ipyty Repeka maro; moroto Reia ekepyry tonẽse ya. ");
INSERT INTO apyNT_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Moro tupito oramã maro topekahse heteu tomo a. ");
INSERT INTO apyNT_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Tõturukehse Jako ahtao tumũkuru tõ maro tohrame toehse ropa ynororo tynyhtoh po, mame toorihse rahkene. Zuzenu toytose oseporyse tyekyry tõ maro, aorihtyã esaka. ");
INSERT INTO apyNT_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tumy ekepyry pona tõtomase Joze, ihnamõko, xitãko, ẽmyty pohnõko tyxityme. ");
INSERT INTO apyNT_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Mame tumy ekepyry pona opi tyripose opi warõkomo a, motara ehtohme, okyna ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","40me ẽmepyry taropose eya xine moro poko. Toipe toto moro samo tokepyry epinopyry poko. Mokaro tokepyrykõ pona opi rise toto, motara ehtohme. Mame Ejitu põkomo a 70me ẽmepyry pona tyhnamose. ");
INSERT INTO apyNT_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Moromeĩpo tyhnamokehse toto ahtao tõturuse Joze imehnõ tuisa akorehmananomo a. Ynara tykase ynororo. — Ajohpãme sã jomihpyry arotatoko tuisa konõto a. Ynara kahtoko eya: ");
INSERT INTO apyNT_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Orihpyra ro tahtao, tyripose ywy papa a ekepyry zonẽtoh poko, tunukurãkahpyry aka Kanaã po. Ajohpãme sã ytõko ase aporo papa ekepyry zonẽse. Imeĩpo oehnõko ropa ase,” kaxiko, tykase Joze. ");
INSERT INTO apyNT_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ynara tykase tuisa: — Ytoko, omy ekepyry zonẽta, aomihpyry ae ro zonẽta morotona. ");
INSERT INTO apyNT_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Morarame toytose Joze tumy ekepyry zonẽse. Imaro toytose tuisa akorehmananomo te, tuisa tapyĩ tao erohketomo te, Ejitu põkõ tuisary tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Toytose roropa Joze tapyĩ taõkomo, irui tapyĩ taõkõ roropa Jako ekyry tomo, enara. Tynomose eya xine Kosẽ po poetohti tomo te, kaneru tomo te, poti tomo te, pui tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Toytose roropa orutua komo kawaru po te, kahu ao te, oximõmãkõ tuhke. ");
INSERT INTO apyNT_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Toeporehkase toto ahtao Atate pona, tuna Joatão poe xixi tũtatoh wino tiriiku poko erohtoh pona, tyxitase toto, ihnamõko okynahxo. 7me ẽmepyry taropose Joze a moroto tumy hnamory poko. ");
INSERT INTO apyNT_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Mokaro ixitarykõ eneryke tyya xine: “Tõsenuruhkase moro põkomo mokaro Ejitu põkõ xitary etaryke tyya xine.” Naeroro moro tosehpase eya xine Apeu-Miziraĩme. ");
INSERT INTO apyNT_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Moro sã toehse Jako poenomo, tumykõ ekepyry poko, aomihpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ekepyry tarose eya xine Kanaã pona. Tonẽse ynororo eya xine oramãka, Makapera po, Mãre poe xixi tũtatoh wino, tupito po, Aparão nepekatyhpyry po. Topekahse eya Eporõ, heteu a, tyekyry ekepyry zonẽtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Moromeĩpo ekepyry tonẽkehse ahtao, toytose ropa toto Ejitu pona, Joze, irui tõ maro, tymarõkõ maro emero, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Morarame jũkõ toorihse ahtao, ynara tykase Joze rui tomo: — Otarame Joze kyzehno xine, kuãnohtorỹko mana taosanumatopõpyry mỹpõko mana, tykase toto oseya rokene. ");
INSERT INTO apyNT_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Naeroro tõmirykõ taropose Joze a. Ynara tykase toto: — Orihpyra ro papa ahtao, ");
INSERT INTO apyNT_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","taropose yna ekaropose oya ynara: “Ajohpãme sã yna rypyry ikorokapoko, zae pyra yna ehtopõpyry amaro.” Naeroro ekaropõko ynanase oya, yna rypyry ikorokapoko, popyra yna ehtopõpyry amaro, ynara exiryke: Ritonõpo, omy Esẽ poetoryme ynanase. Mokaro omiry totase ahtao Joze a tyxitase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Moromeĩpo irui tõ tooehse eya. Toepuise toto Joze ẽpataka. Ynara tykase: — Taro ynanase, opoetoryme. ");
INSERT INTO apyNT_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yrome tozuhse toto Joze a. Ynara tykase ynororo: — Enaromyra ehtoko. Oty kara ase opoko xine. ");
INSERT INTO apyNT_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ajohpe pyra, mosenetuputyatose josanumatoh poko repe. Yrome moro popyra ehtoh tymyakãmase Ritonõpo a kure ehtoh ke. Moro enẽko matose seromaroro. Tuhkãkõ typynanohse Ritonõpo a orihpyra toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Enaromyra ehtoko. Opynanohtorỹko ase opoenõkõ maro. Morara kary etaryke tyya xine, typyno xine Joze exiry eneryke tyya xine, mynyhme toehse toto tukurohtao xine. ");
INSERT INTO apyNT_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Mame moroto ehse Joze Ejitu po, jumy ekyry tõ maro. 110me jeimamyry taropose eya, ");
INSERT INTO apyNT_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Eparaĩ mũkuru tõ, ipakomotyã roropa tonese eya. Tonao tapoise toto eya typoenõme, typary Makia mũkuru tõ roropa. Manase mũkurume Makia kynexine. ");
INSERT INTO apyNT_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Morarame ynara tykase Joze takorõ tomo a, turui tomo a roropa: — Orihsasaka ywy. Yrome Ritonõpo opynanohtorỹko mana. Aarotorỹko ropa ynororo taroino, imepỹ nonory pona, tynenepohpyry Aparão a, Izake a, Jako a, enara. ");
INSERT INTO apyNT_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Mame toto omiry tokaropose Joze a, tyekyry tomo a, ynara tykase: — Ynara enetupuhnõko ase, Ritonõpo ãkorehmatorỹko mana, oytotohkõme taroino. Morara toehse ahtao jekepyry arotoko amaro xine. ");
INSERT INTO apyNT_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Mame toorihse Joze 110me jeimamyry taropose ahtao eya. Ekepyry topinohse opi ke motara ehtohme. Mame okepy ẽ aka ekepyry tyrise eya xine Ejitu po.");
INSERT INTO apyNT_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Mame Jako mũkuru tõ toytose tumykõ maro Ejitu pona tytapyĩ taõkõ maro. Ynara toh kynexine: ");
INSERT INTO apyNT_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rupẽ te, Ximeão te, Rewi te, Juta te, ");
INSERT INTO apyNT_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakaa te, Zepurõ te, Pẽjamĩ te, ");
INSERT INTO apyNT_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Tã te, Napatari te, Kate te, Asea, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jako poenõ maro ipakomotyã maro atapona 70me kynexine. Imũkuru Joze toytose apitoryme Ejitu pona. ");
INSERT INTO apyNT_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Morarame okynahtao toorihse Joze, irui tõ roropa emero, zakorõ roropa. Imehnõ roropa toorihse emero mokaro zumakahpõkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Yrome Jako mũkuru tõ, ipakomotyã roropa Izyraeu tõ toemũkuase tuhke. Tomãse toto. Jamihme toehse roropa toto. Tãtahpahse toto Ejitu nonory punero. ");
INSERT INTO apyNT_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Moromeĩpo imepỹ tuisame toehse Ejitu esẽme. Joze ehtopõpyry poko tuaro pyra kynexine ynororo ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ynara tykase ynororo typoetory tomo a: — Enetoko ke! Mokaro Izyraeu tomo jamihme mã toto. Kymarokõ motye emãnõko roropa mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Imepỹ nonory põkõ maro kuosetaparykohtao otarame kuepetõkara maro osepeme exĩko mã toto. Toto akorehmãko kyporemãkaporykõ poko. Mame kurumekatorỹko otarame mã toto. Naeroro tuaro sehtone toto poko. Emãpyra syripotone toto. ");
INSERT INTO apyNT_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Morara exiryke Izyraeu tõ rohmanohponanõ tyrise Ejitu põkomo a tõmipona xine Izyraeu tõ ritohme te, yronymyryme toto rohmanohpotohme, erohtoh tupimã ke. Morarame pata tõ tyrise eya xine: Pitom te, Ramese roropa, tonahsã kurãkatohme Ejitu tuisary a. ");
INSERT INTO apyNT_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Yrome itamurumehxo tyrohmanohpose toto ahtao Ejitu põkomo a itamurumehxo Izyraeu tõ tomãse. Toto zuno toehse Ejitu põkomo, ");
INSERT INTO apyNT_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","naeroro topehke pyra typoetoryme toto tyripose eya xine. Orẽpyrahxo tyrohmanohpose toto eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Toetuarimase toto toerokurukõ poko; omoxinety puimary poko te, tijoro tõ riry poko, tapyi tõ riry poko te, tupito tõ arykary poko, enara. Emero poko toerohse toto ahtao ro, toto zehno sã esẽkõ kynexine, popyrahme sã toto tyrise eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mame ynara tykase tuisa Xipara a, Pua maro Izyraeu nohpory tõ onurumapotõkomo a: ");
INSERT INTO apyNT_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","— Izyraeu nohpory akorehmaryhtao oya xine enururu poko ynara tyritoko: tonuruse orutuame ahtao etapako; yrome nohpome ahtao onetapara ehtoko. Ah isene nexino. ");
INSERT INTO apyNT_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Yrome Ritonõpo tonetupuhse eya xine. Naeroro tuisa omipona pyra toh kynexine. Orutua kõ tonuruse ahtao typynanohse toto eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Naeroro tuisa a onurumapotõkõ tykohmapose tyya ekaropotohme eya xine. Ynara tykase ynororo: — Oty katoh morara myritou? Oty katoh enurusenã orutua kõ pynanohnõko matou? ");
INSERT INTO apyNT_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ynara tykase toto: — Mokaro Izyraeu tõ nohpo tõ Ejitu tõ nohpory sã pyra mã toto. Tupime pyra enurũko mã toto. Eporehkara ro yna ahtao, poeto tõ enurũko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Ritonõpo omipona se onurumapotõkõ exiryke, kure tyrise toto Ritonõpo a. Oximaro tyrise Ritonõpo a jekyry tõ maro; tynioke, typoenõke, enara. Mame Izyraeu tõ tomãse itamurume. Jamihme toehse roropa toto. ");
INSERT INTO apyNT_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Mame ynara tykase tuisa, typoetory tomo a emero: — Izyraeu mũkuru tõ enurusenã kõ ematoko tuna Niro kuaka. Nohpo tõ ipynanohtoko isene toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Morarame orutua kynexine, Rewi parỹpyryme exikety. Typytase ynororo nohpo, Rewi parỹpyrymã maro. ");
INSERT INTO apyNT_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Mame poetoẽme toehse mokyro nohpo. Toemũkuase ynororo, orutua kurã potume. Tumũkuru kurã eneryhtao tyya tonẽse ynororo eya oseruao nuno ehtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Morarame tumũkuru zonẽtoh pune pyra toehse ahtao ruto tapoise eya arumaimo risemy, mame tapuhse eya azawa ke. Moro aka tumũkuru tyrise eya, inomotohme nakuaka tuna ehpikoxi, sapisapirimoh taka. ");
INSERT INTO apyNT_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Aoryxiry tehme kynexine ameke rokẽ typiry eraseme. ");
INSERT INTO apyNT_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mame Ejitu tuisary ẽxiry toytose nakuataka epyse, ipoetory tõ ytoytoryhtao ehpikuroko. Mame ruto tonese nohpo a sapisapirimoh tao. Typoetory a moro tonehpose tyya enetohme. ");
INSERT INTO apyNT_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ruto totapuruhmakase tuisa ẽxiry a. Poeto pitiko tonese eya, xitãko. Nupunato tonese eya. Ipyno toehse ynororo, ynara tykase: — Izyraeu tõ mũkuru mose ro. ");
INSERT INTO apyNT_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Morarame poeto pitiko oryxiry tõturupose tuisa ẽxiry a. Ynara tykase: — Zuãtanohne se hma? Nohpo Izyraeu mã enehpõko ha suhsu ẽponeme, ãkorehmatohme? tykase. ");
INSERT INTO apyNT_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","— Ỹ, enehta, tykase tuisa ẽxiry eya. Naeroro aoryxiry toytose poeto ẽ enehse. Tonehse eya rahkene. ");
INSERT INTO apyNT_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mame ynara tykase tuisa ẽxiry eya: — Mose, poeto pitiko, aroko zuãtanohtohme umũkurume. Oepehmãko ase oerohtamitume. Naeroro tumũkuru tarose eya zuãtanohtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Imeĩpo tuãtase poeto ahtao, tarose eya tuisa ẽxiry a. Tuisa ẽxiry mũkurume toehse ynororo. Tosehpase ynororo Moezeme eya ynara karyke: — Mose anymyase nakuae. ");
INSERT INTO apyNT_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Morarame tuãtase Moeze ahtao tutũtase ynororo osenuhmase, tyekyry tõ enese. Mame Izyraeu tõ rohmanohpotoh tupimã poko tonese eya. Tyekyry pipokuru Ejitu pono a tonese roropa eya. Tyekĩtapãse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Tỹkakoxi tõsenuhmase Moeze. Imehnõ pyra kynexine moroto. Mame mokyro Ejitu põ totapase eya. Ekepyry tonẽse eya isawã htaka rokene. ");
INSERT INTO apyNT_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Yrokokoro toytose ropa ynororo osenuhmase ropa. Izyraeu tõ tonese eya asakoro. Atatapoĩko toh kynexine. Mame tõturupose Moeze zae pyra exikety a. Ynara tykase ynororo eya: — Oty katohme oekyry pipohnõko mah? tykase Moeze. ");
INSERT INTO apyNT_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Tozuhse ynororo eya: — Onoky omi poe yna zupokãko mahno? Yna tuisaryme awahtao sahmo? Jetapary se hmahno ahno etapatopõpyry sã oya? Mame enaromỹke toehse Moeze. Ynara tõsenetupuhse ynororo: “Tuaro toehse mã toto ynyrihpyry poko.” ");
INSERT INTO apyNT_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Mame zuaro toehse Ejitu tõ esẽ ahtao Moeze nyrihpyry poko, etapary se toehse ynororo, yrome toepase Moeze Ejitu poe Mitiã pona, moroto ehse. Jetoro, Ritonõpo maro oturuketyme kynexine Mitiã po. Tõxike kynexine ynororo 7me, nohpo tomo. Morarame Moeze typorohse kynexine tuna eutary pũto. Mokaro nohpo tõ tooehse tuna anỹse toky tõ ohpatoh pehkatohme, kaneru tõ ohpatohme poti tõ maro, tumykõ eky tomo. ");
INSERT INTO apyNT_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Mame imehnõ kaneru tõ ekahmananõ toeporehkase Jetoro ẽxiry tõ ererehse toto aropotohme morotoino. Yrome Moeze towõse. Towomase toto eya. Tuna tanỹse eya toto eky tõ ohpatohme. ");
INSERT INTO apyNT_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Mame toytose ropa toto tumykomo a. Jũkõ tõturupose eya xine: — Oty katohme axĩ moehtou ropa, kohmãpyra ahtao ro seroae? tykase. ");
INSERT INTO apyNT_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","— Orutua tooehse, Ejitu pono. Eya towomase yna imehnõ toky tõ nahpananõ winoino. Tuna tanỹse eya yna okurume, yna eky tõ okurume roropa, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","— Otoko hnae ynororo? tykase Jetoro. — Oty katohme mokyro tynomose oya xine moroto? Ytotoko mokyro enehtohme autuhtohme kymaro xine. ");
INSERT INTO apyNT_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mame Moeze toahmase Jetoro a moroto aehtohme tymaro xine. Naeroro moroto tõsesarise Moeze kynexine. Mame tõxiry Zipora tokarose eya jumy a ipytyme. ");
INSERT INTO apyNT_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Mame toemũkuase Moeze ahtao, tumũkuru tosehpase eya Jeresõme. Ynara tykase ynororo: — Katonõme ase taro imehnõ nonory po. ");
INSERT INTO apyNT_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Imeĩpo Ejitu tuisary toorihse. Yrome Izyraeu tõ etuarimãko ro, pusuh ãko toh kynexine. Topehke pyra toerohse toto Ejitu tõ tuisary poetoryme. Tyxitase toto, takorehmanekõ ekaroporyme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Mokaro pusuhkatoh totase Ritonõpo a. Wenikehpyra kynexine tõmihpyry poko Aparão a te, Izake a te, Jako a, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Izyraeu tõ rohmanohpotoh topehke pyra tonese Ritonõpo a. Toto pynanopyry se kynexine ynororo. ");
INSERT INTO apyNT_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moroto toerohse Moeze, tymeretamuru eky tõ poko. Imeretamuru, Jetoro, Ritonõpo maro oturuketyme kynexine Mitiã po. Eky tõ tynahpase eya, kaneru tomo, poti tõ maro. Mame toto tarose Moeze a mya ona poro, ypy Xinai myhtokoxi. Moro ypy tymenekase Ritonõpo a, tosaryme ehtohme kurãme. ");
INSERT INTO apyNT_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Moroto tõsenepose Ritonõpo nenyokyhpyry Moeze a, apoto samo. Pika zatyry tonese Moeze a tororo ãko, yrome ezehpyra kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moro eneryke tyya toemynyhmase ynororo. “Otãto puhkoke pika ezehpyra nae? Enetã aporo,” tykase ynororo tukurohtao rokene. ");
INSERT INTO apyNT_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Morarame enese toytose Moeze. Ameke pyra toehse ynororo ahtao taomirose Ritonõpo a pika wino. Ynara tykase ynororo: — Moeze! Moeze! — Taro ase, tykase Moeze. ");
INSERT INTO apyNT_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ynara tykase Ritonõpo eya: — Oetypohko moroto! Asãtajã tõ touko. Sero osa jesaryme kurã nase. Mame ynara tykase Ritonõpo eya: ");
INSERT INTO apyNT_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","— Ywy ase Ritonõpo atamuru tõ Esemy, Aparão te, Izake te, Jako, enara. Toto esẽkõme ase, tykase. Morara kary etaryke tyya tonuru tapuruse Moeze a tomary ke. Osenuhmara toehse ynororo tõserepyryke, Ritonõpo enery zuno toexiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Mame ynara tykase Ritonõpo: — Ypoetory tõ tuarimapory tonese ya Ejitu põkomo a. Toto omiry totase roropa ya typynanohnekõ ekaropory, toto rohmanohponanõ pokoino. Zuaro ase toto etuarimary poko. ");
INSERT INTO apyNT_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Morara exiryke tyhtose ywy toto pynanohtohme Ejitu tõ wino, toto arotohme Ejitu poe nono konõto pona, nono kurano. Moroto nono kure mana, otyro zamaro mana. Moroto kananeu tõ nae te, heteu tomo te, amoreu tomo te, perizeu tomo te, heweu tomo te, jepuseu tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ypoetory tõ xitary totase ya rahkene, typynanopyrykõ ekaropotopõpyry ya. Toto ryhmary Ejitu tomo a tonese roropa ya. ");
INSERT INTO apyNT_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Seromaroro aaropõko ase Ejitu tuisary a, ypoetory tõ enehtohme oya Izyraeu tomo, Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Yrome ynara tykase Moeze Ritonõpo a: — Tuisame pyra ase, jamihme pyra exiketyme roropa. Otãto ytõko ywy oturuse Ejitu tõ tuisary a, morotoino Izyraeu tõ enehtohme? ");
INSERT INTO apyNT_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ynara tykase Ritonõpo: — Amaro exĩko ase. Ypoetory tõ enepyryhtao oya Ejitu poe, sero ypy pona oehnõko matose jeahmase. Morara toehse ahtao tuaro exĩko matose ywy roro kuenyohno. ");
INSERT INTO apyNT_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Yrome ynara tykase Moeze: — Jytoryhtao oturuse Izyraeu tomo a, ynara karyhtao eya xine: “Ritonõpo kytamuru tõ Esemy a tonyohse ywy oya xine.” Ynara ekaropõko mã toto: “Onoky mokyro esety?” Otara ãko ywy eya xine? ");
INSERT INTO apyNT_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ynara tykase Ritonõpo: — Ywy ase. Jesety Ywy Ase, tykase. Mame ynara tykase roropa: — Ynara ãko mase eya xine: “Ywy Ase jenehpoase oya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ritonõpo, atamuru tõ Esemy: Aparão Esemy te, Izake Esemy te, Jako Esemy roropa jenehpoase oya xine. Sero esety nase jũme. Taroino apakomotyã wenikehpyra mã toto sero esety ke Ritonõpo esehtõko mã toto.” ");
INSERT INTO apyNT_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","— Ytoko, Izyraeu tõ tamuximãkõ oximõme enehpoko. Zuruko toto ypoko. Ynara kaxiko eya xine: “Ritonõpo, atamuru tõ Esemy, Aparão Esemy te, Izake Esemy te, Jako Esẽ roropa nosenepoase ya. Ynara nase ya ourutohkõme: ‘Oetuarimarykõ tonese ya. Oryhmarykõ poko Ejitu põkomo a zuaro ase. ");
INSERT INTO apyNT_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Naeroro ynara tyrĩko ase, aarotorỹko ase Ejitu poe, oryhmatohkõ poe nono kurã pona, otyro zamaro ehtoh pona, kananeu tõ nonory pona; heteu tõ, amoreu tõ, perizeu tõ, heweu tõ, jepuseu tõ nonory pona, enara.’ ” ");
INSERT INTO apyNT_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","— Õmiry etãko ypoetory tõ mana. Imeĩpo Izyraeu tõ tamuximãkõ maro ytõko mase Ejitu tuisary zuruse. Ynara kahtoko eya: “Ritonõpo epereu tõ Esemy a tõsenepose yna a. Seromaroro ah ynanytoxi ona pona ahno esaka pyra, oseruao ẽmepyry yna ytory poko. Moroto okyno zahkãko ynanase ynanekaroryme Ritonõpo yna Esemy a.” ");
INSERT INTO apyNT_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","— Yrome zuaro ase, mokyro Ejitu tõ esẽ morara onyripopyra jahtao yjamitunuru ke aaroporykõ se pyra exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Morara exiryke yjamitunuru enepõko ase eya xine. Iiryhmatohkõ enehpõko ase Ejitu tõ wãnohtohme. Moromeĩpo aaropotorỹko ituisary mana Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","— Ozehno xine pyra Ejitu põkõ rĩko ase. Mame oytorykohtao Ejitu poe tymõkomoke kurã ke ytõko matose. ");
INSERT INTO apyNT_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Izyraeu tõ nohpo tõ ekaropõko tykatonomory a, Ejitu põkomo a, parata risemy te, uuru risemy te, upo roropa opoenõkomo a amurutohme. Morara Ejitu tõ mõkomory arõko matose oytorykohtao. ");
INSERT INTO apyNT_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Morarame ynara tykase Moeze Ritonõpo a: — Yrome otarame zae jehtoh onenetupuhpyra Izyraeu tõ tamuximãkõ exĩko mana. Otarame jomiry etary se pyra exĩko mã toto. Otarame, “Ajohpe, Ritonõpo osenepopyra nase oya,” ãko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Naeroro ynara tykase Ritonõpo: — Oty moro oemahpo? — Ymyxiry, tykase Moeze. ");
INSERT INTO apyNT_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","— Emako nono pona, tykase Ritonõpo. Tomase ahtao eya okoime tanyhtase imyxiry. Toepase Moeze okoi kurũke. ");
INSERT INTO apyNT_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Mame ynara tykase Ritonõpo Moeze a: — Arokyry poko apoiko oemary ke. Morarame okoi tapoise Moeze a arokyry poko. Tanyhtase ropa imyxiryme ropa emahpo. ");
INSERT INTO apyNT_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Mame ynara tykase Ritonõpo: — Morara tyriko Izyraeu tõ neneryme tuaro toto ehtohme Ritonõpo itamurukõ Esẽkõ, Aparão Esemy te, Izake te, Jako enara Esẽkõ nosenepoase oya. ");
INSERT INTO apyNT_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ynara tykase ropa Ritonõpo Moeze a: — Seromaroro oemary tyriko opuroh pokoxi. Aomi poe morara tyrise Moeze a. Mame tomary touse ropa ahtao eya orukoimo panõ toehse emary poko. Ekurãkapỹme sã toehse. ");
INSERT INTO apyNT_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","— Oemary tyriko ropa opuroh pokoxi, tykase Ritonõpo. Tyrise eya. Mame touse ropa ahtao eya, emary kure ropa toehse tupũ osemazuhme aexihpyry samo. ");
INSERT INTO apyNT_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Mame ynara tykase Ritonõpo eya: — Onyrihpyry yjamitunuru ke apitorymã eneryhtao Izyraeu tomo a, oenetupuhpyra toto ahtao zakorõ tyriko. Oenetupuhnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Yrome moro asakoro onyrityã yjamitunuru ke eneryhtao eya xine, onenetupuhpyra ro toto ahtao, õmiry etary se pyra roropa toto ahtao, tuna anỹko Niro kuae aekuãtohme nono pokoxi. Munume anyhtãko moro tuna mana. ");
INSERT INTO apyNT_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ynara tykase Moeze Ritonõpo a: — Ritonõpo, moino ro tupime jotururu ya. Seromaroro oturũko mase ya. Yrome morararo ywy, tupime ro ya jotururu. Otupĩko ywy jotururuhtao. ");
INSERT INTO apyNT_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yrome ynara tykase Ritonõpo eya: — Onoky myta ekarõko ahno a? Onoky ahno tyripõko otato pyra te, sekere kara roropa? Onoky imehnõ rĩko tonure te, tonurẽkara roropa? Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Naeroro ytoko. Ãkorehmãko ase õtururu poko. Õturutoh ekarõko ase oya. ");
INSERT INTO apyNT_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Yrome Moeze a tozuhse. Ynara tykase: — Arypyra, Ritonõpo. Ajohpãme sã imepỹ aropoko. ");
INSERT INTO apyNT_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Tohne toehse Ritonõpo Moeze poko. Ynara tykase eya: — Otara ãko mah orui Arão poko, Rewi parỹpyry? Otupipyra ynororo tõtururuhtao. Zuaro ase. Oehnõko mana oenese seromaroro. Tãkye exĩko mana oeneryhtao. ");
INSERT INTO apyNT_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Oturũko mase Arão maro. Zurũko mase aoturutohme. Ãkorehmatorỹko ase õtururukõ poko te, ãmorepatorỹko ase onyrirykõ poko. ");
INSERT INTO apyNT_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Mame õmiry ekarõko mã ynororo ahno netaryme. Ritonõpo sã exĩko mase, õmiry ekarory poko eya, ahno zurutohme. ");
INSERT INTO apyNT_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Sero omyxiry aroko amaro. Ike yjamitunuru enepõko mase. ");
INSERT INTO apyNT_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mame toytose Moeze tymeretamuru, Jetoro tapyĩ taka. Ynara tykase: — Ytoxi Ejitu pona ropa wekyry tõ enese. Toto enery se ase isene ro toto ahtao. — Ỹ, kure rokẽ ytoko, tykase Jetoro. ");
INSERT INTO apyNT_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mitiã nonory po Moeze ahtao ro, morara tykase Ritonõpo eya: — Ytoko ropa Ejitu pona. Mokaro, oetapary se aehtyã toorihse mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mame typyty tyrise Moeze a jumẽtu pona, tumũkuru tõ roropa. Toytopitose ropa toto Ejitu pona. Tymyxiry tarose Moeze a tomahpo, Ritonõpo naropohpyry. ");
INSERT INTO apyNT_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Tõturuzomose ropa Ritonõpo Moeze a. Ynara tykase: — Yjamitunuru ekaroase oya enepotohme te, enetupuhpotohme. Toeporehkase awahtao Ejitu pona yjamitunuru enepõko mase morotõkõ tuisary ẽpataka. Yrome mokyro ripõko ase aosenetupuhtoh tũpore. Ypoetory tõ Izyraeu anaropopyra exĩko mã ynororo moro poe. ");
INSERT INTO apyNT_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Mame mokyro zurũko mase, ynara ãko ywy, Ritonõpo oya: “Izyraeu tõ umũkurume mana, apitorymano. ");
INSERT INTO apyNT_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Kuuruase, ah umũkuru nytono jeahmase. Yrome anaropopyra mexino. Morara exiryke omũkuru apitorymã etapãko ase.” ");
INSERT INTO apyNT_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mame aytoryhtao Ejitu pona, totypohse Moeze tytapyĩ taõkõ maro moroto ẽmehtohme. Mame tõseporyse Ritonõpo Moeze etapatohme repe. ");
INSERT INTO apyNT_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Mame topu taere exikety tapoise ipyty Zipora a. Tumũkuru aĩpotapihpyry tysahkase eya. Moro tomase eya Moeze pupuru pona, ynara tykase ynororo: — Ynio mã munuhpe exiketyme mase ya. ");
INSERT INTO apyNT_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Morara tykase eya aĩpotapihpyry sahkary pokoino. Naeroro Moeze typynanohse Ritonõpo a, iseneme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Morarame ynara tykase Ritonõpo Arão a: — Ytoko osẽpatakamase Moeze maro ona pona. Toytose ynororo. Tõsẽpatakamase toto ypy Xinai po. Typohse ynororo eya. ");
INSERT INTO apyNT_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mame Arão turuse Moeze a Ritonõpo omihpyry emero, taropose tahtao Ejitu pona toytotohme ropa. Turuse roropa eya Ritonõpo nyripohpyry poko tyjamitunuru ke. ");
INSERT INTO apyNT_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mame Arão maro toytose Moeze Ejitu pona. Tõximõse toto Izyraeu tõ tamuximãkõ maro emero. ");
INSERT INTO apyNT_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Mame toto turuse Arão a, Ritonõpo omihpyry Moeze a. Mame Ritonõpo nyripohpyry tyrise Moeze a Ritonõpo jamitunuru enepotohme eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Tonetupuhse eya xine. Mame tuaro toehse toto ahtao Ritonõpo oepyry poko tyya xine toetuarimarykõ eneryke eya, toepuise toto Ritonõpo eahmaryme eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Moromeĩpo toytose Moeze tõ Arão maro oturuse Ejitu tuisary maro. Ynara tykase toto eya: — Ynara ãko Ritonõpo Izyraeu tõ Esẽ oya: “Ah ypoetory tõ nytõ toto ona pona, ahno esaka pyra otuhtoh konõto ritohme, toto oseahmatohme jeahmaryme.” ");
INSERT INTO apyNT_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","— Onoky mokyro, Ritonõpo? tykase tuisa. — Oty katohme aomiry etãko ha, Izyraeu tõ aropory poko ona pona? Mokyro Ritonõpo waro pyra ase. Izyraeu tõ anaropopyra ase taroino. ");
INSERT INTO apyNT_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ynara tykase Moeze tõ, Arão maro eya: — Ritonõpo, epereu tõ Esẽ nosenepoase yna a. Naeroro ah ynanytoxi oseruao ẽmepyry ae ona pona, yna eky tõ zahkatohme ynanekaroryme Ritonõpo yna Esemy a. Ytopyra yna ahtao yna enahkãko mana tyrohsẽ ke, etonatoh ke, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ynara tykase Ejitu tõ tuisary Moeze tomo a, Arão maro: — Oty katoh ypoetory tõ akorekehkãko hmatou? Ypoetory tõ topehke pyra erohketõ aropoko ropa toerohtohkõ pona ropa. ");
INSERT INTO apyNT_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ynara tykase roropa ynororo: — Enetoko ke, tuhkehxo matose toehse. Oty katoh aerohtohkõ rumekapõko matou oserematohme rokene? ");
INSERT INTO apyNT_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Moro ẽmepyry ae ro Izyraeu tõ tyrohmanohpose itamurumehxo tuisa a. Ynara tykase ynororo irohmanohponanomo a, erohketõ tuisary tomo a roropa: ");
INSERT INTO apyNT_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","— Taroino onahpoty onekaropyra ehtoko erohketomo a tijoro tõ ritohme. Ah nytõ toto tamoreme xine, onahpoty zupiry poko, anỹtohme eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Yrome tijoro tuhke tyripoko eya xine apitoryme toto nyrityã samo. Toiro tijoro onyripyra ahtao eya xine, toto wãnohnõko matose. Akĩme mã toto. Naeroro kohtãko mã toto: “Ehmaropa okyno zahkatohme kynekarorykõme Ritonõpo a,” ãko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Naeroro yronymyrymehxo irohmanohpoko toto, erohkehpyra toto ehtohme, oseremara toto ehtohme, ajohpe ehtoh onetara toto ehtohme, tykase tuisa. ");
INSERT INTO apyNT_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Mame mokaro irohmanohponanomo, erohketõ tuisary tõ roropa tutũtase Izyraeu tõ zuruse. Ynara tykase toto eya xine: — Tuisa ynara nase: taroino onahpoty onekaropyra mana oya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Aomi poe amarokõ, amoreme xine, onahpoty zupĩko, anỹtohme. Yrome tuhke tijoro rĩko ro matose apitoryme tuhke onyrityãkõ samo. ");
INSERT INTO apyNT_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Morara exiryke sapararahme toytose toto Ejitu nonory poro onahpoty apoitohme tyya xine, tiriiku zoko roropa ipuhturu tapoise ahtao esẽkomo a. ");
INSERT INTO apyNT_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Mame kokoro rokẽ Izyraeu tõ tãtarypose irohmaponanomo a tijoro riry poko, tuhke tyripotohme eya xine, apitoryme toto nyrityã samo onahpoty tokarose ahtao eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Izyraeu tõ tamuximãkõ typitypipohse irohmaponanomo a. Tõturupose toto eya xine. Ynara tykase toto: — Oty katohme tuhke hkopyra tijoro tõ rĩko hmatou? apitorymã sã pyra? ");
INSERT INTO apyNT_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Mame Izyraeu tõ tamuximãkõ toytose ekaropose tuisa a. Ynara tykase toto: — Oty katohme yna ryhmãko mahno? Opoetoryme ynanase. ");
INSERT INTO apyNT_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Seromaroro onahpoty onekaropopyra mase yna a. Yrome tuhke tijoro tyripõko ro mã toto yna a. Moro motye yna pipohnõko mã toto. Mokaro, yna rohmanohponanõ zae pyra mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Yrome ynara tykase Ejitu tõ esemy: — Amarokõ akĩme rokẽ matose. Oerokurukõ se pyra matose. Morara exiryke ekaropõko matose ya oytotohkõ poko oeky tõ zahkatohme onekarorykõme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ytotoko ropa oerohtohkõ pona. Onahpoty onekaropyra oya xine mã toto. Yrome tuhke tijoro rĩko ro matose apitoryme onyrityãkõ samo. ");
INSERT INTO apyNT_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Morara kary etaryke tyya xine, Izyraeu tõ tamuximãkõ mã tuaro toehse tupime toehtohkõ poko. Kokoro rokẽ tuhke tijoro tyripose eya xine apitoryme toto nyrityã samo. ");
INSERT INTO apyNT_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Moromeĩpo tõturukehse toto ahtao tuisa maro tõseporyse Moeze tõ maro Arão maro. Toto eraximãko toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ynara tykase toto: — Onyrirykõ enẽko Ritonõpo mana. Awãnohtorỹko mana. Opokoino xine yna zehno tuisa mana, ipoetory tõ roropa yna zehno mã toto. Opokoino xine yna orihmapõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mame tõturuse ropa Moeze Ritonõpo maro. Ynara tykase ynororo: — Ritonõpo, oty katohme opoetory tõ ryhmãko mah? Oty katohme kuenehpoase xiaro? ");
INSERT INTO apyNT_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ynara exiryke: Õmihpyry omi poe tõturupitose jahtao Ejitu tõ tuisary maro, opoetory tõ tyyryhmase eya. Yrome toto onypynanohpyra mekurehno roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Mame ynara tykase Ritonõpo Moeze a: — Seromaroro ynyriry Ejitu tuisary a enẽko mase. Ynara tyripõko ase eya: ypoetory tõ akorehmãko mana aytorykõ poko. Ỹ, tãtaryporyke toto aropõko mana tynonory rumekatohme eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ynara tykase Ritonõpo Moeze a: — Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Osenepoase Aparão a te, Izake a te, Jako a roropa Ritonõpo Jamihmehxo Exiketyme. Yrome jesety kurã Oesẽkõme onekaropyra exine eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Jomihpyry ekarone eya xine. Ynara akene: Sero nono ekarõko ase, Kanaã ekarõko ase apakomotyamo a. Moro nono po katonõme sã rokẽ toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Seromaroro Izyraeu tõ pusuh kary totase ya. Topehke pyra toto rohmanohpotoh Ejitu põkomo a tonese ya. Wenikehpyra ase jomihpyry poko. ");
INSERT INTO apyNT_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Naeroro ynara kahtoko Izyraeu tomo a: “Ywy ase Oesẽkomo. Opynanohtorỹko ase otuarimatohkõ wino Ejitu po. Yjamitunuru ke Ejitu põkõ wãnohnõko ase yronymyryme. Opynanohtorỹko ase. ");
INSERT INTO apyNT_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Oritorỹko ase ypoetory tõme. Ywy Oesẽkõme exĩko ase. Tuaro exĩko matose Ritonõpome jexiry poko, Oesẽkõme, opynanopyrykohtao ya otuarimatohkõ wino Ejitu po. ");
INSERT INTO apyNT_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Aarotorỹko ase, jomihpyry ae ro Aparão a te, Izake a te, Jako a roropa: ‘Sero nono emero ekarõko ase apakomotyamo a,’ katopõpyry ae ro. Mame moro nono ekarõko ase oya xine oesarykõme. Ywy ase Oesẽkomo.” ");
INSERT INTO apyNT_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Izyraeu tõ turuse Moeze a, Ritonõpo omihpyry emero. Yrome onetara toh kynexine, typoremãkapose toto exiryke ikurohtao xine, yronymyryme toto rohmanohporyke Ejitu põkomo a. ");
INSERT INTO apyNT_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","— Ytoko, Parao, Ejitu tuisary zuruse: “Ah Izyraeu tõ nytõ toto ononory poe.” ");
INSERT INTO apyNT_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Yrome ynara tykase Moeze Ritonõpo a: — Izyraeu tõ jomiry etary se pyra toehse. Mokaro motye jomiry etary se pyra tuisa exĩko mana. Tupime jotururu ya roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Mame tõmipona Moeze tõ tyripose Ritonõpo a Arão maro, ynara katohme Izyraeu tomo a, Ejitu tuisary a roropa: — Yna tonyohse Ritonõpo a, Izyraeu tõ arotohme, Ejitu nonory poe. ");
INSERT INTO apyNT_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ynara mã oxiekyryme exiketomo, Moeze tõ tamuru tomo, Arão maro: Rupẽ, Jako mũkuru apitorymano toemũkuase asakoropane: Enoke te, Paru te, Ezerõ te, Karami, enara. Mokaro mã Rupẽ ekyry tomo. ");
INSERT INTO apyNT_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ximeão toemũkuase 6me: Jemueu te, Jamĩ te, Oate te, Jakĩ te, Zoa te, Sauu, enara. Sauu eny Kanaã põme kynexine. Mokaro mã Ximeão ekyry tomo. ");
INSERT INTO apyNT_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Rewi toemũkuase oseruao: Jeresõ te, Koate te, Merari, enara. 137me jeimamyry taropose Rewi a. ");
INSERT INTO apyNT_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Jeresõ toemũkuase asakoro: Ripani te, Ximei, enara. Tuhke tumũkue te, typakõke roropa toehse toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Koate toemũkuase asakoropane: Anarão te, Isara te, Eperõ te, Uzieu, enara. 133me jeimamyry taropose Koate a. ");
INSERT INTO apyNT_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari toemũkuase asakoro: Mari te, Muxi, enara. Mokaro Rewi ekyry tõ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Anarão typytase tumy oryxiry maro. Toemũkuase toto asakoro: Arão te, Moeze, enara. 137me jeimamyry taropose Anarão a. ");
INSERT INTO apyNT_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isara toemũkuase oseruao: Kora te, Nepeke te, Zikiri, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzieu roropa toemũkuase oseruao: Misaeu te, Euzapã te, Xitiri, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arão typytase Erisepa maro, Aminatape ẽxiry, Nasõ oryxiry. Toemũkuase toto asakoropane: Natape te, Apiu te, Ereaza te, Itamaa, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora toemũkuase oseruao: Axia te, Eukana te, Apiasape, enara. Mokaro Kora ekyry tõ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ereaza, Arão mũkuru, typytase toiro Putieu ẽxiry maro. Toemũkuase toto toiro: Pineiame. Mokaro oxiekyry tõ tuisary kynexine Rewi ekyry tomo. ");
INSERT INTO apyNT_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Arão tõ taropose Ritonõpo a Moeze maro ynara karyke: Izyraeu tõ arotoko Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Toytose ynaroro oturuse Parao, Ejitu tuisary a, Ejitu poe Izyraeu tõ arotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Moeze maro tõturuse Ritonõpo ahtao Ejitu po, ");
INSERT INTO apyNT_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ynara tykase ynororo: — Ywy ase Oesẽkomo. Parao, Ejitu tuisary zuruko emero ynekarory oya. ");
INSERT INTO apyNT_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Yrome Moeze a tozuhse. Ynara tykase ynororo: — Ritonõpo, tupime ya jotururu. Otãto jomiry etãko tuisa nae? ");
INSERT INTO apyNT_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Mame ynara tykase Ritonõpo Moeze a: — Ynara tyrĩko ase: ritõme sã orĩko ase tuisa a; orui Arão oturuketyme tyrĩko ase, õmiry ekaroneme. ");
INSERT INTO apyNT_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Arão zurũko mase emero ynekarory oya. Mame oturũko ynororo tuisa maro, Izyraeu tõ aropotohme Ejitu nonory poe. ");
INSERT INTO apyNT_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Yrome tuisa aosenetupuhtoh tũpore sã tyripõko ase. Mame yjamitunuru ke toto enaroxitapãkãko ase, Ejitu põkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Õmirykõ onetara exĩko tuisa mana. Mame mokyro wãnohnõko ase iiryhmatoh ke. Ypoetory tõ arõko ase Ejitu poe, Izyraeu tomo. ");
INSERT INTO apyNT_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Mame tuãnohse toto ahtao ya, ypoetory tõ Izyraeu tõ tarose ahtao ya Ejitu poe tuaro exĩko mã toto: Ywy ase Ritonõpo emero Esemy. ");
INSERT INTO apyNT_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mame Ritonõpo nyripohpyry tyrise Moeze a Arão maro, aomihpyry omipona. ");
INSERT INTO apyNT_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Tõturuse toto ahtao Ejitu tuisary a, 80me jeimamyry Moeze nae kynexine, Arão 83me jeimamyry nae kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ynara tykase Ritonõpo Moeze a, Arão maro: ");
INSERT INTO apyNT_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","— Yjamitunuru enery se Ejitu tuisary ahtao, omoro Moeze, orui zuruko tymyxiry ematohme nono pona tuisa ẽpataka. Okoime anyhtãko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mame morara tyrise Moeze a Arão maro. Toytose toto osẽpatakamase tuisa maro. Tymyxiry tomase Arão a nono pona tuisa ẽpataka oximõmãkõ neneryme. Mame okoime tanyhtase Arão myxiry. ");
INSERT INTO apyNT_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mame pyaxi tõ tykohmase tuisa a, tuarohxo exiketomo. Isaaro tyrise eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Tymyxiry tomase ahtao nono pona pyaxi tomo a okoime tanyhtase toto imyxirykõ roropa. Yrome Arão myxiry a toto myxiry tõ tonahse porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Morohne eneryhtao ro tuisa aosenetupuhtoh tũpore ro kynexine Ritonõpo nekarohpyry ae ro. Moeze tõ omiry, Arão maro onymoipyra kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Mame ynara tykase Ritonõpo Moeze a: — Ejitu tuisary aosenetupuhtoh tũpore mana. Ejitu poe ypoetory tõ anaropopyra mana aporo. ");
INSERT INTO apyNT_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kokoro pakeimo mokyro zupiko aytoryhtao Niro kuaka. Omyxiry aroko, okoime tanyhtase aexihpyry. Mame eraximatatoko tuna ehpikoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ynara kaxiko eya: “Ritonõpo epereu tõ Esemy jenehpoase ourutohme: Ah ypoetory tõ nytõ toto ona pona jeahmatohme. Yrome Ritonõpo nyripohpyry omipona pyra mexino. ");
INSERT INTO apyNT_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Seromaroro, ãko Ritonõpo, inyriry eneryke oya Ritonõpome aexiry waro exĩko mase. Tuisa, seromaroro tuna etapãko ase nakuatao, sero ymyxiry ke. Mame sero tuna anyhtãko munume. ");
INSERT INTO apyNT_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Kana tõ nakuaõkõ orihnõko mã toto. Sero tuna su ãko mana, tymoke. Mame moro tuna xihpyry enyry se pyra exĩko Ejitu põkõ mana.” ");
INSERT INTO apyNT_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ynara tykase roropa Ritonõpo Moeze a: — Kaxiko Arão a, tymyxiry anỹtohme tuna tõ poro, iporiry tõ maro, ikuhpo tõ maro, morohne tunary anyhtatohme munume. Ahtao munume exĩko paxiha tõ wewe risẽ ao, oripo tõ topu risẽ ao roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ritonõpo nyripohpyry tyrise Moeze a Arão maro. Tuisa ẽpataka, ipoetory tõ maro tymyxiry tanỹse Arão a, tuna totapase eya nakuatao, munume moro tuna tanyhtase. ");
INSERT INTO apyNT_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kana tõ toorihse, tymoke toehse tuna, su ãko xihpyryme. Tuna onẽsaromepyra toehse Ejitu põkomo. Emero esarykõ po, Ejitu po munume toehse kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Yrome pyaxi tõ a roropa tukuhse ahtao morara tyrise eya xine isaaro. Naeroro tuisa aosenetupuhtoh tũpore ro kynexine. Ritonõpo omihpyry ae ro Moeze tõ omiry Arão maro onymoipyra kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Morarame toeramase tytapyĩ konõto taka ropa, torẽtyke pyra morohne poko. ");
INSERT INTO apyNT_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Eutary tõ tahkase Ejitu põkomo a emero, tuna ehpio tuna kurã zupitohme, moro tuna kuaõ onẽsaromepyra toexirykõke. ");
INSERT INTO apyNT_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","7me ẽmepyry taropose eya xine, tuna Niro totapase ahtao Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Moromeĩpo ynara tykase Ritonõpo Moeze a: — Ytoko tuisa zuruse, kaxiko ynara ãko Ritonõpo eya: “Ah ypoetory tõ nytõ toto sero nonory poe jeahmatohme. ");
INSERT INTO apyNT_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Toto anaropopyra awahtao awãnohtorỹko ase pororu tõ ke. ");
INSERT INTO apyNT_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Tuna Niro pehkãko pororu tõ mana. Moro kuae tũtãko mã toto omõtohme tuisa tapyĩ konõto taka, tuisa nyhtoh taka te, etuety pona te, ipoetory tõ tapyĩ taka te, imehnõ tapyĩ taka te, wyi ritoh aka, ekeitoh aka, paxiha tõ aka wyi riryhtao, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Pyhseky ãko pororu tomo opona xine te, ahno pona te, otuisary tõ pona, enara.” ");
INSERT INTO apyNT_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ynara tykase roropa Ritonõpo Moeze a: — Arão zuruko tymyxiry anỹtohme tuna poro te, iporiry tõ po te, pẽkamã kõ po te, pororu tõ kohmatohme nakuae nono po pororu tuhke ehtohme Ejitu nonory po. ");
INSERT INTO apyNT_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Mame Ejitu tunary tõ poro tymyxiry tanỹse Arão a. Pororu tõ tutũtase tuna kuae Ejitu nonory pehnõko sã porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Yrome pyaxi tõ a roropa tukuhse ahtao pororu tõ tonehpose Ejitu nonory pona. ");
INSERT INTO apyNT_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Mame Moeze tõ tykohmapose tuisa a Arão maro. Ynara tykase ynororo: — Oturutoko Oesẽkõ Ritonõpo a pororu tõ aropotohme ropa yna wino. Izyraeu tõ aropõko ase amaro xine okyno tõ zahkatohme onekarorykõme eya, tykase repe. ");
INSERT INTO apyNT_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ynara tykase Moeze: — Kure. Tãkye ase jotururu poko Ritonõpo a opoko xine. Kaxiko ya otara ahtao jotururu se hma Ritonõpo a ãkorehmatohme te, opoetory tõ akorehmatohme te, ononory põkõ emero akorehmatohme, pororu tõ aropotohme ropa atapyĩ konõto tae, imehnõ tapyĩ tõ tae roropa, tuna kuao rokẽ toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","— Kokoro oturuko ypoko, tykase tuisa. — Ỹ, morara tyrĩko ase õmihpyry ae ro, tykase Moeze. Mame zuaro exĩko mase; imepỹ isã pyra mana, Ritonõpo rokene Kuesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Owino xine pororu tõ ytõko ropa, atapyĩ tõ tae te, otuisary tõ wino te, Ejitu põkõ wino porehme, enara. Tuna Niro kuao rokẽ pororu tõ exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mame tuisa tapyĩ tae tutũtase Moeze tomo, Arão maro. Tõturuse Moeze Ritonõpo a pororu tõ aropotohme ropa, inenehpotyã tuisa wãnohtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mame Moeze omiry totase Ritonõpo a: pororu tõ toorihse tapyi tõ tao te, tupito tõ po te, ona po roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Kaetoko tuhke tyrise Ejitu põkomo a, pororu tomo. Su ãko kynexine Ejitu nonory po porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mame pororu tõ toorihse exiry tonese ahtao tuisa a, aosenetupuhtoh tũpore toehse ropa, Ritonõpo nekarohpyry ae ro. Moeze tõ onymoipyra toehse, Izyraeu tõ anaropopyra tokurehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Mame ynara tykase Ritonõpo Moeze a: — Kaxiko Arão a: “Nono etapako omyxiry ke.” Mame Ejitu nonory po nono anyhtãko azamo panõme. ");
INSERT INTO apyNT_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Tymyxiry ke nono totapase Arão a. Mame Ejitu nonory poro emero nono tanyhtase azamo panõme. Ahno poko toehse toto okyno tõ poko roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Morara riry tukuhse pyaxi tomo a. Yrome azamo panõ onyrisaromepyra toh kynexine. Ahno poko ro, okyno poko roropa azamo panõ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ynara tykase pyaxi tomo tuisa a: — Azamo panõ onyrisaromepyra ynanase Ritonõpo a rokẽ mokaro tyrise, tykase toto. Yrome tũpore ro tuisa osenetupuhtoh kynexine. Ritonõpo omihpyry ae ro Moeze omiry onenetupuhpyra kynexine, Arão maro. ");
INSERT INTO apyNT_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ynara tykase Ritonõpo Moeze a: — Kokoro pakeimo, tuisa ytoryhtao nakuataka ytoko eya oturuse. Kaxiko eya, ynara ãko Ritonõpo oya: “Ah ypoetory tõ nytõ toto Ejitu nonory poe, jeahmase. ");
INSERT INTO apyNT_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Toto anaropopyra awahtao moromoro tõ enehpõko ase awãnohtohme te, opoetory tõ maro te, ahno maro emero. Ejitu põkõ tapyĩ tõ pehme exĩko mã kehko moromoro ke. Nono pehme exĩko moromoro ke. ");
INSERT INTO apyNT_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Yrome ypoetory tõ esary Kosẽ pynanohnõko ase, moroto moromoro pyra ehtohme. Morara ahtao zuaro exĩko matose ywy, Ritonõpo taro ase sero nonory po. ");
INSERT INTO apyNT_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Tyoro tyrĩko ase ypoetory tomo a, opoetory tomo a ynyriry sã pyra. Kokoro morara tyrĩko ase.” ");
INSERT INTO apyNT_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Mame morara tyrise Ritonõpo a. Moromoro tuhke tomõse tuisa tapyĩ taka ipoetory tõ tapyĩ taka roropa. Tyrohsẽ konõto kynexine Ejitu tõ nonory po porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Naeroro Moeze tõ tykohmapose tuisa a, Arão maro. Ynara tykase ynororo: — Ytotoko okyno tõ zahkase onekarorykõme Oesẽkõ Ritonõpo a, yrome morara tyritoko taro Ejitu nonory po, tykase. ");
INSERT INTO apyNT_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","— Arypyra, tykase Moeze, morara zae pyra mana. Ynara exiryke: yna eky tõ etapary yna a jahkatohme ynanekaroryme Ritonõpo a oenurukõ zamaro pyra mana. Oryhpopãkatorỹko mana. Mame yna zehno exĩko Ejitu põkõ nase. Yna etapãko topu ke mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Oseruao ẽmehnõko ynanase yna ytory poko ahno esaka pyra. Moroto yna eky etapãko ynanase jahkatohme ynanekaroryme Ritonõpo yna Esemy a, aomihpyry omipona se yna exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Mame ynara tykase tuisa: — Ỹ, ytotoko. Aaropotorỹko ase. Oekykõ etapatatoko jahkatohme onekarorykõme Ritonõpo Oesẽkomo a. Yrome mya nymyry pyra ytotoko. Oturutoko ypoko roropa, tykase Ejitu tuisary eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ynara tykase Moeze: — Jytoryhtao taroino oturũko ase Ritonõpo a moromoro tõ aropotohme kokoro owino te, opoetory tõ wino te, ahno wino porehme, enara. Yrome yna onenekunohpyra ropa exiko. Ah Izyraeu tõ nytõ toto tynekarorykõ zahkase, Ritonõpo tosẽkõ eahmaryme. ");
INSERT INTO apyNT_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mame tutũtase Moeze tuisa tapyĩ konõto tae. Tõturuse Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Mame Moeze omiry totase Ritonõpo a. Moromoro tõ taropose ropa Ejitu tuisary poe te, ipoetory tõ poe te, ahno poe emero, enara. Moromoro pyra toehse ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Yrome tuisa osenetupuhtoh tũpore toehse ropa. Izyraeu tõ anaropopyra tokurehse ropa ynororo. ");
INSERT INTO apyNT_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Morarame ynara tykase Ritonõpo Moeze a: — Ytoko tuisa zuruse ropa. Kaxiko eya Ritonõpo, epereu tõ Esemy, ynara ãko oya: “Ah ypoetory tõ nytõ toto sero nono poe jeahmase. ");
INSERT INTO apyNT_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Toto anaropopyra awahtao, ");
INSERT INTO apyNT_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","tyrohsẽ konõto enehpõko ase oeky tõ pona awãnohtohme, kawaru tomo te, kameru tomo te, pui tomo te, kaneru tomo te poti tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ypoetory tõ Izyraeu eky tõ apiakãko ase toto ewomatohme. Ejitu põkõ eky tõ rokẽ tyrohsẽ apoĩko mana, yrome Izyraeu tõ eky tõ orihpyra exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ywy Ritonõpo imenekano, kokoro morara tyritohme.” ");
INSERT INTO apyNT_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Yrokokoro morara tyrise Ritonõpo a tõmihpyry ae ro. Tyrohsẽ tooehse Ejitu tõ eky tõ pona. Toorihse toto emero. Yrome Izyraeu tõ eky tõ orihpyra toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Enenanõ tonyohse tuisa a tuaro toehtohme. Turuse ynororo, Izyraeu eky tõ orihpyra tokurehse toto porehme. Yrome aosenetupuhtoh tũpore ro kynexine. Izyraeu tõ anaropopyra kynexine ynororo. ");
INSERT INTO apyNT_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Mame ynara tykase Ritonõpo Moeze tomo a Arão maro: — Oemary ke oruno apoitoko apoto esary poe, ipahtohme kakoxi Ejitu tuisary ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Sapararahme oruno ytõko Ejitu nonory po porehme. Emero esao zaozao toh exĩko. Soporome exĩko ahno pihpyry poko, okyno pihpyry poko, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Naeroro oruno tapoise Moeze a Arão maro. Tuisa ẽpataka toytose toto. Mame Moeze a oruno tomase kakoxi. Zaozao toh toehse, soporome toehse roropa ahno pihpyry poko te, okyno pihpyry poko, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Mame pyaxi tõ oehsaromepyra toh kynexine Moeze ẽpataka zaozao toh pokoino typihpyrykõ poko, imehnõ Ejitu põkõ pihpyry samo. ");
INSERT INTO apyNT_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Yrome Ritonõpo a tuisa osenetupuhtoh tyripose tũpore. Ritonõpo omihpyry ae ro Moeze tõ omiry onenetupuhpyra ro tuisa kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Mame ynara tykase Ritonõpo Moeze a: — Kokoro pakeimo ytoko osẽpatakamase tuisa maro. Zuruko ynororo, ynara ãko Ritonõpo epereu tõ Esemy: “Ah ypoetory tõ nytõ toto sero nono poe jeahmase. ");
INSERT INTO apyNT_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Seromaroro oryhmatoh epukãko opona xine te, otuisary tõ pona te, ahno pona, enara, zuaro oehtohkõme, sero nono po imepỹ ysã exikety pyra mana. ");
INSERT INTO apyNT_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Oryhmarykõ se nymyry jahtao tyrohsẽ ke amarokõ tonahse exiry porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Yrome isene ro onomõko ase, yjamitunuru enepotohme oya xine juaro imehnõ ehtohme sero nono põkõ porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Epyrypãko ro mase. Ypoetory tõ Izyraeu anaropopyra roropa mase ononory poe. ");
INSERT INTO apyNT_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Naeroro kokoro konopoimo enehpõko ase, topu sã exikety maro, orẽpyra exikety. Sero konopoimo onenepitopyra Ejitu põkõ mana. ");
INSERT INTO apyNT_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Morara exiryke oekykõ enehtoko, jarao exiketõ emero, tapyi tõ taka. Omõpyra toto ahtao, konopoimo toehse ahtao, topuimo epukãko kaino. Mame orihnõko mã toto ahno tomo te, okyno roropa, enara.” ");
INSERT INTO apyNT_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Toitoine enaromỹke tuisa poetory tõ toehse morara kary etaryke tyya xine. Typoetory tõ tarose eya xine tytapyĩkõ taka, toky tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Yrome imehnõ tuisa poetory tõ putupyra rokẽ kynexine. Typoetorykõ tynomose eya xine jarao rokene, toky tõ maro tutupikõ po. ");
INSERT INTO apyNT_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Mame ynara tykase Ritonõpo Moeze a: — Oemary anỹko kakoxi konopoimo oehtohme, topuimo maro. Ejitu nonory pona epukãko mana, emero ahno pona te, okyno tõ pona te, otyro tõkehko pona tupito po. ");
INSERT INTO apyNT_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Tymyxiry tanỹse Moeze a kakoxi. Konomeru tonehpose Ritonõpo a te, konopoimo maro te, nenenehkane nono poro porehme. Tonehpose eya ");
INSERT INTO apyNT_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","konopoimo, topu panõ ke, nenenehkane maro, Ejitu nonory po porehme, okynano. Moro konopoimo, jamihme exiry panõ exipitopyra kynexine Ejitu ehpitotopõpyry poe. ");
INSERT INTO apyNT_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ejitu poro porehme konopoimo a jarao exiketomo tonahkase, ahno tomo te, okyno tõ roropa te, otyro tõkehko tupito tõ po te, wewe roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kosẽ nonory po rokẽ, Izyraeu tõ esary po konopoimo oehpyra kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Moeze tykohmapose tuisa a, Arão maro. Ynara tykase ynororo: — Toerypymase ywy seromaroro. Zae Ritonõpo Oesẽkõ mana. Ywy, ypoetory tõ maro, azahkuru ynanase. ");
INSERT INTO apyNT_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Oturuko Ritonõpo a. Epo mana konomeru, konopoimo topu tõ maro! Aaropotorỹko ropa ase. Taroino oneraximazomopopyra ase oya xine, tykase tuisa. ");
INSERT INTO apyNT_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ynara tykase Moeze: — Pata poe tutũtase jahtao jemary tõ anỹnõko ase jotururume Ritonõpo Kuesẽkomo a. Konomeru mynyhpãnõko, konopoimo oehkehnõko. Moro eneryke oya zuaro exĩko mase, sero nono Ritonõpo kyryryme mana. ");
INSERT INTO apyNT_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Yrome zuaro ase, Oesẽkõme Ritonõpo onenetupuhpyra ro matose opoetory tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Mauru panõ, otyro roropa anarykatyã tonahkase, tupuhtuke exiketomo te, tokure exiketõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Yrome tiriiku onenahkara exipyra ro exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mame tuisa maro ehxĩpo tutũtase Moeze pata poe. Tomary tõ tanỹse eya tõtururume Ritonõpo Tosẽkomo a. Mame konomeru tymynyhpãse, konopoimo roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Yrome konopoimo te, konomeru roropa mynyhpãtopõpyry eneryke tuisa a, iirypyryme toehse ropa ynororo. Izyraeu tõ anaropopyra toehse ropa ynororo ipoetory tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Mame Ritonõpo omihpyry ae ro, Moeze maro Izyraeu tõ anaropopyra tuisa kynexine tynonory poe. ");
INSERT INTO apyNT_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ynara tykase Ritonõpo Moeze a: — Ytoko tuisa zuruse. Aosenetupuhtoh tyripose ya tũpore, ituisary tõ maro. Jomiry onetara ynaroro tyripose ya yjamitunuru enepotohme eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Omũkurukõ te, apakomotyãkõ zurutohme roropa oya xine imeĩpo, Ejitu põkõ poremãkatopõpyry poko ya te, yjamitunuru enepotopõpyry poko eya xine. Morarame tuaro exĩko matose, ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moeze toytose Arão maro tuisa zuruse. Ynara tykase toto eya: — Ritonõpo epereu tõ Esẽ ynara ãko: “Otarahtao jomiry moĩko mano? Jomiry omipona exĩko mano? Ah ypoetory tõ nytõ toto sero nono poe jeahmase. ");
INSERT INTO apyNT_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Toto anaropopyra awahtao, kokoro taparara tõ enehpõko ase xiaro. ");
INSERT INTO apyNT_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Nono onenesaromepyra exĩko matose pehme exiryke taparara ke, Ejitu nonory po. Otyro enahnõko emero konopoimo nynomohpyry. Wewe roropa amoriry enahnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Atapyĩkõ pehkãko mã toto, otuisary tõ tapyĩ tao roropa, ahno tapyĩ tao roropa. Sero oryhmatoh panõ onenepitopyra omykomo, atamuru tõ roropa moino ro.” Morara tykase Moeze. Mame tutũtase ynororo tuisa tapyĩ tae. ");
INSERT INTO apyNT_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Mame ynara tykase tuisa poetory tõ eya: — Otara ahtao kuerekohmakehnõko mokaro nae? Ah mokaro orutua kõ nytõ toto tosẽkõ Ritonõpo eahmase. Tuaro pyra ro mahno Ejitu enahkatoh poko? ");
INSERT INTO apyNT_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Mame Moeze tõ tarose ropa Arão maro tuisa ẽpataka ropa. Ynara tykase ynororo eya xine: — Jomi poe ytotoko Ritonõpo Oesẽkõ eahmase. Yrome zuaro se ase: onokãkõ ytõko nae? ");
INSERT INTO apyNT_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","— Yna ytõko emero, tykase Moeze, yna poenõ maro, tamuhpomãkõ maro. Yna mũkuru tõ arõko ynanase, yna ẽxiry tõ maro te, yna eky tõ maro: kaneru tomo te, poti tõ maro te, pui tomo, enara. Otuhtoh konõto rĩko ynanase Ritonõpo yna Esẽ eahmaryme. ");
INSERT INTO apyNT_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ynara tykase tuisa: — Otarame Ritonõpo amaro xine ytõko mana. Yrome opyxiãkõ anaropopyra ase opoenõ maro. Tuaro ase oeparykõ poko atamorepãko matose, yna rumekatohme. ");
INSERT INTO apyNT_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Arypyra! Orutua kõ rokẽ aropõko ase Ritonõpo eahmatohme, moro se awahtao xine. Mame Moeze tõ taropose Arão maro tuisa maro ehxĩpo. ");
INSERT INTO apyNT_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Mame ynara tykase Ritonõpo Moeze a: — Oemary anỹko Ejitu po taparara tõ oehtohme. Oehnõko mã toto otyro enahkase emero, konopoimo nenahkahpyry akoĩpyry enahkase. ");
INSERT INTO apyNT_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Tymyxiry tanỹse Moeze a Ejitu po. Tyryrykane tonehpose Ritonõpo a xixi tũtatoh wino. Tyryry tykase nono poro saereme, koko, enara. Mame tõmehse ahtao taparara tõ tonehse tyryrykane a. ");
INSERT INTO apyNT_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Sapararahme toytose toto Ejitu poro porehme, taparara tuhke. Moro panono exipitopyra kynexine moino ro. Mokaro panõ exipyra ropa exiry jumãme. ");
INSERT INTO apyNT_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Nono typehkase eya xine. Xinukutume toehse. Otyro akoĩpyry tonahse eya xine, epery tõkehko wewe poko, konopoimo nenahkahpyry akoĩpyry. Wewe ary te, onahpoty roropa, tonahkase eya xine Ejitu nonory po porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Taryporyke Moeze tykohmapose Arão maro tuisa a. Ynara tykase ynororo: — Iirypyryme toehse ywy Ritonõpo Oesẽkomo a, oya xine roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Seromaroro yyrypyry ikorokapoko Ritonõpo a. Oturuko roropa eya sero juãnohtoh xihpyry aropotohme ropa ywinoino. ");
INSERT INTO apyNT_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Tuisa tapyĩ tae tutũtase ropa Moeze. Tõturuse ynororo Ritonõpo Tosemy a. ");
INSERT INTO apyNT_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Mame tyryrykane tonehpose Ritonõpo a xixi omõtoh wino jamihme exikety. Taparara tõ tanỹse eya, tomase toto tuna konõto Tahpiremã kuaka emero porehme. Taparara pyra toehse ipunaka Ejitu nonory po. ");
INSERT INTO apyNT_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Yrome Ritonõpo poe tuisa osenetupuhtoh tũpore exikehpyra toehse. Izyraeu tõ anaropopyra kynexine ynororo. ");
INSERT INTO apyNT_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Mame ynara tykase Ritonõpo Moeze a: — Oemary anỹko kakoxi, ikohmãkapotohme Ejitu nonory poro porehme, xinukutume ehtohme ipunaka, moro xinukutumã apõko sã mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Tomary tanỹse Moeze a kakoxi. Tykohmãse Ejitu po. Oseruao ikohmamyry taropose ẽmehpyra. ");
INSERT INTO apyNT_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Imehnõ onenesaromepyra Ejitu põkõ kynexine. Morara ahtao tytapyĩkõ tae tũtara toh kynexine. Yrome Izyraeu tõ tapyĩ tao saereme kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Moeze tykohmapose tuisa a tyya. Ynara tykase ynororo eya: — Ytotoko. Izyraeu tõ aropõko ase Ritonõpo eahmase Oesẽkomo. Opyxiãkõ arotoko opoenõkõ maro. Yrome oeky tõ: kaneru tomo te, poti tomo te, pui tõ maro taro rokẽ exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","— Morara ahtao, tykase Moeze, — omoro ro okyno tõ ekarõko mase yna a etapatohme, jahkatohme ynanekaroryme Ritonõpo yna Esẽ eahmaryme. ");
INSERT INTO apyNT_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Morara se pyra ynanase. Yna eky tõ arory se ynanase. Toiro okyno onynomopyra ynanase. Imenekary se ynanase toitoine ynanekaroryme Ritonõpo eahmatohme, yna Esẽme. Morotona eporehkara ro yna ahtao, zuaro pyra ynanase onokãkõ etapãko ynanase ynanekaroryme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Yrome Ritonõpo a tuisa osenetupuhtoh tũpore tyripose. Naeroro Izyraeu tõ anaropopyra kynexine Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ynara tykase ynororo Moeze a: — Epo hnae! Esyryhmako taroino! Jũme oehpyra ropa exiko tarona! Tooehse ropa awahtao orihnõko mase! ");
INSERT INTO apyNT_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","— Zae mase, jenepyra ropa mase jũme, tykase Moeze eya. ");
INSERT INTO apyNT_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ynara tykase Ritonõpo Moeze a: — Toiro Ejitu tuisary wãnohtoh enehpõko ro ase Ejitu põkõ wãnohtohme. Moromeĩpo aaropotorỹko mana. Ajohpe pyra aaropotorỹko mã rahkene. ");
INSERT INTO apyNT_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Seromaroro Izyraeu tõ zuruko, orutua komo, nohpo tõ maro: uuru risẽ ekaropotohme parata risẽ roropa, Ejitu põkomo a. ");
INSERT INTO apyNT_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ritonõpo poe Izyraeu tõ akorehmary se toh kynexine. Ajohpe pyra, Moeze tonetupuhse tuisa poetory tomo a, orutua imehxo exiketyme. ");
INSERT INTO apyNT_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mame tuisa turuse Moeze a, ynara tykase Ritonõpo: “Onoa ytõko ase Ejitu poro. ");
INSERT INTO apyNT_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ononorykõ poro porehme omũkurukõ osemazupu tõ orihnõko mã toto: emero tapyi tao, tuisa mũkuru poe, jumy nymenekahpyry tuisame tymyakãme, erohkety mũkuru pona, tiriiku apory poko exikety. Orihnõko roropa okyno mũkuru tomo, apitoryme aenurutyamo. ");
INSERT INTO apyNT_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ejitu poro kui ãko mã toto, xitãko sam karyke. Sero panõ exipitopyra kynexine moino ro. Ipanõ exipyra ropa exĩko jũme. ");
INSERT INTO apyNT_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Yrome Izyraeu tõ esary po mynyhme rokẽ exĩko. Kaikuxi tõ roropa hoho kara exĩko mã toto. Zuaro oehtohkõme, ywy, Ritonõpo Ejitu põkõ apiakãko ase Izyraeu tõ wino.” ");
INSERT INTO apyNT_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Etyhpyryme ynara tykase Moeze: — Opoetory tõ esã emero jupĩko mã toto, tosekumuru po porohnõko mã toto jẽpataka, “Ajohpãme sã ytotoko taroino. Izyraeu tõ aroko porehme,” ãko mã toto. Moromeĩpo ytõko ase. Tutũtase Moeze tohne tuisa oturutoh poe. ");
INSERT INTO apyNT_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Mame ynara tykase Ritonõpo Moeze a: — Õmiry onetara tuisa mana, yjamitunuru ke ynyrityã ritohme osenuruhkatohme Ejitu po. ");
INSERT INTO apyNT_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Morohne tyrise Moeze tomo a Arão maro, Ritonõpo jamitunuru enepotohme Ejitu tuisary ẽpataka. Yrome Ritonõpo poe aosenetupuhtoh tũpore rokẽ kynexine. Izyraeu tõ anaropopyra kynexine Ejitu nonory poe. ");
INSERT INTO apyNT_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ynara tykase Ritonõpo Moeze tomo a Arão maro Ejitu po: ");
INSERT INTO apyNT_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","— Sero nuno apitorymãme exĩko, jeimamyry ae oya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ynara kaxiko Izyraeu tomo a emero: Ẽmepyry 10mã po, sero nuno po emero jũkõ kaneru menekãko, kaneru pyra ahtao poti menekãko tytapyĩ taõkõ zotyme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Tuhke pyra itapyĩ taõkõ ahtao, tokykõ onõsaromepyra toto ahtao tytororo, imepỹ tapyi esẽ maro exĩko mana oximaro toiro okyno apiakatohme eya xine. Tõsẽ apiakãko mã toto ahno pune ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Okyno menekãko kaneru mũkuru te, otarame poti orutuame atapuropyra exikety, toiro jeimamyry nae exikety. ");
INSERT INTO apyNT_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Mame kokonie pukuro ẽmepyry 14mã po, sero nuno po tokykõ etapãko mã Izyraeu tõ porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Imunuru pitiko ke omõtoh ehpiry zonohnõko mã toto iratozome, kae roropa, enara. Mame moro tapyi tao moro tõsẽ õnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Koko moro tõsẽ purũko mã toto ikarã po, tõtohme otyro itũ exiketõ maro, wyi iporutatoh maro pyra exikety maro. ");
INSERT INTO apyNT_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Moro tõsẽ onõpyra matose onupurupyra ahtao, tahnose ahtao tuna maro roropa onõpyra matose. Okyno tytororo purũko matose, zupuhpyry maro, jaxiry tõ maro te, erery te, eano tõkehko purũko matose ikarã po. ");
INSERT INTO apyNT_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Tõsẽ akoĩpyry onukurãkara ehtoko yrokokoro. Akoĩpyry ahtao jahkatoko. ");
INSERT INTO apyNT_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Otupohtotoko, asapatũkõ amurutoko roropa, omyxirykõ apoitoko. Taryporyke sã mokyro pũ õnõko matose. Sero mã Paxikoame, Otuhtoh Epozakuroko jeahmatohme Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","— Sero koko ytõko ase Ejitu nonory poro imũkurukõ apitorymãkõ etapase emero, ahno mũkuru tomo te, okyno mũkuru tomo, enara. Ejitu põkõ ritõ tõ wãnohnõko ase porehme. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Munu, tapyi omõtoh ehpiry poko eneryhtao ya enetupuhnõko ase Izyraeu tõ tapyĩme exiry poko. Ejitu põkõ wãnopyryhtao ya, moro munu eneryhtao ya, epozakuroko ytõko ase etypohpyra ase, oryhmara xine exĩko ase. ");
INSERT INTO apyNT_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Mame emero ikonopory punero oseahmãko matose sero ẽmepyry ae. Jeahmãko roropa matose wenikehpyra oehtohkõme; ywy, Ritonõpo, ynyrihpyryme moro. Oseahmatoh Epozakuroko ytotopõpyry poko tyrĩko matose oseahmatohme. Apakomotyã roropa morara tyrĩko mã toto jũme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Mame 7me ẽmepyry wyi enahnõko matose iporutatoh maro pyra exikety. Porutapỹ rokẽ enahnõko matose. Naeroro ẽmepyry apitorymã po porutakety ipahtoko emero arypyra ehtohme atapyĩkõ htao. Morarame ẽmepyry apitorymã poe 7mã pona wyi iporutatoh maro enapyryhtao imepyny a mokyro taroposẽme exĩko mana ypoetory tõ Izyraeu tõ winoino. ");
INSERT INTO apyNT_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ẽmepyry apitorymã po te, 7mã po roropa oximõme ehtoko Ritonõpo eahmatohme. Moro ẽmepyry tõ ae erohpyra exĩko matose, yrome tonahsẽ riry poko erohnõko ro matose. ");
INSERT INTO apyNT_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Oseahmatoh Wyi poko Iporutatoh maro pyra, emero jeimamyry ae. Sero nuno po, sero ẽmepyry po, õseahmatohkõ tyritoko, wenikehpyra oehtohkõme, seroae Ejitu nonory poe Izyraeu tõ tarose ya. Naeroro sero oseahmatoh tyripõko ase oya xine jumãme onytyoromara ehtohme. Jũkõ tumũkuru tõ amorepãko mã toto, moro ynyripohpyry poko. ");
INSERT INTO apyNT_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Kokonie pukuro ẽmepyry 14mã poe, nuno apitorymã po, ẽmepyry 21 pona kokonie pukuro nuno apitorymã poro, ourukõ enahnõko matose porutapỹ rokene. ");
INSERT INTO apyNT_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","7me ẽmepyry pune iporutatoh pyra atapyĩ tao tyritoko. Ynara exiryke wyi enapyryhtao iporutatoh maro, moro 7me ẽmepyry ae, katonõme ahtao ro ehse ononory po te, Izyraeume exikety ahtao ro, taroposẽme exĩko Izyraeu tõ winoino. ");
INSERT INTO apyNT_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Naeroro moro 7me ẽmepyry ae tonahsẽ iporutatoh maro onenahpyra ehtoko. Atapyĩkõ tao wyi porutapỹ risẽ tonahsẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Izyraeu tõ tamuximãkõ tykohmapose Moeze a. Ynara tykase ynororo eya xine: — Okyno imenekatoko kaneru te, kaneru pyra ahtao, poti etapatohme kuohkõme, Izyraeu tõ emero oseahmatohme, Epozakuroko ytosẽ poko. ");
INSERT INTO apyNT_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Otyro hissopo amoriry apoitoko ehxikatohme munu ke paxiha ao. Mame atapyĩkõ omõtoh ehpiry isỹmako, iratozo tomo te, epoe, enara. Mame tũtara matose tapyi tae ẽmehtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ejitu põkõ etapase Ritonõpo ytoryhtao moro munu enẽko mana omõtoh ehpiry poko. Tynenyokyhpyry anaropopyra mana atapyĩ tõ taka oetapatohkõme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ynyripohpyry oya xine omipona ehtoko jũme; amarokomo te, opoenomo te, apakomotyã roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Oytorykohtao Ritonõpo nekarory pona, ononorykõ pona, Ritonõpo omihpyry omipona jeimamyry ae oseahmatoko sero samo, eahmaryme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Morarame opoenõkomo a ekaroporyhtao: “Oty kary se sero oseahmatoh nae?” ");
INSERT INTO apyNT_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Ynara ãko matose: “Kuekykõ etapãko sytatose Epozakuroko aytotopõpyry poko Ritonõpo eahmatohme, Ejitu po kytapyĩkõ epozakuroko toytose Ritonõpo exiryke. Etypohpyra kynexine Izyraeu tapyĩkõ tao. Ejitu tõ totapase eya, yrome Izyraeu tõ typynanohse eya.” Morarame tosekumuru po typorohse Izyraeu tomo, Ritonõpo eahmaryme Tosẽkõme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Mame toytose toto. Tyrise eya xine emero, Ritonõpo nyripohpyry Moeze tomo a Arão maro. ");
INSERT INTO apyNT_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Onoa Ejitu põkõ mũkuru tõ osemazuhme aenurutyã totapase Ritonõpo a emero tapyi tao; tuisa mũkuru osemazupu tumy myakãme exikety poe, ãpuruhpyry tao exikety mũkuru pona, okyno poenõ roropa totapase eya. ");
INSERT INTO apyNT_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Moro koko ae ro tynyhtoh poe towõse tuisa te, ipoetory tomo te, Ejitu põkõ emero. Ejitu poro ahno kynexine xitãko, kui ãko toiro imũkuru toorihse exiryke emero tapyi tao. ");
INSERT INTO apyNT_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Moro koko ae ro Moeze tykohmapose tuisa a, Arão maro. Ynara tykase: — Ytotoko taroino! Amarokomo, Izyraeu tõ maro porehme! Ynonory irumekatoko. Ytotoko Ritonõpo Oesẽkõ eahmase onekaropohpyrykõ ae ro ya. ");
INSERT INTO apyNT_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Oeky tõ arotoko, kaneru tomo te, poti tõ maro te, pui tõkehko maro. Ytotoko taroino. Ekaropoko Ritonõpo a kure rokẽ jyritohme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Taryporyke Izyraeu tõ aropory se toehse Ejitu põkomo. Ynara tykase toto: — Ytopyra awahtao xine orihnõko ynanase porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Naeroro wyi risẽ tapoise porutapỹ Izyraeu tomo a, emero tapyi taõkomo a, paxiha aka tyrise eya xine, tyõtose kamisa ke arotohme tymota po xine. ");
INSERT INTO apyNT_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Mame Moeze omihpyry ae ro Ejitu põkomo a uuru risẽ tokaropose Izyraeu tomo a te, parata risẽ maro te, upo roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ritonõpo poe mõkomo tokarose Ejitu põkomo a, ekarory se toexirykõke Izyraeu tomo a, emero tokaropose ahtao eya xine. Morara Ejitu põkõ mõkomory kurã tarose Izyraeu tomo a. ");
INSERT INTO apyNT_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Morarame Izyraeu tõ toytopitose pupu po Ramese poe Sukote pona. 600 miume orutua kõ kynexine, nohpo tõ onukuhpyra tuhke aehtohkomo te, poetohti roropa te, tamuhpomãkõ roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Toto maro imehnõ kynexine tuhke, toky tõ maro tuhke kaneru tomo te, poti tomo te, pui tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Mame wyi tyrise Izyraeu tomo a iporutatoh maro pyra. Moro wyi risẽ tonehse tymaro eya xine Ejitu poe. Taryporyke Ejitu poe toto taropose Ejitu põkomo a exiryke tonahsẽ onyrisaromepyra toh kynexine, wyi roropa onyrisaromepyra toh kynexine iporutatoh maro. ");
INSERT INTO apyNT_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","430me jeimamyry taropose Izyraeu tomo a Ejitu po. ");
INSERT INTO apyNT_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Morarame moro 430mãkõ tõtyhkase ahtao moro ẽmepyry ae ro tutũtase Ritonõpo poetory tõ emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Moro koko toto enẽko Ritonõpo kynexine toto arotohme Ejitu poe. Moro koko Ritonõpo eahmatohme toehse jũme. Moro koko tõseahmarykõme nyhpyra Izyraeu tõ porehme Ritonõpo omihpyry omi poe. ");
INSERT INTO apyNT_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ynara tykase Ritonõpo Moeze tomo a Arão maro: — Ynara tyripõko ase oya xine Epozakuroko jytotopõpyry poko. Moro Otuhtoh Epozakuroko poko otuhnõko Izyraeu tõ rokene. Imehnomo a moro onenahpopyra ase. ");
INSERT INTO apyNT_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Yrome opoetory tõ, topekahse exiketõ oya xine, otuhnõko mã toto aĩkõpotapihpyry tysahkase ahtao. ");
INSERT INTO apyNT_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Imehnõ Izyraeu tõ kara otuhpyra mã toto, axĩtao rokẽ tõsesarise toto ahtao te, okynahxo ehse exiketõ roropa amaro xine topehke erohketõme toto ahtao ro otuhpyra mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Moro otuhtoh tõnõko matose tapyi tao, moro tao tupuruse ahtao: moro tae anaropyra ehtoko imepỹ pona. Kaneru zehpyry onytahkara ehtoko ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Jomi poe Izyraeu tõ emero moro otuhtoh enahnõko mã toto jeahmaryme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Imehnõ onenahpyra mã toto tyaĩkõpotapihpyry onysahkara exiketomo. Yrome imehnõ amaro xine ehse exiketõ moro otuhtoh poko tõtukuru se ahtao jeahmatohme, ah apitoryme aĩpotapihpyry tysahkase nexino imehnõ itapyĩ taõkõ maro, orutua komo te, poeto tõ maro. Moromeĩpo Otuhtoh Epozakuroko poko otuhnõko mana Izyraeume aenurutyã samo. ");
INSERT INTO apyNT_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Sero jomihpyry omipona exĩko Izyraeu tõ aenurutyã Izyraeu nonory po te, imehnõ nonory poe aehtyã roropa amaro xine ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Mame Izyraeu tõ emero Ritonõpo nyripohpyry omipona toehse, inyripohpyry Moeze tomo a, Arão maro. ");
INSERT INTO apyNT_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Moro ẽmepyry ae Ejitu poe Izyraeu tõ tarose Ritonõpo a, oxiekyrymãkõ porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","— Osemazuhme aenurutyã umũkurume mã toto. Okyno mũkuru osemazuhme aenurutyã roropa jekyme mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ynara tykase Moeze Izyraeu tomo a: — Wenikehpyra ehtoko sero ẽmepyry poko. Seroae Ejitu turumekase oya xine. Moroto imehnõ namotome mexiatose. Sero ẽmepyry ae amarokõ tonehse Ritonõpo a tyjamitunuru ke. Wyi porutatoh maro onenahpyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ejitu rumekãko matose seroae, nuno apitorymã po, nuno apipe po. ");
INSERT INTO apyNT_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Tõmihpyry tokarose Ritonõpo a atamuru tomo a kananeu tõ nonory ekarory poko oya xine te, heteu tõ nonory te, amoreu tõ nonory te, heweu tõ nonory te, jepuseu tõ nonory, enara. Moro nono kure mana otyro zamaro exikety. Tarose awahtao xine eya morotona otuhtoh konõto tyritoko oeahmatohkõme nuno apitorymã po, emero jeimamyry ae. ");
INSERT INTO apyNT_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","7me ẽmepyry ae wyi enahnõko matose iporutatoh maro pyra ipunaka. Mame ẽmepyry 7mã po otuhtoh konõto rĩko matose Ritonõpo eahmatohme, Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Sero 7mã ẽmepyry ae wyi enahnõko matose iporutatoh maro pyra. Naeroro ononorykõ po porehme iporutatoh ipahtoko, iporutatoh pyra ehtohme ononorykõ po, wyi porutatoh risẽ pyra ehtohme roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Sero ẽmepyry ae opoenõkõ zurutoko onyrirykõ poko: Serara rĩko sytatose Ritonõpo nyrihpyry pokoino Ejitu nonory poe toesyryhmase kuahtao xine. ");
INSERT INTO apyNT_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Sero otuhtoh konõto enetupuhpotohme exĩko oya xine imykyhpyry samo oemary poko te, opery poko roropa. Ãkorehmatorỹko mana wenikehpyra oehtohkõme, Ritonõpo omihpyry otururu poko, atamorepary poko, enara. Tyjamitunuru ke Izyraeu tõ tarose Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Naeroro oseahmatoko sero ẽmepyry ae, sero nuno po jeimamyry ae rokene. ");
INSERT INTO apyNT_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ritonõpo Oesẽkõ aarotorỹko mana kananeu tõ nonory pona, tõmihpyry ae ro atamuru tomo a. Morarame sero nono ekaroryhtao oya xine, ");
INSERT INTO apyNT_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","emero mũkuru apitoryme aenurutyã ekarõko matose Ritonõpo a, emero okyno mũkuru apitoryme aenurutyã roropa Ritonõpo ekyme mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Yrome jumẽta mũkuru apitorymã se awahtao xine oekyme, kaneru mũkuru ekaroko Ritonõpo a. Yrome oekyme ise pyra awahtao jumẽtu orihmanohpõko matose, ipymyry tohkãko rokene. Ahno mũkuru apitorymãkõ emero epekahtoko roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Imeĩpo opoenõkõ oturuporyhtao oya xine: “Oty kary morohne?” toto ezuhnõko matose: “Tyjamitunuru ke Ritonõpo a tarose yna Ejitu poe. Moroto imehnõ namotome ynanexiase. ");
INSERT INTO apyNT_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Yna aropory se pyra Ejitu tuisary ahtao Ritonõpo omipona pyra, Ejitu põkõ mũkuru tõ apitorymãkõ totapase Ritonõpo a, ahno poenomo te, okyno poenomo, enara. Morara exiryke okyno mũkuru apitorymãkõ ekarõko ynanase ynanekaroryme Ritonõpo a. Epehpyry ke rokẽ yna mũkuru apitorymãkõ epekahnõko ynanase. ");
INSERT INTO apyNT_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Morara tyrĩko ynanase wenikehpyra ehtohme, enetupuhtoh mykyry sã yna emary poko te, yna pery poko roropa; wenikehpyra ynanase yna arotopõpyry poko Ritonõpo a Ejitu poe, tyjamitunuru ke.” ");
INSERT INTO apyNT_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Morarame Izyraeu tõ taropose ahtao tuisa a Ejitu nonory poe, tarose toto Ritonõpo a topohme pyra, pirixteu tõ esemary ae pyra. Ynara tõsenetupuhse Ritonõpo: Izyraeu tõ eramary ropa Ejitu pona se pyra ase. Otarame pirixteu tõ maro osetapary kurũke toeramarykõ se exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Morara exiryke tarose toto eya ona esemary ae tuna konõto Tahpiremã ehpikoxi. Ejitu poe Izyraeu tõ toytose atakenaka, soutatu tõ samo, osetapaketõ samo. ");
INSERT INTO apyNT_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Joze ekepyry tarose Moeze a, ynara exiryke, Izyraeu tõ omihpyry tokaropose Joze a orihpyra ro tahtao moro riry poko. Ynara tykase ynororo: “Aarorykohtao Ritonõpo a taroino jekepyry arotoko amaro xine.” ");
INSERT INTO apyNT_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Sukote poe toytose Izyraeu tomo Etã pona osesarise. Moroto ahno esary pyra ona ehpio kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Saereme ahtao toto esemazupurume toytose Ritonõpo akurũ, xikihme exikety samo, toto esemary enepotohme eya xine. Koko toehse ahtao toto esemazupurume toytose ynororo apoto xikihme exikety samo, toto esemary zeipotohme, Izyraeu tõ ytotohme saereme ahtao te, koko ahtao, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Moro akurũ xikihme exikety toto esemazupurume exikehpyra kynexine saereme ahtao. Koko moroto ro apoto xikihme exikety sã exikehpyra kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","— Izyraeu tõ zuruko toto eramatohme ropa, osesarise Pi-Hairote etonie, irãnao, Mikitou poe tuna konõto Tahpiremã pona, Paau-Zepõ pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Izyraeu tõ tytahse, ekarõko Ejitu tuisary mana. Ytoytõko rokene, aza rokẽ ahno esao pyra. ");
INSERT INTO apyNT_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Mame tuisa aosenetupuhtoh ripõko ase tũpore oekahmatohkõme, mame iporemãkapõko ase soutatu tõ maro, yjamitunuru enepotohme. Ejitu põkõ juaro exĩko mã toto, ywy ase Ritonõpo Oesẽkomo. Mame aomipona toehse Izyraeu tomo. ");
INSERT INTO apyNT_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mame Ejitu tuisary turuse ahtao ipoetory tomo a, Izyraeu tõ toepase mã toto owinoino, tokarose ahtao, toetyorõmase ynororo ipoetory tõ maro. Ynara tykase toto: — Enetoko ke kynyrihpyrykomo! Kynamotokõ Izyraeu tõ taropose kyya xine. Epãko mã toto kywinoino xine! ");
INSERT INTO apyNT_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Mame tykanary tukurãkapose tuisa a, soutatu tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Toytose ynororo tykanary tõ maro emero, etonatohme. 600me tykanary tõ kurãkõ tarose eya, tosẽke exiketomo, tuisa poetory tomo. ");
INSERT INTO apyNT_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mame Ritonõpo poe Ejitu tuisary osenetupuhtoh tũpore ro kynexine. Izyraeu tõ tokahmase eya. Ytõko Izyraeu toh kynexine orẽpyra exiketõ samo. ");
INSERT INTO apyNT_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Mame toytose Ejitu põkomo, kawaru tõ maro te, tykanary tõ maro aronanõ maro etonatohme. Izyraeu tõ tokahmase eya xine. Toeporehkase toto Izyraeu tõ osesaritoh pona, tuna konõto Tahpiremã ehpikoxi, Pi-Hairote pũtokoxi, Paau-Zepõ pũtokoxi roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Tuisa tõ tonese ahtao Izyraeu tomo a soutatu tõ maro enaromỹke toehse toto. Kui tykase toto Ritonõpo a takorehmapotohkõme. ");
INSERT INTO apyNT_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ynara tykase toto Moeze a: — Yna ekepyry zonẽtoh nae nexiase Ejitu po. Oty katohme yna menehno xiaro sero ona pona, ahno esaka pyra yna orihtohme? Eneko ke onyrihpyry, Ejitu poe yna enepyryke oya. ");
INSERT INTO apyNT_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Oty tykase yna oya Ejitu po kuahtao xine? Ah ynanexino tehme rokene, Ejitu põkõ namotome. Kurehxo yna a Ejitu tõ namotome yna exiry. Popyrahxo yna orikyry taro ona po! ");
INSERT INTO apyNT_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Yrome toto tozuhse Moeze a. Ynara tykase ynororo: — Oserehpyra ehtoko! Enaromyra ehtoko! Epara ehtoko! Orẽpyra ehtoko. Opynanopyrykõ Ritonõpo a enẽko matose seroae! Mokaro Ejitu põkõ onenezomopyra ropa exĩko matose. ");
INSERT INTO apyNT_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Tehme rokẽ ehtoko oepetõkara poremãkapõko Ritonõpo mana. ");
INSERT INTO apyNT_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ynara tykase Ritonõpo Moeze a: — Oty katohme ãkorehmapõko matou ya? Kaxiko eya xine mya toto ytotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Omyxiry anỹko tuna epoe. Atapiakãko tuna mana Izyraeu tõ ytotohme nono tonore poro, tuna konõto Tahpiremã rãnakuroko. ");
INSERT INTO apyNT_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ejitu põkõ osenetupuhtoh ripõko ase tũpore. Izyraeu tõ ekahmãko mã toto tuna kuaka. Mame Imehxo jekarõko imehnõ mana, Ejitu tuisary te, soutatu tõ maro te, ikanary tõ aronanõ maro toto poremãkaporyhtao ya. ");
INSERT INTO apyNT_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ejitu põkõ poremãkaporyhtao ya tuaro exĩko mã toto, ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Mame toesyryhmase Ritonõpo nenyokyhpyry Izyraeu tõ esemazupuru poe, toto mykakoxi. Akuru xikihme exikety roropa toesyryhmase ");
INSERT INTO apyNT_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","irãnakuroko Ejitu tõ maro Izyraeu tõ maro. Moro akurũ kynexine ikohmamyhpyry sã Ejitu tomo a. Yrome saereme toehse Izyraeu tomo a. Naeroro Ejitu tõ soutatu tõ oseporypyra toh kynexine Izyraeu tõ maro koko. ");
INSERT INTO apyNT_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Tomary tanỹse Moeze a tuna epozakoxi. Tyryrykane jamihme tonehpose Ritonõpo a xixi tũtatoh wino tuna aropotohme. Tyryry kary poko tõmehse moro tuna konõto esahpyry nono tonore toehse. Moro tuna tapiakase, ");
INSERT INTO apyNT_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Izyraeu tõ toytose tuna konõto kuroko nono tonorẽ poro. Apuru sã kaetokohxo tuna toehse toto esemary ehpikuroko, apotunuru wino, ipozery wino, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Toto tokahmase Ejitu põkomo a toto apoitohme repe, osema ae tuna rãnakuroko, kawaru tõ maro te, ikanary tõ maro kawaru aroponanõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ẽmehsasaka ahtao Ejitu põkõ tonese Ritonõpo a akurũ xikihme exikety poe apoto xikihme exikety maro. Enaromỹke tyripose toto eya. Tõserehse toto. ");
INSERT INTO apyNT_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Kahu tõ ytory tupime toehse. Ritonõpo poe ipupuru tõ tomõse nono aka. Ytopỹme toehse toto. Ynara tykase Ejitu põkomo: — Ehmaropa! Sepatone Izyraeu tõ wino! Toto akorehmãko Ritonõpo mana. Kuakorekehkatorỹko nase. ");
INSERT INTO apyNT_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ynara tykase Ritonõpo Moeze a: — Oemary anỹko tuna epozakoxi tuna oehtohme ropa Ejitu põkõ nerymapotohme kahu tõ maro te, kawaru tõ aroponanõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Tomary tanỹse Moeze a tuna epozakoxi. Mame tõmehse ahtao tuna konõto tooehse ropa apitoryme toehtopõpyry samo. Ejitu põkõ tutũtarykõ tukuhse tuna konõto kuae repe. Yrome Ritonõpo a tynerymapose toto tuna kuaka. ");
INSERT INTO apyNT_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Tuna konõto toeramase, ikanary tõ tyneryse te, kawaru tõ maro, Ejitu tõ soutatu tõ maro porehme, Izyraeu tõ ekahmahpõkomo tuna konõto kuaka. Osepynanohpyra toh kynexine porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Yrome Izyraeu tomo a tuna konõto takuohse nono tonore poro kaetokohxo tuna toehse ahtao apuru samo apotunuru wino, ipozery wino, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Moro ẽmepyry ae Izyraeu tõ typynanohse Ritonõpo a, toto anapoipyra Ejitu põkõ ehtohme. Mokaro Ejitu põkõ ekepyry tonese isawã po tuna ehpikuroko Izyraeu tomo a. ");
INSERT INTO apyNT_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ritonõpo jamitunuru tonese ahtao Izyraeu tomo a Ejitu põkõ poremãkapory poko, Ritonõpo tonetupuhse eya xine. Aomipona se toehse toh kynexine. Moeze omipona se roropa toehse toto. ");
INSERT INTO apyNT_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Mame toremiase Moeze tomo Izyraeu tõ maro Ritonõpo Tosẽkõ eahmaryme. Ynara tykase toto: — Eremiãko ase Ritonõpo eahmaryme typoremãkapose toto eya exiryke, orẽpyrahxo toexiryke, kawaru tõ tomase eya, kawaru aronanõ maro tuna konõto kuaka. ");
INSERT INTO apyNT_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Jewomane jamihme Ritonõpo mana. Eya typynanohse ywy; Ritonõpo Jesẽme mana, eahmãko ase. Papa Esẽme mana, eremiãko ase, Imehxo Aexiry poko. ");
INSERT INTO apyNT_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ritonõpo etonaketyme mana. Esety mã Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Tuna konõto kuaka Ejitu soutatu tõ tomase ikanarykõ maro. Soutatu tõ esã, imehxo exiketõ tynerymapose tuna konõto Tahpiremã kuaka. ");
INSERT INTO apyNT_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Tynerymase toto tuna konõto zueme exikety a. Topu sã tyneryse toto zue aka. ");
INSERT INTO apyNT_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ritonõpo, jamihmehxo oemary apotunuru wino mana, osenuruhkãko ynanase oepetõkara etohtohkary eneryke yna a. ");
INSERT INTO apyNT_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Emero motye orẽpyra mexino. Oepetõkara poremãkapory poko, toto zehno oexiryke jahkãko mase onahpoty samo tonore ahtao. ");
INSERT INTO apyNT_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Typũmase oya, tuna kaetokohxo toehse. Pohkane tõ tõnuhse xikihme, apuru samo pata zomye. Tũpore toehse tuna konõto zue ao, jeru samo. ");
INSERT INTO apyNT_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Kuepetõkara ynara tykase: “Mokaro ekahmãko sytatose, toto apoĩko sytatose, Imõkomory emero apoĩko sytatose, kymõkomorykõme. Kypyrekõ ke toto poremãkapõko sytatose.” ");
INSERT INTO apyNT_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Yrome Omoro, Ritonõpo, typũmase oya ahtao Ejitu põkõ tyneryse, zue aka tomõse toto xũpu samo, pohkane xihpyry kuaka. ");
INSERT INTO apyNT_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Imepỹ ritõ apanõ pyra mana, Ritonõpo! Onoky nae kurano, Imehxo Exiketyme apanono? Onokãkõ tyjamitunuru ke tyrĩko nae, typoetory tõ ewomãko roropa nae? ");
INSERT INTO apyNT_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Oemary tanỹse ahtao oya ãpotunuru wino, mokaro tonahkase nono a, yna ekahmahpõkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Yna pyno oexiryke, opoetory tõ arõko mase typynanohse toto oya, ajamitunuru ke tarose toto oya ononory kurã pona, Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Onyrihpyry poko totase imehnõ nonory põkomo a, tykytyky ãko mã toto enaromỹke toexirykõke. Pirixteu tõ oserehnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Etõ põkõ tamuximãkõ roropa tonaroxitapãse mã toto. Moape põkõ jamihmãkõ typoremãse mã toto. Kanaã põkõ emero tykytyky ãko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Enaromỹke toehse toto, ouno mã toto ipunaka. Ajamitunuru eneryke tyya xine totypohse mã toto, topume anyhtahpyry sã toexirykõke, opoetory tõ ytoytory eneryke tyya xine, opoetory tõ typynanohse oya Ejitu põkõ namotome toto ahtao. ");
INSERT INTO apyNT_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Toto enehnõko mase, ypy pona, oesary pona onymenekahpyry oesaryme, Atapyĩ esaryme, onyrihpyry esaryme. ");
INSERT INTO apyNT_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ritonõpo, yna Esemy, yna Tuisary Imehxo mase, jũme exikehpyra mase. ");
INSERT INTO apyNT_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Tuna konõto takuohse Izyraeu tomo a nono tonore poro. Yrome tykanarykõ tarose ahtao Ejitu põkomo a, kawaru tõ maro Izyraeu tõ ekahmaryme, tuna tonehpose ropa Ritonõpo a toto nerymapotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Urutõme Miriã kynexine Arão oryxiry. Pãteru tapoise eya imehnõ nohpo tõ emero imaro toehse, pãteru tõ etõko, wãko toto. ");
INSERT INTO apyNT_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mame toremiase Miriã, toto netaryme. Ynara tykase: — Eremiatoko Ritonõpo eahmaryme, typoremãkapose toto eya, Imehxo toehse ynororo ipunaka; kawaru tõ tomase eya, kawaru aronanõ maro tuna konõto kuaka. ");
INSERT INTO apyNT_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mame Izyraeu tõ tarose Moeze a tuna konõto Tahpiremã poe ona Sua pona. Oseruao tõmehse toytorykõ poko toto ona poro, tuna zupiry poko repe. ");
INSERT INTO apyNT_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Toeporehkase toto Mara pona. Yrome moro tuna onẽsaromepyra toh kynexine, itũ exiryke. Morara exiryke moro esety Mara kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tykerekeremase toto Moeze netaryme; tõturupose toto: — Oty ẽnõko ynanae? tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Jarao tõturuse Moeze yronymyryme Ritonõpo a takorehmatohme. Mame wewe zokonaka tonepose Ritonõpo a eya. Moro wewe tõmase eya ahtao tuna kuaka, tuna kure toehse toto okurume. Moroto tõmihpyry tokarose Ritonõpo a eya xine, Aomipona toto ehtohme. Moroto tukuhse roropa toto Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ynara tykase ynororo eya xine: — Tomeseke awahtao xine jomihpyry poko, zae ehtoh riryhtao oya xine roropa, jomihpyry omipona awahtao xine awãnohpyra xine exĩko ase tyrohsẽ ke Ejitu põkõ wãnohtopõpyry ke. Ywy ase Ritonõpo okurãkanekomo. ");
INSERT INTO apyNT_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Moromeĩpo toeporehkase Izyraeu tomo Erĩ pona. Moroto 12me tuna eutary nae kynexine te, 70me airiki panõ roropa. Moroto tõsesarise toh kynexine tuna eutary tõ pũto. ");
INSERT INTO apyNT_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Morotoino Erĩ poe toytose Izyraeu tomo ona Xĩ pona, irãnaka Erĩ poe ypy Xinai pona. Toeporehkase toto morotona ẽmepyry 15mã po, nuno 2mã po, Ejitu rumekatopõpyry poe. ");
INSERT INTO apyNT_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Moroto, ona tonorẽ po Moeze tõ netaryme Arão maro tykerekeremapitose ropa toto. ");
INSERT INTO apyNT_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ynara tykase toto eya xine: — Kurehxo yna a exiry toorihse yna ahtao Ejitu po! Moroto tõsẽ nae ynanexiase. Typorohse yna ahtao otuhtohme tuesapare toehse yna. Yrome kuenepyatose ahno esaka pyra ynaemitapamyryke orihtohme, emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ynara tykase Ritonõpo Moeze a: — Seromaroro wyi enehpõko ase kapu ae konopo samo. Ahno tũtãko mã toto tytapyĩkõ tae kokoro rokene tynapyrykõ anỹtohme ipune xine ehtohme. Morarame toto kuhnõko ase, jomiry omipona toto ehtoh waro jehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ẽmepyry 6mã po asakoro ẽmepyry pune ehtoh tynapyrykõ anỹnõko mã toto ikurãkatohme. ");
INSERT INTO apyNT_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mame ynara tykase Moeze tõ Arão maro imoihmãkomo a: — Seroae mõtahtao zuaro exĩko matose, Ritonõpo Oesẽkomo a tonehse matose Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Kokoro pakeimo Ritonõpo ezuru imehxo exikety enẽko matose, tykerekerematopõpyry oya xine totase eya exiryke. Yna kerekeremaryhtao oya xine, yna poko pyra, Ritonõpo kerekeremãko matose aomipona exiketyme rokẽ yna exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Tõturuse ro Moeze eya xine: — Ritonõpo Oesẽkõ Mokyro tõsẽ ekaroneme kokonie pukuro te, wyi ekaroneme roropa pakeimo, õmihpyrykõ totase eya exiryke ikerekeremaryhtao oya xine. Yna kerekeremaryhtao oya xine Ritonõpo kerekeremãko matose. ");
INSERT INTO apyNT_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mame ynara tykase Moeze Arão a: — Kaxiko imoihmãkomo a, toto oehtohme xiaro Ritonõpo Kuesẽkõ ẽpataka, tykerekerematopõpyry totase eya exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Toto zururuhtao Arão a, tõsenuhmase toto ona pona. Ritonõpo ezuru imehxo exikety tonese eya xine akuruhtao. ");
INSERT INTO apyNT_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","— Ykerekerematopõpyry Izyraeu tomo a totase ya. Kaxiko eya xine. Seroae ro kokonie pukuro tõsẽ õnõko mã toto. Mame kokoro pakeimo wyi ohnõko mã toto. Tuesapare exĩko mã toto. Tuaro exĩko mã toto ywy ase Ritonõpo, toto Esemy. ");
INSERT INTO apyNT_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Mame kokonie pukuro aramixi panõ tooehse tuhke. Nono typehkase Izyraeu tõ esary po. Mame yrokokoro pakeimo onahpoty tahxikure kynexine toto tapyĩ tõ zomye. ");
INSERT INTO apyNT_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Morarame moro axitaku tonore toehse ahtao isawã po ona po ohpetu tõxinamase, tonahsẽ kãseme exikety mauru panono. ");
INSERT INTO apyNT_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Moro eneryhtao Izyraeu tomo a zuaro pyra toh kynexine. Tõturupose toto oseya xine: — Otyhkoh seny? tykase toto. — Sero Ritonõpo nenehpohpyry anapyrykõme, tykase Moeze. ");
INSERT INTO apyNT_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ynara tykase Ritonõpo tyripotohme oya xine: “Emero matose anapyrykõ anỹnõko matose atapyĩ taõkõ pune ehtohme. Toiro ahno napyryme asakoro riturumã ipune exĩko mana.” ");
INSERT INTO apyNT_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Morara tyrise Izyraeu tomo a, toitoine itamurumehxo tanỹse, imehnomo a tuhke hkopyra. ");
INSERT INTO apyNT_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Mame tukuhse ahtao eya xine ipune kynexine. Tuhkehxo apoihpõkomo a tuhke nymyry pyra kynexine. Tuhke hkopyra apoihpõkomo a ipune ro inanymyhpyrykomo. Emero pune inapyrykõ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mame ynara tykase Moeze eya xine: — Moro onukurãkara ehtoko enahtohme kokoro, tykase. ");
INSERT INTO apyNT_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Yrome toitoine aomihpyry omipona pyra toehse. Moro tonahsẽ akoĩpyry tukurãkase eya xine. Yrokokoro ikurãkahpyry tonese eya xine. Moromoro hpe toehse, tymoke roropa. Tohne toehse Moeze moro eneryke eya. ");
INSERT INTO apyNT_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kokoro rokẽ tonahsẽ tanỹse eya xine tytapyĩ taõkõ napyryme moro ẽmepyry ae. Mame xixi jamihme toehse ahtao inynomohpyry nono po tuname toehse. ");
INSERT INTO apyNT_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Mame 6me aehtoh po tonahsẽ tanỹse eya xine asakoro ẽmepyry pune ehtohme 4 riturumano tapoise toiro ahno napyryme. Izyraeu tõ tamuximãkõ toytose Moeze zuruse imoihmãkõ nyriry poko. ");
INSERT INTO apyNT_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ynara tykase Moeze eya xine: — Kokoro oserematohme mana, ẽmepyry tapiakase Ritonõpo eahmatohme, oserematoh kurano. Morara exiryke ynara tyripose toto Ritonõpo a: “Seroae ekeiry se exiketõ ekeĩko mã toto. Ahnory se exiketõ ahnõko ikurãkatohme akoĩpyry enahtohme yrokokoro.” ");
INSERT INTO apyNT_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Moeze omihpyry omipona moro tonahsẽ akoĩpyry tukurãkase eya xine. Motara, tymoke pyra, moromoro hpe exipyra, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ynara tykase Moeze: — Sero enahtoko seroae, oserematohme exiryke, oserematoh ẽmepyry tapiakase Ritonõpo Oesẽkõ eahmatohme. Seroae tonahsẽ onenepyra exĩko matose ona po. ");
INSERT INTO apyNT_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Sero tonahsẽ apoĩko matose 6me aẽmehtoh pona. Yrome 7mã ẽmepyry ae, oserematohme exiryke, tonahsẽ exipyra mana nono po. ");
INSERT INTO apyNT_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Mame ẽmepyry 7me aehtoh po toitoine tutũtase tonahsẽ apoitohme repe. Yrome onenepyra tokurehse toto. ");
INSERT INTO apyNT_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Mame ynara tykase Ritonõpo Moeze a: — Oty katohme jomiry onetara hmatou? Oty katoh ynyripohpyry onyripyra hmatou? ");
INSERT INTO apyNT_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Wenikehpyra ehtoko, Ywy, Ritonõpo toiro ẽmepyry ekaroase oya xine õserematohkõme. Morara exiryke ẽmepyry 6mã po tonahsẽ ekarõko ase oya xine asakoro ẽmepyry pune ehtohme. Naeroro 7me aehtoh po tehme ehtoko oesarykõ po. Tũtara rokẽ ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Morarame erohpyra toh kynexine ẽmepyry 7me aehtoh po. ");
INSERT INTO apyNT_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Mame moro tonahsẽ tosehpase Izyraeu tomo a manãme. Ipuhturu pisarara sã kynexine, karimutume. Tonahse ahtao kãsemã sã kynexine ano zeni risẽ samo. ");
INSERT INTO apyNT_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ynara tykase Moeze: — Manã tukurãkapose Ritonõpo a, asakoro riturumã ao pehme, imeĩpo enepotohme kypakomotyãkomo a, zuaro toto ehtohme sero tonahsẽ poko, Ritonõpo nekarohpyry kyya xine ona po, tarose eya kuahtao xine Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mame ynara tykase Moeze Arão a: — Oripo apoiko. Manã tyriko asakoro riturumã tomo moro oripo aka tyritohme Ritonõpo ẽpataka, ikurãkatohme kypakomotyãkõ neneryme. ");
INSERT INTO apyNT_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ritonõpo nyripohpyry tyrise Arão a. Moro oripo tyrise Moeze a Ritonõpo omihpyry ẽ ẽpataka ikurãkatohme moroto. ");
INSERT INTO apyNT_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","40me jeimamyry manã nae Izyraeu tõ kynexine tonahsẽme, toeporehkatoh pona nono tytaõke exikety pona, Kanaã ehpikoxi toeporehkatohkõ pona. ");
INSERT INTO apyNT_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Toiro ahno napyry toiro ẽmepyry ae asakoro riturume tukuhse kynexine, toiro ikuhtopo. 10me moro tonahsẽ kuhtoh 20 riturume kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ona Xĩ poe toytose Izyraeu tomo imeimehnõ osa pona Ritonõpo omi poe. Mame Repitĩ pona toytose toto. Yrome tuna pyra kynexine moroto, eukuru pyra. ");
INSERT INTO apyNT_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Tykerekeremase ropa Moeze eya xine: — Tuna ekaroko yna a, yna okurume, tykase toto. — Oty katohme ykerekeremãko matou? tykase Moeze. — Oty katohme Ritonõpo kuhnõko matou? ");
INSERT INTO apyNT_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Yrome tutunazehnase imoihmãkõ kynexine. Onykerekeremakehpyra toh kynexine. Kui tykase toto Moeze netaryme. Ynara tykase toto: — Oty katohme yna menepyase Ejitu poe? Yna orihmapotohme tuna peneryke? Yna te, yna poenomo te, yna eky tõ maro kaneru tomo poti tõ maro? ");
INSERT INTO apyNT_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mame Moeze tõturuse yronymyryme Ritonõpo a takorehmatohme. Ynara tykase ynororo: — Oty rĩko ywy moxiã poko? Jetapary se exisasaka mã toto topu ke. ");
INSERT INTO apyNT_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ynara tykase Ritonõpo Moeze a: — Toitoine Izyraeu tõ tamuximãkõ imenekako amaro toto ytotohme osemazuhme. Omyxiry aroko amaro, ike tuna Niro etapatopõpyry oya. ");
INSERT INTO apyNT_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Oẽpataka exĩko ase topu po ypy Xinai po. Moro topu etapako, mame ewino tuna tũtãko mana imoihmãkõ okurume. Morara tyrise Moeze a Izyraeu tõ tamuximãkõ neneryme. ");
INSERT INTO apyNT_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Mame moroto tosehpase eya xine Masame te, Meripame roropa, moroto Moeze tykerekeremase Izyraeu tomo a exiryke. Ritonõpo tykerekeremase roropa eya xine. Ynara karyke Ritonõpo tukuhse eya xine: — Ritonõpo kymaro xine nae? Otarame kymaro xine pyra mana, karyke eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Mame amarekita tõ tooehse osetapase Izyraeu tõ maro Repitĩ po. ");
INSERT INTO apyNT_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ynara tykase Moeze Jozue a: — Orutua kõ imenekako toto arotohme, kokoro pakeimo, etonatohme amarekita tõ maro. Ypy emory pona ytõko ase Ritonõpo myxiry apoiry poko. ");
INSERT INTO apyNT_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Morarame toytose Jozue, Moeze omi poe osetapase amarekita tõ maro. Moeze tõ tõnuhse ypy emory pona turui maro Huru maro. ");
INSERT INTO apyNT_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mame tapory tõ tanỹse ahtao kakoxi Moeze a, orẽpyrahxo Izyraeu tõ toehse. Yrome tukuromoxinase Moeze apory ahtao amarekita tõ orẽpyra toehse. ");
INSERT INTO apyNT_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mame Moeze apory tukuromoxinase ahtao, topu tonehse Arão tomo a Huru maro epona Moeze porohtohme. Mame apory tõ tapoise eya xine. Morarame apory tõ tanỹse eya xine xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Morarame amarekita tõ typoremãkapose Jozue tomo a. ");
INSERT INTO apyNT_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Mame ynara tykase Ritonõpo Moeze a: — Onyrihpyrykõ poko imeroko wenikehpyra oehtohkõme, oepetõkara poremãkatopõpyry poko oya xine. Kaxiko Jozue a: “Amarekita tõ enahkapõko ase porehme.” ");
INSERT INTO apyNT_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moroto apoto apõ tyrise Moeze a. Moro tosehpase eya: “Ritonõpo Kuesẽkõ Jewomaneme mana.” ");
INSERT INTO apyNT_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Mame ynara tykase ynororo: — Ritonõpo esety kamisa poko anỹtoko kakoxi. Kuepetõkara amarekita tõ poremãkapõko Ritonõpo mana, jumãme. ");
INSERT INTO apyNT_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Morarame Moeze enese toytose imeretamuru, Jetoro, Ritonõpo maro oturukety Mitiã po. Tuaro toehse ynororo Ritonõpo nyrihpyry poko Moeze maro, Izyraeu tõ maro. Izyraeu tõ arotopõpyry Ejitu poe Ritonõpo a, waro roropa ynororo kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mame toytose ynororo Moeze esaka. Tymaro Zipora, Moeze pyty tarose eya, Jetoro tapyĩ tao Zipora tynomose Moeze a tumũkuru asakoro ro toytose tahtao Ejitu pona. ");
INSERT INTO apyNT_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Toiro imũkuru esety Jeresõ kynexine, ynara tykase Moeze exiryke: “Katonõme toehse ywy imehnõ nonory po.” ");
INSERT INTO apyNT_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Zakorõ esety Erieze kynexine ynara karyke Moeze a: “Ritonõpo, Papa Esemy a takorehmase ywy jetapara Ejitu tõ tuisary ehtohme,” katopo. ");
INSERT INTO apyNT_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Toytose Jetoro, Moeze meretamuru, ipyty maro te, imũkuru tõ maro Moeze esaka, ypy kurã pona, Ritonõpo esary pona. ");
INSERT INTO apyNT_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Apitoryme tõmihpyry taropose eya Moeze a, ynara katopo: “Oehnõko ase, opyty maro, omũkuru tõ maro.” ");
INSERT INTO apyNT_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mame tutũtase Moeze oseporyse Jetoro maro. Toepuise ynororo tymeretamuru ẽpataka. Typohse eya. Tãtaomikase toto, tõturupose kure toto ehtoh poko. Mame tomõse toto Moeze tapyĩ taka. ");
INSERT INTO apyNT_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Tymeretamuru turuse eya emero Ritonõpo nyrihpyry poko, typoetory tõ Izyraeu pyno exiry poko te, Ejitu tuisary wãnohtopõpyry poko Ejitu põkõ maro. Turuse roropa tupime Izyraeu tõ ytotopõpyry poko te, toto pynanohtopõpyry poko roropa Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Tãkye toehse Jetoro morara kary etaryke tyya, Ritonõpo nyrihpyry poko, Izyraeu tõ arotopõpyry poko eya Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ynara tykase ynororo: — Kure Ritonõpo Kuesẽkõ mana typynanohse oexirykõke eya Ejitu tõ tuisary winoino, Ejitu põkõ winoino, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Seromaroro zuaro toehse ywy. Imehnõ ritõ kõ motye jamihmehxo Ritonõpo mana, Izyraeu tõ typynanohse exiryke eya Ejitu jamitunuru wino, tyyryhmase toto ahtao Ejitu põkomo a. ");
INSERT INTO apyNT_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mame toky tõ tonehse Jetoro a etapatohme jahkatohme tynekaroryme Ritonõpo a. Arão tõ Izyraeu tõ tamuximãkõ maro toytose toto imaro otuhse Ritonõpo eahmaryme. ");
INSERT INTO apyNT_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Yrokokoro typorohse Moeze, ahno nekaropotoh etatohme, apiakatohme zae ehtoh enetupuhpotohme. Moro poko tykohmãse Moeze. ");
INSERT INTO apyNT_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mame Moeze nyriry eneryke Jetoro a tõturupose ynororo eya: — Oty katohme morara tyrĩko mahno toiroro, imoihmãkõ nekaropory tõ apiakãko, zae ehtoh waro toto ehtohme? Moxiã roropa xikihme oeraximary poko kohmãnõko toh nae? ");
INSERT INTO apyNT_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","— Morara tyrĩko ase moxiã oepyryke ya zae ehtoh waro toehtohkõme Ritonõpo poe. ");
INSERT INTO apyNT_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Asakoro ahno atae pyra toto ahtao ya oehnõko mã toto. Mame toto ezuhnõko ase, zae ehtoh waro toto ehtohme. Toto amorepãko ase Ritonõpo omihpyry poko te, Inyripohpyry poko, enara, tykase Moeze. ");
INSERT INTO apyNT_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","— Ỹ, onyriry zae nymyry pyra mana, tykase Jetoro. ");
INSERT INTO apyNT_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Serara awahtao etaehnõko mase. Penekehnõko roropa mã imoihmãkõ mana. Sero oerohtoh itamurume tyriryke oya toiroro. ");
INSERT INTO apyNT_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Jomiry etako, ãkorehmãko Ritonõpo mana. Zae ro nase Izyraeu tõ arory Ritonõpo ẽpataka inekaroporykõ pona. ");
INSERT INTO apyNT_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Zae roropa toto amorepary Ritonõpo omihpyry poko inyripohpyry omipona toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Yrome kurehxo orutua kõ menekary oya, tuaro exiketomo tuisame toto ehtohme: miumãkõ tuisaryme te, 100mãkõ tuisaryme te, 50mãkõ te, 10mãkõ tuisaryme, enara. Ritonõpo omipona se exiketomo, zae rokẽ exiketomo, ajoajohpe pyra exiketomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Mokaro tyriko ahno apiakananõme aerohtohkõme kokoro rokene. Mame tupimãkõ enehnõko ro mã toto oya. Yrome tupimãkara enetupuhnõko mã toto zae ehtoh poko. Morara ahtao ãkorehmãko mã toto omoxĩ hkopyra oerohtoh ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Serara tyrise ahtao oya, tyripose ahtao Ritonõpo a etaehpyra mase exĩko. Moxiã roropa ytõko mã toto tytapyĩkõ taka tãkye rokene. ");
INSERT INTO apyNT_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Kure Jetoro omiry totase Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Orutua kõ emese kure exiketõ, Izyraeu tõ tymenekase Moeze a miumãkõ tuisaryme te, 100mãkõ tuisaryme te, 50mãkõ tuisaryme te, 10mãkõ tuisaryme, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Toerohse toto imehnõ akorehmary poko atae pyra toto ahtao tupimãkõkara topohmãko. Yrome tupimãkõ tarose Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mame tõsekazumase Moeze Jetoro maro. Toytose ropa ynororo tytapyĩ taka ropa. ");
INSERT INTO apyNT_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Repitĩ poe toytose Izyraeu tomo, ẽmepyry apitorymã po, 3me nuno aehtoh po toto ytotopõpyry poe Ejitu poe. Ona Xinai pona toeporehkase toto. Tõsesarise toto moroto ypy Xinai myhto. ");
INSERT INTO apyNT_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mame ypy pona tõnuhse Moeze oseporyse Ritonõpo maro. Ypy emory poe tykohmase ynororo Ritonõpo Izyraeu tõ Esemy a. Ynara tykase ynororo: — Oturuko Jako pakomotyamo a, Izyraeu tomo a. Ynara kaxiko: ");
INSERT INTO apyNT_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Ynyrihpyry Ejitu põkomo a meneatose oenurukõ ke, oenehtopõpyrykõ roropa ya meneatose, ymaro oehtohkõme, piano a tumũkuru puimary samo, taporykõ po. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Seromaroro jomiry omipona awahtao xine, ynyripohpyry riryhtao oya xine, ypoetoryme exĩko matose. Sero nono emero ykyryryme mana. Yrome amarokõ ypoetoryme exĩko matose, tymenekase ya oexirykõke. ");
INSERT INTO apyNT_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Amarokõ tapiakase ya, imehnõ wino jomipona oehtohkõme, ymaro oturuketõme sã oehtohkõme.” Morara kaxiko Izyraeu tomo a, tykase Ritonõpo Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Naeroro Moeze toytose Izyraeu tõ tamuximãkõ kohmase. Mame turuse toto eya emero Ritonõpo nekaropohpyry. ");
INSERT INTO apyNT_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Mame ynara tykase toto oximõme: — Ritonõpo nyripohpyry rĩko ynanase emero porehme. Mame toto omihpyry tarose Moeze a Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ynara tykase Ritonõpo Moeze a: — Amaro oturũko ase akurũ xinukutumah tae jomiry etatohme imoihmãkomo a, taroino õmiry zae ehtoh waro toto ehtohme. Imoihmãkõ omiry tokarose Moeze a Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ynara tykase ropa Ritonõpo: — Ytoko imoihmãkõ zuruse: Seroae nuriame ehtoh irumekatoko. Morararo kokoro oorypyrykõ irumekatoko jeahmatohme oya xine. Oupõkõ roropa ikurikatoko ");
INSERT INTO apyNT_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","jeraximatohme yrokokoro. Moro ẽmepyry ae yhtõko ase ypy Xinai emory pona. Moroto jenẽko matose. ");
INSERT INTO apyNT_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ypy zomye enetupuhtoh tyriko ahno ytopyra ehtohme, ypy pona onuhpyra toto ehtohme te, ypy pũtokoxi ytopyra toto ehtohme. Imepyny a tupupuru tyrise ahtao ypy pona, taorihmaposẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Mokyro anapopyra ehtoko. Topu ke totapasẽme exĩko mana, pyrou ke tuosẽme roropa exĩko mana. Ahno ahtao, okyno ahtao roropa morara tyrĩko matose. Yrome rue totose ahtao ah imoihmãkõ nytõ toto ypy myhtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mame tyhtose Moeze ypy poe. Imoihmãkõ tukurãkapose toto eya nuriame pyra toto ehtohme, Ritonõpo eahmatohme. Naeroro tupõkõ tukurikase eya xine emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Mame ynara tykase Moeze eya xine: — Epytatoko. Oupõkõ ikurikatoko Ritonõpo eahmatohme mokokoro. Opyxiãkõ poko pyra ehtoko roropa Ritonõpo eraximaryme. ");
INSERT INTO apyNT_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Mame oseruao ẽmepyrymã po konomeru totase eya xine. Nenenehkane tonese roropa eya xine. Akuru xinukutumehme sã exikety tyhtose ypy pona. Rueimo tõsetose opore samo imoihmãkõ netaryme. Moro etaryke tyya xine enaromỹke morotõkõ kynexine emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mame imoihmãkõ tarose Moeze a tosarykõ poe jarãnaka oseporyse Ritonõpo maro. Totypohse toto ypy myhtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ypy Xinai orexĩtohpã sã kynexine, epona typorohse Ritonõpo exiryke apoto maro. Moro orexĩto tõnuhse apoto konõto erexĩtory samo apotoimo poe samo. Tykytyky tykase toto morohne kurũke. ");
INSERT INTO apyNT_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Oporehxo toehse moro rueimo osetory. Moeze tõturuse. Mame tozuhse ynororo Ritonõpo a konomeru ae. ");
INSERT INTO apyNT_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mame tyhtose Ritonõpo ypy emory pona. Moeze tykohmase eya aunuhtohme morotona. Naeroro Moeze tõnuhse. ");
INSERT INTO apyNT_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ynara tykase Ritonõpo eya: — Oyhtoko ropa mokaro zuruse oehpyra toto ehtohme ypy pona jenese. Ypy pona tooehse toto ahtao orihnõko mã toto tuhkãkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ymaro oturuketõ zuruko roropa tyyrypyrykõ korokapotohme nuriame pyra toto ehtohme, toto oehtohme ya. Toto rypyrykõ onykorokapopyra toto ahtao etapãko ase. ");
INSERT INTO apyNT_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ynara tykase Moeze Ritonõpo a: — Mokaro onuhsaromepyra mã toto onenehpopyra oya exiryke. Onutũmapopyra ypy po mexiase. Enetupuhtoh tyripose roropa oya ypy zomye onuhpyra toto ehtohme, tykase. ");
INSERT INTO apyNT_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","— Oyhtoko eya xine, tykase Ritonõpo Moeze a. — Moromeĩpo Arão enehta amaro xiaro. Yrome mokaro ymaro oturuketõ, imoihmãkõ roropa oehsaromepyra mã toto sero pona, jesaka. Tooehse toto ahtao toto etapãko ase. ");
INSERT INTO apyNT_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Naeroro tyhtose ropa Moeze imoihmãkomo a. Turuse toto emero Ritonõpo omihpyry. ");
INSERT INTO apyNT_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ritonõpo tõturuse. Ynara tykase ynororo: ");
INSERT INTO apyNT_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","— Ywy ase Ritonõpo Oesẽkomo. Kuenepyatose Ejitu poe, imehnõ namotome awahtao xine. ");
INSERT INTO apyNT_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","— Imepỹ ke ymyakãmara ehtoko. Ywy rokẽ kueahmatoko. ");
INSERT INTO apyNT_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","— Ahno panõ anaxikara ehtoko oneahmarykõme: torõ tomo te, onokyro tõ roropa te, tunakuaõkõ roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Anaxikahpyrykõ ẽpataka porohpyra ehtoko oesekumurukõ po mokaro eahmaryme. Ywy ro rokẽ Ritonõpome ase Oesẽkomo. Imepỹ ymyakã se pyra ase ipunaka zumoxike jexiryke. Yzehno exiketõ wãnohnõko ase: ipakõ roropa te, ipakõ poenomotyamo te, ipary pakomotyã roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Yrome ypyno exiketõ pynanohnõko ase, jomipona exiketomo te, ynyripohpyry rinanõ roropa. Toto poenõ te, ipakomotyã roropa pynanohnõko ase miume zumakahpõkomo a, jomiry se toto exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","— Jesety zuno exiketõme ehtoko. Atahmãkara ehtoko jesety poko, onykenãpara ehtoko. Ywy Ritonõpo imehnõ wãnohnõko ase zae pyra toehse toto ahtao jesety poko. ");
INSERT INTO apyNT_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","— Ẽmepyry 7me aehtoh poko wenikehpyra ehtoko ypoko oehtohkõme, jeahmaryme. ");
INSERT INTO apyNT_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Oerohtohkõ poko ehtoko 6me ẽmepyry ae. ");
INSERT INTO apyNT_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Yrome 7mã po ẽmepyry õserematohkõme mana, ypoko eahmatohme mana. Ywy ase Ritonõpo Oesẽkomo. Oerohtoh poko pyra ehtoko seroae: amarokomo te, omũkurukomo, oẽxirykõ maro te, anamotokomo orutuame toto ahtao te, nohpo tõ roropa, oeky tõ roropa te, imehnõ nonory põkõ roropa tõsesarise toto ahtao ononorykõ po, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","6me ẽmepyry taropose ya, Ritonõpo, kapu riry poko, nono roropa, tuna konõto te, kana tõkehko maro. Yrome 7me aehtoh po tõseremase ywy. Morara exiryke ẽmepyry 7me aehtoh tyrise ya kurãme. Sero tapiakase ya ẽmepyry kurãme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","— Kure omykõ tyritoko. Asakõ roropa kure tyritoko. Kure toto riryhtao oya xine okynã sã orihpopyra matose ynekarohpyry po ononorykõme. ");
INSERT INTO apyNT_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","— Ahno onetapara ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","— Imepỹ nohpo poko pyra ehtoko. Morararo imepỹ orutua poko pyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","— Imepỹ mõkomory onematonanohpyra ehtoko. Imepỹ nykyryry onematonanohpyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","— Imehnõ poko ajohpe pyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","— Imepỹ tapyĩ poko penetara ehtoko. Ipyty poko penetara ehtoko. Ipoetory tõ poko penetara ehtoko. Eky tõ poko penetara ehtoko, pui tomo te, jumẽtu tomo te, imõkomory tõkehko poko roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Moro konomeru totase imoihmãkomo a rueimo osetory maro. Nenenehkane tonese roropa eya xine orexĩto maro ypy po. Enaromỹke toehse toto. Tykytyky tykase toto. Ameke rokẽ toehse toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ynara tykase toto Moeze a: — Yna zururuhtao oya etãko ynanase. Yrome yna zururuhtao Ritonõpo a orihnõko ynanase, tykase toto. ");
INSERT INTO apyNT_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","— Enaromyra ehtoko, tykase Moeze eya xine. — Okuhtorỹko rokẽ Ritonõpo mana. Zuno exikehpyra awahtao xine, aomihpyry omipona exikehpyra matose, oorypyrykõ poko pyra roropa matose. ");
INSERT INTO apyNT_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Yrome ameke rokẽ imoihmãkõ kynexine xikihme. Moeze rokẽ toytose akurũ xinukutumã pũtokoxi, Ritonõpo pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Mame tõturuse Ritonõpo Moeze a ynara katohme Izyraeu tomo a: — Joturutopõpyry oya xine kapu ae tonese oya xine: ");
INSERT INTO apyNT_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Imehnõ oneponãmarykõ onyripyra ehtoko parata risemy te, uuru risemy eahmatohme jeahmaryhtao oya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Apoto apõ tyritoko nono risemy epona oeky tõ zahkatohme tytororo: kaneru tomo te, pui tomo, osepeme ehtohme. Osa tõ menekãko ase moroto jeahmatohme. Moroto oseporỹko ase amaro xine. Kure rokẽ oritorỹko ase roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Apoto apõ riryhtao oya xine topu ke, topu onyhkohpyra ehtoko kurimene ke. Ynara exiryke apoto apõ tyrise ahtao jeahmatohme topu se pyra ase tyhkohse aexityã kurimene ke. ");
INSERT INTO apyNT_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Apoto apõ ykyryryme onyripyra ehtoko opyi maro onuhtohme epona. Morara ãko ase osenepopyra oehtohkõme apoto apõ poko oerokurukohtao oeky tõ jahkary poko jeahmaryme. ");
INSERT INTO apyNT_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Mame ynara Izyraeu tõ zuruko, tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","— Epereumã epekatyryhtao namotome oya xine, 6me jeimamyry erohnõko opoetoryme mana. Mame 7mã po tymyhpokase sã exĩko roropa mana. Onepehmapopyra eya aytotohme ropa. ");
INSERT INTO apyNT_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Typye pyra ynororo namotome toehse ahtao morararo typye pyra ytõko ropa mana. Yrome typye ynororo ahtao namotome toehse ahtao typyty arõko mana tymaro. ");
INSERT INTO apyNT_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Namoto esemy a nohpo tokarose ahtao eya ipytyme, toemũkuase roropa nohpo ahtao, esẽ poetoryme ro mã toto. Mokyro namoto ytõko ropa toiroro. ");
INSERT INTO apyNT_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Yrome ynara tykase namoto ahtao, “Ypyty pyno ase, ypoenõ maro te, jesemy roropa, moxiã rumekary se pyra ase, toiroro jytotohme,” ");
INSERT INTO apyNT_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Ritonõpo eahmatoh taka typoetory arõko esẽ mana. Moroto omõtoh pũtokoxi ipanary posohkãko mana iposohkatoh ke. Mame ipoetoryme exikehpyra exĩko mana toorikyry ponãmero. ");
INSERT INTO apyNT_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","— Tõxiry ekamoryhtao orutua a imepỹ poetoryme ehtohme, orutua sã pyra tymyhpokase ropa sã exipyra mana. ");
INSERT INTO apyNT_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Topekahse ynororo ahtao orutua a, pytary se toexiryke imaro, yrome imeĩpo ise pyra toehse ahtao, nohpo epekahpoko ropa jumy a. Onekamopopyra exiko imehnõ nonory põkomo a, zae pyra toehse esẽ exiryke imaro. ");
INSERT INTO apyNT_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Nohpo epekatyryhtao imepyny a tumũkuru pytyme aehtohme, ipynanohnõko mana tõxiry pynanopyry saaro. ");
INSERT INTO apyNT_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Orutua typytase ropa ahtao imepỹ nohpo ke, kure rokẽ ipyty osemazupu rĩko ro mana. Tonahsẽ ekarõko ro eya mana te, upo ekarõko ro eya mana apitoryme inekarohpyry saaro, ipyno toehtoh enepõko eya mana imaro aehpitotopõpyry saaro. ");
INSERT INTO apyNT_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Morohne onyripyra ahtao eya, tymyhpokase ropa sã nohpo exĩko mana, epehpyry anapoipyra roropa inio mana. ");
INSERT INTO apyNT_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","— Imehnõ etaparyhtao aorihtohme, taorihmaposẽme exĩko etapahpõ mana. ");
INSERT INTO apyNT_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Yrome tuamekaro rokẽ imepỹ taorihmapose eya ahtao, etapary se pyra ahtao, kure mokyro etapahpõ epary osewomatoh pona, ynymenekahpyry pona ehse. ");
INSERT INTO apyNT_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Yrome imepỹ zehno orutua toehse ahtao, etaparyhtao eya, mokyro etapahpõ totapasẽme exĩko, aeparyhtao ro ymaro oturutoh taka osewomatohme totapasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","— Tumy etaetaparyhtao ahno a mokyro taorihmaposẽme exĩko. Tyse etaetaparyhtao eya morararo mokyro taorihmaposẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","— Imepỹ tapoise ahtao ekamotohme tineru poko te, tynamotome tyritohme mokyro taorihmaposẽme exĩko. ");
INSERT INTO apyNT_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","— Tumy osanumane taorihmaposẽme exĩko. Tyse osanumane taorihmaposẽme exĩko roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","— Atatapoiryhtao imepỹ etaparyhtao topu ke te, tomary ke roropa orihpyra ynororo ahtao, mokyro onuwãnohpyra matose. Yrome mokyro owõsaromepyra toehse ahtao, ");
INSERT INTO apyNT_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","yrome imeĩpo toekurãkase ropa ahtao, jarãnaka ytoytõko tymyxiry maro, mokyro etapahpõ epehmãko mana aerohtopõpyry poko erohsaromepyra aexihpyry te, opi tõkehko aekurãkatoh ropa epehpyryme, enara, tokurehnanohpose eya exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","21","— Typoetory pipokuruhtao orutua a. Mame toorihse ynororo typipohse ahtao, mokyro etapahpõ wãnohnõko matose. Yrome okynã orihpyra ynororo ahtao toiro te, asakoro ẽmepyry ahtao, esẽ onuwãnohpyra matose. Tynamoto orihtopõpyry ke tuãnohse sã exĩko mana. Morararo nohpo tõ namotome toto ahtao. ");
INSERT INTO apyNT_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","— Orutua kõ atatapoiryhtao nohpo poetoẽme exikety ryhmaryhtao, mame moro pokoino poeto toepukase ahtao yrome nohpo kure ro, mokyro iiryhmapohpõ epehmãko mana mokyro nio epehmapory, juize nekaropohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Yrome nohpo tyyryhmase ahtao yronymyryme iiryhmahpõ wãnohnõko matose, taorihmaposẽme exĩko mana, toorihse mokyro ahtao. ");
INSERT INTO apyNT_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Enuru epehmãko enuru ke, jery epehmãko jery ke, oma epehmãko oma ke te, pupu epehmãko pupu ke. ");
INSERT INTO apyNT_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Jahkatoh epehmãko jahkatoh ke, isahkatoh epehmãko isahkatoh ke, iiryhmatoh epehmãko iiryhmatoh ke. ");
INSERT INTO apyNT_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","27","— Imepyny a tynamoto enukaryhtao, tynamoto myhpokãko mana enuru epehpyryme tyyryhmasẽme exiryke esemy a. Imepyny a tynamoto zery tahkaryhtao, tynamoto myhpokãko mana jery epehpyryme. Serara tyriposẽme exĩko nohpome inamoto ahtao roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","— Mame ahno totapase ahtao pui a, mame toorihse ahtao, mokyro pui totapasẽme exĩko topu tõ ematoh ke. Ipũ onõpyra matose. Yrome esemy onuwãnohpyra matose. ");
INSERT INTO apyNT_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Yrome mokyro pui torẽnase ahtao ahno ekahmary poko, toto wotohme tyretyry ke, zuaro roropa esemy ahtao mokyro ehtoh poko, yrome anapurupyra tokurehse ahtao, mame ahno totapase eya ahtao nohpo te orutua, enara, mokyro pui etapãko matose topu ke. Esẽ roropa taorihmaposẽme exĩko. ");
INSERT INTO apyNT_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Mãpyra tineru ke epehmary se esẽ ahtao orihpyra toehtohme, epehmãko mã ynororo emero epehmapotopõpyry menekatõkomo a. ");
INSERT INTO apyNT_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Poeto totapase ahtao pui orutua a nohpome ahtao te, poetome ahtao esemy epehmapõko matose moro jomihpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Imepỹ namoto totapase ahtao pui orutua a, inamoto orutuame ahtao te, nohpome ahtao roropa, namoto esẽ 30me parata tõ apoĩko epehpyryme. Mame mokyro pui orutua totapasẽme exĩko topu tõ ke mana. ");
INSERT INTO apyNT_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","— Imepyny a tuna eutary totapuruhmakase ahtao te, eutary tahkase ahtao roropa eya, yrome apuru onyripyra ahtao pui toepukase zaka te, jumẽtu toepukase ahtao zaka, ");
INSERT INTO apyNT_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","okyno esẽ epehmãko mokyro mana tineru ke. Mame mokyro eky ekepyry zotyme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Imepỹ eky pui orutua osetaparyhtao pui orutua maro. Mame mokyro pui totapase ahtao toorihse, mokyro pui orihpyra aexihpyry tokamosẽme exĩko tineru poko apiakatohme mokaro asakoro esẽkõ tinerũme. Pui ekepyry roropa tapiakasẽme exĩko mokaro asakoro zotyme. ");
INSERT INTO apyNT_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Yrome mokyro pui orutua orihpyra exikety moino ro etapahpõme ahtao, moro waro roropa toto ahtao, yrome mokyro anapurupyra tokurehse esẽ ahtao mokyro esemy imepỹ pui orutua ekarõko mana isene exikety mokyro orutua a. Yrome mokyro pui ekepyry zotyme exĩko. ");
INSERT INTO apyNT_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","— Imepỹ eky tomatonanohse ahtao ahno a, pui te, kaneru tõkehko, mame totapase eya ahtao te, tokamose eya ahtao, 5me pui tõ ke epehmãko ropa mana. Kaneru ahtao 4me kaneru tõ ekarõko ropa mana toiro tapoise ahtao eya. ");
INSERT INTO apyNT_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Omato a tomatonanohtopõpyry epehmapoko. Epehmatoh pyra ynororo ahtao, tokamosẽme exĩko mã ynororo namotome, inapoihpyry epehmatohme. Okyno tomatonanohse ahtao, pui te, jumẽtu te, kaneru tõkehko, tonese ropa ahtao isene ro omato emahpo, epehmapoko asakoro, toiro tapoise eya ahtao. — Omato tapoise ahtao koko, aematonaryhtao, totapase ynororo ahtao, etapahpõ zae ro ekarõko matose, omato etapatopõpyry poko. Yrome saereme ahtao etapahpõ ekarõko matose ikarimotahpyryme. ");
INSERT INTO apyNT_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","— Okyno esemy a toky tõ tynomose ahtao, tykyrysã enahse imepỹ tupi po te, imepỹ uwa esary po te, imehnõ napyry tonahse ahtao eya xine, tỹkyryry kurã ke mokaro epehmãko mana, tutupi poe, tynarykahpyry poe uwa esary poe. ");
INSERT INTO apyNT_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","— Imepyny a apoto tukase ahtao tutupi po, mame ãtaryka htaka toytose apoto ahtao imepỹ tupi pona tiriiku zahkase te, inarykahpyry zahkase, mokyro apoto zukahpõ mokaro epehmãko mana jahkatopõpyry epehpyryme. ");
INSERT INTO apyNT_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","— Imepỹ tineru te, imõkomory tokarose ahtao oya ikurãkatohme, mame atapyĩ tae tomatonanohse ahtao, omato tonese ahtao epehmãko mã ynororo asakoro ro. ");
INSERT INTO apyNT_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Yrome omato onenepyra ahtao tapyi esẽ arotoko oximõtoh taka, Ritonõpo eahmatoh taka, moroto tõmiry etapotohme Ritonõpo neneryme, onematonanohpyra toexiry poko, morohne riryhtao eya zae aehtoh enetupuhnõko matose. ");
INSERT INTO apyNT_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","— Pui esẽme toehse ahtao te, jumẽtu te, kaneru te, upo te mõkomo tõkehko, mame imepỹ tooehse ahtao, “Sero esẽme ase,” karyhtao. Mokaro arotoko Ritonõpo eahmatoh taka. Mokyro zae pyra tykase Ritonõpo ahtao, epehmãko mana asakoro, esemy a. ");
INSERT INTO apyNT_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","— Okyno esemy a toky tynomose ahtao imepỹ maro eneneme ehtohme, jumẽtu te, pui te, kaneru te, emero, mame toorihse eky ahtao te, ytopỹme toehse eky ahtao te, tomatonanohse eky ahtao omato onenepyra ahtao, ");
INSERT INTO apyNT_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","mokyro okyno enene tõmiry etapõko Ritonõpo a onematonanohpyra toexiry poko. Onematonanohpyra ahtao aomiry etãko esẽ mana. “Otara kara,” ãko mana. Enene a onepehmapopyra matose. ");
INSERT INTO apyNT_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Yrome eya tomatonanohse mokyro eky ahtao epehmãko mana esemy a eky epehpyryme. ");
INSERT INTO apyNT_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Eky tosekase ahtao onokyro tomo a, akoĩpyry enehnõko enene tuaro esẽ ehtohme. Onepehmara enene mana mokyro eky esekatopõpyry poko. ");
INSERT INTO apyNT_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","— Imepỹ eky tapoise ahtao axĩtao rokene, mame takuruhtase te, toorihse esemy esahpokoxi, mokyro eky apoihpõ axĩtao rokene epehmãko mana eky epehpyryme. ");
INSERT INTO apyNT_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Yrome morara toehse esemy moroto ahtao, onepehmara mokyro mana. Topehke mokyro eky tapoise ahtao eya axĩtao rokene, moro axĩtao rokẽ zurupohpyry epehmãko rokẽ mana. ");
INSERT INTO apyNT_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","— Tynioke pyra exikety poko toehse orutua ahtao, jũ epehmãko mana ipyty epehpyryme. Iniome exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Yrome ise pyra jũ ahtao tõxiry niome, epehmãko ro mana tineru ke tynioke pyra exikety epehpyryme. ");
INSERT INTO apyNT_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","— Joroko poko exiketyme nohpo ahtao, aorihmapoko. ");
INSERT INTO apyNT_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","— Okyno maro osehnõko ahno ahtao taorihmaposẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","— Imehnomo a toky tõ etaparyhtao jahkatohme imepỹ neponãmary eahmaryme ywy kara, mokyro aorihmapoko. Ywy rokẽ ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","— Imehnõ nonory põkõ onyryhmara ehtoko, tõsesarise toto ahtao ononorykõ po. Zae rokẽ ehtoko toto maro. Wenikehpyra katonõme oehtopõpyrykõ poko Ejitu po. ");
INSERT INTO apyNT_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Pytỹpo tõ onyryhmara ehtoko, poetõpo tõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Toto ryhmaryhtao oya xine, ywy Ritonõpo toto akorehmãko ase aotururukohtao ya. ");
INSERT INTO apyNT_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ozehno xine exĩko ase. Oetapatorỹko ase atatapoiry poko awahtao xine. Mame pytỹpome opyxiãkõ exĩko, tumyke pyra opoenõ exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","— Tineru ekaroryhtao oya xine ypoetory tomo a, tymõkomokãkara a, tineru ekarone sã pyra ehtoko. Imotye onepehmapopyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Imepỹ zupõ tapoise ahtao oya, axĩtao rokene tineru axĩtao rokẽ ekaroryke eya, zupõ ekaroko ropa eya kohmãpyra ahtao ro. ");
INSERT INTO apyNT_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Otarame moro zupõ ke rokẽ oxiõtõko nyhtohme, kõxikene pyra ehtohme. Otarame tãtyke pyra ynororo, tupoke pyra toexiryke. Mame ykohmaryhtao takorehmapotohme aomiry etãko ase, zae jexiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","— Omi xihpyry ke Ritonõpo onykerekeremara ehtoko. Popyra otuisary tõ onyripopyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","— Ya onekarory tõ enehtoko toehse tiriiku tõkehko ahtao, uwa eukuru, oriu ahtao roropa. — Omũkuru tõ apitorymãkõ ekarotoko ya. ");
INSERT INTO apyNT_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Oeky tõ mũkuru tõ apitorymãkõ ekarotoko ya: pui tomo te, kaneru tomo. Ah tyse maro nexĩ toto 7me ẽmepyry pona. Mame 8me ẽmepyry ahtao etapako jahkatohme onekaroryme ya. ");
INSERT INTO apyNT_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","— Ypoetoryme matose. Naeroro tõsẽ onõpyra ehtoko onokyro tõ nesekahpyryme aexihpyry, tokarosẽme mana kaikuxi tõ zohme. ");
INSERT INTO apyNT_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","— Ajohpe ehtoh poko oturupyra ehtoko imehnomo a te. Zae pyra exikety anakorehmara ehtoko zae pyra imenekane zururuke oya. ");
INSERT INTO apyNT_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Imoihmãkõ maro pyra ehtoko azahkuru toto ahtao. Omihpo ajohpe onekaropyra ehtoko imoihmãkõ akorehmatohme zae pyra toto ehtoh poko. ");
INSERT INTO apyNT_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Zae pyra ehtoh poko pyra ehtoko, tymõkomokãkara akorehmary se awahtao ro. ");
INSERT INTO apyNT_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","— Oepekara eky eneryhtao oya aytoytoryhtao, tytahse ahtao: pui ahtao te, jumẽtu ahtao, aroko ropa eya. ");
INSERT INTO apyNT_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Oepekara eky jumẽtu toepukase ahtao omoxinety puimary poko, moroto onurumekara exiko. Yrome esẽ akorehmako toky anymyry poko tupupuru pona ropa ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","— Tymõkomokãkara tooehse ahtao apiakane ẽpataka zae ehtoko imaro. ");
INSERT INTO apyNT_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Imehnõ onyhxiropyra exiko ajohpe ehtoh ke. Zae exiketõ anaorihmapopyra exiko roropa. Moro rihpono hxirõko ase popyra exiryke, aorihmapõko ase roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Tineru anapoipyra ehtoko ekarory se imehnõ ahtao zae pyra ehtohme. Moro tineru tonurẽkara sã ahno rĩko mana zae ehtoh onenepyra ehtohme. Morarame kurãkõ akorekehkãko mã rahkene. ");
INSERT INTO apyNT_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","— Imehnõ nonory põkõ onyryhmara ehtoko ononorykõ po tõsesarise toto ahtao. Katonõme ehtoh waro matose, katonõme mexiatose roropa Ejitu po. ");
INSERT INTO apyNT_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","— 6me jeimamyry otupikõ arykãko matose, anapyrykõ apoĩko matose toehse ahtao. ");
INSERT INTO apyNT_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Yrome jeimamyry 7mã po otupikõ anarykara ehtoko. Tykyrysã anapoipyra ehtoko roropa otupikõ poe. Yrome ah tymõkomokãkara notuhno toto tỹkyryry toehse ahtao. Onokyro tõ roropa enahnõko mã toto akoĩpyry nae ahtao. Morara tyritoko roropa uwa tõ ke anarykatyã poko te, azeitona ke anarykatyã poko roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","— Erohtoko 6me ẽmepyry ae, yrome 7mã po erohpyra ehtoko, anamotokõ oserematohme te, oekykõ roropa te, katonõ roropa imehnõ nonory põkõ opoetoryme erohketõ oserematohme roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","— Tomeseke ehtoko jomihpyry omipona oehtohkõme, Ritonõpome ase. Imehnõ neponãmary tomo a oturupyra ehtoko. Esetykõ onesehtopyra roropa ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","— Otuhtoh konõto rĩko matose oseruao, oseahmatohme, jeahmatohme, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Nuno apipe po, moro ae tutũtase oexirykõke Ejitu poe, oseahmatoko õtuhtohkõ ke, Wyi Porutapỹ maro, jomihpyry ae ro. 7me ẽmepyry ae wyi ohnõko matose iporutatoh risẽ pyra. Jeahmãko matose onekarorykõ enepyry ke ya. ");
INSERT INTO apyNT_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","— Oseahmatoko Tykyrysã Apoitoh poko anarykahpyrykõ toehse ahtao, apoipitoryhtao oya xine. — Oseahmatoko roropa Oseahmatoh Tapyi Pisarara poko eina enatyryhtao, uwa tõ apoiryhtao te, wewe epery roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Moro oseahmatoh oseruao pona ro, jeimamyry ae ro, orutua kõ emero oximõnõko mã toto jeahmase. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","— Oeky tõ etaparyhtao oya xine jahkatohme onekarorykõme ya, wyi porutatoh maro onenehpyra ehtoko ya. Onetapatyã kasery zahkãko matose jeahmaryme. Moro ẽmepyry ae ro jahkãko matose. ");
INSERT INTO apyNT_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","— Jeimamyry ae rokẽ anarykahpyrykõ toehse ahtao anapoihpyrykõ apitorymã enehtoko ytapyĩ taka. Ywy ase Ritonõpo Oesẽkomo. — Okyno mũkuru poti te, kaneru mũkuru roropa anahnopyra ehtoko jẽ suhsuru maro. ");
INSERT INTO apyNT_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","— Ynenyokyhpyry aropõko ase oesemazupurukõme oewomatohkõme osema ae oyoytorykohtao aarotohkõme oesaka xine, ynukurãkahpyry oesarykõme. ");
INSERT INTO apyNT_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Tomeseke ehtoko aomiry omipona oehtohkõme. Ozehno xine onyripopyra ehtoko, tonyohse ya aexiryke. Ozehno xine toehse ynororo ahtao azahkuru oehtohkõ onykorokara mana. ");
INSERT INTO apyNT_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Yrome aomipona yronymyryme awahtao xine, inyripohpyry riryhtao oya xine, oepetõkara poremãkapõko ase. ");
INSERT INTO apyNT_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ynenyokyhpyry ytõko osemazuhme. Aarotorỹko mã ynororo amoreu tõ nonory pona te, heteu tõ te, perizeu tõ te, kananeu tõ te, heweu tõ te, jepuseu tõ maro. Mokaro enahkãko ase. ");
INSERT INTO apyNT_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Mokaro neponãmarykõ ẽpataka epuipyra ehtoko. Oneahmara ehtoko. Toto namorepatoh poko pyra ehtoko ipunaka. Toto neponãmarykõ enahkatoko, xikihme exiketõ Paau kyryryme ikararahtoko. ");
INSERT INTO apyNT_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Jeahmaryhtao oya xine Ritonõpome, Oesẽkõme, kure rokẽ oritorỹko ase. Tonahsẽ ekarõko ase oya xine tuna roropa. Owino xine tyrohsẽ arõko ase mya. ");
INSERT INTO apyNT_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ononory po opyxiãkõ emũkuãko mã toto. Epukara poeto tõ exĩko mã toto. Ypoe isene matose exĩko okynahxo. ");
INSERT INTO apyNT_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","— Oepetõkara rĩko ase enaromỹke, juno toto ehtohme. Tuaro pyra toto rĩko ase, otupĩko mã toto imaro xine õsetaparykohtao. Owino xine oepetõkara enepanohpõko ase. ");
INSERT INTO apyNT_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ouno xine oepetõkara ripõko ase. Mame oyoytorykohtao ononorykõ apoitohme heweu tõ aropõko ase te, kananeu tomo te, heteu tõ maro owinoino xine. ");
INSERT INTO apyNT_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Mokaro anaropopyra ase toiro jeimamyry ae. Morara tyrise ahtao ya tytaõke pyra moro nono exiry repe, onokyro tõ esaryme exiry roropa repe, popyra exiry oya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mãpyra toitoine mokaro aropõko ase tuhkehxo oemãtohkõme te amarokõ osesaritohme sero nono po. ");
INSERT INTO apyNT_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ononorykõ ehpiry rĩko ase Akapa tunary poe tuna Eupyrati pona te, tuna Metiteraneu poe ona tonorẽ pona. Ajamihtanohtorỹko ase imeimehnõ poremãkapotohme oya xine, toto nonory apoitohme oya xine oesarykõme, toto aroporyhtao oya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Osepeme pyra ehtoko toto maro te, toto neponãmarykõ maro osepeme pyra ehtoko ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Oesarykõ onekaropyra ehtoko mokaro a ononorykõ po. Oesarykõ ekaroryhtao eya xine iirypyryme oritorỹko mã toto yneneryme. Jomipona pyra oritorỹko mã toto. Mokaro neponãmary tõ eahmaryhtao oya xine toatãkaposẽme exĩko matose. ");
INSERT INTO apyNT_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ynara tykase Ritonõpo Moeze a: — Onuhtoko ypy pona jẽpataka: omoro, Arão te, Natape, Apiu maro te, 70me Izyraeu tõ tamuximãkõ maro. Mame ameke ro awahtao xine oesekumurukõ po oporohtoko jeahmatohme. ");
INSERT INTO apyNT_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Omoro rokẽ, Moeze, upũtokoxi oehnõko mase. Mokaro arypyra. Ahno tõ imoihmãkõ onuhpyra tyripoko toto ypy pona. ");
INSERT INTO apyNT_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Imoihmãkõ zuruse toytose Moeze, Ritonõpo omihpyry emero, inyripohpyry roropa. Mame ynara tykase Izyraeu tõ oximõme: — Ritonõpo omihpyry emero omipona exĩko ynanase. ");
INSERT INTO apyNT_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ritonõpo, Izyraeu tõ Esẽ nyripohpyry emero tymerose Moeze a. Yrokokoro pakeimo apoto apõ tyrise eya ypy myhto. 12me xikihme exiketõ, topu tõ tyrise eya, 12me Izyraeu oxiekyrymãkõ pune ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Mame nuasemãkomo a okyno tõ zahkary poko tyripose Moeze a Ritonõpo eahmaryme, pui orutua kõ totapapose roropa eya tynekaroryme osepeme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Munu tapiakase Moeze a, zokonaka tyrise eya paxiha tõ aka te, zokonaka tukuãse apoto apõ pona. ");
INSERT INTO apyNT_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Mame Ritonõpo papẽ tapoise eya, moro poko tymerose Ritonõpo omihpyry te, inyripohpyry, enara. Moro pape tysekeremase eya imoihmãkõ netaryme. Ynara tykase toto: — Ritonõpo Kuesẽkõ omiry omipona exĩko ynanase, inyripohpyry rĩko ynanase porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mame moro munu paxiha ao tapoise Moeze a, sapararahme tomase eya imoihmãkõ pona. Ynara tykase ynororo eya xine: — Sero munu enetupuhtohme mana, kure oritorỹko Ritonõpo mana, tõmihpyry ae ro senohne inyripohpyry tokarose ahtao oya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Tõnuhse toto ypy pona, Moeze, Arão maro te, Natape te, Apiu maro, 70mãkõ Izyraeu tõ tamuximãkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ritonõpo, Izyraeu tõ Esẽ tonese eya xine. Ipupuru zopino zara sã tonese sapira tõ risemy, ezuezume kapu samo. ");
INSERT INTO apyNT_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Mokaro Izyraeu tõ tamuximãkõ onetapara Ritonõpo kynexine; tonese ynororo eya xine, moromeĩpo tõtuhse toto eukuru tõse eya xine oximõme. ");
INSERT INTO apyNT_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ynara tykase Ritonõpo Moeze a: — Onuhko ypy pona ya, tehme ehse tarona. Ynymerohpyry topu tõ poko ekarõko ase, ynyripohpyry, Izyraeu tõ amorepatohme. ");
INSERT INTO apyNT_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mame tãtakimase Moeze tomo takorehmane Jozue maro. Tonuhpitose ynaroro ypy kurã pona. ");
INSERT INTO apyNT_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ynara tykase Moeze Izyraeu tõ tamuximãkomo a: — Yna eraximatoko taro, yna oepyry ropa pona. Amaro xine Arão te Huru maro. Ekaropotoh nae awahtao xine oturutoko eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mame tõnuhse Moeze ypy Xinai pona, ypy tyõtose akurũ a. ");
INSERT INTO apyNT_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Mame Ritonõpo ezuru tyhtose ypy pona. Apoto sã ezuru tonese Izyraeu tomo a ypy emory po. 6me ẽmepyry taropose moroto akurũ ypy po. Mame 7mã po Moeze tykohmase Ritonõpo a akurũ poe. ");
INSERT INTO apyNT_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Tomõse Moeze moro akurũ htaka. Moroto tehme toehse ynororo 40me ẽmepyry, 40me kohmamyry, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","— Izyraeu tõ zuruko tynekarory tõ enehtohme ya. Toto nekarotyã apoiko emero ekarory se aehtohkomo. ");
INSERT INTO apyNT_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Kure ynara ekaroryhtao: uuru te, parata te, metau te; ");
INSERT INTO apyNT_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","kaneru hpoty earyme tyrise ahtao ezuezume te, puupura te, tahpiremano te; mauru panono te; kamisa poti hpoty risemy te; ");
INSERT INTO apyNT_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kaneru pihpyry tonohse tahpire ahtao te, okyno pihpyry kurano te; wewe akaxiame te; ");
INSERT INTO apyNT_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","oriu, azeite nãparina eukurume, jahkatohme te; typoxine exiketomo azeite maro zoximatohme ahno popatohme te, jahkatohme roropa ixtaratu zahkatoh po typoxine exiketyme; ");
INSERT INTO apyNT_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","topu tõ kurano, onixi te, imehnõ typyne exiketõ tyritohme Ritonõpo maro oturukety zupõ pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Tapyi Kurã tyripoko Izyraeu tomo a jesaryme ehtohme toto rãnao. ");
INSERT INTO apyNT_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","— Omoro Moeze, moro tapyi tyripõko ase, itaõkõ maro, ynenepory sã oya. ");
INSERT INTO apyNT_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","— Kaxo tyripoko wewe akaxia risemy, 1,10 meturume mosa exiry te, 66 sẽtimeturume ipuroroje exiry te, 66 sẽtimeturume kae exiry, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Uuru kurã ke moro kaxo apuhko zao te, jarao, enara. Ehpikuroko uuru risẽ tyriko roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","4me parihmã tyriko uuru risemy ipupuru 4mãkõ pokona, tyritohme asakoro seino, asakoro moino arotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Asakoro mara tyriko epurume, wewe akaxiame tapuhse uuru ke. ");
INSERT INTO apyNT_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Moro mara tõ tyriko moro parihmã aka kaxo ratozo ae asakoro. ");
INSERT INTO apyNT_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Moroto parihmã ao mara tõ inomoko, morohne onoupopyra exiko esary tõ poe. ");
INSERT INTO apyNT_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Topu risẽ asakoro ekarõko ase oya, ipoko ynyripohpyry tymerose mana. Morohne tyriko kaxo aka, jomihpyry ẽ aka. ");
INSERT INTO apyNT_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","— Kaxo apuru tyriko roropa, uuru kurã risemy, 1,10 meturume mosa exiry te, 66 sẽtimeturume ipuroroje exiry, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Asakoro taporihke exiketõ tyriko, uuru tapitapĩse risemy, kaxo apuru etyhpyry tõ po. ");
INSERT INTO apyNT_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Toiro tyriko seino, toiro moino apuru etyhpyry tõ po kaxo apuru maro toiro kyryryme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Tyriko toto osẽpataka aporiry tõ totapuruhmakase kaxo apuru epoe. ");
INSERT INTO apyNT_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Kaxo aka moro topu risẽ asakoro tyriko. Epona kaxo apuru tyriko. ");
INSERT INTO apyNT_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Moroto amaro oseporỹko ase, oturũko ase kaxo apuru epoe, taporihke exiketõ asakoro rãnao. Ynyripohpyry emero ekarõko ase oya Izyraeu tomo a ekarotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","— Meza tyriko wewe akaxia risemy, ynara samo: 88 sẽtimeturume mosa exiry te, 44 sẽtimeturume ipuroroje exiry te, 66 sẽtimeturume kae exiry, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Uuru kurã ke meza apuhko. Ehpikuroko uuru risẽ tyriko roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Meza zomye ehpiry tyriko 7 sẽtimeturume, uuru risẽ roropa tyriko ehpiry zomye. ");
INSERT INTO apyNT_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","4me parihmã tyriko uuru risemy tyritohme meza poko ipupuru 4mãkõ pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Moro parihmã tyriko meza ehpio pũtokoxi mara tõ apoitohme, meza epurume, arotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Moro epuru tõ tyriko wewe akaxia ke, uuru kurã ke apuhko kehko. Meza arõko matose moro mara tõ poko. ");
INSERT INTO apyNT_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Uuru kurã ke paratu tõ tyriko te, kopu tomo te, paxiha tomo te, jaha tomo uwa eukuru eny, onekarorykõ kyryryme. ");
INSERT INTO apyNT_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Moro meza tyriko jomihpyry ẽ ẽpataka. Meza po wyi tõ tyriko kokoro rokene. Ynyripohpyry onekarorykõme ya. ");
INSERT INTO apyNT_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","— Ezuru apõ tyriko uuru risemy. Apõ tyriko uuru tapitapĩse exikety ke, zoko roropa. Ekuru tõ tyriko emeporyme te, potão tõ maro petara tõ maro toiro kyryryme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","6me amoriry tyriko zoko poko, oseruao toiro eriety poko, oseruao zakorõ eriety poko. ");
INSERT INTO apyNT_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Toiro amoriry poko oseruao ekuru tyriko, amẽtoeira ekuru panono potão tõ maro, petara tõ maro. Oxisã amoriry tõ tyriko. ");
INSERT INTO apyNT_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","— Ezuru apõ zoko poko 4me ekuru tõ tyriko amẽtoeira ekuru samo potão tõ maro, petara tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Asakoro amoriry zopino toiro potão tyriko amẽtoeira kyryry, oseruao potão tomo. ");
INSERT INTO apyNT_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Moro potão tomo te, amoriry tomo te, ezuru apõ zoko maro toiro kyryryme tyriko uuru risẽme, tapitapĩse exikety. ");
INSERT INTO apyNT_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","7me nãparina tyriko ezuru apõ po, saereme ehtohme ezuru ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Jahpi tõ ezuru tõ aryry kyrytohme te, oruno kyryry roropa tyriko uuru kurã ke. ");
INSERT INTO apyNT_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","34 kirume uuru kurã ke moro ezuru apõ tyriko ikyryry tõ maro emero. ");
INSERT INTO apyNT_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","— Tomeseke roropa tyritohme emero ynenepohpyry sã oya ypy po. ");
INSERT INTO apyNT_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Mame ynara tykase Ritonõpo Moeze a: — 10me kamisa tõ tyriko tapyi, ymaro oturutoh apurume, zao: kamisa mauru panõ risemy te, kaneru hpoty risẽ eary maro, ezuezume te, puupura te, tahpire, enara. Sero kamisa tõ tyriko enekure taporihkã panõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Toiro kamisa tyriko 12,5 meturume mosa exiry te, 1,80 meturume ipuroroje. ");
INSERT INTO apyNT_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","5me kamisa tõ ixixĩnõko mase toiro kamisa konõto ehtohme. Morara tyriko roropa zakorõ 5me kamisa tõ ke. ");
INSERT INTO apyNT_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Imyhtoh tyriko kamisa ezuezumã ke kamisa ehpiõ poko jarao exikety etyhpyry poko. Morara tyriko roropa zakorõ kamisa konõto poko. ");
INSERT INTO apyNT_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","50me imyhtoh tyriko kamisa apitorymã ehpiõ poko te, 50me roropa kamisa etyhpyry ehpio zakorõ kamisa konõto poko, imyhtoh tonõ osẽpataka ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","50me apoitoh tyriko roropa uuru risemy kamisa tõ asakoro osexihtohme toiro sã moro kamisa tõ ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","— Amotoh tyriko tapyi amotohme. 11me kamisa tõ apoiko poti hpoty risemy. ");
INSERT INTO apyNT_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Oxisã zumo kehko tyriko 13,30 meturu mosa exiry te 1,80 meturume ipuroroje exiry, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","5me moro kamisa tõ ixixĩnõko mase toiro kamisa konõto ehtohme. Moro imehnõ 6mãkõ ixixĩnõko mase osepokona toiro kamisame ehtohme. Moro kamisa 6mano osẽtapona exĩko tapyi potataõ po. ");
INSERT INTO apyNT_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","50me imyhtoh tyriko kamisa etyhpyry ehpio kamisa apitorymã po te, 50me imyhtoh roropa zakorõ kamisa ehpio. ");
INSERT INTO apyNT_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","50me apoitoh tyriko roropa metau risemy. Imyhtoh 50mãkõ pokona moro apoitoh tonõ tyriko kamisa tõ asakoro osexihtohme, toiro tapyi amotohme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Moro kamisa zokonaka akoĩpyry tyhwyme exĩko tapyi mykae. ");
INSERT INTO apyNT_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","45 sẽtimeturume kamisa akoĩpyry tapyi panakotuh pokoxi moroto exĩko tapyi amotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","— Imepỹ amotoh asakoro tyriko: toiro tyriko kaneru pihpyry ke, zonopyhpyry tahpireme. Moro pona imepỹ amotoh tyriko onokyro pihpyry kurã ke. ");
INSERT INTO apyNT_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","— Wewe risẽ tyriko akaxia risẽme xikihme exiketomo tapyi kyryryme. ");
INSERT INTO apyNT_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","4,45 meturume mosa aehtoh tyriko te, ipuroroje 67 sẽtimeturume. ");
INSERT INTO apyNT_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Asakoro tyrãmatoh ke moro wewe risẽ tyriko aosexihtohme imepỹ maro. Morara tyriko emero wewe risẽ poko, tapyi kyryry kehko. ");
INSERT INTO apyNT_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","20me wewe risẽ tyriko tapyi apurume ikurenaka exikety a. ");
INSERT INTO apyNT_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Moro 20mãkõ wewe risẽ apõme 40me parata risẽ tyriko asakoro apõ tyritohme toiro wewe risẽ apõme, tũpore moro aosexihtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","20me wewe risẽ tyriko tapyi apurume inikahpozakoxi exikety a. ");
INSERT INTO apyNT_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","40me parata risẽ tyriko wewe risẽ apõme, toiro wewe ahtao asakoro apony. ");
INSERT INTO apyNT_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Tapyi mykae, xixi omõtoh wino, 6me wewe risẽ tyriko. ");
INSERT INTO apyNT_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Asakoro wewe risẽ tyriko roropa tapyi eriety tõ kyryryme. ");
INSERT INTO apyNT_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Moro wewe risẽ eriety tõ kyryryme osexihnõko mã kehko apõ poe zupuhpyry pokona toiro kyryryme sã ehtohme. Moro asakoro wewe risẽ, moro eriety tõ ritohme morara tyrihpyryme exĩko mã kehko. ");
INSERT INTO apyNT_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Morara exiryke 8me wewe risẽ exĩko, 16me parata risẽ apõ maro. Asakoro apõ exĩko toiro wewe risẽ apõme. ");
INSERT INTO apyNT_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","— 15me wewe tyriko akaxia risemy moro wewe risẽ kuroko ehtohme 5me ehtohme wewe kuroko ikurenaka exikety a. ");
INSERT INTO apyNT_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","5me wewe kuroko ehtohme inikahpozakoxi exikety a te, 5me wewe kuroko ehtohme tapyi mykae, xixi omõtoh wino. ");
INSERT INTO apyNT_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Toiro wewe irãnaono tyriko; irãnakuroko wewe risẽ apitorymã poe tapyi etyhpyry pona. ");
INSERT INTO apyNT_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Moro wewe risẽ tõ atapuhnoko uuru ke. Parihmã tyriko uuru risẽme moro wewe risẽ pokona epuru ritohme. Moro epuru roropa atapuhnoko uuru ke. ");
INSERT INTO apyNT_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tapyi anỹtoko xikihme ynenepohpyry saaro oya ypy po. ");
INSERT INTO apyNT_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","— Kamisa tyriko apurume samo mauru panõ kurã risẽme kaneru hpoty eary maro ezuezume te, puupura te, tahpiremã maro, enara. Taporihkã panõ ke emeporyme tyriko. ");
INSERT INTO apyNT_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","4me wewe xikihmãkõ pona tyhwyme moro kamisa tyriko. Akaxiame wewe pona tapuhse uuru ke, apoitoh ke uuru risemy, tapõ ke 4mãkõ ke parata tõme. ");
INSERT INTO apyNT_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Tyhwyme moro kamisa tyriko apoitoh uuru risẽ zopino. Mame moro apurume moino akoxi kaxo, jomihpyry ẽ tyriko, topu risẽ asakorõkõ eny. Moro kamisa Osa Kurã apiakãko mana Osa Kurã Kuhse wino. ");
INSERT INTO apyNT_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Mame kaxo apuru tyriko jomihpyry ẽ pona, Osa Kurã Kuhse tao. ");
INSERT INTO apyNT_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Jarao Osa Kurã Kuhse ẽpataka meza tyriko inikahpozakoxi tapyi tao. Ikurenaka tapyi tao ro ezuru apõ tyriko. ");
INSERT INTO apyNT_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","— Tapyi omõtoh tao kamisa tyriko, mauru panõ kurã risemy kaneru hpoty eary maro ezuezumano te, puupura te, tahpire te, emepory maro. ");
INSERT INTO apyNT_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Moro kamisa apoitohme, wewe akaxia risẽ xikihme exiketõ tyriko 5me, tapuhse uuru ke, kamisa apoitoh ke roropa uuru risemy. Moro 5me wewe apõ tyriko metau risẽ ke. ");
INSERT INTO apyNT_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ynara tykase Ritonõpo Moeze a: — Wewe akaxia ke apoto apõ tyriko, tahramehme sã ehtohme, 2,20 meturume mosa exiry te, ipuroroje exiry morararo 2,20 meturume te, 1,30 meturume kae exiry, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ipotyry tõ po, 4me iretyry tõ tyriko, aosexihtohme apõ maro, toiro kyryryme sã ehtohme. Apoto apõ tytororo tapuhse tyriko metau ke. ");
INSERT INTO apyNT_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Otyro ẽ tõ tyriko oruno ẽme ehtohme ikasery ẽme roropa, anỹtoh tonõ maro te, paxiha tomo te, okaimo tomo te, ikarã eny tõ maro. Morohne emero tyrihpyryme exĩko metau risẽme. ");
INSERT INTO apyNT_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Metau risẽ tyriko apoto ẽme, 4me parihmã maro metau risẽme, ipotyry 4mãkõ poko, epuru ritohme, arotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Moro apoto ẽ tyriko apoto apõ ao, irãnao ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Epuru tõ tyriko wewe akaxia risẽme, tapuhse metau ke. ");
INSERT INTO apyNT_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Tyriko kehko parihmã aka apoto apõ eriety poko asakoro, arotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Moro apoto apõ wewe risemy tytaõke pyra exĩko mana, ynenepohpyry saaro oya ypy po. ");
INSERT INTO apyNT_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","— Zara tyriko tapyi ymaro oturutoh zomye, tapuruse kamisa ke, mauru panõ risẽ ke. Apuru ikurenae exikety kamisa mosa ehtoh 44 meturume exĩko. ");
INSERT INTO apyNT_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","20me xikihme exiketõ tyriko tapõkõke 20me metau risẽme. Apoitoh xikihmãkõ poko tyrĩko mase parata ke, epuru roropa parata risẽme kamisa ryhkatohme. ");
INSERT INTO apyNT_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Morararo tyriko zara ehpikuroko inikahpoe aehtopo a. ");
INSERT INTO apyNT_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","13","Moro zara ipuroroje 22 meturume exĩko. Naeroro apuru rĩko mase kamisa risẽ ke 22 meturume mosa exiry xixi omõtoh wino te, xixi tũtatoh wino, enara. Moro kamisa apoitoh tonõ 10me xikihmãkõ tyriko 10me apõ tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Omõtoh erietyme kamisa exĩko 6,60 meturume mosa exiry te, 3me xikihme exiketomo, 3me apõ maro, apotunuru wino te, ipozery wino, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Omõtoh tao zara pona kamisa rĩko mase 8,80 meturume mosa exiry. Moro kamisa tyriko mauru panõ kurã ke, kaneru hpoty maro: ezuezume exikety te, puupura te, tahpiremano, enara, emeporyme ehpiõ poko. Moro kamisa apoitohme 4me xikihmãkõ tyriko, 4me apõ tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Moro xikihmãkõ zara zomye oximaro tymyhsẽme exĩko parata risẽ ke. Kamisa apoitoh, iryhkatoh tonõ mã parata risẽme exĩko te, tapõ tõ metau risẽme exĩko. ");
INSERT INTO apyNT_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Moro zara mosa exiry 44 meturume exĩko. Ipuroroje 22 meturume exĩko. Apuru kamisa risẽ kae exiry 2,20 meturume exĩko. Moro kamisa mauru panõ risẽ kurãme exĩko te, apõ tõ metau risẽme exĩko. ");
INSERT INTO apyNT_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tapyi mõkomory kehko emero metaume exĩko te, epuru tõ roropa tapyi myhtohme te, zara apuru myhtohme roropa metau risẽme rokẽ kehko. ");
INSERT INTO apyNT_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","— Oriu, azeite kurã enehpoko Izyraeu tomo a, ezuru eukurume, kokoro rokene, kokonie pukuro, ezuru zukatohme. ");
INSERT INTO apyNT_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Moro ezuru apõ arõko Arão tomo a imũkuru tõ maro, tapyi taka, ymaro oturutoh taka, jarao kamisa myhtokoxi, kaxo, jomiry ẽ ẽpataka. Moroto oriu zahkãko saerehkatohme jẽpataka kokonie pukuro poe ẽmehtoh pona. Sero omipona exĩko Izyraeu tomo ipoenõkomo, ipakomotyãkomo jũme, kakehpyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ynara tykase Ritonõpo Moeze a: — Orui Arão enehpoko imũkuru tõ maro, Natape, Apiu, Ereaza, Itamaa, enara. Toto imenekako Izyraeu tõ wino ypoko toto erohtohme, ymaro oturuketõme. ");
INSERT INTO apyNT_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Upo tyriko, ymaro oturukety zupõme, ekarotohme orui a imehxo exiketyme aehtohme imehnõ neneryme te, kure potu aehtohme roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ypoe emese kure exiketõ ikohmako emero, Arão zupõme tyritohme eya xine, ynymenekahpyryme Arão ehtohme ymaro oturuketyme aehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ynara tyripoko eya xine: ipuropuru apuru, upo oturukety mose ro katopo, oturukety zupõ mosano jaraõme exikety, kamisa emepory xixĩsemy enekure exikety, zupuhpyry zõty, zamareary, enara. Morohne upo tyripoko eya xine ymaro oturuketõ zupõme, orui Arão zupõme ehtohme, imũkuru tõ maro jomiry omipona toto erohtohme ymaro oturuketõme. ");
INSERT INTO apyNT_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Mokaro emese kure exiketõ moro upo rĩko mã toto kaneru hpoty eary ezuezumã ke te, puupuramã ke te, tahpiremã ke te, mauru panõ eary kurã ke te, uuru eary ke, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","— Mame oturukety zupõ tyripoko emese kure exiketomo a, mauru panõ kurã ke te, kaneru hpoty eary ezuezumã ke te, puupura ke te, tahpiremã ke te, uuru earyme te, ixiximyhpyry ke emepory ke, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Moro upo aretyry pokona asakoro kamisa tõ tyriko eary panõ imotary kyryryme, tyxixĩse moro upo ratozo asakoro pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Zamareary kahnõko matose mauru panõ kurã ke, moro upo risẽ samo, moro upo pokona ixixĩtohme toiro exikety sã ehtohme moro upo maro. ");
INSERT INTO apyNT_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Topu tõ kurã apoiko asakoro akata ipokona Jako mũkuhpyry tõ esetykõ imerotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","6me esetykõ toiro akata pona, 6me esetykõ zakorõ pokona atakenaka aenurutopõpyry poe ro. ");
INSERT INTO apyNT_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Emese kure exikety imenekako moro topu tõ asakoro pokona Jako mũkuhpyry tõ esetykõ merotohme te, uuru pokona moro topu tõ tyritohme. ");
INSERT INTO apyNT_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Moro topu tõ tyriko eary tõ pokona, moro upo kyryry pona Izyraeu tõ esetykõ arotohme Arão a Ritonõpo ẽpataka, aerokurukohtao tapyi kurã tao. Morara ahtao ywy, Ritonõpo, wenikehpyra ase ypoetory tõ poko. ");
INSERT INTO apyNT_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Uuru risẽ asakoro, apoihty tõ tyriko, topu tõ kurã apoihtyme, ");
INSERT INTO apyNT_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Keti tõ asakoro roropa uuru risẽme eary samo aosexihtohme apoihty tõ pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","— Puropu apuru tyriko moro upo samo, mauru panõ kurã ke te, kaneru hpoty eary ezuezumã maro te, puupura maro te, tahpiremã maro te, ipanõ tõ ke ixiximyhpyry roropa, Ritonõpo maro oturuketõ imehxo exikety Ritonõpo nyripory waro ehtohme, ");
INSERT INTO apyNT_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Puropu apuru tahramehme sã tyrĩko mase asakoro iramahpyry sã exiketyme ehtohme, 22 sẽtimeturume mosa exiry te, 22 sẽtimeturume ipuroroje exiry, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ipokona 4me atakenaka topu tõ kurã tyriko; atakenaka apitorymã ao rupi, topazio, karanata; ");
INSERT INTO apyNT_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","atakenaka zakorõ ao ezemerauta, sapira, tiamãte; ");
INSERT INTO apyNT_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","atakenaka oseruaõ ao turukeza, akata, ametixta; ");
INSERT INTO apyNT_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","atakenaka 4mano ao periro, onixi, jasape, enara. Morohne tyriko uuru pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Toiro topu ahtao Jako mũkuhpyry esety toiro imeroko ipokona 12me topu tõ kurã pokona 12mãkõ Jako mũkuhpyry tõ esetykõ tymerose ehtohme, 12mãkõ oxiekyrymãkõ enetupuhtohme Ritonõpo ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Keti tõ asakoro tyriko uuru eary ke. Earyme tyriko moro uuru ipuropuru apoihtyme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Parihmã asakoro tyriko uuru risẽme puropu apuru potyry pokona kae aosexihtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Moro eary tõ asakoro uuru risẽ tyriko parihmã tõ asakorõkõ kuroko. ");
INSERT INTO apyNT_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Eary tõ etyhpyry tõ tyriko uuru risẽ pokona puropu apuru osexihtohme apoihty pokona, moro upo pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Imehnõ parihmã tyriko uuru risẽ asakoro puropu apuru potyry pokona zopino, ehpio poko zao moro upo ao. ");
INSERT INTO apyNT_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Parihmã asakoro tyriko uuru risẽme aosexihtohme apoihty tõ etyhpyry pokona moro upo pokona osexihtoh pũto zamareary epozakoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Eary ezuezumã ke puropu apuru imyhko parihmã poko moro upo parihmã poko aosexikyhpyry sã ehtohme epukara ehtohme, zamareary epozakoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","— Mame Osa Kurã taka Arão omomyryhtao Ritonõpo Esary Kurã taka puropu apuru amurũko mana tymerose Izyraeu tõ esetykõ ke, wenikehpyra jehtohme ypoetory tõ poko. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Puropu apuru pokona Urim tyriko Tumĩ maro Arão eano po sã Izyraeu tõ ehtohme jẽpataka tooehse ynororo ahtao. Morara ahtao puropu apuru enẽko mana ise jehtoh waro ehtohme tyripotohme Izyraeu tomo a. ");
INSERT INTO apyNT_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","— Upo tyriko kamisa ezuezumã ke Arão tõ a amurutohme moro upo kurã zopino. ");
INSERT INTO apyNT_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Eutary tyriko zupuhpyry omõtohme. Moro eutary zomye kamisa xixĩnõko matose exihkara ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Moro upo ehpikuroko zopino emepory tyritoko romã epery panono, kaneru hpoty eary risemy ezuezumã ke te, puupura ke te, tahpiremã ke, enara. Epery asakoro rãnaka imarakã pitiko tyriko uuru risẽme. ");
INSERT INTO apyNT_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Moro kamisa ezuezumã ke Arão a amurupoko toerokuru poko tahtao, ymaro oturutohme. Aomomyryhtao jẽpataka Jesary Kurã taka te, itũtary ropa ahtao moro marakany osetãko, mokyro onetaparaino. ");
INSERT INTO apyNT_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","— Uuru risẽ pipahmã tyriko, ipokona tymerose: Imenekahpyryme Ritonõpo Poetoryme. ");
INSERT INTO apyNT_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Moro uuru risẽ pipahmã imyhko Arão zuhzõty pokona eary ezuezumã ke. ");
INSERT INTO apyNT_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Arão a amurupoko moro uuru pipahmã ke ipery pokona, ywy Ritonõpo yzamaro Izyraeu tõ nekarotyã ehtohme, toto onyhxiropyra jehtohme azahkuru toehse toto ahtao tynekarorykõ enepyryhtao ya. ");
INSERT INTO apyNT_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","— Kamisa tõ tykahtoko oturukety Arão zupõme mauru panõ kurã karimutumã ke te, zuhzõty roropa mauru panõ kurã ke te, zamareary panõ emepory ke ixiximyhpyry ke. ");
INSERT INTO apyNT_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","— Arão mũkuru tõ zupõ tõ ixixĩtoko, kamisa, zamareary, zuhzõty tõ roropa, tuisamehxo toto enetupuhpotohme te, toto enetohme kure. ");
INSERT INTO apyNT_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Moro upo kurã ke orui Arão a amurupoko imũkuru tõ maro. Mame toto ekaroko ya ypoetoryme toto ehtohme. Azeite pitiko ke ahpako toto, ymaro oturuketõme toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Axiakã tyriko toto zupõme mauru panõ karimutumã ke zamareary poe ipety tõ pona. ");
INSERT INTO apyNT_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Moro upo amurupoko Arão a imũkuru tõ maro aomomyryhtao Tapyi Kurã taka, ymaro oturutoh taka te, apoto apõ pũtokoxi toto ytoryhtao roropa erohse Jesary Kurã taka, toto etaparyino. Tomeseke toto ahtao orihpyra exĩko mã toto, emurukõ osenepyra exiryke. Moro omipona Arão tyripoko imũkuru tõ maro, ipakomotyãkõ maro jũme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Mame ynara tykase Ritonõpo Moeze a: — Ynara tyriko Arão tõ menekaryme imũkuru tõ maro, erohtohme ymaro oturuketõme. Pui mũkuru apoiko wãtara ro exikety kaneru tõ asakoro ahmitatyã kara rokene. ");
INSERT INTO apyNT_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Tiriiku risẽ wyi tõ tyriko toitoine oriu maro te, toitoine oriu maro pyra, emero iporutatoh maro pyra exiketõme, enara. Wyi pipahme exiketõ tyriko roropa epona azeite ritohme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Morohne tyriko ruto aka onekarorykõme ya, pui mũkuru wãtara ro exikety etaparyhtao, kaneru tõ asakoro maro onekarorykõme ya. ");
INSERT INTO apyNT_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","— Arão tõ enehko imũkuru tõ maro Tapyi omõtoh taka, ymaro oturutoh taka, aekurikatohkõme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Mame Arão a upo amurupoko, oturukety zupõ ke: kamisa te, oturukety zupõ zopinono te, zupõ jaraono te, puropu apuru te, zamareary imetỹ earyme, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Zupuhpyry pona zuhzõty tyriko. Uuru risẽ pipahmã imyhko ipokona, imerohpyry: “Imenekahpyry Ritonõpo poetoryme,” katopo. ");
INSERT INTO apyNT_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Mame zupuhpyry oriu ke ahpako. ");
INSERT INTO apyNT_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","— Arão mũkuru tomo a roropa upo amurupoko toto kamisa ke. ");
INSERT INTO apyNT_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Kamisa tyriko zamarearyme imetỹkõ earyme. Zuhzõty tõ imyhko zupuhpyrykõ pona. Morara Arão tõ ekarõko mase imũkuru tõ maro ya ymaro toto erohtohme. Jũme ypoetoryme Arão tõ erohnõko mã toto imũkuru tõ maro te, ipakomotyã maro, ymaro oturuketõme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","— Pui mũkuru enehta Tapyi ẽpataka. Arão tõ, imũkuru tõ maro, tomarykõ rĩko mã toto zupuhpyry pona. ");
INSERT INTO apyNT_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Mame pui mũkuru etapako jẽpataka Tapyi omõtoh myhtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Imunuru apoiko oemary ke tyritohme apoto apõ retyry pokona. Munu akoĩpyry ikuãko apoto apõ myhtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Mame apoto apõ po ynara okyno jahkako onekaroryme ya: ikasery emero zuahxiririny poko exikety te, erery zokonaka kurano te, epyasyhny asakoro ikasery maro. ");
INSERT INTO apyNT_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Yrome mokyro zoko jahkako ameke, jarao Izyraeu tõ esary poe: ipihpyry maro te, zuahxiririny maro. Moro mã oturuketõ nekaroryme ya, tyyrypyrykõ korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","— Mame kaneru apoiko toiro, zupuhpyry pona Arão tõ imũkuru tõ maro tomarykõ ritohme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Mokyro kaneru etapako. Imunuru emako apoto apõ ehpiry 4mãkõ pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Kaneru zoko isahkako. Zuahxiririny ikurikako tuna ke, jaxiry tõ maro ãtykyry wino. Zupuhpyry pona senohne tyriko. ");
INSERT INTO apyNT_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Mame kaneru iahkako emero apoto apõ po onekaroryme, tõsẽme. Moro typoxine exĩko ya mana, yzamaro mana. ");
INSERT INTO apyNT_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","— Mame kaneru zakorõ apoiko. Zupuhpyry pona Arão tõ emary tyripoko imũkuru tõ emary maro. ");
INSERT INTO apyNT_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Mokyro kaneru etapako imunuru zokonaka tyritohme Arão panary etyhpyry pona apotunuru wino, imũkuru tõ panary pokona roropa apotunuru wino. Imunuru tyriko roropa emarykõ omazũpona apotunuru wino, ipupurukõ pupuzũ pokona apotunuru wino, enara. Munu akoĩpyry isapararahmako apoto apõ ehpiry 4mãkõ pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Munu apoiko zokonaka apoto apõ poe, oriu ahpatoh maro, Arão pona isapararahmatohme, zupõ pona te, imũkuru tõ pona, zupõkõ pona, enara. Morara ahtao Arão tõ imũkuru tõ maro zupõkõ maro tokarosẽme exĩko mã toto ya, ypoetoryme te, ykyryryme roropa ehtohme, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Sero kaneru onekaroryme mana oturuketõ tymenekase ahtao ymaro oturuketõme toto ehtohme. Kaneru kasery apoiko: arokyry kasery te, zuahxirirĩ poko exikety te, erery zokonaka kurano te, epyasyhny asakoro ikasery maro te, ipety maro apotunuru wino. ");
INSERT INTO apyNT_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","— Mame ruto wyi ẽ ae iporutatoh pyra exikety risemy, onekarohpyry ya, wyi apoiko osehta: toiro wyi oriu maro exikety te, imepỹ oriu maro pyra te, toiro wyi pipahmano, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Morohne tyriko Arão emahpokoxi, imũkuru tõ emahpokoxi roropa. Mame morohne anỹpoko eya xine jẽpataka, tynekarorykõme ya. ");
INSERT INTO apyNT_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Mame moro wyi apoiko toto emary poe jahkatohme apoto apõ po onekarorykõme ya, tonahsẽme. Typoxine moro ehtoh yzamaro mana. ");
INSERT INTO apyNT_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Kaneru puropuru apoiko apiakatohme onekaroryme kurã ya. Moro okyno pũ õtykõme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","— Ymaro oturuketõ menekaryhtao ypoetoryme, kaneru puropuru, ipety roropa apiakako onekarory kurãme ya, ekarotohme oturuketõ zohme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Izyraeu tõ tynekarory tõ ekaroryhtao osepeme ehtohme morara tyrĩko mã toto jumãme. Okyno puropuru ipety maro oturuketõ zohme exĩko. Sero nase ahno nekarohpyry ya. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","— Toorihse oturukety Arão ahtao zuponỹpyry tokarosẽme exĩko imũkuhpyry tomo a. Moro upo amurũko mã toto tymenekase toto ahtao ymaro oturuketyme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Arão mũkuru tumy myakãme toehse ahtao ymaro oturuketyme omõnõko mana Tapyi taka, ymaro oturutoh taka erohtohme Jesary Kurã tao. Moro upo amurũko 7me ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","— Moro kaneru pũ totapase exikety, Arão tõ menekary poko ymaro oturuketõme, moro tõsẽ ahnoko osa kurã tao. ");
INSERT INTO apyNT_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Mame Tapyi ymaro oturutoh omõtoh tao moro tõsẽ õnõko mã toto wyi maro, ruto ao aexihpyry. ");
INSERT INTO apyNT_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Oturuketõme tymenekase toto ahtao, tynekarorykõ õnõko mã toto, tyyrypyrykõ korokapotohme moro tokarose exiryke. Oturuketõ rokẽ tõnõko mã toto tokarose Ritonõpo a exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Morara exiryke morohne akoĩpyry enahpyra aexihpyry moro ẽmepyry ae ro, tyahkasẽme exĩko mana. Yrokokoro onenahpyra ehtoko tokarose Ritonõpo a exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","— Jomihpyry ae ro 7me ẽmepyry aropoko oseahmary poko Arão menekary poko imũkuru tõ maro ymaro oturuketõme toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kokoro rokẽ pui orutua wãtara ro exikety etapako onekarorykõme oorypyrykõ korokapotohme. Onekarorykõ apitorymã ke apoto apõ kurãkãko roropa matose. Oriu pitiko ikuãko ipona ykyryry kurãme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Morara tyritoko kokoro rokene 7me ẽmepyry ae. Mame moro apoto apõ tokarosẽme exĩko ykyryryme ipunaka. Mame imepyny a tytorohmase ahtao, tyyryhmasẽme exĩko mana yjamitunuru a ykyryryme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","— Kokoro rokẽ jũme ynara tyrĩko matose: kaneru asakoro zahkãko matose apoto apõ po, toiro jeimamyry nae exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Toiro kaneru pakeimo jahkãko matose te, toiro kokonie pukuro. ");
INSERT INTO apyNT_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kaneru apitorymã maro tiriiku tapose exikety enehko toiro kirume, otoxie oriu maro toiro riturume te, epona uwa eukuru jehnahpyry tyriko toiro riturume onekaroryme ya. ");
INSERT INTO apyNT_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Kokonie pukuro zakorõ kaneru ijahkako tiriiku maro, oriu maro uwa eukuru jehnahpyry maro pakeimo onekarohpyry saaro. Moro onekarohpyry tonahsẽme sã ya. Ritonõpome ase. Moro typoxine ehtoh yzamaro mana. ");
INSERT INTO apyNT_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Moro onekarorykõ zahkãko matose jũme jẽpataka Tapyi omõtoh tao, ymaro Oturutoh tao. Moroto oseporỹko ase ypoetory tõ maro, amaro xine oturũko ase. ");
INSERT INTO apyNT_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Moroto Izyraeu tõ maro oseporỹko ase. Jezuru ke sero jesary rĩko ase osa kurãme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Sero Tapyi rĩko ase Jesaryme Kurano, apoto apõ roropa ykyryry kurãme. Arão tõ menekãko ase imũkuru tõ maro ypoetoryme toto ehtohme erohtohme ymaro oturuketõme. ");
INSERT INTO apyNT_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Osesarĩko ase ypoetory tõ Izyraeu tõ rãnao. Toto Ritonõpome exĩko ase. ");
INSERT INTO apyNT_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Tuaro exĩko mã toto: Ywy, Ritonõpo, toto Esẽme ase. Ya toto tonehse Ejitu poe toto maro jehtohme. Ywy ase Ritonõpo, Izyraeu tõ Esemy. ");
INSERT INTO apyNT_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Mame ynara tykase Ritonõpo Moeze a: — Apoto apõ tyriko roropa, wewe akaxia risẽme epona ixtaratu jahkatohme. ");
INSERT INTO apyNT_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Tahramehme sã tyriko, 45 sẽtimeturume mosa exiry te, 45 sẽtimeturume ipuroroje exiry te, 90 sẽtimeturume kae exiry. Ipotyry tõ 4mãkõ pokona iretyry tyriko aosexihtohme apoto apõ pokona, toiro kyryryme toto ehtohme apoto apõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Apurutoh apuhnõko matose uuru kurã ke te, iratozo 4mãkõ maro te, iretyry tõ maro, enara. Apoto apõ zomye uuru risẽ tyriko ehpiryme. ");
INSERT INTO apyNT_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Parihmã asakoro tyriko uuru risẽme, ehpiry zopino, toiro seino, toiro moino. Mara tõ tyriko parihmã tõ aka, epurume ehtohme arotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Moro epuru tõ tyriko wewe akaxia ke tapuhse uuru ke. ");
INSERT INTO apyNT_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Moro apoto apõ tyriko kamisa ẽpataka, Osa Kurã Kuhse ẽpataka, kaxo Ritonõpo omihpyry ẽ etonie. Moroto oseporỹko ywy amaro. ");
INSERT INTO apyNT_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Pakeimo, nãparina tõ poko Arão ahtao, ixtaratu typoxine exikety jahkapoko eya. ");
INSERT INTO apyNT_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Mame kokonie pukuro, nãparina tõ tukase ropa ahtao eya, morararo tyripoko ropa eya. Moro onekarory jahkary poko exikehpyra ehtoko jũme, apakõ pakomotyã pona ro. ");
INSERT INTO apyNT_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Sero apoto apõ po, imepỹ ixtaratu onyahkara ehtoko te, okyno tõkehko te, tiriiku tõkehko te, eukuru jehnahpyry roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Jeimamyry ae sero apoto apõ kurãkãko Arão mana, tynekarory ke. Okyno munuru tyrĩko ynororo apoto apõ retyry 4mãkõ pokona, totapase ahtao ahno rypyry korokapotohme. Morara kakehpyra ehtoko jeimamyry ae rokene. Sero apoto apõ nuriame onyripyra ehtoko, tymenekase exiryke ykyryry kurãme. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","— Izyraeu tõ kukuruhtao tuhke toto ehtoh waro ehtohme, tineru pitiko epehmapõko mase eya xine, emero porehme, isene toexirykõke, etuarimara toto ehtohme toto kukuruhtao. ");
INSERT INTO apyNT_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Oxisã epehmãko matose emero porehme, tukuhse awahtao xine, onekarorykõme ya, Oesẽkomo a. ");
INSERT INTO apyNT_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","20me jeimamyry exiketõ tukuhse ahtao epehmãko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Isene oehtohkõ epehpyry epehmaryhtao oya xine, tytineruke exiketõ onymotyẽkara mã toto te, tymõkomokẽkara roropa zae epehmãko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Moro tineru apoĩko mase Izyraeu tõ nekarory tõ, akorehmatohme Ytapyĩ, Ymaro oturutoh kurãkary poko. Moro epehpyry Izyraeu tomo a isene toehtohkõ epehpyryme ya. Wenikehpyra ase toto ewomatohkõme. ");
INSERT INTO apyNT_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","— Metau risẽ osemahtoh tyriko, tuna ẽme, apõ po metau risẽ po. Tapyi maro apoto apõ maro irãnaka moro osemahtoh tyriko. Tuna tyriko zaka. ");
INSERT INTO apyNT_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Moro tuna ke Arão tõ osemahnõko mã toto, imũkuru tõ maro te, tupupurukõ kurikãko roropa mã toto, ");
INSERT INTO apyNT_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","omõtohto Tapyi taka te, apoto apõ pona toto ytoryhtao roropa tonahsẽ jahkatohme tynekarorykõme. Morara ahtao orihpyra mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Osemahnõko mã toto te, tupupurukõ kurikãko roropa mã toto aorikyrykõino. Sero ynyripohpyry eya xine omipona tyripoko jũme eya xine, ipakomotyamo a, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","25","— Ixtaratu tõ imenekako typoxine exikety tomo, oriu kurã ritohme ahpatohme, ixtaratu rinanõ nyriry samo: 3,5 riturume azeite maro ynara tyriko: mira eukuru 6 kirume te, kanera 3 kirume te, axikaru typoxinemy 3 kirume te, kasia 6 kirume, enara. (Emero tukuhse tuisa ikuhtoh ke.) ");
INSERT INTO apyNT_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Sero ahpatoh ke Tapyi Kurã, ymaro Oturutoh ahpako te, kaxo jomihpyry eny roropa te, ");
INSERT INTO apyNT_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","meza imõkomory emero te, ezuru apõ imõkomory maro te, apoto apony ixtaratu zahkatopo te, ");
INSERT INTO apyNT_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","apoto apõ, okyno zahkatopo, imõkomory maro emero te, osemahtopo apõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Morara morohne apiakãko matose ykyryryme kurano. Mame ipoko toehse imepỹ ahtao tyyryhmasẽme exĩko mana yjamitunuru ke morohne kurãme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Mame Arão ahpako imũkuru tõ maro. Toto imenekako jomipona toto ehtohme ymaro oturuketõme. ");
INSERT INTO apyNT_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ynara kaxiko Izyraeu tomo a: — Sero ahpatoh, azeite risẽ tyrĩko matose jũme, ykyryry tõ rokẽ ahpatohme, ymaro oturutoh poko, imõkomory tõkehko, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ike imehnõ anahpara ehtoko, zoko pona onyripyra ehtoko ymaro oturuketyme pyra ahtao. Sero ahpatoh panõ onyripyra ehtoko. Ykyryry kurã sero. Naeroro tomeseke ehtoko ipoko. ");
INSERT INTO apyNT_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Imehnomo a sero ahpatoh panõ riryhtao te, imehnõ ahparyhtao ipanõ ke ymaro oturuketyme pyra ahtao, taroposẽme exĩko mana ypoetory tõ tae. ");
INSERT INTO apyNT_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","35","Mame ynara tykase Ritonõpo Moeze a: — Ixtaratu zahkatoh tyriko ykyryryme kurano tyriry waro exiketõ nyriry samo. Ynara zoximako oxisamo: pẽjoĩ te, onika te, azawa opime exikety te, ixtaratu kurano. Sautu tyriko roropa imaro kure rokẽ ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","— Ako aka tyriko zokonaka, pisarara ehtohme. Moromeĩpo moro arota Tapyi taka, ymaro Oturutoh taka. Moro tao oseporỹko ywy amaro. Moroto moro ixtaratu tyriko kaxo, jomihpyry ẽ ẽpataka. Tomeseke ehtoko moro ixtaratu poko ykyryry kurãme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ixtaratu riryhtao oya xine okyryrykõme, ykyryry panõ onyripyra ehtoko. Sero ixtaratu ykyryry kurãme mana, jeahmatohme rokẽ mana. ");
INSERT INTO apyNT_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ykyryry panõ riryhtao imehnomo a tykyryryme ehtohme, mokyro taroposẽme exĩko ypoetory tõ htae. ");
INSERT INTO apyNT_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","— Pezareu tymenekase ya, Uri mũkuru, Huru pary Juta tõ ekyry. ");
INSERT INTO apyNT_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Eya Juzenu ekaroase akorehmaneme. Tuaro tyripose ya, emese kure aehtohme, ynyripotyã riry waro aehtohme tomepore ehtohme, ");
INSERT INTO apyNT_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","emepory riry waro ehtohme te, uuru poko te, parata te, metau riry waro ehtohme ");
INSERT INTO apyNT_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","joia tõ kotyry poko te, tyriry poko roropa te, wewe riry poko te, emero aatesenatu riry poko roropa zuaro ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Aoriape tymenekase ya roropa, Aisamake mũkuru Tã tõ ekyryme mokyro akorehmaneme ehtohme. Imehnõ roropa tuaro tyripose ya emese kure toto ehtohme ynyripotyã riry waro toto ehtohme: ");
INSERT INTO apyNT_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Tapyi, ymaro oturutohme te, kaxo jomihpyry eny te, kaxo apuru maro, tapyi mõkomory porehme; ");
INSERT INTO apyNT_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","meza, imõkomory maro te, ezuru apony, imõkomory maro te, ixtaratu zahkatoh apony te, ");
INSERT INTO apyNT_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","apoto apõ roropa, okyno zahkatopo, imõkomory maro te, paxiha konõto tuna ẽme, apõ maro te, ");
INSERT INTO apyNT_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","upo kurano, ymaro oturuketõ zupõme, Arão tõ zupony imũkuru tõ maro amurutohme aomomyryhtao ymaro oturutoh taka erohtohme te, ");
INSERT INTO apyNT_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","oriu, ipopatohme te, ixtaratu typoxine exikety, Jesary Kurã kyryry. Morohne emero tyripoko eya xine ynyripohpyry ae ro oya. ");
INSERT INTO apyNT_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Mame ynara tykase Ritonõpo Moeze a, ");
INSERT INTO apyNT_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Izyraeu tõ zurutohme: — Kure rokẽ ẽmepyry 7mã tyritoko, ynymenekahpyry oserematohme. Moro enetupuhtohme exĩko mana jũme, ywy Ritonõpo opynanohnekõme ase ypoetoryme oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Naeroro kure rokẽ oserematoh tyritoko, ypoko oehtohkõme moro ẽmepyry ae. Kure rokẽ oserematoh onyripyra ahno ahtao, aerokuruhtao, taorihmaposẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","6me ẽmepyry erohnõko matose, yrome 7mã po oserematohme nase, ypoko oehtohkõme. Morara exiryke toerohtoh poko exikety moro ae taorihmaposẽme exĩko. ");
INSERT INTO apyNT_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Izyraeu tomo a oserematoh ikurãkapoko enetupuhtohme ypoetoryme toto ehtoh poko, jũme. ");
INSERT INTO apyNT_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Jũme enetupuhtohme moro exĩko ya, ypoetory tõ Izyraeu tomo a, enara. Ynara exiryke senohne emero yrine 6me ẽmepyry ae, kapu, nono roropa. Mame 7mã po toerohkehse exine oserematohme. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Morarame tõturukehse Ritonõpo ahtao Moeze maro ypy Xinai po, topu tõ asakoro tokarose eya, tynymerohpyry inyripotyamo. ");
INSERT INTO apyNT_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mame okynã Moeze ahtao ypy po, typenekehse imoihmãkõ kynexine eraximary poko. Tõximõse toto Arão maro, oturutohme. Ynara tykase toto eya: — Otoko keh Moeze nae? Otarahxo tã nexiase? Eatãpyrahxo pãna nexiase. Eya tonehse kymarokõ Ejitu poe. Naeroro ritõ tyriko kuesemazupurukõme ytotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ynara tykase Arão eya xine: — Panasere tõ uuru risẽ toutoko opyxiã kyryry te, opoenõ kyryry roropa enehtohme ya. ");
INSERT INTO apyNT_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Naeroro typanarykõ poe panasere tõ uuru risẽ touse eya xine, ekarotohme Arão a. ");
INSERT INTO apyNT_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Mame morohne panasere tõ tyrise Arão a apoto pona. Tutunatanohpose ahtao, pui mũkuru sã tyrise eya. Mame ynara tykase toto: — Izyraeu tomo, mose ro kuesẽkõ myakãme, eya tonehse kymarokõ Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Mame apoto apõ tyrise Arão a tynyrihpyry ẽpataka, pui mũkuru uuru risẽ ẽpataka. Ynara tykase ynororo imoihmãkomo a: — Kokoro otuhtoh konõto rĩko sytatose Ritonõpo Kuesẽkõ eahmatohme. ");
INSERT INTO apyNT_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Yrokokoro pakeimo okyno tõ tonehse eya xine jahkatohme tynekarorykõme te, tõsẽme roropa tõtuhtohkõme osepeme toehtohkõme. Imeĩpo typorohse toto otuhtohme, eukuru ẽtohme roropa. Mame towõse ropa toto tuatuatohkõme. ");
INSERT INTO apyNT_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Mame ynara tykase Ritonõpo Moeze a: — Oyhtoko axiny, opoetory tõ, onenehtyã Ejitu poe nerypyhtõ toto, jurumekã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Toeramase ropa mã toto jesemary poe, ynyripohpyry omipona pyra toehse mã toto. Pui mũkuru panõ tyrise eya xine, uuru risemy, eahmatohme, ẽpataka tynekarorykõ zahkatohme. Tyrihpõkõme pui panõ uuru risẽ ekarõko mã toto, typynanohnekõme, Ejitu poe tonepyhpõkõme. ");
INSERT INTO apyNT_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Moxiã waro ase. Putupyra rokẽ mã toto ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Seromaroro ukuremary onukuhpyra exiko. Toto zehno jexiryke toto wãnohnõko ase, toto enahkãko ase. Imeĩpo oemãkapõko ase imoihme omũkuru tõ maro, apakomotyã maro. ");
INSERT INTO apyNT_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Yrome tõturuse Moeze Ritonõpo a. Ynara tykase ynororo: — Ritonõpo, yna Esemy, oty katohme opoetory tõ zehno mexino ajamitunuru ke toto enehxĩpo Ejitu poe? ");
INSERT INTO apyNT_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Oty katoh ynara kamexipõko mase Ejitu põkomo a: “Typoetory tõ tarose Ritonõpo a yna wino, Ejitu poe, toto etapatohme ypy tõ po, toto enahkatohme ipunaka?” Moro sã pyra exiko, toto zehno pyra exiko. Opoetory tõ onenahkara exiko. ");
INSERT INTO apyNT_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Wenikehpyra exiko opoetory tõ poko, Aparão, Izake, Jako, enara. Wenikehpyra exiko õmihpyry poko eya xine: “Apakomotyã emãnõko mã toto tuhke toto ehtohme xirikuato samo kapu poko.” Wenikehpyra roropa exiko õmihpyry poko: “Sero nono ekarõko ase apakomotyamo a jũme toto esaryme ehtohme.” ");
INSERT INTO apyNT_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Naeroro, “Teh,” tykase rokẽ Ritonõpo. Izyraeu tõ onenahkapopyra tokurehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mame ypy poe tyhtose Moeze topu tõ asakoro emahpo, Ritonõpo nymerohpyry ipokona. Inyripotyã tymerose topu tõ pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ritonõpo nyrityã moro topu tõ kynexine. Tynyripotyã tymerose eya roropa ipokona. ");
INSERT INTO apyNT_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Mame imoihmãkõ kohtary etaryke tyya ynara tykase Jozue Moeze a: — Otara panaikatõ etãko ah? Otarame osetapãko mã toto Izyraeu tõ esao. ");
INSERT INTO apyNT_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ynara tykase Moeze: — Moro panaikatõ imehnõ poremãkatopõpyry sã pyra mana te, typoremãse exiketõ kui kary sã pyra roropa mana. Eremiatoh sã etãko ase. ");
INSERT INTO apyNT_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mame ameke pyra toehse Moeze tõ ahtao Izyraeu tõ esaka pui mũkuru panõ, uuru risẽ, tonese eya, ahno roropa wãko. Tyekĩtapãse ynororo. Moroto ypy myhto topu tõ pipahmã asakoro ipuimatyã tomase eya nono pona. Tãtakuhmose kehko. ");
INSERT INTO apyNT_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Mame moro pui mũkuru panõ, uuru risẽ tapoise eya, toto nyrihpyry. Tyahkase eya apoto ke. Mame tyhmose eya akumurume pisarara ehtohme. Mame tuna kuaka tomase eya. Moromeĩpo moro tuna ke Izyraeu tõ tauhpase eya. ");
INSERT INTO apyNT_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mame ynara tykase Moeze Arão a: — Otara tykase toto oya, toto arotohme oya tyyrypyrykõ xihpyry poko toto ehtohme? ");
INSERT INTO apyNT_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ynara tykase Arão: — Yzehno pyra exiko. Tuaro mase. Tupime pyra moxiamo a tyyrypyrykõ poko toto exiry. ");
INSERT INTO apyNT_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ynara tykase toto ya: “Otara toehse mokyro Moeze, kuenepyhpõkomo Ejitu poe? Zuaro pyra sytatose. Naeroro ritõ tyriko kutuisarykõme.” ");
INSERT INTO apyNT_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Mame ikyryrykõ uuru risẽ tonehpose ya ekarotohme ya. Moro uuru tomase ya apoto htaka. Mame tutũtase mokyro pui mũkuru panõme. ");
INSERT INTO apyNT_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Eraseme Arão ahtao imoihmãkõ tynomose eya ajoajohpe toehtohkõ poko toto ehtohme, epetõkara a toto eunohpotohme. Morara tonese Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Morara exiryke toytose ynororo Izyraeu tõ esary omõtoh taka. Ynara tykase ynororo opore: — Onokãkõ Ritonõpo Kuesẽkõ maro nae? Osehtoko xiaro imaro se awahtao xine. Naeroro Rewi tõ ekyry tõ emero tõximõse toh kynexine Moeze ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ynara tykase ynororo: — Ritonõpo Izyraeu tõ Esẽ ynara tyripõko oya xine: Atapemãkõ apoitoko. Ytotoko Izyraeu tõ rãnakuroko ehpiry poe etyhpyry pona, oekyry tõ etapase, oepe tõ maro, katonõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Naeroro Rewi tõ toytose Moeze omi poe ahno etapase. 3 miumãkõ totapase eya xine, orutua komo. ");
INSERT INTO apyNT_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ynara tykase Moeze Rewi tomo a: — Seroae omũkuru tõ totapase oya xine, ãkorõ tõ maro. Morara tyrise oya xine exiryke, tapiakase matose Ritonõpo Kuesẽkõ maro oerohtohkõme. Aomipona oexirykõke kure rokẽ oritorỹko Ritonõpo mana, seroae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Yrokokoro ynara tykase Moeze imoihmãkomo a: — Oorypyrykõ xihpyry poko mexiatose Ritonõpo neneryme. Mãpyra seromaroro onuhnõko ropa ase ypy pona oturuse Ritonõpo maro. Otarame jomiry etaryhtao eya oorypyrykõ korokãko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mame toytose ropa Moeze Ritonõpo ẽpataka ropa, ynara tykase ynororo: — Moxiã tyyrypyhpyke toehse ipunaka. Okyno panõ uuru risẽ tyrise eya xine, tyneahmarykõme. ");
INSERT INTO apyNT_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ajohpãme sã iirypyrykõ ikorokako ropa! Mãpyra ikorokary se pyra awahtao, jesety imikako ropa apapẽ poe. Moroto opoetory tõ esetykõ tymerose oya. ");
INSERT INTO apyNT_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mame ynara tykase Ritonõpo Moeze a: — Mokaro esetykõ mikãko ropa ase, tyyrypyrykõ poko aexityamo, jomipona pyra toehse aexirykõke. ");
INSERT INTO apyNT_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Seromaroro mokaro arota ynaropohpyry pona. Wenikehpyra exiko ynenyokyhpyry oesemarykõ enepõko oya xine mana. Yrome okynã pyra mokaro wãnohnõko ase toto rypyry epehpyryme. ");
INSERT INTO apyNT_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Morara exiryke tyrohsẽ ke Izyraeu tõ tuãnohse Ritonõpo a, pui mũkuru panõ, uuru risẽ tyripose Arão a eya xine exiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ynara tykase Ritonõpo Moeze a: — Ytotoko taroino, omoro, opoetory tõ maro, onenepyhpyry tõ Ejitu poe. Ytotoko ononorykõ pona. Moro nono poko jomihpyry ekarone Aparão a te, Izake a, Jako a, imũkuru tõ maro, ipakomotyã maro. “Sero nono ekarõko ase oya xine,” akene. ");
INSERT INTO apyNT_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ynenyokyry aropõko ase amaro xine oesemarykõ enepotohme oya xine te, kananeu tõ aropotohme owinoino xine te, amoreu tomo te, heteu tomo te, perizeu tomo te, heweu tomo te, jepuseu tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ytõko matose nono kurã pona, otyro zamaro exikety pona. Yrome amaro xine ywy ytopyra ase awaro xine jexiryke, putupyra sã rokẽ oexirykõke, oenahkarykõ ino ya osema tao oytorykohtao. ");
INSERT INTO apyNT_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Mame Izyraeu tõ turuse ahtao Moeze a Ritonõpo omiry poko tyxitapitose toto. Tynamururukõ anamurupyra toehse toto emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ynara tykase Ritonõpo exiryke Moeze a, toto zurutohme: — Putupyra exiketõme matose. Amaro xine jahtao, axĩtao rokẽ jahtao ro oenahkarykomo ipunaka. Naeroro okyryry tõ anamururukõ toutoko; osenetupuhxi otara oritorỹko ha? ");
INSERT INTO apyNT_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Naeroro moromeĩpo Xinai poe toytose Izyraeu tõ ahtao tynamururukõ anamurupyra toehse toto. ");
INSERT INTO apyNT_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Morarame Izyraeu tõ totypohse ahtao tõsesaritohkõme, Tapyi Kurã, Ritonõpo maro oturutoh tyrise Moeze a ameke pixo imoihmãkõ wino. Moro Tapyi esety Ritonõpo maro Oturutohme kynexine. Mame ekaropory se toto ahtao Ritonõpo a moro Tapyi taka toytose toto. ");
INSERT INTO apyNT_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Morarame toytose Moeze ahtao Tapyi Kurã taka, Ritonõpo maro Oturutoh taka, ahno emero toraximase tosarykõ omõtoh tao. Moeze enẽko toh kynexine, aomomyryhtao. ");
INSERT INTO apyNT_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Tomõse Moeze ahtao akurũ tyhtose xikihme exikety samo. Totypohse akurũ Tapyi omõtoh taka. Mame akurũ poe tõturuse Ritonõpo Moeze maro. ");
INSERT INTO apyNT_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Moro akurũ eneryke Izyraeu tomo a Tapyi omõtoh tao tosekumuru po typorohse toto emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Moroto osẽpataka tõturuse Ritonõpo Moeze maro ahno otururu sã tope maro. Moromeĩpo toytose ropa Moeze imoihmãkõ esaka ropa. Yrome Jozue, Num mũkuru, Moeze akorehmane nuasemã, tehme rokẽ kynexine moro Tapyi tao. ");
INSERT INTO apyNT_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ynara tykase Moeze Ritonõpo a: — Zae turuse ywy oya moxiã imoihmãkõ arotohme onekarohpyry pona. Yrome onoky ymaro ytõko nae? Mokyro onekaropyra ro mase ya. Juarohxo oehtoh mekaroase. Azamaro jehtoh roropa ekarõko mase. ");
INSERT INTO apyNT_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Morara awahtao õsenetupuhtoh poko kuruko zuaro jehtohme õmipona jehtohme, azamaro ro jehtohme. Wenikehpyra exiko, moxiã tymenekase oya opoetoryme toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ynara tykase Ritonõpo eya: — Amaro ytõko ase. Orẽpyra orĩko ase oepetõkara poremãkapotohme oya. ");
INSERT INTO apyNT_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mame ynara tykase Moeze: — Moxiã, opoetory tõ maro ytopyra awahtao yna anaropopyra exiko taroino. ");
INSERT INTO apyNT_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Otãto yna pyno oehtoh poko, azamaro yna ehtoh poko roropa waro exĩko imehnõ nae yna maro pyra awahtao? Yna maro oexiry eneryke tyya xine imehnõ ahno sã pyra yna ehtoh enetupuhnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ynara tykase Ritonõpo Moeze a: — Onyripohpyry ya tyrĩko ase awaro jexiryke, yzamaro roropa oexiryke. ");
INSERT INTO apyNT_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mame tokaropose ropa Moeze a: — Ajohpãme sã oẽmyty ezuru imehxo exikety enexi, tykase. ");
INSERT INTO apyNT_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ynara tykase Ritonõpo eya: — Ynara tyrĩko ase. Ytõko ase oẽpataka jezuru imehxo exikety maro. Jesety kurã ekarõko roropa ase onetaryme. Ywy ase Ritonõpo. Imehnõ pyno ase ise jahtao. Imehnõ onuãnohpyra ase ipynanopyrykõ se jahtao. ");
INSERT INTO apyNT_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ynara tykase roropa: — Jẽmyty onenepopyra ase oya, ynara exiryke, jẽmyty eneryhtao imepyny a isene ehsaromepyra exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yrome taro osa nae upũto. Moroto exiko topu konõto po. ");
INSERT INTO apyNT_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Jezuru ytoryhtao oẽpataka oramãka oripõko ase topu ao. Jemary rĩko ase opona jenepyra oehtohme jytoryhtao opũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Moromeĩpo jemary anỹnõko ropa ase ỹpary enetohme oya. Yrome jẽmyty onenepyra ekurehnõko mase. ");
INSERT INTO apyNT_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Mame ynara tykase Ritonõpo Moeze a: — Topu tõ asakoro pipahmãkõ axikako, onyhmopotyã samo. Mame omi merõko ase ipokona, ynymerohpyry saaro apitoryme. ");
INSERT INTO apyNT_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kokoro pakeimo atakimako onuhtohme ypy Xinai pona oseporyse ymaro moroto ypy emory po. ");
INSERT INTO apyNT_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Imehnõ anaropyra exiko amaro. Imehnõ emero moro ypy poe aropoko. Kaneru tomo, poti tomo, pui tõ roropa ameke rokẽ aropoko toto ypy poe. ");
INSERT INTO apyNT_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mame topu tõ pipahmã taxikase Moeze a apitorymãkõ samo. Yrokokoro Ritonõpo omihpyry ae ro towõse ynororo pakeimo. Tõnuhse ypy Xinai pona. Moro topu tõ pipahmãkõ tarose tymaro. ");
INSERT INTO apyNT_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Akuru ao tyhtose Ritonõpo Moeze maro toehtohme. Tosety tokarose eya. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mame toytose Ritonõpo Moeze ẽpataka. Opore ynara tykase ynororo: — Ywy ase Ritonõpo, jũme Exikety. Opyno xine exiketyme ase. Etuarimaketõ pynanohnõko ase. Axĩ pyra awãnohtorỹko ase. Kure rokẽ ehtoh enehpõko ase oya xine, anamonohpyra ase opyno xine jexiryke ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Jomihpyry omipona ase miu motye zumakahpõkomo a, azahkuru oehtohkõ, oorypyrykõ korokãko roropa ase. Yrome ajoajohpe exiketõ wãnohnõko ase, ipoenõ roropa, ipakõ roropa te, ipoenõ pakõ roropa jũkõ rypyry emetakame. ");
INSERT INTO apyNT_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Tosekumuru po typorohse Moeze, tõmyty po nono pokoxi Ritonõpo eahmatohme. ");
INSERT INTO apyNT_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ynara tykase ynororo: — Ritonõpo, ajohpe pyra azamaro jahtao, ajohpãme sã yna maro ytoko. Moxiã mã putupyra exiketõme mã toto. Yrome yna rypyry ikorokako, popyra yna ehtopo. Opoetoryme yna tyriko rahkene. ");
INSERT INTO apyNT_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ynara tykase Ritonõpo Moeze a: — Seromaroro jomiry ekarõko ase oya xine oekyry tõ maro. Toto ẽpataka yjamitunuru enepõko ase. Ynyriry panõ onenepitopyra sero nono põkõ porehme imehnõ nonory po. Ahno morotõkõ emero yjamitunuru enẽko mã toto. Ywy, Ritonõpo ãkorehmatohkõ eneryke tyya xine osenuruhkãko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Jomihpyry omipona ehtoko, ynyripohpyry oya xine seroae. Sero nono pona oytorykohtao, owino xine imehnõ aropõko ase: amoreu tomo te, kananeu tomo te, heteu tomo te, perizeu tomo te, heweu tomo te, jepuseu tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Osepeme pyra ehtoko morotõkõ maro. Ataomihpykara ehtoko eya xine osewomatohme, apoitoh sã exĩko oya xine morara riryhtao oya xine, oorihmapotohkõme. ");
INSERT INTO apyNT_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mãpyra toto nyrihpyry tõ, apoto apõ tõ ikararahtoko, xikihme exiketõ Paau kyryry te, wewe axikatyã tyneponãmarykõ Asera roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","— Imehnõ neponãmarykõ oneahmara ehtoko. Ywy Ritonõpo osesehpãko ase Zumoxikatome. Jeahmapory se rokẽ ase oya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Õmirykõ onekaropyra ehtoko morotõkomo a atakorehmatohme ononorykõ pona oytorykohtao. Tyneponãmarykõ eahmaryhtao eya xine tynekarorykõ zahkãko mã toto. Mame oeahmatorỹko mã toto oximõtohme tymaro xine. Mame tukuhsẽme exĩko matose tõsẽ õtohme, toto nekarohpyry tyneponãmarykomo a. ");
INSERT INTO apyNT_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Mame omũkuru tõ pytãko mã toto otarame katonõ nohpory tõ maro. Toto pokoino jomihpyry omipona pyra exĩko matose, jurumekãko imehnõ neponãmary tõ eahmatohme oya xine imaro xine. ");
INSERT INTO apyNT_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","— Metau risẽ oneponãmarykõ onyripyra ehtoko, oneahmara ehtoko roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","— Atãkyematoko Oseahmatoh Wyi poko Iporutatoh maro pyra. Jomihpyry ae ro wyi ohnõko matose iporutatoh maro pyra exikety 7me ẽmehtoh pona, nuno apipe po, moro nuno po toesyryhmase oexirykõke Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","— Omũkurukõ apitorymãkõ umũkurume mã toto, oeky tõ mũkuru apitoryme aenurutyã roropa jekyme mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Yrome jumẽta mũkuru apitorymã epekahnõko matose kaneru mũkuru ke onekaroryme imyakãme. Jumẽtu mũkuru onepekahpyra awahtao xine aorihmapõko matose ipỹ tohkatoh ke. Omũkuru tõ emero apitoryme aenurutyã epekahtoko. — Jẽpataka oehpyra ehtoko tokarosẽ maro pyra, onekaroryme ya. ");
INSERT INTO apyNT_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","— 6me ẽmepyry ae erohtoko emero poko. Yrome 7mã po erohpyra ehtoko, arykatoh toehse ahtao ro te, otyro apoitoh toehse ahtao roropa. ");
INSERT INTO apyNT_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","— Oseahmatoko Otyro Apoitoh poko tiriiku apoipitoryhtao oya xine. Mame Oseahmatoko Tapyi Pisarara poko wewe epery apoiryhtao oya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","— Jeimamyry ae oseruao otuhtoh konõto rĩko matose, Izyraeu tõ porehme, jeahmatohme, Ritonõpo, Izyraeu tõ Esemy. ");
INSERT INTO apyNT_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Apatarykõ poe imehnõ ahno aropõko ase ouno xine toto ehtohme. Morara ahtao oesarykõ zumohxo exĩko. Mame imehnõ okuhpyra xine mã toto oporemãkapory poko ononorykõ apoitohme, ooepyrykohtao jeahmase moro oseahmatoh oseruao poko awahtao xine. ");
INSERT INTO apyNT_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","— Okyno etaparyhtao oya xine jahkatohme onekarorykõme ya, wyi iporutatoh risẽ maro onenehpyra ehtoko. Mokyro punu akoĩpyry onukurãkara ehtoko otuhtohme yrokokoro Oseahmatoh Epozakuroko ytotopõpyry poko ahtao. ");
INSERT INTO apyNT_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","— Jeimamyry ae rokẽ tiriiku tõ apoipitoryhtao oya xine apitorymã enehtoko ymaro oturutoh taka, Ritonõpo Oesẽkõme jexiryke. Kaneru mũkuru, poti roropa anahnopyra ehtoko jẽ suhsuru maro. ");
INSERT INTO apyNT_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ynara tykase Ritonõpo Moeze a: — Senohne jomihpyry imeroko, wenikehpyra oehtohkõme omipona oehtohkõme. Morara awahtao xine kure oritorỹko ase jomihpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moroto 40me ẽmepyry taropose Moeze a Ritonõpo maro, Izyraeu tõ Esemy, otuhpyra, tuna onẽpyra. Omi tymerose eya topu tõ pipahmã asakoro pokona. Tynyripohpyry 10me tymerose eya. ");
INSERT INTO apyNT_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mame tyhtose Moeze ahtao topu pipahmã asakoro tarose eya, Ritonõpo omihpyry. Ẽmyty saereh ãko kynexine Ritonõpo maro tõturuse exiryke, yrome zuaro pyra kynexine ynororo. ");
INSERT INTO apyNT_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Mame ẽmyty saerehkary eneryke tyya xine enaromỹke toehse Arão tomo, imoihmãkõ maro, ameke se rokẽ toehse toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Yrome toto tykohmase tyya Moeze a. Arão tõ toeporehkase ahtao Izyraeu tõ tamuximãkõ maro, tõturuse ynororo toto maro. ");
INSERT INTO apyNT_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Moromeĩpo Izyraeu tõ porehme tõximõse Moeze zomye. Turuse toto emero Ritonõpo nyripohpyry, inekarohpyry eya ypy Xinai po. ");
INSERT INTO apyNT_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mame toto maro tõturukehse Moeze ahtao kamisa ke tõmyty tapuruse eya. ");
INSERT INTO apyNT_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Mame toytose ropa Moeze ahtao Tapyi Kurã taka oturuse Ritonõpo maro moro kamisa touse ropa eya. Tutũtase ropa ynororo ahtao Izyraeu tõ turuse eya Ritonõpo nekarohpyry emero. ");
INSERT INTO apyNT_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ẽmyty tonese imoihmãkomo a, saereh ãko. Mame kamisa ke tõmyty tapuruse ropa eya toytotohto ropa Tapyi taka oturuse ropa Ritonõpo maro. ");
INSERT INTO apyNT_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mame Izyraeu tõ tykohmase Moeze a oximõtohme toto zurutohme. Ynara tykase ynororo: — Ynara tyripose Ritonõpo oya xine: ");
INSERT INTO apyNT_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","6me ẽmepyry nae matose erohtohme. Yrome ẽmepyry 7mã kure nase, emero rokẽ poko pyra ehtohme, Ritonõpo poko ehtohme. Ahno toerohse ahtao moro ẽmepyry ae tuãnohsẽme exĩko mana, totapasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ẽmepyry 7mã po, oserematoh po, apoto onyripyra ehtoko atapyĩkõ htao. ");
INSERT INTO apyNT_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ynara tykase Moeze Izyraeu tõ imoihmãkomo a: — Ynara tyripose Ritonõpo oya xine: ");
INSERT INTO apyNT_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Onekarorykõ enehtatoko Ritonõpo a. Uuru ekarory se awahtao xine te, parata te, metau te, ");
INSERT INTO apyNT_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","kaneru hpoty ezuezumano te, puupura te, tahpiremano te, mauru panõ topuru te, kamisa, poti hpoty risemy te, ");
INSERT INTO apyNT_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kaneru pihpyry tonohse tahpire ke, okyno pihpyry kurano te, wewe akaxia te, ");
INSERT INTO apyNT_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","oriu nãparina eukuru te, typoxine exiketõ tyritohme azeite maro ahpatohme te, jahkatohme typoxine ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Topu kurã onixi te, imehnõ topu kurã roropa tyritohme Ritonõpo maro oturuketõ zupõ poko te, oturuketõ tuisary puropuru poko exikety, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Orutua kõ emero, emese kure exiketõ enehpõko ase, erohtohme Ritonõpo nyripohpyry poko: ");
INSERT INTO apyNT_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Tapyi Kurã, amotoh tonõ maro (zao exikety te, jarao exikety, enara) te, apoitoh tonomo te, wewe risẽ xikihme exiketomo te, apõ tomo te, wewe kuroko exiketomo te, xikihme exiketõ tapõke exiketõ maro, ");
INSERT INTO apyNT_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","kaxo, Ritonõpo omihpyry eny, epuru tõ maro wewe risã te, apuru maro te, kamisa risemy Osa Kurã Kuhse apiakatohme, Osa Kurã apurume, ");
INSERT INTO apyNT_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","meza, epuru tõ maro, imõkomory maro te, wyi kehko ahno nekarohpyry Ritonõpo a, ");
INSERT INTO apyNT_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ezuru apony imõkomory maro te, nãparina tomo oriu maro te, ");
INSERT INTO apyNT_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","apoto apony, ixtaratu zahkatopo, epuru tõ maro te, oriu oturuketõ ahpatohme te, ixtaratu typoxine exikety te, kamisa Tapyi omõtohme te, ");
INSERT INTO apyNT_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","apoto apõ okyno tõ zahkatopo, apoto ẽ maro metau risemy te, epuru tõ maro, imõkomory maro te, tuna eny osemahtohme, apõ maro te, ");
INSERT INTO apyNT_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","kamisa, zara zomye apurume exikety te, xikihme exiketõ apõ tõ maro te, kamisa roropa zara pona omõtohme te, ");
INSERT INTO apyNT_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","inepuru tomo nono aka tyritohme tapyi eary myhtohme te, zara eary myhtohme roropa te, eary tõ roropa te, ");
INSERT INTO apyNT_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","upo roropa, Ritonõpo maro oturuketõ zupony, Arão zupõ kurano te, imũkuru tõ zupõ kurano, amurutohme omõtohme Ritonõpo Esary Kurã taka. ");
INSERT INTO apyNT_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Mame Izyraeu tõ toytose ropa tytapyĩ taka ropa, ");
INSERT INTO apyNT_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","tynekarorykõ enepyry se exiketõ toeramase ropa tynekarorykõ enehse Ritonõpo a, Tapyi Kurã Ritonõpo maro oturutoh ripotohme. Tonehse eya xine emero, Ritonõpo eahmatohme, upo kurã ritohme Ritonõpo maro oturuketõ zupõme. ");
INSERT INTO apyNT_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Tooehse orutua komo, nohpo tõ maro, pino tõ enehse te, panasere tomo te, omahtao tomo te, omekumy tomo, uuru risẽ tõkehko. Morohne tokarose eya xine Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Mauru panõ kurã tonehse eya xine, kaneru hpoty ezuezumano te, puupura te, tahpiremano te, kamisa poti hpoty risemy te, kaneru pihpyry tonohse tahpirẽ ke, onokyro pihpyry kurano, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Parata tonehse ekarory se exiketomo a, imehnõ a metau tonehse tynekarorykõme Ritonõpo a te, imehnomo a wewe akaxia tonehse emero rokẽ tyritohme. ");
INSERT INTO apyNT_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Tynyrityã tonehse nohpo tomo a, emese kure exiketomo a: mauru panõ kurano te, kaneru hpoty ezuezumano te, puupura te, tahpiremã, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Kamisa tyrise roropa eya xine poti hpoty risemy. ");
INSERT INTO apyNT_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Topu tõ kurã tonehse tamuximãkomo a: onixi te, imehnõ topu tõ kurã roropa, Ritonõpo maro oturuketõ tuisary zupõ ritohme. ");
INSERT INTO apyNT_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Typoxine exiketõ tonehse eya xine te, oriu roropa nãparina eukurume te, ahpatohme te, jahkatohme typoxine ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Tynekarory tõ tonehse Izyraeu tomo a porehme, ekarory se toexirykõke Ritonõpo a, Inyripohpyry Moeze a tyritohme. ");
INSERT INTO apyNT_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mame ynara tykase Moeze Izyraeu tomo a: — Pezareu, Uri mũkuru, Huru pary, Juta tõ ekyry tymenekase Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Tuzenu tokarose Ritonõpo a eya tuaro ehtohme, emese kure ehtohme roropa tyriry poko, zuaro ehtohme emero poko, ");
INSERT INTO apyNT_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","enekure ehtoh riry waro ehtohme te, uuru poko tyriry waro te, parata poko te, metau poko, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Topu tõ kurãkary waro, tyriry waro roropa apõ pona te, wewe roropa te, emero rokẽ tyriry waro ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Pezareu akorehmane Aoriape kynexine, Aisamake mũkuru, Tã ekyryme. Mokaro asakoro takorehmase Ritonõpo a imehnõ amorepaneme toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Emese kure tyrise toto Ritonõpo a enekure ehtoh riry poko te, uuru tõkehko poko erohtohme parata poko te, metau poko te, kamisa riry poko roropa mauru panõ kurã ke te, kaneru hpoty ke ezuezumano te, puupura te, tahpiremã te, imepỹ kamisa roropa, enara. Emese kure toh kynexine toerohtohkõ poko te, tonesã riry poko roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Pezareu tomo, Aoriape maro, imehnõ orutua kõ roropa emese kure tyrise Ritonõpo a. Tuaro tyrise roropa Ritonõpo a Tapyi Kurã ritohme eya xine. Mokaro emero tyripose Ritonõpo a zae tõmipona toto ehtohme tynyripohpyry ritohme eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mame Pezareu tõ tykohmase Moeze a, Aoriape maro, imehnõ orutua kõ maro, Ritonõpo nymenekatyã, emese kure exiketomo, toerokuru se exiketomo. Tyrohmanohpopitose toto Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Izyraeu tõ nekarotyã tokarose Moeze a eya xine Tapyi Kurã ritohme. Kokoro rokẽ ẽmepyry ae tynekarorykõ tonehse Izyraeu tomo a Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","5","Mame mokaro Tapyi Kurã poko erohketõ toytose toto oturuse Moeze maro. Ynara tykase toto eya: — Tynekarorykõ itamurume enehnõko mã toto. Imotyẽkãko roropa mã toto, Ritonõpo nyripohpyry motye. ");
INSERT INTO apyNT_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Naeroro toto nekarotyã Tapyi Kurã kyryryme onenehpopyra ropa toehse Moeze. Morara exiryke tonehkehse eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Toto nekarotyã ipune kynexine, Ritonõpo nyripohpyry pune, imotye roropa kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ritonõpo maro oturutoh Tapyi Kurã tyrise emese kurehxo exiketomo a. Apurume kamisa tyrise 10me mauru panõ kurã ke te, kaneru hpoty, ezuezumano te, puupura te, tahpiremã, enara. Morohne kamisa poko taporihkã tyxixĩse kynexine emeporyme. ");
INSERT INTO apyNT_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Moro kamisa tõ oxisã kynexine, zumo exiry 12,5 meturume mosa toto exiry te, 1,80 meturume ipuroroje exiry. ");
INSERT INTO apyNT_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","5me moro kamisa tõ tyxixĩse osepokona toiro kamisame ehtohme. Morarame tyrise eya xine imepỹ 5mãkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Imyhtoh tyrise eya xine kamisa ezuezumã ke, kamisa etyhpyry ehpikuroko moro kamisa konõto asakorõ pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","50me imyhtoh tyrise eya xine kamisa apitorymã ehpikuroko te, 50me imyhtoh tyrise roropa eya xine zakorõ kamisa konõto etyhpyry ehpikuroko osẽpataka moro imyhtoh tonõme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Mame 50me apoitoh tyrise eya xine uuru risẽme kamisa konõto asakoro osexihtohme oximaro toiro konõtome ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Tapyi amotoh tyrise eya xine kamisa 11mãkõ ke, poti hpoty risẽ ke. ");
INSERT INTO apyNT_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Oxisã kehko morohne kynexine, zumo exiry 13,30 meturume mosa exiry, 1,80 meturume ipuroroje exiry. ");
INSERT INTO apyNT_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","5me moro kamisa tyxixĩse eya xine oximaro toiro kamisa konõto ehtohme. Zakorõ 6mãkõ tyxixĩse eya xine zakorõ kamisa konõtome ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","50me imyhtoh tyrise apitorymã etyhpyry ehpikuroko te, 50me imyhtoh tyrise roropa zakorõ ehpikuroko. ");
INSERT INTO apyNT_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Moromeĩpo 50me apoitoh tyrise eya xine, metau risẽme moro kamisa konõto asakorõ osexihtohme oximaro, toiro amotohme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Imepyny amotoh tyrise roropa eya xine, kaneru pihpyry ke tonohse tahpire. Moro po imepyny amotoh tyrise eya xine okyno pihpyry kurano, jarao exikety. ");
INSERT INTO apyNT_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Wewe risẽ tyrise eya xine, akaxia risẽme, xikihme exiketomo, Tapyi apurume ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Toiro wewe risẽ 4,45 meturume kynexine kae exiry te, ipuroroje 67 sẽtimeturume. ");
INSERT INTO apyNT_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Asakoro tyetyere tyrise kehko eya xine osexihtohme. Morara tyrise emero wewe risẽ eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","20me wewe risẽ tyrise eya xine apurume ikurenae. ");
INSERT INTO apyNT_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Moro wewe risẽ zopino 40me apõ tyrise eya xine parata risẽme, toiro wewe risẽ ahtao asakoro apõ tyrise jamihmehxo aosexihtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","20me wewe risẽ tyrise eya xine Tapyi apurume inikahpozakoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","40me apõ tyrise eya xine parata risẽme, toiro wewe risẽ ahtao, asakoro apõ kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Tapyi apuru mykae, xixi omõtoh wino 6me wewe risẽ tyrise eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Asakoro wewe risẽ tyrise roropa eya xine eriety tõ kyryryme. ");
INSERT INTO apyNT_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Moro wewe risẽ eriety tõ kyryryme toxixihmase kehko kynexine apõ poe zuhpokoxi toiro kyryryme ehtohme. Moro wewe risẽ asakoro morara tyrise eya xine eriety tõ ritohme. ");
INSERT INTO apyNT_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Naeroro 8me wewe risẽ kynexine 16me apõ tõ maro. Toiro wewe risẽ ahtao asakoro apõ nae kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","15me wewe risẽ kuroko exiketõ tyrise eya xine, akaxia risẽme, 5me tyritohme wewe risẽ kuroko ikurenae te, 5me inikahpozakoxi te, 5me xixi omõtoh wino Tapyi mykae. ");
INSERT INTO apyNT_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Moro wewe irãnaono tyrise eya xine irãnakuroko, wewe risẽ apitorymã poe Tapyi etyhpyrymã pona. ");
INSERT INTO apyNT_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Moro wewe risẽ tapuhse eya xine uuru ke. Parihmã tyrise eya xine uuru risemy wewe risẽ pokona epuru ritohme. Moro epuru roropa tapuhse uuru ke eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Kamisa tyrise eya xine apurume mauru panõ kurã risẽme, kaneru hpoty maro ezuezumã te, puupura te, tahpiremã maro, enara. Taporihkã panõ ke emeporyme tyrise eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","4me wewe xikihmãkõ tyrise eya xine ipokona kamisa ritohme tyhwyme. Moro xikihmãkõ tyrise eya xine wewe akaxia ke tapuhse uuru ke. Kamisa apoitoh tyrise eya xine uuru ke te, apõ tõ 4mãkõ tyrise eya xine parata ke. ");
INSERT INTO apyNT_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Tapyi omõtoh tao kamisa tyrise eya xine mauru panõ kurã ke, kaneru hpoty maro: ezuezumã te, puupura te, tahpiremã maro te, emepory maro tyxixĩse. ");
INSERT INTO apyNT_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Moro kamisa apoitohme wewe akaxia risẽ xikihme exiketõ tyrise eya xine 5me, kamisa apoitoh maro, zupuhpyry tõ tapuhse uuru ke. Moro wewe apõ 5me tyrise eya xine metau risẽme. ");
INSERT INTO apyNT_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Mame wewe akaxia ke kaxo tyrise Pezareu a, Ritonõpo omihpyry ẽme, 1,10 meturume mosa exiry kynexine te, 66 sẽtimeturume ipuroroje exiry te, 66 sẽtimeturume kae exiry, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Uuru kurã ke moro kaxo tapuhse eya zao te, jarao, enara. Ehpikuroko kaxo zomye uuru risẽ tyrise eya. ");
INSERT INTO apyNT_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","4me parihmã tyrise eya uuru risemy, ipupuru 4mãkõ pokona, asakoro osetatoro apotunuru wino te, asakoro ipozery wino, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Mame mara asakoro tyrise eya epurume, wewe akaxia risemy, tapuhse uuru ke. ");
INSERT INTO apyNT_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Moro parihmã aka kaxo ratozome mara tõ tyrise eya epurume, arotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Kaxo apuru tyrise Pezareu a, uuru kurã risẽ ke, 1,10 meturume mosa exikety te, 66 sẽtimeturume ipuroroje, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Asakoro taporihke exiketõ tyrise eya uuru apimyhpyry ke kaxo apuru etyhpyry tõ po. ");
INSERT INTO apyNT_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Toiro tyrise eya seino, toiro moino, apuru etyhpyry tõ po toiro kyryryme toto ehtohme kaxo apuru maro. ");
INSERT INTO apyNT_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Osẽpataka mokaro taporihke exiketõ tyrise eya. Aporiry tõ tyrise eya totapuruhmakase kaxo apuru epoe. ");
INSERT INTO apyNT_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Meza tyrise Pezareu a, wewe akaxia risemy, 88 sẽtimeturume mosa exiry te, 44 sẽtimeturume ipuroroje exiry te, 66 sẽtimeturume kae exiry, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Uuru kurã ke meza tapuhse eya. Ehpikuroko meza zomye uuru risẽ tyrise roropa eya. ");
INSERT INTO apyNT_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Meza zomye ehpiry tyrise eya 7 sẽtimeturume uuru risemy. Moro ehpiry maro uuru risẽ tyrise roropa eya. ");
INSERT INTO apyNT_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","4me parihmã tyrise eya uuru risemy. Meza pokona morohne tyrise eya ipupuru 4mãkõ pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Meza ehpiry pokona parihmãkõ tyrise eya mara tõ esaryme, epurume, arotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mara tõ asakoro tyrise eya wewe akaxia ke tapuhse uuru ke. ");
INSERT INTO apyNT_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Uuru kurã ke eukuru ẽ tyrise eya te, paratu tomo te, kopu tomo te tijera tomo te, jaha tomo, uwa eukuru puimatohme, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Mame ezuru apõ tyrise eya uuru kurã ke. Apony te, zoko roropa tyrise eya uuru tapĩsehme exikety ke. Ekuru tõ enekure tyrise eya, potão tõ maro te, petara tõ maro toiro kyryryme tyrise zoko pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","6me amoriry tõ tyrise eya zoko poko, oseruao seino te, oseruao moino, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Toiro amoriry oseruao ekuru nae kynexine emeporyme, amẽtoeira ekuru panono potão tõ maro te, petara tõ maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ezuru apõ zoko 4me ekuru tõ tyrise eya, amẽtoeira ekuru samo, potão tõ maro, petara tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Asakoro amoriry ahtao toiro potão tyrise eya amẽtoeira potãome samo, oseruao potãome ehtohme atapona. ");
INSERT INTO apyNT_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Morohne potão tomo te, amoriry tõ maro, ezuru apõ maro zoko maro toiro kyryryme tyrise eya, uuru kurã tapĩsehme exikety ke. ");
INSERT INTO apyNT_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","7me nãparina tõ tyrise Pezareu a, ezuru apõ po, jahpi tõ roropa ezuru tõ aryry kyrytohme te, oruno ẽ roropa. Uuru kurã ke morohne tyrise eya. ");
INSERT INTO apyNT_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","34 kirume uuru kurã ke moro ezuru apõ tyrise eya, ikyryry tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Apoto apõ tyrise Pezareu a, wewe akaxia risẽme, ixtaratu zahkatohme. Moro apoto apõ tahramehme sã kynexine; 45 sẽtimeturume mosa exiry te, 45 sẽtimeturume ipuroroje exiry te 90 sẽtimeturume kae exiry, enara. Iretyry tõ 4mãkõ toiro kyryryme kynexine apoto apõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Moro apurutoh tapuhse Pezareu a uuru kurã ke te, iratozo tõ 4mãkõ maro te, iretyry tõ maro, enara. Apoto apõ zomye uuru risẽ tyrise eya ehpiryme. ");
INSERT INTO apyNT_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Parihmã asakoro tyrise eya uuru risemy ehpiry zopino, toiro seino te, toiro moino. Mara tõ tyrise eya moro parihmã tõ aka, epurume, arotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Moro mara tõ tyrise wewe akaxia ke tapuhse uuru ke. ");
INSERT INTO apyNT_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Oriu kurã, Ritonõpo nyripohpyry tyrise Pezareu a ahpatohme, ixtaratu roropa kurã, typoxine exikety, ixtaratu panono. ");
INSERT INTO apyNT_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Mame apoto apõ tyrise Pezareu a okyno tõ zahkatohme Izyraeu tõ nekaroryme Ritonõpo a. Moro apoto apõ tyrise wewe akaxia ke tahramehme samo, 2,20 meturume mosa exiry te, 2,20 meturume ipuroroje exiry te, 1,30 meturume kae exiry, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Iretyry tyrise eya 4me, apoto apõ potyry pokona, toiro kyryryme ehtohme apoto apõ maro. Moro apoto apõ tapuhse metau ke eya, tytororo. ");
INSERT INTO apyNT_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Apoto apõ kyryry, ipoko erohtoh tõkehko tyrise roropa eya, oripo tomo te, pa tomo te, paxiha tomo te, kaafu tomo te, apoto ẽ tomo, enara. Senohne emero metau ke tyrise eya. ");
INSERT INTO apyNT_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Apoto ẽ tyrise eya otuato samo, metau risẽ ke, irãnao, apoto apõ ao, ehpio zopino tyritohme. Kae exiry zokonaka kynexine apoto apõ ao. ");
INSERT INTO apyNT_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","4me parihmãkõ tyrise eya metau risẽme apoto ẽ, otuato panõ eriety tõ pokona tyritohme, mara tõ ritohme epurume, arotohme. ");
INSERT INTO apyNT_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Moro epuru tõ tyrise eya wewe akaxia ke, tapuhse metau ke. ");
INSERT INTO apyNT_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Mame morohne tyrise eya parihmã tõ aka seino te, moino, enara, apoto apõ epurume, arotohme. Wewe akaxia risẽme moro apoto apõ kynexine kaxo samo, apuruhmakahpyry sã ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Mame osemahtoh paxiha tyrise eya metau risemy, apõ maro. Moro metau tapoise eya xine, nohpo tõ nekarotyamo, osene tomo. Erohketõme toh kynexine Tapyi Kurã omõtoh tao. ");
INSERT INTO apyNT_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Tapyi Kurã zomye osa tapuruse Pezareu a, zarame. Moro zara tapuruse eya xine kamisa ke, mauru panõ kurã risẽ ke. Apuru ikurenae kamisa mosa exiry tyrise eya 44 meturume. ");
INSERT INTO apyNT_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Xikihme exiketõ tyrise eya 20me, metau risemy, apõ tõ maro metau risemy. Kamisa apoitoh tyrise, mara tõ roropa parata risemy. ");
INSERT INTO apyNT_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Zara apurume inikahpozakoxi morararo tyrise Pezareu a. ");
INSERT INTO apyNT_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","13","Moro zara ipuroroje exiry 22 meturume kynexine. Naeroro apurume xixi omõtoh wino te, xixi tũtatoh wino roropa kamisa tyrise eya 22 meturume mosa exiry. Xikihme exiketõ 10me kynexine 10me apõ tõ maro. Apoitoh tonõ tyrise eya mara tõ maro parata ke. Omõtoh kynexine xixi tũtatoh wino. ");
INSERT INTO apyNT_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Omõtoh erietyme kamisa tõ tyrise eya xine 6,60 meturume mosa exiry. Oseruao xikihme exiketõ tyrise eya xine tapõ maro oseruao seino apotunuru wino te, moino roropa ipozery wino, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Moro kamisa tõ, zara apurume, emero mauru panõ kurã risẽ kynexine, karimutume. ");
INSERT INTO apyNT_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Xikihme exiketõ apõ tõ metau risẽme kynexine. Kamisa apoitoh tonomo te, mara tõ maro te, xikihme exiketõ zupuhpyry tõ roropa parata risẽme kynexine. Moro xikihme exiketõ emero tymyhse sã oximaro kynexine mara tõ parata risẽ ke. ");
INSERT INTO apyNT_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Omõtoh tao zara pona kamisa tyrise mauru panõ kurã karimutumã ke. Enekure tyrise kynexine, kaneru hpoty ke ezuezumã ke te, puupura ke te, tahpiremã ke, enara. 8,80 meturume moro kamisa mosa exiry kynexine te, kae exiry 2,20 meturume, imehnõ kamisa tõ samo zara apurume. ");
INSERT INTO apyNT_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Inepuru xikihme exiketõ 4me tyrise eya xine tapõ ke metau risẽ ke. Kamisa apoitoh te, inepuru zupuhpyry tõ te, mara tõ roropa parata risã kehko kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Inepuru tõ Tapyi eary myhtohme nono pokona te, zara apuru eary myhtohme roropa emero metau risãme kehko kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Mame Tapyi Kurã risẽ omoxiny ehtoh tymerose kynexine, uuru te, parata te, metau, enara. Moroto Ritonõpo Tapyĩ tao aomihpyry ẽ kynexine, topu tõ pipahmã tymerose Ritonõpo a, inyripohpyry 10mãkomo. Moeze a morohne omoxiny ehtoh tymeropose Rewi tomo a. Toto tuisary Itamaa kynexine, Arão pary. ");
INSERT INTO apyNT_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Ritonõpo nyripohpyry Moeze a, emero tyrise Pezareu a, Uri mũkuru, Huru pary, Juta tõ ekyry. ");
INSERT INTO apyNT_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Akorehmane kynexine Aoriape, Aisamake mũkuru Tã tõ ekyry. Emese kure Aoriape kynexine tutuaronyry ke, kamisa kurã mauru panõ karimutumã riry waro kynexine. Tyxixĩse eya otyro panõ tõ kaneru hpoty ke: ezuezumã ke te, puupuramãkõ ke, tahpiremã ke, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Uuru emero ahno nekarotyã Ritonõpo a Tapyi Kurã ritohme atapona miu kirume kynexine, ikuhtoh zae exikety ae tukuhse ahtao, tuisa kyryry ke. ");
INSERT INTO apyNT_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Parata tapoise ahno tukuhse ahtao, 3.430 kirume tukuhse tuisa kyryry ke. ");
INSERT INTO apyNT_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Orutua kõ emero tukuhse kynexine 20me jeimamyry nae ahtao. Orutua a emero topehmase epehmapotopõpyry, tuisa ikuhtoh ae ro. Orutua kõ esetykõ 603.550 kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Parata 3.400 kirume tapoise 100me apõ tõ ritohme, Tapyi kyryryme kamisa apoitohme. Toiro apõ 34 kirume parata nae kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Morarame akoĩpyry 30 kirume parata ke apoitoh tonõ tyrise Pezareu a te, mara tomo te, xikihme exiketõ zupuhpyry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Metau, imoihmãkõ nekarohpyry Ritonõpo a atapona 2.425 kirume kynexine. ");
INSERT INTO apyNT_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Moro metau ke omõtoh apõ tõ tyrise Pezareu a, Tapyi taka aomõtohme Ritonõpo maro oturutoh taka te, apoto apony metau risẽme, kereuja maro apoto eny, otuato samo, imõkomory maro ipoko erohtohme te, ");
INSERT INTO apyNT_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","xikihme exiketõ apõ tomo zara zomye exiketomo te, omõtoh apõ roropa te, inepuru tõ Tapyi myhtohme nono pokona te, zara apuru roropa myhtohme Tapyi zomye exikety myhtohme nono pokona, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Mame upo kurã tyrise Pezareu tomo a, Aoriape maro, Arão tõ zupõme, aotupohtohkõme erohtohme Ritonõpo Esary Kurã tao. Moro upo tyrise kaneru hpoty ke, ezuezumã ke, puupura ke, tahpiremã ke, enara Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ritonõpo maro oturukety zupõ kurã tyrise eya xine mauru panõ kurã ke; kaneru hpoty ezuezumã maro te, puupura maro, tahpiremã maro; uuru topuru maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Uuru tapĩse eya xine kãseme sã ehtohme, mauru topuru sã ehtohme kamisame tyritohme mauru panõ kurã maro te, kaneru hpoty maro, ezuezumano, puupura, tahpiremã maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Kamisa eary asakoro tyrise eya xine, upo pokona, imotary kyryry. ");
INSERT INTO apyNT_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Zamareary tykahse Ritonõpo maro oturukety zupony, mauru panõ kurã risẽme. Moro tyxixĩse Ritonõpo maro oturukety zupõ pokona. Tyrise kynexine Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Topu kurã akata asakoro tyhkohse eya xine. Tyrise uuru pokona eya xine. Jako mũkuhpyry tõ esetykõ 12mãkõ tymerose moro topu pokona emese kure exikety a. ");
INSERT INTO apyNT_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Mame moro topu tõ asakoro tyrise eya xine eary tõ pokona, oturukety zupõ pokona, Jako mũkuhpyry tõ, oxiekyry tõ maro esetykõ arotohme Ritonõpo ẽpataka, Ritonõpo omihpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Puropu apuru kurã tyrise eya xine upo apitorymã ehtoh saaro. Mauru panõ kurã tykahse eya xine kaneru hpoty maro, ezuezumã te, puupura te, tahpiremã te, tyxixĩse roropa otyro panõ ke, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Tahramehme sã kynexine, turetureme, 22 sẽtimeturume mosa exiry te, 22 sẽtimeturume ipuroroje exiry, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ipokona topu tõ kurã tyrise eya xine atakenaka exikety asakoropane exikety. Atakenaka exikety apitorymã ao: rupi tyrise te, topazio te, karanata, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Atakenaka exikety zakorõ ao ezemerauta te, sapira te, tiamãte, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Atakenaka exikety oseruaono ao turukeza te, akata te, ametixta, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Atakenaka exikety 4mano ao periro te, onixi te, jasape, enara. Morohne tyrise uuru pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Toiro topu ahtao, Jako mũkuhpyry esety toiro tymerose ipokona. 12me topu tõ kurã pona 12mãkõ Jako mũkuhpyry tõ esetykõ tymerose, 12mãkõ oxiekyry tõ enetupuhtohme Ritonõpo ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Keti tõ asakoro tyrise eya xine uuru kurã ke. Oximaro tyrise kehko earyme ehtohme ipuropuru apururu kyryryme ehtohme, imyhtohme Ritonõpo maro oturukety zupõ kurã pokona. ");
INSERT INTO apyNT_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Parihmã asakoro tyrise eya xine uuru risemy puropu apuru potyry pokona, kae aosexihtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Moro eary tõ asakoro uuru risẽ tyrise moro parihmã kuroko. ");
INSERT INTO apyNT_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Eary tõ etyhpyry tõ tyrise uuru pokona puropu apuru poko. Mame puropu apuru tymyhse eya xine eary pokona, oturuketõ zupõ kurã poko. ");
INSERT INTO apyNT_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Parihmã imehnõ asakoro tyrise eya xine uuru risẽ ke puropu apuru potyry pokona zopino, ehpio poko zao oturukety zupõ pũto. ");
INSERT INTO apyNT_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Parihmã asakoro tyrise ropa uuru risẽ aosexihtohme eary tõ etyhpyry pokona oturukety zupõ pokona aosexihtoh pũto zamareary epozakoxi. ");
INSERT INTO apyNT_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Puropu apuru parihmã tõ tymyhse oturukety zupõ kurã parihmã pokona eary ezuezumã ke, zamareary epozakoxi ehtohme, oturukety zupõ kurã poe epukara ehtohme roropa. Morohne tyrise eya xine Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Upo tyrise eya xine kamisa ezuezumã ke Arão tomo a amurutohme oturukety zupõ kurã zopino. ");
INSERT INTO apyNT_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Eutary tyrise eya xine zupuhpyry omõtohme. Moro eutary zomye kamisa tyxixĩse exihkara ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Moro upo ehpiry zopino ehpikuroko emeporyme tyrise eya xine romã tõ panono, kamisa ke tyrise: mauru panõ kurã ke, kaneru hpoty maro ezuezumã te, puupura te, tahpiremano, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Tĩtĩ katoh pitiko tyrise roropa eya xine, uuru kurã risemy, romã tõ asakoro rãnao, upo ehpiry poko, Arão tõ a amurutohme toerohtohkõ poko toto ahtao. ");
INSERT INTO apyNT_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Morara Arão tõ zupõ ehpiry zopino enekure kynexine tĩtĩ katoh pitiko ke atakenaka romã tõ maro: toiro tĩtĩ katopo, toiro romã te, imepỹ tĩtĩ katoh, imepỹ romã, enara, Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Kamisa tõ tyrise eya xine mauru panõ kurã ke Arão zupõme imũkuru tõ zupõme, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Zuhzõty roropa mauru panõ kurã risẽ ke Arão zupuhpyry pona amurutohme te, xapeu tõ roropa, imetỹ tõ roropa mauru panõ risẽme imũkuru tõ zupõme. ");
INSERT INTO apyNT_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Zamareary Arão zupõme tyrise eya xine mauru panõ kurã ke tyxixĩse enekure ehtohme kaneru hpoty ke, ezuezumano, puupura, tahpiremano, enara, Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Uuru pipahmã pixo tyrise eya xine, tymerose “Tymenekase Ritonõpo maro ehtohme.” ");
INSERT INTO apyNT_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Moro tyrise Arão zuhzõty pokona, tymyhse eary ke ezuezumã ke Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Mame tõtyhkase toto toerohtohkõ poko Ritonõpo maro oturutoh, Tapyi Kurã poko. Izyraeu tomo a emero tyrise, Ritonõpo nyripohpyry Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Tynyrihpyrykõ tarose eya xine Moeze a, Tapyi Kurã, mõkomoryme, emero erohtoh kyryry maro, apoitoh tonomo te, wewe risẽ xikihme exiketomo te, wewe kuroko exiketomo te, xikihme exiketomo apõ tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Tapyi amotoh tarose eya xine kaneru pihpyry risemy tonohse tahpire te, imepỹ amotoh roropa okyno pihpyry risẽ kurano te, kamisa konõto, Ritonõpo Esary Kurã apurume Esary Kurã Kuhse apuru maro. ");
INSERT INTO apyNT_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Kaxo, Ritonõpo omihpyry eny, topu pipahmã maro tymerose Ritonõpo nymeropohpyry 10mãkõ tymoisemy te, epuru tõ maro, apurutoh maro. ");
INSERT INTO apyNT_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Meza tarose eya xine imõkomory maro te, wyi tomo tynekaroryme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Ezuru apony uuru kurã risemy te, imõkomory maro nãparina tomo te, oriu te, nãparina eukurume, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Apoto apony uuru risemy te, oriu ahpatohme te, ixtaratu zahkatohme te, kamisa Tapyi omõtoh po te, ");
INSERT INTO apyNT_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Apoto apõ metau risemy okyno zahkatohme te, apoto ẽ otuato panõ te, epuru tomo te, imõkomory maro te, osemahtoh ẽ apõ maro. ");
INSERT INTO apyNT_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Kamisa tõ tarose eya xine, Tapyi zomye osa apurutohme xikihme exiketõ maro te, apõ tõ maro te, kamisa zara pona omõtoh kamisa te, eary tomo te, inepuru tõ, Tapyi kyryry tõkehko te, Tapyi mõkomory emero, erohtohme Tapyi Kurã tao. ");
INSERT INTO apyNT_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Upo kurã Arão tõ zupony imũkuru tõ zupony roropa amurutohme erohse toytose toto ahtao Osa Kurã taka, toerohtohkõ poko toto ahtao, Ritonõpo maro oturuketõme, okyno etapary poko, zahkary poko tynekarorykõme, enara. ");
INSERT INTO apyNT_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Toerohtohkõ tyrise Izyraeu tomo a zae, Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mame toto nyrihpyry tonese Moeze a. Emero tyrise eya xine zae ipunaka, Ritonõpo nyripohpyry ae ro. Mame tõturuse Moeze Ritonõpo a kure rokẽ Izyraeu tõ ritohme. ");
INSERT INTO apyNT_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Morarame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","— Ẽmepyry apitorymã po, nuno apitorymã po Tapyi Kurã amotoko, ymaro õturutohkõme. ");
INSERT INTO apyNT_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Kaxo jomihpyry ẽ tyriko Tapyi taka. Moro kaxo ao topu pipahmã tukurãkase ynyripotyã omame porehme; kamisa anỹko tyhwyme jomihpyry ẽ ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Meza aroko Tapyi taka. Ykyryry tõ tyriko epona. Ezuru apõ aroko Tapyi taka nãparina tõ tyriko esaka xine. ");
INSERT INTO apyNT_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Apoto apõ uuru risẽ ixtaratu zahkatoh tyriko kaxo, jomihpyry ẽ, ẽpataka. Kamisa tyriko Tapyi omõtoh tao. ");
INSERT INTO apyNT_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Apoto apõ okyno tõ zahkatoh tyriko Tapyi ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Osemahtoh ẽ tyriko irãnaka, apoto apõ poe Tapyi pona. Tuna tyriko osemahtoh ẽ aka. ");
INSERT INTO apyNT_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Kamisa tõ tyriko zara zomye, Tapyi zomye, apurume te, kamisa tyriko roropa zara omõtoh taka. ");
INSERT INTO apyNT_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","— Mame oriu apoiko, ahpatohme. Ikuãko pitiko Tapyi pona te, imõkomory pona roropa, apiakatohme ykyryry tõ kurãme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Apoto apõ pona oriu ikuãko pitiko okyno zahkatoh po imõkomory maro apiakatohme ykyryryme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Osemahtoh ẽ pona oriu ikuãko pitiko apõ maro apiakatohme ykyryryme kurãme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","— Mame Arão tõ imũkuru tõ maro enehko Tapyi omõtoh taka toto ekurikatohme tuna ke. ");
INSERT INTO apyNT_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Mame upo kurã amurupoko Arão a, oriu ke ahpako apiakatohme erohtohme, ymaro oturuketyme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Imũkuru tõ a roropa amurupoko, oturukety zupõ kurã ke. ");
INSERT INTO apyNT_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Oriu ke toto ahpako jũkõ saaro ymaro toto erohtohme, ymaro oturuketõme toto ehtohme. Tahpase toto oya exiryke oriu ke, jũme ymaro oturuketõme exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mame morara tyrise Moeze a emero Ritonõpo nyripohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ẽmepyry apitorymã po, nuno apitorymã po, jeimamyry asakorõ po, Ejitu rumekatopõpyry poe, Tapyi Kurã tamose eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moeze omihpyry omi poe Tapyi apõ tõ tyrise eya xine, wewe risẽ xikihme exiketõ tanỹse eya xine, wewe kuroko exiketõ tyrise esaka, xikihme exiketõ kamisa apõ tanỹse eya xine. ");
INSERT INTO apyNT_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Mame amotoh tyrise eya xine Tapyi pona, Ritonõpo nyripohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Topu pipahmã asakoro tyrise eya xine kaxo aka, Ritonõpo omihpyry ẽ aka. Mara tõ tyrise parihmã aka kaxo pokona, epurume. Apurutoh tyrise kaxo pona. ");
INSERT INTO apyNT_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Mame kaxo, Ritonõpo omihpyry ẽ tarose eya, Osa Kurã taka, Tapyi Kurã taka. Kamisa tyrise eya xine Osa Kurã Apurume, jaraõkõ osenuhmara ehtohme, kaxo kurã onenepyra toto ehtohme. Morara tyrise eya Ritonõpo nyripohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Meza tyrise Moeze a Tapyi Kurã taka inikahpozakoxi kamisa ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Moro meza po wyi tyrise eya tynekaroryme Ritonõpo a, Ritonõpo nyripohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Mame ezuru apõ tyrise eya Tapyi Kurã tao, ikurenaka meza etonie. ");
INSERT INTO apyNT_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Nãparina tõ tyrise eya ezuru apõ po, Ritonõpo ẽpataka. Tukase Ritonõpo nyripohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Apoto apõ uuru risẽ, ixtaratu zahkatoh tyrise eya Tapyi taka kamisa ẽpataka, Osa Kurã Kuhse ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Ixtaratu tyahkase epona, Ritonõpo nyripohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Kamisa tyrise eya Tapyi Kurã omõtoh tao. ");
INSERT INTO apyNT_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Apoto apõ okyno zahkatoh tyrise eya omõtoh ẽpataka. Moro apoto apõ po tynekaroryme okyno tõ tyrise eya. Tyahkase toto tiriiku tõkehko maro, Ritonõpo omihpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Osemahtoh ẽ tyrise eya irãnaka Tapyi poe apoto apõ pona. Tuna tyrise zao. ");
INSERT INTO apyNT_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moro osemahtoh ẽ ao tõsemahse, tupupurukõ tukurikase Arão tomo a, imũkuru tõ maro ");
INSERT INTO apyNT_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","aomomyrykohtao Tapyi taka te, apoto apõ pona toytose toto ahtao, Ritonõpo omihpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Moeze omihpyry omi poe kamisa tõ tyrise zara zomye, apurume Tapyi Kurã zomye, apoto apõ maro. Kamisa tyrise omõtoh taka zara pona omõtohme. Mame tõtyhkase rahkene. ");
INSERT INTO apyNT_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Mame akurũ tooehse Tapyi Kurã pona. Ritonõpo Ezuru tomõse Tapyi taka. ");
INSERT INTO apyNT_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moro pokoino omõsaromepyra Moeze kynexine Tapyi taka. ");
INSERT INTO apyNT_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Mame akurũ tõnuhse ahtao rokẽ Tapyi poe toesyryhmase Izyraeu tomo tosarykõ poe imepỹ pona. ");
INSERT INTO apyNT_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Yrome onuhpyra akurũ ahtao tehme rokẽ Izyraeu tõ kynexine akurũ onukuru ropa eraximãko. ");
INSERT INTO apyNT_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Mame aytorykohtao akurũ tonese eya xine, saereme ahtao tymaro xine Ritonõpo exiry, akurũme, Tapyi epoe. Koko apoto tonese eya xine, saereh ãko, Tapyi epoe.");
INSERT INTO apyNT_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Morarame Moeze tykohmase Ritonõpo a tymaro Oximõtoh Kurã tae, ynara tyripotohme ");
INSERT INTO apyNT_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Izyraeu tomo a tynekarorykõ zahkaryhtao eya xine: Tokykõ zahkaryhtao ahno a tynekaroryme Ritonõpo a tokykõ menekãko mã toto pui te, kaneru te, poti, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Pui ekaroryhtao eya jahkatohme apoto apõ po, pui orutua menekãko mana kurãkõ rokene. Mokyro arõko mana Tapyi Kurã omõtoh taka zae ehtohme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Moroto tomary rĩko mana okyno zupuhpyry pona zae ehtohme Ritonõpo a iirypyry tykorokase ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Toky etapãko mokyro mana moroto Tapyi Kurã ẽpataka. Mame oturuketõ, Arão pakomotyã imunuru ekarõko mã toto Ritonõpo a. Mame imunuru kuãnõko mã toto apoto apõ ehpiry 4mãkõ pokona Tapyi ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Moromeĩpo okyno ekepyry pikãko mokyro mana, mame zoko sahsahkãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Apoto zukãko oturuketõ mana apoto apõ po. Ikemehtõko mã toto apotopokõ ke. ");
INSERT INTO apyNT_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Mame apoto pona mokyro pui orutua isahsahkahpyry rĩko mã toto: zupuhpyry, ikasery zuahxiririny te, ");
INSERT INTO apyNT_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","epyasyhny tõkehko kurikãko mokyro mana jaxiry tõ roropa. Mame apoto pona morohne rĩko oturukety mana jahkatohme. Mokyro pui orutua ekepyry zahkãko oturukety mana, porehme tynekaroryme, typoxine potu Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Kaneru menekaryhtao ahno a jahkatohme tynekaroryme Ritonõpo a te, poti roropa, orutua menekãko mana kurãkõ rokene. ");
INSERT INTO apyNT_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Mame mokyro etapãko mana Ritonõpo ẽpataka apoto apõ poe inikahpozakoxi. Imunuru kuãnõko oturuketomo apoto apõ ehpiry poro 4mãkõ pona. ");
INSERT INTO apyNT_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Moromeĩpo okyno sahsahkãko mokyro mana. Mame oturukety mokyro pũ zupuhpyry maro, ikasery maro zuahxirirĩ roropa apoto pona tyrĩko mana apoto apõ pona. ");
INSERT INTO apyNT_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Mame okyno esẽ toky epyasyhny tõkehko kurikãko mana jaxiry tõ maro, mame morohne zahkãko oturukety mana tynekaroryme Ritonõpo a. Okyno tytororo jahkãko mana, tynekaroryme Ritonõpo a. Moro typoxine mana eya. ");
INSERT INTO apyNT_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Torõ menekaryhtao ahno a jahkatohme tynekaroryme Ritonõpo a, utukuimo te, parutopuru menekãko mana enehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Mokyro torõ arõko oturukety mana apoto apõ pona, zukãko mana jahkatohme apoto apõ po, imunuru tũtãko apoto apõ ehpiry poro. ");
INSERT INTO apyNT_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Mame torõ napyry ẽ oũko mana ipahtohme oruno htaka apoto apõ poe xixi tũtatoh winakoxi. ");
INSERT INTO apyNT_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Mame torõ apoĩko mana aporiry poko aporiramãko mana, yrome anapiakara mana asakorõ ehtohme, mame mokyro zahkãko mana apoto apõ po. Zahnõko mana tytororo inekaroryme, typoxine exiketyme Ritonõpo Oesẽkomo a. ");
INSERT INTO apyNT_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Mame tiriiku tõkehko enepyryhtao ahno a tynekaroryme Ritonõpo a, moro otyro puhturu apõko mana aporo kurehxo exikety outohme tynekaroryme. Imeĩpo azeite zoximãko mana ixtaratu maro, tiriiku apotopõpyry maro. ");
INSERT INTO apyNT_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Mame morohne ekarõko mana oturuketomo a, Arão pakomotyamo a. Mame moro tiriiku toiro tomary ao apoĩko oturukety mana azeite maro, ixtaratu maro, jahkatohme apoto apõ po enetupuhpotohme moro emero tokarose Ritonõpo a. Ahno nekaroryme mana, tonahsẽme, typoxine exiketyme, Ritonõpo zamaro exiketyme. ");
INSERT INTO apyNT_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Moro akoĩpyry oturuketõ napyryme mana, Arão mũkuru tomo, ipakomotyamo, enara; morohne Ritonõpo zamaro mana, touse exiryke ahno nekarohpyry poe, tokarose ahtao Ritonõpo Oesẽkomo a. ");
INSERT INTO apyNT_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Mame tynekaroryme tiriiku risẽ enepyryhtao ahno a ekeihpyry orinato po, tiriiku kurã apohpyry kure yrome iporutatoh maro pyra mana. Inũme tyrise ahtao azeite maro kure mana, pipahmã pisarara tyrise ahtao typopase azeite ke kure roropa mana. ");
INSERT INTO apyNT_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Tiriiku risẽ tupuruse ahtao oripo ao ekarotohme onekaroryme tiriiku apohpyry tyriko otoxie azeite maro, yrome iporutatoh maro pyra. ");
INSERT INTO apyNT_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Moro enepyryhtao oya onekaroryme moro pão itohkako azeite ritohme epona. ");
INSERT INTO apyNT_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Onekaroryme pão tõ tupuruse ahtao ekeitoh ao tiriiku apohpyry tyriko azeite maro. ");
INSERT INTO apyNT_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Onekaroryme morohne ekaroko Ritonõpo Oesemy a; morohne ekaroko oturukety a, mame moro arõko mana apoto apõ pona. ");
INSERT INTO apyNT_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Onekarohpyry zokonaka apoĩko mana pitiko rokene jahkatohme apoto apõ po enetupuhpotohme moro tytororo tokarose Ritonõpo a. Onekaroryme mana tonahsẽme, typoxine exikety Ritonõpo zamaro exiketyme mana. ");
INSERT INTO apyNT_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Mame akoĩpyry oturuketõ napyryme exĩko mana, Arão mũkuru tomo te, ipakomotyã roropa. Ritonõpo kyryry kurãme mana touse exiryke onekarohpyry poe Ritonõpo Jumãme Exikety a. ");
INSERT INTO apyNT_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Onekarorykõ tiriiku risẽ emero tyritoko iporutatoh maro pyra, iporutatoh maro pyra te, ano zeni maro pyra roropa tyritoko onekarorykõme Ritonõpo Jumãme Exikety a. ");
INSERT INTO apyNT_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Tiriiku tõkehko osemazuhme anapoihpyrykomo oya xine ekarotoko onekarorykõme Ritonõpo a. Yrome morohne onyahkara ehtoko apoto apõ po. ");
INSERT INTO apyNT_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Sautu tyritoko onekarorykõ maro, tiriiku tõkehko risẽ tomepore ehtohme. Sautu enetupuhtohme mana Ritonõpo omihpyry poko, inetapohpyry poko typoetory tomo a. Onekarorykõ emero tiriiku risẽ ahtao sautu tyritoko epona, tomepore ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Mame otyro epery apoipitoryhtao oya xine, osemazuhme anapoityã ekaroryhtao Ritonõpo a, ipuhturu exipyra ro exiketõ aroko, apohpyryme aexihpyry apoto pona. ");
INSERT INTO apyNT_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Azeite tyriko ixtaratu roropa moro onekarory pona. ");
INSERT INTO apyNT_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Morohne tiriiku tõkehko zokonaka zahkãko oturukety mana, apoto apõ po, azeite maro te, ixtaratu maro enetupuhtohme moro onekarohpyry emero Ritonõpo Oesẽkõ kyryryme mana. ");
INSERT INTO apyNT_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Okyno enepyryhtao ahno a tynekaroryme Ritonõpo a osepeme ehtohme, pui menekaryhtao eya orutua kure, nohpome ahtao kure roropa, yrome kure rokẽ exikety menekãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ritonõpo Tapyĩ ẽpataka tomary rĩko mokyro mana pui zupuhpyry pona, mame etapãko mana. Imunuru kuãnõko oturuketõ, Arão pakomotyã mana apoto apõ ehpiry tõ pona, asakoropane exiketõ pona. ");
INSERT INTO apyNT_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Mame tonahsẽme ynara ekarõko oturukety mana Ritonõpo a: ikasery zuahxiririny poko te, ");
INSERT INTO apyNT_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","epyasyhny asakoro, ikasery maro ipoko te, erery zokonaka kurehxo aexihpyry touse ahtao epyasyhny tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Morohne emero jahkãko oturuketõ mana apoto apõ po, moro zahkatoh maro tyrityã apotopokõ pona, apoto apõ po. Morohne ahno nekarohpyry tonahsẽme exĩko, typoxine kure Ritonõpo zamaro exikety. ");
INSERT INTO apyNT_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Okyno enepyryhtao ahno a tynekaroryme Ritonõpo a osepeme ehtohme, toky menekaryhtao eya orutuame kure, nohpome ahtao kure roropa, yrome kure rokẽ exikety menekãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kaneru mũkuru menekaryhtao eya tynekaroryme Ritonõpo a, ");
INSERT INTO apyNT_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","tomary rĩko mokyro mana toky zupuhpyry pona; mame etapãko mana Ritonõpo Tapyĩ ẽpataka. Imunuru apoĩko oturuketomo, Arão pakomotyamo, ikuãtohme apoto apõ ehpiry asakoropanẽ pona. ");
INSERT INTO apyNT_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Mokyro kasery apoĩko toiro oturukety mana ekarotohme tonahsẽme Ritonõpo a: arokyry maro tytororo tuhkohse ãtykyry pũto, ikasery maro zuahxirirĩ maro te, ");
INSERT INTO apyNT_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","epyasyhny asakoro maro ikasery tỹpokõke exikety maro, erery zokonaka kurehxo exikety, touse epyasyhny tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Morohne emero zahkãko oturukety mana apoto apõ po, tonahsẽme samo, tynekaroryme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Poti menekaryhtao ahno a tynekaroryme Ritonõpo a, ");
INSERT INTO apyNT_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","tomary rĩko mana toky zupuhpyry pona, mame etapãko mana Ritonõpo Tapyĩ ẽpataka. Imunuru kuãnõko oturuketõ, Arão pakomotyã, apoto apõ ehpiry asakoropanẽ exikety pona. ");
INSERT INTO apyNT_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Mame ikasery zahkãko toiro oturukety mana, tynekaroryme Ritonõpo a tonahsẽme samo: ikasery zuahxirirĩ poko, ");
INSERT INTO apyNT_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","epyasyhny asakoro maro, ikasery maro ipoko, erery zokonaka kurehxo exikety touse epyasyhny tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Morohne emero zahkãko oturukety mana apoto apõ po tynekaroryme tonahsẽme samo, typoxine Ritonõpo a. Ikasery emero Ritonõpo kyryryme mana. ");
INSERT INTO apyNT_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Morara exiryke Izyraeu tõ emero osa po toto ahtao ikasery onenahpyra mã toto, munu roropa onenahpyra mã toto. Jũme moro Ritonõpo nyripohpyry omipona ehtoko, apakomotyã roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Mame Moeze turuse Ritonõpo a ");
INSERT INTO apyNT_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Izyraeu tõ zurutohme ynara tyritohme iirypyryme se pyra tahtao xine ro Ritonõpo nyripohpyry tamonohse eya xine, aomipona pyra toehse. ");
INSERT INTO apyNT_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Mokyro Oturukety imehxo exikety iirypyryme toehse ahtao, tyyrypyry korokapotohme Ritonõpo a pui mũkuru kure exikety enehnõko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Mokyro arõko mana Ritonõpo Tapyĩ omõtoh taka, tomary rĩko mana zupuhpyry pona, mame mokyro etapãko mana moroto Ritonõpo ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Mame imunuru zokonaka apoĩko mana arotohme Tapyi taka. ");
INSERT INTO apyNT_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Moro tao tomahxikyry rĩko mana munu aka, mame Ritonõpo ẽpataka munu pixo sapararahmãko mana 7me kamisa Osa Kurã apuru ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Mame, Ritonõpo ẽpataka ro, munu pitiko rĩko mana apoto apõ potyry pona moro Tapyi tao, ixtaratu zahkatoh po. Munu akoĩpyry kuãnõko mana apoto apõ okyno zahkatoh myhtokoxi Tapyi ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Mame okyno kasery apoĩko oturukety mana zuahxirirĩ poko exikety emero te, ");
INSERT INTO apyNT_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","epyasyhny asakoro ikasery maro ipoko exikety te, erery zokonaka kurehxo exikety touse ahtao epyasyhny tõ maro, ");
INSERT INTO apyNT_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","morohne apoiry samo okyno zahkaryhtao onekaroryme osepeme ehtohme. Mame morohne emero zahkãko oturukety mana apoto apõ po, okyno tõ zahkatoh po. ");
INSERT INTO apyNT_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Yrome ipihpyry apoĩko mana, ipũ maro emero, zupuhpyry te, jaxiry tomo te, zuahxirirĩ maro, zuehtoto maro. ");
INSERT INTO apyNT_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Morohne arõko mana jarãnaka apatarykõ poe, osa nuriame pyra exikety pona, oruno pahtoh pona. Moroto mokyro okyno zahkãko mana tytororo, apotopokohtao. ");
INSERT INTO apyNT_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Tyyrypyrykõ se pyra ro imoihmãkõ ahtao Ritonõpo omiry omipona pyra toehse toto ahtao, inyripohpyry tamonohse eya xine. Moro toehse ahtao iirypyryme mã toto tuaro pyra toto ahtao ro. Mame ");
INSERT INTO apyNT_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","tuaro toehse toto ahtao tyyrypyrykõ poko pui mũkuru arõko mã toto jahkatohme tynekarorykõme tyyrypyrykõ korokapotohme. Mokyro arõko mã toto Tapyi Kurã ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Moroto, Ritonõpo ẽpataka, tomarykõ rĩko tuisa tõ mana okyno zupuhpyry pona, mame mokyro etapãko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Okyno munuru zokonaka arõko Oturukety imehxo exikety mana Tapyi taka. ");
INSERT INTO apyNT_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Tomahxiky ehxikãko mana munu ke, mame Ritonõpo ẽpataka munu pixo sapararahmãko mana 7me kamisa ẽpataka Osa Kurã tao. ");
INSERT INTO apyNT_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Morarame Ritonõpo ẽpataka ro munu pitiko rĩko mana apoto apõ potyry pokona moro Tapyi tao; munu akoĩpyry kuãnõko mana apoto apõ, okyno zahkatoh myhtokoxi Tapyi ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Mame okyno kasery apoĩko oturukety mana emero jahkatohme apoto apõ po, ");
INSERT INTO apyNT_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","sero okyno rĩko mana tynyrihpyry saaro zakorõ poko tyyrypyry korokapotohme. Morara tyrĩko oturukety mana ahno tõ rypyhpyry korokapotohme, mame tykorokasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Mame okyno apitorymã ritopõpyry saaro sero pui mũkuru arõko oturukety mana jarãnaka, pata poe jahkatohme. Mokyro onekarorykõme mana imoihmãkõ rypyhpyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Iirypyryme se pyra ro tuisame exikety ahtao, Ritonõpo omiry omipona pyra toehse ynororo ahtao, popyra ehtoh tyrise ahtao eya, morohne poko pyra ehtoko, tykase Ritonõpo ahtao, ");
INSERT INTO apyNT_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","mame tuaro tyripose ynororo ahtao iirypyryme aehtoh poko, poti enehnõko mana kure rokẽ exikety enehnõko mana tynekaroryme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Tomary rĩko mokyro mana toky zupuhpyry pona, mame Ritonõpo ẽpataka etapãko mana apoto apõ myhto inikahpozakoxi. Moroto okyno tõ etapãko mã toto jahkatohme. Inekaroryme mokyro mana tyyrypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Mame tomahxikyry ehxikãko oturukety mana okyno munuru ke, munu rĩko mana apoto apõ okyno zahkatoh potyry pona, munu akoĩpyry kuãnõko mana moro apoto apõ myhtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ahno nekarory sã osepeme ehtohme, mokyro poti kasery emero tyahkasẽme exĩko mana apoto apõ po. Moro saaro mokyro nekarohpyry zahkãko oturukety mana mokyro rypyry korokapotohme. Mame iirypyrykõ tykorokasẽme ropa exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Mame ahno iirypyryme se pyra ahtao ro, Ritonõpo omiry omipona pyra toehse ahtao, popyra ehtoh tyrise ahtao eya ipoko pyra tyripose ahtao Ritonõpo a, ");
INSERT INTO apyNT_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","tuaro tyripose ynororo ahtao iirypyryme toehtoh poko, okyno poti enehnõko mana kure exikety tynekaroryme Ritonõpo a tyyrypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Tomary rĩko mokyro mana okyno zupuhpyry pona, mame etapãko mana apoto apõ poe inikahpozakoxi. Moroto okyno tõ etapãko mã toto tyahkasẽme. ");
INSERT INTO apyNT_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Mame tomahxikyry ehxikãko oturukety mana okyno munuru ke, munu ritohme apoto apõ potyry pokona, okyno tõ zahkatoh pona. Mame munu akoĩpyry kuãnõko mana moro apoto apõ myhtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Moromeĩpo okyno kasery apoĩko mana emero jahkatohme apoto apõ po, ahno nekarory osepeme ehtoh riry samo. Typoxine moro ehtoh Ritonõpo Oesẽkõ zamaro mana. Moro sã ahno rypyry korokapõko oturukety mana, mame iirypyry tykorokasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Kaneru enepyryhtao ahno a tynekaroryme tyyrypyry korokapotohme kure rokẽ exikety enehnõko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Tomary rĩko mokyro mana kaneru zupuhpyry pona, mame apoto apõ poe inikahpozakoxi, okyno tõ etapatoh po, toky etapãko mana jahkatohme tynekaroryme tyyrypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Oturukety tomahxikyry ehxikãko mana kaneru munuru ke munu ritohme apoto apõ potyry pokona okyno tõ zahkatoh pona, munu akoĩpyry kuãnõko mana apoto apõ myhtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ahno nekarory osepeme ehtoh riry sã, kaneru kasery emero apoĩko oturukety mana jahkatohme apoto apõ po, imehnõ jahtyã maro ahno nekaroryme Ritonõpo a. Moro sã inekarory zahkãko oturukety mana ahno rypyry korokapotohme, mame iirypyhpyry tykorokasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Ahno nekarory se jahkatohme ynara toehse ahtao: Tymenekase ahno ahtao eneneme, yrome tynenehpyry onekaropyra ynororo ahtao, inetahpyry onekaropyra roropa ynororo ahtao iirypyryme mana, tuãnohsẽme. ");
INSERT INTO apyNT_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Imepyny a nuriame exikety tapose ahtao; onokyro ekepyry te, okyno ekepyry te, okoi tõkehko ekepyry, nuriame exĩko mokyro mana, tuãnohsẽme. ");
INSERT INTO apyNT_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Imepyny a ahno kyryry nuriame exikety, emero rokẽ tapose ahtao eya, nuriame exĩko mana, mame tuaro toehse ahtao inyrihpyry pokoino tuãnohsẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Imepỹ ahno a osenetupuhpyra tõmiry totapose ahtao otyro ritohme, mame tuenikehse moro poko, tuaro toehse ynororo ahtao, tuãnohsẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Azahkuru toehtoh waro toehse ahtao iirypyryme osekarõko mana, ");
INSERT INTO apyNT_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","tynekaroryme okyno enehnõko mana Ritonõpo a tyyrypyry korokapotohme, toiro kaneru, kaneru pyra ahtao poti etapatohme. Mame oturukety mokyro zahkãko mana iirypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Kaneru te, poti roropa onepekahsaromepyra tahtao asakoro utukuimo enehnõko mana, utukuimo pyra ahtao utuku tõ asakoro enehnõko mana tynekaroryme, toiro torõ inekaroryme tyyrypyry korokapotohme, zakorõ inekaroryme jahkatohme tytororo. ");
INSERT INTO apyNT_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Mokaro torõ tõ asakoro enehnõko mokyro mana oturukety a, toiro etapatohme tyyrypyry korokapotohme. Ipymyry tohkãko oturukety mana, yrome zupuhpyry onyhkohpyra mana. ");
INSERT INTO apyNT_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Munu zokonaka emãko mana apoto apõ zomye, akoĩpyry yhtõko apoto apõ myhtokoxi. Ahno rypyry korokapotohme, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Moromeĩpo zakorõ torõ etapãko oturukety mana jahkatohme, Ritonõpo nyripohpyry omi poe. Moro sã tynekarory zahkãko oturukety mana ahno rypyry korokapotohme, mame mokyro rypyry tykorokasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Tytineruke pyra toexiryke asakoro utuku te, utukuimo tõ onepekahsaromepyra ahtao, toiro kirume tiriiku apohpyry kurã enehnõko mana tynekaroryme tyyrypyry korokapotohme. Azeite onyripyra mana otoxie moro tiriiku tapose aexihpyry maro, ixtaratu roropa onyripyra mana, inekaroryme exiryke tyyrypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Moro tiriiku apoĩko oturukety mana, mame tomahpo zokonaka apoĩko mana jahkatohme apoto apõ po, imehnõ nekarotyã maro, tokarose aexihpyry Ritonõpo a. Moro enetupuhpotohme mana emero tokarose Ritonõpo a. Inekaroryme mana iirypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Moro sã morohne ekarõko oturukety mana Ritonõpo a ahno rypyry korokapotohme, mame iirypyry tykorokasẽme exĩko mana. Inekarohpyry akoĩpyry oturukety napyryme exĩko mana, tiriiku tõkehko ekarory samo ahno nekaroryme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ynara tyripose roropa Ritonõpo a Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Iirypyryme toehtoh se pyra ahno ahtao ro, iirypyryme toehse: tynekarory onenehpyra tokurehse ahtao, Ritonõpo kyryryme, mame moro epehmatohme, kaneru enehnõko mana, kure rokẽ exikety tynekaroryme Ritonõpo a. Mokyro epehpyry zae ehtoh kuhnõko mã toto pape eneryke Ritonõpo Tapyĩ tao. Moro poko okyno tõ epehpyry tymerose. Mokyro okyno totapasẽme exĩko ahno nekaroryme tyyrypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Moro motye oturukety a epehpyry enehnõko mokyro mana ipune ehtohme, imotye roropa 20%me. Mame kaneru apoĩko oturukety mana, etapãko mana, jahkãko roropa mana ahno rypyry korokapotohme; moro ke mokyro rypyry tykorokasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Imepỹ ahno, iirypyryme se pyra ahtao ro, iirypyryme toehse, Ritonõpo nyripohpyry omipona pyra, popyra ehtoh poko toehse ipoko pyra tyripose ahtao Ritonõpo a, moro tyrise eya exiryke iirypyryme mana, tuãnohsẽme. ");
INSERT INTO apyNT_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Naeroro tyyrypyry korokapotohme kaneru enehnõko mana kure rokẽ exikety oturukety a. Mokyro kaneru epehpyry zae ehtoh kuhnõko mã toto pape eneryke Ritonõpo Tapyĩ tao. Moro poko okyno tõ epehpyry tymerose mana. Mame mokyro okyno etapãko oturukety mana jahkatohme tynekaroryme Ritonõpo a ahno rypyry korokapotohme, iirypyryme toehse exiryke tyyrypyry poko se pyra ahtao ro. Mame mokyro rypyry tykorokasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Iirypyryme toehse ynororo Ritonõpo omiry omipona pyra, mame moro inekarory iirypyry korokapotohme mana. ");
INSERT INTO apyNT_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Mame tõturuse Ritonõpo Moeze a, ynara tyripotohme Izyraeu tomo a: ");
INSERT INTO apyNT_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Tyyrypyry korokapotohme okyno enehnõko ahno mana jahkatohme tynekaroryme Ritonõpo a ynara toehse ahtao: imepỹ mõkomory onekaropyra ropa toehse ahtao esemy a tynomose ahtao eya ikurãkatohme rokene. Mame imepỹ mõkomory onekaropyra ropa tokurehse ahtao tynomose ahtao axĩtao rokene, tineru epehmatohme imeĩpo te; imepỹ mõkomory apoiryhtao omatome. Mame imepỹ mõkomory apoiryhtao tonekunohse ahtao; ");
INSERT INTO apyNT_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ajohpe ahtao imepỹ mõkomory poko, tonese ropa ahtao: “Onenepyra exiase,” ãko ajohpe; morohne panõ riryhtao imepyny a, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","Tyyrypyry korokapotohme ropa mokyro tyyrypyhpyke exikety mokyro mõkomory ekarõko ropa mana esemy a, imepỹ kyryry ekarõko ropa mana tapoise tyya enekunopyry ke te, imepỹ kyryry ekarõko ropa mana tonese ropa aexihpyry, emero zae pyra toehtopõpyry kurãkãko ropa mana. Mame tynekarory ekaroryhtao tyyrypyry korokapotohme morohne tynematonanohtyã epehmãko ropa mana toiro kĩtu maro. ");
INSERT INTO apyNT_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Mame kaneru mũkuru enehnõko mana oturukety a, kure rokẽ exikety tynekaroryme Ritonõpo a tyyrypyry korokapotohme. Mokyro epehpyry kuhnõko ropa mana pape eneryke Ritonõpo Tapyĩ tao. ");
INSERT INTO apyNT_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Mame inekarory etapãko oturukety mana jahkatohme iirypyry korokapotohme, mame iirypyry korokãko Ritonõpo mana. ");
INSERT INTO apyNT_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Mame Ritonõpo tõturuse Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","ynara tyripotohme Arão tomo a imũkuru tõ maro okyno tõ zahkary poko tytororo: Onekarory zahkatoh tytororo apoto apõ po ẽmehnõko mana, morara ahtao apoto onezehkara tyripõko mase apoto apõ po. ");
INSERT INTO apyNT_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Imeĩpo mokyro tyahkase ahtao porehme oturukety tupoke mauru panono risẽ ke oruno oũko mana apoto apõ poe tyritohme apoto apõ myhtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Morarame tupõ myakamãko mana oruno arotohme mya osa kurã pona jarãnaka pata poe. ");
INSERT INTO apyNT_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Moro apoto jũme onezehkara matose apoto apõ po; kokoro rokẽ moro apoto ezehpyra ehtohme. Kokoro rokẽ apotopokõ rĩko oturukety mana apoto pona, tynekarory rĩko epona jahkatohme tytororo, ahno nekarory kasery zahkãko roropa mana osepeme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Jũme apoto ezehpyra ehtohme apoto apõ po; zemime rokẽ aehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ynara Ritonõpo nyripohpyry mana tiriiku tõkehko ekarory poko. Tiriiku tõkehko enehnõko oturuketõ mana tynekaroryme Ritonõpo a apoto apõ ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Toiro tomahpo apoĩko oturukety mana ahno nekarohpyry wino tiriiku apohpyry, azeite maro, ixtaratu maro, otoxie jahkatohme apoto apõ po enetupuhpotohme emero tokarose Ritonõpo a. Moro zatyry typoxine mana, Ritonõpo zamaro mana. ");
INSERT INTO apyNT_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Moro tiriiku tõkehko akoĩpyry oturuketõ napyryme exĩko mana, Arão pakomotyã napyryme. Moro ke pão rĩko mã toto iporutatoh maro pyra, otuhtohme osa kurã po, Tapyi Kurã zara po. ");
INSERT INTO apyNT_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Moro pão rĩko mã toto iporutatoh maro pyra. Moro zokonaka ahno nekarohpyry, tiriiku tõkehko oturuketõ napyryme, Ritonõpo kyryryme ro mana. Naeroro tomeseke ehtoko ipoko nuriame onyripyra ehtohme. Moro sã roropa ahno nekarohpyry tyyrypyry korokapotohme te, ahno nekarohpyry zae pyra toehtopõpyry kurãkapotohme roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Arão mũkuru tõ, ipakomotyã roropa emero Ritonõpo omi poe moro pão ohnõko mã toto. Moro ahno nekarohpyry Ritonõpo a, zokonaka tokarose eya xine zohkõme. Yrome popyra ehtoh exĩko mana imepyny a morohne tapose ahtao eya, tapiakase exiryke Ritonõpo kyryryme kurano. ");
INSERT INTO apyNT_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Tõturuse Ritonõpo Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","ynara tyripotohme Arão pakomotyamo a tapiakase toto ahtao aerohtohkõ poko, oturuketõme: Oturukety typopase ahtao toiro kirume tiriiku enehnõko mana tynekaroryme Ritonõpo a, tiriiku zahkatoh samo kokoro rokene. Moro tiriiku zokonaka jahkãko mana pakeimo, akoĩpyry jahkãko kokonie pukuro. ");
INSERT INTO apyNT_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Moro tiriiku, apohpyry otoxie exĩko azeite maro, mame tokeisẽme exĩko mana pãome orinato po. Mame oturukety mã moro pão tohtohkãko pisarara jahkatohme tynekaroryme Ritonõpo a. Moro typoxine exĩko Ritonõpo a mana. ");
INSERT INTO apyNT_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Sero ynyripohpyry jũme mana: Arão pakomotyã emero Oturukety imehxo toehse ahtao, moro rĩko mã toto. Moro inekarory tyahkasẽme exĩko emero inekaroryme Ritonõpo Jũme Exikety a. ");
INSERT INTO apyNT_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Moro tiriiku, oturukety nekarohpyry Ritonõpo a, tonahsẽme pyra mana, tyahkasẽme exĩko mana porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Mame Ritonõpo tõturuse Moeze a, ");
INSERT INTO apyNT_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","sero ripotoh ekarotohme Arão tomo a, imũkuru tõ maro ahno nekarory poko tyyrypyry korokapotohme: Okyno tonehse ahtao ahno a tyyrypyry korokapotohme etapãko mana Ritonõpo ẽpataka, apoto apõ myhto inikahpozakoxi. Moroto okyno tõ etapãko mã toto okyno tõ etapatoh po. Morohne ahno nekarory Ritonõpo kyryryme kure mana. ");
INSERT INTO apyNT_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Mokyro oturukety, okyno etapahpono ipũ õnõko mana osa kurã po, Tapyi Kurã zara po. ");
INSERT INTO apyNT_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Yrome imepyny a mokyro pũ tapose ahtao, popyra ehtoh oehnõko eya, moro ahno nekarohpyry Ritonõpo kyryryme kurã exiryke. Munu mokyro wino toepukase ahtao ahno zupõ pona, moro upo tukurikasẽme exĩko mana osa kurã po. ");
INSERT INTO apyNT_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Oripo ao, orino risẽ ao mokyro okyno pũ tahnose ahtao, moro oripo tytohkasẽme exĩko mana. Metau risẽ ao mokyro pũ tahnose ahtao, moro oripo akurihnõko, ikurikahpyryme exĩko mana tuna ke. ");
INSERT INTO apyNT_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Mokyro tõsẽ õnõko mã oturuketõ ekyry emero. Ritonõpo kyryryme kurã mana. ");
INSERT INTO apyNT_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Yrome okyno totapase ahtao ahno rypyry korokapotohme, mame imunuru tarose ahtao Tapyi Kurã taka ahno rypyry korokapotohme, mokyro pũ onõpyra matose, tyahkasẽme exĩko mana porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ynara tyripõko ase ahno nekarory poko zae pyra ehtoh korokapotohme. Sero onekarorykõ kure kuhse mana. ");
INSERT INTO apyNT_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Onekaroryme okyno totapasẽme exĩko apoto apõ myhto, okyno tõ etapatoh po, jahkatohme. Imunuru tukuãse apoto apõ ehpiry pokona. ");
INSERT INTO apyNT_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ikasery emero tyahkasẽme exĩko onekaroryme Ritonõpo a; arokyry te, ikasery roropa, zuahxirirĩ roropa tyahkasẽme exĩko mana, ");
INSERT INTO apyNT_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","epyasyhny asakoro ikasery maro ipoko exikety, erery zokonaka kurehxo exikety maro. ");
INSERT INTO apyNT_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Morohne zahkãko oturukety mana apoto apõ po tynekaroryme, tõsẽ samo Ritonõpo a. Ahno nekaroryme mana zae pyra toehtoh korokapory. ");
INSERT INTO apyNT_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Orutua kõ emero oturukety ekyryme ahtao otuhnõko mã toto moro poko. Osa kurã po rokẽ moro õnõko mã toto, kure kuhse moro ahno nekarohpyryme exiryke Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ritonõpo nyripohpyry ahno nekarohpyry poko tyyrypyry korokapotohme yroro mana ahno nekarohpyry zae pyra toehtoh korokapotohme: okyno pũ mokyro oturukety zohme exĩko mana, toerohse exiryke ahno rypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Okyno pihpyry mokyro oturukety kyryryme exĩko roropa mana typikase exiryke eya ipũ zahkatohme. ");
INSERT INTO apyNT_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Tiriiku risẽ roropa taise ahtao apoto po te, oripo ao te, orinato po roropa oturukety napyryme exĩko mana inekarohpyryme exiryke Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Yrome tiriiku tõkehko ahno nekarory tõ emero ahnopyra ahtao, azeite maro otoxie ahtao, azeite maro pyra ahtao, emero oturuketõ napyryme exĩko, tapiakase mana zokonaka ekarotohme emero oturuketomo a. ");
INSERT INTO apyNT_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Ynara tyripõko ase oya xine onekarorykõ poko osepeme ehtohme ekaroryhtao Ritonõpo Oesẽkomo a. ");
INSERT INTO apyNT_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Okyno enepyryhtao onekaroryme “Kure mase” katohme Ritonõpo a, mokyro okyno maro pão tõ enehnõko mase tiriiku risẽ azeite maro, yrome iporutatoh maro pyra; pão pipahmã enepyryhtao kure iporutatoh maro pyra, tahpase azeite pitiko ke; pão inunõ enepyryhtao kure tiriiku risẽme azeite maro otoxie. ");
INSERT INTO apyNT_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Morohne onekarory maro “Kure mase” katohme Ritonõpo a, pão enehnõko mase, tyrise iporutatoh maro. ");
INSERT INTO apyNT_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Morohne poe toiro anỹnõko mase emero pão tõ poe osehta onekaroryme Ritonõpo Oesẽkomo a; oturukety napyryme moro exĩko mana, okyno munuru tukuãse eya exiryke apoto apõ pona. ");
INSERT INTO apyNT_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Okyno pũ emero tõsẽme exĩko mana moro ẽmepyry ae ro totapase ahtao jahkatohme apoto apõ po; akoĩpyry onukurãkara exiko yrokokoro pona. ");
INSERT INTO apyNT_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Okyno tonehse ahtao ahno a tynekaroryme osepeme ehtohme: tõmihpyry omipona toehtohme te, typoe rokẽ ahtao roropa, mokyro pũ õnõko matose asakoro ẽmepyry ae; totapase ahtao te, yrokokoro akoĩpyry õnõko matose, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Yrome ẽmepyry oseruaono akoĩpyry nae ahtao tyahkasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Mokyro pũ tõse ahtao ahno a ẽmepyry oseruaõ po, popyra exĩko mana Ritonõpo a, inekarohpyry toiparo rokẽ exĩko roropa mana. Moro tõsemy akoĩpyry nuriame mana, mame tõse ahtao ahno a tuãnohsẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Tõsemy tapose ahtao nuriame exikety a, tyahkasẽme exĩko mana; tõsẽme pyra mana. Ahno nuriame pyra exiketõ emero tõnõko mã toto onekarorykõ osepeme ehtoh poko. ");
INSERT INTO apyNT_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Yrome moro tõse ahtao ahno a nuriame ahtao taroposẽme exĩko mana ypoetory tõ poe. ");
INSERT INTO apyNT_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Mame nuriame exikety tapose ahtao ahno a, ahno kyryry nuriame exikety te, onokyro kyryry nuriame exikety, moromeĩpo tõsẽ onyryhtao eya, ahno nekarohpyry Ritonõpo a osepeme ehtohme, mokyro aropõko ropa toh mana Ritonõpo poetory tõ poe. ");
INSERT INTO apyNT_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Mame tõturuse Ritonõpo Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","ahno zurutohme. Ynara tykase ynororo: Pui tõ kasery onõpyra ehtoko te, kaneru tõ kasery roropa, poti tõ kasery roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Okyno kasery tamoreme toorihse ahtao te, tosekase ahtao roropa onokyro tomo a, mokyro kasery ke emero rokẽ tyrĩko matose, yrome onõpyra rokẽ matose. ");
INSERT INTO apyNT_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Okyno totapase ahtao jahkatohme onekaroryme ya, Ritonõpo Oesẽkomo a, mame ikasery tõse ahtao ahno a taroposẽme ropa exĩko mokyro mana ypoetory tõ poe ikasery tõse eya exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Emero Izyraeu tõ esary po, okyno munuru torõ tõ munuru roropa onenahpyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Munu tonahse ahtao ahno a taroposẽme exĩko mokyro mana ypoetory tõ poe. ");
INSERT INTO apyNT_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Mame tõturuse Ritonõpo Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","ahno zurutohme, ynara tyripotohme eya xine: Okyno enepyryhtao jahkatohme onekaroryme Ritonõpo a osepeme ehtohme zokonaka apiakako tyoro sã ehtohme onekaroryme kurano. ");
INSERT INTO apyNT_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Oemary ke moro tõsẽ apoĩko mase tyritohme apoto pona onekaroryme Ritonõpo a; ipuropuru, ikasery maro ipuropuru poko onekaroryme kurã kuhse tokarosẽme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ikasery zahkãko oturukety mana apoto apõ po, yrome ipuropuru oturuketõ zohme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Okyno pety apotunuru wino ahno nekarohpyryme osepeme ehtohme, oturukety zohme exĩko mana, ");
INSERT INTO apyNT_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","okyno munuru ekarohpono Ritonõpo a, ikasery maro. ");
INSERT INTO apyNT_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Okyno puropuru, ipety maro ahno nekaroryme kurã Ritonõpo a, moro apoĩko Ritonõpo mana Izyraeu tõ wino ekarotohme oturuketomo a, Arão pakomotyamo. Jũme moro tõsẽ apoĩko mã toto ahno nekarohpyry osepeme ehtoh wino, Ritonõpo omi poe. ");
INSERT INTO apyNT_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Morohne okyno zokonaka, totapase ahtao jahkatohme ahno nekaroryme Ritonõpo a, Arão zohme mana, ipoenõ maro, ipakomotyã maro moro ẽmepyry poe tymenekase toto ahtao erohtohme oturuketõme. ");
INSERT INTO apyNT_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Moro ẽmepyry ae tymenekase toto ahtao Ritonõpo a erohtohme oturuketõme, Izyraeu tõ tyripose eya tynekarorykõ zokonaka ekarotohme eya xine. Moro Ritonõpo nyripohpyry jũme mana, aomipona Izyraeu tõ ehtohme ipakomotyã maro. ");
INSERT INTO apyNT_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Morohne Ritonõpo nyripohpyry ahno nekarory tõ poko jahkatohme tytororo te, inekarory tõ tiriiku tõkehko te, inekarory tõ tyyrypyry korokapotohme te, inekarory tõ zae pyra toehtopõpyry korokapotohme te, inekarory tõ oturuketõ typopase ahtao te, inekarory tõ osepeme ehtohme, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Morohne Ritonõpo nyripotyã tokarose Moeze a ypy Xinai po ona tonorẽ po, Izyraeu tõ tyripose ahtao Moeze a okyno tõ enehtohme jahkatohme tynekarorykõme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","— Arão tõ aroko imũkurukõ maro Ytapyĩ Kurã omõtoh taka. Oturukety zupõ aroko, azeite maro ipopatohme, pui mũkuru maro onekaroryme iirypyry korokapotohme te, asakoro kaneru tomo te, ruto roropa pehme pão tiriiku risẽ ke, iporutatoh maro pyra. ");
INSERT INTO apyNT_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Mame ahno emero oximõme enehpoko Tapyi Kurã ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moro tyrise Moeze a, Ritonõpo nyripohpyry omi poe, mame imoihmãkõ tõximõse toto Tapyi Kurã ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mame ynara tykase Moeze eya xine: — Ritonõpo nyripohpyry rĩko ase seromaroro. ");
INSERT INTO apyNT_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moeze a Arão tõ tonehpose tyya, mame aomi poe toekurikase toto. ");
INSERT INTO apyNT_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Moromeĩpo oturukety zupõ ke Arão tupohtose, kamisa ke, zamareary ke, upo mosahxo exikety ke, enara. Mame oturukety zupony tyrise eya, imetỹ eary roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ipuropuru apuru tyrise roropa eya Arão zupõme, ipoko Urim tyrise eya Tumĩ maro. ");
INSERT INTO apyNT_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Zupuhpyry pona zuhzõty tyrise eya, uuru risẽ pipahmã tymyhse eya ipokona enetupuhpotohme Arão menekatopõpyry poko oturuketyme. Morohne emero tyrise Moeze a Ritonõpo omi poe. ");
INSERT INTO apyNT_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moromeĩpo azeite tapoise Moeze a, Ritonõpo kyryry, Tapyi Kurã popatohme te, zao aexityã popatohme roropa emero porehme, Ritonõpo kyryryme rokẽ morohne ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","7me azeite pitiko ke apoto apõ typopase eya, ikyryry tõ roropa typopase, paxiha roropa osemahtopo te, osemahtoh apõ roropa typopase Ritonõpo kyryryme morohne ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Mame Arão zuhpokoxi azeite kurã tukuãse Moeze a, typopase ynororo oturuketyme aehtohme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Imeĩpo Arão mũkuru tõ tonehpose tyya. Toto tupohtose Moeze a oturukety zupõ ke, kamisa, zamareary maro, zupuhpyry tõ pona zuhzõty tyrise eya, Ritonõpo nyripohpyry omipona toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Mame pui mũkuru tapoise Moeze a iirypyrykõ korokapotohme. Tomarykõ tyrise Arão tomo a typoenõ maro okyno zuhpokoxi. ");
INSERT INTO apyNT_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mame mokyro pui mũkuru totapase Moeze a. Imunuru tapoise eya tyritohme tomahxikyry ke apoto apõ potyry pokona, asakoropane. Moro ke apoto apõ nuriame pyra tyripose eya Ritonõpo a. Imeĩpo munu akoĩpyry tukuãse eya apoto apõ myhtokoxi Ritonõpo nyripohpyry poko rokẽ moro apoto apõ ehtohme, nuriame pyra moro ehtohme roropa Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Imeĩpo okyno kasery tapoise Moeze a zuahxirirĩ te, erery kurehxo exikety te, epyasyhny asakoro, ikasery maro jahkatohme apoto apõ po. ");
INSERT INTO apyNT_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Akoĩpyry tarose eya, ipihpyry maro, ipũ maro, zuahxirirĩ maro, zuehtoto maro jarãnaka, pata poe jahkatohme, Ritonõpo nyripohpyry omi poe. ");
INSERT INTO apyNT_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Mame kaneru tapoise Moeze a etapatohme tynekaroryme jahkatohme. Arão tomo a imũkuru tõ maro tomary tõ tyrise okyno zuhpokoxi. ");
INSERT INTO apyNT_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mame kaneru totapase Moeze a, imunuru tukuãse eya apoto apõ ehpiry poro asakoropane. ");
INSERT INTO apyNT_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Mame okyno tysahsahkase Moeze a, zuahxirirĩ tukurikase eya, jaxiry tõ maro. Mame zupuhpyry tõkehko tyahkase eya apoto apõ po ikasery maro, akoĩpyry maro emero, Ritonõpo nyripohpyry omi poe. Moro inekarory tyahkase tõsẽme Ritonõpo a, typoxine nexiase eya, Ritonõpo zamaro. ");
INSERT INTO apyNT_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Mame zakorõ kaneru tonehse Moeze a Arão tõ popatohme Ritonõpo poko toto erohtohme. Tomary tõ tyrise Arão tomo a imũkuru tõ maro kaneru zuhpokoxi. ");
INSERT INTO apyNT_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mame okyno totapase Moeze a, imunuru pitiko tapoise eya Arão panary pona apotunuru wino tyritohme, Arão emary zũ pona apotunuru wino tyritohme te, ipupuru zũ pona tyritohme apotunuru wino roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Mame Arão mũkuru tõ tonehpose tyya Moeze a, munu ritohme ipanarykõ pona apotunuru wino te, emary zũ pona apotunuru wino tyritohme, ipupuru zũ pona apotunuru wino roropa, enara. Mame munu akoĩpyry tukuãse eya apoto apõ ehpiry tõ asakoropane pokona. ");
INSERT INTO apyNT_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ikasery tapoise eya te, arokyry te, ikasery roropa zuahxirirĩ poko exikety te, erery zokonaka kurehxo exikety te, epyasyhny asakoro ikasery maro te, ipety maro apotunuru wino. ");
INSERT INTO apyNT_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Mame toiro pão tapoise eya ruto wino, pão pehme exikety iporutatoh maro pyra, inekarotyã Ritonõpo a, toiro pão tapoise roropa eya tiriiku risẽ otoxie azeite maro te, toiro pão pipahmã tapoise roropa eya. Moro pão tõ oseruao tyrise eya okyno kasery pona, ipety pona roropa apotunuru wino exikety. ");
INSERT INTO apyNT_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Morohne tyrise Moeze a Arão tõ emary aka imũkuru tõ maro morohne ekarotohme tynekarorykõme kurã Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mame morohne tapoise ropa Moeze a Arão tõ emary wino jahkatohme apoto apõ po, tynekarory zahkatopõpyry po. Moro inekarohpyry oturuketõ popatohme nexiase Ritonõpo nyripohpyry poko toto erohtohme. Morohne tyahkase eya tynekaroryme tõsẽme, typoxine exiketyme, Ritonõpo zamaro exiketyme. ");
INSERT INTO apyNT_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Mame kaneru puropuru tapoise Moeze a ekarotohme Ritonõpo a tynekaroryme kurano. Moro okyno pũ Moeze zohme toehse Ritonõpo nyripohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mame azeite kurã tapoise Moeze a apoto apõ poe munu zokonaka maro Arão pona ematohme zupõ pona roropa, Arão mũkuru tõ pona te, toto zupõ pona roropa. Moro ke Arão tõ imũkuru tõ maro zupõkõ maro typopase toh nexiase Ritonõpo poko erohtohme, inyripohpyry omipona toehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ynara tykase Moeze Arão tomo a imũkuru tõ maro: — Tõsẽ arotoko Tapyi Kurã omõtoh taka, moroto ahnotohme, tõtohme oya xine pão maro, ruto ao exikety maro, onekaroryme mana sero poko ehtohme, Ritonõpo nyripohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Mame tõsẽ akoĩpyry pão akoĩpyry roropa jahkatoko. ");
INSERT INTO apyNT_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Tapyi Kurã omõtoh onurumekara matose 7me ẽmepyry ae sero oseahmatoh poko. 7me ẽmepyry aropõko matose otyhkatohme. ");
INSERT INTO apyNT_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Senohne tyrise kyya xine seroae, Ritonõpo nyripohpyry ae ro, oorypyrykõ korokapotohme eya. ");
INSERT INTO apyNT_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Tehme ehtoko taro Tapyi Kurã omõtoh tao 7me ẽmepyry ae 7me ikohmamyry maro Ritonõpo nyripohpyry omipona oehtohkõme ipunaka oorikyrykõino. Moro tokarose Ritonõpo a ya ourutohkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Morohne emero tyrise Arão tomo a, Ritonõpo omiry omi poe, inekarohpyry Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","7me ẽmepyry taropose eya xine oseahmary poko Arão tõ popatopõpyry poko, mame yrokokoro Arão tõ tykohmase Moeze a, imũkuru tõ maro Izyraeu tõ tamuximãkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ynara tykase ynororo Arão a: — Okyno tõ asakoro apoiko kure rokẽ exiketomo, toiro pui mũkuru etapatohme ahno rypyry korokapotohme te, toiro kaneru etapatohme jahkatohme tytororo, onekaroryme Ritonõpo Kuesẽkomo a. ");
INSERT INTO apyNT_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Moromeĩpo ahno tomo a okyno tõ enehpoko: toiro poti etapatohme jahkatohme ahno rypyry korokapotohme; toiro pui mũkuru te, toiro kaneru maro, kure exiketomo, toiro jeimamyry exiketomo etapatohme, jahkatohme tytororo; ");
INSERT INTO apyNT_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","toiro pui mũkuru roropa, toiro kaneru maro etapatohme jahkatohme ahno nekaroryme osepeme ehtohme. Mokaro jahkako onekarorykõme Ritonõpo a tiriiku tõkehko maro otoxie azeite maro. Morohne tyripoko eya xine, seroae osenepõko Ritonõpo exiryke eya xine. ");
INSERT INTO apyNT_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Moeze nenehpohpyry emero tonehse ahno a Ritonõpo Tapyĩ omõtoh taka. Mame tõximõse toto moroto Ritonõpo Tosẽkõ ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ynara tykase Moeze: — Moro tyripose Ritonõpo a oya xine tysaerehkatoh enepotohme oya xine. ");
INSERT INTO apyNT_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mame ynara tykase Moeze Arão a: — Ytoko apoto apõ pona onekarory zahkatohme oorypyrykõ korokapotohme, onekarory zakorõ roropa jahkako tytororo oorypyrykõ korokapotohme Ritonõpo a, oekyry tõ rypyry tõ maro, moro Ritonõpo nyripohpyryme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Mame Arão toytose apoto apõ pona, pui mũkuru totapase eya tynekaroryme Ritonõpo a, tyyrypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Okyno munuru tonehse Arão mũkuru tomo a eya. Tomahxikyry tohxikase eya munu ke pitiko tyritohme apoto apõ potyry asakoropane pokona, mame munu akoĩpyry tukuãse eya apoto apõ myhtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Mame apoto apõ po ikasery tyahkase eya, epyasyhny tõ maro, erery zokonaka kurehxo exikety maro Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Mame osa mya tapyi tõ poe okyno pũ tyahkase Arão a ipihpyry maro. ");
INSERT INTO apyNT_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Imeĩpo kaneru totapase Arão a tynekaroryme jahkatohme tytororo. Okyno munuru tonehse imũkuru tomo a eya ematohme apoto apõ ehpiry asakoropane pokona. ");
INSERT INTO apyNT_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Mame okyno zupuhpyry tonehse eya xine Arão a okyno sahsahkasamo akoĩpyry maro jahkatohme apoto apõ po. ");
INSERT INTO apyNT_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Mame zuahxirirĩ tukurikase eya kaneru axiry tõ maro; morohne tyahkase roropa eya tynekarory akoĩpyry po, apoto apõ po. ");
INSERT INTO apyNT_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Moromeĩpo ahno nekarory tonehse Arão a. Poti tapoise eya osemazuhme ahno rypyry korokapotohme. Mokyro totapase eya, tyahkase roropa eya ahno nekaroryme Ritonõpo a, tynekarohpyry zahkatopõpyry samo tyyrypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Mame okyno tapoise eya etapasemy jahkatohme tytororo, totapase eya tynekaroryme Ritonõpo a, inyripohpyry omi poe. ");
INSERT INTO apyNT_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Mame tiriiku tõkehko tonehse eya tynekaroryme Ritonõpo a, tomary ao moro tapoise eya apoto apõ pona tyritohme, jahkatohme (moro nexiase imepỹ jahkatoh maro, kokoro rokẽ pakeimo tyahkase eya xine). ");
INSERT INTO apyNT_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Pui mũkuru totapase Arão a, kaneru roropa ahno nekaroryme osepeme ehtohme. Munu tonehse ipoenomo a, mame moro munu tukuãse eya apoto apõ pona. ");
INSERT INTO apyNT_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Mokaro okyno tõ asakoro kasery tonehse Arão mũkuru tomo a, arokyry maro, ikasery zuahxirirĩ poko te, epyasyhny tomo, erery zokonaka kurehxo exikety, ");
INSERT INTO apyNT_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","morohne tyrise Arão a okyno tõ puropuru pona arotohme apoto apõ pona. Ikasery tyahkase eya apoto apõ po, ");
INSERT INTO apyNT_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","yrome ipuropuru, ipety tõ roropa apotunuru wino tokarose Arão a Ritonõpo a tynekaroryme kurano. Moro onyahkara nexiase, tukurãkase eya oturuketõ zohme, Moeze nyripohpyry omi poe. ");
INSERT INTO apyNT_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Moromeĩpo tõtyhkase Arão ahtao morohne ekarory poko Ritonõpo a, tomary tanỹse eya ahno tõ ẽpataka kure toto ripotohme Ritonõpo a. Mame tyhtose ynororo, apoto apõ poe. ");
INSERT INTO apyNT_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moeze maro tomõse ynororo Ritonõpo Tapyĩ taka; tutũtase ropa tahtao xine kure ahno ripotohme, saerehkatoh tonepose Ritonõpo a imoihmãkomo a porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Mõtoino rokẽ apoto tõtumakase Ritonõpo ẽpataka, mokaro nekarohpyry tonahkase emero, ikasery tõkehko apoto apõ po. Moro eneryke tyya xine kui tykase Izyraeu tomo tãkye toehtohkõke, tosekumuru po typorohse toto tõmytykõ po nono pokoxi Ritonõpo eahmatohme. ");
INSERT INTO apyNT_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Mame ixtaratu zahkatoh tapoise Natape tomo a Apiu maro, Arão mũkuru tomo; ixtaratu tyrise eya xine zaka, apoto tyrise roropa eya xine enehtohme Ritonõpo Tosẽkõ ẽpataka, tynekarorykõme. Yrome moro tyrise eya xine Ritonõpo nyripohpyry omipona pyra. Morara exiryke mokaro nekarohpyry Ritonõpo zamaro pyra kynexine. ");
INSERT INTO apyNT_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Mõtoino rokẽ apoto tutũtase Ritonõpo ẽpatae. Mokaro tyahkase; toorihse toto moroto Ritonõpo ẽpatao. ");
INSERT INTO apyNT_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mame ynara tykase Moeze Arão a: — Sero poko oturũko Ritonõpo nexiase kyya xine ynara tykase ahtao: “Oehketõ upũtokoxi tomeseke toexirykõ se mã toto zae toehtohkõme ipunaka, orihpyra toehtohkõme. Imoihmãkõ ẽpataka imehxo jyripory se ase ypoetory tomo a.” Yrome mynyhme rokẽ Arão kynexine. ");
INSERT INTO apyNT_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mame Misaeu tõ tykohmase Moeze a, Euzapã maro, Uzieu mũkuru tomo, Arão ekyry. Ynara tykase eya xine: — Oekyry tõ ekepyry apoitoko Tapyi Kurã ẽpatae arotohme mya jarãnaka pata poe. ");
INSERT INTO apyNT_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Toytose toto, mokaro ekepyry tõ tapoise eya xine zupõ poko, toto arotohme jarãnaka pata poe, Moeze omi poe. ");
INSERT INTO apyNT_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mame ynara tykase Moeze Arão tomo a ipoenõ maro Ereaza, Itamaa maro: — Imehnõ Izyraeu tõ omũkuru tõ hnamõko mã toto taorihmapose toto exiryke Ritonõpo a apoto ke. Yrome amarokõ oũsetykõ ekurinãko ro matose, oupõkõ onyxihkara ehtoko oemynyhmarykohtao, oorikyrykõino, typoetory tõ zehno Ritonõpo exiryino roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ritonõpo Tapyĩ Kurã omõtoh onurumekara ehtoko oorikyrykõino, typopase oexirykõke azeite kurã ke, Ritonõpo kyryry ke, Oesẽkomo. Mame Moeze omipona toehse toto, oseruaõkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ynara tykase Ritonõpo Arão a: ");
INSERT INTO apyNT_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","— Ytapyĩ Kurã taka omõpyra ehtoko, omoro te, opoenõ roropa eukuru jehnahpyry tõse ahtao oya xine; moro riryhtao oya xine orihnõko matose. Opoenomo a, apakomotyamo a roropa moro jomiry omipona tyripotoko jũme. ");
INSERT INTO apyNT_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Tuaro oehtohkõ se ase: zae ehtoh ya oxisã pyra mana popyra ehtoh maro te; nuriame pyra ehtoh tyoro, nuriame ehtoh sã pyra mana. ");
INSERT INTO apyNT_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Mame Izyraeu tõ amorepãko matose emero ynekarohpyry poko eya xine. Ywy, Ritonõpo, morohne ekaroase Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mame ynara tykase Moeze Arão tomo a, Ereaza maro, Itamaa maro, Arão mũkuru tõ isene ro exiketomo: — Tiriiku akoĩpyry apoitoko, ahno nekarohpyry Ritonõpo a, pão ritohme iporutatoh maro pyra. Mame moro pão enahtoko apoto apõ pũto awahtao xine Ritonõpo kyryry kurãme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ritonõpo esary kurã po moro pão ohnõko matose, tokarose exiryke Ritonõpo a ourukõme ehtohme opoenõkõ maro. Moro tyripose Ritonõpo a ya. ");
INSERT INTO apyNT_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Okyno puropuru, ipety maro õtykõme exĩko mana, tanỹse aexihpyry Ritonõpo ẽpataka. Õtyme mana omũkuru tõ maro oekyry tõ maro. Tõnõko matose osa kurã po; Izyraeu tõ nekaroryme kurã mana osepeme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Moro okyno pety enehnõko Izyraeu tõ mana, ipuropuru maro, ikasery tyahkase ahtao anỹtohme Ritonõpo ẽpataka. Moro okyno pũ tanỹse aexihpyry õtykõme mana jũme, apakomotyã roropa Ritonõpo nyripohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mame poti tupise Moeze a ahno rypyry korokapotohme. Zuaro toehse tahtao mokyro jahkahpyry poko porehme, tohne toehse Moeze Ereaza tõ poko Itamaa maro, tõturupose ynororo eya xine: ");
INSERT INTO apyNT_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","— Oty katohme mokyro onõpyra matokene osa kurã po, tokarose exiryke ahno rypyry korokapotohme? Ahno nekarohpyry kurãme mana, tokarose Ritonõpo a oya xine, otuhtohme Ritonõpo ẽpataka ahno rypyry korokatohme eya. ");
INSERT INTO apyNT_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Mokyro munuru anaropyra exiryke Tapyi Kurã taka; ipũ tõsẽme nexiase oya xine moroto, ynyripohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Ynara tykase Arão eya: — Seroae okyno tõ tonehse ahno a jahkatohme tynekarorykõme Ritonõpo Kuesẽkomo a, tyyrypyrykõ korokapotohme, imehnomo a roropa tynekarorykõ roropa tonehse jahkatohme tytororo, yrome morohne tyrise ahtao ro popyra ehtoh toehse ya. Naeroro ahno nekarohpyry pũ tõse ahtao ya seroae, iirypyrykõ korokapotohme, moro Ritonõpo zamaro exiry? Naary rokene. ");
INSERT INTO apyNT_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mame “To” tykase rokẽ Moeze, tãkye toehse ropa ynororo kure tozuhse exiryke Arão a. ");
INSERT INTO apyNT_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ritonõpo, Izyraeu tõ Esẽ, tõturuse Moeze tomo a Arão maro ");
INSERT INTO apyNT_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","ynara tyripotohme Izyraeu tomo a: Okyno tõ onokyro tõ roropa kure mã toto õtykõme, ");
INSERT INTO apyNT_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ipepexipuhturu tãtapiakase ahtao, kayhkayhkame roropa toto ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Yrome kameru tõ onõpyra matose, koeriu tõ roropa, repere tõ maro, ynara exiryke, kayhkayhãko mã toh repe yrome ipepexipuhturu atapiakara exiketõme mã toto. Oya xine mokaro nuriame mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Poinokoimo pũ onõpyra matose. Oya xine poinoko tõ nuriame mã toto, ipepexipuhturu tãtapiakase repe, yrome kayhkayhkara mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Mokaro pũ onõpyra ehtoko, toto ekepyry anapopyra ehtoko toorihse ahtao. Mokaro emero nuriame mã toto oya xine. ");
INSERT INTO apyNT_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Emero rokẽ kana tõ õnõko matose tozakoke ahtao, ipuhturu nae ahtao roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Yrome onokyro tõ nakuaõkõ tozakoke pyra ahtao, tupuhtuke pyra, mokaro onõpyra ehtoko; ");
INSERT INTO apyNT_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","mokarohne nuriame mã toto oya xine. Naeroro toto onõpyra ehtoko, ekepyry anapopyra ehtoko toorihse ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Nakuaõkõ emero onõpyra ehtoko tozakoke pyra toto ahtao, ipuhturu maro. ");
INSERT INTO apyNT_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Ynara torõ tõ onõpyra ehtoko, nuriame mã toto oya xine: piano tomo, kurumu tomo, pianoimo tomo, ");
INSERT INTO apyNT_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","asore tomo, parakão tomo te, ");
INSERT INTO apyNT_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","kurou tomo te, ");
INSERT INTO apyNT_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","awexituruze tomo, suhsuku tomo, kumarako panõ komo muramura tomo, ");
INSERT INTO apyNT_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","moxo tomo, kurou marĩjo tomo, ipi tomo, ");
INSERT INTO apyNT_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","kararia tomo, perikano tomo te, imotatyã enahnanomo, ");
INSERT INTO apyNT_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","sekonia tomo, akarara tomo te, poupa tomo; rere tõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Nuriame oya xine onokyro tõ emero nono po ytoketomo te, taporihke exiketõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Yrome onokyro tõ tyaxike exiketomo pyhseky kananomo, mokaro õnõko matose. ");
INSERT INTO apyNT_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Taparara tõ emero tõnõko matose, kiriru tõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Yrome imehnõ onokyro tõ ytoketomo nono po, taporihke ytoketõ roropa nuriame mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","Okyno tõ ekepyry tapose ahtao oya nuriame exĩko mase xixi omõtoh pona: onokyro tomo te, okyno tõ roropa typepexipuhturu atapiakara exiketomo te, kayhkayhkara roropa exiketomo te, emero tupupuke asakoropane te, tomahtopuke exiketomo. Mokaro ekepyry tapoise ahtao oya xine oupõkõ ikurikatoko, mame nuriame exĩko ro mase xixi omõtoh pona. Mokaro nuriame oya xine mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","Onokyro tõ esyryhmaketõ nono poro ynara nuriame mã toto oya xine: oruko tomo te, rakaatixa tomo, mũpo tomo, toupeira tomo te, zuana tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Mokaro tapose ahtao oya xine toorihse ahtao nuriame exĩko matose xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Mokaro ekepyry toepukase ahtao mõkomo pona, nuriame exĩko mana: wewe risẽme ahtao te, kamisa te, ipihpyry risemy te, kamisa topuxiximano te, emero rokene. Mame ikurãkatohme ropa morohne tyritoko tuna kuaka, yrome nuriame exĩko ro mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Mokaro ekepyry toepukase ahtao oripo orino risẽ aka, emero moro ao exikety nuriame exĩko mana. Mame moro oripo itohtohkatoko. ");
INSERT INTO apyNT_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Tuna moro oripo ao exikety epukaryhtao tonahsẽ pona, moro tonahsẽ nuriame exĩko mana. Emero eukuru moro oripo ao exikety nuriame mana. ");
INSERT INTO apyNT_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Nuriame exikety ekepyry toepukase ahtao mõkomo pona nuriame exĩko mana. Orino risẽme ahtao, orinato tõkehko nuriame exĩko mana, typahsẽme exĩko mana; ");
INSERT INTO apyNT_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","tuna enatyryme ahtao, tuna ẽ konõto ahtao roropa kure ro mã tuna moro aono, yrome nuriame aexihpyry apohpono nuriame exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Nuriame exikety ekepyry toepukase ahtao ipuhturu pona, tarykasẽ pona kure ro mana, nuriame pyra; ");
INSERT INTO apyNT_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","yrome moro ipuhturu tõ ehxikaryhtao tuna ke mame nuriame exikety ekepyry toepukase ahtao epona, nuriame exĩko mã morohne. ");
INSERT INTO apyNT_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Okyno tõsẽme exikety tamoreme toorihse ahtao, mokyro ekepyry apohpono nuriame exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Mame mokyro pũ tõse ahtao ahno a tupõ kurikãko mana, mame nuriame exĩko mana xixi omõtoh pona; mokyro okyno ekepyry tupuimase ahtao ahno a tupõ kurikãko ropa mana, mame nuriame exĩko roropa mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Onokyro tõ nono poro ytoketõ onõpyra ehtoko; nuriame mã toto oya xine. ");
INSERT INTO apyNT_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Sararahme ytoketõ onõpyra ehtoko te, ytoytoketõ asakoropane pupu po te, tuhke tupupurukõ po roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Nuriame pyra ehtoko, mokarohne onõpyra ehtoko ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ywy ase Ritonõpo Oesẽkomo; anamonohpyra ehtoko jomiry omipona, zae rokẽ jexiryke nuriame pyra. Naeroro nuriame pyra ehtoko ysamo, mokarohne nuriame exiketõ poko pyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ywy ase Ritonõpo, kuenepyatose Ejitu poe Oesẽkõme jehtohme. Naeroro nuriame ehtoh poko pyra ehtoko kure rokẽ ehtoh poko jehtoh samo. ");
INSERT INTO apyNT_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Morohne ynyripohpyry oya xine onokyro tõ poko, torõ tõ poko, isene exiketõ poko nakuaõkõ poko, nono poro ytoketõ poko, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Morohne ãmorepatohkomo nuriame pyra ehtoh poko te, nuriame ehtoh poko roropa, onokyro tõ pũ tõsẽme ehtoh poko, tyorõ pũ onõpyra oehtohkõme, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Mame tõturuse Ritonõpo Moeze a ynara tyripotohme ");
INSERT INTO apyNT_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Izyraeu tomo a: Nohpo enururuhtao orutuame, 7me ẽmepyry aropõko mana nuriame toehtoh poko, munume exikety samo nuno po. ");
INSERT INTO apyNT_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Mame ẽmepyry 8mã po enurusenã aĩpotapihpyry sahkãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Moromeĩpo munu topuru toepukase exiryke tehme exĩko mana 33me ẽmepyry pona. Morara ahtao Ritonõpo kyryry anapopyra mana. Ytosaromepyra roropa mana Tapyi Kurã pona. ");
INSERT INTO apyNT_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ẽxiry tonuruse ahtao 14me ẽmepyry aropõko mana tehme toehtoh poko, munume exikety samo nuno po. Moromeĩpo munu topuru toepukase exiryke asakoro nuno aropõko mana nuriame exikety samo. ");
INSERT INTO apyNT_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Moromeĩpo moro ẽmepyry tõ taropose ahtao ekurãkatohme, orutuame tonuruse ahtao, nohpo tonuruse ahtao, ytõko mokyro nohpo mana Tapyi Kurã omõtoh taka kaneru ekarotohme oturukety a toiro jeimamyry nae exikety tynekaroryme jahkatohme tytororo te, toiro utuku maro, utuku pyra ahtao utukuimo tynekaroryme tyyrypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Mokaro ekarõko oturukety mana Ritonõpo a nohpo rypyry korokapotohme. Mame ikurãkahpyryme exĩko mokyro nohpo mana, nuriame pyra. Moro Ritonõpo nyripohpyry nohpo poko tonuruse ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Tytineruke pyra nohpo ahtao kaneru epekahtohme, asakoro utukuimo enehnõko mana ekarotohme oturukety a, utukuimo pyra ahtao utuku tõ enehnõko mana; toiro tynekaroryme jahkatohme tytororo, zakorõ tynekaroryme tyyrypyry korokapotohme. Morohne ekaroryke oturukety a nohpo rypyry korokãko Ritonõpo mana, ikurãkãko ropa mana, nuriame pyra aehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Mame tõturuse Ritonõpo Moeze tomo a Arão maro ynara tyripotohme: ");
INSERT INTO apyNT_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Tyrohsẽ hpe toehse ahno ahtao ipihpyrykõ poko, tyaose ahtao, zuzu nae ahtao, apurotoh nae ahtao, otarame imehnõ apoipõko mana. Mokyro aroko Arão a, Arão pyra ahtao imũkuru a, oturuketyme ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Mokyro pihpyry enẽko oturukety mana, mame moro ãtahporohpyry po ihpoty karimutume toehse ahtao, moro tyrohsẽ ikurohtaka ahtao roropa, otarame atahpahnõko mana imehnõ pokona. Naeroro, “Nuriame mana,” ãko oturukety mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Yrome moro ãtahporohpyry karimutume ahtao, zumo pyra roropa ahtao ihpoty moro karimutume pyra roropa ahtao, mokyro apiakãko oturukety mana, ahno maro pyra ehtohme 7me ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Mame 7me ẽmepyry taropose ahtao mokyro pihpyry enẽko ropa oturukety mana; ãtahporohpyryhtao, etyorõmara roropa ahtao, toiroro mokyro ripõko ropa mana 7me ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Mame 7me ẽmepyry taropose ahtao mokyro pihpyry enẽko ropa oturukety mana; moro ãtahporohpyry pohto toehse ahtao, atahpahpyra roropa ahtao ipihpyry pokono, ekurãkãko ropa mana. Tupõ kurikãko mokyro mana, nuriame pyra mokyro ekarõko oturukety mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Yrome imeĩpo moro ãtahporohpyry tãtahpahse ahtao mokyro pihpyry pokono, ytõko ropa mana oturuse oturukety a. ");
INSERT INTO apyNT_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Mokyro pihpyry enẽko oturukety mana, tãtahpahse ahtao ipihpyry poko ahtao, mokyro “Nuriame mana,” ãko oturukety mana; moro tyrohsẽ popyra mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Tyrohsẽke popyra ahno ahtao ipihpyry poko, mokyro arotoko oturukety a. ");
INSERT INTO apyNT_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Mokyro pihpyry enẽko mana, ipihpyry tyaose ahtao karimutume roropa, ihpoty moro poko karimutume ahtao roropa, muretano hpe roropa ahtao kunu ke pehme, ");
INSERT INTO apyNT_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","tyrohsẽ popyra mana, moino ro. Mokyro “Nuriame mana,” ãko oturukety mana. Yrome mokyro toiroro anapiakara mana, tuaro emero exiryke, nuriame mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Tyrohsẽ popyra toehse ahtao ahno pihpyry poko, mame tãtahpahse zoko poko porehme, zupuhpyry poe ipupuru pona, ");
INSERT INTO apyNT_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","mokyro enẽko oturukety mana. Ajohpe pyra, moro tyrohsẽ tãtahpahse zoko poko porehme, mame ipihpyry karimutume toehse, morara ahtao mokyro nuriame pyra mana, kure rokene. Mokyro ekarõko nuriame pyra oturukety mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Yrome tõsẽxipuhtutase ahtao ipihpyry poko nuriame exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Mokyro pihpyry enẽko ropa oturukety mana. Moro ẽxipuhtutasẽ eneryhtao tyya, “Nuriame mose,” ãko mana. Tõsẽxipuhtutase ahtao, tyrohsẽ popyra enetupuhnõko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Yrome totyhse ropa ahtao, karimutume toehse ahtao osenepõko mokyro mana oturukety a, ");
INSERT INTO apyNT_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","moro enepõko ropa mana. Mame moro karimutume toehse ahtao, mokyro kure rokẽ mana, nuriame pyra ekarõko oturukety mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Ahno zuzu hpe ahtao, mame totyhse ropa, ");
INSERT INTO apyNT_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","yrome moro esahpokoxi tyaose ahtao karimutume roropa te, kamirarame ahtao roropa, moro enepõko mana oturukety a. ");
INSERT INTO apyNT_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Moro enẽko oturukety mana, muretano hpe zumo ahtao te, ihpoty moroto karimutume ahtao, “Nuriame mase,” ãko oturukety mana. Moro tyrohsẽ popyra mana, toehpitose moro zuzu hpe toehse ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Yrome moro eneryhtao oturukety a ihpoty moro ao karimutume pyra te, muretano hpe zumo pyra, yrome ipihpyry moro karimutume ahtao mokyro toiroro tyripõko mana 7me ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Moro muretano tãtahpahse ahtao, tyrohsẽ popyra enetupuhnõko oturukety mana, “Nuriame mase,” ãko eya. ");
INSERT INTO apyNT_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Yrome moro muretano atahpahpyra ahtao, etyorõmara roropa ahtao, tosahpyry rokẽ tynomose muretano a ipihpyry poko; “Mokyro kure mana, nuriame pyra,” ãko oturukety mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ahno pihpyry tyahse ahtao, mame moro jatyhpyry muretano sã toehse ahtao kamirarame, kamirarame pyra ahtao karimutume, ");
INSERT INTO apyNT_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","moro ipihpyry enẽko oturukety mana. Ihpoty moro poko karimutume ahtao te, moro muretano zumo ahtao, tyrohsẽ popyra mana toehpitose jatyhpyry maro, “Mokyro nuriame,” ãko oturukety mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Yrome moro muretano eneryhtao oturukety a, ihpoty enẽko mana karimutume pyra, moro muretano zumo pyra roropa te, moro kamirarame hkopyra toehse roropa ahtao, mokyro apiakãko mana toiroro ehtohme 7me ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Mame 7me ẽmepyry taropose ahtao mokyro enẽko ropa oturukety mana. Moro muretano tãtahpahse ahtao tyrohsẽ popyra mana. Naeroro, “Nuriame mase,” ãko oturukety mana eya. ");
INSERT INTO apyNT_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Yrome moro muretano atahpahpyra ahtao, etyorõmara roropa ahtao, kamirarame hkopyra ahtao, tyaose rokẽ mana jatyhpyry poe. Naeroro, “Mokyro kure, nuriame pyra,” ãko oturukety mana esahpyry rokẽ exiryke jatyhpyry po. ");
INSERT INTO apyNT_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ahno muretano hpe toehse ahtao, orutua te nohpo roropa zupuhpyry poko te, jematary poko ahtao roropa, ");
INSERT INTO apyNT_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","moro ipihpyry enẽko oturukety mana. Moro muretano zumo ahtao, ihpoty moro poko seweme ahtao, tuhke pyra roropa ahtao, tyrohsẽ popyra mana. “Mokyro nuriame,” ekarõko oturukety mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Yrome moro ipihpyry eneryhtao eya, muretano zumo pyra ahtao te, yrome ihpoty xinukutumã moro poko onenepyra ahtao mokyro apiakãko mana toiroro ehtohme 7me ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Mame 7me ẽmepyry taropose ahtao moro muretano enẽko ropa oturukety mana. Atahpahpyra moro muretano ahtao, ihpoty sewemã pyra ahtao roropa ipoko te, zumo exipyra moro ahtao roropa ");
INSERT INTO apyNT_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","zũsety sahkãko mokyro mana zupuhpyry poko, jematary poko ahtao, yrome muretano esary poko onysahkara mana. Mame toiroro mokyro ripõko ropa oturukety mana 7me ẽmepyry pona ropa. ");
INSERT INTO apyNT_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Morarame 7me ẽmepyry taropose ahtao ipihpyry enẽko oturukety mana. Atahpahpyra moro muretano ahtao, zumo exipyra roropa ahtao, “Kure mana, nuriame pyra,” ãko oturukety mana. Tupõ kurikãko mokyro mana, mame nuriame pyra exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Yrome, moromeĩpo moro muretano tãtahpahse ahtao, ");
INSERT INTO apyNT_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","mokyro pihpyry enẽko oturukety mana. Moro eneryhtao eya, ajohpe pyra moro muretano tãtahpahse ahtao, ũsehpo sewemã onupipyra mana; mokyro nuriame mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Yrome moro muretano eneryhtao oturukety a, atahpahpyra eneryhtao, moroto ũsehpo kurã ahtãko ropa, moro muretano etyhnõko mana. Mokyro kure, “Nuriame pyra mana,” ekarõko oturukety mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Ahno pihpyry tyrohsẽ hpe ahtao, orutua te, nohpo ahtao roropa, ipihpyry karimutume toehse ahtao, ");
INSERT INTO apyNT_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","mokyro enẽko oturukety mana. Moro tyrohsẽ karimutumã sã rokẽ ahtao kure ro mana. Nuriame pyra mokyro mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Mame orutua zũsety toepukase ahtao, merehkusasame toehse ynororo ahtao, kure ro mana, nuriame pyra. ");
INSERT INTO apyNT_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Yrome zũsety esahpokoxi zupuhpyry poko tyrohsẽ toehse ahtao tahpiremy, tyrohsẽ popyra mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Mokyro enẽko oturukety mana, moro tahpirẽ eneryhtao tyya zupuhpyry poko, ẽmyty poko ahtao, tyrohsẽ ipihpyry poko samo, ");
INSERT INTO apyNT_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","tyrohsẽ popyra mana. Mokyro orutua nuriame mana. “Nuriame mokyro mana,” ãko oturukety mana moro tyrohsẽ exiryke tyya zupuhpyry poko. ");
INSERT INTO apyNT_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Tyrohsemy a tapoise typihpyry pokona ahtao, upo ixihpyryme exikety amurũko mana, tũsety onekurinara mana, tõmyty zokonaka zopino apurũko mana. Mame kohtãko mana: “Nuriame! nuriame!” ");
INSERT INTO apyNT_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Mame tyrohsẽ popyra nae ahtao nuriame exikehpyra mokyro mana, toiroro osesarĩko mana mya, imehnõ tapyĩ poe. ");
INSERT INTO apyNT_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Mame upo tymapiuhtase ahtao, kaneru hpoty risemy te, mauru panõ ahtao te, ");
INSERT INTO apyNT_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","kamisa poko ahtao roropa mauru panono risẽme ahtao te, kaneru hpoty risẽme ahtao te, okyno pihpyry poko ahtao te, okyno pihpyry risẽme ahtao roropa, ");
INSERT INTO apyNT_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","moro imapiuhtahpyry ezuezume ahtao, kamirarame ahtao roropa, moro imapiuhtahpyry enepotoko oturukety a. ");
INSERT INTO apyNT_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Moro mõkomo enẽko oturukety mana, imapiuhtahpyry. Mame tyorõ pona apiakãko mana 7me ẽmepyry pona amerehmã pona. ");
INSERT INTO apyNT_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Mame 7me ẽmepyry taropose ahtao imapiuhtahpyry enẽko mana; mame tãtahpahse ahtao moro imapiuhtahpyry tyrohsẽ popyra mana; moro upo te, moro kamisa, okyno pihpyry, mõkomo okyno pihpyry tyrihpyry ahtao, moro nuriame mana. ");
INSERT INTO apyNT_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Mame moro tymapiuhtase exikety zahkãko oturukety mana. Moro imapiuhtahpyry tyrohsẽme popyra mana, enahkatoko apoto ke. ");
INSERT INTO apyNT_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Yrome moro upo tonese ahtao oturukety a, kamisa te, okyno pihpyry risẽme roropa ahtao, mame moro imapiuhtahpyry atahpahpyra ahtao, ");
INSERT INTO apyNT_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","moro kyryry ikurikapõko mana, mame torõ pona apiakãko mana 7me ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Imeĩpo moro kyryry enẽko ropa mana. Mame moro imapiuhtahpyry etyorõmara ahtao, atahpahpyra ahtao ro, nuriame mana. Jahkatoko apoto ke. Moro imapiuhtahpyry tyrohsẽme popyra mana zao ahtao te, jarao ahtao roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Yrome moro kyryry tonese ahtao oturukety a, mame moro imapiuhtahpyry kamirarame hkopyra te, ezuezume hkopyra toehse ahtao ikurikaxĩpo moro imapiuhtahpyry rokẽ ixihkãko mana: okyno pihpyry poe, kamisa poe, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Yrome moromeĩpo moro kyryry poko imapiuhtahpyry toehse ropa ahtao moro imapiuhtahpyry tyrohsẽme popyra mana. Naeroro moro kyryry jahkatoko apoto ke. ");
INSERT INTO apyNT_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Moro kyryry tukurikase ahtao moro imapiuhtahpyry osenepyra toehse ahtao, ikurikatoko ropa toiro, kure ehtohme ropa, nuriame pyra ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ynara rokẽ inyripohpyry imapiuhtahpyry poko upo poko ahtao, kaneru hpoty risẽme ahtao, mauru panõ risẽme ahtao te, kamisa poko ahtao te, mõkomo poko roropa okyno pihpyry risẽme ahtao, enetupuhtohme kure ehtoh poko te, nuriame ehtoh poko roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ritonõpo tõturuse Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","ynara tyripotohme ahno a nuriame pyra ehtohme ropa ipũ imotahpyry ekurãkase ropa ahtao. Mokyro arotoko oturukety a enetohme. ");
INSERT INTO apyNT_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Imaro ytõko oturukety mana jarãnaka tapyi tae ipihpyry enetohme. Toekurãkase ropa mokyro ahtao, ");
INSERT INTO apyNT_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","asakoro torõ tõ kurã enehpõko oturukety mana, wewe apupari maro, kaneru hpoty kamiraramano te, toiro amoriry hissopo, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Mame oturukety omi poe toiro torõ tohkãko mã toto oripo epoe, pehme tuna ke enatyry wino. ");
INSERT INTO apyNT_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Imeĩpo zakorõ torõ apoĩko mana wewe apupari maro, kaneru hpoty kamiraramã maro, hissopo maro ehxikatohme torõ itohkahpyry munuru ke. ");
INSERT INTO apyNT_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Mame munu pixo kuãnõko mã 7me mokyro ahno pona ikurãkatohme. “Nuriame pyra mase,” ãko oturukety mana eya. Moromeĩpo torõ aropõko oturukety mana ona pona isene ro exikety. ");
INSERT INTO apyNT_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Mame tupõ kurikãko mokyro mana, tũsety sahkãko mana, osetypokãko te, epỹko; mame kure exĩko mana, nuriame pyra. Pata pona ytõko ropa mana, yrome 7me ẽmepyry aropõko mana omõpyra tytapyĩ taka. ");
INSERT INTO apyNT_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Mame 7me ẽmepyry taropose ahtao tũsety sahkãko ropa mana, osetypokãko ropa, osepixihpokãko roropa, imepỹ tuhpoty tõ maro toko pokõ maro, tupõ kurikãko mana, epỹko roropa mana; mame kure exĩko mana, nuriame pyra. ");
INSERT INTO apyNT_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Yrokokoro kaneru mũkuru asakoro enehnõko mokyro mana, toiro kaneru nohpo maro, toiro jeimamyry nae exiketomo, kurãkõ rokene. Tynekaroryme roropa 3 kirume tiriiku apohpyry enehnõko mana otoxie azeite maro te, ¼ rituru azeite maro. ");
INSERT INTO apyNT_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Mokyro arõko oturukety mana inekarotyã maro Tapyi Kurã omõtoh taka. Moroto Ritonõpo ẽpataka, ");
INSERT INTO apyNT_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","toiro kaneru mũkuru apoĩko mana azeite maro jahkatohme tynekaroryme Ritonõpo a nuriame ehtoh korokapotohme. Inekarory moro kurãme mana, tokarose Ritonõpo a, oturukety zohme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Mokyro kaneru etapãko mana osa kurã po, okyno tõ etapatoh po ahno rypyry korokapotohme, ahno nekarory zahkatohme tytororo roropa. Moro rĩko oturukety mana, ahno nekarory zae pyra ehtoh korokapotohme oxisã exiryke inekarory maro tyyrypyry korokapotohme: kure kuhse morohne mã kehko, oturukety zohme roropa mã kehko. ");
INSERT INTO apyNT_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Okyno munuru zokonaka apoĩko oturukety mana, tomahxikyry ke munu rĩko mana mokyro panary pona apotunuru wino te, emary zũ pona apotunuru wino, ipupuru zũ pona apotunuru wino roropa mokyro tukurãkase. ");
INSERT INTO apyNT_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Mame azeite zokonaka kuãnõko oturukety mana tomary aka ipozery wino, ");
INSERT INTO apyNT_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","toiro tomahxikyry ke tapotunuru wino ehxikãko mana, azeite pitiko ke isapararahmãko 7me Ritonõpo ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Moromeĩpo tomahxikyry ke azeite pitiko rĩko mana mokyro ikurãkahpyry pona okyno munuru ritopõpyry saaro, ipanary etyhpyry pona apotunuru wino te, emary zũ pona apotunuru wino te, ipupuru zũ pona apotunuru wino, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Azeite akoĩpyry kuãnõko mana zupuhpyry pona. Moro ke, Ritonõpo ẽpataka mokyro rypyry korokapõko oturukety mana. ");
INSERT INTO apyNT_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Mame okyno zahkãko oturukety mana tynekaroryme, mokyro rypyry korokapotohme, mame mokyro tukurãkasẽme ropa exĩko mana. Moromeĩpo okyno etapãko mana ahno nekarohpyry, jahkatohme tytororo. ");
INSERT INTO apyNT_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Mokyro zahkãko mana apoto apõ po, tiriiku tõkehko maro. Moro ke mokyro ikurãkahpyry rypyry tykorokasẽme ropa exĩko mana, kure rokẽ exĩko mana, nuriame pyra. ");
INSERT INTO apyNT_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Yrome tytineruke pyra mokyro ahtao, morohne emero onepekahsaromepyra ahtao, toiro kaneru mũkuru arõko mana oturukety a, tynekaroryme zae pyra ehtoh korokapotohme. Inekarory kure mana, tokarose Ritonõpo a, oturukety zohme ehtohme. Tiriiku apohpyry toiro kirume rokẽ arõko mana otoxie azeite maro te, ¼ riturume azeite maro te, ");
INSERT INTO apyNT_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","asakoro utukuimo maro, utukuimo pyra ahtao asakoro utuku arõko mana ipune itinerũ ahtao. Toiro torõ totapasẽme exĩko iirypyry korokapotohme, zakorõ totapasẽme exĩko inekaroryme jahkatohme tytororo. ");
INSERT INTO apyNT_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Mame ẽmepyry 8me taropose ahtao, emero arõko mokyro mana Tapyi Kurã omõtoh taka ekarotohme oturukety a. Mame moroto Ritonõpo ẽpataka ");
INSERT INTO apyNT_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","kaneru mũkuru apoĩko oturukety mana azeite maro ekarotohme Ritonõpo a tynekaroryme kurano, oturukety zohme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Mame kaneru mũkuru etapãko mana. Imunuru zokonaka apoĩko mana, tomahxikyry ke munu rĩko mana mokyro panary aretyry pokona apotunuru wino, emary zũ pona apotunuru wino, ipupuru zũ pona apotunuru wino, mokyro kurãkatohme ropa. ");
INSERT INTO apyNT_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Mame azeite zokonaka kuãnõko oturukety mana tomary ao ipozery wino, ");
INSERT INTO apyNT_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","tomahxikyry ke apotunuru wino azeite pitiko ke isapararahmãko mana 7me moroto Ritonõpo ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Mame tomahxikyry ke azeite pitiko rĩko mana ikurãkahpyry ropa pona, okyno munuru ritopõpyry saaro, ipanary aretyry pona apotunuru wino te, emary zũ pona apotunuru wino te, ipupuru zũ pona apotunuru wino, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Azeite akoĩpyry kuãnõko mana mokyro zuhpokoxi. Moro ke Ritonõpo ẽpataka mokyro rypyry korokapõko oturukety mana. Ikorokãko Ritonõpo mana. ");
INSERT INTO apyNT_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Moromeĩpo mokaro utukuimo asakoro apoĩko oturukety mana, utukuimo pyra ahtao asakoro urutukue apoĩko mana, ipune itinerũ ahtao, ekarotohme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Toiro torõ totapasẽme exĩko inekaroryme iirypyry korokapotohme, zakorõ totapasẽme exĩko inekaroryme jahkatohme tytororo. Moro ke Ritonõpo ẽpataka mokyro rypyry korokapõko oturukety mana. Ikorokãko Ritonõpo mana. ");
INSERT INTO apyNT_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Sero Ritonõpo nyripohpyry ahno a toekurãkase ropa ahtao tyrohsẽke popyra ehxĩpo ipihpyry poko, yrome tytineruke pyra exiryke emero onepekahsaromepyra mana. ");
INSERT INTO apyNT_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Mame tõturuse Ritonõpo Moeze tomo a, Arão maro ");
INSERT INTO apyNT_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","ynara tyripotohme Izyraeu tomo a tapyi tymauhtase ahtao. Sero tyripotoh tokarose eya xine omipona toto ehtohme Kanaã pona toeporehkase toto ahtao, Ritonõpo nekarory eya xine, toto esaryme. Mame imauhtahpyry tonehpose ahtao Ritonõpo a ahno tapyĩ taka ");
INSERT INTO apyNT_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","oturukety a ytõko tapyi esẽ mana oturuse: “Imauhtahpyry tonese ya ytapyĩ poko,” ekarõko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Osemazuhme tapyi mõkomory emero toupõko oturukety mana ytopyra ro tahtao moro tapyi enese; onoupyra ahtao emero tapyi tao exiketõ nuriame ekarõko matose. Imeĩpo ytõko oturukety mana tapyi taka ");
INSERT INTO apyNT_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","moro imauhtahpyry enese. Tapyi apuru tõ poko imauhtahpyry ezuezumã sã te, kamiraramã sã ahtao roropa, tapyi apuru poko ahtao, ");
INSERT INTO apyNT_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","tũtãko oturukety tapyi tae, tapyi apurupõko mana 7me ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Mame 7me ẽmepyry taropose ahtao ytõko ropa mana tapyi enese ropa. Tonese ahtao eya moro zumo tãtahpahse ahtao apuru poko, ");
INSERT INTO apyNT_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","topu tõkehko, ipoko imauhtahpyry ahtao, toupõko mana ematohme mya pata poe osa nuriame ehtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Tapyi apuru mikamikapõko mana. Mame moro imimikahpyry arotoko pata poe osa nuriame ehtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Imeĩpo topu tõ kasenato rĩko matose moro esahpyry pona. Mame tapyi apuru tõ apuhnõko ropa matose. ");
INSERT INTO apyNT_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Moromeĩpo morohne emero tyrise ahtao oya xine imauhtahpyry enery ropa ahtao moro tapyi tao, ");
INSERT INTO apyNT_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","moro enẽko oturukety mana. Moro imauhtahpyry tõ zumohxo tãtahpahse ahtao apuru tõ poko, imauhtahpyry popyra exiketyme mana. Moro tapyi nuriame toehse mana. ");
INSERT INTO apyNT_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Moro tapyi ikararahtoko topu te, wewe te, apuhtopõpyry emero arotohme ipahtohme jarãnaka pata poe osa nuriame ehtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Moro tapyi taka, tomõse ahno ahtao, moro 7me ẽmepyry ae tapuruse ahtao, nuriame exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Moro tao tãtaxikase ahno ahtao, tõtuhse roropa moro tao ahtao, tupõ kurikãko mokyro mana nuriame toehse exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Yrome tooehse ropa oturukety ahtao tapyi enese tapuhse ropa ahtao, mame imauhtahpyry onenepyra ahtao apuru tõ poko: “Kure rokẽ mana, nuriame pyra,” ãko mana, imauhtahpyry tonahse exiryke ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Mame moro tapyi kurãkatohme asakoro torõ tõ apoĩko oturukety mana, wewe apupari maro te, kaneru hpoty kamiraramano te, hissopo amoriry maro. ");
INSERT INTO apyNT_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Mame toiro torõ etapãko mana oripo epoe tuna ke pehme tuna enatyry ae anymyhpyry. ");
INSERT INTO apyNT_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Mame zakorõ torõ apoĩko mana wewe apupari maro, kaneru hpoty kamiraramã maro, hissopo maro ehxikatohme torõ osemazuhmã munuru ke, imeĩpo moro tuna kurã ke, pitiko ke sapararahmãko tapyi pona, 7me. ");
INSERT INTO apyNT_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Moro riryke tapyi kurãkãko mana torõ munuru ke, tuna kurã maro, torõ isene ro exikety maro, wewe apupari maro, hissopo maro, kaneru hpoty maro kamirarame exikety. ");
INSERT INTO apyNT_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Mame pata poe torõ arõko mana isene exikety aropotohme ona pona. Moro riryke tapyi kurãkapõko oturukety mana, kure rokẽ moro tapyi exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","56","Morohne Ritonõpo nyripohpyryme mã kehko: tyrohsẽ popyra nae ahtao ipihpyry poko te, zupuhpyry poko roropa; tyaose ahtao, zuzu tõ nae ahtao, ẽxipuhturu nae ahtao ipihpyry poko; imapiuhtahpyry upo poko ahtao te, tapyi poko ahtao roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Ãmorepatohkõme mã morohne nuriame exiketyme ahtao te, kure rokẽ ahtao roropa nuriame pyra. Morohne Ritonõpo nyripohpyryme mana morohne toehse ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ritonõpo, Izyraeu tõ Esemy, tõturuse Moeze tomo a Arão maro ynara tyripotohme ");
INSERT INTO apyNT_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Izyraeu tomo a: Kunu tũtaryhtao ahno aĩ ae, nuriame mana, ");
INSERT INTO apyNT_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","moro kunu tũtakehpyra ahtao, totypohse ahtao roropa. Moro kunu pokoino mokyro nuriame mana. ");
INSERT INTO apyNT_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Emero nyhtoh pona tãtaxikase ynororo ahtao, emero epehtoh pona typorohse mokyro ahtao moro nuriame exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Mame mokyro nyhtoh tapose ahtao ahno a te, ");
INSERT INTO apyNT_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","typorohse ahtao roropa mokyro porohtopõpyry pona, tupõ kurikãko mana te, epỹko roropa mana; mame nuriame exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Mokyro kunu tũtakehpyra exikety tapose ahtao imepyny a, tupõ kurikãko mana te, epỹko roropa mana; mame nuriame exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Mokyro kunu tũtakehpyra exikety ituh tykase ahtao ahno nuriame pyra exikety pona, tupõ kurikãko mokyro mana, epỹko roropa mana; mame nuriame exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Mame mokyro tukunuke exikety tõtyrise ahtao sera pona, epehtoh pona roropa, moro nuriame exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Mame moro tapose ahtao ahno a epona typorohse moro pona ahtao, nuriame exĩko mana xixi omõtoh pona. Moro tarose ahtao imepyny a, epona typorohse tukunuke exikety ahtao, tupõ kurikãko mana, epỹko roropa mana; mame nuriame exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Mame ahno tapose ahtao mokyro a kunu tũtakehpyra exikety a tomary onukurikara ahtao, mokyro tapose aexihpyry tupõ kurikãko mana, epỹko roropa mana; mame nuriame exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Oripo tapose ahtao mokyro a, orino risemy, moro itohkatoko; wewe risẽme ahtao ikurikako tuna ke. ");
INSERT INTO apyNT_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Mame mokyro toekurãkase ropa ahtao, 7me ẽmepyry eraximãko mana tukurãkapotohme ropa, nuriame pyra ehtohme. Mame 7me ẽmepyry taropose ahtao tupõ kurikãko mana, epỹko roropa mana tuna anymyhpyry ke tuna enatyry ae; morarame kure exĩko ropa mana, nuriame pyra. ");
INSERT INTO apyNT_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Mame ẽmepyry 8mã po asakoro utukuimo apoĩko mana, arypyra ahtao asakoro urutukue arõko mana Tapyi Kurã omõtoh taka, mame moroto Ritonõpo ẽpataka torõ tõ ekarõko mana oturukety a. ");
INSERT INTO apyNT_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Toiro torõ etapãko oturukety mana inekaroryme iirypyry korokapotohme, zakorõ etapãko mana jahkatohme tytororo. Moro ke, Ritonõpo ẽpataka, mokyro kurãkapõko mana, kure rokẽ exĩko mana nuriame pyra. ");
INSERT INTO apyNT_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Mame orutua wino jeipyry tutũtase ahtao, epỹko mokyro mana, mame nuriame exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Upo ahtao, okyno pihpyry risẽme ahtao roropa, epona jeipyry pitahtykase ahtao, moro tukurikasẽme exĩko mana, mame nuriame exĩko ro mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Orutua maro nohpo osenao toehse toto ahtao, epỹko mã toto, asakoro ro, mame nuriame exĩko mã toto xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Munume nohpo ahtao nuno po, 7me ẽmepyry aropõko mana nuriame toehtoh poko. Mokyro tapose ahtao imepyny a moro sã ynororo ahtao nuriame exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Emero nyhtoh pona tãtaxikase mokyro munume exikety ahtao, emero epehtoh pona typorohse ynororo ahtao morohne nuriame exĩko. ");
INSERT INTO apyNT_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Moro nyhtoh tapose ahtao ahno a, moro epehtoh roropa tapose ahtao ahno a epona typorohse mokyro munume exikety ahtao, tupõ kurikãko mana, epỹko roropa mana; mame nuriame exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Mame orutua nohpo poko toehse ahtao munume ynororo ahtao nuriame exĩko mana 7me ẽmepyry pona; emero nyhtoh pona tãtaxikase ynororo ahtao, moro nyhtoh nuriame exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Nohpo munuru mynyhpãpyra ahtao, munuimohpe ynororo ahtao okynahxo, nuriame exĩko mana munume toehtoh samo nuno po. ");
INSERT INTO apyNT_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Emero nyhtoh pona tohrame toehse ynororo ahtao, emero epehtoh pona typorohse ynororo ahtao munume ahtao, morohne nuriame exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Mame ahno a moro nyhtoh tapose ahtao, morohne epehtoh tonõ tapose ahtao roropa eya epona typorohse nohpo munume exikety ahtao, nuriame exĩko mana, tupõ kurikãko mana, epỹko roropa mana; mame nuriame exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Tumũkehse ahtao, 7me ẽmepyry eraximãko mana, kure ehtohme ropa, nuriame pyra. ");
INSERT INTO apyNT_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Mame 8me ẽmepyry taropose ahtao asakoro utukuimo apoĩko mana, utukuimo pyra ahtao asakoro urutukue arõko mana Tapyi Kurã omõtoh taka ekarotohme oturukety a. ");
INSERT INTO apyNT_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Toiro torõ etapãko oturukety mana tynekaroryme iirypyry korokapotohme, zakorõ etapãko mana jahkatohme tytororo. Moro ke, Ritonõpo ẽpataka mokyro kurãkapõko mana, mame kure nohpo exĩko ropa mana nuriame pyra. ");
INSERT INTO apyNT_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Morohne Ritonõpo nyripohpyry tõ Izyraeu tõ akorehmatohme, toto kurãkatohme nuriame toto ehtoh winoino, aorikyrykõino. Nuriame toehtohkõ tarose ahtao eya xine Ritonõpo Tapyĩ taka Izyraeu tõ rãnao totapasẽme toh exiry. ");
INSERT INTO apyNT_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Morohne Ritonõpo nyripohpyry tõ orutua komo a nuriame toehse ahtao kunu tũtakehpyra ahtao jaĩkõ ae te, jeipyry tutũtase ahtao te, ");
INSERT INTO apyNT_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","nohpo tõ roropa munume ahtao nuno po; orutua kõ roropa nohpo poko toehse ahtao munume ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Moromeĩpo, Arão mũkuru tõ asakoro toorihse ahtao, ixtaratu zahkaryhtao eya xine tynekaroryme Ritonõpo a repe, yrome Ritonõpo nyripohpyry omipona pyra, tõturuse ropa Ritonõpo Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Ynara tykase: — Orui Arão zuruko omõpyra ehtohme emero rokẽ xixi ahtao, Osa Kurã Kuhse taka, kamisa moinakoxi Tapyi Kurã tao. Moro taka aomomyryhtao orihnõko mana, moroto joseneporyke akuru ao Jomiry ẽ apuru epoe. Moroto mã ahno rypyry tykorokase mã kehko. ");
INSERT INTO apyNT_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Ynara ahtao rokẽ Osa Kurã Kuhse taka omõnõko Arão mana, pui mũkuru totapase ahtao eya tynekaroryme tyyrypyry korokapotohme te, kaneru roropa totapase ahtao eya tynekaroryme jahkatohme tytororo. ");
INSERT INTO apyNT_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Omõtohme Osa Kurã Kuhse taka Arão epỹko mana, mame oturukety zupõ amurũko mana, mauru panono risemy exiketomo emero, upo zopinono, upo jaraono, zamareary, zupuhpyry pona kamisa mauru panono risemy. ");
INSERT INTO apyNT_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Mame tõturuse Ritonõpo Moeze a ynara tyripotohme Ẽmepyry Ahno Rypyry Korokatoh poko: asakoro poti tõ enehnõko Izyraeu tõ mana Arão a tynekarorykõme tyyrypyrykõ korokapotohme, toiro kaneru maro jahkatohme tytororo. ");
INSERT INTO apyNT_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Pui mũkuru apoĩko Arão mana jahkatohme tynekaroryme tyyrypyry korokapotohme. Moro ke iirypyry tõ tykorokasẽme exĩko, jekyry tõ rypyry tõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Mame poti tõ asakoro arõko mana Tapyi Kurã omõtoh taka. Moroto, Ritonõpo Tosẽkõ ẽpataka, ");
INSERT INTO apyNT_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","imenekatoh emãko mana poti menekatohme, toiro etapatohme tynekaroryme Ritonõpo a, zakorõ aropotohme ona pona, Azazeume tosehkemy. ");
INSERT INTO apyNT_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Mokyro poti, Ritonõpo eky etapãko Arão mana ahno nekaroryme iirypyry tõ korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Zakorõ poti tosehke Azazeume ekarõko mase isene ro Ritonõpo a. Imeĩpo taroposẽme exĩko mana ona pona ahno rypyry korokapotohme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Mame pui mũkuru apoĩko Arão mana tynekaroryme tyyrypyry korokapotohme, moro ke iirypyry tykorokasẽme exĩko mana, jekyry tõ rypyry tõ roropa tykorokasẽme exĩko mana. Mame mokyro pui totapase ahtao eya ");
INSERT INTO apyNT_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ikarã eny apoĩko Arão mana, ikarã ke pehme tanỹse apoto apõ poe, mame ixtaratu typoxine exikety maro, asakoro tomary ao pehme, omõnõko mana Osa Kurã Kuhsẽ taka. ");
INSERT INTO apyNT_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Moroto, Ritonõpo ẽpataka, moro ixtaratu rĩko mana apoto pona, orexĩto akurũ sã Ritonõpo Omiry ẽ apuru apurutohme, moro apuru osenepyra ehtohme. Moro ke orihpyra Arão exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Pui mũkuru munuru zokonaka apoĩko mana, mame tomahxikyry ke munu pitiko ke isapararahmãko mana Ritonõpo Omiry ẽ apuru pokona xixi tũtatoh wino; mame munu pitiko ke isapararahmãko mana 7me Ritonõpo Omiry ẽ ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Moromeĩpo poti etapãko Arão mana ahno tõ rypyry korokapotohme Ritonõpo a. Munu arõko mana Osa Kurã taka. Munu pitiko ke isapararahmãko mana Ritonõpo Omiry ẽ apuru pokona te, moro kaxo ẽpataka roropa tynyrihpyry saaro pui mũkuru munuru ke. ");
INSERT INTO apyNT_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Moro ke Osa Kurã Kuhse kurãkãko Arão mana. Ahno rypyry tõ, popyra toto ehtoh te, zae pyra Izyraeu tõ ehtopõpyry emero korokapõko mana. Mame moro rĩko roropa mana Tapyi Kurã kurãkatohme roropa, ahno rãnao exikety, nuriame exiketõ rãnao. ");
INSERT INTO apyNT_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Osa Kurã Kuhse tao Arão ahtao moro kurãkary poko, imehnõ omõpyra exĩko mã toto Tapyi taka. Mame tyyrypyry tykorokapose Arão a ahtao jekyry tõ rypyry roropa te, ahno rypyry roropa emero, ");
INSERT INTO apyNT_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","tũtãko mana Tapyi Kurã tae. Apoto apõ pona ytõko mana Tapyi ẽpataka. Moroto apoto apõ kurãkãko roropa mana. Pui mũkuru munuru zokonaka apoĩko mana, poti munuru zokonaka maro tyritohme apoto apõ potyry pokona, asakoropane. ");
INSERT INTO apyNT_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Tomahxikyry ke munu pitiko ke isapararahmãko mana 7me apoto apõ pona. Moro ke ikurãkãko mana. Izyraeu tõ nuriame ehtoh emero korokapõko mana. Mame tapiakase moro apoto apõ exĩko mana Ritonõpo nyripohpyry poko rokẽ ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Mame tõtyhkase Arão ahtao Osa Kurã Kuhse kurãkary poko te, Tapyi Kurã kurãkary poko te, apoto apõ kurãkary poko roropa, poti isene ro exikety apoĩko mana aropotohme Azazeume ona pona, ");
INSERT INTO apyNT_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","tomary rĩko mana okyno zupuhpyry pona, Izyraeu tõ rypyry esehtõko mana, emero Izyraeu tõ zae pyra ehtopõpyry roropa. Moro ke tyyrypyrykõ rĩko mana poti zupuhpyry pona. Mame mokyro poti aropõko mana ona pona. Toiro ahno menekãko mana mokyro arotohme, ");
INSERT INTO apyNT_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","mame imyhpokãko mokyro mana ona tonorẽ po. Morarame poti ytõko mana ahno esaka pyra, tymaro ahno rypyry arõko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Mame Tapyi Kurã taka omõnõko ropa Arão mana tupõ outohme ropa oturukety zupony. Moro upo tamuruse eya ytotohme Osa Kurã Kuhse taka. Moroto moro upo nomõko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Moroto, Tapyi Kurã tao, epỹko mana. Mame tupõ amuruxĩpo tũtãko ropa mana okyno enehtohme tynekaroryme Ritonõpo a jahkatohme tytororo, ahno nekarory roropa zahkatohme tytororo. Moro ke iirypyry tykorokasẽme exĩko mana, ahno rypyry roropa emero. ");
INSERT INTO apyNT_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Apoto apõ po okyno kasery zahkãko mana ahno nekarohpyry tyyrypyrykõ korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Mame mokyro poti arohpono ona pona tupõ kurikãko mana, epỹko roropa mana toehtohme ropa pata pona. ");
INSERT INTO apyNT_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Mame tõtyhkase ahtao okyno tõ zahkary poko ahno rypyry korokapotohme te, Osa Kurã Kuhse kurãkary poko roropa, pui mũkuru munuru ke poti munuru maro, mokaro okyno tõ ekepyry asakoro tarosẽme exĩko mya oesarykõ poe jarãnaka. Moroto ipihpyry te, ipũ te, zuahxiririny, zuhtoto maro tyahkasẽme exĩko. ");
INSERT INTO apyNT_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Mame mokyro morohne zahkahpono tupõ kurikãko mana, epỹko roropa mana toehtohto ropa pata pona. ");
INSERT INTO apyNT_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Sero Ritonõpo nyripohpyry omipona ehtoko jũme: — Ẽmepyry 10me ehtoh po, nuno 7me ehtoh po, Izyraeu tõ emero, imehnõ maro emero aosesarityã Izyraeu tõ maro otuhpyra kohmãnõko mã toto, erohpyra roropa kohmãnõko mã toto ipunaka, ");
INSERT INTO apyNT_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ynara exiryke: sero ẽmepyry ae okyno tõ totapasẽme exĩko, tyahkasẽme exĩko ahno rypyry korokapotohme Ritonõpo a. Moro ke kure exĩko matose, nuriame pyra Ritonõpo Oesẽkõ ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Sero ẽmepyry atãkyematohme exikehpyra exĩko mana jũme, morara exiryke amarokõ emero otuhpyra matose, erohpyra roropa kohmãnõko matose moro ae. ");
INSERT INTO apyNT_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Oturukety imehxo exikety typopase exikety tumy myakãme upo amurũko mana oturukety zupõ ke mauru panõ risemy; ");
INSERT INTO apyNT_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","mame morohne emero tyrĩko mana Osa Kurã Kuhse kurãkatohme, Tapyi Kurã maro, apoto apony te, oturuketõ maro, ahno maro porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Sero Ritonõpo nyripohpyry omipona exĩko matose, jũme. Emero jeimamyry ae atãkyematoh rĩko matose; mame morohne rĩko matose ahno emero rypyry korokapotohme. Mame moro emero tyrise eya xine Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Mame tõturuse Ritonõpo Moeze a, ");
INSERT INTO apyNT_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","ynara tyripotohme Arão a, imũkuru tõ maro, Izyraeu tõ maro emero: ");
INSERT INTO apyNT_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Okyno etaparyhtao oya xine, pui te, kaneru te, poti roropa, pata po, moe jarãnaka pata poe roropa ");
INSERT INTO apyNT_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","mokyro onenehpyra awahtao xine Tapyi Kurã omõtoh taka imunuru ekarotohme Ritonõpo Oesẽkomo a, taroposẽme exĩko mase Izyraeu tõ poe iirypyryme oexiryke, ahno etapatopõpyry sã oya. ");
INSERT INTO apyNT_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Naeroro Izyraeu tomo, oekykõ onetapara ehtoko moe ona po. Enehtoko toto oturukety a Tapyi Kurã ẽpataka. Moroto rokẽ oekykõ etapãko matose onekaroryme Ritonõpo a, osepeme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Munu kuãnõko oturukety mana apoto apõ pona Tapyi Kurã ẽpataka. Moroto roropa okyno kasery zahkãko mana. Onekarorykõ zahkaryhtao typoxine exĩko Ritonõpo a mana. ");
INSERT INTO apyNT_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Taroino jũme Izyraeu tõ morohne rĩko mã toto. Tynekarorykõ onekaropyra ropa mã toto joroko tomo a ona po; ynara exiryke moro riryhtao eya xine Ritonõpo omiry omipona pyra exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Tynekarorykõ enehnõko Izyraeu tõ mana emero porehme Tapyi Kurã omõtoh taka rokene. Morararo imehnõ roropa Izyraeu tõ maro exiketomo, tokykõ enehnõko mã toto Ritonõpo a tynekarorykõme jahkatohme tytororo, emero tynekarorykõ roropa ");
INSERT INTO apyNT_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Tapyi Kurã omõtoh taka rokene, imepỹ esaka pyra. Ritonõpo nyripohpyry omipona pyra exikety taroposẽme exĩko mana ipoetory tõ poe. ");
INSERT INTO apyNT_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Munu enapyryhtao Izyraeume exikety a te, imepyny a roropa Izyraeu tõ maro exikety a, mokyro wãnohnõko Ritonõpo mana, typoetory tõ poe mokyro aropõko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Isene exiketõ emero isene ehtoh munu ao mana. Morara exiryke moro tyripose Ritonõpo a: okyno tõ, ahno nekaroryme ahtao imunuru tukuãsẽme exĩko apoto apõ pona, ahno rypyry korokapotohme. Ynara exiryke: munu, isene ehtoh, ahno rypyry korokãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Morara exiryke moro poko turuse Ritonõpo a: Izyraeu tõ emero imehnõ roropa Izyraeu tõ maro exiketõ roropa, munu onenahpyra aehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Urakanase oytorykohtao, Izyraeu tomo, imehnõ roropa, okyno tuose ahtao oya torõ roropa, tõsẽme, imunuru kuãnõko matose nono pona, imeĩpo nono ke moro munu ẽputohmatoko. ");
INSERT INTO apyNT_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Isene ehtoh mã munu ao mana. Morara exiryke Izyraeu tõ tyripose Ritonõpo a: onokyro tõ emero munu onenahpyra tyripose eya, imunuru isene exiryke. Munu tonahse ahtao ahno a taroposẽme exĩko mana Izyraeu tõ poe. ");
INSERT INTO apyNT_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Tõsẽ onyryhtao Izyraeume exikety a, imehnomo a roropa Izyraeu tõ maro exiketyme ahtao, mokyro tamoreme toorihse ahtao te, tosekase ahtao roropa onokyro tomo a, tupõ kurikãko mokyro mana, epỹko roropa mana. Mame nuriame exĩko ro mana xixi omõtoh pona. Imeĩpo kure rokẽ exĩko ropa mana, nuriame pyra. ");
INSERT INTO apyNT_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Yrome tupõ onukurikara mokyro ahtao, epypyra roropa mokyro ahtao, tuãnohsẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Tõturuse Ritonõpo Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","ynara tyripotohme Izyraeu tomo a: — Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ejitu põkõ nyriry sã onyripyra ehtoko, mokaro maro mexiatose. Kanaã nonory pona aarotorỹko ase, yrome Kanaã põkõ nyriry sã onyripyra ehtoko. Mokaro nyripohpyry tõ omipona pyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Morara exiryke jomihpyry omipona ehtoko. Ynyripohpyry oya xine omipona ehtoko. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Jomihpyry omipona awahtao xine, ynyripohpyry oya xine omipona roropa awahtao xine, isene exĩko matose. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ynara tyripõko ase oya xine: Nohpo poko pyra ehtoko oekyryme ynororo ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Asa maro osenao pyra ehtoko; omy hxirõko mana moro sã tyriryhtao oya, asa hxirõko roropa mase. ");
INSERT INTO apyNT_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Imepỹ ke typye omy ahtao, mokyro maro pyra exiko, ipoko pyra exiko. ");
INSERT INTO apyNT_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ooryxiry poko pyra exiko: omy ẽxiryme ahtao asa maro te, omy ẽxiryme rokẽ ahtao; tuãtase ynororo ahtao atapyĩ tao, imepỹ tapyĩ tao roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Apary poko pyra exiko oehxiroryino. ");
INSERT INTO apyNT_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ooryxiryme roropa omy pyty ẽxiry mana omy maro. Mokyro poko pyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Omy oryxiry poko pyra ehtoko omy ekyryme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Asa akorõ poko pyra ehtoko, ipaxiry poko pyra ehtoko roropa asa ekyryme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Omy akorõ pyty poko pyra ehtoko, omy rui pyty poko pyra roropa ehtoko, eohpyryme exiryke oya. ");
INSERT INTO apyNT_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Omũkuru pyty poko pyra ehtoko apary ẽme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ãkorõ pyty poko pyra ehtoko, orui pyty poko pyra ehtoko roropa, ãkorõ ehxiroryino, orui ehxiroryino roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Nohpo maro toehse awahtao, ẽxiry poko pyra ehtoko, ipary poko pyra ehtoko roropa. Otarame oekyryme mã toto. Toto poko pyra ehtoko, popyra oexiryino. ");
INSERT INTO apyNT_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Opyty akorõ anapoipyra ehtoko opytyme, ipaxiry anapoipyra ehtoko opytyme, orihpyra ro opyty ahtao, toto oxiehno exiryino. ");
INSERT INTO apyNT_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Nohpo maro osenao pyra ehtoko munume ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Imepỹ pyty poko pyra ehtoko, iirypyryme oexiryino, nuriame. ");
INSERT INTO apyNT_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Opoenõ onekaropyra ehtoko tyahkasẽme onekaroryme imehnõ neponãmary tomo a Moroke eahmaryme. Moro poko toehse awahtao xine Ritonõpo Oesẽkõ Esety kurã, nuriame tyrĩko matose. ");
INSERT INTO apyNT_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Imepỹ orutua maro osenao pyra ehtoko; moro se pyra Ritonõpo mana ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ahno osehpyra ehtoko onokyro maro, okyno maro roropa; popyra moro exiryke ipunaka, nuriame oexirykõino. ");
INSERT INTO apyNT_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ynara tykase Ritonõpo Izyraeu tomo a: — Morohne poko pyra ehtoko ipunaka. Moro popyra ehtoh riryhtao oya xine nuriame exĩko matose, mokaro nuriame aexihpyry samo, mokaro taroposẽme ya moro nono poe, ynekaroryme oya xine. ");
INSERT INTO apyNT_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Mokaro ahno tõ rypyry pokoino moro nono nuriame toehse. Morara exiryke moro nono wãnohtoh enehpõko ase, epõkõ taroposẽme exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Yrome amarokõ emero, Izyraeu tomo, imehnõ roropa amaro xine exiketomo, jomihpyry omipona ehtoko. Ynyripohpyry roropa oya xine omipona ehtoko. Mokaro popyra ehtoh poko pyra ehtoko ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Morohne popyra ehtoh poko toehse moro nono põkomo, morara exiryke moro nono nuriame toehse. ");
INSERT INTO apyNT_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Zae awahtao xine, jomihpyry omipona, ononorykõ poe amarokõ anaropopyra exĩko, mokaro nuriame aexityã aropotopõpyry samo, osemazuhme sero nono po aexityamo. ");
INSERT INTO apyNT_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Morohne iirypyrykõ tyrise ahtao oya xine, mokyro tyyrypyry poko exikety tuãnohsẽme exĩko, taroposẽme exĩko mana Izyraeu tõ wino. ");
INSERT INTO apyNT_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Morara exiryke jomihpyry omipona ehtoko, popyra ehtoh poko pyra oehtohkõme, mokaro osemazuhme sero nono po aexityã sã pyra. Nuriame pyra ehtoko. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Mame tõturuse Ritonõpo Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","ynara tyripotohme Izyraeu tomo a: — Zae rokẽ ehtoko, ywy, Ritonõpo Oesẽkõ, zae rokẽ jexiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Kure rokẽ asakõ tyritoko, omykõ roropa kure rokẽ tyritoko. Kure oserematoh tyritoko jeahmatohme. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","— Ritõ panõ oneahmara ehtoko, oneponãmarykõ onyripyra ehtoko metau risẽme. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","— Okyno tõ etaparyhtao oya xine onekaroryme, osepeme ehtohme, ynyripohpyry oya xine omipona ehtoko, zae oehtohkõme yneneryme. ");
INSERT INTO apyNT_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Mokyro pũ õnõko matose moro ẽmepyry ae ro, mokyro etapatopõpyry ae ro te, yrokokoro roropa mokyro pũ õnõko matose nae ro ahtao. Yrome akoĩpyry nae ro ahtao oseruao ẽmepyry po, jahkatoko rokene, ");
INSERT INTO apyNT_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","nuriame toehse exiryke. Tõse oya ahtao ẽmepyry oseruaõ ae popyra mana, onekaroryme ya ahtao roropa popyra mana. ");
INSERT INTO apyNT_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Moro tõsẽ ahtao onyhpono tuãnohsẽme exĩko mana. Ynyripohpyry kurã tymyakãmase exiryke eya nuriame ehtohme. Naeroro mokyro taroposẽme exĩko mana Izyraeu tõ poe. ");
INSERT INTO apyNT_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","— Tykyrysã toehse ahtao, tiriiku tõkehko tapoise ahtao oya xine otupikõ po moro onysahkara ehtoko tupito ehpikuroko. Ytopyra ropa ehtoko otyro akoĩpyry apoise. ");
INSERT INTO apyNT_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ytopyra ropa ehtoko uwa zoko esary pona uwa epery akoĩpyry anỹse tynomose ahtao apitoryme, ytopyra ropa ehtoko uwa epery apoise toepukase ahtao roropa nono pona. Morohne inomotoko tymõkomokãkara napyryme ehtohme, imehnõ nonory põkõ napyryme roropa. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","— Ematonara ehtoko, ajohpe pyra ehtoko, imehnõ onenekunohpyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Õmirykõ onetapopyra ehtoko jesety maro ajohpe awahtao xine, moro ke jesety rĩko matose nuriame. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","— Imehnomo a oepehmarykohtao onymotyẽkara ehtoko, onematonanohpyra ehtoko. Erohkety toerohse ahtao opoetoryme, aerohtamitu ekaroko eya jũme rokene. “Kokoro oepehmãko ase,” kara ehtoko epehpyry nae awahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Popyra ehtoh onenehpopyra ehtoko otato pyra exikety pona, osetapapotoh onyripyra ehtoko tonurãkara esema tao. Jomiry omipona ehtoko. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","— Zae rokẽ ehtoko imehnõ apiakaryhtao oya xine; tymõkomokãkara akorehmary se rokẽ pyra ehtoko, tamuximehxo exiketõ zuno pyra ehtoko. Zae rokẽ imehnõ apiakatoko, emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ajohpe ehtoh anahpahpyra ehtoko ahno rãnao. Imehnõ onyhxiropyra ehtoko ajohpe ehtoh ke, aorihmaporyino. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","— Okurohtao imepỹ Izyraeume exikety zehno pyra exiko, yrome axĩ ke ekurãkako ropa. Ajohpe pyra oturuko imaro iirypyryme oexiryino mokyro pokoino. ");
INSERT INTO apyNT_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Emỹpopyra ehtoko, imepỹ zehno pyra ehtoko, yrome imehnõ pyno ehtoko osepyno oehtoh samo. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","— Ynyripohpyry tõ oya xine omipona ehtoko. Okyno tõ onumũkuapopyra ehtoko tyorono a. Otyro puhturu otoxie anarykara ehtoko otupikõ po. Kamisa tyorõ risẽ otoxie upo anamurupyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","— Nohpo poko toehse orutua ahtao imepỹ namotome mokyro nohpo ahtao, tymenekase ynororo imepỹ pytyme repe, yrome onepekahpyra ro mana, onymyhpokara roropa ynororo, morara ahtao tuãnohsẽme exĩko mã toto asakoro ro, yrome toto onetapara exĩko imykyhpyry sã mokyro nohpo exiryke, imepỹ namotome. ");
INSERT INTO apyNT_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Moro toehse ahtao tyyrypyry korokapotohme, okyno enehnõko orutua mana tynekaroryme Ritonõpo a, kaneru enehnõko mana Tapyi Kurã omõtoh taka. ");
INSERT INTO apyNT_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Moroto, Ritonõpo ẽpataka kaneru etapãko oturukety mana inekaroryme Ritonõpo a, iirypyhpyry korokapotohme. Mame mokyro rypyry korokãko ropa Ritonõpo mana. ");
INSERT INTO apyNT_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","— Tomõse awahtao xine Kanaã pona, moroto ehse, epery zoko tõ arykaryhtao oya xine, moro epery onenahpyra ehtoko oseruao jeimamyry pona; nuriame oya xine mana. ");
INSERT INTO apyNT_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mame jeimamyry asakoropane toehse ahtao moro epery emero kure ya mana; enehtoko ya, Oesẽkomo a, onekarorykõme jeahmatohme. ");
INSERT INTO apyNT_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Jeimamyry omame ahtao moro epery enahnõko matose. Morarame itamurumehxo eperytãko moro wewe tomo. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","— Tõsẽ onõpyra ehtoko munu maro ahtao. Pyaxime ehtoh onukuhpyra ehtoko, joroko tõ poko pyra ehtoko imeĩpo ehtoh waro oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Oũsetykõ onysahkara ehtoko apanarykõ myhtokoxi exikety, oetypotykõ onysahkara ehtoko roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ahno hnamoryhtao opihpyry onysahkara ehtoko, õkokõ onyryhmara ehtoko, imerohpyry roropa onyripyra ehtoko õkokõ poko. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","— Oẽxirykõ onekaropyra ehtoko imehnomo a tineru apoitohme. Morohne riry popyra mana ipunaka, moro riryhtao oya xine imehnõ neponãmary poko exĩko matose, iirypyrymehxo exĩko roropa matose. ");
INSERT INTO apyNT_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Kure rokẽ oserematoh tyritoko, Ritonõpo eahmatohme oya xine moro ae, tomeseke ehtoko kure rokẽ jeahmatohme oya xine. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","— Ytopyra ehtoko aorihtyã zuzenu maro oturuketomo a ãkorehmapotohme, joroko tõ poe imeĩpo ehtoh waro exiketomo a roropa. Moro iirypyryme mana, ipokoino nuriame exĩko matose. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","— Owõtoko xikihme tamuhpomãkõ ẽpataka, kure rokẽ tyritoko toto roropa; kure rokẽ kyritoko roropa, Oesẽkomo. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","— Imehnõ nonory poe aehtyã onyryhmara ehtoko, ononorykõ pona toehse ahtao amaro xine ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Kure rokẽ tyritoko toto Izyraeu tõ ritohme sã oya xine; imehnõ nonory poe aehtyã pyno ehtoko, katonõme oehtopõpyrykõ sã mã toto Ejitu po. Naeroro katonõ pyno ehtoko osepyno oehtohkõ samo. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","— Imehnõ onenekunohpyra ehtoko. Ematonara ehtoko ajohpe ehtoh kuhtoh ke, mosa kuhtoh ke, omoxinety kuhtoh ke, rituru kuhtoh ke, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Omoxinety kuhtoh zae exikety rokẽ poko ehtoko, zae rokẽ mõkomo kuhtohme ekamoryhtao, epekatyryhtao, enara. Ywy ase Ritonõpo Oesẽkomo. Kuenepyatose Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","— Jomihpyry omipona ehtoko, ynyripohpyry tõ oya xine. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Mame tõturuse Ritonõpo Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","ynara tyripotohme Izyraeu tomo a: — Tumũkuru ekaroryhtao Izyraeu a, imehnomo a roropa, ritõ panõ Moroke poetoryme ehtohme, mokyro totapasẽme exĩko mana topu ke ahno tomo a. ");
INSERT INTO apyNT_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mokyro zehno exĩko ase, aorihmapõko ase tumũkuru tokarose eya exiryke Moroke eahmatohme. Moro ke Ytapyĩ Kurã nuriame tyripose eya, moroto jesaryme, jesety kurã nuriame tyrise roropa eya. ");
INSERT INTO apyNT_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Mame mokyro onyhxiropyra ahno ahtao typoenõ ekaroryhtao Moroke a, mokyro onetapara roropa toto ahtao ");
INSERT INTO apyNT_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ywy roro mokyro wãnohnõko ase, itapyĩ taõkõ maro. Mokaro aropõko ase ypoetory tõ winoino, imaro emero isã tyneponãmarykõ Moroke eahmananomo. ");
INSERT INTO apyNT_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","— Ahno ytoryhtao aorihtyã zuzenu kohmananomo a takorehmapotohme, mokaro a roropa joroko poko exiketomo a imeĩpo ehtoh waro ehtohme, mokyro wãnohnõko ase iirypyry pokoino, aropõko ase ypoetory tõ tae. ");
INSERT INTO apyNT_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Osekarotoko ya zae ehtoh poko rokẽ oehtohkõme, ywy, Ritonõpo Oesẽkõme jexiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Jomiry omipona ehtoko, ynyripohpyry oya xine. Ywy ase Ritonõpo, ãpiakanekõme imehnõ wino, ymaro rokẽ oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","— Tumy pona popyra ehtoh enehporyhtao, tyse pona moro riryhtao roropa ahno a, mokyro totapasẽme exĩko iirypyry epehpyryme iirypyryme toehse exiryke, tumykõ pona popyra ehtoh enehporyke eya mokyro wãnohnõko ase. ");
INSERT INTO apyNT_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","— Imepỹ pyty poko toehse orutua ahtao totapasẽme exĩko mana, nohpo roropa totapasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Tumy pyty poko toehse orutua ahtao, popyra tumy rĩko mã ynororo. Naeroro totapasẽme exĩko mana, nohpo roropa totapasẽme exĩko, zae pyra toehse toto exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Tumũkuru pyty poko toehse orutua ahtao, mokaro asakoro ro totapasẽme exĩko iirypyrykõ epehpyryme, zae pyra toehse toto exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Orutua imepỹ orutua poko toehse ahtao, mokaro asakoro ro totapasẽme exĩko mana, nuriame ehtoh poko toehse toto exiryke. Tyyrypyrykõ epehmãko mã toto, toorikyrykõ ke. ");
INSERT INTO apyNT_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Orutua typytase ahtao nohpo maro, jeny maro roropa, moro popyra mana ipunaka. Mokaro oseruao tyahkasẽme exĩko mã toto, isene ro toto ahtao; moro popyra ehtoh enahnõko mana ypoetory tõ rãnao. ");
INSERT INTO apyNT_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Okyno maro orutua tõsehse ahtao, mokaro asakoro ro totapasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Nohpo tohse ahtao okyno a, mokaro asakoro ro totapasẽme exĩko mana, morohne epehpyryme. ");
INSERT INTO apyNT_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","— Orutua typytase ahtao toryxiry maro, tumy ẽxiryme ahtao te, tyse ẽxiryme ahtao, mokaro asakoro ro taroposẽme exĩko mã toto ypoetory tõ winoino. Ehxirotoh moro toryxiry tapoise exiryke orutua a, moro poko tuãnohsẽme exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Orutua nohpo poko toehse ahtao munume ahtao, mokaro asakoro ro taroposẽme exĩko mana ypoetory toh tae. Nuriame toehse toto exiryke ynyripohpyry omipona pyra toehse toexirykõke. ");
INSERT INTO apyNT_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Orutua nohpo poko toehse ahtao, aohpyryme ahtao, mokaro asakoro ro tuãnohsẽme exĩko mã toto oxiekyryme toto exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Orutua tohpyry poko toehse ahtao, inio hxirõko mana. Mokaro asakoro ro tuãnohsẽme exĩko mã toto; typoenoke pyra exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ahno a takorõ pyty apoiryhtao typytyme, turui pyty apoiryhtao eya typytyme, inio hxirõko mana. Zae pyra mana, tumũkue pyra orihnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","— Jomihpyry omipona ehtoko, ynyripohpyry oya xine roropa omipona ehtoko, moro nono ynekarohpyry oya xine aaropopyra xine ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Imehnõ ahno ehtoh onypoenohpyra ehtoko. Mokaro aropõko ase moro nono poe õmomyrykohtao osesaritohme. Typenekehse ywy mokaro poko, popyra ehtoh poko toto exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Yrome jomiry etapoase: moro nono ekarõko ase oya xine oesarykõme kurano, otyro zamaro exikety. Ywy ase Ritonõpo Oesẽkomo; imehnõ ahno tõ wino kuapiakatose. ");
INSERT INTO apyNT_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Morara exiryke okyno tõ apiakatoko, torõ tõ roropa kure exiketõ wino nuriame exiketomo. Ywy ro rokẽ okyno tõ menekãko ase, torõ tõ roropa, nono poro ytoketõ maro, nuriame exiketomo te, nuriame pyra exiketõ roropa. Ynara tyripõko ase oya xine: nuriame exiketõ onõpyra ehtoko, nuriame pyra oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Zae ehtoh poko rokẽ ehtoko zae rokẽ jexiryke, Oesẽkõme. Kuapiakatose imehnõ ahno tõ winoino ypoetoryme rokẽ oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","— Aorihtyã zuzenu maro oturuketyme ahno ahtao, orutuame ahtao, nohpome ahtao roropa, joroko tõ poko tahtao roropa imeĩpo ehtoh waro toehtohme, totapasẽme exĩko mã toto topu ke. Zae pyra toehse toto exiryke tuãnohsẽme exĩko mana, aorikyry ke topehmasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Mame Ritonõpo tõturuse Moeze a ynara tyripotohme oturuketomo a, Arão mũkuru tomo a, ipakomotyamo a roropa: — Nuriame pyra ehtoko oekyry toorihse ahtao. Ekepyry anapopyra ehtoko zonemyry poko oekyryme ahtao ro. ");
INSERT INTO apyNT_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Yrome ameke pyra oekyryme ahtao, asame ahtao, omyme ahtao, omũkurume, oẽxiryme ahtao te, ãkorõme, oruime ahtao te, ");
INSERT INTO apyNT_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ooryxiryme tynioke pyra, atapyĩ tao exiketyme ahtao, apoĩko mase. ");
INSERT INTO apyNT_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Yrome tynioke ooryxiry toorihse ahtao ekepyry anapopyra exiko, nuriame pyra ehtoko ipoko. ");
INSERT INTO apyNT_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","— Tũsety onysahkara oturuketõ mana, osetypokara te, typihpyry onysahkara roropa tyekyry hnamoryhtao. ");
INSERT INTO apyNT_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Zae ehtoh poko anamonohpyra mã toto, nuriame pyra toehtohkõme, Ritonõpo nyripohpyry omipona. Okyno tõ enehnõko mã toto etapatohme jahkatohme, tynekaroryme Ritonõpo a. Moro mã tonahsẽme sã Ritonõpo a mana. Naeroro nuriame pyra tahtao xine rokẽ, ytõko mã toto Ritonõpo ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Tapiakase mã toto imehnõ wino Ritonõpo ẽpataka ytotohme erohse. Morara exiryke pytara mã toto imeimehnõ poko aexihpyry maro te, turumekase ropa aexihpyry maro te, orutua poko exipitopyra exikety maro rokẽ pytãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Tonahsẽ enehnõko oturukety mana tynekaroryme Ritonõpo a. Naeroro zae rokẽ exiketyme, nuriame pyra oturukety ekarõko ahno mana. Ywy ase Ritonõpo. Zae rokẽ ase nuriame pyra, ypoetory tõ Izyraeu tõ tymenekase ya zae rokẽ toto ehtohme roropa, nuriame pyra. ");
INSERT INTO apyNT_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","— Imeimehnõ poko toehse oturukety ẽxiry ahtao, tumy hxirõko mana; tuãnohsẽme exĩko mana, tyahkasẽme exĩko aorihtohme apoto ke. ");
INSERT INTO apyNT_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","— Oturukety imehxo exiketyme tymenekase, zupuhpyry typopase ahtao azeite kurã ke, Ritonõpo kyryry ke, oturukety zupõ tamuruse roropa ahtao eya; morara exiryke tũsety onekurinakehpyra mã ynororo, tupõ onyxihkara roropa mana aorihtyã hnamoryhtao. ");
INSERT INTO apyNT_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Aorihtyã ekepyry anapopyra mana, tumyme ahtao ro, tyseme ahtao roropa, nuriame toexiryino. Nuriame toehse ynororo ahtao ");
INSERT INTO apyNT_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","aomomyryhtao Ritonõpo Tapyĩ Kurã taka, nuriame moro rĩko mana. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Oturukety imehxo exikety pytãko mana imehnõ maro exipitopỹ maro rokene; ");
INSERT INTO apyNT_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","pytỹpo maro pytara mana, imepỹ nurumekahpyry maro pytara roropa te, imeimehnõ poko exikety maro pytara mana, mokarohne anapoipyra mana typytyme. Orutua poko exipitopyra exikety maro rokẽ pytãko mana, Izyraeume exiketyme mokyro ahtao, ");
INSERT INTO apyNT_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","kure rokẽ ipoenõ, ipakomotyã roropa ehtohme nuriame pyra. Ywy ase Ritonõpo, ya mokyro tapiakase oturuketyme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","— Oturuko Arão a, apakomotyã kurãkõ ahtao rokẽ tonahsẽ enehnõko mã toto tynekaroryme ya. Jũme moro ynyripohpyry omipona ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Orutua kõ kure rokẽ exiketõ omõnõko mã toto tynekarory maro jẽpataka: tonurãkara omõpyra mana, ahmitahpyryme exikety te, ẽmyhpopyra exikety te, zoko poko tynyrohke exikety te, ");
INSERT INTO apyNT_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","emahpopyra exikety te, jaxiry aehtahkahpyry ahmitahpyry te, ");
INSERT INTO apyNT_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","tupue exikety te, kae pyra zuãtahpyry exikety te, tyrohsẽ hpe exikety enuru ao te, tyrohsẽ hpe exikety ipihpyry poko te, emukahpyry, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Orutua kõ emero oturukety Arão pakõme ahtao, jaxiry miramirame exiketyme ahtao tonahsẽ onenehpyra mana tynekaroryme ya; emero nuriame exiketõ ahtao tynekarory onekaropyra mã toto ya, jotyme. ");
INSERT INTO apyNT_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Moro tonahsẽ enahnõko mokyro mana, ahno nekarohpyry ya, inekarohpyry kurãme ahtao te, inekarohpyry kure kuhse ahtao roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Yrome oehpyra mana Osa Kurã Kuhse kamisã pũtokoxi te, oehpyra roropa mana apoto apõ pũtokoxi, kure pyra exiketyme exiryke, morohne ykyryry asakoro nuriame kamexiporyino. Ywy ase Ritonõpo. Morohne tapiakase ya nuriame pyra ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moro emero tokarose Moeze a, Arão tomo a, imũkuru tõ maro, Izyraeu tõ maro emero. ");
INSERT INTO apyNT_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Mame tõturuse Ritonõpo Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","ynara tyripotohme Arão tomo a imũkuru tõ maro: — Tomeseke ehtoko kure rokẽ ahno nekarotyã ritohme oya xine, ya tokarose exiryke, jesety nuriame onyripyra oehtohkõme. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Apakomotyã nuriame ahtao ahno nekarory kurã etaparyhtao tynekaroryme ya, jũme oturuketyme pyra exĩko mokyro mana. Sero ynyripohpyry oya xine jũme aomipona exikehpyra exĩko matose. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","— Arão pakomotyã tyrohsẽ hpe popyra ahtao ipihpyry poko te, kunu tũtaryhtao jaĩ ae otuhpyra mana ahno nekarotyã poko ya. Toekurãkase ropa ahtao rokẽ, nuriame pyra toehse ahtao moroto otuhnõko ropa mana. Nuriame exĩko oturukety mana nuriame exikety tapose ahtao eya, ahno ekepyry aporyke eya. Nuriame exĩko mana jeipyry tutũtase ahtao jaĩ ae te, ");
INSERT INTO apyNT_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","onokyro nuriame exikety tapose ahtao eya, ahno nuriame exikety tapose ahtao eya, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Nuriame exĩko mana xixi omõtoh pona, mame toepyse ahtao rokẽ ahno nekarotyã kurã po otuhnõko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Mame xixi tomõse ahtao nuriame pyra exĩko mana, otuhnõko mana ahno nekarotyã kurã po, morohne mokyro zohme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Tamoreme toorihse okyno ahtao ipũ onõpyra mana, tosekase ahtao onokyro tomo a ipũ onõpyra mana. Mokyro pũ tõse ahtao eya nuriame exĩko mana. Ywy ase Ritonõpo Jumãme Exikety. ");
INSERT INTO apyNT_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","— Oturuketõ emero ynyripohpyry omipona exĩko mã toto; moro omipona pyra toehse toto ahtao iirypyryme exĩko mã toto, aorikyry ke tuãnohsẽme exĩko mã toto. Ywy ase Ritonõpo, tapiakase toto ya nuriame pyra toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","— Oturuketõ rokẽ jekyry tõ maro otuhnõko mã toto ahno nekarotyã kurã po. Katonomo te, itapyĩ tao nyhketomo, oturuketõ poetory tõ roropa otuhpyra mã toto, ahno nekarotyã kurã po. ");
INSERT INTO apyNT_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Yrome inamotokõ topekahse ahtao eya te, tonuruse exiketõ roropa itapyĩ tao otuhnõko mã toto ahno nekarotyã kurã po. ");
INSERT INTO apyNT_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Oturukety ẽxiry niotaryhtao orutua maro, oturukety kara, otuhpyra exĩko mana ahno nekarotyã kurã po. ");
INSERT INTO apyNT_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Pytỹpome toehse ahtao, turumekase ynororo ahtao inio a, tumũkue pyra ynororo ahtao, tooehse ropa ahtao tumy tapyĩ taka ropa moroto ehse poetome toehtopõpyry samo, otuhnõko mana ahno nekarotyã kurã po. Oturuketõ rokẽ jekyry tõ maro otuhnõko mã toto ahno nekarotyã kurã po. ");
INSERT INTO apyNT_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","— Imepỹ oturukety ekyryme pyra ahtao, tuaro pyra ahtao, ahno nekarotyã kurã tõse ahtao eya, moro epehmãko mana oturukety a tõsẽ epehpyry maro ⅕me exikety maro. ");
INSERT INTO apyNT_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Oturuketõ tomeseke sã exĩko mã toto ahno nekarotyã kurã poko, tokarose exiryke Ritonõpo a, nuriame exipyra ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Ahno nekarotyã Ritonõpo a onõpopyra mã toto imehnomo a, oturuketõ ekyryme pyra exiketomo a. Tõse ahtao mokaro a zae pyra exĩko mã toto, tuãnohsẽme exĩko mã toto. Ywy ase Ritonõpo, ahno nekarotyã rĩko ase kurãme. ");
INSERT INTO apyNT_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Mame tõturuse Ritonõpo Moeze a, ");
INSERT INTO apyNT_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","ynara tyripotohme Arão a, imũkuru tõ maro, Izyraeu tõ maro emero: Okyno enepyryhtao Izyraeu tomo a, imehnomo a roropa tynekaroryme Ritonõpo a jahkatohme tytororo te, tõmihpyry zae ehtohme te, tamoreme tynekarory ekarory se tahtao, ");
INSERT INTO apyNT_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","okyno orutua kure exikety rokẽ kure mana. Pui ahtao te, kaneru te, poti roropa kure mã toto ");
INSERT INTO apyNT_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","tynyrohke pyra exiketyme ahtao. Okyno kure rokẽ exikety tonehse ahtao Ritonõpo zamaro mana. ");
INSERT INTO apyNT_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Okyno tonehse ahtao tynekaroryme osepeme ehtohme te, tõmihpyry omipona ehtohme te, tamoreme ekarory se tahtao, okyno atapuropyra exiketyme ahtao rokẽ kure mana. Pui mũkurume ahtao te, kaneru te, poti roropa, atapuropyra exiketyme ahtao rokẽ kure mana. ");
INSERT INTO apyNT_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Okyno tonurẽkara onenehpyra ehtoko onekarorykõme Ritonõpo a te, ãtakamatyã onenehpyra ehtoko, tynyrohke exikety, zuzu hpe te, oxi hpe ahtao, imepỹ tyrohsẽ ipihpyry poko ahtao roropa, mokarohne onenehpyra ehtoko onekaroryme Ritonõpo zohme. ");
INSERT INTO apyNT_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Amoreme xine okyno ekarory se awahtao xine onekarorykõme, pui mũkuru te, kaneru tynyrohke ro exikety kure ro mã repe. Yrome õmihpyry zae ehtoh epehpyryme mokyro onekaropyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Okyno onenehpyra ehtoko onekarorykõme Ritonõpo a emuru nuriame ahtao, tapurose ahtao, touse ahtao, tysahkase ahtao. Morohne zae pyra onekarorykõme mana Ritonõpo a Izyraeu tõ nonory po. ");
INSERT INTO apyNT_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Mokaro sã exiketõ ekarory se imehnõ nonory põkõ ahtao tynekarorykõme Ritonõpo a, anapoipyra ehtoko. Nuriamãkõ se pyra Ritonõpo mana. ");
INSERT INTO apyNT_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ynara tykase roropa Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","— Okyno tonuruse ahtao, pui te, kaneru te, poti roropa, ah tyse maro nexĩ toto 7me ẽmepyry pona. Moromeĩpo mokyro enepyry se awahtao enehnõko mase onekaroryme Ritonõpo zohme. ");
INSERT INTO apyNT_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Toiro ẽmepyry ae pui onetapara ehtoko ipoenõ maro onekaroryme Ritonõpo a te, kaneru ipoenõ maro te, poti ipoenõ maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Okyno etaparyhtao oya xine onekarorykõme “Kure mase” katohme ya, Ritonõpo Oesẽkomo a, ynyripohpyry omipona ehtoko moro poko zae oehtohkõme, yzamaro onekarorykõme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Onekarohpyry pũ õnõko matose toiro ẽmepyry ae, emero, akoĩpyry pyra ehtohme yrokororo. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","— Ynyripohpyry tõ omipona ehtoko. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Popyra ehtoh poko pyra ehtoko nuriame jesety kurã onyripyra ehtohme, Izyraeu tõ emero kure jehtoh ekarotohme! Ywy ase Ritonõpo. Tapiakase matose ya ypoetoryme oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Kuenepyatose Ejitu poe Oesẽkõme jehtohme. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Mame tõturuse Ritonõpo Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","ynara tyripotohme Izyraeu tomo a atãkyematoh tonõ ritoh poko Ritonõpo eahmatohme: ");
INSERT INTO apyNT_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Erohnõko matose 6me ẽmepyry ae, yrome ẽmepyry 7mã po oserematohme mana Ritonõpo omi poe. Moro ae erohpyra ehtoko. Oserematohme mana Ritonõpo poko oehtohkõme emero oesarykõ po. ");
INSERT INTO apyNT_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ynara atãkyematoh rĩko matose Ritonõpo eahmatohme, oseahmatoh ẽmepyry toehse ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Oseahmatoh tapyi tõ Epozakuroko Ritonõpo nenyokyhpyry ytotopõpyry poko, Ritonõpo Oesẽkõ eahmapitõko matose ikohmamyry ae ro ẽmepyry 14mã po, nuno apitorymã po. ");
INSERT INTO apyNT_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Yrokokoro ẽmepyry 15mã po moro nuno poro Oseahmatoh Wyi poko Iporutatoh maro pyra tyripitõko matose, Ritonõpo Oesẽkõ eahmaryme. 7me ẽmepyry ae moro oseahmatoh poko pão ohnõko matose iporutatoh maro pyra exikety. ");
INSERT INTO apyNT_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Moro ẽmepyry apitorymã po moro oseahmatoh poko erohpyra exĩko matose emero porehme, oximõnõko matose emero porehme Ritonõpo eahmatohme. ");
INSERT INTO apyNT_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","7me ẽmepyry ae anapyrykõ enehtoko onekarorykõme Ritonõpo a. Mame ẽmepyry 7mã po oximõtoko ropa Ritonõpo eahmatohme. Moro ẽmepyry ae erohpyra exĩko matose emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Mame tõturuse Ritonõpo Moeze a, ");
INSERT INTO apyNT_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Izyraeu tõ zurutohme: — Tomõse awahtao xine moro nono pona, ynekarory pona oya xine, tiriiku apoipitoryhtao oya xine, anapoihpyry osemazuhme toiro tymõse aroko oturukety a. ");
INSERT INTO apyNT_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Oserematoh mykapo moro tymõse tiriiku enehnõko oturukety mana Ritonõpo ẽpataka Ritonõpo zamaro oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Moro ẽmepyry ae ro okyno enehnõko matose onekarorykõme Ritonõpo a jahkatohme tytororo, toiro kaneru mũkuru maro toiro jeimamyry exikety, kurã rokene. ");
INSERT INTO apyNT_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Mokyro maro tiriiku apohpyry enehnõko matose 2 kirume otoxie azeite maro. Moro tyahkase ahtao typoxine exĩko Ritonõpo a mana. Enehtoko roropa eukuru onekarorykõme toiro rituru uwa eukuru jehnahpyry. ");
INSERT INTO apyNT_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Tiriiku onenahpyra ehtoko, exipyra ro ahtao te, tupuruse ahtao te, pãome tyrise ahtao, onekaropyra ro awahtao xine onekarorykõme Ritonõpo a. Sero ynyripohpyry oya xine omipona ehtoko emero oesarykõ po, amarokomo opoenõkomo, apakomotyã roropa, jũme. ");
INSERT INTO apyNT_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","— Mame moro tiriiku apitorymã tonehse oya xine ahtao onekarorykõme Ritonõpo a, 7me semana aropotoko. ");
INSERT INTO apyNT_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Moromeĩpo yrokokoro, 50me ẽmepyry taropose ahtao tiriiku apitorymã tokarose ahtao Ritonõpo a, imepỹ tykyrysã enehtoko onekarorykõme Ritonõpo a, anapoihpyrykõ poe. ");
INSERT INTO apyNT_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Emero tapyi esẽ asakoro pão tõ enehnõko, tiriiku kurã risemy iporutatoh maro tyrihpyry. Toiro pão 2 kirume exiketyme exĩko mana. Moro pão tõ onekarorykõme exĩko mana Ritonõpo Oesẽkomo a. ");
INSERT INTO apyNT_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Moro pão tõ maro 7me kaneru mũkuru tõ enehnõko matose, toiro jeimamyry nae exiketomo, kure rokẽ exiketomo, toiro pui mũkuru maro te, asakoro kaneru tõ maro. Mokarohne etapãko matose, jahkatohme tytororo onekarorykõme Ritonõpo a, moro tiriiku maro te, uwa eukuru jehnahpyry maro. Moro tonahsẽ zatyry typoxine exĩko Ritonõpo a mana. ");
INSERT INTO apyNT_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Toiro poti etapako roropa jahkatohme, oorypyrykõ korokapotohme te, asakoro kaneru tõ maro, toiro jeimamyry nae exiketomo onekarorykõme osepeme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Mokaro kaneru asakoro etapãko oturukety mana jahkatohme tynekaroryme Ritonõpo a pão tõ maro tynekarory kurãme Ritonõpo a. Morohne ahno nekarohpyry kurã oturuketõ zohme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Moro ẽmepyry ae erohpyra exĩko matose emero porehme, oximõnõko roropa matose Ritonõpo eahmatohme. Moro ynyripohpyry oya xine omipona ehtoko emero oesarykõ po, amarokomo, opoenomo te, apakomotyã roropa, jũme. ");
INSERT INTO apyNT_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","— Tiriiku tõkehko tapoise ahtao oya xine otupikõ po moro onysahkara ehtoko tupito ehpikuroko, ytopyra ropa ehtoko otyro akoĩpyry apoise. Moro inomoko tymõkomokãkara napyryme, imehnõ nono poe aehtyã napyryme, enara. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Mame tõturuse Ritonõpo Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","ynara Izyraeu tõ zurutohme: — Ẽmepyry apitorymã po, nuno 7mã po oserematohme mana atãkyematohme jeahmatoh poko, rue tõ etory poko; oximõtoko emero porehme Ritonõpo eahmatohme. ");
INSERT INTO apyNT_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Moro ẽmepyry ae erohpyra ehtoko, tonahsẽ enehtoko onekarorykõme Ritonõpo Oesẽkomo a. ");
INSERT INTO apyNT_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Mame tõturuse Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","— Ẽmepyry 10me aehtoh ae, nuno 7mã po, ahno rypyry korokatohme exĩko mana. Moro ẽmepyry ae otuhpyra ehtoko emero porehme te, tonahsẽ enehtoko jahkatohme onekarorykõme Ritonõpo Oesẽkomo a. ");
INSERT INTO apyNT_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Moro ẽmepyry ae erohpyra ehtoko, moro ae okyno totapasẽme exĩko jahkatohme onekarorykõme Ritonõpo Oesẽkomo a, oorypyrykõ korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Moro Ẽmepyry Ahno Rypyry Korokatoh ae tonahsẽ enapyryhtao ahno a, mokyro taroposẽme exĩko mana Izyraeu tõ htae. ");
INSERT INTO apyNT_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Moro ẽmepyry ae erohtoh poko toehse ahno ahtao, ywy roro mokyro enahkapõko ase. ");
INSERT INTO apyNT_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Moro ẽmepyry ae erohpyra ehtoko; emero oesarykõ po, amarokomo, opoenomo te, apakomotyamo, jũme moro ynyripohpyry omipona exikehpyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Xixi omõtoh poe ẽmepyry 9me aehtoh po xixi omõtoh pona ẽmepyry 10me aehtoh pona, oserematohme exĩko mana Ritonõpo omi poe, moro ẽmepyry ae otuhpyra matose emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Tõturuse Ritonõpo Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","ynara tyripotohme Izyraeu tomo a: Ẽmepyry 15me aehtoh po, nuno 7mã po Oseahmatoh Tapyi Pisarara poko exĩko mana. Moro oseahmatoh ae Ritonõpo Imehxo Exikety eahmãko matose, 7me ẽmepyry aropõko matose moro poko. ");
INSERT INTO apyNT_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ẽmepyry osemazupu po oximõnõko matose Ritonõpo eahmatohme, erohpyra exĩko matose emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kokoro rokẽ tonahsẽ enehnõko matose jahkatohme onekarorykõme Ritonõpo Oesẽkomo a, 7me ẽmepyry ae moro rĩko matose. Mame ẽmepyry 8me aehtoh po oximõnõko matose emero porehme Ritonõpo eahmatohme, tonahsẽ zahkatohme roropa onekarorykõme eya. Moro ẽmepyry ae Ritonõpo eahmary poko rokẽ exĩko matose oximõme, erohpyra matose emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(Morohne oseahmatoh tonõ mã imoihmãkõ oximõtohme, Ritonõpo Tosẽkõ eahmatohme. Moro poko õseahmarykohtao tonahsẽ enehnõko matose jahkatohme onekarorykõme Ritonõpo a, okyno tõ zahkatohme tytororo, tiriiku tõkehko, okyno tomo, uwa eukuru jehnahpyry onekarorykõme. Emero oseahmatoh tonõ tyrise eya xine ẽmepyry po, nuno po, Ritonõpo nyripohpyry omi poe. ");
INSERT INTO apyNT_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Morohne maro oserematoh tonõ tapiakase Ritonõpo eahmatohme Tosẽkõme, Oseahmatoh tonõ tyritoko te, onekarorykõ enehtoko Ritonõpo a imehnõ nekarory tõ maro te, onekarorykõ õmihpyrykõ anamonohpyra oehtohkõme te, onekarorykõ amoreme xine ekarory se oehtohkõ roropa Ritonõpo a.) ");
INSERT INTO apyNT_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Õkyryrykõ tapoikehse ahtao oseahmatoh rĩko matose Ritonõpo eahmatohme Oesẽkomo. Moro oseahmatoh exipitõko ẽmepyry 15me aehtoh poe, nuno 7mã po. Mame oseahmãko ẽmepyry 22me aehtoh pona. Ẽmepyry osemazuhmã po etyhpyrymã po roropa erohpyra exĩko matose. ");
INSERT INTO apyNT_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ẽmepyry osemazuhmã po epery apoĩko matose, wewe kurã epery, marariary tõkehko sahkãko roropa matose, wewe amoriry roropa tarỹke exiketomo. Mame 7me ẽmepyry ae oseahmãko matose, kure Ritonõpo riry poko, Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Jũme, emero jeimamyry ae, nuno 7mã po moro oseahmatoh rĩko matose 7me ẽmepyry ae. ");
INSERT INTO apyNT_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Mame moro 7me ẽmepyry ae Izyraeu tõ emero exĩko tapyi tõ pisarara tao, moro wewe amoriry risẽ tao, ");
INSERT INTO apyNT_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","wenikehpyra toto ehtohme, ipoenomo te, ipakomotyã roropa jũme typoetory tõ tyripose Ritonõpo a tapyi tõ pisarara taka, Ejitu poe tarose toto ahtao eya. Ritonõpome mana, Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Moro sã Ritonõpo nyripohpyry tokarose Moeze a Izyraeu tomo a, oseahmatoh tonõ riry poko eya xine, Ritonõpo Imehxo eahmatohme, Tosẽkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Mame tõturuse Ritonõpo Moeze a ynara tyripotohme ");
INSERT INTO apyNT_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Izyraeu tomo a: Azeite kurã enehtoko ezuru ezehpyra ehtohme Tapyi Kurã tao. ");
INSERT INTO apyNT_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Kokoro rokẽ kokonie pukuro nãparina tõ zukãko Arão mana ezuru apõ po, saereh kakehpyra ẽmehtohme moroto Ritonõpo, Izyraeu tõ Esẽ ẽpataka, kamisa poe jarãnaka, Ritonõpo omiry ẽ etonie. Sero ynyripohpyry omipona ehtoko, amarokomo, opoenomo te, apakomotyã roropa jũme jomiry omipona exikehpyra oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Moro nãparina tõ zuru kurãkãko Arão mana ezuru apõ uuru risẽ po, ezehpyra ehtohme Ritonõpo ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","12me pão tõ tyriko, toiro ahtao asakoro kirume ehtohme, tiriiku kure apohpyry risemy, ");
INSERT INTO apyNT_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","tyritohme meza uuru risẽ pona Ritonõpo Oesẽkõ ẽpataka. Moro pão tõ tyriko asakoro atakenaka ehtohme, 6me toiro atakenaka ehtohme, 6me zakorõ atakenaka ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Moro atakenaka exiketõ pona ixtaratu kurã tyriko enetupuhpotohme moro pão tõ emero tokarose Ritonõpo a tonahsẽme. ");
INSERT INTO apyNT_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Emero oserematoh ae, jũme, pão tõ rĩko Oturukety imehxo exikety mana atakenaka, meza pona Ritonõpo ẽpataka. Moro pão tõ enetupuhpotohme mã kehko jũme osepeme Izyraeu tõ ehtoh poko Ritonõpo maro. ");
INSERT INTO apyNT_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Naeroro jũme Arão tõ napyryme exĩko mana ipakomotyã maro. Moro pão kure kuhse mana tokarose exiryke Ritonõpo a tonahsẽme; morara exiryke moro pão ohnõko oturuketõ mana osa kurã tao. ");
INSERT INTO apyNT_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Mame orutua nexiase Ejitu põ mũkuru Izyraeu nohpory maro. Mokyro nohpo esety Seromiteme nexiase, Tipiri ẽxiry, Tã tõ ekyryme nexiase. Mame tupito po ahtao tãtatapoipitose ynororo Izyraeume exikety maro. ");
INSERT INTO apyNT_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Atatapoiryhtao tomiase ynororo xihpyryme, Ritonõpo tosehtose eya popyra ehtoh enehpotohme. Mokyro tarose eya xine Moeze a, ");
INSERT INTO apyNT_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ãpuruhpyry tao tynomose eya xine, Ritonõpo omiry etatohme otara tyko mokyro ritohme. ");
INSERT INTO apyNT_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","— Mokyro arotoko pata poe jarãnaka. Mame mokaro, aomiry etahpõkomo tomary rĩko mã toto mokyro zuhpokoxi, mame mokyro etapãko mã toto imoihmãkomo topu tõ ke. ");
INSERT INTO apyNT_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ynara kaxiko ahno a: “Popyra Ritonõpo Oesẽkõ tyripose mokyro a. Naeroro tyyrypyry epehmãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Taorihmaposẽme exĩko mana imoihmãkomo a topu tõ ke. Izyraeume exiketyme ahtao te, imepỹ nono põme ynororo ahtao otara kara; popyra Ritonõpo esety tyripose ahtao taorihmaposẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","— “Imepỹ etapahpono taorihmaposẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Imepỹ eky totapase ahtao ahno a, esemy a imepỹ okyno ekarõko mokyro mana isã exiketyme ipunaka, mokyro eky myakãme. ");
INSERT INTO apyNT_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Imepỹ tyyryhmase ahtao ahno a, isaaro mokyro ryhmãko roropa toh mana inyrihpyry sã ipunaka: ");
INSERT INTO apyNT_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","zehpo tytahkase eya ahtao, isaaro jehpyry tahkãko toh mana; enuru typosohkase ahtao, isaaro enukãko roropa mã toto; imepỹ zery tytahkase ahtao, isaaro jery tahkãko roropa toh mana; tapurose ahtao, apurõko roropa mã toto isaaro. ");
INSERT INTO apyNT_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Okyno etaparyhtao imepỹ eky, mokyro esẽ epehmãko roropa toh mana ipanõ ke. Ahno etaparyhtao, totapasẽme exĩko mokyro mana. ");
INSERT INTO apyNT_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Moro ynyripohpyry oxisã mã oya xine Izyraeume exiketomo a, imehnomo a roropa. Ywy ase Ritonõpo Oesẽkomo.” ");
INSERT INTO apyNT_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mame moro emero tokarose Moeze a Izyraeu tomo a. Mame mokyro popyra Ritonõpo esety popyra rihpono tarose mya pata poe. Moroto totapase ynororo eya xine topu tõ ke. Moro ke emero tyrise eya xine Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mame tõturuse Ritonõpo Moeze a ypy Xinai po ");
INSERT INTO apyNT_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","ynara tyripotohme Izyraeu tomo a: Toeporehkase awahtao xine ynekarory pona ononorykõme, 7me, 7me jeimamyry taropose ahtao, jomi poe otupikõ anarykara ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","6me jeimamyry ae otupikõ arykãko matose, uwa zoko amoriry tõ sahkãko matose te, anarykahpyrykõ epery apoĩko matose. ");
INSERT INTO apyNT_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Yrome jeimamyry 7mã po ononorykõ oserematohme exĩko mana, Ritonõpo imehxo Ehtoh enetupuhtohme. Moro jeimamyry ae otupikõ anarykara exĩko matose, uwa amoriry onysahkara exĩko matose, enara. ");
INSERT INTO apyNT_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Tamoreme tiriiku toperytase ahtao, moro epery anapoipyra ehtoko, uwa amoriry tõ onysahkara ehtoko, uwa epery anapoipyra roropa ehtoko. Jeimamyry oserematohme exĩko mana ipunaka, nono oserematohme. ");
INSERT INTO apyNT_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Otupikõ anarykara ahtao ro moro jeimamyry ae, tonahsẽme exĩko mana anapyrykõme, anamotokõ napyryme, topehke erohketõ napyryme imehnõ nonory poe aehtyã napyryme te, ");
INSERT INTO apyNT_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","okyno tõ napyryme te, onokyro tõkehko napyryme ona po, enara. Tykyrysã emero ahtatyã tonahsẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","7me 7mãkõ jeimamyry kuhnõko matose, atapona 49me jeimamyry ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Mame ẽmepyry 10me ehtoh po, nuno 7mã po, Ẽmepyry Ahno Rypyry Korokatohme mana, ahno aropoko rue etotohme ononory poro porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Moro jeimamyry 49me jeimamyry mykapo, jeimamyry aosanumatyã myhpokatohme exĩko ropa mana Ritonõpo omi poe. Moro ae imoihmãkõ zurũko matose: emero porehme sero nono põkõ tymyhpokasẽme ropa exĩko mã toto. Moro jeimamyry ae emero ahno, ekamotyã imehnõ namotome aehtyã oehnõko ropa mã toto imyhpokatyã ropa tyekyry tomo a ropa; nono roropa ekarohpyry ahtao, esẽ apitorymã apoĩko ropa mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Moro jeimamyry ae otupikõ anarykara matose, tiriiku anapoipyra matose tamoreme tahtase ahtao, uwa amoriry onysahkara exĩko matose, uwa epery anapoipyra roropa matose. ");
INSERT INTO apyNT_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Moro Jeimamyry Emyhpokatoh ropa mana, tapiakase jeimamyry kurãme Ritonõpo nyripohpyry ae, moro ae otuhnõko matose moroto, tamoreme ahtatyã enahnõko matose. ");
INSERT INTO apyNT_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Moro Jeimamyry Emyhpokatoh ae tupito tõ ekamotyã apoĩko ropa esẽ osemazuhme aexihpyry ropa mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Nono epekatyryhtao oya, ekamoryhtao roropa oya, imehnõ onymotyẽkara ehtoko typynehxo epehmapory poko. ");
INSERT INTO apyNT_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","16","Epehpyry menekãko matose jeimamyry kukuruhtao Jeimamyry Emyhpokatoh ropa poe; ynara exiryke nono nymyry onepekahpyra matose, jeimamyry ae tykyrysã apoĩko rokẽ matose. Naeroro epekahne a epehpyry enyhtõko matose jeimamyry tõ kuhnõko Jeimamyry Emyhpokatoh ropa poe; ekamone roropa jeimamyry kuhnõko mana otãto ise ro Jeimamyry Emyhpokatoh ropa pona. Tuhkehxo jeimamyry ise ro ahtao epehpyry typynehxo exĩko mana, tuhke pyra ise ro ahtao typyne hkopyra nono epehpyry exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Imehnõ onymotyẽkara ehtoko typynehxo epehmapory poko; Ritonõpo Oesẽkõ omipona ehtoko. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Ritonõpo omihpyry omipona ehtoko, inyripohpyry tõ roropa oya xine omipona ehtoko towomase oehtohkõme moro nono po. ");
INSERT INTO apyNT_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Tykyrysã ahtãko mana, anapyrykõ apoĩko matose, opune xine exĩko mana, mame towomaneke exĩko matose, emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Yrome otarame ahno ynara ekaropõko: Otãto tonahsẽ exĩko nae jeimamyry 7mã po otyro anarykara emero ahtao, apoitoh po pyra ahtao roropa? ");
INSERT INTO apyNT_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Ezuhtoh ynara mana: jeimamyry 6mã po kure rokẽ nono rĩko Ritonõpo mana, itamurumehxo ahtãko mana, mame õkyryrykõ apoĩko matose oseruao jeimamyry pune ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Mame otupikõ tarykase ahtao oya xine jeimamyry 8mã po tonahsẽ enahnõko ro matose anapoihpyrykõ jeimamyry 6mã po, anapyrykõ ipune exĩko mana apoitoh jeimamyry 9mã pona. ");
INSERT INTO apyNT_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Nono esẽme Ritonõpo mana; naeroro nono topekahse ahtao ahno a jũme pyra moro nono esẽme exĩko mokyro mana. Esẽme nymyry Ritonõpo mana, katonõme rokẽ sytatose eya, axĩtao rokẽ osesarĩko sytatose inonory po. ");
INSERT INTO apyNT_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Nono tokamose ahtao, esemỹpyry apitorymã osemazuhme epekahnõko mana, epekatyry se tahtao rokene. ");
INSERT INTO apyNT_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Izyraeume exikety tytineruke pyra toehse ahtao, tynonory zokonaka ekamory se toehse tahtao, jekyry ameke pyra exikety moro nono epekatyry se tahtao, epekahnõko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Yrome tyekye pyra ahno ahtao inonory epekahtohme, otarame imeĩpo tytineruke exĩko ropa mã ynororo, mame moro nono tynekarohpyry epekatyry se exĩko ropa mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Moro nono epehmãko mana, jeimamyry tõ kuhnõko: otãto tykyrysã apoitoh exĩko nah imepỹ Jeimamyry Emyhpokatoh ropa pona? Mame moro epehmaryke tynonorỹpyry esẽme exĩko ropa mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Yrome itinerũ ipune pyra ahtao moro nono epekahtohme, moro nono exĩko ro epekatyhpõ maro imepỹ Jeimamyry Emyhpokatoh ropa pona. Mame moro Jeimamyry Emyhpokatoh ropa ae moro nono apoĩko ropa esemỹpyry apitorymã mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Tapyi tokamose ahtao ahno a pata apuruhpyryme exikety po, tytapyinỹpyry epekatyry se ropa tahtao toiro jeimamyry anaropopyra ro ahtao epekahnõko ropa esemỹpyry mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Yrome toiro jeimamyry taropose ahtao, tytapyinỹpyry onepekahpyra ropa ahtao, jũme moro tapyi epekatyhpõ tapyĩme exĩko mana ipoenõ maro, ipakomotyã maro. Mame Jeimamyry Emyhpokatoh ropa toehse ahtao moro tapyi anapoipyra ropa esemỹpyry apitoryme aexihpyry mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Yrome tapyi pata po ahtao, apuru pyra pata ahtao, nono sã rokẽ exĩko mana. Esemỹpyry apitorymã tytapyinỹpyry epekatyry se ropa ahtao epekahnõko ropa mana. Mame Jeimamyry Emyhpokatoh ropa toehse ahtao esemỹpyry apitorymã moro tapyi esẽme exĩko ropa mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Jũme tytapyinỹpyrykõ epekahnõko rewita tõ mana typatarykõ po ise tahtao xine. ");
INSERT INTO apyNT_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Yrome tytapyĩ tokamose ahtao rewita a, typatary po, mame moro tapyi onepekahpyra ropa ahtao eya, Jeimamyry Emyhpokatoh ropa toehse ahtao moro tapyi ikyryryme exĩko ropa mana; ynara exiryke, tapyi tõ rewita tõ patary tõ po jũme rewita tõ kyryryme exĩko mana Izyraeu tõ nonory po. ");
INSERT INTO apyNT_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Yrome ona te, tupito tõ roropa rewita tõ patary zomye onekamosaromepyra matose; rewita tõ kyryryme morohne exikehpyra mã kehko, jũme. ");
INSERT INTO apyNT_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Izyraeume exikety tymõkomoke pyra toehse ahtao, aetuarimaryhtao mokyro akorehmatoko. Ipyno ehtoko imehnõ nono poe aepyhpyry samo, isene ro aehtohme amaro xine. ");
INSERT INTO apyNT_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Axĩtao rokẽ tineru ekaroryhtao eya, moro motye onepehmapopyra ehtoko eya. Ritonõpo nyripohpyry omipona ehtoko, isene ro mokyro ehtohme amaro xine. ");
INSERT INTO apyNT_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Axĩtao rokẽ tineru tokarose oya xine ahtao eya moro motye onepehmapopyra ehtoko eya, tonahsẽ ekamoryhtao eya, epehpyry onymotyẽkara ehtoko tuhke tineru apoitohme. ");
INSERT INTO apyNT_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Moro Ritonõpo Kuesẽkõ nyripohpyryme mana kyya xine. Ejitu poe kuenepyatose sero nono ekarotohme kyya xine Kanaã po, Kuesẽkõme aehtohme roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Izyraeume exikety tymõkomoke pyra toehse ahtao ipunaka, mame tõsekarory se toehse ahtao oya anamotome tineru apoitohme, mokyro onyrohmanohpopyra ehtoko namotome. ");
INSERT INTO apyNT_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Topehke erohketyme rokẽ mokyro tyritoko, katonõme sã mokyro tyritoko. Erohnõko amaro xine mana Jeimamyry Emyhpokatoh ropa pona. ");
INSERT INTO apyNT_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Mame moro jeimamyry toehse ahtao typoenõ maro ytõko ropa mana tyekyry tomo a, tytamurukõ nonory pona ropa. ");
INSERT INTO apyNT_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Tosẽkõ Ritonõpo namotome rokẽ Izyraeu tõ mana, tonehse toto eya Ejitu poe; imehnõ namotome toto onekamopyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Naeroro toto onyrohmanohpopyra ehtoko, Ritonõpo nyripohpyry omipona ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Namoto tõ epekatyry se awahtao xine imehnõ nonory põkõ epekahtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Imehnõ nonory põkõ poenõ, amaro xine aexityã epekatyry se awahtao xine, mokaro epekahtoko anamotokõme toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Mokaro esẽkõ ise tahtao toto nomõko mana tumũkuru tõ namotome, jũme mokaro maro toto ehtohme toorikyrykõ ponãmero. Yrome Izyraeume exikety imepỹ Izyraeume exikety anamotome onyripyra ehtoko, onyryhmara roropa ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Otarame imepỹ nonory poe aepyhpyry itamurume tytineruke exĩko mana. Mame otarame Izyraeume exikety tymõkomoke pyra toehse ahtao tõsekarory se exĩko mana mokyro namotome, jekyry namotome roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Moro toehse ahtao tõsekarose Izyraeume exikety ahtao tymyhpokary se ropa ynororo ahtao osepekahnõko ropa mana. Irui te, otarame zakorony, ");
INSERT INTO apyNT_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","jũ akorony te, irui roropa, jekyryme ahtao mokyro epekahnõko mana. Tineru tapoise ahtao eya ro, ipune ahtao tymyhpokatoh epehmãko mana tosẽke pyra toytotohme ropa. ");
INSERT INTO apyNT_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Oturũko mana tosẽ maro atae toto ehtohme epehpyry poko. Ikuhnõko mã toto otãto jeimamyry nae tõsekarotopõpyry poe Jeimamyry Emyhpokatoh ropa pona. Mame ikuhnõko mã toto erohkety epehpyry poko aerohtamitume. ");
INSERT INTO apyNT_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Tuhke jeimamyry ise ro ahtao Jeimamyry Emyhpokatoh ropa pona isã zokonaka ekarõko ropa mana moro tineru apoihpyry poe. ");
INSERT INTO apyNT_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Yrome tuhke pyra jeimamyry ise ro ahtao pitikohxo epehmãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Mokyro esemy mokyro rĩko mana erohkety samo jeimamyry ae topehmase ahtao typoetoryme aerohtohme. Mokyro onyryhmara esẽ monehtane kamexipotoko eya. ");
INSERT INTO apyNT_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Moro sã onymyhpokara mokyro toehse ahtao, Jeimamyry Emyhpokatoh ropa toehse ahtao tymyhpokasẽme exĩko mokyro mana ipoenõ maro. ");
INSERT INTO apyNT_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ynara exiryke Izyraeu tõ Ritonõpo namotome mã toto tonehse exiryke eya Ejitu poe. Ynororo rokẽ Ritonõpome mana, toto Esẽme mana. ");
INSERT INTO apyNT_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Mame ynara tykase Ritonõpo Izyraeu tomo a: — Ritõ panõ, oneponãmarykõ onyripyra ehtoko ipunaka, ahno panono te, xikihme exikety eahmatohme te, topu risẽ imehnõ panõ axikahpyry eahmatohme. Mokaro oneahmara ehtoko; ywy Ritonõpo Oesẽkõme ase. ");
INSERT INTO apyNT_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Kure rokẽ oserematoh tyritoko jeahmatohme, jesary roropa kure tyritoko moroto toahmase jexiryke oya xine. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","— Jomihpyry omipona awahtao xine, ynyripohpyry tõ roropa, emero riryhtao oya xine jomipona, ");
INSERT INTO apyNT_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","konopo enehpõko ase konopo oehtoh po toehse ahtao. Anarykarykõ kure ahtãko mana, itamurume tykyrysã exĩko mana, wewe tõ roropa eperytãko mã kehko. ");
INSERT INTO apyNT_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Tonahsã apoiryhtao oya xine itamurume exĩko mana, tiriiku tõkehko apoĩko ro matose uwa epery apoitoh po toehse ahtao, mame uwa apoĩko ro matose tupito po arykatoh toehse ahtao. Anapyrykõ opune xine exĩko mana tuesapare emero oehtohkõme, towomasẽme exĩko roropa matose ononorykõ po. ");
INSERT INTO apyNT_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","— Osepeme ehtoh ekarõko ase oya xine torẽtyke pyra oehtohkõme ononorykõ po. Enaromyra nyhnõko matose emero porehme, onokyro tõ, osekatõ kõ pyra tyripõko ase, etonatoh enahkapõko ase roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Oepekõkara poremãkãko matose, toto enahkãko matose; ");
INSERT INTO apyNT_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","amarokõ omame ahtao 100me oepetõkara poremãkãko matose, 100me awahtao xine 10 miumãkõ poremãkãko matose. Toto etapãko matose emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Kure ehtoh enehpõko ase oya xine, opoenõkõ tuhke ekarõko ase oya xine. Jomiry etapotopõpyry oya xine tyrĩko ase oya xine. ");
INSERT INTO apyNT_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Õkyryrykõ apoiryhtao oya xine itamurumehxo apoĩko matose, tiriiku pakato pahnõko matose osa nae ehtohme apoisenã kurãkatohme. ");
INSERT INTO apyNT_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Osesarĩko ase arãnao xine, Ytapyĩ Kurã tao, jũme orumekara xine exĩko ase. ");
INSERT INTO apyNT_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Amaro xine exikehpyra exĩko ase; ypoetoryme exĩko matose, Oesẽkõme exĩko ase. ");
INSERT INTO apyNT_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ywy ase Ritonõpo Oesẽkomo. Kuenepyatose Ejitu poe, Ejitu tõ namotome pyra oehtohkõme. Amarokõ tymyhpokase ya imehnõ namotome pyra oehtohkõme, xikihme oytotohkõme, oupuhpyrykõ kae rokẽ ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","— Yrome ynyripotyã oya xine omipona pyra awahtao xine, ");
INSERT INTO apyNT_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","jomihpyry rumekaryhtao oya xine, ynyripohpyry se pyra awahtao xine, ynetapohpyry oya xine omipona pyra awahtao xine, ");
INSERT INTO apyNT_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","awãnohtorỹko ase. Popyra ehtoh enehpõko ase oya xine, tyrohsemy, oxirohtopo, tonure pyra ehtopo, jamihme pyra zoko ehtoh roropa. Toiparo rokẽ tupito tõ arykãko matose, anapyrykõ enahnõko oepekõkara mana. ");
INSERT INTO apyNT_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ãkorekehkatorỹko ase, oporemãkapotorỹko ase oepekõkara a. Typoetoryme oritorỹko mã toto, epãko matose oekahmara xine imehnõ ahtao ro. ");
INSERT INTO apyNT_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","— Morarame morohne toehse ahtao jomiry omipona pyra ro awahtao xine, yrome oorypyrykõ poko ro awahtao xine, awãnohtopõpyrykõ motye 7me enehpõko ase awãnohtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ajamitunurukõ enahkapõko ase, ipoko epyrypãko mexiatose; konopo onenehpopyra exĩko ase, mame nono tũpore exĩko mana kurimene samo. ");
INSERT INTO apyNT_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Toiparo rokẽ erohnõko matose otupikõ poko etaehnõko; anarykahpyrykõ eperytara exĩko mã kehko, wewe tõ roropa eperytara ekurehnõko mã kehko. ");
INSERT INTO apyNT_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","— Mame morohne toehse ahtao oorypyrykõ poko ro awahtao xine, jurumekaryhtao ro, ynyripohpyry tõ omipona pyra roropa awahtao xine awãnohtohkõ popyrahxo 7me enehpõko ase. ");
INSERT INTO apyNT_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Onokyro tõkehko enehpõko ase arãnaka xine, zehno exiketomo opoenõ esekatohme, oeky tõ enahkãko mã toto, ahno esekãko roropa tuhke, ytoytoketõ pyra exĩko mana osema ae. ");
INSERT INTO apyNT_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","— Mame moro sã toehse ahtao, oehpyra ropa awahtao xine ya, yrome jomiry omipona pyra ro awahtao xine, ");
INSERT INTO apyNT_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","oepeme pyra exĩko ase, mame awãnohtorỹko ase 7me jetuhxo exikety ke. ");
INSERT INTO apyNT_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Osetapatoh enehpõko ase opona xine awãnohtohkõme ynetapohpyry oya xine omipona pyra toehse oexirykõke. Mame õximomyrykohtao pata tõ po õsewomatohkõme, tyrohsẽ popyra exikety enehpõko ase oya xine, morarame rokẽ exĩko matose osekarotohme oepetõkara a. ");
INSERT INTO apyNT_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Awãnopyrykõke ya anapyrykõ pitikohxo exĩko mana, 10me nohpo tõ pune toiro orinato exĩko mana wyi ekeitohme. Mame wyi zokonaka pitiko rokẽ apoĩko toiro ahno mana, omise ro exĩko mana, tuesapare pyra toexiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","— Moro sã toehse ahtao jomiry omipona pyra ro awahtao xine, yrome oorypyrykõ poko ro awahtao xine, ");
INSERT INTO apyNT_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","tohne jexiryke awãnohtorỹko ase oorypyrykõ pokoino 7me popyrahxo exikety ke. ");
INSERT INTO apyNT_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Tonahsẽ pyra exĩko mana yronymyrymehxo, opoenõkõ õnõko matose omise oexirykõke. ");
INSERT INTO apyNT_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Tohne exĩko ase ipunaka opoko xine: toponãmasã eahmatoh esary pahnõko ase, ixtaratu zahkatoh tonõ roropa, oekepyrykõ emãko ase oneponãmarykõ aepukatyã pona. ");
INSERT INTO apyNT_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Pata tõ enahkãko ase, patãpome inomõko ase kehko. Tapyi tõ Kurã jeahmatoh pahnõko ase, oeky tõ zahkaryhtao onekarorykõme ya ise pyra exĩko ase. ");
INSERT INTO apyNT_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Oesarykõ pahnõko ase nono pona ipunaka, oepetõkara moro eneryke tyya xine osenuruhkãko mã toto, oserehnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Osetapatoh enehpõko ase oya xine. Sapararahme aropotorỹko ase imeimehnõ nonory pona; ononorykõ po ahno pyra exĩko mana, patãpome exĩko mã kehko. ");
INSERT INTO apyNT_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Moro sã moro nono oseremãko sã mana jeimamyry tõ ae. Tytaõke pyra toehse nono ahtao, sapararahme awahtao xine imehnõ nonory po, moro nono jeimamyry tõ ae oseremãko sã mana; ");
INSERT INTO apyNT_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","oseremara exiryke jeimamyry tõ ae, moroto awahtao xine. ");
INSERT INTO apyNT_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","— Amarokõ isene ro exiketõ imeimehnõ nonory po oserehnõko matose, ituary epukary etaryhtao oya xine epãko matose; epãko matose oekahmanekõ sã oepetõkara a, epukãko matose ozehnotokõ pyra ahtao opũto xine. ");
INSERT INTO apyNT_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Osetapãko matose osepona, osetapaketõ samo, ozehno exiketõ pyra ahtao. Mame oepetõkara toehse ahtao apotũkepyhpyry sã exĩko matose, osetapasaromepyra exĩko matose. ");
INSERT INTO apyNT_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Orihnõko matose imeimehnõ nonory po, moroto tonẽsẽme exĩko matose. ");
INSERT INTO apyNT_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ãkoĩpyrykõ isene ro exiketõ oepetõkara nonory po, osenahkãko matose oorypyrykõ pokoino, atamurukõ rypyhpyry pokoino roropa. ");
INSERT INTO apyNT_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","— Yrome apakomotyã osekarõko mã toto iirypyryme toexirykõ poko te, tytamurukõ rypyhpyry tõ ekarõko roropa mã toto; ynyripohpyry omipona pyra aexityamo, otato pyra toexirykõke ");
INSERT INTO apyNT_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","tymaro xine pyra tyripose ywy eya xine. Naeroro taropose toto ya epekõkara nonory pona. Moromeĩpo tyyrypyrykõ rumekary se ropa toehse toto ahtao, imehnõ neponãmary tõ poko se pyra toehse toto ahtao, tuãnohse toto ahtao tyyrypyrykõ epehpyryme, ");
INSERT INTO apyNT_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ywy wenikehpyra exĩko ase ynetapohpyry poko Jako a, Izake a, Aparão a, enara. Wenikehpyra exĩko ase roropa nono, ynekarory poko. ");
INSERT INTO apyNT_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","— Yrome apakomotyã sapararahme ahtao imehnõ nonory po, moro nono ynekarohpyry oya xine patãpome exĩko mana, oseremãko sã rokẽ mana jeimamyry tõ ae. Apakomotyã ynyripohpyry omipona pyra toehse toexirykõke tyyrypyrykõ epehmãko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Yrome topekõkara nonory poro toto ahtao toto onurumekara exĩko ase, toto onenahkara exĩko roropa ase. Ynetapohpyry eya xine anamonohpyra ase. Ywy ase Ritonõpo, toto Esemy. ");
INSERT INTO apyNT_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Mãpyra jomihpyry poko wenikehpyra ase, ynetapohpyry itamurukomo a yjamitunuru tonepose ya ahtao imehnõ nonory põkomo a, emero, Ejitu poe ypoetory tõ tonehse ahtao ya, toto Esẽme Jehtohme. Ywy ase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Morohne Ritonõpo omiry, inyripohpyry tõ roropa, ekarotohme Izyraeu tomo a. Morohne tokarose eya Moeze a, ypy Xinai po. ");
INSERT INTO apyNT_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Tõturuse Ritonõpo Moeze a ");
INSERT INTO apyNT_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","ynara tyripotohme Izyraeu tomo a: Ahno tapiakase ahtao Ritonõpo namotome ehtohme, mame tymyhpokary se ropa toehse ynororo ahtao, zae epehpyry epehmãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ynara imerõko mase zae epehmatoh waro emero ehtohme: Orutua 20me jeimamyry nae exikety 60me exikety pona 50me parata ke epehmãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Nohpo tõ moro sã ahtao 30me parata ke epehmãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Aimo tõ 5me jeimamyry poe 20me ehtoh pona 20me parata ke epehmãko mana. Oryxi tõ 5me jeimamyry nae exikety 20me exikety pona 10me parata ke epehmãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Poetohti orutuame toiro nuno nae exikety 5me exikety pona 5me parata ke epehmãko mana. Nohpome poeto tõ oseruao rokẽ parata ke epehmãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Orutua kõ 60me jeimamyry motye nae ahtao 15me parata ke epehmãko, nohpo tomo 60me jeimamyry nae ahtao 10me parata ke epehmãko. ");
INSERT INTO apyNT_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Yrome tytineruke pyra ahno ahtao, moro epehpyry onepehmasaromepyra ynororo ahtao, ytõko mã ynororo oturuse oturukety maro. Mame zokonaka rokẽ mokyro epehmapõko mana nae ynororo ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Mame okyno tapiakase ahtao, totapasẽme ahno nekaroryme Ritonõpo a, Ritonõpo ekyme kurã exĩko mana, ");
INSERT INTO apyNT_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","mokyro onymyakãmara matose imepỹ ke, kurehxo exikety ke, kure hkopyra exikety ke roropa. Yrome tymyakãmase ahtao imepỹ ke, mokaro asakoro Ritonõpo ekyme exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Okyno nuriame exiketyme ahtao, Ritonõpo ise pyra ehtoh ahtao, mokyro arõko esẽ mana oturukety a, ");
INSERT INTO apyNT_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","mokyro epehpyry waro ehtohme. Mokyro eneryke tyya epehpyry poko zurũko oturukety mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Toky epekatyry se esẽ ahtao mokyro epehpyry ekarõko mana, imotye ⅕ zokonaka. ");
INSERT INTO apyNT_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Tytapyĩ ekaroryhtao ahno a tynekaroryme kurã Ritonõpo a, moro tapyi enẽko oturukety mana, kure ehtoh waro ehtohme, mame jũme epehpyry menekãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Mame moro tapyi epekatyry se ropa esẽ ahtao epekahnõko mana, imotye ⅕ zokonaka epehmãko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Tynonory zokonaka tokarose ahtao ahno a Ritonõpo kyryryme ehtohme tumy nekarohpyry, moro nono enẽko oturukety mana, epehpyry enetupuhnõko mana otãto kirume ipuhturu se moro nono arykatohme, 50me parata tinerume epehpyryme 100 kirume sewata ahtao. ");
INSERT INTO apyNT_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Tynonory ekaroryhtao Ritonõpo a Jeimamyry Emyhpokatoh ropa toehse ahtao, epehpyry tytororo inonory epehpyry exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Yrome moro riryhtao Jeimamyry Emyhpokatoh ropa mykapo ahtao moro nono epehpyry enetupuhnõko oturukety mana, jeimamyry tõ kuhnõko mana otãto ise ro imepỹ Jeimamyry Emyhpokatoh ropa pona, moro sã typyne hkopyra exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Mame moro nono epekatyry se ropa esẽ ahtao moro epehpyry epehmãko mana imotye ⅕ zokonaka. ");
INSERT INTO apyNT_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Yrome moro nono epekatyry se pyra esẽ ahtao, imepyny a moro nono topekahse ahtao, moromeĩpo onepekahpyra ropa esẽ exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Mame Jeimamyry Emyhpokatoh ropa toehse ahtao moro nono tokarosẽme exĩko Ritonõpo a, inonoryme ehtohme; oturuketõ nonoryme kurãme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Tynonory ekaroryhtao ahno a Ritonõpo a tynepekatyhpyry tineru ke, anapoipyra aexihpyry tumy wino, ");
INSERT INTO apyNT_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","moro epehpyry enetupuhnõko oturukety mana, jeimamyry tõ kuhnõko mana otãto ise ro Jeimamyry Emyhpokatoh ropa pona. Moro ẽmepyry ae ro moro nono epehpyry ekarõko esẽ mana, tytororo tynekaroryme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Mame Jeimamyry Emyhpokatoh ropa toehse ahtao moro nono apoĩko ropa esẽ mana, jũ nynomohpyry esẽ maro, ipoenõ maro. ");
INSERT INTO apyNT_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Nono epehpyry emero tukuhsẽme exĩko moro onymerohpyry eneryke oturukety a. ");
INSERT INTO apyNT_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Okyno apitorymãme aenurutyã Ritonõpo ekyme mã toto pui, kaneru, poti. Mokaro anapiakara exĩko matose onekarorykõme Ritonõpo a ekyme toto exiryke. ");
INSERT INTO apyNT_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Yrome nuriame exikety aenuruhpyry osemazuhmã epekahnõko ropa mase ise awahtao. Mokyro epehpyry epehmãko mase, imotye ⅕ zokonaka. Onepekahpyra ropa mokyro ahtao esemy a, imehnomo a tokamosẽme exĩko mana epehpyry poko rokene. ");
INSERT INTO apyNT_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ritonõpo kyryryme kurã tapiakase ahtao aomipona rokẽ ehtohme: ahno ahtao te, mõkomo ahtao, okyno ahtao, nono ahtao, tokarose ahtao Ritonõpo a, mokarohne onepekahsaromepyra ropa matose, onekamopyra roropa matose. Ritonõpo kyryryme kurãme mokarohne mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ahno tapiakase ahtao Ritonõpo maro ehtohme, mokyro onepekahsaromepyra ropa exĩko mana. Taorihmaposẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Anapoityãkõ 1/10me zokonaka Ritonõpo kyryryme mana: tiriiku tõkehko, wewe epery tõkehko, naeroro morohne ekarotoko eya. ");
INSERT INTO apyNT_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Moro 1/10me zokonaka exikety wino, zokonaka epekatyry se esẽ ahtao moro epehpyry epehmãko mana, imotye ⅕me zokonaka maro. ");
INSERT INTO apyNT_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Mame 10me okyno tõ toehse ahtao toiro Ritonõpo ekyme mana. Toky tõ rĩko mana atakenaka tuhke exiry waro toehtohme. Pui tomo, kaneru tomo, poti tomo roropa 10me ahtao, toiro Ritonõpo ekyme mana, ");
INSERT INTO apyNT_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","kure mokyro ahtao, popyra mokyro ahtao roropa. Mokyro onymyakãmara esẽ mana imepỹ ke. Yrome imyakãmaryhtao mokaro asakoro Ritonõpo ekyme exĩko mã toto. Mokaro onepekahpyra ropa esẽ mana. ");
INSERT INTO apyNT_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Morohne Ritonõpo nyripohpyry tõ nexiase, tokarose Moeze a, ypy Xinai po, ekarotohme Izyraeu tomo a.");
INSERT INTO apyNT_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Mame jeimamyry asakoro taropose ahtao, Izyraeu tõ esyryhmatopõpyry poe Ejitu poe, nuno asakoro aehtoh po, ẽmepyry apitorymano, Ritonõpo tõturuse Moeze a ona Xinai po, tapyi pitiko Tymaro oturutoh tao. Ynara tykase ynororo: ");
INSERT INTO apyNT_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","— Arão maro Izyraeu tõ ikuhtoko, oxiekyrymãkomo, itapyĩ taõkomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Orutua kõ esety imerotoko 20me jeimamyry nae exiketomo, emero tuãtase exiketomo, soutatume exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Tamuxime exiketõ imenekako, toiro tuisame exikety toiro oxiekyrymãkõ wino ãkorehmatohkõme. ");
INSERT INTO apyNT_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","16","Ynara mã toto orutua komo, tyekyrykõ tuisaryme exiketomo, ãkorehmatohkõme: Rupẽ tõ tuisary Erisua, Seteua mũkuru. Ximeão tõ tuisary Serumieu, Zurisatai mũkuru. Juta tõ tuisary Nasõ, Aminatape mũkuru. Isakaa tõ tuisary Netaneu, Zuaa mũkuru. Zepurõ tõ tuisary Eriape, Herõ mũkuru. Eparaĩ tõ tuisary Erisama, Amiute mũkuru. Manase tõ tuisary Kamarieu, Petasua mũkuru. Pẽjamĩ tõ tuisary Apitã, Kiteoni mũkuru. Tã tõ tuisary Aiezea, Amisatai mũkuru. Asea tõ tuisary Pajieu, Okarã mũkuru. Kate tõ tuisary Eriasape, Teueu mũkuru. Napatari tõ tuisary Aira, Enã mũkuru. Mokaro tymenekase tuisame toto ehtohme tyekyry tõ akorehmaneme toto ehtohme Izyraeu tõ rãnao. ");
INSERT INTO apyNT_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","Naeroro nuno asakoromã po, ẽmepyry apitorymã po Moeze a Arão maro mokaro 12mãkõ maro, ahno imoihmãkõ taoximõnohpose toto, toto kuhtohme, oxiekyrymãkõ oximõme, tapyi taõkõ oximõme, orutua kõ, 20me jeimamyry nae exiketõ esetykõ merotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Moro sã tukuhse toh nexiase ona Xinai po, Ritonõpo omi poe Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","43","Orutua kõ 20me jeimamyry nae exiketõ, soutatume exiketõ esetykõ tymerose oximaro tyekyry tõ maro. Osemazuhme Rupẽ tõ, Jako mũkuru apitorymã tymerose. Atapona toto ehtoh tymerose: Rupẽ tomo, 46.500. Ximeão tomo, 59.300. Kate tomo, 45.650. Juta tomo, 74.600. Isakaa tomo, 54.400. Zepurõ tomo, 57.400. Eparaĩ tomo, 40.500. Manase tomo, 32.200. Pẽjamĩ tomo, 35.400. Tã tomo, 62.700. Asea tomo, 41.500. Napatari tomo, 53.400. ");
INSERT INTO apyNT_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","46","Orutua kõ 20me jeimamyry nae exiketõ, soutatume exiketõ 603.550me nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Yrome rewita tõ esetykõ onymeropyra toh nexiase imehnõ oxiekyry tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ynara tykase Ritonõpo exiryke Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","— Orutua kõ tuãtase exiketõ, soutatume exiketõ kukuruhtao oya, rewita tõ onukuhpyra exiko. ");
INSERT INTO apyNT_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Yrome rewita tõ tyripoko Ytapyĩ Kurã kurãkananõme, imõkomory maro. Morohne aronanõme toto tyripoko, ipoko toto erohtohme Tapyi zomye toto osesaritohme. ");
INSERT INTO apyNT_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ytotoh toehse ahtao rewita tõ ymaro oturutoh kararahnõko mã toto. Toeporehkase awahtao xine osesaritoh pona Ytapyĩ amõko ropa rewita tõ mana imehnõ oehpyra ehtohme Ytapyĩ Kurã pũtokoxi aorikyrykõino. ");
INSERT INTO apyNT_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Imehnõ Izyraeu tõ tehme exĩko mã toto tosarykõ po, kamisã risẽ pãteira pũto tyekyry tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Yrome rewita tõ osesarĩko mã toto ymaro oturutoh zomye eraseme, imehnõ rewita tõ kara oehpyra ehtohme moro pũtokoxi Izyraeu tõ zehno jexiryino. ");
INSERT INTO apyNT_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Moro tyrise Izyraeu tomo a emero Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ynara tykase Ritonõpo Moeze a Arão maro: ");
INSERT INTO apyNT_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","— Osesariryhtao Izyraeu tomo a tykamisã, pãteira pũto exĩko mã toto, oxiekyrymãkõ maro, tyekyry tõ kamisã pãteira pũto. Osesarĩko mã toto Ymaro Oturutoh Kurã zomye, atameke pohto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","8","— Xixi tũtatoh wino mokaro Juta tõ maro exiketõ tosarykõ rĩko mã toto oximaro, tyekyry tõ maro, Juta tõ kamisã, pãteira pũto. Ynara mã toto tutuisarykõ maro soutatu tõ maro: Juta tõ soutatu tomo: 74.600 mãkomo, tuisa Nasõ maro, Aminatape mũkuru. Isakaa tõ soutatu tomo: 54.400 mãkomo, tuisa Netaneu maro, Zuaa mũkuru. Zepurõ tõ soutatu tomo: 57.400 mãkomo, tuisa Eriape maro, Herõ mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","— Juta tõ maro ytoketõ atapona 186.400me ytoytõko osemazuhme. ");
INSERT INTO apyNT_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","15","— Ikurenae ytoytoketõ Rupẽ tõ tykamisã, pãteira maro. Ynara mã toto tutuisarykõ maro, soutatu tõ maro: Rupẽ tõ soutatu tomo: 46.500 mãkomo, tuisa Erisua maro, Seteua mũkuru. Ximeão tõ soutatu tomo: 59.300 mãkomo, tuisa Serumieu maro, Zurisatai mũkuru. Kate tõ soutatu tomo: 45.650 mãkomo, tuisa Eriasape maro, Teueu mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","— Rupẽ tõ maro ytoketõ atapona 151.450me ytoytõko okomino, Juta tõ mykapo. ");
INSERT INTO apyNT_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","— Mame mokaro asakoro oximõmãkõ mykapo Ymaro Oturutoh arõko rewita tõ mana. Oximaro ytõko mã toto atakenaka toehtopõpyrykõ sã totypohse toto ahtao osesarise tykamisã, pãteira pũto. ");
INSERT INTO apyNT_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","23","— Xixi omõtoh wino ytoytoketõ Eparaĩ tõ tykamisã, pãteira maro ynara mã toto tutuisarykõ maro soutatu tõ maro: Eparaĩ tõ soutatu tomo: 40.500 mãkomo, tuisa Erisama maro, Amiute mũkuru. Manase tõ soutatu tomo: 32.200 mãkomo, tuisa Kamarieu maro, Petasua mũkuru. Pẽjamĩ tõ soutatu tomo: 35.400 mãkomo, tuisa Apitã maro, Kiteoni mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","— Eparaĩ tõ maro ytoketõ atapona 108.100me ytoytõko oximõmãkõ oseruaome samo rewita tõ mykapo. ");
INSERT INTO apyNT_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","30","— Inikahpoẽkõ ytoytoketõ Tã tõ tykamisã, pãteira maro ynara mã toto tutuisarykõ maro soutatu tõ maro: Tã tõ soutatu tomo: 62.700 mãkomo, tuisa Aiezea maro, Amisatai mũkuru. Asea tõ soutatu tomo: 41.500 mãkomo, tuisa Pajieu maro, Okarã mũkuru. Napatari tõ soutatu tomo: 53.400 mãkomo, tuisa Aira maro, Enã mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","— Tã tõ maro ytoketõ atapona 157.600me toh nexiase. Etyhpyryme ytoytõko toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Atapona Izyraeu tõ esetykõ tymerose soutatu tõme: 603.550me nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ritonõpo omi poe Moeze a rewita tõ onukuhpyra toh nexiase imehnõ Izyraeu tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Moro saaro Ritonõpo nyripohpyry Moeze a, moro tyrise Izyraeu tomo a emero. Tõsesarise toh nexiase tyekyry tõ maro tykamisã, pãteira pũto. Mame toytoytose toto oximõme tyekyry tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ynara Arão poenõ nexiase, Moeze poenõ roropa tõturuse Ritonõpo ahtao Moeze maro ypy Xinai po. ");
INSERT INTO apyNT_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Arão poenõ esetykõ ynara nexiase: Natape, apitorymano; ĩkapo Apiu te, Ereaza te, Itamaa, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Typopase toh nexiase, tymenekase roropa, oturuketyme toto ehtohme Ritonõpo ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Yrome Natape tõ Apiu maro toorihse ona Xinai po tynekarorykõ ekaroryhtao Ritonõpo a apoto tyorõ maro, Ritonõpo nyripohpyry apoto kurã maro pyra. Tumũkue pyra toh nexiase. Naeroro Ereaza tõ, Itamaa roropa toerohse oturuketõme isene ro Arão ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ynara tykase Ritonõpo Kuesẽkõ Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","— Rewita tõ enehpoko ekarotohme oturukety Arão a, ipoetoryme toto ehtohme akorehmatohme aerohtoh poko. ");
INSERT INTO apyNT_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Erohnõko mã toto ymaro Oturutoh poko te, oturuketõ akorehmãko mã toto te, ahno emero akorehmãko roropa mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Erohnõko mã toto Ytapyĩ mõkomory poko emero te, toerohtohkõ poko roropa Izyraeu tõ myakãme. ");
INSERT INTO apyNT_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Toiro rokẽ erohtoh ekarõko ase rewita tomo a: Arão tõ omipona toto ehtopo, ipoenõ maro, ipakomotyã maro. ");
INSERT INTO apyNT_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Naeroro Arão tõ rokẽ ripõko mase ymaro oturuketõme, ipoenõ maro ipakomotyã maro. Imepỹ orutua moro erohtoh poko tukuhse ahtao, mokyro tapiakasẽme exĩko aorihmapotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ynara tykase roropa Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","— Rewita tõ seromaroro ypoetoryme mã toto. Ejitu tõ osemazuhme aenurutyã totapase ahtao ya, Izyraeu tõ poenõ, osemazuhme aenurutyã tapiakase ya ypoetoryme toto ehtohme, eky tõ osemazuhme aenurutyã maro. Seromaroro Izyraeu tõ osemazuhme aenurutyã myakãme rewita tõ ypoetoryme mã toto. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ona Xinai po Moeze a tõturuse Ritonõpo, Izyraeu tõ Esemy, ynara tyripose eya: ");
INSERT INTO apyNT_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Rewita tõ oxiekyry tõ esetykõ imeroko, tapyi taõkõme, orutua kõ emero, toiro nuno motye exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Naeroro toto tukuhse Moeze a Ritonõpo nyripohpyry omipona. ");
INSERT INTO apyNT_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Rewi tumũkue oseruao kynexine: Jeresõ te, Koate te, Merari, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Jeresõ mũkuru tõ ynara kynexine: Ripani te, Ximei, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Koate mũkuru tõ asakoropane kynexine: Anarão te, Isara te, Eperõ te, Uzieu, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari tumũkue kynexine asakoro: Mari te, Muxi, enara. Mokaro rewita tõ ekyry tõ tamurume toh kynexine. ");
INSERT INTO apyNT_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","22","Jeresõ poe Ripani tõ toehse, Ximei tõ roropa. Mokaro ekyry tõ orutua kõ toiro nuno motye exiketõ ynara nexiase: 7.500me. ");
INSERT INTO apyNT_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Mokaro esaryme nexiase Ritonõpo maro Oturutoh moino akoxi, xixi omõtoh wino. ");
INSERT INTO apyNT_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eriasape, Raeu mũkuru mokaro tuisaryme nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Mokaro Jeresõ ekyry tõ toerohse Ritonõpo Tapyĩ poko, moro Tapyi amotoh zao exikety te, Tapyi amotoh jarao exikety roropa te, kamisa tõ poko omõtoh kyryry roropa, ");
INSERT INTO apyNT_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","kamisa tõ poko zara ehpikuroko exikety Tapyi Kurã zomye, apoto apõ maro te, kamisa tõ poko roropa omõtoh kyryry zara pona te, eary tõ poko roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Koate ekyry tõ ynara nexiase: Anarão tomo te, Isara tõ maro te, Eperõ tõ maro te, Uzieu tõ maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Mokaro tuhke exiry, orutua kõ rokene, toiro nuno motye exiketõ ynara toh nexiase: 8.600me. Ritonõpo maro Oturutoh poko toerohse toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Mokaro ekyry tõ, koatita tõ esary nexiase Tapyi Kurã poe ikurenae. ");
INSERT INTO apyNT_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Mokaro tuisary Erisapã, Uzieu mũkuru nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Mokaro toerohse Ritonõpo omihpyry ẽ poko, meza poko, wyi apony te, saerehkatoh apony te, apoto apõ tomo, oturuketõ kyryry erohtohme Osa Kurã tao te, kamisa poko Osa Kurã Kuhse omõtoh kyryry. Morohne emero poko toerohse toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Mokaro rewita tuisary tõ tuisaryme nexiase Ereaza, Arão mũkuru. Mokaro erohketõ Ritonõpo maro Oturutoh tao, Osa Kurã tao, tuisaryme nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari ekyry tõ ynara nexiase: Mari tomo te, Muxi tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Mokaro tuhke ehtoh, orutua kõ rokene, toiro nuno motye exiketõ ynara nexiase: 6.200me. ");
INSERT INTO apyNT_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merari ekyry tõ tuisary: Zurieu, Apiaiu mũkuru nexiase. Mokaro esary nexiase Tapyi Kurã poe inikahpozakoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Toerohse toh nexiase Tapyi Kurã kyryry wewe risẽ poko: tapua tomo te, itararany tomo te, xikihme exiketomo te, apõ tomo te, erohtoh kyryry emero poko. ");
INSERT INTO apyNT_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Toerohse roropa toto xikihme exiketõ poko zara po, Tapyi zomye, apõ tõ poko, inepuru tomo te, eary tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moeze tõ esary nexiase Tapyi Kurã ẽpataka, Arão tõ maro, imũkuru tõ maro, xixi tũtatoh wino. Toerohse toto Osa Kurã tao Izyraeu tõ akorehmary poko. Yrome imepỹ mokaro erohtoh poko tukuhse ahtao, mokyro tapiakasẽme exĩko totapasẽme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ritonõpo nyripohpyry omipona Moeze nexiase Arão maro. Rewita tõ esetykõ tymerose eya xine, orutua kõ emero toiro nuno motye exiketomo; 22.000me toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Mame ynara tykase Ritonõpo Moeze a: — Izyraeu tõ osemazuhme aenurutyã esetykõ imeroko, orutua komo, toiro nuno motye exiketomo, ypoetoryme toto exiryke emero. ");
INSERT INTO apyNT_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Yrome mokaro myakamãko ase rewita tõ ke, ypoetoryme toto ehtohme. Ywy ase Ritonõpo Oesẽkomo. Rewita tõ eky tõ tyriko roropa imehnõ Izyraeu tõ eky tõ osemazuhme aenurutyã myakãme. ");
INSERT INTO apyNT_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ritonõpo omi poe Izyraeu tõ mũkuru tõ osemazuhme aenurutyã tymerose Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Mokaro toiro nuno motye exiketõ atapona: 22.273me nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Moromeĩpo ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","— Rewita tõ tyriko mokaro Izyraeu tõ mũkuru tõ osemazuhme aenurutyã myakãme, rewita tõ eky tõ roropa tyriko imehnõ Izyraeu tõ eky tõ myakãme. Moxiã rewita tõ ypoetoryme mã toto. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Yrome Izyraeu tõ mũkuru tõ osemazuhme aenuruhpyryme exiketõ rewita tõ motye mã toto, 273me. Morara exiryke mokaro poko epehmãko mase. ");
INSERT INTO apyNT_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","48","5me parata epehmãko mase toiro ahno poko. Moro tineru ekaroko Arão tomo a imũkuru tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Naeroro moro tineru tapoise Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","15,5 kirume parata, ");
INSERT INTO apyNT_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","moro tokarose eya Arão tomo a imũkuru tõ maro, Ritonõpo nyripohpyry ae ro eya. ");
INSERT INTO apyNT_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","— Rewita tõ, koatita tõ ikuhko, oxiekyryme exiketomo, jũkõ tapyĩ taõkomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Orutua kõ esety imeroko 30me jeimamyry nae exiketomo, 50me jeimamyry ehtoh pona erohtohme Ytapyĩ Kurã poko. ");
INSERT INTO apyNT_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Koatita tõ erohtoh Ytapyĩ tao ynara mana: ykyryry tõ kurã kuhse pyno exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","— Atapyĩkõ tymyhpokase ahtao atakimatohme Arão tõ ytõko imũkuru tõ maro Ytapyĩ taka, kamisa tyhwyme exikety apoĩko mã toto jomihpyry ẽ ẽpataka exikety. Moro kamisa ke Jomihpyry ẽ zõtõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Mame moro pona ãty rĩko mã toto onokyro pihpyry risẽ kurano. Mame moro pona kamisa rĩko mã toto ezuezumano. Moromeĩpo mara tõ rĩko mã toto parihmã tõ aka, kaxo epurume. ");
INSERT INTO apyNT_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","— Kamisa ezuezumã rĩko roropa mã toto meza pona, wyi apõ pona tynekaroryme tokarosẽme aexityã Ritonõpo a. Moro pona paratu tõkehko tyrĩko mã toto: tijera tõ ixtaratu ẽ maro te, kopu tomo te, uwa eukuru jehnahpyry ẽ tomo, enara. Moro po pão jũme exikehpyra exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Moromeĩpo moro pona kamisa kamiraramã rĩko mã toto. Moro kamisa po ãty rĩko mã toto onokyro pihpyry kurã risemy. Moromeĩpo mara tõ rĩko mã toto epurume parihmã tõ meza kyryry aka. ");
INSERT INTO apyNT_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","— Mame kamisa ezuezumã apoĩko mã toto, saerehkatoh apõ zõtõko mã toto nãparina tõ maro, jahpi te, mauru panõ tõ sahkatohme, nãparina aryry te, ezehkatoh tonomo te, azeite ẽ tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Moromeĩpo morohne emero jõtõko mã toto onokyro pihpyry kurã risẽ ke mara tõ pona tyritohme arotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Apoto apõ uuru risẽ pona kamisa ezuezumã rĩko mã toto. Mame moro pona ãty rĩko mã toto onokyro pihpyry kurã risemy. Moromeĩpo mara tõ rĩko mã toto epurume parihmã tõ aka, apoto apõ kyryry aka. ");
INSERT INTO apyNT_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Mame Osa Kurã kyryry tõ emero apoĩko mã toto, jõtotohme kamisa ezuezumã ke. Mame morohne zõtõko onokyro pihpyry kurã risẽ ao tyritohme mara tõ pona arotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","— Mame oruno oũko mã toto apoto apõ poe, epona kamisa kamiraramã ritohme. ");
INSERT INTO apyNT_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Moro pona apoto apõ poko erohtoh kyryry kehko tyrĩko mã toto: apoto ẽ tomo te, kaafu tomo te, pa tomo, paxiha tomo, enara. Morohne pona ãty rĩko mã toto onokyro pihpyry kurã risemy. Mame mara tõ rĩko mã toto parihmã tõ aka, apoto apõ epurume. ");
INSERT INTO apyNT_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Atapyĩkõ tykararahse ahtao atakimatohme, Koate poenõ oehnõko mã toto Ritonõpo mõkomory kurã arotohme tõtyhkase Arão tõ ahtao rokẽ Tapyi Kurã jõtory poko imõkomory maro emero. Koate ekyry tõ morohne kurã anapopyra tyripoko toto aorikyrykõino. — Morohne tyripoko Koate tomo a Tapyi Kurã esyryhmatoh toehse ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","— Ereaza, oturukety Arão mũkuru, moro Tapyi Kurã poko erohketõ esẽme exĩko mana, azeite esẽme roropa nãparina eukuru te, ixtaratu esẽme, tiriiku tõkehko esẽme, ahno nekarotyã Ritonõpo a te, azeite esẽme roropa ipopatohme, emero Tapyi Kurã tao exiketomo tokarose ahtao Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ynara tykase Ritonõpo Moeze a Arão maro: ");
INSERT INTO apyNT_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","— Koate ekyry tõ anaorihmapopyra ehtoko ");
INSERT INTO apyNT_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ameke pyra aepyrykõke ykyryry tõ kurã pona. Mokaro orikyrykõino Arão tõ omõnõko mã toto imũkurukõ maro Tapyi Kurã taka zurutohme eya xine oty ritohme te, oty arotohme, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Yrome koatita tõ omõsaromepyra mã toto osenuhmatohme morohne kurã jõtoryhtao Arão tomo a aorikyrykõino. ");
INSERT INTO apyNT_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","— Jeresõ ekyry tõ ikuhko, oxiekyryme exiketomo te, tumykõ tapyĩ taõkomo roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Toto esetykõ imeroko orutua kõ 30me jeimamyry nae exiketõme ahtao 50me jeimamyry ehtoh pona erohtohme Tapyi Kurã tao Ritonõpo maro Oturutoh tao. ");
INSERT INTO apyNT_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Jeresõ ekyry tõ erohnõko mã toto Ritonõpo Tapyĩ tao, imõkomory arory poko, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Moro Tapyi arõko mã toto, Tapyi amotoh zao exikety te, jarao exikety roropa te, amotoh onokyro pihpyry kurã risemy te, tyhwyme exikety kamisa risẽ roropa omõtoh kyryry. ");
INSERT INTO apyNT_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Tyhwyme exiketõ kamisa risẽ roropa zara po te, tyhwyme exikety kamisa omõtoh kyryry zara pona Tapyi zomye, apoto apõ maro te, eary tõ roropa te, erohtoh kyryry emero roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Jeresõ ekyry tõ erohtoh emero, mõkomo arory poko te, toerokurukõ poko roropa emero rĩko mã toto Arão tõ omipona imũkuru tõ maro. Tyripõko mã toto morohne arory poko eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Morohne mã Jeresõ ekyry tõ erohtoh moro Tapyi Kurã tao. Moro erohtoh esẽme exĩko Itamaa, oturukety Arão mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Mame ynara tykase Ritonõpo Moeze a: — Merari ekyry tõ ikuhko, jũkõ tapyĩ taõkomo te, oxiekyryme exiketomo, ");
INSERT INTO apyNT_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","orutua kõ esety imeroko emero 30me jeimamyry nae exiketõ 50me jeimamyry ehtoh pona, toto erohtohme Ritonõpo Tapyĩ Kurã tao. ");
INSERT INTO apyNT_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ynara arõko mã toto toerohtoh poko Tapyi Kurã poko: wewe risẽ kehko, tapua tomo te, xikihme exiketõ inepurume exiketomo, Tapyi apõ tõ roropa; ");
INSERT INTO apyNT_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","xikihme exiketõ zara po, Tapyi zomye exiketõ te, apõ tomo te, xikihme exiketomo te, eary tomo te, mõkomo roropa emero erohtoh kyryry. Pape imeroko ekarotohme emero erohketomo a ikyryry tõ emero anaropotyã eya. ");
INSERT INTO apyNT_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Morohne mã Merari ekyry tõ erohtohme mana Tapyi Kurã poko. Moro erohtoh esẽme Itamaa exĩko mana, oturukety Arão mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Morarame Ritonõpo nyripohpyry omi poe rewita tõ tukuhse Moeze a Arão maro, Izyraeu tõ tuisaryme toexirykõke. Oseruao oxiekyry tõ tukuhse eya xine: Koate tomo te, Jeresõ tomo te, Merari tomo, enara. Jũkõ tapyĩ taõkõ tukuhse eya xine. Orutua kõ esety tymerose eya xine 30me jeimamyry nae exiketõ 50me jeimamyry ehtoh pona, erohtohme Tapyi Kurã poko. Ynara tuhke toto ehtoh nexiase: Koatita tomo: 2.750 mãkomo. Jeresonita tomo: 2.630 mãkomo. Merarita tomo: 3.200 mãkomo. Atapona: 8.580 mãkomo. ");
INSERT INTO apyNT_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Mokaro orutua kõ esety tymerose pape pokona Ritonõpo nyripohpyry ae ro Moeze a. Mame erohtoh tokarose Moeze a mokaro a emero imõkomory waro toto ehtohme, arotohme. Morohne tyrise Moeze a Ritonõpo nyripohpyry omipona. ");
INSERT INTO apyNT_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","— Oturuko Izyraeu tomo a tyrohsẽ hpe exiketõ ipihpyry poko aropotohme tosarykõ poe te, kunu hpe exiketomo, munu hpe exiketõ roropa te, nuriame exiketõ roropa ekepyry tapose exiryke eya. ");
INSERT INTO apyNT_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Mokaro aropoko oesarykõ poe moino akoxi oesarykõ nuriame onyripyra toto ehtohme, moroto jesaryme exiryke ypoetory tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Morohne tyrise Izyraeu tomo a, Ritonõpo omipona; mokaro taropose eya xine tosarykõ poe. ");
INSERT INTO apyNT_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Ynara tykase ropa Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","— Oturuko Izyraeu tomo a, ynara kaxiko eya xine: azahkuru toehse awahtao xine imepỹ poko, Ritonõpo zamaro pyra mase, iirypyryme mase. ");
INSERT INTO apyNT_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Naeroro oorypyry ekaroko Ritonõpo a. Mame moro epehmãko ropa mase imotye roropa 20%me mokyro a. ");
INSERT INTO apyNT_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Yrome mokyro toorihse ahtao itapyĩ taõkõ pyra ahtao roropa moro tineru ekaroko Ritonõpo a, oturukety kyryryme ehtohme. Moro epehpyry maro okyno ekarõko mana etapatohme tynekaroryme Ritonõpo a tyyrypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Morarame ahno nekarotyã Ritonõpo a oturuketõ kyryryme exĩko mokyro a tokarose ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Oturuketõ emero ahno nekarohpyry apoĩko mã toto tykyryryme tokarose ahtao eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","— Oturuko Izyraeu tomo a, ynara kaxiko eya xine: Typye orutua ahtao, mame ipyty imepỹ poko toehse ahtao, ");
INSERT INTO apyNT_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","imepỹ orutua maro iirypyryme toehse ynororo. Yrome inio zuaro pyra onenepyra imehnõ exiryke; ");
INSERT INTO apyNT_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","otarame typyty poko zumoxike toehse inio. Imepỹ maro pyra ipyty ahtao ro ");
INSERT INTO apyNT_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ipyty enehpoko inio a oturukety ẽpataka inekarory maro, toiro kirume sewata tapose aexihpyry maro. Azeite onyripopyra exiko oturukety a moro sewata pona ixtaratu onyripopyra exiko roropa, zae ehtoh enetupuhpotohme moro ekaroryke eya. ");
INSERT INTO apyNT_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","— Mokyro nohpo arõko oturukety apoto apõ ẽpataka, Ritonõpo ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Tuna kurã arykãko mana ẽ aka, orino risẽ aka, nono pixo rĩko roropa mana Tapyi Kurã poe moro tuna kuaka. ");
INSERT INTO apyNT_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Mame mokyro nohpo xikihme ro apoto apõ ẽpataka, zũsety myhpokãko mana, moro sewata ekarõko mana emary aka, moro tuna itunety nono maro apoĩko oturukety mana, popyra ehtoh enehpotopo. ");
INSERT INTO apyNT_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","— Mame ynara ãko oturukety nohpo a: “Ajohpe pyra imehnõ poko pyra awahtao towomasẽme exĩko mase, sero tuna oryhmara mana. ");
INSERT INTO apyNT_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Yrome imepỹ poko toehse awahtao iirypyryme mase ");
INSERT INTO apyNT_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ah Ritonõpo awãnohno oekyry tõ rãnao. Ah omone nakyhno. Ah awakuru tyaose nexino. ");
INSERT INTO apyNT_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Sero tuna tõse ahtao oya awakuru tyaosẽme exĩko, omone akyhnõko mana.” Mame nohpo ynara ãko: “Aõ, ah Ritonõpo morohne sã nyripono!” ");
INSERT INTO apyNT_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","— Mame okyno pihpyry pona moro popyra tyripotoh imerõko oturukety mana. Moro omi kurikãko mana moro tuna kuaka. ");
INSERT INTO apyNT_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Imeĩpo moro tuna itunety ẽnõko nohpo mana. Sam ãko nohpo mana zuakuru ao. ");
INSERT INTO apyNT_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Yrome moro tuna onẽpopyra ro ahtao moro sewata apoĩko ropa oturukety mana nohpo emary poe, anỹtohme Ritonõpo ẽpataka, apoto apõ pona tyritohme. ");
INSERT INTO apyNT_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Tomary ao sewata apoĩko mana jahkatohme apoto apõ po. Mame etyhpyryme moro tuna ẽpõko mana nohpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Imepỹ poko toehse ynororo ahtao sam kamexipõko moro tuna mana. Zuakuru tyaosẽme exĩko mana. Imone akyhnõko mana. “Popyra mokyro mana,” ãko mã jekyry tõ ipoko. ");
INSERT INTO apyNT_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Yrome imehnõ poko exipitopyra ynororo ahtao jetũ pyra exĩko mana. Poetoẽme exĩko ro mana. ");
INSERT INTO apyNT_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","— Moro Ritonõpo nyripohpyry zumoxike ehtoh poko, orutua pyty tynio kuroko imepỹ poko toehse ahtao te, ");
INSERT INTO apyNT_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","zumoxike toehse orutua ahtao. Mame typyty arõko mana Ritonõpo ẽpataka oturukety a morohne ritohme eya. ");
INSERT INTO apyNT_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mame mokyro inio ehxiropyra exĩko mana. Yrome ipyty imepỹ poko toehse ahtao tuãnohsẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","— Oturuko Izyraeu tomo a. Ynara kaxiko eya xine: orutua komo, nohpo tõ roropa, osekarory se awahtao xine Ritonõpo a nazireume ehtohme, tapiakase oehtohme, Ritonõpo omipona ehtoh poko rokẽ oehtohme yronymyryme, ");
INSERT INTO apyNT_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","uwa eukuru jehnahpyry onẽpyra ehtoko. Uwa eukuru onẽpyra, uwa epery onenahpyra, uwa asarananohpohpyry tõ roropa onenahpyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Nazireume awahtao xine uwa epery tõkehko onenahpyra ehtoko, ipuhturu te, ipihpyry roropa onenahpyra exĩko matose. ");
INSERT INTO apyNT_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","— Tapiakase awahtao nazireume oũsety onysahkara exiko, osetypokara exiko roropa. Tõtyhkase awahtao rokẽ nazireume oehtoh poko morohne rĩko ropa mase, oũsety sahkãko. ");
INSERT INTO apyNT_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","7","Oũsety onysahkara ehtoh enetupuhpotohme mana ãpiakatopõpyry poko Ritonõpo omiry omipona rokẽ oehtohme. Morara exiryke tomeseke exiko nuriame pyra oehtohme Ritonõpo a, aorikyhpyry ekepyry pũto pyra exiko: omy ekepyryme ahtao ro te, asa ekepyryme ahtao ro, ãkorõ ekepyryme ahtao, orui roropa te, ooryxiry ekepyryme ahtao roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Nazireume awahtao tapiakase mase Ritonõpo Oesẽ omiry omipona rokẽ oehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","— Imepỹ orikyryhtao mõtoino rokẽ opũto, nuriame oũsety toehse ahtao moro pokoino nazireume oexiryke, ynara tyrĩko mase: 7me ẽmepyry taropose ahtao oũsety sahkãko mase, osetypokãko roropa mase ekurikatohme ropa nuriame pyra oehtohme ropa. ");
INSERT INTO apyNT_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Yrokokoro, ẽmepyry 8mã po parutopuru asakoro enehnõko mase moro pyra ahtao utuku poenõ asakoro enehnõko mase oturukety a Ritonõpo Tapyĩ omõtoh taka. ");
INSERT INTO apyNT_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Toiro zahkãko oturukety mana tynekaroryme iirypyry epehpyryme, zakorõ zahkãko mana tytororo okurãkatoh epehpyryme, nuriame toehse oexiryke, ekepyry pũto awahtao. Moro ẽmepyry ae ro oũsety ekarõko ropa mase Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Osekarõko ropa mase Ritonõpo Oesemy a, nazireume, Ritonõpo omiry omipona rokẽ oehtohme. Moro ẽmepyry tõ apitoryme nazireume oehtopõpyry onukuhpyra exĩko matose oũsety nuriame toehse exiryke tokarose ahtao Ritonõpo a. Ikuhpitõko ropa mase. Mame oorypyry korokapotohme ropa, kaneru mũkuru enehnõko mase toiro jeimamyry exikety, onekaroryme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","— Ynyripohpyry sero Nazireume ehtoh poko, tõtyhkase ahtao ynara tyrĩko: ytõko mase Ymaro Oturutoh omõtoh taka ");
INSERT INTO apyNT_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","okyno tõ oseruao ahmitara exiketõ ekarõko mase Ritonõpo Oesẽkomo a: toiro kaneru mũkuru toiro jeimamyry exikety zahkatohme tytororo te, toiro kaneru toiro jeimamyry exikety zahkatohme oorypyry korokapotohme te, toiro kaneru onekaroryme osepeme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Pão tõ enehnõko roropa mase ruto pehme, tyrise pão porutatoh maro pyra: pão tõ topuxixime exiketõ tiriiku risẽ azeite maro te, pão tõ pitiko pipahme exiketomo azeite pitiko epona te, tiriiku tõkehko maro, uwa eukuru jehnahpyry maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","— Morohne emero arõko oturukety Ritonõpo ẽpataka. Moroto okyno zahkãko mana tynekaroryme iirypyry korokatohme, zakorõ roropa zahkatohme tytororo. ");
INSERT INTO apyNT_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Kaneru zahkãko roropa mana tynekaroryme Ritonõpo a osepeme ehtohme, tynekarory ekarõko roropa mana, pão tõ ruto pehme, tyrise pão porutatoh maro pyra. Tiriiku tõkehko ekarõko roropa mana tynekaroryme, uwa eukuru jehnahpyry maro. ");
INSERT INTO apyNT_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Ritonõpo Tapyĩ omõtoh tao mokyro nazireume exikety tũsety sahkãko mana. Tũsety apoĩko mana tyritohme apoto htaka tynekarory zahkatoh taka osepeme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","— Mame kaneru zokonaka tupuruse ahtao moro tõsẽ apoĩko, zokonaka, oturukety mana nazireume exikety emary aka tyritohme, pão asakoro maro ruto poe, toiro zumono, toiro zumõkara, enara. (Moro tyrise mokyro nazireume exikety zũsety tysahkase ahtao.) ");
INSERT INTO apyNT_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Moromeĩpo mokyro oturukety morohne ekarõko mana tynekaroryme kurã Ritonõpo a. Mokarohne kurã tokarosẽme exĩko oturukety zohme kaneru puropuru maro, ipety maro oturukety zohme, Ritonõpo nyripohpyry ae ro. Moromeĩpo mokyro nazireume exikety uwa eukuru jehnahpyry ẽnõko mana ise tahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","— Moro Ritonõpo nyripohpyryme mana nazireume toexiry se exikety poko Ritonõpo Tosẽ omiry omipona rokẽ toehtohme. Yrome tõmiry totapose ahtao nazireu a imepỹ kyryry ekarory poko morohne maro, ah mokyro tõmihpyry omipona nexino. ");
INSERT INTO apyNT_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","— Oturuko Arão tomo a, imũkuru tõ maro kure rokẽ Izyraeu tõ ripotohme ynara samo: ");
INSERT INTO apyNT_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Kure rokẽ oriporykõ se ase Ritonõpo a, oewomarykõ se ase roropa eya. ");
INSERT INTO apyNT_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Kure ehtoh oya ekaropõko ase Ritonõpo a, awãnohpopyra xine roropa ase eya. ");
INSERT INTO apyNT_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Nupunato oeneporykõ se ase Ritonõpo a, opyno xine aehtohme, osepeme oehtohkõme imehnõ maro, emero.” ");
INSERT INTO apyNT_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ynara tykase Ritonõpo: — Moro sã Arão tõ, imũkuru tõ maro kure rokẽ Izyraeu tõ ripõko mã toto ya. Mame kure rokẽ toto rĩko ase. ");
INSERT INTO apyNT_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Morarame tõtyhkase Moeze ahtao Ritonõpo Tapyĩ riry poko, Ritonõpo Tapyĩme Kurã typopase eya, Tapyi mõkomory maro, apoto apõ mõkomory maro. Morohne tapiakase eya Ritonõpo poko rokẽ ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Mame oxiekyrymãkõ tuisary tomo a, tamuximehxo toexirykõke, Moeze akorehmaneme roropa toh nexiase tyekyry tõ kuhtopõpyry poko, ");
INSERT INTO apyNT_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","tynekarorykõ tonehse Ritonõpo Tosẽkomo a: 6me kahosa tomo, pui tõ maro 12me. Asasakoro tuisa tõ a toiro kahosa tokarose, toiro tuisa a toiro pui tokarose roropa. Morohne emero tyrise eya xine Tapyi ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","— Kahosa tõ apoiko pui tõ maro erohtohme Tapyi poko. Morohne ekaroko rewita tomo a toto akorehmatohme toerohtohkõ poko. ");
INSERT INTO apyNT_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Naeroro rewita tomo a moro kahosa tõ tokarose Moeze a, pui tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Jeresõ pakomotyamo a asakoro kahosa tõ tokarose eya 4me pui tõ maro mokaro erohtoh pokoino. ");
INSERT INTO apyNT_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Merari pakomotyamo a, toto erohtoh pokoino, 4me kahosa tõ tokarose Moeze a 8me pui tõ maro. Mokaro erohtoh esẽme Itamaa nexiase, oturukety Arão mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Yrome Koate pakomotyamo a morohne onekaropyra Moeze nexiase, Ritonõpo mõkomory kurã toto motary tõ po rokẽ tupuimapose exiryke Ritonõpo omi poe. ");
INSERT INTO apyNT_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Tuisa tomo a tynekarorykõ tonehse oseahmatohme, apoto apõ ekarory poko Ritonõpo a ikyryryme kurano. Morohne enepyry se toehse toto ahtao apoto apõ pona, ");
INSERT INTO apyNT_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ynara tykase Ritonõpo Moeze a: — Kaxiko eya xine 12me toto exiryke 12me ẽmepyry ae tynekarory tõ enehnõko mã toto. Atakenaka toiro ẽmepyry ae toiro tuisa tynekarory enehnõko mana moro apoto apõ apiakaryme ykyryryme kurano. ");
INSERT INTO apyNT_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Ynara tynekarory tonehse eya xine atakenaka: Ẽmepyry apitorymã po Juta tõ tuisary Nasõ, Aminatape mũkuru. 2mã po Isakaa tõ tuisary Netaneu, Zuaa mũkuru. 3mã po Zepurõ tõ tuisary Eriape, Herõ mũkuru. 4mã po Rupẽ tõ tuisary Erisua, Seteua mũkuru. 5mã po Ximeão tõ tuisary Serumieu, Zurisatai mũkuru. 6mã po Kate tõ tuisary Eriasape, Teueu mũkuru. 7mã po Eparaĩ tõ tuisary Erisama, Amiute mũkuru. 8mã po Manase tõ tuisary Kamarieu, Petasua mũkuru. 9mã po Pẽjamĩ tõ tuisary Apitã, Kiteoni mũkuru. 10mã po Tã tõ tuisary Aiezea, Amisatai mũkuru. 11mã po Asea tõ tuisary Pajieu, Okarã mũkuru. 12mã po Napatari tõ tuisary Aira, Enã mũkuru. Mokaro nekarotyã oxisã kehko nexiase: toiro paratu parata risemy 1,5 kirume; toiro paxiha parata risemy 800 karamame; tuisa konõto kuhtoh ae ro. (Moro paratu, paxiha roropa tonehse eya xine pehme tiriiku ke azeite maro, tynekaroryme) te, paratu uuru risemy 115 karamame ixtaratu ke pehme te, toiro pui mũkuru te, toiro kaneru te, toiro kaneru mũkuru 1 anome exikety zahkatohme apoto apõ po te, toiro poti zahkatohme iirypyry korokapotohme te; osepeme, 2me pui tomo, 5me kaneru tomo, 5me poti tomo te, 5me kaneru mũkuru tomo toiro jeimamyry nae exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","85","Atapona Izyraeu tõ tuisary tõ nekarohpyry moro apoto apõ apiakary poko Ritonõpo nyripohpyry poko ynara nexiase: 12me paratu tomo parata risemy te, 12me paxiha tõ parata risemy te, atapona omoxinety 27,5 kirume nexiase; ");
INSERT INTO apyNT_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","12me paratu tõ uuru risemy, omoxinety 1 kiru 380 karamame (Moro paratu tõ pehme kehko nexiase ixtaratu ke); ");
INSERT INTO apyNT_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","tynekarorykõ zahkatohme tytororo: 12me kaneru tomo te, 12me kaneru mũkuru tõ 1 anome exiketomo te, tiriiku tõkehko maro moro tynekarorykõ maro ehtohme; iirypyry korokapotohme, 12me poti tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","tynekarorykõ osepeme ehtohme, 24me pui tomo te, 60me kaneru tomo, 60me poti tomo te, 60me kaneru mũkuru tõ toiro jeimamyry nae exiketomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mame tomõse Moeze ahtao Ritonõpo maro Oturutoh taka, oturuse Ritonõpo maro, Ritonõpo omiry totase eya. Oturũko nexiase, aomihpyry ẽ apuru poe, mokaro kerupĩ tõ rãnae. (Moro sã tõturuse Ritonõpo Moeze maro.) ");
INSERT INTO apyNT_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","— Arão zuruko moro 7me nãparina tõ riryhtao saerehkatoh apõ pona, tyripoko saerehkatohme moro apõ wapokoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Moro tyrise Arão a, aomiry omipona, nãparina tõ tyrise eya saerehkatohme moro zuapokoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Moro nãparina apõ tyrise nexiase emero uurume tapitapĩse Ritonõpo nenepohpyry sã Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","— Rewita tõ apiakako imehnõ Izyraeu tõ winoino toto kurãkatohme. ");
INSERT INTO apyNT_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Toto kurãkatohme tuna pitiko emako toto pona, zũsety emero isahkako toto zoko poko te, zupõkõ ikurikapoko roropa. Moro ke tukurãkasẽme exĩko mã toto, nuriame pyra. ");
INSERT INTO apyNT_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Mame pui mũkuru apoĩko mã toto, tiriiku kurã maro, azeite maro. Imepỹ pui mũkuru apoĩko mase onekaroryme oorypyrykõ korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Mame Izyraeu tõ emero oximõme enehpõko mase, rewita tõ ripõko mase Tapyi Kurã ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Mame Izyraeu tõ tomarykõ rĩko mã toto rewita tõ zupuhpyry pona. ");
INSERT INTO apyNT_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Mokaro rewita tõ apiakãko Arão mana toto ekarotohme ya, Izyraeu tõ nekaroryme kurano. Ahtao rewita tõ exĩko mã toto ypoetoryme. ");
INSERT INTO apyNT_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Tomarykõ rĩko rewita tõ mana mokaro pui asakoro zupuhpyry pona. Toiro tokarosẽme exĩko iirypyry korokapotohme, zakorony tyahkasẽme exĩko tytororo rewita tõ kurãkatohme. ");
INSERT INTO apyNT_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Rewita tõ apiakako onekarorykõme kurã ya. Mame Arão tomo imũkuru tõ maro toto tuisaryme exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Rewita tõ apiakako imehnõ Izyraeu tõ winoino, ypoetoryme toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Moromeĩpo rewita tõ tukurãkase ahtao te, tapiakase roropa toto ahtao ypoetoryme kurã omõnõko mã toto erohtohme ymaro oturutoh taka. ");
INSERT INTO apyNT_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Tapiakase toh nexiase imehnõ Izyraeu tõ winoino ypoetoryme toto ehtohme Izyraeu tõ mũkuru tõ osemazuhme aenurutyã myakãme. Ypoetoryme mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ejitu tõ mũkuru tõ osemazuhme aenurutyã totapase ahtao ya, Izyraeu tõ mũkuru tõ osemazuhme aenurutyã emero tapyi tao tapiakase ya ypoetoryme toto ehtohme, eky tõ osemazuhme aenurutyã maro. ");
INSERT INTO apyNT_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Rewita tõ tapoise ya Izyraeu tõ mũkuru tõ osemazuhme aenurutyã myakãme. ");
INSERT INTO apyNT_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Seromaroro rewita tõ ekarõko ase Arão tomo a imũkuru tõ maro Izyraeu tõ nekaroryme aerohtohme Ytapyĩ tao Izyraeu tõ akorehmatohme iirypyrykõ korokapotohme te, toto ewomatohme roropa popyra ehtoh oehpyra ehtohme toto wãnohtohme Osa Kurã pũtokoxi aepyrykohtao. ");
INSERT INTO apyNT_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Naeroro Ritonõpo nyripohpyry Moeze a rewita tõ poko, emero tyrise Moeze a te, Arão a te, Izyraeu tõ maro rewita tomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Toekurãkase toh nexiase rewita tomo, tupõkõ tukurikase roropa eya xine. Mame toto tapiakase Arão a tynekaroryme kurã Ritonõpo a, okyno tõ tyahkase Arão a iirypyrykõ korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ritonõpo nyripohpyry Moeze a rewita tõ poko, emero tyrise eya xine Ritonõpo omihpyry omipona. Moro sã tymenekase rewita tomo aerohtohme Tapyi Kurã tao, Arão tõ poetoryme imũkuru tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","— Ynara tyripõko ase rewita tomo a: 25me jeimamyry nae toto ahtao erohpitõko mã toto Ytapyĩ Kurã tao, ");
INSERT INTO apyNT_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","50me jeimamyry nae ahtao toerohtoh rumekãko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Moromeĩpo 50me jeimamyry motye toto ahtao tope tõ akorehmãko ro mã toto toerohtoh poko Tapyi Kurã tao. Yrome tuisame pyra exĩko mã toto moro erohtoh poko. Moro sã rewita tõ erohtoh apiakãko mase toto erohtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Morarame jeimamyry 2mã po Izyraeu tõ ytotopõpyry poe Ejitu nonory poe, nuno apitorymã po Ritonõpo tõturuse Moeze maro ona Xinai po. Ynara tykase: ");
INSERT INTO apyNT_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","3","— Ẽmepyry 14mã po sero nuno po, kohmãsasaka ahtao, otuhtoh konõto “Epozakuroko” tyripoko Izyraeu tomo a ynyripohpyry ae ro moro poko. ");
INSERT INTO apyNT_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Naeroro Epozakuroko Paxikoa otuhtoh tyripose Moeze a Izyraeu tomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ẽmepyry 14mã po, nuno apitorymã po oseahmatoh tyrise Izyraeu tomo a kohmãsasaka ahtao, ona Xinai po. Emero tyrise Izyraeu tomo a Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Yrome orutua kõ nexiase nuriame, aorikyhpyry ekepyry tapose eya xine exiryke. Naeroro Paxikoa poko ehsaromepyra toh nexiase moro ae. Toytose toto oturuse Moeze a, Arão maro. ");
INSERT INTO apyNT_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Ynara tykase toto: — Nuriame ynanase aorikyhpyry ekepyry tapose exiryke yna a. Ajohpe pyra, ynanekarory onekarosaromepyra ynanae Ritonõpo a imehnõ Izyraeu tõ maro moro ẽmepyry po, onymenekahpyry po? ");
INSERT INTO apyNT_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mame tozuhse toto Moeze a. Ynara tykase: — Apoaporo, oturũko ase Ritonõpo a zuaro jehtohme, oty ripõko ynororo oya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","— Ynara kaxiko Izyraeu tomo a: nuriame toehse awahtao xine opoenomo te, apakomotyã roropa nuriame toehse ahtao ahno ekepyry tapose exiryke eya te, moe ynororo ahtao roropa te, mya ayaytoryhtao roropa, moro toehse ahtao otuhnõko ro mã toto Paxikoa poko, Ritonõpo eahmaryme. ");
INSERT INTO apyNT_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Toiro nuno eraximako. Moromeĩpo Paxikoa oseahmãko matose, ẽmepyry 14mã po, nuno 2mã po, kohmãsasaka ahtao. Mame moro poko awahtao xine okyno õnõko matose wyi maro, iporutatoh maro pyra exikety ke, otyro ary itunety maro. ");
INSERT INTO apyNT_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Tõsẽ akoĩpyry onukurãkara ehtoko yrokokoro pona, okyno zehpyry onytahkara ehtoko roropa. Moro Paxikoa tyritoko ynyripohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Yrome ynara toehse ahtao, ahno nuriame pyra ahtao, mya ytoytopyra ynororo ahtao, Paxikoa otuhtoh onyripyra ahtao, mokyro aropõko matose owinoino xine, tynekarory onenehpyra exiryke ya zae ekarotoh po toehse ahtao. Tuãnohsẽme exĩko mokyro mana iirypyry emetakame. ");
INSERT INTO apyNT_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","— Imepỹ nonory poe exikety, tosake toehse exikety amaro xine, tõtukuru se ynororo ahtao Paxikoa poko amaro xine, ynyripohpyry omipona exĩko mana moro poko. Moro saaro matose imepỹ nonory poe aehtyã samo, ynyripohpyry omipona ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Mame Ritonõpo Tapyĩ tyrikehse ahtao akurũ toehse epozakoxi. Tykohmãse ahtao moro akurũ apoto sã nexiase ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Morarame kokoro rokẽ moro sã nexiase tõmehse ahtao akurume nexiase Tapyi epoe, koko apoto sã nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Tõnuhse moro akurũ ahtao Tapyi poe Izyraeu tõ toytopitose. Mame totypohse akurũ ahtao moroto tõsesarise toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Toytopitose toto, totypohse roropa toto Ritonõpo nyripohpyry omipona. Mame tehme toh nexiase moroto, moro akurũ tehme ahtao Tapyi epoe. ");
INSERT INTO apyNT_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Okynahxo Tapyi epoe akurũ ahtao, Ritonõpo omipona Izyraeu tõ nexiase. Ytopyra toh nexiase moro poe. ");
INSERT INTO apyNT_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Toitoine moro akurũ okynã nexiase Tapyi epoe tuhke pyra ẽmepyry pona. Morarame tehme toh nexiase te, toytose ropa toh nexiase Ritonõpo omiry omipona. ");
INSERT INTO apyNT_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Toitoine moro akurũ okynã pyra nexiase Tapyi epoe, kokonie pukuro poe ẽmepyry pona yrokokoro. Tõnuhse ahtao ẽmepyryme ahtao toytopitose toto. Tahxime tõnuhse akurũ ahtao, saereme ahtao te, tykohmãse ahtao roropa toytopitose toto. ");
INSERT INTO apyNT_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Yrome totypohse akurũ ahtao Tapyi epoe asakoro ẽmepyry te, nuno tytororo te, jeimamyry porehme, totypohse pixo moro akurũ ahtao, Izyraeu tõ roropa tehme toh nexiase. Ytoytopyra toh nexiase. Yrome tõnuhse yroro ahtao ytõko toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ritonõpo nyripohpyry ae ro totypohse toh nexiase, toytose roropa toh nexiase. Ritonõpo nyripohpyry Moeze a moro omipona Izyraeu tõ nexiase toto. ");
INSERT INTO apyNT_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Ritonõpo Izyraeu tõ Esẽ ynara tykase Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","— Rue asakoro tyriko parata apimyhpyry risemy. Moro rue tõ ke ahno kohmãko mase oximõtohme te, toto kohmãko ropa mase esyryhmatohme. ");
INSERT INTO apyNT_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Asakoro rue totose ahtao ahno emero oximõnõko mã toto amaro Tapyi Kurã omõtoh taka. ");
INSERT INTO apyNT_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Yrome toiro rokẽ rue totose ahtao, oxiekyrymãkõ tuisary tõ rokẽ oximõnõko mã toto amaro. ");
INSERT INTO apyNT_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Rue tõ totose ahtao mytyhse samo, jamihme sã roropa oxiekyrymãkõ, tosake exiketõ xixi tũtatoh wino ytopitõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Mame rue tõ totose ropa ahtao mytyhse samo jamihme sã roropa oxiekyrymãkõ, tosake ikurenae exiketõ ytopitõko mã toto. Enetupuhtohme toytorykõ poko moro rue etory mytyhse sã exĩko, jamihme sã roropa; ");
INSERT INTO apyNT_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","yrome ahno emero kohmatohme oximõme rue tõ etõko okynahme samo. ");
INSERT INTO apyNT_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Oturuketõ moro rue etoneme exĩko mã toto, Arão poenomo, ipakomotyã roropa. — Ynara tyripõko ase oya xine, Izyraeu tomo, jũme omipona oehtohkõme. ");
INSERT INTO apyNT_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Amarokõ õsetaparykohtao ononorykõ po, Õsewomarykõ poko oepetõkara winoino sero rue tõ etotoko etonatoh poko. Ywy, Ritonõpo Oesẽkomo ãkorehmatorỹko ase, oepetõkara poremãkatohme. ");
INSERT INTO apyNT_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ãtãkyemarykohtao roropa, Nuno Kasenato poko õseahmarykohtao, tyorõ otuhtoh roropa riryhtao oya xine, rue tõ etotoko onekarorykõ zahkaryhtao tytororo apoto apõ po te, osepeme ehtoh zahkaryhtao roropa oya xine. Mame ãkorehmatorỹko ase, ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Mame jeimamyry 2me aehtoh po Ejitu rumekatopõpyry poe, ẽmepyry 2me aehtoh po, nuno 2me aehtoh po, akurũ tõnuhse Tapyi Kurã poe. ");
INSERT INTO apyNT_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Moro ae Izyraeu tõ toytopitose ona Xinai poe. Mame moro akurũ totypohse ona Parã po. ");
INSERT INTO apyNT_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Moro saaro, toytopitose toto apitoryme samo, Ritonõpo nyripohpyry ae ro Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Osemazuhme toytose Juta kamisã pãteira maro ytoytoketomo oxikone, oxiekyrymãkomo. Ituisarykõ nexiase Nasõ, Aminatape mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netaneu, Zuaa mũkuru, Isakaa ekyry tõ tuisaryme nexiase; ");
INSERT INTO apyNT_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eriape, Herõ mũkuru, Zepurõ ekyry tõ tuisaryme nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Mame Tapyi Kurã tymyhpokase. Rewita tomo, Jeresõ ekyry tomo, Merari ekyry tõ maro toytopitose toto Tapyi arory poko. ");
INSERT INTO apyNT_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Mokaro mykapo Rupẽ tõ kamisã pãteira maro ytoytoketõ toytose, oxiekyry tõ oxikone. Ituisarykõ Erisua nexiase, Seteua mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Serumieu, Zurisatai mũkuru, Ximeão ekyry tõ tuisaryme nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eriasape, Teueu mũkuru, Kate ekyry tõ tuisaryme nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Moromeĩpo rewita tõ, Koate ekyry tõ toytose, Tapyi Kurã mõkomory kurã arõko toh nexiase. Mame toeporehkase toto ahtao osa kasenato pona, moro Tapyi Kurã tamose nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Mame Eparaĩ tõ kamisã pãteira maro exiketõ toytose oxiekyrymãkõ oximõme tutuisarykõ maro, Erisama, Amiute mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Kamarieu, Petasua mũkuru, Manase ekyry tõ tuisaryme nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Apitã, Kiteoni mũkuru, Pẽjamĩ ekyry tõ tuisaryme nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Moromeĩpo etyhpyryme Tã tõ kamisã pãteira maro exiketõ toytose oxiekyrymãkõ oxikone tutuisarykõ maro Aiezea, Amisatai mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pajieu, Okarã mũkuru, Asea ekyry tõ tuisaryme nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Aira, Enã mũkuru, Napatari ekyry tõ tuisaryme nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Moro sã Izyraeu tõ atakenaka toytopitose toto, oxiekyrymãkõ oxikone. ");
INSERT INTO apyNT_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mame ynara tykase Moeze tokono a, Hopape a, Jetoro mũkuru, Mitiã pono: — Ytõko ynanase Ritonõpo nekarory pona. Inetapohpyry ae kure rokẽ Izyraeu tõ rĩko mana tymõkomoke itamurume toto ehtohme. Naeroro yna maro eropa, Ritonõpo a yna riryhtao kure, kure orĩko roropa ynanase. ");
INSERT INTO apyNT_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ynara tykase Hopape: — Arypyra. Ytõko ropa ase jesaka ropa, wekyry tomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","— Ajohpãme sã morara kara exiko, tykase Moeze. — Sero ona emero waro mase. Osa tõ kurã waro roropa mase yna osesaritohme; yna aroneme exiko. ");
INSERT INTO apyNT_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Yna maro oytoryhtao Ritonõpo nekarory yna a apiakãko ynanase zokonaka okyryryme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Morarame toytose Izyraeu tõ ahtao Xinai poe, Ritonõpo ypy poe, toytose toto oseruao ẽmepyry ae. Ritonõpo omihpyry ẽ aronanõ toytose osemazuhme osa menekatohme osesaritohme. ");
INSERT INTO apyNT_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Toytose toto ahtao Ritonõpo akurũ mokaro epoe nexiase saereme ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Tahxime Ritonõpo omihpyry ẽ taropitose ahtao ynara tykase Moeze: “Ritonõpo, yna Esemy owõko! Sapararahme oepetõkara aropoko! Ah ozehno exiketõ nepã toto oẽpatae oytoryhtao.” ");
INSERT INTO apyNT_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Mame totypohse Ritonõpo omihpyry ẽ ahtao, ynara tykase Moeze: “Osehko ropa, Ritonõpo yna Esemy, tuhke miumãkõ Izyraeu tomo a.” ");
INSERT INTO apyNT_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Mame toetuarimarykõ poko tykerekeremase Ritonõpo eya xine. Aomirykõ etaryke tyya, tohne toehse Ritonõpo nexiase. Apoto tomapose eya toto pona. Moro apoto a tyahkase mokaro rãnao, toitoine tyahkase toh nexiase tosarykõ etyhpyry po. ");
INSERT INTO apyNT_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Kui tykase toto, tykohtase Moeze a takorehmapotohkõme; tõturuse Moeze ahtao Ritonõpo a, apoto tozehse. ");
INSERT INTO apyNT_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Moroto tosehpase eya xine Taperame, moroto apoto tonehpose Ritonõpo a exiryke toto rãnaka. ");
INSERT INTO apyNT_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Izyraeu tõ maro imehnõ nonory põkõ nexiase, ytõko imaro xine. Tõsẽ poko typenetase toh nexiase. Izyraeu tõ maro tykerekeremapitose, ynara tykase toto tyxitarykõme: — Tõsẽ sehxo ynanano! ");
INSERT INTO apyNT_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ejitu po kana nae sexiatose tuhke, tuesapare sexiatose kana ke, topehke pyra roropa nexiase. Omuhpe sytatose pepino poko te, merão roropa te, otyro ary te, sepora tomo te, ariu roropa! ");
INSERT INTO apyNT_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Yrome seromaroro tapotũkehse sytatose. Tonahsẽ pyra toehse sytatose, manã rokẽ nae kokoro rokene! ");
INSERT INTO apyNT_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(Manã ipuhturu pitiko sã nexiase karimutume, sewemehme sã pitiko. ");
INSERT INTO apyNT_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Toepukase koko ahtao konopo samo. Yrokokoro pakeimo ahno toytose moro wyi panõ apoise tytapyĩkõ zomye. Moro manã tapose eya xine ako aka te, moĩjo aka roropa. Mame tahnose eya xine oripo ao te, wyi panõ pipahme exikety tyrise roropa eya xine, kure nexiase pão samo tupuruse ahtao azeite maro.) ");
INSERT INTO apyNT_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mame mokaro xitary totase Moeze a. Emero tapyĩ taõkõ tyxitase tytapyĩ omõtoh tao. Tohne toehse Ritonõpo, Moeze roropa torekohmase. ");
INSERT INTO apyNT_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ynara tykase ynororo Ritonõpo a: — Oty katohme popyra jyrĩko mah sero samo? Oty katoh torekohmase mahno ypoko? Oty katohme sero erohtoh tupimã mekaroase ya mokaro emero arory poko? ");
INSERT INTO apyNT_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Mokaro onyripyra exiase, toto enurumaponeme pyra roropa exiase. Oty katoh suhsu ekaroneme jyripõko mah, syhryme mokaro arotohme poeto pisarara samo mya moro nono pona, onekarory eya xine õmihpyry ae ro itamuru tomo a? ");
INSERT INTO apyNT_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Otokoino tõsẽ apoĩko hano ekarotohme mokaro zohme? Ya oehnõko mã toto tyxitarykõme, tõsẽ ekaropõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ywy toiroro mokaro emero onypynanohsaromepyra ase, omoxihxo mã toto ya! ");
INSERT INTO apyNT_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Sero sã jyriryhtao oya ypyno exiko kuetapako jũme rokene! Azamaro jahtao ypyno exiko sam kakehtohme ya! ");
INSERT INTO apyNT_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ynara tykase Ritonõpo Moeze a: — 70me orutua kõ imenekako, zae exiketomo, tuisame exiketomo ahno neneryme, enehtohme ya, Tapyi Kurã taka. Amaro xikihme toto tyripoko. ");
INSERT INTO apyNT_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mame yhtõko ase oturuse amaro moroto. Juzenu, ynekarohpyry oya apoĩko ase zokonaka ekarotohme eya xine. Mame ãkorehmãko mã toto oerohtoh poko ahno pyno oexiry poko, toiroro pyra oehtohme mokaro arory poko oya. ");
INSERT INTO apyNT_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Seromaroro ynara kaxiko ahno a: “Atapiakatoko oorypyrykõ winoino nuriame pyra oehtohkõme kokoro. Tõsẽ õnõko matose. Oxitarykõ totase Ritonõpo a ynara kary maro: ‘Tõsẽ poko penetãko ynanase, Ejitu po kure nexiase.’ Naeroro tõsẽ ekarõko oya xine mana. Otuhnõko matose. ");
INSERT INTO apyNT_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Tõsẽ õnõko matose toiro ẽmepyry ae rokẽ pyra, 2me rokẽ pyra, 5me pyra, 10me pyra te, 20me pyra. ");
INSERT INTO apyNT_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Yrome toiro nuno pune tõsẽ õnõko matose, tũtatoh pona oeunarykõ ae, ise pyra oehtohkõ pona. Moro sã exĩko Ritonõpo se pyra toehse oexirykõke, arãnao xine jahtao. Tykerekeremase roropa oya xine: ‘Oty katohme Ejitu turumekase kyya xine? Kurehxo exiry moroto ro kuahtao xine,’ ãko.” ");
INSERT INTO apyNT_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ynara tykase Moeze: — 600 miume orutua kõ arõko ase. Mokaro zoh ekarõko mah, tõsẽ õtohme eya xine nuno pune? ");
INSERT INTO apyNT_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Kaneru tõ tuhke, pui tõ tuhkãkõ maro totapasẽme exĩko nae toto pune ehtohme? Kana tõ emero tuna konõto kuao tanỹsẽme exĩko nae mokaro zohme? ");
INSERT INTO apyNT_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Moeze tozuhse Ritonõpo a. Ynara tykase: — Yjamitunuru ipune pyra toehse nahe? Seromaroro ynyriry enẽko mase jomihpyry ae ro, “Naary!” kara oehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mame Moeze tutũtase Ritonõpo omihpyry ekarotohme ahno a. 70me orutua kõ, tuisamehxo exiketõ tonehpose eya Tapyi Kurã zomye. ");
INSERT INTO apyNT_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Mame Ritonõpo tyhtose akurũ ao oturuse eya. Tuzenu tapoise eya tynekarohpyry Moeze a zokonaka ekarotohme mokaro 70mãkomo a. Tuzenu tokarose ahtao Ritonõpo a eya xine, tõturupitose toto opore urutõ kõ samo, Ritonõpo omiry ekaroryme axĩtao rokene. ");
INSERT INTO apyNT_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Yrome asakoro orutua kõ mokaro maro pyra toh nexiase. Tytapyĩkõ pũto nexiase toto. Toiro esety Eutate nexiase, zakorõ Metate nexiase. Ritonõpo Zuzenu toehse ahtao toto pona opore tõturupitose toto urutõ kõ samo. ");
INSERT INTO apyNT_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Moro eneryke tururume toytose nuasemano ekarotohme Eutate tõ poko Metate maro, toto otururu poko urutõ kõ samo tytapyikõ pũto. ");
INSERT INTO apyNT_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Mame Jozue, Num mũkuru, moino ro Moeze akorehmaneme exikety, ynara tykase: — Moeze, jesemy, moro sã kamexipopyra exiko mokaro a! ");
INSERT INTO apyNT_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ynara tykase Moeze: — Oty katohme torẽtyke mahno? Tuisame jehtoh poko jewomary se hma? Kurehxo ya exiry Ritonõpo poetory tõ emero urutõme toto ahtao, Ritonõpo Zuzenu tokarose roropa ahtao eya xine! ");
INSERT INTO apyNT_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Mame toytose ropa Moeze tomo mokaro 70mãkõ maro, Izyraeu tõ tuisary tõ maro tosaka xine ropa. ");
INSERT INTO apyNT_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Mame tyryrykane tonehpose Ritonõpo a tuna konõto wino. Moro tyryrykane a aramixi tõ tonehse tuhke mokaro tapyi tõ zomye. Mokaro ke nono pehme toehse. Tõnuhse toto ahtao toiro meturume toytose toto nono epozakuroko. ");
INSERT INTO apyNT_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Naeroro tykohmãse toto aramixi apoiry poko, tõmehse roropa toto, tykohmãse ropa toto mokaro apoiry poko eya xine; tuhke tapoise eya xine, toiro ahno ahtao miu kirume sã tapoise eya. Mame xixi aka mokaro pũ tyrise eya xine anorytohme. ");
INSERT INTO apyNT_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Itamurume tõsẽ nae ro ahtao mokaro zehno toehse Ritonõpo. Tyrohsẽ ke tuãnohse toto eya, tuhkãkõ toorihse. ");
INSERT INTO apyNT_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Morara exiryke moroto tosehpase eya xine Kiporote-Ataawa, ynara katohme “Penetaketõ Zonẽtopõpyry”; moroto tõsẽ poko ipenetatyã ekepyry tonẽse exiryke. ");
INSERT INTO apyNT_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Moromeĩpo Izyraeu tõ toytose Hazerote pona osesarise. ");
INSERT INTO apyNT_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mame Moeze tykerekeremase Miriã tomo a Arão maro, typytase Moeze exiryke nohpo, Etiopia põ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ynara tykase toto: — Ritonõpo tõturuse Moeze ae rokẽ pyra. Tõturuse roropa ynororo kymoro ae. Mame mokaro otururu totase Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Moeze epyrypara ipunaka, imehnõ motye imehxo toexiry poko epyrypara nexiase.) ");
INSERT INTO apyNT_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ynara tykase Ritonõpo Moeze tomo a, Arão maro, Miriã maro: — Osehtoko, amarokõ oseruao, ymaro oturutoh taka! Naeroro toytose toto. ");
INSERT INTO apyNT_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Tyhtose Ritonõpo akurũ ao Tapyi omõtoh taka. Mame Arão tykohmase eya Miriã maro. Toeporehkase toto ahtao, ");
INSERT INTO apyNT_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ynara tykase Ritonõpo: — Seromaroro, etatoko ke jotururu oya xine. Urutõ tõ nae ahtao arãnao xine osenepõko ase eya xine enepotoh ae te, oturũko ase roropa toto maro aosenetykõ ae. ");
INSERT INTO apyNT_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Yrome ypoetory Moeze maro moro sã pyra mana, tymenekase ya ynororo ypoetory tõ emero esẽme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Naeroro imaro oturũko ase osẽpataka, topohme, tupimãkõ ke pyra, enetupuhpotoh ke pyra; tonese roropa ywy eya! Oty katohme zuno pyra hmatokene ypoetory Moeze kerekeremary poko oya xine? ");
INSERT INTO apyNT_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Mame toytose Ritonõpo tohne mokaro poko. ");
INSERT INTO apyNT_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Moro akurũ toytose ahtao Tapyi epoe axĩ Miriã pihpyry tyrohsẽ hpe toehse, karimutume akurũ samo. Arão a tonese Miriã, tyrohsemyimo hpe rahkene. ");
INSERT INTO apyNT_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Ynara tykase Arão Moeze a: — Ajohpame sã tuisa, yna onuãnohpopyra exiko azahkuru yna ehtoh poko, ajoajohpe toehse yna exiryke. ");
INSERT INTO apyNT_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ajohpame sã poeto aepukahpyry sã Miriã onyripopyra exiko, zokonaka tonahkase aexihpyry sã aenururuhtao. ");
INSERT INTO apyNT_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Naeroro ynara tõturuse Moeze Ritonõpo a: — Ritonõpo ajohpãme sã ikurãkako ropa! ");
INSERT INTO apyNT_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ynara tykase Ritonõpo Moeze a: — Jumy ituh tykase ahtao ẽmyty pona, toehxirose ynororo exiry 7me ẽmepyry. Naeroro ah ynororo taroposẽme nexino owinoino xine 7me ẽmepyry. Imeĩpo enehko ropa. ");
INSERT INTO apyNT_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Mame 7me ẽmepyry taropose Miriã a ameke tapyi tõ wino. Tehme rokẽ toh nexiase mokyro enehtoh ropa pona itapyĩ taka ropa. ");
INSERT INTO apyNT_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Moromeĩpo toytose toto Hazerote poe ona Parã pona osesarise. ");
INSERT INTO apyNT_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ritonõpo Izyraeu tõ Esẽ ynara tykase Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","— Orutua kõ aropoko Kanaã nonory enetohme, moro nono ekarõko ase Izyraeu tomo a. Toiro orutua imenekako tuisame exikety Jako poenomotyã punero. ");
INSERT INTO apyNT_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ona Parã poe mokaro tonyohse Moeze a nono enetohme Ritonõpo Tosẽkõ nyripohpyry ae ro. Tuisame toh nexiase Izyraeu tõ oxiekyrymãkõ tuisaryme ");
INSERT INTO apyNT_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","15","Ynara toh nexiase: Rupẽ tõ tuisary Samua, Zakua mũkuru. Ximeão tõ tuisary Sapate, Hori mũkuru. Juta tõ tuisary Karepe, Jepone mũkuru. Isakaa tõ tuisary Ikau, Joze mũkuru. Eparaĩ tõ tuisary Ozeja, Num mũkuru. Pẽjamĩ tõ tuisary Pauti, Rapu mũkuru. Zepurõ tõ tuisary Katieu, Soti mũkuru. Manase tõ tuisary Kati, Suxi mũkuru. Tã tõ tuisary Amieu, Kemari mũkuru. Asea tõ tuisary Setua, Mikaeu mũkuru. Napatari tõ tuisary Napi, Wopixi mũkuru. Kate tõ tuisary Keueu, Maki mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Moro sã mokaro orutua kõ esety nexiase. Mokaro tonyohse Moeze a nono enetohme. Ozeja, Num mũkuru esety tymyakãmase eya Jozueme. ");
INSERT INTO apyNT_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mokaro tonyohse ahtao Moeze a nono enetohme ynara tykase eya xine: — Ytotoko inikahpozakoxi nono ikurenae poro, onuhtohme ypy tõ poro. ");
INSERT INTO apyNT_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Enetoko kure moro nono ehtoh poko. Ahno, moro nono põkõ enetoko: jamihme toh nae? jamihme pyra? tuhke nae? tuhke pyra? ");
INSERT INTO apyNT_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Enetoko roropa moro nono: otyro zamaro nae? Otyro zamaro pyra nae? pata tõ enetoko: apuru tõ nae? arypyra nae? ");
INSERT INTO apyNT_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Nono enetoko ropa, oty sã nae? Kure arykatohme? Popyra? Wewe tõ roropa enetoko. Orẽpyra ehtoko otyro epery enehtatoko roropa moro poe (Uwa epery tõ toehse ehtoh exipitõko nexiase). ");
INSERT INTO apyNT_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Naeroro mokaro orutua kõ toytose toh nexiase nono enese ona Zim poe inikahpozakoxi Reope pona, onuhtoh Hamate pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Toytose toto nono ikurenae poro Eperõ pona. Moroto anakĩ tõ nexiase ahno konõto pakomotyamo: Aimã te, Sesai te, Taumai, enara. (Eperõ pata tyrise kynexine osemazuhme, okomino 7me jeimamyry taropose ahtao pata Zoã tyrise Ejitu po.) ");
INSERT INTO apyNT_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Moromeĩpo toeporehkase toto jakanahmã Exikou pona. Moroto uwa amoriry tysahkase eya xine uwa epery tõ maro zumo, omoxihxo, asakoro orutua kõ se nexiase ipuimatohme tyhwyme mara poko. Imehnõ epery tõ tarose roropa eya xine: romã tomo, fiku tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","(Moroto tosehpase eya xine Jakanahmã Exikoume, uwa amoriry konõto tysahkase moroto exiryke eya xine.) ");
INSERT INTO apyNT_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Morarame moro nono tonese ahtao eya xine 40me ẽmepyry ae, ");
INSERT INTO apyNT_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","toytose ropa toto. Tooehse ropa toto Kate pona, ona tonorẽ Parã pona. Moroto Moeze nexiase, Arão maro, Izyraeu tõ maro emero. Tõturuse toto imaro xine tynenehpyrykõ poko. Moro epery tõkehko tonepose eya xine, tynenepyhpyrykõ moro nono poe. ");
INSERT INTO apyNT_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ynara tykase toto Moeze a: — Ynanytoase moro nono pona yna aropotopõpyry ae ro oya. Ajohpe pyra, otyro zamaro moro nono mana, kure kuhse mana. Seny otyro epery kehko. ");
INSERT INTO apyNT_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Yrome moro põkõ jamihme mã toto, ipatarykõ zumo mana, tapuruse roropa. Moro motye roropa ahno konõto pakomotyã ynanenease moroto. ");
INSERT INTO apyNT_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amarekita tõ moroto nono ikurenae po. Heteu tõ ypy tõ po mã toto, jepuseu tõ maro te, amoreu tõ maro. Kanaã põkõ tuna konõto Metiteraneu pũto mã toto, tuna Joatão ehpiõ po roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Mame Moeze tykerekeremase toto a yrome toto tymynyhpãkapose Karepe a ynara karyke: — Ehmaropa etonatohme seromaroro moro nono põkõ poremãkatohme. Jamihme sytatose, orẽpyra exĩko sytatose! ");
INSERT INTO apyNT_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Yrome imehnõ mokaro imaro aytotyã ynara tykase: — Arypyra. Osetapasaromepyra sytatose mokaro maro, jamihmehxo mã toto, kymotye xine. ");
INSERT INTO apyNT_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Moro ke ajohpe omi tokarose eya xine Izyraeu tomo a moro nono poko tynenehpyrykõ poko. Ynara tykase toto: — Moro nono põkõ osenahkãko mã toto. Mosahxo roropa moro põkõ tonese yna a. ");
INSERT INTO apyNT_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Moroto ahno konõto ynanenease roropa, Anake pakomotyamo. Mokaro pũto taparara sã ynanexiase yna a. Eya xine roropa taparara sã rokẽ ynanexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Mame tyxitarykõ poko kui kary poko roropa tõmehse toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Moeze tõ tykerekeremase nexiase Arão maro. Ynara tykase toto: — Kurehxo exiry toorihse kuahtao xine Ejitu po, sero ona tonorẽ po roropa! ");
INSERT INTO apyNT_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Oty katohme kymarokõ tonehse xiaro Ritonõpo Kuesẽkomo a sero nono pona? Orihnõko sytatose osetapary poko, kypyxiãkõ kypoenõ roropa apoĩko imehnõ mana typoetory tõme. Kurehxo exiry Ejitu pona kytorykõ ropa. ");
INSERT INTO apyNT_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ynara tykase toto oseya xine: — Imepỹ tuisa symenekatone Ejitu pona kytotohkõme ropa! ");
INSERT INTO apyNT_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mame tosekumuru po typorohse Moeze tomo, Arão maro tõmytykõ nono pokoxi imoihmãkõ ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Jozue a, Num mũkuru, Karepe a roropa, Jepone mũkuru tupõkõ tyxihkase toemynyhmarykõ enetupuhpotohme. Tuisa tõ nexiase asakoro, nono enese aytotyamo. ");
INSERT INTO apyNT_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Tõturuse toto imoihmãkomo a. Ynara tykase toto: — Moro nono, ynanenehpyry kure kuhse mana. ");
INSERT INTO apyNT_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ritonõpo Kuesẽkõ kuakorehmarykohtao, kuarotorỹko mana moro nono pona. Moro ekarõko kyya xine mana kuesarykõme, nono kurano, otyro zamaro exikety. ");
INSERT INTO apyNT_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Yrome Ritonõpo onurumekara ehtoko, moro nono põkõ zuno pyra ehtoko. Toto poremãkapõko sytatose. Tupime pyra exĩko mana Ritonõpo kymaro xine exiryke. Mokaro neponãmarykõ pake typoremãkase eya. Towomaneke pyra toehse mokaro mana; naeroro enaromyra ehtoko, tykase Karepe, Jozue maro. ");
INSERT INTO apyNT_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Imoihmãkõ emero toto etapary se toh nexiase topu ke. Yrome ezuru jamihmã tonese eya xine emero, Ritonõpo Tapyĩ epoe. ");
INSERT INTO apyNT_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ynara tykase Ritonõpo Moeze a: — Otara ahtao jurumekakehnõko moxiã nae? Otara ahtao jenetupuhpitõko toh nae, tuhke yjamitunuru enepoase eya xine? ");
INSERT INTO apyNT_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Tyrohsẽ enehpõko ase mokaro enahkapotohme. Yrome opoenõ, apakomotyã roropa rĩko ase imoihme, mokaro motye; jamihme roropa, mokaro motye. ");
INSERT INTO apyNT_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Yrome Ritonõpo tozuhse Moeze a, ynara tykase ynororo: — Ajamitunuru ke moxiã menehpoase Ejitu poe. Ejitu põkõ zuaro toehse ahtao onyriry poko moxiamo a, ");
INSERT INTO apyNT_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","moro ekarõko mã toto sero nono põkomo a. Tuaro toehse mã toto omoro, Ritonõpo, opoetory tõ rãnao oexiry poko, osenepõko mase eya xine akurũ ao tyhtose awahtao yna epoe. Zuaro roropa mã toto oytory poko osemazuhme akurũ ao saereme ahtao, apoto ao, xikihme exikety ao tykohmãse ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Opoetory tõ etaparyhtao oya, moro ekarory etãko imehnõ nonory põkomo. Mame ynara ãko mã toto: ");
INSERT INTO apyNT_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Typoetory tõ totapase eya ona po, toto anarosaromepyra toexiryke moro nono pona, sero nono ekarõko ase oya xine oesarykõme, kaxĩpo. ");
INSERT INTO apyNT_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Seromaroro, Ritonõpo, ajohpãme sã ajamitunuru enepoko onetapohpyry ae ro ynara karyhtao: ");
INSERT INTO apyNT_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","“Ywy, Ritonõpo, penekehpyra ase, imehnõ pynanohnõko ase; popyra toto ehtoh korokãko ase, iirypyry roropa. Yrome iirypyrymãkõ onyripyra ase zae ehtoh poko exiketõ samo. Popyra exiketõ rypyry epehmapõko ase imũkuru tomo a, ipakomotyamo a, imũkuru tõ pakomotyamo a roropa, asakoropane zumakahpõkomo a.” ");
INSERT INTO apyNT_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Naeroro seromaroro, Ritonõpo, sero ahno rypyry ikorokako imehnõ pyno exikehpyra oexiryke, onyrihpyry sã Ejitu poe tarona. ");
INSERT INTO apyNT_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ynara tykase Ritonõpo: — Onekaropohpyry ae ro iirypyrykõ korokãko ase. ");
INSERT INTO apyNT_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Yrome isene jexiryke, taro jexiryke roropa amaro, imehxo jehtoh sero nono pehkaryke, jomiry etapõko ase: ");
INSERT INTO apyNT_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","mokaro orutua kõ emero eporehkara mã toto moro nono pona. Ysaerehkatoh tonese eya xine, yjamitunuru roropa Ejitu po ona po roropa repe. Yrome jukukuase toto 10me, penekehpyra jexiry tukuhse eya xine, jomiry omipona se pyra toexirykõke. ");
INSERT INTO apyNT_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Jũme mokaro omõpyra exĩko mã toto moro nono pona, moro ekarõko ase, katopõpyry atamurukomo a. Mokaro emero jurumekahpõkõ moro nono onenepyra ekurehnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Yrome ypoetory Karepe tyoro sã tuzenuke mana emero rokẽ sã pyra. Anamonohpyra jomiry omipona toehse mã ynororo. Naeroro moro pata pona tyripõko ase, inenehpyry pona. Ipakomotyã roropa ripõko ase moro nono esẽme. ");
INSERT INTO apyNT_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Seromaroro amarekita tõ moroto mã toto, kananeu tõ maro jakanahmã tõ po; Naeroro kokoro ytotoko ropa ona tonorẽ pona ropa, tuna Akapa etonie ropa. ");
INSERT INTO apyNT_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ritonõpo, toto Esẽ ynara tykase Moeze tomo a Arão maro: ");
INSERT INTO apyNT_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","— Ykerekerematopõpyry Izyraeu tomo a totase ya. Penekehnõko ase mokaro, popyra exiketõ ykerekeremary poko. ");
INSERT INTO apyNT_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ynara kaxiko eya xine: “Jomiry etapõko ase oya xine, onekaropohpyrykõ ya ekarõko ase oya xine. Ywy, Ritonõpo, oturuno. ");
INSERT INTO apyNT_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Orihnõko matose, oekepyry tõ sapararahme exĩko mã toto ona po. Tykerekeremase ywy oya xine. Naeroro amarokõ emero 20me jeimamyry motye exiketõ omõpyra matose moro nono pona. ");
INSERT INTO apyNT_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Jomihpyry totapose ya moro nono ekarory poko oya xine oesarykõme. Yrome amarokõ emero omõpyra matose moro nono pona. Karepe rokẽ Jepone mũkuru, Jozue maro, Num mũkuru ytõko mã toto moro nono pona. ");
INSERT INTO apyNT_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Omũkuru tõ tapoisẽme exĩko imehnõ poetoryme mekaroatose. Yrome mokaro omũkuru tõ arõko ase moro nono pona, ise pyra oehtopõpyrykõ pona, moroto toto esaryme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Yrome amarokõ orihnõko matose, oekepyrykõ taro exĩko sero ona po. ");
INSERT INTO apyNT_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Taro omũkuru tõ ytoytõko mã toto 40me jeimamyry. Tamonohse oya xine, naeroro sam ãko matose, amarokõ emero oorihtohkõ ponãmero taro. ");
INSERT INTO apyNT_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","40me jeimamyry aropõko matose oetuarimarykõ poko oorypyrykõ pokoino. 40me ẽmepyry maropoatose moro nono enery poko oya xine. Naeroro toiro ẽmepyry ahtao toiro jeimamyry etuarimãko matose. Zuaro exĩko matose ymaro osepeme pyra oehtohkõ poko. ");
INSERT INTO apyNT_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Jomiry etapõko ase oya xine, popyra exiketomo, oximõme jurumekary se exiketomo: amarokõ emero orihnõko matose, tonahkasẽme exĩko matose sero ona tonorẽ po. Ywy, Ritonõpo oturuno.” ");
INSERT INTO apyNT_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Mokaro orutua kõ, Moeze naropotyã moro nono enese, ajohpe tõturuse moro poko imoihmãkomo a. Morara exiryke tykerekeremase toto Ritonõpo netaryme Moeze poko. Naeroro tyrohsẽ tonehpose Ritonõpo a kure pyra toto ehtohme, toorihse roropa toto. ");
INSERT INTO apyNT_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mokaro 12mãkõ, nono enese aytotyã wino, Jozue rokẽ Karepe maro tõxinamase isene ro. ");
INSERT INTO apyNT_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mame Ritonõpo omiry tokarose ahtao Moeze a Izyraeu tõ netaryme tãkye pyra toehse toh nexiase ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Yrokokoro pakeimo toytopitose toto somokyhmã pona, ynara karyke: — Seromaroro ehmaropa Ritonõpo nekarohpyry pona. Ajohpe pyra iirypyryme sexiatose. ");
INSERT INTO apyNT_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Yrome ynara tykase Moeze: — Naeroro oty katohme aomiry omipona se pyra hmatou? Orẽnõko matose. ");
INSERT INTO apyNT_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ytopyra ehtoko moro somokyhmã pona. Ritonõpo amaro xine pyra mana. Oepetõkara oporemãkapõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amarekita tõ moroto mã toto, kananeu tõ maro etonatohme amaro xine, oetapatohkõme. Ritonõpo amaro xine pyra mana, turumekase ynororo oya xine exiryke. ");
INSERT INTO apyNT_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Yrome putupyrahme sã toytose toto ypy tõ pona; Ritonõpo omihpyry ẽ ytopyra nexiase. Moeze roropa ytopyra nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Mame Amarekita tõ kananeu tõ roropa moro ypy tõ põkõ osetapano poko toh nexiase. Izyraeu tõ typoremãkase eya xine. Tokahmase toto eya xine Horoma pona. ");
INSERT INTO apyNT_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Mame Ritonõpo tõturuse Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","— Ynara tyripõko mase, sero omipona Izyraeu tõ ehtohme toeporehkase awahtao xine moro nono pona, ynekarory pona oesarykõme. ");
INSERT INTO apyNT_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Okyno enepyryhtao oya xine onekaroryme Ritonõpo a: pui orutua te, kaneru te, poti ahtao, mokyro ekarõko mase: jahkatohme tytororo apoto apõ po te, otarame õmihpyry omipona oehtohme te, otarame mokyro ekarory se rokẽ oexiryke te, otarame oseahmatoh po onekaroryme mana. Typoxine mokaro exĩko mã toto Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","Mame kaneru enepyryhtao oya jahkatohme onekaroryme Ritonõpo a, poti enepyryhtao roropa, mokyro maro tiriiku enehko toiro kirume, azeite maro 1 riturume, uwa eukuru jehnahpyry maro 1 riturume. ");
INSERT INTO apyNT_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Toiro kaneru maro onekaroryme tiriiku enehko 2 kirume otoxie azeite maro 1¼ rituru te, ");
INSERT INTO apyNT_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","uwa eukuru jehnahpyry 1¼ riturume roropa. Morohne typoxine exĩko mana Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Pui mũkuru ekaroryhtao jahkatohme onekaroryme Ritonõpo a te, õmihpyry omipona oehtohme te, osepeme ehtohme, ");
INSERT INTO apyNT_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","imaro tiriiku enehtoko 3 kirume tapose aexihpyry kurano otoxie azeite maro 1¾ riturume ");
INSERT INTO apyNT_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","moro maro roropa uwa eukuru jehnahpyry 1¾ riturume. Moro tyahkase ahtao typoxine exĩko mana Ritonõpo a, Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Moro sã tyrĩko matose pui orutua maro te, kaneru orutua maro te, kaneru mũkuru maro te, poti mũkuru maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Toiro okyno motye ekaroryhtao oya xine onekarorykõme, imaro xine itamurumehxo tiriiku tõkehko enehnõko matose tuhke mokaro ehtoh samo. ");
INSERT INTO apyNT_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Izyraeu tõ emero moro sã tyrĩko mã toto tynekarorykõ enepyryhtao jahkatohme, typoxine ehtohme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Moro saaro imehnõ nonory põkõ amaro xine exiketõ asã xine tyrĩko mã toto tynekarorykõ enepyryhtao, tiriiku tõkehko maro, typoxine exikety Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ynyripohpyry omipona tyrĩko mã mokaro, asã xine, imepỹ nono poe aehtyamo, amaro xine exiketomo. Toiro jomihpyry mana eya xine, oya xine roropa jũme etyorõmara mana, opoenõ poenomo a roropa. Ritonõpo a oxisã matose mokaro maro; ");
INSERT INTO apyNT_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","moro ynyripohpyry omipona oehtohkõme mana, mokaro roropa, asã xine. ");
INSERT INTO apyNT_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ritonõpo, Izyraeu tõ Esẽ tõturuse ropa Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Tynyripohpyry tokarose eya aomipona Izyraeu tõ ehtohme toeporehkase toto ahtao moro nono pona, inekarory eya xine esarykõme. ");
INSERT INTO apyNT_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Morarame tonahsẽ enapyryhtao oya xine, moroto toehse aexihpyry, zokonaka apiakãko matose ekarotohme onekarorykõme kurã Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Wyi riryhtao oya xine, moro wyi osemazuhme tyrise ahtao tiriiku ekeisenã ke, moro ekarõko matose onekarorykõme kurã Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Amarokomo, opoenomo te, apakomotyã roropa moro pão ekarõko matose Ritonõpo a onekarorykõme kurã eya. ");
INSERT INTO apyNT_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Mame tyyrypyhpyke toehse awahtao xine, tuamekaro rokẽ oexirykõke: ynyripohpyry Moeze a omipona pyra toehse awahtao xine, ");
INSERT INTO apyNT_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","emero Ritonõpo nyripohpyry oya xine, Moeze a, apitorymã poe moro tyripotoh turuse ahtao Ritonõpo a tarona, opoenõ poenomo a, ynara tyrĩko matose: ");
INSERT INTO apyNT_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","awamekaro xine rokẽ iirypyryme toehse awahtao xine, zuaro pyra imoihmãkõ ahtao, toiro pui mũkuru ekarõko mã toto jahkatohme, typoxine ehtohme Ritonõpo a, tiriiku maro, uwa eukuru jehnahpyry maro, Ritonõpo nyripohpyry ae ro te, toiro poti mũkuru maro tyyrypyrykõ korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Naeroro mokaro nekarory zahkãko oturukety mana, imoihmãkõ nekaroryme, iirypyrykõ korokapotohme. Tykorokasẽme exĩko mã toto. Iirypyryme toexirykõ se pyra tahtao xine iirypyryme toehse, naeroro tynekarorykõ tyahkapose eya xine tyyrypyrykõ korokapotohme Ritonõpo a, tonahsẽme sã roropa eya. ");
INSERT INTO apyNT_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Izyraeu tõ emero, imehnõ roropa imepỹ nono poe amaro xine exiketõ tykorokasẽme exĩko, iirypyryme toehse oexirykõke emero awamekaro xine rokẽ awahtao xine. ");
INSERT INTO apyNT_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Toiro ahno iirypyryme toehse ahtao tuenikaroro rokene, poti enehnõko mana toiro jeimamyry exikety jahkatohme tyyrypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Okyno zahkãko oturukety mana apoto apõ po mokyro rypyry korokapotohme tuenikaroro rokẽ iirypyryme aexihpyry, mame tykorokasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ritonõpo nyripohpyry toiro mana tuenikaroro iirypyryme toehse exiketõ poko Izyraeume exiketyme ahtao imepỹ nono poe exiketyme roropa amaro xine ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Yrome tyyrypyry poko toehse ahno ahtao, tuaro ahtao Izyraeume exikety ahtao, imepỹ nono poe exiketyme ahtao amaro xine, tuãnohsẽme exĩko Ritonõpo omiry omipona pyra toehse exiryke. Taorihmaposẽme exĩko mana, ");
INSERT INTO apyNT_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Ritonõpo nyripohpyry turumekase exiryke eya. Aomihpyry omipona pyra toehse toexiryke tuãnohsẽme exĩko mana tynyrihpyry emetakame. ");
INSERT INTO apyNT_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Mame ona po Izyraeu tõ ahtao orutua tonese eya xine apotopokõ apoĩko oserematoh ae. ");
INSERT INTO apyNT_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Mokyro tarose enenanomo a Moeze a Arão maro imoihmãkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Orutua kõ tyrise eya xine mokyro eraseme ekaropotohto Ritonõpo a oty ritohme eya, zuaro pyra ro toexirykõke. ");
INSERT INTO apyNT_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Mame ynara tykase Ritonõpo Moeze a: — Mokyro totapasẽme mana; ah imoihmãkõ mokyro etapã toto topu tõ ke ameke tapyi tõ poe! ");
INSERT INTO apyNT_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Naeroro Ritonõpo nyripohpyry ae ro Moeze a, mokyro tarose eya xine tapyi tõ poe, totapase ynororo eya xine topu tõ ke aorihtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ynara tykase ropa Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","— Oturuko Izyraeu tomo a, ipakomotyamo a roropa aretyry tõ ritohme tupõ ehpiry tõ pokona. Emero aretyry tõ pokona eary ezuezume tyripotoko. ");
INSERT INTO apyNT_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mame moro aretyry tõ eneryhtao oya xine, osenetupuhnõko matose emero Oesẽkõ nyripohpyry poko oya xine omipona oehtohkõme. Anamonohpyra ehtoko jomiry omipona oehtohkõ poko, openetatohkõ poko pyra ehtoko, oenurukõ penetatoh poko pyra roropa ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Moro aretyry tõ ãkorehmatorỹko jomihpyry tõ poko wenikehpyra oehtohkõme, jomipona oehtohkõme. Ahtao, ahno apiakasẽ sã exĩko matose ypoetoryme rokẽ rahkene. ");
INSERT INTO apyNT_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ywy ase Ritonõpo Oesẽkomo. Kuenepyatose Ejitu poe ypoetoryme oehtohkõme, Oesẽkõme roropa jehtohme. Ywy ase Ritonõpo Oesẽkomo. ");
INSERT INTO apyNT_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Kora, Isara mũkuru, Koate ekyry, Rewi pakomotyã ekyry ajoajohpe toehse. Typenekehse ynororo Moeze tutuisarykõme ehtoh poko. Tõximõse ynororo oseruao orutua kõ maro, Rupẽ pakomotyamo. Asakoro toh nexiase Eriape mũkuru tomo, Tatã te, Apirão maro; imepỹ nexiase Om, Perete mũkuru. Imehnõ orutua kõ 250mãkõ toahmase roropa Kora a, tamuximãkomo, orẽpyra exiketomo, tuisamãkomo. ");
INSERT INTO apyNT_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Oximõme toytose toto oturuse Moeze tõ maro Arão maro. Ynara tykase toto: — Epo hnae tuisamehxo oehtohkomo! Moxiã emero Ritonõpo Kuesẽkõ poetoryme mã toto. Typoetory tõ rãnao Ritonõpo mana. Naeroro oty katohme tuisamehxo osekarõko matou, Ritonõpo poetory tõ esãme? ");
INSERT INTO apyNT_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Morara kary etaryke Moeze a tosekumuru po typorohse ynororo tõmyty po nono pokoxi oturutohme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ynara tykase ynororo Kora tomo a, imaro exiketõ maro: — Kokoro pakeimo typoetory tõ enepõko Ritonõpo mana, tapiakase exiketõ tymaro aerohtohme. Tynymenekahpyry enehpõko Ritonõpo mana apoto apõ pũtokoxi toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Kokoro pakeimo ixtaratu zahkatoh apoitoko, omoro Kora amaro exiketõ maro, ikarany tyritoko zaka ixtaratu maro arotohme apoto apõ pũtokoxi. Mame enẽko sytatose onoky kywino xine Ritonõpo nymenekahpyryme nae. Seromaroro epo hnae, amarokõ tymotyẽkase mexiatose, rewita tomo! ");
INSERT INTO apyNT_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Ynara tykase roropa Moeze Kora a: — Etatoko ke seromaroro rewita tomo! ");
INSERT INTO apyNT_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Amarokõ tapiakase Ritonõpo Kuesẽkomo a, imehnõ Izyraeu tõ winoino tupũtokoxi oehtohkõme, erohtohme Tytapyĩ Kurã tao, typoetory tõ akorehmary poko. Morohne oya xine ipune pyra nae? ");
INSERT INTO apyNT_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Moro oerokurukõ kurã tokarose Ritonõpo a oya xine, rewita tomo. Seromaroro oturuketõme oexirykõ se roropa hmatou? ");
INSERT INTO apyNT_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Arão kerekeremaryhtao oya xine, Ritonõpo Kuesẽkõ kerekeremãko matose, amaro exiketõ maro. Inyripohpyry omipona pyra exĩko matose. ");
INSERT INTO apyNT_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mame Tatã tõ tonehpose Moeze a, Apirão maro, Eriape mũkuru tomo. Yrome omi arone tozuhse eya xine: — Ytopyra ynanase! ");
INSERT INTO apyNT_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Epo mana. Nono kurã poe, otyro zamaro exikety poe kuenepyatose yna orihmapotohme sero ona tonorẽ po. Moro motye yna aropõko mase tuisamehxo awahtao samo. ");
INSERT INTO apyNT_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ajohpe pyra, yna onenehpyra mekuretyase nono kurã pona, otyro zamaro exikety pona, tupito tõ onekaropyra mexiase yna a ona kurã maro yna esaryme ehtohme. Moro motye yna enekunopyry se mahno. Ytopyra ynanase! ");
INSERT INTO apyNT_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mame Moeze tyekĩtapãse, ynara tykase ynororo Ritonõpo Tosemy a: — Mokaro omiry onetara exiko tynekarorykõ enepyryhtao oya. Mokaro onenekunohpitopyra exiase, ekykõ jumẽtu anapoipitopyra roropa exiase! ");
INSERT INTO apyNT_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mame Kora a ynara tykase Moeze: — Kokoro osehko amaro 250mãkõ maro Ritonõpo Tapyĩ Kurã taka. Arão roropa moroto exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Amarokõ emero ixtaratu zahkatoh apoitoko, ixtaratu tyritoko zaka arotohme apoto apõ pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Naeroro tykyryrykõ, ixtaratu zahkatoh tapoise eya xine, ikarany tyrise eya xine zaka ixtaratu maro, xikihme toh nexiase emero Tapyi omõtoh tao Moeze tõ maro Arão maro. ");
INSERT INTO apyNT_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Mame mokaro emero taoximõnohpose Kora a, Moeze tõ maro osẽpataka toehse toto Arão maro Ritonõpo Tapyĩ omõtoh tao. Mame Ritonõpo saerehkatoh konõto tonese eya xine emero. ");
INSERT INTO apyNT_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ynara tykase Ritonõpo Moeze tomo a Arão maro: ");
INSERT INTO apyNT_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","— Ameke ehtoko moxiã winoino, toto enahkatohme ya axiny. ");
INSERT INTO apyNT_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Yrome tosekumuru po typorohse Moeze tomo Arão maro tõmytykõ po nono pokoxi, ynara tykase toto: — Ritonõpo isene ehtoh ekaroneme mase ahno a emero. Toiro rokẽ ahno iirypyryme ehtoh pokoino opoetory tõ emero zehno exĩko mah? ");
INSERT INTO apyNT_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","— Oturuko imoihmãkomo a ameke toto ehtohme Kora tõ tapyĩ winoino, Tatã tapyĩ winoino, Apirão tapyĩ winoino roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mame Moeze toytose imehnõ tamuximãkõ maro Tatã tõ esaka Apirão maro. ");
INSERT INTO apyNT_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ynara tykase Moeze imoihmãkomo a: — Ameke ehtoko mokaro, popyra exiketõ tapyĩ winoino, ikyryrykõ anapopyra ehtoko ipunaka; tomeseke pyra awahtao xine amarokõ roropa tonahkasẽme exĩko matose mokaro popyra ehtoh pokoino. ");
INSERT INTO apyNT_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Naeroro ameke toytose imoihmãkomo Kora tõ tapyĩ winoino, Tatã maro, Apirão maro. Tatã tõ tutũtase Apirão maro, tehme toh nexiase tytapyĩ omõtoh tao, typyxiãkõ maro typoenõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mame ynara tykase Moeze imoihmãkomo a: — Ourutorỹko ase zuaro exĩko matose ywy poe pyra senohne emero toehse. Ritonõpo nyripohpyry omipona senohne tyrise ya. ");
INSERT INTO apyNT_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Mokaro orutua kõ orikyry emero rokẽ orikyry sã ahtao, toto onuãnohpyra Ritonõpo ahtao, jenyohpyra Ritonõpo nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Yrome tyoro sã tyrise ahtao eya enetupuhpotohme, sero nono ẽtakaryhtao mokaro enahtohme itapyĩ taõkõ maro, imõkomory maro, tomõse toto ahtao isene ro aorihtyã esaka, zuaro exĩko matose Ritonõpo turumekase moxiamo a. ");
INSERT INTO apyNT_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Morarame tõturukehse Moeze ahtao nono totapuruhmakase mokaro zopino, ");
INSERT INTO apyNT_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","tonahse toto itapyĩ taõkõ maro, Kora ekahmananõ maro emero, imõkomory maro. ");
INSERT INTO apyNT_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Moro sã tyhtose toto isene ro nono aka aorihtyã esaka imõkomory maro emero porehme. Mame nono tapuruse ropa, osenepyra toehse toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Mokaro kui kui kary etaryke tyya xine tururume toytose Izyraeu tomo, moroto aexityamo. Kui ãko roropa toh nexiase, ynara tykase toto: — Epatoko! Kuenahkatorỹko nono mana! ");
INSERT INTO apyNT_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Mame apoto tonehpose Ritonõpo a mokaro 250mãkõ orihmapotohme, ixtaratu zahkahpõkomo. ");
INSERT INTO apyNT_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","— Oturuko Ereaza a, oturukety Arão mũkuru a, moro metau risẽ ixtaratu zahkatoh kehko apoitohme eya apoto zahkatopõpyry poe, oruno akoĩpyry pahtohme eya, Ritonõpo kyryryme kurã, moro ixtaratu zahkatoh tonõ exiryke. ");
INSERT INTO apyNT_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ritonõpo kyryry kurãme toehse toh nexiase tokarose toto ahtao Ritonõpo a apoto apõ po. Naeroro moro ixtaratu zahkatoh tonõ apoiko mokaro tyahkase aexityã ekepyry winoino, tyyrypyrykõ emetakame tyahkase toto. Mame moro ixtaratu zahkatoh tonõ etapako metau risemy, paratu kãseme ehtohme apoto apõ apurume tyritohme. Izyraeu tõ enetupuhpotohme exĩko mana, enaroximatohme. ");
INSERT INTO apyNT_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Naeroro moro ixtaratu zahkatoh tonõ tapoise Ereaza a. Tapĩpose kehko eya paratu kãsemã apoto apõ apuru ritohme. ");
INSERT INTO apyNT_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Ritonõpo oturutopõpyry ae ro Moeze a, Izyraeu tõ enaroximatohme toehse moro, imehnõ pyra, Arão poenõ rokẽ ipakomotyã roropa oehtohme ixtaratu zahkatohme Ritonõpo ẽpataka. Imehnõ tuãnohse exiry Kora tõ wãnohtopõpyry samo, imarõkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Yrome yrokokoro Izyraeu tõ emero tykerekeremapitose toto Moeze tõ poko Arão maro. Ynara tykase toto: — Ritonõpo Kuesẽkõ poetory tõ totapase oya xine! ");
INSERT INTO apyNT_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Morarame tõximõse imoihmãkõ ahtao Moeze tõ kerekeremase Arão maro toeramase toto Ritonõpo Tapyĩ winakoxi. Akurũ tonese eya xine Tapyi epoe. Ritonõpo saerehkatoh konõto tõsenepose eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moeze tõ toytose Arão maro Tapyi omõtoh ẽpataka xikihme. ");
INSERT INTO apyNT_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","— Ytotoko mokaro winoino. Toto enahkãko ase seromaroro rahkene! Yrome tosekumuru po typorohse Moeze tomo Arão maro tõmytykõ po nono pokoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Ynara tykase Moeze Arão a: — Okyryry ixtaratu zahkatoh apoiko, ikarã tyriko zaka apoto apõ poe, ixtaratu roropa tyriko ikarã pona. Axĩ ke ytoko ahno tõ pona onekarory zahkatohme mokaro rypyry korokapotohme. Axiny! Toto zehno Ritonõpo ehtoh osenepopitõko mana. Tyrohsẽ toehpitose mana! ");
INSERT INTO apyNT_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Naeroro tykyryry, ixtaratu zahkatoh tapoise Arão a Moeze omihpyry omipona. Tururume toytose ynororo ahno rãnaka. Tyrohsẽ oehpitory tonese ahtao Arão a, ixtaratu tyrise eya ikarã pona, tynekarory tokarose eya Ritonõpo a mokaro ahno rypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Moro ke tyrohsẽ tymynyhpãse, moroto Arão nexiase xikihme ahno rãnao, xia isene exiketomo, mya aorihtyã ekepyry tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Mokaro toorihse aexityã tuhke exiry 14.700me nexiase, Kora tõ toorihse aexityã maro pyra. ");
INSERT INTO apyNT_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Mame tyrohsẽ tonahse ahtao, Arão toytose ropa Ritonõpo Tapyĩ omõtoh taka, moroto Moeze exiryke. ");
INSERT INTO apyNT_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","— Oturuko Izyraeu tomo a, 12me oxiekyrymãkõ tuisary tomo a imyxiry enehtohme, 12me imyxiry tõ ehtohme atapona. Mame tuisa esety imeroko imyxiry pokona. ");
INSERT INTO apyNT_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Moromeĩpo Arão esety imeroko Rewi tõ myxiry pokona. Toiro myxiry exĩko toiro oxiekyrymãkõ tuisary esety ke. ");
INSERT INTO apyNT_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Mame moro imyxiry tõ tyriko Tapyi Kurã tao, jomihpyry ẽ ẽpataka kuoseporytoh po. ");
INSERT INTO apyNT_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Morarame ynymenekahpyry myxiry arỹtãko mana. Moro eneryke tyya xine okerekeremakehnõko Izyraeu tõ mana, typenekehse ywy okerekeremary etaryke ya. ");
INSERT INTO apyNT_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Naeroro Moeze tõturuse Izyraeu tomo a. Ituisary tomo a tymyxiry tõ tokarose eya, oxiekyrymãkõ tuisary 12me toh nexiase, imyxiry tõ 12me roropa nexiase. Arão myxiry mokaro myxiry tõ maro nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moro imyxiry tõ tyrise Moeze a Ritonõpo Tapyĩ taka, aomihpyry ẽ ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Yrokokoro Moeze tomõse Tapyi Kurã taka. Imyxiry tonese eya Arão esety ke ipoko, Rewi ekyry tõ tuisary kyryryme tarỹtase. Tokutase roropa, topere toehse roropa, amẽtoa tõ toehsehxo exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mame moro imyxiry tõ tarose emero Moeze a Ritonõpo ẽpatae Izyraeu tomo a. Tonese eya xine. Mame tymyxiry tõ tapoise ropa eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Mame ynara tykase Ritonõpo Moeze a: — Tyriko ropa moro imyxiry Arão esety ke tymerose exikety jomihpyry ẽ ẽpataka. Moroto exĩko mana Izyraeu tõ ajoajohpe exiketõ enaroximatohme; ykerekeremakehnõko mã toto aorikyrykõino. ");
INSERT INTO apyNT_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mame moro tyrise Moeze a Ritonõpo nyripohpyry omipona. ");
INSERT INTO apyNT_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Ynara tykase imoihmãkõ Moeze a: — Orihnõko ynanase! Orihketõme ynanase! Kymarokõ emero orihnõko sytatose. ");
INSERT INTO apyNT_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ritonõpo Tapyĩ pũtokoxi ytokety orihnõko mana. Morara ahtao kymarokõ emero orihketõme sytatose! ");
INSERT INTO apyNT_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Ynara tykase Ritonõpo Arão a: — Amarokõ tymenekase ya Ytapyĩ poko oerohtohkõme: omoro, omũkuru tomo, imehnõ rewita tõ maro. Tomeseke ehtoko zae rokẽ oehtohkõme Ytapyĩ poko oerohtohkõ poko. Azahkuru awahtao xine amarokõ rokẽ tuãnohsẽme exĩko. Yrome omoro Arão, omũkuru tõ maro rokẽ tymenekase ya oturuketõme. Azahkuru toehse awahtao xine oturuketõ erohtoh poko amarokõ rokẽ tuãnohsẽme exĩko matose. ");
INSERT INTO apyNT_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Imehnõ rewita tõ enehko, oekyry tomo ãkorehmatohkõme omũkuru tõ maro Ytapyĩ tao oerohtohkõ poko. ");
INSERT INTO apyNT_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Mokaro rewita tõ erohnõko mã toto onyripohpyry poko, erohnõko roropa mã toto Ytapyĩ poko. Yrome ykyryry tõ kurã pũtokoxi toto onenehpopyra exĩko Osa Kurã tao, apoto apõ po roropa. Morohne pũtokoxi toehse toto ahtao orihnõko matose, mokaro roropa orihnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Mokaro rewita tõ erohnõko mã toto amaro Ytapyĩ erohtoh poko emero poko, yrome imehnõ onyrohmanohpopyra exiko amaro xine. ");
INSERT INTO apyNT_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Omoro rokẽ omũkuru tõ maro erohnõko matose Osa Kurã tao, apoto apõ poko roropa Izyraeu tõ zehno ropa jexiryino. ");
INSERT INTO apyNT_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Izyraeu tõ poe oekyry tõ tymenekase ya, rewita tomo ynekaroryme oya xine, oturuketomo. Mokaro rewita tõ tapiakase ya mã toto erohtohme Tapyi Kurã poko. ");
INSERT INTO apyNT_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Yrome omoro omũkuru tõ maro erohnõko oturuketõ erohtoh poko apoto apõ poko, ykyryry tõ poko roropa Osa Kurã Kuhse tao. Morohne poko erohnõko matose tapiakase oexirykõke ya oturuketõme oehtohkõme. Yrome imehnõ orihnõko mã toto tooehse toto ahtao ykyryry kurã pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Ynara tykase Ritonõpo, Izyraeu tõ Esẽ Arão a: — Seromaroro ahno nekarohpyry tõ tonehse ahtao ya, jahkara ahtao, morohne ekarõko ase oya, emero, omũkuru tomo a roropa, apakomotyamo a, enara, õtykõme ehtohme jũme. ");
INSERT INTO apyNT_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ykyryry tõ kurã poe, jahkara ahtao ynara apoĩko matose: ahno nekarory tõ tiriiku tõkehko te, inekarory tõ tyyrypyry korokapotohme te, inekarory tõ onyhxiropyra ehtohme, emero tonehse ahtao ahno a tynekaroryme ya ekarõko ase oya, omũkuru tomo a roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Morohne õnõko matose Osa Kurã tao. Orutua kõ rokẽ otuhnõko mã toto moro poko. Tonahsẽ kurãme exĩko oya xine mana ypoe. ");
INSERT INTO apyNT_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Morohne maro imehnõ nekarohpyry tonehse ahtao Izyraeu tomo a õtykõme exĩko. Morohne ekarõko ase oya, omũkuru tomo a, oẽxiry tomo a roropa jũme samo. Oekyry tõ emero toekurãkase exiketõ otuhnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Emero kurehxo exiketõ ekarõko ase oya, osemazuhme toperytase aexityã tonehse ahtao ya Izyraeu tomo a: azeite kurehxo exikety, uwa eukuru jehnahpyry kurehxo exikety, tiriiku kurehxo exikety, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Osemazuhme toehse tykyrysã ahtao, tokarose ahtao ya, moro anapyrykõme exĩko. Mame atapyĩ taõkõ emero toekurãkase exiketõ morohne enahnõko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Izyraeu tõ nonory po emero, tapiakase ahtao ahno nekaroryme Ritonõpo Oesẽkõ kyryryme, ekarõko ase oya. ");
INSERT INTO apyNT_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Emero osemazuhme aenuruhpyry ahno mũkurume, okyno mũkurume roropa Izyraeu tõ nekaroryme ya exĩko. Yrome ahno epehmãko mã toto typoenõ pynanohtohme, okyno nuriame exiketõ pynanohtohme roropa epehmãko esẽ mana. ");
INSERT INTO apyNT_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Moro epehpyry ahno mũkuru pynanohtohme topehmasẽme exĩko oya toiro nuno toehse poeto ahtao. 5me parata epehmãko mã toto, (55 karamame parata tukuhse ahtao Ritonõpo Tapyĩ tao). ");
INSERT INTO apyNT_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Yrome pui mũkuru osemazuhme aenuruhpyry te, kaneru tõ roropa, poti tõ roropa tokarose ahtao ya, mokaro poko onepehmara esẽ mana ipynanohtohme. Jekyme mã toto, totapasẽme exĩko jahkatohme. Imunuru tomasẽme exĩko apoto apõ pokona, ikasery tyahkasẽme exĩko onekaroryme, tonahsẽme sã ya, typoxine exĩko mana ya. ");
INSERT INTO apyNT_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Mokyro pũ õtyme exĩko mana imehnõ ahno nekarotyã kurã samo: ipuropuru te, ipety apotunuru wino maro õtyme ehtoh samo. ");
INSERT INTO apyNT_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Izyraeu tõ nekarory tõ tonehse ahtao ya, morohne ekarõko ase oya, omũkuru tomo a, oẽxiry tomo a roropa, jũme. Moro jomiry etapõko ase jũme etyorõmara ehtohme. Naeroro sautume esehpãko ase jũme etyorõmara exiryke. ");
INSERT INTO apyNT_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Mame ynara tykase Ritonõpo Arão a: — Nono esẽme exipyra exĩko mase Izyraeu tõ nonory po, tupito pyra, ona pyra, imehnõ Izyraeu tõ sã pyra. Izyraeu tõ rãnao ywy ase oesarykõme samo, atapyĩkõme sã roropa, otupikõme sã roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Ynara tykase Ritonõpo Arão a: — Omame porehme exiketõ ousemy toiro exikety ekarõko ase rewita tomo a. Moro tineru tokarose ahtao Izyraeu tomo a ya, moro tokarosẽme exĩko rewita tomo a Tapyi Kurã poko toto erohtamitume. ");
INSERT INTO apyNT_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Taroino imehnõ Izyraeu tõ onenehpopyra exiko Tapyi Kurã pũtokoxi aorikyrykõino, moro iirypyryme exiryke eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Yrome rewita tõ rokẽ erohnõko mã toto Ytapyĩ Kurã poko. Tomeseke exĩko mã toto zae rokẽ toerohtohkõ poko toto ehtohme, toto wãnopyryino. Sero ynyripohpyry jũme mana, ipakomotyã pona. Rewita tõ nono esẽme exipyra exĩko mã toto jũme Izyraeu tõ nonory po. ");
INSERT INTO apyNT_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Ynara exiryke: Izyraeu tõ omame porehme exiketõ ousemy toiro exikety ekarõko mã toto ya tynekarorykõme, moro ekaroase rewita tomo a nono myakãme samo toto kyryryme ehtohme. Morara exiryke moro tykase ywy, nono esẽme pyra rewita tõ exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ritonõpo, Izyraeu tõ Esẽ turupose Moeze a ");
INSERT INTO apyNT_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","rewita tõ zurutohme ynara: — Izyraeu tõ nekarohpyry tõ tapoise ahtao oya xine, omame porehme exiketõ ousemy toiro exikety, Ritonõpo nekarohpyryme oya xine, omame porehme exiketõ ousemy toiro exikety apiakãko matose ekarotohme onekarorykõme kurã Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Moro onekarohpyrykõ tupito poko erohkety nekarory sã mana tykyrysã apoipitoryhtao, uwa eukuru jehnahpyry tyripitoryhtao roropa eya. ");
INSERT INTO apyNT_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Naeroro emero omame porehme exiketõ ousemy toiro exikety apoiryhtao oya xine Izyraeu tõ nekarohpyry tõ poe, amarokõ roropa onekarorykõ ekarõko matose Ritonõpo a, Oesẽkomo a. Moro ekarõko matose oturukety Arão a. ");
INSERT INTO apyNT_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Imehnõ nekarohpyry tõ tapoise ahtao oya xine, zokonaka, kurehxo exikety ekarotoko ya. ");
INSERT INTO apyNT_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Imeĩpo kurehxo exikety tokarose oya xine ahtao ya, akoĩpyry emero okyryryme exĩko, tupito poko erohkety samo, zokonaka tokarose ahtao eya tynekaroryme, akoĩpyry emero imaro exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Moro akoĩpyry enahnõko matose oekyry tõ maro emero rokẽ po oepehpyrykõme exiryke. ");
INSERT INTO apyNT_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Morohne enapyryhtao oya xine iirypyryme pyra matose, kurehxo exikety tapiakase oya xine ahtao onekarorykõme Ritonõpo a. Zae pyra exĩko matose Izyraeu tõ nekarohpyry tõ enapyryhtao oya xine kurehxo exikety onekaropyra ro awahtao xine ya. Ynyripohpyry omipona pyra awahtao xine orihnõko matose. ");
INSERT INTO apyNT_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Ritonõpo, Izyraeu tõ Esẽ tõturuse Moeze tomo a Arão maro, ");
INSERT INTO apyNT_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","ynara tyripotohme Izyraeu tomo a: — Pui ẽxiry wãtasenã enehtoko kamiraramano, ãtakamahpyryme pyra exikety, erohpitopyra exikety tupito po. ");
INSERT INTO apyNT_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Mame mokyro ekarotoko oturukety Ereaza a, arotohme ahno esary poe jarãnaka, moroto pui totapasẽme exĩko ineneryme. ");
INSERT INTO apyNT_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Mame munu apoĩko Ereaza mana, tomary ke, omahxiky ke emãko mana 7me, Tapyi Kurã omõtoh winakoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Moromeĩpo mokyro pui zoko tytororo tyahkasẽme exĩko: ipihpyry te, ipunu te, munu te, zuahxiririny, zuehtoto maro tyahkasẽme exĩko oturukety ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Apupari zokonaka apoĩko oturukety mana ematohme apoto htaka, otyro hissopo amoriry maro te, kaneru hpoty zonopyhpyryme aexihpyry tahpiremy. Morohne emãko mana apoto pona pui zahkaryhtao. ");
INSERT INTO apyNT_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Mame tupõ kurikãko oturukety mana, epỹko roropa mana. Moromeĩpo omõnõko ropa mana ahno esaka ropa, yrome iirypyry onykorokara ro exĩko ikohmãtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Mokyro roropa pui zahkahpono roropa tupõ kurikãko mana, epỹko roropa mana. Yrome nuriame exikehpyra exĩko mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Mame orutua nuriame pyra exikety moro oruno, pui zahkasẽ apoĩko mana arotohme jarãnaka ahno esary poe Osa Kurã pona. Moroto tukurãkasẽme exĩko Izyraeu tõ imoihmãkõ kyryryme, moro oruno ke tuna rĩko nuriame ehtoh kurikapotohme, iirypyryme ehtoh korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Mame mokyro oruno apoihpono, pui erunory, tupõ kurikãko mana, yrome nuriame aehtoh tykorokasẽme exĩko mana xixi omõtoh pona rokene. Morohne tymerosẽme exĩko jũme moro ynyripohpyry omipona Izyraeu tõ ehtohme te, moro omipona imehnõ nonory põkõ ehtohme roropa, Izyraeu tõ maro exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","— Aorihtyã ekepyry tapose ahtao ahno a nuriame exĩko mana 7me ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ẽmepyry oseruao taropose ahtao te, 7me ẽmepyry taropose ahtao roropa ekurikãko mana moro tuna ekurikatoh ke nuriame pyra ehtohme. Yrome ekurikara mokyro ahtao ẽmepyry oseruao taropose ahtao te, 7mã pona roropa nuriame exikehpyra mana. ");
INSERT INTO apyNT_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Aorihtyã ekepyry tapose ahtao ahno a, mame ekurikara mokyro ahtao nuriame exikehpyra mana, epona tuna ekurikatoh onemara exiryke. Nuriame Ritonõpo Tapyĩ Kurã rĩko mokyro mana. Mokyro anaorihmapopyra ahtao taroposẽme exĩko mana Izyraeu tõ maro pyra ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","— Toorihse ahno ahtao tapyi tao, moro taka õmomyrykohtao nuriame exĩko matose 7me ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Oripo ahtao, tuna eny roropa totapuruhmakase ahtao nuriame exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ona po aorihtyã ekepyry tapose ahtao, totapase ahtao, tamoreme toorihse ahtao roropa ahno zehpyry tapose ahtao, zonẽtoh tapose ahtao, nuriame exĩko mokyro mana 7me ẽmepyry pona. ");
INSERT INTO apyNT_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","— Ekurikatohme nuriame pyra ehtohme ropa, oruno apoiko mokyro pui ẽxiry kamiraramã zahkatopõpyry erunory. Mokyro tyahkase ahno rypyry korokapotohme. Moro oruno tyriko oripo aka. Mame tuna kurã emako epona. ");
INSERT INTO apyNT_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Aorihtyã ekepyry tapose ahtao ahno a, imepỹ orutua, nuriame pyra exikety hissopo amoriry apoĩko, zumyhkatohme moro tuna ekurikatoh kuaka. Mame moro hissopo ke tuna emãko moro tapyi pona, imõkomory pona te, ahno pona, emero moro tapyi tao exiketõ pona. Ahno zehpyry tapose ahtao te, zonẽtopõpyry tapose ahtao moro tuna ekurikatoh tomasẽme exĩko epona imepyny a, nuriame pyra exikety a. ");
INSERT INTO apyNT_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Ẽmepyry 3mã po te, ẽmepyry 7mã po roropa, nuriame pyra exikety moro tuna emãko nuriame exikety pona. Mame 7me ẽmepyry pona mokyro nuriame pyra exĩko mana, tupõ kurikãko mana, epỹko mana, mame xixi tomõse ahtao tykorokasẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","— Yrome nuriame toehse ahno ahtao, mame ekurikara mokyro ahtao nuriame exikehpyra mana epona tuna ekurikatoh onemara exiryke. Mokyro Ritonõpo Tapyĩ Kurã nuriame tyrĩko mana. Naeroro mokyro taroposẽme exĩko mana Izyraeu tõ winoino. ");
INSERT INTO apyNT_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Sero ynyripohpyry oya xine omipona ehtoko jũme. Mame mokyro moro tuna emane nuriame pyra ehtohme, tupõ kurikãko mana. Moro tuna apohpono nuriame exĩko ro mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Emero tapose aexihpyry nuriame exikety a, nuriame exĩko; mokyro nuriame exikety apohpono nuriame exĩko roropa mana xixi omõtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Mame nuno apitorymã po Izyraeu tõ emero toytose ona tonorẽ Zim pona. Tõsesarise toh nexiase Kate po. Moroto Miriã toorihse; ekepyry tonẽse nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Moroto tuna pyra nexiase; naeroro tõximõse toto, Moeze tõ tykerekeremase Arão maro. ");
INSERT INTO apyNT_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ynara tykase toto: — Kurehxo exiry toorihse yna ahtao Ritonõpo Kuesẽkõ ẽpataka imehnõ kuekyrykõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Oty katohme Ritonõpo poetory tõ menepyase sero ona tonorẽ pona? Kuenepyatose xiaro orihtohme yna eky tõ mahro? ");
INSERT INTO apyNT_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Oty katohme yna menepyase Ejitu poe xiaro, osa xihpyry pona, tykyrysã pyra taro, wikeira tõ pyra, uwa zoko tõ pyra, romã tõ pyra? Morohne motye tuna pyra mana taro kuokurukõme! ");
INSERT INTO apyNT_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Naeroro Moeze tõ toytose Arão maro imoihmãkõ poe Tapyi Kurã omõtoh taka. Tosekumuru po typorohse toto tõmytykõ po nono pokoxi. Mame Ritonõpo saerehkatoh tõsenepose eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","— Omyxiry apoiko moro jomihpyry ẽ ẽpataka, Arão maro ahno enehpoko oximõme. Mame imoihmãkõ neneryme oturuko topuimo a, tuna tũtatohme topuimo poe. Moro sã tuna apoĩko matose topuimo poe ekarotohme ahno a aukurukõme te, okyno tõ okurume, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Naeroro Ritonõpo nyripohpyry omi poe tymyxiry tapoise Moeze a Ritonõpo ẽpataka aexihpyry. ");
INSERT INTO apyNT_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ahno imoihmãkõ tanonohpose eya Arão maro topuimo ẽpataka, mame ynara tykase Moeze: — Etatoko ke, Ritonõpo omiry omipona pyra exiketomo! Tuna tũtanohpõko matou yna a sero topuimo poe? ");
INSERT INTO apyNT_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Mame tomary tanỹse Moeze a. Topuimo totatotapase eya asakoro, tymyxiry ke, tuna tutũtase itamurume. Mame tõse ahno a, okyno tomo a, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Yrome ynara tykase Ritonõpo Moeze a, Arão maro: — Jenetupuhpyrahme sã mexitou. Yjamitunuru kurã onenetupuhpopyra mexitou Izyraeu tomo a. Morara exiryke Izyraeu tõ anaropyra exĩko matose moro nono pona ynekarory pona esarykõme. ");
INSERT INTO apyNT_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Moro toehse Meripa po, moroto Izyraeu tõ tykerekeremase Ritonõpo Tosẽkõ poko. Moroto tyjamitunuru kurã tonepose Ritonõpo a eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Morarame pata Kate poe, tõmiry aronanõ tonyohse Moeze a Etõ tuisary a ynara katohme: — Sero omi oekyry tõ poe mana, Izyraeu tõ poe. Zuaro mase yna etuarimatopõpyry poko emero. ");
INSERT INTO apyNT_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Zuaro mase yna tamuru tõ ytotopõpyry poko Ejitu pona, moroto toehse yna, tuhke jeimamyry. Yna tamuru tõ, yna roropa tyrohmanohpose Ejitu põkomo a, tyyryhmase yna eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Naeroro Ritonõpo a yna akorehmary ynanekaropoase. Yna a ekaropotopõpyry totase eya. Tynenyokyhpyry tonyohse eya yna syryhmatohme Ejitu poe. Seromaroro pata Kate po ynanase, ononory ehpiõ po. ");
INSERT INTO apyNT_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ajohpame samo, ah ynanytoxi ononory kuroko. Yna, yna eky tõ roropa osema ae rokẽ ytõko ynanase. Tupito tõ pona ytopyra exĩko ynanase, uwa tõ anarykahpyry tõ pona ytopyra. Tuna eutary tõ poe onẽpyra exĩko ynanase. Oesarykõ po yna ahtao osema konõto ae rokẽ ytõko ynanase. ");
INSERT INTO apyNT_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Yrome tozuhse Etõ tuisary a, ynara tykase: — Yna nonory rãnakuroko ytopyra matose. Irãnakuroko toytose awahtao xine etonãko sytatose. ");
INSERT INTO apyNT_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Mame ynara tykase Izyraeu tõ eya: — Osema konõto ae rokẽ ytoytõko ynanase. Tuna enyryhtao yna a yna eky tomo a roropa, otunary epehmãko ynanase. Pupu po rokẽ yna ytory se ynanase oesarykõ rãnakuroko. ");
INSERT INTO apyNT_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Yrome Etõ tuisary ynara tykase: — Arypyra. Ytopyra matose! Mame Etõ tõ tooehse soutatu tõ jamihme exiketõ maro etonase Izyraeu tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Moro sã Izyraeu tõ anaropopyra etomita tõ nexiase tosarykõ rãnakuroko. Naeroro Izyraeu tõ toytose imepỹ osema ae. ");
INSERT INTO apyNT_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Mame Izyraeu tõ emero toytose pata Kate poe ypy Hoa pona, ");
INSERT INTO apyNT_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Etõ tõ nonory ehpiõ po. Moroto ynara tykase Ritonõpo Moeze tomo a Arão maro: ");
INSERT INTO apyNT_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","— Arão omõpyra mana moro nono pona, ynekarory pona Izyraeu tomo a. Orihnõko mana ynara exiryke: tuna poko Meripa po jomiry omipona pyra mexiatose. ");
INSERT INTO apyNT_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Arão enehko, imũkuru Ereaza maro, toto onuhmapotohme ypy Hoa pona. ");
INSERT INTO apyNT_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Mame Arão zupõ apoiko, moro amurutohme Ereaza zupõme. Moroto Arão orihnõko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moeze a moro tyrise Ritonõpo nyripohpyry ae ro. Tõnuhse toto ypy Hoa pona ahno imoihmãkõ neneryme. ");
INSERT INTO apyNT_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Oturukety Arão zupõ tapoise Moeze a, moro upo amurutohme Ereaza a. Moroto Arão toorihse ypy emory po. Moromeĩpo Moeze tyhtose ropa Ereaza maro. ");
INSERT INTO apyNT_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Mame zuaro toehse imoihmãkõ ahtao Arão orihtopõpyry poko tyhnamose ynororo eya xine emero, 30me ẽmepyry ae. ");
INSERT INTO apyNT_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mame Kanaã tuisary, Arate esẽ zuaro toehse ahtao Izyraeu tõ oepyry poko Atarĩ esemary ae, toytose ynororo osetapase Izyraeu tõ maro. Tuhke pyra Izyraeu tõ tarose eya typoetoryme. ");
INSERT INTO apyNT_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Naeroro Izyraeu tõ ynara tykase Ritonõpo a: — Yna akorehmaryhtao oya mokaro poremãkatohme ipatary tõ enahkãko ynanase ipunaka. ");
INSERT INTO apyNT_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Aomirykõ totase Ritonõpo a, Izyraeu tõ takorehmase eya kananeu tõ poremãkatohme. Naeroro toto tonahkase Izyraeu tomo a ipatary tõ maro. Moroto tosehpase eya xine Horomame. ");
INSERT INTO apyNT_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Mame ypy Hoa poe Izyraeu tõ toytose osema ae, tuna Akapa winakoxi Etõ nonory ehpikuroko toytotohkõme. Yrome osema ae toytorykohtao typenekehse toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ritonõpo tykerekeremase toto a, Moeze tykerekeremase roropa eya xine, ynara tykase toto: — Oty katohme Ejitu poe tonehse yna Ritonõpo a, Moeze a roropa? Kuorihtohkõme sero ona tonorẽ po, wyi pyra ehtoh po, tuna pyra roropa ehtoh po? Typenekehse sytatose sero tonahsẽ xihpyry poko! ");
INSERT INTO apyNT_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Naeroro okoi tõ orihmatõ kõ tonehpose Ritonõpo a ahno rãnaka; tosekase toto eya xine, tuhke Izyraeu tõ toorihse toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Naeroro toytose toto Moeze a oturuse imaro, ynara tykase toto: — Iirypyryme toehse ynanase, Ritonõpo kerekeremaryke yna a, okerekeremaryke roropa yna a. Oturuko Ritonõpo a okoi tõ arotohme ropa yna winoino. Tõturuse Moeze Ritonõpo a ahno pyno ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ynara tykase Ritonõpo eya: — Okoi panõ tyriko metau risemy, wewe ixikihmahpyry pokona exixihmapoko. Mame esekatyamo a moro enepoko toto ekurãkatohme ropa. ");
INSERT INTO apyNT_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Naeroro okoi panõ tyrise Moeze a metau risemy. Toxixihmase eya wewe pokona. Mame mokaro okoi nesekatyamo a Moeze nyrihpyry okoi panõ tonese ahtao toekurãkase ropa ynaroro. ");
INSERT INTO apyNT_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Mame moro poe Izyraeu tõ toytose Opote pona nyhse. ");
INSERT INTO apyNT_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Morotoino Opote poe toytose toto patãpo Aparĩ pona, ona tonorẽ pona Moape tõ nonory poe xixi tũtatoh wino. ");
INSERT INTO apyNT_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Morotoino toytose toto jakanahmã Zerete pona. ");
INSERT INTO apyNT_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Morotoino toytose toto osesarise tuna Aranõ ehpikoxi inikahpozakoxi ona tonorẽ po amoreu tõ esary pũto (Tuna Aranõ Moape tõ nonory apiakãko mana amoreu tõ esary winoino). ");
INSERT INTO apyNT_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Morara exiryke ynara tymerose Ritonõpo Nymeropohpyry pokona etonatoh poko: “Pata Waepe, Supa nonory po, jakanahmã tõ roropa; tuna Aranõ ");
INSERT INTO apyNT_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","yhtotoh roropa jakanahmã tõ pata Ara pona, Moape nonory ehpiõ winakoxi.” ");
INSERT INTO apyNT_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Morotoino toytose toto osa pona, esety Peea, moroto ynara tykase Ritonõpo Moeze a: — Oximõme mokaro enehpoko, tuna ekarõko ase eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Naeroro Izyraeu tõ toremiase moro poko: “Eutary tomo, tuna ekaroko, soesoekaneme ehtoko, aomikãko sytatose eremiatoh ke. ");
INSERT INTO apyNT_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Eutary tahkase tuisa poenomo a, tuisa tomo a tymara ke, tymyxiry ke rahkene.” Morotoino ona tonorẽ poe toytose toto Matana pona. ");
INSERT INTO apyNT_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Morotoino Matana poe toytose toto Naarieu pona, morotoino Naarieu poe Pamote pona. ");
INSERT INTO apyNT_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Morotoino Pamote poe toytose toto jakanahmã pona, Moape nonory pona, ypy Pixika emory myhtokoxi, moro emory poe ona tonorẽ osenẽko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Mame omi aronanõ taropose Izyraeu tomo a Seõ zuruse. Ynara tykase toto eya: ");
INSERT INTO apyNT_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","— Ajohpame sã ah ynanytoxi ononory rãnakuroko. Tupito tõ poro ytopyra exĩko ynanase, uwa zoko tõ anarykatyãkõ poro ytopyra roropa ynanase. Tuna onẽpyra ynanase eutary tõ poe; osema konõto ae rokẽ ytõko ynanase oesarykõ rãnakuroko. ");
INSERT INTO apyNT_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Yrome tynonory rãnakuroko Izyraeu tõ anaropopyra Seõ nexiase. Typoetory tõ emero oximõme tyripose eya etonatohme Izyraeu tõ maro ona tonorẽ po. Toytose ynororo Jasa pona etonatohme Izyraeu tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Yrome tõsetaparykohtao tuhke amoreu tõ totapase Izyraeu tomo a. Toto esary tapoise eya xine tuna Aranõ poe tuna Japoke pona, Amõ nonory ehpiõ pona. Moroto apuru tõ nexiase, Amõ tõ nonory ehpiõme. ");
INSERT INTO apyNT_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Morara exiryke amoreu tõ patary tõ tapoise Izyraeu tomo a emero. Moro pata tõ tyrise eya xine typatarykõme, Hexipõ te, pata pisarara roropa Hexipõ zomye exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hexipõ nexiase Seõ patary, amoreu tõ tuisary patary. Osemazuhme tõsetapase ynororo nexiase moapita tuisary maro. Moape tõ nonory tapoise eya tosaryme ehtohme tuna Aranõ pona. ");
INSERT INTO apyNT_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Morara exiryke tuaro exiketõ moro poko ynara ãko mã toto: “Osehtoko Hexipõ pona, tuisa Seõ patary pona! Moro pata rĩko ropa mana, kure rokẽ Seõ patary exĩko ropa mana. ");
INSERT INTO apyNT_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Apoto tutũtase exiryke Hexipõ poe, apoto tuisa Seõ patary poe, isoutatu tõ apoto sã nexiase, pata Ara tonahkase eya xine, Moape po. Ypy tõ tonahkase, tuna Aranõ inikahpozakoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Myhẽ matose, Moape põkomo! Oneponãmarykõ, Kemo eahmananomo, typoremãkase matose! Oneponãmarykõ omi poe osoutatukõ toepase mã toto, oẽxiry tõ tokarose Seõ, amoreu tõ tuisary namotome. ");
INSERT INTO apyNT_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Yrome seromaroro Hexipõ jamitunuru tonahse; Hexipõ poe Tipõ pona, emero tonahkase. Nopa tonahse, apoto toehse Metepa pona.” ");
INSERT INTO apyNT_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Naeroro Izyraeu tõ tõsesarise amoreu tõ nonory po. ");
INSERT INTO apyNT_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moromeĩpo ahno tonyohse Moeze a pata pona, Jazea enetohme. Mame ipatarykõ tapoise eya xine, amoreu tõ tonyohse moro poe eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Morarame toeramase ropa toto tonuhtohkõme Pasã esemary ae. Mame Oke, Pasã tuisary tutũtase osetapase Izyraeu tõ maro pata Eterei po. ");
INSERT INTO apyNT_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ynara tykase Ritonõpo Moeze a: — Mokyro zuno pyra exiko. Toto tuisary ekarõko ase oya xine ipoetory tõ maro, inonory maro. Mame mokyro tyriko onyrihpyry sã Seõ, amoreu tõ tuisary a Hexipõ po. ");
INSERT INTO apyNT_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Naeroro Oke typoremãkase Izyraeu tomo a. Totapase ynororo eya xine, imũkuru tõ maro, ipoetory tõ maro porehme; epasaromepyra toh nexiase. Mame toto nonory tapoise eya xine tosarykõme. ");
INSERT INTO apyNT_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Mame Izyraeu tõ toytose osesarise ona pona, Moape nonory po, tuna Joatão poe xixi tũtatoh wino, pata Jeriko etonie, tuna moino Jeriko nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Morarame Moape tõ tuisary, Parake, Zipoa mũkuru, zuaro toehse tahtao Izyraeu tõ nyrihpyry amoreu tõ poko, ");
INSERT INTO apyNT_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","tonaroxitapãse ynororo Izyraeu tõ poko, tuhke toto exiryke. Enaromỹke Moape tõ toehse rahkene Izyraeu tõ zuno. ");
INSERT INTO apyNT_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Tõturuse Moape tõ mitianita tõ tamuximãkomo a, ynara tykase toto: — Senohne emero kuomye xine enahkãko mokaro imoihmãkomo, onahpoty enahkary samo pui orutua a. Mame moapita tõ tuisary, Parake a ");
INSERT INTO apyNT_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","omi aronanõ tonyohse Paraão, Peoa mũkuru a, enehtohme tyya. Pata Petoa po nexiase ynororo tuna Eupyrati pũto, Amawe nonory po. Ynara tykase omi aronanõ Paraão a: “Ahno imoihme tutũtase Ejitu poe, sero nono pehkãko mã toto. Seromaroro xiaro toehse mã toto osesarise yna pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ajohpame sã, osehko xiaro axiny mokaro ripotohme popyra. Ymotye jamihme mã toto. Popyra ehtoh tonehpose mokaro pona awahtao otarame mokaro poremãkapõko ase, toto aropotohme taroino. Zuaro ase: imehnõ kure tyripose ahtao oya, kure toto exĩko. Yrome popyra toto ehtoh tonehpose ahtao oya popyra ehtoh oehnõko toto pona.” ");
INSERT INTO apyNT_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Naeroro Moape tõ tamuximãkõ toytose mitianita tamuximãkõ maro. Tineru tarose eya xine popyra Izyraeu tõ ripotohtamitume. Toeporehkase toto ahtao Paraão esaka, Parake omiry tokarose eya xine Paraão a. ");
INSERT INTO apyNT_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Mame ynara tykase Paraão eya xine: — Taro oẽmehtoko, kokoro Ritonõpo a ezuhtoh ekarõko ase oya xine. Naeroro mokaro Moape tõ tamuximãkõ moroto tõmehse Paraão maro. ");
INSERT INTO apyNT_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Mame Ritonõpo tooehse Paraão a. Ynara tykase: — Onokãkõ mokaro amaro? ");
INSERT INTO apyNT_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Paraão a tozuhse, ynara tykase: — Parake a, moapita tõ tuisary, tõmiry tonehpose ya ynara kase: ");
INSERT INTO apyNT_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Ahno tutũtase Ejitu poe, sero nono pehkãko mã toto. Jaropory se mana, popyra mokaro ripotohme. Moro tyrise ahtao otarame toto poremãkãko mana, toto aropotohme taroino. ");
INSERT INTO apyNT_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ynara tykase Ritonõpo Paraão a: — Mokaro maro ytopyra exiko, popyra Izyraeu tõ onyripopyra exiko roropa, ahno kurãme tyripose toto exiryke ya. ");
INSERT INTO apyNT_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Yrokokoro pakeimo Paraão towõse, ynara tykase tamuximãkomo a, Parake nenyohtyamo a: — Ytotoko ropa oesaka xine. Amaro xine jaropopyra Ritonõpo mana. ");
INSERT INTO apyNT_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Naeroro toytose ropa toto, tõturuse toto Parake maro. Ynara tykase: — Paraão toepyry se pyra nexino yna maro. ");
INSERT INTO apyNT_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Imehnõ tuisame exiketõ tonyohse ropa Parake a, tuhkehxo, tuisamehxo exiketõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Toytose toto oturuse Paraão maro, ynara tykase toto: — Ywy Parake, Zipoa mũkuru ynara ãko oya: Axĩ ke osehko xiaro! ");
INSERT INTO apyNT_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Epehpyry ekarõko ase oya itamurume, emero ise oehtoh ekarõko ase oya. Ajohpame sã osehko, mokaro ahno popyra ripotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ynara tykase Paraão: — Uuru emero ekaroryhtao Parake a ya, parata maro emero tytapyĩ konõto tao aexityamo, Ritonõpo omiry onytyoromasaromepyra ase. Aomiry onymotyẽkara ase, Ritonõpo nyripohpyry omipona pyra jexiryino. ");
INSERT INTO apyNT_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Yrome seromaroro taro oẽmehtoko zuaro jehtohme. Otarame Ritonõpo oturutoh nae ro mana tõturutohme ya. ");
INSERT INTO apyNT_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Mame koko tooehse Ritonõpo Paraão a, ynara tykase: — Mokaro toehse exiryke okohmase tymaro xine oytotohme, atakimako toto maro oytotohme. Yrome ynyripory rokẽ tyriko. ");
INSERT INTO apyNT_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Naeroro tõmehse ahtao Paraão towõse, tãtakimase, tykyryry tõ tyrise jumẽtu nohpo pona, toytose moape tamuximãkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Tohne toehse Ritonõpo, toytose Paraão exiryke. Jumẽtu po typorohse Paraão nexiase toytoryme; imaro ipoetory tõ asakoro toytose roropa. Mõtoino rokẽ Ritonõpo nenyokyhpyry tyhtose osema taka, ytopyra aehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Mokyro, Ritonõpo nenyokyhpyry tomahpõke, tapema ke nexiase. Mokyro eneryhtao jumẽtu a osema turumekase eya, tãtapiakase ona pona toytotohme. Naeroro toky typipohse Paraão a aeramatohme ropa tosemataka. ");
INSERT INTO apyNT_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Mame mya ropa Ritonõpo nenyokyhpyry toytose, toexikihmase osema tao. Moroto nexiase tupito uwa arykasẽ nexiase osetatoro. Moro rãnakuroko osema pitiko nexiase, osetatoro apuru tomo topu tõ risemy. ");
INSERT INTO apyNT_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Moroto Ritonõpo nenyokyhpyry tonese ahtao jumẽtu a torõme toehse ynororo apuru pokona, Paraão axiry tysokorohmapose eya. Naeroro toky jumẽtu typipohse ropa eya. ");
INSERT INTO apyNT_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Moromeĩpo Ritonõpo nenyokyhpyry toytose mya pitiko eraximase osema pitiko ehtoh pona. Moroto osema onurumekasaromepyra nexiase apotunuru wino, ipozery wino, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ritonõpo nenyokyhpyry tonese ahtao jumẽtu a, põme toehse ynororo nono po. Paraão tyekĩtapãse yronymyryme, toky typitypipohse eya myxi ke. ");
INSERT INTO apyNT_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Mame Ritonõpo poe jumẽtu tomitapitose, ynara tykase Paraão a: — Oty yrino yzehno oehtohme? Oty katohme kypipohno oseruao? ");
INSERT INTO apyNT_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Tozuhse ynororo eya, ynara tykase: — Ajoajohpe toehse oexiryke, jomiry omipona pyra mase. Tytapemake jahtao, kueatãkary seromaroro!, tykase Paraão. ");
INSERT INTO apyNT_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Naeroro ynara tykase jumẽtu Paraão a: — Oekyme ase. Moino ro õmiry omipona ase topekahse jehtopõpyry poe. Kuenease õmiry omipona pyra, sero samo? — Arypyra, tykase ynororo. ");
INSERT INTO apyNT_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Mame Ritonõpo poe, Paraão a Ritonõpo nenyokyhpyry tonese moroto osema tao tapema ke tomahpõke. Paraão typorohse tosekumuru po nono pona, tõmyty po nono pokoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ynara tykase Ritonõpo nenyokyhpyry eya: — Oty katohme oeky jumẽtu mypipohno oseruao? Oehno oya oepekara samo aaropotohme ropa, onyriry zae pyra exiryke ya. ");
INSERT INTO apyNT_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Yrome oeky, jumẽtu jeneno; toeramase ynororo ywinoino oseruao. Eramara tokurehse ynororo ahtao, pake kueatãkary, ynororo rokẽ typynanohse exiry isene ro aehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Mame ynara tykase Paraão Ritonõpo nenyokyhpyry a: — Iirypyryme toehse ywy. Zuaro pyra exiase moroto osema tao oehtopõpyry poko jetypohkapotohme. Yrome seromaroro jytory se pyra awahtao morotona, eramãko ropa ase tapyi taka ropa. ");
INSERT INTO apyNT_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ynara tykase Ritonõpo nenyokyhpyry: — Ytoko moxiã maro; yrome oturuko ynekarory ae rokene. Naeroro Paraão toytose mokaro tamuximãkõ, Parake nenyohtyã maro. ");
INSERT INTO apyNT_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Mame Parake zuaro toehse ahtao Paraão oepyry poko toytose ynororo oseporyse imaro pata Ara pona, tuna Aranõ ehpikoxi, Moape nonory ehpio po. ");
INSERT INTO apyNT_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ynara tõturupose Parake: — Oty katohme ooepyry se pyra mexiase okohmaryhtao ya apitoryme? Kure oepehmasaromepyra jexiry menetuputyase otarame? ");
INSERT INTO apyNT_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ynara tykase Paraão eya: — Yrome taro ase seromaroro amaro rahkene. Yrome oturusaromepyra ase jamoreme; Ritonõpo nekarory ke rokẽ ourũko ase, onymotyẽkara ase. ");
INSERT INTO apyNT_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Naeroro toytose Paraão, Parake maro pata Huzote pona, ");
INSERT INTO apyNT_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","moroto Parake a tynekarory tõ tyahkase pui orutua tomo te, kaneru tomo roropa. Mame tõsẽ zokonaka tokarose eya Paraão a, tymaro tamuximãkomo a roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Yrokokoro tõmehse ahtao Paraão tarose Parake a Pamote-Paau pona. Moroto toto ahtao Izyraeu tõ zokonaka tonese eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Mame ynara tykase Paraão Parake a: — Apoto apõ 7me tyriko taro, pui mũkuru tõ enehko 7me, 7me kaneru tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Moro tyrise Parake a, Paraão omiry omipona. Mame toiro pui mũkuru tyahkase eya xine toiro kaneru maro apoto apõ po emero. ");
INSERT INTO apyNT_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ynara tykase Paraão, Parake a: — Taro exiko onyahkahpyry pũto, morotona ytõko ase. Otarame Ritonõpo oehnõko ya oturuse. Mame inyripohpyry emero ekarõko ase oya. Naeroro Paraão tõnuhse toiroro somokyhmã emory pona. ");
INSERT INTO apyNT_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Moroto Ritonõpo tõseporyse imaro. Ynara tykase Paraão: — Apoto apõ 7me yrino. Pui mũkuru tõ 7me tyahkase ya 7me kaneru tõ maro moro apoto apõ tõ po. ");
INSERT INTO apyNT_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Mame omi tokarose Ritonõpo a Paraão a ekarotohme Parake a. Mame tonyohse ropa ynororo eya Parake zurutohme. ");
INSERT INTO apyNT_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Naeroro toytose ynororo Parake a. Tynyahkatopõpyry pũto ro nexiase Moape tamuximãkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Mame ynara tykase Paraão Ritonõpo poe: “Parake, Moape tõ tuisary, jenepyase xiaro, Xiria poe, ypy tõ poe xixi tũtatoh wino. ‘Osehko, — tykase ynororo ya, — ajohpãme sã popyra Izyraeu tõ tyripoko! Popyra ehtoh enehpoko Izyraeu tõ pona!’ ");
INSERT INTO apyNT_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Mokaro popyra onyriposaromepyra ase, popyra toto onyripyra Ritonõpo ahtao. Toto onuãnohposaromepyra ase, toto wãnopyry se pyra Ritonõpo ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Topuimo emory poe, ypy emory poe Izyraeu tõ enẽko ase. Oxiekyryme mã toto toiroro samo. Imehnõ ahno motye kure ehtoh tokarose Ritonõpo a, eya xine. Moro waro mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Jako pakomotyã putoh katoh sã mã toto; tuhke mã toto, ikuhpỹme. Jorikyry se ase mokaro Ritonõpo poetory tõ samo. Jorikyry se ase torẽtyke pyra, ajohpe pyra exiketõ samo.” ");
INSERT INTO apyNT_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Mame ynara tykase Parake Paraão a: — Otara kyrino? Kuenehpoase xiaro popyra jepetõkara tyripotohme repe. Yrome kure rokẽ toto ripõko mase. ");
INSERT INTO apyNT_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ynara tykase Paraão: — Ritonõpo nurutopõpyry rokẽ poko oturũko ase. ");
INSERT INTO apyNT_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Mame ynara tykase Parake Paraão a: — Eropa imepỹ pona, moro poe Izyraeu tõ enẽko mase zokonaka rokene, emero pyra. Ajohpame sã popyra mokaro tyripoko moro poe. ");
INSERT INTO apyNT_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Tarose ynororo Parake a ona Zofim pona, ypy Pixika emory pona. Moroto apoto apõ tõ tyrise eya 7me. Epona xine tynekarory tyahkase eya toiro pui mũkuru toiro kaneru maro emero apoto apõ po. ");
INSERT INTO apyNT_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Mame ynara tykase Paraão Parake a: — Taro exiko onekarohpyry pũto. Morotona ytõko ase oseporyse Ritonõpo, Jesẽ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Mame Ritonõpo tõseporyse Paraão maro. Omi tokarose eya Parake zurutohme. Mame tonyohse ropa ynororo Parake a omi ekarotohme eya. ");
INSERT INTO apyNT_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Naeroro tooehse ropa Paraão, tõseporyse Parake maro tynyahkahpyry pũto, Moape tõ tamuximãkõ maro. Parake a tõturupose eya Ritonõpo nekarohpyry poko. ");
INSERT INTO apyNT_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Sero omi tokarose Paraão a Parake netaryme: “Osehko Parake, Zipoa mũkuru, etako ke ynekarory oya. ");
INSERT INTO apyNT_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ahno sã pyra Ritonõpo mana, ajohpe exiketõ sã pyra; tõsenetupuhtoh onytyoromara mana. Tõmiry totapose ahtao Ritonõpo a, moro rĩko mana; ‘Tyrĩko ase,’ tykase ahtao Ritonõpo a tyrĩko mã rahkene. ");
INSERT INTO apyNT_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Tyripose ywy eya kure rokẽ tyripotohme; kure rokẽ tyripose ahtao eya, moro onytyoromasaromepyra ase. ");
INSERT INTO apyNT_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Enẽko ase imeĩpo Izyraeu tõ ehtopo, toto onyporemãkara exĩko imehnõ mana, toto onutuarimapopyra exĩko roropa mã toto. Ritonõpo, Izyraeu tõ Esẽ, toto maro mana, kohtãko mã toto Ritonõpo, Tutuisarykõme exiry poko. ");
INSERT INTO apyNT_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Tonehse toh nexiase Ritonõpo a Ejitu poe. Jamihmehxo mã ynororo pui orutua itu htaõ samo. ");
INSERT INTO apyNT_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Pyaxi tomo a, popyra toto ripory kukuruhtao toiparo rokẽ moro kuhnõko mã toto, Izyraeu tõ onyryhmara mã toto. Seromaroro ynara ãko mã toto emero Izyraeu tõ poko: ‘Enetoko ke Ritonõpo nyrihpyry!’ ");
INSERT INTO apyNT_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Izyraeu owõnõko mana reão nohpory samo, reão sã roropa oseremara mana tykarimory onõpyra ro tahtao, imunuru onẽpyra ahtao roropa.” ");
INSERT INTO apyNT_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Mame ynara tykase Parake Paraão a: — Mokaro Izyraeu tõ popyra onyriposaromepyra awahtao, kure toto onyripopyra exiko roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ynara tykase Paraão eya: — Morara exiryke moro sã tykase ywy oya, Ritonõpo nekarory rokẽ ekarõko ase oya, tykase ywy. ");
INSERT INTO apyNT_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Mame ynara tykase Parake Paraão a: — Ajohpame sã ymaro eropa imepỹ pona. Otarame moro poe Ritonõpo zamaro exĩko mana popyra mokaro tyripory oya. ");
INSERT INTO apyNT_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Naeroro Paraão tarose Parake a ypy Peoa emory pona ona enetohme mya. ");
INSERT INTO apyNT_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ynara tykase Paraão eya: — Apoto apõ 7me tyriko, 7me pui mũkuru tõ zahkatohme 7me kaneru tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Moro tyrise Parake a Paraão omipona. 7me pui mũkuru tõ tyahkase eya 7me kaneru tõ maro moro apoto apõ tõ po. ");
INSERT INTO apyNT_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Morarame kure rokẽ Izyraeu tõ riry se Ritonõpo ehtoh tonetupuhse Paraão a. Naeroro mya ytopyra nexiase enetupuhpotoh eraximase Ritonõpo poe. Toeramase rokẽ ynororo ona amerehmã wino rokene, ");
INSERT INTO apyNT_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Izyraeu tõ enese. Tõsesarise, oxiekyrymãkõ oximõme, tosarykõ po. Mame Ritonõpo Zuzenu poe tõturupitose Paraão: ");
INSERT INTO apyNT_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Ynara tykase ynororo Ritonõpo poe: “Sero nase Paraão nekarory, Peoa mũkuru, ynekarory sero jenuru kure rokẽ osenuhmaryhtao, ");
INSERT INTO apyNT_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","kure rokẽ Ritonõpo omiry etãko roropa. Jesekumuru po typorohse ywy, jenuru tõ onetõ sã, Ritonõpo a tyripose, Jamihmehxo Exikety enepotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Enekure potu oesarykomo, Izyraeu tomo! Enekure atapyĩkomo! ");
INSERT INTO apyNT_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Airiki panõ tõ sã mã toto, tarykase exiketõ samo atakenaka, tupito po sã tuna ehpio, tykyrysã samo tarykase ahtao Ritonõpo Kuesẽkomo a, apupari tõ samo ahtãko tuna tõ ehpio. ");
INSERT INTO apyNT_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Konopo itamurume nae Izyraeu tõ exĩko aukurukõme mana te, otyro puhturu ehxikatohme tarykase ahtao eya xine. Ituisarykõ jamihmehxo exĩko mana, Akake motye, tuisamehxo exĩko roropa mana tuisa tõ rãnao. ");
INSERT INTO apyNT_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Izyraeu tõ tonehse Ritonõpo a Ejitu poe epetõkara poremãkapõko mana pui orutua itu htaõ samo. Topetõkara enahkãko mã toto, Toto zehpyry akuakuhmõko mã toto, ipyrekõ tahtahkãko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Reão jamihmã sã Izyraeu mana: tynyhse ynororo ahtao ipakary zuno mã toto. Kure rokẽ Izyraeu tõ ripory se exiketõ, kure rokẽ exĩko mã toto. Popyra Izyraeu tõ riponanõ, popyra tyriposẽme exĩko mã toto.” ");
INSERT INTO apyNT_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Mame Parake tyekĩtapãse Paraão poko. Tomary totapase eya zakorõ ke zehno toexiryke, ynara tykase ynororo: — Kykohmase ooehtohme popyra jepetõkara ripotohme. Yrome kure rokẽ toto tyripose oya oseruao. ");
INSERT INTO apyNT_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Seromaroro ytoko ropa atapyĩ taka. Oepehmary se exiase repe. Yrome Ritonõpo, Oesẽ oepehmapopyra mana. ");
INSERT INTO apyNT_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Ynara tykase Paraão: — Õmiry aronanomo a oturuase, ynara ase eya xine, ");
INSERT INTO apyNT_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","parata ke topehmase jahtao oya, uuru maro emero atapyĩ tao exikety, Ritonõpo, Jesẽ nyripohpyry omipona pyra ehsaromepyra ase. Mokaro zuruase: jamoreme emero rokẽ onyrisaromepyra ase, Ritonõpo omi poe rokẽ oturũko ase. ");
INSERT INTO apyNT_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ynara tykase Paraão Parake a: — Seromaroro ytõko ropa ase wekyry tomo a; yrome osemazuhme ekarory se hano Izyraeu tõ nyriry poko opoetory tomo a imeĩpo. ");
INSERT INTO apyNT_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Mame ynara tykase ynororo imeĩpo ehtoh poko: “Sero nase Paraão otururu, Peoa mũkuru, ynekarohpyry sero jenuru kure osenuhmaryhtao, ");
INSERT INTO apyNT_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","kure rokẽ Ritonõpo omiry etaryhtao, tuaro ehtoh apoitohme Imehxo Exikety wino. Jesekumuru po typorohse ywy, jenuru tõ onetõ sã Ritonõpo a tonepose ya, Jamihmehxo Exikety. ");
INSERT INTO apyNT_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Imeĩpo ehtoh enẽko ase, Izyraeu tõ enẽko. Tuisa konõto, xirikuato saeremehxo exikety sã exĩko mana mokaro wino. Tonesã samo oehnõko mana Izyraeu tõ poe. Moape tõ tuisamãkõ poremãkapõko mana. Mokaro ahno epyrypaketõ enahkapõko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Izyraeu tõ epetõkara poremãkãko mana, etomita tomo. Mokaro nonory apoĩko mana Izyraeu tõ nonoryme ehtohme. Tyjamitunuru enepõko Izyraeu tõ mana. ");
INSERT INTO apyNT_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Jako pakomotyã wino, orẽpyra exikety exĩko mana; pata põkõ enahkapõko mana.” ");
INSERT INTO apyNT_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Mame moro enepotoh ae amarekita tõ tonese Paraão a, naeroro ynara tykase: “Amareke tõ imehnõ motye orẽpyra toh nexiase repe. Yrome etyhpyryme tonahkasẽme exĩko mã toto jũme.” ");
INSERT INTO apyNT_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Mame enepotoh ae keneu tõ tonese Paraão a, ynara tykase ynororo: “Oesarykõ jamihme mana, omyny ewomahpyry sã topu konõto ao. ");
INSERT INTO apyNT_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Yrome tonahkasẽme exĩko matose tarose awahtao xine axirio tomo a typoetory tõme.” ");
INSERT INTO apyNT_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ynara tykase roropa Paraão: “Onokãkõ mokaro ahno oximõnõko inikahpozakoxi? ");
INSERT INTO apyNT_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Xipere poe epetõkara oehnõko mã toto tywapukõ ae. Axirio tõ poremãkapõko mã toto, Hepea tõ maro. Yrome imeĩpo tonahkasẽme exĩko mã toto, jumãme.” ");
INSERT INTO apyNT_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Moromeĩpo tãtakimase ropa Paraão toytotohme tytapyĩ taka ropa. Parake roropa toytose ropa. ");
INSERT INTO apyNT_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Mame Izyraeu tõ tehme ahtao jakanahmã Akaxia tõ po, moapita nohpory tõ poko toehpitose Izyraeu tõ orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Oseahmatoh tonõ pona toahmase toto mokaro nohpo tomo a, tynekarory tõ tyahkase eya xine tyneponãmarykõ eahmatohme. Izyraeu tõ tõtuhse toto maro, toto neponãmarykõ toahmase roropa eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Moro saaro Izyraeu tõ tõximõse mokaro maro tyneponãmarykõ Paau-Peoa eahmary poko, morara exiryke tohne toehse Ritonõpo toto poko. ");
INSERT INTO apyNT_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ynara tykase ynororo Moeze a: — Oximõme Izyraeu tõ tuisary tõ enehpoko, jomi poe toto etapatohme jẽpataka saereme ahtao. Moro tyrise ahtao oya xine, mokaro zehno jehtoh mynyhpãnõko ropa mana. ");
INSERT INTO apyNT_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ynara tykase Moeze tuisa tomo a: — Amarokõ ytotoko emero, oekyry tõ etapatohme, tyneponãmarykõ Paau-Peoa eahmase aytotyamo. ");
INSERT INTO apyNT_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Imoihmãkõ maro Moeze xitãko nexiase Ritonõpo Tapyĩ omõtoh ẽpataka. Mame nohpo mitianita tonehse Izyraeume exikety a tytapyĩ taka Moeze tõ neneryme. ");
INSERT INTO apyNT_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Moro eneryhtao Pineia a, Ereaza mũkuru, Arão pary, towõse ynororo, tutũtase oximõtoh poe. Warata tapoise eya, ");
INSERT INTO apyNT_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","mokyro orutua tokahmase eya, tomõse itapyĩ taka, mokaro tuose eya warata ke zuakuru tõ pona, orutua, nohpo maro. Moro ke tyrohsẽ tymynyhpãkapose Izyraeu tõ rãnao. ");
INSERT INTO apyNT_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Moro tyrohsẽ ke 24 miume ahno toorihse nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Mame ynara tykase Ritonõpo, Izyraeu tõ Esẽ Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","— Pineia nyrihpyry ke Izyraeu tõ zehno jehtoh tymynyhpãse. Ysamo Pineia mana: imehnõ neponãmary eahmary poko se pyra mana ipunaka. Jeahmary se rokẽ mana. Pineia nyrihpyry pokoino Izyraeu tõ onenahkara exiase toto zehno jehtoh ke. ");
INSERT INTO apyNT_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Naeroro kaxiko eya, jomiry etapõko ase eya, imaro osepeme ase. ");
INSERT INTO apyNT_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ynoro, ipoenõ maro, ipakomotyã maro, jũme oturuketõme exĩko mã toto, imehnõ neponãmarykõ oneahmapopyra aexiryke Izyraeu tomo a, ywy ro rokẽ eahmatohme eya xine. Moro ke mokaro rypyry tykorokapose eya. ");
INSERT INTO apyNT_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Mokyro esety, totapase aexihpyry mitianita maro Ziniri nexiase, Saru mũkuru, tamuxime exikety Ximeão ekyryme. ");
INSERT INTO apyNT_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Mokyro nohpo mitianita, tuose aexihpyry esety Koxipi nexiase, Zua ẽxiry. Tuisame Zua nexiase mitianita tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","— Oetonatatoko mitianita tõ maro toto etapatohme. ");
INSERT INTO apyNT_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Popyra ehtoh tonehse eya xine opona xine, oenekunopyrykõke aarorykohtao tyneponãmarykõ eahmatohme Peoa po. Tonekunohse roropa mexiatose Koxipi poko, mitianita tuisary ẽxiry. Tuose ynororo nexiase tyrohsẽ toehse ahtao, moroto ypy Peoa po. ");
INSERT INTO apyNT_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Moromeĩpo, tyrohsẽ tymynyhpãse ahtao, ynara tykase Ritonõpo Moeze tomo a, Ereaza maro, oturukety Arão mũkuhpyry: ");
INSERT INTO apyNT_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","— Izyraeu tõ orutua kõ ikuhtoko emero 20me jeimamyry nae exiketomo, emero tapyi taõkomo, emero tõsetapary waro exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","4","Naeroro Ritonõpo omiry omipona toehse Moeze tomo Ereaza maro, oximõme orutua kõ tonehpose eya xine soutatume exiketomo. Tõximõse toto ona Moape po, tuna Joatão ehpiõ po, pata Jeriko etonie, tuna Joatão moino Jeriko nexiase. Ynara toh nexiase Izyraeu tomo, Ejitu poe aepyhpyamo: ");
INSERT INTO apyNT_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Rupẽ tõ oxiekyrymãkomo (Rupẽ osemazuhme aenuruhpyryme nexiase Jako mũkurume): Ipoenõ nexiase Enoke te, Paru te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Ezerõ te, Karami, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Mokaro 43.730me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Paru poe tonuruse Eriape, ");
INSERT INTO apyNT_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","imũkuru tõ maro: Nemueu te, Tatã te, Apirão (Tatã, Apirão maro tymenekase ahno a tuisame toto ehtohme. Yrome toeramase toto Moeze tõ omipona pyra Arão maro. Osepeme toh nexiase Kora maro, Ritonõpo omipona pyra. ");
INSERT INTO apyNT_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Mame nono toẽtakase toto enahkatohme. Toorihse nexiase Kora tõ maro. Mame apoto a 250mãkõ tyahkase nexiase. Moro toehse imehnõ enaroximatohme. ");
INSERT INTO apyNT_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Yrome Kora mũkuru tõ orihpyra toh nexiase.) ");
INSERT INTO apyNT_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ximeão ekyry tomo: Nemueu tomo te, Jamĩ tomo te, Jakĩ tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zera tomo te, Sauu tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Mokaro 22.200me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Kate ekyry tomo: Zepõ tomo te, Haki tomo te, Suni tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozini tomo te, Eri tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arote tomo te, Areri tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Mokaro 40.500me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","21","Juta ekyry tomo: Sera tomo te, Pereze tomo te, Zera tomo te, Ezerõ tomo te, Hamuu tomo, enara. (Juta mũkuru tõ asakoro toorihse toh nexiase Kanaã po, Ere te, Onã, enara.) ");
INSERT INTO apyNT_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Juta tõ poe 76.500me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isakaa ekyry tomo: Tora tomo te, Puwa tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jasupe tomo te, Xinorõ tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Mokaro poe 64.300me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zepurõ ekyry tomo: Serete tomo te, Erõ tomo te, Jareeu tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Mokaro poe 60.500me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Manase ekyry tomo, Eparaĩ ekyry tõ maro, Joze mũkurume mokaro toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manase ekyry tomo: Makia, Manase mũkuru, Kireate zumy nexiase. Kireate poe: ");
INSERT INTO apyNT_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Iezea tomo te, Hereke tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Axirieu tomo te, Xikẽ tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semita tomo te, Hepea tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zeropeate, Hepea mũkuru tõxike rokẽ nexiase tumũkue pyra. Zeropeate ẽxiry tõ nexiase: Makara, Noa, Hokara, Miuka, Tiriza, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Mokaro poe 52.700me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Eparaĩ ekyry tomo: Sutera tomo te, Pekea tomo te, Taã tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Erã tomo; Sutera mũkurume Erã nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Mokaro poe 32.500me orutua kõ nexiase. Mokaro Joze pakomotyãme toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Pẽjamĩ ekyry tomo: Pera tomo te, Asapeu tomo te, Airão tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Supã tomo te, Hupã tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Arate tomo te, Naamã tomo, enara. Arate, Naamã roropa Pera pakomotyãme nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Mokaro poe 45.600me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Tã ekyry tomo: Suão tõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Mokaro wino 64.400me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Asea ekyry tomo: Imina tomo te, Ixiwi tomo te, Peria tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Hepea tomo te, Maukieu tomo, enara. Hepea, Maukieu roropa Peria mũkurume toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asea ẽxiry esety Sera nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Mokaro poe 53.400me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Napatari ekyry tomo: Jazeeu tomo te, Kuni tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezea tomo te, Xirẽ tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Mokaro poe 45.400me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Atapona Izyraeu tomo 601.730me orutua kõ nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","— Nono apiakako Izyraeu tõ esaryme ehtohme. Tuhkehxo Izyraeu tõ ahtao oxiekyryme, nono zumohxo ekaroko eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","56","Nono tapiakase ahtao imenekatoh ke nono ekamoko oxiekyry mãkõ nonoryme ehtohme; tuhkehxo oxiekyryme exiketomo a nono zumohxo ekaroko; tuhke hkopyra oxiekyryme exiketomo a nono zumo hkopyra ekaroko. ");
INSERT INTO apyNT_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Rewi ekyry tõ ynara kynexine: Jeresõ tomo te, Koate tomo te, Merari tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ripani tomo te, Eperõ tomo te, Mari tomo te, Muxi tomo te, Kora tomo, enara. Koate toemũkuase Anarãome. ");
INSERT INTO apyNT_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Anarão pytyme Jokepete nexiase, Rewi ẽxiry; tonuruse ynororo Ejitu po. Anarão maro Jokepete toemũkuase asakoro: Arão, Moeze maro. Tonuruse toiro ẽxiry roropa, esety Miriã. ");
INSERT INTO apyNT_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Arão toemũkuase asakoropane: Natape te, Apiu te, Ereaza te, Itamaa, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Yrome Natape, Apiu maro toorihse toh nexiase azahkuru toehse toto ahtao, apoto tyorõ tokarose ahtao eya xine tynekaroryme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Rewita tõ tukuhse nexiase 23.000me orutua kõ rokene, toiro nuno motye exiketomo. Imehnõ Izyraeu tõ maro pyra tukuhse toh nexiase nono anapoipyra rewita tõ exiryke tynonorykõme, Izyraeu po. ");
INSERT INTO apyNT_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Mokaro oxiekyry tõ emero tukuhse toh nexiase Moeze tomo a, oturukety Ereaza maro, Izyraeu tõ tukuhse ahtao ona Moape po tuna Joatão ehpiõ, pata Jeriko etonie. Tuna Joatão moino Jeriko nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Mokaro maro pake tukuhse aexityã pyra nexiase, Moeze tomo a Arão maro, apitoryme ona tonorẽ Xinai po. ");
INSERT INTO apyNT_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ritonõpo omihpyry ae ro: Orihnõko mã toto emero porehme ona tonorẽ po, katopõpyry ae, toorihse toh nexiase. Karepe, Jepone mũkuru te, Jozue, Num mũkuru maro rokẽ orihpyra toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Manase ekyry tõ maro nohpo tõ atakorõmãkõ omame nae nexiase: Makara, Noa, Hokara, Miuka, Tiriza, enara. Jũkõ Zeropeate nexiase, Hepea mũkuru, Kireate pary, Makia pary mũkuru, Manase pary, Joze mũkurume Manase kynexine. ");
INSERT INTO apyNT_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Toytose mokaro nohpo tõ oturuse Moeze maro, Ereaza maro tamuximãkõ maro Ritonõpo Tapyĩ omõtoh tao. Ynara tykase toto: ");
INSERT INTO apyNT_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","— Yna zumy toorihse ona tonorẽ po tumũkue pyra orutuame. Kora maro pyra nexiase, Ritonõpo omipona pyra exikety maro pyra, yrome tamoreme toorihse ynororo tyyrypyry emetakame. ");
INSERT INTO apyNT_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Yna zumy tuenikehse ahtao Izyraeu tõ rãnao, tumũkue pyra exiryke orutuame zae pyra exiry. Nono ekaroko yna a papa ekyry tõ maro, yna esaryme. ");
INSERT INTO apyNT_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mokaro omiry tarose Moeze a Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Mame ynara tykase Ritonõpo: ");
INSERT INTO apyNT_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","— Zeropeate ẽxiry tõ nekaropohpyry zae mana. Nono ekaroko eya xine esarykõme jũkõ ekyry tõ pũto. Mame jũkõ nonory tokarosẽme exĩko mokaro nohpo tõ esaryme. ");
INSERT INTO apyNT_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Izyraeu tõ zuruko: orutua toorihse ahtao tumũkue pyra orutuame, inonory tokarosẽme exĩko ẽxihpyry a. ");
INSERT INTO apyNT_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Tõxike pyra ynororo ahtao inonory tokarosẽme exĩko zakorõ tomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Takorõke pyra ahtao inonory tokarosẽme exĩko jumy akorõ tomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Mame jumy takorõke pyra ahtao inonory tokarosẽme exĩko jekyry ameke pyra exikety a inonoryme ehtohme. Izyraeu tomo a morara tyripoko zae ehtohme, ywy, Ritonõpo nyripohpyry ae ro oya, Moeze. ");
INSERT INTO apyNT_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Mame ynara tykase Ritonõpo Moeze a: — Onuhko sero ypy Aparĩ pona moro nono enetohme, ynekarory Izyraeu tomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Moromeĩpo, moro nono tonese ahtao oya, orihnõko mase orui, Arão orihtopõpyry saaro, ");
INSERT INTO apyNT_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","jomiry omipona pyra toehse oexirykõke asakoro ro moroto ona Zim po. Ykerekeremaryhtao imoihmãkomo a Meripa po yjamitunuru kurã enetuputyry se pyra mexiatose mokaro ẽpataka. (Meripa tuna enatyryme mana Kate po, ona tonore Zim po.) ");
INSERT INTO apyNT_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mame ynara tykase Moeze: ");
INSERT INTO apyNT_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","— Ritonõpo yna Esemy, opoe isene ynanase emero, onoky ymyakãme exĩko nae, mokaro, opoetory tõ aroneme ");
INSERT INTO apyNT_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","toto tuisaryme atatapoiry poko, kaneru sã pyra toto ehtohme tosẽke pyra toto ahtao? ");
INSERT INTO apyNT_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Ynara tykase Ritonõpo Moeze a: — Jozue ikohmako, Num mũkuru, orutua emese kure exiketyme mã ynororo, oemary tõ tyriko epona. ");
INSERT INTO apyNT_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Mokyro xikihme tyriko oturukety Ereaza ẽpataka, imoihmãkõ ẽpataka roropa; omyakãme mokyro ekaroko toto neneryme. ");
INSERT INTO apyNT_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Tuisame oehtoh zokonaka ekaroko eya, aomiry omipona Izyraeu tõ ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Oturukety Ereaza omiry etãko mana ise jehtoh waro ehtohme. Ereaza ise jehtoh waro exĩko mana Urim eneryke eya Tumim maro. Moro ke Jozue amorepãko mana Izyraeu tõ maro ise jehtoh ritohme eya xine emero. ");
INSERT INTO apyNT_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mame Ritonõpo nyripohpyry tyrise Moeze a. Jozue tonehse eya imoihmãkõ ẽpataka, Ereaza ẽpataka roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Mame Ritonõpo omi poe tomary tõ tyrise eya Jozue zupuhpyry pona. Moro ke Moeze myakãme Jozue toehse. ");
INSERT INTO apyNT_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Ynara tykase Ritonõpo, Izyraeu tõ Esẽ Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","— Ynara tyripoko Izyraeu tomo a: kokoro rokẽ inekarory tõ enehtohme ya, tõsemy, tonahsẽ maro zahkatohme typoxine exiketomo, yzamaro exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","— Ynara enehpõko mase eya xine tõsẽme, toto nekaroryme kokoro rokene, jũme: kaneru mũkuru tõ asakoro, toiro jeimamyry exiketomo, atapuropyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Toiro mokyro tyahkasẽme exĩko pakeimo te, zakorõ tyahkasẽme exĩko kokonie pukuro. ");
INSERT INTO apyNT_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Kaneru mũkuru maro tiriiku kurã toiro kirume ekarõko matose otoxie azeite toiro riturumã maro. ");
INSERT INTO apyNT_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Moro onekarory zahkãko matose tytororo, kokoro rokene. Moro tokarose apitoryme ypy Xinai po. Tonahsẽme moro onekarory mana, typoxine mana Ritonõpo Oesẽkomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Kaneru mũkuru maro uwa eukuru jehnahpyry, toiro riturume ekarõko matose. Moro eukuru ikuãnõko matose Osa Kurã pona onekarorykõme Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Kokonie pukuro zakorõ kaneru mũkuru tyahkasẽme exĩko tiriiku maro toiro kirume, azeite maro, uwa eukuru jehnahpyry maro, pakeimo onekarohpyry samo. Moro onekarohpyry tonahsẽme mana ya, typoxine ya mana, yzamaro mana, tykase Ritonõpo. ");
INSERT INTO apyNT_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","— Mame oserematoh ae kaneru mũkuru asakoro enehnõko matose ya, toiro jeimamyry exiketomo, tynyrohke pyra exiketomo. Mokaro maro tiriiku kurã enehtoko asakoro kirume otoxie azeite maro, uwa eukuru jehnahpyry maro. ");
INSERT INTO apyNT_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Moro onekarory zahkãko matose tytororo emero oserematoh ae, onekarorykõ maro kokoro rokẽ tyahkasẽme exiketõ maro, uwa eukuru jehnahpyry maro onekaroryme. ");
INSERT INTO apyNT_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","— Emero nuno po, ẽmepyry apitorymã po ynara enehtoko onekaroryme ya, Oesẽkomo a, oekykõ zahkatohme tytororo: pui mũkuru tõ asakoro te, toiro kaneru orutua te, 7me kaneru mũkuru tomo toiro jeimamyry exiketomo, tynyrohke pyra exiketomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Toiro pui mũkuru maro oseruao kirume tiriiku kurã enehtoko otoxie azeite maro. Toiro kaneru orutua maro asakoro kirume tiriiku enehtoko otoxie azeite maro, ");
INSERT INTO apyNT_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","toiro kaneru mũkuru maro toiro kirume tiriiku enehtoko. Moro onekarory tõ tyahkasẽme exĩko mã kehko tytororo, onekarorykõme ya, typoxine exĩko mã kehko ya, Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Uwa eukuru jehnahpyry onekarorykõme ya ynara mana: toiro pui mũkuru maro asakoro riturume uwa eukuru jehnahpyry enehnõko matose, kaneru orutua maro 1½ riturume uwa eukuru jehnahpyry enehnõko matose, kaneru mũkuru maro toiro riturume uwa eukuru jehnahpyry enehnõko matose. Morohne enehnõko matose onekarorykõ zahkatohme tytororo ẽmepyry apitorymã po emero nuno po emero jeimamyry ae. ");
INSERT INTO apyNT_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Moro onekarorykõ tyahkase aexihpyry tytororo maro, tonehse oya xine kokoro rokene, uwa eukuru jehnahpyry maro, toiro poti enehtoko roropa jahkatohme onekarorykõme Ritonõpo a, ahno rypyry korokapotohme eya. ");
INSERT INTO apyNT_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Ẽmepyry 14mã po, nuno apitorymã po Oseahmatoh Paxikoa, Ritonõpo nenyokyhpyry ytotopõpyry poko oseahmãko matose Ritonõpo Oesẽkõ eahmaryme. ");
INSERT INTO apyNT_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Yrokokoro, ẽmepyry 15me aehtoh po otuhtoh konõto rĩko matose; 7me ẽmepyry ae pão ohnõko matose iporutatoh maro pyra. ");
INSERT INTO apyNT_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Sero otuhtoh konõto ẽmepyry apitorymã po erohpyra exĩko matose emero porehme; oximõnõko matose Ritonõpo eahmatohme. ");
INSERT INTO apyNT_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Mame onekarorykõ enehtoko jahkatohme porehme onekarorykõme Ritonõpo a: pui mũkuru tõ asakoro te, toiro kaneru orutua te, 7me kaneru tõ, toiro jeimamyry exiketomo, tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Toiro pui mũkuru maro 3 kirume tiriiku kurã zahkãko matose otoxie azeite maro. Kaneru orutua maro 2 kirume tiriiku zahkãko matose otoxie azeite maro, ");
INSERT INTO apyNT_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","toiro kaneru maro toiro kirume tiriiku zahkãko matose. ");
INSERT INTO apyNT_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Onekaroryme roropa Ritonõpo a poti enehko jahkatohme, ahno rypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Morohne enehnõko matose onekarorykõme ya, kokoro rokẽ onekarorykõ maro jahkatohme porehme. ");
INSERT INTO apyNT_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Mokarohne ke, kokoro rokẽ 7me ẽmepyry ae onekarorykõ Ritonõpo a jahkãko matose tonahsẽme, typoxine exiketyme eya. Morohne enehnõko matose onekarorykõme, kokoro rokẽ onekarotyã maro, jahkatohme porehme te, uwa eukuru jehnahpyry maro, onekarorykõme. ");
INSERT INTO apyNT_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Mame ẽmepyry 7mã po oximõnõko matose Ritonõpo eahmatohme, moro ẽmepyry ae erohpyra exĩko matose emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Ẽmepyry apitorymã po Oseahmatoh Tykyrysã Apoitoh poko, Otuhtoh Konõto Semana tõ poko roropa, onekarorykõ enepyryhtao oya xine Ritonõpo Oesẽkomo a, anapoityãkõ apitorymã tiriiku tõkehko, oximõnõko matose jeahmatohme. Erohpyra exĩko matose, emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Onekarory tõ enehnõko matose jahkatohme onekarorykõme ya, Ritonõpo a. Moro typoxine exĩko ya mana. Ynara enehnõko matose ya: pui orutua mũkuru tõ asakoro te, toiro kaneru orutua te, 7me kaneru mũkuru tomo, toiro jeimamyry exiketomo, tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Toiro pui mũkuru maro oseruao kirume tiriiku kurã zahkãko matose otoxie azeite maro. Kaneru orutua maro asakoro kirume tiriiku zahkãko matose otoxie azeite maro, ");
INSERT INTO apyNT_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","toiro kaneru maro toiro kirume tiriiku zahkãko matose. ");
INSERT INTO apyNT_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Toiro poti enehtoko roropa jahkatohme ahno rypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Morohne enehtoko uwa eukuru jehnahpyry maro onekarorykõme jahkatohme kokoro rokẽ onekarohpyrykõ maro, tiriiku tõkehko onekarotyãkõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Ynara tykase Ritonõpo Moeze a Izyraeu tõ ripotohme: — Ẽmepyry apitorymã po nuno 7mã po oximõtoko Ritonõpo eahmatohme, moro ae erohpyra ehtoko. Moro ẽmepyry ae rueimo etotoko. ");
INSERT INTO apyNT_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Okyno tõ zahkãko matose tytororo onekarorykõme Ritonõpo a typoxine ehtohme: toiro pui mũkuru te, toiro kaneru orutua te, 7me kaneru mũkuru tomo toiro jeimamyry exiketomo, emero tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Pui mũkuru maro 3 kirume tiriiku kurã enehtoko otoxie azeite maro. Kaneru orutua maro 2 kirume tiriiku enehtoko otoxie azeite maro, ");
INSERT INTO apyNT_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","toiro kaneru mũkuru maro toiro kirume tiriiku enehtoko otoxie azeite maro. ");
INSERT INTO apyNT_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Toiro poti roropa jahkatoko onekaroryme Ritonõpo a ahno rypyry korokapotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Morohne enehtoko, onekarorykõ maro jahkatohme tytororo ẽmepyry apitorymã po nuno po, onekarorykõ tiriiku tõkehko maro, onekarorykõ maro roropa jahkatohme kokoro rokene tiriiku tõkehko maro, uwa eukuru jehnahpyry maro. Morohne tonahsẽ zahkaryhtao onekarorykõme typoxine mana Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","— Ẽmepyry 10mã po nuno 7mã po oximõtoko Ritonõpo eahmatohme. Moro ẽmepyry ae otuhpyra ehtoko ipunaka erohpyra ehtoko, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Okyno tõ enehtoko Ritonõpo a jahkatohme porehme onekarorykõme typoxine exiketyme eya. Ynara enehnõko matose: toiro pui mũkuru te, toiro kaneru orutua te, 7me kaneru mũkuru tomo toiro jeimamyry exiketomo, emero tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Pui mũkuru maro 3 kirume tiriiku kurã enehtoko otoxie azeite maro. Kaneru orutua maro asakoro kirume tiriiku enehtoko otoxie azeite maro, ");
INSERT INTO apyNT_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","toiro kaneru mũkuru maro toiro kirume tiriiku enehtoko. ");
INSERT INTO apyNT_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Poti mũkuru zahkatoko roropa onekarorykõme oorypyrykõ korokapotohme; morohne maro onekarotyã zahkatohme ahno kurãkatohme te, kokoro rokẽ onekarory maro zahkatohme tiriiku maro, uwa eukuru jehnahpyry maro. ");
INSERT INTO apyNT_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","— Ẽmepyry 15mã po, nuno 7mã po oximõtoko Ritonõpo eahmatohme. Sero otuhtoh konõtome exĩko 7me ẽmepyry ae Ritonõpo eahmary poko. ");
INSERT INTO apyNT_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Ẽmepyry apitorymã po sero oseahmatoh poko tonahsẽ enehtoko jahkatohme onekarorykõme Ritonõpo a, typoxine exikety jamaro ehtohme. Ynara enehtoko 13me pui mũkuru tomo te, asakoro kaneru orutua komo te, 14me kaneru mũkuru tomo, toiro jeimamyry exiketomo, emero tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Toiro pui mũkuru maro 3 kirume tiriiku kurã enehtoko otoxie azeite maro. Toiro kaneru orutua maro asakoro kirume tiriiku enehtoko otoxie azeite maro, ");
INSERT INTO apyNT_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","toiro kaneru mũkuru maro toiro kirume tiriiku enehtoko, uwa eukuru jehnahpyry maro onekarorykõme. ");
INSERT INTO apyNT_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Poti roropa jahkatoko onekarorykõme ahno rypyry korokapotohme. Mokarohne jahkatoko onekarorykõme, moro kokoro rokẽ kaneru tõ zahkatoh maro, tiriiku maro, uwa eukuru jehnahpyry maro. ");
INSERT INTO apyNT_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","— Yrokokoro, ẽmepyry asakoromã po 12me pui mũkuru tõ enehtoko jahkatohme onekarorykõme, kaneru orutua kõ asakoro te, 14me kaneru mũkuru tõ maro, toiro jeimamyry exiketomo, emero tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","19","Mokaro maro morohne enehtoko onekaroryme emero Ritonõpo nenehpohpyry ẽmepyry apitorymã po. ");
INSERT INTO apyNT_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","— Ẽmepyry 3mã po 11me pui mũkuru tõ enehtoko, 2me kaneru orutua komo te, 14me kaneru mũkuru tõ maro toiro jeimamyry exiketomo, emero tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","22","Mokaro maro morohne enehtoko roropa emero Ritonõpo nenehpohpyry ẽmepyry apitoryme aexihpyry samo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","— Ẽmepyry 4mã po 10me pui mũkuru tõ enehtoko, 2me kaneru orutua komo te, 14me kaneru mũkuru tomo toiro jeimamyry exiketomo, emero tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","25","Mokaro maro morohne enehtoko roropa emero Ritonõpo nenehpohpyry ẽmepyry apitoryme aexihpyry samo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","— Ẽmepyry 5mã po 9me pui mũkuru tõ enehtoko, 2me kaneru orutua komo te, 14me kaneru mũkuru tomo toiro jeimamyry exiketomo, emero tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","28","Mokaro maro morohne enehtoko roropa emero Ritonõpo nenehpohpyry apitoryme aexihpyry samo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","— Ẽmepyry 6mã po 8me pui mũkuru tõ enehtoko, 2me kaneru orutua komo te, 14me kaneru mũkuru tomo toiro jeimamyry exiketomo, emero tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","31","Mokaro maro morohne enehtoko roropa emero Ritonõpo nenehpohpyry ẽmepyry apitoryme aexihpyry samo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","— Ẽmepyry 7mã po 7me pui mũkuru tõ enehtoko, 2me kaneru orutua komo, 14me kaneru mũkuru tomo toiro jeimamyry exiketomo, emero tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","34","Mokaro maro morohne enehtoko roropa emero Ritonõpo nenehpohpyry ẽmepyry apitorymã po jahkatohme. ");
INSERT INTO apyNT_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","— Ẽmepyry 8mã po oximõtoko Ritonõpo eahmatohme, erohpyra ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Okyno enehtoko jahkatohme tytororo onekarorykõme Ritonõpo a typoxine exiketyme eya. Ynara enehtoko: toiro pui mũkuru te, kaneru orutua toiro te, 7me kaneru mũkuru tomo toiro jeimamyry exiketomo, emero tynyrohke pyra exiketomo. ");
INSERT INTO apyNT_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","38","Mokaro maro morohne enehtoko roropa emero Ritonõpo nenehpohpyry ẽmepyry apitoryme aehtoh ae. ");
INSERT INTO apyNT_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","— Morohne tyripõko ase oya xine okyno tõ enehtohme jahkatohme tytororo tiriiku tõkehko maro, uwa eukuru jehnahpyry maro onekarorykõme Ritonõpo a osepeme ehtohme oseahmatoh poko awahtao xine, ẽmepyry inymenekahpyry toehse ahtao. Mokarohne enehpõko ase oya xine enehtohme onekarorykõme Ritonõpo a te, onekarorykõ maro omihpyry ae ro totapose ahtao oya xine te, imepỹ ropa onekarorykõ ekarory se rokẽ awahtao xine amoreme xine, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Naeroro Izyraeu tõ turuse Moeze a morohne emero Ritonõpo nyripohpyry eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mame Moeze tõturuse Izyraeu tõ oxiekyry tõ tuisary tomo a. Ynara tykase: — Sero nase Ritonõpo nyripohpyry oya xine: ");
INSERT INTO apyNT_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Õmirykõ totapose ahtao oya xine onekarorykõ enepyry poko Ritonõpo a te, õmirykõ totapose ahtao oya xine otytyko riry poko oya te, otytyko onyripyra oehtohkõ poko roropa, õmihpyrykõ omipona ehtoko emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","— Mame nohpo oryximã tumy tapyĩ tao ro tahtao tõmiry etaporyhtao otytyko ekarory poko Ritonõpo a te, otytyko riry poko eya te, otytyko onyripyra toehtoh poko roropa, ");
INSERT INTO apyNT_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","jumy moro waro ahtao, oturupyra ynororo ahtao, zae mokyro nohpo mana moro riryhtao eya emero tynetapohpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Yrome moro waro toehse jumy ahtao, moro onyripopyra ahtao, mokyro nohpo zae ro mana onyripyra tahtao. Iirypyry korokãko Ritonõpo mana, aomiry onyripopyra jumy exiryke. ");
INSERT INTO apyNT_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","— Nohpo, tynioke pyra exikety, tõmiry totapose ahtao Ritonõpo a, osenetupuhpyra ahtao te, tuaro ynororo ahtao roropa, otytyko ritohme te, onyripyra toehtohme roropa, mame niotãko mana, ");
INSERT INTO apyNT_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","inio moro waro tahtao oturupyra ynororo ahtao, zae mokyro nohpo mana morohne riryhtao tõmihpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Yrome, inio moro waro toehse ahtao, moro onyripopyra ahtao eya, mokyro nohpo zae ro mana tõmihpyry onyripyra tahtao. Iirypyry korokãko Ritonõpo mana. ");
INSERT INTO apyNT_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","— Pytỹpo tomo te, tynio a turumekase aexityã roropa tõmiry totapose ahtao tynekarory poko Ritonõpo a te, otytyko riry poko te, otytyko onyripyra toehtoh poko roropa, zae mã ynororo tõmihpyry ae emero riryhtao eya. ");
INSERT INTO apyNT_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","— Nohpo tynioke exikety tõmiry totapose ahtao eya tynekarory poko Ritonõpo a te, tõmiry totapose ahtao eya otytyko riry poko te, otytyko onyripyra toehtoh poko, ");
INSERT INTO apyNT_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","inio moro waro toehse ahtao, oturupyra ynororo ahtao, zae mokyro nohpo mana morohne riryhtao eya tõmihpyry ae ro. ");
INSERT INTO apyNT_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Yrome inio moro waro toehse ahtao, moro onyripopyra ynororo ahtao eya, mokyro nohpo zae ro mana tõmihpyry onyripyra tahtao. Iirypyry korokãko Ritonõpo mana inio aomihpyry onyripopyra exiryke eya. ");
INSERT INTO apyNT_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Inio ỹme se ahtao typyty omihpyry poko zae mana. Tyripory se pyra inio ahtao zae ro mana onyripopyra ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Yrome moro waro inio toehse ahtao, mame yrokokoro oturupyra ro mana, zae nohpo mana moro riryhtao eya emero, tynetapohpyry ae ro. Inio ỹme toehse mana typyty omihpyry maro oturupyra exiryke tuaro toehse ahtao moro poko. ");
INSERT INTO apyNT_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Yrome imeĩpo inio moro onyripopyra toehse ahtao, tõmihpyry totapose nohpo ahtao, tuãnohsẽme exĩko inio mana, nohpo onuãnohpyra exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Morohne Ritonõpo nyripohpyry Moeze a tõmihpyry totapose ahtao nohpo a tynioke pyra exiketyme ahtao te, tynioke exikety roropa, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","— Izyraeu tõ enyohko etonatohme mitianita tõ maro, emỹpotohme popyra toto nyrityã poko Izyraeu tomo a. Moromeĩpo orihnõko mase. ");
INSERT INTO apyNT_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Naeroro ynara tykase Moeze Izyraeu tomo a: — Opyrekõ tyritoko oytotohkõme emero pyra etonatohme mitianita tõ maro, emỹpotohme zae pyra toehse toto exiryke Ritonõpo Kuesẽkomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Emero oxiekyry tõ toiro miume soutatu tõ imenekatoko, aropotohme etonatohme. ");
INSERT INTO apyNT_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Naeroro Izyraeu tõ oxiekyry tõ poe 12 miumãkõ tymenekase ytotohme etonatohme; emero oxiekyry tõ poe toiro miumãkõ tymenekase. ");
INSERT INTO apyNT_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mokaro 12 miumãkõ taropose Moeze a etonatohme, Pineia poetoryme, oturukety Ereaza mũkuru. Ritonõpo kyryry tõ kurã tarose roropa eya, rueimo tõ maro tuaro ehtoh enetupuhpotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Mame Ritonõpo nyripohpyry Moeze a omipona tõsetapase toto mitianita tõ maro; orutua kõ totapase eya xine emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Aorihtyã ekepyry tõ maro Ewi nexiase te, Rekẽ te, Zua te, Huru te, Repa, enara; 5me mitianita tuisary tomo. Paraão roropa totapase eya xine Peoa mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Mitianita nohpory tõ tarose Izyraeu tomo a typoetory tõme, poeto tõ maro. Kaneru tõ roropa tapoise eya xine, poti tõ maro, pui tõkehko maro, imõkomohpyry maro. ");
INSERT INTO apyNT_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Apoto tukase eya xine mitianita tõ patary tõ zahkatohme, soutatu tõ tapyinỹpyry tõ tyahkapose roropa eya xine emero porehme. ");
INSERT INTO apyNT_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Mame imõkomohpyry tapoise eya xine, ahno maro, okyno tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Morohne emero tarose eya xine Moeze a, oturukety Ereaza a roropa, imoihmãkõ Izyraeu tomo a roropa, tosarykõ po toto ahtao, ona Moape po, tuna Joatão ehpiõ pũto, pata Jeriko etonie. Tuna moino Jeriko nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mame Moeze tomo, oturukety Ereaza maro, Izyraeu tõ tamuximãkõ maro tutũtase toto tosarykõ poe oseporyse soutatu tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Tohne toehse Moeze, soutatu tõ tuisary tõ zehno, miumãkõ tuisary tomo te, 100mãkõ tuisary tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Ynara tykase Moeze: — Oty katohme mokaro nohpo tõ emero typynanohse oya xine isene ro? ");
INSERT INTO apyNT_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Wenikehpyra ehtoko, nohpo tõ nexiase Paraão omi poe Izyraeu tõ ewokananõme toehse, Ritonõpo Omihpyry omipona pyra Izyraeu tõ ehtohme, tyneponãmarykõ Paau-Peoa eahmatohme eya xine. Morara exiryke tyrohsẽ toehse Ritonõpo poetory tõ pona. ");
INSERT INTO apyNT_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Seromaroro mokaro mũkuru tõ emero etapatoko, nohpo tõ maro emero orutua maro toehse aexityamo. ");
INSERT INTO apyNT_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Yrome mokaro ẽxiry tõ ipynanohko nohpo tõ maro, emero orutua maro exipitopyra exiketomo; opoetoryme mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Seromaroro amarokõ emero, ahno etapahpõkomo te, ekepyry apoihpõkõ roropa omõpyra matose atapyĩkõ taka, 7me ẽmepyry aropotoko jarãnaka. Ẽmepyry oseruaõ po, 7mã po roropa, amarokõ opoetory tõ maro ekurikatoko. ");
INSERT INTO apyNT_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Oupõkõ roropa ikurikatoko, okyno pihpyry risẽ roropa te, poti hpoty risemy te, wewe risẽ roropa emero. ");
INSERT INTO apyNT_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Mame ynara tykase oturukety Ereaza, mokaro orutua komo a toehse ropa aexityamo a etonatoh poe: — Ritonõpo Kuesẽkõ nyripohpyry Moeze a ynara mana: ");
INSERT INTO apyNT_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","Mõkomo emero zahpyra exiketõ apoto ke, uuru te, parata te, metau te, kurimene te, exitanio te, xũpu, enara tyriposẽme exĩko apoto htaka ikurãkatohme nuriame pyra ehtohme. Yrome mõkomo emero apoto ke zahketomo, morohne ikurikãko matose tuna ke. ");
INSERT INTO apyNT_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Mame ẽmepyry 7mã po, ekurãkatohme oupõkõ ikurikatoko emero. Moromeĩpo omõnõko ropa matose oesaka xine. ");
INSERT INTO apyNT_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","— Pape pona imerotoko, emero mokaro nenehtyã mitianita tõ poe, oturukety Ereaza ãkorehmãko mana te, tamuximãkõ ãkorehmãko roropa mã toto. Ahno tõ imeroko, okyno tõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Mame morohne apiakako irãnakuroko, asakoro zokonaka ehtohme, oxisamo. Toiro zokonaka soutatu tõ kyryryme exĩko; toiro zokonaka imehnõ ahno kyryryme exĩko. ");
INSERT INTO apyNT_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Mame soutatu tõ kyryry poe zokonaka pitiko apoĩko matose ekarotohme Ritonõpo a: 500me ahno ahtao toiro ahno ekarõko matose Ritonõpo a. Morararo pui tomo te, jumẽtu tomo te, kaneru tomo te, poti tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Moro Ritonõpo kyryry tõ apoiko ekarotohme oturukety Ereaza a. ");
INSERT INTO apyNT_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Mame moro ahno kyryry poe apiakako: 50me ahno ahtao toiro touko te, pui tomo te, jumẽtu tomo te, kaneru tomo te, poti tomo te, imehnõ okyno tõ roropa ekarotohme rewita tomo a, Ritonõpo Tapyĩ Kurã poko erohketomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Mame Ritonõpo nyripohpyry tyrise Moeze tomo a Ereaza maro. ");
INSERT INTO apyNT_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Ynara tymerose eya xine soutatu tõ napoityamo, (onymeropyra nexiase mõkomo tapoise ahtao soutatu tomo a tykyryrykõme rokene) 675 miume kaneru tomo poti tõ maro te, ");
INSERT INTO apyNT_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72 miume pui tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61 miume jumẽtu tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","32 miume ahno tomo, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Moro zokonaka soutatu tõ eky tõme 337.500me kaneru tõ nexiase poti tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Moro poe 675me tapiakase Ritonõpo eky tõme. ");
INSERT INTO apyNT_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Pui tomo 36 miume nexiase soutatu tõ ekyme. Mokaro wino 72me tapiakase Ritonõpo eky tõme. ");
INSERT INTO apyNT_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Jumẽtu tõ 30.500me soutatu tõ ekyme nexiase. Mokaro wino Ritonõpo ekyme 61me nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Nohpo tomo 16 miume nexiase soutatu tõ poetoryme nexiase. Mokaro wino 32me tokarose Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moro zokonaka pitiko tokarose Moeze a Ereaza a tynekaroryme kurã Ritonõpo a Izyraeu tõ Esemy, Ritonõpo nyripohpyry omipona. ");
INSERT INTO apyNT_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Moro zokonaka ahno kyryryme oxisã nexiase soutatu tõ kyryry maro. ");
INSERT INTO apyNT_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","337.500me kaneru tõ nae nexiase poti tõ maro te, ");
INSERT INTO apyNT_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36 miume pui tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30.500me jumẽtu tomo te, ");
INSERT INTO apyNT_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","16 miume ahno maro, enara. ");
INSERT INTO apyNT_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Mame Ritonõpo nyripohpyry ae ro moro zokonaka ahno tõ kyryry poe 50me ahtao toiro tapoise Moeze a Ritonõpo kyryryme ahno, okyno tomo, enara. Mame Ritonõpo kyryry tõ tokarose eya xine rewita tomo a, Ritonõpo Tapyĩ Kurã poko erohketõme toto exiryke. ");
INSERT INTO apyNT_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Mame soutatu tõ tuisary tomo, miumãkõ tuisary tomo, 100mãkõ tuisary tõ maro toytose toto oturuse Moeze a. ");
INSERT INTO apyNT_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Ynara tykase toto eya: — Soutatu tõ tukuhse yna a, yna poetory tomo emero isene ro mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Naeroro ynanekaroryme uuru risẽ ynanenehno keti tomo te, omekumy tomo te, omahtao tomo te, panasere tõkehko, Ritonõpo epehpyryme “Kure mase” katohme yna ewomaryke eya. ");
INSERT INTO apyNT_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Morohne tapoise Moeze tomo a Ereaza maro. ");
INSERT INTO apyNT_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Moro uuru tukuhse ahtao atapona 191 kirume nexiase soutatu tõ tuisary tõ nekarohpyry Ritonõpo a. ");
INSERT INTO apyNT_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Soutatu tõ tuisame pyra exiketomo a tynapoityã tukurãkase tykyryrykõme rokene. ");
INSERT INTO apyNT_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Mame moro uuru, soutatu tõ tuisary tõ nekarohpyry tarose Moeze a Ereaza maro Ritonõpo Tapyĩ taka wenikehpyra ehtohme Izyraeu tõ ewomaneme Ritonõpo ehtoh poko. ");
INSERT INTO apyNT_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Mame Rupẽ ekyry tõ Kate ekyry tõ roropa tokyke tuhke nae toh nexiase, pui tõkehko. Moro nono, Jazea nonory te, Kireate nonory roropa tonese ahtao eya xine, nono kure pui tõ nahpatohme, ");
INSERT INTO apyNT_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","toytose toto oturuse Moeze tomo a, oturukety Ereaza maro, Izyraeu tõ tuisary tõ maro. Ynara tykase toto: ");
INSERT INTO apyNT_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","— Sero nono typoremãkase Ritonõpo Kuesẽkomo a, Izyraeu tõ esaryme, pata Atarote te, Tipõ te, Jazea te, Ninira te, Hexipõ te, Ereau te, Sepã te, Nepo te, Peõ, enara; sero nono kure mana pui tõ nahpatohme. Tokyke ynanase tuhke pui tõkehko. ");
INSERT INTO apyNT_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Naeroro azamaro yna ahtao sero nono ekaroko yna a, yna esaryme ehtohme, tuna Joatão mõpozakoxi yna anaropopyra oehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Yrome ynara tykase Moeze Kate tomo a Rupẽ tõ maro: — Tehme oehtohkõ se hmatou taro imehnõ Izyraeu tõ ytoryhtao etonatohme? ");
INSERT INTO apyNT_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Oty katohme oekyrykõ, Izyraeu tõ omipohtomãko matou, ytopyra toto ehtohme moro nono pona, Ritonõpo nekarory pona? ");
INSERT INTO apyNT_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Moro sã tyrise omy tomo a taropose toto ahtao ya Kate-Panea poe sero nono enetohme. ");
INSERT INTO apyNT_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Toeporehkase toto ahtao jakanahmã Exikou pona, nono tonese eya xine; yrome tooehse ropa toto ahtao, ahno taomipohtomase eya xine, omõpyra tokurehse toto nono, Ritonõpo nekarory pona. ");
INSERT INTO apyNT_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","— Morarame moro ẽmepyry ae tohne toehse Ritonõpo nexiase. Ynara tykase ynororo: ");
INSERT INTO apyNT_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","“Mokaro orutua kõ, Ejitu poe aehtyã 20me jeimamyry motye exiketõ jomihpyry omipona pyra toehse. Naeroro jomiry etapõko ase: moro nono onenepyra ekurehnõko mã toto, sero ekarõko ase oya, katopõpyry ya Aparão a, Izake a, Jako a, enara.” ");
INSERT INTO apyNT_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Karepe rokẽ, Jepone mũkuru, kenezeume exikety, Jozue roropa, Num mũkuru, Ritonõpo omiry omipona exikehpyra toh nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Izyraeu tõ zehno toehse Ritonõpo exiryke toto taropose eya toytorykõ poko ona tonorẽ poro 40me jeimamyry ae; mokaro emero Ritonõpo zamaro pyra aexityã orihtoh pona. ");
INSERT INTO apyNT_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Seromaroro enetoko ke, amarokõ omykõ myakãme matose, iirypyryme matose roropa, Ritonõpo Izyraeu tõ zehnohxo ripõko matose. ");
INSERT INTO apyNT_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ritonõpo omiry omipona se pyra awahtao xine Izyraeu tõ rumekãko ropa mana ona tonorẽ po, tonahkasẽme exĩko mã toto opokoino xine. ");
INSERT INTO apyNT_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Mame Moeze ẽpataka toehse toh nexiase. Ynara tykase toto: — Topu ke kaneru tõ esary rĩko ynanase taro, pui tõ esary roropa, pata tõ rĩko roropa ynanase yna poenõ esaryme yna pyxiã maro. ");
INSERT INTO apyNT_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Moromeĩpo typyreke ytõko ynanase imehnõ Izyraeu tõ maro osetapase toto akorehmaryme nono apoitohme toto esaryme. Yrome yna poenomo yna pyxiã maro tehme exĩko mã toto taro pata tõ tapuruse aexityã ao, towomase imehnõ sero nono põkõ wino. ");
INSERT INTO apyNT_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Oehpyra ropa ynanase exĩko otyhkara ro kuahtao xine Izyraeu tõ nonory apoiry poko, ekamory poko roropa eya xine toto esarykõme. ");
INSERT INTO apyNT_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Nono anapoipyra exĩko ynanase moroto Izyraeu tõ rãnao tuna Joatão moinakoxi, nono tapoise yna exiryke taro Joatão poe xixi tũtatoh wino. ");
INSERT INTO apyNT_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mame ynara tykase Moeze: — Ajohpe pyra awahtao xine tyritoko õmihpyrykõ ae ro Ritonõpo neneryme, opyrekõ tyritoko oytotohkõme etonase. ");
INSERT INTO apyNT_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Mame amarokõ, orutua kõ typyreke exiketõ emero tuna Joatão akuohnõko matose Ritonõpo Kuesẽkõ omipona, kuepetõkara emero aropotohme Ritonõpo ẽpataka, ");
INSERT INTO apyNT_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","moro nono poremãkatohme. Imeĩpo oehnõko ropa matose xiaro, Ritonõpo Oesẽkõ nyripohpyry tyrise oya xine exiryke, Izyraeu tõ takorehmase oya xine exiryke. Mame sero nono oesarykõme exĩko mana Ritonõpo poe tuna Joatão poe xixi tũtatoh wino. ");
INSERT INTO apyNT_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Yrome, õmihpyrykõ omipona pyra awahtao xine iirypyryme exĩko matose Ritonõpo a; tuaro ehtoko tuãnohsẽme exĩko matose oorypyrykõ pokoino. ");
INSERT INTO apyNT_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Pata tõ tyritoko opyxiãkõ esaryme opoenõ maro, oeky tõ esary tõ tyritoko roropa: kaneru tõ esary tomo, pui tõ esaryme roropa. Tyritoko emero õmihpyrykõ ae ro. ");
INSERT INTO apyNT_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Ynara tykase Kate tomo, Rupẽ tõ maro Moeze a: — Onyripohpyry omipona exĩko ynanase. ");
INSERT INTO apyNT_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Yna poenomo, yna pyxiamo, yna eky tomo: kaneru tomo te, poti tõ maro, pui tõ maro emero taro rokẽ exĩko mã toto pata tõ po Kireate po. ");
INSERT INTO apyNT_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Yrome yna orutua kõ emero ytõko ynanase etonatohme. Õmiry omipona ytõko ynanase tuna Joatão mõpozakoxi etonatohme Ritonõpo omiry omipona. ");
INSERT INTO apyNT_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Naeroro tõmiry tokarose Moeze a Rupẽ tõ poko, Kate tõ poko roropa oturukety Ereaza a te, Jozue, Num mũkuru a te, Izyraeu tõ tuisary tomo a roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Ynara tykase ynororo: — Ritonõpo omiry omipona, Kate tõ, Rupẽ tõ maro ytõko mã toto tuna Joatão mõpozakoxi typyrekõ maro etonatohme. Moro nono typoremãkase oya xine ahtao Joatão poe xixi omõtoh wino, sero nono Kireate ekarotoko eya xine esarykõme. ");
INSERT INTO apyNT_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Yrome tuna Joatão anakuohpyra toto ahtao typyrekõ maro, amaro xine, nono apoĩko rokẽ mã toto Kanaã po asã xine. ");
INSERT INTO apyNT_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Ynara tykase Kate tomo Rupẽ tõ maro: — Ỹ, Ritonõpo Kuesẽkõ nyripohpyry omipona tyrĩko ynanase. ");
INSERT INTO apyNT_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Aomiry omi poe ytõko ynanase tuna Joatão mõpozakoxi yna pyre tõ maro etonatohme Kanaã nonory po. Yrome sero nono tuna Joatão poe xiaro yna esaryme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Morara exiryke ynara tokarose Moeze a, Kate tomo a te, Rupẽ tomo a te, Joze mũkuru, Manase zokonaka a: Seõ nonory amoreu tõ tuisary te, Oke nonory, Pasã tuisary te, pata tõ maro, nono maro moro pata tõ zomye. ");
INSERT INTO apyNT_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Mame pata tõ tyrise ropa Kate tomo a: Tipõ te, Atarote te, Aroea te, ");
INSERT INTO apyNT_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atarote-Sofã te, Jazea te, Jokopea te, ");
INSERT INTO apyNT_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Pete-Ninira te, Pete-Harã. Apuru tõ tyrise eya xine moro pata tõ apurume, okyno tõ apurutoh roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Mame pata tõ tyrise ropa Rupẽ tomo a: Hexipõ te, Ereau te, Kiriataĩ te, ");
INSERT INTO apyNT_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nepo te, Paau-Meõ, (moro pata tõ esety tytyorõmase nexiase) te, Xipima, enara. Imehnõ esety ke pata tõ tosehpase eya xine tyrise ahtao eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Oxiekyry tõ Makia ekyrymãkõ, Manase mũkuru, toytose toto Kireate pona. Moro põkõ typoremãkase eya xine, amoreu tomo. Taropose toto moro poe eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Naeroro Kireate tokarose Moeze a Makia tomo a, moroto toto esaryme ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Imehnõ amoreu tõ patary tõ typoremãkase Jaia a, Manase pary. Moro pata tõ tosehpase eya “Jaia patary” me. ");
INSERT INTO apyNT_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Mame pata Kenate typoremãkase Nopa a pata pisarara maro moro pata zomye. Moro pata tosehpase eya Nopame, tosety ae ro. ");
INSERT INTO apyNT_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Sero nase Izyraeu tõ ytotopõpyry poko toesyryhmase toto ahtao Ejitu poe oxiekyrymãkõ maro, tarose toto ahtao Moeze tomo a, Arão maro. ");
INSERT INTO apyNT_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Ritonõpo nyripohpyry omipona, osa tõ esety tymerose Moeze a ytoytopitoryhtao. Ynara tymerose Moeze a toytorykõ poko: ");
INSERT INTO apyNT_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Ejitu poe Izyraeu tõ toytose ẽmepyry 15mã po, nuno apitorymã po. Yrokokonie Otuhtoh Paxikoa apitorymã tonahse eya xine. Mame pata Ramese poe toytose toto orẽpyra samo, Ejitu põkõ neneryme, ");
INSERT INTO apyNT_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","tumũkuru tõ zonemyryke eya xine, osemazuhme aenurutyã totapase Ritonõpo a exiryke. Moro ke Ejitu põkõ neponãmarykõ motye tyjamitunuru tonepose Ritonõpo a, Ejitu põkomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Morotoino Ramese poe Izyraeu tõ toytose osesarise Sukote pona. ");
INSERT INTO apyNT_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Morotoino Sukote poe toytose toto Etã pona osesarise ona tonorẽ ehpiõ pona. ");
INSERT INTO apyNT_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Morotoino Etã poe toeramase toto Pi-Hairote pona, Paau-Zepõ poe xixi tũtatoh wino, osesarise Mikitou pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Morotoino Pi-Hairote poe toytose toto tuna konõto Tahpiremã rãnakuroko ona tonorẽ Sua pona. Toytose toto oseruao ẽmepyry ae ona tonorẽ poro osesarise Mara pona. ");
INSERT INTO apyNT_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Morotoino toytose toto Erĩ pona osesarise. Moroto Erĩ po 12me tuna enatyry nae nexiase, 70me airiki panõ tõ roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Morotoino toytose toto Erĩ poe osesarise tuna Sueze pũtokoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Morotoino toytose toto osesarise ona tonorẽ Xĩ pona. ");
INSERT INTO apyNT_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Morotoino toytose toto osesarise Topika pona. ");
INSERT INTO apyNT_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Morotoino toytose toto Topika poe Aru pona osesarise. ");
INSERT INTO apyNT_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Morotoino toytose toto Aru poe osesarise Repitĩ pona. Yrome moroto tuna pyra nexiase ahno okurume. ");
INSERT INTO apyNT_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","37","Morotoino toytorykõme Repitĩ poe mya ypy Hoa pona tõsesarise toh nexiase ynara pona: ona tonorẽ Xinai pona te, Kiporote-Ataawa te, Hazerote te, Ritima te, Rimõ-Pereze te, Ripina te, Risa te, Keerata te, ypy Sepea te, Harata te, Makerote te, Taate te, Tera te, Mitika te, Hasamona te, Moserote te, Pene-Jaakã te, Hoa-Hajitikate te, Jotopata te, Aparona te, Eziõ-Kepea te, ona tonorẽ Zim te, (esety akorõ Kate mana), ypy Hoa roropa Etõ tõ nonory ehpiõ po kynexine. ");
INSERT INTO apyNT_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Moroto Ritonõpo nyripohpyry omipona oturukety Arão tõnuhse ypy Hoa pona. Toorihse ynororo moroto, ẽmepyry apitorymã po, nuno 5mã po, 40me jeimamyry taropose ahtao Izyraeu tomo a, tutũtatopõpyrykõ poe Ejitu poe. ");
INSERT INTO apyNT_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","123me jeimamyry Arão nae nexiase. Mame toorihse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Mame kananeu tõ tuisary Arate tosake nexiase ikurenae Kanaã nonory po. Izyraeu tõ oepyry poko zuaro toehse ynororo. ");
INSERT INTO apyNT_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","49","Morotoino ypy Hoa poe toytorykõme Moape tõ nonory pona; ynara pata tõ pona toytose toto osesarise: Saumona te, Punõ te, Opote te, patãpo Aparĩ, Moape ehpio po te, Tipõ-Kate po te, Aramõ-Tipirataĩ te, ypy tõ Aparĩ te, ypy Nepo pũto, nono topohmã po Moape po, irãnao Pete-Jeximote poe jakanahmã Akaxia tõ po, tuna Joatão poe xixi tũtatoh wino, pata Jeriko etonie. Jeriko kynexine tuna moinakoxi. ");
INSERT INTO apyNT_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Mame nono topohmã po Moape po, tuna Joatão ehpiõ, pata Jeriko etonie, tõturuse Ritonõpo Moeze a, ");
INSERT INTO apyNT_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","ynara katohme Izyraeu tomo a: — Tuna Joatão takuohse ahtao oya xine, omõtohme Kanaã pona, ");
INSERT INTO apyNT_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","moro põkõ aropotoko emero porehme moro nono poe. Mokaro neponãmary tõ enahkatoko: metau risemy te, topu risẽ maro te, mokaro eahmatoh roropa, emero. ");
INSERT INTO apyNT_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Moro nono apoitoko oesarykõme, ekarõko ase oya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Moro nono apiakatoko ekamotohme imenekatoh ke, oxiekyry tõ esaryme. Oxiekyry tõ tuhkehxo ahtao, nono zokonaka zumohxo ekarotoko eya xine; oxiekyry tõ tuhke hkopyra ahtao, nono zokonaka zumo hkopyra ekarotoko eya xine. ");
INSERT INTO apyNT_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Yrome moro põkõ anaropopyra awahtao xine moro nono poe, moroto ro aexityã omoxino tõ sã exĩko mã toto oenurukõ ao, purutõ sã roropa õparykõ poko. Atatapoĩko mã toto amaro xine moro oesarykõ po. ");
INSERT INTO apyNT_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Morarame oritorỹko ase mokaro riry se jehtopõpyry samo. ");
INSERT INTO apyNT_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Mame ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","— Ynara tyripoko Izyraeu tomo a: Oeporehkarykohtao Kanaã pona, nono ynekarory oya xine, ynara sã ehpiõme exĩko mana: ");
INSERT INTO apyNT_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","— Ehpio ikurenae exĩko ona tonorẽ Zim poe Etõ nonory ehpikuroko. Ehpio xixi tũtatoh wino exĩko tuna konõto Aorikyhpyry potyry ikurenae poe. ");
INSERT INTO apyNT_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Moro poe ytõko ikurenaka onuhtoh Akarapĩ pokoxi, Zim rãnakuroko Kate-Panea pona. Morotoino ytõko Hazaa-Ataa poro Azamõ pona. ");
INSERT INTO apyNT_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Morotoino Azamõ poe ytõko iporiry ehpikoxi, Ejitu ehpiome exikety tuna konõto Metiteraneu pona. ");
INSERT INTO apyNT_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","— Moro tuna konõto Metiteraneu ononorykõ ehpiõme exĩko xixi omõtoh wino. ");
INSERT INTO apyNT_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","— Ononorykõ ehpio inikahpozakoxi exĩko tuna konõto Metiteraneu poe ypy Hoa pona. ");
INSERT INTO apyNT_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Morotoino ytõko onuhtoh Hamate pona, moromeĩpo Zetate pona. ");
INSERT INTO apyNT_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Zetate poe ononorykõ ehpio inikahpozakoxi ytõko Zipirõ pona, mame Hazaa-Enã pona, etyhpyryme. ");
INSERT INTO apyNT_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","— Ononorykõ ehpio xixi tũtatoh wino exĩko Hazaa-Enã poe Sepã pona. ");
INSERT INTO apyNT_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Mame Sepã poe ytõko Ripira pona, Aim poe xixi tũtatoh wino. Morotoino ononorykõ ehpio yhtõko ikuhpo Karirea ehpikuroko xixi tũtatoh wino. ");
INSERT INTO apyNT_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Tuna Joatão rãnakuroko ytõko ikurenaka tuna konõto Aorikyhpyry ehpikoxi. — Morohne ononorykõ ehpiõ asakoropane. ");
INSERT INTO apyNT_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Mame ynara tyripose Moeze a Izyraeu tomo a: — Sero nono apiakãko matose imenekatoh ke ononorykõme. Sero nono Ritonõpo Kuesẽkõ nekarohpyryme mana ekamotohme 9½me oxiekyryme exiketomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","15","Ynara exiryke: nono tapoise tosarykõme tuna Joatão poe xixi tũtatoh wino, pata Jeriko etonie 2½me oxiekyryme exiketomo a, Kate tomo te, Rupẽ tomo te, zokonaka Manase tomo a, enara. Tuna Joatão moino Jeriko nexiase. ");
INSERT INTO apyNT_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","— Oturukety Ereaza, Jozue maro, Num mũkuru, nono ekamõko mã toto ahno esaryme. ");
INSERT INTO apyNT_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Imehnõ tamuximãkõ imenekatoko roropa, toiro orutua toiro oxiekyrymãkõ wino ãkorehmatohme nono apiakary poko. ");
INSERT INTO apyNT_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","28","Ynara ikohmatoko ãkorehmatohkõme: Juta tõ tuisary Karepe, Jepone mũkuru. Ximeão tõ tuisary Samueu, Amiute mũkuru. Pẽjamĩ tõ tuisary Eritate, Kixirõ mũkuru. Tã tõ tuisary Puki, Jokiri mũkuru. Joze (Manase) tõ tuisary Hanieu, Epote mũkuru. Eparaĩ tõ tuisary Kemueu, Xipitã mũkuru. Zepurõ tõ tuisary Erisapã, Paranake mũkuru. Isakaa tõ tuisary Pautieu, Azã mũkuru. Asea tõ tuisary Aiute, Seromi mũkuru. Napatari tõ tuisary Petaeu, Amiute mũkuru. ");
INSERT INTO apyNT_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Mokaro tymenekase Ritonõpo a nono apiakatohme Kanaã po ekamotohme Izyraeu tomo a tosarykõme. ");
INSERT INTO apyNT_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Mame nono pipahmã Moape po, tuna Joatão ehpio pũto pata Jeriko etonie tõturuse Ritonõpo Moeze a. Tuna mõpoe pata Jeriko nexiase. Ynara tykase Ritonõpo Moeze a: ");
INSERT INTO apyNT_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","— Ynara tyripoko Izyraeu tomo a: nono tapoise oya xine ahtao pata tõ ekarotoko rewita tomo a, toto esaryme ehtohme ona maro pata tõ zomye. ");
INSERT INTO apyNT_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Moro pata tõ rewita tõ esaryme exĩko mana, moro tao tytapyĩke toto ehtohme, moro pata tõ zomye ona pui tõ esaryme exĩko, kaneru tõ esaryme, poti tõ maro, imehnõ okyno tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Moro okyno tõ esary pata tõ zomye exĩko 450 meturume pata apuru poe. ");
INSERT INTO apyNT_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Moro ehpio 900 meturume exĩko tahramehme samo, xixi tũtatoh wino xixi omõtoh pona, inikahpoe roropa ikurenaka. Moro pata exĩko irãnao, onahpoty exĩko pata zomye. ");
INSERT INTO apyNT_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","— Pata tõ 6me ekarotoko rewita tomo a moro taka epaketõ ytotohme. Imepỹ etapary se pyra orutua ahtao te, osenekunopyryhtao ahno etaparyhtao, moro pata pona epãko mã ynororo. Morohne maro imehnõ 42 pata tõ ekarotoko rewita tomo a. ");
INSERT INTO apyNT_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Naeroro atapona 48me pata tõ ekarõko matose rewita tomo a ona maro toto zomye. ");
INSERT INTO apyNT_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Moro pata tõ imehnõ oxiekyrymãkõ rãnao tuhkehxo exĩko moro oxiekyrymãkõ nonory zumohxo ahtao. Tuhke hkopyra exĩko moro nono zumo hkopyra ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Tõturuse Ritonõpo Moeze a, ");
INSERT INTO apyNT_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","ynara Izyraeu tõ zurutohme: — Tuna Joatão takuohse ahtao oya xine Kanaã nonory pona oytotohkõme, ");
INSERT INTO apyNT_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","pata tõ imenekatoko, moro taka epaketõ ytotohme, imepỹ etapary se pyra exikety te, osenekunopyryhtao imepỹ totapase ahtao eya. ");
INSERT INTO apyNT_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Moro tao exĩko mana towomase aorikyhpyry ekyry tõ wino, emỹpory se toto ahtao. Mame orihpyra exĩko mana anapiakara ro ahtao ahno ẽpataka. ");
INSERT INTO apyNT_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","6me pata tõ imenekatoko moro taka epaketõ ytotohme. ");
INSERT INTO apyNT_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Oseruao pata tõ tuna Joatão poe xixi tũtatoh wino, oseruao roropa Kanaã nonory po. ");
INSERT INTO apyNT_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Moro 6me pata tõ epaketõ ewomatohme exĩko mana: Izyraeu tõ ewomatohme te, imehnõ nonory põkõ ewomatohme roropa amaro xine toehse aexityamo axĩtao rokẽ amaro xine toehse toto ahtao, jũme toehse toto ahtao roropa. ");
INSERT INTO apyNT_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","18","— Imepỹ tapurose ahtao orutua a kurimene risẽ ke te, topu ke te, wewe ke, mokyro orihmaporyke, tyyrypyhpyke mã ynororo, aorikyry ke tuãnohsẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Mame mokyro aorikyhpyry ekyry toehse ahtao, tyekyry etapahpõ etapãko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","— Imepỹ tupurohmase ahtao orutua a zehno toexiryke te, otyro emaryhtao epona iiryhmatohme, mame taorihmapose ynororo ahtao, ");
INSERT INTO apyNT_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","topekara typipohse ahtao orutua a, mame taorihmapose ahtao roropa ynororo, mokyro etapahpono tuãnohsẽme exĩko aorikyry ke ahno totapase eya exiryke. Aorihtyã ekyry, toeporehkase ahtao, tyekyry etapahpõ etapãko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","— Yrome otarame ahno tupurohmase orutua a iiryhmary se pyra ahtao, osepeme toto ahtao; otarame iiryhmary se pyra ahtao otyro emãko mana epona. ");
INSERT INTO apyNT_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","Otarame onenepyra ahtao topu emãko mana, mame moro topu epukãko ahno pona, aorihtohme. Yrome mokaro asakoro osepeme toh nexiase. Tope etapary se pyra nexiase repe. ");
INSERT INTO apyNT_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Moro toehse ahtao ynara apiakãko ahno tõ mana: mokyro onuãnohpyra matose, ahno totapase eya etapary se pyra ahtao. Naeroro mokyro onekaropyra ehtoko aorikyhpyry mỹpone a. ");
INSERT INTO apyNT_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Mokyro ewomãko imoihmãkõ mana etapary se pyra ynororo exiryke, mokyro onetapara aorikyhpyry ekyry ehtohme. Mokyro arõko ropa mã toto pata epatoh taka, moroto aehtohme Oturukety imehxo exikety orihtoh pona, typopase exikety azeite kurã ke, Ritonõpo kyryry ke. ");
INSERT INTO apyNT_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Yrome mokyro, imepỹ etapahpono tũtaryhtao pata poe, epatoh poe, ");
INSERT INTO apyNT_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","mame aorihtyã mỹpone a tõseporyse ahtao mokyro totapasẽme exĩko mana. Mokyro etaparyhtao eya zae ro mana. Onuãnohpyra matose. ");
INSERT INTO apyNT_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Mokyro, imepỹ etapahpono tehme exĩko mana moro pata epatoh po, Oturukety imehxo exikety orihtoh pona. Moromeĩpo ytõko mana tytapyĩ taka ropa. ");
INSERT INTO apyNT_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Sero ynyripohpyry omipona ehtoko, opoenõ maro, apakomotyã roropa emero nono pona oytorykohtao. ");
INSERT INTO apyNT_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","— Imepỹ etapahpono tuãnohsẽme exĩko mana, totapasẽme exĩko mana, tonese ahtao asakoro enenanomo a te, tuhkehxo enenanõ ahtao; yrome toiro rokẽ enene ahtao, mokyro onetapara ehtoko. ");
INSERT INTO apyNT_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Ahno totapase ahtao orutua a aorihmapotoh ke tuãnohsẽme exĩko mana. Tineru ke onepehmasaromepyra mana orihpyra toehtohme. Mokyro etapatoko. ");
INSERT INTO apyNT_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Tineru anapoipyra ehtoko roropa toepase exikety wino epatoh taka. Otarame toytory se ropa mã ynororo tytapyĩ taka orihpyra ro Oturukety imehxo exikety ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Ononorykõ onyripyra ehtoko nuriame. Ahno etaparyhtao nuriame nono exĩko mana. Moro toehse ahtao ahno etapahpõkõ totapasẽme exĩko mana nono kurãkatohme ropa. ");
INSERT INTO apyNT_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Omõnõko matose ononorykõ pona osesaritohme. Moro ononorykõ nuriame onyripyra ehtoko, ynara exiryke: Ywy roropa moroto ase. Ywy, Ritonõpo, Izyraeu tõ Esẽ amaro xine ase. ");
INSERT INTO apyNT_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Morarame tamuximãkõ, Kireate ekyry tõ, Makia ekyry, Manase mũkuru, Joze mũkuru, toytose oturuse Moeze tomo a tuisa tõ maro. Ynara tykase toto eya: ");
INSERT INTO apyNT_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","— Ritonõpo Kuesẽkõ nyripohpyry omi poe sero nono tapiakase imenekatoh ke. Aomi poe ro nono tokarose zokonaka yna ekyry Zeropeate a, ẽxiry tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Yrome mokaro nohpo tõ tyniotase ahtao orutua kõ maro, imehnõ oxiekyrymãkõ maro, inonorykõ yna oxiekyrymãkõ kyryryme pyra exĩko mana, moro oxiekyrymãkõ kyryryme exĩko imaro tyniotase ahtao. Morarame moro toehse ahtao yna oxiekyrymãkõ nonory zumo hkopyra exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Mame Jeimamyry Emyhpokatoh ropa toehse ahtao, inonorykõ imehnõ oxiekyrymãkõ kyryryme exĩko imaro tyniotase exiryke, yna oxiekyrymãkõ kyryryme pyra. ");
INSERT INTO apyNT_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Mame ynara tykase Moeze, Ritonõpo nyripohpyry omi poe ro: — Moxiã Joze ekyry tõ zae mã toto. Ritonõpo nyripohpyry Zeropeate ẽxiry tomo a ynara mana: ");
INSERT INTO apyNT_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Inymenekatyã maro niotãko mã toto tumykõ ekyryme ynororo ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Moro sã Izyraeu tõ nonory onytyoromara exĩko mana, toiro oxiekyrymãkõ poe imepỹ pona. Mame Izyraeu tõ tynonory esẽme exĩko mã toto jũme samo, tumy nonory esẽme exĩko mã toto. ");
INSERT INTO apyNT_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Mame ẽxiry tõ emero, nono esẽme toehse ahtao, niotãko mã toto orutua maro, jumy ekyryme ynororo ahtao. ");
INSERT INTO apyNT_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Mame Izyraeu tõ mũkuru tõ nono esẽme exĩko tumykõ myakãme jumy ekyry tõ maro. Nono esẽ onytyoromara mana toiro oxiekyrymãkõ wino imepỹ pona. Emero oxiekyry tõ jũme tynonory esẽme exĩko mana. ");
INSERT INTO apyNT_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","11","Naeroro Makara, Tiriza, Hokara, Miuka, Noa maro, Zeropeate ẽxiry tomo Ritonõpo nyripohpyry omipona toehse toh nexiase. Tyniotase toh nexiase tumykõ ekyry mũkuru tõ maro. ");
INSERT INTO apyNT_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Tyniotase toto Manase ekyry tõ maro, Joze mũkuru, inonorykõ moroto rokẽ nexiase Joze ekyry tõ nonory maro. ");
INSERT INTO apyNT_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Enara nexiase Ritonõpo nyripohpyry tõ Moeze a ekarotohme Izyraeu tomo a moroto nono pipahmã Moape po tuna Joatão ehpiõ po, pata Jeriko etonie. Tuna Joatão mõpoe pata Jeriko nexiase.");
INSERT INTO apyNT_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Sero pape ao Moeze oturutopõpyry tõ mana, inekarohpyry Izyraeu tõ netaryme ona po, tuna Joatão poe xixi tũtatoh wino. Moroto Izyraeu tõ nexiase Joatão jakanahmã po, pata Supe pũto. Xia pata Parã nexiase, mya ynara pata tõ nexiase: Topeu te, Rapã te, Hazerote te, Ti-Zaape, enara. ");
INSERT INTO apyNT_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Ypy Xinai poe pata Kate-Panea pona, 11me ẽmepyry aropõko ytoytokety mana, osema poro ypy tõ rãnakuroko Etõ nonory po.) ");
INSERT INTO apyNT_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Morarame 40me jeimamyry taropose Izyraeu tomo a toesyryhmatopõpyry poe Ejitu poe. Mame ẽmepyry apitorymã po, nuno 11mã po ahno turuse Moeze a emero Ritonõpo nekaropohpyry eya, toto zurutohme. ");
INSERT INTO apyNT_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Morara kynexine Seõ tõ poremãkaxĩpo Moeze a, amoreu tõ tuisary, pata Hexipõ pono, Oke maro, Pasã tuisary, pata Axitarote pono, Eterei põme roropa. ");
INSERT INTO apyNT_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Moape tõ nonory po Izyraeu tõ ahtao, tuna Joatão poe xixi tũtatoh wino, Izyraeu tõ tamorepapitose Moeze a, Ritonõpo nyripohpyry tõ poko, inamorepatoh tonõ poko roropa. Ynara tykase ynororo: ");
INSERT INTO apyNT_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","— Ypy Xinai myhto kuahtao xine, Ritonõpo Kuesẽkõ tõturuse kyya xine, ynara tykase: “Epo mana, tehme oehtohkõ taro. ");
INSERT INTO apyNT_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Seromaroro ytotoko taroino ypy tõ winakoxi amoreu tõ nonory pona, imehnõ nonory pona roropa emero tuna Joatão jakanahmã po, ypy tõ myhto kuroko Juta tõ nonory topohmã poro, ikurenae te, tuna konõto Metiteraneu ehpikoxi roropa. Kanaã nonory apoitoko oesarykõme emero, ypy tõ Ripano poe inikahpozakoxi, mya tuna Eupyrati pona xixi tũtatoh wino. ");
INSERT INTO apyNT_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Sero nono emero ekarõko ase oya xine. Ywy ase Ritonõpo. Jomihpyry etapoase Aparão a, Izake a, Jako a roropa, atamuru tomo, sero nono ekarory poko oya xine, opoenomo a, apakomotyamo a roropa. Naeroro ytotoko moro nono apoise oesarykõme.” ");
INSERT INTO apyNT_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Mame ynara tykase Moeze ahno a: — Ypy Xinai myhto ro kuahtao xine oturuase oya xine: “Toiroro opyno xine ehsaromepyra ase. ");
INSERT INTO apyNT_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Tomãkapose matose Ritonõpo Kuesẽkomo a, tuhke oehtohkõme xirikuato samo kapu poko. ");
INSERT INTO apyNT_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Ritonõpo a, atamurukõ Esemy a, oemãkapory se ro ase tuhkehxo, miume motye oehtohkõme, tymõkomoke roropa oehtohkõme, aomihpyry ae ro! ");
INSERT INTO apyNT_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Yrome toiroro ãpiakasaromepyra xine ase atae pyra oehtohkõ poko. ");
INSERT INTO apyNT_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Naeroro orutua kõ tuaro exiketõ imenekatoko oekyry tomo zuarohxo exiketomo, emese kure exiketõ roropa, otuisarykõme toto ritohme ya.” ");
INSERT INTO apyNT_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","— Mame moro kure nexiase oya xine. “Ỹ, moro tyriry õmihpyry ae ro,” tykase amarokõ ya. ");
INSERT INTO apyNT_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Naeroro tuisa tõ tapoise ya oekyry tõ wino, tuaro exiketomo, emese kure roropa exiketomo tyritohme otuisarykõme. Toitoine miumãkõ tuisaryme toehse; imehnõ 100me exiketõ tuisaryme toehse; imehnõ 50mãkomo; imehnõ 10mãkõ tuisaryme toehse. Mokaro maro imehnõ tuisa tõ tymenekase ya oxiekyry tõ tuisaryme toto ehtohme. ");
INSERT INTO apyNT_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Morarame moro poko jahtao ynara tykase ywy akorehmane tomo a: “Atae pyra ahno aht