﻿USE sofia;
DROP TABLE IF EXISTS sofia.apwNT_vpl;
CREATE TABLE apwNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES apwNT_vpl WRITE;
INSERT INTO apwNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abraham bits’ą́’dí’ hanádaałinolt’įįłíí Jesus Christ, David bá niłtíni nyáázhį’ naltsoos besi’aaníí. ");
INSERT INTO apwNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Isaac Abraham bá hizhchįį; Jacob Isaac bá náánázhchį́; Judas hik’e bik’isyú Jacob bá hizhchįį; ");
INSERT INTO apwNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Thámar, Pháres hik’e Zára Judas yá yishchįį; Ésrom Pháres bá náánázhchį́; Áram Ésrom bá náánázhchį́; ");
INSERT INTO apwNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Amínadab Áram bá náánázhchį́; Náasson Amínadab bá náánázhchį́; Sálmon Náason bá náánázhchį́; ");
INSERT INTO apwNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ráchab, Bóoz Sálmon yá yishchįį; Ruth, Óbed Bóoz yá yishchįį; Jesse Óbed bá hizhchįį; ");
INSERT INTO apwNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","David, ízisgo nant’án nlíni, Jesse bá hizhchįį; Urías n’íí bi’aahíí Sólomon David, ízisgo nant’án nlíni, yá yishchįį; ");
INSERT INTO apwNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Robóam Sólomon bá hizhchįį; Abíah Robóam bá náánázhchį́; Asa Abíah bá náánázhchį́; ");
INSERT INTO apwNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jósaphat Asa bá náánázhchį́; Jóram Jósaphat bá náánázhchį́; Ozías Jóram bá náánázhchį́; ");
INSERT INTO apwNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jóatham Ozías bá náánázhchį́; Áchaz Jóatham bá náánázhchį́; Ezékias Áchaz bá náánázhchį́; ");
INSERT INTO apwNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manásses Ezekías bá náánázhchį́; Ámon Manásses bá náánázhchį́; Josías Ámon bá náánázhchį́; ");
INSERT INTO apwNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Bábylonyú isnáhgo odestįįdá’, áí hadá’ Jechonías, hik’e bik’isyú Josías bá náánázhchį́; ");
INSERT INTO apwNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bábylonyú isnáhgo odestiiníí bikédí’go: Saláthiel Jechonías bá hizhchįį; Zoróbabel Saláthiel bá náánázhchį́; ");
INSERT INTO apwNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abíud Zoróbabel bá náánázhchį́; Elíakim Abíud bá náánázhchį́; Ázor Elíakim bá náánázhchį́; ");
INSERT INTO apwNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sádoc Ázor bá náánázhchį́; Áchim Sadoc bá náánázhchį́; Elíud Áchim bá náánázhchį́; ");
INSERT INTO apwNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleázar Elíud bá náánázhchį́; Mátthan Eleázar bá náánázhchį́; Jacob Mátthan bá náánázhchį́; ");
INSERT INTO apwNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Joseph Jacob bá náánázhchį́, Josephíí Mary holzéhi biką’ nlįį ni’, Maryhíí Jesus, Christ holzéhi, yishchįį. ");
INSERT INTO apwNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Áík’ehgo Abraham bits’ą́’dí’ David neheṉá’zhį’ dį́į́ts’ádah hanáłolchįį; David bits’ą́’dí’ isnáhgo odestįįzhį’ dį́į́ts’ádah hananáłolchįį; áídí’ isnáhgo odestiiníí bits’ą́’dí’ Christ nyáázhį’ dį́į́ts’ádah hananáłolchįį. ");
INSERT INTO apwNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Díí k’ehgo nko Jesus gozlįį: Bą́ą́ Mary holzéhi iłk’idá’ Joseph baa hiiłtįį, ndi doo hwahá yił niiṉéh da ndi Holy Spirit bits’ą́’dí’go biyi’ mé’ silįį. ");
INSERT INTO apwNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yił niiṉéhihíí, Joseph holzéhi, nṉee nłt’éégo at’éhi, Mary doo dénchǫ’égo bich’į’ godigháh hát’į́į́ dahíí bighą, doo hadíń yígółsinégo bił iłk’inásht’aash, nzį. ");
INSERT INTO apwNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Áídá’ yaa ntsekees nt’éégo, nayeełgo Bik’ehgo’ihi’ṉań binal’a’á yaaká’ dí’ihíí bich’į’ hadziigo gáṉíí, Joseph, David biye’ ńlíni, Mary ni’aa ándle’zhį’ doo nénldzid da; hiltsąą siliiníí Holy Spirit bits’ą́’dí’go at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bizhaazhé ishkiinhi goleeh, áí Jesus holzeego ádńlííł: bik’íí binchǫ’íí bits’ą́’zhį’ hasdáyihiṉííł doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bik’ehgo’ihi’ṉań binkááyú na’iziidi áṉíí n’íí begolṉe’go be’ánágót’įįd, gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Isąą, na’ilíhn doo hwahá nṉéh dahíí hiltsąą hileeh, bizhaazhé ishkiinhi goleeh, áí bizhi’íí Emmánuel golzee doleeł, áí, Bik’ehgo’ihi’ṉań nohwił nlįį, golzeego ágolzee. ");
INSERT INTO apwNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Áídí’ Joseph ch’ínádzidgo, Bik’ehgo’ihi’ṉań binal’a’á ábiłnṉiidyú ádzaago Mary yił nṉáá: ");
INSERT INTO apwNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Áídá’ doo yaa naghaa da, bizhaazhé dantsé ishkiinhi gozlįįzhį’; áń Jesus yizhi’ yá áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judéayú Béthlehem golzeegee Jesus gozlįįdá’ Hérod nant’án nlįį lę́k’e, áídá’ ya’áí hanadáhdí’ nṉee daagoyánihi hikai, Jerúsalemzhį’, ");
INSERT INTO apwNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Gádaaṉiigo, Jews binant’a’ gozlįįhíí hayú? Ya’áí hanadáhdí’ bits’iłsǫǫsé dah hiit’įįhíí bighą daahohiikąąhyú dekai. ");
INSERT INTO apwNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hérod nant’án nlíni ła’íí nṉee dawa Jerúsalemyú daagolíni biłgo díí daidezts’ąądá’ doo bił daagozhǫ́ǫ́ da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hérod okąąh yebik’ehi itisyú nadaandeehi ła’íí begoz’aaníí ye’ik’eda’iłchíhi íła’áyíílaago, Hayú Christ goleeh? daayiłṉiigo nayídaadiłkid. ");
INSERT INTO apwNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Áík’ehgo gádaabiłṉii, Judéayú Béthlehem golzeegee; Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí k’e’eshchįįhíí k’ehgo, ");
INSERT INTO apwNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Júda bini’yú Béthlehem ńlííníí, Júdagee nant’án daanliiníí bił dáłedaanłt’éé: nant’án shichągháshé, Israel hat’i’íí, yá nant’aa doleełíí nits’ą́’dí’go goleehíí bighą, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hérod dánant’į’ego nṉee daagoyánihíí yiká o’ił’a’dá’ nayídaadiłkid, Daadá’ ts’iłsǫǫsé dantsé hit’įį silįį? ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Áídí’ Béthlehemyú odaayis’a’ gádaabiłṉiigo, Ishkiin ałts’ísę́ę nłt’éégo biká hadaanohtaa; baa nohkai lę́k’eyúgo shił nanádaagodołṉihgo shíí ałdó’ ákú hoshkąąhyú disháh. ");
INSERT INTO apwNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nant’án áṉííhíí daidezts’ąądá’ dahiskai; hikaahdá’ ya’áí hanadáhdí’go ts’iłsǫǫsé dahs’ąągo daayo’įį n’íí bádįhyúgo hiltǫǫł nt’éégo, ishkiin ałts’ísę́hi sitįįgee bik’ehdí’ dahs’ąą silįį. ");
INSERT INTO apwNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ts’iłsǫǫsé daayiłtsąądá’ dázhǫ́ yaa bił daagozhǫ́ǫ́ lę́k’e; ");
INSERT INTO apwNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Áídí’ kįh yuṉe’ ha’ákaidá’ ishkiin ałts’ísę́híí bą́ą́, Mary holzéhi, yiłgo daayiłtsąądá’, yich’į’ hayaa ádaadzaago daayokąąh: ilínihi nadaayiné’íí yidá’ch’ída’iztąągo óodo, jeeh didlidgo łikągolchini, frankincense holzéhi, ła’íí jeeh nch’í’i, myrrh holzéhi, yaa daizné’. ");
INSERT INTO apwNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nṉee daagoyáni Bik’ehgo’ihi’ṉań, Hérod bich’į’yú nádohkáh hela’, daabiłṉiigo yaa nadaiyeełgo, dabíí bini’yú onákai, łahyúgo. ");
INSERT INTO apwNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Anákaidá’ Bik’ehgo’ihi’ṉań binal’a’á yaaká’dí’hi Joseph bił ch’í’ṉah ánágodlaa nayeełíí bee, gáṉíígo, Nádndáh, mé’ hik’e bą́ą́ biłgo Egyptyú bił nkáh, akú nahísóotąą, nohwił nanágosisṉi’zhį’; Hérod k’ad mé’ yiziłheego yiká hantaa godigháh. ");
INSERT INTO apwNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Áík’ehgo Joseph nádiidzaago mé’ihíí hik’e bąąhíí biłgo tł’é’yú Egyptyú okai. ");
INSERT INTO apwNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hérod daztsąązhį’ da’akú naháztąą: Bik’ehgo’ihi’ṉań binkááyú na’iziidíí áṉíí n’íí, ShiYe’ Egyptdí’ hanṉáh biłdishṉii, nṉiidíí begolṉe’go ágodzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Áídí’ Hérod nṉee daagoyáni bich’į’ nadaazhch’a’go yígołsįįdá’ dázhǫ́ bágóchįįdgo, ishikíń naki bił łedaagodzaadí’ hayaa godezt’i’go dawa natseedgo yengon’ą́ą́ Béthlehemyú, nṉee daagoyáni Jesus yaa nayídaadiłkid n’íídí’ godezt’i’go. ");
INSERT INTO apwNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jéremy, Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí, gánṉiidíí begolne’, ");
INSERT INTO apwNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rámayú ła’ bizhii daidits’ag, daachag ła’íí chaał daadilwosh, Rachel bichągháshé yighą hichago, yati’ inesk’azíí bee bich’į’ yádaach’iłti’ ndi doo hagot’éégo da lę́k’e, bichągháshé da’ádaadįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hérod daztsąądá’ Bik’ehgo’ihi’ṉań binal’a’á yaaká’dí’hi Egyptgee Joseph nayeełíí bee bił ch’í’ṉah ánágodlaa, ");
INSERT INTO apwNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Gáṉíígo, Nádndáh, niye’ hik’e bą́ą́ biłgo Israel hat’i’i bini’yú bił nádnkáh: niye’ daiziłhee hádaat’įį n’íí nanezna’. ");
INSERT INTO apwNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Áídí’ nádiidzaago biye’ hik’e bąąhíí biłgo Israel hat’i’íí bini’yú onákai. ");
INSERT INTO apwNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Arkeláus Judéayú nant’án nanásdlį́į́, bitaa Hérod sitįį n’íígee nnańtłizhgo Joseph ya’ikonzįįdá’, ákú digháhzhį’ neldzid: áík’ehgo bindzeełíí bee Bik’ehgo’ihi’ṉań, Doo ákú ńṉáh da, biłnṉiid, áík’ehgo ni’ łahyúgo Galilee golzeeyú okai. ");
INSERT INTO apwNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Áídí’ kįh gozṉilíí Názareth golzeegee ndaagozle’; Bik’ehgo’ihi’ṉań binkááyú nada’iziidi, Áń Názarene holzee doleeł, daaṉii n’íí begolṉe’go. ");
INSERT INTO apwNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Áí benagowaadá’ John Baptize ágole’íí nṉee yich’į’ yałti’go nyáá, da’igolį́į́yú, Judéa bigodesdzogíí biyi’, gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nohwinchǫ’íí bits’ą́’zhį’ ádaahṉe’, yaaká’yú dahsdaahń nant’aahíí biká’ nagowaa. ");
INSERT INTO apwNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Díínko Esáias, Bik’ehgo’ihi’ṉań binkááyú na’iziidi, yaa yałti’go gáṉíí n’íí, Da’igolį́į́yú hadíńshį dilwosh, NohweBik’ehń bádįhyú iłch’į’daagohłe’, intín iłk’ídezdǫhgo bá ádaahłe’, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John bidiyágé bigháń ha’i’áhíí bighaa alzaa, ikał hilchii biziz alzaa; nágonech’iidi hik’e dziłyú gosnihíí biłgo bihidáń lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Áídá’go Jerúsalemdí’ Judéa dahot’éhé ni’ nagoz’ąądí’ ła’íí túńlííníí Jórdan holzéhi biṉaayú dahot’éhé ni’ nagoz’ąądí’ baa nánzą́ą́, ");
INSERT INTO apwNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Áík’ehgo bi’ádaat’e’ nchǫ’íí yaa nanádaagosṉi’dá’, túńlííníí Jórdan holzéhi biyi’ John baptize ádaabizlaa. ");
INSERT INTO apwNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Phárisees daanlíni hik’e Sádducees daanlíni baptize ádaalṉéhíí yighą neheskaigo yiłtsąądá’ gáyiłṉii, Nohwíí, ch’osh bik’asda’ golį́į́híí k’ehgo daałinołt’įįłíí, hadíń lá nohwádįhyú nohwiniigodilṉe’ goz’aaníí bits’ą́’nohkáh nohwiłnṉiid? ");
INSERT INTO apwNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Da’aṉii nohwinchǫ’íí bits’ą́’ ádaahdzaayúgo ch’í’ṉah ádaadi’nołsį, nest’ą’ nłt’éégo nádaant’į́híí k’ehgo nohwaa daide’aah. ");
INSERT INTO apwNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Abraham bits’ą́’dí’ daadihe’ṉa’i doo ídiłdaadoh’ṉii da: Bik’ehgo’ihi’ṉań díí tséé nazṉilíí nṉee Abraham bits’ą́’dí’ daadihezṉa’híí k’ehgo áile’yúgo áile’, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ch’il nkedn’aagee iłk’idá’ bé’nil’ąądgo ácha nnit’ąą: ch’il dawa doo nest’áń nłt’ééhíí baa dahndéh dayúgo yó’ok’éhgo kǫ’ diltłi’ yuyaa olkaadhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Shihíí tú bee baptize ádaanohwish’įį gádnii, nohwinchǫ’íí bits’ą́’zhį’ ádaasohdzaayúgo: ndi shiké’dí’ ła’ shitisgo at’éhi higháh, bikee hishłeełíí ndi doo bik’eh sitį́į́ da: áń Holy Spirit hik’e kǫ’ yee baptize ádaanohwił’įį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Be’iłch’íhé dahyotįįł, tł’oh nagháí iłch’íhi goz’ąągee nágosho doleeł; binest’ą’híí iłk’eyihiṉiił; áídá’ bizhoolíí kǫ’ doo ntsésihi biyi’ yuyaa yidiłid. ");
INSERT INTO apwNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Áídí’ Jesus Gálileedí’ Jórdan túńlį́į́zhį’ nyáá, John baptize ábile’híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Áídá’ John doo hat’į́į́ dago gáṉíí, Shíígo née shaa ńyaa, shíí ni baptize áshííle’go dábik’ehdá’? ");
INSERT INTO apwNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesus gábiłṉii, Ch’ík’eh ndi nzhǫǫ k’adíí: nzhǫǫgo ágot’eehíí dawa be’iidle’go dábik’eh. Áík’ehgo John baptize ábíílaa. ");
INSERT INTO apwNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus baptize ábi’delzaadá’ tú biyi’dí’ dagoshch’į’ hanádzaa: áídí’ yáá bich’į’ iłts’ą́’ ádzaago Bik’ehgo’ihi’ṉań biSpirit hawú k’ehgo bich’į’ nke’eṉíihgo yiłtsaaníí dábiłgo biká’ dahnezdaa: ");
INSERT INTO apwNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nt’éégo yaaká’dí’go yati’ gáṉíígo yidezts’ąą, Díínko shiYe’ shił nzhóni, áń baa shił gozhǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Áídí’ Jesus Holy Spirit nabiłaago da’igolį́į́yú ch’iidn nant’án nabíntaahyú óyáá. ");
INSERT INTO apwNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dá doo iyáné dizdin behiskąą, áí ąął hiskąądá’ shiṉá’ silįį. ");
INSERT INTO apwNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na’íntaahíí baa nyáágo gábiłṉii, Ni Bik’ehgo’ihi’ṉań biYe’ ńlį́į́yúgo, díí tsééhíí báń náodleeh, nṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Áídá’ Jesus gábiłṉii, Ágágolzeego k’e’eshchįį, Nṉee doo dá báń zhą́ yee hiṉaa da doleeł, áídá’ Bik’ehgo’ihi’ṉań biyati’íí bizé’dí’ behagohigháhíí dawa yee hiṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ch’iidn nant’án godiyįhgo ízisgo kįh gozṉilyú Jesus yił o’áázhgo kįh biyi’ da’ch’okąąhíí ts’ídago goz’aaníí bilatahyú yił n’áázhgo, ");
INSERT INTO apwNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Gánábiłdo’ṉiid, Bik’ehgo’ihi’ṉań biYe’ ńlį́į́yúgo gódah ch’í’ńłt’e’: ágágolzeego k’e’eshchįį, Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí nłt’éégo biṉádaadeh’į́į́ doleeł, ná daayiłdoṉiił: áídí’, Doo tséé hitałgo hayaa ngeeh dahíí bighą anádaanołteeł doo. ");
INSERT INTO apwNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus bich’į’ hananádziigo gábiłṉii, Ágágolzeego k’ená’ishchįį, Bik’ehgo’ihi’ṉań neBik’ehń doo nabíńtaah da. ");
INSERT INTO apwNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Áídí’ dził dázhǫ́ yúdahi biká’yú yił hananát’aazhgo nṉee iłtah at’éégo hadaazt’i’íí dawa ła’íí bi’ízisgo ágot’eehíí bił ch’í’ṉah áyíílaago; ");
INSERT INTO apwNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Gábiłṉii, Díí nagoz’aaníí dawa naa dinish’aa doleeł, hayaa ánṉe’go shonkąąhyúgo. ");
INSERT INTO apwNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus gánábiłdo’ṉiid, Yuwehyú, Satan: ágágolzeego k’ená’ishchįį, Bik’ehgo’ihi’ṉań neBik’ehń zhą́ honkąąh, da áń zhą́ bá na’izíid. ");
INSERT INTO apwNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Áídí’ ch’iidn nant’án bits’ą́’zhį’ onádzaadá’ Bik’ehgo’ihi’ṉań binadaal’a’á yaaká’dí’hi baa hikaigo bich’odaazṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Áídí’ Jesus John ha’áneztįįgo ya’ikonzįįdá’ Gálileeyú óyáá; ");
INSERT INTO apwNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Názarethdí’ dahiyaago Capérnaumyú ngonle’, túsikaaníí bahyú, Zábulon hik’e Néphthalim bigodesdzogíí biyi’: ");
INSERT INTO apwNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Esáias, Bik’ehgo’ihi’ṉań binkááyú na’iziidi, gánṉiid n’íí begolṉe’go, ");
INSERT INTO apwNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zábulon bini’ hik’e Néphthalim bini’ Jórdan túńlį́į́ hanaayú túsikaaníí bich’į’ Gálileeyú, doo Jews daanlįį dahíí bini’yú; ");
INSERT INTO apwNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Godiłhiłyú naháztąą n’íí kǫ’ bená’dindííngo daayiłtsąą; da’itsaah bichagosh’ohyú naháztąą n’íí bich’į’ idindláád silįį. ");
INSERT INTO apwNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Áídí’ godezt’i’go, Nohwinchǫ’íí bits’ą́’zhi’ ádaahṉe’, yaaká’yú dahsdaahń nant’aahíí biká’ nagowaa, ṉiigo Jesus yałti’ nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus túsikaaníí Gálilee holzéhi bahyú higaałdá’, nṉee iłk’isyú naki, Simon, da’áń Peter holzéhi, hik’e bik’isn Andrew łóg behaidlehé nanestł’óli téh nádaayi’aa’go yiłtsąą: áí łóg hadaayihileehíí daanlįį. ");
INSERT INTO apwNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Áík’ehgo gádaayiłṉii, Shiké’ dahdoh’aash; łóg hayihileehíí k’ehgo nṉee shá nádaahohłáhgo ánohwishłe’. ");
INSERT INTO apwNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dagoshch’į’ łóg behaidlehé nanestł’ólihíí da’áígee ndaistsoozdá’ Jesus yiké’ dahn’aazh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Áídí’ dahnádiidzaago iłk’isyú naki naayiłtsąą, James, Zébedee biye’, hik’e bik’isn John, áí bitaa Zébedee biłgo tsina’eełíí yiyi’ naháztąą, biłógbehaidlehé nanestł’ólihíí nádaiłkadgo; áík’ehgo yich’į’ ánṉiid. ");
INSERT INTO apwNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dagoshch’į’ bitaa tsina’eełíí yiyi’ sidaadá’ yits’ą́’ dahn’aazh, Jesus biké’. ");
INSERT INTO apwNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Áídí’ Jesus, Gálileeyú dahot’éhé Jews ha’ánáłséh nagozṉilyú iłch’ígó’aahgo, yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí nłt’éégo baa na’goṉi’íí yaa yałti’go, ła’íí nṉee bitahyú iłtah at’éégo kah yaa nadaakaihíí hik’e daanṉiihíí náyihilziihgo anádaał. ");
INSERT INTO apwNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Syria golzeeyú dáhot’éhé Jesus baa daach’iṉii: ákú iłtah at’éégo daanṉiihíí hik’e kah yaa nakaihíí, góyéégo bich’į’ nadaagowaahíí, ch’iidn yisná ádaabiłsiníí, onádaatłishihíí, ła’íí daadi’ilihíí yił nadaaskaigo Jesus nłt’éégo ánádaayisdlaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Áík’ehgo nṉee łą́ą́go Gálilee, Decápolis, Jerúsalem, Judéa, ła’íí Jórdan túńlííníí hanaadí’hi biké’ anáłseeł lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesus nṉee biké’ anáłseełíí yiłtsąągo dziłyú hayaa: áígee nezdaago bitsiłke’yu ałdó’ baa hikai: ");
INSERT INTO apwNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yił ch’ídaago’aah nkegonyaa, gáṉíígo: ");
INSERT INTO apwNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Hadíí ídaagoch’iyolba’íí biyaa daagozhǫ́ǫ́ le’: yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí itah daanlįį. ");
INSERT INTO apwNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Chaał nadaakaihíí biyaa daagozhǫ́ǫ́ le’: bá nádaagodojǫǫł. ");
INSERT INTO apwNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bijíídí’ isht’edaagodnt’ééhíí biyaa daagozhǫ́ǫ́ le’: ni’gosdzáń dá goz’ąą nt’éégo bíyéé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nzhǫǫgo ágot’eehíí dázhǫ́ hádaat’įįhíí bighą shiṉá’ hik’e dibá’ daanliiníí biyaa daagozhǫ́ǫ́ le’: áí náda’doldįįł. ");
INSERT INTO apwNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bił daagoch’oba’íí biyaa daagozhǫ́ǫ́ le’: bíí ałdó’ baa goch’oba’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bijíí biyi’ daagozhóóníí biyaa daagozhǫ́ǫ́ le’: áí Bik’ehgo’ihi’ṉań daidołtsééł. ");
INSERT INTO apwNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Iłch’į’gont’ééhíí benadaago’aahíí biyaa daagozhǫ́ǫ́ le’: áí Bik’ehgo’ihi’ṉań bichągháshé daabiłdi’ṉii doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nzhǫǫgo ágot’eehíí ye’ádaat’eehíí bighą bich’į’ nadaagoch’inłkaadíí biyaa daagozhǫ́ǫ́ le’: yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí itah daanlįį. ");
INSERT INTO apwNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Shíí shighą nṉee yati’ yee daanohwokáałyúgo, nohwiniidaagodnłsįyúgo, ła’íí łéda’iłchoogo yati’ dénchǫ’éhíí yee nohwaa yádaałti’yúgo, nohwiyaa daagozhǫ́ǫ́ le’. ");
INSERT INTO apwNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nohwił daagozhǫ́ǫ́ le’, dázhǫ́ nohwił daagozhǫ́ǫ́ le’: yaaká’dí’go ízisgo ágot’eehíí nohwaa hi’né’ doleeł: nohwíí dánohwintségo Bik’ehgo’ihi’ṉań binkááyú nada’iziid n’íí da’ágát’éégo bich’į’ nadaagoch’inłkaad ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nohwíí ni’gosdzáń bi’ishįįh daanohłįį: áídá’ ishįįhíí doo nk’ǫ́ǫ́zh da silįįyúgo, nt’é bee nk’ǫ́ǫ́zh ánálṉe’? Doo nt’é bee nłt’éé da, daazhógo ch’élkáadgo biká’ nach’ikai doo. ");
INSERT INTO apwNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nohwíí ni’gosdzáń biká’ nṉee bá’idindláádíí daanohłįį. Dził biká’yú ízisgo kįh nagozṉil dahgoz’ąąyúgo, doo hagotéégo nant’į’ da. ");
INSERT INTO apwNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ła’íí ik’ah kǫ’íí ch’idnłtłah lę́k’eyúgo, doo táts’aa bił hayaa nch’i’áah da go’į́į́, áídá’ ik’ah kǫ’íí biká’ dahnásiłt’áhé biká’ dahch’iłt’aah go’į́į́; áík’ehgo hadíí kįh yuṉe’ naháztaaníí dawa yee daago’įį. ");
INSERT INTO apwNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nṉee biṉááł nohwits’ą́’ idindláád le’, áík’ehgo nłt’éégo ánádaaht’įįłíí daayo’įįgo nohwiTaa yaaká’yú dahsdaahń ízisgo at’ééhíí bee ch’í’ṉah ádaanołsį. ");
INSERT INTO apwNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Bik’ehgo’ihi’ṉań yegos’aaníí dagohíí Bik’ehgo’ihi’ṉań binkááyú nada’iziid n’íí bek’e’eshchiiníí doo ánábiyishdįįhyú níyáá daashoh’ṉíí da: doo ánábiyishdįįhyú níyáá da, áídá’ dawa begolṉe’go níyáá. ");
INSERT INTO apwNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Da’aṉii gánohwiłdishṉii, Yáá hik’e ni’gosdzáń biłgo bech’ígoṉáhzhį’ begoz’aaníí biyi’dí’ ayą́hágo isdzohíí ła’íí dahts’idiłhiłíí doo daazhógo dá dahgoz’ąą nt’éégo da, ąął alzaazhį. ");
INSERT INTO apwNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hadíń díí Bik’ehgo’ihi’ṉań yegos’aaníí ayą́hágo ágot’eehíí ndi doo yikísk’eh at’éé dahíí, ła’íí áík’ehgo nṉee yił ch’ídaago’aahíí, áń yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí bitahyú dázhǫ́ doo ílį́į́ dahíí bee hojíí doleeł: áídá’ hadíń díí begoz’aaníí yikísk’eh at’ééhíí ła’íí yee iłch’ígó’aahíí, áń yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí bitahyú ízisgo at’ééhíí bee hojíí doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Begoz’aaníí ye’ik’eda’iłchíhi hik’e Pharisees daanlíni bitisgo nłt’éégo ádaanoht’eeyúgo zhą́ yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí itah daahłeeh go’į́į́, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Doo áníidá’ díí k’ehgo nṉee bángot’ąągo daadesots’ąą ni’, Doo iziłhéé da; hadíń izis‐hįį’íí góyéégo bágoz’áni at’éé, golzeego: ");
INSERT INTO apwNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Áídá’ gádaanohwiłdishṉii, Hadíń bik’isn doo nt’é bighą dayú yik’enṉiihíí góyéégo bágoz’áni at’éé: hadíń bik’isn, Ráca, yiłṉiihíí baa yá’iti’go bágoz’áni at’éé: hadíń bik’isn, Doo gonyą́ą́ da, yiłṉiihíí ch’iidn bikǫ’ diltłi’ yuyaa bágoz’áni at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Áík’ehgo bech’okąąhíí biká’ dahnási’ṉiłíí goz’ąągee nt’éhéta Bik’ehgo’ihi’ṉań baa nánné’yúgo, nik’isn bił dahgosíńł’ąąhíí bínálṉiihyúgo; ");
INSERT INTO apwNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Da’áígee da’ch’okąąh goz’ąągee nt’éhéta nánné’ n’íí siné’dá’ nik’isn bich’į’ nṉáhgo iłk’ínágodołdǫǫh; áídí’ t’ąązhį’ nádńdáhgo áníita Bik’ehgo’ihi’ṉań baa nánné’. ");
INSERT INTO apwNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Hadíń naa dahgoz’aaníí dagoshch’į’ bił iłk’ínágodnłdǫ́ǫh, yáná’iti’héyú bił hi’ashdá’; dahyúgohíí dánko aayánáltihíí yaa nide’ahi at’éé, aayánáltihíí aasitíni yaa niłtéehgo ha’aniłt’e’. ");
INSERT INTO apwNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Da’aṉii doo ch’ínánódáh át’éé da, dá ąął na’íńṉilgo zhą́, niłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Doo áníidá’ ágádaach’iṉiigo ba’ikodaanohsį láń shį, Doo nant’į’ nahkai da, golzeego: ");
INSERT INTO apwNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Áídá’ shíí gádaanohwiłdishṉii, Nṉee isdzán dázhǫ́ hát’į́į́go dénchǫ’égo yineł’įįdíí iłk’idá’ bijíí biyi’ yuyaa nant’į’ deyaa. ");
INSERT INTO apwNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Niṉáá dihe’nazhiṉéégohíí nchǫ’go ánát’įįł áníłsįyúgo ha’aahgo yó’ołṉe’: nits’í łahzhį’ da’ádįhyúgo doo nzhǫǫ da, áídá’ nits’í dabiighago ch’iidn bikǫ’ diltłi’ yuyaa, hell holzéhi, oni’dolt’e’yúgo itisgo doo nzhǫǫ da. ");
INSERT INTO apwNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nigan dihe’nazhiṉéégohíí nchǫ’go ánát’įįł áníłsįyúgo nadnłgeeshgo yó’ołt’e’: nits’í łahzhį’ da’ádįhyúgo doo nzhǫǫ da, áídá’ nits’í dabiighago ch’iidn bikǫ’ diltłi’ yuyaa oni’dolt’e’yúgo itisgo doo nzhǫǫ da. ");
INSERT INTO apwNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Gánádaadi’ṉii ni’, Hadíń bi’aa yó’onáyíłt’e’ hat’ííníí, naltsoos yiká’ iłk’ínát’aash: ");
INSERT INTO apwNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Áídá’ shíí gádaanohwiłdishṉii, Hadíń bi’aa doo nṉee ła’ yił nant’į’ na’aash dadá’ yił iłk’ínát’aazhyúgo, nant’į’ naghaago áile’: hadíń isdzán yó’ołt’e’ n’íí yił nṉááyúgo, áí nṉeehíí yił nant’į’ na’aash hileeh. ");
INSERT INTO apwNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Doo áníidá’ gádaach’iṉiigo ba’ikonaadaanohdzį láń shį, Doo daazhógo nitł’a dahnádinlṉiih da le’, áídá’ Bik’ehgo’ihi’ṉań binadzahgee hagot’éégo ánṉiihíí k’ehgo áńle’: ");
INSERT INTO apwNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Áídá’ shíí gádaanohwiłdishṉii, Doo yaaká’ bee nohwitł’a dahnádaadidołṉiih da; áígee Bik’ehgo’ihi’ṉań nant’aago dahsdaahíí bighą: ");
INSERT INTO apwNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ła’íí doo ni’gosdzáń bee nohwitł’a dahnádaadidołṉiih da; áí Bik’ehgo’ihi’ṉań dahnádil’iséhi at’éé: doo Jerúsalem ndi bee da; áí ízisgo kįh gozṉilíí nant’án ízisíí golínihi at’ééhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Doo nitsits’in ndi bee nitł’a dahnádinlṉiih da, nitsizíl dała’á ndi doo łigaigo dagohíí diłhiłgo áóléh át’éé dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ha’oh, dagohíí, Dah, zhą́ daadohṉii, doo nohwitł’a dahnádaadidołṉiih da ndi da’aṉiigo ádaadohṉii: ła’ihíí nchǫ’ihíí bits’ą́’dí’go at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Doo áníidá’ gádaadi’ṉiigo ba’ikodaanohsį láń shį, Nohwiṉáá hayi’ą́ą́yúgo biṉáá hanádoh’aał, nohwiwoo hayi’ą́ą́yúgo biwoo hanádoh’aał: ");
INSERT INTO apwNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Áídá’ shíí gádaanohwiłdishṉii, Nṉee nchǫ’go nohwich’į’ at’ééhíí doo bich’į’ t’ąązhį’ ádaanoht’ee da: hadíń nitł’aah yonłts’į́yúgo, łahzhiṉéé bich’į’ nnanínt’aah. ");
INSERT INTO apwNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Dahadíń ni’íí bighą naa yá’iti’dá’ nahayiiłtsóozyúgo, ni’íícho ałdó’ doo baa ńchį’ da. ");
INSERT INTO apwNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Dała’á dahgostǫ’yú nińdeyoodyúgo, nakidn dahgostǫ’yú bił n’áash. ");
INSERT INTO apwNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hadíń dant’éhéta níyókeedíí baa nné’, hadíń dant’éhéta bá ch’íńné’yúgo doo bich’į’ t’ąązhį’ hóńtą’ da. ");
INSERT INTO apwNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Doo áníidá’ gánádaadi’ṉiigo ba’ikonaadaanohdzį láń shį, Nit’ahdí’ gólííníí zhą́ nił nzhǫǫdá’ nik’enṉiihíí bik’enṉíih le’. ");
INSERT INTO apwNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Áídá’ shíí gádaanohwiłdishṉii, Nohwik’enṉiihíí nohwił daanzhǫǫ le’, yati’ yee daanohwokáałíí biyaa daagozhǫ́ǫ́ doleeł daahoh’ṉíí le’, hadíí bił daanołchǫ’íí nłt’éégo bich’į’ ádaanoht’ee le’, nchǫ’go nohwich’į’ ádaat’eehíí ła’íí nohwiniidaagodnłsiníí bá da’ohkąąh le’; ");
INSERT INTO apwNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Áík’ehgo nohwiTaa yaaká’yú dahsdaahń bizhaazhé daanohłįį: áń nchǫ’íí hik’e nzhǫǫhíí dáłełt’eego biká’zhį’ ya’áí hanadáhgo áyíłsį, nłt’éégo at’ééhíí hik’e doo dábik’ehyú ádaat’ee dahíí dáłełt’eego biká’ nagołtįįhgo áyíłsį. ");
INSERT INTO apwNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hadíí bił daanohshooníí zhą́ nohwił daanzhǫǫyúgo, nt’é bighą nohwich’į’ nahi’ṉííł? Tax bich’į’ nadaahi’ṉiiłíí ndi hadíí yił daanzhooníí bił daanzhǫǫ ya’? ");
INSERT INTO apwNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nohwik’isyú zhą́ bilák’e nádaadołṉihyúgo, ła’ihíí hant’é bee bitisgo ádaanoht’ee? Tax bich’į’ nadaahi’ṉiiłíí ałdó’ da’ágát’éé ya’? ");
INSERT INTO apwNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Áík’ehgo nohwiTaa yaaká’yú dahsdaahń dázhǫ́ nłt’éégo at’éé, nohwíí ałdó’ ágádaanoht’ee le’. ");
INSERT INTO apwNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Doo dá nṉee binadzahgee zhą́ nṉee bich’į’ nłt’éégo ádaanoht’ee da, daazhógo dédaanohwinił’įįhíí bighą: ágádaaht’įįyúgo nohwiTaa yaaká’yú dahsdaahń bits’ą́’dí’ doo nt’é nohwich’į’ naho’ṉííł át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tédaat’iyéhíí dant’éhéta baa nné’ lę́k’eyúgo, doo nádįh higaałíí bésh dilwoshé yee aṉiigo da, daanzhǫǫ ádaadil’iiníí Jews ha’ánáłséh nagozṉil yuṉe’ ła’íí intínyú nṉee bada’ołííhíí bighą ágádaat’įįhíí k’ehgo doo áńt’įį da. Da’aṉii gánohwiłdishṉii, Iłk’idá’ áí bich’į’ nahasṉili at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Áídá’ tédaat’iyéhíí dant’éhéta baa nné’yúgo nigan dihe’nazhiṉéé ánát’įįłíí ne’eshganzhiṉééhíí doo yígółsį da le’. ");
INSERT INTO apwNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dánant’į’ego baa nné’: áík’ehgo dánant’į’ego ánáda’ch’ol’įįł ndi yo’iiníí, niTaa, da’áń nṉee binadzahgee nich’į’ nado’oṉiłi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Onkąąhgee doo daanzhǫǫ ádaadil’įįhíí k’ehgo áńt’éégo da: áí ha’ánázéh yuṉe’ ła’íí iłk’ída’itingee nazįįgo da’okąąhgo bił daagozhǫ́ǫ́, nṉee daabineł’į́į́go. Da’aṉii gádaanohwiłdishṉii, Iłk’idá’ áí bich’į’ nahasṉili at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Áídá’ ni, onkąąhyúgo, ntééh yuṉe’ ha’ánṉáhgo, ídił da’déntį́įhdá’ niTaa nagont’į’yú honkąąh; áń dánant’į’ego ánáda’ch’ol’įįł ndi yo’iiníí, niTaa, da’áń nṉee binadzahgee nich’į’ nado’oṉiłi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Da’ohkąąhgee be’ádaadohṉiihíí doo dayúweh doo nt’é bighąyú be’ádaadohṉii da, doo Jews daanlįį dahíí ádaat’eehíí k’ehgo: áí łą́ą́go yádaasiilti’yúgo zhą́ Bik’ehgo’ihi’ṉań nohwidits’ag, daanzį. ");
INSERT INTO apwNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Doo áík’ehgo ádaanoht’ee da: nohwiTaa hant’é bídaanohdįįhíí yígółsį, t’ah doo hwahá bíhóhkeed da. ");
INSERT INTO apwNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Díí k’ehgo nkó da’ohkąąh: NohwiTaa yaaká’yú dahsíńdaahíí, Nizhi’íí dilzįhgo bígózįh le’. ");
INSERT INTO apwNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nant’án ńlį́į́híí begodowáh. Hagot’éégo ánṉiiyú yaaká’yú benagowaahíí k’ehgo ni’gosdzáń biká’yú ałdó’ begodolṉííł. ");
INSERT INTO apwNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Díí jįį daahiidąą doleełíí nohwá ágonłsį́. ");
INSERT INTO apwNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Hadíí nchǫ’go nohwich’į’ ádaaszaahíí bighą baa nágodent’ąąhíí k’ehgo néé ałdó’ nchǫ’go ádaasiidzaahíí bighą nohwaa nádaagodin’áah. ");
INSERT INTO apwNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nanohwída’dintaah yuṉe’ onohwoṉííł hela’, áídá’ nchǫ’go at’ééhíí bits’ą́’zhį’ hanánohwihi’ṉííł: Dahazhį’ dawa bá nant’áá, ła’íí ninawodíí itisyú át’éhi, ła’íí ízisgo áńt’éhi dahazhį’ bee síńzįį doleeł. Doleełgo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nṉee binchǫ’híí bighą baa nádaagodeso’ąąyúgo, nohwiTaa yaaká’yú dahsdaahń ałdó’ nohwaa nágode’aahi at’éé: ");
INSERT INTO apwNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Áídá’ nṉee binchǫ’híí bighą doo baa nádaagodeso’ąą dayúgo, nohwiTaa ałdó’ doo nohwaa nágode’aahi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Dáshiṉá’ da’ohkąąh lę́k’eyúgo, daanzhǫǫ ádaadil’íni doo k’ehgo adaanoht’ee da: áí dáshiṉá’ da’okąąhgee ídaadaagoch’iyolba’go binii hago áńdaayol’įįł, nṉee dáshiṉá’ oshkąąhíí yídaagołsį le’, daanzigo. Da’aṉii gádaanohwiłdishṉii, Iłk’idá’ áí bich’į’ nahasṉili at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Áídá’ ni dáshiṉá’ onkąąh lę́k’eyúgo, nitsizíl nnłtłag, ninii táńgis; ");
INSERT INTO apwNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Áí bee nṉee dáshiṉá’ onkąąhíí doo yídaagołsį da, niTaahíí zhą́ na’gont’į’ ndi yígółsį: áík’ehgo dánant’į’ego ánáda’ch’ol’įįł ndi yo’iiníí, niTaa, da’áń nṉee binadzahgee nich’į’ nado’oṉiłi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ni’gosdzáń biká’ dawahá nohwił da’ilííníí doo nadaanohṉíí da, dánko gółchoozhi nohwits’ą́’ da’iyąą, beshihii nohwits’ą́’ dichíh, ła’íí da’in’įįhíí nohwee dain’įįh: ");
INSERT INTO apwNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Áídá’ yaaká’yú zhą́ nada’nohṉíí, akúyúgo zhą́ gółchoozhi doo nohwits’ą́’ da’iyąą da, béshihíí doo nohwits’ą́’ dichíh da, ła’íí da’in’įįhíí doo nohwee daino’į́įh at’éé da: ");
INSERT INTO apwNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Dahayú nohwił ilíni siṉilyú, áí zhą́ baa natsídaahkees doo. ");
INSERT INTO apwNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Koṉáá’íí kots’í bikǫ’i at’éé: áík’ehgo koṉáá nłt’ééyúgo kots’í dahot’éhé bikǫ’ golíni at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Áídá’ koṉáá doo nłt’éé dayúgohíí, kots’íhíí dahot’éhé diłhiłi at’éé. Koyi’ ná’dindíín n’íí kots’ą́’ diłhił silįįyúgo, áí dázhǫ́ diłhiłi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Doo hadíń binant’a’ naki da, dała’á bił nchǫ’dá’ ła’ihíí bił nzhǫǫ doleełi at’ééhíí bighą; dagohíí dała’á yotą’dá’ ła’ihíí yich’ołaa doleełi at’éé. Bik’ehgo’ihi’ṉań hik’e hágółdzilíí dáła’ doo hagot’éégo bá na’ch’iziidi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Áí bighą gádaanohwiłdishṉii, Nohwi’ihi’ṉa’íí doo baa nohwił daagoyéé da le’, hant’éshą’ hishąą doleeł, daanohsįgo; dagohíí nohwits’í doo baa nohwił daagoyéé da le’, hant’éshą’ ágoshdle’, daanohsįgo. Ya’ idáńhíí ihi’ṉaahíí bitisgo ilįį gá, ya’ diyágé kots’íhíí bitisgo ilįį gá? ");
INSERT INTO apwNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Dlǫ́’ yúdahyú nada’iṉiihíí baa natsídaahkees: doo k’eda’dilee da, doo náda’igeesh da, doo hayú binon’iłk’edaayihiṉiiłíí bá gową goz’ąą da; da’ágát’éé ndi nohwiTaa yaaká’yú dahsdaahń bá da’diiné’. Ya’ nohwíí áí bitisgo da’inohłįį gá? ");
INSERT INTO apwNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nohwitahyú hadíń daahołṉeezíí yaa natsékeesíí zhą́ bee ayą́hágo ndi ts’ídag ńdiłséhgo ádidle’ gá? ");
INSERT INTO apwNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Hant’é bighą diyágé baa nohwił daagoyéé? Tł’oh dénzhónéhíí baa natsídaahkees; doo nada’iziid da, doo da’itł’ool da ndi nłt’éégo daanołseeł: ");
INSERT INTO apwNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Da’ágát’éé ndi Sólomon ízisgo at’éé lę́k’e ndi doo díí tł’oh dénzhóné k’ehgo ík’e’isdlaa da, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tł’oh díí jįį nołseełíí, áídí’ iskąą daadidlidíí ndi Bik’ehgo’ihi’ṉań nłt’éégo bik’e’isłaadá’ danilt’eego ya’ áí tł’ohíí bitisgo Bik’ehgo’ihi’ṉań nohwik’e’isłaa gá, nohwíí nohwi’odlą’ ádaayą́háhi? ");
INSERT INTO apwNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Áík’ehgo, Hant’é da’iidąą shįhíí? dagohíí, Hant’é da’iidląą shįhíí? dagohíí, Hant’é ádaagohiidle’ shįhíí? doo daadohṉiigo baa nohwił daagoyéé da le’. ");
INSERT INTO apwNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Doo Jews daanlįį dahíí áí zhą́ itisgo hádaat’į́į́:) áídá’ áí dawa bídįh daanohłįįhíí nohwiTaa yaaká’yú dahsdaahń yígółsį. ");
INSERT INTO apwNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí hik’e bits’ą́’dí’ nzhǫǫgo ágot’eehíí ntsé biká hádaaht’įį; áík’ehgo díí dawahá ałdó’ nohwíyéé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Áík’ehgo yiskąągo hago ágot’eehíí doo baa nohwił daagoyéé da le’: áí dabíí na’ídintł’og ndi at’éé. Dała’á jįį nagontł’ogíí da’áí zhą́ dábik’eh. ");
INSERT INTO apwNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Doo hadíń baa nádaaht’įį da le’, áík’ehgo nohwíí ałdó’ doo nohwaa nádaach’it’įį da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aanádaaht’įįhíí k’ehgo nohwíí ałdó’ nohwaa nádaach’it’įį doleeł; dáhołąągo kaa daasohné’ láń shį n’íí k’ehgo da’ágáhołąągo nohwaa nádo’né’. ");
INSERT INTO apwNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hant’é bighą nik’isn biṉáá yuṉe’ tsį ałts’ísę́ę sitaaníí hí’į́į́, áídá’ nihíí niṉáá yuṉe’ tsį nchaahi sitaaníí doo hí’į́į́ da? ");
INSERT INTO apwNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ni niṉáá yuṉe’ tsį nchaahi sitąądá’, hagot’éégo nik’isn gáłnṉii, Shik’isn, ai tsį ałts’ísę́ę niṉáá yuṉe’ sitaaníí ná haoshtįįh? ");
INSERT INTO apwNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ni, nzhǫǫ ídńł’íni, ntsé niṉáá yuṉe’ tsį nchaahi sitaaníí hatįįh; áík’ehgo nłt’éégo go’į́į́ nleehgo áníita nik’isn biṉáá yuṉe’ tsį ałts’ísę́ę sitaaníí bá hatįįh. ");
INSERT INTO apwNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nt’é dilziníí doo gósé baa daahohṉiił da, ła’íí nohwiyo’ nłt’éhihíí doo góchi bich’į’ odaahołkaad da, ágádaaht’įįyúgo dánko yiká’ nakai doleeł, áídí’ nohwich’į’ nádiikeego nohwik’idahjeeh. ");
INSERT INTO apwNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ídaadohkeed, áík’ehgo hant’é ídaadohkeedíí nohwaa hi’né’hi at’éé; hádaadoh’į́į́, áík’ehgo hant’é hádaadoh’iiníí nádaadohné’hi at’éé; dáádítį́h ńdaanołts’į, áík’ehgo nohwá ch’í’ítįįhi at’éé: ");
INSERT INTO apwNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Hadíń ídókeedíí baa hi’né’hi at’éé; hadíń hádéz’iiníí hant’é hádéz’įį shįhíí náidiné’hi at’éé; hadíń dáádítį́h ńdaałts’įhíí bá ch’í’ítįįhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nohwitahyú ła’ nṉee biye’ golíni, biye’ báń bíyókeedyúgo, ya’ tséégo yaa yi’aah gá? ");
INSERT INTO apwNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Dagohíí łóg bíyókeedyúgo, ya’ ch’oshgo yaa yiłteeh gá? ");
INSERT INTO apwNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Daanołchǫ’ ndi nohwichągháshé nt’é nłt’éhi baa hi’né’íí bídaagonołsįyúgo, itisgo nohwaa natsekeesgo nohwiTaa yaaká’yú dahsdaahń hadíń dant’éhéta nłt’éhihíí bíyókeedíí yaa yiné’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Áík’ehgo nṉee hagot’éégo nohwich’į’ ádaat’eego hádaaht’įįhíí k’ehgo nohwíí ałdó’ bich’į’ ágádaanoht’ee: áí Bik’ehgo’ihi’ṉań yegos’aaníí hik’e binkááyú nada’iziid n’íí ye’iłch’ídaago’aahíí bik’ehgohi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ágołts’ósę́go ch’ígót’i’yú ch’ínohkáh: nteelgo ch’ígót’i’ihíí, goteelgo intínhíí góyéé nágost’ąąyú intín, łą́ą́go ákóṉe’ ha’ánáłséh. ");
INSERT INTO apwNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ágołts’ósę́go ch’ígót’i’ihíí, ágołts’ósę́go intínhíí, áí zhą́ ihi’ṉaa bich’į’ intín, da’akwííyé zhą́ ákú ch’ekáh, doo łą́ą́go da. ");
INSERT INTO apwNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Bik’ehgo’ihi’ṉań binkááyú nada’iziidíí ádaadil’íni baa daagonohsąą, áí dibełį́į́ bikágéhíí daabidiyágégo nohwaa hikáh, áídá’ biyi’ yuyaahíí ma’cho dázhǫ́ shiṉá’ daanliiníí k’ehgo at’éhi ádaat’ee. ");
INSERT INTO apwNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Dá binest’ą’híí bee bídaagonołsį doleeł. Ya’ dahts’aa’íí hosh baa ndaach’ihiṉiił née, née figs kǫ’dahosh baa ndaach’ihiṉiił née? ");
INSERT INTO apwNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ch’il nłt’éhihíí nest’áń nłt’ééhíí bah dahnándahi at’éé; áídá’ ch’il dénchǫ’éhíí nest’ą́ń dénchǫ’éhíí bah dahnándahi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ch’il nłt’éhihíí doo nest’áń dénchǫ’éhíí bah dahnándahi at’éé da, ła’íí ch’il dénchǫ’éhíí doo hagot’éégo nest’án nłt’éhihíí bah dahnándahi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ch’il dawa doo nest’áń nłt’ééhíí bah dahndéh dayúgo, yó’ok’éhgo kǫ’ diltłi’ yuyaa olkaadhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Áík’ehgo binest’ą’ihíí bee bídaagonołsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","SheBik’ehń, sheBik’ehń, daashiłṉiihíí doo dawa yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí itah daaleeh da; hadíń shiTaa yaaká’yú dahsdaahń aṉiihíí yikísk’eh at’ééhíí zhą́ itah daaleeh. ");
INSERT INTO apwNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Áí bijįį nṉee łą́ą́go gádaashiłṉii doleeł, NohweBik’ehń, nohweBik’ehń, ya’ doo daanónjiigo Bik’ehgo’ihi’ṉań nohwinkááyú yałti’ da láń? Ya’ doo nich’į’ ádaan’ṉiigo ch’iidn hadaaniidzood da láń? Ya’ doo nizhi’ biláhyú ízisgo ánágot’įįłíí be’ádaant’ee da láń? ");
INSERT INTO apwNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nohwíí doo nohwídaagonsini ádaanoht’ee da: yúwehzhį’ nohkáh, nchǫ’go ádaaht’íni, biłdidishṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Dahadíń shíyésts’ąągo shiyati’ yikísk’eh at’ééhíí díí k’ehgo nkó at’éhi at’éé: nṉee goyáni tséé yiká’ bigową ágodlaa: ");
INSERT INTO apwNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Łą́ą́go nanágołtįį, ła’íí tú ná’dijoł, ła’íí bigową bich’į’ nádiyoł; ndi doo nagongeeh da: tséé biká’ goz’ąąhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Áídá’ dahadíń shíyésts’ąą ndi shiyati’ doo yikísk’eh at’éé dahíí, díí k’ehgo nkó at’éhi at’éé: nṉee doo goyánihi sáí biká’ bigową ágodlaa: ");
INSERT INTO apwNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Łą́ą́go nanágołtįį, ła’íí tú ná’dijoł, ła’íí bigową bich’į’ deyolgo nangóngo’: gową nabígoztł’įįh silįį. ");
INSERT INTO apwNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus áí ąął yaa nagosṉi’dá’ iłch’ígon’ą́ą́híí bighą nṉee bił díyadaagot’ee lę́k’e: ");
INSERT INTO apwNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yebik’ehíí k’ehgo yił ch’ígó’aahíí bighą, doo nṉee begoz’aaníí ye’ik’eda’iłchíhi ádaat’eehíí k’ehgo da. ");
INSERT INTO apwNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Dził biká’dí’ nkenádiidzaadá’ łą́ą́go biké’ anázeeł lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nt’éégo ła’ nṉee łóód doo ínádįh dahi, léprosy holzéhi, yaa nagháhi biyahzhį’ hayaa adzaago gábiłṉii, SheBik’ehń, náshíńlziihíí bik’e síńtįįgo nígonsį, háńt’įįyúgo náshíńlziih. ");
INSERT INTO apwNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Áík’ehgo Jesus yich’į’ dahdidilṉiidí’ yiká’ ndelṉiihgo, Hasht’į́į́; nándziih, yiłṉii. Áí dábiłgo łóód n’íí ínásdįįd lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Áídí’ Jesus gábiłṉii, Hadíń dánko bił nagolṉí’ hela’; ti’i, okąąh yebik’ehi bich’į’ ch’í’ṉah ádndle’go, nt’éhéta be’okąąhíí Bik’ehgo’ihi’ṉań baa nné’, Moses ngon’ą́ą́ lę́k’ehíí k’ehgo, áík’ehgo nándziihíí nṉee yídaagołsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus Capernaum golzeeyú ńyáádá’, áígee silááda dała’á gonenadín binant’a’íí nábokąąhgo baa nyáágo, ");
INSERT INTO apwNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Gábiłṉii, ShiNant’a’, shána’iziidíí di’il silínihi yaat’éégo bił na’diṉi’go gowąyú sitįį. ");
INSERT INTO apwNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus gábiłṉii, Ákú disháhgo naszíih. ");
INSERT INTO apwNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Silááda nant’án gábiłṉii, ShiNant’a’, shigową yuṉe’ ha’ánṉáhgo ndi doo bik’eh sitį́į́ da: déhadziihgo ndi shána’iziidi nadzíih ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Shíí ałdó’ shinant’a’ golį́į́, shihíí silááda bá nansht’aa: dała’á, Dah nṉáh, biłdishṉiiyúgo dahdigháh; ła’íí, Yushdé’, biłdishṉiiyúgo shaa higháh; ła’íí shána’iziidi, Díí áńle’, biłdishṉiiyúgo áí áíle’. ");
INSERT INTO apwNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesus áí yidezts’ąądá’ débiłdíyagodzaago nṉee biké’ náłseełíí gáyiłṉii, Da’aṉii gádaanohwiłdishṉii, Israel hat’i’íí bitahyú ndi doo hadíń díí k’ehgo bi’odlą’ golíni baa nsháh da. ");
INSERT INTO apwNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ła’íí gánádish’ṉii, Łą́ą́go ya’áí hanadáhdí’ ła’íí ya’áí onadáhdí’ nihikáhgo, Abraham hik’e Isaac ła’íí Jacob yił dahnáhaztąą doleeł, yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí bitah: ");
INSERT INTO apwNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Áídá’ nṉee, yaaká’yú dahsdaahń bilałtł’áhgee daanlįį le’at’éé n’íí, chagołheeł yuṉe’ ohilkaad doo: áígee daach’ichag hik’e kowoo łídaach’idiłk’ash doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesus silááda binant’a’íí gáyiłṉii, Nádńdáh; hagot’éégo osíńdląądíí da’áí k’ehgo ná begolzaa. Áík’ehgo silááda binant’a’ bána’iziidihíí da’áígee dagoshch’į’ nadziih. ");
INSERT INTO apwNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Áídí’ Jesus Peter bigową yuṉe’ ha’ayáádá’ Peter bi’aahíí bimaa nezgaigo sitįįgo yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bigan yedelṉiih, áík’ehgo nezgai n’íí bits’ą́’ gonyáá: áídí’ nádiidzaago yá da’dezné’. ");
INSERT INTO apwNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Áídí’ o’i’ą́ą́zhį’ godeyaago łą́ą́go ch’iidn isná ádaabiłsiníí bich’į’yú yił neheskai: áík’ehgo hadaadzi’íí zhą́ bee ch’iidn hainiheyood, ła’íí daanṉiihíí dawa nádaayilziih: ");
INSERT INTO apwNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Esáias, Bik’ehgo’ihi’ṉán binkááyú na’iziidi, gánṉiid n’íí begolṉe’go, Néé doo daanldzil dahíí, ła’íí nohwikah n’íí dawa dabízhą́ ídá’áyiidlaa. ");
INSERT INTO apwNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesus biṉaayú nṉee łáni íła’at’ééhíí yiłtsąądá’, Hanaazhį’ nohwił nada’do’eeł, nṉiid. ");
INSERT INTO apwNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Áígee begoz’aaníí ye’ik’e’iłchíhi baa nyáágo gábiłṉii, Iłch’ígó’aahíí, dahayú anadááłyú niké’ anáshdaał doo. ");
INSERT INTO apwNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus gábiłṉii, Ma’ ndi bi’i’áń daagolį́į́, dlǫ́’ yúdahyú nada’iṉiihíí ndi bit’oh daagolį́į́; áídá’ shíí nṉee k’ehgo Niyááhíí doo hayú nshteehi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ła’ bitsiłke’yuhíí gábiłṉii, ShiNant’a’, haląą shitaa ntsé łehishteehyú dósha’. ");
INSERT INTO apwNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus gábiłṉii, Shiké’ híṉááł; áídá’ nanezna’íí dabíí łedaałii’ṉiił le’. ");
INSERT INTO apwNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Áídí’ tsina’eełíí yehiyaadá’ bitsiłke’yu ałdó’ ehikai. ");
INSERT INTO apwNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nt’éégo tú yat’éégo bił deyol, áík’ehgo tsina’eełíí tú nádidáhíí beh nádilk’ooł: áídá’ Jesus‐híí iłhosh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Áík’ehgo bitsiłke’yu bich’į’ nnikaigo ch’ínádaabisidá’ gádaaṉii, NohweBik’ehń, hasdánohwiṉííł: dak’azhą́ téłtł’áh nohwił ogo’eeł. ");
INSERT INTO apwNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Áík’ehgo gádaayiłṉii, Hant’é lą́ bighą ńdaałdzid, ntsóląą’at’éégo nohwi’odlą’ doo hwoi da? ṉii. Áídá’ nádiidzaago nyolhíí túhíí biłgo yich’į’ hadziigo nkenágoheltǫ’. ");
INSERT INTO apwNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Áík’ehgo nṉee bił díyadaagot’éégo gádaaṉii, Nṉee ląą daat’éhi díí, nyolhíí ła’íí túhíí ndi da’áyiłṉiiyú ádaat’įį! ");
INSERT INTO apwNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hanaayú Gérgesenes daagolį́į́yú bił nada’diz’eeldá’ nṉee łena’ṉiłíí goz’ąądí’ nṉee naki, ch’iidn isná ádaabiłsinihíí, Jesus yaa n’áázh, bédaach’ildzidhíí bighą doo hadíń ałhánégo bit’ah ch’egháhi da. ");
INSERT INTO apwNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yat’éégo gádaaṉii, Hago lą́ą́ ánohwile’go áńt’į́į́, Jesus, Bik’ehgo’ihi’ṉań biYe’ ńlíni? Nohwiniigodilṉe’íí doo hwahá biká’ ngoṉáh dadá’ nohwiniigodnle’ née? ");
INSERT INTO apwNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Áígee da’aṉahyú góchi da’iyąągo nanałse’. ");
INSERT INTO apwNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Áík’ehgo ch’iidn náda’okąąhgo gádaabiłṉii, Hanohwinyóódyúgo, góchi nanłsé’íí beh nohwinyóód. ");
INSERT INTO apwNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Áík’ehgo, Hahkeeh, yiłnṉiid. Hakį́į́dá’ góchi nanałsé’íí yeh hikį́į́: nt’éégo góchi dawa hayaa nádnkįįgo túsikáni yeh hikį́į́, áík’ehgo tú yił daadesdzii. ");
INSERT INTO apwNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Áídí’ góchi yiṉádaadéz’įį n’íí nádnkįįgo kįh gozṉilyú okai, áígee ch’iidn isná ádaabiłsį n’íí hago ádaabi’deszaahíí dawa yaa nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Áídí’ kįh gozṉilgee daagolííníí dawa Jesus yich’į’ ch’ínáłsą́ą́: áík’ehgo daayiłtsąądá’ náyokąąhgo gádaayiłṉii, Nohwini’dí’ ch’íńṉáh. ");
INSERT INTO apwNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Áídí’ Jesus tsina’eełíí yeh hiyaago hanaayú dabíí gólį́į́yú bił oná’í’éél. ");
INSERT INTO apwNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nt’éégo ła’ nṉee di’ili baa daach’iskąą: Jesus daabi’odlą’ yígołsįįdá’ nṉee di’ilihíí gáyiłṉii, Shiye’, nił gozhǫ́ǫ́ le’; ninchǫ’híí bighą dák’ad naa nágodet’aah. ");
INSERT INTO apwNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Áídá’ begoz’aaníí ye’ik’eda’iłchíhi ła’ dábiyi’yú, Díí nṉee Bik’ehgo’ihi’ṉań ádil’įįgo áṉii, daanzį. ");
INSERT INTO apwNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Natsídaakeesíí Jesus yígółsįgo gádaabiłṉii, Nt’é bighą nohwijíí biyi’ yuyaa nchǫ’go natsídaahkees? ");
INSERT INTO apwNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hadíihíí doo nyeego ách’iṉiih da, Ninchǫ’híí bighą dák’ad naa nágodet’aah; dagohíí, Nádndáhgo dahnṉáh? ");
INSERT INTO apwNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ni’gosdzáń biká’ nṉee binchǫ’híí bighą baa nágodet’aahíí shíí, nṉee k’ehgo Niyááhíí, beshik’ehgo bídaagonołsį doleełhíí bighą, (nṉee di’ili sitiiníí gáyiłnṉiid,) Nádndáhgo biká’ síntiiníí dahnádnné’go gowąyú nádńdáh. ");
INSERT INTO apwNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Áík’ehgo nádiidzaago gowąyú onádzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nṉee łą́ą́go íła’adzaahíí díí daayo’įįdá’ bił díyadaagot’eego Bik’ehgo’ihi’ṉań ya’ihédaanzį, nṉee díí k’ehgo á’ił’įįgo yaa goden’ąąhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus áídí’ higaałgo nṉee Matthew holzéhi tax nanáhi’ṉiłígee sidaago yiłtsąądá’, Shiké’ dahnṉáh, yiłṉii. Áík’ehgo nádiidzaago biké’ dahiyaa. ");
INSERT INTO apwNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesus iyąągo nezdaago, tax bich’į’ nadaahi’ṉiiłííhik’e nṉee doo dábik’ehyú ádaat’ee dahíí łą́ą́go hikaigo Jesus hik’e bitsiłke’yu yił da’iyąągo dahdinezbįh. ");
INSERT INTO apwNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pharisees daanlíni daabo’įįdá’ Jesus bitsiłke’yu gádaayiłṉii, Nt’é bighą nohwiłch’ígó’aahíí tax bich’į’ nadaahi’ṉiiłíí hik’e nṉee doo dábik’ehyú ádaat’ee dahíí yił da’iyąą? ");
INSERT INTO apwNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesus áí yidezts’ąądá’ gádaabiłṉii, Doo hago’ádaat’ee dahíí izee nant’án doo yaa nakáh bik’eh da, daanṉiihíí zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hant’é ṉiigo ágodi’ṉiihíí bídaagonoł’aah, Dawahá nastseedgo bedaashich’okąąhíí bitisgo nṉee łaadaach’oba’íí hásht’į́į́, ṉiigo: shíí nṉee doo bik’ehyú ádaat’ee dahíí, Nohwinchǫ’íí bits’ą́’zhį’ ádaahṉe’, biłdishṉiiyú níyáá, áídá’ doo nṉee dábik’ehyú ádaat’eehíí ágáłdishṉiiyú níyáá da. ");
INSERT INTO apwNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","John bitsiłke’yu Jesus yaa hikaigo gádaaṉii, Nt’é bighą néé hik’e Pharisees daanlíni łahgee dáshiṉá’ da’ohiikąąh, áídá’ ni nitsiłke’yu doo dáshiṉá’ da’okąąh da? ");
INSERT INTO apwNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus gádaabiłṉii, Ya’ ni’i’ṉéhgee nṉee íła’ádaat’eehíí nṉee niiṉéhíí yił nakaiyúgo doo bił daagozhǫ́ǫ́ da née? Dahagee nṉee niiṉéhíí bits’ą́’ nádilteeh ndi at’éé, áígee dáshiṉá’ da’okąąh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ko’íí dénchǫ’éhíí doo nak’ą’ áníidéhíí bee ch’idi’aah da; ágách’idzaayúgo áníidéhíí iłhanigháhgo dayúwehégo onanádlaad. ");
INSERT INTO apwNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ła’íí wine áníi alzaahíí ikágé wine benałtiníí dénchǫ’éhíí doo biyi’ tádaach’iṉił da: ágách’idzaayúgo wine benałtiníí kots’ą́’ daidiłdoh, áík’ehgo winehíí ąął ha’ijooł, ła’íí wine bee nałtį n’íí da’ílíí hileeh: áídá’ wine áníi alzaahíí wine benałtiníí áníidéhíí zhą́ biyi’ tádaach’iṉił, áík’ehgo da’íła nłt’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus t’ah bich’į’ yałti’ nt’éégo nant’án ła’ baa nyáágo biyahzhį’ hayaa adzaago gábiłnṉiid, Shitsi’ áníi daztsąą: ndi yushdé’, biká’ ndenlṉíhgo nnaahó’ṉaa. ");
INSERT INTO apwNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Áík’ehgo Jesus nṉeehíí yiké’ dahiyaago bitsiłke’yu ałdó’ biké’ dahiskai. ");
INSERT INTO apwNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nt’éégo isdzán dił bigháńlį́į́go nakits’ádah bił łegodzaahi Jesus yine’dí’ ninyaago bi’íí bidá’yú yedelṉiih: ");
INSERT INTO apwNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ídił yałti’go gáṉíí, Bi’íí zhą́ ndi bedenshṉiihyúgo nłt’éé náshdleeh. ");
INSERT INTO apwNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus łédiidzaago biłtsąą, áík’ehgo gábiłṉii, Shilah, nił gozhǫ́ǫ́ le’; ni’odlą’íí nłt’éégo ánániidlaa. Áík’ehgo dagoshch’į’ nłt’éé násdlį́į́. ");
INSERT INTO apwNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Áídí’ Jesus nant’án bigową yuṉe’ ha’ayáágo, tsįsól yeda’do’aałíí hik’e nṉee daagodnch’aadíí yiłtsąągo, ");
INSERT INTO apwNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ch’ínohkáh, yiłnṉiid: na’ilíhn doo daztsąą da, daazhógo iłhoshgo at’éé. Áí bighą baa daach’odloh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nṉee íła’adzaahíí dawa ch’ínáńłsą́ą́dá’ Jesus ha’ayáágo na’ilíhníí bigan yiłtsoodá’ nádiidzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Áík’ehgo áí biṉaayú dahot’éhé ágodzaahíí baa ch’iṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Áídí’ Jesus dayúweh higaałgo nṉee naki biṉáá ádaagodini biké’ dahizh’aazh, adįįd daadilwoshgo gádaaṉii, David biye’ ńlíni, nohwaa ch’onbáah. ");
INSERT INTO apwNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kįh yuṉe’ ha’ayáágo nṉee biṉáá ádaagodini baa n’áázh: Jesus gádaayiłṉii, Ya’ ágá’ishłéhgo nohwi’odlą’ golį́į́ née? Ha’oh, nohwiNant’a’, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Áík’ehgo biṉáá ádaagodiníí biṉáá yiká’ ndelṉiigo, Hago nohwi’odlą’ nel’aaníí dábik’ehgo nohwá begolṉe’, biłnṉiid. ");
INSERT INTO apwNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Áík’ehgo biṉáá nádaagosdlįįgo, Hadíń yígonołsį́įh hela’, Jesus nłdzilgo baa daasṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Da’ágát’éé ndi o’áázhyú dahot’éhé yaa nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Áídí’ dahnádikáh ńt’éégo nṉee doo yałti’ dahi, ch’iidn isná ábiłsini, Jesus baa bił ch’ikai. ");
INSERT INTO apwNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Áík’ehgo nṉeehíí biyi’dí’ ch’iidn habi’dinodzoodá’, nṉee doo yałti’ da n’íí hadzii: áík’ehgo nṉee íła’adzaahíí bił díyadaagot’eego gádaaṉii, Israel hat’i’íí bitahyú doo hak’i díí k’ehgo ágot’eehíí daahiltséhi da. ");
INSERT INTO apwNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Áídá’ Pharisees daanlíni, Ch’iidn nant’án binawodíí bee ch’iidn hainihiyood, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Áídí’ Jesus kįh nagozṉilyú hik’e gotahyú yitah naghaa, Jews ha’ánáłséh nagozṉilyú iłch’ígó’aahgo, yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí baa na’goṉi’íí nłt’éhi yaa yałti’go, ła’íí nṉee bitahyú iłtah at’éégo daanṉiihíí hik’e kah yaa nakaihíí dawa náyihilziihgo naghaa. ");
INSERT INTO apwNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesus nṉee łáni yo’įįgo, dibełį́į́ nadaabinyoodíí da’ádįhgo nakai łehíí k’ehgo doo daanłdzil dago iłtanáhosąąhíí bighą dázhǫ́ yaa ch’oba’ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Áídí’ bitsiłke’yu gádaayiłṉii, Nest’áń dázhǫ́ łą́ą́go nest’ąądá’ nada’iziidíí doo łą́ą́ dahíí bighą doo hwoi da; ");
INSERT INTO apwNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Áík’ehgo nest’ą’ yeBik’ehń bich’į’ da’ohkąąhgo gádaabiłdohṉiih, Nada’iziidíí ninest’ą’ nádaayihigeshyú daadnł’áá. ");
INSERT INTO apwNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus bitsiłke’yu nakits’ádahíí yushdé’ daayiłnṉiidá’ spirits daanchǫ’i hadainihiyóód doleełgo yedaabik’ehgo yaa daagodez’ąą, iłtah at’éégo daanṉiihíí hik’e kah iłtah at’ééhíí yaa nadaakaihíí nádaayilziihgo ałdó’ yaa daagodez’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nakits’ádah nadaal’a’á gádaaholzee; dantséhíí Simon, da’áń Peter holzéhi, hik’e bik’isn Andrew; James Zebedee biye’hi, hik’e bik’isn John; ");
INSERT INTO apwNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip hik’e Barthólomew; Thomas ła’íí Matthew, tax bich’į’ nahi’ṉíłi; James, Alphéus biye’hi, hik’e Lebbéus, da’áń Tháddeus holzéhi; ");
INSERT INTO apwNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, Cánaanite nlíni, ła’íí Judas Iscáriot, Jesus ch’íyido’aałíí. ");
INSERT INTO apwNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Díí nakits’ádahíí Jesus odaahił’aago gádaayiłṉii, Doo Jews daanlįį dahíí bitahyú dohkáh hela’, ła’íí Samáriayú kįh nagozṉilyú dohkáh hela’: ");
INSERT INTO apwNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel hat’i’íí bitahyú, dibełį́į́ ch’a’onehezdeehíí k’ehgo zhą́ bich’į’ dohkáh. ");
INSERT INTO apwNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Desohkaiyú, Yaaká’yú dahsdaahń nant’aahíí biká’ nagowaa, daadohṉiigo baa yádaałti’. ");
INSERT INTO apwNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Daanṉiihíí nádaahołziih, nṉee łóód doo ínádįh dahi, leprosy holzéhi, yaa nakaihíí nłt’éégo ánádaahdle’, nanezna’íí nádaabihoł’ṉaah, ch’iidn nṉee biyi’dí’ hadaanohohsood: daazhógo nohwaa daas’né’, daazhógo nadaahṉiih. ");
INSERT INTO apwNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nohwibestso bizis biyi’ yuyaa óodo, béshłigai, dagohíí zhaali łitsogé odaahṉííł hela’; ");
INSERT INTO apwNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Hohkaahyú izis bena’iltiníí, dagohíí nohwi’íícho naki, ik’e’an nohwikee, ła’íí tsį be’idiltłishé dahdaadohṉiił hela’: nṉee na’iziidíí bá di’né’go goz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Dahadíí kįh nagozṉil dagohíí gotahyú dohkáhyúgo, hadíń nłt’éégo at’ééhíí biká na’ídaadołkidgo, łahyú naadohkáhzhį’ bił nahísóotąą le’. ");
INSERT INTO apwNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gową yuṉe’ ha’ahkaigee, Iłch’į’gont’ééhíí díí gową yuṉe’ be’ágót’ee le’, daadohṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Áígee daagolííníí nłt’éégo ádaat’eeyúgo nohwił iłch’į’gont’ééhíí yił daanlįį doo: doo nłt’éégo ádaat’ee dayúgo, nohwił iłch’į’gont’ééhíí dánohwíí nohwił nádodleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Dahadíń doo hádaanohwit’įį dayúgo, nohwiyati’ doo yídaayésts’ąą dayúgo, áí gową dagohíí kįh gozṉilíí bits’ą́’ dahnádohkáhgo, nohwikee bąą łeezhíí baa daałhaał. ");
INSERT INTO apwNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Da’aṉii gádaanohwiłdishṉii, Bik’ehgo’ihi’ṉań nṉee yándaago’aahíí bijįį Sodom hik’e Gomórrah golzeegee daagolį́į́ n’íí biniidaagodilṉe’íí bitisgo áí kįh gozṉilgee daagolííníí biniigodolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ma’ bitahyú dibełį́į́ k’ehgo daanohwideł’a’: áí bighą ch’osh goyą́ą́híí k’ehgo daagonohsąą, hawú ga’ádaanoht’eego doo t’ąązhį’ nádaadołghash da. ");
INSERT INTO apwNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nṉee baa daagonohsąą: yánádaaltihíí yaa nádaanohwide’aah doleeł, ła’íí Jews íła’ánát’įįh nagozṉil yuṉe’ hanohwínáda’iltsas doleeł; ");
INSERT INTO apwNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ła’íí nant’ánchań hik’e ízisgo nant’ánhíí biyahzhį’ nnádaanohwich’iłteeh doleeł, shíí shighą, áí hik’e doo Jews daanlįį dahíí ałdó’ biṉááł shá nadaagołṉi’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nohwaa yá’iti’yú nohwił ch’ideskaiyúgo, hagot’éégoshą’ hasdzii, hant’éshą’ dishṉii, doo daanohsį da: hant’é daadohṉiihíí da’áí bik’ehenkéézgee nohwaa hi’né’ ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Áí doo dánohwíí hahdziih da, ndi nohwiTaa bits’ą́’dí’go Spirit‐híí nohwinkááyú hadziih ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nṉee ła’ bik’isn zideeyú nyide’aah doleeł, ła’íí nṉee ła’ bizhaazhé ágáyidoliił: chągháshé bą́ą́ hik’e bitaa yich’į’ nanádaagonłkaadgo bik’ehgo nabi’ditseed doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Shizhi’ bee daanohwich’ozhiihíí bighą nṉee dawa bił daanohchǫ’ doleeł: áídá’ dahadíń dángont’í’zhį’ dahildǫ́híí hasdábi’ dolteeł. ");
INSERT INTO apwNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ła’ kįh gozṉilgee nohwiniidaagoch’idnłsįyúgo, łahyúgo náádohkáh: da’aṉii gádaanohwiłdishṉii, Shíí, nṉee k’ehgo Niyááhíí, nánsdzaazhį’ Israel hat’i’i bikįh nagozṉilíí t’ah doo hwahá dawago nohkáh da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Biłch’ígót’aahíí biłch’ígó’aahíí doo yitisgo at’éhi at’éé da, ła’íí na’iziidíí doo binant’a’ yitisgo at’éhi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Biłch’ígót’aahíí biłch’ígó’aahíí yiłgo dáłełt’eego dábik’eh, ła’íí na’iziidíí binant’a’ yiłgo dáłełt’eego dábik’eh. Bigową golííníí Beélzebub daałch’iṉiigo daabich’ozhííyúgo, bichągháshé itisgo nchǫ’go daabich’ozhíí doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Áík’ehgo doo bédaałdzid da: k’ad dawahá bił łe’izkaad n’íí ch’í’ṉah ádolṉiił; ła’íí k’ad dawahá nanl’į’ n’íí bígózįhgo ádolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Godiłhił yuṉe’ nohwił nagoshṉi’íí idindláádyú baa nadaagołṉi: nant’į’ego bee nohwich’į’ ha’odziihíí kįh biká’dí’ daadołwoshgo baa nadaagołṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hadíí kots’í nadaiłtseedá’ koyi’siziiníí doo nadaiłtseed at’éé dahíí doo bédaałdzid da; áídá’ ch’iidn bikǫ’ diltłi’ yuyaa kots’í hik’e koyi’ siziiníí oyiné’híí, áń zhą́ bédaałdzid. ");
INSERT INTO apwNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ya’ dlǫ’dichiné naki zhaali łichí’é dała’á ílį́į́go nahiṉiih gá? Da’ágát’éé ndi nohwiTaa doo hat’į́į́ dayúgo dała’á ndi doo ni’yú bits’ą́’ naokáad at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nohwitsizíl ndi dawa iłk’idá’ hotagi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Áík’ehgo doo nédaałdzid da, dlǫ’dichiné doo ałch’ídé bitisgo da’inohłįį da. ");
INSERT INTO apwNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Dahadíń nṉee binadzahgee, Áń bígonsį, shiłṉiihíí, áń shiTaa yaaká’yú dahsdaahń binadzahgee ágáłdidishṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Áídá’ dahadíń nṉee binadzahgee, Áń doo bígonsį da, shiłṉiihíí, áń shiTaa yaaká’yú dahsdaahń binadzahgee ágáłdidishṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ni’gosdzáń biká’zhį’ iłch’į’gont’ééhíí nkeniné’ doo daasho’ṉíí da: doo iłch’į’gont’ééhíí nkenishné’híí bighą niyáá da, bésh be’idiltłishé niitą́ą́go niyáá. ");
INSERT INTO apwNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nṉee ła’ bitaa bił łił nanágonłkaad doleeł, isdzán bi’isdzą’ bił łił nanágonłkaad, ła’íí isdzán hik’e bá’iyéhíí ałdó’ bił łił nanágonłkaadgo ashłe’híí bighą niyáá. ");
INSERT INTO apwNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nṉee dabíí bichągháshé bich’į’ nanádaagonłkaad doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Dahadíń bitaa dagohíí bą́ą́ shíí shitisgo bił nzhooníí doo shíyéé hileehgo dábik’eh da: ła’íí dahadíń biye’ dagohíí bitsi’ shíí shitisgo bił nzhooníí doo shíyéé hileehgo dábik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Dahadíń bitsį’iłna’ááhíí doo dahiditįįhgo shiké’ dahdigháh dahíí doo shíyéé hileehgo dábik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dahadíń bi’ihi’ṉa’ bił ilííníí bits’ą́’ da’ilíí hileeh: áídá’ dahadíń shíí shighą bi’ihi’ṉa’ doo bił ilį́į́ dahíí, áń zhą́ dahazhį’ ihi’ṉaahíí yaa higháhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Dahadíń nánohwidnłtiiníí shíí ałdó’ náshidnłtíni at’éé; dahadíń náshidnłtiiníí shides’a’íí ałdó’ náidnłtíni at’éé; ");
INSERT INTO apwNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dahadíń nṉee Bik’ehgo’ihi’ṉań binkááyú na’iziidi nlįįhíí bighą nádnłtiiníí, Bik’ehgo’ihi’ṉań binkááyú na’iziidi nt’é Bik’ehgo’ihi’ṉań bainé’íí áń ałdó’ da’áík’ehgo baa hi’né’hi at’éé; dahadíń nṉee dábik’ehyú át’ééhíí nlį́į́híí bighą náidnłtiiníí, nṉee ágát’éhi nt’é Bik’ehgo’ihi’ṉań bainé’íí áń ałdó’ da’áík’ehgo baa hi’né’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dahadíń, Jesus yiké’ higaałhíí bighą, díí doo ízisgo at’éé dahíí idee bee tú sik’azíí ndi yá ná’iłsįįhyúgo, da’aṉiigo gádaanohwiłdishṉii, Bik’ehgo’ihi’ṉań bich’į’ nayihiṉiiłíí da’aṉiigo bíyéé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus bitsiłke’yu nakits’ádahíí ąął yił ch’ídaagoz’ąądá’ Jews daanlíni bikįh nagozṉilyú iłch’ígó’aahgo hik’e yati’ baa gozhóni yaa nagolṉi’go onanádzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","John ha’ásitįį yuṉe’ Christ ánát’įįłíí ya’ikonzįįdá’ bitsiłke’yu naki Christ yich’į’ oyił’a’go, ");
INSERT INTO apwNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Gáyiłnṉiid, Ya’ ni higháhi n’íí ánt’įį née, dagohíí ła’i biká daadéet’įį née? ");
INSERT INTO apwNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus gábiłṉii, John bich’į’ nádoht’aashgo díí disołts’aaníí ła’íí hoł’iiníí baa bił nagołṉi’: ");
INSERT INTO apwNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Biṉáá ádaagodįh n’íí biṉáá ánágodle’, doo nadaakai da n’íí náhikáh, nṉee łóód doo ínádįh dahi, leprosy holzéhi, yaa nadaakai n’íí nłt’éégo ánádaidle’, bijeyi’ ádaagodįh n’íí da’idits’ag ánádaidle’, nanezna’ n’íí naahikáhgo ánádaidle’, tédaat’iyéhíí yati’ baa gozhóni bee bich’į’ yáda’iti’. ");
INSERT INTO apwNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hadíń shodląągo doo t’ąązhį’ at’éé dahíí biyaa gozhǫ́ǫ́ doleeł, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Onát’aazhdá’ Jesus nṉee íła’at’ééhíí John yaa nagolṉi’go yich’į’ yałti’go nkegonyaa gáṉíígo, Da’igolį́į́yú nt’é hádaadeh’į́į́yú nasohkai? Tł’oh bit’ąą nteelíí bił godiyołíí née? ");
INSERT INTO apwNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nt’é hádaadeh’į́į́yú nasohkai áídá’? Nṉee nłt’éégo bik’e’izláhi née? Hadíí bidiyágé nłt’ééhíí nant’án golį́į́gee nadaakaihi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nt’é lą́ą́ hádaadeh’į́į́yú nasohkai áídá’? Bik’ehgo’ihi’ṉań binkááyú na’iziidi née? Ha’oh, Bik’ehgo’ihi’ṉań binkááyú na’iziidi yitisgo at’éhi, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Díí baa k’e’eshchįį n’íí áń át’į́į́, Shinal’a’á nádįh dish’aa, nádįh iłch’į’gole’go. ");
INSERT INTO apwNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Da’aṉiigo gánohwiłdishṉii, Nṉee daagozliiníí bitahyú doo ła’ John Baptize ágole’íí yitisgo at’éé da: áídá’ yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí bitahyú hadíń dázhǫ́ doo ílį́į́ dahíí John yitisgo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","John Baptize ágole’íí ni’gosdzáń biká’ naghaadí’ godezt’i’go nṉee yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí itah daaleeh dázhǫ́ hádaat’įįgo ídéédaalnaa. ");
INSERT INTO apwNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí ła’íí begoz’aaníí baa k’e’eshchiiníí ágoṉe’íí dabíntsédá’ yaa yił nadaagosṉi’, John nyáázhį’. ");
INSERT INTO apwNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Shiyati’ nádaagodoh’aah hádaaht’įįyúgo gánohwiłdishṉii, Elías, hígháh n’íí, át’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Hadíń bijeyi’ golííníí, íyésts’ąą le’. ");
INSERT INTO apwNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Dząągee nṉee daałinolt’įįłíí hant’é bił łíshhah nishłeego baa nagoshṉi’? Na’iṉiih nagoz’ąągee chągháshé íła’at’éégo iłch’į’ ádaaṉiigo, ");
INSERT INTO apwNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Tsįsól bee nohwich’į’ da’nt’aał ndi doo hak’i da’ołzhizh da; nohwich’į’ daahiichag ndi doo hak’i ch’adaashinołzhil da, daałiłdi’ṉiihíí nṉee díí goldohgee daagolííníí bił dáłełt’ee. ");
INSERT INTO apwNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","John doo iyąągo ła’íí doo idląągo nyáá dadá’, Ch’iidn biyi’ golį́į́, daałch’iṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Shíí, nṉee k’ehgo Niyááhíí, ishąągo ła’íí ishdląągo niyáádá’ gádaashiłch’iṉii, Áń dichini ła’íí idlánihi, tax bich’į’ nadaahi’ṉiiłíí ła’íí nṉee doo bik’ehyú ádaat’ee dahíí bit’eké nlíni, daach’iṉii. Da’aṉii igoyą’íí nt’é ádaat’įįłíí bee bígózįh. ");
INSERT INTO apwNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kįh nagozṉilíí biyi’ Jesus ízisgo áná’ol’įįłíí łą́ą́go ye’ánát’įįłdá’ binchǫ’íí doo yits’ą́’yúgo ádaaṉe’ dahíí bighą yił daaditeh nkegonyaa, gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Korázingee daagonohłiiníí, nohwá góyéé doleeł! Bethsáidagee daagonohłiiníí ałdó’ nohwá góyéé doleeł! Nohwitahyú ízisgo ánágot’įįłíí Tyre hik’e Sídongee ágágodzaayúgo, áígee daagolííníí doo áníidá’ nak’ą’dich’ízhé bik’inazlaadá’ iłch’ii yiyi’ naháztąągo binchǫ’íí yits’ą́’zhį’go ádaasdzaa doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bik’ehgo’ihi’ṉań nṉee yándaago’aahíí bijįį Tyre hik’e Sídon bitisgo nohwiniigodidolṉiił, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nohwíí, Capérnaumgee daagonohłiiníí, yaaká’zhį’go hanohwidi’ṉiiłíí, nohwíí ch’iidntahzhį’go nohwidido’ṉił: nohwitahyú ízisgo ánágot’įįłíí Sódomgee ágágodzaayúgo, díí jįį Sódom t’ah goz’ąą doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bik’ehgo’ihi’ṉań nṉee yándaago’aahíí bijįį ni’, Sódom golzeehíí, bitisgo nohwiniigodidolṉiił, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Áídá’ Jesus Bik’ehgo’ihi’ṉań yokąąhgo gáṉíí, ShiTaa, yaaká’zhį’ hik’e ni’zhį’ nant’án ńlinihi, díí iłch’ígót’aahíí nṉee daagoyą́ą́go bił ídaagozínihíí baa ch’ananł’į’ n’íí mé’ ga’ádaat’eehíí bich’į’ ch’í’ṉah ánleehíí nich’į’ ba’ihénsį. ");
INSERT INTO apwNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Da’áík’ehgo ágot’ee le’, shiTaa; da’áík’ehgo hánt’įįgo ágónlaahihi. ");
INSERT INTO apwNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ShiTaa bits’ą́’dí’go dawa shaa hi’ṉííł: doo hadíń shíí, Bik’ehgo’ihi’ṉań biYe’ nshłíni, shígółsini at’éé da, shiTaa zhą́; ła’íí doo hadíń shiTaa yígółsini at’éé da, shíí biYe’ nshłíni zhą́, ła’íí dahadíńta shiTaa bich’į’ bígózįhgo áshłe’íí ałdó’ shiTaa yígółsį. ");
INSERT INTO apwNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Daanohwigha nada’ohsiidíí ła’íí ndaazgo dahda’ohheełíí shich’į’ nohkáh, áík’ehgo hádaasołgo ánohwishłe’. ");
INSERT INTO apwNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Izénázwodíí łahdí’ nábiyi’hishaałgo shits’ą́’dí’ ígonł’áah; shijíí yuṉe’ isht’egodnt’ee, doo itisgo ídésht’įį da: áík’ehgo nohwiyi’ siziiníí hanáyoł doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Izénázwodíí łahdí’ nábiyi’hishaałyúgo doo ná nyee da doleeł, da’ighéélgo ánisiníí doo ná ndaaz da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Áídá’ Jews daagodnłsiníí bijįį Jesus tł’oh nagháí hentííníí yiyi’yú higaał; bitsiłke’yu yił hikaahgo shiṉá’ daasilįįgo tł’oh nagháí binest’ą’ nadaayiṉiiłgo daayiyąą nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pharisees daanlíni daabiłtsąądá’ gábiłṉii, Díń’įį, godilziníí bijįį doo baa nach’ighaa dahíí nitsiłke’yu yaa nakai. ");
INSERT INTO apwNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus gádaabiłṉii, Ya’ David hik’e yił nakaihíí biłgo shiṉá’ daasilįįgo, hago ádaasdzaa láń shįhíí doo hwahá baa da’ohshiih da née? ");
INSERT INTO apwNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bik’ehgo’ihi’ṉań daach’okąąh goz’ąą yuṉe’ ha’akaigo, báń Bik’ehgo’ihi’ṉań ye’ okąąhgo baa hi’né’go nii’né’ n’íí, doo daayiyąągo bágoz’ánihi daayiyą́ą́, áí báńhíí okąąh yedaabik’ehi zhą́ daayiyąągo goz’ánihi. ");
INSERT INTO apwNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Da’ch’okąąh goz’ąą yuṉe’ okąąh yedaabik’ehi godilziníí bijįį doo daagodnłsį da ndi doo bee bída’itah dahíí, begoz’aaníí bek’e’ eshchiiníí biyi’ doo hwahá baa da’ohshiih da née? ");
INSERT INTO apwNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Dząągee hadíń da’ch’okąąh goz’aaníí yitisgo at’éhi naghaa, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dawahá nastseedgo bedaashich’okąąhíí bitisgo nṉee łaadaach’oba’íí hásht’į́į́, ṉiigo aṉííhíí bídaagonołsįyúgo, shíí, doo shaa dahgoz’ąą dahíí, doo shaa yádaałti’ da doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Shíí, nṉee k’ehgo Niyááhíí, godilziníí bijįį ndi beshik’eh. ");
INSERT INTO apwNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Áídí’ dahiyaadá’ Jews ha’ánáłséh goz’ąą yuṉe’ ha’ayáá. ");
INSERT INTO apwNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Áígee nṉee bigan dała’ázhiṉéé binawod ásdįįdi itah sidaa lę́k’e. Nṉee ła’i Jesus dant’éhéta bee baa dahgosit’aa daanzįgo nayídaadiłkid gádaaṉiigo, Ya’ godilziníí bijįį ná’ch’ilziihíí begoz’ąą née? ");
INSERT INTO apwNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesus gádaabiłṉii, Nohwitahyú nṉee ła’ bidibełį́į́ dała’áhi godilziníí bijįį o’i’áń yuṉe’ ogo’yúgo, yiłtsoodgo hanáidishood ya’? ");
INSERT INTO apwNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nṉee dibełį́į́ yitisgo ílį́į́ go’į́į́! Áík’ehgo godilziníí bijįį nłt’éégo ánách’ot’įįłgo goz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Áídí’ nṉee bigan binawod ásdįįdi yich’į’ gáṉíí, Yushdé’ dahdinlṉíh. Áík’ehgo bich’į’ dahdidilṉiigo bigan nádzii, łahzhiṉééhíí ga’at’éé násdlį́į́. ");
INSERT INTO apwNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Áídí’ Phárisees daanlíni ch’ékaigo, hagot’éégo Jesus daayiziłhee doleełíí yaa nadaagoshchįį. ");
INSERT INTO apwNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesus díí yígółsįgo áídí’ dahnyaa: nṉee biké’ dahnánłsąą, áí dawa náyihilziih; ");
INSERT INTO apwNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Áídí’ gádaayiłṉii, Ch’ídaashinoh’aah hela’: ");
INSERT INTO apwNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bik’ehgo’ihi’ṉań binkááyú na’iziidi, Esáias holzéhi, gánṉiidíí begolṉe’go ánágot’įįł, ");
INSERT INTO apwNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Shinal’a’á, hałtííníí, shił nzhóni, shiyi’siziiníí bił dábik’ehyú át’éhi daaneł’į́į́: shiSpirit‐híí biká’zhį’ ashłéhgo doo Jews daanlįį dahíí bich’į’ dábik’ehyú ágot’eehíí yaa nagolṉi’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Doo nagontł’og nago’aa da, doo dilwosh da doleeł; da’intínyú bizhiihíí doo hadíń yidits’ag da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dábik’ehyú ánách’ot’įįłíí itis silįįgo áyíílaazhį’ tł’oh hichǫǫdíí doo yitíh da, túkǫ’íí beh hiit’i’íí dét’įh dałchiihíí doo yinłtsees da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bíí bizhi’íí doo Jews daanlįį dahíí bada’ołíí doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nṉee ła’ ch’iidn isná ábiłsini biṉáá ágodįh, ła’íí doo yałti’ dahi baa bił ch’ikaigo náyilziih: áí nṉee doo yałti’ da n’íí yałti’ ła’íí go’įį násdlį́į́. ");
INSERT INTO apwNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nṉee dawa bił díyadaagot’eego gádaanṉiid, Áń David biYe’ at’į́į́ ya’? ");
INSERT INTO apwNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Phárisees daanlíni áí daidezts’ąądá’ gádaanṉii, Ch’iidn nant’án, Beélzebub holzéhi, binawodíí bee díí nṉee ch’iidn hainihiyood, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Natsídaakeesíí Jesus yígółsįgo gádaayiłṉii, Nṉee dałaháyú binant’a’ golííníí dabíí iłch’į’ nanágonłkaadyúgo da’ílíí hileeh; kįh gozṉilgee daagolííníí dagohíí dáła’ naháztaaníí dabíí iłk’ídahnájahyúgo doo aṉahyú bengonowáh át’éé da: ");
INSERT INTO apwNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satan nṉee biyi’dí’ Satan hainihiyoodyúgo, dabíí ích’į’ naná’idziid; áík’ehgo yebik’ehíí hagot’éégo ńzaad begoldoh? ");
INSERT INTO apwNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Shíí Beélzebub bee ch’iidn haniisoodyúgo, nohwíí daanohwiye’íí hadíń bee ch’iidn hadainiyood áídá’? Áík’ehgo daanohwiye’íí ch’í’ṉah ádaanohwile’. ");
INSERT INTO apwNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Áídá’ Bik’ehgo’ihi’ṉań biSpirit bee ch’iidn haniisoodyúgo, Bik’ehgo’ihi’ṉań nohwitahyú iłk’idá’ nant’aa. ");
INSERT INTO apwNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Hagot’éégo ła’ nṉee nalwodi bigową yuṉe’ ha’ách’ighaago dawahá bíyééhíí ch’in’įįh? Nṉee nalwodíí ntsé łích’iltł’ó hik’e go’į́į́. Áídá’ dawahá bíyééhíí bits’ą́’ ch’in’įįh. ");
INSERT INTO apwNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Hadíń doo bił gonsht’įį dahíí shich’į’ got’ínihi at’éé; hadíń doo bił íła’áná’ishdle’ dahíí shits’ą́’ ts’iłtįįgo áile’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Áík’ehgo gádaanohwiłdishṉii, Konchǫ’íí dawa ła’íí Bik’ehgo’ihi’ṉań dénchǫ’go baa yách’iłti’híí bighą kaa nágodit’aah doleeł: áídá’ Holy Spirit dénchǫ’go baa yách’iłti’yúgohíí doo kaa nágodinot’aah at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Shíí, nṉee k’ehgo Niyááhíí, dénchǫ’go shaa yách’iłti’híí bighą kaa nágodit’aah doleeł: áídá’ Holy Spirit dénchǫ’go baa yách’iłti’híí bighą doo kaa nágodinot’aah at’éé da, díí jįį goldohíí hik’e nágoldohíí ndi. ");
INSERT INTO apwNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ch’il nłt’ééyúgo, binest’ą’ ałdó’ nłt’éé ngolníí; áídá’ ch’il dénchǫ’yúgo, binest’ą’ ałdó’ dénchǫ’ ngolníí; ch’il hago’at’ééhíí binest’ą’ bee bígózini at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ch’osh bik’asda’ golííníí k’ehgo hałinołt’įįłíí, hagot’éégo nłt’éégo yádaałti’, nchǫ’go ádaanoht’eedá’? Kojíí yuṉe’ hagot’éégo goz’ąą shįhíí bee yách’iłti’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kojíí yuṉe’ nłt’éégo goz’aaníí bee nłt’éégo ách’ít’éhi at’éé: kojíí yuṉe’ nchǫ’go goz’aaníí bee nchǫ’go ách’ít’éhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Bik’ehgo’ihi’ṉań nṉee yándaago’aahíí bijįį nṉee yati’ da’ilíníhíí dawa yee hadaadzi’ n’íí bighą baa yá’iti’doleeł, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Niyati’ n’íí bee nłt’éégo áńt’ééhíí ná ha’dodzih, dagohíí niyati’ n’íí bee nángodot’aał. ");
INSERT INTO apwNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanlíni ła’ Jesus gádaayiłṉii, Iłch’ígó’aahíí, godiyįhgo be’ígóziníí ła’ nohwił ch’í’ṉah áńle’. ");
INSERT INTO apwNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yich’į’ hananádziigo gádaayiłṉii, Nchǫ’go ádaat’éhi nant’į’ nakaihi daałinolt’įįłíí godiyįhgo be’ígóziníí yiká daadéz’įį; áídá’ be’ígóziníí doo bił ch’í’ṉah ádaalṉe’hi at’éé da, Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí, Jonas holzéhi, nṉee bich’į’ be’ígózįh alzaahíí zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonas taagi jįį hik’e taagi tł’é’ łóg nchaahíí bibid sitįįhíí k’ehgo shíí, nṉee k’ehgo Niyááhíí, taagi jįį hik’e taagi tł’é’ łeyi’ sitį́į́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bik’ehgo’ihi’ṉań nṉee yándaago’aahíí bijįį nṉee Nínevehgee daagolį́į́ n’íí daahizįįgo nṉee daałinolt’įįłíí yaa yádaałti’go, Nohwíí nohwitisgo daanchǫ’ ni’, daadidoṉiił: Nínevehgee daagolííníí Jonas yałti’go daidezts’ąądá’ binchǫ’íí yits’ą́’zhį’ ánádaasdzaa; áídá’ k’adíí Jonas bitisgo ánsht’éhi niyáá. ");
INSERT INTO apwNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Bik’ehgo’ihi’ṉań nṉee yándaago’aahíí bijįį isdzán nant’ánihi hayaadí’go nyááhíí hizįįgo nṉee daałinolt’įįłíí yaa yałti’go, Shíí shitisgo daanchǫ’ ni’, didoṉiił: áń dázhǫ́ ńzaadí’ ńyáá, Sólomon bigoyą’ yidits’į́hgo; áídá’ k’adíí Sólomon bitisgo ánsht’éhi niyáá. ");
INSERT INTO apwNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Spirit nchǫ’íí nṉee yiyi’dí’ háyáádá’ tú ádįhyú aanádaał, hayú hanayóołíí yiká hantaago; áídá’ doo hagee da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Áík’ehgo gáṉíí, Shíí shigowąyú hadí’ níyáá n’ííyú nádésdzá; bigową n’íí doo nt’é siné’ da, nágolzhoogo dawahá nzhǫǫgo neheshjaayú nádzá. ");
INSERT INTO apwNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Áík’ehgo spirits gosts’idi daanchǫ’i yił nakai, bíí bitisgo daanchǫ’ihi, áí gową yuṉe’ yił ha’akáhgo áígee ndaagoleeh: áík’ehgo nṉee ntsédá’ át’éé n’íí bitisgo at’éé hileeh. Áík’ehgo díí nchǫ’go daałinolt’įįłíí ałdó’ ágát’éé doo. ");
INSERT INTO apwNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus nṉee íła’adzaahíí t’ah yich’į’ yałti’dá’, bą́ą́ hik’e bik’isyú dadáńyú nadaazį, yich’į’ hadaadzii hádaat’įįgo. ");
INSERT INTO apwNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nṉee ła’ gábiłṉii, Nimaa hik’e nik’isyú dadáńyú nadaazį, nich’į’ hadaadzii hádaat’įįgo. ");
INSERT INTO apwNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nṉee bił nagosṉi’íí gáyiłṉii, Hadíń shimaa, hadíń shik’isyú? ");
INSERT INTO apwNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bitsiłke’yu yich’į’ dahdidilṉiigo gáṉíí, Kú shimaa hik’e shik’isyú! ");
INSERT INTO apwNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dahadíń shiTaa yaaká’yú dahsdaahń yikísk’eh at’ééhíí shik’isn, dagohíí shilah, ła’íí shimaa at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Da’áí bijįį Jesus kįhdí’ ch’ínyáágo, túsikaaníí bahgee nezdaa. ");
INSERT INTO apwNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Áígee nṉee łą́ą́go baa náńłsą́ą́, áík’ehgo tsina’eełíí yeh hiyaago dahnezdaa; áídá’ nṉeehíí tábąąyú íła’adzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Áígee na’goṉi’íí yee łą́ą́go yił ch’ígó’aah, gáṉíígo, K’edileehíí yił ke’go k’edileeyú óyáá; ");
INSERT INTO apwNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","K’edileegee k’edilzíí ła’ intín bahyú nanehezdee, áík’ehgo dlǫ́’ íła’adzaago ąął nádaihezlaa: ");
INSERT INTO apwNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ła’ k’edilzíí tsétahyú nanehezdee, ákú łeezh doo dázhǫ́ łą́ą́yú da: łeezh da’ayą́háhíí bighą dagoshch’į’ hadaazhjeed. ");
INSERT INTO apwNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Áídá’ ya’áí hanadáhgee dilid; bikeghad doo yúyahyú nel’ąą dahíí bighą nádaahesgą. ");
INSERT INTO apwNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ła’ihíí hosh bitahyú nanehezdee; áík’ehgo hoshihíí igháńłsąągo nadaistseed. ");
INSERT INTO apwNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ła’ k’edilzííhíí łeezh nłt’ééyú nanehezdee, áí zhą́ nest’áń áyíílaa, ła’ dała’á gonenadín, ła’íí gostądin, ła’íí tádin bitisyú ánálzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Hadíń bijeyi’ golííníí íyésts’ąą le’. ");
INSERT INTO apwNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bitsiłke’yu baa hikaigo gádaabiłṉii, Nt’é bighą iłch’ígót’aahgo na’goṉi’íí bee bich’į’ yáńłti’? ");
INSERT INTO apwNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Áík’ehgo gábiłṉii, Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí doo bígózį da n’íí nohwíí bídaagonołsįįhgo nohwaa daagodest’ąądá’ bíhíí doo baa daagodest’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Dahadíń íyésts’ąągo ígoł’aahíí, bigoyą’íí itisgo baa nádo’né’, áík’ehgo dayúweh bigoyą’ bá ínágododaał: áídá’ dahadíń doo íyésts’ąą dahíí, ayą́hágo ígoł’ąą n’íí ndi bits’ą́’ da’ílíí nádodleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Áí bighą iłch’ígót’aahgo na’goṉi’íí bee bich’į’ yádaashti’: dédaineł’įį ndi doo daayo’įį da; dédaidits’ag ndi doo ídaayésts’ąą da, doo bił ídaagozį da. ");
INSERT INTO apwNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","T’ah doo hwahá gágoṉéh dadá’ Esáias yaa nagolṉi’ n’íí begolzaa, gánṉiidhi, Dédaadohts’ag ndihíí doo nohwił ídaagozį da doleeł; dédaaneł’į́į́ ndihíí doo daah’įį da doleeł: ");
INSERT INTO apwNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Díí nṉeehíí bijíí daantł’iz daazlįį, doo da’dits’ag da daazlįį, ła’íí daanéshch’il daazlįį; doo ágádaat’ee dayúgo biṉáá yee daago’įį doleeł ni’, bijeyi’ yee da’dits’ag doleeł ni’, bijíí yee bił ídaagozį doleeł ni’, áík’ehgo shich’į’ ádaaṉe’go nádaasziih doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nohwíí nohwiṉáá biyaa gozhǫ́ǫ́, go’įįhíí bighą: nohwijeyi’ biyaa gozhǫ́ǫ́, idits’ag‐híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Da’aṉiigo gádaanohwiłdishṉii, Doo ałch’ídé Bik’ehgo’ihi’ṉań binkááyú nada’iziidi, ła’íí nṉee nłt’éégo ánát’įįłíí daah’iiníí daayiłtséh hádaat’įį ndi doo hak’i daayiłtsąą da; daadohts’agíí daidits’į́h hádaat’įį ndi doo hak’i daidezts’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Áík’ehgo k’edileehíí iłch’ígót’aahgo baa nagoṉi’íí nt’é golzeego ágolzeehíí ídaayesółts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hadíń yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí baa yá’iti’íí íyésts’ąągo doo bił ígózį dadá’, nchǫ’i nlįįhń baa nyáágo bijíí yuṉe’ k’edolzaa n’íí bits’ą́’ haiyiné’. Áń k’edilzíí intín bahyú nanehezdee n’íí át’éé; ");
INSERT INTO apwNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Áídá’ tsétahyú nanehezdee n’íí, yati’ yidits’ago dagoshch’į’ bił gozhǫ́ǫ́go náidnné’híí át’éé; ");
INSERT INTO apwNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Áídá’ biyi’yú bikeghad doo yúyahyú nel’ąą dago, da’aṉahzhį’ begodigháh: áídá’ yati’híí bighą nagontł’ogíí, dagohíí biniigonłt’ééhíí baa gowáhgee dagoshch’į’ t’ąązhį’ nanánihidéh. ");
INSERT INTO apwNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Hosh bitahyú nanehezdee n’íí yati’ yidits’agdá’ ni’gosdzáń biká’zhį’ nabi’dintł’ogíí, hágołdzilgohíí k’izé’idiłteehíí igháńłsą́ą́go yati’ k’edolzaa n’íí naistseed, áík’ehgo doo binest’ą’ goleeh da. ");
INSERT INTO apwNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Łeezh nłt’ééyú nanehezdee n’íí, yati’ yidits’ago bił ígóziníí át’éé; áń nest’áń ánáil’įįh, ła’ dała’á gonenadín, ła’íí gostądin, ła’íí tádin bitisyú ánáil’įįh. ");
INSERT INTO apwNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Áídí’ Jesus iłch’ígót’aahgo na’goṉi’íí ła’ ch’í’ṉah anágodlaa, gáṉíígo, Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí díí k’ehgo at’éé: nṉee bik’edolzaayú k’edilzíí nzhooníí k’eidnláá: ");
INSERT INTO apwNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Áídá’ nṉee da’ałhoshdá’ nṉee bó’ṉi’íí áígee nyáágo, tł’oh nagháí bitahyú tł’oh dénchǫ’éhi k’eidnláádá’ onádzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tł’oh nagháí hájéédá’ binest’ą’ gozlįįgee tł’oh dénchǫ’éhi ałdó’ hájééd lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bik’edolzaa golííníí bánada’iziidíí baa hikaigo gádaabiłṉii, Nohwinant’a’, k’edilzíí nłt’éhi la’ k’edíńlaa ni’dá’ díí tł’oh dénchǫ’éhi hadí’go hajéédhi gá? ");
INSERT INTO apwNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Gábiłṉii, Shó’ṉi’íí át’į́į́. Bánada’iziidíí gádaabiłṉii, Ya’ áí tł’ohíí daahi’ṉizh née? ");
INSERT INTO apwNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Dah; tł’oh daahṉizhyúgo, tł’oh nagháíhíí dánko bił daahṉizhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ch’ík’eh dała’ nołseeł le’, inest’ąązhį’: áík’ehgo inest’ąągo tł’oh nagháí daigeeshíí gádaałdishṉiih, Tł’oh dénchǫ’éhíí ntsé bee da’ohtł’o’go didlid doleełhíí bighą: áídá’ tł’oh nagháíhíí shitł’oh nagháí bágową yuṉe’ ndaanohṉííł. ");
INSERT INTO apwNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Áídí’ Jesus iłch’ígót’aahgo na’goṉi’íí ła’ ch’í’ṉah ánágodlaa gáṉíígo, Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí díí k’ehgo ánánát’éé: nṉee bik’edolzaayú ch’il mustard holzéhi biyigé k’eidnláá. ");
INSERT INTO apwNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Áí biyigéhíí dázhǫ́ ałts’ísę́hi, ndi k’edolzaayúgo, dázhǫ́ nchaa hileeh, ch’il dawa bitisgo nchaahi, áídí’ ch’il dázhǫ́ nṉeezgo hileehgo dlǫ́’ yúdahyú nada’iṉiihíí bits’ádaaz’aahíí biyi’yú bit’oh ádaagole’. ");
INSERT INTO apwNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iłch’ígót’aahgo na’goṉi’íí yee nanágolṉi’ gáṉíígo, Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí díí k’ehgo ánánát’éé: isdzán ik’áán táádn ha’oką́ą́go, báń benilzoołé yił ná’ist’oodgo ąął dahńdiilzoolzhį’. ");
INSERT INTO apwNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Díí dawa iłch’ígót’aahgo nada’goṉi’íí Jesus nṉee íła’ádaadzaahíí yee yił nagosṉi’; dá iłch’ígót’aahgo nada’goṉi’íí zhą́ yee yich’į’ yałti’ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Áí Bik’ehgo’ihi’ṉań binkááyú na’iziidi gáṉíí n’íí begolṉe’go, Iłch’ígót’aahgo nada’goṉi’íí bee yashti’ doleeł; ni’gosdzáń alzaadí’ yushdí’ godezt’i’go nal’į’ n’íí baa nagodishṉih, ṉii ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesus nṉee łáni nádohkáh yiłnṉiidá’ kįh yuṉe’ ha’ayáá: áígee bitsiłke’yu baa hikaigo gádaabiłṉii, Tł’oh dénchǫ’éhi k’edolzaayú hentį́į́, nṉiigo nagosíńłṉi’íí nohwił ch’í’ṉah áńle’. ");
INSERT INTO apwNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Áík’ehgo gádaabiłṉii, K’edilzíí nzhóni k’edileehíí shíí, nṉee k’ehgo Niyááhíí ánsht’ee; ");
INSERT INTO apwNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","K’edolzaahíí ni’gosdzáń át’éé; k’edilzíí nzhónihíí yaaká’yú dahsdaahń nṉee bilałtł’áhgee siṉilíí át’éé; áídá’ tł’oh dénchǫ’éhíí nchǫ’i nlįįhń bichągháshé át’éé; ");
INSERT INTO apwNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ó’ṉi’hi k’edilzíí dénchǫ’éhíí k’eidnlááhíí ch’iidn nant’án at’éé; ąął inest’aaníí nnágodáhíí át’éé; ła’íí náda’igeeshíí Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí ádaat’ee. ");
INSERT INTO apwNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tł’oh dénchǫ’éhíí dała’ alzaago kǫ’ yuṉe’ didlidhíí k’ehgo nnágodzaago ágágot’ee doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Shíí, nṉee k’ehgo Niyááhíí, shinal’a’á yaaká’yú daagolííníí daadish’aago, da’iłchǫǫhíí ła’íí nṉee doo bik’ehyú ádaat’ee dahíí shíí shilałtł’áhgee goz’aaníí biyi’dí’ hadaayiṉiił; ");
INSERT INTO apwNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Áídí’ kǫ’ yáádiṉah yuyaa oyihiłkaad: ákú daach’ichag ła’íí kowoo łídaach’idiłk’ash doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Áídá’ nṉee dábik’ehyú ádaat’eehíí ya’áí k’ehgo bik’inada’didlaad doleeł, biTaa bilałtł’áhgee goz’ąąyú. Hadíń bijeyi’ golííníí, íyésts’ąą le. ");
INSERT INTO apwNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí dant’éhéta koł ilíni ték’eyú nách’ides’įį łehíí k’ehgo at’éé; nṉee náidnné’go náides’įįgo bił gozhǫ́ǫ́go bíyéé dawa baa nahazṉiigo ték’ehíí nagohesṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí díí k’ehgo ánánát’éé: nṉee bana’iṉiihi yoo’ łáń ílíni, dilkǫǫhé holzéhi, yíkantaa: ");
INSERT INTO apwNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Áík’ehgo yoo’ łáń ílínihíí yaa nyáágo, bíyéé n’íí dawa baa nahazṉii’go yoo’ n’íí nayihesṉii’. ");
INSERT INTO apwNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí díí k’ehgo ánánát’éé: łóg behaidlehé nanestł’óli tayi’ yuyaa olkaadgo, łóg iłtah at’ééhíí łą́ą́go bee hanáltąą: ");
INSERT INTO apwNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Dáhalk’iłgo, tábąązhį’ ndaidistǫ’go dinezbįh, nłt’ééhíí táts’aa yiyi’ odaihezṉil, áídá’ doo nzhǫǫ dahíí yó’odaiskaad. ");
INSERT INTO apwNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Díí k’ehgo ágot’ee doleeł nnágodáhgee: Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí híkáhgo, nṉee dábik’ehyú ádaat’eehíí yits’ą́’zhį’ nṉee doo bik’ehyú ádaat’ee dahíí yita’iláh, ");
INSERT INTO apwNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Áídí’ doo bik’ehyú ádaat’ee dahíí kǫ’ yáádiṉah yuyaa oyihiłkaad: ákú daach’ichag ła’íí kowoo łídaach’idiłk’ash doo. ");
INSERT INTO apwNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus gádaabiłṉii, Ya’ díí dawa nłt’éégo bídaagonołsį née? Ha’oh, nohweBik’ehń, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesus gánábiłdo’ṉiid, Begoz’aaníí ye’ik’eda’iłchíhi dała’á ntį́į́go yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí baa bił ch’ígót’aaníí díí k’ehgo at’éé: nṉee bikįh golííníí nainonííhíí biyi’dí’ dawahá áníidéhi hik’e sá’áhíí ndi hanáyihi’ṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesus díí iłch’ígót’aahgo na’goṉi’íí ąął yaa nagosṉi’dá’ dahnasdzá. ");
INSERT INTO apwNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Áídí’ dabíí bini’yú ńyáágo Jews ha’ánáłséh goz’ąą yuṉe’ yił ch’ídaago’aahgo, nṉee bił díyadaagot’eego gádaaṉii, Hadí’go díí nṉeehíí bigoyą’ gozlíni, hagot’éégo ízisgo ánát’įįł? ");
INSERT INTO apwNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Díń la’ kįh ágole’íí biye’, bą́ą́ la’ Mary holzee, bik’isyú James, Joses, Simon ła’íí Judas daaholzee? ");
INSERT INTO apwNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bilahkííyú la’ ałdó’ kú nohwił daanlįį? Díí nṉeehíí hadí’ díí dawa nágodn’áni? ");
INSERT INTO apwNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Áí bighą bik’edaach’ishch’ii lę́k’e. Áík’ehgo Jesus gádaabiłṉii, Bik’ehgo’ihi’ṉań binkááyú na’iziidi dahot’éhé nṉee daabidnłsį, áídá’ dágolį́į́gee, bik’íí bitahyú doo hadíń bidnłsį da, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Áígee doo łą́ą́go ízisgo ánát’įįł da lę́k’e, doo daabodląą dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Áídá’ nant’án, Hérod holzéhi, Jesus ánát’įįłíí ya’ikonzįįdá’, ");
INSERT INTO apwNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Bánada’iziidi gádaayiłṉii, Áń John Baptize ágole’íí n’íí át’į́į́ ląą; daztsąądí’ naadiidzaa; áí bighą ízisgo ánát’įįł. ");
INSERT INTO apwNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Dabíntsédá’ Hérod John yiłtsoodgo łíyistł’ǫǫgo ha’áyiłt’e’ ni’, Hérod bik’isn Philip bi’aa, Heródias holzeehíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","John gábiłnṉiidhíí bighą, Áń doo bił na’aashgo ná goz’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hérod John yiziłhee hát’į́į́ ndi, nṉee łáni yénáldzid lę́k’e, Bik’ehgo’ihi’ṉań binkááyú na’iziidi daanzįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hérod bił łenágodáhgee nnágodzaago daagoch’inełįįgo Heródias bizhaazhé na’ilíhníí biṉááł ilzhishgo, Hérod yił goyiłshǫ́ǫ́ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Áík’ehgo Hérod bitł’a dahdidilṉiihgo gáyiłnṉiid, Dant’éhéta shíhóńkeedíí naa nshné’. ");
INSERT INTO apwNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Áík’ehgo na’ilíhníí bą́ą́ ábiłṉiigo, Hérod gáyiłnṉiid, Bena’ikaahíí biká’ John Baptize ágole’íí bitsits’in dahs’ąągo shaa nkáah. ");
INSERT INTO apwNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nant’ánhíí doo bił gozhǫ́ǫ́ da, áídá’ bitł’a dahdidilṉiih n’íí bighą, ła’íí nṉee yił da’iyąąhíí bighą, Baa daanohkaah, ṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ákú ił’aago, ha’áná’ilka’ yuṉe’ John bitsits’in nadain’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Áídí’ bena’ikaahíí bee bitsits’in ha’ádaiskąągo na’ilíhníí yaa yinką́ą́: áídí’ bą́ą́ yaa nainką́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","John bitsiłke’yu akú hikaigo bits’íhíí nádaidnłtįįgo, łehdaistįį, áídí’ Jesus yaa hikaigo yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesus díí ya’ikonzįįdá’ dasahn bił o’i’éél, doo hadíń naghaa dayú: áídá’ nṉee Jesus oyááhíí ya’ikodaanzįįdá’ ił’anigo kįh nagozṉildí’ dáni’ biké’ nádesąą. ");
INSERT INTO apwNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesus ákú ńyáádá’, nṉee łą́ą́go yo’įį, áí yaa daach’oba’go, daanṉiihíí nádaayilziih. ");
INSERT INTO apwNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","K’ad o’i’aahgo bitsiłke’yu baa hikai, gádaaṉiigo, Kú doo hadíń gólį́į́ da, k’ad o’i’aahzhį’ goldoh; áík’ehgo nṉeehíí dahayú gotahyú nádaadnł’áá, idáń nadaayiłṉiihyú. ");
INSERT INTO apwNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Doo nádikáh bik’eh da; nohwíígo bá da’dohné’, ṉii, Jesus. ");
INSERT INTO apwNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bitsiłke’yuhíí, Báń dijolé dá’ashdla’á zhą́ hik’e łóg dánakiyé biłgo nadaahii’né’, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Áí shaa daanohné’, daabiłṉii, Jesus. ");
INSERT INTO apwNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nṉee dawa, Ni’yú tł’oh biká’ dinohbįįh, yiłṉiidá’ báń dijolé ashdla’ihíí hik’e łóg nakihíí biłgo náidnné’go hadag déz’įįgo ya’ihénzįgo oskąądí’ iłk’ídaizné’go bitsiłke’yu yaa daizné’, áí nṉee dawa yitada’izṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Áígee nṉee dawa da’iyąągo náda’isdįįd lę́k’e: áídí’ ch’ékaadíí táts’aa nakits’ádah bik’ehgo nádaihezlaa. ");
INSERT INTO apwNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chągháshé hik’e isdzáné doo bił otago da, dá nṉee zhą́go ashdladn doo náhóltagyú áhołáni shį da’iyąą. ");
INSERT INTO apwNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Áídí’ Jesus bitsiłke’yu gáyiłṉii, Tsina’eełíí behohkáh, shádįhyú nohwił ido’éeł hanaayú, shíí nṉee nádohkáh, biłdishṉiidá’. ");
INSERT INTO apwNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nṉee nádohkáh yiłnṉiidá’, dasahndi wą́’yú óyáá, okąąhyú: o’i’ą́ą́yú ákú dasahndi naghaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Áídá’ tsina’eełíí tú iłṉí’yú hi’ołyú tú nádidáhíí nabihiłnaa lę́k’e: bidáhzhį’ nyolhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Doo hwahá ha’i’aah dayú Jesus bich’į’ higaał, tú yiká’ higaałgo. ");
INSERT INTO apwNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tú yiká’ higaałgo bitsiłke’yu daabiłtsąągo, tsídaadolyizgo, Ch’iidn át’į́į́, daaṉiigo ńdaaldzidyú daadilwosh. ");
INSERT INTO apwNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dagoshch’į’ Jesus bich’į’ hadziigo, Nohwił daagozhǫ́ǫ́ le’; shíí ásht’į́į́; doo nédaałdzid da, daabiłṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peter gábiłṉii, SheBik’ehń, da’aṉii ánt’įįyúgo, Tú biká’ shich’į’ ńṉáh, shiłnṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus, Yushdé’, biłṉii. Áídí’ Peter tsina’eełíí biyi’dí’ gódah ch’eyáágo Jesus yich’į’ tú yiká’ deyaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Áídá’ Peter adįįd nyolgo yígołsįįdgo neldzid; hayaa dezkaadá’ nádidilghaazh, SheBik’ehń, hasdáshíłteeh, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Dagoshch’į’ Jesus bich’į’ dahdidilṉiidá’ yiłtsoodgo gábiłṉii, Ni’odlą’ lántsoh ayą́há, hant’é bighą nił nagoki? ");
INSERT INTO apwNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Áídí’ tsina’eełíí yiyi’ onát’aazhdá’ nyolíí isht’idedzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tsina’eełíí yiyi’ naháztánihíí Jesus daayokąąh lę́k’e, Da’aṉii Bik’ehgo’ihi’ṉań biYe’ ńlíni ląą, daayiłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hanaayú bił nada’dez’eeldá’ ni’ Gennésaret golzeeyú hikai. ");
INSERT INTO apwNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nṉee áígee daagolííníí Jesus ya’ikodaanzįįdá’ daagotahyú dahot’éhé anákeełgo, kah yaa nakaihíí dawa baa daayihesṉil; ");
INSERT INTO apwNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nidiyágé bidá’yú zhą́ ndi bedaadenolṉíh, daabiłṉiigo nádaabokąąh: dawa bedaadelṉiihíí nádaabi’dilziih lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jerúsalemdí’ begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanlíni Jesus yaa hikai, gádaayiłṉiigo, ");
INSERT INTO apwNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Hant’é bighą nitsiłke’yú iłk’idá’ nṉee yánazįį n’íí yendaago’aahíí doo yikísk’eh ádaat’ee da? Dá doo daagonłsįgo táda’digisé da’iyąą. ");
INSERT INTO apwNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus gádaabiłṉii, Nohwíí hant’é bighą iłk’idá’ nṉee ye’ádaaṉiihíí zhą́ daahonohtą’go Bik’ehgo’ihi’ṉań yegos’aaníí doo bikísk’eh ádaanoht’ee da? ");
INSERT INTO apwNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bik’ehgo’ihi’ṉań díí k’ehgo gos’ąą, Nitaa hik’e nimaa dinłsį́, ṉii: ła’íí, Hadíń bitaa dagohíí bą́ą́ yati’ yee yokáałíí zideego bá goz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Áídá’ nohwihíí gádaadohṉii, Hadíń bitaa dagohíí bą́ą́, Nt’éhéta naa nshné’ doleeł n’íí Bik’ehgo’ihi’ṉań baa nshné’, yiłṉiihíí; ");
INSERT INTO apwNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ła’íí bitaa, bą́ą́ biłgo doo yidnłsį da ndihíí, da’áík’eh nłt’éé, daabiłdohṉii. Áík’ehgo iłk’idá’ nṉee yendaagos’aaníí bee Bik’ehgo’ihi’ṉań biyati’íí doo nt’égo ádaanołsį da. ");
INSERT INTO apwNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nohwíí, nṉee nzhóni ádaadoł’iiníí, Esáias da’aṉiigo dabíntsé nohwaa nagolṉi’ lę́k’e, gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Díí nṉeehíí dáyáti’ zhą́ yee ałhánégo shit’ah daanlįį, dáyáti’ zhą́ yee daashidnłsį, áídá’ bijíí yee doo daashidnłsį da. ");
INSERT INTO apwNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Daashokąąh ndi ch’éh ádaat’įį, nṉee yegos’aaníí zhą́ yee iłch’ídaago’aah. ");
INSERT INTO apwNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesus nṉee łáni yushdé’ daayiłnṉiidá’ gádaayiłṉii, Shídaayełts’ą́ą́go bídaagonoł’aah. ");
INSERT INTO apwNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kozé’ yuṉe’ be’ogohigháhíí doo nchǫ’go kodiłteeh da; áídá’ kozé’dí’ behagohigháhíí zhą́ nchǫ’go kodiłteehi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Áídí’ bitsiłke’yu baa hikaigo Jesus gádaayiłṉii, Áí ánṉiihíí Phárisees daanlíni daidezts’ąągo doo bił daanzhǫǫ dahíí bígonłsį́ née? ");
INSERT INTO apwNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Áídí’ gáyiłṉii, K’edolzaahíí dawa shiTaa yaaká’yú dahsdaahń doo k’eidnláá dahíí hi’ṉizh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ch’ík’eh da’áík’ehgo ádaat’ee: nṉee biṉáá ádaagodiníí ła’ biṉáá ádaagodini łolǫǫsíí k’ehgo ádaat’ee. Biṉáá ágodiníí ła’ biṉáá ágodini łolǫǫsyúgo, da’íła o’i’áń yuyaa ołiłdeeł. ");
INSERT INTO apwNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter gábiłṉii, Iłch’ígon’áahgo nagosíńłṉi’íí nohwił ch’í’ṉah áńle’. ");
INSERT INTO apwNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus gádaabiłṉii, Ya’ nohwíí ałdó’ t’ah doo nohwił ídaagozį da née? ");
INSERT INTO apwNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ya’ doo hwahá bídaagonołsįįhda, hadíí kozé’ yuṉe’ be’ogohigháhíí kobidyú bendaagowa’, áídí’ nláhyú bech’ígohigháh? ");
INSERT INTO apwNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Hadíí kozé’dí’ behagohigháhíí kojíídí’ behagohigháhi at’éé; áí nchǫ’go kodiłteehi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nchǫ’go natsí’ikeesíí, izideehíí, nant’į’ na’idaahíí, iké’ na’idaahíí, ich’in’įįhíí, łé’iłchoogo ánách’it’įįhíí, nchǫ’go yách’iłti’íí, díí dawa kojíídí’ behagohigháhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Áí nchǫ’go daakodihiṉiiłi at’éé: kogan dá doo tách’igisé da’ch’iyąąhíí doo nchǫ’go kodiłteehi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Áídí’ Jesus dahiyaago Tyre hik’e Sídon golzeehíí biṉaayú óyáá. ");
INSERT INTO apwNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Isdzán áízhį’ golíni, Cánaan hat’i’íí nlíni, baa nyáágo gábiłṉii, ShiNant’a’, David biYe’ ńlíni, shaa ch’onbáah; shizhaazhé na’ilíhníí góyéégo bich’į’ nagowaa, ch’iidn biyi’ golį́į́go. ");
INSERT INTO apwNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Da’ágát’éé ndi doo yich’į’ hadzii da. Bitsiłke’yu baa hikai, gádaabiłṉiigo, Yúwehyú nádńł’áá; áń nohwiké’ dilwoshgo anádaał. ");
INSERT INTO apwNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus gáṉíí, Israel hat’i’íí bitahyú nṉee dibełį́į́ ch’a’onehesdee’híí k’ehgo ádaat’eehíí zhą́ bighą niyáá. ");
INSERT INTO apwNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Áídí’ isdzánhíí biyahzhį’ hayaa adzaago bokąąhgo gábiłṉii, ShiNant’a’, shich’oṉiih. ");
INSERT INTO apwNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus gábiłṉii, Chągháshé báń bits’ą́’ nách’idiné’go gósé bich’į’ och’iłkaadgo doo bik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Isdzán gánábiłdo’ṉiid, Da’aṉii, shiNant’a’: da’ágát’éé ndi báń bizhool nṉee bibiká’idáné biká’dí’ nanihidéhíí, gósé daayiyąą. ");
INSERT INTO apwNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesus gánábiłdo’ṉiid, Isdzán, dázhǫ́ ni’odlą’ golį́į́ lą́! Dá hánt’įįhíí k’ehgo ná łalṉe’ doleeł. Áík’ehgo da’áí bik’ehenkéézgee bizhaazhé nłt’éé násdlį́į́. ");
INSERT INTO apwNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus dahnadiidzaago túsikaaníí Gálilee holzéhi bit’ahyú ńyáá; áídí’ dziłyú óyáágo akú dahnezdaa. ");
INSERT INTO apwNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nṉee doo ałch’ídé baa náńłsą́ą́go, nṉee doo nakai dahíí, biṉáá ádaagodiníí, doo yádaałti’ dahíí, baa dahnagoz’aaníí, ła’íí ik’e’an łą́ą́go, Jesus dées’eezgee ndaihezṉilgo nádailziih: ");
INSERT INTO apwNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Áí bighą nṉee íła’at’ééhíí nṉee doo yádaałti’ da n’íí yádaałti’go nádaasdlįįgo daayiłtsąągo, ła’íí baa dahnagoz’ąą n’íí nłt’éé nádaasdlįįgo, doo nadaakai da n’íí nłt’éégo nakai nádaasdlįįgo, biṉáá ádaagodįh n’íí biṉáá nádaagosdlįįgo daayiłtsąągo bił díyadaagot’ee: áík’ehgo Israel hat’i’i Bik’ehgo’ihi’ṉań daayokąąhíí ya’ihédaanzį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Áídí’ Jesus bitsiłke’yu yushdé’ daayiłnṉiidá’ gáyiłṉii, Díí nṉee shaa náńłsą́ą́híí baa daach’oshba’, dá bił nashkaigo taagiskąą, k’adíí doo nt’é daiyąą da: doo dá shiṉá’ nádaadish’aa hasht’į́į́ da, ágádaadzaayúgo nákaahyú dánko shiṉá’ yik’e odaatłizh. ");
INSERT INTO apwNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bitsiłke’yu gádaabiłṉii, Da’igolį́į́gee hadí’ báń díí nṉee doo ałch’ídé dahíí bá daan’né’go nádaadihii’né’? ");
INSERT INTO apwNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Báń dijolé da’kwíí nadaahné’, daabiłṉii, Jesus. Gosts’idi, ła’íí łóg ałts’ísę́hi ayą́hágo biłgo, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Áígee nṉeehíí, Ni’yú dinohbįįh, daayiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Báń dijolé gosts’idihíí, łógíí biłgo náidnné’go ya’ihénzįgo oskąądí’ iłk’ídaizné’go bitsiłke’yu yaa daizné’go nṉee yitada’izṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dawa da’iyąągo náda’isdįįd lę́k’e: áídí’ ch’ékaadíí táts’aa gosts’idi bik’ehgo nádaihezlaa. ");
INSERT INTO apwNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Isdzáné hik’e chągháshé doo bił otago da, dá nṉee zhą́go dį́į́dn doo náhóltagyú áhołáni shį da’iyą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Áídí’ nṉee baa náńłsą́ą́ n’íí onádaihes’a’dá’, bíhíí ni’ Mágdala golzeehíí biṉaayú bił o’i’éél. ");
INSERT INTO apwNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Phárisees hik’e Sádducees daanlíni Jesus yaa hikai, nabídaantaah daanzįgo, Yaaká’dí’ godiyįhgo be’ígóziníí nohwił ch’í’ṉah áńle’, daabiłṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesus gádaabiłṉii, O’i’aahgee gádaadohṉii dák’eh, Gonłt’éé doleeł ląą ko: yaak’os łichiihíí be’ígózį. ");
INSERT INTO apwNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Áídá’ t’ahbįdá’ gádaadohṉii dák’eh, Dégóchǫ’go o’i’aah ląą: yaak’os łichiigo dábégódzidgo bił hayiłką́ą́híí be’ígózį. Nohwíí nṉee nzhóni ádaagonoł’iiníí, yáá daaneł’į́į́go hago ágoṉéhíí bídaagonołsį; áídá’ k’ad ágoṉéhíí doo bídaagonołsį da. ");
INSERT INTO apwNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nchǫ’go ádaat’éhi nant’į’ nakaihi daałinolt’įįłíí godiyįhgo be’ígóziníí yiká daadéz’įį; áídá’ be’ígóziníí doo bił ch’í’ṉah ádaalṉe’hi at’éé da, Bik’ehgo’ihi’ṉań binkááyú na’iziidi, Jonas holzéhi, nṉee bich’į’ be’ígózįh alzaahíí zhą́. Áídá’ Jesus bits’ą́’ dahnasdzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesus bitsiłke’yu hanaazhį’ bił naná’diz’eeldá’, báń yínádaasṉah lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus gádaabiłṉii, Báń benilzoołé, Phárisees hik’e Sádducees daanlíni bíyééhíí, baa daagonohsąą, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bitsiłke’yu iłch’į’ yádaałti’go gádaaṉii, Báń doo daasii’né’ dahíí bighą aṉíí. ");
INSERT INTO apwNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus ádaaṉiihíí yígółsįgo gábiłṉii, Nohwíí nohwi’odlą’ da’ayą́háhi, hant’é bighą báń doo daasooné’ dahi baa iłch’į’ yádaałti’? ");
INSERT INTO apwNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ya’ doo hwahá bídaagonołsįįh da? Báń dijolé ashdla’i nṉee ashdladn doo náhóltag dago bá da’desné’ n’dá’ ch’ékaadíí da’kwíí táts’aa bik’ehgo ńdaahesoolaa n’íí, ya’ doo bínádaałṉiih da née? ");
INSERT INTO apwNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Łah ałdó’ báń dijolé gosts’idi, nṉee dį́į́dn doo náhóltag dago bá da’desné’ n’dá’ ch’ékaadíí da’kwíí táts’aa bik’ehgo ńdaahesoolaa n’íí, ya’ doo bínádaałṉiih da née? ");
INSERT INTO apwNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nt’é bighą doo nohwił ídaagozį da? Báń benilzoołé Phárisees hik’e Sádducees daanlíni bíyééhíí baa daagonohsąą, nohwiłdéṉiidíí, báń doo baa yashti’go ádishṉii da. ");
INSERT INTO apwNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bitsiłke’yu áníita yídaagołsįįd, Báń benilzoołé baa daagonohsąą, doo ṉiigo aṉíí da, áídá’ Phárisees hik’e Sádducees daanlíni hagot’éégo iłch’ídaago’aahíí baa daagonohsąą, ṉiigo aṉíí lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesus Caesaréa Philíppi golzéhi biṉaayú ńyáágo bitsiłke’yu nayídaadiłkidgo gáyiłṉii, Shíí, nṉee k’ehgo Niyááhíí, nṉee hadíń nshłįį daashiłṉii? ");
INSERT INTO apwNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bitsiłke’yu gádaabiłṉii, Ła’, John, Baptize ágoł’įį n’íí át’į́į́, daaniłṉii; ła’ihíí, Elías at’į́į́; ła’ihíí Jeremías; dagohíí Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí át’į́į́ daaniłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesus gánábiłdo’ṉiid, Nohwíí nohwich’į’yúgohíí, hadíń át’į́į́ daashiłdohṉii? ");
INSERT INTO apwNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter gábiłṉii, Ni Christ ánt’įį, Bik’ehgo’ihi’ṉań hiṉáhi biYe’. ");
INSERT INTO apwNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesus gábiłṉii, Simon Bar‐jóna, ni niyaa gozhǫ́ǫ́ le’: its’í hik’e dił nlíni doo nił ch’í’ṉah áyíílaa da, shiTaa yaaká’yú dahsdaahń zhą́ nił ch’í’ṉah áyíílaago ádíńṉiid. ");
INSERT INTO apwNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ła’íí gániłdishṉii, Ni Peter honlzéhi, daashodlaaníí kįh ágoch’ile’híí k’ehgo díí tsééhíí biká’ yishtł’į: áík’ehgo ch’iidntahdí’ ch’iidn binawodíí doo bitis hileeh da. ");
INSERT INTO apwNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yaaká’yú dahsdaahń bilałtł’áhgee goz’aaníí bá be’igęęsé naa nshṉííł: áík’ehgo nt’éhéta ni’gosdzáń biká’ łesíńtł’ooníí yaaká’yú ałdó’ łestł’ǫǫ doleeł; nt’éhéta ni’gosdzáń biká’ k’e’íín’aahíí yaaká’yú ałdó’ k’e’dot’aah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesus bitsiłke’yu gádaayiłṉii, Shíí Jesus, Christ nshłiiníí hadíń bił nadaagolṉi’ hela’. ");
INSERT INTO apwNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Áídí’ godezt’i’go Jesus, Jerúsalemyú deyaago Jews yánazíni, okąąh yebik’ehi itisyú nadaandeehi, ła’íí begoz’aaníí ye’ik’eda’iłchíhi biniidaagodnle’íí, ła’íí bidizideedí’ taagi jįį hileehgo naadiidáhíí dahkodá’ bitsiłke’yu yił na daagolṉi’go nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter t’ąązhį’ bich’į’ hananádziigo gáṉíí, SheBik’ehń, díí nits’ą́’zhį’ begoz’ąą le’: nich’į’ begolṉe’ hela’. ");
INSERT INTO apwNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus t’ąązhį’ adzaago Peter yich’į’ hadziigo, Satan, yúwehyú shiká’zhį’ ánṉe’: ni shił godnłkísh: Bik’ehgo’ihi’ṉań binatsekeesíí k’ehgo doo natsíńkees da ląą, nṉee binatsekeesíí zhą́ bee natsíńkees, biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesus bitsiłke’yu gádaayiłṉii, Dahadíń shiké’ dahdigháh hát’į́į́yúgo, ídaayo’ṉahdá’ bitsį’iłna’áhi dahyidotįįhgo shiké’ dahdowáh. ");
INSERT INTO apwNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Dahadíń bi’ihi’ṉa’ yaa bił goyééhíí, áí bits’ą́’ da’ilíí hileeh: áídá’ dahadíń ídaayis’ṉahgo shíí shighą bi’ihi’ṉa’ da’ilíí silįį’íí, áń ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doo. ");
INSERT INTO apwNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ni’gosdzáń dágoz’ąą nt’éégo ch’ist’įįdá’ koyi’siziiníí da’ilíí silįįyúgo, áí hant’é bits’ą́’dí’ ch’it’įįh? Dagohíí koyi’siziiníí hant’é bideṉá nch’iné’? ");
INSERT INTO apwNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Shíí, nṉee k’ehgo Niyááhíí, shiTaa bits’ą́’idindláádíí bee shits’ą́’idindláádgo, binal’a’á yaaká’yú daagolííníí bił nánshkáh; áígee nṉee dała’á daantį́į́gee ánát’įįdíí dábik’ehgo bich’į’ nadi’ish’ṉił. ");
INSERT INTO apwNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Da’aṉii gánohwiłdishṉii, Kúgee nadaaziiníí ła’ dá doo da’itsaahíí dailįįhé shíí, nṉee k’ehgo Niyááhíí, nant’án nshłįįgo náshdaałgo daashiłtsąągo zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Áídí’ gostáń iskąągee Peter, James, hik’e John, bik’isnhíí, biłgo Jesus dasahndi yił okai lę́k’e, dził n’ááyú. ");
INSERT INTO apwNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Áígee binadzahgee Jesus łahgo ánolįh silįį: binii bik’ina’didlaad silįį, ya’áí k’ehgo, bidiyágéhíí łigai silįį, idindláádhíí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nt’éégo áígee Moses hik’e Elías bił daanlįįgo silįį, Jesus yił yádaałti’go. ");
INSERT INTO apwNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter Jesus gáyiłṉii, NohweBik’ehń, kú nkaihíí nohwá nzhǫǫ: hánt’įįyúgo dząągee tł’ohdahskáń taago ádaagohiidle’; ła’ ni ná, ła’ihíí Moses bá, ła’ihíí Elías bá. ");
INSERT INTO apwNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","T’ah yałti’go áígee yaak’os dázhǫ́ bits’ą́’idindládi biká’ dahiyaa: nt’éégo yaak’os biyi’dí’ yati’ yidezts’ąą gáṉíígo, Díínko shiYe’ shił nzhóni, baa shił gozhóni; áń hódaayołts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Díí daidezts’ąągo Jesus bitsiłke’yu hayaa ádaasdzaa, ńdaaldzidgo. ");
INSERT INTO apwNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus baa nyáágo bedaadesṉiigo gádaabiłṉii, Daohsįįh, doo ńdaałdzid da. ");
INSERT INTO apwNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hadag daadéz’įį hik’e nṉee doo ła’ dadá’ Jesus zhą́ daayo’įį. ");
INSERT INTO apwNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dziłdí’ hayaa nákahdá’ Jesus gádaabiłṉii, Daahołtsąą n’íí hadíń bił nadaagołṉi’ hela’, shíí, nṉee k’ehgo Niyááhíí, dasitsą́ą́dí’ naadisdzaago zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bitsiłke’yu nabídaadiłkidgo gádaabiłṉii, Hant’é bighą Elías dantsé hígháh, daaṉii, begoz’aaníí ye’ik’eda’iłchíhi? ");
INSERT INTO apwNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus gádaabiłṉii, Elías da’aṉii dantsé hígháhgo dawahá iłch’į’nádaidle’. ");
INSERT INTO apwNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Áídá’ gánohwiłdishṉii, Elías iłk’idá’ ńyáá, ndi doo bídaagoch’iłsį da ni’, áídá’ dá hádaach’it’įįyú ánádaach’ol’įįł lę́k’e. Áí k’ehgo shíí, nṉee k’ehgo Niyááhíí, ałdó’ ádaashich’idoliił. ");
INSERT INTO apwNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","John, Baptize ágoł’įį n’íí, áyiłṉiigo bitsiłke’yu yídaagołsįįd. ");
INSERT INTO apwNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nṉee łą́ą́go íła’at’ééhíí yaa hikaigo nṉee ła’ Jesus yaa nyáágo yich’į’ hilzhiizhgo gábiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ShiNant’a’, shiye’ baa ch’onbáah; onátłishgo goyéégo bich’į’ nagowaa: łahgee kǫ’ yeh naká’, łahgeehíí tú yeh naká’. ");
INSERT INTO apwNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nitsiłke’yu baa bił ni’áázh ndi doo hagot’éégo iłch’į’ ánádaidle’ da. ");
INSERT INTO apwNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus gádaabiłṉii, Nohwi’odlą’ édaadįhgo, dánohwíí zhą́ daanohwik’ehgo daałinołt’įįłíí, dahosahzhį’ nohwił nahashtą́ą́? Dahosahzhį’ ląą nohwidag ánsht’ee? Yushdé’ niye’ shich’į’ bił nn’áash. ");
INSERT INTO apwNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesus ch’iidn nłdzilgo yich’į’ hadziigo ishkiiníí yiyi’dí’ háyáá: áík’ehgo da’áí bik’ehenkéézgee nłt’éé násdlį́į́. ");
INSERT INTO apwNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Áík’ehgo Jesus bitsiłke’yu dasahndiyú baa hikaigo, Nééhíí hant’é bighą doo hadaandzóód da láń? daabiłṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesus gádaabiłṉii, Nohwi’odlą’ da’ayą́háhíí bighą: da’aṉii gádaanohwiłdishṉii, Nohwi’odlą’ mustard biyígé ga’at’éé ndi, díí dziłíí bich’į’ hadaahdziigo, Yúwehégo dihi’ṉáh, daabiłdohṉiiyúgo, ágáṉéh: doo nt’é ch’éh ádaał’įį da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Áídá’ díí ga’at’éhihíí dáshiṉá’ da’ch’okąąhgo zhą́ habidi’nedzódihi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Gálilee golzeegee naháztąądá’ Jesus bitsiłke’yu gádaayiłṉii, Shíí, nṉee k’ehgo Niyááhíí, shik’edaanṉiihíí bilák’e shi’dolteeł: ");
INSERT INTO apwNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Daashiziłheedá’ taagi jįį hileehgo naadishdáh, ṉii. Áí bighą bitsiłke’yu bijíí daanṉiih lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Capérnaum golzeeyú hikaigo tribute bich’į’ nada’ch’iṉiiłíí Peter yaa hikaigo, Ya’ niłch’ígó’aahíí naná’i’ṉiłihíí nayiṉiił née? daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peter, Ha’oh, ṉii. Kįh yuṉe’ oyáágo Jesus ntsé bich’į’ hadziigo gábiłṉii, Hagot’éégo baa natsíńkees, Simon? Ni’gosdzáń biká’ ízisgo nant’án daanliiníí, hadíń tax dagohíí tribute bich’į’ nayiṉiił? Ya’ dabíí bichągháshéhíí née, dagohíí nanidí’ nakaihíí née? ");
INSERT INTO apwNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter, Nanidí’ nakaihíí, ṉii. Jesus gánábiłdo’ṉiid, Áík’ehgo bichągháshé doo nada’hiṉiił da. ");
INSERT INTO apwNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Da’ágát’éé ndi, doo hadaashkee da doleełhíí bighą, túsikąąyú ńṉáh, łóg behahidleehíí táyi’ ołdeełgo, łóg dantsé hánlee’íí bizé’ iłts’ą́’ ánle’; ákóṉe’ zhaali siné’ihíí hanné’go tribute bich’į’ nada’ch’iṉiiłíí shíí shá ła’íí ni ná bich’į’ nahiṉííł. ");
INSERT INTO apwNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Áídá’ Jesus bitsiłke’yu baa hikaigo gádaabiłṉii, Yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí bitahyú hadíń itisgo nlįį? ");
INSERT INTO apwNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Áík’ehgo Jesus chągháshé ałts’ísę́hi dała’á yushdé’ yiłṉiigo, bit’ahdí’ dahyinesdaago, ");
INSERT INTO apwNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Gáṉíí, Da’aṉiigo gánohwiłdishṉii, Nohwinchǫ’íí bits’ą́’zhį’ ádaahṉe’go chągháshé ałts’ísę́híí k’ehgo ádaadohdle’yúgo zhą́ yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí itah hohłeeh. ");
INSERT INTO apwNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Dahadíń díí chągháshéhíí k’ehgo ídaagoch’iyolba’íí, yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí bitahyú da’áń itis nlįį. ");
INSERT INTO apwNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Dahadíń shizhi’íí binkááyú chągháshé díí ga’at’ééhíí náidnłtįįyúgo, shíí náshidnłtíni at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Dahadíń díí doo ízisgo ádaat’ee da ndi daashodląąhíí dała’á nchǫ’go at’į́į́go áile’íí, áń tséé be’ik’áhi nchaahi bik’osyú bidestł’ǫǫgo túnteel beh hilt’e’go tú yił didziihgo bá nzhǫǫ doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ni’gosdzáń biká’ nṉee nakóntaahíí bá góyéé doleeł: nakódintaahíí dá begolṉéh go’į́į́; áídá’ hadíń na’íntaahíí bá góyéé doleeł! ");
INSERT INTO apwNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Áík’ehgo nigan dagohíí nikee nchǫ’go ánát’įįł áníłsįyúgo, nadnłgeeshgo yó’ołt’e’: doo hagot’éégo nanṉaa da ndi, nits’í łahzhį’ ádįh ndi dahazhį’ ihi’ṉaahíí biyi’ onṉáhgo doo hago’at’éé da, áídá’ nigan nakigo hik’e nikee nakigo kǫ’ dahazhį’ diltłi’íí biyi’ yuyaa oni’dilt’e’yúgo doo ná nzhǫǫ da. ");
INSERT INTO apwNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Niṉáá nchǫ’go ánát’įįł áníłsįyúgo, ha’aahgo yó’ołṉe’: niṉáá dała’á ádįh ndi dahazhį’ ihi’ṉaahíí biyi’ onṉáhgo doo hago’at’éé da, áídá’ niṉáá nakigo ch’iidn bikǫ’ diltłi’i biyi’ yuyaa oni’dilt’e’yúgo doo ná nzhǫǫ da. ");
INSERT INTO apwNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ídaa daagonohdząą, díí doo ízisgo ádaat’ee dahíí ła’ doo daach’ohłaa da; yaaká’yú Bik’ehgo’ihi’ṉań binadaal’a’á biṉádaadéz’iinihíí, shiTaa yaaká’yú dahsdaahń biniizhį’ dahazhį’ daabineł’į́į́, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Shíí, nṉee k’ehgo Niyááhíí, ch’a’onehesdeehíí hasdáhishṉiiłhíí bighą niyáá. ");
INSERT INTO apwNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Díí hagot’éégo baa natsídaahkees? Nṉee bidibełį́į́ dała’á gonenadín golį́į́dá’ dała’á ch’a’oyááyúgo, ngost’ádin ngost’áíhíí dákú nyiṉííłdá’ dziłyú ch’a’oyáá n’íí hantaa gá? ");
INSERT INTO apwNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Da’aṉiigo gádaanohwiłdishṉii, Náidnłtįįyúgo ngost’ádin ngost’áí doo hak’i ch’a’okai dahíí dawa bitisgo náid nłtiiníí yaa bił gozhǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Áík’ehgo shiTaa yaaká’yú dahsdaahń díí doo ízisgo ádaat’ee dahíí dała’á ndi doo ch’a’okaad hat’į́į́ da. ");
INSERT INTO apwNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nik’isn nich’į’ nchǫ’go adzaayúgo, bich’į’ ńṉáhgo bi’at’e’íí dasahndi bee bich’į’ yáńłti’: nidits’agyúgo, nik’isn hosíńłbáni at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Áídá’ doo nidits’ag dayúgo, dała’á dagohíí naki biłgo bich’į’ bił nkáh, áík’ehgo naki dagohíí taagi hilt’eego biṉááł bee yá’iti’íí da’aṉiigo bee bígózį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Díí ndi doo yidits’ag dayúgo, Bik’ehgo’ihi’ṉań daayodlaaníí ha’ánáłséhyú baa nagolṉí’: áí ndi doo yidits’ag dayúgo, doo Jew nlįį dahíí, tax bich’į’ nahi’ṉiiłíí k’ehgo baa natsíńkees doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Da’aṉiigo gádaanohwiłdishṉii, Nt’éhéta ni’gosdzáń biká’ łédaasołtł’ǫǫhíí yaaká’yú ałdó’ łestł’ǫǫ doleeł; nt’éhéta ni’gosdzáń biká’ k’éda’so’aahíí yaaká’yú ałdó’ k’e’do’t’aah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Gánánohwiłdish’ṉii, Naki dołt’eego ni’gosdzáń biká’ nt’éhéta dała’ haht’į́į́ lę́k’eyúgo hohkeedgo, shiTaa yaaká’yú dahsdaahń nohwá áile’. ");
INSERT INTO apwNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Dahayú naki dagohíí taagi hilt’eego shizhi’ yee da’okąąhgo íła’at’ééyúgo, áígee iłṉí’gee shíí nshłįį. ");
INSERT INTO apwNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Peter baa nyáágo gábiłṉii, SheBik’ehń, shik’isn shich’į’ dénchǫ’go ánát’įįłyúgo, da’kwiidnshą’ baa nágodinsh’aah, gosts’idn née? ");
INSERT INTO apwNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus gábiłṉii, Gosts’idn doo niłdishṉii da, ndi gosts’idinhíí gosts’idngo. ");
INSERT INTO apwNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí nant’án bánada’iziidíí baa hadaaz’aahíí iłk’ídaagodiłdǫǫh hádaat’įįhíí k’ehgo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yołtag nkegonyaagee, bána’iziidi ła’ gonenáń doo náhóltagyú talents golzeego baa ha’ááhi baa híl’a’. ");
INSERT INTO apwNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Doo hagot’éégo na’iṉiił dahíí bighą, Díí nṉeehíí, bi’aahíí, hik’e bichągháshéhíí, ła’íí dawa bíyééhíí biłgo nahoṉíih, áí bee shich’į’ nanáhó’ṉííł, ṉiigo bángon’ą́ą́, binant’a’. ");
INSERT INTO apwNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Áík’ehgo bána’iziidíí bich’į’ hayaa adzaago nábokąąhgo, Shinant’a’, ntsé ńt’ah, ąął nich’į’ na’ishṉiił ndi at’éé, biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Áík’ehgo binant’a’íí baa ch’oba’go, Doo shich’į’ na’iṉííł da ndi nzhǫǫ, biłṉiigo nanábines’įįd. ");
INSERT INTO apwNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Áídá’ áń ch’íńyáágo ła’ yił na’iziidi, dała’á gonenadín pence golzeego baa hayił’áhi, yiłtsąą: áń yizidnłtsoodgo, Shaa hánł’aahíí shich’į’ nanáhí’ṉííł, yiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yił na’iziidíí bich’į’ hayaa adzaago nábokąąhgo, Ntsé ńt’ah, dawa nich’į’ na’ishṉiił ndi at’éé, biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ndi, Dah, ṉiigo ha’áyíłt’e’, baa ha’ááhíí na’hazṉilzhį’. ");
INSERT INTO apwNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ła’ yił nada’iziidíí daabiłtsąągo doo bił daagozhǫ́ǫ́ dago díí ágodzaahíí dawa binant’a’ yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Áídí’ binant’a’íí biká’íł’aadgo gábiłṉii, Ni shána’izíidíí dázhǫ́ ńchǫ’ ląą, ni shaa háńł’áhi doo shich’į’ nanáhí’ṉííł da ndi nzhǫǫ, niłdéṉiid ni’, náshonkąąhgo: ");
INSERT INTO apwNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Áík’ehgo ni ałdó’ bił na’izíidíí baa ch’onba’ le’at’éhi, shíí naa ch’osibáadhíí k’ehgo, ");
INSERT INTO apwNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Áík’ehgo binant’a’ hashkeego ha’áná’ilka’ yuṉe’ obił’a’ biniigodilṉéhgo, baa ha’ááhíí dawa nanáyihezṉilzhį’. ");
INSERT INTO apwNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Díí k’ehgo shiTaa yaaká’yú dahsdaahń ádaanohwile’, doo nohwijíídí’ nohwik’isn nohwich’į’ nchǫ’go at’ééhíí bighą baa nádaagodinoh’aah dayúgo. ");
INSERT INTO apwNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesus díí ąął yee nyánłti’dá’ Gálileedí’ dahnyaa lę́k’e, ni’ Judéa golzeeyú, túńlííníí Jórdan holzéhi bitisyú ńyáá; ");
INSERT INTO apwNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Áígee nṉee biké’ náńłsą́ą́go nádaayilziih lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Phárisees daanlíni ałdó’ baa hikaigo nabídaantaahgo gádaabiłṉii, Ya’ nṉee hant’éhéta bighą bi’aa yił iłk’ínát’aashgo goz’ąą née? ");
INSERT INTO apwNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus gádaabiłṉii, Ya’ díí doo hwahá daahohshiih da née, dantsé godeyaadá’ Bik’ehgo’ihi’ṉań nṉee áyíílaahń, nṉee ła’íí isdzán áyíílaa lę́k’e, ");
INSERT INTO apwNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Gáṉíígo, Díí bighą nṉee bitaa hik’e bą́ą́ yits’ą́’gháhgo bi’aa yił nlįį doleeł: áí naki n’íí dała’á nádodleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Áík’ehgo doo naki dilt’ee dadá’ bits’í dała’á silįį. Áík’ehgo dahadíń Bik’ehgo’ihi’ṉań łayinlááhíí, dahadíńta iłk’íyóléh hela’. ");
INSERT INTO apwNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Phárisees gádaabiłṉii, Ágát’éédá’, nt’é bighą naltsoos bee iłk’íńch’ít’aashíí łayile’go isdzánhíí yił iłk’ínát’aashgo Moses ngon’ą́ą́ láń gá? ");
INSERT INTO apwNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus gádaabiłṉii, Moses nohwijíí daantł’izíí bighą nohwi’aa bił iłk’ínát’aashgo nohwá ngon’ą́ą́ lę́k’e: ndi dantsé godeyaadá’ doo ágágot’ee da ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Shíí gádaanohwiłdishṉii, Hadíń bi’aa doo nṉee ła’ yił nant’į’ na’aash dadá’, yił iłk’ínát’aazhdá’ yił naná’ṉááyúgo nant’į’ nagháhi at’éé: hadíń isdzán yó’olt’e’ n’íí yił nṉááyúgo, áń ałdó’ nant’į’ nagháhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bitsiłke’yu gádaabiłṉii, Na’i’ṉeehíí ágát’ééyúgo, doo nch’iṉéh da ndi nzhǫǫ. ");
INSERT INTO apwNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus gádaabiłṉii, Doo nṉee dawa díí yídaanel’ąą da, hadíí ye’at’éé doleełgo baa daadest’aaníí zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nṉee ła’ doo nnádaałsé’ dago daabi’deshchíni ádaat’ee: áídá’ ła’íí doo nnádaałsé’ dago ádaalṉe’: ła’íí dabíí hádaat’įįgo yaaká’yú dahsdaahń bilałtł’áhgee begoz’ąąhíí bighą doo nnádaałsé’ da. Hadíń díí yínel’aaníí ch’ík’eh ye’at’éé le’. ");
INSERT INTO apwNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jesus chągháshé ałts’ísę́hi baa bił nch’ihezkai lę́k’e, yiká’ ndaadilṉiihgo yá okąąh daabich’o’ṉíígo: áídá’ bitsiłke’yu Doo ágádaaht’įį da, daakołṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Áídá’ Jesus gáṉíí, Ch’ík’eh chągháshé shich’į’ nihikáh le’, doo t’ąązhį’ daahínóhtą’ da; bíí ga’ádaat’eehíí yaaká’yú dahsdaahń bilałtł’áhgee daanlįį. ");
INSERT INTO apwNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chągháshé ąął yiká’ ndaadesṉiihdá’ onádzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nt’éégo nṉee ła’ Jesus yaa nyáágo gáyiłṉii, Iłch’ígó’aahíí nłt’éhi ńlínihi, hago ląą nłt’éhi áshṉe’go ihi’ṉaa doo ngonel’ąą dahíí yaaká’yú bee hinshṉaa doleeł? ");
INSERT INTO apwNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus gábiłṉii, Nt’é bighą nłt’éhi shiłnṉii? Doo hadíń nłt’éé da go’į́į́, dała’á zhą́, Bik’ehgo’ihi’ṉań zhą́: áídá’ ihi’ṉaa nłt’éhi biyi’ onṉáh háńt’įįyúgo, Bik’ehgo’ihi’ṉań yegos’aaníí bikísk’eh áńt’ee le’. ");
INSERT INTO apwNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Daat’éhihíí? ṉii. Jesus gábiłṉii, Doo ich’iziłhee da, Doo nant’į’ nach’ighaa da, Doo ich’in’įįh da, Doo łé’ ch’iłchoo da, ");
INSERT INTO apwNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kotaa hik’e komaa ch’idnłsį: ła’íí, Kot’ahdí’ gólííníí koł nzhǫǫ, dakíí ídił ch’ijǫǫhíí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nṉee áníi nagháhihíí gábiłṉii, Ánists’ísę́dí’ godezt’i’go díí dawa be’ánsht’ee: áídá’ nt’é zhą́shą’ doo be’ánsht’ee da? ");
INSERT INTO apwNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus gábiłṉii, Nzhǫǫ nleeh háńt’įįyúgo, ti’i, dawahá ṉíyééhíí naa nahoṉiihgo zhaalihíí tédaat’iyéhíí bita’iṉííh, áík’ehgo yaaká’yú dawahá łáń ílíni ṉíyéé doleeł: áídí’ yushdé’ shiké’ dahsinṉáh. ");
INSERT INTO apwNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Áídá’ nṉee áníi nagháhihíí díí yidezts’ąądá’, doo bił gozhǫ́ǫ́ dago onádzaa: dázhǫ́ háłdzilhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesus bitsiłke’yu gádaayiłṉii, Da’aṉiigo gánohwiłdishṉii, Nṉee háłdzili yaaká’yú dahsdaahń bilałtł’áhgee daanliiníí itah hileehgo bá nyee. ");
INSERT INTO apwNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gánádaanohwiłdish’ṉii, Łį́į́ bigháń ha’i’áhíí bená’kadé bigha’i’áńyú ch’égháhgo bá nyeedá’ nṉee háłdzilíí Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah hileehgo itisgo bá nyee. ");
INSERT INTO apwNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bitsiłke’yu díí daidezts’ąądá’ bił díyadaagot’eego gádaaṉii, Áídá’ hadíń zhą́ hasdábi’dilteeh? ");
INSERT INTO apwNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus daabineł’į́į́go gáṉíí, Nṉeehíí áí doo łayole’ at’éé da go’į́į́; Bik’ehgo’ihi’ṉań zhą́ dawa łayile’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peter gábiłṉii, Isąą, nohwíyéé dawa bits’ą́’ dahdihiikaidá’ niké’ dahsiikai ni’: áígee nt’é nohwich’į’ nahi’ṉiił? ");
INSERT INTO apwNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus gádaabiłṉii, Da’aṉiigo gánohwiłdishṉii, Dawa áníidégo ánálzaago, shíí, nṉee k’ehgo Niyááhíí, nant’án biká’dahsdáhá bits’ą́’idindláádíí biká’ dahsidaago, nohwíí shiké’ nahkaihíí ałdó’ nant’án biká’ dahsdáhá nakits’ádah biká’ dahnahísóotąą doleeł, Israel nakits’ádah hat’i’íí yaa yádaałti’go. ");
INSERT INTO apwNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Dahadíń bigową, bik’isyú, bilahkííyú, bitaa, bą́ą́, bi’aa, bichągháshé, dagohíí bini’ shizhi’híí bighą yits’ą́’ dahnyaahíí, dała’á gonenadín ánáhołąągo baa det’aahi at’éé, ła’íí ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doleeł, yaaká’yú. ");
INSERT INTO apwNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Áídá’ łą́ą́go dantsé daanlįį n’íí iké’yú doleeł; ła’íí iké’yú daanlįį n’íí dantsé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí díí k’ehgo at’éé: nṉee dahts’aa hentííníí bíyéé gólíni dázhǫ́ t’ahbiyú bánada’iziidíí hantaayú dahiyaa. ");
INSERT INTO apwNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nṉee bánada’iziidíí penny yich’į’ na’iṉiiłgo yángon’ą́ą́dá’ bidahts’aa hentį́į́yú odais’a’. ");
INSERT INTO apwNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ngost’áí bik’ehenkéézyú shį onanádzaago na’hiṉiih nagoz’ąąyú ła’ daazhógo nadaazįįgo yiłtsąągo, ");
INSERT INTO apwNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Gádaayiłṉii, Nohwíí ałdó’ shidahts’aa hentį́į́yú dohkáh, dábik’ehgo nohwich’į’ nahishṉiił ndi at’éé. Áík’ehgo áí ałdó’ ákú okai. ");
INSERT INTO apwNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Isk’áhńyááyú ła’íí taagi bik’ehenkéézyú shį onanádzaago da’ágánánádzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ashdla’i bik’ehenkéézyú shį onanádzaago ákú ła’ daazhógo nadaazįįgo náyíłtsąą, Hant’é bighą daazhógo nasozįįgo o’i’ą́ą́? yiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Doo hadíń na’idziid nohwaidi’aah dahíí bighą, daabiłṉii. Nohwíí ałdó’ shidahts’aa hentį́į́yú dohkáh, yiłṉii. Dábik’ehgo nohwich’į’ nahishṉiił ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","O’i’ą́ą́yú dahts’aa hentííníí bíyééhíí bik’ehgo na’idziidi gáyiłṉii, Shánada’iziidíí bich’į’ ádaanṉiigo bich’į’ nada’hiṉííł, da’iké’yú náda’nziidíí ntsé, áídá’ dantsé náda’nziidíí iké’yú. ");
INSERT INTO apwNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ashdla’i bik’ehenkéézyú shį náda’nziid n’íí ákú hikaigo dała’á ntį́į́go penny bich’į’ nahas’ṉil. ");
INSERT INTO apwNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dantsé náda’nziid n’íí ákú hikaigo, néé itisgo nohwich’į’ nahi’ṉiił, daanzį lę́k’e; da’ágát’éé ndi dała’á ntį́į́go penny zhą́ bich’į’ nahas’ṉil. ");
INSERT INTO apwNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Díí bich’į’ nahas’ṉilhíí bighą nṉee bidahts’aa golííníí yída’iłtahgo, ");
INSERT INTO apwNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Gádaabiłṉii, Dała’ádn łédihikeezzhį’ nada’iziid n’íí néé bił dáłełt’eego nohwich’į’ naháńṉil, néé gozdogyú nyeego nada’idziidgo o’i’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nant’ánhíí na’iziidíí ła’ gáyiłṉii, Shit’eké, doo hagot’éégo nich’į’ natseskees da: penny nich’į’ nadihishṉiił, niłdishṉiigo, da’áígee nił nzhǫǫ ni’ ya’? ");
INSERT INTO apwNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nich’į’ na’heṉilihíí nádnné’go nádńdáh: díí iké’yú na’nziidíí áń ałdó’ nich’į’ na’háńṉilhíí k’ehgo bich’į’ na’hishṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Dashíí shíyééhíí dashíí hásht’į́į́yú ánásh’įįłgo, áí doo shá goz’ąą da née? Ya’ nił nṉii née, nłt’éégo ánsht’eehíí bighą? ");
INSERT INTO apwNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Áík’ehgo iké’yú daanlįį n’íí dantsé doleeł, ła’íí dantsé daanlįį n’íí iké’yú doleeł: łą́ą́go yiká ádaanṉiid ndi da’akwíyé habi’do’ṉil. ");
INSERT INTO apwNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus wą́’yú Jerúsalemyú bitsiłke’yu yił hikaahgo k’ihzhį’ yił nikaigo gádaayiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Isąą, Jerúsalemyú dekai; ákú shíí, nṉee k’ehgo Niyááhíí, okąąh yebik’ehi itisyú nadaandeehíí hik’e begoz’aaníí ye’ik’eda’iłchíhi biłgo baa shi’dilteehdá’ shidizideego shá ngot’áah doleeł, ");
INSERT INTO apwNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Áídí’ doo Jews daanlįį dahíí yaa daashiłtéehgo shaa daadloh doo, hashída’iłtsaas doo, áídí’ tsį’iłna’áhi bídaashiłkałgo daashiziłhee doleeł: áídí’ taagi jįį hileehgo naadishdáh. ");
INSERT INTO apwNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zébedee bichągháshé bą́ą́híí binṉe’híí Jesus yaa yił hikaigo yich’į’ daahilzhiizh, nahídóshkid nzigo. ");
INSERT INTO apwNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nt’é háńt’įį gá? biłṉii, Jesus. Isdzán gábiłṉii, Nant’án síńlįįgo dahnándaago díí shinṉe’yu nakihíí ła’ nigan dihe’nazhiṉéé dahsdaa doleełgo, ła’íí ni’eshganzhiṉéé dahsdaa doleełgo bá ngon’áah. ");
INSERT INTO apwNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Áídá’ Jesus gádaabiłṉii, Nt’é biká hádaaht’iiníí doo bídaagonołsį da ląą. Idee be’ishdląąhíí be’ohdląągo bínołdzil née, ła’íí baptize be’áshi’dilṉe’íí bee baptize ánohwi’dilṉe’go bínołdzil née? Bínldzil, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus gánábiłdo’ṉiid, Idee be’ishdląąhíí da’aṉii be’ohdląą doleeł, ła’íí baptize áshi’dilṉe’íí da’aṉii bee baptize ánohwi’dilṉe’ doleeł: áídá’ shigan dihe’nazhiṉéé dagohíí shi’eshganzhiṉéé sodaa doleełíí, doo shíí nohwaa godesh’aah da, áí dahadíń shiTaa yágoz’aaníí zhą́ bágoz’áni at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iłk’isyú nakihíí ádaaṉiihíí Jesus bitsiłke’yu gonenanhíí daidezts’ąądá’ doo bił daabik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesus bitsiłke’yu íła’áyíílaago gádaayiłṉii, Doo Jews daanlįį dahíí binadaant’a’íí isná ádaabiłsįgo bá nadaant’aah, ła’íí bitahyú nṉee ízisgo ádaat’eehíí da’áṉííyú ádaat’įįgo ádaabiłsįgo bídaagonołsį. ");
INSERT INTO apwNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Áídá’ nohwihíí nohwitahyú doo ágágot’ee da doleeł: áídá’ dahadíń nohwitahyú ízisgo ánsht’ee le’ nzįhíí, áń nohwá áił’įį le’; ");
INSERT INTO apwNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nohwitahyú dahadíń nant’án nshłįį le’ nzįhíí, áń nohwá na’iziid le’: ");
INSERT INTO apwNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Shíí, nṉee k’ehgo Niyááhíí nshłįį ndi, doo hadíń shich’oṉiihíí bighą niyáá da, áídá’ nṉee bich’oshṉiihíí bighą niyáá, shi’ihi’ṉa’íí nṉee łáni bá nahishṉiiłhíí bighą niyáá. ");
INSERT INTO apwNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jérikodí’ dahnanáskaigo, Jesus biké’ naadeząą. ");
INSERT INTO apwNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nt’éégo nṉee naki biṉáá ágodini intín bahyú sikee lę́k’e, áí Jesus higaałgo ya’ikodaanzįįgo nádaadidilghaazhgo, NohwiNant’a’, David biye’ ńlíni, nohwaa ch’onbáah, daaṉiigo nádaabokąąh. ");
INSERT INTO apwNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nṉee Jesus biké’ náłseełíí, Godnch’áad, daabiłnṉiid: áídá’ da’tiségo nanádaadidilghaazhgo, NohwiNant’a’, David biye’ ńlíni, nohwaa ch’onbáah, daaṉiigo nanádaabokąąh. ");
INSERT INTO apwNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus ninyáágo bich’į’ ánṉiidgo, Nt’é nohwá áshłe’go ádohṉii? biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","NohwiNant’a’, gohiit’įįgo ánánohwidle’, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus baa daach’osbaadgo biṉáá yedaadolṉiihgo dagoshch’į’ daago’įį nádaasdlįįgo biké’ dahish’aazh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Áídí’ Jerúsalem k’ad yaa hikáh, Béthphage golzeezhį’, áí dził Olives holzéhi si’ąągee, áídí’ Jesus bitsiłke’yu naki oyił’a’, ");
INSERT INTO apwNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Gáyiłṉiigo, Ti’i, nohwádįhyú gotahyú doh’aash, áígee dagoshch’į’ túlgayé bizhaazhé biłgo dahstł’ǫǫgo baa noh’aash: áí k’e’oh’adgo shaa nánohłǫǫs. ");
INSERT INTO apwNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nṉee ła’ nt’éhéta nohwiłṉiiyúgo, NohwiNant’a’ hát’į́į́go áhiit’įį, biłdohṉiih; áík’ehgo dagoshch’į’ nohwaa gode’aahgo nádohłǫǫs. ");
INSERT INTO apwNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Díí ánágot’įįłíí Bik’ehgo’ihi’ṉań binkááyú na’iziidi gáṉíí n’íí begolṉéhgo ánágot’įįł, ");
INSERT INTO apwNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sion bizhaazhé bił nadaagołṉi’, Díń’įį, ízisgo niNant’a’ ídaagoch’iyolba’go túlgayé, áí túlgayé bizhaazhéhi, yiká’ dahsdaago nich’į’ boghééł. ");
INSERT INTO apwNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Áík’ehgo Jesus da’áṉííyú bitsiłke’yu ádaadzaa, ");
INSERT INTO apwNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Túlgayé, bizhaazhé biłgo, baa daizlǫǫzgo bidiyágéhíí yiká’ dahdaihezṉildá’ Jesus yiká’ dainesdaa. ");
INSERT INTO apwNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nṉee łą́ą́go bidiyágé intínyú yídaagosteel lę́k’e; ła’ihíí ch’il palm bits’ádaaz’aahíí nadaayihiłgeeshgo intínyú yídaagosteel. ");
INSERT INTO apwNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nṉee bádįh náłseełíí, ła’íí biké’dí’ náłseełíí daadilwoshgo gádaaṉii, Hosánna, David biYe’ nlíni: NohweBik’ehń bizhi’ yee higaałíí ba’ihégosini at’éé; da’itisé goz’ąądí’ Hosánna. ");
INSERT INTO apwNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Áídí’ Jerúsalemyú ńyáágo áígee daagolííníí dawa, hago ląą ágodzaa daanzįgo, Díí hadíń át’į́į́? daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nṉee biké’ náłseełíí gádaaṉii, Díí Jesus, Bik’ehgo’ihi’ṉań binkááyú na’iziidi at’į́į́, Názarethdí’ nagháhi, áí Gálilee bigodesdzogíí biyi’dí’. ");
INSERT INTO apwNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Áídí’ Bik’ehgo’ihi’ṉań daach’okąąh goz’ąą yuṉe’ Jesus ha’ayáágo, baa nada’iṉiihi ła’íí nada’iłṉiihi ch’íinihiyood, ła’íí zhaali yiká’ iłkáh ch’ínádaiṉiiłíí naz’aaníí nanyihesgo’, hawúcho baa nadaahiṉiihíí biká’dah’sdáhá ałdó’ nanyihesgo’, ");
INSERT INTO apwNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Gáyiłṉiigo, Ágáṉíígo bek’e’eshchįį, Shikįhíí kįh biyi’ da’ch’okąąhíí holzeego hojíí doleeł; áídá’ nohwihíí daan’įįhíí bigową ádaagosolaa ląą. ");
INSERT INTO apwNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Biṉáá ádaagodiníí ła’íí doo nadaakai dahíí da’ch’okąąh goz’ąągee baa hikai; áígee nádaabiłziih lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Okąąh yebik’ehi itisyú nadaandeehíí hik’e begoz’aaníí ye’ik’eda’iłchíhi Jesus ízisgo áná’ol’įįłíí daayiłtsąągo, ła’íí da’ch’okąąh goz’ąągee chągháshé daadilwoshgo, Hosánna, David biYe’ nlíni, daaṉiigo daayiłtsąągo, dázhǫ́ doo bił daagozhǫ́ǫ́ da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Áík’ehgo gádaabiłṉii, Ya’ díí ádaaṉiihíí dints’ag née? Jesus gábiłṉii, Ha’oh; ya’ díí doo hwahá daahohshiih da née, Chągháshé ałts’ísę́hi ła’íí mé’ t’ah da’iłbe’i dázhǫ́ nłt’éégo ihédaanzįgo ádaasíńlaa? ");
INSERT INTO apwNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Áídí’ bits’ą́’ dahiyaago kįh gozṉildí’ Béthany golzeezhį’ nyáá; áígee sidaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","T’ahbįyú kįh gozṉilyú nádesdzaago, shiṉá’ silįį. ");
INSERT INTO apwNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ch’il fig intín bahyú o’áágo yiłtsąągo yaa nyáá, binest’ą’ da’ádįhdá’ bit’ąą zhą́ gólį́į́go yígołsįįdgo gáyiłṉii, Kodí’ godezt’i’go dahazhį’ ninest’ą’ da’ádįh doleeł. Áík’ehgo dagoshch’į’ ch’il fig náhesgą. ");
INSERT INTO apwNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bitsiłke’yu díí daayiłtsąągo bił díyadaagot’eego gádaaṉii, Hagot’éégo ch’il fig dagoshch’į’ náhesgą ląą! ");
INSERT INTO apwNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus gádaabiłṉii, Da’aṉii gánohwiłdishṉii, Nohwi’odlą’ golį́į́yúgo, doo nohwił nadaagoki dayúgo, doo díí ch’il fig ádzaahíí k’ehgo zhą́ ádaahṉe’ da, áídá’ díí dziłíí bich’į’ hahdziigo, Yúwehégo dihi’ṉáhgo túnteel biyi’ onidolṉé’, daadohṉiiyúgo, nohwá ágáṉe’. ");
INSERT INTO apwNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Da’ohkąąhgo dant’éhéta daahohkeedíí, da’ohdląągo ádaadohṉiiyúgo, dawa nohwaa hi’né’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus da’ch’okąąh goz’ąą yuṉe’ i’ayáágo, áígee nṉee yił ch’ígó’aahgo, okąąh yebik’ehi itisyú nadaandeehi, nṉee yánazíni biłgo baa hikaigo gádaabiłṉii, Hadíń bik’ehgo ánánt’įįł? Hadíń naa godin’ą́ą́go ánt’įįh? ");
INSERT INTO apwNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus gádaabiłṉii, Shíí ałdó’ dała’ándi nanohwídishkid, shił nadaagołṉi’yúgo, shíí ałdó’ hadíń bik’ehgo ánásht’įįłíí nohwił nagoshṉi’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","John baptize ádaagole’íí hadí’ begoz’áni? Yaaká’dí’go née, dagohíí nṉee bits’ą́’dí’go née? Łił yádaałti’go gádaałiłdi’ṉii, Yaaká’dí’go daan’ṉiihyúgo, gánohwiłṉiih, Áídá’ nt’é bighą doo daahohdląą da láń? ");
INSERT INTO apwNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Áídá’, Nṉee bits’ą́’dí’go, daan’ṉiihyúgo, nṉee bédaahildzid; nṉee dawa John Bik’ehgo’ihi’ṉań binkááyú na’iziidi nlįį daanzįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Áík’ehgo Jesus gádaayiłṉii, Néé doo bídaagonlzį da. Jesus gánábiłdo’ṉiid, Shíí ałdó’ hadíń bik’ehgo ánásht’įįłíí doo nohwił nagoshṉi’ da. ");
INSERT INTO apwNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Díí hagot’éégo baa natsídaahkees? Ła’ nṉee biye’ke naki; dała’á yaa nyáágo, Shiye’, díí jįį shidahts’aa hentį́į́yú na’iziidyú ńṉáh, yiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Áń bich’į’ hadziigo, Dah, doo akú disháh da, biłṉii; áídá’ bikédí’go biini’ łahgo ánáyiidlaago akú óyáá lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Biye’ ła’ihíí yaa nanádzaago da’ágánáyiłdo’ṉiid. Áík’ehgo, Akú disháh, nṉiid; áídá’ doo akú óyáá da. ");
INSERT INTO apwNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Díí nakihíí hadíí bitaa áṉííyú ádzaa? Dantséhi, daaṉii. Jesus gádaabiłṉii, Da’aṉii gánohwiłdishṉii, Tax bich’į’ nadaahi’ṉiiłíí ła’íí nant’į’ nakaihi danohwintsé Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah daaleeh. ");
INSERT INTO apwNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","John nłt’éégo ágot’eehíí yaa yałti’go nohwitahyú ńyáá, ndi doo daahohdląą da; tax bich’į’ nadaahi’ṉiiłíí ła’íí nant’į’ nakaihíí zhą́ daabodląą: nohwíí bídaagonołsį ndi bikédí’go nohwiini’ doo łahgo ánádaasohdląągo daahohdląą da. ");
INSERT INTO apwNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iłch’ígót’aahgo naná’goṉihíí ła’ ódaayełts’ą́ą́: ła’ nṉee bidák’eh golííníí dahts’aa k’eidnláágo yiṉaayú na’nezṉil, dahts’aa hahigęęs doleełgee yá ogogéed, biká’dí’ ídést’iiníí ágólaa, ła’íí bá yiṉádaadéz’íni yá ch’ígohet’ąądá’ ńzaadyú ni’ goz’ąąyú óyáá: ");
INSERT INTO apwNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Da’nest’ąągee ngonyáágo bánada’iziidi bidahts’aa bá yiṉádaadéz’íni yich’į’ oyił’a’, binest’ą’ ła’ bá náyíné’go. ");
INSERT INTO apwNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Áídá’ bá iṉádaadéz’íni nada’iziidíí yił ndaazdeelgo dała’á nyída’eshtłizh, ła’ihíí daizes‐hį́į́, ła’ihíí tséé bee daayitséed. ");
INSERT INTO apwNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Bánada’iziidíí ntsédá’ oyił’a’ n’íí bitisgo onayíł’a’: áí ágánádaayiidlaa. ");
INSERT INTO apwNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Da’iké’yú biye’ oyił’a’, Shiye’ daidnłsį doleeł, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Áídá’ biye’ daayiłtsąądá’, dahts’aa yiṉádaadéz’íni gádaałiłdi’ṉii, Díí dahts’aa hentííníí bíyéé doleełíí át’éé; yushdé’, daazołdee, áík’ehgo bíyéé doleeł n’íí daanohwíyéé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Áík’ehgo yił ndaazdeelgo dahts’aa hentį́į́dí’ ch’ídaist’e’go daizes‐hį́į́. ");
INSERT INTO apwNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Áík’ehgo dahts’aa hentííníí bíyééhíí nádzáágo bidahts’aa bá yiṉádaadéz’ínihíí hagoshą’ ádaile’? ");
INSERT INTO apwNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jesus gádaayiłṉii, Bidahts’aa golííníí nṉee doo bik’ehyú ádaat’įį dahíí naiłtseedá’, bidahts’aa hentííníí bá yiṉádaadéz’íni ła’ihíí yá ch’ínágohet’aah, áí inest’ąągo nest’ánhíí baa daach’ihiṉiił doo. ");
INSERT INTO apwNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus gádaabiłṉii, Díínko Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí doo hwahá daahohshiih da née? Tséé kįh ádaagole’íí yó’odaisṉe’i n’íí, hagon’áágee dantsé si’aaníí silįį: díí nohweBik’ehń bik’ehgo ánágot’įįł, áí daanéel’įįgo nohwił díyadaagot’ee. ");
INSERT INTO apwNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Áí bighą gádaanohwiłdishṉii, Yaaká’yú dahsdaahń bilałtł’áhgee daanohłįįgo nohwaa ch’ígót’i’ n’íí nohwaa nágodit’aahgo łahgo hat’i’íí, Bik’ehgo’ihi’ṉań yikísk’eh hikaahíí, baa godidot’aał, nohwits’ą́’. ");
INSERT INTO apwNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Dahadíń áí tséé yiká’ nágo’yúgo, ałts’ísę́go nihiltǫǫd: áídá’ dahadíń áí tséé biká’ naltǫ’yúgo, di’ílégo bik’aa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Okąąh ye bik’ehi itisyú nadaandeehíí hik’e Phárisees daanlíni iłch’ígót’aahgo na’goṉi’i Jesus yee hadzii n’íí daidezts’ąądá’, bíí ádaabiłṉiigo yídaagołsįįd. ");
INSERT INTO apwNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ha’ádaiłt’e’ hádaat’įį ndi nṉee łáni yédaaldzid, Bik’ehgo’ihi’ṉań binkááyú na’iziidi nlįį daanzįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus iłch’ígót’aahgo na’goṉi’íí yee yił nanágolṉi’go gáṉíí, ");
INSERT INTO apwNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí díí k’ehgo at’éé: ízisgo nant’án biye’ niiṉéhi bá da’idąągo ngon’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Áík’ehgo binadaal’a’á ni’i’ṉéhyú nohohkáh daayiłnṉiid n’íí, yushdé’ biłṉiigo yił’aa: ndi doo ákú híkáh da. ");
INSERT INTO apwNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nadaal’a’á ła’i onáyíł’a’ gáṉíígo, Daabi’dokeedíí gábiłdohṉii, Hidáń dawa łalzaa: shimagashi hik’e bizhaazhé łik’ahíí nasiłtseed, dawa ąął nłt’éégo alzaa: yushdé’ ni’i’ṉéhyú nohkáh. ");
INSERT INTO apwNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Áídá’ áí doo akú ádaat’ee da, dabíí hádaat’įįyú oheskai, ła’ bidák’ehyú óyáá, ła’ihíí baa na’hiṉiihyú óyáá: ");
INSERT INTO apwNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ła’ihíí nant’án binadaal’a’á yił ndaazdeelgo yiniidaagodezlaadí’ nadaistseed. ");
INSERT INTO apwNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nant’ánhíí díí ya’ikonzįįdá’ hashkee: áík’ehgo bisiláádahíí daił’aago nṉee ádáát’įįd n’íí nadaistseed, ła’íí bikįh nagozṉilíí daidnłid. ");
INSERT INTO apwNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Áídá’ nant’án binadaal’a’á gáyiłṉii, Ni’i’ṉéhgo da’idąąhíí łalzaa ndi daabi’dokeedíí doo yik’e shijeed da. ");
INSERT INTO apwNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Áí bighą da’ditinyú dohkáh, áígee hadíń daah’iiníí dawa ni’i’ṉéhyú nohohkáh, daabiłdohṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Áík’ehgo nadaal’a’á intínk’ehyú okai, hadíí daayiłtsąąhíí dawa, doo bik’ehyú ádaat’ee dahíí ła’íí nłt’éégo ádaat’eehíí íła’ádaizlaa: áík’ehgo nṉee łáni ni’i’ṉéhyú hikai. ");
INSERT INTO apwNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Áígee nant’án ha’ayáádá’ nṉee niheskaihíí yineł’į́į́go, nṉee ła’ ni’i’ṉéhgo ííhíí doo golį́į́ dago yiłtsąą: ");
INSERT INTO apwNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Áík’ehgo gáyiłṉii, Shit’ekéhé, hagot’éégo kóṉe’ ha’ányaa, ni’i’ṉéhgo ííhíí doo ágóndlaa dago? Áídá’ nṉeehíí doo nt’é ṉii da. ");
INSERT INTO apwNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nant’ánhíí binadaal’a’á gádaayiłṉii, Bigan hik’e bikee łídaałtł’oogo godiłhiłyú ch’ídaanołt’e’; akú daach’ichag ła’íí kowoo łídaach’idiłk’ash doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Łą́ą́go yiká ádaanṉiid ndi da’akwíyé habi’do’ṉil. ");
INSERT INTO apwNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Phárisees daanlíni hagot’éégo Jesus yałti’gee daabihiljizh doleełgo ndaagoshchįį. ");
INSERT INTO apwNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Phárisees biké’ anákahíí hik’e Hérod yił daagot’íni Jesus yich’į’ odais’a’, gádaabiłṉiigo, Iłch’ígó’aahíí, da’aṉiigo ánṉiigo, ła’íí Bik’ehgo’ihi’ṉań bich’į’zhiṉéégo goz’aaníí da’aṉiigo baa iłch’ígon’áahgo bídaagonlzį, nṉee doo béníldzid dago yáńłti’: nṉee doo ła’ itisgo síńłtįį da. ");
INSERT INTO apwNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Áí bighą nohwił nagolṉí’, Díí hagot’éégo baa natsíńkees? Ya’ Caesar bich’į’ tax nadaach’iṉiiłgo begoz’ąą née? Née dah née? ");
INSERT INTO apwNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Áí nṉeehíí doo bik’ehyú ádaat’ee dago Jesus yígółsįgo gádaayiłṉii, Nt’é bighą yashti’íí bee daashołjizhgo ádaashiłdohṉii, nohwíí daanohshǫǫ ádaadoł’íni? ");
INSERT INTO apwNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Zhaali tax bideṉá nahi’ṉiiłíí shaa noh’aahgo nesh’į́į́. Áík’ehgo zhaali ła’, penny holzéhi, baa daiz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Hadíń be’ilzaa, hadíń bizhi’ biká’ dahgoz’ąą? daayiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Caesar bíyéhi ląą, daaṉii. Jesus gádaabiłṉii, Caesar bíyééhíí Caesar baa daanohṉiił, áídá’ Bik’ehgo’ihi’ṉań bíyééhíí Bik’ehgo’ihi’ṉań baa daanohṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Díí daidezts’ąądá’ bił díyadaagot’eego bits’ą́’yú dah hiskai. ");
INSERT INTO apwNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Da’áí bijįį Sádducees daanlíni, nanezna’ n’íí doo naadikáh da daaníhi, Jesus yaa hikaigo nayídaadiłkid, ");
INSERT INTO apwNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Gádaayiłṉiigo, Iłch’ígó’aahíí, Moses gáṉíí ni’, Ła’ nṉee bichągháshé doo ła’ dago daztsąąyúgo, bik’isnhíí bi’aa n’íí yił nnádo’ṉeełgo, bik’isn n’íí chągháshé bá ágodolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Iłk’isyú gosts’idi nohwitahyú daagolį́į́ ni’: dantsé nṉááhíí daztsąą, bichągháshé doo ła’ da, áík’ehgo bi’aa n’íí bik’isn yił naná’ṉáá: ");
INSERT INTO apwNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nakigeehíí ágánánádzaa, taagigeehíí ałdó’, da’áík’ehgo gosts’idzhį’ dawa nanezna’. ");
INSERT INTO apwNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Da’iké’yú isdzánhíí ałdó’ daztsąą. ");
INSERT INTO apwNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Áík’ehgo nanezna’dí’ naach’idikáhgee díí gosts’idihíí shą’ hadíí bi’aa doleeł, dawa yił nadaazṉaadá’? ");
INSERT INTO apwNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus gádaabiłṉii, Da’ołsiih, Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí ła’íí Bik’ehgo’ihi’ṉań binawodíí doo bídaagonołsį dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Naach’idikáhgee doo nnádaach’iłse’ da, doo ndaagoch’ihiṉiiłgo nnádaach’iłse’ da, áídá’ Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolį́į́híí k’ehgo daagoch’ilį́į́. ");
INSERT INTO apwNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Áídá’ nanezna’íí naadiikáhíí, Bik’ehgo’ihi’ṉań baa nohwich’į’ yałti’íí, ya’ doo hwahá baa daahohshiih da née, gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Shíí Abraham Bik’ehgo’ihi’ṉań yokąąhíí nshłįį, Isaac, Jacob ałdó’ Bik’ehgo’ihi’ṉań yokąąhíí nshłįį. Bik’ehgo’ihi’ṉań doo nanezna’íí yokąąhíí nlįį da, daahiṉaahíí zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nṉee íła’at’ééhíí díí daidezts’ąągo, iłch’ígó’aahííbighą bił díyadaagot’ee. ");
INSERT INTO apwNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesus Sádducees daanlíni doo nt’é ńdaado’ṉii dago áyíílaago Phárisees ya’ikodaanzįįgo, íła’adzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Áí ła’ begoz’aaníí nłt’éégo yígółsini Jesus yich’į’ hadziigo nabíntaahgo nabídiłkid, ");
INSERT INTO apwNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Iłch’ígó’aahíí, Bik’ehgo’ihi’ṉań yegos’aaníí hadíí itisgo at’éé? ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus gábiłṉii, Bik’ehgo’ihi’ṉań neBik’ehń nijíí dawa bee nił nzhǫǫ le’. niyi’siziiníí dawa bee, ła’íí ninatsekeesíí dawa bee nił nzhǫǫ le’. ");
INSERT INTO apwNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Áí Bik’ehgo’ihi’ṉań yegos’aaníí dantséhi ła’íí itisgohi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nakigeehíí ałdó’ ágánánát’éé, Nit’ahdí’ gólííníí nił nzhǫǫ le’, dáni ídił njǫ́ǫ́híí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bik’ehgo’ihi’ṉań yegos’aaníí ła’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí k’eda’ eshchiiníí dawa díí nakihíí bits’ą́’dí’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Phárisees daanlíni t’ah íła’at’éégee, Jesus nabídaadiłkid, ");
INSERT INTO apwNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Gáṉíígo, Christ‐híí hagot’éégo baa natsídaahkees? Hadíń biye’ nlįį? David biye’ nlįį, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesus gánádi’ṉii, Hagot’éégoshą’ David Holy Spirit yábiyiłti’go, SheBik’ehń, biłṉii, gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Bik’ehgo’ihi’ṉań sheBik’ehń gáyiłnṉiid, Shigan dihe’nazhiṉéégo síńdaa, ni’ina’ benik’eh silįįgo nikełtł’ááhyú niníṉilzhį’. ");
INSERT INTO apwNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David, SheBik’ehń, biłṉiigo bozhííyúgo, hagot’éégoshą’ biye’ nlįį áídá’? ");
INSERT INTO apwNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jesus nṉee doo ła’ bich’į’ hanadzíih da lę́k’e, áí bijįįdí’ godezt’i’go nṉee daaste’go, doo hadíń nabínánłkid da. ");
INSERT INTO apwNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesus nṉee íła’at’ééhíí hik’e bitsiłke’yu yich’į’ hadzii, ");
INSERT INTO apwNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Gáṉíígo, Begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanlíni Moses nṉee yá sizįį n’íí k’ehgo nṉee yá nazįį: ");
INSERT INTO apwNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Áí bighą da’ádaanohwiłṉiiyú ádaanoht’eego ádaaht’įį; ndi doo ádaat’įįhíí k’ehgo ádaaht’įį da: áí ádaaṉiiyú doo ádaat’įį da ndi ádaaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Áí nṉeehíí nṉee biwosyú ndaazgo dázhǫ́ nyeego dahda’ogheełgo ádaayiłsį; áídá’ da’ayą́há ndi doo ich’odaaṉii da. ");
INSERT INTO apwNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nłt’éégo ánádaat’įįłíí dawa nṉee dá bo’įį hádaat’įįhíí bighą ánádaat’įįł: Bik’ehgo’ihi’ṉań biyati’ ła’ bídaadestł’ǫǫhíí nteelgo ádaile’, bi’íí bidá’yú ałdó’ nteelgo na’izlaago ádaayiłsį. ");
INSERT INTO apwNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Da’idąągee nṉee ízisgo ádaat’eehíí dahnádinbįhyú itah dahnaháztąągo zhą́ bił daanzhǫǫ, ła’íí Jews ha’ánáłséh nagozṉil yuṉe’ nṉee yánazíni dahnádinbįhyú itah dahnaháztąągo ałdó’ bił daanzhǫǫ, ");
INSERT INTO apwNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Na’hiṉiih nadaagoz’ąąyú bich’į’ ádaach’iṉiigo, ła’íí, Iłch’ígó’aahíí, Iłch’ígó’aahíí, daabiłṉiigo zhą́ bił daanzhǫǫ, ");
INSERT INTO apwNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Áídá’ nohwihíí doo hadíń, Iłch’ígó’aahíí, nohwiłṉii da le’: dała’á nohwił ch’ígó’aahíí nlįį, Christ zhą́; ła’íí nohwihíí daanohwigha iłk’isyú daanohłįį. ");
INSERT INTO apwNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ni’gosdzáń biká’ nṉee doo ła’, ShiTaa, biłdohṉii da le’: dała’á, yaaká’yú dahsdaahń zhą́, nohwiTaa at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Doo hadíń, ShiNant’a’, nohwiłṉii da le’: dała’á nohwiNant’a’ nlįį, Christ zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hadíń nohwitahyú ízisgo at’ééhíí, nohwá na’iziid le’. ");
INSERT INTO apwNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hadíń itisgo ídéstiiníí ídaagoch’olba’go ádolṉiił; áídá’ hadíń ídaagoch’olba’íí itisgo at’éégo ádolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanohłíni, daanohshǫǫ ádaadoł’íni, nohwá góyéé doleeł! Yaaká’yú dahsdaahń bilałtł’áhgee goz’áni nṉee bits’ą́’ daanáda’dohtį́: nohwíí doo itah daahłeeh dadá’, nṉee itah daaleeh doleeł n’íí t’ąązhį’ ádaanołsį. ");
INSERT INTO apwNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanohłíni, daanohshǫǫ ádaadoł’íni, nohwá góyéé doleeł! Isdzáné itsaa daanlíni bigową bits’ą́’ nádaahohṉiił, ła’íí daazhógo ádaadohṉiigo nzaad gont’i’go da’ohkąąh: áí bighą nohwíí itisgo nohwiniigonłt’éégo nohwá ndaagodot’aał. ");
INSERT INTO apwNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanohłíni, daanohshǫǫ ádaadoł’íni, nohwá góyéé doleeł! Tú biká’ ła’íí ni’ biká’ dahot’éhé nadaanohtaah, dała’á ndi nohwíhiigháhíí bighą; nohwíhiyaayúgo nakidn nohwitisyú łenágołchǫǫdgo ch’iidn bikǫ’ diltłi’ yuyaa bágoz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nohwiṉáá ádaagodįh ndi ła’ bádįh nadaahkaihíí, nohwá góyéé doleeł! Dahadíń da’ch’okąąh goz’aaníí biláhyú bitł’a dahnádidilṉiihdá’, áí doo nt’é da, daadohṉii: ndi hadíń óodo da’ch’okąąh goz’ąą yuṉe’hi biláhyú bitł’a dahnádidilṉiihíí, áń zhą́ da’áṉííyú át’éé le’, daadohṉii! ");
INSERT INTO apwNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nohwíí doo daagonohsąą da, nohwiṉáá ádaagodini: hadíí itisgo at’éé, óodohíí née, née da’ch’okąąh goz’aaníí bits’ą́’dí’ óodo dilzįhgo alzaahíí née? ");
INSERT INTO apwNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ła’íí, Dahadíń be’okąąhíí biká’ dahnási’ṉiłi goz’aaníí biláhyú bitł’a dahnádidilṉiihdá’, áí doo nt’é da, daadohṉii; ndi hadíń Bik’ehgo’ihi’ṉań baa hi’ṉiiłíí áí yiká’ dahsiné’íí biláhyú bitł’a dahnádidilṉiihíí, áń zhą́ da’áṉííyú át’éé le’, daadohṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nohwíí doo daagonohsąą da, nohwiṉáá ádaagodini: hadíí itisgo at’éé, Bik’ehgo’ihi’ṉań baa hi’né’ihíí née, née yiká’ dahsiné’íí Bik’ehgo’ihi’ṉań baa hi’né’ihíí dilzįhgo áile’ihíí née? ");
INSERT INTO apwNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Áík’ehgo dahadíń Bik’ehgo’ihi’ṉań baa hi’né’i yiká’ dahsiné’i biláhyú bitł’a dahnádidilṉiihíí, áí hik’e biká’ dah sihi’ṉiiłíí dawa ałdó’ biláhyú bitł’a dahnádidilṉiih. ");
INSERT INTO apwNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ła’íí dahadíń da’ch’okąąh goz’aaníí biláhyú bitł’a dahnádidilṉiihíí, áí hik’e ákóṉe’ golííníí ałdó’ biláhyú bitł’a dahnádidilṉiih. ");
INSERT INTO apwNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ła’íí dahadíń yaaká’yú biláhyú bitł’a dahnádidilṉiihíí, Bik’ehgo’ihi’ṉań dahsdaagee goz’aaníí hik’e áígee dah sdaahíí ałdó’ biláhyú bitł’a dahnádidilṉiih. ");
INSERT INTO apwNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanohłíni, daanohshǫǫ ádaadoł’íni, nohwá góyéé doleeł! Tł’oh mint, ánise, hik’e cúmmin daaholzéhi dá goneznanyú iłk’é’ṉilgo, dała’á Bik’ehgo’ihi’ṉań baa nádaahné’, áídá’ Bik’ehgo’ihi’ṉań yegos’aaníí itisgo at’ééhíí doo bee ádaanoht’ee da, dábik’ehyú ánách’ot’įįłíí, koł goch’oba’íí, ła’íí ko’odlą’ golííníí: díí bee ádaanoht’ee le’at’éhi, ła’ihíí doo baa daayołṉah dago. ");
INSERT INTO apwNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nohwiṉáá ádaagodįh ndi ła’ bádįh nadaahkaihíí, dǫ́’ áłts’ísę́hi bitádaadołkaałdá’ łį́į́ bigháń ha’i’áhi odaahołneeh. ");
INSERT INTO apwNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanohłíni, daanohshǫǫ ádaadoł’íni, nohwá góyéé doleeł! Idee hik’e its’aa biká’yú zhą́ tádaahgisdá’, aadaach’ihi’ṉiiłíí ła’íí doo ádaagoch’idzaa dahíí zhą́ biyi’ yuṉe’ begoz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Phárisee ńlíni, niṉáá ágodini, idee hik’e its’aahíí biyi’ yuṉe’ ntsé táńgis, áík’ehgo biká’dí’ ałdó’ nłt’éé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanohłíni, daanohshǫǫ ádaadoł’íni, nohwá góyéé doleeł! Nṉee łe’shijeedíí biká’gee alzaahíí łigaigo ánálzaahíí k’ehgo ádaanoht’ee, áídá’ áí biyi’ yuṉe’híí nṉee daztsáni bits’in zhą́ siṉil, nchǫ’íí zhą́ dawa begoz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nohwíí ałdó’ nohwiká’dí’go zhą́ nṉee biṉááł nłt’éégo ádaanoht’ee, áídá’ nohwiyi’ yuṉe’ nzhǫǫ ách’idil’iiníí hik’e nchǫ’híí bee hagolk’ił. ");
INSERT INTO apwNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanohłíni, daanohshǫǫ ádaadoł’íni, nohwá góyéé doleeł! Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí łe’shijéédíí biká’gee dant’éhéta bee bínádaach’ilṉiihíí ádaagohłe’, ła’íí nṉee dábik’ehyú ádaat’ee n’íí łe’shijeedíí biká’gee alzaahíí dénzhónégo ánádaahdle’híí bighą, ");
INSERT INTO apwNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Gádaadohṉiigo, Nohwitaa n’íí t’ah daahiṉaadá’ daagondlįįyúgo, Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí naatseedgee doo itah daandlįį da doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ádaadohṉiigo, Bik’ehgo’ihi’ṉań binkááyú nada’iziidi ndaistseed n’íí bichągháshé daanohłįįgo dánohwíí ádaa nadaagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nohwitaa n’íí nchǫ’go ádaat’įį n’íí ąąłzhį’ beda’ohłe’. ");
INSERT INTO apwNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tł’iish k’ehgo daanohłíni, ch’osh bik’asda’ golííníí k’ehgo hałinołt’įįłíí, ch’iidn bikǫ’ diltłi’ yuyaa nohwá goz’aaníí hagot’éégoshą’ bitis hahkáh? ");
INSERT INTO apwNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Áí bighą Bik’ehgo’ihi’ṉań binkááyú nada’iziidi, nṉee daagoyáni, hik’e begoz’aaníí ye’ik’eda’iłchíhi nohwich’į’ daadeł’a’: áí ła’ nadaałtseed doleeł, ła’íí tsį’iłna’áhi bídaahołkał doleeł; ła’ihíí íła’ánádaaht’įįgee habída’ołtsaas doleeł, ła’íí daabi’odlą’híí bighą yóíyahgo biṉí’da’dołṉíh doleeł, kįh gozṉildí’ łahyúgo kįh gozṉilzhį’: ");
INSERT INTO apwNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Áí bighą ni’gosdzáń biká’ nṉee dábik’ehyú ádaat’eehíí nadaaztseedíí dawa bidił nohwik’izhį’ didot’aał, dábik’ehyú át’éhi, Abel holzéhi, zesdįįdí’ Barakías biye’, Zakarías holzéhi, zesdįįzhį’, Zakaríasíí kįh biyi’ da’ch’okąąhíí hik’e be’okąąhíí biká’ dahnási’ṉiłíí goz’aaníí bigizhgee daazesołhįį n’íí. ");
INSERT INTO apwNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Da’aṉiigo gánohwiłdishṉii, Díí dawa díí daałinolt’įįłíí bik’izhį’ didot’aał. ");
INSERT INTO apwNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerúsalem, Jerúsalem ńlíni, Bik’ehgo’ihi’ṉań binkááyú nada’iziidi natsíńłtseedíí, ła’íí nich’į’ daahil’aadíí tséé bee nbida’tsíńłṉe’íí, tazhik’áné bi’aadíí bit’ats’in bitł’ááh yuṉe’ bizhaazhé onáyiṉiłíí k’ehgo nichągháshé doo ałch’ídn łináhishṉiił hasht’į́į́ ndi doo hádaaht’įį da ni’! ");
INSERT INTO apwNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nikįhíí yó’agodot’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gádaanohwiłdishṉii, Bik’ehgo’ihi’ṉań bizhi’ yee higaałíí ba’ihégosini at’éé, daadohṉiihíí bijįį zhą́ nadaashołtséh. ");
INSERT INTO apwNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus da’ch’okąąh goz’ąądí’ ch’ínyáádá’, bitsiłke’yu baa hikai, gádaabiłṉiigo, Díí da’ch’okąąh goz’ąągee kįh nagozṉilíí níńł’įį. ");
INSERT INTO apwNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesus gádaabiłṉii, Díí dawa daah’įį née? Da’aṉiigo gánohwiłdishṉii, díí tséé iłká’ dahnagozṉilíí doo ła’ iłká’ dahnast’ą́ą́ da doleeł, dawa nanehiłkaad doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Áídí’ Jesus dził Olives holzéhi biká’yú dahsdaago bitsiłke’yu dasahndiyú baa hikaigo gádaabiłṉii, Nohwił nagolṉí’ da’os’ah ágoṉéhi? Nádńdáhíí hik’e nnágodáhi biłgo hant’é bee bígózį doleeł? ");
INSERT INTO apwNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus gánádaabiłdi’ṉii, Ídaa daagonohdząą, nṉee ła’ ch’a’onohołt’e’ hela’. ");
INSERT INTO apwNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nṉee łą́ą́go shizhi’ yee daahikáh doleeł, Shíí Christ nshłįį, daaṉiigo; áí nṉee łą́ą́go ch’a’odaayiłkaad doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nagonłkaadíí ba’ikodaanohsį, ła’íí nagonłkaadíí baa ch’iṉii daadohts’ag doleeł: áídá’ doo nohwijíí natsídaahiltǫ’ da le’: díí dawa begolṉe’hi at’éé, ndihíí t’ah doo hwahá nnágodáh da. ");
INSERT INTO apwNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nṉee iłtah at’éégo hadaazt’i’íí iłch’į’ nanágonłkaad doleeł, ła’íí nṉee dała’á binant’a’ daagolínihíí ałdó’ iłch’į’ nanágonłkaad doleeł: da’adzaayú shiṉá’ góyééhíí benagowaa doo, nadaagontł’ogíí iłtah at’ééhíí benadaagowaa doleeł, ła’íí ni’ nagohi’naa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Áí koniidaagonłt’ééhíí begodigháh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Áígee nohwiṉí’daach’idiłṉi’go odaanohwiniyood doleeł ła’íí nadaanohwiłtseed doleeł: ła’íí shizhi’ daanohwich’ozhííhíí bighą nṉee iłtah at’éégo hadaazt’i’íí dawa bił daanohchǫ’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Áígee nṉee łą́ą́go t’ąązhį’ ánáda’ṉe’ doo, łaa nadaagolṉi’ doo, ła’íí iłk’edaadi’ṉiih doo. ");
INSERT INTO apwNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bik’ehgo’ihi’ṉań binkááyú nada’iziidi ádaadil’íni hahikáh doleeł, áík’ehgo nṉee łą́ą́go ch’a’odaayiłkaad doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Doo bik’ehyú ágot’ee dahíí dázhǫ́ łą́ą́go begoz’ąąhíí bighą nṉee łą́ą́go bił’ijóóníí édįįłgo nádaanihik’as doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Áídá’ dahadíń dángont’i’zhį’ dahildǫ́híí hasdábi’dolteeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí nłt’éégo baa na’goṉi’íí ni’ dágoz’ąą nt’éégo be’ánágoldoh doleeł, nṉee iłtah at’éégo hadaazt’i’íí dawa yidiits’į́h doleełhíí bighą; áí bikédí’go nnágodáh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Áík’ehgo gołchǫǫhgo o’ṉí’ihíí Bik’ehgo’ihi’ṉań binkááyú na’iziidi, Daniel holzéhi, yaa yałti’ n’íí, godiyįhgo goz’ąągee sizįįgo daah’įįdá’, (dahadíń áí yózhííhíí bił ígózį le’,) ");
INSERT INTO apwNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Hadíí Judéa golzeeyú daagolííníí, dził naz’aaníí yich’į’ okeeh doo: ");
INSERT INTO apwNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Dahadíń kįh biká’yú dahsdaahíí nt’éhéta náidiiné’go gódah ch’ínádáh hela’: ");
INSERT INTO apwNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ła’íí dahadíń k’edolzaahíí yiyi’ na’iziidíí t’ąązhį’ bidyágé yaa nánódáh hela’. ");
INSERT INTO apwNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Áígee goldohíí daaltsaaníí ła’íí isdzáné mé’ daabiłbe’íí bá góyéé doleeł! ");
INSERT INTO apwNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Haihíí biyi’ ła’íí godilziníí bijįį ágóṉéh hela’, daadohṉiigo da’ohkąąh. ");
INSERT INTO apwNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Áígee dantsé godeyaadí’ godezt’i’go díí jįįzhį’ goyéégo nagowaahíí áí ga’at’éhi doo hwahá be’ágoṉe’ da, áí doo be’ágánágo’ṉéh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Áígee goldohíí doo dé’igodégo ánálzaa dayúgo, nṉee doo ła’ hasdáwáh át’éé da: áídá’ nṉee bitahasdlaahíí bighą áígee goldohíí dé’igodégo ánádolṉííł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Áígee nṉee ła’, Daadeh’į́į́, Christ kú naghaa, dagohíí, nlahyú naghaa, nohwiłṉiiyúgo, doo daahohdląą da. ");
INSERT INTO apwNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Christ ádaadil’iiníí, ła’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi ádaadil’iiníí hahikáh doleeł, áí godiyįhgo be’ígóziníí ch’í’ṉah ádaile’ ła’íí ízisgo áńda’ol’įįh doleeł; yídaanel’ąąyúgo áí bee nṉee bitahasdlaahíí ndi ch’a’odaiłkaad doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ídaayesółts’ąą, iłk’idá’ dabíntsé baa nohwił nagosisṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Christ da’igolį́į́yú naghaa, daanohwiłch’iṉiiyúgo; ákú dohkáh hela’: nagont’į’ goz’ąą yuṉe’ sidaa, daanohwiłch’iṉiiyúgo; áí doo daahohdląą da. ");
INSERT INTO apwNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ya’áí hanadáhdí’ ya’áí onadáhzhį’ hada’didla’íí k’ehgo shíí, nṉee k’ehgo Niyááhíí, nádishdaał. ");
INSERT INTO apwNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Dahayú its’í siné’yú ch’ishoogi íła’at’éé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Goyéégo nagoyaahíí bikédí’go ya’áí diłhił doleeł, tł’égona’áíhíí doo bee got’įį da doleeł, ts’iłsǫǫsé yáádí’ nanihidéh doleeł, ła’íí yáázhį’go inawodíí nagohi’naa doo: ");
INSERT INTO apwNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Áígee shíí, nṉee k’ehgo Niyááhíí, yaaká’yú beshígóziníí ch’í’ṉah hileeh; áík’ehgo ni’gosdzáń biká’ nṉee iłtah at’éégo hadaazt’i’íí doo bił daagozhǫ́ǫ́ dago daachag doleeł, shíí, nṉee k’ehgo Niyááhíí, yaak’os biyi’dí’ shinawodíí bee ła’íí dázhǫ́ shits’ą́’idindláádgo náshdaałgo daashidołtseeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Áídí’ shinadaal’a’á yaaká’dí’ ohish’aa doleeł, bésh dilwoshé ádaaṉiigo bitahelááhíí dį́į́dí’, ni’gosdzáń nel’ąądí’ yáá nel’ąązhį’ íła’ádaile’. ");
INSERT INTO apwNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ch’il fig holzéhi bits’ą́’dí’ nohwił ch’ígót’aah; bits’ádaaz’aahíí dit’ódé daaleehdí’ bit’ąą daagoleehyúgo, k’ad shį́į́ nágodleehgo bídaagonołsį. ");
INSERT INTO apwNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Da’áík’ehgo áí be’ádaagoṉe’íí goldohgo daah’įįdá’, k’ad náshdaałzhį’ ałhánégo godziihgo bídaagonołsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Da’aṉiigo gádaanohwiłdishṉii, Díí daałinolt’įįłíí doo nohwee ch’ígoṉáh da, díí ádaanohwiłdéṉiidíí dawa begolzaago zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yáá hik’e ni’gosdzáń biłgo bech’ígoṉáh doleeł, áídá’ shiyati’íí doo bech’ígowáh da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Hadíí bijįį shįhíí, dagohíí da’kwíí bik’ehenkéézgo shįhíí ágoṉe’íí nṉee doo ła’ yígółsį da, Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí ndi doo yídaagołsį da, shiTaa zhą́ yígółsį. ");
INSERT INTO apwNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noe t’ah golį́į́dá’ ágot’ee n’íí k’ehgo shíí, nṉee k’ehgo Niyááhíí, nánshdáhíí bijįį ałdó’ ágágot’ee doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tú’idezjoolíí dabíntségo ágot’ee lę́k’ehíí k’ehgo ágot’ee doleeł, da’ch’iyąą ni’, da’ch’idląą ni’, nnádaach’iłse’ ni’, ła’íí łaa daagoch’ihiṉiiłgo nnádaaze’ ni’, Noe tsina’eełíí yiyi’ oyaahíí bijįįzhį’, ");
INSERT INTO apwNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tú’idezjoolíí doo yídaagołsį’égo tú idezjoolgo dawa bił ogo’éél; shíí, nṉee k’ehgo Niyááhíí, nánshdáhgo ałdó’ ágágot’ee doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Áí bijįį nṉee naki k’edolzaayú na’aashyúgo, dała’á nádilteehdá’ ła’íí da’akú sizįį doo. ");
INSERT INTO apwNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Isdzáné naki da’ik’aayúgo, dała’á nádilteehdá’ ła’íí da’akú sidaa doo. ");
INSERT INTO apwNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Áí bighą biká nádaadeht’į́įh; da’kwíí bik’ehenkéézgo shíí, nohweBik’ehńhíí, nánshdáhíí doo bídaagonołsį da. ");
INSERT INTO apwNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Díí bídaagonołsį, nṉee bigową golííníí da’os’ah in’įįhíí hígháhgo yígółsįyúgo, yiká déz’įį doleeł ni’, áík’ehgo bigową doo ch’ínódzį́į́s át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nohwíí ałdó’ dahkodá’ iłch’į’daanoht’ee: shíí, nṉee k’ehgo Niyááhíí, dahagee nánshdáh, doo ndaashołíí dagee. ");
INSERT INTO apwNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Áídá’ hadíń na’iziidi begondlįįhíí góyáni, binant’a’ bigowąhíí yebik’ehgo nbiłtį́į́ n’íí, dahagee idáń nana’ṉííhgee idáń nayiṉiih. ");
INSERT INTO apwNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Na’iziidíí binant’a’ ábiłṉiiyú át’į́į́go, binant’a’ nadzááyúgo, áń biyaa gozhǫ́ǫ́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Da’aṉiigo gádaanohwiłdishṉii, Nant’án nt’é bíyééhíí dawa yebik’ehgo na’iziidíí nbiłtéeh doo. ");
INSERT INTO apwNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Áídá’ áí na’iziidi nchǫ’ihíí, Shinant’a’ doo hwah nadáh da, ídiłdi’ṉiiyúgo; ");
INSERT INTO apwNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Isdzáné hik’e nṉee ła’ nada’iziidíí nadainłkaad nkegonyaago bił nágodizyisíí biłgo da’iyąą hik’e da’idląąyúgo; ");
INSERT INTO apwNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Áí na’iziidi binant’a’ doo yiká déz’įį dagee, doo nyołíí dagee nadáhgo, ");
INSERT INTO apwNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nbihiłgeesh, áídí’ hadíí daanzhǫǫ ádaagodil’ínihíí bich’į’zhiṉéégo nilteeh: áígee daach’ichag ła’íí kowoo łídaach’idiłk’ash doo. ");
INSERT INTO apwNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí díí k’ehgo at’éé: ch’ekíí gonenan kǫ’ nałbaałíí dahdaayo’aałgo nṉee niiṉéhíí bich’į’yú deskai. ");
INSERT INTO apwNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ashdla’ihíí daagoyą́ą́, áídá’ ashdla’ihíí doo daagoyą́ą́ da. ");
INSERT INTO apwNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Doo daagoyą́ą́ dahíí kǫ’ nałbaałíí dahdaayo’aał ndi túkǫ’íí ik’e’an doo ła’ dahdaidnziid da. ");
INSERT INTO apwNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Áídá’ daagoyááníí túkǫ’íí tús biyi’ siziidgo ik’e’an dahdaidn’ąą lę́k’e, kǫ’ nałbaałíí biłgo. ");
INSERT INTO apwNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nṉee niiṉéhíí t’ah doo hwahá hígháh dadá’, ch’ekíí bił daanzįįgo da’iłhaazh. ");
INSERT INTO apwNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tł’é’is’ahyú ła’ nádidilghaazh gáṉíígo, Daadeh’į́į́, nṉee niiṉéhíí kodí’ higaał; bich’į’ dohkáh. ");
INSERT INTO apwNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Áík’ehgo ch’ekííhíí nádiikaigo bikǫ’ nałbaałíí iłch’į’daizlaa. ");
INSERT INTO apwNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Áídá’ doo daagoyą́ą́ dahíí daagoyááníí gádaayiłṉii, Túkǫ’ííła’ nohwaa daanohsiid; nohwikǫ’ nohwits’ą́’ daanestsiz. ");
INSERT INTO apwNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Daagoyááníí gádaabiłṉii, Dah; ágádaasiidzaayúgo, doo hwoi da hileeh: áídá’ hayú nahiṉiih goz’ąąyú dohkáhgo ła’ nadaahołṉiih. ");
INSERT INTO apwNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nada’iłṉiihyú okaidá’ nṉee niiṉéhíí ńyáá; áík’ehgo iłk’idá’ nłt’éégo ádaadeszaago naháztaaníí ni’i’ṉéh yuṉe’ okai: áídí’ da’det’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Bikédí’go ła’ ch’ekíí n’íí nákaigo gádaaṉii, Nohwinant’a’, Nohwinant’a’, nohwá ch’í’íńtįįh. ");
INSERT INTO apwNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Áídá’ nṉee niiṉéhíí gádaabiłṉii, Da’aṉiigo gánohwiłdishṉii, Doo nohwídaagonsį da. ");
INSERT INTO apwNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Áík’ehgo biká ńdaadeht’į́įh; hadíí bijįį shįhíí, da’kwíí bik’ehenkééz shįhíí shíí, nṉee k’ehgo Niyááhíí, nánshdáhíí doo bídaagonołsį da. ");
INSERT INTO apwNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yaaká’yú dahsdaahń bilałtł’áhgee begoz’aaníí díí k’ehgo at’éé: nṉee ńzaadyú deyaago bánada’iziidíí yushdé’ nnohkáh yiłṉiigo, bíyééhíí yiṉádaadéz’įįgo yaidin’ą́ą́ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ła’ bestso talent holzéhi ashdla’i yaidin’ą́ą́, ła’íí naki yaidin’ą́ą́, ła’íí dała’á yaidin’ą́ą́; dawa daantį́į́gee dá yídaanel’ąągee yaidin’ą́ą́go; áídí’ nant’ánhíí dagoshch’į’ dahnyaa. ");
INSERT INTO apwNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nṉee talents ashdla’i baadet’aaníí hant’é nayihesṉiihíí baa nanáhazṉiigo ashdla’i bá ígoya. ");
INSERT INTO apwNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ła’íí talents naki baadet’aaníí ałdó’ naki bá ígoya. ");
INSERT INTO apwNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Áídá’ talent dała’á baadet’aaníí łeyi’ ogogeed yuyaa binant’a’ bibestsohíí náyides’įįd. ");
INSERT INTO apwNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Áídí’ ńzaad godeyaago binant’a’íí nádzáágo yił daayołtag. ");
INSERT INTO apwNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Áík’ehgo talents ashdla’i baadet’aaníí talents ashdla’i bá’ígoyahíí ałdó’ ákú yinné’ gáṉiigo, Shinant’a’, talents ashdla’i shá ńṉil n’íí talents ashdla’i shá ígoya. ");
INSERT INTO apwNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Binant’a’ gábiłṉii, Negondlįįgo shána’izíídi, nłt’éégo ándzaa ląą: da’ayą́háhi ndi nłt’éégo shá ánlaahíí bighą łáni benik’ehgo ánishłe’: shíí ninant’a’ baa shił gozhóóníí ni ałdó’ baa nił gozhǫ́ǫ́ le’. ");
INSERT INTO apwNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Talents naki baadet’aaníí ałdó’ kú ńyáá gáṉíígo, Shinant’a’, talents naki shá ńlaa n’íí talents naki shá ígoya. ");
INSERT INTO apwNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Binant’a’ gábiłṉii, Negondlįįgo shána’izíídi, nłt’éégo ándzaa ląą: da’ayą́háhi ndi nłt’éégo shá ánlaahíí bighą łáni benik’ehgo ánishłe’: shíí ninant’a’ baa shił gozhóóníí ni ałdó’ baa nił gozhǫ́ǫ́ le’. ");
INSERT INTO apwNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Áídí’ talent dała’á baadet’aaníí kú ńyáá gáṉíígo, Shinant’a’, nṉee doo bee gónedząą dahi ńlį́į́go nígonsį, doo k’edínlaa dayú ná’igéésh, doo ishínlch’ii dayú łená’ílá: ");
INSERT INTO apwNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nésdzidgo, nitalent‐híí łeyi’ yuyaa nádéł’į́ ni’; koh, ṉíyéé naa náníné’. ");
INSERT INTO apwNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Binant’a’ gábiłṉii, Nchǫ’go shána’izíídi, bił goyé’i ńlį́į́, doo k’e’diláá dayú ná’ishgeesh, doo ishíłch’ii dayú łená’ishłá bígonłsį́: ");
INSERT INTO apwNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Áí bighą bestso iłkáh ch’ídaihiṉiiłíí shizhaali bánné’ le’at’éhi, áík’ehgo nánsdzaago bínágodáhíí bił shaa nánné’ doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Áík’ehgo talent‐híí bits’ą́’ nádo’né’go nṉee gonenan talents bíyééhíí baa no’né’. ");
INSERT INTO apwNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Dahadíń dant’éhéta bíyéé gólííníí bitisgo baa nádo’né’, áík’ehgo łą́ą́go bíyéé doleeł: áídá’ dahadíń bíyéé da’ayą́háhi, bíyéé gólį́į́ n’íí ndi bits’ą́’ nádido’né’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na’iziidi doo bik’ehyú át’éé dahíí chagołheełzhį’ ch’ídaanołt’e’: ákú daach’ichag ła’íí kowoo łídaach’idiłk’ash doo. ");
INSERT INTO apwNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Shíí, nṉee k’ehgo Niyááhíí, shits’ą́’idindláádíí bee dahnádisdzaago yaaká’dí’go nadaal’a’á dilzini bił nánshkáh, biká’dahsdáhá biká’dí’ shits’ą́’idindládi biká’ dahsidáágo nansht’aa doo: ");
INSERT INTO apwNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Shinadzahgee nṉee iłtah at’éégo hadaazt’i’íí dawa íła’alṉéhgo iłts’ą́’ hishṉiił, dibełį́į́ nanyoodi bidibełį́į́ hik’e gantł’ízí bits’ą́’yihiṉiiłhíí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dibełį́į́ shigan dihe’nazhiṉéégo nnihishṉiił, áídá’ gantł’ízí she’eshganzhiṉéégo. ");
INSERT INTO apwNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Áídí’ shíí, Ízisgo Nansht’aahíí, shigan dihe’nazhiṉéégohíí gádaałdishṉii, Yushdé’, shiTaa gozhóóníí nohwá ádaizlaahíí, ni’gosdzáń nnit’ąądá’ bee nadaanoht’aa doleełgo nohwá iłch’į’golzaahíí bee nadaanoht’aa le’: ");
INSERT INTO apwNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Shiṉá’ nshłįįgo shá da’desoné’ ni’: dibá’ nshłįįgo tú shaa daasoziid ni’: doo kígonsį dayú hishaałgo nádaashidołtįį ni’: ");
INSERT INTO apwNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Shidiyágé ádįhgo diyágé shá ádaagosolaa ni’: dinshṉiihgo shaa nanádaanohtaah ni’: ha’ásítį́į́go shaa nahkáh ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Áík’ehgo dábik’ehyú ádaat’eehíí gádaashiłṉiih, NohweBik’ehń, dadá’ shiṉá’ ńlį́į́go daaniit’įįgo ná da’de’né’ láń? Ła’íí dibá’ ńlį́į́go tú nadaasiidziid láń? ");
INSERT INTO apwNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Dadá’ doo kígonłsį́ dayú híṉááłgo nádaanideltįį láń? Ła’íí nidiyágé ádįhgo naa daasii’ṉil láń? ");
INSERT INTO apwNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ła’íí dadá’ dinṉíihgo dagohíí ha’ásíńtįįgo daaniit’įįgo naa nkai láń? ");
INSERT INTO apwNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Shíí, Ízisgo Nansht’aahíí, bich’į’ hasdziihgo gádaałdishṉiih, Da’aṉii gánohwiłdishṉii, Shik’isyú doo ízisgo at’éé dahi ndi ágádaasolaayúgo, shíí ałdó’ ágádaashisolaahi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Áídí’ she’eshganzhiṉééhíí ałdó’ díí k’ehgo bich’į’ hasdziih, Nohwíí, da’ílíí daahłeehgo nohwá ndaagost’ąąhíí shits’ą́’zhį’ daadohkáh, kǫ’ dahazhį’ diltłi’ yuṉe’, ch’iidn nant’án hik’e binadaal’a’á biłgo bá iłch’į’golzaayú. ");
INSERT INTO apwNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Shiṉá’ nshłįįgo doo shá da’desoné’ da ni’: dibá’ nshłįįgo tú doo shaa daasoziid da ni’: ");
INSERT INTO apwNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Doo kígonsį dayú hishaałgo doo nádaashidołtįį da ni’: shidiyágé ádįhgo diyágé doo shá ádaagosolaa da ni’: dinshṉiihgo ła’íí ha’ásítį́į́go doo shaa noyaa da ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Áík’ehgo gádaashiłṉiih, NohwiNant’a’, dadá’ shiṉá’ ńlį́į́go, dagohíí dibá’ ńlį́į́go, dagohíí doo kígonłsį́ dayú híṉááłgo, dagohíí nidiyágé ádįhgo, dagohíí dinṉíihgo, dagohíí ha’ásíńtįįgo daaniit’įįgo doo nich’odaasii’ṉi’ da láń? ");
INSERT INTO apwNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Áík’ehgo gádaałdishṉiih, Da’aṉii gánohwiłdishṉii, Díí doo ízisgo at’éé dahi ndi doo ágádaasolaa dayúgo, shíí ałdó’ doo ágádaashisolaahi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Dííhíí dahazhį’ biniigodilṉe’ doleeł, áídá’ dábik’ehyú ádaat’eehíí dahazhį’ daahiṉaa doleeł, yaaká’yú. ");
INSERT INTO apwNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Áík’ehgo Jesus díí ąął yaa nagosṉi’dá’ bitsiłke’yu gádaayiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Nakiskąą hik’e bitis‐hagowáh n’íí bee bíná’ godiṉíhgo da’idąą doleełíí bídaagonołsį, áígee shíí, nṉee k’ehgo Niyááhíí, shik’edaanṉiihíí bilák’e shi’dolteełgo tsį’iłna’áhi bíshi’dilkał. ");
INSERT INTO apwNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Áídí’ okąąh yebik’ehi itisyú nadaandeehíí, begoz’aaníí ye’ik’eda’iłchíhi, ła’íí nṉee yánazíni okąąh yebik’ehi da’itiséyú sitíni, Cáiaphas holzéhi, bigowągee íła’adzaago, ");
INSERT INTO apwNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Hagot’éégo dánant’į’eego Jesus daayiłtsoodgo daayiziłheego yee ndaagoshchįį. ");
INSERT INTO apwNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Áídá’, Doo da’idąąhíí bijįį daahiiltsood da, daaṉii, ágádaasiidzaayúgo nṉee dánko bádaagochįįhgo godnch’aad doleełi at’ééhíí bighą, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Béthanyú Simon, łóód doo ínádįh dahi, léprosy holzéhi, yaa naghaa n’íí bigową yuṉe’ Jesus sidaadá’, ");
INSERT INTO apwNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iyąągo sidaago isdzán ła’ ch’il bik’ah łáń ílíni tús alabáster be’alzaahi besi’áni ha’áyí’ą́ą́go Jesus baa nyáá, áí ik’ahíí Jesus bitsits’in yiká’ yaa yiziid. ");
INSERT INTO apwNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jesus bitsiłke’yu díí daayiłtsąągo doo bił dábik’eh dago gádaaṉii, Nt’é bighą ik’ahíí da’ílíí yishchįį? ");
INSERT INTO apwNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Áí ik’ahíí łą́ą́go ílį́į́go nahiṉiihgo, zhaalihíí tédaat’iyéhíí baa hi’né’ le’at’éhi. ");
INSERT INTO apwNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ádaaṉiihíí Jesus yígołsįįdgo gábiłṉii, Nt’é bighą isdzánhíí nadaanołtł’og? Nłt’éégo áshíílaa. ");
INSERT INTO apwNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tédaat’iyéhíí dabik’ehn nohwitahyú nadaakai; áídá’ shihíí doo dahazhį’ nohwitahyú nashaa da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Doo hwahá łeeh shi’dilteeh dadá’ ik’ahíí shits’í yiká’ yaa yiziid. ");
INSERT INTO apwNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Da’aṉii gánohwiłdishṉii, Ni’gosdzáń dágoz’ąą nt’éégo dahayú yati’ baa gozhóni baa na’goṉi’gee, díí isdzán adzaahíí baa na’goṉi’ doleeł, bee bíná’godiṉíhgo. ");
INSERT INTO apwNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Áídí’ Judas Iscáriot, nakits’ádahíí itah nlíni, okąąh yebik’ehi itisyú nadaandeehi yaa nyáágo, ");
INSERT INTO apwNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jesus hayúhíí nohwił ch’ínsh’aahdá’, hant’é shaa daanohné’? daayiłṉii. Zhaali łigaií tádin naa do’né’, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Áídí’ godezt’i’go hagot’éégo ch’íidish’aał nzįgo yiká hésdaa nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Báń benilzoołíí da’ádįhgo báń alzaahi daadaaníí dantséhíí bijįį Jesus bitsiłke’yu baa hikaigo gádaabiłṉii, Bitis‐hagowáh n’íí bee bíná’godiṉíhgo da’idaaníí hayú ná iłch’į’daagohiidle’? ");
INSERT INTO apwNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesus gádaabiłṉii, Kįh gozṉilyú dohkáh, áígee nṉee ła’ gádaabiłdohṉiih, Iłch’ígó’aahíí gáṉíí, Iłk’idá’ shaa gonyáá; nigową yuṉe’ bitis‐hagowáh n’íí bee bíná’godiṉíhgo shitsiłke’yu bił da’ishąą doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Áík’ehgo Jesus ádaabiłṉii n’íí k’ehgo bitsiłke’yu ádáát’įįd; áígee bitis‐hagowáh n’íí bee bíná’godiṉíhgo da’idaaníí iłch’į’daizlaa. ");
INSERT INTO apwNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Áídí’ o’i’ą́ą́yú nakits’ádahíí da’iyąągo yił dahdinezbįh. ");
INSERT INTO apwNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Da’iyąągo Jesus gáṉíí, Da’aṉiigo gánohwiłdishṉii, nohwíí ła’ ch’íshinoh’aah doleełi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Áík’ehgo dázhǫ́ doo bił daagozhǫ́ǫ́ dago dała’á daantį́į́go, SheBik’ehń, ya’ shíí née? daaṉii nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Áík’ehgo gáṉíí, Dahadíń its’aa biyi’zhį’ dała’ bił éédisht’áhi, áń ch’íshí’aah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Shíí, nṉee k’ehgo Niyááhíí, dá shaa k’e’eshchiiníí shee godolṉiił: áídá’ nṉee ch’íshí’aahíí bá góyéé doleeł! Áí nṉeehíí doo bi’deshchįį dayúgo nłt’éé doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Áídí’ Judas, ch’íbí’aah doleełíí, Jesus gáyiłṉii, Iłch’ígó’aahíí, ya’ shíí née? Jesus gábiłṉii, Da’áígee ánṉiid. ");
INSERT INTO apwNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Da’iyąągo Jesus báń náidn’ąągo ya’ihénzįgo oskąądá’ iłk’ídaizné’go bitsiłke’yu yitaizṉiih, Nkóh daohsąą; díí shits’í át’éé, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Áídí’ idee beda’iskaaníí náidnkąą, áí ya’ihénzįgo oskąądá’ iłtah daidezkąą, Daanohwigha daohdląą, yiłṉiigo; ");
INSERT INTO apwNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Díínko shidił k’ehgo at’éé, shidił bee áníidégo łángont’aahi at’éé, nṉee łą́ą́go bá idijoołíí, binchǫ’híí bighą baa nádaagodet’aahgo. ");
INSERT INTO apwNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gádaanohwiłdishṉii, Kodí’ godezt’i’go dahts’aa bitoohíí doo naanáshdlą́ą́ da, dahadíí bijįį shiTaa bilałtł’áhgee goz’ąąyú áníidéhi nohwił naadaadishdlįįłgo zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Áídí’ sį ła’ hadaidez’ąądá’, dził Olives holzéhi si’ąąyú okai. ");
INSERT INTO apwNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Áígee Jesus gádaabiłṉii, Tł’é’go áshi’dilṉe’híí bighą daanohwigha t’ąązhį’ ádaahṉe’: díí baa k’e’eshchįįhíí k’ehgo, Dibełį́į́ Nanyoodíí biṉí’dishṉíh, áík’ehgo dibełį́į́híí da’adzaayú nkenelt’ee doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Áídá’ dasiitsąądí’ naadisdzaago Gálileeyú nohwádįh disháh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter gábiłṉii, Nṉee dawa nits’ą́’ t’ąązhį’ ánádaasdzaa ndi, shíí doo ágáoshṉe’ at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus gánábiłdo’ṉiid, Da’aṉiigo gániłdishṉii, Tł’é’go tazhik’áné doo hwahá áṉiih dadá’ taadn, Áń doo bígonsį da, shiłdinṉíił. ");
INSERT INTO apwNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Áídá’ Peter gábiłṉii, Dała’ nił dastsaah ndi, Áń doo bígonsį da, doo niłdoshṉiih at’éé da. Ła’ihíí bitsiłke’yu dawa da’áík’ehgo ádaanṉiid. ");
INSERT INTO apwNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Áídí’ Gethsémane golzéhi goz’ąąyú Jesus bitsiłke’yu yił hikaidá’ Jesus gádaabiłṉii, Dádząą nahísóotąą, nláhyú déyáá, oshkąąhyú. ");
INSERT INTO apwNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Peter ła’íí Zébedee biye’ke naki Jesus yił okai, áídí’ dázhǫ́ doo bił gozhǫ́ǫ́ dago bijíí nṉiih nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Áík’ehgo gádaabiłṉii, Shiyi’siziiníí dázhǫ́ doo bił gozhǫ́ǫ́ da, dák’azhą́ dastsaahíí ga’at’éé: dádząą nahísóotąągo sha’ishhah daadeh’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Áídí’ da’aṉahyú óyááyú ni’zhį’ hayaa adzaago okąąh gáṉíígo, Bígonedząąyúgo, shiTaa, díí hishdląą doleełíí shits’ą́’zhį’ ánle’: áídá’ shíí doo beshik’eh da, ni zhą́ benik’eh. ");
INSERT INTO apwNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Áídí’ bitsiłke’yu yaa nadzaago da’iłhoshgo yiká nnyáá, áík’ehgo Peter gáyiłṉii, Dała’á łedihikeezzhį’ ndi shą’ doo sha’ashhah daadeh’į́į́ le’at’éé da? ");
INSERT INTO apwNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Daadeh’į́į́go da’ohkąąh, nanohwída’dintaah bídaanołdzil doleełhíí bighą: nohwiyi’siziiníí da’aṉii hát’į́į́ ndi nohwits’íhíí doo nłdzil da. ");
INSERT INTO apwNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nakidn onaanádzaagee na’okąąh gáṉíígo, ShiTaa ńlíni, díí hishdląą doleełíí doo hagot’éégo shits’ą́’zhį’ alṉe’ dayúgo hishdląą, ni nik’ehgo ágoṉe’. ");
INSERT INTO apwNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Bitsiłke’yu da’iłhoshgo yaa naanádzaa: dázhǫ́ bił daanzįgo. ");
INSERT INTO apwNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Áídí’ yits’ą́’ onaanádzaa, okąąhyú taadngee da’ágánádi’ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Áídí’ bitsiłke’yu yaa naanádzaago gádaayiłṉii, Akú da’ołhoshgo hanádaahsoł: shíí, nṉee k’ehgo Niyááhíí, nṉee doo bik’ehyú ádaat’ee dahíí bilák’e shi’dilteehgo ch’íshi’dot’aałíí iłk’idá’ biká’ ngonyáá. ");
INSERT INTO apwNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nádohkáh, hiikaah le’: ch’íshí’aahíí kodí’ higaał. ");
INSERT INTO apwNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus t’ah yałti’dá’ Judas, nakits’ádahíí bił itah nlíni, nṉee łą́ą́go bésh be’idiltłishé ła’íí tsį be’idiltłishé dahdaayiṉííłgo, okąąh yebik’ehi itisyú nadaandeehíí ła’íí nṉee yánazíni daabides’a’íí yił náłsą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ch’íbí’aah doleełíí iłk’idá’ bebígózį doleełíí yengon’ą́ą́ lę́k’e, gáṉíígo, Hadíń hists’ǫsíí áí áń doleeł; áń daahołtsood. ");
INSERT INTO apwNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Dagoshch’į’ Jesus yaa nyáágo, Gozhǫ́ǫ́, Iłch’ígó’aahíí, yiłṉiigo yizts’ǫs lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus gábiłṉii, Shik’isn, hant’é bighą ńyaa? Áídí’ Jesus yił ndaazdeelgo daayiłtsood. ");
INSERT INTO apwNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nṉee dała’á Jesus yił hikaahíí bibízh be’idiltłishé hayidzį́į́zgo okąąh yebik’ehi da’tiséyú sitíni binal’a’áhi yontłízhgo bijaa naidnłgizh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus gábiłṉii, Nibízhíí iłch’į’nántįįh: dahadíń bésh yee iziłheehíí dabíí ałdó’ bésh bee nabizi’dodeełi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ya’ doo bígonłsį́ da née, shiTaa bich’į’ oshkąąhyúgo binadaal’a’á yaaká’dí’hi nakits’ádahyú siṉili dagoshch’į’ shich’į’ yidił’aah go’į́į́? ");
INSERT INTO apwNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Áídá’ ágádzaayúgo, Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí hagot’éégo begolṉe’? Da’ágágoṉéhgo goz’ąą go’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Da’áí bik’ehenkéézgee Jesus nṉee baa nánłsą́ą́híí gádaayiłṉii, Ya’ bésh be’idiltłishé ła’íí tsį be’idiltłishé dahdaanohṉiiłgo daashołtsoodgo nánołsąą née, in’įįhíí daach’iłtsoodhíí k’ehgo? Dawa jįį ła’ da’ch’okąąh goz’ąą yuṉe’ nohwił ch’ídaagonsh’aahgo dahsídáá át’éé ni’, ndi doo hak’i daashołtsood da ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí yee K’e’eshchiiníí begolṉe’híí bighą díí dawa ánágot’įįł. Áídí’ bitsiłke’yu dawa bits’ą́’zhį’ ádaaszaago bits’ą́’ iłhadeskai. ");
INSERT INTO apwNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nṉee Jesus daabiłtsoodíí okąąh yebik’ehi da’tiséyú sitíni, Cáiaphas holzéhi, yaa yił hikai, begoz’aaníí ye’ik’eda’iłchíhi hik’e Jews yánazíni biłgo íła’at’éégee. ");
INSERT INTO apwNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peter da’aṉahgo biké’dí’ higaał, áídí’ okąąh yebik’ehi da’tiséyú sitíni bikįh biṉaa łé’ditł’įįh yuṉe’ ha’ayáágo nada’iziidi bitahyú nezdaa, hago ágoṉe’íí dá’ąąłzhį’ yineł’į́į́ hát’į́į́go. ");
INSERT INTO apwNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Okąąh yebik’ehi itisyú nadaandeehi, Jews yánazíni, yánádaaltihi biłgo Jesus zidee hádaat’įįgo daazhógo yaa dahgosi’aahíí yiká daadéz’įį; ");
INSERT INTO apwNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ndi doo ła’ da: łą́ą́go neheskai ndi dá doo at’éé dayú baa dahdaago’aahíí doo ła’ da. Nt’éégo nṉee naki n’áázh, daazhógo baa dahdaago’aahi, ");
INSERT INTO apwNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Gádaaṉiigo, Díí nṉee, Bik’ehgo’ihi’ṉań daach’okąąh goz’aaníí tagoshṉiłgo, áídí’ taagi jįį hileehgo ánágoshdle’go bínesh’ąą, ṉíí ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Okąąh yebik’ehi da’tiséyú sitíni hizį’go Jesus gáyiłṉii, Ya’ nihíí doo nt’é nṉiigo hadziih da née? Díí naa dahdaago’aahgo naa yádaałti’íí hago at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Áídá’ Jesus doo nt’é ṉii da. Okąąh yebik’ehi da’tiséyú sitíni gábiłṉii, Bik’ehgo’ihi’ṉań hiṉáhi biláhyú gániłdishṉii, Nohwił nagolṉí’, ya’ ni Christ, Bik’ehgo’ihi’ṉań biYe’ ńlį́į́ née? ");
INSERT INTO apwNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus gábiłṉii, Da’áígee áńṉiid: gádaanohwiłdishṉii, Díí bikédí’go shíí, nṉee k’ehgo Niyááhíí, da’tiséyú binawod golíni bigan dihe’nazhiṉéé dahsídáágo, yaaká’dí’ yaak’os shił hoṉáhgo daashidołtsééł. ");
INSERT INTO apwNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Áík’ehgo okąąh yebik’ehi da’tiséyú sitíni bidiyágé ídá nayihesdzį́į́zdá’ gáṉíí, Bik’ehgo’ihi’ṉań nchǫ’go yaa yałti’; nt’é bighą nṉee ła’i baa yanánálti’ doleeł? Bik’ehgo’ihi’ṉań nchǫ’go yaa yałti’íí daadisots’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hagot’éégo baa natsídaahkees? Zideego bángonot’aah daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Áídí’ biniizhį’ odaach’idihizheeh, ła’íí ńdaach’inłts’į; ła’ihíí bítł’adaach’ika’, ");
INSERT INTO apwNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Gádaaṉiigo, Christ ńlíni, Bik’ehgo’ihi’ṉań binkááyú yáńłti’yúgo, hadíń náninłts’į shįhíí nohwił nagolṉí’. ");
INSERT INTO apwNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Okąąh yebik’ehi da’tiséyú sitíni bikįh biṉaa łé’ditł’įh yuṉe’ Peter sidaa: áígee isdzán na’iziidi baa nyáágo, Ni la’ ałdó’ Jesus Gálileedí’ nagháhi bił na’aash ni’, biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Áídá’ dawa biṉááł, Dah, hant’é nṉiigo ánṉiihíí doo bígonsį da, nṉiid. ");
INSERT INTO apwNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kįh bahgee ch’ínágohen’ą́ą́yú ch’ínyáágo isdzán na’iziidi ła’i náábiiłtsąągo, áígee naháztaaníí gáyiłṉii, Díí nṉeehíí ałdó’ Jesus, Názarethdí’ gólíni, yił na’aash ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bitł’a dahdidilṉiihdá’ gánádo’ṉiid, Áí nṉeehíí doo bígonsį da. ");
INSERT INTO apwNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dét’įhék’e ałhánídí’ nazíni Peter yaa hikaigo gádaayiłṉii, Da’aṉii ni áí itah ńlį́į́, niyati’íí bee nígózį. ");
INSERT INTO apwNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Áídá’ Peter bitł’a dahdidilṉiihgo hashkeego nchǫ’go yałti’ nkegonyaa, Ai nṉeehíí doo bígonsį da, ṉíí ńt’éégo, áígee tazhik’áné ánṉiid. ");
INSERT INTO apwNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Peter Jesus gábiłnṉiid n’íí yénálṉii, Tazhik’áné doo hwahá áṉiih dadá’ taadn, Áń doo bígonsinihi at’éé da, shiłdinṉíił. Áídí’ ch’ínyáágo dázhǫ́ doo bił gozhǫ́ǫ́ dago hichag. ");
INSERT INTO apwNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hayiłką́ą́yú okąąh yebik’ehi itisyú nadaandeehi hik’e Jews yánazíni biłgo dawa hagot’éégo Jesus zidee doleełíí yaa nadaagoshchįį: ");
INSERT INTO apwNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Áík’ehgo łídaistł’ǫǫgo dahdainłt’e’, nant’án, Póntius Pílate holzéhi, yaa daidez’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, ch’íbin’áni, Jesus zideego bángot’ąągo yígołsįįdá’, dázhǫ́ doo bił gozhǫ́ǫ́ dago zhaali tádinhíí okąąh yebik’ehi itisyú nadaandeehíí, Jews yánazíni biłgo t’ąązhį’ yaa náyiné’, ");
INSERT INTO apwNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Gáṉíígo, Nṉee dábik’ehyú át’éhi ch’íní’ą́ą́híí bighą doo bik’ehyú ásdzaa da. Áík’ehgo gádaabiłṉii, Néé doo nanohwinłtł’og da. Dani nanínłtł’og le’. ");
INSERT INTO apwNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Da’ch’okąąh goz’ąą yuṉe’ zhaalihíí nayiłkaadá’ ch’ínyáágo da’ídodleeh. ");
INSERT INTO apwNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Okąąh yebik’ehi itisyú nadaandeehíí zhaali nádaidnné’go gádaaṉii, Zhaali biyi’ ohilkaadíí biyi’ yuyaa doo o’né’go goz’ąą da, dił bighą nahasṉilhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Áík’ehgo yaa yádaałti’dá’ zhaalihíí bee nṉee goshtł’ish tús áiléhi bini’ nahazṉii, áígee aṉahdí’ nadaakaihíí łehi’ṉííł doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Áí bighą áídí’ godezt’i’go díí jįįzhį’ áí ni’híí, Ni’ dił bee nahazṉiihíí, holzee. ");
INSERT INTO apwNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Áík’ehgo Jéremy, Bik’ehgo’ihi’ṉań binkááyú na’iziidi, gáṉíí n’íí begolzaa, Zhaali tádinhíí, Israel hat’i’íí ła’i, Áí nṉee ilį́į́, daaṉiigo, nádaidnné’go, ");
INSERT INTO apwNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Goshtł’ish tús áiléhi bini’íí yaa nadaihesṉii, sheBik’ehń áshiłnṉiid n’íí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus nant’án yidáhzhį’ sizįįgo nayídiłkid gáyiłṉiigo, Jews ízisgo biNant’a’i ńlį́į́ née? Da’áígee ánṉii, biłṉii, Jesus. ");
INSERT INTO apwNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Okąąh yebik’ehi itisyú nadaandeehíí, Jews yánazíni biłgo baa dahgoz’ąą ndi doo nt’é ṉii da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Áík’ehgo Pílate gábiłṉii, Łą́ą́go naa yádaałti’íí ya’ doo dints’ag da née? ");
INSERT INTO apwNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Áídá’ t’ah Jesus doo nt’é biłṉii da, yati’ dała’á ndi; áí bighą nant’án dázhǫ́ bił díyagot’ee. ");
INSERT INTO apwNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bitis hagowáh n’íí bíná’godiṉíhgo da’idąągee ha’áshijeedíí dała’á, hadíí nṉee hádaat’iiníí, nant’án bá ch’ínádaayíłtéeh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Áígee nṉee doo bik’ehyú át’éé dago bígózini, Barábbas holzéhi, ha’ásitįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Áík’ehgo nṉee íła’adzaago Pílate gádaabiłṉii, Hadíí nohwich’į’ ch’ínánshteeh hádaaht’įį? Barábbas née, dagohíí Jesus, Christ holzeehíí née? ");
INSERT INTO apwNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pílate yígółsį nṉee dawa Jesus bił daanzhǫǫhíí bighą okąąh yedaabik’ehi Jesus yik’edaanṉiihgo baa daabidez’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pílate yánáltihgo dahnezdaadá’ bi’aahíí, ła’ yich’į’ yił’aa gábiłṉiigo, Áí nṉee dábik’ehyú át’ééhíí doo baa nanṉaa da, díí jįįgo baa naiseełgo shiniigonłt’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Okąąh yebik’ehi itisyú nadaandeehi, Jews yánazíni biłgo nṉee íła’adzaahíí biini’ yá ádaagozlaa, gádaayiłṉiigo, Barábbas nohwá ch’ínáńłteehdá’ Jesus‐híí zodéé, daadohṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nant’ánhíí gádaabiłṉii, Díí nṉee nakihíí hadíí nohwich’į’ ch’ínánshteeh? Barábbas zhą́ hádaahiit’įį, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pílate gánádaabiłdo’ṉiid, Jesus, Christ holzéhi, hago ląą nohwá áshłe’ áídá’? Dawa gádaabiłṉii, Tsį’iłna’áhi bíhołkałgo zodéé. ");
INSERT INTO apwNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nant’ánhíí gádaabiłṉii, Nt’é bighą, hant’é bee nchǫ’go adzaago? Nṉee da’tiségo nnádaadidilghaazhgo, Tsį’iłna’áhi bíhołkałgo zodéé, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pílate doo hagot’éégo nṉee yidag hagháh át’éé dago, ła’íí godnch’áad nkegonyaago yígołsįįdá’, nṉee íła’adzaahíí biṉááł tú náidnkąągo bigan tayizgis, gáṉíígo, Díí nṉee dábik’ehyú át’ééhíí bidiłíí shíí doo nashinłtł’og da: dánohwíí nadaanohwinłtł’og le’. ");
INSERT INTO apwNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nṉee dawa gádaabiłṉii, Bidiłíí nohwiká’zhį’ at’éé doleeł, ła’íí nohwichągháshéhíí ałdó’ biká’zhį’ at’éé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Áík’ehgo Pílate Barábbas nṉee yich’į’ ch’ínáinłtį́į́, áídá’ Jesus‐híí habí’ oltsaazdá’ tsį’iłna’áhi bíhołkałgo zidéégo nṉeehíí yaa daidez’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nant’án bisiláádahíí yáná’itih goz’ąą yuṉe’ Jesus odaizt’e’ lę́k’e, áígee silááda dawa baa íła’ádaizlaa. ");
INSERT INTO apwNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Áídí’ bidiyágé yaa daidnłtsoozdá’ diyágé łichí’i yá ádaagozlaa. ");
INSERT INTO apwNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Hosh diwozhi nánihezwodgo nant’án bich’ah k’ehgo alzaahi bik’e daidez’ąą, bigan dihe’nazhiṉéégo tsį yaa daiztąą: ła’íí bich’į’ nádaahilzhishgo baa daadloh, Gozhǫ́ǫ́, Jews ízisgo biNant’a’ ńlíni! daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Áídí’ bik’ídaadihizheeh, ła’íí tsįhíí naanádaidntąągo bitsits’inyú nádainłtłish. ");
INSERT INTO apwNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ąął baa daadlohdá’, diyágé yaa daidnłtsoozdá’ dabíí bidiyágé yá ánádaagosdlaa, áídí’ tsį’iłna’áhi yiká’ daiziłheeyú bił nádeząą lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ch’ínáńłsą́ą́yú nṉee Símon holzéhi, Cyréne golzeedí’ gólíni, silááda daabiłtsąągo, Tsį’iłna’áhi bá dahngheeh, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Áík’ehgo Gólgotha golzeegee náńłsą́ą́, áí golzeego itsits’in si’áni golzeego ágolzee. ");
INSERT INTO apwNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Áígee vinegar, nch’í’i bił nadesdziidgo, Jesus yaa daizkąą: yizlįh ndi doo yodląą da. ");
INSERT INTO apwNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Áígee tsį’iłna’áhi yídaabiskałdá’ bidiyágé iłta’isṉiigo yighą da’diłjoł lę́k’e: Bik’ehgo’ihi’ṉań binkááyú na’iziidi gáṉíí n’íí begolṉe’go ánágot’įįł, Shidiyágé iłta’isṉii, ła’íí iká’ shi’ííhíí yighą da’diłjoł. ");
INSERT INTO apwNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Áídí’ áígee naháztąągo daabineł’į́į́ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nt’é baa dahgost’aaníí ádaagozlaago bitsit’á’gee díínko dahdaiztąą, DÍÍ JESUS JEWS ÍZISGO BINANT’A’ NLÍNI, golzeego k’e’eshchįį. ");
INSERT INTO apwNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Áígee nṉee da’in’įįhíí naki ałdó’ Jesus ba’ashhahdí’ tsį’iłna’áhi bídaahaskał, ła’ dihe’nazhiṉéégo, ła’íí be’eshganzhiṉéégo. ");
INSERT INTO apwNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bahyú ch’íhikáhíí bitsits’in daidiłtasgo yati’ yee daabokáał, ");
INSERT INTO apwNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Gádaaṉiigo, Biyi’ da’ch’okąąhíí tanágoshṉiłgo taagi jįį hileehgo ánágoshdle’, nṉii ni’, haląą, Bik’ehgo’ihi’ṉań biYe’ ńlį́į́yúgo dáni hasdá’ánlteehgo tsį’iłna’áhi biká’dí’ gódah ch’ínṉáh. ");
INSERT INTO apwNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Okąąh yebik’ehi itisyú nadaandeehi, begoz’aaníí ye’ik’eda’iłchíhi, ła’íí Jews yánazíni ałdó’ baa daadloh lę́k’e, gádaaṉiigo, ");
INSERT INTO apwNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Nṉee hasdáyiṉiiłdá’ bíhíí doo hasdá’ádilteeh da. Israel hat’i’íí ízisgo biNant’a’ nlįįyúgo, tsį’iłna’áhi yiká’dí’ naadowáh, áík’ehgo daahohiidląąh. ");
INSERT INTO apwNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bik’ehgo’ihi’ṉań ya’ołíí; áń hát’į́į́yúgo hasdábółteeh: Bik’ehgo’ihi’ṉań biYe’ nshłįį, ṉiidá’, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Da’n’įįhíí áígee tsį’iłna’áhi yídaayiskałíí ałdó’ da’áík’ehgo bee baa daadlohgo daabóch’iid lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Isk’áhńyáádí’ taagi nehenkéézzhį’ ni’ biká’ dahot’éhé godiłhił gozlįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Taagi nehenkéézgo shį Jesus nádidilghaazhgo gáṉíí, Éli, Éli, láma sabákthani? áí, Bik’ehgohinshṉaahíí, Bik’ehgohinshṉaahíí, nt’é ląą bighą shits’ą́’zhį’ ándzaa? golzeego ágolzee. ");
INSERT INTO apwNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ła’ áígee nadaaziiníí daabidits’ago, Díí nṉeehíí Elías yich’į’ aṉii, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dagoshch’į’ nṉee ła’ nádilwodgo túdaabits’ǫsíí vinegar yiyi’ naiz’ąą, áídí’ tsį yaa dahyiz’ąągo Jesus bizé’zhį’ dahyída’nłtsiih. ");
INSERT INTO apwNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ła’ihíí gádaaṉii, Ntséńt’ah, bídaagonolzįįh, Elías baa higháhgo hasdábiłteeh shį. ");
INSERT INTO apwNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus nanádidilghaazhgo dabíí biyi’siziiníí be’ogoyáágo áyíílaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Áígee kįh biyi’ da’ch’okąąhíí biyi’ yuṉe’ daadintsoozíí bighą́’dí’ hayaago iłch’idláád lę́k’e; ni’ godihes’naadá’ tséé daahesdla’; ");
INSERT INTO apwNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nṉee łeyi’ nazjeedíí bá iłts’ą́’ ádaagosdzaago ínashood daanlįį n’íí łą́ą́go naadiikai. ");
INSERT INTO apwNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Áí Jesus naadiidzaahíí bikédí’go łeyi’dí’ hakaidá’ kįh dilzini gozṉilyú okaigo, nṉee łą́ą́go daabiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Silááda gonenadín binant’a’íí, ła’íí yił nakaihi Jesus daineł’íni, ni’ nagohi’naago ła’íí áígee ágodzaahíí daayiłtsąądá’ dázhǫ́ ńdaałdzid, áík’ehgo gádaaṉii, Díí da’aṉii Bik’ehgo’ihi’ṉań biYe’ nlíni ląą. ");
INSERT INTO apwNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Isdzáné łą́ą́go Gálileedí’ Jesus biké’ anákahi, bich’odaaṉiihi, aṉahdí’ nazįį daabineł’į́į́go: ");
INSERT INTO apwNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mary Mágdalene, ła’íí Mary, James hik’e Joses bą́ą́, ła’íí Zébedee bichągháshéhíí bą́ą́hi ałdó’ itah nazįį. ");
INSERT INTO apwNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","K’ad o’i’aahyú, nṉee háłdzili, Arimathéa golzeeyú gólíni, Joseph holzéhi nyáá, áń Jesus yodláni: ");
INSERT INTO apwNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Áń Pílate yich’į’ oyáágo Jesus bits’íhíí yíyókeed. Áík’ehgo Pílate áṉíígo Jesus bits’íhíí baa daach’idez’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joseph Jesus bits’íhíí baa det’ąądá’ nak’ą’łigaihi nłt’éhi yik’íyidesdizgo, ");
INSERT INTO apwNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Dabíí bitsébii’i’áń áníidéhi goz’ąą yuṉe’ nyinłtį́į́, áí tséé biyi’ yuṉe’ hayik’éhgo áyíílaahi: áídí’ tséé nchaahi yidaidenłhizdá’ onádzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Mágdalene, ła’ Maryhíí biłgo, tsébii’i’áńhíí bidáhzhį’ sikee lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Iłch’į’golṉe’íí bijįį hiskąągo okąąh yebik’ehi itisyú nadaandeehíí, Phárisees daanlíni biłgo, dała’ Pílate yaa hikai, ");
INSERT INTO apwNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Gádaabiłṉiigo, Nohwinant’a’, bínádaahiilṉiih, áí k’izé’idiłteehíí t’ah hiṉaadá’, Taagi hileehgo bijįį naadishdáh, ṉii ni’. ");
INSERT INTO apwNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Áí bighą nik’ehgo tsébii’i’áńhíí ch’í’itingee dázhǫ́ ntł’izgo áolṉe’, taagi hileehíí bijįįzhį’, doo ágát’éé dayúgo dánko bitsiłke’yu tł’é’go hikáhgo bits’í daayín’įįh, áídí’, Jesus daztsąądí’ naadiidzaa, nṉee daayiłṉiih: áík’ehgo iké’yú doo bik’ehyú ádaaṉii dahíí ntségo ádaaṉii n’íí bitisgo ádaaṉii doleeł ákoh. ");
INSERT INTO apwNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pílate gádaabiłṉii, Silááda tsébii’i’áń yiṉádaadéz’íni nohwaa siṉil: ti’i, nzhǫǫgo ntł’izgo ádaahłe’. ");
INSERT INTO apwNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Áídí’ okaigo, tsébii’i’áńhíí nzhǫǫgo ntł’izgo ádaizlaa, ła’íí áígee silááda yiṉádaadéz’įįgo ádaizlaa. ");
INSERT INTO apwNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jews daagodnlsiníí bijįį hiskąągo hayołkaałyú ínashood daagodnłsiníí bijįį, Mary Mágdalene, ła’ Maryhíí biłgo tsébii’i’áńyú daadéz’įįyú ó’áázh. ");
INSERT INTO apwNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nt’éégo adįįd ni’godes’naa: Bik’ehgo’ihi’ṉań binal’a’á yaaká’dí’ nkenyáágo, tséé daadin’ááníí yó’oyiłhizdá’ yiká’ dahnezdaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Biniizhį’ hada’didla’híí k’a’at’éé, bidiyágé zas k’ehgo dázhǫ́ łigai: ");
INSERT INTO apwNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Iṉádaadéz’íni tsídaadesyizyú daaditłid daasilįį, nṉee nanezna’híí k’ehgo ádaasdzaa. ");
INSERT INTO apwNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bik’ehgo’ihi’ṉań binal’a’á isdzáné gáyiłṉii, Doo nédaałdzid da: Jesus tsį’iłna’áhi bíheskał n’íí biká hadaanohtaago bígonsį. ");
INSERT INTO apwNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Áń doo hak’i da: naadiidzaa ni’, áṉíí n’íí k’ehgo, Yushdé’, nohweBik’ehń bits’í siné’ n’gee daadeh’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ti’i, dáháłe bitsiłke’yu Jesus daztsąądí’ naadiidzaahíí baa nagołṉi’yú doh’aash; nohwádįh Gálilee golzeeyú óyáá; ákú daahołtséh: da’aṉiigo ádishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tsébii’i’áńdí’ hwéheego dahts’isteel, nédaaldzid ndi bił daagozhǫ́ǫ́ lę́k’e; bitsiłke’yu yił nagolṉi’yú ots’iłteel. ");
INSERT INTO apwNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nt’éégo bitsiłke’yu yił nadaagolṉi’yú hi’ashgo, Jesus bideyaa, Gozhǫ́ǫ́, biłṉiigo. Ákú Jesus yiyahzhį’ hayaa adzaago yikee daayotą’dá’ daayokąąh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesus gábiłṉii, Doo nełdzid da: shik’isyú, Gálileeyú dohkáh, biłdohṉii, ákú daashiłtséh ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Isdzáné ákú hi’ashdá’ iṉádaadéz’ínihíí ła’ kįh gozṉilyú hikaigo, okąąh yebik’ehi itisyú nadaandeehi hago ágodzaahíí dawa yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Okąąh yedaabik’ehi, Jews yánazíni biłgo íła’adzaago baa nagoshchįįdí’ silááda bestso łą́ą́go bitasṉii, ");
INSERT INTO apwNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Gádaayiłṉiigo, Nṉee gádaabiłdohṉiih, Bitsiłke’yu tł’é’yú nádaabinest’įįd, da’ilwoshdá’. ");
INSERT INTO apwNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nant’án ya’ikonzįyúgo, nohwá bich’į’ yádaahiilti’go doo hago ádaanohwile’ at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Silááda bestso nádaidnné’go, da’ádaabiłdi’ṉiiyú ádaasdzaa: díí jįį ndi silááda ádaaṉii n’íí Jews bitahyú t’ah benagowaa. ");
INSERT INTO apwNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bitsiłke’yu ła’ts’ádahíí dziłyú okai, Jesus bándaagoz’ąą n’yú, Gálileeyú. ");
INSERT INTO apwNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Akú Jesus daayiłtsąądá’ daayokąąh: ndi ła’ihíí bił nadaagoki. ");
INSERT INTO apwNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesus baa nyáágo gádaabiłṉii, Yaaká’yú, ni’gosdzáń biká’gee ałdó’, dawa beshik’ehgo shaa godet’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Áík’ehgo ti’i, dahdohkáh, ił’aniyú hadaazt’i’íí dawa bił ch’ídaagonoh’aah, Bik’ehgo’ihi’ṉań nohwiTaa, hik’e biYe’, ła’íí Holy Spirit bizhi’íí biláhzhį’ baptize ádaagoł’įįgo: ");
INSERT INTO apwNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ádaanohwiłdéṉiidíí dawa bikísk’eh ádaat’eego bił ch’ídaagonoh’aah: áík’ehgo dahazhį’ nohwił nshłįį, nnágodzaayú ndi. Doleełgo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Bik’ehgo’ihi’ṉań biYe’, Jesus Christ, baa na’goṉi’íí baa gozhóni díínko begodezt’i’; ");
INSERT INTO apwNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí binaltsoos biyi’dí’ díí baa k’e’eshchįį, Shíí, Bik’ehgo’ihi’ṉań, shinal’a’á nádįhyú iłch’į’gole’ doleełíí deł’a’. ");
INSERT INTO apwNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Da’igolį́į́yú hadíńshį dilwosh, NohweBik’ehń bádįhyú iłch’į’daagohłe’, intín iłk’ídezdǫhgo bá ádaahłe’, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Áík’ehgo John da’igolį́į́yú baptize ádaagole’, nṉee yich’į’ yádaałti’go gádaayiłṉii, Nohwinchǫ’íí bits’ą́’zhį’ ádaahṉe’go baptize ádaanohwi’dolṉe’, áík’ehgo nohwinchǫ’híí bighą nohwaa nágodit’aah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judéa dahot’éhé ni’ goz’ąądí’ ła’íí Jerúsalem golzeedí’ baa náńzą́ą́, áí dawa bi’ádaat’e’ nchǫ’íí yaa nanádaagosṉi’dá’ túńlííníí Jórdan holzéhi biyi’ John baptize ádaabizlaa. ");
INSERT INTO apwNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John bidiyágé bigháń ha’i’áhíí bighaa alzaa, ikał hilchii biziz alzaa; nágonech’iidi hik’e dziłyú gosnihíí biłgo bihidáń lę́k’e; ");
INSERT INTO apwNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nṉee yich’į’ yádaałti’go gaṉíí, Shiké’dí’ ła’ shitisgo at’éhi higháh, ts’íyaa ashṉéhgo biketł’óól k’e’ish’adzhį’ ndi doo bik’eh sitį́į́ da. ");
INSERT INTO apwNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Shíhíí tú bee baptize ádaanohwishłaa: áídá’ áń Holy Spirit yee baptize ádaanohwił’įį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Áí benagowaadá’ Jesus ni’ Gálileegee Názareth holzeedí’ ch’ínyáádá’, túńlííníí, Jórdan holzéhi, biyi’ John baptize ábíílaa. ");
INSERT INTO apwNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tú biyi’dí’ hanádzaadá’ dagoshch’į’ yáá iłts’ą́’ ádzaago, Holy Spirit hawú k’ehgo bich’į’ nke’eṉíihgo yiłtsąą: ");
INSERT INTO apwNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nt’éégo yaaká’dí’go yati’ gáṉíígo yidezts’ąą, ShiYe’ shił nzhóni ńlį́į́, naa shił gozhǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dagoshch’į’ Holy Spirit nabiłaago da’igolį́į́yú obinyood. ");
INSERT INTO apwNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Satan nabíntaahgo ákú da’igolį́į́yú dizdin behiskąą; tsétahgo daagolíni biłgo; áígee Bik’ehgo’ihi’ṉań binal’a’á yaaká’dí’ daagolííníí baa hikaigo bich’odaazṉi’ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John ha’áneztįįhíí bikédí’go Jesus Gálileeyú ńyáá, Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí baa na’goṉi’íí baa gozhóni yaa yałti’go, ");
INSERT INTO apwNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Gáṉíí, Áígee baa gonyáá, Bik’ehgo’ihi’ṉań nant’aahíí biká’ nagowaa; nohwinchǫ’íí bits’ą́’zhį’ ádaahṉe’, yati’ baa gozhóni daahohdląą le’. ");
INSERT INTO apwNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus túsikaaníí Gálilee holzéhi bahyú higaałdá’, Simon bik’isn Andrew biłgo łóg behaidléhé nanestł’óli téh nádaayi’aa’go yiłtsąą: áí łóg hadaayileehíí daanlįį. ");
INSERT INTO apwNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus gádaabiłṉii, Shiké’yú doh’aash, łóg hayihileehíí k’ehgo nṉee shá nádaahohłáhgo ánohwishłe’. ");
INSERT INTO apwNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Áík’ehgo dagoshch’į’ łóg behaidlehé nanestł’ólihíí da’áígee ndaistsoozdá’ Jesus yiká’ dahn’aazh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Áídí’ dahnádiidzaago James, Zébedee biye’, hik’e bik’isn John biłgo yiłtsąą, áí tsina’eełíí yiyi’ naháztąą, nanestł’ólihíí nádaiłkadgo. ");
INSERT INTO apwNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dagoshch’į’, Yushdé’, biłṉii: áík’ehgo bitaa, Zébedee, hik’e bánada’iziidíí biłgo da’akú tsina’eełíí yiyi’ naháztąądá’ yits’ą́’ dahn’aazh, Jesus biké’. ");
INSERT INTO apwNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Áídí’ Capérnaum golzeeyú okai; dagoshch’į’ Jews daagodnłsiníí bijįį ha’ánáłséh goz’ąą yuṉe’ ha’ayáágo iłch’ígó’aah lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Áígee iłch’ígót’aahíí yaa bił díyadaagot’ee: yebik’ehíí k’ehgo yił ch’ígó’aahíí bighą, doo begoz’aaníí ye’ik’eda’iłchíhi ádaat’eehíí k’ehgo da. ");
INSERT INTO apwNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jews ha’ánáłséh goz’ąą yuṉe’ nṉee ła’ spirit nchǫ’i biyi’ golínihi sidaa lę́k’e; áń nádidilghaazhgo, ");
INSERT INTO apwNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Gáṉíí, Doo nohwaa nanṉaa da; hago lą́ą́ át’éégo nohwich’į’ goń’aahgo ánt’įį, Jesus, Názarethdí’ nanṉáhi? Ya’ da’ílíí nohwiłchííyú ńyaa née? Shíí nígonsį, hadíń ánt’įįhíí, Bik’ehgo’ihi’ṉań bits’ą́’dí’go Dilzįhgo Ńlíni. ");
INSERT INTO apwNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus nłdzilgo hadziigo gáyiłṉii, Handziih hela’, an biyi’dí’ hanṉáh. ");
INSERT INTO apwNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Áík’ehgo spirit nchǫ’ihíí nṉee nádinigisdá’ ádįįd nádidilghaazhgo biyi’dí’ halwod. ");
INSERT INTO apwNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nṉee dawa bił díyadaagot’eego nałídaadilkid gádaaṉiigo, Díí nt’é lą́hi? Áníi zhą́ iłch’ígó’aahi ląą. Yebik’ehgo spirits daanchǫ’íí yich’į’ hadziigo ndi daabidits’ag. ");
INSERT INTO apwNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dagoshch’į’ Gálilee golzeehíí dahot’éhé nłt’éégo baa ch’iṉii didezdlaad lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesus, James hik’e John biłgo ha’ánázéhdí’ ch’ínákaigo Simon hik’e Andrew bigową yuṉe’ ha’ákai. ");
INSERT INTO apwNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ákóṉe’ Simon bi’aahíí bą́ą́ nezgaigo sitįį; áík’ehgo dagoshch’į’ Jesus yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Baa nyáádá’ bigan yiłtsoodgo hadag áyíílaa; dagoshch’į’ nezgai n’íí bits’ą́’ gonyáá, áídí’ nádiidzaago yá da’dezné’. ");
INSERT INTO apwNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","O’i’ą́ą́zhį’ godeyaago kah iłtah at’éhi yaa nakaihíí dawa, ła’íí ch’iidn isnáh ádaabiłsiníí Jesus bich’į’yú bił nch’eheskai. ");
INSERT INTO apwNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Áí kįh gozṉilgee daagolííníí dawa dadáńgee baa íła’adzaa. ");
INSERT INTO apwNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Áígee kah iłtah at’éhi yaa nakaihíí łą́ą́go nádaayilzii, ła’íí ch’iidn łą́ą́go haineheyood; ch’iidnhíí bídaagołsįhíí bighą Jesus, Hadaahdziih hela’, daabiłṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","T’ahbįyú doo hwahá got’įįh dadá’ Jesus nádiidzaago ch’ínyáá, doo hadíń naghaa dayú óyáá, ákú oskąąd. ");
INSERT INTO apwNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon hik’e yił nakaihíí biłgo biké’yú okai. ");
INSERT INTO apwNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Baa hikaigo gádaabiłṉii, Nṉee dawa hadaanintaah. ");
INSERT INTO apwNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Áík’ehgo Jesus gáṉíí, Noo’, łahyúgo kįh nagozṉilyú náádokáh, ákú nṉee bich’į’ yánádaahoshti’; díí bighą niyáhi. ");
INSERT INTO apwNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Áídí’ Gálilee dahot’éhé biyi’yú Jews ha’ánáłséh nagozṉil yuṉe’ nṉee yich’į’ yałti’go naghaa, ła’íí ch’iidn haineheyood lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nṉee łóód doo ínádįh dahi, leprosy holzéhi, yaa nagháhi Jesus yich’į’ hilzhiizhgo náyokąąh, gáṉíígo, Nashíńlziihíí bik’eh síńtįįgo nígonsį, háńt’įįyúgo náshíńlziih. ");
INSERT INTO apwNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Áík’ehgo nṉeehíí Jesus yaa ch’oba’go yich’į’ dahdidilṉiidí’ yee delṉiihgo, Hasht’į́į́; nándziih, yiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Áí yiłnṉiidá’ dagoshch’į’ łóód n’íí ínásdįįdgo nṉeehíí nádzii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesus bich’į’ hadziidá’ obił’a’; ");
INSERT INTO apwNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Gábiłṉiigo, Hadíń dánko bił nagolṉí’ hela’: ti’i, okąąh yebik’ehi bich’į’ ch’í’ṉah ádńdle’go, Moses ngon’ą́ą́ lę́k’ehíí k’ehgo hanánidelzaahíí bighą Bik’ehgo’ihi’ṉań dant’éhéta baa nné’, áík’ehgo nándziihíí nṉee yídaagołsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Áídá’ da’ádzaayú yaa nagolṉi’go deyaa, dahot’éhé ch’iṉii didezdlaad, áí bighą Jesus doo dayúweh kįh gozṉilyú ch’í’ṉah aanádaał da, da’igolį́į́yú zhą́ naghaa: áídá’ iłch’į’dí’ nṉee baa náńłsą́ą́ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Áídí’ da’kwíí iskąągo Jesus Capérnaum golzeeyú nádzá; áígee gowąyú sidaa, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dagoshch’į’ nṉee łą́ą́go baa náńłsą́ą́, dázhǫ́ doo hagee nágost’ąą da, dáádítį́h bahyú ndi: áígee yati’ nłt’éhi yaa yałti’ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Áígee nṉee ła’ baa hikai, dį́į́’i hilt’eego nṉee di’ili baa daiskąągo, ");
INSERT INTO apwNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ch’iląądhíí bighą Jesus doo bit’ah ch’idowáhgo da, áík’ehgo kįh biká’híí yó’adaizṉil, Jesus bik’ehgee: áí ąął ch’í’i’áńgo ádaizlaadí’ di’ilihíí yiká’ sitiiníí bee nkedaiztįį. ");
INSERT INTO apwNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Daabi’odlą’ Jesus yígółsįįdá’ di’ilihíí gáyiłṉii, Shiye’, ninchǫ’híí bighą dák’ad naa nágodet’aah. ");
INSERT INTO apwNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Begoz’aaníí ye’ik’eda’iłchíhi ła’ naháztąą, dábiyi’yú na’ídaadiłkidgo gádaaṉii, ");
INSERT INTO apwNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Hant’é bighą díí nṉee Bik’ehgo’ihi’ṉań ádil’įįgo aṉíí ląą? Hadíń lą́ konchǫ’híí bighą kaa nágode’aah? Bik’ehgo’ihi’ṉań zhą́ go’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na’ídaadiłkidíí Jesus dagoshch’į’ biyi’siziiníí bee yígołsįįdgo gáyiłṉii, Nt’é bighą na’ídaadołkid? ");
INSERT INTO apwNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Hadíihíí doo nyeego di’ilihíí áłch’iṉiih da, Ninchǫ’híí bighą naa nágodet’aah; dagohíí, Nádndáh, biká’ síńtiiníí dahnádnné’go dahnṉáh? ");
INSERT INTO apwNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ni’gosdzáń biká’ nṉee binchǫ’híí bighą baa nágodet’aahíí shíí, nṉee k’ehgo Niyááhíí, beshik’ehgo bídaagonołsį doleełhíí bighą, (nṉee di’ili sitiiníí gáyiłnṉiid,) ");
INSERT INTO apwNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nádndáhgo biká’ síńtiiníí dahnádnné’go gowąyú nádńdáh, niłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dagoshch’į’ nádiidzaago yiká’ sitįį n’íí dahnáyiné’go dawa biṉááł ch’ínyáá; áík’ehgo nṉee dawa bił díyadaagot’eego Bik’ehgo’ihi’ṉań ya’ihédaanzįgo gádaaṉii, Doohwahá áík’ehgo daahiiltséhi da. ");
INSERT INTO apwNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Áídí’ Jesus túsikaaníí bahyú ch’ínánádzaadá’ nṉee baa nanáńłsą́ą́, áígee yił ch’ídaagoz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jesus higaałgo Alphéus biye’, Levi holzéhi, tax nanáhi’ṉiłígee sidaago yiłtsąądá’ gáyiłṉii, Shiké’ dahnṉáh. Áík’ehgo nádiidzaago biké’ dahiyaa. ");
INSERT INTO apwNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Áídí’ Levi bigową yuṉe’ Jesus iyąągo nezdaago, tax bich’į’ nadaahi’ṉiiłíí ła’íí nṉee doo bik’ehyú ádaat’ee dahíí łą́ą́go Jesus hik’e bitsiłke’yu biłgo itah da’iyąągo dahdinezbįh; nṉee gádaat’eehíí łą́ą́go Jesus biké’ anáłseeł lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanlíni biłgo tax bich’į’ nadaahi’ṉiiłíí ła’íí nṉee doo bik’ehyú ádaat’ee dahíí Jesus yił da’iyąągo daayiłtsąądá’ bitsiłke’yu gádaayiłṉii, Nt’é bighą tax bich’į’ nadaahi’ṉiiłíí ła’íí nṉee doo bik’ehyú ádaat’ee dahíí Jesus yił da’iyąą? ");
INSERT INTO apwNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus áí yidezts’ąądá’ gádaabiłṉii, Doo hago’ádaat’ee dahíí izee nant’án doo yaa nakáh bik’eh da, daanṉiihíí zhą́: shíí nṉee doo bik’ehyú ádaat’ee dahíí, Nohwinchǫ’íí bits’ą́’zhį’ ádaahṉe’, biłdishṉiiyú níyáá, áídá’ nṉee dábik’ehyú ádaat’eehíí doo ágáłdishṉiiyú níyáá da. ");
INSERT INTO apwNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","John bitsiłke’yu hik’e Pharisees daanlíni bitsiłke’yu dáshiṉá’ da’okąąh ni’: áík’ehgo Jesus yaa hikaigo gáṉíí, Nt’é bighą John bitsiłke’yu hik’e Phárisees bitsiłke’yu dáshiṉá’ da’okąąh, áídá’ ni nitsiłke’yu doo dáshiṉá’ da’okąąh da? ");
INSERT INTO apwNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus gádaabiłṉii, Ya’ ni’i’ṉéhgee nṉee íła’ádaat’eehíí nṉee niiṉéhíí yił nakaiyúgo dáshiṉá’ da’okąąh née? Dah, nṉee niiṉéhíí yił nakaiyúgo doo dáshiṉá’ da’okąąh at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Dahagee nṉee niiṉéhíí bits’ą́’ nádilteeh ndi at’éé, áígee dáshiṉá’ da’okąąh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ko’íí dénchǫ’éhíí doo nak’ą’ áníidéhíí bee ch’idi’aah da; ágách’idzaayúgo áníidéhíí iłhanigháhgo dayúwehégo onanádlaad. ");
INSERT INTO apwNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ła’íí wine áníi alzaahíí ikágé wine benałtiníí dénchǫ’éhíí doo biyi’ tádaach’iṉił da; ágách’idzaayúgo wine áníi alzaa’ihíí ikágé yidiłdohgo na’ṉil, áík’ehgo winehíí ąął ha’ijool, ła’íí ikágéhíí kots’ą́’ yiłchǫǫh: áídá’ wine áníi alzaa’ihíí wine benałtiníí áníidéhíí zhą́ biyi’ tádaach’iṉił. ");
INSERT INTO apwNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Łah Jews daagodnłsinii bijįį Jesus tł’oh nagháí hentííníí yiyi’yú higaał; bitsiłke’yu yił hikaahgo tł’oh nagháí binest’ą’ nadaayiṉiił nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Phárisees daanlíni Jesus gádaayiłṉii, Díń’įį, nt’é bighą godilziníí bijįį doo baa nach’ighaa dahíí nitsiłke’yu yaa nakai? ");
INSERT INTO apwNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesus gádaabiłṉii, Ya’ David hik’e yił nakaihíí biłgo idáń ádįhgo shiṉá’ daasilįįgo, hago ádaasdzaa láń shįhíí doo hwahá baa da’ohshiih da née? ");
INSERT INTO apwNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abíathar okąąh yebik’ehi da’tiséyú sitįįdá’ Bik’ehgo’ihi’ṉań daach’okąąh goz’ąą yuṉe’ ha’ayáágo, báń Bik’ehgo’ihi’ṉań ye’okąąhgo baa hi’né’go nii’né’ n’íí náidnné’go yiyąą, ła’íí yił nakaihíí ałdó’ ła’ yá’ńné’ lę́k’e; áí báńhíí okąąh yedaabik’ehi zhą́ daayiyąągo goz’ánihi. ");
INSERT INTO apwNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesus gádaabiłṉii, Godilziníí bijįį nṉee bá alzaa, doo nṉee godilziníí bijįį bá alzaa da: ");
INSERT INTO apwNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Áí bighą shíí, nṉee k’ehgo Niyááhíí, godilziníí bijįį ndi beshik’eh. ");
INSERT INTO apwNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus Jews ha’ánáłséh goz’ąą yuṉe’ ha’anánádzaago nṉee bigan dała’ázhiṉéé binawod ásdįįdi ákóṉe’ itah sidaa. ");
INSERT INTO apwNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Áík’ehgo Jesus daabich’inł’į́į́, godilziníí bijįį áí nṉeehíí náyilziih shį daabich’o’ṉíígo; ágádzaayúgo dant’éhéta bee yaa dahdaago’aahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus nṉee bigan binawod ásdįįdi, Kodé’ hizįį, yiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Áídí’ nṉee daabineł’ííníí gádaayiłṉii, Ya’ godilziníí bijįį nłt’éégo ách’ít’įįgo goz’ąą née, dagohíí nchǫ’i bee ách’ít’įįgo née? Ya’ nṉee hasdách’iłteehgo née, dagohíí ch’iziłheego née? Áídá’ doo nt’é daaṉii da. ");
INSERT INTO apwNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bijíí daantł’izíí bighą Jesus doo bił gozhǫ́ǫ́ dago déhashkeego nṉee yitah déz’įįdá’ nṉee bigan binawod ásdįįdi, Yushdé’ dahdinlṉíh, yiłṉii. Áík’ehgo bich’į’ dahdidilṉiigo bigan nádzii, łahzhiṉééhíí ga’at’éé násdlį́į́. ");
INSERT INTO apwNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Áídí’ Phárisees daanlíni ch’ékaigo dagoshch’į’ Hérod yił daagot’íni biłgo hagot’éégo Jesus daayiziłheehíí yee ndaagoshchįį. ");
INSERT INTO apwNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus bitsiłke’yu biłgo túsikąąyú dahiskai: nṉee łą́ą́go Gálileedí’ ła’íí Judéadí’ biké’ onałsą́ą́, ");
INSERT INTO apwNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerúsalemdí’ ałdó’, ła’íí Iduméadí’, Jórdan túńlííníí hanaadí’, ła’íí Tyre hik’e Sidon biṉaadyúdí’, ízisgo ánát’įįłíí ya’ikodaanzįįgo baa náńłsą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Akú nṉee łą́ą́híí bighą Jesus bitsiłke’yu gádaayiłṉii, Nṉee doo daashiłjizh da doleełgo t’ahkodá’ tsina’eeł ałts’ísę́hi kozhį’ shá nnoł’eeł. ");
INSERT INTO apwNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nṉee łą́ą́go náilzii; áík’ehgo kah yaa nakaihíí dawa bee denshchíd daanzįgo bik’izhį’ daałishjizh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Spirits daanchǫ’íí dahagee daabo’įįgee biyahzhį’ hayaa ádaadzaago nádaadidilghaazh, Ni, Bik’ehgo’ihi’ṉań biYe’ nlíni ánt’įį, daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ch’ídaashinoh’aah hela’, daayiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Áídí’ Jesus wą́’zhį’ hayaadá’ yił nakai doleełíí, Yushdé’, daayiłnṉiid: áík’ehgo baa hikai lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bitsiłke’yu doleełíí nakits’ádah hayiṉil, yati’ baa gozhóni yaa yádaałti’yú daidoł’aałgo, ");
INSERT INTO apwNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Iłtah at’éégo daanṉiihíí nádaayilziihgo, ch’iidn ałdó’ hadainihiyóódgo binawod baa daadest’ąą: ");
INSERT INTO apwNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Simon holzéhi Peter ałdó’ yizhi’ yá áyíílaahi; ");
INSERT INTO apwNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zébedee biye’, James holzéhi hik’e bik’isn John biłgo; áí Boanérges yizhi’ yá ádaayiizlaa, i’ṉiihíí k’a’at’éégo golzeego ágolzee: ");
INSERT INTO apwNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Barthólemew, Matthew, Thomas, Alphéus biye’ James holzéhi, Tháddeus, Símon, Cánaanite nlíni, ");
INSERT INTO apwNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ła’íí Judas Iscáriot, ch’íbido’aałíí: áí hayiṉildá’ kįh yuṉe’ ha’akai lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Áígee nṉee dázhǫ́ łą́ą́go íła’ánánádzaa, áík’ehgo Jesus hik’e bitsiłke’yu doo hagot’éégo ndi da’iyąą da. ");
INSERT INTO apwNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bik’íí ya’ikodaanzįįdá’ biká okai; Biini’ édįh ląą, daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Begoz’aaníí ye’ik’eda’iłchíhi Jerúsalemdí’ hikaihíí gádaaṉii, Ch’iidn binant’a’, Beélzebub holzéhi, biyi’ sizįį lą́go, áń binawodíí bee nṉee biyi’dí’ ch’iidn hainihiyood, daabiłṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Áídí’ Jesus begoz’aaníí ye’ik’eda’iłchíhi, Yushdé’, daayiłṉiigo, na’goṉi’íí bee bił ch’ígó’aahgo gáṉíí, Hagot’éégo Satan biyi’dí’ dabíí hádi’nidzood doleeł? ");
INSERT INTO apwNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nṉee dałaháyú binant’a’ golííníí dabíí iłch’į’ nanádaagonłkaadyúgo doo aṉahyú bengonowáh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dała’ naháztaaníí dabíí iłk’ídahnájahyúgo doo aṉahyú bengonowáh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Áík’ehgo Satan dabíí ích’į’ naná’idziidgo ádaagodet’ąąyúgo doo aṉahyú bengonowáh át’éé da, daazhógo bengoṉáh. ");
INSERT INTO apwNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Doo hadíń nṉee nalwodi bigową yuṉe’ ha’agháhgo dawahá bíyééhíí yino’į́įh at’éé da, ntsé nṉee nalwodíí łíhiłtł’ǫǫyúgo zhą́; áídá’ dawahá bíyééhíí yits’ą́’ yin’įįh. ");
INSERT INTO apwNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Da’aṉiigo gádaanohwiłdishṉii, Nṉee binchǫ’íí dawa baa nágodit’aah doleeł, Bik’ehgo’ihi’ṉań nchǫ’go baa yách’iłti’íí ndi ałdó’: ");
INSERT INTO apwNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Áídá’ Holy Spirit dénchǫ’go baa yách’iłti’yúgohíí doo kaa nágodinot’áah at’éé da, áídá’ dahazhį’ bił ch’ígodeehíí bee bá goz’ąą: ");
INSERT INTO apwNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Begoz’aaníí ye’ik’eda’iłchíhi, Ch’iidn biyi’ golį́į́ lą́ą́, daabiłṉiihíí bighą Jesus díí k’ehgo yałti’ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesus bik’isyú bimaa biłgo akú hikai, dadáńyú nadaazį’dá’ bich’į’ oda’is’a’, Yushdé’, daabiłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nṉee łą́ą́go biṉaayú naháztaaníí gádaabiłṉii, Nimaa ła’íí nik’isyú dadáńyú nazįį, níka daantaahgo. ");
INSERT INTO apwNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Hadíń shimaa, hadíń shik’isyú? biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jesus nṉee biṉaayú naháztaaníí yitah déz’įįdá’ gáṉíí, Kúnko shimaa ła’íí shik’isyú. ");
INSERT INTO apwNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dahadíń Bik’ehgo’ihi’ṉań dáhát’į́į́yú ánát’įįłíí, shik’isn dagohíí shilah ła’íí shimaa at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus túsikaaníí bahgee iłch’ígó’aah nkenágodidzaa: áígee nṉee łą́ą́go baa náńłsą́ą́, áík’ehgo tsina’eełíí yihiyaago dahnezdaa; áídá’ nṉeehíí tábąąyú íła’adzaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Áígee na’goṉi’íí yee łą́ą́go yił ch’ígó’aah gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ídaayesółts’ąą; k’edileehíí yił ke’go k’edileeyú óyáá, ");
INSERT INTO apwNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","K’edileegee k’edilzíí ła’ intín bahyú nanehezdee, áík’ehgo dlǫ́’ íła’adzaago ąął nádaihezlaa. ");
INSERT INTO apwNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ła’ k’edilzíí tsétahyú nanehezdee, ákú łeezh doo dázhǫ́ łą́ą́yú da; łeezh da’ayą́háhíí bighą dagoshch’į’ hadaazhjeed: ");
INSERT INTO apwNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Áídá’ ya’áí hanadáhgee dilid; bikeghad doo yúyahyú nel’ąą dahíí bighą nádaahesgą. ");
INSERT INTO apwNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ła’ihíí hosh bitahyú nanehezdee, áík’ehgo hoshihíí igháńłsąągo nadaistseedgo binest’ą’ da’ádįh. ");
INSERT INTO apwNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ła’ k’edilzíí łeezh nłt’ééyú nanehezdee, áí zhą́ hadaazhjeedí’ nchaa daasilįįgo nest’áń áyíílaa, ła’ tádin, ła’íí gostądin, ła’íí dała’á gonenadín bitisyú ánálzaa. ");
INSERT INTO apwNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hadíń bijeyi’ golííníí íyésts’ąą le’, ṉii, Jesus. ");
INSERT INTO apwNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesus dasahndi nṉee ła’ t’ah biṉaayú nadaazį’íí bitsiłke’yu biłgo nabídaadiłkidgo gádaabiłṉii, Iłch’ígót’aahgo na’goṉi’íí bee nohwił nadaagosíńłṉi’íí nt’é nṉiigo ánṉii? ");
INSERT INTO apwNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Áík’ehgo gáyiłṉii, Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí doo bígózį da n’íí nohwíí bídaagonołsįįhgo nohwaa daagodest’ąą: áídá’ doo néé zhiṉéé daanlįį dahíí iłch’ígót’aahgo na’goṉi’íí zhą́ bee bił na’goṉi’: ");
INSERT INTO apwNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Áík’ehgo dédaineł’įį ndi doo daayo’įį da doleeł; dédaidits’ag ndi doo bił ídaagozį da doleeł; doo ágát’éé dayúgo binchǫ’íí yits’ą́ t’ąązhį’ nakáhgo binchǫ’híí bighą baa nágodit’aah doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ya’ iłch’ígót’aahgo nohwił nagosisṉi’ n’íí doo nohwił ídaagozį da née? Áídá’ hagot’éégo iłch’ígót’aahgo nada’goṉi’íí dawa nohwił ídaagozį doleeł? ṉii, Jesus. ");
INSERT INTO apwNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","K’edileehíí Bik’ehgo’ihi’ṉań biyati’ k’eidilee. ");
INSERT INTO apwNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","K’edilzíí intín bahyú nanehezdee n’íí áí nṉee yati’ biyi’ k’edolzaahíí ádaat’ee, áídá’ yati’ dédaidits’agdá’ Satan baa nyaago daabijíí yuṉe’ yati’ k’edolzaa n’íí bits’ą́’ hayiné’. ");
INSERT INTO apwNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Da’ágánánát’éégo tsétahyú nanehezdee n’íí yati’ daidits’ago dagoshch’į’ bił daagozhǫ́ǫ́go nádaidnné’hi; ");
INSERT INTO apwNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Áídá’ daabiyi’yú bikeghad doo yúyahyú nel’ąą dago dá’aṉahzhį’ begodigháh; áídá’ yati’híí bighą nagontł’ogíí bee, dagohíí nṉee daabich’ołaahíí bighą biniigonłt’ééhíí begowáhgee dagoshch’į’ t’ąązhį’ nanánihidéh. ");
INSERT INTO apwNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hosh bitahyú nanehezdee n’íí yati’ daidits’ag, ");
INSERT INTO apwNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Áídá’ ni’gosdzáń biká’zhį’ nabi’dintł’ogíí, hágołdzilgohíí k’izé’idiłteehíí, ła’íí dawahá biká hágot’iiníí bijíí biyi’ bitis silįįgo, hosh igháńłsą́ą́go yati’ k’edolzaa n’íí naistseed, áík’ehgo doo binest’ą’ goleeh da. ");
INSERT INTO apwNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Łeezh nłt’ééyú nanehezdee n’íí yati’ daidits’ago nádaagodin’ąą, áík’ehgo nest’áń ánádail’įįh, ła’ tádin, ła’íí gostądin, ła’íí dała’á gonenadín bitisyú ánádail’įįh. ");
INSERT INTO apwNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus gánádaayił’ṉii, Ik’ah kǫ’íí ch’otį́į́łgo táts’aa bił hayaa nch’í’áah née? Kástíné yitł’ááhyú nch’í’áah née? Ik’ah kǫ’íí biká’ dahnásiłt’áhé biká’ dahch’i’aahgohi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dawahá nanl’į’ n’íí ch’í’ṉah ádolṉiił; dawahá doo hit’įį da n’íí bígózįhgo ádolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hadíń bijeyi’ golííníí íyésts’ąą ");
INSERT INTO apwNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Da’dohts’agíí nłt’éégo ídaayesółts’ąą. Dáhołąągo kaa daasohné’ láńshį n’íí k’ehgo da’ágáhołąągo nohwaa nádo’né’; ła’íí nohwíí daadohts’agíí dayúweh bitisyú ínágodáhgo nohwaa nádo’né’, biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Dahadíń íyésts’ąągo ígoł’aahíí, bigoyą’íí itisgo baa nádo’né’; áídá’ dahadíń doo íyésts’ąą dahíí ayą́hágo íyésts’ąą n’íí ndi bits’ą́’ da’ílíí nádodleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus gáṉíí, Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí díí k’ehgo at’éé: ła’ nṉee k’edilzíí yił ke’go k’edilee; ");
INSERT INTO apwNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ánágoldohgo tł’é’gee iłhoshdá’ t’ahbįgo nádidáhdá’ k’ednláá n’íí hadaazhjeedí’ ńdaandésąą, hagot’éégo shįhíí doo yígółsį da ndi. ");
INSERT INTO apwNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ni’ dabíí inest’ą’ yińdíłsé, bit’ąą ntsé hadaajah, áígeehíí bilatáhé daagoleeh, áídí’ binest’ą’ nłt’éégo nt’į́. ");
INSERT INTO apwNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nłt’éégo nest’ąągee dagoshch’į’ tł’oh bená’itłíshé bee higeesh nkegonigháh, da’nest’ąągee ngonyááhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus gánádi’ṉii, Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí hant’é bił łíshhah ndleego baa nadaagohiilṉi’? Nt’éshą’ iłch’ígót’aahgo na’goṉi’íí baa nadaagohiilṉi’? ");
INSERT INTO apwNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ch’il mustard holzéhi biyigéhíí k’ehgo at’éé; áík’edilzeegee k’edilzíí dawa bitahgee bízhą́ ałts’ísę́hihi at’éé: ");
INSERT INTO apwNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Áídá’ k’edolzaadá’ hadag nołsééł, áídí’ ch’il dawa bitisgo at’éhi hileeh, bits’ádaaz’aahíí nchaa hileeh, áík’ehgo dlǫ́’ yúdahyú nada’iṉiihíí bit’oh ádaagole’, bichagosh’ohyú. ");
INSERT INTO apwNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iłch’ígót’aahgo nada’goṉi’íí ágádaat’eehíí łą́ą́go Jesus Bik’ehgo’ihi’ṉań biyati’ bee bił nagosṉi’ lę́k’e, bił ídaagozįhíí bik’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dá’iłch’ígót’aahgo nada’goṉi’íí zhą́ bee bich’į’ yałti’ lę́k’e: áídá’ dasahndi bitsiłke’yu yił nadaaháztąąyúgo, dawahá bił ch’í’ṉah áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Da’áí bijįį o’i’ą́ą́yú Jesus bitsiłke’yu gádaayiłṉii, Noo’, hanaazhį’ nohwił nada’do’éeł. ");
INSERT INTO apwNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nṉee baa náńłsą́ą́ n’íí nádihołséh daayiłnṉiidá’, Jesus t’ah tsina’eełíí yiyi’ dahsdaago bitsiłke’yu bił oda’iz’éél. Tsina’eeł ádaałts’ísę́hi ałdó’ ba’ashhah dahi’eeł lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nt’éégo yat’éégo deyolgo tsina’eełíí tú nádidáhíí beh nádilk’oołgo bee ha’dezbįh. ");
INSERT INTO apwNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Áídá’ tsina’eełi biyi’ iké’dí’ tsi’aał biká’ Jesus iłhosh: bitsiłke’yu ch’ínádaabisidgo gádaabiłṉii, Iłch’ígó’aahíí, goyéégo nohwich’į’ godegháhíí doo nił hago’at’éé da née? ");
INSERT INTO apwNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Áík’ehgo ch’ínádzidgo nyolhíí yich’į’ hadzii, áídí’ túsikaaníí gáyiłṉii, Dákohégo, nkegohin’ą́ą́ le’. Áík’ehgo oyólgo nkenágoheltǫ’ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Áídí’ Jesus gádaabiłṉii, Hant’é lą́ bighą ńdaałdzid? Hant’é bighą doo Bik’ehgo’ihi’ṉań bada’ohłíí da? ");
INSERT INTO apwNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Áík’ehgo bitsiłke’yu dázhǫ́ tsídaadesyizgo gádaałiłdi’ṉii, Nṉee lą́ą́ daat’éhi díí, nyolhíí ła’íí tú ndi da’áyiłṉiiyú ádaat’įį. ");
INSERT INTO apwNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hanaayú Gadarénes daagolį́į́yú bił nada’diz’eel. ");
INSERT INTO apwNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus tsina’eełíí yiyi’dí’ háyáágo nṉee łena’ṉiłíí goz’ąądí’ nṉee spirit nchǫ’íí biyi’ golíni baa nyáá, ");
INSERT INTO apwNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Áń nṉee łena’ṉiłíí goz’ąąyú golínihi; doo hadíń łínábółtł’óh adzaa da, bésh hishbizhíí bee ndi: ");
INSERT INTO apwNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Goląąn bésh hishbizhíí ła’íí kokee bee łínádaach’iłtł’óhíí bee łíbi’destł’ǫǫ ndi bésh hishbizhíí iłk’ínáyidzįįs, ła’íí bikee łínádaach’iłtł’óhíí nyihidzįįz lę́k’e: doo hadíń nzhǫǫgo ábóle’ ágódzaa da. ");
INSERT INTO apwNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tł’é’gee ła’íí jįįgee dziłyú nṉee łena’ṉiłíí bitahyú dádilwoshgo zhą́ naghaa, tséé yee n’ídilgeeshgo. ");
INSERT INTO apwNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Áídá’ dáńzaadí’ Jesus yiłtsąądá’ yich’į’ nádilwodgo yiyahzhį’ hayaa adzaago, ");
INSERT INTO apwNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Yat’éégo gáṉíí, Hago ląą áshíle’go ánt’įį, Jesus, da’tiséyú át’éhi biYe’ ńlíni? Shiniigodnléh hela’, Bik’ehgo’ihi’ṉań binadzahgee nánoshkąąh. ");
INSERT INTO apwNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesus spirit nchǫ’íí iłk’idá’ gáyiłnṉiid, An biyi’dí’ hanṉáh, spirit nchǫ’íí ńlíni. ");
INSERT INTO apwNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus nabídiłkidgo, Hant’é honlzéé? biłṉii. Shíí Łáni honszee: hiidląąhíí bighą, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Díí goz’ąądí’ ch’ídaanohwinyóód hela’, ṉiigo náyokąąh. ");
INSERT INTO apwNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Áígee dził biṉahzhį’yú góchi da’ayąągo nanałsé’ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Áík’ehgo ch’iidn dawa nádaayokąąh, Góchi biyi’ onohwinyóód, áí beh náhiilzéh, daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Áík’ehgo Jesus baa goden’ą́ą́. Spirits daanchǫ’íí nṉeehíí yiyi’dí’ hanałsą́ą́dá’ góchi yiyi’ onałsą́ą́; áídí’ góchi n’íí (nakidn doo náhóltagyú shį,) hayaa nádnkįįgo túsikáni yeh nałsą́ą́go tú yił daadesdzii. ");
INSERT INTO apwNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Góchi yiṉádaadéz’įį n’íí nádnkįįgo kįh gozṉilyú ła’íí biṉaayú gotahyú yaa nadaagosṉi’. Nṉee yił nadaagosṉi’íí áí ágodzaahíí daineł’į́į́yú oheskai lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus yaa hikaidá’ nṉee ch’iidn isná ábiłsį n’íí, spirits daanchǫ’i łáni biyi’ golį́į́ n’íí, bidiyágé gólį́į́go, biini’ ndi golį́į́go sidaago daayiłtsąą lę́k’e; áík’ehgo ńdaaldzid. ");
INSERT INTO apwNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nṉee biṉááł ágodzaahíí hagot’éégo nṉee ch’iidn isná ábiłsį n’íí biyi’dí’ Jesus ch’iidn hainiyoodíí, ła’íí góchi hago ádaasdzaahíí yaa nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Áík’ehgo, Nohwini’dí’ ch’ínṉáh, yiłṉiigo náyokąąh nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesus tsina’eełíí yeh nádzaago nṉee ch’iidn isná ábiłsį n’íí nábokąąhgo, Nił nádósht’aash, ṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Áídá’ Jesus, Dah, biłṉii, gowąyú nádńdáhgo nit’eké Bik’ehgo’ihi’ṉań dázhǫ́ ná áyíílaahíí baa bił nadaagolṉí’, ła’íí hagot’éégo naa ch’oba’íí. ");
INSERT INTO apwNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Áídí’ dahiyaago Decápolis biṉaayú Jesus bá áyíílaahíí yaa nagolṉi’ nkegonyaa; áík’ehgo nṉee dawa bił díyadaagot’ee lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus hanaayú bił naná’dez’eeldá’ ákú nṉee łą́ą́go baa náńłsą́ą́; áń tábąąyú sizįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Áígee Jews ha’ánáłséhíí yebik’ehi ła’ Jáirus holzéhi nyáá; áń Jesus yiłtsąądá’ yiyahzhį’ hayaa adzaago, ");
INSERT INTO apwNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Náyokąąhgo gáṉíí, Shitsi’ ałts’ísę́hi k’azhą́ datsaah: noo’, nłt’éé nádleeh doleełgo bik’enlṉíh; áík’ehgo hiṉaa doo. ");
INSERT INTO apwNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Áík’ehgo Jesua yił onát’aazh; higaałgo nṉee łą́ą́go biké’ nałseełgo daabiłjizh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Áígee isdzán dił bigháńlį́į́go nakits’ádah bił łegodzaa, ");
INSERT INTO apwNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Izee nant’án łáń ch’éh ádaabił’įįd, ła’íí bizhaali dawa nayihiṉiił ndi doo nzhǫǫ nádleeh da, áídá’ da’tiségo adzaa. ");
INSERT INTO apwNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesus ya’ikonzįįgo biṉe’dí’ ch’iląągee ninyaago bi’íí yedelṉiih lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ídił yalti’go gáṉíí, Bi’íí zhą́ ndi bedenshṉiihyúgo, nłt’éé náshdleeh. ");
INSERT INTO apwNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Dagoshch’į’ dił bigháńlį́į́ n’íí ésdįįd; áík’ehgo kah yaa naghaa n’íí nábi’dilziigo yígołsįįd lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesus, binawodíí bits’ą́’ hagoshį adzaago yígołsįįdgo, dagoshch’į’ nṉee biké’ náńłsą́ą́híí yich’į’ łedidzaago gáṉíí, Hadíń shi’íí yedelṉiih? ");
INSERT INTO apwNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bitsiłke’yu gádaabiłṉii, Nṉee niṉaayú daałiłjizhgo hí’į́į́; nt’é bighą, Hadíń shedelṉiih, nṉii áídá’? ");
INSERT INTO apwNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hadíń át’ííníí yígołsįįhgo, nṉee yitah dez’įį. ");
INSERT INTO apwNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Isdzánhíí ábi’dilzaahíí yígołsįįdgo néldzidgo ditłidgo Jesus yiyahzhį’ hayaa adzaago, adzaahíí da’aṉiigo yaa yił nagosṉi’ ");
INSERT INTO apwNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus gáyiłṉii, Shilah, ni’odlą’íí nłt’éégo ánániidlaa; iłch’į’gont’éégo nadááł, kah baa nanṉaa n’íí nándzii. ");
INSERT INTO apwNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus áígee t’ah yałti’dá’ Jews ha’ánáłséhíí yebik’ehi bigowądí nṉee hikaigo gádaabiłṉii, Nitsi’ dastsąą; nt’é bighą Iłch’ígó’aahíí dayúweh nańtł’og áída’? ");
INSERT INTO apwNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ádaaṉiihíí Jesus yidezts’ąągo ha’ánázéh yebik’ehi gáyiłṉii, Doo néńldzid da, Bik’ehgo’ihi’ṉań hondlą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Áídí’ Peter, James hik’e bik’isn Johnhíí zhą́ yił dikáhgo ngon’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ha’ánázéh yebik’ehi bigowąyú ńyáágo godnch’aadgo ła’íí nṉee díyat’éégo daachago yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Gową yuṉe’ ha’ayáágo gádaabiłṉii, Nt’é bighą daagodinołch’aadgo daahchag? Na’ilíhn doo daztsąą da, daazhógo iłhoshgo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Áí bighą nṉee dázhǫ́ baa daadloh lę́k’e. Nṉee íła’adzaahíí, Ch’ínohkáh, daayiłṉiidá’, na’ilíhnhíí bą́ą́, bitaa hik’e yił nakai n’íí biłgo na’ilíhn sitįį yuṉe’ ha’akai. ");
INSERT INTO apwNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Áígee bigan yiłtsoodgo gáyiłṉii, Talítha cúmi; áí, Na’ilíhn, nádndáh, (niłdishṉii,) golzeego ágolzee. ");
INSERT INTO apwNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dagoshch’į’ nádiidzaago dahiyaa; áń nakits’ádah bił łegodzáhi. Áígee dázhǫ́ koł díyadaagodzaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ágodzaahíí hadíń baa bił nadaagołṉi’ hela’, daayiłṉii, Jesus; ła’íí gánádaabiłdo’ṉiid, Bá da’dohné’. ");
INSERT INTO apwNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus áídí’ dahiyaa, dabíí gólį́į́yú nádzáá; bitsiłke’yu biké’ hikaahgo. ");
INSERT INTO apwNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jews daagodnłsiníí bijįį, ha’ánáłséh goz’ąą yuṉe’ Jesus iłch’ígó’aah nkegonyaa: nṉee łą́ą́go daidits’ago bił díyadaagot’eego gádaaṉii, Hadí’ lą́ą́ yígołsįįdihi? Bigoyą’íí hadí’ baa hi’né’i, godiyįhgo ánágot’įįłíí ndi ánáyol’įįłgo? ");
INSERT INTO apwNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Díń la’kįh ágole’hi nlįį, Mary bizhaazhé ya’, James, Joses, Juda hik’e Simon daabik’isn ya’? Bilahkiihíí ałdó’ la’ akú bił nahétąą? Áí bighą bik’edaach’ishch’ii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus gádaabiłṉii, Bik’ehgo’ihi’ṉań binkááyú na’iziidi dahot’éhé nṉee daabidnłsį, áídá’ dágolį́į́gee, bik’ííhíí ła’íí dała’ naháztaaníí bitahyú zhą́ doo hadíń bidnłsį da. ");
INSERT INTO apwNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Áí bighą ákú doo ízisgo ánát’įįł da ndihíí daanṉiihíí da’kwííyé zhą́ yik’e daadilṉiihgo nádailzii. ");
INSERT INTO apwNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Doo daabodląą dahíí bighą bił díyagot’ee lę́k’e. Áígee iłch’ígó’aahgo gotahyú naghaa. ");
INSERT INTO apwNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesus bitsiłke’yu nakits’ádahíí, Yushdé’, daayiłnṉiidá’, dánaki nláágo zhą́ odaayihił’aago spirits nchǫ’íí daabidits’ago yá ndaagoz’ąą; ");
INSERT INTO apwNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gádaayiłṉiigo, Desohkaiyú doo hant’é daahné’go da, gish zhą́; izis bena’iltiníí dahgo, báń ałdó’ dah, nohwibestso bizis biyi’ zhaali da’ádįhgo: ");
INSERT INTO apwNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kee biká’na’astł’ónihíí biyi’ desoł’eez, ni’íícho doo naki da le’. ");
INSERT INTO apwNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gánádaayiłdo’ṉiid, Dahagee gowąyú ha’ahkáhgo, da’áígee dinohbįh le’gá, łahyú desohkaizhį’. ");
INSERT INTO apwNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Dahagee nṉee daagolííníí doo hádaanohwit’įį dayúgo, nohwiyati’ doo yídaayésts’ąą dayúgo, áídí’ dahdohkáhgo nohwikee bąą łeezhíí baa daałhaał, áí bee doo hádaanohwit’įį dahíí bígózį doo. Da’aṉiigo gánohwiłdishṉii, Bik’ehgo’ihi’ṉań nṉee yándaago’aahíí bijįį Sódom hik’e Gomórrah golzeegee daagolį́į́ n’íí biniidaagodilṉe’íí bitisgo hagee nohkai n’íígee daagolííníí biniidaagodolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Áík’ehgo nakits’ádahíí dahdikaigo nṉee yich’į’ yádaałti’, Nohwinchǫ’íí bits’ą́’zhį’ ádaahṉe’, daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ch’iidn łą́ą́go nṉee biyi’dí’ hadainiheyood, ła’íí daanṉiihíí łą́ą́go ik’ah yił yedaadilṉiihgo nádailzii. ");
INSERT INTO apwNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nant’án Hérod holzéhi Jesus ya’ikonzį; (dahot’éhé bizhi’ bígozįįdgo;) áík’ehgo gáṉíí, John Baptize ágole’ n’íí daztsąądí’ naadiidzaa ląą, áí bighą ígozisgo ánát’įįł. ");
INSERT INTO apwNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Áídá’ ła’íí, Elías at’į́į́, daaṉii. Ła’, Bik’ehgo’ihi’ṉań binkááyú na’iziidi at’į́į́, dagohíí doo áníidá’ Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí ga’at’éhi, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hérod Jesus ánát’įįłíí ya’ikonzįįdá’ gáṉíí, John, bitsits’in nadik’ii n’íí át’į́į́: daztsąądí’ naadiidzaa ląą. ");
INSERT INTO apwNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Dabíntsédá’ Hérod oda’is’a’go John daayiłtsoodgo ha’ádaayist’e’, Heródias holzéhihíí bighą, áń Hérod yił nṉaa lę́k’e, bik’isn Philip t’ah yił nanṉee ndi. ");
INSERT INTO apwNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John Hérod gáyiłnṉiid, Nik’isn bi’aa doo bił na’aashgo ná goz’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Áí bighą Heródias John yik’enṉiihgo bidizidee hat’į́į́ ndi doo hagot’éégo da lę́k’e: ");
INSERT INTO apwNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hérod John yidnłsį, nṉee dábik’ehyú át’ééhíí, dilzįhgo bá habi’delzaahíí nlįįgo yígółsįgo biṉádéz’įį lę́k’e; Hérod yidits’ago yaa bił gozhǫ́ǫ́, bił nagodinlt’ee ndi. ");
INSERT INTO apwNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Áídá’ Heródias bá iłch’į’golzaa, Hérod bił łénágodáhgo nnágodzaagee bá da’odąągo nadaant’aahíí, silááda bá nant’án daanliiníí, ła’íí Gálileegee nṉee itisgo ádaat’eehíí dawa da’iyąą. ");
INSERT INTO apwNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Heródias bizhaazhé na’ilíhníí ha’ayaadá’ ilzhishgo Hérod ła’íí yił da’iyąąhíí yił daagoyiłshǫ́ǫ́, áík’ehgo Hérod na’ilíhníí gáyiłṉii, Dant’éhéta háńt’iiníí shíhóńkeed, áík’ehgo naa nshné’. ");
INSERT INTO apwNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Bitł’a dahdidilṉiihgo gánáyiłdi’ṉii, Dant’éhéta shíhóńkeedíí, dawahá bánansht’aahíí iłṉí’go ndi naa densh’aa. ");
INSERT INTO apwNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Áídí’ na’ilíhníí onádzaayú bimaa gáyiłṉii, Nt’é bíhóshkeed? Áík’ehgo bimaa gábiłṉii, John Baptize ágole’íí bitsits’in bíhóńkeed. ");
INSERT INTO apwNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Áík’ehgo na’ilíhníí dagoshch’į’ ha’ánádzaadá’ hwéhego Hérod yich’į’ nnilwodgo gáṉíí, John Baptize ágole’íí bitsits’in bena’ikaahíí biká’ dahs’ąągo dagoshch’į’ shaa ńkaah. ");
INSERT INTO apwNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nant’ánhíí dázhǫ́go doo bił gozhǫ́ǫ́ da; áídá’ bitł’a dahdidilṉiih n’íí bighą, ła’íí nṉee yił da’iyąąhíí bighą doo hagot’éégo, Dah, yiłṉii da. ");
INSERT INTO apwNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Áík’ehgo dagoshch’į’ nant’ánhíí silááda John bitsits’in náyíí’aahgo oyił’a’: áík’ehgo ha’áná’ilka’ yuṉe’ bitsits’in nadain’ą́ą́dá’, ");
INSERT INTO apwNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bena’ikaahíí bee bitsits’ini ha’ádaiskąągo, na’ilíhníí yaa yinką́ą́; áídí’ na’ilíhníí bimaa yaa nainką́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","John bitsiłke’yu ya’ikodaanzįįdá’ bits’íhíí nádainłtįįgo tsébii’i’áń yuṉe’ odaiztįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Odais’a’ n’íí Jesus yaa nákaigo hago ánádáát’įįdíí, ła’íí nt’é iłch’ídaagos’ąąhíí dawa baa bił nanádaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Áídí’ Jesus gádaabiłṉii, Noo’, danéé zhą́ da’igolį́į́yú ch’a’ohkáh, hanádaahidzoołyú; nṉee łą́ą́go baa nihikáhíí bighą doo da’iyąą da le’ágot’ee lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Áík’ehgo doo hadíń naghaa dayú dabíí zhą́ bił oda’iz’eel. ");
INSERT INTO apwNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Áídá’ nṉee bił oda’iz’eelgo daabiłtsąą lę́k’e, áík’ehgo łą́ą́go Jesus yídaagołsįįdgo ił’anigo kįh gozṉildí’ dáni’go akú dantsé ńkį́į́, áídí’ baa náńłsą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus ákú bił nda’iz’eelgo nṉee łą́ą́go íła’adzaahíí yo’įįgo yaa daach’oba’, dibełį́į́ nanyoodíí da’ádįhgo nakai łehíí k’ehgo ádaat’eehíí bighą; áík’ehgo łą́ą́go yił ch’ídaago’áah nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","O’i’ą́ą́zhį’ godeyaayú bitsiłke’yu baa hikaigo gádaabiłṉii, Kú da’igolį́į́yú doo hadíń gólį́į́ da, k’ad o’i’aahzhį’ goldoh: ");
INSERT INTO apwNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nṉeehíí dahayú gotahyú nádaadnł’áá, báń nadaayiłṉiihyú; bi’idáń da’ádįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Áídá’ Jesus gádaabiłṉii, Nohwíígo bá da’dohné’. Bitsiłke’yu gánádaabiłdo’ṉiid, Báń naki gonenadín zhaali, penny holzéhi, dábik’ehgo nadaahiilṉiihyú nkáh née, bá da’n’né’go? ");
INSERT INTO apwNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Báń dijolé da’kwíí nadaahné’? ṉii, Jesus, Ti’i, akú hadaadeh’į́į́. Yídaagołsįįdá’ gádaaṉii, Ashdla’i ląą, łógíí naki biłgo. ");
INSERT INTO apwNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesus gádaabiłṉii, Nṉee dawa ni’yú tł’oh dotł’izhi biká’yú ił’anigo dinohbįh daabiłdohṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Áík’ehgo dała’á gonenadíngo ła’íí ashdladingo dinezbįh. ");
INSERT INTO apwNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Áídí’ Jesus báń ashdla’ihíí łóg nakihíí biłgo náidnné’go hadag déz’įįgo ya’ihénzįgo oskąądí’ iłk’ídaizné’go bitsiłke’yu yaa daizné’, nṉee yitada’iṉiihgo; ła’íí łóg nakihíí nṉee dawa yitada’izṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Áígee nṉee dawa da’iyąągo náda’isdįįd lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ch’ékaadíí táts’aa nakits’ádah bik’ehgo nádaihezlaa, báń hik’e łóg biłgo. ");
INSERT INTO apwNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nṉee ashdladn doo náhóltagyú áhołánishį báń daiyą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Áídí’ Jesus bitsiłke’yu gádaayiłṉii, Tsina’eełíí beh hohkáhgo shádįhyú nohwił ido’éeł hanaayú, Bethsáidayú, shíhíí nṉee nádohkáh biłdishṉiidá’. ");
INSERT INTO apwNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nádohkáh yiłnṉiidá’ dasahndi wą́’yú óyáá, okąąhyú. ");
INSERT INTO apwNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","O’i’ą́ą́ ni’ tsina’eełíí tú iłṉí’yú hi’oł, áídá’ Jesus dasahndi ni’yú naghaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Bił da’o’ołgee bidáhzhį’ nyolgo bich’į’ nagontł’ogo Jesus yiłtsąą; áík’ehgo doo hwahá ha’i’aah dayú bich’į’ higaał, tú yiká’ higaałgo; ba’ashhah ch’egháhgo. ");
INSERT INTO apwNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nt’éégo tú yiká’ higaałgo bitsiłke’yu daabiłtsąądá’, ch’iidn at’į́į́ daanzįgo nádaadidilghaazh: ");
INSERT INTO apwNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Dawa daabiłtsąągo tsídaadolyiz. Áídá’ dagoshch’į’ Jesus bich’į’ hadziigo, Nohwił daagozhǫ́ǫ́ le’: shíí ásht’į́į́; doo nédaałdzid da, daabiłṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Áídí’ tsina’eełíí itah yiyi’ oyáágo nyolíí isht’idedzaa: áí bighą dázhǫ́ bił díyadaagot’eego tsídaadolyiz. ");
INSERT INTO apwNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Báń godiyįhgo łą́ą́go alzaa n’íí doo bił ídaagozį da; áídá’ bijíí ntł’iz daasilįį. ");
INSERT INTO apwNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hanaayú bił nada’dez’eeldá’ ni’ Gennésaret golzeeyú nda’iz’eelgo tsina’eełíí dah daayihiztł’ǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Áígee tsina’eełíí biyi’dí’ hakaidá’ dagoshch’į’ nṉee Jesus yídaagołsįįd. ");
INSERT INTO apwNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Áík’ehgo daagotahyú dahot’éhé anákeełgo daanṉiihíí ch’id yiká’ nashjeed, hayú Jesus naghaa ch’iṉiiyú anádaayołtéeh. ");
INSERT INTO apwNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Dahayú naghaayú kįh nagoshjaayú, ła’íí kįh nagozṉilyú, ła’íí gotahyú, daanṉiihíí intínk’ehyú ndaayihiṉiił, Jesus náyokąąhgo, Ni’íí bidá’yú zhą́ ndi bedaadenlṉiih, daabiłṉiigo: áík’ehgo bedaadesṉiihíí dawa nádaabi’dilzii. ");
INSERT INTO apwNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pharisees daanlíni hik’e begoz’aaníí ye’ik’eda’iłchíhi ła’ biłgo Jerúsalemdí’ hikaihíí Jesus yaa íła’adzaa. ");
INSERT INTO apwNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesus bitsiłke’yu ła’ bigan dáchįzhą́go da’iyąągo daa yiłtsąą, áí dá doo daagodnłsįgo táda’digisé da’iyąągo ágolzee; áí daayiłtsąądá’ yída’iłtah lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Phárisees hik’e Jews daanlíni dawa daagodnłsįgo tánáda’digisyúgo zhą́ náda’idįįh, iłk’idá’ nṉee yánazįį n’íí yendaago’aahíí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na’hiṉiih nagoz’ąądí’ nnáhikáhgee daagodnłsįgo táda’digisgo zhą́ da’iyąą. Iłk’idá’ nṉee n’íí yedaagos’aaníí łą́ą́go ałdó’ yee ánádaat’įįł, idee, isaa, be’ibízhé bésh łitsogi alzaahíí daagodnłsįgo tádaasgisgo, biká’idáné ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Phárisees hik’e begoz’aaníí ye’ik’eda’iłchíhi biłgo Jesus nayídaadiłkidgo, Hant’é bighą nitsiłke’yu iłk’idá’ nṉee yánazįį n’íí yendaagos’aaníí doo yikísk’eh ádaat’ee dago dá doo daagodnłsįgo táda’digiségo da’iyąą? daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus gádaabiłṉii, Nohwíí nṉee nzhóni ádaadoł’íni, Esáias da’aṉiigo dabíntsédá’ nohwaa nagolṉi’ lę́k’e, díí k’ehgo nohwaa k’e’eshchįįgo, Díí nṉee dá yati’ zhą́ bee daashidnłsį, áídá’ bijíí bee doo daashidnłsį da. ");
INSERT INTO apwNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Da’ílį́į́zhį’ daashokąąh, nṉee yegos’aaníí zhą́ yee iłch’ídaago’aah. ");
INSERT INTO apwNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bik’ehgo’ihi’ṉań yengon’ááníí k’ihzhį’ ádaasolaadá’ iłk’idá’ nṉee n’íí yendaagos’aaníí zhą́ bikísk’eh ádaanoht’ee, isaa, ideeta daagodinołsįgo tádaahgisgo; ła’íí da’áík’ehgo łą́ą́yú ánádaaht’įįł. ");
INSERT INTO apwNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Áídí’ gánádaabiłdi’ṉii, Iłk’idá’ nṉee n’íí nohwá yendaagos’aaníí zhą́ nłdzilgo daahonohtą’híí bighą Bik’ehgo’ihi’ṉań yengon’ááníí daazhógo k’ihzhį’ ádaanołsį. ");
INSERT INTO apwNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses gánṉiid, Nitaa hik’e nimaa dinłsį́, ła’íí, Hadíń bitaa dagohíí bą́ą́ yati’ yee yokáałíí zideego bá goz’ąą: ");
INSERT INTO apwNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Áídá’ nohwihíí gádaadohṉii, Hadíń bitaa dagohíí bą́ą́, Nt’éhéta bee nich’oshṉii doleeł n’íí Corban at’éé, yiłṉiihíí, áí golzeego Bik’ehgo’ihi’ṉań baa nshné’ golzeego ágolzee; áík’ehgo áń doo zideego bá goz’ąą da, daadohṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ádohṉiigo bitaa dagohíí bą́ą́ doo dayúweh bich’oṉii da ndi nzhǫǫ, daadohṉii; ");
INSERT INTO apwNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Áík’ehgo iłk’idá’ nṉee n’íí yendaagos’aaníí nohwichągháshé bił ch’ídaagonoh’aahíí bikísk’eh ádaanoht’eego Bik’ehgo’ihi’ṉań biyati’íí doo nt’égo ádaanołsį da: ła’íí da’áík’ehgo łą́ą́yú ánádaaht’įįł. ");
INSERT INTO apwNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Áídí’ nṉee dawa, Yushdé’, daayiłnṉiidá’ gádaayiłṉii, Daanohwigha shídaayełts’ą́ą́go bídaagonoł’aah: ");
INSERT INTO apwNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nt’é koká’dí’ koyi’ yuṉe’ be’ogohigháhíí doo nchǫ’go kodiłteeh da: áídá’ nt’é koyi’dí’ behagohigháhíí zhą́ nchǫ’go kodiłteehi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hadíń bijeyi’ golííníí íyésts’ąą le’. ");
INSERT INTO apwNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nṉee íła’at’éé n’íí bits’ą́’ Jesus kįh yuṉe’ ha’ayaadá’ bitsiłke’yu iłch’ígó’aahgo nagolṉi’ n’íí yaa nabídaadiłkid. ");
INSERT INTO apwNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Áík’ehgo gádaabiłṉii, Ya’ nohwíí ałdó’ t’ah doo nohwił ídaagozį da née? Nt’éhéta koká’dí’ koyi’ yuṉe’ be’ogohigháhíí doo nchǫ’go kodiłteeh dahíí, ya’ doo hwahá bídaagonołsįįh da née? ");
INSERT INTO apwNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Áí kojíí doo biyi’ yuṉe’ ogohigháh da go’į́į́, áídá’ kobid yuyaa be’ogohigháh, áídí’ nláhyú bech’ígohigháh; Jesus áṉííhíí bee idáń dawa nłt’éé, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Gánádaabiłdo’ṉiid, Koyi’dí’ behagohigháhíí zhą́ nchǫ’go kodiłteehi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Koyi’dí’, kojíí biyi’dí’ díínko behagohigháh: nchǫ’go natsí’ikeesíí, nant’į’ na’idaahíí, iké’ na’idaahíí, na’iłtseedíí, ");
INSERT INTO apwNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ich’in’įįhíí, dawahá dayúwehégo ídáhách’it’iiníí, nchǫ’go ách’ít’ééhíí, nach’ich’aahíí, nchǫ’íí doo bich’į’ t’ąązhį’ ách’it’éé dahíí, bíyééhíí hách’it’įįhíí bighą hach’ishkeehíí, nchǫ’go yách’iłti’íí, ída’ch’odlííhíí, koni’ ádiníí ałdó’: ");
INSERT INTO apwNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Díí nchǫ’íí dawa koyi’dí’ behagohigháh, áí nchǫ’go daakodihiṉiiłi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Áídí’ Jesus dahiyaago Tyre hik’e Sidon golzeehíí biṉaayú óyáá, áígee kįh yuṉe’ ha’ayáá, akú nashaahíí doo hadíń yígołsįįh da, nzįgo: áídá’ doo hagot’éégo nádaabidoł’į́ihgo da. ");
INSERT INTO apwNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Áídá’ isdzán bizhaazhé na’ilíhníí spirit nchǫ’i biyi’ golíni Jesus ya’ikonzį, áík’ehgo baa nyáágo biyahzhį’ hayaa adzaa: ");
INSERT INTO apwNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Isdzánhíí Greek k’ehgo yałti’ihi, Syropheníciadí’ gólíni; áń nábokąąh, Ch’iidn shizhaazhé biyi’ golíni biyi’dí’ hanyóód, biłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus gábiłṉii, Chągháshé ntsé bá daach’idiné’go nłt’éé: báń chągháshé bits’ą́’ nách’idiné’go gósé bich’į’ och’iłkaadgo doo bik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Isdzán gánábiłdi’ṉii, Da’aṉii, shiNant’a’: da’ágát’éé ndi gósé biká’idáné bich’į’ nakaihíí báń bizhool chągháshé bits’ą́’ nanihidéhíí daayiyąą. ");
INSERT INTO apwNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus gábiłṉii, Ánṉiihíí bighą nádńdáh; ch’iidn nizhaazhé biyi’dí’ háyáá. ");
INSERT INTO apwNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Isdzánhíí bigowąyú nadzaago, ákú bizhaazhé biká’dahstíné yiká’ dahstįį ląą, ch’iidn da’ádįhgo. ");
INSERT INTO apwNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Áídí’ Jesus dahnadidzaago Tyre hik’e Sidon golzeedí’ túsikaaníí Gálilee golzeezhį’ nadzáá, Decápolis golzeeyú ch’ínyáágo. ");
INSERT INTO apwNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Áígee nṉee bijeyi’ ágodini, doo nłt’éégo yałti’i, Jesus baa bił ch’ikai lę́k’e; Biká’nlṉíh, daabiłch’iṉiigo nádaabich’okąąh. ");
INSERT INTO apwNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nṉee íła’at’ééhíí bits’ą́’ dasahndi yił o’áázhdá’ bijeyi’ odolṉiih, áídí’ hadnzhéédgo nṉeehíí bizaad yedelṉiih; ");
INSERT INTO apwNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hadag déz’įįgo deyoldá’, Éphphtha, biłṉii, áí, Ch’ínádendláad, golzeego ágolzee. ");
INSERT INTO apwNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dagoshch’į’ bijeyi’ ch’ínádendláád, ła’íí bizaad n’íí nłt’éé násdlį́į́go, nłt’éégo yałti’. ");
INSERT INTO apwNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hadíń bił nadaagołṉi’ hela’, biłṉii, Jesus: ádaabiłnṉiid ndi da’tiségo yaa nanádaagolṉi’; ");
INSERT INTO apwNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Dázhǫ́ bił díyadaagot’ee lę́k’e, gádaaṉiigo, Dawahá dázhǫ́ nłt’éégo ładaile’: kojeyi’ ágodįh n’íí ich’idits’ago ánáidle’, ła’íí doo yách’iłti’ da n’íí ndi yách’iłti’go ánáidle’. ");
INSERT INTO apwNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Áí benagowaadá’ nṉee łą́ą́go íła’adzaa, doo nt’é daiyąą dago Jesus bisiłke’yu, Yushdé’, yiłnṉiidgo gádaayiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Nṉee íła’at’ééhíí baa daach’oshba’, dá bił nashkaigo taagiskąą, k’adíí doo nt’é daiyąą da. ");
INSERT INTO apwNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bigowąyú dáshiṉá’ onádaasił’a’yúgo, nákaahyú dánko shiṉá’ yik’ee odaatłish: ła’íí ńzaadí’ neheskaihíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bitsiłke’yu gádaabiłṉii, Da’igolį́į́gee hadí’ báń nádaach’idiné’, díí nṉee bá daan’né’go? ");
INSERT INTO apwNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus gádaabiłṉii, Báń dijolé da’kwíí nadaahné’? Gosts’idi, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Áígee nṉeehíí, Ni’yú dinohbįh, daayiłṉii: áídí’ báń gosts’idi náidnné’go ya’ihénzįgo oskąądí’ iłk’ídaizné’go bitsiłke’yu yaa daizné’, nṉee yitada’iṉiihgo; áík’ehgo yitada’izṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Łóg ałts’ísę́híí da’ayą́hágo ałdó’ nadaané’: áí ya’ihénzįgo oskąądgo, Díí ałdó’ nṉee bitadaahṉiih, ṉii, Jesus. ");
INSERT INTO apwNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Áík’ehgo da’iyąągo náda’isdįįd: áídí’ ch’ékaadíí táts’aa gosts’idi bik’ehgo nádaihezlaa. ");
INSERT INTO apwNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nṉee dį́į́dn doo náhóltagyú áhołánishį da’iyąą: áídí’ onádaihes’a’ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Dagoshch’į’ bitsiłke’yu biłgo tsina’eełíí beh hikai, áídí’ Dalmanútha golzeeyú bił nda’iz’eel. ");
INSERT INTO apwNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Phárisees baa hikaigo yił łahada’dit’áh nkegonyaa, bídaantááh daanzįgo gádaabiłṉii, Yaaká’dí’ godiyįhgo be’ígózini nohwił ch’í’ṉah áńle’. ");
INSERT INTO apwNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesus biyi’siziiníí doo bił gozhǫ́ǫ́ dago gáṉíí, Nt’é bighą díí daałinolt’įįłíí be’ígózini yiká daadéz’įį? Da’aṉii gádaanohwiłdishṉii, be’ígózini doo bił ch’í’ṉah ádaalṉéhi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Áídí’ tsina’eełíí yeh nanadzaago hanaayú yits’ą́’ bił naná’diz’eel. ");
INSERT INTO apwNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bitsiłke’yu báń yínádaasṉah ni’, dała’á zhą́ tsina’eełíí biyi’ si’ąą lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus bił ch’ígó’aahgo gádaabiłṉii, Báń benilzoołé Phárisees daanlíni bíyééhíí, ła’íí Hérod ałdó’ bíyééhíí baa daagonohsąą. ");
INSERT INTO apwNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bitsiłke’yu iłch’į’ yádaałti’go gádaaṉii, Báń doo daasii’né’ dahíí bighą aṉíí. ");
INSERT INTO apwNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus ádaaṉiihíí yígółsįgo gábiłṉii, Hant’é bighą báń doo daasoné’ dahi baa iłch’į’ yádaałti’? Ya’ doo hwahá bídaagonoł’aah da, doo nohwił ídaagozį da nee? Ya’ nohwijíí t’ah daantł’iz? ");
INSERT INTO apwNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nohwiṉáá daagolį́į́dá’ doo bee daadeh’į́į́ da née? Nohwijeyi’ daagolį́į́dá’ doo bee ídaayesółts’ąą da née? Ya’ doo bínádaałṉiih da née? ");
INSERT INTO apwNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Báń dijolé ashdla’i iłk’ídaasiiné’go nṉee ashdladn doo náhóltago bá da’dená’ n’dá’, ch’ékaadíí da’kwíí táts’aa bik’ehgo ńdaahesolaa láń? Gosts’idi, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Báń dijolé gosts’idi iłk’ídaasiiné’go nṉee dį́į́dn doo náhóltago bá da’dené’ n’dá’, ch’ékaadíí da’kwíí táts’aa bik’ehgo ńdaahesolaa láń? Gosts’idi, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Áík’ehgo Jesus gánádo’ṉiid, Nt’é bighą doo nohwił ídaagozį da? ");
INSERT INTO apwNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Áídí’ Jesus Bethsáidayú ńyáá; áígee nṉee biṉáá ágodini baa bił ch’ikaigo, Bik’enlṉíh, daabiłṉiigo nádaabokąąh. ");
INSERT INTO apwNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Áík’ehgo nṉee biṉáá ágodinihíí bigan yiłtsoodgo kįh gozṉilíí bits’ą́’yú oyilǫ́ǫ́z; ákú biṉáá yik’ídihizheedá’ yiká’ ndelṉiihgo gáyiłṉii, Nt’éhéta hí’į́į́ née? ");
INSERT INTO apwNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Déz’įįgo gáṉíí, Nṉee hikahgo daash’įį ndi t’iis hikahi ga’at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus nṉeehíí biṉáá yiká’nnádelṉiihdá’, Díń’įį, biłṉii; áníita biṉáá nágosdlįįgo nṉee dawa nłt’éégo yo’įį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Áídí’ Jesus gowąyú onábíł’a’ gábiłṉiigo, Kįh gozṉilyú dáko nádódáh hela’, hadíń bił nagolṉí’ hela’. ");
INSERT INTO apwNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Áídí’ Jesus bitsiłke’yu biłgo Caesaréa Philíppi golzéhi biṉaayú kįh nagozṉilyú okai: hikaahyú bitsiłke’yu nayídaadiłkidgo gáyiłṉii, Nṉee hadíń át’į́į́ daashiłṉii? ");
INSERT INTO apwNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Gádaabiłṉii, Ła’, John, Baptize ágole’ n’íí át’į́į́, daaniłṉii; ła’ihíí, Elías at’į́į́, ła’ihíí, Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí ła’ at’į́į́, daaniłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesus gádaabiłṉii, Nohwíí nohwich’į’yúgohíí, hadíń át’į́į́ daashiłdohṉii? Ni Christ ánt’į́į́, yiłṉii, Peter. ");
INSERT INTO apwNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesus gádaabiłṉii, Hadíń shaa bił nadaagołṉi’ hela’. ");
INSERT INTO apwNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Áídí’ bił ch’ídaago’aah nkenágodidzaa gáṉíígo, Shíí, nṉee k’ehgo Niyááhíí, doo ałch’ídn shiniigodilṉéh da, Jews yánazíni, okąąh yebik’ehi itisyú nadaandeehi, ła’íí begoz’aaníí ye’ik’eda’iłchíhi doo hádaashit’įį dago shidizideedá’ taagi jįį hileehgo naadishdáh. ");
INSERT INTO apwNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Áí doo nainł’į’ dago aṉíí. Áídá’ Peter bich’į’ yałti’ nkegonyaago, Doo ánṉii da, biłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Áídá’ Jesus t’ąązhį’ adzaago bitsiłke’yu ła’ihíí yich’į’ déz’įįdgo Peter nłdzilgo bich’į’ hadziigo, Satan, yúwehyú shiké’zhį’ ánṉe’: Bik’ehgo’ihi’ṉań binatsekeesíí k’ehgo doo natsíńkees da ląą, nṉee binatsekeesíí zhą́ bee natsíńkees, biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Áígee nṉeehíí bitsiłke’yu biłgo yiká ánṉiidgo gádaayiłṉii, Dahadíń shiké’ dahdigháh hát’į́į́yúgo, ídaayo’ṉahdá’ bitsį’iłna’áhi dahyidotįįhgo shiké’ dahdowáh. ");
INSERT INTO apwNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Dahadíń bi’ihi’ṉa’ yaa bił goyééhíí áí bits’ą́’ da’ilíí hileeh: áídá’ dahadíń ídaayis’ṉahgo shíí shighą ła’íí yati’ baa gozhónihíí bighą bi’ihi’ṉa’ da’ilíí silįį’į́į́, áń ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ni’gosdzáń dágoz’ąą nt’éégo ch’ist’įįdá’, koyi’sizíni da’ilíí silįįyúgo, áí hant’é bits’ą́’dí’ ch’it’įįh? ");
INSERT INTO apwNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dagohíí koyi’sizíni hant’é bideṉá nch’iné’? ");
INSERT INTO apwNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Díí nchǫ’go nant’į’ nakaigo daałinolt’įįłíí bitahgee dahadíń shik’e ídaayándzįhíí, ła’íí shiyati’ yik’e ídaayándzįhíí, shíí, nṉee k’ehgo Niyááhíí, ałdó’ áń bik’e ídaayánsdzį doo, nánshdáhgee, shiTaa bits’ą́’idindláádíí bee shits’ą́’idindláádgo, binal’a’á yaaká’yú daagolííníí dilzini bił nánshkáhgo. ");
INSERT INTO apwNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesus gádaabiłṉii, Da’aṉii gánohwiłdishṉii, kúgee nadaaziiníí ła’ dá doo da’itsaahíí dailįhé Bik’ehgo’ihi’ṉań binawod golį́į́go nant’aa nkegonyaago daayiłtséh. ");
INSERT INTO apwNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Áídí’ gostáń iskąągee Peter, James hik’e John, Jesus dasahndi yił okai lę́k’e, dził n’ááyú; áígee binadzahgee Jesus łahgo ánolįh silįį. ");
INSERT INTO apwNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Bidiyágé bik’ina’didlaad silįį, zas k’ehgo łigaigo, nṉee ni’gosdzáń biká’gee doo hadíń ágát’éégo łigaigo áyóle’ at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Áígee Moses hik’e Elías bił daanlįįgo silįį: Jesus yił yádaałti’go. ");
INSERT INTO apwNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter Jesus gáyiłṉii, NohweBik’ehń, kú nkaihíí nohwá nzhǫǫ; tł’ohdahskáń táágo ádaagohiidle’; ła’ ni ná, ła’ihíí Moses bá, ła’ihíí Elías bá. ");
INSERT INTO apwNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nt’éshą’ dishṉii nzį lę́k’e; ńdaaldzidhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Áígee yaak’os biká’ dahiyaa: nt’éégo yaak’os biyi’dí’ yati’ daidezts’ąą gáṉíígo, Díínko shiYe’ shił nzhóni; hódaayełts’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dagoshch’į’ bitsiłke’yu łédaadnghalgo, nṉee doo ła’ dadá’ Jesus zhą́ itah sizįįgo daayo’įį. ");
INSERT INTO apwNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dziłdí’ nkenádikaigo, Jesus gádaabiłṉii, Daahołtsąą n’íí hadíń bił nadaagołṉi’ hela’, shíí, nṉee k’ehgo Niyááhíí, dasitsąądí’ naadisdzaago zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Áík’ehgo áṉíí n’íí doo hadíń yił nadaagolṉi’ da lę́k’e, áídá’ gádaałiłdi’ṉii, Nt’éshą’ áiłṉii, dasitsą́ą́dí’ naadishdáh, ṉiihíí? ");
INSERT INTO apwNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bitsiłke’yu nabídaadiłkidgo gádaabiłṉii, Hant’é bighą Elías dantsé hígháh, daaṉii, begoz’aaníí ye’ik’eda’iłchíhi? ");
INSERT INTO apwNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus gádaabiłṉii, Elías da’aṉii dantsé hígháhgo dawahá iłch’į’nádaidle’; áídí’ shíí, nṉee k’ehgo Niyááhíí, díí k’ehgo shaa k’e’eschchįį lę́k’e, doo ałch’ídn shiniigodilṉe’ da, ła’íí doo shił da’ch’ołtag da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Áídí’ gánohwiłdishṉii, Elías iłk’idá’ nyáádá’ baa k’e’eshchiiníí k’ehgo nṉee dabíí hádaat’įįyú ánádaayol’įįł lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Áídí’ bitsiłke’yu ła’ihíí yaa nákaidá’ nṉee łą́ą́go biṉaayú nadaazįįgo begoz’aaníí ye’ik’eda’iłchíhi yił łádaadit’áhgo Jesus yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nṉee dawa Jesus daayiłtsąągo bił díyadaagot’ee, áídí’ dagoshch’į’ baa bił daagozhǫ́ǫ́go bich’į’ nádnkįį. ");
INSERT INTO apwNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Áígee begoz’aaníí ye’ik’eda’iłchíhi gádaayiłṉii, Nt’é baa bił ładaadoht’áh láń? ");
INSERT INTO apwNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Áík’ehgo nṉee íła’at’ééhíí ła’ gáṉíí, Iłch’ígó’aahíí, shiye’ naa bił ní’áázh, spirit nchǫ’i biyi’ golį́į́go doo yałti’ da. ");
INSERT INTO apwNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Dahagee nabihiłaagee nádinigis; áídí’ bizédí’ táńwosh hahigháh hileeh, biwoo’íí łíidiłk’ash, ła’íí doo nłdzil da hileeh: nitsiłke’yu hadainihiyoodgo nádaahoshkąąh: ndi doo hagot’éégo da ni’. ");
INSERT INTO apwNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus gábiłṉii, Nohwi’odlą’ édaadįhgo daałintołt’įįłíí, dahosahzhį’ nohwił nahashtąą? Dahosahzhį’ ląą nohwidag ánsht’ee? Yushdé’, niye’ shich’į’ bił nn’áash. ");
INSERT INTO apwNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Áík’ehgo ishkiinhíí baa bił hikai: nt’éégo spirit nchǫ’ihíí Jesus yiłtsąądá’ dagoshch’į’ ishkiinhíí nádinigisgo ni’yúnágo’; áígee anáyis lę́k’e, bizédí’ táńwosh hahigháhdá’. ");
INSERT INTO apwNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus ishkiin bitaahíí nayídiłkid gáṉíígo, Dadá’ át’į́į́ godeyáhi? Ałts’í ę́ędá’ át’íni, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Łahgee spirit nchǫ’ihííkǫ biyi’ onábiłt’ee, tú ałdó’ biyi’ onábiłt’ee, biziłheego ch’éh ábił’įįgo; bínil’ą́ą́yúgo nohwaa ch’onbaahgo nohwich’onṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus gábiłṉii, Ondląąyúgo, dahadíń odlaaníí dawahá bá łaalṉe’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dagoshch’į’ ishkiinhíí bitaa hichago nádidilghaazhgo gáṉíí, Shíí oshdląą; doo oshdląą dagee oshdląągo áshíńłsį. ");
INSERT INTO apwNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus nṉee łą́ą́go bich’į’ dahikeego yiłtsąądá’ spirit nchǫ’i nłdzilgo yich’į’ hadziigo gáṉíí, Spirit nchǫ’i ńlíni, doo yáńłti’i da, doo idints’agi da, biyi’dí’ halyeedá’ t’ąązhį’ onándáh hela’, niłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Áídí’ spirit nchǫ’íí nádidilghaazhdá’ nádinigisgo ábíílaago biyi’dí’ háyáá; áídí’ ishkiinhíí daztsáni k’a’ánolįh silįį; áík’ehgo nṉee łą́ą́go, Daztsąą ląą, daaṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Áídá’ Jesus ishkiinhíí bigan yiłtsoodí’ náidnlǫǫzgo hizį’. ");
INSERT INTO apwNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Áídí’ Jesus kįh yuṉe’ ha’ayáádá’ bitsiłke’yu dasahndi nabídaadiłkidgo, Nohwihíí nt’é bighą doo hadaandzood da láń? daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus gádaabiłṉii, Spirit nchǫ’i ga’at’éhihíí dáshiṉá’ da’ch’okąąhgo zhą́ habidi’nedzoodhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Áídí’ dahnanáskaidá’ Gálilee golzeeyú ch’ékai; áídá’ Jesus akú naghaa ndi nṉee doo ła’ bígółsį hat’į́į́ da. ");
INSERT INTO apwNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Bitsiłke’yu bił ch’ídaago’aah gáṉíígo, Shíí, nṉee k’ehgo Niyááhíí, nṉee bilák’e shi’dolteełgo daashiziłhee; áídí’ taagi jįį hileehgo naadishdáh. ");
INSERT INTO apwNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hant’é ṉiigo aṉííhíí doo bił ídaagozį da, áídá’ nabídaadiłkidzhį’ nédaaldzid. ");
INSERT INTO apwNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesus Capérnaum golzeeyú ńyáá: áígee kįh yuṉe’ ha’ayáádá’ bitsiłke’yu nayídaadiłkid gáṉíígo, Hohkaahyú nt’é baa łił nadaagołṉi’? ");
INSERT INTO apwNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Áídá’ doo hant’é daaṉii da: Nohwitahyú hadíń itisgo at’éhi? daałiłdi’ṉii ni’, hikaahyú. ");
INSERT INTO apwNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Áígee Jesus nezdaago nakits’ádahíí yiká ánṉiidá’ gádaayiłṉii, Dahadíń shíí dantsé le’ nzįyúgo, áń iké’zhį’ hileeh doo, áń dawa yá áił’įį doo. ");
INSERT INTO apwNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chągháshé ła’ íłṉí’gee nyinlǫ́ǫ́z: áídí’ dahyinłtįįgo bitsiłke’yu gádaabiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Dahadíń shizhi’íí binkááyú chągháshé díí ga’at’ééhíí náidnłtįįyúgo, shíí náshidnłtíni at’éé; ła’íí dahadíń náshidnłtiiníí doo shíí zhą́ náshidnłtįį da ndi shides’a’íí ałdó’ náidnłtíni at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John gábiłṉii, ShiNant’a’, nṉee ła’ doo bił daandlįį dahíí nizhi’íí binkááyú nṉee biyi’dí’ ch’iidn hainiyoodgo daahiit’įį; áík’ehgo, Doo ágáńt’įį da, daabiłn’ṉiid, doo bił daandlįį dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Áídá’ Jesus gábiłṉii, Doo ágádaabiłdohṉii da: dahadíń shizhi’íí binkááyú godiyįhgo áná’ol’įįłíí, doo dénchǫ’égo áshiłdoṉi’ at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Hadíń doo nchǫ’go nohwich’į’ na’iziid dahíí, áń bił daagohiit’įį. ");
INSERT INTO apwNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Hadíń shizhi’íí bighą, Christ bíyéé daanohłįįhíí bighą, idee bee tú nohwá nayiziidíí, da’aṉiigo gánohwiłdishṉii, Bik’ehgo’ihi’ṉań bich’į’ nayihiṉiiłíí da’aṉiigo bíyéé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Dahadíń díí doo ízisgo ádaat’ee da ndi daashodlaaníí dała’á nchǫ’go at’į́į́go áile’íí, áń tséé be’ik’áhi nchaahi bik’osyú bidestł’ǫǫgo túnteel beh hilt’e’go bá nzhǫǫ doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nigan nchǫ’go ánát’įįł áníłsįyúgo nadnłgeesh; nigan dała’á ádįh ndi dahazhį’ ihi’ṉaahíí biyi’ onṉáhgo doo hago at’éé da, áídá’ nigan nakigo ch’iidn bikǫ’ diltłi’i, kǫ’ dahazhį’ diltłi’íí biyi’ yuyaa onṉáhyúgo doo ná nzhǫǫ da: ");
INSERT INTO apwNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ákú ch’osh doo nanṉe’ da, ła’íí kǫ’ doo nłtséés da. ");
INSERT INTO apwNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nikee nchǫ’go ánát’įįł áníłsįyúgo nadnłgeesh; nikee dała’á ádįh ndi dahazhį’ ihi’ṉaahíí biyi’ onṉáhgo doo hago at’éé da, áídá’ nikee nakigo ch’iidn bikǫ’ diltłi’i, kǫ’ dahazhį’ diltłi’íí biyi’ yuyaa oni’dolt’e’yúgo doo ná nzhǫǫ da: ");
INSERT INTO apwNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ákú ch’osh doo nanṉe’ da, ła’íí kǫ’ doo nłtséés da. ");
INSERT INTO apwNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Niṉáá nchǫ’go ánát’įįł áníłsįyúgo ha’aah; niṉáá dała’á ádįh ndi Bik’ehgo’ihi’ṉań bilałtł’áhgee goz’ąą yuṉe’ ha’ánṉáhgo doo hago at’éé da, áídá’ niṉáá nakigo ch’iidn bikǫ’ dahazhį’ diltłi’i biyi’ yuyaa oni’dilt’e’yúgo doo ná nzhǫǫ da: ");
INSERT INTO apwNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ákú ch’osh doo nanṉe’ da, ła’íí kǫ’ doo nłtséés da. ");
INSERT INTO apwNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Daakówa kǫ’ bee hadaakodilṉe’ doleeł, ishįįh k’ehgo, be’okąąhíí natseedgo Bik’ehgo’ihi’ṉań baa hi’ṉiiłíí ishįįh bee daadilk’ǫsh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ishįįh nłt’éé ndi doo nk’ǫ́ǫ́zh da silįįyúgo, nt’é bee nk’ǫ́ǫ́zhgo ánálṉe’? Nohwiyi’ ishįįh daagolį́į́ le’, áídí’ iłch’į’ daanohjǫǫ le’. ");
INSERT INTO apwNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Áídí’ Jesus dahnádidzaago ni’ Judéa golzéhi goz’ąąyú túńlííníí Jórdan holzéhi hanaayú ńyáá: ákú nṉee baa nanáńłsą́ą́; áígee iłch’ígó’aah n’íí k’ehgo yich’į’ yałti’go nkenágodidzaa. ");
INSERT INTO apwNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Phárisees daanlíni baa hikaigo nabídaantaahgo gádaabiłṉii, Ya’ nṉee bi’aa iłk’ínát’aashgo goz’ąą née? ");
INSERT INTO apwNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Gábiłṉii, Moses nt’é nohwiłṉiigo nohwá ngon’ą́ą́ láń? ");
INSERT INTO apwNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Áídí’ gádaaṉii, Naltsoos bee iłk’íńch’ít’aashíí łayile’go isdzánhíí yił iłk’ínát’aashgo Moses bá ndaagoz’ąą ni’. ");
INSERT INTO apwNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus gádaabiłṉii, Nohwijíí daantł’izíí bighą díí begoz’aaníí Moses bee nohwich’į’ k’e’eshchįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dantsé godeyaadá’ Bik’ehgo’ihi’ṉań nṉee áyíílaadí’ godezt’i’go nṉee ła’íí isdzán áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Díí bighą nṉee bitaa hik’e bą́ą́ yits’ą́’gháhgo bi’aa yił nlįį doleeł; ");
INSERT INTO apwNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Áí naki n’íí dała’á nádodleeł; áík’ehgo doo naki dilt’ee dadá’ bits’í dała’á silįį. ");
INSERT INTO apwNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Áík’ehgo dahadíń Bik’ehgo’ihi’ṉań łayinlááhíí, dahadíńta iłk’íyóléh hela’. ");
INSERT INTO apwNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Áídí’ kįh yuṉe’ bitsiłke’yu da’áí baa nabínádaadiłkid. ");
INSERT INTO apwNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesus gáyiłṉii, Hadíń bi’aa yił iłk’ínát’aazhdá’ ła’i yił naná’ṉááyúgo nant’į’ nagháhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Dagohíí isdzánhíí biką’ yił iłk’ínát’aazhdá’ ła’i yił naná’ṉááyúgo, isdzánhíí ch’a’oṉáá hileeh. ");
INSERT INTO apwNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesus chągháshé ałts’ísę́hi baa bił nch’ihezkai lę́k’e, yiká’ ndaadilṉiih daabich’o’ṉíígo; áídá’ bitsiłke’yu, Doo ágádaaht’įį da, daakołṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Áídá’ Jesus daabiłtsąągo doo bił bik’eh da lę́k’e, áík’ehgo bitsiłke’yu gádaayiłṉii, Ch’ík’eh chągháshé shich’į’ nihikáh le’, doo t’ąązhį’ daahínóhtą’ da; bíí ga’ádaat’eehíí Bik’ehgo’ihi’ṉań bilałtł’áhgee daanlįį. ");
INSERT INTO apwNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Da’aṉiigo gádaanohwiłdishṉii, Dahadíń chągháshé ałts’ísę́híí k’ehgo Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí nágodn’ąąyúgo zhą́ Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah hileeh. ");
INSERT INTO apwNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Áík’ehgo dahnáidiłtééhgo yiká’ ndaadelṉiigo yá da’oskąąd. ");
INSERT INTO apwNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Áídí’ łahyúgo Jesus dahnasdzaadá’ nṉee bich’į’ nádilwodgo biyahzhį’ hilzhiizhdá’ nabídiłkid, Iłch’ígó’aahíí nłt’éhi ńlínihi, hago ląą áshṉe’go ihi’ṉaa doo ngonel’ąą dahíí bee hinshṉaa doleeł? ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus gábiłṉii, Nt’é bighą nłt’éhi shiłnṉii? Doo hadíń nłt’éé da go’į́į́, dała’á zhą́, Bik’ehgo’ihi’ṉań zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Bik’ehgo’ihi’ṉań ngon’ą́ą́ lęk’ehíí bígonłsį́ go’į́į́, Doo nant’į’ nach’ighaa da, Doo na’ch’iłtsee da, Doo ich’in’įįh da, Doo łé’ch’iłchoo da, Doo nach’ich’aa da, Kotaa hik’e komaa ch’idnłsį. ");
INSERT INTO apwNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nṉeehíí gábiłṉii, Iłch’ígó’aahíí, ánists’ísę́dí’ godezt’i’go díí dawa bee ánsht’ee. ");
INSERT INTO apwNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus bił nzhǫǫgo bineł’į́į́go gábiłṉii, Dała’á zhą́ doo bee áńt’éé da: ti’i, dawahá ṉíyééhíí naa nahoṉiihgo zhaalihíí tédaat’iyéhíí bita’iṉííh, áík’ehgo yaaká’yú dawahá łáń ílíni ṉíyéé doleeł: áídí’ yushdé’ tsį’iłna’áhi dahntįįłgo shiké’ dahsinṉáh. ");
INSERT INTO apwNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesus áṉíídá’ nṉeehíí ádaatsídézkeezgo doo bił gozhǫ́ǫ́ dago onádzaa; dázhǫ́ háłdzilhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Áídí’ Jesus bitsiłke’yu yitah déz’įįdá’ gádaabiłṉii, Nṉee hádaałdzilíí Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah daaleehgo dázhǫ́ bá nyee! ");
INSERT INTO apwNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bitsiłke’yu Jesus áṉííhíí bighą bił díyadaagot’ee lę́k’e. Áídá’ Jesus gánádaabiłdo’ṉiid, Shichągháshé, nṉee hádaałdzilíí zhą́ ya’ołííhíí Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah daaleehgo dázhǫ́ bá nyee! ");
INSERT INTO apwNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Łį́į́ bigháń ha’i’áhíí bená’kadé bigha’i’áńyú ch’égháhgo bá nyeedá’ nṉee háłdzilíí Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah hileehgo itisgo bá nyee. ");
INSERT INTO apwNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bitsiłke’yu díí daidezts’ąądá’ dázhǫ́ bił díyadaagodzaago gádaałiłdi’ṉii, Áídá’ hadíń zhą́ hasdábi’dilteeh? ");
INSERT INTO apwNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus daabineł’į́į́go gáṉíí, Nṉeehíí áí doo łayole’ at’éé da, Bik’ehgo’ihi’ṉań zhą́ go’į́į́: Bik’ehgo’ihi’ṉań zhą́ dawa łayile’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peter gábiłṉii nkegonyaa, Nohwíyéé dawa bits’ą́’ dahidiikaidá’ niké’ dahsiikai ni’. ");
INSERT INTO apwNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus gádaabiłṉii, Da’aṉii gádaanohwiłdishṉii, dahadíń bigową, bik’isyú, bilahkííyú, bitaa, bą́ą́, bichągháshé, bi’aa, dagohíí bini’ shíí shighą ła’íí yati’ baa gozhónihíí bighą yits’ą́ dahnyaayúgo, ");
INSERT INTO apwNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Áń díí goldohíí biyi’ gową, bik’isyú, bilahkííyú, bą́ą́, bichągháshé, ła’íí bini’ dała’á gonenadín k’a’ánáhołąągo, biniigodilṉéhíí bíhii’né’go, baa det’aahi at’éé, ła’íí łahgo nágodesdzaago ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Áídá’ łą́ą́go dantsé daanlįį n’íí iké’yú doleeł; ła’íí iké’yú daanlįį n’íí dantsé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Áídí’ Jesus ádįh higaałgo Jerúsalemyú wą́’yú intínk’eh ch’okaah lę́k’e; áígee bił díyadaagot’ee; ła’íí biké’ hikaahíí nédaaldzid lę́k’e. Nakits’ádahíí k’ihzhį’ yił nnanákaigo bich’į’ ágoṉéhíí baa bił nadaagolṉi’go nkenágodidzaa, ");
INSERT INTO apwNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Gáṉíígo, Isąą, Jerúsalemyú dekai; ákú shíí nṉee k’ehgo Niyááhíí, okąąh yebik’ehi itisyú nadaandeehi hik’e begoz’aaníí ye’ik’eda’iłchíhi biłgo baa shi’dilteehdá’ shidizideego shá ngot’áah doleeł, áídí’ doo Jews dannlįį dahíí yaa daashiłtéehgo, ");
INSERT INTO apwNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Shaa daadloh doo, hashída’iłtsaas doo, shik’ídaadihizheeh doo, ła’íí daashiziłhee doleeł; áídí’ taagi jįį hileehgo naadishdáh. ");
INSERT INTO apwNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Áídí’ James hik’e John biłgo, Zébedee biye’kehíí, Jesus yaa n’áázhgo gáyiłṉii, NohwiNant’a’, nt’é níhǫ́keedíí nohwá łanle’. ");
INSERT INTO apwNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Hant’é nohwá áshłe’ haht’į́į́ gá’? biłṉii, Jesus. ");
INSERT INTO apwNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Gádaabiłṉii, Ízisgo áńt’ee síńlįįgee ła’ nigan dihe’nazhiṉéé dahsdaa doleełgo, ła’íí ni’eshganzhiṉéé dahsdaa doleełgo nohwá ngon’áah. ");
INSERT INTO apwNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Áídá’ Jesus gádaabiłṉii Nt’é shíhóhkeedíí doo bígonołsį da ląą: idee be’ishdląąhíí be’ohdląągo bínołdzil née? Baptize be’áshi’dilṉ’eíí bee baptize ánohwi’dilṉe’go bínołdzil née? ");
INSERT INTO apwNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bínldzil, daabiłṉii. Jesus gánábiłdo’ṉiid, Idee be’ishdląąhíí da’aṉii be’ohdląą doleeł, baptize áshi’dilṉe’íí da’aṉii bee baptize ánohwi’dilṉe’ doleeł, ");
INSERT INTO apwNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Áídá’ shigan dihe’nazhiṉéé dagohíí shi’eshganzhiṉéé sodaa doleełíí, doo shíí nohwaa godesh’aah da; áí dahadíń bá iłch’į’golzaahíí zhą́ baa godet’aahi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Áík’ehgo bitsiłke’yu gonenanhíí James hik’e John ádaaṉiihíí daidezts’ąądá’ doo bił daabik’eh da nkegonyaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesus bitsiłke’yu íła’áyíílaago gádaayiłṉii, Doo Jews daanlįį dahíí bánant’án daanlįįgo ha’ṉilíí isná ádaabiłsįgo bá nadaant’aah; ła’íí bitahyú nṉee ízisgo ádaat’eehíí da’áṉííyú ádaat’įįgo ádaabiłsįgo bídaagonołsį. ");
INSERT INTO apwNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Áídá’ nohwihíí nohwitahyú doo ágágot’ee da doleeł: áídá’ dahadíń nohwitahyú ízisgo ánsht’ee le’ nzįhíí, áń nohwá áił’įį le’: ");
INSERT INTO apwNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nohwitahyú dahadíń nant’án nshłįį le’ nzįhíí, áń nohwá na’iziid le’. ");
INSERT INTO apwNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Shíí, nṉee k’ehgo Niyááhíí nshłįį ndi, doo hadíń shich’oṉiihíí bighą niyáá da, áídá’ nṉee bich’oshṉiihíí bighą niyáá, shi’ihi’ṉa’íí nṉee łáni bá nahishṉiiłhíí bighą niyáá. ");
INSERT INTO apwNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jériko golzeeyú hikai: áídí’ Jérikodí’ dahiskaigo bitsiłke’yu nṉee łą́ą́go biłgo náńłsą́ą́go nṉee biṉáá ágodini, Bartiméus holzéhi, Timéus biye’híí, intín bahyú sidaa, ídókeedgo. ");
INSERT INTO apwNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesus, Názarethdí’ gólíni, higaałgo nṉee biṉáá ágodini ya’ikonzįįdá’ nádidilghaazh nkegonyaago gáṉíí, Jesus, David biYe’ ńlíni, shaa ch’onbáah. ");
INSERT INTO apwNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nṉee łą́ą́go, Godnch’áad, daabiłṉii: áídá’ da’tiségo nanádidilghaazhgo gánádo’ṉiid, David biYe’ ńlíni, shaa ch’onbáah. ");
INSERT INTO apwNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus ninyáágo gáṉíí, Yushdé’ daabiłdohṉii. Áík’ehgo nṉee biṉáá ágodiníí yich’į’ ánṉiidgo gádaabiłṉii, Nił gozhǫ́ǫ́go nádndáh: yushdé’ niłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Íícho ídáidiłtsoozdá’ nádihiitahgo Jesus yich’į’ nyáá. ");
INSERT INTO apwNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus gánábiłdo’ṉiid, Nt’é ná áshłe’ háńt’įį gá? Nṉee biṉáá ágodiníí gábiłṉii, SheBik’ehń, desh’į́į́go ánáshidle’. ");
INSERT INTO apwNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus gábiłṉii, Ti’i, ni’odlą’íí nłt’éégo ánániidlaa. Áík’ehgo dagoshch’į’ biṉáá nágosdlįįgo biké’ dahiyaa. ");
INSERT INTO apwNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Áídí’ Jesus bitsiłke’yu biłgo Jerúsalem k’ad yaa hikáh, Béthphage ła’íí Béthany golzeezhį’, dził Olives holzéhi si’ąągee, áídí’ bitsiłke’yu naki oyił’a’, ");
INSERT INTO apwNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Gáyiłṉiigo, Ti’i, nohwádįhyú gotahyú doh’aash: dáha’ah’aashgee túlgayé zhaazhé dahastł’ǫǫgo baa noh’aash, doo hwahá hadíń yiká’ dahndaahi da; áí k’e’oh’adgo kú nánohłǫǫs. ");
INSERT INTO apwNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dahadíń, Nt’é bighą k’e’oh’ad? nohwiłṉiiyúgo, gábiłdohṉiih, NohwiNant’a’ hát’į́į́go áhiit’įį; áík’ehgo dagoshch’į’ nohwaa gode’aahgo nádohłǫǫs. ");
INSERT INTO apwNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Áík’ehgo o’áázh, ákú túlgayé zhaazhé kįh bitah na’iztínhíí bahyú ch’íná’itį́hgee dahastł’ǫǫgo yaa n’áázh, áídí’ k’eda’yi’ad. ");
INSERT INTO apwNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Áígee ła’ nadaaziiníí gádaabiłṉii, Nt’é bighą túlgayé k’e’oh’ad? ");
INSERT INTO apwNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesus áṉííhíí bee ágádaabiłṉii; áík’ehgo onádaist’e’. ");
INSERT INTO apwNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Áídí’ túlgayéhíí Jesus yaa daizlǫǫzgo bidiyágéhíí biká’ dahdaihezṉildá’ Jesus túlgayéhíí yiká’ dahnezdaa. ");
INSERT INTO apwNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nṉee łą́ą́go bidiyágé intínyú yídaagosteel lę́k’e; ła’ihíí ch’il palm bits’ádaaz’aahíí nadaayihilgeeshgo intínyú yídaagosteel. ");
INSERT INTO apwNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nṉee bádįh náłseełíí ła’íí biké’dí’ náłseełíí daadilwoshgo gádaaṉii, Hosánna: NohweBik’ehń bizhi’ yee higaałíí ba’ihégosini at’éé: ");
INSERT INTO apwNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","David, bits’ą́’dí’ hadaałinelt’ąąhíí, nant’aa n’íí k’ehgo nohweBik’ehń bizhi’ bee kú ngowáhíí ba’ihégosį: da’tiséyú goz’ąądí’, Hosánna. ");
INSERT INTO apwNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Áídí’ Jesus Jerúsalemyú ńyáágo da’ch’okąąh goz’ąą yuṉe’ oyáá: ákú dawahá daineł’į́į́dá iłk’dá’, o’i’ą́ą́go Béthanyú nakits’ádahíí biłgo onákai. ");
INSERT INTO apwNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Iskąą hik’e Béthanydí’ nákaahdá’ Jesus shiṉá’ silįį; ");
INSERT INTO apwNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dańzaadí’ ch’il fig bit’ąą golį́į́go o’áágo yiłtsąągo yaa nyáá, nt’éhéta baa dahsné’ nolį nzįgo: áídá’ yaa nyáádá’ doo nt’é baa dahsné’ da ląą, bit’ąą zhą́, figs doo hwahá daant’ąą dagee goldohíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Áík’ehgo Jesus gábiłṉii, Kodí’ godezt’i’go doo hadíń nits’ą́’dí’ nest’ą’ náyódą́ą́ át’éé da. Áṉííhíí bitsiłke’yu daidezts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Áídí’ Jerúsalemyú hikai: áígee da’ch’okąąh goz’ąą yuṉe’ Jesus ha’ayáágo, baa nada’iṉiihi ła’íí nada’iłṉiihi ch’íinihiyood nkegonyaa, ła’íí zhaali yiká’ iłkáh ch’ínádaiṉiiłíí naz’aaníí nanyihesgo’; hawúcho baa nadaahiṉiihíí biká’ dah’sdáhá ałdó’ nanyihesgo’; ");
INSERT INTO apwNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Áídí’ doo hadíń nt’éhéta da’ch’okąąh goz’aaníí iłṉí’yú ch’ínáyiné’ dago ngon’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Áídí’ bił ch’ídaago’aahgo Jesus gádaabiłṉii, Ya’ díínko doo bek’e’eshchįį da née? Shikįhíí nṉee iłtah at’éégo hadaazt’i’íí dawa kįh biyi’ da’ch’okąąhíí holzeego hojíí doleeł, áídá’ nohwihíí daan’įįhíí bigową ádaagosolaa ląą. ");
INSERT INTO apwNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Begoz’aaníí ye’ik’eda’iłchíhi hik’e okąąh yebik’ehi itisyú nadaandeehi díí ya’ikodaanzįįdá’ hagot’éégo daabiziłheehíí ch’éh yaa natsídaakees: áídá’ bee yił ch’ígó’aahíí nṉee dawa bił díyadaagot’eehíí bighą yédaaldzid lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Áídí’ o’i’ą́ą́yú kįh gozṉildí’ onádzaa. ");
INSERT INTO apwNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","T’ahbįyú ch’il fig o’áhi n’íí naach’okahgo bikeghadí’ náhesgągo daayiłtsąą lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jesus áṉíí n’íí Peter yénálṉiihgo gáyiłṉii, NohweBik’ehń, isąą, ch’il fig doo nant’ą́ą́ át’éé da biłnṉii n’íí náhesgą ląą. ");
INSERT INTO apwNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus gádaabiłṉii, Bik’ehgo’ihi’ṉań baa daahohłíígo daahohdląą. ");
INSERT INTO apwNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Da’aṉii gádaanohwiłdishṉii, Dahadíń díí dził bich’į́’ hadziigo, Yúwehégo dihi’ṉáhgo túnteel biyi’ oni’dolné’, yiłṉiiyúgo, ła’íí bijíí biyi’dí’ doo bił nagoki dago, áídá’ áṉííhíí begolṉe’ yodląąyúgo, da’áṉííhíí k’ehgo bá ádolṉííł. ");
INSERT INTO apwNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Áí bighą gádaanohwiłdishṉii, Dant’éhéta da’ohkąąhgo daahohkeedíí nohwaa do’né’go daahohdląą, áík’ehgo nohwaa hi’né’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ła’íí dahayú nasozįįgo da’ohkąąhgee dahadíń nohwil dahgoz’ąą lę́k’eyúgo baa nágodenoh’aah; áík’ehgo nohwiTaa yaaká’yú dahsdaahíí doo bik’ehyú ádaanoht’ee dahíí nohwaa nágode’aah ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Áídá’ doo baa nádaagodeso’ąą da lę́k’eyúgo, nohwiTaa yaaká’yú dahsdaahíí ałdó’ doo bik’ehyú ádaanoht’ee dahíí doo nohwaa nágode’aahi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Áídí’ Jerúsalemyú naanákai: áígee da’ch’okąąh goz’ąą yuṉe’ Jesus anádaałgo okąąh yebik’ehi itisyú nadaandeehi, begoz’aaníí ye’ik’eda’iłchíhi ła’íí Jews yánazíni baa hikaigo, ");
INSERT INTO apwNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Gádaabiłṉii, Hadíń bik’ehgo ánánt’įįł? Hadíń naa godin’ą́ą́go ánt’įįh? ");
INSERT INTO apwNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus gádaabiłṉii, Shíí ałdó’ dała’ándi nanohwídishkid, shił nadaagołṉi’yúgo, shíí ałdó’ hadíń bik’ehgo ánásht’į́į́łíí nohwił nagoshṉi’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ya’ John baptize ádaagole’íí yaaká’ dí’go née, dagohíí nṉee bits’ą́’dí’go née? Shił nadaagołṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Łił yádaałti’go gádaałiłdi’ṉii, Yaaká’dí’go daan’ṉiihyúgo, gánohwiłṉiih, Áídá’ nt’é bighą doo daahohdląą da láń? ");
INSERT INTO apwNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Áídá’, Nṉee bits’ą́’dí’go daan’ṉiihyúgo nṉee bédaahildzid, nṉee dawa John da’aṉii Bik’ehgo’ihi’ṉań binkááyú na’iziidi nlįį n’íígo yídaagołsįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Áík’ehgo Jesus gádaayiłṉii, Néé doo baa nadaagohiilṉi’da. Jesus gánábiłdo’ṉiid, Shíí ałdó’ hadíńbik’ehgo ánásht’įįłíí doo nohwił nagoshṉi’ da. ");
INSERT INTO apwNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesus iłch’ígót’aahgo na’goṉi’íí bee bich’į’ yádaałti’ nkegonyaa. Ła’ nṉee dahts’aa k’eidnláádá’ yiṉaayú ná’nezṉil, dahts’aa hahigęęs doleełgee yá ogogéed, biká’dí’ idést’iiníí ágólaa, ła’íí bá yiṉádaadéz’íni yá ch’ígohet’ąądá’ ńzaadyú ni’ goz’ąąyú óyáá. ");
INSERT INTO apwNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Da’nest’ąągee ngonyáágo bána’iziidi bidahts’aa bá yiṉádaadéz’íni yich’į’ oyił’a’, binest’ą’ ła’ bá náyíné’go. ");
INSERT INTO apwNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Áídá’ bił ndaazdeelgo nyída’eshtłizhdá’ dádílkǫǫhgo onádais’a’. ");
INSERT INTO apwNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Áídí’ bána’iziidíí ła’ihi onaayíł’a’; áń bitsits’in yiṉída’desṉih, ła’íí nchǫ’go ánádaabił’įįdá’ áń ałdó’ onádais’a’. ");
INSERT INTO apwNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Áídí’ ła’ onaayíł’a’; áń daizes‐hį́į́; áídí’ da’áík’ehgo łą́ą́go odaihes’a’, ła’ nyída’eshtłizh, ła’ihíí nadaistseed. ");
INSERT INTO apwNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Áídá’ dała’á ná’godzii lę́k’e, biye’ bił nzhóni, áń da’iké’yú oyił’a’, Shiye’ daidnłsį doleeł, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Áídá’ bidahts’aa yiṉádaadéz’íni gádaałiłdi’ṉii, Díí dahts’aa hentííníí bíyéé doleełíí át’éé, yushdé’, daazoldee, áík’ehgo bíyéé doleeł n’íí daanohwíyéé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Áík’ehgo yił ndaazdeelgo daizes‐hį́į́dá’ dahts’aa hentį́į́dí’ ch’ídaist’e’. ");
INSERT INTO apwNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Áídá’ dahts’aa hentííníí bíyééhíí hago ádaabile’shą’? Áń nádáhgo dahts’aa bá yiṉádaadéz’į́į́ n’íí naiłtseedá’ dahts’aa hentííníí ła’ihi yá ch’ínágohet’aah. ");
INSERT INTO apwNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Díínko Bik’ehgo’ihi’ṉań biyati’ bek’e’ eshchiiníí doo hwahá daahohshiih da née: Tséé kįh ádaagole’íí yó’odaisṉe’i n’íí, hagon’áágee dantsé si’aaníí silįį; ");
INSERT INTO apwNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Díí nohweBik’ehń bik’ehgo ánágot’įįł, áí daanéel’įįgo nohwił díyadaagot’ee, ṉiihíí daahohshíí née? ");
INSERT INTO apwNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Áídí’ Jesus ha’ádaiłt’e’ hádaat’įį ndi nṉee łáni yédaaldzid, iłch’ígót’aahgo na’goṉi’íí bíí ádaabiłṉiigo yídaagołsį lę́k’ehíí bighą; áík’ehgo bits’ą́’ okai. ");
INSERT INTO apwNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Áídí’ ła’ Phárisees daanlíni, ła’ Hérod yił daagot’íni biłgo Jesus bich’į’ odaach’is’a’, yałti’gee daabihiljizh, daabich’o’ṉíígo. ");
INSERT INTO apwNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Áí baa hikaigo gádaabiłṉii, Iłch’ígó’aahíí, da’aṉii ánṉiigo, nṉee doo béníldzid dago yáńłti’go bídaagonlzį; nṉee doo ła’ itisgo síńłtįį da, áídá’ Bik’ehgo’ihi’ṉań bich’į’zhiṉéégo goz’aaníí da’aṉiigo baa iłch’ígóń’aah. Ya’ Caesar bich’į’ tax nadaach’iṉiiłgo begoz’ąą née? Née dah née? ");
INSERT INTO apwNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bich’į’ nadaahii’ṉiił née, née doo bich’į’ nadaahii’ṉiił da née? Áídá’ daazhógo ádaaṉiigo Jesus yígółsįgo gádaabiłṉii, Nt’é bighą yashti’íí bee daashołjizhgo ádaashiłdohṉii? Zhaali ła’, penny holzéhi, shaa noh’aahgo nesh’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Áík’ehgo ła’ baa daiz’ąą. Jesus gádaabiłṉii, Hadíń be’ilzaa, hadíń bizhi’ biká’ dahgoz’ąą? Caesar bíyéhi ląą, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Áík’ehgo Jesus gádaabiłṉii, Caesar bíyééhíí Caesar baa daanohṉiił, áídá’ Bik’ehgo’ihi’ṉań bíyééhíí Bik’ehgo’ihi’ṉań baa daanohṉiił. Áígee nṉeehíí bił díyadaagot’ee lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Áídí’ ła’ Sádducees daanlíni, nanezna’ n’íí doo naadikáh da daaṉihi, Jesus yaa hikaigo nayídaadiłkidgo gádaaṉii, ");
INSERT INTO apwNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Iłch’ígó’aahíí, Moses gáṉíígo nohwá k’e’eshchįį lę́k’e. Ła’ nṉee bik’isn bi’aa yits’ą́’ daztsąąyúgo, bichągháshé doo ła’ dayúgo, nṉeehíí bik’isn n’íí bi’aa yił nnádo’ṉeełgo bik’isn n’íí chągháshé bá ágodolṉiił, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Łah nṉee iłk’isn gosts’idi daanlįį lę́k’e, áí dantséhíí nṉáágo bichągháshé doo ła’ dago daztsąą. ");
INSERT INTO apwNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bik’isn nakigeehíí yił nnaná’ṉáágo dananástsą́ą́, bichągháshé doo ła’ dago; taagigeehíí da’ágánánádzaa. ");
INSERT INTO apwNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Iłk’isyú gosts’idíí dawa nanezna’, bichągháshé doo ła’ dago. Dá’iké’yú isdzánhíí ałdó’ daztsąą. ");
INSERT INTO apwNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Áík’ehgo nanezna’dí’ naach’idikáhgee hadíí bi’aa doleeł? Iłk’isyú gosts’idihíí dawa yił nadaazṉaadá’. ");
INSERT INTO apwNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus gádaabiłṉii, Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí dagohíí Bik’ehgo’ihi’ṉań binawodíí doo bídaagonołsį dahíí bighą da’ołsiih shį ya’? ");
INSERT INTO apwNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Naach’idikáhgee doo nnádaach’iłse’ da, doo ndaagoch’ihiṉiiłgo nnádaach’iłse’ da; áídá’ Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí k’ehgo daagoch’ilį́į́. ");
INSERT INTO apwNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Áídá’ ya’ Moses binaltsoos biyi’dí’ áṉííhíí k’ehgo nanezna’íí naadikáhíí doo hwahá baa daahohshiih da née? Ch’il biyi’dí’ Bik’ehgo’ihi’ṉań Moses gáyiłṉii, Shíí Abraham yokąąhíí nshłįį, Isaac, Jacob ałdó’ yokąąhíí nshłįį. ");
INSERT INTO apwNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bik’ehgo’ihi’ṉań doo nanezna’íí yokąąhń nlįį da, daahiṉaahíí zhą́: áígee nohwíí dázhǫ́ da’ołsiih. ");
INSERT INTO apwNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Begoz’aaníí ye’ik’eda’iłchíhi dała’á nṉeehíí Jesus yił łahadaadit’áhgo yidezts’ąądá’ Jesus goyą́ą́go t’ąązhį’ yich’į’ hadziigo yígołsįįdá’ nayídiłkid gáṉíígo, Bik’ehgo’ihi’ṉań yegos’aaníí hadíí itisgo at’éé? ");
INSERT INTO apwNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus gábiłṉii, Dantsé begoz’aaníí díínko, Israel hat’i’íí daanohłíni, ídaayesółts’ąą; Bik’ehgo’ihi’ṉań nohweBik’ehń Nant’án dała’á nlįį; ");
INSERT INTO apwNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bik’ehgo’ihi’ṉań neBik’ehń nijíí dawa bee nił nzhǫǫ le’, niyi’siziiníí dawa bee, ninatsekeesíí ła’íí ninawodíí dawa bee; áí dantségee begoz’aaníí át’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nakigeehíí ágánánát’éé, Nit’ahdí’ gólííníí nił nzhǫǫ le’, dáni ídił njǫ́ǫ́híí k’ehgo. Díí begoz’aaníí bitisgo at’ééhíí doo ła’ da. ");
INSERT INTO apwNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","K’e’iłchiihíí gábiłṉii, Bik’ehgo’ihi’ṉań dała’á nlįį, nṉiihíí da’aṉii ánṉii, Iłch’ígó’aahíí, ba’ashhahíí doo ła’ da, dabíí zhą́: ");
INSERT INTO apwNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Áń kojíí dawa bee koł nzhǫǫgo, konatsekeesíí dawa bee, koyi’siziiníí ła’íí konawodíí dawa bee, ła’íí kot’ahdí’ gólííníí koł nzhǫǫgo, dakó ídił ch’ijǫ́ǫ́híí k’ehgo, áí okąąhgo Bik’ehgo’ihi’ṉań bich’į’ nch’ihiṉiiłíí dawa didlidíí, ła’íí natseedíí Bik’ehgo’ihi’ṉań bich’į’ nch’ihiṉiiłíí dawa bitisgo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","K’e’iłchiihíí góyą́ą́go hadziigo Jesus yígołsįįdá’ gábiłṉii, Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí k’azhą́ itah nleeh ląą. Áí bikédí’go nṉee daaste’go doo hadíń nabínáńłkid da. ");
INSERT INTO apwNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus da’ch’okąąh goz’ąą yuṉe’ iłch’ígó’aahgo gáṉíí, Hagot’éégoshą’ begoz’aaníí ye’ik’eda’iłchíhi Christ David biye’ nlįį, daaṉii? ");
INSERT INTO apwNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David dabíí Holy Spirit yábiyiłti’go gáṉíí, Bik’ehgo’ihi’ṉań sheBik’ehń gáyiłnṉiid, Shigan dihe’nazhiṉéégo síńdaa, ni’ina’ ni’isna’ ashłe’go nikełtł’ááhyú niṉílzhį’. ");
INSERT INTO apwNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David dabíí sheBik’ehń biłṉiigo bozhíí; hagot’éégoshą’ biye’ nlįį áídá’? Áígee nṉee łą́ą́go bił daagozhǫ́ǫ́go daidezts’ąą lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus iłch’ígó’aahgee gáṉíí, Begoz’aaníí ye’ik’eda’iłchíhi baa daagonohsąą, áí bidiyágé daanṉeezihi daagolį́į́go nakaigo, ła’íí na’hiṉiih nadaagoz’ąąyú bich’į’ ádaach’iṉiigo bił daanzhǫǫ, ");
INSERT INTO apwNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jews ha’ánáłséh nagozṉil yuṉe’ nṉee yánazíni dahnádinbįhyú itah dahnanáztąągo, ła’íí da’idąągee nṉee ízisgo ádaat’eehíí dahnádinbįhyú itah dahnaháztąągo ałdó’ bił daanzhǫǫ: ");
INSERT INTO apwNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Áí isdzáné itsaa daanlíni bigową́ yits’ą́’ nádaagohi’aa, ła’íí daazhógo ádaaṉiigo ńzaad gont’i’go da’okąąh: áí itisgo biniigonłt’éégo bándaagodot’aał. ");
INSERT INTO apwNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus zhaali biyi’ ohilkaadíí bit’ahgee dahnezdaa, nṉee áí biyi’ yuyaa bizhaali odaayihiłkaadgo yineł’į́į́go: nṉee łą́ą́go hádaałdzilíí bizhaali doo ałch’ídé odaayihiłkaad da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Áídá’ isdzán itsaa nlíni tét’iyéhi ákú ńyáágo zhaali naki doo ílínihi da oyiłkaad, áí nakigo zhaaliłché’é ílį́į́. ");
INSERT INTO apwNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Áík’ehgo Jesus bitsiłke’yu yiká ánṉiidgo gádaayiłṉii, Da’aṉii gádaanohwiłdishṉii, Áí itsaa tét’iyéhíí nṉee dawa zhaali odaiheskaadíí bitisgo zhaali oyiłkáad: ");
INSERT INTO apwNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nṉee hádaałdzilíí bizhaali dáłahzhį́’ zhą́ odaiheskaad, áídá’ bííhíí tét’iyé ndi bizhaali da’áí zhą́ yee golíni n’íí oyiłkáad. ");
INSERT INTO apwNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Áídí’ Jesus da’ch’okąąh goz’ąądí’ ch’ínyáágo, bitsiłke’yu dała’á gábiłṉii, Iłch’ígo’aahíí, díń’įį, tséé ntso ląą nłt’éhi, ła’íí kįh ntso ląą gonłt’éhi gozṉil! ");
INSERT INTO apwNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus gábiłṉii, Ya’ díí kįh ízisgo ádaagoszaahíí hí’į́į́ née? Díí tséé iłká’ dahnagozṉilíí doo ła’ iłká’ dahnast’ą́ą́ da doleeł, dawa nanehiłkaad doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Áídí’ da’ch’okąąh goz’aaníí hanaayú dził Olives holzéhi biká’yú Jesus dahsdaago, Peter, James, John hik’e Andrew biłgo zhą́ nabídaadiłkid, gádaaṉiigo, ");
INSERT INTO apwNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Nohwił nagolṉí’, da’os’ah ágoṉéhi? Dawa be’ágoṉe’go hant’é bee bígózį doleeł? ");
INSERT INTO apwNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus gádaabiłṉii godeyaa, Ídaa daagonohdząą, nṉee ła’ ch’a’onohołt’e’ hela’: ");
INSERT INTO apwNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nṉee łą́ą́go shizhi’ yee daahikáh doleeł, Shíí Christ nshłįį, daaṉiigo; áí nṉee łą́ą́go ch’a’odaayiłkaad doleel. ");
INSERT INTO apwNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nagonłkaadíí ba’ikodaanohsį, ła’íí nagonłkaadíí baa ch’iṉiigo daadohts’agdá’, doo nohwijíí natsídaahiltǫ’ da le’; áí dawa begolṉe’hi at’éé ndihíí t’ah doo hwahá nnágodáh da. ");
INSERT INTO apwNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nṉee iłtah at’éégo hadaazt’i’íí iłch’į’ nanágonłkaad doleeł, ła’íí nṉee dala’á binant’a’ daagolínihíí ałdó’ iłch’į’ nanágonłkaad doleeł: da’adzaayú ni’ nagohi’naa doleeł; shiṉá’ góyééhíí benagowaa doo, ła’íí nyé’i daats’idits’ag doleeł: áí koniidaagonłt’ééhíí begodigháh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Áídá’ ídaa daagonohdząą: yánádaaltihíí yaa nádaanohwide’aah doleeł; Jews ha’anáłséh nagozṉil yuṉe’hanohwínáda’iłtsas doleeł; ła’íí nant’ánchań hik’e ízisgo nant’án daanliiníí daabiṉááł shaa yádaałti’go biyahzhį’ nadaasozįį doo. ");
INSERT INTO apwNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yati’ baa gozhóni nṉee iłtah at’éégo hadaazt’i’íí dawa ntsé bił na’goṉi’ ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nohwaa yá’iti’yú bił desohkaigo yánádaaltihíí yaa daanohwidez’ąąyúgo, doo hwahá hadaahdziih dadá’ nt’éshą’ dishṉiih doo daanohsį da, ła’íí doo nohwiini’ łą́ą́ da le’: áídá’ daazhógo nohwaa hi’né’íí baa hadaahdziih, da’áí bik’ehenkéézgee: doo dánohwíí yádaałti’ da, Holy Spirit nohwiláhyú yałti’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nṉee ła’ bik’isn zideeyú nyiiłtéeh doleeł, ła’íí nṉee ła’ biye’ ágáyidoliił; chągháshé bitaa, bą́ą́ biłgo yich’į’ nanáda’idziidgo, ádaaṉiigo nabi’ditseed doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Shizhi’ bee daanohwich’ozhííhíí bighą nṉee dawa bił daanohchǫ’ doleeł; áídá’ dahadíń dángont’i’zhį’ dahildǫhíí hasdábi’dolteeł. ");
INSERT INTO apwNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Áík’ehgo gołchǫǫhgo o’ṉí’ihíí, Bik’ehgo’ihi’ṉań binkááyú na’iziidi Daniel holzéhi yaa yałti’ n’íí, doo bágoz’ąą dagee sizįįgo daah’įįdá’, (dahadíń áí yózhííhíí bił ígózį le’,) hadíí Judéa golzeeyú daagolííníí dził naz’aaníí yich’į’ okeeh doo. ");
INSERT INTO apwNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dahadíń bikįh biká’yú dahsdaahíí gódah ch’ínádáhgo bikįh yuṉe’ ha’awáh hela’, nt’éhéta náidiiné’go. ");
INSERT INTO apwNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ła’íí dahadíń k’edolzaahíí yiyi’ na’iziidíí t’ąązhį’ bidiyágé yaa nánódáh hela’. ");
INSERT INTO apwNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Áígee goldohíí daaltsaaníí ła’íí isdzáné mé’ daabiłbe’íí bá góyéé doleeł! ");
INSERT INTO apwNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Haihíí biyi’ ágóṉéh hela’, daadohṉiigo da’ohkąąh. ");
INSERT INTO apwNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Áígee goldohíí Bik’ehgo’ihi’ṉań dawahá áyíílaadí’ godezt’i’go díí jįįzhį’ goyéégo nagowaahíí áí ga’at’éhi doo hwahá be’ágoṉe’ da, áí doo be’ágánágo’ṉéh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Áígee goldohíí nohweBik’ehń doo dé’igodégo áyíílaa dayúgo, nṉee doo ła’ hasdáwáh át’éé da: áídá’ nṉee bitahasdlaahíí, dabíí yitahezlaahíí bighą áígee goldohíí dé’igodégo áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Áígee nṉee ła’, Daadeh’į́į́, Christ kú naghaa; dagohíí, Daadeh’į́į́, nlahyú naghaa, nohwiłṉiiyúgo, doo daahohdląą da: ");
INSERT INTO apwNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Christ ádaadil’iiníí ła’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi ádaadil’iiníí hahikáh doleeł, áí godiyįhgo be’igóziníí ch’i’ṉah ádaile’, ła’íí ízisgo áńda’ol’įįh doleeł, yídaanel’ąąyúgo áí bee nṉee bitahasdlaahíí ndi ch’a’odaiłkaad doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Áík’ehgo ídaa daagonohdząą: ídaayesółts’ąą, iłk’idá’ dabíntsé dawa baa nohwił nagosisṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Áí benagowaadá’, goyéégo nagoyaahíí bikédí’go ya’áí diłhił doleeł, tł’égona’áíhíí doo bee got’įį da doleeł, ");
INSERT INTO apwNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ts’iłsǫǫsé yáádí’ nanihidéh doleeł, ła’íí yáázhį’go inawodíí nagohi’naa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Áígee shíí, nṉee k’ehgo Niyááhíí, shinawodíí bee, ła’íí dázhǫ́ shits’ą́’idindláádgo yaak’os biyi’dí’ náshdaałgo daashidołtseeł. ");
INSERT INTO apwNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Áídá’ shinadaal’a’á yaaká’dí’ ohish’aa doleeł, bitahelááhíí dį́į́dí’, ni’gosdzáń nel’ąądí’ yáá nel’ąązhį’ íł íła’ádaile’. ");
INSERT INTO apwNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ch’il fig holzéhi bits’ą́’dí’ nohwił ch’igót’aah; bits’ádaaz’aahíí dit’ódé daaleehdí’ bit’ąą daagoleehyúgo k’ad shį́į́ nágodleehgo bídaagonołsį: ");
INSERT INTO apwNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Da’áík’ehgo áí be’ádaagoṉe’íí goldohgo daah’įįdá’, k’ad náshdaałzhį’ ałhánégo godziihgo bídaagonołsį́: ");
INSERT INTO apwNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Da’aṉii gánohwiłdishṉii, díí daałinolt’įįłíí doo nohwee ch’ígoṉáh da, díí ádaanohwiłdéṉiidíí dawa begolzaago zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yáá hik’e ni’gosdzáń biłgo bech’ígoṉáh doleeł; áídá’ shiyati’íí doo bech’ígowáh da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Hadíí bijįį shįhíí dagohíí da’kwíí bik’ehenkéézgo shįhíí ágoṉe’íí nṉee doo la’ yígólsį da, Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí ła’íí biYe’ ndi doo yídaagołsį da, shiTaa zhą́ yígółsį. ");
INSERT INTO apwNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Da’os’ah begoṉáh shįhíí doo bídaagonołsį dahíí bighą ídaa daagonohdząą, biká nádaadeht’į́į́h, ła’íí da’ohkąąh. ");
INSERT INTO apwNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Shíí, nṉee k’ehgo Niyááhíí, nṉee ła’ bigową yits’ą́ dahiyaago łahyú óyááhíí k’ehgo ánsht’ee; áń bánada’iziidíí bíyéé gólííníí yebik’ehgo áyíílaa, dała’á daantį́į́gee binasdziid golį́į́go; ła’íí dáádítį́h yaasidaahíí nádét’įįhgo yángon’ ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Áik’ehgo nádaadeht’įįh: bikįh golííníí da’os’ah nadáh doleełíí doo bídaagonołsį da, o’i’ą́ą́go shį, tł’é’ís ahgo, tazhik’áné ádaaṉiigo, dagohíí t’ahbį shį nadáh doleeł: ");
INSERT INTO apwNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Doo nádaadeht’į́įh dayúgo dahį́ko nádaałgo da’ołhoshgo nohwiká niigháh. ");
INSERT INTO apwNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ádaanohwiłdishṉiihíí da’áí nṉee dawa ádaabiłdishṉii, Nádaadeht’į́į́h. ");
INSERT INTO apwNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bitis‐hagowáh n’íí bee bíná’goṉiihgo da’idąązhį’, ła’íí báń benilzoołé da’ádįhgo báń alzaahi daadąązhį’ naki yiłkaah godziih: okąąh yebik’ehi itisyú nadaandeehi, begoz’aaníí ye’ik’eda’iłchíhi biłgo hagot’éégo dánant’į’eego Jesus daayiłtsoodgo daayiziłheego yee ndaagoshchįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Áídá’, Doo da’idąąhíí bijįį daahiiltsood da, nṉee dánko bádaagochįįhgo godnch’aad doleełhi at’ééhíí bighą, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Béthanyú Simon, łóód doo ínádįh dahi leprosy holzéhi yaa naghaa n’íí, bigową yuṉe’ Jesus iyąągo sidaadá’, isdzán ła’, ch’il bik’ah spikenard holzéhi łáń ílíni, tús alabáster bee alzaahi besi’áni ha’áyí’ą́ą́go baa nyáá; áídí’ tús bidá’gee yists’iłgo ik’ahíí Jesus bitsits’in yiká’ yaa yiziid lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Áígee ła’ doo bił dábik’eh dago gádaałiłdi’ṉii, Nt’é bighą ik’ahíí da’ílíí yishchįį? ");
INSERT INTO apwNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ik’ahíí taadn gonenadín zhaali, penny holzéhi, bitisyú izlįįgo nahazṉii láńshį n’íí zhaalihíí tédaat’iyéhíí bitahi’ṉiih le’at’éhi, daaṉii. Áík’ehgo isdzánhíí yída’iłtah lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Áídá’ Jesus gáṉíí, Doo nt’é daabiłdohṉii da; hant’é bighą nadaanołtł’og? Nłt’éégo áshíílaa. ");
INSERT INTO apwNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tédaat’iyéhíí dabik’ehn nohwitahyú nadaakai, áí hádaaht’įįgee nłt’éégo ádaał’įį doleeł: áídá’ shihíí doo dahazhį’ nohwitahyú nashaa da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yínel’ąąhíí ąął łayiilaa: doo hwahá łeeh shi’dilteeh dadá’ ik’ahíí shits’í yiká’ yaa yiziid. ");
INSERT INTO apwNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Da’aṉii gádaanohwiłdishṉii, Ni’gosdzáń dágoz’ąą nt’éégo dahayú yati’ baa gozhóni bee na’goṉi’gee, díí isdzán adzaahíí baa na’goṉi’ doleeł, bee bíná’godiṉíhgo. ");
INSERT INTO apwNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Áídí’ Judas Iscáriot, nakits’ádahíí itah nlíni, okąąh yebik’ehi itisyú nadaandeehi yaa nyáá, Jesus ch’íyí’aah doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Áí daidezts’ąądá’ bił daagozhǫ́ǫ́ lę́k’e, áík’ehgo Judas zhaali yaa daayiné’go yándaagoz’ąą. Áídí’ hagot’éégo Jesus ch’íyí’aahíí yiká déz’įį. ");
INSERT INTO apwNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Báń benilzoołé da’ádįhgo báń alzaahi daadaaníí, Bitis‐hagowáh n’íí bee bíná’goṉiihgee dibełį́į́ zhaazhé zesdįįdá’, bitsiłke’yu Jesus gádaayiłṉii, Bitis‐hagowáh n’íí bee bíná’godiṉíhgo da’idaaníí hayú ná iłch’į’daagohiidle’? ");
INSERT INTO apwNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Áídí’ bitsiłke’yu naki oyił’a’, gáyiłṉiigo, Ti’i, kįh gozṉilyú doh’aash, áígee nṉee ła’ tús tú beyo’áłi nohwaa hiṉáh doleeł: áń biké’doh’aash. ");
INSERT INTO apwNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Dahayú ha’ayááyú, nṉee bigową golííníí gábiłdohṉiih, Iłch’ígó’aahíí gániłṉii, Gosta’ nakaahíí hayú bágoz’ąą, ákóṉe’ bitis‐hagowáh n’íí bee bíná’godiṉíhgo shitsiłke’yu bił da’ishąą doleeł? ");
INSERT INTO apwNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Áík’ehgo ik’ehyú dahnágost’ąą yuṉe’, iłk’idá’ dawa siṉili, nohwiba’ goz’ąąyú bił nkáh doleeł: ákóṉe’ nohwá iłch’į’gohłe’. ");
INSERT INTO apwNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Áídí’ bitsiłke’yu dahizh’aazhgo kįh gozṉilyú ó’áázh, ákú Jesus da’ádaabiłṉii n’íí k’ehgo yaa n’áázh: áígee bitis hagowáh n’íí bee bíná’godiṉíhgo da’idaaníí iłch’į’daizlaa. ");
INSERT INTO apwNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Áídí’ o’i’ą́ą́yú Jesus nakits’ádahíí yił hikai. ");
INSERT INTO apwNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Áígee da’iyąągo naháztąądá’ Jesus gáṉíí, Da’aṉii gánohwiłdishṉii, Nohwíí ła’ ch’íshinoh’aah doleeł, hadíń bił dała’ ishaaníí. ");
INSERT INTO apwNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Áík’ehgo doo bił daagozhǫ́ǫ́ dago dała’á daantį́į́go, Ya’ shíí née? daabiłṉii nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus gádaabiłṉii, Nakits’ádah daanohłiiníí dała’á, hadíí its’aa biyi’zhį’ dała’ bił éédisht’áhi. ");
INSERT INTO apwNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Shíí, nṉee k’ehgo Niyááhíí, dá shaa k’e’eshchiiníí shee godolṉiił: áídá’ nṉee ch’íshí’aahíí bá góyéé doleeł! Áí nṉeehíí doo bi’deshchįį dayúgo bá nłt’éé doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Da’iyąągo Jesus báń náidn’ąągo ya’ihénzįgo oskąądá’ iłk’ídaizné’go bitsiłke’yu yitaizṉiih, Nkóh, daohsąą: díí shits’í át’éé, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Áídí’ idee beda’iskaaníí náidnkąą, áí ya’ihénzigo oskąądá’ iłtah daizkąągo dawa daayodląą. ");
INSERT INTO apwNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesus gádaabiłṉii, Díínko shidił nṉee łą́ą́go bá idijoołíí bee áníidégo Bik’ehgo’ihi’ṉań hik’e nṉee biłgo łángont’aahi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Da’aṉiigo gádaanohwiłdishṉii, Kodí’ godezt’i’go dahts’aa bitoohíí doo naanáshdlą́ą́ da, dahadíí bijįį Bik’ehgo’ihi’ṉań bilałtł’áhgee goz’ąąyú áníidéhi naadishdląąłgo zhą́. ");
INSERT INTO apwNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Áídí’ sį ła’ hadaidez’ąądá’, dził Olives holzéhi si’ąąyú okai. ");
INSERT INTO apwNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Áígee Jesus gádaabiłṉii, Tł’é’go áshi’dilṉe’híí bighą daanohwigha t’ąązhį’ ádaahṉe’: díí baa k’e’eshchiiníí k’ehgo, Dibełį́į́ Nanyoodíí biṉí’dishṉíh, áík’ehgo dibełį́į́híí da’adzaayú nkenelt’ee doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Áídá’ dasiitsą́ą́dí’ naadisdzaago Gálileeyú nohwádįh disháh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter gábiłṉii, Nṉee dawa nits’ą́’ t’ąązhį’ ánádaasdzaa ndi, shíí doo ágáoshṉe’ at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus gánábiłdo’ṉiid, Da’aṉiigo gániłdishṉii, Tł’é’go tazhik’áné doo hwahá nakidn áṉiih dadá’ taadn, Áń doo bígonsį da, shiłdinṉíił. ");
INSERT INTO apwNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Áídá’ Peter nawode gábiłṉii, Dała’ nił dastsaah ndi, Áń doo bígonsį da, doo niłdoshṉiih at’éé da. Ła’ihíí bitsiłke’yu dawa da’áík’ehgo ádaanṉiid. ");
INSERT INTO apwNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Áídí’ Gethsémane golzéhi goz’ąąyú hikaidá’ Jesus bitsiłke’yu gádaayiłṉii, Dádząą nahísóotąą, oshkąąhyú déyáádá’. ");
INSERT INTO apwNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Áídí’ Peter, James, ła’íí John yił okai, áígee Jesus dázhǫ́ doo bił gozhǫ́ǫ́ dago bijíí nṉiih nkegonyaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Áík’ehgo gádaabiłṉii, Shiyi’siziiníí dázhǫ́ doo bił gozhǫ́ǫ́ da, dák’azhą́ dastsaahíí ga’at’éé; dádząą nahísóotąągo daadeh’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Áídí’ da’aṉahyú óyááyú ni’zhį’ adzaadá’ okąąh, gáṉíígo, Bígonedząąyúgo, díí shich’į’ begodigháhíí shits’ą́’zhį’ begodogaał. ");
INSERT INTO apwNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Gánádi’ṉii, Ábba, shiTaa, doo nt’é ná nyee da; díí hishdląą doleełíí shits’ą́’zhį’ ánle’: áídá’ shíí doo beshik’eh da, ni zhą́ benik’eh. ");
INSERT INTO apwNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Áídí’ bitsiłke’yu dá’iłhoshgo yaa nadzaa, áík’ehgo Peter gáyiłṉii, Simon, iłhosh née? Dała’á łedihikeezzhį’ ndishą’ doo díń’įį le’ágot’ee da née? ");
INSERT INTO apwNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Daadeh’į́į́go da’ohkąąh, nanohwída’dintaah bídaanołdzil doleełhíí bighą. Nohwiyi’siziiníí da’aṉii hat’į́į́ ndi nohwits’íhíí doo nłdzil da. ");
INSERT INTO apwNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Áídí’ onaanádzaayú da’ágánádi’ṉiigo naa’okąąh. ");
INSERT INTO apwNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Áídí’ bitsiłke’yu da’iłhoshgo yaa nánádzáá, (dázhǫ́ bił daanzįgo,) áígee hant’é daaṉiih shįhíí doo yídaagołsį da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Taadngee baa naanádzáágo gádaabiłṉii, Akú da’ołhoshgo hanádaahsoł gádnii: shí k’adí’, shíí, nṉee k’ehgo Niyááhíí, nṉee doo bik’ehyú ádaat’ee dahíí bilák’e shi’dilteehgo ch’íshi’det’ąąhíí iłk’idá’ biká’ ngonyáá. ");
INSERT INTO apwNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nádohkáh, hiikaah le’: ch’íshí’aahíí kodí’ higaał. ");
INSERT INTO apwNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Dagoshch’į’ Jesus t’ah yałti’dá’, Judas, nakits’ádahíí bił itah nlíni, nṉee łą́ą́go bésh be’idiltłishé ła’íí tsį be’idiltłishé dahdaayiṉííłgo okąąh yebik’ehi itisyú nadaandeehi, begoz’aaníí ye’ik’eda’iłchíhi, ła’íí Jews yánazíni daabides’a’íí yił náłsą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ch’íbí’aah doleełíí iłk’idá’ bebígózį doleełíí yengon’ą́ą́ lę́k’e, gáṉíígo, Hadíń hists’ǫsíí áń doleeł; daahołtsoodgo biṉádaadeh’į́į́go bił dohkáh. ");
INSERT INTO apwNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Áík’ehgo Judas ákú ńyáágo dagoshch’į’ Jesus yich’į’ daheswodgo, Iłch’ígó’aahíí, Iłch’ígó’aahíí, yiłṉiigo yizts’ǫs. ");
INSERT INTO apwNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Áídí’ Jesus yił ndaazdeelgo daayiłtsood. ");
INSERT INTO apwNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Áídá’ bit’ahgee naziiníí dała’á bibéshbe’idiltłishé hayidzį́į́zgo okąąh yebik’ehi da’tiséyú sitíni binal’a’áhi yontłízhgo bijaa naidnłgizh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Áídí’ Jesus nṉee baa nánłsąąhíí gádaayiłṉii, Ya’ bésh be’idiltłishé ła’íí tsį be’idiltłishé dahdaanohṉiiłgo daashołtsoodgo nánołsąą née, in’įįhíí daach’iłtsoodhíí k’ehgo? ");
INSERT INTO apwNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Dawa jįį la’ da’ch’okąąh goz’ąą yuṉe’ nohwił ch’ídaagonsh’aahgo nohwitah nashaa ni’ ndi doo hak’i daashołtsood da ni’: áídá’ Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí begolṉe’ doleełhíí bighą ánágot’įįł. ");
INSERT INTO apwNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Áígee bitsiłke’yu dawa bits’ą́’zhį’ ádaasdzaago bits’ą’ iłhadeskai. ");
INSERT INTO apwNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nṉee áníid nagháhihi nak’ą’łigaihi zhą́ binasti’go Jesus yiké’ itah higaał lę́k’e; áń nṉee áníid nakaiyéhi bił ndaazdeel: ");
INSERT INTO apwNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Áídá’ nak’ą’ binasti’ n’íí yiyi’ halwodgo dáłichiigo ch’a’olwod. ");
INSERT INTO apwNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nṉee Jesus daabiłtsoodíí okąąh yebik’ehi da’tiséyú sitíni yaa yił hikai: áígee okąąh yebik’ehi itisyú nadaandeehi, Jews yánazíni, hik’e begoz’aaníí ye’ik’eda’iłchíhi biłgo íła’adzaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter da’aṉahgo biké’dí’ higaał, áídí’ okąąh yebik’ehi da’tiséyú sitíni bikįh biṉaa łé’ditł’įįh yuṉe’ ha’ayáá: áígee kǫ’ diltłi’zhį’ aasiṉilíí yił naháztąą, nániiłdziiłgo. ");
INSERT INTO apwNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Okąąh yebik’ehi itisyú nadaandeehi ła’íí yánádaaltihi dawa Jesus zidee hádaat’įįgo, yaa dahgosi’aahíí yiká daadéz’įį ndi doo ła’ da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Łááni daazhógo ádaaṉiigo baa dahgo’aahgo baa yádaałti’ ndi doo ła’ łełt’ee da. ");
INSERT INTO apwNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Áígee nṉee ła’ daahizį’go łéda’iłchoogo baa yádaałti’, gádaaṉiigo, ");
INSERT INTO apwNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Áń gáṉíígo daadihiits’ag ni’, Díí kįh biyi’ da’ch’okąąhi nṉee áyíílaahíí taanágoshṉił, áídí’ taagi jįį hileehgo ła’ihíí nṉee doo áyíílaa dahíí ánágoshdle’, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gádaaṉii ndi doo łełt’eego ádaaṉii da. ");
INSERT INTO apwNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Áídí’ okąąh yebik’ehi da’tiséyú sitíni da’iłṉí’gee hizį’go Jesus nayídiłkidgo gáṉíí, Ya’ nihíí doo nt’é nṉiihgo hadziih da née? Díí naa dahgo’aahgo naa yádaałti’íí hago’at’éé? ");
INSERT INTO apwNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Áídá’ Jesus doo nt’é ṉii dago doo t’ąązhį’ hanádzii da. Okąąh yebik’ehi da’tiséyú sitíni nabínádiłkidgo, Ya’ ni Christ, Bik’ehgo’ihi’ṉań Dilzini biYe’ ńlį́į́ née? biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus, Ha’oh, áń nshłįį, ṉii: shíí nṉee k’ehgo Niyááhíí, Bik’ehgo’ihi’ṉań da’tiséyú binawod golíni bigan dihe’nazhiṉéégo dahsídáágo yaaká’dí’ yaak’os shił hoṉahgo daashidołtsééł. ");
INSERT INTO apwNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Áík’ehgo okąąh yebik’ehi da’tiséyú sitíni bidiyágé ídánayihesdzį́į́zdá’ gáṉíí, Nt’é bighą nṉee ła’i baa nanaagolṉi’ doleeł? ");
INSERT INTO apwNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bik’ehgo’ihi’ṉań nchǫ’go yaa yałti’íí daadisots’ąą: hagot’éégo baa natsídaahkees? Dawa gádaaṉii, Zideego bángonot’aah. ");
INSERT INTO apwNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Áídí’ ła’ bik’ídaadihizheeh nkegonyaa, ła’íí binii yináda’isti’dá’ nádainłts’į, Bik’ehgo’ihi’ṉań binkááyú yáńłti’yúgo, hadíń náninłts’į shįhíí nohwił nagolṉi’, daabiłṉiigo; ła’íí aasiṉilíí bitł’adaayika’ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter yúyahyú kįh biṉaa łedn’aahíí biyi’ yuṉe’ sidaadá’ isdzán, okąąh yebik’ehi da’tiséyú sitíni yána’iziidi, baa nyáá: ");
INSERT INTO apwNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Áń Peter kǫ’zhį’ nániiłdziiłgo yo’įįdá’, Ni la’ ałdó’ Jesus, Nazaréne nlíni, bił na’aash ni’, biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Áídá’, Dah, hant’é nṉiigo ánṉiihíí doo bígonsį da, ṉii. Áídí’ kįh bahgee ch’ínágohen’ą́ą́yú ch’ínyáá; áígee tazhik’áné ánṉiid lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Áígee isdzán na’iziidi naabiiłtsąą, áík’ehgo áígee naziiníí gáyiłṉii, Díí nṉeehíí áí itah nlįį. ");
INSERT INTO apwNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Áídá’, Dah, naado’ṉiid. Dét’įhék’e áígee naziiníí Peter gánádaayiłdo’ṉiid, Da’aṉii ni áí itah nlį́į́: Gálileedí’ gonlį́į́, áí yádaałti’híí k’ehgo yáńłti’. ");
INSERT INTO apwNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Áídá’ Peter bitł’a dahdidilṉiihgo hashkeego nchǫ’go yałti’ nkegonyaa gáṉíígo, Nṉee baa yádaałti’íí doo bígonsį da. ");
INSERT INTO apwNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nt’éégo tazhik’áné ánádo’ṉiid nakidngee. Peter Jesus gábiłnṉiid n’íí yénálṉiih, Tazhik’áné doo hwahá nakidn áṉiih dadá’ taadngee, Áń doo bígonsį da, shiłdinṉíił. Áí yaa natsekeesgo hichag lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hayiłką́ą́yú okąąh yebik’ehi itisyú nadaandeehi, Jews yánazíni, begoz’aaníí ye’ik’eda’iłchíhi, ła’íí yánádaaltihi dawa biłgo íła’adzaago Jesus yaa ndaagoshchįį, áídí’ łídaistł’ǫǫdá’ dahdainlǫ́ǫ́zgo Pílate yaa daidez’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Áígee Pílate Jesus nayídiłkid, Ya’ ni Jews ízisgo biNant’a’i ńlį́į́ née? Da’áígee ánṉii, biłṉii, Jesus. ");
INSERT INTO apwNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Okąąh yebik’ehi itisyú nadaandeehíí doo ałch’ídéyú baa dahgoz’ąą da; ndi doo nt’é ṉii da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","5","Áík’ehgo Pílate nabínádiłkid, Nihíí doo nt’é shiłnṉii da née? Doo ałch’ídéyú naa dahgost’ąą da ląą akoh. ");
INSERT INTO apwNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bitis hagowáh n’íí bee bíná’godiṉíhgo da’idąągee ha’áshijeedíí dała’á, hadíí nṉee hádaat’iiníí, Pílate bá ch’ínáyíłteeh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Áígee nṉee, Barábbas holzéhi, ha’ásitįį lę́k’e; áń nṉee nant’án agohet’aa nkegonyaago nada’iłtseedihi yił ha’áshijeed. ");
INSERT INTO apwNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Áík’ehgo nṉee Pílate yaa náńłsą́ą́go daadilwoshgo gádaayiłṉii, Da’ánál’įįhíí k’ehgo nohwá áńléh. ");
INSERT INTO apwNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ya’ Jews ízisgo biNant’a’ nohwá ch’ínánshteehgo hádaaht’įį née? biłṉii, Pílate. ");
INSERT INTO apwNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pílate yígółsį, nṉee dawa Jesus bił daanzhǫǫhíí bighą okąąh yebik’ehi itisyú nadaandeehíí Jesus yik’edaanṉiihgo baa daabidez’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Áídá’ okąąh yebik’ehi itisyú nadaandeehi nṉee łą́ą́go íła’adzaahíí biini’ yá ádaagozlaa, gádaayiłṉiigo, Barábbas nohwá ch’ínáńłteeh, daadohṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Áík’ehgo Pílate gánádaabiłdo’ṉiid, Jews ízisgo biNant’a’, daadohṉiigo daahohshíhishą’ hago ląą nohwá áshłéh áídá’? ");
INSERT INTO apwNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Áídá’ nnádaadidilghaazhgo, Tsį’iłna’áhi bíhołkałgo zodéé, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nt’é bighą, hant’é bee nchǫ’go adzaago? ṉii, Pílate. Áídá’ da’tiségo nanádaadidilghaazhgo, Tsį’iłna’áhi bíhołkałgo zodéé, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Áík’ehgo Pílate nṉeehíí yił daagoyiłshǫ́ǫ́ hát’į́į́go Barábbas bich’į’ ch’ínáinłtį́į́, áídá’ Jesus habí’oltsaazdá’ tsį’iłna’áhi bíhołkałgo zideego nṉeehíí yaa daidez’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Áídí’ silááda yáná’itih goz’ąą yuṉe’, Pretórium holzéhi, Jesus odaizt’e’; áígee silááda dawa baa íła’ádaizlaa. ");
INSERT INTO apwNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Áídí’ diyágé łichíígo dotł’izhi Jesus yá ádaagozlaadá’ hosh diwozhi nánihezwodgo nant’án bich’ah k’ehgo alzaahi bik’e daidez’ąą. ");
INSERT INTO apwNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Áídí’ daidnłsįgo ádaadil’įįgo, Gozhǫ́ǫ́, Jews ízisgo biNant’a’ ńlíni, daabiłṉiigo yaa daadilwosh nkegonyaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Áídí’ tsį bee bitsits’inyú nádainłtłish, áídí’ bik’ídaadihizheeh, áídí’ biyahzhį’ nádaahilzhishgo daayokąąh nádaadi’ṉiihé lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ąął baa daadlohdá’ diyágé łichiigo dotł’izh n’íí yaa daidnłtsoozdá’ dabíí bidiyágé yá ánádaagosdlaa, áídí’ tsį’iłna’áhi yiká’ daiziłheeyú bił nádeząą. ");
INSERT INTO apwNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nṉee ła’, Simon holzéhi, Alexánder hik’e Rúfus bitaahi, Cyréne golzeedí’ gólíni, k’edolzaadí’ nádaałgo, silááda tsį’iłna’áhi yogheełgo ádaabizlaa. ");
INSERT INTO apwNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Áík’ehgo Gólgotha golzeeyú bił náńzą́ą́; áí golzeego itsits’in si’áni golzeego ágolzee. ");
INSERT INTO apwNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Áígee wine, jeeh nch’í’i, myrrh holzéhi, bił nadesdziidgo Jesus yaa daizką́ą́; áídá’ doo yodląą da. ");
INSERT INTO apwNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Áígee tsį’iłna’áhi yídaabiskałdá’ bidiyágé iłta’isṉiigo yighą da’diłjoł lę́k’e, hadíí gonesnaahíí bíyéé hileehgo. ");
INSERT INTO apwNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ńgost’áí bik’ehenkéézgee tsį’iłna’áhi yídaabiskał lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nt’é baa dahgost’aaníí ádaagozlaago díínko bik’ehgee dahgoz’ąą, JEWS ÍZISGO BINANT’A’ NLÍNI, golzeego k’e’eshchįį. ");
INSERT INTO apwNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Áígee nṉee da’in’įįhíí naki ałdó’ Jesus ba’ashhahdí’ tsį’iłna’áhi bídaahaskał, ła’ dihe’nazhiṉéégo, ła’íí be’eshganzhiṉéégo. ");
INSERT INTO apwNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Áík’ehgo Bik’ehgo’ihi’ṉań biyati’ bek’e’ eshchiiníí, Begoz’aaníí doo yikísk’eh ádaat’ee dahíí bił da’ch’ołtag lę́k’e, ṉii n’íí begolzaa. ");
INSERT INTO apwNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bahyú ch’íhikáhíí bitsits’in daidiłtasgo yati’ yee daabokáałgo gádaaṉii, Háhái’, biyi’ da’ch’okąąhíí taagoshṉiłgo taagi jįį hileehgo ánágoshdle’, nṉii ni’, ");
INSERT INTO apwNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Haląą, dáni hasdá’ídnlteehgo tsį’iłna’áhi biká’dí’ gódah ch’ínṉáh. ");
INSERT INTO apwNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Okąąh yebik’ehi itisyú nadaandeehi, begoz’aaníí ye’ik’eda’iłchíhi biłgo Jesus yaa daadloh, gádaałiłdi’ṉiigo, Nṉee ła’íí hasdáyihiṉiił; áídá’ bííhíí doo hasdá’ídilteeh da. ");
INSERT INTO apwNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Christ, Israel hat’i’íí ízisgo biNant’a’ nliiníí, haląą tsį’iłna’áhi yiká’dí’ naadowáh, áík’ehgo daahihiiltsąągo zhą́ daahohiidląąh. Áídí’ bit’ahyú tsį’iłna’áhi bił bídaach’iskałíí yati’ yee daabokáał lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Isk’áhńyáádí’ taagi nehenkéézzhį’ ni’ biká’ dahot’éhé godiłhił gozlįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Taagi nehenkéézgo Jesus nádidilghaazhgo gáṉíí, Éloi, Éloi, láma sabákthani? áí, Bik’ehgohinshṉaahíí, Bik’ehgohinshṉaahíí, nt’é ląą bighą shits’ą́’zhį’ ándzaa? golzeego ágolzee. ");
INSERT INTO apwNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ła’ áígee nadaaziiníí daabidits’ago, Isąą, Elías yich’į’ aṉii, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ła’ nádilwodgo tú daabits’ǫsíí vinegar yiyi’ naiz’ąą, áídí’ tsį yaa dahyiz’ąągo Jesus bizé’zhį’ dahyída’nłtsiih, gáṉíígo, Ntséńt’ah; bídaagonolzįįh, Elías baa higháhgo nanábidiłteeh shį. ");
INSERT INTO apwNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Áídí’ Jesus nádidilghaazhgo oyol. ");
INSERT INTO apwNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Áígee kįh biyi’ da’ch’okąąhíí biyi’ yuṉe’ daadintsoozíí bighą́’dí’ hayaago iłch’idláád lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Silááda dała’á gonenadín binant’a’íí Jesus bich’į’go siziiníí Jesus nádidilghaazhdá’ oyolgo yígołsįįdá’ gáṉíí, Díí nṉeehíí da’aṉii Bik’ehgo’ihi’ṉań biYe’ nlíni ląą. ");
INSERT INTO apwNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Isdzáné aṉahdí’ nazįį daabineł’į́į́go, Mary Mágdalene, Mary, James iké’yú nagháhi hik’e Joses bąąhíí, ła’íí Salóme biłgo, itah nazįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Áí Jesus Gálileeyú naghaadá’ biké’ anákah lę́k’e, bich’odaaṉiigo; ła’íí isdzáné Jerúsalemyú bił hikaihíí ałdó’ łą́ą́go itah nadaazįį. ");
INSERT INTO apwNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","K’ad o’i’aahyú iłch’į’golṉe’íí bijįį, áí iskąą hik’e Jews daagodnłsiníí bijįį doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nṉee Joseph holzéhi, Arimathéa golzeeyú gólíni, doo biini’ hą́h dago Pílate yich’į’ oyáá, Jesus bits’íhíí yíyókeedgo; áń nṉee godnłsíni, yánádaaltihíí itah nlíni, Bik’ehgo’ihi’ṉań nant’aa doleełíí yibad sidáhi. ");
INSERT INTO apwNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pílate, Jesus daztsąą shį dashą’at’éé nzįgo, silááda binant’a’ yiká ánṉiidgo nayídíłkid, Iłk’idá’ daztsąą née? yiłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Áík’ehgo silááda binant’a’, Ha’oh, daztsąą, biłnṉiiddá’ Pílate Jesus bits’íhíí Joseph yaa yiden’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Áík’ehgo Joseph nak’ą’łigaihi nłt’éhi nayihesṉii, áídí’ Jesus bits’íhíí tsį’iłna’áhi yiká’dí’ nanáidnłtįįgo nak’ą’łigaihi yik’íyidesdiz, áídí’ tsébii’i’áńgo ágolzaa yuṉe’ nyinłtį́į́dá’ tséé yidaidenłhiz lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Mágdalene hik’e Joses bą́ą́ biłgo hayú nniltiiníí daayo’į́į́ ni’. ");
INSERT INTO apwNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jews daagodnłsiníí bijįį ąąłdá’ Mary Mágdalene, Mary, James bąąhíí, Salóme biłgo, ik’ah łikągolchinihíí nadaahesṉii ni’, Jesus bits’í yee yídizhish doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Áík’ehgo dázhǫ́ t’ahbį godilziníí bijįį ya’áí hagaałdá’ tsébii’i’áńyú hikai. ");
INSERT INTO apwNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Áígee, Hadíńshą’ tséé daadin’ą́ą́híí nohwá yó’idołhis? daałiłdi’ṉii. ");
INSERT INTO apwNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Áídí’ hadag daadéz’įįgo tséé n’íí yó’olyizgo daayiłtsąą; tséé dázhǫ́ nchaago. ");
INSERT INTO apwNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tsébii’i’áń yuṉe’ ha’ákaidá’ nṉee áníi nagháhihi, bi’íí nṉeezi łigaihi dihe’nazhiṉéégo sidaago daayiłtsąą; áík’ehgo tsídaadolyiz lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Áídá’ nṉeehíí gádaabiłṉii, Tsídaadołheez hela’: Jesus, Názarethdí’ gólíni, tsį’iłna’áhi bíheskał n’íí biká hadaanohtaago bígonsį: áń naadiidzaa ni’; doo hak’i da: nniltį́į́ n’íígee daadeh’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ti’i dohkáh, bitsiłke’yu, Peter biłgo, Jesus Gálileeyú nohwádįh deyaa, biłdohṉiih: ákú daabidołtsééł, da’ánohwiłṉiihíí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Áídí’ tsébii’i’áńdí’ dahałe ch’ínákaidá’ nádnkįį; daiditłid ła’íí bił díyadaagot’ee daasilįį: nédaildzidgo doo hadíń nt’é daayiłṉii da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Godilziníí bijįį t’ahbį Jesus daztsąądí’ naadiidzaadá’ Mary Mágdalene dantsé yich’į’ hit’įįgo ádelzaa, áí isdzánhíí biyi’dí’ ch’iidn gosts’idi haniyóod n’íí. ");
INSERT INTO apwNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Áń nṉee Jesus yił nakai n’íí doo bił daagozhǫ́ǫ́ dago chaał naháztąąyú yaa nyáágo yił nagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Áídá’ Jesus náhi’ṉa’go isdzán bo’įįgo ya’ikodaanzįį ndi doo daayodląą da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Áí bikédí’go Jesus yił nakai n’íí naki itínk’ehyú hi’aashgo bich’į’ łahgo hit’įįgo ádelzaa. ");
INSERT INTO apwNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Áídí’ onát’aazhgo ła’ihíí yił nadaagosṉi’ ndi doo daabodląą da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Áí bikédí’go bitsiłke’yu łats’ádahíí da’iyąągo nahą́ztąągo Jesus bich’į’ hit’įįgo ádelzaa, áígee doo da’odląą dago bijíí daantł’izíí bighą bich’į’ yádaałti’, daztsąądí’ naadiidzaahíí bikédí’go ła’ daabo’įįhíí doo daayodląą dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Áídí’ gábiłṉii, Ni’gosdzáń dágoz’ąą nt’éégo yati’ baa gozhóni nṉee dawa baa bił nadaagołṉi’ le’. ");
INSERT INTO apwNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dahadíń odląądí’ baptize ábi’delzaahíí hasdádolteeł; áídá’ dahadíń doo odląą dahíí dahazhį’ biniigonłt’éégo bá ngodot’aał. ");
INSERT INTO apwNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Áídí’ díínko godiyįhgo ánágot’įįłíí da’odlaaníí ádaadoliił; shizhi’ bee ch’iidn hadaanyood doleeł; ła’íí yati’ łahgo at’éégo yee yádaałti’ doleeł; ");
INSERT INTO apwNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ch’osh bik’asda’ golíni nádaihiṉiił doleeł; dant’éhéta koziłheehíí daidląą ndi doo hago ádaabile’ da doleeł; ła’íí daanṉiihíí yiká’ ndaadilṉiigo nádaadziih doleeł. ");
INSERT INTO apwNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Áík’ehgo Jesus ąął bich’į’ yádaałti’dá’ yaaká’yú onábi’doltį́į́, áígee Bik’ehgo’ihi’ṉań bigan dihe’nazhiṉéégo dahnezdaa. ");
INSERT INTO apwNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Áídí’ dahiskaigo dahot’éhé yati’ baa gozhóni yaa nadaagolṉi’ lę́k’e, beBik’ehń yił nlįįgo nada’iziidgo, godiyįhgo ánágot’įįłíí bee biyati’ da’aṉii at’éhi ch’í’ṉah áile’go. Doleełgo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nṉee łą́ą́go nohwitahyú hago ánágot’įįłíí dałiké’go yek’eda’ishchįįgo, ");
INSERT INTO apwNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nṉee da’iłtsé godezt’i’gé’ biṉááł ánágot’įįłíí, Jesus biyati’ yaa nadaagolṉi’íí nohwił nadaagosṉi’híí k’ehgo yek’eda’ishchįį; ");
INSERT INTO apwNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Áík’ehgo Theóphilus, ízisgo áńt’éhi, shíí ałdó’ da’iłtsé godezt’i’gé’ hago ánágot’įįłíí bígosiłsįįdgo dałiké’ ánágot’įįłíí bee nich’į’ k’e’eshchįį hasht’į́į́, ");
INSERT INTO apwNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hago ánágot’įįłíí nił na’gosṉi’ n’íí da’aṉiigo bígonłsį́įhíí bighą nich’į’ bek’e’eshchii. ");
INSERT INTO apwNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hérod Judéa yánant’aaná’ nṉee, Zakarías holzéhi, okąąh yedaabik’ehi Abía hat’i’íí itah nlįį lę́’e: áń bi’aad, Elísabeth holzéhi, Aaron hat’i’i nlįį. ");
INSERT INTO apwNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakarías ła’íí bi’aad biłgo Bik’ehgo’ihi’ṉań binadzahgee dánłt’éégo ádaat’ee, Bik’ehgo’ihi’ṉań ngon’ááníí ła’íí biyati’íí nzhǫǫgo yikísk’eh hi’ash lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bichągháshé doo hwaa da, Elísabeth doo iłchiih dahíí bighą; sáan ła’íí hastiin daasilįį’. ");
INSERT INTO apwNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bik’ehgo’ihi’ṉań binadzahgee Zakarías okąąh yebik’ehgo baa gonyááná’, ");
INSERT INTO apwNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nṉee okąąh yedaabik’ehi dahgos’aaníí k’ehgo Bik’ehgo’ihi’ṉań daach’okąąh goz’ąą yuṉe’ dilidgo łikągolchinihíí yidiłtłi’go habi’doltįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Łikągolchinihíí diltłi’go biká’ ngonyaaná’ nṉee łą́ą́go dadáńyú dała’adzaago da’okąąh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ákóṉe’ łikągolchinihíí biká’ dahsi’ąągo yidiłtłi’íí dihe’nazhiṉéégo Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi bił ch’í’ṉah adzaa. ");
INSERT INTO apwNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakarías yiłtsąągo yik’e tsídolyizgo biłgoyéé’go gozlįį. ");
INSERT INTO apwNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Áíná’ Bik’ehgo’ihi’ṉań binal’a’á gáyiłṉii, Doo nénldzid da, Zakarías: Bik’ehgo’ihi’ṉań ni’okąąhíí yidezts’ąą; ni’aad Elísabeth bizhaazhé ishkiini ná yiłchii, áí mé’ihíí bizhi’ John bá áńle’. ");
INSERT INTO apwNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Baa nił gozhǫ́ǫ́ doleeł, dázhǫ́ nił gozhǫ́ǫ́ doleeł; nṉee łą́ą́go mé’ goleehíí yaa bił daagozhǫ́ǫ́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bik’ehgo’ihi’ṉań binadzahgee ízisgo at’éé doleeł, wine dagohíí iłnágodiłhisíí doo yidląą da doleeł; t’ah bimaa bibishch’id yiyi’ sitįįgé’ godezt’i’go Holy Spirit bee baa godet’ąą doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Díí mé’ goleehíí nṉee Israel hat’i’íí łą́ą́go beBik’ehń, Bik’ehgo’ihi’ṉań daayokąąhń, yich’į’ nnáhiikáhgo áidoliił. ");
INSERT INTO apwNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Elías biyi’siziiníí ła’íí binawodíí k’ehgo beBik’ehń yádn dahdidogaał doleeł, nṉee bichągháshé nłt’éégo yaa tsínádaadikeesgo áidoliił, ła’íí hayíí doo ídaayésts’ąą dahíí nṉee nłt’éégo ádaat’eehíí bigoyą’ yídaayésts’ąągo áidoliił; beBik’ehń yaa higháhíí nṉee bijíí yuṉe’ bá iłch’į’gole’go áidoliił. ");
INSERT INTO apwNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakarías Bik’ehgo’ihi’ṉań binal’a’á gáyiłṉii, Hago at’éégo shiye’ goleehíí bígonsį doleeł, shíí hastiin silįįná’ shi’aadń ałdó’ są́ silįį? ");
INSERT INTO apwNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Bik’ehgo’ihi’ṉań binal’a’á bich’į’ hananádzii, gáṉíígo, Shíí Gábriel honszee, Bik’ehgo’ihi’ṉań binadzahgee sizį́į́; shíí nich’į’ hasdziihgo díí nłt’éégo ágoṉe’íí baa nił nagoshṉi’go shi’dol’aad. ");
INSERT INTO apwNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Doo yáńłti’ da nleeh, díí ágoṉe’ dishṉiihíí begolzaahíí bijįį zhą́ hanáńdziih, doo shondląą dahíí bighą, ágoṉe’ dishṉiihíí da’aṉii begolṉe’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nṉee dała’at’éé n’íí Zakarías ch’éh yiba’ naháztąą, hat’íí bighą doo hwaa ch’ínádáh da daanzigo. ");
INSERT INTO apwNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ch’ínádzaaná’ doo hago’at’éégo nṉee yich’į’ hadzii da: áík’ehgo hat’íhíta bich’į’ ch’í’ṉah adzaa shį daanzį; t’ah doo yałti’ dago daazhógo na’ígizh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Áígee binasdziidíí ąął áyíílaaná’ bigowąyú onádzaa. ");
INSERT INTO apwNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Áí bikédé’go bi’aad Elísabeth hiltsąą silįįná’ yaa ch’anant’į’go ashdla’i dahitąą, gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nṉee bich’į’ siste’ n’íí shich’ą́’zhį’go shá áile’híí bighą sheBik’ehń shaa ch’ozbaago díí k’ehgo shá ágólaa. ");
INSERT INTO apwNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isdzán holtsaanihíí gostáń behitąągo Bik’ehgo’ihi’ṉań binal’a’á, Gábriel holzéhi, yaaká’gé’ kįh gozṉil Názareth golzeezhį’ yíł’aad, áí kįh gozṉilíí Gálileehíí biyi’, ");
INSERT INTO apwNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Áígee it’eedń k’ad nṉee, Joseph holzéhi, baa hiiłtíni yich’į’ oyáá lę́’e, áí nṉeehń David hat’i’i nlįį; it’eedń Mary holzee. ");
INSERT INTO apwNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi Mary yaa nyáágo gáyiłṉii, Nił gozhǫ́ǫ́ le’, Bik’ehgo’ihi’ṉań dázhǫ́ naa ch’oba’go nohweBik’ehń nił nlįį: dázhǫ́ niyaa gozhǫ́ǫ́ doleełgo isdzáné bitahgé’ haniłtį́į́. ");
INSERT INTO apwNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Áń yo’į́į́go ábiłṉiihíí bighą tsídolyiz, yaa tsídiskeezgo hat’ííshą’ ṉiigo aṉíí nzį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bik’ehgo’ihi’ṉań binal’a’á gábiłṉii, Doo nénłdzid da, Mary: Bik’ehgo’ihi’ṉań naa ch’oba’go haniłtį́į́. ");
INSERT INTO apwNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Isąą, hinłtsą́ą́ nleehgo ishkiiníí hinłchii, áń Jesus golzeego áńlííł. ");
INSERT INTO apwNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ízisgo at’éé doleeł, Da’tiséyé At’éhi biYe’ holzee doo; áń David yá niltįįgo godoleeł, Bik’ehgo’ihi’ṉań nohweBik’ehń David yánant’aa lę́’e n’íí yánant’aago ábile’: ");
INSERT INTO apwNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jacob hat’i’i daanliiníí dahazhį’ yánant’aa doleeł; nant’aago doo bee nnágódáh da. ");
INSERT INTO apwNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary Bik’ehgo’ihi’ṉań binal’a’á gáyiłṉii, Hago’at’éégo díí, shiką’ doo hwaa daná’? ");
INSERT INTO apwNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bik’ehgo’ihi’ṉań binal’a’á gábiłṉii, Holy Spirit niká’zhį’ at’éé doleeł, Da’tiséyú At’éhi binawodíí niká’zhį’ áiléh: áík’ehgo ni’imé’ goleehíí dázhǫ́ dilzini doleeł, Bik’ehgo’ihi’ṉań biYe’ holzee doo. ");
INSERT INTO apwNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elísabeth, nik’íí, doo iłchíhi da daałch’iṉii n’íí, są́ silįį ndi ałdó’ hiltsąą, gostáń bedahitąą, bi’imé’ ishkiin doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bik’ehgo’ihi’ṉań doo hat’íí ch’éh áil’įį da. ");
INSERT INTO apwNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary gáṉíí, Shíí Bik’ehgo’ihi’ṉań bíyéé nshłįį; ha’aa dishṉii, da’ánṉiihíí bikísk’ehyú áshidolííł. Áígé’ Bik’ehgo’ihi’ṉań binal’a’á bich’ą́’ onádzaa. ");
INSERT INTO apwNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Áígé’ Mary dahałeego aṉahyú beezhį’yú kįh gozṉilyú Judahíí biyi’ oyáá lę́’e; ");
INSERT INTO apwNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ákú Zakarías bigową yuṉe’ ha’ayáágo Elísabeth yich’į’ hadzii. ");
INSERT INTO apwNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elísabeth Mary biyati’ yidezts’ąągo biyi’ mé’ dehes’naa lę́’e; ła’íí Elísabeth Holy Spirit bee baa godet’ąą lę́’e: ");
INSERT INTO apwNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Áń nawode hadzii ląą gáṉíígo, Isdzáné bitahgé’ niyaa gozhǫ́ǫ́ doleeł, mé’ nibishch’id biyi’ sitiiníí ałdó’ biyaa gozhǫ́ǫ́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hago’at’éégo lą́hi sheBik’ehń bimaa shaa ch’oba’go shaa nyáá? ");
INSERT INTO apwNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Niyati’íí disets’ąąná’ mé’ bił gozhǫ́ǫ́go shiyi’ dehes’naa ląą. ");
INSERT INTO apwNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Isdzán osdląądíí biyaa gozhǫ́ǫ́: Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’híí binkááyú ábiłṉiihíí da’aṉii begolṉe’híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary gáṉíí, Shijíí dawa bee sheBik’ehń ízisgo at’ééhíí baa nagoshṉi’, ");
INSERT INTO apwNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Shiyi’siziiníí Bik’ehgo’ihi’ṉań Hasdáshíłtííníí yaa bił gozhǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Shíí binal’a’á nshłíni doo hat’íí be’ánsht’ee da ndi nłt’éégo shaa tsínádeskeez: kogé’ godezt’i’go nṉee daałinolt’įįłíí dawa, isdzán biyaa gozhóni daashiłṉii doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dázhǫ́ k’a’at’éhi dázhǫ́ nłt’ééhíí áshíílaa; áń bizhi’íí dilzįh. ");
INSERT INTO apwNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iłké’ nánot’įįłíí dahadń Bik’ehgo’ihi’ṉań bił diyinihíí baa ch’oba’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Binawod ch’í’ṉah áyíílaa: bijíí yuṉe’ dázhǫ́ ádaadilkąhíí yił nadaagodesgeed, ");
INSERT INTO apwNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nṉee hayíí ízisgo ádaat’ee n’íí hayaa ánáyiidlaaná’ doo ízisgo ádaat’ee da n’íí hadag ánáyiidlaa. ");
INSERT INTO apwNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hayíí dáshiṉá’ nakai n’íí dawahá nłt’ééhíí yá ná’nné’ ni’; áíná’ ízis da’it’iinihíí dádilkǫǫgo onáyis’a’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Bána’iziidíí, Israel holzéhi, bich’ozṉi’, biłgoch’oba’íí yee yénálṉiihgo; ");
INSERT INTO apwNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Dahazhį’ Abraham ła’íí bich’ą́’gé’ hadaałinolchiiłííbił goch’oba’, daanohwitaa n’íí ágáyiłṉii n’íí k’ehgo, ṉii, Mary. ");
INSERT INTO apwNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary Elísabeth yił sikeego taagi dahitąą lę́’e, áígé’ bigowąyú onádzaa. ");
INSERT INTO apwNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elísabeth iłchiigee ngonyaa lę́’e; áígee ishkiin yizhchįį. ");
INSERT INTO apwNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hago’at’éégo Elísabeth Bik’ehgo’ihi’ṉań baa ch’ozbaadíí, ba’ashhahgé’ daagolííníí ła’íí daabik’ííhíí yaa t’ídaanzįgo bił daagozhǫ́ǫ́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mé’ tsebíí beyiskąągo circumcise alṉéhgo baa ch’ikai; Zakarías holzee doleeł, bitaa bizhi’híí k’ehgo, daach’iṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Áíná’ mé’ bimaahíí, Dah; John bizhi’ hileeh, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nik’íí doo ła’ ágágolzee da, daabiłch’iṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Áík’ehgo mé’íí bitaahíí bich’į’ na’ída’ch’igizhgo, Díí mé’íí hat’íí holzee doo? daabiłch’iṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Áík’ehgo Zakarías biká’ k’e’elchiihíí hát’į́į́go na’ígizh, áígé’, Díí mé’íí John holzee doo, ṉiigo biká’ k’e’eshchįį. Áí bighą nṉeehíí bił díyadaagot’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Áígé’ dahį́ko Zakarías hanádziigo, Bik’ehgo’ihi’ṉań ya’ahénzį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Áígé’ ba’ashhahgé’ daagolííníí tsídaadesyiz: díí ágodzaahíí ni’ Judéa biyi’ dahyisk’idyú daagoch’ilííníí dawa bitahyú didesdlaad. ");
INSERT INTO apwNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hayíí áí ch’iṉii daidezts’aaníí bijíí yuyaa nazné’go, Díí mé’íí hagoshą’ at’éé hileehi! daaṉii. Áígé’ Bik’ehgo’ihi’ṉań yił nlįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakarías, mé’ bitaahíí, Holy Spirit yábiyiłti’go Bik’ehgo’ihi’ṉań binkááyú yałti’, gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Bik’ehgo’ihi’ṉań Israel hat’i’i beBik’ehń ba’ahégosį; nṉee bíyééhíí yaa nyáágo hanáyíṉilhíí bighą, ");
INSERT INTO apwNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bána’iziidíí, David holzéhi, bich’ą́’gé’ hadaałinolchiiłíí bitahgé’ dázhǫ́ nalwodi hasdánohwiṉiił doleełíí nohwá hayiłtį́į́; ");
INSERT INTO apwNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ni’gosdzáń alzaagé’ yúshdé’ godezt’i’go Bik’ehgo’ihi’ṉań binkááyú nada’iziidi daadilzini yinkááyú nohwich’į’ hadziigo gánohwiłnṉiid: ");
INSERT INTO apwNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nohwik’edaanṉiihíí ła’íí hayíí bił daanlchǫ’íí dawa nohwidás sizįį doleeł; ");
INSERT INTO apwNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Daanohwitaa n’íí áyiłṉii n’íí k’ehgo nohwaa daach’oba’, ła’íí áí biłgo godiyįhgo łángot’ąą n’íí yénálṉiih, ");
INSERT INTO apwNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Bik’ehgo’ihi’ṉań bitł’a dahdidilṉiigo díí k’ehgo nohwá ngon’ą́ą́, ");
INSERT INTO apwNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nohwíí hayíí nohwik’edaanṉiihíí nohwidás sizįįgo, doo nídaahiildzidgo da Bik’ehgo’ihi’ṉań bá nada’iidziid doo, ");
INSERT INTO apwNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Dáhandaahinṉa’zhį’ daagodinlzįgo ła’íí nłt’éégo binadzahgee ádaant’eego. ");
INSERT INTO apwNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ni, mé’íí, Da’tiséyú At’éhi binkááyú na’iziidíí honlzee doo: ni nohweBik’ehń bádnyú iłch’į’goléhgo dahnṉáh; ");
INSERT INTO apwNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nṉee Bik’ehgo’ihi’ṉań bíyééhíí hago’at’éégo binchǫ’íí bá da’ízlį́į́ ánánlṉe’go hasdaakáh doleełgo yídaagołsįįhgo ánle’, ");
INSERT INTO apwNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bik’ehgo’ihi’ṉań daahohiikąąhń nohwaa ch’oba’íí binkááyú; da’áń bik’ehgo yaaká’gé’ idindláádíí nohwaa nyáá, ");
INSERT INTO apwNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hayíí chagołheełyú naháztaaníí da’itsaah yédaaldzidíí bá idindláádgo ágole’, ła’íí iłch’į’gont’éégo yikísk’eh hiikaahgo áile’, ṉii lę́’e, Zakarías. ");
INSERT INTO apwNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mé’ nchaa silįįgo biyi’siziiníí dázhǫ́ nalwod silįį, Israel hat’i’i bich’į’ ch’í’ṉah ádilṉe’íí bijįįzhį’ da’izlįįyú naghaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Áíná’ nant’án Caesar Augústus holzéhi nṉee dawa daantį́į́gee tax nahi’ṉiił doleełgo bizhi’ ádaagole’go yángon’ąą lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Cyrénius, Sýriayú nant’án nlįįná’, díí nach’ihi’ṉiił doleełgo kozhi’ ádaagoch’ile’íí da’iłtsé álzaa lę́’e.) ");
INSERT INTO apwNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nṉee dawa bizhi’ ádaagole’yú onádaaskai lę́’e, hayú kįh gozṉilgé’ daagolį́į́yú. ");
INSERT INTO apwNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph ałdó’ itah onádzaa, Gálilee bigodzogíí biyi’ Názareth golzeegé’ Béthlehem golzeezhį’, Judéahíí biyi’gee, David golį́į́ n’ííyú, (Joseph David yił hat’i’i lę́’ehíí bighą,) ");
INSERT INTO apwNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mary dak’adégo iłchiihi, Joseph baa hiiłtíni yił hi’ash lę́’e, bizhi’ ádaagole’yú. ");
INSERT INTO apwNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Áígee sikeená’ iłchiihíí biká’ ngonyaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Da’iłtsé iłchíhi ishkiin yishchįį, mé’ihíí nadik’ą’ bik’ídisdizgo magashi yiyi’ náda’idįįhíí yiyi’ nyinłtį́į́; na’ch’injahíí doo ła’ hayú bá goz’ąą dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mé’ sitiiníí da’aṉahyú nṉee nada’nyoodíí bidibełį́į́ yiṉádaadéz’įį lę́’e, tłé’yú. ");
INSERT INTO apwNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Áígé’ Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi bich’į’ ch’í’ṉah adzaago Bik’ehgo’ihi’ṉań bich’ą́’idindláádíí bee ike’dendláád; áík’ehgo nṉee nada’nyoodíí tsídaadesyiz. ");
INSERT INTO apwNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bik’ehgo’ihi’ṉań binal’a’á gábiłṉii, Doo nédaałdzid da: íyínłts’ąą są́ą́, yati’ dázhǫ́ nłt’éhi nṉee dawa bee bił daagoyiłshǫ́ǫ́ doleełíí baa nohwił nagoshṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Díí jįį David golį́į́ n’ííyú nṉee hasdáyihiṉíłi nohwá gozlįį, Christ nohweBik’ehń. ");
INSERT INTO apwNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Díí bee bídaagonołsį doleeł, mé’ihíí nadik’ą’ bik’ídisdizgo magashi yiyi’ náda’idįįhíí yiyi’ sitįįgo daahołtséh. ");
INSERT INTO apwNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dahį́ko Bik’ehgo’ihi’ṉań binal’a’á da’iłtsé ch’í’ṉah ádilzaahíí łą́ą́go yaaká’gé’ yił ch’í’ṉah ánádedlaa, áí Bik’ehgo’ihi’ṉań ya’ahédaanzįgo gádaaṉii, ");
INSERT INTO apwNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Bik’ehgo’ihi’ṉań da’tiségo at’éhi yaaká’zhį’go daach’inłsį le’, ła’íí ni’ biká’yú nṉee Bik’ehgo’ihi’ṉań biłgoch’oba’íí bee iłch’į’gont’ééhíí bíyéé le’. ");
INSERT INTO apwNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Áígé’ Bik’ehgo’ihi’ṉań binadaal’a’á yaaká’yú onákainá’ nada’nyoodíí, Béthlehemyú dokáh, daałiłdi’ṉii, Díí ágodzaahíí Bik’ehgo’ihi’ṉań nohwił ch’í’ṉah ágolaahíí daanél’įįyú dokáh. ");
INSERT INTO apwNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Áík’ehgo áígé’ dagoshch’į’ deskaigo Mary, Joseph, ła’íí mé’ magashi yiyi’ náda’idįįhíí yiyi’ sitįįgo yaa hikai. ");
INSERT INTO apwNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Daayiłtsąąná’ mé’ihíí ábiłdi’ṉii n’íí dahot’éhé yaa nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Hayíí daidezts’aaníí nada’nyoodíí ádaabiłṉiihíí yaa bił díyadaagot’ee. ");
INSERT INTO apwNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maryhíí díí dawa yénálṉiihgo dayúweh bijíí yuyaa yaa natsekees lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nada’nyoodihíí da’ádaabiłdi’ṉiihíí k’ehgo hayíí daidezts’ąąhíí ła’íí daayo’įįhíí bighą Bik’ehgo’ihi’ṉań ízisgo at’ééhíí yaa nadaagolṉi’go, ła’íí ya’ahédaanzįgo t’ąązhį’ onákai. ");
INSERT INTO apwNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tsebíí beyiskąąná’ mé’ círcumcise ábi’delzaaná’ Jesus bizhi’ bá álzaa, áí bizhi’íí doo hwaa goleeh daná’ Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’ihi bizhi’ bá áyíílaahi. ");
INSERT INTO apwNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses ngon’ąą n’íí k’ehgo Mary godnłsįgo iłch’į’bi’dilṉe’íí biká’ ngonyáágo, mé’ Bik’ehgo’ihi’ṉań baa hiłtéehgo Mary ła’íí Joseph biłgo Jerúsalemyú odaistįį lę́’e; ");
INSERT INTO apwNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Mé’ da’iłtsé ishkiin daagolehihíí Bik’ehgo’ihi’ṉań bá sanigo nihi’ṉiiłgo ngon’ą́ą́go k’e’eshchįįhíí bighą;) ");
INSERT INTO apwNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ła’íí Bik’ehgo’ihi’ṉań hat’íhíta ye’okąąhíí yaa daayiné’go odaistįį lę́’e ałdó’, hawú naki, dagohíí hawúcho bizhaazhé naki, Bik’ehgo’ihi’ṉań yegos’aaníí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerúsalemgee nṉee ła’, Símeon holzéhi, nłt’éégo at’éhi, Bik’ehgo’ihi’ṉań yidnłsíni naghaa lę́’e; áń Israel hat’i’i yił goyiłshǫ́ǫ́go ánáyidle’íí hígháhíí yiká déz’įį lę́’e: Holy Spirit biká’zhį’ at’éhi. ");
INSERT INTO apwNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Holy Spirit bee bił ch’í’ṉah ágolzaago gábił’idi’ṉii, T’ah doo hwaa dantsaah daná’ Bik’ehgo’ihi’ṉań Its’áltíni, Christ holzéhi, hinłtséh. ");
INSERT INTO apwNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Holy Spirit nábihiłaago da’ch’okąąh goz’ąą yuṉe’ nyáá; ákú Jesus bimaa ła’íí bitaa biłgo begoz’aaníí k’ehgo bá okąąhgo ádaabistįįná’, ");
INSERT INTO apwNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Áígee Símeon mé’ náyinłtįįgo Bik’ehgo’ihi’ṉań ya’ahénzįgo gáṉíí, ");
INSERT INTO apwNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","SheBik’ehń, áníita áshiłnṉii n’íí k’ehgo nána’isiidíí shił gozhǫ́ǫ́go ch’ík’eh shee ngonowáh: ");
INSERT INTO apwNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Shí shiṉaahíí bee hago’at’éégo hasdá’ííṉííł doleełíí hish’įį, ");
INSERT INTO apwNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Áí nṉee dawa biba’ iłch’į’ńdlaa n’íí; ");
INSERT INTO apwNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Áń bich’ą́’idindííníí nṉee doo Jews daanlįį dahíí bee bá got’įį doleeł, ła’íí nṉee ṉíyééhíí, Israel hat’i’i, áń bee ízisgo ádaat’ee doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jesus ábiłdi’ṉiihíí bitaa, bimaa biłgo yaa bił díyadaagot’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Símeon bá da’oskąądná’ Mary, Jesus bimaahíí, gáyiłṉii, Íyínłts’ąą są́ą́, díí mé’ihíí Israel hat’i’i łą́ą́go bighą naanándéh, ła’íí łą́ą́go nádikáh doleełhíí bighą habi’doltíni at’éé; godiyįhgo be’ígózini baa yádaach’iłti’ doleełi; ");
INSERT INTO apwNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","(Bésh be’idiltłishé nijíí bighálgeedhíí k’ehgo nijíí nṉiih doleeł;) nṉee bijíígé’ natsekeesíí ch’í’ṉah alṉéh doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Phánuel, Áser hat’i’i itah nlíni, bitsi’, Anna holzéhi, Bik’ehgo’ihi’ṉań binkááyú yałti’i nlįį lę́’e; áń są́ silįį, nanṉeego gosts’idn łegodzaa; ");
INSERT INTO apwNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Itsaa nlįįgo tsebídin dį́į́’i bił łegodzaa, da’ch’okąąh goz’ąągé’ dá doo ch’igháhá dajįį biigha ła’íí datł’é’ biigha dáshiṉá’ okąąhgo Bik’ehgo’ihi’ṉań yá na’iziid lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Áń ałdó’ da’áígee nyáágo, Bik’ehgo’ihi’ṉań yich’į’ ahénzį, áígé’ Jerúsalemgee daagolííníí hago’at’éégo hasdábidi’ṉiił doleełíí yiká daadéz’iiníí Jesus yaa yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bik’ehgo’ihi’ṉań hago’at’éégo gos’aaníí ąął yikísk’eh ádaasdzaaná’ dabíí daagolį́į́yú, Gálilee bigodzogíí biyi’ Názareth golzeeyú, onákai. ");
INSERT INTO apwNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mé’ n’íí nołseełná’ biyi’siziiníí nłdzil silįį, goyą́ą́ silįį; ła’íí Bik’ehgo’ihi’ṉań biłgoch’oba’íí biká’zhį’ at’éé lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesus bimaa ła’íí bitaa biłgo dałenágodáhgee Jerúsalemyú onat’ash lę́’e, bitis‐hagowáh n’íí bee bíná’godiṉíhgo náda’idįįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesus nakits’ádah bił łegodzaaná’, dałenágodáhgee ákú onakáhíí k’ehgo ákú okai lę́’e; ");
INSERT INTO apwNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ąął bengonyaaná’ onákai, ndi Jesus t’ąązhį’ ídestąą lę́’e Jerúsalemgee; bimaa ła’íí bitaahíí dá doo yídaagołsį dago. ");
INSERT INTO apwNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jesus bił hikah daanzįgo názeełgo o’i’ą́ą́yú; bik’íí ła’íí hayíí bídaagosiníí bitahyú ch’éh yiká daantaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Doo hwaa hayú nádaanłtįį dahíí bighą t’ąązhį’ Jerúsalemyú biká daantaayú onát’aazh. ");
INSERT INTO apwNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Taagiskąąyú da’ch’okąąh goz’ąą yuṉe’ nṉee daagoyááníí iłch’ídaago’aahíí íyésts’ąągo ła’íí nayídiłkidgo naháztąąyú itah sidaago yaa hikai lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bił’ígóziníí ła’íí nabídíkidgo yígółsįgo hadzi’híí bighą nṉee daabidezts’aaníí bił díyadaagot’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jesus bimaa ła’íí bitaahíí daabiłtsąągo bił díyadaagot’ee: áík’ehgo bimaa gábiłṉii, Shizhaazhé, hat’íí lą́ą́ bighą áńt’íni? Nitaa ła’íí shíí ch’éh niká hantaahíí bighą doo nohwił daagozhǫ́ǫ́ da ni’. ");
INSERT INTO apwNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesus gábiłṉii, Hat’íí bighą shiká hanołtaa? ShiTaa binasdziidíí baa nashaago shá goz’ąą, ya’ doo bígonołsį da née? ");
INSERT INTO apwNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hat’íí ṉiigo aṉíí shįhíí doo yídaagołsį da lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Áík’ehgo yił onákai Názarethyú, bimaa ła’íí bitaa da’ádaabiłṉiiyú át’éé lę́’e: bimaahíí bizhaazhé ábiłnṉiidíí dawa yaa natsekees lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Áík’ehgo Jesus goyą́ą́go hoṉaał, ła’íí Bik’ehgo’ihi’ṉań da’áígeego bił at’éé, áígé’ nṉee ałdó’, dayúweh begoldoh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tibérius Caesar holzéhi nant’ánchań nlįįgo ashdla’ádah łegodzaa lę́’e, áíná’ iké’gee sitiiń, Póntius Pílate holzéhi, ni’ Judéa golzéhi yánant’aa, taagigee sitiiń, Hérod, ni’ Gálilee golzéhi yánant’aaná’ bik’isn Philip Ituréa ła’íí Trakonítis yánant’aa, ła’íí Lysánias Ábilene yánant’aa lę́’e, ");
INSERT INTO apwNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ánnas ła’íí Cáiaphas okąąh yebik’ehi da’tiséyú sitíni daanlįįná’ Zakarías biye’, John holzéhi, da’izlį́į́yú Bik’ehgo’ihi’ṉań bich’į’ hadzii. ");
INSERT INTO apwNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jórdan túńlínihíí biṉaayú nṉee yich’į’ yałti’go gádaayiłṉii, Nohwinchǫ’íí bich’ą́’zhį’ ádaałṉe’go baptize ádaanohwi’dolṉe’, áík’ehgo nohwinchǫ’íí nohwá da’ízlį́į́ ánálṉe’; ");
INSERT INTO apwNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bik’ehgo’ihi’ṉań binkááyú na’iziidi, Esáias holzéhi, binaltsoos biyi’gé’ díí bak’e’eshchįį, Da’izlį́į́yú hadńshį gáṉíígo dilwosh, NohweBik’ehń bádnyú iłch’į’daagołe’, intín iłk’ídezdǫhgo bá ádaałe’. ");
INSERT INTO apwNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nadaashwozhíí hanágodibįh, ła’íí dził naz’aaníí, nadaask’idíí hayaa álṉe’; ła’íí godigizíí iłk’ínádoldǫł, ła’íí godilwołíí dilkǫh ánálṉe’ doo; ");
INSERT INTO apwNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Áígee nṉee dawa hago’at’éégo Bik’ehgo’ihi’ṉań hasdá’iiṉiił doleełíí daidołtseeł. ");
INSERT INTO apwNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Áígé’ nṉee John baptize ádaabile’ hádaat’įįgo yaa hikaihíí gáyiłṉiigo yich’į’ yałti’, Nohwíí tł’iish bik’asda’ golííníí k’ehgo daałinołt’įįłíí, hadń lá nohwádnyú nohwiniigodilṉe’íí bich’ą́’ nołkáh nohwiłnṉiid? ");
INSERT INTO apwNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Da’aṉii nohwinchǫ’íí bich’ą́’ ádaałdzaayúgo ch’í’ṉah ádaadi’ṉołsį, nest’ą’ nłt’éégo nádaant’įhíí k’ehgo nohwaa daide’aah, Abraham bich’ą́’gé’ daadihe’ṉa’i doo ídiłdaadoł’ṉii da: Bik’ehgo’ihi’ṉań díí tséé nazṉilíí nṉee Abraham bich’ą́’gé’ daadihezṉa’íí k’ehgo áile’yúgo áile’, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tsint’áni nkedn’aagee k’ek’éhgo godest’ąą; tsint’áni dawa doo nest’áń nłt’ééhíí baa dahndéh dayúgo, yó’ok’éhgo kǫ’ diltłi’ yuyaa olkaadhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nṉeehíí John nayídaadiłkidgo gádaabiłṉii, Hago ádaahi’ṉe’ áíná’? ");
INSERT INTO apwNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","John gáṉíí, Hadń bi’íícho naki shįhíí, ła’ihíí bi’íícho da’ádįh shįhíí yaa yinołtsós; hadń bich’iyáń łą́ą́ shįhíí hadń bich’iyáń da’ádįh shįhíí ła’ yaa yinoné’. ");
INSERT INTO apwNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tax bich’į’ nadaahi’ṉiiłíí ałdó’ baptize ádaabi’dilṉe’yú hikaigo John gádaayiłṉii, Iłch’ígó’aahíí ńlíni, hago ląą ádaahi’ṉe’? ");
INSERT INTO apwNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","John gábiłṉii, Da’kwíí nohwich’į’ nadaahi’ṉiiłgo goz’ąą shįhíí doo bitisyú daahołkeed da. ");
INSERT INTO apwNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Silááda ałdó’ nabídaadiłkidgo gádaaṉii, Nohwihíí hago ląą ádaahi’ṉe’? John gábiłṉii, Hadń biṉí’dołṉíh hela’, hadń da’izlįįyú baa dahdaagoł’aah hela’; ła’íí hanádaałdéhíí, da’áí nohwił daanzhǫǫgo nzhǫǫ. ");
INSERT INTO apwNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nada’ołíígo nṉee dawa bijíí yuṉe’ gádaanzį, Díí nṉee, John holzéhi, Christ at’į́į́ née, dah née? ");
INSERT INTO apwNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John dawa yich’į’ hananádziigo gáyiłṉii, Shíhíí tú bee baptize ádaanohwish’įį, áíná’ shiké’gé’ ła’ shitisgo at’éhi higháh, biketł’óól k’e’ish’adgo ndi doo bik’eh sitį́į́da; áń Holy Spirit ła’íí kǫ’ yee baptize ádaanohwił’įį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Be’iłch’íhé dahyotįįł, tł’oh nagháí iłch’íhi goz’ąągee nágosho doleeł, binest’ą’híí náyiziidgo iłk’eyihiṉiiłná’ bizhoolíí kǫ’ doo ntsésihi biyi’ yuyaa yidiłid. ");
INSERT INTO apwNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Áígé’ nṉee yich’į’ yałti’go łą́ą́go yił ch’ígó’aah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hérod, nant’án nlínihi, nchǫ’go at’į́į́go bik’isn Philip holzéhi bi’aad, Heródias holzéhi, yaa yiheltįį, ła’íí nchǫ’go ánát’įįdíí John yee bich’į’ yałti’ lę́’e, ");
INSERT INTO apwNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hérod nchǫ’go ánát’įįdííbitisgo adzaa, John ha’áyíłt’e’. ");
INSERT INTO apwNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nṉee dawa baptize ádaabilṉe’ná’, Jesus ałdó’ baptize ábi’delzaago yáá bich’į’ ałch’ą́’ ádzaago, ");
INSERT INTO apwNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Holy Spirit hawú k’ehgo bich’į’ nke’eṉíihgo yaaká’gé’ yati’ gáṉíígo yidezts’ąą, ShiYe’ shił nzhóni ńlį́į́; naa shił gozhǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Áígee Jesus tádin shį bił łegodzaa, áń Joseph biye’ (bido’ṉíí), Josephíí Héli biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hélihíí Mátthat biye’, Mátthatíí Levi biye’, Levihíí Mélki biye’, Mélkihíí Jánna biye’, Jánnahíí Joseph biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josephíí Mattathías biye’, Mattathíasíí Amos biye’, Amosíí Náum biye’, Náumíí Ésli biye’, Éslihíí Nágge biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nággehíí Máath biye’, Máathíí Mattathías biye’, Mattathíasíí Sémei biye’, Sémeihíí Joseph biye’, Josephíí Júda biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Júdahíí Joánna biye’, Joánnahíí Rhésa biye’, Rhésahíí Zoróbabel biye’, Zoróbabelhíí Saláthiel biye’, Saláthielhíí Néri biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérihíí Mélki biye’, Mélkihíí Áddi biye’, Áddihíí Cósam biye’, Cósamhíí Elmódah biye’, Elmódamhíí Er biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erhíí Jóse biye’, Jósehíí Eliézer biye’, Eliézerhíí Jórim biye’, Jórimhíí Mátthat biye’, Mátthatíí Levi biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levihíí Símeon biye’, Símeonhíí Júda biye’, Júdahíí Joseph biye’, Josephíí Jónan biye’, Jónanhíí Elíakim biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elíakimhíí Mélea biye’, Méleahíí Ménan biye’, Ménanhíí Máttatha biye’, Máttathahíí Náthan biye’, Náthanhíí David biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidhíí Jesse biye’, Jessehíí Óbed biye’, Óbedhíí Bóoz biye’, Bóozíí Sálmon biye’, Sálmonhíí Náasson biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Náassonhíí Amínadab biye’, Amínadabíí Áram biye’, Áramhíí Ésrom biye’, Ésromhíí Pháres biye’, Pháresíí Júda biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Júdahíí Jacob biye’, Jacobíí Isaac biye’, Isaacíí Abraham biye’, Abrahamhíí Thára biye’, Thárahíí Nákor biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nákorhíí Sáruk biye’, Sárukhíí Rágau biye’, Rágauhíí Phálec biye’, Phálecíí Héber biye’, Héberhíí Sála biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sálahíí Caínan biye’, Caínanhíí Arfáxad biye’, Arfáxadíí Sém biye’, Semhíí Noe biye’, Noehíí Lámek biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lámekhíí Mathúsala biye’, Mathúsalahíí Enok biye’, Énokhíí Járed biye’, Járedhíí Maléleel biye’, Maléleelhíí Caínan biye’, ");
INSERT INTO apwNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Caínanhíí Énos biye’, Énosíí Seth biye’, Sethíí Adam biye’, Adamíí Bik’ehgo’ihi’ṉań biye’. ");
INSERT INTO apwNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus, Holy Spirit bił nlįįgo Jórdan túńlį́į́gé’ t’ąązhį’ nádesdzaa lę́’e, Spirit‐híí nabiłnaago da’izlįįyú óyáá, ");
INSERT INTO apwNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Áígee dizdin behiskąą, ákú ch’iidn nant’án nabíntaah lę́’e. Akú naghaaná’ doo hat’íí yiyąą da: áí dizdin ąął iskąąná’ shiṉá’ silįį lá. ");
INSERT INTO apwNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ch’iidn nant’án bich’į’ hadziigo gábiłṉii, Ni Bik’ehgo’ihi’ṉań biYe’ ńlį́į́yúgo díí tséhíí báń náodleeh, nṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Áíná’ Jesus gábiłṉii, Ágágolzeego k’e’eshchįį, Nṉee doo dá báń zhą́ yee hiṉaa da doleeł, áíná’ Bik’ehgo’ihi’ṉań biyati’íí dawa yee hiṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Áígé’ ch’iidn nant’án dził dázhǫ́ yúdahi biká’yú yił hananásht’aazhgo, áígé’ nṉee iłtah at’éégo hadaazt’i’íí dawa ch’inesk’ołíí dábich’į’ bił ch’í’ṉah áyíílaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Áígé’ ch’iidn nant’ánhíí gánábiłdo’ṉiid, Díí dahot’éhé ízisgo ágot’eehíí naa nishné’, dawa bee nik’ehgo: díí ałk’iná’ dawa shaa hi’né’hi at’éé; dahadńta baa nishné’ hásht’į́į́yúgo baa nishné’. ");
INSERT INTO apwNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ni shonkąąhyúgo díí dawa ṉíyéé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus gánábiłdo’ṉiid, Ágágolzeego k’ená’ishchįį, Satan, shiké’gé’ ńṉáh: ágágolzeego k’ená’ishchįį, Bik’ehgo’ihi’ṉań neBik’ehń zhą́ honkąąh, da’áń zhą́ bá na’ízíid. ");
INSERT INTO apwNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ch’iidn nant’án Jesus Jerúsalemyú yił o’áázhgo, kįh biyi’ da’ch’okąąhíí hadago goz’aaníí bilatahyú yił n’áázhgo gáyiłṉii, Bik’ehgo’ihi’ṉań biYe’ ńlį́į́yúgo kogé’ gódah ch’í’ńłt’e’: ");
INSERT INTO apwNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ágágolzeego k’e’eshchįį, Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí nłt’éégo biṉádaadeł’į́į́ doleeł, ná daayiłdoṉiił: ");
INSERT INTO apwNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Áígé’, Doo tséé hitałgo hayaa nageeh dahíí bighą ánádaanołteeł doo, golzeego k’e’eshchįį. ");
INSERT INTO apwNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus ch’iidn nant’án yich’į’ hananádziigo gáyiłṉii, Bik’ehgo’ihi’ṉań neBik’ehń doo nabíńtaah da, golzee. ");
INSERT INTO apwNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ch’iidn nant’án dawa yee nayíneztąąd hik’e, Jesus yich’ą́’zhį’go dahnasdzaa, dét’įhézhį’. ");
INSERT INTO apwNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Áígé’ Jesus Holy Spirit nabiłnaago Gálileeyú onádzaa: ákú dahot’éhé nłt’éégo baa ch’iṉiigo didezdlaad lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jews ha’ánáłséh nagozṉil yuṉe’ iłch’ígó’aahgo naghaago nṉee dawa daabidnłsį. ");
INSERT INTO apwNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Názarethyú gólį́į́ n’ííyú nadzaa: ákú Jews ha’ánáłséh goz’ąą yuṉe’ oyáá, Jews daagodnłsiníí bijįį ákóṉe’ onadáhgee, áígé’ ozhíihgo hizį’, ");
INSERT INTO apwNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí, Esáias holzéhi, naltsoos biyati’ biyi’ k’e’eshchiiníí Jesus baa hit’ą́ą́. Áí naltsoosíí iłch’ą́’ áyíílaa, gáṉíígo k’e’eshchįįgee, ");
INSERT INTO apwNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Bik’ehgo’ihi’ṉań sheBík’ehń biSpirit‐híí shiká’zhį’ nlįį, nṉee tédaat’iyéhíí yati’ baa gozhóni bee bich’į’ yádaashti’ doleełgo Bik’ehgo’ihi’ṉań hashidilaahíí bighą; dázhǫ́ doo bił daagozhǫ́ǫ́ dahíí nłt’éégo ánáshdle’ doleełhíí bighą shidol’aad, isnáh daanliiníí hago’at’éégo yich’ákáhgo ła’íí biṉáá ádaagodiníí hago’at’éégo ch’ínádaaghaałgo ánádaadle’go bił nagoshṉi’go, hayíí bich’į’ nagontł’ogíí biyi’gé’ hahishṉiił doleełgo, ");
INSERT INTO apwNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ła’íí Bik’ehgo’ihi’ṉań nṉee yaa ch’oba’íí biká’ ngonyaagee baa nagoshṉi’híí bighą shi’dol’aad. ");
INSERT INTO apwNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Áígé’ naltsoosíí iłch’į’ ánáyiidlaago, nal’a’á yaa náyin’ą́ą́gé’ nánezdaa. Ha’ánáłséh goz’ąą yuṉe’ yił naháztaaníí dawa daabineł’į́į́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nṉee yich’į’ yałti’ nkegonyaago gáṉíí, Díí Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí díí jįį daasidołts’aanihíí begolṉe’. ");
INSERT INTO apwNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nṉee dawa nłt’éégo baa yádaałti’ lę́’e, yati’ nzhóni yee hadziihíí yaa bił díyadaagot’eego gádaałiłdi’ṉii, Díń la’ Joseph biye’ at’éé? ");
INSERT INTO apwNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesus gábiłṉii, Yati’ iłch’ígó’aahíí bee gádaashiłdołṉii, Izee nant’án ńlíni, dáni na’ńlziih: Capérnaumyú ánát’įįłíí yaat’ídaandzįgo kú ałdó’ dáni gonlį́į́yú ágánt’įįł. ");
INSERT INTO apwNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Bik’ehgo’ihi’ṉań binkááyú na’iziidi dá golį́į́gee doo habi’dit’įį da, da’aṉiigo ádaanohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Shíí da’aṉiigo nohwił nadaagoshṉi’, Elías t’ah hiṉaaná’ dá doo nagołtįįhé taagi łegodzaagé’ gostáń dahitąą, áígee shiṉá’ góyééhíí benagowaa lę́’e, Israel hat’i’i bitahgee isdzáné biką’ da’adini łą́ą́go daagolį́į́; ");
INSERT INTO apwNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ndi Elías doo hwaa ła’ bich’į’ bi’dol’aad da, naniyúgo itsaa Sídon godzogíí biyi’ kįh gozṉil Sarépta golzeeyú gólínihi zhą́ bich’į’ bi’dol’aad lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bik’ehgo’ihi’ṉań binkááyú na’iziidi, Elíseus holzéhi, t’ah hiṉaaná’ Israel hat’i’i bitahgee nṉee łą́ą́go łǫ́ǫ́d doo ínádįh dahi, leprosy holzéhi, yaa nakai; ndi doo ła’ nádzii daná’ nṉee Náaman holzéhi, Sýriayú gólíni, zhą́ nádzii lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ha’ánázéh yuṉe’ naháztaaníí díí Jesus áṉííhíí daideztsąąná’ bádaagoshchįįd, ");
INSERT INTO apwNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Áík’ehgo daahizį’go Jesus ch’ídaaniyood, dził nan’aahíí biká’ gotahyú yił náłseeł lę́’e, áígé’ gódah ch’ídaahilt’e’ daanzį. ");
INSERT INTO apwNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Áíná’ nṉeehíí bigizhyú ch’ínyáá lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Áígé’ Capérnaum golzeeyú ńyáá, Gálilee godzogíí biyi’, ákú Jews daagodnłsiníí bijįį dawahn iłch’ígó’aah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yebik’ehgo iłch’ígó’aahíí bighą nṉee bił díyadaagot’ee. ");
INSERT INTO apwNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jews ha’ánáłséh goz’ąą yuṉe’ ła’ nṉee ch’iidn biyi’ golínihi sidaa lę́’e, áń nawode ");
INSERT INTO apwNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Gáṉíí, Doo nohwaa nanṉaa da; hago lą́ą́ át’éégo nohwich’į’ goń’aahgo ánt’įį, Jesus, Názarethgé’ nanṉáhi? Ya’ da’izlįįyú ánohwiléhíí bighą ńyaa née? Shíí nígonsį hadń ánt’įįhíí; Bik’ehgo’ihi’ṉań bich’ą́’gé’go Dilzįhgo Ńlíni. ");
INSERT INTO apwNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus nłdzilgo hadziigo gáyiłṉii, Handziih hela’, an biyi’gé’ hanṉáh. Nṉee iłṉí’gee nṉee ch’iidn biyi’ golínihíí ch’iidn nkíbidest’ehgo dá doo hago ábile’é biyi’gé’ halwod. ");
INSERT INTO apwNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nṉee dawa bił díyadaagot’eego gádaałiłdi’ṉii, Díí yati’íí hago’at’éhi! Dawa yebik’ehgo ła’íí binawod golį́į́go spirits daanchǫ’i haołkáh yiłṉiigo hainiyood. ");
INSERT INTO apwNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dahot’éhé nṉee bitahyú nłt’éégo baa ch’iṉii didezdlaad lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nádiidzaago ha’ánázéhgé’ ch’ínádzaago Simon bigową yuṉe’ ha’ayáá. Simon bi’aadíí bimaa yóíyahgo nezgai; áí bighą nádaach’okąąh. ");
INSERT INTO apwNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yit’ahgé’ sizįįgo hat’íí binesgai shįhíí náines’įįhgo nłt’éé násdlį́į́: áík’ehgo dagoshch’į’ nádiidzaago yá da’dezné’. ");
INSERT INTO apwNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","O’i’ą́ą́zhį’ godeyaago hayíí bik’íí kah iłtah at’éhi yaa nakaihíí Jesus bich’į’yú yił neheskai; áík’ehgo dała’á daantį́į́go yik’e daadilṉiigo nádailziih lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nṉee ch’iidn biyi’ daagolííníí łą́ą́go ch’iidn nádaadihilghaashgo haikáhná’ gádaaṉii, Ni, Christ Bik’ehgo’ihi’ṉań biYe’ ńlíni. Ch’iidn Jesus, Christ nlįįgo yídaagołsįhíí bighą, nłdzilgo yich’į’ hadziigo, Hadaałdziih hela’, yiłnṉiid. ");
INSERT INTO apwNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hayołkaałyú ch’ínyáágo da’izlįįyú óyáá: áíná’ nṉee biká hadaantaago, áíke’égo baa hikai, doo yich’ą́’ digháh hádaabit’įį dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Áík’ehgo yich’į’ hadziigo gáṉíí, Łahyú kįh nagozṉilíí Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí baa yashti’ doleeł: áí bighą shi’dol’aad. ");
INSERT INTO apwNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Gálileeyú Jews ha’ánáłséh nagozṉil yuṉe’ nṉee yich’į’ yałtigo naghaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jesus túsikaaníí Gennésaret holzéhi bahyú sizįįná’ nṉee daałiłjizh, Bik’ehgo’ihi’ṉań biyati’ daidits’į́h hádaat’įįhíí bighą, ");
INSERT INTO apwNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Túsikąągee tsina’eełíí naki silaago yiłtsąą, nṉee łog hadaileehíí tsina’eeł yiyi’gé’ hakaigo biłógbehaidlehé nanestł’óli tádaigisgo. ");
INSERT INTO apwNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesus tsina’eełíí dała’á Simon bíyééhíí yeh hiyaaná’, Simon gáyiłṉii, Da’aṉahzhį’ shił ńł’eeł. Áígé’ tsina’eełíí yiyi’ dahnezdaa, áígé’ nṉee yił ch’ígó’aahgo yich’į’ yałti’. ");
INSERT INTO apwNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ąął nyáńłti’ná’ Simon gáyiłṉii, Tú łą́ą́yú idnł’eełgo áígé’ niłógbehaidléhé ténłtsosgo beha’íílée. ");
INSERT INTO apwNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Áík’ehgo Simon gábiłṉii, Iłch’ígó’aahíí, ch’éh ádaahiit’įįgo iskąą ndi doo ła’ hadaasiidlee da: da’ágát’éé ndi da’áshiłnṉiiyú áshṉe’go shiłógbehaidlehé hayaa ashłe’, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ágádaadzaago łóg dázhǫ́ łą́ą́go hayíléego biłógbehaidlehé bich’ą́’ ndaasdlaad lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ła’ yił hada’ileehíí aṉahyú tsina’eełíí bił dahna’eełíí yich’į’ yída’dishgish, Nohwich’odaałṉiih, daaṉiigo, Áík’ehgo áí bich’į’ bił nda’iz’eelgo tsina’eełíí da’áła łóg biyi’ ha’desbįhgo tsina’eełíí hayaa téłtł’á’o’eeł nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Peter díí yiłtsąągo Jesus biyahzhį’ hayaa adzaago gáṉíí, SheBik’ehń, shich’ą́’zhį’go dahnṉáh, nṉee binchǫ’ łánihi nshłįįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon ła’íí yił hada’ileehíí biłgo dawa bił díyadaagot’ee, łóg dázhǫ́ łą́ą́go hadaizlee’híí bighą: ");
INSERT INTO apwNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","James ła’íí John biłgo, Zébedee biye’kehi, Simon yił nada’iziidi, ałdó’ bił díyadaagot’ee. Jesus Simon gáyiłṉii, Doo nénłdzid da; kodé’ godezt’i’go łóg hayihileehíí k’ehgo nṉee shá náhiláh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Áík’ehgo bitsina’eełíí tábąąyú ndaayisṉilná’ dawahá akúyaa ndaizṉilná’, Jesus yiké’ dahiskai lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesus kįh gozṉilyú nyáágo nṉee łóód doo ínádįh dahi, leprosy holzéhi, yaa nagháhi Jesus yiłtsąąná’ hayaa adzaago náyokąąhgo gáyiłṉii, SheBik’ehń, náshíńlziihíí bik’e síńtįįgo nígonsį, háńt’įįyúgo náshíńlziih. ");
INSERT INTO apwNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus yich’į’ dahdidilṉiigé’ yedelṉii’go gáyiłṉii, Hasht’į́į́, nándziih. Áí dábiłgo łóód n’íí ínásdįįd lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesus gábiłṉii, Hadń dánko bił nagolṉí’ hela’: ti’i, okąąh yebik’ehń bich’į’ ch’í’ṉah ádńdle’go, Moses ngon’ą́ą́ lę́’ehíí k’ehgo hat’íhíta be’okąąhíí Bik’ehgo’ihi’ṉań baa nné’, hanánidelzaahíí bighą, áík’ehgo nándziihíí nṉee yídaagołsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Áíná’ yúwehyú ch’iṉii didezdlaad: áík’ehgo nṉee doo ałch’ígé Jesus yałti’íí daidits’į́h hádaat’įį ła’íí kah iłtah at’éhi yaa nakaihíí nádaabi’dilzii hádaat’įįhíí bighą baa hikáh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Áígé’ Jesus dasahn da’izlįįyú óyááyú oskąąd. ");
INSERT INTO apwNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Áíná’ ła’ jįį Jesus iłch’ígó’aahgo Phárisees daanlíni ła’íí begoz’aaníí iłch’ídaago’aahi itah naháztąą lę́’e, Gálilee biyi’, Judéa biyi’ daagotahgé’, ła’íí Jerúsalemgé’ hikaihi: Jesus Bik’ehgo’ihi’ṉań binawodíí biłnlįįgo nádailziih. ");
INSERT INTO apwNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jesus yałti’ná’ ła’ nṉee di’ili Jesus bich’į’ ndaach’íłteehgo biyahzhį’ ndaach’íłteehgo ch’éh ádaach’it’įį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Dázhǫ́ ch’iląądgo doo hayú Jesus bich’į’ ch’ígót’i’ dahíí bighą kįh biká’yú hádaach’istįįgo Jesus siziiníí bik’ehgé’ ch’í’í’áńgo ádaach’izlaagé’ a’ádaach’istįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesus nṉee bi’odlą’ yígołsįįdná’ di’ilihíí gáyiłṉii, Shik’isn, ninchǫ’íí da’izlíné nádleeh. ");
INSERT INTO apwNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Begoz’aaníí ye’ik’eda’iłchíhi ła’íí Phárisees daanlíni biłgo dábiyi’yú na’ídaadiłkidgo gádaaṉii, Hadń láhi áń Bik’ehgo’ihi’ṉań ádil’įįgo aṉíí? Hadń konchǫ’íí da’izlíné áile’? Bik’ehgo’ihi’ṉań zhą́ go’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus áí natsídaakeesíí yígołsįįdná’ gáyiłṉii, Hat’íí bighą dánohwiyi’yú na’ídaadołkid? ");
INSERT INTO apwNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hayííhíí doo nyeego ách’iṉiih da, Ninchǫ’íí da’izlíné nádleeh, dagohíí, Nádndáhgo dahnṉáh? ");
INSERT INTO apwNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ni’gosdzáń biká’ nṉee binchǫ’íí da’izlį́į́ alṉe’íí shíí, nṉee k’ehgo Niyááhíí, beshik’ehgo bídaagonołsį doleełhíí bighą, (nṉee di’ili sitiiníí gáyiłnṉid,) Nádndáhgo biká’ síntiiníí dahnádnné’go gowąyú nádńdáh, niłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nṉee biṉááł dagoshch’į’ nádiidzaago yiká’ sitįį n’íí dahnáyiné’go gowąyú onádzaa, Bik’ehgo’ihi’ṉań ya’ahénzįgo. ");
INSERT INTO apwNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nṉeehíí dawa dázhǫ́ bił díyadaagot’eego Bik’ehgo’ihi’ṉań ya’ahédaanzį, áígé’ tsídaadesyizgo gádaaṉii, Díí jįį ánágot’įįłíí doo hwaa ła’ hat’íí gát’éégo daahiit’įį da. ");
INSERT INTO apwNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Díí bikédé’go Jesus ch’ínádzaago tax nanáhi’ṉiłígee nṉee tax bich’į’ nahi’ṉiiłihi, Levi holzéhi, sidaago yiłtsąą lę́’e: áík’ehgo gáyiłṉii, Shiké’ dahnṉáh. ");
INSERT INTO apwNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Áík’ehgo dawahá da’akú nazṉilná’ nádiidzaago Jesus yiké’ dahiyaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi bigowąyú Jesus bá da’odąą: áígee nṉee łą́ą́go tax bich’į’ nadaahi’ṉiiłíí, nṉee ła’ihíí biłgo, Jesus ła’íí bitsiłke’yu itah da’iyąązhį’ naháztąą. ");
INSERT INTO apwNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Áíná’ Phárisees daanlíni ła’íí bitahyú begoz’aaníí ye’ik’eda’iłchíhi biłgo Jesus bitsiłke’yu yída’iłtahgo gádaayiłṉii, Hat’íí bighą tax bich’į’ nadaahi’ṉiiłíí ła’íí nṉee doo bik’ehyú ádaat’ee dahíí bił da’ołsąą? ");
INSERT INTO apwNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus gádaabiłṉii, Doo hago’ádaat’ee dahíí izee nant’án doo yaa nakah bik’eh da, daanezgaihíí zhą́. ");
INSERT INTO apwNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Shíí nṉee doo bik’ehyú ádaat’ee dahíí, Nohwinchǫ’íí bich’ą́’zhį’ ádaałṉe’, biłdishṉiiyú níyáá, áíná’ doo nṉee dábik’ehyú ádaat’eehíí ágáłdishṉiiyú níyáá da. ");
INSERT INTO apwNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Phárisees Jesus gádaayiłṉii, Hat’ííshą’ bighą John bitsiłke’yu dáshiṉá’ da’okąąh, ła’íí Pharisees bitsiłke’yu ałdó’ ágádaat’ee; áíná’ ni nitsiłke’yuhíí doo dáshiṉá’ da’okąąh da? ");
INSERT INTO apwNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus gádaabiłṉii, Ya’ ni’i’ṉéhgee nṉee dała’ádaat’eehíí nṉee niiṉéhíí yił nakaiyúgo dáshiṉá’ da’okąąh née? ");
INSERT INTO apwNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dahagee nṉee niiṉéhíí bich’ą́’ nádilteeh ndi at’éé, áígee dáshiṉá’ da’okąąh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus iłch’ígót’aahgo na’goṉi’íí ałdó’ yee hadziigo gábiłṉii, Doo hadń íí áníidéhíí haizǫǫsgo íí dénchǫ’éhíí yenádi’aah da; ágádzaayúgohíí áníidéhíí biká’ ch’ída’i’áń hileehná’ íí dénchǫ’éhíí áníidéhíí béédit’ąągo doo łełt’ee da. ");
INSERT INTO apwNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ła’íí wine áníi alzaahíí ikágé wine bee nałtiníí dénchǫ’éhíí doo biyi’ tádaach’iṉił da; ágách’idzaayúgo wine áníi alzaa’ihíí ikágé yidiłdohgo na’ṉil, áík’ehgo winehíí ąął ha’ijooł, ła’íí ikágéhíí koch’ą́’ yiłchǫǫh. ");
INSERT INTO apwNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Áíná’ wine áníi alzaahíí wine bee nałtiníí áníidéhíí zhą́ biyi’ tádaach’iṉił; áík’ehgo daańłt’éé ńt’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hadń wine da’iłtsé alzaahíí yodlaaníí, doo áníi alzaahíí hát’į́į́da; Wine da’iłtsé alzaahíí zhą́ nłt’éé, ṉiihíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jews daagodnłsiníí bijįį nakigeehíí Jesus tł’oh nagháí hentííníí yiyi’yú higaał; bitsiłke’yu yił hikaahgo tł’oh nagháí binest’ą’ nadaayiṉiił; áígé’ daidnzhishgo daayiyąą lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Phárisees daanlíni ła’ gádaabiłṉii, Hat’íí bighą godilziníí bijįį doo hat’íí baa nach’ighaa dahíí ádaałt’įį? ");
INSERT INTO apwNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus gáṉíí, Ya’ David ła’íí yił nakaihíí biłgo shiṉá’ daasilįįgo hago ádaasdzaa láń shįhíí doo hwahá baa da’ołshiih da née? ");
INSERT INTO apwNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bik’ehgo’ihi’ṉań daach’okąąh goz’ąą yuṉe’ ha’ayáágo, báń Bik’ehgo’ihi’ṉań ye’okąąhgo baa hi’né’go nii’né’ n’íí náidnné’go yiyąą, ła’íí yił nakaihíí ałdó’ ła’ yá’ńné’ lę́’e; áí báńhíí okąąh yedaabik’ehi zhą́ daayiyąągo goz’ánihi. ");
INSERT INTO apwNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Shíí, nṉee k’ehgo Niyááhíí, godilziníí bijįį ndi beshik’eh, ṉii, Jesus. ");
INSERT INTO apwNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Łah Jews daagodnłsiníí bijįį ha’ánáłséh goz’ąą yuṉe’ Jesus ha’ayáágo iłch’ígó’aah lę́’e: akóṉe’ nṉee bigan dihe’nazhiṉéégo binawod ásdįįdi itah sidaa. ");
INSERT INTO apwNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Begoz’aaníí ye’ik’eda’iłchíhi ła’íí Phárisees daanlíni biłgo Jesus daineł’į́į́ lę́’e, godilziníí bijįį nṉeehíí náyilziih shį daanzįgo; ágádzaayúgo Jesus hat’íhíta yee yaa dahdaago’aahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Áíná’ Jesus áí natsídaakeesíí yígółsįhíí bighą nṉee bigan binawod ásdįįdi gáyiłṉii, Nádndáhgo kodé’ hizįį. Áík’ehgo nádiidzaago áígee hizį’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesus begoz’aaníí ye’ik’eda’iłchíhi ła’íí Phárisees biłgo gádaayiłṉii, Dała’á nanohwídaadishkid, ya’ godilziníí bijįį nłt’éégo ách’ít’įįgo goz’ąą née, dagohíí dénchǫ’égo ách’ít’įį née? Ya’ nṉee hasdách’iłteehgo née, dagohíí ch’iziłheego née? ");
INSERT INTO apwNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesus nṉee yitah déz’įį lę́’e, áígé’ nṉee bigan binawod ásdįįdi gáyiłṉii, Yushdé’ dahdinlṉíh. Ágádzaaná’ bigan nłt’éé násdlį́į́, łahzhiṉééhíí ga’at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nṉee Jesus yik’edaanṉiihíí hadaashkeego gádaałiłdi’ṉii, Jesus hagoshą’ ádaahiidle’? ");
INSERT INTO apwNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Áíná’ Jesus dasahn dziłyú óyáá okąąhgo, Bik’ehgo’ihi’ṉań yich’į’ okąąhgo iskąą. ");
INSERT INTO apwNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Hayiłką́ą́yú biké’ hikahíí, Yushdé’, daayiłnṉiidná’ nakits’ádah hayiṉil: áí shinadaal’a’á daayiłṉii; ");
INSERT INTO apwNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon, (Peter yízhi’ yá áyíílaahíí,) bik’isn Andrew, ła’íí James, John, Philip, Barthólemew, ");
INSERT INTO apwNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew, Thomas, ła’íí James Alphéus biye’i, Simon Zelótes holzéhi, ");
INSERT INTO apwNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas James bik’isn, ła’íí Judas Iscáriot, ch’íbido’aał doleełi. ");
INSERT INTO apwNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Dziłgé’ yił nkenákainá’ dziłíí bitl’ááhgee sizįį, áígee biké’ hikahíí, ła’íí nṉee łą́ą́go Judéagé’, Jerúsalemgé’, ła’íí tádá’yú Tyre ła’íí Sídongé’ daagolínihi daabidits’į́h hádaat’įįgo, ła’íí daanezgaihíí nádaabidilziih hádaat’įįgo baa náńłsą́ą́; ");
INSERT INTO apwNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hayíí spirits nchǫ’i biyi’ daagolííníí ałdó’ baa hikai: áík’ehgo náda’bidilzii lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nṉee dawa bedaadilchiid hádaat’įį lę́’e: binawodíí nádaabilziihíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Biké’ hikahíí yineł’į́į́go gáyiłṉii, Nohwíí tédaanołt’iyéhíí nohwiyaa gozhǫ́ǫ́ doleeł: Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah daanołįį. ");
INSERT INTO apwNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","K’adíí shiṉá’ daanołiiníí nohwiyaa gozhǫ́ǫ́ doleeł: náda’dołdǫǫł. K’adíí daałchagíí nohwiyaa gozhǫ́ǫ́ doleeł: daałdloh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Shíí, nṉee k’ehgo Niyááhíí, shighą nṉee nohwik’edaanṉiihyúgo, ła’íí doo hádaanohwit’įį dayúgo, nchǫ’go nohwich’į’ yádaałti’yúgo, nohwizhi’ nchǫ’go yaa yádaałti’yúgo nohwiyaa gozhǫ́ǫ́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Áí bijįį dázhǫ́ nohwił daagozhǫ́ǫ́go yaadaołjah le’: yaaká’yú itisgo nohwaa hi’né’i dázhǫ́ nchaa doleeł: nṉee nohwik’edaanṉiihíí bich’ą́’gé’ nṉee daanlínihíí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí ałdó’ ágádaayiłsį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Áíná’ nohwíí ízisgo da’ołt’iiníí, nohwá góyéé doleeł! ałk’iná’ dawa hádaałt’iiníí nohwíyéé. ");
INSERT INTO apwNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","K’adíí náda’sołdįįdíí, nohwá góyéé doleeł! shiṉá’ daanołįį doleeł. K’adíí daałdlohíí, nohwá góyéé doleeł! ík’edaadoł’ṉii ła’íí daołchag doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nohwíí nṉee dawa nłt’éégo nohwaa yádaałti’ihíí, nohwá góyéé doleeł! áí bich’ą́’gé’ nṉee daanlínihíí Bik’ehgo’ihi’ṉań binkááyú nada’iziidíí daazhógo ádaadil’íni n’íí ágádaayiłnṉiid ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Shihíí daashidołts’agíí gádaanohwiłdishṉii, Nohwik’edaanṉiihíí nohwił daanzhǫǫ le’, hayíí bił daanołchǫ’íí nłt’éégo bich’į’ ádaanołt’ee le’, ");
INSERT INTO apwNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yati’ yee daanohwókaałíí nłt’éégo bich’į’ natsídaałkees le’, ła’íí nchǫ’go nohwich’į’ ádaat’eehíí bá da’ołkąąh le’. ");
INSERT INTO apwNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Hadń nitł’ah yonłts’íyúgo łahzhiṉéé bich’į’ nnanínt’aah; hadń ni’íícho nich’ą́’ náidiłtsoozyúgo n’íí ałdó’ doo baa ńchį’ da. ");
INSERT INTO apwNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dahadń hat’íí níyókeedíí baa nné’; hadń dahat’íhíta ṉíyééhíí nich’ą́’ náidnné’yúgo doo t’ąązhį’ bínáhóńkeed da. ");
INSERT INTO apwNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nṉee hago’at’éégo nohwich’į’ ádaat’eego hádaałt’įįhíí k’ehgo nohwíí ałdó’ bich’į’ ágádaanołt’ee. ");
INSERT INTO apwNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Hayíí bił daanołshooníí zhą́ nohwił daanzhǫǫyúgo, hago’at’éégo nłt’éé áí? Nṉee doo daagodnłsį dahíí ndi hayíí bił daanzhooníí bił daanzhǫǫ. ");
INSERT INTO apwNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Hayíí nłt’éégo ádaanłsį shįhíí zhą́ bich’į’ nłt’éégo ádaanołt’eeyúgo, hago’at’éégo nłt’éé áí? Nṉee doo daagodnłsį dahíí ndi ágádaat’íni at’éé ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nohwíí hadń hat’íí bá ch’ídaashołné’yúgo t’ąązhį’ shaa nné’ daanołsįgo, hago’at’éégo nłt’éé áí? nṉee doo daagodnłsį dahíí ndi dawahá łáłch’ínádai’né’i at’éé, da’áígee shaa nai’né’ daanzįgo. ");
INSERT INTO apwNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nohwik’edaanṉiihíí nohwił daanzhǫǫ le’, ła’íí nłt’éégo ádaałt’įį, dahat’íhíta ch’ídaanołné’ le’ doo shaa nané’ daanołsį dago; áík’ehgo yaaká’gé’ łą́ą́go nohwaa nané’ ła’íí Da’tiséyú At’éhi bichągháshé daanołįį doleeł: áń nṉee doo ahédaanzį dahíí ła’íí daanchǫ’íí ndi yich’į’ nłt’éégo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","NohwiTaa bił goch’oba’híí k’ehgo nohwíí ałdó’ nohwił goch’oba’ le’. ");
INSERT INTO apwNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Doo hadń baa nádaałt’įį da le’, áík’ehgo nohwíí ałdó’ doo nohwaa nádaach’it’įį da doleeł: nṉee doo nchǫ’go baa natsídaałkees da le’, áík’ehgo doo nchǫ’go nohwaa natsída’ikees da: nṉee nohwich’į’ nchǫ’go ánát’įįłíí baa nádaagodenoł’aah le’, áík’ehgo nohwíí ałdó’ nohwaa nágodet’aah: ");
INSERT INTO apwNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nṉee baa daanołné’, áík’ehgo nohwíí ałdó’ nohwaa na’né’; áí nłt’éégo bínel’ąądgo, hayaa iłk’ínábénisdzilgo, nłt’éégo ąął nnésgohgo haláh odaazlįįgo nohwaa nach’iné’. Dáhołąągo kaa daasołné’ láńshį n’íí k’ehgo da’ágáhołąągo nohwaa nádo’né’. ");
INSERT INTO apwNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iłch’ígót’aahgo na’goṉi’íí yee hadziigo gádaabiłnṉiid, Ya’nṉee biṉáá ágodiníí ła’ nṉee biṉáá ágodini łolǫǫs née? ágádaasdzaayúgo shą’ da’áła ínlwozh yuyaa ołiłdeeł? ");
INSERT INTO apwNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Biłch’ígót’aahíí biłch’ígó’aahi doo yitisgo at’éhi at’éé da: áíná’ daakówa nłt’éégo koł ch’ídaakost’ąąyúgo, áí bił ch’ígó’aahíí ga’ách’ít’éé daach’ileeh. ");
INSERT INTO apwNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Hat’íí bighą nik’isn biṉáá yuṉe’ tsįałch’ísę́ę sitaaníí hí’į́į́, áíná’ nihíí niṉáá yuṉe’ tsį nchaahi sitaaníí doo hí’į́į́ da? ");
INSERT INTO apwNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ni niṉáá yuṉe’ tsį nchaahi sitaaníí doo hí’į́į́ daná’, hat’íí bighą nik’isn gáłnṉii, Shik’isn, ai tsį ałch’ísę́ę niṉáá yuṉe’ sitaaníí ná haoshtįįh? Ni nzhǫǫ ádńł’íni, iłtsé niṉáá yuṉe’ tsį nchaahi sitaaníí hatįįh, áík’ehgo nłt’éégo go’į́į́ nleehgo, áníita nik’isn biṉáá yuṉe’ tsį ałch’ísę́ę sitaaníí bá hatįįh. ");
INSERT INTO apwNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Tsint’áni nłt’éhihíí doo nest’áń dénchǫ’éhíí baa dahnándahi at’éé da; ła’íí tsint’áni dénchǫ’éhíí nest’áń nłt’éhihíí doo baa dahnándahi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tsint’áni dała’á hentį́į́go nest’áń baa dahnándahíí bee bígózį. Figs doo hosh baa ndaach’ihiṉiiłhi at’éé da, ła’íí dasts’aa’íí doo hosh diwozhíí baa ndaach’ihiṉiiłhi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nṉee nłt’éhihíí bijíí yuṉe’ nłt’éégo goz’aaníí bich’ą́’gé’ nłt’éhihíí zhą́ bee hagowá; áíná’ nṉee nchǫ’íí bijíí yuṉe’ nchǫ’go goz’aaníí bich’ą́’gé’ nchǫ’íí zhą́ bee hagowá: hago’at’éégo yách’íłti’ shįhíí kojíí yuṉe’ hago’at’éégo goz’ąą shįhíí bich’ą́’gé’ ách’iṉiihi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Hat’íí bighą, SheBik’ehń, sheBik’ehń, daashiłdołṉiigo shich’į’ ádaadołṉiiná’ da’ánohwiłdishṉiiyú doo ádaanołt’ee da? ");
INSERT INTO apwNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Dahadń shaa nyááhń shíyésts’ąągo shiyati’ yikísk’eh at’ééhń, díí k’ehgo ako at’éhi at’éé: ");
INSERT INTO apwNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nṉee yúyahgo hagogéedgo tséé biká’ bigową ágodlaa: áík’ehgo tú idezjoolgo bigowąhíí bídilk’oł ndi doo hago adzaa da; nłdzilgo tséé biká’ ágolzaahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Áíná’ dahadń shíyésts’ąą ndi doo yikísk’eh at’éé dahń, díí k’ehgo ako at’éhi at’éé, nṉee bigową dá sáí zhą́ yiká’ ágodlaa, doo tséé biká’ dahgoz’ąą dago; áí gowąhíí yich’į’ tú idezjoolgo dagoshch’į’ nangóngo’; áík’ehgo aanábígotł’įįł gozlįį. ");
INSERT INTO apwNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesus nṉee bídaayésts’aaníí ąął yich’į’ nyánłti’ná’ Capérnaum golzeeyú óyáá. ");
INSERT INTO apwNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Silááda dałá’n gonenadín binant’a’íí yána’iziidi bił nzhóni nezgaigo dak’azhą́ datsaah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nant’ánhíí Jesus yaat’ínzįgo nṉee Jews yánadaazíni Jesus bich’į’ odais’a’ gáṉíígo, Yushdé’, kú ńṉáhgo shá na’iziidíí shá nánlziih, daabiłdołṉiih. ");
INSERT INTO apwNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Áík’ehgo Jesus yaa hikaigo nádaayokąąhgo gádaaṉii, Díí áíłṉiihíí bá áńdle’go dábik’eh: ");
INSERT INTO apwNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Bił daanjǫǫgo ha’ánálzéh goz’aaníí nohwá ágolaa. ");
INSERT INTO apwNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Áík’ehgo Jesus yił onákai. Nant’ánhíí bigową t’ah bich’į’ hikahná’ nant’án bit’eké Jesus bich’į’ hil’aad gáṉíígo, ShiNant’a’, nich’į’ nagóńtł’ogíí bighą dáko akú nódáh hela’; shigową yuṉe’ ha’ánṉáhgo ndi doo bik’eh sitį́į́ da: ");
INSERT INTO apwNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Naa nsháhgo doo bik’eh sitį́į́ da nsįhíí bighą doo dashíí naa niyáá da: déhadziihgo ndi shána’iziidń nádziih ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Shíí ałdó’ shinant’a’ golį́į́, shihíí silááda bá nansht’aa, dała’á, Dahnṉáh, biłdishṉiiyúgo dahdigháh; ła’íí, Yushdé’, biłdishṉiiyúgo shaa higháh, ła’íí shána’iziidi, Díí áńle’, biłdishṉiiyúgo áí áile’. ");
INSERT INTO apwNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus áí yidezts’ąąná’ dé bił díyagodzaago, nṉee biké náłseełíí yich’į’ adzaago gáyiłṉii, Gánohwiłdishṉii, Israel hat’i’i bitahyú ndi doo hwaa hadń díí k’ehgo bi’odlą’ golíni baa nsháh da. ");
INSERT INTO apwNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jesus yich’į’ oda’is’a’íí gowąyú nákainá’ nezgai n’íí nłt’éé násdlįįgo yaa nakai lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Áí iskąą hik’e Jesus kįh gozṉil, Nain golzeeyú óyáá; bitsiłke’yu ła’íí nṉee yił okai. ");
INSERT INTO apwNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Áí kįh gozṉil ch’íná’itį́h goz’aaníí yich’į’ higaałgo, nṉee édįhi ch’ídaach’iłteeh lę́’e, bimaa itsaaná’ dabíí zhą́ bizhaazhé ishkiin dała’áhi; áí isdzánhíí nṉee łą́ą́go yił náłseeł lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesus yiłtsąąná’ bijíí nṉiihgo gáyiłṉii, Doo nchag da. ");
INSERT INTO apwNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesus yaa nyáágo tsiłhwón yedolchidgo, tsiłhwón daayo’aałíí daahizį’. Áígé’ hadziigo gáṉíí, Shik’isn, nádndáh, niłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Édįhgo sitįį n’íí nezdaago yałti’ nkegonyaa. Áík’ehgo Jesus isdzánhíí bizhaazhé yaa náíńłtį́į́. ");
INSERT INTO apwNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nṉee dawa tsídaadolyizgo Bik’ehgo’ihi’ṉań ya’ahédaanzįgo gádaaṉii, Bik’ehgo’ihi’ṉań yána’iziidi ízisgo at’éhi nohwitah silįį; ła’íí, Bik’ehgo’ihi’ṉań nṉee hayihezṉilíí yaa nyáá. ");
INSERT INTO apwNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Judéa dágoz’ąą nt’éégo, ła’íí biṉaayú daagotahyú Jesus nłt’éégo baa ch’iṉii lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John bitisłke’yu díí ánágot’įįdíí dawa yaa bił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","John bitsiłke’yu naki, Yushdé’, daayiłnṉiidná’ gádaayiłṉii, Jesus bich’į’yú doł’aashgo gáłdołṉi’, Ya’ ni higháhi n’íí áńt’įį née? dagohíí ła’i biká daadéet’įį née? ");
INSERT INTO apwNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nṉee nakihíí Jesus yaa n’áázhgo gádaabiłṉii, John Baptize ágole’íí nich’į’ nohwides’a’, gániłn’ṉiihgo, Ya’ ni higháhi n’íí áńt’įį née? dagohíí ła’i biká daadéet’įį née? ");
INSERT INTO apwNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yaa n’áázhná’ Jesus nṉee łą́ą́go náyihilzii, kah iłtah at’éhi yaa nakaihíí ałdó’, spirits nchǫ’i biyi’ daagolííníí bá hanesdzood; ła’íí biṉáá ádaagodiníí daago’įįgo ánayidlaa. ");
INSERT INTO apwNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","23","Áík’ehgo áí nṉee bich’į’ hil’aadíí gáyiłṉii, John bich’į’ nádołt’aashgo díí hoł’iiníí ła’íí disołts’aaníí baa bił nagołṉi’: biṉáá ádaagodįh n’íí biṉáá ánágodle’, doo nadaakai da n’íí náhikáh, nṉee łóód doo ínádįh dahi yaa nadaakai n’íí nłt’éégo ánádaidle’, bijeyi’ ádaagodįh n’íí da’idits’ag ánádaidle’, nanezna’ n’íí naahikáhgo ánádaidle’, tédaat’iyéhíí yati’ baa gozhóni bee bich’į’ yáda’iti’. ");
INSERT INTO apwNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nṉee John daabis’a’íí t’ąązhį’ onát’aazhná’, Jesus nṉee dała’at’ééhíí John yaa nagolṉi’go yich’į’ yałti’ nkegonyaa gáṉíígo, Da’izlį́į́yú hat’íí hádaadeł’į́į́yú nasołkai? Tł’oh bit’ąą nteelíí bił godiyołíí née? ");
INSERT INTO apwNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Hat’íí hádaadeł’į́į́yú nasołkai áíná’? Nṉee nłt’éégo bik’e’izláhi née? Hayíí bidiyágé nłt’ééhíí ła’íí ízisgo daagolííníí nant’án golį́į́gee nadaakaihi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Hat’íí lą́ą́ hádaadeł’į́į́yú nasołkai áíná’? Bik’ehgo’ihi’ṉań binkááyú na’iziidi née? Ha’aa, Bik’ehgo’ihi’ṉań binkááyú nada’iziidi yitisgo at’éhi, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Díí bak’e’eshchįį n’íí áń át’į́į́, Shinal’a’á nádn dish’aa, nádn iłch’į’gole’go. ");
INSERT INTO apwNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Gánohwiłdishṉii, Nṉee daagozlííníí bitahyú Bik’ehgo’ihi’ṉań binkááyú nada’iziidi doo ła’ John Baptize ágole’íí yitisgo at’éé da: áíná’ Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí bitahyú hadń dázhǫ́ doo ilį́į́ dahíí John yitisgo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nṉee dawa Jesus daidezts’aaníí ła’íí tax bich’į’ nadaahi’ṉiiłíí John baptize ádaabizlaa n’íí, Bik’ehgo’ihi’ṉań dázhǫ́ nłt’éégo at’éé, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Áíná’ Phárisees ła’íí begoz’aaníí nłt’éégo yídaagołsini, John doo hwaa baptize ádaabizlaa dahíí bighą Bik’ehgo’ihi’ṉań ngon’ááníí doo hádaat’įį dago yich’ą́’zhį’ ádaat’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesus gáṉíí, Nṉee daałinolt’įįłíí hat’íí bił łíshhah nishłeego baa nagoshṉi’? hat’íí bił dáłełt’ee? ");
INSERT INTO apwNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Na’iṉiih nagoz’ąągee chągháshé dała’at’éégo iłch’į’ ádaaṉiigo, Tsįsól bee nohwich’į’ da’nt’aał ndi doo hwaa ch’adaashinołzhil da, daałiłdi’ṉiihíí bił dáłełt’ee. ");
INSERT INTO apwNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","John Baptize ágole’íí doo báń yiyąą dago ła’íí doo wine yidląą dago nyaaná’; Ch’iidn biyi’ golį́į́, daadołṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Shíí, nṉee k’ehgo Niyááhíí, ishąągo ła’íí ishdląągo niyááná’ gádaashiłdołṉii, Áń dichini ła’íí idlánihi, tax bich’į’ nadaahi’ṉiiłíí ła’íí nṉee doo bik’ehyú ádaat’ee dahíí bit’eké nlíni! ");
INSERT INTO apwNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Da’aṉii igoyą’íí hat’íí ádaat’įįłíí bee bígózįh. ");
INSERT INTO apwNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ła’ Phárisee nlíni Jesus, Shigowąyú ńṉáá, yiłṉii. Áík’ehgo Jesus áí Phárisee bigowąyú nyaayú iyąągo nezdaa. ");
INSERT INTO apwNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ła’ isdzán binchǫ’ łánihi áí kįh gozṉilgee golínihi, Jesus Phárisee bigowąyú iyąągo yaat’ínzįgo tús tséé, alabáster holzéhi, bee alzaahi yee ik’ah yin’ą́ą́go, ");
INSERT INTO apwNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesus dés’eezi yiṉe’gé’ hichago hizį’, biṉáá túhíí bee Jesus bikee yá táyigis nkegonyaa, bitsizíl yee k’eyiłdéh, áígé’ daayits’ǫsgé’ ik’ah yaa yiziid lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Phárisee yił iyąą’ń díí isdzán at’ííníí yo’įįgo dabíí gádiłdi’ṉii, Díí nṉeehíí Bik’ehgo’ihi’ṉań binkááyú na’iziidi nlįįyúgo, díí isdzán bídilchi’íí hadń át’į́į́ shįhíí hago’at’éé shįhíí yígółsį doleeł ni’; binchǫ’ łánihi at’ééná’. ");
INSERT INTO apwNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus bich’į’ hadziigo gáṉíí, Simon, hat’íí shį niłdishṉii. Áík’ehgo Simon gábiłṉii, Ánṉii, iłch’ígó’aahíí. ");
INSERT INTO apwNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ła’ nṉee zhaali ách’íiṉíłi nṉee naki yaa yił’áá lę́’e: nṉee dała’á ashdla’i gonenadín zhaali, penny holzéhi, baa ha’áá, ła’ nṉeehíí ashdladin baa ha’áá, ");
INSERT INTO apwNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Doo hago’at’éégo nanáda’i’ṉiił da lę́’e, da’ágát’éé ndi nzhǫǫ yiłnṉiid. Díí nṉee nakihíí hayííhíí nṉee zhaali ách’íiṉíłi itisgo bił nzhǫǫ gá? ");
INSERT INTO apwNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon hananádzii, Hayíí dázhǫ́ itisgo baa ha’áá shįhíí go’į́į́. Jesus gábiłṉii, Da’áígee ádínṉiid. ");
INSERT INTO apwNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesus isdzánhíí yich’į’ adzaaná’ Simon gáyiłṉii, Ya’ díí isdzánhíí hí’į́į́ née? Nigową yuṉe’ ha’ayááná’ doo hwaa tú shikee bee tánágisíí shaa ńziid da: áíná’ díí isdzánhíí biṉáá túhíí bee shikee shá táyigisgé’ bitsizílíí bee k’e’iłdee. ");
INSERT INTO apwNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ni doo hwaa shísíńts’ǫs da: áíná’ ha’ayáágé’ yushdé’ godezt’i’go díí isdzánhíí shikee daayits’ǫs nkegonyaa ni’. ");
INSERT INTO apwNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Doo hwaa ik’ah shitsit’á’ bídínzhizh da: áíná’ díí isdzánhíí ik’ah shikee yídezhizh. ");
INSERT INTO apwNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Áík’ehgo gániłdishṉii, Isdzán binchǫ’ dázhǫ́ łą́ą́híí da’izlíné bá ánálṉe’, dázhǫ́ bił nshǫǫhíí bighą: áíná’ hadń binchǫ’ ayą́háhíí da’izlíné bá ánálṉe’íí, ayą́hágo bił nshóni at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesus isdzánhíí gáyiłṉii, Ninchǫ’íí da’izlíné ná ánálṉe’. ");
INSERT INTO apwNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nṉee yił da’ayaaníí gádaałiłdi’ṉii, Hadń láhi díí, konchǫ’íí da’ízlíné ká ánáidle’i? ");
INSERT INTO apwNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesus isdzánhíí gánáyiłdo’ṉiid, Ni’odlą’íí hasdáníłtį́į́; iłch’į’gont’éégo dahnádndáh. ");
INSERT INTO apwNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Áí bikédé’go Jesus kįh nagozṉilyú ła’íí gotahyú dahot’éhé nṉee áígee daagolííníí yich’į’ yałti’go ła’íí Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí nłt’éégo baa na’goṉi’íí yaa nagolṉi’go naghaa lę́’e: bitsiłke’yu nakits’ádah yił nakai, ");
INSERT INTO apwNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ła’íí isdzáné spirits nchǫ’íí biyi’ daagolį́į́ n’íí ła’íí kah iłtah at’ééhíí yaa nadaakai n’íí nádaabi’dilzii lę́’ehi yił nakai ałdó’, Mary, Mágdalene daałch’iṉiihi, ch’iidn gosts’idn biyi’gé’ hakaihi, ");
INSERT INTO apwNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ła’íí isdzán Joánna, nant’án Hérod bikįh yá bik’ehi, Chúza holzéhi, bi’aad; ła’íí Susánna, ła’íí isdzáné doo ałch’ídé dahi, ałdó’ yił nakai, áí isdzánéhíí bíyééhíí łahzhį’ Jesus yee yich’odaazṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ił’ánigé’ kįh nagozṉilgé’ nṉee łą́ą́go Jesus yaa náńłsą́ą́, áígee na’goṉi’íí yee yił ch’ígó’aahgo gáṉíí: ");
INSERT INTO apwNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","K’edileehíí yił ke’go k’edileeyú óyáá: k’edileegee k’edilzíí ła’ itín bahyú nanehezdee; áí ła’ nṉee yiká’ naskai, ła’ihíí dlǫ́’ nádaihezlaa. ");
INSERT INTO apwNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ła’ k’edilzíí tsééká’ nanehezdee; ndi hadaazhjeedgo dagoshch’į’ daanłṉago nádaahisgą, doo nłt’éégo godit’oodyú hadaazhjeed dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ła’ihíí hosh bitahyú nanehezdee; áík’ehgo hoshihíí igháńłsąągo nadaistseed. ");
INSERT INTO apwNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ła’ k’edilzíí łeezh nłt’ééyú nanehezdee, áí zhą́ hadaazhjeedgo dała’á gonenadín bitisyú ánálzaa. Ąął nagosṉi’ná’ gánṉiid, Hadń bijeyi’ golííníí íyésts’ąą le’. ");
INSERT INTO apwNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bitsiłke’yu nabídaadiłkidgo gádaabiłṉii, Iłch’ígót’aahgo na’goṉi’íí bee nohwił nadaagosíńlṉi’íí hat’íí ṉiigo ánṉii? ");
INSERT INTO apwNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesus gáṉíí, Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’áni doo bígózį da n’íí nohwíí bídaagonołsįįhgo nohwaa daagodest’ąą: áíná’ ła’ihíí iłch’ígót’aahgo na’goṉi’íí zhą́ bee bił na’goṉi’; áík’ehgo dédaineł’įį ndi doo daayo’įį da doleeł, ła’íí dédaidits’ag ndi doo bił ídaagozį da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Iłch’ígót’aahgo na’goṉi’íí hat’íí ṉiigo ádishṉii shįhíí baa nohwił nagoshṉi’: K’edilziihíí Bik’ehgo’ihi’ṉań biyati’ at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","K’edilzíí itínyú nanehezdee n’íí áí nṉee yati’ daidezts’ąą, ndi ch’iidn nant’án nyáágo yati’ bijíí yuṉe’ benagoz’aaníí bich’ą́’ náyihezlaa’íí ádaat’ee, doo da’osdląądgo hasdákai dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","K’edilzíí tséé yiká’ nanehezdee n’íí nṉee bił daagozhǫ́ǫ́go daidezts’ąą; áíná’ tł’oh bikeghad ádįįhíí k’ehgo ádaat’eego, dét’įhézhį’ yati’ daayodląą, áíná’ nabída’dintaahgee t’ąązhį’ nanánihidéh. ");
INSERT INTO apwNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","K’edilzíí hosh biyi’ nanehezdee n’íí nṉee yati’ daidezts’ąą, ndi dahikáhyú ni’gosdzáń biká’ ágot’eehíí, ízisgo it’ííníí, ła’íí gonedliiníí zhą́ yaa natsídaakeesíí ádaat’ee, áík’ehgo doo nest’ą’ goleeh da. ");
INSERT INTO apwNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","K’edilzíí łeezh nłt’ééyú nanihezdee n’íí yati’ daidezts’ąąná’ daabijíí nłt’éhi biyi’ yuyaa yati’ ích’iyołtą’, áík’ehgo nest’ą’ nłt’ééhíí yinłt’ąą dayúweh yaa hikaahgo. ");
INSERT INTO apwNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Doo hadń ik’ah kǫ’íí yidiłtłaadgo dahat’íhíta yitł’ááh ch’aanáidił’įį da, dagohíí doo kástíné yitł’ááhyú nyiłt’áah da; áíná’ ik’ah kǫ’íí biká’ dahnásiłt’áhé yiká’ dahyi’aah, áík’ehgo hayíí ha’áhikáhíí áí kǫ’íí yee daago’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dawahá nanl’į’ n’ií ch’í’ṉah ádolṉiił; dawahá doo hit’įį da n’íí bígózįhgo hit’įį doo. ");
INSERT INTO apwNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Áí bighą da’dołts’agíí nłt’éégo ídaayesółts’ąą: dahadń íyésts’ąągo ígoł’aahń bigoyą’íí itisgo baa nádo’né’; áíná’ dahadń doo íyésts’ąą dahń, ayą́hágo ígoł’ąą n’íí ndi bich’ą́’ da’ílíí nádodleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus bimaa ła’íí bik’isyú biłgo baa hikai, ndi Jesus baa ch’iląąhíí bighą doo hago’at’éégo baa hikáh da lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nimaa ła’íí nik’isyú biłgo naa hikáh hádaat’įįhíí bighą dadáńyú nadaazį, daabiłch’inṉiid. ");
INSERT INTO apwNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesus hadziigo gáṉíí, Bik’ehgo’ihi’ṉań biyati’ yidezts’ąągo yikísk’eh ádaat’eehíí shimaa ła’íí shik’isyú ádaat’ee. ");
INSERT INTO apwNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Łah jįį Jesus tsina’eełíí yeh hiyaa, bitsiłke’yu biłgo: bitsiłke’yu gádaayiłṉii, Noo’, hanaazhį’ nohwił nada’do’éel. Áík’ehgo bił dahda’n’eel. ");
INSERT INTO apwNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bił da’o’ołyú Jesus iłhaazh lę́’e: áígé’ dát’éégo deshch’iidgo tú nádidáh silįįgo tsina’eełíí bidaadesk’olgo ńgodzid lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Áík’ehgo Jesus ch’ínádaabisidgo gádaabiłṉii, NohweBik’ehń, nohweBik’ehń, k’azhą́ téłtł’áh nohwił ogo’eeł. Áík’ehgo ch’ínádzidgo ńch’iidíí ła’íí tú hashkeego nádídáhíí yich’į’ hadziigo óch’iidgo nkenágoheltǫ’. ");
INSERT INTO apwNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesus bitsiłke’yu gáyiłṉii, Hago’at’éégo nohwi’odlą’íí doo bada’ołíí da? Tsídaadolyiz ła’íí bił díyadaagot’eego gádaałiłdi’ṉii, Hago’at’éégo ląą, díí nṉeehń tú ła’íí ńch’iidíí ndi da’áyiłṉiiyú ádaat’ee! ");
INSERT INTO apwNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gadarénes daagolį́į́yú Gálilee biṉaazhį’yú bił nada’diz’eel. ");
INSERT INTO apwNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesus tsina’eełíí yiyi’gé’ háyáágo kįh gozṉilgé’ nṉee ła’ doo áníiná’ godezt’i’go ch’iidn biyi’ golíni baa nyáá, áń bidiyágé da’ádįhgo nagháhi, nṉee łena’ṉiłíí goz’ąąyú gólíni, doo kįh biyi’ da. ");
INSERT INTO apwNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesus yiłtsąąná’ nádidilghaazhgo yiyahzhį’ hayaa adzaago, nawode gáṉíí, Hago lą́ą́ áshíle’go áńt’įį, Jesus, Bik’ehgo’ihi’ṉań da’tiséyú at’éhi biYe’ ńlíni? Nánoshkąąh, shiniigodoléh hela’. ");
INSERT INTO apwNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Jesus spirit nchǫ’íí ałk’iná’ gáyiłnṉiid, An biyi’gé’ hanṉáh. Doo ałch’ídn ch’iidnhíí nabihesłaa da: bésh hishbizhíí ła’íí kokee bee łínádaach’iłtł’óhíí bee łíbi’destł’ǫǫ; ndi łíbi’destł’ooníí nyihidzįįzgo ch’iidn da’ilįįyú onábinyo’.) ");
INSERT INTO apwNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus nabídiłkidgo, Hat’íí honlzéé? biłṉii. Shíí Łáni honszee, nṉiid: ch’iidn doo ałch’ídé biyi’ oheskai dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jesus nádaayokąąhgo, Doo yúyahgo o’i’áńyú dołkáh nohwiłdoṉii hela’, daanṉiid. ");
INSERT INTO apwNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Áígee dziłyú góchi da’ayąągo nanałsé’: ch’iidn Jesus nádaayokąąhgo gádaaṉii, Góchi behokáh. Áík’ehgo Jesus yaa goden’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Áík’ehgo nṉeehíí yiyi’gé’ hakaigo góchi nanałsé’íí yiyi’ oheskaigé’ túnteel sikaaníí yeh nałsą́ą́go hayaa nádnkįįgo tú yił daadesdzii. ");
INSERT INTO apwNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Góchi yiṉádaadéz’įį n’íí díí ágodzaahíí daayiłtsąąná’ nádnkįįgo, kįh gozṉilyú ła’íí biṉaayú gotahyú yaa nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nṉee bił nada’gosṉi’íí áí ágodzaahíí daineł’į́į́yú oheskai lę́’e. Jesus yaa hikainá’ nṉee ch’iidn biyi’ golį́į́ n’íí Jesus bikeeyú sidaago daayiłtsąą, áí nṉeehíí ch’iidn biyi’gé’ haheskaigo k’adíí biini’ golį́į́go bidiyágé gólį́į́go sidaa, áík’ehgo ńdaaldzid lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nṉee biṉááł ágodzaahíí hago’at’éégo nṉee ch’iidn isná ábiłsį n’íí biyi’gé’ ch’iidn hainiyoodgo nailziihíí yaa nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nṉee Gadarénes daanliiníí bini’yú daagolínihíí dawa ńdaaldzidhíí bighą Jesus, Nohwich’ą́’zhį’ dahnṉáh, daayiłṉii; áík’ehgo tsina’eełíí yeh nádzaago t’ąązhį’ bił oná’í’éél. ");
INSERT INTO apwNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nṉee ch’iidn yiyi’gé’ hanałsą́ą́ n’íí nábokąąhgo, Nił nádósht’aash, ṉii: áíná’ Jesus t’ąązhį’ onábíł’a’, gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Nigowąyú nádńdáhgo Bik’ehgo’ihi’ṉań hago nłt’éégo ánániidlaahíí baa nagólṉi’yú. Áík’ehgo Jesus hago nłt’éégo ánábiidlaahíí kįh dágozṉil nt’éégo yaa nagolṉi’go anádaał. ");
INSERT INTO apwNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesus hanaayú bił naná’dez’eelná’ akú nṉee łą́ą́go biba’ dała’at’éégo Jesus baa nyááhíí yaa bił daagozhǫ́ǫ́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nṉee ła’ Jáirus holzéhi, Jews ha’ánáłséhíí yebik’ehń, Jesus yaa nyáá lę́’e; yiyahzhį’ hayaa adzaago náyokąąhgo gáṉíí, Shigowąyú ńṉáh: ");
INSERT INTO apwNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Bizhaazhé dała’áhi it’eedn nakits’ádah shį bił łegodzáhi k’azhą́ datsaahíí bighą áṉíí. Jesus higaałyú nṉee daabiłjizh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Áígee isdzán dił bigháńlį́į́go nakits’ádah bił łégodzáhi itah lę́’e, dawahá bíyéé n’íí izee nant’án yich’į’ nayihezṉil ndi doo hwaa ła’ nábilziih da. ");
INSERT INTO apwNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Áń Jesus yine’gé’ ninyaago bi’íí bidá’yú yedelṉiih: dagoshch’į’ dił bigháńlį́į́ n’íí ésdįįd. ");
INSERT INTO apwNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus gáṉíí, Hadń shedelṉiih? Nṉee baa náńłsą́ą́híí, Nohwíí doo hwaa ádaahiit’įį da, daanṉiidgo, Peter ła’íí yił nakaihíí Jesus gádaayiłṉii, NohweBik’ehń, nṉee łą́ą́go niṉaayú náńłsą́ą́go daałiłjizh, hat’íí bighą, Hadń shedelṉiih? nṉii, áíná’? ");
INSERT INTO apwNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesus gáṉíí, Shinawodíí łahzhį’ shich’ą́’zhį’ adzaahíí bighą hadńshį shedelṉiihgo bígonsį. ");
INSERT INTO apwNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Isdzánihíí doo nant’į’ dago yígołsįįdná’ tsídolyizgo ditłidgo Jesus yiyahzhį’ hayaa adzaago hat’íí bighą Jesus yedelṉiih shįhíí, ła’íí hago’at’éégo dagoshch’į’ nábi’dilziihíí nṉee dawa yiṉááł nagosṉi’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesus isdzánihíí gáyiłṉii, Shilah, nił gozhǫ́ǫ́ le’: ni’odlą’íí nłt’éégo ánániidlaa; iłch’į’gont’éégo dahnádńdáh. ");
INSERT INTO apwNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Áígee t’ah yałti’ná’ Jews ha’ánáłséhíí yebik’ehń bigowągé’ nṉee ła’ baa nyáágo gábiłṉii, Nitsi’ daztsąą; Jesus doo dayúweh nańłtł’og da. ");
INSERT INTO apwNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesus díí yidezts’ąągo gáṉíí, Doo ńńłdzid da: ondląągo zhą́ nitsi’ nłt’éé nádodleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesus gowąyú ńyááná’ Peter, John ła’íí James biłgo ła’íí it’eedn daztsaanihíí bitaa ła’íí bimaa zhą́ bił ha’ashkáh, nṉiid lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","It’eedn n’íí nṉee dawa baa daachag ła’íí baa ch’aadaaneshzhil: áíná’ Jesus gáṉíí, Doo daałchag da, it’eedn doo daztsąą da, daazhógo ałhoshgo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Áí bighą nṉee dázhǫ́ baa daadloh, it’eedn da’aṉii daztsąą yídaagołsįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesus nṉee dała’adzaahíí, Ch’ínołkáh, daayiłnṉiidná’ it’eedn bigan yiłtsoodgo gáyiłṉii, Shina’ilį’, nádndáh. ");
INSERT INTO apwNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bi’ihi’ṉa’ nágosdlįįgo dagoshch’į’ nádiidzaa lę́’e: áígé’ Jesus, Bá’dołné’, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bitaa ła’íí bimaa bił díyadaagot’ee: áíná’ Jesus gábiłṉii, Díí ágodzaahíí hadń baa bił nadaagołṉi’ hela’. ");
INSERT INTO apwNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus bitsiłke’yu nakits’ádahíí dała’áyíílaago ch’iidn dawa bitisgo binawod daagolį́į́go yedaabik’ehgo, ła’íí kah iłtah at’ééhíí yaa nadaakaihíí nádaayilziihgo yaa daagodez’ąą. ");
INSERT INTO apwNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Áígé’ Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí yaa nadaagolṉi’go, ła’íí daanezgaihíí nádaayilziihgo odais’a’. ");
INSERT INTO apwNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Áígee gádaabiłṉii, Desołkaiyú doo hat’íí daałné’go da, gish, izis bena’iltiníí, báń, dagohíí zhaali; doo íícho naki nadaałṉilgo da. ");
INSERT INTO apwNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dahayú gowągee ha’áłkaigee, łahyú nádesołkaizhį’ da’áígee nasółtąą le’gá. ");
INSERT INTO apwNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dahadń doo nádaanohwidiłteeh dayúgo dahdołkáhgo nohwikee bąą łeezhíí baa daałhaał, áí bee doo hádaanohwit’įį dahíí bígózįh doo. ");
INSERT INTO apwNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Áík’ehgo dahdikaigo daagotahyú yati’ baa gozhóni yaa nadaagolṉi’, ła’íí dahayú nakaiyú náda’ihilziih lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hérod nant’án Jesus ánát’įįłíí dawa yaat’ínzįgo, hadńshą’ ádaayiłṉii, nzį lę́’e, ła’, John daztsąągé’ naadiidzaago áń át’į́į́, daaṉiihíí bighą; ");
INSERT INTO apwNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ła’ihíí, Elías n’íí nádzáá, daaṉii; ła’ihíí, Doo áníiná’ Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí naadiidzaahi at’į́į́, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hérod gánṉiid, Shí la’ John shik’ehgo bitsits’in nadaach’idnk’ii ni’; hadń lą́ą́hi áíná’, díń dá baa idists’ag nt’éé? Áík’ehgo Jesus yiłtséh hát’į́į́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Odais’a’ n’íí nákaigo hago ánádaat’įįł n’íí Jesus yił nadaagosṉi’. Áígé’ aṉahyú da’izlįįyú, kįh gozṉil Bethsáida holzéhi ba’ashhahyú yił okai lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Áíná’ nṉee yídaagołsįįdgo biké’ onałsą́ą́: áík’ehgo Jesus baa bił gozhǫ́ǫ́go Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí yaa bich’į’ yałti’, ła’íí hayíí nádaabi’dilziih hádaat’iiníí nádaayilzii lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","O’i’ą́ą́zhį’ godeyaayú nakits’ádahíí Jesus gádaayiłṉii, Ai nṉee dała’at’ééhíí dahayú gotahyú nádaadnł’áá, dahayú njeehíí nádaagodi’aahgo, ła’íí dahat’íhíta daiyaaníí yiká daadéz’įįyú; kú da’izlįįyú nahétąąhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Áíná’ Jesus gádaabiłṉii, Nohwihíí bá da’dołné’. Áík’ehgo gádaaṉii, Báń dijolé dá’ashdla’á zhą́ nadaahii’né’, łóg dánakiyé biłgo; díí nṉeehíí dawa idáń bá nadaahiilṉiihyúgo zhą́ bá da’n’né’. ");
INSERT INTO apwNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nṉee dała’at’ééhíí ashdladn doo náhóltag dayú hilt’ee lę́’e. Jesus bitsiłke’yu gáyiłṉii, Nṉee dała’at’ééhíí ashdladingo ił’anigo dinołbįh daabiłdołṉiih. ");
INSERT INTO apwNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ágádaanṉiidná’ nṉee dawa dinezbįh. ");
INSERT INTO apwNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Áígé’ Jesus báń ashdla’ihíí łóg nakihíí biłgo náidnné’go hadag déz’įįgo ya’ahénzįgo oskąądná’ iłk’ídaizdlaad, áígé’ bitsiłke’yu yaa daizné’, nṉee yitada’iṉiihgo. ");
INSERT INTO apwNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Áígee nṉee dawa da’iyąągo náda’isdįįd lę́’e: áígé’ ch’ékaadíí táts’aa nakits’ádah bik’ehgo nádaach’ihezlaa. ");
INSERT INTO apwNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Łah Jesus dasahn okąąh, bitsiłke’yu zhą́ bił naháztąągo; áígé’ Jesus bitsiłke’yu nayídiłkidgo gádaabiłṉii, Nṉee hadń át’į́į́ daashiłṉii? ");
INSERT INTO apwNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Áík’ehgo gádaabiłṉii, Ła’ John Baptize ágole’ n’íí daaniłṉii: ła’ihíí Elías at’į́į́; ła’ihíí doo áníiná’ Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí daztsąągé’ naadiidzaahi at’į́į́ daaniłṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesus gánádo’ṉiid, Nohwihíí hadń át’į́į́ daashiłdołṉii? Peter gáṉíí, Bik’ehgo’ihi’ṉań Ats’áltíni, Christ holzéhi, áńt’įį. ");
INSERT INTO apwNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bitsiłke’yu nłdzilgo yich’į’ hadziigo gáyiłṉii, Hadń áí bił nadaagołṉi’ hela’; ");
INSERT INTO apwNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Shíí, nṉee k’ehgo Niyááhíí, doo ałch’ídn shiniigodilṉe’ da, Jews yánazíni, okąąh yedaabik’ehi bánadaant’aahi, ła’íí begoz’aaníí ye’ik’eda’iłchíhi doo hádaashit’įįdago shidizideená’ taagi jįį hileehgo naadishdáh. ");
INSERT INTO apwNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dawa yich’į’ hananádziigo gánádo’ṉiid, Dahadń shiké’ dahdigháh hát’į́į́yúgo ídaayo’ṉahná’ dajįį biigha bitsį’iłna’áhi dahyidotįįhgo shiké’ dahdowáh. ");
INSERT INTO apwNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dahadń bi’ihi’ṉa’ yaa bił goyééhń, áí bich’ą́’ da’izlį́į́ hileeh: áíná’ dahadń ídaayis’ṉahgo shíí shighą bi’ihi’ṉa’ da’izlį́į́ silįį’ń, áń ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doo. ");
INSERT INTO apwNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ni’gosdzáń dágoz’ąą nt’éégo ch’ist’įįná’ koyi’sizíni da’izlį́į́ silįįgo ch’a’och’ítłizhyúgo, áí hat’íí bich’ą́’gé’ ch’it’įįh? ");
INSERT INTO apwNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hadń shik’e ídaayándzįhíí ła’íí shiyati’ yik’e ídaayándzįhíí, shíí, nṉee k’ehgo Niyááhíí, ałdó’ nánshdáhgo bik’e ídaayánsdzį doo, shich’ą́’idindláádgo, shiTaa bich’ą́’idindláádíí ła’íí binal’a’á yaaká’yú daagolííníí dilzini bich’ą́’idindláádíí bee shich’ą́’idindláádgo. ");
INSERT INTO apwNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Shíí da’aṉiigo nohwił nadaagoshṉi’, kúgee nadaaziiníí ła’ dá doo da’itsaahíí dailįhé Bik’ehgo’ihi’ṉań nant’aago daayiłtséh. ");
INSERT INTO apwNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Díí ánṉiidíí dáshį tsebíískąągo Peter, James, ła’íí John biłgo, Jesus yił okai lę́’e, dził n’ááyú okąąhyú. ");
INSERT INTO apwNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesus okąąhná’ biniihíí łahgo at’éégo silįį, bidiyágéhíí dázhǫ́ łigaigo bik’ina’didlaad silįį. ");
INSERT INTO apwNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Áígee nṉee naki, Moses holzéhi ła’íí Elías holzéhi Jesus yił yádaałti’ silįį: ");
INSERT INTO apwNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Áí nṉeehíí dázhǫ́ bich’ą́’idindláád silįį, áígé’ Jesus datsaah doleełíí yaa yádaałti’, Jerúsalemyú áṉe’ihi. ");
INSERT INTO apwNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter ła’íí yił nakaihíí dázhǫ́ bił daanzįį: ndi t’ah daadez’įįná’ Jesus bich’ą́’idindláádgo ła’íí nṉee naki yił nadaazį’íí daayiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Áí nṉee nakihíí Jesus yich’ą́’zhį’go dahnasht’aazhná’ Peter Jesus yich’į’ hadziigo, SheBik’ehń, kú nkaihíí nohwá nłt’éé: chagosh’oh taagi ádaagohiidle’; ła’ ni ná, ła’ihíí Moses bá, ła’ihíí Elías bá, ṉii lę́’e: dá doo natsekéesé da. ");
INSERT INTO apwNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","T’ah yałti’ná’ yaak’os biká’ dahiyaa lę́’e: biyaa nágoṉahgo tsídaadolyiz. ");
INSERT INTO apwNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Áí yaak’os biyi’gé’ yati’ yidests’ąą, gáṉíígo, Díínko shiYe’ shił nzhóni: hódaayołts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Áíhíí ąął yałti’ná’ Jesus dasahn daayiłtsąą. Bitsiłke’yu díí ágodzaahíí nadainł’įį’go doo hadń yił nadaagosṉi’ da. ");
INSERT INTO apwNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Áí iskąą hik’e dziłgé’ gódah nákaigo nṉee łą́ą́go baa náńłsą́ą́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Áí nṉeehíí ła’ nádidilghaazhgo gáṉíí, Iłch’ígó’aahi, nánoshkąąh, shiye’ shá níł’įį; da’áí zhą́ shizhaazhéhi. ");
INSERT INTO apwNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Łahgee spirit nchǫ’i nabihiłaa, áígee dilwosh; nádinigisgo bidayi’gé’ itáwosh haigháh nádleeh, áígé’ biniigonłt’éégo doo bich’ą́’digháh da. ");
INSERT INTO apwNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nitsiłke’yu nádaahoshkąąh hadainihiyoodgo; ndi doo hago’at’éégo da. ");
INSERT INTO apwNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus gáṉíí, Nohwi’odlą’ édaadįhgo dánohwíí zhą́ daanohwik’ehgo daałinołt’įįłíí, dahónłsahzhį’ nohwił nahashtą́ą́, dahónłsahzhį’ ląą nohwidah ánsht’ee? Yushdé’, niye’ shich’į’ bił nń’aash. ");
INSERT INTO apwNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","T’ah yich’į’ higaałná’ ch’iidn yaabiłt’e’gé’ nádinigis lę́’e. Áíná’ Jesus spirit nchǫ’íí nłdzilgo yich’į’ hadziigo haińyood, áík’ehgo ishkiiníí náyilziigo bitaa yaa náińłtį́į́. ");
INSERT INTO apwNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Daakowa Bik’ehgo’ihi’ṉań binawodíí baa kił díyadaagot’ee lę́’e. Dawahá yaa ánát’įįłíí baa kił díyadaagot’eego Jesus bitsiłke’yu gáyiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Díí yati’íí nłt’éégo ídaasinółts’ąągo nohwijíí yuṉe be’ogohigháh le’: shíí, nṉee k’ehgo Niyááhíí, nṉee baa daashich’ide’aah. ");
INSERT INTO apwNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Áík’ehgo bitsiłke’yu Jesus hat’íí ṉiigo aṉííhíí doo bił ídaagozį da, doo yídaagołsį da doleełgo yaa ch’ananl’į’ lę́’e: áígé’ na’ódaadiłkidzhį’ bił daagoyéé. ");
INSERT INTO apwNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesus bitsiłke’yu ładaadit’áh nkegonyaa, Nohwitahyú hadń itisgo at’éhi? daałiłdi’ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus bitsiłke’yu natsídaakeesíí yígołsįįdgo, chągháshé ałch’ísę́ęhi náidnlǫǫzgo ba’ashhahgé’ yinesdaago, ");
INSERT INTO apwNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Bitsiłke’yu gáyiłṉii, Dahadń shizhi’íí binkááyú díí chągháshéhíí náidnłtįįyúgo shíí ałdó’ náshidnłtíni at’éé; dahadń náshidnłtiiníí shides’a’ń ałdó’ náidnłtíni at’éé: dahadń nohwitahyú doo ilį́į́ dahíí ízisgo at’éé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John gáṉíí, SheBik’ehń, nṉee ła’ nizhi’íí binkááyú nṉee biyi’gé’ ch’iidn hainiyoodgo daahiit’įįgo, Doo ágánt’įį da, daabiłde’ṉiid; doo bił daagohiit’įį dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesus John gáyiłṉii, Doo ágádaabiłdohṉii da: hadń doo nchǫ’go nohwich’į’ na’iziid dahń bił daagohiit’íni at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesus yaaká’zhį’go nábidi’dilteehíí biká’ ngonyaago, Jerúsalemyú digháhgo biini’ łayílaa, ");
INSERT INTO apwNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Áík’ehgo bádnyú bá iłch’į’daagole’go binadaal’a’á odaił’a’: áí Samáritans bigotahyú híkai. ");
INSERT INTO apwNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ndi áígee daagolííníí Jesus doo hádaayit’įį da lę́’e, Jerúsalemyú deyáá daanzįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jesus bitsiłke’yu John ła’íí James biłgo díí yídaagołsįįdgo gádaaṉii, NohweBik’ehń, ya’ yaaká’gé’ kǫ’íí daahwíikeedgo díí nṉeehíí daadndlid née, Elías adzaahíí k’ehgo? ");
INSERT INTO apwNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesus bich’į’ adzaago nłdzilgo bich’į’ hadziigo gádaabiłṉii, Spirit nohwiyi’sizíni hago’at’ééhíí doo bídaagonołsį da. ");
INSERT INTO apwNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Shíí, nṉee k’ehgo Niyááhíí, doo nṉee da’izlíí ishchiihíí bighą niyáá da, áíná’ hasdáhishṉiiłhíí bighą niyáá. Áígé’ łahyúgo gotahyú onanákai. ");
INSERT INTO apwNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Itínyú ch’okaahyú nṉee ła’ Jesus yich’į’ hadziigo gáṉíí, Dahayú anadááłyú niké’ anáshdaał doo. ");
INSERT INTO apwNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus gábiłṉii, Ba’ ndi bi’i’áń daagolį́į́, dlǫ́’ yúdahyú nada’iṉiihíí bit’oh daagolį́į́; áíná’ shíí, nṉee k’ehgo Niyááhíí, doo hayú nshteehi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesus nṉee ła’ihi gáyiłṉii, Shiké’ dahnṉáh. Áí nṉeehíí gáṉíí, ShiNant’a’, haląą shitaa iłtsé łehishteehyú dóshą’. ");
INSERT INTO apwNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus áí nṉeehíí gánáyiłdo’ṉiid, Nanezna’íí dabíí łedaałii’ṉiił le’: áíná’ nihíí Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí baa nagólṉi’go dahnṉáh. ");
INSERT INTO apwNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nṉee ła’ihi gánádo’ṉiid, ShiNant’a’, niké’ dahdisháh doleeł; áíná’ iłtsé shigowąyú nádishdáhgo áígee naháztaaníí bił nanágoshṉi’ hik’e. ");
INSERT INTO apwNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus gábiłṉii, Dahadń bengohildzísé ałk’iná’ yiłtsoodná’ t’ąązhį’ nádést’įįń Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah hileehíí doo yik’eh sitįį da. ");
INSERT INTO apwNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Díí bikédé’go Jesus ła’ gosts’idin hanayíṉilíí bádn dá nakigo nlaago kįh nagozṉilyú hayú deyaa shįyú odaihes’a’. ");
INSERT INTO apwNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesus gádaabiłṉii, Nest’ą’ dázhǫ́ łą́ą́go nest’ąąná’ nada’iziidíí doo hwoi da: áík’ehgo nest’ą’ yeBik’ehń bich’į’ da’ołkąąhgo gádaabiłdołṉiił, Nada’iziidíí ninest’ą’ nádaayihigeeshyú daadnł’áá. ");
INSERT INTO apwNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dahdołkáh: ba’ bitahyú dibełį́į́ bizhaazhé k’ehgo daanohwideł’a’. ");
INSERT INTO apwNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bestso bizis, izis bena’iltiníí, dagohíí nohwikee ik’e’an dahdaadołné’ hela’: itínyú daahołkáhyú nṉee da’adzaayú doo bił nadaagołṉi’ da. ");
INSERT INTO apwNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gową yuṉe’ ha’ałkaigee iłtsé gádaadołṉiih doleeł, Iłch’į’gont’ééhíí díí gową yuṉe’ be’ágót’éé le’. ");
INSERT INTO apwNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nṉee nłt’éégo at’ééhíí áígee sidaayúgo nohwił iłch’į’gont’ééhíí yił nlįį doo: áíná’ nṉee doo hwaa ágát’éé da lę́’eyúgo, nohwił iłch’į’gont’ééhíí dánohwíí nohwíyéé nádodleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Gową yuṉe’ ha’ałkaigee, da’áígee dinołbįh le’gá, áígee dahat’íhíta nohwá daach’idiné’íí daahołsąągo, ła’íí dahat’íhíta nohwá náda’ch’iłsįįhíí daahołdląągo: hadń na’iziidíí bich’į’ na’i’ṉiiłgo goz’ąą. Doo daazhógo gotahkaigo da. ");
INSERT INTO apwNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Dahagee kįh gozṉilgee ha’ałkaigo, áígee hádaanohwich’it’įįyúgo, idáń nohwidáhgee daach’izné’íí daahołsąą doleeł: ");
INSERT INTO apwNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Áígee daanezgaihíí nádaahołsiihgo bich’į’ gádaabiłdołṉiił, Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah daałeehgo nohwá ch’ígót’i’. ");
INSERT INTO apwNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Dahagee kįh gozṉilgee ha’ałkaigo, áígee doo hádaanohwich’it’įį dayúgo, áígee da’ditinyú nołkahgo gádaadidołṉiił, ");
INSERT INTO apwNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Daagonołįįgee dá łeezh zhą́ ndi nohwikee bídaahitł’į́híí k’eda’ildéh, áí bee doo hádaanohwiłt’įį da bígózįh doo, ndi díí bídaagonołsį, Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah daałeehgo nohwá ch’ígót’i’ ni’. ");
INSERT INTO apwNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Shíí nohwił nagoshṉi’, Bik’ehgo’ihi’ṉań yándaago’aahíí bijįį Sódom biniigodilṉe’íí bitisgo áí kįh gozṉilíí biniigodolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Korázingee daagonołiiníí, nohwá góyéé doleeł! Bethsáidagee daagonołiiníí, nohwá góyéé doleeł! Nohwitahyú ízisgo ánágot’įįłíí Tyre ła’íí Sídongee ágágodzaayúgo, áígee daagolííníí doo áníiná’ nak’ą’ dich’ízhé bik’inazlaaná’ iłch’ii yiyi’ naháztąągo binchǫ’íí yich’ą́’zhį’ ádaasdzaa doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bik’ehgo’ihi’ṉań nṉee yándaago’aahíí bijįį Tyre ła’íí Sídon bitisgo nohwiniigodidolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nohwíí, Capérnaumgee daagonołiiníí, yaaká’zhį’go hanohwidi’ṉiiłíí, nohwíí ch’iidntahzhį’go nohwidido’ṉił. ");
INSERT INTO apwNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Hadń daanohwíyésts’aaníí shíí shíyésts’ąą ałdó’; hadń daanohwich’ołaahíí shíí ałdó’ shich’ołaa; hadń shich’ołaahíí shides’a’ń ałdó’ yich’ołáhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Gosts’idinhíí bił daagozhǫ́ǫ́go nákaigo gádaaṉii, NohweBik’ehń, nizhi’íí binkááyú ch’iidn ndi benohwik’eh. ");
INSERT INTO apwNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus gádaabiłṉii, Ch’iidn nant’án, Satan holzéhi, yaaká’gé’ hada’didla’híí k’ehgo gódah ch’íńgo’go hish’įį ni’. ");
INSERT INTO apwNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Shíí tł’iish ła’íí ch’ígodahistas doo ła’ łanohwile’ dago, ła’íí nohwik’edaanṉiihíí binawod bitisgo nohwinawod golį́į́go nohwaa godini’ą́ą́; áík’ehgo doo hat’íí nohwiṉí’dółṉíh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Da’ágát’éé ndi ch’iidn da’ádaadołṉiiyú ánádaat’įįłíí doo da’áí zhą́ baa nohwił daagozhǫ́ǫ́ da le’; áíná’ yaaká’yú daanohwizhi’ ágolaahíí baa nohwił daagozhǫ́ǫ́ le’. ");
INSERT INTO apwNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Áíná’ Jesus Holy Spirit bee bił gozhǫ́ǫ́go gánṉiid, ShiTaa, yaaká’zhį’ ła’íí ni’zhį’ nant’án ńlínihi, díí iłch’ígót’aahíí nṉee daagoyą́ą́go bił ídaagozínihíí baa ch’ananł’į’ n’íí mé’ ga’ádaat’eehíí bich’į’ ch’í’ṉah áńlaahíí ba’ahénsį: da’áík’ehgo ágot’ee, shiTaa; da’áík’ehgo háńt’įįgo ágónlaahi. ");
INSERT INTO apwNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ShiTaa bich’ą́’gé’go dawa shaa hi’ṉííł: doo hadń shíí Bik’ehgo’ihi’ṉań biYe’ nshłíni shígółsini at’éé da, shiTaa zhą́; doo hadń shiTaa yígółsini at’éé da, shíí biYe’ nshłíni zhą́, ła’íí dahadń shiTaa bich’į’ bígózįhgo áshłe’íí ałdó’ shiTaa yígółsį. ");
INSERT INTO apwNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bitsiłke’yu zhą́ yich’į’ adzaago gáyiłṉii, Hadń hat’íí daał’iiníí daayo’iiníí biyaa gozhǫ́ǫ́ doleeł: ");
INSERT INTO apwNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Shíí nohwił nagoshṉi’, doo ałch’ídé Bik’ehgo’ihi’ṉań binkááyú nada’iziidi ła’íí nant’án daanlíni daał’iiníí daayiłtséh hádaat’įį ndi doo hwaa daayiłtsąą da; daadołts’agíí daidits’į́h hádaat’įį ndi doo hwaa daidezts’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Begoz’aaníí nłt’éégo yígółsini ła’ Jesus hat’íí nayíntaahgo gáṉíígo hizį’, Iłch’ígó’aahíí, hago ashṉe’go ihi’ṉaa doo ngonel’ąą dahíí bee hinshṉaa doleeł? ");
INSERT INTO apwNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus gáṉíí, Begoz’aaníí hago’at’éégo k’e’eshchįį? Hóńzhiigo hat’íí nił’idi’ṉii? ");
INSERT INTO apwNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nṉeehíí gáṉíí, Bik’ehgo’ihi’ṉań neBik’ehń nijíí dawa bee nił nzhǫǫ le’, niyi’siziiníí dawa bee, ninawodíí ła’íí ninatsekeesíí dawa bee; na’ashhahgé’ gólííníí nił nzhǫǫ le’, dáni ídił njǫ́ǫ́híí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus gánábiłdo’ṉiid. Da’áígee ádíńṉiid: díí bee áńt’ééyúgo hinṉáá doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Begoz’aaníí nłt’éégo yígółsini nṉee binadzahgee nzhǫǫ ádil’įį hat’į́į́go Jesus gánáyiłdo’ṉiid, Na’ashhahgé’ gólííníí nṉiihíí, hat’íí nṉiigo ánṉii? ");
INSERT INTO apwNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus hananádziigo gáṉíí, Ła’ nṉee Jerúsalemgé’ Jériko yuyaa higaałyú nṉee da’n’įįhi bik’idahishjeedgo dawahá bíyééhíí bich’ą́’ nádaidnṉilgo yóíyahgo biṉí’da’disṉihná’ bich’ą́’ onákai, k’azhą́ datsaahgo da’akú ndaabistįįná’. ");
INSERT INTO apwNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Okąąh yebik’ehi áí itín yuyaa higaałyú, áí nṉee sitiiníí yiłtsąą, ndi łahzhiṉéégo łédnyaago ch’ínyáá lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ła’ nṉee Levi hat’i’íí nlíni ałdó’ áí nṉee sitiiníí yiłtsąą, ndi áń ałdó’ łahzhiṉéégo ya’ishhah ch’ínánádzaa. ");
INSERT INTO apwNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Áíná’ ła’ nṉee Samáritan nlíni higaałyú, áí nṉee sitiiníí yiłtsąągo yaa nyáá; áík’ehgo yaa ch’oba’go, ");
INSERT INTO apwNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ik’ah ła’íí wine biłgo hagee bídaant’oodgee yik’i yaa daayiziidgo yik’ída’disdiz, áígé’ Samáritanhíí dabíí bitúlgayé yiká’ dahyistįįgo ná’ch’injahyú yinłtį́į́, áík’ehgo nłt’éégo áyíłsį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Iskąą hik’e bizhaali, penny holzéhi, naki hayiné’go ná’ch’injahíí yebik’ehń yaa yinné’ gáyiłṉiigo, Díí nṉeehń shá nłt’éégo áńłsį: díí zhaali naa niné’íí bitisyú izlįįyúgo, nich’į’ naná’dihishṉił, nánsdzaago. ");
INSERT INTO apwNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Áí nṉee taagihíí hayíihíí nṉee be’nest’įįdihíí ba’ashhahgé’ gólį́į́híí k’ehgo ábíílaa ńnzį? ");
INSERT INTO apwNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Begoz’aaníí nłt’éégo yígółsiníí gáṉíí, Nṉee biłgoch’ozbaadíí. Jesus gábiłṉii, Dahnṉáh, ni ałdó’ ágáńt’įį le’. ");
INSERT INTO apwNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ch’okaahyú Jesus ła’ gotahzhį’ oyáá: áígee isdzán Martha holzéhi bigowąyú ńyáágo, ha’ánṉáh biłṉiigo ha’ayáá. ");
INSERT INTO apwNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ákóṉe’ Martha bik’isn, Mary holzéhi, Jesus yit’ahgé’ nezdaa ni’yú, biłch’ígó’aahíí yíyésts’ąągo. ");
INSERT INTO apwNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martha łą́ą́go nabi’dintł’ogo Jesus yaa nyáágo gáṉíí, SheBik’ehń, ya’ shik’isn doo shich’oṉii dago dasahn na’isiidíí doo nił hago’at’éé da née? Nik’isn bich’onṉii, biłńṉe’. ");
INSERT INTO apwNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesus gábiłṉii, Martha, Martha, nani’dintł’ogíí zhą́ łą́ą́go baa natsíńkees: ");
INSERT INTO apwNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Áíná’ dała’á zhą́ ízisgo ilíni; áí Mary nágodn’ąą, doo hago’at’éégo bich’ą́’ nádi’né’ da. ");
INSERT INTO apwNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Łahn Jesus okąąh lę́’e; ąął oskąądná’ bitsiłke’yu dała’á gábiłṉii, SheBik’ehń, da’ohiikąąhgo nohwił ch’ígon’áah, John bitsiłke’yu yił ch’ígon’ąą lę́’ehíí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Áík’ehgo Jesus gáṉíí, Da’ołkąąhgee gádaadidołṉiił, NohwiTaa yaaká’yú dahsíńdaahń, Nizhi’íí dilzįhgo bígózįh le’. Nant’án ńlį́į́híí begodowáh. Hago’at’éégo ánṉiiyú yaaká’yú benagowaahíí k’ehgo ni’gosdzáń biká’yú ałdó’ begodolṉííł. ");
INSERT INTO apwNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dajįį biigha daahiidaaníí nohwá ágonłsį́. ");
INSERT INTO apwNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nohwinchǫ’híí nohwá da’izlíné ánándle’; nohwíí ałdó’ nṉee nchǫ’go nohwich’į’ ádaadzaahíí baa nádaagodent’aah. Nanohwída’dintaah yuṉe’ onohoṉííł hela’; áíná’ nchǫ’go at’ééhíí bich’ą́’zhį’ hanánohwihi’ṉííł. ");
INSERT INTO apwNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesus gádaabiłṉii, Tł’é’ís’ahgo nohwíí ła’ dánko nit’eké bich’į’ nṉáhgo gábiłńṉiił, Shit’éké, báń dijolé taagi shá ch’íhinjáh; ");
INSERT INTO apwNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ła’ shit’ekéhi shaa nyaaná’ doo hat’íí bá’dishné’ da. ");
INSERT INTO apwNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bigową yuṉe’ nit’ekéhíí dánko gániłdiṉiih, Doo nashíńłtł’og da: ałk’iná’ dáádítį́h da’dintą́ą́, shichągháshé bił shiijééd; doo hago’at’éégo nádishdáhgo dahat’íhíta naa nshné’ da. ");
INSERT INTO apwNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Gádaanohwiłdishṉii, Áí nṉeehń nádiidáhgo nṉee ídókeedíí dahát’į́į́gee yaa yiné’, doo bit’ekéhíí zhą́ bighą da, dayúweh ídókeedhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Áík’ehgo gádaanohwiłdishṉii, Da’dołkeed, áík’ehgo hat’íí daadołkeedíí nohwaa hi’né’hi at’éé; nadaanołtaad, áík’ehgo hat’íí bíka daanołtaadihíí nádaadołné’hi at’éé; dáádítį́h ńdaanołts’į, áík’ehgo nohwá ch’í’ítįįhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Hadń ídókeedń baa hi’né’hi at’éé; hadń nantaadń hat’íí yíka ntaadíí náidiné’hi at’éé; hadń dáádítį́h ńyinłts’įhń bá ch’í’ítįįhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nohwitahyú ła’ nṉee biye’ golíni, biye’ báń bíyókeedyúgo, ya’ tséégo yaa yi’aah gá? Dagohíí łóg bíyókeedyúgo, ya’ tł’iishgo yaa yiłteeh gá? ");
INSERT INTO apwNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Dagohíí iyęęzh bíyókeedyúgo, ya’ ch’ígodahistasgo yaa yiłteeh gá? ");
INSERT INTO apwNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Daanołchǫ’ ndi nohwichągháshé nłt’éhi baa hi’né’íí bídaagonołsįyúgo, itisgo nohwaa natsekeesgo nohwiTaa yaaká’yú dahsdaahń hadń Holy Spirit bíyókeedíí yaa yiné’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus ch’iidn doo yałti’ dahíí hainyood lę́’e. Ch’iidn habi’dinodzoodná’ nṉee doo yałti’ da n’íí hadzii; áík’ehgo nṉee dała’adzaahíí bił díyadaagot’ee. ");
INSERT INTO apwNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Áíná’ ła’ gádaaṉii, Ch’iidn nant’án Beélzebub holzéhi binawodíí bee Jesus ch’iidn hainihiyood. ");
INSERT INTO apwNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ła’ihíí nayídaantaahgo gádaaṉii, Yaaká’gé’ godiyįhgo be’ígóziníí nohwił ch’í’ṉah ánle’. ");
INSERT INTO apwNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Áíná’ Jesus, áí nṉee natsídaakeesíí yígółsįgo gáyiłṉii, Nṉee iłch’į’ t’ekédaas’anihíí dabíí iłch’į’ nanádaagonłkaadyúgo da’izlį́į́ hileeh; nṉee dała’ naháztaaníí dabíí iłk’ídahnájahyúgo doo aṉahyú begonowáh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Áík’ehgo Satan dabíí ích’į’ naná’idziidyúgo hagoshą’ yebik’ehíí bínágoṉaał doleeł? Ni Beélzebub bee ch’iidn haniyóód daashiłdołṉiihíí bighą ádishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Shíí Beélzebub bee ch’iidn haniisoodyúgo, nohwíí daanohwiye’íí hadń bee ch’iidn hadainiyood áíná’? Áík’ehgo daanohwiye’íí ch’í’ṉah ádaanohwile’. ");
INSERT INTO apwNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Áíná’ Bik’ehgo’ihi’ṉań binawodíí bee ch’iidn haniisoodyúgo, da’aṉiigo Bik’ehgo’ihi’ṉań nohwitahyú ałk’iná’ nant’aa. ");
INSERT INTO apwNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nṉee nłdzili yenagonłkaad doleełíí ałk’iná’ dahyoné’go bigową yiṉádéz’įįyúgo, dawahá bíyééhíí doo hago aṉéh da: ");
INSERT INTO apwNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Áíná’ ła’ nṉee bitisgo nłdzilihi bich’į’ nanálwodgo isná ábidlaayúgo, yenagonłkaadíí ya’ołíí n’íí bich’ą́’ náyidinṉiiłgo nṉee yitah’iṉiih. ");
INSERT INTO apwNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Hadń doo bił gonsht’įį dahń shich’į’ got’įį’hi at’éé; hadń doo bił dała’á ná’áshdle’ dahń shich’ą́’ ts’iłtįįgo áile’. ");
INSERT INTO apwNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Spirit nchǫ’íí nṉee yiyi’gé’ háyááná’ tú ádįhyú aanádaał, hayú hanayóołíí yíka ntaago; áíná’ doo hagee dahíí bighą gáṉíí, Shigowąyú hagé’ níyáá n’ííyú nádésdzá. ");
INSERT INTO apwNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bigową n’íí nłt’éégo nágolzhoogo dawahá nzhǫǫgo neheshjaayú nádzá. ");
INSERT INTO apwNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Áík’ehgo spirits gosts’idi daanchǫ’i yił nakai, bíí bitisgo daanchǫ’ihi, áí gową yuṉe’ yił ha’akáhgo áígee ndaagoleeh: áík’ehgo nṉee iłtséná’ át’éé n’íí bitisgo at’éé hileeh. ");
INSERT INTO apwNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesus t’ah yałti’ná’ ła’ isdzán dała’ách’ít’éé biyi’gé’ hadziigo Jesus gáyiłṉii, Isdzán bibishch’id biyi’gé’go síńlįįgo nnłbe’ n’íí biyaa gozhǫ́ǫ́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Áíná’ Jesus gáṉíí, Hadń Bik’ehgo’ihi’ṉań biyati’ yidits’ago yikísk’eh at’ééhń, áńgo biyaa gozhǫ́ǫ́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nṉee łą́ą́go dała’adzaaná’ Jesus gáṉíí nágodidzaa, Dázhǫ́ nchǫ’go daałinolt’įįłi: godiyįhgo be’ígóziníí yíka daadéz’įį; áíná’ be’ígóziníí doo bił ch’í’ṉah ádaalṉe’hi at’éé da, Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí, Jonas holzéhi, nṉee bich’į’ be’ígózįh alzaahíí zhą́. ");
INSERT INTO apwNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonas nṉee Nínevehgee daagolííníí bich’į’ be’ígózįh alzaahíí k’ehgo shíí, nṉee k’ehgo Niyááhíí, daałinolt’įįłíí bich’į’ be’ígózįh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bik’ehgo’ihi’ṉań nṉee yándaago’aahíí bijįį isdzán nant’ánihi hayaadé’go nyááhń hizįįgo daałinolt’įįłíí yaa yałti’go, Shíí shitisgo daanchǫ’ ni’, didoṉiił: áń dázhǫ́ ńzaadgé’ ńyáá, Sólomon bigoyą’ yidits’į́hgo; áíná’ k’adíí Sólomon bitisgo ánsht’éhi niyáá. ");
INSERT INTO apwNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aayá’iti’gee nṉee Nínevehgee daagolį́į́ n’íí daahizįįgo nṉee daałinolt’įįłíí yaa yádaałti’go, Nohwíí nohwitisgo daanchǫ’ ni’, daadidoṉiił; Nínevehgee daagolííníí Jonas yałti’go daidezts’ąąná’ binchǫ’íí yich’ą́’zhį’go ánádaasdzaa; áíná’ k’adíí Jonas bitisgo ánsht’éhi niyáá. ");
INSERT INTO apwNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Doo hadń ik’ah kǫ’íí yidiłtłaadgo nagont’į’yú nyiłt’áah da, dagohíí doo táts’aa yił yaa nyí’aah da, áíná’ ik’ah kǫ’íí biká’ dahnásiłt’ááhyú daach’iłt’aah, áík’ehgo hayíí ha’áhikáhíí áí kǫ’íí daayo’įį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kiṉáá’íí kits’í bikǫ’i at’éé: kiṉáá nłt’ééyúgo kits’í dahot’éhé bikǫ’ golíni at’éé; áíná’ doo nłt’éé dayúgohíí kits’íhíí dahot’éhé diłhiłi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Áík’ehgo ádaagots’idząą, dahyúgo kiyi’ ná’dindíín n’íí kich’ą́’ diłhił nádleeh. ");
INSERT INTO apwNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kits’í dahot’éhé biyi’ adindíínyúgo, hayú doo diłhiłgo baa dahgoz’ąą dayúgo, kits’í dahot’éhé bich’ą́’idindíín doo, ik’ah kǫ’íí bich’ą́’idindíínhíí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus t’ah yałti’ná’ Phárisee nlínihi, Shił ináá, biłṉii: áík’ehgo Jesus itah iyąągo nezdaa. ");
INSERT INTO apwNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jesus Phárisees bi’at’e’híí k’ehgo dá doo táádígisé itah iyąągo nezdaago Pháriseehíí bił díyagot’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesus gábiłṉii, Nohwíí Phárisees daanołíni, idee ła’íí its’aa biká’yú zhą́ táádaałgis; áíná’ nohwiyi’yú aadaach’ihi’ṉiiłíí ła’íí daanchǫ’íí zhą́ begoz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nohwíí doo daagonołsáni da, hadń nohwits’í áyíílaahń shą’ da’áń nohwiyi’ihíí ałdó’ áyíílaa? ");
INSERT INTO apwNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dawahá nohwijíí biyi’gé’ nłt’ééhíí nṉee bá daadołné’; áík’ehgo dawahá nohwá nłt’éé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Phárisees daanołíni, nohwá góyéé doleeł! tł’oh mint holzéhi, ła’íí rue holzéhi, ła’íí tł’oh iłtah at’ééhíí dágonenanyú iłk’é’ṉilgo dała’á Bik’ehgo’ihi’ṉań baa nádaałné’, áíná’ nłt’éégo ágot’eehíí doo bikísk’eh ádaanołt’ee da, Bik’ehgo’ihi’ṉań bił’ijóóníí doo baa natsídaałkees da: áí bee ádaanołt’ee doleeł ni’, ła’ihíí doo baa daayołṉah dago. ");
INSERT INTO apwNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Phárisees daanołíni, nohwá góyéé doleeł! nohwíí Jews ha’ánáłséh nagozṉil yuṉe’ nṉee ízisgo ádaat’eehíí dahnádinbįhyú itah dahnasółtąągo zhą́, ła’íí nahi’ṉiih nagoz’ąąyú nohwich’į’ ádaach’iṉiigo nohwił daagozhǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Begoz’aaníí ye’ik’eda’iłchíhi ła’íí Phárisees daanołíni, daanołshǫǫ ádaagonoł’íni, nohwá góyéé doleeł! łe’ch’izhjeegíí doo daat’įį dahíí ga’ádaanołt’ee, áí łe’ch’izhjeegíí biká’ ch’ích’ihikáh, dá doo bídaagoch’iłsinégo. ");
INSERT INTO apwNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ła’ Jews bich’į’ begoz’aaníí nłt’éégo yígółsini Jesus gáyiłṉii, Iłch’ígó’aahíí, ágánṉiiyú nohwíí ałdó’ ánohwiłnṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus gáṉíí, Begoz’aaníí nłt’éégo bídaagonołsini, nohwíí ałdó’ nohwá góyéé doleeł! heeł ndaazi nṉee biká’ dahda’ohołheeh, áíná’ nohwihíí dázhǫ́ da’ayą́hágo ndi doo bich’odaałṉii da. ");
INSERT INTO apwNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nohwíí nohwá góyéé doleeł! nohwitaa n’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi nadaistseedi łe’shijeegíí biká’ dahat’íhíta bee bínádaach’ilṉihíí ádaagołe’. ");
INSERT INTO apwNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nohwitaa n’íí ánádaat’įįł n’íí nohwił dábik’ehgo ch’í’ṉah ádaał’įį: daanohwitaa n’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidíí nadaistseed, nohwíí łe’shijeegíí biká’ dahat’íhíta bee bínádaach’ilṉihíí ádaagołe’. ");
INSERT INTO apwNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Áí bighą Bik’ehgo’ihi’ṉań bigoyą’íí gánṉiid lę́’e, Binkááyú nada’isiidíí ła’íí shinadaal’a’á koch’į’ daadish’aa, ła’ nadaach’iłtseed doleeł, ła’íí biniidaagoch’idile’ doleeł: ");
INSERT INTO apwNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Áík’ehgo ni’gosdzáń alzaagé’ godezt’i’go Bik’ehgo’ihi’ṉań binkááyú nada’iziidi dawa bidił nada’ijóółíí, daałinolt’įįłíí bik’izhį’ didot’aał, ");
INSERT INTO apwNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ábel zesdįįgé’ Zekarías zesdįįzhį’ nnágont’i’go, Zekaríasíí bech’okąąhíí biká’ dahnási’ṉiłíí goz’aaníí ła’íí kįh biyi’ da’ch’okąąhíí bigizhgee daztsąą lę́’e: da’aṉii ádaanohwiłdishṉii, daałinolt’įįłíí bik’izhį’ didot’aał. ");
INSERT INTO apwNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Begoz’aaníí nłt’éégo bídaagonołsini, nohwá góyéé doleeł! nohwíí igoyą’ bich’į’ bená’igisé nádaadołtąą: nohwíí doo ha’ałkáh daná’ nṉee ha’akáh doleeł n’íí t’ąązhį’ ádaanołsį. ");
INSERT INTO apwNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesus ágáṉííná’ begoz’aaníí ye’ik’eda’iłchíhi ła’íí Phárisees daanlíni bá daagoshchįįdgo łą́ą́go nayídaadiłkid: ");
INSERT INTO apwNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yá nakída’ił’áágo, k’izé hadzii daanzįgo, dahat’íhíta yik’izhį’ daidi’aahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Díí bee ánágot’įįłná’ nṉee doo náhóltag dayú dała’adzaago dázhǫ́ daałiłjizhná’ Jesus bitsiłke’yu iłtsé gáyiłṉii nkegonyaa, Phárisees daanlíni binchǫ’íí báń benilzoołé ga’at’éhi baa daagonołsąą, áí nṉee binadzahgee nzhóni ádaadil’íni at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","K’ad dawahá bił łe’izkaad n’íí ch’í’ṉah ádolṉiił; ła’íí k’ad dawahá nanl’į’ n’íí bígózįhgo ádolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Áík’ehgo godiłhiłyú hat’íí daadołṉii n’íí got’įįzhį’ didots’įįł; kįh biyi’ yuṉe’ datąąnégo hat’íí daadołṉii n’íí kįh biká’gé’ didots’įįł. ");
INSERT INTO apwNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Shit’ekéhíí, gádaanohwiłdishṉii, Hayíí kits’í nadaiłtseedná’, bikédé’go doo hago ádaaṉéh dahíí doo bédaałdzid da. ");
INSERT INTO apwNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Shíí nohwił nadaagoshṉi’ hadń bédaałdzid: ich’izishiiníí bikédé’go ch’iidn bikǫ’ diltłi’ yuyaa kaa o’iłkaadíí áń bédaałdzid; gánohwiłdishṉii, áń bédaałdzid. ");
INSERT INTO apwNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ya’ dlǫ’dichiné ashdla’i zhaali łichí’é naki izlįįgo nahiṉiih gá? Da’ágát’éé ndi Bik’ehgo’ihi’ṉań dała’á ndi doo yaa yiṉah da. ");
INSERT INTO apwNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nohwitsizíl dawa ałk’iná’ hotagi at’éé. Áík’ehgo doo nédaałdzid da: dlǫ’dichiné doo ałch’ídé bitisgo da’inołįį da. ");
INSERT INTO apwNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Gánádaanohwiłdish’ṉii, Dahadń nṉee binadzahgee, Áń bígonsį, shiłṉiihń, shíí nṉee k’ehgo Niyááhíí Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí binadzahgee ágádiłdishṉiił: ");
INSERT INTO apwNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Áíná’ hadń nṉee binadzahgee, Áń doo bígonsį da, shiłṉiihń, Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí binadzahgee, Doo yígółsį da, biłdidishṉiił. ");
INSERT INTO apwNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Dahadń shíí, nṉee k’ehgo Niyááhíí, nchǫ’go shaa yałti’ ndi binchǫ’íí bá da’izlíné ánádolṉiił; áíná’ dahadń Holy Spirit nchǫ’go yaa yałti’ń binchǫ’íí doo bá da’izlíné ánálṉe’ at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Jews ha’ánáłséhíí, ła’íí nadaant’aahíí, ła’íí aasiṉilíí binadzahgee ndaanohwidel’aago, hago’at’éégo shą’ hasdziih, dagohíí hat’ííshą’ dishṉii gádnii, doo daanołsį da: ");
INSERT INTO apwNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Holy Spirit da’áí bik’ehen’ą́ą́gee biyi’ hat’íí daadołṉiihíí nohwił ch’ígó’aah ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nṉee dała’at’ééhíí ła’ Jesus yich’į’ hadziigo gáṉíí, Iłch’ígó’aahíí, shik’isn hat’íí nohwíyéé doleełíí łahzhį’ shaa no’né’, biłnṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus gábiłṉii, Dawahá nanohwíńłtł’ogíí hadń nohwá iłch’į’ishłe’go hashiłtį́į́? ");
INSERT INTO apwNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Áígé’ Jesus gánádo’ṉiid, Daagonołsąą le’, dawahá dayúwehégo ádáhádaałt’iiníí baa daagonołsąą: kíyééhíí łą́ą́ ndi doo áí bee ch’ihiṉaa da. ");
INSERT INTO apwNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iłch’ígót’aahgo na’goṉi’íí yee yich’į’ hadziigo gáyiłṉii, Nṉee ízisgo it’iiníí łą́ą́go na’inłt’į́h: ");
INSERT INTO apwNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dabíí gáłdi’ṉii, Hago áshṉéh, shinest’ą’íí doo hayú bá nágost’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Áígé’ gánádi’ṉii, Hago áshṉéhíí bígonsį: dawahá bá gową shíyééhíí nanágohishṉiiłgo nchaago ánágoshdléhgo, shinest’ą’íí ła’íí dawahá shíyééhíí ákóṉe’ oshṉiił. ");
INSERT INTO apwNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Shiyi’siziiníí gábiłdishṉii, Shiyi’siziiníí, dawahá ṉíyééhíí da’kwíí łegodzaayú dábik’ehyú iłk’eyíhiṉil; áík’ehgo hanányoł, ináá, ídlą́ą́, nił gozhǫ́ǫ́ le’. ");
INSERT INTO apwNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Áíná’ Bik’ehgo’ihi’ṉań gábiłnṉiid, Doo gonyą́ą́ da; díí tł’é’ niyi’siziiníí níhókeed: dawahá ṉíyééhíí iłk’ehiṉilíí hadń bíyéé doleeł áíná’? ");
INSERT INTO apwNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Hadń dabízhą́ nzhooníí zhą́ ádáhát’į́į́go iłk’eyihiṉilná’ Bik’ehgo’ihi’ṉań binadzahgee doo nzhǫǫ da, áń nṉeehń ágát’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesus bitsiłke’yu gáyiłnṉiid, Áí bighą gánohwiłdishṉii, Nohwi’ihi’ṉa’íí doo baa daanohwił goyéé’ da le’, hat’ííshą’ hishąą doleeł, daanołsįgo; dagohíí nohwits’í doo baa daanohwił goyéé’ da le’, hat’ííshą’ ágoshdle’, daanołsįgo. ");
INSERT INTO apwNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ki’ihi’ṉa’íí idáń bitisgo ilíni at’éé, kits’íhíí diyágé bitisgo ilíni at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gaagé baa natsídaałkees: doo k’eda’dilee da, doo náda’igeesh da; doo hayú binon’iłk’edaayihiṉiiłíí bá gową goz’ąą da; da’ágát’éé ndi Bik’ehgo’ihi’ṉań bá da’diiné’: nohwíí dlǫ’ bitisgo da’inołįį! ");
INSERT INTO apwNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nohwitahyú hadń daahołṉeezíí yaa natsekeesíí zhą́ bee ayą́hágo ndi hadag ńdiłséhgo ádidle’ gá? ");
INSERT INTO apwNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Áík’ehgo ágát’éhi dé’iyą́há ndi ch’éh ádaałe’ná’, hat’íí bighą ła’ihíí baa daanohwił goyéé’? ");
INSERT INTO apwNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tł’oh dénzhónéhíí baa natsídaałkees, hago’at’éégo nadaanse’íí: doo nada’iziid da, doo da’itł’ool da; da’ágát’éé ndi Sólomon ízisgo at’éé lę́’e ndi, doo díí tł’oh dénzhóné ga’at’éégo ík’e’isdlaa da, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Áík’ehgo tł’oh díí jįį nołseełíí, áígé’ iskąą daadidlidíí ndi Bik’ehgo’ihi’ṉań nłt’éégo bik’e’isłaaná’; áí tł’ohíí bitisgo Bik’ehgo’ihi’ṉań nohwik’e’isłaa, nohwíí nohwi’odlą’ ayą́háhi. ");
INSERT INTO apwNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Áík’ehgo hat’íí da’iidąą shįhíí dagohíí hat’íí da’iidląą shįhíí zhą́ doo baa natsídaałkees da, doo nohwiini’ hą́h da le’. ");
INSERT INTO apwNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ni’gosdzáń biká’ nṉee iłtah at’éégo hadaazt’i’íí áí zhą́ itisgo hádaat’įį: áíná’ hat’íí bídn daanołiiníí Bik’ehgo’ihi’ṉań nohwiTaa nohwá yígółsį. ");
INSERT INTO apwNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí itisgo biká hádaałt’įį, áígé’ díí dawahá ałdó’ nohwíyéé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Doo nédaałdzid da, doo hwoigo shiké’ hołkah dahíí, Bik’ehgo’ihi’ṉań nohwiTaa bilałtł’áhgee daanliiníí itah daanołįįgo nohwá ngon’ą́ą́, áí bił goyiłshǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dawahá nohwíyééhíí nohwaa nahiṉiił le’, tédaat’iyéhíí baa daanołné’; bestso bizis doo są’i hileeh dahíí nádaadoł’aah, yaaká’zhį’ ilínihíí doo édį́įhi nádaadoł’aah, ákú da’in’įįhíí doo keda’in’įįh dayú, ła’ihíí doolé doo nohwich’ą́’ da’iyąą dayú. ");
INSERT INTO apwNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Dahayú nohwił ilíni siṉilyú áí zhą́ baa natsídaałkees doo. ");
INSERT INTO apwNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ík’eda’ sołdlaago t’ałkoná’ nohwikǫ’ daadiltłi’ le’, ");
INSERT INTO apwNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nṉee binant’a’ ni’i’ṉéhgee k’ad nadáhgo yiba’ naháztąąhíí k’ehgo ádaanołt’ee le’; nadzáágo dáádítį́h ńyínłts’įgo dagoshch’į’ yá ch’ída’itįįh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nadaal’a’á binant’a’ nadzááná’ daadéz’įįhíí biyaa gozhǫ́ǫ́ doleeł: da’aṉii gánohwiłdishṉii, ík’e’idleego, Dinołbįh, yiłṉiigo yich’į’ iikaah. ");
INSERT INTO apwNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","K’ad tł’é’ís’ahzhį’ godeyaayú, dagohíí hadiyeskąąyú biká daadéł’įįgo nadzááyúgo, áí nadaal’a’á biyaa gozhǫ́ǫ́ doo. ");
INSERT INTO apwNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Díí bídaagonołsį, nṉee bigową golííníí da’os’ah in’įįhíí hígháhgo yígółsįyúgo yiká déz’įį doleeł ni’, áík’ehgo bigową doo ch’í’nódzį́į́s át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nohwíí ałdó’ t’ałkoná’ iłch’į’daanołt’ee, shíí nṉee k’ehgo Niyááhíí dahagee nánshdáh, doo ndaashołíí dagee. ");
INSERT INTO apwNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter gábiłṉii, SheBik’ehń, iłch’ígót’aahgo na’goṉi’íí bee yáńłti’íí, ya’ nohwíí zhą́ nohwá ánṉii née, dagohíí dawa bá ánṉii née? ");
INSERT INTO apwNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesus gáṉíí, Hadń begondlįįgo na’iziidíí góyáni, binant’a’ bigowąhíí yebik’ehgo nbiłtį́į́ n’íí, dahagee idáń nana’ṉííhghee idáń nayiṉiih. ");
INSERT INTO apwNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Na’iziidíí binant’a’ ábiłṉiiyú át’į́į́go binant’a’ nadzááyúgo, áń biyaa gozhǫ́ǫ́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Da’aṉiigo gádaanohwiłdishṉii, nant’án hat’íí bíyééhíí dawa yebik’ehgo na’iziidíí nbíłteeh doo. ");
INSERT INTO apwNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Áíná’ áí na’iziidíí, Shinant’a’ doo dáhah nadáh da, idiłdi’ṉiiyúgo; isdzáné ła’íí nṉee nada’iziidíí nadainłkaad nkegonyaayúgo, iyąą ła’íí idląągo bił nágodezyizyúgo; ");
INSERT INTO apwNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Áí na’iziidi binant’a’ doo yiká déz’įį dagee, doo nyołíí dagee nadáhgo nbihiłgeesh, áígé’ hayíí doo da’odląą dahíí bich’į’zhiṉéégo nilteeh. ");
INSERT INTO apwNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Áí na’iziidi binant’a’ hat’íí áile’ hábit’iiníí yígółsį ndi doo hwaa ágádzaa da, doo hwaa iłch’į’ádidlaa dahíí nábi’diltsas. ");
INSERT INTO apwNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Áíná’ na’iziidi binant’a’ hat’íí áile’ hábit’iiníí doo yígółsį dahíí, nábi’diltsas dábik’ehyú adzaayúgo ndi, dét’įh ńbi’diltsas doleeł. Hadń łą́ą́go baa hi’né’íí, áń łą́ą́go bínádokił; hadń nṉee łą́ą́go yá’ńné’yúgo, áń łą́ą́go yíná’dókeed doo. ");
INSERT INTO apwNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Shíí kǫ’ ni’gosdzáń biká’zhį’ nkedinshṉiiłgo niyáá: ałk’iná’ diltłi’ le’ láń! ");
INSERT INTO apwNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Shíí baptize áshidilṉe’; áí dáhah hadó’ begolṉe’! ");
INSERT INTO apwNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ya’ ni’gosdzáń biká’zhį’ iłch’į’gont’ééhíí nkeniiné’ daanołsį née? Dah, nohwiłdishṉii; nṉee iłk’ídaashṉilyú níyáá: ");
INSERT INTO apwNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kodé’ godezt’i’go ashdla’i kįh dała’á biyi’ daagolį́į́yúgo, taagi yich’į’ nakiłt’éé doleeł, dagohíí naki yich’į’ tałt’éé doo. ");
INSERT INTO apwNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nṉeehń biye’ yił nanágonłkaad doo, biye’ń bitaa yił nanágonłkaad doo ałdó’; ła’íí isdzán bi’isdzą’ yił nanágonłkaad doo, bi’isdzą’ń bimaa yił nanágonłkaad doo ałdó’; isdzán yá’iyéhń yił nanágonłkaad doo, isdzán bá’iyéhń yił nanágonłkaad doo ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus nṉee dała’at’ééhíí yich’į’ hadziigo gánṉiid, O’i’áh biyaayú yaak’os dahnanłse’go daał’įįyúgo dagoshch’į’ gádaadołṉii, Nagołtįį ląą; áík’ehgo da’ágánágot’įįł. ");
INSERT INTO apwNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Hayaagé’go ńch’iidyúgo, Gozdog doleeł ląą, daadołṉii; áík’ehgo ágánágot’įįł. ");
INSERT INTO apwNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nohwíí nṉee nzhóni ádaagonoł’íni, yaak’os ła’íí ni’gosdzáń hago ágoṉéhíí bídaagonołsįná’, hat’íí bighą k’ad ágoṉéhíí doo bídaagonołsį da? ");
INSERT INTO apwNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Hat’íí bighą doo dánohwíí nohwi’at’e’ hago’at’éé shįhíí bídaagonołsį dashą’? ");
INSERT INTO apwNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Hadń naa dahgoz’aaníí nant’án yaa bił hi’ashyú dagoshch’į’ bił iłk’ínágonłdǫ́ǫh; dahyúgohíí aayánáltihíí yaa nidołt’eełgo at’éé, áík’ehgo aayánáltihíí aasitíni yaa niłtéehgo, aasitiiníí ha’ániłt’e’. ");
INSERT INTO apwNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Doo ch’ínánódáh át’éé da, dá ąął na’íńṉilgo zhą́, niłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Áíná’ ła’ nṉee áígee dała’at’ééhíí Jesus yił nadaagolṉi’go gádaayiłṉii, Ła’ nṉee Gálileegé’ hikaihi Pílate nabistseedgo bidiłíí ła’íí Bik’ehgo’ihi’ṉań yaa dainé’íí bidiłíí bił nanádisgeed lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus gádaabiłṉii, Ya’ áí nṉee Gálileegé’ daagolííníí nṉee ła’ihíí Gálileegé’ daagolííníí bitisgo binchǫ’ ye’ádaat’eehíí bighą biniidaagodeszaa daanołsį née? ");
INSERT INTO apwNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Dah, nohwiłdishṉii: áíná’ nohwíí daanohwinchǫ’ doo bich’ą́’zhį’ ádaałṉe’ dayúgo, nohwíí ałdó’ áí k’ehgo nanołṉe’. ");
INSERT INTO apwNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Dagohíí łah nṉee tsebiits’ádah hilt’éhi Silóamgee tséé iłk’ehistł’ini nṉeezgo nadn’áhi biká’ nágo’go nabistseed n’íí, ya’ áí ła’ihíí Jerúsalemgee daagolííníí bitisgo binchǫ’ ye’ádaat’eehíí bighą adzaa daanołsį née? ");
INSERT INTO apwNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dah, nohwiłdishṉii: áíná’ nohwíí daanohwinchǫ’ doo bich’ą́’zhį’ ádaałṉe’ dayúgo, nohwíí ałdó’ áík’ehgo nanołṉe’. ");
INSERT INTO apwNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesus iłch’ígót’aahgo na’goṉi’íí yee yaa nanágolṉi’go gáṉíí, Ła’ nṉee bidasts’aa hentííníí biyi’gee ch’il fig holzéhi o’áá lę́’e; áík’ehgo nṉeehń áí fig o’áhi bah dahnándahíí yiká déz’įįgo nyáá ndi doo ła’ da ląą. ");
INSERT INTO apwNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nṉee bidasts’aa hentííníí bá yaa nádéz’iiníí gáyiłṉii, Kú díń’įį, díí fig sikaadíí bah dahnándahíí biká nádísht’įįgo taagi łegodzaa, t’ah doo ła’ nádish’aa da: k’íńk’é; hat’íí bighą o’áá doleeł, doo bah dahná’ndah daná’? ");
INSERT INTO apwNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Áík’ehgo gáṉíí, Shinant’a’, ch’ík’eh da’áík’ehgo o’áágo łenágodáhgo nzhǫǫ, áík’ehgo dahat’íhíta bich’į’ int’aaníí bił k’enádishdlee: ");
INSERT INTO apwNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Áík’ehgo bah dahnisdeeyúgo nłt’éé: dahyúgohíí k’ídńk’i. ");
INSERT INTO apwNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jews daagodnłsiníí bijįį Jesus ła’ Jews ha’ánáłséh goz’ąą yuṉe’ iłch’ígó’aah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Áígee ła’ isdzán spirit nchǫ’i kah naghaago ábíłsini biyi’ golį́į́go tsebiits’ádah bił łegodzaahi itah lę́’e, áń hayaa isk’idgo doo iłk’ídídǫǫhi da. ");
INSERT INTO apwNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesus yiłtsąągo yich’į’ áṉíígo gáyiłṉii, Isdzán, kah nanṉaahíí bich’ą́’ ni’doltįį. ");
INSERT INTO apwNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yiká ndelṉiigo dagoshch’į’ isdzánhíí iłk’ínádezdǫǫd, áík’ehgo Bik’ehgo’ihi’ṉań náshilziihgo bich’į’ ahénsį, ṉii lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Áígee Jews ha’ánáłséh yebik’ehń hashkee, Jesus Jews daagodnłsiníí bijįį ná’ilziihíí bighą, áík’ehgo nṉee dała’at’ééhíí yich’į’ hadziigo gáṉíí, Gostáń iskąązhį’ na’iziidíí bee goz’ąą: áí gostáń iskaaníí biyi’ nádaanohwidilziihyú nohołkáh, doo godilziníí bijįį da. ");
INSERT INTO apwNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesus hananádziigo áí nṉeehíí gáyiłṉii, Ni, nzhǫǫ ádńł’íni, nohwíí dała’á nołtįįgo godilziníí bijįį nohwimagashi dagohíí nohwitúlgayé dahastł’ooníí k’eda’oł’adgo túyú daadołǫǫz góya’? ");
INSERT INTO apwNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Díí isdzánihíí, Abraham bich’ą́’gé’ bi’dishchíni, Satan dahbihestł’ǫǫgo tsebííts’ádah bił łegodzaahi, godilziníí bijįįshą’ doo k’e’it’ad da née? ");
INSERT INTO apwNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ágánṉiidná’ nṉee Jesus yich’į’ daagot’iiníí ádaa yádaaniidzįį: áíná’ nṉee ła’ihíí dawa bił daagozhǫ́ǫ́, Jesus dázhǫ́ nłt’éégo adzaahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Áígé’ Jesus gáṉíí, Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí hago’at’ééhíí? Hat’íí bił łísht’a nshné’ baa nagoshṉi’? ");
INSERT INTO apwNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nṉee ła’ mústard biyigé dázhǫ́ ałch’ísę́hi náidn’ąągo bikíyaayú k’eidnláá; áí ch’il dázhǫ́ nchaahi silįįgo bich’ádaaz’aahíí biyi’yú dlǫ́’ yúdahyú nada’iṉiihíí bit’oh ádaagozlaahíí k’ehgo Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí át’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Áígé’ gánádo’ṉiid, Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí hat’íí bił łísht’a nshné’go baa nagoshṉi’? ");
INSERT INTO apwNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Isdzán ik’áán taadn ha’oką́ą́go báń benilzoołé yił ná’ist’oodgo ąął dahńdilzoołíí k’ehgo Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí át’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus Jerúsalemyú higaałgo kįh nagozṉilyú ła’íí daagotahyú iłch’ígó’aah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ła’ bich’į’ gánṉiid, ShiNant’a’, ya’ nṉee da’ayą́hágo hasdáhikáh doleeł née? Gáyiłnṉiid, ");
INSERT INTO apwNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ágołch’óshígo ch’ígót’i’ ch’ínołkáh bich’į’ dahdaanołdǫh: łą́ą́go ha’akáh hádaat’įį doleeł ndi ch’éh ádaat’įį doleeł, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bigową golííníí nádidáhgo dáádítį́h nohwich’ą́’ da’ditįįhná’ da’dáńyú nasozįįgo dáádítį́híí ńdaanołts’įgo gádaadołṉiił, Nohwinant’a’, Nohwinant’a’, nohwá ch’í’íńtįįh; nohwich’į’ hadziigo gádaanohwiłdoṉiił, Hagé’ nałkaihi shį, shíí doo nohwídaagonsį da: ");
INSERT INTO apwNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Áíná’ gánádaadoł’ṉiił, Niṉááł da’iidąą ni’, nohwida’itinyú iłch’ígon’aah ni’. ");
INSERT INTO apwNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Áíná’ gánohwiłdidoṉiił, Hagé’ nołkaihi shį doo nohwídaagonsį da, nohwiłdishṉii; yúwehzhį’ nołkáh, daanohwigha nchǫ’go ádaałt’íni. ");
INSERT INTO apwNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abraham, Isaac, Jacob, ła’íí dawa Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí Bik’ehgo’ihi’ṉań bilałtł’áhgee goz’ąą yuṉe’ naháztąągo daał’įįgo, áíná’ nohwíí nohwich’ą́’ da’detąągo, daałchag ła’íí nohwiwoo’ łídaadołk’ash doo. ");
INSERT INTO apwNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nṉee ha’i’áh biyaadé’go, ła’íí o’i’áh biyaadé’go, yúdaazhidé’go, ła’íí hayaadé’go nihikáhgo, Bik’ehgo’ihi’ṉań bilałtł’áhgee goz’ąą yuṉe’ dahnaháztąą doo. ");
INSERT INTO apwNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nṉee ła’ iké’yú daanlįį n’íí da’iłtsé doleeł; ła’ da’iłtsé daanlįį n’íí iké’yú doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Da’áí bijįį ła’ Phárisees daanlínihi baa hikaigo Jesus gádaayiłṉii, Kogé’ dahnṉáh; Hérod niziłhee hát’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus gábiłṉii, Ti’i, áí ba’íí k’ehgo nlíni gádaadołṉii, Díí jįį ła’íí iskąą shíí ch’iidn nṉee biyi’gé’ ch’ínihisood, ła’íí ná’isziih; nakiskąągo áníita shinasdziid ąął ashłeh. ");
INSERT INTO apwNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Da’ágát’éé ndi díí jįį ła’íí iskąą ła’íí nakiskąągo da’áí k’ehgo hishgaał: Bik’ehgo’ihi’ṉań binkááyú na’iziidi Jerúsalemyú zhą́ datsaah dábik’eh. ");
INSERT INTO apwNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerúsalem, Jerúsalem ńlíni, Bik’ehgo’ihi’ṉań binkááyú nada’iziidi natsíńłtseedíí, ła’íí nich’į’ daahi’aadíí tséé bee nabida’tsisíńłṉe’íí; tazhik’áné bi’aadíí bit’ats’in bitł’ááh yuṉe’ bizhaazhé onáyiṉiłíí k’ehgo nichągháshé doo ałch’ídn łináhishṉiił hasht’į́į́ ndi doo hádaałt’į́į́ da ni’! ");
INSERT INTO apwNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nikįhíí yó’agodot’ąą: da’aṉiigo gádaanohwiłdishṉii, Bik’ehgo’ihi’ṉań bizhi’ yee higaałń ba’ahégosini at’éé, daadołṉiihíí bijįį zhą́ nadaashołtséh. ");
INSERT INTO apwNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Łah Jews daagodnłsiníí bijįį Jesus Phárisee nant’án nlíni bigową yuṉe’ iyąąyú óyáágo, dé’at’éégo daayinł’į́į́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jesus ła’ nṉee nádaanilzołi yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Áík’ehgo nṉee begoz’aaníí nłt’éégo yídaagołsini ła’íí Phárisees daanlíni yich’į’ hadziigo gáyiłṉii, Ya’ godilziníí bijįį na’ch’ilziihgo goz’ąą née, dah née? ");
INSERT INTO apwNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Doo hadń bich’į’ hanadzii da lę́’e. Áík’ehgo nṉee kah yaa nagháhihíí náidnlǫǫzgé’ náilziih, áígé’ onáyíł’aad. ");
INSERT INTO apwNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Áígé’ gánádaabiłn’ṉiid, Hadń godilziníí bijįį bitúlgayé dagohíí bimagashi o’i’áń yúyaa ogo’yúgo dagoshch’į’ hanáidishood ya’? ");
INSERT INTO apwNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Áígee doo hadń hananádzii da lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nṉee kú neheskaihíí hagee nṉee itisgo ádaat’eehíí dahnádaadinibįhgee dahnihebįįłgo yiłtsąąná’ iłch’ígót’aahgo na’goṉi’íí yee hadziigo gáṉíí, ");
INSERT INTO apwNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ni’i’ṉéhgee da’idąąyú ńṉáh, niłnṉiidyúgo, nṉee itisgo ádaat’eehíí dahnádinibįhyú dahnódaa hela’; ágándzaayúgo nṉee nitisgo at’éhi, Kú ńṉáh, biłdo’ṉiid n’íí; ");
INSERT INTO apwNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Áík’ehgo nṉee bá da’idaaníí nich’į’ nigháhgo gániłdidoṉiiłgo at’éé, Ai dahsíńdaageehíí díí nṉeehíí baa goń’aah; ádaayáńdzįgo dá’ích’į’égee goz’ąągee dahńdaał. ");
INSERT INTO apwNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kú ńṉáh golzeego naa ch’íníhít’ą́ą́go akú ńyaago dá’ích’į’égee goz’ąągee dahńdaał; áík’ehgo nṉee bá da’idaaníí ńyáágo, Shit’eké, yúdahgee dahńdaał, niłṉiigo, kú neheskaihíí biṉááł itisgo nni’dilteeh. ");
INSERT INTO apwNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hadń itisgo ádéstįįhń ádaagoch’olba’go ádolṉiił; áíná’ ádaagoch’olba’ń itisgo at’éégo ádolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesus nṉee bá da’idaaníí ałdó’ yich’į’ hadziigo gáyiłṉii, Nigowągee ha’iz’ąągo da’idąąyúgo, dagohíí o’i’ą́ą́go da’idąąyúgo, doo dá nit’eké, nik’isyú, nik’íí, dagohíí ízis da’it’iiníí na’ashhahgé’ daagolííníí zhą́, Kú nohołkáh da’ołsąąyú, biłnṉii da; ágándzaayúgo ni ałdó’, Kú ńṉáh, nádaaniłdo’ṉiiłi at’éé, t’ąązhį’ ni nich’į’ naná’doho’ṉił. ");
INSERT INTO apwNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ná da’idąąyúgo tédaat’iyéhíí, baa dahnagoz’aaníí, doo nadaakai dahíí, ła’íí biṉáá édaagodiníí, Da’ołsąąyú nohołkáh, daabiłnṉii doo: ");
INSERT INTO apwNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Áík’ehgo niyaa gozhǫ́ǫ́ doleeł; áí doo hat’íí nich’į’ nanádaihi’ṉiił dahíí bighą: nṉee nłt’éhi nanezna’íí naadikaihíí bijįį nich’į’ nanádo’ṉił. ");
INSERT INTO apwNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nṉee ła’ Jesus yił iyaaníí díí yidezts’ąągo gábiłṉii, Bik’ehgo’ihi’ṉań bilałtł’áhgee goz’ąą yuṉe’ hadń báń yiyąą doleełíí biyaa gozhǫ́ǫ́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus gábiłṉii, Nṉee ła’ ízisgo bá da’idąągo, nṉee łą́ą́go, Kú da’ołsąąyú nohołkáh, yiłnṉiid lę́’e: ");
INSERT INTO apwNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Áígé’ da’idaaníí biká’ ngonyáágee binal’a’á gáyiłṉii, Hayíí, Kú nohołkáh, daabiłdéṉiidíí, Yushdé’, daabiłnṉii; ałk’iná’ ąął á’ilzaa. ");
INSERT INTO apwNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Áíná’ nṉee dała’á daantį́į́go, Doo ákú disháh da, daaṉii nkegonyaa. Nṉee da’iłtséhíí gáṉíí, Ni’ nagohéłṉii ni’, áí nish’į́į́yú díyáá: shá ch’ígon’aah, nánoshkąąh. ");
INSERT INTO apwNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ła’ihíí gánádo’ṉiid, Shíí magashi bena’ibąąsé gonenan nahéłṉii ni’, áí bínshtááhyú díyáá: shá ch’ígon’aah, nánoshkąąh. ");
INSERT INTO apwNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ła’ihíí ałdó’ gánádo’ṉiid, Shíí shi’aad gozlįį ni’, áí bighą doo ákú nsháh da. ");
INSERT INTO apwNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nal’a’á binant’a’ áí nṉeehíí hat’íí daaṉiihíí yił nagosṉi’. Nant’ánhíí bágóchįįdgo binal’a’á gáyiłṉii, Ti’i, dahałe, kįh gozṉilíí biyi’ da’itinyú, kįh bigizh ch’énádaagozt’i’yú nṉee tédaat’iyéhíí, baa dahnagoz’aaníí, doo nadaakai dahíí, ła’íí biṉáá édaagodiníí, Yushdé’, daabiłnṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Áígé’ nal’a’áhíí binant’a’ gáyiłṉii, Shinant’a’, áshiłnṉiihíí ałk’iná’ begolzaa, ndi t’ah goz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nant’ánhíí binal’a’á gáyiłṉii, Ti’i, da’itinyú ła’íí kįh biṉaayú ch’il łédaant’i’yú nihiyóód, áík’ehgo shigową yuṉe’ ch’iląą doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nṉee, Kú da’ołsąąyú nohołkáh, ch’éh ádaabiłdéṉiidíí shi’idáń doo daayolįh at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesus nṉee łą́ą́go yił náłseeł: áí yich’į’ adzaago gáyiłnṉiid, ");
INSERT INTO apwNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Dahadń shaa nyááhń bitaa, bimaa, bi’aad, bichągháshé, bik’isyú, bilahkííyú, ła’íí dabíí bi’ihi’ṉa’ ndi shitisgo bił nzhooníí, áń doo shiké’ higaałíí át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Dahadń bitsį’iłna’ááhíí doo dahiditįįhgo shiké’ dahdigháh dahń, doo shiké’ higaałíí át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nohwitahyú dahadń yúdahyú nil’ąągo iłk’e’ishtł’i nzįyúgo, áń iłtsé ndaahgoshą’ da’kwíí ileeh shįhíí yołtag, dá bínil’ąą shį ąął ashłéhzhį’ nzįgo? ");
INSERT INTO apwNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Dahyúgohíí kįh bitł’ááh łédn’aahíí ąął áyíílaaná’ hat’íí áile’ihíí doo ąął áile’ yínés’ąą dayúgo, nṉee biṉááł doo ąął áile’ dahíí baa daadloh nkegonyaa, ");
INSERT INTO apwNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Gádaaṉiigo, Áí nṉeehíí itł’i nkegonyaa ndi doo ąął áile’ yínés’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ła’íí nant’án, nant’án ła’ yił nagonłkaad doleełyúgo, iłtsé ndaahgoshą’ yaa natsekees, shisilááda gonenango doo náhóltag dayú ła’ nant’ánhíí bisilááda nadin doo náhóltag dayúhi bił nagonshkaad dábik’eh shį, nzįgo? ");
INSERT INTO apwNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Dahyúgohíí, yił nagonłkaadíí t’ah ńzaadgé’ hikaahná’, bá ch’iṉííh nadai’aahíí bidáhzhį’ daidił’aa gádaayiłdiṉiihgo, Iłt’eké náodleeh. ");
INSERT INTO apwNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Áík’ehgo nohwitahyú dahadń bíyééhíí dawa bił nzhǫǫhíí bighą doo yich’ą́’hígháh hát’į́į́ dahń, doo shiké’ higaałíí át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ishįįh nłt’éé, ndi ishįįh doo nk’ǫ́ǫ́zh da silįįyúgo, hat’íí bee nk’ǫ́ǫ́zhgo ánálṉe’? ");
INSERT INTO apwNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Łį́į́ bichan ndi bił nadigeedgo kíyaayú doo nalkaad bik’eh da; daazhógo ch’élkáad. Hadń bijeyi’ golííníí íyésts’ąą le. ");
INSERT INTO apwNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tax bich’į’ nadaahi’ṉiiłíí ła’íí nṉee doo bik’ehyú ádaat’ee dahíí dawa Jesus yídaayésts’ąągo yich’į’ nihikáh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Phárisees daanlíni ła’íí begoz’aaníí ye’ik’eda’iłchíhi Jesus yída’iłtahgo gádaaṉii, Áí nṉee, nṉee doo bik’ehyú ádaat’ee dahíí yich’į’ nihikáh, ła’íí yił da’ayąą. ");
INSERT INTO apwNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Áík’ehgo Jesus iłch’ígót’aahgo na’goṉi’íí yee yił nagolṉi’ gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Nohwitahyú ła’ dahadń dibełį́į́ dała’á gonenadín da’izlįįyú yinoyołgo, dała’á ch’a’oyááyúgo, ngost’ádin ngost’áíhíí dakú nyiṉííłshą’, áíná’ dała’á bich’ą́’ ch’a’oyááhíí yíka ntaah, dá náidnłtįįzhį’? ");
INSERT INTO apwNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Náidnłtįįná’ yaa bił gozhǫ́ǫ́go biwosyú dahiłteeh. ");
INSERT INTO apwNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Bigowąyú nádzáágo bit’eké ła’íí ba’ashhahgé’ daagolííníí dała’áyíílaago gádaayiłṉii, Shił nohwił daagozhǫ́ǫ́ le’; shidibełį́į́ ch’a’oyáá n’íí nádiłtįįh. ");
INSERT INTO apwNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Da’áík’ehgo ałdó’ nṉee dała’á nchǫ’go at’ééhń binchǫ’ yich’ą́’zhį’ adzaahń, ngost’ádin ngost’áí nṉee daanjǫǫ daanzįgo binchǫ’ doo yich’ą́’zhį’ ádaaṉe’ dahíí bitisgo yaaká’yú baa koł daagozhǫ́ǫ́ doleeł, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Isdzán ła’ zhaali béshłigai be’alzaahi gonenan naiṉilgo, dała’á baa ch’a’oltǫ’yúgo, kǫ’ yidiltłaadgoshą’ nágołshóhgé’ yiká déz’įį, danáidn’ąązhį’? ");
INSERT INTO apwNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Náidn’ąąná’ bit’eké ła’íí ba’ashhahgé’ daagolííníí dała’áyíílaago gádaayiłṉii, Shił nohwił daagozhǫ́ǫ́ le’; zhaali shich’a’oltǫ’ n’íí nádi’ąą. ");
INSERT INTO apwNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Da’áík’ehgo ałdó’ nṉee dała’á nchǫ’go at’ééhń binchǫ’ yich’ą́’zhį’ adzaahíí bighą Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí biṉááł gózhǫ́ǫ́ doleeł, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus gánádo’ṉiid, Ła’ nṉee biye’ naki golį́į́ lę́’e: ");
INSERT INTO apwNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iké’gee nagháhihíí bitaa gáyiłṉii, Shitaa, dawahá ṉíyééhíí łahzhį’ shíyéé doleełíí shaa nné’. Áík’ehgo bá iłk’ííyíné’go yaa yiné’. ");
INSERT INTO apwNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Da’kwíí iskąą hik’e iké’gee nagháhihíí dawahá bíyééhíí dała’áyíílaago ńzaadyú óyáá, ákú da’adzaayú análwołgo dawahá bíyéé n’íí ąął ch’ayishchįįh. ");
INSERT INTO apwNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Dá ąął ch’ayishchįįná’ áígee shiṉá’ góyéégo daagodeyaa lę́’e; áík’ehgo dawahá yídn nlįįgo nkenyaa. ");
INSERT INTO apwNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nṉee ła’ áígee daagolííníí yá ná’nziid; góchi yá nádi’né’go. ");
INSERT INTO apwNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Góchi bi’idáń dák’azhą́ yiyąą ndi nṉee doo ła’ bá’diné’ da. ");
INSERT INTO apwNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ídínágoszįįdgo gádiłdi’ṉii, Shitaa yánada’iziidíí łą́ą́go bi’idáń daagolį́į́, ik’e’an nazṉilgo, áíná’ shihíí shiṉá’ dák’azhą́ shiziłhee! ");
INSERT INTO apwNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Shíí nádishdáhgo shitaa bich’į’yú nádésdzá, áík’ehgo gábiłdishṉiih, Shitaa, yaaká’zhį’ bich’į’, ła’íí ni nich’į’ nchǫ’go asdzaa, ");
INSERT INTO apwNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Doo niye’ daashiłch’iṉii bik’eh sitį́į́ da: nánada’iziidíí k’ehgo nashíńłteeh. ");
INSERT INTO apwNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Áík’ehgo nádiidzaago bitaa yich’į’ onádzaa. T’ah ńzaadgé’ nádaałná’ bitaa biłtsąągo baa ch’ozbaadgo bich’į’ nádilwod, bizénáschidgo bizts’ǫs lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Biye’ gábiłṉii, Shitaa, yaaká’zhį’ bich’į’, ła’íí ni nich’į’nchǫ’go asdzaa, doo niye’ daashiłch’iṉii bik’eh sitį́į́da. ");
INSERT INTO apwNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Áíná’ bitaahíí yánada’iziidi gádaayiłṉii, Diyágé dázhǫ́ itisgo nłt’éhihíí kú ndaanołtsoosgo bá ádaagołe’; gan bik’edn’áné bik’e daadoł’aa, kee ałdó’ bá ádaagołe’: ");
INSERT INTO apwNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Magashi zhaazhé bidinesk’ah n’íí nádaadołt’e’go bá daazołhee; áík’ehgo daahiidąągo nohwił daagozhǫ́ǫ́ le’: ");
INSERT INTO apwNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Díí shiye’ daztsąą nsį n’íí t’ah hiṉaa lą́ą́; ch’a’otłizh n’íí nádiltįįh. Áík’ehgo bił daagozhǫ́ǫ́ nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Biye’ iłtsé nagháhihíí k’edolzaayú naghaa n’íí nádaał: áń kįh yit’ahzhį’ nnyááná’ bésh dilwoshé bee idot’aałná’ da’ch’ilzhishgo yidezts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nada’iziidi ła’ yiká ánṉiidgo nayídiłkid, Hat’íí bighą ágot’įįh? ");
INSERT INTO apwNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Gábiłṉii, Nidizhé nádzáá; nitaa magashi zhaazhé bidinesk’ah n’íí bá zesdįį, nidizhé dánłt’éé nt’éégo baa nadzááhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Áík’ehgo bágóchįįdgo doo ha’agháh dahíí bighą bitaa bich’į’ ch’ínyáágo, Ha’ánṉáh, biłṉiigo nábokąąh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bitaa yich’į’ hadziigo gáyiłṉii, Doo ałch’ídé łegodzaa da nich’oshṉiigo áshiłnṉiihíí dawa bikísk’eh ánsht’ee ni’; ndi gantł’ízí zhaazhé ndi t’ah doo hwaa shaa ńłteeh da, shit’eké bił shił daagozhǫ́ǫ́ le’at’éhi: ");
INSERT INTO apwNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Áíná’ díí niye’, bizháan da’adzaahíí yił anákeełgo dawahá ṉíyéé n’íí ąął ch’ayishchįįná’ nádzááyú, dagoshch’į’ magashi bidinesk’ah n’íí bá zínłhįį. ");
INSERT INTO apwNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Bitaa gábiłṉii, Shiye’, ni nił gonshłįį, shíyééhíí dawa ṉíyéé. ");
INSERT INTO apwNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nohwił daagozhǫ́ǫ́, nohwił gonedlįįgo dábik’eh go’į́į́: díí nidizhé daztsąągo daandzį n’íí hiṉaa; ch’a’otłizh n’íí nádiltįįh. ");
INSERT INTO apwNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus bitsiłke’yu yich’į’ hananádzii, Łah nṉee ízisgo it’íni ła’ nṉee bána’iziidihi bíyééhíí dawa yiṉádéz’įįgo nyinłtįį lę́’e; áí nṉee ízisgo it’įį n’íí gádaabiłch’iṉii, Ṉíyééhíí yiṉádéz’iiníí dawahá nich’ą́’ da’izlį́į́ áił’įį. ");
INSERT INTO apwNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Áík’ehgo bána’iziidíí, Yushdé’, yiłnṉiidgo gáyiłṉii, Hat’íí lą́ą́ daaniłch’iṉiigo naa idists’ag? Naltsoos biká’dawahá shíyééhíí shá beda’izoh n’íí shaa nán’aah; k’adíí dawahá shíyééhíí doo shá biṉádíń’įį da. ");
INSERT INTO apwNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Na’iziidíí gádiłdi’ṉii, Hago ląą ashṉe’? Shinant’a’ dawahá bá biṉádésh’įį n’íí shich’ą́’ nágodn’ąą: doo nagoshgeed bik’eh da; ídóshkeedyúgohíí ádaayánsdzį. ");
INSERT INTO apwNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Shíí hago ashṉe’ bígonsį, kodé’ ch’ínáshi’dolt’e’go nṉee bitashaa doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Áík’ehgo binant’a’íí yaa hadais’aa n’íí, Yushdé’, daayiłṉiigo, da’iłtséhihíí gáyiłṉii, Shinant’a’ da’kwíí naa ha’áá? ");
INSERT INTO apwNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mazhííl dała’á gonenadíni ik’ah bee kedaanes’ąągo, ṉii. Áík’ehgo gánáyiłdo’ṉiid, Dagoshch’į’ ńdaahgo ashdladin zhą́ shaa ha’áá ánágódle’go k’e’iłchíí. ");
INSERT INTO apwNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ła’ gánáyiłdo’ṉiid, Ṉihíí da’kwíí naa ha’áá? Áík’ehgo gáṉíí, Tł’oh nagháí ízis nchaahíí dała’á gonenadín dádeskadgo. Áík’ehgo gánáyiłdo’ṉiid, Tsebídin zhą́ shaa ha’áá ánágódle’go k’e’ełchíí. ");
INSERT INTO apwNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nant’án bána’iziidná’ bich’į’ nach’aahń, Gonyą́ą́yú ándzaa ląą, yiłṉii: díí jįį ni’gosdzáń biká’ ágot’ee zhiṉéé nakaihíí daałinolt’įįłíí, idindíín zhiṉéé nakaihíí bitisgo daagoyą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ni’gosdzáń biká’ ízis it’iiníí bee nohwit’eké ádaagołdle’; áík’ehgo ásdįįdgo dahazhį’ daagolį́į́yú nohwá ch’ídaadotįįł, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Hadń da’ayą́hágo ágot’eehíí ndi begondlįįgo nayik’í’iziidyúgo ízisgo ágot’eehíí ałdó’ begondlįįgo nayik’í’iziid doleeł: hadń ayą́hágo doo bik’ehyú át’éé dayúgo dázhǫ́ itisgo doo bik’ehyú át’éé da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Áík’ehgo ni’gosdzáń biká’ it’iiníí doo nzhǫǫgo ádaanołsį dayúgo, hadń yaaká’yú it’iiníí nohwaa yiné’ áíná’? ");
INSERT INTO apwNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ła’ bíyéhi doo bá nzhǫǫgo ádaanołsį dayúgo, hadń dánohwíí nohwíyééhíí nohwaa yiné’ áíná’? ");
INSERT INTO apwNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Doo hadń binant’a’ naki da: dała’a bił nchǫ’ná’ ła’ihíí bił nzhǫǫ doleełi at’ééhíí bighą, dagohíí dała’á yotą’ná’ ła’ihíí yich’ołaa doleełi at’éé. Bik’ehgo’ihi’ṉań ła’íí it’iiníí dała’ doo hago’at’éégo bá na’ch’iziidi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Phárisees daanlíni, zhaali ádáhádaat’ínihi, díí dawa daidezts’ąąná’ Jesus yaa yádaałti’go yaa daadloh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Áík’ehgo gáyiłnṉiid, Nṉee binadzahgee daanołshǫǫ ádaanoł’įį ndihíí Bik’ehgo’ihi’ṉań nohwijíí yuṉe’íí yígółsį: nṉee hat’íí itisgo ádaayoṉiihíí, áí Bik’ehgo’ihi’ṉań bił nchǫ’. ");
INSERT INTO apwNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Bik’ehgo’ihi’ṉań yegos’aaníí ła’íí binkááyú nada’iziidíí ádaaṉiihíí yebik’ehgo ngóhéyáá, John nyáázhį’: áígé’ yushdé’ godezt’i’go Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí nłt’éégo baa na’goṉi’íí t’ah baa nadaagolṉi’ goldoh, áík’ehgo nṉee dała’á daantį́į́gee dázhǫ́ hádaat’įįgo ídéédaalnaa. ");
INSERT INTO apwNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yáá ła’íí ni’gosdzáń biłgo bech’ígoṉáhgo doo nyee da, áíná’ begoz’aaníí dázhǫ́ da’ayą́hágo ndi bech’ígowáhgo nyee. ");
INSERT INTO apwNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dahadń bi’aad yił iłk’ínát’aazhgo ła’i yił nnaná’ṉááyúgo áń nant’į’ naghaa: ła’íí dahadń isdzán biką’ yó’onáyíłt’e’ń yił nṉááyúgo áí nṉee nant’į’ naghaa. ");
INSERT INTO apwNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Łah nṉee ízisgo it’iiníí, nak’ą’ nłt’éhi łichiigo dotł’izhi bidiyágé lę́’e, dajįį biigha idáń łáń ílííníí zhą́ yiyáni. ");
INSERT INTO apwNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Áí nṉee bich’ígót’i’gee ła’ nṉee ídókeedi dá łóód zhą́hi, Lázarus holzéhi, ndaabich’istįį. ");
INSERT INTO apwNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nṉee ízis it’iiníí iyąągé’ báń bizhool nanidéhíí shá dó’né’ hadó’ nzį lę́’e: ła’íí łicháné baa hikáhgo biká’ łóódíí daayiłṉaad. ");
INSERT INTO apwNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nṉee tét’iyé n’íí daztsąągo Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí Abraham bijííláhzhį’ ídéyóltą’go onádaabistįį lę́’e: nṉee ízis it’įį n’íí ałdó’ daztsąągo łełtįį. ");
INSERT INTO apwNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ch’iidntahyú dázhǫ́ biniigonłt’éégo hadag déz’įįgo ńzaadyú Abraham Lázarus ídéyóltą’go yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Áík’ehgo Abraham nawode yich’į’ ánṉiid, Abraham, shitaa, shaa ch’onba’go Lázarus shich’į’ nł’áá, bilázhoozhíí tú bee náyółt’oodgo shizaad shá yinołk’az; díí kǫ’íí biyi’ nyeego shich’į’ nagowaahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Áíná’ Abraham gábiłnṉiid, Shiye’, t’ah hinṉááná’ bínánlṉíh, dawahá nłt’ééhíí ṉíyéé ni’, áíná’ Lázarus doo hat’íí nłt’éhi bíyéé da ni’: k’adíí áń nłt’éégo ábi’dilzį, áíná’ nihíí k’adíí niniigonłt’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nohwíí nohwigizhgee dázhǫ́ yúyahgo nalwozh ałdó’: áík’ehgo kodé’ azhį’ nach’idikáh doleeł n’íí doo hago’at’éégo akú nach’idikáh át’éé da; áíná’ doo yushdé’ nach’idikáh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Áík’ehgo nṉee ízis it’įį n’íí gánṉiid, Shitaa, nánoshkąąh, Lázarus shitaa bigowąyú ńł’áá: ");
INSERT INTO apwNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Shik’isyú ashdla’i golį́į́; áí doo kúyaa góyéégo goz’ąą yuyaa dikáh da doleełhíí bighą Lázarus bił nagolṉi’go nł’áá. ");
INSERT INTO apwNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham gábiłnṉiid, Bíí Moses ła’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí k’eda’ashchiiníí yedaagoyiłį́į́; áí yídaayésts’ąą le’. ");
INSERT INTO apwNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ágánṉiid, Dah, shitaa Abraham: áíná’ dahadń daztsánihi bich’ą́’gé’ náńł’ááyúgo shik’isyú binchǫ’íí yich’ą́’zhį’ ádaaṉe’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham gánábiłdo’ṉiid, Moses ła’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí k’eda’ashchiiníí doo daidits’ag dayúgo, daztsáni naadiidzaago bił nadaagolṉi’ ndi doo da’odląą da doleeł go’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus bitsiłke’yú gáyiłnṉiid, Nakídintaahíí dábegolṉe’ go’į́į́, áíná’ hadń na’íntaahíí bá góyéé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tséé be’ik’áhi nchaahi bik’osyú bídestł’ǫǫgo túnteel beh hilt’e’go bá nzhǫǫ doleeł ni’, díí doo ízisgo ádaat’ee dahíí dała’á nchǫ’go at’į́į́go doo áile’ da doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ídádaadesółt’įį: nik’isn nich’į’ nchǫ’go at’į́į́yúgo bee bich’į’ yáńłti’; áík’ehgo, Shaa nágodin’áah, niłṉiiyúgo baa nágodin’áah. ");
INSERT INTO apwNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dała’á jįį gosts’idn nich’į’ nchǫ’go ánádzaayúgo, gosts’idn nich’į’ ánádzaago, Shaa nágodin’áah, niłṉiiyúgo, baa nágodin’áah. ");
INSERT INTO apwNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesus binadaal’a’á gádaabiłṉii, Nohwi’odlą’íí dayúweh nohwá bínáhodaałgo áńłsį. ");
INSERT INTO apwNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Áík’ehgo Jesus gádaabiłṉii, Nohwi’odlą’ mústard biyígé ga’at’ééyúgo ndi, díí tsį sýcamine holzéhi gádaabiłdołṉii, Dáni nikeghadgé’ hádńłts’ǫǫdgo túnteel biyi’gee ík’endléé; áík’ehgo da’ánṉiiyú aṉe’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nohwitahyú ła’ bána’iziidíí bá nagodzįįzyúgo, dagohíí magashi bá nanyoodyúgo, ya’ kíyaagé’ nádzáágo gáyiłṉiih née, Yushdé’, dák’ad ńdaahgo ináá? ");
INSERT INTO apwNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Dah, áíná’ gáyiłṉiih, Shá á’íle’, áígé’ ík’e’idleego shich’į’ n’ííkáah, ąął iyą́ą́gé’ ąął ishdląąyúgo; bikédé’go ináá ła’íí ídlą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ya’ bana’iziidíí da’áyiłṉiiyú adzaahíí bighą, Ahíyi’ee, yiłṉii née? Dah, nsį. ");
INSERT INTO apwNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nohwíí ałdó’ da’ánohwiłdi’ṉiihíí dawa ádaasolaayúgo gádaadołṉiih, Nohwíí doo nił daandlįį dago ná nada’iidziid: hat’íí, Ádaałe’, nohwiłdi’ṉiihíí zhą́ ádaasiidlaa. ");
INSERT INTO apwNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerúsalemyú higaałyú Jesus Samária ła’íí Gálilee bigizhyú higaał lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Gotah yuṉe’ oyáágo nṉee gonenan łóód doo ínádįh dahi, léprosy holzéhi, yaa nakaihi baa hikai, áí da’aṉahyú nazįįgo, ");
INSERT INTO apwNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Daadilwoshgo gádaaṉii, Jesus, Nant’án, nohwaa ch’onbáah. ");
INSERT INTO apwNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus áí nṉeehíí yiłtsąągo gádaayiłṉii, Daadołkáhgo okąąh yedaabik’ehi bich’į’ ch’í’ṉah ádaadołdle’. Hikahná’ nłt’éé nádaasdlįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Áí nṉee dała’á nábi’dilziihíí yígołsįįdgo t’ąązhį’ Jesus yaa nadzáá, nádziihíí Bik’ehgo’ihi’ṉań ya’ahénzįgo dilwoshgo, ");
INSERT INTO apwNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesus biyahzhį’ hayaa adzaa, Ahíyi’ee, yiłṉiigo: áń Samáriagé’ gólínihi. ");
INSERT INTO apwNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Áígé’ Jesus gábiłṉii, Gonenan nádaadziihná’ ngost’áíhíí hayú? ");
INSERT INTO apwNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dadíń zhą́ łahgé’ nṉeehihi t’ąązhį’ nadzáá, Bik’ehgo’ihi’ṉań ya’ahénzįgo. ");
INSERT INTO apwNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nádndáhgo híṉááł, ni’odlą’íí nłt’éégo ánániidlaa, yiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Phárisees daanlíni Jesus nayídaadiłkidgo gádaayiłṉii, Da’os’ah Bik’ehgo’ihi’ṉań nant’aa doleełíí kú bengowáh? Jesus gáṉíí, Doo hwit’įįgo kú bengowáh da: ");
INSERT INTO apwNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kúńko díń’įį! dagohíí, Nláhyú nláh! doo daach’iṉii da: Bik’ehgo’ihi’ṉań ałk’iná’ nohwiyi’ yuṉe’ nant’aa. ");
INSERT INTO apwNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesus bitsiłke’yu gáyiłṉii, Shíí, nṉee k’ehgo Niyááhíí bijįį dała’á nách’ołtséh hádó’ daanołsįįh doleeł, ndi doo ndaahołtséh át’éé da goldohíí dahagee biká’ ngowáh. ");
INSERT INTO apwNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nláhyú daadeł’į́į́, dagohíí, Kú daadeł’į́į́, daanohwiłch’iṉii doo: áíná’ akú dołkáh hela’, biké’ dołkáh hela’. ");
INSERT INTO apwNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Hada’didla’íí bee yáá dáłázhiṉéégé’ łahzhiṉéégo bee got’įį nágodleeh; áík’ehgo shíí, nṉee k’ehgo Niyááhíí, ánsht’ee doleeł ch’í’ṉah áshi’delzaahíí bijįį. ");
INSERT INTO apwNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Dabí’iłtsé łą́ą́go shiniigodilṉe’go daałinolt’įįłíí doo hádaashit’įį da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noe t’ah golį́į́ná’ ágot’ee n’íí k’ehgo shíí, nṉee k’ehgo Niyááhíí, nánshdáhíí bijįį ałdó’ ágágot’ee doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Áíná’ Noe tsina’eełíí yiyi’ oyaazhį’ da’ch’iyąą ni’, da’ch’idląą ni’, nnádaach’iłse’ ni’, ła’íí łaa daagoch’ihiṉiiłgo nnádaaze’ ni’, áígé’ tú idezjoolgo ąął tú bił daach’idesdzii’. ");
INSERT INTO apwNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot t’ah golį́į́ná’ ałdó’ da’ágágot’ee ni’; da’ch’iyąą ni’, da’ch’idląą ni’, nada’ch’ihiłṉiih ni’, kaa nadaahi’ṉiih ni’, k’eda’ch’idilee ni’, ła’íí gową ádaagoch’ile’ ni’; ");
INSERT INTO apwNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Áíná’ Lot Sódomgé’ ch’ínyááhíí bijįį kǫ’ ła’íí tséé łikǫ’i, brimstone holzéhi, yaaká’gé’ náłtą́ą́go ąął daakową́ą́’. ");
INSERT INTO apwNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Shíí, nṉee k’ehgo Niyááhíí, ch’í’ṉah ádideshdle’híí bijįį ałdó’ ágágot’ee doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Áí bijįį hadń bikįh biká’yú dahsdaahń bikįh yuṉe’ bíyééhíí siné’i, gódah yiká o’ánáodáh hela’: da’áík’ehgo ałdó’ nṉee k’edolzaahíí yiyi’ naghaahń t’ąązhį’ ánáo’ṉe’ hela’. ");
INSERT INTO apwNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot bi’aadń bínádaałṉiih. ");
INSERT INTO apwNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dahadń bi’ihi’ṉa’ yaa bił goyééhń, áí bich’ą́’ da’izlį́į́ hileeh; áíná’ dahadń ádaayis’ṉahgo bi’ihi’ṉa’ da’izlį́į́ silįį’ń ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doo. ");
INSERT INTO apwNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Shíí gánohwiłdishṉii, Áí bitł’é’ nṉee naki dashteezhgo, dała’á nádilteehná’ ła’íí da’akú sitįį doo. ");
INSERT INTO apwNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Isdzáné naki łísht’a da’ik’aayúgo, dała’á nádilteehná’ ła’íí da’akú sidaa doo. ");
INSERT INTO apwNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nṉee naki k’edolzaayú na’aashyúgo, dała’á nádilteehná’ ła’íí da’akú sizįį doo. ");
INSERT INTO apwNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hayú, nohweBik’ehń? daabiłṉii. Jesus gádaabiłṉii, Dahayú its’í siné’yú ch’ishoogi dała’at’éé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Da’ch’okąąh nt’éégo doo kił iyeeh dago Jesus na’goṉi’íí bee iłch’ígó’aahgo ");
INSERT INTO apwNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Gánṉiid, Łah kįh gozṉilyú yánáltihń gólį́į́, Bik’ehgoihi’ṉań doo yidnłsíni da, nṉee doo bił ilíni da: ");
INSERT INTO apwNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ła’ isdzán, itsaa nlíni, áígee golíni dakozhą́ baa nadáhgo gábiłṉii, Shá iłk’ígodnłdǫ́ǫh, nṉee ła’ shik’enṉiihíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Dét’įhézhį’, Dah, yiłṉii: ndi bikédé’gohíí dabíí gádiłdi’ṉii, Bik’ehgo’ihi’ṉań doo dinsį da, nṉee doo shił ilį́į́ da; ");
INSERT INTO apwNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Da’ágát’éé ndi díí itsaahíí ts’íshiłdįįhíí bighą bá iłk’ígodishdǫǫh; dahyúgohíí kú nádáh ńt’ééyúgo shiyiłhá. ");
INSERT INTO apwNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesus gánádo’ṉiid, Yánáltihń doo dábik’ehyú át’éé dahń ánṉiidíí ídaayesółts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bik’ehgo’ihi’ṉań nṉee hayíṉilííshą’ dajįį biigha ła’íí datł’é’ biigha bich’į’ ádaaṉiihíí bich’į’ ídésts’ąągo ńzaad godihigháh ndi yá ilk’ígodildǫǫh. ");
INSERT INTO apwNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Dagoshch’į’ yá iłk’ígodildǫǫh, nohwiłdishṉii. Da’ágát’éé ndi shíí nṉee k’ehgo Niyááhíí nánsdzaagoshą’, ni’gosdzáń biká’ nṉee daashodlaaníí ła’ daastséh shį? ");
INSERT INTO apwNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus nṉee ła’ dázhǫ́ nshǫǫ daanzįgo dabíí zhą́ ádaa da’odlíígo, ła’íí doo hadń yił da’óltagi da, iłch’ígót’aahgo na’goṉi’íí yee hadziigo gáyiłṉii: ");
INSERT INTO apwNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Łah nṉee naki wą́’yú da’ch’okąąh goz’ąą yuṉe’ o’áázh lę́’e; dała’á Phárisee nlíni, ła’ń tax bich’į’ nadaahi’ṉíłi. ");
INSERT INTO apwNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Phárisee nlínihń ídá’okąąhgo gáṉíí, Bik’ehgo’ihi’ṉań, shíí ła’ nṉee ádaat’eehíí k’ehgo doo ánsht’ee dahíí bighą naa ahénsį, áí aadaanchį’íí, doo bik’ehyú ádaat’ee dahíí, nant’į’ nadaakaihíí, díí tax bich’į’ nahi’ṉiłń ndi doo bik’ehgo ánsht’ee da. ");
INSERT INTO apwNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Shíí dałán godilziníí biyi’ nakidn dáshiṉá’ oshkąąh, ła’íí dawahn shíyééhíí dágonenanyú iłk’é’ṉilgo dała’á Bik’ehgo’ihi’ṉań bich’į’ nanáhishṉił. ");
INSERT INTO apwNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Áíná’ tax bich’į’ nahi’ṉiłihń da’aṉahyú sizįįgo bijííláhzhį’ nyínłts’į, dá doo hadag dighaałé gáṉíígo okąąh, Bik’ehgo’ihi’ṉań, shíí shinchǫ’ łánihi shaa ch’onba’ le’. ");
INSERT INTO apwNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Shíí nohwił nadaagoshṉi’, Áí nṉeehń gowąyú onádzaa, Bik’ehgo’ihi’ṉań binadzahgee bízhą́ binchǫ’ n’íí bich’ą́’né’ná’ ła’ nṉeehíí, dah: hadń itisgo ádéstįįhń ádaagoch’olba’go ádolṉiił; áíná’ hadń ádaagoch’olba’ń itisgo at’éégo ádolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jesus mé’ baa ndaach’ihezṉil lę́’e, yiká ndaadilṉiih daabich’ido’ṉíígo: áíná’ Jesus bitsiłke’yu daayiłtsąągo, Doo ágádaałt’įį da, daabiłnṉiid. ");
INSERT INTO apwNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Áíná’ Jesus, Yushdé’, daayiłṉiigo, Ch’ík’eh chągháshé shich’į’ nihikáh le’, doo t’ąązhį’ daahínółtą’ da; bíí ga’ádaat’eehíí Bik’ehgo’ihi’ṉań bilałtł’áhgee daanlįį, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Da’aṉiigo gádaanohwiłdishṉii, Dahadń chągháshé ałch’ísę́híí k’ehgo Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí nágodn’ąąyúgo zhą́ Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah hileeh. ");
INSERT INTO apwNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Łah nant’án Jesus nayídiłkidgo gáyiłṉii, Iłch’ígó’aahíí nłt’éhi ńlínihi, hago ląą áshṉe’go ihi’ṉaa doo ngonel’ąą dahíí bee hinshṉaa doleeł? ");
INSERT INTO apwNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus gábiłṉii, Hat’íí bighą nṉee nłt’éhi shiłnṉii? doo hadń nłt’éé da go’į́į́, dała’á zhą́, Bik’ehgo’ihi’ṉań zhą́. ");
INSERT INTO apwNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Bik’ehgo’ihi’ṉań ngon’ą́ą́ lę́’ehíí bígońłsį́ go’į́į́, Doo nant’į’ nach’ighaa da, Doo ich’iziłhee da, Doo ich’in’įįh da, Doo łé’ch’iłchoo da. Kitaa ła’íí kimaa ch’idnłsį. ");
INSERT INTO apwNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nṉeehíí gábiłṉii, Áníi nashaagé’ godezt’i’go áí dawa bee ánsht’ee. ");
INSERT INTO apwNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesus áí yidezts’ąąná’ gábiłṉii, Dała’á zhą́ doo bee áńt’éé da: ti’i, dawa ṉíyééhíí naa nahoṉiihgo, zhaalihíí tédaat’iyéhíí bita’iṉííh, áík’ehgo yaaká’yú dawahá łáń ílíni ṉíyéé doleeł: áíná’ yushdé’, shiké’ dahsinṉáh. ");
INSERT INTO apwNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Áí yidezts’ąąná’ doo bił gozhǫ́ǫ́ da silįį: dázhǫ́ ízis it’įįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Doo bił gozhǫ́ǫ́ da silįįgo Jesus bígołsįįdná’ gáṉíí, Nṉee ízis da’it’iiníí Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah daaleehgo dázhǫ́ bá nyee! ");
INSERT INTO apwNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Łį́į́ bigháń ha’i’áhíí bená’kadé bigha’i’áńyú ch’égháhgo bá nyeená’ ízis it’iiníí Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah hileehgo itisgo bá nyee. ");
INSERT INTO apwNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nṉee áí daidezts’aaníí gádaaṉii, Áíná’ hadń zhą́ hasdábi’dilteeh? ");
INSERT INTO apwNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesus gáṉíí, Nṉee dahat’íhíta doo łayole’ at’éé dahíí Bik’ehgo’ihi’ṉań łayile’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peter gábiłṉii, Nohwíí nohwíyéé dawa bich’ą́’ dahdihiikainá’ niké’ dahsiikai ni’. ");
INSERT INTO apwNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesus gánádaabiłdo’ṉiid, Da’aṉii gádaanohwiłdishṉii, Bik’ehgo’ihi’ṉań bilałtł’áhgee daanlįįzhį’ itah nlįįhíí bighą bigową, bi’aad, bik’isyú, bimaa, bitaa, dagohíí bichągháshé yich’ą́’ dahnyááyúgo, ");
INSERT INTO apwNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Áń díí goldohíí biyi’ áí bitisgo doo ałch’ídn baa na’né’ doleeł, ła’íí łahgo náhodeszaago ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus bitsiłke’yu nakits’ádahíí yił its’ákaigo gádaayiłnṉiid, Jerúsalem yúdag deikai, ákú Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí shíí, nṉee k’ehgo Niyááhíí, shaa k’eda’ashchiiníí dawa begolṉe’. ");
INSERT INTO apwNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nṉee doo Jews daanlįį dahíí baa shi’dilteehgo shaa daadloh doleeł, yúyahgo shiniidaagodile’ ła’íí shik’ídaadihizheeh doleeł: ");
INSERT INTO apwNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hashída’iłtsaas doo, ła’íí daashiziłhee doleeł, áígé’ taagi jįį hileehgo naadishdáh. ");
INSERT INTO apwNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Áíná’ hat’íí ṉiigo aṉííhíí doo ła’ yídaagołsį da: aṉííhíí baa ch’ananl’į’go doo bił ídaagozį da. ");
INSERT INTO apwNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus Jériko k’ad yaa higháhná’, ła’ nṉee biṉáá ágodini ídókeedgo itín bahyú sidaa: ");
INSERT INTO apwNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nách’ołseełíí yidezts’ąągo, Hat’íí lą́ą́ ágodzaa, ṉiigo na’ídiłkid lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Áík’ehgo gádaabiłch’iṉii, Jesus, Názarethgé’ gólíni, kúk’e higaał. ");
INSERT INTO apwNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Áík’ehgo nádidilghaazhgo gáṉíí, Jesus, David biYe’ ńlíni, shaa ch’onbáah. ");
INSERT INTO apwNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ła’ ádn náłseełíí bił daadestehgo, Godnch’áad, daabiłṉii, áíná’ da’tiségo dilwosh, gáṉíígo, David biYe’ ńlíni, shaa ch’onbáah. ");
INSERT INTO apwNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus nnyáágo, Yushdé’ bił dołkáh, ṉii: bit’ahzhį’ nyááná’ nayídiłkidgo ");
INSERT INTO apwNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Gáyiłṉii, Hat’íílá ná áshłe’ háńt’įį gá? Nṉee biṉáá ágodiníí gábiłṉii, SheBik’ehń, desh’į́į́go ánáshídle’. ");
INSERT INTO apwNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus gábiłṉii, Niṉáá nágódleeh, ni’odlą’ nłt’éégo ánániidlaa. ");
INSERT INTO apwNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Dagoshch’į’ go’į́į́ nasdlįįgo biké’ dahiyaa, Bik’ehgo’ihi’ṉań ba’ahénzįgo: áík’ehgo nṉee dawa daayiłtsąąná’ Bik’ehgo’ihi’ṉań ya’ahédaanzį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus Jérikoyú ch’ínyáá lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ákú ła’ nṉee Zacchéus holzéhi, tax bich’į’ nadaahi’ṉiiłíí da’tiséyú sitíni, ízis it’íni golį́į́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesus holzeehń yiłtséh hát’į́į́; áíná’ nṉee daałiłjizhgé’ bíí ałch’ísę́híí bighą ch’éh histséh nzį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Áík’ehgo náłseełíí yádn nádilwodgo Jesus ch’égháh doleełyú gashdla’á nan’áhi yiká’zhį’ hayáá. ");
INSERT INTO apwNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesus áígee nyááná’ hadag déz’įįná’ gábiłṉii, Zacchéus, dáhałe gódah ch’íńṉáh; díí jįį nich’į’ hasta’ deyáá. ");
INSERT INTO apwNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Áígé’ dáhałego gódah ch’ínádzaago yaa bił gozhǫ́ǫ́go gowąyú yił onát’aazh. ");
INSERT INTO apwNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nṉee áí daayiłtsąąná’ bída’iłtahgo gádaaṉii, Nṉee doo bik’ehyú át’éé dahń yaa hasta’ oyáá. ");
INSERT INTO apwNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zacchéus nnyáágo Jesus gáyiłṉii, ShiNant’a’, dawahá shíyééhíí iłṉí’gé’ tédaat’iyéhíí baa hishṉiił; áíná’ dahat’íhíta bee bich’į’ nashich’a’yúgo, dį́į́dn dábitisyú da’ágánáołąągo bich’į’ nanádihishṉił. ");
INSERT INTO apwNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus gábiłṉii, Díí jįį behasdách’igháhíí kogee naháztaaníí bee bá goz’ąą, Zacchéus ałdó’ Abraham bich’ą́’gé’ bi’dishchíni at’éégo. ");
INSERT INTO apwNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Shíí, nṉee k’ehgo Niyááhíí, nṉee ch’a’onezdeehíí biká daadesh’įį ła’íí hasdáhishṉiiłhíí bighą niyáá. ");
INSERT INTO apwNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nṉeehíí ídaayésts’ąągo Jesus iłch’ígót’aahgo na’goṉi’íí yee bił nanádaagołṉi’, Jerúsalemyú dák’azhą́ hígháhíí bighą, ła’íí Bik’ehgo’ihi’ṉań nant’aa doleełíí dagoshch’į’ ch’í’ṉah áile’ daanzįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Łah nṉee ízisgo at’éhi ńzaadyú óyáá, nant’án ábi’dilṉe’go, áígé’ nádáhgo. ");
INSERT INTO apwNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nṉee gonenan bánada’iziidíí, Yushdé’, daayiłnṉiidgo, bestso pounds holzéhi dała’ágo daantį́į́gee yita’izṉii gáyiłṉiigo, Díí zhaalihíí bigowáhgo ádaałe’, danánsdzaazhį’. ");
INSERT INTO apwNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Áíná’ nṉee áígee daagolííníí daabich’ołaahíí bighą ch’iṉii nadai’aahíí biké’ odais’a’ gádaaṉiigo, Díń nṉeehń doo nohwinant’a’ hileeh hádaahiit’įį da. ");
INSERT INTO apwNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nant’án ábi’delzaagé’ nádzáágo, Shánada’iziidi zhaali baa daasiṉilíí yushdé’ shá daabiłdołṉiih, ṉii lę́’e, dała’á daantį́į́gee zhaali da’kwíí ádaizlaahíí bígonsįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Da’iłtsé baa nyááhń gábiłṉii, Shinant’a’, nizhaalihíí gonenan itisyú ánáyiidlaa. ");
INSERT INTO apwNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Áík’ehgo gáyiłṉii, Nłt’éégo shána’izíídi, nłt’ééyú ándzaa lą́ą́: da’ayą́há ndi nłt’éégo shá ánlaahíí bighą gonenáágo kįh gozṉili bá nant’áágo ánishłe’. ");
INSERT INTO apwNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Iké’gee nanádzááhń gáṉíí, Shinant’a’, nizhaalihíí ashdla’ itisyú ánáyiidlaa. ");
INSERT INTO apwNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Áík’ehgo gáyiłṉii, Nihíí ashdla’go kįh gozṉili bá nant’áá doo. ");
INSERT INTO apwNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ła’ nanádzáágo gáṉíí, Shinant’a’, kóh nizhaali, bił isíídisgo ná síłné’ ni’: ");
INSERT INTO apwNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nṉee doo begónedząą dahi ńlį́į́híí bighą nénásdzid: hat’íí doo ninne’ dahíí dahnné’, hat’íí doo k’edínlaa dahíí náhigéésh. ");
INSERT INTO apwNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nant’ánhíí gábiłṉii, Dáni niyati’íí bee ch’é’édént’ąą, nchǫ’go shána’izíídi. Nṉee doo begónedząą dahi nshłįįgo bígońłsį, doo ni’niné’ dahíí nádishné’hi, ła’íí doo k’edíláá dahíí náhishgeeshi: ");
INSERT INTO apwNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Hat’íí bighą áíná’ shizhaalihíí doo shá ha’áńṉil da, kú nánsdzaago bínágodzaahíí bił hanaṉil doleeł ni’? ");
INSERT INTO apwNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nṉee bit’ahyú nadaaziiníí gáyiłṉii, Bizhaali bich’ą́’ nadaadołṉiiłgo nṉee bizhaali gonenanhń baa daanołṉiił. ");
INSERT INTO apwNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","(Nohwinant’a’, áń la’ ałk’iná’ gonenan bíyéé, daabiłṉii.) ");
INSERT INTO apwNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Gádaanohwiłdishṉii, Dakówa hat’íí kíyééhíí kaa nado’né’ doleeł; ła’íí doo hat’íí kíyéé dahíí, kíyéé lę́’e ndi kich’ą́’ nadido’né’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Áíná’ díí daashich’ołaahíí, doo binant’a’ hishłeeh hádaashit’įį dahíí, kú shidáhyú ndaahołt’e’go shiṉááł nadaałtseed. ");
INSERT INTO apwNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesus ąął nagosṉi’ná’ ádn dahiyaa wą́’yú Jerúsalemyú. ");
INSERT INTO apwNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Béthphage ła’íí Béthany k’ad yaa highánná’, dził Olives holzéhi si’ąągee nyááná’ bitsiłke’yu naki oyił’a’, ");
INSERT INTO apwNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Gáyiłṉiigo, Ti’i, nohwádnyú gotahyú doł’aash; dáha’ał’aashgee túlgayé zhaazhé dahastł’ǫ́ǫ́go baa noł’aash, t’ah doo hwahá hadń yiká’ dahndaahi da: áí k’e’oł’adgo kú nánołǫǫs. ");
INSERT INTO apwNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Dahadń, Hat’íí bighą k’e’oł’ad? nohwiłṉiiyúgo, gábiłdidołṉiił, NohwiNant’a’ hát’į́į́go áhiit’įį. ");
INSERT INTO apwNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Doł’aash, yiłṉii n’íí dahazh’aazh, áík’ehgo Jesus dá ábiłṉii n’íí k’ehgo túlgayé zhaazhé yaa n’áázh. ");
INSERT INTO apwNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","K’edaayi’adná’ nṉee áí túlgayé bíyéhihi gádaabiłṉii, Hat’íí bighą túlgayé zhaazhé k’e’oł’ad? ");
INSERT INTO apwNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Gádaayiłṉii, NohwiNant’a’ hát’į́į́go áhiit’įį. ");
INSERT INTO apwNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Áígé’ túlgayé zhaazhé Jesus yaa daizlǫǫzgo bidiyágéhíí biká’ dahdaihezṉilná’ Jesus yiká’ dainesdaa. ");
INSERT INTO apwNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bił higaałyú bádnyú nṉee bidiyágé yídaagosteel lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jerúsalemyú k’ad yaa higháhgo, dził Olives holzéhi si’ąągé’ hayaa iditingee biké’ náłseełíí ízisgo áná’ol’įįłíí daayiłtsąąhíí bighą bił daagozhǫ́ǫ́go Bik’ehgo’ihi’ṉań ya’ahédaanzįgo nádaadidilghaazhgo gádaaṉii nkegonyaa: ");
INSERT INTO apwNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ízisgo Nant’án, nohweBik’ehń bizhi’ yee higaałń ba’ahégosini at’éé: yaaká’yú iłch’į’gont’éé, da’tisé goz’ąągee idindíín. ");
INSERT INTO apwNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nṉee biṉááł ágot’įįdíí ła’ Phárisees daanlíni Jesus gádaayiłṉii, Iłch’ígó’aahíí ńlíni, niké’ náłseełíí, Doo daagonołch’aad da, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Áíná’ gádaayiłṉii, Áí doo daagonłch’aad dayúgo dá tséé ndi nádaadidilghaash go’į́į́nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ałhánégé’ higaałná’ kįh gozṉilíí yiłtsąągo yaa hichag. ");
INSERT INTO apwNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Gáṉíígo, Díí jįį ndi hat’íí bee niyi’ iłch’į’gont’éé doleełíí bígońłsįyúgo nłt’éé doleeł ni’! Áíná’ naa ch’anal’į’. ");
INSERT INTO apwNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nik’edaanṉiihíí niṉaa łeedaagodigeedgo łeezh niṉaa łeedn’aago doo hwaa ch’ígót’i’ da doleełíí bich’į’ goldoh. ");
INSERT INTO apwNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nkínádaanidiłt’eeh doo, ni ła’íí nichągháshé niyi’ daagolííníí; doo ła’ hayú tséé iłk’idaanasdláágo ádaanile’ da; Bik’ehgo’ihi’ṉań naa nyááná’ doo bígońłsį dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Da’ch’okąąh goz’ąą yuṉe’ Jesus ha’ayáágo ákóṉe’ baa nada’iṉiihíí ch’íinihiyood nkegonyaa lę́’e; ");
INSERT INTO apwNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Gádaayiłṉiigo, Díínko bek’e’eshchįį, Shikįhíí kįh biyi’ da’ch’okąąhíí át’éé, áíná’ nohwihíí daan’įįhíí bigową ádaagosolaa ląą. ");
INSERT INTO apwNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Dawa jįį da’ch’okąąh goz’ąą yuṉe’ iłch’ígó’aah lę́’e. Okąąh yedaabik’ehi ła’íí begoz’aaníí ye’ik’eda’iłchíhi ła’íí nṉee itisgo nadaandeehi daabiziłhee hádaat’įį, ");
INSERT INTO apwNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ndi doo hago ádaabile’ da: nṉee nłt’éégo bich’į’ ídaayésts’ąąhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Łah da’ch’okąąh goz’ąą yuṉe’ Jesus nṉee yił ch’ígó’aahgo nłt’éégo na’goṉi’íí yaa nagolṉi’go okąąh yebik’ehi itisyú nadaandeehi, begoz’aaníí ye’ik’eda’iłchíhi, ła’íí Jews yánazíni baa hikaigo, ");
INSERT INTO apwNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Gádaabiłṉii, Hadń bik’ehgo ánánt’įįł, nohwił nagólṉi’, hadń naa godin’ą́ą́go áńt’įįh? ");
INSERT INTO apwNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesus gádaabiłṉii, Shíí ałdó’ dała’á nanohwídishkid; áí shił nadaagołṉi’: ");
INSERT INTO apwNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ya’ John baptize ádaagole’íí yaaká’gé’go née, dagohíí nṉee bich’ą́’gé’go née? ");
INSERT INTO apwNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Łił yádaałti’go gádaałiłdi’ṉii, Yaaká’gé’go daan’ṉiihyúgo gánohwiłdiṉiih, Áíná’ hat’íí bighą doo daahołdląą da láń? ");
INSERT INTO apwNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Áíná’, Nṉee bich’ą́’gé’go, daan’ṉiihyúgo: nṉee nohwił łedaats’iłṉe’: John da’aṉii Bik’ehgo’ihi’ṉań binkááyú na’iziidi nlįį ni’ daanzįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Áík’ehgo, Doo baa nadaagolṉi’ da, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesus gánábiłdo’ṉiid, Shíí ałdó’ hadń bik’ehgo ánásht’įįłíí doo nohwił nagoshṉi’ da. ");
INSERT INTO apwNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesus díí iłch’ígót’aahgo na’goṉi’íí yee nṉee yił nanagolṉi’ nkegonyaa; Ła’ nṉee dasts’aa k’eidnláágo bá yiṉádaadéz’íni yá ch’ígohet’ąąná’ łahyú ni’ goz’ąąyú óyáá, ákú sidaago ńzaad begodigháhyú. ");
INSERT INTO apwNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Da’nest’ą́ą́gee ngonyáágo ła’ bána’iziidi bidasts’aa bá yiṉádaadéz’íni yich’į’ oyił’a’, binest’ą’ ła’ bá náyíné’go: áíná’ dasts’aa bá yiṉádaadéz’ínihíí nbída’eshtłizhná’ dá dílkǫǫhgo onádaabis’a’. ");
INSERT INTO apwNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bána’iziidíí ła’ihi onaayíł’a’: áń ałdó’ nyída’eshtłizhgo yiniidaagodezlaaná’ dádílkǫǫhgo onádais’a’. ");
INSERT INTO apwNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Áígé’ taagigee onaayíł’a’: áń ałdó’ yiṉída’desṉihgo ch’ídaist’e’. ");
INSERT INTO apwNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dasts’aa hentííníí bíyééhíí, Hago ashłe’? ṉii. Shiye’ shił nzhónihi dish’aa: áń zhą́ daayiłtsąągo daidnłsį doleeł shį. ");
INSERT INTO apwNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Áíná’ dasts’aa yiṉádaadéz’íni áń daayiłtsąąná’ gádaałiłdi’ṉii, Díí dasts’aa hentííníí bíyéé doleełíí át’éé: haląą, daazołdee, áígé’ bíyéé doleeł n’íí daanohwíyéé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Áík’ehgo dasts’aa hentííníí yiyi’gé’ ch’ídaist’e’go daizes‐hį́į́. Áíná’ dasts’aa hentííníí bíyéhi hago ádaabile’shą’? ");
INSERT INTO apwNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Áń nádáhgo dasts’aa bá yiṉádaadéz’į́į́ n’íí naiłtseedná’ dasts’aa hentííníí ła’ihi yá ch’ínágohet’aah. Nṉee áí daidezts’ąąná’ gádaanṉiid, Begolṉéh hela’. ");
INSERT INTO apwNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Áíná’ yineł’į́į́go gádaabiłṉii, Áíná’ díí bek’e’eshchiiníí hat’íí golzeego ágolzee, Tséé kįh ádaagole’íí yó’odaisṉe’ n’íí, iłhagon’áágee da’iłtsé si’aaníí silįį? ");
INSERT INTO apwNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Dahadń áí tséé yiká’ nágo’yúgo bizéígo ábile’; áíná’ dahadń áí tséé biká’ naltǫ’yúgo ik’áń k’ehgo ábile’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Da’áígee begoz’aaníí ye’ik’eda’iłchíhi ła’íí okąąh yedaabik’ehi itisyú nandeehíí, iłch’ígót’aahgo na’goṉi’i yee hadzii n’íí bíí ádaabiłṉiigo yídaagołsįhíí bighą ha’ádaiłt’e’ hádaat’įį, ndi nṉee dała’adzaahíí yédaasdzii’. ");
INSERT INTO apwNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Daabinel’į́į́go anadaal’izi bich’į’ odais’a’, nṉee nzhóni ádaadil’įįgo, Jesus biyati’íí bee daahiiljizh daanzįgo, nant’ánchań baa daanłteehgo baa yá’iti’ doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Áík’ehgo nabídaadiłkidgo gádaabiłṉii, Iłch’ígó’aahíí, nłt’éégo yáńłti’, ła’íí da’áígee iłch’ígóń’aahgo bídaagonlzį, nṉee doo ła’ itisgo síńłtįį da, dawa nich’į’ dáłełt’ee, Bik’ehgo’ihi’ṉań bich’į’zhiṉéé goz’aaníí da’aṉiigo baa iłch’ígóń’aah: ");
INSERT INTO apwNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ya’ Caesar bich’į’ nadaach’iṉiiłgo begoz’ąą née, dah dó’nolį? ");
INSERT INTO apwNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Áíná’ nadaach’aahíí yígółsįgo gádaabiłṉii, Hat’íí bighą yashti’íí bee daashołjizhgo ádaashiłdołṉii? ");
INSERT INTO apwNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Zhaali, penny holzéhi, ła’ shaa noł’aahgo nesh’į́į́. Hadń be’ilzaa, hadń bizhi’ biká’ dahgoz’ąą? Caesar bíyéhi ląą, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesus gánádaabiłdo’ṉiid, Caesar bíyééhíí Caesar baa daanołṉiił, áíná’ Bik’ehgo’ihi’ṉań bíyééhíí Bik’ehgo’ihi’ṉań baa daanohṉiił. ");
INSERT INTO apwNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nṉee biṉááł Jesus aṉííhíí doo bee daahiljizh at’éé da: áíná’ t’ąązhį’ hanadziihíí baa bił díyadaagot’eego, doo hat’íí daaṉii da lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Áígé’ ła’ Sádducees daanlíni, nanezna’ n’íí doo naadiikáh da daaṉíhi, Jesus yaa hikaigo nabídaadiłkid, ");
INSERT INTO apwNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Gádaaṉiigo, Iłch’ígó’aahíí, Moses gáṉíígo nohwá k’e’eshchįį lę́’e, Ła’ nṉee bik’isn bi’aad yich’ą́’ daztsąąyúgo, bichągháshé doo ła’ dayúgo, nṉeehń bik’isn n’íí bi’aad yił nnádo’ṉeełgo bik’isn n’íí chągháshé bá ágodolṉiił, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Łah nṉee iłk’isn gosts’idi daanlįį lę́’e: áí da’iłtséhíí nṉáágo bichągháshé doo ła’ dago daztsąą. ");
INSERT INTO apwNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bik’isn nakigeehíí isdzánhíí yił nnaná’ṉáágo bichągháshé doo ła’ dago dananástsą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Taagigeehíí ałdó’ isdzánhíí yił nnaná’ṉáágo dananástsą́ą́; gosts’idihíí dawa da’ágánádaadzaa: bichągháshé doo ła’ dago nanezna’. ");
INSERT INTO apwNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dá’iké’yú isdzánhíí ałdó’ daztsąą. ");
INSERT INTO apwNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Áík’ehgo nanezna’gé’ naach’idikáhgee hayíí bi’aad doleeł, iłk’isyú gosts’idihíí dawa yił nadaazṉaaná’? ");
INSERT INTO apwNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus gádaabiłṉii, Nṉee díí ni’gosdzáń biká’ nakaihíí nnádaałse’, ndaagohiṉiiłgo nnádaałse’: ");
INSERT INTO apwNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Áíná’ yaaká’go yił da’otagihíí nanezna’gé’ naadikaigo doo nnádaałse’ da, doo ndaagohiṉiiłgo nnádaałse’ da: ");
INSERT INTO apwNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Doo nanánne’ da: Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí k’ehgo daagolį́į́; naadikaihíí itah daanlįįgo, Bik’ehgo’ihi’ṉań bichągháshé daanlįį. ");
INSERT INTO apwNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nanezna’íí naadiikáhgo Moses, ch’il yaa nagosṉi’íí bee nohwich’į’ dá’ígózįgo ágolaa, gáṉíígo, Bik’ehgo’ihi’ṉań, Abraham yokąąhń, da’áń Isaac, Jacob ałdó’ yokąąhń, yiłṉiigo yozhii. ");
INSERT INTO apwNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Áń doo nanezna’íí yokąąhń nlįį da, daahiṉaahíí zhą́: nṉee nanezna’ ndi Bik’ehgo’ihi’ṉań binadzahgee t’ah daahiṉaa. ");
INSERT INTO apwNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Áígé’ begoz’aaníí ye’ik’eda’iłchíhi ła’ gádaabiłṉii, Iłch’ígó’aahíí, nłt’éégo háńdzii. ");
INSERT INTO apwNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Áí bikédé’go nṉee daaste’go doo hadń nabínánłkid da. ");
INSERT INTO apwNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesus gánádaabiłdo’ṉiid, Hago’at’éégo, Christ David biye’ nlįį, daach’iṉii áíná’? ");
INSERT INTO apwNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David dabíí naltsoos Psalms holzéhi biyi’ k’e’eshchįį gáṉíígo, Bik’ehgo’ihi’ṉań sheBik’ehń gáyiłnṉiid, Shigan dihe’nazhiṉéégo síńdaa, ");
INSERT INTO apwNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Nik’edaanṉiihíí ni’isna’ ashłe’go nikełtł’ááhyú niṉílzhį’. ");
INSERT INTO apwNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David, sheBik’ehń biłṉiigo bozhíí, áík’ehgo hago’at’éégo biye’ nlįį áíná’? ");
INSERT INTO apwNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nṉee dawa bídaayésts’ąągo Jesus bitsiłke’yu gádaayiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Begoz’aaníí ye’ik’eda’iłchíhi baa daagonołsąą, áí bidiyágé daanṉeezihi daagolį́į́go nakaigo, ła’íí na’hiṉiih nadaagoz’ąąyú bich’į’ ádaach’iṉiigo zhą́ bił daagozhǫ́ǫ́, ła’íí Jews ha’ánáłséh nagozṉil yuṉe’ nṉee yánazíni dahnádinbįhyú itah dahnaháztąągo, ła’íí da’adąągee nṉee ízisgo ádaat’eehíí dahnádinbįhyú zhą́ itah dahnáháztąągo bił daagozhǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Áí isdzáné itsaa daanlíni bigową yich’ą́’ nádaagohi’aa ła’íí daazhógo ádaaṉiigo ńzaad gont’i’go da’okąąh: áí itisgo biniigonłt’éégo bándaagodot’aał. ");
INSERT INTO apwNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus hadag déz’įįgo nṉee ízis da’it’iiníí zhaali biyi’ ohilkaadíí biyi’ yuyaa bizhaali odaayihiłkaadgo yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Áígé’ isdzán itsaa nlíni tét’iyéhi zhaali naki doo ílį́į́ le’at’éhi oyíłkaadgo yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Áík’ehgo gáṉíí, Da’aṉiigo gádaanohwiłdishṉii, áí itsaa tét’iyéhíí nṉee dawa zhaali odaiheskaadíí bitisgo zhaali oyíłkaad: ");
INSERT INTO apwNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nṉee ízis da’it’iiníí bizhaali Bik’ehgo’ihi’ṉań yaa daayiṉiiłgo zhaali biyi’ ohilkaadíí biyi’ yuyaa odaiheskaad: áíná’ itsaahń tét’iyé ndi bizhaali da’áí zhą́ goyiłíni oyíłkaad. ");
INSERT INTO apwNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nṉee ła’ da’ch’okąąh goz’aaníí tséé dénzhónéhi ła’íí dawahá dénzhónéhi ndaayihezṉilíí be’ágolzaahi yaa yádaałti’ná’ Jesus gáṉíí, ");
INSERT INTO apwNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Díí daoł’iiníí tséé iłká’ dahnagozṉilíí doo ła’ iłká’ dahnast’ą́ą́ da doleeł, dawa nanehiłkaad doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Áík’ehgo nabídaadiłkidgo gádaabiłṉii, Iłch’ígó’aahíí, da’os’ah ágoṉéhi, dawa be’ágoṉe’go hat’íí bee bígózį doleeł? ");
INSERT INTO apwNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Áík’ehgo gábiłṉii, Ádaa daagonołdząą, nṉee ła’ ch’a’onohołt’e’ hela’: łą́ą́go shizhi’ yee daahikáh doleeł, Shíí Christ nshłįį; ałk’iná’ Christ nádaałíí biká’ ngonyáá, daaṉiigo: áí biké’ dahdołkáh hela’. ");
INSERT INTO apwNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Áígé’ nagonłkaadíí ła’íí iłch’į’ nadaagontł’ogíí baat’ídaanołsį ndi doo ńdaałdzid da: áí iłtsé begolṉe’hi at’éé; ndi nnágodáhíí doo dagoshch’į’ begolṉe’ da. ");
INSERT INTO apwNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Áígé’ gánádaabiłdo’ṉiid, Nṉee iłtah at’éégo hadaazt’i’íí iłch’į’ nanágonłkaad doleeł, ła’íí nṉee dała’á binant’a’ daagolínihíí ałdó’ iłch’į’ nanágonłkaad doleeł: ");
INSERT INTO apwNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Da’adzaayú ízisgo ni’ nagohi’naa doleeł, shiṉá’ góyééhíí benagowaa doo, ła’íí nadaagontł’ogíí iłtah at’ééhíí benadaagowaa doleeł; dázhǫ́ négodzidíí ła’íí godiyįhgo be’ígóziníí yaaká’gé’go bee ádaagot’įį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Áí dawa t’ah doo hwahá begolṉe’ daná’ nṉee daanohwiłtsoodgo nohwiniidaagodile’ doleeł, Jews ha’ánáłséhíí bich’į’ odaanohwiłt’e’ doleeł, ła’íí ha’ádaanohwiłkaad doo, ła’íí shizhi’ bee daanohwich’ozhííhíí bighą ízisgo nant’án ła’íí nant’ánchań biyahzhį’ nádaanohwiłt’eeh doo, nohwaa yádaałti’go. ");
INSERT INTO apwNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Dząągee shá nadaagołṉi’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Doo iłtsé hat’íí dishṉiih shįhíí baa natséskees dago nohwiini’ ładaałe’: ");
INSERT INTO apwNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Shíí yati’ nohwaa hishṉiił doo, góyą́ą́go ádaanohwish’įį doleeł, hayíí nohwaa dahdaagoz’aaníí doo nohwitisgo hanádaadziih dago, doo nohwaa daagodiit’aah dago. ");
INSERT INTO apwNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Dá daanohwitaa, nohwimaa, nohwik’isyú, nohwik’íí, ła’íí nohwit’eké ndi nohwaa yáda’iti’go ndaanohwiṉiił doleeł; ła’íí ádaaṉiigo nohwíí ła’ nadaanohwiłtseed doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Shizhi’ bee daanohwich’ozhííhíí bighą nṉee dawa nohwik’edaanṉiih doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Da’ágát’éé ndi nohwitsits’in biká’gé’ nohwitsizílíí dała’á ndi doo ch’a’odeeł da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Daagoyéégo nohwich’į’ na’idziid ndi hadag ádaanołt’ee, áík’ehgo nohwiyi’siziiníí bídaagowa’. ");
INSERT INTO apwNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jerúsalemyú silááda biṉaa łeednt’i’go daoł’įįyúgo, daagołchǫǫhíí biká’ ngoṉáhgo bídaagonołsį doo. ");
INSERT INTO apwNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nṉee Judéa golzeeyú daagolííníí dził naz’aaníí yich’į’ okeeh doo; Jerúsalem yuṉe’ daagolííníí ch’ínókáh; ła’íí da’dáńyú daagolííníí Jerúsalem yuṉe’ dáko ha’aokáh hela’. ");
INSERT INTO apwNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iłk’ínágodildǫǫhíí goldoh biká’ ngowaa, baa k’e’eshchiiníí dawa begolṉe’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Áígee goldohíí daaltsaaníí ła’íí isdzáné mé’ daabiłbe’íí bá góyéé doleeł! Ni’gosdzáń biká’ góyéégo nagowaa doo, díí hat’i’íí áígee biniidaagodidolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bésh be’idiltłishé bee nabi’ditseed doo, ła’íí nṉee iłtah at’éégo hadaazt’i’íí bi’isna’ daanlįį doo: doo Jews daanlįį dahíí Jerúsalem yiká’ nakai doleeł, doo Jews daanlįį dahíí ąął bengonyaazhį’. ");
INSERT INTO apwNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ch’ígona’áí, tł’é’gona’áí, ła’íí ts’iłsǫǫsé biyi’ godiyįhgo be’ígóziníí hit’įį doo; ni’gosdzáń biká’ nṉee iłtah at’éégo hadaazt’i’íí hat’íí bighą ánágot’įįł doo yídaagołsį dago bitah góyéégo nagowaa doo; túnteel ła’íí túnteel nádidáhíí díyat’éégo áṉíí doleeł; ");
INSERT INTO apwNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ni’gosdzáń biká’ hago ágoṉéh shįhíí bik’e nṉee natsídaalyiz doleeł: yaagé’ benagowodíí ndi nahi’naa doo. ");
INSERT INTO apwNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Áígee áníita shíí, nṉee k’ehgo Niyááhíí, yaak’os biyi’gé’ shinawod bee, ła’íí dázhǫ́ shich’ą́’idindláádgo náshdaałgo daashidołtseeł. ");
INSERT INTO apwNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Díí benagowaahíí bee nkegonyaaná’ hadag yaa daanołt’ąągo hadag daadeł’į́į́; hasdánohwidi’ṉiiłíí biká’ ngonyááhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iłch’ígót’aahgo na’goṉi’íí yee yił nagolṉi’; Fig bitsiníí ła’íí tsį dawa daanoł’į́į́; ");
INSERT INTO apwNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bit’ąą nádaagodleełgo daał’įįná’ k’ad shįį nágodleehgo bídaagonołsį. ");
INSERT INTO apwNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Da’áík’ehgo áí be’ádaagoṉe’íí goldohgo daał’įįná’ Bik’ehgo’ihi’ṉań nant’aahíí biká’ nagowaago bídaagonołsį doo. ");
INSERT INTO apwNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Da’aṉii gádaanohwiłdishṉii, Díí daałinolt’įįłíí doo nohwee ch’ígoṉáh da, díí ádaanohwiłdéṉiidíí dawa begolzaago zhą́’ ");
INSERT INTO apwNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yáá ła’íí ni’gosdzáń biłgo bech’ígoṉáh doleeł, áíná’ shiyati’íí doo bech’ígowáh da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ídádaadesół’įį, daazhógo anákeełíí, bił nádaagodiyisíí, ła’íí ni’gosdzáń biká’ ágot’eehíí doo bee ádaanołt’ee da le’; ágádaanołt’eeyúgo dánohwinats’ą́ą́ná’ áí bijįį dánko bee nohwiká ngododaałi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Áí bijįį be’ijizhé iłjizhíí k’ehgo nṉee dawa ni’gosdzáń biká’ daagolííníí bee biká’ ngowáh. ");
INSERT INTO apwNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Áík’ehgo dákozhą́ daadoł’į́į́ ła’íí da’ołkąąh, áík’ehgo nohwidziilíí nohwá ágolzaahíí bee áí ágoṉe’íí dawa bich’ą́’zhį’ ádaałṉe’ doleeł, ła’íí shíí, nṉee k’ehgo Niyááhíí, shidáhzhį’ daadołsįįł. ");
INSERT INTO apwNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Dajįį biigha Jesus da’ch’okąąh goz’ąą yuṉe’ iłch’ígó’aah; tł’é’gohíí dził Olives golzéhi si’ąąyú bee náiłkáhyú onadáh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dázhǫ́ t’ałbį nṉee dawa da’ch’okąąh goz’ąąyú nihikáh lę́’e, bídaayésts’ąąyú. ");
INSERT INTO apwNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Báń benilzoołé da’ádįhgo báń álzaahi daadaaníí, bitis hagowáh n’íí bee bíná’goṉiihgo holzéhi ałhánégé’ begogaał. ");
INSERT INTO apwNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Okąąh yebik’ehi itisyú nadaandeehíí ła’íí begoz’aaníí ye’ik’eda’iłchíhi Jesus dáhago’at’éégo daayiziłheego ch’éh yiká daadéz’įį; nṉee yédaaldzidhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Áígé’ Judas, Iscáriot holzéhi, Satan bihiyáá, áń nakits’ádahíí itah nlíni. ");
INSERT INTO apwNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas dahnyaago okąąh yebik’ehi itisyú nadaandeehíí ła’íí bisilááda yánadaant’aahíí hago’at’éégo Jesus ch’íyí’aah doleełíí yaa yił yádaałti’. ");
INSERT INTO apwNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Áí yaa bił daagozhǫ́ǫ́go zhaali ła’ baa daach’iné’go ndaagoch’is’ąą lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas bił dábik’ehgo hago’at’éégo Jesus ch’íyí’aahíí yiká déz’įį, nṉee dała’at’ééhíí doo ła’ daná’. ");
INSERT INTO apwNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Báń benilzoołé da’ádįhgo báń álzaahi daadaaníí bijįįgee ngonyáá, dibełį́į́ zhaazhé zesdįįgo Bik’ehgo’ihi’ṉań baa hi’né’, bitis‐hagowáh n’íí bee bíná’goṉiihgo. ");
INSERT INTO apwNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus Peter ła’íí John oyił’a’ gáṉíígo, Bitis‐hagowáh n’íí bee bíná’goṉiihgo da’adaaníí nohwá iłch’į’gołe’, da’iidąą doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Áígé’ gádaabiłṉii, Hayú ná iłch’į’gohiidle’ háńt’įį? ");
INSERT INTO apwNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus gádaabiłṉii, Kįh gozṉil yuṉe’ ha’ał’aashgee ła’ nṉee tús tú beyo’áłi nohwaa higháh doleeł; hayíí goz’ąą yuṉe’ ha’agháhíí biké’ ha’ał’aash; ");
INSERT INTO apwNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Áígee bigową golííníí gáyiłdołṉiih, Iłch’ígó’aahíí gániłṉii, Gosta’ nakaahíí hayú bágoz’ąą, ákóṉe’ bitis‐hagowáh n’íí bee bíná’godiṉíhgo shitsiłke’yu bił da’ashąą doleeł? ");
INSERT INTO apwNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Áík’ehgo ik’ehyú dahnágost’ąą yuṉe’ ałk’iná’ dawa siṉili bił nkáh doleeł; ákóṉe’ nohwá iłch’į’gołe’. ");
INSERT INTO apwNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ákú ó’áázh, áík’ehgo Jesus da’ádaabiłṉii n’íí k’ehgo yaa n’áázh: áígee bitis‐hagowáh n’íí bee bíná’godiṉíhgo da’adaaníí iłch’į’daizlaa. ");
INSERT INTO apwNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Da’adąągee ngonyáágo bitsiłke’yu biłgo dahdinezbįh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Gádaayiłṉii, Doo hwahá shiniigodilṉe’é díí bitis hagowáh n’íí bee bíná’goṉiihgo da’adaaníí dázhǫ́ nohwił daashąą hásht’į́į́ ni’: ");
INSERT INTO apwNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Doo naanáshdą́ą́ da, Bik’ehgo’ihi’ṉań bilałtł’áhgee goz’ąąyú díí bee bíná’goṉiihíí begolzaago zhą́, nohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Idee yee náidnkąągo ya’ahénzįgo oskąądgé’ gáṉíí, Díí nádaadoł’aahgo daanołtįįgee ła’ da’ołdląąh: ");
INSERT INTO apwNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gánohwiłdishṉii, Kogé’ godezt’i’go dasts’aa bitoohíí doo naanáshdlą́ą́ da, Bik’ehgo’ihi’ṉań nant’aa doleełíí begodeyaago zhą́. ");
INSERT INTO apwNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Áígé’ báń náidn’ąągo ya’ahénzįgo oskąądná’ iłk’ídaizné’go bitsiłke’yu yitaizṉiih gáṉíígo, Díí shits’í át’éé, nohwaa hi’né’hi: díí be’ánádaałt’įįł, bee shínádaadołṉíhgo. ");
INSERT INTO apwNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Da’áík’ehgo ałdó’ da’ch’iyááníí bikédé’go idee beda’iskaaníí náidnkąągo gáṉíí, Díí idee besikanihíí shidił nohwá idijoołíí bee áníidégo Bik’ehgo’ihi’ṉań ła’íí nṉee biłgo łángont’aahi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ła’ ch’íshí’aahíí kú bił ishąą, biká’da’adáné yiká’ dahdésṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Shíí, nṉee k’ehgo Niyááhíí, dá shá ngolchííníí shegodolṉiił: áíná’ ch’íshí’aahíí bá góyéé doleeł! ");
INSERT INTO apwNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bitsiłke’yu nałídaadiłkidgo nkegonyaa, gádaałiłdi’ṉiigo, Hadń nohwitahyú nlíni ágáṉe’? ");
INSERT INTO apwNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Łada’dit’áh nkegonyaa, Nohwitahyú hadń itisgo at’éhi baa ch’iṉii doo? daałiłdi’ṉii lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus gádaabiłṉii, Doo Jews daanlįį dahíí ízisgo binadaant’a’íí isná ádaayiłsįgo yá nadaant’aah; ła’íí nṉee yánadaant’aahíí ich’odaaṉíhi daaholzee. ");
INSERT INTO apwNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Áí k’ehgo doo ádaanołt’ee da: nohwitahyú ła’ itisgo at’ééhíí dá’iké’yú naghaahíí ga’at’éé le’; itisgo nandeehíí kánada’iziidíí ga’at’éé le’. ");
INSERT INTO apwNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hayííhíí itisgo at’ééhíí, biká’da’adáné yich’į’ dahsdáhihíí née, ya’ bána’iziidhíí née? Biká’da’adáné yich’į’ dahsdáhihíí go’į́į́. Áíná’ shihíí nohwá na’iziidhíí k’ehgo nohwitah nshłįį. ");
INSERT INTO apwNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Góyéégo shich’į’ nagowaa ndi nohwíí da’akú shił daanołįį ni’: ");
INSERT INTO apwNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Beshik’eh doleełíí shiTaa shaa gon’ááníí k’ehgo, benohwik’eh doleełíí nohwaa dinsh’aah; ");
INSERT INTO apwNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nansht’aayú ná’ishdįįhíí nohwił da’ashąą doleeł, ła’íí nant’án dahsdaagee dahnadaasółtąą doleeł, Israel nakits’ádah hat’i’íí bá nadaanołt’aah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, ch’iidn nant’án, Satan holzéhi, nánohwidiṉiił hat’į́į́, tł’oh nagháí ch’iłch’íhíí k’ehgo ádaanohwidoliiłgo: ");
INSERT INTO apwNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Áíná’ ni ná osékąąd ni’, ni’odlą’íí doo bee yó’ogoṉáhgo da: shich’į’ nnándzaago nik’isyú nłdzilgo ánádaandle’. ");
INSERT INTO apwNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peter Jesus gáyiłṉii, SheBik’ehń, nił ha’ánshteeshgo, nił shidizideego ndi ałk’iná’ naa ádinsht’ąą. ");
INSERT INTO apwNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus gánábiłdo’ṉiid, Peter, tazhik’áné doo hwahá ádí’ṉiih daná’ taadn, Áń doo bígonsį da, shiłdińṉiił, niłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesus gádaabiłṉii, Nohwibestso bizis ła’íí izis bena’iltiníí ła’íí nohwikee ik’e’anhíí da’ádįhgo odaanohwił’a’ná’, ya’ dahat’íhíta bídaanołdįh lá née? Doo hat’íí da, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Áígé’ Jesus gádaabiłṉii, K’adíí hadń bibestso bizis ła’íí izis bena’iltiníí gólííníí daidoné’: hadń bibéshbe’idiltłishé da’ádiníí bi’íícho baa nahóṉiihgo ła’ nayółṉííh. ");
INSERT INTO apwNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Díí bek’e’eshchiiníí dá be’áshi’dilṉe’ goz’ąą, nohwiłdishṉii, Begoz’aaníí doo yikísk’eh ádaat’ee dazhį’ bił da’ch’ółtag lę́’e: hat’íí baa shak’e’eshchiiníí dawa begolṉe’go goz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bitsiłke’yu gádaabiłṉii, NohweBik’ehń, díń’įį, kúnko bésh be’idiltłishé naki silaa. Jesus gáṉíí, Dá’ąął. ");
INSERT INTO apwNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Da’ch’iyą́ą́gé’ ch’ínyáágo dził, Olives holzéhi, si’ąąyú onadáhíí k’ehgo ákú onádzaa; bitsiłke’yu biké’ onákai. ");
INSERT INTO apwNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Akú ńyááyú gádaabiłṉii, Nakída’dintaahíí bídaanołdzil doleełhíí bighą da’ołkąąh. ");
INSERT INTO apwNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tséé bee its’idesṉe’i hayú naltǫ’ shįhíí dábik’ehyú yich’ą́’ ńyááyú hilzhiizhgo okąąh gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ShiTaa, ni háńt’įįyú ánágot’įįłyúgo, díí hishdląą doleełíí shich’ą́’zhį’ ánle’: áíná’ shíí doo beshik’eh da, ni zhą́ benik’eh. ");
INSERT INTO apwNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yaaká’gé’ Bik’ehgo’ihi’ṉań binal’a’á bił ch’í’ṉah adzaago, nłdzilgo ánábiidlaa. ");
INSERT INTO apwNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Dázhǫ́ biniigodelzaago dázhǫ́ nłdzilgo okąąh lę́’e: áík’ehgo bidiłíí biká’zhį’ dasta’go ni’yú nahikaad. ");
INSERT INTO apwNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Okąąhgé’ nádiidzaago bitsiłke’yu, doo bił daagozhǫ́ǫ́ dahíí yik’e da’iłhoshgo, yaa nyáágo, ");
INSERT INTO apwNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Gádaayiłṉii, Hat’íí bighą da’ołhosh? Nádołkáhgo, nakída’dintaahíí bídaanołdzil doleełhíí bighą da’ołkąąh. ");
INSERT INTO apwNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus t’ah yałti’ná’ nṉee baa náńłsą́ą́ lę́’e, nṉee Judas holzéhi, nakits’ádahíí bił itah nlínihi, bádn higaałgo, Jesus yit’ahzhį’ nyáágo yizts’ǫs lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesus gábiłṉii, Ya’ shíí, nṉee k’ehgo Niyááhíí, shizaa nínt’ąągo ch’íshíń’aah née? ");
INSERT INTO apwNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesus yit’ahzhį’ naziiníí hago ágoṉe’ shįhíí bił ídaagozįgo gádaaṉii, NohweBik’ehń, ya’ bésh be’idiltłishé bee da’ntłish née? ");
INSERT INTO apwNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Okąąh yebik’ehi da’tiséyú sitíni binal’a’áhi ła’ yóńtłizhgo dihe’nazhiṉéégo bijaa naidnłgizh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesus, Dákozhį’ áshłe’, daabiłṉii lę́’e. Áń bijaa’íí yedelṉiigo náyilzii. ");
INSERT INTO apwNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Áígé’ Jesus okąąh yebik’ehi itisyú nadaandeehíí, ła’íí silááda yánadaant’aahíí, ła’íí nṉee yánaziiníí nádaabidiłteehgo baa hikaihíí gádaayiłṉii, Ya’ bésh be’idiltłishé ła’íí tsį be’idiltłishé dahdaanołṉiiłgo nánołsąą née, in’įįhíí daach’iłtsoodhíí k’ehgo? ");
INSERT INTO apwNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Dawa jįį da’ch’okąąh goz’ąą yuṉe’ nohwitah nashaa ni’, ndi doo hago ádaashołe’ da ni’: k’adíí bee nohwik’eh, godiłhiłíí bee nohwinawod gozlįį. ");
INSERT INTO apwNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Áígé’ daayiłtsoodgo onádaizt’e’go okąąh yebik’ehi da’tiséyú sitíni bikįhyú yił hikai. Peter da’aṉahgé’ iké’ higaał. ");
INSERT INTO apwNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Okąąh yebik’ehi da’tiséyú sitíni bikįh biṉaa łé’ditł’įįh yuṉe’ iłṉí’gee dedaach’idishjeego ch’ídinezbįh, Peter ákú itah nezdaa. ");
INSERT INTO apwNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Isdzán na’iziidíí Peter kǫ’zhį’ nezdaago yiłtsąą, yineł’į́į́go gáṉíí, Díń nṉeehń Jesus yił na’aash ni’. ");
INSERT INTO apwNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Áíná’ Peter isdzánhíí gáyiłṉii, Dah, áń doo bígonsį da. ");
INSERT INTO apwNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Áígé’ dét’įhé hik’e ła’ nṉee biiłtsąągo gánábiłdo’ṉiid, Ni ałdó’ áí itah ńlį́į́. Áíná’ Peter nṉeehíí gáyiłṉii, Doo áí itah nshłįį da. ");
INSERT INTO apwNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Dała’á łenádihikeez hak’e ła’ihíí gánábiłdo’ṉiid, Da’aṉiigo díń nṉeehń Jesus yił nlįį ni’; Gálileegé’ nṉeehi nlįį. ");
INSERT INTO apwNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Áíná’ Peter nṉeehíí gánáyiłdo’ṉiid, Shíí hat’íí nṉiigo ánṉii shįhíí doo bígonsį da. T’ah yałti’go tazhik’áné ánṉiid. ");
INSERT INTO apwNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Áík’ehgo Jesus Peter yich’į’ nánesṉe’go yineł’į́įd. Peter Jesus, Tazhik’áné doo hwahá ádí’ṉiih daná’ taadn, Doo bígonsį da, shiłdinṉiił, biłṉii n’íí yénálṉiih. ");
INSERT INTO apwNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Áígé’ ch’ínyáágo dázhǫ́ doo bił gozhǫ́ǫ́ dago hichag lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nṉee Jesus yiṉádaadéz’iinihíí baa daadloh ła’íí ńdaabinłhaał lę́’e; ");
INSERT INTO apwNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ła’íí biṉáá nada’ist’i’go biniiyú nádainłts’į́ná’ nayídaadiłkid gádaaṉiigo, Bik’ehgo’ihi’ṉań binkááyú yáńłti’yúgo, hadń ńnínłts’į shįhíí nohwił nagólṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dayúweh nchǫ’go yich’į’ yádaałti’go daayoch’íid lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hayiłką́ą́yú nṉee báyáníí, okąąh yebik’ehi itisyú nadaandeehíí, ła’íí begoz’aaníí ye’ik’eda’iłchíhi dała’adzaagé’ yánádaaltihíí bich’į’yú Jesus odaist’e’ná’ gádaabiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ni Christ ńlį́į́ née? nohwił nagólṉi’, Áíná’ Jesus gádaabiłṉii, Shíí nohwił nadaagoshṉi’yúgo doo daashołdląą da doleeł go’į́į́: ");
INSERT INTO apwNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ła’íí shíí nanohwídaadishkidyúgo doo shich’į’ hanádaadołdziih da, doo ch’ínádaashidoł’aa da go’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kogé’ godezt’i’go Bik’ehgo’ihi’ṉań binawodi dihe’nazhiṉéégo shíí nṉee k’ehgo Niyááhíí dahnshdaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dawa gádaabiłṉii, Ya’ Bik’ehgo’ihi’ṉań biye’ ńlį́į́ née? Áík’ehgo gádaayiłṉii, Da’áígee ádaashiłdołṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hat’ííshą’ bighą ła’ nṉee baa yánánálti’ doleeł? Ałk’iná’ dabíí bizé’ yee ánṉiidhíí daadesiits’ąą, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nṉee dała’adzaahíí dawa nádiikaigo Pílate bich’į’yú Jesus yił onałsą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Áígé’ baa dahdaago’aa nkegonyaa, gádaaṉiigo, Díń nṉeehń dénchǫ’égo iłch’ígó’aahgo nṉee ch’a’oyihiłkaad, Caesar doo bich’į’ nadaahołṉiił da, nohwiłṉii ła’íí, Shíí Christ, ízisgo nant’án nshłįį, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pílate Jesus nayídiłkid gáyiłṉiigo, Ya’ ni Jews ízisgo binant’a’i ńlį́į́ née? Da’áígee ánṉii, biłṉii, Jesus. ");
INSERT INTO apwNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pílate okąąh yebik’ehi itisyú nadaandeehíí, ła’íí nṉee dała’at’ééhíí yich’į’ hadziigo gáṉíí, Díń nṉeehń doo nagontł’og ye’at’éé dago bígosíłsįįd. ");
INSERT INTO apwNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ndi dayúweh gádaaṉii, Gálileegé’ iłch’ígó’aah godeyaa lę́’e, Jews daagolį́į́gee nṉee dahot’éhé yił daagoshkish, áígé’ kú bengonyaa. ");
INSERT INTO apwNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pílate díí yidezts’ąąná’ na’ódiłkid gáṉíígo, Ya’ díń nṉeehń Gálileegé’ nagháhi née? ");
INSERT INTO apwNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hérod yánant’a’íí yiyi’ naghaa lą́go yígołsįįd, áígé’ Hérod bich’į’ obidol’aad, Hérod k’adíí Jerúsalemyú naghaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hérod Jesus yiłtsąąná’ dázhǫ́ yaa bił gozhǫ́ǫ́: łą́ą́go baat’ínzįhíí bighą doo áníiná’ yiłtséh hát’į́į́ da lę́’e; godiyįhgo áná’ol’įįłíí ła’ hostséh nzįgo. ");
INSERT INTO apwNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Áík’ehgo na’ódiłkidgo ńzaad godeyáá ndi Jesus doo hat’íí biłṉii da. ");
INSERT INTO apwNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Okąąh yebik’ehi itisyú nadaandeehíí ła’íí begoz’aaníí ye’ik’eda’iłchíhi bit’ah nazįį, baa dahdaagoz’aaníí yee nawode ádaaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hérod ła’íí bisiláádahíí Jesus yaa daadlohgo yedaańdit’įįh lę́’e, áígé’ dázhǫ́ nłt’éégo yik’e da’ilaago Pílate bich’į’yú onádais’a’. ");
INSERT INTO apwNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hérod ła’íí Pílate díí dabí’iłtséná’ dázhǫ́ doo iłch’į’ at’éé da n’íí, áníita áí bijįį iłt’eké silįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pílate okąąh yebik’ehi itisyú nadaandeehíí ła’íí nadaant’aahíí ła’íí nṉee dała’áyíílaago, ");
INSERT INTO apwNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Gáyiłṉii, Díń nṉeehń nṉee ch’a’oyihiłkaad daadołṉiigo shaa bił nołkaihń nohwiṉááł nahódéłkid ndi baa yádaałti’ihíí doo da’aṉii dago bi’at’e’ nłt’éégo bígosíłsįįd: ");
INSERT INTO apwNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hérod bich’į’yú odaanohwił’a’ ni’; áíná’ Hérod díí k’ehgo bígołsįįd: doo hat’íí yighą zidee bik’eh da, doo hago ánát’įįł da. ");
INSERT INTO apwNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Áík’ehgo habí’iłtsaasgé’ ch’ínánshteeh. ");
INSERT INTO apwNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Da’adąągee kogo goz’ąą lę́’e, nṉee ła’ ha’ásitíni bich’į’ ch’ínálteeh.) ");
INSERT INTO apwNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nṉee dáła’ nádidilghaazhgo, Áí nṉeehń yúwehyú, Barábbas nohwá ch’ínáńłteeh, daaṉii lę́’e: ");
INSERT INTO apwNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Nṉee Barábbas holzéhi kįh gozṉilíí biyi’ nant’án agohet’aa nkegonyaa, ła’íí nṉee nastseedhíí bighą ha’ábi’dolt’e’.) ");
INSERT INTO apwNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nṉee dała’adzaahíí Pílate bich’į’ hananádzii, Jesus ch’ínáyíłteeh hat’į́į́go. ");
INSERT INTO apwNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Áíná’ nṉee dawa daadilwoshgo gádaaṉii, Tsį’iłna’áhi bíhołkałgo zodéé, tsį’iłna’áhi bíhołkałgo zodéé. ");
INSERT INTO apwNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Taadngee Pílate gánádo’ṉiid, Hat’íí bighą, hat’íí bee nchǫ’go adzaago? Shíí díń nṉeehń doo hat’íí yighą datsaah dago bígosíłsįįd: áík’ehgo habí’iłtsaasgé’ ch’ínánshteeh. ");
INSERT INTO apwNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Áíná’ nṉee dała’at’ééhíí nawode daadilwoshgo gádaaṉii, An tsį’iłna’áhi bíhołkałgo datsaah dábik’eh: daadilwoshíí bee nṉee dała’at’ééhíí ła’íí okąąh yebik’ehi itisyú nadaandeehíí itis okai. ");
INSERT INTO apwNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Áík’ehgo Pílate nṉee dahádaat’iiníí begolṉe’go ngon’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nṉee nant’án agohet’aa nkegonyaa n’íí, nṉee nastseedhíí bighą ha’ábi’dolt’e’ihíí ch’ínáínłtį́į́, nṉee nádaabokeedhíí bighą: áígé’ Jesus nṉeehíí dahádaat’įįyú ádaabile’go yaa yidin’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Silááda Jesus yił dahnasą́ą́yú ła’ nṉee Simon holzéhi, Cyrénegé’ gólíni, k’edolzaagé’ nadáłi yiká ádaanṉiidgo tsį’iłna’áhi yiká’ dahdaistąą, áń Jesus biṉe’gé’ yá yogheełgo higaał. ");
INSERT INTO apwNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nṉee dázhǫ́ łą́ą́go biké’ nałseeł, isdzáné ałdó’ Jesus yaa chał daadilwosh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus bich’į’ adzaago gádaabiłṉii, Isdzáné Jerúsalemgee daagonołíni, doo shíí shaa daałchag da, dánohwíí ła’íí nohwichągháshé baa daałchag. ");
INSERT INTO apwNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Isdzáné doo da’iłchii dahíí, bibishch’id biyi’ doo mé’ daagoleeh dahíí, doo daabi’dilbe’ dahíí biyaa daagozhǫ́ǫ́ doleeł, daach’ididooṉiiłíí dahadíí bijįį biká’ ngowáh. ");
INSERT INTO apwNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ła’íí gádaaṉii doleeł, Dził nchaa’i, nohwiká’zhį’ nahigeeh le’; ch’ínálk’idíí, nohwik’i goziid le’. ");
INSERT INTO apwNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ch’il daadotł’izhná’ díí ye’ádaadzaayúgo, náhisgąyúgohíí hago ágoṉe’? ");
INSERT INTO apwNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ła’ nṉee naki nchǫ’go ádaadzaahíí biłgo kił onazą́ą́ lę́’e, nadaaki’ditseedyú. ");
INSERT INTO apwNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Akú Cálvary golzeeyú kił náńzą́ą́yú tsį’iłna’áhi bídaahaskał, nṉee nchǫ’go ádaadzaahíí ałdó’, Jesus ba’ashhahgé’ dá’ał’an, ła’ dihe’nazhiṉéégo, ła’íí be’eshganzhiṉéégo. ");
INSERT INTO apwNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesus gáṉíí, ShiTaa, díí nchǫ’go ádaat’įįhíí bighą baa nádaagodíń’aah; doo yídaagołsį dago ádaat’įį. Áígé’ bidiyágéhíí iłta’isṉiigo yighą da’diljoł. ");
INSERT INTO apwNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nṉee bit’ahgé’ nazįįgo daabineł’į́į́. Nant’án daanliiníí ałdó’ Jesus yaa yádaałti’go yaa daadloh gádaaṉiigo, Ła’ nṉee hasdádaayiṉiiłná’ bíí ałdó’ hasdá’ádólteeh le’at’éhi, bíí Christ, Bik’ehgo’ihi’ṉań habiłtiiníí nlįįyúgo. ");
INSERT INTO apwNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Silááda ałdó’ bedaanít’įįhgo nk’ǫ́zhi, vinegar holzéhi, bich’į’ dahyída’ołtsi lę́’e, ");
INSERT INTO apwNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Gádaabiłṉiigo, Ni Jews ízisgo biNant’a’i ńlį́į́yúgo, dáni hasdá’áńlteeh. ");
INSERT INTO apwNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesus bik’ehgee Greek, Latin, ła’íí Hebrew k’ehgo k’e’eshchįį lę́’e, gágolzeego, DÍÍ JEWS ÍZISGO BINANT’A’I NLĮĮ. ");
INSERT INTO apwNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nṉee nchǫ’go ádaadzaahíí, áígee tsį’iłna’áhi yídaayiskałíí dała’á beńdít’įįhgo gábiłṉii, Christ ńlį́į́ lę́’eyúgo hasdánohwiléh, ła’íí ni ałdó’ hasdá’áńlteeh. ");
INSERT INTO apwNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Áíná’ ła’ihíí áí áṉííhíí gáyiłṉii, Ya’ doo Bik’ehgo’ihi’ṉań béńldzid da, ni ałdó’ dákoh niniigonłt’éé, dáłełt’eego nohwá ngot’ą́ą́? ");
INSERT INTO apwNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nohwíí da’ánohwidilṉe’ dábik’ehyú ánohwi’delzaa: áíná’ díń nṉeehń doo nagontł’og ye’at’éhi da. ");
INSERT INTO apwNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Áígé’ Jesus gáyiłṉii, SheBik’ehń, nant’ááyú ńyaago shénálṉiih doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus gábiłṉii, Shíí da’aṉiigo gániłdishṉii, Díí jįį dázhǫ́ gózhǫ́ǫ́ goz’ąąyú shił ńlį́į́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Dáha’iz’ąągé’ taagi nehenkéézgo dahot’éhé godiłhił gozlįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ch’ígona’áí bich’ą́’idindííníí ásdįįd, kįh biyi’ da’ch’okąąhíí biyi’ yuṉe’ daadintsoozi iłk’edláád lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesus nádidilghaazhgo gáṉíí, ShiTaa, shiyi’siziiníí naa nshné’: díí yee ánṉiidná’ dá’iké’yú nádeyol. ");
INSERT INTO apwNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Silááda yánant’aahi díí ánágot’įįdíí yiłtsąąná’ Bik’ehgo’ihi’ṉań yich’į’ ahénzįgo gáṉíí, Da’aṉiigo díń nṉeehń nṉee nłt’éhi nlįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nṉee daadéz’įįgo łą́ą́go dała’adzaahíí dawa ánágot’įįłíí daayiłtsąągo bijííláhzhį’ nádainłts’įná’ onáskai. ");
INSERT INTO apwNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesus yídaagołsiníí dawa ła’íí isdzáné Gálileegé’ biké’ hikai n’íí aṉahgé’ nazįįgo díí ánágot’įįłíí daayiłtsąą lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ła’ nṉee Joseph holzéhi, nṉee yánádaaltihíí itah nlíni; nṉee nłt’éhi, dábik’ehyú át’éhi nlįį: ");
INSERT INTO apwNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(Nṉee yánádaaltihíí nadaagoshchįįgo ánáda’ol’įįdíí Joseph doo hwaa itah ánát’įįd da:) áń Jews daanlíni bikįh gozṉil Arimathéa golzeegé’ gólíni; Bik’ehgo’ihi’ṉań nant’aa doleełíí ya’ołíí lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Díń nṉeehń Pílate yich’į’ oyáá, Jesus bits’íhíí yíyókeedgo. ");
INSERT INTO apwNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tsį’iłna’áhi yiká’gé’ nanáidnłtįįgo nak’ą’łigaihi yik’íyidesdiz, áígé’ tsébii’i’áńgo ágolzaa yuṉe’ nyinłtį́į́ lę́’e, doo hwahá hadń ákóṉe’ nnilteehi da. ");
INSERT INTO apwNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jews daagonłsiníí bijįį bee nkegonyaago iłch’į’golṉe’íí bijįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Isdzáné Gálileegé’ Jesus yił hikaihíí tsébii’i’áńyú Joseph yiké’ hikaigo Jesus bits’íhíí hago’at’éégo nniłtįį shįhíí daayiłtsąą lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Onákaiyú łikągolchini ła’íí ik’ah yił iłch’į’daizlaa; áígé’ Jews daagodnłsiníí bijįį hádaayoł, dángot’ąą lę́’ehíí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Áí iskąą hik’e godilziníí bijįį dázhǫ́ t’ałbįgo tsébii’i’áńyú łikągolchini iłch’į’daizlaa n’íí odaizné’, ła’i ałdó’ yił hikai. ");
INSERT INTO apwNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tsébii’i’áńyú hikaigo tséé daadin’ą́ą́ n’íí yó’olyiz lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ákóṉe’ ha’ákaigé’ Jesus nohweBik’ehń bits’íhíí doo hwaa da lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hayúshą’ daanzįná’ nṉee naki bidiyágé dázhǫ́ bik’enadidlaadi bit’ahgé’ nazįį silįį: ");
INSERT INTO apwNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Isdzáné tsídaadolyizgo hayaa ádaadzaa nt’éégo nṉeehíí gádaabiłṉii, Hat’íí bighą hiṉáhi nanezna’íí bitahyú hádaadeł’į́į́? ");
INSERT INTO apwNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Áń doo hwaa da, naadiidzaa: t’ah Gálileeyú naghaaná’ gádaanohwiłṉii n’íí bénádaałṉiih shį, ");
INSERT INTO apwNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Shíí, nṉee k’ehgo Niyááhíí, nṉee binchǫ’ daagolííníí baa shich’ilteehgo tsį’iłna’áhi biká’ dastsaah, áíná’ taagi jįį hileehgo naadiishdáh. ");
INSERT INTO apwNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Áík’ehgo áí áṉíí n’íí yénádaalṉiih. ");
INSERT INTO apwNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tsébii’i’áńgé’ nákaiyú łats’ádahíí ła’íí ła’ Jesus biké’ hikahíí ałdó’ bił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mary Mágdalene, Jóanna, ła’íí Mary, James bimaa, ła’ isdzáné biłgo nadaal’a’á díí yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ndi daazhógo ádaaṉii daanzįgo doo daayodląą da. ");
INSERT INTO apwNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Áíná’ Peter nádiidzaago tsébii’i’áńyú nádilwod; hayaa adzaago ákóṉe’ déz’įįd, nak’ą’łigai n’íí daazhógo siṉilgo yiłtsąą, áík’ehgo t’ąązhį’ gowąyú onádzaa, hagoshą’ ágodzaa nzįgo. ");
INSERT INTO apwNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Da’áí bijįį ła’ naki dilt’eego Jerúsalemhíí da’dáńyú gosts’idi dahgostǫ’yúshįgotah, Emmáus golzeeyú dezh’aazh. ");
INSERT INTO apwNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Díí ánágot’įįłíí dawa yaa łił nagolṉi’go goldoh. ");
INSERT INTO apwNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","T’ah yádaałti’go łił nagolṉi’ nt’éégo Jesus bit’ah nyáágo bił dahiskai. ");
INSERT INTO apwNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Áíná’ daineł’į́į́ ndi hadń át’ííníí doo bídaagołsįįd da alzaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesus gádaabiłṉii, Hat’íílá baa łił nagołṉi’ goldoh, doo nohwił daagozhǫ́ǫ́ dago? ");
INSERT INTO apwNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Dała’á, Cléopas holzéhihíí, gábiłṉii, Ya’ dáni zhą́ Jerúsalemyú asta’ńyáhi, áníi áígee ánágot’įįłíí doo bígonłsį́ da née? ");
INSERT INTO apwNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Hago ágolzaahi áłdołṉii? ṉii, Jesus. Áík’ehgo gánádaabiłdo’ṉiid, Jesus, Názarethgé’ nlínihi, Bik’ehgo’ihi’ṉań binkááyú na’iziidi, dázhǫ́ ízisgo áná’ol’įįłi, biyati’ nłdzili, Bik’ehgo’ihi’ṉań ła’íí nṉee dawa biṉááłihi áłn’ṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Áń dánohwíí nohwi’okąąh yebik’ehi itisyú nadaandeehíí ła’íí nohwá nadaant’aahíí bángot’aahgo bidizideego ndaistįį, áígé’ tsį’iłna’áhi yiká’ daizes‐hįį: ");
INSERT INTO apwNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Áíná’ nohwíí Israel hadaasiit’i’íí hasdánohwiṉiił lą́ą́ daandzį: n’íí díí ánágot’įįł n’íí yúshdé’ taagi jįį silįį. ");
INSERT INTO apwNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nohwitahgé’ ła’ isdzáné nohwił díyadaagot’eego ádaanohwizlaa, áń dázhǫ́ t’ałbįná’ tsébii’i’áńyú okai lą́ą́; ");
INSERT INTO apwNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ndi Jesus bits’íhíí ákú doo hwaa da lą́ą́go, t’ąązhį’ nakai gádaaṉiigo, Bik’ehgo’ihi’ṉań binadaal’a’á yaaká’gé’hi nohwich’į’ ch’í’ṉah ádaadzaago gádaanohwiłṉii, Jesus hiṉaa. ");
INSERT INTO apwNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ła’ bił nahikaihíí tsébii’i’áńyú okai, isdzáné da’ádaaṉii n’íí k’ehgo yaa hikai: ndi Jesus doo hwaa daayiłtsąą da. ");
INSERT INTO apwNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Áígé’ Jesus gádaabiłṉii, Nohwíí nṉee doo daagoyáni daanołínihi, Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí nadaagosṉi’íí doo dáhah daahołdląąh da: ");
INSERT INTO apwNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Christ áík’ehgo biniigodilṉe’go áígé’ yee ízisgo at’ééhíí baa godidot’aałgo dábik’eh lą́ą́ née? ");
INSERT INTO apwNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mosesgé’ godezt’i’go Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí ádaaṉiihíí dawa, ła’íí Bik’ehgo’ihi’ṉań biyati’ bek’eda’ashchiiníí dahot’éhé dabíí baa k’e’eshchiiníí hat’íí golzeego ágolzeehíí yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Gotah dezh’aazh n’ííyú dák’ad nikáh: Jesus bádn dayúweh dahiyaa nt’éégo, ");
INSERT INTO apwNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nił nahátąą le’, daabiłṉiigo nádaabokąąh; ałk’iná’ o’i’ą́ą́, k’ad tł’é’ goleeh, daabiłṉii. Áík’ehgo yił ha’ákaiyú yił naháztąą. ");
INSERT INTO apwNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Da’iyąągo bił dinezbįhgo báń náidn’ąągo ya’ahénzįgo oskąądná’ iłk’íyíné’go baa daizné’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Áníita áígee hadń át’į́į́ shįhíí nzhogo daayiłtsąą; nt’éégo Jesus dádaineł’į́į́zhį’ yitł’ąą tsídaazghal. ");
INSERT INTO apwNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gádaałiłdi’ṉii, Nohwijíí dázhǫ́ diltłi’ ngonolįgo at’éé, itínyú nohwich’į’ yałti’ná’, áń Bik’ehgo’ihi’ṉań biyati’ bek’eda’ashchiiníí hat’íí ṉiigo aṉííhíí baa nohwił nagolṉi’ná’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Áígé’ dagoshch’į’ nádiit’aazhgo Jerúsalemyú onát’aazh, ákú łats’ádahíí ła’íí nṉee ła’ ishhah dała’ádaat’eego baa n’áázh, ");
INSERT INTO apwNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nt’éégo gádaabiłṉii, NohweBik’ehń da’aṉii naadiidzaa lą́, Simon bich’į’ ch’í’ṉah ádilzaa ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nṉee áníi n’áázhíí itínyú hago ágodzaahíí, ła’íí hago at’éégo Jesus báń iłk’íyíné’gee yínádaagosdzįįdíí yaa nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Gádaaṉiiná’ Jesus dabíí áí bitah sizįį silįįgo gádaayiłṉii, Iłch’į’gont’ééhíí bee nohwich’į’ goz’ąą le’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ndi bił díyadaagodzaago tsídaadesyiz, ch’iidn daahiiltsąą daanzįgo. ");
INSERT INTO apwNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesus gádaabiłṉii, Hat’íí bighą tsídaadołyiz? Hat’íí bighą na’ódikidíí nohwiini’ biyi’ begoz’ąą? ");
INSERT INTO apwNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Shigan ła’íí shikee daanéł’į́į́, da’aṉii shíí ásht’į́į́: shídaadołṉih, áík’ehgo bídaagonołsįįh; ch’iidn bits’í ła’íí bits’in doo golį́į́ da go’į́į́, daał’įį go’į́į́ nkoh, shíí shits’í ła’íí shits’in golį́į́. ");
INSERT INTO apwNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ánṉiidná’ bigan ła’íí bikee yił ch’í’ṉah áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dázhǫ́ bił daagozhǫ́ǫ́ ła’íí bił díyadaagot’ee ndi t’ah doo da’odląą daná’ Jesus gádaabiłṉii, Dahat’íhíta hidąąhíí ła’ daasołné’ née? ");
INSERT INTO apwNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Łóg sit’éédhíí ła’íí gosnih yaa daizné’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Náidnné’go biṉááł yíyą́ą́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Áígé’ gádaayiłṉii, T’ah nohwił nshłįįná’ díí bee nohwił nadaagosisṉi’ go’į́į́, Moses ngon’ą́ą́ lę́’ehi shaa k’e’eshchiiníí, ła’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí k’eda’ashchiiníí, psalms holzéhi ndi, biyi’ dábegolṉe’ goz’ąą, daanohwiłdishṉii ni’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Áígé’ Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí hat’íí ṉiigo aṉíí shįhíí bił ídaagozįgo ádaabizlaago, ");
INSERT INTO apwNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Gádaabiłṉii, Shíí Christ nshłíni, shiniigodilṉe’go taagi jįį hileehgo naadiishdáh golzeego shak’e’ashchįį, áík’ehgo dábik’ehyú ágodzaa: ");
INSERT INTO apwNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ła’íí Jerúsalemgé’ godezt’i’go shizhi’íí bee yá’iti’ nṉee dahot’éhé hadaazt’i’íí bitahyú, bidaanchǫ’íí yich’ą́’zhį’ ádaaṉe’go binchǫ’híí bighą baa nádaagodit’aah golzeego. ");
INSERT INTO apwNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Díí daał’įį go’į́į́ ákoh baa nadaagołṉi’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ShiTaa nohwaa yiné’go ngon’ááníí nohwaa dishné’: Jerúsalem yuṉe’ nahísółtąą, yaaká’gé’ nawodíí bee nohwaa ngonyáázhį’. ");
INSERT INTO apwNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Áígé’ Jesus Jerúsalemgé’ binadaal’a’á yił ch’ékai, Béthanyzhį’, yádn ninyáágo, áígee hadag yaa dilṉiigo yá da’oskąąd, Nohwiyaa gozhǫ́ǫ́ doleeł, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yá da’oskąądná’ yich’ą́’ yaaká’yú hadag be’ogoyáá. ");
INSERT INTO apwNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Binadaal’a’á daaboskąądgé’ Jerúsalemyú onákai, dázhǫ́ bił daagozhǫ́ǫ́go: ");
INSERT INTO apwNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bik’ehgo’ihi’ṉań bich’į’ ahédaanzįgo da’ch’okąąh goz’ąą yuṉe’ dáda’okąąh nt’éé lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dantsé godeyaadá’ Yati’ golį́į́ lę́k’e, Yati’ Bik’ehgo’ihi’ṉań yił nlįį, Yati’íí Bik’ehgo’ihi’ṉań nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yati’íí dantsé godeyaadá’ Bik’ehgo’ihi’ṉań yił nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Áń dawahá áyíílaa; áń doo hak’i dayúgo dawahá álzaahíí doo álzaa le’at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ihi’ṉaahíí biyi’ golį́į́; áí ihi’ṉaahíí nṉee yee daago’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Got’iiníí godiłhiłyú idindláád; godiłhiłíí got’iiníí doo yitis nlįį da. ");
INSERT INTO apwNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bik’ehgo’ihi’ṉań nṉee John holzéhi yides’a’. ");
INSERT INTO apwNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Áń Begot’ínihíí nṉee yił nagolṉi’go nyáá, bíí bee nṉee dawa da’odląą doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","John doo Begot’iiníí nlįį da, áídá’ Begot’iiníí yaa nagolṉi’go nyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Da’aṉii Begot’ínihíí nṉee ni’gosdzáń biká’ daagolííníí dawa bee daayo’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Áń ni’gosdzáń nṉeehíí yitah silįį, áń ni’gosdzáń áyíílaa, ndi ni’gosdzáń biká’ nṉeehíí doo bídaagołsį da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Dabíí áyíílaahíí yaa nyáá, áídá’ dabíí hat’i’ihíí doo hádaabit’įį da. ");
INSERT INTO apwNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Áídá’ hadíí hádaabit’iiníí, daabosdląądíí, Bik’ehgo’ihi’ṉań bichągháshé daaleehgo yaa goden’ą́ą́: ");
INSERT INTO apwNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Áí nádaagosdliiníí doo nṉee hadaazt’i’íí bee da, doo kots’íhíí bee da, doo nṉee bits’ą́’dí’go da, áídá’ Bik’ehgo’ihi’ṉań bits’ą́’dí’ nádaagosdlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yati’íí nṉee silįįgo nohwitahyú gólį́į́ lę́k’e, dawahá ye’at’éhihi biłgoch’oba’íí ła’íí da’aṉii ágot’éhi nlįį, (Bik’ehgo’ihi’ṉań biYe’ dała’áhi nlįįhíí bighą ízisgo at’éégo bits’ą́’idindláád, áí bits’ą́’idindláádíí daahihiiltsąą ni’.) ");
INSERT INTO apwNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John baa nagolṉi’go nádidilghaazh lę́k’e gáṉíígo, Díń áłdishṉii ni’, ágádéṉiid n’dá’, Shiké’dí’ hígháhíí dashíntsé golį́į́híí bighą shitisgo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Dawahá yegoyiłííníí nohwaa hi’né’, biłgoch’oba’íí dałiké’go nohwaa hi’ṉiił. ");
INSERT INTO apwNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bik’ehgo’ihi’ṉań yegos’aaníí Moses biláhyú ngot’ąą lę́k’e, áídá’ biłgoch’oba’íí hik’e da’aṉii ágot’éhi Jesus Christ yił nyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Doo hadíń Bik’ehgo’ihi’ṉań yo’įį da; biYe’ dała’áhi Bik’ehgo’ihi’ṉań ádíbóltą’ihi, áń zhą́ ch’í’ṉah áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerúsalem golzeedí’ okąąh yedaabik’ehi hik’e Lévites daanlínihi Jews daanlíni odaabis’a’, Hadíń lą́ą́ áńt’ee? daabiłṉiigo nabídaadiłkidá’ John gáṉíí lę́k’e, ");
INSERT INTO apwNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Shíí doo Christ ánsht’ee da, doo nayił’į’go da da’aṉiigo ádaa nagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Áídí’ nayínádaadiłkid, Hadíń ánt’éé gá? Elías ńlį́į́ née? Dah, doo áń nshłįį da, ṉii lę́k’e. Bik’ehgo’ihi’ṉań binkááyú na’iziidihíí, ya’ áí ńlį́į́ née? Dah, ṉiigo hadzii. ");
INSERT INTO apwNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Gánádaayiłdo’ṉiid, Áídá’ hadíń áńt’éé gá? Nohwił nagolṉí’go hadíń daanohwides’a’íí bił nadaagohiilṉi’. Hant’é nṉiigo ádaa nagolṉí’? ");
INSERT INTO apwNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Áídí’ gáṉíí, NohweBik’ehń bádįhyú iłch’ígodezdǫhgo ádaahłe’, dishṉiigo shíí da’igolį́į́yú dilwoshi nshłįį, Esáias, Bik’ehgo’ihi’ṉań binkááyú nada’iziidi áṉíí n’íí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nṉee na’ídaadiłkidihíí Phárisees daanlíni daabinł’a’. ");
INSERT INTO apwNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nabídaadiłkidgo, Doo Christ ńlį́į́ dadá’, ła’íí doo Elías dagohíí Bik’ehgo’ihi’ṉań binkááyú na’iziidihíí ńlį́į́ dadá’, nt’é bighą baptize ánł’įį? daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John bich’į’ hadzii, Shihíí tú bee baptize ash’įį: áídá’ ła’ nohwitahyú sizįį, doo bídaagonołsį dahi; ");
INSERT INTO apwNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Da’áń shikédí’ hígháhíí shitisgo at’éhi, biketł’óól k’e’ish’adgo ndi doo bik’eh sítį́į́ da. ");
INSERT INTO apwNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Áí Bethábara golzeeyú Jórdan túńlííníí hanaayú ágodzaa, John baptize ágole’gee. ");
INSERT INTO apwNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Iskąą hik’e John Jesus bich’į’ higaałgo yo’įįgo gáṉíí, Daadeh’į́į́, dibełį́į́ biZhaazhé Bik’ehgo’ihi’ṉań bíyéhi áídí’ higaał! Áń ni’gosdzáń biká’ nṉee binchǫ’íí da’ílį́į́ yiłchiih. ");
INSERT INTO apwNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Díń áłdishṉii ni’ gádéṉiid n’dá’, Nṉee ła’ shikédí’ hígháh, áń dashíntsé gólį́į́híí bighą shitisgo at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Dashíí ndi doo bígonsį da ni’: áídá’ Israel hat’i’i bił ch’í’ṉah ágolṉe’híí bighą tú bee baptize ádaagoshłe’go niyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","John yaa nagolṉi’go gáṉíí, Holy Spirit yaaká’dí’ hawú k’ehgo Jesus yich’į’ nke’eṉíihgo biká’ dahnezdaago hish’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Shíí ndi doo bígonsį da ni’: áídá’ hadíń tú bee baptize ádaagoshłe’go shides’a’ń shich’į’ gánṉiid ni’, Hadíń Holy Spirit yaaká’dí’ bich’į’ nke’eṉíihgo biká’ dahnezdaago hí’ííníí, áń Holy Spirit bee baptize ádaagole’íí át’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Díí hiłtsąą hik’e baa nagosisṉi’, Díń da’aṉii Bik’ehgo’ihi’ṉań biYe’ ląą, dishṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Iskąą hik’e John bitsiłke’yu naki yił nadaazį’; ");
INSERT INTO apwNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesus higaałyú ndaineł’į́į́’go gánṉiid, Daadeh’į́į́, dibełį́į́ biZhaazhé, Bik’ehgo’ihi’ṉań bíyéhi! ");
INSERT INTO apwNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","John bitsiłke’yu nakihíí ágáṉíígo daabidezts’ąągo Jesus yiké’ dahizh’aazh. ");
INSERT INTO apwNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus t’ąązhį’ déz’įįgo biké’ hi’ashgo yiłtsąągo gáyiłṉii, Hant’é biká hanohtaago aht’į́į́? Áík’ehgo gádaaṉii, Rábbi, (Iłch’ígó’aahíí golzeego ágolzee,) hayú gonlį́į́? ");
INSERT INTO apwNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesus gádaabiłṉii, Yushdé’ ákú dokáhgo bígonołsįįh. Áík’ehgo yił okaigo hayú sidaahíí yídaagołsįįd, t’ahbįdí’ gonenádn łedihikęęzyú nákaigo, ákú dá yił naháztąą lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nṉee nakihíí John áṉííhíí daidezts’aaníí, Jesus yiké’ ó’áázhíí dała’á Andrew holzee, Simon Peter bik’isnhi. ");
INSERT INTO apwNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrewhíí ntsé bik’isn Simon holzéhi yaa nyáágo gáyiłṉii, Messías baa nt’áázh, áí Christ golzeego ágolzee. ");
INSERT INTO apwNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Áídí’ Simon Jesus yaa yił n’áázh. Jesus Simon yineł’į́į́ hik’e gáyiłṉii, Simon, Jona biye’ ńlíni, Céphas honlzéé doleeł, tséé golzeego ágolzee. ");
INSERT INTO apwNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Iskąą hik’e Jesus Gálileeyú deyaago, Philip yaa nyáágo, Shiké’ híṉááł, yiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Andrew ła’íí Peter Bethsáida golzeedí’ na’aash, ła’íí Philip ałdó’ áídí’ naghaa. ");
INSERT INTO apwNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip Nathánael yaa nyáágo gáyiłṉii, Jesus, Joseph biye’, Názarethdí’ gólíni baa nkai, Bik’ehgo’ihi’ṉań yegos’aaníí biyi’ Moses bak’e’eshchįį lę́k’ehi, Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí ałdó’ bak’eda’ashchįį lę́k’ehi. ");
INSERT INTO apwNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathánael gábiłṉii, Hant’é nzhooníí Názarethdí’ behagowáhshą’? Philip gánábiłdo’ṉiid, Ákú dot’aashgo bígonłsį́įh. ");
INSERT INTO apwNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesus Nathánael bich’į’ higaałgo yo’įįgo gáṉíí, Da’aṉii Israel hat’i’íí nlíni kudí’ higaał, doo k’izé’át’éhi da. ");
INSERT INTO apwNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathánael gábiłṉii, Hagot’éégo shígonłsį́? Jesus gábiłṉii, Philip doo hwahá niká áṉíí dadá’, fig ch’il bitł’ááhyú síńdaago nish’įį ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathánael gábiłṉii, Ni iłch’ígó’aahííńlíni, Bik’ehgo’ihi’ṉań biYe’ ńlį́į́ lą́ą́; Israel hat’i’ihi ízisgo biNant’a’ ńlį́į́ lą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus gábiłṉii, Fig ch’il bitł’ááhyú síńdaago nish’įį niłdishṉii n’íí bighą shondląą née? Díí bitisgo ágot’éhi hí’į́į́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesus gánábiłdo’ṉiid, Da’aṉii, da’aṉiigo gánohwiłdishṉii, Shíí, nṉee k’ehgo Niyááhíí, yáá iłts’ą́’álṉéhgo shik’ehdí’ Bik’ehgo’ihi’ṉań binal’a’á yaaká’yú daagolííníí hadagodí’ hayaago iłdenánádikahgo daah’įį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Taagi hileehíí bijįį Gálileehíí biyi’ Cána golzeegee ni’i’ṉéh; ákú Jesus bą́ą́hi itah lę́k’e: ");
INSERT INTO apwNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus ałdó’ bitsiłke’yu biłgo ni’i’ṉéhyú daabi’dokeed. ");
INSERT INTO apwNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dasts’aa bitoo ásdįįdá’ Jesus bą́ą́ gábiłṉii, Dasts’aa bitoo ásdįįd. ");
INSERT INTO apwNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus gábiłṉii, Shimaa, hago ląą ánishłéhgo ánṉii? Shágoz’aaníí doo hwahá bengowáh da. ");
INSERT INTO apwNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Bą́ą́ nada’iziidíí gáyiłṉii, Hant’é daanohwiłṉiiyú dakú ádaat’įį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Áígee tús tséé álzaahi gostáń siṉil, Jews daanlíni daagos’ąąhíí k’ehgo yee táda’digisíí bighą, túsíí dała’ágo nadin dagohíí tádin gallons dábik’eh lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus gádaabiłṉii, Túsíí tú bee hada’dołbį. Áík’ehgo dáhalk’iłgo hada’desbį. ");
INSERT INTO apwNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesus gánádaabiłdo’ṉiid, Ła’ hakaahgo bik’ehgo da’idaaníí bich’į’ dohkaah. Áík’ehgo odaiskąą. ");
INSERT INTO apwNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bik’ehgo da’idaaníí tú dasts’aa bitoo silįįhíí yizlįh, hadí’ hídziid shįhíí doo yígółsį dago, (nada’iziidíí tú hadaiziidíí zhą́ yídaagołsį ndihíí,) bik’ehgo da’idaaníí nṉee niiṉéhi yiká ánṉiidgo, ");
INSERT INTO apwNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Gáyiłṉii, Nṉee dawa da’idąą débegonyaago dasts’aa bitoo nzhónihíí ntsé yita’ikaah; áídí’ dahádaat’įįzhį’ da’odląądá’ doo nzhǫǫ dahíí yita’ikaah: áídá’ nihíí dasts’aa bitoo nzhónihíí áníita bitasíńkąą. ");
INSERT INTO apwNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Áí Jesus dantsé godiyįhgo adzaa, Gálilee biyi’, Cána golzeegee, áík’ehgo ízisgo ye’at’éhi bee bígozįįd; áídí’ bitsiłke’yu daabosdląąd lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Díí bikédí’go Capérnaum golzeeyú bíí hik’e bą́ą́, bik’isyú ła’íí bitsiłke’yu yił okai; akú da’akwii bedahiskąą. ");
INSERT INTO apwNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Bitis‐hagowáh n’íí bíná’godiṉíhgo Jews daanlíni da’iyąąhíí biká’ ngonyáágo Jesus Jerúsalemyú óyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Akú da’ch’okąąh goz’ąą yuṉe’ nṉee ła’ magashi, dibełį́į́, hawúcho baa nadaahiṉiihi, ła’íí zhaali iłkáh ch’ídaihiṉiiłíí binasdziid yaa naháztąągo yiká nnyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tł’óół iłkénásgisíí ił’áyíílaago dawa, dibełį́į́, magashita biłgo da’ch’okąąh goz’ąą biyi’dí’ ch’íinihiyood; ła’íí zhaali iłkáh ch’ídaihiṉiiłi bizhaalihíí yayinką́ą́, áídí’ zhaali yiká’ iłkáh ch’ínádaiṉiiłíí naz’aaníí nanyihesgo’. ");
INSERT INTO apwNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Áídí’ hawúcho baa nadaahiṉiihíí gáyiłnṉiid, Dííhíí ch’ídaahohṉiił; shiTaa bikįhíí kįh biyi’ na’iṉiihi ádaagołe’ hela’. ");
INSERT INTO apwNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nikįhíí dázhǫ́ godilziníí begoz’ąą doleełgo dázhǫ́ hásht’į́į́híí bighą shidizidee, golzeego bek’e’eshchiiníí bitsiłke’yu yínádaalṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Áídí’ Jews daanlíni gádaabiłṉii, Nt’é godiyįhgo be’ígóziníí nohwił ch’í’ṉah ánle’, díí ánánt’įįłhíí bighą? ");
INSERT INTO apwNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus gádaabiłṉii, Díí kįh biyi’ da’ch’okąąhíí ąął nanádaagołṉiiłgo, taagi jįį hileehgo ánágoshdle’. ");
INSERT INTO apwNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jews daanlíni gábiłṉii, Díí kįh biyi’ da’ch’okąąhíí ágolṉe’go dizdin gostáń łegodzaa, áídá’ nihííshą’ taagi jįį hileehgo ánágodle’? ");
INSERT INTO apwNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ndi bíí bits’íhi kįh biyi’ da’ch’okąąhíí k’ehgo yaa yałti’. ");
INSERT INTO apwNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jesus daztsąądí’ naadiidzaadá’ bitsiłke’yu nt’é ṉii n’íí yínádaalṉii; áík’ehgo Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí ła’íí Jesus áṉíí n’íí daayosdląąd lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jerúsalem golzeeyú bitis‐hagowáh n’íí bee bíná’godiṉíhgo da’idaaníí bijįį, Jesus akú itah nlįįgo nṉee łą́ą́go daabosdląąd, godiyįhgo áná’ol’įįłíí daayiłtsąądá’. ");
INSERT INTO apwNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Áídá’ Jesus nṉeehíí doo yada’ołíí da, nṉee dawa yígółsįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Doo hadíń nṉee ye’at’ééhíí baa bił nagolṉi’ bik’eh da; dabíí nṉee ye’at’ééhíí dawa yígółsįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nṉee Phárisees daanliiníí itah nlíni, Nicodémus níholzéhi, Jews binant’a’ nlíni lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Áń tł’é’yú Jesus yaa nyáágo gáyiłṉii, Ni, Iłch’ígó’aahíí ńlíni, doo hadíń godiyįhgo áná’ol’įįłíí áńł’įįhíí áyóléh át’éé da, Bik’ehgo’ihi’ṉań yił nlįįyúgo zhą́: áí bighą Bik’ehgo’ihi’ṉań bits’ą́’dí’ iłch’ígó’aahíí ńlį́į́go bídaagonlzį. ");
INSERT INTO apwNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus gábiłṉii, Da’aṉii, da’aṉiigo gániłdishṉii, Nṉee nágosdlįįyúgo zhą́ Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah nlįį doo. ");
INSERT INTO apwNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodémus gábiłṉii, Hagot’éégo nṉee nágodleeh, báyáń silįįdá’? Ya’ komaa bibishchid bih nách’idáhgo nágoch’idleeh née? ");
INSERT INTO apwNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus gáṉíí, Da’aṉii, da’aṉiigo gániłdishṉii, nṉee tú bee ła’íí Holy Spirit bee nágosdlįįyúgo zhą́ Bik’ehgo’ihi’ṉań bilałtł’áhgee goz’ąą yuṉe’ ha’agháh. ");
INSERT INTO apwNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kots’í bee gozliiníí kots’í át’éé, áídá’ Holy Spirit bee gozliiníí spirit at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Doo nił díyagot’éé da le’, Nágoch’idleeh, niłdishṉiihíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nyolíí da’adzaayú nyol, áí dints’agdá’ hadí’ nyolíí, hayúgo nyolíí doo bígonłsį́ da; dawa Holy Spirit bee nádaagosdliiníí ágádaat’éhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodémus gábiłṉii, Hagot’éégo ląą ágołnṉíhi? ");
INSERT INTO apwNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus gábiłṉii, Ni Israel hat’i’i yił ch’ígó’aahi ńlį́į́dá’, dííshą’ doo bígonłsį́ da? ");
INSERT INTO apwNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Da’aṉii, da’aṉiigo gániłdishṉii, néé bídaagonlziníí zhą́ baa yádaahiilti’, hant’é daahiit’iiníí zhą́ baa nadaagohiilṉi’; áídá’ baa nadaagosiilṉi’íí doo nádaagodoh’aah da. ");
INSERT INTO apwNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ni’gosdzáń biká’ ágot’eehíí baa nohwił nagosisṉi’ ndi doo shondląą dadá’, yaaká’yú ágot’eehíí baa nohwił nagoshṉi’yúgo hagot’éégo shondląą? ");
INSERT INTO apwNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Doo hadíń yaaká’yú bił ogoyáá da, shíí nṉee k’ehgo Niyááhíí zhą́, yaaká’dí’ nkeniyáá, yaaká’yú gonshłįį. ");
INSERT INTO apwNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses da’igolį́į́yú tł’iish dahyidnłtįįhíí k’ehgo, shíí ałdó’ nṉee k’ehgo Niyááhíí dahshidi’dolteeł: ");
INSERT INTO apwNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Hadíń shosdląądihíí ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Bik’ehgo’ihi’ṉań ni’gosdzáń biká’ nṉee dázhǫ́ bił daanzhǫǫhíí bighą biYe’ dała’áhi yaa yinłtį́į́, áík’ehgo dahadíń bosdląądihíí doo da’ílį́į́ hileeh da, áídá’ ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bik’ehgo’ihi’ṉań biYe’ ni’gosdzáń biká’zhį’ nkeyínł’a’íí ni’gosdzáń biká’ nṉee doo yił ch’ígóweh doleełhíí bighą nkeyínł’a’ da, áídá’ ni’gosdzáń biká’ nṉee bíí bee hasdádokaahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Hadíń bosdląądíí doo bił ch’ígódeeh da: áídá’ hadíń doo bosdląąd dahíí iłk’idá’ bił ch’ígódíni at’éé, Bik’ehgo’ihi’ṉań biYe’ dała’áhi doo yosdląąd dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Díí bighą nṉee bił ch’ígódįh, begot’iiníí ni’gosdzáń biká’ begonyáá, áídá’ nṉee doo got’iiníí bił daanzhǫǫ da, chagołheeł zhą́ bił daanzhǫǫ, nchǫ’go ádaat’eehíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Dahadíń nchǫ’go at’éé lę́k’eyúgo, got’iiníí bił nchǫ’, bi’at’e’ nchǫ’íí doo bígozįįh hat’į́į́ dahíí bighą, doo got’įįyú ch’égháh hát’į́į́ da. ");
INSERT INTO apwNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Hadíń nłt’éégo at’ééhíí, bi’at’e’íí Bik’ehgo’ihi’ṉań ye’at’éégo bígozįįh doleełhíí bighą got’įįyú ch’égháh. ");
INSERT INTO apwNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Áí bikédí’go Jesus, bitsiłke’yu biłgo, Judéa golzeeyú okai; baptize ádaagole’go akú dét’įhézhį’ yił naháztąą lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","John ałdó’ Aenon golzeeyú baptize ágoł’įį, Sálimhíí bit’ahyú, akú tú łą́ą́híí bighą: áígee nṉee neheskaigo baptize ádaaszaa. ");
INSERT INTO apwNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Doo hwahá John ha’ánteeh dadá’. ");
INSERT INTO apwNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","John bitsiłke’yu ła’íí Jews daanlíni ła’ okąąhzhiṉéégo táko’digisíí yaa ładaagodit’áh nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Áídí’ John yaa hikaigo gádaayiłṉii, Iłch’ígó’aahíí ńlíni, nṉee Jórdan túńlííníí hanaayú bił na’aash n’íí, baa nagolṉí’ n’íí, áń kú naghaa, baptize ádaił’įįgo nṉee dawa bich’į’ nihikáh. ");
INSERT INTO apwNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Áík’ehgo John gáṉíí, Nṉee doo hant’é yót’į́į́ át’éé da, yaaká’dí’ baa hi’né’yúgo zhą́. ");
INSERT INTO apwNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nohwíí shídaanołsįgo, Shíí doo Christ nshłįį da, dishṉii ni’, dabíntségo bidol’aadíí nshłįį. ");
INSERT INTO apwNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ishkiin niiṉéhíí na’ilíhn yił niiṉéhíí, bíí niiṉéhi at’éé: niiṉéhíí bit’ekéhíí, bíyésts’ąągo sizįįgo, bizhii yidits’ago dázhǫ́ bił gozhǫ́ǫ́: áí k’ehgo shíí ałdó’ dázhǫ́ shił gozhǫ́ǫ́ sílį́į́. ");
INSERT INTO apwNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bíí itisgo bá godigháh, áídá’ shihíí t’ąązhį’ shá godigháh. ");
INSERT INTO apwNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hadíń yaaká’dí’ nkenyááhíí dawa yitisgo nlįį: hadíń ni’gosdzáń biká’gee nliiníí ni’gosdzáń ye’at’éé, áík’ehgo dá ni’gosdzáń biká’ ágot’eehíí zhą́ yaa yałti’: hadíń yaaká’dí’go nkenyááhíí dawa yitisgo nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Áń nt’é yo’iiníí, nt’é yidezts’aaníí, áí dawa yaa nagolṉi’; áídá’ doo hadíń bosdląąd da. ");
INSERT INTO apwNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Hadíń yaa nagosṉi’íí bosdląądíí, Bik’ehgo’ihi’ṉań da’aṉii ląą ṉiigo yiká’ iskał. ");
INSERT INTO apwNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Hadíń Bik’ehgo’ihi’ṉań bides’a’íí Bik’ehgo’ihi’ṉań biyati’ yee yałti’: Bik’ehgo’ihi’ṉań Holy Spirit doo yídaanel’ąągo baa yiné’ da. ");
INSERT INTO apwNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bik’ehgo’ihi’ṉań biYe’ bił nzhǫǫgo dawa yebik’ehgo yaidin’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dahadíń Bik’ehgo’ihi’ṉań biYe’ yosdląądíí, ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doo: dahadíń doo yosdląąd dahíí ihi’ṉaa doo yiłtséh da; áídá’ Bik’ehgo’ihi’ṉań bihashke’ biká’zhį’ siné’. ");
INSERT INTO apwNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","John biké’ hikaahíí bitisgo Jesus biké’ anáłseełíí áyidedlaago, ła’íí baptize ádaayizlaago Phárisees daanlíni ya’ikodaanzįįgo Jesus yígołsįįdá’, ");
INSERT INTO apwNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Da’ágát’éé ndi Jesus doo baptize áíł’įį da, bitsiłke’yu zhą́,) ");
INSERT INTO apwNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Judéadí’ Gálileeyú naadesdzaa. ");
INSERT INTO apwNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Dá Samáriayú zhą́ bá ch’ígót’i’ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Áígee kįh gozṉilyú ńyáá, Sýchar golzéhi, ni’ Jacob biye’, Joseph holzéhi, yaa gon’ą́ą́ n’íí bit’ahgee goz’áni. ");
INSERT INTO apwNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Áígee Jacob bitúhahidleeh goz’ąą. Jesus higaałgo isk’áhńyááyú hiyaago túhahidleehgee dahnezdaa. ");
INSERT INTO apwNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Isdzán, Samáritan nlíni, tú haileehyú ńyáá: Jesus, Tú shá ná’íłsįįh, biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Bitsiłke’yuhíí kįh gozṉilyú hidáń nadaihiłṉiihyú okai.) ");
INSERT INTO apwNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Isdzán Samáritan nlínihíí gábiłṉii, Hant’é lą́ bighą ni, Jew ńlíni, shíí Samáritan nshłíni tú shídǫ́keed? Jews daanlíni Samáritans daanliiníí doo iłch’į’ádaat’ee da. ");
INSERT INTO apwNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus gábiłṉii, Hant’é Bik’ehgo’ihi’ṉań kaa yiné’íí, ła’íí hadíń, Tú shá ná’íłsįįh, niłṉiihíí bígonłsį́yúgo shí’ǫ́keed doleeł ni’, áík’ehgo tú bits’ą́’dí’ ihi’ṉáhi naa nizíid doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Isdzán gábiłṉii, Doo nt’é bee tú haleeh da, túhahidleehíí yúyah: áídá’ hadí’ tú bits’ą́’dí’ ihi’ṉáhi nádnziid? ");
INSERT INTO apwNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nishą’ Jacob, bits’ą́’dí’ daadihe’ṉa’i, bitisgo áńt’ee? áń díí túhahidleeh nohwá ágólaago, bits’ą́’dí’ bíí ła’íí bichągháshé ła’íí bimagashi da’idląą ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus gánábiłdo’ṉiid, Dahadíń díí tú yodlaaníí dibá’ nánádleeh: ");
INSERT INTO apwNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Áídá’ dahadíń tú baa nsiidgo yodlaaníí doo dibá’ nánáodleeh at’éé da; tú baa nsiidíí túhahidleehíí k’ehgo biyi’dí’ tú hanáńlį́į́ doleeł, dayúweh ihi’ṉaa doo ngonel’ąą dayú ńlį́į́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Isdzán gánábiłdo’ṉiid, Díí tú áłnṉiihíí ła’ shaa nzííd, doo dibá’ nánáshdleehgo da, ła’íí doo kú nánshdáhgo tú hanáhishdleeh dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus gábiłṉii, Ti’i, niką’ biká nádndáhgo bił nánt’aash. ");
INSERT INTO apwNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Isdzán, Shiką’ da’ádįh, biłṉii. Jesus gánábiłdo’ṉiid, Shiką’ da’ádįh, nṉiihíí da’aṉii ánṉii: ");
INSERT INTO apwNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Niką’ ashdla’adá’ k’adyúgo bił na’aashíí doo niką’ at’éé da: díí da’aṉii ánṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Isdzán gábiłṉii, Bik’ehgo’ihi’ṉań binkááyú na’iziidi ńlį́į́go bígosíłsįįd. ");
INSERT INTO apwNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Daanohwitaa n’íí díí dziłíí biká’ da’okąąh ni’; áídá’ nohwihíí, Jerúsalemyú zhą́ nṉee da’okąąhgo bá goz’ąą, daadohṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus gánábiłdo’ṉiid, Isdzán, shondląą, dahagee díí dziłíí biká’yú, dagohíí Jerúsalemyú shiTaa doo daahohkąąh da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nohwíí nt’é daahohkąąh shįhíí doo bídaagonołsį da: nééhíí nt’é daahohiikąąh shįhíí bídaagonlzį; hasdách’igháhíí Jews daanliiníí bits’ą́’dí’ benagowáhi. ");
INSERT INTO apwNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kodí’ begoldoh, da’aṉiigo da’okąąhíí biyi’siziiníí bee da’aṉiigo shiTaa daayokąąh doleełíí kú begoz’áni at’éé: shiTaahíí ágát’éégo da’okąąhíí yiká déz’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Bik’ehgo’ihi’ṉań spirit nlįį, hadíń daabokąąhíí biyi’ siziiníí bee da’aṉiigo daabokąąhgo dábik’eh. ");
INSERT INTO apwNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Isdzán gábiłṉii, Messías, Christ holzéhi, hígháhgo bígonsį: áń ńyáágo dawa nohwił nagolṉi’ ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus gábiłṉii, Shíí nich’į’ yashti’ihíí áń ánsht’ee. ");
INSERT INTO apwNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Áík’ehgo bitsiłke’yu nákaigo isdzán bich’į’ yałti’híí bighą bił díyadaagot’ee lę́k’e: áídá’ doo ła’ gánṉiid da, Nt’é bighą na’ídńłkid? dagohíí, Nt’é bighą bił iłch’į’ yáńłti’? ");
INSERT INTO apwNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Áík’ehgo isdzán bitús da’akú si’ąądá’ kįh gozṉilyú onálwodgo nṉee yił nadaagolṉi’, ");
INSERT INTO apwNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Yushdé’, nṉee dahot’éhé ánásht’įįdíí yaa shił nagosṉi’íí daahołtséh: áńshą’ Christ at’į́į́? ");
INSERT INTO apwNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Áík’ehgo kįh gozṉildí’ dahnádnząą, bich’į’ dahdeskaigo. ");
INSERT INTO apwNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","T’ah daahiikááhdá’ Jesus bitsiłke’yu nádaabokąąh, NohwiNant’a’, ináá, daabiłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Áídá’ gádaabiłṉii, Hidáń hishaaníí doo bídaagonołsį da. ");
INSERT INTO apwNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bitsiłke’yu gádaałiłdi’ṉii, Hadíń ła’ hidáń baa yiné’? ");
INSERT INTO apwNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus gádaabiłṉii, Shinł’a’ń dabíí hát’ííyú ánásht’įįłgo, ła’íí binasdziid bá łaashłe’go shihidáń át’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","T’ah dį́į́’i daahiit’įįh yidziishą’ int’ąązhį’, daadohṉii? Nohwił nagoshṉi’, hadag ádaahṉéhgo daadeh’į́į́; iłk’idá’ daadiigaago da’ildlaadgee ngonyaa. ");
INSERT INTO apwNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Hadíń iłdlaadíí nest’áń dáła’áile’go ihi’ṉaa doo ngonel’áni bich’į’ nahi’ṉiił: áík’ehgo k’e’dileehíí ła’íí iłdlaadíí biłgo dała’ bił daagozhǫ́ǫ́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Díí beha’odziihíí da’aṉii ágolzee, Ła’ k’e’dilee, ła’íí iłdlaad. ");
INSERT INTO apwNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Doo k’edaadisolaa dagee daahołdlaadyú nohwidéł’a’: nṉee ła’i k’ednláhi, binasdziid n’íí daahisołdlaad. ");
INSERT INTO apwNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Isdzán, Ánásht’įįd n’íí dawa yaa shił nagosṉi’, ṉiihíí bighą kįh gozṉildí’ Samáritans daanlíni łą́ą́go Jesus daayosdląąd lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samáritans daanlíni baa hikaigo, Dakú síńdaa, daabiłṉii: da’áígee sidaago naki beiskąą. ");
INSERT INTO apwNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Biyati’híí bighą dayúwehégo łą́ą́go nádaabosdląąd; ");
INSERT INTO apwNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Áí isdzánhíí gádaayiłṉii, K’adíí doo dániyati’ zhą́ bighą da’osiidląąd da, danéé da’disiit’ąąhíí bighą, ła’íí da’aṉii ni’gosdzan biká’ nṉeehíí hasdáyiṉiiłíí, áí Christ nlįįgo bídaagonlzį. ");
INSERT INTO apwNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nakiskąą hik’e Gálileeyú onanádzaa. ");
INSERT INTO apwNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesus ádaanagołṉi’go gánṉiid, Bik’ehgo’ihi’ṉań binkááyú na’iziidi dabíí bini’yú doo hadíń bidnłsíni at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Gálileeyú ńyáádá’ Gálileeyú daagolííníí bił daagozhǫǫgo k’édaabiłnṉiid, Jerúsalemyú da’idąągee ánát’įįd n’íí dawa daayo’įį n’íí bighą: bíí ałdó’ da’idąąyú naaskai ni’go. ");
INSERT INTO apwNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Áídí’ Gálilee biyi’ Cána golzeeyú Jesus nádzáá, tú dasts’aa bitoo áyíílaa n’yú. Áígee nant’án ła’ biye’ nṉiih lę́k’e, Capérnaum golzeegee. ");
INSERT INTO apwNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Áí nṉeehíí Jesus Judéadí’ Gálileeyú ńyáágo ya’ikonzįįdá’ yaa nyáágo náyoskąąd, Shiye’ nánlziihyú ńṉáh, yiłṉiigo, dak’azhą́ datsaahi. ");
INSERT INTO apwNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus gábiłṉii, Godiyįhgo be’ídaagozini ła’íí ízisgo ánágot’įįłíí daah’įįyúgo zhą́ da’ohdląą. ");
INSERT INTO apwNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nant’ánhíí gábiłṉii, Shigowąyú ńṉáh, shizhaazhé doo hwahá datsaah dadá’. ");
INSERT INTO apwNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus gábiłṉii, Nádńdáh; niye’ hiṉaa, nłt’éé násdlį́į́. Nṉee Jesus áṉííhíí yosdląądgo dahnasdzáá. ");
INSERT INTO apwNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","T’ah nádaałdá’ bánada’iziidíí bidááh hikaigo bił nadaagolṉi’, Niye’ hiṉaa, daabiłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nṉeehíí na’ídńłkid, Da’kwíí bik’ehenkéézdá’ t’ąązhį’ bá nágodesdzaa láń? biłṉiigo. Gádaabiłṉii, Adąądá’ hayaazhį’ dała’á bik’ehenkéézdá’ nezgai n’íí bits’ą́’ gonyáá ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bitaa yígółsį, da’áí bik’ehenkééz n’dá’ Jesus, Niye’ hiṉaa, biłṉii ni’: áík’ehgo osdląąd, ła’íí bikįh yuṉe’ naháztaaníí dawa ałdó’ da’osdląąd. ");
INSERT INTO apwNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesus Judéadí’ Gálileeyú ńyáádá’ díí nakigee godiyįhgo adzaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Díí bikédí’go Jews daanlíni da’iyąąhíí begonyáádá’, Jesus wą́’yú Jerúsalemyú óyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerúsalemyú dibełį́į́ nahiṉiih goz’aaníí bahgee túdahskąą lę́k’e, Hébrew biyati’íí k’ehgo Bethésda golzéhi, áígee ashdla’yú chagosh’oh nagoz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Áígee iłtah at’éégo kah yaa nakaihíí łą́ą́go, biṉáá ádaagodini, doo nakai dahi, daadi’ilihi ałdó’, tú dihi’ṉáhíí yiba’ íła’at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bik’ehgo’ihi’ṉań binal’a’á yaaká’dí’hi łahgee túdahskaaníí yeh nadáhgo tú nádihi’ná: tú dehes’naago hadíń ntsé téh híyááhíí, nt’é yaa naghaa láshį n’íí nádzii. ");
INSERT INTO apwNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nṉee ła’ tádin tsebíí bił łegodzaago kah yaa naghaago áígee sitįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus bo’įįdá’ dásitįįgo ńzaad ogoyááhíí yígółsįgo gábiłṉii, Ya’ nándzii hánt’įį née? ");
INSERT INTO apwNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nṉee kah yaa naghaahíí gábiłṉii, Tú nahi’naagee doo hadíń téh shiłteeh da: dá doo téh hisháhé dashíntsé ła’ téh nádáh. ");
INSERT INTO apwNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus gábiłṉii, Nádndáh, biká’síńtįįhíí dahnádnné’go dahnádńdáh. ");
INSERT INTO apwNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nṉeehíí dagoshch’į’ nádziigo yiká’ sitįį n’íí dahnáyidnné’go dahnasdzáá: áí Jews daagodnłsiníí bijįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Áík’ehgo Jews daanlíni nṉee nádziihíí gádaayiłṉii, Díí godilziníí bijįį: biká’ńtéhíí anané’go doo begoz’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Áík’ehgo gábiłṉii, Nṉee náshilziihíí gáshiłnṉiid, Biká’síńtįįhíí dahnádnné’go dahnádndáh. ");
INSERT INTO apwNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Áídí’ nabídaadiłkid, Nṉee daat’éhi, Biká’síńtįįhíí dahnádnné’go dahnádndáh, niłnṉiid? ");
INSERT INTO apwNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nṉee nádziihíí hadíń nábilzii shįhíí doo yígółsį da: áígee nṉee łą́ą́dá’ Jesus łahyúgo oyáá lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Díí bikédí’go da’ch’okąąh goz’ąą yuṉe’ Jesus nṉee nádzii n’íí yaa nyáágo gáyiłṉii, Nłt’éé násíńdlįį gádnii áko: nchǫ’go ánáo’ṉe’ hela’, ágánándzaayúgo dánko da’tiségo nich’į’ nágodiidáh. ");
INSERT INTO apwNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nṉeehíí Jews daanlíni yaa nyáágo, Náshidilziihíí Jesus at’į́į́, daayiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Díí daagodnłsiníí bijįį adzaahíí bighą Jews daanlíni Jesus yaa yádaałti’go daiziłhee hádaat’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Áídá’ Jesus gádaabiłṉii, ShiTaa t’ah na’iziid, shí ałdó’ na’isiid. ");
INSERT INTO apwNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Godilziníí bijįį begoz’aaníí doo yikísk’eh at’éé dahíí bighą, ła’íí Bik’ehgo’ihi’ṉań shiTaa yiłṉiigo Bik’ehgo’ihi’ṉań yił dała’ nlįįgo ádilzįhíí bighą Jews daanlíni dayúwehégo daabiziłhee hádaat’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus gánádaabiłdo’ṉiid, Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Shíí, Bik’ehgo’ihi’ṉań biYe’ nshłiiníí, dashí zhą́ doo nt’é łaoshłéh át’éé da, shiTaa ánát’įįłgo hish’iiníí zhą́: shiTaa ánát’įįłíí k’ehgo shíí ałdó’ ánásht’įįł. ");
INSERT INTO apwNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ShiTaa shíí biYe’ nshłiiníí dázhǫ́ bił nshǫǫ, dabíí ánát’įįłíí dawa shił ch’í’ṉah áyíłsį: díí bitisgo áná’ol’įįłíí shił ch’í’ṉah áile’gee nohwił díyadaagot’ee doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ShiTaa nanezna’íí nádaayihiłṉahíí k’ehgo shíí, biYe’ nshłiiníí, ałdó’ hadíí hásht’ííníí nádaabihishṉah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ShiTaa nṉee doo ła’ yángo’áah da, shíí, biYe’ nshłiiníí, dawa bándaagosh’a’go shaidin’ą́ą́: ");
INSERT INTO apwNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nṉee dawa shiTaa daayidnłsįhíí k’ehgo shíí, biYe’ nshłiiníí, ałdó’ daashidnłsį doleełhíí bighą adzaa. Hadíń doo shidnłsį dahíí shiTaa shides’a’ń ałdó’ doo yidnłsį da. ");
INSERT INTO apwNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Hadíń shiyati’ yidits’agíí, ła’íí shinł’a’ń yodlaaníí, ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doleeł, áń doo bił ch’ígódeeh da; áń da’itsaahdí’ ch’ínyáá, ihi’ṉaazhį’go. ");
INSERT INTO apwNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Nanezna’íí shíí, Bik’ehgo’ihi’ṉań biYe’ nshłiiníí, shizhiihíí daidiits’į́h doleełíí baa gowáh, iłk’idá’ kú begoz’ąą: hadíí áí daidezts’aaníí daahiṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ShiTaa ihi’ṉaa dabíí biyi’ nlįįhíí k’ehgo, shíí, biYe’ nshłiiníí, ałdó’ ihi’ṉaa dashíí shiyi’ nlįįgo shaa godin’ą́ą́; ");
INSERT INTO apwNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Shíí, nṉee k’ehgo Niyááhíí nshłįįhíí bighą nṉee bá ndaagosh’a’go shiTaa shaa godin’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Doo nohwił díyadaagot’ee da le’: łeyi’ nazṉilíí dawa shizhii daidezts’ąągo nádiikáhíí baa gowáh, ");
INSERT INTO apwNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Áí nádiikáhgee nłt’éégo ádaadzaa n’íí yaaká’yú dahazhį’ daahiṉaa doleeł; áídá’ nchǫ’go ádaadzaa n’íí bił ch’ígódeeh. ");
INSERT INTO apwNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Dashíí shik’ehgo doo nt’é áoshłéh át’éé da: diists’sagíí k’ehgo aayashti’: dashíí hásht’ííníí doo be’ánsht’ee da, áídá’ shiTaa shides’a’ń dabíí hát’ííníí zhą́ be’ánsht’eehíí bighą aayashti’íí dábik’eh. ");
INSERT INTO apwNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Dashíí ádaa nagoshṉi’yúgo, ádaa nagoshṉi’íí doo da’aṉii da. ");
INSERT INTO apwNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ła’ shaa nagolṉi’íí gólį́į́; áí shaa nagolṉi’íí da’aṉiigo bígonsį. ");
INSERT INTO apwNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","John bich’į’ oda’soł’a’, áń da’aṉiigo shaa nagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Da’aṉiigo shaa na’goṉi’íí doo nṉee bits’ą́’dí’ da: áídá’ hasdánohwidi’ṉiił doleełhíí bighą ágánohwiłdishṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John diltłi’íí hik’e bits’ą́’idindláádíí k’ehgo at’éé lę́k’e: áík’ehgo bits’ą́’idindláádíí biyi’ dét’įh nohwił daagozhǫǫhgo ádaasoht’įįd. ");
INSERT INTO apwNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","John shaa nagosṉi’íí bitisgo shaa na’goṉi’íí gólį́į́: na’idziidíí shiTaa łaashłe’ doleełgo shaa yidin’ááníí, áí ánásht’įįłgo shiTaa shides’a’go shaa nagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ShiTaa shides’a’ń dabíí shaa nagolṉi’. Bizhiihíí doo hak’i daadesołts’ąą da, ánoliníí doo hak’i daahołtsąą da. ");
INSERT INTO apwNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Biyati’íí doo nohwiyi’ golį́į́ da: shíí shinł’a’íí doo daashohdląą dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí nzhǫǫgo daahohshíí; áí biláhyú dahazhį’ daahii’ṉaa doleeł daanohsįgo: da’áí shaa nagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ndi doo shich’į’ nohkáh hádaaht’įį da, dahazhį’ daahinohṉaa doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nṉee shídnłsį́híí doo biká désh’įį da. ");
INSERT INTO apwNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nohwídaagonsį, Bik’ehgo’ihi’ṉań nohwił daanzhooníí doo ła’ be’ádaanoht’ee da. ");
INSERT INTO apwNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ShiTaa bizhi’íí bee niyáá ndi doo hádaashoht’įį da: áídá’ ła’i dabíí bizhi’íí yee nyááyúgo, áń zhą́ hádaaht’įį doo. ");
INSERT INTO apwNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Dánohwíí daałinołsiníí hádaaht’įįdá’, Bik’ehgo’ihi’ṉań dała’áhi bits’ą́’dí’ idilziníí doo hádaaht’įį da, áídá’ hagot’éégo da’ohdląą? ");
INSERT INTO apwNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ShiTaa biṉááł nohwik’izhį’ dish’aah doo daanohsį da le’: Moses nohwik’izhį’ dez’ąą, bada’ohłíí n’íí. ");
INSERT INTO apwNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses daahohdląąyúgo shíí daashohdląą doleeł ni’, shaa k’e’eshchįįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Áídá’ bíí k’e’eshchiiníí doo daahohdląą dayúgo, hagot’éégo shiyati’íí daahohdląą áídá’? ");
INSERT INTO apwNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Díí bikédí’go Jesus túsikaaníí, Gálilee golzéhi, da’áí Tibérias golzéhi, hanaayú onanádzaa. ");
INSERT INTO apwNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Áígee nṉee łą́ą́go biké’ onałsą́ą́, godiyįhgo áná’ol’įįłíí kah yaa nakaihíí yá ánát’įįłíí daayo’įįgo. ");
INSERT INTO apwNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus dziłyú háyáá, akú bitsiłke’yu yił dinezbį. ");
INSERT INTO apwNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Bitis‐hagowáh n’íí bee bíná’godiṉíhgo Jews daanlíni da’iyąąhíí biká’ ngonyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus déz’įįgo nṉee łą́ą́go bich’į’ náłseełgo yiłtsąądá’ Philip gáyiłṉii, Hagot’éégo báń nadaahiilṉiih, díí nṉee dawa da’iyąągo? ");
INSERT INTO apwNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Díí áṉííhíí daazhógo Philip bebígozįįhgo ánṉiid: dabíí hagot’éégo áile’ yígółsį ndi. ");
INSERT INTO apwNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip gábiłṉii, Zhaali, penny holzéhi, naki gonenadín báń bee nahazṉii ndi dała’á ntį́į́go ayą́hágo bita’isné’ ndi, doo bínenol’ąą at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Bitsiłke’yu dała’á Andrew holzéhi, Simon Peter bik’isnhi, gábiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Kú ła’ ishkiin báń dijolé ashdla’i barley alzáhi yisné’, łóg naki biłgo: áídá’ hagot’éégo dawa bínel’ąą, nṉee łánihíí? ");
INSERT INTO apwNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus bitsiłke’yu gáyiłṉii, Nṉee dinohbįh, daabiłdohṉii. Tł’oh dázhǫ́ łą́ą́go lę́k’e. Áík’ehgo nṉee dinezbį, ashdladn doo náhóltagyú áhołáni shį. ");
INSERT INTO apwNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Áígee Jesus báń náidnné’go ya’ihénzįgo oskąądá’, bitsiłke’yu yaa daizné’, áídí’ bitsiłke’yu nṉee nadaaháztaaníí yitada’izṉii; łógíí ałdó’ da’áí k’ehgo, dá daabiłhwiihzhį’. ");
INSERT INTO apwNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Dawa náda’isdįįdgo, bitsiłke’yu gádaayiłṉii, Ch’ékaadíí nádaahohłá, doo ła’ da’ílíí hileehgo da. ");
INSERT INTO apwNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Áík’ehgo ąął nádaihezlaago táts’aa nakits’ádah hadaidesbį, báń ashdla’i bits’ą́’dí’ ch’ené’íí, nṉee yi’oh da’iyą́ą́híí. ");
INSERT INTO apwNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nṉeehíí Jesus godiyįhgo adzaahíí daayiłtsąądá’ gádaaṉii, Áń da’aṉii Bik’ehgo’ihi’ṉań binkááyú Na’iziidihíí, ni’gosdzáń biká’zhį’ hiṉáhi. ");
INSERT INTO apwNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus nṉee dabízhą́ daabik’ehgo dak’azhą́ binant’a’ ádaabidléhgo yígołsįįdá’, dasahn dziłyú ch’a’onánóot’įįd. ");
INSERT INTO apwNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","O’i’ą́ą́yú bitsiłke’yu túsikąąyú onanákai, ");
INSERT INTO apwNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Akú tsina’eełíí yeh hikaigo túsikaaníí hanaayú bił dahda’n’eel, Capérnaum golzeeyú. Godiłhił gozlįįdá’ Jesus doo hwahá baa hiṉáh da. ");
INSERT INTO apwNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tú nádidáh, adįįd nyolhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Taagi dagohíí dį́į́’i shį dahgostǫ’yú bił oda’is’eeldá’, Jesus tú yiká’ tsina’eełíí yich’į’ higaałgo daayiłtsąą: áík’ehgo tsídaadesyiz lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Áídá’ Jesus gádaabiłṉii, Shíí ásht’įį, doo ńdaałdzid da. ");
INSERT INTO apwNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Áídí’ bił daagozhǫ́ǫ́go tsina’eełíí beh ńṉáh, daabiłnṉiid: dagoshch’į’ ni’zhį’ bił nda’iz’eel, deskai n’yú. ");
INSERT INTO apwNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Iskąą hik’e nṉee túsikaaníí hanaayú naháztaaníí akú tsina’eełíí dała’á zhą́ si’ąą n’go daayo’įį, ła’íí Jesus bitsiłke’yu tsina’eełíí yeh hikaiyú doo itah yeh hiyaa da, áídá’ bitsiłke’yu dasahndi okaigo daayo’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(Jesus báń ya’ihénzįgo oskąądíí bikédí’go, báń daach’iyą́ą́ n’gee bahyú Tibérias golzeedí’ tsina’eełíí ndaahaz’eel:) ");
INSERT INTO apwNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Áík’ehgo nṉee Jesus ła’íí bitsiłke’yu doo hak’i dago yídaagołsįįdá’, dabíí tsina’eełíí yeh heskaigo, Capérnaum golzeeyú bił oda’iz’eel, Jesus yíka daantaago. ");
INSERT INTO apwNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Túsikaaníí hanaadí’ baa hikaidá’ gádaabiłṉii, Iłch’ígó’aahíí, dadá’ kú ńyaa? ");
INSERT INTO apwNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus bich’į’ hadzii, Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Doo godiyįhgo ánásht’įįłíí daah’įį n’íí bighą shíka daanohtaa da, báń bee náda’sołdįįd n’íí zhą́ bighą ádaaht’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Doo hidáń da’ílíí hileehíí bighą nada’ohsiid da, hidáń dahazhį’ ihi’ṉaazhį’ nnel’ąąhíí zhą́ hádaaht’įį, shíí nṉee k’ehgo Niyááhíí nohwaa nshné’: Bik’ehgo’ihi’ṉań shiTaa, bíyéé nshłįįgo shebígózįhgo shiká’ izkał. ");
INSERT INTO apwNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Áídí’ gádaabiłṉii, Hago ádaahii’ṉe’go Bik’ehgo’ihi’ṉań binasdziidíí nadaahiidziid? ");
INSERT INTO apwNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus gádaabiłṉii, Díí k’ehgo Bik’ehgo’ihi’ṉań bá na’idziidi at’éé, áń shíí shides’a’ń daashohdląągo. ");
INSERT INTO apwNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Áík’ehgo gádaabiłṉii, Godiyįhgo be’ígóziníí daat’éhi nohwił ch’í’ṉah ánle’go daahiiltséhgo daanohiidląą doleeł? Iłtah áná’ol’įįłíí daat’éhi ánł’įį? ");
INSERT INTO apwNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bits’ą́’dí’ daadihe’ṉa’íí da’igolį́į́yú manna daayiyąą łeh lę́k’e: díínko bek’e’eshchiiníí k’ehgo, Yaaká’dí’ báń kaa daizné’go daach’iyąą. ");
INSERT INTO apwNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus gánádaabiłdo’ṉiid, Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Yaaká’dí’ báń nohwaa hi’né’ n’íí doo Moses nohwaa daizné’ da; shiTaa yaaká’dí’ báń da’aṉiihi nohwá da’dihiné’. ");
INSERT INTO apwNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yaaká’dí’ nkenyááhíí Bik’ehgo’ihi’ṉań bits’ą́’dí’ báńhi at’éé, áń ni’gosdzáń biká’ nṉeehíí ihi’ṉaa yaa yiné’. ");
INSERT INTO apwNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Gádaabiłṉii, NohweBik’ehń, díí báńhíí dayúweh nohwá dihii’né’ le’. ");
INSERT INTO apwNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus gádaabiłṉii, Shíí báń be’ihi’ṉaahíí nshłįį: dahadíń shaa nyááhń doo shiṉá’ holeeh at’éé da; shodląąhń doo dibá’ holeeh at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Iłk’ida’ gádaanohwiłdéṉiid, Daashoh’į́į́ ndi doo daashohdląą da. ");
INSERT INTO apwNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ShiTaa shaa yiṉilíí dawa shaa hikáh; dahadíń shaa nyááhń doo yó’ósht’e’ at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yaaká’dí’ níyáá, doo dashíí hásht’į́į́yú ánásht’įįłgo da, ndi shinł’a’ń dabíí hát’į́į́yú ánásht’įįłgo niyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Díínko shiTaa shinł’a’ń hát’į́į́, shaa yiṉilíí doo ła’ shich’a’otłíísh da, áídá’ nnágodzaahíí bijįį dawa nádaabihishṉah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Díínko shinł’a’ń hát’į́į́, hadíń shíí, biYe’ nshłiiníí, sho’iiníí ła’íí shodlaaníí ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doleeł: áík’ehgo nnágodzaahíí bijįį nábihishṉah doo. ");
INSERT INTO apwNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yaaká’dí’ báń nke’né’íí nshłįį, ṉiihíí bighą Jews daanlíni baa daanet’į́į́ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Áí gádaałiłdi’ṉii, Díń la’ Jesus, Joseph biye’, bą́ą́ bitaa biłgo bídaagonlzįhíí át’į́į́ ya’? Hagot’éégo, Yaaká’dí’ níyáá, ṉii áídá’? ");
INSERT INTO apwNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Áík’ehgo Jesus gádaabiłṉii, Doo shaa daaneht’į́į́ da. ");
INSERT INTO apwNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Doo hadíń shaa nowáh át’éé da, shiTaa shinł’a’ń shich’į’ ábíílaayúgo zhą́: nnágodzaahíí bijįį nábihishṉah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bik’ehgo’ihi’ṉań binkááyú nada’iziidi binaltsoos biyi’ k’e’eshchįį gáṉíígo, Dawa Bik’ehgo’ihi’ṉań bił ch’ídaago’aah doleeł. Dahadíń shiTaa yidezts’ąągo bits’ą́’dí’ ígoł’aaníí shaa hiṉáh. ");
INSERT INTO apwNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Da’ágát’éé ndi doo hadíń shiTaa yo’įį da, shíí bits’ą́’dí’ nshłiiníí zhą́ shiTaa yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Shodlaaníí ihi’ṉaa doo ngonel’ąą dahíí yee hiṉáhi at’éé, ");
INSERT INTO apwNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Báń be’ihi’ṉaahíí nshłįį. ");
INSERT INTO apwNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bits’ą́’dí’ daadesoṉa’íí da’igolį́į́yú manna daayiyąą n’íí nanezna’. ");
INSERT INTO apwNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Díínko báń yaaká’dí’ nke’né’hi at’éé, nṉee yiyąągo doo datsaah da. ");
INSERT INTO apwNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Shíí báń hiṉaahíí, yaaká’dí’ nkenyááhíí nshłįį: dahadíń díí báńhíí yiyąąyúgo dahazhį’ hiṉaa doleeł: ni’gosdzáń biká’ nṉee báń yee daahiṉaa doleełgo baa daanshné’íí shitsį’ at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jews daanlíni łahada’dit’áhgo gádaałiłdi’ṉii, Hagot’éégo díí nṉeehíí bitsį’ nohwaa yiné’go daahiidąą? ");
INSERT INTO apwNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus gádaabiłṉii, Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Shíí nṉee k’ehgo Niyááhíí shitsį’ daahsąągo, ła’íí shidił daahdląąyúgo zhą́ ihi’ṉaahíí nohwiyi’ golį́į́. ");
INSERT INTO apwNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Hadíń shitsį’ yiyaaníí ła’íí shidił yidlaaníí ihi’ṉaa doo ngonel’ąą dahíí yee hiṉáhi at’éé; nnágodzaahíí bijįį nábihishṉah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Shitsį’ da’aṉii hidáń át’éé, ła’íí shidił da’aṉii hidlaaníí át’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Hadíń shitsį’ yiyaaníí ła’íí shidił yidlaaníí shiyi’ golį́į́, bíí ałdó’ biyi’ gonshłįį. ");
INSERT INTO apwNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ShiTaa hiṉáhi shinł’a’híí k’ehgo, ła’íí shiTaa bee hinshṉaahíí k’ehgo hadíń shiyaaníí shee hiṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Áń báń yaaká’dí’ nke’né’hi at’éé: doo daanohwitaa n’íí manna daayiyąą ndi nanezna’ n’íí k’ehgo da: hadíń díí báń yiyaaníí dahazhį’ hiṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capérnaum golzeegee iłch’ígó’aahgo ágánṉiid, Jews ha’ánáłséh goz’ąą yuṉe’. ");
INSERT INTO apwNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Łą́ą́go biké’ hikaahíí áí daidezts’ąądá’ gádaaṉii, Dázhǫ́ doo bígózį dahi yee aṉíí; hadíń áí yígółsį? ");
INSERT INTO apwNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Biké’ hikaahíí Jesus aṉííhíí yaa yída’iłtahgo yígółsį, áík’ehgo gádaabiłṉii, Díí ádishṉiihíí doo nohwił daabik’eh da née? ");
INSERT INTO apwNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Shíí, nṉee k’ehgo Niyááhíí, dabíntsé sídáá n’yú shił onágodzaago daashoh’įįyúgo, nt’é daadohṉii? ");
INSERT INTO apwNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Spirit‐híí ihi’ṉaa aayiné’hi at’éé; kots’íhíí doo nt’é áile’ da: yati’ bee nohwich’į’ hasdziihíí spirit hik’e ihi’ṉaahíí át’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Áídá’ nohwitahyú ła’ doo da’ohdląą da. Jesus dantsé iłch’ígó’aah godeyaadá’ hadíí doo daabodląą dahíí, ła’íí hadíń ch’íbido’aałń yígółsį. ");
INSERT INTO apwNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Áík’ehgo gánádí’ṉii, Díí bighą gádaanohwiłdéṉiid, Doo hadíń dabíí bik’ehgo shaa hiṉáh da, shiTaa bik’ehyúgo zhą́. ");
INSERT INTO apwNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Díí bikédí’go biké’ hikaah n’íí łą́ą́go t’ąązhį’ ádaadzaago, doo dayúweh yił nakai da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesus bitsiłke’yu nakits’ádahíí gádaayiłṉii, Nohwíí ałdó’ shits’ą́’ dahdohkáh née? ");
INSERT INTO apwNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter gábiłṉii, NohweBik’ehń, hadíń bich’į’ nkáhgo áídá’? Dani zhą́ yati’ dahazhį’ be’ihi’ṉaahíí bee yáńłti’. ");
INSERT INTO apwNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ni Christ, Bik’ehgo’ihi’ṉań hiṉáhi biYe’ ńlį́į́go, daahosiidląądgo da’aṉiigo bídaagonlzį. ");
INSERT INTO apwNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus gánádaabiłdo’ṉiid, Nohwíí nakits’ádah hołt’eehíí hanohwiṉil, ndi nohwitahyú dała’á ch’iidn nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Áí Judas Iscáriot, Simon biye’ áyiłṉii: áń nakits’ádah itah nlíni ch’íbido’aałń nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Díí bikédí’go Jesus Gálileeyú anádaał: Judéayú doo naghaa da, Jews daanlíni daabiziłheego hádaat’įįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jews daanlíni tł’ohdahskáń yuṉe’ náda’idįįhíí biká’ ngonyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesus bik’isyú gádaabiłnṉiid, Kodí’ dahnṉáhgo Judéayú ńṉáh, ákú niké’ hikaahíí áná’íl’įįłíí daayiłtséh doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nṉee shígózį le’ nziníí doo dánant’į’ego ánát’įįł da. Díí baa nanṉaayúgo, ni’gosdzáń biká’ nṉee bił ch’í’ṉah ádńlzį. ");
INSERT INTO apwNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bik’isyú ndi doo daabodląą da. ");
INSERT INTO apwNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus gádaabiłṉii, Shíí t’ah doo shaa gowáh da: áídá’ nohwíí zhą́ da’ádzaagee nohwaa gowáh. ");
INSERT INTO apwNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ni’gosdzáń biká’ nṉee nohwíí doo nohwik’edaanṉiih da; dénchǫ’go ánádaat’įįł dishṉiigo baa nagoshṉi’híí bighą shíí zhą́ shik’edaanṉiih. ");
INSERT INTO apwNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Dánohwízhą́ da’idąąyú dohkáh: shíí t’ah doo shaa gowáh dahíí bighą doo dak’ad da’idąąyú déyáá da. ");
INSERT INTO apwNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ágánṉiidá’ da’akú Gálilee golzeeyú sidaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bik’isyú da’idąąyú okaihíí bikédí’go, bíí ałdó’ dánant’į’ego akú óyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Da’idąągee Jews daanlíni biká daadéz’įįgo, Áńhíí hayú? daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nṉee bitahyú łą́ą́go baa daanet’į́į́ lę́k’e: ła’, Nṉee nłt’éhi nlįį, daaṉiidá’ ła’íí, Dah, nṉee ch’a’oyiłkaadi nlįį, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Áídá’ Jews daanlíni yédaaldzidhíí bighą doo ch’í’ṉah baa yádaałti’ da. ");
INSERT INTO apwNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Da’idąąhíí da’iłṉí’yú goldohdá’ Jesus da’ch’okąąh goz’ąąyú óyáágo iłch’ígó’aah. ");
INSERT INTO apwNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jews daanlíni bił díyadaagot’ee gádaaṉiigo, Hagot’éégo díí nṉeehíí dawahá yígółsį, doo ółtagyú nayaa dadá’? ");
INSERT INTO apwNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus gádaabiłṉii, Iłch’ígonsh’aahíí doo dashíí ádíshṉii da, shinł’a’ń áṉííhíí át’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nṉee ła’ Bik’ehgo’ihi’ṉań dáhat’į́į́híí ánát’įįł hat’į́į́yúgo, iłch’ígonsh’aahíí Bik’ehgo’ihi’ṉań bits’ą́’dí’hi at’éé, dagohíí dashínik’ehgo yashti’íí yígółsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Dahadíń dabínik’ehgo yałti’íí dabíí ízisgo ádestįį hat’į́į́: áídá’ hadíń binł’a’ń ízisgo ágot’eehíí yá hát’ííníí, áń da’aṉii áṉíí, áík’ehgo áń biyi’ łé’gochoohíí da’ádįh. ");
INSERT INTO apwNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ya’ Moses begoz’aaníí yee doo nohwá ngon’ą́ą́ da née? Áídá’ doo ła’ bikísk’eh ádaanoht’ee da. Nt’é bighą daashizołhee hádaaht’į́į́? ");
INSERT INTO apwNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nṉeehíí gádaabiłṉii, Ch’iidn niyi’ golį́į́ lą́ą́: hadíń niziłhee hat’į́į́? ");
INSERT INTO apwNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus gádaabiłṉii, Dałán áná’íł’įįdgee nohwił díyadaagot’ee ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses círcumcise ádaanohwidilṉe’go yee nohwá ngon’ą́ą́; (ndi Moses doo bits’ą́’dí’ begodeyaa da, daanohwitaa n’íí bits’ą́’dí’;) áík’ehgo godilziníí bijįį nṉee círcumcise ádaahłe’. ");
INSERT INTO apwNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Godilziníí bijįį Moses yegos’aaníí doo k’ích’ídzį́į́s da doleełhíí bighą nṉee círcumcise alzaayúgo, godilziníí bijįį nṉee bits’í dawa nłt’éégo ánáshdlaahíí bighą shich’į’ hadaashohkee née? ");
INSERT INTO apwNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Doo da’ánoliníí zhą́ bee aayádaałti’ da, áídá’ da’aṉii ágot’eehíí bee aayádaałti’ le’. ");
INSERT INTO apwNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerúsalemgee nṉee ła’ gádaaṉii, Díń daayiziłheego hádaat’iiníí shį ya’? ");
INSERT INTO apwNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Áń kú doo biini’ hą́h dago yałti’go naghaa, áídá’ doo nt’é daayiłṉii da. Nant’án daanlíni díń da’aṉii Christ nlįįgo yídaagołsįįd shį. ");
INSERT INTO apwNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Áídá’ díí nṉee hadí’ naghaa shįhíí bídaagonlzį: Christ nyáágo hadí’ naghaa shįhíí doo hadíń yígółsį da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Áík’ehgo Jesus da’ch’okąąh goz’ąą yuṉe’ iłch’ígó’aahgo gáṉíí, Shídaagonołsį, ła’íí hadí’ nashaahíí bídaagonołsį: doo dashíí hásht’į́į́go niyáá da, shinł’a’ń da’aṉii, áń doo bídaagonołsį da. ");
INSERT INTO apwNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Shíí bígonsį; shinł’a’go bits’ą́’dí’ níyááhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Áík’ehgo ha’ádaabiłt’e’ hádaat’įį: ndi doo daabiłtsood da, doo hwahá bidizi’deehíí biká’ ngowáh dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nṉee łą́ą́go daabosdląądgo gádaaṉii, Christ nyáágo, díí nṉee godiyįhgo áná’ol’įįłíí bitisgo áná’ol’įįł doleeł née? ");
INSERT INTO apwNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Phárisees daanlíni nṉee ágát’éégo baa yádaałti’go ba’ikodaanzįįdá’, okąąh yedaabik’ehi itisyú nadaandeehi ła’íí Phárisees daanlíni biłgo aasiṉilíí bich’į’ odais’a’, daabiłtsoodgo. ");
INSERT INTO apwNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus gádaabiłṉii, Dét’įhézhį’ t’ah nohwił nashkai, áídí’ shinł’a’ń bich’į’ nádésdzá. ");
INSERT INTO apwNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Shíka daanohtaa ndi doo shaa nohkáh át’éé da: hayú níyááyú doo nohkáh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jews daanlíni gádaałiłdi’ṉii, Díí nṉee hayú doo baa nkáh dayú deyaago aṉii? Jews daanliiníí doo Jews daanlįį dahíí bitahyú iłtanáhosąą n’íí yich’į’ deyaayú, doo Jews daanlįį dahíí yił ch’ídaago’aahgo aṉíí shį? ");
INSERT INTO apwNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nt’é ṉíígo aṉii, Shíka daanohtaa ndi doo shaa nohkáh át’éé da: ła’íí, Hayú níyááyú doo nohkáh át’éé da? ");
INSERT INTO apwNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Da’idaaníí bennágódáhíí bijįį, nṉee łą́ą́go íła’adzaahíí bijįį, Jesus hizį’dá’ adįįd hadziigo, Dahadíń dibá’ silįįhń shich’į’ nowáhgo odląą, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dahadíń shodląąhń biyi’dí’ tú hiṉáhi hálį́į́ doleeł, Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Díí k’ehgo Holy Spirit yaa yałti’, áń hadíí daabodlaaníí bee baa godot’aał: Holy Spirit doo hwahá hadíń baa det’aah dadá’, Jesus ízisgo ye’at’ééhíí doo hwahá ch’í’ṉah ábi’dilṉe’ dahíí bighą.) ");
INSERT INTO apwNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nṉee łą́ą́go díí yati’íí daidezts’ąądá’ gádaanṉiid, Díń da’aṉii Bik’ehgo’ihi’ṉań binkááyú Na’iziidíí át’į́į́ lą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ła’íí gádaaṉii, Díń da’aṉii Christ nlįį lą́ą́. Ła’íí gádaaṉii, Ya’ Christ Gálileedí’ hígháhgo láń? ");
INSERT INTO apwNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiinííshą’ gáṉíí, Christ David hat’i’íí bits’ą́’dí’ goleeh, Béthlehem golzeedí’ hígháh, David golį́į́ lę́k’egee? ");
INSERT INTO apwNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Áík’ehgo áígee Jesus bighą nṉee iłts’ą́’kai. ");
INSERT INTO apwNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ła’ daabiłtsood hádaat’įį ndi doo daabiłtsood da. ");
INSERT INTO apwNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Aasiṉilíí okąąh yedaabik’ehi itisyú nadaandeehi ła’íí Phárisees daanlíni biłgo yaa nákaigo gádaabiłṉii, Nt’é bighą doo daahołtsood da? ");
INSERT INTO apwNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aasiṉilíí gádaabiłṉii, Doo ła’ nṉee díí nṉeehíí k’ehgo yałti’ da. ");
INSERT INTO apwNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Phárisees daanlíni gánádaabiłdo’ṉiid, Ya’ nohwíí ałdó’ nohwich’į’ na’deshch’a’ née? ");
INSERT INTO apwNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ya’ ła’ nant’án daanlíni dagohíí Phárisees daanlíni daabosdląą née? ");
INSERT INTO apwNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Áídá’ díí nṉeehíí begoz’aaníí doo yídaagołsį dahíí nchǫ’íí bee bá ha’odzii. ");
INSERT INTO apwNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodémus, Phárisees itah nlíni, (łah tł’é’yú Jesus yaa nyáá lę́k’e n’íí,) gádaabiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Bedaagosiil’aaníí k’ehgo ya’ nṉee dá doo daadihiits’į́hé, ła’íí dá doo ánát’įįłíí bídaagonlzįhé baa yáhiilti’ née? ");
INSERT INTO apwNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Áík’ehgo gánádaado’ṉiid, Ya’ ni ałdó’ Gálileedí’ nanṉaa née? Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí biyi’ díń’įį, áík’ehgo bígonłsįįh ndi at’éé: Bik’ehgo’ihi’ṉań binkááyú na’iziidi doo ła’ Gálileedí’ hígháh golzee da. ");
INSERT INTO apwNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Áídí’ nṉee dawa bigowąyú nnáheskai lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesus dził Olives golzeeyú óyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Dázhǫ́ t’ahbį da’ch’okąąh goz’ąąyú nádzáá lę́k’e, akú nṉee dawa baa íła’adzaa; áík’ehgo nezdaago biłch’ídaago’aah. ");
INSERT INTO apwNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Begoz’aaníí ye’ik’eda’iłchíhi hik’e Phárisees daanlíni biłgo isdzán ła’ baa yił hikai, áń nant’į’ naghaago bígozįįd lę́k’e; áík’ehgo isdzánhíí iłṉí’zhį’ ndaist’e’dá’, ");
INSERT INTO apwNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesus gádaayiłṉii, Iłch’ígó’aahíí, díí isdzánhíí nant’į’ naghaago, da’aṉii ánát’įįłgo bígozįįd. ");
INSERT INTO apwNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ágádaat’iiníí bił ndaats’inołṉe’ le’gá, ṉiigo Moses nohwee ngon’ą́ą́ ni’, begoz’áni biyi’: nihíí ánṉiiyúgo nt’é ńṉii? ");
INSERT INTO apwNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nayídaantaahgo ágádaayiłṉii, dáhagot’éégo izadaahilt’e’ daanzigo. Jesus hayaa adzaago bigan yee łeezh yiyi’yú k’e’eshchįį lę́k’e, doo yidezts’ąą da hik’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Dayúweh nahódaadiłkidgo Jesus hizį’go gádaabiłṉii, Nohwitahyú ła’ binchǫ’ da’ádįhíí ntsé idołṉe’. ");
INSERT INTO apwNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Áígee hayaa ánádzaago bigan yee łeezh yiyi’yú k’ená’eshchįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nṉee díí daidezts’ąądá’ binchǫ’ daagolííníí yídaagołsįįdgo, báyáńdí’ áníi nagháhííyú onáhezkai: áík’ehgo Jesus dasahn ch’íńtłizh, isdzán bádįhgee siziiníí biłgo. ");
INSERT INTO apwNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus hadag adzaago isdzán zhą́ sizįįgo yiłtsąągo yich’į’ hadzii, Isdzán, nṉee nchǫ’ daaniłṉiihíí hayú okai? Ya’ doo ła’ nṉee nił ch’ígonyį́į́ da? ");
INSERT INTO apwNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Isdzánhíí gábiłṉii, SheBik’ehń, doo hadíń da. Jesus gánábiłdo’ṉiid, Shíí ndi doo nił ch’ígonoshheeh at’éé da: ti’i, nchǫ’íí bee ánáo’ṉe’ hela’. ");
INSERT INTO apwNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Łah Jesus nṉee gánádaayiłdo’ṉiid, Shíí ni’gosdzáń biká’ nṉee begot’iiníí nshłįį: dahadíń shiké’ higaałń doo chagołheełyú higaał da doleeł, áídá’ ihi’ṉaa be’idindláádíí bíyéé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Phárisees daanlíni gádaabiłṉii, Dani zhą́ ádaa nagolṉí’; ádaa nagolṉí’íí doo da’aṉii da. ");
INSERT INTO apwNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus gábiłṉii, Dashíí ádaa nagoshṉi’ ndihíí ádaa nagoshṉi’íí da’aṉii: hadí’ níyááhíí ła’íí hayú déyááhíí bígonsįhíí bighą; áídá’ nohwihíí hadí’ níyááhíí ła’íí hayú déyááhíí doo bídaagonołsį da. ");
INSERT INTO apwNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nohwihíí nṉee k’ehgo zhą́ aayádaałti’; shihíí doo hadíń baa yashti’ da. ");
INSERT INTO apwNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Áídá’ shíí aayashti’yúgo, aayashti’íí da’aṉiihi: shíí doo dasahn aayashti’ dahíí bighą, shíí ła’íí shiTaa shinł’a’ń biłgo aayáhiilti’. ");
INSERT INTO apwNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Bedaagosoł’aaníí biyi’ nṉee naki dáłełt’éégo yaa nadaagolṉi’yúgo da’aṉii golzeego dahgoz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Dashíí ádaa nagoshṉi’, ła’íí shiTaa shinł’a’ń ałdó’ shaa nagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Áík’ehgo gádaabiłṉii, NiTaahíí hayú? Jesus gánádaabiłdo’ṉiid, Shíí doo shídaagonołsį da, shiTaa ndi doo bídaagonołsį da: shídaagonołsįyúgo shiTaa ałdó’ bídaagonołsį doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus zhaali iłch’į’nihi’ṉiił goz’ąą yuṉe’ aṉíí, da’ch’okąąh goz’ąą yuṉe’ iłch’ígó’aahgo: áídá’ doo hadíń biłtsood da ląą: bidizi’deehíí doo hwahá biká’ ngowáh dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus gánádaabiłdo’ṉiid, Shíí dahdisháh, ch’éh shiká daadeh’įį doleełgo t’ah nchǫ’go ánádaaht’įįłgo nanohṉe’ doleeł: hayú déyááyú doo nohkáh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jews daanlíni gádaaṉii, Hayú déyááyú doo nohkáh át’éé da, ṉiihííshą’, dabíí ádiziłdeego aṉii née? ");
INSERT INTO apwNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Áídí’ gádaayiłṉii, Nohwíí yáá bitł’ááhdí’ nahkai; shihíí yaaká’dí’ nashaa: nohwíí díí ni’gosdzáń biká’ nṉee daanohłįį; shihíí doo ni’gosdzáń biká’ nṉee nshłįį da. ");
INSERT INTO apwNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Áí bighą, T’ah nchǫ’go ánádaaht’įįłgo nanohṉe’, daanohwiłdishṉii: áń nshłiiníí doo daahohdląą dayúgo, t’ah nchǫ’go ánádaaht’įįłgo nanohṉe’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Áík’ehgo gánádaabiłdo’ṉiid, Hadíń lą́ą́ ánt’įį? Jesus gádaabiłṉii, Dantsé nohwił nagosisṉi’dá’ ánsht’ee daanohwiłdishṉii n’íí, da’áń ánsht’ee. ");
INSERT INTO apwNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","T’ah łą́ą́go nohwich’į’ hasdziih godziih, łą́ą́go nohwaa yádaashti’ doleeł: áídá’ shinł’a’ń da’aṉiigo, áń shił nagosṉi’íí zhą́ ni’gosdzáń biká’ nṉee baa bił nagoshṉi’. ");
INSERT INTO apwNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesus biTaa baa yałti’íí doo yídaagołsį da. ");
INSERT INTO apwNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesus gánádaabiłdo’ṉiid, Shíí, nṉee k’ehgo Niyááhíí, dahdaashołteehdá’, áń nshłįįhíí bídaagonołsį ndi at’éé, dashíí shínik’ehgo doo nt’é áshłe’ da; áídá’ shiTaa shił ch’ígon’ááníí bee yashti’. ");
INSERT INTO apwNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Shinł’a’ń t’ah bił nshłįį: shiTaa doo hwahá dasahndi yó’oshiłt’e’ da; dábik’ehn dá bił bik’ehyú ánásht’įįł. ");
INSERT INTO apwNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ágáṉíígo yałti’gee łą́ą́go daabosdląąd. ");
INSERT INTO apwNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jews daanlíni Jesus daayosdląądíí gádaayiłṉii, Shiyati’íí dayúweh bikísk’eh ádaanoht’eeyúgo da’aṉii shiké’ hikaahíí daanohłįį; ");
INSERT INTO apwNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Áík’ehgo da’aṉii ágot’eehíí bídaagonołsį doleeł, áídí’ da’aṉii ágot’eehíí ch’ídaanohwiṉííł. ");
INSERT INTO apwNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Gádaayiłṉii, Abraham hat’i’íí daandlíni ádaant’ee, doo hadíń bi’isna’ daasiidlįį da: áídá’ hagot’éégo ánṉíhi, Ch’ídaanohwide’ṉiił, nṉiihíí? ");
INSERT INTO apwNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus gádaabiłṉii, Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Dahadíń nchǫ’go ánát’įįłíí nchǫ’íí yisna’ nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Isna’ nliiníí doo dahazhį’ binant’a’ bigową yuṉe’ golį́į́ da: áídá’ biye’híí zhą́ dahazhį’ bigową yuṉe’ golį́į́. ");
INSERT INTO apwNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Áík’ehgo Bik’ehgo’ihi’ṉań biYe’ ch’ídaanohwizṉilyúgo, da’aṉiigo ch’ídaanohwi’des’ṉil. ");
INSERT INTO apwNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraham hat’i’i daanohłįįgo nohwígonsį; da’ágát’éé ndi daashizołhee hádaaht’įį, shiyati’íí doo hak’i nohwiyi’ bá goz’ąą dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Shíí shiTaa bits’ą́’dí’ bígoł’ąąhíí bee nohwich’į’ yashti’: nohwihíí nohwitaa bits’ą́’dí’ bídaagonoł’ąąhíí ánádaaht’įįł. ");
INSERT INTO apwNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Áídí’ gádaabiłṉii, Abraham bits’ą́’dí’ daadihe’ṉa’. Jesus gádaabiłṉii, Abraham bichągháshé daanohłįįyúgo Abraham at’ííníí k’ehgo ánádaaht’įįł doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Áídá’ k’adíí daashizołhee hádaaht’įį, shíí da’aṉii ágot’eehíí Bik’ehgo’ihi’ṉań bits’ą́’dí’ disiits’áni baa nohwił nagoshṉi’: díí doo Abraham ye’at’éé da ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nohwíí nohwitaa ánát’įįłíí k’ehgo ádaaht’įį. Áídí’ gádaabiłṉii, Néé nant’į’ na’ildeehíí doo bits’ą́’dí’ daagosiidlįį da; néé nohwiTaa dała’á, áí Bik’ehgo’ihi’ṉań. ");
INSERT INTO apwNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus gádaabiłṉii, Bik’ehgo’ihi’ṉań daanohwiTaa nlįįyúgo, nohwił daanshǫǫ doleeł ni’: Bik’ehgo’ihi’ṉań bits’ą́’dí’go niyááhíí bighą; doo dashínik’eh niyáá da, Bik’ehgo’ihi’ṉań shinł’a’. ");
INSERT INTO apwNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nt’é bighą’shiyati’íí doo bídaagonołsį da? Shiyati’íí doo ídaayełts’ąą hádaaht’įį dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Daanohwitaa, ch’iidn nant’án, áń hat’i’íí daanohłįį, áík’ehgo nohwitaa nchǫ’go hat’į́į́híí k’ehgo ádaaht’įį: dantsé godeyaadí’ nṉee naiłtseedi nlįį, bíí ła’íí da’aṉii ágot’eehíí doo nałinłtł’og da, da’aṉii ágot’eehíí doo ła’ biyi’ golį́į́ dahíí bighą. Łé’iłchoogo yałti’dá’ dabíí ye’at’éhi yee yałti’: łé’iłchóhi nlįįgo, łé’ichoohíí bitaa nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Áídá’ shíí da’aṉii ádishṉiihíí bighą doo daashohdląą da. ");
INSERT INTO apwNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hadíń ła’ dénchǫ’go ánásht’įįłíí ch’íshinoh’áah? Áídá’ da’aṉii ádishṉiiyúgo, nt’é bighą doo daashohdląą da? ");
INSERT INTO apwNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dahadíń Bik’ehgo’ihi’ṉań bíyééhíí Bik’ehgo’ihi’ṉań biyati’íí yídésts’ąą: Bik’ehgo’ihi’ṉań doo bíyéé daanohłįį dahíí bighą doo ídaayełts’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jews daanlíni gádaabiłṉii, Samáritan ńlíni, ch’iidn niyi’ golíni, daaniłn’ṉiihíí da’aṉii ádaan’ṉii shį ya’? ");
INSERT INTO apwNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus gáṉíí, Ch’iidn doo shiyi’ golį́į́ da; áídá’ shiTaa diniłsį, nohwihíí doo daashidinołsį da. ");
INSERT INTO apwNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nṉee daashidnłsiníí doo biká désh’įį da: dała’áńhíí zhą́ áí yiká déz’įį, áń aayánáltih doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Dahadíń shiyati’ yikísk’eh at’ééhíí, da’itsaahíí doo yo’įį da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jews daanlíni gánádaabiłdo’ṉiid, K’adíí nídaagosiilzįįd, ch’iidn niyi’ golį́į́híí. Abraham daztsąą, ła’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidíí nanezna’; áídá’ ni ánṉii, Dahadíń shiyati’ yikísk’eh at’ééhíí da’itsaahíí doo yolįh at’éé da, nṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ya’ ni nohwitaa Abraham daztsąą n’íí bitisgo áńt’éhi née? Bik’ehgo’ihi’ṉań binkááyú nada’iziidíí nanezna’ n’íí ałdó’: hadíń lą́ą́ ánsht’ee ńnzį? ");
INSERT INTO apwNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus gábiłṉii, Shíí ádiłdinszįyúgo, ádiłdinszįhíí doo nt’é da: shidi’dilzįhíí shiTaa at’éé; áń Bik’ehgo’ihi’ṉań daahohiikąąhń, daabiłdohṉii: ");
INSERT INTO apwNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Áídá’ nohwíí áń doo bídaagonołsį da; shíí zhą́ áń bígonsį: Doo áń bígonsį da, dishṉiiyúgo, nohwíí k’ehgo łé’ishchóhi yishłeeh: áídá’ shíí áń da’aṉiigo bígonsį, biyati’íí bikísk’eh ánsht’ee. ");
INSERT INTO apwNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nohwitaa Abraham n’íí shee hayiłkaahíí yiłtséhgo bił gozhǫ́ǫ́ ni’: áí yiłtsąądá’ bił gozhǫ́ǫ́ ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jews daanlíni gádaabiłṉii, Doo hwahá ashdladin nił łégódáh dadá’, hagot’éégo Abraham hí’į́į́ láń? ");
INSERT INTO apwNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus gádaabiłṉii, Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Abraham dabíntségo shíí ánsht’ee. ");
INSERT INTO apwNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Áík’ehgo tséé nádaayiheslaago daabołṉe’ nt’éégo Jesus bits’ąą ńdest’įįdgo, da’ch’okąąh goz’ąądí’ nṉee biyi’dí’ ch’ínádzaa. ");
INSERT INTO apwNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesus higaałyú nṉee biṉáá ágodįhgo gozlíni sidaago yiłtsąą lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bitsiłke’yu nabídaadiłkid, NohwiNant’a’, hant’é bighą díí nṉeehíí biṉáá ágodįhgo gozlįį? Hadíń nchǫ’go adzaa, díí nṉeehíí née, dagohíí bą́ą́ hik’e bitaa née? ");
INSERT INTO apwNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus gádaabiłṉii, Díí nṉehíí, ła’íí bą́ą́ hik’e bitaa doo nchǫ’go ádaadzaa da: áídá’ Bik’ehgo’ihi’ṉań áná’ol’įįłíí bee ch’í’ṉah alṉe’híí bighą at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","T’ah got’įįdá’ shinł’a’ń binasdziidíí áshłe’: tł’é’gohíí doo hadíń na’iziid da. ");
INSERT INTO apwNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","T’ah ni’gosdzáń biká’ nashaadá’ ni’gosdzáń biká’ nṉee begot’iiníí nshłįį. ");
INSERT INTO apwNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ágánṉiidá’ ni’zhį’ hadnzhéégo bizhígíí łeezh yił naidiziidgo nṉee biṉáá ágodinihíí biṉáágee yídezhizh, ");
INSERT INTO apwNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Gábiłṉiigo, Ti’i, tá’ńgisyú ńṉáh, túsikáni biyi’, Silóam holzéhi, (Hil’á’ golzeego ágolzéhi.) Áík’ehgo nṉeehíí tá’digisyú óyáá, áídí’ go’įįgo nadzá. ");
INSERT INTO apwNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nṉee bit’ahdí’ daagolííníí, ła’íí biṉáá ágodįhdá’ daabo’į́į́ n’íí gádaaṉii, Díí nṉeehíí ídókeedgo sidaa n’íí ya’? ");
INSERT INTO apwNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ła’íí gádaaṉii, Áń át’į́į́: ła’íí, Áń ga’ánolini at’į́į́, daaṉii: bíí, Shíí ásht’į́į́, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Áík’ehgo, Hagot’éégo niṉáá nágosdlįį? daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Gáṉíí, Nṉee, Jesus holzéhi, goshtł’ish áyíílaago, shiṉáá yídezhizhdá’ gáshiłnṉiid, Ti’i, tá’ńgis, túsikąąyú Silóam holzéhi: áík’ehgo ákú óyáágo ta’désgiz, áídí’ shiṉáá nágosdlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Áńhíí hayú? daabiłṉii. Doo bígonsį da, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nṉee biṉáá ágodįh n’íí Phárisees daanlíni yaa yił hikai. ");
INSERT INTO apwNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jews daagodnłsiníí bijįį Jesus goshtł’ish áyíílaago nṉee biṉáá nágosdlįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Phárisees daanlíni nabídaadiłkid, Hagot’éégo niṉáá nágosdlįį? Gádaayiłṉii, Jesus goshtł’ish shiṉáá yídezhizh, áídí’ ta’désgizgo gosh’įį násisdlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Phárisees daanlíni ła’ gádaaṉii, Díí nṉeehíí doo Bik’ehgo’ihi’ṉań bits’ą́’dí’hi da ląą, godilziníí bijįį doo godnłsį dahíí bighą. Ła’íí gádaaṉii, Hagot’éégo nṉee Bik’ehgo’ihi’ṉań doo yidnłsį dahíí godiyįhgo áná’ol’įįł? Áík’ehgo bighą iłts’ą́’kai. ");
INSERT INTO apwNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nṉee biṉáá ágodįh n’íí gánádaayiłdo’ṉiid, Nihíí niṉáá ánágodlaahíí nt’é biłnṉii? Bik’ehgo’ihi’ṉań binkááyú na’iziidi at’į́į́ biłdishṉii, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jews daanlíni nṉee biṉáá ágodįh n’íí biṉáá nágosdlįįhíí doo daayodląą dago bą́ą́ hik’e bitaa yiká ánṉiidgo, ");
INSERT INTO apwNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nayídaadiłkid, Ya’ díí nohwizhaazhé biṉáá ágodįhgo gozlį́į́ dohṉii n’íí née? Hagot’éégo go’įį k’adíí? ");
INSERT INTO apwNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bą́ą́ hik’e bitaa gádaabiłṉii, Díń nohwizhaazhé át’éégo bígonlzį, biṉáá ágodįhgo gozlįį ni’: ");
INSERT INTO apwNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","K’adíí hagot’éégo go’įį, hadíń biṉáá ánágodlaahíí doo bígonlzį da: áń goyąą silįį; nahódaadołkid: dabíí ádáyálti’ le’. ");
INSERT INTO apwNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bą́ą́ hik’e bitaa Jews daanlíni yédaaldzidhíí bighą ádaaṉii lę́k’e: dahadíń, Christ at’į́į́, ṉiigo baa nagolṉi’yúgo Jews ha’ánáłséhdí’ ch’élt’e’go iłk’idá’ ndaagoz’ąą lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Áí bighą bą́ą́ hik’e bitaa ágádaanṉiid, Áń goyąą silįį; nahódaadołkid. ");
INSERT INTO apwNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nṉee biṉáá ágodįh n’íí yiká ánádo’ṉiidgo, Bik’ehgo’ihi’ṉań zhą́ ba’ihéńnzį: díí nṉeehíí Bik’ehgo’ihi’ṉań doo yidnłsį dago bídaagonlzį, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nṉeehń gáṉíí, Bik’ehgo’ihi’ṉań doo yidnłsį da shįhíí, yidnłsį shįhíí doo bígonsį da: da’ágát’éé ndi dała’á zhą́ bígonsį, shiṉáá ágodįh n’íí, k’adíí gosh’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Phárisees daanlíni gánádaabiłdo’ṉiid, Hagot’éégo áníílaa? Hagot’éégo niṉáá ná ánágodlaa? ");
INSERT INTO apwNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nṉeehń gádaabiłṉii, Iłk’idá’ nohwił nagosisṉi’ ndi doo daashidołts’ąą da ni’: nt’é bighą nohwił nanágoshṉi’? Ya’ nohwíí ałdó’ biké’ hikaahíí daahłeeh née? ");
INSERT INTO apwNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Áídí’ dénchǫ’égo bich’į’ yádaałti’go gádaaṉii, Ni zhą́ biké’ higaałíí ńlį́į́ dagá; nééhíí Moses biké’ hikaahíí daandlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bik’ehgo’ihi’ṉań Moses yich’į’ yałti’ n’go bídaagonlzį: áídá’ díí nṉeehíí hadí’ naghaa shįhíí doo bídaagonlzį da. ");
INSERT INTO apwNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nṉeehń gánádaabiłdo’ṉiid, Hagot’éégo hadí’ naghaa shįhíí doo bídaagonołsį da, áídá’ shiṉáá shá ánágodlaa. ");
INSERT INTO apwNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Hadíń Bik’ehgo’ihi’ṉań doo daayidnłsį dahíí doo bídaayésts’ąą dago bídaagonlzį: áídá’ dahadíń Bik’ehgo’ihi’ṉań yokąąhíí, ła’íí áń dábił bik’ehgo ánát’įįłíí Bik’ehgo’ihi’ṉań bíyésts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ni’gosdzáń álzaadí’ yushdí’ godezt’i’go nṉee biṉáá ágodįhgo gozlįį n’íí go’įį nasdlį́į́ t’ah doo golzee da. ");
INSERT INTO apwNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Díí nṉeehíí doo Bik’ehgo’ihi’ṉań bits’ą́’dí’ dayúgo, doo nt’é áyóléh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Gádaabiłṉii, Nchǫ’íí zhą́ bił gosínilínihi, nohwił ch’ídaagonsh’aah nihó’ṉii née? Áík’ehgo Jews ha’ánáłséhdí’ ch’ídaabist’e’. ");
INSERT INTO apwNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ch’ídaabist’e’íí Jesus ya’ikonzįįdá’ baa nyáágo gábiłṉii, Ya’ Bik’ehgo’ihi’ṉań biYe’ hondląą née? ");
INSERT INTO apwNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nṉeehń gáṉíí, Hadíńhíí baa shił nagolṉi’, sheBik’ehń, áík’ehgo hoshdląą doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus gábiłṉii, Iłk’idá’ hí’į́į́, nich’į’ yałti’íí áń át’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nṉeehń, SheBik’ehń, noshdląą, ṉii. Áídí’ yoskąąd. ");
INSERT INTO apwNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus gáṉíí, Aayá’iti’híí bighą ni’gosdzáń biká’zhį’ niyáá, hadíí doo daago’įį dahíí daago’įį nádaadleehíí bighą; áídá’ hadíí daago’iiníí biṉáá ádaagodįh daaleeh. ");
INSERT INTO apwNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Áígee Phárisees daanlíni ła’ bit’ahyú nadaaziiníí díí daidezts’ąądá’ gádaabiłṉii, Ya’ néé ałdó’ nohwiṉáá ádaagodįh née? ");
INSERT INTO apwNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus gánádaabiłdo’ṉiid, Nohwiṉáá ádaagodįhyúgo nohwinchǫ’íí ádįh doleeł ni’: áídá’ k’adíí, Daagohiit’įį, daadohṉii; áík’ehgo nohwinchǫ’íí t’ah be’ádaanoht’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Dahadíń dibełį́į́ ha’ánáṉiłí ch’ígót’i’dí’ doo ha’ánádáh dadá’ łahyúgo yitisyú ha’ánádáhíí, áń in’įįhi dagohíí aayihi’ṉiiłi nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Hadíń ch’ígót’i’dí’ ha’ánádáhíí dibełį́į́ nanyoodi nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ch’íná’itį́h yaa sidaahń bá yó’o’itį́h; áń bidibełį́į́ yich’į’ aṉíígo daidíts’ag: dabíí bidibełį́į́ bizhi’ yee yich’į’ aṉíígo ch’íyihiṉiił. ");
INSERT INTO apwNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Dabíí bidibełį́į́ ch’íyihiṉiiłdá’, yádįh dahdigháh, áík’ehgo dibełį́į́ biké’ dahnádiłsééh: bizhiihíí yídaagołsįįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nṉee doo yídaagołsį dahíí doo yiké’ dahdikáh da, daazhógo bits’ą́’ dahnádiłséh; áń bizhiihíí doo yídaagołsį dahíí bighą’ ");
INSERT INTO apwNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Áí Jesus bił ch’ígó’aahgo ádaabiłnṉiid; áídá’ nt’é ṉiigo aṉii shįhíí doo bił ídaagozį da. ");
INSERT INTO apwNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesus gánádaabiłdo’ṉiid, Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Shíí ch’ígót’i’íí nshłįį, dibełį́į́ ha’áná’ṉiłgee. ");
INSERT INTO apwNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Dashíntsé híkaihíí dawa da’in’įįhíí ła’íí aadaayihi’ṉiiłíí daanlįį; áí dibełį́į́ doo daabidits’ag da. ");
INSERT INTO apwNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Shíí ch’ígót’i’íí nshłįį: hadíń shíí shinkááyú ch’ínyááhíí hasdádogaał, áík’ehgo ha’ánádáhdí’ ch’ínádáhgo da’iyąą doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","In’įįhíí in’įįhíí bighą nadáh, ła’íí na’iłtseedhíí bighą, dawahá da’ílíí yiłchiihíí bighą: shihíí ko’ihi’ṉa’ daagolį́į́ doleełhíí bighą niyáá, dázhǫ́ bitisyú ch’ída’izkaadyú ihi’ṉaahíí bee daach’ihiṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Shíí dibełį́į́ nanyoodíí nłt’éhi nshłįį: dibełį́į́ nanyoodíí nłt’éhi bi’ihi’ṉa’ ndi bidibełį́į́ yá nyiné’. ");
INSERT INTO apwNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Hadíí na’iziidíí, doo dibełį́į́ nanyoodíí nlįį dahíí, doo dibełį́į́ bíyéé dahíí, mą’cho higaałgo yo’įįdá’ dibełį́į́ yits’ą́’yúgo nádilwo’i; áík’ehgo mą’chohíí dibełį́į́ ła’ yił ndaadeeł, ła’ihíí náhołsééh. ");
INSERT INTO apwNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na’iziidíí daazhógo na’iziidhíí bighą, dibełį́į́ doo yaa bił goyéé dahíí bighą yits’ą́’ nádilwo’. ");
INSERT INTO apwNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Shíí dibełį́į́ nanyoodíí nłt’éhi nshłįį, shidibełį́į́ bídaagonsį, shíyééhíí shídaagołsį. ");
INSERT INTO apwNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ShiTaa shígółsįhíí k’ehgo shíí ałdó’ shiTaa bígonsį: shi’ihi’ṉa’íí dibełį́į́ bá ndiishné’. ");
INSERT INTO apwNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Shidibełį́į́ łahyúgo ha’ánsiṉil: áí ałdó’ bił nánishkáh, áí shizhiihíí daidiits’į́h doleeł; áí dała’ázhį’ nádleeh, dibełį́į́ nanyoodíí dała’á hileeh. ");
INSERT INTO apwNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Shi’ihi’ṉa’íí nniishné’, nádidiishné’ doleełgohíí bighą shiTaa bił nshǫǫ. ");
INSERT INTO apwNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Doo hadíń shits’ą́’ náidoné’ át’éé da, dashínik’eh ndiishné’. Dashíí shinawodíí bee ndiishné’, dashíí shinawodíí bee nádidiishné’. Díí shiTaa yee shá ngon’ą́ą́ ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Díí yati’híí bighą Jews daanlíni iłts’ą́’kai. ");
INSERT INTO apwNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Łą́ą́go gádaanṉiid, Ch’iidn biyi’ golį́į́, biini’ ádįh; nt’é bighą hídaayołts’ąą? ");
INSERT INTO apwNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ła’íí gádaanṉiid, Ch’iidn biyi’ golííníí doo díí k’ehgo yałti’ da go’į́į́. Ya’ ch’iidn nṉee biṉáá ágodiníí yiṉáá yá ánágodle’ née? ");
INSERT INTO apwNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Haigo Jerúsalemgee da’ch’okąąh goz’aaníí Bik’ehgo’ihi’ṉań bá its’ágót’ą́ą́ bee bíná’goṉiihgo da’idąągee ngonyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Da’ch’okąąh goz’ąągee Solomon bich’ínágohin’ą́ą́ yuṉe’ Jesus anádaał lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jews daanlíni baa íła’adzaago gádaabiłṉii, Da’os’ahzhį’ lą́ą́ nohwił nagolṉí’go áńt’ee? Christ ńlį́į́yúgo dabígózįgo nohwił nadaagolṉí’. ");
INSERT INTO apwNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus gádaabiłṉii, Nohwił nadaagosisṉi’ ni’, ndi doo daashohdląą da: shiTaa bizhi’ bee áná’esh’įįłíí dabígózįgo yee shaa nagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Áídá’ doo shidibełį́į́ daanohłįį dahíí bighą doo daashohdląą da. ");
INSERT INTO apwNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Shidibełį́į́ shizhiihíí daidits’ag, áí bídaagonsį, áí shiké’ anákah: ");
INSERT INTO apwNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ihi’ṉaa doo ngonel’ąą dahíí baa daasiiné’; doo da’ílíí daaleeh dago doo hadíń shilák’e hayoṉiił at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ShiTaa shaiṉilíí dawa yitisgo at’éhi nlįį; doo hadíń shiTaa bilák’e hayiṉiił yínel’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Shíí hik’e shiTaa biłgo dała’á ndlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jews daanlíni tséé nádaayiheslaa, yee daabołṉe’go. ");
INSERT INTO apwNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus gádaabiłṉii, ShiTaa bits’ą́’dí’ nłt’éégo áná’ol’įįłíí doo ałch’ídn nohwił ch’í’ṉah ashłaa da; hadííhíí bighą ńdaashidołṉe’? ");
INSERT INTO apwNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jews daanlíni gádaabiłṉii, Nłt’éégo áná’íl’įįłíí bighą doo ńdaaninlṉe’ da; áídá’ Bik’ehgo’ihi’ṉań dénchǫ’go baa yáńłti’híí bighą; ni nṉee ńlíni Bik’ehgo’ihi’ṉań áná’ńl’įįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus gádaabiłṉii, Dilzini daanohłįį nohwiłdéṉiid, golzeego nohwá begoz’aaníí biyi’ bek’e’eshchįį shį ya’? ");
INSERT INTO apwNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Bik’ehgo’ihi’ṉań biyati’ baa daasné’íí nṉee dilzini daiłṉiigo yozhiiyúgo, Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí doo k’ihzhį’ ngot’ąą dago; ");
INSERT INTO apwNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ya’ shíí shiTaa its’ą́’shíńłtį́į́go ni’gosdzáń biká’zhį’ nkeshinł’a’íí, Bik’ehgo’ihi’ṉań nchǫ’go baa yáńłti’, daashiłdohṉii née; Bik’ehgo’ihi’ṉań biYe’ nshłįį, dishṉiihíí bighą? ");
INSERT INTO apwNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ShiTaa ánát’įįłíí k’ehgo doo ánásht’įįł dayúgo, doo daashohdląą da. ");
INSERT INTO apwNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Áídá’ be’ánásht’įįłyúgo, doo daashohdląą da ndi, ánásht’įįłíí daahohdląą; áí bee shiTaa shiyi’ golį́į́híí, ła’íí shiTaa biyi’ gonshłįįhíí bídaagonołsį, ła’íí daahohdląą doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Áí bighą daabiłtsoodgo ch’éh ánáádaabił’įį; ndi bits’ą́’ hach’iyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Áídí’ Jesus Jórdan túńlííníí hanaayú onaanádzaa, John dantsé baptize ágólaa goz’ąązhį’; akú naghaa. ");
INSERT INTO apwNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nṉee łą́ą́go baa heskaigo gádaaṉii, John doo godiyįhgo áná’ol’įįłíí áyíílaa da: ndi John díí nṉeehíí yaa nagolṉi’ n’íí dawa da’aṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Áík’ehgo áígee łą́ą́go daabosdląąd. ");
INSERT INTO apwNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Béthany golzeegee nṉee ła’, Lázarus holzéhi, nṉiih lę́k’e, áí kįh gozṉilgee Mary ła’íí bik’isn Martha daagolį́į́. ");
INSERT INTO apwNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Áń Maryhíí Jesus ik’ah yik’i yaa yiziidgo bitsizíl bee bikee yá k’eyiłdee n’íí, áń bilah Lázarus holzéhi nṉiih.) ");
INSERT INTO apwNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázarus bilahkíí Jesus yich’į’ yati’ bá ot’ą́ą́, NohweBik’ehń, nił nzhóni nṉiih, daayiłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesus yidezts’ąądá’ gáṉíí, Díí nṉiihíí doo datsaahgo at’éé da, áídá’ Bik’ehgo’ihi’ṉań ízisgo ye’at’ééhíí ch’í’ṉah álṉéhgo ágot’įį, ła’íí Bik’ehgo’ihi’ṉań biYe’ ízisgo ye’at’ééhíí ch’í’ṉah hileeh doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus, Martha hik’e bik’isn ła’íí Lázarus biłgo bił daanzhǫǫ. ");
INSERT INTO apwNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lázarus nṉiihgo ya’ikonzįįdá’, da’akú sidaago naki bee náyiskąą lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Áí bikédí’go Jesus bitsiłke’yu gádaayiłṉii, Judéayú náádookáh. ");
INSERT INTO apwNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Áídá’ bitsiłke’yu gádaabiłṉii, NohwiNant’a’, da’ániidégo Jews daanlíni nił ndaaziłṉé’go hádaat’įį ni’; ndi ya’ akú nádíńdzaa née? ");
INSERT INTO apwNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus gánádaabiłdo’ṉiid, Ya’ dała’á jįį doo nakits’ádah łénádihikos da née? Dahadíń jįįhíí yiyi’ naghaayúgo, doo hayaa nageeh at’éé da, díí ni’gosdzáń biká’ begot’iiníí yo’įįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Dahadíń tł’é’yú higaałyúgo hayaa nageeh, biyi’ yuṉe’ begot’iiníí ádįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ánṉiidíí bikédí’go gánádaayiłdo’ṉiid, Nohwit’eké Lázarus iłhosh; ch’ínánsiidyú déyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bitsiłke’yu gádaabiłṉii, NohweBik’ehń, Lázarus iłhoshyú nłt’éé nádleeh gádnii. ");
INSERT INTO apwNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesus, Lázarus daztsąą, ṉiigo aṉíí: áídá’ bitsiłke’yuhíí hánáyołgo iłhoshgo áyiłṉii lą́ą́ daanzį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jesus áníita ch’í’ṉah ádaagozlaa, Lázarus daztsąą, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Da’ohdląą doleełhíí bighą doo ákú nashaa dahíí nohwá shił gozhǫ́ǫ́; ndi haląą bich’į’yú dookáh. ");
INSERT INTO apwNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas, Dídymus holzéhi, itsiłke’yu yił daanlíni gádaayiłṉii, Néé ałdó’ akú dookáh, Jesus bił nadaan’ṉe’ doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lázarus iłk’idá’ łe’sitįįgo dį́į́’i bee yiskąąyú Jesus nyáá lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerúsalemdí’ nakidn dahgostǫ’yú shį Béthany goz’ąą: ");
INSERT INTO apwNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Áídí’ Jews daanlíni łą́ą́go Martha hik’e Mary bilah n’íí bighą bidag yádaałti’go baa heskai. ");
INSERT INTO apwNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martha Jesus higháhgo ya’ikonzįįgo dagoshch’į’ yich’į’ ch’ínyáágo yaa nyáá, Mary kįh yuṉe’ sidaadá’. ");
INSERT INTO apwNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha Jesus gáyiłṉii, SheBik’ehń, kú síńdaayúgo shilah doo daztsąą da doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","K’ad ndi dant’éhéta Bik’ehgo’ihi’ṉań bíhónkeedíí naa yiné’go bígonsį. ");
INSERT INTO apwNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus gábiłṉii, Nilah naadidodaał. ");
INSERT INTO apwNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha gábiłṉii, Nnágodzaahíí bijįį nách’idikáhgee naadidodaałgo bígonsį. ");
INSERT INTO apwNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus gábiłṉii, Shíí shilahyú nṉee naadidokaah, shíí ihi’ṉaahi nshłįį: dahadíń shodląąyúgo daztsąą ndi, hiṉaa nádodleeł: ");
INSERT INTO apwNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Dahadíń hiṉaago shodlaaníí doo datsaah at’éé da. Ya’ díí hondląą née? ");
INSERT INTO apwNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha gábiłṉii, Ha’oh, sheBik’ehń: Christ, Bik’ehgo’ihi’ṉań biYe’ ni’gosdzáń biká’ hígháhi ńlį́į́go hoshdląą. ");
INSERT INTO apwNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Gánṉiidá’ onádzaago dant’éhego bik’isn Mary gáyiłṉii, Iłch’ígó’aahíí kú nyáágo nokéed. ");
INSERT INTO apwNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mary áí yidezts’ąądá’ dagoshch’į’ nádiidzaago yich’į’ oyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus Martha baa nyáá n’íígee t’ah sidaago, doo hwahá kįh gozṉilyú hígháh da. ");
INSERT INTO apwNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jews daanlíni bidag yádaałti’go kįh yuṉe’ yił naháztąą n’íí Mary hwéheego nádiidzaago ch’ínyááhíí daayo’įįgo yiké’ dahiskai, Lázarus łe’sitįįyú hichagyú deyaa shį, daaṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mary, Jesus sidaayú ńyáádá’ yiłtsąągo yiyahzhį’ hayaa adzaa gáṉíígo, SheBik’ehń, kú síńdaayúgo shilah doo daztsąą da doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesus Mary ła’íí Jews daanlíni yił hikai n’íí biłgo daachago yo’įįdá’ biyi’siziiníí doo bił gozhǫ́ǫ́ da lę́k’e, ");
INSERT INTO apwNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Áík’ehgo gáṉíí, Hayú ndaasołtįį láń? NohweBik’ehń, yushdé’ ákú díń’įį, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus hichag lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jews daanlíni, Dázhǫ́ bił nzhǫǫ lę́k’e! daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Áídí’ ła’ gánádaado’ṉiid, Nṉee biṉáá ágodini déz’įįgo ánáyiidlaa n’íí, díí nṉee ałdó’ doo datsaah dago áyíílaa doleeł láń shį ya’? ");
INSERT INTO apwNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus bidayi’ chad nadesdzaago, Lázarus łe’sitįįyú ńyáá. Tsébii’i’áń yuṉe’ sitįį, tséé biṉásgee daaden’ą́ą́go. ");
INSERT INTO apwNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus gáṉíí, Tséé yó’odaah’aah. Nṉee daztsaaníí bilah Martha gábiłṉii, SheBik’ehń, k’adíí nłchǫ’ silįį go’į́į́, dį́į́’i yiskąądá’ daztsąą n’íí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus gábiłṉii, Ondląąyúgo Bik’ehgo’ihi’ṉań bits’ą́’dí’ ízisgo ágot’eehíí hįłtséh doleeł, ya’ doo ágániłdéṉiid da lá née? ");
INSERT INTO apwNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Áík’ehgo daztsaaníí sitįįgee tséé biṉásgee daaden’aaníí yó’odaiz’ąą. Jesus hadag déz’įįdá’gáṉíí, ShiTaa, shidints’agíí na’ihénsį. ");
INSERT INTO apwNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Dábik’ehn shidints’ago bígonsį, ndi kú nṉee nadaazįhíí bighą ádéṉiid, shinł’a’íí daayodląą doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ágánṉiidá’ adįįd yiká áṉíí, Lázarus, aadí’ ch’íńṉáh, yiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nṉee daztsąą n’íí bigan ła’íí bikee nadik’ą’ bik’ídaadesdizgo; binii ałdó’ nadik’ą’ bik’ídesdizgo ch’ínyáá. Jesus gádaabiłṉii, K’eda’oh’ad, áík’ehgo dowáh. ");
INSERT INTO apwNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Áídí’ Jews daanlíni łą́ą́go Mary yił hikai n’íí, Jesus adzaahíí daayo’įįgo daabosdląąd lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Áídá’ ła’, Phárisees daanlíni yich’į́’ okaigo, Jesus ánát’įįdíí yaa yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Áík’ehgo okąąh yedaabik’ehi itisyú nadaandeehi hik’e Phárisees daanlíni biłgo nṉee yánádaaltihíí íła’ádaizlaago gádaayiłṉii, Hago lą́ą́ ádaahi’ṉe’? Díí nṉeehíí godiyįhgo áná’ol’įįłíí łą́ą́go ánát’įįł. ");
INSERT INTO apwNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Dayúweh díí k’ehgo ánát’įįłyúgo nṉee dawa dánko daabodląąh doleełi at’éé; ła’íí Romans daanlíni nałsééhgo nohwi’okąąh goz’aaníí ła’íí nohwini’íí nohwaa daagohet’aah. ");
INSERT INTO apwNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Áídí’ áí ádaanṉiidíí ła’, Cáiaphas holzéhi, áí łegodzaahíí biyi’ okąąh yebik’ehi da’tiséyú sitíni gádaabiłnṉiid, Doo nt’é bídaagonołsį da, ");
INSERT INTO apwNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nṉee dała’á nṉee dawa yá datsaahgo zhą́ nzhǫǫ, áík’ehgo zhą́ Jews daanlíni dawa doo da’ílíí hileeh da, áí doo nohwił bídaagozį da lą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Díí doo dabínik’ehgo aṉíí da: áí łegodzaahíí biyi’ okąąh yebik’ehi da’tiséyú sitįįgo, Jesus Jews daanlíni yá datsaah doleełíí dabíntsé yaa nagolṉi’; ");
INSERT INTO apwNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Doo Jews daanlíni zhą́ bá datsaah da, ndihíí Bik’ehgo’ihi’ṉań bichągháshé dawa iłts’ą́’yú nadaakaihíí dała’ázhį’ ánálṉéhgo ałdó’ bá datsaah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Áí bijįįdí’ godezt’i’go hagot’éégo Jesus daayiziłheehíí yee nadaagoshchįį. ");
INSERT INTO apwNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Áí bighą Jesus doo dayúweh Jews daanlíni bitah ch’í’ṉah naghaa da; ndi áídí’ da’igolį́į́yú ba’ashhahgee goz’áni biyi’ kįh gozṉil Éphraim golzeeyú óyáá, áígee bitsiłke’yu yił naháztąą. ");
INSERT INTO apwNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Bitis‐hagowáh n’íí bee bíná’godiṉíhgo Jews da’iyąąhíí bich’į’ goldohdá’, Jews daanlíni łą́ą́go okąąh zhiṉéégo iłch’į’ ádaach’idilṉe’híí bighą ił’anidí’ Jerúsalem yúdag oheskai. ");
INSERT INTO apwNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Da’ch’okąąh goz’ąą yuṉe’ nadaazį’go Jesus yiká daadéz’įįgo gádaałiłdi’ṉii, Nt’é daanohsį, da’idąąyú híṉáh doleeł shį ya’? ");
INSERT INTO apwNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Okąąh yedaabik’ehi itisyú nadaandeehi ła’íí Phárisees daanlíni, dahadíń Jesus hayú naghaahíí yígółsįyúgo bił nadaagolṉi’go yá ndaagoz’ąą, daayiłtsoodhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bitis‐hagowáh n’íí bee bíná’godiṉíhzhį’ gostáń yiłkaah godziihdá’ Jesus Béthanyú ńyáá, Lázarus daztsąądí’ náyihilṉa’ n’íí golį́į́yú. ");
INSERT INTO apwNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Áígee o’i’ą́ą́yú bá áda’ch’izlaago Martha koch’į’ ndaahazkąą, Lázarus itah bił da’ch’iyąą lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mary ik’ah łáń ílíni, spikenard holzéhi, dała’á dahdidleego Jesus bikee biká’zhį’ yaa yiziidgo bitsizíl yee k’eyiłdée: kįh yuṉe’ ik’ah łikągolchiníí dahot’éhé godideznag. ");
INSERT INTO apwNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Áídá’ Judas Iscáriot, Simon biye’, Jesus bitsiłke’yu itah nlíni, ch’íbido’aałíí gáṉíí, ");
INSERT INTO apwNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Zhaalihíí tét’iyéhíí bitah’i’ṉiihíí bighą nt’é bighą díí ik’ah doo taagi gonenadín penny izlįįgo nahazṉii da? ");
INSERT INTO apwNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Díí áṉííhíí doo tédaat’iyéhíí yaa bił goyéégo aṉii da; ndi in’įįhi nlįįhíí bighą aṉii, bestso bizis nayi’aago bestso biyi’ odaach’ihiłkaadíí náyihiṉiił. ");
INSERT INTO apwNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesus gáṉíí, Ch’ík’eh at’į́į́: łeeh shi’dilteehíí bijįį doleełhíí bighą da’áík’ehgo nainé’ nzhǫǫ. ");
INSERT INTO apwNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tédaat’iyéhíí dábik’ehn nohwitahyú nadaakai; shihíí doo dábik’ehn nohwitahyú nashaa da doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jews daanlíni łą́ą́go Jesus ákú naghaago yídaagołsįgo baa náńłsą́ą́, doo dá Jesus zhą́ bighą da, Lázarus daztsąądí’ náyihilṉa’ n’íí daayiłtséhíí bighą ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Áídá’ okąąh yedaabik’ehi itisyú nadaandeehi Lázarus ałdó’ zideego doleełíí yaa nadaagoshchįį; ");
INSERT INTO apwNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Bíí bighą Jews daanlíni łą́ą́go Jesus daayosdląądgo bits’ą́’ daheskaihíí bighą zideego hádaat’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Áí iskąą hik’e nṉee łą́ą́go da’idąąyú híkaihíí Jesus Jerúsalemyú hígháhgo ya’ikodaanzįįdá’, ");
INSERT INTO apwNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ch’il, palm holzéhi, bits’ádaaz’aahíí daayoṉiłgo, yidááhzhį’ deskaigo nádaadidilghaazhgo gádaaṉii, Hosánna: Israel hat’i’íí biNant’a’ nlíni, Bik’ehgo’ihi’ṉań bizhi’ yee higaałíí bits’ą́’dí’ gózhǫ́ǫ́ le’. ");
INSERT INTO apwNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus túlgayé bizhaazhé yaa nyáágo yiká’ dahnezdaa; dá bek’e’eshchiiníí k’ehgo, ");
INSERT INTO apwNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Doo nénldzid da, Sion bizhaazhé ńlíni: níńł’įį, niNant’a’ higaał, túlgayé bizhaazhé yiká’ dahsdaago, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jesus bitsiłke’yu dantségee doo bił ídaagozį da: ndi Jesus ízisgo ye’at’ééhíí ch’í’ṉah ágolzaadá, díí bak’e’eshchįį n’íí ła’íí ábi’dilzaahíí yínádaalṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesus Lázarus daztsąądí’ náyihilṉa’go tsébii’i’áńdí’ ch’íńṉáh yiłnṉiid n’dá’ nṉee biṉááł ánágot’įįł n’íí yaa nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Godiyįhgo ágodzaahíí ya’ikodaanzįįhíí bighą nṉee Jesus yidááhzhį’ onałsą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Áík’ehgo Phárisees daanlíni gádaałiłdi’ṉii, Doo hagot’éégo ładaahodle’go da ląą; daadeh’į́į́, ni’gosdzáń biká’ nṉee dawa biké’ dahnádnłsą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nṉee Greeks daanlíni ła’ itah náńłsą́ą́, da’idąągee da’ch’okąąhyú. ");
INSERT INTO apwNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Áí Philip yaa hikai, Gálilee biyi’ Bethsáida golzeedí’ gólíni, áík’ehgo gádaabiłṉii, Jesus daahihiiltséh hádaahiit’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip Andrew yił nagolṉi’yú óyáá: Andrew, Philip yił o’áázhgo Jesus yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus gádaabiłṉii, Shíí, nṉee k’ehgo Niyááhíí, ízisgo be’ánsht’eehíí ch’í’ṉah hileehíí bee biká’ ngonyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Tł’oh nagháí biyigé doo łeezh biyi’ onehezdeego daztsąą dayúgo da’ágát’éé ńt’éé: áídá daztsąąyúgo zhą́ binest’ą’ łą́ą́ hileeh. ");
INSERT INTO apwNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Dahadíń bi’ihi’ṉa’ bił ilį́į́híí bi’ihi’ṉa’ bits’ą́’ da’ílíí hileeh; áídá’ dahadíń díí ni’gosdzáń biká’gee bi’ihi’ṉa’ doo bił ilį́į́ dahíí ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doo. ");
INSERT INTO apwNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Dahadíń shá na’iziidyúgo shiké’ higaał le’; hayú nashaayú ákú shá na’iziidíí ałdó’ naghaa doleeł: dahadíń shá na’iziidíí shiTaa bidnłsįhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Shiyi’sizíni doo bił aṉii da k’adíí; nt’éshą’ dishṉiih? ShiTaa, díí shich’į’ ágoṉéhíí bits’ą́’ hasdáshíńłteeh, dishṉiih née? Dah, díí shich’į’ ágoṉéhíí bighą niyááhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ShiTaa, ízisgo nizhi’íí ch’í’ṉah ánle’. Áík’ehgo yaaká’dí’ hadziihíí gánṉiid, Iłk’idá’ ízisgo nizhi’íí ch’í’ṉah áshłaa ni’, áík’ehgo ch’í’ṉah ánánáshdle’. ");
INSERT INTO apwNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nṉee bit’ahgee nadaaziiníí ła’ áí daidezts’ąągo gádaaṉii, Ides’ṉih: ła’íí gádaaṉii, Bik’ehgo’ihi’ṉań binal’a’á yaaká’dí’hi bich’į’ hadzii. ");
INSERT INTO apwNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus gáṉíí, Díí hadziihíí doo shíí shighą da, nohwíí nohwighą ánṉiid. ");
INSERT INTO apwNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","K’adíí díí ni’gosdzáń biká’ ágot’eehíí baa yá’iti’: áík’ehgo ni’gosdzáń binant’a’ ch’ídolt’eeł. ");
INSERT INTO apwNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Shíí ni’dí’ ts’ídag dahshidi’diiltįįyúgo nṉee dawa ích’į’go ashdléh. ");
INSERT INTO apwNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hagot’éégo datsaah doleełíí bebígózįhíí bighą ágánṉiid. ");
INSERT INTO apwNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nṉee gánádaado’ṉiid, Begoz’aaníí biyi’, Christ dahazhį’ golį́į́, golzeego néé daasidiits’ąą: nt’é bighą, Nṉee k’ehgo Nyááhíí ts’ídago dahbidi’dolteeł, nṉii áídá’? Nṉee k’ehgo Nyááhíí nṉiihíí hadíń áłnṉii? ");
INSERT INTO apwNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus gádaabiłṉii, Be’idindláádíí dét’įhézhį’ t’ah nohwá begot’įį. Be’idindláádíí t’ah golį́į́dá’ bee nahkai, dahyúgo godiłhiłíí nohwitis hileeh: dahadíń godiłhiłyú naghaahíí hayúgo higaałíí doo yígółsį da. ");
INSERT INTO apwNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Be’idindláádíí t’ah nohwá begot’įįdá’, be’idindláádíí daahohdląą, áík’ehgo idindláádíí bichągháshé daadołeeł. Jesus díí yee hadziidá’ yits’ą́’ ńyáágo yits’ąą nádest’įįd lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Godiyįhgo áná’ol’įįłíí łą́ą́go biṉááł áyíílaa ndi t’ah doo daabodląą da: ");
INSERT INTO apwNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Esáias, Bik’ehgo’ihi’ṉań binkááyú na’iziidi gánṉiid n’íí begolṉe’híí bighą ágodzaa, NohweBik’ehń, nadaagosiilṉi’íí hadíń yosdląąd? Ła’íí hadíń nohweBik’ehń bigan binawodíí bił ch’í’ṉah alzaa? ");
INSERT INTO apwNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Áí bighą doo da’odląą da, Esáias gánádo’ṉiidhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Biṉáá ádaagodįhgo, ła’íí bijíí daantł’izgo áyíílaa; dahyúgo biṉáá yee daayo’įį, ła’íí bijíí bee bił ídaagozį, áík’ehgo shich’į’ ádaaṉe’go nádaasziih doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","NohweBik’ehń bits’ą́’idindláádíí yo’įįdá’ yaa yałti’go Esáias ágánṉiid lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Da’ágát’éé ndi nant’án daanlíni łą́ą́go Jesus daayosdląąd ndi Phárisees daanlíni yédaaldzidgo doo ch’í’ṉah yaa nadaagolṉi’ da, Jews ha’ánáłséhdí’ ch’ínohwidinedzoodhi at’éé dánko daanzįgo: ");
INSERT INTO apwNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bik’ehgo’ihi’ṉań bił nzhooníí doo dázhǫ́ hádaat’įį dadá’ nṉee bił nzhooníí zhą́ itisgo hádaat’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus hadįįd hadziigo gánṉiid, Dahadíń shodląąhíí doo shíí zhą́ shodląą da, áídá’ shinł’a’ń ałdó’ yodląą. ");
INSERT INTO apwNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hadíń sho’iiníí shinł’a’ń yo’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Be’idindláádíí nshłįįgo ni’gosdzáń biká’zhį’ niyáá, dahadíń shodląąhíí doo godiłhiłyú naghaa le’ at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Dahadíń ádishṉiihíí yidits’agdá’ doo yikísk’eh at’éé dahíí, áń doo baa yashti’ da: ni’gosdzáń biká’ nṉee doo baa yashti’go niyáá da, hasdáhishṉiiłgo niyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Dahadíń doo háshit’įįgo shiyati’ doo nágodi’aah dahíí baa yałti’íí gólį́į́: yati’ bee yásíłti’íí nnágodzaahíí bijįį baa yałti’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Doo dashínik’eh yásíłti’ da, shiTaa shinł’a’ń nt’é dishṉiigo yashti’íí, nt’é dishṉiigo hasdziihíí shá ngon’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Díí bígonsį, hadíń biyati’ bikísk’eh at’ééhíí ihi’ṉaa doo ngonel’ąą dahíí yee hiṉaa doleeł: áík’ehgo shiTaa áshiłṉiihíí bikísk’eh yashti’. ");
INSERT INTO apwNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bitis‐hagowáh n’íí bee bíná’godiṉíhgo da’idąąhíí dabíntsé, Jesus ni’gosdzáń yits’ą́’ biTaa yich’į’ nádiidáhíí biká’ ngonyáágo yígółsįdá’, ni’gosdzáń biká’ biké’ hikaahíí bił nzhǫǫgo dángonyáázhį’ bił nzhǫǫ. ");
INSERT INTO apwNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","O’i’ą́ą́yú da’ch’iyąądá’ Simon biye’, Judas Iscáriot holzéhi, Jesus ch’íbidi’aahgo iłk’idá’ ch’iidn nant’án natsíbiłkeesgo ábíłsį; ");
INSERT INTO apwNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus biTaa dawa baidin’ą́ą́go yígółsį, ła’íí Bik’ehgo’ihi’ṉań yits’ą́’dí’ ńyáá, Bik’ehgo’ihi’ṉań yich’į’ nádesdzaago ałdó’ yígółsį; ");
INSERT INTO apwNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Áík’ehgo da’iyąądí’ nádiidzaago iká’ bi’ííhíí ídaa yidiltsooz; áídí’ niibek’e’ildéhé náidnłtsoozgo ídináisti’. ");
INSERT INTO apwNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Betádígisé biyi’zhį’ tú yaa yiziidgo, bitsiłke’yu bikee yá tádaizgizdí’ niibek’e’ildéhé binasti’ n’íí bee yá k’edaayiłdéh nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Áídí’ Simon Peter baa gonyáágo gábiłṉii, SheBik’ehń, ya’ shikee shá tánángis née? ");
INSERT INTO apwNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus gábiłṉii, Nt’é bighą asht’ííníí k’adyúgo doo bígonłsį da, ndi bígonłsįįh ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter gábiłṉii, Shikee doo shá tánáogis at’éé da. Jesus gánábiłdo’ṉiid, Nikee doo ná tásígiz dayúgo, doo nił gonsht’įį da. ");
INSERT INTO apwNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter gábiłṉii, SheBik’ehń, doo shikee zhą́ shá tánángis da, shigan hik’e shitsits’in ałdó’ shá tánángis. ");
INSERT INTO apwNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus gábiłṉii, Dahadíń ténáltłi’íí bikee zhą́ táyigis bik’eh, áík’ehgo dásizįį nt’éégo tanásgiz: nohwíí tádaanohwidesgiz, ndi doo dánohwigha da. ");
INSERT INTO apwNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Hadíń ch’íbido’aałíí yígółsįhíí bighą ágánṉiid, Doo dánohwigha tádaanohwidesgiz da. ");
INSERT INTO apwNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ąął bikee yá tádaizgizgo iká’ bi’ííhíí ánágodlaa, áídí’ dahnánezdaago gádaabiłṉii, Nohwá ásdzaahíí bídaagonołsį née? ");
INSERT INTO apwNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Iłch’ígó’aahíí ła’íí nohweBik’ehń daashiłdohṉii: da’áígee ádaadohṉii áí; áń nshłįįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Shíí nohweBik’ehń ła’íí nohwił ch’ígó’aahíí nshłíni nohwikee nohwá tádaasigizi: áík’ehgo nohwíí ałdó’ nohwikee łátádaahgisgo dábik’eh. ");
INSERT INTO apwNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Be’oł’įį doleełíí nohwiṉááł áshłaa, áík’ehgo nohwíí ałdó’ ágádaaht’įį le’. ");
INSERT INTO apwNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Na’iziidíí doo binant’a’ yitisgo at’éé da; hadíń hil’a’íí binł’a’íí doo yitisgo at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Díí bídaagonołsįgo, be’ánádaaht’įįłyúgo nohwił daagozhǫ́ǫ́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Doo dánohwigha nohwaa yashti’ da: hadíí hanohwiṉilíí bígonsį: ndi Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí begolṉe’ doleełhíí bighą, Hadíń báń bił hishaaníí shich’į’ got’įįh. ");
INSERT INTO apwNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Doo hwahá begolṉe’ dadá’ baa nohwił nagoshṉi’, áík’ehgo be’ágodzaago da’áń nshłįįgo daahohdląą doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Dahadíń deł’a’ń náidnłtįįyúgo, shíí ałdó’ náshidiłteeh; hadíń náshidnłtįįhíí shinł’a’á ałdó’ náidiłteeh. ");
INSERT INTO apwNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus ágánṉiidá’ biyi’siziiníí doo bił gozhǫ́ǫ́ dago, nagolṉi’go gáṉíí, Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Nohwíí ła’ ch’íshinoh’aah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Hadíńshą’ áyiłṉii daanzįgo bitsiłke’yu nádaałinéł’įį. ");
INSERT INTO apwNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Bitsiłke’yu ła’, Jesus bił nzhónihi, Jesus bitílzhį’ bínentį́į́ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Áík’ehgo Simon Peter áí nayí’izhgizhgo gáyiłṉii, Nahódńłkid, hadíń áyiłṉii áí? ");
INSERT INTO apwNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Bitílzhį’ bínentííníí Jesus gáyiłṉii, SheBik’ehń, hadíń áłnṉii áí? ");
INSERT INTO apwNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus gáṉíí, Ee’sí’ą́ą́go baa dish’ałíí, áń áłdishṉii. Yee’iz’ąągo Judas Iscáriot yaa yin’ą́ą́, Simon biye’. ");
INSERT INTO apwNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ee’ist’ąąhíí náidn’ąądá’ ch’iidn nant’án, Satan holzéhi beh hiyáá. Jesus gábiłṉii, Nt’é ánle’íí dahałe ánle’. ");
INSERT INTO apwNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Da’iyąągo naháztaaníí nt’é bighą ágábiłnṉiidíí doo ła’ yígołsįįd da. ");
INSERT INTO apwNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas zhaali bizis nayi’aahíí bighą Jesus ágábiłṉii, daanzį ląą, Da’idaaníí bá hidáń nayiłṉiihgo, dagohíí, Tédaat’iyéhíí nt’éhéta yaa daayiné’, yo’ṉiigo aṉíí ląą daanzį. ");
INSERT INTO apwNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas ee’ist’ąąhíí náidn’ąąhíí bikédí’go dagoshch’į’ ch’ínyáá; áídí’ tł’é’ gozlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ch’ínyáádá’ Jesus gáṉíí, K’adíí shíí, nṉee k’ehgo Niyááhíí ízisgo be’ánsht’eehíí ch’í’ṉah alṉe’, Bik’ehgo’ihi’ṉań ízisgo ye’at’ééhíí shíí shee ch’í’ṉah alṉe’. ");
INSERT INTO apwNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Áík’ehgo Bik’ehgo’ihi’ṉań ízisgo ye’at’ééhíí shíí shee ch’í’ṉah alzaayúgo, Bik’ehgo’ihi’ṉań ałdó’ ízisgo be’ánsht’eehíí dabíí ch’í’ṉah áidolííł, dagoshch’į’ ch’í’ṉah áidolííł. ");
INSERT INTO apwNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Shichągháshé, dét’įhézhį’ t’ah nohwił nashkai. Shiká daadeh’į́į́ doleeł; Jews daanlíni ádaabiłdéṉiidíí k’ehgo nohwíí ałdó’ gánohwiłdishṉii, Hayú déyááyú doo nohkáh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Begoz’aaníí áníidéhi bee nohwá ngonsh’aah, łił daanohjǫǫgo; dashíí shił daanohshǫǫhíí k’ehgo nohwíí ałdó’ łił daanohjǫǫ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Díí bee shiké’ hikaahíí daanohłįįgo nṉee dawa yídaagołsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter gábiłṉii, SheBik’ehń, hayú dínyaa? Jesus gábiłṉii, Hayú déyááyú k’adyúgo doo shiké’ ńṉáh da; áídá’ ikédí’go shiké’ ńṉáh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter gábiłṉii, SheBik’ehń, nt’é bighą k’adyúgo doo niké’ disháh da? Shíí nighą dasiitsąą ndi dábik’eh. ");
INSERT INTO apwNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus gábiłṉii, Ya’ shíí shighą dantsaah née? Da’aṉii, da’aṉiigo gániłdishṉii, Tazhik’áné doo hwahá áṉiih dadá’, taadn doo bígonsį da shiłnṉiih ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Doo nohwijíí natsídaahiltǫ’ da le’: Bik’ehgo’ihi’ṉań daahohdląą, shíí ałdó’ daashohdląą. ");
INSERT INTO apwNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ShiTaa golį́į́yú łą́ą́go nohwiba’ goz’ąą: doo ágát’éé dayúgo doo nohwił nagoshṉi’ da doleeł ni’. Ákú nohwá iłch’į’goshłéhyú déyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ákú nohwá iłch’į’goshłaadá’ nánshdáhgo t’ąązhį’ nohwił nádishkáh; hayú sídááyú nohwíí ałdó’ ákú nasółtąą doo. ");
INSERT INTO apwNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hayú déyááyú bídaagonołsį, itínhíí ałdó’ bídaagonołsį. ");
INSERT INTO apwNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas gábiłṉii, NohweBik’ehń, hayú dínyaahíí doo bídaagonlzį dadá’ hagot’éégo itínhíí bídaagonlzį? ");
INSERT INTO apwNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus gábiłṉii, Shíí itínhíí nshłįį, da’aṉii ágot’eehíí, ła’íí ihi’ṉaahíí nshłįį: shíí shinkááyú zhą́ shiTaa yaa higháhi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Shídaagonołsįyúgo shiTaa ałdó’ bídaagonołsį doleeł ni’: kodí’ godezt’i’go bídaagonołsį, ła’íí daahołtsąą. ");
INSERT INTO apwNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip gábiłṉii, NohweBik’ehń, niTaa nohwił ch’í’ṉah ánle’, áík’ehgo nohwił dádaabik’eh. ");
INSERT INTO apwNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus gábiłṉii, Philip, ya’ nohwił nashkaigo ńzaad ogoyáádá’ t’ah doo shígonłsįįh da née? Hadíń sho’iiníí shiTaa yo’įį; áídá’ nt’é bighą, NiTaa nohwił ch’í’ṉah ánle’, nṉii? ");
INSERT INTO apwNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ShiTaa biyi’ gonshłįį, ła’íí shiTaa shiyi’ golį́į́ doo hondlą́ąh da née? Yati’ bee yashti’íí doo dashínik’eh yashti’ da: shiTaa shiyi’ golííníí ánásht’įįłíí dabíí ánáyol’įįł. ");
INSERT INTO apwNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ShiTaa biyi’ gonshłįįgo, ła’íí shiTaa shiyi’ golį́į́go shondlą́ąh: dagohíí ánásht’įįłíí zhą́ bighą shondlą́ąh. ");
INSERT INTO apwNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Hadíń shodlaaníí ánásht’įįłíí k’ehgo ánát’įįł doleeł; ánásht’įįłíí bitisgo ndi ánát’įįł doo; shíí shiTaa bich’į’ nádésdzáhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Shizhi’ hohshiigo nt’éhéta daahóhkeedíí nohwá łashłe’, shiTaa ízisgo ye’at’ééhíí biYe’ bee ch’í’ṉah ádolṉiił doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Shizhi’ hohshiigo dant’éhéta daahóhkeedyúgo nohwá łashłe’. ");
INSERT INTO apwNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nohwił daanshǫǫyúgo bengoni’ááníí bikísk’eh ádaanoht’ee. ");
INSERT INTO apwNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ShiTaa hoshkąąh doleeł, áík’ehgo ła’ Kich’oṉiihíí nohwaa naadit’aah, áń dahazhį’ nohwił nlįį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Áń Spirit da’aṉii ágot’éhi ch’í’ṉah áile’hi; da’áń ni’gosdzáń biká’ nṉee doo hagot’éégo nágodi’aah da, doo daayo’įį da, doo yídaagołsį dahíí bighą: áídá’ nohwíí bídaagonołsį; nohwił nlįį, ła’íí nohwiyi’ golį́į́híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nohwits’ą́’ nádésdzáágo doo dasahndi ádaanoht’ee da doleeł: áídí’ nohwich’į’ nádishdááł. ");
INSERT INTO apwNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dét’įhézhį’ ni’gosdzáń biká’ nṉee doo nádaashiłtséh da; da’ágát’éé ndi nohwíí daashołtséh: shíí hinshṉaahíí bighą nohwíí ałdó’ daahinohṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Áí bijįį shíí shiTaa biyi’ nshłįį, nohwíí shiyi’ daanohłįį, shíí nohwiyi’ daanshłįįhíí bídaagonołsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Hadíń bengoni’ááníí yígółsįgo yikísk’eh at’ééhíí, áń bił nshǫǫ: hadíń bił nshooníí shiTaa bił nzhóni at’éé, áík’ehgo áń shił nzhǫǫgo bich’į’ ch’í’ṉah ádinszį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, doo Iscáriot dahi, gábiłṉii, NohweBik’ehń, nt’é bighą ni’gosdzáń biká’ nṉee doo bich’į’ ch’í’ṉah ádńdléh dadá’, néé zhą́ nohwich’į’ ch’í’ṉah ádńdléh doleeł? ");
INSERT INTO apwNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus gábiłṉii, Nṉee bił nshǫǫyúgo shiyati’íí yikísk’eh at’éé doleeł: shiTaa bił nzhǫǫ doleeł, áík’ehgo baa nt’aashgo bił daagondlįį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Hadíń doo bił nshǫǫ dahíí shiyati’íí doo yikísk’eh at’éé da: yati’ daadohts’agíí doo dashíí shiyati’ at’éé da, shiTaa shinł’a’ń biyati’ at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Díí ágot’eehíí bee nohwich’į’ yásíłti’, t’ah nohwitahyú nshłįįdá’. ");
INSERT INTO apwNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kich’oṉiihíí, Holy Spirit holzéhi, shizhi’ biláhyú shiTaa nohwich’į’ daidił’aa doleełíí dawa nohwił ch’ígó’aah doleeł, nohwił nagosisṉi’íí dahot’éhé bínádaałṉiihgo ánohwiłsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Iłch’į’gont’ééhíí nohwaa nnshné’, iłch’į’gont’ééhíí shits’ą́’dí’ begoz’ánihíí nohwaa daanshné’: doo ni’gosdzáń bits’ą́’dí’ ágot’eehíí k’ehgo nohwaa daanshné’ da. Doo nohwijíí natsídaahiltǫ’ da le’, doo nédaałdzid da le’. ");
INSERT INTO apwNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Gádaanohwiłdéṉiidíí daadisots’ąą, Deyáádí’ nohwaa náshdáh doleeł. Nohwił daanshǫǫ lę́k’eyúgo nohwił daagozhǫ́ǫ́ doleeł ni’, shiTaa bich’į’ nádésdzá dishṉiihíí bighą; shiTaa shitisgo at’éhi nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Doo hwahá begolṉe’ dadá’ nohwił nagosisṉi’, be’ágodzaadá’ da’ohdląą doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kodí’ godezt’i’go doo łą́ą́go nohwich’į’ yádaashti’ da: díí ni’gosdzáń binant’a’ higaałhíí bighą, áń doo shebik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ni’gosdzáń biká’ nṉee shiTaa shił nzhǫǫgo yídaagołsį doleełhíí bighą, shiTaa shá ngon’ááníí k’ehgo ánásht’įįł. Daohsįįh, hikaah le’. ");
INSERT INTO apwNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Shíí dasts’aa dahnanlsé’íí da’aṉiihíí nshłįį, shiTaahíí dahnanlsé’íí nłt’éégo áyíłsiníí nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Shits’ádaaz’aahíí doo nest’ą’ áile’ dahíí dawa shits’áyiṉiił: áídá’ shits’ádaaz’aahíí nest’ą’ áile’íí náyigeesh, nest’áń dayúweh łą́ą́go áiléh doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nohwíí iłk’idá’ yati’ bee nohwich’į’ yásíłti’íí bee daanohwidiłkǫǫd. ");
INSERT INTO apwNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Shiyi’ daanohłįį, shíí ałdó’ nohwiyi’ nshłįį. Its’ádaaz’aahíí doo dabízhą́ nest’ą’ áyóléh át’éé da, bá’ó’áhi yiyi’ nlįįyúgo zhą́; nohwíí ałdó’ nest’ą’ doo ádaahłe’ da, shiyi’ daanohłįįyúgo zhą́. ");
INSERT INTO apwNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Shíí dasts’aa dahnanlsé’íí bá’ó’áhi nshłįį, nohwíí shits’ádaaz’aahíí daanohłįį. Dahadíń shiyi’ nliiníí, ła’íí biyi’ nshłiiníí, áń nest’ą’ łą́ą́go áiléhi nlįį; shíí da’ánshdįhyúgo doo nt’é ádaahłéh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nṉee ła’ doo shiyi’ nlįį dayúgo, its’ádaaz’aahíí ła’ yó’olt’e’go náhasganhíí k’ehgo yó’obi’dilt’e’; nṉee áí its’ádaaz’aahíí łenádaihezlaago kǫ’ biyi’ odaiskaadgo nlíd. ");
INSERT INTO apwNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Shiyi’ daanohłįįyúgo, shiyati’ nohwiyi’ begoz’ąąyúgo, dahádaaht’įįhíí daahóhkeedgo nohwá ádaadolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nohwinest’ą’ łą́ą́go ánádaał’įįłíí bee shiTaa ízisgo at’ééhíí ch’í’ṉah ábi’dilzį; áík’ehgo da’aṉiigo shiké’ hikaahíí daanohłįį. ");
INSERT INTO apwNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ShiTaa bił nshǫǫhíí k’ehgo nohwíí shił daanohshǫǫ: dayúweh shił daanohshǫǫ le’. ");
INSERT INTO apwNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ShiTaa yegos’aaníí bikísk’eh ánsht’eego dábik’ehn bił nshǫǫhíí k’ehgo bengoni’ááníí bikísk’eh ádaanoht’eeyúgo, dábik’ehn shił daanohshǫǫ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Shits’ą́’dí’ koł’ijóóníí nohwiyi’ daagolį́į́ doleełgo, ła’íí dázhǫ́ nohwił daagozhǫ́ǫ́ doleełhíí bighą be’ánohwiłdéṉiid. ");
INSERT INTO apwNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Díínko bengoni’áni at’éé, Shił daanohshooníí k’ehgo nohwíí ałdó’ łił daanohjǫǫ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ił’ijóóníí díí bitisgo at’éhi doo hadíń ye’at’éé da, nṉee bi’ihi’ṉa’ bit’eké yá nyiné’i. ");
INSERT INTO apwNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bengoni’ááníí be’ádaanoht’eeyúgo shit’eké daanohłįį. ");
INSERT INTO apwNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kodí’ godezt’i’go doo dayúweh shá na’iziidíí daanohwiłdishṉiigo daanohwoshíí da; na’iziidíí binant’a’ ánát’įįłíí doo yígółsį da: áídá’ shit’eké daanohwiłdishṉiigo daanohwoshíí; shiTaa bits’ą́’dí’ disiits’ą́ą́’íí dawa nohwił ígózįgo ashłaahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nohwíí doo hadaasisołtįį da, shíí hanohwiheṉil, nest’ą’ ánádaał’įįłyú dahdohkáhgo nohwaa godini’ą́ą́, áí nest’ą’ daagolį́į́ ńt’éé doleełgo; áík’ehgo dant’éhéta shizhi’ biláhyú shiTaa bídaahóhkeedyúgo, nohwaa yidoné’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Díínko nohwá ngoni’ą́ą́, łił daanohjǫǫ le’. ");
INSERT INTO apwNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ni’gosdzáń biká’ nṉee nohwik’edaanṉiihyúgo, nohwik’edaanṉiihíí dabíntsé shik’edaanṉiihgo bídaagonołsį. ");
INSERT INTO apwNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ni’gosdzáń biká’ ágot’eehíí bich’į’zhiṉéé daanohłįįyúgo, ni’gosdzáń biká’ nṉee dabíí bich’į’zhiṉééhíí bił daanzhóni at’éé; áídá’ ni’gosdzáń biká’ ágot’eehíí doo bich’į’zhiṉéé daanohłįį da, ndi bits’ą́’ nohwiniṉil, áí bighą ni’gosdzáń biká’ nṉee nohwik’edaanṉiih. ");
INSERT INTO apwNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nohwich’į’ hasdzii n’íí bínádaałṉii, Na’iziidíí doo binant’a’ yitisgo at’éé da, nohwiłdéṉiid. Shiniidaagodezlaayúgo, nohwíí ałdó’ nohwiniidaagodile’; ádishṉiihíí yikísk’eh ádaat’ee lę́k’eyúgo, nohwíí ałdó’ ádaadohṉiihíí yikísk’eh ádaat’ee doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Shizhi’híí bighą díí dahot’éhé ye’ádaanohwile’, shides’a’ń doo yídaagołsį dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Doo niyáágo bich’į’ yádaasiłti’ dayúgo, doo nchǫ’go ádaadzaa da doleeł ni’; k’adíí binchǫ’íí bighą doo nt’é yik’ídaagodi’áh da. ");
INSERT INTO apwNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Dahadíń shik’enṉiihíí shiTaa ałdó’ yik’enṉiih. ");
INSERT INTO apwNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bitahyú áná’ol’įįłíí doo hwahá hadíń áile’hi ashłaa dayúgo, doo nchǫ’go ádaadzaa da doleeł ni’: k’adíí shíí hik’e shiTaa biłgo daanohwiłtsąągo nohwik’edaanṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Dabíí bich’į’ begoz’aaníí biyi’ k’e’eshchiiníí, Doo nt’é bighą shik’edaanṉii da, golzeego dahgoz’aaníí begolṉe’go ánágot’įįł. ");
INSERT INTO apwNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kich’oṉiihíí, áń shiTaa bits’ą́’dí’ nohwich’į’ dish’aa doleełíí ńyáágo, Holy Spirit da’aṉii ágot’éhi ch’í’ṉah áile’hi, shiTaa yits’ą́’dí’ nlíni, áń shaa nagolṉi’ doleeł: ");
INSERT INTO apwNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nohwíí ałdó’, dantsé godezt’i’dí’ nohwił nashkaihíí bighą shaa nadaagołṉi’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Doo t’ąązhį’ nanánohohdéh da doleełhíí bighą díí dawa bee nohwich’į’ yádaasiłti’. ");
INSERT INTO apwNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jews ha’ánáłséhdí’ ch’ídaanohwinihiyood doleeł: ła’íí dahadíń nohwizes‐hiiníí Bik’ehgo’ihi’ṉań bá ásht’į́į́ nzį doleełíí baa gowáh. ");
INSERT INTO apwNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Áí shiTaa doo yídaagołsį da, shíí ndi doo shídaagołsį dahíí bighą ánádaat’įįł doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Díí baa nohwił nagosisṉi’íí baa gonyáágo, bínádaałṉiih doleełhíí bighą nohwił nagosisṉi’n’. Iłch’ígonsh’aahgo godeyaadá’ díí doo baa nohwił nagosisṉi’ da ni’, t’ah nohwił nashkai n’íí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","K’adíí shides’a’ń bich’į’ deyáá; áídá’ doo ła’, Hayú dínyaa? daashiłdohṉiigo nashídaadołkid da. ");
INSERT INTO apwNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Díí baa nohwił nagosisṉi’híí bighą nohwijíí biyi’ doo nohwił daagozhǫ́ǫ́ da daasolįį. ");
INSERT INTO apwNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Da’ágát’éé ndi da’aṉiigo ánohwiłdishṉii; dahdisháhíí nohwá nzhǫǫ: doo dahdiyaa dayúgo, Kich’oṉiihíí doo nohwaa hiṉáh da; áídá’ óyááyúgo zhą́ nohwich’į’ dish’aa doo. ");
INSERT INTO apwNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Áń ńyáágo nchǫ’go ágot’eehíí, nzhǫǫgo ágot’eehíí, ła’íí aayá’iti’íí ni’gosdzáń biká’ nṉee yił ch’í’ṉah ádaile’ doo. ");
INSERT INTO apwNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Doo daashodląą dahíí bighą nchǫ’go ágot’eehíí bił ch’í’ṉah ádaile’ doleeł; ");
INSERT INTO apwNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ShiTaa bich’į’ deyáágo doo nádaashołtséh dahíí bighą nzhǫǫgo ágot’eehíí bił ch’í’ṉah ádaile’ doleeł; ");
INSERT INTO apwNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Díí ni’gosdzáń binant’a’ baa yá’iti’híí bighą aayá’iti’íí bił ch’í’ṉah ádaile’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Łą́ą́go t’ah nohwich’į’ yashti’ ndi k’adííyúgo doo nohwił ídaagozį da. ");
INSERT INTO apwNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Áídá’ Spirit da’aṉii ágot’éhi ch’í’ṉah áile’hi nohwaa nyáágo, da’aṉii ágot’eehíí dawa nohwá yígółsį doleeł: doo dabínik’eh yałti’ da doleeł; nt’éhéta yidits’agíí zhą́ yaa yałti’ doo: ła’íí begoldohíí nohwił ch’í’ṉah áidoliił. ");
INSERT INTO apwNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Shits’ą́’dí’go be’ágot’eehíí náidiiné’go, yaa nohwił nagolṉi’ doleełíí ízisgo be’ánsht’eehíí nohwił ch’í’ṉah áidoliił. ");
INSERT INTO apwNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ShiTaa bits’ą́’dí’go be’ágot’eehíí dawa shíyéhi at’éé. áí bighą shits’ą́’dí’go be’ágot’eehíí náidiiné’go nohwił ch’í’ṉah áidoliił, déṉiid. ");
INSERT INTO apwNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Dét’įhézhį’ doo nádaashołtséh da: áídí’ dét’įhézhį’ nanádaashołtséh, shiTaa bich’į’ deyááhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Bitsiłke’yu ła’ gádaałiłdi’ṉii, Dét’įhézhį’ doo nádaashołtséh da: áídí’ dét’įhézhį’ nanádaashołtséh: ła’íí, ShiTaa bich’į’ deyááhíí bighą, daanohwiłṉiihíí, nt’é ṉiigo aṉíí? ");
INSERT INTO apwNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Gádaaṉii, Nt’é ṉiigo aṉíí, Dét’įhézhį’, ṉiihíí? Néé doo bídaagonlzį da nt’é ṉiigo aṉiihíí. ");
INSERT INTO apwNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus nabídaadiłkid hádaat’įįgo yígółsįgo gádaabiłṉii, Dét’įhézhį’ doo nádaashołtséh da: áídí’ dét’įhézhį’ nanádaashołtséh, dishṉiihíí bighą nałídaadołkid née? ");
INSERT INTO apwNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Daahchag, ła’íí chaał ádaanoht’eedá’ ni’gosdzáń biká’ nṉee bił daagozhǫ́ǫ́ doleeł; doo nohwił daagozhǫ́ǫ́ da doleeł, áídá’ doo nohwił daagozhǫ́ǫ́ dahíí nohwił daagozhǫ́ǫ́ nádaadodleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Isdzán iłchiigo doo bił gozhǫ́ǫ́ da, iłchiigee ngonyááhíí bighą: áídá’ ishchįįhíí bikédí’go, ni’gosdzáń biká’zhį’ nṉee yishchįįhíí yaa bił gozhǫ́ǫ́go, nṉiih n’íí doo yínálṉiih da. ");
INSERT INTO apwNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Áík’ehgo doo nohwił daagozhǫ́ǫ́ da k’adíí: ndi nádaanohwiłtsąągo nohwił daagozhǫ́ǫ́ doleeł, doo hadíń nohwił gozhóóníí nohwits’ą́’ náidoné’ át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Áí bijįį doo nashídaadołkid da doleeł. Da’aṉii, da’aṉiigo gádaanohwiłdishṉii, Nt’éhéta shiTaa shizhi’ biláhyú bídaahóhkeedíí nohwaa daayiné’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Doo nt’é shizhi’ biláhyú daahóhkeed da ngoheyaa: da’óhkeedgo nohwaa hi’né’, áík’ehgo dázhǫ́ nohwił daagozhǫ́ǫ́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Díí iłch’ígót’aahgo na’goṉi’íí bee nohwił nagosisṉi’: ndi iłch’ígót’aahgo na’goṉi’íí doo dayúweh bee nohwił nadaagoshṉi’ dahíí baa gowáh, áídá’ dabígózįgo shiTaa baa nohwił nadaagoshṉi’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Áí bijįį shizhi’ biláhyú da’óhkeed doleeł: shiTaa nohwá hoshkąąh doo daanohwiłdishṉiigo da: ");
INSERT INTO apwNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ShiTaa dabíí bił daanohshǫǫ, nohwił daanshǫǫhíí bighą, ła’íí shiTaa bits’ą́’dí’ níyáágo daahosohdląądhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Shíí shiTaa bits’ą́’dí’ ni’gosdzáń biká’zhį’ nkeniyáá: k’adíí ni’gosdzáń bits’ą́’dí’ shiTaa bich’į’ nádésdzá. ");
INSERT INTO apwNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Bitsiłke’yu gádaaṉii, Áníita dabígózįgo yánłti’, iłch’ígót’aahgo na’goṉi’íí dee bee yánłti’ da. ");
INSERT INTO apwNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Dawa bígonłsį́go k’adíí bídaagosiilzįįd, doo hadíń nanódiłkid bik’eh da: díí bee Bik’ehgo’ihi’ṉań bits’ą́’dí’ ńyaago daanosiidląąd. ");
INSERT INTO apwNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus gádaabiłṉii, Áníita da’osohdląąd née? ");
INSERT INTO apwNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Isąą, iłtahosohkaigo danohtįįgee gowąyú onáhasohkaidá’, shízhą́ dasahndi ch’ídishtłish doleełíí baa gowáh, iłk’idá’ biká’ ngonyáá: ndi doo dasahndi ch’ínítłizh da, shiTaa bił nash’aashíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Shíí shiláhyú iłch’į’gont’ééhíí be’ádaanoht’ee doleełhíí bighą díí bee nohwich’į’ hasdzii. Ni’gosdzáń biká’ góyéégo nagowaahíí biyi’ nahkai: áídá’ nohwił daagozhǫ́ǫ́ le’; ni’gosdzáń biká’ ágot’eehíí bitis silį́į́. ");
INSERT INTO apwNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus díí ąął ánṉiidá’ yaaká’yú déz’įįgo gáṉíí, ShiTaa, baa gowáh n’íí biká’ ngonyáá; shíí, niYe’ nshłiiníí, ízisgo be’ánsht’eehíí ch’í’ṉah ánle’go, shíí ałdó’ ízisgo áńt’ééhíí ch’í’ṉah ánshłe’. ");
INSERT INTO apwNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Daahiṉaahíí dawa beshik’ehgo shá ngoń’ąą, hadíí shaa daadín’ąąhíí dawa dahazhį’ ihi’ṉaahíí baa daadinsh’aa doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Díínko dahazhį’ ihi’ṉaahíí át’éé, danizhą́ Bik’ehgo’ihi’ṉań da’aṉíhi ńlį́į́híí nídaagołsį, ła’íí shíí, Jesus Christ shíńńł’a’íí, ałdó’ shídaagołsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ni’gosdzáń biká’ ízisgo be’áńt’ééhíí ch’í’ṉah ánishłaa: na’idziid shaa díń’ąą n’íí ąął ashłaa. ");
INSERT INTO apwNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ShiTaa, k’adíí ni’gosdzáń t’ah doo álṉe’ dadá’ ízisgo nił be’ánsht’ee n’íí bee dani ízisgo be’ánsht’eehíí ch’í’ṉah ánle’. ");
INSERT INTO apwNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ni’gosdzáń biká’ nṉee bitahdí’ ła’ shaa ńṉilíí bich’į’ nizhi’ bígózįgo ashłaa: ṉíyéé daanlįį ni’, shaa ńṉil; niyati’ yikísk’eh ádaat’ee. ");
INSERT INTO apwNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Dawahá shaa díń’ąąhíí ni nits’ą́’dí’go yídaagołsį. ");
INSERT INTO apwNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Yati’ shaa díń’ąąhíí bee bich’į’ yádaasiłti’; áí nádaidnné’, nits’ą́’dí’ níyááhíí da’aṉiigo yídaagołsį, ła’íí shińńł’a’íí daayosdląąd. ");
INSERT INTO apwNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Bá da’oshkąąh: ni’gosdzáń biká’ nṉeehíí doo bá da’oshkąąh da, áídá’ hadíí shaa ńṉilíí zhą́ bá da’oshkąąh; áí ṉíyéé daanlįįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Shíyééhíí dawa ṉíyéé, ṉíyééhíí dawa shíyéé; áík’ehgo áí bee ízisgo be’ánsht’eehíí ch’í’ṉah áshi’delzaa. ");
INSERT INTO apwNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","K’ad doo ni’gosdzáń biká’ nashaa da doleeł, áíhíí ni’gosdzáń biká’ nakai, shihíí nich’į’ dahnádishdáh. ShiTaa diyini, hadíí shaa ńṉilíí nizhi’ binawodíí bee daahóńtą’, dała’á ndlįįhíí k’ehgo dała’á daanlįį doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ni’gosdzáń biká’ t’ah bił nashkaidá’, hadíí shaa ńṉilíí nizhi’ binawodíí bee daahóshtą’ ni’; biṉádaadesh’į́į́go doo ła’ ch’a’otłizh da, ndi da’ílíí hileeh yá gozlíni zhą́, Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí begolṉe’híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","K’ad nich’į’ nádesdzá; shił gozhóóníí dázhǫ́ bee bił daagoyiłshǫ́ǫ́ doleełhíí bighą díí ni’gosdzáń biká’zhį’ bee yashti’. ");
INSERT INTO apwNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Niyati’íí baa bił nadaagosisṉi’; ni’gosdzáń biká’ ágot’eehíí doo be’ánsht’ee dahíí k’ehgo ni’gosdzáń biká’ ágot’eehíí doo be’ádaat’ee dahíí bighą ni’gosdzáń biká’ nṉee bik’edaanṉiih. ");
INSERT INTO apwNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ni’gosdzáń bits’ą́’ńṉííł doo dishṉiigo oshkąąh da, áídá’ nchǫ’íí bits’ą́’go ádaanłsį, dishṉiigo oshkąąh. ");
INSERT INTO apwNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ni’gosdzáń biká’ ágot’eehíí doo be’ánsht’ee dahíí k’ehgo ni’gosdzáń biká’ ágot’eehíí doo be’ádaat’ee da. ");
INSERT INTO apwNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Da’aṉiihíí nits’ą́’dí’ begoz’aaníí bee hadaańle’: niyati’ da’aṉíhi. ");
INSERT INTO apwNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ni’gosdzáń biká’zhį’ shidíńł’a’ n’íí k’ehgo, bíí ni’gosdzáń biká’zhį’ odaał’a’. ");
INSERT INTO apwNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Bíí bighą godiyini be’ánsht’eego ádishdle’, bíí ałdó’ da’aṉíhi bee hadaadilṉe’ doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Doo dabíí zhą́ bá da’oshkąąh da, hadíń díí nṉee biyati’híí bighą daashodląą doleełíí ałdó’ bá da’oshkąąh; ");
INSERT INTO apwNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Áí dawa dała’á daanlįį doleełgo; ni shiTaa ńlínihíí shiyi’ nlįį, ła’íí niyi’ nshłįįhíí k’ehgo bíí ałdó’ dała’á daanlįįgo nohwiyi’ daanlįį doleeł: shińńł’a’go ni’gosdzáń biká’ nṉee daayodląą doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ízisgo be’ánsht’eehíí shaa ńné’íí baa daasiiné’; dała’á ndlįįhíí k’ehgo dała’á daanlįį doleełhíí bighą: ");
INSERT INTO apwNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Shíí biyi’ daanshłįįgo, ni shiyi’ nlį́į́go, díí nṉee dazhǫ́ nłt’éégo ádaabile’go dała’á daanlįį doleeł; áík’ehgo ni’gosdzáń biká’ nṉee shidíńł’a’go yídaagołsį doleeł, ła’íí nił nshǫǫhíí k’ehgo nił daanzhǫǫhíí ałdó’ yídaagołsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ShiTaa, hadíí shaa ńṉilíí hayú nashaayú bił daanshłįį doleełgo hasht’į́į́; áík’ehgo ízisgo be’ánsht’eehíí shaa ńné’íí daidołtsééł, ni’gosdzáń doo hwahá nnit’aa dadá’ nił nshǫǫ lę́k’ego. ");
INSERT INTO apwNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ShiTaa, dázhǫ́ nłt’éégo áńt’ééhíí, ni’gosdzáń biká’ nṉee doo nídaagołsį da lę́k’e: ndi shíí nígonsį, ła’íí díí nṉeehíí shińńł’a’go yídaagołsį. ");
INSERT INTO apwNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nizhi’ baa bił nadaagosisṉi’, baa bił nanádaagoshṉi’ doleeł; ił’ijóni bee nił nshooníí biyi’ daagolį́į́ doleeł, ła’íí biyi’ daanshłįį doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesus ágánṉiidá’ bitsiłke’yu biłgo tú da’ayą́hágo nlíni, Cédron golzéhi, hanaa deskai, áígee dégózhónégo goz’ąązhį’ yił okai. ");
INSERT INTO apwNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, ch’íbí’aahíí, ałdó’ dégózhónégo goz’aaníí yígółsį: Jesus łahgee akú bitsiłke’yu yił onákah lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ákú silááda ła’íí aasiṉilíí, okąąh yedaabik’ehi itisyú nadaandeehi hik’e Phárisees odais’a’ihíí, kǫ’nalbaałíí, kǫ’diltłishíí ła’íí benagonlkaadíí daayoṉiłgo Judas yił hikai. ");
INSERT INTO apwNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus díí bee bich’į’ ágoṉéhíí dawa yígółsįgo áí nṉeehíí yich’į’ nyáágo gádaayiłṉii, Hadíń biká hadaanohtaa? ");
INSERT INTO apwNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nṉeehíí gádaabiłṉii, Jesus, Názarethdí’ gólíni. Shíí áń ánsht’ee, ṉii, Jesus. Judas, ch’íbí’aahíí, ałdó’ itah sizįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Shíí áń ánsht’ee, daabiłnṉiidá’ dagoshch’į’ t’ąązhį’ deheskaigo ni’zhį’ nanehezdee. ");
INSERT INTO apwNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesus gánádaabiłdo’ṉiid, Hadíń biká hadaanohtaa? Jesus, Názarethdí’ gólíni, nádaado’ṉiid. ");
INSERT INTO apwNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus gánádí’ṉii, Shíí áń ánsht’ee, daanohwiłdéṉiid: shíí shiká hadaanohtaayúgo, díí nṉeehíí ch’ík’eh nádókáh: ");
INSERT INTO apwNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nṉee shaa ńṉilíí doo ła’ shaa ch’a’okáad da, áṉíí n’íí begolṉe’híí bighą aṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Peter, bésh be’idiltłishé naitįįhíí hayidzį́į́zgo, okąąh yebik’ehi da’tiséyú sitíni yána’iziidíí bijaa dihe’nazhiṉéégo naidnłgizh. Na’iziidíí Málkas holzéhi. ");
INSERT INTO apwNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus Peter gáyiłṉii, Nibízh be’idiltłishé bizis biyi’ onántįį: shiTaa idee yee sha’ikaahíí hishdląą ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Áídí’ silááda ła’íí binant’a’ ła’íí aasiṉilíí Jews odais’a’íí Jesus daayiłtsoodgo łídaayistł’ǫǫ, ");
INSERT INTO apwNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Áídí’ dantsé Ánnas holzéhi bich’į’ odaizlǫǫz; áń Cáiaphas baadaaní, Cáiaphas‐híí áí łegodzaahíí biyi’ okąąh yebik’ehi da’tiséyú sitįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Cáiaphas Jews daanlíni yich’į’ yałti’go gánṉiid lę́k’e, Nṉee dała’á nṉee dawa yá datsaahgo zhą́ nzhǫǫ. ");
INSERT INTO apwNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter Jesus yiké’ óyáá, bitsiłke’yu ła’i ałdó’: áń okąąh yebik’ehi da’tiséyú sitíni bígółsįgo kįh yuṉe’ Jesus yił ha’a’aazh. ");
INSERT INTO apwNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Áídá’ Peter dáádítį́hgee sizįį. Áídí’ Jesus bitsiłke’yu ła’ihíí, okąąh yebik’ehi da’tiséyú sitíni yígółsini, ch’ínyáágo, isdzán dáádítį́h yaa sitíni yich’į’ hadziigo Peter yił ha’a’aazh. ");
INSERT INTO apwNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Isdzán dáádítį́h yaa sitíni Peter gáyiłṉii, Ni ałdó’ ła’ áí nṉeehíí bitsiłke’yu itah ńlį́į́ nsį. Dah, shí doo áí nshłįį da, ṉii, Peter. ");
INSERT INTO apwNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nada’iziidíí ła’íí aasiṉilíí gozk’azíí bighą deda’deshjeedgo nádaaniiłdziiłgo kǫ’zhį’ nadaazį: Peter ałdó’ itah nániiłdziiłgo sizįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Okąąh yebik’ehi da’tiséyú sitíni Jesus biké’ hikaahíí ła’íí iłch’ígó’aahíí yaa nabídiłkid lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus gábiłṉii, Ni’gosdzáń biká’ nṉee ch’í’ṉah bich’į’ yádaashti’ ni’; Jews ha’ánáłséh nagoz’ąą yuṉe’, ła’íí da’ch’okąąh goz’ąą yuṉe’ dábik’ehn iłch’ígonsh’aah ni’, Jews daanlíni íła’ánádaat’įįhgee; doo nt’é nash’į’go yashti’ da ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nt’é bighą nashídńłkid áídá’? Hadíí daashidezts’aaníí nt’é daabiłdéṉiidíí yídaagołsį: áí nahódaańłkid. ");
INSERT INTO apwNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ágánṉiidá’ aasiṉilíí ła’, Jesus bit’ahdí’ sizíni, bonłts’į́, gáṉíígo, Ya’ áík’ehgo okąąh yebik’ehi da’itiséyú sitíni bich’į’ yách’iłti’ née? ");
INSERT INTO apwNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus gábiłṉii, Doo bik’ehgo hasdzii dayúgo baa shił nagolṉí’: áídá’ da’aṉiigo hasdziiyúgo nt’é bighą shóńłts’į́? ");
INSERT INTO apwNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ánnas, Jesus łestł’ǫǫgo Cáiaphas, okąąh yebik’ehi da’tiséyú sitíni, bich’į’ oyił’a’ ni’. ");
INSERT INTO apwNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Peter nániiłdziiłgo sizįį lę́k’e. Gádaabiłch’iṉii, Ni ałdó’ ła’ bitsiłke’yu ńlį́į́ daandzį. Dah, shí doo áń nshłįį da, nádo’ṉiid. ");
INSERT INTO apwNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Okąąh yebik’ehi da’tiséyú sitíni yána’iziidíí ła’, áń Peter yijaa naidnłgizh n’íí bik’íí nlíni, gáṉíí, Ni née, dégózhóné goz’ąągee áí nṉeehíí bił nish’įį ni’? ");
INSERT INTO apwNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter, Dah, nádo’ṉiid; áígee tazhik’áné ánṉiid. ");
INSERT INTO apwNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Cáiaphas bikįh goz’ąądí’ yáná’itihé yuṉe’ Jesus odaizlǫ́ǫ́z: dázhǫ́ t’ahbį lę́k’e; Jews daanlíni ákóṉe’ ha’á’iikaiyúgo bitis‐hagowáh n’íí bee bíná’godiṉíhgo da’idąągee doo itah daahiidleeh da, okąąh zhiṉéégo doo iłch’į’daandléh dahíí bighą daanzįgo, doo ha’akáh da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Áík’ehgo nant’án, Pílate holzéhi, bich’į’ ch’ínyáágo gádaabiłṉii, Áí nṉeehíí hago lą́ą́ adzaago bił nohkai? ");
INSERT INTO apwNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jews gádaabiłṉii, Doo nchǫ’go adzaa dayúgo doo naa bił nokáh át’éé da. ");
INSERT INTO apwNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pílate gánádi’ṉii, Dánohwíí bedaagosoł’aaníí bee baa yádaałti’. Jews daanlíni gánádaadi’ṉii, Nṉee zideego begoz’aaníí doo bee daagosiil’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesus hagot’éégo datsaah doleełíí dabíí yaa nagolṉi’ n’íí begolṉe’go ánágot’įįł. ");
INSERT INTO apwNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pílate yáná’itihé yuṉe’ onanádzaago, Jesus yich’į’ hadziigo gáyiłṉii, Ya’ ni Jews ízisgo biNant’a’ ńlį́į́ née? ");
INSERT INTO apwNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus gábiłṉii, Ya’ danínik’eh ánṉii née, dagohíí ła’ ágádaashiłṉiigo nił nadaagolṉi’híí bighą ánṉii née? ");
INSERT INTO apwNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pílate gáṉíí, Ya’ shíí Jew nshłįį gá? Dani bił háńt’i’íí ła’íí ni’okąąh yedaabik’ehi itisyú nadaandeehi shaa daanidez’ąą: hago ándzaa áídá’? ");
INSERT INTO apwNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus gábiłṉii, Beshik’ehíí doo díí ni’gosdzáń biká’ begoz’ąą da: beshik’ehíí díí ni’gosdzáń biká’ begoz’ąąyúgo, Jews daanlíni doo baa shi’deltįį dahíí bighą shinadaal’a’á nadaagonłkaad doleeł ni’: n’íí beshik’ehíí díí ni’gosdzáń doo bits’ą́’dí’ begoz’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pílate gábiłṉii, Nant’án ńlį́į́ lą́ą́ ya’? Jesus gábiłṉii, Da’áígee ánṉii, Nant’án nshłįįhíí. Da’aṉii ágot’eehíí baa nagoshṉi’ doleełhíí bighą gosilį́į́, ła’íí áí bighą ni’gosdzáń biká’zhį’ niyáá. Nṉee daantį́į́gee da’aṉii zhiṉéé ádaat’eehíí shiyati’ yidits’ag doo. ");
INSERT INTO apwNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pílate gánábiłdi’ṉii, Da’aṉii ágot’eehíí nṉiihíí nt’é golzeego ágolzee? Díí ánṉiidá’ Jews daanlíni yich’į’ ch’ínánádzaago gádaayiłṉii, Díí nṉeehíí doo hago adzaa dago bígosíłsįįd. ");
INSERT INTO apwNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bitis‐hagowáh n’íí bee bíná’godiṉíhgo da’idąągee nṉee ła’ nohwá ch’ínálteehgo daagosoł’ąą: áík’ehgo Jews ízisgo biNant’a’ nohwá ch’ínánshteeh née? ");
INSERT INTO apwNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nanádaadidilghaazhgo gádaaṉii, Díí nṉeehíí dooda, Barábbas zhą́ nohwá ch’ínánłteeh. Barábbas‐híí in’įįhi nlįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pílate aṉiigo Jesus habí’oltsaz. ");
INSERT INTO apwNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Silááda ch’il diwozhi nánihezwodgo nant’án bich’ah k’ehgo alzaahi bik’edaidez’ąą lę́k’e, ła’íí diyágé łichíí dotł’izhi bá ádaagozlaa, ");
INSERT INTO apwNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Áídí’ bich’į’ hayaa ánádaat’įįgo, Gozhǫ́ǫ́ le’, Jews ízisgo biNant’a’ ńlíni! daaṉiidá’ daayołts’į́. ");
INSERT INTO apwNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pílate ch’ínánádzaago nṉee gádaayiłṉii, Kúnko, doo hago adzaa dago bígosíłsįįd, áí bídaagonołsį doleełhíí bighą nohwich’į’ bił ch’ínánsht’aazh. ");
INSERT INTO apwNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Áík’ehgo Jesus ch’il diwozhi bich’ahdá’ bi’ííhíí nṉeezi łichiigo dotł’izhi golį́į́go ch’ínyáá. Pílate gádaabiłṉii, Kú nṉeehíí sizįį nko! ");
INSERT INTO apwNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Okąąh yedaabik’ehi itisyú nadaandeehi ła’íí aasiṉilíí daabiłtsąądá’ nádaadidilghaazh, Tsį’iłna’áhi bíhołkałgo zodéé, tsį’iłna’áhi bíhołkałgo zodéé, daaṉiigo. Pílate gánádaabiłdo’ṉiid, Dánohwíí tsį’iłna’áhi bídaahołkałgo daazołhéé: shíí doo hago adzaa dago bígosíłsįįd. ");
INSERT INTO apwNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jews daanlíni gádaabiłṉii, Da’áík’ehgo nohwá goz’áni bikísk’eh datsaah dábik’eh, Bik’ehgo’ihi’ṉań biYe’ ádil’įįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pílate díí yidezts’ąądá’ dayúwehégo biini’ hą́h silįį; ");
INSERT INTO apwNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yáná’itihé yuṉe’ ha’ánánádzaago Jesus gáyiłṉii, Hadí’ nanṉáhi? Ndi Jesus doo bich’į’ hadzii da. ");
INSERT INTO apwNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Áík’ehgo Pílate gábiłṉii, Ya’ doo shich’į’ handziih da née? Ya’ ch’ínáninshteehgo dagohíí tsį’iłna’áhi bíni’dilkałgo beshik’ehíí doo bígonłsį́ da née? ");
INSERT INTO apwNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus gábiłṉii, Doo shenik’eh da doleeł ni’, yaaká’dí’ doo naa godet’ąą dayúgo: áí bighą hadíń naa shinłtííníí itisgo nchǫ’go adzaa. ");
INSERT INTO apwNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Áídí’ Pílate ch’ínábíłteeh hat’į́į́: ndi Jews daanlíni nádaadidilghaazhgo gádaaṉii, Díí nṉee ch’ínánłteehyúgo doo Caesar bit’eké ńlį́į́ da: dahadíń ízisgo nant’án ádil’iiníí Caesar yits’ą́’zhį’go na’ídiltee. ");
INSERT INTO apwNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Díí yidezts’ąądá’ Jesus yił ch’ín’áázhgo Pílate yánáltihíí biká’asdáhá yiká’ dahnezdaa, áí Pavement golzeegee ánágot’įįł, Hebrew k’ehgo Gábbatha golzéhi. ");
INSERT INTO apwNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bitis‐hagowáh n’íí bee bíná’godiṉíhíí bá iłch’į’golṉéhíí bijįį, gostáń bik’ehenkéézyú shį: Pílate Jews daanlíni gádaayiłṉii, Kú nohwiNant’a’ sizįį nko! ");
INSERT INTO apwNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Áídá’ nádaadidilghaazh, Zodéé, zodéé, tsį’iłna’áhi bíhołkał. Pílate gánádaabiłdo’ṉiid, Ya’ nohwiNant’a’ tsį’iłna’áhi bíhishkałgo zis‐héé née? Okąąh yedaabik’ehi itisyú nadaandeehi gádaaṉii, Caesar zhą́ nohwinant’a’ nlįį. ");
INSERT INTO apwNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Áídí’ Pílate Jews daanlíni yaa daabistįį, tsį’iłna’áhi yídaabiłkałgo. Áík’ehgo Jesus nádaidnłt’e’go yił onałsą́ą́ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesus dabíí bitsį’iłna’áhi yogheełgo, itsits’in si’áni, golzeego ágolzéhi goz’ąązhį’ bił náńzą́ą́, áí Hebrew k’ehgo Gólgotha golzee: ");
INSERT INTO apwNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Akú Jesus tsį’iłna’áhi yídaayiskał, ła’íí nṉee naki ałdó’ ba’ashhahdí’ tsį’iłna’áhi bídaabi’deskał, Jesus iłṉí’gee dahdaistįįdá’ nṉeehíí dá’ił’an dahshteezh. ");
INSERT INTO apwNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pílate k’e’eshchįį, JESUS NÁZARETHDÍ’ GÓLÍNI JEWS ÍZISGO BINANT’A’ NLÍNI, golzeego dahgoz’áni tsį’iłna’áhi yiká’ yíyiskał. ");
INSERT INTO apwNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jews daanliiníí łą́ą́go k’e’eshchiiníí daayozhi’; Jesus tsį’iłna’áhi bíheskałíí kįh gozṉilíí da’ałhánégo goz’ąą: áík’e’eshchiiníí Hebrew, Greek, ła’íí Latin k’ehgo k’e’eshchįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jews bi’okąąh yedaabik’ehi itisyú nadaandeehi Pílate gádaayiłṉii, Jews biNant’a’ nlįį, doo ágóléh da; Jews biNant’a’ nshłįį ṉiigo ágóléh. ");
INSERT INTO apwNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pílate hanádzii, Nt’é ágoshłaahíí iłk’idá’ ágoshłaa, ṉii lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Silááda Jesus tsį’iłna’áhi yídaiskałdá’, bidiyágéhíí dį́į́yú iłk’ídaizṉil, dántį́į́gee dała’á bíyéégo; iká’ííhíí doo hadilkad da: ndi dahot’éhé bida’zhį’ ngont’i’go histł’ool. ");
INSERT INTO apwNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Áík’ehgo gádaałiłdi’ṉii, Díí doo k’ad ndaahiidzǫǫs da, daazhógo bighą da’doljołgo, hadíń gonesnaahíí bíyéé doleeł: díínko Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí begolṉé’go ánágot’įįł, Shidiyágéhíí iłta’is’ṉii, shi’ííhíí bighą da’diłjoł. Áík’ehgo silááda díí ye’ánádáát’įįd. ");
INSERT INTO apwNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesus tsį’iłna’áhi bíbideskałíí ba’ashhahgee bą́ą́ ła’íí bą́ą́ bik’isn, Mary, Cléophas bi’aad, ła’íí Mary Mágdalene nazįį lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus bą́ą́ hik’e bitsiłke’yu dała’á bił nzhónihíí ba’ashhahgee nazįįgo yiłtsąądá’, bą́ą́ gáyiłṉii, Shimaa, kú nizhaazhé! ");
INSERT INTO apwNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Áídí’ bitsiłke’yu dała’á siziiníí, Kú nimaa! yiłṉii. Áídí’ godezt’i’go yił onát’aazh, bitsiłke’yu bigowąyú. ");
INSERT INTO apwNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Díí bikédí’go Jesus dawa ąął alzaahíí yígółsįgo, Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí begolṉe’go gáṉíí, Dibá’ sélį́į́. ");
INSERT INTO apwNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Áígee nk’ǫ́zhi, vinegar holzéhi, ts’aa bee sikąą: tú daayiłt’o’íí vinegar yee daiz’ąądí’ tsį nṉeezi hýssop holzéhi, bílátahgee yaa dahdaiz’ąągo, Jesus bizé’zhį’ dahyída’nłtsii. ");
INSERT INTO apwNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesus vinegar yits’ǫ́ǫ́zdá’ gáṉíí, Ąął alzaa: áídí’ hayaa onot’ąądá’ dabíí biyi’sizíni be’ogoyáágo áyíílaa lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iłch’į’golṉe’íí bijįį lę́k’e, áí godilziníí bijįį (dázhǫ́ nzhǫǫgo godilzįhgo,) Jews daanlíni kots’í tsį’iłna’áhi biká’ dahnaztįįgo doo bił dádaabik’eh dahíí bighą bijád daahotį́hgo nanáhó’ṉííł, daayiłṉiigo Pílate nádaayoskąąd. ");
INSERT INTO apwNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Áík’ehgo silááda hikaigo Jesus ba’ashhahdí’ tsį’iłna’áhi bídaahiskałíí dantséhíí bijád daayihestį’, ła’ihíí ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Áídá’ Jesus yaa hikaigo, iłk’idá’ daztsąągo yídaagołsįįdhíí bighą yijád doo daayiheztį’ da. ");
INSERT INTO apwNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Silááda ła’ ba’ask’eh yuṉe’ bésh nṉeezíí oyiłgeed, áídí’ dagoshch’į’ dił ła’íí tú bił ha’ijool. ");
INSERT INTO apwNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Áí yo’įįhń yaa nagolṉi’, na’goṉi’íí da’aṉii; da’aṉiigo nagolṉi’go yígółsį, nohwíí ałdó’ da’ohdląą doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Díí be’ánágot’įįdíí Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí, Bits’in doo ła’ k’e’íltǫǫd da doleeł, ṉiihíí begolṉe’go ágodzaa. ");
INSERT INTO apwNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí ła’i ałdó’ gánádi’ṉii, Hadíń yighátsi’nłgeedíí áń daineł’įį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Díí bikédí’go Joseph, Arimathéadí’ gólíni, Jesus yits’ą́’dí’ ígoł’aahíí nlíni, dánant’į’ego Jews daanlíni yénáldzidhíí bighą, áń Jesus bits’íhíí yíyókeed: áík’ehgo Pílate baa godin’ą́ą́. Akú ńyáágo Jesus bits’íhíí naidnné’. ");
INSERT INTO apwNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodémus ałdó’, tł’é’yú Jesus yaa nyáá n’íí, jeeh nch’í’i, myrrh holzéhi, aloes bił nadesdziidi, dała’á gonenadín dahdidlee’i shį yogheełgo nyáá. ");
INSERT INTO apwNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jesus bits’íhíí nádaidnné’go nak’ą’łigaihi yik’ídaidesdiz, łikągolchiníí biłgo, Jews daanlíni nṉee łedaihiṉiiłhíí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tsį’iłna’áhi bíheskałgee dégózhóné goz’ąą: áí biyi’ tsébii’i’áń áníidéhi goz’ąą, doo hwahá hadíń ákóṉe’ nnilteehi da. ");
INSERT INTO apwNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jews daanlíni iłch’į’golṉe’íí bijįįhíí bighą, ła’íí tsébi’i’áń da’ałhánédí’ goz’ąąhíí bighą Jesus bits’í ákóṉe’ ndaizné’ lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Godilziníí bijįį Mary Mágdalene, t’ahbį, t’ah godiłhiłdá’ tsébii’i’áńyú Jesus łe’sitįį n’íígee nyáá, ńt’éégo tséé daadin’ą́ą́ n’íí yó’ot’ąągo yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Áídí’ nádilwod, Simon Peter hik’e Jesus bitsiłke’yu ła’íí, Jesus bił nzhǫǫ n’íí, yiłgo yaa hílwodgo gáyiłṉii, NohweBik’ehń tsébii’i’áńdí’ ch’ídaistįį lą́ą́, hayú ndaistįį shįhíí doo bídaagonlzį da. ");
INSERT INTO apwNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Áík’ehgo Peter hik’e Jesus bitsiłke’yu ła’ihíí biłgo ch’íń’áázhgo tsébii’i’áńyú ó’áázh. ");
INSERT INTO apwNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Dała’ nátsidnłteel: ndi bitsiłke’yu ła’ihíí Peter yaa dilwod, tsébii’i’áńyú dantsé hílwod: ");
INSERT INTO apwNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ts’íyaa adzaago ákóṉe’ déz’įįdgo nak’ą’łigaihíí zhą́ akú siṉilgo yiłtsąą, ndi doo ha’ayáá da. ");
INSERT INTO apwNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Peter ákú ńyáá dábiké’, áń tsébii’i’áń yuṉe’ ha’ayáágo nak’ą’łigaihíí zhą́ siṉilgo yiłtsąą, ");
INSERT INTO apwNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nak’ą’łigai bitsits’in bik’ídesdiz n’íí dasahn hisdisgo aṉahyú siné’, doo nak’ą’łigai ła’ihíí bił siṉil da. ");
INSERT INTO apwNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Bitsiłke’yu ła’i tsébii’i’áńyú dantsé hílwodíí ałdó’ ha’ayáágo yiłtsąągo osdląąd. ");
INSERT INTO apwNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí, Daztsąądí’ naadiidáh doleeł, ṉiihíí doo hwahá bił ídaagozįįh da. ");
INSERT INTO apwNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Áídí’ bitsiłke’yu bigowąyú onát’aazh. ");
INSERT INTO apwNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary tsébii’i’áńgee hichago sizįį: hichagdá’ ts’íyaa adzaago tsébii’i’áń yuṉe’ déz’įįd, ");
INSERT INTO apwNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bik’ehgo’ihi’ṉań binal’a’á yaaká’dí’hi naki bidiyágé daałigaihi, Jesus bits’í siné’ n’íígee sikeego yiłtsąą, ła’ nés’ąą n’íígee sidaago, ła’íí dés’eez n’íígee. ");
INSERT INTO apwNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Gádaabiłṉii, Isdzán, nt’é bighą nchag? Mary gábiłṉii, SheBik’ehń nádaidnłtįį ląą, hayú ndaistįį shįhíí doo bígonsį da. ");
INSERT INTO apwNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ágánṉiidá’ t’ąązhį’ adzaago Jesus sizįįgo yiłtsąą, ndi Jesus at’į́į́híí doo yígołsįįd da. ");
INSERT INTO apwNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus gábiłṉii, Isdzán, nt’é lą́ą́ bighą nchag? Hadíń biká díń’įį? Áí ni’ goz’aaníí dégózhónégo ágółsiníí át’į́į́ lą́ą́ nzįgo gáyiłṉii, Jesus bits’íhíí nádńłtįį lę́k’eyúgo, hayú nńłtįį shįhíí shił nagolṉí’, áík’ehgo nadishné’. ");
INSERT INTO apwNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus, Mary, biłṉii. Mary łediidzaago Hebrew k’ehgo, Rabbóni, biłṉii; shiłch’ígó’aahíí golzeego ágolzee. ");
INSERT INTO apwNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus gábiłṉii, Shedinołchid hela’; doo hwahá shiTaa bich’į’ dahnádishdáh dahíí bighą: áídá’ shik’isyú bich’į’ nṉáhgo shá bił nadaagolṉí’, ShiTaa, nohwíí ałdó’ nohwiTaa, Bik’ehgo’ihi’ṉań hoshkąąhń, nohwíí ałdó’ Bik’ehgo’ihi’ṉań daahohkąąhń bich’į’ nádésdzá. ");
INSERT INTO apwNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Áík’ehgo Mary Mágdalene Jesus bitsiłke’yu yaa nyáágo gádaayiłṉii, NohweBik’ehń hish’į́į́, áídí’ ábiłṉii n’íí yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Da’áí bijįį o’i’ą́ą́yú, godilziníí bijįį, Jesus bitsiłke’yu íła’adzaa lę́k’e, Jews daanlíni yédaaldzidhíí bighą dáádítį́híí da’dentą́ą́dá’ Jesus bitahyú sizįįgo daayiłtsąą, nt’éégo gábiłṉii, Iłch’į’gont’ééhíí bee nohwich’į’ goz’ąą le’. ");
INSERT INTO apwNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ágánṉiidá’ bigan ła’íí ba’ask’ehgeehíí yił ch’í’ṉah áyíílaa. Bitsiłke’yu beBik’ehń daayiłtsąądá’ bił daagozhǫǫd. ");
INSERT INTO apwNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesus gánádaabiłdo’ṉiid, Iłch’į’gont’ééhíí bee nohwich’į’ goz’ąą le’. ShiTaa shides’a’híí k’ehgo nohwíí ałdó’ daanohwidish’aa. ");
INSERT INTO apwNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ágánṉiidá’ yiká’zhį’ deyołgo gádaayiłnṉiid, Holy Spirit nohwaa det’ąą: ");
INSERT INTO apwNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Dahadíń binchǫ’híí bighą baa nágodenoh’ąąhíí, áí binchǫ’íí baa nágodet’ąą; dahadíń binchǫ’híí bighą doo baa nágodenoh’ąą dahíí, binchǫ’íí t’ah yegoyiłį́į́. ");
INSERT INTO apwNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Thomas, nakits’ádahíí itah nlíni, Dídymus holzéhi, Jesus nyáádá’ doo áígee itah sidaa da lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bitsiłke’yu ła’ihíí bił nadaagolṉi’, NohweBik’ehń daahiiltsąą, daabiłṉiigo. Thomas gáṉíí, Bigan biyi’ bésh bikísk’eh nagoz’ąąhíí hish’įįyúgo zhą́, bésh odaaz’aa n’íí yuṉe’ nadishṉiihgo, ła’íí ba’ask’ehgee o’i’áń yuṉe’ nadishṉiihyúgo zhą́ oshdląą doleeł. ");
INSERT INTO apwNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tsebíí yiskąą hik’e Jesus bitsiłke’yu kįh yuṉe’ naháztąą lę́k’e, k’adíí Thomas biłgo: áígee dáádítį́h da’dentą́ą́ ndi Jesus ákóṉe’ bitahyú sizįįgo nanádaayiłtsąągo gábiłṉii, Iłch’į’gont’ééhíí bee nohwich’į’ goz’ąą le’. ");
INSERT INTO apwNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Áídí’ Thomas gáyiłṉii, Dząą bedenłṉíhgo shigan ńńł’įį; yushdé’ dahdenłṉíhgo sha’ask’ehgee o’i’áńhíí nabik’íńłṉiih; doo odląą dahíí doo ńlį́į́go da, ondląą le’. ");
INSERT INTO apwNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas gábiłṉii, SheBik’ehń, Bik’ehgohinshṉahń ńlį́į́ lą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus gábiłṉii, Shi’į́į́híí bighą shosíńdląąd: hadíń doo sho’įį da ndi shodlaaníí biyaa gozhǫ́ǫ́ doo. ");
INSERT INTO apwNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus bitsiłke’yu biṉááł godiyįhgo áná’ol’įįłíí łą́ą́go áyíílaa, ła’ díí naltsoosíí biyi’ doo bak’e’eshchįį da: ");
INSERT INTO apwNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Áídá’ Jesus, Christ nlįį, ła’íí Bik’ehgo’ihi’ṉań biYe’ nlįį daahohdląą doleełgo; áídí’ daahohdląągo bizhi’íí biláhyú daahinohṉaa doleełhíí bighą díí bak’e’eshchįį. ");
INSERT INTO apwNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Díí bikédí’go túsikaaníí Tibérias golzéhi bahgee Jesus bitsiłke’yu yich’į’ ch’í’ṉah áná’delzaa; díí k’ehgo ch’í’ṉah áná’delzaa. ");
INSERT INTO apwNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas, Dídymus holzéhi, Nathánael, Gálilee biyi’ Cánagee golíni, Zébedee biye’ke, ła’íí Jesus bitsiłke’yu naki dawa dała’ naháztąą lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter gádaabiłṉii, Ha’ishłeehyú déyáá. Yił nakaihíí gádaabiłṉii, Néé ałdó’ ákú nił nkáh. Dahiskaigo dagoshch’į’ tsina’eełíí yiyi’ okai; áí bitł’é’ doo nt’é hadaizlee da. ");
INSERT INTO apwNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hayołkaałdá’ Jesus tábąąyú sizįį; áídá’ bitsiłke’yu Jesus at’ííníí doo yídaagołsį da. ");
INSERT INTO apwNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesus gádaabiłṉii, Shichągháshé, łóg ła’ hadaasolee née? Dah, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Gánádaayiłdo’ṉiid, Tsina’eełíí dihe’ṉazhiṉéégo łóg behaidlehé nanestł’ólihíí tédaałkaad, áík’ehgo ła’ hadaahłeeh. Áídí’ áí tédaiskaad nt’éégo łóg dázhǫ́ łą́ą́híí bighą doo hagot’éégo hadaiłtįį bik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Bitsiłke’yu dała’á Jesus bił nzhónihíí Peter yich’į’ gáṉíí, NohweBik’ehń át’į́į́ ląą. Simon Peter hadíń át’ííníí yaa idezts’ąądá’, na’idziid bighą bi’íí ádayidiltsooz n’íí ánágodlaago tayi’ yáhít’ag. ");
INSERT INTO apwNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jesus bitsiłke’yu ła’ihíí, łóg behaidlehé nanestł’ólihíí łóg bee halk’iłgo daidołshoołgo, tsina’eełíí yee hikai, (doo aṉahdí’ táts’á ngont’i’ da, dała’á gonenadín da’des’eezyú shį.) ");
INSERT INTO apwNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Táts’á haskaidá’ tsííd diltłi’go, łóg ła’íí báń biłgo kǫ’ká’ siṉilgo daayiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus gádaabiłṉii, Łóg hadaasolee’íí ła’ deda’nohṉiił. ");
INSERT INTO apwNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter, tsina’eełíí yiyi’ oyáágo, łóg behaidlehé nanestł’ólihíí łóg nchaahíí bee halk’iłgo tábąązhį’ nyidenłshóód, łógíí dała’á gonenadín biká’yú ashdladin taagi: łóg dázhǫ́ łą́ą́ ndi łóg behaidlehé nanestł’ólihíí doo odláád da. ");
INSERT INTO apwNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus gádaabiłṉii, Yushdé’ da’ohsąą. Bitsiłke’yu daaste’go doo ła’, Hadíń ánt’įį? daabiłṉii da, beBik’ehń át’į́į́go yídaagołsįįdhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Áídí’ Jesus báń náidnné’go bita’izné’, łóg ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Díí biłgo taadn Jesus bitsiłke’yu yich’į’ ch’í’ṉah ádelzaa, daztsąądí’ naadiidzaahíí bikédí’go. ");
INSERT INTO apwNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ąął da’iyąądá’ Jesus Simon Peter gáyiłṉii, Simon, Jonas biye’ ńlíni, ya’ díí bitisgo nił nshǫǫ née? Peter gábiłṉii, Ha’oh, sheBik’ehń; shił nzhóóníí bígonłsį́. Jesus gánádo’ṉiid, Shidibełį́į́ bizhaazhé shá biza’hiṉííł. ");
INSERT INTO apwNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nakidngee Jesus gánábiłdo’ṉiid, Simon, Jonas biye’ ńlíni, nił nshǫǫ née? Peter gábiłṉii, Ha’oh, sheBik’ehn, shił nzhóóníí bígonłsį́ gádnii. Jesus gánábiłdo’ṉiid, Shidibełį́į́ shá biza’hiṉííł. ");
INSERT INTO apwNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Taadngee gánábiłdo’ṉiid, Simon, Jonas biye’ ńlíni, nił nshǫǫ née? Peter doo bił gozhǫ́ǫ́ da, taadn, Nił nshǫǫ née? biłnṉiidhíí bighą. Áík’ehgo Peter gábiłṉii, SheBik’ehń dáwa bígonłsį́ gádnii; shił nzhóóníí bígonłsį́. Jesus gánábiłdo’ṉiid, Shidibełį́į́ shá biza’hiṉííł. ");
INSERT INTO apwNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Da’aṉii, da’aṉiigo gániłdishṉii, Áníi nanṉaadá’ dani ák’ená’ídlééhgo, dahánt’įįyú nanṉaa ni’: hastiin síńlįįgohíí iłts’ą́’ dahdńlṉihdá’, ła’ n’íí ná ágole’go, doo hánt’įį dayú nidiłteeh doo. ");
INSERT INTO apwNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Díí Jesus yee ánṉiid, da’itsaah daat’éhi Peter yee datsaahgo Bik’ehgo’ihi’ṉań ízisgo ye’at’ééhíí ch’í’ṉah ádolṉiiłgo. Ágánṉiidá’ Peter, Shiké’ híṉááł, yiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter t’ąązhį’ déz’įįdgo, Jesus bitsiłke’yu bił nzhónihíí biké’ higaałgo yiłtsąą; áń da’iyą́ą́ n’íígee Jesus bitíldí’ yínentį́į́dá’, SheBik’ehń, hadííhíí ch’íní’aah doleeł? nṉiid lę́k’e. ");
INSERT INTO apwNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter biłtsąądá’ Jesus gáyiłṉii, SheBik’ehń, láí nṉeehń hago anṉéh áídá’? ");
INSERT INTO apwNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus gábiłṉii, Hasht’į́į́yúgo nánisdzaazhį’ hiṉaa, hant’é naninłtł’og áízhį’? Nkú shiké’ híṉááł! ");
INSERT INTO apwNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Áí bitsiłke’yu dała’á doo datsaah da, ch’iṉiihíí Jesus yił nakaihíí bitah didezdlaad: ndi Jesus, Doo datsaah da, doo biłnṉiid da; daazhógo, Hasht’į́į́yúgo nánisdzaazhį’ hiṉaa, hant’é naninłtł’og áízhį’, biłnṉiidá’. ");
INSERT INTO apwNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Da’áń, doo datsaah da, daałch’iṉiihíí biṉááł díí dawa ánágot’įįł lę́k’ehíí yaa nagolṉi’dí’ yak’e’eshchįį ałdó’: yaa nagosṉi’íí da’aṉiigo bídaagonlzį. ");
INSERT INTO apwNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ła’íí łą́ą́go ałdó’ Jesus ánát’įįd; áí dawa naltsoos bee álzaayúgo, ni’gosdzáń biká’ doo hayú bá goz’ąą da doleeł shį nsį. ");
INSERT INTO apwNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Theóphilus ńlíni, ałk’iná’ Jesus ánát’įįłíí ła’íí iłch’ígó’aah nkegonyaahíí dawa naltsoos biká’ ashłaa, ");
INSERT INTO apwNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Binadaal’a’á hahesṉilíí Holy Spirit binkááyú bił ch’ídaagoz’ąąná’ yaaká’yú onádzaazhį’ áí naltsoos biyi’ baa nagosisṉi’: ");
INSERT INTO apwNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesus biniigodelzaahíí bikédé’go dizdin yiskaaníí biyi’ binadaal’a’á bich’į’ ch’í’ṉah ánádil’įįh, da’aṉii hiṉaago yídaagołsįįhíí bighą, ła’íí Bik’ehgo’ihi’ṉań bilałtł’áhgee bėgoz’aaníí bich’į’ zhiṉéégo ágot’éhihíí baa yił nadaagolṉi’: ");
INSERT INTO apwNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","T’ah yił naháztąąná’ gádaabiłṉii, Jerúsalem bich’ą́’ daadołkáh hela’ shiTaa aṉííhíí begolzaazhį’, áí baa nohwił nagosisṉi’ n’íí. ");
INSERT INTO apwNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John da’aṉii tú bee baptize áił’įį ni’; áíná’ nohwíí da’kwíí yiskąągo Holy Spirit bee baptize ádaanohwi’dolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Łaahikaiyú nayídaadiłkid gádaaṉiigo, NohweBik’ehń, ya’ dák’ad Israel hat’i’i dabíí naałidziidgo ánándle’ née? ");
INSERT INTO apwNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Áígé’ Jesus bich’į’ hananádzii, Hagee ágoṉe’ihíí nohwíí doo hago’at’éégo bídaagonołsį bik’eh da, shiTaa zhą́ yebik’ehi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Holy Spirit nohweh hiyáágo nohwinawod goleeh: áígee Jerúsalemyú, Judéayú, Samáriayú ła’íí ni’gosdzáń nánel’ąąyú shaa nadaagołṉi’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ąął yaa hadzii’íí bikédé’go binadaal’a’á t’ah daineł’į́į́go dahbi’didiltįįgo yaak’os biyi’ yuṉe’ bił ogoyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bił ogoyááyú binadaal’a’á t’ah daadéz’įįgo nṉee naki bidiyágé daałigaihi bit’ahgé’ daahizį’go; ");
INSERT INTO apwNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Gádaabiłṉii, Gálileegé’ nṉee daanołíni, hat’íí bighą yaaká’yú daadeł’į́į́? Díí Jesus yaaká’yú nohwich’ą́’ onábi’doltįįgo daał’iiníí da’áí k’ehgo nádodaał dahagee. ");
INSERT INTO apwNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Áígé’ binadaal’a’á dził Ólivet golzeegé’ Jerúsalemzhį’ nákai, áí da’áłhání, Jews daagodnłsiníí bijįį oná’iłdahíí ga’áhosahyú goz’ąą lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nákaiyú dák’ehéyú nágost’ąą yuṉe’ onákai, áígėe Peter, James, John, Andrew, Philip, Thomas, Barthólemew, Matthew, James, Alphéus biye’, Simon Zelótes, ła’íí Judas, James bik’isn, naháztąą. ");
INSERT INTO apwNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kóṉe’ áí dawa isdzáné ła’, Mary, Jesus bimaa, ła’íí Jesus bik’isyú biłgo dała’á daabiini’go da’okąąh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Áíná’ Jesus daayodlaaníí dała’án gonenadínhíí biká’yú nadin shį dała’adzaagee Peter da’iłṉí’gé’ hizį’go gáṉíí, ");
INSERT INTO apwNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Nṉee daanołíni, shik’ííyú, Judas, Jesus ha’ádaizt’e’ n’íí yágo’iiníí, doo hwahá ágoṉe’ daná’ Holy Spirit David binkááyú yałti’go baa nagolṉi’ n’íí, áí Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí baa nagolṉi’íí begolṉe’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas nohwitah nlįįgo bíí biłgo Jesus bá nada’iidziidgo baa godet’ąą ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Áí nṉee nchǫ’go adzaahíí bideṉá bich’į’ nahesṉilíí bee ni’ nagohesṉii’, áígé’ ts’íyaa nago’go bibid desdohgo bich’í haago’. ");
INSERT INTO apwNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Díí Jerúsalemgee daagolííníí dawa yídaagołsįgo ni’ihíí dabíí biyati’ k’ehgo Akéldama daayiłṉii, áí Dił Ni’goz’áni golzeego ágolzee. ");
INSERT INTO apwNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Naltsoos Psalms holzeehíí biyi’ gát’éégo bek’e’eshchįį, Golį́į́ n’íígee dénchǫ’égo yó’ogolṉe’go, doo hadń gólį́į́ da doleeł: ła’íí, Na’iziid n’íígee ła’ nnánólteeh. ");
INSERT INTO apwNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Jesus nohwitahyú naghaaná’ nṉee ła’ bił nahikai ni’, ");
INSERT INTO apwNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","John nṉee baptize ádaił’įįgé’ godezt’i’go Jesus nohwich’ą́’ onábi’doltįįzhį’, áí nṉeehíí ła’ hanábi’doltéeh, áń Jesus naadiidzaahíí yo’iiníí bíí ałdó’ bił baa nadaagohiilṉi’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Áík’ehgo naki hadaizlaa, Joseph, Bársabas holzéhi, iké’yú bizhi’íí Jústus holzee, ła’íí Matthías biłgo. ");
INSERT INTO apwNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Áígee da’okąąhgo gádaaṉii, NohweBik’ehń, ni nṉee bijíí dawa bígonłsį́, díí nṉee naki halzaahíí hayíí hánłtiiníí nohwił ch’í’ṉah ánle’, ");
INSERT INTO apwNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas dabíí bá goz’ąąyú dahdidogaałgo, ná na’iziid n’íí, ninal’a’á nlįį n’íí yich’ą́’zhį’ adzaa, áík’ehgo nṉee hánłtiiníí áígee nnaltéeh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dahadń halteehíí bee bígozįįhíí ádaizlaa, áík’ehgo Matthías haltįį: áń nadaal’a’á itah silįį, łats’ádah zhą́go ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Péntecost‐híí bijįį Jesus daayokąąhíí dała’á daabiini’go dałahágee dała’adzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Dahį́ko yaaká’gé’ nawode ńch’iidhíí k’ehgo áhíłts’ą́ą́go naháztąą yuṉe’ dahot’éhé bengonyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kǫ’ izaad ga’at’éhi iłts’ą́’go adzaago dała’á daantį́į́go biká’zhį dahiltłi’go bił ch’í’ṉah ádelzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Holy Spirit bee baa daagodest’ąągo yati’ iłtah at’éhi yee yádaałti’go nkegonyaa, Holy Spirit áí k’ehgo yádaabiyiłti’. ");
INSERT INTO apwNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Áíná’ Jews daanlíni Bik’ehgo’ihi’ṉań daidnłsíni, ni’gosdzáń nánel’ąągé’ Jerúsalemyú nádaagosdle’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Díí baa ch’iṉiiná’ nṉee łą́ą́go dała’adzaago hago ląą ágodzaa daanzį, dała’á daantį́į́go bíí biyati’ yee yádaałti’go da’dezts’ąą’híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Dázhǫ́ bił díyagodzaago gádaałiłdi’ṉii, Sąą’a, aishą’ dawa Gálileegé’ nṉeehíí ádaaṉii? ");
INSERT INTO apwNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Áíná’ hago’at’éégo dánohwíí daanohwiyati’íí yee yádaałti’go daadiits’ag? ");
INSERT INTO apwNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Párthians, Medes, Élamites, ła’íí nṉee Mesopotámia, Judéa, Cappadócia, Póntus, Asia, ");
INSERT INTO apwNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrýgia, Pamphýlia, Egypt ła’íí Líbya Cyréne biṉaayú ił’angé’ łedaadiltíni, ła’íí Romegé’ dét’įh hasta’ hikaihi, Jews ła’íí nṉee Jews bi’okąąhíí k’eh da’okąąh daazlíni, ");
INSERT INTO apwNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cretes ła’íí Arábians daanlíni, dánohwíí daanohwiyati’ yee yádaałti’go Bik’ehgo’ihi’ṉań ízisgo ánát’įįłíí yaa nadaagolṉi’go daadiits’ag. ");
INSERT INTO apwNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Áík’ehgo dawa bił díyadaagodzaa ła’íí hago ląą ágodzaa daanzįgo gádaałiłdi’ṉii, Dííshą’ hago ánágot’įįłihi? ");
INSERT INTO apwNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ła’íí daazhógo déyaadaadlohgo gádaaṉii, Díí nṉeehíí wine áníidéhi daayodląągo ádaaṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Áíná’ Peter łats’ádahíí yił daahizį’go nṉee dała’adzaahíí yich’į’ hadzii, Nṉee Judéagé’ ła’íí Jerúsalemgee daagonołíni, díí ádishṉiihíí nłt’éégo hódaayisółts’ąągo nohwił ídaagozį le’: ");
INSERT INTO apwNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Díí nṉeehíí bił nádaagodiyis ádaanołsį ndi doo ágát’éé da, ánaazhą́ ngost’áí bik’ehenkééz la’. ");
INSERT INTO apwNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Áíná’ Joel, Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí díí ánágot’įįłíí dabí’iłtséná’ yaa nagosṉi’ ni’ gánṉiidgo; ");
INSERT INTO apwNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Bik’ehgo’ihi’ṉań gáṉíí, Ikék’eh nnágodzaayú be’ágodoṉiił, nṉee dawa shiSpirit baa daadish’a’ doleeł: nohwiye’ke ła’íí nohwitsi’ke dawa ágodoṉiiłíí shá yaa nadaagolṉi’ doleeł, nṉee áníi nakaiyehíí bił ch’í’ṉah ádaagol’įį doleeł, hastįyúhíí nadaayeeł doleeł: ");
INSERT INTO apwNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Áí benagowaaná’ nṉee shánada’iziidíí ła’íí isdzáné shánada’iziidíí shiSpirit baa daadish’a’ doleeł; áík’ehgo ágodoṉiiłíí shá yaa nadaagolṉi’ doleeł: ");
INSERT INTO apwNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yáá biyi’ ízisgo ánágot’įįłíí ch’í’ṉah ádeshłiił, ni’ biká’ godiyįhgo be’ígóziníí, áí dił, kǫ’, ła’íí łid aad k’ehgo at’éégo ałdó’ ch’í’ṉah ádeshłiił: ");
INSERT INTO apwNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Dá doo nohweBik’ehń nadáhíí bijįį, dázhǫ́ gonłt’ééhíí bijįį biká’ ngowaa daná’ ch’ígona’áíhíí diłhił doleeł, tł’é’gona’áíhíí dił doleeł: ");
INSERT INTO apwNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Áíná’ hadń Bik’ehgo’ihi’ṉań bizhi’íí yee yiká áṉiihń hasdádogaał. ");
INSERT INTO apwNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israel hat’i’íí daanołíni, díí yati’íí ídaayesółts’ąą; nohwíí bídaagonołsį go’į́į́, Jesus Názarethgé’ nlíni, Bik’ehgo’ihi’ṉań nohwiṉááł Jesus binkááyú ízisgo áná’ol’įįłíí ła’íí godiyįhgo be’ígóziníí ánáyo’įįłgo nohwich’į’ bee bígózįgo áyíílaa: ");
INSERT INTO apwNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Áí Jesus‐híí Bik’ehgo’ihi’ṉań dabíntsé yaa natsekeesgo yaa nagoshchįįgo nohwaa hííltį́į́go nṉee begoz’aaníí doo yikísk’eh ádaat’ee dahíí nohwíí ádaabiłdołṉiigo tsį’iłna’áhi yídaayiheskałgo daayizes‐hį́į́: ");
INSERT INTO apwNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Áíná’ Jesus nezgaigo da’itsaahíí Bik’ehgo’ihi’ṉań nláhyú áyíílaaná’ nábihil’ṉa’: da’itsaahíí doo dayúweh botą’ bik’eh dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David Jesus yaa nagolṉi’go gáṉíí, SheBik’ehń dawahn shádnyú hish’įį; shinawod shá ágółsįhíí bighą shigan dihe’nazhiṉéégo nlįį: ");
INSERT INTO apwNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Áí bighą shijíí bił gozhǫ́ǫ́ ła’íí sizaa gozhǫ́ǫ́go yashti’; ła’íí áń zhą́ ba’oshłíígo shits’í hanayoł doleeł: ");
INSERT INTO apwNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Shiyi’siziiníí ch’iidntahyú doo nyinoné’ at’éé dahíí bighą, Dilzini Nlíni ṉíyééhíí diłdzidihíí bich’ą́’zhį’ ánłsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Hago’at’éégo ch’ihiṉaa doleełíí shił ch’í’ṉah áńlaa; shił ńlį́į́go dázhǫ́ shił gozhǫ́ǫ́go áshíłsį. ");
INSERT INTO apwNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nṉee daanołiiníí, shik’ííyú, bich’ą́’gé’ daagosiidlíni David holzéhi, doo siste’ dago da’aṉiigo baa nohwił nagoshṉi’, daztsąągo iłch’į’nniltį́į́ ni’, iłch’į’nniltį́į́ n’íí dííjįį t’ah dząągee begoz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David Bik’ehgo’ihi’ṉań binkááyú na’iziidíí nlįį ni’, ła’íí Bik’ehgo’ihi’ṉań bitł’a dahdidilṉiigo gábiłnṉiid, Nich’ą́’gé’ hadaałishchiiníí ła’, Christ holzéhi, benik’eh n’íí yebik’ehgo ádishłiił, nṉiigo yígółsį; ");
INSERT INTO apwNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Áík’ehgo áí dabí’iłtsé yígółsįgo Christ nábi’dihil’ṉa’híí baa nagolṉi’ gánṉiidgo, Biyi’siziiníí ch’iidntahyú doo yó’oyoṉe’ da, ła’íí bits’íhíí doo diłdzid da. ");
INSERT INTO apwNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Díí Jesus‐híí Bik’ehgo’ihi’ṉań nábihil’ṉa’híí daanohwigha nohwiṉááł ágodzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ízisgo at’éégo ábi’delzaago Bik’ehgo’ihi’ṉań bigan dihe’nazhiṉéégo sidaago, ła’íí Holy Spirit higháh doleełíí biTaa bee bángon’ą́ą́go díí daał’įįhíí ła’íí daadołts’agíí bíí áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David yaaká’yú doo bił ogoyáá da; ndi dabíí gáṉíí, Bik’ehgo’ihi’ṉań sheBik’ehń gáyiłnṉiid, Shigan dihe’nazhiṉéégo síńdaa, ");
INSERT INTO apwNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ni’ina’íí benik’eh silįįgo nikełtł’ááhyú niníṉilzhį’. ");
INSERT INTO apwNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Áí bighą Israel hat’i’íí dawa da’aṉiigo díí yídaagołsį le’, Jesus‐híí tsį’iłna’áhi bídaahesołkał n’íí Bik’ehgo’ihi’ṉań nohweBik’ehń, Christ nlįįgo nohwá áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nṉee díí daidezts’ąąná’ bił daagoshch’ii’ lę́’e, áígé’ Peter ła’íí ła’ nadaal’a’áhíí yich’į’ gádaaṉii, Nṉee daanołiiníí, nohwik’ííyú, hago ádaahii’ṉe’? ");
INSERT INTO apwNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter gádaabiłṉii, Nohwinchǫ’íí bich’ą́’yúgo ádaałṉe’go dała’á daanołtįįgee Jesus Christ bizhi’ bee baptize ádaanohwi’dolṉe’, nohwinchǫ’íí nohwá da’izlį́į́ alṉe’híí bighą, áík’ehgo Holy Spirit bee nohwaa godit’aah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","40","Nohwíí díí bee nohwángot’ąą ła’íí nohwíí nohwich’ą́’gé’ daałidiłchiihíí, ła’íí doo daanohwik’íí dahíí ałdó’ bángot’ąą, dahadń Bik’ehgo’ihi’ṉań nohweBik’ehń ích’į’ yojííhíí. ");
INSERT INTO apwNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Hadíí bił daagozhǫ́ǫ́go biyati’ nádaidné’íí baptize ádaabi’deszaa: da’áí bijįį nṉee taadn doo náhóltag dayú shį Jesus daayodlaaníí yedikai. ");
INSERT INTO apwNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Áí nṉee nadaal’a’á bee bił ch’ídaago’aahíí, ła’íí łił daanlįįgo, báń nihi’né’íí, ła’íí okąąhíí dayúweh nłdzilgo yaa nakai. ");
INSERT INTO apwNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Dała’á daantį́į́go daidnłsįgo ńdaaldzid: ízisgo ánágot’įįłíí ła’íí godiyįhgo be’ígóziníí nadaal’a’á binkááyú bee ánágot’įįł. ");
INSERT INTO apwNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jesus daayodlaaníí dawa dałahágee naháztąą, dawahá dałaházhį’ daabíyéégo; ");
INSERT INTO apwNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Daabíyééhíí baa nadaahazṉiigo hadíí yídaadiníí yitaada’izṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Dajįį biigha dała’á daabiini’go da’ch’okąąh goz’ąą yuṉe’ dała’ánát’įįh, bił daagozhǫ́ǫ́go, doo íłch’į’ yaa daagochį’go da daabigowąyú łił náda’idįįh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bik’ehgo’ihi’ṉań yich’į’ ahédaanzįgo nṉee dawa bił dádaabik’ehgo ádaat’ee lę́’e. Áígé’ ła’ Bik’ehgo’ihi’ṉań binkááyú hayíí hasdákaihíí dajįį biigha ínáhikah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ha’iz’ąągé’ hayaazhį’yú Peter ła’íí John biłgo da’ch’okąąh goz’ąąyú dezh’aah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nṉee dágozlįįgé’ doo naghaa dahi dajįį biigha da’ch’okąąh goz’aaníí ch’íná’itį́híí Dénzhóné holzéhi bahgee nnádaach’iłtééh lę́’e, da’ch’okąąh goz’ąą yuṉe’ ha’áhikáhíí yídókeedgo; ");
INSERT INTO apwNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Peter ła’íí John biłgo da’ch’okąąh goz’ąą yuṉe’ hi’ashgo yiłtsąągo, Dahat’íhíta shaa nohné’, ṉiigo yídókeed. ");
INSERT INTO apwNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peter ła’íí John biłgo nṉee sitiiníí da’as’ah daayinéł’įįná’ Peter gáṉíí, Nohwíńł’įį. ");
INSERT INTO apwNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nṉee sitiiníí hat’íhíta shaa daayiné’ nzįgo yineł’į́įd. ");
INSERT INTO apwNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Áíná’ Peter gáṉíí, Shihíí béshłigaihíí ła’íí óodo doo ła’ nashné’ da; ndi hat’íí bigonshłįį’ihíí naa nshné’: Jesus Christ Názarethgé’ gólíni bizhi’ binkááyú nádnṉahgo dah nṉáh. ");
INSERT INTO apwNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bigan dihe’nazhiṉéé yiłtsoodgo hadag ábíílaa: dagoshch’į’ bikee ła’íí bikegod biłgo nłdzil daazlįį. ");
INSERT INTO apwNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Hadag yáhílwodgo hizį’, áígé’ dahnyaagé’ da’ch’okąąh goz’ąą yuṉe’ Bik’ehgo’ihi’ṉań yich’į’ ahénzįgo higaał ła’íí yáhilwo’go Peter ła’íí John biłgo yił okai. ");
INSERT INTO apwNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Higaałná’ Bik’ehgo’ihi’ṉań yich’į’ ahénzįgo nṉee dawa daabo’įį: ");
INSERT INTO apwNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Da’ch’okąąh goz’aaníí ch’íná’itį́h Dénzhóné holzéhi bahgee ídókeedgo sitįį n’íí át’į́į́go nṉee yídaagołsį: áík’ehgo hago’at’éégo bich’į’ ágodzaahíí daanzįgo bił díyadaagot’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nṉee doo nagháhi da n’íí Peter ła’íí John biłgo dayúweh yotą’ná’ nṉee łą́ą́go bich’į’ nádnkįįgo bił díyadaagot’eego baa dała’adzaa ch’ínágohin’ą́ą́gee, Sólomon’s holzéhi. ");
INSERT INTO apwNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peter nṉee dała’adzaahíí yiłtsąąná’ yich’į’ yałti’ gáṉíígo, Israel hat’i’i daanołíni, hat’íí bighą nohwił díyadaagot’ee? Hat’íí bighą dánohwíí nohwinawodíí bee dagohíí dánohwíí njǫǫhíí bee díí nṉeehíí naghaago ánáhiidlaa daanołsįgo da’os’ah daanohwineł’į́į́? ");
INSERT INTO apwNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Bik’ehgo’ihi’ṉań Abraham, Isaac, Jacob ła’íí bich’ą́’gé’ hadaałidelchįįhíí daayokąąhń, biYe’ Jesus ízisgo at’éégo áyíílaa; Pílate baa daadeso’ąągo ch’ínábííłteeh hat’į́į́, ndi nohwíí, Doo hádaahiit’įį da, daadołṉii, Pílate biṉááł. ");
INSERT INTO apwNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Dilzini, Nłt’éégo Ánát’įįłíí, Doo hádaahiit’įį da, daabiłdołṉiiná’, Nṉee yizes‐híni nohwá ch’ínánołteeh, daabiłdołṉii ni’; ");
INSERT INTO apwNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Áígé’ Ihi’ṉaa yeBik’ehń daazesołhįįná’, áń Bik’ehgo’ihi’ṉań daztsąągé’ nábihil’ṉa’; áí dawa nohwiṉááł ánágot’įįł ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Da’áń bizhi’ yodląągo díí nṉee daał’iiníí ła’íí bídaagonołsiníí nłdzilgo ánábiidlaa: bi’odlą’íí díí nṉeehíí doo hayú baa dahgoz’ąą dago ánábiidlaa, daanohwigha nohwiṉááł. ");
INSERT INTO apwNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Shik’ííyú, doo bídaagonołsįyú ádaałdzaa dago bígonsį, nohwá nadaant’aahíí ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Áíná’ díí k’ehgo Christ biniigodilṉé doleeł, ṉiihíí Bik’ehgo’ihi’ṉań binkááyú nada’iziidíí dabí’iłtséná’ yaa nadaagolṉi’ n’íí Bik’ehgo’ihi’ṉań ye’iilaa. ");
INSERT INTO apwNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Áík’ehgo nohwinchǫ’íí bich’ą́’yúgo ádaałṉe’, áígé’ Bik’ehgo’ihi’ṉań bich’į’ dahdołkáh, áík’ehgo nohwinchǫ’íí nohwá k’ená’ildéh, áík’ehgo Bik’ehgo’ihi’ṉań bich’ą́’gé’ nohwił gozhóóníí begoldoh ndi at’éé; ");
INSERT INTO apwNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Áígé’ Jesus Christ nohwich’į’ náidił’aa doleeł, áń ałk’iná’ baa nohwił na’gosṉi’ ni’: ");
INSERT INTO apwNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Áń ni’gosdzáń alzaagé’ yushdé’ godezt’i’go Bik’ehgo’ihi’ṉań binkááyú nada’iziidi daadilzini dabí’iłtséná’ yaa nagolṉi’ n’íí begolṉe’go dawahá iłch’į’nágodle’híí begonyaazhį’ yaaká’yú gólį́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses daanohwitaa n’íí da’aṉiigo gáyiłnṉiid, Nohwik’ííyú bitahgé’ Bik’ehgo’ihi’ṉań nohwe Bik’ehń binkááyú Na’iziidíí nohwá haiłteeh, shíí hashiltííníí k’ehgo; áń ádaanohwiłṉiihíí dawa nłt’éégo ídaayesółts’ąą doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Díí k’ehgo doleeł, dahadń áí Bik’ehgo’ihi’ṉań binkááyú Na’iziidíí doo íyésts’ąą dahń nṉee bitahgé’ da’ízlį́į́ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel golį́į́gé’ yushdé’ godezt’i’go Bik’ehgo’ihi’ṉań binkááyú nada’iziidíí dawa yádaałti’ n’íí díí bijįįyúgo ánágot’įįłíí dabí’iłtsé yaa nadaagolṉi’ ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nohwíí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí bich’ą́’gé’ hadaałiłshołchįį, ła’íí Bik’ehgo’ihi’ṉań Abraham bich’į’ hadzii, Nich’ą́’gé’ daałideshchiinihíí ła’ binkááyú ni’gosdzáń biká’ ił’angé’ łedaadiłchiinihíí dawa biyaa gozhǫ́ǫ́ doleeł, ṉiigo daanohwitaa n’íí yił łángodest’ąą n’íí nohwá begolṉe’. ");
INSERT INTO apwNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Bik’ehgo’ihi’ṉań biYe’, Jesus, hayiłtį́į́go da’iłtsé nohwich’į’ oyił’a’ ni’, dała’á nołtįįgo nchǫ’go ágot’eehíí bich’ą́’yúgo ádaanołt’eego nohwiyaa gozhǫ́ǫ́ doleełhíí bighą nohwich’į’ oyił’a’ ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peter ła’íí John biłgo nṉee t’ah yich’į’ yádaałti’ná’ okąąh yedaabik’ehi, silááda da’ch’okąąh goz’aaníí yiṉádaadéz’íni binant’a’ ła’íí Sádducees daanlíni baa hikai, ");
INSERT INTO apwNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Áí hadaashkee lę́’e, Peter ła’íí John biłgo nanezna’íí Jesus binkááyú naadiikáh doleeł, daaṉiigo, nṉee yił ch’ídaago’aahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nṉee hadaashkee n’íí Peter ła’íí John biłgo daayiłtsoodgo ha’ánezhteezh iskąązhį’: ałk’iná’ o’i’ą́ą́híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Da’ágát’éé ndi nṉee łą́ą́go Peter ła’íí John biłgo biyati’ daidezts’aaníí daayosdląąd; ashdladn doo náhóltag dayú shį da’osdląąd. ");
INSERT INTO apwNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Iskąą hik’e Jews binadaant’a’íí, Jews yánazíni ła’íí begoz’aaníí ye’ik’eda’iłchíhi Jerúsalemyú dała’adzaa, ");
INSERT INTO apwNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Okąąh yebik’ehi da’tiséyú sitíni, Ánnas holzéhi, Cáiaphas, John, Alexánder, ła’íí okąąh yebik’ehi da’tiséyú sitíni bik’íí dawa ałdó’ dała’adzaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Díí nṉeehíí Peter ła’íí John biłgo da’ałṉí’gee daayineskeego nayídaadiłkid, Hat’íí binawod, hadń bizhi’ bee díí ádaałdzaa? ");
INSERT INTO apwNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Peter, Holy Spirit bił nlįįgo yábiyiłti’go gádaabiłṉii, Nṉee bánadaanołt’aahíí ła’íí Israel hat’i’íí bánasoziiníí, ");
INSERT INTO apwNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nṉee doo nagháhihíí bich’osii’ṉi’íí, díí nṉee hago at’éégo nábi’dilziihíí bighą díí jįį nanohwídaadołkidyúgo: ");
INSERT INTO apwNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nohwíí ła’íí Israel hat’i’íí dawa bídaagonołsį le’, Jesus Christ, Názarethgé’ gólíni, tsį’iłna’áhi bídaahesołkał n’íí, daztsąągé’ Bik’ehgo’ihi’ṉań nábihil’ṉa’ n’íí, áń bee díí nṉee nłt’éé nasdlįįgo nohwidáhyú sizįį. ");
INSERT INTO apwNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Díí tséhíí kįh ádaagołe’íí daanołíni yó’odaasołṉe’ n’íí iłhagon’aagee da’iłtsé si’aaníí silįį. ");
INSERT INTO apwNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Áń ba’ashhahyú doo hadń hasdákołteehíí gólį́į́ da, díí yáá das’aaníí bitł’ááhyú hizhííhíí bee hasdáhikáh doleełíí dała’á ndi doo ni’ biká’ nṉee baa nádet’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Peter ła’íí John biłgo nṉee doo da’ołtag dahi, débaagoch’oba’íí daanlįį ndi doo bił daagoyéé dago yádaałti’, nṉee nadaant’aahíí yídaagołsįįdgo bił díyadaagot’ee; áík’ehgo Jesis yił nakai n’íí yínádaagołsįįd. ");
INSERT INTO apwNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nṉee nábi’dilziihíí bit’ahgé’ sizįįgo daayo’įįhíí bighą doo hat’íí nádaado’ṉiid da. ");
INSERT INTO apwNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Áíná’ Peter ła’íí John biłgo ch’ínoł’aash daayiłnṉiidná’, dasahn iłch’į’ yádaałti’, ");
INSERT INTO apwNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Díí nṉeehíí hago ádaahiidle’? Godiyįhgo ágodzaahíí binkááyú ágodzaago Jerúsalemyú daagolííníí dawa yídaagołsį; nohwíí doo daahohiidląą da daan’ṉiihíí doo bik’eh da, daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nṉee bitahyú doo dayúwehyú dididlaadgo da, haląą gádaabiłdo’ṉiih, Áń bizhi’íí bee hadń bich’į’ yánáhólti’ hela’. ");
INSERT INTO apwNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Áík’ehgo yushdé’ daayiłṉiigo, Jesus bizhi’ bee yánáhólti’ hela’ dagohíí iłch’ínánágonoł’aah hela’, daabiłṉiigo bándaagoz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Áíná’ Peter ła’íí John biłgo gádaabiłṉii, Bik’ehgo’ihi’ṉań binadzahgee nohwíí nohwich’į’ ídílts’ąągo née, dagohíí Bik’ehgo’ihi’ṉańgo née, hayíí dábik’ehíí bendaagonoł’aah. ");
INSERT INTO apwNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nohwíí hayíí hiit’iiníí ła’íí dihiits’agíí baa nagohiilṉi’hi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nṉee nadaant’aahíí, Jesus baa yánáhólti’ hela’, nádaabiłdo’ṉiidná’ nádołt’aash daabiłnṉiid; nṉee dawa ágodzaahíí bighą Bik’ehgo’ihi’ṉań ba’ahédaanzįgo doo hago at’éégo ádaile’ da. ");
INSERT INTO apwNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nṉee nábi’dilziihíí dizdinhíí bitisyú bił łegodzaahi. ");
INSERT INTO apwNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Peter ła’íí John biłgo ch’ínát’áázhná’ yił nakai n’íí yich’į’ onát’aazhgo okąąh yedaabik’ehi yánadaant’aahíí ła’íí Jews yánazíni ádaabiłṉii n’íí yaa nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Áí daidezts’ąąná’ Bik’ehgo’ihi’ṉań bich’į’ da’okąąhgo gádaaṉii, NohweBik’ehń, yáá, ni’gosdzáń, túnteel ła’íí daabiyi’ daagolííníí dawa Bik’ehgo’ihi’ṉań ńlį́į́go áńlaa; ");
INSERT INTO apwNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","David, nánal’a’á, binkááyú yánłti’go gáńṉii ni’, Hat’íí bighą doo Jews daanlįį dahíí hadaashkee, ła’íí nṉee dawahá doo begolṉe’ dahíí yaa natsídaakees? ");
INSERT INTO apwNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ni’gosdzáń biká’ ízisgo nant’án daanliiníí iłk’izhį’ ádaadzaa, ła’íí nṉee yánadaant’aahíí dała’adzaa, Bik’ehgo’ihi’ṉań ła’íí Its’áínłtíni, Christ holzéhi, biłgo yich’į’ náda’nziidgo. ");
INSERT INTO apwNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Da’aṉiigo, niYe’ Dilzini, Jesus, Its’ánłtíni, yich’į’ náda’nziidgo Hérod ła’íí Póntius Pílate, doo Jews daanlįį dahíí, ła’íí Israel hat’i’íí biłgo dała’adzaa, ");
INSERT INTO apwNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nigan binawodíí ła’íí niini’ be’ágodoṉiiłíí dabí’iłtsé bengóń’ąą n’íí yee ádaaṉe’go dała’adzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","K’adíí nohweBik’ehń, nowhenadaago’aahíí hóyíńłts’ąą, áík’ehgo nánada’idziidíí niyati’ doo daasiite’go bee yádaahiilti’ dago bidag ádaant’eego ádaanohwinłsį, ");
INSERT INTO apwNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dahdnlṉíhgo na’ílziih; ła’íí niYe’ Dilzini, Jesus, bizhi’íí binkááyú godiyįhgo be’ídaagoziníí ła’íí ízisgo ánágot’įįłíí ánánł’įįł le’, da’okąąhgo daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ąął da’oskąądná’ dała’adzaagee godihes’naa; áígé’ Holy Spirit bee baa daagodest’ąągo Bik’ehgo’ihi’ṉań biyati’ doo daaste’go yee yádaałti’ da lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nṉee łą́ą́go da’osdląądíí biini’ dała’á, bijíí dała’á nasdlįį: daabíyééhíí doo dasahn shíyéé daanzį da; ndi dawahá dałaházhį’ daabíyéé lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nadaal’a’á dayúweh beBik’ehń Jesus daztsąągé’ naadiidzaahíí dázhǫ́ nłt’éégo yaa nadaagolṉi’, Bik’ehgo’ihi’ṉań biłgoch’oba’íí zhą́ bitisgo biká’zhį’ at’éé daazlįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tédaat’iyéhíí bitahyú doo ła’ da silįį: hayíí bini’ dagohíí bikįh daagolííníí baa nadaagohezṉiigo, bich’ą́’gé’ daayist’įįdíí ");
INSERT INTO apwNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Nadaal’a’á bádngee ndaayihezṉil: áígé’ hayíí tédaat’iyéhíí hat’íí yídaadiníí daantį́į́gee yitah da’izṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Joses, nadaal’a’á Bárnabas bizhi’ bá ádaizlaahi, (Kodag yałti’íí ye’at’éhi golzeego ágolzee,) Cýprusgé’ Levi hat’i’íí nlíni, ");
INSERT INTO apwNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ni’ bíyééhíí baa nagohezṉiigo zhaali baa hi’né’íí nadaal’a’á bádngee nyiné’. ");
INSERT INTO apwNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Áíná’ nṉee ła’, Ananías holzéhi, bi’aad, Sapphíra holzéhi, biłgo ni’ baa nadaagohezṉii, ");
INSERT INTO apwNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Bi’aad yígółsįgo zhaali baa hi’né’íí ła’ t’ąązhį’ yotą’ná’ ła’ zhą́ nadaal’a’á bádngee nyiné’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Áík’ehgo Peter gáṉíí, Ananías, hat’íí bighą ch’iidn nant’án, Satan holzéhi, naniłaago Holy Spirit bich’į’ nashíńch’a’, ni’ bich’ą́’gé’ zhaali naa hi’né’íí łahzhį’ t’ąązhį’ hóńtą’go nńné’? ");
INSERT INTO apwNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Doo hwahá nahiṉiih daná’ ṉíyéé ni’ ya’? Nahezṉiihíí bikédé’go zhaali naa hi’né’íí dáni benik’eh ni’ ya’? Hago at’éégo tsídíńkeezgo díí bee ándzaa? Doo nṉee bich’į’ nashíńch’a’ da, Bik’ehgo’ihi’ṉań bich’į’ nashíńch’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Díí yati’íí Ananías yidezts’ąąná’ nágo’go daztsąą: nṉee dawa yaat’ídaanzįhíí tsídaadesyiz. ");
INSERT INTO apwNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nṉee áníi nakaiyéhíí nádikaigo ch’id bił daizdis, áígé’ ch’adaabizyįįyú łehdaabistįį. ");
INSERT INTO apwNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Áígé’ taadn łedihikeezyú shį nṉee daztsaaníí bi’aad ágodzaahíí doo yígółsį dago ha’ayáá. ");
INSERT INTO apwNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter gáyiłṉii, Shił nagolṉí’, gáhołąągo izlįįgo ni’ nohwaa nagohezṉii née? Áígé’ gáṉíí, Ha’aa, akohgo izlįį. ");
INSERT INTO apwNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peter gánábiłdo’ṉiid, Hat’íí bighą Bik’ehgo’ihi’ṉań biSpirit nabínołtaahgo bich’į’ godeso’ąą? Isąą, niką’ łehdaistiiníí ch’ígót’i’yú nadaazį, áí ni ałdó’ ch’ídaaniłteeh. ");
INSERT INTO apwNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Áík’ehgo dagoshch’į’ Peter bádnyú nágo’go daztsąą: nṉee áníi nakaiyéhíí ha’ákaigo isdzán daztsąągo yídaagołsįįd, áígé’ ch’adaabizyįįyú biką’ łe’sitįį n’íí bahgee łehdaistįį. ");
INSERT INTO apwNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nṉee da’osdląądíí dała’ánát’įįłíí tsídaadesyiz lę́’e, ła’íí hayíí yaat’ídaanzįhíí ałdó’ tsídaadezyiz. ");
INSERT INTO apwNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nṉee bitahyú godiyįhgo be’ídaagoziníí łą́ą́go, ła’íí ízisgo ánádaagot’įįłíí nadaal’a’á binkááyú ánágot’įįł; (Sólomon bich’ínágohin’ą́ą́gee dała’á daabiini’go dała’ánát’įįh. ");
INSERT INTO apwNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jesus doo daayodląą dahíí ńdaaldzidgo doo yéhikai da ndi nṉee nłt’éégo baa natsídaakees. ");
INSERT INTO apwNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nṉee dayúweh łą́ą́go ła’íí isdzáné biłgo Jesus daayodlaaníí yénáhikai;) ");
INSERT INTO apwNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Áík’ehgo daanezgaihíí da’intinyú ch’ínádai’ṉiłgo biká’da’astíné ła’íí ch’id biká’ nazhjeed, Peter higaałgo bichagosh’oh zhą́ ndi biká’zhį’ áoṉe’ daanzįgo. ");
INSERT INTO apwNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerúsalem biṉaayú kįh nagozṉilgé’ ałdó’ nṉee łą́ą́go daanezgaihíí ła’íí nṉee spirits daanchǫ’íí biyi’ daagolííníí yił nihikáh, áí dawa nádaadziih lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Okąąh yebik’ehi da’tiséyú sitíni yił nakaihíí dábiłgo (Sádducees daanlíni,) dázhǫ́ hadaashkeego, ");
INSERT INTO apwNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nadaal’a’á daayiłtsoodgo ha’áná’ilka’á yuṉe’ ha’ádaiskaad lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tł’é’yú Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi ha’áná’ilka’ágee ch’íná’itį́híí yá ch’íńtą́ą́go ákú yił ch’íkai, áígé’ gábiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ti’i, da’ch’okąąh goz’ąąyú dołkáh, áígee nasozįįgo díí nłt’éégo ihi’ṉaahíí baa yati’íí dawa nṉee baa bił nadaagołṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Díí daidezts’ąąná’ hayiłkaałyú da’ch’okąąh goz’ąą yuṉe’ ha’ákaigo bił ch’ídaago’aah. Okąąh yebik’ehi da’tiséyú sitíni yił nakaihíí biłgo hikaigo nṉee yánádaaltihíí ła’íí Israel hat’i’i yánaziiníí dała’áyíílaaná’ ha’áná’ilka’áyú nadaal’a’á yíká o’ił’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Áíná’ aasitíni ha’áná’ilka’áyú okai, n’íí nadaal’a’á n’íí doo hwaa da lę́’e, áígé’ nákaigo nadaagosṉi’, ");
INSERT INTO apwNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Gádaaṉiigo, Ha’áná’ilka’áyú nłt’éégo o’ogęęzná’ aasitíni dáádítį́hgee t’ah nazįįná’ baa nkai ndi ch’ídaasiitąą hik’e doo hadń ákóṉe’ naháztąą da ląą. ");
INSERT INTO apwNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Okąąh yebik’ehi da’tiséyú sitíni ła’íí silááda da’ch’okąąh goz’aaníí yiṉádaadéz’íni binant’a’ ła’íí okąąh yedaabik’ehi itisyú nadaandeehi díí daidezts’ąąná’ hagoshą’ at’éégo ląą dayúweh bá daagowáh daanzį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ła’ nyáágo gádaabiłṉii, Nṉee ha’ádaasołkaad n’íí da’ch’okąąh goz’ąą yuṉe’ nazįį, nṉee yił ch’ídaago’aahgo. ");
INSERT INTO apwNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Áík’ehgo silááda da’ch’okąąh goz’aaníí yiṉádaadéz’íni ła’íí binant’a’ nadaal’a’á yíká okaigé’ dánt’éhego yił nakai: nṉee tséé bee daanohwiłṉé’ doleełhi at’éé daanzįgo ńdaaldzidhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Yił nakainá’ nṉee yánádaaltihíí naháztąągee yił hikai baa yá’iti’híí bighą: áígee okąąh yebik’ehi dá’tiséyú sitíni nabídaadiłkid, ");
INSERT INTO apwNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Gáṉíígo, Díí yízhííhíí bee iłch’ínágonoł’aah hela’, daanohwiłn’ṉiigo nohwá ndaagosiit’ąą ni’, n’íí kú lá Jerúsalem dágoz’ąą nt’éégo bił ch’ínánágonołt’aah, ła’íí áí nṉee zesdiiníí nohwíí nohwik’izhį’ daadoł’áhgo ádaałt’įį. ");
INSERT INTO apwNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter ła’íí nadaal’a’á ła’ihíí biłgo hadaasdziigo gádaaṉii, Nohwíí Bik’ehgo’ihi’ṉań da’áṉííyú ádaant’eego dábik’eh, doo nṉee da. ");
INSERT INTO apwNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jesus tsį’iłna’áhi bídaahesołkałgo daazesołhįį n’íí daanohwitaa n’íí Bik’ehgo’ihi’ṉań daayokąąhń daztsąągé’ nábihil’ṉa’. ");
INSERT INTO apwNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Áń Nant’án ła’íí Hasdá’iiṉíłi nlįįgo Bik’ehgo’ihi’ṉań ábíílaago bigan dihe’nazhiṉéégo dahbinesdaa ni’, Israel hat’i’i binchǫ’i bich’ą́’zhį’go ádaile’go binchǫ’íí bich’ą́’gé’ baa nádaagodet’ąąhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Díí ánágot’įįłíí daahiit’į́į́go baa nadaagohiilṉi’; Holy Spirit ałdó’ yaa nagolṉi’, áí Holy Spirit‐híí hayíí Bik’ehgo’ihi’ṉań biyati’ yikísk’eh ádaat’eehíí yaa daidez’ąą ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Yánádaaltihíí áí daidezts’ąąná’ bił daagoshch’iigo, nadaiłtseed hádaat’įįgo yendaagoshchįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Áíná’ Phárisee ła’ nṉee yánádaaltihíí itah nlíni, Gamáliel holzéhi, begoz’aaníí iłch’ígó’aahi, nṉee dawa nłt’éégo baa natsekeesi hizį’go, Díí nṉeehíí dét’įhézhį’ nláhyú ch’ínókáh, nṉiid; ");
INSERT INTO apwNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Áíná’ gáṉíí, Israel hat’i’íí daanołíni, díí nṉee hago ádaałe’íí baa daagonołsąą. ");
INSERT INTO apwNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Doo áníiná’ nṉee ła’ Theúdas holzéhi ízisgo at’éhi ídeshchįįgo nṉee łą́ą́go dį́į́go nanadínyú shį béhikai ni’: áń zesdįįgo bikísk’eh ádaat’ee n’íí dawa iłtanáhosąągo begoldoh n’íí doo hat’íí da silįį ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Áí bikédé’go Judas, Gálileegé’ gólíni, nṉee tax nahi’ṉiił doleełhíí bighą daaholtag ni’ná’ nyáá, áń ałdó’ nṉee łą́ą́go íts’áíńṉil: áń ałdó’ daztsąą, áígé’ bikísk’eh ádaat’ee n’íí dawa iłtanáhosąą ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","K’adíí gánohwiłdishṉii, Díí nṉeehíí doo baa nałkai da, doo nadaanołtł’og da: díí begoldohíí nṉee bich’ą́’gé’ bee ánágot’įįł lę́’eyúgo, doo hat’íí da hileeh: ");
INSERT INTO apwNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Áíná’ Bik’ehgo’ihi’ṉań bich’ą́’gé’ lę́’eyúgo doo bengowáh ádaałe’ at’éé da; nohwíí dánko Bik’ehgo’ihi’ṉań bich’į’ nadaagonołkaadgo nohwígózį. ");
INSERT INTO apwNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nṉee yánádaaltihíí Gamáliel aṉííhíí bił dádaabik’ehgo nadaal’a’á yushdé’ daayiłṉiigo ánákai, áígé’ Jesus bizhi’íí bee yánánáłti’ hela’, daabiłṉiiná’ ńdaabinestsaz, áígé’ onádaabis’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Áík’ehgo yánádaaltihíí yich’ą́’ dahnaskai, Jesus bizhi’híí bighą ádaayágosįhyú ádaats’izlaa lę́’e ndi Bik’ehgo’ihi’ṉań binadzahgee nłt’éégo ádaat’eego yídaagołsįhíí bighą bił daagozhǫ́ǫ́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Dajįį biigha da’ch’okąąh goz’ąą yuṉe’ ła’íí daagowąyú Jesus Christ yaa nadaagolṉi’go yaa iłch’ídaago’aah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Áíná’ Jesus daayokąąhíí łą́ą́go silįįná’ Jews daanlíni Greek biyati’ yee yádaałti’íí doo bił daagozhǫ́ǫ́go Hebrews daanlíni gádaayiłnṉiid, Dajįį biigha ch’iyáń na’ṉiihgee nohwíí nohwitahyú isdzáné biką’ nanezna’ihíí doo yich’į’ zhiṉéé ádaat’ee da lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Áík’ehgo nakits’ádahíí nṉee Jesus daayokąąhíí dawa yushdé’ daayiłnṉiid, áígé’ gádaayiłṉii, Ch’iyáń nadaahii’ṉiihíí bighą Bik’ehgo’ihi’ṉań biyati’ baa nadaagolṉi’íí doo k’ihzhį’ ndaagont’aa bik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Áík’ehgo, nohwik’ííyú, nṉee gosts’idi, nłt’éégo baa yádaałti’íí, Holy Spirit ye’ádaat’eehíí, daagoyááníí nohwitahgé’ hadaałṉiił, áí nṉee díí na’idziidíí yedaabik’ehgo ádaahiidle’. ");
INSERT INTO apwNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Áíná’ nohwíí dágodest’i’yú da’ohiikąąh ła’íí Bik’ehgo’ihi’ṉań biyati’ baa yádaahiilti’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ádaaṉiihíí nṉee dawa bił dádaabik’eh: áík’ehgo Stephen dázhǫ́ nłdzilgo odláni, Holy Spirit ye’at’éhi, Philip, Prókorus, Nicánor, Tímon, Pármenas, ła’íí Nícolas, Jews bi’okąąhíí yenyáhi, Ántiochgé’ gólíni, hadaihezṉil. ");
INSERT INTO apwNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Áí hadaisṉilíí nadaal’a’á yidáhzhį’ yił nnikaigee yiká’ ndaadesṉiigo yá da’oskąąd. ");
INSERT INTO apwNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bik’ehgo’ihi’ṉań biyati’ dayúweh begodeyaago Jerúsalemgee Jesus daayokąąhíí łą́ą́go bínáhiikai; okąąh yedaabik’ehi ałdó’ łą́ą́go odlaaníí yikísk’eh ádaat’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen, dázhǫ́ nłdzilgo odláni, Holy Spirit bee binawod golíni, ízisgo ánágot’įįłíí ła’íí godiyįhgo be’ídaagoziníí nṉee bitahyú ye’áná’ol’įįł. ");
INSERT INTO apwNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nṉee ła’, Líbertines daaholzéhi, ła’íí Cyrénegé’ ła’íí Alexándriagé’ daagolíni, ła’íí nṉee Cilíciagé’ ła’íí Asiagé’ nakaihi ha’ánáłséhíí bitahgé’ Stephen yił ładaadit’ah nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Áíná’ Stephen goyą́ą́go ła’íí Holy Spirit yábiyiłti’go nṉeehíí doo ła’ bitisgo hadziih da lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Áík’ehgo nṉee ła’ yich’į’ na’daahezṉilgo gáyiłṉii, Nadaałch’aago Stephen baa yádaałti’, áík’ehgo gádaaṉii, Moses ła’į́į́ Bik’ehgo’ihi’ṉań nchǫ’go yaa yałti’go daadihiits’ag. ");
INSERT INTO apwNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Áígé’ nṉee Stephen yik’edaanṉiihíí, Jews yánazíni, ła’íí begoz’aaníí ye’ik’eda’iłchíhi, ła’íí nṉee dawa hadaashkee ádaizlaago Stephen yaa hikaigo daayiłtsood, áígé’ nṉee yánádaaltihíí yił yaa hikai. ");
INSERT INTO apwNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nṉee nadaach’áhi yił hikai, áík’ehgo gádaaṉii, Díí nṉeehń díí godiyįhgo goz’aaníí ła’íí begoz’aaníí dawahn nchǫ’go yaa yałti’; ");
INSERT INTO apwNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Gáṉiigo daadihiits’ag, Jesus Názarethgé’ gólíni díí godilzįhgo goz’aaníí nagohilkaad, ła’íí Moses nohwá yengon’ą́ą́ n’íí łahgo ánáyidle’. ");
INSERT INTO apwNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nṉee yánádaaltihíí dawa Stephen da’is’ah daineł’į́į́go binii Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi biniihíí k’ehgo at’éégo daayiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Okąąh yebik’ehi da’tiséyú sitíni gábiłṉii, Ádaaniłch’iṉiihíí da’aṉii née? ");
INSERT INTO apwNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen gáṉíí, Nṉee daanołíni, shik’ííyú, nṉee báyáń daanołíni, shídaayesółts’ąą; nohwitaa n’íí Abraham, doo hwahá Chárranyú ngoleeh daná’ Mesopotámiayú gólį́į́ ni’ná’ Bik’ehgo’ihi’ṉań bich’ą́’idindláád nlíni bich’į’ ch’í’ṉah ádelzaa, ");
INSERT INTO apwNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Áígee gábiłnṉiid, Nini’ ła’íí nik’íí bich’ą́’ dahnṉáhgo ni’ nił ch’í’ṉah áshłe’yú ńṉááł. ");
INSERT INTO apwNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Áík’ehgo Abraham Kaldéans bini’gé’ dahnyaago Charran golzeegee golį́į́ lę́’e: bitaa daztsąąná’ díí ni’ biyi’ daagonołįįzhį’ Bik’ehgo’ihi’ṉań bik’ehgo onágódle’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Áíná’ ni’ bíyééhíí doo ła’ baa gon’ą́ą́ da, doo ndi dałahndi nch’idel’eezgo da: áíná’ bichągháshé doo ła’ da ndi bíí ła’íí bich’ą́’gé’ daałideshchiinihíí daabíyéé doleełgo yángon’ą́ą́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Bik’ehgo’ihi’ṉań Abraham bich’į’ hananádziigo gánṉiid, Nich’ą́’gé’ daałideshchiiníí ni’ doo yídaagołsį da n’íí yiyi’ daagolį́į́ doleeł; áígee nṉee ni’ daabíyééhíí isná ádaabidle’go dį́į́dn gonenadín łegodzaazhį’ biniidaagonłt’éé doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nṉee isná ádaabisdlaahíí biniidaagodishłe’ doleeł; áí bikédé’go áígé’ ch’ékáhgo dząągee daashokąąh doleeł, ṉii lę́’e, Bik’ehgo’ihi’ṉań. ");
INSERT INTO apwNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Áígé’ Bik’ehgo’ihi’ṉań circumcísion bee Abraham yił łángot’ąą: áík’ehgo Abraham biye’ Isaac gozlįįgo tsebíí behiskaaníí bijįį círcumcise áyíílaa; áígé’ Isaac biye’ Jacob gozlįį; Jacobhíí biye’ke nakits’ádah daagozlįį, áí bich’ą́’gé’ nakits’ádahyú nṉee hat’i’ silįį. ");
INSERT INTO apwNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jacob biye’kehíí daabidizhé Joseph daayołch’įį’go, yik’edaanṉiihgo Egyptyú baa nadaahezṉii: áíná’ Bik’ehgo’ihi’ṉań bił nlįįgo, ");
INSERT INTO apwNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Bich’į’ nadaagontł’ogíí bighą dawa yich’ą́’ binłtį́į́, áígé’ Pháraoh, Egypt yánant’aahíí, yił nzhǫǫgo ła’íí binadzahgee goyą́ą́go Bik’ehgo’ihi’ṉań ábíłsį; Pháraohíí Egypt dahot’éhé ła’íí bikįh biyi’ daagolííníí yánant’aago ábíílaa. ");
INSERT INTO apwNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Egypt ła’íí Cánaanyú dahot’éhé shiṉá’ góyéégo daagodeyaa: áígee daanohwitaa n’íí bich’iyą’ n’íí bich’ą́’ ádaasdįįdgo biniidaagonłt’éé lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egyptyú nadą́’ gólį́į́ łą́ą́go Jacob yaat’ínzįįná’ daanohwitaa n’íí da’iłtsé ákú odais’a’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Iké’gee nanákainá’ Joseph, Daanohwik’isn nshłįį n’íí shíí ánsht’ee, daayiłṉiigo bídaagołsįįd; ła’íí Joseph bik’íí Pháraoh yígółsįįd. ");
INSERT INTO apwNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Áígé’ Joseph bitaa ła’íí bik’íí dawa biłgo gosts’idin ashdla’ hilt’eego yiká’o’ił’a’, ");
INSERT INTO apwNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Áík’ehgo Jacob Egyptyú o’íṉil, ákú Jacob daztsąą, ła’íí daanohwitaa n’íí ałdó’ da’iłké’go nanezna’, ");
INSERT INTO apwNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Áí dawa Sýkemyú onádaihezṉilgo iłch’į’ndaahi’ṉiił goz’ąą yuṉe’ da’iłké’go łedaahasṉil, áí goz’aaníí Abraham Sýkem biye’ Émmor biye’ke bich’ą́’gé’ zhaali bee nagohesṉii ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Bik’ehgo’ihi’ṉań Abraham bángon’ą́ą́ n’íí begolṉe’íí ałhánégé’ goldohná’ Abraham bich’ą́’gé’ daałideshchiinihíí Egyptgee łą́ą́ silįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Áíná’ Egyptyú ła’ nant’án nanásdlį́į́, áń Joseph doo yígółsį da lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Áń nohwíí hahiit’i’íí yik’edaanṉiih lę́’e, ła’íí daanohwitaa n’íí gádaayiłṉiigo bándaagoz’ąą, Mé’ daagozlįįhíí da’izlįįyú ch’ídaahołkaadgo da’akú nanṉe’ le’. ");
INSERT INTO apwNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Áígee Moses gozlįįgo dázhǫ́ dénzhóné lę́’e, áń bitaa golį́į́ yuṉe’ nadaach’iłteego taagi daahitąą: ");
INSERT INTO apwNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Áígé’ da’izlįįyú ch’ídaach’istįįyú Pháraoh bitsi’ nábinłtįįgo dabíí bizhaazhé k’ehgo yíhiłṉa’. ");
INSERT INTO apwNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Egyptyú daagolííníí bigoyą’íí dawa Moses bił ch’et’ą́ą́go dázhǫ́ nłt’éégo yałti’ ła’íí nłt’éégo ánát’įįł silįį. ");
INSERT INTO apwNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moses dizdin bił łegodzaaná’, shik’ííyú Israel hat’i’íí bich’į’ dosháh nzį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Áík’ehgo ła’ inaghanaghaago yiłtsąągo, áń yik’izhį’ onálwodgo yił nałts’įhgo daztsąą: ");
INSERT INTO apwNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Shíí hat’i’íí biniidaagonłt’ééhíí biyi’gé’ Bik’ehgo’ihi’ṉań shich’oṉiigo bił ch’ídishkaahíí yídaagołsį shį nzį lę́’e; ndi doo bídaagołsį da. ");
INSERT INTO apwNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Iskąą hik’e dabíí hat’i’i naki iłch’į’ dahnádilwo’go yiká ńyáá, nkenágoheltǫǫd nzįgo gádaayiłṉii, Iłk’isyú nołdlįįná’ hat’íí bighą iłṉí’dołṉíh? ");
INSERT INTO apwNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Áíná’ ba’ashhahgé’ gólíni doo bik’ehyú ánáyo’įįł dahń Moses k’ihzhį’ yenyilná’ gáṉíí, Hadń nohwinant’a’ ła’íí nohwaa yałti’i áníílaago áńt’įį? ");
INSERT INTO apwNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Adąąná’ nṉee Egýptian nlíni zíníłhįįhíí k’ehgo shíí ałdó’ shiziniłhéé née? ");
INSERT INTO apwNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Díí áṉííhíí bighą Moses dabíí hat’i’i yich’ą́’ halwodgo Mádiangee golį́į́ ngohéyáá, áígee biye’ke naki gozlįį. ");
INSERT INTO apwNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Áígé’ dizdin łegodzaa bikédé’go Dził Sína holzéhi biṉaayú da’izlįįyú ch’il diltłi’i biyi’gé’ Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi bich’į’ ch’í’ṉah ádelzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses yo’įįná’ bił díyagot’ee lę́’e: iłhánégo yineł’į́į́go nyáá hik’e Bik’ehgo’ihi’ṉań bich’į’ hadzii, ");
INSERT INTO apwNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Gáṉíígo, Shíí daanitaa n’íí Bik’ehgo’ihi’ṉań daayokąąhń nshłįį, Abraham, Isaac ła’íí Jacob Bik’ehgo’ihi’ṉań daayokąąhń nshłįį. Moses tsídolyizgo ditłidgo doo ázhį’ nádést’įįd da. ");
INSERT INTO apwNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bik’ehgo’ihi’ṉań gábiłṉii, Nikee ádaandlee: ni’ biká’ síńziiníí ni’ godiyini at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egyptyú shichągháshé biniidaagonłt’éégo hish’įį, áí hish’įįgo ik’ídaadi’ṉiihíí dists’ag, áík’ehgo áí bich’ą́’ nshṉiiłyú níyáá. Ti’i, dák’ad Egyptyú nideł’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Dadíí Moses Israel hat’i’i doo hádaabit’įįgo gádaaṉii n’íí, Hadń nohwinant’a’ ła’íí nohwaa yałti’íí áníílaa? Da’áí Moses n’íí Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi ch’il biyi’gé’ bich’į’ ch’í’ṉah ádelzaa n’íí binkááyú Bik’ehgo’ihi’ṉań bides’a’, nant’án nlįįgo ła’íí Israel hat’i’íí biniidaagonłt’ééhíí yich’ą́’ yííṉííłgo bides’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Áí Moses n’íí ízisgo ánágot’įįłíí ła’íí godiyįhgo be’ídaagoziníí Egyptyú ła’íí Red Seayú ánát’įįł ni’ná’ Egyptgé’ ch’íiṉilgo da’izlįįyú nanałse’go dizdin łegodzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Da’áí Moses‐híí Israel hat’i’íí gádaayiłṉii ni’, Bik’ehgo’ihi’ṉań binkááyú Na’iziidi hileehgo nohwik’ííyú bitahgé’ Bik’ehgo’ihi’ṉań nohweBik’ehń nohwá habiłteeh, shíí hashiłtį́į́híí k’ehgo; áń hódaayesółts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Da’izlįįyú ha’ánáłséh n’ná’, díí Moses‐híí Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi Dził Sína holzeeyú bich’į’ yałti’ n’íí ła’íí daanohwitaa n’íí bigizhgee yałti’íí nlįįgo yati’ hiṉáhi nohwá baa hi’né’ ni’: ");
INSERT INTO apwNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Áń daanohwitaa n’íí doo bídaayésts’ąą hádaat’įį da ni’, doo hádaabit’įį da, áíná’ Egyptyúgo nádiikáhíí zhą́ bijíígé’ hádaat’įį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aaron gádaayiłṉii, Hat’íhíta daahohiikąąhíí nohwá ánle’, áí nohwá go’įį doleeł: díí Moses Egyptgé’ ch’ínohwiṉil n’íí hago adzaa shįhíí doo bídaagonlzį da. ");
INSERT INTO apwNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Áíná’ magashi bizhaazhé be’ilzaa’i ndi ádaizlaago dahat’íhíta yiyaa odaayihiṉiiłgo daayokąąh, dabíí ádaizlaahíí yaa bił daagozhǫ́ǫ́go. ");
INSERT INTO apwNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Áík’ehgo yáá biyi’gé’ dawaháhíí daayokąąhgo Bik’ehgo’ihi’ṉań dabiini’zhį’ ch’ídaabizṉil; Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí binaltsoos biyi’ k’e’eshchįįhíí k’ehgo, Israel hat’i’i daanołíni, da’izlįįyú dizdin nohwee łedaagosdzaa n’ná’ magashi bizhaazhé, dibełį́į́ bizhaazhéta nadaałtseedíí ła’íí dahat’íhíta shaa daahołṉiił lá née? ");
INSERT INTO apwNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Gowągolgai biyi’ Mólok holzéhi daayokąąhíí nadaałṉil, ła’íí daahołkąąhíí Rémphan holzéhi bits’iłsǫǫsé k’ehgo be’ilzaahíí ałdó’ nadaałṉil, díí be’ilzaago ádaasolaahíí daahołkąąhgo: áík’ehgo Bábylon bitisyú ch’ínołkáhgo ánohwishłe’. ");
INSERT INTO apwNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Daanohwitaa n’íí gowągolgai biyi’ da’okąąhi Bik’ehgo’ihi’ṉań yił daanlįįgo bebígózini da’izlįįyú goz’ąą, áí hago’at’éégo alṉéhíí Bik’ehgo’ihi’ṉań Moses yił ch’í’ṉah áyíílaahíí k’ehgo alzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Daanohwitaa n’íí Jesus bá nant’aago Bik’ehgo’ihi’ṉań doo Jews daanlįį dahíí bá ch’íineheyoodná’ gowągolgai biyi’ da’okąąhíí ni’ daabíyéé gozlįįyú daistsoozgo hikai, áí doo Jews daanlįį dahíí David dánant’aa silįįzhį’ Bik’ehgo’ihi’ṉań daanohwitaa n’íí dábidáhgee ch’ídaaniheyood; ");
INSERT INTO apwNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David Bik’ehgo’ihi’ṉań yił nzhǫǫ silįį, áík’ehgo Jacob Bik’ehgo’ihi’ṉań yokąąhń yiyi’ golį́į́ doleełíí bá ágóshłe’ nzį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ndi Sólomon holzéhigo Bik’ehgo’ihi’ṉań kįh yiyi’ golííníí bá ágólaa. ");
INSERT INTO apwNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Áíná’ Da’tiséyú At’éhi kįh dá nṉee bigan yee ádaizlaahi doo yiyi’ golį́į́ da; Bik’ehgo’ihi’ṉań binkááyú na’iziidíí gáṉíí n’íí k’ehgo, ");
INSERT INTO apwNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yaaká’yú goz’aaníí biká’dah’asdáhá biká’gé’ nansht’aahíí át’éé, ni’gosdzáńhíí biká’ dahnádes’isíí át’éé: kįh hago’at’éhi shá ágóle’? ṉíí lę́’e Bik’ehgo’ihi’ṉań: hayúshą’ hanasółgo áíná’? ");
INSERT INTO apwNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Aishą’ shiganíí doo dawa bee ashłaa da lę́’e? ");
INSERT INTO apwNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Doo nohwee daagondlįį dahi, nohwijíí ła’íí nohwijeyi’ doo círcumcise ádaanołt’e’i dahíí k’ehgo doo daagodinołsíni da, dawahn Holy Spirit bich’ą́’zhį’go ádaanołt’ee, daanohwitaa n’íí ánádaat’įįł n’íí k’ehgo nohwíí ałdó’ ánádaałt’įįł. ");
INSERT INTO apwNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Hagee daanohwitaa n’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí doo yiniidaagodezlaa da? Nłt’éégo Ánát’įįłíí yígháhíí dabí’iłtséná’ yaa nadaagolṉi’íí nadaistseed; áí Nłt’éégo Ánát’įįłíí nyee’íí biyi’zhį’ ch’ídaasołtįįgo daazesołhįį: ");
INSERT INTO apwNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Bik’ehgo’ihi’ṉań binadaal’a’á yaaká’gé’hi begoz’aaníí nohwaa daidez’ąą ndi doo bikísk’eh ádaanołt’ee da. ");
INSERT INTO apwNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nṉee dała’adzaahíí Stephen áṉííhíí daidezts’ąąná’ dázhǫ́ bił daagoshch’ii’go biwoo nádaagai. ");
INSERT INTO apwNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Áíná’ Stephen, Holy Spirit ye’at’éégo, yaaká’yú dezghalgo Bik’ehgo’ihi’ṉań bich’ą́’idindláádíí ła’íí Jesus Bik’ehgo’ihi’ṉań dihe’nazhiṉéégo sizįįgo yiłtsąą, ");
INSERT INTO apwNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Áígé’ gáṉíí, Yáá iłch’ą́’ adzaago yaaká’yú nṉee k’ehgo Nyááhń Bik’ehgo’ihi’ṉań dihe’nazhiṉéégo sizįįgo hish’įį. ");
INSERT INTO apwNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nádaadidilghaazhná’ bijeyi’ ndaadeshchidgo dawa bich’į’ nádnkįį. ");
INSERT INTO apwNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Kįh gozṉilíí bich’ą́’yú ch’ídaabist’e’go nyída’isṉe’: tséé yee da’dilṉiihíí bidiyágé nṉee áníi nagháhá, Saul holzéhi, dées’eezgee ndaayihezṉil. ");
INSERT INTO apwNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Stephen t’ah nyída’iłṉe’ná’ gáṉíígo oskąąd, Jesus sheBik’ehń, shiyi’siziiníí nádnné’. ");
INSERT INTO apwNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Hayaa adzaago nawode gánṉiid, SheBik’ehń, díí nchǫ’ihíí dákoh bik’izhį’ ádaaholé hela’. Ánṉiidná’ daztsąą. ");
INSERT INTO apwNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Stephen daabiziłheehíí Saul da’áígee bił dábik’eh lę́’e. Áígé’ godeyaago Jesus daayokąąhíí Jerúsalemgee ha’ánáłséhíí biniidaagonłt’éégo inaghanakai begodeyaa; áík’ehgo dawa iłtanáhosąągo Judéayú ła’íí Samáriayú oheskai, nadaal’a’á zhą́ da’akú naháztąą lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nṉee daagodnłsíni Stephen dát’eego yaa daachagná’ łedaistįį. ");
INSERT INTO apwNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Áíná’ Saulhíí Jesus daayokąąhíí dayúweh binaghanakai, gowąhíí dała’á gon’ą́ą́go nantaago, nṉee ła’íí isdzáné daayiłtsoodgo ha’áyiłkaad lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jesus daayokąąhíí iłtanáhosąą n’íí dahot’éhé anákahyú yati’ baa gozhóni yaa nadaagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip Samáriayú óyáá, áí biyi’ kįh gozṉilgee Christ yaa yił nadaagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nṉee łą́ą́go Philip yałti’ihíí daidezts’ąągo ła’íí godiyįhgo ánágot’įįłíí ye’ánát’įįłíí daayiłtsąągo, áṉííhíí dałełt’eego yaa natsídaakeesgo bídaayésts’ąą lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Spirits daanchǫ’i nṉee łą́ą́go biyi’ daagolį́į́ n’íí daadilwoshná’ biyi’gé’ hanáhesąą, ła’íí łą́ą́go daadi’il n’íí ła’íí doo nadaakai da n’íí nádaabi’dilziih. ");
INSERT INTO apwNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Áík’ehgo áí kįh gozṉilgee dázhǫ́ koł daagozhǫ́ǫ́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Áí kįh gozṉilgee nṉee ła’ Simon holzéhi dabí’iłtséná’ nṉee Samáriayú daagolííníí daabo’ṉi’go k’izéyoṉiłi golį́į́ lę́’e, nṉee ízisgo at’éhi ádil’įįgo: ");
INSERT INTO apwNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Áń nṉee dawa bídaayésts’ąą, nṉee doo ízisgo ádaat’ee dahíí, nṉee ízisgo ádaat’eehíí ndi gádaaṉiigo, Díí nṉee Bik’ehgo’ihi’ṉań binawod bił nlįį lą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Daabo’ṉi’go ńzaad ogoyaahíí bighą nṉee yédaaldzidgo daayidnłsį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Áíná’ Philip, Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí nłt’éégo baa na’goṉi’íí ła’íí Jesus Christ bizhi’ daayozhíígo yaa nagolṉi’go nṉee ła’íí isdzáné daayosdląądgo baptize ádaaszaa. ");
INSERT INTO apwNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon dabíí ndi osdląądgo baptize ábi’delzaa: áígé’ Philip yił dahizh’aazhgo godiyįhgo be’ídaagoziníí ła’íí ízisgo áná’ol’įįłíí yiłtsąągo bił díyagot’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerúsalemgee nadaal’a’á nṉee Samáriayú daagolííníí Bik’ehgo’ihi’ṉań biyati’ nádaagodn’ą́ą́ yaat’ídaanzįįná’ Peter ła’íí John biłgo bich’į’ odais’a’: ");
INSERT INTO apwNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ákú ń’áázhná’ Holy Spirit baa daadót’aah daanzįgo yá da’oskąąd: ");
INSERT INTO apwNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","(BeBik’ehń Jesus bizhi’ bee baptize ádaaszaa ndi doo hwahá hadń ła’ Holy Spirit bee baa godet’aah da lę́’e.) ");
INSERT INTO apwNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Peter ła’íí John biłgo biká’ ndaadelṉiigo Holy Spirit bee baa daagodest’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nadaal’a’á nṉee yiká’ ndaadezṉiigo Holy Spirit bee baa daagodest’ąąhíí Simon yiłtsąąná’ nadaal’a’á zhaali yaa náiné’, ");
INSERT INTO apwNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Gáṉíígo, Shíí ałdó’ díí beshik’ehgo shaa godinot’aah, áík’ehgo dáhayíí biká’ ndaadeshṉiihíí Holy Spirit baa daadit’aah doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Áíná’ Peter gábiłṉii, Bik’ehgo’ihi’ṉań bich’ą́’gé’ aahi’né’íí nahashṉiih ńńzįhíí bighą nizhaalihíí dábił da’izlįį nleeh. ");
INSERT INTO apwNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bik’ehgo’ihi’ṉań binadzahgee nijíí doo bik’ehyú át’éé dahíí bighą díí ánáhiit’įįłíí doo hwaa ná goz’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ninchǫ’íí bich’ą́’yúgo ánṉe’go onkąąh, áík’ehgo nijíí biyi’gé’ dénchǫ’égo tsídíńkeezíí da’izlíné da’ánádolṉiił. ");
INSERT INTO apwNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nchǫ’go ágot’eehíí zhą́ niyi’ begoz’ąągo ninchǫ’íí łínestł’ǫǫ bígosíłsįįd. ");
INSERT INTO apwNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Áík’ehgo Simon gádaabiłṉii, Áshiłdołṉiihíí doo shich’į’ be’ágoṉe’ dahíí bighą Bik’ehgo’ihi’ṉań shá honołkąąh. ");
INSERT INTO apwNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Peter ła’íí John biłgo daayo’įį’ n’íí yaa nadaagosṉi’, ła’íí Jesus biyati’íí yaa yił nadaagosṉi’ná’ Jerúsalemyú onát’aazh; nát’aashyú Samária biyi’ gotahyú yati’ baa gozhóni yaa nadaagolṉi’go ánágoldoh. ");
INSERT INTO apwNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi Philip yich’į’ hadziigo gáyiłṉii, Dahnṉáhgo yagiyú ńṉáh, Jerúsalemgé’ Gázazhį’ intínhíí bich’į’go, da’izlįįyú. ");
INSERT INTO apwNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nádiidzaago dahiyaa: áígé’ nṉee Ethiópian eunuch nlíni, isdzán Cándace holzéhi, Ethiópians yánant’aahíí yiké’gee sitíni, dawahá łáń ílíni Cándace bíyééhíí yebik’ehi, Jerúsalemyú okąąhyú naghaagé’ ");
INSERT INTO apwNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","T’ąązhį’ nádaał lę́’e, bitsinaghái bijad nakihíí yiyi’ dahsdaago Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí, Esáias holzéhi, binaltsoos yozhíí goldoh. ");
INSERT INTO apwNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Holy Spirit Philip gáyiłṉii, Tsinagháihíí ałhánégo bich’į’ ńṉáh. ");
INSERT INTO apwNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Áík’ehgo Philip bich’į’ nádilwodgo Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí, Esáias holzéhi, binaltsoos yozhííhíí yidezts’ąągo gáyiłṉii, Ya’ áí hóńzhiihíí bígonłsį́ née? ");
INSERT INTO apwNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ethiópian gáṉíí, Hago’at’éégo bígonsíni, dahadń shił ch’ígó’aahyúgo zhą́ go’į́į́? Hasiiṉáhgo shit’ahgé’ dahndaa, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí díí k’ehgo aṉíhi yozhíí lę́’e, Dibełį́į́ zideeyú ch’olǫǫsíí k’ehgo, dagohíí dibełį́į́ bizhaazhé biłshéhíí yádngee sitįįgo doo hat’íí ṉíí dahíí k’ehgo bizé’ doo iłch’ą́’ ágole’ da: ");
INSERT INTO apwNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ádaayágosįyú ádaizlaagé’ dá doo nzhógo baa yá’iti’ da: hadńshą’ bich’ą́’gé’ daałideshchiinihíí yaa nagolṉi’? Ni’gosdzáń bich’ą́’gé’ bi’ihi’ṉa’ nádii’né’, ṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Áígé’ nṉeehń Philip gánábiłdo’ṉiid, Nánoshkąąh, díí Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí áṉííhíí hadń áiłṉiihíí? Dabíí ádaayalti’ née, dagohíí nṉee ła’ yaa yałti’ née? ");
INSERT INTO apwNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Áík’ehgo da’áí Bek’e’eshchiiníí biyi’gé’ Philip yałti’ nkegonyaago Jesus yaa yił nagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ch’okahyú tú bich’į’ dahch’idikaigo nṉeehń gáṉíí, Kú tú ła’ ląą; hat’íí bighą doo baptize áshi’dilṉe’ da doleeł? ");
INSERT INTO apwNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philip gáṉíí, Nijíí dawa bee ondląąyúgo ágáni’dilṉe’. Nṉeehń gábiłṉii, Jesus Christ Bik’ehgo’ihi’ṉań biYe’ nlįįgo hoshdląą. ");
INSERT INTO apwNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tsinaghái nnólgheed, nṉiid: áígé’ tú yiyi’ o’áázhgo Philip nṉeehń baptize áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tú biyi’gé’ hanát’aazhgo Bik’ehgo’ihi’ṉań biSpirithíí dagoshch’į’ Philip onábííłtį́į́: nṉee Ethiópian nlíni doo hwaa nábiłtsąą da, ndi bił gozhǫ́ǫ́go dahiyaa. ");
INSERT INTO apwNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philip Azótusgee náhiiltsąą: áígé’ kįh nagozṉilyú yati’ baa gozhóni yaa nagolṉi’go naghaa, áígé’ Caesaréa golzeezhį’ nnyaa. ");
INSERT INTO apwNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saul, Jesus daayokąąhíí nagontł’og yá hát’į́į́go ła’íí naotseed yo’ṉíígo okąąh yebik’ehi da’tiséyú sitíni yaa nyáá, ");
INSERT INTO apwNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Áígee gáyiłṉii, Damáscusgee Jews ha’ánáłséhíí bich’į’ naltsoos shá áńle’, áík’ehgo nṉee ła’íí isdzáné hayíí Jesus yikísk’eh daahikahíí ła’ baa niyááyúgo łídaashtł’ǫǫgo Jerúsalemyú shinaghadokah. ");
INSERT INTO apwNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Áígé’ Saul Damáscus golzeehíí bit’ahyú higaałgo, dahį́ko yaaká’gé’ bich’į’ nke’idindláád lę́’e: ");
INSERT INTO apwNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Áígee hayaa nágo’ná’ yati’ yidezts’ąą lę́’e, gáṉíígo, Saul, Saul, hat’íí ląą bighą shiniigonłt’éégo áshińłsį? ");
INSERT INTO apwNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul gáṉíí, Hadń áńt’įį, shiNant’a’? Áígé’ nohweBik’ehń gábiłṉii, Shiniigonłt’éégo áshińłsinihíí shíí ásht’į́į́, Jesus honszéhi: tsįdik’iihíí bee níts’i’ishgo’yúgo dayúweh t’ąązhį’ hóńtałyúgo dayúweh dáni ídída’nłṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saul bił díyagot’eego ditłidgo gáṉíí, SheBik’ehń, hat’íí áshłéhgo hánt’įį? Jesus gábiłṉii, Nádndáhgo kįh gozṉilyú ńṉáh, ákú hat’íí ánléhíí baa nił na’goṉi’ ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nṉee yił hikah n’íí doo hadaadzii dago nazįįná’ yati’ daidits’ag ndi doo hadń daayo’įį da lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul ni’gé’ nádiidzaago biṉáá iłch’ą́’ágolaa ndi doo go’į́į́ da lę́’e: áík’ehgo bigan daach’otą’go Damáscusyú odaach’izlǫǫz. ");
INSERT INTO apwNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Doo go’į́į́ dago taagi be’iskąą, dáshiṉá’ ła’íí dádibá’. ");
INSERT INTO apwNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damáscusgee nṉee Jesus yokąąhń Ananías holzéhi golį́į́ lę́’e; áń Jesus bił ch’í’ṉah ágólaago, Ananías, biłṉii. Ananías gáṉíí, Kú sídáá, sheBik’ehń. ");
INSERT INTO apwNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jesus gábiłṉii, Nádndáhgo kįh bigizhyú itín Ts’ígodezdǫh golzeegee ńṉáh, áígee nṉee Saul holzéhi, Társusgé’ gólíni, Judas golį́į́gee biká na’íńłkid: áígee áń okąąh ląą. ");
INSERT INTO apwNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Áígee nṉee Ananías holzéhi ha’ayáágo, go’į́į́ nádleeh doleełhíí bighą ndelṉiigo Saul bił ch’í’ṉah ágolzaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías gábiłṉii, SheBik’ehń, áń nṉeehń Jerúsalemgee nṉee daanokąąhíí nyeego yiniidaagodezlaahíí baat’ínsį ni’: ");
INSERT INTO apwNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","K’adíí áń kú hígháhgo hayíí nizhi’íí yeda’okąąhíí łídaiłtł’o’go baa godet’ąą lę́’e, okąąh yebik’ehi itisyú nadaandeehi ádaaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Jesus gábiłṉii, Ti’i: áń ich’ą́’níłtíni at’éé, shá na’iziidgo doo Jews daanlįį dahíí, ízisgo nadaant’aahíí, ła’íí Israel hat’i’íí shizhi’íí yídaagołsį áiléh doleełgo: ");
INSERT INTO apwNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Shíí shighą hago’at’éégo biniidaagonłt’éé doleełíí baa bił ch’í’ṉah ágoshłe’. ");
INSERT INTO apwNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Áík’ehgo Ananías dahiyaago kįh yuṉe’ ha’ayáá; Saul yiká’ ndelṉiiná’ gáṉíí, Shik’isń, Saul, Jesus nohweBik’ehń, itínyú yushdé’ híṉááłná’ nich’į’ ch’í’ṉah ádelzaahń, gon’į́į́ nándleeh doleełgo, ła’íí Holy Spirit bee nagodet’aago nich’į’ shides’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Dagoshch’į’ biṉáá biká’ siłtsooz silįį lę́’e n’íí yó’ózhóódgo go’įį násdlį́į́. Áígé’ nádiidzaago baptize ábi’delzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Áígé’ iyąągo nalwod nasdlį́į́. Damáscusgee Jesus daayokąąhíí yił naháztąągo da’kwííshį behiskąą. ");
INSERT INTO apwNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dagoshch į’ Jews ha’ánáłséh nagozṉil yuṉe’ Saul, Christ Bik’ehgo’ihi’ṉań biYe’ nlįį, ṉiigo yaa nagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nṉee daabidezts’ąą’íí dawa bił díyadaagot’eego gádaaṉii, Díńshą’ nṉeehń Jerúsalemgee nṉee Jesus bizhi’ daayozhíígo da’okąąhíí naistseedń át’į́į́; áí bighą kú ńyáá ni’, łídaiłtł’o’go okąąh yebik’ehi itisyú nadaandeehi yich’į’ yił dikáhgo? ");
INSERT INTO apwNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Áíná’ Saul dayúweh nłdzilgo yałti’go Jesus da’aṉii Christ nlįį lą́ą́, ṉiigo Jews Damáscusgee daagolííníí doo bich’į’ hanádaasdzii dago áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Łą́ą́go hiskaaníí bikédé’go Jews daanliiníí Saul daiziłheego ndaagoshchįį: ");
INSERT INTO apwNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Áíná’ ndaagoshchiiníí Saul yígołsįįd ni’: daabiziłhee hádaat’įįgo dajįį biigha, datł’é’ biigha kįh gozṉilíí biṉaayú łeda’diltł’į́hgee dááda’ditį́híí nzhógo yiṉádaadéz’įį; ");
INSERT INTO apwNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Áíná’ Jesus daayokąąhíí tł’é’yú łeda’diltł’į́híí bitis yuyaa gódah ch’ídaabíleeh, táts’aa yiyi’ dahsdaago. ");
INSERT INTO apwNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul Jerúsalemyú ńyááná’ Jesus daayokąąhíí yedigháh hát’į́į́ ndi bédaaldzid lę́’e, da’aṉii Jesus yokąąhń silįį ndi doo daabodląą dahíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Áíná’ Bárnabas Saul édeidiltįįgo nadaal’a’á yaa yił n’áázhgo gáṉíígo yaa nagolṉi’, Díń nṉeehń higaałyú Jesus yo’įįgo bich’į’ yałti’ ni’, ła’íí Damáscusgee doo biini’ hą́h dago Jesus yá sizįįgo yaa yałti’ ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Áígé’ Jerúsalemyú da’adzaayú yił nkedikai. ");
INSERT INTO apwNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Áígee doo biini’ hą́h dago Jesus yá sizįįgo yaa yałti’, Jews daanliiníí Greek biyati’ yee yádaałti’íí yich’į’ yałti’go yił łahadaadit’áhná’ daabiziłhee hádaat’įį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Áí odlą’ bee iłk’ííyú yídaagołsįįdná’ Caesaréayú yił hikai, áígé’ Társusyú onádaabis’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Áík’ehgo Jesus daayokąąhgo ha’ánáłséhíí Judéayú, Gálileeyú, Samáriayú daagolííníí bił nkenádaagodez’ąągo hadag bá nádaagodeyaa lę́’e, áí Bik’ehgo’ihi’ṉań daidnłsįgo dayúweh bá daagowáhgo, ła’íí Holy Spirit bidag ádaat’eego, dázhǫ́ łą́ą́ silįį. ");
INSERT INTO apwNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter gotah anádaałgo Jesus daayokąąhíí Lýdda golzeeyú daagolííníí ałdó’ yaa nyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ákú nṉee Enéas holzéhi yaa nyáá, di’ilhíí bighą sitįįgo tsebíí łegodzaahi. ");
INSERT INTO apwNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter gáyiłṉii, Enéas, Jesus Christ nánilziih: nádndáhgo nitsesk’eh iłch’į’ nándle’. Áígé’ dagoshch’į’ Enéas nádiidzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Áík’ehgo Lýddagee daagolííníí ła’íí Sárongee daagolííníí daayiłtsąągo Jesus yich’į’ dahaskai. ");
INSERT INTO apwNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Áígé’ Jóppa golzeegee isdzán Jesus yokąąhń gólį́į́, Tábitha holzéhi. Tábitha golzeeyú Dórcas golzeego ágolzee: áń nłt’éégo at’éhi, tédaat’iyéhíí yich’oṉíhi. ");
INSERT INTO apwNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Áíná’ áń yóíyahgo ńdezgaa’go daztsąą, áígé’ bits’í tádaizgizgo ik’éhéyú kįh dahnágost’ąą yuṉe’ ndaistįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lýdda golzeehíí Jóppa dábit’ahyú goz’ąą, áík’ehgo Jesus daayokąąhíí Peter akú naghaago yaat’ídaanzįįgo nṉee naki yich’į’ odais’a’ nádaayokąąhyú, Doo nt’áhgo da, dák’ad akú ńṉáh, daabiłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Áígé’ Peter dagoshch’į’ yił onákaigo ik’éhéyú kįh dahnágost’ąąyú yił okai. Ákóṉe’ itsaahíí Peter yit’ahgé’ daachago nazįį, íícho ła’íí diyágé Dórcas t’ah hiṉaaná’ áyíílaa n’íí dahdaayiṉííłgo. ");
INSERT INTO apwNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Áíná’ Peter dawa ch’ínołkáh yiłnṉiidgo, ch’ékainá’ Peter hishzhiizhgo oskąąd; áígé’ its’í siné’zhį’ déz’įįdná’ gáṉíí, Tábitha, nádndáh. Áík’ehgo ch’íńghalgo Peter yiłtsąąná’ nádiidzaago nezdaa. ");
INSERT INTO apwNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Yich’į’ dahdidilṉiigo náidnlǫǫs; áígé’ Jesus daayokąąhíí ła’íí itsaa daanliiníí dawa yushdé’ daayiłnṉiidgo gádaabiłṉii, Kú Tábitha náhi’ṉa’. ");
INSERT INTO apwNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jóppagee dahot’éhé baa godidezdlaadgo łánihi Jesus daayosdląąd. ");
INSERT INTO apwNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jóppa golzeegee Peter, Simon ikágé yiłdzehń yił sikeego doo ałch’ídé hiskąą da. ");
INSERT INTO apwNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Caesaréa golzeegee nṉee Cornélius holzéhi, silááda dałán gonenadín Italian band holzéhi yinant’a’ nlíni, golį́į́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Áń nṉeehń godnłsíni, ła’íí yił naháztaaníí biłgo Bik’ehgo’ihi’ṉań daidnłsį lę́’e, tédaat’iyéhíí yich’į’ odaagohijáhi, ła’íí Bik’ehgo’ihi’ṉań dá yokąąh nt’éhi. ");
INSERT INTO apwNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ha’iz’ąągé’ hayaazhį’ taagi łedihikeezyúshį Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi bił ch’í’ṉah ádelzaa, áí baa nyáágo, Cornélius, biłnṉiid. ");
INSERT INTO apwNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Yineł’į́įdná’ tsídolyizgo gáṉíí, Hat’íí lą́ą́hi, shiNant’a’? Bik’ehgo’ihi’ṉań binal’a’áhíí bich’į’ hadziigo gábiłṉii, Bik’ehgo’ihi’ṉań binadzahgee ni’okąąhíí ła’íí niłgoch’oba’íí bił nelą’. ");
INSERT INTO apwNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nṉee Jóppa golzeeyú daadnł’áá, Simon da’áń Peter holzéhi, yił nánókáh: ");
INSERT INTO apwNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Simon ikágé yiłdzehń yił sikee, bigową túnteel sikaaníí bit’ahyú goz’ąą: hago áńṉe’ shįhíí yaa nił nagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Bik’ehgo’ihi’ṉań binal’a’á bich’į’ yałti’ n’íí da’aazhį’ ásdįįdná’ Cornélius binal’a’á naki yich’į’ ánṉiid, silááda godnłsínihi dawahn naił’a’ihi ałdó’; ");
INSERT INTO apwNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Áík’ehgo bił ch’í’ṉah ágolzaahíí dawa yaa yił nadaagolṉi’ná’ Jóppa golzeeyú odais’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Áígé’ hiskąą hik’e odais’a’ n’íí kįh gozṉilíí yich’į’ ałhánégo hikahná’ ha’iz’ąązhį’ godeyaayú Peter kįh biká’yú okąąh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dázhǫ́ shiṉá’ silįįgo dahat’íhíta hoshąą nzį: áíná’ áda’ilṉe’ná’ nt’éégo bił ch’í’ṉah ágolṉe’go nágodiidzaa, ");
INSERT INTO apwNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Yaaká’gé’ bich’į’ iłch’ą́’ ágodzaago yiłtsąą, hat’ííshį łigaihi bich’į’ bił nkegonyáá, nadik’ą’ łigaihi k’a’at’éhi, dįįgé’ daayotą’go ni’zhį’ yił nkedaistsooz: ");
INSERT INTO apwNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Áí biká’gee ba’ iłtah at’éhi, dziłká’yú daagolíni, ch’osh ła’íí dlǫ́’ nadaakaigo yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Yaaká’gé’ yati’ yidezts’ąą gáṉíígo, Peter, nádndáh; ła’ nałtseedgo nnáá. ");
INSERT INTO apwNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Áíná’ Peter gáṉíí, SheBik’ehń, doodah, da’izlíné dagohíí doo daahidąągo nohwá goz’ąą dahíí doo hwaa hishąą da. ");
INSERT INTO apwNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Yati’íí náyidezts’ąą gáṉíígo, Bik’ehgo’ihi’ṉań nłt’éégo áyíílaahíí doo da’izlíné biłnṉii bik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Díí k’ehgo taadn da’iłké’go bich’į’ ágodzaa: áígé’ nadik’ą’ łigaihíí yaaká’yú bił onágodzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peter, shił ch’í’ṉah ágolzaahíí hagoshą’ ágot’eego shich’į’ ágót’įįd, nzįná’ nṉee Cornélius daades’a’ n’íí hikai, Simon hayú gólį́į́? daaṉiigo na’ódaadiłkidgo ch’í’ítinyú nazį. ");
INSERT INTO apwNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ya’ Simon, Peter ałdó’ bizhi’ń kú sidaa née? daaṉiigo na’ónádaadiłkid. ");
INSERT INTO apwNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter bich’į’ ágodzaahíí t’ah yaa natsekeesgo Holy Spirit gábiłṉii, Nṉee taagi níka daantaago kú hikai. ");
INSERT INTO apwNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nádndáhgo gódah ch’ínṉáh. Bił nádńkáh, doo t’ąązhį’ nt’éégo da: shíí kú odaasił’á’i at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Áík’ehgo Peter nṉee Cornélius odais’a’ n’íí yich’į’ gódah ch’ínyáágo gádaayiłṉii, Nṉee bíka daanołtaahíí shíí ásht’į́į́. Hat’íí bighą kú nołkai? ");
INSERT INTO apwNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Gádaabiłṉii, Cornélius, silááda dałán gonenadín yinant’a’ nlíni, nṉee bi’at’e’ nzhóni, Bik’ehgo’ihi’ṉań yidnłsíni, Jews dawa nłt’éégo baa yádaałti’i, Bik’ehgo’ihi’ṉań binal’a’á dilzini yaaká’gé’hi bich’į’ hadziigo niká idol’áá ṉiigo, bigowąyú ńṉáhgo niyati’ yidits’į́hyú. ");
INSERT INTO apwNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Áík’ehgo Peter, Ha’ałkáh, yiłnṉiid, áígé’ da’akú bedaiskąą. Iskąą hik’e Peter yił onákai, ła’íí ła’ odlą’ bee iłk’isyú daanliiníí Jóppagé’hi ałdó’ itah onákai. ");
INSERT INTO apwNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Áígé’ náiskąągee Caesaréa golzeeyú hikai. Áígee Cornélius bik’ííyú ła’íí daabit’ekéhíí dała’áyíílaago biba’ naháztąą. ");
INSERT INTO apwNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peter t’ah bich’į’ higaałná’ Cornélius bidedeswodgo biyahzhį’ hayaa na’ádolt’e’go yokąąh nágodiidzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Áíná’ Peter nábidnlǫǫzgo, Hizįį: shíí ałdó’ dáni k’ehgo nṉee nshłíni ánsht’ee, biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Iłch’į’ yałti’go ha’a’áázh, áígee łą́ą́go biba’ dała’ách’ít’éégo yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Peter gádaayiłṉii, Nṉee Jew nlíni nṉee łahgo hadaazt’i’íí yił na’aashgo, dagohíí yich’į’ onadáhgo doo bee bá goz’ąą da nohwíí bídaagonołsį; ndi shíí Bik’ehgo’ihi’ṉań gáshiłṉiigo shił ch’í’ṉah áyíílaa, Nṉee da’izlįį ádaat’ee, dagohíí dénchǫ’go ádaat’ee, doo daabiłnṉii da. ");
INSERT INTO apwNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Áí bighą shiká odaasoł’a’ná’ doo t’ąązhį’ ánsht’eego da, dagoshch’į’ niyáá: k’adíí nanohwídishkid, hat’íí bighą shiká odaasoł’a’ lą́ą́? ");
INSERT INTO apwNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornélius gábiłṉii, Dį́į́’i hiskąąná’ dákogee in’ą́ą́zhį’ dáshiṉá’ oshkąąh ni’; áígé’ ha’iz’ąągé’ hayaazhį’ taagi łedihikeezyú oshkąąh nt’éégo nṉee bidiyágé bich’ą́’idindládi shich’į’ sizįį ni’, ");
INSERT INTO apwNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Gáshiłnṉiid, Cornélius, Bik’ehgo’ihi’ṉań ni’okąąhíí yidezts’ąą, ła’íí tédaat’iyéhíí baa ch’onba’íí yee nínálṉiih. ");
INSERT INTO apwNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Áík’ehgo nṉee Jóppa golzeeyú daadnł’áágo Simon, da’áń Peter holzéhi, yił nánókáh; Simon, ikágé yiłdzehń, yił sikee, bigową túnteel sikaaníí bit’ahyú goz’ąą: áń nyáágo nich’į’ yałti’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Áí bighą dagoshch’į’ niká o’íł’aad ni’; nłt’éégo áńdzaago ńyaa. K’adíí daanohwigha dała’ánt’ee, Bik’ehgo’ihi’ṉań binadzahgee, Bik’ehgo’ihi’ṉań hago’at’éégo nángon’ą́ą́ shįhíí dawa daadnts’į́híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Peter yałti’ nkegonyaago gánṉiid, Bik’ehgo’ihi’ṉań nṉee dałełt’eego yaa natsekees bígosíłsįįd: ");
INSERT INTO apwNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nṉee iłtah at’éégo hadaazt’i’íí daantį́į́gee dahadń Bik’ehgo’ihi’ṉań yidnłsiníí ła’íí nłt’éégo at’ééhíí Bik’ehgo’ihi’ṉań bił dábik’ehi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bik’ehgo’ihi’ṉań biyati’ Israel hat’i’i bich’į’ bił o’ol’a’íí bídaagonołsį, Jesus Christ binkááyú nkegohen’ą́ą́go yá’iti’: (áń dawahá yebik’ehń nlįį:) ");
INSERT INTO apwNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Da’áí yati’íí John, Baptize ádaanohwi’dolṉe’, ṉiigo yaa yałti’íí bikédé’go Gálilee golzeegé’ Judéa dahot’éhé biyi’ baa na’goṉi’go bídaagonołsį dishṉii; ");
INSERT INTO apwNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Bik’ehgo’ihi’ṉań Jesus Názareth golzeegé’ gólíni, Holy Spirit ła’íí binawodíí bee baa godin’ą́ą́go its’áyinłtį́į́: áígé’ nłt’éégo ánát’įįłgo ánádaał lę́’e, ła’íí ch’iidn yisná ádaabiłsíni n’íí nádailziih; Bik’ehgo’ihi’ṉań yiłnlįįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jews daabini’yú ła’íí Jerúsalemyú dawa ye’ánát’įįłíí nohwíí nohwiṉááł ánágot’įįł; áń tsį’iłna’áhi yídaayiheskałgo daizes‐hįį: ");
INSERT INTO apwNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Áíná’ áígé’ taagi jįį hileehgo Bik’ehgo’ihi’ṉań nábihil’ṉa’ná’ ch’í’ṉah hit’įįgo ábíílaa; ");
INSERT INTO apwNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Doo nṉee dawa bich’į’ da, áíná’ nohwíí daahihiiltséh doleełgo Bik’ehgo’ihi’ṉań hadaanohwihezṉilíí nohwich’į’ Jesus daztsąągé’ naadiidzaahíí bikédé’go bił da’iidąą n’íí Bik’ehgo’ihi’ṉań nohwich’į’ ch’í’ṉah hit’įįgo ábíílaa. ");
INSERT INTO apwNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jesus gánohwiłṉiigo nohwá ndaagoz’ąą, Yati’ baa gozhóni nṉee baa bił nadaagołṉi’, ła’íí bich’į’ gáshiłdołṉiih, Daahiṉaahíí ła’íí nanezna’íí yaa Yałti’ doleełgo Bik’ehgo’ihi’ṉań haiyiłtį́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí dawa áń yaa nadaagolṉi’go gádaanṉiid, Áń bizhi’íí bee dahadń bodląągo ba’ołííhń binchǫ’íí da’izlíné doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peter t’ah díí yaa yałti’go hayíí daidezts’aaníí dawa Holy Spirit bee baa daagodest’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Círcumcise ádaabi’deszaahíí bitahgé’ Jesus daayodlaaníí Peter yił hikaihíí bił díyadaagodzaa, áí nṉee doo Jews daanlíni da ndi Holy Spirit bee baa daagodest’ąąhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Holy Spirit‐híí yati’ ła’i yee yádaałti’go ádaabiłsįgo ła’íí, Bik’ehgo’ihi’ṉań bich’į’ ahédaandzį, daaṉiigo daidezts’ąą. Áík’ehgo Peter gáṉíí, ");
INSERT INTO apwNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Hadń díí nṉee dánohwíí k’ehgo Holy Spirit bee baa daagodest’aaníí doo tú bee baptize ádaabi’dilṉe’ bik’eh da nzį? ");
INSERT INTO apwNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Áík’ehgo Jesus Christ bizhi’ bee baptize ádaanohwi’dolṉiił, ṉiigo yee yángon’ą́ą́. Áígé’ gádaabiłṉii, Da’kwíí hiskąązhį’ kú nohwitahyú síńdaa. ");
INSERT INTO apwNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nadaal’a’á ła’íí Jesus bee iłk’ííyú daanliiníí Judéayú daagolííníí, doo Jews daanlįį dahíí Bik’ehgo’ihi’ṉań biyati’ ałdó’ nádaagodn’ąągo yaat’ídaanzį. ");
INSERT INTO apwNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Áík’ehgo Peter Jerúsalem yúdag onanádzaago nṉee círcumcise ádaaszaa zhiṉéé daanliiníí doo bił daabik’eh dago ");
INSERT INTO apwNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Gádaabiłṉii, Nṉee doo círcumcise ádaaszaa dahi bił da’ináá lą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Áík’ehgo Peter hago’at’éégo ánádaagot’įįłíí iłké’ nyiṉilgo yaa yił nadaagolṉi’ nkegonyaa gáṉíígo, ");
INSERT INTO apwNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Jóppa golzeeyú sídáágo oshkąąhgo shił ch’í’ṉah ágolṉéh nkegonyaa: Hat’ííshį łigaihi shich’į’ bił nkegonyáá, nadik’ą’ łigaihi dįįgé’ daayotą’go shich’į’ yił nkedaistsoozgo hiłtsąą: ");
INSERT INTO apwNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Da’as’ah neł’įįdgo áí biká’gee ba’ iłtah at’éhi, dziłká’yú daagolíni, ch’osh ła’íí dlǫ́’ nadaakaigo hiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yati’ desiits’ą́ą́ gáṉíígo, Peter, nádndáh, nałtseedgo nnáá. ");
INSERT INTO apwNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Áíná’ gádéṉiid, SheBik’ehń, doodah, da’izlíné dagohíí doo daahiidąągo nohwá goz’ąą dahíí doo hwaa ízaashné’i at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Yati’íí yaaká’gé’ gánáshido’ṉiid, Bik’ehgo’ihi’ṉań nłt’éégo áyíílaahíí doo da’izlíné biłnṉii bik’eh da, ṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Díí k’ehgo taadn da’iłké’go shich’į’ ágodzaa: áígé’ nadik’ą’ łigaihíí yaaká’yú bił onágodzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Áígé’ dagoshch’į’ nṉee taagi Caeseréa golzeegé’ shich’į’ hil’aad lą́ą́hi shaa hikai. ");
INSERT INTO apwNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Holy Spirit gáshiłnṉiid, Ákú bił nádńkáh, doo t’ąązhį’ nt’éégo da. Odlą’ bee iłk’isyú daanliiníí gostáń ałdó’ biłonáhiikai, áígee nkaigo nṉeehíí bigową yuṉe’ ha’áhiikai: ");
INSERT INTO apwNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Áík’ehgo nohwił nagosṉi’ hago’at’éégo bigową yuṉe’ Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi sizįįgo yiłtsąągo gábiłnṉiid, Nṉee ła’ Jóppa golzeeyú daadnł’áá, Simon, da’áń Peter holzéhi, yił nánókáh; ");
INSERT INTO apwNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Áń ni ła’íí bił naháńtaaníí biłgo yati’ bee hasdádołkahíí yaa nił nagodolṉih. ");
INSERT INTO apwNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Áík’ehgo bich’į’ yádaashti’ nágodiidzaago Holy Spirit bee baa daagodest’ąą, ntsé godeyaaná’ nohwaa daagodest’ąą n’íí k’ehgo. ");
INSERT INTO apwNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jesus áṉíí n’íí, John tú zhą́ yee baptize ádaayizlaa; ndi nohwíí Holy Spirit bee baptize ádaanohwi’dolṉiił, nohwiłṉii n’íí bénashṉiih. ");
INSERT INTO apwNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","NohweBik’ehń Jesus Christ daahosiidląądná’ Bik’ehgo’ihi’ṉań Holy Spirit nohwaa daizné’íí bíí ałdó’ da’áí k’ehgo baa daizné’yúgo, shíí doo hat’íí bee inshłįį dago, doo doodah dishṉii da ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Áí daidezts’ąąná’ doo hat’íí ńdaado’ṉii da, áíná’ Bik’ehgo’ihi’ṉań ya’ahédaanzįgo gádaaṉii, Áík’ehgo nṉee doo Jews daanlįį dahíí ałdó’ binchǫ’íí yich’ą́’zhį’ ádaasdzaayúgo ihi’ṉaa doo ngonel’ąą dahíí Bik’ehgo’ihi’ṉań baidin’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stephen zesdįįhíí bikédé’go Jesus daayokąąhíí biniidaagodeszaahíí bighą iłch’ą́’yú oheskaihíí, ła’ Pheníce golzeezhį’, ła’íí Cýprus golzeezhį’, ła’íí Ántioch golzeezhį’ oheskai, dá Jews daanliiníí zhą́ Bik’ehgo’ihi’ṉań biyati’ yee yich’į’ yádaałti’go. ");
INSERT INTO apwNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ła’íí nṉee Cýprus golzeegé’ ła’íí Cyréne golzeegé’ daagolííníí Ántioch golzeeyú hikainá’ nṉee Greek biyati’ yee yádaałti’íí yich’į’ yádaałti’, Jesus nohweBik’ehń yaa yił nadaagolṉi’go. ");
INSERT INTO apwNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bik’ehgo’ihi’ṉań yił daanlįįgo nṉee łą́ą́go da’osdląądgo Bik’ehgo’ihi’ṉań yich’į’ dahaskai. ");
INSERT INTO apwNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jesus daayokąąhíí Jerúsalemgee ha’ánáłséhíí áí yaat’ídaanzįgo Bárnabas Ántiochyú odais’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ákú ńyááyú Bik’ehgo’ihi’ṉań biłgoch’oba’íí ye’ánát’įįłíí yiłtsąągo bił gozhǫ́ǫ́ lę́’e, Nohwi’odlą’ nłdzilgo bee nasołsįįgo nohweBik’ehń doo bich’ą́’zhį’ ánádaahołṉe’ da, daayiłṉiigo yidag yádaałti’. ");
INSERT INTO apwNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bárnabasń nṉee nłt’éhi nlįį, Holy Spirit ye’at’éhi, ła’íí bi’odlą’ nłdzili: áík’ehgo nṉee łą́ą́go Bik’ehgo’ihi’ṉań daayosdląąd. ");
INSERT INTO apwNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Áígé’ Bárnabas Társus golzeeyú Saul yíka ntaayú óyáá: ");
INSERT INTO apwNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ákú yaa nyáágo Ántiochyú yił nat’áázh. Áígee Jesus daayokąąhíí yił ha’ánáłséhgo dała’á łegodzaa, áík’ehgo nṉee łą́ą́go yił ch’ídaagoz’ąą. Ántiochgee Jesus daayokąąhíí da’iłtsé ínashood daahosze’. ");
INSERT INTO apwNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Áí benagowaaná’ nṉee Bik’ehgo’ihi’ṉań binkááyú yádaałti’íí Jerúsalemgé’ Ántiochzhį’ hikai. ");
INSERT INTO apwNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Áí ła’ Ágabus holzéhi hizį’go, Holy Spirit yábiyiłti’go, Ni’gosdzáń dahot’éhé shiṉá’ góyéégo begodigháh, nṉiid: Cláudius Caesar nant’án nlįįná’ díí begolzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ínashood daantį́į́gee dayídaanel’ąągee Jesus bee bik’ííyú Judéayú daagolííníí bich’odaahi’ṉii daanzįgo biini’ ładaizlaa: ");
INSERT INTO apwNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Gádaadzaago Bárnabas ła’íí Saul yaa daizné’gé’ Judéayú ínashood yánaziiníí yich’į’ odaizné’. ");
INSERT INTO apwNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Áí benagowaaná’ Hérod nant’án nlįįgo ínashood ła’ yiniidaagonłsį nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Áń bik’ehgo James, John bik’isn, bésh be’idiltłishé bee zesdįį. ");
INSERT INTO apwNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Áí Jews daanliiníí bił dádaabik’ehgo yígołsįįdná’, Peter ałdó’ ha’alt’e’go yee nagoshchįį lę́’e. (Báń benilzoołé da’ádįhgo báń alzaahi daach’iyąąná’ díí be’ánágot’įįł.) ");
INSERT INTO apwNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Áík’ehgo Peter Hérod bik’ehgo daayiłtsoodgo ha’ádaist’e’, áígé’ silááda dį́į́’go siṉili biṉádaadéz’įįgo baa neltįį; Bitis‐hagowáh bee bíná’godiṉíhgo bikédé’go nṉee biṉááł ch’ínádishteeł nzįgo. ");
INSERT INTO apwNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Peter ha’áná’ilka’ yuṉe’ ásitįįná’ Bik’ehgo’ihi’ṉań bich’į’ ínashood ha’ánáłséhíí dá bá da’okąąh nt’éé lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Iskąą hik’e Hérod Peter ch’ínádishteeł nzį lágo, ndi da’áí bitł’é’ bésh hishbizhíí naki bee łíbi’destł’ǫǫgo silááda naki bigizhyú ałhosh: silááda ła’ihíí dáádítį́hgee yiṉádaadéz’įį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Dahį́ko Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi ch’í’ṉah ádelzaago ha’ásitįį yuṉe’ ididezdlaad: Peter bi’ask’ehyú bedelchidgo, Dahałe nádndáh, biłnṉiid. Bésh hishbizhíí bigan bee łestł’ǫ́ǫ́ n’íí nanehesdee. ");
INSERT INTO apwNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Áígé’ Bik’ehgo’ihi’ṉań binal’a’á gánábiłdo’ṉiid, Nidiyágé ánágodle’go áde’itł’ó, ła’íí nikee na’astł’óné bee ná’ńl’éés: áík’ehgo ágádzaa. Áígé’ gánábiłdo’ṉiid, Iká’ ninasti’íí ídinánłtihgo shiké’ ńṉáh. ");
INSERT INTO apwNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Áígé’ ch’ínyáágo yiké’ dahiyaa; Bik’ehgo’ihi’ṉań binal’a’á ánát’įįłíí da’aṉii bich’į’ ánát’įįłíí doo yígółsį da; áíná’ daazhógo shił ch’í’ṉah ágodzaa nzį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Silááda yiṉádéz’iiníí iłtséhíí ła’íí iké’geehíí yitis ch’ín’áázhná’ kįh gozṉilíí bich’į’zhį’go bésh dáádítį́hi yaa n’áázh; áí dabínik’eh ch’ínkééz: áígé’ ch’ín’áázhgo kįh bigizhyú itín yuṉe’ o’áázh; áígee dagoshch’į’ Bik’ehgo’ihi’ṉań binal’a’á bich’ą́’ onádzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Peter dabíí ídínágolzįįdgo gánṉiid, Bik’ehgo’ihi’ṉań binal’a’á shich’į’ yił’aadgo, Hérod bíla’łtł’áhgé’ ła’íí Jews daanliiníí hago áshidilṉe’go ndaayołíí n’íí yich’ą́’ ch’íshinłtį́hgo bígosíłsįįd. ");
INSERT INTO apwNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Díí yígołsįįdná’ John, da’áń Mark holzéhi, bimaa Mary bigowąyú óyáá; áígee łą́ą́go dała’adzaago da’okąąh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peter ch’í’ítinyú dáádítį́híí ńyinests’įgo it’eedn, Rhoda holzéhi, dáádítį́hyú ńyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Peter bizhiihíí yígołsįįdgo dá doo yá ch’í’ítiinhé bił gozhǫ́ǫ́go ha’ánálwodgo, Peter dáádítį́hgee sizįį, ṉiigo nṉee ákóṉe’ naháztaaníí yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Niini’ ádįh née! daabiłnṉiid. Áíná’ dayúweh ágáṉíí. Gánádaabiłdo’ṉiid, Binádidzołíí zhą́ benagowaa. ");
INSERT INTO apwNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Áíná’ Peter dayúweh dáádítį́h ńyinłts’į: áígé’ bá ch’ída’iztąągo daabiłtsąąná’ bił díyadaagot’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Dant’éhe naháztąą doleełhíí bighą nabída’igizh, áígé’ hago’at’éégo Bik’ehgo’ihi’ṉań ha’áná’ilka’gé’ ch’íbinłtiiníí yaa nagosṉi’. Áígé’ gánṉiid, Díí ágodzaahíí James ła’íí odlą’ bee nohwik’ííyú baa bił nadaagołṉi’. Áígé’ dahnyaago łahyúgo onanádzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Hayiłkąą hik’e silááda bitahyú ch’iṉii hadndláád, Peter hago adzaa, daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Áígé’ Hérod bíka ntaa ndi doo hwaa baa nyaa da, áík’ehgo silááda yiṉádaadéz’įį n’íí baa yá’iti’go natseedgo yándaagoz’ąą. Áígé’ Judéagé’ Caesaréayú óyáágo da’áígee sidaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hérod, Tyre ła’íí Sídongee nṉee daagolííníí yich’į’ hashkee: Blástus, Hérod yánal’a’á, t’eké ádaisdlaago dałaházhį’ dała’adzaago Hérod yaa hikai, nkegohen’ą́ą́ le’, daaṉiigo yich’į’ yádaałti’, nant’án bini’ bich’ą́’gé’ zhą́ da’iyąąhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Áík’ehgo ch’ídaagoz’aaníí bijįį Hérod nant’án k’ehgo ík’e’idlaago nant’án dahsdaa n’gee dahnezdaago nṉee hikaihíí nłt’éégo yich’į’ yałti’. ");
INSERT INTO apwNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Áík’ehgo nṉeehíí, Díí bich’į’ da’ch’okąąhń bizhiihíí áṉíí, doo nṉee da! daaṉiigo ńdaadidilghaazh. ");
INSERT INTO apwNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hérod, Bik’ehgo’ihi’ṉań zhą́ daach’idnłsíni at’éé, doo ṉii dahíí bighą dagoshch’į’ Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi kah bik’izhį’ áyíílaa: áígé’ ch’osh bitsį daiyąągo bizes‐hį́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Áíná’ Bik’ehgo’ihi’ṉań biyati’íí dayúweh didezdlaadgo nchaa silįį. ");
INSERT INTO apwNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bárnabas ła’íí Saul biłgo, bighą daades’a’ n’íí ąął ádaizlaaná’ Jerúsalemgé’ John, da’áń Mark holzéhi, yił nakai. ");
INSERT INTO apwNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ántiochgee ínashood ha’ánáłséhíí Bik’ehgo’ihi’ṉań binkááyú yádaałti’íí ła’íí iłch’ídaago’aahíí, áí Bárnabas ła’íí Símeon, Niger holzéhi, Lúcius, Cyrénegé’ gólíni, Mánaen, Hérod nant’án yił daahiṉa’ń, ła’íí Saul itah ha’ánákah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Dáshiṉá’ Bik’ehgo’ihi’ṉań daayokąąhná’ Holy Spirit gábiłṉii, Bárnabas ła’íí Saul shá nada’iziidgo bich’į’ ádéṉiid n’íí shá its’ánołe. ");
INSERT INTO apwNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Áík’ehgo dáshiṉá’ náda’oskąądná’ Bárnabas ła’íí Saul yiká’ ndaadesṉii, áígé’ odais’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Áígé’ Holy Spirit odaabis’a’go Seléuciayú ń’áázh; áígé’ Cýprusyú bił oda’iz’eel. ");
INSERT INTO apwNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Sálamisgee n’áázhná’ Jews ha’ánáłséh nagoz’ąą yuṉe’ Bik’ehgo’ihi’ṉań biyati’ yaa yádaałti’: John bich’odaaṉii lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Páphos golzeegee ni’ tayi’ dahgoz’áni yiká’ ch’ín’áázh; áígee nṉee Bar‐Jesus holzéhi, Jew nlíni, bena’ich’aahíí iłtah at’éégo áná’ol’įįłi, Bik’ehgo’ihi’ṉań binkááyú na’iziid ádil’ínihi, Paul ła’íí Bárnabas baa n’áázh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Áń nṉee góyáni, nant’án nlíni, Sérgius Paulus holzéhi yił n’áázh; áń Bik’ehgo’ihi’ṉań biyati’íí yidits’į́h hát’į́į́híí bighą Bárnabas ła’íí Saul yiká’iił’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Áíná’ Bar‐Jesus, da’áń Élymas holzéhi, (Élymas golzeehíí bena’ich’aahíí iłtah at’éégo áná’ol’įįłi golzeego ágolzee) nant’án dánko odląą hileeh nzįhíí bighą Bárnabas ła’íí Saul yidáhzhį’ yałti’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Áíná’ Saul, (da’áń Paul holzéhi) Holy Spirit yábiyiłti’go da’as’ah yineł’į́į́, ");
INSERT INTO apwNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Áígé’ gáyiłṉii, Ni, ch’iidn bik’ehgo áńt’íni, dawahn nṉee bich’į’ nach’áhi, dawahn nchǫ’go áńt’éhi, nłt’éégo ágot’eehíí dawa doo nił nzhǫǫ dahi, Bik’ehgo’ihi’ṉań bich’į’ ts’ígodesdǫh itínhíí digizgo ánłsini, doo dayúweh ágánt’įį da le’. ");
INSERT INTO apwNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","K’adíí Bik’ehgo’ihi’ṉań nich’į’ ná’diziidgo dét’įhézhį’ niṉáá ágodįhgo ch’ígona’áí doo hí’į́į́ da nleeh. Dagoshch’į’ biṉá’oh golbaa gozlįį, áígé’ godiłhił bik’egonyáá; áík’ehgo hadń bidilǫǫsń yíka nantaa nágodiidzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Áígé’ nant’án ánágot’įįłíí yo’įįná’, Bik’ehgo’ihi’ṉań biyati’ yee bił ch’ígót’aah n’íí baa yił díyagot’eego osdląąd. ");
INSERT INTO apwNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul yił nakaihíí biłgo Páphosgé’ bił oda’iz’eel, ni’ Pamphýlia golzeehíí biyi’ Pérga golzeezhį’ hikai: áígé’ John bich’ą́’ Jerúsalemyú onádzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Áígé’ Pérgagé’ yúweh ni’ Pisídia golzeehíí biyi’ Ántioch golzeeyú onanákai, Jews daagodnłsiníí bijįį ha’ánáłséh goz’ąą yuṉe’ ha’ákaigé’ dahdinezbįh. ");
INSERT INTO apwNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Begoz’aaníí ła’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí biyati’ daayozhiihíí bikédé’go Jews ha’ánáłséhíí binadaant’a’ bich’į’ oda’is’a’ gádaaṉiigo, Nṉee daanołíni, shik’ííyú, yati’ ła’ nṉee bich’į’ bidag yádaałti’ lę́’eyúgo dák’ad ágádaadołṉiih. ");
INSERT INTO apwNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Áík’ehgo Paul hizį’go na’ígizhná’ gáṉíí, Israel hat’i’i daanołíni, Bik’ehgo’ihi’ṉań daadinołsíni, ídaayesółts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Díí Isreal hat’i’i Bik’ehgo’ihi’ṉań daayokąąhń daanohwitaa n’íí hayihezṉilgo ni’ Egypt, doo daabíyéhi biyi’ daagolį́į́ n’ná’ nṉee ízisgo ádaat’eego áyíílaa ni’, ła’íí binawod bee ni’ Egyptgé’ ch’íiṉil ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dénchǫ’go ádaat’ee ndi yiṉádéz’įįgo da’izlįįyú dizdinhíí hagee bił łegodzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ni’ Cánaan golzeegee nṉee gosts’idyú hat’i’i doo hat’íí dago áyíílaaná’ bini’ n’íí Israel hat’i’i dała’á daantį́į́gee bíyéé doleełíí bebígozįįhíí yá áyíílaago ni’ yá iłk’idaahosdzog. ");
INSERT INTO apwNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Áí bikédé’go aayádaaltihíí bánadaant’aago bá ágólaa, dį́į́dn gonenadínyú ashdladin łegodzaayú shį, Bik’ehgo’ihi’ṉań binkááyú na’iziidi, Samuel holzéhi, nyáázhį’. ");
INSERT INTO apwNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Áígé’ ízisgo nant’án daayokeed; áík’ehgo Saul, Kish biye’, Benjamin hat’i’íí nlíni, Bik’ehgo’ihi’ṉań baa destįįgo bánant’aago dizdin łegodzaazhį’. ");
INSERT INTO apwNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Áń k’ihzhį’ nnáíńłtį́į́ná’ David nant’án ánálzaa; áń díí k’ehgo áṉíígo yaa nagolṉi’, David, Jesse biye’híí shił dábik’ehyú át’ééhíí ła’íí dáhasht’į́į́yú ánát’įįłíí bígosíłsįįd. ");
INSERT INTO apwNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Díí nṉee bich’ą́’gé’ hadaałishchínihíí bitahgé’ Bik’ehgo’ihi’ṉań ngon’ááníí k’ehgo Israel hat’i’i bá Hasdá’iiniiłíí bá yiłtį́į́, áń Jesus holzee: ");
INSERT INTO apwNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Doo hwahá Jesus higháh daná’ John, Nohwinchǫ’íí bich’ą́’zhį’ ádaałṉe’go baptize ádaanohwi’dolṉe’, ṉiigo Israel hat’i’íí dawa yich’į’ yałti’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","John binasdziid k’ad ąął áile’ná’ gáṉíí, Hadń át’į́į́ daashidołṉiih? Shíí doo áń ásht’į́į́ da. Ndi shikédé’go higháhihíí biketł’óól k’e’ish’adgo ndi doo bik’eh sítį́į́ da. ");
INSERT INTO apwNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Nṉee daanołíni, shik’ííyú, Abraham hat’i’i daanołíni, ła’íí nohwitahgé’ Bik’ehgo’ihi’ṉań daadinołsíni, hasdách’ikáhíí baa na’goṉi’íí nohwíí nohwich’į’ alzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerúsalemyú daagolííníí binadaant’a’ dábiłgo Jesus doo yínádaagolzį da, ła’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidi ádaaṉii n’íí, godilziníí bijįį dawahn náhójii n’íí doo bił ídaagozį dahíí bighą ádaaṉii n’íí begolzaa, da’itsaahíí bee bá ndaagoz’ąągo. ");
INSERT INTO apwNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hat’íí bighą daayiziłhééhíí doo yídaagołsį da, ndi Pílate nádaayokąąh, ziłhéé daayiłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bek’e’eshchiiníí ąął begolzaaná’ tsį’iłna’áhi biká’gé’ godah ch’ínádaiztįįgo, tsébii’i’áń yuṉe’ iłch’į’ndaiztįį. ");
INSERT INTO apwNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ndi daztsąągé’ Bik’ehgo’ihi’ṉań nábihil’ṉa’: ");
INSERT INTO apwNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Áígé’ łą́ą́go iskąągo hayíí Gálileegé’ Jerúsalemzhį’ yił hikaihíí yich’į’ ch’í’ṉah ánádil’įį lę́’e, áí k’adyúgo biṉááł ánágot’įįdíí nṉee yił nadaagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Yati’ baa gozhóni baa nohwił nadaagolṉi’, bich’ą́’gé’ hadaałinelt’aaníí Bik’ehgo’ihi’ṉań bángon’ą́ą́ n’íí k’ehgo, ");
INSERT INTO apwNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Jesus nábi’dihil’ṉa’íí, nohwíí bichągháshé daandliiníí nohwá ye’ilaa; psalm nakigee ałdó’ biyi’ gáṉíígo k’e’eshchįį, ShiYe’ ńlį́į́, díí jįįgé’ nitaa sílį́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Doo diłdzid nanádleeh dago daztsąągé’ náyihilṉa’íí yaa nagolṉi’go gáṉíí, Da’aṉiigo David bángoni’ááníí nohwíí nohwaa nshné’. ");
INSERT INTO apwNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Psalm ła’íí ałdó’ biyi’ gánádi’ṉii, Dilzini Nlíni ṉíyééhíí diłdzidíí doo bee bángon’áah da. ");
INSERT INTO apwNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davidhíí naghaa n’ná’ habinołt’įįłíí bá Bik’ehgo’ihi’ṉań yighą binł’a’íí ąął áyíílaahíí bikédé’go, David daztsąągo bik’íí n’íí łe’siṉilíí bitahyú nbi’deltį́į́ lę́’e, áík’ehgo nłdzid; ");
INSERT INTO apwNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ndi Bik’ehgo’ihi’ṉań nábihil’ṉa’íí doo nłdzid da. ");
INSERT INTO apwNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Áí bighą nṉee daanołíni, shik’ííyú, bídaagonołsį le’, díí nṉeehń baa nohwił nagolṉi’, binkááyú dénchǫ’go ádaanołt’ee n’íí nzhooníí bee nohwaa nágodit’aahíí bighą: ");
INSERT INTO apwNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Hayíí áń yodląąhń dawahá biyi’gé’ nłt’éégo ch’íbíłteehi at’éé, áíná’ Bik’ehgo’ihi’ṉań yegos’aaníí Moses binkááyú ni’né’i doo dawa bee ch’íkółteehi at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Bik’ehgo’ihi’ṉań binkááyú nada’iziidi ágádaaṉii n’íí doo bee nohwich’į’ ágoṉéh da doleełhíí bighą baa daagonołsąą; ");
INSERT INTO apwNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Sąą, aadaadlohíí daanołíni, nohwił díyadaagot’ee, doo haada daadołeeł: nohwíí yołkaałíí biyi’ hat’íhíta ashłe’, áí ashłe’íí ła’ nohwił nagolṉi’yúgo ndi doo daahołdląą da. ");
INSERT INTO apwNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Jews daanliiníí ch’ínákainá’ doo Jews daanlįį dahíí, Iké’gee godilziníí bijįį da’áík’ehgo nohwił nanádaagodołṉih, daabiłṉiigo nádaabokąąh. ");
INSERT INTO apwNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Áík’ehgo dała’ách’ít’ééhíí ąął tanách’osąąná’ Jews daanlíni ła’íí Jews bi’okąąhíí yédikaihíí daidnłsíni łą́ą́go Paul ła’íí Bárnabas yiké’ dahiskai; áí bich’į’ yádaałti’ ła’íí, Bik’ehgo’ihi’ṉań biłgoch’oba’íí dayúweh nłt’éégo baa hołkaah, daabiłṉiigo bidag yádaałti’. ");
INSERT INTO apwNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Áígé’ godilzįh hik’e kįh gozṉilgee nṉeehíí dásdozhą́ dawa dała’adzaa, Bik’ehgo’ihi’ṉań biyati’ ídaayésts’ąąyú. ");
INSERT INTO apwNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Jews daanlíni nṉee dała’at’ééhíí daayiłtsąąná’ dázhǫ́ da’ołch’įįd lę́’e, Paul áṉííhíí doo áígee da, daaṉii ła’íí nchǫ’go yaa yádaałti’. ");
INSERT INTO apwNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paul ła’íí Bárnabas doo biini’ hą́h dago gádaaṉii, Bik’ehgo’ihi’ṉań biyati’íí nohwíí iłtsé nohwich’į’ bee yá’iti’go dábik’eh: ndi daanohwíí k’ihzhį’ bídaasoyilgo dahazhį’ ihi’ṉaahíí doo bik’eh sitįį da daanołsį dago, ádándaagosołt’ąąhíí bighą doo Jews daanlįį dahíí bich’į’go dahsiikai. ");
INSERT INTO apwNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ágáṉíígo nohweBik’ehń nohwá ngon’ą́ą́, Doo Jews daanlįį dahíí bá idindláádíí ńlį́į́go haniłtį́į́, ni’gosdzáń náhen’ą́ą́yú nṉee iłtah at’éégo hadaazt’i’i ninkááyú hasdákáh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Doo Jews daanlįį dahíí díí daidezts’ąąná’ bił daagozhǫ́ǫ́go Bik’ehgo’ihi’ṉan biyati’ ya’ahédaanzį lę́’e: dahazhį’ daahiṉaa doleełgo nábidihesdlaahíí dawa da’osdląąd. ");
INSERT INTO apwNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Bik’ehgo’ihi’ṉań biyati’ Ántioch biṉaayú dáhot’éhé didesdlaad lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ndi Jews daanlíni isdzáné daagodnłsíni nłt’éégo bídaagozini, ła’íí nṉee nant’án daanlíni ákú daagolííníí biini’ yá ádaagozlaa, Paul ła’íí Bárnabas biniidaagododle’, daaṉiigo, áík’ehgo daabini’gé’ ch’ídaayineyood. ");
INSERT INTO apwNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bikee łeezh yaa daayiiłháal, doo hádaabich’it’įį dahíí nṉee bee bígózįhíí bighą, áígé’ Icóniumyú onanát’aazh. ");
INSERT INTO apwNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Hayíí da’osdląądíí bijíí dawa yee bił daagozhǫ́ǫ́, ła’íí Holy Spirit ye’ádaat’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Icónium golzeegee Paul ła’íí Bárnabas biłgo Jews ha’ánáłséh goz’ąą yuṉe’ ha’a’áázhgo yádaałti’, áík’ehgo nṉee łą́ą́go da’osdląąd, ła’ Jews daanlíni, ła’ Greeks daanlíni. ");
INSERT INTO apwNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Áíná’ Jews doo da’odląą dahíí, doo Jews daanlįį dahíí yił daagoshkishgo odlą’ bee iłk’ííyú daanliiníí bich’į’ nchǫ’go natsídaakeesgo ádaizlaa. ");
INSERT INTO apwNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Da’áígee sikeego ńzaad ogoyaago, doo biini’ hą́h dago Bik’ehgo’ihi’ṉań yá yádaałti’ lę́’e, áík’ehgo godiyįhgo be’ígózini ła’íí ízisgo áná’ol’įįłi Paul ła’íí Bárnabas binkááyú Bik’ehgo’ihi’ṉań ánát’įįłgo biyati’ yee biłgoch’oba’íí da’aṉii at’éégo bígózįgo áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Áígee nṉee daagolííníí iłk’ékai; ła’ Jews daanliiníí yił daagost’įįd; ła’íí Paul ła’íí Bárnabas yił daagost’įįd. ");
INSERT INTO apwNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Doo Jews daanlįį dahíí ła’íí Jews daanliiníí bindaant’a’ biłgo biṉí’da’diłṉíh ła’íí nbída’iłṉe’go ndaagoshchįį, ");
INSERT INTO apwNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Áí yídaagołsįįdná’ Lýstra ła’íí Dérbe, Lycaónia biyi’ kįh nagozṉilyú ła’íí biṉaayú dahtsídinkįį. ");
INSERT INTO apwNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ákú yati’ baa gozhóni yaa nadaagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lýstra golzeegee nṉee di’ilihi sidaa lę́’e, dágozlįįná’ dasa’go doo nagháhi da: ");
INSERT INTO apwNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Áń Paul yałti’go yidits’ag: Paul da’as’ah bineł’į́į́go bi’odlą’ golį́į́go nádziihgo bígołsįįd, ");
INSERT INTO apwNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Áík’ehgo, Nádndáhgo hizįį, biłṉii. Nṉee di’ilń dáhah nádihitahgo dahiyaa. ");
INSERT INTO apwNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nṉee dała’at’ééhíí Paul adzaahíí daayiłtsąąná’ Lycaónia biyati’íí yee nádaadidilghaazhgo gádaaṉii, Daadinlziníí nohwich’į’ nken’áásh, nṉee k’ehgo nohwitahyú anát’ash. ");
INSERT INTO apwNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bárnabasń Júpiter daayiłṉii; Paulhíí, itisgo yałti’híí bighą Mercúrius daayiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kįh gozṉilíí bádngee kįh biyi’ Júpiter bich’į’ da’ch’okąąhíí goz’ąą lę́’e; áígee Júpiter bich’į’ okąąh yebik’ehń magashi ła’íí ch’il hishbizhgo alzaahíí ch’é’ítiinzhį’ ła’ádaizlaa, magashihíí natseedgo Paul ła’íí Bárnabas okąąhgo baa hi’ṉííł nzįgo, nṉee dała’adzaahíí binadzahgee. ");
INSERT INTO apwNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Áíná’ nadaal’a’á, Paul ła’íí Bárnabas, díí yaat’ídaanzįgo doo bił daanzhǫǫ dago ák’e nada’ihidzįįz nágodiidzaago, nṉee dała’at’ééhíí yitah anákeeł lę́’e, nawode gádaaṉiigo, ");
INSERT INTO apwNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Nṉee daanołíni, hat’íí lą́ą́ bighą ágádaałt’įį? Nohwíí ałdó’ nohwíí k’ehgo nṉee ndlíni ánt’ee; daazhógo ádaat’éhi bich’ą́’zhį’ ádaałṉe’ná’ Bik’ehgo’ihi’ṉań hiṉáhi daahołkąąh le’, áń yáá, ni’gosdzáń, túnteel ła’íí dawa biyi’ daagolínihíí áyíílaahi at’éé: ");
INSERT INTO apwNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Áń doo áníiná’ nṉee iłtah at’éégo hadaazt’i’i dabiini’yú nadaakeego áyíłsį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Da’ágát’éé ndi be’ígózį doleełíí dawahn nohwich’į’ ch’í’ṉah áyíłsį, nłt’éégo nohwich’į’ at’éé, nanágoltį́hgo ła’íí ná’nt’į́hgo nohwá ágółsį, ch’iyáń ła’íí iłgoyiłshóóníí bee hwoi daandlįįgo ánohwiłsį ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Áí gánṉiidgo magashi nastseedgo bee daahohiikąąh daanzį n’íí t’ąązhį’ ádaadzaa, ndi dásdozhą́ begolzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jews daanlíni Ántiochgé’ ła’íí Icóniumgé’ hikaihíí nṉee ła’ yiini’ yá ádaagozlaago Paul łeyída’isṉe’go, daztsąą lą́ą́ daanzįgo kįh gozṉil bitisyú ch’ídaideshood. ");
INSERT INTO apwNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Áíná’ ínashood biṉaayú nazįįgo, nádiidzaago kįh gozṉil yuṉe’ onanádzaa: áígé’ iskąą hik’e Dérbeyú ó’áázh, Bárnabas biłgo. ");
INSERT INTO apwNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Áí kįh gozṉilyú yati’ baa gozhóni yaa nadaagolṉi’go łą́ą́go da’osdląądná’ Lýstra, Icónium ła’íí Ántioch golzeeyú t’ąązhį’ onákai, ");
INSERT INTO apwNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ínashood nłdzilgo ádaile’go, yidag yádaałti’go, Dayúweh da’ołdląą le’, daayiłṉiigo, ła’íí, Nyé’i daadihiits’ago zhą́ Bik’ehgo’ihi’ṉań bilałtł’áhgee daanliiníí itah daahiidleeh, daayiłṉiigo ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Dáshiṉá’ da’okąąhgo ínashood ha’ánáłséhíí dawago yánazíni yá hadaihezṉilná’ Bik’ehgo’ihi’ṉań yada’ołííhíí yaa yidin’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisídia yiyi’ ch’ín’áázhná’ Pamphýliagee n’áázh. ");
INSERT INTO apwNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pérgagee Bik’ehgo’ihi’ṉań biyati’ yee yádaałti’gé’ Attália golzee yuyaa onanát’aazh. ");
INSERT INTO apwNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Áígé’ Ántiochyú t’ąązhį’ bił onada’iz’eel, áígé’ odaach’is’a’ ni’, áígé’ binasdziidíí ąął ładaizlaahíí Bik’ehgo’ihi’ṉań biłgoch’oba’íí yee baa daagodest’ąą ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ákú nakainá’ ínashood dała’adzaago hago’at’éégo Bik’ehgo’ihi’ṉań binkááyú nada’iziidíí dawa yaa yił nadaagolṉi’, ła’íí doo Jews daanlįį dahíí odląągo yá yił ch’ída’iztaaníí ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Da’áígee ínashood yił naháztąągo ńzaad godeyaa. ");
INSERT INTO apwNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ła’ nṉee Judéa golzeegé’ hikaigo odlą’ bee iłk’ííyú daanlíni yił ch’ídaago’aah, Moses yegos’aaníí bik’ehgo circumcise ádaanohwi’deszaayúgo zhą́ hasdáłkáh, daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul ła’íí Bárnabas díí yaa yádaałti’go díyat’eego yił łahada’dit’áh, áík’ehgo Paul ła’íí Bárnabas, ła’ihíí ałdó’ Jerúsalem yúdag nadaal’a’á ła’íí ínashood yánazíni díí baa nahódaidiłkidyú dołkah, daayiłṉiigo hadaizṉil. ");
INSERT INTO apwNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ínashood ha’ánáłséhíí daabides’a’go dahdiikai; doo Jews daanlįį dahíí Jesus yich’į’ dahaskaihíí yaa nadaagolṉi’go Pheníce ła’íí Samária golzeeyú ch’íkai: odlą’ bee iłk’ííyú daanliiníí dawa yaa bił daagozhǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerúsalemyú hikainá’ ínashood ha’ánáłséhíí, nadaal’a’á ła’íí ínashood yánazíni biłgo yaa hikaihíí ba’ahédaanzįgo hago’at’éégo Bik’ehgo’ihi’ṉań binkááyú nada’iziidíí dawa yaa yił nadaagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ła’ ínashood Phárisees zhiṉéégo daagot’iiníí daahizį’go gádaanṉiid, Da’aṉii círcumcise ádaal’įįgo dábik’eh, ła’íí Moses yegos’aaníí bikísk’eh ádaanołt’eego daan’ṉiigo bándaagosiit’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nadaal’a’á ła’íí ínashood yánazíni díí yaa yádaałti’híí bighą dała’adzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ńzaad godeyaago łahada’dit’áhná’ Peter hizį’go hadzii, Nṉee daanołíni, shik’ííyú, dá’ałk’iná’ yati’ baa gozhóni, Jesus baa yati’íí, shíí shinkááyú doo Jews daanlįį dahíí daidits’ago Jesus daayodląą doleełgo Bik’ehgo’ihi’ṉań nohwitahgé’ hanáshííłtį́į́ ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Bik’ehgo’ihi’ṉań daakojíí dawa yígółsini Holy Spirit nohwíí nohwaa daadest’aaníí k’ehgo bíí ałdó’ baa daadest’ąągo bił’ijóóníí yee yił ch’í’ṉah áyíłsį; ");
INSERT INTO apwNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nohwíí ła’íí bíí biłgo dáłełt’eego nohwaa natsekeesgo bi’odlą’ bee bijíí nłt’éégo ánádaisdlaa. ");
INSERT INTO apwNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Áík’ehgo hat’íí bighą nohwíí ła’íí daanohwitaa n’íí ch’éh ádaahiil’įį n’íí, Jesus daayodláni doo Jews daanlįį dahíí ładaile’go ádaałt’įįgo Bik’ehgo’ihi’ṉań nabídaanołtaa? ");
INSERT INTO apwNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Jesus Christ nohweBik’ehń dázhǫ́ biłgoch’oba’íí bee hasdáhii’ṉííłgo bíí ałdó’ da’áík’ehgo hasdákáhgo dahohiidląą. ");
INSERT INTO apwNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nṉee dała’adzaahíí dawa doo hat’íí daahiłts’ag daná’ Bárnabas ła’íí Saul yídaayésts’ąą, hago’at’éégo doo Jews daanlįį dahíí bitahyú Bik’ehgo’ihi’ṉań binkááyú godiyįhgo ánágot’įįłíí ła’íí ízisgo áná’ol’įįłíí ánáda’ol’įįł n’íí yaa nadaagolṉi’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ąął hadaasdziiná’ James hadziigo gánṉiid, Nṉee daanołíni, shik’ííyú, shídaayełts’ą́ą́: ");
INSERT INTO apwNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Símeon gáṉíí ni’, Da’iłtséná’ doo Jews daanlįį dahíí Bik’ehgo’ihi’ṉań bizhi’ yee da’okąąhgo hayiṉííł doleełhíí bighą yaa nyáá lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Dáłełt’eego Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí yaa nadaagosṉi’; díí k’ehgo k’e’eshchįį ni’, ");
INSERT INTO apwNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Díí bikédé’go nádishdaałgo David bich’ą́’gé’ hadaałishchínihíí nadaant’ángo ánádaashdle’, kįh ánágoch’idle’ łehíí k’ehgo; nagohezgo’ n’íí dawa nágodishtł’įįł, nłt’éégo nnágodish’aał: ");
INSERT INTO apwNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nṉee ła’ihíí ałdó’ Bik’ehgo’ihi’ṉań hádaabit’įį doleełhíí bighą, ła’íí doo Jews daanlįį dahíí shizhi’ bee daahojííhíí ałdó’, ṉii nohweBik’ehń, díí dawa ánát’įįłi. ");
INSERT INTO apwNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Bik’ehgo’ihi’ṉań ni’gosdzáń ágólzaagé’ yushdé’ godezt’i’go binasdziidíí yígółsį ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Áí bighą shíí díí k’ehgo shił dábik’eh, doo Jews daanlįį dahíí Bik’ehgo’ihi’ṉań bich’į’ dahnáhikáhíí doo hat’íí bighą bich’į’ nadaagontł’og bik’eh da: ");
INSERT INTO apwNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Díí zhą́ bee bich’į’ k’eda’iilchii, Beda’okąąhíí nastseedgo nadn’áí yaa hi’ṉiił n’íí doo daałsąą da, doo nant’į’ nach’ikai da, ła’íí dawahá bize’da’istł’ooníí ła’íí diłihíí ałdó’ doo daałsąą da. ");
INSERT INTO apwNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Doo áníiná’gé’ godezt’i’go kįh nagozṉilíí dawagee hadń Moses yaa nadaagolṉi’íí gólį́į́, Jews daagodnłsiníí bijįį Jews ha’ánáłséh nagoz’ąą yuṉe’ Moses binaltsoos dawahn nádaahojíí. ");
INSERT INTO apwNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nadaal’a’á, ínashood yánazíni, ła’íí ínashood ha’ánáłséhíí dawa biłgo dabíí bitahyú nṉee hádaihezṉilgo Ántiochyú Paul ła’íí Bárnabas yił daides’a’go bił dádaabik’eh; áík’ehgo Judas, Bársabbas holzéhi ła’íí Silas, ínashood bitahyú nṉee ádn nazínihíí: ");
INSERT INTO apwNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Naltsoos díí k’ehgo k’e’eshchiiníí yił odais’a’: Odlą’ bee nohwik’ííyú daandlíni, nadaal’a’á, ła’íí ínashood yánazíni biłgo, nohwíí doo Jews daanołįį dahíí, Ántiochyú, Sýriayú, Ciliciayú odlą’ bee nohwik’ííyú daanołíni, Gozhǫ́ǫ́, daanohwiłn’ṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Doo hadń ágádaabiln’ṉii da ndi, nohwich’ą́’gé’ ła’ yati’ yee nanohwinłtł’ogo, Círcumcise ádaanohwi’dilṉe’, ła’íí Jews bich’į’ begoz’aaníí yikísk’eh ádaanołt’ee, daanohwiłṉiigo nohwiini’ nadaidezgeedíí baat’ídaandzį ni’: ");
INSERT INTO apwNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Áík’ehgo dała’áhiidzaaná’ nṉee ła’ hadaahii’ṉiił, áí Paul ła’íí Bárnabas, nohwił daanzhóni, ákú bił nádaadn’aago daanohwigha nohwił dádaabik’eh. ");
INSERT INTO apwNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Díí nṉeehíí dásdozhą́ daabi’distseed, Jesus Christ nohweBik’ehń bizhi’ bee daabich’ozhiihíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Áík’ehgo Judas ła’íí Silas díí naltsoosíí bił daadel’a’, dá díí bek’e’eshchįįhíí k’ehgo dabíí nohwił nadaagodolṉih. ");
INSERT INTO apwNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Holy Spirit ła’íí nohwíí nohwił dádaabik’eh, doo nohwá nyéé dago, dá díí zhą́ bee nohwá ndaagosiit’ąą; ");
INSERT INTO apwNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Beda’okąąhíí nastseedgo nadn’áí yaa hi’ṉiił n’íí, ła’íí dił, ła’íí dawahá bize’da’istł’ooníí doo daałsąą da, doo nant’į’ nach’ikai da ałdó’: díí bich’ą́’zhį’ ádaanołt’eego nzhǫǫ. Da’áí zhą́ nohwich’į’ k’eda’shiilchįį. ");
INSERT INTO apwNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Dahdes’a’ná’ Ántioch golzee yuyaa okai: ákú hikainá’ ínashood dała’ádaizlaaná’ naltsoosíí yaa daistsooz: ");
INSERT INTO apwNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bek’e’eshchiiníí daayozhi’ná’, áí bee hadag ádaat’eehíí bighą bił daagozhǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ła’íí Silas, dabíí Bik’ehgo’ihi’ṉań binkááyú yałti’i daanlįįgo, odlą’ bee bik’ííyú łą́ą́go yich’į’ yádaałti’, ła’íí nłdzilgo bi’odlą’ goleehíí bighą yidag yádaałti’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Dét’įhézhį’ naháztąą hik’e odlą’ bee bik’ííyú nadaal’a’á bich’į’ onádais’a’, bił daagozhǫ́ǫ́go. ");
INSERT INTO apwNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Áíná’ Silas, Dákú sídáá ndizhǫǫ, nṉiid. ");
INSERT INTO apwNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paul ła’íí Bárnabas ałdó’ Ántiochyú sikee, Bik’ehgo’ihi’ṉań biyati’ yee iłch’ídaago’aahgo ła’íí yaa nadaagolṉi’go, ła’ihíí ałdó’ łą́ą́go ágádaat’įį ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Da’kwíí hiskaaníí ch’ígóyáá hik’e Paul Bárnabas gáyiłṉii, Noo’, t’ąązhį’ nádot’aash kįh gozṉil n’ííyú, Bik’ehgo’ihi’ṉań biyati’ baa nagohiilṉi’ n’ííyú, odlą’ bee nohwik’ííyú baa nanádaanotaa hagoshą’ ádaat’ee. ");
INSERT INTO apwNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bárnabasń John, da’áń Mark holzéhi, yił dikáh hát’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ndi Paulń doo yił dikáh hát’į́į́ da, dabí’iłtséná’ Pamphýliagee bich’ą́’ t’ąązhį’ ádeheltįį ni’, doo dayúweh bich’odaaṉiigo yił okai da ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Áí bighą ła’, Ch’ík’eh, ṉiiná’ ła’íí, Dah, ṉiigo yighą díyat’eego łahadit’áh, áí bighą iłk’é’áázh: Bárnabasń Mark biłgo bił oda’iz’eel, Cýprus golzeeyú; ");
INSERT INTO apwNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulń Silas hayiłtį́į́go dahn’áázh, odlą’ bee bik’ííyú, Bik’ehgo’ihi’ṉań biłgoch’oba’íí nohwił daanlįį, daabiłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Áík’ehgo Sýria golzeeyú ła’íí Cilícia golzeeyú ínashood ha’ánáłséhíí bi’odlą’ nłdzil hileehíí bighą akú ch’ín’áázh. ");
INSERT INTO apwNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Áígé’ Paul Dérbeyú nanadzaa, Lýstrayú ałdó’: áígee Jesus yodláni sidaa lę́’e, Timothy holzéhi, isdzán odláni Jew nlíni bimaa; áíná’ bitaahíí Greek nlįį: ");
INSERT INTO apwNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Áń Lýstragee ła’íí Icóniumgee odlą’ bee iłk’ííyú daanliiníí nłt’éégo baa yádaałti’. ");
INSERT INTO apwNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul Timothy yił di’aash hat’íígo círcumcise ábíílaa, bitaa Greek nlįįgo Jews ákú daagolííníí dawa yídaagołsįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kįh nagozṉilyú hikahná’ Jerúsalemgee nadaal’a’á ła’íí ínashood yánazíni begoz’aaníí bá ádaizlaahíí bek’e’eshchíni baa daistsooz, yikísk’eh ádaat’ee doleełíí. ");
INSERT INTO apwNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Áík’ehgo ínashood ha’ánáłséhíí bi’odlą’ nłdzil daasilįį, ła’íí dajįį biigha bínáhíkah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Holy Spirit, Asia biyi’ doo Bik’ehgo’ihi’ṉań biyati’ bee yádaałti’ da, biłṉiigo Phrýgia ła’íí Galátiayúgo ch’ékai. ");
INSERT INTO apwNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mýsiayú hikainá’ Bithýniayú dikáh ńt’éégo Holy Spirit doo hádaabist’įį da. ");
INSERT INTO apwNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Áík’ehgo Mýsiahíí ch’ékaigo Tróasyú hikai. ");
INSERT INTO apwNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tł’é’yú Paul bił ch’í’ṉah ágolzaa: nṉee Macedóniagee golíni sizįį; áń gábiłṉiigo nábokąąh, Yushdé’, kú Macedóniayú ńṉáhgo nohwich’onṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Bił ch’í’ṉah ágodzaaná’ dagoshch’į’ Macedóniayú nkáh daaniidzį, yati’ baa gozhóni, Jesus baa yati’íí, baa nadaagohiilṉi’go Bik’ehgo’ihi’ṉań ánohwiłṉii lą́ą́ daandzįgo. ");
INSERT INTO apwNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Áík’ehgo Tróasgé’ ts’ígozdǫh Samothráciazhį’ nohwił dahdez’eeł, iskąą hik’e Neápolisyú nohwił naada’iz’eel; ");
INSERT INTO apwNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Áígé’ Philíppizhį’ ohiikai, áí Macedónia biyi’ itisgo kįh gozṉili, Rome yebik’ehi: kú naháatąągo da’kwíí hiskąą. ");
INSERT INTO apwNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jews daagodnłsiníí bijįį túńlíni bahgee kįh gozṉilgé’ ch’ínkai, ákú náda’ch’okąąh goz’ąą; áígee dinebįhgo isdzáné nihikáhíí bich’į’ yádaahiilti’ ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Isdzán Lydia holzéhi, Thyatíragé’ gólíni, nak’ą’ łichiigo dotł’izhíí baa nahiṉiihń, Bik’ehgo’ihi’ṉań yokąąhń, nohwidezts’ąą: áń Bik’ehgo’ihi’ṉań bijíí iłch’ą́’ áyíílaago Paul áṉííhíí nłt’éégo yidezts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Áń ła’íí yił naháztaaníí biłgo baptize ádaabi’delzaaná’ nádaanohwokąąhgo gánohwiłṉii, NohweBik’ehń da’aṉii yodląągo daashidołṉiiyúgo, shigowąyú nahísółtąą. Dayúweh yushdé’ daanohwiłṉiiyú ohiikai. ");
INSERT INTO apwNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Náda’ch’okąąh goz’ąąyú hiikaahná’ it’eedn, ch’iidn biyi’ golį́į́go o’įįń, biyisnahíí zhaali yá ágole’ń nohwaa nyáá: ");
INSERT INTO apwNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Áń Paul ła’íí nohwíí nohwiké’ naghaa, dilwoshgo gáṉíígo, Díí nṉeehíí Bik’ehgo’ihi’ṉań da’tiséyú at’éhi bánada’iziidíí ádaat’ee, hago’at’éégo hasdách’igháhíí yaa nohwił nadaagolṉi’i. ");
INSERT INTO apwNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Da’ágánát’įįłgo łą́ą́go iskąą. Áí Paul yik’etsézdįįdgo t’ąązhį’ adzaago spirit nchǫ’íí gáyiłṉii, Jesus Christ bizhi’íí bee gániłdishṉii, Biyi’gé’ hanṉáh. Áík’ehgo dagoshch’į’ hayáá. ");
INSERT INTO apwNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Biyisnahíí zhaali yá ádaile’ n’íí bich’ą́’ ásdįįdgo yídaagołsįįdná’ Paul ła’íí Silas yił ndaazdeelgo na’hiṉiih goz’ąąyú nadaant’án biyahzhį’ ndaideshood, ");
INSERT INTO apwNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Áígé’ nant’ánchań daanliiníí yaa yił hikaigo gádaayiłṉii, Díí nṉeehíí, Jews daanlíni, kú nadaagontł’ogo nadaago’aa, ");
INSERT INTO apwNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bi’at’e’íí nohwíí Romans daandlíni nádaagodiit’aago doo nohwá goz’ąą dahíí yee iłch’ídaago’aah, áí bikísk’eh ádaant’eego doo nohwá goz’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Áígé’ nṉee łą́ą́go dała’adzaahíí bik’i dahishjeed; áígé’ nadaant’aahíí Paul ła’íí Silas bidiyágé baa nadaihezdzįįzná’ habída’iłtsaasgo bá ndaagoz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Aasiṉilíí nádaabinestsazná’ ha’áná’ilka’ yuṉe’ ha’ádaabisdeel, bena’igęsé nai’ṉilíí gádaayiłṉiigo, Nłt’éégo biṉádaadńł’įį: ");
INSERT INTO apwNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ágábiłṉiihíí bighą da’iłṉí’yú ha’áná’ilka’ yuṉe’ da’obiláá, bikee o’i’áń yuṉe’ odaadés’eezgo ádaabizlaago doo nahi’naa da. ");
INSERT INTO apwNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Áígé’ tł’é’ís’ahyú Paul ła’íí Silas Bik’ehgo’ihi’ṉań daayokąąhgo ła’íí ya’ahédaanzįgo da’do’aałgo ha’áshijeedíí daabidezts’ąą lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Dágosiłe ni’ godihes’naago, ha’áná’ilka’á biká’ goz’aaníí dihes’naago dagoshch’į’ dáádítį́h dawa ch’ída’ezkęęz, ła’íí bésh hishbizhíí bełídaahestł’óó n’íí k’eda’os’ṉah. ");
INSERT INTO apwNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Bena’igęsé nai’ṉilíí ch’ínádzidná’ ha’áná’ilka’á bidáádítį́híí ch’ída’astąągo yo’įįgo ha’áshijeedíí hahizkįį lą́ nzįgo bésh be’idiltłishé hayiidzį́į́zgo ídiziłdee niizįį. ");
INSERT INTO apwNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Áíná’ Paul nádidilghaazhgo gáṉíí, Íṉí’dólṉíh hela’: daanohwigha t’ah kú naháatąą. ");
INSERT INTO apwNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Bena’igęsé nai’ṉilíí, Kǫ’ shaa noł’aa, ṉiigo ha’alwod, áíná’ tsídolyizgo ditłidná’ Paul ła’íí Silas yiyahzhį’ nágo’, ");
INSERT INTO apwNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Áígé’ yił ch’ékainá’ gádaayiłṉii, Hago ashṉéhgo hasdáshidilteeh? ");
INSERT INTO apwNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Gádaabiłṉii, Jesus Christ nohweBik’ehń hondląąyúgo hasdániłteeh, ła’íí bił nahántaanihíí ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Áígee áń ła’íí yił naháztaanihíí dawa Bik’ehgo’ihi’ṉań biyati’ bee yich’į’ yádaałti’. ");
INSERT INTO apwNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Da’áí bitł’é’ biṉída’desṉihgee bá tádaizgiz; áígé’ dagoshch’į’ áń ła’íí yił naháztaaníí dawa baptize ádaabi’deszaa. ");
INSERT INTO apwNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Bigowąyú yił onákaiyú yá da’dezné’, áígé’ áń ła’íí yił naháztaaníí dawa Bik’ehgo’ihi’ṉań daayosdląądhíí bighą bił daagozhǫ́ǫ́ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Got’įį gozlįįná’ nant’án iké’gee siṉilíí aasiṉilíí akú odes’a’, Nṉeehíí ch’ínánót’aash, daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Bena’igęsé nai’ṉilíí ádaaṉiihíí Paul yił nagosṉi’ gáṉíígo, Nant’án iké’gee siṉilíí ínł’a’, ch’ínánót’aashgo: áík’ehgo ch’ínół’aashgo nohwił gozhǫ́ǫ́go nádołt’aash. ");
INSERT INTO apwNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Áíná’ Paul gábiłṉii, Nohwíí Romans ndlíni dá doo nohwaa yá’iti’é nṉee biṉááł nohwída’ashtłizh, ha’áná’ilka’ yuṉe’ ha’ádaanohwisdeel; ya’ k’adíí dánant’į’é ch’ínánohwiléé née? Dah; dabíí kú nókáhgo ch’ídaanohwinoléé. ");
INSERT INTO apwNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Aasiṉilíí díí yati’íí nant’án iké’gee siṉilíí yił nadaagosṉi’: áí Paul ła’íí Silas Romans daanliiníí yídaagołsįįdná’ ńdaaldzid. ");
INSERT INTO apwNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Áík’ehgo akú hikaigo nłt’éégo yich’į’ hanádaasdziiná’ ch’ínádaabizlaago, Kįh gozṉilgé’ ch’ínół’aash, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Áík’ehgo ha’áná’ilka’gé’ ch’ínát’aazh, áígé’ Lydia bigowąyú ó’áázh: odlą’ bee bik’ííyú daanliiníí daayo’įįná’ yidag yádaałti’ná’ onát’aazh. ");
INSERT INTO apwNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Áígé’ Amphípolisyú ła’íí Apollóniayú ch’ékainá’ Thessalonícayú nanákai, ákú Jews ha’ánáłséh goz’ąą lę́’e: ");
INSERT INTO apwNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ákóṉe’ Paul ha’ayáá, da’át’į́į́híí k’ehgo, áígee Jews daagodnłsiníí bijįį Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí yaa yáńdaaltihgo taadn godilzįh. ");
INSERT INTO apwNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Christ biniigodelzaaná’ daztsąągé’ naadiidzaahíí dábik’ehyú adzaa, daayiłṉiigo nłt’éégo ch’í’ṉah ádaayiłsįgo yaa yádaałti’; áígé’ gádaayiłṉii, Díí Jesus baa nohwił nagosṉi’ń Christ nlįį. ");
INSERT INTO apwNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Áík’ehgo ła’ da’osdląądgo Paul ła’íí Silas yíhikai; Greeks daagodnłsíni łą́ą́go, isdzáné itisyú nandeehíí doo ałch’ídé ałdó’ ádaadzaa da. ");
INSERT INTO apwNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Áíná’ Jews daanlíni da’ołch’įįdgo nṉee nchǫ’go nadaakaihíí dała’ádaizlaago nṉee áígee daagolííníí yił daagołkizh, Jason bigową ch’ída’isdzįįz, Paul ła’íí Silas nṉee dała’adzaahíí bich’į’ ch’ídaanendzood daanzįgo. ");
INSERT INTO apwNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Doo hwaa da yídaagołsįįdná’ Jasongo ła’íí odlą’ bee iłk’ííyú daanlíni ałdó’ ła’ biłgo nadaant’án bidáhzhį’ ndaineyood, daadilwoshgo gádaaṉiiná’, Díí nṉeehíí ni’gosdzáń biká’ dahot’éhé daagołkizhgo na’aash n’íí kú ń’áázhgo, ");
INSERT INTO apwNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason k’íyó’ṉíí lę́’e: nant’án ła’ihíí nlįį, Jesus holzéhi, daaṉiigo, áí dawa Caesar yegos’aaníí doo yikísk’eh ádaat’ee da. ");
INSERT INTO apwNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nṉee dała’adzaahíí ła’íí nant’án daanliiníí díí daidezts’ąąná’ doo bił dábik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jason ła’ihíí biłgo ídánada’hes’ṉilná’ nańdaabines’įįd. ");
INSERT INTO apwNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Odlą’ bee iłk’ííyú daanliiníí tł’é’yú Paul ła’íí Silas Beréayú odais’a’: ákú ń’áázhná’ Jews ha’ánáłséh goz’ąą yuṉe’ ha’a’áázh. ");
INSERT INTO apwNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jews áígee daagolíni Jews Thessalonícagee daagolíni bitisgo nłt’éégo natsídaakees lę́’e, Jesus baa na’goṉi’íí dázhǫ́ hádaat’įįgo nádaidnné’go Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí dajįį biigha yitah daadéz’įįgo daayozhíí lę́’e, Jesus baa na’goṉi’íí da’aṉii shį daanzįgo. ");
INSERT INTO apwNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Áí bighą łą́ą́go da’osdląąd; isdzáné Greeks daanlíni itisyú nandeehíí doo ałch’ídé da, nṉee ałdó’ łą́ą́go da’osdląąd. ");
INSERT INTO apwNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Áíná’ Thessalonícagé’ Jews daanlíni Beréagee Paul Bik’ehgo’ihi’ṉań biyati’ yee yałti’íí yídaagołsįįdgo, ákú náńłsą́ą́go, Beréagee daagolííníí yił daagoshkizh lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Áík’ehgo odlą’ bee iłk’ííyú daanlíni dagoshch’į’ Paul túnteel bich’į’go odais’a’: Silas ła’íí Timothy da’áígee sikeená’. ");
INSERT INTO apwNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paul yił okaihíí Áthenszhį’ yił niikai: t’ąązhį’ nádesht’aazhná’ Paul gábiłṉii, Silas ła’íí Timothy dagoshch’į’ shaa no’aash le’gá shá biłdołṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paul Áthensgee biba’ sidaaná’ beda’aszaahíí bich’į’ da’ch’okąąhíí dázhǫ́ łą́ą́go yo’įįgo biyi’siziiníí doo bił gozhǫ́ǫ́ da. ");
INSERT INTO apwNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Áík’ehgo Jews ha’ánáłséh goz’ąą yuṉe’ Jews daanlíni ła’íí nṉee daagodnłsíni yił łahada’dit’áh, ła’íí na’iṉiih nagoz’ąąyú dajįį biigha nákaahíí ałdó’ yił łahada’dit’áh. ");
INSERT INTO apwNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Igoyą’ yaa nakaihíí, ła’ Epicuréans daaholzéhi, ła’íí Stóics daaholzéhi baa hikai. Ła’ gádaaṉii, Díí bizaagolánihíí lą́ą́ hat’íí ṉiih? Ła’ihíí, Bich’į’ da’ch’okąąhíí doo bígózį dahi yaa nagolṉi’ ngonolṉíí, daaṉii, Jesus yaa nagolṉi’ ła’íí nanezna’íí naadiikáhíí yaa nagolṉi’híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Daabiłtsoodgo dahisk’id Areópagus golzeeyú yił hikai gádaayiłṉiigo, Áníidégo iłch’ígót’aahíí baa nohwił nagolṉí’. ");
INSERT INTO apwNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Hat’ííshį doo bígózį dahi baa nagolṉí’go da’nts’ag: áí bídaagonlzį hádaahiit’įį. ");
INSERT INTO apwNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Athensgee dasa’ daagolííníí ła’íí ńzaadgé’ daagolį́į́ n’íí dawa daazhógo na’goṉi’ áníidéhíí yaa nadaagolṉi’go dagohíí yídaayésts’ąągo naháztąą.) ");
INSERT INTO apwNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paul dahisk’idgé’ Mars golzeeyú sizįįgo gáṉíí, Athensgee daagonołíni, dázhǫ́ nohwił daagodiyįh lą́ą́go bígosíłsįįd. ");
INSERT INTO apwNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Hishgaałyú dawahá daahołkąąhíí daanesh’į́į́, ła’íí da’ołkąąhgee DILZINI DOO BÍGÓZÍNI BICH’Į’ golzeego k’e’eshchiiníí hish’įį ni’. Áík’ehgo daahołkąąhíí doo bídaagonołsį dahíí baa nohwił nagoshṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Bik’ehgo’ihi’ṉań ni’gosdzáń ła’íí dawahá biká’ daagolííníí áyíílaahń yaaká’yú ła’íí ni’gosdzáń biłgo yeBik’ehń nlįįgo da’ch’okąąh nagoz’aaníí nṉee áyíílaahíí doo yiyi’ golį́į́ da. ");
INSERT INTO apwNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Doo hat’íí yídn nlįį dahíí bighą dawahá nṉee ádaizlaahíí doo bee daach’okąąh da, dabíí nṉee dawa ihi’ṉaahíí, nádidzołíí ła’íí dawahá yá ágółsįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nṉee dała’á bich’ą́’gé’ nṉee iłtah at’éégo hadaazt’i’i ni’gosdzáń biká’ dahot’éhé gólį́į́go yá áyíílaa, ła’íí hazhį’ daahiṉaahíí ła’íí hayú daagolííníí yá ngon’ą́ą́; ");
INSERT INTO apwNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Bik’ehgo’ihi’ṉań yiká daadéz’įį doleełhíí bighą, baa deshaał daanzįgo, dat’éé ndi dała’á ntįįgo doo nohwich’ą́’ ńzaadyú gólíni at’éé da, ");
INSERT INTO apwNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Bee daahin’ṉaa, ła’íí bee nadaahiikai, ła’íí binkááyú daagondlįį; nohwitahgé’ biyati’ nzhónihíí ła’ gádaaṉiihíí k’ehgo, Nohwíí da’aṉii bichągháshé daandlįį. ");
INSERT INTO apwNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nohwíí Bik’ehgo’ihi’ṉań bichągháshé daandlįįgo, nṉee dábiini’ihíí yee Bik’ehgo’ihi’ṉań ádaile’, óodo dagohíí béshłigaií, tsééta bee nłt’éégo be’ilzaahíí áyíílaahíí k’ehgo doo baa natsídaahiikees da le’. ");
INSERT INTO apwNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nṉee Bik’ehgo’ihi’ṉań doo yídaagołsį daná’ binchǫ’íí doo yineł’į́į́ da ni’: ndi k’adíí Bik’ehgo’ihi’ṉań nṉee dahot’éhé gádaayiłṉiigo bá ndaagoz’ąą, Nohwinchǫ’íí bich’ą́’yúgo ádaałṉe’: ");
INSERT INTO apwNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nṉee háyiłtííníí ni’gosdzáń biká’ nṉee dábik’ehgo yaa yałti’ doleełgo ła’a jįį ngon’ą́ą́híí bighą; áí da’aṉii ágodoṉiiłíí da’áí nṉee daztsąągé’ náyihil’ṉa’íí bee nṉee dawa yígółsįgo áyíílaa. ");
INSERT INTO apwNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nanezna’íí naadiikáhíí yaa da’dezts’ąąná’ ła’ baa daadloh lę́’e; ła’íí, Baa nohwił nanagolṉí’ ndi at’éé, daaṉii lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Áík’ehgo áígé’ Paul ch’ínyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nṉee ła’ bíhikaigo da’osdląąd: Dionýsius, Areópagite nlíni, ła’íí isdzán Dámaris holzéhi, ła’ihíí biłgo ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Díí bikédé’go Paul Áthensgé’ dahnyaago Córinthgee nyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Áígee Áquila, Jew nlíni, Póntusgé’ gólíni yaa nyáá, áí bi’aad Priscílla biłgo da’áníihí Italygé’ ń’áázh, (Jews daanlíni Romegee daagolííníí, Daanohwigha ch’ínółkáh, ṉiigo Cláudius ngon’ą́ą́híí bighą,) áík’ehgo Paul yaa nyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paul ałdó’ gowągolgai ágole’íí nlįįgo yił daagolį́į́go yił nada’iziid lę́’e: (áí gowągolgai ádaile’íí daanlįį.) ");
INSERT INTO apwNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Jews daagodnłsiníí bijįį dawahn ha’ánáłséh goz’ąą yuṉe’ Paul Jews daanlíni ła’íí Greeks daanlíni yich’į’ yánádaaltihgo biini’ yá ádaagozlaa. ");
INSERT INTO apwNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas ła’íí Timothy Macedóniagé’ ń’áázhná’ Paul dá yałti’ nt’éé, Jesus, Christ nlįį, ṉiigo Jews daanlíni yil nadaagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Jews daanlíni doo hádaabit’įį dahíí bighą dénchǫ’égo bidáhzhį’ yádaałti’ná’ Paul bidiyágé yiiłháalgo gádaabiłṉii, Dáhaago ádaałdzaa lę́’eyúgo dánohwíí nadaanohwinłtł’og; shíí doo nashinłtł’og da: kodé’ godezt’i’go doo Jews daanlįį dahíí bich’į’ dahdisháh. ");
INSERT INTO apwNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Áígé’ dahnyaago nṉee Jústus holzéhi, Bik’ehgo’ihi’ṉań yokąąhń, bigowąyú óyáá; áí gowąhíí Jews ha’ánáłséh goz’aaníí dábit’ahgé’ goz’ąą lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Críspus, Jews ha’ánáłséh yinant’a’ nlíni, yił naháztaaníí dawa Jesus daayosdląąd; ła’íí Córinthgee daagolííníí Paul biyati’ daidezts’ąąná’ da’osdląądgo baptize ádaaszaa. ");
INSERT INTO apwNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Áígé’ tł’é’yú Jesus Paul bił ch’í’ṉah ágólaago gábiłṉii, Doo nénldzid da, yáńłti’, doo t’ąązhį’ áńt’éé da: ");
INSERT INTO apwNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Shíí nił nshłįįgo nṉee doo ła’ nṉi’dolṉih at’éé da: dząągee shichągháshé łą́ą́go daagolį́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Áík’ehgo áígee golį́į́go dałádn łegodzaagé’ gostáń dahitąą, nṉee bitahyú Bik’ehgo’ihi’ṉań biyati’ yee iłch’ígo’aah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Áígé’ Akéyagee Gállio nant’án nlįįná’ Jews daanlíni łedikaigo Paul yich’į’ nanakį́į́, áík’ehgo yáná’itihéyú yił hikai, ");
INSERT INTO apwNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Gádaaṉiigo, Díí nṉeehń begoz’aaníí doo yikísk’eh at’éé dago, Bik’ehgo’ihi’ṉań daayokąąhgo nṉee biini’ yá ádaagoléh. ");
INSERT INTO apwNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul k’ad hadziih nt’éégo Gállio Jews gádaayiłṉii, Nchǫ’go ánágot’įįł dagohíí nyeeyú ádzaahíí baa yádaałti’yúgo nohwíyésts’ą́ą́go dábik’eh doleeł ni’, Jews daanołíni: ");
INSERT INTO apwNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Áíná’ yati’, hizhíí ła’íí benagosoł’aaníí zhą́ baa łahada’dołt’áhíí bighąyúgo, dánohwíí nadaanohwinłtł’og; shíí díí k’ehgo ágot’eehíí doo baa yashti’ at’éé da. ");
INSERT INTO apwNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Áík’ehgo yáná’itihégé’ ch’íyineńyood. ");
INSERT INTO apwNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Greeks daanlíni dawa Sósthenes, Jews ha’ánáłséhíí yinant’a’, yił ndaazdéélgo yánáltihíí dahnándaahíí bádngee nyída’ashtłizh. Gállio ánágot’įįdíí doo yich’į’ zhiṉéé át’éé da ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Díí bikédé’go Paul da’áígee sidaago ńzaad ogoyáá, áígé’ odlą’ bee bik’ííyú daanlíni yich’ą́’ bił o’i’éél Sýriayú, Priscílla ła’íí Áquila biłgo; Cenchréagee bitsizíl yiłshéég: godnłsįgo ngon’ą́ą́ n’íí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Áígé’ Éphesusyú hikai, áígee Priscílla ła’íí Áquila sikeená’ yich’ą́’ óyáá: áíná’ bííhíí Jews ha’ánáłséh goz’ąą yuṉe’ oyáágo Jews daanlíni yich’į’ yádaałti’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Da’aṉahzhį’ síńdaa, daabiłṉiiná’, Dah, ṉiigo, ");
INSERT INTO apwNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Yich’ą́’ dahnanásdzaa, gáyiłṉiigo, Okąąhgo da’idąąyú dázhǫ́ disháh hásht’į́į́, Jerúsalemyú: Bik’ehgo’ihi’ṉań hát’ííyúgo nohwaa nádishdááł. Áík’ehgo Éphesusgé’ bił oná’í’éél. ");
INSERT INTO apwNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Caesaréayú bił na’n’éélná’ ínashood ha’ánáłséh yúdag óyáágo dét’įhézhį’ yił yádaałti’ lę́’e, áígé’ yagi Ántiochyú onanádzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Dét’įh ákú sidaa hik’e dahnaadiidzaa, łahyúgo onanádzaago Galátia ła’íí Phrýgia golzeeyú ch’ínyáá, ínashood dawa bi’odlą’ nłdzil ánádaidle’go. ");
INSERT INTO apwNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jew nlíni, Apóllos holzéhi, Alexándriayú gólíni, Éphesusyú ńyáá; dázhǫ́ nłt’éégo yałti’, Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí nłt’éégo yígółsį. ");
INSERT INTO apwNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","NohweBik’ehń bikísk’eh ch’ogaałíí nłt’éégo baa bił ch’ígot’áni; bijíí yuṉe’ diltłi’go, dawahn nohweBik’ehń yaa yałti’go iłch’ígó’aah lę́’e, John baptize ábi’delzaahíí zhą́ yígółsį ndi. ");
INSERT INTO apwNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Áń Jews ha’ánáłséh goz’ąą yuṉe’ doo biini’ hą́h dago yałti’ nkegonyaa; Priscílla ła’íí Áquila daabidezts’ąąná’ dasádnyú yił okaigo Bik’ehgo’ihi’ṉań bikísk’eh ch’ogaałíí nłt’éégo doo hidziih dago bił ch’ídaago’aah lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Akéyayú shił ido’eel nzįná’ odlą’ bee bik’ííyú daanlíni, Apóllos akú deyaa, ńdaadołteeh le’gá, daayiłṉiigo ínashood Akéyagee daagolííníí yich’į’ k’eda’ashchįį: akú ńyááná’ ínashood iłgoch’oba’íí bee da’osdląądíí nłt’éégo yich’oṉii lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Bik’ehgo’ihi’ṉań biyati’ bek’e’eshchiiníí bee Jesus, Christ nlįį, bił ch’í’ṉah ádaayiłsįgo nṉee biṉááł Jews daanliiníí yił łahada’dit’áhgo biini’ yá ádaagozlaa. ");
INSERT INTO apwNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apóllos Córinthgee sidaaná’ Paul ni’ bidazhiṉéégo ch’ínyáágo Éphesusyú ńyáá; ákú ínashood ła’ yaa nyáágo, ");
INSERT INTO apwNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Gádaayiłṉii, Ya’ Holy Spirit bee nohwaa daagost’ąą lánée da’osodląądná’? Gádaaṉii, Dah, Holy Spirit nliiníí doo hwaa baat’ídaandzį da. ");
INSERT INTO apwNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paul gáyiłṉii, Hat’ííshą’ bikísk’eh baptize ádaanohwi’deszaa lą́ą́? John iłch’ígó’aahíí bikísk’eh, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul gánádo’ṉiid, John, Nohwinchǫ’íí bich’ą́’zhį’ ádaałṉe’go baptize ádaanohwi’dolṉe’, ṉiigo nṉee baptize ádaile’ ni’, Shiké’gé’ hígháhíí, Jesus holzéhi, daahołdląą, daayiłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Díí daidezts’ąąná’ Jesus nohweBik’ehń bizhi’ bee baptize ádaabi’deszaa. ");
INSERT INTO apwNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Áígé’ Paul biká’ ndaadesṉiigo Holy Spirit bee baa daagodest’ąągo yati’ ła’i yee yádaałti’, ła’íí Bik’ehgo’ihi’ṉań binkááyú yádaałti’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nṉee nakits’ádah shį hilt’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Áígé’ Paul Jews ha’ánáłséh goz’ąą yuṉe’ onadáhgo doo biini’ hą́h dago yałti’go taagi dahitąą, Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí yaa yałti’go ła’ biini’ yá ádaagozlaa. ");
INSERT INTO apwNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Áíná’ ła’ t’ąązhį’ na’ádi’ṉilgo doo da’odląą da lę́’e, áí dała’at’ééhíí biṉááł Jesus bikísk’eh da’ch’okahíí nchǫ’go yaa yádaałti’, áí bighą Paul, ínashood biłgo, yich’ą́’ dahdikaigo, Tyránnus holzéhi bida’oltag yuṉe’ dajįį biigha iłch’į’ yánádaaltih. ");
INSERT INTO apwNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Díí k’ehgo ádaat’įįgo naki łegodzaa; áík’ehgo Asia biyi’ daagolííníí dawa, Jews daanlíni ła’íí Greeks daanlíni Jesus nohweBik’ehń biyati’ daidezts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bik’ehgo’ihi’ṉań Paul binkááyú ízisgo áná’ol’įįłíí doo hwaa hit’įį dahi ye’ánát’įįł: ");
INSERT INTO apwNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bą́ą́yo dagohíí itíl sitzoozé Paul bich’ą́’gé’ daanezgaihíí bich’į’ onádaach’iṉiił, áík’ehgo kah yaa nakaihíí nádaabi’dilziih, ła’íí nṉee spirits nchǫ’i biyi’ daagolį́į́ n’íí hahikáh. ");
INSERT INTO apwNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ła’ Jews daanlíni dá nakai nt’éhi nṉee biyi’gé’ spirits nchǫ’i hadainiyoodíí daanlíni, Jesus nohweBik’ehń bizhi’ yee ádaaṉiigo spirits nchǫ’íí hadainiyood daanzįgo gádaayiłṉii, Jesus, Paul yaa yałti’ihi, bee ná ngoni’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jews bi’okąąh yedaabik’ehi yánant’a’i, Sceva holzéhi, biye’ke gosts’idihíí ádaat’įįd lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Áíná’ spirit nchǫ’i gádaabiłṉii, Jesus bígonsį, Paul ałdó’ bígonsį; nohwíí hadń ádaałt’įį shį? ");
INSERT INTO apwNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nṉee spirit nchǫ’i biyi’ golínihíí nṉee gosts’idi yich’į’ yaahilwodgo dawa yich’į’ dahnadilwo’go yitis silįį, áík’ehgo gowągé’ dádaałichiigo biṉí’da’dezṉihgo ch’ínkį́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Éphesusgee daagolííníí, Jews daanlíni ła’íí Greeks daanlíni díí yídaagołsįįdná’ dawa tsídaadesyiz lę́’e; áík’ehgo Jesus nohweBik’ehń bizhi’ nṉee dawa daidnłsį nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nṉee łą́ą́go da’osdląądíí neheskaigo nchǫ’go ánádaat’įįł n’íí yaa nadaagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bena’ch’aahíí ye’ánádaat’įįł n’íí ła’ binaltsoos dała’ádaizlaago nṉee dawa biṉááł daidnłid: áí da’izlįįhíí daayołtag hik’e zhaali béshłigaihíí ashdladin doo náhóltagyú da’izlíni lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Áík’ehgo Bik’ehgo’ihi’ṉań biyati’ dayúweh bínágodaałgo itisgo at’éé silįį. ");
INSERT INTO apwNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Díí ánágot’įįdíí bikédé’go Holy Spirit bik’ehgo Paul Jerúsalemyú déyáágo Macedóniayú ła’íí Akéyayú ch’idishaał nzįgo gáṉíí, Ákú déyááhíí bikédé’go Romeyú ałdó’ dishaał. ");
INSERT INTO apwNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Áígé’ bich’odaaṉiihíí naki, Timótheus ła’íí Erástus Macedóniayú odes’a’; bíí Asiayú dét’įhézhį’ sidaa lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Áíná’ Jesus bikísk’eh da’ch’okąąhíí nṉee dénchǫ’go yaa hagoł’áá nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ła’ nṉee Demétrius holzéhi, béshłigaihíí yitsidi nlíni, kįh biyi’ Diána daach’okąąhíí béshłigai bee be’ilzaago áile’i, áń béshłigai daayitsidíí łą́ą́go yich’į’ nadaahi’ṉiił lę́’e; ");
INSERT INTO apwNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Áń áí nṉee ła’íí da’ágát’éégo binasdziidíí biłgo dała’áyíílaago gádaayiłṉii, Shik’isyú, díí nada’idziidíí bich’ą́’gé’ ízisgo da’iit’įįhíí bídaagonołsį. ");
INSERT INTO apwNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Díí daał’įį ła’íí daadołts’ag, Dawahá bich’į’ da’ch’okąąhíí nṉee ádaile’íí doo bich’į’ da’ch’okąąh bik’eh da, ṉiigo Paul, nṉee łą́ą́go biini’ yá ádaagozlaago nohwich’ą́’yúgo ádaadzaa, doo dá Éphesus zhą́ da, Asia biyi’ dák’azhą́ dahot’éhé ałdó’: ");
INSERT INTO apwNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Díí nohwinasdziidíí nohwich’ą́’ daayiłchǫǫ; doo áí zhą́ da, ndi Diána, isdzán bich’į’ daach’okąąhíí ízisgo at’éhi, kįh biyi’ daach’okąąhíí doo ílį́į́ da hileeh, áí Asia dahot’éhé ła’íí ni’gosdzáń biká’ nṉee dawa daabokąąh n’íí bich’ą́’gé’ ízisgo gos’ánihíí bech’ígowáh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Díí daidezts’ąąná’ díyat’eego bádaagozhchįįdgo nádaadidilghaazh, Éphesusgee daagolííníí daayokąąhíí, Diána holzéhi, ízisgo at’éhi nlíni at’éé, daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Áík’ehgo kįh gozṉilgee godikish gozlįįgo, dała’ánách’it’įįh goz’ąą yuṉe’ nádnkįį, Paul yił nakaihi Gáius ła’íí Aristárkus, Macedóniagé’ daagolíni, ákóṉe’ odaideshoodgo. ");
INSERT INTO apwNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul nṉee łą́ą́go dała’adzaahíí bitahyú digháh hát’į́į́ ndi yił nakaihíí, Dah, daabiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asiagee nant’án, Paul bit’eké daanlíni, ałdó’ bich’į’ o’ił’a’, Dała’ánách’it’įįh goz’ąą yuṉe’ doṉah hela’, daabiłṉiigo nádaabokąąh. ");
INSERT INTO apwNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nṉee ła’ kogo ádaaṉiiná’ ła’íí łahgo ádaaṉii: áígee godikish; hat’íí bighą dała’ádaach’idzaahíí ła’ doo yídaagołsįįd da lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nṉee ła’ Alexánder holzéhi, Jews daanlíni, Nohwá hadziih, daabiłṉiigo ádnyú nadaabizlǫǫs. Áń na’ígizh, nṉee yich’į’, Jews daanlíni bá yashti’ nzįgo. ");
INSERT INTO apwNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ndi Jew nlįįgo yídaagołsįįdná’ dáła’t’ohe, Éphesusgee daagolíni daayokąąhíí, Diána holzéhi, ízisgo at’éhi nlíni at’éé, daaṉiigo daadilwoshgo nakidn łedihikęęz. ");
INSERT INTO apwNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Áígé’ kįh gozṉilíí begoz’aaníí yek’e’eshchíni nṉee dała’at’ééhíí, Doo hagoł’aa da, yiłnṉiidná’ gádaayiłṉii, Éphesusgee daagonołíni, díí kįh gozṉilgee daagolííníí, Diána, ízisgo at’éhi, daayokąąhgo hadń doo yígółsį da? Ła’íí be’ilzaahíí Júpiter bich’ą́’gé’ naltǫ’íí daayokąąhgo ałdó’ hadń doo yígółsį da? ");
INSERT INTO apwNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Díí doo da’aṉii da doo hadń ṉii le’ at’éé dahíí bighą doo daagonołch’aad dago dábik’eh, doo natsí’ikees dahíí doo ádaałt’įį da. ");
INSERT INTO apwNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Díí nṉee kú daanenoyoodíí dilzįhgo nagoz’aaníí doo daiłchǫǫh da, ła’íí isdzán be’ilzaahi daahohiikąąhíí doo nchǫ’go yaa yádaałti’ da. ");
INSERT INTO apwNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Áík’ehgo Demétrius ła’íí da’itsidi yił nada’iziidíí dahadń yaa yádaałti’go hádaat’įįyúgo, yáná’itihé ch’í’otąą, ła’íí aayádaałti’íí gólį́į́, akú łaa yádaałti’ dábik’eh. ");
INSERT INTO apwNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Dayúweh ła’ hádaałt’įįyúgo nṉee yándaaltihíí iłch’į’ hilṉéh ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Díí jįį be’ánágot’įįdhíí bighą nohwaa yáda’iti’ ngolṉíí, hat’íí baa daagonch’aadihíí doo ła’ da. ");
INSERT INTO apwNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Díí yee gánṉiidná’ nṉee dała’at’ééhíí, Nádaadołkáh, yiłnṉiid. ");
INSERT INTO apwNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Godikish n’íí ąąłná’, Paul ínashood yushdé’ daayiłnṉiidná’ yinádaadezhchid, áígé’ yich’ą́’ Macedóniayú dah nadiidzaa, ");
INSERT INTO apwNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Macedónia biyi’ daagolííníí yitaaghaago yidag yádaałti’ná’ Greeceyú ńyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ákú taagi bedahitąą. Jews daanlíni benadaago’aaná’ Sýriayú bił naadez’eel nt’éégo Macedóniayúgo ch’ínánóshdáh nzį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sópater Beréagé’ gólíni, Aristárkus ła’íí Secúndus, Thessalonícagé’ daagolíni; Gáius, Dérbegé’ gólíni, ła’íí Timótheus; Tíkakus ła’íí Tróphimus, Asiagé’ daagolíni, áí dawa yił deskai. ");
INSERT INTO apwNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Áí Tróasyú okaigo áígee nohwiba’ naháztąą lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Báń benilzoołé da’ádįhgo báń alzaahi daahi’dąą ni’, áígé’ Philíppigé’ Tróaszhį’ ashdla’i nohwee daizkąą nohwił dah’o’ołgo; áígee naháatąągo gosts’idi nohwee daizkąą. ");
INSERT INTO apwNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Godilziníí bijįį ínashood da’okąąhgo da’iyąągo dała’adzaaná’ Paul iskąą dahnádishdáh nzįgo dá yił yádaałti’go tł’é’ís’ah. ");
INSERT INTO apwNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Dá’ík’ehyú dahnágost’ąąyú dała’adzaa yuṉe’ ik’ah kǫ’i łą́ą́go daadiltłi’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ákú nṉee áníi nagháhi Éútikus holzéhi biká’got’íné daadentą́ą́gee dahsdaago iiłhaazh: Paul dá yałti’ nt’éégo nṉeehíí gódah ch’ínenlóól, áí taagi nágost’ąągé’ lę́’e, áígé’ daztsąągo nádainłtįį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Áík’ehgo Paul gódah ch’ínyáágo hayaa adzaago yinazhchidná’ gáṉíí, Doo hago nohwił ádaagot’ee da le’; t’ah hiṉaa. ");
INSERT INTO apwNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Paul wą́’yúdag onádzaaná’ báń yehesdlaadgo da’iyą́ą́, áígé’ yił iłch’į’ yánádaalti’go ńzaad ogoyáá gost’įįdzhį’, áígé’ yich’ą́’ dahnadiidzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nṉee áníi nagháhá gódah ch’ínenlóól n’íí hiṉaago yił onákai, dázhǫ́ bił daagozhǫ́ǫ́go. ");
INSERT INTO apwNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paul dabí’iłtsé tsina’eełíí si’ąąyú nkaigé’ Ássosyú nohwił da’des’eel, ákú nkaigo Paul tsina’eełíí yiyi’ dahndáah doleeł, daandzįgo: Paul dáni’ ákú higháhgo ngonłchį́į́híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ássosgee nohwaa nyááná’ tsina’eełíí yeh hiyáágo Mityléneyú bił nohwił da’iz’eel. ");
INSERT INTO apwNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Áígé’ nohwił dahna’iz’eelgo iskąą hik’e Chíos ba’ashhahyú nohwił ch’ída’iz’eel; áígé’ iskąą hik’e Sámosyú nohwił nada’iz’eel, áígé’ Trogýlliumgee dét’įh naháatąą; iskąą hik’e Milétusyú nohwił nada’iz’eel. ");
INSERT INTO apwNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul Asiahíí biyi’ doo ńzaad begodigháh dahíí bighą Éphesus bitis bił ch’ída’i’eełgo ngon’ą́ą́: dábik’ehyúgo Péntecost‐híí bijįį Jerúsalemyú dáhah hįkáhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Paul Milétusyú sidaago Éphesusyú ínashood yánazíni, Kú nółkáh, daabiłṉiigo o’ił’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ákú hikainá’ gádaayiłṉii, Da’iłtsé Asiagee níyáágé’ godezt’i’go dawahn hago’at’éégo nohwitahyú gonshłįį n’íí bídaagonołsį, ");
INSERT INTO apwNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Dá shaa goch’oba’go, łahgee shiṉáá túnálį́į́ná’ Jews daanlíni shenadaago’aahíí bee shich’į’ nagontł’ogo Bik’ehgo’ihi’ṉań bá na’isiid ni’: ");
INSERT INTO apwNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Dawahá nohwá nzhooníí doo ła’ t’ąązhį’ ánsį dago baa nohwił nadaagoshṉi’go nohwił ch’í’ṉah ashłaa ni’, dała’ánádaałt’įįyú ła’íí daagotahyú, ");
INSERT INTO apwNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Jews ła’íí Greeks daanlíni, Nohwinchǫ’íí bich’ą́’zhį’go ádaałṉe’ná’ Bik’ehgo’ihi’ṉań bich’į’go ádaałṉéh, ła’íí Jesus Christ nohweBik’ehń daahołdląągo bada’ołį́į́, dishṉiigo baa bił nadaagoshṉi’ n’íí ałdó’ bídaagonołsį. ");
INSERT INTO apwNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Áík’ehgo k’adíí Holy Spirit nashihiłnaa’go Jerúsalemyú nádésdzá, ákú shidáhyú goz’ąą doleełíí doo bígonsį da: ");
INSERT INTO apwNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ndihíí ha’ánshteeh ła’íí shiniigonłt’éé doleełíí shiba’ goz’ąągo Holy Spirit shił nanágolṉih, kįh nagozṉilyú nashaayú. ");
INSERT INTO apwNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Áíná’ áí doo shił hago’at’éé da, shi’ihi’ṉa’íí doo shił ilį́į́ da, shił gozhǫ́ǫ́go shinasdziid łashłé zhą́ hásht’į́į́, ła’íí yati’ Jesus nohweBik’ehń shaa yiné’íí Bik’ehgo’ihi’ṉań bił goch’oba’íí nłt’éégo baa na’goṉi’íí ąął baa nagoshṉi’go hasht’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nohwíí nohwitahyú Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí baa nagoshṉi’go nashaa n’íí doo nádaashołtséh dahíí bígonsį. ");
INSERT INTO apwNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Áík’ehgo díí jįį gádaanohwiłdishṉii, Doo da’dołts’ag daná’, ch’a’onesołdeeyúgo doo hat’íí nashinołtł’og da. ");
INSERT INTO apwNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Doo ła’ t’ąązhį’ ánsį dago Bik’ehgo’ihi’ṉań nohwá ngon’ááníí dawa baa nohwił nadaagosisṉi’híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ádaa daagonołdząą, ła’íí ínashood dawa bá daagonołsąą, Bik’ehgo’ihi’ṉań daayokąąhgo ha’ánáłséhíí dabíí bidił yee yist’įįdíí Bik’ehgo’ihi’ṉań bá da’dołné’; áí biṉádaadeł’į́į́go Holy Spirit ádaanohwizlaa. ");
INSERT INTO apwNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Díí bígonsį, nohwich’ą́’ dahdiyaahíí bikédé’go nṉee ba’cho bégodzidi ga’ádaat’éhi nohwitahyú híkáhgo ínashood ndi k’izédaidihiṉiił doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nohwíí nohwitahyú ndi nṉee ła’ yati’ doo da’aṉii dahíí yee yádaałti’ nkegoniigháh, ínashood daanlíni bich’ą́’zhį’ yaa da’ṉiigo, bíígo bikísk’eh dahikáh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Áí bighą ádaa daagonołdząą, tł’é’ biigha ła’íí jįį biigha dá godezt’i’ nt’éégo taagi łegodzaazhį’ shiṉáá túnálį́į́ná’ dała’á nołtįįgo nohwił ch’ígonsh’aah n’íí bínádaałṉiih. ");
INSERT INTO apwNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","K’adíí, shik’ííyú, Bik’ehgo’ihi’ṉań ła’íí biyati’ biłgoch’oba’íí baa nohwinshṉiił, áí yati’íí daanołdzilgo ádaanohwile’, ła’íí Bik’ehgo’ihi’ṉań báhadaadeszaahíí bitahyú nohwíyéé doleełíí nohwaa yiné’go yínel’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Béshłigaihíí, óodo, dagohíí diyágé ła’ daabíyééhíí doo ádá hásht’į́į́ da. ");
INSERT INTO apwNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nohwíí bídaagonołsį, dashíí ídee hinsh’ṉaa ni’, ła’íí bił nashkaihíí dawahá bá ádaagonsį ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Díí k’ehgo nada’ołsiidgo doo daanłdzil dahíí bich’odaałṉiigo dábik’eh nohwił ch’í’ṉah ashłaa, ła’íí Jesus nohweBik’ehń gáṉíí n’íí bínádaałṉiihgo nohwił ch’ígonsh’aah ni’, Dahadń hat’íí kaa yiné’yúgo áí doo dá baa gozhǫ́ǫ́ da, áíná’ dahadń hat’íí baa ch’iné’yúgo, áí zhą́ itisgo baa gozhǫ́ǫ́. ");
INSERT INTO apwNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Díí ąął yee yałti’ná’ hilzhiizhgo dawa yił da’oskąąd. ");
INSERT INTO apwNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Dawa daachagná’ Paul yinádaazhchidgo daazts’ǫs, ");
INSERT INTO apwNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Doo nádaashołtséh da, ṉiihíí bighą itisgo doo bił daagozhǫ́ǫ́ da. Áígé’ tsina’eełíí si’ąąyú yił nakai lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Áígé’ bich’ą́’ nohwił da’iz’eelná’ Cóos golzeezhį’ ts’ígozdǫh nohwił oda’iz’eel, iskąą hik’e Rhodes golzeezhį’, áígé’ Pátara golzeezhį’: ");
INSERT INTO apwNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Phenécia tsina’eełíí dez’íli lą́ą́ baa nkaigo beh hiikaigo nohwił dahna’iz’eel. ");
INSERT INTO apwNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Áígé’ Cýprus golzeehíí nohwe’eshganzhiṉéégo hit’įį silįįná’ nohwił ch’ída’iz’eel Sýriazhį’, Tyregee nohwił nda’iz’eel: áígee tsina’eełíí yogheełíí nahi’ṉiiłhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ínashood baa nkaigo áígee gosts’idi nohwee da’izkąą: áí Holy Spirit yádaabihiłti’go Paul, Jerúsalemyú doṉáh hela’, daabiłṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Gosts’idihíí ąął nohwee nyíńłką́ą́ná’ dahnádihiikai; ínashood dawa bi’aad ła’íí bichągháshé biłgo kįh gozṉilíí bich’ą́’zhį’ bił ch’ínkai: ákú tábąąyú daahihiilzhiizhná’ da’osiikąąd. ");
INSERT INTO apwNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Bik’ehgo’ihi’ṉań nohwił daanlįį doleeł, daałiłn’ṉiiná’ tsina’eełíí beh hiikainá’ bííhíí gowąyú onákai. ");
INSERT INTO apwNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tyregé’ Ptolemáiszhį’ nohwił da’iz’eel, áígee odlą’ bee nohwik’ííyú bił iłch’į’ yádaahiilti’go dała’á jįį bił naháatąą. ");
INSERT INTO apwNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Iskąą hik’e Paul bił nahiikaihíí Caesaréazhį’ nohwił onáda’iz’eel; áígee Philip, Jesus yá nagolṉi’i, gosts’idi ha’ṉilíí itah nlíni; bigową yuṉe’ ohiikaigo bił naháatąą. ");
INSERT INTO apwNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Bitsi’ke doo ndaaṉee dahíí dį́į́’i, áí Bik’ehgo’ihi’ṉań binkááyú yádaałti’ lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Áígee naháatąągo dá’aṉah godeyaago Bik’ehgo’ihi’ṉań binkááyú yałti’i, Ágabus holzéhi, Judéagé’ ńyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nohwaa nyáágo Paul biziz náidnlaago dabíí bikee ła’íí bigan łíyistł’ǫǫná’ gánṉiid, Holy Spirit gáṉíí, Jerúsalemgee Jews daanlíni nṉee díí sis bíyééhíí díí k’ehgo łídaabiłtł’ohgo doo Jews daanlįį dahíí yaa daabiłtéeh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Díí da’disiits’ąąná’ nohwíí ła’íí nṉee áígee daagolííníí biłgo Paul, Jerúsalem yúdag doṉáh hela’, daabiłn’ṉiigo nádaahohiikąąh. ");
INSERT INTO apwNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Paul gánṉiid, Hat’íí bighą daałchago shijíí nṉiihgo ádaanołsį? Shíí Jesus nohweBik’ehń bizhi’híí bighą Jerúsalemyú ha’ánshteeh, ła’íí dastsaahgo ndi shił dábik’eh. ");
INSERT INTO apwNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ch’éh ádaałn’ṉii hik’e gádaade’ṉiid, NohweBik’ehń hát’ííníí bikísk’ehyú ágodoṉiił. ");
INSERT INTO apwNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Díí bikédé’go iłch’į’da’siidlaago Jerúsalem yúdag ohiikai. ");
INSERT INTO apwNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ínashood ła’ Caesaréagé’ daagolíni bił ohiikai, áí Mnáson, Cýprusgé’ gólíni, doo áníiná’ ínashood silíni, bigowąyú bił nkai, áń bił naháatąą. ");
INSERT INTO apwNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Áígé’ Jerúsalemyú nkainá’ odlą’ bee nohwik’isyú baa nkaihíí bighą nohwa’ahédaanzįį’. ");
INSERT INTO apwNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Iskąą hik’e Paul bił ha’áhiikai James bich’į’; áígee ínashood yánazíni dała’adzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Iłch’į’ yádaałti’ná’ Paul binkááyú doo Jews daanlįį dahíí bitahyú Bik’ehgo’ihi’ṉań hat’íí áyíílaahíí dała’ágo iłké’ gon’ą́ą́go yaa yił nadaagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Díí daidezts’ąąná’, NohweBik’ehń ízisgo at’éhi nlįį, daaṉii, áígé’ Paul gádaayiłnṉiid, Isąą, nohwik’isn, Jews daanlíni bitahgé’ łą́ą́go doo náhóltagyú da’osdląąd; áí dawa Jews bich’į’ begoz’aaníí dázhǫ́ nłt’éégo yikísk’eh ádaat’ee: ");
INSERT INTO apwNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Áíná’ naat’ídaanzį, Jews daanlíni doo Jews daanlįį dahíí bitahyú daagolínihíí, Moses nohwił ch’ídaagos’aaníí yó’odaadoł’aago nohwichągháshé doo círcumcise ádaał’įį da, ła’íí nohwi’at’e’ doo bikísk’eh ádaanołt’ee da, biłńṉiigo bił ch’ídaagon’áah, nídaagołsįįd. ");
INSERT INTO apwNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Hago’at’éégoshą’ ádaahii’ṉe’? Nṉee łą́ą́go dała’aṉe’ doleeł: kú ńyaahíí yaat’ídaanizįįh go’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Áí bighą ádaaniłn’ṉiihíí k’ehgo ánṉe’: nohwitahyú nṉee dį́į́’i godnłsiníí yich’į’ hadaagodile’go ndaagoz’ąą lę́’e; ");
INSERT INTO apwNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ni ałdó’ godínłsįgo bił iłch’į’da’dołdlé’go bił nkáhgo ákú bá nadahíńṉił, bitsits’in łigaigo daiłshéhíí bighą: díí bee nṉee dawa bich’į’ bígózį doleeł, naat’ídaanzį n’íí doo da’aṉii da, ndi begoz’aaníí bikísk’eh áńt’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Áíná’ doo Jews daanlįį dahíí da’osdląądíí bich’į’ naltsoos ádaasiidlaa gádaan’ṉiigo, Ágádaat’eehíí doo be’ádaanołt’ee da nzhǫǫ, áíná’ beda’okąąhíí nastseedgo nadn’áí yaa hi’ṉiiłíí, ła’íí dił, ła’íí dawahá bize’da’istł’ooníí doo daałsąą da, doo nant’į’ nach’ikai da ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Áík’ehgo Paul nṉee dį́į́’ihíí yił okaigo iskąą hik’e godnłsįgo yił iłch’į’áda’desdlaaná’ da’ch’okąąh goz’ąą yuṉe’ yił okai, godnłsįgo iłch’į’ádaach’idle’ ąął bengowáhíí bebígozįįhíí bighą, ła’íí dała’á ntį́į́go dahat’íhíta Bik’ehgo’ihi’ṉań bá baa hi’né’híí ałdó’ bebígozįįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Gosts’idiskaaníí k’azhą́ ąął bengowáhná’ Jews Asiagé’ daagolííníí da’ch’okąąh goz’ąą yuṉe’ Paul daayiłtsąąná’ nṉee dawa yił daagoshkishgo Paul yił ndaazdeelgo, ");
INSERT INTO apwNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Nádaadidilghaazhná’ gádaanṉiid, Israel hat’i’i daanołíni, nohwich’odaałṉii: Díń nṉeehń nṉee dahot’éhé yił ch’ígó’aah ánágoldoh, Israel hat’i’i ła’íí begoz’aaníí ła’íí díí goz’aaníí bich’ą́’yúgo ádaanołt’ee, daayiłṉiigo: dayúwehyú Greeks daanlíni ałdó’ da’ch’okąąh goz’ąą yuṉe’ yił okaigo díí godiyįhgo goz’aaníí daayiłchǫǫd. ");
INSERT INTO apwNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Dabí’iłtséná’ kįh gozṉilyú Tróphimus, Éphesusgé’ gólíni, yił na’aashgo daabo’įį ni’go, áń Paul da’ch’okąąh goz’ąą yuṉe’ yił o’áázh daanzįį ni’.) ");
INSERT INTO apwNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kįh gozṉilgee nṉee daagolíni dawa godikish nagodiidzaa ni’, áígé’ iłch’į’ nádnkįįgo dała’adzaa ni’: áígé’ Paul yił ndaazdeelgo da’ch’okąąh goz’ąągé’ ch’ídaabist’e’ná’ ch’íná’itį́híí dagoshch’į’ daada’deztąą ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Daabiziłhee nkegonyaaná’ silááda binant’a’ Jerúsalem dahot’éhé godikish gozlį́į́go yaat’ínzį: ");
INSERT INTO apwNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Áík’ehgo dagoshch’į’ silááda ła’íí binadaant’a’ biłgo nṉee dała’adzaahíí yich’į’ gódah ch’ínkį́į́: áí nṉee daayiłtsąąná’ Paul nyída’iz‐haal n’íí dákehégo ádaisįįd. ");
INSERT INTO apwNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Áígé’ silááda binant’a’íí Paul yaa nyáágo biłtsoodgo, Bésh hishbizhíí naki bee łíbi’doltł’óh, ṉii; áígé’, Hadń át’į́į́, hat’íí hago áyíílaa? ṉiigo yiká na’ódíłkid. ");
INSERT INTO apwNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nṉee dała’at’ééhíí ła’ kogo ádaaṉiiná’ ła’íí łahgo ádaaṉii: áík’ehgo godńch’aadhíí bighą ch’éh yígołsįįhgo at’į́į́go, Silááda siṉilyú bił dołkáh, nṉiid. ");
INSERT INTO apwNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Gódah ch’í’itiinzhį’ nyááná’ nṉee łą́ą́go dała’at’ééhíí hadaashkeehíí bighą silááda dahdaabinłtįį. ");
INSERT INTO apwNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nṉee dała’at’ééhíí daadilwoshgo biké’ náłseeł, Daazołhee, daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Paul k’ad silááda siṉil yuṉe’ yił ha’akáhná’ silááda binant’a’íí gáyiłṉii, Nich’į’ hasdziih née? Silááda binant’a’íí gáṉíí, Greek biyati’ bee yáńłti’ née? ");
INSERT INTO apwNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ni Egyptgé’ nṉee ńlíni née, da’iłk’ehéná’ nṉee godikishgo dį́į́dn doo náhóltagyú nada’iłtseedíí da’igozlįįyú oyiṉil n’íí ni née? ");
INSERT INTO apwNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paul gáṉíí, Shíí Jew nshłįį, Cilícia biyi’ ízisgo kįh gozṉilíí Társus golzeegé’ gonshłíni: nánoshkąąh, ch’ík’eh nṉee bich’į’ hasdziih. ");
INSERT INTO apwNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Silááda binant’a’, Ch’ík’eh hadziih, yiłnṉiidná’ Paul gódah ch’í’itiingé’ dahsizįįgo nṉee dała’at’ééhíí yich’į’ na’ígizh. Doo hat’íí náhists’ąą daná’ Hebrew biyati’ bee yich’į’ yałti’ nkegonyaa. ");
INSERT INTO apwNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Nṉee daanołíni, shik’ííyú, ła’íí nibáyáń daanołíni, nohwiṉááł ádá hasdziihíí ídaayesółts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","(Hebrew biyati’íí yee hadziigo da’dezts’ąąná’ dayúwehégo doo hat’íí náhists’ąą da: Paul gánṉiid,) ");
INSERT INTO apwNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Shíí Jew nshłįį, Cilícia biyi’ kįh gozṉilíí Társus golzeegee gosilį́į́, ndi dząągee díí kįh gozṉilgee shi’dihiilṉa’, begoz’aaníí daanohwitaa yikísk’eh ádaat’ee n’íí Gamáliel holzéhi shił ch’ígon’ą́ą́, nohwíí ádaanołt’eehíí k’ehgo nłdzilgo Bik’ehgo’ihi’ṉań bá sízį́į́ ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nṉee ła’íí isdzáné Jesus yikísk’eh daayikahíí łídaashtł’o’go ha’áná’ilka’á yuṉe’ odaahiskaad ni’, biniigonłt’éégo ádaansį, dak’azhą́ hishhąągo. ");
INSERT INTO apwNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Díí ánát’įįdíí okąąh yebik’ehi da’tiséyú sitíni ła’íí nṉee yándaaltihíí shídaagołsį: áí bik’isyú daanlíni, Damáscusyú daagolínihíí, bá naltsoos shaa daizṉil, áík’ehgo ákú níyáá, Jesus yikísk’eh daayikahíí áígee daagolííníí łídaashtł’o’go Jerúsalemyú bił nshkáh, biniidaagodilṉe’ doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Damáscusyú dak’azhą́ nsháhgo ha’iz’ąąyú shį, dahį́ko yaaká’gé’ shich’į’ nke’idindláád. ");
INSERT INTO apwNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Áígee hayaa nago’ná’ yati’ gáshiłṉiigo idisiits’ą́ą́, Saul, Saul, hat’íí lą́ą́ bighą shiniigonłt’éégo áshińłsį? ");
INSERT INTO apwNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Áík’ehgo gádéṉiid, Hadń ánt’įį, shiNant’a’? Gánáshiłdo’ṉiid, Shiniigonłt’éégo áshińłsinihíí shíí ásht’į́į́, Jesus, Názarethgé’ gonshłíni. ");
INSERT INTO apwNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bił hishkaahíí ałdó’ nke’dindláádíí daayiłtsąą ndi izhii shich’į’ yałti’íí doo daidezts’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Áík’ehgo gádéṉiid, Hago lą́ą́ áshṉe’, sheBik’ehń? Jesus gáshiłnṉiid, Nádndáhgo Damáscusyú ńṉáh; ákú hat’íí ánléhíí ąął baa nił na’goṉi’ ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Dázhǫ́ łigaigo nke’idindláádhíí bighą doo gosh’įį da silį́į́go bił hishkaahíí Damáscusyú odaashizlǫǫz. ");
INSERT INTO apwNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ła’ nṉee Ananías holzéhi, begoz’aaníí yikísk’eh nlįįgo Bik’ehgo’ihi’ṉań yidnłsíni, Jews áígee daagolííníí dawa nłt’éégo baa yádaałti’i, ");
INSERT INTO apwNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Áń shaa nyáágo shit’ahgee hizį’go gáshiłnṉiid, Shik’isn Saul, go’įį nándleeh. Áík’ehgo dagoshch’į’ gosh’įį násisdlįįgo Ananías yiłtsąą. ");
INSERT INTO apwNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Gánáshiłdo’ṉiid, Bik’ehgo’ihi’ṉań, nohwitaa n’íí daayokąąhń, hat’ííníí bígonsį doleełgo hanitį́į́, Nłt’éégo Anát’įįłíí hįłtséhgo, ła’íí bizhiihíí dints’į́hgo. ");
INSERT INTO apwNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Hat’íí hí’ííníí ła’íí hat’íí dints’agíí nṉee dawa áń bá baa bił nagolṉí’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Áík’ehgo hat’íí biba’ síńdaa? Nádndáhgo nohweBik’ehń bizhi’ bee bich’į’ ánṉiigo baptize áni’dolṉéh, áík’ehgo ninchǫ’íí yó’o’eeł. ");
INSERT INTO apwNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Jerúsalemyú nánsdzaaná’ da’ch’okąąh goz’ąą yuṉe’ oshkąąh nt’éégo shił ch’í’ṉah ágolzaago, ");
INSERT INTO apwNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Gáshiłṉiigo hiłtsąą, Dahałe, Jerúsalemgé’ dagoshch’į’ ch’íńṉáh: shaa bił nadaagolṉi’íí doo hádaat’įį da doleełhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Áík’ehgo gádéṉiid, SheBik’ehń, Jews ha’ánáłséh nagoz’ąą dahot’éhé daanodlaaníí ha’áná’ilka’á baa hiṉíl, ła’íí nbída’niłhaał n’íí dabíí yídaagołsį: ");
INSERT INTO apwNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ła’íí Stephen, ná nagolṉi’íí nlíni, bidił idezjoolná’ bit’ahgé’ sízį́į́go shił dábik’eh ni’, hayíí daabizis‐hiinihíí iká’ daabi’ííhíí bá biṉádésh’į́į́ ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Áígé’ gánáshiłdo’ṉiid, Dahnṉáh: ńzaadyú doo Jews daanlįį dahíí bich’į’ nideł’a’. ");
INSERT INTO apwNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nṉee dała’adzaahíí bídaayésts’ąą lę́’e, ndi díí yee ánṉiidná’ nádaadidilghaazhgo gádaanṉiid, Yúwehyú, daazołhee: nṉee ga’at’éhihíí ni’gosdzáń biká’ doo hiṉaa bik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nádaadidilghaazhgo iká’ daabi’ííhíí dahnadai’ah, ła’íí łeezh hadag daiki’, ");
INSERT INTO apwNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Áík’ehgo silááda binant’a’ da’tiséyú sitíni, Silááda siṉilyú bił nołkáh, biłnṉiid, ła’íí habída’ołhaałgo nahódaadołkid, hat’íí bighą baa daadilwoshíí bígonozį́įh. ");
INSERT INTO apwNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Áíná’ łídaabistł’ǫǫná’ Paul silááda dała’á gonenadín binant’a’i bit’ahgee siziiníí gáyiłnṉiid, Nṉee Roman nlíni doo baa yá’iti’í habí’į́łhaałgo ná goz’ąą née? ");
INSERT INTO apwNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Silááda binant’a’i díí yidezts’ąąná’ silááda binant’a’ da’tiséyú sitíni yich’į’ oyáágo gáyiłṉii, Hago ánṉe’go láń? díń nṉeehń Roman nlíni ląą. ");
INSERT INTO apwNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Áík’ehgo silááda binant’a’íí Paul yaa nyáágo gáyiłṉii, Shił nagolṉí’, ya’ Roman ńlį́į́ née? Paul gáṉíí, Ha’aa. ");
INSERT INTO apwNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Silááda binant’a’i gánádo’ṉiid, Roman nshłiiníí łą́ą́go bighą nahaṉílhi at’éé. Paul gáṉíí, Shíí dá Roman nshłįįgo gosilíni ánsht’ee. ");
INSERT INTO apwNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Áík’ehgo k’ad nabídaadiłkid n’íí bich’ą́’ nádnkįį: ła’íí silááda binant’a’i ałdó’, Paul łíhistł’ooníí, Roman nlįįgo yígołsįįdhíí bighą tsídolyiz. ");
INSERT INTO apwNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Iskąą hik’e silááda binant’a’i hat’íí bighą Jews daanlíni baa dahdaagoz’aaníí da’aṉii yígołsįįh hat’į́į́go, k’ena’bí’ahná’ okąąh yedaabik’ehi itisyú nadaandeehi ła’íí yándaaltihi, Dała’ ałṉéh, daayiłnṉiid, áík’ehgo Paul yił gódah ch’i’áázhgo yándaaltihíí biyahzhį’ yił nn’áázh. ");
INSERT INTO apwNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul yándaaltihíí da’as’ah yineł’įįdná’ gáṉíí, Nṉee daanołíni, shik’isyú, díí jįįzhį’ ngont’i’go Bik’ehgo’ihi’ṉań shineł’į́į́go nłt’éégo ánásht’įįł bígonsįgo hinshṉaa. ");
INSERT INTO apwNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Okąąh yebik’ehi da’tiséyú sitíni, Ananías holzéhi, bit’ahgee naziiníí, Bizadaałts’į, daayiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Áík’ehgo Paul gábiłṉii, Dá’iká’gee zhą́ łigaigo ánálzaahi ńlíni, Bik’ehgo’ihi’ṉań nił hayaa nałts’į go’į́į́: begoz’aaníí bee shaa yáńłti’go dahsíńdaa née, áíná’ begoz’aaníí doo bikísk’eh áńt’éé dago nik’ehgo shi’dolts’į? ");
INSERT INTO apwNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bit’ahgee naziiníí gádaabiłṉii, Bik’ehgo’ihi’ṉań bi’okąąh yebik’ehi da’tiséyú sitíni nchǫ’go baa yáńłti’ née? ");
INSERT INTO apwNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul gánádo’ṉiid, Shik’isyú, okąąh yebik’ehi da’tiséyú sitíni nlįį lą́áhíí doo bígonsį da ni’: nohwíí nohwihat’i’i binant’a’ doo nchǫ’go baa yádaałti’ da le’, ṉiigo bek’e’eshchįį. ");
INSERT INTO apwNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nṉee ła’ Sádducees daanlįįgo ła’íí Phárisees daanlįįgo Paul yígolsįįdná’, yándaaltihíí yich’į’ gáṉíí, Nṉee daanołíni, shik’isyú, shíí Phárisee nshłįį, Phárisee nlíni biye’ nshłįį: nanezna’íí naadiikáh hoshdląąhíí bighą shaa yá’iti’. ");
INSERT INTO apwNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Díí ánṉiidná’ Phárisees daanliiníí ła’íí Sádducees daanliiníí łahada’dit’áh nkegonyaa: áík’ehgo nṉee dała’at’ééhíí nakiyú iłk’ékai. ");
INSERT INTO apwNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sádducees, Nanezna’íí doo naadiikáh da, Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi dagohíí spirit ta doo ła’ golį́į́ da, daaṉii: áíná’ Phárisees daanlínihíí, Áí gólį́į́, daaṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Áík’ehgo nawode hagołdog: begoz’aaníí ye’ik’eda’ałchíhi Phárisees yił daagot’iiníí daahizį’go gádaaṉii, Díń nṉeehń doo hat’íí nchǫ’íí ye’adzaa dago bídaagosiilzįįd: spirit dagohíí Bik’ehgo’ihi’ṉań binal’a’á yaaká’gé’hi bich’į’ yałti’ lę́’eyúgo, doo Bik’ehgo’ihi’ṉań bich’į’ nadaagonlkaad da ndizhǫǫ. ");
INSERT INTO apwNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Łahada’dit’áh n’íí hagowáh nkegonyaaná’ silááda binant’a’ Paul dánko iłk’ídaach’idzįįs he’at’éé nzįgo, silááda, Ákú dołkáhgo baa hadaanołteehgo nołjahyú bił nádołkáh, daayiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Iskąą tł’é’ hik’e Jesus Paul bit’ahgee sizįįná’ gáṉíí, Paul, bidag áńt’éé: Jerúsalemyú shaa nagosíńṉi’híí k’ehgo Romeyú ałdó’ shá nagolṉí’ doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Jįį gozlįįná’ Jews daanliiníí ła’ ndaagoshchįįgo, Paul daayizes‐hįįzhį’ doo da’iyąągo, doo da’idląągo ádándaagost’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ndaagoshchiiníí dizdin bitisyú hilt’ee lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Okąąh yedaabik’ehi itisyú nadaandeehi ła’íí Jews yánazíni yich’į’ okaigo gádaayiłṉii, Nłdzilgo ádándaagosiit’ąą, Paul daazeldįįzhį’ doo da’iidąą dago. ");
INSERT INTO apwNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Áík’ehgo nohwíí ła’íí yándaaltihíí biłgo silááda binant’a’i bich’į’ ch’iṉii daadoł’aah nohwaa yił nołkáhgo, dayúweh na’ídaadołkid k’a’at’éégo: nohwíí ałk’iná’ biba’ naháatąą, daazildeego dénohwit’ah dahiyaago. ");
INSERT INTO apwNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Paul daaziłheego yiba’ naháztaaníí Paul bilah bizhaazhé yaat’ínzįįná’ Paul silááda siṉilyú yich’į’ oyáágo yił nagosṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Áík’ehgo Paul silááda dała’á gonenadín binant’a’ ła’ yushdé’ yiłṉiigo gáyiłṉii, Díń nṉee áníi naghahń silááda binant’a’ da’tiséyú sitíni bich’į’ bił n’áásh: yił nagolṉi’ hat’į́į́híí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Silááda binant’a’ yaa yił n’aazhná’ gáṉíí, Paul, ha’ásitíni yushdé’ shiłnṉiidgo, Díń nṉee áníi naghahń hat’íí shį niłdishṉii niłṉiigo bich’į’ bił n’áash, shiłṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Áík’ehgo silááda binant’a’ dasahn nabídiłkid yuṉe’ obiilǫ́ǫ́z, Hat’íí baa shił nagolṉí’go láń? biłṉii. ");
INSERT INTO apwNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Paul bidá’áhń gáṉíí, Jews daanlíni iskąą nṉee yándaaltihíí bich’į’ Paul bił n’aash daaniłn’ṉii, daaṉiigo ndaagoshchįį, nłt’éégo baa na’ódíkidíí k’a’at’éégo. ");
INSERT INTO apwNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Áíná’ baa godeno’áah hela’: nṉee dizdin bitisyú hilt’éégo daaziłheego yiba’ naháztąą, Paul daizes‐hįįzhį’ doo da’iyąągo, doo da’idląągo nłdzilgo ádándaagost’ąą: áík’ehgo, Ha’aa, ńṉiihíí yiba’ naháztąą. ");
INSERT INTO apwNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Áík’ehgo silááda binant’a’ nṉee áníi naghahń, Shił nagosíńṉi’íí hadń bił nagolṉí’ hela’, yiłnṉiidná’, Nádńdáh, yiłnṉiid. ");
INSERT INTO apwNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Áígé’ silááda dała’á gonenadín binant’a’ naki yushdé’ yiłnṉiidgo gáyiłṉii, Silááda naki gonenadín, ła’íí łį́į́ bee silááda daanliiníí gosts’idin, ła’íí silááda bésh yee nadaagonłkaadíí naki gonenadín dagoshch’į’ Caesaréayú dahnádiiłséhgo áhłéh, tł’é’go ngost’áí bik’ehenkéézgo; ");
INSERT INTO apwNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Paul ałdó’ łį́į́ bił hiltéhíí bá iłch’į’hołéh, áík’ehgo Félix, nant’ánchań, baa bił nołkáh. ");
INSERT INTO apwNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Díí k’ehgo áṉíígo Félix yich’į’ k’e’eshchįį: ");
INSERT INTO apwNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Shíí Cláudius Lýsias nshłíni Félix nant’ánchań, ízisgo áńt’éhi, Gozhǫ́ǫ́, niłdishṉiigo nich’į’ k’e’eshchiih. ");
INSERT INTO apwNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Díń nṉeehń Jews daanlíni ła’ daabiłtsoodgo nabiziłhee nt’éégo Roman nṉee nlįį lą́ą́híí bígosíłsįįdgo silááda kú bił nshkaigo bich’ą́’ ńdaadihiiltįį. ");
INSERT INTO apwNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Hat’íí bee baa dahgost’aaníí bígonsį hasht’į́į́go bá yándaaltihíí baa bił ni’áázh. ");
INSERT INTO apwNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Dabíí yenahas’aaníí bik’izhį’ baa dahgost’ąą lą́ą́go bígosíłsįįd, ndi ha’ásitiiníí dagohíí da’itsaahíí doo ła’ bee bángot’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Díń nṉeehń zideego yaa ndaagoshchiiníí baa shił nagosṉi’ná’ dagoshch’į’ nich’į’ oł’a’, hayíí baa dahdaagoz’aaníí niṉááł baa nadaagodolṉih biłdishṉiigo bándaagosii’ąą. Da’áí zhą́ nich’į’ k’e’shiłchį́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Áík’ehgo silááda ádaabiłdo’ṉiidhíí k’ehgo tł’é’yú Antípatrisyú Paul yił okai. ");
INSERT INTO apwNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Iskąą hik’e siláádahíí siṉilyú nákainá’ łį́į́ bee silááda daanliiníí Paul yúweh yił okai: ");
INSERT INTO apwNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Áí Caesaréayú hikainá’ nant’ánchań naltsoos yaa daistsooz, Paul ałdó’ yaa yił hikai. ");
INSERT INTO apwNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Naltsoosíí yozhi’ná’, Ni’ hat’íí golzéhi biyi’ gonlíni, ṉiigo Paul nayídíłkid. Cilíciagé’ gólį́į́go yígołsįįdná’, ");
INSERT INTO apwNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Gáyiłṉii, Naa dahdaagoz’aaníí hikaigo naa yashti’ ndi at’éé. Hérod yánáltih goz’ąągee Paul silááda biṉádaadéz’įįgo ngon’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Áígé’ ashdla’iskaaníí bikédé’go okąąh yebik’ehi da’tiséyú sitíni, Ananías holzéhi, ła’íí Jews yánazíni biłgo hayaayú hikai, nṉee, Tertúllus holzéhi, bá yádaałti’go yił hikai, áń Paul bee baa dahgost’aaníí nant’ánchań yaa yił nagolṉi’ doleełgo. ");
INSERT INTO apwNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paul yiká ánṉiidná’ Tertúllus baa dahgo’aa nkegonyaa gáṉíígo, Nighą nohwini’ iłch’į’gont’éé, ła’íí nohwitahyú nchǫ’ n’íí nłt’éégo ánándlaa, ");
INSERT INTO apwNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Áí dawahn ła’íí dahayú ba’ahédaandzį, Félix, ízisgo áńt’éhi. ");
INSERT INTO apwNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Niłgoch’oba’go ayą́hágo nich’į’ hasdziihíí ídínłts’ąągo nánoshkąąh. ");
INSERT INTO apwNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Díń nṉeehń baa nagontł’ogíí nlįįgo bídaagosiilzįįd, Jews daanlíni ni’ dahot’éhé biká’ daagolííníí yił daagołkizh, ła’íí Nazarénes daanlįį zhiṉéégo yásizíni bídaagosiilzįįd: ");
INSERT INTO apwNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Da’ch’okąąh goz’ąą yuṉe’ gołchǫǫh nt’éégo bił ndaasiideel: nohwíí benagosiil’aaníí bee baa yádaasiiłti’ doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ndi Lýsias, siláada binant’a’ń, nohwaa nyáágo hagoshkéhégo nohwilák’e hayidzį́į́z ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Baa dahdaagoz’aaníí naa hikáhgo, ṉiigo ngon’ą́ą́: dá ni nahídńłkidgo hat’íí bighą baa dahdaagosiit’aaníí dawa bígonłsį́įh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jews daanlíni ałdó’ díí áṉííhíí da’aṉii áṉíí daanṉiid. ");
INSERT INTO apwNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nant’ánchań nabí’igizhná’ Paul yałti’ nkegonyaa gáṉíígo, Doo ałch’ídn łegodzaa dago díí hat’i’íí bá yánáltihíí ńlį́į́go bígonsįhíí bighą shił gozhǫ́ǫ́go ninadzahgee ádá hasdziih: ");
INSERT INTO apwNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Díí bígóńłsįįh, nakits’ádah iskąąná’ Jerúsalem yúdag oshkąąhyú níyáá ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Áígee da’ch’okąąh goz’ąą yuṉe’, ła’íí Jews ha’ánáłséh goz’ąą yuṉe’, ła’íí kįh gozṉilyú ła’ bił łaha’disht’áhgo doo hadń sho’įį da ni’, ła’íí nṉee bił daagodikishgo doo hadń sho’įį da ni’: ");
INSERT INTO apwNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Shaa dahgoz’aaníí daazhógo ágolzéhi. ");
INSERT INTO apwNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Áíná’ díí nich’į’ ádá nagoshṉi’, Jesus bikísk’eh da’ch’okahíí, okąąh bee sahngo na’ádi’ṉilíí daabiłdi’ṉiihíí, áí itah nshłįį, bich’ą́’gé’ nṉee sílííníí Bik’ehgo’ihi’ṉań daayokąąh lę́’e n’íí hoshkąąh, begoz’aaníí bee nohwá ngot’ąą n’íí ła’íí Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí bek’e’eshchiiníí dawa hoshdląą: ");
INSERT INTO apwNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nłt’éégo ádaat’eehíí ła’íí doo dábik’ehyú ádaat’ee dahíí nanezna’gé’ naadiikáh doleełíí áí nṉee yiká daadéz’įįhíí shíí ałdó’ Bik’ehgo’ihi’ṉań binkááyú biká désh’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Áígé’ dawahn Bik’ehgo’ihi’ṉań ła’íí nṉee ałdó’ daashineł’į́į́go nłt’éégo ánásht’įįłgo bígonsį doleełhíí bighą nłdzilgo nabik’í’isiid. ");
INSERT INTO apwNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Da’kwíí łegodzaahíí bikédé’go tédaat’iyéhíí hat’íhíta baa daanshné’go, ła’íí Bik’ehgo’ihi’ṉań hoshkąąhgo hat’íhíta baa nshné’go bił nít’i’íí bich’į’ násdzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Díí bee ánásht’įįłná’ da’ch’okąąh goz’ąą yuṉe’ godnłsįgo iłch’į’ áde’dinshdlaago, doo shiṉaayú nṉee łą́ą́go dała’adzaa da, doo godnch’áad dago Jews daanlíni ła’ Asiagé’ daagolííníí shaa hikai ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Áí hat’íhíta bee shaa dahdaago’aayúgo niṉááł shaa dahdaago’aago kú híkáhgo dábik’eh. ");
INSERT INTO apwNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Dagohíí yándaaltihíí shaa yádaałti’ n’ná’ hago’at’éégo nchǫ’go ánát’įįdíí shídaagołsįįdíí, nṉee kú nich’į’ hikaihíí yaa nadaagolṉi’go dábik’eh, ");
INSERT INTO apwNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Díí dała’á zhą́ doo bił dábik’eh da ni’, bitahyú sízį́į́go nádidishghaazhgo gádéṉiid n’ná’, Nanezna’íí naadiikáhíí hoshdląąhíí bighą díí jįį nohwiṉááł shaa yá’iti’. ");
INSERT INTO apwNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Áí Félix yidezts’ąąná’, Jesus bikísk’eh da’ch’okahíí nłt’éégo yígołsįhíí bighą gáṉíí, Dét’įhégo Lýsias, silááda binant’a’íí, kú ńyáágo bá ngonsh’aa ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Áígé’ silááda gonenadín binant’a’íí gáyiłṉii, Paul biṉádíń’įį, ndi łahgee dabíí hát’į́į́yú naghaa le’, ła’íí bit’eké baa nákáh nnizhǫǫ, hat’íhíta yídn nliiníí baa nádainé’go nnizhǫǫ. ");
INSERT INTO apwNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Da’kwíí iskaaníí bikédé’go Félix bi’aad Drusílla, Jew nlíni, yił n’áázhgo Paul yiká o’iił’a’, áík’ehgo Christ ch’odląąhíí yaa yałti’go daidezts’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Dábik’ehyú ánách’ot’įįłíí, ła’íí ádaagoch’idzaaníí, ła’íí yuṉáásyú kaa yá’iti’íí yaa yałti’go Félix ditłidgo tsídolyizgo gáṉíí, Dák’ad yúwehyú dahnṉáh, dahagee dábik’ehgee niká ánádeshṉe’ ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ndi yiká oná’ił’aa nt’éégo iłch’į’ yałti’, Paul ch’ínánshteehíí bighą zhaali shaa yiné’ shį nzį lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Naki łegodzaahíí ch’ígóyááná’ Félix nant’ánchań n’íígee Pórcius Féstus nant’ánchań silįį; áík’ehgo Félix Jews daanlíni bił dádaabik’ehyú ashṉe’ nzįgo Paul dáha’ásitįį nt’ééná’ óyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Féstus ni’ yánant’aa doleełíí biyi’ nyááná’ taagiskaaníí bikédé’go Caesaréagé’ Jerúsalem yúdag oyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Okąąh yedaabik’ehi da’tiséyú sitíni ła’íí Jews daanlíni ádn nazínihíí Paul bee dahdaagost’aaníí Féstus yaa yił nadaagolṉi’ná nádaayokąąh, ");
INSERT INTO apwNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Paul Jerúsalemyú dol’áá, daabiłnṉiid, higaałgo daayiziłheego ndaagoshchįįná’. ");
INSERT INTO apwNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Áíná’ Féstus gánṉiid, Paul, Caesaréayú t’ah bi’dotą’ ni’, shíí dák’adégo ákú nádésdzá. ");
INSERT INTO apwNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Áík’ehgo nohwitahyú nohwá nadaant’aahíí bił nádóshkáh, áígee nṉeehń nchǫ’go adzaayúgo ch’ík’eh baa nadaagolṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Féstus itah sidaago gonenan bitisyú iskąą, áígé’ Caesaréayú onádzaa; ákú iskąą hik’e yánáltihíí dahnándaahgee dahnezdaago, Paul yushdé’ bił nołkáh, nṉiid. ");
INSERT INTO apwNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ákú ńyááná’ Jews Jerúsalemgé’ hikaihíí biṉaayú nadaazįį, daazhógo ágolzeego, Doo ałch’ídn dénchǫ’go adzaa da, daabiłṉiigo baa dahdaagoz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paul ádá hadzii gáṉíígo, Jews yenagos’aaníí, dagohíí da’ch’okąąh goz’aaníí, dagohíí Caesar ndi doo hago ashłaa da. ");
INSERT INTO apwNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Áíná’ Féstus, Jews daanlíni bił dádaabik’ehyú áshṉéh nzįgo Paul gáyiłṉii, Ya’ Jerúsalem yúdag ńṉáhgo ákú shiṉááł naa dahgoz’aaníí bighą naa yá’iti’ háńt’įį née? ");
INSERT INTO apwNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paul gáṉíí, Caesar bá yánáltihíí bidáhgee sízį́į́, da’áígee shaa yá’iti’go dábik’eh: Jews daanlíni doo dénchǫ’go ánásht’įįł dahíí nłt’éégo bígonłsį́. ");
INSERT INTO apwNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nchǫ’go ánásht’įįł lę́’eyúgo hat’íí bighą dastsaahgo ásdzaayúgo dastsaahíí doo bich’ą́’ ch’a’oshgheed at’éé da; bighą shaa yá’iti’íí doo hat’íí dayúgo, doo hadń Jews daanlíni yaa shaa dino’aa at’éé da. Caesar shaa yałti’go hasht’į́į́. ");
INSERT INTO apwNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Áík’ehgo Féstus, yił nant’án daanliiníí iłch’į’ yádaałti’ná’ Paul gáyiłṉii, Caesar naa yałti’ háńt’įį, áík’ehgo áń bich’į’ nṉáh doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Da’kwíí iskaaníí ch’ígóyááná’ Agríppa, ízisgo nant’án nlíni, ła’íí Berníce biłgo Féstus, kozhį’ nant’án silįįhíí bighą, Caesaréayú yaa n’áázh. ");
INSERT INTO apwNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ákú sikeego łą́ą́go bedaizkąąná’ Féstus Agríppa Paul yaa yił nagosṉi’ gáṉíígo, Nṉee ła’ dá ha’ásitįį nt’ééná’ Félix onádzaa ni’: ");
INSERT INTO apwNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jerúsalemyú sídááná’ Jews bi’okąąh yebik’ehi itisyú nadaandeehi ła’íí Jews yánazíni, áí nṉeehń yaa shił nadaagosṉi’, Bá ngono’aah, daaṉiigo. ");
INSERT INTO apwNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Gádaabiłdéṉiid, Nṉee baa dahgost’aaníí hayíí baa dahdaagoz’aaníí doo baa yádaałti’égo, ła’íí baa dahgost’ąąhíí bighą dá doo ádá hadziihé yó’olt’e’go Romans daanliiníí doo áík’ehgo daagoz’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Áík’ehgo baa dahdaagoz’aaníí kú hikainá’ doo ńt’ah nsįgo da, iskąą hik’e yánáltihíí dahnándaahgee dahnídáágo, Yushdé’ nṉeehń bił nołkáh, déṉiid. ");
INSERT INTO apwNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Baa dahdaagoz’aaníí daahizį’ná’ nchǫ’go ánágot’įįłíí bee baa dahdaago’aa shį niizį́į́’, ndi doo hwaa da: ");
INSERT INTO apwNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Dabíí daabi’okąąhíí yaa łahada’dit’áh ła’íí nṉee ła’ Jesus holzéhi daztsąą n’íí Paul yaa nagolṉi’yúgo, T’ah hiṉaa, ṉiihíí ałdó’ yaa łahada’dit’áh. ");
INSERT INTO apwNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Díí k’a’at’ééhíí hago’at’éégo baa yashti’ shįhíí doo bígonsį dago, Jerúsalemyú ńṉáh háńt’įį née, ákú naa yá’iti’yú? biłdéṉiid. ");
INSERT INTO apwNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Áíná’ Paul gáshiłnṉiid, Augústus, nant’án da’tiséyú sitíni zhą́ shaa yałti’go hasht’į́į́, áík’ehgo Caesar bich’į’ oł’a’zhį’ biṉádaadeł’į́į́, daabiłdéṉiidgo bá ndaagosii’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agríppa Féstus gáyiłṉii, Nṉeehń dabíí yałti’go dists’į́h hásht’į́į́. Féstus gáṉíí, Iskąągo nts’į́h ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Iskąą hik’e Agríppa ła’íí Berníce biłgo baa da’olṉíígo n’áázh, silááda yánadaant’aahíí ła’íí kįh gozṉilgee nṉee itisyú nadaandeehíí biłgo dała’ánách’it’įįh goz’ąą yuṉe’ yił onałsą́ą́, áígé’ Féstus bik’ehgo Paul yił ha’ákai. ");
INSERT INTO apwNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Féstus gáṉíí, Agríppa, ízisgo nant’án ńlíni, ła’íí kú neheskaihíí daanohwigha, díń nṉeehń daał’įį ako, dząągee Jews daagolííníí dawa ła’íí Jerúsalemyú daagolííníí ałdó’ daadilwoshgo gádaashiłṉii, Díń nṉeehń doo hiṉaa bik’eh da. ");
INSERT INTO apwNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Áíná’ bighą da’itsaahíí doo ła’ yee adzaa da ląągo bígosíłsįįd, ła’íí dabíí gáshiłnṉiid, Augústus, nant’án da’tiséyú sitíni shaa yałti’go hasht’į́į́, áík’ehgo ákú bich’į’ dish’aago ngoni’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Áíná’ shinant’a’ bich’į’ doo hat’íí baa bek’e’eshchii da. Áí bighą nohwaa bił ni’áázh, ni zhą́ Agríppa, ízisgo nant’án ńlíni, naa bił ni’áázh, áík’ehgo nahídaadelkidíí bikédé’go shinant’a’ hat’íhíta baa bich’į’ k’e’eshchii doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ha’ásitiiníí hat’íí bee baa dahgost’aaníí doo bígoziné dago deł’a’go doo shił bik’eh da, shíí. ");
INSERT INTO apwNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agríppa Paul gáyiłṉii, Ádá hadziihgo naa godet’ąą. Áík’ehgo Paul na’ígizhná’ ádá hadzii, gáṉíígo: ");
INSERT INTO apwNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Agríppa, ízisgo nant’án ńlíni, Jews daanliiníí yee shaa dahdaagoz’aaníí dawa díí jįį niṉááł bee ádá hasdziihíí baa shił gozhǫ́ǫ́: ");
INSERT INTO apwNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Jews daanlíni bi’at’e’ ła’íí łahada’dit’áhíí nłt’éégo bígonłsįhíí bighą: nłt’éégo shíyíńłts’ąą, nánoshkąąh. ");
INSERT INTO apwNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Jerúsalemgee bił nít’i’íí daagolííníí bitahyú ishkiin nshłįį ni’, áígé’ yushdé’ godezt’i’go hago’at’éégo hinshṉaahíí Jews daanlíni dawa yídaagołsį. ");
INSERT INTO apwNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Doo áníi shídaagołsį da ni’, shá hadaadziih hádaat’įįyúgo, Phárisee nlįįgo, Phárisees daandliiníí nohwi’okąąh itisgo daidnłsiníí yikísk’eh hiṉaa ni’, daashiłṉii doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Daanohwitaa n’íí Bik’ehgo’ihi’ṉań bándaagoz’ąą n’íí hoshdląąhíí bighą shaa yá’iti’go kú sízį́į́: ");
INSERT INTO apwNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Díí Bik’ehgo’ihi’ṉań ngon’ááníí begolṉe’go nohwíí nakits’ádahyú hahiit’i’íí dájįį biigha dátł’é’ biigha nłdzilgo Bik’ehgo’ihi’ṉań daahohiikąąh. Díí oshdlaaníí Jews daanlíni shaa dahdaagoz’ąą, Agríppa, ízisgo nant’án ńlíni. ");
INSERT INTO apwNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Bik’ehgo’ihi’ṉań nanezna’íí naadaayihil’ṉahíí hat’íí bighą doo daahołdląą hádaałt’įį da? ");
INSERT INTO apwNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Jesus, Názarethgé’ gólíni, bizhi’ bich’ą́’zhį’go dashíí ánásht’įįłgo dábik’eh nsį ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Áík’ehgo Jerúsalemyú ágásdzaa: okąąh yedaabik’ehi yánadaant’aahíí bik’ehgo Jesus daayokąąhíí łą́ą́go ha’áhálkaad ni’; ła’íí natseedgo bándaagot’a’íí, Ha’aa, dishṉiigo bá da’isoh ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Jews ha’ánáłséh nagoz’ąą yuṉe’ łahgee biniidaagodinsį ni’, Jesus nchǫ’go yaa yádaałti’go ádaashłe’ ni’; ła’íí dázhǫ́ bik’edaadinshṉiihgo doo Jews daanlįį dahíí bikįh nagozṉilyú ndi biniidaagodinsį ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Ágánásht’įįłgo okąąh yedaabik’ehi itisyú nadaandeehi shaa daagodez’ąą, Ti’i ákú ńṉáh, daashilnṉiidgo Damáscusyú óyáá. ");
INSERT INTO apwNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ízisgo nant’án ńlíni, hishaałyú ha’iz’ąągo shíí ła’íí bił hishkaahíí biłgo nohwiṉaayú ch’ígona’áí be’idindláádíí bitisgo yaaká’gé’ nohwich’į’ nke’dindláád ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Daanohwigha hayaa nandeená’ Hebrew biyati’ k’ehgo yati’ gáshiłṉiigo idisiits’ą́ą́, Saul, Saul, hat’íí lą́ą́ bighą shiniigonłt’éégo áshińłsį? Tsįdik’iihíí bee níts’i’ishgo’yúgo dayúweh t’ąązhį’ hóńtałyúgo dayúweh dáni ídída’nłṉi’. ");
INSERT INTO apwNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Gádéṉiid, Hadń áńt’įį, shiNant’a’? Gáshiłnṉiid, Shiniigonłt’éégo áshińłsinihíí shíí ásht’į́į́, Jesus honszéhi. ");
INSERT INTO apwNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nádndáhgo hizįį: díí bighą nił ch’í’ṉah ádeshdlaa, shá na’iziidgo haniłtį́į́, hago’at’éégo shinłtsaaníí ła’íí hat’íí nił ch’í’ṉah ádidishdliiłíí shá baa nagolṉí’ doleełgo; ");
INSERT INTO apwNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Jews daanliiníí ła’íí doo Jews daanlįį dahíí ałdó’ bich’ą́’ niishteeh, doo Jews daanlįį dahíí bich’į’ nidish’aa, ");
INSERT INTO apwNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Biṉáá got’įįgo ánádaadle’go chagołheełgé’ idindiinzhį’ ánáda’ṉe’go, ła’íí Satan nadaabiłaahíí bich’ą́’yúgo Bik’ehgo’ihi’ṉań bich’į’ ánáda’ṉe’go binchǫ’íí bich’ą́’zhį’ ádaile’, ła’íí daashodląąhíí bee hadaadeszaahíí bitah daanlįį doleełhíí bighą bich’į’ nidish’aa. ");
INSERT INTO apwNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Áík’ehgo Agríppa, ízisgo nant’án ńlíni, díí yaaká’gé’ shił ch’í’ṉah ágolzaahíí da’áshiłṉiiyú ásdzaa: ");
INSERT INTO apwNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Damáscusyú daagolííníí iłtsé, áígé’ Jerúsalemyú daagolííníí, ła’íí ni’ Judéa dahot’éhé biyi’yú daagolííníí, ła’íí doo Jews daanlįį dahíí ałdó’ gádaałdishṉii, Nohwinchǫ’íí bich’ą́’yúgo ádaałṉe’go Bik’ehgo’ihi’ṉań bich’į’ ánádaałṉe’, ła’íí nohwinchǫ’íí bich’ą́’yúgo ádaałdzaahíí dábełt’eego ánádaałt’įįł. ");
INSERT INTO apwNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Díí bighą Jews daanlíni da’ch’okąąh goz’ąą yuṉe’ shił ndaazdeelgo daashiziłheego ch’éh ádaat’įįd ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Díí jįįzhį’ ngońt’i’go Bik’ehgo’ihi’ṉań shich’oṉiigo kú sízį́į́, nṉee doo ízisgo ádaat’ee dahíí, ízisgo ádaat’eehíí biłgo Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí ła’íí Moses be’ágoṉe’ daaṉii n’íí zhą́ baa nagoshṉi’go gádaabiłdishṉii: ");
INSERT INTO apwNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Christ biniigodilṉe’ doleeł, ła’íí da’iłtsé daztsąągé’ naadiidáhíí nlįį doleeł, be’idindííníí Jews daanliiníí ła’íí doo Jews daanlįį dahíí yił ch’í’ṉah áyíłsį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ágáṉíígo ádá yałti’ná’ Féstus nawode gánṉiid, Paul, niini’ édįh ląą; łą́ą́go ígonł’aaníí niini’ édįhgo áníílaa ląą. ");
INSERT INTO apwNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paul gánádo’ṉiid, Féstus, ízisgo áńt’éhi, doo shiini’ édįh da: da’aṉii ágot’eehíí shiini’ golį́į́go baa yashti’. ");
INSERT INTO apwNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ízisgo nant’án ńlíni, díí baa yashti’íí bígonłsį́, doo hat’íí t’ąązhį’ be’ánsht’ee dago nich’į’ yashti’; díí dahot’éhé bígonłsį; doo ła’ nagont’i’ dayú ba’ánágot’įįdhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Agríppa, ízisgo nant’án ńlíni, Bik’ehgo’ihi’ṉań binkááyú nada’iziidi n’íí hondląą née? Hondląągo nígonsį. ");
INSERT INTO apwNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agríppa Paul gáyiłṉii, Ínashood hishłeehgo dásdozhą́ shiini’ shá ágonlaa. ");
INSERT INTO apwNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paul gánádo’ṉiid, Doo dásdozhą́ da, da’aṉii odlání ńlį́į́ doleeł, doo dáni zhą́ da, áíná’ díí jįį daasidezts’aaníí dawa da’ánsht’eehíí k’ehgo ágát’éé doleeł, dishṉiigo Bik’ehgo’ihi’ṉań hoshkąąh, díí łíshi’destł’ooníí zhą́ dahgo. ");
INSERT INTO apwNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Paul ánṉiidná’ ízisgo nant’án, ła’íí nant’ánchań, ła’íí Berníce ła’íí yił naháztaaníí biłgo nádiikai. ");
INSERT INTO apwNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","K’ihzhį’yú niikaigo gádaałiłdi’ṉii, Díń nṉeehń bighą datsaahíí dagohíí bighą ha’á’istiiníí doo ye’ánát’įįd da ląą. ");
INSERT INTO apwNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agríppa Féstus gáyiłṉii, Díń nṉeehń ch’ínádzá doleeł ni’, Caesar doo yaa ádet’ąą dayúgo. ");
INSERT INTO apwNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Italyú nohwił dahdez’eelgo nagot’ąąná’ Paul, ła’ ha’áshijeedíí biłgo silááda dałán gonenadín binant’a’, Július holzéhi, biṉádaadéz’įį doleełgo baa ni’ṉil, áń silááda Augústus yánant’aahíí itah nlįį. ");
INSERT INTO apwNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tsina’eełíí Adramýttiumgé’ Asia bitábąą zhiṉééyú k’ad des’éli bih hiikaigo nohwił dahda’n’eel; Aristárkus, Macedónia biyi’ Thessalonícagé’ gólíni, bił dekai. ");
INSERT INTO apwNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Iskąą hik’e Sídon golzeegee nohwił nda’iz’eel; áígee Július Paul yaa ch’oba’go, Nit’eké bich’į’ nṉáhgo nłt’éégo ádaaniłsį le’, biłnṉiid. ");
INSERT INTO apwNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Áígé’ nohwił dahnáda’n’eelná’ Cýprus bit’ahyú isht’agonch’iidyú nohwił ch’ída’iz’eel, nohwich’į’go ńch’iidhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Cilícia ła’íí Pamphýlia bit’ahyú túnteel biyi’ nohwił ch’ída’iz’eel, áígé’ Lýcia biyi’ kįh gozṉilíí Mýra golzeezhį’ nohwił nda’iz’eel. ");
INSERT INTO apwNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Áígee silááda gonenadín binant’a’ tsina’eełi Alexándriagé’ihi Italyú dez’éli yaa nyáágo, Beh hołkáh, nohwiłnṉiid. ");
INSERT INTO apwNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Dátąądégo nohwił da’o’ołgo doo ałch’ídn nohweda’iskąą da, nohwich’į’ nagontł’ogo, ni’ tayi’ dahgoz’áni Cnidus golzéhi bit’ahzhį’ nohwił ch’ída’iz’eel, ńch’iidhíí bighą doo dayúweh nohwił da’o’oł bik’eh dago Salmóne bitis Crete bit’ahyú isht’agonch’iidyú nohwił ch’ída’iz’eel; ");
INSERT INTO apwNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nohwich’į’ nagontł’ogo tábąą zhiṉéé nohwił da’o’ołgo Fair Havens golzeezhį’ nohwił nda’iz’eel, kįh gozṉil Laséa golzeehíí bit’ahyú. ");
INSERT INTO apwNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nohwich’į’ nagontł’ogíí bighą, ła’íí daagodnłsįgo dáshiṉá’ da’ch’okąąhíí ałk’iná’ bitis ch’ígóyááhíí bighą ił’o’ołíí bégódzid ni’, áík’ehgo Paul gádaabiłṉii, ");
INSERT INTO apwNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Shik’isyú, díí bígonsį, nohwił da’o’ołyú tsina’eełíí ła’íí daayogheełíí bich’į’, nohwíí dó’ nohwich’į’ nadaagontł’og doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Áíná’ silááda gonenadín binant’a’ń, o’ołíí yebik’ehń ła’íí tsina’eełíí bíyéé gólííń zhą́ óyésts’ąą, áíná’ Paulń doo óyésts’ąą da. ");
INSERT INTO apwNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Tsina’eełíí nná’i’ołgee doo nohwehai bik’eh dahíí bighą ch’iląągo gádaaṉii, Nohwił da’o’oł le’, dáhago’at’éégo Pheníceyú niikáh, áígee nohwehai doleeł, daanzįgo; Pheníce áí Crete biyi’ goz’ąą, áígee tsina’eełíí nna’oł northwestzhį’go ła’íí southwestzhį’go ch’ígót’i’. ");
INSERT INTO apwNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Hayaagé’ tąądégo ńch’iidná’, nohwá ííts’ííd daanzįgo, bésh ndaazíí tsina’eełíí bee dahastł’ǫ́ n’íí ihnádaiz’ąąná’ Crete bibąhyú bił ch’ída’iz’eel. ");
INSERT INTO apwNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Dét’įhék’e tsina’eełíí híłch’į’cho bił hayaa, Euroclýdon holzéhi. ");
INSERT INTO apwNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nawode desch’iidhíí bighą tsina’eełíí doo híłch’į’dáhzhį’ dahdi’eeł da, dabiini’yú dez’eel lę́’e. ");
INSERT INTO apwNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ni’ táyi’ dahgoz’áni ałch’ísę́hi, Cláudia golzéhi, bit’ahyú isht’agonch’iidyú nohwił ch’ída’iz’eelgo tsina’eełíí ałch’ísę́híí da’ónanta tsina’eełíí nchaahíí bit’ahyú ndaiz’ąą: ");
INSERT INTO apwNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Áígé’ tsina’eełíí nchaahíí biká’yú dahdaiz’ąąná’ bésh hishbizhíí nchaahíí tsina’eełíí bik’ídesdiz; goshtł’ishcho yédaaldzidgo gowągolgai biká’ dastsoozíí nadaayinłtsoozná’ ńch’iidíí zhą́ bee dez’eel. ");
INSERT INTO apwNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nawode nohwił iłch’ą́’ nách’ihíí bighą iskąą hik’e tsina’eełíí yoghélihíí ła’ yó’odaiskaad; ");
INSERT INTO apwNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Nakiskąą hik’e tsina’eełíí benadziidi dabíí yó’odaiskaad. ");
INSERT INTO apwNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ch’ígona’áí ła’íí ts’iłsǫǫsé doo hwaa bee got’įį dago doo ałch’ídeskąą da, ła’íí díyat’éégo nohwił iłch’ą́’ nách’ih, áík’ehgo doo hago’at’éégo hasdáhiikáh da ląą daandzį ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Dá doo da’iyáné ńzaad begodeyaaná’ Paul iłṉí’gé’ hizįįgo gáṉíí, Shik’isyú, shich’į’ ídaayesółts’ąąyúgo, Cretegé’ doo nohwił dahda’n’eel dayúgo, doo díí k’ehgo nohwich’į’ nadaagontł’og da doleeł ni’, ła’íí doo hat’íí ch’a’oné’ da doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Áíná’ gádaanohwiłdishṉii, Bidag ádaanołt’ee le’: doo ła’ daaholtsaah at’éé da, tsina’eełíí zhą́ da’ízlį́į́ hileeh. ");
INSERT INTO apwNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Tł’é’ná’ Bik’ehgo’ihi’ṉań, bíyéé nshłįįń ła’íí hoshkąąhń, binal’a’á yaaká’gé’hi shit’ahgé sizįįgo, ");
INSERT INTO apwNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Gáshiłnṉiid, Paul, doo niini’ hąh da le’; Caesar bidáhgee síńzįį doleeł: ła’íí bił nił da’o’ołíí dawa daahiṉaahgo Bik’ehgo’ihi’ṉań naa godin’ą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Áík’ehgo shik’isyú, bidag ádaanołt’ee le’: Bik’ehgo’ihi’ṉań hoshdląąhíí bighą da’áshiłṉiihíí k’ehgo ágoṉe’go bígonsį. ");
INSERT INTO apwNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Áíná’ ni’ táyi’ dahgoz’aaníí biká’gee yónohwi’dilkaad doleeł. ");
INSERT INTO apwNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Dį́į́’ts’ádah iłkaahíí bitł’é’ túnteel Ádria holzéhi biyi’gé’ tsina’eełíí bił iłch’ą́’ nnáiłṉiiná’ tł’é’ís’ahyú shį nada’ił’eełíí ni’ bich’į’yú nohwił da’n’eel daanzį lę́’e; ");
INSERT INTO apwNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Áík’ehgo hayaa tú yída’nes’ąądgo nadin iłk’ích’idesṉiih, k’a’áhosah lą́go yídaagołsįįd: yuṉáásyú tú yínáda’nes’ąądgo k’adíí ashdla’ádah iłk’ích’idesṉiih k’a’áhosah. ");
INSERT INTO apwNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Dánko tséé biká’ hi’eełhíí bighą bił daagoyé’égo bésh ndaazíí tsina’eełíí bedahastł’óníí dį́į́’i nkedezṉil, tsina’eełíí biké’ńṉáá yúyaa, áíná’ jįį góleeh, daaṉiigo da’okąąh. ");
INSERT INTO apwNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Nadaał’eełíí tsina’eełíí biyi’gé’ hahiikeeh daanzįgo, tsina’eełíí ałch’ísę́híí téh daayihezṉil, bésh ndaazíí tsina’eełíí bádngé’ nkedaayiṉííł ádaagodil’įįgo, ");
INSERT INTO apwNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paul silááda ła’íí silááda gonenadín binant’a’íí gáyiłṉii, Díí nṉeehíí dá tsina’eełíí biyi’ naháztąąyúgo zhą́ daahołṉaa. ");
INSERT INTO apwNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Áík’ehgo silááda tsina’eełíí ałch’ísę́híí bedahdaahestł’ooníí daayiheshgizhgo bił odaagohez’eel. ");
INSERT INTO apwNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","K’ad haiłkaahyú Paul nádaayokąąhgo gádaayiłṉii, Da’ołsąągo nzhǫǫ, nda’ołíígo dáshiṉá’ dį́į́’ts’ádahyú nohwíyołkaał. ");
INSERT INTO apwNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Áík’ehgo nádaanohwoshkąąh, da’ołsąą, áí bee daanołdzilgo; nohwitsizíl dała’á ndi doo nohwich’ą́’ ch’a’odeeł da. ");
INSERT INTO apwNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Díí yee ánṉiidná’ báń náidnné’go dawa biṉááł Bik’ehgo’ihi’ṉań áshǫǫd yiłṉiigo oskąądná’ iłk’íyíłdláádgo yiyąą nágodiidzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Áík’ehgo nṉee ła’ihíí yidag ádaat’eego dabíí ałdó’ da’iyą́ą́. ");
INSERT INTO apwNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Daanohwighago naki gonenadín iká’yú gosts’idin gostáń hiilt’ee, tsina’eełíí biyi’. ");
INSERT INTO apwNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Náda’isdįįdzhį’ da’iyą́ą́ná’ tł’oh nagháí téh daayeskaadgo tsina’eełíí dá’ałdzólé silįį. ");
INSERT INTO apwNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Got’įį gozlįįná’ ni’híí doo yídaagołsį da: ndi tú ónáhíką́ą́go ténágohįį’ą́ą́ daayo’įį, áígee nohwił ndaanó’eeł daanzį. ");
INSERT INTO apwNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Áík’ehgo bésh ndaazíí tsina’eełíí bee dahastł’ǫ́ n’íí daazhógo yó’odaiskaadgo be’anáhot’aałíí bitł’ól k’eda’iz’ahgo, ła’íí tsina’eełíí bit’a’ bádn zhiṉééhíí hadag ádaizlaago ńch’iid bich’į’go tábąązhį’ bił nda’iz’eel. ");
INSERT INTO apwNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ndi tú łednlįįgee tsina’eełíí łehígo’go doo nahi’naa da silįį; biké’dinṉáágé’íí tú nádidáhíí nbiheztį’. ");
INSERT INTO apwNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ha’áshijeedíí ła’ nada’diłkǫh daanzįgo, silááda nadaabiłtseedgo ndaagoshchįį, ");
INSERT INTO apwNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Áíná’ silááda gonenadín binant’a’ń Paul doo zidee hat’į́į́ dago, Dah, biłnṉiid; Hayíí nada’ołkǫ’íí tsina’eełíí bitisyú’an odaołjágo táts’áda’ołkǫ́h, daayiłṉii: ");
INSERT INTO apwNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ła’íí gáyiłṉii, Tsį nteelíí ła’íí tsina’eełíí baa nahastǫ’íí bee hanaazhį’ nada’ołkǫ́h. Áík’ehgo dawa ni’zhį’ nádaaheskai. ");
INSERT INTO apwNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tásts’áskainá’ ni’ táyi’ dahgoz’aaníí Melíta golzee lą́go bídaagosiilzįįd. ");
INSERT INTO apwNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nṉee áígee daagolííníí k’ídaanzįgo deda’deshjeedná’, Yushdé’ nádaanołdziił, daanohwiłnṉiid, nagoltįh nkegonyaa, ła’íí gozk’azíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paul chizh ła’ náyihezlaago dayínṉilná’ tł’iish bik’asda’ golíni ndoogo áígé’ hayáágo Paul bigan baa dahisdeeł. ");
INSERT INTO apwNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nṉee áígee daagolííníí tł’iishíí Paul bigangé’ nahitį́į́go daayiłtsąąná’ gádaałiłdi’ṉii, Díń nṉeehń nṉee naiłtseedíí nlíni lą́ą́, túnteel bich’ą́’gé’ híṉa’ ndi, doo hiṉaa bik’eh dahíí bighą datsaah. ");
INSERT INTO apwNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Áíná’ Paul tł’iishíí dá kǫ’ biyi’zhį’ nayííłt’e’ná’ Paul doo hago adzaa da. ");
INSERT INTO apwNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","K’ad nilzooł shį daabo’ṉíígo, dagohíí datsaah shį daanzįgo biba’ naháztąą; ndi ńzaad godeyaago doo hago adzaa dago daayo’įįná’ biini’ łahgo ánádaizdlaago, Diyin nlįį lą́ą́, daanzį. ");
INSERT INTO apwNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ni’ táyi’ dahgoz’ąąyú daagolííníí binant’a’, Públius holzéhi áígee ła’ bini’ lę́’e; áń k’ínoho’ṉíígo bigowąyú taago nohweskąą. ");
INSERT INTO apwNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Públius bitaa yóíyahgo nezgaigo chan diłé yaa naghaago sitįį: Paul baa nyáágo biká’ ndelṉiiná’ bá oskąądgo nábi’dilziih. ");
INSERT INTO apwNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ágágodzaaná’ nṉee táyi’ dahgoz’ąąyú daagolííníí ła’ihíí kah yaa nakaihíí neheskaigo nádaabi’dilziih: ");
INSERT INTO apwNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Daanohwidnłsįgo dawahá nohwá daayihezṉil; ła’íí k’ad nohwił da’dez’eelná’ dawahá bídaandinihíí tsina’eełíí yih daihezṉil. ");
INSERT INTO apwNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Taagi nohwedahitąąná’ tsina’eełíí áígee behaihi, Alexándriagé’ihíí, Cástor ła’íí Póllux beda’aszaahi bádngee nazįįgo ádaaszaago bił nohwił da’dez’eel. ");
INSERT INTO apwNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sýracuse nohwił nda’iz’eelgo áígee taagi nohweskąą. ");
INSERT INTO apwNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Áígé’ nohwił łéda’n’eelgo Rhégium nohwił nda’iz’eel: áígé’ iskąą hik’e hayaagé’go dezhch’iidgo iskąą hik’e Putéoliyú nohwił nda’iz’eel: ");
INSERT INTO apwNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ákú odlą’ bee nohwik’ííyú baa nkaigo, Nohwił nahísółtąą le’, daanohwiłṉiigo, bił naháatąą gosts’idiskąą: áígé’ Romeyú ohiikai. ");
INSERT INTO apwNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Odlą’ bee nohwik’ííyú ákú daagolííníí hiikahgo nohwaat’ídaanzįįná’ Ápiai Forum ła’íí Three Taverns golzeezhį’ nohwiba’ hikai; áí Paul yiłtsąąná’ Bik’ehgo’ihi’ṉań ya’ahénzįgo bił gozhǫ́ǫ́go hadag adzaa. ");
INSERT INTO apwNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Romeyú nkainá’ silááda binant’a’ ha’áshijeedíí biṉádaadéz’iiníí binant’a’ yaa ńṉil: ndi Paulhíí dasahn golį́į́go baa godet’ąą, silááda ła’ biṉádéz’įįgo. ");
INSERT INTO apwNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Taagiskąąná’ Paul Jews áígee daagolííníí yánazíni, Dała’ałṉéh, daayiłṉii: dała’adzaaná’ gádaayiłṉii, Nṉee daanołíni, shik’ííyú, Jews daanliiníí dagohíí daanohwitaa n’íí bi’at’e’ doo hago ashłaa da ndi, Jerúsalemgé’ ha’ásítį́į́go niyáágo Romans daanlíni baa shi’deltįį. ");
INSERT INTO apwNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Shaa yádaałti’ná’ bighą dastsaahíí doo ła’ dahíí bighą ch’ínádaashíłteeh hádaat’įį ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ndi Jews daanliiníí áí doo hádaat’įį dago, Caesar shaa yałti’ hasht’į́į́, dishṉii lę́’e, bił nít’i’íí doo hat’íí bee baa dahdaagosh’aa da ndi. ");
INSERT INTO apwNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Áík’ehgo Israel hat’i’íí bángot’ąąhíí bighą díí bésh hishbizhíí bee łíshi’destł’ǫǫhíí bighą dała’ánohwishłaa, nohwines’į́į́go, nohwich’į’ yashti’go: ");
INSERT INTO apwNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Gádaabiłnṉiid, Judéage’ naltsoos naa nagolṉi’go doo ła’ nohwaa hi’ṉil da, ła’íí nohwik’ííyú áígé’ kú neheskaihíí doo ła’ naa naagolṉi’ da, doo ła’ nchǫ’go naa yałti’ da. ");
INSERT INTO apwNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Dahot’éhé díí okąąh bee sahngo na’ádi’ṉilihíí baa yá’iti’go bídaagonlzį: ni hago’at’éégo baa natsíńkeesíí daadihiits’į́h hádaahiit’įį. ");
INSERT INTO apwNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Bángot’aaníí bijįį nṉee łą́ą́go Paul dásidaayú dała’adzaa; t’ałbįgé’ o’i’ą́ą́zhį’ Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí nłt’éégo yaa nagosṉi’, Moses yegos’aaníí ła’íí Bik’ehgo’ihi’ṉań binkááyú nada’iziidíí k’eda’ashchiiníí bich’ą́’gé’ Jesus yaa nagosṉi’go biini’ yá ádaagole’go nzį. ");
INSERT INTO apwNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ła’ yaa yałti’íí daayosdląąd, ła’ihíí doo daayosdląąd da. ");
INSERT INTO apwNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Łahada’dit’áhgo Paul dałán yee hananádzii’ná’ onákai, Esáias, Bik’ehgo’ihi’ṉań binkááyú na’iziidi n’íí, Holy Spirit binkááyú daanohwitaa n’íí da’aṉiigo gáyiłnṉiid, ");
INSERT INTO apwNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Díí hat’i’íí bich’į’ nṉáhgo gádaabiłnṉiih, Daadołts’ag ndi doo nohwił ídaagozį da doleeł; daaneł’į́į́ ndi doo da’aṉii daał’įį da doleeł: ");
INSERT INTO apwNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Díí nṉeehíí biini’ daanyee’ daazlįį, doo da’diits’ag da daazlįį, ła’íí daanéshch’il daazlįį; doo ágádaat’ee dayúgo biṉáá yee daago’įį doleeł ni’, bijeyi’ yee da’diits’ag doleeł ni’, ła’íí biini’ yee bił ídaagozį doleeł ni’, áík’ehgo shich’į’ ádaaṉe’go nádaasdziih doleeł ni’. ");
INSERT INTO apwNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Díí bídaagonołsį le’, Bik’ehgo’ihi’ṉań bich’ą́’gé’ bee hasdách’igháhíí doo Jews daanlįį dahíí bich’į’ ol’a’, nohwiłdishṉii, áíhíí ídaadésts’ąą ndi at’éé. ");
INSERT INTO apwNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Díí yee hadziiná’ Jews daanliiníí dázhǫ́ łahada’dit’áhgo onákai. ");
INSERT INTO apwNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paul ákú kįh yighą na’ihiṉiiłíí yiyi’ golį́į́go naki łegodzaa, ła’íí baa hikáhíí dawa ya’ahénzį ni’, ");
INSERT INTO apwNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Doo nanł’į’ dago, nṉee doo ła’ tsíbiłdįį dago Bik’ehgo’ihi’ṉań bilałtł’áhgee begoz’aaníí yaa nagolṉi’ ni’, ła’íí Jesus Christ nohweBik’ehń yaa iłch’ígó’aah ni’. ");
INSERT INTO apwNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Shíí, Paul, Jesus Christ bána’isiidi, áń binal’a’á nshłįįgo shich’į’ ánṉiid, ła’íí Bik’ehgo’ihi’ṉań bits’ą́’dí’ yati’ baa gozhónihíí baa nagoshṉi’híí bighą its’áshi’doltįį, ");
INSERT INTO apwNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","(Da’áí Bik’ehgo’ihi’ṉań binkááyú nada’iziid n’íí binkááyú yałti’go dabíntsé yengon’ą́ą́, áí godiyįhgo Bek’e’eshchiiníí biyi’ bek’eda’ishchįį lę́k’e,) ");
INSERT INTO apwNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Áí yati’ baa gozhóni Bik’ehgo’ihi’ṉań biYe’ Jesus Christ nohweBik’ehń yaa nagolṉi’, áń nṉee k’ehgo nyáágo David łinolt’įįłíí nlįį; ");
INSERT INTO apwNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Jesus Christ daztsąądí’ naadiidzaahíí bee Bik’ehgo’ihi’ṉań biYe’ nlįįgo ch’í’ṉah alzaa, Holy Spirit bits’ą́’dí’ binawod golį́į́go: ");
INSERT INTO apwNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Holy Spirit biláhyú Bik’ehgo’ihi’ṉań bits’ą́’dí’ iłgoch’oba’íí shaa det’ąą, binal’a’á nshłįį doleełgo, áík’ehgo Jesus bizhi’íí ba’ihégosį doleełhíí bighą baa nagoshṉi’go, nṉee iłtah at’éégo hadaazt’i’i daabodląąhgo bikísk’eh ádaat’eego ashłe’: ");
INSERT INTO apwNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nohwíí ałdó’ Jesus Christ bíyéé daanohłįį doleełgo nohwich’į’ ánṉiid: ");
INSERT INTO apwNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Daanohwigha Romeyú daagonohłiiníí nohwich’į’ k’e’eshchii, Bik’ehgo’ihi’ṉań bił daanohshǫǫgo báhadaadeszaahíí daanohłįįgo nohwich’į’ ánṉiid: Bik’ehgo’ihi’ṉań nohwiTaa ła’íí Jesus Christ nohweBik’ehń biłgoch’oba’íí ła’íí bits’ą́’dí’ iłch’į’gont’ééhíí bee nohwich’į’ goz’ąą le’. ");
INSERT INTO apwNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Dantsé Jesus Christ binkááyú daanohwigha Bik’ehgohinshṉań nohwighą ba’ihénsį, nohwi’odlą’ ni’gosdzáń biká’ dahot’éhé baa ch’iṉiihíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Bik’ehgo’ihi’ṉań, biYe’ baa yati’ nłt’éhi baa nagoshṉi’go, shijíí biyi’dí’ bána’isiidíí da’ákozhą́ nohwá oshkąąh nt’éé shá yígółsį; ");
INSERT INTO apwNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Díínko bighą dá oshkąąh nt’éé, Bik’ehgo’ihi’ṉań bik’ehgo áníita dáhago’at’éégo nłt’éégo nohwaa deshááł. ");
INSERT INTO apwNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","K’azhą́ daanohwistséh, nt’é Holy Spirit bits’ą́’dí’ shaa hi’né’íí ła’ nohwaa nshné’híí bighą, áí bee nłdzilgo daahodohsįįł doleełgo; ");
INSERT INTO apwNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Díí áłdishṉii, nohwíí hik’e shíí biłgo nohwi’odlą’ dała’ázhį’ iłdeṉáágo bee hadag ádaałinlzį doleeł. ");
INSERT INTO apwNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Shik’ííyú, doo ałch’ídndi nohwich’į’ disháh hásht’į́į́go ni’ bídaagonołsįgo hasht’į́į́, doo Jews daanlįį dahíí ła’ihíí bitahyú nṉee Bik’ehgo’ihi’ṉań bich’į’ hosiłbą́ą́híí k’ehgo nohwitahyú ałdó’ ła’ hodishbįįłhíí bighą, (ndi nashi’dinłtł’ogo t’ahkó goldoh.) ");
INSERT INTO apwNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Greeks daanliiníí hik’e nanidí’ nṉee daanliiníí ałdó’, daagoyą́ą́híí hik’e doo daagoyą́ą́ dahíí ałdó’ shaa hadais’aahíí k’ehgo t’ah Christ baa bił nagoshṉi’go shá goz’ąą. ");
INSERT INTO apwNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Áík’ehgo iłk’idá’ yati’ baa gozhóni nohwił nagoshṉi’go dázhǫ́ hásht’į́į́, Romeyú nadaahisohtaaníí ndi. ");
INSERT INTO apwNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Christ baa yati’ baa gozhóni doo bik’e ídaayánsdzį da: áí Bik’ehgo’ihi’ṉań binawodíí biláhyú behasdách’igháhi at’éé, da’odlaaníí dawa bá, Jews daanliiníí dantsé, ła’íí Greeks daanliiníí ałdó’. ");
INSERT INTO apwNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Áí yati’íí biyi’ Bik’ehgo’ihi’ṉań bits’ą́’dí’ nṉee bich’į’ dábik’ehyú át’ééhíí ch’í’ṉah alzį, odlą’ begodeyaadí’ odlą’ bengont’i’zhį’: bek’e’eshchiiníí gáṉííhíí k’ehgo, Hadíń dábik’ehyú át’ééhíí odlą’ zhą́ yee hiṉaa doleeł. ");
INSERT INTO apwNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nṉee Bik’ehgo’ihi’ṉań doo daidnłsį dahíí ła’íí nchǫ’íí ye’ánádaat’įįłíí dawa yich’į’ Bik’ehgo’ihi’ṉań bihashke’ yaaká’dí’ ch’í’ṉah alzį, áí nchǫ’íí ye’ánádaat’įįłíí yee da’aṉii ágot’eehíí t’ąązhį’ ádaayiłsį; ");
INSERT INTO apwNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Bik’ehgo’ihi’ṉań bebígózį doleełíí ch’í’ṉah alzaago yídaagołsį, Bik’ehgo’ihi’ṉań dabíí bił ch’í’ṉah áyíłsįhíí bighą. ");
INSERT INTO apwNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Ni’gosdzáń alzaadí’ godezt’i’go Bik’ehgo’ihi’ṉań ye’at’éhi doo hit’į́į́ dahíí nłt’éégo bígózį, dahazhį’ binawod golííníí, ła’íí Bik’ehgo’ihi’ṉań nliiníí nt’é áyíílaahíí bebígózį; áí bighą áí nṉee nchǫ’go ánádaat’įįłíí doo nt’é bee bich’į’ ch’ídaagonowáh