﻿USE sofia;
DROP TABLE IF EXISTS sofia.apuNT_vpl;
CREATE TABLE apuNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES apuNT_vpl WRITE;
INSERT INTO apuNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Xesosi Teoso mereẽkiti itxaua. Uai aua Xesosi apika atokiriakorini uãka. Xosee inakori Xesosi iri atoko ĩkorapokoriti. Apraãoni, Taviini pakini Xesosi apika atokiriakorini atoko. Ininiã Xesosi Taviini, Apraãoni pakini imi atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ininiã ia atoko itxa: Kitxakapirĩka Apraão, Isaki iri. Isaki, Xakoo iri. Xakoo, Xotaa itariakorikata iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Xotaa, Péresi, Sera pakini iri. Inorona Tamara. Péresi, Ésirõ iri. Ésirõ, Arão iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arão, Aminatapi iri. Aminatapi, Nasoõ iri. Nasoõ, Sáomõ iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sáomõ, Póasi iri. Póasi inoro Haapi. Póasi, Opetxi iri. Opetxi inoro Hotxi. Opetxi, Xesee iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Xesee, Tavii iri. Tavii Isaeokini auĩte itxaua. Tavii, Saromão iri. Saromão inoro mitxi Oria ĩtanoro. Eereka Tavii takaro oa. ");
INSERT INTO apuNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saromão, Hopoão iri. Hopoão, Apia iri. Apia, Asa iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa, Xosapaa iri. Xosapaa, Xorão iri. Xorão, Osia iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osia, Xotão iri. Xotão, Akasi iri. Akasi, Esekia iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekia, Manasee iri. Manasee, Amõ iri. Amõ, Xosia iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Xosia, Xekonia itariakorikata iri. Iuasaaki ĩkorakanani kãkiti Isaeokini maĩkaãka. Papirónia tixinimoni anikaãkana. ");
INSERT INTO apuNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Papirónia anikikona atoko, Xekonia, Saratxieo iri. Saratxieo, Soropapeo iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Soropapeo, Apiotxi iri. Apiotxi, Eriakiĩ iri. Eriakiĩ, Asoo iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoo, Satoki iri. Satoki, Akĩ iri. Akĩ, Eriotxi iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriotxi, Ereasa iri. Ereasa, Mataã iri. Mataã, Xakoo iri. ");
INSERT INTO apuNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Xakoo, Xosee iri. Iua Xosee, Maria ĩtaniri. Xesosi, iuara Teoso Mereẽkiti itxaua. Inoro Maria. ");
INSERT INTO apuNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Apraão, iua ãkiri, imekaniri, apika mekaniri, apika mekaniri ãkiri, apika mekaniri apika mekaniri, apiko itxaãpota. Tavii auakasaaki, katosipeka pakini ninoa uãka. Eereka aua Tavii, Tavii ãkiri, imekaniri, apika mekaniri, apiko itxaãpota. Katosipeka pakini ninoa uãka. Iuasaakiika Xoteoakori anikaãka Papirónia tixinimoni. Ninoa mekaniriakori katosipeka inakasaaki, Xesosi iponaniãpeka. ");
INSERT INTO apuNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ia atoko itxapaniko Xesosi. Teoso mereẽkiti iponaniãkasaaki, Maria ominapatari Xosee. Oĩtaniriuatini apisapanika, omotokiãri amarini Erekari Matamatakoti sikakiti. ");
INSERT INTO apuNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Xosee uãkatari Maria kamari maerekati ãtikata. Atão inakarinoka kamakari iua, ininiã kona inirekari kãkiti imaropiretiniri oa kamixi onini. Kãkiti sauaki osiniã, Xosee !inirekaro opẽtauatini, kotxi erekari kamakari iua. Ininiã inirekari itakanapiniro oa, ixika kãkiti mimarotakaniã. ");
INSERT INTO apuNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ikara atoko inini ixiniremoni, Teoso nitiri iaxitikiri apoka itaponemoni. Ininiã itxa: —Xosee, Taviini apika mekaniri pite. Kona pipĩkapero Maria papakapini pĩtanoro ĩkapani, kotxi Erekari Matamatakoti, iuara kamixipeka txĩkitakaro. ");
INSERT INTO apuNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Auako oa ãkiri. Pitakauãkatariko Xesosi itxauako, kotxi imakatxakari kãkiti maerekani —itxa Teoso nitiri. “Xesosi” popĩkari sãkireẽ, iuatxikana, “Kãkiti Maerekani Makatxakakari,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Apikomoni Teoso nitiri txari: —Ikara atoko inakari auapeka, kotxi kitxakapirĩka Teoso sãkire sãpiretakari sãpiretapekari ikara sãkiretxi. ");
INSERT INTO apuNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Kitxakapirĩka ia atoko itxa: Hĩkenakotari. Sito kikikata masirĩkato mixiuatako. Auako oimi. Itakauãkataãka Emanoeo inakori —itxa Teoso nitiri Xoseemoni. “Emanoeo” popĩkari sãkireẽ “Teoso atekata aua.” ");
INSERT INTO apuNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Xosee merekasaaki, iua auikari Teoso nitiri sãkire. Ininiã ĩtanorouata Mariakata. ");
INSERT INTO apuNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Eereka amarini iponaniãkasaaki, Xosee takauãkatari Xesosi itxaua. Amarini iponaniini apisa iua !isirĩka Mariakata. ");
INSERT INTO apuNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Xesosi iponaniã Pereẽ inakori sitatxiti, Xotéia tõpa, Erotxi auĩtetxi inakasaakiua. Iuasaaki atokatxi pokĩkinimoni auakani sari Xerosareẽ sitatxitimoni Pereẽ takote. Iõriki imarotakani ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ininiã itxana kãkitimoni: —Naniparari amarini Xoteo auĩte inakariua? Ate itikapekaro iõrikite atokatxi pokĩkinimoni. Oa iõriki oerekaua auĩtetxi Apiananiri iponaniãpeka. Ininiã ate apoka uai akapotoreẽkiniua iua apisatoõ, kotxi Apiananiri itxaua —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Erotxi ikara ikenakoenetakasaaki, kona erekaxinireri. Kona inirekari ãti auĩtetxi apokini. Ininiã ikinimane Xerosareẽ auakani kona erekaxinirena, kotxi ninoa pĩkari Erotxi. ");
INSERT INTO apuNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ininiã iua apotiitana sasetotxi auĩteakori, kaiõkatsoparerini pakini. Ininiã Erotxi pimaãna: —Nanipa Teoso Mereẽkiti iponaniãko? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ninoa apakapapiretari: —Pereẽ sitatxiti, Xotéia tõpa aua. Ia atoko itxapaniko Teoso sãkire sãpiretakari iõkatsopatakiti kitxakapirĩka: ");
INSERT INTO apuNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Pereẽ sitatxiti auakani, Xotéia tõpa, hĩte sitatxine poiãori, iuaritika kona hĩpẽtauatape, kotxi hĩte sitatxineẽ iponaniãko Isaeokini auĩte. Kãkiti mĩkiikakari itxauako —itxa ninoa auĩtetxiakori Erotximoni. ");
INSERT INTO apuNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ininiã Erotxi akiritana ninoa iõriki imarotakani, ninoanani imisãkiretini ĩkapani. Ininiã ipimaãna: —Mitxipitipanika kirisaakipa hĩtikataro oa iõriki? —itxa ninoamoni. Ininiã ninoa sãpiretari. ");
INSERT INTO apuNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Iposo atoko iokanatana Pereẽmoni: —Hĩsako Pereẽmoni amarini hinitini ĩkapani. Hãpokasaakiri, hĩsãpiretano. Ininiã nota apaka sako, iua apisatoõ nikapotoreẽkiniua ĩkapani —itxa Erotxi. Txamari inirekari okiniri Xesosi, kotxi !inirekari ãti auĩtetxi auini. ");
INSERT INTO apuNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Erotxi sãkire ikenakotakana atoko, ipotorikana. Iõriki atokatxi pokĩkinimoni itikakitona ĩkiika. Anikana Xesosi auinimoni. Iuaãtaã oa iõriki iotoka. ");
INSERT INTO apuNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ninoa atamatakasaakiro iõriki, iteene ipoxokoniuatana. ");
INSERT INTO apuNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ininiã apokana aapoko. Ĩroãna. Apokarina amarini inoro Mariakata. Ininiã ikapotoreẽkauana Xesosi apisatoõ. Itxarina: —Apiananiri pitxaua. Aãuĩte pitxaua —itxana. Iposo atoko itiina imakatxakana. Ininiã imakatxakarina erekari imĩkitina auĩtetximoni isikakitina ĩkapani. Isikarina oro, ĩsẽso inakori, miha inakori pakini. Ĩsẽso, miha pakini kamariãro peerekari. ");
INSERT INTO apuNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ininiã eereka Teoso sãpiretana iõriki imarotakanimoni itaponeẽna: —Kona hĩkanapiriãpe Erotximoni —itxa Teoso ninoa taponemoni. Ininiã ninoa kanapiriãkasaaki auinimoni, ãti kimaporitimoni isana. ");
INSERT INTO apuNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Iõriki imarotakani sipeka atoko, Teoso nitiri iaxitikiri sãpiretari Xosee itaponemoni: —Paiamata. Põkitikaua. Panikari amarini, inoro apaka Exito tixinimoni. Himiteka. Kona hĩkanapiriãpe nota masãpiretakanisaakii, kotxi Erotxi nitari amarini okiniri ĩkapani —itxa Teoso Xoseemoni. ");
INSERT INTO apuNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ininiã Xosee: —Nisapitikako —itxa. Ininiã iua ĩkanõkatika Xosee õkitikaua. Aiamata Exito tõpamoni isini, amarini anikini ĩkapani. Ininiã imimitekari amarini inorokata Exitomoni. ");
INSERT INTO apuNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Erotxi ipinakasaaki, iuasaaki ikanapiriãko. Kona ikanapiriã Erotxi ipinini apisa. Ia atoko itxapaniko kitxakapirĩka Teoso sãkire sãpiretakari sãpiretakiti: Nakiritariko namarite Exito tixini itakanapini. ");
INSERT INTO apuNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erotxi imarotakasaakiri iõriki imarotakani sipe inakasaaki, !imisãkiretaikarina iua, ininiã iua omanãkarauata. Ininiã amarini ipikananipeka inakaniua, apaka axapitipanika inakaniua, imakinikana okãkitaka Pereẽ sitatxitiã auakani. Ikara atoko itxa, kotxi iõriki imarotakani sãpiretari ipikananipeka oa iõriki tokiã. ");
INSERT INTO apuNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kitxakapirĩka Teoso sãkire sãpiretakari Xeremia inakori sãpiretakiti iaõka auape iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Iua txari: Hamaa sitatxiti ikenakotaãkako ãtsaãtxi. Hakeo atoko sitoakoro txiapatako oimiakori matinani. !Onirekari kãkiti mĩkapiritiniro oa, kotxi oimiakori kona auaika. ");
INSERT INTO apuNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erotxi ipinaka atoko, Xosee Exito tixini auakasaaki, Teoso nitiri misãkiretari iua itaponemoni. ");
INSERT INTO apuNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Itxari: —Põkitikaua, pimikanapiriãri amarini, inorokata Isaeo tixinimoni. Amarini kinirão okaka inakani kona auaika —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ininiã Xosee mikanapiriãri amarini, inorokata Xotéia tõpamoni, Isaeo tixinimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Txamari imarotakasaakiri Akirao, Erotxi ãkiri auĩtetxi ininiua irini tikini, Xosee pĩkari Xotéia tõpa auini. Ininiã Teoso nitiri iuaĩkana itaponemoni sãpiretari ãtiãtaã isini ĩkapani. Ininiã Xosee, Maria, Xesosi pakini sari Kariréia tõpamoni Isaeo tixini. ");
INSERT INTO apuNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nasaree sitatxiti kaikota itxana. Ia atoko itxa kitxakapirĩka Teoso sãkire sãpiretakani sãpiretakiti iaõka inini. Ninoa txari: Nimereẽkiti, Nasareekiri itxauako. ");
INSERT INTO apuNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Eereka Xesosi aneẽpe. Iuasaaki Xoão kapatxisareri, ãparaã makipakaniãtaã Xotéia tõpa aua. Iuaã iua oerekari Teoso sãkire kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Iua txa: —Himaerekani hĩtakanapako, kotxi Teoso mereẽkiti paĩtiki apokako iua ikinipoko auĩte ininiua ĩkapani —itxari Xoão. ");
INSERT INTO apuNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kitxakapirĩka Isaía inakori, Teoso sãkire sãpiretakari, sãpiretapekari Xoão pirena. Itxari: Auako kiki ãparaã makipakaniãtaã. Isãpirenauatako. Itxariko: “Hõeretariko kimapori Apiananiri apokini apisapanika. Itĩkaãpo erekari hĩkamako iua napini ĩkapani,” itxa Isaía kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Xoão takari mãkatxi kamero piti kamakori. Kamero kãkiti pira. Ipakiotsere aamata kamakori. Inikari txĩtxiri. Itximari mapaã ĩtopakero. ");
INSERT INTO apuNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kãkiti Xerosareẽkini, ikinimane Xotéia tõpakini, ikinimane Xotão tinikata auakani pakini sari ikenakotinirina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Iuaã ninoa sãpiretari Teosomoni maerekati ikamakitina, imaerekani imakatxakini ĩkapani. Eereka iua patxisatana Xotão uiniti. ");
INSERT INTO apuNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Txama Xoão atapakasaakina pariseoakori, satoseoakori pakini apokini iuamoni ipatxisatikona ĩkapani, iua txana: —Imini katsiiri anaakorirai hĩte. Teoso misiritapitikai himaerekani xika. Himitekini !auari. Hinirekari hĩpatxisatiko, txamari !hinirekari hĩtakanapiniri himaerekani. ");
INSERT INTO apuNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hinirekiniãri himaerekani hĩtakanapini, ininiã hĩkamariko erekari. Ikara atoko ininiã, hõerekari Teoso atão hĩtakanapiniri himaerekani. ");
INSERT INTO apuNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hãkixiniremoni !hĩxinikapiri: “Teoso apakapapitikauako ate, kotxi ate atokirini Apraãoni txaua,” !hĩtxapeko. Ari, nota sãpiretai hĩte, Teoso nirekiniãri, iposotari ia kai soroã Apraãoni mekaniriakori ikamini. Kona Apraãoni posotari anikinii Teosomoni. ");
INSERT INTO apuNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aamina maereka iriti atoko hĩtxa. Teoso iposopeka hĩte ixipokini. Kãkiti auari ikitaite kauanari aamina maereka iriti itokini ĩkapani. Ikinika aamina maereka iriti tokaãkako. Xaminaã oka inaãkanako. Teoso kamakiti iua atokokana itxa. Ininiã Teoso kitaite kauanapeka, aamina kotsa sauakiko tĩkane. Iua atokokana ininiã, Teoso aiamatapeka hĩte ixipokini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","—Hĩte nipatxisata ãparaaã. Hĩpatxisatiko oerekari maerekati hĩkamakiti hĩtakanapapeka. Nota tikini apoãkari patxisataiko hĩte Erekari Matamatakotiã, xaminaã pakini. Apiatakari itxaua iua. !Apakata iua takote napokini ikiti mata nimakatxakini ĩkapani, kotxi iua apiata. Nota poiãoka. Imakatxakari himaerekani, itxiko metao ãki auakari arikini atoko. ");
INSERT INTO apuNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Katakareri ãpokari ahoisi otãta imakatxakini ĩkapani. Otãta arikaãka. Oki nĩkataãka ikiena nĩkatikoãtaã. Iua atokokana Teoso nĩkatariko kãkiti erekarini. Maerekati kamakani arikaãkako xamina maxipoãkatiã —itxa Xoão. ");
INSERT INTO apuNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Iuasaaki Xesosi potorika Kariréia tõpa. Isari Xotão uinitimoni, Xoão patxisatiniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Txamari Xoão txari Xesosi: —Pite nirekatari nota patxisatinii? !Apakata, kotxi pitemoni maerekati !auari. Notara nirekari pite patxisatinino nota —itxa Xoão. ");
INSERT INTO apuNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Xesosi apakapapiretari: —Apakatapitika pipatxisatinino. Uatxa akamariko ikinika Teoso nirekaãkiti —itxa. Ininiã Xoão: —Ateeneka. ");
INSERT INTO apuNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Eereka ipatxisataãka atoko ikanĩkiĩta imiriĩ. Iuasaakipeka iaxiti takaka. Ininiã kãkiti atapari Erekari Matamatakoti katxakaãpotini kamoa atoko inakari. Xesosimoni oãpoka. ");
INSERT INTO apuNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eereka Teoso sãkirauata iaxiti: —Pite namarite, nitiretakiti, napokaerekatai, kotxi ninirekakiti pikama —itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Erekari Matamatakoti anikari Xesosi ãparaã makipakaniãtaã Satanasi atamakaerekatiniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iuaã Xesosi takanapari inipokotini Teoso imisãkiretini ĩkapani. Koarẽta pokamara, koarẽta ĩkanõkati pakini itakanapari inipokotini. Ininiã inatxikatani iuani. ");
INSERT INTO apuNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ininiã iuasaakiika Satanasi apoka Xesosimoni. Iua katamakaerekareri itxaua. Itxari: —Pite Teoso ãkiri pininiãua, ininiã ere kai soro komiri pitxĩkitaka —Satanasi txari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Xesosi apakapapiretari: —Kona nikamari pite paniãtakiti, kotxi Teoso sãkire iõkatsopatakori txari: Kona komirinanini txĩkitakari kãkiti ãtipirika auini tĩkane. Ikinika Teoso sãkirera txĩkitakari kãkiti ãtipirika auini tĩkane —itxa Xesosi Satanasimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Eereka Satanasi anikari Xesosi Xerosareẽmoni. Iua sitatxi akiritaãka Teoso nakiti. Satanasi anikari Xesosi Teoso misãkiretiko aikotimoni apiata õtano tsokitiri nopini. ");
INSERT INTO apuNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ininiã Satanasi txari Xesosi: —Teoso ãkiri pininiãua, pokaua xiti. Ininiã ikinipoko kãkiti imarotariko Teoso ãkiri pininiãua, kotxi Teoso sãkire iõkatsopatakori txari: Teoso iokanatanako initiriakori iaxitikini pite inĩkatinina tĩkane. Ninoa maĩkai pimapinakani tĩkane, ininiã pikarouatini !auari. Kona kai soro karotari pikiti, —itxa Satanasi. ");
INSERT INTO apuNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Xesosi apakapapiretari: —Teoso sãkire iõkatsopatakori apaka txari: Kona patamakaerekatapiri Apiananiri piTeosone. ");
INSERT INTO apuNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Eereka Satanasi anikari Xesosi ãtiãtaã iuaĩkana. Itano xiratarimoni anikari. Iuaã Satanasi oerekari ikini itixiti, ikinika tiitxiti iuaã auakari pakini. ");
INSERT INTO apuNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ininiã itxa: —Pikapotoreẽkiniãua nota apisatoõ piteosonetinino, ininiã ikinika nisikaiko —itxa Satanasi. ");
INSERT INTO apuNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Xesosi apakapapiretari: —Konapitini. Pisipeka Satanasi. Teoso sãkire iõkatsopatakori txari: Apiananiri piTeosone, iuanokara piteosoneta. Iua ĩkapaninokara piparĩkauatako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ininiã Satanasi takanapa txari iua. Ininiã Teoso nitiriakori iaxitikini apoka Xesosimoni inĩkatinirina ĩkapani, kotxi itapara !auaika. ");
INSERT INTO apuNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Xesosi kenakoenetakasaakiri Xoão kapatxisareri kateia ãki takiko, isari Kariréia tõpamoni. Nasaree sitatxitimoni isa. ");
INSERT INTO apuNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ininiã eereka itakanapari Nasaree sitatxiti. Kapanaoõ sitatxitipeka aua itxa. Kapanaoõ, Kariréia poa takote, apaka Seporõ, Natarii pakini tõpati takote. ");
INSERT INTO apuNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kitxakapirĩka Isaía, Teoso sãkire sãpiretakari sãpiretapekari, iuaã Xesosi auako. Ia atoko Teoso sãkire txapeka: ");
INSERT INTO apuNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Seporõ, Natarii pakini tõpati ipoa mitari takote, Xotão uiniti ipiniã. Kãkiti takauãkatari iua itixi, Kariréia tõpa. Xoteo minakaniua tixine itxaua. Iuaã Erekari apokako. ");
INSERT INTO apuNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ninoa kãkiti, ipiã auakani, !imarotari Teoso. Ipĩkaniãtaã ninoa auanãta. Ninoa atamatariko tirikapi. Ikamara mitari. Iua tirikapi iopinipokotako ipiã auakani sauaki. Ikara atoko itxa Isaía kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Xesosi apokasaaki Kapanaoõ sitatxiti, imipotorikari oerekarauatini. Ia atoko itxa: —Himaerekani hĩtakanapa, kotxi iposope Teoso hĩauĩte ininiua —Xesosi txana ikinipoko kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Xesosi Kariréia poa tiniã itĩpokotakasaaki, itikari ipi kiki, Simão Petro inakori, itari Ãtree inakori pakini. Itakanãtarina hetxi. Kokatsaãriti itxauana. ");
INSERT INTO apuNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ininiã Xesosi akiritana ninoa: —Masa notakata. Hĩtakanapariko hõkatsaãtini parĩkatxiti. Noerekaiko hĩte Teoso sãkire hõerekini ĩkapani, kãkiti imarotini ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ininiã iuasaakiika ninoa takanapari okatsaãtinina. Xesosikata sa itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Apikomoni itĩpokotakasaaki, atamatana Txiako, Xoão pakini. Sepeteo anaakori itxauana. Ninoa irikata kanauaã auanãta. Ihetxina iotsaãnãtana. Ininiã Xesosi akiritana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Iuasaakipeka itakanaparina iri, kanaua pakini. Xesosikata sa itxana imoianatinirina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Xesosi sari ikini Kariréia tõpamoni. Aiko Xoteoakori apotiitiniãtaãua isa. Iuaã isãpiretana Teoso iokanapirena erekari, Teoso kãkiti auĩte inini pirena. Apaka erekapeka itxĩkitakana amianatakani. ");
INSERT INTO apuNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Xesosi kamakiti, apaka isãpiretakiti, iaripiretapeka ikinika Síria tixini. Ininiã kãkiti minana itomaneri amianatakani iuamoni. Ikini sereti amianari auakini sari iuamoni. Kãkiti maerekati matamatakoti Satanasi nitiri auaĩtotakiti apoka iuamoni. Apaka kãkiti mapitxiritakani apoka. Apaka titinanakakari amianariti auakini apoka. Apaka kãkiti maposota tĩpokotakani pakini apoka Xesosimoni. Ikinikana erekape itxĩkitakana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Itomaneri sari iua tikini. Kãkiti Kariréiakini, tesi pakini sitatxitikini, Xerosareẽkini, kãkiti Xotéia tõpakini, Xotão uiniti ipiniãkini pakini sari iua tikini. ");
INSERT INTO apuNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Xesosi itomaneri kãkiti atapakasaaki, ixirata nopini isa, topãka itxa oerekarauatini ĩkapani. Imoianariakori apotiitaua iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Iuasaaki oerekana ia sãkiretxiti: ");
INSERT INTO apuNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Teoso takari erekari kãkitimoni, ia atoko inakanimoni. Ninoa nirekari Teoso nireẽkiti ikaminina, iuaritika imarotarina !iposotarina Teoso nireẽkiti ikaminina, ininiã amanaãrina Teoso sikaposotiiretinina ninoa. Teoso takari erekari kãkiti ikara atoko inakanimoni. Ninoa sari Teoso auĩtetxi ininiãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","—Teoso takari erekari kãkitimoni, ia atoko inakanimoni. Mitxi ninoa txiapata imaerekanina xika. Ininiã eereka Teoso mĩkapiritana ninoa, amarini mĩkapiritiko atoko. ");
INSERT INTO apuNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","—Teoso takari erekari kãkitimoni, ia atoko inakanimoni. Pataparaxinirena ninoa, iuaritika !itxitarina ãti. Iamonĩkarina ãti. Teoso sikapanikariko ikinika itixi ikara atoko inakanimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","—Teoso takari erekari kãkitimoni, ia atoko inakanimoni. Ninoa iteene nirekari erekarinoka ikaminina. Nipokori inirekinina atoko, ãparaã inirekinina atoko, ninoa iteene nirekari erekari ikaminina. Ininiã Teoso sikana ninoa ikinipoko erekari inirekakitina. ");
INSERT INTO apuNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","—Teoso takari erekari kãkitimoni, ia atoko inakanimoni. Ninoa amonĩkari ninoa misiritakani, ininiã iua atokotxikana Teoso amonĩkanako ninoa kaamonĩkarerini. ");
INSERT INTO apuNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","—Teoso takari erekari kãkitimoni, ia atoko inakanimoni. Ninoa kamari Teoso nireẽkitinoka, ininiã ninoa aõkitariko Teoso. ");
INSERT INTO apuNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","—Teoso takari erekari kãkitimoni, ia atoko inakanimoni, kauaĩrerinimoni. Ninoa parĩkauata neenamatxi xipokini ĩkapani. Ininiã ninoa akiritaãkako Teoso anaakori. ");
INSERT INTO apuNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","—Teoso takari erekari kãkitimoni, ia atoko inakanimoni. Ninoa kamari erekari, ininiãkara apanakini kãkiti misiritana. Ninoa erekari kamakani auako Teoso auĩtetxi ininiãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Teoso takari erekari hĩtemoni, apanakini misiritakasaakii, imisãkirepiretakasaakii, aãpirena ikamakasaaki hĩtemoni nota sãkire hãuikini xika. ");
INSERT INTO apuNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Poxokonoka hĩtxako, kotxi Teoso sikai hĩparĩka ĩki ito, itixine hãpokasaaki. Hĩte misiritiko atokokana Teoso sãkire sãpiretakani kitxakapirĩka misiritaãka, ininiã hĩpoxokoniuatako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Iuaĩkana Xesosi sãkirauata: —Iõkira erekaro atoko hĩtxaua ikinimane ĩkapani. Iõkira matxoatapeka onakasaaki, ininiã !apakata otxoa kanapiriini iuaĩkana. Ininiã oõkaãka. Kãkiti kitakaro, kotxi kona otxaika. ");
INSERT INTO apuNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Tirikapi atoko hĩtxaua ikinimane kãkiti ĩkapani. !Hĩposotari hĩkipatiniri sitatxi xirata nopini auakari, kotxi ikinimane atamatari tirikapi. ");
INSERT INTO apuNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kãkiti !itakari tirikapi kopiti ãki. Itakarina itano ikini aapokotxiti iopinikini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Iua atokokanera hĩtxako, kotxi erekari hĩkamakiti tirikapi kamara atoko itxa. Erekarinokara hĩkamako. Ininiã apanakini atamatari erekari hĩkamakiti. Ininiãra itxarina aĩri iaxitikirimoni: “Peerekai pite.” ");
INSERT INTO apuNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Iuaĩkana Xesosi sãkirauata: —Kona hĩtxape: “Xesosi xipokariko Teoso sãkire Moisesini apakapakiti,” kona hĩtxape. Apaka, “Kitxakapirĩka Teoso sãkire sãpiretakani sãpiretakiti Xesosi xipokako,” kona hĩtxape. Kona ikara inakari !nixipoka. Nota ina ikinipoko ninoa sãpiretakiti nikamini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Atãopitika ikinika Teoso sãkire apokako. Kona xatiki Teoso sãkire iõkatsopatakori kona xipoka. Iaxiti, itixi pakini xipokini apisa Teoso sãkire !ixipoka. Apokapitikako imakinika isãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Teoso sãkire ipaniãtakiti apiari aua, apaka poiãori aua. Kãkiti makamakaniãri ikinika Teoso sãkire, oerekiniãri apanakini ikinika Teoso sãkire imakamakani ĩkapani, poiãori itxaua Teoso auĩtetxi ininiãtaãua. Ãti kãkitipekana, ikaminiãri ikinika Teoso sãkire, oerekiniãri apanakini ikinika Teoso sãkire ikamini ĩkapani, apiari itxaua Teoso auĩtetxi ininiãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ia nisãpiretai. Kaiõkatsopareriakori, pariseoakori pakini !ikamari atão inakari Teoso nireẽkiti. Ininiã hĩte kaminiãri ninoa atokotxikana, !hãuiritaãka hiĩroini Teoso auĩtetxi ininiãtaãua. Atão inakari Teoso nireẽkiti hĩkaminiã, hiĩroãpitika iuaã. ");
INSERT INTO apuNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Hĩte imarotari kãkiti kitxakapirĩka sãpiretaãka. Ia atoko inaãka: “Kona apanakini hõkape. Kokaniri anikaãkako imisiritikomoni,” inaãka kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Uatxa apikomoni nota sãpiretaiko hĩte. Maxikatiĩka pomanatiniãri pitari, panikaãkako pimisiritikomoni. Pite napetiniãri pitari, ininiã auĩtetxiakori misiritapitikai. Pakiritiniãri pitari: “Kiĩkitei,” ininiã pimisiritiko paĩtiki apokako. Nota txai hĩte, kona erekari kokaniri. Iua atokokana kona erekari hinaperauatini. Hinaperauatiniã, ininiã maerekani misiritikoãtaã hĩsapitikako. ");
INSERT INTO apuNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","—Ininiã hĩsikasaaki Teoso apisatoõ hĩsikakiti hĩsikini ĩkapani, iuasaaki hĩxinikari hĩtari homanatakiti. ");
INSERT INTO apuNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Iuasaakiika hĩtakanapariko hĩsikakiti iuaã hĩsikiniri apisa. Hĩsako katimaritika homanatakitimoni. Himisãkiretari, homanãkare hĩxipokini ĩkapani. Iposo atoko kanapiriã, hĩsikakiti tĩkane sika hĩtxako Teosomoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Iuaĩkana Xesosi sãkirauata: —Kãkiti kinirão apoĩtakiniãi, ininiã pimisiritiko mereẽkarimoni iua anikinii apisapanika, katimariã pisa iuamoni. Pimisãkiretari iua, kotxi pimisiritiko mereẽkari sikaiko pite pimisiritakirimoni. Ininiã eereka iua takai kateia ãki. Iuaã pikaikotako. Ininiã apisapanika pimisãkiretariko iua pomanatakiri. ");
INSERT INTO apuNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Atão nisãpiretai, kona posipikari kateia ikinika pimisiritiko mereẽkari paniãtakiti pimiĩkitxitakanisaaki —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Xesosi apikomoni sãkirauata: —Hĩte imarotapekari kitxakapirĩka sãpiretakori: “Pĩtanoro minakotokatika kona pisirĩkape.” ");
INSERT INTO apuNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kitxakapirĩka ikara atoko itxama. Nota sãpiretaiko hĩte apikomoni. Sito atamatakari kinirão oakata sirĩkaka inakari, iuara kamapekari maerekati ãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kona pauiritapiri maerekati pikamini txĩkitaãkari pitekata ikaikotini. Patamatakiti txĩkitakiniãi maerekati pikamini, pimakatxakari poki, oka pitxari, kotxi maerekati pikaminiã, maerekani misiritikoãtaã pokaãkako. Apiaerekata Teosokata ãtipirika pauini ãti pokinoka pauini. ");
INSERT INTO apuNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Piuako pikikomoni auakari txĩkitakiniãi maerekati pikamini, ininiã pisauaka, oka pitxa, kotxi maerekati pikaminiã, maerekani misiritikoãtaã pokaãkako. Apiaerekata mauakotikai pauini ãtipirika Teosokata. Kona pauiritapiri maerekati kaikotini pitekata. Pitakanapariko maerekati. ");
INSERT INTO apuNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Kitxakapirĩka ia atoko itxa sãkiretxi: Pĩtanoro pitakanapiniã, aãtsopa pisika oamoni ĩtanorotxi takanapiko aãtsopati. ");
INSERT INTO apuNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Iuaritika nota sãpiretaiko hĩte, !hĩtakanapaperoko pĩtanoro. Pitakanapiniãro, ininiã maerekati pikamapitika, kotxi eereka oa atxiĩti nirekakari ãti kiki. Ininiã iuasaaki oa kamari maerekati apaka pite xika. Apaka oa takakari kamari maerekati. Apakata pitakanapiniro pĩtanoro, ãtikata osirĩkiniã —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Iuaĩkana Xesosi sãkirauata: —Hĩte imarotapekari kitxakapirĩka sãkiretxiti. Ia atoko itxapaniko: “Hĩkamariko imakinika hĩkamaenetakiti. Hĩkamariko hĩkamaenetakiti Teoso ĩkapani,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Notara sãpiretai hĩte apikomoni: “Nikamapitikariko,” pinakasaaki, !pakiriuãkatapiri Teoso tixine uãka, kotxi iuaã Teoso auĩtetxi ininiãtaãua. “Nikamapitikariko,” pinakasaaki, kona apikomoni pakiritape. ");
INSERT INTO apuNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","“Nikamapitikariko,” pinakasaaki, !pakiriuãkatapiri itixi uãka, kotxi Teoso uai aua apaka. “Nikamapitikariko,” pinakasaaki, !pakiriuãkatapiri Xerosareẽ uãka, kotxi auĩtetxi Apiananiri sitatxine itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Nikamapitikariko,” pinakasaaki, !pakiriuãkatapiri pikii uãka, kotxi !apakata pitxĩkitakiniri piãko pomama inini, kasarori inini. Ãtika piãko kona piposotari pitxĩkitakiniri kasarori inini, pomamari inini. ");
INSERT INTO apuNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Ari,” pinakasaaki, pikamapitikariko. “Kona,” pinakasaaki, kotxi kona piposotari pikaminiri. Kona ãti sãkiretxi !pikamape. Maxikatiĩka kamakori sãkiretxiti Satanasi sãkire itxaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Xesosi oerekarauatapanika: —Ia atoko kitxakapirĩka sãkiretxiti: “Neenamatxisaaki ãti makatxakiniãri poki, pixikatxitariko. Iuasaaki pimakatxakariko iua oki apaka. Pitsiriĩ pataka ãti kãkiti xika, pixikatxitariko. Iuasaaki iua tsiriĩ apaka pimapatakako,” itxa sãkiretxi kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Txamari nota sãpiretaiko hĩte apikomoni. Kona hĩxikatxitapiri maerekati hĩtemoni auakasaaki. Ãti aritiniãri pitoõ, ininiã pikirioka ipinitoõ iaritini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Atxiĩti ãti nirekari anikinii pimisiritiko mereẽkarimoni, kotxi iua nirekari pite sikiniri pimãka iuamoni iua txineirote pimasikakani xika. Ininiã anikinii apisapanika, pisikariko pimãka inirekakiti, apaka apikomoni ãti pimãka. Ikara atoko hĩkamako. ");
INSERT INTO apuNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ia ãti sãkiretxiti: Ãti paniãtiniãi itii panikini ãti õti, ininiã ipi õti panikari itii. Poerekariko pitiraõki. ");
INSERT INTO apuNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Atxiĩti ãti amanaãi pitii, ininiã pisikariko iuamoni inirekakiti. Iua amanainiãi pitii “Akamoni iuaĩkana !nisikai,” ininiã iuasaaki pisikariko iuamoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Iuaĩkana Xesosi sãkirauata: —Hĩkenakotapekari ia sãkiretxiti: “Hĩtiretariko hinirimane. Homanatariko himokaiakari.” Ikara atoko kitxakapirĩka auari. ");
INSERT INTO apuNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ikara atoko itxama. Nota sãpiretaiko hĩte ipinimoni. Kona homanatapiri himokaiakari. Hĩtiretariko iua apaka. Hamanaãri Teoso hĩte omanatakani erekari isikini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Apakatapitika amokaiakarimoni erekari akamini, kotxi Teoso kamari atokatxi kãkiti erekarini auiniãtaã iopinikini ĩkapani, apaka maerekani auiniãtaã iopinikini ĩkapani. Iua iokanatari ãparaã atão inakari kamakanimoni, apaka atão minakati kamakanimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hĩte tiretakaninani hĩtiretiniã, kinirepa Teoso sikari erekari hĩtemoni hinirimanenokara hĩtiretakasaaki? Kotxi kãkiti maerekati kamakani apaka tiretari ninoa tiretakani. ");
INSERT INTO apuNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hĩte misãkiretakaninani himisãkiretiniã, kãkiti Teoso mimarotakani atoko hĩtxa, kotxi ninoa misãkiretakani imisãkiretana. ");
INSERT INTO apuNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ikinipoko hĩri iaxiti auakari kamakiti erekari, ininiã iua atokokana hĩtxĩkitakariko ikinipoko hĩte kamakiti erekari —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iuaĩkana Xesosi sãkirauata: —Erepaniko. Erekari pikamakasaaki, kona pikamapiri piuikiniua ĩkapani, erekari pikamakiti apanakini imarotini ĩkapani. Pikaminiãri erekari apanakini apokaerekatinii ĩkapani, kona papakapari piparĩka ĩki iaxiti, aĩri iaxiti auakari sikakiti. ");
INSERT INTO apuNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aua kãkiti ia atoko inakari. Ikamakiti atxiĩti erekari, txamari ixinikakiti kona erekari. Kãkiti ikara atoko inakari sikarauatakasaaki minakati matiitimoni aiko Xoteo apotiitiniãtaãua, apaka mapara kãkiti napiniãtaã, inirekarina ikinimane itikiniri erekari ikamakitina. Inirekarina kãkiti iuikinina. Ikara atoko !pitxape minakati matiitimoni pisikarauatakasaaki. Pixinikariko ia: Ninoa apakapapekari ikinika erekari kãkiti sikakiti, txamari !apakaparina erekari Teoso sikakiti. ");
INSERT INTO apuNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pisikarauatakasaaki minakati matiitimoni, kona pauiritapiri piuako pisaneremoni auakari imarotiniri piuako pikikomoni auakari sikakiti. ");
INSERT INTO apuNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ikara atoko ininiã, pitenani imarotari pisiãkiti. Piri iaxitikiri, ikinipoko atamatakari, iĩkitxitaiko kãkiti apisatoõ —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Iuaĩkana Xesosi sãkirauata: —Teoso himisãkiretakasaaki, kona hĩkamapiri kamisirienereri atoko hinini. Ninoa potxitari itiminina aiko Xoteo apotiitiniãtaãua, kimaporiã apaka, Teoso imisãkiretini ĩkapani. Ininiã ikinimane itikana. Hĩxinikari. Ninoa apakapapekari poxokonitxi uai ĩkorapokoriti auakari. Txamari ninoamoni atão poxokonitxi !auari. ");
INSERT INTO apuNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Teoso pimisãkiretakasaaki, pisa pitenani auiniãtaã. Kona pauiritapiri ãti kaikotini pitekata Teoso pimisãkiretakasaaki. Iuaã pimisãkiretari piri matamatakoti. Iuaã iua atamataiko pite. Eereka isikaiko erekari iaxitikiri. ");
INSERT INTO apuNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Teoso pimisãkiretakasaaki, pimixinikariko pisãkire. Maxikatiĩka kona pisãkirauatape iuakata. Teoso sãkire mauiãkati xinikari Teoso kenakotiniri isãkire kotxi kaiãori isãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ikara atoko !pikamape pimisãkiretakasaakiri iua, kotxi pisãkirauatini apisapanika Teoso imarotapekari pinirekakiti. ");
INSERT INTO apuNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ia atoko hĩtxako Teoso himisãkiretakasaaki: ");
INSERT INTO apuNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Anirekari ikini itixiti auakani auĩtetinii pite. Pite tixine pinireẽkiti kamiko atokokana, anirekari pinireẽkiti kamiko ĩkorapokoriti, ");
INSERT INTO apuNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nipokori ikiniõtika pisikauako. ");
INSERT INTO apuNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pimaxinĩkaretariko maerekati akamakiti. Maerekati atemoni kamakori amaxinĩkaretini atokokana pimaxinĩkaretariko. ");
INSERT INTO apuNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kona panikapeua aãtaerekatikomoni. Pisikakauako ate, maerekati sauaki aãuakasaaki. Ikara atoko piposota, kotxi pitenanira auĩtetxi txaua. Pitenanira kaposotiire. Ãtipirika peerekai pite. Ameẽ.” Ikara atoko hĩtxako Teosomoni. ");
INSERT INTO apuNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","—Pimaxinĩkaretiniãri maerekati ãti kamakiti pitemoni, ininiã piri iaxiti auakari maxinĩkaretari maerekati pite kamakiti apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pimamaxinĩkaretakaniãri maerekati ãti kamakiti pitemoni, ininiã piri iaxitikiri kona maxinĩkaretari maerekati pite kamakiti apaka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Iuaĩkana Xesosi sãkirauata: —Aua kãkiti ia atoko inakari. Ikamakiti atxiĩti erekari, txamari ixinikakiti kona erekari. Kãkiti ikara atoko inakari takanapari inipokotini Teosokata isãkirauatini ĩkapani. Txamari ninoa nirekari ikinimane imarotiniri itakanapinirina inipokotinina, kãkiti iuikinina ĩkapani. Ininiã ninoa matinaniuata itooãna ikara kãkiti imarotini ĩkapani. Atão nitxai, ninoa apakapapekari ikinika erekari kãkiti sikakiti, txamari !apakaparina erekari Teoso sikakiti. Kona ikara atoko !pitxape nipokori pitakanapakasaaki Teoso pimisãkiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Hĩte ikara atoko !hĩkamape. Hinipokotini hĩtakanapakasaaki Teoso himisãkiretini ĩkapani, hãrokatoõtaua. Hõeretari hiãko. ");
INSERT INTO apuNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ininiãkara apanakini !imarotari hĩtakanapiniri hinikini. Ininiã hĩri matamatakoti, iuananira itikariko hĩkamakiti, apanakini mimarotakiniti, ininiã isikaiko hĩparĩka ĩki —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Iuaĩkana Xesosi sãkirauata: —Maxikatiĩka kona papotiitapiri pitiretakiti uai auakari, kotxi atxiĩti kamara nikari pitii. Atxiĩti oerẽkata. Atxiĩti kiĩtiriri ĩtirĩkari iua. ");
INSERT INTO apuNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ikara atoko kona pikamape. Papotiitariko pitiretakiti Teoso tixineẽ, kotxi iuaã !auari kamara. Iuaã tiitxi !oerẽkata. Kona ixipoka. Kiĩtiriri !ĩtirĩkari iua. ");
INSERT INTO apuNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pitiretakiti auiniãtaã, iuaã pixinikapika. Iuaã pinirekari pauini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Poki tirikapi atoko itxa piĩto ĩkapani. Poki ereka inakasaaki, ipinikare aua pãkixinireẽ, ininiã pinireẽkiti imakinika erekari. Erekarinokara patamatiniã, erekari pixinire. ");
INSERT INTO apuNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Txamari poki oerekasaakii maerekati pikamini, ipiã apoka pãkixiniremoni. Iuasaaki tirikapi kamara na xatiki !auari pitemoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Iuaĩkana Xesosi sãkirauata: —!Apakata kãkiti parĩkauatini ipi iauĩtena ĩkapani, kotxi atxiĩti ãti omanata, ãti itireta. Atxiĩti ãti apokaerekata, ãti inorita. Iua atokokana kãkiti kona posotari iparĩkauatini tiitxi ikinipoko iamotini ĩkapani, Teoso ĩkapani iparĩkauatakasaaki. !Apakata piauĩtetiniri Teoso, txineiro piauĩtetakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Ininiã nitxai: Pinirekari nipokori, iãriã pakini auãki pinini ĩkapani. Apaka pinirekari mãkatxi piĩto ĩkapani. Ikara pinirekini xika maerekaxiniretika kona pitxape. Erekari nipokori. Apiaerekata pixinire. Erekari mãkatxi. Apiaerekata piĩto. Ininiã ãtipirika !pixinikapiri nipokori, mãkatxi pakini pinitini. ");
INSERT INTO apuNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kona pipĩkarauatape nipokori poião auakasaaki. Pixinikariko kotipiriki. Kona ninoa takarauata. Kona apotiitari ikiena. Kona ipotetari ikiena. Iuaritika piri iaxitikiri sikakienatana ninoa. Ininiã ninoamoni nipokori !ixipoka. Teoso apia xinikai hĩte. Ininiã kona pipĩkarauatape. ");
INSERT INTO apuNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kinirepa maerekaxiniretinoka pitxa? Pimaerekaxinirene !itxĩkitakai apikomoni ãti oara pauini. ");
INSERT INTO apuNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—Kinirepa maerekaxiniretinoka pitxa pimãka pinirekini xika. Aãui pixinikako. Kona aãui parĩkauata. !Ikamari imãka, iuaritika aãui peereri. ");
INSERT INTO apuNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kitxakapirĩka auĩtetxi Saromão inakori, iteene katiiri itxaua. Kaiãori imãka ereri, iuaritika apia ereri ikinika aãui. ");
INSERT INTO apuNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Aãui !okanani aua. Uatxa aua. Katana ikatikata iotikaãka. Iuaritika Teoso nĩkatari aãui. Ininiã apiata inĩkatai hĩte. Ikamamãkatapitikai. Poiãonoka hĩte auikari Teoso sãkire. Ikara xika maerekaxiniretinoka hĩtxa. ");
INSERT INTO apuNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","—Ininiã maerekaxiniretinoka kona hĩtxape. “Kipa ninika? Kipa niãta? Nãpa napokari mãkatxi?” kona hĩtxape. ");
INSERT INTO apuNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Teoso sãkire mauiãkani maerekaxiniretinoka itxana ikara atoko. Piri iaxiti auakari imarotari pinirekaãkiti. Ininiã maerekaxiniretika !pitxape. ");
INSERT INTO apuNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Merepitipanika pinirekariko Teoso piauĩte ininiãua. Iua nireẽkiti pinitako, ininiã atão inakarinoka pikamako. Ikara atoko inakari pikaminiã, pite nirekakiti apaka isikaiko. ");
INSERT INTO apuNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Maerekaxiniretinoka kona pitxape katana pinirekakiti pixinikini xika. Pinirekakiti auapitikako katana, iuaritika mitxipanika kona pixinikapiri ikara maerekaxiniretika, kotxi ikiniõtika aua ikara atoko inakari —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iuaĩkana Xesosi sãkirauata: —“Kona erekari pikamakiti,” kona pitxape ãtimoni, ininiãkara Teoso kona txai pite: “Kona erekari pite kamakiti,” !itxai, ");
INSERT INTO apuNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","kotxi Teoso misiritai pimaerekani xika, ãti pite misiritini atokokana. Iteene pimisiritiniãri ãti imaerekani xika, iteene Teoso misiritai pite, pite maerekani xika. ");
INSERT INTO apuNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ikara ia atoko. Pisãpiretari ãti: “Aãsoro aua poki ãki,” txamari kona pimaãkatari aãtxirata pite oki ãki auakari. Kinirepa ikara atoko inakari pikama? ");
INSERT INTO apuNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","!Apakata pisãkire pitarimoni: “Pauiritano aãsoro poki ãki auakari nimakatxakini.” Ikara atoko pininiã !erekari, kotxi aãtxirata aua pite oki ãki. ");
INSERT INTO apuNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Maerekati kamakarii pite, kotxi pikamakiti erekari atxiĩti, txamari maerekatinoka pixinikakiti. Pimakatxakariko aãtxirata pite oki ãki auakari merepanika, ininiã eereka apakata patamatiniri aãsoro pitari oki ãki auakari pimakatxakini. Ikara oerekaua piteka maerekani auakasaaki, pitakanapariko piteka maerekani, ininiã eereka apakata pimoianatiniri ãti iua maerekani itakanapini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Kãkiti kona sikari Teoso nakiti anãpamoni, kotxi atxiĩti iua anãpa kirioka, akatsata txai. Iua atokokana Teoso nakiti kona asika Teoso mapaxitakatimoni, kotxi iua anãpa atoko. Eereka iua misiritapitikai. —Apaka kona pinoakitsa ereri kona pisika irarimoni, kotxi iua katxaratari. Iua atokokanera Teoso mapaxitakanimoni kona hĩsikari Teoso nakiti, kotxi eereka imisiritari Teoso nakiti noakitsatxi irari misiritini atoko —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Iuaĩkana Xesosi sãkirauata: —Teosomoni pamanarauatakasaaki, papakapariko pinirekakiti. Pinitarauatakasaaki, papokapitikariko pinireẽkiti. Aĩri iaxitikiri pakiritiniã, iua apakapapiretai. Ia atoko itxako: “Pikanikauata. Piĩroã,” itxako. ");
INSERT INTO apuNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ikinika amanarauatakari apakapariko inirekakiti. Nitarauatakari apokariko initakiti. Teoso akiritakari apakapaãkapitikako. ");
INSERT INTO apuNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Amarini amanainiãri iri komiri, atauako kai sorokani isikatari imi? ");
INSERT INTO apuNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ximaki amanainiãri, atauako iminikani isikari? Konapitini. Irĩtxi kona kamari ikara atoko inakari. ");
INSERT INTO apuNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kãkiti maerekani apaka imarotari erekari isikini amaritenamoni. Aĩri iaxitikiri apiata imarotari isikiniri erekari iua anaakorimoni, ninoa amanaãkasaakiri. ");
INSERT INTO apuNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Pixinikariko. Natokopa pinirekari apanakini tiretinii pite? Ininiã iua atokokana pitiretariko apanakini. Ikara atoko itxa ikinika Teoso paniãtakiti aãtsopaã auakari, apaka Teoso sãkire sãpiretakani sãpiretakiti kitxakapirĩka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Iuaĩkana Xesosi sãkirauata: —Teoso tixine hiĩroã axapitiri ĩronakikoãtaã. Mitari ĩronakikoãtaã sikari sari maerekani misiritikoãtaã. Iua kimapori mitari, kotxi itomaneri kãkiti sari iuaã. ");
INSERT INTO apuNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Axapitiri ĩronakikoãtaã, kimapori axapitiri. Iua apo sari auapininiika inini tixinemoni. Iua kimaporiti axapitiki, kotxi poiãoka kãkiti sari iua kimaporiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Iuaĩkana Xesosi sãkirauata: —Erepaniko. Auapitika Teoso sãkire sãpiretakari, txamari iua na atão isãpireta, kotxi isãpiretari iua sãkire Teoso sãkirekata. Ikoketari. Atão inakari ikoketa maerekatikata. Erepaniko. Pamonõkoniri iua. Mapara patamatakasaakiri, soti auĩte atoko itxa. Ãkixiniremoni ãkiti atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pimarotari kãkiti ikara atoko inakari, kotxi patamatari ninoa kamakiti maerekati. Inako mina kona iritari kĩpaima. Aanaia kona iritari pama. Iua atokotxikana kãkiti maerekati kamakani kona kamari erekari. ");
INSERT INTO apuNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ikinika aamina erekari, erekari iri. Aamina maerekati, ininiã maerekati iri. ");
INSERT INTO apuNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Aamina erekari kona posotari maerekati iritini. Iua atokokana aamina maerekati kona posotari erekari iritini. ");
INSERT INTO apuNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Aamina maereka iriti itoãka, arika inaãka. ");
INSERT INTO apuNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ininiã aamina iriãra kãkiti imarotari ereka inini. Iua atokokanera kãkiti imarotaãka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Iuaĩkana Xesosi sãkirauata: —Apanakini txano nota: “Pite niauĩte” inakani, !isapanina Teoso auĩtetxi ininiãtaãua. Niri iaxiti auakari nireẽkiti kamakarinanira sapaniko iuaã. ");
INSERT INTO apuNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Itixi xipokini õtisaaki, itomaneri kãkiti maxikatiĩka akiritano: “Pite aãuĩte apiatakari. Papakapaua. Aõerekapekari pisãkire apanakinimoni. Aõmitikapekari maerekati matamatakoti piuãkaã. Akamapekari posotiiretxi kaiãopokori,” itxanako ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Txamari nitxanako: “Kona nimarotai hĩte. Hĩsipiniikaua. Maerekatira hĩkama.” Ikara atoko nisãpiretanako ninoa, kotxi maerekati kamakani itxauana —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Iuaĩkana Xesosi sãkirauata: —Nisãkire kenakotakari, nisãkire nĩkaenetakari, ia kiki kimaroreri atoko itxa. Ia kiki kamakasaakiri aapoko, iopitimita aapokotxi tsota. Otsomori ikama. ");
INSERT INTO apuNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ininiã ãparaã kipakasaaki, uini apoãtakasaaki, ĩtima apisatakasaaki, aapoko kona irika, kotxi iua tsota itakapekari otsomori. Nisãkire kenakotakani nisãkire nĩkaenetakani, iua kiki kimaroreri atoko itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","—Nisãkire kenakotakari, nisãkire miinĩkaenetakati, kãkiti miĩkiteti atoko itxa. Iua kamari aapoko ikipatxiteẽ. ");
INSERT INTO apuNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ikipakasaaki, uini apoãtakasaaki, ĩtima apisatakasaakiri, aapoko irika. Irika, kotxi aapokotxi !otsomori. Poião tsomikari. Irikasaaki, ikinika xipoka. Ikara atoko itxa nisãkire miinĩkaenetakati. Iua imarotapitikamari, txamari !ikamari. Ikara atoko nisãkire mapaxitakani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Xesosi oerekarauatini xipoka atoko, kãkiti xinikari: “Paimatireri Xesosi. Iua imarotari atão.” ");
INSERT INTO apuNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ikara atoko ixinikana, kotxi Xesosi imarotapitikari Teoso sãkire oerekini. Kaposotiireri iua isãkirauatakasaaki. Kaiõkatsoparerini atoko kona itxa. Ninoa kona imarotari Teoso sãkire Xesosi imarotiniri atoko. ");
INSERT INTO apuNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Xesosi ixirata iokiriĩtaka atoko, itomaneri kãkiti sari iua tikini. ");
INSERT INTO apuNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Iuasaaki amianatakari maere matati apoka iuamoni. Ikapotoreẽkaua iua apisatoõ. Itxari: —Nimarotari pinirekiniã, erekapeka pitxĩkitakano nota —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Xesosi maãtakari iua. Ininiã itxa: —Ari, ninirekapitikari. Erekapekai —itxari. Iuasaakipeka erekapeka itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ininiã Xesosi: —Kona ĩkora !pisãpiretape apanakinimoni. Uatxa sasetotximoni pisa. Poerekaua iuamoni erekapeka pinini. Moisesini paniãtakiti atoko pikama. Pikaminiãri ipaniãtakiti atoko, ininiã ikinimane imarotari erekapeka pinini —itxa Xesosi. Eereka isari Xesosi paniãtakiti ikamini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kapanaoõ sitatxiti apokasaaki, sotatoakori auĩte sari Xesosimoni. Homano itxaua. Iua iteene amanaãri Xesosi: ");
INSERT INTO apuNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Xesosi, ninitiri iteene amianata naapoko. Ikikinanaka. !Itĩpokotaika. Inikoriãtsiitari —itxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ininiã Xesosi: —Iuaã nisako erekape inini ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ininiã iua Homano: —Konapitini. Pite auĩtetxi apiatakari pitxaua. Nota poiãorino. !Apakata naapoko piĩroini. Pisãkirenani piokanata. Ininiã erekapeka itxako ninitiri. ");
INSERT INTO apuNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nimarotari ikaranani apakatako, kotxi nota kamari nota auĩte paniãtakiti. Apaka sotato auĩte nitxaua nota. Nisãkirauatakasaaki, nisotatone kamapitikari nipaniãtakiti. Nota txari: “Pisa.” Iuasaakipeka isa. Nitxari ãti: “Pina.” Iuasaakipeka ina itxa. “Ia pikama,” nitxari ninitiri. Iuasaakipeka ikamari. Ininiã pisãkirenani apakatapitika —itxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Isãkire Xesosi kenakotakasaaki, iteene ipotxitari isãkire. Iposo atoko itxa: —Atão nitxai. Isaeo auakani poião auikari nisãkire. Ia Homano itxaua, iuaritika apiata iua auikari nota posotiire. Kona nitikapanikari kãkiti Isaeo auakari auikiniri nisãkire ia kiki auikiniri atoko. ");
INSERT INTO apuNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nota sãpiretai hĩte, itomaneri kãkiti ãti uãka atokatxi pokĩkini tixinimoni auakani, atokatxi ereẽkokini tixinimoni auakani apaka, itomaneri itixi auakani kiiniritauatako Teoso auĩtetxi ininiãtaãua. Ninoa nipokotako anirimanekata kitxakapirĩka auakanikata. Apraão, Isaki, Xakoo pakinikata inipokotana. ");
INSERT INTO apuNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Iuasaaki apanakini Apraão apika mekaniriakori kona sari iua Teoso kiiniritemoni, kotxi ninoa !auikari Teoso sãkire. Piãkatximoni iokanataãkanako. Iuaã itxiapatanako, akatsakatsiriĩtauanako imisiritikona xika —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ininiã Xesosi txari sotatoakori auĩte: —Pisa paapokomoni. Pite auikari niposotiire pinitiri erekape inini ĩkapani. Uatxa auape pinirekakiti —itxa Xesosi. Ininiã initiri iuasaakipeka erekape itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iposo atoko Xesosi sari Petro aapokomoni. Iuaã apokasaaki, atamataro Petro imakiro. Osirimata nopini osirĩkanãta. Oãpoomata. ");
INSERT INTO apuNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ininiã Xesosi takapiotaua ouako nopini. Iuasaakipeka apoomari xipoka. Ininiã oõkitikaua. Osikakienatana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mapiãpeka inakasaaki, kãkiti anikana itomaneri maerekati matamatakoti auaĩtotakini iuamoni. Isãkireẽ omitikana maerekani matamatakoni. Imakananitana ikinikana amianatakani. ");
INSERT INTO apuNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ikara atoko itxa Xesosi, kotxi inirekari Isaía sãkire iaõka apokini. Kitxakapirĩka Teoso sãkire sãpiretakari Isaía inakori txari: Iua tiretariko amianatakari. Imakatxakariko aamianare. Imakananitaua. Iuaka atatsiirauata ate ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Itomaneri kãkiti iuakata auakasaaki, Xesosi txari imoianariakori: —Masa ipiniãmoni —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Iuasaakipeka ãti kaiõkatsopareri apoka Xesosimoni. Itxa: —Koerekareri, nota iposope nisini pite nirekinimoni —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ininiã Xesosi: —Atauako pinirekatari pisini notakata? Aripa aua auini iriko. Araãkani auari ikoa. Txamari nota kãkiti itari iaxitikiri !auari nimakiniãtaã —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ãtipekana apoka Xesosimoni. Xesosi moianari iua. Itxari: —Niauĩte, pauiritano niri nikatanapini merepanika, kotxi kiomãtxipekari iua. Eereka nisa pitekata —itxari. Iteene iua !inirekari isini Xesosikata. ");
INSERT INTO apuNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Xesosi apakapapiretari: —Notakata pisa uatxa. Nisãkire mauiãkani ipĩkani atoko itxana. Ininiã pauiritana ipĩkani katiniri inirimane nisãkire mauiãkani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iposo atoko, Xesosi imoianariakorikata iereẽtaua, ĩpiriãtinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mokatanitika ĩtima kataparari apoãkata. Tsakati okari ãparaã kanaua ãki. Iuasaaki Xesosi imakanãta. ");
INSERT INTO apuNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Imoianariakori sari iuamoni. Õpirĩkarina. Akiripoakatana: —Apiananiri, !pauiritapiri apinini. Apinanapanoka —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ininiã Xesosi: —Kinirepa hĩpĩkarauata? Poiãonoka hãuikari niposotiire —itxa. Iposo atoko õkitikaua, pinita itxari ĩtima, tsakati pakini. Iuasaakipeka ĩtima, tsakati pakini iotoka. ");
INSERT INTO apuNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ininiã imoianariakori tsorĩkaãta. Itxana: —Natokopa inakaripa ia kiki? Ĩtima, tsakati pakini kenakotari isãkire —itxana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ipiniã apokasaakina Xerasa tõpamoni, itaõkitarina ipi kiki itomane maerekani matamatakoni auaĩtotakini. Akauariã auanãtana. Paneenamana. Ikara xika kãkiti pĩkari akauarimoni isinina. ");
INSERT INTO apuNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Xesosi inaãpotakasaaki, maerekani matamatakoni iĩtoãna auakani akiripoakata: —Xesosi, Teoso ãkiri pitxaua. Kiripa pinirekaka atemoni? Pite ina uaimoni amisiritiko õti apisapanika pimisiritiniua ĩkapani atxiĩti? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ikara ininiãtaã takote auana itomane irariakori. Ikira atoko inipokonãtana. ");
INSERT INTO apuNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ininiã maerekani matamatakoni txari: —Ate pomitikiniã, irariakorimoni piokanataua —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ininiã Xesosi: —Hĩsipeka ninoamoni —itxa. Iuasaakipeka irariakori ĩtoã ĩroãna. Ininiã imakinikana irariakori miteẽkata. Iokiriĩkatana. Ipoamoni isana. Iuaã ikomokana, axãpoãta itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ninoa irariakori nĩkatakani miteka sitatximoni. Iuaã ikinika isãpiretana irari ipinini pirena, kiki maerekani matamatakoni auaĩtotakini pirena apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ininiã ikinimane sitatxikini sari Xesosi itaõkitinina ĩkapani. Iua itaõkitakasaakina, amanaãrina ninoa tixine itakanapini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ininiã Xesosi iereẽtaua kanauaã. Ikanapiriã iua auinimoni Kapanaoõ sitatxitimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ãtikaka kikiakori minari matĩpokotakati Xesosimoni. Xesosi imarotari ninoa auikiniri iua sãkire. Ininiã itxari: —Namarite, pipoxokoniuatako. Pimaerekani makatxakapeẽkaika —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iuasaaki aua ãtikaka kaiõkatsoparerini iuaã. Ninoa ãkixinireẽ itxana: —Kona erekari isãkire. Teosonanira posotari kãkiti maerekani imakatxakini —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Xesosi imarotari maerekati ixinikakitina ãkixinireẽna. Ininiã iua txa: —Kinirepa hĩuãkatari nisãkire maerekati inini? ");
INSERT INTO apuNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nitxari iua imaerekani nimakatxakini, txamari !himarotari imaerekani atão nimakatxakini. “Põkitikaua. Pitĩpokota,” nininiã, himarotari nisãkire atão ininiãua, kotxi hĩtikari. Niposotiire imaerekani nimakatxakini ĩkapani, niposotiire iua nõkitikini ĩkapanitxikana. ");
INSERT INTO apuNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ininiã uatxaika noerekai hĩte, Teoso iokanatano nota hĩtari iaxitikiri ĩkorapokoritimoni kãkiti maerekani nimakatxakini ĩkapani —itxa Xesosi. Ininiã itxari matĩpokotakatimoni: —Põkitikaua. Pisirimata pikoseka, sipe pitxa paapokomoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Iuasaakipeka iua õkitikaua, aapokomoni sipe itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ikara inakari apanakini itikasaaki, ipĩkarauatana. —Peerekari Teoso, kotxi iua oerekari iposotiire kãkitimoni —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ikara inakari oereka atoko Xesosi sipeka. Isikasaaki, itaõkitari Mateo inakori. Auĩtetxiakori txineirote apotiitakari iua. Xesosi napakasaaki, iitopãkanãta txineiro apakapiniãtaã. Ininiã Xesosi txari: —Masa notakata pimoianatinino ĩkapani. Ininiã Mateo õkitikaua, Xesosikata sa itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Eereka Xesosi imoianariakorikata nipokota Mateo aapoko. Txineiro apotiitakani, apanakini kãkiti maerekati kamakani pakini apoka Xesosikata inikinina ĩkapani. Kãkiti kona potxitari txineiro apotiitakani, kotxi ninoa sikaro oa txineiro ãti uãka auĩteakorimoni. !Neerekana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pariseoakori itikari ninoa nipokotini, ininiã itxana Xesosi moianariakorimoni: —Kinirepa hĩauĩte nipokota txineiro apotiitakanikata, maerekanikata? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ininiã Xesosi kenakotari ninoa sãkire. Itxa: —Maerekati kamakari amianatakari atoko itxa. Ninoa nirekari erekape ininina. Kãkiti mamianatakani !inirekari ipini sikakarimoni isinina. Amianatakaninoka nirekari ipini sikakarimoni isinina. Hĩte !inirekari nota makatxakiniri himaerekani, kotxi hĩte uãkatari !auari himaerekani. ");
INSERT INTO apuNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hĩxinikariko ia Teoso sãkire iõkatsopatakori: Hĩsikarauata notamoni. Apiaerekata hiamonĩkiniri apanakini. Nota ina ĩkorapokoriti kona kãkiti “atão inakarinoka kamakarino nota” inakani ĩkapanini, kotxi ninoa uãkatari erekarini ininiãuana, txamari kona erekana. Kãkiti maerekati kamakani ĩkapanira nina nota uai imaerekanina itakanapinina ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Eereka Xoão kapatxisareri moianariakori apoka Xesosimoni. Itxana: —Ate, pariseoakori pakini atakanapari anipokotini itokata Teoso amisãkiretini ĩkapani. Kinirepa pite moianariakori !itakanapari inikinina Teoso imisãkiretinina ĩkapani? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ininiã Xesosi apakapapiretana: —Nota kiiniri kamakari atoko nitxa. Kiki nirekiniã ĩtanorouatini, ikamari kiiniri. Iuasaaki imoianariakori kona nirekari imatinaniuatinina, iua ninoakata auakasaaki. Ininiã kona itakanaparina inikinina Teoso imisãkiretinina ĩkapani. Ãti õti nimaĩkaãkako. Nanikaãkako ninoa mauakaniãtaã. Iuasaakiko itakanaparina inikinina Teoso imisãkiretinina ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Kiomãtxiakori kitxakapirĩka auakani sãkirekata kona hĩkoketapiri nota sãkire. Ikara hĩkaminiã, ininiã mãkatxi kitxakari amaneriã hĩtãpanatini atoko itxa. Mãkatxi kitxakari amaneriã kona hĩtãpanatape, kotxi parokasaakiri, amaneri txikika, ininiã ikatsorãkari mãkatxi kitxakari. Ininiã mitari itsorãkare. Mãkatxi amaneri nota oerekakiti atoko. Mãkatxi kitxakari, kãkiti kitxakapirĩka oerekakiti atoko itxa. Hĩkoketiniãri kitxakapirĩka oerekakiti, amaneri oerekakitikata, imakinika xipoka. ");
INSERT INTO apuNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","—Kitxakapirĩka kãkiti takari iãriã sako aamata kamakori ãki. Iuasaaki kona kãkiti takari amaneri iãriã kitxakari mata ãki, kotxi iãriã txiõkaãtakasaaki, itiãkaãpota. Ininiã omata kitxakari tsorakitako, kotxi paikori. Kona itiãka. Ininiã iãriã katxaka. Iãriã, aamata pakini xipoka. Amaneri matariã itakaãka iãriã amaneri. Ikara atoko ininiã, erekapitikari. Kona ixipokapaniko. Iua atokokana kona hĩkoketapiriko kiomãtxi kitxakapirĩka oerekakiti nota oerekakitikata —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Xesosi sãkirauatapanika, inakasaaki Xoteoakori auĩte apoka iuamoni. Ikapotoreẽkaua Xesosi apisatoõ. Itxa: —Namarite opinanapanoka. Masa. Piuako pitaka oa nopini, ininiã kona opina —itxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ininiã Xesosi imoianariakorikata õkitikaua, iuakata sa itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Isikasaakina, sito apoka iua porikimoni. Oamianare oãrẽka !iotokiniãro. Tosikanani oamianatini. Oãpokasaaki, omaãtakari imãka imapotomatare. ");
INSERT INTO apuNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Oãkixinireẽ otxa: —Imãka nimaãtakiniã, erekape nitxako —otxa. Ininiã otikakari imãka. ");
INSERT INTO apuNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iuasaakipeka Xesosi kirioka, atamata itxaro: —Namarite, kataparaxinire pitxako. Pauikari niposotiire, ininiã erekapekai —itxaro. Iuasaakipeka oa erekape. ");
INSERT INTO apuNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iposo atoko Xesosi sari Xoteoakori auĩte aapokomoni. Iuaã apokasaaki, iĩroã. Itikari sokonaki xõkakani, itomaneri kãkiti txiapatakani apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ininiã Xesosi: —Mapara hĩsa, kotxi oa amarini kona opina. Omakanãta —itxa Xesosi. Ininiã ninoa napetari Xesosi: —!Omakanãta. Opĩpe. Pite !imarotari —inapetarina. ");
INSERT INTO apuNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ikinimane mapara isikasaakina, Xesosi sari oa ãtokoromoni. Imaĩkaro ouako. Iuasaakipeka oõkitikaua. ");
INSERT INTO apuNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ikara ene iaripireta iua tõpa. ");
INSERT INTO apuNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iposo atoko Xesosi sipe. Iuasaaki ipi mõsiãreni sari iua tikini. Iuasaaki ninoa akiripoakata: —Tavii apika mekanirii, piamonĩkaua ate —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aapokotxi Xesosi ĩroãkasaaki, ninoa ĩroã apaka. Ininiã Xesosi: —Hãuikatari niposotiniri erekapeka nitxĩkitakinii hĩte? —itxa Xesosi. Ininiã ninoa: —Ari, Apiananiri —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ininiã itakapiotaua ninoa oki nopini. Ininiã itxa: —Ari, hãuikakiti iaõka itxako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iuasaakipeka ninoa kõsiãrepeka itxana. Ininiã Xesosi: —Kona hĩsãpiretapiri nikamakiti apanakinimoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Eereka ninoa sipe. Txamari iaripiretarina ikamakiti ikinika iua tõpa. ");
INSERT INTO apuNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ninoa kiki potorikasaaki, masãkireti anikaãka Xesosimoni. Iua kona kasãkireri, maerekati matamatakoti auaĩtotakiti xika. ");
INSERT INTO apuNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iuasaaki Xesosi omitikari iua maerekati matamatakoti. Iuasaakipeka iua kiki sãkirauata. Itomaneri kãkiti itikari. Iuasaakiika ninoa tikoka. Ininiã itxana: —Ikinika Isaeo tixiniã auakani, mitxi !itikapanikari ĩkora atoko inakari —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Txamari pariseoakori txari: —Xesosi omitikari maerekati matamatakoti Satanasi posotiireẽ —itxana. Na atão ninoa sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ininiã Xesosi sari ikini sitatxiti tõpa. Aapokotxi auiniãtaã apaka isa. Oerekarauata aiko Xoteo apotiitiniãtaãua. Isãpiretari Teoso iokanapirena erekari, Teoso auĩtetxi ininiãua pirena. Apaka erekapeka itxĩkitakana ikinipoko amianatakani. Ikini sereti amianari aua kãkitimoni. Ikinika imakananita. ");
INSERT INTO apuNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Atamatakasaakina ninoa kãkitipokoni, iamonĩkana ninoa, kotxi soti auĩte minĩkatakoni atoko itxana, kotxi !imarotarina isinimonina. Imaãkauana. ");
INSERT INTO apuNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ininiã itxari imoianariakori: —Kaiãori kãkiti iposope auikiniri nisãkire, txamari !imarotarina nisãkire, kotxi !ikenakotapanirina. Ninoa kikio erekari atoko itxana. Imakinika iposope iuaã. Ininiã iposope auikinirina nisãkire. Txamari, poiãoka parĩkauatakani aua nisãkire isãpiretinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ininiãkara himisãkiretariko Apiananiri iaxitikiri iokanatinina parĩkauatakani iua sãkire auiãkani apotiitinina ĩkapani. Ikara atoko hĩtxako Teosomoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Xesosi mereẽna tosi imoianariakori. Isikari iposotiire ninoamoni maerekati matamatakoti omitikinina ĩkapani. Isikari iposotiire ninoamoni amianatakani imakananitinina ĩkapani, ikinika amianari inokasaakina ninoa amianatakani. ");
INSERT INTO apuNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Naia imoianariakori uãka: Merepitipanika auari Simão Petro inakorima, apaka itari Ãtree inakorima. Auari Txiakoma, apaka itari Xoãoma. Ninoa Sepeteo anaakori. ");
INSERT INTO apuNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Auari Piripima, Patoromeoma, Tomeema. Apaka auari Mateoma, txineiro apotiitakari. Apaka ãti Txiakoma, Aopeo ãkiri. Aua Tateoma. ");
INSERT INTO apuNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Aua Simãoma, Homano omanatakari. Apaka aua Xotasi Isikariotxi inakorima. Iua Xesosi mĩkapiritakari itxaua. Ninoa Xesosi moianariakori itxauana. ");
INSERT INTO apuNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ininiã Xesosi iokanatana ninoa isãkire isãpiretinina. Ia atoko õtãkikana: —Kona hĩsipeko Xoteo minakonimoni, apaka Samaria tõpa sitatxitimoni kona hĩsipeko. ");
INSERT INTO apuNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Hĩsako kãkiti Isaeo tixinikinimoni. Hinirimanemoni, Xoteoakorimoni hĩsako. Ninoa soti auĩte pĩpinanaãkani atoko itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hãpokasaaki kãkitimoni, hĩtxariko: “Teoso ikinimane auĩte ininiua manapi paĩtiki apokako.” ");
INSERT INTO apuNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Himakananitanako amianatakani. Maere matati erekapeka hĩtxĩkitakako apaka. Ipĩkani hõkitikako. Homitikariko maerekati matamatakoti kãkiti auaĩtotakini. Ikara atoko hĩkamako. Kona hĩte ĩkitxitari Teoso hãpakapakiti ĩkapani. Ininiã ikara atokokana hĩtxako. Kona hinirekapiri kãkiti iĩkitxitinii hĩte, hĩte sikakiti ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kona hanikapero txineiro oro kamakoro. Pirata kamakoro, ãtião txineiro apaka, kona hanikape. ");
INSERT INTO apuNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Uatxa hianaxititakasaaki, sako mata !hanikape. Ãti himãka !hanikape. Ãti hĩkiti mata kona hanikape. Hĩtsonere !hanikape. Kona himaãkapeua, kotxi parĩkauatakani apakapariko nipokori. Hinirekakiti apokapitikako. ");
INSERT INTO apuNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Sitatxi hãpokasaaki, hinitari kãkiti Teoso sãkire kenakotakani, hĩte apakapakani. Hĩkaikota ninoakata. Eereka kona hĩsipe ãti aapokomoni hĩkaikotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aapokotxi ãki hiĩroãkasaaki, hĩtxako: “Erekari Teoso sikakiti kaikotako hĩtekata,” hĩtxako. ");
INSERT INTO apuNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kãkiti ipoxokoniritika apakapiniãi, hĩtxako: “Teoso takari erekari hĩtemoni,” hĩtxako. Imanirekakaniãi, hĩtxariko: “Teoso kona takari erekari hĩtemoni.” ");
INSERT INTO apuNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Atxiĩti aapokotxi hãpokasaaki, kãkiti iuaãtaã !apakapai. Atxiĩti !inirekarina hĩsãkire, ininiã iuasaaki hĩsipeka. Hĩtakanapariko iuaãtaã. Hĩpotorikasaaki, himakatxakari kipatxi hĩkiti mataã auakari. Ininiã iuasaaki ninoa imarotari Teoso kona apokaerekatana. ");
INSERT INTO apuNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Hĩxinikariko ia nisãkire. Kãkiti misiritiko õti apokasaaki, ninoa apiata misiritaãka. Sotoma sitatxiti auakani, Komoha sitatxiti auakani pakini misiritaãka poiãoka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Iuaĩkana Xesosi sãkirauata: —Erepaniko, pamonõkoniri. Hĩte soti auĩte atoko hĩtxa, kotxi !kaposotiirei hĩte, iuaritika niokanatai kãkitimoni. Ninoa ãkiti atoko, ininiã erepaniko. Ininiã kimarorei hĩtxako. Imini kimaroreri atoko hĩtxako. Ininiã maerekati ninoa auakiti kona misiritai. Iuasaakiika kamoa atoko hĩtxako, kotxi kamoa !imisiritari kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","—Erepaniko. Araõkire hĩtxako. Auako kãkiti kinirão anikinii maxikatiĩka kãkiti misiritiko mereẽkanimoni. Apanakini xirokaiko hĩte maxikatiĩka aiko ãki Xoteo apotiitiniãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nota sãkire hãuikini xika hanikaãkako auĩtetxiakorimoni himisiritiko himarotini ĩkapani. Ikara atoko ininiã, iuasaaki erekapitikari, kotxi hĩsãpiretariko nota sãkire iuaã auakanimoni, Xoteo minakonimoni apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","—Kãkiti misiritiko mereẽkarimoni hanikikosaaki, kona himaãkapeua hĩsãkirauatini apisa. Teoso sikaiko hĩsãpirena tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sãkiretxi hĩsãpiretakiti kona hĩte sãkireni. Erekari Matamatakoti, iuarako sikariko sãkiretxi hĩsãkirauatini ĩkapani iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","—Ãti õti hĩtari sikaiko hĩte homanatakinimoni okinii ĩkapani, kotxi hĩte auikari nota sãkire. Iua atokokanerako irĩtxi sikariko imi ãtimoni okiniri ĩkapani, kotxi imi auikari nota sãkire. Auako apaka imi omanatinina iri, inoro pakini, kotxi inoro, iri pakini auikari nota sãkire. Iua sikanako ãtimoni okinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ikinimane omanataiko hĩte nota sãkire hãuikini xika, iuaritika hãuikiniãri nisãkire ãtipirika, nimakatxakai himapinakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Sitatxiã hãuakasaaki, himisiritikosaaki, ãti sitatxitimoni himitekako. Atão nota sãpiretai hĩte. Kona hĩte xipokapaniri hĩparĩka ikini sitatxiti Isaeo tixini hĩtari iaxitikiri kanapiriini apisa —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Iuaĩkana Xesosi sãkirauata: —Apaiaõkarauatakari poião. Koerekareri apiata. Apaka nitiritxi poião. Iauĩte apiata. ");
INSERT INTO apuNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Apakatapitika apaiaõkarauatakari koerekareri imarotakiti iaõka imarotini. Iua atokokanera nitiritxi iua auĩte atoko inini. Apanakini akiritano nota “Peosepoo,” Satanasi inakori. Ininiã itakauãkatai hĩte hĩuãka apia maerekati, kotxi nota anaakorirai hĩte —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Ininiã kona !hĩpĩkapena ninoa maerekati kamakani, kotxi nota kanapiriãkasaaki, kona kipatakori auapanika. Ikinika imarotaãkako. ");
INSERT INTO apuNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hĩtemoni ĩkanõka nimaasakapiretakiti, ikara nisãkire hãkiripoakatako aapokotxi nopini imakinika kãkiti imarotiniri ĩkapani. Uatxa hĩtemoninani nisãpiretakiti ãti õti ikinimanemoni hĩsãpiretako. ");
INSERT INTO apuNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kona hĩpĩkapena hiĩto okakani, kotxi !iposotarina hĩxinire okinina. Hĩpĩkariko Teoso, kotxi iuanokara posotari iokanatinii hĩte, hiĩto, hĩxinire pakini maerekani misiritikoãtaã. Iuara hĩpĩkako. ");
INSERT INTO apuNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","—Ipi kotipiriki ĩki poião, ãtika txineiro otanoka. Iuaritika hĩri iaxiti auakari tiretana ninoa. Imauiritakaniãri, kona ãtika ipina. ");
INSERT INTO apuNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kipakinipa piãko pikiiã auakari aua? !Pimarotari. Teoso imarotapitikari, kotxi iteene inĩkatai, ininiãkara !hĩpĩkarauatape. ");
INSERT INTO apuNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kotipiriki ĩki poião, iuaritika Teoso tiretari kotipiriki. Ininiãkara kona hĩpĩkarauatape. Kaiãopokori kotipiriki auiniã, iuaritika hĩte ĩki apiata, ininiã Teoso tiretapitikai hĩte —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Xesosi sãkirauatapanika: —Apanakini apisatoõ hĩsãpiretiniãri: “Xesosi nakiti nitxaua nota,” iua atokokanerako nitxariko niri iaxiti auakari apisatoõ: “Nota nakitipitikara iua,” nitxako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Hĩsãpiretiniãri apanakini: “Xesosi nakiti !nitxaua nota,” iuasaaki nisãpiretari niri iaxiti auakari: “Kona nota nakitini iua.” ");
INSERT INTO apuNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Kona hĩxinikapiri nota ĩkorapokoriti napokini neenamatxi nixipokini ĩkapani. Kotxi kãkiti auikari nisãkire, ininiã eereka apanakini omanatana. Kona neenamatxi xipokapanika, kotxi nota minari niposotiire maerekati nixipokini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nota apokini xika imi omanatana iri, inoro pakini, kotxi ninoa auikari nisãkire. Tiĩrotxi omanataro oimakiro, kotxi ãto omanatano nota, ãto tiretano nota. ");
INSERT INTO apuNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Iuasaaki pinirimane pimokaiakarinikarako itxauanako. ");
INSERT INTO apuNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Poiãoka pitiretiniãno nota, apiata pitiretiniãna pinoro, piri pakini, kona erekari nimoianari pininiua. Apiata pitiretiniãna pamariteakori, kona erekari nimoianari pininiua. ");
INSERT INTO apuNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nota kinirão moianataka hinakasaaki, notakata hĩsa. Himamĩteenekakanisaakiri himisiritiko nota ĩkapani, ininiã !apakata himoianatinino. ");
INSERT INTO apuNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","—Pite ãtipirika kaminiãri piteka nireẽkitinoka, ininiã pinireẽkiti xipokapitikako pitekata. Pite nireẽkiti xipokiniã, nota sãkire pauikini xika, pite auapininiika txako Teosokata —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Iuaĩkana Xesosi sãkirauata: —Kãkiti hĩte apakapakani, apakapano nota apaka. Nota apakapakari apakapari nota iokanatakari apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Papakapiniãri Teoso sãkire sãpiretakari, kotxi iua sãpiretari Teoso sãkire, ininiã papakapari erekari Teoso sikakiti iua apakapakiti iaõka. Papakapiniãri atão inakari kamakari, kotxi iua kamari atão inakari, ininiã papakapari erekari Teoso sikakiti iua apakapakiti iaõka. ");
INSERT INTO apuNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pisikiniãri ãparaã nimoianari poiãorimoni iãtini ĩkapani, kotxi nimoianari itxaua, Teoso iĩkitxitapitikai pite —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Xesosi moianariakori tosi pakini isãkire oerekini xipoka atoko, Xesosi sipe. Isa ãti sitatxitimoni, eereka ãti sitatxitimoni Kariréia tõpa itxaãpota oerekarauatakasaaki. Teoso sãkire isãpiretari kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Xoão kapatxisareri, kateia ãki auakasaaki, ikenakoenetari Xesosi kamakiti, ininiã iokanatari ipi imoianariakori Xesosimonikari. ");
INSERT INTO apuNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ininiã Xoão txari imoianariakori: —Hĩpimaãri Xesosi: “Pitekani iaxiti ĩkari, kãkiti iãtapakiti pitxataua? Ãtikani atxiĩti aiãtapakiti pitxataua?” hĩtxariko —itxa Xoão. Ininiã ninoa sipe. Ipimaãrina Xesosi Xoão sãkire iaõka. ");
INSERT INTO apuNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ininiã Xesosi apakapapiretana: —Hĩkanapiriã Xoãomoni. Hĩsãpiretari hĩkenakotakiti, hãtamatakiti pakini. ");
INSERT INTO apuNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Hĩte atamatapekari mõsiãreti kõsiãrepeka inini. Matĩpokotakati tĩpokotapeka. Hãtamatapekari maere matati erekapeka inini. Makenakokiti kakenakokipeka. Ipĩkani õkitikapekaua. Teoso iokanapirena erekari sãpiretapeẽkaika minakati mauapikinitinimoni. Pakini hãtamatapeka. Ikara hĩsãpiretako Xoãomoni. ");
INSERT INTO apuNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kãkiti iteene auikiniãri nota sãkire, Teoso takari erekari iuamoni. Ikara nisãkire hĩsãpiretari Xoão —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ininiã ninoa sipe. Isikasaakina, Xesosi sãpiretari Xoão pirena itomaneri kãkitimoni. Ia atoko itxa: —Kipa ĩkai hĩte, Xoão kapatxisarerimoni hĩsikasaaki, ãparaã makipakaniãtaã iua auakasaaki? Hĩte sari iuamoni, kotxi ãtitxika isãkire aua. Teoso sãkirenoka isãpireta. Ĩtima ãpokaxitikasaaki, katsotati ipinimoni ipapĩka, iuaĩkana ipinimoni ipapĩka inini atoko kãkiti, kotxi isãkire kita ãti, isãkire uatxa ãtião, isãkire katana iuaĩkana ãtião, itxaãpota isãkire. Ikara atoko !itxa Xoão. ");
INSERT INTO apuNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","—Kipa ĩkai hĩte Xoãomoni hĩsikasaaki? Hĩte sari iuamoni, kotxi !inirekari tiitxi, txineiro pakini. !Kakaroneri imãka, kotxi !ikaikota auĩtetxi aapoko. Auĩtetxi aapoko peereri mãkatxi. ");
INSERT INTO apuNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","—Kipa ĩkai hĩte iuamoni hĩsikasaaki? Hĩte sari iuamoni, kotxi iua Teoso sãkire sãpiretakari itxaua. Atãopitika Teoso sãkire sãpiretakari itxaua. Iua Xoão Teoso sãkire sãpiretakari apiari. ");
INSERT INTO apuNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","—Teoso sãkire iõkatsopatakori kitxakapirĩka txari: Niokanatariko nisãkire sãpiretakari kãkitimoni pite apisa, papokini isãpiretini ĩkapani, kãkiti iposope inini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Atãopitikara. Ikinimane sauaki Xoão kapatxisareri apiatakari itxaua. Iuaritika Teoso auĩtetakari poiãori inakari apia imarotariko Teoso kamakiti tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Xoão auakasaaki Teoso auĩtetakani misiritaãka, kotxi kãkiti kaneenamari naiatana ninoa. Ninoa nirekari ixipokinirina Teoso auĩtetxi ininiua ĩkorapokoriti. Uatxapiima auapanika ikara atoko inakari. ");
INSERT INTO apuNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Xoão apokini apisapanika, ikinika Teoso sãkire sãpiretakani, ikinika Teoso sãkire iõkatsopatakani, sãpiretari Teoso auĩtetxi ininiua pirena. Xoão apokasaaki, iua apaka oerekari Teoso auĩtetxi ininiua pirena. ");
INSERT INTO apuNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","—Kitxakapirĩka Teoso sãkire sãpiretakani sãpiretaua: Ãti Teoso sãkire sãpiretakari Eríasi atoko inakari apokako, itxana. Iuakara Xoão. Hãuikiniãri nisãkire, hãuikariko iuara apokapeka. ");
INSERT INTO apuNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kakenakokii, ininiã hĩkenakotariko nisãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—Kanatokopa itxa kãkiti ĩkorasaaki auakani? Amarini sarauatini atoko itxana ĩkorasaaki auakani. Ninoa amarini topãka tiitxi amotikoãtaã. Apanakini amarini txitana apanakini amarini. Itxana: ");
INSERT INTO apuNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ate xikarauata hĩte serenini ĩkapani, txamari !hĩserena. Kãkiti pĩkasaaki xikariti axikareta, txamari !hĩtxiapata.” Ninoa amarini sarauatini atoko itxana ĩkorasaaki auakani, ");
INSERT INTO apuNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","kotxi Xoão kapatxisareri apoka ĩkorapokoriti. Itakanapari inikini Teoso imisãkiretini ĩkapani. !Iãtari ovaã. Iuaritika hĩte txari: “Maerekati matamatakoti auaĩtotari Xoão,” hĩtxari. ");
INSERT INTO apuNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nota hĩtari iaxitikiri apoka ĩkorapokoriti. !Nitakanapari ninikini. Ikiniõtika ninipokota. Niãtari ovaã. Ininiã hĩte txari: “Iua kiki ixori. Poãtakari iua. Iua moianatana txineiro apakapakani, kãkiti maerekati kamakani,” himisãkirepirenãtano. Kimaroreri atão inakari kamari erekarinani. Kãkiti atamatakasaakiri ikamakiti, imarotari kimaroreri atão inakari ininiua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ininiã Xesosi pinitana Korasiĩ sitatxiti auakani, Petsáita sitatxiti auakani pakini, kotxi kaiãopokori iposotiire ikamapeka iuaãtaã, iuaritika kona itakanaparina maerekati. ");
INSERT INTO apuNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Xesosi txana ninoa: —Kãkiti Korasiĩ auakani himisiritaãkako. Kãkiti Petsáita auakani hĩte apaka misiritaãkako. Kitxakapirĩka Txiro, Sitoõ pakini sitatxitikini kamari maerekati, ininiã Teoso xipokana ninoa arikatxiã. Ninoa atamataãkamariko nota posotiire hĩte atamatiniri atokokana, ininiã ninoa mãkatamariko sako mata. Itakamariko atapani iĩtoãna. Ikara atoko ininiã, ninoa oerekari maerekati itakanapinina. ");
INSERT INTO apuNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nisãpiretai hĩte ia: “Kãkiti misiritiko õtisaaki, Txirokini, Sitoõkini pakini misiritaãka poião. Hĩte apiata.” ");
INSERT INTO apuNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Hĩte Kapanaoõkinipekana, Teoso ãkiri aua hĩtekata. Hĩte itikapekari ito posotiiretxi iaxitikiri. Txamari hõkakatapeẽkako maerekani misiritikoãtaã. Nikamakiti hĩtemoni Sotoma auakani sauaki nikamaãkamako, kona ninoa xipokamako. Auapanikamanako. ");
INSERT INTO apuNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ininiã nitxai hĩte: “Himisiritikosaaki, apiata himisiritaãka. Poiãoka Sotomakini misiritaãka,” —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Iuasaaki Xesosi misãkiretari iri: —Niri, pitixine auakani auĩte pitxaua. Uai ikini itixiti auakani auĩte apaka pitxaua. Peerekai pite, kotxi na poerekari pimarore kãkiti kimarorerinimoni, iuikakanimoni. Pite oerekari pimarore kãkiti poiãorinimoni, miuikakanimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ari niri, ikara atoko pinireka. Ikara atoko papokaerekata —itxari iri. ");
INSERT INTO apuNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Eereka imisãkiretari kãkiti: —Niri sikapekano ikinika. Kãkiti !imarotano nota Teoso ãkiri nininiua. Nirinokara atão imarotano nota. Apaka kãkiti na atão imarotari niri. Notanokara imarotari niri, kotxi iua ãkiri nitxaua. Kãkiti nirekiniãri imarotiniri niri, nota oerekari niri iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","—Iteene minari atoko itxa himaerekani. Hinireka hĩtakanapiniri iua, txama !hĩposota hĩtakanapiniri. Hĩsãpakiniã himaerekani xika, hina notamoni hĩtomatini ĩkapani. Iuasaaki nimakatxakari himaerekani. ");
INSERT INTO apuNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Hĩtakariko nipaniãtakiti hãkixinireẽ. Hãpaiaõkariko nota pirena. Erekapitikari hãpaiaõkiniri ninirekakiti, kotxi kona kaneenamano. Kona nota napetari kãkiti. Niuikiniua !auari. Ikara atoko ininiã, hĩxinire tomatapitika. ");
INSERT INTO apuNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Hĩposotapitikari nipaniãtakiti hĩkamini, notakata hĩparĩkauatiniã. Nipaniãtakiti !kasãpaniri. Kona kamimari. Peerekari nipaniãtakiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mapaõti atoko tomatiko õtisaaki, Xesosi imoianariakorikata napaãpota triko takikoãtaã. Inatxitana. Inapaãpotakasaakina, imakatxakarona triko iki mapaki inikinirona ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pariseoakori ikara itikasaaki, itxarina Xesosi: —Patamata. Pimoianariakori kamari ate mauiritakiniti. Ninoa parĩkauata tomatiko õtisaaki —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ininiã Xesosi: —Atxiĩti kona hãtatsopatapanikari Taviini kamakiti imoianariakorikata kitxakapirĩka inatxitakasaakina? ");
INSERT INTO apuNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Iua ĩroã Teoso misãkiretikoãtaã. Imoianariakorikata inikari komiri Teosomoni sikakori. Sasetotxinokara auiritaãka iua komiri inikinina. Apanakini !auiritaãka inikiniri. Iuaritika ninoa sasetotxiakori tiretari Taviini, imoianariakori pakini inatxitakasaakina. ");
INSERT INTO apuNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Atxiĩti kona hãtatsopatapanikari Moisesini iõkatsopatakiti. Iua auiritari sasetotxi parĩkauatini tomatiko õtisaaki, Teoso misãkiretiko aikotiã. Iuasaaki ninoa !ikamari maerekati, kotxi iparĩkauatana Teoso misãkiretiko aikotiã. ");
INSERT INTO apuNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Atão nisãpiretai, hĩte paniãtakiti poiãori. Nota paniãtakiti apiari. ");
INSERT INTO apuNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Teoso sãkire iteene hãuikasaaki, kona hãpoĩtana kãkiti maxikatiĩka, kotxi Teoso sãkire txari: Nota nirekari apanakini hĩtiretini. Pimatiretakanisaakiri ãti, !apakata pisikarauatini notamoni. Iuasaaki kona ninirekari pisikakiti, itxa Teoso kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","—Nota hĩtari iaxitikiri posotari ikinipoko ninireẽkiti nikamini tomatiko õtisaaki, kotxi Apiananiri nitxaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Xesosi ikara inaãka atoko, isa aiko Xoteoakori apotiitiniãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Iuaã aua kiki motĩkauakotakari. Iuaã aua apaka pariseoakori Xesosi kinirão apoĩtaka inakani tomatiko õtisaaki iparĩkauatini xika. Ninoa amanaãri Xesosi: —Atauako apakata atxiĩti tomatiko õtisaaki, erekape pitxĩkitakiniri kãkiti? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ininiã Xesosi pimaãna: —Hĩpira soti auĩte tomatiko õtisaaki aariko ãki irikiniã, himakatxakatari? Atãopitikara Teoso sãkire auiritapitikari kãkiti makatxakiniri ipira tomatiko õtisaaki. ");
INSERT INTO apuNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Soti auĩte poiãori, kãkiti apiari. Ininiã Teoso sãkire auiritapitikari tomatiko õti erekape nitxĩkitakiniri kãkiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ininiã itxari kiki motĩkauakotakarimoni: —Poerekauakotauako —itxa. Oerekauakotakasaakiua, erekapeka itxa, ipini uako atokopeka itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Iuasaaki pariseoakori sipeka atoko, ninoakakarika misãkiretakakauana: —Natokopa atxatari Xesosi aõkini? —itxakakana. ");
INSERT INTO apuNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Xesosi imarotakasaakiri ninoa okaenetiniri iua, iuasaakipeka Xesosi sipeka. Itomaneri kãkiti sa iuakata. Ikinika amianatakani erekapeka itxĩkitaka. ");
INSERT INTO apuNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Xesosi !auiritana isãpiretinirina ikamakiti apanakinimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ikara atoko itxa Xesosi, Teoso sãkire sãpiretakari Isaía inakori sãpiretakiti iaõka apokini ĩkapani. Ia atoko itxa Teoso Isaíamoni: ");
INSERT INTO apuNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ia ninitiri nimereẽkiti. Ia nitiretakiti napokaerekatakiti. Nota sikariko Erekari Matamatakoti iuamoni. Iua sãpiretariko nota sãkire Xoteo minakonimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","!Kataparasãkireri ahoa kimaporiti ĩtiniãpo isãkirauatakasaaki. !Ineenamauata. !Itxitakaka apanakinikata kãkiti napiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Apanakini Teoso sãkire auiãkani oiõkapeta ãkixinireẽna. Itapara !auari. Ninoa aanaia katxitoãkori atoko itxana. Iuaritika kona imapirinikari iua aanaia katxitoãkori. Iua atokokana kona ixipokari iua sãkire auiãkani mataparani. Itiretana. Apanakini Teoso sãkire auiãkani, kona iteene auikari Teoso sãkire. Ininiã ninoa tirikapi iopinikare xapitikiri atoko itxana, iuaritika kona iua oakari. Iua atokokana kona ixipokana Teoso sãkire auiãkani. Ikamaãpotari erekari, erekarinoka kãiatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Xoteo minakaniua auikariko iua sãkire. Itxa Isaía sãpirena kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Iuasaaki kãkiti anikari kiki maerekati matamatakoti auaĩtotakiti Xesosimoni. !Isãkirauata. Mõsiãreti itxaua iua, maerekati matamatakoti xika. Xesosi erekapeka txĩkitakari iua. Iuasaaki kõsiãrepeka, kasãkirepeka itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iuasaaki kaiãopokori kãkiti iuaã tsorĩkaãta. Ininiã ipimaãkakauana: —Atauako ia kiki aãuĩte Taviini apika mekanirikani? Atxiĩti Teoso iokanatakitikani? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pariseoakori ikara ikenakotakasaakina: —Konapitini. Maerekati matamatakoti auĩte Peosepoo inakori sikari iposotiire Xesosimoni maerekati matamatakoti omitikini ĩkapani —itxana pariseoakori. ");
INSERT INTO apuNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Xesosi imarotari ikara ixinikakitina. Ininiã itxa Xesosi: —Kãkiti tixine auakani ninoakakarika inaiatakakiniãuana, ixipokakakauana. Iarikapenako. Iua atokokana kãkiti aapokoã auakani inaiatakakiniãuana, ixipokakakauanako. ");
INSERT INTO apuNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Iua atokokana Satanasi nitiriakori, ninoakakarika inaiatakakiniãuana, ixipokako Satanasi tapara. ");
INSERT INTO apuNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hĩte sãkire, Peosepoo sikari iposotiire notamoni maerekati matamatakoti nomitikini ĩkapani. Ininiã nota pimaãi: “Kipa sikari posotiiretxi hĩte moianariakorimoni, maerekati matamatakoti omitikinina ĩkapani?” Himoianariakori sãpiretai: “Teosonoka sikari posotiiretxi maerekati matamatakoti omitikakanimoni.” ");
INSERT INTO apuNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Teoso posotiireẽ nomitikari maerekani matamatakoni. Ikara atoko ininiã, Teoso oerekai iua apokapeka hĩtemoni hĩauĩte inini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—Kiki pataparari iua aapoko auiniã, kona kiĩtiriri ĩroã ĩtiriuatini ĩkapani. Kiĩtiriri iaxirikiniãri iua kiki pataparari, iuasaakiika apakata iĩtirĩkiniri itii. ");
INSERT INTO apuNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Notakata maparĩkauatakani omanatano nota. Imamoianatakaniãno, inirekari niparĩka ixipokini. ");
INSERT INTO apuNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","—Ininiã nisãpiretai. Apakata Teoso makatxakiniri ikinipoko maerekati kãkiti kamakiti, imaerekani Teoso imisãkirepiretini pakini. Txamari Erekari Matamatakoti misãkirepiretakari maerekani makatxakiko kona auari. ");
INSERT INTO apuNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kãkiti misãkirepiretiniãno nota hĩtari iaxitikiri, eereka amanainiãri Teoso ikara imaerekani imakatxakini, ininiã Teoso makatxakapitikari. Kãkiti misãkirepiretiniãri Erekari Matamatakoti, !kimakatxakikori ikara maerekati ikamakiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ininiã Xesosi sãkirauata iuaĩkana pariseoakorimoni: —Aamina atoko hĩtxa. Aamina erekari ininiã, iri erekari apaka. Aamina maerekati ininiã, iri apaka !erekari. Patamatiniãri amãtiiri, pimarotari imina. ");
INSERT INTO apuNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nimarotai hĩte. Imini katsiiri atoko hĩtxaua hĩte. Hĩte maerekati kamakanii. Ininiã !hĩposotari erekari hĩsãpiretini, kotxi hãkixinire !erekari. Hinamaã hĩsãpiretakiti hãkixinireẽ potoriãkari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kãkiti erekari ininiã, erekarinoka isãkire, kotxi iua ãkixinireẽ erekarinoka aua. Kãkiti maerekati ininiã, isãkire maerekati apaka, kotxi maerekatinoka auari iua ãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Atão nisãpiretai hĩte. Ikinipoko kãkiti sãkire Teoso atamakaerekata xipokatxi õtisaaki. Iuasaaki Teoso mereẽri kãkiti misiritiko. Maxikatiĩka hĩsãpiretakiti kona apakata. Kona iua potxitari. Ininiã iuasaaki iua pimaãi: “Kinirepa ikara atoko pisãkire?” itxako. ");
INSERT INTO apuNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pisãkire ereka ininiã, ixika !auari Teoso misiritinii. Pisãkire maerekati ininiã, pisãkire maerekati xika Teoso misiritai —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ãtikaka kaiõkatsoparerini, pariseoakori pakini txari: —Koerekareri, takaõtxikari Teoso posotiire poerekaua ate, aãtamatiniri ĩkapani, Teoso iokanatinii ĩkorapokoriti aimarotini ĩkapani —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Xesosi apakapapiretana: —Kãkiti uatxarini !erekana. Itakanaparina Teoso. Hĩte nirekari noerekinii Teoso takaõtxikare, iposotiire. Konapitini. Kona noerekai hĩte. Kitxakapirĩka Teoso sãkire sãpiretakari Xonasini inakori auakasaaki, Teoso kamari posotiiretxi. Ikara atoko inakari posotiiretxi Xonasini auakasaaki, iuaĩkana ikamapanikariko. Iua posotiiretxi Teoso takaõtxikare itxapanikaua hĩte ĩkapani. Iua takaõtxikarinoka Teoso takaõtxikare hĩte ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Xonasi kaikota ximaki mitari tikako ãki ipi ãti pakini õti. Iua atokokanerako hĩtari iaxitikiri napako ipi ãti pakini õti ipĩkani auiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","—Itixi xipokini õtisaaki, kãkiti Nínivi sitatxiti auakani sãkirauatapitikako. Ninoa txai hĩte: “Kona erekai hĩte, kotxi !hĩtakanapari himaerekani. Ate takanapari amaerekani Xonasi sãkire akenakotakasaaki,” itxanako ninoa. Uatxa uai aua hĩte apisatoõ Xonasi apiatakari. Imisãkiretai hĩte, iuaritika kona !hĩtakanapari himaerekani. ");
INSERT INTO apuNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","—Xipokatxi õtisaaki, sito Sapaa auakani auĩte sãkirauatapitikako. Oa õtakoxiti auakaro, iuaritika osari Saromãomoni imatire okenakotini ĩkapani. Uatxa apopeka Saromão apiatakari, iuaritika hĩte !auikari nota sãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Iuaĩkana Xesosi sãkirauata: —Maerekati matamatakoti kiki auaĩtotakiti takanapakasaakiri iua kiki, iua maerekati matamatakoti saãpota ãparaã makipakaniãtaã, ikaikotiniãtaã initini ĩkapani, txamari !apokari. ");
INSERT INTO apuNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ininiã itxa: “Nikanapiriãpiriko mitxi nauinimoni nipotorikinimonikari,” itxa iua maerekati matamatakoti. Ininiã ikanapiriã. Apokasaaki, ãti iuaã auakari !auari. Oeretapeẽkaika. Iposope ãti auini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ininiã apana apikomoni setxi pakini maerekani matamatakoni apia maerekanitakani. Imakinikana aua iua kiki ĩtoã. Ininiã iua kiki mitxi poiãoka imaerekani, eereka apia maerekanita. Ikara atoko itxako kãkiti uatxarini maerekani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Xesosi sãkirauata itomane kãkitimoni, inakasaaki oãpoka inoro, itariakorikata. Iporikiti auana. Ipĩkapiretarina. ");
INSERT INTO apuNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ininiã ãti txari Xesosi: —Pinoro, pitariakori ikiraã iporikiti auana. Inirekakarina imisãkiretinii pite —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ininiã Xesosi: —Keropa ninoro? Kiripa nitariakori? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ininiã imioakari imoianariakori: —Hãtamata. Uai aua ninoro, nitariakori pakini. ");
INSERT INTO apuNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Niri iaxitikiri nirekaãkiti kamakanira, ninoara nitariakori, nitaroakoro, ninoro txaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Iua õtisaaki Xesosi takanapari iua aapokotxi. Ipoa tiniã isa. Iuaã ipoa tiniã iitopãka. ");
INSERT INTO apuNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iuaã auana itomaneri kãkiti. Apotiitauana iua takote. Ininiã kanaua ãki iereẽtaua, topãka itxa oerekarauatini ĩkapani. Ninoa kaikota imiriĩ. ");
INSERT INTO apuNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ininiã itori sãpirenatxi atão inakari oerekiko isãpiretana ninoa Teoso imarotinina ĩkapani. Ia atoko itxa: —Katakareri potorika itakarauatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Takari iki itakaãpotakasaaki, okaãpotakasaaki, ãtikaka irika kimapori tiniãpo. Kotipiriki apoka. Inikari imakinika. ");
INSERT INTO apuNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Apanakini irika kai auiniãtaã. Poiãoka kipatxi auari, ininiã mokatanitika ipitxaka. ");
INSERT INTO apuNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Txamari, atokatxi papatakari inakasaaki, arikari iua takari. Otxiaroka, kotxi kona kakotsari. ");
INSERT INTO apuNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Apanakinipekana irika aanaia auiniãtaã. Ininiã aanaia aneẽ takari takote. Aãpitsa iapinokari takari, oka txari. ");
INSERT INTO apuNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Apanakinipekana irika kipatxi erekariãtaã. Ininiã iriuata. Ãtiãtaã ãti takari iriuata seĩ oki pakini. Ãtiãtaã takari iriuata sesẽta oki pakini. Ãtiãtaã ãti takari iriuata trĩta oki pakini. ");
INSERT INTO apuNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kakenakokii, ininiã hĩkenakotariko nisãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Imoianariakori apoka Xesosimoni. Ipimaãrina: —Kinirepa sãpirenatxi atão inakari oerekiko pisãpiretari kãkiti? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ininiã Xesosi: —Kãkiti xinikiniãri Teoso auĩtetxi ininiãua pirena, auapitika kaiãopokori ninoa mimarotakiniti, kotxi Teoso kona oerekana ninoa. Teoso oerekai hĩte ninoa mimarotakiniti. ");
INSERT INTO apuNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Teoso sãkire auakiti, iua sãkire kĩpitakari, Teoso sikari apikomoni imaroretxi iuamoni. Txamari Teoso sãkire kenakotakari, isãkire makĩpitakati, imarore xapiti iuamoni auakari makatxakaãkako. ");
INSERT INTO apuNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nisãkirauatakasaaki kãkitikata, nisãpiretana sãpirenatxi atão inakari oerekiko, kotxi kokiri kãkiti, iuaritika !atamatari Teoso kamakiti. Kakenakokiri kãkiti, iuaritika !imarotari Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ininiã apokapeka Isaía sãkire kitxakapirĩka, kotxi iua sãpiretari Teoso sãkire: Hĩkenakotapiikamari nisãkire, iuaritika !himarotari. Hĩtikapiikamari nikamakiti, iuaritika !himarotari, ");
INSERT INTO apuNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","kotxi !hinirekari himarotiniri atão inakari. !Hinirekaikari nisãkire hĩkenakotini. !Hinirekaikari nikamakiti hãtamatini. Hinirekaãkamariko, hãtamatamariko nikamakiti. Hinirekaãkamariko, hĩkenakotamariko nisãkire. Hinirekaãkamariko, himarotamariko nisãkire. Hĩkanapiriaãkamako notamoni, nimakatxakamariko himaerekani, itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","—Hĩtepekana, Teoso sikari erekari hĩtemoni, kotxi hõki atamatapitikari iua kamakiti. Hĩkenakoki kenakotapitikari iua sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Atão nisãpiretai. Itomaneri Teoso sãkire sãpiretakani, apanakini kiki atão inakari kamakani pakini kitxakapirĩka nirekari atamatiniri hĩte atamatakiti, txamari kona atamatarina. Inirekarina ikenakotinirina hĩte kenakotakiti, txamari kona ikenakotarina —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Xesosi sãkirauanãtapanika: —Hĩtakaõtxikari ikara sãpirenatxi atão inakari oerekiko, katakareri pirena. Noerekai ikara. ");
INSERT INTO apuNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kãkiti kenakotakasaakiri Teoso auĩtetxi ininiua pirena, imimarotakaniãri ikenakotakiti, kimapori kãkiti katxaratakiti ikotaxiti atoko itxa iua ãkixinire, kotxi Satanasi apoka iuamoni. Imakatxakari Teoso sãkire iua ãkixinireẽ apokakari. Teoso sãkire takariki atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","—Takariki kai auiniãtaã iriãkari, Teoso sãkire ipoxokoniritika apakapakari atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Itxama kona okanani aua, kotxi kona kakotsari. Omanatiko inakasaaki, inapetiko inakasaaki, Teoso sãkire auikini xika, itakanapari Teoso sãkire auikini. ");
INSERT INTO apuNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","—Ãti kãkitipekana kenakotari Teoso sãkire, txamari ixinikapikari tiitxi, nipokori, iparĩka pakini. Ikinipoko ixinikapika, ininiã maerekaxiniretinoka itxa. Txineiro ipotxitini xika !inirekaikari Teoso sãkire. Takariki aanaia auiniãtaã iriãkari atoko itxa iua. Takari mariti atoko itxa iua ãkixinire. ");
INSERT INTO apuNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","—Ãti kãkitipekana ikenakotakasaakiri Teoso sãkire, atão iua auikari. Iua ãkixinire kipatxi erekari atoko itxa. Takari mininiua atoko, iua kãkiti minari atxiĩti seĩ pakini kãkiti Teosomoni isãkire auikinina ĩkapani. Atxiĩti iminari sesẽta pakini kãkiti. Atxiĩti iminari trĩta pakini kãkiti Teosomoni isãkire auikinina ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iuaĩkana Xesosi sãpiretari ãti sãpirenatxi atão inakari oerekiko. Ininiã ia atoko itxa: —Teoso auĩtetxi ininiua ia atoko itxa. Teoso katakareri atoko itxa. Iua katakareri takari erekari takariki ikikioteẽ. ");
INSERT INTO apuNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ãti ĩkanõkati ikinimane imakasaaki, imokaiakari apoka. Itakaro katsotati ahoisi atoko inakaro ahoisi sauaki. Kona !otxa. Iposo atoko ĩkorape itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Takari aneẽka atoko, oriuata. Iuasaaki kãkiti imarotapekari katsotati ahoisi atoko inakaro auapeka. Kona otxa. ");
INSERT INTO apuNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ininiã katakareri nitiriakori apoka iauĩtemonina. “Auĩtetxi, pite takaro takariki erekaro. Nanipa oina katsotati?” itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","—“Amokaiakari takari,” itxa. —“Pinirekatari amaporokiniri?” itxana initiriakori. ");
INSERT INTO apuNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","—“Kona. Katsotati himaporokiniã, atxiĩti himaporokaro nitakare apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hĩtakanapari imakinika aneinina ĩkapani. Oamikosaakirako, omakatxakaãka. Ininiã iuasaakiko nipaniãtaiko hĩte: ‘Merepanika himakatxakaroko katsotati. Hãpotiitaro. Xaminamoni oka inaãkako. Iposo atoko hãpotiitari ahoisi. Hĩtakari nikiena nĩkatiko aikoti ãki.’” ");
INSERT INTO apuNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iuaĩkana Xesosi oerekari ãti sãpirenatxi atão inakari oerekiko. Ininiã ia atoko itxa: —Teoso auĩtetxi ininiua, kiki takiniro mostata iki ikikioteẽ atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mostata iki axapitiki. Apanakini takariki apiata, iuaritika oaneẽka atoko amananiikaro. Aamina otxaua. Ininiã kotipiriki ina. Ikamari ikoa okatiã —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Xesosi iuaĩkana sãpiretari sãpirenatxi atão inakari oerekiko. Ininiã ia atoko itxa Xesosi: —Teoso auĩtetxi ininiãtaãua ĩkorapokoriti ia atokokana itxa. Sito kosekari tirekakari pani. Okoketari axapiti tirekakari pani kaiãopokori triko panikata, ãparaãkata. Eereka ikinika ipe tirekaãpota otxa. ");
INSERT INTO apuNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Xesosi sãkirauatakasaaki kãkitikata, isãpiretari sãpirenatxi atão inakari oerekiko. Ikara sãpirenatxinokara isãpiretari kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ininiã kitxakapirĩka Teoso sãkire sãpiretakari sãpiretakiti apokapeka, kotxi iua txari: Nisãkirauatakasaaki kãkitikata, nisãpiretari sãpirenatxi atão inakari oerekiko. Itixi kamikosaakipanika aua kãkiti mimarotakiniti. Ikara noerekako kãkitimoni, itxa Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Eereka Xesosi takanapana ninoa kãkitipokoni. Iĩroã aapokotxi. Imoianariakori apoka iuamoni. Itxana: —Poerekaua ate ikara sãpirenatxi atão inakari oerekiko, katsotati pirena, mixikanani pisãpiretakiti. Ate !imarotari —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ininiã Xesosi: —Hĩtari iaxitikiri, iua erekari oki taãkari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Itixi iua kikio atoko itxa. Teoso auĩtetakani takariki erekari atoko itxana. Kãkiti Satanasi nakitiakori iua katsotati atoko itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Katsotati takakari Teoso nakitiakori mokaiakari itxaua. Satanasi itxaua. Itixi xipokini õti iua takari amiko õti atoko itxa. Teoso nitiriakori iaxitikini ninoa takari amakani atoko itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Iua katsotati apotiitaãka, xaminamoni oka inaãka. Iua atokotxikana inaãka itixi xipokini õti. ");
INSERT INTO apuNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Hĩtari iaxitikiri iokanatanako initiriakori itiximoni. Apotiitarinako maerekati oerekakani. Apotiitarinako ikinimane maerekati kamakani. ");
INSERT INTO apuNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Iposo atoko Teoso nitiriakori okana ninoa xaminamoni. Iuaã iteene itxiapatana. Akatsatsiriĩtauana. ");
INSERT INTO apuNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iuasaaki atão inakarinoka kamakani aua iotximerena Teoso auĩtetxi ininiãtaãua. Atokatxi iotximere atoko itxa ninoa iotximere. Kakenakokii, ininiã hĩkenakotariko nisãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Teoso auĩtetxi ininiua, txineiro itomanero kipatakoro atoko itxa. Oa txineiro kipataãka kikio. Ãti õti kiki napaãpotakasaaki, apokaro, ininiã iuaĩkana ikipataro. Iteene ipoxokoniuata, ininiã ivẽtxitari ikinika itii, iua kikio iamotini ĩkapani. Eereka sa itxa iua kikio iamotini ĩkapani. Ikara atoko itxa Teoso auĩtetxi ininiua. ");
INSERT INTO apuNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Teoso auĩtetxi ininiua, pérora iamotakari atoko itxa. Iua nitari pérora apia erekari. ");
INSERT INTO apuNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pérora iteene erekari apokiniã, ikinika itii ivẽtxita iua pérora iamotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Teoso auĩtetxi ininiua hetxi ipoaã taãkori atoko itxa. Ikini sereti ximaki apotiita hetxi. ");
INSERT INTO apuNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ixãpokasaaki kaiotaroariti kosekaãpotari itakoãmoni. Iuaã kaiotaroariti iitopãka. Imereẽrina ximaki. Ximaki erekari kotariã itaka. Kãkiti maniãkiniti mapara oka. ");
INSERT INTO apuNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Xipokatxi õtisaaki ikara atoko itxa. Teoso nitiriakori mereẽriko kãkiti. Mapara itakarina erekarini. Mapara itakarina maerekani. ");
INSERT INTO apuNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ininiã xaminamoni okanako kãkiti maerekati kamakani. Iuaã itxiĩtana. Akerakitatsiriĩtauana, kotxi patsiiri. ");
INSERT INTO apuNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Xesosi pimaãna imoianariakori: —Hĩte imarotatari ikara atoko inakari nisãpiretakiti? —itxa. —Ari, aimarotapitikari —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ininiã Xesosi: —Kaiõkatsopareri oerekikosaaki Teoso auĩtetxi ininiua imarotini ĩkapani, imarotari amaneri oerekakori, apaka kitxakari oerekakori. Kaapokori atoko itxa. Iua kaapokori makatxakari apokaerekatakiti mareta ãki inĩkatakiti. Amaneri, kitxakari apaka imakatxaka. ");
INSERT INTO apuNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ikara sãpirenatxi atão inakari oerekiko ixipokapiretaka atoko, Xesosi sipe. ");
INSERT INTO apuNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ikanapiriã Nasaree sitatxitimoni. Ininiã oerekarauata aiko Xoteoakori apotiitiniãtaãua. Ininiã kãkiti tsorĩkaãta isãkire ikenakotakasaakina. Itxana: —Kiripa sikatari iua imarore? Kiripa sikaposotiiretari iua? ");
INSERT INTO apuNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aapokotxi kamakari ãkiri iua. Inoro Maria. Itariakori Txiako, Xoão, Simão, Xotasi pakini. ");
INSERT INTO apuNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Itaroakoro uai apaka aua. Nanipa apaiaõkari ikinika imarore? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ininiã kona inirekarina iua. Ininiã Xesosi txari: —Teoso sãkire sãpiretakari paxitaãka, txamari Teoso sãkire sãpiretakari itixineẽ auakasaaki, inirimane sauaki auakasaaki, !ipaxitaãka. Isãkire !auikaãka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ininiã Xesosi kona kamari itori Teoso posotiire iuaã Nasaree sitatxiti auakani ĩkapani, kotxi kãkiti iuaãkini !auikari isãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Iuasaaki Erotxi Kariréia auakani auĩte txaua. Iuasaaki ikenakopiretari Xesosi pirena. ");
INSERT INTO apuNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Iuasaaki itxana initiriakori: —Iua Xoão kapatxisareri ipĩpekariika õkitapekaua. Iuakara Xesosi txaua. Ininiã uatxa apiata iposota ikamini —itxa Erotxi. Txamari Xesosipitikara. Kona Xoãoni iua. ");
INSERT INTO apuNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mitxi Erotxi paniãtari Xoão kapatxisareri iaxirikiko, itari Piripi ĩtanoro xika. Ouãka Erotxia. Oomanatari Xoão, ininiã itakaãka kateia ãki. ");
INSERT INTO apuNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Mitxi Xoão kapatxisareri txari Erotximoni: —Kona erekari pitari ĩtanorokata pisirĩkini. !Apakata pikamakiti —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ininiã Erotxi nirekamari okiniri Xoão, iuaritika kona okari, kotxi ipĩkana Xoão sãkire auiãkani. Ninoa uãkatari Xoão, Teoso sãkire sãpiretakari ininiua. ");
INSERT INTO apuNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Erotxi kamari kiiniri auini õti pirena. Erotxia ãkero serena iua Erotxi apisatoõ, ikemaĩtxitakini apisatoõ pakini. Ininiã oserenini kamari ninoa poxokoniuatini. ");
INSERT INTO apuNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ininiã Erotxi poxokoniuatakasaaki itxa: —Nisikai imakinika pinireẽkiti pitemoni —itxaro oa. Ininiã osari onoromoni. ");
INSERT INTO apuNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Onoro nirekari Xoão okiko, ininiãkara oamanaãri Xoão kii prato nopini. Ininiã otxari Erotximoni: —Xoão kapatxisareri kii ninireka prato nopini. ");
INSERT INTO apuNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ininiã Erotxi kona erekaxinireri. Kipa ikama? Kotxi ikinimane ikemaĩtxitakini kenakotari isikaenetiniri oa nirekakiti oamoni. Ininiã iua paniãtari oa nirekakiti sikiko oamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ininiã iua iokanatari sotatoakori kateiamoni Xoão kii tsotakiko ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ininiã ninoa minari ikii prato nopini. Isikarina oamoni. Oa sikari onoromoni. ");
INSERT INTO apuNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Eereka Xoão moianariakori sari kateiamoni. Ninoa anikari iĩto akauarimoni. Iuaã ikatarina. Eereka ninoa sari Xesosimoni. Isãpiretarina Xesosi Xoão ipinini pirena. ");
INSERT INTO apuNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Xesosi kenakopiretakasaakiri Xoão okiko, ipotorika kanauaã. Ãtiãtaã iuanani auini nire isa, txamari itomaneri kãkiti imarotari Xesosi sinimoni. Ininiã itakanaparina sitatxi. Isana imiriĩ iua sinimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iua kanĩkiĩtakasaaki, atapari kãkiti apokaãpotini. Ininiã iua amonĩkana ninoa. Imakananitana amianatakani. ");
INSERT INTO apuNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mapiãpeka inakasaaki, imoianariakori apoka iuamoni. Itxarina: —Mapiãpeka. Uai aapokotxi mauakaniãtaã, ininiã uai nipokori !auari. Piokanatari kãkiti aapokotximoni, ininiã iamotarina nipokori iuaãtaã —itxana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Xesosi apakapapiretana: —Nota kona iokanatana isinina. Hĩtekarako sikakienatana ninoa —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ininiã ninoa: —Komiri ipi ipi ãti pakininokara aua atemoni. Ipi ximaki apaka aua. !Apakata —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ininiã Xesosi: —Himina uai notamoni —itxa. Ininiã imoianariakori minari Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Eereka iua paniãtari kãkiti xiti topãkini. Eereka ikosekari komiri sĩko, ximaki ipi pakini. Ininiã iua ionakaãta iaxiti. Itxari: —Niri pisikakiti peerekari —itxa. Ininiã imaxinĩkaãpotari. Isikaãpotana imoianariakori. Ninoa sikaãpotana kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ikinikana nipokota. Ikinimane: —Kamitopekaua ate —itxana. Eereka imoianariakori apotiitari itetakori. Ininiã xãpokaka itxarina tosi kotari. ");
INSERT INTO apuNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iuasaaki sĩko mio kikiãkini nipokota. Sitoãkini, amarini pakini nipokota apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Eereka ipaniãtana imoianariakori kanauaã iereẽtiniua iua apisa ĩpiriãtinina ĩkapani. Ninoa sipeka. Iua kaikota kãkiti itakapiretini nire. ");
INSERT INTO apuNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kãkiti itakapiretanapaka atoko, Xesosi sari oxiratarimoni, Teoso imisãkiretini nire. Ĩkanõkapeka inakasaaki, iuanani iuaã aua. ");
INSERT INTO apuNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Iuasaaki kanaua ipoa apanĩkakiãpeka. Ĩtima apiãkataro kanaua. Ininiã tsakati iteene apoãkata. ");
INSERT INTO apuNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Imaropirĩkatapeka inakasaaki Xesosi sari ninoamoni. Itĩpokota ipoa nopini. ");
INSERT INTO apuNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Imoianariakori atapakasaakiri Xesosi ipoa nopini itĩpokotini, ninoa pĩkarauata. —Kamiri napani —itxana. Akiripoakatana. ");
INSERT INTO apuNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iuasaakipeka Xesosi: —Kataparaxinire hĩtxako. Notara. Kona hĩpĩkarauatape —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ininiã Petro sãkirauata: —Apiananiri. Xesosi pininiãua, pipaniãtano pitemoni napokini ipoa nopini —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ininiã Xesosi: —Uai pina —itxari. Ininiã Petro katxaka. Ipotorika ianini ipoa nopini Xesosimoni isini. ");
INSERT INTO apuNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Txamari kataparari ĩtimati itikasaaki, ipĩkarauata, ininiã ipatapiã itairakaãpota. Ininiã iua akirikata: —Apiananiri. Pimaĩkano. ");
INSERT INTO apuNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Iuasaakipeka Xesosi maĩkari iua. Itxari: —Poiãoka pauikari niposotiire. Kinirepa kona atão pauikari? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Iuaĩkana morõkoka itxauana kanaua ãki. Iuasaaki ĩtima iotoka. ");
INSERT INTO apuNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Imoianariakori kapotoreẽkaua Xesosi apisatoõ: —Apiananiri pitxaua. Atãopitikara Teoso ãkiripitikarai —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ipoa ĩpiriãtana, Xenesaree tõpamoni apoka itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Iuaã kãkiti imarotari Xesosi, ininiã iokanapireta kãkiti ninoa tixine takote auakanimoni: —Amianatakani himina. Ininiã kãkiti minari itomane amianatakani Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Amianatakani amanaãri Xesosi: —Pauiritaua pimãka mapotomatare atakapiotini —itxana. Ikinimane imãka takapiotakani makananitaãka. ");
INSERT INTO apuNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Iuasaaki pariseoakori, kaiõkatsopareriakori pakini apoka Xesosimoni. Xerosareẽkini ninoa. Ipimaãrina Xesosi: ");
INSERT INTO apuNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Kinirepa pimoianariakori kona kamari aãtokiriakorini sãkire iaõka, kotxi inipokotakasaakina, kona arokauakotauana —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ininiã Xesosi apakapapiretana: —Hĩtepekana, kinirepa kona hĩte kamari Teoso sãkire iaõka? Hĩte kamari hõereẽkitinokara, ");
INSERT INTO apuNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","kotxi Teoso txari: “Pipaxitariko piri. Pipaxitaroko pinoro.” Apaka Teoso txari: “Piri, pinoro pimisãkirepiretiniã, pokaãkako.” ");
INSERT INTO apuNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Txamari hĩte oerekari kãkiti: “Kãkiti auakiti iri, inoro pakini nirekiniã, iua manirekakaniãri isikiniri ninoamoni, isãpiretana: ‘Ia nota auakiti nisika Teosomoni.’” Ininiã !isikari ninoa nirekakiti ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ininiã hĩte oerekari kãkiti mapaxitakanina iri, inoro pakini. Ininiãkara hĩte sãkire hõereẽkiti kipatari Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hĩte txari: “Akamapitikari Teoso sãkire iaõka,” txamari kona hĩte kamari. Atãopitikara Isaía sãkire kitxakapirĩka. Iua sãpiretari Teoso sãkire hĩte pirena. Teoso txari: ");
INSERT INTO apuNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Kamisirienererini ninoa kãkiti. Ninoa sãkireẽnanira ipaxitanona. Ãkixinireẽna !inirekanona. ");
INSERT INTO apuNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Maxikatiĩka ninoa kapotoreẽkaua nota apisatoõ. Maxikatiĩka ninoa txano: “Ateosone pitxaua,” kotxi ninoa !oerekari nota sãkire. Ninoaka sãkire oerekana, txamari “Teoso sãkire asãpiretai” itxana. Itxa Teoso Isaíamoni kitxakapirĩka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Xesosi akiritana kãkiti, ininiã itxana: —Hĩkenakota himarotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nipokori, piixirãkakiti kona kamatxikotari pãkixinire. Pisãkire maerekati, pinamaã potoriãkari, iuara txikotapitikari pãkixinire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Iuasaaki Xesosi moianariakori apoka iuamoni. Itxarina: —Pimarotatari pariseoakori !apokaerekatari ikara pisãkire ninoamoni? ");
INSERT INTO apuNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ininiã Xesosi: —Kãkiti takari atoko itxa. Ininiã ikinika takari niri iaxitikiri mataãkiniti maporokaãkako. ");
INSERT INTO apuNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kona himaãkatapena pariseoakori. Ĩkiikakani mõsiãreni atoko itxana. Mõsiãreti mĩkiikiniãri mõsiãreti, ikinipoko irikako aariko ãki. Iua atokokana maerekati õtãkikiniãri maerekati, imakinika ninoa sari imisiritikoãtaã —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ininiã Petro: —Poerekaua ate ikara sãpirenatxi atão inakari oerekiko. Ate !imarotari —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ininiã Xesosi: —Hĩte apanakini atoko hĩtxa atxiĩti? Kona himarotapanikari? ");
INSERT INTO apuNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Himarotari. Nipokori hinamaã hiĩxirãkakiti hĩtikakomoni isa. Eereka hĩtikatakasaaki, inapa. ");
INSERT INTO apuNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Hĩsãkire hinamaã pokĩkakari potorika hãkixinireẽ. Iuara txikotari kãkiti ãkixinire. ");
INSERT INTO apuNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kotxi hãkixinireẽ hĩxinikakiti maerekati potorika. Okaniuatakatxi, ãti kãkiti ĩtanorokata sirĩkiko nire, anokaretxi, ĩtiriuatakatxi, misirieneretxi, ãti misãkirepiretiko pakini potorika hãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ikara atoko inakarinanira txikotari kãkiti ãkixinire. Kãkiti marokauakotakaniua kona txikotari ãkixinire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ikara atoko inaãka atoko Xesosi sipe. Isipeka Txiro, Sitoõ pakini tõpamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Iuasaaki sito Kanaaãkero, iuaã auakaro, apoka Xesosimoni. Iteene oamanaãri: —Apiananiri, Tavii apika mekaniri, piamonĩkano. Maerekati matamatakoti auaĩtotaro namarite. Iua iteene misiritaro oa —otxari. ");
INSERT INTO apuNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Txamari Xesosi kona apakapapiretaro oa. Imoianariakori apoka Xesosimoni. Itxana: —Piokanataro, osipekako. Atemoni ãtipirika oãkiripoanãta —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Xesosi apakapapiretaro oa: —Niokanataãka Isaeokini ninĩkatini ĩkapani. Ninoa soti auĩte pĩpinanaãkani atoko itxana. Txamari pite kona Isaeokero. Pite ãto uãka —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Iuaritika oa sito apoka iuamoni. Okapotoreẽkaua iua apisatoõ. Ininiã oa: —Apiananiri, pimakananitaro namarite —otxari. ");
INSERT INTO apuNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ininiã Xesosi: —Isaeokini amarini atoko. Nota ninoa iri atoko. Kona erekari amarini komirite nimixirikini, anãpamoni nisikini ĩkapani —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ininiã oa: —Ari, atãopitikara pisãkire. Anãpa atoko nitxaua, iuaritika anãpa nikari nipokori iriãkari kaapokori patapi koa —otxa. ");
INSERT INTO apuNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ininiã Xesosi: —Atãopitikara. Sito, pite iteene auikari niposotiire. Pinirekakiti nikamapitikako —itxaro. Iuasaakipeka oimi erekapeka otxa. ");
INSERT INTO apuNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Eereka Xesosi sari Kariréia poatimoni. Iuaã oxiratari nopini topãka itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Itomane kãkiti iuamoni apoka. Ninoa minari iuamoni kãkiti mõsiãreni, masãkireni, matĩpokotakani, apanakini amianatakani itomaneri pakini. Xesosi makananitana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kãkiti iuaã auakani tsorĩkaãta, kotxi itikarina Xesosi makananitinina amianatakani. Kãkiti masãkireti sãkirauatapeka. Kãkiti matĩpokotakati tĩpokotapeka. Mõsiãreti, kõsiãrepeka itxapeka. Ikinimane txari: —Peerekari Teoso, Isaeo auakani Teosone —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Xesosi akiritana imoianariakori. Itxana: —Nota amonĩkana naia kãkiti. Ipi õti, ãti õti pakini notakata auana. Uatxa kona minakati kona auari inikinina ĩkapani. Kona nota iokanatana ninoa natxiritika, kotxi arikama ipĩtaxititamana, irika itxamana —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ininiã imoianariakori txari: —Nanipa ate apokari nipokori komiri naia kãkiti asikakienatini? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ininiã Xesosi: —Kipakinipa komiri aua hĩtemoni? —itxa Xesosi. Ininiã ninoa: —Setxi komiri, ãtikaka ximaki axapitiri pakini —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ininiã Xesosi: —Hĩpaniãtana kãkiti xiti topãkini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Eereka imaĩkari ninoa setxi komiri, ximaki pakini. Itxari Teoso: —Erekapitikari ia komiri, ximaki pakini pite sikakiti. Mapixinika itxari komiri, ximakikata. Eereka xanakaãpota itxari imoianariakorimoni. Ininiã ninoa xanakaãpotari kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ikinika nipokota. Kamitopeka itxana. Imoianariakori xãpokakari setxi kotari nipokori itetakori. ");
INSERT INTO apuNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ipi ipi pakini mio kikiãkini nipokotapeka, apaka sitoãkini, amarini pakini. ");
INSERT INTO apuNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Eereka Xesosi iokanatana kãkiti aapokomonina. Iposo atoko iereẽtaua kanaua ãki. Makataã tõpamoni isa. ");
INSERT INTO apuNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pariseoakori, satoseoakori pakini sari Xesosimoni. Inirekarina Xesosi kerokiniri, ininiã itxarina Xesosi: —Takaõtxikari, Teoso posotiire poerekaua ate, aãtamatiniri ĩkapani, Teoso iokanatinii ĩkorapokoriti aimarotini ĩkapani —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Txamari Xesosi txana: —Na noerekai. Mapiãnikata iaxiti põkamarari inakasaaki: “Peereõtiri katana,” hĩtxa. ");
INSERT INTO apuNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Iua atokokana ĩkanõkapanika iaxiti põkamarari, piãkaxitita inakasaaki: “Ãparaãnapani. Kataparari ĩtimatipani,” hĩtxa. Himarotapitikari takaõtxikari iaxiti auakari. Txamari kona himarotari Teoso kamanãtakiti ĩkorakanani. Hĩsãkirauatakasaaki, kãkiti erekarini atoko hĩtxa, txamari maerekati hĩkama. ");
INSERT INTO apuNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kãkiti uatxarini !erekana. Itakanaparina Teoso. Hĩte nirekari noerekinii Teoso takaõtxikare, iposotiire. Konapitini. Kona noerekai hĩte. Kitxakapirĩka Teoso sãkire sãpiretakari Xonasi inakori auakasaaki, Teoso kamari posotiiretxi. Ikara atoko inakari posotiiretxi Xonasi auakasaaki, iuaĩkana ikamapanikariko. Iua posotiiretxi Teoso takaõtxikare itxapanikaua hĩte ĩkapani. Iua takaõtxikarinoka Teoso takaõtxikare hĩte ĩkapani —itxa Xesosi. Iposo atoko Xesosi takanapana, sipe itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Xesosi imoianariakorikata ĩpiriãtari ipoa. Ipiniã apokasaakina, imoianariakori xinikaro pão imaxinĩkaretakitona. ");
INSERT INTO apuNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iuasaaki Xesosi õtãkikana ninoa: —Erepaniko. Pariseoakori, satoseoakori pakini pãote tireẽkari pamonõkoniri —itxana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ininiã imoianariakori misãkiretakakaua: —Pão amaxinĩkaretini xika Xesosi ikara atoko txaua ate —itxana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Xesosi imarotari imisãkiretakakiniuana, ininiã iua: —Kinirepa himisãkiretakakaua, pão himaxinĩkaretini xika? Kona iteene hãuikari ninĩkatinii. ");
INSERT INTO apuNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Atauako kona kiĩkitepanikai hĩte? Atauako himaxinĩkaretapekari pão sĩkonoka sĩko mio kãkiti nisikakienatini? Hĩxinikariko kipakinipa kotari hĩxãpokaka pão itetakoro? ");
INSERT INTO apuNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Atauako kona hĩxinikatari ãti õti ipi ipi pakini mio kãkiti setxinoka pãoã nisikakienatini? Hĩxinikariko kipakinipa kotari hĩxãpokaka pão itetakoro? ");
INSERT INTO apuNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hĩte nõtãkikasaaki: “Erepaniko. Pariseoakori, satoseoakori pakini pãote tireẽkari pamonõkoniri,” ninakasaakii, kinirepa kona himarotatari kona pãoni ikara atoko nitxai hĩte? —itxa Xesosi ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Iuasaakiika imarotarina kona pão tireẽkarini monõkori txaua. Imarotarina pariseoakori, satoseoakori pakini sãkirera, ninoa oereẽkitira, monõkori txaua. ");
INSERT INTO apuNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Xesosi sari Sesaréia-Piripi sitatxiti takote. Iuaã ipimaãna imoianariakori: —Kipa kãkiti uãkatano nota hĩtari iaxitikiri? ");
INSERT INTO apuNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ininiã imoianariakori: —Ãtikaka uãkatai Xoãoni kapatxisarerini iuaĩkana õkitikaua inakarii. Apanakini uãkatai Eríasini iuaĩkana õkitikaua inakarii. Apanakinipekana uãkatai Xeremiani iuaĩkana õkitikaua inakarii. Minakanisaaki ãtikaka: “Ãti Teoso sãkire sãpiretakarini iuaĩkana õkitikaua inakarii,” itxaina —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ininiã Xesosi: —Hĩtepekana, kipa hĩte uãkatano nota? —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simão Petro apakapapiretari: —Teoso mereẽkitirai pite. Teoso mapĩkati ãkirirai pite —itxari iua. ");
INSERT INTO apuNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ininiã Xesosi: —Simão Petro, Xoão ãkiri, Teoso takari erekari pitemoni, kotxi kona kãkitini sãpiretai Teoso ãkiri nininiua. Niri iaxitikirira sãpiretai. ");
INSERT INTO apuNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nisãpirenauatapanika pitemoni. Piuãka Petro. Kai sorotxikana piuãka. Kai aapokotxiti kamakari mereẽri kai kaikori xiti itakini ĩkapani, aapokotxi iua kai nopini ikamini ĩkapani, ininiã aapokotxi !irika, kotxi kaikori nopini aua. Aapokotxi kamakari takari kai kaikori xiti. Iua kai atoko itxa ikara Teoso sãkire, isãpiretakiti pitemoni. Kãkiti nota nakitiakori naapoko atoko, ninoa sauaki nauini ĩkapani. Napotiinãtapanikari kãkiti naapoko ĩkapani. Satanasi tapara kona posotapaniri ixipokiniri ia naapoko. ");
INSERT INTO apuNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nipaniãtai Teoso sãkire pisãpiretini kãkitimoni. Xavi nisikinii atoko itxa ikara, kotxi kãkiti auikasaakiri Teoso sãkire iĩroã Teoso auĩtetxi ininiãtaãua. Ĩkorapokoriti kãkiti kamakiti pimauiritakaniã, Teoso tixine apaka !auiritaãka. Ĩkorapokoriti kãkiti kamakiti pauiritiniã, apaka auiritaãka Teoso tixine —Xesosi txari Petro. ");
INSERT INTO apuNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Iposo atoko Xesosi: —Teoso mereẽkiti nininiua, apanakinimoni !kasãpirena hĩtxapeko —itxana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Iua õtisaaki Xesosi potorika isãpiretinina imoianariakori: —Nisako Xerosareẽmoni. Iuaã kiomãtxiakori, kaiõkatsoparerini, sasetotxi auĩteakori pakini misiritanoko. Iposo atoko oka ninaãkako. Ipi ãti õtisaaki iuaĩkana nõkitikaãkako. Iuaĩkana aua nitxako —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ininiã Petro misãkiretari Xesosi iuanoka inakasaaki. Itapararitika itxari: —Konapitini, kona ikara atoko inakari kona auapani pitemoni, Apiananiri. Kona Teoso auiritapaniri ikara atoko piniko —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ininiã Xesosi kirioka Petromoni. —Pisipiniikaua Satanasi. Nikimapore katokapareri atoko pitxa, kotxi pite nireẽkiti kãkiti nireẽkiti atokotxikana. Pite nireẽkiti kona Teoso nireẽkiti atokoni —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Iposo atoko Xesosi misãkiretana imoianariakori: —Notakata kinirão sika pinakasaaki, piteka nireẽkiti kona pinirekape. Notakata kinirão sika pinakasaaki, nota misiritiko atokokana pimisiritaãkako. Ia atoko pinirekiniã, notakata pisapitikako. ");
INSERT INTO apuNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pite ãtipirika kaminiãri pite nireẽkitinoka, ininiã pinireẽkiti xipokapitikako pitekata. Pite nireẽkiti pimanirekakaniã, nota sãkire pauikini xika, Teoso iokanapirena erekari pisãpiretini xika, pite auapininiika txako Teosokata. ");
INSERT INTO apuNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Atxiĩti papakapari ikinipoko tiitxi, ikini itixiti auakani tii, pinakiti ĩkapani. Atxiĩti iua tiitxi xika kona pikĩpitari Teoso sãkire, ininiã kona pikaikota ãtipirika Teosokata. Ikara atoko ininiã, erekari atxiĩti ikinipoko tiitxi auinii? Konapitini. Apiaerekata Teosokata ãtipirika pikaikotini. !Apakata kãkiti iĩkitxitiniri Teoso, iuamoni isini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nota hĩtari iaxitikiri apokako ninitiriakorikata. Iuasaaki niri iotximeretxikana nota iotximeretako. Iuasaakirako erekari isika erekari kamakanimoni. Iparĩkana ĩki isika iparĩkana iaõka. Txamari imisiritanako maerekati kamakani. ");
INSERT INTO apuNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Atãopitikara nisãpiretai hĩte. Uai uatxa aua kãkiti, ninoa imarotapanikariko nota hĩtari iaxitikiri auĩtetxi nininiua. Ikara imarotinina apisa kona ipinapanikana —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seisi õti napaka atoko Xesosi anikana Petro, Txiako, Xoão pakini. Xoão Txiako itari. Ikanĩkana oxiratari nopinixiti. Ninoanani anika iuaã. ");
INSERT INTO apuNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iuaã ninoa atamatari iua. Ipinimonipo itxapeka. Itoõ iotximere atokatxi iotximere atoko itxa. Imãka serõka ipinikare atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iuasaakipeka Moisesi, Eríasi pakini tokiã iuaã, misãkireta itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ininiã Petro akiritari Xesosi: —Apiananiri, erekapitikari uai aãuini. Pinirekiniãri, nota kamari ipi ãti pakini papiri uai. Pite nakiti ĩkapani, Moisesi nakiti ĩkapani, Eríasi nakiti ĩkapani nikama. ");
INSERT INTO apuNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petro sãkirauanãtakasaaki, katxiãri pomẽkoriri ninoa nopini apoka. Katxiãri ãki Teoso txari: —Ere namarite, nitiretakiti. Napokaerekatari iua, kotxi ikamari ninirekakiti. Hĩkenakotariko iua sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Xesosi moianariakori ikara atoko inakari ikenakotakasaakina, iteene ipĩkarauatana, ininiã iriãkatana xitipe. Itoõna ikipatana. ");
INSERT INTO apuNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Xesosi sari ninoamoni. Itakauakotaua ninoa nopini. —Hõkitikaua. Kona hĩpĩkarauatape —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ininiã itikapokotana. Xesosinoka aua. ");
INSERT INTO apuNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Oxiratari xirata iokiriiãpotakasaakina, Xesosi txana ninoa: —Kona hĩsãpiretapiri apanakinimoni hĩtikakiti. Nota hĩtari iaxitikiri nipina iuaĩkana naua ninaka atokoikarako hĩtikakiti mixikanani hĩsãpiretako —itxana. —Ateeneka —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Xesosi moianariakori pimaãri iua: —Kinirepa kaiõkatsoparerini oerekaua: “Eríasi apokako Teoso mereẽkiti apokini apisa?” ");
INSERT INTO apuNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ininiã Xesosi apakapapiretana ninoa: —Ari, atãopitikara ninoa sãkire. Merepitipanika Eríasi apokapitika. Iua kamari imakinika iposope inini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ari, nisãpiretai, Eríasi apokapeka. Txamari kãkiti !imarotari iua. Imisiritarina iua inireẽkitina iaõka. Iua atokotxikana itxanonako nota hĩtari iaxitikiri. Imisiritanona —Xesosi txana Petro, Txiako, Xoão pakini. ");
INSERT INTO apuNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ininiã imoianariakori imarotari Xesosi sãkire. Eríasi, Xoão kapatxisareri itxaua. ");
INSERT INTO apuNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ikanapiriãkana atoko, itomaneri kãkiti apotiitiniãtaãua apokasaakina, kiki apoka Xesosimoni. Ikapotoreẽkaua iua apisatoõ. ");
INSERT INTO apuNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Itxari: —Apiananiri, piamonĩkari namarite. Maerekati matamatakoti auaĩtotari iua. Atatsiirauata. Xaminaã irikapika. Kãuaãriã ikomokapika. ");
INSERT INTO apuNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Niminamari namarite pimoianariakorimoni. Ninoa kona posotari erekapeka itxĩkitakinirina. ");
INSERT INTO apuNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ininiã Xesosi txari: —!Kauikarei hĩte. Maerekati kamakanii hĩte. Kipakinikananipa Teoso nirekatari hĩtekata nauini? Kipakinikananipa Teoso nirekatari hĩte nimĩteenekini? Himinari amarini notamoni —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Apokaãka atoko, Xesosi txitari iua maerekati matamatakoti: —Pisipe. Ininiã iua maerekati sipe. Iuasaakipeka iua amarini erekapeka itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Eereka imoianariakori apoka Xesosimoni. Iuasaaki ninoanoka aua iuakata. Imisãkiretarina: —Kanatokopa ininiãpa ate kona posotari maerekati matamatakoti aomitikini? ");
INSERT INTO apuNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ininiã Xesosi: —Kona atãoni hãuikari nisãkire, ininiã kona hĩposotari homitikiniri iua. Atãoenepitikara nisãpiretai hĩte. Mostata iki axapitikiri. Axapitipitika nisãkire hãuikiniã, mostata iki atoko nisãkire hãuikiniã, hĩposotari ia õtanoxiratari hĩpaniãtini: “Pite oxiratari, uai posipika, ikaimoni pisa,” ininiã oxiratari sapitikamako. Hĩte posotari ikinipoko hinireẽkiti hĩkamini. ");
INSERT INTO apuNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Txamari himamisãkiretakaniãri Teoso, hinipokotini himatakanapakaniã Teoso himisãkiretini ĩkapani, ininiãra kona hĩposotari maerekati matamatakoti homitikini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kariréia tõpa apokasaakina, Xesosi misãkiretana imoianariakori: —Nota, hĩtari iaxitikirino mĩkapiritaãkako. Nisikaãkako kikiakorimoni inirekaãkitina ikaminina tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ninoa okano nota. Ipi ãti pakini õtisaaki iuaĩkana nõkitikauako, iuaĩkana aua nitxako —itxana ninoa. Ikara inakari ikenakotakasaakina, imatinaniuatana. ");
INSERT INTO apuNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kapanaoõ sitatxiti apokasaakina, kikiakori sari Petromoni. Ninoa kiki apakaparo txineiro Teoso misãkiretiko aikoti nĩkatakani amanaãkito. Ipimaãrina Petro: —Hĩte oerekakari sikataro txineiro Teoso misãkiretiko aikoti nĩkatakani amanaãkito? —itxarina iua Petro. ");
INSERT INTO apuNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ininiã Petro: —Ari, isikapitikaro —itxa. Eereka Petro ĩroã aapokotxi ãki ikara sãkiretxiti Xesosi isãpiretini ĩkapani. Xesosi sãkirauata, Petro masãkirauatakani apisa: —Petro, ikini itixiti kipa sikataro txineiro auĩtetxiakorimoni? Atauako auĩtetxi nirimane sikataro? Atauako kãkiti ãtiãtaã ĩkanikani sikataro? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Kãkiti ãtiãtaã ĩkani sikaro txineiro auĩtetximoni —itxa Petro. —Ari atãopitikara. Ininiã kona auĩtetxi nirimaneni sikaro txineiro iuamoni. Iuaritika asikapitikaro. ");
INSERT INTO apuNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Txineiro amasikakaniã, txineiro apotiitakani !apokaerekataua. !Anirekari ikara atoko inakari. Ininiã ipoa pisa. Pokatsaãta. Pimanamãkaro ximaki merepitipanika pimaĩkakito. Onamaã papokaro txineiro ota aĩkitxirauatini ĩkapani. Oa txineiro ota apakata nota sikakito ĩkapani, pite sikakito ĩkapani apaka. Panika. Pisikaro oa txineiro Teoso misãkiretiko aikoti nĩkatakanimoni —itxa Xesosi. Ininiã Petro kamari Xesosi sãkire iaõka. ");
INSERT INTO apuNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Iuasaaki Xesosi moianariakori apoka iuamoni. —Teoso auĩtetxi ininiãtaãua, kipa kãkiti apiatakari txataua? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Xesosi akiritari amarini axapitiri. Ninoa apisatoõ taka itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Atãopitikara nota sãkire. Himaerekani himatakanapakanisaaki, Teoso nireẽkiti himakamakanisaaki, amarini axapitiri atoko himinakanisaaki, kona hĩsapani Teoso auĩtetxi ininiãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ia amarini axapitiri !iuikaua. Kãkiti ia amarini atoko inakarira, iuaka poiãotakiniãua, iuara apiatakari itxaua Teoso auĩtetxi ininiãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nota nireẽkiti pikamakasaaki, pipoxokoniritika papakapiniãri amarini ia atoko inakari pinakasaaki, papakapano nota apaka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Xesosi sãpirenauatapanika: —Kãkiti txĩkitakiniãri amarini, nota sãkire auiãkari, maerekati ikamini, !apakata. Erekamariko kai mitari iua kãkiti maerekati oerekakari iaxirikanokitaãkamako, iposo atoko ipoa apanĩkakiã okaãkamako ipinini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kãkiti ikini itixiti auakani misiritaãkako, kotxi auari kãkiti maerekati apanakini kamini txĩkitakakani. Auapika kãkiti ikara atoko inakani. Ninoa misiritaãkako. ");
INSERT INTO apuNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Piuako txĩkitakiniãi maerekati pikamini, ininiã pitsotakari, oka pitxariko. Pikiti txĩkitakiniãi maerekati pikamini, ininiã pitsotakari, oka pitxariko. Kotxi maerekati pikaminiã arikatxi maxipokatimoni pokaãkako. Apiaerekata mauakotikai pauini ãtipirika Teosokata. Apiaerekata makititikai pauini ãtipirika Teosokata. Pauiritiniãri maerekati pikamini txĩkitaãkari pitekata ikaikotiniã, ininiã pite kamari maerekati apaka, ininiã arikatxi maxipokatimoni pokaãkako. ");
INSERT INTO apuNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Iua atokokana poki txĩkitakiniãi maerekati pikamini, pimaporoka, oka pitxariko. Kotxi maerekati pikaminiã, arikatximoni maerekani misiritikoãtaã pokaãkako. Apiaerekata Teosokata ãtipirika pauini ãti pokinoka pauini. Kona pauiritapiri maerekati pikamini txĩkitaãkari pitekata ikaikotini —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","—Ikinipoko amarini pipaxitako, kotxi niri tixine aua niri nitiriakori. Ninoa nĩkatari amarini. Niri apisatoõ ãtipirika initiriakori auapika, ininiã kãkiti mapaxitakaniãri amarini, isãpiretarina niri. ");
INSERT INTO apuNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nota hĩtari iaxitikiri napoka ĩkorapokoriti kãkiti pĩpinanaãkani atoko inakani napokini ĩkapani, kotxi !imarotarina Teoso kimapore. ");
INSERT INTO apuNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","—Kiãtokopa itxa hĩxinikakiti? Kiki aua ipiraakori soti auĩte seĩ pakini. Txamari ãtika pĩpinanaka. Kiãtokopa itxa? Itakanapari ipiraakori novẽta novi pakini. Isari oxiratarimoni. Initari iua pĩpinanaãkari. ");
INSERT INTO apuNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ipiraakori novẽta novi na pĩpinanaka, ininiã ipoxokoniuata. Apokasaakiri iua pĩpinanaãkari, iteene ipoxokoniuata. ");
INSERT INTO apuNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iua atokokana hĩri iaxitikiri kona nirekari amarini ãtika pĩpinanakini. Hĩri nirekari imakinika amarini imarotiniri ikimapore iuamoni sikari apo —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Pitari nisãkire auiãkari kaminiãri maerekati pitemoni, ininiã pisa iuamoni. Pitenoka pisa iuamoni. Iuanani pimisãkiretako. Põtãkikiniri ikĩpitakasaaki, pimoianari iuaĩkana itxapekaua. ");
INSERT INTO apuNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Põtãkikiniri imakĩpitakanisaaki, ipi kãkiti panikako iuamoni. Ipi minakanisaaki ãtika panika iuamoni. Ininiã iuaĩkana põtãkikari iua maerekati kamakari. Iuasaaki pitekata sikani apaka õtãkikari. Kotxi Teoso sãkire iõkatsopatakori oerekaua kãkiti sãkire kenakotakani, kãkiti kamakiti itikakani ipi ãti pakini auiniã, apakata apanakini atão inakari imarotini ĩkapani. Ipi ãti minakanisaaki, ipi apakata. ");
INSERT INTO apuNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ninoa pitekata sikani sãkire imakĩpitakanisaaki, pisãpiretana kãkiti Teoso misãkiretikoãtaã apotiitakaniua. Ninoa ikinipoko Teoso sãkire auiãkani õtãkikariko iua. Imakĩpitakanisaakiri ninoa sãkire, himarotari atão maerekati kamakari itxaua iua. Teoso sãkire mauiãkati atoko itxaua iua, kotxi kona inirekari õtãkikiko. Ate mokaiakari moianari atoko itxaua —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","—Atãopitikara nitxai hĩte. Ĩkorapokoriti kãkiti kamakiti himauiritakiniti, Teoso tixine apaka !auiritaãka. Ĩkorapokoriti kãkiti kamakiti hãuiritakiti, apaka auiritaãka Teoso tixineẽ. ");
INSERT INTO apuNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","—Apikomoni ia nisãpiretai. Pite xinikakititxikana ãti xinikiniã apaka, hinirekakiti hamanainiãri Teoso, niri iaxitikiri sikapitikai hamanaãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kãkiti apotiitakasaakiua nota ixinikinina ĩkapani, nota ninoakata aua. Atxiĩti ipi ãtinoka aua. Atxiĩti ipinoka aua. Iuaritika nota aua ninoakata —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petro sari Xesosimoni, pimaã itxari Xesosi: —Apiananiri, kipakinikatapa napakapari nitari, maerekati ikaminano ãtipirika inakasaaki? Setxikata atxiĩti? ");
INSERT INTO apuNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ininiã Xesosi: —Kona, kona setxikatani papakapari iua. Setxikata setẽta papakapari iua, ininiã ãtipirika papakapariko. ");
INSERT INTO apuNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—Apikomoni noerekai papakapiniri kãkiti, maerekati ikamakasaaki pitemoni. Teoso auĩtetxi ininiua patrão ia atoko inakari itxa. Ia patrão nirekari initiriakori iĩkitxitiniri iua. ");
INSERT INTO apuNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ininiã iua iaõtaro txineiro isikakitopeka. Iuasaaki initiri minaãka iuamoni. Mitxipeka iua patrão sikari tesi mirão txineiro ota iua initirimoni. Txineiropokoni. Oa txineiro isikasaaki, itxari initiri: “Ãti õti iuaĩkana pisikano oia nitxineirote,” itxari initirimoni. Txamari, !isikaro, kotxi !oãuaika. ");
INSERT INTO apuNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kona katxineiroteri. Ininiã ipatrãote paniãtari ivẽtxitiko iua, ĩtanoro, imiakori, itii ikinipoko, ipatrãote iĩkitxitini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Iua initiri ikara inakari sãkiretxiti ikenakotakasaaki, ipatrãote apisatoõ ikapotoreẽkaua. Itxari iua: “Piãtaparoko. Ikinika pitxineirote nisikaiko,” itxari ipatrãotemoni. ");
INSERT INTO apuNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","—Ininiã ipatrãote amonĩkari. “Kona ninirekaikaro nitxineirote pisikinino.” Ininiã auiritari isini. ");
INSERT INTO apuNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","—Ininiã sipe itxa. Iua nitiritxi mitxi sikapekaro txineiro iua inakito seĩ ota ãti ipatrãote nitirimoni. Poiãonoka oa txineiro. Iuasaaki, aapokomoni isikasaaki, aõkitari iua ãti nitiritxi ipatrãote nitiri. Imaĩkari inoakiã. “Uatxa pisikano nitxineirote,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","—Ininiã imoianari kapotoreẽkaua iua apisatoõ. “Piãtaparoko. Ikinika pitxineirote nisikaiko,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","—Txamari mitxiri nitiritxi: “!Niãtapaikaroko,” itxari. Ininiã kateiamoni ieretakakitãkari imoianari txineiro xika. “Ikinika nitxineirote pisikasaakiikanoko, pikatxakako,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ikara inakari ene apanakini iua patrão nitiriakori kenakotakasaaki, ninoa naiataua. Ininiã isana ipatrãotemonina. Isãpiretarina initiri iokanatiniri ãti initiri kateiamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ininiã iua patrão akiritari iua initiri: “Pite maerekati pitxaua, kotxi kita pite amanaãno nota niamonĩkinii, ininiã piĩkitxitinino !ninirekaika. ");
INSERT INTO apuNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kinirepa kona pite amonĩkari pimoianari nota amonĩkinii atokokana? Kona erekai,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","—Ininiã ipatrãote iteene naiataua. Iokanatari iua kateiamoni imisiritikomoni ipatrãote txineirote okinika imasikakanisaaki. ");
INSERT INTO apuNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ininiã Xesosi xipokapiretari ia isãpirena: —Niri iaxitikiri iua atokokana txaiko hĩte, maerekati ãti kamakasaakii hĩtemoni himamaxinĩkaretakaniã hãkixinireẽ —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ikara inaka atoko Xesosi potorika Kariréia tõpa. Isa Xotéia tõpamoni uini Xotão ipiniã. ");
INSERT INTO apuNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Iuaã itomaneri kãkiti sari iuamoni. Erekapeka itxĩkitakana amianatakani. ");
INSERT INTO apuNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pariseoakori apaka sari iuamoni. Inirekarina Xesosi kerokiniri isãkire. Ininiã ipimaãrina Xesosi: —Auiritaãka atxiĩti kiki takanapiniro ĩtanoro, itakanapiniro inirekasaaki? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ininiã Xesosi: —Hĩte imarotapekari ia Teoso sãkire iõkatsopatakori: Kitxakapirĩka merepitipanika ikinipoko Kamakari kamari kãkiti, kiki inini, sito onini apaka ikamari kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ikara atoko ininiã, kiki takanapari iri, inoro pakini, ĩtanorokata auini ĩkapani, ininiã ninoa ãtika atoko itxauana, itxa Teoso sãkire iõkatsopatakori. ");
INSERT INTO apuNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ininiã kona ipi !itxaikauana. Ãtika itxauana. Ikara atoko ininiã, !erekari kãkiti kaiarikiniri Teoso apotiitakini —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ininiã ninoa pariseoakori pimaãri: —Ikara atoko ininiã, kinirepa Moisesi paniãtari kiki iõkatsopatiniri aãtsopa, ĩtanoro itakanapini aãtsopate, ininiã eereka auiritari iua iokanatiniro oa? ");
INSERT INTO apuNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ininiã Xesosi apakapapiretana: —Moisesi auiritai hĩtanoro hĩtakanapini, kotxi paikori hĩxinire. Teoso nireẽkiti himanirekakani xikara, Moisesi auiritai hĩtanoro hĩtakanapini. Txamari kitxakapirĩka merepitipanika kona kiki takanaparo ĩtanoro. ");
INSERT INTO apuNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ininiã nitxai hĩte, kiki takanapiniãro ĩtanoro, ãtikata masirĩkatoka, iua kamari maerekati. Itakiniãro ãto sito, maerekati apiata ikama, kotxi !imaãkatari Teoso paniãtakiti. Oa itakanapakito taãkari apaka kamari maerekati —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ininiã imoianariakori ikara ikenakotakasaakina, itxarina Xesosi: —Ĩtaniritxi, ĩtanorotxi !auiritaãka itakanapakakinina, ininiã erekapiimana imĩtaniriuatakanina —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ininiã Xesosi: —Erekapitikari kãkiti ĩtanorouatini. Ãtikakanoka Teoso kona nirekari ĩtanorouatinina. ");
INSERT INTO apuNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ixika auapitika kãkiti mĩtanorouatakani. Kotxi ãtikaka kiki auakasaaki, iĩtona kona apakata ninoa takiniro sito. Apanakinipekana ikisauakatsikitiko xika kona ninoa posota itakinirona sito. Apanakinipekana kona nirekari ĩtanorouatini Teoso auĩtetxi ininiãua ãtipirika isãpiretini ĩkapani. Teoso manirekakaniãri pite ĩtanorouatini, ininiã kona pĩtanorouatape —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iposo atoko kãkiti minana amarini Xesosimoni. Inirekarina ninoa kii nopini iuako itakini. Inirekarina Xesosi misãkiretiniri Teoso amarini ĩkapani. Txamari imoianariakori txitana. !Auiritana amarini anikinina Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ininiã Xesosi txana imoianariakori: —Hãuiritanako amarini notamoni apokini. Kona hĩotokakapena notamoni apokinina. Kotxi kãkiti Teoso auĩtetakani amarini atoko itxauana —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ininiã iuako itaka ninoa kii nopini. Iposo atoko ĩkorape itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ãtokori apoka Xesosimoni. —Koerekareri erekarii, kiripa erekari nikama ãtipirika Teosokata nauini ĩkapani? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ininiã Xesosi: —Kininiãpa “erekari” pitxano? Kãkiti erekari !auari. Teosonanira erekari. Teosokata ãtipirika pauini pinirekiniã, pikamariko Teoso paniãtakiti. ");
INSERT INTO apuNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—Ĩkiripa? —itxa. Ininiã Xesosi: —!Pokaniuatape. !Pisirĩkape ãti ĩtanorokata. !Piĩtiriuatape. Poxiene !pikamape. ");
INSERT INTO apuNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Piri, pinoro pakini pipaxitako. Pitiretanako apanakini, piteka pitiretiniua atokokana, pitxapaniko —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Nikamapitikari ikara atoko pinakiti. Kiripa apikomoni nikamaã Teosokata ãtipirika nauini ĩkapani? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Ikinika kinirão kamaka pinakasaaki, ikinika pitii pivẽtxitako. Txineiro papakapakito pisika kãkiti matxineirotenimoni. Ikara atoko inakari pikaminiã, Teoso tixine papokasaaki ikinipoko erekari auiniiko pite. Pitii pivẽtxitaka atoko, notakata sa pitxako —Xesosi txari. ");
INSERT INTO apuNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Iua ãtokori ikara ikenakotakasaaki, isipe. Imatinaninoka itxari ãtokori, kotxi kaiãori itii. !Inirekari itii ivẽtxitini. ");
INSERT INTO apuNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ininiã Xesosi txana imoianariakori: —Atãopitikara ia nitxai hĩte. Pamimari katxineiroterini auĩtetiniri Teoso. ");
INSERT INTO apuNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Apikomoni nisãpiretai. Atauako kamero napatari ãkorike sonakiã? Apia mimari kãkiti katxineiroterini auĩtetiniri Teoso —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Xesosi moianariakori ikara ikenakotakasaakina, itsorĩkaãtana. Ninoa uãkatari katxineiroterinimoni txineiro aua, kotxi Teoso apokaerekatana ninoa, ininiã txineiro isika ninoamoni, ninoa uãkatakiti. Ininiã ninoa pimaãri: —Katxineiroteri maposotakaniãri Teoso tixinemoni isini, kipa posotari iuaã isini? —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Xesosi atamatana. Apakapapiretana: —Kãkitika kona posotari. Teoso posotari ikinipoko ikamini. ");
INSERT INTO apuNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petro misãkiretari Xesosi: —Atepekana, ate takanapapekari ikinipoko pitekata asini ĩkapani. Ikara atoko aniniã, kiripa ate apakapako? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ininiã Xesosi: —Atãopitikara nitxai hĩte. Nota, hĩtari iaxitikiri niitopãkako auĩtetxi itopanere nopini. Iuasaaki ikini itixiti amaneri itxauako. Ikinipoko atamatanoko nota hĩtari iaxitikiri iotximere. Iuasaaki hĩte nisãkire kĩpitakanii apaka topãkako auĩtetxi itopanere nopini. Iua iitopaneretxi tosi pakini. Tosi nirimanetxi Isaeo tixine auakani auĩteakori hĩtxauako. ");
INSERT INTO apuNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Atxiĩti nota ĩkapani pitakanapari paapoko, pitariakori, pitaroakoro. Atxiĩti nota ĩkapani pitakanapari piri, pinoro, pamarite. Atxiĩti pitakanapari pikikiote nota ĩkapani. Ikara pitakanapakasaaki nota ĩkapani, apiata papakapariko. Itori papakapariko. Ikara atoko pininiã nota ĩkapani, ãtipirika paua Teosokata. ");
INSERT INTO apuNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Itori kãkiti apiarini uatxa, itixi xipokini õtisaaki poiãorini itxapekauana. Uatxa itori kãkiti poiãorini, apiarini itxapekauana itixi xipokini õtisaaki —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Xesosi txari: —Teoso auĩtetxi ininiua ia kakikioteri atoko itxa. Ia kakikioteri takapekari txipokori ova inakoro ikikioteẽ. Ovanoka itaka. Oiõpeka onakasaaki, iua kakikioteri potorika ĩkanõkapanika. Initari parĩkauatakani ova amakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Aõkitakasaakina, ipimaãna: “Hinirekatari parĩkatxi?” itxa. —“Ari, anirekapitikari,” itxana. —“Atauako ãtoka txineiro ota pirata kamakori apakata ãti õti pokamara piparĩka ĩki ĩkapani?” itxana. —“Ari, apakatapitika,” itxana. Kotxi ãtoka ota pirata kamakori iuasaaki atão parĩkatxi ĩki ãti õti pokamara kãkiti parĩkauatini ĩki. Ininiã itakaremoni iokanatana iparĩkauatinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","—Novi oarape inakasaaki iuaĩkana ipotorika. Nipokori vẽtxitikoãtaãmoni isa. Iuaã atamatana kãkiti maparĩkauatakani. ");
INSERT INTO apuNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ininiã imisãkiretana: “Hĩte apaka atxiĩti nirekatari hĩparĩkauatini nitakareãtaã, ininiã niĩkitxitai atão inakari hĩparĩka ĩki,” itxa. Ininiã ninoa apaka sari. ");
INSERT INTO apuNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","—Apaniãxitipeka inakasaaki iuaĩkana iokanatana apanakini parĩkauatakani itakaremoni. Itinĩtikitakasaaki iuaĩkana iokanatana apanakini parĩkauatakani itakaremoni. Mitxi isãkire atokokana itxa isãkire ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mapiãnikata takotepeka inakasaaki iuaĩkana isa parĩkauatakani initini. Apokapanikana maparĩkauatakani. Ipimaãna: “Kinirepa ia õti maparĩkauatakanika hĩtxa?” itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","—“Kotxi kona kãkiti sikaua parĩkatxi,” itxarina. —“Nitakareãtaã hĩsa. Iuaã hĩparĩkauata. Hĩte apakapariko hĩparĩka ĩki erekari,” itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Ĩkanõkapeka inakasaaki kakikioteri akiritari initiri apiari: “Parĩkauatakani pakirita. Piĩkitxitana. Merepanika piĩkitxitana kikata parĩkauatakani. Eereka piĩkitxitana tinĩtikita parĩkauatakani, pitxaãpotako,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","—Kikata parĩkauatakani imakinikana apakapari ãtoka txineiro ota pirata kamakori. ");
INSERT INTO apuNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kikiãkini ĩkanõkapanika parĩkauatakani ikara itikasaakina, oãkatarina: “Ate apakaparoko apiatako aparĩka ĩki,” itxamana. Ãtoka txineiro ota pirata kamakoro imakinikana apakapana. ");
INSERT INTO apuNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Txineiro apakapakana atoko, omanãkarauatana. “!Erekari kakikioteri,” itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ininiã ninoa txari iua: “Naia kikata parĩkauatakani poiãoka iparĩkauatana. Ãto oaranoka iparĩkauanãtana. Ate parĩkauata ikiniõtika kapatakariã. Ate parĩkauatapitipo, txamari pite ĩkitxitaua ate naia piĩkitxitini atokokana. Kona erekai,” itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","—Iua kakikioteri apakapapiretana: “Nitiretakini, kona nota misirienetai hĩte. Ĩkanõkapanika nipimaãi: ‘Atauako ãtoka txineiro ota pirata kamakori apakata ãti õti pokamara piparĩka ĩki ĩkapani?’ nitxai mixikanani. Ininiã hĩte: ‘Ari, apakatapitika,’ hĩtxa. Ininiã na nimisirienetai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ininiã txineiro nisikakito hanikaika. Haãpokomoni hĩsipeka. Nota nirekari niĩkitxitinina hĩte tikini parĩkauatakani hĩte niĩkitxitini iaõka. ");
INSERT INTO apuNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Atauako kona erekari nota txineirote ninirekakitimoni nisikini? Hĩte xikotano, erekari nikamini xika,” itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Xesosi xipokari isãpirena: —Itori kãkiti apiarini uatxa, itixi xipokini õtisaaki poiãorini itxapekauana. Uatxa itori kãkiti poiãorini, apiarini itxapekauana itixi xipokini õtisaaki. Teoso aiatana kaiãopokori kãkiti itixine isinina ĩkapani, txamari poiãonoka iua mereẽ —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Xesosi Xerosareẽmoni ikimaporitakasaaki, akiritana imoianariakori. Ninoanoka imisãkireta. ");
INSERT INTO apuNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Hĩkenakotari nisãkire. Xerosareẽmoni asako. Iuaã nota hĩtari iaxitikiri mĩkapiritaãkako. Sasetotxi auĩteakori, kaiõkatsoparerini pakinimoni nisikaãkako, ininiã ninoa apotiitaua. Iuasaakiko ninoa txari: “Okaãkapitikako.” ");
INSERT INTO apuNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Eereka ninoa sikano Xoteo minakonimoni. Ninoa napetano. Ixirokitatanona aãpitsaã. Iposo atoko aamina ĩpiriãmitakariã tokakita ninaãkako, oka itxanonako. Ipi ãti õtisaaki nõkitikauako, iuaĩkana aua nitxako —itxa imoianariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Eereka Sepeteo ĩtanoro apoka Xesosimoni. Ominana imi Txiako, Xoão pakini. Ninoa Txiako, Xoão pakini Xesosi moianariakori. Okapotoreẽkaua iua apisatoõ. —Atauako ninirekakiti pikaminano? —otxari. ");
INSERT INTO apuNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—Kipa pinireka? —itxaro. —Ikinimane auĩte pinakasaakiua, ninirekari naia ipi namariteni auĩtetxiakori ininiãuana pitekata. Pauiritatana pitekata iitopãkinina, ãti pikikomoni inini, ãti pisaneremoni inini? —otxari. ");
INSERT INTO apuNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ininiã Xesosi apakapapiretana ninoa: —!Himarotari hamanaãkiti. Mapaõti napa atoko iteene nimisiritaãkako. Atauako hĩposotatari hãtatsiitiniri notakata? —itxana ninoa. —Aposotapitika —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Atãopitikara hãtatsiirauata notakata, txamari kona notani mereẽna kãkiti nikikomoni, nisanaremoni topãkakani ĩkapani. Nirira mereẽpekana ninoa kãkiti notakata topãkini ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Apanakini Xesosi moianariakori kenakoenetari Txiako, Xoão pakini amanaãri Xesosi auĩtetxi ininiuana ĩkapani, ininiã omanatana. ");
INSERT INTO apuNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ininiã Xesosi akiritana ninoa imakinikana iuamoni. —Himarotari Xoteo minakaniua auĩteakori paniãtari kãkiti ikinika auĩteakori nireẽkiti ikaminina ĩkapani. Kona atão itiretana kãkiti. Kãkiti kona kamari auĩtetxiakori mauiritakiniti. ");
INSERT INTO apuNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kona ninoa auĩtetxiakori atoko !hĩtxape. Atão apiari pininiua pinirekiniã, pimoianatariko apanakini. ");
INSERT INTO apuNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Apanakini auĩte pininiã pinirekiniã, nitiritxi pitxauako merepanika. ");
INSERT INTO apuNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ikara atoko nitxa nota hĩtari iaxitikiri ĩkorapokoriti napokasaaki. Ninitiri !auari. Ĩkorapokoriti napoka, kãkiti nitiri nininiua ĩkapani, kãkiti nitiretini ĩkapani. Ĩkorapokoriti napoka nipinini ĩkapani, kaiãopokori kãkiti mapinakani ĩkapani, kotxi nota iĩkitxirauata ninoa mapinakani ĩkapani —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Xerikoo sitatxiti ipotorikasaakina, itomaneri kãkiti sari Xesosikata, imoianariakori pakinikata. ");
INSERT INTO apuNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Iuasaaki ipi mõsiãreni topãkanãta kimapori tiniãpo. Xesosi napaãpotini ikenakotakasaakina, akiritana: —Apiananiri, aãuĩte Taviini apika mekanirii, piamonĩkaua ate —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kãkiti iuaã pinitana: —Himaãtako —itxana. Txamari apiata akirikatana: —Apiananiri, aãuĩte Taviini apika mekanirii, piamonĩkaua ate —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ininiã Xesosi iotoka. Akiritana ninoa mõsiãreni. Apokana iuamoni. —Kipa hinireka nikaminii hĩte? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Apiananiri, aĩtikapokotini anireka. ");
INSERT INTO apuNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ininiã Xesosi amonĩkana. Okina nopini itakari iuako. Iuasaakipeka kõsiãrepekana, sa itxana Xesosikata. ");
INSERT INTO apuNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Xesosi imoianariakorikata imatokoãpotari Xerosareẽ. Apokana Petxipaxee inakori aapokotxiti, õtanoxiratari takote Oriva inakori xiratamoni. Iuaã Xesosi iokanatana ipi imoianariakori aapokotximoni. ");
INSERT INTO apuNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Hĩsa ikiraã kaixiti auakari aapokotxitiã. Iuaxiti hãpokasaaki, hãpokaroko xomẽta iaxiriãkoro oimikata. Hĩkoxirikana. Uaimoni mina hĩtxanako. ");
INSERT INTO apuNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ãti misãkiretakasaakii: “Kinirepa hĩkaxirikatari pirãtxi?” Ininiã hĩte: “Apiananiri nirekana,” hĩtxako. Ininiã iua auiritai himininina —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kitxakapirĩka Teoso sãkire sãpiretakari sãpiretapekari ikara atoko inakari. Ininiã iua sãpiretakiti kitxakapirĩka atão inakari apokapeka. ");
INSERT INTO apuNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Iua txari: Hĩtxariko Xerosareẽ auakanimoni: “Hãtamata. Hĩauĩte apokaãpota hĩtemoni. !Kaneenamari. Xomẽta nopini iitopãkanãta. Xomẽta ãkiri nopini isaãpota,” hĩtxako ninoamoni, itxa Teoso sãkire sãpiretakari kitxakapirĩkapeka. ");
INSERT INTO apuNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ininiã Xesosi moianariakori sari. Ipaniãtakiti iaõka ikamana. ");
INSERT INTO apuNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ininiã iminaro xomẽta oimikata. Itakarina imãkana inopinina Xesosi topãkini ĩkapani. Ininiã Xesosi topãka xomẽta ãkiri nopini. ");
INSERT INTO apuNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Itomaneri kãkiti katamẽkari imãkana kimapori ãpo. Apanakini sauakari aãxike. Ikasirĩkaxikeãpotarina aãxike kimapori ãpo. Ikara atoko ikamana, Xesosi paxitiko oerekinina ĩkapani. Imãkana nopini, aãxike nopini, xomẽta napaãpota. ");
INSERT INTO apuNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kãkitipokoni ĩkiikakani. Kãkitipokoni Xesosi tikini ĩkani. Imakinika saãpotakasaakina, akirikatana: —Peerekari Tavii apika mekaniri. Teoso posotiirekata ĩkari, Teoso nireẽkiti kamakari iua. Teoso sikariko erekari iuamoni. Peerekari Teoso, iaxiti apiko nopinixiti auakari. Apiananiri itxaua —itxaãpokatana. ");
INSERT INTO apuNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ininiã Xesosi apokapeka Xerosareẽ. Iuasaaki ikinimane Xerosareẽ auakani tsorĩkaãta. —Kirinapanipa ikira kiki inatari? —itxanãtakakana. ");
INSERT INTO apuNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kãkiti Xesosikata ĩkani sãpiretana: —Xesosikara ikira. Teoso sãkire sãpiretakari, ikira. Nasaree sitatxitikiri, Kariréia tõpa auakari ikira —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Xesosi ĩroã aiko ãki Teoso misãkiretikoãtaã. Omitikenatana tiitxi vẽtxitakani. Amotiitakani Teoso misãkiretikoãtaã auakani omitikenata. Ikitakari txineiro vẽtxitakani mesate. Kamoa vẽtxitakani topãkini apaka ikitaka. ");
INSERT INTO apuNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Xesosi misãkiretana: —Teoso sãkire iõkatsopatakori txari: Ia naapoko, “Teoso misãkiretiko aikoti” akiritaãkako, itxa. Txamari hĩte txĩkitakari ia aiko kiĩtiririni iomaãtiniãtaã ininiua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mokirini, kãkiti matĩpokotakani pakini apoka Xesosimoni Teoso misãkiretiko aikotiã. Erekapeka itxĩkitakana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Iuasaaki amarini Teoso misãkiretikoã auakani iteene akirikata: —Peerekari aãuĩte Taviini apika mekaniri —itxanãtana. Sasetotxi auĩteakori, kaiõkatsoparerini pakini itikari Xesosi posotiire, kãkiti erekapeka itxĩkitakini. Ninoa kenakotari amarini akiritakiti: —Peerekari aãuĩte Taviini apika mekaniri. Ininiãkara ninoa omanãkarauata. ");
INSERT INTO apuNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ininiã imisãkiretarina Xesosi: —Pikenakotatari ikara amarini akiritakiti? —itxana. —Nikenakotapitikari. Hĩte atatsopatapekari ia Teoso sãkire iõkatsopatakori: Ãtokoriakori, amarini pakini, ninoapeka apaka txariko: “Peerekari iua,” itxanako, itxa Teoso sãkire iõkatsopatakori. Ininiã Teoso sãkire iaõka ninoa kamanãta. Ininiã erekapitikari ninoa akiritakiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Iposo atoko itakanapana. Ĩkorape itxa. Itakanapari Xerosareẽ. Isa aapokotximoni Petánia inakorimoni. Iuaã itxiaka. ");
INSERT INTO apuNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Katimatinĩkata iuaĩkana Xesosi sari sitatximoni. Ipixinipokoriti inatxita. ");
INSERT INTO apuNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Atamataro piko mina kimapori ĩtiniãpo. Isa oamoni txipokori itximini ĩkapani. Txamari otsopanani auaro. Iuasaaki itxa: —Kona kariikaiko —itxaro. Iuasaakipeka otxiaroka. ");
INSERT INTO apuNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Imoianariakori ikara itikasaakina, itsorikitaãtana. —Ii natokopa otxape katimari otxiarokini? —itxanãtana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ininiã Xesosi: —Atão nisãpiretai. Teoso sãkire hãuikiniã, hĩte posotari hĩkaminiri mixikanani nikamakiti atoko inakari. Piko mina txiarokini nitxĩkitakini atoko, hĩposota hĩkamini. Teoso sãkire iteene hãuikiniã, apiata hĩkamako. Hĩposotamariko hĩpaniãtiniri ikira ixirata: “Põkitikaua. Ipoamoni oka pitxaua.” Iuasaakipekamako ixirata ipoamoni oka itxamauako. ");
INSERT INTO apuNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pite atão pauikiniãri Teoso sãkire, iua pimisãkiretakasaaki, ikinipoko pamanaãkiti Teoso sikai —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Xesosi ĩroã Teoso misãkiretiko aikotiã. Kãkiti oerekasaaki, sasetotxi auĩteakori, kiomãtxiakori pakini apoka iuaã. Ipimaãrina Xesosi: —Kipaniãpa pikamari ĩkora pikamakiti? Kipa paniãtai? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ininiã Xesosi: —Nota apaka pimarauatako hĩtemoni. Ãtinoka nipimaãiko hĩte. Nota pimaãkitiko hĩtemoni hĩsãpiretiniãno, nota apaka sãpiretai hĩte hĩpimaãkiti notamoni, ininiã nisãpiretai nota paniãtakari uãka apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ia nipimaãi hĩte: “Kipa paniãtari Xoãoni ipatxisarauatini? Teosokani paniãtari Xoão? Kãkitikani paniãtari Xoão?” —itxana. Ininiã ninoa misãkiretakakaua: —“Teoso paniãtari,” aniniã, “Kinirepa kona hãuikatari isãkire?” Xesosi txamaua eereka. ");
INSERT INTO apuNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Kãkitira paniãtari Xoão,” aniniã, apanakini omanatamaua, kotxi ninoa uãkatari Xoão Teoso sãkire sãpiretakari ininiua. Ikara atoko itxana imisãkiretakakiniuana. ");
INSERT INTO apuNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ininiã apakapapiretana: —!Aimarotari iua paniãtakari. Ininiã Xesosi: —Nota apaka kona sãpiretai nota paniãtakari uãka. ");
INSERT INTO apuNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","—Hĩxinikariko ia nisãpiretakitiko: Kiki auari ipi imi. Akiritari anekari. “Namarite uatxa piparĩkauata nitakare ova auiniãtaã,” itxari imi. ");
INSERT INTO apuNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","—Ininiã imi anekari: “!Nisapani. !Ninirekari niparĩkauatini,” itxari. Eereka ixinikaxitinãta. “Ari, nisapitikako,” ininiã isa iri takaremoni. ");
INSERT INTO apuNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","—Iua kiki akiritari imi maneritakari. Ipaniãtari iua atokokana. Iua imi: “Ari, nisapitikako.” Txamari, !isari. ");
INSERT INTO apuNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","—Ininiã ĩkiripa kamatari iri paniãtakiti? —itxa Xesosi. Ininiã ninoa kiomãtxiakori, sasetotxi auĩteakori pakini apakapapiretari: —Anekarira. Ininiã Xesosi: —Atãopitika nisãpiretai hĩte. Kiĩtiriri apokako Teoso auĩtetxi ininiãtaãua hĩte apisapanika. Kanokarero apokako Teoso auĩtetxi ininiãtaãua hĩte apisapanika. ");
INSERT INTO apuNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kotxi Xoão kapatxisarerini apoka hĩtemoni. Oerekai erekari kimaporiti. Txamari kona hĩte auikari isãkire. Kiĩtiriri, kanokarero pakini auikari isãkire. Iuasaaki himarotari ninoa maerekati kamakani takanapiniri imaerekanina. Ikamarina erekarinoka. Hĩte itikapekari. Txamari hĩte kona takanapari himaerekani. Kona hãuikari Xoão sãkire, ininiã iua kiki sãkire makĩpitakati atoko hĩtxa, kotxi hĩsãkire: “Akĩpitapitikari Teoso sãkire,” txamari kona hĩkĩpitari —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Ãti sãpirenatxi atão inakari oerekiko nisãpiretai. Hĩkenakota —Xesosi txana. —Kiki kakikioteri takaro txipokori ova inakoro. Ovanoka itaka. Iposo atoko ipiriketaro. Eereka iuaãtaã ikamari ova katsonakiko. Iposo atoko ikamari aapokotxi õtanori, ikinipoko itakare atamatini ĩkapani. Iposo atoko iĩkitxitana kikiãkini itakare nĩkatakani ĩkapani. Ininiã ninoa nĩkatari itakare. Eereka kakikioteri sari ãti itixiti. ");
INSERT INTO apuNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ova manapi inakasaaki, iokanatana initiriakori itakare nĩkatakanimoni, ova apakapinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","—Txamari, ninoa maĩkapena initiriakori. Ixirokitatarina ãti. Okapirina ãti. Ãti kai soroã ikiporonakana. ");
INSERT INTO apuNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Iuaĩkana iua kakikioteri iokanatana initiriakori. Iuasaaki ito iokanata. Mitxirini atokokana itakare nĩkatakani txapena ninoani. ");
INSERT INTO apuNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Eereka imapotõkire iokanatari imi ninoamoni. Iuãkatari: “Namarite iua, ininiã ninoa paxitari iua,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","—Txamari, imi atapakasaakina, imisãkiretakakana: “Erepani imi. Maõkari, ininiã okinika itakare kaikotinaua atemoni.” ");
INSERT INTO apuNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ininiã imaĩkarina imi. Kikio xiripirexiti anikarina. Iuaã oka itxapirina. Ininiã Xesosi pimaãri kãkiti iua takote auakani: ");
INSERT INTO apuNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","—Ininiã iua kakikioteri ĩkasaaki, kiãtokopa itxatanako ninoa kikiãkini? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ininiã ninoa iua takote auakani apakapapiretari: —Kakikioteri okanako ninoa maerekati kamakani. Iĩkitxitanako apanakini itakare nĩkatakani ĩkapani, ininiã ninoa sikapitikaroko ova oiõkasaaki —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ininiã Xesosi: —Hĩte atatsopatapekari ia iõkatsopatakori Teoso sãkire: Kai aapokotxi kamakani kona nirekari ãti kai soro. Iua kai imanirekakiniti kai apiari itxapekaua. Apanakini kai soro maĩkakari itxaua. Teosokara txĩkitakari ikara atoko inini. Ikara peerekari atemoni. Nota hĩtari iaxitikiri iua kai atoko nitxaua. Peerekari Teoso, kotxi nota hĩtari iaxitikiri kãkiti manirekakiniti. Teoso txĩkitakano nota apiananiri nininiãua. ");
INSERT INTO apuNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","—Ininiã nisãpiretai hĩte, Teoso kona hĩauĩte !itxaikauako. Iua mereẽriko apanakini kãkiti inakitiakori ĩkapani. Ninoa kamapitikari Teoso nireẽkiti. ");
INSERT INTO apuNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Apikomoni Teoso sãkire iõkatsopatakori sãpiretaua iua kai apiari atoko inakari. Itxari: Kãkiti iua kai nopini irikasaaki, ikarouata iua. Kai kãkiti nopini irikiniã, !auaika kãkiti, —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sasetotxi auĩteakori, pariseoakori pakini kenakotakasaakiri ikara sãpirenatxi atão inakari oerekiko Xesosi sãpiretakiti, ninoa !apokaerekatarina isãpirena, kotxi imarotarina ninoa takari nĩkatakani maerekani atoko inakani itxauana. ");
INSERT INTO apuNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ininiã ia xika inirekarina imaĩkinirina. Txamari !imaĩkarina, kotxi ipĩkarina kãkiti iuaã apotiitakaniua. Kãkitimoni Xesosi atão Teoso sãkire sãpiretakari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iuaĩkana Xesosi sãkirauatakasaaki kãkitikata, isãpiretari sãpirenatxi atão inakari oerekiko. Itxari: ");
INSERT INTO apuNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Teoso auĩtetxi ininiãua ia auĩtetxi atokokana. Ia auĩtetxi kamari kiiniri imi ĩtanorouatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ipaniãtari initiriakori akiritinina ikemaĩtxitakini kiiniriã ininina ĩkapani. Txamari ikemaĩtxitakini !inirekari ikiiniriteẽ isinina. ");
INSERT INTO apuNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Iuaĩkana iokanatari apanakini initiriakori ikemaĩtxitakinimoni. “Hĩtxanako: ‘Nipokori iposopeka. Nokapekari kema auĩte, kema auĩte ãkiri pakini. Paĩpepokori. Imakinika niposotapekari. Hĩsapoka kiinirimoni,’ hĩtxanako.” Ininiã ninoa kamari isãkire iaõka. ");
INSERT INTO apuNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","—Txamari ikemaĩtxitakini !imaãkapiretarina. Iparĩkamoni isana. Ãtikaka sari kikiomoni. Apanakini sari ãtiãtaã tiitxi ivẽtxitinimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Apanakinipekana maĩkapena initiriakori, noropata, oka itxapena. ");
INSERT INTO apuNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Iua auĩtetxi ikara inakariene ikenakotakasaaki, iteene inaiataua. Iokanatari isotatoneakori ninoamoni. Ininiã okapena ninoa kokanirini. Iotikapirina ninoa aapoko. ");
INSERT INTO apuNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","—Eereka iua auĩtetxi akiritana apanakini initiriakori: “Kiiniri namarite ĩtanorouatini pirena iposopeka. Txamari merepitipanika nikemaĩtxitakini !erekana. ");
INSERT INTO apuNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Iua atoko ininiã, hĩsa ahoaãtaã, kãkiti napanakiniãtaã. Hĩkemaĩtxitana ikinimane haõkitakini,” itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","—Ininiã isana ahoaãtaã. Ikemaĩtxitana ikinimane aõkitakini. Apotiitarina kãkiti itanapoko. Maerekani, erekarini pakini apotiitana. Anikana kiinirimoni, ininiã kãkitipokoni xãpoãkata. ");
INSERT INTO apuNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","—Iua auĩtetxi atamatana ikemaĩtxitakini. Atamatari kiki mãkatxi ĩtanorouatikosaaki ieretaãkori mieretaãkati. ");
INSERT INTO apuNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ininiã akiritari iua: “Nimoianari, kiãtokopa piĩroã naapoko, kotxi mãkatxi ĩtanorouatikosaaki ieretaãkori kona pieretaka?” Iua kona kasãkireri. ");
INSERT INTO apuNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","—Ininiã iua auĩtetxi paniãtari initiriakori: “Himaĩkariko. Hĩaxirikariko iuako, ikitinota pakini, anika hĩtxariko mapara. Piãkatximoni hõkariko,” itxana initiriakori. Iuaãtaã kãkiti txiapatiniãtaã, kãkiti akerakitatsiriĩtiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Xesosi xipokapiretari isãpirena. —Itomaneri kemaĩtxitakoni. Txamari poiãoka mereẽkoni —itxana ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ninoa pariseoakori sipeka. Eereka apotiitauana. Imisãkiretakakana. Ixinikaxitinãtarina: —Anirekari Xesosi kerokiniri isãkire, aãpoĩtiniri ĩkapani. Ininiã kiãtokopa atxatari apimainiri ikerokiniri ĩkapani? —itxanãtakakana. ");
INSERT INTO apuNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ininiã ninoa pariseoakori paniãtana ãtikaka ninoa oerekakini, apaka ãtikaka Erotxi sãkire auiãkani, Xesosimoni isinina ĩkapani. Ininiã isana iuamoni. Imisãkiretarina. Pariseo sãkire iaõka isãpiretana. —Koerekareri, aimarotari atãoenepitikara pisãkire. Atãoenepitikara pisãpiretari Teoso nireẽkiti akamini ĩkapani. Pite na pĩkarauata xatiki kãkiti sãkire xika. Ãtinoka pisãkire pisãpireta ikinakariti kãkitimoni. Apanakinimoni pisãpiretakiti iuatxikana pisãpiretari apanakininapemoni. ");
INSERT INTO apuNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ininiã pisãpiretaua. Atãokani txineiro asikini Homanoakori auĩtemoni, Sesa inakorimoni? Apakata amasikakaniri iuamoni? —itxarina iua. ");
INSERT INTO apuNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Xesosi imarotari ninoa nirekari ikerokiniri isãkire. Ininiãkara itxana: —Kinirepa hinirekari nikerokiniri nisãkire? Kona erekai hĩte. Hĩsãkirauatakasaaki, kãkiti erekarini atoko hĩtxa, txamari maerekati hĩkama. ");
INSERT INTO apuNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hõerekano txineiro ota Homano auĩte asikini ĩkapani. Ininiã iminarona txineiro ota. ");
INSERT INTO apuNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","—Kisanõkapa ia? Kiuãkapa aua uai? —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Ari, Homano auĩte —itxana. —Ininiãkara hĩsikariko Sesamoni iua nakiti. Hĩsikariko Teosomoni iua nakiti —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ikara apakapapirenatxi ikenakotakasaakina itsorĩkaãtana. —Paimatireri iua —itxanãtakakana. Ininiã itakanaparina, sipeka itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Iua õtisaakipeka ãtikaka satoseo apoka Xesosimoni. Satoseo inakoni !auikari ipĩkani iuaĩkana õkitikiniua. ");
INSERT INTO apuNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Koerekareri, Moisesinira oerekari ia sãkiretxiti: “Kiki meenetipanika ipininiã, iua itari takaroko tikinitakoro. Iua itari keene ininiã, itakauãkatari amarini iua itarini ipĩpekarini uãka,” itxa Moisesini. ");
INSERT INTO apuNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Setxi itaritxiakori aua mitxi ĩkorapokoriti. Apia anekatakari ĩtaniriuata. Eereka ipĩpe meenetika, ininiã itari takaro iuani tikinitakito. ");
INSERT INTO apuNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Iua atokokana iua itari ipĩpe meenetika. Ãti itari iuaĩkana takaro iuani tikinitakito. Txamari iua atokokana ipĩpe meenetika. Iua atokokana txaãpota ikinika itariakori. ");
INSERT INTO apuNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Eereka oa sito apaka opĩpe. ");
INSERT INTO apuNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ininiã ipĩkani iuaĩkana õkitikasaakiua iuaĩkana auãki ininina, ĩkiripa oĩtaniri aua oakata iuasaaki? Kotxi ikinimane ninoa setxi itariakori takapekaro oa —itxarina iua. ");
INSERT INTO apuNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ininiã Xesosi: —Hĩte kerokari, kotxi !himarotari Teoso sãkire iõkatsopatakori. !Himarotari Teoso posotiire apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ipĩkani iuaĩkana aua inakasaaki, kona ninoa ĩtaniriuataika. Teoso nitiriakori iaxitikini atokopeka itxanako. ");
INSERT INTO apuNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Hĩte !auikari ipĩkani õkitikiniua iuaĩkana auãki inini. Atauako kona hãtatsopatapanikari Teoso sãpiretakiti hĩtemoni? Iara isãpiretai: ");
INSERT INTO apuNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Apraão, Isaki, Xakoo pakini Teosonekarano nota, itxa Teoso. Ininiã Apraão, Isaki, Xakoo pakini auãkipanika itxana, kotxi auãki inakani Teosonera iua. Ninoa uatxa auãki inakani, kotxi kona ipĩkani Teosoneni Teoso —itxa Xesosi. Iuasaaki kãkitipokoni kenakotari ikara Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Xesosi sãkire ikenakotakasaakina, itsorĩkaãtana, kotxi paimatireri Xesosi apakapapiretakiti satoseoakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Xesosi iĩkiteritika apakapapiretari satoseo pimainiri, ininiã satoseo !ipimarauataika. Pariseoakori kenakotari ikara, ininiã apotiitauana. ");
INSERT INTO apuNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pariseo, Moisesi sãkire oerekakari, iua nirekamari Xesosi kerokiniri isãkire. Ininiã ipimaãri: ");
INSERT INTO apuNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Koerekareri, ĩkiripa Teoso paniãtakiti apiari txataua? Kipa apiaerekata Teoso nireẽkiti akamini? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ininiã Xesosi apakapapiretari: —“Pitiretariko Apiananiri piTeosone, ikinipoko pinireẽkitiã, ikini pãkixinireẽ, ikinipoko pixinikakitiã pakini.” ");
INSERT INTO apuNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ikara atoko inakari Teoso merepitipanika paniãtaua akamini. Ia ipaniãtakiti akamini apiari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Iuaĩkana Teoso paniãtaua. Ia ipaniãtakiti apaka apiari. Merepanika ipaniãtakiti akamini atoko itxa. “Piteka pitiretiniãua atokotxikana, pitiretariko ãti.” ");
INSERT INTO apuNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Iteene atiretiniãri Teoso, iteene atiretiniãri ãti, ininiã akamapitikari apanakini Teoso paniãtakiti, Moisesinimoni isãpiretakiti. Iteene atiretiniãri Teoso, iteene atiretiniãri ãti, ininiã akamapitikari Teoso sãkire sãpiretakani paniãtakiti apaka —Xesosi txari iua. ");
INSERT INTO apuNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pariseoakori apotiitapanikaua inakasaaki, Xesosi pimaãna ninoa: ");
INSERT INTO apuNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Teoso mereẽkiti pisãpiretano. Kiripa apika mekaniripa iua? —itxana ninoa. Ninoa apakapapireta: —Ari, Taviini apika mekanirira —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ininiã Xesosi: —Ikara atoko ininiã, kinirepa Erekari Matamatakoti kamasãkiretari Tavii: “Teoso mereẽkiti niauĩte itxaua,” ina sãkiretini? ");
INSERT INTO apuNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Kotxi Tavii txari: Apiananiri misãkiretari niauĩte: “Nota kikomoni piitopãkiniritika nixipokariko pimokaiakariakori. Nikamariko ninoa pikiti pitakiniãtaã atoko ininiua,” Apiananiri txari niauĩte, itxa Taviini. ");
INSERT INTO apuNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ininiã Tavii akiritari Teoso mereẽkiti “niauĩte.” Ikara atoko ininiã, kiãtokopa itxa Teoso mereẽkiti Taviini apika mekaniri ininiãua? —Xesosi txari pariseoakori. ");
INSERT INTO apuNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kona imarotarina, ininiã kona kasãkirena ninoa. Ikara eereka kona kãkiti pimarauataika Xesosimoni, kotxi ipĩkarina Xesosi imarore. ");
INSERT INTO apuNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ininiã Xesosi misãkiretana imoianariakori, itomaneri kãkiti iuaã auakani apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ia atoko isãpiretana: —Kaiõkatsoparerini, pariseoakori pakini, Moisesini sãkire oerekakani itxauana. ");
INSERT INTO apuNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ininiãra ikinika kaiõkatsoparerini, pariseoakori pakini paniãtakiti hĩkamako, kotxi ninoa sãpiretari Moisesini sãkire Teoso oerekakiti. Ikara erekari. Txamari kona ninoa kamari Moisesini paniãtakiti. Ikara !erekari. Ininiã ninoa kamakiti atoko !hĩkamape. Kotxi isãkirena erekari, txamari ikamakitina !erekari. ");
INSERT INTO apuNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ninoa kaiõkatsoparerini, pariseoakori pakini, kiki ia atoko inakari ninoa. Ia kiki takari iminani imoianariakori porikiã, txamari iuaka na xatiki nirekari iporikitiniri. Kaiõkatsoparerini, pariseoakori pakini, ikara kiki atoko itxana. Ninoa paniãtakiti iua iminani atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","—Pariseoakori kamari erekari apanakini atamatini ĩkapaninoka, ereka ininina apanakini uãkatini ĩkapaninoka. Himarotari kãkiti ieretakari Teoso sãkire iõkatsopatakori aãkoana xapitikiri ãki. Eereka iaxirikarina iteẽtaãna, iuakonotaãna pakini. Ninoa kaiõkatsoparerini, pariseoakori pakini takari aãkoana mitari apanakini atamatini ĩkapaninoka. Paĩtanori itsarãpe imãkana apanakini atamatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kiinirisaaki ninoa nirekari kãkiti potxitiniãtaã iitopãkinina. Aiko ãki Xoteoakori apotiitiniãtaãua inirekarina kãkiti potxitiniãtaã iitopãkinina. ");
INSERT INTO apuNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Apokaerekatarina okapiretikona ipaxitikona kienatxi vẽtxitikoãtaã. Apokaerekatarina kãkiti akiritinina: “Koerekareri” inikona. ");
INSERT INTO apuNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","—Txamari, ãtinani hĩte oereẽkari txaua, Teoso mereẽkitira iua. Koerekareri hiniko !hãuiritapeko, kotxi himakinikara hĩtaritakakaua. ");
INSERT INTO apuNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kona ĩkorapokoriti auakari “niri,” !hĩtxape, kotxi ãtinani aĩri auari iaxiti auakari. ");
INSERT INTO apuNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Apaka apanakini akiritinii “aãuĩte,” !hãuiritapeko, kotxi ãtinani hĩauĩte. Teoso mereẽkiti itxaua. ");
INSERT INTO apuNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Auĩtetxi pininiua pinirekiniã, apanakini nitiri atoko pitxauako. ");
INSERT INTO apuNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Iua “Auĩtetxi nitxaua,” inakari, Teoso txĩkitakariko nitiritxi itxauako. Iua “Nitiritxi nitxaua,” inakari, Teoso txĩkitakariko auĩtetxi itxauako. ");
INSERT INTO apuNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Iuaĩkana Xesosi sãkirauata: —Erepaniko hĩte kaiõkatsoparerinii, pariseoakorii pakini. Hĩsãkire atxiĩti erekari, txamari kona hĩkamari hĩsãkire iaõka. Kinirão ĩroãkari apisapanika aapokotxi tore totakani atoko hĩtxa, kotxi hĩte iotokakari kãkiti Teoso sãkire atão auikini, ininiãkara hĩte iotokakari kãkiti ĩroini Teoso auĩtetxi ininiãtaãua. Hĩte kona ĩroã. Apaka kona hĩte auiritana kinirão ĩroãkani. ");
INSERT INTO apuNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Erepaniko hĩte kaiõkatsoparerinii, pariseoakorii pakini. Hĩsãkire atxiĩti erekari, txamari kona hĩkamari hĩsãkire iaõka. Hĩte mixirikari tikinitakoro aapoko. Himisirienetana. Teosokata hĩsãkirauatakasaaki, itori sãkiretxi hĩkama apanakini, “paimatirena” inini ĩkapaninokara. Ikara xika himisiritiko apiatako. ");
INSERT INTO apuNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Erepaniko hĩte kaiõkatsoparerinii, pariseoakorii pakini. Hĩsãkire atxiĩti erekari, txamari kona hĩkamari hĩsãkire iaõka. Hĩte sari õtakoxiti. Hĩpiriãtari kãuaãri. Imiriĩ õtakoxiti hĩsa, hĩsãkire auikakari hinitini ĩkapani. Ãtinoka hĩsãkire auikakari auiniã, iuaritika hĩsa iuaxiti. Eereka hõerekari iua ikinipoko himarotakiti. Eereka hĩte maerekani xika, iua kiki maerekani apiatako. Isapitika hĩtekata maerekani misiritikoãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Erepaniko hĩte. Mõsiãreni atoko hĩtxa, iuaritika hinirekari hõerekiniri Teoso kimapore apanakinimoni. !Hĩposotari. Hĩte oerekari apanakini ia hĩsãkire: “‘Ia nikamapitikako’ pinakasaaki, Teoso misãkiretiko aikoti pakiriuãkatakasaaki, pimakamakaniãri, kona pimisiritaãkako,” itxa hĩte sãkire. Iuaĩkana hĩte sãkire: “‘Nikamapitikariko,’ pinakasaaki, Teoso misãkiretiko aikoti ãki auakaro oro pakiriuãkatakasaaki, pikamapitikariko pikamaenetakiti. Ikara pimakamakanisaaki, pimisiritaãkako,” itxa hĩte sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","—Hĩte mõsiãreni atoko. Kona kiĩkitei hĩte. Ĩkiripa apiari? Orokani? Teoso misãkiretiko aikotikani? Teoso misãkiretiko aikoti apiari, kotxi oa oro aiko ãki aua, ininiã aiko txĩkitakaro oro Teoso nakito oniniãua. ");
INSERT INTO apuNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","—Hĩte oerekari apanakini ia hĩsãkire apaka: “‘Nikamapitikariko’ pinakasaaki, Teosomoni sikakori takikoãtaã pakiriuãkatakasaaki, pikamaenetakiti pimakamakaniã, kona pimisiritaãkako. ‘Nikamapitikako’, pinakasaaki, Teosomoni sikakori takikoãtaã nopini takakori pakiriuãkatakasaaki, pikamapitikariko pikamaenetakiti. Pimakamakanisaakiri, pimisiritaãkako,” itxa hĩte sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hĩte mõsiãreni atoko hĩtxa. !Kiĩkitei hĩte. Ĩkiripa apiata? Sikakorikani? Sikakori takikoãtaãkani? Sikakori takikoãtaã apiata, kotxi sikakori inopini takikosaaki, iuasaakipeka Teoso nakitipeka. Ininiã sikakori takikoãtaã txĩkitakari sikakori Teoso nakiti ininiãua. ");
INSERT INTO apuNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ininiã pisãpiretakasaakiri Teoso pikamaenetakiti, Teoso sikakori takikoãtaã pakiriuãkatiniã, iuatxikana iua nopini auakari pakiriuãkata. ");
INSERT INTO apuNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pakiriuãkatakasaakiri Teoso misãkiretiko aikoti, iua atokotxikana pakiriuãkatari Teoso, kotxi iua aiko ãki aua. ");
INSERT INTO apuNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pakiriuãkatakasaakiri Teoso tixine, ininiã iua atokotxikana pakiriuãkatari Teoso topãkini. Iua atokotxikana pakiriuãkatari Teoso, kotxi Teoso topãkini nopini iitopãka Teoso. ");
INSERT INTO apuNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Erepaniko hĩte kaiõkatsoparerinii, pariseoakorii pakini. Hĩsãkire atxiĩti erekari, txamari kona hĩkamari hĩsãkire iaõka. Ipixini hinakiti hĩsikari Teosomoni. Tesi hĩtii auiniãi, hĩsikari ãti Teosomoni. Tesi txineiro ota auiniãi, hĩsikari ãto Teosomoni, hĩtxaãpota. Ikara hĩkamakiti erekari. Nipokori koke, oteraã, erva tosi, komínio, axapitikiri inakari, iuaritika ipixini hĩsika Teosomoni. Ikara Teoso paniãtakiti hĩkamapitika. Txamari, Teoso paniãtakiti apiari !hĩkama, kotxi !hĩkamari atão apanakinimoni. !Hiamonĩkana apanakini. Hĩkamaenetakiti !hĩkama. Ikinika Teoso paniãtakiti hĩkamako. ");
INSERT INTO apuNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mõsiãreni atoko hĩtxaua, iuaritika hinirekari hõerekiniri Teoso kimapore apanakinimoni. !Hĩposotari. Himakatxakaro xikiri iãriã ãki komokakaro, txamari hĩixirapoataro kamero, kotxi Teoso paniãtakiti poiãori hĩkama, txamari ipaniãtakiti apiari kona hĩkama. ");
INSERT INTO apuNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Erepaniko hĩte kaiõkatsoparerinii, pariseoakorii pakini. Hĩsãkire atxiĩti erekari, txamari kona hĩkamari hĩsãkire iaõka. Hõeretari hiĩto maparakiri, txamari hãkixinireẽ !erekari. Papotxinanii, patirenanii, paĩtirii. ");
INSERT INTO apuNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hĩte pariseoakorii, mõsiãreni atoko hĩtxa. Merepitipanika himakatxakariko maerekati hãkixinire auakari, ininiã hiĩto erekatxikana. Hãkixinire ereka ininiã, hĩkamakiti ereka apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Erepaniko hĩte kaiõkatsoparerinii, pariseoakorii pakini. Hĩsãkire atxiĩti erekari, txamari kona hĩkamari hĩsãkire iaõka. Kai auĩte iriko, ipĩkari takikoãtaã atoko hĩtxa. Mapara txĩta kasarori minapaãkapeka, ininiã mapara peerekari. Txamari, iriko ãki ipinakari api, arakapoakatakari aua. ");
INSERT INTO apuNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Iua atokokanera hĩtxa. Kãkiti uãkatai hĩte atão inakarinoka kamakani hininiua, kotxi hinopini ererini hĩtxaua. Txamari, hãkixinire !ereri, kotxi maerekatinoka hĩkama. Hĩsãkire atxiĩti erekari, txamari kona hĩkamari hĩsãkire iaõka —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Iuaĩkana Xesosi sãkirauata: —Erepaniko hĩte kaiõkatsoparerinii, pariseoakorii pakini. Hĩsãkire atxiĩti erekari, txamari kona hĩkamari hĩsãkire iaõka. Hĩkamari akauari Teoso sãkire sãpiretakanini ĩkapani. Peereri akauari hĩkama. Hĩkamari akauari ipĩkani atão inakarinoka kamakani ĩkapani. Txĩta himinapa akauariã. Aãui hĩtaka iuaãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Hĩtxari: “Kitxakapirĩka aãtokiriakorini okana Teoso sãkire sãpiretakani. Atepitika auaãkamako iuasaaki, konimako ate okana ninoa,” hĩtxa. ");
INSERT INTO apuNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Teoso sãkire sãpiretakanini okakani mekaniriakori hĩtxaua hĩte. Kotxi hĩtekara txari: “Aãtokiriakorini okana Teoso sãkire sãpiretakani.” Hĩte maerekati kamakani ninoa atokokana hĩtxa. ");
INSERT INTO apuNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hãtokiriakorini mipotorikari Teoso sãkire sãpiretakani okinina. Hĩte xipokapanikanako ãtikaka kaikotakani Teoso sãkire sãpiretakani. ");
INSERT INTO apuNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—Imini atoko hĩtxa. Imini anaakori atoko hĩtxa hĩte. Himisiritaãkapitikako maerekani misiritikoãtaã. Himitekini !auari. ");
INSERT INTO apuNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ininiã nisãpiretai hĩte. Niokanatapanikari hĩtemoni Teoso sãkire sãpiretakani, Teoso iokanapirena imarotakani, koerekarerini pakini niokanata hĩtemoni. Txamari ãtikaka hõka, aamina ĩpiriãmitakari nopini hĩtokakitana apanakini. Apanakinipekana hĩxirokitata aiko Xoteo apotiitiniãtaãua. Eereka hãsikatikinitana ninoa ãti sitatxitimoni sikani, eereka ãti sitatxitimoni, eereka ãti sitatxitimoni hĩtxaãponãta ninoa hãsikatikinitini. ");
INSERT INTO apuNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ininiã hĩte misiritaãkako ikinika atão inakari kamakani okiko xika. Kitxakapirĩka Apeo inakorini okapeẽka. Atão inakari kamakari iua. Ikinimane okapekoni tikinimoni okapeẽka Sakariani, Parakia ãkiri. Iua Sakariani okapeẽka sikakori takikoãtaã takote Teoso misãkiretiko aikoti ãki. ");
INSERT INTO apuNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Atãopitikara nisãpiretai hĩte. Kãkiti uatxa auakani apakapariko misirikaretxi ninoa erekarini okapekoni xika —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Iuaĩkana Xesosi sãkirauata: —Xerosareẽ auakanii, Xerosareẽ auakanii, hĩte okapekana Teoso sãkire sãpiretakani. Kai soroã hĩkiporonakana ninoa hĩtemoni Teoso iokanatakini. Kaiãokatani ninirekamari ninĩkatinii, patari oimiakori omĩkita patapi otakini atokokana nitxanakamaiko hĩte. Txamari !hãuiritano nota nĩkatinii. ");
INSERT INTO apuNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ikara atoko inakari xika haãpoko asikaãkako. Teoso !auaika hĩtekata. ");
INSERT INTO apuNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nisãpiretai. Ia õti hãtamatano, eereka !hãtamataikano. “Teoso takari erekari uaimoni ĩkarimoni, Apiananiri posotiireẽ ĩkarimoni,” hinakasaaki, iuasaakinanirako hãtamatanoko nota —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Teoso misãkiretiko aikoti Xesosi potorikasaakipeka, imoianariakori apoka iuamoni. —Patamata. Peerepokori aikoniri —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ininiã Xesosi: —Ari, hãtamatatari ere aikoniri? Atãopitikara nisãpiretai hĩte. Koniko kai kaikotapani ãti kai nopini. Imakinika kai irikaãkako —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iposo atoko Xesosi sari oxiratarimoni, Oriva inakorimoni. Iuaã topãka itxa. Imoianariakori sari iuamoni. Ninoanoka auari iuaãtaã. —Pisãpiretaua kirisaakiparako aiko Teoso misãkiretiko irikataãkako. Natokopa ininiãparako ate imarotatari pite kaiama kanapirikape pinini? Natokopa ininiãparako aimarotatari itixi xipokini õti kaiamapeka inini õti? —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ininiã Xesosi: —Erepaniko. !Hãuiritapena apanakini misirienetinii. ");
INSERT INTO apuNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kotxi apokako kãkiti itomaneri “Teoso mereẽkiti nitxaua nota,” inakani. Ninoa misirienetana itomaneri. ");
INSERT INTO apuNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hĩkenakopiretariko neenamatxi ene uaimoni, õtakoxiti apaka. Iuaritika !hĩpĩkarauatape. Kotxi auapitikako neenamatxi. Txamari itixi xipokini õti !apokapanika. ");
INSERT INTO apuNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ikara inakari apisapanika, ãti uãka neenamauatako ãti uãkakata. Apanakini auĩte inirimanekata neenamauatako apanakini auĩtekata inirimane pakinikata. Ãtiãtaã kãkiti inikoriãriko natxi. Ãtiãtaã amianari inokanako kãkiti. Ãtiãtaã itixi iakeẽkatako. ");
INSERT INTO apuNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ikara atoko itxako misirikaretxi potorikini. Sito amarini tsii atoko itxako iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Iuasaaki hĩte maĩkaãkako, himisiritiko ĩkapani. Iposo atoko oka hinaãkako. Nisãkire hãuikini xika ikinimane omanataiko hĩte. ");
INSERT INTO apuNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Iuasaaki itomaneri !auikaikari Teoso sãkire. Itakanapapekarina Teoso kimapore. Imĩkapiritakakanako. Omanatakakanako. ");
INSERT INTO apuNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Apokako kãkiti “Nota Teoso sãkire sãpiretakari nitxaua,” inakari. Txamari kona atão. Ninoa misirienetanako itomaneri kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kãkiti tiretiko poiãotako, kotxi maerekanitxi iarikako ikini itixitimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Iuasaaki kãkiti mĩteenekiniãri misirikaretxi, imatakanapakaniãri Teoso sãkire, auapikako ãtipirika Teosokata. ");
INSERT INTO apuNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Teoso iokanapirena erekari, Teoso auĩtetxi ininiãua, sãpiretaãkako ikini itixiti auakani, ikini kãkititi imarotiniri ĩkapani. Ikara inakari auaãka atokoikarako itixi xipokini õti apokako. ");
INSERT INTO apuNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Xesosi sãpirenauatapanika: —Hĩte itikariko iteene maerekati kamakari timini aiko Teoso misãkiretiko ãki. Kitxakapirĩka Tanieo inakori, Teoso sãkire sãpiretakari, sãpiretapekari ikara ene. Hĩte ia atatsopatakani, himarotariko ikara. ");
INSERT INTO apuNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ikara atoko inakari hĩtikasaaki hĩte ĩkorapokoriti Xotéia auakani, oxiratarimoni himitekako. ");
INSERT INTO apuNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ikara õti apokasaaki haãpoko nopini hãuiniã, katima hĩtxako himitekini. !Apakata haãpoko ãki hĩtii himakatxakini. ");
INSERT INTO apuNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kikio hĩparĩkauanãtakasaaki, hãapokomoni !hĩkanapiripe himãka hãpini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ikara õti apokasaaki, kamixironi, kaxitakareroni pakini iteene atatsiitariko. Pasãpaniri ninoa mitekini. ");
INSERT INTO apuNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Hamanaãriko Teoso katxĩkareri mauakani himitekini õtisaaki. Hamanaãriko tomatiko õtisaaki ikara inakari mauakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kotxi ikara mitekatxi õtisaaki kãkiti iteene atatsiitariko imisiritiko. Ikara õti apisa kãkiti !imarotari iteene imisiritiko. Itixi kamikosaakipanika !auari ikara atoko inakari misirikaretxi. Ikara mitekatxi õti napaãka atoko kãkiti !imarotaikari iteene imisiritiko. Ikara õti apiatako kãkiti misiritiko. ");
INSERT INTO apuNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Teoso poiãotakari iua õti ikinipoko kãkiti mapinakani ĩkapani. Ito õti ininiã, kãkiti !auaika. Ipoiãotakari iua õti, kotxi itiretana kãkiti imereẽkini. ");
INSERT INTO apuNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Iuasaakiko ãti: “Ia kiki Teoso mereẽkiti aiãtapakiti inakari,” inakasaakii, !hãuikapiri. Ãtipekana: “Ikira Teoso mereẽkiti inakari,” inakasaakii, !hãuikapiri. ");
INSERT INTO apuNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kotxi apokako kãkiti paxirari kamakari, “Teoso mereẽkiti hiãtapakitino nota,” inakari, “Teoso sãkire sãpiretakari nitxaua nota,” inakari. Ninoa kamariko posotiiretxi kãkiti tsorikitaãtini ĩkapani. Inirekarina kãkiti Teoso mereẽkini imisirienetinina. ");
INSERT INTO apuNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hĩkenakota. Nõtãkikai hĩte ikara inakari apokini õti apisa. ");
INSERT INTO apuNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Hĩte sãpiretikosaaki: “Hĩkenakota. Teoso mereẽkiti aiãtapakiti ãparaã makipakaniãtaãpekarari,” hinikosaaki, !hĩsipe iuaã. Hĩsãpiretikosaaki: “Iriko ãkirari iua,” hinikosaaki, kona hãuikapiri. ");
INSERT INTO apuNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kotxi nota hĩtari iaxitikiri nikanapiriãkasaaki, !ikara atokoni nitxa. Mẽkokari atoko itxa nota hĩtari iaxitikiri nikanapiriãkasaaki, kotxi mẽkokari atokatxi pokĩkinimoni imẽkoka, isapitipo atokatxi ereẽkokinimoni, ininiã ikinimane itikariko. Iua atokokana nota hĩtari iaxitikiri napokini. Ikinimane itikanoko nota. ");
INSERT INTO apuNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Aãtamatakasaakiri maiori apotiitiniua, aimarotari ipĩkari iuaãtaã auini. Iua atokokana nota kanapiriãkasaaki, ikinimane imarotari napokini. ");
INSERT INTO apuNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Xesosi sãpirenauatapanika: —Apikomoni nisãpiretai nikanapiriini pirena. Iua inikoriãkori napaka atoko, atokatxi piãkako. Kasiri kona ponikaikako. Iõriki iaxitikero irikako. Iaxiti iõriki auiniãtaã auakari iakeẽkatako. ");
INSERT INTO apuNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Iuasaaki Teoso takaõtxikare auako iaxiti, nota hĩtari iaxitikiri kaiamapeka uai nikanapiriini himarotini ĩkapani. Ikara atoko inakasaaki, ikini kãkititi itixi auakani txiapatako, kotxi ninoa atapanoko nota kãkiti itari iaxitikiri katxiãri ãki nikatxakaãpotini. Nitapararitika napoãkatako, kotxi ikinimane auĩte nitxauako iuasaaki. Niotximerekata nikatxakaãpota. ");
INSERT INTO apuNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Okenakotaãkako koitxi mitaro, trõpeta inakoro. Iuasaakipekako niokanatana ninitiriakori itixi iaõka kãkiti Teoso mereẽkini apotiitakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Xesosi sãpirenauatapanika: —Nisãpiretai sãpirenatxi atão inakari oerekiko, piko mina pirena, nikanapiriini apiata himarotini ĩkapani. Pooĩoporipeka onakasaaki, otomorekasaaki, “Kamoĩ apokanapanoka,” hĩtxa. ");
INSERT INTO apuNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iua atokokana, ikara misirikaretxi mixikanani nisãpiretakiti hĩtikasaaki, himarotapekariko nota kaiama kanapirikapeka ninini. ");
INSERT INTO apuNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ia nisãkire atão. Itixi auakani !ixipoka ikinipoko nisãpiretakiti mapokakani apisa. ");
INSERT INTO apuNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Iaxiti xipokapitikako. Ĩkoraxiti apaka xipokapitikako. Iuaritika nota sãkire !ixipoka. ");
INSERT INTO apuNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Xesosi sãpirenauatapanika: —Kãkiti !imarotari ikara õti, nota hĩtari iaxitikiri nikanapiriini õti. Teoso nitiriakori iaxitikini apaka !imarotari ikara õti. Nirinanira imarotari. ");
INSERT INTO apuNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nota hĩtari iaxitikiri nikanapiriãkasaaki, kitxakapirĩka Noee auakasaaki atoko itxako. ");
INSERT INTO apuNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Xirataãtxi apisa ikinimane nipokota, iãta itxa. Kiki, sito ĩtaniriuata. Ikara atokokanera itxa Noee maporo ãki iereẽtini õti. ");
INSERT INTO apuNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ikara apisa !imarotarina ipininina tĩkane. Mokatanitika xirataãtxi apoka, ikinikana xipoka itxana. Nota hĩtari iaxitikiri nikanapiriãkasaaki, iua atokokanerako itxa, ininiã iposope hĩtxako. ");
INSERT INTO apuNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","—Iuasaaki nikanapiriini õtisaaki, ipi kiki parĩkauanãta kikio. Teoso nitiri iaxitikiri anikariko ãti, ãti kaikota itxako. ");
INSERT INTO apuNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ipi sito atarokiri kamakani, ãto anikaãkako, ãto takanapaãkako. ");
INSERT INTO apuNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ininiã iposope hĩtxako, kotxi kona himarotari hĩauĩte kanapiriini õti. ");
INSERT INTO apuNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hĩxinikariko. Kaapokori imarotaãkamariko kiĩtiriri apokini õti, !imakamako. !Auiritamariko kiĩtiriri anikiniri itii. ");
INSERT INTO apuNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kiĩtiriri apoka kãkiti miãtapakinitipanika. Iua atokokanerako nota apokako himimarotakinitipanikarako. Ininiã iposope hĩtxako nota hĩtari iaxitikiri hiãtapini —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—Ininiã Teoso nitiriakori erekarini hĩtxauako. Nisãpiretai nitiritxi kimaroreri inakari, kotxi iua kĩpitari ipatrãote sãkire. Iuakara ipatrãote paniãta, apanakini initiriakori inĩkatini ĩkapani. Isikakienatana ipatrãote nitiriakori, nipokori sikiko manapi. ");
INSERT INTO apuNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Iua initiri poxokoniuata ipatrãote paniãtakiti iaõka ikaminiã, ipatrãote apokasaaki iposope itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Atãopitikara nitxai hĩte. Iua patrão paniãtariko iua initiri ikinika inakiti inĩkatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nitiritxi maerekatipekana xinikari: “!Katimari ikanapiriã nipatrãote,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ininiã apanakini nitiritxi ixiroka. Inipokota, iãta poãtakanikata. ");
INSERT INTO apuNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ininiã ipatrãote kanapiriãko imiãtapakinitipanika. Ikanapiriãko initiri mimarotakinitipanika. ");
INSERT INTO apuNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ininiã ipatrãote xirokitatariko aãpitsaã. Iposo atoko imisiritaãkako maerekanikata, “Erekapitikaua ate,” inakanikata. Iuaã kãkiti txiapata, akatsatsiriĩtaua ãtipirika. Ininiã ikara nitiritxi maerekati atoko kona hĩtxape —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Xesosi sãpirenauatapanika: —Ia nisãpirena oerekai Teoso auĩtetxi ininiãua. Tesi ãtokoroakoro kosekari tirikapi. Isana kimaporiã. Iãtaparina ipatrãotena. Iua inapanikako kiinirimoni ĩtanorouatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sĩko ãtokoro kiĩkiterini, sĩko miĩkiteni. ");
INSERT INTO apuNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Miĩkiteni anikari tirikapi koana, txamari !anikarina tirikapiã. ");
INSERT INTO apuNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kiĩkiterini anikari tirikapi koana. Apaka anikarina tirikapiã. ");
INSERT INTO apuNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ipatrãotena !katimari apokini. Ininiã itaponoka ininiãna, imakanãtana. ");
INSERT INTO apuNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","—Apanĩkanõka ikenakotarina: “Apokanapanoka. Hĩsapoka. Hãpiãkatari.” ");
INSERT INTO apuNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","—Ininiã ãtokoroakoro õkitikaua, tirikapi iopotokaka, sa itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ninoa miĩkiteni amanaãri kiĩkiterini tirikapiãte, kotxi miĩkiteni tirikapite oakaarita. ");
INSERT INTO apuNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","—Kiĩkiterini apakapapiretana: “Kona. Tirikapiã ate nakiti !apakata hĩte ĩkapani. Ate ĩkapaninokara apakata. Hĩsa tirikapiã vẽtxitakarimoni. Hiamotariko.” ");
INSERT INTO apuNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","—Ininiã ninoa miĩkiteni sari tirikapiã iamotinina. Ninoa sikasaaki, ipatrãotena apoka. Ãtokoroakoro iposope inakani ĩroã iuakata aapokotxi ãki ĩtanorouatakari kiiniritiã. Itore totaãka. ");
INSERT INTO apuNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","—Eereka ãtokoroakoro tirikapiã amotakani kanapiriã. Ninoa akirita: “Patrão, patrão, pimatakakinaua itore aĩroini ĩkapani,” itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","—Ipatrãotena apakapapireta: “Hĩsipeka. Atão nisãpiretai. !Nimarotai hĩte.” ");
INSERT INTO apuNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Xesosi sãkirauata: —Erepaniko. Iposope hĩtxako, kotxi !himarotari nota hĩtari iaxitikiri kanapiriini õti. !Himarotari amonikitauako napokini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Xesosi sãpirenauatapanika: —Nikanapiriini ia atoko itxapaniko. Kiki aiamatapeka õtakoxiti ãti itixitimoni isini ĩkapani. Ininiã akiritari initiriakori. “Hinĩkatariko ikini nitii,” itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Isikari initiri apia imaroretakari txineiro ota sĩko mio. Ãti initiri isika txineiro ota ipi mio. Ãti initiri poiãoka imarotakari ãtika mio txineiro ota isikari iua. Eereka sipe itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","—Sĩko mio apakapakari amotari tiitxi, eereka vẽtxita itxari. Ikara atoko ininiã apakaparo txineiro ota tesi mio. ");
INSERT INTO apuNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Iua ipi ãti mio apakapakari iua atokokana itxa. Iua apakaparo ipi ipi pakini mio txineiro ota. ");
INSERT INTO apuNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Iua ãtika mio txineiro ota apakapakari, ikisakari kipatxi, taka itxaro txineiro iua aariko ãki. Ikataro ipatrãote txineirote. ");
INSERT INTO apuNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Eereka okananixiti inaka atoko ipatrãotena kanapiriã. Akiritana: “Kiãtokopa hĩtxataro nitxineirote?” itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Iua sĩko mio apakapakari minari tesi mio. Iua sãpiretari ipatrãote: “Patrão, pite sikano sĩko mio txineiro ota. Patamata. Napakapari apikomoni sĩko mio txineiro ota pite ĩkapani,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—Ipatrãote apakapapiretari: “Erekapitikai pite. Erekari nitiritxi pitxaua. Erekari pinĩkatiniro nitxineirote. Erekapitikari pinĩkatiniri poiãoka nisikinii. Ininiã nauiritaiko itomaneri pinĩkatini. Ininiã pipoxokoniuatako notakata,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Iua ipi mio ota apakapakari apoka. Iminaro ipi ipi pakini mio. Isãpiretari ipatrãote: “Patrão, pite sikano ipi mio txineiro ota. Patamata. Apikomoni nota apakaparo ipi mio txineiro ota pite ĩkapani,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—“Erekapitikai pite. Erekari nitiritxi pitxaua. Erekapitikari nitxineirote pinĩkatini. Erekari poiãoka pinĩkatini. Ininiã itomane nitakanapako pinĩkatini ĩkapani. Ininiã pipoxokoniuatako notakata,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—Eereka iua ãtika mio txineiro ota apakapakari apoka. Iua sãpiretari ipatrãote: “Patrão, nimarotai pite. Pataparaxinirei pite. Pite amotari pikiena, kotxi kona pite takarauata. Pite apari pikiena pimaparĩkauatakaniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nipĩkarauatiniã, nikipataro pitxineirote kipatxi ãki. Patamata. Oia pitxineirote,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","—“Nitiritxi maerekati iareri pitxaua pite. Pimarotari niamotiniri nikiena, kotxi !nitakarauata. Pimarotari nota apari nikiena nimaparĩkauatakaniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ikara atoko ininiã, pimanirekakaniãri piparĩkauatini, kinirepa kona pisikatari nitxineirote pãkomoni? Pisikaãkamaroko, napakapamaroko apikomoni nitxineirote nikanapiriãkasaaki,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ininiã ãti ipaniãta: —“Pimakatxakariko iua mio ãtika mio auakiti. Tesi mio txineiro ota auakitimoni pisika. ");
INSERT INTO apuNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kotxi apikomoni isiãkako iua itomaneri auakiti, ininiã apiata auinariko iua. Iua poiãoka auakiti, inakito mixirikaãkako. ");
INSERT INTO apuNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ia ninitiri iareri hõka mapara piãkatximoni. Iuaã kãkiti txiapata. Akerakitatsiriĩta itsii xika.” ");
INSERT INTO apuNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Apikomoni Xesosi sãpirenauata: —Nota hĩtari iaxitikiri nikanapiriãkasaaki auĩtetxi ninakasaakiua, ikinika Teoso nitiriakorikata, niitopãkako auĩtetxi itopanere nopini. Peerekari iuasaaki. Ikinimane paxitanoko nota. ");
INSERT INTO apuNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ikini uãkati kãkiti apotiitaãkako nota apisatoõ. Iuasaaki nikaiarikitatanako ninoa. Soti auĩte, kapra pakini piratakari ipiraakori koketakaniua ikaiarikitatini atokokanera, nota hĩtari iaxitikiri kaiarikitatana ikinimane kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pirãtxi piratakari takiniri soti auĩte ikikomoni, itakiniri kapra isanaremoni, iua atokokanera nota hĩtari iaxitikiri takari kãkiti erekarini nikikomoni. Kãkiti maerekani nitaka nisanaremoni. ");
INSERT INTO apuNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","—Eereka nota kãkiti auĩte txanako ninoa kãkiti erekarini nikikomoni auakani: “Niri sikari erekari hĩtemoni. Hina. Hiĩroã auĩtetxi nininiãtaãua. Ia auĩtetxi nininiãtaãua maiamatapeẽkaika hĩte ĩkapani itixi kamikosaakipeka. ");
INSERT INTO apuNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mitxipeka ninatxitakasaaki, hĩte sikakienatapekano nota. Niposonatakasaaki, ãparaã hĩsikapekano. Ãti itixiti nĩkasaaki, hĩte apakapapekano nota. ");
INSERT INTO apuNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nimamãkanisaaki, mãkatxi hĩsikapekano. Namianatakasaaki, hinĩkatapekano. Kateia ãki nauakasaaki, himotikaẽtapekano. Ininiã hiĩroã,” nota kãkiti auĩte txanako kãkiti erekarini. ");
INSERT INTO apuNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Ininiã kãkiti atão inakari kamakani apakapapiretariko: “Apiananiri, kirisaakipa pinatxitakasaaki, asikakienatai? Kirisaakipa piposonatakasaaki, ãparaã asikai? ");
INSERT INTO apuNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kirisaakipa ãti itixiti pĩkasaaki, aãpakapai? Kirisaakipa pimamãkanisaaki, mãkatxi asikai? ");
INSERT INTO apuNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kirisaakipa pamianatakasaaki, anĩkatai? Kirisaakipa kateia ãki pauakasaaki, amotikaẽtai?” itxanonako nota. ");
INSERT INTO apuNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—Ininiã nota kãkiti auĩte apakapapiretanako: “Atãopitikara nitxai hĩte. Kãkiti poiãori, nisãkire auiãkari, hĩtiretiniã, iuasaaki nota hĩtiretini atokokana hĩtiretari,” nitxanako ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Iuasaaki nitxanako nisanaremoni auakani: “Hĩsipeka. Teoso misiritaiko hĩte, kotxi !hĩkĩpitari iua sãkire. Hĩsipeka arikatxi maxipokatimoni. Teoso kamari iua arikatxi, Satanasi misiritikoãtaã tĩkane, Satanasi nitiriakori misiritikoãtaã tĩkane. Hĩsipeka iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kotxi ninatxitakasaaki nipokori !hĩsikano. Niposonatakasaaki, ãparaã !hĩsikano. ");
INSERT INTO apuNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ãti itixiti nĩkasaaki, !hinirekano haãpoko napokini. Nimamãkanisaaki, kona mãkatxi !hĩsikano. Namianatakasaaki, !hinĩkatano. Kateia ãki nauakasaaki, !himotikaẽtano,” itxanako kãkiti maerekani. ");
INSERT INTO apuNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—Ininiã ninoa apakapapiretariko: “Apiananiri, pinatxitakasaaki, piposonatakasaaki, pamianatakasaaki, pimamãkanisaaki, kateia ãki pauakasaaki, ãti itixiti pĩkasaaki, kirisaakipa ate !apakapai?” maerekani txanoko nota. ");
INSERT INTO apuNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","—Ininiã nota kãkiti auĩte apakapapiretanako ninoa: “Atãopitikara nitxai hĩte. Himanirekakanisaakiri hĩtiretiniri kãkiti poiãori nisãkire auiãkari, iuasaaki !hinirekari nota hĩtiretini,” nitxanako ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—Ininiã Teoso iokanatanako ninoa maerekani kamakani misiritikoãtaã. Iuaãtaã ninoa misiritaãkapikako. Imisiritikona kona xipokaikako. Kãkiti atão inakarinoka kamakani auapininiika imaxipopekaniika Teosokata —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ikara inakari isãpiretaka atoko, Xesosi misãkiretana imoianariakori: ");
INSERT INTO apuNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Hĩte imarotari ipi õti napaka atoko aua Páskoa inakori kiiniriti. Iua kiiniriti auakasaaki nota hĩtari iaxitikiri nisikaãkako nimokaiakariakorimoni. Aamina ĩpiriãmitakari nopini nitakaãkako. Iua atoko ipina nitxako —Xesosi txana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Iuasaaki sasetotxi auĩteakori, kaiõkatsopareriakori, kiomãtxiakori pakini apotiitaua. Sasetotxi auĩte apiatakari Kaipasi inakori aapoko ãki apotiitauana. ");
INSERT INTO apuNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Imapapiretarina Xesosi imaĩkinina ĩkapani. Inirekarina Xesosi imaĩkinina apanakini mimarotakinitika. Imisãkiretakakana Xesosi okinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—Kiinirisaaki !amaĩkapaniri. Amaĩkiniãri, apanakini kãkiti naiatamaua ate —itxakakana. ");
INSERT INTO apuNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Xesosi auanãta aapokotxi Petánia inakoriãtaã. Isari Simão inakori aapokomoni. Iua Simão mitxi amianatakari, maere matati. Eereka erekapekari. ");
INSERT INTO apuNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Simão aapoko Xesosi auakasaaki, sito apoka iuamoni. Ominari kopitipaki kai kamakori, kai arapástiro inakori. Kopitipaki xãpoka kamariãro. Oa pakaronero. Xesosi nipokonãtakasaaki, oa sito kitakaro kamariãro ikiiã. ");
INSERT INTO apuNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Imoianariakori itikari Xesosi kiiã okitakiniro, ininiã ninoa naiataua: —Kinirepa oa ioanatataro kamariãro? ");
INSERT INTO apuNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kinirepa kona ovẽtxitataro? Ovẽtxitaãkamaroko oãpakapamaroko txineiro ito, matxineirotenimonikari osikini ĩkapani —itxakakana. ");
INSERT INTO apuNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Xesosi imarotari ninoa ikara atoko ininina. —Kinirepa homanatataro oia sito? Erekari okaminano notamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Auapikanako matxineiroteni hĩtekata. Kona nota auapani hĩtekata. ");
INSERT INTO apuNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Oia kitakaro kamariãro nikiiã, nota iposope ninini nikatiko apisa. ");
INSERT INTO apuNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Atão nisãpiretai hĩte. Teoso iokanapirena erekari sãpiretikoãtaã ikini itixiti, isãpiretaãkako apaka oia sito kitakiniro kamariãro nikiiã, ininiã kãkiti ikini itixiti auakani xinikapikaro oa —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Eereka Xesosi moianari Xotasi Isikariotxi inakori sari sasetotxi auĩteakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Xesosi nisikiniãi hĩtemoni, kiripa hĩte sikano nota? —itxana ninoa. Ininiã ninoa: —Asikaiko trĩta txineiro ota pirata kamakoro —itxana ninoa. Ininiã iĩkitxitarina. ");
INSERT INTO apuNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Eereka Xotasi iãtapari Xesosi poiãonoka kãkitikata auakasaaki, imĩkapiritiniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pão miãtiãkati nikiko kiiniriti potorikini õti, Xesosi moianariakori apoka iuamoni. —Namonipa ate maiamatari Páskoa kiiniriti pite ĩkapani? —itxarina iua. ");
INSERT INTO apuNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Hĩsa sitatximoni. Nisãpiretakiti iaõka hinitari kiki. Hãpokasaakiri, hĩtxariko iua: “Koerekareri txai, ipinini tĩkane kaiamapeka. Ikamariko kiiniri Páskoa inakori pite aapoko imoianariakorikata,” hĩtxako. ");
INSERT INTO apuNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ininiã imoianariakori kamari Xesosi paniãtakiti iaõka. Imaiamatari ikinika kiiniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ĩkanõkapeka inakasaaki, Xesosi imoianariakorikata topãka inipokotinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Inipokotakasaakina, Xesosi txana: —Atão nisãpiretai hĩte. Ãtika hĩte sauaki mĩkapiritanoko nota. ");
INSERT INTO apuNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ininiã imoianariakori tsorĩkaãta. Iteene imatinaniuatana. Ãti pimaãri: —Apiananiri, atauako notakani? Iua atokokana ãtipekana: —Apiananiri, atauako notakani? Ikara atoko itxanãtana ikinikana, ipimaaãpotinirina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ininiã Xesosi apakapapiretana: —Ia tiitxiã notakata nikakari mĩkapiritanoko. ");
INSERT INTO apuNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nota hĩtari iaxitikiri okaãkako. Teoso sãkire iõkatsopatakori sãpiretapekari nipinini tĩkane. Nota hĩtari iaxitikiri mĩkapiritakari iteene misiritaãkako. Erekamariko maponaniãkatika inaãkamako. ");
INSERT INTO apuNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ininiã Xotasi kamĩkapirireri misãkiretari Xesosi: —Koerekareri, atauako notakani? Xesosi apakapapiretari: —Ari, pitepitikara. ");
INSERT INTO apuNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Inipokonãtakasaakina, Xesosi kosekari komiri. Imisãkiretari Teoso: —Erekapitikari ia komiri pisikakiti atemoni —itxa. Eereka imaxinĩkitari, sika itxari imoianariakorimoni. —Apakapa, nika hĩtxako. Ia niĩto —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Eereka ikosekari iãkoanatxi iãriã auini. Imisãkiretari Teoso: —Erekapitikari ia iãriã pisikakiti atemoni —itxa. Eereka sika itxari iãkoanatxi ninoamoni: —Hĩkinika hiãtariko. ");
INSERT INTO apuNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ia niarẽka xiketakari makatxakariko kaiãopokori kãkiti maerekani. Teoso sãpiretapekari kãkiti ikamaenetakiti amaneri kãkiti ĩkapani. Ia niarẽka oerekari kãkiti, Teoso kamapekari ikamaenetakiti. ");
INSERT INTO apuNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Atão nisãpiretai. !Niãtaikaroko ovapeẽ, Teoso auĩtetxi ininiãtaãua nimapokakanisaaki. Iuaã napokasaaki niãtari. Amaneri iãriãti niãtako hĩtekata —itxana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Xipoka atoko ixikaretarina xikari Teoso ĩkapani. Eereka isana oxiratarimoni Oriva inakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iuaã Xesosi misãkiretana imoianariakori: —Ia ĩkanõkati hĩkinika hĩte takanapanoko nota, kotxi Teoso sãkire iõkatsopatakori sãpiretapekari ikara atoko inakari. Itxari: Nokariko soti auĩte piratakari, ininiã ikinika ipiraakori iarikitatako, itxa Teoso sãkire iõkatsopatakori. ");
INSERT INTO apuNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ininiã eereka nota nipinaãka atoko, iuaĩkana nõkitikaãkaua atoko, nisako hĩte apisa Kariréiamoni —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ininiã Petro apakapapiretari: —Nota !nitakanapai pite. Atxiĩti ikinimane takanapai, iuaritika kona nota takanapai —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ininiã Xesosi: —Atão nisãpiretai. Ia ĩkanõkati patari sãkirauatini apisapanikako, “!Nimarotari iua,” pitxanoko ipi ãti pakinikata. ");
INSERT INTO apuNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ininiã Petro: —Ikara atoko !nitxapanii pite. Nikipatinii apisapanikamako, nipinamako. Ikinika Xesosi moianariakori ikara atoko itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Eereka Xesosi sari imoianariakorikata Xetsémani inakoriãtaã. Xesosi: —Uai hĩitopãka. Ikiraã nisako Teoso nimisãkiretini ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Anikari Petro, Sepeteo anaakori ipi pakini iuakata isinina. Iuaã Xesosi tsorĩkaãnãta, imaromaxiretari. ");
INSERT INTO apuNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Imisãkiretana ninoa: —Nixinire imaromaxiretari. Iteene nimaxire, ininiã okaaritano. Uai hĩkaikota. Araõkire hĩtxako —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Apikomoni isa, pamaka itxa, misãkireta itxari Teoso: —Niri, atauako apakata pimakatxakiniri nimisiritiko akamoni ĩkari? Kona ninirekari natatsiirauatini. Iuaritika pite nirekiniãri, ininiã nota apaka nirekari —itxari Teoso. ");
INSERT INTO apuNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Iuasaaki ikanapiriã ipi ãti imoianariakori auiniãtaã. Ninoa imakanãta: —Petro, atauako kona hĩte mĩteenekari hĩtikapokotini ãto oaranoka? ");
INSERT INTO apuNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Erepaniko. Hinirekasaakiri maerekati hĩkamini, !hĩkamapiri. Araõkire hĩtxako. Himisãkiretariko Teoso, ininiã !hĩkamari maerekati. Kãkiti xinire atxiĩti !inirekari maerekati ikamini. Txamari kãkiti ĩto tapara poiãoka, ininiã ikamari maerekati. Ininiã erepaniko —Xesosi txari Petro. ");
INSERT INTO apuNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iuaĩkana isa apikomoni Teoso imisãkiretini ĩkapani: —Niri, pinirekiniãri natatsiitiniri nimisiritiko akamoni ĩkari, ininiã nikamapitikariko pinirekakiti —itxari Teoso. ");
INSERT INTO apuNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iuaĩkana ikanapiriã imoianariakorimoni. Imakanãtapanikana. Itaponoka itxana. Kona iposotarina ikoatinina. ");
INSERT INTO apuNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Iuaĩkana Xesosi takanapana, iuaĩkana ikanapiriã iuaãtaãkana. Iuaĩkana misãkireta itxari Teoso. Mitxi atokokana itxa isãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Iuaĩkana ikanapiriã imoianariakorimoni: —Himakanãtapanika? Hĩtomanãtapanika? Nisikiko manapi apopeka. Nota hĩtari iaxitikiri nimĩkapiritaãka maerekanimoni nisikiko, inireẽkitina ikaminina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hõkitikaua. Masipeka. Hãtapa. Ikiraã ina nota mĩkapiritakari —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Xesosi sãkirauanãtapanika inakasaaki, Xotasi, Xesosi mitxi moianari, apoka. Iuakata ina itomaneri kãkiti, saasara mĩkani, piriri mĩkani pakini. Sasetotxi auĩteakori, kiomãtxiakori pakini iokanatana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Iua Xotasi kamĩkapirireri sãpiretapekana ninoa: —Iuapitipanikarako napitxokapaniko. Himaĩkariko iua napitxokakiti. ");
INSERT INTO apuNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Xotasi apoka. Xesosimonipitipo isa. —Ereẽkai koerekareri. Eereka apitxoka itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ininiã Xesosi txari Xotasi: —Nitiretakiti, pikamariko pinirekakiti. Nauiritai —itxari. Iuasaakipeka Xotasikata sikani sakata Xesosimoni, maĩka itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ãti Xesosi moianari kosekaro saasara. Isauaãkatari sasetotxi auĩte apiatakari nitiri. Itsotakakĩpitatari. ");
INSERT INTO apuNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ininiã Xesosi txari: —Pitaka saasara mitxi oãuiniãtaã. !Pineenamauatape. Ikeekotxi himaĩkiniã, ãti õti hĩpinako ikeekotxi xika. ");
INSERT INTO apuNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","!Pimarotari niposotiire. Nota nirekiniãri, nakiritari niri moianatinino nota. Nakiritiniãri, iuasaakipeka iua iokanatamariko seĩ mio initiriakori nota imakatxakinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kona nakiritari niri, kotxi Teoso sãkire iõkatsopatakori sãpiretapekari nimaĩkiko tĩkane ia atoko inakari. ");
INSERT INTO apuNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iuasaaki Xesosi misãkiretana iuamoni ĩkani: —Kinirepa himinari saasara, piriri pakini himaĩkinino ĩkapani? !Kiĩtirino nota. !Kikeekono nota. Ikiniõtika niitopãka Teoso misãkiretiko aikoti ãki noerekinii hĩte. Iuasaaki kona himaĩkano. ");
INSERT INTO apuNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ia atoko himaĩkano, kotxi kitxakapirĩka Teoso sãkire sãpiretakani iõkatsopatapekari ia atoko himaĩkinino. Ininiã Teoso sãkire iõkatsopatakori iaõka uatxa apokapeka —itxa Xesosi. Iuasaakipeka Xesosi moianariakori asikari iua, miteka itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ninoa Xesosi maĩkakani anikari Xesosi Kaipasi aapokomoni. Iua Kaipasi sasetotxi auĩte apiatakari itxaua. Iuaãtaã kaiõkatsopareriakori, kiomãtxiakori pakini apotiitapekaua iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ninoa anikasaakiri Xesosi, Petro sari Xesosi tikini. Ikira atoko auaãponãta. Sasetotxi auĩte apiatakari aapoko takote isa. Iĩroã pirikere ãki. Iitopãka Kaipasi nitiriakorikata. Kiatokopa inaãkapani Xesosi, ininiãra isa Xesosi tikini imarotiniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kaipasi aapoko ãki Sasetotxi auĩteakori, kiomãtxiakori, ikinika Xoteo auĩteakori pakini nitana kãkiti aãpirena kamakani Xesosi okinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Itori kãkiti sãpiretari aãpirena Xesosi ikamapiretinina. Txamari ixika !auari Xesosi okinina ĩkapani. Eereka apokana ipi aãpirena kamakani. ");
INSERT INTO apuNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ninoa txari: —Ia kiki txari: “Nota posotari aiko Teoso misãkiretiko nirikini. Ipi ãti õtisaaki niposotari iuaĩkana nõkitikiniri,” itxa isãkire. Kona atão ninoa sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sasetotxi auĩte apiatakari õkitikaua. —Kona papakapapiretatari pitemoni apoĩrauatakani? Atãokani piposotatari ikara atoko pikamini? —itxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Xesosi !kasãkireri. Ininiã sasetotxi auĩte apiatakari iuaĩkana misãkiretari Xesosi: —Uatxa nipimaãi Teoso mipĩkati apisatoõ. Atãonani pisãpiretaua. Pite, Teoso mereẽkiti pitxataua? Teoso ãkirikai pite? —itxari Xesosi, kotxi inirekari Xesosi kerokiniri isãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—Ari, iuapitikarano. Nisãpiretaiko hĩte hĩkinika. Hãtamatariko kãkiti itari iaxitikiri topãkini Kaposotiireri kikomoni. Hãtapariko kãkiti itari iaxitikiri uai apokaãpotini katxiãri ãki —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sasetotxi auĩte apiatakari kenakotari ikara Xesosi sãkire. Iuasaakipeka iua matsorãkari imãka, kotxi kona xatiki ipotxitari Xesosi sãkire. —Maerekati isãkire: “Teoso ãkirirano,” itxa. !Anirekaikari apanakini kamapiretiniri Xesosi. Uatxaika hĩkenakotapekari isãkire maerekati. ");
INSERT INTO apuNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kiãtokopa atxatari Xesosi? —itxana ninoa. —Ixika auapeka ipinini ĩkapani ininiã uatxa okaãkapitikako —ninoa txari iua. ");
INSERT INTO apuNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Eereka ikiisokatoõtarina. Iãsokarina. Apanakini aritoõtari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Pite Teoso mereẽkiti pininiãua, pisãpiretaua, kipa aritai? —itxarina iua. Inapetarina. ");
INSERT INTO apuNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Iuasaaki Petro topãkanãta mapara pirikeri ãki. Ãtokoro Kaipasi nitero sari iuamoni. —Pite Xesosi Kariréiakiri moianaripitikarai —otxari iua. ");
INSERT INTO apuNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Txamari iua kipatari ikinimane apisatoõ. —!Nimarotari ikara atoko pinanãtakiti. ");
INSERT INTO apuNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ininiã isa pirikeri ĩroãnakikomoni. Iuaã ãto ãtokoropekana Kaipasi nitero atamatari iua. Ininiã osãpiretana kãkiti iuaã auakani: —Xesosi Nasareekiri moianaripitikara ikira —otxa. ");
INSERT INTO apuNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Iuaĩkana ikipatari: —Teoso imarotari iua kiki nimimarotakani —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Eereka paĩtiki atoko kikiãkini iuaã auakani sari Petromoni: —Pite atãopitika iua moianaripitikarai, kotxi pisãkire ipinimoni. Kãkiti Kariréiakiri sãkire atokokana, Xesosi sãkire atokokana pitxa pite sãkire —ninoa txari Petro. ");
INSERT INTO apuNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ininiã Petro apakapapiretana: —Atão nisãkire minakaniãua Teoso misiritanoko. Nisãkire atãopitika. !Nimarotari iua kiki —itxama. Iuasaakipeka patari sãkirauata. ");
INSERT INTO apuNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ikara ikenakotakasaaki, Petro xinikari Xesosi sãkire, kotxi mitxipe Xesosi txari iua: “Patari sãkirauatini apisapanikako, ipi ãti pakinikata, ‘!Nimarotari iua,’ pitxanoko.” Ininiã Petro sipeka. Itxiapakata. ");
INSERT INTO apuNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Katimatinĩkata sasetotxi auĩteakori, kiomãtxiakori pakini apotiitaua. Imisãkiretakakana: —Kiãtokopa atxatari Xesosi aõkini? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Eereka iaxirikãkitakarina Xesosi, anika itxarina Homano auĩte Põsio Pirato inakorimoni, sikanapa itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Xotasi, Xesosi mĩkapiritakari, kenakoenetakasaakiri Xesosi ipinini tĩkane, maerekaxiniretinoka itxa, kotxi iuaka sikari Xesosi imokaiakariakorimoni okiko tĩkane. Iuaĩkana isipikaro trĩta txineiro ota pirata kamakoro sasetotxi auĩteakori, kiomãtxiakori pakinimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Nota kamari maerekati. Nimĩkapiritari Xesosi. Ixika !auari iua ipinini ĩkapani —itxana ninoa. Ininiã ninoa: —Pite kamakiti xikakara. Pitekara sikaua ate Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ininiã Xotasi okaro txineiro ota Teoso misãkiretiko aikoti ãki, eereka isipe ãtiãtaã. Iuaãtaã iuaka iaxirikanokitapeua, aamina poriã iaxirikaua, arõka, ipĩpe itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Teoso misãkiretiko aikoti ãki sasetotxi auĩteakori kosekaro oa txineiro. —Oia txineiro kiki okiko ĩki. Ia xika ate !auiritaãka aãpotiitiniro oia txineiro ãto txineirotikata Teoso misãkiretiko aikotiãkero. ");
INSERT INTO apuNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kiãtokopa atxataro oia txineiro? —itxakakana. Eereka ninoa imarotape. Iamotarina kikio, tiitxi kamakari kikiote, Xoteo minakaniua ikatiko tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Oa txineiro kiki okiko ĩki xika, Xesosi okiko ĩki xika, iua akauari takauãkataãka “Arẽkatxi Akauariti” inaãka. Uatxa akiritaãkapanika iuaãtaã “Arẽkatxi Akauariti.” ");
INSERT INTO apuNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iua atoko ininiã, kitxakapirĩka Teoso sãkire sãpiretakari Xeremia inakori atão txari: Isaeo auakani iĩkitxitari trĩta ota pirata kamakoro Teoso mereẽkiti okiko ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Eereka isikarona oa txineiro ota tiitxi kamakarimoni, ikikiote iamotinina ĩkapani, kotxi Teoso nirekari ia atoko ikaminina, itxa Xeremia kitxakapirĩka. Ininiã Xeremia sãkire iaõka apopeka iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iuasaaki Xesosi tima Homano auĩte Pirato inakori apisatoõ. Pirato pimaãri Xesosi: —Pitekani Xoteoakori auĩte txataua? —Ari, iuapitikarano —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Eereka sasetotxi auĩteakori, kiomãtxiakori pakini apoĩtari Xesosi. !Kasãkireri Xesosi iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ininiã Pirato txari: —Atauako kona pikenakotatari apoĩtiniina? ");
INSERT INTO apuNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Xesosi !kasãkireri, ininiã Pirato tsorĩkaãta. Ãkixinireẽ iua: —Kininiãpa !kasãkireri? ");
INSERT INTO apuNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ikini kiiniriti Páskoa inakori, Homano auĩte sikakari ãtika kateia ãki auakari kãkiti nirekakiti. ");
INSERT INTO apuNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Iuasaaki aua kateia ãki auakari Pahapasi inakori. Ikinimane imarotari iua. ");
INSERT INTO apuNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Itomaneri kãkiti apotiitakasaakiua, Pirato pimaãna ninoa: —Ĩkiripa kateia ãki auakari hinireka nisikakini? Pahapasikani? Xesosi Teoso mereẽkiti inakorikani? —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pirato imarotari Xesosi isikinina iuamoni ixikotinirina xika. ");
INSERT INTO apuNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Iuasaaki Pirato topãkanãta kãkiti misiritiko isãpiretini pakita ãki. Iuasaaki ĩtanoro iokanapireta iuamoni. —Maerekati !pikamape iua kikimoni, kotxi ixika !auari pokiniri. Erekari iua. Minipani nitaponetari iua kiki, ininiã maerekaxiniretinoka nitxa —otxari. ");
INSERT INTO apuNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mapara sasetotxi auĩteakori, kiomãtxiakori pakini misãkiretana kãkiti iuaãtaã apotiitakaniua: —Piratomoni hĩtxako: “Pisikakariko Pahapasi. Pokãkitakariko Xesosi,” hĩtxariko —itxana kãkiti. Ininiã ninoa auikari isãkirena. ");
INSERT INTO apuNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Eereka Pirato pimaãna kãkiti iuaã apotiitakaniua: —Ĩkiripa kateia ãki auakari hinireka nisikakini? Ininiã ninoa akirikata: —Pahapasira. ");
INSERT INTO apuNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—Kiãtokopa nitxatari Xesosi, Teoso mereẽkiti inakorima? —itxa Pirato. Ikinikana apakapapiretana: —Aamina ĩpiriãmitakari nopini pitokakitariko. ");
INSERT INTO apuNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ininiã Pirato: —Kixikapa? Maerekati !ikama —itxa. Iuasaakipeka ninoa iteene akiripoakatana: —Aamina ĩpiriãmitakari nopini pitokakitariko. ");
INSERT INTO apuNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ininiã Pirato kona sãpiretaikari Xesosi isikakini, kotxi ninoa neenamauatanapanoka. Ikosekari ãparaã. Arokauakotaua ninoa apisatoõ. —Na nota xikani ia kiki ipinako. Hĩte xikakara ia kiki ipina —Pirato txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ikinimane apakapapiretari: —Atãopitikara. Misirikaretxi auiniã okiko xika, ate, aamariteni pakini apakapariko iua misirikaretxi —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iuasaakipeka Pirato sikakari Pahapasi. Eereka ipaniãtari Xesosi xirokitatiko aãpitsaã. Eereka isikari Xesosi isotatonemoni aamina ĩpiriãmitakari nopini itokakitinirina tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ininiã sotatoakori anikari Xesosi ninoa auĩte aapokomoni. Iuaã akiritarina apanakini sotatoakori, ininiã ikinimane sotatoakori ãkitari Xesosi. Inapetarina. ");
INSERT INTO apuNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Imakatxakarina Xesosi mãka. Mãkatxi põkamarari ieretaka itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Eereka itakarina saporiẽta kotipiaro kamakori ikiiã. Iuako ikikomoni taka itxari aãke. Ininiã itxĩkitakarina Xesosi auĩtetxi atoko ininiãua. Eereka ikapotoreẽkauana iua apisatoõ, napeta itxarina Xesosi: —Aãuĩte —itxarina Xesosi inapetinina. —Xoteo auĩtekai pite —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ikiisokarina. Iua aãke ikosekana, arikiita itxapikarina. ");
INSERT INTO apuNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Inapetarina, eereka imakatxakarina mãkatxi põkamarari. Iua nakiti imãka iuaĩkana ieretaka itxarina. Eereka mapara anika itxarina, aamina ĩpiriãmitakari nopini itokakitinirina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Xesosi anikaãpotakasaakina, aõkitarina Sireni sitatxitikiri, Simão inakori. Ninoa paniãtari iua, Xesosi anikakiti aamina ĩpiriãmitakari, anikini ĩkapani, kotxi Xesosi !iposotaikari anikiniri. Ininiã Simão anikari. ");
INSERT INTO apuNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Apokana Kóokota inakoriãtaã. Apanakini akiritari “Kiitãtatxi” inaãka akiritiko. ");
INSERT INTO apuNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Iuaã iãriãmoni ikoketarina pinĩtxi kipixiãri, sika itxarina Xesosimoni, Xesosi iãtini ĩkapani, imakini ĩkapani. Atapixiãtaãka atoko, !iãtari. ");
INSERT INTO apuNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ininiã itokakitarina Xesosi aamina ĩpiriãmitakari nopini. Inaãka atoko ikamarina sarauatxi kai soroã. Sarauatxi kãiatakani apakapari Xesosi mãka. Kitxakapirĩka Teoso sãkire sãpiretakari sãpiretapekari ikara atoko inini tĩkane. Iua txari: Ixanakarina nimãka. Sarauatxi ikamana nimãka apakapakani imarotinina ĩkapani. Itxa Teoso sãkire sãpiretakari kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sarauatxi xipoka atoko iitopãkana. Imoiaãrina Xesosi, kãkiti manikakaniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aamina ĩpiriãmitakariã ikii nopini itakarina iõkatsopatakori: “Xesosi, Xoteoakori Auĩte,” itxa iõkatsopatakori. Ikara xika okaãka Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Xesosi takote itokakitarina ipi kiĩtiririni aamina ĩpiriãmitakari nopini, ãti Xesosi kikomoni, ãti Xesosi sanaremoni. ");
INSERT INTO apuNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kãkiti iuaã napakani napetari, nokonoko itxa kiitana. Maerekaeneti isãkirepiretarina Xesosi: ");
INSERT INTO apuNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Pite txari: “Aiko Teoso misãkiretiko niriãka atoko, ipi ãti õtisaaki iuaĩkana nõkitikari,” pitxa. Piteka pimakatxakaua. Pite Teoso ãkiri pinakasaakiua, pikatxaka. Ikara atoko itxa sãkiretana kãkiti iuaã napakani. ");
INSERT INTO apuNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Iua atokotxikana itxana sasetotxi auĩteakori, kaiõkatsoparerini, kiomãtxiakori pakini ikara atoko inapetarina Xesosi: ");
INSERT INTO apuNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Iua makananitapekari apanakini. Txamari iuaka !iposotari imakananitiniua. Iua Isaeo auakani auĩte ininiãua, iuaka imakatxakamauako. Ikatxakiniã, ate auikari iua sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iua auikari Teoso sãkire. Maiãtapari. Atauako Teoso nirekari imakatxakiniri iua uatxa, kotxi iua txari: “Teoso ãkirirano nota,” itxa —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kiĩtiririni iuakata tokakitakoni apaka maerekaeneti isãkirepiretarina Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Apaniãxiti itixi piãka. Ipi ãti pakini oara ipiãka. ");
INSERT INTO apuNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ipi ãti pakini oarape kikatamonipeka Xesosi iteene akirikata: —Erii, Erii, aremaa sapakatanii. Ikara Epireo sãkire. Ia atatsopatakari sãkireẽ, “NiTeosone, niTeosone, kinirepa pitakanapano?” ");
INSERT INTO apuNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kãkiti iuaã auakani kenakotari Xesosi sãkire. Ninoa uãkatari akirinãtiniri Eríasi. ");
INSERT INTO apuNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ininiã ãti miteka, mapoa atoko inakari iãka itxari iãriã katxioãrimoni. Aãke mapotõkire taka, isirĩka itxamari Xesosi iãtini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Txamari apanakini: —Kona pisikapiri. Atxiĩti Eríasi makatxakari iua —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iuaĩkana Xesosi iteene akirikata. Eereka iokanatari ixinire Teosomoni, eereka ipĩpe. ");
INSERT INTO apuNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iuasaakipeka mãkatxi mata Teoso misãkiretiko aikoti ãki arõkakari tsorakita. Itano itsorakita. Ixitipeka apoka. Mitxi iua mãkatxi mata !auiritari kãkiti ĩroini Teosonani Auini Pakitaãtaã. Itsorakitakasaaki, itixi iakeẽkata. Kai mitari xoreka iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Apanakini akauari xoreka. Itomaneri kãkiti ipĩkani Teoso nakitiakori iuaĩkana õkitikapekaua. ");
INSERT INTO apuNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Osipikarina akauari. Xesosi iuaĩkana õkitikaãkaua atoko, isana Xerosareẽmoni, Teoso nakiti sitatxitimoni. Iuaã itomaneri kãkiti itikana ninoa iuaĩkana õkitikakaniua. ");
INSERT INTO apuNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sotato auĩte, sotatoakori Xesosi moiaãkani apaka, itikarina Xesosi ipinini. Imarotarina itixi iakeẽkatini, ininiã iteene ipĩkarauatana. —Atãopitikara Teoso ãkiri itxaua —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Itoro sitoãkini ikira atoko atamanãtari Xesosi. Kariréia tõpa Xesosi potorikasaaki ninoa sitoãkini moianatari iua. ");
INSERT INTO apuNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maria Matarena inakoro iuaã aamina ĩpiriãmitakari ikira atoko auanãta apaka. Txiako, Xosee pakini inoro, Maria inakoro iuaã aua. Sepeteo anaakori inoro iuaã auanãta apaka. ");
INSERT INTO apuNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ĩkanõka katxineiroteri Xosee inakori, Arimateia sitatxitikiri, apoka. Iua apaka Xesosi sãkire auiãkari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Isa Piratomoni. Xesosi ĩto amanaã. Ininiã Pirato paniãtari isikiko. ");
INSERT INTO apuNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ininiã Xosee anikari Xesosi ĩto. Mãkatxi mataã iapirika itxari. Mãkatxi mata amaneri arínio inakoriã iapirikari. ");
INSERT INTO apuNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Eereka taka itxari akauari ãki. Iua akauari amaneri, Xosee kisakakiti kai auĩte iriko. Ikamari iua akauari ipĩkasaaki ikatiko ĩkapani. Xesosi ĩto iriko ãki itaka atoko ikakanapiritari kai meraminapoari, itota itxari akauari iriko, sipe itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Iuasaaki Maria Matarena inakoro, ãto Maria inakoro apaka topãkanãta akauari apisatoõ. ");
INSERT INTO apuNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Iua õti sesta veira, tomatiko õti apisa. Iua õti Xoteoakori parĩkauatapitipo, tomatiko õti imaparĩkauatakani ĩkapani. Katimatinĩkata sasetotxi auĩteakori, pariseoakori pakini sari Piratomoni. ");
INSERT INTO apuNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ninoa txari: —Ate xinikari iua kamisirienereri sãkire. Iua txari: “Nipĩkasaaki eereka ipi ãti pakini õtisaaki iuaĩkana nõkitikauako.” ");
INSERT INTO apuNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pipaniãtana pisotatoneakori ipi ãti pakini õti akauari imoiainina. Imamoiaãkaniãrina, imoianariakori ĩkanõka sari iuaã iĩto iĩtirĩkinina. Ininiã eereka isãpiretarina kãkiti: “Teoso õkitikapekari iua. Iuaĩkana auãki itxapeka,” itxamana ninoa imoianariakori. Ininiã ikara misirieneretxi apiatama eereka. Mitxiri misirieneretxi poiãoka —itxarina Pirato. ");
INSERT INTO apuNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","—Ininiã hanikari sotatoakori akauari moiaãkani tĩkane. Hĩsa. Hĩtotariko akauari sona —Pirato txana. ");
INSERT INTO apuNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ininiã isana iuaã. Akauari sona iteene itotinina ĩkapani. Itakarina Pirato takaõtxikare itore nopini. Sotatoakori iuaã kaikota. Imoiaãrina akauari. ");
INSERT INTO apuNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tomatiko õti xipoka atoko, tomĩko ĩkanõkapanika Maria Matarena, oa ãto Maria pakini sari akauarimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ninoa saãpotakasaaki, katimaritika itixi iakeẽkata itapararitika. Iuasaaki Teoso nitiri iaxitikiri katxaka. Ikatapakiritari kai akauari tore, topãka itxa iua kai nopini. ");
INSERT INTO apuNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Itoõ atokatxi iotximere atoko itxa. Imãka mapoa saro atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sotatoakori, akauari moiaãkani, kikinanaãkata, ipĩkarauatinina. Irikana xitipeka. Ipĩkani atokopeka itxana. ");
INSERT INTO apuNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Eereka ninoa sitoakoro apoka akauari. Teoso nitiri misãkiretana: —!Hĩpĩkarauatape. Nimarotari hĩte nitanãtiniri Xesosi, aamina ĩpiriãmitakari nopini tokakitakori. ");
INSERT INTO apuNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","!Auaika uai. Teoso õkitikapekari iua. Ikara iua sãpiretapekai hĩte. Uai hina. Hãtamatari iĩto mitxi auiniãtaã. Ininiã ninoa atamatari. ");
INSERT INTO apuNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","—Katima hĩtxako imoianariakorimoni hĩsini ĩkapani. Hĩsãpiretana: “Iuaĩkana auapeka itxa Xesosi. Teoso õkitikapekari iua. Iua sari hĩte apisapanika Kariréiamoni. Iuaã haõkitariko iua,” hĩtxako ninoamoni. Ikara atoko nitxa nisãpirena hĩtemoni —itxa Teoso nitiri. ");
INSERT INTO apuNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ininiã ninoa takanapari akauari. Ipĩkareritikana, ieneniritikana isana. Imitekana Xesosi moianariakorimoni õkitikiniua isãpiretini tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ninoa mitekaãpotakasaaki, ipixinipokoriti Xesosi tokiã ninoamoni: —Hĩtepini ina —itxana. Ininiã ninoa kapotoreẽkaua iua apisatoõ, maĩkakitita itxarina. —Peerekai. Apiananiri pitxaua —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ininiã Xesosi: —Kona hĩpĩkarauatape. Nitariakorimoni hĩsa. Hĩsãpiretana Kariréiamoni isinina. Iuaã aõkitanonako nota —Xesosi txana ninoa Mariaakoro. Ininiã ninoa sipe. ");
INSERT INTO apuNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sitoãkini sikasaaki, ãtikaka sotatoakori akauari moiaãkani kanapiriã sitatximoni. Isãpiretarina itikakitina sasetotxi auĩteakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ininiã sasetotxi auĩteakori, kiomãtxiakori pakini apotiitaua ikara ene ixinikinina ĩkapani. Eereka isikarina itoro txineiro sotatomoni, atão imasãpiretakanina ĩkapani apanakinimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ininiã sasetotxi auĩteakori, kiomãtxiakori pakini txana: —Hĩtxariko apanakinimoni: “Xesosi moianariakori apoka ĩkanõka aimakasaaki. Iĩtirĩkarina Xesosi ĩto,” hĩtxako. ");
INSERT INTO apuNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hĩauĩte Pirato imarotakasaakiri himakini, ininiã ate misãkiretariko iua, ininiã kona himisiritaãka himakini xika —itxarina sotatoakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ininiã sotatoakori apakaparo txineiro, sãpireta itxarina kãkiti Xesosi moianariakori ĩtirĩkiniri Xesosi ĩto. Ikara aãpirena iaripireta Xoteoakorimoni. Uatxa apaka ikara aãpirena auiãkapanika. ");
INSERT INTO apuNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Õsi pakini Xesosi moianariakori sari oxiratarimoni Xesosi paniãtinimoni Kariréia tõpamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ninoa atamatari Xesosi. Ikapotoreẽkauana iua apisatoõ. —Peerekai. Apiananiri pitxaua —itxanãtana. Txamari ãtikaka kona iteene auikari iua Xesosi ininiãua. ");
INSERT INTO apuNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Xesosi apoka ninoa takote, misãkireta itxana ninoa: —Teoso txĩkitakano itixine auakani auĩte nininiãua. Itxĩkitakano ĩkoraxiti auakani auĩte apaka nininiãua. Ininiã ikinika posotiiretxi aua notamoni. ");
INSERT INTO apuNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ininiã nipaniãtai. Hĩsako ikini uãkati kãkitimoni ikini itixitika. Hõerekana ninoa nisãkire. Hĩpatxisatana nisãkire kĩpitakani niri uãkaã, imi uãkaã, Erekari Matamatakoti uãkaã pakini hĩpatxisatanako. ");
INSERT INTO apuNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Hõerekanako ninoa ikinika nipaniãtakiti ikaminina ĩkapani. Hĩxinikariko ia. Nota ãtipirika auako hĩtekata. Hĩtekata nauiniritika itixi xipokako —itxa Xesosi sãkire.");
INSERT INTO apuNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ia Xesosi Kristo iokanapirena erekari. Teoso ãkiri itxaua Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Teoso sãkire sãpiretakani iõkatsopatari ia: Niokanatariko niokanapirena aniãkari kãkitimoni kimapori oeretini ĩkapani pite uai apokini apisa. ");
INSERT INTO apuNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Iua auako ãparaã makipakaniãtaã. Isãpirenauatako: “Hõeretariko kimapori Apiananiri apokini apisapanika. Itĩkaãpo erekari hĩkamako iua napini ĩkapani,” itxa iua. Itxa Teoso sãkire iõkatsopatakori kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ikara atoko Xoão kapatxisareri ãparaã makipakaniãtaã aua. Ipatxisatakasaakiri kãkiti, isãpiretari ia pirena: —Hĩtakanapariko maerekati hĩkamakiti. Hĩpatxisataãkako. Ininiã Teoso makatxakariko maerekati hĩkamakiti —itxa Xoão kapatxisareri. ");
INSERT INTO apuNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ikinimane kãkiti Xotéia auakani Xerosareẽ sitatxiti auakani pakini sari Xoãomoni isãkire ikenakotinina ĩkapani. Ninoa sãpiretakasaakiri maerekati ikamakitina, ipatxisatana uini Xotão inakoriãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Xoão takari imãka kamero piti kamakori. Itakari ipakiomatare pirãtxi mata kamakori. Inikari txĩtxiri. Mapaã itxima. ");
INSERT INTO apuNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iua txari kãkitimoni: —Nota poiãori. Nota tikini apokako apiatakari. !Apakata nikapotoreẽkiniua iua takote ikiti mata nimakatxakini ĩkapani, kotxi nota poiãoka. Iua apiata. ");
INSERT INTO apuNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nota patxisatai ãparaaãnokara. Iua patxisataiko Erekari Matamatakotiã. Iuasaaki hĩte apakapariko Erekari Matamatakoti. ");
INSERT INTO apuNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Iuasaaki Xesosi apoka Nasaree sitatxiti, Kariréia tõpamoni. Iuasaaki Xoão kapatxisareri patxisatari iua uini Xotão inakoriãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Xesosi kanĩkiĩtakasaaki, iua itikari iaxiti takakini. Iuasaaki Erekari Matamatakoti katxaka kamoa katxakini atoko. Iua nopini apoka. ");
INSERT INTO apuNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iuasaakipeka Teoso iaxitikiri txari: —Pite namarite, nitiretakiti, napokaerekatai, kotxi ninirekakiti pikama. ");
INSERT INTO apuNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iuasaaki Erekari Matamatakoti iokanatari Xesosi ãparaã makipakaniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iuaãtaã ikaikota koarẽta õti. Iuasaaki Satanasi atamakaerekatari iua. Iuaãtaã auari kaxipirini kaneenamarini. Ininiã Teoso nitiriakori iaxitikini nĩkatari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Xoão kateia ãki takikosaaki, Xesosi sari Kariréia tõpamoni. Iuaãtaã isãpiretari Teoso iokanapirena erekari, Teoso auĩtetxi ininiãua pirena. ");
INSERT INTO apuNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Itxari: —Teoso keto apopeka. Iua auĩtetxi ininiua apokaãpotapeka. Ininiã hĩtakanapariko himaerekani. Hãuikariko Teoso iokanapirena erekari —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Xesosi tĩpokota Kariréia poati tiniã. Iuasaaki atamatana ipi hetxi takakani, Simão Petro, itari Ãtree pakini. Iua atamatana itakinirina hetxi. ");
INSERT INTO apuNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ininiã Xesosi txana: —Uatxa masa notakata. !Himaĩkaikariko ximaki. Ãtião hĩparĩka auako. Nisãkire hĩsãpiretako kãkitimoni —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ininiã iuasaaki ninoa takanapari hetxi, sa itxana Xesosikata. ");
INSERT INTO apuNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Apikomoni ninoa saãpota. Itikana Txiako, itari Xoão pakini. Ninoa Sepeteo anaakori. Kanaua miramaneri ãki auanãtana iuasaaki. Hetxi iotsaãnãtana. ");
INSERT INTO apuNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iuasaaki iua akiritana ninoa. Ininiã ninoa takanapari iri, iri nitiriakori pakini kanaua ãki. Eereka isana Xesosikata. ");
INSERT INTO apuNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Xesosi imoianariakorikata apoka Kapanaoõ sitatxiti. Ininiã tomatiko õtisaaki Xesosi sari aiko Xoteo apotiitiniãtaãua oerekarauatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iua sãkire kenakotakani tsorĩkaãta, kotxi kona kaiõkatsoparerini atokoni !itxa. Iua oerekakiti sãkiretxiti pataparari, kotxi !isãpiretari ãti koerekareri sãkire apanakini kaiõkatsoparerini atoko. Iuaka sãkirekara isãpireta. ");
INSERT INTO apuNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Iuasaaki aiko ãki Xoteo apotiitiniãtaãua aua kiki maerekati matamatakoti auakiti. Iua akiripoakata: ");
INSERT INTO apuNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Xesosi Nasaree sitatxitikiri. Kipa pinireka atemoni? Pite ina ate pixipokini ĩkapanikani? Erekarinoka kamakarii. Teoso nakiti pitxaua —itxa. Ikara atoko iua akiripoakata, kotxi iua maerekati matamatakoti pĩkari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ininiã Xesosi itapararitika txari: —Piotoka. Pitakanapariko ere kiki ĩto. ");
INSERT INTO apuNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Iuasaaki maerekati matamatakoti iõkokaĩtotari. Ikatxakasaaki, akiripoakata. ");
INSERT INTO apuNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kãkiti iuaãtaã auakani tsorĩkaãta. Iuasaaki imisãkiretakakauana: —Kiripa? Atxiĩti oerekakori sãkiretxiti amaneri apopeka? Iua sãkire kaposotiireri. Ipaniãtakiti maerekati matamatakoti kamapeka —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ininiã ikara pirena iaripireta ikini Kariréia tõpati. ");
INSERT INTO apuNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ininiã Xesosi, Txiako, Xoão pakini takanapakasaakiri aiko Xoteo apotiitiniãtaãua, isana Simão, Ãtree pakini aapokomoni. ");
INSERT INTO apuNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Iuasaaki Simão imakiro apoomata. Osirĩkanãta. Ininiã ninoa sãpiretari Xesosi oamianare. ");
INSERT INTO apuNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ininiã Xesosi sari oamoni. Imaĩkaro ouako. Õkitikaro. Iuasaakipeka oãpoomare !auaika. Ininiã opotorika oparĩkauatini, ninoa kiena okamini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ininiã mapiãnikata kãkiti minana ikinipoko amianatakani, maerekati matamatakoti auaĩtotakini pakini iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ininiã ikinimane iua sitatxi auakani apotiitaua aapokotxi tore takote. ");
INSERT INTO apuNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ininiã Xesosi makananitana itomaneri amianatakani. Kaiãopokori amianari auakini imakananita. Apaka omitikana itomaneri maerekani matamatakoni. Iuasaaki !auiritana ninoa sãkirauatini, kotxi ninoa imarotari Teoso ãkiri ininiua Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ĩkanõkapanika mapiãpanika Xesosi õkitikaua. Itakanapari aapokotxi. Iuanoka sari kãkiti mauakaniãtaã iri iaxitikiri imisãkiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Eereka Simão imoianariakorikata sari Xesosi initinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ninoa apokasaakiri, itxana: —Ikinimane nitai —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Xesosi apakapapiretana: —Masa ãtiãtaã kãkiti aapokomoni. Iuaã nisãpiretariko Teoso sãkire, kotxi ikara atoko itxa niparĩka kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Xesosi sari ikini Kariréia tõpa. Aiko Xoteo apotiitiniãtaãua isãpiretari Teoso sãkire. Apaka omitikana maerekani matamatakoni kãkiti ĩtoã auakani. ");
INSERT INTO apuNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Amianatakari maere matati apoka Xesosimoni. Ikapotoreẽkaua iua apisatoõ. Iua iteene amanaãri: —Nimarotari, pinirekiniãri piposotari erekape pitxĩkitakinino —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ininiã iuasaaki Xesosi iteene tiretari iua. Itakari iuako iua nopini. Itxari: —Ari, ninirekapitikari. Erekapekai uatxa. ");
INSERT INTO apuNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Iuasaakipeka amianari !auaika. Erekapekari iua. ");
INSERT INTO apuNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Xesosi iokanatari iua. Iuasaaki isãpiretari iua: ");
INSERT INTO apuNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Kona pisãpiretapiri apanakini pitemoni nikamakiti. Uatxa merepanika pisa sasetotxiakorimoni. Poerekari piĩto ninoamoni. Eereka pikamariko Moisesini paniãtakiti. Ikara atoko oerekari kãkiti atão erekapeka pinini —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Iuaritika isãpiretapikari Xesosi kamakiti. Ininiã iaripireta ikara pirena. Ikara xika Xesosi !iposotaika isini aapokotximoni. Ikaikota kãkiti mauakaniãtaã. Iuaritika kãkiti sari iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Eereka mapaõtipeka inaka atoko iuaĩkana Xesosi Kapanaoõ sitatxiti apoka itxa. Iaripireta Xesosi inirimane aapoko apokini. ");
INSERT INTO apuNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iuasaakipeka mirikiniti kãkiti apoka iuamoni, ininiã iua aapokotxi xãpoka. Apotiitauana ĩronakikoãtaã apaka. Ininiã !apakata apanakini kãkiti ĩroini aapokotxi ãki. Iuasaaki Xesosi sãpiretari Teoso sãkire kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Iuasaaki ipi ipi pakini kikiakori minari matĩpokotakati. ");
INSERT INTO apuNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kãkiti itomaneri ĩronakikoãtaã aua, ininiã kona iposotarina Xesosi takote apokinina. Ininiã aapokotxi nopini, Xesosi manapi ninoa sonatari iua matĩpokotakati iokatxakinina tĩkane Xesosimonikari. Iposo atoko isikakaãpotarina iua manapi. ");
INSERT INTO apuNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Xesosi imarotari ninoa atão auikiniri iua sãkire. Ininiã Xesosi txari matĩpokotakatimoni: —Namarite, pimaerekani makatxakapeẽkaika —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Iuasaaki ãtikaka kaiõkatsopareriakori topãkanãta iuaã. Itsorĩkaãnãtana. Ixiniremoninani: ");
INSERT INTO apuNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Kinirepa ia kiki ikara atoko itxa? Maerekati isãpiretakiti, kotxi Teosonanira posotari imakatxakiniri kãkiti maerekani —itxa ninoa sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iuasaakipeka Xesosi imarotari ninoa xinikakiti ãkixinireẽna. Ininiã Xesosi txana ninoa: —Kininiãpa ikara atoko hĩtxa xinireta? ");
INSERT INTO apuNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nitxari iua imaerekani nimakatxakini, txamari !himarotari imaerekani atão nimakatxakini. “Põkitikaua. Pisirimata pikoseka, sipe pitxa,” nininiã, iuasaaki himarotari nisãkire atão ininiãua, kotxi hĩtikari. Niposotiire imaerekani nimakatxakini ĩkapani, niposotiire iua nõkitikini ĩkapanitxikana. ");
INSERT INTO apuNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ininiã uatxaika noerekai hĩte, Teoso iokanatano nota hĩtari iaxitikiri ĩkorapokoritimoni kãkiti maerekani nimakatxakini ĩkapani —itxana kaiõkatsopareriakori. ");
INSERT INTO apuNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ininiã matĩpokotakatimoni itxa: —Põkitikaua. Pisirimata pikoseka, sipe pitxa paapokomoni —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Iuasaakipeka iua õkitikaua. Ikosekari isirimata. Ĩkorape itxa ikinimane okiãtaã. Imakinika kãkiti tikoka. —Peerekari Teoso kamakiti. Kona mitxi ate itikari ĩkora atoko inakari —itxanãtana kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ininiã iuaĩkana isari ipoamoni. Kaiãopokori kãkiti apotiitaua iuakata. Iuasaaki oerekana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Isaãpotakasaaki, atamatari Arevii inakori. Ãti iuãka Mateo inaãka. Aopeo inakori ãkiri itxaua iua. Iitopãkanãta auĩtetxiakori txineirote apakapiniãtaã. Ininiã Xesosi txari: —Masa notakata. Iuasaakipeka õkitikaua, Xesosikata sa itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Eereka Xesosi nipokota Arevii aapoko. Itori auĩtetxiakori txineirote apakapakani, itori apanakini maerekani, topãkanãta Xesosi takote, imoianariakori takote pakini. Kaiãopokori kãkiti aua iuasaaki, kotxi kaiãopokori kãkiti Xesosikata sikani. ");
INSERT INTO apuNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pariseoakori, kaiõkatsopareriakori pakini itikari Xesosi auĩtetxiakori txineirote apakapakanikata, apanakini maerekanikata pakini inipokotini. Ininiã kaiõkatsopareriakori, pariseoakori pakini pimaãna Xesosi moianariakori: —Kinirepa hinipokota auĩtetxiakori txineirote apakapakanikata, maerekanikata? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Xesosi ikara ikenakotakasaaki, itxana: —Kãkiti mamianatakani kona nirekari kãkiti pinĩtxi imarotakari. Amianatakaninokara nirekari pinĩtxi imarotakari. Nota uai apoka maerekani nakiritini ĩkapani, imaerekanina itakanapinina ĩkapani. Kona nakiritari kãkiti “atão inakari kamakani” uãkatakaniua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ãti õti Xoão moianariakori, pariseoakori pakini takanapari inikinina Teoso imisãkiretinina ĩkapani. Iuasaaki kãkiti pimaãri Xesosi: —Kinirepa Xoão moianariakori, pariseoakori pakini takanapari inikinina Teoso imisãkiretinina ĩkapani, txamari pite moianariakori kona ikara atoko !itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ininiã Xesosi: —Kiiniri kãkiti ĩtanorouatakasaaki, ĩtanorouatakari aua iuaã, ininiã kona kãkiti takanapari inikini iuasaaki. Kona iua ĩtanorouatakari nirekari kãkiti natxitini. Ininiã iua auakasaaki ninoakata, ikinimane nipokota. ");
INSERT INTO apuNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ininiã nota ĩtanorouatakari atoko nitxa. Nota auakasaaki nimoianariakorikata, kona itakanaparina inikinina Teoso imisãkiretinina ĩkapani. Ãti õti nota !auaika nimoianariakorikata. Iuasaakiikarako itakanaparina inipokotinina Teoso imisãkiretinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kona kãkiti tãpanetari mãkatxi kitxakari mãkatxi mata amaneriã. Mãkatxi mata amaneri itxikika, ininiã kitxakari tsorakita. ");
INSERT INTO apuNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kona kãkiti takari iãriã amaneri sako kitxakari aamata kamakori ãki. Itakiniãri, koanatxi kitxakari aamata kamakori tsorakita, ininiã iãriã xikepoata, ininiã koanatxi !kikeikari. Sako amaneri ãki itakaãka iãriã amaneri. Iua atokokana kona hĩkoketari kitxakari sãkiretxiti amaneri sãkiretxitikata. ");
INSERT INTO apuNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tomatiko õti Xesosi imoianariakorikata napaãpota kikio triko takikoãtaã. Ininiã ninoa makatxakaro triko iki mapaki inikinirona ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pariseoakori atamatana, ininiã itxarina: —Kinirepa ninoa parĩkauata tomatiko õtisaaki? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ininiã Xesosi apakapapiretana: —Kona hãtatsopatapanikari Taviini kamakiti? Iua, imoianariakorikata natxitakasaaki, kona himarotatari ikamakiti? ");
INSERT INTO apuNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Iua ĩroã Teoso misãkiretikoãtaã. Apiataa inakori sasetotxi auĩte apiatakari iuasaaki. Iuaã Tavii nikari komiri Teosomoni sikakori. Sasetotxinokara auiritaãka iua komiri inikinina. Apanakini !auiritaãka inikiniri. Txamari Tavii sikari imoianariakori inikinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","—Tomatiko õti kamaãka, kãkiti ĩto ereka inini ĩkapani. Kona kãkiti kamaãka tomatiko õti auini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nota hĩtari iaxitikiri posotari ikinipoko ninireẽkiti nikamini tomatiko õtisaaki, kotxi Apiananiri nitxaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iuaĩkana Xesosi imoianariakorikata ĩroã aiko Xoteoakori apotiitiniãtaãua. Iuaã apokari kiki motĩkauakotakari. ");
INSERT INTO apuNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ininiã iuaã auakani txari —Atxiĩti iua erekapeka txĩkitakari motĩkauakotakari uatxa tomatiko õtisaaki? Ninoa xinikari ikara atoko inini, kotxi ninoa kinirão apoĩtaka txari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ininiã Xesosi akiritari iua motĩkauakotakari: —Uaimoni pina —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Iposo atoko ipimaãna iuaã auakani: —Kipa atão Teoso paniãtaua akamini tomatiko õtisaaki? Maerekati akaminikani? Erekari akaminikani? Ipaniãtataua ãti amakananitini? Ipaniãtataua ãti aõkini? Txamari ninoa !kasãkirena. ");
INSERT INTO apuNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Xesosi atamatana. Iuasaaki inaiataua, iuaritika imatinaniuata, kotxi ninoa !inirekari atão imarotinina. Ininiã Xesosi txari iua motĩkauakotakari: —Pisirĩkauakota —itxari. Ininiã itamẽkauakota. Erekape itxa iuako. ");
INSERT INTO apuNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ininiã pariseoakori potorika iuaã. Isana Erotxi sãkire auiãkanimoni. Iuaãtaã ninoa xinikari Xesosi okaenetinina. ");
INSERT INTO apuNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ininiã Xesosi sari Kariréia poamoni. Iuasaaki itori kãkiti Kariréia tixinikini, Xotéia tixinikini pakini sari iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Xerosareẽ sitatxitikini, Itoméiakini, Xotão ipiniãkini, Txirokini, Sitoõkini pakini sari iuamoni. Ninoa kenakoenetari ikamakiti, ininiã iuamoni isana. ");
INSERT INTO apuNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ininiã ipaniãtana imoianariakori: —Kanaua himina, kotxi kaiãopokori kãkiti katikaãpotano. Ininiã kanaua ãki niereẽtaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iuasaaki kaiãopokori kãkiti erekapeka itxĩkitakapeka. Apanakini amianatakani nirekakari imaãtakinirina Xesosi, erekapeka ininina ĩkapani. Ininiã ikatikaãpotarina Xesosi, kotxi kaiãori kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Maerekati matamatakoti auakini atamatakasaakiri Xesosi, irikana Xesosi apisatoõ. Akiripoatana: —Teoso ãkiripitikai pite. ");
INSERT INTO apuNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ininiã Xesosi kona auiritana ninoa: “Teoso ãkiripitikai,” ininina. ");
INSERT INTO apuNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iposo atoko Xesosi sari õtanoxiratarimoni, akirita itxana inirekaãkini. Ininiã ninoa sari iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ininiã iua mereẽna tosi kikiakori iuakata kaikotakani tĩkane, Teoso sãkire sãpiretakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Iua sikari iposotiire ninoamoni, amianatakani erekapeka itxĩkitakinina ĩkapani, apaka maerekati matamatakoti omitikinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ininiã akiritari Simão. Xesosi takauãkatari Simão ãti iuãka. Petro itxaua. ");
INSERT INTO apuNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Akiritana Txiako, itari Xoão pakini. Sepeteo anaakori itxauana. Xesosi takauãkatana ninoa Poanexi. Poanexi Popĩkari sãkireẽ “Ikarokirauari anaakori.” ");
INSERT INTO apuNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Akiritana Ãtree, Piripi, Patoromeo, Mateo, Tomee, Txiako pakini. Aopeo ãkiri itxaua iua Txiako. Akiritana Tateo, Simão pakini. Homano omanatakari iua Simão. ");
INSERT INTO apuNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Akiritari Xotasi Isikariotxi inakori apaka. Xesosi mĩkapiritakari itxaua iua Xotasi Isikariotxi. Pakini Xesosi akiritakini imoianariakori ininiuana ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iuaĩkana ãti aapokotxitimoni isa Xesosi, imoianariakorikata. Iuasaaki mirikiniti kãkiti iuaĩkana apotiitaua. Ikara atoko ininiã kona ninoa nipokota. !Apakata inipokotinina, kotxi mirikiniti kãkiti aua iuaã. ");
INSERT INTO apuNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Xesosi nirimane kenakotari kãkiti apotiitiniua iuakata. Ininiã isana iua apinina ĩkapani. —Imapitxiritapeka —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kaiõkatsopareriakori Xerosareẽ ĩkani apoĩtari Xesosi maerekati ikamini. Ninoa sãkire: —Peosepoo inakori auaĩtotari iua. Ininiã Peosepoora omitikari maerekati matamatakoti —itxana. Peosepoo Satanasi itxaua. Apanakini sãkire: —Maerekani matamatakoni auĩte sikaposotiiretari Xesosi maerekati matamatakoti omitikini. ");
INSERT INTO apuNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ininiã Xesosi akiritari kãkiti isãkire ikenakotinina ĩkapani. Sãpirenatxi atão inakari oerekiko isãpiretana ninoa. Ipimaãna: —Natokopa itxa Satanasika omitikiniua? ");
INSERT INTO apuNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Auĩtetxi tixine auakani naiatakakiniãua, ixipokaãkanako. ");
INSERT INTO apuNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kãkiti aapoko ãki auakani ninoakakarika neenamauatiniã, ixipokaãkanako apaka. ");
INSERT INTO apuNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Iua atokokana, Satanasi nitiriakori, ninoakakarika naiatakakiniãua, Satanasi tapara xipokako. ");
INSERT INTO apuNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","—Kona kãkiti ĩroã kiki mitapoari aapoko ãki iĩtiriuatini ĩkapani. Kinirão iĩtiriuataka, ininiã iaxirikari mitari mitxi. Iposo atoko inirekaãkiti iĩtirĩka. ");
INSERT INTO apuNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","—Ari, atãopitikara nota txai hĩte. Apakata Teoso makatxakiniri ikinipoko maerekati kãkiti kamakiti, imaerekani Teoso imisãkirepiretini pakini. ");
INSERT INTO apuNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Txamari ãtipekana maerekati kamakari aua. Erekari Matamatakoti misãkirepiretakari maerekani makatxakiko kona auari. Ikara atoko inakani inikoriãriko imisiritiko maerekani misiritikoãtaã —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Xesosi ikara atoko itxa, kotxi pariseoakori txari: “Iua auari maerekati matamatakoti.” ");
INSERT INTO apuNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iuasaaki itariakori inorokata apoka porikiti. Ipaniãtarina ãti akiritiniri Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iuasaaki itori kãkiti topãkakani ãkitari Xesosi. Isãpiretarina: —Pitariakori, pinoro apaka porikiti aua. Initanãtai —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ininiã Xesosi apakapapireta: —Kiripa nitariakori, ninoro pakini? ");
INSERT INTO apuNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Iua atamatana itakote topãkakani: —Hãtamata, uai aua ninoro, nitariakori pakini. ");
INSERT INTO apuNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Teoso nireẽkiti kamakani nitariakori, nitaroakoro, ninoro pakini itxauana —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iuaĩkana Xesosi oerekarauata ipoa takote. Kãkiti mirikiniti, ininiã imorõkokaua kanaua ãki. Iitopãka. Ninoa aua imiriĩ, ininiã iua kanauaã oerekarauata. ");
INSERT INTO apuNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Itori Teoso sãkire oerekana ninoa sãpirenatxi atão inakari oerekikoã. Itxana: ");
INSERT INTO apuNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Hĩkenakota. Katakareri takarauata. ");
INSERT INTO apuNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Itakarauatakasaaki itakareki irika kimapori tiniãpo. Ininiã kotipiriki nikari itakareki. ");
INSERT INTO apuNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","—Apanakini itakareki irika kai auiniãtaã, kipatxi mauakaniãtaã. Atãoka ipitxaka. ");
INSERT INTO apuNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kipatxi poiãoka auiniã atokatxi pataka apokasaaki itxarika. Omakotsani xika osonãka. ");
INSERT INTO apuNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Apanakini irika inako sauaki. Inako aneẽkasaaki, okari takari. !Iriuata. Ipina. ");
INSERT INTO apuNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","—Apanakini irika kipatxi auiniãtaã. Ininiã iriuata. Ãti poiãoka iriuata, trĩtakata. Ãti apiata iriuata, sesẽtakata. Ãti kaiãopoko iriuata, seĩkata. ");
INSERT INTO apuNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","—Kakenakokii, ininiã hĩkenakotariko nisãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iuanani imoianariakorikata auakasaaki, ipimaãrina Xesosi: —Poerekaua mixikanani sãpirenatxi atão inakari oerekiko pisãpiretakiti? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ininiã isãpiretana: —Teoso sãkire mauiãkani !imarotari Teoso auĩtetxi ininiua. Teoso oerekai hĩte ninoa mimarotakiniti. Teoso oerekana ninoa isãkire sãpirenatxi atão inakari oerekikoã. ");
INSERT INTO apuNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Atxiĩti ninoa iteene atamatari Teoso oerekakiti, iuaritika !imarotarina atamatakitina. Atxiĩti iteene ikenakotarina Teoso sãkire, iuaritika !imarotarina ikenakotakitina. Imarotaãkamariko, akiritaãkamariko Teoso, ininiã Teoso makatxakamariko ninoa maerekani. ");
INSERT INTO apuNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ininiã Xesosi txari: —Himarotatari ikara sãpirenatxi atão inakari oerekiko? —!Aimarotari —itxana. —Ininiã natokopa ininiãparako himarotatari apanakini sãpirenatxi atão inakari oerekiko? ");
INSERT INTO apuNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ininiã imimarotakinitina oerekana: —Iua takarauatakari takari Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aua kãkiti kimapori tiniãpo takarekitxi irikiniãtaã atoko inakani. Ininiã Teoso sãkire ikenakotakasaaki Satanasi apoka. Ininiã imakatxakari Teoso sãkire ãkixinireẽna apokakari. ");
INSERT INTO apuNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","—Aua kãkiti kai auiniãtaã atoko inakani. Ninoa kenakotakasaakiri Teoso sãkire, iuasaakipeka apakaparina ipoxokoniritikana. ");
INSERT INTO apuNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Itxamana, kona kakotsari. Imaxikiko apokiniã, imisiritiko Teoso sãkire auikinina xika apokiniã, iuasaaki itakanaparina Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","—Aua kãkiti aanaia auiniãtaã atoko inakani. Ninoa kenakotapitikari Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Txamari maerekaxiniretinoka itxana. Txineironoka inirekana, ininiã ikara misirienetana ninoa. Kaiãopokori inireẽkitina, Teoso manirekakiniti. Maerekaxiniretinoka ininina, txineiro, inireẽkitina pakini inako atoko itxa, ininiã !ixinikaikarina Teoso sãkire, ininiã kona iriuata. ");
INSERT INTO apuNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aua kãkiti kipatxi erekari auiniãtaã atoko inakani. Ninoa auikari Teoso sãkire. Iriuatana. Ãti iriuata poiãoka, trĩtakata. Ãti iriuata apiata, sesẽtakata. Ãti iriuata ito, seĩkata. ");
INSERT INTO apuNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Xesosi pimaãna ninoa: —Nanipa hĩtakari tirikapi? Kopiti ãkikani hĩtakatari? Amesa patapikani hĩtakatari? Konapitini. Hĩtakari itano imakinika iopinikini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iomaãtakori ãti õti oerekaãkako. Kipatakori oerekaãkako, kotxi nota imarotapitikari hĩkamakiti. ");
INSERT INTO apuNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kakenakokii, ininiã hĩkenakotariko nisãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Xesosi sãkirauatapanika: —Hĩtakaõtxikariko nisãkire. Imakinika hĩkenakotako. Erepaniko pikamakiti ãtimoni, kotxi pite kamakititxikana kamaãka pitemoni. Erepaniko, kotxi apiata ikamaãka pitemoni. ");
INSERT INTO apuNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Teoso sãkire auakiti, iua sãkire kĩpitakari, Teoso sikari apikomoni imaroretxi iuamoni. Txamari Teoso sãkire kenakotakari, isãkire makĩpitakati, imarore xapiti iuamoni auakari makatxakaãkako. ");
INSERT INTO apuNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Apikomoni Xesosi txari: —Teoso auĩtetxi ininiãua kiki takariki taãkari atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Itakarauata. Imaka ĩkanõka. Ãti iparĩka ikama pokamara. Iuasaaki itakare pitxakapeka. Kona iua imarotari otomorekini. ");
INSERT INTO apuNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Merepanika otomoreka. Iposo atoko opitxaka. Eereka opa aua. ");
INSERT INTO apuNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Oaneẽpeka onakasaaki katakareri makoapataro, kotxi oamiko manapipeka itxa. Ikara atoko itxa Teoso auĩtetxi ininiãua. ");
INSERT INTO apuNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Xesosi sãkirauatapanika. Itxari: —Natokopa itxa Teoso auĩtetxi ininiãua? Ĩkiripa sãpirenatxi atão inakari oerekiko oerekaua? Ia atoko itxa: ");
INSERT INTO apuNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Teoso auĩtetxi ininiãua mostata oki atoko itxa. Axapitikiro oa. Apanakini iki apiata. ");
INSERT INTO apuNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Otakaãka atoko opitxaka. Eereka oaneẽ. Apanakini takari ĩtano apiata oa. Amaripokoro okati. Kotipiriki takari okoa okatiã. Iua atokotxikana Teoso auĩtetxi ininiãtaãua. Merepanika poião kãkiti. Eereka apiata. Eereka kaiãopokori kãkiti auĩtetari Teoso. Txamari iuasaaki Satanasi apoka ninoamoni kotipiriki apokini atokokana. ");
INSERT INTO apuNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kaiãopokori sãpirenatxi atão inakari oerekiko isãpiretana, Teoso sãkire imarotinina ĩkapani. Ninoa imarotakasaakiri isãkire, apiata isãpiretana. Imimarotakanisaakiri isãkire, poiãonoka isãpiretana. ");
INSERT INTO apuNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Teoso sãkire oerekasaakina ninoa, sãpirenatxi atão inakari oerekikonoka isãpireta. Eereka imoianariakorinoka auakasaaki iuakata, oerekana ikara imarotinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iua õtipanika mapiãnikata itxana imoianariakori: —Maĩpiriãta ipoa. Ipiniãmoni masa —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ininiã itakanapana itomaneri kãkiti. Iuasaaki imoianariakori anikari Xesosi kanauaã. Apanakini kanaua axapitiri apaka sari ninoakata. ");
INSERT INTO apuNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ĩpiriãtakasaakina ĩtima kataparari apoka ninoamoni. Tsakati kataparari, ininiã ãparaã ierepeẽpokataua kanaua ãki. Kanaua sakikaariãpotape. ");
INSERT INTO apuNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iuasaaki Xesosi ikapokiãmoni imakanãta. Isirimata nopini imakanãta. Ninoa õpirĩkari iua: —Kona pimaãkataua ate. Kona pitiretataua? Apinanapanoka —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ininiã imereka. Ipinitari ĩtima: —Piotoka. Auapika pitxako —itxari ipoa. Ininiã itsorĩkaxitita. Ĩtima iotoka. Tsakati iotoka apaka. ");
INSERT INTO apuNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ininiã Xesosi: —Natokopa ininiãpa kapĩkarei hĩte? Kinirepa hĩte kona auikano nota? —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Apiapĩkareta ninoa. Ininiã ninoa: —Kinakaripa ia kiki, kotxi ĩtima, tsakati pakini auikari iua sãkire —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Xesosi imoianariakorikata apoka ãtiãtaã Xerasa tõpa, Kariréia poa ipiniã. ");
INSERT INTO apuNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Xesosi kanĩkiĩtakasaaki, kiki ina iuamoni. Iua akauariãtaã auakari. ");
INSERT INTO apuNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Iuaãtaã iua auanãta. Kãkiti !iposotari iĩtxikiniri iua. Iĩtxikare metao kamakori karakitapekata. ");
INSERT INTO apuNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kaiãokatani kãkiti ĩtxikari iuako, ikiti pakini metaoã, txamari ikakarakitsatari metao. !Apakata kãkiti nĩkatiniri iua. ");
INSERT INTO apuNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ĩkanõka, pokamara pakini ixirataãtaã akiripoanãta akauari auiniãtaã. Kai soroã iuaka ikisauakitataua. ");
INSERT INTO apuNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Õtakopanika atapari Xesosi inini. Ininiã imiteẽkata iuamoni. Ikapotoreẽkaua iua apisatoõ. —Apiananiri pitxaua —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Akiripoakata: —Xesosi, Teoso ãkiri pitxaua. Apiananiri ãkiri pitxaua. Kipa pinireka nota ĩkapani? Teoso uãkaã namanaãi pite, kona pimisiritapeno —itxa maerekati matamatakoti. ");
INSERT INTO apuNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ikara atoko itxa kotxi Xesosi paniãtari: —Maerekati matamatakoti pisipeka. Pitakanapari ere kiki —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Xesosi pimaãri: —Kipa piuãka? —itxari. Iua apakapapiretari: —“Itori” ninaãka niuãka. Kotxi itori maerekani matamatakoni ate. ");
INSERT INTO apuNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Iteene iua amanaaãpotari Xesosi: —Kona piokanatapeua ãtiãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Iuasaaki auari kaiãopokori irari ixiratamoni nipokonãtakani. ");
INSERT INTO apuNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Maerekati matamatakoni iteene amanaãri Xesosi: —Piokanataua ate irarimoni. Pauiritaua ate sini ninoamoni —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ininiã Xesosi iokanatana. Iuasaakipeka maerekani matamatakoni takanapari iua kiki, ĩroã itxana irari ĩtomoni. Iuaãtaã auari ipi mio irari. Ninoa ĩroãkasaaki, irari miteẽkata oiokiriĩtini ipoamoni. Komoka, axãpoãta itxana iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Irari nĩkatakani miteka sitatximoni, aapokotxi poião auinimoni pakini. Isãpiretana kãkiti itikakitina. ");
INSERT INTO apuNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Eereka isana Xesosimoni. Iuasaaki atamatarina kiki mitxi maerekati auaĩtotakiti. Iitopãkanãta. Mãkatxi auapekari. Atão iĩkitapeka auari. Iuaritika ninoa pĩkarauata. ");
INSERT INTO apuNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Itikakani sãpiretari apanakini iua kiki pirena, irari pirena pakini. ");
INSERT INTO apuNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kãkiti iuaãtaã auakani paniãtari Xesosi osipikiniri iuaãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Xesosi iereẽtakasaakiua kanaua ãki, iua kiki amanaãri iuakata isini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Xesosi !auiritari. Itxari: —Pisa pinirimanemoni. Pisãpiretana Apiananiri kamakiti pite ĩkapani. Pisãpiretana iua iteene iamonĩkai pite. ");
INSERT INTO apuNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ininiã iua sipe. Iuaãtaã auari sitatxi tesi pakini. Iua kiki sari ninoa tesi sitatxitimoni. Isãpiretari kãkiti Xesosi kamakiti iua ĩkapani. Iuaãtaã auakani tsorĩkaãta: —Anekani, peerekari Teoso —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ininiã eereka Xesosi ĩpiriãta ipoa. Ininiã ipoa ĩtiniã kaiãopokori kãkiti apotiitaua iuakata. ");
INSERT INTO apuNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aiko Xoteo apotiitiniãtaãua sikani auĩte apoka iuamoni. Akiritaãka Xáiro iua. Iua kapotoreẽkaua Xesosi apisatoõ. ");
INSERT INTO apuNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Iua iteene amanaãri Xesosi: —Namarite opinanapanoka. Masa notakata. Pitakari piuako oa nopini erekape onini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ininiã Xesosi sari iuakata. Kãkiti kinapokope itxakata isinina. ");
INSERT INTO apuNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Iuasaaki sito amianatakaro apoka. Tosikanani oa arẽka !iotoka. ");
INSERT INTO apuNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Okinika otxineiroteẽ oĩkitxitapekari oamianare imarotakani. Kaiãopokori ipitamaro. Txamari ninoa !iposotari imakatxakinirina oamianare. Kona erekaro. Apiata oamianare. ");
INSERT INTO apuNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Okenakoenetakasaakiri Xesosi napini, osari iuamoni. Omaãtakari imãka, ");
INSERT INTO apuNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kotxi oamoni: “Nimaãtakiniãri imãka, iuasaakiika erekapekano,” otxanãta oxinikakiti. ");
INSERT INTO apuNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ininiã omaãtakasaakiri, oarẽka iotoka. Iuasaakipeka oimarotari erekape onini. ");
INSERT INTO apuNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Iuasaakiika Xesosi posotiire sari oamoni. Ininiã ikirioka kãkiti sauaki. Eereka ipimaãna: —Kipa maãtakatari nimãka? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Iuasaaki imoianariakori apakapapiretari: —Apiananiri, patamata. Itomaneri kãkiti kinapokopeka, iuaritika pite pimaãri kãkiti: “Kipa maãtakatano?” pitxa —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iuaritika Xesosi nitari imãka maãtakakari. ");
INSERT INTO apuNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Iuasaaki oa sito imarotari erekape onini, ininiã okapotoreẽkaua iuamoni. Opĩkarauata. Okikinanaka. Eereka osãpiretari ikinika oamianare iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ininiã Xesosi txaro: —Namarite, pite erekapekai uatxa, kotxi pauikari niposotiire. Pisipiniikaua, erekaxinirepekai —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Xesosi sãkirauatakasaaki oakata, apanakini Xáiro nitiriakori apoka. Itxari: —Pamarite !auaika. Opĩpeka. Pauiritari Xesosi kanapiriini. ");
INSERT INTO apuNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ininiã Xesosi !imaãkatari ikara pirena. Itxari Xáiro: —Kona pipĩkarauatape. Pauikano —itxari. Ininiã ninoa sari Xáiro aapokomoni. ");
INSERT INTO apuNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Xesosi auiritana Petro, Txiako, Txiako itari Xoão pakini sini iuakata. !Auiritana apanakini sini iuakata. ");
INSERT INTO apuNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ninoa apokasaaki Xáiro aapoko, kãkiti iuaãtaã auakani !imarotarina ikamakitina. Ikinipoko kãkiti txiapanãta, akiripoakanãtana. ");
INSERT INTO apuNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Xesosi ĩroã. Itxana: —Kinirepa iteene hĩtxiapanãta? Kinirepa hãkiripoanãta? Amarini !ipina. Oimakanãta —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ininiã inapetarina iua. Ininiã iokanatana ninoa mapara. Oĩri, onoro, Xesosi moianariakori pakini ĩroã amarini auiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Imaĩkaro ouako. Iuasaaki isãpiretaro oa isãkireẽ: —Taritaa komii. Popĩkari sãkireẽ: “Amarini põkitikaua.” ");
INSERT INTO apuNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Iuasaakipeka oõkitikaua. Otĩpokota. Oa amarini aua tosi anokanani. Iuasaaki ninoa iteene tsorĩkaãta. ");
INSERT INTO apuNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ininiã Xesosi paniãtana: —!Hĩsãpiretapiri apanakini nimakananitiniro oa. Apaka ipaniãtana isikakienatiniro oa. ");
INSERT INTO apuNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Xesosi imoianariakorikata potorika iuaã. Nasaree sitatxitimoni isana. Iuaãtaã mitxi Xesosi aneẽ. ");
INSERT INTO apuNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tomatiko õtisaaki iua oerekari kãkiti aiko Xoteo apotiitiniãtaãua. Xesosi sãkire kenakotakani tsorĩkaãta. Itxana: —Nanipa apaiaõkarauata, ikara atoko imarotini? Kipa oerekari imarore? Ikamakiti oerekari apiata imarore aua. Kininiãpa ĩkora atoko itxa posotiireta? ");
INSERT INTO apuNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ate imarotari iua, kotxi aapokotxi kamakari itxaua iua. Maria ãkiri iua. Iua itariakori Txiako, Xosee, Xota, Simão pakini itariakori itxauana. Itaroakoro apaka aua uai, ininiã ate imarotari iua —itxana. Ikara xika kona ninoa auikari isãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ininiã Xesosi txana ninoa: —Teoso sãkire sãpiretakari paxitaãka, txamari Teoso sãkire sãpiretakari itixineẽ auakasaaki, iuaã auakani, inirimane, iua aapoko ãki auakani pakini !ipaxitari. !Auikarina iua sãkire —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ininiã iuaã kona ikamari iposotiire apiari. Iuako itaka ãtikaka amianatakani nopini, ininiã amianatakani erekapeka itxĩkitaka. ");
INSERT INTO apuNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Itsorĩkaãta, kotxi iuaã auakani !auikari isãkire. Ininiã iua tõpa isari aapokotximoni. Oerekarauata iuaã. Eereka isari apanakini aapokotxitimoni. Iuaĩkana oerekarauata. Itxaãpota iuaãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Xesosi akiritana imoianariakori tosi pakini. Ipi iokanata ãtiãtaã, iuaĩkana ãtiãtaã iokanatana ipi. Ikara atoko iokanaãpotana imoianariakori. Iposotiire isikana ninoa maerekani matamatakoni omitikinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Itxana: —Kona minakati hanikape. Hĩtsonerenoka hanika. Kona hĩtii, kona auatxi, kona txineiro !hanikape. ");
INSERT INTO apuNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Hĩkiti mata hĩeretaka. Ãtika kasipiri himãka hanika. ");
INSERT INTO apuNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sitatxi hãpokasaaki, ãtika aapokotxinanirako hãua. Iua sitatxi hãuakasaaki, hĩkaikota iua kãkiti aapoko. Kona hãuape ãti kãkiti aapoko. ");
INSERT INTO apuNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kãkiti mapakapakanisaakii, hĩsãkire imakenakotakanisaakina, ininiã hĩtakanapana. Hĩpotorikasaaki, hĩkaxipokari kipatxi hĩkiti mataã auakari, ininiã ikara atoko hõerekana ninoa maerekani ininiuana. Kãkiti misiritiko sãpiretiko õti apokasaaki, Sotoma sitatxiti auakani misiritiko auapitika. Iuasaaki Komoha sitatxiti auakani misiritiko auapitika. Iuaritika sitatxi auakani hĩte mapakapakani misiritaãkako apiata iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ininiã isana. Isãpiretari kãkiti imaerekani itakanapini. ");
INSERT INTO apuNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mirikiniti maerekati matamatakoti iokanatana. Iĩtxiã itakana amianatakani nopini. Ininiã erekapeka itxĩkitakana amianatakani. ");
INSERT INTO apuNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Auĩtetxi Erotxi inakori kenakopiretari Xesosi pirena. Xesosi uãka iaripireta ikini tõpati. Ininiã Erotxi xinikanãta: —Ikara Xesosi, Xoão kapatxisareri itxaua. Uatxa iua õkitikapekaua. Iuakara Xesosi itxa. Ininiãkara iposotiire aua iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ãtikaka uãkatari Xesosi Eríasi ininiua. Ãtikaka uãkatari Xesosi Teoso sãkire sãpiretakari kitxakapirĩka ininiua. ");
INSERT INTO apuNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ikara Erotxi kenakopiretakasaaki, itxari: —Xoãokara nitsotakakiitakitikara iua Xesosi txa. Ipĩpekariika iuaĩkana õkitikapekaua —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mitxi Erotxi takaro itari Piripi ĩtanoro. Ouãka Erotxia inakoro. Oa xika Erotxi maĩkari Xoão. Iaxiriĩtotari, kateia ãki taka itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Xoão takaãka kateia ãki, kotxi itxari Erotximoni: —!Erekari pitari ĩtanoro pitakini —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ikara xika Erotxia apaka omanatari Xoão. Oa iteene kinirão okaka otxamari Xoão. Kona oposotari oõkiniri iua, ");
INSERT INTO apuNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kotxi Erotxi pĩkari Xoão. Iua imarotari, atão inakarinoka kamakari, erekarinoka kamakari ininiua Xoão. Xoão sãkire ikenakotakasaaki, !iteene !imarotari isãkire, iuaritika iua apokaerekatari ikenakotiniri isãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erotxi kamari isaiã kiiniriti. Iua kemaĩtxitana sotato auĩteakori, Kariréia auakani auĩteakori, apanakini auĩteakori pakini. ");
INSERT INTO apuNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ininiã Erotxia ãkero apoka iua kiiniritiã. Iuasaaki oserenapirĩkata Erotxi apisatoõ, ikemaĩtxitakini apisatoõ pakini. Ninoa potxitari oserenini. Ininiã Erotxi txaro oa ãtokoro: —Pinirekakiti pamanaãno, ininiã nisikai. ");
INSERT INTO apuNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Atãopitikara nisikai pamanaãkiti. Nitixine pinirekiniã, ipixini nisikai —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ininiã oa miteka onoromoni. Oa pimaã txaro onoro: —Kiripa namanaãtari? —otxaro. Ininiã onoro txaro: —“Xoão Kapatxisareri kii prato nopini ninireka,” pitxari. Ikara atoko pamanaãri iua —otxaro. ");
INSERT INTO apuNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ininiã katimariã okanapiriã kiiniri auiniãtaã iuaĩkana. Katimariã auĩtetximoni osa. Oamanaãri iua: —Ninirekari Xoão kapatxisareri kii prato nopini —otxa. ");
INSERT INTO apuNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ininiã Erotxi maerekaxiniretinoka itxa, kotxi mitxi iua sãpiretaro oa amanaãkiti isikiniro oa ikemaĩtxitakini apisatoõ. Ininiã !apakata imasikakaniãri isikaenetakiti. ");
INSERT INTO apuNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ininiã katimariã ipaniãtari sotatoakori okiniri Xoão: —Ikii himina —itxa. Ininiã isana kateiamoni. Itsotakakiitarina Xoão. ");
INSERT INTO apuNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pirato nopini itakarina ikii, sika itxarona ãtokoro. Ininiã oa sikari onoromoni. ");
INSERT INTO apuNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ininiã Xoão moianariakori kenakopiretakasaakiri Xoão okiko pirena, isana kateiamoni. Aparina iĩto. Itakarina iĩto kai iriko ãki. ");
INSERT INTO apuNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ininiã Xesosi iokanatakini kanapiriã iuamoni. Apoka itxana Xesosimoni. Isãpiretarina ikamakitina, oerekakitina pakini. ");
INSERT INTO apuNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iuasaaki kaiãopokori kãkiti aua iuaãtaã, ininiã !apakata inipokotinina. Ininiã: —Amasipeka kãkiti mauakaniãtaã atomatini ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ininiã kanauaã iereẽtauana. Ĩpiriãtarina ipoa. Isana kãkiti mauakaniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kãkiti itikari Xesosi inapaãpotini, ininiã ninoa miteka. Iopiriãrina ipoa koropoa, apoka itxana Xesosi apisapanika. ");
INSERT INTO apuNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iua kanĩkiĩtakasaaki apisamoni mirikiniti kãkiti, ininiã iamonĩkana, kotxi soti auĩte ipitikiri mauakiniti atoko itxana. Iuasaaki Xesosi oerekana kaiãori Teoso sãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ininiã mapiãpeka inaãpotiniã, Xesosi moianariakori iuamoni apoka. Itxarina: —Kona kãkiti aapoko auari uai. Uatxa mapiaãpopeka. ");
INSERT INTO apuNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ininiã pipaniãtana kãkiti isinina ĩkapani nipokori iamotinina tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ininiã Xesosi: —Hĩtekarako sikakienatana ninoa —itxana. Ininiã ninoa: —Pinirekatari asini komiri aamotini ĩkapani? Oito kasiriti kãkiti parĩkauatini ĩki anireka komiri ĩki naia kãkiti nikini ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ininiã Xesosi pimaãna ninoa: —Kipakinipa komiri katari aua? Hãtariko —itxa. Ninoa imarotakasaakiri, apoka iuamoni. Itxana: —Sĩko pakini komiri katari, ipi ximaki pakini aua —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Xesosi paniãtana ikinika kãkiti topãkini katsotati nopini. ");
INSERT INTO apuNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ãtiãtaã iitopãkana sĩkoẽta, ipinimoni iitopãkana seĩ. Imakinikana ikara atoko itxaãpotana iitopãkinina. ");
INSERT INTO apuNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ininiã Xesosi kosekari sĩko pakini komiri, ipi ximaki pakini. Iuasaaki ionakaãta iaxiti: —Erekapitikari pisikakiti —itxa. Eereka imaxiõpekari komiri. Isikari imoianariakori. Imoianariakoripekana sikaãpotana apanakini. Iuaĩkana imapirinikari ximaki, xanaka itxari imakinikana. ");
INSERT INTO apuNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ikinimanekana nipokota, kamitopeka itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ininiã imoianariakori apotiitari ximaki itetakori, komiri itetakori pakini. Tosi pakini kotari xãpoka itetakori. ");
INSERT INTO apuNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Iuasaaki sĩko mio kikiakori nipokotakani. ");
INSERT INTO apuNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Xesosi takapiretakasaakiri kãkiti, iuasaaki iokanatana imoianariakori ĩpiriãtinina iua apisa, Petsáita tixinimoni isinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Xesosi takapiretanapaka atoko, mitaxiratari nopini isa Teoso imisãkiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mapiãpe inakasaaki kanaua ipoa apanĩkakiãxitipeka aua. Iuasaaki Xesosi imiriĩpanika aua. ");
INSERT INTO apuNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Xesosi atamatana ninoa, itaparanoka itxana imekoãtinina, kotxi ĩtima, tsakati pakini anikaãpotana ninoa. Ininiã ikatimaãpotakasaaki, Xesosi apokaãpota ninoamoni. Itĩpokota ipoa nopini. Inapaãpoaritana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ininiã ninoa atapakasaakiri ipoa nopini itĩpokotini, ninoa uãkatari kamiri. Ininiã ninoa akiripoakata. ");
INSERT INTO apuNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ininiã iua misãkiretana: —Kataparaxinire hĩtxako. Notakara. Na !hĩpĩkarauatape —itxana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Eereka kanauaã iereẽtaua. Iuasaaki ĩtima iotoka itxa. Ininiã itikokitatana ninoa. Itsorĩkaãtana: —Kiripa atxiĩti? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ikara atoko isãkirena, kotxi kona ixinikaikarina Xesosi posotiire komiri ixanakasaaki. Paikoxinirena ninoa iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Xesosi imoianariakorikata ĩpiriãtari ipoa. Isari Xenesaree tixinimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ikanĩkiĩtakasaakina apanakini itikari Xesosi. —Xesosira —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ininiã imitekana kãkiti auinimoni amianatakani apinina ĩkapani. Anikana isirimatana nopini Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ikini sitatxiti kãkiti amianatakani sirĩka kimapori tiniãpo. Amanaãrina Xesosi auiritinina ninoa imãka itikakinina. Ikinikana imãka tikakakani erekapeka itxĩkitaka. ");
INSERT INTO apuNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ininiã pariseoakori, kaiõkatsopareriakori pakini, Xerosareẽ ĩkani, apotiitaua Xesosikata. ");
INSERT INTO apuNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Iuasaaki itikarina Xesosi moianariakori marokapiotakaniua nipokori inikinina apisa. Ininiã itxana: —!Erekari imarokapiotakaniuana —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pariseoakori, imakinikana Xoteoakori apaka kamari ikiomaneakori kitxakapirĩkarini sãkire iaõka. Inipokotinina apisapanika arokapiotauana. ");
INSERT INTO apuNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nipokori amotikoãtaã Xoteoakori sikasaaki, eereka apokasaakina aapokona imarokapiotakaniãuana kona inipokotana. Tiitxi iãkoanatxi, kopiti, apanakini itiina pakini arokasaakina ikiomaneakorini oerekakiti iaõka arokana. ");
INSERT INTO apuNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ininiã pariseoakori, kaiõkatsopareriakori pakini pimaãri Xesosi: —Kinirepa pimoianariakori kona kamatari kitxakapirĩka atoko ininina? Kinirepa marokapiotakanikaua inikarina nipokori? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ininiã Xesosi apakapapireta: —Mitxipitipanika Isaía sãpiretai hĩte. Atão iua sãkire, kotxi hĩsãkire atxiĩti erekari, txamari kona hĩkamari hĩsãkire iaõka. Iua txari: Kamisirienererini ninoa kãkiti. Ninoa sãkireẽnanira ipaxitanona. Ãkixinireẽna !inirekanona. ");
INSERT INTO apuNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Maxikatiĩka ninoa kapotoreẽkaua nota apisatoõ. Maxikatiĩka ninoa txano: “Ateosone pitxaua,” kotxi ninoa !oerekari nota sãkire. Ninoaka sãkire oerekana, txamari “Teoso sãkire asãpiretai” itxana. Ikara atoko Isaía iõkatsopatakiti Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","—Ininiã hĩtakanapapekari Teoso sãkire, kãkiti oereẽkiti hĩkamini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hĩtakanapapikari Teoso paniãtakiti, hinirekaãkiti hĩkamini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kitxakapirĩka Moisesi txari: Pipaxitariko piri. Pipaxitaroko pinoro. Piri, pinoro pimisãkirepiretiniã, pokaãkako, itxa Moisesi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Txamari hĩte oerekari kãkiti: “Kãkiti auakiti iri, inoro pakini nirekiniã, iua manirekakaniãri isikiniri ninoamoni, isãpiretana: ‘Ia nota auakiti nisika Teosomoni.’” Ininiã !isikari ninoa nirekakiti ninoamoni. Ikara atoko inakari kãkiti sikakiti Teosomoni, hĩte takauãkatari “Kopaã.” ");
INSERT INTO apuNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ininiãkara hõerekari kãkiti imatiretakanina iri, inoro pakini. !Apakata hõerekakiti. ");
INSERT INTO apuNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ikara hõerekakiti xika kona hĩte maãkatari Teoso sãkire. Apiata hinirekari kãkiti oereẽkiti. Auapanika itori hõereẽkiti sãkiretxiti ikara atoko inakari —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Xesosi iuaĩkana akiritana ikinimane kãkiti. Itxana: —Hĩkinika hĩkenakota. Hĩtakaõtxikariko nisãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Imakinika hinikakiti, mapara auakari. !Ikamari ate maerekani. Hĩxinireẽ potoriãkarira kamari maerekanitxi. ");
INSERT INTO apuNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kakenakokii, ininiã hĩkenakotariko nisãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ikinimane kãkiti itakanapaka atoko, aapokotxi ãki ĩroã. Iuasaaki imoianariakori pimaãri: —Pisãpiretaua mixikanani pisãpiretakiti —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ininiã iua txari: —!Kiĩkitei hĩte. Kona hĩte imarotatari hinamaã ĩroãkari kona kamari maerekanitxi. ");
INSERT INTO apuNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kotxi ĩroãkari !isari hĩxiniremoni. Hĩtikako ãki isa. Iposo atoko hĩtikatakasaaki inapa. Ikara atoko ininiã, erekari ikinipoko kãkiti niãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","—Ixinireẽ potoriãkari iuara kamari kãkiti maerekani. ");
INSERT INTO apuNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kãkiti ãkixinire ipotorika ixinikakiti maerekati, anokaretxi, ĩtiriuatakatxi, okaniuatakatxi, ãti kãkiti ĩtanorokata isirĩkini nire pakini. ");
INSERT INTO apuNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Kãkiti ãkixinireẽ ipotorika itirenani, maerekati Satanasi oerekakiti, misirieneretxi, pẽtauatakatxi kamakari, xikotakatxi, ãti misãkirepiretiko, iuikiniua, miĩkiteti inini pakini. ");
INSERT INTO apuNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ikinika ikara maerekati kãkiti ãkixinire auakari txikotari kãkiti xinire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xenesaree tixini Xesosi potorika. Txiro sitatxiti tõpa, Sitoõ tixini pakinimoni isa. Iuaã kãkiti aapoko ĩroã. Kona inirekari kãkiti imarotiniri iua auiniãtaã. Txamari !iposotari iomaãtiniua. Kãkiti imaroãpotari iua auiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sito apoka Xesosimoni, kotxi oa kenakopiretari Xesosi pirena. Maerekati matamatakoti auaĩtotaro oimi. Oãpokasaaki Xesosimoni, okapotoreẽkaua iua apisatoõ. ");
INSERT INTO apuNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Oa sito sãkiretari Kreko sãkire. Ãto uãka oa. Siropenísia tixinikero oa. Okapotoreẽkasaakiua Xesosi apisatoõ, oamanaãri Xesosi: —Pomitikenatariko maerekati matamatakoti namarite ĩtoã auakari —otxari. ");
INSERT INTO apuNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ininiã Xesosi: —Xoteo !pitxaua. Maparakerorai. Pite nirekakari nisikinii Xoteoakori nakiti. Amarini mitxi nikini atão. !Erekari nokiniri amarini kiena anãpamoni —itxaro oa. ");
INSERT INTO apuNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Oa apakapapireta: —Atãopitikara ikara atoko pitxa, kotxi nota maparakero, anãpa atoko Xoteoakorimoni. Iuaritika kãkiti auiritari anãpapiki nikiniri nipokori katxakakari amarini nipokotiniãtaã patapi —otxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ininiã Xesosi apakapapireta: —Erekari papakapapiretini, ininiã paapokomoni pisa. Maerekati matamatakoti !auaika pamarite ĩtoã —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Oaãpoko oãpokasaaki, oãpokaro oamarite sirĩkanãta. Erekapekaro oa. Maerekati matamatakoti asikapekaro. ");
INSERT INTO apuNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Eereka Xesosi takanapari Txiro sitatxiti tõpa. Ĩpirixititari Sitoõ tixini. Sitatxi tõpa tesi pakini ĩpirixitita. Apoka Kariréia poamoni. ");
INSERT INTO apuNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ãtikaka kãkiti minari makenakoreti Xesosimoni. !Iposota atão isãkirauatini. Ninoa iteene amanaãri Xesosi: —Piuako pitaka iua nopini kakenakorepeka inini ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Xesosi anikari iua kiki kãkiti mauakaniãtaã. Itakari iuakoki ikĩpita ãki. Eereka ikiisoka, taka itxari ienemaã masãkireti nini nopini. ");
INSERT INTO apuNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Eereka ionakaãta iaxiti, oõka itxa: —Epataa —itxa. Popĩkari sãkireẽ, “Piauãka.” ");
INSERT INTO apuNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iuasaakipeka ikenakoki auãka, ininiã kakenakorepeka itxa. Iuasaaki inini poiõpeka apaka. Eereka erekapeka itxa isãkirauatini. ");
INSERT INTO apuNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ininiã Xesosi txana ninoa: —Kona hĩsãpiretapiri apanakini nimakananitiniri iua. Txamari apiata ninoa sãpirenauata. ");
INSERT INTO apuNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kãkiti tsorĩkaãta: —Ikinika ikamakiti peerekari. Makenakoreti kakenakorepeka itxa. Mimatasãkiretakati, kasãkirepeka itxa —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Eereka mapaõti itomaneri kãkiti apotiitaua Xesosimoni. Nipokori xipokapeka, ininiã Xesosi akiritana imoianariakori. Itxana ninoa: ");
INSERT INTO apuNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nota amonĩkana naia kãkiti, kotxi ipi õti, ãti õti pakini õtipeka auana notakata. Ininiã uatxa nipokori !auaika. ");
INSERT INTO apuNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Niokanatiniãna auinimoni manipokotakatipanikana, ininiã ipixiniãpo iõkapetana. Irikana. Ãtikaka õtako ĩkani kona apakata manipokotakanika isinina —Xesosi txana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Imoianariakori apakapapireta: —Uai aapokotxi mauakaniãtaã, ininiãkara nãpa aãpokari nipokori ito naia kãkiti asikakienatini ĩkapani? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ininiã Xesosi: —Kipakinipa komiri katari hĩtemoni aua? —Setxinokara komiri aua atemoni —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ipaniãtari kãkiti topãkini ixiti. Imaĩkari iua komiri setxi. —Erekari pisiãkiti —itxari Teoso. Iposo atoko imaxiõpekari komiri, sika itxana imoianariakori. Imoianariakori sika itxana apanakinimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ninoamoni aua ãtikaka ximaki axapitiri. Ininiã Xesosi txari: —Ia erekari —itxa Teosomoni. Eereka ipaniãtana imoianariakori sikiniri kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ininiã ikinipoko kamitopeka itxana. Iposo atoko apotiita itxarina itetakori. Xãpokaka itxarina setxi kotarina. ");
INSERT INTO apuNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ninoa komiri nikakani ipi ipi pakini mio kãkiti. Kamitopeka itxana. Ininiã itakapiretanapana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Iposo atoko imoianariakorikata iereẽtaua kanaua ãki. Taomanota tõpamoni isana. ");
INSERT INTO apuNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pariseoakori apoka Xesosimoni. Inirekarina Xesosi kerokiniri, ininiã itxarina Xesosi: —Takaõtxikari, Teoso posotiire poerekaua ate, aãtamatiniri ĩkapani, Teoso iokanatinii ĩkorapokoriti aimarotini ĩkapani —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ininiã Xesosi oõka. Itxari: —Kinirepa kãkiti uatxarini nirekari noerekiniri Teoso takaõtxikare, iposotiire? Atãopitikara nota txai hĩte, kona noerekai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ininiã itakanapana. Iereẽtaua kanaua ãki. Ikanapiriã ipoa ipiniãmoni iuaĩkana. ");
INSERT INTO apuNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Xesosi moianariakori maxinĩkaretari pão. Ãtika pão poriĩ kanaua ãki aua. ");
INSERT INTO apuNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ininiã Xesosi õtãkikana: —Erepaniko, pamonõkoniri pariseoakori, Erotxi pakini pãote tireẽkari —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Xesosi moianariakori misãkiretakakaua: —Ikara atoko itxaua, kotxi amaxinĩkaretari pão. ");
INSERT INTO apuNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Xesosi imarotari ninoa sãkire, ininiã itxana: —Kinirepa hĩsãkirauanãta pão mauakani xika? Kona himarotatapanikari niposotiire? Kona hiĩkitetapanikari? Kona hinirekatari hãuikiniri nisãkire? ");
INSERT INTO apuNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kokimai, txamari, !hãtamatari. Kakenakokimai, txamari !hĩkenakotari nisãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kona hĩxinikapanikari iuasaaki nimaxiõpekitakiti sĩko komiri, sĩko mio kãkiti nisikakienatini? Kipakinipa kotari itetakori hĩxãpokaka? —ipimaãna. Ininiã ninoa apakapapireta: —Tosi kotari axãpokaka. ");
INSERT INTO apuNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Xesosi txana ninoa: —Eereka ãti õti nimaxiõpekari setxi komiri poriĩ. Nisikari ipi ipi pakini mio kãkiti. Itetakori hãpotiitakiti, kipakinipa kotari hĩxãpokaka? —ipimaãna. Ininiã ninoa: —Setxi kotari axãpokaka. ");
INSERT INTO apuNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ininiã Xesosi: —Ininiã kinirepa kona hiĩkitetapanikari? ");
INSERT INTO apuNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Xesosi Petsáita aapokotxitimoni apoka. Iuasaaki kãkiti minari mõsiãreti iuamoni. Amanaãrina Xesosi maãtakiniri iua mõsiãreti. ");
INSERT INTO apuNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ininiã iua anikaãpotari iuakoã kãkiti mauakanimoni. Iuaã iminapari ienemaã mõsiãreti okiã. Eereka taka itxari iuako iĩtoã. Ipimaãri iua: —Kõsiãrepekai? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ininiã iua atamata. —Nota itikapokotapeka, txamari nitikari kãkiti tĩpokotakari aamina atoko —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iposo atoko Xesosi iuaĩkana takari iuako mõsiãreti nopini. Eereka mõsiãreti atão itikapokotapeka. Ikinipoko atamata. ");
INSERT INTO apuNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ininiã Xesosi iokanatari: —Pisipeka paapokomoni. Kona pisipe Petsáita aapokotxitimoni, kotxi kona ninirekari pisãpiretiniri nikamakiti kãkitimoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Eereka Xesosi imoianariakorikata sari kãkiti poiãoka auinimoni, Sesaréia-Piripi sitatxiti takote isana. Ipixiniãpo Xesosi pimaãna imoianariakori: —Kiripa kãkiti uãkatano nota? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ninoa apakapapireta: —Xoão kapatxisareri iuãkataina. Apanakini “Eríasi inakori” iuãkataina. Ininiã apanakini “Teoso sãkire sãpiretakari” iuãkataina —itxana Xesosi moianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iuaĩkana Xesosi pimaãna: —Hĩtepekana, kipa hĩte uãkatano? —itxana. Ininiã Petro apakapapiretari: —Teoso mereẽkiti, kãkiti iãtapanãtakiti pitxaua —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ininiã Xesosi txana imoianariakori: —Teoso mereẽkiti nininiua !hĩsãpiretapiri apanakini —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ininiã ia atoko oerekarauata: —Nota hĩtari iaxitikiri iteene atatsiirauatako. Kiomãtxiakori, sasetotxi auĩteakori, kaiõkatsoparerini pakini kona nirekapanino nota. Nokaãkako. Eereka ipi ãti pakini õtisaaki iuaĩkana nõkitikauako. ");
INSERT INTO apuNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ikara isãpireta ikinimane kãkitimoni. Ininiã Petro anikari iua maparamoni. Itxari: —Kona ikara atoko !pitxape. Kona erekari pisãkire ikara atoko pinini —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ininiã Xesosi kirioka imoianariakorimoni. Iua txitari Petro: —Pisipiniikaua Satanasi. Pite nireẽkiti kãkiti nireẽkiti atokotxikana. Pite nireẽkiti kona Teoso nireẽkiti atokoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Xesosi akiritana kãkiti imoianariakori apaka. Itxana ninoa: —Notakata kinirão sika pinakasaaki, piteka pinireẽkiti kona pixinikape. Notakata kinirão sika pinakasaaki, nota misiritiko atokokana pimisiritaãkako. Ia atoko pinirekiniã, notakata pisapitikako. ");
INSERT INTO apuNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pite ãtipirika kaminiãri piteka nireẽkitinoka, ininiã pinireẽkiti xipokapitikako pitekata. Pite nireẽkiti xipokiniã, nota sãkire pauikini xika, Teoso iokanapirena erekari pisãpiretini xika, pite auapininiika txako Teosokata. ");
INSERT INTO apuNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Atxiĩti papakapari ikinipoko tiitxi, ikini itixiti auakani tii, pinakiti ĩkapani. Atxiĩti iua tiitxi xika kona pikĩpitari Teoso sãkire, ininiã kona pikaikota ãtipirika Teosokata. Ikara atoko ininiã, erekari atxiĩti ikinipoko tiitxi auinii? Konapitini. Apiaerekata Teosokata ãtipirika pikaikotini, kotxi tiitxi ĩki poiãoka, pixinire karone apiata. ");
INSERT INTO apuNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","!Apakata kãkiti iĩkitxitiniri Teoso, iuamoni isini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ĩkorasaaki kãkiti !inirekari Teoso. Inirekari maerekatinoka. Ĩkorasaaki pipẽtatiniãno nota, pipẽtatiniãri nota sãkire, ininiãkara nota kãkiti itari iaxitikirino pẽtataiko pite, uai nikanapiriãkasaaki. Nikanapiriãkasaaki, niri iotximere aua notamoni. Nina niri nitiriakorikata, erekarinikata. ");
INSERT INTO apuNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Xesosi txana ninoa: —Hĩxinikariko ia nisãkire. Apanakini hĩte uatxa uai auakanii, hĩpinini apisapanika himarotari Teoso auĩtetxi ininiãua. Auĩtetxi kaposotiireri itxaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seisi pakini õti napaka atoko Xesosi anikana Petro, Txiako, Xoão pakini oxiratarimoni, mitaxiratarimoni. Iuasaaki ninoanani aua iuaã. Iuaã auakasaakina, Xesosi ĩto ipinipo itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Imãka kasarori itxaua. Iotximere apaka auari. Ikara imãka saro atoko inakari, !auari. Kãkiti iteene arokiniãri mãkatxi, iuaritika ikara isaro atoko !auari. ");
INSERT INTO apuNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iuasaaki Eríasi, Moisesi pakini tokiã iuaã. Isãkirauatana Xesosikata. ");
INSERT INTO apuNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ininiã Petro txari Xesosi: —Koerekareri, erekapitikari uai aãuini. Makamari papiri ipi ãti pakini, pite ĩkapani, Moisesi ĩkapani, Eríasi ĩkapani —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ikara atoko itxa Petro, kotxi !imarotaikari isãkire, iteene ipĩkarauatiniã. ");
INSERT INTO apuNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Iuasaaki katxiãri apoka ninoamoni. Katxiãri ãki auana. Katxiãri ãki Teoso txari: —Ere namarite, nitiretakiti. Hĩkenakotariko iua sãkire —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Katimaritika Xesosi moianariakori sapotorika. Itikapokotana. Mitxi Xesosikata sãkirauatakani !auaika iuaã. Xesosinokara kaikota ninoakata. ");
INSERT INTO apuNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Õtanoxiratari iokiriiãpotakasaakina, Xesosi txana: —Mixikanani hĩtikakiti !hĩsãpiretapiri apanakini. Nota hĩtari iaxitikiri nipinaka atoko iuaĩkana nõkitikaãkaua atokoikarako, hĩsãpiretariko mixikanani hĩtikakiti —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ininiã !isãpiretarina apanakinimoni. Ninoanoka isãkirauanãtana: —Natokopa itxa kãkiti ipĩkaripeka iuaĩkana õkitikiniãua —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ipimaãrina Xesosi: —Kinirepa kaiõkatsoparerini sãkire: “Teoso mereẽkiti apokini apisapanikarako Eríasi apokako.” Kinirepa ikara atoko itxana? ");
INSERT INTO apuNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ininiã Xesosi: —Inipitikara Eríasi apoka merepanika, kãkiti iposope inini ĩkapani. Teoso sãkire iõkatsopatakori txari: “Kãkiti itari iaxitikiri iteene atatsiirauatako. !Inirekaãkako.” Kinirepa ikara atoko itxa Teoso sãkire iõkatsopatakori? ");
INSERT INTO apuNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nisãpiretaiko Eríasi apokapeka. Kãkiti misiritapekari iuani. Inireẽka iaõka imisiritarina. Teoso sãkire iõkatsopatakori sãpiretapekari ikara ene —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ninoa apokaãpotakasaaki apanakini imoianariakorimoni, atamatana kãkitipokoni. Ninoa ãkitana Xesosi moianariakori. Iuasaaki kaiõkatsoparerini kãkitikata itaparakienetakakaua. ");
INSERT INTO apuNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Iuasaaki kãkiti atapari Xesosi. Ipoxokoniritikana itxana: —Xesosi napani. Ininiã imitekana iuamoni, okapireta itxarina: —Piteni? ");
INSERT INTO apuNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ininiã Xesosi: —Ari, notara. Ipimaãna: —Kininiãpa hĩtxitakakaua? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ininiã kiki kãkiti sauaki auakari apakapapiretari: —Nota minamari namarite pitemoni. Maerekati matamatakoti auaĩtotari iua. !Auiritari namarite sãkirauatini. ");
INSERT INTO apuNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Iua maĩkasaakiri, okaĩtotari iua xiti. Iuasaaki namarite sorikipeta. Akatsakatsiriĩtaua. Itorõkaĩtota. Ininiã nimisãkiretamana pimoianariakori omitikiniri maerekati matamatakoti, txamari ninoa !iposotari. ");
INSERT INTO apuNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Xesosi txari: —!Kauikarei hĩte. Maerekati kamakanii hĩte. Kipakinikananipa Teoso nirekatari hĩtekata nauini? Kipakinikananipa Teoso nirekatari hĩte nimĩteenekini? Himinari amarini notamoni —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ininiã ninoa anikari iua amarini Xesosimoni. Iuasaakipeka maerekati matamatakoti atamatari Xesosi. Iuasaakipeka maerekati matamatakoti txĩkitakari amarini okaratiniua. Ininiã iua amarini iriãkata. Ikanapirikata, isorikipekata, itxĩkitakari amarini. ");
INSERT INTO apuNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Xesosi pimaãri iri: —Kirisaakipa ipotorika ĩkora atoko inini? —Axapitipanikara ipotorika ĩkora atoko inini. ");
INSERT INTO apuNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Itokata maerekati matamatakoti okaĩtotari xaminamoni. Itokata okaĩtotari kãuaãrimoni. Inirekari okiniri iua. Piposotiniãri, pomitikariko maerekati matamatakoti. Piamonĩkauako atepaniko —itxa iri sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ininiã Xesosi: —Nota posotatari? Teoso sãkire auiãkari posotari ikaminiri ikinika —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Iuasaaki iua kiki apakapapiretari iãtsaritika: —Nauikapitikari piposotiire. Axapitikinoka !nauikari, ininiã pisikaposotiiretano iteene pisãkire nauikini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Isãkirauanãtakasaakina, kãkitipokoni miteẽkata ninoamoni Xesosi kamakiti imarotinina ĩkapani. Ininiã Xesosi itapararitika txitari maerekati matamatakoti: —Pite maerekati matamatakoti. Pitxĩkitakari kãkiti masãkireti inini. Pitxĩkitakari kãkiti makenakokiti inini. Nota omitikai pite. Pipokĩka. Iuaĩkana !piĩroãpinikako iua ĩtoã —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Iua maerekati matamatakoti akiripoakata. Okaraĩtokatari atoko, sipe itxa. Iua amarini ipĩkari ĩto atokopeka itxa. Ininiã apanakini kãkiti: —Ipĩpeka —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ininiã Xesosi maĩkauakotari. Õkitikari iua, ininiã itima. ");
INSERT INTO apuNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Xesosi aapokotxi ãki auakasaaki, iuanoka inakasaaki, imoianariakori pimaãri: —Natokopa ininiãpa kona ate posotatari maerekati matamatakoti aomitikini? —itxana iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ininiã Xesosi: —Teoso pimisãkiretakasaaki, iuasaaki pimanipokotakaniãra, iuasaaki piposotari ikara atoko inakari maerekati matamatakoti pomitikini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iuaã ipotorikana. Ĩpirixititarina Kariréia tõpa. Xesosi !inirekari apanakini kenakoenetiniri iua auiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kotxi inirekari oerekinina imoianariakorinoka ipinini pirena. Ininiã Xesosi: —Nota hĩtari iaxitikiri mĩkapiritaãkako. Nisikaãkako kikiakorimoni inirekaãkitina ikaminina tĩkane. Ninoa okano nota. Ipi õti ãti õti inakasaaki iuaĩkana nõkitikauako —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ninoa !imarotari Xesosi sãkire. Ninoa pĩkari ipimainirina iua. ");
INSERT INTO apuNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapanaoõ sitatxiti apokana. Aapokotxi ãki auakasaakina, Xesosi pimaãna ninoa: —Natokopa itxa hĩsãkire, uaimoni aĩkasaaki hĩtaparakienatakakasaakiua? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Masãkirenika itxana, kotxi kimaporiãpo ninoa sãkire: “Ĩkiripa ate apiatakari?” itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Xesosi, iitopãka atoko, akirita itxana imoianariakori tosi pakini. —Hĩkinika uaimoni hiĩtopãka. Apiatakari pininiãua pinirekiniã, piteka poiãotakaua. Ikinimane nitiri pitxauako. ");
INSERT INTO apuNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Xesosi kosekari amarini, mina itxari imoianariakori sauaki, katarata itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Papakapiniãri amarini pipoxokoniritika, papakapano nota apaka. Papakapiniãno nota, na notananini papakapa. Iuasaaki papakapari iua uaimoni niokanatakiri —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Xoão sãpiretari Xesosi: —Koerekareri, ate kenakotari kiki omitikinina maerekani matamatakoni pite uãkaã. Kona pimoianarini iua. Ininiã ate: “Ikara atoko !pitxape,” atxari. ");
INSERT INTO apuNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ininiã Xesosi: —!Hĩotokakapiri ikara ikamini. Kãkiti nota uãkaã maerekati matamatakoti omitiãkari, kona imisãkirepiretano. ");
INSERT INTO apuNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iua ate mokaiakari minakatiua. Atiretakiri itxaua. ");
INSERT INTO apuNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nota atãopitikara nitxai hĩte. Atxiĩti kãkiti sikai ãparaã, kotxi Teoso mereẽkiti nakiti pitxaua. Iua kamakiti erekari, ininiã apakapapitikariko ikamakiti ĩki. ");
INSERT INTO apuNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","!Erekari kãkiti mitari oerekiniãri amarini nota sãkire auiãkari maerekati ikamini. !Erekari. Erekamariko kai mitari iaxirikaãkamako iua kãkiti mitari nokiã, eereka okaãkamako ipoamoni ipinini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Piuako maerekati ikamãkitakiniãi, pitsotakari. Erekamariko ãtinani piuako Teosokata ãtipirika pauini ĩkapani, kotxi maerekati pikaminiã, pisa maerekani misiritikoãtaã. Iuaã xamina tirinapika. !Oakaãka. Atxiĩti piuako ipi aua, txamari pite sari iuaãtaã. !Erekari. ");
INSERT INTO apuNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Iuaã kĩtxi piĩtoã auakaro !opina. Xamina !oakaãka. ");
INSERT INTO apuNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Pikiti maerekati ikamãkitakiniãi, pitsotakari. Erekamariko ãtinani pikiti Teosokata ãtipirika pauini ĩkapani, kotxi maerekati pikaminiã, pisa maerekani misiritikoãtaã. Iuaã xamina tirinapika. !Oakaãka. Atxiĩti pikiti ipi aua, txamari pite sari iuaã. !Erekari. ");
INSERT INTO apuNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Iuaã kĩtxi piĩtoã auakaro !opina. Xamina !oakaãka. ");
INSERT INTO apuNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Poki maerekati ikamãkitakiniãi, pimakatxakari. Erekamariko ãtinoka poki auini Teoso auĩtetxi ininiãtaãua pisini ĩkapani, kotxi maerekati pikaminiã pisa maerekani misiritikoãtaã. Iuaã xamina tirinapika. !Oakaãka. Atxiĩti poki ipi aua, txamari pite sari iuaã. !Erekari. ");
INSERT INTO apuNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Iuaã kĩtxi piĩtoã auakaro !opina. Xamina !oakaãka. ");
INSERT INTO apuNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Iõkira nipokorimoni takiko atokokana xamina tirinakari takaãkako ikinimane kãkitimoni. Ikara atokokana ikinimane ataerekataãkako. ");
INSERT INTO apuNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Iõkira erekaro. Txamari iõkira koketikosaaki kipatxikata, !erekaikaro. !Apakata xinitxi piõkiratini ĩkapani. Atão iõkira atoko hĩtxako. !Hĩtxitakakapeua. ");
INSERT INTO apuNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Xesosi potorika iuaã. Xotéia tõpa isa. Ĩpiriãkitari Xotão kãuaãriti. Iuaĩkana kãkiti apotiitaua iuamoni. Kaiãopokori kãkiti, ininiã oerekarauata, mitxi oerekarauanãtini atokokana. ");
INSERT INTO apuNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kikiakori, pariseo inakaniua, apoka Xesosimoni. Ninoa nirekari Xesosi kerokiniri isãkire, ininiã ipimaãrina: —Atãokani erekari kiki takanapiniro ĩtanoro? ");
INSERT INTO apuNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ininiã Xesosi: —Kiatokopa itxa Moisesi paniãtakiti? ");
INSERT INTO apuNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ininiã ninoa: —Moisesi paniãtari kiki iõkatsopatiniri aãtsopa, ĩtanoro itakanapini aãtsopate, ininiã eereka auiritari iua iokanatiniro oa —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ininiã Xesosi: —Moisesi auiritai hĩtanoro hĩtakanapini, kotxi paikori hĩxinire. Teoso nireẽkiti himanirekakani xikara, Moisesi auiritai hĩtanoro hĩtakanapini. ");
INSERT INTO apuNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kotxi merepitipanika Teoso ikinipoko ikamakasaaki, ikamari kiki, sito pakini. ");
INSERT INTO apuNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ikara atoko ininiãpitikara, kiki takanapari iri, inoro pakini, ĩtanorokata auini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ininiã ãtika atoko itxauana. Ininiã ipi kãkiti !itxaikauana. Ãtinokara itxapekauana. ");
INSERT INTO apuNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ikara atoko ininiã, !erekari kãkiti kaiarikiniri Teoso apotiitakini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Eereka Xesosi imoianariakorikata kanapiriã aapokomonina. Iuaã apokasaakina, imoianariakori pimaãri iua ikara sãkiretxiti iuaĩkana oerekinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ininiã isãpiretana: —Kiki ĩtanoro takanapakari, ãto sito itaka inakari, maerekati ikaminaro ĩtanoro. ");
INSERT INTO apuNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Iua atokokana sito õtaniri takanapakaro, ãti õtanirita inakaro maerekati okaminiri õtaniri —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iposo atoko ãtikaka kãkiti anikari amarini Xesosimoni. Inirekarina Xesosi misãkiretiniri Teoso ninoa amarini ĩkapani. Txamari imoianariakori txitana. !Auiritana amarini anikinina Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Xesosi ikara ikenakotakasaaki, !apokaerekatari. Ininiã iua: —Hãuiritariko amarini notamoni apokini. !Hĩotokakapiri, kotxi kãkiti Teoso auĩtetakani amarini atoko itxauana. ");
INSERT INTO apuNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ia atão: Kãkiti mapakapakaniãri Teoso, amarini apakapiniri atoko iminakaniã, kona isa Teoso auĩtetxi ininiãtaãua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ininiã Xesosi kataratari amarini. Itakari iuako ikiina nopini. Amanaãri Teoso erekari itakini amarinimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Xesosi iuaĩkana potorika. Iuasaaki ãtokori miteka iuamoni. Ikapotoreẽkaua Xesosi apisatoõ. —Koerekareri erekari, kiripa nikama Teosokata ãtipirika nauini ĩkapani? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ininiã Xesosi: —Kininiãpa “erekari” pitxano? Teosonanira erekari. ");
INSERT INTO apuNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pite imarotari Teoso paniãtakiti. !Pokaniuatape. !Pisirĩkape ãti ĩtanorokata. !Piĩtiriuatape. Poxiene !pikamape. Apanakini !pimisirienetape. Piri, pinoro pakini pipaxitako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iua ãtokori txari: —Noereẽkiri, axapitipanikara ninakasaaki, nikĩpitari ikara Teoso paniãtakiti —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ininiã Xesosi apokaerekatari iua. —Auapanika ãtinoka pikamini tĩkane. Pisa. Tiitxi ikinika pinakiti pivẽtxitako. Txineiro papakapakito pisikako matxineirotenimoni. Eereka pimoianatanoko nota. Ikara atoko inakari pikaminiã, Teoso tixine papokasaaki ikinipoko erekari auiniiko pite —itxari iua. ");
INSERT INTO apuNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ikara Xesosi sãkire ikenakotakasaaki, imatinaniuata. Isipe. Maerekaxiniretinoka itxa, kotxi kaiãori itii. ");
INSERT INTO apuNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Xesosi sapotorika, misãkireta itxana imoianariakori: —Pamimapaniri katxineiroteri sini Teoso auĩtetxi ininiãtaãua —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Imoianariakori: —Anekani? —itxana. Iuaĩkana Xesosi txari: —Pamimapaniri katxineiroteri sini Teoso auĩtetxi ininiãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Atauako kamero napatari ãkorike sonakiã? Apia mimari kãkiti katxineiroterini auĩtetiniri Teoso —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Imoianariakori iteene tsorĩkaãnãta. —Ininiã kipa sari Teoso auĩtetxi ininiãtaãua? —itxana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ininiã Xesosi apakapapiretana: —Teoso posotari ikinipoko ikamini. Kãkiti !iposotari. Teoso posotari anikiniri katxineiroteri itixinemoni —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petro txari: —Ate takanapapekari ikinipoko pite amoianatini ĩkapani —itxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ininiã Xesosi: —Atão nitxai. Paapoko pitakanapiniã, pitariakori, pitaroakoro, piri, pinoro, pĩtanoro, pamariteni, pikikiote, pitakanapiniã notakata pisini ĩkapani, Teoso iokanapirena erekari pisãpiretini ĩkapani, ");
INSERT INTO apuNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","pitakanapakiti iua apiata nisikaiko. Ĩkorasaaki nisikaiko itomaneri aapokotxi, itomaneri pitariakori, itomanero pitaroakoro, itomanero pinoroakoro, itomaneri pamariteni, itomaneri pikikiote, nisikaiko. Txamari iuasaaki patatsiitari pimisiritiko. Iuaritika eereka Teosokata pauapika ãtipirika. ");
INSERT INTO apuNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Uatxa apiari inakari, iuasaakiko minakati itxauako. Uatxa minakati inakari, iuasaakiko apiari itxauako —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Xesosi imoianariakorikata Xerosareẽ kimaporite iãpotakasaakina, Xesosi ĩkiika. Iuasaaki ninoa maerekaxiniretinoka itxana. Apanakini ninoa tikini sikani pĩkarauata. Ininiã Xesosi iotoka. Akiritana imoianariakori tosi pakini. Isãpiretana paĩtiki kãkiti kamakiti iuamoni tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ininiã iua: —Hĩkenakota. Xerosareẽmoni asa uatxa. Iuaã nota hĩtari iaxitikiri sikaãkako sasetotxi auĩteakorimoni, kaiõkatsopareriakorimoni pakini. Ninoa paniãtariko nota okiko. Iposo atoko Xoteo minakonimoni sika ninaãkako. ");
INSERT INTO apuNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Inapetanonako. Inoropatanonako aãpitsaã. Ikiisokanonako. Iposo atoko oka ninaãkako. Ipi ãti pakini õti inakasaaki iuaĩkana nõkitikauako —itxa imoianariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Iposo atoko Txiako, Xoão pakini sari Xesosimoni. Ninoa Sepeteo anaakori. —Koerekareri, ate nirekari aamanaãkiti pikamini —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ininiã Xesosi pimaãna: —Kipa hinireka nikaminii hĩte? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Pite ikinimane auĩte pinakasaakiua, pauiritaua pitekata aĩtopãkini, pikikomoni, pisaneremoni aĩtopãkini —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ininiã Xesosi: —!Himarotari hamanaãkiti, kotxi mapaõti napa atoko nota apakapariko iãtatxi tsiĩtxiã niãtini ĩkapani. Hĩposotatari ikara hiãtini? Nipatxisataãkako tsiĩtxiã. Hĩposotatari ikara atoko hĩpatxisatiko? ");
INSERT INTO apuNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Aposotapitika —itxana ninoa. Xesosi txana ninoa: —Inipitikara hiãtariko nota iãtakiti. Inipitikara hĩpatxisataãkako nota patxisatiko atokokana. ");
INSERT INTO apuNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Txamari !niposotari nauiritinii hĩte nikikomoni, nisanaremoni hiĩtopãkini, kotxi Teoso mereẽpekana kãkiti nikikomoni, nisanaremoni topãkakani tĩkane —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Xesosi moianariakori tesi pakini kenakopiretakasaakiri Txiako, Xoão pakini amanaãkiti, ininiã ninoa omanatana. ");
INSERT INTO apuNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ininiã Xesosi akirita txana imoianariakori: —Uaimoni hina. Hiĩtopãka notakata —itxana ninoa. —Hĩte imarotari Xoteo minakaniua auĩteakori pataparana. Ninoa auiritari kãkiti kaminiri ninoa paniãtakitinoka. ");
INSERT INTO apuNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ninoa atoko !hĩtxape. Apiari pininiua pinirekiniã, pimoianatana apanakini. ");
INSERT INTO apuNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Apanakini auĩte pininiã pinirekiniã, nitiritxi pitxauako merepanika. ");
INSERT INTO apuNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ikara atoko nitxa nota hĩtari iaxitikiri ĩkorapokoriti napokasaaki. Ninitiri !auari. Ĩkorapokoriti napoka, kãkiti nitiri nininiua ĩkapani, kãkiti nitiretini ĩkapani. Ĩkorapokoriti napoka nipinini ĩkapani, kaiãopokori kãkiti mapinakani ĩkapani, kotxi nota iĩkitxirauata ninoa mapinakani ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Xesosi imoianariakorikata apoka Xerikoo sitatxiti. Eereka ipotorikasaaki imoianariakorikata itomaneri kãkitikata, iuasaaki mõsiãreti Patximeo inakori kimapori ĩtiniãpo iitopãkanãta. Tximeo inakori ãkiri iua. Iua mõsiãreti amanaãnãtaro txineiro. ");
INSERT INTO apuNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Iua kenakotari Xesosi Nasareekiri inapaenetini, ininiã akirinãta: —Xesosi, Taviini apika mekanirii, piamonĩkanoko —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ininiã apanakini kãkiti pinitari: —Maãtako. !Pakirinãtape —itxarina mõsiãreti. Iuaritika apiata akirinanikata: —Taviini apika mekani. Piamonĩkanoko nota —itxanãta. ");
INSERT INTO apuNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ininiã Xesosi iotoka itxa. —Hãkiritari iua mõsiãreti —itxa. Ininiã ninoa: —Pipoxokoniuatako. Põkitikaua. Akiritapekai —itxarina iua mõsiãreti. ");
INSERT INTO apuNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ininiã Patximeo okanapari imãka inopini auakari. Pakoteri õkitikaua, sa itxa Xesosi akiritiniri manapi. ");
INSERT INTO apuNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ininiã Xesosi: —Kipa pinireka nota kaminii pite? —itxari. —Apiananiri, nõsiãrera ninireka —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ininiã Xesosi: —Pisa. Erekapekai, kotxi pite auikari niposotiire —itxari. Iuasaakipeka Patximeo kõsiãrepeka itxa. Xesosikata sa itxa kimaporiã. ");
INSERT INTO apuNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Xesosi imoianariakorikata imatokoãpotari Xerosareẽ. Õtanoxiratari, oriva mina takikoãtaã takote apokana. Iuaã aua aapokotxi Petxipaxee inakori, Petánia inakori apaka. Iuaã Xesosi iokanatana ipi imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Hĩsa ikiraã kaixiti auakari aapokotxiã. Iuaã hãpokasaaki, hãpokari xomẽta ãkiri iaxiriãkori. Kãkiti !iitopãkapanika iua nopini. Hĩkoxirikari. Uaimoni mina hĩtxari. ");
INSERT INTO apuNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kãkiti pimaãkasaakii hĩte: “Kinirepa hĩkoxirikatari xomẽta ãkiri?” hinikosaakiko: “Apiananiri nirekari iua. Iuaĩkana akamoni aminariko,” hĩtxako. ");
INSERT INTO apuNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ininiã eereka isana. Apokarina iua xomẽta ãkiri iaxiriãkori kimaporiã aapokotxi tore takote. Ininiã ikoxirikarina. ");
INSERT INTO apuNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ãtikaka kãkiti iuaã auakani: —Kinirepa hĩkoxirikatari xomẽta ãkiri? —itxana Xesosi moianariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ininiã Xesosi paniãtini iaõka apakapapiretana. Ininiã kãkiti iuaã auakani: —Ininiã hanikaikari —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ninoa anikari xomẽta ãkiri Xesosimoni. Ininiã imãkana ãti imãkana nopini auakari itakarina xomẽta ãkiri nopini Xesosi topãkini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Apanakini kãkiti matameẽkari imãkana ãti imãkana nopini auakari kimaporiã Xesosi napini tĩkane. Apanakinipekana sauakari aãxike. Kimaporiã itakaãpotarina. ");
INSERT INTO apuNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ninoa Xesosi tikini ĩkani, iua apisa sikani pakini akiriãpokatana ipoxokoniritikana imakinikana: —Peerekari Teoso, Apiananiri. Iua iokanatai pite atemoni. Anirekari erekari isikinii pite. ");
INSERT INTO apuNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Peerekari Teoso, aãtokirini Tavii aãuĩte ininiua atokokana iuaĩkana apoka. Peerekari Teoso, iaxiti apiko nopinixiti auakari. Apiananiri itxaua —itxaãpokatana. ");
INSERT INTO apuNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Xesosi apoka Xerosareẽ. Teoso misãkiretiko aikotimoni isa. Iuaã ĩroã itxa. Ikinika iroko ãki itikapokota. Iua atoko mapiãpe, ininiã isari Petánia aapokotxitimoni tosi imoianariakorikata. ");
INSERT INTO apuNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ikatimatakasaaki ipotorikana Petánia. Iuasaaki Xesosi natxita. ");
INSERT INTO apuNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ikira atoko atamataro piko mina. Ito otsopa aua. Isari oamoni kariro iuãkatiniãro, kotxi piko mina tsopa auakasaaki, ori auapitika. Txamari apokasaaki, otsopanani auari, kotxi kona ori manapini. ");
INSERT INTO apuNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ininiã Xesosi: —Kãkiti !itximaikaiko piri —itxari piko mina. Imoianariakori kenakotari isãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Xesosi imoianariakorikata apoka Xerosareẽ. Xesosi ĩroã Teoso misãkiretiko aikotiã. Omitikana kãkiti iuaãtaã amotiitakani, sikatiitakani. Ikapakitikari amesa ninoa txineiro apakapakani amesane. Ikapakitikari kamoa vẽtxitakani topãkini apaka. ");
INSERT INTO apuNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Iua !auiritana kãkiti anikiniri tiitxi aiko ĩpirikoatinina. ");
INSERT INTO apuNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Xesosi oerekana kãkiti iuaã auakani: —Teoso sãkire iõkatsopatakori txari: Ia naapoko. “Teoso misãkiretiko aikoti” akiritaãkako, ikini itixiti auakani misãkiretinino ĩkapani, itxa. Txamari hĩte txĩkitakari ia aiko kiĩtiririni iomaãtiniãtaã ininiua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sasetotxi auĩteakori, kaiõkatsoparerini pakini kenakotari Xesosi sãkire. Ininiã ninoa tsorĩkaãta. Ixinikaxititana. —Kanatokopa atxatari Xesosi aõkini? —itxanãtana. Ikinimane iteene apokaerekatari Xesosi sãkire, ininiãkara sasetotxi auĩteakori, kaiõkatsoparerini pakini pĩkari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ipiãkapokotapeka Xesosi takanapari sitatxi imoianariakorikata. ");
INSERT INTO apuNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Katimatinĩkata kimaporiã isaãpotakasaakina, atamatarona oa piko mina. Opĩpe. Okotsapekara ipinakepeta apaka. ");
INSERT INTO apuNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petro xinikari iua apisapanika Xesosi sãkire, ininiã akiritari Xesosi: —Koerekareri, patamataro piko mina. “Kãkiti !itximaikaiko piri,” pinakito. Oa piko mina ipĩpeka —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ininiã Xesosi: —Pauikapiretariko Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Atãoenekara nisãpiretai. Pauikiniãri Teoso sãkire, piposotari pipaniãtiniri ikira õtanoxiratari: “Põkitikaua. Pokakataua potxoari uinitimoni.” Pãkixinireẽ iteene pauikiniãri pisãkire iaõka apokini, ininiã apokapitikako pamanaãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ikara atoko ininiã nota txai hĩte, Teoso pimisãkiretakasaaki, pamanaãkasaakiri pinirekakiti, pauikariko iposope Teoso sikinii, ininiã papakapapanikariko. ");
INSERT INTO apuNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Teoso pimisãkiretakasaaki, ãti pomanatiniã, pitakanapariko pomanãkare. Pimaxinĩkaretiniãri maerekati ikaminii, ininiã piri iaxitikiri maxinĩkaretari maerekati pite kamakiti. ");
INSERT INTO apuNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pimamaxinĩkaretakaniãri maerekati ãti kamakiti pitemoni, ininiã piri iaxitikiri kona maxinĩkaretari maerekati pite kamakiti apaka. ");
INSERT INTO apuNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iuaĩkana apokana Xerosareẽ. Xesosi tĩpokota aiko Teoso misãkiretiko pirikere ãki tinikata. Itĩpokonãtakasaaki, sasetotxi auĩteakori, kaiõkatsoparerini, kiomãtxiakori pakini apoka iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ininiã ninoa txari: —Kipaniãpa pikamari ĩkora pikamakiti? Kipa paniãtai? —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ininiã Xesosi apakapapiretana: —Nota apaka pimarauatako hĩtemoni. Ãtinoka nipimaãiko hĩte. Hĩsãpiretiniãno, nota sãpiretai hĩte niokanatakiri uãka apaka. ");
INSERT INTO apuNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kipa paniãtari Xoãoni ipatxisarauatini? Teosokani paniãtari Xoão? Kãkitikani paniãtari Xoão? Hĩsãpiretano —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ininiã ninoa xinikaxitinãta. Imisãkiretakakana. Ipimaãkakana: —Natokopa itxa aãpakapapiretiniri iua? Aãpakapapiretiniãri: “Teoso paniãtari iua,” ininiã iua: “Kinirepa kona hãuikatari iuani sãkire?” itxapemaua. ");
INSERT INTO apuNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aãpakapapiretiniãri: “Kãkiti paniãtari iua,” ikinimane omanataua —itxanãtana. Ninoa pĩkari kãkiti kotxi ikinimane auikari Xoãoni atão Teoso sãkire sãpiretakari ininiua. ");
INSERT INTO apuNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ikara atoko ininiã ninoa apakapapiretari Xesosi: —Ate !imarotari. Ininiã Xesosi: —Ikara atoko ininiã, nota !nisãpiretai hĩte nipaniãtakiri uãka. ");
INSERT INTO apuNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Eereka Xesosi sãpiretana ninoa sãpirenatxi atão inakari oerekiko. Itxari: —Kiki takarauata. Txipokori ova inakoronoka itaka. Ipiriketari. Ikamari ova maõkiko. Iposo atoko itakare apanĩkakixitika ikamari aapokotxi axapitiri õtanori ikikiote imakinetini ĩkapani. Iposo atoko ipaniãtana ãtikaka kikiakori itakare inĩkatinina ĩkapani, kotxi iua sariko õtakoxiti. Ninoa apakapamaroko ipixini ova iparĩkana ĩki. Iposo atoko katakareri sipe. ");
INSERT INTO apuNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ova manapi, iua katakareri iokanatari initiri ninoa kikiakorimoni ova ipixini apakapini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Txamari iua apokasaaki ninoa maĩkari iua. Ixirokitatarina. “Pisipeka,” itxarina. Miketika ikanapiripe. ");
INSERT INTO apuNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","—Iuaĩkana katakareri iokanatari ãti initiri ninoamonikana. Txamari ninoa kikiakori misiritari iua. Kai soroã ikiporonakarina, karota itxapirina ikiiã. ");
INSERT INTO apuNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Iuaĩkana katakareri iokanatari ãti ninoamonikana, txamari ninoa okapiri iuani. Kaiãopokori initiriakori iokanata ninoamoni. Apanakini inoropatana. Apanakini okana. Itxaãpotana. ");
INSERT INTO apuNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","—Iua katakareri auapanika ãtinoka iokanatini ĩkapani, imi iteene itiretakiti. Imapotõkire iokanatari imi ninoamonikana. “Notamoni ninoa paxitariko namarite” itxa. Ininiã imi apoka ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Katakareri ãkiri napani. Maõkari. Aõkiniãri, itakare imakinika kaikotinaua ate,” itxakakana kikiakori. ");
INSERT INTO apuNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","—Ininiã ninoa maĩkari katakareri ãkiri, oka itxapirina, kikio xiripire oka itxarina iĩto. ");
INSERT INTO apuNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","—Ininiã kiripa ikama katakareri? —itxa Xesosi. —Iua kanapiriã. Okanako ninoa kikiakori. Ipaniãtana apanakini itakare imakinetinina ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hĩte atatsopatapekari ia Teoso sãkire iõkatsopatakori: Aapokotxi kamakani kona nirekari ãtika kai soro. Iua kai imanirekakiniti kai apiari itxapekaua. Apanakini kai soro maĩkakari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Teosokara txĩkitakari ikara atoko inini. Ikara peerekari atemoni, itxa Teoso sãkire iõkatsopatakori. ");
INSERT INTO apuNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Xoteo auĩteakori imarotarina Xesosi sãkire. Ninoa imarotari ikamakitina takari makinetakani kamakiti atokokana, ininiã ninoa omanãkarauata Xesosi sãpiretakiti xika. Ninoa kinirão maĩkaka itxarina Xesosi, txamari !imaĩkarina iua, kotxi ipĩkarina kãkiti. Ininiã itakanaparina Xesosi, sipe itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Eereka Xoteo auĩteakori iokanatana ãtikaka Erotxi sãkire auiãkani, ãtikaka pariseoakori pakini Xesosimoni. Inirekarina Xesosi kerokiniri isãkire, kotxi ninoa nirekari Xesosi kaminiri maerekati imaĩkinirina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ninoa apokasaaki, imisãkiretarina Xesosi: —Koerekareri, ate imarotari pite sãkire atãonani ininiãua. Poerekari atãonani Teoso nireẽkiti kãkiti kamini ĩkapani. !Pipĩkari kãkiti. Kãkiti poiãori pimisãkiretini atokokana kãkiti apiari pimisãkireta apaka. Ikara atoko ininiã, pisãpiretaua. Atãokani txineiro asikini Homanoakori auĩtemoni, Sesa inakorimoni? ");
INSERT INTO apuNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Atãokani asikiniri iuamoni? Apakata amasikakaniri iuamoni? —itxana. Xesosi imarotari isãkirena. Imarotari ninoa pimarauatini isãkire ikerokini ĩkapani. !Inirekarina atão inakari imarotinina. Ininiã Xesosi txana ninoa: —Kinirepa hãtamakaerekatano nota? Himinaro txineirota. Ninirekari natamatiniro —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ininiã iminarona. —Kisanõkapa ia? Kiuãkapa aua uai? —itxana. Ininiã ninoa: —Sesa sanõka, iuãka pakini —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ininiã Xesosi: —Ikara atoko ininiã, hĩsikariko Sesamoni iua nakiti. Hĩsikariko Teosomoni iua nakiti —itxana. Ininiã kasãkirena ninoa, kotxi peerekari Xesosi apakapapiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kikiakori satoseo inakoni, !auikari kãkiti ipĩkaripeka iuaĩkana õkitikiniua iuaĩkana auãki inini ĩkapani. Ninoa satoseo apoka Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Koerekareri, Moisesini iõkatsopatari ia ipaniãtakiti: “Kiki meenetipanika ipininiã, iua itari takaroko tikinitakoro. Iua itari keene ininiã, itakauãkatari amarini iua itarini ipĩpekarini uãka,” itxa Moisesi. ");
INSERT INTO apuNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Setxi itaritxiakori aua ĩkorapokoriti. Apia kiomanetakari takaro sito. Txamari ipĩkasaaki meenetopanika itikinitaro. ");
INSERT INTO apuNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ininiã ãti itari takaro oakana. Ipĩkasaaki !keenepanikaro oa. Iua atokokana itxape ãti itari. ");
INSERT INTO apuNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ininiã imakinikana ninoa takapiimaro oa. Ikinikana ninoa meenenipanika ipĩpena. Eereka oanipekana apaka opĩpe. ");
INSERT INTO apuNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ipĩkani õkitikasaakiua, kiriĩtanoropa otxatauako? Kotxi ikinikana setxi takapekaro oa —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ininiã Xesosi: —Hĩte kerokari, kotxi !himarotari Teoso sãkire iõkatsopatakori. Teoso posotiire apaka !himarota. ");
INSERT INTO apuNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ipĩkani iuaĩkana õkitikasaakiua, Teoso nitiriakori iaxitikini atoko itxapekauana. !Ĩtanorouataikako. ");
INSERT INTO apuNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Hĩte !auikari ipĩkani õkitikiniua. Hĩte atatsopatapekari Moisesi iõkatsopatakiti aanaia tirinakari pirena. Iuasaaki Teoso misãkiretari Moisesi: “Apraão, Isaki, Xakoo pakini Teosonekarano nota,” itxari Moisesimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ikara atoko ininiã Apraão, Isaki, Xakoo pakini õkitikapekaua iuaĩkana, kotxi auãki inakani Teosonera iua. Kona ipĩkani Teosoneni itxaua Teoso. Amananini hĩkerokari —itxa Xesosi satoseoakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iuaãtaã aua kaiõkatsopareri. Ikenakotana ninoa misãkiretakakiniua. Ikenakotari Xesosi apakapapiretakiti erekari ene. Ininiã iua pimaãri Xesosi: —Ĩkiripa Teoso paniãtakiti apiari txataua? Kipa apiaerekata Teoso nireẽkiti akamini? ");
INSERT INTO apuNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Xesosi apakapapiretari: —Teoso paniãtakiti apiari ia: “Isaeo tõpa auakani, hĩkenakota. Ateosone Apiananiri iua. Iuananira Teoso txaua. ");
INSERT INTO apuNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pitiretariko Apiananiri piTeosone, ikinipoko pinireẽkitiã, ikini pãkixinireẽ, ikinipoko pixinikakitiã, ikini pitaparaxinireẽ pakini.” ");
INSERT INTO apuNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ãtipekana Teoso paniãtakiti apiari ia: “Piteka pitiretiniãua atokotxikana, pitiretariko ãti.” Iuananira Teoso paniãtakiti ipi apiari txaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ininiã iua kaiõkatsopareri apakapapiretari Xesosi: —Inipitikara pisãkire, koerekareri. !Auari ãti Teoso. Iuanokara auari. ");
INSERT INTO apuNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ininiã atiretamariko Teoso ikinipoko anireẽkitiã, ikinipoko axinikakitiã, ikini ataparaxinireẽ. Atiretamanako apanakini aĩtoka atiretini atokokana. Ikara Teoso paniãtakiti ipi apiari txaua. Teoso paniãtakiti pirãtxi aõkini iua ĩkapani poiãori —itxa Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Xesosi kenakotakasaakiri isãkire ereka inini, itxari iua: —Pite auĩtearitari Teoso. Iposo atoko apanakini !kataparaxinireika apikomoni ipimainirina. ");
INSERT INTO apuNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Xesosi Teoso misãkiretiko aikoti oerekarauanãtakasaaki, ipimaãri: —Kinirepa kaiõkatsoparerini sãkire: “Tavii apika mekanirako Teoso mereẽkiti txauako?” itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Erekari Matamatakoti kamasãpirenatakari Tavii: Apiananiri misãkiretari niauĩte: “Nota kikomoni piitopãkiniritika nixipokariko pimokaiakariakori. Nikamariko ninoa pikiti pitakiniãtaã atoko ininiua,” Apiananiri txari niauĩte, itxa Taviini. ");
INSERT INTO apuNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tavii akiritari iua Teoso mereẽkiti “Niauĩte.” Ikara atoko ininiã, natokopa itxa iua Tavii apika mekani ininiua? —itxa Xesosi. Iuasaaki ikinimane kãkiti iuaã apitiitakaniua potxitari Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Xesosi oerekarauanãtakasaaki, õtãkikana kãkiti: —Kaiõkatsoparerini moianari !hĩtxapeua. Ninoa potxitari mãkatxi ereri ieretakinina kãkiti apisatoõ inapinina ĩkapani, kãkiti atamatinina ĩkapani. Ninoa apokaerekatari imisãkiretikona ipaxitikona nipokori sikikoãtaã inapaãpotakasaakina. ");
INSERT INTO apuNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ninoa potxitari kãkiti topãkini apiaerekatakari nopini iitopãkinina aiko Xoteo apotiitiniãtaãua. Kiiniriã ninoa potxitari kakiiniriteri topãkinimoni iitopãkinina. ");
INSERT INTO apuNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ninoa mixirikari tikinitakoni aapoko, iuaritika okanani imisãkiretarina Teoso kãkiti apisatoõ, ininiã kãkiti uãkatari ninoa erekarini atoko ininiãuana. Teoso iteene misiritanako kãkiti ikara atoko inakani. ");
INSERT INTO apuNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Xesosi topãka txineiro Teoso ĩkapani apakapikoãtaã. Xesosi itikari kãkiti ieretakiniro txineiro kaixa ãki. Itori katxineiroterini okaro txineiro mirikinito kaixa ãki. ");
INSERT INTO apuNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Eereka tikinitakoro matxineiroteto apoka iuaã. Otakaro ipi txineiro otaki kaixa ãki. Poiãonoka txineiro. ");
INSERT INTO apuNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ininiã Xesosi akiritana imoianariakori. —Inipitikara nisãpiretai hĩte. Õkora tikinitakoro matxineiroteto sikakito apiata. Apanakini sikakito poiãoka. ");
INSERT INTO apuNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kotxi ninoa sikaro txineiro itetakoro. Oa matxineiroteto sikari okinika onakito —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Teoso misãkiretiko aikoti Xesosi pokĩkasaaki, imoianari misãkiretari iua: —Koerekareri, patamata ia kai aapokotxiti itomaneri. Amaripokori. Ia aiko Teoso misãkiretiko peerekari. ");
INSERT INTO apuNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ininiã Xesosi: —Hãtamatari ia aiko mitari. Ãti õti imakinika irikaãkako. Kona kai kaikotaikako ãti kai nopini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Xesosi topãka oxiratari nopini Teoso misãkiretiko aikoti apisatoõ. Iuaã aua oriva minanape. Iuasaaki Petro, Txiako, Xoão, Ãtree pakini apoka iuamoni. Ninoanoka aua iuaã. ");
INSERT INTO apuNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ipimaãrina Xesosi: —Kirisaakipa aiko Teoso misãkiretiko irikaãka? Natokopa itxa aimarotiniri ikara õti apisapanika? ");
INSERT INTO apuNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ininiã Xesosi: —Erepaniko. !Hãuiritapiri apanakini misirienetinii hĩte. ");
INSERT INTO apuNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Itopaniriko kãkiti, “Xesosikarano,” inakanipaniko. Ninoa misirienetari kaiãopokori kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Neenamatxi hĩkenakoenetakasaaki, neenamatxi ene hĩkenakoenetakasaaki, !hĩpĩkarauatape. Ikara auapitikako, iuaritika kona xipokatxi õtipanikani. ");
INSERT INTO apuNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ãti uãka neenamauata ãti uãkakata. Ãti tixini auakani neenamauatako ãti tixini auakanikata. Ãtikaka itixi iakeẽkatako. Kaiãopokopaniri natxi. Amarini auini tsii atoko itxapaniko. ");
INSERT INTO apuNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—Erepaniko hĩte. Himaĩkaãkako, auĩtetximoni hĩsiãkako. Hinoropataãkako aãpitsaã aiko ãki Xoteo apotiitiniãtaãua. Nota sãkire hãuikini xika hĩte anikaãkako poiãori auĩtetximoni. Apiari auĩtetximoni apaka hanikaãkako. Iuasaaki hĩte sãpiretanako ninoa Teoso iokanapirena erekari. ");
INSERT INTO apuNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Itixi xipokini apisapanika Teoso iokanapirena erekari sãpiretaãkako ikinimanemoni ikini itixitikinimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kãkiti maĩkasaakii hĩte, anikasaakii hĩte auĩtetxiakorimoni, !hĩxinikapiri hĩsãkire tĩkane hĩsãkirauatini apisapanika. Hĩsãkirauatakasaaki, iuasaakipeka himarotari hĩsãkire. Erekari Matamatakoti txĩkitakai iuasaaki hĩsãkire himarotini. ");
INSERT INTO apuNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kãkiti sikanapariko atão itariakori auĩtetximoni okiko tĩkane. Iriakoritxi sikanapanako imiakori auĩtetximoni okiko tĩkane. Eenetxiakori omanatana iriakori, inoroakoro pakini. Eenetxiakori xika ninoa okapeẽka. ");
INSERT INTO apuNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nota sãkire hãuikini xika, ikinimane omanatai hĩte, iuaritika himatakanapakaniãri nisãkire hãuikini, hanikaãkako Teoso tixinemoni —itxa Xesosi imoianariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Iuaĩkana Xesosi sãpiretana: —Hĩtikariko Maerekati Apiatakari Teoso misãkiretiko aikoti ãki. Kitxakapirĩka Teoso sãkire sãpiretakari Tanieo inakori sãpiretapekari ikara pirena. (Ininiã hĩte ia atatsopanãtakanii, hĩkenakotariko Xesosi õtãkikiniua.) Maerekati Apiatakari Teoso misãkiretiko aikoti ãki hĩtikasaaki, hĩte Xotéia tõpa auakanii, himitekapoka mitaxiratarimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iuasaaki hĩte haãpoko nopini auakanii, katima hĩtxako hĩkatxakini. Haãpoko !hiĩroãpe hĩtii himakatxakini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Hĩte kikio auakanii, !hĩkanapiripe haãpokomoni himãka hãpini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ikarasaaki !erekapaniri sito kamixiromoni, sito kaxitakakareromoni. ");
INSERT INTO apuNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Teoso hamanaã himitekini kamoĩsaaki, kotxi himitekini mitaãsaaki !erekari. ");
INSERT INTO apuNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Iuasaaki atatsiiri auakatapitikako. Ia atatsiiri apiata atatsiitaãkako. Kitxakapirĩka itixi Teoso kamakasaaki kãkiti atatsiirauata poiãoka. Ikara atatsiiri õti apisa kãkiti atatsiirauata poiãoka. Ikara atatsiiri õti napa atoko !ikara atoko inakari atatsiiri !auaikako. ");
INSERT INTO apuNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Teoso mapoiãotakaniãri iua õti kãkiti atatsiirauatini õti, !auaikamako kãkiti. Ikinipekamako ipĩpemanako. Teoso iotokakariko ĩkora atatsiiretxi, imereẽkini mapinakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—Apanakini sãpiretiniãi hĩte: “Xesosi Teoso mereẽkiti ia,” hinikosaaki, !hãuikapiri. “Xesosi Teoso mereẽkiti ikiraãtaã,” hinikosaaki, !hãuikapiri. ");
INSERT INTO apuNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kotxi Teoso mereẽkiti minakaniua apokapitikako, “Xesosikarano nota,” inakari. Apaka apanakini apokapitikako, “Teoso sãkire sãpiretakarikarano nota,” inakari. Paxirari ninoa sãkire. Kãkiti ikara atoko inakani kamariko posotiiretxi, kãkiti itikiniri ĩkapani. Ninoa nirekamari Teoso mereẽkini imisirienetinina. ");
INSERT INTO apuNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Erepaniko. Ikara õti apokini apisapanika nõtãkikai hĩte —itxa Xesosi imoianariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Iua misirikaretxi napa atoko atokatxi iuakapeka. Kasiri !iponikaika. ");
INSERT INTO apuNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Iõriki iaxitikero irikako. Ikinipoko kaikori iaxiti auakari ioĩketaãkako. ");
INSERT INTO apuNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Iuasaakipekako ikinimane atapariko kãkiti itari iaxitikiri apokaãpotini katxiãri ãki. Itapararitika apoka. Kaiotximereri itxaua iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iuasaaki iokanatana initiriakori iaxitikini ĩtinixitimoni, ipinimoni ĩtinixitimoni, atokatxi pokĩkinimoni, atokatxi ereẽkokinimoni. Iokanatana initiriakori ikini itixitimoni kãkiti imereẽkini apitiitinina ĩkapani —itxa Xesosi imoianariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iuaĩkana Xesosi sãkirauata. —Nisãpiretai sãpirenatxi atão inakari oerekiko, piko mina pirena, nikanapiriini apiata himarotini ĩkapani. Pooĩoporipeka onakasaaki, otomorekasaaki, “Kamoĩ apokanapanoka,” hĩtxa. ");
INSERT INTO apuNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Iua atokokana ikara misirikaretxi mixikanani nisãpiretakiti hĩtikasaaki, himarotapekariko nota kaiama kanapirikapeka ninini. ");
INSERT INTO apuNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ia nisãkire atão. Itixi auakani !ixipoka ikinipoko nisãpiretakiti mapokakani apisa. ");
INSERT INTO apuNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Iaxiti xipokapitikako. Ĩkoraxiti apaka xipokapitikako. Iuaritika nota sãkire !ixipoka —itxa Xesosi imoianariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Iuaĩkana Xesosi sãkirauata: —Kãkiti !imarotari ikara õti manapi apokini. Teoso nitiriakori iaxitikini apaka !imarotari ikara õti. Nota Teoso ãkirikanera !imarotari ikara õti. Nirinanira, Teosonanira, imarotari. ");
INSERT INTO apuNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hiãtapapikariko. Hĩkoatapikako. Teoso himisãkiretapikako. Kotxi !himarotari ikara õti apokini. ");
INSERT INTO apuNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","—Nikanapiriãkasaaki, kiki õtako sikari kanapiriini atoko nitxa. Iua kiki potorikasaaki, ipaniãtana initiriakori aapoko inĩkatinina. Ikininape isikanapana parĩkatxi ikaminina. Ipaniãtari initiri aapoko toreãtaã kaikotakari, “Araõkire pitxako,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nota hĩtari iaxitikiri iua kiki õtako sikari atoko nitxako. Ãtipirika hiãtapapikanoko, kotxi !himarotari nota apokini õti. !Himarotari mapiãtikikauako napoka. !Himarotari apanĩkanõkauako napoka. Imaropirĩkatauako napoka. Ĩkanõkapanikauako napoka !himarotapaniri. ");
INSERT INTO apuNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Atxiĩti patimari napokini, ininiã hĩkoatapikako, mimakatika hinini ĩkapani nota apokasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ininiã ãtipirika hiãtapapikanoko. Ikininapemoni apaka ikara nitxa —itxa Xesosi imoianariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Iuasaaki kãkiti apotiitaua ipi kiiniriti auakasaaki. Páskoa kiiniriti, pão miãtiãkati nikiko kiiniriti pakini aua. Ipi õti kiiniri potorikini apisapanika sasetotxi auĩteakori, kaiõkatsoparerini pakini xinikaxitita: —Natokopa atxatariko Xesosi amaĩkini aõkini ĩkapani? ");
INSERT INTO apuNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","!Amaĩkapaniri kiinirisaaki, kotxi amaĩkiniãri, kãkiti naiatamaua eereka —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Xesosi auanãta Petánia aapokotxiti Simão inakori aapoko. Iua Simão akiritaãka “Maere Matati.” Simão aapoko Xesosi nipokonãtakasaaki, sito apoka. Oa minari kopitipaki kai kamakori, kai arapástiro inakoro. Kopitipaki ãki aua kamariãro, nato inakoro. Pakaronepokoro. Oãpokasaaki Xesosimoni, opakauanakari kopitipaki. Okitakaro kamariãro Xesosi kiiã. ");
INSERT INTO apuNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Iuasaakipeka apanakini iuaã auakani omanãkarauata. —Kinirepa oioanataãka kamariãro? ");
INSERT INTO apuNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ovẽtxitamaroko, ininiã kaiãopokomaniko txineiro oãpakapamako. Tresẽtosi txineiro ota prata kamakori oãpakamako. Txineiro mauakinitimoni osikiniã erekamariko —itxana. Iteene ikapatitana. ");
INSERT INTO apuNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ininiã Xesosi: —Ikara atoko !hĩtxapero. !Homanatapero. Erekari okaminano. ");
INSERT INTO apuNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kãkiti matxineiroteni auapikako hĩtekata. Hinirekasaakiriko hĩsikaro txineiro ninoamoni. Nota !auari ãtipirika hĩtekata. ");
INSERT INTO apuNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Oia sito kamari ikinipoko oimarotakiti nota ĩkapani. Nipinini apisapanika oina notamoni. Omaritari niĩto, niĩto iposope inini nikatiko ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Atão nisãpiretai hĩte. Teoso iokanapirena erekari sãpiretikoãtaã ikini itixiti, osãpiretaãkako apaka oia sito kitakiniro kamariãro nikiiã, ininiã kãkiti ikini itixiti auakani xinikapikaro oa —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tosi pakini Xesosi moianariakori. Imoianari Xotasi inakori sari sasetotxi auĩteakorimoni. Imisãkiretana ninoa Xesosi imĩkapiritini ĩkapani, ninoamoni isikiniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ikenakotakasaakirina Xotasi sãkire, ipoxokoniuatana. Isikaenetarona txineiro iuamoni. Eereka Xotasi iãtapari Xesosi imĩkapiritini õti. ");
INSERT INTO apuNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Páskoa kiiniriti potorikini õti, soti auĩte anaakori okiko õti, Xesosi moianariakori misãkiretari iua: —Namonipa pinirekatari Páskoa kiiniriti akamini? ");
INSERT INTO apuNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ininiã Xesosi iokanatana imoianariakori ipi. —Hĩsa sitatximoni. Iuaã kiki ãparaã kopitiã anikakari hãpiãkata. Iua kikikata hĩsa. ");
INSERT INTO apuNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Iua sinimoni kaapokori himisãkireta. Hĩtxariko iua: “Koerekareri nirekari imarotiniri, namonipa erekari imoianariakorikata inipokotini Páskoa kiiniriti ikamakasaakina?” hĩtxariko. ");
INSERT INTO apuNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ininiã iua oerekaiko hĩte itanokiri koa mitapoari. Auapeka kãkiti topãkini. Imakinika oeretapeẽkaika —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ininiã imoianariakori sari. Sitatxi apokasaakina Xesosi sãkire iaõka aua. Ininiã ninoa kamari nipokori Páskoa kiiniriti ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ĩkanõkapeka inakasaaki Xesosi apoka tosi imoianariakorikata. ");
INSERT INTO apuNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Inipokonãtakasaakina, Xesosi txana: —Atão nisãpiretai. Ãti hĩte notakata nipokotakari mĩkapiritanoko nota —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ininiãkara Xesosi moianariakori matinaniuata. Ipimaãrina Xesosi: —Notakani atxiĩti? Ãtipekana: —Notakani atxiĩti? Ininiã imakinikana ikara atoko itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ininiã Xesosi: —Ãtika hĩte notakata auakari mĩkapiritano. Notakata komiri iopitiãtakarikarako sikano nimokaiakariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nota hĩtari iaxitikiri okaãkako. Teoso sãkire iõkatsopatakori sãpiretapekari nipinini tĩkane. Nota hĩtari iaxitikiri mĩkapiritakari iteene misiritaãkako. Erekamariko maponaniãkatika inaãkamako. ");
INSERT INTO apuNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Xesosi imoianariakorikata nipokonãtakasaaki, Xesosi kosekari komiri. Imisãkiretari Teoso: —Erekapitikari ia komiri pisikakiti atemoni —itxari. Imapopeẽri komiri, xanaka itxari imoianariakorimoni. —Apakapa, nika hĩtxako. Ia niĩto —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Iposo atoko koseka itxaro iãkoanatxi. Imisãkiretari Teoso: —Erekapitikari ia iãriã pisikakiti atemoni. Ininiã iãkoanatxi isikana imoianariakori. Ikinikana iãtarina iãriã. ");
INSERT INTO apuNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ininiã Xesosi: —Ia niarẽka xiketakari makatxakariko kaiãopokori kãkiti maerekani. Teoso sãpiretapekari kãkiti ikamaenetakiti amaneri kãkiti ĩkapani. Ia niarẽka oerekari kãkiti, Teoso kamapekari ikamaenetakiti. ");
INSERT INTO apuNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Atão nisãpiretai. !Niãtaikaroko ovapeẽ, Teoso auĩtetxi ininiãtaãua nimapokakanisaaki. Iuaã napokasaaki niãtari. Amaneri iãriãti niãtako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eereka ninoa xikarauata Teoso ĩkapani. Iua atoko isana oriva mina auiniãtaã, oxiratari nopini. ");
INSERT INTO apuNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Xesosi misãkiretana imoianariakori: —Ia ĩkanõkati hĩkinika hĩte takanapanoko nota, kotxi Teoso sãkire iõkatsopatakori sãpiretapekari ikara atoko inakari. Itxari: Nokariko soti auĩte piratakari, ininiã ikinika ipiraakori iarikitatako, itxa Teoso sãkire iõkatsopatakori. ");
INSERT INTO apuNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ininiã eereka nota nipinaãka atoko, iuaĩkana nõkitikaãkaua atoko, nisako hĩte apisa Kariréiamoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ininiã Petro: —Nota !nitakanapai pite. Atxiĩti ikinimane takanapai, iuaritika kona nota takanapai. ");
INSERT INTO apuNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ininiã Xesosi: —Atão nisãpiretai. Ia ĩkanõkati patari ipikata sãkirauatini apisapanikako, ipi ãti pakinikata, “!Nimarotari iua,” pitxanoko —itxari Petro. ");
INSERT INTO apuNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petro apakapapiretari itaparaxinireritika: —Atxiĩti pitekata nokaãka, iuaritika kona nota sãpiretari apanakini nimimarotakanii pite. Ikininape Xesosi moianariakori Petro sãkire iaõka ikamana. ");
INSERT INTO apuNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Xesosi imoianariakorikata apoka ãtiãtaã kãkiti akiritakiti Xetsémani inakoriãtaã. Iuaã Xesosi paniãtana imoianariakori: —Uai hiĩtopãka. Teoso nimisãkiretako —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Anikari Petro, Txiako, Xoão pakini iuakata apikomoni. Iuaã Xesosi iteene matinaniuata. Maerekaxiniretinoka itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ininiã iua: —Nixinire imaromaxiretari. Iteene nimaxire, ininiã okaaritano. Uai hĩkaikota. Araõkire hĩtxako —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Apikomoni isa. Ipamaka xitimoni, misãkireta itxari Teoso. ");
INSERT INTO apuNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Itxari iri: —Papai, pite posotari ikinipoko pikamini. !Pauiritapeno paĩtiki natatsiirauatini, iuaritika ninirekari pite nirekakiti nikamini. Nota nirekakiti nikamini kona ninireka —itxari iri. ");
INSERT INTO apuNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Eereka ikanapiriã Petro, Txiako, Xoão pakinimoni, txamari ninoa imakanãta. Xesosi akiritari Petro: —Simão, himakanãta? Kona hĩposotatari ãti oaranoka hĩkoatini? ");
INSERT INTO apuNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Erepaniko. Hinirekasaakiri maerekati hĩkamini, !hĩkamapiri. Araõkire hĩtxako. Himisãkiretariko Teoso, ininiã !hĩkamari maerekati. Kãkiti xinire atxiĩti !inirekari maerekati ikamini. Txamari kãkiti ĩto tapara poiãoka, ininiã ikamari maerekati. Ininiã erepaniko —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iuaĩkana isa Teoso imisãkiretini ĩkapani. Teoso imisãkireta, mitxi isãkire atokokana itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Iposo atoko ikanapiriã. Txamari iuaĩkana ninoa imakanãtapanika. !Iposotarina ikoatinina. Ipẽtauatana, ininiã !kasãkirena. ");
INSERT INTO apuNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iuaĩkana ikanapiriã Petro, Txiako, Xoão pakinimoni. —Himakanãtapanika? Hĩtomanãtapanika? Iaõpe. Hãtapana. Hĩtari iaxitikiri uatxa sikaãkako maerekati kamakanimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hõkitikaua. Masa. Hãtapana. Apokaãpota kiki nimĩkapiritakiri —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Xesosi sãkirauanãtakasaaki, Xotasi apoka. Iua Xotasi Xesosi moianarikamara. Iminana ito kiki, saasara mĩkani, piriri mĩkani. Sasetotxi auĩteakori, kaiõkatsoparerini, kiomãtxiakori pakini iokanatari Xotasi kikiakorikata Xesosi imaĩkinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Xotasi mitxipeka sãpiretari kikiakori: —Nota apitxokakiti Xesosipitikarako iua. Iuasaaki himaĩkapekariko. Erepaniko hanikasaakiri, imamitekakani ĩkapani —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Xotasi apokasaaki, isakatapitipori Xesosimoni. Akiritari: —Koerekareri. Inakasaakipeka apitxoka itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Inakasaakipeka kikiakori maĩka, anika itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kiki iuasaaki iuaã auakari kosekaro saasara. Iua sauaãkatari sasetotxi auĩte apiatakari nitiri. Itsotakakĩpitari. ");
INSERT INTO apuNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iuasaakipeka Xesosi: —Hĩte ina himaĩkinino ĩkapani, saasarakata, piririkata. Kiĩtiriri atoko hĩtxapeno nota himaĩkinino. ");
INSERT INTO apuNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ikiniõtika nota auanãtari hĩtekata Teoso misãkiretiko aikoti ãki, noerekarauatakasaaki. Iuaã hĩte !imaĩkano nota, kotxi Teoso sãkire iõkatsopatapeẽkaika hĩte maĩkinino kiĩtiriri himaĩkini atoko —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iuasaakipeka ikinika Xesosi moianariakori miteka, asika itxarina iua. ");
INSERT INTO apuNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Iuasaaki ãtokori sari Xesosi tikini. Iua mãka ãtinoka aua iĩtoã pirikakari. Kikiakori maĩkamari iua. ");
INSERT INTO apuNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Imãkanoka kaikota iuakoãna. Kasarapeka imiteka iua ãtokori. ");
INSERT INTO apuNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ninoa anikari Xesosi sasetotxi auĩte apiatakari aapokomoni. Iuaã ikinika sasetotxi auĩteakori, kiomãtxiakori, kaiõkatsoparerini pakini apotiitaua. ");
INSERT INTO apuNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petro ikira atoko isaãpota Xesosi anikakani tikini. Ĩroã sasetotxi auĩte aapoko piriketakoriã. Iuaã iitopãka sasetotxi auĩte apiatakari nitiriakorikata. Iroka xamina tinipoki. ");
INSERT INTO apuNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Aapokotxi ãki sasetotxi auĩteakori, ikinika Xoteo auĩteakori pakini pimaãna kãkiti: —Kipa imarotatari maerekati Xesosi kamini? Ninoa nirekari Xesosi okiko imaerekani xika. Txamari !apokarina imaerekani imarotakani, kotxi !ikamari maerekati. ");
INSERT INTO apuNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kaiãopokori kãkiti sãpiretari maerekati Xesosi kamakiti, txamari paxirari ninoa sãkire, kotxi ãti sãpiretakiti ipinimoni, ãti sãpiretakiti ipinimoni, itxaãpotana. ");
INSERT INTO apuNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Apanakini kiki õkitikaua, sãpireta itxarina ia aãpirena Xesosi ikamapiretinina. ");
INSERT INTO apuNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ninoa: —Ate kenakotari isãpiretiniri: “Nirikariko ia aiko Teoso misãkiretiko aikoti kãkiti kamakiti. Ipi ãti pakini õti inakasaaki nikamariko ãti aiko kãkiti makamakiniti,” itxa isãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Txamari ikara sãkiretxi ãti sãpiretakiti ipinimoni, ãti sãpiretakiti ipinimoni, itxaãpota. ");
INSERT INTO apuNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Iposo atoko sasetotxi auĩte apiatakari tima ikinimane apisatoõ. Iua pimaãri Xesosi: —Kininiãpa na papakapapiretari ninoa sãkire? Kixikapa ninoa ikara atoko txanãtai? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Txamari !kasãkireri Xesosi. !Apakapapiretari. Ininiã sasetotxi auĩte apiatakari iuaĩkana pimaãri: —Pitekani Teoso mereẽkiti txataua? Pitekani Teoso ãkiri txataua? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ininiã Xesosi: —Ari, iua ãkiripitikarano. Hãtamatariko kãkiti itari iaxitikiri topãkini Kaposotiireri kikomoni. Hãtapariko kãkiti itari iaxitikiri uai apokaãpotini katxiãri ãki —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iuasaakipeka sasetotxi auĩte apiatakari matsorãkari imãka, kotxi iuãkatari Xesosi sãkire maerekati ininiua. —!Anirekaikari Xesosi kamakiti sãpiretakani. Atokopeka. ");
INSERT INTO apuNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kotxi hĩte kenakotapekari isãkire maerekati, “Teoso ãkirirano” inini. Natokopa atxatari iua? —itxana. Ininiã ninoa apakapapiretari: —Okaãkapitikako —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Apanakini kiisokari Xesosi. Mãkatxi mataã iapirikarina ikiiã oki manapi imatamatakani ĩkapani. Iposo atoko iãsokarina. —Pisãpiretaua, kipa ãsokai? —itxarina. Sasetotxi auĩte nitiriakori apaka ãsokari iua iuakoãna. ");
INSERT INTO apuNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Iuasaaki Petro ixiti aua aapokotxi piriketakori ãki. Sasetotxi auĩte apiatakari nitero ãtokoro apoka iuaã. ");
INSERT INTO apuNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Oãtamatari Petro irokanãtini xamina tinipoki. Oa mixinitari iua. Ininiã oa: —Xesosi Nasareekiri moianarikai pite apaka —otxa. ");
INSERT INTO apuNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ininiã: —Kona, nota !imarotari pisãkire —itxaro. Iuasaaki pirikere ĩronakikoãtaã isari. Iuasaakipeka patari sãkirauata. ");
INSERT INTO apuNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Oa sasetotxi auĩte nitero atamatari iua iuaã. —Ere kiki iua moianaripitikara —otxana ninoa Petro takote auakani. ");
INSERT INTO apuNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","—Kona iuano nota —itxa. Paĩtiki ninoa iuaã auakani: —Iua moianaripitikarai. Pite Kariréiakirikarai. Pisãkireẽra ate imarotai —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ininiã Petro: —Nota !imarotari kiki ikara atoko hinanãtakiti. Atãoene nimasãpiretakaniã, Teoso misiritamanoko. Teoso imarotari nota sãkire atãoka nisãpiretinii —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ikara atoko Petro inakasaaki, iuaĩkana patari sãkirauata. Ininiã Petro xinikari Xesosi sãpiretakiti iuamoni. “Ipikata patari sãkirauatini apisapanikako, ipi ãti pakinikata, ‘!Nimarotari iua,’ pitxanoko.” Ikara inakari ixinikasaaki, itxiapata. ");
INSERT INTO apuNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Katimatinĩkata sasetotxi auĩteakori, kiomãtxiakori, kaiõkatsoparerini, ikinimane Xoteo auĩteakorikata xinikaxitinãta. Ipaniãtarina Xesosi iaxirikiko. Iposo atoko anika, sika itxarina Piratomoni. ");
INSERT INTO apuNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pirato pimaãri Xesosi: —Pitekani Xoteoakori auĩte txataua? —itxari. Ininiã Xesosi: —Ari, pisãkire atãopitikara. ");
INSERT INTO apuNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sasetotxi auĩteakori apoiãpotari Xesosi, txamari Xesosi !kasãkireri. ");
INSERT INTO apuNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ininiã Pirato: —Na papakapapiretatari? Ninoa iteene misãkirepiretai —itxari. ");
INSERT INTO apuNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Iuaritika Xesosi !apakapapiretari. Ininiã Pirato ãkixinireẽ: —Kinirepa kona apakapapiretari? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Páskoa kiiniriti auakasaaki, Pirato itotari isikakiniri kateia ãki auakari kãkiti nireẽkiti. ");
INSERT INTO apuNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iuasaaki Xesosi maĩkikosaaki, Pahapasi inakori aua kateia ãki. Iua Pahapasi apanakini kateia ãki auakanikata okaniuatapeka Homanoakori inaiatakasaakina. ");
INSERT INTO apuNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pirato sãkirauatakasaaki Xesosikata, kãkitipokoni apoka Piratomoni. —Kateia ãki auakari pisikaka —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ininiã Pirato pimaãna: —Hinirekatari nisikakiniri Xoteo auĩte hĩte ĩkapani? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pirato iteene imarotari sasetotxi auĩteakori sikari Xesosi iuamoni Xesosi ixikotinina xika. ");
INSERT INTO apuNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sasetotxi auĩteakori maasakana ninoa iuaã apotiitakaniua: —Hamanaãri Pirato Pahapasi isikakini ĩkapani —itxana kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pirato iuaĩkana pimaãna: —Natokopa nitxatari ia kiki Xoteo auĩte inakori? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Akiripoakatana: —Aamina ĩpiriãmitakari nopini hĩtokakitari —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ininiã Pirato: —Kixikapa? Maerekati !ikama —itxa. Apiata akiripoakatana: —Aamina ĩpiriãmitakari nopini hĩtokakitari —itxakatana. ");
INSERT INTO apuNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ininiã Pirato sikakari Pahapasi ninoa ĩkapani, kotxi inirekari ikamapoxokonitinina ninoa kãkiti. Eereka ipaniãtari Xesosi xirokitatiko aãpitsaã. Eereka Pirato paniãtari sotatoakori tokakitiniri Xesosi aamina ĩpiriãmitakari nopini. ");
INSERT INTO apuNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ininiã sotatoakori anikari Xesosi Pirato aapoko ãki. Akiritarina ikinika sotato. ");
INSERT INTO apuNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Iposo atoko ieretakarina mãkatxi põkamarari Xesosi ĩtoã. Ikamarina saporiẽta kotipiaro kamakori, taka itxarina Xesosi kiiã. ");
INSERT INTO apuNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","—Aãuĩte —itxarina Xesosi inapetinina. —Xoteo auĩtekai pite —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Iaritakiitarina aãkeẽ. Ikiisokarina. Ikapotoreẽkauana Xesosi apisatoõ. —Aãuĩte —itxarina Xesosi inapetinina. ");
INSERT INTO apuNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Inapetakarina atoko imakatxakarina mãkatxi põkamarari. Xesosi mãka iuaĩkana ieretaka. Eereka anikarina Xesosi aamina ĩpiriãmitakari nopini itokakitinirina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ipixinipokoriti itaõkitarina kiki Simão inakori. Sireni sitatxitikiri iua. Iua anaakori Arexãtri, Hopo pakini. Iuasaaki Simão apoka Xerosareẽ. Sotatoakori paniãtari iua: —Ia aamina ĩpiriãmitakari panikinari —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Anikarina Xesosi ixirataã, Kóokota inakoriãtaã. Xoteo sãkire “Kóokota.” Apanakini akiritari iua oxiratari uãka “Kiitãtatxi,” inaãka akiritiko. Iuaã apokana. ");
INSERT INTO apuNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Isikamarina iãriã pinĩtxikata, miha inakorokata, Xesosi iãtini ĩkapani, itsii imimarotakani ĩkapani, txamari !inirekaro iãtiniro. ");
INSERT INTO apuNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ininiã itokakitarina aamina ĩpiriãmitakari nopini. Eereka ikamarina sarauatxi, Xesosi mãka apakapakani imarotinina ĩkapani. Ikara atoko apanakini anikari Xesosi mãka. ");
INSERT INTO apuNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ĩkanõkapanika novi oara itokakitapeẽka Xesosi aamina ĩpiriãmitakari nopini. ");
INSERT INTO apuNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aaminaã auari iõkatakitina, apoĩtiko pirena, “Xoteoakori Auĩte” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ninoa tokakitana ipi kiĩtiririni apaka aamina ĩpiriãmitakari nopini, ikikomoni ãti, isanaremoni ãti. ");
INSERT INTO apuNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kitxakapirĩka Teoso sãkire iõkatsopatakori txari: Okapeẽkako iua, kokaniri okiko atoko inapeẽkako. Ininiã Xesosi okikosaaki ia Teoso sãkire iõkatsopatakori iaõka auapeka iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ninoa iuaã napakani misãkirepiretapikari Xesosi: —Kiĩkitei. Pite sãkire: “Nirikariko Teoso misãkiretiko aikoti. Ipi ãti pakini õti inakasaaki nikamari iuaĩkana,” pitxama. ");
INSERT INTO apuNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ikara atoko piposotiniã, piteka pimakatxakauako, ininiã pikatxaka aamina ĩpiriãmitakariã —itxarina Xesosi inapetinina. ");
INSERT INTO apuNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sasetotxi auĩteakori, kaiõkatsoparerini pakini napetari Xesosi: —Iua makananitapekari apanakini. Txamari iuaka !iposotari imakananitiniua —itxakakana. ");
INSERT INTO apuNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","—Ikatxakiniãrako ate auikari Teoso mereẽkiti ininiãua. Ikatxakiniã, aãuikari Isaeo auakani auĩte ininiãua —itxakakana. Kiĩtiririni iuakata tokakitakoni apaka misãkirepiretari. ");
INSERT INTO apuNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Iuasaaki apaniãxiti ipiãka. Ikini itixitika piãka. Ipi ãti pakini oara ipiãka. ");
INSERT INTO apuNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ipi ãti pakini oara napa atoko Xesosi akiripoakata: —Erii, Erii, aremaa sapakatanii —itxa. Ia atatsopatakari sãkireẽ: “NiTeosone, niTeosone, kinirepa pitakanapano?” itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kãkiti iuaã auakani kenakotari akirinãtini. —Hĩkenakota. Akirinãtari Eríasi —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Iuasaakipeka kiki ina katimariã. Iãkari mapoa atoko inakari iãriã katxioãrimoni, aãke mapotõkire taka itxari, sika itxari Xesosi iãtini ĩkapani. —Mitxipanikako. Maiãtapari. Atauako Eríasi makatxakatapaniri Xesosi —itxana. ");
INSERT INTO apuNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Xesosi itapararitika akiripoakata, eereka ipĩpe itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iuasaakipeka mãkatxi mata Teoso misãkiretiko aikoti ãki arõkakari tsorakita. Itano itsorakita. Ixitipeka apoka. Mitxi iua mãkatxi mata !auiritari kãkiti ĩroini Teosonani Auini Pakitaãtaã. ");
INSERT INTO apuNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sotatoakori auĩte aua aamina ĩpiriãmitakari apisatoõ. Ikenakotari Xesosi akiritini. Itikari ipinini. —Atãopitikara Teoso ãkiri itxaua ia kiki —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ãtokaka sitoakoro ikira atoko atamanãtarina Xesosi, Maria Matarenama, Saromeema, ãto Mariama, apanakini sitoakorokata. Xosesi, Txiako pakini inoro oa Maria. Iua Txiako maneripanika inakari. ");
INSERT INTO apuNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Xesosi Kariréia auakasaaki, ninoa sitoakoro moianatari iua. Imiparĩkatarina. Xesosi ipĩkasaakikanera apanakini sitoakoro kaiãopokoro aua iuaãtaã. Ninoa apoka Xerosareẽ Xesosikata. ");
INSERT INTO apuNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ikara õti, Xesosi ipinini õti, kãkiti parĩkauatini õti, kãkiti tomatini õti apisapanika, iuasaaki kikatatikipeka. ");
INSERT INTO apuNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Iuasaaki Xosee inakori, Arimateia sitatxitikiri, sari Piratomoni. Iua Xosee Xoteo auĩte apanakinikata. Ikinimane paxitari iua. Iua apaka iãtapari Teoso ikinimane auĩte ininiua õti apokini. Itaparaxinireritika Piratomoni isa, amanaã itxari Xesosi ĩto. ");
INSERT INTO apuNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ininiã Pirato ãkixinireẽ: —Atauako patimari Xesosi ipinini? —itxa. Ininiã ipĩkapiretari sotatoakori auĩte. Iua apokasaaki Pirato pimaãri: —Atauako Xesosi ipĩpeka? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ininiã iua: —Ari, ipinapitipeka —itxari. Ininiã Pirato: —Panikaikari iĩto —itxari Xoseemoni. ");
INSERT INTO apuNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iuasaaki Xosee amotari mãkatxi mata erekari, arínio inakori. Eereka imakatxakari Xesosi ĩto. Iapirikari iĩto mãkatxi mataã, anika itxari akauari irikomoni. Kai kisakakori ãki ieretakari Xesosi ĩto. Eereka kai mitapoari ikatika, tota itxari iriko. ");
INSERT INTO apuNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ipi Maria itikanãtari Xesosi ĩto takikoãtaã, Maria Matarenama, Maria, Xosesi inakori inoroma pakini. ");
INSERT INTO apuNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tomatiko õti xipoka atoko mapiãnikata, ipi ãto pakini sito amotaro kamariãro, Xesosi ĩto ikamamaritinina ĩkapani, Maria Matarenama, Saromeema, Maria Txiako inoroma pakini. ");
INSERT INTO apuNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Katimatinĩkata, tomĩkosaaki, ĩkanõkapanika, atokatxi pokĩkasaaki, ninoa sari akauarimoni. ");
INSERT INTO apuNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kimaporiã isikasaakina, isãkirauaãpotana: —Kipa makatxakinaua kai auĩte iriko tore? —itxaãpotana. Amaripokori iua kai. ");
INSERT INTO apuNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Iuaã apokasaakina, atamatarina. Kai makatxakapeẽkaika. ");
INSERT INTO apuNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ininiã ĩroãna iriko ãki. Atamatarina ãtokori topãkanãta ikikomoni. Imãka ĩtanori, kasarori. Ininiã ninoa tikoka. ");
INSERT INTO apuNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ininiã iua: —!Hĩtikokape. Hĩte nitanãtari Xesosi Nasareekiri, aamina ĩpiriãmitakari nopini tokakitakori. Õkitikapekaua iua. !Auaika uai. Hãtamata. Mitxi itakarina iĩto uai. ");
INSERT INTO apuNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hĩsipeka. Hĩsãpiretari Petro, apanakini Xesosi moianariakori pakini: “Xesosi sapanikako hĩte apisa Kariréiamoni. Iuaã hĩte aõkitari iua, kotxi ipinaka apisapanika isãpiretapekari ikara hĩtemoni,” —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Itimaritikana ninoa pokĩka. Imitekana. Ikikinanakana, ipĩkarena xika. !Isãpiretarina apanakini, kotxi ipĩkarauatana. ");
INSERT INTO apuNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Xesosi õkitikasaakiua ipinaka atoko ĩkanõkapanika semana potorikini õti, tomĩkosaaki, oerekaua merepitipanika Maria Matarenamoni. Mitxipe Xesosi aõkitakasaakiro oa Maria, omitikari maerekani matamatakoni setxi pakini oa ĩtoã auakani. ");
INSERT INTO apuNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Xesosi õkitikasaakiua, iua oaõkitaka atoko, osari merepanika Xesosi moianariakorimoni. Iuasaaki iteene imatinaniuatana. Itxiapanãtana. Osãpiretana ninoa: ");
INSERT INTO apuNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","—Xesosi iuaĩkana auãki itxapeka. Nota aõkitari iua —otxana. Txamari ninoa kona auikari osãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Eereka iuaka oerekaua ipi imoianariakorimoni, kimaporiã isikasaakina aapokotxi mauakaniãtaã. Iuasaaki itoõ ipinipo itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Eereka ninoa kanapiriã. Isãpiretana apanakini imoianariakori, txamari !auikarina isãkirena. ");
INSERT INTO apuNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Eereka Xesosi oerekaua õsi imoianariakorimoni inipokotakasaakina. Xesosi õtãkikana: —Kinirepa hĩte !auikatari nota iuaĩkana auãki ninini? Kinirepa !hãuikatari nota aõkitakani sãkire? !Kaiokakarekii —itxa. ");
INSERT INTO apuNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iposo atoko Xesosi txana: —Ikini itixiti hĩsako. Hĩsãpiretariko Teoso iokanapirena erekari ikinimanemoni. ");
INSERT INTO apuNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Teoso sãkire auiãkari patxisatakori, iuarako sari Teoso tixinemoni. Teoso sãkire mauikakati, Teoso misiritapikariko. ");
INSERT INTO apuNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Teoso sikaposotiiretanako isãkire auiãkani, ininiã apanakini imarotari Teosokara sikari iposotiire ninoamoni. Ia atoko Teoso sikaposotiiretana. Omitikarina maerekani matamatakoni nota uãkaã. Isãkirauatana imimarotakinitina sãkiretxitiã. ");
INSERT INTO apuNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Imaĩkiniãrina imini, !ipinana. Iãtiniãrina ikianari, !amianatana. !Ipinana. Itakauakotaua amianatakani nopini, ininiã amianatakani makananitaãka —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Imoianariakori imisãkiretanapaka atoko, Xesosi anikaãka Teoso tixinemoni. Iuaã iua topãka Teoso kikomoni. ");
INSERT INTO apuNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Xesosi moianariakori eereka isipekana, Teoso sãkire ikini aapokotxiti auakani isãpiretinina ĩkapani. Apiananiri moianatana. Apiananiri sikaposotiiretana ninoa, ininiã apanakini imarotari ninoa sãpiretakiti atão inini. Ameẽ.");
INSERT INTO apuNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nota Arókasi iõkatsopata pite Teópiromoni. Iteene nipaxitai. Kãkiti ito iõkatsopatapekari ikinipoko Xesosi kamakiti Xoteoakori sauaki auakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ninoa, nota pakini imarotari ikinipoko Xesosi kamakiti, kotxi Xesosi kamakiti atamatakani, isãkire oerekakani, sãpiretapekaua ate. ");
INSERT INTO apuNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nota apaka apaiaõkapekari ikinipoko Xesosi sãkire, ikamakiti pakini. Ininiã nota apokaerekatari ikinipoko Xesosi pirena niõkatsopatini pite Teópiromoni. Merepitipanika ikamakiti nisãpiretai. Ininiã eereka ikamakiti nisãpiretai. Ininiã eereka ikamakiti nisãpiretai, nitxaãpotako. ");
INSERT INTO apuNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Koerekarerini oerekapekai Xesosi pirena, ininiã uatxa pimarotari ninoa oerekakiti atão inini. ");
INSERT INTO apuNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Erotxi inakori Xoteoakori auĩte inakasaakiua Xotéia tõpa, iuasaaki auanãta sasetotxi Sakaria inakori. Sakaria auĩte, apanakini sasetotxiakori auĩte apaka, Apia inakori. Sakaria tanoro ouãka Isapeo otxaua. Oĩri, oãtokiri, oãtokiri iri imakinikana sasetotxi itxauana. Oãtokiri kitxakapirĩkari Moisesi itari Arão inakori. Iua apaka sasetotxi itxaua. ");
INSERT INTO apuNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Teoso nirekaãkitinanira ikamana Sakaria, Isapeo pakini. Ninoa kamari ikinipoko iua paniãtakiti, Apiananiri paniãtakiti. Atão inakarinoka ikamana. !Ikerokarina ikamakitina. ");
INSERT INTO apuNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Txamari !keenena. Isapeo !oposotari kamixi onini. Iuasaaki ikiomaneẽpekana. ");
INSERT INTO apuNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ãti õti Sakaria, apanakini sasetotxiakorikata, parĩkauanãta Teoso misãkiretiko aikoti ãki. Iuasaaki ninoatene iuaã parĩkauata. ");
INSERT INTO apuNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sasetotxiakori itotari sasetotxi imereinina Apiananiri misãkiretiko aikoti ĩroini kamariãro arikini ĩkapani, ininiã iuasaaki ninoa mereẽri Sakaria. Ininiã iua ĩroã. ");
INSERT INTO apuNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sakaria aiko ãki kamariãro arikanãtakasaaki, mapara kãkiti apotiitakaniua misãkiretari Teoso. ");
INSERT INTO apuNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Iuasaakipeka Teoso nitiri iaxitikiri tokiã Sakariamoni kamariãro arikikoãtaã takote. ");
INSERT INTO apuNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaria atamatakasaakiri, itikoãkata, pĩkarauata itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Teoso nitiri misãkiretari iua: —Sakaria, kona pipĩkarauatape. Teoso sikapitikaiko pamanaãkiti. Ininiã pĩtanoro Isapeo keenepitikaroko. Pitakauãkatariko pamarite Xoão. ");
INSERT INTO apuNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iua auakasaaki ikamapoxokonitaiko pite, itori kãkiti apaka. ");
INSERT INTO apuNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Apiananirimoni apiari itxauako iua Xoão. Kona Xoão iãtapaniroko kapoãro. Erekari Matamatakoti auariko iua ãkixinireẽ. Inoro irokota ãkipanika auakasaaki, Erekari Matamatakoti auako iua ãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iua Xoão anikanako itomaneri kãkiti Isaeo auakani Teosomoni. Apiananirimoni iua anikana. Ininiã iuaĩkana ninoa kanapiriã iTeosonemonina, isãkire auikinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Xoão apokako Apiananiri apokini apisapanika. Erekari Matamatakoti sikataparatari Eríasi kitxakapirĩka. Iuatxikana Erekari Matamatakoti sikataparatariko Xoão. Ikara atoko ininiã, iua oerekariko irĩtxi iuaĩkana amaritena itiretinina ĩkapani. Iua Xoão oerekariko kãkiti Teoso paniãtakiti makamakani, imaerekanina itakanapinina, erekarinoka ikaminina ĩkapani. Paimatirenako ninoa iuasaakiko. Iua Xoão oerekariko kãkiti iposope ininina Apiananiri apokini apisapanika —itxa Teoso nitiri Sakariamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ininiã Sakaria pimaãri: —Kiãtokopa nitxa uatxa keenepeka ninini, kotxi nota, nĩtanoro apaka kiomaneẽpeka —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Teoso nitiri apakapapireta: —Niuãka Kapirieo. Nota auari Teosokata ipaniãtakiti nikamini ĩkapani. Teoso iokanatano pitemoni pite nimisãkiretini ĩkapani, ia erekari pirena niminapiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Txamari na pauikari nisãpiretakiti. Ia xika !kasãkireikaiko, kotxi nisãpiretakiti atãopitika. Teoso sikaenetakiti apokapitikako. Apokasaaki, pimarotariko nisãkire atão ininiua. Iuasaakiikarako piposotari pisãkirauatini —itxa Teoso nitiri Sakariamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Iuasaaki kãkiti mapara auakani iãtapanãtari Sakaria. —Kiripa ikamanãta Sakaria aiko ãki? !Katimari —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ipokĩkasaaki !kasãkireikari. Ninoa kãkiti imarotari Teoso misãkiretiniri iua aiko ãki itaponeẽ, kotxi !kasãkireikari. Iuakoãnokara imisãkiretana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mapaõti iparĩka xipoka atoko aapokomoni isipeka. ");
INSERT INTO apuNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Eereka Isapeo kamixipeka otxa. Onapari ipi ipi ãti pakini kasiriti oaãpoko. !Osari ãtiãtaã. ");
INSERT INTO apuNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Apiananiri sikano namarite. Erekari ikaminano notamoni. Uatxa !nipẽtauataika kãkiti apisatoõ. Keenepekano —otxa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isapeo seisi pakini kasiriti kamixi onakasaaki Teoso iokanatari initiri iaxitikiri Kapirieo Nasaree sitatxitimoni, Kariréia tõpamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Iuaã iokanatari iua ãtokoromoni Maria inakoromoni. Oa kona sirĩkapanika kikikata. Osãpiretapekari ãtokori Xosee inakori iuakata oĩtaniriuatini ĩkapani. Xosee atokiri kitxakapirĩka Xoteoakori auĩte Tavii inakori. ");
INSERT INTO apuNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Teoso nitiri apokasaaki oamoni, akiritaro Maria: —Ereẽkai. Apiananiri pitekata aua. Iua mereẽi pite. Itoro sitoakoro ikini itixiti aua, iuaritika pitenanirako Teoso sika iteene erekari —itxaro oa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria pĩkarauata Teoso nitiri sãkire okenakotakasaaki. —Kinirepa ikara atoko itxa sãkireta? —otxa oãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Teoso nitiri txaro: —!Pipĩkarauatape, Maria. Teoso apokaerekatai pite. ");
INSERT INTO apuNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pimixiuatako, keene pitxako. Pitakauãkatariko pamarite Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iua Apiatakari itxauako. Apiananiri ãkiri akiritaãkako. Teoso Apiananiri kamariko iua auĩtetxi ininiãua. Kitxakapirĩka Xoteoakori auĩte Taviini. Taviini auĩtetxi ininiua atokokana, Teoso txĩkitakariko Xesosi Xoteoakori auĩte ininiua. ");
INSERT INTO apuNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ãtipirika Xoteoakori auĩte, Xakooni apiko mekaniriakori auĩte, itxauako. Iua auĩtetxi ininiua !ixipoka —itxaro oa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ininiã oa: —Kiãtokopa nitxa kikikata masirĩkatokano, keenepe ninini? —otxa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Teoso nitiri apakapapiretaro: —Erekari Matamatakoti apokako pãkixinireẽ. Apiananiri posotiire ãkitaiko pite, ininiã amarini auakari Teoso ãkiri akiritaãkako. ");
INSERT INTO apuNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Pinoromane Isapeo kiomãtxipe, iuaritika kamixiro oa. Kãkiti sãkirema: “!Oposotaikari kamixi onini” iuaritika seisi pakini kasiritipe kamixi onini. ");
INSERT INTO apuNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kotxi Teoso posotari ikinipoko ikamini —itxaro oa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","—Nikamapitikariko Apiananiri nirekaãkiti. Pisãpiretakiti iaõka ninirekapitika —otxa Maria. Iuasaakipeka Teoso nitiri sipeka. ");
INSERT INTO apuNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mapaõti napa atoko Maria katimariã sari oxiratarimoni, Xotéia tõpamoni. Iuaã osari sitatximoni. ");
INSERT INTO apuNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Oĩroã Sakaria aapoko. Oãkiritaro Isapeo: —Ereẽkai —otxa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Isapeo kenakotakasaakiri Maria akiritiniro oa, iuasaaki amarini otikakoãkiri oãkika. Iuasaakipeka Erekari Matamatakoti itapararitika apoka Isapeo ãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Iuasaaki otapararitika otxaro Maria: —Kaiãopokoro sito itixi auakani, iuaritika pitenokara Teoso sika apia erekari. Apaka Teoso sikariko erekari pamaritemoni. ");
INSERT INTO apuNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Erekari Teoso kaminano nota, kotxi niauĩte inoro motikaẽtano. Kinirepa ia erekari Teoso kaminano, kotxi nota minakato nitxaua. ");
INSERT INTO apuNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nikenakotakasaakiri “Ereẽkai” pininino, namarite nitikakoãkiri oãkika, ipoxokoniuatiniã. ");
INSERT INTO apuNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Teoso sikari erekari pitemoni, kotxi pite auikari isãkire. Pite auikari isikaenetakiti atão isikinii —otxa Isapeo Mariamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria txari: ");
INSERT INTO apuNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nipoxokoniuata, kotxi Teoso nimaerekani makatxaãkari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nipoxokoniuata, kotxi ixinikano nota. Initero poiãoro nitxaua. Ĩkorakanani eereka auakani kãkiti txanoko: ‘Teoso kamapoxokonitaro, erekari isikiniro,’ txanoko nota. ");
INSERT INTO apuNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nipoxokoniuata, kotxi Teoso Apiananiri kaminano posotiiretxi. Maerekati !auari iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iua amonĩkari kãkiti iua paxitakani, kitxakapirĩkarini, ĩkorakanani auakani, eereka auakani apaka iamonĩka. ");
INSERT INTO apuNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pataparari iua, ininiã ikamari posotiiretxi. Teoso txĩkitakana kãkiti iuikakaniua minakani ininiãuana, kotxi ãkixinireẽ iuikauana. ");
INSERT INTO apuNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Teoso makatxakapekari auĩtetxi pataparari inakaniua. Eereka auĩtetxi !itxaikauana ninoa. Kãkiti poiãorini inakaniua Teoso kamari auĩtetxi ininiãuana. ");
INSERT INTO apuNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Isikakienatari natxitakani. Iokanatari katxineiroteri sini. Kona xatiki isikari iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Imoianatapekana Xoteoakori, iua ĩkapani parĩkauatakani. !Imaxinĩkaretari iamonĩkinina ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kitxakapirĩka Teoso xinikari Apraãoni iamonĩkini. Apaka iua tikini auakani ãtipirika iamonĩka, kotxi: ‘Nimoianataiko hĩte,’ itxa anirimanemoni kitxakapirĩkarinimoni,” otxa Maria. ");
INSERT INTO apuNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Okaikota ipi, ãti pakini kasiriti Isapeokata. Eereka oaãpokomoni kanapiriã otxa Maria. ");
INSERT INTO apuNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Amarini auini õti apopeka. Isapeo auãkitakari amarini kiki. ");
INSERT INTO apuNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Oaãpoko takote auakani, onirimane pakini kenakotari erekari Teoso kaminaro oa, ininiã ninoa, Isapeo pakini poxokopeka itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Oito õtisaaki, onirimane motika oamoni, Teoso takaõtxikare amarinimoni itakinina ĩkapani. Inirekarina iuãka Sakaria itakauãkatinirina, kotxi iri uãkatxikana ninoa nireka itakauãkatinirina. ");
INSERT INTO apuNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Txamari inoro: —Kona Sakariani iuãka. Xoãorako akiritaãkako —otxa. ");
INSERT INTO apuNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ininiã ninoa txaro: —Pinirimane ãtika kona Xoão txa uãkataua. ");
INSERT INTO apuNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ninoa pimaãri amarini iri Sakaria iuakoãna amarini uãka inirekaãkiti. ");
INSERT INTO apuNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ininiã Sakaria amanaãri iõkatsopatiko. Iõkatari: “Imi uãka Xoão.” Ininiã ikinimane tsorĩkaãta. ");
INSERT INTO apuNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Iuasaakipeka Teoso sikaposotiiretari isãkirauatini: —Peerekari Teoso —itxa Sakaria. ");
INSERT INTO apuNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kãkiti iua aapoko takote auakani pĩkarauata. Teoso posotiire ipĩkana. Ikara inakariene Sakaria, Xoão pakini pirena iaripireta oxiratari Xotéia tõpa, ininiã kãkiti iuaãtaã sãpirenauanãta ikara pirena. ");
INSERT INTO apuNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kãkiti ikara inakariene kenakotakani tsorĩkaãta: —Kanatokopa inakaripa itxatapaniua ia amarini? —itxana. Ikinimane imarotari Apiananiri nĩkatiniri iua amarini. ");
INSERT INTO apuNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Iuasaaki Erekari Matamatakoti sikaposotiiretari Xoão iri Sakaria, ininiã Sakaria sãpiretari Teoso sãkire: ");
INSERT INTO apuNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Peerekari Apiananiri aTeosone, ikinimane Xoteoakori Teosone, kotxi iua apoka inakitiakorimoni imakatxakinina ĩkapani, imapinakanina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Teoso iokanatari kãkiti maerekani makatxakakari kaposotiireri atemoni. Teoso nitiri Taviini mekanirira iua. ");
INSERT INTO apuNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kitxakapirĩka Teoso sãkire sãpiretakani erekarini sãpiretari ikara Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Teoso txari: ‘Nimakatxakaiko hĩte himokaiakari mokakanii tĩkane, homanatakini mokakanii tĩkane.’ ");
INSERT INTO apuNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Isãpiretari aãtokiriakorini kitxakapirĩkarini: ");
INSERT INTO apuNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kitxakapirĩka Teoso txari aãtokiri Apraãoni: ‘Kona nimaxinĩkaretari nisikaenetakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nimakatxakapitikaiko hĩte himokaiakari mokakanii tĩkane, ininiã hĩparĩkauata nota ĩkapani mapĩkaretika. ");
INSERT INTO apuNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ininiã hĩte auini erekari. Kona hĩkamari maerekati hãuapanika hinakasaaki,’ Teoso txari Apraãoni. ");
INSERT INTO apuNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pitepekana namarite Xoão, Teoso sãkire sãpiretakari pitxauako. Teoso Apiananiri iaxitikiri sãkire sãpiretakari pitxauako. Pite sari Apiananiri apisa. Ikinika pimaiamatako iua apokini apisa, ikinika iposope inini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Pisãpiretariko kãkiti Teoso nakitiakori, Teoso makatxakiniri maerekanitxi kãkiti kamakiti. Ininiã ninoa imarotariko ikara. ");
INSERT INTO apuNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Katiraõkiri aTeosone. Kaamonĩkareri iua. Ininiã iua tixinekiri apokako atemoni. Atokatxi pokĩkini atoko itxako. Iuasaaki ipiã !auaika, kotxi iua makatxakari amaerekani. ");
INSERT INTO apuNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ininiã iua iopinikari kãkiti xinire, ipinini pĩkakani xinire. Ipiaã auakani atoko ninoa. Ininiã iua iopinikari axinire Teoso kimapore aimarotini ĩkapani, aãuini ereka inini ĩkapani.” Itxa Sakaria xikare. ");
INSERT INTO apuNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Iua amarini aneẽ. Teoso sãkire iaõka ikamapika. Teoso sãkire Xoteoakorimoni imasãpiretakani apisapanika ãparaã makipakaniãtaã aua Xoão. ");
INSERT INTO apuNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Iuasaaki Homanoakori auĩte Sesa Akósito inakori. Iua paniãtana initiriakori iaõtiniri ikininape kãkiti iua auĩtetxi ininiãtaãua tõpa auakani, ikini aapokotxitikini uãka imakatxakini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mitxi Sesa Akósito !ikamapanikari kãkiti iaõtiko. Iuasaaki Síria tixini auakani auĩte Sirénio inakori. ");
INSERT INTO apuNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iuasaaki ikinimane sari sitatximoni iponaniiniãtaãna. Iuaã isikarina iuãkana. ");
INSERT INTO apuNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ininiã Xosee apaka sari iuãka isikini ĩkapani. Ininiã ipotorika Nasaree sitatxiti Kariréia tõpa. Xotéia tõpamoni isa, Pereẽ sitatxitimoni. Iuaã isa, kotxi iuaã auĩtetxi Taviini kitxakapirĩka aua. Taviini nirimane itxaua Xosee. ");
INSERT INTO apuNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Isa Mariakata. Ĩtanoro tĩkane oa. Iuasaaki !itakapanikaro. Kamixipeka otxa iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pereẽ apoka itxana. Iuaã auakasaakina, aua itxa amarini. ");
INSERT INTO apuNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Oãuãkitakari merepitipanika oimi kiki. Ininiã mãkatxi mataã oiapirikari, pirãtxi nipokotini tiitxitiã taka otxari amarini, kotxi kãkiti imakanakiniãtaã imakinika xãpokapeka, ininiã ninoa auanãta pirãtxi auiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Iuaãtaã Pereẽ sitatxiti mapotõkire ĩkanõka kikiakori soti auĩte piratakani nĩkanãtari ipiraakorina. ");
INSERT INTO apuNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Iuasaaki katimaritika Apiananiri nitiri iaxitikiri tokiã ninoamoni. Iuasaaki Apiananiri iotximere iopinikari ninoa auiniãtaã, ininiã imarotarina Teoso apokini iuaãtaã. Ininiã iteene ipĩkarauatana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ininiã Teoso nitiri txana ninoa: —!Hĩpĩkarauatape. Nota minapiretari erekari pirena ikinimane kãkiti enenĩkini ĩkapani, ");
INSERT INTO apuNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","kotxi ia õti kãkiti maerekani makatxaãkari iponaniãpeka Taviini auini sitatxitiã. Iua Teoso mereẽkiti. Apiananiri iua. ");
INSERT INTO apuNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Himarotariko nisãkire atão inini, kotxi hãpokariko ia amarini mãkatxi mataã iapirikiko pirãtxi nikini tiitxitiã —Teoso nitiri txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Iuasaakipeka itomaneri Teoso nitiriakori iaxitikini tokiã iuaãtaã. Ninoa xikarauata Teoso ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ixikaretarina: —Peerekari Teoso, iaxiti apiko nopinixiti auakari. Iua kamaerekaxiniretari kãkiti iua apokaerekatakini —itxana ixikarena. ");
INSERT INTO apuNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Teoso nitiriakori kanapiriã itxana Teoso tixinemoni. Iuasaaki ninoa pirãtxi nĩkatakani misãkiretakakaua: —Masa Pereẽmoni. Maãtamatari ikara Apiananiri sãpiretakiti —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ininiã katimaritika isana Pereẽmoni. Iuaã apokasaakina, initarina amarini. Apokana Xosee, Maria pakini. Ininiã atamatarina amarini pirãtxi nikini tiitxitiã. ");
INSERT INTO apuNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ikara atamataãkana atoko, isãpirenãtarina Teoso nitiri sãpiretakiti amarini pirena ikinimanemoni. ");
INSERT INTO apuNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kãkiti kenakotakasaakiri soti auĩte nĩkatakani sãpiretakiti, ikinimane tsorĩkaãta iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria kenakotakasaakiri soti auĩte nĩkatakani sãpiretakiti, oa ãkixinireẽ onĩkatari ikara ene. !Omaxinĩkaretari ninoa sãpiretakiti. Oxinikapikari. ");
INSERT INTO apuNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Eereka pirãtxi nĩkatakani kanapiriã ipiraakori auinimoni. Imisãkiretakakana: —Peerekari Teoso. Apiananiri iua, kotxi erekapitikari aĩtikakiti. Erekapitikari initiri iaxitikiri sãpiretakiti. Isãpiretakiti atãopitika, kotxi aãtamatari isãpiretakiti iaõka —itxanãtana ninoa soti auĩte nĩkatakani. ");
INSERT INTO apuNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Xesosi oito õti auakasaaki, inirimane kamari Teoso takaõtxikare iĩtoã. Iuasaaki inirimane takauãkatari Xesosi, kotxi iua iaõka Teoso nitiri iaxitikiri sãpiretapekaro Maria oa kamixi oinini apisapanika. ");
INSERT INTO apuNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisesini ketotiniri manapi Xosee, Maria pakini kamari Moisesini paniãtakiti iaõka amarini auakasaaki, Xosee, Maria pakini maerekani Teoso makatxakini ĩkapani. Ikara xipoka atoko anikarina Xesosi Xerosareẽ sitatxitimoni Apiananirimoni isikinirina ĩkapani, ");
INSERT INTO apuNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kotxi Apiananiri paniãtakiti iõkatsopatakori txari: Merepitipanika iponaniãkari sikaãkako Teosomoni, kotxi Teoso nakiti iua. ");
INSERT INTO apuNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Apaka Apiananiri paniãtakiti iõkatsopatakori txari: Amarini iponaniãkasaaki, ipi kamoa pisika Teosomoni. Iminakaniã, ipi kamoa ãkiri pisika Teosomoni, itxa Teoso. Ininiã Xosee, Maria pakini sari Xerosareẽ kamoa isikinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Iuasaaki kiki Simião inakori aua Xerosareẽ. Iua erekari kamakari. Ikinipoko Teoso paniãtakiti ikama. Erekari Matamatakoti auari ãkixinireẽ. Ãkixinireẽ iãtapanãtapikari Teoso Mereẽkiti apokini, kotxi Isaeo auakani maerekani makatxaãkari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Erekari Matamatakoti sãpiretapekari iua: “Pipinini apisa paõkitapanikariko Apiananiri Mereẽkiti,” itxari Simião. ");
INSERT INTO apuNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Erekari Matamatakoti sikanireõtari Simião aiko Teoso misãkiretiko aikoti ĩroini. Iuasaaki Xosee, Maria pakini ĩroã iuaãtaã, Apiananirimoni Xesosi isikinina ĩkapani, Teoso paniãtakiti ikaminina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Iuasaakipeka Simião apakapari Xesosi: —Peerekari Teoso. ");
INSERT INTO apuNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Niauĩte Apiananiri, uatxa apokapeka ia amarini pisikaenetakiti. Nota pite ĩkapani parĩkauatakarino. Uatxa niposotari nipinini erekaxinirepeka ninini, ");
INSERT INTO apuNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kotxi nota atamatari ia amarini piokanatakiti atemoni, amaerekani imakatxakini ĩkapani, amapinakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Pite iokanatapekari ia ĩkorapokoriti ikini itixiti auakani maerekani imakatxakini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ia amarini tirikapi atoko, kotxi iopinikariko pikimapore, pisãkire Xoteo minakaniua imarotini ĩkapani. Ia amarini tirikapi apiatakari atoko Xoteoakorimoni pinakitiakorimoni, kotxi oerekai pite ninoamoni —itxa Simião sãkire Teosomoni. ");
INSERT INTO apuNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Xosee, Xesosi inoro apaka tsorĩkaãnãta ikara Simião sãkire ikenakotakasaakina. ");
INSERT INTO apuNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simião amanaãri Teoso ikinipoko erekari ninoamoni isikini ĩkapani. Eereka imisãkiretaro Maria, Xesosi inoro: —Teoso mereẽri ia amarini Xoteoakorimoni iokanatiniri ĩkapani. Ia apakapakari Teoso apakapa apaka. Ia mapakapakati Teoso !apakapari. Imisiritaãkako. Ia amarini oerekari Teoso kãkitimoni, txamari itori kãkiti !auikari isãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ikara atoko ininiã, itori kãkiti xiniãkiti kipatakori ãkixinireẽ, imarotaãkako. Pitepekana pite matinaniuatako. Pãkipa iouata iorotini tsii atoko itxako —itxa Simião sãkire Mariamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Iuasaaki oãua sito Teoso sãkire sãpiretakaro Ana inakoro. Panoeo ãkero oa. Oãtokiri kitxakapirĩka Asee inakori. Iuasaaki kiomãtxipekaro oa. Oãua setxi ano õtanirikata. Eereka ipĩpe. ");
INSERT INTO apuNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","!Oĩtaniriuataika. Oitẽta koatrokananipeka oãuini. Oa auapika Teoso misãkiretiko aikoti ãki. Iuaã ikini õti, ikini ĩkanõkati pakini omisãkiretapikari Teoso. Itokata otakanapari onipokotini Teoso omisãkiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Xosee, Maria pakini Simião misãkiretaka atoko Ana apoka. Omisãkiretari Teoso: —Erekapitikari ia amarini pimereẽkiti kãkiti iãtapakiti piokanatini atemoni —otxa. Eereka osãpirenauata Xesosi apokini pirena Xerosareẽ auakanimoni kãkiti maerekani makatxaãkari iãtapakanimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Xosee, Maria pakini Apiananiri paniãtakiti iõkatsopatakori imakinika ikamaãkana atoko, kanapiriã itxana Kariréia tõpamoni. Iuaã isana aapokomonina Nasaree sitatxitiã. ");
INSERT INTO apuNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Iua amarini aneẽ. Itapara auaãpotari. Kimaroreri itxaua. Teoso iteene tiretari iua Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ikinikanani Xosee, Maria pakini sari Páskoa kiiniritimoni Xerosareẽ sitatxitimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Xesosi tosi anopeka inakasaaki, isana Xerosareẽ auakari kiiniritimoni mitxi isanãtinina atokokana. ");
INSERT INTO apuNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kiiniri xipoka atoko Xosee, Maria pakini potorika aapokomonina isinina ĩkapani. Iuasaaki Xesosi kaikota Xerosareẽ. Txamari ninoa !imarotari ikaikotini. ");
INSERT INTO apuNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ninoa uãkatamari apanakini inirimanekata isini. Ikara atoko ininiã, ikimaporitana ãti õtipeka. Mapiãnikata ipixinipokoriti initamarina inirimanemoni, aõkimaneremoni. !Apokarina. ");
INSERT INTO apuNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ininiã ikanapiriãna Xerosareẽmoni iuaĩkana initinirina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ipi, ãti pakini õti initapiimarina. !Apokarina Xesosi. Eereka apokarina Teoso misãkiretiko aikoti ãki. Moisesi sãkire oerekakanikata iitopãkanãta. Xesosi kenakonãtari ninoa sãkire. Apaka ipimarauata. ");
INSERT INTO apuNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ninoa Xesosi sãkire kenakotakani tsorĩkaãnãta, kotxi paimatireri iua. ");
INSERT INTO apuNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Xosee, Maria pakini apokasaakiri iua, kona imarotarina Xesosi parĩka. Inoro txari: —Namarite, kinirepa pimisiritaua ate? Piri, nota pakini pikamamaxirexiniretaua ate. Anitapiimai. Kona aãpokai —otxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ininiã Xesosi: —Kinirepa hinitanãtano? Kona himarotatari uai niri aapoko ninirekari nauini, ipaniãtakiti nikamini ĩkapani —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Txamari ninoa !imarotari Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ikara atoko ininiã, Xesosi kanapiriã ninoakata Nasaree sitatxitimoni. Ikinika Xosee, Maria pakini sãkire ikĩpita. Inoro xinikapikari Xesosi sãkire oãkixinireẽ. Opotxitari oxinikiniri Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Xesosi aneẽ. Imatire apaka aneẽ. Teoso apokaerekatari Xesosi. Kãkiti apaka apokaerekatari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Homa sitatxitiã Homanoakori auĩte Txipério inakori iua. Kĩsi anokananipeka iua auĩtetxi ininiua iuasaaki. Iuasaaki Xotéia tõpa auakani auĩte Põsio Pirato inakori. Kariréia tõpa auakani auĩte Erotxi inakori. Erotxi itari Piripi inakori. Itoreia tixini auakani auĩte, Takonitxi tixini auakani auĩte apaka itxaua Piripi. Iuasaaki Apireni auakani auĩte Arisánia inakori. ");
INSERT INTO apuNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Iuasaaki Anasi inakori, Kaipasi inakori pakini sasetotxi auĩteakori apiatakani itxauana ninoa. Iuasaaki Teoso sãpiretari isãkire Xoãomoni Sakaria ãkirimoni, ãparaã makipakaniãtaã auakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ininiã Xoão sari ikininape kãkitimoni, uini Xotão takote auakanimoni. Isãpiretari Teoso sãkire: —Hĩtakanapariko himaerekani. Eereka patxisata hinaãkako. Ikara atoko hininiã, Teoso makatxakinii himaerekani —itxanãta Xoão ikininape kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kitxakapirĩka Teoso sãkire sãpiretakari Isaía inakori iõkatsopatari: Auako kiki ãparaã makipakaniãtaã. Isãpirenauatako. Itxariko: “Hõeretariko kimapori Apiananiri apokini apisapanika. Itĩkaãpo erekari hĩkamako iua napini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kipatxiã ixãpokakaãkako ikini isauana. Ixirata miriĩ oerekataãkako. Kimapori ikitokare oerekataãkako. Kimapori pakota totaãkako. ");
INSERT INTO apuNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ikinimane kãkiti itixi auakani imarotariko Teoso makatxakiniri kãkiti maerekani imapinakani ĩkapani,” itxanãta. Ikara atoko itxa Isaía iõkatsopatakiti Xoão pirena. Kimapori kãkiti oerekatini atokokana, auĩtetxi apokini apisa, iua atokokana Xoão nirekari kãkiti iposope inini Apiananiri apokini apisa, imaerekanina itakanapinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Itomaneri kãkiti sari Xoãomoni ipatxisatikona ĩkapani. Ininiã Xoão: —Imini katsiiri anaakorirai hĩte. Teoso misiritapitikai himaerekani xika. Himitekini !auari. Hinirekari hĩpatxisatiko, txamari !hinirekari hĩtakanapiniri himaerekani. ");
INSERT INTO apuNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hinirekiniãri himaerekani hĩtakanapini, ininiã hĩkamariko erekari. Ikara atoko ininiã, hõerekari Teoso atão hĩtakanapiniri himaerekani. Hãkixiniremoni !hĩxinikapiri: “Teoso apakapapitikauako ate, kotxi ate atokirini Apraãoni txaua,” !hĩtxapeko. Ari, nota sãpiretai hĩte, Teoso nirekiniãri, iposotari ia kai soroã Apraãoni mekaniriakori ikamini. Kona Apraãoni posotari anikinii Teosomoni. ");
INSERT INTO apuNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aamina maereka iriti atoko hĩtxa. Teoso iposopeka hĩte ixipokini. Kãkiti auari ikitaite kauanari aamina maereka iriti itokini ĩkapani. Ikinika aamina maereka iriti tokaãkako. Xaminaã oka inaãkanako. Teoso kamakiti iua atokokana itxa. Ininiã Teoso kitaite kauanapeka, aamina kotsa sauakiko tĩkane. Iua atokokana ininiã, Teoso aiamatapeka hĩte ixipokini ĩkapani —itxa Xoão ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","—Ikara atoko ininiã, kipa akama Teoso mamisiritakaniua ĩkapani? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ininiã Xoão apakapapireta: —Pimãka kauanata ipi auiniãi, ãti pisika mãkatxi kauanata mauakinitimoni. Nipokori auiniãi, pisikari nipokori mauakinitimoni —itxa Xoão sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kikiãkini, txineiro apakapakani Homano auĩte nitiriakori, apoka apaka ipatxisatikona ĩkapani. —Koerekareri, atepekana, kipa ate kama Teoso mamisiritakaniua ĩkapani? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ininiã Xoão: —Kãkiti txineirote himakatxakakito, Homano auĩte nireẽkito iaõka himakatxakako. Apikomoni !himakatxakapero —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ãtikaka sotatoakori apaka pimaãri: —Atepekana, kipa ate kama amaerekani atakanapini ĩkapani? Ininiã Xoão: —!Himaĩkapiri kãkiti, itxineirote himixirikini ĩkapani. Kona ãti maxikatiĩka !hãpoĩtape. Hĩpoxokoniuatako txineiro hãpakapakitoã hĩparĩka ĩki. !Hinirekapero apikomoni —itxa sotatoakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Iuasaaki kãkiti iãtapanãtari Teoso mereẽkiti apokini. Ininiã Xoão sãpiretakiti ikenakotakasaakina, ãkixinireẽna ixinikarina: —Xoãokani Teoso mereẽkiti txataua atxiĩti? —itxanãtana ixinikanãtakitina. ");
INSERT INTO apuNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ininiã Xoão: —Ãparaaãnokara nipatxisatai hĩte. Nota tikini apoãkari patxisataiko hĩte Erekari Matamatakotiã, xaminaã pakini. Apiatakari itxaua iua. !Apakata iua takote napokini ikiti mata nimakatxakini ĩkapani, kotxi iua apiata. Nota poiãoka. Imakatxakari himaerekani, itxiko metao ãki auakari arikini atoko. ");
INSERT INTO apuNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Katakareri ãpokari ahoisi otãta imakatxakini ĩkapani. Otãta arikaãka. Oki nĩkataãka ikiena nĩkatikoãtaã. Iua atokokana Teoso nĩkatariko kãkiti erekarini. Maerekati kamakani arikaãkako xamina maxipoãkatiã. ");
INSERT INTO apuNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ikara atokora itxa Xoão sãpirena õtãkikinina kãkiti. Isãpiretari erekari pirena Teoso pirena kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ãti õti Xoão pinitari Erotxi, Kariréia auakani auĩte: —Pitakiniãro pitari Piripi ĩtanoro Erotxia inakoro, maerekati pikama. Apaka apikomoni maerekati pikamapitipo —itxa Xoão. ");
INSERT INTO apuNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ininiã iuasaaki iuaĩkana Erotxi kamari maerekati, kotxi itakari Xoão kateia ãki isãkire imapokaerekatakani xika. ");
INSERT INTO apuNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Xoão Erotxi maĩkini apisapanika ikinimane kãkiti ipatxisatakasaaki, Xesosi apaka patxisataãka. Iuasaaki Xesosi sãkirauatakasaaki Teosokata, iaxiti takaka. ");
INSERT INTO apuNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Erekari Matamatakoti katxaka Xesosi nopini. Kamoa katxakini atoko itxa ikatxakini. Iuasaaki ikenakotaãka iaxitikiri sãkire: —Pite namarite, nitiretakiti, napokaerekatai, kotxi ninirekakiti pikama —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iuasaaki Xesosi potorika iparĩkauatini Teoso ĩkapani. Trĩta anokananipeka itxaua iuasaaki Xesosi. Kãkiti uãkatari iua Xosee ãkiri ininiãua. Xosee iri Erii. ");
INSERT INTO apuNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Erii iri Matatxi. Matatxi iri Arevii. Arevii iri Meokii. Meokii iri Xanai. Xanai iri Xosee. ");
INSERT INTO apuNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Xosee iri Matatxia. Matatxia iri Amosi. Amosi iri Naoõ. Naoõ iri Esirii. Esirii iri Nakai. ");
INSERT INTO apuNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai iri Maatxi. Maatxi iri Matatxia. Matatxia iri Semei. Semei iri Xosee. Xosee iri Xota. ");
INSERT INTO apuNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Xota iri Xoanaã. Xoanaã iri Hesa. Hesa iri Soropapeo. Soropapeo iri Saratxieo. Saratxieo iri Nerii. ");
INSERT INTO apuNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerii iri Meokii. Meokii iri Atxii. Atxii iri Kosaã. Kosaã iri Eomataã. Eomataã iri Eri. ");
INSERT INTO apuNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri iri Xosoee. Xosoee iri Eriesa. Eriesa iri Xoriĩ. Xoriĩ iri Matatxi. Matatxi iri Arevii. ");
INSERT INTO apuNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Arevii iri Simião. Simião iri Xotaa. Xotaa iri Xosee. Xosee iri Xonaã. Xonaã iri Eriakiĩ. ");
INSERT INTO apuNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriakiĩ iri Mereaa. Mereaa iri Mena. Mena iri Matata. Matata iri Nataã. Nataã iri Tavii. ");
INSERT INTO apuNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tavii iri Xesee. Xesee iri Opetxi. Opetxi iri Póasi. Póasi iri Sáomõ. Sáomõ iri Nasoõ. ");
INSERT INTO apuNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoõ iri Aminatapi. Aminatapi iri Átximĩ. Átximĩ iri Anii. Anii iri Ésirõ. Ésirõ iri Péresi. Péresi iri Xotaa. ");
INSERT INTO apuNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Xotaa iri Xakoo. Xakoo iri Isaki. Isaki iri Apraão. Apraão iri Tera. Tera iri Nakoo. ");
INSERT INTO apuNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakoo iri Seroki. Seroki iri Hakaoo. Hakaoo iri Pareki. Pareki iri Epi. Epi iri Sara. ");
INSERT INTO apuNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sara iri Kainaã. Kainaã iri Apaxatxi. Apaxatxi iri Seĩ. Seĩ iri Noee. Noee iri Arameki. ");
INSERT INTO apuNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Arameki iri Metosareẽ. Metosareẽ iri Enoki. Enoki iri Xaretxi. Xaretxi iri Marereo. Marereo iri Kainaã. ");
INSERT INTO apuNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainaã iri Enosi. Enosi iri Setxi. Setxi iri Adão. Adão iri Teoso. Imapotõkirepe. ");
INSERT INTO apuNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Xesosi ipatxisatiko atoko, Erekari Matamatakoti iteene sikaposotiiretari iua. Erekari Matamatakoti txĩkitakari Xesosi uini Xotão itakanapini, ãparaã makipakaniãtaã isini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Iuaã koarẽta õti auakasaaki, Satanasi atamakaerekatari Xesosi. Koarẽta õti manipokotakatinoka itxa Xesosi. Ininiã natxinoka itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ininiã Satanasi txari: —Pite Teoso ãkiri pitxaua, ininiã ia kai soro komiri pitxĩkitaka —itxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ininiã Xesosi apakapapiretari: —Kona, kotxi Teoso sãkire iõkatsopatakori txari: Kona komirinanini txĩkitakari kãkiti ãtipirika auini tĩkane. Ikinika Teoso sãkirera txĩkitakari kãkiti ãtipirika auini tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ininiã iuasaaki Satanasi anikari Xesosi ixirata nopinixiti. Iuaã pakoteri oerekiniri ikinimane tixine. ");
INSERT INTO apuNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ininiã Satanasi: —Nota posotari nisikinii ikinimane auĩtetxiakori posotiire. Ikinipoko ninoa txineirote apaka niposotari nisikinii. Merepitipanika notamoni isikaãka ia posotiiretxi, ininiã nota sikari ninirekaãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ikara atoko ininiã, piteosonetiniãno, ia posotiiretxi nisikai pite —Satanasi txari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ininiã Xesosi: —Konapitini. Pisipeka Satanasi. Teoso sãkire iõkatsopatakori txari: Apiananiri piTeosone. Iuanokara piteosoneta. Iua ĩkapaninokara piparĩkauatako. ");
INSERT INTO apuNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Eereka Satanasi anikari Xesosi Xerosareẽmoni, aiko Teoso misãkiretiko nopinixiti. Itanoxiti paĩtanori. Pamonõkoniri. Iuaã itxari: —Teoso ãkiri pininiãua, pokaua xiti. Ininiã ikinipoko kãkiti imarotariko Teoso ãkiri pininiãua, ");
INSERT INTO apuNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kotxi Teoso sãkire iõkatsopatakori txari: Teoso iokanatanako initiriakori iaxitikini pite inĩkatinina tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ninoa maĩkai pimapinakani tĩkane, ininiã pikarouatini !auari. Kona kai soro karotari pikiti, itxa Teoso sãkire —Satanasi txari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ininiã Xesosi: —Teoso sãkire iõkatsopatakori apaka txari: Kona patamakaerekatapiri Apiananiri piTeosone, —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Iuasaakipeka Satanasi atamakaerekatiniri Xesosi xipope. Ininiã itakanapari Xesosi ãti õti iuaĩkana ikanapiriini iuamoni ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ikara inaãka atoko Xesosi kanapiriã Kariréia tõpa auakanimoni. Paposotiireri, kotxi Erekari Matamatakoti auari iuakata. Iua pirena iaripireta ikini Kariréia tõpa auakanimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iua oerekarauata aiko ãki Xoteo apotiitiniãtaãua. Ininiã ikinimane txari: —Peerekari iua, kotxi erekapitikari iua sãpiretakiti —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Eereka Xesosi sari Nasaree sitatxitimoni. Iuaã Xesosi aneẽ mitxi. Xoteo tomatini õtisaaki Xesosi itotapekari aiko Xoteo apotiitiniãtaãua isini. Ininiã iuasaaki, Xoteo tomatini õtisaaki isari iuaã. Iuaãtaã itima Teoso sãkire iõkatsopatakori atatsopatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Teoso sãkire sãpiretakari Isaía iõkatsopatakiti tsopa isikaãka. Ininiã imatakireẽri aãtsopa. Ia Teoso sãkire inita, atatsopata itxa: ");
INSERT INTO apuNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—Erekari Matamatakoti notakata aua, ininiã Apiananiri mereẽno nota matxineirotenimonikari erekari pirena nisãpiretini ĩkapani. Iokanatano kateia ãki auakani nisikakini ĩkapani. Iokanatano mõsiãrenimoni iuaĩkana atamarauatinina ĩkapani. Iokanatano misiritakonimoni, ninoa misiritakani nixipokini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ipaniãtano kãkiti nisãpiretini: “Ĩkorakanani Teoso apokapeka kãkiti maerekani imakatxakini ĩkapani, imapinakanina tĩkane.” Ikara atatsopata Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Aãtsopa iapirikaãka atoko, sika itxari sasetotxi nitirimoni. Ikara inaãka atoko Xesosi topãka. Imakinika kãkiti aiko Xoteo apotiitiniãtaãua ãki auakani, imakinikana atamatari Xesosi, isãpiretakiti kinirão kenakotaka inakani. ");
INSERT INTO apuNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ininiã Xesosi sãpiretana: —Ikara Teoso sãkire hĩkenakotakiti apokapeka uatxa —itxa ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ikinimane kãkiti sãpirenauata Xesosi ereka inini. Itsorĩkaãnãtana isãkire erekari ikenakotakasaakina: —Kiãtokopa ininiãpa imarotatari ikara atoko inakari isãpiretini? Kotxi Xosee ãkirira iua, minakati ãkirira iua —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ininiã Xesosi txana ninoa: —Atxiĩti hĩte txanoko nota imatiretxi kitxakapirĩka kiomãtxiakori sãkire. Ninoa txari: “Pinĩtxi imarotakari pininiãua, piteka pipitaua.” Atxiĩti hĩxinikanãtari: Kapanaoõ sitatxiti nauakasaaki, nikamari posotiiretxi iuaãtaã. Kinirepa na nikamatari posotiiretxi uai nauiniãtaã? Ikara atoko atxiĩti hĩxinikanãta. ");
INSERT INTO apuNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Atão nisãpiretai, kãkiti Teoso sãkire sãpiretakari inirimane sauaki auakasaaki, inirimane !auikari isãkire. Ia xika kona nikamari posotiiretxi uai. ");
INSERT INTO apuNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Atãopitika nisãpiretai hĩte. Kitxakapirĩka Teoso sãkire sãpiretakari Eríasi inakori auakasaaki, ipi ãti pakini ano ipixini ano pakini ãparaã !ikipa. Iuaã Isaeo tixini natxinoka aua. Iuasaaki kaiãopokoro sitoakoro tikinitakoro auari iuaãtaã. ");
INSERT INTO apuNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Iuaritika Teoso !iokanatari Eríasi ninoa ikininapemoni. Iokanatari ãtoka sitomoni tikinitakoromoni, nipokori isikiniro ĩkapani. Oa sito aua Sarepita sitatxiti Sitoõ tõpa, Isaeo tixini takote. Xoteo !otxaua oa. ");
INSERT INTO apuNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","—Ikara atokotxikana itxa Teoso sãkire sãpiretakari Eriseo inakori. Iua auakasaaki, kaiãopokori amianatakani maere matati Isaeo tixini auakani aua. Kona imakinikani erekapeka inaãkana. Kiki Naamaã inakori Síria tixini auakari, iuanokara erekapeka itxĩkitakaãka. Iua Naamaã kona Xoteo !itxaua iua —itxa Xesosi ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ikinimane aiko ãki apotiitakaniua, ikara ikenakotakasaakina, iteene inaiatauana. ");
INSERT INTO apuNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ininiã ikosekaĩtotarina Xesosi sitatxi mapotõkiremoni. Anikarina ixirata nopini sitatxi auiniãtaã. Iuaã inirekarina Xesosi okinina ixiratamoni ipinini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Txamari Xesosi napari ninoa sauaki, ĩkorape itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Eereka Xesosi sari Kapanaoõ sitatxitimoni Kariréia tõpa. Iuaã tomatiko õtisaaki oerekana kãkiti Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kãkiti iuaã auakani tsorĩkaãnãta oerekakiti ikenakotakasaakina, kotxi paimatireri iua. Isãpiretakiti atãonoka itxa isãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Iuasaaki aiko ãki kãkiti apotiitiniãtaãua, aua kiki maerekati matamatakoti auaĩtotakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Iua kiki ãkixinire auakari akiripoakata: —Xesosi Nasareekiri, kipa ĩkai uai? Kiãtokopa pitxataua ate? Atxiĩti papoka ate pixipokini ĩkapani? Nota imarotai pite. Pite maerekati mauakiniti pite. Teoso nakiti pitxaua pite —itxa maerekati matamatakoti Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ininiã Xesosi txitari iua. !Auiritari isãkirauatini: —Maãtako. Posipikari ere kiki —itxari. Ininiã maerekati matamatakoti iriãkatari iua kiki ikinimane okiãtaã. Ininiã itakanapari iua, makarotika itxa kiki. ");
INSERT INTO apuNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kãkiti iuaãtaã tsorĩkaãnãta. Imisãkiretakakauana: —Ĩkora kiki paposotiireri isãkire. Itapararitika ipaniãtari maerekati matamatakoti sini, ininiã nãkorape itxapena maerekani matamatakoni. ");
INSERT INTO apuNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ininiã Xesosi pirena iua tõpa iaripireta. ");
INSERT INTO apuNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Eereka Xesosi potorika aiko Xoteoakori apotiitiniãtaãua. Simão aapokomoni isa. Iuasaaki Simão imakiro iteene oãpoomata. Ininiã amanaãrina Xesosi oa erekape inĩkitakini. ");
INSERT INTO apuNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ininiã ipapĩka oamoni: —Nipaniãtari apoomari iotokini —itxa. Ininiã apoomari iotoka. Iuasaakipeka oa õkitikaua, nipokori osikana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Atokatxi ereẽkokaãpotapeka inakasaaki, kãkiti anikana amianatakani ikinipoko amianari auakini, Xesosimoni. Itakari iuako amianatakani nopini. Iuasaakipeka ninoa erekapeka itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Omitikari maerekati matamatakoti kãkiti ĩtoã auakari apaka. Osipikasaakina, akiripoakatana: —Pite Teoso ãkiri pitxaua. Ininiã Xesosi txitana ninoa. !Auiritaikana akiritinina, kotxi ninoa imarotari Teoso mereẽkiti ininiãua Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Katimatinĩkata Xesosi sari kãkiti mauakaniãtaã. Iuasaaki kãkiti nitanãtari iua. Apokasaakirina, amanaãrina Xesosi: —Pikaikota atekata —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Txamari Xesosi txari: —!Apakata uai nikaikotini, kotxi ãtiãtaã apaka nisãpiretariko erekari pirena Teoso auĩtetxi ininiãua pirena. Ikinimanemoni ikara nisãpiretini ĩkapanira, Teoso iokanatano kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ikara atoko ininiãra, isãpirenauata ikininape aiko ãki Xoteoakori apotiitiniãtaãua ikinipoko Xoteoakori tixine. ");
INSERT INTO apuNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ãti õti Xesosi auanãta Xenesaree inakori poa tinikata. Xenesareetxikana Kariréia poa. Ipi iuãka aua. Iuasaaki kãkitipokoni ãkitari iua Teoso sãkire ikenakotinina ĩkapani. Iuakatapeka xãpoka itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iuasaaki Xesosi atamatari ipi kanaua ioporoko. Kokatsaãriti kanauate. Ninoa imiriĩ arokanãtari hetxi. ");
INSERT INTO apuNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Xesosi iereẽtaua Simão kanauate ãki: —Pikatika pikanauate amaãtiki apanĩkakiã —itxa Simãomoni. Eereka iitopãka kanaua ãki. Iuaãtaã isãpiretari Teoso sãkire kãkitimoni imiriĩ apotiitakanimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Isãpirenauataka atoko itxari: —Apanĩkakiã pimekota. Iuaãtaã pitakari hetxi kãuaãriã —Xesosi txari Simão. ");
INSERT INTO apuNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ininiã Simão: —Koerekareri, hetxi atakapikama ĩkanõka. Iteene aõkatsaãkatapiikama. Txamari na xatiki ximaki amaĩka. Kona ãtika amaĩka. Iuaritika pite paniãtiniãno, iuaritika nitakapitikariko hetxi —itxa Simão. ");
INSERT INTO apuNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hetxi ninoa takasaaki kãuaãriã, ximakipokoni imaĩkana, ininiã hetxi tsorakiarita. ");
INSERT INTO apuNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ikara xika akiritana imoianariakori ãti kanauate ãki auakani: —Ãpina. Himoianataua ate. Hetxi tsorakiãpotanapanoka. Ininiã ninoa ina. Ikinimane kosekari hetxi. Ximakipokoni. Ipi kanaua xãpoãkata ximakinoka. Ximaki xika kanaua sakikaarita. ");
INSERT INTO apuNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simão Petro atamatakasaakiri ximakipokoni, ikapotoreẽkaua Xesosi apisatoõ: —!Pikaikotape nota takote, kotxi erekai pite. Maerekati kamakarino nota —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ikara atoko itxa Simão sãkire, kotxi iua, imoianariakori apaka tsorĩkaãta kaiãopokori ximaki ninoa maĩkakiti xika. ");
INSERT INTO apuNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simão moianariakori Txiako, Xoão pakini, ninoa apaka tsorĩkaãta. Txiako, Xoão pakini Sepeteo anaakori. Ininiã Xesosi txari Simão: —!Pipĩkarauatape. !Pimaĩkaikari ximaki. Ãtião piparĩka auako. Nisãkire pisãpiretako kãkitimoni —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Eereka ninoa apokitaãka atoko, ikinika itiina itakanapana, Xesosikata sa itxana imiparĩkatinirina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ãti õti Xesosi auanãta ãti sitatxitiã. Iuaã auakasaaki, aua kiki maere matati. Atamatakasaakiri Xesosi, ikapotoreẽkaua, iãka Xesosi apisatoõ. Iteene amanaãri Xesosi: —Apiananiri, pinirekiniãri, piposotari nota ereka pitxĩkitakini —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ininiã Xesosi maãtakari iua: —Ari ninirekapitikari. Erekapekai —itxari. Iuasaakipeka erekapeka itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ininiã Xesosi paniãtari: —!Pisãpiretapiri apanakini ereka nitxĩkitakinii. Pisa sasetotximoni. Poerekari piĩto iuamoni, ininiãkara itxai: “Atãopitika erekapekai pite.” Eereka pisikari Teosomoni Moisesi paniãtakiti iaõka. Ikara atoko pikaminiã, ikinimane imarotari pite atão ereka pininiãua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Xesosi paniãtari iua apanakini imasãpiretakani, iuaritika Xesosi pirena apikomoni iaripireta. Ininiã kãkitipokoni sari iuamoni isãkire ikenakotinina ĩkapani, amianari imakatxakini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ininiãkara Xesosi itotapekari iuanoka isini kãkiti mauakaniãtaã Teosokata isãkirauatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ãti õti Xesosi sãpirenauata. Iua takote pariseoakori, kaiõkatsoparerini apaka topãkanãta. Ninoa Kariréia tõpakini, Xotéia tõpakini, Xerosareẽ sitatxitikini pakini. Iuasaaki Xesosi sãpirenauatakasaaki, Apiananiri sikaposotiiretari Xesosi amianatakani erekapeka itxĩkitakini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Iuasaaki kikiakori apoka iuaã. Iminarina kiki matĩpokotakatinoka inakari. Isirimata nopini iminarina. Inirekarina aapokotxi ãki ĩroinina, Xesosi apisatoõ iua matĩpokotakati itakinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Txamari !apakata ninoa ĩroini, kotxi kãkitipokoni xãpoka. Ininiã ikanĩkana kanikoatxiã aapokotxi nopini. Imakatxakarina itano auakari kipatxi kai kamakori, eereka isikakaãpotarina iua matĩpokotakati isirimata nopini Xesosi manapi kãkiti sauaki. Xesosi apisatoõ apoka. ");
INSERT INTO apuNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ininiã Xesosi imarotari ninoa auikiniri iua posotiire. Ininiã itxari matĩpokotakati: —Namarite, pimaerekani makatxakapeẽkaika. ");
INSERT INTO apuNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Iuasaaki pariseoakori, kaiõkatsoparerini pakini tsorĩkaãnãta. Ãkixinireẽna ninoa: —Teosonokara posotari amaerekani imakatxakini. Maerekati Xesosi kama Teosomoni —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Xesosi imarotari ninoa xinikakiti ãkixinireẽna, ininiã Xesosi txana: —!Erekari hãkixinireẽ ikara hĩxinikakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nitxari iua imaerekani nimakatxakini, txamari !himarotari imaerekani atão nimakatxakini. “Põkitikaua. Pitĩpokota,” nininiã, ininiã himarotari nisãkire atão ininiãua, kotxi hĩtikari. Niposotiire imaerekani nimakatxakini ĩkapani, niposotiire iua nõkitikini ĩkapanitxikana. ");
INSERT INTO apuNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ininiã uatxaika noerekai hĩte. Teoso iokanatano nota hĩtari iaxitikirino ĩkorapokoritimoni kãkiti maerekani nimakatxakini ĩkapani. Ininiã ipaniãtari matĩpokotakati: —Põkitikaua. Pisirimata pikoseka, sipe pitxa paapokomoni —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Iuasaakipeka õkitikaua. Ikinimane kãkiti okiãtaã õkitikaua. Ikosekari isirimata, sipe itxa aapokomoni. Isikasaaki ipoxokoniuata. —Peerekari Teoso —itxaãpota iua. ");
INSERT INTO apuNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ikinimane kãkiti tsorĩkaãta. Ipĩkarauatana. —Peerekari Teoso. Mitxi !aĩtikari matĩpokotakati erekapeka txĩkitaãkari. Peerekari uatxa aĩtikakiti —itxanãtana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Eereka Xesosi tĩpokoãponãtakasaaki, atamatari kiki Arevii inakori. Iitopãkanãta iparĩkauatiniãtaã. Iuaã apakapari txineiro Homanoakori auĩte paniãtakiti kãkiti ãtiãtaã tiitxi anikini ĩkapani. Xesosi akiritari Arevii: —Ãpina, uatxa nimoianari pitxaua —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Iuasaakipeka Arevii õkitikaua. Ikinika itii itakanapa, Xesosikata sa itxa, Xesosi imiparĩkatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Eereka Arevii kamari kiiniri aapokoã Xesosi ĩkapani. Kiinirisaaki aua ĩkamanere kaiãopokori. Txineiro apakapakani aua kiiniriã. Ninoa apanakinikata nipokota Xesosikata Arevii aapokoã. ");
INSERT INTO apuNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pariseoakori, ninoakata parĩkauatakani, kaiõkatsoparerini pakini txitana Xesosi moianariakori, Xesosi txineiro apakapakanikata nipokotini xika. Ininiã ninoa txari: —Kinirepa hĩte nipokota txineiro apakapakanikata, maerekati kamakanikata? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Xesosi apakapapiretana: —Kãkiti mamianatakani !inirekari pinĩtxi siãkarimoni isinina. Amianatakarinoka nirekari pinĩtxi siãkarimoni isini. ");
INSERT INTO apuNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iua atokokana, nota ina ĩkorapokoriti kona kãkiti “Atão inakarinoka kamakarino” ĩkapanini, kotxi ninoa uãkatari atão inakarinoka ikaminina, txamari !ikamarina atão. Kãkiti maerekati kamakani ĩkapanira nina nota uai imaerekani itakanapini ĩkapani. Nota pinĩtxi siãkari atoko inakarino nota —itxa Xesosi sãkire iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kãkiti txari Xesosi: —Xoão kapatxisareri moianariakori itokata takanapari inikinina Teoso imisãkiretinina ĩkapani. Iua atokotxikana itxa pariseoakori moianariakori. Txamari pite moianariakori !itakanapari nipokori, iãriã, Teoso imisãkiretinina ĩkapani. Kinirepa? —itxana kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ininiã Xesosi apakapapiretana: —Kiki ĩtaniriuatini pirenasaaki erekari atxiĩti kemaĩtxitakoni manikakaniãri nipokori? !Erekari. Ninoa poxokoniuata imoianari ĩtanirauatini, ininiã inipokotapitikana. ");
INSERT INTO apuNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Txamari ãti õti ninoa moianari maĩkaãkako, oka inaãkako. Iuasaakiko ninoa takanapari inipokotini, kotxi imatinaniuatana. Iua atokotxikana nota. Nota auapanika nimoianariakorikata. Ãti õti nokaãkako. Iuasaakiko ninoa takanapari inipokotini Teoso imisãkiretinina ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Eereka Xesosi sãpiretari sãpirenatxi, atão inakari oerekiko. —!Pikitsorãkitari mãkatxi amaneri, kitxakari pitãpanetini ĩkapani. Ikara atoko pikaminiã, mãkatxi amaneri pioanata. Mãkatxi mata amaneri ĩsapekata piotsainiã, mãkatxi kitxakari tsorakita iuaĩkana. ");
INSERT INTO apuNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kãkiti kitakari ovaã sako aamata kamakori ãki. Ovaã amanero auiniã, !otakaãka aamata kitxakari ãki. Pitakiniãro aamata kitxakari ãki, aamata tsorakita. Ovaã xikepoatamako. Sako !otxaika. ");
INSERT INTO apuNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ovaã amanero pikitakako aamata amanero ãki. ");
INSERT INTO apuNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ovaã kitxakaro auiniã, kãkiti !inirekaro amanero, kotxi: “Ovaã kitxakaro apiaerekata,” itxa. Ikara atoko Xesosi txari kãkitimoni. Ikara sãkiretxiti Xesosi sãpireta, kotxi apanakini kãkiti itotapekari Moisesini sãkire, Teoso sãkire kitxakapirĩka isãpiretakiti, ininiã !inirekari Xesosi sãkire amaneri inakari. Ninoa mãkatxi kitxakari atoko. Sako kitxakari atoko ninoa. Ovaã kitxakaro atoko ninoa. Xesosi sãkire mãkatxi amaneri atoko. Ovaã amanero atoko itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Xoteoakori tomatini õtisaaki Xesosi imoianariakorikata motipetari kikio takari triko auiniãtaã. Ĩpiripetakasaakirina, imoianariakori makatxakaãpotari triko oki. Iuakoã ikotxokarona, ixõka itxarona otãta katxakini ĩkapani, okinoka nika itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ãtikaka pariseoakori itikana imakatxakinirona: —Kinirepa triko hĩkotxoka tomatiko õtisaaki? !Auiritaãka tomatiko õtisaaki parĩkauatiko —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ininiã Xesosi apakapapiretana: —Himarotari Taviini kamakiti kitxakapirĩka, iua imoianariakorikata natxitakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Iua ĩroã Teoso misãkiretikoãtaã. Iuasaaki imakatxakari komiri Teosomoni sikakori. Inikari, sika itxari imoianariakorimoni. Ninoa nikari apaka. Sasetotxinokara auiritaãka iua komiri inikinina. Apanakini !auiritaãka inikiniri. Iuaritika iua Taviini nikari. ");
INSERT INTO apuNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nota hĩtari iaxitikiri posotari ikinipoko ninireẽkiti nikamini tomatiko õtisaaki, kotxi Apiananiri nitxaua —Xesosi txana ninoa pariseoakori. ");
INSERT INTO apuNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ãti tomatiko õtisaaki Xesosi ĩroã aiko ãki Xoteoakori apotiitiniãtaãua. Oerekarauata. Iuasaaki iuaãtaã aua kiki iuako ikikomoni motĩkauakotakari. ");
INSERT INTO apuNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kaiõkatsoparerini, pariseoakori apaka aua iuaã. Atamatapikarina Xesosi, atauako erekapeka itxĩkitakapaniri motĩkauakotakari tomatiko õtisaaki. Inirekarina Xesosi kerokiniri. Tomatiko õtisaaki iparĩkauatiniã, ninoa apoĩtari iua. ");
INSERT INTO apuNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Xesosi imarotari ãkixinireẽna ixinikakitina, ininiã ipaniãtari kiki motĩkauakotakari: —Põkitikaua. Ãpina ikinimane okiãtaã. Ininiã iua kiki õkitikaua, sa itxa Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ininiã Xesosi pimaãna kaiõkatsoparerini, pariseoakori pakini: —Natokopa itxa Moisesini paniãtakiti iõkatsopatakiti tomatiko õtisaaki atão akamini? Ipaniãtataua maerekati akamini tomatiko õtisaaki? Ipaniãtataua erekari akamini tomatiko õtisaaki? Inirekatari amoianatiniri ãti imapinakani ĩkapani tomatiko õtisaaki? Inirekatari aõkaniuatini tomatiko õtisaaki? —itxa Xesosi ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","!Kasãkirena ninoa kaiõkatsoparerini, pariseoakori pakini. Xesosi atamatana ikinimane. —Piuako poerekata —itxari iua kiki. Oerekatari iuako. Iuasaakipeka iuako erekapeka itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pariseoakori, kaiõkatsoparerini pakini omanãkarauata. Imisãkiretakakauana Xesosi okinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ãti õti Xesosi kanĩka oxiratari nopini, Teoso imisãkiretini ĩkapani. Ĩkanõka ikaikota iuaãtaã Teosokata isãkirauatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Katimatinĩkata akiritana itomaneri imoianariakori iuamoni apokinina ĩkapani. Apokasaakina, imereẽna kikiakori tosi pakini kãkitimoni iokanatakini tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Imereẽna Simãoma, (Iuãka Petro apaka.) Ãtreema, (Simão itari) Txiakoma, Xoãoma, Piripima, Patoromeoma, ");
INSERT INTO apuNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateoma, Tomeema, Txiakoma, (Aopeo ãkiri) Simãoma, (Homano omanatakari) ");
INSERT INTO apuNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Xotasima, (Txiako ãkiri, ãti Txiakoti) Xotasi Isikariotxima (Xesosi mĩkapiritakari tĩkane) pakinima. Ninoa kikiakori tosi pakini Xesosi mereẽkini imoianariakori ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Eereka oxiratari iokiriiãpotana. Ipitexitimoni apokana. Iuaã aua kaiãopokori imoianariakori. Apanakini kãkiti iuaãtaã aua apaka. Xotéia tõpa ĩkani, Xerosareẽ sitatxiti ĩkani pakini auari iuaã. Apaka auari Txiro sitatxiti ĩkani, Sitoõ sitatxiti ĩkani apaka. Txiro, Sitoõ pakini potxoari uiniti ĩtinikata aua. ");
INSERT INTO apuNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ninoa kãkitipokoni sari Xesosimoni isãkire ikenakotinina ĩkapani, amianarena imakatxakini ĩkapani. Ninoa maerekati matamatakoti auaĩtotakini sari Xesosimoni maerekati imakatxakini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ikinimane nirekari imaãtakiniri Xesosi, kotxi imaãtakiniãrina, apakapari Xesosi tapara amianarena sini ĩkapani. Ininiã ikinimane amianatakani Xesosi maãtakakani iuaĩkana erekape itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Eereka Xesosi misãkiretana imoianariakori: —Hĩte matxineiroteni Teoso sikai erekari. Teoso hĩauĩte itxaua. Iua nakitiakori hĩtxaua. ");
INSERT INTO apuNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","—Hĩte ĩkorapokoriti natxitakani Teoso sikai erekari. Himitouatapanikako. —Hĩte ĩkorapokoriti txiapatakani Teoso sikai erekari. Hãpiapoxokonitapanikako. Hĩsiroatapanikako. ");
INSERT INTO apuNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","—Apanakini omanatiniãi hĩte, hĩtari iaxitikiri sãkire hãuikini xika, Teoso sikai erekari. Atxiĩti apanakini !nirekai. Atxiĩti apanakini misãkirepiretai. Atxiĩti ninoa akiritai “maerekati kamakari” nota hĩtari iaxitikiri sãkire hãuikini xika. Ikara atoko hinaãkako. ");
INSERT INTO apuNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","—Ninoa misiriãpotakasaakii, hĩpoxokoniuatako. Himĩteenekariko hĩpoxokoniritika, kotxi erekari Teoso nĩkatinii iaxiti itixine. Inĩkatakiti hĩte ĩkapani peerekari. Apanakini misiritinii atokokanera, ninoa atokiriakorini misiritari Teoso sãkire sãpiretakani kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","—Hĩte ĩkorapokoriti katxineiroterini misiritaãkako. Mitxi papoxokonii hĩte. Uatxa hĩpoxokoni !auaika. ");
INSERT INTO apuNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","—Hĩte ĩkorapokoriti ikiniõtika mitouanãtakanii misiritaãkako. Hinatxitapanikako. —Hĩte ĩkorapokoriti siroatakanii misiritaãkako. Himatinaniuatapanikako. Hĩtxiapatapanikako. ");
INSERT INTO apuNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","—Ikinimane: “Peerekai pite,” ininiã, himisiritaãkako, kotxi ninoa nirimane kitxakapirĩkarini sãpiretari ikara atoko inakari Teoso sãkire atão masãpiretakanimoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Iuaĩkana Xesosi sãpirenauata: —Nõtãkikai hĩte nisãkire kenakotakanii. Hĩtiretanako himokaiakari. Erekari hĩkaminana hĩte omanatakani. ");
INSERT INTO apuNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Himisãkiretariko Teoso erekari hĩte misãkirepiretakani isikini ĩkapani. Himisãkiretariko Teoso hĩte misiritakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kãkiti aritiniãi pikakota, ipinimoni pikakota iuaĩkana pisikana. Kãkiti anikiniãri pimãka õtanominari, pauiritari iua pimãka kauanata apaka anikini. ");
INSERT INTO apuNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pitii amanaãkarimoni pisika inirekakiti. Kãkiti anikiniãri pitii, !pamanaãpiri iuaĩkana imikanapiriiniri. ");
INSERT INTO apuNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ãti tiretinii pinirekini atokotxikana, pitiretari ãti. ");
INSERT INTO apuNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Pite tiretakaninani pitiretiniã, kinirepa Teoso sikari erekari pitemoni, pinirimanenokara pitiretakasaaki? Kotxi kãkiti maerekati kamakani apaka tiretari ninoa tiretakani. ");
INSERT INTO apuNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pimoianatiniãna pite moianatakaninani, !apakata, kotxi iua atokotxikana maerekati kamakari moianatana iua moianatakaninani. ");
INSERT INTO apuNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pisikiniãro pitxineirote, pitxineirote mikanapiriãkarimoninani, !apakata, kotxi iua atokotxikana maerekati kamakani sikaro itxineirotena apanakini maerekati kamakanimoni ãti õti iuaĩkana imikanapiriiniro ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Iua atokokana na pitxape. Pitiretariko pimokaiakari. Erekari pikaminariko. Inirekiniãri pitii iparĩkauatini ĩkapani, pisika iuamoni. !Pimaãkapeua, pitii iuaĩkana imasikakaniãi. Iua atokokana hĩkaminiã, Teoso sikai hĩte iteene erekari. Iua atokokana hĩkaminiã, Apiananiri iaxitikiri anaakori hĩtxauako, kotxi iua amonĩkari kãkiti maerekati kamakani. Ninoa !isãpiretari Teoso iua ereka inini, iuaritika Teoso amonĩkana. ");
INSERT INTO apuNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Piamonĩkariko ãti, aĩri Teoso amonĩkarauatini atokokana —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—!Papoĩtapiri ãti. Papoĩtiniãri ãti, ininiã pite apaka apoĩtaãkako. !Pisãpiretapiri ãti ikamakiti maerekati inini, ininiãkara Teoso !isãpiretai pite pikamakiti maerekati inini. !Pixinikapinikari maerekati ãti kamakiti pitemoni, ininiã Teoso !ixinikaikari maerekati pite kamakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pisikarauatako ãtimoni, ininiã Teoso sikarauata ito pitemoni. Kaiãopokori papakapa. Atarokiri arata ãki takakori atokokana papakapa. Atarokiri iõkokakori, kaiãkakori kinapakopeka iuaĩkana atarokiri inopini takaãka. Xãpoãkata, ininiã katxapoaãpota. Iua atokotxikana Teoso sikai kaiãopokori, ãtimoni pisikarauatiniã. Ãtimoni pisikarauatini atokotxikana, Teoso sikarauata pitemoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Xesosi sãpiretari ia sãpirenatxi atão inakari oerekiko: —Apakata ãti mõsiãreti anikiniri ãti mõsiãreti? !Apakata. Ninoa ipi irikako aariko ãki. Ininiã nota sãkire himimarotakanisaaki, kona apakata hõerekiniri ãti. Hõerekiniãri ãti, hĩkerokari. Ninoa mõsiãreni aariko ãki irikakani atoko hĩtxa. ");
INSERT INTO apuNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Apaiaõkarauatakari !imarotari koerekareri imarotakiti atoko. Poiãonoka imarota. Apaiaõkarauatini ixipokasaaki, iuasaaki koerekareri imarotakiti atoko imarotape. ");
INSERT INTO apuNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","—Pisãpiretari ãti: “Aãsoro aua poki ãki,” txamari kona pimaãkatari aãtxirata pite oki ãki auakari. Kinirepa ikara atoko inakari pikama? ");
INSERT INTO apuNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kinirepa pitxari pitari? “Nitari, nota makatxakinii aãsoro pokiã auakari,” kotxi !piposotari patamatiniri aãtxirata piteka pokiã auakari. Pisãkire atxiĩti erekari, txamari pikamakiti kona erekari. Merepitipanika pimakatxakari aãtxirata piteka pokiã auakari. Eereka piposotari patamatiniri aãsoro pitari okiã auakari pimakatxakini. Maerekati pite kamakiti apiata atxiĩti iua aãtxirata atoko. Maerekati ãti kamakiti poiãoka atxiĩti iua aãsoro atoko. Iuaritika !pimaãkatari maerekati piteka kamakiti. Põtãkikari ãti imaerekani itakanapini. Ikara atoko !apakata. Merepitipanika pite takanapariko pite maerekani, eereka põtãkikari ãti imaerekani itakanapini —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Amãtiiri erekari kona iritari matximakoti. Amãtiiri matximakoti kona iritari erekari. ");
INSERT INTO apuNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Patamatiniãri amãtiiri, pimarotari imina. Txipokori piko inakoro pinirekiniã, kona pisa inakomoni. Ova pinirekiniã, kona pisa inakomoni. ");
INSERT INTO apuNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kãkiti erekari amãtiiri erekari atokokana itxa. Iua erekari, ininiã erekarinoka ikama, kotxi iua ãkixinireẽ erekarinoka aua. Kãkiti maerekati amãtiiri matximakoti atoko itxa. Iua maerekati, ininiã ikamakiti maerekati apaka, kotxi maerekatinoka auari iua ãkixinireẽ. Iua ãkixinire ereka, ininiã isãkire ereka apaka. Iua ãkixinire maerekati, ininiã isãkire maerekati apaka, kotxi isãkire potorika ãkixinireẽ —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Xesosi sãkirauatapanika: —Kinirepa pakiritano nota “Apiananiri,” nipaniãtakiti pimakamakanisaaki? ");
INSERT INTO apuNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kãkiti notamoni ĩkari, nisãkire kenakotakari, nisãkire kĩpitakari, aapokotxi kamakari atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iua kamari aapokotxi. Ikisakari kipatxi. Otsomori aapoko tsota ikama. Iua apokari kai, ininiã iopitĩkari aapoko tsota iua kai nopini. Ininiã aapokotxi ikamakiti paikori. Ãparaã apoãtakasaaki, itorõkani inokasaakiri iua aapoko, !iakeka, kotxi iua kiki atão ikamari aapoko. Iua kiki atoko kãkiti nisãkire kĩpitakari. ");
INSERT INTO apuNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","—Ãti kiki aapokotxi kamakari, iua iopitĩkari aapoko tsota motsomotika popaiape ininiãtaã. Ãparaã apoãtakasaaki, itorõkani inokasaakiri iua aapoko pakitika. Xipoka itxa. Iua kiki atoko kãkiti nisãkire kenakotakari, nisãkire mauiãkati —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ikara sãkiretxiti isãpiretaka atoko, Kapanaoõ sitatxitimoni isa Xesosi. Iuaãtaã apoka. ");
INSERT INTO apuNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kapanaoõ auari kiki ãti uãka Homano inakori. Sotatoakori auĩte itxaua iua Homano. Ipaniãtana sotatoakori seĩ pakini inireẽkiti ikaminina. Xesosi apokasaaki Kapanaoõ, iua Homano nitiri iteene itiretakiti amianata. Ipinanapanoka. ");
INSERT INTO apuNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Iua Homano kenakopiretari Xesosi. Ininiã ipaniãtari Xoteoakori kiomãtxiakori Xesosimoni isinina. —Hĩtxariko: “Homano nirekai iuamoni pisini, initiri pimakananitini ĩkapani.” ");
INSERT INTO apuNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ininiã ninoa sa itxana Xesosimoni, aõkita itxarina. —Masa sotatoakori auĩtemoni. Initiri amianata. Masa, pimakananitiniri ĩkapani. Iua Homano erekari itxaua, ininiã erekapitikari pimoianatiniri iua. ");
INSERT INTO apuNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Itiretari Xoteoakori. Aiko aãpotiitiniãtaãua ikaminaua ate, ininiã iua Homano erekari itxaua —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ininiã Xesosi sari ninoakata. Iua Homano aapoko takote apokasaaki, iua Homano iokanatari imoianariakori Xesosimoni, isãpiretinirina ĩkapani: —Apiananiri, apikomoni !pisipe, kotxi minakati nota. Pite Apiananiri txaua. Nota apakapiniãi naapoko ãki !apakata. ");
INSERT INTO apuNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nota pitemoni napokini !apakata, kotxi pite Apiananiri, nota poiãori. Ininiãkara ereẽ piotoka. Ereẽkarako pitxĩkitakariko ninitiri ereka inini. ");
INSERT INTO apuNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nota auĩte paniãtiniãno nota ipaniãtakiti nikamini ĩkapani, ininiã nikamapitikariko. Nota auĩtetxi nitxaua apaka. Nota paniãtakiti sotatoakori kamapitika. Ãti nipaniãta: “Pisa,” ininiã iua sa. Ãti nipaniãta: “Uai pina,” ininiã iua ina. Ninitiri nipaniãta: “Ia pikama,” ininiã iua kamari. Ininiã nimarotari ereẽ pite paniãtiniãri ninitiri ereka inini, ereẽkarako erekapeka pitxĩkitakari ninitiri —itxa Homano sãkire Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iua Homano sãkire ikenakotakasaaki, Xesosi tsorĩkaãta. Isapotorika, misãkireta itxana kãkiti iuakata sikani. —Iua Homano iteene auikari nisãkire. Peerekari. Mitxi !naõkitari nisãkire auiãkari iua Homano atoko inakari. Na naõkitapanikari Xoteo iua Homano atoko inakari —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Eereka ninoa Homano iokanatakini kanapiriã Homano aapokomoni. Iuaã apokasaakina, atamatarina Homano nitiri. Erekapeka itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mapaõti napaãka atoko Xesosi sari Naiĩ sitatxitimoni. Imoianariakori, kãkitipokoni apaka sari iuakata. ");
INSERT INTO apuNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iimatokoãpotakasaakiri sitatxi pirikere tore kãkiti ĩronakikoãtaã, ipĩkari imipokĩkaãka sitatxi mapara. Sito imatonõkari oimi ipĩpe. Oa sito tikinitakoro. Kaiãopokori kãkiti sitatxi auakani pokĩka oakata sikani. ");
INSERT INTO apuNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Apiananiri atamatakasaakiro, iamonĩkaro oa, ininiã: —!Pitxiapatape —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Isa ipĩkarimoni. Imaãtakari ipĩkari auini kaixati, ininiã iua kaixa anikakani iotoka. Iuasaaki iua akiritari: —Ãtokori, nipaniãtai põkitikaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iuasaakipeka iua ãtokori topãka, sãkirauata itxa. Ininiã Xesosi sikari iua inoromoni. ");
INSERT INTO apuNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ikinimane pĩkarauata. —Peerekari Teoso. Teoso iokanatari isãkire sãpiretakari apiatakari atemoni. Teoso apokapeka ĩkorapokoriti ate inakitiakori imoianatini ĩkapani —itxanãtana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ia Xesosi pirena iaripireta ikini tõpati Xotéia tõpa. Apaka apikoxiti Xesosi pirena kenakopiretaãka. ");
INSERT INTO apuNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Xoão kapatxisareri moianariakori minapiretari Xesosi pirena Xoãomoni. Eereka Xoão akiritari imoianariakori ipi: ");
INSERT INTO apuNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","—Hĩsa Xesosimoni. Hĩpimaãri: “Teoso mereẽkitikai pite? Kãkiti iãtapanãtakitikai pite? Kãkiti iãtapanãtakiti ãtikani atxiĩti?” Ikara atoko hĩtxako Xesosimoni —Xoão txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ininiã ninoa ipi sari Xesosimoni. Iuamoni apoka itxana. —Xoão kapatxisareri iokanataua ate pitemoni. Ipimaãi: “Teoso mereẽkitikai pite? Kãkiti iãtapanãtakitikai pite? Kãkiti iãtapanãtakiti ãtikani atxiĩti?” itxai —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Iuasaaki ninoa Xesosimoni apokasaaki, amianatakani kaiãopoko erekapeka itxĩkitaka Xesosi. Iua omitikari maerekani matamatakoni kãkiti ĩtotaã auakani. Mõsiãreni kõsiãrepeka itxĩkitaka. ");
INSERT INTO apuNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ininiã Xesosi apakapapiretana Xoão moianariakori: —Hĩkanapiriã Xoãomoni. Hĩsãpiretari mixikanani uai hĩtikakiti, hĩkenakotakiti pakini. Hĩsãpiretari mitxi mõsiãreni uatxa kõsiãrepeka nitxĩkitakapeka. Hĩsãpiretari mitxi matĩpokotakani tĩpokotapeka uatxa. Mitxi maere matati erekapeka uatxa. Mitxi makenakokini uatxa kakenakokipeka. Mitxi ipĩkani iuaĩkana auãki itxapekana. Hĩsãpiretari Xoão, nota sãpiretari Teoso iokanapirena erekari minakati mauakinimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kãkiti iteene auikiniãri nota sãkire, Teoso takari erekari iuamoni. Ikara nisãkire hĩsãpiretari Xoão —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ininiã ninoa Xoão moianariakori sipe. Eereka Xesosi sãpiretari Xoão pirena kãkiti iuamoni apotiitakaniua. —Kipa ĩkai hĩte Xoão kapatxisarerimoni hĩsikasaaki ãparaã makipakaniãtaã iua auakasaaki? Hĩte sari iuamoni, kotxi isãkire ãtinoka, Teoso sãkirenoka. Kãkiti katsotati ĩtima anikakiti atoko itxa. Isãkire kita ãti, isãkire uatxa ãtião, isãkire katana iuaĩkana ãtião, itxaãpota isãkire. Ikara atoko !itxa Xoão. ");
INSERT INTO apuNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kipa ĩkai hĩte Xoãomoni hĩsikasaaki? Hĩte sari iuamoni, kotxi !inirekari tiitxi, txineiro pakini. !Kakaroneri imãka, kotxi !ikaikota auĩtetxi aapoko. Auĩtetxi auiniãtaã kãkiti mãka peereri. ");
INSERT INTO apuNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kipa ĩkai hĩte iuamoni hĩsikasaaki? Hĩte sari iuamoni, kotxi iua Teoso sãkire sãpiretakari itxaua. Atão inakari Teoso sãkire sãpiretakari itxaua. Apiata iua Xoão. ");
INSERT INTO apuNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Apiata iua, kotxi kitxakapirĩka Teoso sãkire iõkatsopatakori sãpiretapekari Xoão pirena: Ia kiki nisãkire sãpiretakari. Niokanatari iua kãkitimoni, pite nimereẽkiti sini apisa, papokini isãpiretini ĩkapani, kãkiti iposope inini ĩkapani, itxa Teoso sãkire iõkatsopatakori. ");
INSERT INTO apuNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iuaĩkana Xesosi txana kãkiti: —Atão nisãpiretai, ãti Xoão atoko inakari !auari. Xoão apiata. Iuaritika kãkiti Teoso auĩtetakari poiãori inakari apia imarotariko Teoso kamakiti tĩkane —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ikinimane kãkiti, txineiro apakapakani apaka kenakotakasaakiri Xesosi sãkire, imarotarina Teoso nireẽkiti kãkiti kamini ĩkapani atão inini, kotxi ninoa sari Xoãomoni ipatxisatikona ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Txamari pariseoakori, Teoso paniãtakiti oerekakani pakini !inirekari Xoão patxisatinina ninoa, ininiãkara Teoso nireẽkiti iaõka !inirekana ikaminina. ");
INSERT INTO apuNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Xesosi sãpirenauatapanika: —Kiãtokopa itxana kãkiti ĩkorasaaki auakani? ");
INSERT INTO apuNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Amarini sarauatini atoko itxana ĩkorasaaki auakani. Ninoa amarini topãkanãta tiitxi amotikoãtaã. Ipixini amarini tsoanãta. Itxana apanakinimoni: “Ate xikarauata hĩte serenini ĩkapani, txamari !hĩserena. Kãkiti ipĩkasaaki xikariti axikareta, txamari !hĩtxiapata.” Ninoa amarini sarauatini atoko itxana ĩkorasaaki auakani, ");
INSERT INTO apuNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","kotxi Xoão kapatxisareri apoka ĩkorapokoriti. Itakanapari inikini Teoso imisãkiretini ĩkapani. !Iãtari ovaã. Iuaritika hĩte txari: “Maerekati matamatakoti auaĩtotari Xoão,” hĩtxari. ");
INSERT INTO apuNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nota hĩtari iaxitikiri apoka ĩkorapokoriti. !Nitakanapari ninikini. Ikiniõtika ninipokota. Niãtari ovaã. Ininiã hĩte txari: “Iua kiki ixori. Poãtakari iua. Iua moianatana txineiro apakapakani, kãkiti maerekati kamakani,” himisãkirepiretano. ");
INSERT INTO apuNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Paimatireri Teoso. Iua nakitiakori imarotari isãkire atão ininiua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ãti õti pariseo Simão inakori aiatari Xesosi inipokotini iuakata, ininiã Xesosi sari iua aapoko. Iuaã apoka atoko iitopãka inipokotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Simão auini sitatxiti oãua sito kanokarero. Oa kenakopiretari Xesosi iua pariseo aapoko inipokotini, ininiã oa anikaro kamariãro iuamoni. Kopitipaki kai arapástiro kamakori ãki oãua kamariãro. Xãpoka. ");
INSERT INTO apuNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Otima Xesosi kiti takote. Otxiapanãta. Oãtsaã oãrokari ikiti. Okaxipokari oiãkoã. Ikiti oãpitxoka. Eereka okitakari kamariãro ikiti nopini. ");
INSERT INTO apuNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Iua Simão atamatakasaakiro Xesosi kiti oãrokini, ãkixinireẽ ixinikari: —Xesosi atão Teoso sãkire sãpiretakari inaãkamako, imarotamaroko oa sito iua maãtakakaro. Imarotamaroko maerekati kamakaro oa —itxa ãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ininiã Xesosi: —Simão, ninirekari nimisãkiretinii —itxa. —Ei, koerekareri, pisãkirauata —itxa Simão. ");
INSERT INTO apuNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ininiã Xesosi: —Ipi kiki apakapari txineiro sikakari txineirote. Imikanapiriãpanikaroko txineiro isikakito. Ãti apakapari isikakito txineiro kaiãopokoro, kiẽtosi txineirota. Ãtipekana apakapari isikakito poiãonoka, sĩkoẽta txineirota. ");
INSERT INTO apuNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ninoa ipi !iposotaikarina iuaĩkana txineiro isikinirina txineiro sikakarimoni, kotxi !oãuaika. Iuaritika iua xipokari ninoa kõtane. !Inirekaikaro itxineirote. Ininiãkara ĩkiripa ninoa kiki ipi apia apokaerekatari iua txineiro sikakari? —Xesosi pimaãri Simão. ");
INSERT INTO apuNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ininiã Simão: —Niuãkatari kiẽtosi txineirota apakapakari. Iua apia apokaerekatari txineiro sikakari, kotxi iua apakaparo kaiãopokoro txineiro —itxa. —Iuapitikara —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iuasaaki Xesosi sapotorika sitomoni. Itxari Simãomoni: —Patamatataro oia sito? Niĩroã pite aapoko, txamari kona pite sikano ãparaã nikiti narokini ĩkapani. Oia arokapekari nikiti oãtsaã. Oiãkoã okaxipokari. ");
INSERT INTO apuNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Uai napokasaaki kona pite apitxokano. Oia !iotoka nikiti oãpitxokini. ");
INSERT INTO apuNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Pite na takari iĩtxi nikiiã. Oia kitakari kamariãro nikitiã. ");
INSERT INTO apuNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Oia iteene tiretano, ininiã aimarotari omaerekani kaiãopokori makatxakaãkapeka. Kãkiti poiãonoka tiretakasaakino, aimarotari imaerekani poião inakari makatxakaãkapeka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iuasaaki Xesosi sãpiretaro: —Nimakatxakapekari pimaerekani —itxaro oa sito. ");
INSERT INTO apuNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Xesosikata nipokonãtakani ãkixinireẽna ixinikanãtarina: —Kiripitipa ia kiki atxiĩti? Iua makatxakatari kãkiti maerekani? —itxanãtana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iuasaaki Xesosi txaro oa sito: —Atão pauikari nisãkire, ininiãkara pimaerekani makatxakaãkapeka. Pisipiniikaua erekaxinirepeka pinini —itxaro oa. ");
INSERT INTO apuNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mapaõti napaãka atoko Xesosi sari ãti sitatxitimoni, ininiã eereka ãti sitatxitimoni isa, itxaãpota. Isãpiretari erekari pirena Teoso auĩtetxi ininiãua. Imoianariakori tosi pakini sari iuakata. ");
INSERT INTO apuNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Sitoakoro apaka sari iuakata. Mitxipe Xesosi erekapeka txĩkitakana ninoa sito. Mitxipe ãtikaka amianata. Mitxipe maerekati matamatakoti auaĩtotana ãtikaka. Maria Matarena inakoro sari iuakata. Mitxipe Xesosi omitikana maerekani matamatakoni setxi pakini oĩtoã auakani. ");
INSERT INTO apuNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Xoana inakoro, Kosa inakori tanoro, oa apaka sari Xesosikata. Kosa parĩkauata auĩtetxi Erotxi inakorikata. Erotxi paniãtakiti ikama. Sosana inakoro apaka sari Xesosikata. Apanakini sitoakoro apaka sari iuakata. Ninoa sikari itxineirotena Xesosimoni, imoianariakori pakinimoni nipokori iamotinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kãkitipokoni apokaãpota Xesosimoni, ãti sitatxitikini, iuaĩkana ãti sitatxitikini, iuaĩkana ãti sitatxitikini txaãpota apokinina Xesosimoni. Kãkitipokoni apotiitakasaakiua Xesosikata, Xesosi sãpiretana ninoa sãpirenatxi atão inakari oerekiko. ");
INSERT INTO apuNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Kiki sari ikikiote itakarauatini ĩkapani. Triko oki itaka. Okaãpotari. Okaãpotakasaakiro, kimaporiã apaka oãpoka oki okakiti. Eereka oki katxarataãka. Apanakini kotipiriki nika. ");
INSERT INTO apuNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oki apoka kai nopini. Kai auiniãtaã kipatxi poiãonoka auari. Eereka ipitxaka, txamari pitxakakaro kotsa imiti masikaniã, ãparaã mauakaniã, opina. ");
INSERT INTO apuNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Triko oki apoka inako sauaki apaka. Eereka inako aneẽ takarikata, txamari inako matxorotakaro takari, ininiã opina. ");
INSERT INTO apuNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Oki apoka kipatxi erekari nopini apaka. Eereka takari pitxaka, aneẽ otxa. Eereka ominaua kaiãopokori. Triko katiã seĩ oki aua. Xesosi sãkirauata iuaĩkana: —Kakenakokii, ininiã hĩkenakotariko nisãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Xesosi moianariakori pimaãri iua: —Poerekaua ikara sãpirenatxi atão inakari oerekiko pisãpiretakiti. !Aimarotari mixikanani pisãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ininiã Xesosi: —Nisãpiretapitikaiko hĩte Teoso auĩtetxi ininiãua, ininiã hĩte imarotari. Apanakini !imarotari hĩte imarotakiti Teoso auĩtetxi ininiãua. Ninoa apanakinimoni nisãpiretari sãpirenatxi atão inakari oerekiko. Ninoa kenakotari, txamari !imarotarina nisãpiretakiti sãkiretxiti, kotxi kitxakapirĩka Teoso sãkire sãpiretakani sãpiretari: Kokiri kãkiti, txamari !atamatari Teoso kamakiti. Karokokenakokiri kãkiti, txamari !ikenakotari Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","—Noerekai hĩte ikara sãpirenatxi atão inakari oerekiko, kiki takarauatini pirena. Triko oki atoko itxa Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Apanakini kãkiti kimapori atoko itxa. Ninoa kenakotari Teoso sãkire, kimapori nopini oki apokini atoko itxa. Txamari Satanasi apoka kotipiriki apokini atoko. Imakatxakari Teoso sãkire ãkixinireẽna apokakari, ininiã ninoa !auikaikari Teoso sãkire, ininiã Teoso !imakatxakari ninoa maerekani. ");
INSERT INTO apuNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","—Apanakini kãkiti kai auiniãtaã atoko itxa. Ninoa kenakotari Teoso sãkire, ininiã ipotxitarina. Txamari oki kipatxi poião nopini apokini atoko, Teoso sãkire !ĩroã ninoa ãkixinireẽ. Mapa kasiriti ninoa auikari Teoso sãkire atxiĩti. Eereka imisiritaãkana Teoso sãkire auikinina xika, ininiã itakanaparina Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","—Apanakini kãkiti inako auiniãtaã atoko itxa. Ninoa kenakotari Teoso sãkire. Eereka ninoa maerekaxinirenoka itxana. Inirekarina txineiro, tiitxi pakini. Inirekarina isarauatinina. Inako atoko itxa txineiro, tiitxi, isarauatinina, maerekaxinirenoka ininina pakini. Ininiã !ixinikaikarina Teoso. Oki inako sauaki pitxakakaro !ominaua. Iua atokokana, ninoa kãkiti !ikamari erekari Teoso ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","—Apanakini kãkiti kipatxi erekari atoko itxa. Ninoa kenakotari Teoso sãkire. Teoso sãkire ĩroã ninoa ãkixinireẽ ikaikotini ĩkapani. Erekari ninoa ãkixinire. Ninoa nirekari Teoso paniãtakiti ikaminina ikiniõtika. Eereka ninoa kamapitikari erekari Teoso ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Tirikapi iopotokaãkari iomaãtatari tirikapi kopiti ãki atxiĩti? Isĩkatatxi patapi itakatari atxiĩti? Konapitini. Itano itakari tirikapi, ininiã iopinikari aapokotxi ãki ĩroãkani atamarauatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ikinika iomaãtakori atamataãkako. Ikinika ipatakori apokaãkako, iopinikaremoni anikaãkako. ");
INSERT INTO apuNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","—Erepaniko. Iteene pikenakotariko Teoso sãkire, kotxi isãkire auakiti, Teoso sãkire kĩpitakari, Teoso sikari apikomoni imaroretxi iuamoni. Txamari Teoso sãkire kenakotakari, isãkire makĩpitakati, imarore xapiti iuamoni auakari makatxakaãkako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Xesosi sãpirenauanãtakasaaki, inoro, itariakori pakini apoka iuaãtaã. Inirekamarina Xesosimoni apokinina, txamari kãkitipokoni ãkitari iua. ");
INSERT INTO apuNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Iuasaaki kãkiti txari Xesosi: —Pinoro, pitariakori porikiti auanãta. Inirekarina imisãkiretinii —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ininiã Xesosi sãpiretari ikinimane: —Teoso sãkire kenakotakani, isãkire kĩpitakani, ninoro atoko itxauana. Nitariakori atoko itxauana —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ãti õti Xesosi iereẽtaua kanaua ãki imoianariakorikata. Aiatana: —Masa ipoa ipiniã —itxana imoianariakori. Ininiã ĩpiriãtana. ");
INSERT INTO apuNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ĩpiriãtakasaakina, Xesosi imaka. Mokatanitika ĩtima inataparata. Kataparari ĩtima apokasaaki, tsakati kataparari apaka, ininiã ierepeẽpokataua. Iuasaaki kanaua ãki ãparaã xãpokaãpokata. Pamonõkoniri. ");
INSERT INTO apuNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Xesosi moianariakori õpirĩkari. —Apiananiri, Apiananiri, pimereka. Apinanapanoka. Ininiã Xesosi õkitikaua. Ipaniãtari ĩtima, tsakati pakini iotokini: —Hĩotokako —itxa. Iuasaakipeka ĩtima, tsakati pakini iotoka. Itsorĩkaãta. ");
INSERT INTO apuNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iuasaaki Xesosi txari imoianariakori: —Kinirepa hĩte !auikano nota? Itsorĩkaãkatana, ipĩkarauakatana. Ninoakakarika isãkirauatana: —Kinakaripa ia kiki? Iua paniãtari ĩtima, tsakati pakini iotokini, ininiã ninoa kĩpitari isãkire —itxakakana. ");
INSERT INTO apuNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Eereka ipoa ipiniã apokana Xesosi imoianariakorikata. Ninoa potorikiniãtaã Kariréia tõpa. Ninoa apokiniãtaã Xerasa tõpa. ");
INSERT INTO apuNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Xesosi kanĩkiĩtakasaaki, kiki apoka iuamoni. Xerasa sitatxitikiri iua. Maerekani matamatakoni auaĩtotari iua. Okananipe !itakaikari imãka. !Inirekari aapoko ãki ikaikotini. Akauariã auanãta. ");
INSERT INTO apuNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Atamatakasaakiri Xesosi, akiripoakata. Iriãkata Xesosi apisatoõ. Maerekati matamatakoti akiritari Xesosi: —Xesosi, Teoso ãkiri, Apiananiri ãkiri, kiatokopa pitxanoko? Namanaãi !pimisiritapeno —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ikara atoko itxa isãkire, kotxi Xesosi paniãtana maerekani matamatakoni takanapiniri iua kiki. Mitxi inirimane iĩtxikapiimari iĩto imasikani ĩkapani. Iĩtxikarina iuako, ikiti kohẽtxiã. Txamari maerekati matamatakoti itotapekari imaĩkiniri, ininiã iua kiki kapatakari kohẽtxi. Maerekati matamatakoti txĩkitakari iua kiki mitekini kãkiti mauakaniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Xesosi aõkitakasaakiri iua kiki, ipimaãri: —Kipa piuãka? Ininiã maerekati matamatakoti txari: —Nota uãka “Itori,” ninaãka —itxa. Ikara atoko iuãka, kotxi itori maerekani matamatakoni auaĩtotari iua kiki. ");
INSERT INTO apuNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Maerekati matamatakoti amanaãri Xesosi: —Aariko mamapotõkire irikotimoni !piokanatapeua ate —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Iuaãtaã auari kaiãopokori irariakori piratakoni. Inipokonãtana oxiratari nopini. Maerekati matamatakoni amanaãri Xesosi: —Pauiritaua irariakori ãki aĩroini —itxana. Ininiã Xesosi auiritana. ");
INSERT INTO apuNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ininiã ninoa takanapari iua kiki. Irariakori ĩto ãki ĩroãna. Iuasaakipeka ikinika irari miteẽkata. Iokiriĩkatana oxiratari. Kãuaãriãmoni ikomoãkatana, ipĩpe itxana irariakori. ");
INSERT INTO apuNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kikiakori irari piratakani itikari irari mitekini, ininiã imitekana sitatximoni. Anikapiretarina itikakitina sitatxi auakanimoni, sitatxi mapara auakanimoni apaka. ");
INSERT INTO apuNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ininiãkara kãkiti sari Xesosimoni ikamakiti imarotinina ĩkapani. Ninoa apoka iuamoni. Atamatarina iua kiki mitxi maerekani matamatakoni auaĩtotakiti. Iitopãkanãta Xesosi apisatoõ. Kamãkapekari. Kiĩkitepekari apaka. Ininiã iuasaaki ninoa kãkiti pĩkari Xesosi posotiire. ");
INSERT INTO apuNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Xesosi kamakiti itikakani sãpiretari ninoa kãkiti, Xesosi erekapeka itxĩkitakiniri iua kiki. ");
INSERT INTO apuNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Eereka ikinimane kãkiti Xerasa tõpa auakani paniãtari Xesosi ãtiãtaã isini ipĩkarena xika. Ininiã Xesosi iereẽtaua kanaua ãki ipoa iuaĩkana ĩpiriãtini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iua kiki mitxi maerekani matamatakoni auaĩtotakiti amanaãri Xesosi: —Pauiritano pitekata nisini. Txamari Xesosi iokanatari aapokomoni. ");
INSERT INTO apuNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Pikanapiriã paapokomoni. Pisãpiretari kãkiti Teoso kamakiti pitemoni —itxa Xesosi. Ininiã iua sari ikini aapokotxitimoni. Isãpiretari ikinimane kãkiti Xesosi kaminiri iua erekapeka inini. ");
INSERT INTO apuNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Xesosi kanapiripe, ipoa ĩpiriãtini. Apokitakasaaki, kãkitipokoni apakapari Xesosi ipoxokoniritikana. Ninoa iãtapanãtari iua, ipiniã iua auakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Iuasaaki kiki Xáiro inakori apoka iuaã. Iua auĩtetxi itxaua aiko Xoteo apotiitiniãtaãua. Apoka Xesosimoni. Ikapotoreẽkaua Xesosi apisatoõ. —Masa naapoko. ");
INSERT INTO apuNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nota ãkero imatonõkaro, tosi ano auakaro, opinanapanoka —itxari Xesosi. Iuakata Xesosi sikasaaki, kãkitipokoni ãkitari iua, ininiã ikaiarikaãpotana kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kãkiti sauaki oãua sito amianatakaro. Tosi ano oamianata oãrẽka !iotokinaro. Otxineirote !auaika, kotxi okinika otxineiroteẽ oĩkitxitapekari pinĩtxi siãkani, txamari erekapeka otxĩkitakakiri !auari. ");
INSERT INTO apuNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kãkiti sauaki oãpoka Xesosi porikimoni. Omaãtakari imãka mapotomatare. Omaãtakasaakipeka, oãrẽka iotoka. ");
INSERT INTO apuNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ininiã Xesosi pimaãri kãkiti: —Kipa maãtakano? Ikinimane kãkiti: —!Ateni —itxana. Ininiã Petro: —Apiananiri, kãkitipokoni ãkitai. Ikinimane kãkiti tikakai. ");
INSERT INTO apuNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Txamari Xesosi: —Kãkiti maãtakapitikano, kotxi iuasaaki nitapara sari iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Iuasaaki oa sito imarotari Xesosi imarotiniro oa maãtakiniri. Ininiã osa Xesosimoni otitinanakiniritika. Okapotoreẽkaua iua apisatoõ. Ikinimane okiãtaã osãpiretari Xesosi: —Notara maãtakai namianatiniã. Nimaãtakasaakii, iuasaakipeka erekapekano —otxari. ");
INSERT INTO apuNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ininiã Xesosi: —Namarite, pauikari niposotiire, ininiãkara erekapekai. Pisipiniikaua erekaxinirepeka pinini —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Xesosi sãkirauanãtakasaaki, Xáiro aapoko potoriãkari apoka Xáiromoni. —Pamarite !oãuaika. Pauiritari Xesosi kanapiriini —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Xesosi kenakotari iminapiretakiti, ininiã Xesosi txari: —!Pipĩkarauatape. Pauikari nisãkire, ininiã iuaĩkana oãuapanikako pamarite —Xesosi txari Xáiro. ");
INSERT INTO apuNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Xesosi apokasaaki Xáiro aapoko, auiritana Petro, Xoão, Txiako, Xáiro, Xáiro ĩtanoro pakini ĩroini iuakata. ");
INSERT INTO apuNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iuaãtaã ikinimane kãkiti txiapanãta. Imatinaniuatana amarini ipinini xika. Ininiã Xesosi: —!Hĩtxiapatape. !Opina. Oimakanãta —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ininiã ninoa napetari Xesosi, kotxi imarotarina amarini ipinini. ");
INSERT INTO apuNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ininiã Xesosi paniãtana ninoa porikiti ipokĩkinina. Eereka Xesosi maĩkaro oa ãtokoro uako, akirita itxaro: —Ãtokoro, põkitikaua. ");
INSERT INTO apuNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Iuasaakipeka iuaĩkana oa auãkipeka otxa. Oõkitikaua. Xesosi paniãtana oĩri, onoro pakini nipokori isikinirona. ");
INSERT INTO apuNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Oĩri, onoro pakini tsorĩkaãta. Xesosi sãpiretana apanakini imasãpiretakanina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Xesosi akiritana imoianariakori tosi apotiitiniuana ĩkapani. Iuasaaki isikataparatana. Isikaposotiiretana maerekani matamatakoni iokanatinina ĩkapani, amianari imakatxakinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Eereka iokanatana imoianariakori kãkitimoni Teoso auĩtetxi ininiãua isãpiretinina ĩkapani, amianatakani erekapeka itxĩkitakinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Xesosi txana ninoa: —Hĩsikasaaki, !hanikapiri hĩtii. Na hĩtsonere !hanikape. Na sakora, na nipokori, na txineiro, na ãti himãka, !hanikape. ");
INSERT INTO apuNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kãkiti apakapakasaakii, iuaã ninoa aapoko hĩkaikota iua sitatxiti hãuakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kãkiti mapakapakaniãi, hĩtakanapari iua sitatxiti. Hõsipikasaakiri, hĩkaxipokariko kipatxi hĩkitiãkiri. Ikara oerekana iua sitatxiti auakani Teoso misiritanako ninoa, kotxi !inirekarina ikenakotinirina Teoso sãkire —itxa Xesosi imoianariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Eereka imoianariakori potorika. Ninoa sari ikinipoko aapokotxiti. Isãpiretarina Teoso iokanapirena erekari aapokotxiã auakanimoni. Erekapeka itxĩkitakana amianatakani ikini aapokotxiti auakani. ");
INSERT INTO apuNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erotxi Kariréia tõpa auakani auĩte kenakopiretari Xesosi pirena. Maerekaxiniretinoka itxa, kotxi kãkiti sãpiretari: —Xoão kapatxisareri iuaĩkana auãki itxapekaua. Iuara Xesosi txaua —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Apanakini sãpiretari: —Eríasi iuaĩkana uatxa auãki itxapekaua. Iuara Xesosi txaua —itxana. Apanakinipekana: —Teoso sãkire sãpiretakari kitxakapirĩka auakari iuaĩkana uatxa auãki itxapekaua. Iuara Xesosi txaua —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erotxi txari: —Notara paniãtari Xoão nopi tsotakiko, ininiã Xesosi kona Xoãoni. Kiripitipa Xesosi? Ãtipirika nikenakopiretari iposotiire —itxa Erotxi. Kinirão aõkitaka itxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ninoa Xesosi iokanatakini kanapiripeka iuamoni. Ikinika ikamakitina isãpiretarina Xesosi. Eereka Xesosi anikana ninoa kãkiti mauakaniãtaã, Petsáita sitatxiti takote. Ninoanoka sari iuaã. ");
INSERT INTO apuNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Txamari apanakini kenakopiretari Xesosi sinimoni, ininiã kãkitipokoni sari iua tikini. Ninoa apokasaaki Xesosimoni, Xesosi apakapana ipoxokoniritika. Isãpiretana Teoso auĩtetxi ininiãua. Erekapeka itxĩkitakana amianatakani. ");
INSERT INTO apuNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tinĩtikita imoianariakori tosi pakini apoka iuamoni: —Piokanatana kãkiti aapokotxi imatokotinimoni inipokotinina ĩkapani, imakinina ĩkapani, kotxi uai aapokotxi mauakaniãtaã —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Txamari Xesosi txana: —Hĩtekarako sikakienatana ninoa. Ininiã ninoa: —Poiãonoka nipokori aua atemoni, sĩkonoka komiri, ipinoka ximaki pakininokara aua. !Apakata aiamotiniri nipokori kaiãopokori kãkiti asikakienatini ĩkapani —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iuaãtaã kikiakorinoka sĩko mio auakata. Xesosi paniãtana imoianariakori: —Hĩpaniãtari kãkiti topãkini, uai sĩkoẽta, apikomoni iuaĩkana sĩkoẽta, apikomoni iuaĩkana sĩkoẽta, txaãpokata kãkiti —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ininiã imoianariakori paniãtari kãkiti ikara atoko iitopãkinina. Ininiã ninoa topãka. ");
INSERT INTO apuNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iuasaaki Xesosi kosekari komiri sĩko, ximaki ipi pakini. Iaxiti ionakaãta, misãkireta itxari Teoso: —Peerekari ia nipokori pisikakiti —itxa. Iuasaaki ixanakari komiri, ximaki pakini, sika itxari imoianariakorimoni, ininiã ninoa sikari kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ikinimane nikari, kamitopeka itxana. Eereka Xesosi moianariakori amari nipokori itetakori. Ixãpokakarina kotari tosi pakini. ");
INSERT INTO apuNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ãti õti Xesosi iuanani misãkiretari Teoso. Eereka imoianariakori apoka iuamoni. Ipimaãna: —Kiripa kãkiti uãkatano nota? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ininiã ninoa: —Apanakini xinikakiti pite Xoão kapatxisareri pitxaua. Apanakinipekana xinikakiti pite Eríasi pitxaua. Apanakinipekana xinikakiti pite Teoso sãkire sãpiretakari kitxakapirĩka auakari iuaĩkana auãki inakari pitxaua —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ininiã Xesosi: —Hĩtepekana, kipa hĩte uãkatano nota? —itxa. Petro apakapapiretari: —Pite Teoso mereẽkiti kãkiti iãtapanãtakiti pitxaua —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ininiã Xesosi iteene pinitari ikara apanakinimoni imasãpiretakani. ");
INSERT INTO apuNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ininiã Xesosi: —Nota hĩtari iaxitikiri iteene natatsiitariko nimisiritiko. Kiomãtxiakori, sasetotxi auĩteakori, kaiõkatsoparerini pakini !inirekano nota, ininiã nokaãkako. Ipi ãti õtisaaki Teoso õkitikanoko nota iuaĩkana auãki ninini ĩkapani —itxari imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Eereka isãpiretari ikinimane: —Notakata kinirão sika pinakasaaki, piteka pinireẽkiti kona pixinikape. Notakata kinirão sika pinakasaaki, nota misiritiko atokokana pimisiritaãkako. Ia atoko pinirekiniã ikiniõtika, notakata pisapitikako. ");
INSERT INTO apuNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pite ãtipirika kaminiãri piteka nireẽkitinoka, ininiã pinireẽkiti xipokapitikako pitekata. Pite nireẽkiti xipokiniã, nota sãkire pauikini xika, Teoso iokanapirena erekari pisãpiretini xika, pite auapininiika txako Teosokata. ");
INSERT INTO apuNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Atxiĩti papakapari ikinipoko tiitxi, ikini itixiti auakani tii, pinakiti ĩkapani. Atxiĩti iua tiitxi xika kona pikĩpitari Teoso sãkire, ininiã kona pikaikota ãtipirika Teosokata. Ikara atoko ininiã, erekari atxiĩti ikinipoko tiitxi auinii? Konapitini. Apiaerekata Teosokata ãtipirika pikaikotini. ");
INSERT INTO apuNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pipẽtatiniãno nota, pipẽtatiniãri nisãkire, nota kãkiti itari iaxitikiri pẽtataiko pite uai nikanapiriãkasaaki. Peerekari iuasaaki uai nikanapiriini õti. Iuasaaki kãkiti imarotariko niposotiire, niri posotiire, initiriakori iaxitikini posotiire apaka. Teoso nitiriakori erekarini itxauana. ");
INSERT INTO apuNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Atão nisãpiretai, apanakini hĩte uatxa uai auakanii, hĩpinini apisapanika himarotari Teoso auĩtetxi ininiãua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ãti semanati napaka atoko, Xesosi anikana Petro, Xoão, Txiako pakini. Ikanĩkana oxiratari nopini Teoso imisãkiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Teosokata isãkirauanãtakasaaki, itoõ ipinipo itxa, imãka ponika, kasarori. ");
INSERT INTO apuNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Iuasaaki ipi kiki tokiã iuaã, Moisesi, Eríasi pakini. Isãkirauatana Xesosikata. ");
INSERT INTO apuNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ninoa iotximere aua, kotxi ipotorikana Teoso tixine. Isãkirauatana Xesosikata, Xesosi ipinini pirena, mapa semanati napaka atoko Xerosareẽ ipinini Teoso paniãtakiti ikamini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Iuasaaki Petro, Xoão, Txiako pakini imakanãta. Eereka imerekana. Atamatarina Xesosi iotximere. Atamatarina ninoa ipi kiki iuakata itiminina. ");
INSERT INTO apuNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moisesi, Eríasi, takapiretakasaakiri Xesosi, Petro akiritari Xesosi: —Koerekareri, erekari uai akaikotini. Makamari papiri ipi ãti pakini, pite ĩkapani, Moisesi ĩkapani, Eríasi ĩkapani —itxa. Txamari maxikatiĩka isãkirauata. !Imarotari amanaãkiti. ");
INSERT INTO apuNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petro sãkirauanãtakasaaki, katxiãri apoka. Xesosi moianariakori pĩkarauata katxiãri ãki auakasaakina. Katxiãri ãkitana. ");
INSERT INTO apuNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Katxiãri ãki ikenakotaãka sãkiretxi: —Ere namarite, nitiretakiti. Hĩkenakotariko iua sãkire —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Isãkirauataka atoko Xesosi moianariakori atamatari Xesosinani. Eereka !isãpiretarina itikakitina apanakinimoni. Masãkirenika itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Katimatinĩkata iokiriĩtana. Iuasaaki kãkitipokoni apoka Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ninoa sauaki kiki akiritari Xesosi: —Koerekareri, patamatari nota ãkiri imatonõkari namarite. ");
INSERT INTO apuNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ãtipirika maerekati matamatakoti maĩkari iua. Iuasaaki akiripoakata, okarakataua. Isorikipekata inamamoni. Maerekati matamatakoti kamatsiitari namarite. Poiãonoka itakanapari. ");
INSERT INTO apuNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Iteene namanaãpekari pimoianariakori omitikiniri, txamari !iposotarina —itxa Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ininiã Xesosi txari kãkitimoni: —!Kauikarei hĩte. Maerekati kamakanii hĩte. Kipakinikananipa Teoso nirekatari hĩtekata nauini? Kipakinikananipa Teoso nirekatari hĩte nimĩteenekini? —itxa. Eereka ipaniãtari iua kiki: —Pamarite pimina uai. ");
INSERT INTO apuNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Iua amarini apokaãpotakasaaki, maerekati matamatakoti irikari ixiti. Amarini okarakataua. Xesosi paniãtari maerekati takanapiniri amarini. Erekapeka itxĩkitakari amarini, ininiã isika iua iuaĩkana irimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ikinimane tsorĩkaãta Teoso posotiire itikasaakina. Ikinimane tsorĩkaãtakasaaki, Xesosi misãkiretari imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—!Himaxinĩkaretapiri uatxa nisãpiretakiti. Nota hĩtari iaxitikiri mĩkapiritaãkako. Nisikaãkako kãkitimoni ninoaka nirekakiti ikaminina ĩkapani —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Imoianariakori kenakotari Xesosi sãkire, txamari !imarotarina isãpiretakiti. Teoso !nirekari ninoa imarotiniri Xesosi sãpiretakiti iuasaaki. Ninoa pĩkari Xesosi ipimainina isãkire oerekinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ãti õti Xesosi moianariakori !auikakauana isãkirena, kotxi inirekarina imarotinirina apiatakari ninoa sauaki auakari. ");
INSERT INTO apuNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Xesosi imarotari ninoa xinikakiti, ininiã iminari amarini ninoamoni. Xesosikata tima itxa amarini. ");
INSERT INTO apuNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Iuasaaki Xesosi txana: —Papakapiniãri amarini ia atoko inakari, papakapano nota apaka. Papakapiniãno nota, papakapari niokanatakiri apaka. Iuaka poiãotakakariua hĩte sauaki, iuarako apiatakari txauako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Xoão sãpiretari Xesosi: —Koerekareri, ate kenakotari kiki omitikinina maerekani matamatakoni pite uãkaã. Ate sãpiretari iua kiki ikara atoko inakari imakamakani, kotxi kona pimoianarini iua —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ininiã Xesosi: —!Hĩotokakapiri ikara atoko inakari ikamini, kotxi iua kiki !omanataua ate. Iua apamonĩkaua ate —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Teoso tixine iuaĩkana Xesosi kanapiriini õti apokaãpota, ininiã Xesosi ãkixinireẽ txari: —Nisapitikako Xerosareẽmoni. ");
INSERT INTO apuNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Iokanatari kãkiti iua apisa, imakiniãtaã initinina ĩkapani. Ipixinipokoriti ninoa kãkiti nitari imakiniãtaã aapokotxi Samaria auakani auiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Txamari kãkiti iuaãtaã !inirekarina Xesosi apakapinina, kotxi iua nirekari Xerosareẽmoni isini. Samaria auakani omanatana Xerosareẽ auakani. ");
INSERT INTO apuNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Txiako, Xoão pakini kenakopiretari ikara ene. Iuasaaki ipimaãrina Xesosi: —Apiananiri, pinirekatari aamanainiri Teoso xamina iaxitikiri iokanatini ninoamoni ixipokinirina ĩkapani? ");
INSERT INTO apuNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Txamari Xesosi pinitana, isãkirena maerekani xika. ");
INSERT INTO apuNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","—Nota, hĩtari iaxitikiri kona kãkiti nixipokini ĩkapanini napoka uai. Kãkiti maerekani nimakatxakini ĩkapanira uaimoni nina —Xesosi txari Txiako, Xoão pakini. Eereka ninoa sari apikoxiti apanakini kãkiti auiniãtaãmoni. ");
INSERT INTO apuNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Xesosi imoianariakorikata saãpotakasaaki kimaporiã, kiki txari Xesosi: —Apiananiri, pite sinimoni nota apaka sako. ");
INSERT INTO apuNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ininiã Xesosi: —Karikori aripa auini. Kakoari kotipiriki auini, txamari nota hĩtari iaxitikiri nimakiniãtaã !auari. Pimoianatiniãno, ikara atoko pimisiritiko pinireka atxiĩti? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Xesosi txari ãti kiki: —Notakata pisako. Txamari iua kiki: —Koerekareri, merepanika ninirekari niãtapiniri niri ipinini —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ininiã Xesosi: —Ikara piparĩka pauiritari ãti kamini. Piparĩka apiari uatxa aua. Pite sari kãkitimoni. Pisãpiretanako Teoso auĩtetxi ininiãua —itxa Xesosi iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ãti kikipekana txari Xesosi: —Koerekareri, nota pimoianari nitxamauako. Mitxi pauiritano nikanapiriini nauinimoni. Nitakapiretanapana ninirimane —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ininiã Xesosi: —Teoso kimaporeẽ potoriãkari nirekiniãri mitxi ikamakiti iuaĩkana ikamini, !apakata iparĩkauatini aãuĩte Teoso ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ikara inaãka atoko Apiananiri mereẽna setẽta pakini kãkiti. Iokanatana ipi, iuaĩkana ipi, iuaĩkana ipi, itxaãpotana iokanatinina. Iokanatana iua sini apisapanika ikini aapokotxitimoni. Ninoa ĩkiika. Apokana Xesosi apisa. ");
INSERT INTO apuNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Xesosi txana ninoa: —Kaiãori kãkiti iposope auikiniri nisãkire, txamari !imarotarina nisãkire, kotxi !ikenakotapanirina. Ninoa kikio erekari atoko itxana. Imakinika iposope iuaã. Txamari, poiãoka parĩkauatakani aua nisãkire isãpiretinina ĩkapani. Ininiãkara himisãkiretariko Apiananiri kakikioteri iokanatinina parĩkauatakani iua sãkire auiãkani apotiitinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hĩsa. Soti auĩte anaakori ãkitimoni iokanatiko atoko, niokanatai hĩte kãkitimoni, kotxi pamonõkonina ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Txineiro !hanikape. Tiitxi !hanikape. Ãti hĩkiti mata !hanikape. Kimaporiãpoã kãkiti akiritakasaakii, !hĩotokaãpotape kãkitikata hĩsãkirauatini ĩkapani. Hĩsapitiporiko niokanatinimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kãkiti aapoko hãpokasaaki, merepitipanika hĩtxariko: “Namanaãri Teoso, ikamaerekaxiniretinina kãkiti uai auakani,” hĩtxako. ");
INSERT INTO apuNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kaapokori nirekiniãri Teoso ikara atoko inakari ikaminana ninoa, Teoso kamapitikari hamanaãkiti. Kaapokori manirekakaniãri, hĩsãpiretana Teoso kona kamaerekaxiniretana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kaapokori apakapiniãi hĩte, hĩkaikotako iua aapokonoka. Ãti aapoko, eereka ãti aapoko kona hĩtxaãpotapeko iua sitatxiti hãuakasaaki. Iuaã ninoa sikakiti hinikini ĩkapani, hiãtini ĩkapani hãpakapariko. !Hĩpẽtauatape hãpakapiniri, kotxi hĩte nota ĩkapani parĩkauatakani hĩtxaua. Apakatapitika hãpakapiniri hĩparĩka ĩki. ");
INSERT INTO apuNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","—Aapokotxiãtaã hãpokasaaki hãpakapikoã, iuaã hĩsikiko hinikako, hiãta hĩtxaãpotako. !Hĩxinikapiri ninoa sikakiti mapitxiri ininiua. Hinikariko. ");
INSERT INTO apuNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Erekapeka hĩtxĩkitakanako amianatakani iuaã auakani. Hĩsãpiretana ninoa, kaiamapekari Teoso ninoa auĩte ininiua tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Aapokotxiãtaã himapakapakoniã, hĩsa kãkiti napaãporetxiã. Hĩsãpiretana kãkiti iuaã auakani: ");
INSERT INTO apuNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Hãuiniãkiri pani akitiãkiri akaxipoka, kotxi !erekari uai, kotxi maerekati hĩkama ate himapakapakaniã. Hĩxinikariko, ate apoka uai Teoso auĩtetxi ininiãua asãpiretinii ĩkapani, txamari !hinirekari.” Ikara atoko hĩtxa sãkiretako ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kãkiti misiritiko õtisaaki Teoso misiritanako kãkiti Sotoma sitatxiti auakani ninoa maerekani xika, txamari Teoso apia misiritanako iua aapokotxiti auakani hĩte mapakapakani, kotxi hĩte sãpiretana Teoso sãkire, iuaritika !auikarina. Kitxakapirĩka Teoso sãkire sãpiretakani !isana Sotoma sitatxitimoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","—Hĩte Korasiĩ sitatxiti auakani inipitika atatsiitariko misirikaretxi. Hĩtepekana Petsáita sitatxiti auakani apaka atatsiitariko misirikaretxi, kotxi nota kamapekari posotiiretxi hĩte sauaki, txamari !hĩtakanapari himaerekani. Ikara posotiiretxi Sitoõ sitatxiti, Txiro sitatxiti pakini auaãkamako, kãkiti iuaã auakani uatxakapokoikamani itakanapamarinako maerekati ikamakitina. Ninoa sako mata ieretakamanako, atapani iĩtoãna itakamanako, imaerekanina itakanapinina oerekinina. ");
INSERT INTO apuNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kãkiti misiritiko õti apokasaaki, Teoso misiritariko Txiro sitatxiti auakani, Sitoõ sitatxiti auakani pakini, txamari iua apia misiritaiko hĩte Petsáita sitatxiti auakani, hĩte Korasiĩ sitatxiti auakani apaka. ");
INSERT INTO apuNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hĩtepekana Kapanaoõ sitatxiti auakani apiarini hinireka hininiãua, txamari maerekani misiritikoãtaã iuamonirako hõkapeẽkako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Xesosi misãkiretana imoianariakori: —Hĩte sãkire kenakotakani kenakotari nota sãkire apaka. Hĩte mapakapakani !apakapano nota apaka. Nota mapakapakani !apakapari nota uaimoni iokanatakari apaka —itxana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ninoa setẽta pakini kãkiti kanapiriã. Poxokonoka itxakatana. —Apiananiri, maerekani matamatakoni apaka kĩpitari asãkire, pite uãkaã aiokanatakasaakina —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ininiã Xesosi: —Ari, nitikapekari Teoso patimari iokanatiniri Satanasi, okaratxirari patimari imẽkokini atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hĩkenakota. Nota sikaposotiiretai hĩte imini, kaxipiro pakini hĩkatxaratini. Kona ioãkai hĩte. Amokaiakari Satanasi pataparari, iuaritika hĩposota hĩokanatiniri iua, kotxi nota sikataparatai hĩte. !Auari hĩte karotakani. ");
INSERT INTO apuNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hĩpoxokoniuata, kotxi maerekani matamatakoni kamari hĩpaniãtakiti. Apia hĩpoxokoniuatako, kotxi hĩuãka Teoso tixine aãtsopateẽ iõkatsopatapeẽkaika iuaã hĩsini ĩkapani —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Iuasaaki Erekari Matamatakoti kamapoxokonitari Xesosi, ininiã Xesosi misãkiretari Teoso: —Niri, pitixine auakani auĩte pitxaua. Uai ikini itixiti auakani auĩte apaka pitxaua. Peerekai pite, kotxi kimarorerini, iuikakaniua kona poereka pimarore. Poiãorini, miuikakaniua poereka pimarore. Ari niri, ikara atoko pinireka. Ikara atoko papokaerekata —itxari iri. ");
INSERT INTO apuNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Eereka imisãkiretari kãkiti: —Niri sikapekano ikinika. Kãkiti !imarotano nota Teoso ãkiri nininiua. Nirinokara atão imarotano nota. Apaka kãkiti na atão imarotari niri. Notanokara imarotari niri, kotxi iua ãkiri nitxaua. Kãkiti nirekiniãri imarotiniri niri, nota oerekari niri iuamoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Eereka Xesosi aua imoianariakorikata. Ninoanani aua iuakata. Imisãkiretana: —Teoso sikari erekari hĩtemoni, kotxi hĩte atamatari nota kamakiti, hĩte kenakotari nota sãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nota sãpiretai hĩte. Kitxakapirĩka Teoso sãkire sãpiretakani, auĩtetxiakori pakini kinirão atamataka txari hĩte atamatakiti, txamari ninoa !atamatari. Ninoa nirekari hĩte kenakotakiti ikenakotinina, txamari !ikenakotarina —Xesosi txari imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kiki Moisesi sãkire oerekakari apoka Xesosimoni. Inirekamari Xesosi kerokiniri isãkire. —Koerekareri, kiripa nikama Teosokata ãtipirika nauini ĩkapani? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ininiã Xesosi: —Kiripa patatsopata Teoso aãtsopateẽ? Pisãpiretano Teoso paniãtakiti —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ininiã iua kiki apakapapireta: —Teoso paniãtaua: “Pitiretariko Apiananiri piTeosone, ikinipoko pinireẽkitiã, ikini pãkixinireẽ, ikini pitaparaxinireẽ, ikinipoko pixinikakitiã pakini.” Apaka Teoso paniãtaua: “Piteka pitiretiniãua atokotxikana, pitiretariko ãti,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Atãopitikara papakapapiretano. Ikara pikaminiã, pauapika ãtipirika Teosokata —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Txamari iua kiki !inirekari ikara atoko inakari ikamini, ininiã iua pimaãri Xesosi: —Kiripa ãti nitiretini ĩkapani? ");
INSERT INTO apuNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Xesosi apakapapiretari, ia sãpirenatxi atão inakari oerekiko isãpiretini: —Kiki potorika Xerosareẽ. Inirekari Xerikoo sitatxitimoni isini. Ipixinipokoriti kiĩtiririni maĩkari iua. Iĩtirĩkarina imãka, itii pakini, noropata, karota, itxarina. Mauãkixiniretinoka itakanaparina iua kiki. ");
INSERT INTO apuNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Iuasaaki sasetotxi iãpota iua kimaporiti. Iua atamatari iua kiki karotakori, txamari !imaãkatari. Iopiriãri, napa, ĩkorape itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Eereka kiki Arevii apika mekaniri, sasetotxiakori moianatakari apoka. Iua apaka atamatari iua kiki karotakori, txamari iua sasetotxi atokokana !imaãkatari. Iopiriãri, napa, ĩkorape itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Eereka kiki Samaria tõpakiri iãpota iua kimaporiti. Iua apoka iuaã. Atamatari iua kiki maĩkapekori, ininiã iua amonĩkari. ");
INSERT INTO apuNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iuamoni isa. Arokari ikaro ipiniã. Ipitari ikaro iĩtxiã. Mãkatxi mataã iapirika itxari ikaro. Eereka õkitika itxari, ipira poho nopini taka itxari. Anikari kãkiti imakiniãtaã aikotimoni. Iuaã imoiaãri. ");
INSERT INTO apuNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Katimatinĩkata isikari txineiro kaapokorimoni. Ipi ota pirata kamakori isika. “Nisipekako. Pite moiaãriko ia kiki. Apikomonipanika txineiro pinirekiniã ikiena ĩkapani, nikanapiriãkasaaki niĩkitxitai,” itxa Samariakiri, —itxa Xesosi Moisesi sãkire oerekakarimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Xesosi pimaãri iua: —Ipi ãti kikiakori iãpota iua kimapori. Ĩkiripa iua kiki kiĩtiririni maĩkakiti tiretakari? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ininiã iua Moisesi sãkire oerekakari: —Ari, Samariakirinokara tiretari iua —itxa. Ininiã Xesosi: —Pisipe. Samariakiri kamakiti atoko inakari pikamako, kotxi iua tiretari ãti. ");
INSERT INTO apuNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Xesosi imoianariakorikata sipeka. Apokana aapokotxiãtaã. Iuaã sito Mata inakoro apakapana oaãpoko. ");
INSERT INTO apuNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Oĩtaro Maria inakoro topãka Apiananiri takote isãkire okenakotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata maerekaxiniretonoka otxa oparĩka ito inini xika. Ininiã osari Xesosimoni. —Apiananiri, nitaro topãkanãta ereẽ. Notanani parĩkauanãta. Pitemoni erekari atxiĩti? Pipaniãtaroko notakata nipokori okamini —otxa. ");
INSERT INTO apuNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ininiã Xesosi: —Mata, Mata, maerekaxiniretonokai pitxa, kotxi piparĩka ito inini xika. ");
INSERT INTO apuNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ãtinoka pikamini tĩkane ninireka. Maria mereẽri ikara. Omereẽri nota sãkire okenakotini. Oa mereẽkiti apiaerekata, ininiã !niotokakaro oa nisãkire okenakotini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ãti õti Xesosi misãkiretari Teoso. Ixipoka atoko ãtika imoianari txari: —Apiananiri, Xoão oerekari imoianariakori Teoso imisãkiretinina. Iua atokokana poerekaua ate Teoso amisãkiretini. Natokopa itxa Teoso amisãkiretini? ");
INSERT INTO apuNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Xesosi apakapapireta: —Teoso himisãkiretakasaaki, ia atoko hĩtxako: ");
INSERT INTO apuNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nipokori ikiniõtika pisikauako. ");
INSERT INTO apuNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pimaxinĩkaretariko maerekati akamakiti. Maerekati atemoni kamakori amaxinĩkaretini atokokana, pimaxinĩkaretariko. Kona panikapeua aãtaerekatikomoni. Pisikakauako ate, maerekati sauaki aãuakasaaki.” Ikara atoko hĩtxako Teoso himisãkiretini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Eereka Xesosi oerekana imoianariakori: —Atxiĩti apanĩkanõka pisa pimoianari aapokomoni nipokori pamanaini ĩkapani. Ininiã pakiritari iua: “Nimoianari, ipi ãti pakini komiri pisikano. ");
INSERT INTO apuNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Naõkimanere iãpotakari uatxaika apoka naapoko. Natxinoka itxape. Nipokori !auari nisikiniri,” atxiĩti pitxari iua. ");
INSERT INTO apuNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","—Atxiĩti pimoianari iroko ãki apakapapiretai: “!Pakirinãtapeno. Naapoko tore katoreri. Nota, namariteni apaka imakanãtape. !Niposota nõkitikiniua, nipokori nisikinii.” ");
INSERT INTO apuNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","—Pimoianari itxaua iua, iuaritika atxiĩti !inirekari õkitikiniua. Iuaĩkana, iuaĩkana pakiritiniãri pimoianari, iua õkitikapitikaua. Ikini nipokoriti pinirekakiti isikaiko, iuaĩkana imakini ĩkapani. Iua pimoianari na atoko itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ininiãkara pamanaãriko pinirekakiti, ininiã Teoso sikapitikai. Pinitariko pinirekakiti, ininiã papokapitikari. Pakiritariko Teoso, ininiã iua apakapapiretai. ");
INSERT INTO apuNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Amanarauatakari apakapapitikari amanaãkiti. Nitarauatakari apokapitikari initakiti. Teoso akiritakari apakapapiretaãkapitika. ");
INSERT INTO apuNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","—Hĩte irĩtxiakori, hamariteni amanainiãi komiri, kaikani hĩsikatana hamariteni? Ximaki amanainiãna, iminikani hĩsikatana hamariteni? ");
INSERT INTO apuNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Patari naki amanainiãna, kaxipirokani hĩsikatana hamariteni? Konapitini. ");
INSERT INTO apuNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hĩte maerekati kamakani hĩtxaua, iuaritika himarotari erekari hamaritenimoni hĩsikini, ininiã hĩri iaxiti auakari, erekarinani kamakari, iua sikapitikariko Erekari Matamatakoti hĩtemoni hamanainiãri iua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ãti õti Xesosi omitikari maerekati matamatakoti masãkireti. Iua maerekati matamatakoti sipeka atoko, iua kiki mitxi maerekati matamatakoti auaĩtotakiti posotari iuaĩkana isãkirauatini. Kãkiti Xesosi kamakiti itikakani tsorĩkaãnãta. ");
INSERT INTO apuNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ãtikaka ninoa txari: —Satanasi, maerekani matamatakoni auĩte, iuakara sikataparatari Xesosi maerekani matamatakoni omitikini. ");
INSERT INTO apuNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Apanakinipekana nirekari Xesosi kerokiniri, ininiã itxarina Xesosi: —Takaõtxikari, Teoso posotiire poerekaua ate, aãtamatiniri ĩkapani, Teoso iokanatinii ĩkorapokoriti aimarotini ĩkapani —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Xesosi imarotari ninoa xinikanãtakiti, ininiã iua txana: —Kãkiti tixine auakani, ninoakakarika inaiatakakiniãuana, !apakata. Ixipokakakauana. Iua atokokana kãkiti aapokoã auakani inaiatakakiniãuana, ninoakakarika ixipokakakauana. ");
INSERT INTO apuNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Iua atokokana Satanasi nitiriakori, ninoakakarika inaiatakakiniãuana, Satanasi tapara xipokako. Ikara atoko ininiã, kona atão hĩte sãkire, nota iokanatinina Satanasi nitiriakori, maerekani matamatakoni, Satanasi taparaã. Ikara hĩsãkire kona atãoni. ");
INSERT INTO apuNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hĩte sãpiretano, maerekani matamatakoni Satanasi taparaã nomitika, ininiãkara kitaparaãpa hĩte moianariakori omitikana maerekani matamatakoni? Ninoa omitikana maerekani matamatakoni Teoso taparaã, ininiã ninoakara oerekari !atão hĩsãkire nota pirena. ");
INSERT INTO apuNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Teoso posotiireẽ nomitikari maerekani matamatakoni. Ikara atoko ininiã, Teoso oerekai iua apokapeka hĩtemoni hĩauĩte inini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Kiki pataparari ikeeko iposope inakari moiainiãri aapoko, kona kiĩtĩrikikori itii. ");
INSERT INTO apuNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Txamari ãti kiki apiataparata inaiatiniãri, iriãkata, ininiã anikapitikari kaapokori ikeeko. Mitxi iua kaapokori sãkire: “Nikeeko auiniã, kona kamakatxakikori nitii,” itxama, iuaritika kiki apiataparatakari ĩtirĩkari itii. Eereka imoianariakorimoni ixanakari tiitxi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Notakata maparĩkauatakani omanatano nota. Imamoianatakaniãno, inirekari niparĩka ixipokini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Iuaĩkana Xesosi sãpirenauata: —Maerekati matamatakoti omitikikosaaki, kãkiti itakanapakasaaki, isaãpota ãparaã makipakaniãtaã auiniãtaã initini ĩkapani. Imapokakaniãri, “Iuaĩkana nikanapiriãko mitxi nauinimoni,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Iuaã apoka. Iua aapoko mitxi inakari iuasaaki peereri. Oeretapeẽkaika. ");
INSERT INTO apuNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ininiã apana apikomoni setxi pakini maerekani matamatakoni, apia maerekanitakani. Ninoa ikinikana ĩroaĩtotari iua kiki. Iua ĩtoã aua itxana. Iuasaaki oitope maerekani matamatakoni misiritari iua kiki, ininiã apiata itsii inikoriã. Mitxipe ãtinoka maerekati matamatakoti paniãtari iua maerekati ikamini. Eereka oito paniãtari iua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Xesosi sãkirauataka atoko, sito iuaã kãkiti sauaki auakaro txari Xesosi: —Pite auãkĩtakakaro, pite axitakakaro, poxokoniuata, kotxi Teoso sikari erekari oamoni —otxa. ");
INSERT INTO apuNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Xesosi apakapapiretaro oa: —Ari, inipitikara. Iuaritika Teoso sãkire kenakotakani, isãkire auiãkani, apia poxokoniuatako, kotxi Teoso sikari apikomoni erekari ninoamoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kaiãopokori kãkiti apokaãpota Xesosi takote. Iuasaaki Xesosi txari: —Kãkiti uatxarini !erekana. Hĩte nirekari noerekinii Teoso takaõtxikare, iposotiire. Konapitini. Kona noerekai hĩte. Kitxakapirĩka Teoso sãkire sãpiretakari Xonasini inakori auakasaaki, Teoso kamari posotiiretxi. Ikara atoko inakari posotiiretxi Xonasini auakasaaki, iuaĩkana ikamapanikariko. Iua posotiiretxi Teoso takaõtxikare itxapanikaua hĩte ĩkapani. Iua takaõtxikarinoka Teoso takaõtxikare hĩte ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kitxakapirĩka Nínivi sitatxiti auakani imarotari Teoso iokanatiniri Xonasi ninoamoni. Iua atokokana kãkiti uatxa auakani imarotariko Teoso iokanatinino nota kãkiti itari iaxitikiri ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—Kitxakapirĩka sito Sapaa auakani auĩte sari õtakoxiti auĩtetxi Saromão inakorimoni imarore okenakotini ĩkapani. Kãkiti misiritiko õti apokasaaki, oa sito txitanako kãkiti uatxa auakani, kotxi uatxa uai aua Apiatakari. Iua Saromão auĩtetxi itxaua, iuaritika uatxa uai aua auĩtetxiakori auĩte. Txamari kãkiti uatxa auakani !inirekari ikenakotinirina nota sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","—Kãkiti misiritiko õti apokasaaki, kãkiti Nínivi sitatxiti auakani txitaiko hĩte ĩkorasaaki auakani, kotxi ninoa kenakotari Xonasi sãkire. Iuasaaki itakanaparina maerekati ikamakitina. Uatxa uai aua Apiatakari. Xonasi poiãoka. Hĩte kenakotapekari nota sãkire, txamari himaerekani !hĩtakanapa —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Iuaĩkana Xesosi sãpirenauata: —Kãkiti iopotokakasaakiri tirikapi, itano itaka ikinimane ĩroãkani atamarauatini ĩkapani. !Ikipatari tirikapi. !Iomaãtari tirikapi kopiti ãki. ");
INSERT INTO apuNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Poki tirikapi atoko itxa piĩto ĩkapani. Poki ereka inakasaaki ipinikare aua pãkixinireẽ. Poki maerekanisaaki, pãkixinireẽ mapiãriko. ");
INSERT INTO apuNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Erepaniko. Atxiĩti piuãkatari ipinikare pãkixinireẽ auini, txamari atxiĩti ipiãnoka auari pãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ipinikarenoka pãkixinireẽ auiniã, ipiã na xatiki auinii, tirikapi iopinikinii atoko itxa —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Xesosi sãkirauataka atoko pariseo aiatari Xesosi: —Manipokota naapoko —itxari. Ininiã Xesosi sari iuakata. Apokaãka atoko, iitopãka inipokotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Iua pariseo tsorĩkaãnãta Xesosi marokauakotakaniãua inipokotini apisa, kotxi iuasaaki Xesosi !ikamari Xoteo kiomaneakorini oerekakiti iaõka. ");
INSERT INTO apuNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ininiã Xesosi: —Hĩte pariseoakori arokari hiĩto, txamari hãkixinire patxikopiĩri, kotxi maerekatinoka hĩkama. Kapotxinaniri hĩtxaua. Iãkoanatxi inopininoka arokiko atoko hĩtxa. Pirato inopininoka arokiko atoko hĩtxa. ");
INSERT INTO apuNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","!Kiĩkitei hĩte. Teoso hiĩto kamakari kamari hãkixinire apaka. ");
INSERT INTO apuNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Iãkoanatxi ãki auakari iãriã hĩsikako matxineirotenimoni. Hĩpratone ãki auakari nipokori hĩsikako matxineirotenimoni. Hĩtiretariko apanakini. Ikara atoko hĩkaminiã, Teoso atamatari hãkixinire ereka inini. ");
INSERT INTO apuNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—Hĩte pariseoakori misiritaãkako. Hĩte sikari ipixini hĩtakare kikio auakari Teosomoni Moisesi paniãtakiti iaõka. Apikomoni hĩkama, kotxi ipixini takari kanaua ãki hĩtakakiti apaka hĩsika Teosomoni, oteraã, seporĩa hĩsika. Erekapitikamari hĩte sikakiti Teosomoni, txamari himisirienetari kãkiti. Teoso !hĩtireta. Erekari ipixini hĩtii hĩsikiniri Teoso. Iuakatikana erekari atão hĩkaminari kãkiti. Erekari atão hĩtiretiniri Teoso. ");
INSERT INTO apuNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—Hĩte pariseoakori misiritaãkako. Hĩte potxitari hiĩtopãkini kãkiti apisatoõ, aiko ãki Xoteo apotiitiniãtaãua kãkiti atamatinii ĩkapaninoka. Nipokori sikaretikoãtaã hãuakasaaki, hĩte apokaerekatari kãkitipokoni paxitinii hĩte koerekareri hininiãua. ");
INSERT INTO apuNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—Hĩte pariseoakori misiritaãkako. Akauari matakaõtxiãkoti atoko hĩtxa. Iua nopini kãkiti napa imimarotakoniã, kotxi hiĩto peerekari, txamari hãkixinire !erekari. Akauari ãki arakakari atoko itxa hãkixinire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ikara sãkiretxiti kiki Moisesi paniãtakiti oereẽkari kenakotakasaaki, omanãkarauata. Itxari Xesosi: —Koerekareri, ikara atoko pisãkirauatiniã, ate apaka “maerekati kamakani” pitxataua ate —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ininiã Xesosi: —Hĩte Moisesi paniãtakiti oereẽkanii hĩtekanerako misiritaãkako. Hĩte paniãtari kãkiti hĩteka paniãtakiti ikaminina. Ninoa !iposotari ikinika hĩpaniãtakiti ikaminina. Iminani ninoa porikiã hĩtakini atoko hĩkamanãta hĩte. !Iposotarina anikinirina. Hĩte apaka !hĩkamari hĩteka paniãtakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Hĩte misiritaãkako. Hĩte kamari takaõtxikari peereri Teoso sãkire sãpiretakanini ikatikoãtaã hĩtakini. Txamari hĩte atokiriakorinikara okapena ninoa Teoso sãkire sãpiretakanini. ");
INSERT INTO apuNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iuaritika hĩte sãpiretari ikinimane hãpokaerekatiniri hĩte atokiriakorini kamakiti. Txamari ninoara okana Teoso sãkire sãpiretakanini. Hĩtera takari takaõtxikari peereri ninoa Teoso sãkire sãpiretakanini akauariãtaã, ininiã kãkiti uãkatari hĩpaxitinina ninoani, txamari !hĩkamari ninoani paniãtakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","—Paimatireri Teoso, kotxi mitxipe imarotari ninoa kamakiti tĩkane. Mitxipe iua txari: “Nota iokanatanako nisãkire sãpiretakani, niokanapirena aniãkani pakini ninoamoni, txamari ninoa okapanikana apanakini. Imisiritapanikana apanakini,” itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kãkiti uatxa auakani misiritaãkako, Teoso sãkire sãpiretakanini okiko xika. Teoso itixi ikamakasaakipeka ipotorika Teoso sãkire sãpiretakani okiko. ");
INSERT INTO apuNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Merepitipanika Apeo inakori okapeẽka. Eereka apanakini okaãpotapeẽka. Imapotõkire okakori Sakaria inakori. Teosomoni sikakori takikoãtaã takote, Teoso Auini Pakitaãtaã takote apaka, iuaã okapeẽka Sakaria. Inipitikara nota sãpiretai hĩte, uatxa auakani misiritaãkako ninoa Teoso sãkire sãpiretakani okiko xika. ");
INSERT INTO apuNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Hĩte Moisesi paniãtakiti oereẽkani misiritaãkako. Hĩte kipatari atão inakari Teoso iokanapirena. Hĩte apaka !auikari ikara. !Hãuiritari apanakini auikiniri —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ikara Xesosi sãkire xika, Moisesi paniãtakiti oereẽkani, pariseoakori pakini tsoata, Xesosi omanatinina. Ãtipirika ipimaãnãtapikarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Inirekarina Xesosi kerokiniri isãkire, imaĩkiko ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kãkitipokoni apotiitaua kinapokopeka, ininiã ikatxarakititakakauana. Iuasaaki Xesosi merepanika õtãkikana imoianariakori: —Erepaniko pariseoakori sãkire. Pamonõkoniri isãkirena, kotxi !ikamarina isãkirena iaõka. Ikara imaerekanina kipataua pão tireẽkari pani koketakori atoko itxaua. Eereka imarotaãka imaerekani. ");
INSERT INTO apuNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ikinika seretakori oerekaãkako. Ikinika kipatakori imarotaãkako. ");
INSERT INTO apuNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ininiã ipiãpokoã pisãpiretakiti, pokamara imarotaãkako. Aapokotxi katoreri ãki pimaasakapiretakiti aapokotxi nopini akiritaãkako ikinimane imarotiniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","—Nimoianariakori nõtãkikapanikai hĩte. !Hĩpĩkapiri hĩte okakani tĩkane. Hiĩtonanira iposotana okinina. Hĩxinire !iposotana okinina. ");
INSERT INTO apuNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nisãpiretai hĩpĩkakiti tĩkane. Teosora hĩpĩkako. Iuara posotari hiĩto okini, eereka iposotari iokanatinii maerekani misiritikoãtaã. Ari, iuara hĩpĩkako. ");
INSERT INTO apuNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—Kiripa ipi ipi ãti pakini kotipiriki karone? Poiãonoka txineiro, ota ipinoka. Iuaritika Teoso !imaxinĩkaretari ãtika kotipiriki. ");
INSERT INTO apuNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kipakinipa piãko pikiiã auakari aua? !Pimarotari. Teoso imarotapitikari, kotxi iteene inĩkatai, ininiãkara !hĩpĩkarauatape. Kotipiriki ĩki poião, iuaritika Teoso tiretari kotipiriki. Kaiãopokori kotipiriki auiniã, iuaritika hĩte ĩki apiata, ininiã Teoso tiretapitikai hĩte —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Xesosi sãpirenauatapanika: —Apikomoni nisãpiretai. Kãkiti ikinimanemoni: “Xesosi nakiti nitxaua nota,” inakari, iua atokokana nota hĩtari iaxitikiri txako Teoso nitiriakorimoni: “Nota nakitipitikara iua,” nitxako. ");
INSERT INTO apuNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kãkiti ikinimanemoni: “Xesosi nakiti !nitxaua nota,” inakari, iua atokokana nota hĩtari iaxitikiri txako Teoso nitiriakorimoni: “Kona nota nakitini iua,” nitxako. ");
INSERT INTO apuNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","—Kãkiti misãkirepiretiniãno nota hĩtari iaxitikiri, eereka amanainiãri Teoso ikara imaerekani imakatxakini, ininiã Teoso makatxakapitikari. Kãkiti misãkirepiretiniãri Erekari Matamatakoti, !kimakatxakikori ikara maerekati ikamakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Hanikikosaaki aiko Xoteo apotiitiniãtaãua hãpoĩtikoã, hanikikosaaki auĩtetxiakorimoni hãpoĩtikoã, mitxi !hĩxinikapiri hĩte apoĩtakani hãpakapapiretini. Maerekaxiniretinoka !hĩtxape. ");
INSERT INTO apuNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Iuasaaki ninoa apoĩtakasaakii, Erekari Matamatakoti sãpiretaiko hĩte hãpakapapiretini ĩkapani —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kiki kãkitipokoni sauaki misãkiretari Xesosi: —Koerekareri, pipaniãtari nitari sikinino nota ipixini aĩrini tii ipĩkasaaki itakanapakiti —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ininiã Xesosi: —Naõkimanere, kona nota parĩkani pirini tii nixanakini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ininiã Xesosi misãkiretana ikinimane: —Erepaniko. !Erekari tiitxi iteene pinirekini. Kapotxinani !hĩtxape. Itomaneri tiitxi !itxĩkitakai okanani pauini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ininiã Xesosi sãpiretari ia sãpirenatxi atão inakari oerekiko: —Kiki katxineiroteri aua kikio mitari. Itakare peerekari, kaiãopokori. ");
INSERT INTO apuNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ixinikaxitita ãkixinireẽ: “Nãpa ninĩkatari nikiena? Nikiena nĩkatikoãtaã xapitikiri. !Apakata itomaneri nikiena ĩkapani. Kipa nikama? ");
INSERT INTO apuNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ari, nimarotari nikamakiti tĩkane. Nõtikariko nikiena nĩkatikoãtaã. Iuaĩkana nikamari ãti mitari. Iuaã ikinika nikiena, nitii apaka ninĩkata. ");
INSERT INTO apuNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Eereka notaka nitxauako: ‘Peerekano nota. Kaiãopokori nikiena. Kaiãopokori nitii. Apakatapitikako kaiãopokori anokanani ĩkapani. Ininiã !niparĩkauataika. Ninipokotako, niãtako, nipoxokoniuatako nitxako,’” itxa iua kiki. ");
INSERT INTO apuNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Txamari Teoso misãkiretari iua: “Kiĩkitei pite. Uatxa ia ĩkanõkati pipinako, ininiã kipa apakapatari ikinipoko pikiena, pitii apaka?” itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","—Ikara atoko itxa kãkiti tiitxinoka xinikakari, Teoso maxinikati —itxa Xesosi ikara sãkiretxiti ixipokini. ");
INSERT INTO apuNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ininiã Xesosi misãkiretari imoianariakori: —Ininiãkara nota sãpiretai hĩte, maerekaxiniretinoka !hĩtxape, hiniãkiti nire, mãkatxi hĩeretaãkiti nire. ");
INSERT INTO apuNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nipokori, mãkatxi pakininoka kona txĩkitakari pauini ereka inini. Nipokori, mãkatxi pakini poiãoka. ");
INSERT INTO apuNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hãtamatari kotipiriki. Ninoa !itakarauata. !Amarina ikiena. !Ipotetarina ikiena. Iuaritika Teoso sikakienatana ninoa. Teoso nĩkatiniãri kotipiriki, inĩkatapitikai hĩte apaka. Hĩte ĩki apiata. ");
INSERT INTO apuNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kinirepa maerekaxiniretinoka pitxa? Pimaerekaxinirene !itxĩkitakai apikomoni ãti oara pauini. ");
INSERT INTO apuNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pimaerekaxinirene kona txĩkitakai axapitiki apikomoni pauini, ininiã kinirepa maerekaxiniretika pitxa? ");
INSERT INTO apuNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","—Aãui pixinikako. Kona aãui parĩkauata. !Ikamari imãka, iuaritika aãui peereri. Kitxakapirĩka auĩtetxi Saromão inakori, iteene katiiri itxaua. Kaiãori imãka ereri, iuaritika apia ereri ikinika aãui. ");
INSERT INTO apuNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Aãui !okanani aua. Uatxa aua. Katana ikatikata iotikaãka. Iuaritika Teoso nĩkatari aãui. Ininiã apiata inĩkatai hĩte. Ikamamãkatapitikai. Poiãonoka hĩte auikari Teoso sãkire. Ikara xika maerekaxiniretinoka hĩtxa. ");
INSERT INTO apuNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ininiãkara maerekaxiniretinoka !hĩtxape. !Hĩxinikanãtapiri nipokori mauakanisaaki, iãriã mauakanisaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kãkiti Teoso sãkire mauiãkani ikiniõtika maerekaxiniretinoka itxana imãkana ixinikinina xika, inipokore ixinikinina xika. Hĩri imarotari himãka hinirekini, hĩkiena hinirekini. ");
INSERT INTO apuNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Merepitipanika pinirekariko Teoso piauĩte ininiãua. Iua nireẽkiti pikamako, ininiã, himãka, hĩkiena apaka Teoso sikaiko hĩte —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—Ininiã hĩte ninakitiakori !hĩpĩkarauatape, kotxi hĩri apokaerekatari isikinii ikinipoko erekari iua auĩtetxi ininiãtaãuakiri. ");
INSERT INTO apuNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ikinika hĩtii hĩvẽtxitako. Txineiro hĩsikako matxineirotenimoni. Ikara atoko hĩkaminiã, hĩparĩka ĩki auapitika Teoso tixine. Iuaã hĩparĩka ĩki !ixipoka. Kiĩtiriri !ĩtirĩkari. Kiĩriki !inikari. Iuaã hinĩkatariko hĩparĩka ĩki. ");
INSERT INTO apuNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Erekari hĩparĩka ĩki Teoso tixine auiniã, ininiãkara iuaã pixinikapika. Iuaã pinirekari pauini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Xesosi sãpirenauatapanika: —Himerekako, kamãka hĩtxako. Tirikapi hĩopotokakako. Iposope hĩtxako niparĩka hĩkamini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nitiritxi ipatrãotena iãtapakani atoko hĩtxako. Ipatrãotena sari ĩtanorouatakari kiiniritemoni. Initiriakori iãtapari ikanapiriini. Apokasaaki, akiritakasaaki, pakoteri initiriakori matakakari itore ipatrãotena ĩroini ĩkapani. Ninoa nitiritxi atoko hĩtxako. ");
INSERT INTO apuNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Patrão apokasaaki initiriakori merekapanika inakasaaki, iãtapanãtakasaakiri iua, ininiãkara erekapitikari. Himarotatari patrão kamakiti? Iua ieretakari imãka iparĩkauatini ĩkapani. Ipaniãtana ninoa topãkini. Eereka isikakienatana initiriakori. ");
INSERT INTO apuNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Erekapitikari ipatrãotena apokasaaki imirekiniãna. Atxiĩti apanĩkanõka apoka ipatrãotena. Atxiĩti imaropirĩkata apoka ipatrãotena, iuaritika iposope itxana, ininiã erekapitikari. ");
INSERT INTO apuNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","—Hĩxinikari ia. Kaapokori imarotaãkamariko kiĩtiriri apokini, !auiritamariko iua aapoko ĩroini itii ĩtirĩkini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hĩtepekana, hĩte apaka iposope hĩtxako, kotxi nota hĩtari iaxitikiri kanapiriãko. Iuasaaki, “!Apoka uatxa,” hinakasaaki, iua õtipitika nota kanapiriã uai —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petro misãkiretari Xesosi: —Apiananiri, ikara sãpirenatxi atão inakari oerekiko pisãpiretakiti, atenani poerekini ĩkapanikani? Ikinimane poerekini ĩkapanikani ikara pisãpireta? —itxa Petro Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ininiã Xesosi: —Nitiritxi kimaroreri ipatrãote paniãtakiti kamakari ia atoko itxako. Iuara apanakini nitiritxi auĩte itxaua. Iuara sikakienatana apanakini nitiritxi nipokotiko manapi. ");
INSERT INTO apuNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nitiritxi ipatrãote paniãtakiti iaõka kamakari poxokoniuata ipatrãote apokasaaki, kotxi ipatrãote paniãtakiti iaõka ikama. ");
INSERT INTO apuNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ipatrãote auiritariko iua ikinika itii, aapoko, ikikiote pakini inĩkatini. ");
INSERT INTO apuNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","—Txamari atxiĩti ãti patrão nitiri !inirekari ipatrãote paniãtakiti iaõka ikamini, ipatrãote auapokotini xika. Atxiĩti inoropatari apanakini ipatrãote nitiriakori, apanakini ipatrãote niteroakoro apaka. Atxiĩti inipokota, kapoãro iãta, ipoãta. ");
INSERT INTO apuNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ipatrãote apoka initiri mimarotakanisaaki, ininiãkara initiri !iposopanika ipatrãote apakapini. Ikara xika ipatrãote misiritari iua. Eereka iokanatari iua Teoso sãkire mauiãkani misiritikoãtaã. ");
INSERT INTO apuNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","—Nitiritxi ipatrãote nireẽkiti imarotakari makamakaniãri ipatrãote paniãtakiti iposope inini ĩkapani, ixirokitataãkako aãpitsaã. ");
INSERT INTO apuNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nitiritxi ipatrãote nireẽkiti mimarotakati kaminiãri maerekati, ixirokitataãkako, txamari poiãonoka. Teoso sikari parĩkatxi, imaroretxi pakini kãkitimoni. Kaiãopokori parĩkatxi, kaiãopokori imaroretxi isikiniãi pitemoni, ininiã Teoso nirekari pite iteene parĩkauatini iua ĩkapani. Apikomoni parĩkatxi, apikomoni imaroretxi isikiniãi pitemoni, ininiã Teoso nirekari pite apiata piparĩkauatini iua ĩkapani —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Xesosi sãkirauatapanika: —Teoso misiritariko kãkiti imaerekani xika. Xamina tirinini atoko itxa kãkiti misiritiko. Ia itixi napoka ikara xamina tirinini nitxĩkitakini ĩkapani. Ninirekari ikara niparĩka nixipokini. ");
INSERT INTO apuNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nota atatsiirauatako. !Erekaxinireno. Ninirekakari natatsiirauatini katima xipokaka inini. ");
INSERT INTO apuNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kona neenamatxi niotokakini ĩkapanini napoka ĩkorapokoriti. Nota sãkire auikiko xika neenamatxi auapitikako. ");
INSERT INTO apuNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Aapokotxi ãki auakani sĩko. Atxiĩti ipi ãti pakini naiatari ipi, atxiĩti ipi naiatari ipi ãti pakini, nota sãkire auikiko xika. ");
INSERT INTO apuNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Irĩtxiakori omanatana ninoa ãkiri nota sãkire auikiko xika. Ninoa ãkiri omanatana iriakori. Inorotxiakoro omanatana ninoa ãkero. Ninoa ãkero omanatana inoroakoro. Imakirotxiakoro omanatana otiiroakoro. Otiiroakoro omanatana oimakiroakoro nota sãkire auikiko xika —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Xesosi iuaĩkana misãkiretari kãkiti: —Atokatxi ereẽkokinimoni ipiãkaãpotakasaaki, “Ãparaãnapani,” hĩtxa. Ari, ikipapitikako. ");
INSERT INTO apuNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ĩtima ikiitaã ĩkari apokasaaki ĩkorapokoriti, hĩte: “Kamoĩpani,” hĩtxa. Ari, kapatakapitikariko. ");
INSERT INTO apuNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kamisirienererini hĩtxaua. Hãtamatari iaxiti, itixi pakini, ininiã himarotapitikari ãparaã, kamoĩ pakini. Kinirepa kona hãtamatano nota? Kinirepa kona hĩkenakotari nisãkire Teoso kamaenetakiti himarotini ĩkapani? —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—Kinirepa hĩteka na xinikari atão inakari hĩkamini tĩkane? ");
INSERT INTO apuNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Maerekati pikamakasaaki, ãti nirekari anikinii pimisiritiko mereẽkarimoni. Iua anikinii apisapanika, pisãkirauata iuakata atão pikamini ĩkapani, ininiã iua !anikaikai pimisiritiko mereẽkarimoni. Pimamisãkiretakaniãri, iua anikaiko pimisiritiko mereẽkarimoni. Eereka pimisiritiko mereẽkari sikaiko sotatomoni. Eereka sotato takai kateia ãki. ");
INSERT INTO apuNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Atão nisãpiretai, kona posipikari kateia ikinika pimisiritiko mereẽkari paniãtakiti pimiĩkitxitakanisaaki —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Xesosi sãkirauatakasaaki, kãkiti iuaã auakani sãpiretari iua Kariréia auakani okiko pirena. Ninoa Teoso misãkiretiko aikotiã auakasaaki, ninoa okari ipirana imaerekanina Teoso makatxakini ĩkapani. Ininiã iuasaaki Pirato sotatone apoka iuaã. Iuasaaki ninoa okana. ");
INSERT INTO apuNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Xesosi imarotari kãkiti ãkixinire xiniãkiti. Ininiã ia atoko itxa: —Hĩte uãkatari ninoa Kariréia auakani maerekani apiata. Ininiã, “Ikara atoko inapeẽkana ninoani,” hĩtxa. ");
INSERT INTO apuNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Konapitini. Nota sãpiretai hĩte, himaerekani himatakanapakanisaaki, hĩpinako ninoa atokokana hinaãkako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ininiã Xesosi sãpiretana ninoa apanakini ipinini pirena: —Xerosareẽ aua Siroee inakori aapokotxiti. Iua aapokotxi ĩtanori irika. Irikasaaki, tesoito kikiakorini ipĩpe. Hĩte uãkatana iuaã auakani apia maerekani itxauana? ");
INSERT INTO apuNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Konapitini. Hĩtekanera himaerekani himatakanapakanisaaki, ninoa atokokanera hĩpina —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ininiã Xesosi sãpiretari ãti sãpirenatxi atão inakari oerekiko: —Aua kiki. Initirikata isari ikikiote atini ĩkapani. Iuaãtaã aua amãtiiri piko inakori mina. Iuaã apokasaaki, maritoka otxa itakare. ");
INSERT INTO apuNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ininiã itxari: “Ipikanani ãtikanani pakini ninapiima. !Kariro. Ininiã erekari otokiko, kotxi kona oĩriuata. Ininiã kona erekari uai okaikotini, kotxi oxipokari takari kiena kipatxi ãki auakari,” itxari initiri. ");
INSERT INTO apuNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ininiã initiri: “Kona pitokapero. Nota oeretariko opatapi. Ãti kipatxi erekari patari tikakata nitakapatapitaroko. ");
INSERT INTO apuNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ãtikanani inakasaakiua karipeka oniniã, ereẽ oãua. Erekari okaikotini. Omiriuatakanisaaki, iuasaaki erekapekari otokiko,” itxa initiri —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tomatiko õtisaaki Xesosi auari aiko Xoteo apotiitiniãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Iuasaaki sito apoka. Tesoito anokananipeka ina amianaretakaro. Ia atoko otxa amianareta. Okomĩkaãpota, kotxi maerekati matamatakoti amianari kamakari ĩroaĩtotaro. Kona oposota oõkitikaĩtotiniãua. ");
INSERT INTO apuNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Xesosi atamatakasaakiro, itxaro: —Sito, erekapitikaiko uatxa —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ininiã itakari iuako onopini. Iuasaakipeka oõkitikaĩtotaua. Ininiã iuasaaki otxa: —Peerekari Teoso. Erekari imakinika ikamakiti —otxa. ");
INSERT INTO apuNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Iuasaakipeka Xoteo apotiitiniãtaãua aikotiã auakani auĩte naiataua, kotxi tomatiko õtisaaki Xesosi makananitaro amianatakaro. Ininiã iua txitari kãkiti: —Auari seisi pakini õti kãkiti parĩkauatini ĩkapani. Ininiã ĩkora seisi õti hina iua makananitinii ĩkapani. Kona hinape tomatiko õti erekapeka hĩtxĩkitakiko ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ininiã Xesosi txari iua: —Hĩsãkire atxiĩti erekari, txamari kona hĩkamari hĩsãkire iaõka. Tomatiko õtisaaki hĩte tiretari hĩpiraakori, kotxi hanikari hĩpiraakori, kema auĩte iaãmoni ãparaã iãtinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Oia sito Apraãoni apika mekaniro otxaua. Satanasi kamaamianaretaro oa tesoito anokananipeka. Iaõpe. Apakatapitika tomatiko õtisaaki nitiretiniro oa, nimakananitiniro oa —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Xesosi apakapapiretakasaakina, imokaiakariakori pẽtauata. Iuasaaki apanakini iuaã auakani poxokoniuata, kotxi imarotarina erekari Xesosi kamakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ininiã Xesosi pimaãna: —Natokopa itxa Teoso auĩtetxi ininiãua? Kiãtokopa itxa axinikiniri? ");
INSERT INTO apuNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Teoso auĩtetxi ininiãua mostata iki atoko itxa. Kiki takaro mostata ikikioteẽ. Oa aneẽ. Mitape onakasaaki kotipiriki kamari ikoa okatiã. Ikara atoko itxa Teoso auĩtetxi ininiua —itxa Xesosi. Merepanika poião kãkiti auĩtetari Teoso. Eereka kaiãopokori kãkiti auĩtetari iua. Txamari iuasaaki Satanasi apoka ninoamoni kotipiriki apokini atokokana. ");
INSERT INTO apuNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iuaĩkana Xesosi pimaãna: —Natokopa itxa ĩkorapokoriti Teoso auĩtetxi ininiãua? ");
INSERT INTO apuNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ia atokokana itxa: Sito kosekari pão tirekakari pani. Okoketari axapiti pão tirekakari pani kaiãopokori triko panikata, ãparaãkata. Eereka ikinika ipe tirekaãpota otxa. ");
INSERT INTO apuNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ikara inaka atoko Xesosi potorika Xerosareẽ sitatxiti isini ĩkapani. Isaãpotakasaaki, isãpiretari Teoso sãkire. Isãpiretari ãti sitatxitiã, ãti aapokotxitiã, ãti sitatxitiã, itxaãpota isãpiretiniri Teoso sãkire kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Oerekarauanãtakasaaki, kiki pimaãri: —Niauĩte, poiãokani satako Teoso auiniãtaã? ");
INSERT INTO apuNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ininiã Xesosi apakapapiretari: —Teoso tixine ĩronakikoãtaã axapitiri. Hinirekariko iuaã hiĩroini. Kaiãopokori kãkiti nirekari ĩroinina. Txamari, !iposotarina. ");
INSERT INTO apuNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kaapokori totiniri aapoko tore atoko itxa. Itotakasaakiri, kãkiti iporikiti aritari itore: “Pimataakariko itore ate ĩkapani.” Iuasaaki iua kaapokori txako: “Kona nimarotai hĩte,” itxanako ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ininiã ninoa: “Ate nipokota pitekata. Sitatxi ate auiniãtaã pauakasaaki, pitekara oerekaua,” itxanako ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ininiã iuaĩkana itxako ninoamoni: “!Nimarotai hĩte. Namonipa hãua hĩte? Hĩsipiniikaua. Imakinika hĩkamakiti !erekari.” ");
INSERT INTO apuNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","—Hãtamatakasaakina Apraão, Isaki, Xakoo, ikinimane Teoso sãkire sãpiretakani pakini Teoso auĩtetxi ininiãtaãua, iuasaaki hĩtxiapatapitikako. Apanakini ĩroãpeka. Txama hĩtenoka kaikotape iporikiti himaerekani xika. ");
INSERT INTO apuNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Teoso auĩtetxi ininiãtaãua apokako kaiãopokori kãkiti, ikini itixiti ĩkani. Atokatxi pokĩkinimoni ĩkani, atokatxi ereẽkokinimoni ĩkani, atokatxi pokĩkini sanaremoni ĩkani, atokatxi pokĩkini kikomoni ĩkani pakini apokako Teoso kiiniritimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Merepitipanika Xoteoakori kenakotari Teoso sãkire, txamari !imaãkatari. Eereka Xoteo minakaniua kenakotari Teoso sãkire, ininiã auikarina. Ininiã Xoteo minakaniua apokako Teoso auĩtetxi ininiãtaãua Xoteoakori apokini apisa —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ikarasaakipeka ãtikaka pariseoakori apoka. Itxarina Xesosi: —Pisipiniikaua, kotxi Erotxi okaenetai —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ininiã Xesosi apakapapiretana: —Hĩsa iuamoni. Hĩtxariko iua aripa kamisirienereri: “Nota omitikari maerekati matamatakoti, apaka amianatakani erekapeka nitxĩkitaka. Uatxa, katana pakini niparĩkauatako. Ipi ãti õtisaaki nixipokariko niparĩka ĩkorapokoriti.” Ikara atoko hĩtxariko iua. ");
INSERT INTO apuNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ininiã uatxa niparĩkauatako. Katana niparĩkauatako. Ininiã katana eereka nisa Xerosareẽmoni, kotxi ãtiãtaã Teoso sãkire sãpiretakani okikoãtaã !auari. Xerosareẽnanira ninoa ipina. Ininiã nota sako iuaã. ");
INSERT INTO apuNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","—Xerosareẽ auakanii, Xerosareẽ auakanii, hĩte okapekana Teoso sãkire sãpiretakani. Kai soroã hĩkiporonakana ninoa hĩtemoni Teoso iokanatakini. Kaiãokatani ninirekamari ninĩkatinii, patari oimiakori omĩkita patapi otakini atokokana nitxanakamaiko hĩte. Txamari !hãuiritano nota nĩkatinii. ");
INSERT INTO apuNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ikara atoko inakari xika haãpoko asikaãkako. Teoso !auaika hĩtekata. Nisãpiretai. Ia õti hãtamatano, eereka !hãtamataikano. “Teoso takari erekari uaimoni ĩkarimoni, Apiananiri posotiireẽ ĩkarimoni,” hinakasaaki, iuasaakinanirako hãtamatanoko nota —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tomatiko õtisaaki Xesosi sari pariseoakori auĩtemoni, iuakata inipokotini ĩkapani. Iuaã auakani mixinitari iua apoĩtinirina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iuasaakipeka apoka kiki amianatakari. Ikanoke, itapike, imakinika ananaĩtota. Iua apoka Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ininiã Xesosi pimaãna Moisesini sãkire oerekakani, pariseoakori pakini. Ipimaãna: —Erekari atxiĩti tomatiko õtisaaki amianatakari erekapeka nitxĩkitakini? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ininiã ninoa tsorĩkaãnãta. !Apakapapiretarina. Ininiã iuasaaki Xesosi erekapeka txĩkitakari iua amianatakari. —Pisipeka paapokomoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Eereka ipimaãna pariseoakori: —Hĩpira kema auĩte, hĩpira poho apaka aariko ãki irikiniã tomatiko õtisaaki, iuasaaki himakatxakatari? Ari, himakatxakapitikari hĩpira tomatiko õtisaaki. Ininiã kinirepa kona hinirekatari erekari nikamini tomatiko õtisaaki? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Txamari kona ninoa apakapapiretari, kotxi atão Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iuasaaki Xesosi itikana kãkiti. Apanakini mereẽri kãkiti apiatakari takote iitopãkini. Ininiã isãpiretari ia sãpirenatxi atão inakari oerekiko. ");
INSERT INTO apuNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Kãkiti ĩtaniriuatini kiiniriti pirena isãpireta: —Kiiniriã hĩsikasaaki, kona himereẽpiri kãkiti apiatakari topãkiniãtaã hiĩtopãkini, kotxi atxiĩti eereka kemaĩtxitakori apiatakari apoka. ");
INSERT INTO apuNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ininiã iua apiatakari apokasaaki, kakiiniriteri txaiko pite: “Ikiraã piitopãka. Ia kiki topãka nota takote.” Iuasaaki pipẽtauata. Ininiã pitakanapari iuaã. Maparapeka apanakinikata topãka pitxa. ");
INSERT INTO apuNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kiiniriã hĩsikasaaki, apanakinikata hĩitopãka. Ikara atoko ininiã, kakiiniriteri akiritai: “Nitari uaimoni pina. Piitopãka uai. Uaira erekari.” Ikara atoko pininiã, apanakini iuaã auakani imarotariko pite apiatakari pininiãua. ");
INSERT INTO apuNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ãtikaka kãkiti txari: “Nota apiari nitxaua.” Txamari Teoso txariko: “Poiãori itxaua.” Ãtipekana txari: “Nota poiãori nitxaua.” Txamari Teoso txariko: “Iua apiari itxaua.” ");
INSERT INTO apuNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Xesosi txari ikemaĩtxitakiri: —Kiiniri pikamakasaaki, kona pikemaĩtxitapiri pinirimane, pitariakori, paõkimaneri, paapoko takote auakani, katxineiroteni pakini, ninoa iuaĩkana kemaĩtxitinii pite ĩkapani. Ininiã ikara atoko ninoa iĩkitxitai. ");
INSERT INTO apuNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Apiaerekata kiiniri pikamakasaaki, pikemaĩtxitari kãkiti minakati mauakiniti, mokirini, matĩpokotakati pakini. ");
INSERT INTO apuNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ikara atoko pininiã, Teoso sikari erekari pitemoni, kotxi ninoa !iposotari kiiniri ikaminina, iuaritika kãkiti erekarini iuaĩkana õkitikasaakiua, iuasaaki Teoso ĩkitxitaiko pite —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ininiã ãti Xesosikata nipokotakari kenakotari ikara Xesosi sãkire. Ininiã iua txari: —Teoso auĩtetxi ininiãtaãua sikani nipokotako iuaã. Ininiã iuasaaki Teoso sikapoxokonitana —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ininiã Xesosi apakapapireta. Ia atoko itxa: —Kiki kiiniri kamakari kemaĩtxitari itomaneri kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nipokori iposopeka inakasaaki, iokanatari initiri ikemaĩtxitakinimoni: “Masa kiinirimoni. Iposopekari imakinika nipokori,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","—Txamari ikemaĩtxitakini kamari ãti sãkiretxi kiinirimoni imasikanina ĩkapani. Ininiã kemaĩtxitakori txari: “Nota amotari itixi. Iua ninireka natini. Ininiã !niposotari nisini kiiniriã,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","—Ininiã ãti: “Nota amotari tesi kema auĩte parĩkauatakani. Ininiã nota sari ninoamoni. Ninireka nimarotiniri ninoa parĩka. Pauiritano nisini ninoamoni,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","—Ãtipekana: “Nota ĩtanorouatape. Nĩtanoro auano nota. Ininiã kona niposota nisini pikiiniritemoni,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","—Ininiã initiri kanapiriã iauĩtemoni. Ikinipoko ikemaĩtxitakini sãkire isãpireta iuamoni. Ininiã iuasaaki iua auĩtetxi naiataua. Ininiã ipaniãtari initiri: “Sitatxi auakari kimaporitiã pisa. Katima pitxako. Piminana kãkiti minakati mauakini, matĩpokotakani, mokirini pakini pimina,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ininiã katimaritika ikamari ikinika auĩtetxi paniãtakiti. “Nikamapekari ikinika pipaniãtakiti, txamari auapanika nipokori. Apakatapanika kãkiti nikini ĩkapani,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","—Ininiã iuaĩkana, iua auĩtetxi paniãtari sitatxi mapara õtako isini. “Iuaã pakiritana kãkiti inini, naapoko kãkiti xãpokini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Atãopitikara nitxai: ‘Mitxi nikemaĩtxitakini !inikapaniri nikiena,’” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ãti õti itomaneri kãkiti moianatari Xesosi. Ininiã ikirioka sãpireta itxana ia sãkiretxiti: ");
INSERT INTO apuNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Nota kinirão moianataka hinakasaaki, apiata hĩtiretanoko nota. Merepanika hĩtiretanoko nota, eereka hĩtiretanako hĩri, hinoro, hĩtaniri, hĩtanoro, hĩtari, hĩtaro, hamarite pakini. Hĩteka apaka poião hĩtiretauako. ");
INSERT INTO apuNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nota kinirão moianataka hinakasaaki, notakata hĩsa. Himamĩteenekakanisaakiri himisiritiko nota ĩkapani, ininiã !apakata himoianatinino. ");
INSERT INTO apuNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","—Hinirekiniãri aapokotxi mitari sitatxi auakari atoko hĩkamini, merepanika hĩxinikaroko txineiro aapokotxi kamiko karone. Atxiĩti !apakata hĩtxineirote. Atxiĩti apakata. Ikara atoko hĩxinika merepanika. ");
INSERT INTO apuNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ikara maxinikati merepanika !ixinikari, ininiã atxiĩti itakari itsota, ininiã eereka txineiro !auaika, ininiã kona apakata imakinika ikamini. Ininiã apanakini napetari iua. ");
INSERT INTO apuNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ininiã ninoa txari: “Hãtamatariko ikamakiti. Iua kiki potorikamari ĩkora aapoko, txamari !iposotari imakinika ikamini.” Ikara atoko itxanako. Ininiã pikamakiti apisapanika iteene hĩxinikariko. ");
INSERT INTO apuNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ininiã eereka Xesosi sãpiretari ãti sãkiretxi: —Auĩtetxi auari tesi mio sotato. Iua nirekari neenamatxi ikamini ãti auĩtetxikata. Txamari ãti auĩtetxi auari vĩtxi mio sotato. Iua tesi mio sotato auakiti merepanika xinikari, atxiĩti iposota ineenamauatini vĩtxi mio sotatokata? Atxiĩti auĩtetxi vĩtxi mio sotato auakiti xipokari iua? Ininiã apisapanika ixinikari. ");
INSERT INTO apuNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Imaposotakaniãri, vĩtxi mio sotato õtakopanika auakasaaki, iua auĩtetxi tesi mio auakiti iokanapireta ãti auĩtetximoni isãkirauatinina ĩkapani, neenamatxi xipokini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Erekari iua auĩtetxi neenamatxi takanapakari atoko hinini. Ininiã merepanika hãkixinireẽ hĩxinikariko: “Nota nirekatari nimoianatiniri Xesosi, kotxi pasãpaniri?” hĩtxa. Atão hinirekiniãri himoianatinino, ininiã imakinika hĩtakanapako notakata hĩsini ĩkapani. Himanirekakaniãri hĩtakanapiniri imakinika, ininiã !apakata himoianatinino. Ininiã hĩxinikariko merepanika —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Iõkira peerekaro. Omatxoaniã, !otxaika. Aua kãkiti iõkira potxoaro atoko inakani, ininiã erekapitikana ninoa. Apanakini kãkiti iõkira matxoato atoko itxana. !Kakamarena ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Iõkira matxoato ininiã, !apakata takari sikakienatiko ĩkapani. !Apakata hĩkoketiniri kipatxikata, pirãtxi tikakata takari sikakienatiko ĩkapani. Kona erekaro. Maparamoni oõkapeẽkaika. Ikara atoko itxa apanakini, kotxi ninoa !kakamarena. —Kakenakokii hĩte, ininiã hĩkenakotariko ia nisãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ãti õti auĩtetxiakori txineirote apakapakani, apanakini maerekati kamakani apaka apotiitaua Xesosi sãkire ikenakotinina ĩkapani. Ninoa kaiãopoko. ");
INSERT INTO apuNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Iuasaaki pariseoakori, kaiõkatsopareriakori pakini misãkirepiretari Xesosi. Itxana: —Iua apakapari maerekani. Maerekanikata inipokota —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ikara isãkirena xika Xesosi sãpiretari ipi, ãti pakini sãpirenatxi atão inakari oerekiko. ");
INSERT INTO apuNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ia atoko itxa Xesosi: —Atxiĩti pite aua seĩ soti auĩte. Ãti pĩpinanakiniã, kipa pikama? Pitakanapari apanakini mapara inipokotiniãtaã apanakini nĩkatini ĩkapani. Ininiã eereka pisari pĩpinanakakari pinitini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Papokasaakiri iua pĩpinanakakari, pipoxokoniuata. Piporikiãpotari pipira paapokomoni. ");
INSERT INTO apuNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Papokaãka atoko pakiritana paõkimaneriakori, apanakini kãkiti pakini. Pitxana ninoa: “Hĩpoxokoniuatako notakata, kotxi napokapekari nipira pĩpinanakakari,” itxa soti auĩte pitikiri. ");
INSERT INTO apuNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","—Nisãpiretai hĩte, ãtika maerekati kamakari takanapakasaakiri imaerekani, iaxiti Teoso auiniãtaã auakani poxokoniuatapitikako. Atxiĩti novẽta novi kãkiti iuikakaniua txari: “Peerekaua ate. !Akamari maerekati,” itxana. Txama kona atão isãkirena. Ninoa sãkire kona kamari iaxitikini poxokoniuatini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Apikomoni Xesosi txari: —Sito aua tesi ota pirata kamakoro. Pakaronero. Ãto ereẽkokiniã, ininiã onitakasaakiro oiopotokakari tirikapi. Oiatiĩkaãpotari oaãpoko ota onitaãpotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Oa apokasaakiro, apanakini oãkirita: “Hĩpoxokonauatako notakata. Napokapekaro ota ereẽkokakaro,” otxa. ");
INSERT INTO apuNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","—Kãkiti poxokoniuata ota pirata kamakoro apokikosaaki. Nisãpiretai, iaxiti Teoso nitiriakori apiapoxokoniuata, ãti maerekati kamakari imaerekani itakanapakasaaki —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Apikomoni Xesosi txari: —Aua kiki. Ipi imiakori. ");
INSERT INTO apuNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Maneri takari amanaãri iri. Itxari: “Ninirekari pitakanapakito pipĩkasaaki pisikini notamoni uatxa,” itxa. Ininiã iri xanakari inakiti imiakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Eereka mapaõti inaka atoko, iua ãtokori apotiitari iri sikakiti. Ininiã eereka isipeka. Õtakoxiti ãti tixini isa. Iuaã maerekati ikama. Iuaã xipoka itxari iri sikiniri. ");
INSERT INTO apuNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","—Ikinika ixipoka iuaã. Iuasaaki ãparaã !ikipa. Natxipokoni auari. Nipokori !auari. Ininiã iuasaaki iua minakati !auari. Imakinika xipope. ");
INSERT INTO apuNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ininiã iuaxiti auakarimoni isa, parĩkatxi amanaini ĩkapani. Ininiã ipatrãote paniãtari irariakori isikakienatini. ");
INSERT INTO apuNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Irariakori isikakienatakasaaki, natxinoka itxa. Iuasaaki iua nirekari irariakori kiena inikini, kotxi iua sikakienatakari !auari. ");
INSERT INTO apuNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","—Iuasaakiika ixinikari iri aapoko: “Niri nitiriakori aua nipokori. Nipokori itetakori auapitika. Uai natxinoka txapeno nota. ");
INSERT INTO apuNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nikanapiriãko niri aapokomoni. Nitxariko niri: ‘Maerekati nikamapeka Teosomoni, pitemoni apaka. ");
INSERT INTO apuNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kona pamarite na pitxaikanoko, kotxi !erekano. Pitxĩkitakano pinitiri nininiua.’ Ikara atoko nitxariko niri,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ininiã iua aiamata, kanapiriã itxa iri aapokomoni. Iuasaaki iri iãtapanãtari iua ikiniõtika. —Ininiã iua apokaãpotakasaaki, õtakopanika, iri atapari iua. Ininiã iri miteẽkata iuamoni. Ininiã iteene ipoxokoniuata. ");
INSERT INTO apuNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Iuasaaki imi txari iri: “Niri, maerekati nikamapeka Teosomoni, pitemoni apaka. Kona pamarite na pitxaikanoko, kotxi !erekano.” ");
INSERT INTO apuNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","—Iuasaakipeka iri akiritari initiriakori: “Katima hĩtxako, mãkatxi ereri himinini. Aneo ereri hĩtakako iuakokimoni. Ikiti mata hĩtakako ikitiã. ");
INSERT INTO apuNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kema auĩte kiĩri hõkako. Kiiniri makamako. Manipokota. Mapoxokoniuata, ");
INSERT INTO apuNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kotxi ia namarite ipĩkari atokopeka, uatxa iuaĩkana ikanapiripeka. Mitxi pĩpinanakakari atoko itxa, uatxa apokapeẽkaika,” itxa. —Ininiã iuasaaki ninoamoni ipoxokoniuatini apopeka. ");
INSERT INTO apuNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ninoa kiiniritauatakasaaki, imi aneẽkari tokoriã iparĩkauanãta. Ikanapiriãkasaaki aapokomoni, ikenakotari xikari, serẽkatxi ene pakini. ");
INSERT INTO apuNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ininiã akiritari iri nitiri: “Kiripa ikara?” itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Iri nitiri apakapapireta: “Pitari apoka. Ininiã piri paniãtari kema auĩte okiko, kotxi erekapanikari pitari. Kona monõkori apoka iuamoni. Erekari ikanapiriini,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","—Ininiã ikara ikenakotakasaaki, inaiataua. Kona inirekari ĩroini kiiniriã. Ininiã iri iuamoni sa itxa. Akiritari: “Piĩroã,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ininiã iua apakapapiretari: “Itori mitaãti niparĩkauatinapekai. Txama kona nota sipikapiretari pisãkire. Iuaritika kona pisikano potxi ãkiri nimoianariakorikata kiiniri nikamini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Iua pamarite xipokari pitxineirote. Sitokata isirĩka. Txama ikanapiriãkasaaki, pokari kema auĩte. Kiiniri pikama iua ĩkapani.” Ikara atoko itxitari iri. ");
INSERT INTO apuNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","—Iri apakapapireta: “Namarite, ãtipirika pauapika notakata. Ikinika nota nakiti pite nakiti txaua. ");
INSERT INTO apuNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Erekapitikari kiiniri nikamini apoxokoniuatini ĩkapani, kotxi pitari ipĩkari atokopeka itxa. Uatxa auapanika. Pĩpinanakakari uatxa apokapeka,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Xesosi sãpiretana imoianariakori: —Kiki ito tiitxi aua. Iua nitiri nĩkatari ikinika ipatrãote nakiti. Apanakini sãpiretari iua kiki, initiri iouanatiniri itxineirote. ");
INSERT INTO apuNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ikara atoko ininiã, iua akiritari initiri: “Nikenakopiretari pite misirienetinino nota. Ininiã piminari tiitxi piamotiitini tsopa. Ikara pisikasaakino, niokanatai pisini. Kona apikomoni piparĩkauataika nota ĩkapani,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","—Ininiã initiri ãkixinireẽ: “Kipa nikama uatxa, kotxi nipatrãote paĩtiki iokanatano. !Kataparano nota, ininiã !niposotari atokatxi patapi niparĩkauatini. Nipẽtauata txineiro maxikatiĩka namanainiri kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Uatxaika nimarotari nikamakiti tĩkane. Ininiã niparĩka xipokasaaki uai, kãkiti apakapapanikano nota ninoa aapokoã,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","—Ininiã akiritana kãkiti ipatrãote maĩkitxitakani. Ininiã ipimaãri ãti: “Kipakinipa !piĩkitxitapanika nipatrãotemoni?” ");
INSERT INTO apuNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","—“Seĩ kopiti iĩtxi auakiti kona niĩkitxitapanika,” itxari. —Ininiã iua nitiritxi txari: “Pikosekari pimaĩkitxitakiniti tsopa. Pitakari sĩkoẽta kopitinoka,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","—Ininiã ãti ipatrãote maĩkitxitakari ipimaã: “Kipakinipa kona piĩkitxitapanika nipatrãote?” —Iua apakapapiretari: “Seĩ atarokiri kotarina,” itxa. —Itxari iua: “Pimaĩkitxitakiniti tsopa pikoseka. Oitẽta kotarinoka pitaka,” itxa. Ikara atoko ikama ninoa ĩkapani, ininiã iparĩka itakanapaka atoko, ninoa apakapari iua ninoa aapokoã. ");
INSERT INTO apuNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","—Ininiã iua patrãote ikara imarotakasaaki, itsorĩkaãta: “Ari, ninitiri paimatireri. Maerekati ikama, iuaritika ikamakasaakiri, paimatireri iua,” itxa. —Teoso sãkire mauiãkani imarotapitikari ixinikinirina parĩkatxi katana ikamakitina. Atxiĩti Teoso sãkire auiãkani !imarotari ixinikinirina parĩkatxi katana ikamakitina. ");
INSERT INTO apuNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nisãpiretai hĩte, ĩkorapokoriti hãuakasaaki, hĩxinikari ikara nitiritxi. Hĩsikari hĩtii, hĩtxineirote pakini Teoso parĩka ĩkapani, Teoso mimarotakani atão inakari imarotinina ĩkapani. Eereka atxiĩti Teoso mimarotakani moianatai. Eereka ninoa apaka imarotari aĩri iaxitikiri. Eereka ãti õti haõkitana ninoa iaxiti. ");
INSERT INTO apuNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","—Axapitiki parĩkatxi atão pikaminiã, ininiã kãkiti auikariko piposotiniri parĩkatxi apiatakari pikamini apaka. Axapitiki piĩtiriuata mitxi, ininiã eereka kaiãori piĩtiriuata. ");
INSERT INTO apuNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Txineiro uaimonipokoriti auakari himimarotakaniãri hinĩkatini, ininiã kona hĩposotari hinĩkatiniri erekari Teoso sikakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Apanakini tii pimanĩkatakaniã, ininiã kona kãkiti sikai tiitxi pinakiti inini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—!Apakata kãkiti parĩkauatini ipi iauĩtena ĩkapani, kotxi atxiĩti ãti omanata, ãti itireta. Atxiĩti ãti apokaerekata, ãti inorita. Iua atokokana kãkiti kona posotari iparĩkauatini tiitxi ikinipoko iamotini ĩkapani, Teoso ĩkapani iparĩkauatakasaaki. !Apakata piauĩtetiniri Teoso, txineiro piauĩtetakasaaki —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pariseoakori ikara ikenakotakasaakina, inapetarina Xesosi, kotxi ninoa iteene potxitaro txineiro. ");
INSERT INTO apuNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ininiã Xesosi sãkirauata ninoamoni: —Hĩte txa apanakinimoni: “Ate !ikeroka. Peerekaua ate,” hĩtxa hĩsãkire. Txama Teoso imarotari hãkixinire. Kãkiti uãkatari erekari hĩkamini, txama Teoso omanatari hĩkamakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Kitxakapirĩka kãkiti auikari Teoso sãkire Moisesimoni sikakori, Teoso sãkire sãpiretakani sãkire pakini. Xoão kapatxisareri apoka. Iuasaaki Teoso iokanapirena erekari auĩtetxi ininiãua sãpiretaãka. Itomaneri iteene nirekari isini Teoso auĩtetxi ininiãtaãua ĩroini. ");
INSERT INTO apuNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","—Teoso sãkire !ixipoka. !Ixipoka axapiti. Auapika imakinika isãkire. Itixi, iaxiti pakini xipokapitikako, iuaritika Teoso sãkire !ixipoka. ");
INSERT INTO apuNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Teoso sãkire iõkatakori kitxakapirĩkari auapanika uatxa. Ininiã ĩtanorotxi asikakari ãto itakini ĩkapani inakari, maerekati ikama. Apaka sito takanapakoro takakari maerekatikanera ikama. Ikara Teoso sãkire auapanika. Kona ixipoka ikara —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Xesosi sãkirauatapanika. Ia atoko itxa: —Aua kiki katiiri. Peereri imãka. Põkamarari imãka. Apiaerekata imãka. Ikiniõtika peerekari ikiena. Imakinika iua auakiti peerekari. Iua aapoko ikiniõtika kiinirisaaki auakari atoko itxapika ikiena. ");
INSERT INTO apuNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","—Ãti kiki Arásaro inakori. Pamatinaniri. Minakati !auinari iua. Iua sirĩka katiiri aapoko patapi koa. Amianari aua iuamoni. Ininiã iĩto imakinika kakaro. ");
INSERT INTO apuNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kinirão nika inakasaaki, ixiti okakorinoka inika. Iuaã anãpa amerokari ikaro. ");
INSERT INTO apuNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","—Ikara atoko ininiã, eereka ipĩpe. Ininiã eereka Teoso nitiriakori iaxitikini anikari iua Teoso auinimoni. Kitxakapirĩka Apraão sari iuaã. Iuaã iua Arásaro aõkitari Apraão. —Eereka iua katiiri apaka ipĩpe. Ikataãka. Isari maerekani misiritikoãtaã. ");
INSERT INTO apuNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Iuaã maerekani misiritikoãtaã auakasaaki, õtakoxiti atamatari Apraão, Arásaro pakini. ");
INSERT INTO apuNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ininiã akiritari Apraão: “Toti Apraão, piamonĩkano. Pipaniãtariko Arásaro iãkiniri iuakoki iaã, tapikaka itxa ninamamoni. Ia xamina sikatsiitapitipono,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","—Apraão apakapapireta: “Pixinikariko kãkitikata pauakasaaki, kaiãori pitii aua pitemoni. Arásaro auakasaaki, kona minakati auari iua. Arásaro auakasaaki, amianarinani, natxinani pakini auari. Uatxa iua poxokoniuanãtakasaaki, pite atatsiitari pimisiritiko. ");
INSERT INTO apuNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Patamata ereẽ sauana auĩte. Kona ate posotari hĩtemoni asini. Hĩte apaka kona posota uaimoni hãpokini,” itxa Apraão. ");
INSERT INTO apuNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","—Iuaĩkana katiiri: “Toti, pikenakotano. Pipaniãtariko Arásaro niri aapokomoni isini. ");
INSERT INTO apuNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Iuaã aua sĩko nitariakori maneripanika inakaniua. Isãpiretanako: ‘Kona erekari uai. Erekari ia misirikaretxi auiniãtaã imĩkanina. Ininiã uatxa ikamarinako Teoso sãkire paniãtakiti,’” itxa katiiri. ");
INSERT INTO apuNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—Ininiã Apraão: “Ninoamoni auape Teoso sãkire, Moisesini sãpiretakiti, apanakini Teoso sãkire sãpiretakani sãpiretakiti apaka. Ininiã pitariakori posotari ikenakotinirina ninoa sãkire,” itxa Apraão. ");
INSERT INTO apuNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—Ininiã katiiri txari: “Toti Apraão, ikara atokonani !apakata. Ipĩkari kanapiriiniã ninoamoni, iuasaakiikarako itakanaparina imaerekanina.” ");
INSERT INTO apuNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—Ininiã Apraão: “Pitariakori !auikari Moisesini sãkire, apanakini Teoso sãkire sãpiretakani sãkire pakini. Ipĩkari kanapiriiniã ninoamoni, iuaritika ninoa !auikari Teoso sãkire. Ikara atoko ininiã, kona nipaniãtari Arásaro isini ninoamoni,” itxa Apraão. Ikara atoko itxa Xesosi sãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Xesosi txari imoianariakorimoni: —Aua maerekati oerekakani. Ninoa kãkiti kamari maerekati. Ikara atoko inakani apokapitikako. Ninoa xika kãkiti kamari maerekati. Maerekati oerekakari misiritaãkapitikako. ");
INSERT INTO apuNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Teoso omanatari kãkiti maerekati oerekakani. Kãkiti txĩkitakiniãri amarini nota sãkire auiãkari maerekati ikamini !apakata. Erekamariko iua kãkiti maerekati oerekakari kai mitariã iaxirikanokitaãkamako, ipoa apanĩkakiã okaãkamako ipinini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Erepaniko. !Pikamapiriko maerekati. Pitari Xesosi sãkire auiãkari kaminiãri maerekati pitemoni, põtãkikariko, imaerekani itakanapini ĩkapani. Itakanapiniãri, !pixinikapinikari ikara maerekati ikamakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Atxiĩti ãti õti iua kamari maerekati pitemoni. Eereka iua pitemoni apoka. “!Erekari nikamakiti pitemoni. Pimaxinĩkaretariko maerekati nikamakiti. !Nikamaikari,” itxa. Ininiã ĩkora õti iuaĩkana maerekati ikama pitemoni. Iuaĩkana amanaãi imaerekani pimaxinĩkaretini tĩkane. Atxiĩti ĩkora õti setxikata ikara atoko ikama pitemoni, ininiã pimaxinĩkaretariko ikinika maerekati ikamakiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Xesosi iokanatakini txari Xesosi: —Pitxĩkitakaua ate apikomoni aãuikiniri Teoso sãkire —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ininiã Xesosi txana: —Mostata iki axapitiki. Mostata iki atokokana nisãkire poião hãuikiniã, iuaritika hĩposotapitikari hĩpaniãtiniri ia uasini aamina: “Pikotsakatika pimaporokauako. Ipoamoni pitakauako.” Ininiã ikamapitikariko pisãkire iaõka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Xesosi txari: —Pinitiri tokoriã parĩkauatakari, pipiraakori inĩkatakari, apokasaaki paapoko, kona pitxa: “Pinipokota, pitomata.” Kona ikaraatoko pitxa. ");
INSERT INTO apuNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pitxari: “Auapanika parĩkatxi. Nipokori pikaminano. Xipoka atoko pisikakienatano. Piãtapari nota nipokotini, ininiã eereka pite nipokota.” Ikara atoko pitxa pinitiriakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pipaniãtakitinanira ikama, ininiã kona pitxa: “Erekapitikari piparĩka,” kotxi pipaniãtakitinani ikama. ");
INSERT INTO apuNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","—Ininiã iua atokokanera itxa ikinipoko Teoso paniãtakiti pikamakasaaki. Kona apakata: “Erekapitikano nota,” pinini. Ia atoko atão pinini: “Nitiritxinani nitxaua. Poiãori nitxaua, kotxi niauĩte paniãtakitinani nikama.” ");
INSERT INTO apuNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Xerosareẽmoni Xesosi sikasaaki, inapari Samaria tõpa. Ipinimoni auari Kariréia tõpa. ");
INSERT INTO apuNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ãti aapokotxi apokaãpotakasaaki, aõkitana tesi kikiakori amianatakani paiaka matatakani. ");
INSERT INTO apuNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ikira atoko akiritarina: —Xesosi, koerekareri, piamonĩkaua ate —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Xesosi atamatakasaakina, ipaniãtana ninoa Moisesini paniãtakiti iaõka ikaminina, sasetotximoni isinina, iĩtona oerekinina ĩkapani. —Sasetotximoni hĩsako. Hõerekariko hiĩto iuamoni —itxa Xesosi. Iuamoni isaãpotakasaakina, ikinipoko ninoa erekapeka itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ninoa amianatakani erekapeka, txamari ãtinani kanapiriã Xesosimoni. Itapararitika akirita: —Peerekari Teoso —itxa iua paiaka matatakari. ");
INSERT INTO apuNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ininiã ikapotoreẽkaua Xesosi apisatoõ. —Notamoni pikamakiti peerekari —itxa. Samaria tõpakiri iua kiki. ");
INSERT INTO apuNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ininiã Xesosi txari: —Nota makananitana tesi kikiakori. Ĩtapari apanakini? Auapanika novi kikiakori nimakananitakini. ");
INSERT INTO apuNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ia kiki Samariakiri. Ianokara kanapiriã, “Peerekari Teoso,” inini ĩkapani. Ninoa Xoteo iua atoko !itxana —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ininiã itxari iua Samariakiri: —Põkitikauako. Pisako. Pite auikari nisãkire, ininiãkara erekapekai —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ãti õti pariseoakori pimaãri Xesosi: —Kirisaakipa Teoso ikinimane auĩte inini õti apokatako? —itxana. Ininiã Xesosi apakapapiretana: —Teoso auĩtetxi inakasaakiua, kãkiti !atamatari iua apokini. Teoso kãkiti auĩte inakasaaki, iua kãkiti ãkixinireẽ apoka. ");
INSERT INTO apuNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Iuasaaki kãkiti !akiritari: “Uaikarari Teoso auĩtetxi ininiãtaãua. Ikiraãrari Teoso auĩtetxi ininiãtaãua.” Ikara atoko !itxana, kotxi hĩxinire ãkirari Teoso auĩtetxi ininiãtaãua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ininiã itxa imoianariakorimoni: —Apokako ãti õti nota hĩtari iaxitikiri iteene kinirão hãtamatini. Txamari !hãtamatano. ");
INSERT INTO apuNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Apanakini sãpiretaiko hĩte: “Ikiraãrari iua.” Ãti sãpiretari: “Uaikarari iua.” Iuasaaki kona himaãkatapiri ikara atoko inakari sãkiretxiti. !Hãuikapiri ikara atoko inakari. ");
INSERT INTO apuNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Hĩtari iaxitikiri kanapiriãkasaaki, mẽkokari ãtiãtaã potorikini, ãtiãtaã apokini, iua atokokana nikanapiriini. Katimaritika napokako. Mẽkokari atoko nitxako napokini. Iuasaakiika ikinimane kãkiti atamatano. ");
INSERT INTO apuNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nikanapiriini apisapanika, nota hĩtari iaxitikiri iteene ninikoriãriko nimisiritiko, kotxi kãkiti uatxa auakani kona nirekano. ");
INSERT INTO apuNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","—Nota hĩtari iaxitikiri kanapiriãkasaaki, Noee auakasaaki atokokana itxapaniko. ");
INSERT INTO apuNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noee auakasaaki, ikinimane nipokota. Iãta. Ĩtanorouata. Ikara atoko itxapikana. Ãti õti Noee, inirimanekata maporo ãki iĩroãna. Eereka imaiãtapakinitipanika ãparaã kipakata. Xãpoãkata. Ininiã xirataãtxi xipopena ikinimane. Ikara atokotxikana itxako nota kanapiriãkasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","—Aroo inakori auakasaaki atokokana itxako nota kanapiriãkasaaki. Iuasaaki ikinimane nipokota. Iãtana. Iamotiitana. Isikatiitana. Itakarauatana. Aapokona ikamana. ");
INSERT INTO apuNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sotoma sitatxiti Aroo potorikini õti, iuasaakipeka xamina ãparaã kipini atoko itxa ikatxakini. Xamina miniki katxaka. Ininiã ikinipoko iuaãtaã ariãkata. ");
INSERT INTO apuNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","—Iuasaaki kãkiti !imarotari xamina katxakini õti. Iua atokokana kãkiti !imarotari nota hĩtari iaxitikiri apokini õti. ");
INSERT INTO apuNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Napokini õti haãpoko mapara hãuiniã, kona hĩkanapiripe haãpokomoni hĩtii hãpini ĩkapani. Tokoriã hãuiniã, kona !hĩkanapiripe haãpokomoni. !Apakata hĩkanapiriini iuaã. ");
INSERT INTO apuNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Hĩxinikaroko Aroo ĩtanoro. Kona oa atoko hĩtxape, kotxi oa ipina, kotxi !onirekari otakanapiniri sitatxi maerekani auiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","—Pite ãtipirika kaminiãri piteka nireẽkitinoka, ininiã pinireẽkiti xipokapitikako pitekata. Pite nireẽkiti xipokiniã, nota sãkire pauikini xika, pite auapininiika txako Teosokata. ");
INSERT INTO apuNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","—Nikanapiriãkasaaki, ia atoko itxako. Nikanapiriini ĩkanõkati atxiĩti ipi kãkiti imakanãta imakiniãtaãna. Iuasaaki Teoso sãkire auiãkari sari notakata. Teoso sãkire mauiãkati kaikota. ");
INSERT INTO apuNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","—Iuasaakiko atxiĩti ipi sito kamanãtari atarokiri. Teoso sãkire auiãkaro sari notakata. Teoso sãkire mauiãkato kaikota. ");
INSERT INTO apuNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","—Iuasaakiko atxiĩti ipi kiki kikio parĩkauata. Ãti sa notakata, ãti kaikota —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ininiã imoianariakori pimaãri: —Namoniparako? —itxana. Ininiã iua apakapapiretana: —Aãtamatakasaakiri maiori apotiitiniãtaãua, ikinimane imarotari ipĩkari iuaãtaã auini. Iua atokokana ikinimane atamatariko kãkiti apotiitiniua notakata nikanapiriãkasaaki —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Xesosi misãkiretari imoianariakori ãti sãpirenatxi atão inakari oerekiko, Teoso misãkiretiko pirena. Ikara inakari oerekari kãkiti ãtipirika imisãkiretiniri Teoso, Teoso misãkiretiko imatakanapakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Xesosi sãpiretari ia sãkiretxiti: —Sitatxi auari kãkiti misiritiko mereẽkari. Iua kona paxitari Teoso. Kona ipaxitari kãkiti apaka. ");
INSERT INTO apuNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Iuaã sito apaka aua. Õtaniri ipĩpe. Tikinitakoro otxaua. Oa nirekari iua atão ikamini oa misiritakarimoni. Txamari iua kãkiti misiritiko mereẽkari !ipotxitari omokaiakari pirena ikenakotini. Osãpiretapikari iuamoni: “Pikenakotariko nisãkire. Pikamariko atão nota misiritakarimoni. !Nimĩteenekaikari nota misiritakari apikomoni misiritinino,” otxa. ");
INSERT INTO apuNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","—Isãpakapekari ãtipirika osãkire ikenakotini. Ininiã eereka ixinikari: “Atãopitikara, kona nota paxitari Teoso, kãkiti pakini. Iuaritika nikamariko onirekakiti, kotxi ");
INSERT INTO apuNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ãtipirika oa tikinitakoro amanaãnãtano, ininiã nikamaãkaretxitaro. Ininiã nikamariko onirekakiti, kotxi nisãpakapekaro osãkire. Ãtipirika ikara atoko otxanãtapikano. !Nimĩteenekaikari,” itxa kãkiti misiritiko mereẽkari. ");
INSERT INTO apuNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ininiã Xesosi txana imoianariakori: —Ikara kãkiti misiritiko mereẽkari kona erekari, iuaritika ikamari osãkire iaõka. ");
INSERT INTO apuNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Teoso apiaerekata. Ininiã ikenakotapitikari imereẽkini sãkire pokamara, ĩkanõka. Ninoa amanaãri Teoso imoianatinina. Ininiã apiata Teoso kenakotari isãkirena. Patimari Teoso kenakotiniri imereẽkini amanaãkiti. ");
INSERT INTO apuNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nisãpiretai, patimari Teoso misiritinina ninoa misiritakani. Ia nipimaãi. Nota hĩtari iaxitikiri iuaĩkana nikanapiriãkasaaki, atxiĩti napokari nisãkire auiãkani ĩkorapokoriti? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iuikakaniua !apokaerekatari apanakini. Ninoamoni, ninoanokara kamari atão. Ãti õti Xesosi sãpiretari ia sãpirenatxi atão inakari oerekiko, kãkiti ikara atoko inakanimoni atão imarotinina ĩkapani: ");
INSERT INTO apuNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ipi kiki sari Teoso misãkiretiko aikotimoni. Ãti kiki pariseo itxaua. Ãti kiki auĩtetxiakori txineirote apakapakari itxaua. Iteene iua misiritari kãkiti, kotxi kãkitimoni imakatxakaro apikomoni txineiro. Kona atão imakatxaka. Imisiritari kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Iuaã pariseo tima Teoso imisãkiretini ĩkapani. Txama iuaka imisãkiretaua. Ia atoko itxa isãkire: “Teoso, nota poxokopitikano, kotxi nota apanakini atoko kona nitxa. Kiĩtiriri !nitxaua. Kãkiti misiritakari kona nitxaua. Kona nota sirĩka ãti ĩtanorokata. Kona nota ia txineiro apakapakari atoko na nitxa. Konapitini. ");
INSERT INTO apuNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ikini semanati, ipi õti nitakanapari ninikini pite nimisãkiretini ĩkapani. Txineiro nisikai. Tesi txineirota auiniãno, ãtoka nisikai, ininiã pipaniãtakiti iaõka nikama,” itxa iua pariseo. ");
INSERT INTO apuNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","—Iuasaaki txineiro apakapakari ikira atoko itima. Kona ionakaãta iaxiti. Iaritari itorota imaerekani oerekini ĩkapani, kotxi maerekati ikamapeka. Itxari Teosomoni: “Teoso, piamonĩkano. Kona erekano nota, kotxi maerekati kamakarino nota,” itxa txineiro apakapakari. ");
INSERT INTO apuNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ininiã Xesosi txari: —Atãopitikara nisãkire. Ikara inakari kiki Teoso kamaerekata. Isikasaaki iua aapokomoni, erekari itxapekaua. Iua pariseopekana, Teoso !ikamaerekatari iua. —Iuikakariua, poiãori itxauako. Poiãoripekana, apiatakari itxauako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ãti õti kãkiti minari amarini Xesosimoni erekari ninoamoni itakini ĩkapani. Txamari Xesosi moianariakori atapakasaakiri kãkiti imiakori mĩkani, isipikapana. —Hĩkanapiripeka. Hĩsipeka —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Txamari Xesosi txari imoianariakori: —Hãuiritanako amarini notamoni apokini. !Hĩsipikapapena amarini, kotxi nitiretapitikana ninoa. Nisãkire auiãkani auikari nisãkire amarini auikini atoko. Kãkiti nisãkire amarini auikini atoko inakaninokara apoka Teoso auĩtetxi ininiãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Amarini auikari iri sãkire. Ininiã hĩxinikariko ia: Amarini atoko himinakaniã, Teoso sãkire iteene himauikakaniã, ininiã Teoso auĩtetxi ininiãtaãua !hiĩroã —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Xoteo auĩte pimaãri Xesosi: —Koerekareri erekari, kiripa nikama Teosokata ãtipirika nauini ĩkapani? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Xesosi txari iua: —Kininiãpa “erekari,” pitxano? Kãkiti erekari !auari. Teosonanira erekari. ");
INSERT INTO apuNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pite imarotapitikari Teoso paniãtakiti: “!Pisirĩkape ãti ĩtanorokata. !Pokaniuatape. !Piĩtiriuatape. Apanakini !pimisirienetape. Piri, pinoro pakini pipaxitako.” Ikara atoko pimarotapeka —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ininiã iua kiki apakapapiretari: —Nota axapitipanika ninakasaaki, nikĩpitari ikara atoko inakari sãkiretxiti Teoso paniãtakiti —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Xesosi kenakotakasaakiri iua kiki sãkire, itxari: —Auapanika ãtinoka pikamini tĩkane. Ikinika pitii pivẽtxitako, eereka oa txineiro pisikanako minakati mauakinimoni. Eereka pisa notakata. Ikara atoko inakari pikaminiã, Teoso tixine papokasaaki ikinipoko erekari auiniiko pite —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Iua kiki ikara ikenakotakasaaki, imatinaniuata, kotxi iua iteene katiiri itxaua. ");
INSERT INTO apuNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Xesosi atamatakasaakiri iua matinaniuatini, itxari: —Pamimari katxineiroteri auĩtetiniri Teoso. ");
INSERT INTO apuNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Atauako kamero napatari ãkorike sonakiã? Apia mimari kãkiti katxineiroterini auĩtetiniri Teoso —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ikara inakari kenakotakani txari: —Pamimari pisãkire. Ininiã kiripa apoka Teoso auiniãtaã? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ininiã Xesosi txana: —Kãkiti maposotakiniti Teoso posota ikamini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ininiã Petro txari: —Ate takanapapekari ikinipoko pitekata asini ĩkapani —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ininiã Xesosi txari: —Atãopitikara, ininiã ia atoko nitxai hĩte. Pauini pitakanapiniã, pĩtanoro, pitariakori, piri, pinoro, pamariteakori pakini pitakanapiniã, Teoso auĩtetxi ininiãua pirena pisãpiretini ĩkapani, ");
INSERT INTO apuNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ininiã ĩkorasaaki apiata erekari papakapa. Ininiã ãti õti pipĩkasaaki iaxiti papokasaaki, pauapininiika pitxako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ãti õti Xesosi anikari imoianariakori ikira atoko, misãkireta itxana: —Uatxa Xerosareẽmoni asa. Kitxakapirĩka Teoso sãkire sãpiretakani sãpiretapekari nota hĩtari iaxitikiri pirena. Ninoa sãkire iõkatsopatakitina paĩtiki apokapitikako, ");
INSERT INTO apuNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","kotxi nisikaãkako Xoteo minakonimoni. Ninapetaãkako. Nimisãkirepiretaãkako. Nikiisokaãkako. ");
INSERT INTO apuNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Niaritaãkako. Eereka nokaãkako. Ipi, ãti pakini õtisaaki iuaĩkana nõkitikaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Xesosi moianariakori !imarotari isãkire. Ikara sãkiretxi kipatakori atoko itxa. Ininiã kona ninoa imarotari isãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Xesosi apokaãpota Xerikoo sitatxiti takote. Mõsiãreti kimapori tiniãpo iitopãkanãta. Amanaãnãtaro txineiro. ");
INSERT INTO apuNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ikenakotari kãkiti kimaporiã napakani, ininiã: —Kiripa ikara? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Xesosi Nasaree sitatxitikiri, iuara napaãpota —itxana apanakini. ");
INSERT INTO apuNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ininiã iua mõsiãreti akirikata: —Xesosi, Taviini apika mekanirii, piamonĩkanoko —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ninoa ĩkiikakani txitari iua: —!Pakiripoatape —itxana. Txama iteene iua akirikata iuaĩkana: —Taviini apika mekaniri, piamonĩkano —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ininiã Xesosi iotoka. Amanaãna kãkiti: —Ere kiki himina notamoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Xesosi takote apokasaaki, Xesosi pimaãri: —Kipa pinireka nikaminii pitemoni? —Kõsiãrepeka ninini ninireka —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ininiã Xesosi txari: —Kõsiãrepekai uatxa, kotxi pauikari nisãkire —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Iuasaakipeka iua kiki kõsiãrepeka itxa. Ininiã iua saãpota Xesosi tikini. Teoso ereka inini pirena isãpireãpota. Ikinimane kãkiti itikasaakiri Xesosi kamakiti iuamoni. —Peerekari Teoso —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Xesosi Xerosareẽmoni isikasaaki, Xerikoo sitatxiti apanĩkaki inapaãpota. ");
INSERT INTO apuNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Iuaã aua kiki, Sakeo inakori. Iua katiiri. Iua kãkiti txineirote apotiitakari auĩtetxiakori ĩkapani. Apanakini txineiro apotiitakani auĩte itxaua. Iua misirienetari kãkiti. Imakatxakari txineiro auĩtetxiakori ĩkapani. Txamari apikomoni imakatxaka. Kona atão ikamakiti. !Erekari iua. ");
INSERT INTO apuNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Xesosi apokasaaki Xerikoo, iua Sakeo nirekari Xesosi atamatini. !Apakata atamatiniri, kotxi paĩtiri iua. Itomaneri kãkiti Xesosi ĩtinikata auanãta. Ininiã !apakata mõtãnoti atamatiniri iua. ");
INSERT INTO apuNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ininiã imiteka Xesosi apisa, aaminaã kanĩka itxa. Xesosi iuaã napakasaaki, iposotari itikiniri. ");
INSERT INTO apuNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Xesosi apoka iua aamina patapi. Ionakaãta itxa. Itxari: —Sakeo pikatxaka, katima pitxa. Uatxa, paapokomoni nisako, nianapokotini ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ininiã katxaka katimapeka itxa. Ipoxokoniritika iua apakapari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ikinimane iuaã auakani misãkirepiretari Xesosi. Itxana: —Xesosi sari maerekati kamakari aapokomoni. Kininiãpa iua sa iua aapokomoni? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ininiã iua aapoko apoãka atoko, Sakeo tima isãkirauatini ĩkapani. Ininiã itxari Xesosi: —Ipixini ninakiti nisika matiinimoni. Niĩtirĩkakiti iuaĩkana nisikanako kãkiti. Txineiro niĩtirĩkiniã, ininiã iuaĩkana ipi ipi pakinikata nisikariko nimisiritakinimoni —itxa Sakeo. ");
INSERT INTO apuNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ininiã Xesosi: —Ia kiki Apraão apika mekaniri apaka. Uatxa imaerekani makatxakaãka, kotxi itakanapari maerekati ikamakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kãkiti itari iaxitikiri apoka ĩkorapokoriti kãkiti pĩpinanaãkani initini, imaerekani imakatxakini ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Eereka Xesosi sãpiretari ia sãpirenatxi atão inakari oerekiko. Oerekari ia sãpirenatxi, kotxi Xerosareẽ ninoa apokaãpota. Kãkiti uãkatari paĩtiki Teoso ikinimane auĩte ininiua. ");
INSERT INTO apuNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ia atoko itxa: —Kiki aiamatapeka õtakoxiti isini, auĩtetxi ininiua ĩkapani. Iua nirekari isini, ininiã eereka inirekari ikanapiriini. ");
INSERT INTO apuNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ininiã isini apisapanika akiritari tesi initiriakori. Isikanapana txineiro tesi ota oro kamakoro. Ãtoka isikaãpotana initiriakori. Itxa: “Nota ãtiãtaã nauakasaaki, hiamotari tiitxi. Eereka pivẽtxitari apikomoni txineiro hãpakapini ĩkapani. Ikara atoko hĩtxako,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","—Isipeka atoko kãkiti iuaã auakani !inirekari iua auĩtetxi ininiua, kotxi omanatarina. Ininiã ninoa iokanapireta iuamoni: “Ate !nirekai pite aãuĩte pininiua,” itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","—Iuasaaki iua ãtiãtaã auĩtetxipeka itxaua. Ikanapiriãkasaaki akiritana initiriakori, txineiro isikanapakini. Ininiã iua txana ninoa: “Hõerekano txineiro apikomoni hãpakapakito,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ãti initiri apoka iuamoni. “Nipatrãote, pite sikanapano ãtoka ota. Uatxa tesipeka ota aua notamoni,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","—Iuasaaki auĩtetxi txari iua: “Pite kamakiti peerekari. Pite ninitiri erekari. Ãtonoka ota nisikapekai, iuaritika piparĩka peerekari. Uatxa tesi pakini sitatxiti auakani auĩte pitxauako,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","—Ãtipekana apoka auĩtetximoni: “Ãti ota pisikanapano nota. Uatxa sĩkopeka ota aua notamoni,” itxa initiri. ");
INSERT INTO apuNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","—Ininiã auĩtetxi txari: “Erekapitikari. Ininiã sĩko pakini sitatxiti auakani auĩte pitxauako,” itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","—Ãtipekana apoka auĩtetximoni: “Oniã pinakito txineiro. Mãkatxi mataã niapirikaro, poteta nitxaro pitxineirote. ");
INSERT INTO apuNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nota pĩkai pite. Pataparaxinirei. Nimarotari pite amotari ãti kamakiti. Piamotari pikiena ãti kãkiti kiena,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","—Ininiã iua auĩtetxi apakapapiretari: “Pite ninitiri maerekati pitxaua. Pite txano nota kiki kataparaxinireri nitxaua. Pimarotari niamotiniri ãti kamakiti. Pimarotari niamotiniri ãti kãkiti kiena. ");
INSERT INTO apuNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ikara atoko ininiã, pimanirekakaniãri piparĩkauatini, kinirepa kona pisikataro nitxineirote pãkomoni? Pisikaãkamaroko, napakapamaroko apikomoni nitxineirote nikanapiriãkasaaki,” itxa auĩtetxi. ");
INSERT INTO apuNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","—Ininiã iua paniãtana iuaã auakani: “Himakatxakaroko nitxineirote iuamoni nisikakito. Hĩsikaro tesi ota auakitimoni,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","—“Auapeka tesi ota iuamoni,” itxarina. ");
INSERT INTO apuNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","—Ininiã auĩtetxi apakapapiretana: “Piparĩkauatiniã, ininiã pinakiti itori aua, ininiã apikomoni papakapa. Pite iarinouatiniã, ininiã ikara xika pinakito poião. Ãti õti piarini xika ikara poiãori makatxakaãkako apaka. ");
INSERT INTO apuNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Uatxa himinana notamoni nimokaiakariakori, kotxi ninoa !inirekano nota iauĩtena nininiua. Hõkana ninoa nota apisatoõ,” itxa auĩtetxi. ");
INSERT INTO apuNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ikara inaãka atoko, Xesosi sari imoianariakori apisa Xerosareẽmoni. ");
INSERT INTO apuNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Xerosareẽmoni isikasaakina, apokaãpotana Petxipaxee, Petánia pakini aapokotxiti. Ninoa ipi aapokotxi Oriva inakori xirata takote. Iuaã auakasaaki, Xesosi iokanatana ipi imoianariakori aapokotximoni. ");
INSERT INTO apuNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Ikira aapokotximoni hĩsa. Iuaã hãpokariko xomẽta ãkiri, iaxiriãkori. Iua xomẽta ãkiri kãkiti maitopãkakotipanika inakori. Hĩkoxiripatakariko iua. Himinari notamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ipitikiri akiritiniãi: “Kinirepa hĩte koxiripatakari nipira?” inakasaakii, ia atoko hĩtxariko: “Apiananiri nirekari iua,” hĩtxako —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Iuaã apokasaakina, ikinika Xesosi sãkire iaõka auapeka. ");
INSERT INTO apuNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ninoa koxiripatakasaakiri xomẽta ãkiri, ipitikiri apoka. —Kinirepa nipira hĩkoxirika? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ininiã ninoa: —Apiananiri nirekari iua —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ininiã anikarina xomẽta ãkiri Xesosimoni. Imoianariakori takari imãkana xomẽta nopini. Imoianatarina Xesosi xomẽta nopini iitopãkini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Xesosi saãpotakasaaki Xerosareẽmoni, apanakini kãkiti matameẽkari imãkana kimaporiãpo Xesosi napini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Õtanoxiratari Oriva inakori iokiriĩtakasaaki, ninoa imakinika ipoxokoniritikana akiripoakatana, kotxi itikapekarina itori Teoso posotiire. ");
INSERT INTO apuNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Peerekari auĩtetxi, Apiananiri iokanatakiti kãkitimoni. Teoso takari erekari iuamoni. Ininiã Teoso !omanataikari kãkiti. Peerekari Teoso, iaxiti apiko nopinixiti auakari. Apiananiri itxaua —itxanãtana ninoa iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Iuaã kãkiti itomaneri sauaki aua pariseoakori apaka. Ninoa txari Xesosi: —Koerekareri, piotokakana pimoianariakori ikara isãkirena. ");
INSERT INTO apuNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ininiã Xesosi: —Atão ninoa akiritakiti. Ininiã !nipinitana iotokakiniri. Nimauiritakaniãna isãkirena nota Apiananiri nininiãua, ininiã Teoso txĩkitakari kai soro sãkirauatini ikara sãkire isãpiretini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ninoa apokaãpotakasaaki Xerosareẽ, Xesosi Xerosareẽ atamatakasaaki, iua txiapata, kotxi iuaã aua mirikiniti kãkiti isãkire mauikakani. ");
INSERT INTO apuNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ixinikasaakina Xerosareẽ auakani itxa: —!Himarotari hĩkamakiti tĩkane hãuini ereka inini ĩkapani, neenamatxi mauakani ĩkapani. Ninirekari himarotiniri, txamari uatxa ikara himarotini kipataãka himimarotakaniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ãti õti himokaiakarini ãkitai hĩte. Ininiã kona kãkiti pokĩka sitatxi, kona ĩroã. Iuasaaki himitekini !auari. Hãkitapeẽkaikako. ");
INSERT INTO apuNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Himokaiakarini xipokariko ia sitatxi. Ikinimaneko okaãkako. Kai ãti kai nopini auakari !ikaikotaika. Imakinika xipope. Iua atoko inakari auako, kotxi hĩte !apakapari Teoso hĩtemoni apokasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Xesosi apokasaaki Xerosareẽ, isari Teoso misãkiretiko aikotiã. Iuaã auari kãkiti tiitxi vẽtxitakani, ininiã Xesosi omitikana. ");
INSERT INTO apuNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Xesosi txana ninoa: —Teoso sãkire iõkatsopatakori txari: Ia naapoko, “Teoso misãkiretiko aikoti” akiritaãkako, itxa. Txamari hĩte txĩkitakari ia aiko kiĩtiririni iomaãtiniãtaã ininiua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Teoso misãkiretiko aikoti ãki ikiniõtika oerekarauata. Iuasaaki sasetotxi auĩteakori, kaiõkatsopareriakori, kãkiti auĩteakori pakini kinirão okaka txari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Txamari itomaneri kãkiti potxitari Xesosi oerekakiti sãkiretxiti. Ininiã ninoa kaikotapika Xesosikata ikinika isãkire imarotinina ĩkapani. Ikara xika !iposotarina okiniri iua iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Xesosi Teoso iokanapirena erekari isãpiretakasaaki Teoso misãkiretiko aikoti ãki, iuasaaki sasetotxi auĩteakori, kaiõkatsopareriakori, kãkiti auĩteakori pakini apoka. ");
INSERT INTO apuNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ninoa pimaãri Xesosi: —Pite omitikana tiitxi sikakani Teoso misãkiretiko aikotiã auakani. Kipaniãpa pikamari ĩkora pikamakiti? Kipa paniãtai? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ininiã Xesosi txana: —Nota apaka pimarauatako hĩtemoni. Ãtinoka nipimaãiko hĩte. Ininiã hãpakapapiretano. ");
INSERT INTO apuNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","“Kipa paniãtari Xoãoni ipatxisarauatini? Teosokani paniãtari Xoão? Kãkitikani paniãtari Xoão?” —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eereka ninoakakarinani isãkirauatana: —Kanatokopa atxa? “Teosora,” aniniã, ininiã ipaniãtamaua eereka: “Kinirepa kona hãuikatari Xoão sãkire?” itxamaua ate. ");
INSERT INTO apuNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Kãkitira paniãtari Xoão,” aniniã, ininiã kãkiti kiporonakauako ate kai soroã, kotxi ninoamoni Xoão Teoso sãkire sãpiretakari itxaua. Ininiã kanatokopa atxa? —itxakakauana. ");
INSERT INTO apuNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ininiã eereka ninoa apakapapiretari Xesosi: —Kona ate imarotari —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eereka Xesosi txana: —Ininiã nota apaka kona nisãpiretai nipaniãtakiri uãka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Eereka Xesosi sãpiretari kãkiti ia sãpirenatxi atão inakari oerekiko. Ia atoko itxa: —Aua kiki. Itakari amãtiiri ova inakoro. Ovanoka itaka ikikioteẽ. Eereka iĩkitxitana kãkiti itakare nĩkatakani. Eereka isari ãti tixini. Iuaã mapakanani ikaikota. ");
INSERT INTO apuNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Oamiko manapi iokanatari initiri apakapiniri ipixini amãtiiri. Txamari amãtiiri nĩkatakani noropatari iua nitiri. Ininiã eereka iokanatarina iua. Kona axapiti amãtiiri anika ipatrãotemoni. ");
INSERT INTO apuNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ininiã iuaĩkana ãti initiri iokanata. Iuaĩkana ninoa noropatari iua initiri. Imisiritarina. Eereka iokanatari iua. Kona axapiti amãtiiri anika ipatrãotemoni. ");
INSERT INTO apuNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Iuaĩkana ãti initiri iokanata ikikiotemoni. Iuaĩkana ikarotarina, iokanata itxarina. Kona anikari axapiti amãtiiri iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Iua katakareri txari: “Kipa nikamaã? Ari, uatxa nimarotapekari. Namarite nitiretakiti niokanatako ninoamoni. Ninoa paxitapitikariko iua,” itxama. ");
INSERT INTO apuNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","—Amãtiiri nĩkatakani atapari amãtiiri takakari ãkiri apokaãpotini. Ininiã itxana: “Katakareri ãkiri ina. Katakareri ipĩkasaaki, iua ãkiri apakapari ikinika. Ininiã maõkari iua. Ininiã ikinika itakare aua atemoni,” itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","—Ininiã ninoa kosekaĩtotari katakareri ãkiri, mapara okaĩtota itxarina. Ininiã okapirina. Ininiã Xesosi pimaãri kãkiti iuaã auakani: —Kiripa iua katakareri kamaã? ");
INSERT INTO apuNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iua okanako ikinipoko ninoa. Itakare apanakinimoni sika itxako —itxa Xesosi. Kãkiti kenakotakasaakiri ikara pirena itxana: —Ikara atoko inakari !anireka —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ininiã Xesosi iteene atamatana. —Ininiãkara natokopa itxa Teoso sãkire iõkatsopatakori oerekiniua? Aapokotxi kamakani kona nirekari ãtika kai soro. Iua kai imanirekakiniti kai apiari itxapekaua. Apanakini kai soro maĩkakari itxaua. Itxa Teoso sãkire iõkatsopatakori. ");
INSERT INTO apuNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kãkiti mãkititiniã ĩkora kai xika, ikarotaãka. Ĩkora kai irikiniã kãkiti nopini, pomoĩpeka itxana. Ininiã eereka aãpani itxaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Iuasaaki Xesosi sãkirauatakasaaki, sasetotxi auĩteakori, kaiõkatsopareriakori pakini, nirekari maĩkiniri Xesosi, okinirina ĩkapani, kotxi ninoamoni ikara Xesosi sãpiretakiti oerekari kãkiti ninoa nirekiniri okiniri Xesosi. Txamari !imaĩkarina, kotxi ipĩkarina apanakini kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ikiniõtika ninoa itikapikarina Xesosi sinimoni imarotinina ĩkapani. Ininiã ninoa iĩkitxitari kamĩkapirirerini Xesosi imisãkiretinina ĩkapani. Ninoa nirekari Xesosi kerokiniri isãkire. Ikerokiniãri, iposotarina anikiniri auĩtetxiakorimoni okinirina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ininiã ninoa kamĩkapirirerini apoka Xesosimoni. —Koerekareri, ate imarotari atãopitikara pisãkire. Pite oerekari ikinipoko kãkiti atão Teoso nireẽkiti kamiko. Poerekakiti sãkiretxiti kãkiti apiarinimoni, iuatxikana poerekari kãkiti poiãorini. ");
INSERT INTO apuNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Atãokani txineiro asikini Homanoakori auĩtemoni, Sesa inakorimoni? Apakata amasikakaniro iuamoni? —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Xesosi imarotari ninoa nirekari ikerokiniri isãkire, ininiã iua txana: —Kinirepa hãtamakaerekatano nota? ");
INSERT INTO apuNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Poerekano txineiro ota. Kisanõkapa ia? Kiuãkapa aua uai? —itxa. Ininiã ninoa: —Sesa sanõka, iuãka apaka aua —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ininiã Xesosi: —Hĩsikariko Sesamoni iua nakiti. Hĩsikariko Teosomoni iua nakiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ninoa nirekari Xesosi kerokiniri isãkire kãkiti apisatoõ, txamari !ikerokari. Ininiã ninoa tsorĩkaãta Xesosi apakapapiretakiti ikenakotakasaakina. Apikomoni !isãkirauataikana. ");
INSERT INTO apuNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ikara inaãka atoko, apoka satoseoakori inakoni. Satoseo kona auikari ipĩkari iuaĩkana õkitikiniua. Ninoa misãkiretari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Itxana: —Koerekareri, kitxakapirĩka Moisesini iõkatsopatari ia atoko inakari: “Kiki meenetipanika ipininiã, iua itari takaroko tikinitakoro. Iua itari keene ininiã, itakauãkatari amarini iua itarini ipĩpekarini uãka,” itxa Moisesini. ");
INSERT INTO apuNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Setxi itaritxiakori aua mitxi ĩkorapokoriti. Apia kiomanetakari ĩtaniriuata. Meenetipanika ipina. ");
INSERT INTO apuNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Itari takaro iuani tikinitakito. Iua apaka ipina meenetipanika. ");
INSERT INTO apuNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Iuaĩkana ãti itari takaro oa. Iuaĩkana ipina meenetipanika. Iua atokotxikana itxana imakinikana itariakori. ");
INSERT INTO apuNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Eereka oanipekana opĩpe apaka. ");
INSERT INTO apuNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ipĩkani õkitikasaakiua, kiripa oĩtaniri? Kotxi ikinikana takapekaro oa —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ininiã Xesosi: —Uatxa ĩkorasaaki kãkiti ĩtaniriuata. ");
INSERT INTO apuNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Teoso nakitiakori iuaĩkana õkitikasaakiua, !ĩtaniriuataikana. ");
INSERT INTO apuNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ninoa !ipinaika, kotxi Teoso nitiriakori iaxitikini atoko itxauanako. Iuasaaki Teoso anaakori atoko itxauana, kotxi Teoso õkitikapekana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hĩte kerokari hĩsãkire. Hĩte sãkire txari: “Ipĩkani !õkitikaikaua.” Moisesini oerekaua ipĩkani iuaĩkana õkitikapanikaua. Iua iõkatsopatakasaakiri aamina tirinakari pirena, isãpiretari Teoso sãpiretakiti. Ia atoko itxa Teoso iuasaaki: “Nota Apraão Teosone, Isaki Teosone, Xakoo Teosone pakini nitxaua,” itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ininiã ninoa Apraão, Isaki, Xakoo auapanika, kotxi Teoso !ipĩkani Teosoneni. Auãki inakani Teosonera iua, kotxi iuamoni ikinimane auãkipanika —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Eereka ãtikaka kaiõkatsopareriakori txari: —Koerekareri, atãopitikara pisãkire —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ikara inaãka atoko kãkiti pĩkarauata apikomoni ipimarauatini. ");
INSERT INTO apuNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ininiã Xesosi pimaãna: —Kinirepa isãpiretaãka Teoso mereẽkiti Taviini apika mekaniri ininiua? ");
INSERT INTO apuNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kotxi Taviini iõkatsopata Xikari aãtsopateẽ. Itxari: Apiananiri txari niauĩtemoni: “Nota kikomoni piitopãka. ");
INSERT INTO apuNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Piitopãkiniritika nixipokariko pimokaiakariakori. Nikamariko ninoa pikiti pitakiniãtaã atoko ininiua.” Itxa Taviini xikare. ");
INSERT INTO apuNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Taviini akiritari Teoso Mereẽkiti “Niauĩte.” Ininiãkara kanatokopa iua Tavii apika mekaniri? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Eereka kãkiti apisatoõ Xesosi õtãkikana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ia atoko itxa: —Erepaniko, kaiõkatsoparerini misirienetinii. Ninoa ieretakari mãkatxi ĩtanori, peereri, apanakini atamatinina ĩkapani. Tiitxi amotikoãtaã ninoa potxitari kãkiti ninoakata sãkirauatini apanakini atamatinina ĩkapani. Ninoa potxitari iitopãkinina auĩtetxi topãkiniãtaã aiko ãki Xoteo apotiitiniãtaãua. Kiinirisaaki ninoa nirekari apiari topãkiniãtaã iitopãkinina. ");
INSERT INTO apuNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kiki ipĩkasaaki, ninoa misiritaro tikinitakoro. Ninoa mixirikari oaãpoko, iuaritika imisãkiretarina Teoso. Teoso imisãkiretakasaakina, kaiãori sãkiretxi isãkiretana. Ininiã apanakini kenakotakasaakiri, ninoa xinikari: “Atão iua imarotari Teosokata isãkirauatini,” itxana. Txamari Teoso kamaãkaretxitana, ininiã apiata imisiritaãkanako. ");
INSERT INTO apuNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Xesosi sãkirauatakasaaki Teoso misãkiretiko aikoti ãki, itikari katiirini takiniro itxineirotena kaixa ãki Teoso ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Iuasaaki oãua tikinitakoro matiito. Õtaniri !auaika. Oa sikaro ipi txineiro ota okinika oamoni auakaro. ");
INSERT INTO apuNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ininiã Xesosi txa: —Atãopitikara, okira sito sikari apiata. ");
INSERT INTO apuNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kotxi apanakini sikaro itxineirotena itetakito. Okira sikari okinika onakito —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ãti õti Teoso misãkiretiko aikoti ãki aua Xesosi imoianariakorikata. Aiko ereri pirena isãkirenãtana. —Uai peereri. Ere kai sorokiniri paretxiã auakari pakaronepokori. Patamatari kãkiti sikakiti Teosomoni —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ininiã Xesosi txana: —Ari atãopitikara peerekari. Txamari apokapitikako ãti õti ia aiko irikiko ĩkapani. Iuasaaki kai ãti kai nopini auakari !auaika. Ikinipoko irikaãkako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ininiã ninoa pimaãri: —Koerekareri, kirisaakipa ikara atoko inakari auapani? Kiãtokopa itxa ia aiko Teoso misãkiretiko irikini õti manapi aimarotini ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ininiã Xesosi apakapapiretana: —Erepaniko, xipokatxi õti apokaãpotakasaaki, kãkiti nirekari imisirienetinii hĩte. Ito aãpirena auako. Kaiãopokori kiki sãkire: “Teoso mereẽkitikarano nota. Nota apokapeka uai,” itxamana. Paxirari ninoa sãkire. !Himaãkatapena ninoa. !Himoianatapena ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Neenamatxiene hĩkenakoenetakasaaki, !hĩpĩkarauatape. Iua atoko inakari merepanika auako. Iuasaaki xipokatxi õti !apokapanika —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","—Ãti uãka kamari neenamatxi ãti uãkakata. Ãti auĩtetxi sotatoneakori neenamauata ãti auĩtetxi sotatoneakorikata. ");
INSERT INTO apuNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Iuasaaki xipokatxi õti apisa, nota apokini apisa, itixi iakeẽkatako. Natxi auako. Itori amianari auako. Apaka kãkiti atamatakiti iaxiti kamapĩkaretana. ");
INSERT INTO apuNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—Ikara inakari apisa, apanakini maĩkaiko hĩte. Himisiritaãkako. Xoteoakori anikaiko aiko Xoteo apotiitiniãtaãua Xoteoakori auĩte apisatoõ apoĩtiniina ĩkapani. Hĩtakaãka kateia ãki. Ninoa anikaiko hĩte itixi auakani auĩteakorimoni hĩte apoĩtinina ĩkapani. Iua atokokanerako hinaãkako nisãkire hãuikini xika. ");
INSERT INTO apuNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Iuasaaki auĩtetxiakori apisatoõ hãuakasaaki, hĩsãpiretariko Teoso iokanapirena erekari. ");
INSERT INTO apuNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ninoa himisãkiretini apisa, maerekaxiniretika !hĩtxape. Kona hĩpĩkarauatape, ");
INSERT INTO apuNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kotxi ninoa apisatoõ hãuakasaaki, nota sikaimaroretai hĩte, ininiã himokaiakariakori !iposotari apakapapiretiniina hĩte. !Iposotarina isãpiretiniina: “Kona atão pisãkire,” !itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hinoroma, hĩrima, hĩtariakorima, apanakini hinirimanema, haõkimanerema pakini sikaiko hĩte himokaiakariakorimoni. Ãtikaka hĩte okaãkako iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ikinimane omanataiko hĩte nisãkire hãuikini xika. ");
INSERT INTO apuNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Iuaritika Teoso !auiritari ãtika hiãko maporokiko, kotxi Teoso iteene nĩkatapitikaiko hĩte. ");
INSERT INTO apuNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Himĩteenekiniãri ikinika himisiritiko, ininiã Teoso txĩkitakaiko ãtipirika iuakata hãuapininiika hinini ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Apikomoni Xesosi txari: —Hãtamatakasaakiri sotatoakori ãkitiniri Xerosareẽ, iuasaaki himarotariko pakotapaniri sitatxi xipokini. ");
INSERT INTO apuNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iuasaaki hĩte Xotéia tõpa auakani himitekako oxiratarimoni. Sitatxi hãuiniã, ininiã himitekako. Mapara hãuiniã, kona hĩkanapiripe sitatximoni, ");
INSERT INTO apuNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","kotxi iuasaaki kãkiti misiritiko õti apoka. Teoso sãkire iõkatsopatakori sãpiretapekari ikara õti apokini. ");
INSERT INTO apuNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Iuasaaki !erekapaniri sito kamixiro ĩkapani, kaxitakarero ĩkapani, kotxi omitekini !apakata. Xoteo auiniãtaã auapitikako iteene imisiritikona tĩkane, kotxi iuasaaki Teoso oerekari iua omanãkare Xoteoakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Itomaneri kãkiti okaãkako saasara atoko inakaroã. Apanakini anikaãkako ikini uãka tixinemoni. Xoteo minakaniua xipokariko sitatxi Xerosareẽ. Teoso auiritana ninoa kaikotini iuaã. Eereka Teoso xipokariko ninoa tapara. Eereka !auaikana —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Apikomoni Xesosi txari: —Nota uai apokini apisa, atokatxi, kasiri, iõriki pakini oerekariko kãkiti nota iposope uai napokini. Apaka potxoari uiniti auari tsakati mitari. Iua tsakati miramaneri iene. Ikara xika itixi auakani kamaxirexinirepeka itxanako. ");
INSERT INTO apuNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kãkiti ãkipa iotokako ipĩkare xika. Itixi misiritiko xika ipĩkarauata, kotxi iõriki, ikinika iaxiti auakani iakeẽkatako. ");
INSERT INTO apuNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Iuasaaki nota, hĩtari iaxitikiri katxakaãpota katxiãrikata. Iuasaaki ikinimane atapanoko nota. Iuasaaki kaposotiireno nota. Niotximerekata napoka uai. ");
INSERT INTO apuNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ikara itixi misiritiko apokaãpotakasaaki, haiamatako. Hionakaãtako, kotxi paĩtiki nota kanapiriã hĩte napini ĩkapani. Iuasaaki nimakatxakai hĩte ikinika maerekati auiniãtaã —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Xesosi sãpiretari ãti sãpirenatxi atão inakari oerekiko. Itxari: —Hĩxinikari aamina piko inakori. Apanakini ãtião aamina apaka hĩxinika. ");
INSERT INTO apuNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pooĩoporipeka onakasaaki, otomorekasaaki, “Kamoĩ apokanapanoka,” hĩtxa. ");
INSERT INTO apuNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iua atokokana ikara misirikaretxi mixikanani nisãpiretakiti hĩtikasaaki, iuasaaki himarotariko paĩtiki Teoso ikinimane auĩte itxauako. ");
INSERT INTO apuNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","—Ia nisãkire atão. Itixi auakani !ixipoka ikinipoko nisãpiretakiti mapokakani apisa. ");
INSERT INTO apuNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Iaxiti xipokapitikako. Ĩkoraxiti apaka xipokapitikako. Iuaritika nota sãkire !ixipoka. ");
INSERT INTO apuNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","—Erepaniko, maerekaxiniretika kona hĩtxape. !Hĩsarauatape. !Hĩpoãtape. Hĩparĩkanoka !hĩxinikapeko, kotxi hĩsarauatiniã, hĩpoãtiniã, hĩparĩkanoka hĩxinikiniã, !hĩxinikari nikanapiriini õti, kotxi ĩkora õti himimarotakani õtisaaki, napokako. Erepaniko, kotxi txikatoro atoko itxa napokini. Kãkiti !imarotapaniri napokini õti. ");
INSERT INTO apuNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Imakinika kãkiti itixi auakani imarotariko napokini iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hiãtapariko nikanapiriini. Ãtipirika himisãkiretariko Teoso. Hamanaãriko Teoso ikara inakari mamisiritakanii hĩte. Hamanaãriko Teoso himapẽtauatakani ĩkapani hĩtari iaxitikiri apokasaaki iua apisatoõ hĩtimakasaaki —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ikiniõtika Xesosi sari Teoso misãkiretiko aikotimoni Teoso sãkire oerekini ĩkapani. Ikiniõtika mapiãnikata Xesosi sari õtanoxiratarimoni, Oriva inakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ĩkanõkapanika kãkiti apoka Teoso misãkiretiko aikotiã Xesosi sãkire ikenakotinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kaiamapeka Páskoa inakori kiiniriti apokini. Iua kiiniriti Xoteoakori nikari pão matireẽkati. ");
INSERT INTO apuNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Iuasaaki sasetotxi auĩteakori, kaiõkatsopareriakori pakini nirekari Xesosi okinina, txamari, ninoa pĩkari apanakini kãkiti, kotxi ninoa apokaerekatari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iuasaaki Satanasi ĩroaĩtotari Xotasi Isikariotxi inakori. Iua Xotasi Xesosi moianarikamara, apanakinikata. ");
INSERT INTO apuNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Iuasaaki iua sari sasetotxi auĩteakorimoni, Teoso misãkiretiko aikoti nĩkatakani auĩteakorimoni. Iuasaaki isãkirauata ninoakata Xesosi imĩkapiritini ĩkapani. Iuasaaki ninoa xinikaxitita: —Kiãtokopa itxatari Xesosi isikini atemoni? ");
INSERT INTO apuNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Sasetotxi auĩteakori enenĩka. Ninoa txari Xotasimoni: —Pisikasaakiri Xesosi atemoni, aĩkitxitaiko pite —itxana Xotasimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Ateeneka —itxa Xotasi. Ikara atoko inaãka atoko Xotasi iãtapari isikiniri õti manapi. Inirekari kãkiti mauakanisaaki, Xesosi imĩkapiritini. ");
INSERT INTO apuNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Iuasaaki kãkiti parĩkauata Páskoa kiiniriti ikaminina ĩkapani. Iua kiiniriti auakasaaki, itotarina pão matireẽkati inikinina. Iuasaaki okarina soti auĩte ãkiri kiinirisaaki iniãkitina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Xesosi paniãtana Xoão, Petro pakini: —Hĩsako. Hãpotiitariko nipokori Páskoa kiiniriti ĩkapani —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ininiã ninoa: —Namonipa akamatari kiiniri? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ininiã Xesosi: —Xerosareẽmoni hĩsa. Iuaã hĩtikari kiki kaminiri sito parĩka. Iua apaãnãtari ãparaã. Kopiti ikiiã anikanãta. Iua aõkitaiko hĩte. Iuakata sa hĩtxako. Hiĩroã aapokotxi iua ĩroiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Himisãkiretari kauiniri. Hĩtxariko iua: “Koerekareri nirekari imarotiniri: ‘Namonipa ianapokotakani kaikotiniãtaã iriko? Iuaã inirekari inapiniri Páskoa õti imoianariakorikata,’ hĩtxariko iua.” ");
INSERT INTO apuNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iuasaaki kauiniri oerekai itanokiri koa mitari iuaã kiiniri ĩkapani. Imakinika tiitxi iposope. Iuaãrako hãpotiitari imakinika Páskoa kiiniriti ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ininiã sa itxana. Apoka itxarina ikinika Xesosi sãkire iaõka. Ininiã iuaã ninoa maiamatari kiiniri. ");
INSERT INTO apuNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ininiã Páskoa kiiniriti potorikasaaki, Xesosi imoianariakorikata topãka. ");
INSERT INTO apuNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ininiã Xesosi txana: —Iteene ninirekari hĩtekata ninikiniri ia nipokori Páskoa kiiniritisaaki, natatsiirauatini apisa. ");
INSERT INTO apuNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ia atoko inakari nipokori !ninikaikariko hĩtekata. Teoso ikinimane auĩte inakasaakiua, iuasaakiikarako ninikapitikariko iuaĩkana. ");
INSERT INTO apuNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Eereka iua kosekari iãtatxi koana ovaã iãriãti. Ininiã itxa: —Niri, erekapitikari ia pisikakiti —itxari Teoso. Eereka itxana imoianariakori: —Ia iãriã hãpakapako. Hĩkinika hiãtariko. ");
INSERT INTO apuNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Atão nisãpiretai. !Niãtaikaroko ovaã, Teoso ikinimane auĩte iminakanisaakiua. Teoso ikinimane auĩte inakasaakiua, iuasaakiikarako iuaĩkana niãtariko ovaã —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Eereka ikosekari komiri: —Erekapitikari ia komiri pisikakiti atemoni —itxari Teoso. Eereka imapixinikaãpotari, sikaãpota itxana imoianariakori: —Ia niĩto okaãka hĩte ĩkapani. Ia komiri hinikasaaki, hĩxinikanoko nota. Hĩxinikari nipinini hĩte ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Inikaãkarina atoko, ikosekaro ovaã. Isikana imoianariakori. Ininiã itxa: —Ia niarẽka xiketakari makatxakariko hĩte maerekani. Teoso sãpiretapekari kãkiti ikamaenetakiti amaneri kãkiti ĩkapani. Ia niarẽka oerekari kãkiti, Teoso kamapekari ikamaenetakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Iua nimĩkapiritakiri uatxa uai topãka notakata. ");
INSERT INTO apuNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nota hĩtari iaxitikiri okaãkako. Teoso sãkire iõkatsopatakori sãpiretapekari nipinini tĩkane. Nota hĩtari iaxitikiri mĩkapiritakari iteene misiritaãkako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Xesosi moianariakori ninoakakarika isãkirauatana: —Kipa sikatari Xesosi imokaiakariakorimoni? —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ikara atoko inaãka atoko Xesosi moianariakori misãkiretakakaua. —Kiripa apiatakari txatapaniuako ate sauaki? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ininiã Xesosi: —Xoteo minakaniua auĩteakori itaparasãkireritika ipaniãtana Xoteo minakaniua iauĩtena nireẽkiti ikaminina ĩkapani, iuaritika ninoa sãkire, “Peerekaua ate. Ate moianatari kãkiti,” itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Hĩte kona ninoa atoko kona hĩtxape. Atxiĩti apiari pitxaua hĩte sauaki, ininiã amarini atoko pitxauako. Auĩtetxi pininiãua, nitiritxi atoko pitxauako. ");
INSERT INTO apuNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kiripa apiatakari txataua? Auĩtetxi nipokori nikakarikani, apiatakari txatauako? Initiri nipokori kamakarikani apiatakari txatauako? Ikinimane kãkiti imarotari nipokori nikakari apiatakari itxaua. Txamari nota auakasaaki kãkiti sauaki, nitiritxi atoko nitxaua, kotxi kãkiti nimoianata. ");
INSERT INTO apuNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Xoteoakori misiritakasaakino nota, kona hĩte takanapano. Atão nimoianariakori hĩtxaua. ");
INSERT INTO apuNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Niri, auĩtetxi txĩkitakapekano nota. Ininiã iua atokokana nota txĩkitakai hĩte auĩtetxi hininiua. ");
INSERT INTO apuNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nota auĩtetxi ninakasaaki, hinipokota, hiãta hĩtxako notakata. Auako auĩtetxi topãkini hĩte ĩkapani. Ininiã iuasaaki hĩpaniãtana tosi nirimanetxi Isaeo auakani ikamakitina tĩkane —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Xesosi sãkirauata Simão Petromoni: —Simão, Simão, Satanasi amanaãpekari Teoso pite, apanakini apaka atamakaerekatini ĩkapani. Ahoisi misiritiko atoko inirekari imisiritinii pite. ");
INSERT INTO apuNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Iuaritika, nota misãkiretapekari Teoso isikataparatiniri pixinire Simão, nisãkire atão pauikini ĩkapani. Pikerokariko pikamakiti, iuaritika pikanapiriãpitika nota sãkire iteene iuaĩkana pauikini ĩkapani. Eereka pisikataparaxiniretanako pitariakori nota sãkire auiãkani —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petro txari Xesosi: —Niauĩte, nota iposope nitxa kateiamoni nisini pitekata. Pitekata iposope nitxa nipinini —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Xesosi txari: —Atão nisãpiretai. Ia ĩkanõkati patari sãkirauatini apisapanikako, ipi ãti pakinikata, “!Nimarotari iua,” pitxanoko —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Eereka iuaĩkana Xesosi sãkirauata imoianariakorikata: —Mitxi nota iokanatai kãkitimoni. Iuasaaki kona nisikai txineiro. Kona nisikai sako mata. Kona nisikai sapato, iuaritika minakati auinii atxiĩti? Erekari hĩsini ikinika hinirekakiti mauakanisaaki? —itxa Xesosi —Minakati !auinaua ate —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ininiã Xesosi txana: —Txamari uatxa pitxineirote, sakora pakini auiniãi, panika. Iouata mitaro mauakanisaakii, pimãka inopinikiri pivẽtxitako iouata piamotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Teoso sãkire iõkatsopatakori kitxakapirĩka txari: Imaĩkaãka, kokaniri maĩkiko atoko inaãkako. Ininiã ikara nimaĩkiko apokapitikako. Ikara nota pirena kitxakapirĩka atãopitika —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Imoianariakori txari: —Apiananiri, patamata. Uai aua ipi iouata aneenamauatini ĩkapani. Xesosi txari: —!Apakata ikara atoko inakari hĩsãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Eereka ixirata auĩte Oriva inakorimoni isa, kotxi itotapekari iuaã isini. Imoianariakori sari iuakata. ");
INSERT INTO apuNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Iuaã apokasaakina, Xesosi txana: —Satanasi nirekari maerekati hĩkamini. Ininiã himisãkiretariko Teoso, iua sikataparatinii, Satanasi nirekakiti himakamakani ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ininiã iuaã itakanapana imoianariakori. Apikoxãki axapiti sa itxa. Iuaã ikapotoreẽkaua, misãkireta itxari Teoso. ");
INSERT INTO apuNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Itxari: —Niri, !pauiritapeno paĩtiki natatsiirauatini, iuaritika kona pikamapiri nota nirekaãkiti. Pite nirekaãkiti ninireka nikamini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Iuasaaki Teoso nitiri iaxitikiri apoka iuamoni isikataparaxiniretiniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iuasaaki Xesosi xinire kamaxirepeka. Ãkixinireẽ apokapeka itsii. Ininiã iteene imisãkiretari Teoso. Ininiã iinĩkakare arẽkatxikata tapika ixitimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Teoso imisãkiretaka atoko, õkitikaua, imoianariakorimoni isa. Iua apoka ninoamoni. Imakapoanãtana, kotxi isãpakapekana imatinaniuatinina xika. ");
INSERT INTO apuNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ininiã akiritana: —Kinirepa himakanãta? Hõkitikaua. Himisãkiretari Teoso, Satanasi nireẽkiti himakamakani tĩkane —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Xesosi sãkirauatakasaaki imoianariakorikata, itomaneri kãkiti Xotasikata apoka. Xotasi mĩkiikana ninoa Xesosi oerekini ĩkapani. Iua Xotasi Xesosi moianarikamara, apanakinikata. Xotasi apokasaaki apitxokari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ininiã Xesosi txari iua: —Xotasi, pimĩkapiritatari pitari iaxitikiri papitxokasaaki? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Xesosi moianariakori imarotakasaakiri kãkiti nirekiniri Xesosi imaĩkini, itxana: —Apiananiri, erekari atxiĩti uatxa aneenamauatini, aiouataneẽ —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ininiã ãti Xesosi moianari sauakari sasetotxi auĩte apiatakari nitiri kĩpita ikikomoni. ");
INSERT INTO apuNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ininiã Xesosi: —Hiĩtoka ikara. Iaõpe. Eereka Xesosi takapiotaua ikĩpitaã. Iuasaaki kakĩpitapeka itxa iuaĩkana. ");
INSERT INTO apuNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sasetotxi auĩteakori, kiomãtxiakori pakini ina Xesosi imaĩkinina ĩkapani. Xesosi txari ninoamoni: —Kinirepa himinari iouata, piriri pakini himaĩkinino ĩkapani? ");
INSERT INTO apuNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ikiniõtika hĩtekata naua aiko Teoso misãkiretikoã. Iuasaaki kona hĩte maĩkano. Ĩkanõka hina, kotxi ipiaã hĩkamari maerekati —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ininiã ninoa maĩkari Xesosi, anika itxarina sasetotxi auĩte apiatakari aapokomoni. Ĩroãna aapoko ãki. Ininiã Petro sari ninoa tikini. ");
INSERT INTO apuNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sasetotxi aapoko takote apoka. Iuasaaki mapara xamina pokitakori aua. Kãkiti topãkanãta xamina takote. Irokanãtana. Ininiã Petro topãka ninoa takote. ");
INSERT INTO apuNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Iuasaaki ãtokoro atamatari iua xamina kamaraã. Ininiã itakote oãpoka. Omixinitari iua: —Ia kiki Xesosikata auakari —otxa. ");
INSERT INTO apuNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Txamari Petro txari: —Ãtokoro, kona nimarotari iua —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Eereka ãti atamatari iua. Itxari iua: —Pite Xesosi moianarikarai? —itxari. Txamari Petro: —Konapitini —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ãti oara napa atoko ãti txari: —Atãopitikara, ikira kiki Xesosi moianaripitikara, kotxi Kariréiakiri itxaua iua —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petro txari: —Kona nimarotari ikara pisãpiretakiti. Iuasaaki, isãkirauatakasaaki, patari sãkirauata. ");
INSERT INTO apuNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Iuasaaki Xesosi sapotorika, atamata itxari Petro. Iuasaaki, Petro xinikari mitxi Xesosi sãpiretakiti: “Patari sãkirauatini apisapanikako, ipi ãti pakinikata, ‘!Nimarotari iua,’ pitxanoko” ininiri iaõka aua. ");
INSERT INTO apuNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ininiã eereka Petro sipe. Iteene txiapata itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Xesosi nĩkatakani napetari, noropata itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Iuasaaki iaxirikaokitarina iua, ninoa imatamatakani ĩkapani. Iuasaaki noropata itxarina. —Kimarorei pite. Kiripa noropatai? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Itomaneri maerekati sãkiretxitiã itxitarina Xesosi. Inapetiniri !iotoka. ");
INSERT INTO apuNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ĩkanõkapanika kiomãtxiakori, sasetotxi auĩteakori, kaiõkatsopareriakori pakini apotiitaua. Iuasaaki Xesosi minaãka ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Pisãpiretaua ate, Teoso mereẽkitikai pite? —itxarina. Ininiã Xesosi apakapapiretana: —Nisãpiretiniãi, !hãuikari nisãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nipimarauatiniã, hĩte !apakapapiretano. Apaka !hãuiritari nisikakiko. ");
INSERT INTO apuNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Paĩtiki hĩtari iaxitikiri topãkako Teoso kaposotiireri kikomoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ininiã iuaĩkana ninoa pimaãri: —Teoso ãkirikai pite? —itxarina. Ininiã Xesosi apakapapireta: —Atãopitikara hĩsãkire. Iuapitikarano nota —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","—Iaõpekara. Akenakotapekari isãkire. Ininiã apikomoni isãkire kenakotakani !anirekaika, kotxi ateka kenakotapekari iua sãkire maerekati —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ininiã imakinika ninoa anikari Xesosi Piratomoni. ");
INSERT INTO apuNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ininiã iuaã ikamarina aãpirena. Apoĩtarina Xesosi: —Ate kenakopiretari oerekiniri kãkiti maerekati ikamini, kotxi iua õtãkikari kãkiti, kãkiti miĩkitxitakaniri Sesa, Homano auĩte apiari. Apaka itxa: “Teoso mereẽkitino nota. Auĩtetxi apiatakari nitxaua,” itxa iua sãkire. Txamari na atãoni ikara atoko itxana ninoa. Ikara atoko ninoa apoĩtari Xesosi. Kona atão ninoa sãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ininiã Pirato pimaãri Xesosi: —Pitekani Xoteoakori auĩte txataua? —itxari Xesosi. —Iuapitikarano nota —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ininiã Pirato txana sasetotxi auĩteakori, kãkiti pakini: —!Napokari maerekati ikamakiti —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Iuaĩkana apoĩtarina: —Iua oerekana kãkiti maerekati ikamini auĩtetxiakorimoni. Kariréia tõpamonira ipotorika. Uatxa uaipekarari iua —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pirato kenakotakasaakiri isãkirena, ipimaãna: —Ia kiki Kariréiakirikani? ");
INSERT INTO apuNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Ari iuapitikara —itxana. Ikara Pirato imarotakasaaki, iokanatari Xesosi Erotximoni, kotxi Kariréia tõpa auakani auĩte itxaua Erotxi. Iuasaaki iua ianapokota Xerosareẽ. Ininiã Pirato iokanatari Xesosi Erotximoni, kotxi Xesosi Kariréiakiri. ");
INSERT INTO apuNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erotxi kenakopiretapekari Xesosi pirena. Ininiã iua aõkitakasaakiri Xesosi, poxokope itxakata, kotxi inirekari Xesosi oerekiniri iposotiire. ");
INSERT INTO apuNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ininiã iteene ipimaãri Xesosi, ikamakiti imarotini ĩkapani. Txamari Xesosi !apakapapiretari iua. ");
INSERT INTO apuNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Iuasaaki sasetotxi auĩteakori, kaiõkatsoparerini pakini iteene apoĩtari Xesosi. Ikinika ninoa sãkire aãpirenanoka. ");
INSERT INTO apuNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eereka Erotxi, isotatoneakori pakini napetari Xesosi. Ieretakarina auĩtetxi mãka maparakiri apiata inapetinirina ĩkapani. —Hãtamatari ere. Auĩtetxi itxaua —itxana. Eereka iuaĩkana iokanatarina Piratomoni. ");
INSERT INTO apuNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mitxi Erotxi, Piratokata omanatakakaua. Ikara õti ninoa apokaerekatakakaua. ");
INSERT INTO apuNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ininiã eereka Pirato apotiitari sasetotxi auĩteakori, Xoteo auĩteakori, apanakini kãkiti pakini. ");
INSERT INTO apuNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ininiã itxa: —Hĩte minari ia kiki notamoni. Hĩte apoĩtari iua imisirienetiniri kãkiti. Hĩte apisatoõ nipimaãpekari ikamakiti pirena. Notamoni kona maerekati !ikama. ");
INSERT INTO apuNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erotxipekana !apokari maerekati ikamakiti, ininiã iokanatari iua notamoni iuaĩkana. Inipitikara iua erekari, txamari hĩte nirekari okiko maxikatiĩka. ");
INSERT INTO apuNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ininiã nota paniãtari inoropatiko aãpitsa aamata kamakoriã. Eereka niokanatari isini. ");
INSERT INTO apuNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Iuasaaki Páskoa kiiniritisaaki, auĩtetxiakori itotari isikakiniri ãtika kateia ãki auakari. ");
INSERT INTO apuNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ikara Pirato sãkire ikenakotakasaakina, ninoa akirikata: —Hõkariko ere kiki. Hĩsikakariko Pahapasi —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Pahapasi kateia ãki aua, kotxi iua apanakinikata naiatari auĩtetxiakori. Kokaniri apaka itxaua. ");
INSERT INTO apuNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pirato nirekari Xesosi isikakini, ininiã iuaĩkana isãkirauata kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Txamari ninoa akiripoakata: —Aamina ĩpiriãmitakari nopini hĩtokakitariko. Hõkariko aamina ĩpiriãmitakari nopini —itxakatana. ");
INSERT INTO apuNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pirato mitxi isãkirauata ipikata. Iuaĩkana isãkirauata: —Kixikapa? Maerekati !ikama. Ixika !auari ipinini ĩkapani. Nipaniãtariko inoropatiko, eereka nisikakariko —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Txamari iuaĩkana akiripoakatana: —Hõkariko aamina ĩpiriãmitakari nopini. Ninoa akiripoakatini xika Pirato kamari ninoa nirekakiti. ");
INSERT INTO apuNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ininiã Pirato: —Xesosi ipinako hinirekakiti iaõka —itxa Pirato. ");
INSERT INTO apuNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Iuasaaki isikakari Pahapasi kateia ãki auakari. Neenamatxi kamakari, kokaniri apaka itxaua Pahapasi. Eereka isikari Xesosi sotatoakorimoni aamina ĩpiriãmitakari nopini okiko ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ininiã sotatoakori anikari Xesosi okiko ĩkapanimoni. Iuasaaki kimaporiãpo aõkitarina Simão, Sireni sitatxitikiri. Iuasaaki iua apoka sitatximoni. Sotatoakori maĩkari iua. Aamina ĩpiriãmitakari itakana Simão tsotere nopini: —Panika ia aamina ĩpiriãmitakari —itxarina. Xesosi tikini sa itxa Simão. ");
INSERT INTO apuNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Xesosi tikini isa mirikiniti kãkiti. Ãtokaka sitoakoro sari apaka. Imatinaniuatana, itxiapatana, kotxi imarotarina Xesosi paĩtiki ipinini. ");
INSERT INTO apuNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Xesosi kirioka ninoa sitoakoromoni. Itxana: —Sitoãkini Xerosareẽ auakani anaakoro. Kona notani !himariaka. Hĩtekara himariakaua. Hamariteni ĩkapani hĩtxiapata, ");
INSERT INTO apuNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","kotxi ãti õti apokasaaki, kãkiti sãkire: “Apiaerekata sito meeneto oniniua,” kotxi iuasaaki misirikaretxi apokasaaki, pamonõkoniri. ");
INSERT INTO apuNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Iuasaakiikarako kãkiti akiripoakatako ixirata auĩtemoni: “Ate nopini pirika. Pipataua,” itxanako, kotxi iuasaaki ninoa mokaiakariakori apokaãpota ninoa xipokini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nota aamina amaneri atoko nitxa. Hĩte aamina ĩsasaka atoko hĩtxa. Nota !ikamari maerekati, iuaritika ia atoko nota ipina. Erepaniko aamina ĩsasaka atoko hĩtxa, ininiã ãti õtirako apiata himisiritiko —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ninoa anikari ipi maerekati kamakani Xesosikata ipininina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Apokasaakina “Kiitãtatxi” inakoriãtaã, itokakitarina Xesosi aamina ĩpiriãmitakari nopini. Iua atokokanera itxana maerekati kamakani. Ãti maerekati kamakari itakana Xesosi kikomoni, ãti isanaremoni. ");
INSERT INTO apuNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iuasaaki Xesosi txari: —Niri !pimisiritapena ninoa, maerekati ikamakitina xika, kotxi !imarotarina ikamakitina —itxa Xesosi. Iuasaaki sotatoakori kamari sarauatxi. Eereka imakatxakarina Xesosi mãka. Sarauatxi kãiatakari apakapari imãka. ");
INSERT INTO apuNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kãkiti iuaã auakani itikari Xesosi. Sasetotxi auĩteakori napetari iua. Itxana: —Iua makatxakapekari apanakini imapinakanina ĩkapani. Teoso mereẽkiti ininiãua, kinirepa iuaka !imakatxakaua? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Iuasaaki sotatoakori apaka napetari iua. Katxioãri isikarina Xesosi iãtini ĩkapani, txamari !iãtari. ");
INSERT INTO apuNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Itxana: —Pite Xoteo auĩte pininiãua, ininiã aamina ĩpiriãmitakariã pimakatxakaua. Piteka pimakatxakauako —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iuasaaki iõkatakori takaãka ikii tanomoni: —Xoteoakori Auĩte —itxa iua iõkatakori. Homano sãkireẽ aua. Kreko sãkireẽ aua. Xoteo sãkireẽ pakini aua iuaã iõkatakori. ");
INSERT INTO apuNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Maerekati kamakari Xesosi takote tokakitakori akiritari iua. Itxitari. Inapetari: —Pite Teoso mereẽkiti pininiãua, ĩteroa piposotiire? Piteka pimakatxakaua. Ate apaka pimakatxaka —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ãti maerekati kamakari iuaã tokakitakori õtãkikari iua: —Kona pite pĩkatari Teoso? Ate apaka apinako. ");
INSERT INTO apuNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Atãopitikara ate misiritiko, kotxi maerekati akamapeka. Ere kiki !ikamari maerekati —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eereka itxari Xesosi: —Xesosi, auĩtetxi pininiãtaãua papokasaaki, pixinikano nota, kotxi ninirekari nisini pitekata iuaxiti —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Xesosi apakapapiretari: —Atãopitikara nitxai, uatxa ia õti, pite sariko notakata iaxiti Erekariãtaã. ");
INSERT INTO apuNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ininiã apaniãxiti takote atokatxi piãkapeka. Ipi ãti pakini oara ipiãka. ");
INSERT INTO apuNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Atokatxi !iponikaika. Iuasaaki mãkatxi mata mitari Teoso misãkiretiko aikotiã arõkakari matsorakitaãka. Ipi matapeka itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iuasaaki Xesosi akirikata: —Niri, nisikai nixinire pinĩkatini ĩkapani. Ikara atoko inaãka atoko, ipina. ");
INSERT INTO apuNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sotato auĩte itikasaakiri, ikenakotakasaakiri, itxa: —Atãopitikara ikira kiki atão inakarinoka kamakari iua. Maerekati !ikama —itxa sotato auĩte. ");
INSERT INTO apuNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kãkiti iuaã apotiitakaniua ikara atamatakasaakina, itorotana iaritana ipĩkarauatini xika. Ininiã isipekana. ");
INSERT INTO apuNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ikinika Xesosi aõkimanere, sitoakoro Kariréiakini, iua tikini sikani pakini aua iuaã. Ikira atoko itikanãtarina Xesosi okiko. ");
INSERT INTO apuNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Iuasaaki iuaã aua Xosee inakori. Xoteo auĩteakori õtãkikakari iua. Erekari iua. Erekarinoka ikama. ");
INSERT INTO apuNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Arimateia sitatxitikiri iua. Arimateia sitatxiti, Xotéia tõpa aua. Iãtapapikari Teoso ikinimane auĩte ininiua. Mitxipe apanakini Xoteo auĩteakori õtãkikakani nirekasaakiri Xesosi okinina, iuasaaki iua Xosee txari: —Konapitini. !Apakata ikara atoko akamini —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Xesosi ipinaka atoko, Xosee sari Piratomoni. Amanaãri Xesosi ĩto akauarimoni itakini ĩkapani. Ininiã Pirato sikari Xesosi ĩto iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ininiã iua makatxakari Xesosi ĩto itokakitikoãtaã. Iapirikari mãkatxi mataã, kai iriko ãki taka itxari. Mitxi ipĩkari !auapanika iua iriko ãki. ");
INSERT INTO apuNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ikara õti sesta veira. Ikinika sesta veira, Xoteoakori tomatini õti apisa, Xoteoakori aiamata tomatiko õti ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Sitoakoro Kariréiakini Xesosikata ĩkani sari Xosee tikini kai irikomoni. Ninoa nirekari imarotiniri Xesosi ĩto takikoãtaã. ");
INSERT INTO apuNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Eereka ninoa kanapiriã aapokomonina. Kamariãro, aãtsopa ãtião pakini apotiitana Xesosi ĩtoã itakinina ĩkapani. Ininiã tomatiko õti tomata itxana, kotxi Teoso paniãtakiti iaõka ikamana. ");
INSERT INTO apuNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tomĩkosaaki ĩkanõkapanika, sitoakoro sari kai irikomoni, kamariãro Xesosi ĩtoã itakinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ninoa apokasaaki iuaã, atamatarina. !Katoreikari kai iriko. Kai tore makatxakapeẽkaika. ");
INSERT INTO apuNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ininiã ninoa ĩroã, txama kona apokarina Xesosi ĩto. ");
INSERT INTO apuNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ininiã sitoakoro: —Ĩtapari Xesosi ĩto? Kanatokopa itxa? —itxanãtana. Iuasaakipeka ipi kiki tokiã. Itimana sitoakoro apisatoõ. Pomẽkori mãkarini ninoa. Mẽkokari iotximere atoko itxa ninoa mãka. ");
INSERT INTO apuNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sitoakoro pĩkarauata, ininiã iãkana. Ixitipeka auakiitana. Ininiã ninoa kiki txana: —Kinirepa hinitanãtari auãki inakari ipĩkani sauaki? ");
INSERT INTO apuNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","!Uaiikari iua. Õkitikapekaua. Hĩxinikari isãkire Kariréia hĩtekata auakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ia atoko itxa isãkire: “Hĩtari iaxitikiri sikaãkako maerekanimoni. Eereka nipinako aamina ĩpiriãmitakari nopini. Eereka ipi ãti õtisaaki iuaĩkana nõkitikauako,” itxa Xesosi. Hĩxinikariko isãkire —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ininiã ninoa sitoakoro: —Ari ikara atokopitikara itxapeka isãkire —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Eereka ninoa sipeka. Õsi Xesosi moianariakorimoni isana. Apanakini kãkiti iuaã aua apaka. Iuaã ninoa sãpiretana ikinipoko itikakitina. ");
INSERT INTO apuNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria Matarenama, Xoanama, Maria Txiako inoroma, apanakini pakini sãpiretari Xesosi moianariakori itikakitina. ");
INSERT INTO apuNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Txamari Xesosi moianariakori kona auikari ninoa sãkire. —Paxirari hĩsãkire —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Petronoka auikari ninoa sãkire, ininiã imiteẽkata kai irikomoni. Iãka, iriko ãki atamatini ĩkapani. Mãkatxi matanoka, Xesosi ĩtoã Xosee iapirikakitinoka atamata. Eereka aapokomoni ikanapiriã. Isikasaaki, itsorĩkaãnãta, Atamatakiti ixinikanãta. ");
INSERT INTO apuNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ikara õti ipi Xesosi sãkire auiãkani iãpota Emaoso inakori aapokotxitimoni. Xerosareẽ pipotorikasaaki, ipi oara napa atoko papoka Emaoso. ");
INSERT INTO apuNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ninoa ipi sãkirauanãta isaãpotakasaakina. Isãkiretarina, ixinikarina Xesosi ipinini pirena. ");
INSERT INTO apuNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Isãkirauanãtakasaakina, iuasaaki Xesosi ina ninoa tikini, ininiã iua sa ninoakata. ");
INSERT INTO apuNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Txamari ninoa kona imarotari iua Xesosi ininiua. ");
INSERT INTO apuNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ininiã Xesosi: —Kipa hĩte sãkirenãta? —itxa Xesosi. Ininiã ninoa iotoka. Iuasaaki ninoa toõ oerekari imatinaniuatinina. ");
INSERT INTO apuNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kiropasi inakori apakapapiretari: —Ikinimane Xerosareẽ auakani imarotari Xesosi okiko pirena. Atxiĩti pite ãtiãtaã ĩkarikai? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ininiã Xesosi txari: —Natokopa itxa iua? —itxa. Ininiã ninoa: —Xesosi Nasaree sitatxitikiri iua. Teoso sãkire sãpiretakari itxaua. Teoso, kãkiti apaka apokaerekatari isãkire, ikamakiti pakini, kotxi paposotiireri isãkire, ikamakiti pakini. ");
INSERT INTO apuNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sasetotxi auĩteakori, aãuĩteakori apaka sikari iua okiko ĩkapani, aamina ĩpiriãmitakari nopini ipinini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ate uãkatari iua kãkiti Isaeo auakani maerekani makatxaãkari ininiua. Kita mitxi iua ipina. ");
INSERT INTO apuNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mixikanani sitoakoro iua sãkire auiãkani sãkirauata atekata. Ininiã atsorĩkaãta. Isãpiretauana ĩkanõkapanika akauarimoni isinina. ");
INSERT INTO apuNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Txamari ninoa kona apokaikari Xesosi ĩto. Ninoa sãkire, aõkitana Teoso nitiriakori iaxitikini iuaã. Ninoa sãpiretana sitoakoro Xesosi iuaĩkana õkitikapekaua. ");
INSERT INTO apuNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Eereka ãtikaka imoianariakori sari iuaã atamatinirina ĩkapani. Sitoãkini sãkire atãopitikara. Txamari !aõkitari Xesosi iuasaaki —itxa Kiropasi. ");
INSERT INTO apuNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ininiã Xesosi txana ninoa: —Miĩkiteni hĩtxaua. !Hinirekari hãuikiniri Teoso sãkire sãpiretakani sãpiretakiti imakinika Teoso sãkire, ");
INSERT INTO apuNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","kotxi ninoa txari: “Teoso nirekari imereẽkiti atatsiirauatini, Teoso tixine ikanapiriini apisapanika,” itxa Teoso sãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iãpotakasaakina, Xesosi sãpiretana ninoa Teoso sãkire iuaka pirena. Merepanika iuaka oerekaua Moisesi iõkatsopatakitiã, eereka Teoso sãkire sãpiretakani iõkatsopatakitiã. Iuaka oerekaua imakinika Teoso sãkire iõkatsopatakoriã auakariã. ");
INSERT INTO apuNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Iuasaaki ninoa apokaãpota Emaoso takote. Ninoamoni Xesosi nirekari apikomoni isini. ");
INSERT INTO apuNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ininiã itxana: —Kona pisipe apikomoni. Mapiãnikata, ininiã atekata pikaikota —itxarina. Ininiã Xesosi ĩroã aapokotxiã ninoakata ikaikotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iitopãka ninoakata inipokotini ĩkapani. Iuasaaki Xesosi kosekari komiri. —Teoso, erekapitikari pisikakiti atemoni —itxa. Iuasaaki imapixinikari komiri, sika itxana ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Iuasaakipeka ninoa imarotari Xesosi ininiua. Iuasaakipeka, ereẽkoka itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ininiã ninoa misãkiretakakaua: —Atãopitikara, kimaporiã isãkirauaãpotakasaaki, Teoso sãkire oerekarauaãpotakasaaki, axinire poxokoniuata iuasaaki —itxana. ");
INSERT INTO apuNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Iuasaakipeka ninoa aiamata. Ikanapiriãna Xerosareẽmoni. Iuaã apokana õsi Xesosi moianariakori, apanakinikata. ");
INSERT INTO apuNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Isãpiretana: —Xesosi auãki inini pirena atãopitikara. Apiananiri õkitikapekaua. Petromoni oerekapekaua —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ininiã eereka Kiropasi imoianarikata sãpiretana kimapori isinina pirena. Isãpiretana komiri Xesosi mapixinikini pirena, kotxi iuasaakiika ninoa imarotari iua Xesosi ininiua. ");
INSERT INTO apuNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Isãkirauatapanikana inakasaakina, Xesosi tokiã ninoa sauaki. —Erekaxinire hĩtxako —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Itikoãkatana. Ipĩkarauatana. Kamiri iuãkatarina. ");
INSERT INTO apuNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","—Kinirepa hĩtikoka? Kinirepa kamaxirepeka hĩtxa iĩkiteta? ");
INSERT INTO apuNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Hãtamatariko niuako, nikiti pakini. Iuapitikarano nota. Himaãtakano. Kamiri !kaxiniri. Kamiri kona kapiri. Hãtamatano. Niĩtokara. Kamiri !nitxaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ininiã oerekari iuako, ikiti pakini ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ninoa iteene poxokoniuata, txamari !iteene !auikapanikarina atão Xesosi ininiua. Ininiã iuasaaki Xesosi pimaãna: —Nipokori aua hĩtemoni? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ininiã ninoa sikari ipixini ximaki kimitakori. Mapaã apaka isikarina. ");
INSERT INTO apuNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ininiã iua nikari ninoa apisatoõ. Iuasaaki ninoa imarotari atão Xesosi ininiua, kotxi kamiri !inikari nipokori. ");
INSERT INTO apuNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Eereka iua misãkiretana ninoa: —Mitxi hĩtekata nauakasaaki, nisãpiretai ikinipoko nota pirena Teoso sãkire iõkatsopatakoriã. Noerekapekai hĩte Moisesini iõkatsopatakiti, Teoso sãkire sãpiretakani iõkatsopatakiti. Xikari iõkatsopatakori apaka noerekapekai. Imakinika ninoa sãpiretakiti nota pirena apokapeka. ");
INSERT INTO apuNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Iuasaaki isikaimaroretana ninoa Teoso sãkire iõkatsopatakori imarotinina ĩkapani, ininiã iuasaaki ninoa imarotari atão. ");
INSERT INTO apuNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Itxari: —Kitxakapirĩka iõkatsopatapeẽkaika: Teoso mereẽkiti atatsiirauatako. Okaãkako. Ipi ãti õtisaaki õkitikauako. ");
INSERT INTO apuNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kãkiti nisãkire auiãkani iaripiretariko niokanapirena erekari ikini itixiti. Merepanika Xerosareẽ auakanimoni isãpiretaãkako, eereka ikini itixiti auakanimoni isãpiretaãkako. Ninoa oerekariko kãkiti takanapiniri imaerekanina, ininiã iuasaakipeka Teoso makatxakariko maerekati ikamakitina. ");
INSERT INTO apuNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hĩkinika hĩte itikapekari nipinini. Hãtamatano nota iuaĩkana auãki ninini. Ininiã iteene himarotari nota pirena apanakini hĩsãpiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nota iokanatariko niri sikaenetakiti, Erekari Matamatakoti, hĩtemoni. Uai sitatxi hĩkaikotako. Hiãtapariko iua apokini. Ininiã hãpakapariko Teoso posotiire itano ĩkari —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Xesosi anikari imoianariakori Petánia sitatxitimoni. Iuaã apokasaakina, Xesosi õkitikauakotaua. Itxari Teoso: —Niri, naia pinĩkata. Pitakari erekari naiamoni —itxa. ");
INSERT INTO apuNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Isãkirauatakasaaki, anikaãka Teoso tixinemoni. ");
INSERT INTO apuNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Iuasaaki ninoa: —Peerekari Xesosi. Iuanoka Apiananiri —itxanãtana. Eereka Xerosareẽ ikanapiriãna ipoxokoniritikana. ");
INSERT INTO apuNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ikiniõtika isana Teoso misãkiretiko aikotimoni. Iuaã ninoa misãkiretari Teoso: —Peerekai. Erekapitikari pikamakiti ate ĩkapani —itxanãtana ikiniõtika. Ameẽ.");
INSERT INTO apuNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Itixi kamiko apisa iua “Teoso Sãkire” inakori auapeka. Iua Teosokata aua. Iua Teoso txaua. ");
INSERT INTO apuNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ikinipoko potorikikosaaki Teosokata auari iua “Teoso Sãkire” inakori. ");
INSERT INTO apuNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Teoso paniãtari iua ikinipoko ikamini. !Auari iua makamakiniti. ");
INSERT INTO apuNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Xesosi, “Teoso Sãkire” inakori, kamari itanapokoka auãki inini. Iuanoka sikari ikinipoko auãki inini, kotxi iuanoka auapika. Iua tirikapi atoko itxa, kotxi iopinikari kãkiti xiniremoni Teoso sãkire imarotini ĩkapani, ãtipirika auini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Iopinikari ipiã. Ipiã kona xipokari iua tirikapi kamara. ");
INSERT INTO apuNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Teoso iokanatari isãkire sãpiretakari tĩkane kiki Xoão inakori. Iokanatari iua kãkitimoni, kãkiti xinire iopiniãkari isãpiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Isãpirenauata, Teoso sãkire ikinimane imarotini ĩkapani, auikapiretinirina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kona Xoãoni kãkiti xinire iopiniãkari txaua. Xoão iokanataãka kãkiti xinire iopiniãkari isãpiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iua atão iopinikari kãkiti xinire. Apoka ĩkoraxiti, ikinipoko kãkiti xinire iopinikini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iua “Teoso Sãkire” inakori aua ĩkoraxiti. Iua kamari itixi, iuaritika ĩkoraxiti auakani kona auikapiretari iua sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Iua apoka itixi ikamakitimoni, txamari kãkiti ikamakini kona nirekari iua. ");
INSERT INTO apuNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Iuaritika apanakini nirekari iua, ininiã auikarina isãkire. Ininiã iua sikaposotiiretana ninoa Teoso anaakori ininiuana ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aponaniãkasaaki, Teoso anaakori !atxaua. Ateka Teoso anaakori akaminiua !aposota. Kona kãkitini txĩkitakaua Teoso anaakori aniniãua. Teosora kamari iua anaakori aniniua. ");
INSERT INTO apuNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kãkiti itxapekaua iua “Teoso Sãkire” inakori. Atekata aua. Ate itikari iua. Peerekari iua. Peerekari iposotiire. Ikinipoko erekari aua iuamoni. Isãkire atãonoka itxa. Ikara atoko itxa, kotxi iri Teoso. Teoso ãkiri imatonõkari itxaua Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Xoão sãpiretari Xesosi kãkitimoni. Ia atoko isãpirenauata: —Iua, hĩtemoni nisãpiretakiti: “Nota tikinimoni apokakari, apiatako iua. Nota poiãoka, kotxi nota auini apisapanika auapeka iua.” ");
INSERT INTO apuNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ikinipoko erekari aua iuamoni, ininiã amakinika ate apakapari ikinipoko erekari iuamonikiri. Isikaãpotari erekari atemoni. ");
INSERT INTO apuNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Aimarotari Teoso paniãtakiti sãkiretxiti, kotxi Moisesini oerekapekaua. Apiaerekata Xesosi Kristo oereẽkiti, kotxi iua oerekaua Teoso iteene tiretiniua. Ikinipoko erekari isika atemoni. Maerekati kamakani atxaua, iuaritika Teoso tiretaua. Oerekaua atão inakari aimarotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Teoso atamatakari !auari. Imatonõkari Teoso ãkiri, irikata auakari, iuara oerekaua Teoso aimarotini ĩkapani, kotxi Teosotxikana iua. ");
INSERT INTO apuNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Xoteo auĩteakori Xerosareẽ sitatxiti auakani iokanatana kãkiti Xoãomoni. Iokanatana sasetotxiakori. Iokanatana sasetotxiakori moianatakani apaka Xoãomoni, ipimainirina ĩkapani: “Kinakariparai pite?” ");
INSERT INTO apuNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kona Xoão kipatari isãpiretinina. Atão isãpiretana: —Teoso mereẽkiti kãkiti iãtapakiti, kona nitxaua nota —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ininiã ipimaãrina: —Ikara atoko ininiã kiriparai? Eríasikani? —itxana. —Kona iuano —itxa. —Teoso sãkire sãpiretakari aiãtapakitikani atxiĩti? —itxana. —Kona iuano —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—Ikara atoko ininiã, natokopa inakariparai pite? Ninoa ate iokanatakani nirekari imarotiniina pite. Natokopa inakaripa pite? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ininiã Xoão: —Teoso sãkire sãpiretakari Isaía inakori iõkatsopatakiti txari: Auako kiki ãparaã makipakaniãtaã. Isãpirenauatako. Itxariko: “Hõeretariko kimapori Apiananiri apokini apisapanika. Itĩkaãpo erekari hĩkamako iua napini ĩkapani,” itxa Isaía. Iua kiki ãparaã makipakaniãtaã kasãpirenari, iuakarano nota. Iua Isaía sãpiretakitikarano nota —itxa Xoão. ");
INSERT INTO apuNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pariseoakorira iokanatana ninoa kiki Xoãomoni. ");
INSERT INTO apuNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ipimaãrina Xoão: —Iua Teoso mereẽkiti aiãtapakiti piminakanisaakiua, Eríasi inakori piminakanisaakiua, Teoso sãkire sãpiretakari aiãtapakiti piminakanisaakiua, kinirepa pite patxisatari kãkiti? Kipaniãpa pite patxisarauata? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","—Ãparaaãnanira nota patxisarauata. Hĩte sauaki aua kiki himimarotakiniti. ");
INSERT INTO apuNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iuara, nota tikini apokakari, apiatakari iua. Minakati nitxaua nota, ininiã kona apakata napokini iua takote. Kona apakata ikiti mata tsapitsa nikoxirikini, kotxi minakati nitxaua —itxa Xoão. ");
INSERT INTO apuNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ikara atoko Xoão sãpiretana ninoa Xotão ipiniã Petánia sitatxiti, ipatxisarauatiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Katimatinĩkata Xoão atapari Xesosi, iuamoni inini. Xoão sãpiretana apanakini itakote auakani: —Hãtapari. Erenapani soti auĩte ãkiri Teoso nakiti, kotxi ikinimane maerekani makatxaãkari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mitxi nisãpiretakitikara ere. “Kiki apokako nota tikini. Apiananiri iua, kotxi nota mauakanisaakipanika iua aua.” ");
INSERT INTO apuNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mitxi nota apaka kona nimarotari maerekanitxi makatxaãkari uãka. Nota patxisatari kãkiti ãparaaã, kotxi iuasaaki nisãpiretari iua pirena Isaeo tixini auakanimoni —Xoão txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Xoão sãpiretana apanakini itikakiti: —Nota itikari iua Erekari Matamatakoti Teoso tixinekiri katxakini. Kamoa katxakini atoko itxa iua. Isari Xesosimoni, kaikota itxa iuakata. ");
INSERT INTO apuNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ikara apisa kona nota imarotari iuãka. Ãparaaã nipatxisarauatini paniãtakari sãpiretano: “Pitikariko Erekari Matamatakoti katxakini. Kikimoni apokini pitikariko. Iua kiki patxisarauatini ãtião, kotxi isikari Erekari Matamatakoti patxisatakonimoni,” itxano. ");
INSERT INTO apuNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Notakara itikari ikara. Nota sãpiretari nitikakiti, ininiã nimarotapitikari ia kiki Teoso ãkiri ininiua —itxa Xoão. ");
INSERT INTO apuNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Katimatinĩkata iuaĩkana Xoão auanãta iuaã ipi imoianariakorikata. ");
INSERT INTO apuNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iuasaaki itikari Xesosi inapaãpotini, ininiã akiritari imoianariakori: —Hãtapari. Ere kiki, soti auĩte ãkiri Teoso nakiti itxaua —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ikara ikenakotakana atoko ninoa ipi imoianariakori sari Xesosi tikini. ");
INSERT INTO apuNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ininiã Xesosi sapotorika, atapana iua tikini ĩkani. —Kipa hinireka atxiĩti? —itxana ninoa. —Koerekareri, namonipa paua pite? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Masa, hãtamata —itxa. Ininiã isana iuakata, atamata itxarina iua auiniãtaã. Iuasaaki kikatapeka. Eereka ĩkanõkapeka ikanapiriãna. ");
INSERT INTO apuNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ninoa Xoão moianariakori, Xesosikata sikani, Ãtree, Ãtree moianari pakini. Simão Petro itari itxaua iua Ãtree. ");
INSERT INTO apuNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Eereka Ãtree sari katimariã itari Simãomoni. —Ate aõkitari Teoso mereẽkiti aiãtapakiti —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ininiã Ãtree anikari itari Simão Xesosimoni. Xesosi atamatari Simão. —Pite Simão, Xoão inakori ãkiri. Uatxa pite Petro pinaãkako —itxa. Kai sorotxikana iuãka Petro. ");
INSERT INTO apuNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Katimatinĩkata Xesosi nirekari Kariréia tõpamoni isini. Iuaã aõkitari Piripi inakori. —Notakata masa. Nimoianari pitxapekauako —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Iua Piripi aapoko Petsáita sitatxiti. Iuaã apaka aua Ãtree, Petro pakini aapoko. ");
INSERT INTO apuNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Iuasaaki Piripi nitari Natanaeo inakori. Apokasaakiri isãpiretari: —Ate aõkitari kiki. Moisesini iõkatsopatakiti sãpiretakiti iua. Teoso sãkire sãpiretakani iõkatsopatakiti sãpiretakiti aaõkita. Iuakara Xesosi txaua. Nasaree sitatxitikiri iua. Xosee ãkiri iua Xesosi —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—Nasaree sitatxitiã !auari erekari —itxa Natanaeo. —Auapitika. Masa, maãpiãkatari iua —itxa Piripi. ");
INSERT INTO apuNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Xesosi atapari Natanaeo iuamoni inaãpotini. —Ere kiki atão Xoteopitikara. Atãonoka ikama —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ininiã iuasaaki Natanaeo kenakotari Xesosi sãkire. Ipimaãri Xesosi: —Kiãtokopa ininiãpa pimarotano nota? —itxari. Xesosi txari iua: —Piripi akiritinii apisapanikara, nimarotari piko kati patapi piitopãkanãta. ");
INSERT INTO apuNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ininiã Natanaeo apakapapiretari: —Koerekareri, Teoso ãkiri pitxaua pite. Kãkiti Isaeo tixini auakani auĩte pitxaua —itxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ininiã Xesosi: —Pite auikari nisãkire, kotxi nimitikakinitika nimarotari piko kati patapi piitopãkanãtini. Pite imarotapanikariko apia posotiiretxi. ");
INSERT INTO apuNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Pite itikariko Teoso tixine osereẽkiko. Pitikariko Teoso nitiriakori kanĩkini. Pitikariko ninoa katxakini, pitari iaxitikiri nopini apokinina. Atãopitikara ikara atoko nitxai pite —itxari Natanaeo. ");
INSERT INTO apuNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ipi õti napaka atoko aua kiiniri tanirauatiko pirena kiiniriti Kanaa sitatxiti Kariréia tõpa. Xesosi inoro aua kiiniriãtaã iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kakiiniriteri kemaĩtxitari Xesosi, imoianariakori pakini. ");
INSERT INTO apuNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Iãriã xipoka atoko Xesosi inoro: —!Auaika iãriã —otxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ininiã Xesosi: —Kinirepa ikara atoko pitxano? Niposotiire manapi !apokapanika —itxaro inoro. ");
INSERT INTO apuNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ininiã Xesosi inoro txana kaapokori nitiriakori: —Ipaniãtakiti iaõka hĩkamako —otxa. ");
INSERT INTO apuNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Iuaã kopiti aua, seisi pakini, mitari kopititi, kai kamakori. Naia kopiti ãki aua ãparaã Xoteoakori arokiniua ĩkapani. Iuaãtaã ninoa arokaua. Kiomãtxiakorini oerekinina atoko ninoa arokaua Teoso imisãkiretinina apisa, ninoa Teoso apakapini ĩkapani. Ãtika iua kopiti maĩkari ãparaã seĩ arítro. ");
INSERT INTO apuNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Xesosi paniãtana kaapokori nitiriakori: —Hĩxãpokakari naia kopiti ãki ãparaã —itxana ninoa. Ininiã ninoa xãpokakari kopiti ãki ãparaã. Isonakatapeka apoka ãparaã. ");
INSERT INTO apuNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ininiã Xesosi: —Hĩsorokaãtari ãparaã, sika hĩtxari kakiiniriterimoni iãtini ĩkapani. Ininiã ninoa anikari ãparaã kakiiniriterimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Iua kakiiniriteri iãtari. Iuasaaki iãriãpeka itxapekaua ãparaã. —Amonipa ina ia iãriã? —itxa. !Imarotari. Ninoa nitiritxi ãparaã anikakani imarotari iua iãriã. Ininiã kakiiniriteri txari ĩtanorouatakari: ");
INSERT INTO apuNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Kinirepa mixikanani ia iãriã apia erekari na pisikaua? Apanakini sikari iãriã apia erekari kiiniri potorikasaaki. Kãkiti kamitope inakasaakiika apanakini sikari iãriã poião erekari. Txamari uatxaika pite sikari apia erekari —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iuasaaki Xesosi mipotorikari iposotiire Kanaa sitatxiti Kariréia tõpa iua auakasaaki. Iposotiire oerekari Apiananiri ininiua. Ikara atoko ininiã, Xesosi moianariakori auikari Xesosi Teoso mereẽkiti kãkiti iãtapakiti ininiua, kotxi ninoa itikari iposotiire. ");
INSERT INTO apuNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ikara atoko inaãka atoko Xesosi, inoro, itariakori, imoianariakori pakini sari Kapanaoõ sitatxitimoni. Iuaã ikaikotana mapaõtipeka. ");
INSERT INTO apuNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Xoteoakori kiinirite Páskoa inakori apisapanika, Xesosi sari Xerosareẽmoni. ");
INSERT INTO apuNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Isa Teoso misãkiretiko aikotimoni. Iuaã pirikeri ãki itikari pirãtxi vẽtxitakani, kema auĩte, soti auĩte, kamoa pakini vẽtxitakani. Itikari txineirota sikakani apaka. Amesa takote ninoa topãkanãta. Ivẽtxitarona txineirota. Apakaparona ãti uãka txineirote, kotxi oa ãtoião, ininiã Xoteo txineirote isikana. ");
INSERT INTO apuNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ininiã Xesosi kosekari aãpitsa. Ĩpatari. Aãpitsaã omitikenatana ninoa pirãtxi vẽtxitakani. Omitikenatana kema auĩte, soti auĩte Teoso misãkiretiko aikoti takote auakani. Ikakanapiriãri amesa txineirota apakapikoãtaã. Txineirota xikepoakatani. ");
INSERT INTO apuNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ipaniãtana kamoa vẽtxitakani: —Himakatxakariko kamoa. Hanikariko mapara. Niri aapoko ãki hĩvẽtxirauatini !apakata. Kona uaini pirãtxi vẽtxitiko —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iuasaakipeka imoianariakori xinikari Teoso sãkire iõkatsopatakori: Nota iteene tiretari paapoko pite misãkiretiko aikoti. Iua xika nokaãkako, itxa Teoso sãkire iõkatsopatakori. ");
INSERT INTO apuNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Eereka Xoteo auĩteakori misãkiretari Xesosi: —Teoso paniãtiniãi ninoa kãkiti iua misãkiretiko aikotiã auakani pomitikenatini, poerekaua posotiiretxi Teoso paniãtinii aãuikini ĩkapani —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Xesosi apakapapiretari: —Hĩrikariko ia Teoso aapoko. Ipi ãti pakini õtisaaki iuaĩkana nõkitikariko ia Teoso aapoko —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ininiã ninoa: —Anekani. Koarẽta seisi anokanani iua aiko kamiko. Kiãtokopa pitxari ipi ãti pakini õtisaaki põkitikiniri iuaĩkana? Kona kiĩkitei pite pisãkire ikara atoko pinini —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Txamari Xesosi sãkire “Teoso aapoko” ixinikari iĩto. !Ixinikari Teoso misãkiretiko aikoti. ");
INSERT INTO apuNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Xesosi ipinaãka atoko, õkitikaãkaua atoko, iuasaakipeka imoianariakori xinikari ikara Xesosi sãkire. Iuasaaki ninoa auikari Xesosi sãkire. Auikarina Teoso sãkire iõkatsopatakori sãpiretiniri Xesosi atão Teoso ãkiri ininiua. ");
INSERT INTO apuNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Xesosi Xerosareẽ auakasaaki, Páskoa kiiniriti auakasaaki, itomaneri kãkiti auikari Xesosi Teoso mereẽkiti ninoa iãtapakiti ininiua. Ninoa itikari posotiiretxi ikamakiti, ininiã auikarina Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Txamari Xesosi !auikari kãkiti sãkire, kotxi imarotari ikinimane ãkixinire sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kãkiti ãkixinire sãkire !ipimaãri xatiki, kotxi imarotapekari kãkiti ãkixinire sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ãti ĩkanõkati Nikotemo inakori motika Xesosimoni. Iua Xoteoakori auĩte itxaua. Pariseo itxaua apaka. ");
INSERT INTO apuNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Iua misãkiretari Xesosi: —Koerekareri, ate imarotari koerekareri, Teoso iokanatakiti pininiua. Teoso pitekata mauakaniã, kona piposotari posotiiretxi pikamini, ininiã ate imarotari Teoso iokanatai pite kãkitimoni —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ininiã Xesosi: —Iuaĩkana iponaniãkarira sari Teoso auĩtetxi ininiãtaãua. Iuananira sari iuaxiti. Atãopitikara ikara atoko nitxai pite —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—Kiãtokopa pitxa auapekarikai iuaĩkana piponaniini? Kona piposotari pinoro ãko ãki iuaĩkana piĩroini. Kona piposotari iuaĩkana piponaniini —itxa Nikotemo. ");
INSERT INTO apuNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Ininiã Xesosi: —Atãopitikara ikara atoko nitxai. Piponaniãkasaaki, piri, pinorokata ãkirinanira pitxaua. Iua Erekari Matamatakoti iponaniãkitakiniãi, Teoso ãkiri pitxaua. Kãkiti, iua Erekari Matamatakoti iuaĩkana iponaniãkitaãkitinanira, sari Teoso auĩtetxi ininiãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Koniko pitsorĩkaãtapeko. Piponaniãko ipikata. Ipikata pimiponaniãkaniã, kona pisari Teoso auĩtetxi ininiãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ĩtima xõkarauata inirekiniãtaã. Pikenakotari ixõkarauatini, iuaritika na pimarotari ĩtima sinimoni. Na pimarotari ĩtima ininimoni. Iua atokokana !kimarotikori Erekari Matamatakoti iuaĩkana iponaniãkitaãkiniri kãkiti —Xesosi txari Nikotemo. ");
INSERT INTO apuNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikotemo apakapapiretari: —Nota !imarotari ikara pisãkire —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ininiã Xesosi: —Koerekareri apiari pitxaua. Kãkiti Isaeo tixini auakani poereka. Txamari pite !imarotari ikara atoko nininii pite. ");
INSERT INTO apuNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Atãopitikara ikara atoko nitxanãtai pite. Ate sãpiretari aimarotakiti, aĩtiãkiti pakini. Txamari !hinirekari hãuikapiretiniri asãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ĩkorapokoriti pirena nisãpiretakasaakii, !pauikari nisãkire. Atauako pauikatari nisãkire Teoso tixine pirena nisãpiretakasaakii? ");
INSERT INTO apuNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kona kãkiti sapanika Teoso tixine. Ãtinoka sari iuaã, Teoso tixine potorikakarinoka, kãkiti itari iaxitikirinoka sari iuaã. ");
INSERT INTO apuNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","—Kitxakapirĩka ãparaã makipakaniãtaã Moisesini õkitikari imini metao kamakori aãke mapotõkireẽ. Itano itakari. Kãkiti Teoso sãkire auiãkani imini akatsatakini atamatari Moisesini õkitikakiti, ininiã kona ipinana. Iua atokokana kãkiti itari iaxitikiri õkitikaãkako. ");
INSERT INTO apuNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ininiãkara iua sãkire auiãkari kona ipinaika. Auapikako. ");
INSERT INTO apuNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Teoso iteene tiretari ikini itixiti auakani, ininiã iokanatari imatonõkari imi kãkitimoni. Ininiã iua sãkire auiãkanirako kona ipinaikako. Ãtipirika auapikako. ");
INSERT INTO apuNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Teoso iokanatari imi kãkitimoni ikini itixiti auakanimoni kona imisiritinina ĩkapanini. Iua iokanatari imi kãkiti maerekani imakatxakini ĩkapani, ninoa imapinakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","—Teoso ãkiri sãkire auiãkari kona iokanataãka kãkiti misiritikomoni. Iua Teoso ãkiri sãkire mauiãkati, iuarako sako kãkiti misiritikomoni. Teoso ãkiri sãkire imauiãkani xikara ikara atoko inaãkanako. ");
INSERT INTO apuNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Teoso ãkiri sãkire mauiãkani misiritaãkako, kotxi atão inakari oerekakari kãkiti xinire iopiniãkari apokapeka ĩkoraxiti. Iua oerekari atão aimarotini ĩkapani. Tirikapi atoko itxa, kotxi oerekaua atão. Ninoa mauikareni kona nirekari tirikapi. Inirekarina ipiã, kotxi maerekati ikamanãtana. ");
INSERT INTO apuNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Maerekati kamakari kona nirekari tirikapi. Kona tirikapi takote kona aua, kotxi ipĩkari ikamara. Ipĩkari kãkiti itikiniri maerekati ikamini. ");
INSERT INTO apuNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Teoso sãkire iaõka kamakarira sari ikamaraã, kotxi ikamara oerekari apanakini iua kamakiti atão inini Teoso nireẽkiti iaõka inini —Xesosi txari Nikotemo. ");
INSERT INTO apuNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ikara atoko inaka atoko Xesosi imoianariakorikata sari Xotéia tõpamoni. Mapaõti ikaikota imoianariakorikata iuaãtaã. Imoianariakori patxisatari kãkiti iuaã. ");
INSERT INTO apuNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Xoão apaka patxisatari kãkiti Enõ inakoriãtaã, Sarĩ inakoriãtaã takote. Ipatxisarauata iuaãtaã, kotxi iuaãtaã ãparaã kaiãopokori. Ikiniõtika kãkiti sari iuamoni iuaãtaã, ininiã Xoão patxisatana. ");
INSERT INTO apuNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Iuasaaki Xoão kona takaãkapanika kateia ãki. ");
INSERT INTO apuNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Iuasaaki Xoão moianariakori sãkirauata apanakinikata kãkiti arokiniua pirena, Teoso misãkiretiko aikoti ãki iĩroinina apisa pirena. ");
INSERT INTO apuNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Apokana Xoãomoni. —Koerekareri, Xotão ipiniã iua kiki pite patxisatakiti, atemoni pisãpiretakiti, uatxa iua patxisarauatapeka. Ikinipoko kãkiti sari iuamoni. Atemoni !erekari ipatxisarauatini —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Xoão apakapapiretana ninoa: —Erekapitikari ipatxisarauatini, kotxi Teoso paniãtari iua. Teoso masikakaniãri posotiiretxi kãkitimoni, kona xatiki iposotari iparĩkauatini Teoso ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nota kona Teoso mereẽkitino. Kãkiti iãtapakiti kona nitxaua nota. Teoso iokanatano nota Teoso mereẽkiti apokini apisa. Ikara hĩte imarotapeka. Ikara atoko nitxapekai hĩte. Hĩsãpiretari ikara apanakinimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","—Maxinikari kiki ĩtanorouatakasaaki. Sito amanaãkito iua nakiti otxaua. Imoianari topãka iua takote. Ipoxokoniuata ĩtanorouatakari sãkire ikenakotakasaaki. Iua atokokana nota poxokoniuata. Nota iua moianari atoko nitxaua. Xesosi iua ĩtanorouatakari atoko itxaua. Kãkiti iua nakiti itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Xesosi apiaãpotako. Nota poiãoãpotako. ");
INSERT INTO apuNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","—Iaxiti ĩkari Apiananiri. Itixi auakani imarore poiãonoka, kotxi itixinoka imarotana. Teoso tixine ĩkari Apiananiri itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Iua sãpiretari itiãkiti. Ikenakotakiti isãpireta. Txamari kãkiti !auikari isãpirena. ");
INSERT INTO apuNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kãkiti Apiananiri sãpirena auiãkani, imarotari Teoso sãkire atão inini, ininiã apanakini apaka imarotari Teoso sãkire atão inini. ");
INSERT INTO apuNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iua Teoso iokanatakiti sãpiretari Teoso sãkire, kotxi Teoso sikari Erekari Matamatakoti iuamoni, ininiã ikinipoko Erekari Matamatakoti posotiire aua iua Teoso iokanatakitimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aĩri Teoso tiretari imi. Isikari imi ikinipoko imoiaini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Teoso ãkiri sãkire auiãkani auapikako Teosokata. Teoso ãkiri sãkire mauiãkani kona auapanina Teosokata. Teoso omanatapikanako ninoa ãtipirika —itxa Xoão ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kãkiti sãpiretari pariseoakori: —Xesosi sãkire auiãkani, iua patxisatakini, itomaneri. Xoão patxisatakini poiãoka —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ari, kona Xesosini patxisarauata. Imoianariakorira patxisatari kãkiti.) ");
INSERT INTO apuNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Xesosi imarotakasaakiri pariseoakori kenakopiretiniri iua, iuasaaki iua osipikari Xotéia tõpa. Kinirão kanapirikari Kariréia tõpamoni. ");
INSERT INTO apuNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Inirekari Samaria tõpa ĩpirixititini Kariréia tõpa apokini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria tõpa ĩpirixititakasaaki, apoka Sikaa sitatxiti takote. Iuaã aua itixi Xoseeni nakiti, iri Xakooni sikakiti kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iuaã aua aariko Xakooni kisakakiti ãparaã apaãtiko. Iuaã Xesosi apokasaaki, iotoka, kotxi isãpakapeka õtakori ĩpirixititini xika. Ininiã iitopãka aariko takote. Iuasaaki apaniãxitipeka. ");
INSERT INTO apuNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Iuasaaki sito Samaria auakaro apoka iuaã, ãparaã apaãtakaro. Oãpokasaaki, Xesosi amanaãro ãparaã: —Ãparaã pisikano —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Oa apokini apisapanika Xesosi moianariakori sari sitatximoni nipokori iamotinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Oa sito apakapapiretari: —Xoteo pitxaua pite. Samaria auakaro nitxaua nota. Kinirepa nãparaãte pamanaãno? —otxa. Ikara atoko otxa, kotxi Xoteoakori kona sãkirauata Samaria auakanikata. ");
INSERT INTO apuNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ininiã Xesosi: —Teoso sikakiti pimarotaãkamako, pitemoni ãparaã amanaãkari pimarotaãkamako, notamonimarako pamanaãri ãparaã, kotxi piãtiniãri ãparaã nota sikakiti, pauapika ãtipirika —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Kona katiiui pite. Kiriãpa papaãtari ãparaã, kotxi paĩtanoirikori. Namonipa papokatari ãparaã kãkiti ãtipirika auini inĩkitaãkari? ");
INSERT INTO apuNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kitxakapirĩka aãtokirini Xakoo sikaua ate ia aariko. Iua, imiakori, ipiraakori pakini iãtari ia ãparaã ia aarikoãkiri. Pite apiata atxiĩti? —otxa. ");
INSERT INTO apuNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ininiã Xesosi: —Kãkiti ia irikoãkiri ãparaã iãtakari iuaĩkana iposonatapanika. ");
INSERT INTO apuNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kãkiti nota siãkiti ãparaã iãtakari apikomoni !iposonataika. Ãkixinire amomo atoko itxa ãparaã nota siãkiti. Iua ãparaã txĩkitakari iua ãtipirika auini Teosokata —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Iua ãparaã pisikano nimaposonatakani tĩkane, ininiã uai kona ninaika ãparaã napaãtini —otxa. ");
INSERT INTO apuNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Pakiritari pĩtaniri. Uai piminari —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Kona kĩtanirino —otxa. —Atãopitikara, “Kona kĩtanirino,” pinini. ");
INSERT INTO apuNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sĩko pakinipekara pĩtaniri. Kiki uatxa pitekata auakari na atão pĩtanirini. Inipitikara pisãkire —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ininiã oa: —Teoso sãkire sãpiretakari pitxaua pite, kotxi pimarotari ikinipoko nikamakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kitxakapirĩka ate kiomaneakorini apotiitaua Teoso imisãkiretinina ĩkapani ia oxiratari nopini. Txamari hĩte Xoteoakori txari: “Xerosareẽnanira aãpotiitauako Teosokata” —otxa. ");
INSERT INTO apuNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ininiã Xesosi: —Pauikariko nisãkire. Ãti õti apokako. Iuasaaki kona uai oxiratariãni, kona Xerosareẽni kãkiti apotiitaua aĩri Teoso imisãkiretinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hĩte Samaria tõpa auakani apotiitaua Teoso himisãkiretini ĩkapani. Txamari, kona atão himarotari iua. Ate Xoteoakori aimarotapitikari Teoso, kotxi Teoso sikakiti kãkiti maerekani makatxakakari Xoteo itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Teoso keto apokapanika, ari apopeka, ininiã aĩri Teoso misãkiretakani atão inakani misãkiretari iua ãkixinireẽna. Ninoa sãpiretari atão inakarinoka iuamoni. Aĩri nirekari kãkiti ikara atoko inakani misãkiretiniri iua. ");
INSERT INTO apuNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Teoso nirekari amisãkiretiniri iua aãkixinireẽ, kotxi Teoso ĩto !auari. Inirekari kãkiti sãpiretiniri atão inakarinoka iuamoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ininiã oa: —Nimarotapitikari iua Teoso mereẽkiti aiãtapakiti, Kristo inakori, apokapitikako ĩkorapokoriti. Iua apokasaaki ikini sereti isãpiretauako —otxari. ");
INSERT INTO apuNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Nota pimisãkiretakiti Teoso mereẽkiti hiãtapakitikarano nota —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iuasaakipeka Xesosi moianariakori kanapiriã. Ãkixinireẽna ninoa tsorĩkaãnãta: —Kinirepa Xesosi sãkirauata oa sitokata? Kotxi oa Samaria auakaro. Iuaritika !ipimaãrona: “Kiripa ĩkai?” kona itxarona. Kona ipimaãrina Xesosi: “Kinirepa pimisãkiretataro oa?” kona itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Iuasaaki oa sito takanapari otii, sitatximoni kanapiriã otxa. Oãkiritari kãkiti iuaã auakani, ");
INSERT INTO apuNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Masa. Maãpiãkatari kiki ikinipoko nikamakiti imarotakari. Iua Teoso mereẽkiti aiãtapakiti atxiĩti? —oa txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ininiã iua sitatxi auakani sari Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ninoa apokini apisapanika imoianariakori akiritari Xesosi: —Koerekareri, pinipokota —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Nipokori auape nota niãkiti tĩkane hĩte mimarotakiniti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ininiã imoianariakori imisãkiretakakana: —Kiripa sikatari nipokori Xesosi nikakiti? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ininiã Xesosi: —Nota kamari iua niokanatakiri nirekaãkiti. Ninirekari nikaminiri ikinipoko iua paniãtakiti. Ia niparĩka. Niparĩka nikiena atoko itxa, kotxi niokanatakiri paniãtakiti nikamini sikataparatano, nipokori sikataparatinino atokotxikana. ");
INSERT INTO apuNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kãkiti txari: “Ipi ipi pakini kasiriti auapanika takari iposope inini tĩkane, ininiã uatxa kona niparĩkauata.” Ia atoko kona hĩtxape hĩsãkire. Himereka. Hãtamatariko takari. Nisãpiretai hĩte hĩtakare iposope haãpoko hanikini tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Iua atokotxikana Teoso sãkire takaãka kãkiti ãkixinireẽ. Katakareri miparĩkatakari apakapari iparĩka ĩki. Iua anikari kãkiti Teoso aapokomoni, ãtipirika Teosokata auini ĩkapani. Ininiãkara katakareri, iua miparĩkatakari apaka poxokoniuatako. ");
INSERT INTO apuNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Aãtokirini txari: “Ãti takarauata, ãtipekana apotiitari takari.” ");
INSERT INTO apuNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ia sãkiretxiti atão, kotxi nota paniãtai hĩte mitxi himaparĩkauatakaniãtaã hamarauatini. Apanakini parĩkauatapeka iuaã. Ninoa takapekari Teoso sãkire kãkiti ãkixinireẽ. Pasãpaniri ninoa parĩka. Ninoa parĩkauata mitxi, ininiã uatxa hĩte parĩka poião kãkiti Teosomoni hanikini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kaiãopokori Samariakini iua sitatxiti auakani auikari Xesosi sãkire, kotxi oa sito mitxi sãpiretana: —Nikamakiti ikinika isãpiretano —otxana. ");
INSERT INTO apuNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ininiã ninoa Samaria auakani apoka Xesosimoni. —Atekata paua —itxarina Xesosi. Ininiã Xesosi kaikota ipi õti ninoakata. ");
INSERT INTO apuNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Xesosi sãkire ikenakotakasaakina, apikomoni ninoa auikapiretari. ");
INSERT INTO apuNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ninoa misãkiretaro oa sito: —Uatxa ate auikapiretari Xesosi sãkire, kona pite sãpirenaãnanini, ate auikapiretari. Ateka kenakotapekari iua sãkire, ininiãkara ate auikapiretari iua sãkire. Uatxa ate imarotari atão inini Teoso mereẽkiti ininiua Xesosi. Kãkiti itixi auakani maerekani makatxaãkari itxaua iua —itxarona. ");
INSERT INTO apuNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iuaã ipi õti inapaka atoko Xesosi sipeka. Kariréia tõpa isa. ");
INSERT INTO apuNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mitxi Xesosi sãkire: “Teoso sãkire sãpiretakari paxitaãka, txamari Teoso sãkire sãpiretakari itixineẽ auakasaaki, kãkiti iuaãtaã kona auikari iua sãkire,” itxapeka Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Iuaritika Kariréia tõpa apokasaaki, kãkiti iuaã auakani ipoxokoniritika apakapari Xesosi, kotxi ninoa apaka sari iua Páskoa kiiniriti Xerosareẽ sitatxitiã. Iuaãtaã itikarina Xesosi posotiire. Ininiãkara ipoxokoniritikana apakaparina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Xesosi iuaĩkana sari Kanaa sitatxitimoni, Kariréia tõpa. Mitxi Xesosi inoãkapekari ãparaã iãriã ininiua iuaã. Xesosi apokasaaki Kanaa, auĩtetxi ãkiri amianata Kapanaoõ sitatxitikiri. ");
INSERT INTO apuNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Iua auĩtetxi kenakopiretari Xesosi Kariréia tõpa apokini, Xotéia tõpa osipikini. Inakasaaki Xesosimoni isa, aõkita itxari Xesosi. Aiatari: —Masa Kapanaoõmoni, naapokomoni. Namarite amianata. Pimakananitari iua. Ipinanapanoka —itxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ininiã Xesosi: —Nimakamakaniãri posotiiretxi, kona hĩte nirekari auikiniri nisãkire. Posotiiretxi hĩtikasaakinani, hĩte nirekari nisãkire hãuikini. Teoso takaõtxikare hĩtikasaakinani, hinirekari nisãkire hãuikini —itxa Xesosi iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Masapoka naapoko. Pimasikanisaaki, namarite ipinapitikako —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Pisa paapokomoni. Pamarite kona ipina —Xesosi txari iua. Iua kiki auikari Xesosi sãkire, ininiã isipeka. ");
INSERT INTO apuNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ipixinipokoriti aõkitana initiriakori. —Pamarite auapitikako —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—Namonikitapa akananita? —itxana. —Kita apaniãxiti apoomari iotoka —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Iuasaaki iua kiki imarotari kita Xesosi sãkire manapikara: “Pamarite kona ipina,” ininiri manapikara iotoka apoomari. Ikara atoko ininiã, ikinimane iua aapoko auakani, iua pakini auikari Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ininiã ipikatapeka Xesosi kamari posotiiretxi Kariréia tõpa auakasaaki, Xotéia tõpa osipikasaaki. ");
INSERT INTO apuNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ikara atoko inaãka atoko Xesosi sari Xerosareẽ sitatxitimoni, kotxi Xoteo kiinirite Teoso ĩkapani aua iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Xerosareẽ sitatxiti apanĩkaki, soti auĩte vẽtxitikoãtaã takote aua ipoa xapitikiri. Sĩko ĩronakiko aua iuaãtaã. Xoteo sãkire Epiráiko. Epiráiko sãkireẽ iua ipoa uãka “Petésita.” ");
INSERT INTO apuNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ironakikoãtaã amianatakanipokoni sirĩkanãta. Mõsiãreni, motĩkakani, matĩpokotakani pakini iuaã auanãta. Iãtapanãtarina ãparaã tokĩkaãtini. ");
INSERT INTO apuNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Teoso nitiri apokanaka iuaãtaã. Iua apokasaaki itokĩkaãtakari ãparaã. Ãparaã tokĩkaãtakasaaki, ãtika amianatakari ĩkiika komokaãtakari erekapeka itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Matĩpokotakati iuaã auanãtakari amiananãtakari trĩta oito pakini anokanani amianata. ");
INSERT INTO apuNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Xesosi atamatari iua iuaã isirĩkanãtini. Imarotari iua uatxakapokoni amiananãta. Ininiã Xesosi pimaãri: —Ereka pinini pinireka? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Amianatakari apakapapiretari: —Ari, ninirekapitikamari, txamari kona kanikikono kãuaãriã ãparaã tokĩkaãtakasaaki. Nikomokaaritakasaaki, ãti komokape napisapanika —itxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Põkitikaua. Pisirimata pikoseka, sipeka pitxa —Xesosi txari. ");
INSERT INTO apuNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Iuasaakipeka erekapeka itxa iua amianatakari. Isirimata ikoseka, tĩpokota itxapeka. Iua õti kãkiti tomatini õti. ");
INSERT INTO apuNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ininiãkara Xoteo auĩteakori txitari amianatakari erekapeka inakari: —Uatxa kãkiti tomatini õtisaaki pite anikanãtari pisirimata. Ĩkora atoko ininiã, kãkiti !auiritaãka —itxarina, kotxi ninoamoni iparĩkauata isirimata anikasaaki. ");
INSERT INTO apuNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ininiã iua kiki: —Erekape ninĩkitaãkirira paniãtano: “Pisirimata pikoseka, sipeka pitxa,” itxano. ");
INSERT INTO apuNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ininiã ninoa: —Kiripa kiki paniãtai pisirimata pikosekini pisini ĩkapani? ");
INSERT INTO apuNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","—!Nimarotari iuãka —itxa. Iuaãtaã ipoa xapitikiri takote kaiãopokori kãkiti auanãta, ininiã patimari Xesosi sipeka ninoa sauaki. ");
INSERT INTO apuNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Eereka Xesosi aõkitari iua kiki Teoso misãkiretiko aikotiã. —Uatxa pitĩpokotapeka, ininiã maerekati pitakanapako. Iuaĩkana maerekati pikamakasaaki, atxiĩti amianari apiatakari inokai —Xesosi txari iua. ");
INSERT INTO apuNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Eereka iua kiki sari Xoteo auĩteakorimoni. —Xesosira erekapeka txĩkitakano nota —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tomatiko õtisaaki Xesosi makananitari iua amianatakari. Ikara xika Xoteo auĩteakori kinirão okaka txari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Xesosi imarotari Xoteo auĩteakori sãkire, ininiã itxana: —Niri Teoso kamari erekari ikiniõtika. Iua atokotxikana nota. Kona niotoka erekari nikamini tomatiko õtisaaki —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ikara Xesosi sãkire xika Xoteo auĩteakori apiata omanatari Xesosi. Ninoamoni Xesosi kamari maerekati tomatiko õtisaaki amianatakari imakananitini. Xesosi sãkire: “Niri Teoso,” inini xika, apiata omanatarina iua, kotxi iua: “Teosotxikana nota” itxanãta iua Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ininiãkara Xesosi misãkiretana Xoteo auĩteakori: —Atãopitikara nitxai hĩte. Nota Teoso ãkiri nitxaua. Notanani !kakamareno. Nitikari niri kamanãtakiti, ininiã niri kamakiti iaõka nikama. Iuanokara nikama nota. Niri kamakititxikana nota kama apaka. ");
INSERT INTO apuNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Niri tiretano nota, ininiã ikini sereti ikamanãtakiti oerekano. Oerekapanikariko posotiiretxi apiatapanikako nota kamini ĩkapani, ininiãkara hĩte tsorĩkaãtako hĩtikasaakiri. ");
INSERT INTO apuNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Niri õkitikari ipĩkani, iuaĩkana aua inini tĩkane. Iua atokotxikana nota txĩkitakana kãkiti ninirekaãkini, iuaĩkana auini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Teoso kona txari kãkitimoni: “Kona erekai pite, ininiã kãkiti misiritikomoni pisa,” kona itxa Teoso. Apanakinimoni kona Teoso txari: “Erekai pite, ininiã uai pina notakata pauini ĩkapani,” kona itxa Teoso. Notakara iua ãkirikara txari ikara atoko inakari kãkitimoni, kotxi Teoso sikaposotiiretano nota ikara atoko inakari nisãpiretini kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ikara atoko ininiãkara, kãkiti paxitano nota. Niri nirekari nota paxitiko, iua paxitiko atokotxikana. Nota mapaxitakani kona paxitari niri nota iokanatakari. ");
INSERT INTO apuNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—Atãoenepitikara nitxai hĩte. Nisãkire kĩpitakari, nota iokanatakari sãkire auiãkari, auapika Teosokata. Kona Teoso misiritapaniriko iua. Kona ipinaika. Auapika Teosokata. ");
INSERT INTO apuNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Atãoene nitxai hĩte. Kãkiti xinire ipĩkari atoko itxa maerekati ikamakiti xika. Teoso ãkiri sãkire kãkiti kĩpitini õti apokapanikako. Ari iketo apokapeka. Nota sãkire kĩpitakani auapikako. ");
INSERT INTO apuNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Aĩri Teosonoka posotari itxĩkitakiniri ikinipoko auãki inini, kotxi iuanoka auapika. Isikaposotiiretano nota apaka ikinipoko nitxĩkitakini auãki inini. ");
INSERT INTO apuNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","—Aĩri Teoso txano nota: “Kãkiti itari iaxitikiri pitxaua, ininiãkara pitxariko nisãkire mauiãkani: ‘Kona hĩte kĩpitari Teoso sãkire, ininiã kãkiti misiritikomoni hĩsa,’ pitxako. Pitxariko nisãkire auiãkani: ‘Hĩte kĩpitari Teoso sãkire ininiã uai hina Teosokata hãuini ĩkapani.’ Ikara atoko pitxariko kãkitimoni,” Teoso txano nota. ");
INSERT INTO apuNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","—Kona hĩtsorĩkaãtapeko, ikara sãkiretxiti hĩkenakotakasaaki. Ãti õti ipĩkani, katakoni, kenakotariko Teoso ãkiri akiritinina. ");
INSERT INTO apuNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Iuasaaki õkitikauanako. Ninoa erekari kamakani auapikako Teosokata. Ninoa maerekati kamakani misiritaãkako. ");
INSERT INTO apuNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","—Notanani kona nitxari kãkiti: “Pite sari kãkiti misiritikomoni. Pitepekana inari uai Teosokata pauini ĩkapani.” Notanani kona ikara atoko nitxari kãkiti. Teoso sãpiretakitinokara nitxa kãkitimoni, ininiãkara nisãkire kãkitimoni atãonoka, kotxi kona nota nirekaãkitini nikama. Niri nipaniãtakiri nirekaãkitinanira nikama —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Apikomoni Xesosi sãpirenauata: —Notaka sãpiretiniãua hĩtemoni, atxiĩti kona kauikikono. ");
INSERT INTO apuNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ãtipekana nota sãpiretakari aua. Nimarotari atão inini iua sãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Hĩte iokanatapekari himoianariakori Xoãomoni nota himarotini ĩkapani. Iua sãpiretapekana ninoa atãoene nota sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kona ninitanãtari kãkiti nisãkire atão inini sãpiretakani. Nota sãpiretai hĩte Xoão sãpiretakiti sãkiretxiti, himaerekani Teoso makatxakini ĩkapani, himapinakani tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","—Xoão tirikapi tirinakari poniãkari atoko itxa. Tirikapi iopinikari ikinipoko, tirikapi takote auakari aãtamatini ĩkapani. Iua atokokana Xoão oerekari kãkiti atão inakari. Mapaõtinokara hĩte poxokiniuata iua sãkire hĩkenakotakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","—Aua ãti nota sãpiretakari. Iua Xoão poiãoka. Ãtipekana apiata. Nota kamakitikara apiata. Nikamakiti sãpiretari nota sãkire atão inini. Nikamakiti, niri paniãtakiti kãkiti itikasaaki, imarotari niri uaimoni iokanatinino nota. ");
INSERT INTO apuNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","—Niri, nota iokanatakari kãkitimoni, iua apaka nota sãpiretakari. Kona hĩte kenakotari Teoso sãkirauatini. Kona hĩte atamatari itoõ. ");
INSERT INTO apuNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Isãkire !auari hãkixinireẽ, kotxi kona hãuikari nota sãkire iua iokanatakiti sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","—Hĩte atatsopatapikari Teoso sãkire iõkatsopatakori, hãuini ãtipirika Teosokata himarotini ĩkapani. Ia Teoso sãkire iõkatsopatakori nota sãpiretakari apaka itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Txamari kona hinirekari nisãkire hãuikini. Kona hinirekari notamoni hinini, ãtipirika Teosokata hãuini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","—!Ninitari niuikiko. ");
INSERT INTO apuNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Iteene nimarotai hĩte. Kona xapiti hĩtiretari Teoso hãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Niri iokanatano nota uaimoni. Txamari kona hĩte apakapano nota Teoso iokanatakitino. Teoso maiokanatakinitira hĩte apakapa. ");
INSERT INTO apuNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hĩte potxitari ãti iuikinii. Txamari kona hĩkamari erekari Teosonoka iuikinii ĩkapani, ininiã kona hãuikari iua sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","—Kona notani sãpiretapaniri niri hĩte maerekani. Moisesira sãpiretariko himaerekani Teosomoni. Hĩte uãkatari iua sãpiretari hĩte ereka hinini, txamari iua sãpiretariko niri himaerekani. ");
INSERT INTO apuNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisesini sãkire iõkatsopatakiti hãuikaãkamako, nota sãkire apaka hãuikamako, kotxi Moisesini nota sãpiretakari apaka. Iua iõkatsopatapekari nota sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Hĩte kona auikapiretari Moisesini iõkatsopatakiti. Isãkire iõkatsopatakiti himauikakaniã, kiãtokopa hĩtxa nota sãkire hãuikini? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Eereka ãti õti Xesosi ĩpiriãtari Kariréia poa. Ia ipoa uãka apaka Txiperíatxi poa inaãka. ");
INSERT INTO apuNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kaiãopokori kãkiti sari iua tikini, kotxi ninoa itikapekari Xesosi makananirauatini. ");
INSERT INTO apuNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Xesosi kanĩka mitaxiratarimoni. Iuaã iitopãka imoianariakorikata. ");
INSERT INTO apuNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Xoteoakori kiinirite, Páskoa inakori kiiniriti apisapanika Xesosi sari iuaãtaã. ");
INSERT INTO apuNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iitopãkasaaki, Xesosi atapari itomaneri kãkiti apokaãpotini iuamoni. Ininiã ipimaãri Piripi: —Amonipa aiamotatariko komiri nakira kãkiti asikakienatini ĩkapani? ");
INSERT INTO apuNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Xesosi ikara atoko txari Piripi, kotxi inirekari imarotiniri: “Atauako atxiĩti Piripi auikari niposotiire?” Xesosi imarotapekari iuaka ikamakiti tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ininiã Piripi apakapapireta: —Txineiropokoni, tosẽtosi txineiro ota, kona apakata komiri aamotini, nakira kãkiti asikakienatini ĩkapani. !Apakata —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Iuasaaki ãti Xesosi moianari Simão Petro itari, Ãtree inakori, txari Xesosi: ");
INSERT INTO apuNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Uai aua amarini. Auari ikiena. Sĩko komiri sevata inakori kamakori auari iua. Ipi ximaki axapitiri apaka auari iuamoni. Txamari kãkiti itomaneri sikakienatiko !apakata. Ia nipokori poiãoka —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Xesosi paniãtari imoianariakori: —Nakira hĩpaniãta iitopãkinina —itxana. Sotonaiakiperi auari iuaãtaã. Iua nopini iitopãkana. Sĩko mio apikomoni kikiakori aua. ");
INSERT INTO apuNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Xesosi kosekari komiri amarini nakiti. Iuasaakipeka imisãkiretari Teoso: —Erekapitikari ia komiri auiniua ate. Iua sikari imoianariakori. Eereka ninoa xanakari kãkiti topãkakanimoni. Iua atokokanera itxarina ximaki. Ikinikana inirekaka iaõka auana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ikinimane kamitopeka inakasaaki, ipaniãtari imoianariakori: —Itetakori komiri, ximaki pakini hãpotiita. Kona hiomatapiriko —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ininiã apotiitarina komiri itetakori. Tosi kotarina ixãpokakana komiri itetakori. ");
INSERT INTO apuNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Xesosi posotiire ninoa kãkiti itikasaaki, ninoakakarika isãkirauatana: —Atãopitikara Xesosi aiãtapanãtakitikara, Teoso sãkire sãpiretakari inakorikara ere Xesosi —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Xesosi imarotapekari ninoa nirekiniri iauĩtetinirina iua. Iua kona nirekari ninoa auĩtetiniri iua. Ninoa mamaĩkakaniri apisapanika, Xesosi sipeka iuanoka. Apikoxiti oxiratarimoni ikanĩka. ");
INSERT INTO apuNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kikatapeka imoianariakori iokiriĩta ipoa tiniã. ");
INSERT INTO apuNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Iereẽtauana kanaua ãki. Ĩpiriaãpotarina ipoa Kapanaoõ sitatxiti manapi. Ĩkanõkapeka inakasaaki kona Xesosi apokapanika ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kataparari ĩtimati apoka, ininiã tsakatipokoni. ");
INSERT INTO apuNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iuasaaki imekoãpotana. Ipixiniãpeka apokasaakina, ataparina Xesosi ipoa nopini itĩpokotini. Kanauamoni isaãpota. Ninoa pĩkarauata, kotxi ninoa uãkatari kamiri. ");
INSERT INTO apuNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Xesosi akiritana: —Notakara. Kona hĩpĩkarauatape —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ininiã apakaparina Xesosi ipoxokoniritikana. Iua morõkokaua kanauaã. Iereẽtakasaakiua, iuasaakipeka kanaua apoka imiriĩpe Kapanaoõ manapi. ");
INSERT INTO apuNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Katimatinĩkata ipiniãmoni kaikotakani nitamari Xesosi. Ninoa imarotari ãtoka kanaua mitxi iuaã auini. Oa kanaua Xesosi moianariakori anikapeka. Ninoa imarotari Xesosi kona sari imoianariakorikata. Imarotarina ninoanani sini. ");
INSERT INTO apuNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Iuasaaki kanauaniri Txiperíatxi sitatxitikini apokita Xesosi merepani Teoso misãkiretiniãtaã takote merepani komiri nikikoãtaã. ");
INSERT INTO apuNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Iuasaaki kona ninoa apokari Xesosi, imoianariakori apaka. Ininiã ninoa iereẽtaua kanaua ãki. Iuaĩkana ikanapiriãna. Ipoa ĩpiriãtana Kapanaoõ sitatxitimoni, Xesosi initinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ninoa apokari Xesosi ipoa ipiniã. —Koerekareri, namonikitapa papoka uai? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ininiã Xesosi: —Atão nisãpiretai hĩte. Hĩte nikari komiri nisikakiti. Kamitopeka hĩtxa, ininiã nipokori ĩkapaninokara hinitanãtano nota. Kona hãuikari Teoso posotiireẽ nikaminiri iua posotiiretxi. ");
INSERT INTO apuNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Xesosi pinitana: —Nipokorinoka !hĩxinikape, kotxi nipokori okanani mauakati itxaua. Hĩxinikariko ãtião nipokori, nota hĩtari iaxitikiri siãkiti, kotxi nota sikari kãkiti, kãkiti auapininiika inini tĩkane. Teoso sikari ikinika iposotiire notamoni ninirekaãkiti nikamini ĩkapani —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","—Kiãtokopa atxatari Teoso nireẽkiti akamini? —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Ianoka Teoso nirekari hĩkamini. Iua nirekari hãuikiniri iua iokanatakiti sãkire —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","—Iuaĩkana posotiiretxi apiari pikaminiã, ininiãra aãuikari Teoso iokanatakiti pininiãua. Kinakaripa posotiiretxi pikamapanika? ");
INSERT INTO apuNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Anirimaneni kitxakapirĩkarini ãparaã makipakaniãtaã auakasaakina, inikarina komiri iaxiti katxakakari. Teoso sãkire iõkatsopatakori txari: Isikari komiri Teoso tixinekiri ninoamoni, —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ininiã Xesosi: —Atão nisãpiretaiko hĩte. Kona Moisesini sikari komiri Teoso tixinekiri. Nirikara sikaãtari atão komiri iua tixinekiri kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Teoso tixine ĩkari, iua ãkiri, komiri atoko itxa, ikini itixiti auakani ĩkapani, kotxi iua sãkire auiãkani auapininiika Teosokata —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Ikiniõtika pisikaua ia komiri —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—Notakara iua komiri Teoso iokanatakiti nitxaua. Notakara sikari kãkiti auini ĩkapani. Iua nisãkire auiãkari !inatxitaika. !Iposonataika. ");
INSERT INTO apuNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","—Hĩte aõkitapekano nota, txamari kona hĩte auikapanikari nisãkire. Ikara atoko nitxapekai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Imakinika kãkiti notamoni Teoso siãkini inapitikako notamoni. “Hĩsipeka,” kona nitxana notamoni apoãkani. ");
INSERT INTO apuNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nitakanapari Teoso tixine. Ĩkorapokoriti napoka, nipaniãtakiri nirekaãkitinoka nikamini ĩkapani. Notaka nirekaãkiti na nikama. ");
INSERT INTO apuNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Niri nipaniãtakiri !inirekari ãtika kãkiti notamoni isiãkini ereẽkokini. Itixi xipokini õtisaaki, inirekari nota õkitikinina ninoa auapininiika inini tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Iua nipaniãtakiri nirekari nota imarotakani, nisãkire auiãkani, auapininiika inini. Itixi xipokini õtisaaki nõkitikana ninoa iuaĩkana auãki inini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ninoa Xoteoakori kona apokaerekatari Xesosi sãkire, kotxi iua txari: “Nota iua komiri Teoso tixine ĩkari komiriti nitxaua,” ininiã ninoa tsoata. ");
INSERT INTO apuNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ininiã ninoa: —Iua kiki Xesosi Xosee ãkiri. Aaõkitapekari iri, inoro pakini. Kinirepa “Teoso tixine ĩkarirano” itxape iua? —itxana, itsoatinina. ");
INSERT INTO apuNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ininiã Xesosi txana: —Kona himaxirauatape. Kona hĩtsoatape. ");
INSERT INTO apuNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Niri nipaniãtakiri akiritakitinanira posotari inini notamoni. Niri makiritakiniti kona posota inini notamoni. Itixi xipokini õtisaaki nõkitikana notamoni apoãkani iuaĩkana auinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kitxakapirĩka Teoso sãkire sãpiretakani iõkatsopatari ia Teoso sãkire: Teosorako oerekariko ikinipoko kãkiti. Niri sãkire kĩpitakani, niri oereẽkini, apoka notamoni. ");
INSERT INTO apuNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kona aua kãkiti niri atamatakari. Nota Teoso tixine ĩkari, notanokara atamatapekari niri. ");
INSERT INTO apuNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","—Nota sãkire auiãkari, iuara auapininiika Teosokata. Ia nisãkire atão. ");
INSERT INTO apuNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nota iua komiri nitxaua kãkiti auapininiika inĩkitakakarino. ");
INSERT INTO apuNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Hinirimane kitxakapirĩkarini nikari komiri iaxiti katxaãkari ãparaã makipakaniãtaã. Iaxiti katxaãkari inikanimana, txanima ipĩpena. ");
INSERT INTO apuNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kãkiti nikiniãri atão komiri Teoso tixine ĩkari kona ipina. ");
INSERT INTO apuNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iua komiri, Teoso tixine ĩkari nitxaua nota. Kãkiti auapininiika inĩkitakakarino nota. Ia komiri niãkari auapininiika itxako. Ia komiri nisikakiti ia niĩtokara. Niĩto nisika kãkiti ikini itixiti auakani auapininiika inini tĩkane —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ikara atoko ininiã ninoa Xoteoakori taparakienatakakaua: —Natokopa itxa ia kiki iĩto isikiniua ate, anikiniri ĩkapani? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ininiã Xesosi: —Atãoenepitikara ikara atoko nitxai hĩte. Hĩtari iaxitikiri ĩto himanikakanisaaki, iarẽka himiãtakanisaaki, kona hĩxinire auapani ãtipirika. ");
INSERT INTO apuNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Iua niĩto niãkari, niarẽka iãtakari, auapikako Teosokata. Xipokatxi õtisaaki nõkitikariko iua iuaĩkana auini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Niĩto atão komiri itxaua. Niarẽka atão iãriã itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Niĩto niãkari, niarẽka iãtakari, aua nãkixinireẽ. Nota aua iua ãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Niri, ãtipirika auapika inakari, iokanatano nota ĩkorapokoriti. Iuara sikano nota ãtipirika nauini ĩkapani. Iua atokotxikana nota sikari nota niãkari ãtipirika auini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nota iua komiri Teoso tixine ĩkari nitxaua. Komiri hĩkiomaneakorini nikakiti ãtião. Iua komiri nikakari ipĩpe. Nota siãkiti komiriti niãkani, nisãkire auiãkani auapininiika Teosokata itxanako. ");
INSERT INTO apuNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ikara atoko itxa Xesosi sãkire aiko ãki Xoteo apotiitiniãtaãua Kapanaoõ sitatxiti oerekarauatakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Xesosikata sikani isãkire potxitakani, ikara isãkire ikenakotakasaakina, ipimarauatakakana: —Pamimari ikara isãkire. Kipa imarotari ikara atoko inakari sãkiretxiti? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Masãpiretakotika Xesosi imarotari ikara atoko itsoatinina. Ininiã iua: —Hinirekatari hĩtakanapinino nota ia nisãkire xika? ");
INSERT INTO apuNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kiãtokopa hĩxinikakiti hĩtikiniãno nota hĩtari iaxitikirino kanĩkini mitxi nauiniãtaã? Atxiĩti iuasaaki hãuikatari nisãkire? ");
INSERT INTO apuNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Iua Erekari Matamatakotinokara sikari kãkiti auini tĩkane. Kãkiti ĩto tapara !auari. Ikara sãkiretxi hĩtemoni nisãpiretakiti, iua Erekari Matamatakoti sãkiretxikana. Nisãkire auikiko auãkitakari kãkiti, ãtipirika Teosokata auini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Txamari auapitika hĩte sauaki nisãkire mauiãkani —itxa Xesosi. Merepitipanika Xesosi imarotapekari iua sãkire mauiãkani tĩkane. Xesosi imarotari apaka imĩkapiritakiri tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","—Niri Teoso masikaposotiiretakiniti kona iposota apokini notamoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ikara isãkire xika itori Xesosikata sikani takanapari iua. Kona inirekaikarina iuakata isinina. ");
INSERT INTO apuNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ininiã Xesosi pimaãna imoianariakori tosi: —Hĩtepekana, hĩte apaka nirekatari hĩtakanapinino? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ininiã Simão Petro apakapapiretari: —Apiananiri, kirimonipa asa atxiĩti? Pitenanira sãpiretari kãkiti auapininiika inini. ");
INSERT INTO apuNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ate imarotari Teoso mereẽkiti pininiua. Teoso ãkiri, auapika inakari ãkiri pitxaua pite —Petro txari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ininiã Xesosi: —Nota mereẽi hĩte tosi kikiakori. Txamari hĩte sauaki aua Satanasi nitiri —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iuasaaki Xesosi xinikari Xotasi Isikariotxi inakori, Simão inakori ãkiri. Xesosi moianarikamara iua, txamari imĩkapiritariko Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Eereka Xesosi kaikotapanika Kariréia tõpa. Kona Xotéia tõpa !ikaikota iuasaaki, kotxi iuaã Xoteo auĩteakori nirekari okiniri. ");
INSERT INTO apuNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Iuasaaki Xoteo kiinirite Papiri inakori kaiama atokopekari. ");
INSERT INTO apuNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ininiã Xesosi itariakori misãkiretari iua: —Posipika uai. Pisãkire auiãkanimoni Xotéia auakanimoni pisa. Ninoa apaka nirekari itikiniri pikamakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kãkiti nirekiniãri iteene imarotaãka, !ikipatari ikamakiti. Pite kamanãtari posotiiretxi uai Kariréia tõpa. Pisa Xotéiamoni. Iuaã poerekari piposotiire ikinimane imarotinii ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ikara atoko itxarina Xesosi, kotxi itariakori apaka iuasaaki kona auikapanikari isãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ininiã Xesosi apakapapiretana: —Iuaã nisini keto kona apokapanika. Apakata ikiniõtika Xotéia tõpamoni hĩte sini, ");
INSERT INTO apuNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","kotxi kãkiti !omanatai hĩte. Notananira omanataãka, kotxi nisãpiretari maerekati kãkiti kamakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Erekari hĩte sini kiinirimoni. Kona nota sapani uatxa. Nisini manapi apokasaaki nisa —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Itariakorimoni ikara inaka atoko, ikaikotapanika Kariréia tõpa. ");
INSERT INTO apuNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Itariakori kiinirimoni ĩkiikapeka. Ninoa tikinimoni isa Xesosi. Iuasaaki !kasãpirenari kiinirimoni isini tĩkane. Ininiã kãkiti mimarotakinitika isa. ");
INSERT INTO apuNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Xoteo auĩteakori nitapiimari Xesosi kiinirisaaki. Ipimaãri kãkiti: —Ĩtapari Xesosi? ");
INSERT INTO apuNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kãkiti iuaã auakani sãkirauata Xesosi pirena. Apanakini txari: —Peerekari Xesosi. Apanakinipekana: —Kona erekari. Imisirienetari kãkiti —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kona kãkiti sãkirauata Xesosi uãka Xoteo auĩteakori takote, kotxi ipĩkana. ");
INSERT INTO apuNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mapaõtinoka kiiniri xipokini apisapanika, Xesosi sari Xotéia tõpamoni. Isari Teoso misãkiretiko aikotimoni. Iuaã oerekarauata. ");
INSERT INTO apuNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Xoteoakori tsorĩkaãnãta Xesosi sãkire ikenakotakasaakina: —Kininiãpa ere kiki paimatireri. Kona apaiaõkarauata —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ininiã Xesosi apakapapiretana: —Na nota imaroreni noerekai hĩte. Iua niokanatakiri imarorera noerekai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kãkiti Teoso nirekaãkiti nirekaãkani imarotari noerekiniri Teoso imarorenoka. Ninoa imarotari nimoerekakaniri notaka nimarore. ");
INSERT INTO apuNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kãkiti iuaka isãkire sãpiretakari nirekari apanakini iuikiniri iua. Kãkiti Teoso sãkirenoka sãpiretakari nirekari iuikiniri Teoso ipaniãtakiri. Ikara atoko inakari kãkiti sãkire atãonoka. !Ikamari maerekati. ");
INSERT INTO apuNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisesini oerekai hĩte Teoso sãkire, ipaniãtakiti iõkatsopatakori. Txamari kona hĩte kamari Teoso paniãtakiti. Kona ãtika hĩte kamari ipaniãtakiti, kotxi hinirekari hõkinino nota —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ininiã ninoa apakapapiretari: —Maerekati matamatakoti auaĩtotai pite. Kiripa kinirão okaka txai pite? Iua maerekati matamatakoti xika ikara atoko pitxa pisãkire —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ininiã Xesosi: —Nota kamari posotiiretxi tomatikoõtxitisaaki, iua kiki matĩpokotakati nimakananitakasaaki, ininiãkara hĩte tsorĩkaãta. Hĩuãkatari niparĩkauatini. ");
INSERT INTO apuNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Txamari hĩte apaka parĩkauata tomatiko õtisaaki, kotxi hĩkamari Teoso takaõtxikare hamarite ĩtoã tomatiko õtisaaki. Moisesini paniãtai Teoso takaõtxikare hĩkamini hamarite ĩtoã oito õti iua auakasaaki. Ari hinirimane kitxakapirĩkarini, Moisesini apisapanika, oerekapekari ikara atoko inakari hĩkamini. ");
INSERT INTO apuNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ininiã hĩte kamari Moisesi paniãtakiti tomatikoõtxitisaaki. Ikara atoko ininiã, kinirepa hĩte omanatano nota, iua kiki erekapeka nitxĩkitakini xika tomatikoõtxitisaaki? ");
INSERT INTO apuNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Iteene pimimarotakanisaakiri ãti kamakiti, kona pakiritapiri: “Iua kamari maerekati,” kona pitxape. !Papoĩtapiri ãti. Atão inakarinoka pinita, atão pimarotini ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Apanakini kãkiti Xerosareẽ auakani txanãtari: —Ere kikikani ninoa kinirão okaenetakitikani? ");
INSERT INTO apuNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hãtamatari. Iua sãkirauanãta kãkiti apisatoõ. Kona kapĩkareri iua. Auĩtetxiakori !kasãkirena. Atauako aãuĩteakori auikatari isãkire atxiĩti? Atxiĩti auikatarina Xesosi Teoso mereẽkiti aiãtapanãtakiti ininiãua? ");
INSERT INTO apuNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Atão Teoso mereẽkiti aiãtapanãtakiti apokasaaki, kona kimarotikori iua ininimoni. Ate amakinika imarotapitikari iua Xesosi ininimoni. Kariréiakiri iua, ininiã Xesosi Teoso mereẽkiti aiãtapakiti !itxaua —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Teoso misãkiretiko aikotiã Xesosi oerekarauanãtakasaaki, itaparasãkireritika ipimaãna kãkiti iuaã auakani: —Atauako hĩte imarotatano nota? Atauako himarotatari nota ininimoni? Kona notaka iokanataua kãkitimoni. Niokanataãka. Nota paniãtakari atãonoka isãkire. Kona hĩte imarotari iua. ");
INSERT INTO apuNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nota imarotari iua, kotxi iua auiniãtaãkirikarano nota. Iuara iokanatano kãkitimoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iuasaaki auĩtetxiakori nirekamari imaĩkinirina. Kona kamaĩkikori, kotxi imaĩkiko manapi kona apokapanika. ");
INSERT INTO apuNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ninoa auĩtetxiakori kona auikari Xesosi sãkire, iuaritika itomaneri kãkiti auikari Xesosi Teoso mereẽkiti kãkiti iãtapakiti ininiua. —Iua kiki inipitikara Teoso mereẽkiti aiãtapakiti itxaua, kotxi ãti posotiiretxi apiari kamakari !auari —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pariseoakori kenakotakasaakiri kãkiti sãkire ikara atoko inakari, ninoa, sasetotxi auĩteakori pakini iokanatari sotatoakori Xesosi imaĩkinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sotatoakori apokasaaki iuamoni, Xesosi txari kãkiti iuaãtaã: —Mapaõtinoka hĩtekata nauako. Eereka nisa nipaniãtakirimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hinitapiikamano, !hãpokapanino. Nisinimoni kona hĩte posotari hĩsini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Auĩtetxiakori ninoakakarika isãkirauatana: —Amonipa isa atxiĩti, ate mapokakaniãri iua? Atauako õtakoxiti isatako Xoteoakori iarikakanimoni, ãti uãka sauaki Xoteoakorimoni? Atauako oerekatari Xoteo minakaniua? ");
INSERT INTO apuNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kotxi iua sãkire: “Hinitanoko. !Hãpokano nota. Kona hĩte posotari nota sinimoni hĩsini,” itxa sãkireta. Ate !imarotari isãkire —itxanãtakakana. ");
INSERT INTO apuNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kiiniri mapotõkire õti apiapoxokonita. Iua õti Xesosi tima kãkiti sauaki. Itaparasãkireritika isãpirenauata ikinimane kenakotiniri ĩkapani: —Piposonatakasaaki, notamoni pinako piãtini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Teoso sãkire iõkatsopatakori txari: Nota sãkire auiãkari ãkixinireẽ aua amomo atoko inakari. Iua ãparaã txĩkitakari kãkiti auãki inini. —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iua Erekari Matamatakoti amomo atoko itxa. Xesosi sãkire auiãkari apakapariko iua Erekari Matamatakoti. Iuasaaki Xesosi sãkirauatakasaaki, iua Erekari Matamatakoti kona siãkapanika kãkitimoni, kotxi Xesosi kona kanapiriãpanika Teoso tixinemoni. ");
INSERT INTO apuNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ikara Xesosi sãkire ikenakotakasaaki itori kãkiti txari: —Atãopitikara ikira kiki Teoso sãkire sãpiretakari aiãtapakiti itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Apanakini txari: —Iua Teoso mereẽkiti aiãtapakiti itxaua. Apanakinipekana: —Teoso mereẽkiti aiãtapakiti, Kariréiakiri !itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Teoso sãkire iõkatsopatakori sãpiretari Teoso mereẽkiti aiãtapakiti, Taviini apika mekaniri itxaua. Iua iponaniãko Pereẽ sitatxiti Taviini auiniãtaã —itxana. Ikara atoko itxanãtana, kotxi kona imarotarina Xesosi iponaniiniãtaã Pereẽ sitatxiti. ");
INSERT INTO apuNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Iuasaaki apanakini auikari Xesosi sãkire. Apanakinipekana !auikari Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Apanakini nirekamari imaĩkiniri Xesosi iuasaaki, iuaritika iua maĩkakari !auari. ");
INSERT INTO apuNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ininiã sotatoakori kanapiriã sasetotxi auĩteakorimoni, pariseoakori pakinimoni. Ininiã ipimaãna: —Kinirepa kona himinari Xesosi uaimoni? ");
INSERT INTO apuNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Apia imatiresãkireta iua. !Auari kãkiti iua atoko ina sãkiretakari, ininiãkara !apakata amaĩkiniri iua —itxana sotatoakori. ");
INSERT INTO apuNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ininiã pariseoakori omanãkarauata. —Atauako iua misirienetai hĩte apaka? Iua txĩkitakai hĩte isãkire hãuikini. ");
INSERT INTO apuNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","!Auari auĩtetxi iua sãkire auiãkari. !Auari pariseo iua sãkire auiãkari. ");
INSERT INTO apuNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kãkiti miĩkitetinanira auikari Xesosi sãkire. Xesosi sãkire auiãkari kona imarotari Moisesini paniãtakiti. Ininiãkara Teoso misiritanako ninoa —itxa pariseoakori sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Iuasaaki Nikotemo inakori iuaãtaã aua. Pariseo itxaua. Iua õti apisapanika iuara sari Xesosimoni ĩkanõka imisãkiretiniri ĩkapani. Ninoa ikara atoko isãkirauatakasaaki, Nikotemo misãkiretana ninoa: ");
INSERT INTO apuNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Kãkiti kamakiti isãpiretini apisapanika, “maerekati ikamakiti,” kona hĩtxape. Ikara atoko itxa Moisesini oerekasaakiua ate —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ininiã ninoa pariseoakori: —Atxiĩti pite Kariréiakirikai apaka, Xesosi atoko? Iteene patatsopatariko Teoso sãkire iõkatsopatakori. Iua iteene patatsopatakasaaki, iuasaakiikarako pimarotariko !auari Teoso sãkire sãpiretakari, Kariréia tõpakiri —itxarina iua. ");
INSERT INTO apuNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Eereka ikinimane sari aapokomonina. ");
INSERT INTO apuNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Iuasaaki Xesosi sari Orivanape Xiratamoni. Oriva txipokori. ");
INSERT INTO apuNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Katimatinĩkata ikanapiriã Teoso misãkiretiko aikotimoni. Iuasaaki ikinipoko kãkiti apotiitaua iuamoni. Ininiã Xesosi topãka, Teoso sãkire isãpiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Iuasaaki kaiõkatsopareriakori, pariseoakori pakini minaro sito iuamoni. Ninoa apokaro oa sito õtaniri minakotikatika osirĩkini. Itakarona oa ikinimane apisatoõ. ");
INSERT INTO apuNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","—Koerekareri, aãpokaro oia sito õtaniri minakotikatika osirĩkini. ");
INSERT INTO apuNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisesini sãkire iõkatsopatakori paniãtaua ikara atoko inakaro kai soroã oõkaãka. Pitepekana, kiãtokopa atxataro oa? —itxana Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ikara atoko ipimaãrina Xesosi, kotxi inirekarina Xesosi kerokiniri isãkire. Inirekarina Moisesini paniãtakiti iaõka imakamakaniã, ininiã maerekati ikamapeka. Txamari !kasãkireri Xesosi. Iokirita, iõkata itxari kipatxi iuakokiã. Imakenakotakiniti atoko itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ipimarauatapanikana, ininiã Xesosi õkaõkitaua. —Maerekati makamakatirako ĩkiika kiporonakiniro aroa kai soroã —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Eereka Xesosi iuaĩkana iokirita, iõkata itxari kipatxi. ");
INSERT INTO apuNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ninoa ikaraene ikenakotakasaakina, iua apiata kiomãtxi inakariua sipeka. Eereka iua tikini auakari apaka sipeka. Ikara atoko itxaãpotana ikinikana isinina. Eereka Xesosinoka kaikota oa sitokata. ");
INSERT INTO apuNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Xesosi õkaõkitaua, atamata itxaro oa sito. Oanoka kaikota iuaã. —Ĩtapari pimaerekani sãpiretakani? —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Apiananiri, isipekana nimaerekani sãpiretakani —otxari. —Nota apaka kona sãpiretari pimaerekani. Pisipeka. Maerekati kona pikamapinikako —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Eereka Xesosi iuaĩkana oerekari kãkiti. —Nota ikini itixiti auakani tirikapite atoko nitxaua, kotxi noerekari Teoso sãkire notakata sikani. Teoso mimarotakani ipiaã sikani itxauana. Notakata sikanipekana !itĩpokota ipiaã. Nota sikana ninoa ãtipirika auinina ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ininiã pariseoakori misãkiretari Xesosi: —Kona ate auikapiretari pisãkire, kotxi pitenani sãpiretari pisãkire. Ikara atoko ininiã, kona aimarotari atãoene inini pisãkire. Ãti sãpiretiniãri pite sãkire iaõka, aãuikari atxiĩti —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ininiã Xesosi: —Nota sãkirekara ikara atoko nitxai hĩte, iuaritika atãoenekara ikara atoko nitxai hĩte, kotxi nota imarotari nininimoni, nimarotari nisinimoni. Kona hĩte imarotari nota ininimoni. Kona hĩte imarotari nota sinimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kãkiti hĩtxaua, ininiã hãpoĩrauata, kotxi !himarotari atão. Kona nota txari kãkitimoni: “Pite, peerekai pite. Pitepekana, !erekai pite.” !Ikara atoko !nitxari kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Iuaritika nisãpiretakasaakiri kãkiti kamakiti, atãonoka nitxa nisãkire, kotxi kona notananini sãpirenauata. Niri niokanatakiri sãpiretakititxikana nisãpireta. ");
INSERT INTO apuNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kitxakapirĩka hĩteka kiomaneakorini sãkire iõkatsopatakori txari: Kãkiti itikakititxikana ãti itikakiti. Ninoa ipi sãkire ãtinoka auiniã, ininiã ninoa sãkire atãonoka itxa, itxa hĩkiomane sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nota sãpiretari nota pirena. Niri niokanatakiri apaka sãpiretari nota pirena nisãkiretxikana, ininiã ipi auape —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—Naniparari piri? —itxarina. —Kona himarotano nota. Niri apaka kona himarota. Nota himarotaãkamako, niri apaka himarotamako. ");
INSERT INTO apuNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ikara atoko Xesosi sãkirauata. Txineiro Teoso ĩkapani sikikoãtaã takote Xesosi oerekarauata Teoso misãkiretiko aikotiã. Xesosi ikara atoko isãpirenauata, iuaritika kona kamaĩkikori, kotxi imaĩkiko manapi kona apokapanika. ");
INSERT INTO apuNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iuaĩkana Xesosi misãkiretari kãkiti: —Nisipiriko. Eereka hinitapiimano. Nota sinimoni !hãuiritaãka hĩsini. Hĩpinakasaaki, himaerekanikatika hĩpinako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Xoteo auĩteakori napetari: —Atauako iuaka okatauako? Kotxi iua txari: “Nota sinimoni kona hãuiritaãka hĩsini” —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iuaĩkana Xesosi sãkirauata ninoamoni: —Ĩkoraxitikinirai hĩte. Nota itanokiri. Hĩte ĩkora itixikinirai hĩte. !Ĩkoraxitikirino nota. ");
INSERT INTO apuNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ikara atoko ininiãkara, nota txai hĩte: “Hĩpinakasaaki himaerekanikatika hĩpinako,” nitxai. Himauikakanisaakiri nisãkire nota pirena, hĩpinakasaaki himaerekanikatika hĩpinako. Kona Teoso makatxakinii himaerekani —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—Kiriparai pite? —itxarina Xesosi. —Merepitipanika nisãpiretakitikara iuakarano nota. ");
INSERT INTO apuNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nisãpiretakiti tĩkane hĩte maerekani nisãpiretini tĩkane kaiãopokori. Nota iokanatakari atãoenenokara isãkire. Iua sãpiretakitinokara nisãpiretari kãkiti itixi auakani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ninoa !imarotari Xesosi iokanatakari aĩri Teoso. ");
INSERT INTO apuNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ininiã Xesosi txana: —Nota hĩtari iaxitikiri hõkasaaki, niĩto itano hõkitikasaaki, iuasaakiikarako himarotano kinakaripa nota. Iuasaaki himarotariko notaka sãkire !nisãpireta. Niri oereẽkitinokara nisãpireta. ");
INSERT INTO apuNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iua niokanatakiri notakata aua. Niri !itakanapano nota, kotxi inireẽkitinoka nikama —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Xesosi ikara atoko ina sãkiretakasaaki, itomaneri kãkiti auikari isãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ininiã Xesosi sãkirauata Xoteoakorimoni iua sãkire auiãkanimoni. —Nisãkire iaõka hĩkamakasaaki, atão nimoianariakori hĩtxauako. ");
INSERT INTO apuNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Atão nimoianariakori hinakasaakiua, himarotari atãonoka inakari. Atãonoka inakari himarotakasaaki, õpoĩkakoni atoko hĩtxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ninoa apakapapireta: —Apraãoni apika mekanirireua ate, ininiã anirekinimoni asa. Nitiritxi iamotakoni !atxaua. Kinirepa õpoĩkakoni atoko pitxĩkitakaua? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ininiã Xesosi: —Atãonoka nitxai hĩte. Maerekanitxi nitiri atoko itxa kãkiti maerekati kamakari. ");
INSERT INTO apuNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nitiritxi iamotakori ãtipirika !auari ipatrãote aapoko. Patrão ãkiri auapika ãtipirika iri aapoko. ");
INSERT INTO apuNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nota Teoso ãkiri txĩkitakasaakiri kãkiti õpoĩkakori atoko ininiua, maerekanitxi nitiri !itxaikauako. Iuasaaki iposotari erekari ikamini. ");
INSERT INTO apuNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","—Nimarotari Apraãoni apika mekaniriakori hininiua, txamari hinirekari hõkinino. Nisãkire himauiãkani xika hinirekari hõkinino. ");
INSERT INTO apuNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nota sãpiretai hĩte nota iri oerekakiti. Hĩte kamari hĩte iri paniãtakiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Apraãoni ate iri —itxana ninoa. Ininiã Xesosi: —Apraãoni apika mekaniriakori hininiãua, Apraãoni kamakiti atoko hĩkamamako. ");
INSERT INTO apuNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Atãonoka nisãpiretai hĩte. Teoso sãpiretakitinokara nisãpiretai, iuaritika hinirekari hõkinino. Apraãoni !ikamari ikara atoko inakari. ");
INSERT INTO apuNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Hĩte kamari hĩte iri kamakiti atoko inakari —itxa Xesosi. —Teosonanira ate iri. Ate atãopitika iua anaakori atxaua —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","—Teoso atão hĩri ininiãua, nota hĩtiretamako, kotxi Teoso auiniãtaã nota ina uaimoni. Kona notaka iokanataua. Teosora iokanatano nota uaimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kininiãpa !hiĩkitetatari ikara atoko nininii? !Himarotari nisãkire, kotxi kona xatiki hinirekari nisãkire iaõka hĩkamini. ");
INSERT INTO apuNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Satanasira hĩri. Hĩte nirekari maerekati, Satanasi nireẽkiti iaõka hĩkamini. Kitxakapirĩka itixi kamiko atokopanika kokaniri itxaua Satanasi. Iua !inirekari atãoene isãpiretini. !Iposotari atãoene isãpiretini. Aãpirenanokara iua imarota, kotxi aãpirenaãri itxaua iua. Aãpirenaãri iri itxaua iua Satanasi. ");
INSERT INTO apuNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nisãkire atão, ininiãkara hĩte !auikari nisãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hĩte ãtika itikatari maerekati nikamini? Ãtika !itikari maerekati nikamini, kotxi kona maerekati kona nikama. Ininiã kinirepa kona hĩte auikari nisãkire? ");
INSERT INTO apuNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Teoso anaakori kĩpitari iua sãkire. Hĩte kona kĩpitari iua sãkire, kotxi iua anaakori !hĩtxaua hĩte —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ininiã Xoteoakori txari Xesosi: —Ate sãkire atão. Samariakiri pitxaua pite. Maerekati Matamatakoti auaĩtotai pite —itxana. Ninoa akiriuãkatari Xesosi “Samariakiri,” kotxi Xoteoakori omanatana Samariakini. ");
INSERT INTO apuNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ininiã Xesosi: —Maerekati Matamatakoti kona auaĩtotano nota. Nota paxitari niri, txamari hĩte kona paxitano nota. ");
INSERT INTO apuNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kona notani nitari kãkiti nota iuikakani tĩkane. Nirira nirekari kãkiti iuikinino nota. Nirira imarotari nisãkire atãonoka inini. ");
INSERT INTO apuNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nota sãkire iaõka kamakari !ipina. Ikara atãoene. ");
INSERT INTO apuNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Xoteoakori apakapapiretari: —Uatxa aimarotari maerekati matamatakoti auaĩtotai pite, kotxi Apraãoni ipĩpe. Teoso sãkire sãpiretakanini apaka ipĩpe. Kinirepa pite sãkire: “Nota sãkire iaõka kamakari !ipina,” pitxa? ");
INSERT INTO apuNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Aĩrini Apraãoni ipĩpe. Pite apiata atxiĩti? Teoso sãkire sãpiretakanini apaka ipĩpe. Kiriparai pite? —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ininiã Xesosi: —Notaka niuikiniua !apakata. Nirira iuikano nota. Hĩte sãkire: “Ateosone iua,” txamari nota irira iua. ");
INSERT INTO apuNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kona himarotari Teoso. Notananira imarotari Teoso. Nota “kona Teoso nimarota,” nininiã, hĩte atokokamarako nitxamako. Aãpirenaãri nitxamauako. Nota imarotapitikari iua. Nota kĩpitari isãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Hĩri Apraão poxokoniuata, nota uai apokini ikenakoenetakasaaki. Iua itikari nota uai apokini, ininiã iua poxokoniuata. ");
INSERT INTO apuNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ininiã ninoa Xoteoakori: —Pite sĩkoẽta anokanani !apokapanika, iuaritika paõkitatari Apraão? Paxirari pisãkire —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Apraão apisapanikara nota aua. Ikara atãoene nitxai hĩte —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ikara isãkire ikenakotakasaakina, ikosekarina kai soro Xesosi ikiporonakinina ĩkapani, okinina ĩkapani. Xesosi kipataua. Osipikari Teoso misãkiretiko aikoti. Inapaãpota ninoa sauaki. ");
INSERT INTO apuNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Xesosi tĩpokotakasaaki, itikari mõsiãreti. Iua ponaniãkasaaki, mõsiãreti itxapekaua. ");
INSERT INTO apuNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Xesosi moianariakori pimaãri iua: —Koerekareri, kiripa kamari maerekati iua mõsiãreti inini? Iuakani? Irikani? Inorokani? ");
INSERT INTO apuNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ininiã Xesosi: —Kona iua maerekani xikani mõsiãreti itxaua. Kona iri maerekani xikani, kona inoro maerekani xikani mõsiãreti itxaua. Kona maerekanitxi xikani mõsiãreti itxaua. Iua mõsiãreti Teoso posotiire kãkiti imarotini ĩkapanira. ");
INSERT INTO apuNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kãkiti parĩkauata pokamara. Mapiãpeka inakasaaki, kona kãkiti posotaikari iparĩkauatini. Iua atokokana akamariko niokanatakiri paniãtakiti aãuapanika anakasaaki. Apinaka atoko kona akamaikari Teoso paniãtakiti ĩkorapokoriti. ");
INSERT INTO apuNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ĩkorapokoriti nauakasaaki, niopinikana ikinimane ãkixinire Teoso imarotinina ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ikara inaãka atoko ienemaã ixiti oakaka Xesosi. Ikamari ãkape, minapa itxari mõsiãreti oki nopini. ");
INSERT INTO apuNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Iokanatari: —Parokari poki Siroee poamoni —itxari mõsiãreti. Iuaã auari ipoa xapitikiri kãkiti kamakiti. Iua ipoa uãka “Siroee.” Iua uãkatxikana “Iokanatakori” itxaua. Iua sari Siroeemoni. Arokatoõtaua. Iuasaakipeka kõsiãrepeka itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aapoko takote auakani, kãkiti mitxi mõsiãreti itikakani pakini, ninoa misãkiretakakaua: —Ikira kiki mitxi iitopãkanãtapika inakarikani, kãkiti txineirote amanaãnãtapika inakarikani, ikira kiki? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Apanakini apakapapiretari: —Ari, iuapitikara. Apanakinipekana apakapapiretari: —Kona. Kona iuani. Ãti kiki iua mõsiãreti atoko inakarira. Iua mitxi mõsiãreti apakapapiretari: —Ari, iuapitikarano nota —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ininiã ninoa: —Kiãtokopa pitxa uatxa kõsiãrepeka pitxapeka? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Iua Xesosi inakori kamari ãkape, nokiã minapa itxari. Ipaniãtano: “Ãparaã Siroee inakorimoni pisa. Iuaã parokatoõtaua,” itxano nota. Ininiã nisa. Narokatoõtaua. Iuasaakipeka nota kõsiãrepekano —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—Namoniparari iua? —itxarina. —A, meta —itxa iua mitxi mõsiãreti. ");
INSERT INTO apuNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ninoa anikari iua mitxi mõsiãreti pariseoakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Iua õti Xesosi kamakasaakiri ãkape mõsiãreti kõsiãrepeka inĩkitakini ĩkapani tomatiko õtisaaki iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ninoa anikasaakiri iua mitxi mõsiãreti inakari pariseoakorimoni, pariseoakori apaka pimaãri iua: —Kininiãpa uatxa kõsiãrepeka pitxa? —itxana. —Ãkapeẽra noki nopini iminapa. Eereka narokatoõtaua. Uatxa kõsiãrepeka nitxa —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pariseoakori ãtikaka txari: —Iua kiki, ãkape mõsiãreti oki nopini minapakari, kona iua kamari Teoso paniãtakiti, kotxi iparĩkauata tomatiko õtisaaki. !Apakata ikamakiti. Pariseoakori ãtikakapekana sãkirauata: —Maerekati kamakari kona kamari ikara atoko inakari posotiiretxi, mõsiãreti kõsiãrepeka inĩkitakini. Ininiã pariseoakori taparakienatakakaua ikara xika. ");
INSERT INTO apuNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Iuaĩkana pariseoakori misãkiretari iua kiki: —Kiãtokopa inakaripa iua kiki pite makananitakari? —itxarina iua. —Teoso sãkire sãpiretakari itxaua iua. ");
INSERT INTO apuNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Xoteo auĩteakori kona auikari isãkire, mitxi mõsiãreti eereka kõsiãrepeka inakari sãkire. Ininiã ninoa akiritari iri, inoro pakini. ");
INSERT INTO apuNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—Hĩte sãkire hamarite auakasaaki mõsiãreti itxapekaua. Hamaritekani ere? Kiãtokopa uatxa kõsiãrepeka itxa? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Ari, ate ãkiripitikara. Iponaniãkasaaki, mõsiãretipeka itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kona ate imarotari kiriãpareuako uatxa kõsiãrepeka itxa. Kona ate imarotari kiriuako kamari kõsiãrepeka inini. Hĩpimaãri iua, kotxi mitapekari iua. Iuaka apakapapiretai hĩte —iri, inoro pakini txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iri, inoro pakini ikara atoko itxana Xoteo auĩteakori ipĩkinina xika. Xoteo auĩteakori sãpiretapekari kãkiti: “Kãkiti Xesosi sãkire auiãkani, Teoso mereẽkiti ininiua auiãkani, kãkiti iãtapakiti ininiua auiãkani, kona auiritaãkaikana ĩroinina aiko Xoteo apotiitiniãtaãua.” ");
INSERT INTO apuNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ininiã pĩkaretxi xika iri, inoro pakini txari: “Hĩpimaãri iua. Mitapekari iua,” itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ininiã iuaĩkana pariseoakori akiritari iua kiki mitxi mõsiãreti inakari. —Atãonanira pisãpiretako Teoso apisatoõ. Ate imarotari maerekatinoka ikamini Xesosi, kotxi imakananirauata tomatiko õtisaaki —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ininiã iua: —Kona nimarotari maerekati ikamini. Kona nimarotari erekari ikamini. Mitxipeka mõsiãreti nitxaua. Uatxa kõsiãrepeka nitxaua. Ikaranoka nimarota —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—Kiãtokopa itxai kõsiãrepeka inĩkitakiniãi? ");
INSERT INTO apuNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Iua mitxi mõsiãreti inakari apakapapiretari: —Nisãpiretapekai hĩte mixikanani, txamari !hãuikari nisãkire. Kinirepa hinirekatari iuaĩkana nisãpiretinii? Atauako hĩte apaka nirekari iua sãkire hãuikini? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ininiã itxitarina: —Pitera auikari iua sãkire. Ate auikari Moisesini sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Aimarotari Teoso misãkiretari Moisesini. Iua Xesosi kamari maerekati. !Aimarotari amonikiripa iua ina —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Iua kiki apakapapiretari: —Anekani. Kona hĩte imarotari amonikiriuako iua ina. Iuara kamaõsiãretano nota. ");
INSERT INTO apuNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Teoso kona maãkatari maerekati kamakari amanaãkiti. Teoso teosonetakani amanaãkiti imaãkatapitika. Iua nirekaãkiti kamakari amanaãkiti imaãkatapitika. ");
INSERT INTO apuNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mitxipeka mõsiãreti kõsiãrepeka inĩkitaãkari kona auari. Itixi kamikosaakipanika !auari kõsiãrepeka inĩkitaãkari. Uatxaikara auape. ");
INSERT INTO apuNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Xesosi Teoso iokanatakiti iminakanimauako, !ikamamariko posotiiretxi —itxa iua. ");
INSERT INTO apuNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ininiã pariseoakori: —Pite maerekatipeka auakarikai. Ãtipirika pite kamari maerekati. Maerekatinoka piĩkiteta. Iuaritika pinirekatari ate poerekini? Konapitini. Kona ate nirekari ikara pisãkire. Pisipiniikaua. Kona uai pikanapiripinika. Ate kona nirekari pite uai kãkiti apotiitiniãtaãua aikoti pinini —ninoa txari iua. Ininiã aiko porikiti iokanatarina. ");
INSERT INTO apuNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Xesosi kenakopiretari iporikiti iokanatiko mitxi mõsiãreti inakari, ininiã Xesosi nitari iua. Apokasaakiri, itxari: —Atauako pauikatari Teoso ãkiri sãkire? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Kipa iua? Nimarotiniãri, nauikapitikariko —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Pite aõkitapekari Teoso ãkiri. Iuapitikara misãkirenãtai pite uatxa —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Apiananiri, nota auikari pite Teoso ãkiri pininiua. Ininiã iua kapotoreẽkaua Xesosi apisatoõ. ");
INSERT INTO apuNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","—Ĩkorapokoriti napoka Teoso sãkire auiãkani ipinimoni nitakinina ĩkapani. Isãkire mauiãkani ipinimoni nitakinina ĩkapani napoka ĩkorapokoriti. Apanakini nisikaposotiireta, Teoso sãkire auikinina ĩkapani. Mitxi ninoa mõsiãreti atoko itxauana, kotxi mitxi !imarotarina Teoso. Ninoa auikapiretakasaakiri Teoso sãkire, kõsiãreri atoko itxapekauana. Apanakinipekana atão minakati isãkirena: “Nimarotapitikari Teoso.” Ninoa uãkatari kõsiãreri atoko ininiuana. Txamari kona atão ninoa nirekari imarotiniri Teoso. !Nisikari posotiiretxi ninoamoni, Teoso sãkire auikinina ĩkapani. Kãkiti iua atoko inakari mõsiãreti atoko itxaua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ãtikaka pariseoakori Xesosi takote auakani kenakotari. —Atauako atekani apaka mõsiãreti atoko atxaua? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—“Mõsiãreni atoko atxaua,” hininiã hĩsãkire, ininiã atão hĩsãkire. Txamari hĩte txari: “Kõsiãreua ate,” hĩtxama. Iua atoko hininiã hĩkamapitikari maerekati, kotxi kona hãuikari Teoso sãkire —Xesosi txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Xesosi sãkirauatakasaaki, ia atoko itxa isãpirena: —Atãopitikara ia atoko nitxapaniiko hĩte. Soti auĩte ĩroã pirikeri itoremoni. Itoremoni miĩroãkani kiĩtiriri itxauana, kotxi ãtiãtaã ikanĩka ĩroini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pirikeri toremoni ĩroãkari soti auĩte pitikiri. ");
INSERT INTO apuNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Initiri osereẽri pirikeri tore iua ĩkapani. Soti auĩte kenakotari ipitikiri sãkire. Ipitikiri imarotari ikinipoko ipiraakori uãka akiritinina ĩkapani. Iuara anikana inipokotinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Porikiti auakasaakina, iua saãpota ninoa apisa. Iua tikini isana ninoa. Ninoa imarotari iua sãkire ene. ");
INSERT INTO apuNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ninoa kona sari kãkiti imimarotakinitina tikini. Ipitikiri minakotika akiritakasaakina, imitekana. Kona imarotarina imapitikiritakinitina sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ikara sãpirenatxi atão inakari oerekiko Xesosi sãpiretari pariseoakori. Txamari ninoa kona imarotari Xesosi ikara atoko inakari isãpirena. ");
INSERT INTO apuNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Xesosi iuaĩkana sãkirauata. —Inipitikara nota pirikeri tore nitxaua, soti auĩte ĩroini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nota apisa apoãkani, atão minasãkiretakani kiĩtiririni itxauana. Soti auĩte kona maãkatari ninoa sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nota itore nitxaua. Kãkiti ĩroiniãtaã tore nitxaua. Nota makatxakari uai ĩroãkari maerekani, auapininiika inini ĩkapani. Iĩroã, ipokĩka itxapika. Kona kapĩkareri. Natxi !auari. ");
INSERT INTO apuNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kiĩtiriri apoka iĩtiriuatini ĩkapani, okaniuatini ĩkapani, imisirikarauatini ĩkapani. Notapekana apoka kãkiti auapininiika inini ĩkapani, kãkiti auini ereka inini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Pitikiritxi erekari nitxaua nota. Pitikiritxi erekari ipina ipiraakori mapinakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nitiritxi soti auĩteakori pitikiri !itxaua. Anãpa auĩte kaneenamari apokasaaki, iua miteka. Itakanapanako soti auĩteakori. Ininiã anãpa maĩkari soti auĩte, oxikepoata itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iua nitiritxi mitekako, kotxi txineiro ĩkapaninokara iparĩkauata. Kona atão itiretari soti auĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","—Soti auĩte pitikiri erekari nitxaua nota. Atão nimarotari nipiraakori. Ninoa apaka atão imarotano nota. ");
INSERT INTO apuNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Iua atokokana niri imarotano nota. Nota apaka imarotari niri. Nota ipinako soti auĩteakori nota nakiti mapinakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nota aua apanakini soti auĩteakori apaka. Uatxa ia pirikeri ãki !auapanikana. Niminanako ninoa apaka ia pirikeri ãki auinina ĩkapani. Ninoa auikariko nisãkire. Ininiã ninoa imakinika aua ãtika pirikeri ãki. Ãtikarako ninoa pitikiri. ");
INSERT INTO apuNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","—Niri tiretano, kotxi nauiritari nipinini, iuaĩkana nõkitikiniua ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kãkiti !iposotari okinino nota nimanirekasaakiri nokiko. Nota sikariko niĩto nokiko ĩkapani. Ninirekasaaki manapi nipina. Ninirekasaaki manapi nõkitikaua. Ikara atoko niri paniãtano nota —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ikara Xesosi sãkire Xoteoakori kenakotakasaaki, itaparakienatakakauana. Apanakini potxitari Xesosi sãkire. Apanakini kona potxitari. ");
INSERT INTO apuNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Apanakini txari: —Satanasi nitiri auaĩtotari iua. Ãtipekana txari: —Imapitxirita. Kinirepa hĩkenakotatari mapitxiritakari sãkire? —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Apanakini txari: —Satanasi nitiri auaĩtotakiti !ikara atoko itxa sãkireta. Satanasi nitiri kona kõsiãrepeka txĩkitakari mõsiãreti —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mitaãsaaki Xoteoakori kamari kiiniri Xerosareẽ. Iuasaaki ixinikarina Teoso misãkiretiko aikoti merepaniko kamiko. ");
INSERT INTO apuNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iuasaaki Xesosi tĩpokota aiko Teoso misãkiretikoãtaã, Saromãoni inakoriãtaã. ");
INSERT INTO apuNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iuaã Xoteoakori apotiitaua iuamoni. Iuasaaki ninoa txari iua: —Pite Teoso mereẽkiti pininiãua, pisãpiretaua. Akokaxiti anirekari aimarotiniri ikara —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Xesosi apakapapiretana: —Nisãpiretapekai hĩte. Kona hãuikari nota sãkire. Niposotiire nikamakiti niri uãkaã oerekapekai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nisãpiretapekai hĩte, txamari kona hãuikari nota sãkire, kotxi nisoti auĩtene kona hĩtxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nisoti auĩtene imarotari nisãkire. Nota imarotana ninoa. Ninoa kapokitano nota. ");
INSERT INTO apuNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nitxĩkitakana ninoa ãtipirika auinina. Nota kamari ninoa imipĩkanina tĩkane. Kona kamakatxakikona nota nĩkatakini. ");
INSERT INTO apuNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Niri sikana ninoa notamoni. Apiatakari itxaua iua. Ininiã ãti kona posotari imakatxakinina niri nĩkatakini. ");
INSERT INTO apuNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Niri, nota pakini ãtika atxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ikara atoko Xesosi inakasaaki, Xoteoakori morõkari kai soro ikiporonakinirina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Xesosi sãkirauata ninoamoni: —Kaiãopokori erekari niri nakiti noerekapekai hĩte. Kinakarixikapa hinireka hĩkiporonakinino nota? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Xoteoakori apakapapireta: —Kona akiporonakai erekari pikaminiã. Akiporonakai, “Teosorano nota” pinini xikara. Pite kiki, iuaritika “Teosorano,” pitxa. Ininiã maerekati pikamapeka Teosomonikari. ");
INSERT INTO apuNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Xesosi apakapapiretana: —Kitxakapirĩka Teoso sãkire iõkatsopatakori txari: Nitxai: “Teosoakori hĩtxaua hĩte.” ");
INSERT INTO apuNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Aimarotari Teoso sãkire iõkatsopatakori ãtipirika atão inini. Teoso akiriuãkatana ninoa isãkire apakapakani “teosoakori.” ");
INSERT INTO apuNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ininiã kinirepa hĩte kamaãkaretxitano. Niri mereẽno nota inireẽkiti nikamini ĩkapani. Iokanatano ĩkorapokoritimoni. Ininiã kinirepa hãpoĩtano Teoso nimisãkirepiretini, “Teoso ãkirirano” ninakasaaki? ");
INSERT INTO apuNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nimakamakaniãri niri nirekaãkiti, iuasaaki kona hãuikari nota sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nikaminiãri inirekaãkiti, iuaritika himauikakaniãri nisãkire, hãuikariko niposotiire. Hĩtikakiti hãuika. Ininiã himarotariko, hãuikariko, niri, nota pakini ãtika aniniua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iuasaakipeka pariseoakori omanãkarauata. Iuaĩkana inirekarina imaĩkinirina Xesosi. Txamari iuasaakipe isipe. ");
INSERT INTO apuNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iuaĩkana Xesosi kanapiriã Xotão ipiniãmoni. Iuaã ikaikota Xoão kapatxisarerini patxisarauatiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Itomaneri kãkiti sari iuamoni. Ininiã ninoa txa: —Xoão kona kamari posotiiretxi, iuaritika ikinika isãpiretakiti Xesosi pirena atão inakarinoka isãpireta. ");
INSERT INTO apuNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ininiã itori kãkiti iuaãtaã auikari Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kiki Arásaro inakori aua ipi itaro, Maria, Mata pakini. Ninoa aua Petánia aapokotxiti. Iuasaaki Arásaro amianata. ");
INSERT INTO apuNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Xesosi ipinini apisa, oa Maria arokari Xesosi kiti kamariãroã, oiãkoã kaxipota otxari. Oa Maria itari Arásaro amianata. ");
INSERT INTO apuNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Iua amianatakasaaki, Maria, Mata pakini iokanapireta Xesosimoni: —Apiananiri, pitiretakiti amianata —otxari. ");
INSERT INTO apuNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ninoa iokanapirena ikenakotakasaaki, iua txa: —Amianari inokari Arásaro kona ipinini ĩkapanini. Teoso posotiire oerekini ĩkapanira iua amianari inokari iua. Kãkiti: “Teoso ãkiri peerekari” iniko ĩkapanira iua amianata. ");
INSERT INTO apuNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Xesosi tiretari Mata, oĩtaro Maria, Arásaro pakini. ");
INSERT INTO apuNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ikenakotakasaakiri Arásaro amianatini, iua napapanikari ipi õti iuaxiti. ");
INSERT INTO apuNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Eereka itxana imoianariakori: —Iuaĩkana Xotéia tõpa masa. ");
INSERT INTO apuNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ininiã imoianariakori: —Koerekareri, kitapani iuaã Xoteoakori nirekari kai soroã ikiporonakinii pite. Iuaritika pisatapanikako iuaãtaã? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ininiã Xesosi: —Pokamara tosi oara aua kãkiti parĩkauatini ĩkapani. Pokamara tĩpokotakari kona mãkitita, kotxi atokatxi iopinikari ikinipoko. ");
INSERT INTO apuNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Txamari ĩkanõka tĩpokotakari mãkitita, kotxi atokatxi kamara !auari. ");
INSERT INTO apuNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ininiã Xesosi: —Amoianari Arásaro imakanãta. Nota õpirĩkariko iua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ininiã Xesosi moianariakori txa: —Imakanãtiniã, erekaãpopekari uatxa —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Xesosi imarotari Arásaro ipinini, txamari imoianariakori uãkatari Arásaro atão imakini. ");
INSERT INTO apuNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ininiã Xesosi txana ninoa atão imarotinina ĩkapani: —Arásaro ipĩpe. ");
INSERT INTO apuNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Erekapitikari iuaã nimauakani, kotxi eereka hĩte auikariko nota sãkire. Masa iuaxiti. Maõkitari iua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomee Txítximo inakori misãkiretana apanakini Xesosi moianariakori: —Masa iuakata apinini tĩkane. Ikara atoko itxa isãkire, kotxi iuaxiti Xoteoakori nirekari okiniri Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Xesosi apokasaaki iuaxiti ipi ipi pakini õti napapeka. Ininiã iuasaaki Arásaroni katapeẽkaika. ");
INSERT INTO apuNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Petánia Xerosareẽ takote. ");
INSERT INTO apuNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Apanakini kãkiti apoka Mata, Maria pakinimoni. Ninoa moianatana, kotxi itarina !auaika. ");
INSERT INTO apuNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata kenakopiretari Xesosi apokaãpotini. Ininiã oa sari oaõkitiniri ĩkapani. Maria kaikota oaãpoko ãki. ");
INSERT INTO apuNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Xesosimoni Mata apokasaaki, otxari iua: —Apiananiri, pite uai auaãkamako, kona nitari ipinamako. ");
INSERT INTO apuNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Iuaritika nimarotapitikari, pamanaãkiti Teoso sikapitikai —otxa. ");
INSERT INTO apuNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ininiã Xesosi txaro: —Pitari iuaĩkana auapanikako. ");
INSERT INTO apuNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ininiã Mata: —Nimarotari itixi xipokini õti nitari iuaĩkana auapanikako. Ipĩkani õkitikiniua õti, iua õkitikaua —otxa Mata. ");
INSERT INTO apuNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ininiã Xesosi sãkirauata: —Nota ipĩkari õkitikakarirano nota. Kãkiti auãki inĩkitaãkarirano nota. Nota sãkire auiãkari ipininiã, iuaritika iuaĩkana auapanikako. Kona ipinaika. ");
INSERT INTO apuNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nota sãkire auiãkari auapanikako iuaĩkana. !Ipinaikako. Pauikatari ikara atoko nininii? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ininiã Mata: —Apiananiri, nauikapitikari. Teoso mereẽkiti pitxaua. Teoso ãkiri pitxaua. Teoso iokanatakiti itiximoni ĩkari pitxaua. Ikara nauikapitika —oa txari iua. ");
INSERT INTO apuNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Eereka Mata sari oĩtaromoni. Oãkiritaro oa, mapara omisãkiretini ĩkapani. —Koerekareri apope. Iua akiritai —otxa Mata. ");
INSERT INTO apuNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria kenakotari ikara inakasaaki, katimariã õkitikaua, iuamoni sa otxa oa. ");
INSERT INTO apuNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iuasaaki Xesosi !apokapanika aapokotxiãtaã. Ikaikotapanika mitxi Mata apokiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria katimaritika õkitikasaakiua, Xesosimoni osini ĩkapani, Xoteoakori, oaãpoko ãki auakani, oa mĩkapiritakani, sari oa tikini. Ninoa uãkatari akauarimoni osini otxiapatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria apoka Xesosimoni. Oãtamatakasaakiri iua, iua apisatoõ okapotoreẽkaua. Otxari: —Uai pauaãkamako, kona nitari ipinamako —otxa. ");
INSERT INTO apuNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Xesosi atamataro otxiapatini. Xoteoakori oakata apokakani txiapata apaka, ininiã Xesosi iteene matinaniuata ãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Iua pimaãna: —Nanipa hĩkatatari? —itxa. Ininiã ninoa: —Apiananiri, masa. Patariko iuaã —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iuasaaki Xesosi txiapata. ");
INSERT INTO apuNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","—Hãtamatari Xesosi. Iua tiretapitikari Arásaroni —itxa Xoteoakori. ");
INSERT INTO apuNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ãtikaka Xoteoakori txa: —Mõsiãreti kõsiãrepeka itxĩkitakapeka. Atxiĩti iua uai apokaãkamako, kona Arásaro ipinamako —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ininiã Xesosi iteene matinaniuata ãkixinireẽ. Iuasaaki isa akauarimoni. Ninoa takari ipĩkari kai auĩte ãki. Kai auĩte itotaãka. ");
INSERT INTO apuNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ininiã Xesosi txari: —Himakatxakari akauari tore —itxa. Mata, Arásaroni itaro txari Xesosi: —Apiananiri, ipaiakapeka. Ipi ipi õti pakinipeka ikatiko, ininiã pataparasakari —otxari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ininiã Xesosi: —Nota sãpiretapekai: “Nota sãkire pauikiniã, pitikariko Teoso posotiire” —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ininiã imakatxakarina kai. Iuasaakipeka Xesosi ionakaãta iaxiti. —Niri. Erekai, kotxi pikenakotari nisãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nimarotari ãtipirika pikenakotiniri nisãkire. Ikara atoko nitxa sãkireta kãkiti uai auakani kenakotiniri ĩkapani, kotxi ninirekari ninoa auikiniri pite iokanatinino nota uaimoni —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ikara atoko inaãka atoko akirikatari: —Arásaro, põkitikaua. Pipokĩka. ");
INSERT INTO apuNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ininiã iuasaakipeka Arásaro pokĩka. Imakinika iĩto mãkatxi mataã iapirikaãka. Itoõ apaka iapirikaãka mãkatxi mataã. Ininiã Xesosi: —Himakatxakari iapirikiko. ");
INSERT INTO apuNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Xoteoakori Mariamoni ĩkani itikari ikara atoko inakari, ininiã auikarina Xesosi Teoso ãkiri ininiua. ");
INSERT INTO apuNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ãtikaka Xesosi kamakiti itikakani kanapiriã pariseoakorimoni. Isãpiretana Xesosi õkitikiniri Arásaro. ");
INSERT INTO apuNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ininiã pariseoakori, sasetotxi auĩteakori pakini apotiitaua. Imisãkiretakakana: —Kiripa ate kama? Ia kiki kamari itori posotiiretxi. ");
INSERT INTO apuNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Aãuiritiniãri iua ikara atoko ikamini, ikinipoko kãkiti auikari iua sãkire. Ininiã iua tikini isana. Ikara atoko ininiã, Homanoakori xipokari Teoso misãkiretiko aikoti ate nakiti, ate tixine apaka —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Iuasaaki Kaipasi inakori sasetotxiakori auĩte apiatakari inakari iua. Itxana: —Hĩte kona kimarorepanikai. ");
INSERT INTO apuNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Erekari ãti kiki ipinini ikinimane mapinakani ĩkapani. Ikara atoko ininiã, kona ikinipoko anirimane ipinako —itxa Kaipasi. ");
INSERT INTO apuNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ĩkorakanani sasetotxi auĩte apiatakari itxaua Kaipasi. Ia atoko itxa: “Xesosi ipinako Xoteoakori mapinakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kona ninoa ĩkapaninanini ipinako. Teoso anaakori iarikakani ĩkapani apaka ipinako. Ininiã iuasaakirako iua apotiitari ikinipoko ninoa. Ininiã Teoso anaakori itxauanako,” itxa Kaipasi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Iuasaaki eereka imapapiretarina Xesosi okinina tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ikara atoko ininiã, Xesosi kona saika Xotéia tõpamoni. Isari Eparaiĩ sitatxitimoni, ãparaã makipakaniãtaã takote. Iuaã ikaikota imoianariakorikata. ");
INSERT INTO apuNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Iuasaaki imatokoãpotarina Páskoa kiiniriti. Iuasaaki itomaneri Xoteoakori Xerosareẽ tõpa auakani sari Xerosareẽ sitatxitimoni. Iua kiiniri apisapanika, isana iuaã oerexiniretiniuana ĩkapani. Iuasaaki amanaãrina Teoso imakatxakiniri maerekati ikamakitina. ");
INSERT INTO apuNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Iuaã Xoteoakori nitari Xesosi. Ninoakakarika ipimaãkakana: —Atauako kiinirimoni inapani atxiĩti? ");
INSERT INTO apuNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sasetotxi auĩteakori, pariseoakori pakini paniãtapekari kãkiti: —Himarotakasaakiri Xesosi auiniãtaã, hĩsãpiretauako ate, ininiã amaĩkariko iua. ");
INSERT INTO apuNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seisi õti Páskoa kiiniriti apisa, Xesosi sari Petánia sitatxitimoni. Iuaã aua Arásaro, Xesosi õkitikakiti Arásaro ipĩkasaaki. ");
INSERT INTO apuNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Iuaã ikamaãka nipokori Xesosi ĩkapani. Mata sikari nipokori kãkitimoni. Iuasaaki Arásaro apanakinikata topãka Xesosikata. ");
INSERT INTO apuNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Iuasaaki Maria kosekaro kamariãro koana. Oia atão nato kamakoro. Ipixini kiro ominani aua. Kona koketakoroni. Natonokara. Pakaronero, iuaritika okitakaro Xesosi kitimoni. Oiãkoã okaxipokari. Iuasaaki aapokotxi ãki omarinokara itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Txamari Xotasi Isikariotxi inakori !apokaerekatari kamariãro Xesosi kitiã okitakini. Iua Xotasi Simão ãkiri. Xesosi moianari itxaua, txamari imĩkapiritariko Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ininiã Xotasi txari: —Kãkiti parĩkauata tresẽtosi pakini õti oia atoko inakaro kamariãro iamotiko ĩkapani. Kinirepa kona ovẽtxitaãka? Kinirepa txineiro mauakinitimoni !osika? —itxa Xotasi. ");
INSERT INTO apuNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ikara atoko itxa, kotxi kiĩtiriri itxaua. Iua nĩkataro ninoa txineirote. Iua itotapekari txineiro iĩtirĩkini. Iua !imaãkatana txineiro mauakiniti. ");
INSERT INTO apuNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Xesosi apakapapiretari: —Kona hĩtxitapero Mariapani. Onĩkataro kamariãro ia õti notamoni otakini ĩkapani, kotxi oxinikari nikatiko õti ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Minakati mauinakini auapikako hĩtekata. Txama nota !auaikako hĩtekata —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Itomaneri Xoteoakori kenakopiretakasaakiri Xesosi Petánia sitatxitiã auini, ininiã iuaã isana Xesosi aõkitinina ĩkapani. Kona iuananini ninoa nireka aõkitinina. Arásaro Xesosi õkitikakiti apaka ninoa nirekari atamatinina. ");
INSERT INTO apuNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ininiã sasetotxi auĩteakori nirekari Arásaro apaka okinina, kotxi kaiãopokori kãkiti auikari Xesosi sãkire Arásaro sãpiretakiti ikenakotakasaakina. Itakanaparina sasetotxiakori sãkire auikinina. ");
INSERT INTO apuNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Arásaro iuaĩkana auiniã, ininiã itomaneri Xoteoakori asikaãpotari iauĩtena, Xesosi sãkire auikinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Katimatinĩkata, itomaneri kãkiti Páskoa kiiniritimoni sikani, kenakopiretari Xesosi apokaãpotini Xerosareẽmoni. ");
INSERT INTO apuNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ininiã Xerosareẽkini sari aõkitinirina iua. Kinari tape anikana, Xesosi apiãkatakasaakina. Akirikatana: —Peerekari Teoso. Teoso takari erekari Isaeo auakani auĩtemoni, Apiananiri uãkaã ĩkarimoni —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mitxipe Xesosi iokanatari imoianariakori xomẽta ãkiri initinina. Ninoa apokasaakiri, iminarina Xesosimoni. Ininiã Xesosi topãka iua nopini. Iua nopini Xesosi sari Xerosareẽmonikari. Kitxakapirĩka Teoso sãkire iõkatsopatakori txari: ");
INSERT INTO apuNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Kãkiti Xerosareẽkini kona hĩpĩkarauatape. Erepani hĩauĩte. Xomẽta nopini iitopãkako, itxa Teoso sãkire kitxakapirĩka. Ikara iaõka apokapeka, kotxi Xesosi apoka xomẽta nopini. ");
INSERT INTO apuNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Iuasaaki imoianariakori kona xinikari Teoso sãpiretakiti kitxakapirĩka auakari. Xesosi ipinaka atoko, õkitikaãkaua atoko, iuasaakiika ninoa xinikari ikara Teoso sãkire. Ininiã iuasaakiika imarotarina Teoso sãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mitxi kãkiti akauari takote auakani, ninoa itikari Xesosi õkitikiniri Arásaro. Ninoa iaripiretari Xesosi kamakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ininiã kãkiti apiãkatari Xesosi, kotxi ninoa kenakoenetapekari Arásaro õkitikini. ");
INSERT INTO apuNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ininiã pariseoakori misãkiretakakaua: —Hãtamata. Kiripa aposota akamini? Ikinimane kãkiti nirekari iua. Ininiã pariseoakori xikotari Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ãtikaka Krekoakori apoka Xerosareẽmoni Páskoa kiiniriti ĩkapani, kotxi ninoa nirekari Teoso imisãkiretinina. ");
INSERT INTO apuNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Apokasaakina iuaãtaã, isana Piripimoni. Iua Petsáita aapokotxitikiri, Kariréia tõpa auakari. Ininiã apokasaakina Piripimoni, ipimaãrina: —Ate nirekari Xesosi aaõkitini. ");
INSERT INTO apuNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ininiã Piripi sari Ãtreemoni, isãpiretiniri ĩkapani. Eereka isana Xesosimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ininiã apokasaakina, Xesosi txana ninoa: —Kaiamapekari nota hĩtari iaxitikiri sini niri tixinemoni ikinipoko erekari napakapini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Atão nisãpiretai. Nota kimi oki atoko. Kãkiti matakakaniãro oa, ãtika okinoka auapika. Pitakiniãro, opitxaka. Ininiã kaiãori oki aua. Ikara atoko nota. Nimapĩkaniã, ininiã notanokara auari. Nipininiã, ininiã itomaneri kãkiti sari niri tixinemoni. ");
INSERT INTO apuNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Pite ãtipirika kaminiãri piteka nireẽkitinoka, ininiã pinireẽkiti xipokapitikako pitekata. Pite nireẽkiti xipokiniã, nota sãkire pauikini xika, pite auapininiika txako Teosokata. ");
INSERT INTO apuNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kãkiti nirekiniãri iparĩkauatini nota ĩkapani, imoianatanoko. Iua atoko ininiã, nota auiniãtaã iua apaka auako. Kãkiti parĩkauatiniã nota ĩkapani, ininiã niri paxitariko iua. ");
INSERT INTO apuNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Xesosi misãkiretari Teoso: —Uatxa kona erekaxinireno, ininiã kiãtokopa nitxa nisãkire pitemoni? Atxiĩti nipaniãtai: “Niri, pimakatxakinanoko nimapinakani ĩkapani.” Ikara atoko !nipaniãtai, kotxi nipinini ĩkapanira napoka ĩkorapokoritimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ininiã niri, poerekari kãkiti ikinimane auĩte pininiãua —itxa Xesosi. Iuasaakipeka iaxitikiri txari: —Noerekapekari kãkiti ikinimane auĩte nininiãua. Eereka iuaĩkana noerekapanikariko ikara —itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kãkiti iuaãtaã auakani kenakotari iaxitikiri sãkire. Txamari itxana: —Ikarokirauata. Apanakini txari: —Teoso nitirira sãkirauata iuakata —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Xesosi txana ninoa: —Ikara sãkirauata kona nota ĩkapanini. Hĩte ĩkapanira isãkirauata. ");
INSERT INTO apuNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Iposope ikini itixiti auakani misiritiko imaerekanina xika. Iposope ikini itixiti auakani auĩte Satanasi inakori xipokiko. ");
INSERT INTO apuNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nota aamina ĩpiriãmitakari nopini nõkitikikosaaki, iuasaaki nikosekanako kãkiti notamonikari. ");
INSERT INTO apuNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ikara atoko itxa, kãkiti imarotiniri aamina ĩpiriãmitakari nopini ipinini. ");
INSERT INTO apuNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Apanakini kãkiti apakapapiretari: —Teoso sãkire kitxakapirĩka iõkatsopatakori oerekaua Teoso mereẽkiti ãtipirika auini. !Ipina. Txamari pite sãpiretaua ipinini aamina ĩpiriãmitakari nopini? Kipa iua aĩtari iaxitikiri pisãpiretakiti? —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ininiã Xesosi: —Tirikapi kamara atoko nitxa. Hĩtekata nauakasaaki, noerekai hĩte atão inakari. Uatxa tirikapi kamara hĩtekata auapanika. Paĩtiki nota sipe. Tirikapi auakasaaki, pauapikako tirikapi kamaraã. Ininiã ipiã kona apoka hĩtemoni. Kãkiti mauikakaniãri nota sãkire, ĩkanõka tĩpokotakani atoko itxana. !Imarotarina isinimonina. ");
INSERT INTO apuNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tirikapi hĩtemoni auakasaaki, hãuikariko iua sãkire. Ikara atoko ininiã, “pokamarari anaakori” hĩtxaua —itxa Xesosi. Ikara atoko inaka atoko isipeka. !Isãpiretari isinimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Xoteoakori itikari ikinipoko posotiiretxi Xesosi kamakiti. Iuaritika kona ninoa auikari iua sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ikara atoko ininiã, kitxakapirĩka Teoso sãkire sãpiretakari Isaía inakori iõkatsopatakiti, iuasaaki apopeka. Isaía txari: Apiananiri, kãkiti !auikapiretari asãkire ninoamoni asãpiretakiti. !Auikari piposotiire poereẽkiti ninoamoni, itxa Isaía. ");
INSERT INTO apuNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Iua atoko ininiã, Xoteoakori kona posotari auikiniri Xesosi sãkire, kotxi iuaĩkana Isaía txari: ");
INSERT INTO apuNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Teoso mõsiãretakana ninoa. Kaikokii itxĩkitakana. Itikakitina kona iĩkitetana ninoa. Ikiiãna kona !imarotarina. Ininiã ninoa kona apokapaniko notamoni erekapeka ininina nitxĩkitakini ĩkapani, itxa Teoso Isaía iõkatsopatakitiã. ");
INSERT INTO apuNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kitxakapirĩka Xesosi uai apokini apisa Isaía iõkatsopatari ia sãkiretxiti. Iuasaaki Teoso oerekari Isaía Xesosi posotiire, apaka ikinika Xesosi kamakiti tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iuaritika itomaneri Xoteo auĩteakori auikari Xesosi sãkire. Txamari !isãpiretarina apanakini, kotxi ninoa pĩkari pariseoakori. Pariseoakori imarotakasaakiri Xesosi sãkire auiãkani ininiuana, !auiritaikana ninoa ĩroini aiko Xoteoakori apotiitiniãtaãua. ");
INSERT INTO apuNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Iua atoko ininiã, ninoa apia nirekari kãkiti iuikinina. Poiãoka ninoa nirekari Teoso iuikinina. ");
INSERT INTO apuNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Xesosi itaparasãkireritika txari: —Kãkiti auikiniãri nota sãkire, kona nota sãkirenanini ninoa auika. Niri sãkire apaka auikana, kotxi iua iokanatano nota uaimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Natamatakiri apaka atamatari niri. ");
INSERT INTO apuNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tirikapi atoko nitxa nĩkasaaki kãkitimoni. Nota sãkire auiãkani kona kaikota ipiaã. ");
INSERT INTO apuNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kãkiti nisãkire kenakotakani mauikakaniãri nisãkire, kona nimisiritari iua imaerekani xika. Kona kãkiti nimisiritini ĩkapanini nina uaimoni. Nina kãkiti maerekani nimakatxakini ĩkapanira. ");
INSERT INTO apuNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","—Nota manirekakati, nisãkire manirekakati apaka, auapeka imisiritiko mereẽkari. Nisãpiretakiti, iuarako itixi xipokini õtisaaki sãpiretari imisiritiko. ");
INSERT INTO apuNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","—Notaka sãkire !nisãpiretai. Niri sãkirera nisãpiretai. Niri iokanatano nota uaimoni. Iua paniãtakiti isãpiretakiti nisãpiretai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nimarotari kãkiti auikiniãri niri paniãtakiti auapininiika itxako. Nota sãpiretari niri sikapiretinino iaõka. ");
INSERT INTO apuNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Páskoa inakori kiiniriti apisapanika, Xesosi imarotari paĩtiki itixi itakanapini irimoni isini ĩkapani. Iua tiretapikana kãkiti iua nakiti. Ninoa itiretiniritika ipinako Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Xesosi imoianariakorikata inipokotini apisapanika Satanasi sikanireõtapekari Xotasi Isikariotxi Xesosi imĩkapiritini ĩkapani. Iua Xotasi, Simão ãkiri. Eereka inirekari isikiniri Xesosi imokaiakarimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Xesosi imarotapekari iri sikiniri ikinipoko posotiiretxi Xesosimoni. Imarotapekari Teosomoni ipotorikini. Imarotapekari iuamoni ikanapiriini. ");
INSERT INTO apuNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Iuaritika inipokotaka atoko, õkitikaua. Imakatxakari imãka inopini auakari. Eereka ipomakitari mãkatxi mata nitiritxi parĩka atoko ikamini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Eereka itakari ãparaã tiitxi ãki. Ininiã arokana imoianariakori kiti. Eereka mãkatxi mataã ikaxipokaãpotana. ");
INSERT INTO apuNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simão Petro takote apokasaaki, Petro txari: —Konapitini, Apiananiri. Ninitiri !pitxaua. Ininiã kona parokapiri nikiti —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ininiã Xesosi: —Uatxa kona pimarotari nikamakiti. Pimarotariko ãti õti. ");
INSERT INTO apuNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Koniko pite arokapaniri nota kiti —itxa Petro. Ininiã Xesosi: —Pimauiritakaniãno pikiti narokini, ininiã kona nimoianari pitxaikauako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Ikara atoko ininiã, kona nikitinani paroka. Niuako, nikii, imakinika paroka —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ininiã Xesosi: —Kãkiti kipaãtakaniua poirepe itxana. Itĩpokotakasaaki, iuaĩkana itxiko apoka iuamoni. Iuasaaki ikitinokara arokaãka. Hĩte himakinika poirepeka, kotxi nimakatxakapekari himaerekani. Ãtinokara kona poireri, kotxi imaerekani auapanika. ");
INSERT INTO apuNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Xesosi imarotapekari iua mĩkapiritakari, ininiã itxa: “Himakinika poirepeka. Ãtinokara kona poireri,” itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ninoa kiti arokaãka atoko, ieretakari imãka inopinikiri. Ikanapiriã amesamoni. Ipimaãna: —Kinirepa narokatari hĩkiti? ");
INSERT INTO apuNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hĩte akiriuãkatano nota “koerekareri.” Apaka hãkiriuãkatano “Apiananiri.” Atãopitikara hĩsãkire, kotxi ikara inakari nitxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Hĩauĩte, hõereẽkiri nitxaua. Iuaritika narokari hĩkiti. Hinitiri atoko niparĩkauata. Ininiã hãrokakititakakauako, kãkiti nitiri atoko hininiua. ");
INSERT INTO apuNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Noerekapekai hĩte erekari hĩkamini. Uatxa hĩkamariko nota kamakiti atokokana. ");
INSERT INTO apuNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Atão inakari nitxai. Nitiritxi iamotakori poiãori. Iauĩte apiari. Apaka kãkiti iokanatakari apiata. Iokanatakiti poiãori. ");
INSERT INTO apuNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Uatxa hĩte imarotari atão inakari hĩkamini. Hĩkaminiãri, hĩpoxokoniuata. ");
INSERT INTO apuNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","—Kona himakinikani ikara atoko nitxai. Nimarotari nimereẽkini, txamari ia Teoso sãkire iõkatsopatakori iaõka apokapitikako. Itxari: Notakata komiri nikakari, iuakarako kamari maerekati notamoni. ");
INSERT INTO apuNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Uatxa iua himarotini apisapanika nisãpiretai hĩte. Ininiã nisãkire iaõka apokasaaki, himarotariko Teoso ãkiri nininiua nota. ");
INSERT INTO apuNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Atão inakari nisãpiretai. Kãkiti nota iokanatakiti hĩtemoni hãpakapiniã, nota apaka hãpakapa. Hãpakapiniãno nota, hãpakapari apaka nota iokanatakari hĩtemoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Xesosi ikara isãpiretaãka atoko, ãkixinireẽ imatinaniuata. Itxana: —Ari, ãtikara hĩte sauaki mĩkapiritano nota. ");
INSERT INTO apuNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ininiã imoianariakori atamatakakaua. —Kiripa ikara atoko txatako? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iuasaaki Xesosi moianari itiretakiti papĩkaĩtota iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ininiã iuasaaki Simão Petro ieki itxa isona iuamoni. Ininiã Petro: —Pipimaãri iua: “Ĩkiripa ikara atoko txatariko iua?” —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ininiã Xesosi tiretakiti pimaãri Xesosi: —Kiripa ikara atoko txatai? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ininiã Xesosi: —Komiri niãkakiti nisikakitikarako ikara atoko txanoko. Ininiã iuasaaki iãkari komiri. Eereka isikari Xotasi Isikariotximoni. Iua Xotasi Simão ãkiri. ");
INSERT INTO apuNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Xotasi komiri inikasaaki, Satanasi ĩroã ixiniremoni. Ininiã Xesosi txari Xotasi: —Kinirão kamaka pinakiti pikamapoka —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Iuaã auakani ãkixinireẽ: —Kinirepa ikara atoko itxatari Xotasi? ");
INSERT INTO apuNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Xotasi nĩkataro ninoa txineirote. Ininiã ninoa ãkixinireẽ: —Atxiĩti iokanatari iua komiri iamotini ĩkapani. Ãtipekana: —Atxiĩti iokanatari iua matiinimoni txineiro isikini ĩkapani —itxanãtana ãkixinireẽna. ");
INSERT INTO apuNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Komiri apakapaãka atoko, inikaãka atoko isipe Xotasi. Mapiãpe inakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Xotasi sipeka inaãka atoko, Xesosi txana ninoa: —Uatxa kãkiti itikariko kãkiti itari iaxitikiri posotiire. ");
INSERT INTO apuNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kãkiti atamatariko Teoso posotiire imimoni auakari. Ininiã Teoso txari: “Erekapitikari namarite.” Iuasaaki Teoso oerekari kãkiti iua apokaerekatiniri imi. Ikara atoko ininiã, oerekari imi ereka inini. ");
INSERT INTO apuNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","—Nitiretakini, paĩtikinoka nauini hĩtekata. Eereka hinitapiimano nota, txamari nota sinimoni kona hĩposotari hĩsini. Ikara atoko nitxapekana Xoteoakori. Iuatxikana uatxa nisãpiretai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ininiã uatxa nisãpiretaiko hĩte Teoso paniãtakiti amaneri: “Hĩtiretakakaua, nota hĩte nitiretini atokokana.” ");
INSERT INTO apuNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ikara atoko hĩkaminiã, ikinimane imarotariko nota moianariakori atão hininiãua. ");
INSERT INTO apuNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simão Petro pimaãri: —Koerekareri, nanipa pisatako? Xesosi apakapapiretari: —Nota sinimoni kona uatxa apakata hĩsini. Ãti õtirako hĩsa hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Iuaĩkana Petro: —Apiananiri, kinirepa kona pitekata nisa uatxa? Nipinapitikamako pitekata —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—Atãopitikani notakata pipinini pinirekaka? —itxari. —Atão nisãpiretai. Ia ĩkanõkati patari sãkirauatini apisapanikako, “!Nimarotari iua,” pitxanoko ipi ãti pakinikata —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","—Kona himatinaniuatape. Kona himaãkapeua. Hãuikariko Teoso sãkire. Apaka hãuikariko nota sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Niri auiniãtaã aua kaiãopokori aapokotxi. Ikara atoko iminakanimako, nisãpiretapiimaiko hĩte. Iuaã nisa hãuiniãtaã nikamini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Iuaã nisa hãapoko nikamini ĩkapani. Eereka nikanapiriã. Nanikai hĩte notakata hãuini ĩkapani. Ininiã hĩte apaka aua nota auiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hĩte imarotari nota sini kimaporiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","—Kona aimarotari pisinimoni. Natokopa ininiãpa aimarotatari pite sini kimaporiti? —itxa Tomee. ");
INSERT INTO apuNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ininiã Xesosi txari: —Teosomoni sikari kimaporiti nitxaua. Atãonoka nisãkire. Atãonoka nikamakiti. Nitxĩkitakari kãkiti auapininiika inini. Notamoni apokakarinanira sari nirimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Atão nota himarotiniã, ininiã himarotariko niri apaka. Uatxa himarotapekari iua. Hãtamatapekari iua —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","—Apiananiri, poerekari piri atemoni. Ikaranoka anireka —itxa Piripi. ");
INSERT INTO apuNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ininiã Xesosi: —Piripi, kona mixaikani hĩtekata nauama nota, iuaritika kona himarotapanikano nota? Nota aõkitakari, aõkitapekari niri. Kinirepa, “Piri poerekaua,” pitxa? ");
INSERT INTO apuNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kona pite auikapanikari niri auini nota ãki? Nota apaka aua niri ãki. —Hĩtemoni nisãpiretakiti kona nota sãkirenanini. Niri paniãtakitira. Niri nota ãki auakari iuara kamari ikinipoko nikamakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Hãuikariko nisãkire niri ãki nauini. Niri nota ãki auini apaka hãuika. Himauikakaniãri nisãkire, ininiã hãuikari nikamakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Atão nisãpiretai. Nota sãkire auiãkani kamariko nota kamakiti atokokana. Apaka ninoa kamakiti apiata, kotxi nirimoni nisako. ");
INSERT INTO apuNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nota uãkaã hamanaãkiti nota sikai hĩte. Ikara atoko ininiã, oerekaãka niri ereka ininiua. ");
INSERT INTO apuNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ikinipoko nota uãkaã hamanaãkiti, nota sikapitikai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nota hĩtiretiniã, hĩkamariko nipaniãtakiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","—Namanaãriko niri ãti kõtãkikareri iokanatini hĩtemoni. Iuakara auapininiika txako hĩtekata. ");
INSERT INTO apuNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iua Erekari Matamatakoti atãonani ina sãkiretakari. Kãkiti Teoso sãkire mauiãkani kona apakapari iua, kotxi kona atamatarina iua. Apaka kona imarotarina iua. Hĩtepekana imarotari iua, kotxi hĩtekata aua. Iua aua hĩte ãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","—Ininiã kona nitakanapai hĩte. Nikanapiriãpanikako hĩtekata nauini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Paĩtiki atoko kãkiti ĩkoraxiti auakani kona atamataikanoko nota. Hĩte atamatanoko. Hĩte auapanikako, kotxi nota apaka auapanikako. ");
INSERT INTO apuNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Iuaĩkana auapanika ninakasaaki, himarotariko niri ãki nauini. Hĩte apaka auako nota ãkixinireẽ. Nota aua hĩte ãkixinireẽ apaka. Txapaniko. ");
INSERT INTO apuNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","—Iua nisãkire auiãkarira nipaniãtakiti kamakarira tiretano nota. Nota tiretakari niri tireta. Nota apaka tiretari iua nitiretakiri. Ikara atoko ininiã, noerekariko apikomoni nisãkire iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ãti Xotasi, kona Xotasi Isikariotxi inakorini, txari Xesosi: —Kinirepa atenani poerekari Teoso ãkiri pininiua? Kinirepa kona poerekari ikara apanakinimoni? —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Xesosi apakapapiretari: —Kãkiti tiretiniãno, ikamari nisãkire iaõka. Niri tiretariko iua. Niri, nota pakini apokako iuamoni. Iuakata aãuako. ");
INSERT INTO apuNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nota matiretakani kona nĩkatari nisãkire. Nisãkire hĩkenakotakiti kona nota sãkireni. Niri niokanatakiri sãkirera. ");
INSERT INTO apuNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","—Hĩtekata nauakasaaki, ikara sãkiretxi nisãpiretai. ");
INSERT INTO apuNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Niri iokanatariko kõtãkikareri, Erekari Matamatakoti inakori hĩtemoni. Erekari Matamatakoti oerekaiko hĩte ikinipoko niuãkaã. Himaxinĩkaretakiti iuaĩkanako iua oerekaiko. Ikinipoko nisãpiretakiti oerekaiko. ");
INSERT INTO apuNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","—Nisini apisapanika nikamaerekaxiniretai. Nota xinire ereka inini atokotxikana nikamaerekaxiniretai. Nisãkire mauiãkani kona posotari kamaerekaxiniretiniri ãti nota kamaerekaxiniretini atoko. Kona himaãkapeua. Kona hĩpĩkarauatape. ");
INSERT INTO apuNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Hĩte kenakotapekari nisãkire ia atoko nininii hĩte: “Nisapitikako, iuaritika nikanapiriãpanikako hĩtekata nauini ĩkapani.” Hĩtiretiniãno, hĩpoxokoniuata nirimoni nisini ĩkapani, kotxi poiãori nitxaua nota. Apiatakari itxaua niri. ");
INSERT INTO apuNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ikara nisãpiretakiti apokini apisa nisãpiretai hĩte. Ikara nisãpiretakiti iaõka apokasaaki, hĩte auikari nisãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Apikomoni iteene nisãpiretinii !apakata. Ĩkorapokoriti auakani auĩte Satanasi inakori paĩtiki apokako notamoni, iuaritika !iposotari itxĩkitakinino ipaniãtakiti nikamini. ");
INSERT INTO apuNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Iteene ninirekari imakinika kãkiti imarotiniri nitiretiniri niri. Apaka nikamari ikinipoko niri paniãtakiti —itxa Xesosi. Eereka Xesosi txari: —Maõkitikaua. Masipeka. ");
INSERT INTO apuNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ininiã eereka Xesosi txari: —Atão itĩkaretsa nitxaua nota. Itĩkaretsa nĩkatakari itxaua niri. ");
INSERT INTO apuNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Isauakaro otsa marito, kotxi kona kariro oa. Otsa iriuatakaropekana iua kisauakaro omapotõkirenoka, iteene oriuatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Hĩte poirepeka hĩtxa. Nisãkirenanira oeretai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Okanotsa atokokana hĩtxaua. Nota itĩkaretsa atoko nitxaua. Ininiã hĩpitxaka notamoni. Ikara atoko hininiã, hĩkaikota notakata. Ininiã nota kaikotapika hĩtekata. Ikara atoko hininiã, hĩriuatapitika. Ikara atoko hininiã, erekarinanira hĩkama. Hĩriuatiniã, ininiã erekari hĩkama. Notamoni himapitxakakaniã, kona hĩposotari hĩkaminiri erekari. Kona hĩriuata, kotxi nota tapara !apokari hĩtemoni. !Karii hĩte. Okanotsanoka auiniã, kona kariro. Notakata hãuapininiika hininiã, amãtiiri auapitika. ");
INSERT INTO apuNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","—Nota itĩkaretsa nitxaua. Hĩte nikanotsa hĩtxaua. Notamoni pitakakari ãtipaniriko oripaniko. Notakata himauakaniã, kona xapitiki kona hĩposota hĩkamini. ");
INSERT INTO apuNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nota sãkire mauiãkati okanotsa ipinakari atoko itxa. Txiarokakari atoko itxa. Kãkiti apotiitari okanotsa ipinakari. Eereka okari xaminaã arikini ĩkapani. Iua atokokana aĩri Teoso misiritari isãkire mauiãkani. ");
INSERT INTO apuNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Notamoni hĩpitxakiniã, hĩkenakotiniãri nipaniãtakiti, hinirekaãkiti hamanainiãno, ininiã nisikapitikai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ito hĩriuatiniã, kãkiti txariko niri: “Peerekai.” Hĩte iriuatiniã, ininiã hĩte atão oerekariko apanakinimoni atão nimoianariakori hininiua. ");
INSERT INTO apuNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","—Niri tiretinino atokotxikana, nitiretai hĩte. Kona hĩtakanapapiri nitiraõki. ");
INSERT INTO apuNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Hĩkĩpitiniãri nisãkire, ininiã nitiraõki kaikotapika hĩtekata. Nota atokokanerako hĩtxako. Nota kĩpitari niri sãkire, ininiã niri tiraõki kaikotapika notakata. ");
INSERT INTO apuNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","—Ikara atoko nitxai hĩte, nipoxokoni hĩtemoni kaikotini ĩkapani. Ikara atoko ininiã, poxokonitxi xãpokako hĩxiniremoni. ");
INSERT INTO apuNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ia nipaniãtakiti: “Nota tiretinii atokotxikana, hĩtiretakakauako.” ");
INSERT INTO apuNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Pipininiã pimoianariakori mapinakani ĩkapani, ininiãkara iteene pitiretana ninoa. Ikara tiraõkitxi apiatakari. ");
INSERT INTO apuNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nipaniãtakiti hĩkaminiã, atão nimoianariakori hĩtxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Uatxa !nixinikaikari nitiritxi hininiua, kotxi nitiritxi kona imarotari iauĩte xinikakiti. Uatxa atão nimoianariakori hĩtxaua, kotxi ikinipoko niri oerekakiti nisãpiretapekai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kona hĩteni mereẽno nota. Notara mereẽi hĩte hĩriuatini ĩkapani. Ninirekari hĩriuatini. Ninirekari kãkiti nota sãkire hĩsãpiretakini txipokori maxipokakati atoko ininina. Ikara atoko ininiã, hamanaãriko niri hinirekakiti nota uãkaã, ininiã niri sikapitikai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ia nipaniãtai hĩte hĩtiretakakiniua. ");
INSERT INTO apuNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Iuaĩkana Xesosi pinitari imoianariakori: —Apanakini omanataiko hĩte. Ininiã hĩxinikariko ia nisãkire. Merepitipanika ninoa omanatano nota. ");
INSERT INTO apuNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Teoso sãkire himauikakaniã, Teoso sãkire mauiãkani tiretapitikai hĩte, kotxi ninoa atoko hĩtxa. Txamari ninoa nakiti !hĩtxaua. Hĩte kona ĩkoraxiti auakani !hĩtxaikaua. Nimereẽpekai hĩte. Nimakatxakapekai ãtião parĩkatxi hĩkamini ĩkapani. Iua xika Teoso sãkire mauiãkani omanatai. ");
INSERT INTO apuNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Hĩxinikariko ia nisãpiretakiti. Nitiritxi poiãoka itxaua. Iauĩte apiatakari itxaua. Kãkiti misiritiniãno nota, nota atokokanerako imisiritai hĩte apaka. Nisãpiretapekai hĩte. Nota sãkire apamonĩkiniãna, ininiã hĩte sãkirekanera ninoa apamonĩka apaka. ");
INSERT INTO apuNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Imisiritaina, kotxi hĩte auikari nota sãkire. Himisiritaãkako, kotxi kona imarotarina niokanatakiri. ");
INSERT INTO apuNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nota uai mapokakaniã, nimasãkirauatakaniã, kona imarotarina maerekati ikamakitina. ");
INSERT INTO apuNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nota omanatakani apaka omanatari niri. ");
INSERT INTO apuNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Niposotiire nikamakiti apanakini kona posotari ikamini. Noerekari ninoa niposotiire, ininiã uatxa maerekati auari ninoamoni, kotxi !auikari nota sãkire. Ikinika itikapekari posotiiretxi nikamakiti, iuaritika ninoa omanatano nota, niri apaka. ");
INSERT INTO apuNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","—Uatxa apopeka Teoso sãkire iaõka. Teoso sãkire iõkatsopatakori txari: Maxikatiĩka ninoa omanatano. ");
INSERT INTO apuNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kõtãkikareri kona apokapanika. Niokanatariko nirikata auakari, Erekari Matamatakoti. Iua potorika niri auiniãtaã. Atão ene sãkiretakari itxaua. Isãpiretariko nota sãpiretakiti, nikamakiti pakini. ");
INSERT INTO apuNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ininiã hĩte apaka sãpiretariko nota kamakiti, nisãpiretakiti pakini apanakinimoni, kotxi merepitipanika nipotorikasaaki hĩte auapika notakata. Ininiã himarotapitikano nota. ");
INSERT INTO apuNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Xesosi sãkirauatapanika: —Ikara atoko nitxai hĩte atão himarotini ĩkapani, ininiã kona hĩtakanapari nisãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ãti õti Xoteo auĩteakori omitikenataiko hĩte aiko Xoteo apotiitiniãtaãua. Ãti õti apokapanikako ia nisãpiretakiti. Iuasaaki ninoa xinikariko hĩte okiko ereka inini. Ninoamoni hĩte okiko Teoso paniãtakiti iaõka. Txamari kona Teoso paniãtari ikara atoko inakari. ");
INSERT INTO apuNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ikara atoko inakari ikamanako, kotxi kona imarotano nota, niri pakini. ");
INSERT INTO apuNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ikara atoko nitxai hĩte, kotxi ikara atoko inakari apokasaaki, hĩxinikariko nisãkire. Merepanika nimoianatakasaakii, kona ikara atokoni !nitxai hĩte, kotxi nota auapanika hĩtekata —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Xesosi sãkirauatapanika: —Paĩtiki nisipekako niokanatakirimoni. Kona hĩpimaãpeno: “Nanipa pisa?” Kona hĩtxapeno. ");
INSERT INTO apuNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ikara atoko nisãpiretapekai, ininiã uatxa kona erekaxinirei hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Iuaritika nitxai hĩte atão nisãkire. Apiaerekata nota sini. Nota masikaniã, iua Kõtãkikareri kona apoka hĩtemoni. Nisiniã, niokanatariko iua hĩtemoni. ");
INSERT INTO apuNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Iua Kõtãkikareri apokasaaki, oerekariko ĩkorapokoriti auakani maerekani. Oerekariko Teosonoka txĩkitakiniri kãkiti atão inakari ikamini. Oerekariko kãkiti misiritiko imaerekani xika. Iua Erekari Matamatakoti oerekariko ikara atoko inakari. ");
INSERT INTO apuNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Iua oerekariko maerekati kãkiti kamakiti, kotxi ninoa !auikarina nisãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Iua oerekariko Teosonoka txĩkitakiniri kãkiti atão inakarinoka ikamini, kotxi nota sipekako nirimoni. Nota !auaika uai noerekarauatini ĩkapani. Paĩtiki kona hĩte atamataikanoko nota. ");
INSERT INTO apuNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Iua Erekari Matamatakoti oerekariko maerekati kamakani misiritiko, kotxi ĩkorapokoriti auakani auĩte Satanasi inakori misiritiko mereeẽkapeka. ");
INSERT INTO apuNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","—Auapanika apikomoni nisãpiretakiti tĩkane hĩtemoni. Txamari !apakata apikomoni nisãpiretinii, kotxi !himĩteenekari apikomoni nisãpiretinii. ");
INSERT INTO apuNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Iua Erekari Matamatakoti, atãoene sãpiretakari, iua ĩkasaaki, iua oerekaiko ikinipoko atão sãkiretxiti. Kona iua sãkireni isãpiretaiko hĩte. Iaxiti auakari sãkirera, niri sãkirera, isãpiretaiko. Isãpiretaiko hĩte katana Teoso kamakiti tĩkane apaka. ");
INSERT INTO apuNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Erekari Matamatakoti oerekaiko ereka ninini, kotxi iua apakapariko nisãkire, eereka isãpiretaiko hĩtemoni. ");
INSERT INTO apuNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ikini sereti niri nakiti nota nakiti apaka. Ininiã nota txai hĩte, “Erekari Matamatakoti apakapariko nota nakiti. Ininiã eereka isikai hĩtemoni himarotini ĩkapani.” ");
INSERT INTO apuNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—Paĩtiki kona hãtamataikanoko nota. Eereka iuaĩkana hãtamatanoko, kotxi nirimoni nisako —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Imoianariakori txanãta: —Kiripa itxanãta Xesosi? “Paĩtiki kona hãtamatanoko. Eereka iuaĩkana hãtamatanoko nota, kotxi nirimoni nisako.” Kiripitipa itxanãta Xesosi? —itxana imoianariakori. ");
INSERT INTO apuNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","—Kirisaakipa apokatako ikara inaãtakiti? Kiripa ikara isãkire: “Paĩtiki,” Xesosi sãkire atemoni? Ikara isãkire kona ate imarotari xatiki —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Xesosi imarotari ninoa nirekari ipimainiri iua. Ininiã Xesosi txana: —Hĩte nirekari hĩpimainino nota, kotxi nisãpiretai paĩtiki kona hãtamatinino, eereka iuaĩkana hãtamatano. ");
INSERT INTO apuNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Atãopitikara ia atoko nitxai hĩte. Hĩtxiapatako. Himatinaniuatako. Iuasaaki apanakini kãkiti ĩkorapokoriti auakani poxokoniuatako. Himatinaniuatako, eereka hĩpoxokoni apokapitikako. ");
INSERT INTO apuNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","—Hĩte sito atoko hĩtxauako. Sito oãuaenetanapanoka onakasaaki, oa omaãkapekaua. Imi auaka atoko, kona oxinikaikari otsii. Poxokope otxa, kotxi auapeka amarini. ");
INSERT INTO apuNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ikara atoko itxako hĩtemoni apaka. Uatxa kona erekaxinirei hĩte. Iuaĩkana naõkitapanikaiko hĩte. Iuasaakirako hĩpoxokoniuatako. Iuasaaki kãkiti kona posotari ixipokiniri hĩpoxokoni. ");
INSERT INTO apuNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ĩkora õti apokasaaki, kona hĩpimaãikano nota. Iuasaaki hamanaãri niri hinirekakiti nota uãkaã, ininiã iua sikai hamanaãkiti. ");
INSERT INTO apuNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Uatxapiima kona hamanaãpanikari hinirekakiti nota uãkaã. Hamanainiãri, hãpakapapitikariko. Ininiã hĩpoxokoni apokapitikako hĩtemoni. ");
INSERT INTO apuNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","—Mitxi niomaãtari ipixini nisãkire, kãkiti mimarotakaniri ĩkapani. Ãti õti kona niomaãtaikari atão. Nisãpiretaiko niri iteene himarotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Iuasaaki hinirekakiti hamanaãno nota uãkaã. Kona nota amanaãri niri hinirekakiti isikinii. Hĩte amanainiãri, isikapitikai. ");
INSERT INTO apuNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Niri tiretai hĩte, kotxi hĩte tiretano nota. Hĩte auikari iua iokanatinino nota uaimoni. Ininiã iua tiretapitikai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Niri iokanatano ĩkorapokoriti. Paĩtiki nitakanapari ĩkorapokoriti nirimoni nisini ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Imoianariakori txari: —Uatxa pisãkire atãoenepitika. Sãkiretxi piomaãtakiti kona auaika, kotxi uatxa aimarotari pisãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Uatxa aimarotari pite imarotiniri imakinika. Kona apakata apikomoni apimarauatini, kotxi uatxa aãuikari Teoso auinimoni ĩkari pininiua pite —itxarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Xesosi apakapapiretana: —Uatxa hãuikari nisãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","—Uatxa Teoso ketotiniri manapi apope hĩarikini ĩkapani. Imakinika hĩte takanapanoko. Notanani kaikota. Iuaritika kona notananini kaikota, kotxi niri aua notakata. ");
INSERT INTO apuNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ikara atoko nisãpiretai, kotxi ninirekari erekaxinirepeka hinini. Ĩkorapokoriti hãuakasaaki, kãkiti misiritapitikai hĩte. Iuaritika hĩpoxokoniuatako, kotxi nota tapara apiata. Maerekanitxi tapara poiãoka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Xesosi ionakaãta iaxiti. Iuasaaki isãpiretari ia isãkire Teosomoni: —Niri, piketotini manapi apopeka. Pisikariko piotximere iuaĩkana nota pamaritemoni, ininiãkara nota oerekari kãkiti pite iotximere, ");
INSERT INTO apuNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kotxi pite sikano nota piposotiire ikinimane auĩte nininiua ĩkapani. Ininiã nikamari ikinimane kãkiti pite sikakini auapininiika ininina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kãkiti imarotiniãi pite, imarotiniãno nota Xesosi Kristo piokanatakiti, ninoa auapininiika, kotxi pite atão Teoso pitxaua. Pitenanira atão Teoso pitxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Noerekari ĩkorapokoriti auakani pite Apiananiri pininiua, kotxi nikamapekari parĩkatxi pipaniãtakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ininiã niri, uatxa piotximere pisikano, pitemoni napokasaaki. Itixi kamiko apisapanika pitekata nauakasaaki, niotximere aua. Iua niotximeretxikana pisikano iuaĩkana —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Xesosi sãkirauatapanika irimoni: —Nota sãpiretari piuãka kãkitimoni, ninoa itixi auakani notamoni pisikakini. Mitxi pite nakitiakori itxauana. Pite sikana ninoa notamoni, ininiã ninoa kamari pisãkire iaõka. ");
INSERT INTO apuNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Uatxa imarotarina ikinika napakapakiti pite sikinino. ");
INSERT INTO apuNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nisãpiretapekana ninoa pisãkire, ininiã auikarina pisãkire. Imarotapitikarina pitemoni nipotorikini. Ininiã auikarina pite iokanatinino nota kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","—Nimisãkiretai pite ninoa ĩkapani. Kona nimisãkiretai nota sãkire mauiãkani ĩkapani. Nimisãkiretai ninoa notamoni pisikakini ĩkapaninoka, kotxi pite nakitiakori itxauana. ");
INSERT INTO apuNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ikinika nota nakiti pite nakiti itxaua apaka. Ikinika pite nakiti nota nakiti itxaua. Ninoa pisikakini oerekari apanakini Apiananiri nininiua. Ininiã iuasaaki apanakini txari: “Peerekari Xesosi.” ");
INSERT INTO apuNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Uatxa !nikaikotaikako ĩkorapokoriti. Txamari ninoa kaikotapanika uai. Nota sipekako pitemoni, ininiãkara pinĩkatana ninoa notamoni pisikakini, kotxi pite niri pitxaua, erekarinoka kamakarii pite, kaposotiirei pite. Pite sikaposotiiretano nota. Ninirekari ninoa ãtika atoko ininiuana, nota pitekata ãtika atoko aniniua atokokana. ");
INSERT INTO apuNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Itixi ninoakata nauakasaaki, ninĩkatana ninoa pite uãkaã, piposotiireẽ. Ninoa notamoni pisikakini ninĩkatapitika. Kona ãtika nomaiãta. Xotasinoka pĩpinanaka, kotxi pĩpinanakakani ãkiri itxaua iua. Ipĩpinanaka, kotxi kitxakapirĩka Teoso sãkire iõkatsopatakori sãpiretapekari ikara apokini apisapanika. ");
INSERT INTO apuNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","—Uatxa nota sipeka pitemoni. Ikara atoko itxa nisãkire kãkitikata nauapanika ninakasaaki, nota poxokoni ninoa ãkixinire auini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nisikapekari pisãkire ninoamoni, ininiãkara nisãkire mauiãkani omanatana ninoa, kotxi nisãkire auiãkani ĩkorapokoriti auakani !itxaikauana ninoa. Iua atokotxikana kona ĩkorapokoriti auakarino nota. ");
INSERT INTO apuNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nimisãkiretai pinĩkatinina ninoa, Satanasi mamaĩkakanina ĩkapani. Kona ninirekari mauikareni sauaki auakasaakina pimakatxakinina. ");
INSERT INTO apuNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ĩkorapokoriti auakani !itxauana. Nota iua atokotxikana. ");
INSERT INTO apuNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pimakatxakana ninoa pite nakitiakori ĩkapani. Pisãkireẽ pimakatxakana, kotxi pisãkire atão. ");
INSERT INTO apuNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nota pisãkire mauiãkanimoni piokanatini atokokana, niokanatana ninoa pisãkire mauiãkanimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ninoa ĩkapani notaka nisikaua pitemoni pinirekakiti nikamini ĩkapani. Ininiãkara ninoaka apaka sikaua pitemoni pinirekakiti ikaminina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","—Kona nimoianariakorinani ĩkapanini nimisãkiretai pite. Apaka nimisãkiretai imakinika nisãkire auiãkani ĩkapani, katana nimoianariakori sãkire auiãkani ĩkapani apaka. ");
INSERT INTO apuNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nota amanaãi ninoa xinire ãtika atoko ininina ĩkapani. Nota aua pite ãkixinireẽ. Pitepekana aua nota ãkixinireẽ. Iua atokotxikana ate aua ninoa ãkixinireẽ. Ikara atoko ininiã, nota sãkire mauiãkani ĩkorapokoriti auikapanikariko pite iokanatinino nota. ");
INSERT INTO apuNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ininiã erekari notamoni pisikakiti, piotximere, nisikapekana ninoa. Ininiã ninoa xinire ãtika atoko itxauana, ate ãtika aniniua atokokana itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nota aua ninoa ãkixinireẽ. Pite aua nota ãkixinireẽ. Ikara atoko ininiã peerekari, kotxi ãtika itxaua ixinirena. Ikara atoko ininiã nisãkire mauiãkani imarotariko pite iokanatinino nota. Apaka ninoa imarotari nota pitiretini atokotxikana, pitiretinina ninoa apaka. ");
INSERT INTO apuNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","—Niri, ninirekari ninoa notamoni pisikakini notakata auini ĩkapani. Ninirekari ninoa atamatiniri ikinipoko erekari notamoni pisikakiti, niotximere pisikakiti, kotxi pite tiretano nota itixi kamiko apisa. ");
INSERT INTO apuNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Niri, atão inakarinoka kamakarii pite. Kãkiti ĩkorapokoriti auakani kona imarotai pite. Iuaritika nota imarotai pite. Ninoa imarotari pite iokanatinino nota kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nisãpiretapekai pite kãkitimoni. Apikomoni nisãpiretapanikariko pisãkire. Ininiã pitiraõki notamoni auakari ninoamoni auako. Ininiãkara nota aua ninoa ãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Teoso imisãkiretaka atoko, Xesosi ĩpiriãtari sõtoãri Setorõ inakori. Iuaã aua amãtiirinape. Ininiã Xesosi sari iuaã imoianariakorikata. ");
INSERT INTO apuNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Xotasi, Xesosi mĩkapiritakari, imarotari Xesosi imoianariakorikata itotiniri iuaãtaã isinina. ");
INSERT INTO apuNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ininiã Xotasi sari amãtiirinapemoni ãtikaka sotatoakorikata, Teoso misãkiretiko aikoti nĩkatakanikata. Sasetotxi auĩteakori, pariseoakorikata sari iuaãtaã apaka. Ikeekotxi, tirikapi pakini anikana. ");
INSERT INTO apuNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Xesosi imarotari ikinika iuamoni ikamakitina tĩkane. Imarotapekari ninoa nirekakari okinirina iua. Iuaritika isari ninoamoni. Ipimaãna: —Kiripa hinitanãta? ");
INSERT INTO apuNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ininiã ninoa: —Xesosi Nasareekirira anita —itxana. Ininiã Xesosi: —Iuakarano nota. Iuasaaki Xotasi, Xesosi mĩkapiritakari, aua ninoakata. ");
INSERT INTO apuNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Xesosi “iuakarano nota” inakasaaki, osipikana, ixitipe irika itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iuaĩkana Xesosi pimaãna: —Kipa hinitanãta? —Xesosi Nasareekirira —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Nitxapekai, iuakarano nota. Nota hinitiniã, hãuiritana nimoianariakori sini —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ikara atoko itxa, mitxi isãkire apokini ĩkapani. Mitxi itxari Teosomoni: “Kona nomaiãtana nimoianariakori notamoni pisikakini. Kona ãtika !nomaiãta.” ");
INSERT INTO apuNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Eereka Simão Petro inakori kosekari iouata auĩte. Isauakari Maoko inakori ikikomoni ikĩpita. Iua sasetotxi auĩte apiatakari nitiri. ");
INSERT INTO apuNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Xesosi txari Petro: —Pitakaro iouata auĩte omata ãki. Apakatapitika nota kaminiri niri paniãtakiti. Niri nirekapitikari natatsiitiniri nipinini kãkiti ĩkapani —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Eereka sotatoakori, apaka sotatoakori auĩte, Teoso aikote nĩkatakani pakini maĩkari Xesosi. Iaxirika itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Merepanika anikarina Xesosi Anasi inakorimoni. Iua Anasi Kaipasi imatikiri. Iuasaaki iua Kaipasi sasetotxi auĩte apiatakari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Iua Kaipasi õtãkikapekana Xoteo auĩteakori. Ia atoko itxa isãkire: “Apiaerekata ãti kiki ipinini ikinimane mapĩkani ĩkapani,” itxa Kaipasi õtãkikare. ");
INSERT INTO apuNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simão Petro, ãti Xesosi moianari pakini asikatikinitari Xesosi Anasi aapokomoni anikikosaaki. Mitxipeka sasetotxiakori auĩte apiatakari aõkitapekari iua ãti Xesosi moianari. Ininiã iua ĩroã sasetotxiakori auĩte apiatakari aapoko Xesosikata. ");
INSERT INTO apuNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petro kaikota iporikiti itore takote. Eereka imoianari sari iporikiti. Imisãkiretaro ĩronakikoãtaã tore nĩkatakaro. Ininiã oãuiritari Petro ĩroini. ");
INSERT INTO apuNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Oa txari Petro: —Pite ikira Xesosi moianarikai? —otxari. —Kona —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Iuasaaki katxĩkareri aua, ininiã nitiritxiakori, Teoso misãkiretiko aikoti nĩkatakani pakini kamari xamina. Xamina ĩtinipoki irokanãtauana. Petro ninoakata aua iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Iroko ãki Xesosi sasetotxi auĩteakorikata aua. Ininiã sasetotxiakori auĩte apiatakari misãkiretari Xesosi: —Pisãpiretano pimoianariakori, pisãkire poerekakiti pakini —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Xesosi apakapapiretari: —Ãtipirika nisãpiretapikai hĩte. Nitotari noerekarauatini aiko Xoteo apotiitiniãtaãua, Teoso misãkiretiko aikotiã apaka. Kona nikipatari nisãkire. Ikinipoko kenakotari noereẽkiti. ");
INSERT INTO apuNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ininiã kinirepa hĩpimaãno? Hĩpimaãna nisãkire kenakotakani. Ninoara imarotari noereẽkiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Xesosi ikara atoko isãkirauatakasaaki, Teoso misãkiretiko aikoti nĩkatakari aritoõtari Xesosi. —Atokope. Kona ikara atoko pitxape sasetotxi auĩte apiatakarimoni —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ininiã Xesosi: —Nikerokiniãri nisãkire, pisãpiretano nikerokakiti, txamari kona nikerokari. Atão nisãkire, ininiã kinirepa piaritano? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Eereka Anasi iokanatari Xesosi iaxirikiko. Eereka anikarina sasetotxi auĩte apiatakarimoni, Kaipasi inakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Petro iporikiti aua iuasaaki. Ininiã apanakini pimaãri: —Ikira kiki moianarikai pite? —itxarina. Ininiã iua: —Kona —itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ãti sasetotxi auĩte apiatakari nitiri, Petro kisauakakĩpitatakiti nirimane iua. Iua pimaãri Petro: —Pitekani amãtiirinapeãtaã nitika iuakata? —itxari. Iuaĩkana Petro txari: —Kona notani. ");
INSERT INTO apuNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Iuasaakipeka patari sãkirauata. Iuasaakipeka mitxi Xesosi sãpiretakiti iaõka auape. ");
INSERT INTO apuNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ĩkanõkapanika ninoa takanapari Kaipasi aapoko, Anikarina Xesosi Homano auĩte auinimoni, kãkiti misiritiko imarotiko pakitamoni. Xoteo auĩteakori kona nirekari aiko ãki ĩroinina. Kona inirekarina ãti uãka takote iitopãkinina. Ãti uãka takote iitopãkiniãna, kona apakata nipokori inikinina Páskoa kiiniritiã. ");
INSERT INTO apuNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ininiã Pirato pokĩka porikiti Xoteo imisãkiretini ĩkapani. Ininiã Pirato txana ninoa: —Kixikapa himinatari ikira kiki notamoni? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ininiã ninoa txari: —Maerekati imakamakaniã, kona ate minari iua pitemoni. ");
INSERT INTO apuNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ininiã Pirato: —Hĩteka xinikari maerekati ikamakiti, ininiã ixika auiniã hĩteka misiritari iua. Hĩkiomaneakorini sãkire iaõka himisiritari iua —itxa Pirato. Xoteoakori apakapapiretari: —Kona apakata aõkiniri iua, kotxi hĩte Homanoakori !auiritaua aõkiniri kãkiti. Pitenokara apakata okiniri iua —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ikara atoko inaãka, mitxi Xesosi sãkire iaõka apokini ĩkapani, kotxi mitxi isãpiretapekari aamina ĩpiriãmitakari nopini ipinini. ");
INSERT INTO apuNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pirato ĩroã kãkiti misiritiko imarotiko pakita ãki iuaĩkana. Ipĩkapiretari Xesosi. Ipimaãri: —Pitekani Xoteoakori auĩte txataua? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ininiã Xesosi txari: —Piteka sãkirekani ikara? Atxiĩti apanakini sãkire atokotxikana pipimaãno atxiĩti? —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pirato apakapapiretari: —Xoteokani nitxataua? Konapitini. Piteka nirimane, pinirimane auĩteakori pakini sikai pite notamoni pimisiritiko tĩkane. Kixikapa? Kipa maerekati pikamakiti? —itxa Pirato. ");
INSERT INTO apuNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ininiã Xesosi: —Auĩtetxi nininiãtaãua kona ĩkorapokoritini. Nitixine ĩkorapokoriti inaãkamako, ninitiriakori neenamauatamako, ininiã Xoteoakori kona maĩkamanoko. Auĩtetxi nininiãtaãua ãtiãtaãra —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pirato txari Xesosi: —Ininiã auĩtetxikani pitxataua? Ininiã Xesosi: —Atãopitikara pisãkire auĩtetxi nininiua. Niponaniã ĩkorapokoriti auĩtetxi nininiua ĩkapani. Itixi napoka atãoene nisãpiretini ĩkapani. Atãoene nirekakani auikari nisãkire —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ininiã Pirato: —Kiripa atãoene txaua? Eereka Pirato iuaĩkana mapara isa Xoteoakori imisãkiretini ĩkapani. Itxari: —Kona nota apokari maerekati ikamakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Hĩte itotari maerekati kamakari kateia ãki auakari nisikakini Páskoa kiiniritisaaki. Hĩte nirekatari nisikakiniri ikira Xoteoakori auĩte? —itxa Pirato. ");
INSERT INTO apuNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ikinimanekana akiripoakatana: —Kona iuani. Pahapasira anireka. Txamari iua Pahapasi kokaniri. Iua naiatapekari Homanoakori. ");
INSERT INTO apuNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ininiã Pirato paniãtari sotatoakori noropatiniri Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ininiã sotatoakori kamari saporiẽta atoko inakari, kotipiaro kamakori. Ieretakari Xesosi kiiã. Auĩtetxi mãka poporeri itakana Xesosi nopini. Ikara atoko ininiã, inapetarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ikara atoko itxana inapetinirina: —Aãuĩte —itxarina Xesosi inapetinina. —Xoteo auĩtekai pite —itxarina. Ininiã iuasaaki iaritarina itoõ. ");
INSERT INTO apuNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Iuaĩkana Pirato sari mapara iuaĩkana Xoteoakori imisãkiretini ĩkapani. —Hĩtakaõtxikari. Hĩtemoni niminari iua, kotxi ninirekari himarotiniri, !napokari maerekati ikamakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ininiã Xesosi apoka mapara. Saporiẽta kotipiaro kamakori ikiiã, auĩtetxi mãka pakini aua iuamoni. Ininiã Pirato txari: —Hãtamatari iua. ");
INSERT INTO apuNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sasetotxi auĩteakori, Teoso misãkiretiko aikoti nĩkatakani pakini atamatakasaakiri, ninoa akiripoakata: —Hõkariko iua. Hõkariko iua. Aamina ĩpiriãmitakari nopini hĩtokakitariko —itxana. Ininiã Pirato: —Hĩteka anikari. Hĩteka okari iua aamina ĩpiriãmitakari nopini, kotxi kona napokari maerekati ikamakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ininiã Xoteoakori: —Akiomane sãkire paniãtari kãkiti iua atoko inakari okiko, kotxi iua sãkire: “Teoso ãkirirano nota,” itxa —itxana Xoteoakori Piratomoni. ");
INSERT INTO apuNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Xoteoakori sãkire ikenakotakasaaki, apia pĩkareta Pirato. ");
INSERT INTO apuNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ininiã iuaĩkana ĩroã kãkiti misiritiko imarotiko pakita ãki. Ipimaãri Xesosi: —Nanipa pina? Txamari !kasãkireri Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ininiã Pirato: —Kona pinirekatari pimisãkiretinino? Pixinikariko ia nisãkire. Nota posotari nisikakinii. Apaka nota posotari nokinii aamina ĩpiriãmitakari nopini —itxa Pirato sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Xesosi apakapapiretari: —Kona pite auari posotiiretxi pokinino ĩkapani. Ikara inakari piposotiire auiniã, Teosonanira sikai ikara posotiiretxi. Nota sikanapakani pitemoni kamari apiata maerekati. ");
INSERT INTO apuNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pirato ikara atoko inakari ene ikenakotakasaaki, iua ãkixinireẽ ixinikari: —Kiatokopa atxiĩti nisikakari Xesosi? Inirekari Xesosi isikakini. Txamari Xoteoakori akiripoakata: —Pisikakiniãri ikira kiki, kona Sesa moianari !pitxaikauako. Iua sãkire: “Auĩtetxi apiananiri nitxaua.” Sesanoka auĩtetxi apiananiri —itxana Xoteoakori. ");
INSERT INTO apuNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pirato ikara atoko inakariene ikenakotakasaaki, iminari Xesosi iporikitimoni. Ininiã Pirato topãka. Iuaã kãkiti misiritiko isãpiretiniãtaã. Kãkiti takauãkatari iuaã “Kimapori kai kamakori” inaãka. Xoteo sãkireẽ “Kapataa.” Iuaã auĩtetxi iokanatari maerekati kamakari imisiritikomoni. ");
INSERT INTO apuNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Iuasaaki apaniãxiti takote. Iua õti Páskoa kiiniriti potorikini õti apisa. Iuasaaki Pirato txari Xoteoakorimoni: —Hãtamata, hĩauĩte. ");
INSERT INTO apuNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ininiã iuaĩkana ninoa akiripoakata: —Piokanatariko ere. Piokanatariko ere. Hõkariko aamina ĩpiriãmitakari nopini —itxana sasetotxi auĩteakori. Ininiã Pirato: —Hinirekatari nokiniri hĩauĩte aamina ĩpiriãmitakari nopini? Ininiã ninoa: —Ãtikara ate auĩte. Sesanokara ate auĩte —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ininiã Pirato sikari Xesosi sotatoakorimoni aamina ĩpiriãmitakari nopini okiko tĩkane. Ininiã anikarina Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Xesosi anikari aamina ĩpiriãmitakari iuaka okiko ĩkapani. Isana ixirata “Kiitãtatxi” inakorimoni. Xoteo sãkireẽ, “Kóokota,” inakori. ");
INSERT INTO apuNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Iuaã aamina ĩpiriãmitakari nopini itokakitaãka Xesosi. Apaka ipi kiki tokakitaãka iua takote. Ãti Xesosi kikomoni. Ãti isanaremoni. ");
INSERT INTO apuNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pirato paniãtari iõkatsopari aamina ĩpiriãmitakari nopini tokakitiko. Ia atoko itxa iõkatakiti: “Xesosi Nasareekiri, Xoteoakori Auĩte.” ");
INSERT INTO apuNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Itomaneri Xoteoakori atatsopatari iua, kotxi Xesosi okikoãtaã sitatxi takote. Sitatxi sikani napaãpotakasaaki, atamatarina iua iõkatsopari. Ia iõkataãka Xoteo sãkireẽ, Kreko sãkireẽ, Homano sãkireẽ pakini ikinimane imarotiniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ininiã sasetotxi auĩteakori txari Pirato: —Kona piõkatsopatapiri, “Xoteoakori auĩte.” Piõkatsopatariko iuanoka uãkatari Xoteoakori auĩte ininiua —itxana. ");
INSERT INTO apuNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ininiã Pirato: —Auape niõkatsopatakiti. Kona iuaĩkana niõkatsopatari —itxa Pirato. ");
INSERT INTO apuNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Xesosi itokakitakana atoko, sotatoakori kosekari Xesosi mãka. Imatsorakitarina. Imãka mata imatsorakitana ninoa ipi ipi pakini apakapini ĩkapani. Ãti sotato apakapari ipixini, ãti sotato apakapari ipixini, itxaãpota. Xesosi mãka, ãti imãka patapi auakari, !imatsorakitana, kotxi iotsare !auari. Peerekari. ");
INSERT INTO apuNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sotatoakori itxakakana: —Kona amatsorakitari ia. Sarauatxi atoko makama, imãka anikakari aimarotini ĩkapani. Ininiã iuasaaki Teoso sãkire iõkatsopatakori kitxakapirĩka iaõka apoka. Iua txari: Ninoa xanakari nimãka. Isarauatana nimãka anikakari imarotinina ĩkapani. Teoso sãkire iaõka sotatoakori kama. ");
INSERT INTO apuNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iuasaaki aamina ĩpiriãmitakari takote oãua Maria, Xesosi inoro oĩtarokata. Iuaã apaka oãua Maria Matarena inakoro. Iuaã apaka oãua ãto Maria, Krópasi inakori ĩtanoro. ");
INSERT INTO apuNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Xesosi atamatakasaakiro inoro iua takote, atamatakasaakiri imoianari itiretakiti apaka, itxaro inoro: —Nitiretakito, ere Xoão, pamarite itxaua. ");
INSERT INTO apuNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Imoianaripekana itxa: —Aroa pinoro otxaua. Ininiã eereka iua anikaro oa aapokomoni iuakata oãuini tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Eereka Xesosi imarotari iparĩka xipope. Ikinika Teoso sãkire iõkatsopatakori iaõka apokini ĩkapani, itxari: —Niposonata. ");
INSERT INTO apuNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Iuaãtaã aua tiitxi. Iua tiitxi ãki aua iãriã katxioãri. Ininiã iuasaaki iokomokarina mapoa atoko inakari iãriãmoni. Aãkeẽ itakarina, Xesosi namaã taka itxarina. Iua aãke isopo inakorike. ");
INSERT INTO apuNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iãtaka atoko itxari: —Ikinika niparĩka uatxapeka ixipopeka. Inaãka atoko iokirikiita, iokanata itxari ixinire irimoni. Iuasaakipeka ipina itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iua õti sesta veira, kãkiti tomatiko õti apisa. Xoteo auĩteakori paniãtari Pirato aamina ĩpiriãmitakariã auakani tapike kapatakiko, katima ipĩka ininina ĩkapani, iĩtona makatxakiko ĩkapani apaka. Tomatiko õtisaaki kona ninoa nirekari ipĩkari ĩto kaikotini iuaã. ");
INSERT INTO apuNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ininiã sotatoakori sari iuaã. Ikapatakarina Xesosi takote auakani tapike. ");
INSERT INTO apuNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Txamari sotato atamatakasaakiri Xesosi, !auaika. Ipĩpeka. Ininiãkara kona ikapatakari itapike. ");
INSERT INTO apuNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sotato iorotari Xesosi itanapitaã iomĩtiã. Iuasaaki iarẽka, ãparaã pakini xiketa. ");
INSERT INTO apuNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Notara itikari Xesosi ipinini, ininiã atãopitikara nisãpiretakiti. Nisãpiretari ikinika nitikakiti. Nimarotari nisãkire atão inini, ininiã nisãpiretai ia atatsopatakanii, hĩte apaka auikiniri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Teoso sãkire iõkatsopatakori kitxakapirĩka txari: Kona ãtika iua api !kapatakaãka. Ininiãkara kona Xesosi api kapatakaãka, Teoso sãkire iõkatsopatakori iaõka apokini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ãti Teoso sãkire iõkatsopatakori txari: Ninoa atamatariko iorotakitina. ");
INSERT INTO apuNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Eereka Xosee, Arimateia sitatxitikiri, amanaãri Xesosi ĩto Piratomoni. Iua Xosee auikari Xesosi sãkire, txamari ikipatari Xesosi sãkire auikini, kotxi ipĩkari Xoteo auĩteakori. Amanaãkasaakiri Xesosi ĩto, Pirato txari: —Ari, panikari iua. Ininiã Xosee anikari Xesosi ĩto. ");
INSERT INTO apuNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Iuasaaki imoianari Nikotemo inakori. Iua Nikotemo mitxipeka sari Xesosimoni ĩkanõka imisãkiretiniri ĩkapani. Iua moianatari Xosee, Xesosi ĩto apakapakasaaki. Nikotemo anikari aãtsopa aroesi inakori, miha inakori pakini ikoke Xesosi ĩtoã taãkori tĩkane. Trĩta sĩko kiro pakini iua ikoke anika. ");
INSERT INTO apuNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ninoa ipi iapirikari Xesosi ĩto mãkatxi mataã ikokekata. Ikara atoko Xoteo kamari ipĩkari ĩtoã ikatiko apisa. ");
INSERT INTO apuNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Xesosi aamina ĩpiriãmitakari nopini takikoãtaã, iuaã takote aua amãtiirinape. Amãtiirinapeãtaã aua akauari amanepanika inakari. Kona ipĩkari ĩto takaãkapanika iuaã. ");
INSERT INTO apuNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Iua akauari kona õtakori, ininiã itakarina Xesosi ĩto iuaã, kotxi Xoteo tomatini õti apokanapanoka. ");
INSERT INTO apuNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tomĩko ĩkanõkapanika, Maria Matarena sari akauarimoni. Oãpokasaaki, oãtamatari akauari tore kai auĩte kamakori makatxakapeẽkaika. ");
INSERT INTO apuNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ininiã omiteka Simão Petromoni. Xesosi moianari itiretakitimoni apaka osa. Oãkiritana: —Apiananiri ĩto makatxakaãka akauariã. Kona aimarotari namonireuako itakapirina —otxana. ");
INSERT INTO apuNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ininiã Petro, ãti Xesosi moianarikata sari akauarimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Imitekana. Iua ãti Xesosi moianari miteka katimaritika, ininiã inapari Petro. Ininiã iua apoka Petro apisa. ");
INSERT INTO apuNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Iãka aariko ãki atamatini ĩkapani. Atamatari mãkatxi mata, ipĩkari iapirikiko. Kona iĩroã. ");
INSERT INTO apuNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Iuasaaki Petro apoka iua tikini. Iĩroã aariko ãki. Atamatari mãkatxi mata. ");
INSERT INTO apuNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Atamatari mãkatxi mata, mitxi Xesosi kiiã iapirikiko. Iporiĩmatataãka. Ikikomoni aua ãti mãkatxi mata. Isanaremoni aua ãti mata. ");
INSERT INTO apuNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ininiã iua mitxi apoãkari ĩroã, atamata itxari. Ininiã auikari Maria sãkire. Iuasaakiika auikari Xesosi õkitikiniua. ");
INSERT INTO apuNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Iuasaaki ninoa kona iteene imarotapanikari Teoso sãkire iõkatsopatakori kitxakapirĩkari, kotxi Teoso sãkire sãpiretapekari Xesosi ipinini, eereka õkitikiniua. ");
INSERT INTO apuNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Eereka Petro ãti Xesosi moianarikata kanapiriã aapokomonina. ");
INSERT INTO apuNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria Matarena kaikota aariko iriko takote. Otxiapanãtakasaaki, amaãtiki opapĩkakiita oiãkakiita aariko iriko ãki oãtamatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Oãtamatana ipi Teoso nitiriakori iaxitikini. Imãkana kasarori. Iitopãkana mitxi Xesosi ĩto auiniãtaã. Ãti mitxi Xesosi kii auiniãtaã, ãti mitxi ikiti auiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Itxarona: —Kinirepa pitxiapanãta? —itxana. Ininiã oa: —Imakatxakaãka niauĩte ĩto. Kona nimarotari iĩto takikoãtaã —otxana. ");
INSERT INTO apuNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iuasaaki oporikimoni osapotorika. Oãtamatari Xesosi, txamari !oimarotari. ");
INSERT INTO apuNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ininiã Xesosi: —Kinirepa pitxiapanãta? Kiripa pinita? —itxaro. Ouãkatari Xesosi amãtiirinape nĩkatakari ininiua. Ininiã otxari: —Pite makatxakiniãri iua ĩto, ininiã pisãpiretano iĩto pitakiniãtaã. Ininiã nanikariko ãtiãtaã —otxari. ");
INSERT INTO apuNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ininiã Xesosi txaro: —Maria. Ininiã okirioka iuamoni. Otxari osãkireẽ: —Haponii. Popĩkari sãkireẽ, “Noereẽkiri,” otxa. ");
INSERT INTO apuNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ininiã Xesosi txaro: —Kona pimaãtakapeno, kotxi nirimoni kona nisapanika. Pisa nitariakorimoni. Pitxanako: “Nota sariko nirimoni, hĩte iritxikana apaka. Nisariko niTeosonemoni, hĩTeosonetxikana apaka,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ininiã Maria Matarena sari Xesosi moianariakorimoni: —Natamatapekari aãuĩte —otxana. Ininiã osãpiretana ikinika Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Iua Tomĩko ĩkanõkati Xesosi moianariakori apotiitaua. Iuasaaki itotarina ikinika aapokotxi tore, kotxi ipĩkana Xoteo auĩteakori. Iuasaaki Xesosi tokiã aapokotxi ãki ninoa sauaki. —Erekaxinire hĩtxako —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ikara inaka atoko oerekari iuako karo. Oerekari itanapita karo. Ininiã Xesosi atamatakasaakina, imoianariakori iteene poxokoniuata. ");
INSERT INTO apuNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Iuaĩkana Xesosi txana: —Erekaxinire hĩtxako. Niri iokanatinino atokotxikana, niokanatai hĩte niri nireẽkiti hĩkamini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iuasaaki ixõkana. Itxana: —Hãpakapariko Erekari Matamatakoti. ");
INSERT INTO apuNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Apakata pisãpiretiniri nota sãkire auiãkari, imaerekani makatxakaãkapeka. Apakata pisãpiretiniri nota sãkire mauiãkani, imaerekani !imakatxakaãka —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Xesosi imoianariakorimoni oerekasaakiua, Tomee Txítximo inakori kona aua ninoakata. ");
INSERT INTO apuNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ininiã apanakini sãpiretari Tomee: —Ate aõkitari Xesosi —itxana. Ininiã iua: —Iuako karo nimatamatakaniã, iuako karo nimakaaiakakaniã niuakokiã, kona nauikari hĩte sãkire. Itanapita karo nimakaaiakakaniã, kona nauikari hĩsãkire —itxa Tomee. ");
INSERT INTO apuNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ãti semanati napaka atoko, Xesosi moianariakori apotiitaua iuaĩkana aapokotxi ãki. Iuasaakiika Tomee aua ninoakata. Aapokotxi tore itotaãka, iuaritika Xesosi tokiã ninoamoni: —Erekaxinire hĩtxako —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Iuasaaki itxari Tomee: —Patamata niuako. Pikaaiakariko piuakokiã nitokakitiko karoã. Nitanapita iorotikomoni pitakari piuakoki. Kona mauikaretika !pitxape. Pauikariko nisãkire —itxari. ");
INSERT INTO apuNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ininiã: —Niauĩte, niTeosone —itxa Tomee. ");
INSERT INTO apuNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ininiã Xesosi: —Uatxa pite auikari auãki ninini, kotxi patamatano. Kãkiti nota maõkitakani auikiniãri nisãkire, apakapariko apiata erekari Teoso sikakiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Xesosi kamari apikomoni iposotiire imoianariakori sauaki. Iposotiire ikamakiti imakinika kona iõkatsopataãka ia iõkatsopariã. ");
INSERT INTO apuNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ia niõkatsopata Xesosi Teoso mereẽkiti, Teoso ãkiri ininiua hãuikini ĩkapani. Ikara atoko hãuikiniã, hãuapininiika hĩtxako Xesosi posotiireẽ. ");
INSERT INTO apuNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ãti õti Xesosi oerekaua iuaĩkana imoianariakorimoni ipoa Txiperíatxi inakori tiniã. Ia atoko iua oerekaua: ");
INSERT INTO apuNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Iuaã aua Simão Petro. Iuakata aua Tomee Txítximo inakori. Natanaeo, Kanaa aapokotxitikiri, Kariréia tõpa auakari apaka aua iuakata. Sepeteo anaakori apaka aua iuakata. Apikomoni ipi Xesosi moianariakori apaka aua iuaã. ");
INSERT INTO apuNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simão Petro txana: —Nota okatsaãtako —itxa. Ininiã apanakini: —Ari, ate apaka okatsaãtako pitekata —itxana. Ininiã isana. Kanauaã iereẽtauana. Ĩkanõka okatsaãtana, txamari !imaĩkarina ximaki. ");
INSERT INTO apuNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ĩkanõkapanika Xesosi ikipatxitemoni tĩpokonãta, txamari !imarotarina Xesosi iuaã auini. ");
INSERT INTO apuNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Xesosi akiritana: —Namariteakori, kaiomaãi ereẽ? —itxana. —Kona kaiomaãua —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ininiã Xesosi paniãtana: —Hĩtakariko hetxi hĩkikomoni. Ereẽ hãpokariko ximaki —itxa Xesosi. Ininiã ninoa okari hetxi ikikomonina. Eereka kona iposotaikarina ikosekinirina hetxi kanaua ãki, ximaki itori imaĩkinina xika. ");
INSERT INTO apuNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Xesosi moianari itiretakiti txari Petromoni: —Aãuĩtekara. Ikara inakari sãkiretxiti ikenakotakasaaki, Petro ieretakari imãka, mitxi imakatxakakiti, oka itxaua ipoamoni Xesosimoni isini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Apanakini kanauaã ina. Ikosekaãpotarina hetxi. Iuasaaki ximaki xãpoka hetxiã. Itakoã !ĩtakori, atxiĩti seĩ metronoka. ");
INSERT INTO apuNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ikanĩkiĩtakasaakina, atamatarina xamina. Ximaki iropike nopini auape. Apaka auari komiri. ");
INSERT INTO apuNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Xesosi txana: —Himinari ximaki himaĩkakiti mapake. ");
INSERT INTO apuNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ininiã Petro kosekari hetxi imiriĩ. Xãpoãkata ximaki. Sẽtosĩkoẽta tres ximaki mitapoakari aua. Kaiãopokori ximaki, iuaritika hetxi kona tsorakita. ");
INSERT INTO apuNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Xesosi akiritana: —Uai hina. Manipokota. Kona ãtika imoianari kona kataparaxinire ipimainiri iua: “Kiriparai” ininiri iua, kotxi ninoa imarotari iua Apiananiri ininiua. ");
INSERT INTO apuNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ininiã Xesosi apoka ninoamoni. Ixanakari komiri, ximaki pakini, sika itxana ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ikara õti apisapanika, Xesosi ipinaka atoko, õkitikaua atoko, oerekapekaua ipikata imoianariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Inipokotaka atoko Xesosi pimaãri Simão Petro: —Simão, Xonasi ãkiri, kipa apiata tiretano nota, pitekani, nakirakani? —itxa Xesosi. Ininiã Petro txari: —Ari, Apiananiri, pimarotari nota apokaerekatinii —itxa Petro. Ininiã Xesosi: —Poerekari nisãkire soti auĩte anaakorimoni, ninakitiakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iuaĩkana ipimaãri: —Simão, Xonasi ãkiri, atão pitiretatano nota? —itxa Xesosi. —Ari, Apiananiri, pimarotari napokaerekatinii —itxa Petro. Ininiã Xesosi: —Pinĩkatana soti auĩte, ninakitiakori —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iuaĩkana ipimaãri: —Simão, Xonasi ãkiri, pitiretatano nota? Ininiã Petro matinaniuata ixinireẽ, kotxi Xesosi pimaãri ipi ãti pakinikata “Pitiretatano nota.” Ininiã Petro: —Apiananiri, pite imarotari ikinipoko. Pimarotapitikari nitiretinii pite. Ininiã Xesosi: —Poerekari nisãkire soti auĩte ninakitiakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Atão nitxai. Ãtokoripanika pinakasaaki, piteka pieremãkataua. Pisari pinirekinimoni. Kiomãtxi pinakasaaki, pitamẽkakanoketauako, ininiã ãti ieremãkatai. Eereka anikai pimanirekakanimoni —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ikara atoko Xesosi sãkire, kotxi ikara atoko itxako Petro ipinini. Petro ipinini iteene paxitariko Teoso, ininiã kãkiti txariko: “Peerekari Teoso.” Ininiã Xesosi: —Pikapokitano nota. Ninireẽkiti pikamako —itxa Xesosi Petromoni. ");
INSERT INTO apuNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petro kirioka. Atapari Xesosi moianari, itiretakiti ninoa tikini inini. Iuakara mitxi Xesosikata iitopãka Páskoa kiiniritisaaki. Iuasaaki ipimaãri Xesosi: “Niauĩte, kiripa mĩkapiritai?” ");
INSERT INTO apuNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petro atapakasaakiri Xesosi tiretakiti ninoa tikini inini, ipimaãri Xesosi: —Natokopa itxatako ere ipinini? ");
INSERT INTO apuNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ininiã Xesosi: —Nota nirekiniãri iua auapanika inini nikanapiriãkasaaki, kona nisãpiretai pite. Kona pixinikapiri iua. Pixinikari piteka kaminiri nota nireẽkiti —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ininiã iaripireta Xesosi sãkire auiãkanimoni, iua imoianari itiretakiti imapinakani Xesosi kanapiriini apisa. Txamari Xesosi !isãpiretari imapinakani. Iua txari: “Nota nirekiniãri iua auapanika inini nikanapiriãkasaaki, kona nisãpiretai,” itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nota ikara Xesosi moianari itiretakiti nitxaua. Nota itikari imakinika Xesosi kamakiti. Ininiã nota iõkatsopatari ikamakiti, isãkire pakini. Ininiã aimarotari atão nisãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Auapanika itori Xesosi kamakiti. Ikinika ikamakiti !kaiõkatikopanikari. Ikinika niõkatsopatiniã, !apakata, kotxi itixi kona apakata kaiãopokori aãtsopa auini.");
INSERT INTO apuNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ereẽkai Teópiro, Teoso tiretakari. Merepitipanika niõkatsopatakiti aãtsopaã txari ikinipoko Xesosi kamakiti, isãpiretakiti pakini. ");
INSERT INTO apuNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Niõkatsopatakiti mapotõkire auari Xesosi iaxiti sini pirena. Isini apisa isãpiretana iokanatakini Erekari Matamatakoti paniãtakiti. ");
INSERT INTO apuNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ipinaãka atoko iuaĩkana iuaka oerekaua ninoamoni, ininiã imarotarina atãopitika iua õkitikapekaua. Koarẽta pakini õti iua auanãta ninoakata. Iuasaaki isãpiretana Teoso auĩtetxi ininiãua pirena. ");
INSERT INTO apuNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Imakinika apotiitakasaakiua itxana ninoa: —Kona hĩtakanapapiri Xerosareẽ sitatxiti. Aĩri iaxitikiri iokanaenetakiti hiãtapako. Iua mitxi hĩtemoni nisãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Atãopitikara Xoãoni patxisatai hĩte ãparaaã. Mapaõti napaka atoko, Erekari Matamatakoti apokako hĩtemoni. Iuasaaki hĩpatxisataãkako Erekari Matamatakotiã —itxa Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ininiã imoianariakori apotiitakasaakiua Xesosikata, ipimaãrina iua: —Aãuĩte, uatxa iuaĩkana pisikatari atixine atemoni, Isaeo apika mekaniriakorimoni? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ininiã Xesosi txana ninoa: —Kona hĩte imarotiniri ĩkapanini. Aĩrinanira imarotapaniri hĩte tixine hĩtemoni isikini õti. ");
INSERT INTO apuNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Erekari Matamatakoti apokasaakirako hĩtemoni, hãpakapariko posotiiretxi. Ininiã hĩte nota kamakiti atamatakani hĩtxauako. Hĩsãpiretariko hĩtiãkiti, himarotakiti pakini Xerosareẽ sitatxiti auakanimoni, imakinika Xotéia tõpa auakanimoni, Samaria tõpa auakanimoni, ikini itixiti auakanimoni pakini hĩsãpireãpotariko —itxa Xesosi ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ikara atoko inaãka atoko, ninoa okiã atamatari iua anikiko iaxiti. Katxiãri ãki isa, ininiã kona ninoa itikaikari. ");
INSERT INTO apuNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iaxiti ionakaãtakasaakina, apoka ipi kiki katsopiri mãkatakani ninoa takote. ");
INSERT INTO apuNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ninoa txana: —Kiki Kariréiakini, kinirepa hionakanãta iaxiti? Ĩkora Xesosi iaxiti sikari, isini atokotxikana ikanapiriini —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ininiã Oriva xirataãtaã ipotorikana. Ikanapiriãna. Xerosareẽmoni isana. Oriva kona õtakori. Kãkiti Oriva xirata potorikakani sini Xerosareẽmoni tako atokokanera Xoteo kiomaneakorini auiritari kãkiti sini tomatiko õtisaaki. ");
INSERT INTO apuNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Xerosareẽ sitatxiti apokasaakina, iĩroãna aapokotxi ãki. Ininiã isana itanokiri koaã. Petroma, Xoãoma, Txiakoma, Ãtreema, Piripima, Tomeema, Patoromeoma, Mateoma, Txiakoma (Aopeo ãkiri), Simãoma (Homano omanatakari), Xotasima (ãti Txiako itari) pakini aua iuaãtaã. ");
INSERT INTO apuNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ãtipirika ninoa apotiitaua Teoso imisãkiretinina ĩkapani. Apaka sitoakoro Xesosi sãkire auiãkani, Maria Xesosi inoro, Xesosi itariakori pakini apotiitaua ninoakata. Ninoa misãkiretakasaakiri Teoso, ãtika kãkiti xinirenoka atoko itxana. Ininiã erekarinoka auana ninoamoni. Kona omanatakakauana. ");
INSERT INTO apuNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Iuasaaki sẽtovĩtxi pakini Xesosi sãkire auiãkani aua. Petro õkitikaua ninoa sauaki. ");
INSERT INTO apuNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ininiã itxa: —Nitariakori, hĩtakaõtxikari Teoso sãkire kitxakapirĩka Taviimoni isãpiretakiti. Tavii iõkatsopatari Xotasini pirena, Xesosi maĩkakani oerekakari pirena, kotxi Erekari Matamatakoti kamaimaroretari iua Tavii. Atão ikara Teoso sãkire kitxakapirĩkari apokapeka uatxa. ");
INSERT INTO apuNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iua Xotasini atekata auakari iua. Ate parĩka atoko ikama. ");
INSERT INTO apuNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","—Iuaritika isikari Xesosi imokaiakariakorimoni. Txineiro apakapakitoã iamotaãka itixi. Iuaã ipĩpe. Itano okaua. Ixiti apokasaaki, iokirikiita. Ixoreka itikako. Iuasaaki itikapitsa poãpekatani. ");
INSERT INTO apuNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Imakinika Xerosareẽ auakani kenakopiretari Xotasini ipinini. Ininiã ninoa akiritari iuaãtaã itixi uãka “Aseotama.” Popĩkari akiritari “Arẽkatxi Tixini.” ");
INSERT INTO apuNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","—Xikari iõkatsopatakoriã iõkatsopatapeẽkaika ia Xotasi pirena: Iua aapoko takanapaãkako. Kona auiritaãka kãkiti auini iuaãtaã. Iparĩka sikaãkako ãtimoni, itxa Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","—Ininiã amereẽriko ãti kiki atekata sikari tĩkane. Amereẽriko kiki mitxi Xesosikata sikari, mitxi amoianari ikiniõtika Xesosikata aãuakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Amereẽriko kiki Xoãoni patxisarauatini itiãkari, imakinika Xesosi kamakiti itiãkari, iaxiti isini itiãkari, kotxi anirekari iua amereẽkiti Xesosi õkitikiniua imarotakari ate atoko inakari —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ininiã imereẽrina ipi kiki, Xosee Pasapasi inakori. Apanakini akiritari iua Xósito. Ãti kiki uãka Matxia inakori. ");
INSERT INTO apuNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Iposo atoko imisãkiretarina Teoso: —Pite imarotari ikinimane kãkiti ãkixinire. Poerekaua ĩkiripa naia kiki pimereẽkiti ");
INSERT INTO apuNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","atekata parĩkauatakari tĩkane, Xesosi iokanatakiti tĩkane, kotxi Xotasini takanapari ikara parĩkatxi imaerekani xika, maerekani misiritikoãtaã isini ĩkapani —itxana Teosomoni. ");
INSERT INTO apuNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Iposo atoko ikamarina sarauatxi atoko inakari imoianarina imarotinina ĩkapani. Ikara atoko ininiã, imereẽrina Matxia. Ininiã Xesosi iokanatakiti itxaua. Ikara õti atoko, iua moianatari apanakini õsi Xesosi iokanatakini. ");
INSERT INTO apuNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pẽtekósitxi kiiniriti õti (takari merepitipanika nikiko õti) apokasaaki, Xesosi sãkire auiãkani ãtika kãkiti xinire atoko itxauana. Imakinika apotiitauana. ");
INSERT INTO apuNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Katimaritika iaxiti ĩkari kataparari ĩtimati atoko inakari xãpoka aapokotxi ãki Xesosi moianariakori topãkiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ininiã iuasaaki xamina tirika atoko inakari tokiã. Imakinikana ikiiãna apoka. ");
INSERT INTO apuNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Erekari Matamatakoti ĩroã ikinika ãkixinireẽ. Iuasaakipeka ninoa sãkirauata ãti uãka sãkireẽ, kotxi Erekari Matamatakoti kamaimaroretana. ");
INSERT INTO apuNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Iuasaaki Xerosareẽ sitatxitiã auanãta ikini uãkati kãkiti Xoteoakori. Ninoa Teoso sãkire kĩpitakani. ");
INSERT INTO apuNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ikenakotakasaakirina iaxiti ĩkari ĩtima atoko inakari, apotiitauana mirikiniti kãkiti. Ininiã itikokitatana, kotxi ikenakotarina apanakini sãkirauatini isãkireẽna. ");
INSERT INTO apuNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Itsorĩkaãtana: —Kiãtokopa ininiãpa imarotatarina ate sãkire. Hãtamatana, Kariréiakinikara sãkirauanãta ateka sãkireẽ. ");
INSERT INTO apuNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kiãtokopa itxa akenakotiniri ateka sãkire? —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Iuaãtaã auari kaiãopokori kãkiti ãti uãka. Auari Patxiakinima, Métxiakinima, Erãokinima, Mesopotámiakinima, Xotéiakinima, Kapatósiakinima, Põtokinima, Ásiakinima, ");
INSERT INTO apuNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Piríxiakinima, Pãpíriakinima, Exitokinima, Arípiakinima, Sireni takotekinima, Homakinima pakini aua. Apanakini Homakini atão Xoteoakori. Apanakini mamakaua, ininiã Xoteo itxapekauana. ");
INSERT INTO apuNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kretakinima, Arápiakinima pakini aua iuaã. Ininiã ninoa txa: —Ate kenakotari Kariréiakini sãkirauatini ateka sãkireẽ. Isãpiretarina ikinipoko erekari Teoso Apiananiri kamakiti —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ininiã ninoa tsorĩkaãta. !Imarotarina. —Natokopa itxana imarotinirina ate sãkire? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Apanakini kãkiti napetana: —Poãtakanira ninoa —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Iuasaaki Petro, õsi Xesosi iokanatakinikata misãkiretana iuaã apotiitakaniua. Itxari: —Xotéia auakanii, ikinika Xerosareẽ sitatxiti auakanii, hĩtakaõtxikariko nisãkire himarotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Hĩuãkatana naia kikiakori poãtini. Kona ipoãtana, kotxi atokatxi inaãpotapanika. ");
INSERT INTO apuNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ia uatxa hãtamatakiti kitxakapirĩka Teoso sãpiretapekari Xoeomoni. Iua Xoeo Teoso sãkire sãpiretakari sãpiretapekaua. Iua txari: ");
INSERT INTO apuNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Teoso txari: “Xipokatxi õti iatokopeka inakasaaki, niokanatari Erekari Matamatakoti ikini kãkitimoni. Pamariteakori sãpiretariko nisãkire apanakinimoni. Ãtokoriakori atamatariko itapone atoko inakari Teoso sikakiti pokamarasaaki. Iuasaaki nisãkire nisãpiretana. Kiomãtxiakori taponetariko nota oerekakiti. Iuasaaki nisãpiretariko nisãkire ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ĩkora õtisaaki ninitiriakori, niniteroakoro pakinimoni niokanatari Erekari Matamatakoti. Ninoa sãpiretariko nisãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Iaxiti noerekariko niposotiire kãkiti mimarotakiniti. Ĩkorapokoriti apaka noerekariko niposotiire Apiananiri nininiua imarotinina ĩkapani. Arẽkatxi, xamina, katxiãri pakini apokako. ");
INSERT INTO apuNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Atokatxi piãkako. Kasiri arẽkatxi atoko itxako. Apiananiri apokini apisapanikarako auako ikara atoko inakari. Peerekapaniri Apiananiri apokini õti. Ĩkora õti apiatakari, kotxi iuasaaki Apiananiri oerekauako kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ininiã Apiananiri akiritakani makatxakaãkako imapinakani ĩkapani,” itxa Apiananiri Xoeomoni. ");
INSERT INTO apuNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petro sãkirauatapanika: —Kãkiti, Isaeokini, hĩkenakotariko nisãkire. Hĩte apisatoõ Teoso oerekapekari Xesosi, Nasaree sitatxitikiri. Teoso mereẽkiti itxaua, kotxi ikamari Teoso posotiire kãkiti mimarotakiniti Teoso himarotini ĩkapani. Himarotapekari ikara. ");
INSERT INTO apuNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Xesosi sikaãka imokaiakariakorimoni, kotxi Teoso nirekari ikara atoko iniko. Teoso imarotapekari ikara atoko inakari apokini õti. Hĩtekara, apanakini maerekati kamakanikata maĩkari Xesosi. Aamina ĩpiriãmitakari nopini hĩtokakitari, oka hĩtxapiri iuani. ");
INSERT INTO apuNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Iuaritika ipinaka atoko, iuaĩkana Teoso õkitikari iua. Teoso sikakari iua ipĩkitxi mamisiritakaniri ĩkapani. Ipĩkitxi !iposotari ixipokiniri iua, kotxi Apiananiri itxaua. ");
INSERT INTO apuNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","—Kitxakapirĩka Tavii sãpiretari Xesosi pirena. Itxari: Nota itikapikari Apiananiri nota apisatoõ. Iua aua nikikomoni. Ininiã !nimakatxaãka. ");
INSERT INTO apuNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ininiã nixinire poxokoniuatapeka itxa. Nisãkire poxokoni apaka aua. Niĩto auãki inakasaaki, iãtapari Teoso sikaenetakiti. ");
INSERT INTO apuNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Apiananiri kona takanapano nota ipĩkani auiniãtaã. Apiananiri !auiritano Erekari Kamakari paiakini. ");
INSERT INTO apuNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Apiananiri oerekapekano mapĩkani kimaporite. Iua notakata aua, ininiã nipoxokoniuata, itxa Xesosi Taviimoni kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ininiã Petro sãkirauatapanika: —Kikiakori, hãuiritano nisãpiretiniri Tavii pirena. Tavii anirimane kitxakapirĩka auakari. Iuani ipĩpe, ikatapeẽka. Uatxa atemoni auapanika iua akauare. ");
INSERT INTO apuNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Iua Teoso sãkire sãpiretakari. Atão iua imarotari Teoso sãkire. Teoso sãpiretapekari iua apika mekani Teoso mereẽkiti itxauako. Tavii imarotari Teoso mereẽkiti õkitikaãkapanikako auĩtetxi ininiua tĩkane. Teoso sãpiretari imereẽkiti topãka auĩtetxi itopanere nopini. Ininiã atão auĩtetxi itxaua. ");
INSERT INTO apuNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","—Tavii imarotari ikara atoko inakari Xesosi apokini apisapanika, kotxi iõkatsopatari Xesosi ipinini pirena, iuaĩkana õkitikiniua pirena apaka. Iua txari: Ipĩkani auiniãtaã !ikaikota. Iĩto !ipaiaka, itxa Tavii kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","—Iua Xesosi ipinaka atoko, Teoso õkitikari iua. Ate amakinika Xesosi õkitikiniua itikakani atxaua. ");
INSERT INTO apuNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ininiã uatxaika Xesosi topãka Teoso kikomoni. Ikara atoko Xesosi Apiananiri itxaua. Apakapari Erekari Matamatakoti, Teoso sikaenetakiti. Iposo atoko, iokanatari Erekari Matamatakoti atemoni. Iuakara uatxa hãtamata ikamakiti. Hĩkenakotari iua sãkire uatxa. ");
INSERT INTO apuNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","—Tavii !isari iaxiti auĩtetxi ininiua ĩkapani, iuaritika iõkatsopatari: Apiananiri misãkiretari niauĩte: “Nota kikomoni piitopãkiniritika ");
INSERT INTO apuNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nixipokariko pimokaiakariakori. Nikamariko ninoa pikiti pitakiniãtaã atoko ininiua,” Apiananiri txari niauĩte. ");
INSERT INTO apuNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","—Ininiã Isaeo auakanii, himarotariko ia. Hĩte okari Xesosi, iuaritika Teoso kamari iua auĩtetxi ininiua. Teoso mereẽkiti itxaua —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Iuasaaki Petro sãkire ikenakotakasaakina, ãkixinireẽna tsiĩtxi apoka iouata iorotiniri tsii atoko itxa. Maerekaxiniretinoka itxana. Eereka itxana ninoa: —Kiripa akama? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petro apakapapiretana: —Himaerekani hĩtakanapa. Hĩte imakinika hĩpatxisataãkako Xesosi Kristo uãkaã, ininiã Teoso makatxakari himaerekani. Iuasaakiko hãpakapari Erekari Matamatakoti Teoso sikakiti. ");
INSERT INTO apuNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kotxi ikara Teoso sikaenetakiti hĩte ĩkapani, hamarite ĩkapani, apanakini õtako auakani apaka ĩkapani. Ikara Teoso sikaenetakiti ikinimane kãkiti Teoso akiritakini ĩkapani —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petro iteene õtãkikana ninoa, kotxi inirekari atão ikaminina, ininiã itokata õtãkikana ia atoko: —Ĩkorapokoriti auakani maerekati kamakani itxauana. Himakatxakaua. Hĩtakanapariko himaerekani. Hãuikariko Xesosi sãkire —Petro txana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ĩkora õti, tres mio kãkiti ipoxokoniritikana auikari Petro sãpiretakiti. Iuasaaki ipatxisataãkana. ");
INSERT INTO apuNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eereka ikiniõtika apaiaõkarina Xesosi iokanatakini oerekakiti. Ãtipirika itiretakakauana. Ãtipirika ikamarina kiiniri komiri imapixinikinina Xesosi ipinini ixinikinina ĩkapani. Ãtipirika imisãkiretarina Teoso. ");
INSERT INTO apuNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ikinimane tsorĩkaãnãta, kotxi Xesosi iokanatakini kamari ito posotiiretxi kãkiti mimarotakiniti, apanakini Teoso imarotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Teoso sãkire auiãkani apotiitapikaua. Ninoa xanakari ikinika inakitina. ");
INSERT INTO apuNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ivẽtxitarina itiina, ininiã tiitxi ĩki isikana matxineirotenimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ikiniõtika aiko ãki Teoso misãkiretikoãtaã apotiitapikauana. Ninoa aapoko ãki ikamarina komiri mapixinikiko kiiniriti. Ãtipirika ninoa apotiitaua ipoxokoniritikana nipokori inikinina ĩkapani. Ãkixinirena erekapitikari. ");
INSERT INTO apuNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ixikarauatana Teoso ĩkapani. Imakinika kãkiti apokaerekatana ninoa. Ininiã ikiniõtika Teoso makatxakari kãkiti maerekani. Ininiã Teoso sãkire auiãkani apiaãpota. ");
INSERT INTO apuNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ãti õti mapiãtiki Petro, Xoão pakini sari Teoso misãkiretiko aikotimoni Teoso imisãkiretinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Iuasaaki ikiniõtika kãkiti anikari matĩpokotakati Teoso misãkiretiko aikoti toremoni. Itore uãka “Peereri.” Iuaã matĩpokotakati amanaãri txineiro iuaã napakanimoni. Iponaniãkasaaki matĩpokotakati itxaua iua. ");
INSERT INTO apuNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ininiã Petro, Xoão pakini ĩroãkasaaki, iua amanaãri txineiro: —Txineiro hĩsikano —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ininiã Petro, Xoão apaka atamatari iua. Ininiã Petro txari: —Patamataua. ");
INSERT INTO apuNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ininiã iua matĩkati atamatana ninoa. Iuãkatari txineiro isikinina iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ininiã Petro: —Kona auari txineiro atemoni. Kona pirata aua atemoni. Oro apaka !auari. Iuaritika nota auakiti nisikapitikai. Xesosi, Teoso mereẽkiti, Nasareekiri, iua uãkaã põkitikauako. Pitĩpokotako —Petro txari iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ininiã Petro maĩkari iuako ikikomonikiri õkitikiniua ĩkapani. Iuasaakipeka ikiti, ikitinota pakini kataparapeka itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ininiã okakataua, tĩpokota itxa. Ĩroã Petro, Xoão pakinikata Teoso misãkiretiko aikoti ãki. Iroãkasaaki, okaãpokataua. Itĩpokoãpokata. —Ari, peerekari Teoso —itxanãta. ");
INSERT INTO apuNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ikinimane itikari iua tĩpokotini. Ikenakotari ixikarauatini Teosomoni. ");
INSERT INTO apuNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ikinimane imarotari iua kiki aiko ĩronakikoãtaã “Peereri” inakoriãtaã topãkanãtakari, txineiro amanaãnãtakari iua. Ininiã ninoa: —Anekani. Kiripa atxiĩti? Mitxi matĩpokotakati. Uatxa itĩpokotape. Kanatokopa itxa? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Apanakini kenakopiretana ninoa, ininiã imitekana ninoamoni matĩpokotakati pirena imarotinina ĩkapani. Iuasaaki ninoa auiniãtaã akiritaãka “Saromão pakita.” Iuaã Petro, Xoão pakini aua mitxi matĩpokotakatikata. Iua maĩkakanokeãpotana Petro, Xoão pakini. ");
INSERT INTO apuNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Iua Petro atapana kãkiti ninoamoni ĩkani. Itxana: —Isaeo auakanii, kinirepa hĩte tikoka ere kiki tĩpokotini hãtamatakasaaki? Kinirepa hĩte itikaua ate? Na ate posotiireẽni kamari iua tĩpokotini. Ate ereka anini kona kamari iua tĩpokotini. ");
INSERT INTO apuNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Apraãoni, Isakini, Xakooni pakini Teosone, aĩriakorini kitxakapirĩkarini Teosone, iuara oerekapekaua imi Xesosi ereka inini. Teoso ãkiripitikara itxaua. Iua posotiire auapitika. Iuakara hĩsika okiko ĩkapani. Eereka Pirato inakori nirekasaakiri isikakiniri. Hĩte !inirekari iua sikakiniri Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iuasaaki hĩte kona nirekari erekarinoka kamakari. !Hinirekari iua atão inakarinoka kamakari. Hĩte amanaãri Pirato isikakiniri kokaniri hĩtemoni. ");
INSERT INTO apuNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ininiãkara hĩte okapiri kãkiti auãki inini kamakari. Iuaritika ipĩkani sauaki Teoso õkitikari iua. Ate itikari atãopitikara iua õkitikiniri. ");
INSERT INTO apuNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","—Ia kiki hĩtikakiti himarotakiti kataparapeka itxa, kotxi iua auikari Xesosi posotiire. Iua auikari Xesosi sãkire erekapeka inini ĩkapani. Hãtamatari hĩte apisatoõ iua ereka inini. ");
INSERT INTO apuNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","—Ininiã uatxa nitariakori, nimarotari hĩte, hĩte auĩteakori pakini okapiri Xesosi atão himimarotakani xika. ");
INSERT INTO apuNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kitxakapirĩka Teoso sãkire sãpiretakani oerekapekaua Kristo misiritiko. Ikara imisiritiko auapeka. ");
INSERT INTO apuNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ikara atoko ininiã, hĩtakanapariko himaerekani. Erekari kimaporiti hinitako, ininiã Teoso makatxakari himaerekani. ");
INSERT INTO apuNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Iuasaaki Apiananiri kamapoxokonitai. Isikataparatai. Iuasaaki iua iokanatari Xesosi imereẽkiti hĩtemoni. ");
INSERT INTO apuNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Merepanika iua Xesosi kaikota iaxiti. Teoso kamariko imakinika amaneri. Iuasaaki Xesosi apoka iuaĩkana. Iua atokokana itxana Teoso sãkire sãpiretakani kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kitxakapirĩka Moisesi txari: Apiananiri hĩTeosone iokanatariko isãkire sãpiretakari hĩtemoni nota iokanatini atokokana. Hinirimane itxaua iua. Hĩkenakotariko ikinika isãpiretakiti hĩtemoni. ");
INSERT INTO apuNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ikinimane iua sãkire makenakotakati xipokaãkako. ");
INSERT INTO apuNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","—Teoso sãkire sãpiretakari Samoeo inakori, eereka ikinikana Teoso sãkire sãpiretakani pakini sãpiretapekari Teoso iokanatiniri imereẽkiti kãkitimoni ĩkorasaaki. ");
INSERT INTO apuNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Teoso sãkire sãpiretakani anaakorirai hĩte, ininiãkara isãkire ninoamoni, iuatxikana isãkire hĩtemoni uatxa. Itxari Apraãoni: Ãti pimekaniri sikariko erekari ikini itixiti auakanimoni, itxa Teoso. Ininiã ikara Teoso sikaenetakiti hĩkiomaneakorinimoni, hĩtemoni apaka isikaeneta. ");
INSERT INTO apuNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ininiã Teoso iokanatari iua ãkiri Xesosi hĩtemoni merepitipanika. Iokanatari iua hĩtemoni erekari hĩtemoni isikini ĩkapani, himaerekani hĩtakanapini ĩkapani —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petro, Xoão pakini sãkirauatapanika kãkitimoni inakasaaki, sasetotxiakori, Teoso misãkiretiko aikoti nĩkatakari, satoseoakori pakini apoka ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ininiã ninoa naiataua, kotxi Petro, Xoão pakini sãpiretari kãkiti ipĩkani õkitikiniua pirena, kotxi ninoa txari: —Xesosi ipinaka atoko, iuaĩkana iua õkitikaua, ininiã ipĩkani õkitikauako. ");
INSERT INTO apuNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ininiãkara ninoa maĩkana Xoão, Petro pakini. Iuasaaki mapiãnikata, ininiã itakana kateia ãki ĩkanõka iuaã inapinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Iuaritika itomaneri Petro sãkire kenakotakani auikapiretari iua sãkire. Sĩko mio kikiakori auikari Teoso sãkire Petro sãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Katimatinĩkata Xoteo auĩteakori, kiomãtxiakori, kaiõkatsopareriakori pakini apotiimanetaua Xerosareẽ. ");
INSERT INTO apuNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Sasetotxiakori auĩte apiatakari Anasi inakori iuaã aua. Inirimane Kaipasi inakori, Xoão inakori, Arexãtri inakori pakini aua iuaã apanakini sasetotxiakori auĩte nirimanekata. ");
INSERT INTO apuNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Xoão, Petro pakini minaãka ninoa apisatoõ. Ipimaãrina: —Kiposotiireẽpa hõkitikari matĩpokotakati? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Erekari Matamatakoti moianatari Petro. Ininiã iua txana ninoa: —Aãuĩteakori, akiomaneakori, ");
INSERT INTO apuNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","hinirekari asãpiretinii uatxa erekari akamakiti matĩkatimoni. Hinirekari himarotiniri erekapeka inini. ");
INSERT INTO apuNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ininiã ikinika hĩte, ikinika Isaeo tixini auakani apaka, himarotariko ia. Xesosi Nasareekiri posotiireẽra ia kiki hĩte apisatoõ timakari makananitaãka. Iuara hĩte oka aamina ĩpiriãmitakari nopini. Iuara Teoso õkitika iuaĩkana ipĩkani sauaki. ");
INSERT INTO apuNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kitxakapirĩka Teoso sãkire iõkatsopatakori sãpiretari Xesosi hĩte manirekakani, kotxi itxari: Kai aapokotxi kamakanii, !hinirekari ãti kai soro. Iua kai himanirekakiniti apiari itxapekaua. Apanakini kai soro maĩkakari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","—Xesosinokara makatxakari kãkiti maerekani. Kona ãti maerekanitxi makatxakakari !auari ikini itixiti. Teoso sikari iuanokara kãkitimoni imaerekani imakatxakini ĩkapani —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ninoa tsorĩkaãnãtana Petro sãkire ikenakotakasaakina, kotxi Petro, Xoão pakini sãkirauata itaparaxinireritika. Mitxi kona ninoa apaiaõkarauata, iuaritika ninoa imarotari atão isãkirauatini. Ninoa xinikari: —Ixi. Ninoa minakani. Iuaritika kiĩkitena, kotxi Xesosi moianariakori itxauana —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ininiã !kasãkirena, kotxi matĩkati tĩpokotapeka ninoa apisatoõ. ");
INSERT INTO apuNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ininiã ipaniãtana Petro, Xoão pakini mapara isinina, ninoa auĩtetxiakori ininimoniuana isãkirauatinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ininiã auĩtetxiakori txari: —Kanatokopa atxatana ninoa? Kotxi ikinimane Xerosareẽ auakani imarotari itxĩkitakinirina matĩkati erekape inini. Atãopitikara ninoa kamari posotiiretxi. !Aposotari akipatiniri ia sãkiretxiti, kotxi ikinipoko imarotapekari matĩkati tĩpokotini. ");
INSERT INTO apuNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kona anirekari ikara pirena apikomoni iaripiretini kãkiti sauaki. Ininiã atxanako ninoa: “Na apikomoni Xesosi pirena hĩsãpiretapinikariko.” ");
INSERT INTO apuNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ininiã iuaĩkana akiritana. Eereka itxana: —Kona hĩsãpiretapinikariko apikomoni Xesosi pirena. Kona hõerekapiriko iuaĩkana Xesosi pirena —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ininiã Petro, Xoão pakini apakapapiretana: —Kiripa atão akĩpitini? Hĩtekani? Teosokani? Kipa erekari? Hĩte mereẽri. ");
INSERT INTO apuNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kona aposotari atakanapiniri asãpiretiniri aĩtikakiti, akenakotakiti pakini —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ininiã iuaĩkana auĩtetxiakori txitana. Iposo atoko auiritana isinina, kotxi maerekati !ikamana. !Imisiritana, kotxi ipĩkarina kãkiti. Ikinimane kãkiti txari: —Peerekari Teoso kamakiti matĩkati ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ĩkora kiki makananitakori koarẽta anope iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Xoão, Petro pakini sikakikosaaki, ninoa kanapiriã imoianariakorimoni. Ikinika sasetotxi auĩteakori sãkire, kiomãtxiakori sãkire pakini ikinika isãpiretana. ");
INSERT INTO apuNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ikara ikenakotakasaakina, ikinikana misãkiretari Teoso. Ininiã itxana: —Apiananiri, ikinika posotiiretxi auari pitemoni. Pitenanira Teoso pitxaua. Pite kamari iaxiti, itixi, potxoari uiniti pakini. Imakinika iaxiti auakani, itixi auakani, potxoari uiniti auakani pakini pikama. ");
INSERT INTO apuNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kitxakapirĩka Erekari Matamatakoti kamaimaroretari pinitiri aãtokiri Tavii. Ininiã itxari: Kinirepa kãkiti Teoso manirekaãkani omanãkarauata? Kinirepa kãkiti maxikatiĩka xinikari maerekati ikamini ãtimoni? ");
INSERT INTO apuNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Auĩtetxiakori apotiitaua neenamatxi ikaminina ĩkapani. Ninoa apotiitaua Apiananiri inaiatinina ĩkapani, imereẽkiti apaka inaiatinina ĩkapani, itxa Tavii. ");
INSERT INTO apuNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","—Atãopitikara Erotxi, Põsio Pirato pakini apotiitaua Xoteo minakonikata, Xoteoakori pakinikata. Ninoa apotiitaua uai ia sitatxitiã. Isãkirauatana pamarite Xesosi okinina ĩkapani. Txamari pite mereẽri iua erekarinoka kamakari. ");
INSERT INTO apuNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mitxi pite imarotari imakinika ninoa kamakiti tĩkane. Kãkiti kamari pinirekakiti, kotxi kaposotiirei. ");
INSERT INTO apuNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ininiã aãuĩte, pixinikariko ikara maerekapirenati. Pisikataparaxiniretaua ate pinitiriakoriua pisãkire asãpiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pamarite erekari kamakari Xesosi posotiireẽ pimakananitanako amianatakani. Kãkiti maposotakiniti pikamako. Posotiiretxi pikamako pisãkire aõerekini ĩkapani. Ikara pikamako pamarite Xesosi posotiireẽ —itxana ninoa Teosomoni. ");
INSERT INTO apuNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Teoso imisãkiretaãkana atoko, ninoa apotiitiniãtaãua iakeka. Erekari Matamatakoti apoka ikinimanemoni. Ininiã itaparaxinireritikana isãpiretarina Teoso sãkire kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ikinika Teoso sãkire auiãkani ãtika kãkiti xinire atoko itxauana. Kona itxana: “Nota nakitira ia,” kona itxana. Kapotxinaniri !auari. Ninoa xanakari ikinika itiina. ");
INSERT INTO apuNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Xesosi iokanatakini itaparaxinireritikana txari ikinimanemoni: —Xesosi Apiananiri iuaĩkana õkitikaua ipinaka atoko. Ate imarotari, kotxi ate aõkitari iua ipinaka atoko —itxana kãkitimoni. Ininiãkara Teoso sikari ikinika erekari ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ninoa sauaki tiitxi amonitakari !auari. Kikio ipi auiniãri, kakikioteri vẽtxitari ãtika. Aapokotxi ipi auiniãri, kaapokori vẽtxitari ãtika. Oa txineiro ninoa sika ");
INSERT INTO apuNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Xesosi iokanatakinimoni. Eereka ninoa xanakaro oa txineiro matiitinimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iuasaaki aua Xosee. Sasetotxi, Arevii apika mekaniri itxaua. Xipri inakori pokomiriĩtikiri iua. Xesosi iokanatakini takauãkatari iua Panapee inaãka. Popĩkari sãkireẽ iuãka: “Kasikapoxokoniri,” kotxi ãtipirika isikapoxokonitari kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Iua vẽtxitari ãtika ikikiote. Iua kikio ĩki isika Xesosi iokanatakinimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Iuasaaki auari Ananíasi inakori, ĩtanoro Sapira inakoro pakini. Iua vẽtxitari kikio. ");
INSERT INTO apuNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ikaikotakaro ipixini kikio ĩki. Ipixininoka isika Xesosi iokanatakinimoni. Sapira imarotari õtaniri kamakiti. Txamari iua sikasaakiro oa txineiro Xesosi iokanatakinimoni, itxari: —Ikinika kikio ĩki asika Teosomoni —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Iuasaaki Petro txari: —Ananíasi, kinirepa pauiritari Satanasi misirienetinii maerekati pikamini ĩkapani? Erekari Matamatakotira pimisirieneta, kotxi ipixini kikio ĩki kaikota pitekata. Kinirepa pisãpiretari ikinika txineiro pisikini Teosomoni? ");
INSERT INTO apuNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kikio pivẽtxitini apisapanika, ĩkora kikio pite nakiti. Eereka pivẽtxitakasaakiri, õkora txineiro pite nakito. Ininiã kinirepa pitxari: “Ikinika nisika Teosomoni?” Kona kãkitini pimisirieneta. Teosora pimisirieneta —Petro txari. ");
INSERT INTO apuNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Iuasaakipeka Ananíasi iripe. Ipĩpe. Ininiã ikara kenakotakani pĩkarauakata. ");
INSERT INTO apuNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Iuasaaki ãtokoriakori iapirikari Ananíasini ĩto mãkatxi mataã ikatinirina ĩkapani. Eereka anikarina, kata itxarina iuani. ");
INSERT INTO apuNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ipi oara, ãti oara pakini napaka atoko iua ĩtanoro apoka. Kona oimarotapanikari oĩtanirini ipinini. ");
INSERT INTO apuNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ininiã Petro txaro: —Pisãpiretano. Oia txineironokani hĩkikiote ĩki hãpakapakito aua? Atão pisãpiretano? —itxaro. Ininiã oa: —Ari aroanokara ate apakapakito aua —otxari. ");
INSERT INTO apuNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ininiã Petro: —Hĩte uãkatatari Erekari Matamatakoti auiritai himisirienetiniri iua? Uatxaika ĩronakikoãtaã pĩtanirini katakani apokapeka. Ininiã ninoa anikapitikai pite apaka —itxaro. ");
INSERT INTO apuNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Iuasaakipeka oĩripe, pĩpe otxa. Iuaĩkana ninoa ãtokoriakori ĩroã. Apokarona oani, ininiã anikarona. Ikatarona õtanirini takote. ");
INSERT INTO apuNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ininiã ikinipoko Xesosi sãkire auiãkani, apanakini ikara kenakoenetakani pakini pĩkarauata. ");
INSERT INTO apuNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Iuasaaki Xesosi iokanatakini kamanãtari posotiiretxi, kãkiti mimarotakiniti pakini kãkiti sauaki. Ikiniõtika Xesosi sãkire auiãkani apotiitaua Teoso misãkiretikoãtaã, “Saromão pakita” akiritakori. ");
INSERT INTO apuNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Xesosi sãkire mauiãkani apokaerekatana ninoa, txamari ipĩkarena xika !inirekarina imoianatinina. ");
INSERT INTO apuNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Iuaritika apikomoni kãkiti apotiiãpotaua ninoakata, kotxi kikiakori, sitoakoro pakini auikari Apiananiri sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Iuasaaki Xesosi iokanatakini makananitana amianatakani, ininiãkara kãkiti anikana amianatakani kimaporimoni. Sirimatatxi nopini itakana ninoa kimaporiãtaã. Ininiã kãkiti xinikari: “Petro napakasaaki, isanõka amianatakanimoni apokiniã, imakananitaãkana.” ");
INSERT INTO apuNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ininiã kaiãopokori kãkiti Xerosareẽ takotekini apoka. Ninoa minana amianatakani, apaka kãkiti maerekani matamatakoni misiritakini pakini. Ininiã Xesosi iokanatakini makananitana imakinikana. ");
INSERT INTO apuNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Iuasaaki sasetotxi auĩte apiatakari, imoianariakorikata, satoseoakorikata xikotana Xesosi iokanatakini. ");
INSERT INTO apuNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ininiã ninoa maĩkana. Eereka kateia ãki taka itxapena ninoa. ");
INSERT INTO apuNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Iua ĩkanõkati Teoso nitiri iaxitikiri matakakari kateia tore. Eereka anika itxana iporikiti. Itxana: ");
INSERT INTO apuNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Hĩsa Teoso misãkiretiko aikotimoni. Iuaã hĩsãpiretariko Teoso sãkire kãkitimoni kãkiti auini amaneri inini ĩkapani —itxa Teoso nitiri. ");
INSERT INTO apuNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ininiã ĩkanõkapanika ninoa sari Teoso misãkiretiko aikotimoni. Teoso nitiri sãkire iaõka ikamana. Iuaã isãpiretarina Teoso sãkire kãkitimoni. Iuasaaki sasetotxi auĩte apiatakari, imoianariakorikata pĩkapiretana Xoteoakori kõtãkikarerini, Xoteo kiomaneakori pakini, ininiã imakinika ninoa apakĩtakana Xesosi iokanatakini. ");
INSERT INTO apuNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ininiã apanakini sari kateiamoni apinina ĩkapani. Txamari apokasaakina iuaã, !auaikana Xesosi iokanatakini. Ininiã ikanapiriãna auĩtetxiakorimoni isãpiretinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ininiã itxana: —Ate apokasaaki kateia tore, itotaãkapanika. Kateia nĩkatakani auanãta itore takote. Txamari itore amatakakasaaki, kãkiti !auaika iriko ãki —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ininiã sasetotxi auĩte apiatakari, Teoso aikote nĩkatakani auĩte, sasetotxiakori pakini kenakoenetakasaakiri ikara sãkiretxiti: —Anekani? Nãpa ninoa atxiĩti? Kiripa apikomoni auatako? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Iuasaakipeka kiki apoka. Isãpiretana: —Hĩkenakotariko nisãkire. Ninoa kikiakori kateia ãki hĩtakakini Teoso misãkiretiko aikoti ãki aua. Oerekanãtarina Teoso sãkire kãkitimoni —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ininiã Teoso misãkiretiko aikoti nĩkatakani auĩte, initiriakorikata sari iuaã. Ninoa minana Xesosi iokanatakini iuaĩkana auĩtetxiakorimoni. Imaĩkasaakina, kona iaritatana, kotxi ipĩkarina kãkiti kai soroã kiporonakinina. ");
INSERT INTO apuNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ninoa apokasaaki, ipaniãtana Xesosi iokanatakini Xoteoakori kõtãkikarerini apisatoõ itiminina. Sasetotxi auĩte apiatakari txana: ");
INSERT INTO apuNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Mitxi ate paniãtai Xesosi sãkire himasãpiretakani kãkitimoni. Txamari hõerekapanikari iua sãkire ikinimane Xerosareẽ auakanimoni. Ate xika Xesosi ipina, hĩtxanãta ikinimanemoni —itxa sasetotxi auĩte. ");
INSERT INTO apuNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ininiã Petro, apanakini Xesosi iokanatakinikata apakapapiretari: —Ate kĩpitari Teoso paniãtakiti. Kona kãkiti paniãtakitini akĩpita. ");
INSERT INTO apuNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Teoso, akiomaneakorini Teosone, õkitikari Xesosi iuaĩkana auini ĩkapani. Hĩtera okari iua Xesosi aamina ĩpiriãmitakari nopini. ");
INSERT INTO apuNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Iuaritika Teoso takari Xesosi ikikomoni. Itxĩkitakari iua auĩtetxi ininiua. Kãkiti maerekani makatxaãkari itxaua. Ininiã Isaeo auakani takanapiniãri imaerekani, Xesosi makatxakari ninoa maerekani. ");
INSERT INTO apuNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ikara ate imarota. Apaka Erekari Matamatakoti imarotari ikara. Teoso sikari iua Erekari Matamatakoti isãkire kĩpitakanimoni —itxa Petro ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ikara ikenakotakasaakina, iteene omanãkarauatana. Ininiã ninoa: —Mãokana —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Iuasaaki Kamarieo inakori õkitikaua kõtãkikarerini sauaki. Pariseo itxaua. Teoso paniãtakiti oerekakari itxaua. Ikinimane paxitari iua. Ininiã iua txari: —Hanikana naia mapara atenoka asãkirauatini ĩkapani —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ininiã eereka itxana: —Isaeo tixini auakanii, hiĩkitetariko hĩkamakiti ninoa Xesosi moianariakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Akokaxiti auari Teota inakori. Iua txari: “Auĩtetxi apiatakari nitxaua nota,” itxa. Iuasaaki koatrosẽtosi kikiakori moianatari iua. Auikarina iua sãkire. Txamari okapeẽka iuani. Eereka iuakata sikani iarikape. Iua auĩtetxi ininiua xipope. Isãkire !auikaãkaika. ");
INSERT INTO apuNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","—Teotani ipinaka atoko Xotasi Kariréiakiri apoka. Iuasaaki auĩtetxiakori iaõtari ikinimane kãkiti. Kaiãopokori kãkiti auikari iua Xotasi sãkire, ininiã ninoa moianatari iua. Iua Xotasi imoianariakorikata nirekari ixipokinina auĩtetxiakori. Txamari iua apaka okapeẽka, ininiã imoianariakori iarikape. ");
INSERT INTO apuNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","—Ininiã uatxaikara nõtãkikai hĩte: “Hĩtakanapanako ninoa Xesosi iokanatakini. Hĩsikakanako ninoa, kotxi atxiĩti ninoa !ikamari Teoso paniãtakiti, ininiã paĩtiki ninoa sãkire apaka !auaika. ");
INSERT INTO apuNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Txamari, ninoa kaminiãri Teoso paniãtakiti, erepaniko, kotxi atxiĩti hinaiatari Teoso” —itxa Kamarieo. Iuasaaki ninoa Xoteo õtãkikakani kĩpitari Kamarieo sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Akiritana Xesosi iokanatakini iuaĩkana iĩroinina. Ipaniãtari ninoa xirokitatiko. Ininiã ninoa: —Xesosi sãkire kona hĩsãpiretapinikako —itxana. Eereka sikaka itxana isinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Isikasaakina, ipoxokoniuatana. —Teoso apokaerekataua ate, kotxi auiritari amisiritiko Xesosi sãkire aãuikini xika —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ininiã ikiniõtika oerekarauatana Teoso misãkiretiko aikoti ãki, kãkiti aapoko ãki apaka. Isãpiretarina erekari pirena Xesosi Teoso mereẽkiti ininiua pirena. ");
INSERT INTO apuNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Xesosi sãkire auiãkani apiaãpota. Iuasaaki Xoteoakori Kreko sãkire imarotakani taparakienatana apanakini Xoteoakori. Itxana: —Atekata auakani sitoakoro tikinitakoni kona apakapari nipokori ikiniõtika apanakini tikinitakoni apakapiniri atoko —itxana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ininiã Xesosi iokanatakini tosi pakini pĩkapiretana ikinimane Xesosi sãkire auiãkani. Itxana: —Kona erekari ate takanapiniri Teoso sãkire aõerekini asikakienarauatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ininiã setxi kikiakori himereẽko, ikara parĩkatxi ikaminina ĩkapani. Himereẽna Erekari Matamatakoti paniãtakitinoka kamakani. Himereẽna kimarorerini. Ininiã asikana ia parĩkatxi ikaminina, sitoakoro tikinitakoni isikakienatinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ininiã atepekana, Teoso amisãkireta. Isãkire aõereka. Ikaranoka akamako ikiniõtika —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ikinimane Xesosi sãkire auiãkani apokaerekatari Xesosi iokanatakini sãkire, ininiã ninoa mereẽri Estevão. Iua iteene auikari Teoso sãkire. Erekari Matamatakoti paniãtakitinokara ikama. Apaka imereẽna Piripima, Porókoroma, Nikanooma, Tximoma, Pamenama, Nikoraoma pakini. Iua Nikorao Ãtxiokiakiri itxaua. Mitxi Xoteo minakatiua iua, eereka imamakaua. Xoteopeka itxapekaua. ");
INSERT INTO apuNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Xesosi sãkire auiãkani minana ninoa Xesosi iokanatakinimoni. Ininiã Xesosi iokanatakini misãkiretari Teoso. Iuakona itakana ninoa nopini, ikara Teoso parĩka ikaminina tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ikara atoko ininiã, Teoso sãkire iaripireta apikoxiti. Ininiã mokatanitika kaiãori Xerosareẽ auakani auikari Xesosi sãkire. Ito sasetotxiakori apaka kĩpitari Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estevão iteene auikari Xesosi sãkire. Teoso posotiire aua iuamoni. Kaposotiireri iua, ininiã ikamari kãkiti mimarotakiniti. Ikamari posotiiretxi, Teoso posotiire oerekini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Txamari ãtikaka kikiakori !inirekari iua. Ninoa ãti Xoteo apotiitiniãtaãua aikoti sikani. Ninoa “Ninoaka nireẽkiti kamakani” akiritaãkana. Ninoa Sireni sitatxitikini, Arexãtria sitatxitikini, Sirísia tixinikini, Ásia tixinikini pakini. Ninoa iteene misãkiretakakaua Estevãokata, kotxi !auikarina iua sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Txamari Estevão sãkirauataka atoko, !kasãkireikana, kotxi Erekari Matamatakoti sikaimaroretari iua Estevão. ");
INSERT INTO apuNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ininiã ninoa sikari txineiro apanakini kikiakorimoni Estevão apoĩtinina ĩkapani. Ininiã ninoa txineiro apakapakani txari: —Ate kenakotari iua, Moisesini imisãkirepiretini, Teoso apaka imisãkirepiretini —itxana. Txamari na atãoni isãkirena. ");
INSERT INTO apuNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ikara isãkirena xika, kiomãtxiakori, kaiõkatsopareriakori, apanakini kãkiti pakini naiataua, ininiãkara imaĩkarina Estevão, kõtãkikarerinimoni anika itxarina iua. ");
INSERT INTO apuNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Eereka iminana apanakini, Estevão imisãkirepiretinina ĩkapani. Ninoa txari: —Ia kiki misãkirepiretapikari Teoso misãkiretiko aikoti. Apaka kona inirekari Moisesi paniãtakiti. ");
INSERT INTO apuNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ate kenakotari iua sãkire: “Xesosi Nasareekiri xipokariko Teoso misãkiretiko aikoti. Ixipokariko akiomaneakorini sãkire Moisesini paniãtakiti.” Ikara atoko aãpirena ikamana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ikinimane ninoa kãkiti õtãkikakani atamatari Estevão toõ. Teoso nitiri iaxitikiri toõ atokokana itxa Estevão toõ. ");
INSERT INTO apuNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ininiã sasetotxiakori auĩte apiatakari txari Estevão: —Atãokani ninoa sãkire? ");
INSERT INTO apuNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Estevão txari: —Nikiomaneakori, nitariakori pakini, hĩkenakotanoko. Teoso iaxitikiri oerekaua aãtokirini Apraãonimoni. Mesopotámia tixini auakasaaki, Araã tixini auini apisapanika, Teoso motika iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Iuasaaki Teoso txari iua: “Pitakanapariko pitixine, pinirimane pakini. Ãti tixinimoni pisako. Noerekinimoni pisako,” itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ininiã sipe itxa Apraão. Itakanapari Kaotéia inakori tixini. Araã tixinimoni iua sipe. Araã auakasaaki irini ipĩpe. Irini ipinaka atoko, Teoso mĩpiri iua uaimoni uatxa aãuiniãtaã. ");
INSERT INTO apuNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Apraão auakasaaki, Teoso !isikari uai tõpa iuamoni iua nakiti inini ĩkapani. Kona ipixini metro isika iuamoni inakiti inini ĩkapani. Isikaenetari uai tõpa iua, imekaniriakori pakinimoni. Txamari !keeneri iua iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Teoso txari Apraãomoni: “Pamariteni, pimekaniriakori, papika mekaniriakori auako ãti kãkiti tixine. Iuaãrako imisiritapeẽkanako koatrosẽtosi anokanani. Iparĩkauatana apanakini ĩkapani maxikatiĩka. Ininiã iteene imisiritiko aua.” ");
INSERT INTO apuNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","—“Ininiãkara nimisiritariko ninoa misiritakani. Eereka Apraão apika mekaniriakori takanapariko iuaã, uaimoni kanapiriã itxanako. Ininiã ĩkorapokoriti ninoa parĩkauatako nota ĩkapani,” itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ininiã Teoso txari: “Hĩte kitsotakariko ikini hamariteni tsiki mata. Ikara nitakaõtxikare hãtamatakasaaki, hĩxinikariko nisikaenetakiti,” itxa Teoso. Eereka Apraão ãkiri aua, Isaki inakori. Oito õtipeka auini õti inakasaaki, Apraão kitsotakari itsiki mata. Isaki aneẽkasaaki, imi Xakoo inakori aua. Eereka Xakoo anaakori auapeka tosi pakini. Ikara tosi imiakori aãtokiriakorini iriakori itxauana. ");
INSERT INTO apuNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","—Xakoo anaakori xikotari itarina Xosee inakori. Ininiã itariakori vẽtxitari iua Exito sikanimoni. Iuaritika Teoso auapika iuakata. ");
INSERT INTO apuNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Imisiritiko auakasaaki, Teoso moianatari iua imapinakani ĩkapani. Iuasaaki Exito auakani auĩte Paraoo inakori. Teoso sikaimaroretari Xosee, ininiã Paraoo potxitari iua, ininiã Paraoo txari iua: “Exito auakani auĩte pitxauako. Naapoko auakani pinĩkata apaka,” itxa Paraoo Xoseemoni. ");
INSERT INTO apuNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","—Eereka makienanitxi aua Exito tixiniã, Kanaaã tixiniã apaka, ininiã ikinimane natxita. Aãtokiriakorini apaka !auari nipokori. !Apokari nipokori. ");
INSERT INTO apuNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ininiã Xakoo kenakoenetari triko auini Exito tixini. Ininiã ipaniãtana tesi imiakori Exito tixinimoni isinina. Mitxi !isana Exitomoni. ");
INSERT INTO apuNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","—Ininiã iuaĩkana ãti õti isana Exitomoni, kienatxi iamotinina ĩkapani. Iuasaaki Xosee oerekaua ninoamoni. Iuasaaki Paraoo imarotari Xosee nirimane. ");
INSERT INTO apuNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ininiã Xosee pĩkapiretari iri Xakoo, itariakorikata, inirimanekata. Setẽta sĩko pakini kãkiti sari Exito tixinimoni, kotxi aua ikinipoko nipokori iuaã. ");
INSERT INTO apuNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","—Ininiã Xakoo apanakinikata sari Exitomoni. Iuaã mapakanani atoko Xakooni ipĩpe. Eereka aãtokiriakorini ipina iuaãtaã apaka. ");
INSERT INTO apuNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ninoa ipĩkasaakina, iĩtona anikapeẽka Sikeẽ tixinimoni. Iuaãkiri akauaritiã ikata inapeẽkana. Apraãoni auapanika inakasaaki, iamotari iua akauari Emoo ãkiriakorimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","—Itixi Teoso sikaenetakiti Apraãomoni kaiamapeka Xoteoakorimoni inakasaaki, kãkiti Isaeokini kaiãopokoikana Exito tixiniã. ");
INSERT INTO apuNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Itokanani napaka atoko, ãti Exito auakani auĩte Xoseeni mimarotakati aua. ");
INSERT INTO apuNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Iua auĩtetxi misiritari anirimaneakorini. Ininiã sotatoakori mixirika itxapena amarini xapitiri. Eereka oka itxapena. ");
INSERT INTO apuNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","—Iuasaakiikara Moisesi iponaniã. Moisesi amarinipanika inakasaakiua peerepatikiri. Ipi, ãti pakini kasiriti iri, inoro pakini nĩkatari iua ninoa aapoko. ");
INSERT INTO apuNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Eereka ninoa takanapari iua Paraoo ãkero kipaãtiniãtaãua takote. Ininiã oa apokari iua amarini. Oanikari oaãpokomoni. ");
INSERT INTO apuNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Exito auakani imarore ikinipoko oerekaãka iuamoni. Kasãkireri iua. Kakamareri iua. ");
INSERT INTO apuNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","—Koarẽta anokanani inakasaaki, inirekari inirimane Isaeokini aõkitini. ");
INSERT INTO apuNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Inirimanemoni isikasaaki, itikari Exito auakari xirokitatiniri kiki Isaeokiri, ininiã ixikatxitari. Iua aritapiri Exito auakari, oka itxapiri iuani. ");
INSERT INTO apuNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Iuasaaki Moisesi uãkatari inirimane Isaeokini imarotiniri Teoso nirekari Moisesi makatxakinina ninoa, Exito auakani mamisiritakanina ĩkapani. Txamari ninoa !imarotari ikara. ");
INSERT INTO apuNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Apikomoni ãti õti, iua sari inirimanemoni. Iuaã iua apokana ninoa neenamauanãtini, inaiapoatakakauana. Ininiã Moisesi õtãkikana ninoa. Itxana: “Kikiakori hĩtaritakakaua. Kinirepa himisiritakakaua?” ");
INSERT INTO apuNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","—Inirimane misiritakari katika txari Moisesi: “Kipa txai pite ate auĩte pininiua? Kipa txai pite ate õtãkikakari pininiua? ");
INSERT INTO apuNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kita Exitokirini pokini atokokana pokatanoko nota?” itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ikara sãkiretxiti ikenakotakasaaki, Moisesi takanapari Exito tixini. Mitxiaã tixinimoni isa. Iuaã ĩtanorouata. Ipi imiakori aua iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","—Koarẽta anokanani ãparaã makipakaniãtaã iua aua iuasaaki. Teoso nitiri iaxitikiri motika Moisesimoni ixirata Sinai inakoriãtaã. Iuasaaki iua atamatari aanaia tirinini, txama !arika. !Ixipoka. ");
INSERT INTO apuNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ikara itikasaaki, Moisesi tsorĩkaãta, ininiã aanaia takote isa iteene atamatini ĩkapani. Iuasaakipeka ikenakotari Apiananiri sãkirauatini: ");
INSERT INTO apuNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Pikiomaneakori Teosonekarano nota. Apraão, Isaki, Xakoo pakini Teosonekarano nota,” itxa Teoso. Iuasaaki Moisesi kikinanaka ipĩkare xika. Ipĩkari Teoso sãkirauatini manapi atamatini. ");
INSERT INTO apuNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","—Ininiã Apiananiri txari iua: “Pikitimata pimakatxaka, kotxi uai pitiminiãtaã nota auanãta. ");
INSERT INTO apuNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nitikana ninakitiakori Exito tixiniã. Exito auakani misiritapena ninoani. Nikenakotari oõkinina. Nota inari nisikakinina ĩkapani. Ininiãkarako Exito tixinimoni niokanatai pite,” Apiananiri txari Moisesi. ");
INSERT INTO apuNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","—Iua Moisesi Isaeokini manirekakiniti, kotxi ninoa txari: “Kipa txai pite ate auĩte pininiua? Kipa txai pite ate õtãkikakari pininiua?” itxarina. Iuakara Teoso iokanatakiti ninoamoni ninoa auĩte ininiua ĩkapani, ninoa imakatxakini ĩkapani, kotxi Teoso nitiri aanaiaã tirinakariã auakari iokanatari iua ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","—Eereka iua makatxakana ninoa Exito tixini. Oerekari Teoso posotiire kãkiti maposotakiniti Exito tixiniã. Oerekari Teoso posotiire potxoari uiniti, Põkamarari inakoriã. Ãparaã makipakaniãtaã apaka oerekari Teoso posotiire koarẽta anokanani iuaãtaã. ");
INSERT INTO apuNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","—Ia Moisesikara sãpiretana Isaeokini: “Teoso iokanatariko isãkire sãpiretakari hĩtemoni nota iokanatini atokokana. Hĩte nirimanekara iua. Hĩkenakotariko iua sãkire,” itxa Moisesi. ");
INSERT INTO apuNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisesi aua Teoso nakitiakorikata ãparaã makipakaniãtaã. Aãtokiriakorini aua iuakata. Apaka Teoso nitiri iaxitikiri aua iuakata. Iua Teoso nitiri misãkiretari Moisesi ixirata Sinai inakoriãtaã auakasaaki. Iua apakapari Teoso sãkire, atemoni isikini ĩkapani. Iua Teoso sãkire txĩkitakari iua sãkire auiãkani ãtipirika auini Teosokata. ");
INSERT INTO apuNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","—Aãtokiriakorini kona nirekari inĩkaenetinirina Moisesi sãkire. !Inirekarina iua. Inirekarina Exitomoni ikanapiriinina. ");
INSERT INTO apuNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Iuasaaki ninoa paniãtari Arão: “Teosoakori kamakoni pikaminaua, ate mĩkiikakani tĩkane. Ĩkora Moisesi Exito tixini amakatxakakiri, ĩtapari iua? !Aimarotari iua auiniãtaã,” itxarina Arãomoni. ");
INSERT INTO apuNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ininiã ninoa kamari kema auĩte ãkiri atoko inakari oro kamakori iteosonetinina ĩkapani. Eereka okarina soti auĩte teoso ikamakitina isikinina ĩkapani. Kiiniri ikamana. Ipoxokoniuatana, kotxi ninoaka kamari iteosonena. ");
INSERT INTO apuNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Txamari Teoso atão inakari takanapana ninoa. Ininiã iteosonetarina iaxiti auakani iõriki, kasiri, atokatxi pakini. Teoso sãkire sãpiretakani kitxakapirĩka iõkatsopatari ia sãkiretxiti: Hĩte Isaeokini, koarẽta anokanani ãparaã makipakaniãtaã hãuakasaaki, !hõkari pirãtxi nota ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Iuasaaki hĩte anikari papiri aamata kamakori hĩteosone Moroki inakori ĩkapani. Apaka iõriki atoko inakari hĩteosone Hẽpaã inakori hĩkamakiti hanika hĩtekata iuasaaki. Hĩte kamari Moroki, Hẽpaã pakini hĩteosonetini ĩkapani. Ikara xika nota iokanataiko hĩte ãti kãkiti tixinemoni. Papirónia sitatxiti apikoxiti niokanatai hĩte. ");
INSERT INTO apuNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","—Aãtokiriakorini auari papiri aamata kamakori Teoso misãkiretiko papire ãparaã makipakaniãtaã auakasaakina. Moisesi kamari iua papiri Teoso paniãtakiti iaõka, kotxi Teoso oerekari Moisesi iua papiri kamiko. ");
INSERT INTO apuNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Moisesi ipinaka atoko apanakini aãtokiriakorini apakapari iua papiri irina sikakiti. Ininiã iuasaaki ninoa anikari iua papiri, Xosoeekata isikasaakina, ãti uãka tixine imixirikasaakina, kotxi Teoso omitikana ninoa ãti uãka, aãtokiriakorini apokasaaki iuaã. Iua papiri kaikota iuaã. Auapanika iuaã Tavii aãtokiriakorini auĩte inakasaakiua. ");
INSERT INTO apuNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Teoso apokaerekatari Tavii, ininiã Tavii nirekari Xakoo Teosone misãkiretiko aikoti ikamini. ");
INSERT INTO apuNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Txama Teoso !auiritari Tavii kaminiri. Ininiã Saromão, iua ãkiri kamari Teoso misãkiretiko aikoti. ");
INSERT INTO apuNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","—Teoso Apiananiri kona aua aapokotxi kãkiti kamakiti ãki, kotxi Teoso sãkire sãpiretakari kitxakapirĩka txari: ");
INSERT INTO apuNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Apiananiri txari: “Niitopãkiniãtaã iaxiti itxa. Itixi nikiti nitakiniãtaã. Ininiã kanatokopa itxa aapokotxi hĩkamini nota ĩkapani? Namonipa nauiniãtaã? ");
INSERT INTO apuNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kotxi notakara kamari ikinipoko,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Estevão sãkirauatapanika: —Hĩte kona kinirão kenakotaka txari Teoso sãkire. Hĩtsiki mata kisauakaãkapitika, txamari kona hĩkenakotari Teoso sãkire hãkixinireẽ. Ãtipirika kona hinirekari Erekari Matamatakoti paniãtakiti hĩkamini. Hãtokiriakorini kitxakapirĩka atokotxikana hĩte. ");
INSERT INTO apuNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Hãtokiriakorini misiritana ikinimane Teoso sãkire sãpiretakani. Ninoa okana iua sãkire sãpiretakani, Erekarinoka Kamakari sãpiretakani. Ninoa Teoso sãkire sãpiretakani sãpiretari Erekarinoka Kamakari ãti õti uai apokini. Ĩkorasaaki hĩtera mĩkapiritari iua. Hĩtera okari iua Erekarinoka Kamakari. ");
INSERT INTO apuNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Hĩtekara apakapapekari Teoso sãkire Teoso nitiriakori mĩkiti. Iuaritika !hĩkamari ipaniãtakiti —itxa Estevão. ");
INSERT INTO apuNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Xoteoakori kenakotakasaakiri Estevão sãkire, omanãkarauatana. Akatsakatsiriĩtauana omanãkarena xika. ");
INSERT INTO apuNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Iuaritika Erekari Matamatakoti iteene sikataparaxiniretari Estevão. Iuasaaki iua ionakaãta iaxiti. Atamatari Teoso iotximere. Atamatari Xesosi timini Teoso kikomoni. ");
INSERT INTO apuNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ininiã itxa: —Hãtamata. Natamatari iaxiti xorekini. Aĩtari iaxitikiri tima Teoso kikomoni —itxa Estevão. ");
INSERT INTO apuNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Iuasaaki Xoteoakori totari ikenakokina iuakoãna. Iteene ninoa akiripoakata. Eereka ninoa ikinika miteka iuamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Imaĩkarina. Ikosekaãpotarina sitatxi mapotõkire. Iuaãtaã ipotorikana ikiporonakinirina iua kai soroã. Iuasaaki itikarauatakani takari imãkana Saoro inakori kiti takote inĩkatini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ikiporonakasaakirina, Estevão akiritari Teoso. Itxari: —Apiananiri Xesosi, papakapariko nixinire. ");
INSERT INTO apuNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Iuasaaki ikapotoreẽkaua. Itaparasãkireritika akiritari Teoso: —Apiananiri, pimaxinĩkaretariko ia maerekati ninoa kamakiti —itxa. Iuasaakipeka ipĩpe. ");
INSERT INTO apuNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Estevão ipĩkasaaki Saoro aua iuaã. —Ari erekapitikari ipinini —itxa Saoro. Estevãoni ipinini õtisaakipeka ipotorika Xesosi sãkire auiãkani misiritiko Xerosareẽ. Ninoa iteene misiritaãka, ininiã ikinimane Xesosi sãkire auiãkani Xerosareẽ auakani iarika itxapena. Xotéia tõpamoni, Samaria tõpamoni pakini iarikana. Xesosi iokanatakininoka kaikota Xerosareẽ. ");
INSERT INTO apuNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Estevão ipinaka atoko kikiakori Teoso sãkire auiãkani katari iuani. Iteene itxiapatana. ");
INSERT INTO apuNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Iuasaaki Saoro potorika ixipokinina Xesosi sãkire auiãkani. Ninoa aapokomoni isaãpota. Kikiãkini, sitoakoro apaka ikosekaĩtota, taka itxana kateia ãki. ");
INSERT INTO apuNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Teoso sãkire auiãkani iarikasaaki, isãpiretarina Teoso sãkire ikini aapokotxitiã. ");
INSERT INTO apuNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Piripi sari Samaria sitatxitimoni. Iuaã iua sãpiretari kãkiti Xesosi Teoso mereẽkiti ininiua. ");
INSERT INTO apuNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Isãkire ikenakotakasaakina, posotiiretxi ikamakiti itikasaakina, iteene ikenakotarina isãkire. Imixinikarina isãpiretakiti. ");
INSERT INTO apuNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Maerekani matamatakoni kãkiti auaĩtotakini takanapari kãkiti. Akiripoakatana ipokĩkasaakina. Kaiãopokori matĩpokotakani apaka makananitaãka. ");
INSERT INTO apuNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ininiã Samaria auakani iteene poxokoniuata. ");
INSERT INTO apuNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Iuasaaki Samaria sitatxitiã aua kiki Simão inakori. Miĩti itxaua iua. Imisirienetana kãkiti Samaria auakani. Ininiã ikinimane tsorĩkaãta, ikamakiti atamatakasaaki. Iua iuikaua. —Kimaroreno nota —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ininiã ikinimane kĩpitari iua sãkire. Auĩtetxiakori, poiãorini pakini kĩpitari isãkire. Ininiã itxana: —Iua Simão auari Teoso posotiire. Kaposotiireri iua —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ininiã ikĩpitarina isãkire, kotxi itokatapeka itikarina ikamakiti kãkiti mimarotakiniti. ");
INSERT INTO apuNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ninoa auikasaakiri Piripi sãpiretakiti erekari pirena, Teoso auĩtetxi ininiãua pirena, Xesosi Kristo posotiire pirena pakini, kikiakori, sitoakoro apaka patxisataãka. ");
INSERT INTO apuNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Iuasaaki Simão apaka auikari. Ipatxisataãka. Ininiã isari Piripi sinimoni, kotxi itsorĩkaãta, posotiiretxi kãkiti mimarotakiniti itikasaaki. ");
INSERT INTO apuNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Xesosi iokanatakini Xerosareẽ auakani kenakopiretari Samaria auakani auikiniri Teoso sãkire. Ininiã ninoa iokanatari Petro, Xoão pakini Samariamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Iuaã apokasaakina, imisãkiretarina Teoso, Erekari Matamatakoti isãkire auiãkani apakapini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Erekari Matamatakoti kona apokapanika ninoamoni iuasaaki. Apiananiri Xesosi uãkaãnanira ipatxisataãkana. ");
INSERT INTO apuNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ininiã Petro, Xoão pakini takari iuakona ninoa nopini. Iuasaakipeka apakaparina Erekari Matamatakoti. ");
INSERT INTO apuNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simão itikasaakiri Erekari Matamatakoti apokini kãkitimoni, kinirão sikaka itxaro txineiro Petro, Xoão pakinimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ininiã itxa: —Ĩkora hĩposotiire hĩsikano, niuako kãkiti nopini nitakasaaki, Erekari Matamatakoti ninoamoni apokini ĩkapani —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Txamari Petro txari: —Pite, pitxineirotekata samakauako, kotxi pite uãkatari pitxineirote iamotiniri Teoso posotiire. ");
INSERT INTO apuNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kona xapiti pitemoni auapani ia parĩkatxi, kotxi pãkixinire na atão Teoso apisatoõ. ");
INSERT INTO apuNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ininiã pitakanapariko ikara pimaerekani. Pamanaãri Apiananiri pimaerekani imakatxakini ĩkapani. Atxiĩti iua maxinĩkaretari pixinikakiti pãkixinireẽ. ");
INSERT INTO apuNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nota imarotai pite. Pãkixinireẽ xãpoãkata maerekatinoka. Pimaerekani maĩkai. !Auiritai pisini pinirekinimoni —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ininiã Simão apakapapiretari: —Pimisãkiretariko Teoso nota ĩkapani. Ikara atoko pisãpiretakiti na ninireka —itxa Simão. ");
INSERT INTO apuNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petro, Xoão pakini sãpiretari Xesosi kamakiti ninoa ĩkapani. Isãpiretarina Apiananiri sãkire. Eereka ikanapiriãna Xerosareẽmoni. Ikanapiriaãpotakasaakina, isãpiretarina Teoso iokanapirena erekari kaiãopokori aapokotxi auakanimoni Samaria tõpa. ");
INSERT INTO apuNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Eereka Apiananiri nitiri iaxitikiri misãkiretari Piripi: —Paiamatako. Atokatxi pokĩkinimoni pikikomoni pisako. Pisa kimaporimoni, ãparaã makipakaniãtaã. Iua kimapori Xerosareẽ Kasa tixinimoni sikari. ");
INSERT INTO apuNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ininiã aiamata, sipe itxari. Ipixinipokoriti aõkitari Etxiópia tixinikiri. Etxiópia auakani auĩte õtãkikakari itxaua. Paimatireri iua. Ikinimane kamari iua paniãtakiti. Etxiópia auakani auĩte sito Kãtasi inakoro. Kaiãopokoro otxineirote, otii pakini. Iua kiki parĩka ikinipoko oa nakiti inĩkata oa ĩkapani. Mitxi iua sari Xerosareẽmoni Teoso imisãkiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ikanapiriãkasaaki, mitekaĩ ãki iitopãkasaaki, atatsopatari Isaía iõkatsopatakiti. Isaía Teoso sãkire sãpiretakari kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Iuasaaki Erekari Matamatakoti txari Piripi: —Pisa okira mitekaĩmoni. Pikaikota oa takote. ");
INSERT INTO apuNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ininiã Piripi miteka iuamoni. Ikenakotakasaakiri Isaía iõkatsopatakiti atatsopatini, Piripi pimaãri: —Pimarotatari ere patatsopatakiti? —itxari. ");
INSERT INTO apuNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ininiã iua: —Natokopa ininiãpa nimarotari? Kipa oerekano? —itxari. Ininiã aiatari Piripi mitekaĩ ãki iuakata iitopãkini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Iua iõkatsopatari ia Teoso sãkire: Soti auĩte okikomoni anikiko atoko itxa iua. Soti auĩte ãkiri piti kisauakikosaaki, !kasãkireri iua. Iua soti auĩte ãkiri atoko itxa iua, kotxi iua apaka !kasãkireri. ");
INSERT INTO apuNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Inapetaãka iua. !Atãoni kãkiti kama iuamoni. Okaãkape. !Auari iua ãkiri. Ikara atoko itxa Teoso sãkire, Isaía iõkatsopatakiti. ");
INSERT INTO apuNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ininiã iua Etxiópiakiri pimaãri Piripi: —Pisãpiretano, natokopa itxa Teoso sãkire sãpiretakari sãkire? Kipa soti auĩte atoko inakari? Kipa okaãka? Iuakani? Ãtikani? ");
INSERT INTO apuNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ininiã Piripi oerekari ikara Teoso sãkire iõkatsopatakori. —Xesosira ikara atoko inaãka —itxa. Ininiã apikomoni isãpiretari Teoso iokanapirena erekari, Xesosi pirena. ");
INSERT INTO apuNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Isaãpotakasaakina, apokana ãparaã auiniãtaã. Ininiã iua kiki txari: —Uai aua ãparaã. Apakata nipatxisatiko? ");
INSERT INTO apuNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ininiã Piripi txari iua: —Apakatapitika pipatxisatiko iteene pauikiniãri Xesosi sãkire pãkixinireẽ. Ininiã iua apakapapireta: —Nota auikapitikari Xesosi Teoso mereẽkiti, Teoso ãkiri ininiãua. ");
INSERT INTO apuNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ininiã iua Etxiópiakiri paniãtari mitekaĩ anikakari iotokini. Iuasaaki Piripi, iua Etxiópiakiri apaka katxaka, imaãta itxana. Ininiã Piripi patxisatari iua kiki. ");
INSERT INTO apuNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ikanĩkiĩtakasaakina, Erekari Matamatakoti anikari Piripi. Ininiã iua kiki kona atamataikari Piripi. Ininiã iãpotapitipo. Ipoxokoninoka itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Iuasaaki Asoto sitatxitipeka itokiã Piripi. Isaãpotakasaaki, ikinika aapokotxitiã isãpiretari Teoso sãkire. Teoso sãkire isãpiretiniritika Sesaréia sitatxitimoni apokako. ");
INSERT INTO apuNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Iuasaaki Saoro okaenetapikana Apiananiri sãkire auiãkani. Ininiã iua sari sasetotxi auĩte apiatakarimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Amanaãri aãtsopa Saoro parĩka sãpiretiko aãtsopati. Iua nirekari sasetotxi auĩte iõkatsopatiniri ikara, Saoro anikini ĩkapani. Inirekari isikiniri iua aãtsopa ikinika aiko Xoteo apotiitiniãtaãua nĩkatakanimoni Tamásiko sitatxiti, kotxi Saoro nirekari imaĩkinina Xesosi sãkire auiãkani, kikiakori, sitoakoro pakini, Tamásiko sitatxitiã apokakini. Inirekari anikinina Xerosareẽmoni. ");
INSERT INTO apuNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Iua apokaãpotakasaaki Tamásiko sitatxitimoni, katimaritika iotximeretxi iaxitikiri ãkitari. ");
INSERT INTO apuNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Irika xitipe. Ininiã ikenakotari sãkiretxi: —Saoro, Saoro, kinirepa pimisiritano? —itxa ikenakotakiti. ");
INSERT INTO apuNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ininiã iua: —Kiriparai Apiananiri? Ininiã: —Xesosira nota. Pimisiritakitikarano —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ikikinanaka, iteene ipĩkarauatiniã. —Apiananiri, kipa pinireka nikaminii? —itxa. Ininiã Apiananiri: —Põkitikaua, sitatxi pisa. Iuaã ãti sãpiretai pikamakiti tĩkane —itxa Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Imoianariakori iotoka. Ipĩkarauatana. Masãkireninoka itxana. Ninoa kenakotari iaxitikiri sãkire, txamari !atamatarina. ");
INSERT INTO apuNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Eereka Saoro õkitikaua, xorekaãta itxa, txamari imosiãretapeka iua. Ininiã imoianariakori anikari iua. Ikanõpiãpotarina Tamásikomoni. ");
INSERT INTO apuNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ipi, ãti pakini õti mõsiãretika itxa. Iuasaaki !inipokota. !Iãta. ");
INSERT INTO apuNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tamásiko sitatxiti aua kiki Xesosi sãkire auiãkari, Ananíasi inakori. Iuasaaki Teoso sãkirauata Ananíasikata itaponemoni. Itaponeẽ Apiananiri akiritari iua: —Ereẽkai Ananíasi —itxa. Ininiã: —Uaikarano nota, Apiananiri —itxari Teoso. ");
INSERT INTO apuNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Apiananiri txari: —Paiamatako. Kimapori Eretĩka ãpori kimaporitimoni pisako. Xotasi aapokomoni pisa. Iuaã pinitari Taaso sitatxitikiri Saoro inakori. Uatxiikara isãkirauanãta notakata. ");
INSERT INTO apuNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Saoro taponetai pite. Iua atamatai pite apokini iuamoni, piuako inopini pitakini ĩkapani iuaĩkana kõsiãrepeka inini ĩkapani —itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ininiã Ananíasi: —Apiananiri, kãkitipokoni sãpiretano ikara kiki pirena. Pamonõkoniri iua. Imisiritapekana pite nakitiakori Xerosareẽ sitatxiti auakani. ");
INSERT INTO apuNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Sasetotxiakori auĩte paniãtari iua imaĩkinina piuãka akiritakani uai Tamásiko sitatxiti auakani —itxa Ananíasi. ");
INSERT INTO apuNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ininiã Apiananiri txari: —Pisako iuamoni. Nota mereẽpekari iua kiki, nota parĩka ikamini ĩkapani. Iua sãpiretariko nota sãkire Xoteo minakonimoni, auĩtetxiakorimoni, Isaeo tixini auakanimoni pakini. ");
INSERT INTO apuNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Noerekariko Saoro iteene atatsiirauatini nota sãkire auikini xika —itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ininiã Ananíasi sari Xotasi aapokomoni. Iĩroã. Eereka iuako itaka Saoro nopini. —Nitari Saoro, Apiananiri Xesosi, paõkitakitira kimaporiã, iuara iokanatano nota pitemoni kõsiãrepeka iuaĩkana pinini ĩkapani. Iokanatano nota pitemoni Erekari Matamatakoti papakapini ĩkapani —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Iuasaakipeka oki nopini auakari katxaka. Ximaki tãta atoko itxa. Kõsiãrepeka itxa. Eereka õkitikaua. Iuasaaki ipatxisataãka. ");
INSERT INTO apuNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Inipokotaka atoko, itapara auapeka. Saoro kaikota Tamásiko mapaõti Xesosi sãkire auiãkanikata. ");
INSERT INTO apuNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Iua sari aiko Xoteo apotiitiniãtaãua. Iuaã oerekarauata. Oerekari Xesosi Teoso ãkiri ininiãua. ");
INSERT INTO apuNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Isãkire kenakotakani tsorĩkaãta. —Iua Saoro okana Xesosi uãka akiritakani Xerosareẽ auakani. Iua ina uaimoni Xesosi uãka akiritakani imaĩkini ĩkapani, sasetotxi auĩteakorimoni anikinina ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saoro oerekarauatakasaaki, imaroãpotari Teoso imarore. Teoso sikaposotiireãpotari iua. Ininiã iteene imarotari Teoso sãkire, apanakini oerekini ĩkapani. Iua atoko ininiã, itaparaxinireritika oerekari Xoteoakori Tamásiko sitatxiti auakani Xesosi Teoso Mereẽkiti ininiãua. Ininiã ninoa !imarotari apakapapiretinirina iua. ");
INSERT INTO apuNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mapaõti atoko Xoteoakori sãkirauatakaka Saoro okinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saoro sãpiretaãka Xoteo aiamatapeka okinirina iua. Ninoa iãtapapikari sitatxi ĩronakikoãtaã okinirina tĩkane. Ĩkanõka, pokamara iãtaparina iua. ");
INSERT INTO apuNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Iuasaaki ĩkanõka Xesosi sãkire auiãkani anikari iua sitatxi pirikeremoni. Iuaã Saoro ieretakaua kotari ãki. Pirikeri sonaã iokatxakarina Saoro kotari ãki sitatxi mapara. Iposo atoko imiteka Xerosareẽmoni. ");
INSERT INTO apuNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saoro apokasaaki Xerosareẽ, inirekari Xesosi moianariakori imoianatini. Txama ikinikana pĩkari iua. Kona !auiritarina iua moianatinina ninoa, kotxi !auikarina iua atão auikiniri Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Iuaritika Panapee anikari iua Xesosi iokanatakinimoni. Isãpiretana ninoa: —Kimaporiã isikasaaki, Saoro aõkitari Apiananiri. Apiananiri misãkiretari iua. Tamásiko sitatxiti auakasaaki, itaparaxinireritika isãpiretari Xesosi sãkire kãkitimoni —itxa Panapee. ");
INSERT INTO apuNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Panapee sãkire ikenakotakasaakina, auikarina Saoro sãpiretakiti. Ininiã Saoro kaikota Xerosareẽ Xesosi sãkire auiãkanikata. Inirekinimoni isa Xerosareẽ. Isinimoni itaparaxinireritika isãpiretari Apiananiri Xesosi sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Isãkirauata Xoteoakorikata, Kreko sãkire imarotakanikata. Inirekarina ninoa imarotiniri Xesosi sãkire. Txamari inirekarina okinirina iua. ");
INSERT INTO apuNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Iuasaaki Xesosi sãkire auiãkani imaropiretari ninoa okaenetiniri Saoro, ininiã anikarina sitatxi Sesaréia inakorimoni. Eereka iokanatarina iua Taaso inakori sitatxitimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Iuasaaki Xesosi sãkire auiãkani !imisiritaãkaika. Xotéia tõpa, Kariréia tõpa, Samaria tõpa pakini !auaika Xesosi sãkire auiãkani misiritiko iuasaaki. Erekari Matamatakoti sikataparaxiniretana ninoa. Kãkiti itoãpotari auikiniri Xesosi sãkire. !Ikamarina maerekati, kotxi iteene ipĩkarina Apiananiri. ");
INSERT INTO apuNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petro ianaxititakasaaki, iua sari Teoso sãkire auiãkanimoni Arita sitatxiti auakanimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Iuaã aõkitari kiki Enéiasi inakori. Iua matĩpokotakati itxaua. Oito anokananipeka !õkitikaua. ");
INSERT INTO apuNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petro txari iua: —Enéiasi, Xesosi Kristo makananitai. Põkitikaua. Piapirikari pisirimata —itxari matĩpokotakati. Iuasaakipeka õkitikaua. ");
INSERT INTO apuNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ikinipoko Arita sitatxiti auakani, Sarõ sitatxiti auakani pakini atamatari iua Enéiasi, ininiã itakanaparina imaerekanina. Inĩkapiretarina Apiananiri sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ãti sitatxiti Xopi inakoriã oãua sito Teoso sãkire auiãkaro, Tapita inakoro. Kreko sãkireẽ ouãka Tókasi otxaua. Oa kamapikari erekari. Omoianatana matxineiroteni. ");
INSERT INTO apuNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Arita auakani auikasaakiri Apiananiri sãkire, oa Tókasi amianata. Eereka oani opĩpe. Opĩpeka atoko, arokaĩtotarona, taka itxarina oĩto itanokiri koaã. ");
INSERT INTO apuNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Xopi sitatxiti Arita sitatxiti takote, ininiã Xesosi sãkire auiãkani Xopi sitatxiti auakani kenakoenetari Petro Arita sitatxiti auiniã, iokanatana ipi kiki Petromoni, apinirina ĩkapani. Iokanapiretana: —Pinapokako uai. Katima pitxako —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ininiã Petro aiamata. Ninoakata isa. Iua apokasaaki, anikarina itanokiri koaã. Ikinipoko tikinitakoni txiapanãta Petro takote. Ninoa oerekari Petro mãkatxi Tókasini kamakiti ninoa ĩkapani oãuakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ininiã Petro iokanatana ninoa mapara. Eereka ikapotoreẽkaua. Isãkirauata Teosokata. Eereka oamoni ikirioka. Itxaro: —Tapita põkitikaua. Iuasaakipeka xorekaãta otxa. Oãtamatakasaakiri Petro, oitopãka. ");
INSERT INTO apuNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ininiã imaĩkaro ouako oõkitikiniua ĩkapani. Eereka iua akiritana Xesosi sãkire auiãkani, tikinitakoni pakini, oa auãki onini oerekini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ikini Xopi auakani imaropiretari Tókasi iuaĩkana auãki onini, ininiãra itomaneri kãkiti auikari Apiananiri sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petro kaikota iuaã Xopi sitatxiti mapaõti. Iua kaikota Simão inakorikata. Iua Simão aamata kamakari. ");
INSERT INTO apuNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Iuasaaki Sesaréia sitatxiti aua kiki Konério inakori. Ãti uãka iua. Homano itxaua. Seĩ pakini sotato auĩte iua. Kãkiti akiritana ninoa sotatoakori Itáriakini. ");
INSERT INTO apuNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Iua Konério kamari Teoso sãkire iaõka. Iua, ikinipoko aapoko auakanikata paxitari Teoso. Imisãkiretapikari Teoso. Isikana matiitimoni inirekakitina. ");
INSERT INTO apuNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ãti õti kikatapeka inakasaaki itaponeuata. Itaponeẽ itikari Teoso nitiri apokini iuamoni. Itxari: —Konério —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Teoso nitiri atamatakasaaki, ipĩkarauata. —Apiananiri, kipa pinireka? —itxa Konério. Ininiã Teoso nitiri txari: —Teoso kenakotapekari pisãkire iuamoni. Itikapekari pisikarauatini matiinimoni. Teoso xinikapitikai. ");
INSERT INTO apuNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ininiãkara ãtikaka kikiakori piokanata Xopimoni Simão Petro uaimoni imininina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Iua kaikota ãti Simãokata, aamata kamakarikata. Iua aapoko potxoari uiniti takote aua. Iua Simão Petro sãpiretaiko pikamakiti tĩkane —itxa Teoso nitiri. ");
INSERT INTO apuNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Eereka iua Teoso nitiri sipe. Iposo atoko Konério akiritana ipi initiriakori, ãtika isotatone pakini. Iua sotato kamari Teoso sãkire iaõka. Iua auapika Konériokata, inireẽkiti ikamini tĩkane. ");
INSERT INTO apuNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ininiã Konério sãpiretana ninoa ikinipoko Teoso nitiri sãpiretakiti. Iposo atoko iokanatana Xopimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Katimatinĩkata Konério iokanatakini potorika. Apaniãxiti inakasaaki ninoa apokaãpota sitatxi Petro auiniãtaã. Iuasaaki Petro kanikauata aapokotxi nopini Teoso imisãkiretini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Iuasaaki Petro natxita. Inirekari inipokotini. Nipokori kamikosaaki, itaponeuata. ");
INSERT INTO apuNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Itaponeẽ atamatari iaxiti xorekini. Aamata mitamatari katxakaãpota iuamoni. Imapotomatare ipi ipi pakini iaxirikaãka. Iua aamata katxaka xitimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Iua aamata ãki aua ikini sereti kaxipirini. Aua pirãtxi. Aua ĩtopa auakani. Aua imini. Aua araãkani. ");
INSERT INTO apuNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ininiã Petro kenakotari itanokiri sãkirauatini: —Petro, põkitikaua. Pokari ia, pinikini ĩkapani —itxari Petro. ");
INSERT INTO apuNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petro Xoteo itxaua, ininiã kona ikinika !inika. Ininiã Petro txari: —Konapitini Apiananiri. Kona ninikari ikinipoko naia kaxipirini. Manaiatini. Pamininiri —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Iuaĩkana itanokiri sãkirauata: —Nota oeretakiti kona kamininiri kona pitxape —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ipi, ãti pakinikata iua aamata katxaka ikara atoko. Iposo atoko ikanĩkaxitita Teoso tixinemoni. ");
INSERT INTO apuNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ininiã Petro ãkixinireẽ ixinikaxitita: —Kanatokopa itxa ikara nitapone? Iuasaakipeka Konério iokanatakini apokapekari Simão aapoko. Apokana Simão aapoko toremoni. ");
INSERT INTO apuNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Akiritana: —Ereẽkai. Simão Petro uai aua atxiĩti? —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Iuasaaki Petro xinikapanikari itapone. Erekari Matamatakoti txari: —Ikiraãkarana ipi, ãti pakini kãkiti nitanãtai. ");
INSERT INTO apuNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Põkitikaua. Pikatxaka xitimoni. Pisa ninoakata, kotxi niokanatana ninoa uaimoni —itxa Erekari Matamatakoti. ");
INSERT INTO apuNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ininiã Petro sari Konério iokanatakinimoni: —Notakara hĩte nitanãta. Kipa ĩkai hĩte? ");
INSERT INTO apuNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ninoa apakapapiretari iua: —Konério, aãuĩte iokanataua ate. Erekari iua. Ikamari Teoso sãkire iaõka. Ikinipoko Xoteo apokaerekatari iua. Teoso nitiri iaxitikiri paniãtari iua pite akiritini, pisãkire ikenakotini ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ininiã Petro: —Hiĩroã. Uai himaka —itxa. Katimatinĩkata Petro sari ninoakata. Apanakini Xesosi sãkire auiãkani Xopikini sari apaka. ");
INSERT INTO apuNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Katimatinĩkata apokana Sesaréia sitatxiti, Konério auiniãtaã. Iua Konério apotiitapekana inirimane, aõkimanere pakini Petro iãtapinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petro ĩroãkasaaki Konério aapoko, iua aõkitari Konério. Iuasaaki Konério kapotoreẽkaua Petro apisatoõ. ");
INSERT INTO apuNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Txamari Petro txari iua: —Põkitikaua. Kiki pite atoko inakarikarano nota. ");
INSERT INTO apuNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Isãkirauatakasaakina, Petro ĩroã. Aõkitari ito kãkiti apotiitakaniua. ");
INSERT INTO apuNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ininiã itxana: —Hĩte imarotari ate kiomaneakorini !auiritari Xoteo moianatiniri ãti uãka. !Auiritaãka ate ĩroini hĩte atoko inakari aapoko. Iuaritika Teoso txano nota: “Na pakiritapiri ãti uãka kanaiari,” itxano. ");
INSERT INTO apuNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ininiã hĩte pĩkapiretakasaakino nota, nimarotari atão nisini hĩtemoni. Ininiã, kinirepa hĩte apakĩtakano nota? —Petro txari Konériomoni. ");
INSERT INTO apuNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konério apakapapiretari: —Ipi, ipi pakini õti apisapanika nauanãta naapoko. Iuasaaki kona ninikari nipokori, Teoso nimisãkiretini ĩkapani. Kikatapeka inakasaaki, nimisãkiretakasaakiri Teoso, katimaritika kiki tokiã nota apisatoõ. Pomẽkoriri imãka. ");
INSERT INTO apuNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Itxano: “Konério, Teoso kenakotapekari pamanaãkiti. Ixinikari pisikarauatini matiinimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ãtikaka kiki piokanata Xopi sitatxitimoni Simão Petro inakori uaimoni imininina ĩkapani. Iua aua ãti Simãokata, aamata kamakarikata. Simão aapoko potxoari uiniti takote.” ");
INSERT INTO apuNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Iuasaaki nota apakĩtakai pite. Peerekari papokini atemoni. Uatxa ate uai aua Teoso apisatoõ Teoso paniãtakiti pitemonikiri akenakotini ĩkapani. Ininiã pisãpiretauako —itxa Petromoni. ");
INSERT INTO apuNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ininiã Petro txari: —Uatxa nimarotari atão inakari. Teoso sikari erekari ikininapemoni. Inirekari ikini uãka apokini iuamoni, inakitiakori ininiuana ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Teoso apakapari ikini itixiti auakani, iua paxitakani, atão inakari kamakani. Apakapari Xoteoakori. Apakapari Xoteo minakaniua apaka. ");
INSERT INTO apuNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Himarotari Teoso iokanapirena Isaeo auakanimoni. Ikara erekari pirena sãpiretaua Xesosi Kristo xipokari Teoso omanatiniri kãkiti imaerekani xika, kãkiti erekaxinire inini ĩkapani. Ikinimane auĩte itxaua Xesosi. ");
INSERT INTO apuNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ikara Teoso iokanapirena himarota, kotxi iaripireta ikini Xotéia tõpa. Merepitipanika iaripireta Kariréia tõpa, Xoão patxisarauataka atoko. ");
INSERT INTO apuNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Himarotari Xesosi Nasareekiri pirena. Himarotari Teoso sikari Erekari Matamatakoti iuamoni. Iteene isikaposotiiretari iua. Ikini tõpati isa erekari ikamini ĩkapani. Imakananitana Satanasi misiritakini, kotxi Teoso aua iuakata. ");
INSERT INTO apuNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ateka itikari ikinipoko ikamakiti Xoteoakori tixine iua auakasaaki, Xerosareẽ sitatxiti auakasaaki apaka. Eereka aamina ĩpiriãmitakari nopini ninoa okari iuani. ");
INSERT INTO apuNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","—Iuaritika ipi ãti pakini õtisaaki Teoso õkitikari iua. Iuaka oerekaua kãkitimoni ipĩpekariika iuaĩkana aua inini. ");
INSERT INTO apuNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kona ikinipokoni atamatari iua. Teoso mereẽkininanira atamatari iua. Iuaritika kaiãori iua atamatakani. Ininiã ate atamatari iua. Iua õkitikaua atoko ate nipokota, iãriã aãta iuakata. ");
INSERT INTO apuNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iokanataua ate Teoso sãkire asãpiretini ikini kãkitimoni. Teoso mereẽri iua, kãkiti misiritiko mereẽkari ininiua ĩkapani. Auãkipanika inakani, ipĩkani pakini misiritiko mereẽkari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ikinipoko Teoso sãkire sãpiretakani sãpiretari iua pirena. Ninoa txari: “Iua sãkire auiãkani maerekani makatxakaãka” —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petro sãkirauatapanika inakasaaki, Erekari Matamatakoti apoka ikinika Petro sãkire kenakotakanimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ininiã Petro moianariakori Xesosi sãkire auiãkani kisauakatsikimatatakoni tsorĩkaãta, kotxi Teoso sikari Erekari Matamatakoti Xoteo minakonimoni apaka. Ninoa tsiki mata !ikisauakaãka, iuaritika Erekari Matamatakoti apoka ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ikenakotarina Xoteo minakaniua sãkirauanãta ãti uãka sãkireẽ. —Peerekari Teoso. Apiananiri itxaua —itxanãtana Xoteo minakaniua. ");
INSERT INTO apuNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ininiã Petro txari: —Ninoa Xoteo minakaniua apakapapekari Erekari Matamatakoti ate apakapiniri atokokana. Ininiã apakatapitika ninoa patxisatiko ãparaaã. Kona kãkitini iotokakana ipatxisatikona. ");
INSERT INTO apuNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ininiã iua paniãtana ninoa patxisatiko Xesosi Kristo uãkaã. Iuasaaki ninoa aiatari Petro: —Atekata mapaõti pikaikota —itxarina. Ininiã Petro kaikota ninoakata. ");
INSERT INTO apuNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Xesosi iokanatakini, Teoso sãkire auiãkani Xotéia tõpa auakani apaka kenakotari Xoteo minakaniua auikinirina Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ininiã Petro kanapiriãkasaaki Xerosareẽmoni, kisauakatsikimatatakoni apoĩtari iua. ");
INSERT INTO apuNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","—Pite imaka itsiki mata makisauakakoni aapoko ãki. Ninoakata pinipokota pitxa. !Apakata pikamakiti —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ininiã Petro sãpiretari ikinipoko itiãkiti, ikenakotakiti pakini. ");
INSERT INTO apuNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Xopi sitatxiti nauakasaaki, Teoso nimisãkiretakasaaki, nitaponemoni natapari mãkatxi mata atoko inakari iaxiti katxakaãpotini. Ipi, ipi pakini imapotomatare iaxirikaãka. Iua apoka nota takote. ");
INSERT INTO apuNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Iteene nimixinitari mãkatxi mata ãki auakani. Natamatari ikini sereti kaxipirini. Aua pirãtxi. Aua ĩtopa auakani. Aua imini, araãkani pakini. ");
INSERT INTO apuNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Iuasaaki nikenakotari sãkiretxi iaxitikiri: “Põkitikaua. Oka, nika pitxako,” itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Txamari nitxari iua: “Apiananiri, konapitini. !Ninikari nipokori mauiritakoti ia atoko inakari, kotxi pamininiri,” nitxari. ");
INSERT INTO apuNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","—Iuaĩkana iaxitikiri sãkirauata: “Teoso oeretakiti kona kamininiri kona pitxape.” ");
INSERT INTO apuNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ipi ãti pakinikata iua aamata katxaka ikara atoko. Eereka ikinika kosekaãka iaxiti. ");
INSERT INTO apuNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","—Iuasaakipeka ipi, ãti pakini kikiakori Sesaréiakini apoka aapokotxi nikaikotiniãtaã. Iokanataãkana notamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ininiã Erekari Matamatakoti paniãtano: “Pisa ninoakata. Kona pipĩkarauatape,” itxa. Naia seisi aĩtariakori Xopikini moianatano nota iuasaaki. Ininiã ate ĩroã Konério aapoko. ");
INSERT INTO apuNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ininiã iua sãpiretaua ate, Teoso nitiri iaxitikiri apoka iuamoni aapoko ãki. Iua Teoso nitiri txari iua: “Piokanatari kikiakori Xopimoni Simão Petro inakori apinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iua sãpiretaiko pite maerekani makatxakiko, paapoko auakani maerekani makatxakiko apaka.” ");
INSERT INTO apuNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","—Nipotorikasaaki nisãkirauatini, Erekari Matamatakoti apoka ninoamoni merepanika atemoni apokini atokotxikana. ");
INSERT INTO apuNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Iuasaaki nixinikari Apiananiri sãkire. Iua txari: “Xoão patxisarauata ãparaaã. Hĩte patxisataãkako Erekari Matamatakotiã.” ");
INSERT INTO apuNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ininiã Teoso sikari Erekari Matamatakoti ninoamoni, atemoni isikini atokotxikana Xesosi Kristo Apiananiri sãkire aãuikasaaki. Ikara atoko ininiã, !apakata Teoso ninaiatini —itxa Petro. ");
INSERT INTO apuNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Petro sãkire ikenakotakana atoko, !itsoataikana. —Peerekari Teoso —itxana. —Ininiã Teoso auiritari Xoteo minakaniua apaka imaerekanina itakanapinina, Teosokata ãtipirika auinina ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estevão ipinaãka atoko, Xesosi sãkire auiãkani misiritaãka, ininiã ninoa iarika. Iariãkani sari maioakari. Penísia tixinima, Xipri pokomiriĩtima, Ãtxiokia sitatxitima pakinimoni isana. Ninoa oerekari Teoso sãkire Xoteomoninani. ");
INSERT INTO apuNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ninoa ãtikaka Xiprikini, Sirenikini pakini sari Ãtxiokia sitatxitimoni. Iuaã isãpiretarina Teoso iokanapirena erekari, Xesosi Apiananiri pirena, Xoteo minakonimoni ninoa apaka imarotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Apiananiri sikaposotiiretana ninoa. Ininiãkara itomaneri kãkiti auikari Apiananiri sãkire. Maerekati itakanapana. Ikamarina Apiananiri nireẽkiti. ");
INSERT INTO apuNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ikara apopireta Xesosi sãkire auiãkanimoni Xerosareẽ sitatxitiã. Ininiã ninoa iokanatari Panapee Ãtxiokia sitatxitimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Iuaã iua apokasaaki, imarotakasaakiri ninoa apakapiniri erekari Teoso sikakiti, ipoxokoniuata. Isikataparaxiniretana. Õtãkikana Apiananiri paniãtakitinoka ikaminina ikini itaparaxinireritikana. ");
INSERT INTO apuNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Erekari Panapee. Ikinika Erekari Matamatakoti paniãtakiti ikama. Auikari Xesosi sãkire ikini ixinireritika. Ikara atoko ininiã, itomaneri kãkiti auikari Apiananiri sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Eereka Panapee sari Taaso sitatxitimoni, Saoro initini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Itaõkitakasaakiri, iminari iua Ãtxiokia sitatxitimoni. Ãti anokanani ikaikotana iuaã Xesosi sãkire auiãkanikata. Oerekarina Teoso sãkire itomaneri kãkitimoni. Xesosi sãkire auiãkani Ãtxiokia sitatxiti auakani merepitipanika takauãkataãka, “Kristopiki.” ");
INSERT INTO apuNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Iuasaaki ãtikaka Teoso sãkire sãpiretakani Xerosareẽkini sari Ãtxiokia sitatxitimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ninoa ãtika Ákapo inakori õkitikaua. Erekari Matamatakoti sãkire isãpireta: —Natxinoka auako ikini itixiti —itxa. Ikara isãkire apokapeka Kráotxio Homano auĩte inakasaaki. ");
INSERT INTO apuNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ininiã ikinika Xesosi sãkire auiãkani nirekari txineiro iokanatini itariakorimoni Xotéia tõpa auakanimoni. Ito auinina, ito iokanatana. Poiãonoka auinina, poiãonoka iokanatana. ");
INSERT INTO apuNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Panapee, Saoro pakini anikari isikakitina. Isikaro oa txineiro Xotéia tõpa auakani õtãkikakanimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Iuasaaki auĩtetxi, Erotxi inakori, misiritana Xesosi sãkire auiãkani. Ãtikaka itaka kateia ãki. ");
INSERT INTO apuNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Iua okapiri Txiako iouata mitaroã. Iua Txiako Xoão itari. ");
INSERT INTO apuNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Erotxi imarotakasaakiri Xoteoakori apokaerekatiniri Txiakoni okiko, ipaniãtari Petro maĩkiko. Imaĩkari Petro Xoteoakori kiiniritesaaki, pão miãtiãkati kiiniritisaaki. ");
INSERT INTO apuNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Petro imaĩka atoko itakari iua kateia ãki. Ipaniãtari tesiseisi sotatoakori nĩkatiniri iua. Kiiniri xipoka atoko Erotxi nirekari imereiniri imisiritiko ikinimane apisatoõ. ");
INSERT INTO apuNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ininiã Petro kateia ãki kaikota. Iuasaaki Xesosi sãkire auiãkani ãtipirika misãkiretari Teoso Petro ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ĩkanõka, imisiritiko imarotini õti apisapanika, kateia ãki Petro imakanãta ipi sotato apanĩkaki. Iaxirikiko tsapi metao kamakori ipi. Aua apaka apikomoni sotatoakori kateia toreãtaã, Petro mamitekakani ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Patimari Teoso nitiri tokiini. Tirikapi ponika kateia ãki. Iuasaakipeka Teoso nitiri õpirĩkari Petro. —Põkitikaua. Katima pitxako —itxari. Iuasaakipeka itsapi iaxirikiko iuakoãkiri katxaka. ");
INSERT INTO apuNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Teoso nitiri paniãtari: —Pimãka pieretaka. Pikiti mata pitaka, ininiã Petro takari. Pimãka pinopinikiri apaka pitaka, eereka pisa notakata —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ininiã Petro sari iua tikini. Kateia ipokĩkana. Iuasaaki Petro uãkatari itaponeuatini. !Imarotari atão Teoso nitiri mipokĩkiniri iua. ");
INSERT INTO apuNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Eereka inapari ipi sotatoakori auiniãtaã, apoka itxana itore maparakiri metao kamakori. Iuaãtaã napakari sari sitatximoni. Ikara itore iuaka matakakaua. Ininiã ninoa pokĩka. Iua ahoa mapotõkire apokasaakina, katimaritika Teoso nitiri takanapari iua. ");
INSERT INTO apuNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Iuasaaki Petro imarotapekari: —Na nitaponeni itxa. Atãopitikara Apiananiri iokanatari initiri itixinekiri nota imakatxakini ĩkapani. Pataparari Erotxi, iuaritika Apiananiri makatxakano. Xoteoakori nirekari okinino, iuaritika Apiananiri makatxakano —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ikara ixinika atoko, isari Maria aapokomoni. Xoão Marko inakori inoro oa Maria. Iuaã itomaneri kãkiti apotiitapekaua, Teoso imisãkiretinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Maria aapoko apokasaaki, akirita. Ãtokoro Hotxi inakoro sari itoremoni. Okenakotari Petro sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Oimarotakasaakiri Petro mapara apokini, omiteka iriko ãki aapokotxi ãki auakanimoni. Opoxokoniuata, txamari omaxinĩkaretari itore omatakakini Petro ĩkapani. Ininiã otxari apanakinimoni: —Aapokotxi toreãtaãpekari Petro —otxa. ");
INSERT INTO apuNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ininiã ninoa: —Pimapitxirita. —Atãopitikara nisãkire —otxa oa. Ininiã ninoa: —Petro kamiritekara. ");
INSERT INTO apuNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ninoa ikara atoko inaãtakasaaki, Petro mapara akirinãtapanikana ninoa. Eereka ninoa matakakari itore, atamata itxarina. —Kanatokopa pitakanapari kateia? —itxarina. ");
INSERT INTO apuNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ininiã iuakoã ipinitana: —Hĩkenakotari nisãkire —itxana. Eereka isãpiretana: —Apiananiri makatxakano nota kateia ãki. Ikinika ikara hĩsãpiretariko Txiako, apanakini aĩtariakori pakini —itxa. Iuasaaki isipe. Ãtiãtaã isa. ");
INSERT INTO apuNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Katimatinĩkata sotatoakori kateia nĩkatakani tsorĩkaãta: —Ĩteri iua Petro? Kanatokopa itxa Petro pokĩkini? —itxana. Initapiimarina Petro. ");
INSERT INTO apuNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ininiã Erotxi paniãtana initiko, txamari !apokarina. Erotxi pimaãna sotatoakori Petro nĩkatakani, Petro sinimoni imarotinina ĩkapani, txamari ninoa !imarotari Petro sinimoni. Ininiã eereka ipaniãtari ninoa sotatoakori okiko Petro mitekini xika. Ikara atoko inaãka atoko Erotxi sipeka. Xotéia tõpa ipotorika. Sesaréia sitatxitimoni isa. ");
INSERT INTO apuNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erotxi omanatana Txiro sitatxiti auakani, Sitoõ sitatxiti auakani pakini. Ninoa nirekari iua omanatinina xipokini, kotxi ninoa apakapari nipokori Erotxi tixinekiri. Ininiã ninoa sãkirauata Parásito inakorikata. Iua Parásito nĩkatari Erotxi aapoko, itii pakini. Paimatireri iua. Ninoa sãkirauatakasaaki iuakata, iua auikari ninoa sãkire. Eereka Erotximoni isana neenamatxi xipokini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Erotxi ketotari ikinimane kãkiti imisãkiretini ĩkapani. Iketo õti apokasaaki ieretakari imãka ereri inakari, auĩtetxi mãka. Eereka iitopãka auĩtetxi itopanere nopini. Iuaã iua misãkiretana kãkiti. ");
INSERT INTO apuNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ininiã kãkiti txari: —Teosora sãkirauanãta. Na kãkitini —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Iuasaakipeka Teoso nitiri iaxitikiri okari Erotxi, kotxi iua auiritari kãkiti iteosonetiniri iua. Ininiã tsomi sotakiperi nika txari iĩto. Ikara atoko inikoã ipĩpe. ");
INSERT INTO apuNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Iuasaaki Teoso sãkire iaripireta. Ininiã itomaneri kãkiti auikari Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Panapee, Paoro pakini parĩka Xerosareẽ sitatxitiã xipokaãka atoko, Ãtxiokia sitatxitimoni kanapiriã itxana. Anikarina Xoão Marko ninoakata. ");
INSERT INTO apuNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Xesosi sãkire auiãkani sauaki Ãtxiokia sitatxitiã aua Teoso sãkire sãpiretakani, Teoso sãkire oerekakani pakini. Aua Panapee. Aua Simão “Pomamari.” Aua Arósio Sirenikiri. Aua Manaeẽ. Auĩtetxi Erotxi inakori xapitipanika inakasaaki, iua Manaeẽ xapitipanika inakasaaki, imakananitaãka Erotxikata. Apaka Saoro aua Ãtxiokia sitatxitiã. ");
INSERT INTO apuNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ãti õti Xesosi sãkire auiãkani iuaãtaã takanapari inipokotinina Apiananiri imisãkiretinina ĩkapani. Iuasaaki Erekari Matamatakoti txana ninoa: —Himakatxakana Panapee, Saoro pakini parĩkatxi ikaminina nota ĩkapani —itxa Erekari Matamatakoti. ");
INSERT INTO apuNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ininiã ninoa takanapari inikini Teoso imisãkiretini ĩkapani. Iposo atoko itakarina iuakona Panapee, Saoro pakini nopini. Iokanatana ninoa Erekari Matamatakoti paniãtakiti ikaminina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Erekari Matamatakoti iokanatana Panapee, Saoro pakini, ininiã ninoa sari Sereósia sitatxitimoni. Iuaã ninoa iereẽtaua maporo ãki. Isana Xipri pokomiriĩtimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Saramina sitatxitiã apokasaakina, isãpiretarina Teoso sãkire aiko ãki Xoteo apotiitiniãtaãua. Xoão Marko inakori moianatana ninoa iuasaaki. ");
INSERT INTO apuNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Xipri pokomiriĩti ĩpirixititana. Paposi sitatxitimoni isana. Iuaã itaõkitarina kiki Xoteo. Miĩti itxaua. Iuãka Paxesosi. Ãti iuãka Erimasi. —Teoso sãkire sãpiretakarikarano nota —itxa iua. Txamari na atão isãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Iua moianatari Xipri auakani auĩte Séxio Paoro inakori. Paimatireri iua Séxio Paoro. Iua akiritana Panapee, Saoro pakini iuamoni Teoso sãkire ikenakotini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Txamari Erimasi !inirekana ninoa. !Inirekari Séxio Paoro auikiniri atão Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Iuasaaki Erekari Matamatakoti iteene sikaimaroretari Saoro (ãti iuãka Paoro,) ininiã iteene atamatari iua miĩti. ");
INSERT INTO apuNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Itxari iua: —Pite Satanasi ãkiri pitxaua. Pite atão kamakari mokaiakari pitxaua. Pite kamari ikini sereti maerekati. Ikara atoko ininiã, pimisirienetari kãkiti. Atão inakari Apiananiri sãkire pite nirekari pimamakini. ");
INSERT INTO apuNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ikara pimaerekani xika Teoso misiritaiko pite uatxa. Mõsiãreti pitxauako. Kona patamatapaniri atokatxi mapaõti. Iuasaakipeka katxiãri atoko inakari, ipiã apaka apoka Erimasimoni. Ininiã iua nitari ãti anikakiri ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Séxio Paoro atamatakasaakiri Erimasi misiritiko, iua auikari Teoso sãkire. Itsorĩkaãta: —Peerekari Paoro oerekakiti sãkiretxiti Apiananiri pirena isãpiretakiti —itxa. ");
INSERT INTO apuNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Iposo atoko Paoro imoianariakorikata iereẽtaua maporo ãki. Paposi itakanapana. Pexi sitatxitimoni, Pãpíria tixini isana. Pexi sitatxiti auakasaakina, Xoão Marko takanapana ninoa, Xerosareẽmoni ikanapiriini ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Eereka iuaĩkana maporo ãki iereẽtauana. Isana Ãtxiokia sitatxitimoni, Pisítxia tixinimoni. Ãtxiokia sitatxiti auakasaakina tomatiko õtisaaki ĩroãna aiko Xoteo apotiitiniãtaãua. Iuaã iitopãkana. ");
INSERT INTO apuNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Teoso paniãtakiti aãtsopateẽ, Teoso sãkire sãpiretakani iõkatsopatakiti aãtsopateẽ pakini atatsopataãka atoko auĩtetxiakori iuaãtaã auakani txana ninoa: —Aĩtariakori, ate nirekari hĩsãkirauatini, hĩsãkire auiniã, naia kãkiti hĩsikataparaxiniretini ĩkapani —itxana. ");
INSERT INTO apuNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ininiã Paoro õkitikaua. Õkatari iuako ninoa sãkirauatini iotokakinina ĩkapani. Ininiã itxa: —Nitariakori Isaeo auakanii, apaka hĩte Xoteo minakaniua Teoso paniãtakiti kamakanii, hĩkenakotariko nisãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isaeo auakani Teosone mereẽna aãtokiriakorini Exito tixini auakasaakina, ãti uãkakata auakasaakina. Itxĩkitakana ninoa itomane ininina. Iuasaaki Exito auakani misiritana. Ininiã eereka Teoso makatxakana iposotiireẽ, ininiã itakanaparina Exito tixini. ");
INSERT INTO apuNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","—Eereka, koarẽta ano Teoso mĩteenekana ninoa ãparaã makipakaniãtaã, kotxi ikamapikarina maerekati iuaã. ");
INSERT INTO apuNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Eereka ixipokana setxi pakini ãti uãka Kanaaã tixini auakani. Eereka isikari iua itixi ninoamoni ãtipirika iuaã auinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Eereka Teoso sikana kõtãkikarerini Isaeo auakani auĩteakori tĩkane. Ãti kõtãkikareri aua. Eereka iua ipina. Eereka ãtipekana kõtãkikareri aua. Eereka iua ipina. Itxaãpotana koatrosẽtosi sĩkoẽta anokanani. Imapotõkire, Samoeo inakori Teoso sãkire sãpiretakari ninoa õtãkikakari itxaua. ");
INSERT INTO apuNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","—Eereka ninoa nirekari auĩtetxi apiatakari ninoa auĩte ininiua ĩkapani. Ininiã Teoso sikana ninoa Saoo inakori, Kixi ãkiri. Iua atokiri kitxakapirĩka Pẽxamiĩ inakori. Iua Saoo ninoa auĩte apiatakari koarẽta anokanani. ");
INSERT INTO apuNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Eereka Teoso makatxakari Saoo. Itxĩkitakari Tavii ninoa auĩte apiatakari ininiua. Teoso sãpiretari Tavii pirena: “Kãkiti Tavii Xesee ãkiri atoko inakari ninireka, kotxi iua kamari ikinika ninireẽkiti,” itxa Teoso. ");
INSERT INTO apuNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","—Teoso sikaenetari ãti, Tavii apika mekani Isaeo auakanimoni. Isaeo auakani maerekani makatxaãkari itxauako. Iua Xesosikara. Iua kãkiti maerekani makatxaãkari txaua. ");
INSERT INTO apuNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Xesosi parĩka ipotorikini apisapanika, Xoão sãpiretari ikinimane Isaeokini imaerekanina itakanapinina, eereka ipatxisataãkana. ");
INSERT INTO apuNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Xoão parĩka ixipokasaaki, ipimaãna ninoa: “Kipa hĩuãkatatano nota? Nota kona iua hiãtapakitini. Iuaritika iua ina nota tikini. Nota poiãori, ininiã !apakata iua takote napokini ikiti mata nimakatxakini ĩkapani, kotxi iua Apiananiri,” itxa Xoão. ");
INSERT INTO apuNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Paoro sãkirauatapanika: —Nitariakori, Apraão apika mekaniriakorii, apaka hĩte Xoteo minakaniua Teoso paniãtakiti kamakanii, hĩkenakota. Hĩtemonikari Teoso iokanatari iokanapirena kãkiti maerekani makatxakiko pirena. ");
INSERT INTO apuNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Xerosareẽ auakani, ninoa auĩteakori pakini kona imarotari Xesosi Teoso ãkiri ininiua. Ninoa atatsopatari Teoso sãkire sãpiretakani sãkire ikini tomatiko õti, iuaritika !imarotarina ninoa sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ninoa kona apokari ixika Xesosi okiko ĩkapani, iuaritika ipaniãtari Pirato okiniri. ");
INSERT INTO apuNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ninoa kamari Xesosimoni ikinipoko mitxi Teoso sãkire iõkatsopatakori iaõka. Iposo atoko imakatxakarina iua aamina ĩpiriãmitakariã. Ikata itxarina kai iriko ãki. ");
INSERT INTO apuNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Iuaritika Teoso õkitikari iua ipĩkitximonipeka auakaripeka. ");
INSERT INTO apuNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Õkitikaãka atoko, ito õti kãkiti atamatari iua. Kariréiakini, iuakata Xerosareẽmoni sikani aõkitari iua. Ininiã Xesosi iuaĩkana auini pirena sãpiretakani itxauana ninoa Xesosi aõkitakani. Isãpiretarina apanakini Isaeo auakani. ");
INSERT INTO apuNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","—Ininiã uatxa ate sãpiretari Teoso iokanapirena erekari hĩtemoni. Ikara sãkiretxiti Teoso kamaenetakiti aãtokiriakorinimoni kitxakapirĩka. ");
INSERT INTO apuNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ĩkorasaaki Teoso kamapekari ikara ikamaenetakiti ate ĩkapani, ninoani apika mekaniriakori ĩkapani, kotxi iua õkitikari Xesosi ipĩkasaaki, iuaĩkana auãki inini ĩkapani. Kitxakapirĩka Teoso sãkire iõkatsopatakori Xikari ipiãtaã sãpiretari Xesosi õkitikiniua õti, kotxi itxari: Pite namarite. Ia õti noerekari kãkiti pite iri nininiua nota. ");
INSERT INTO apuNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","—Kitxakapirĩka Teoso sãpiretapekari iua õkitikiniri Xesosi ipĩkasaaki, iuaĩkana imapinakani tĩkane, kotxi isãkire iõkatsopatakori txari: Nikamaenetakiti Taviimoni pitemonikara nikama. Ikara erekari nikamapitikako pitemoni. ");
INSERT INTO apuNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Teoso sãkire iõkatsopatakori Xikari tesiseisiãtaã txari: Teoso kona auiritari Erekari Kamakari ĩto paiakini. ");
INSERT INTO apuNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","—Kitxakapirĩka Tavii auakasaaki, ikamari Teoso nireẽkiti, kotxi inirimane auĩte itxaua. Eereka ipĩpe. Ikatapeẽka. Inirimanekata ikatapeẽka, ininiã iĩto paiaka. ");
INSERT INTO apuNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Xesosipekana, Teoso õkitikari iua. Iua ĩto kona paiaka. ");
INSERT INTO apuNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ininiãkara nitariakori himarotariko ia. ");
INSERT INTO apuNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Xesosi sãkire auiãkani maerekani makatxakaãka. Erekarini ninoa. Moisesi paniãtakiti kamiko kona makatxakari kãkiti maerekani. ");
INSERT INTO apuNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Erepaniko. Kitxakapirĩka Teoso sãkire sãpiretakani sãkire iaõka atxiĩti apoka hĩtemoni, kotxi ");
INSERT INTO apuNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ia atoko itxana: Hĩkenakota, hĩte Teoso sãkire napetakanii. Hãtamatariko niposotiire, iuaritika hĩpinako, kotxi !hãuikari niparĩka hĩte sauaki. Ãti sãpiretiniãri niparĩka, iuaritika !hãuikari. Ikara atoko itxa Paoro sãkire ninoamoni. ");
INSERT INTO apuNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Xoteoakori pokĩkasaaki Xoteo apotiitiniua aapokotxiti, iuasaaki Xoteo minakaniua aiatana Paoro, Panapee pakini iuaĩkana tomatiko õti ĩkari Teoso sãkire isãpiretinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kãkiti apotiitakaniua potorika atoko, itomaneri Xoteo, Xoteo minakaniua Teoso sãkire auiãkani pakini sari Paoro, Panapee pakinikata. Paoro, Panapee pakini misãkiretana ninoa. Õtãkikana ninoa, ikiniõtika atão ikaminina, kotxi Teoso iteene tiretana ninoa. ");
INSERT INTO apuNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ininiã ãti tomatiko õtisaaki ikinimane iua sitatxiti auakani apoka Apiananiri sãkire ikenakotinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Xoteoakori atapari itomaneri kãkiti apokaãpotini Paoro, Panapee pakini sãpiretakiti ikenakotinina ĩkapani. Ininiãkara ninoa xikotana Paoro, Panapee pakini. Imisãkirepiretana ninoa: —Na atão Paoro sãkire. !Apakata isãkire —itxanãtana. ");
INSERT INTO apuNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Iuasaaki Paoro, Panapee pakini itaparaxinireritikana isãkirauatana. —Ate sãpiretari Teoso sãkire hĩte Xoteoakorimoni merepitipanika. Ikara atão. Txamari hĩte !inirekari. Hĩte atxiĩti !inirekari ãtipirika auãki hinini? Ikara atoko ininiã, ate sariko Xoteo minakonimoni, ");
INSERT INTO apuNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","kotxi Apiananiri paniãtaua ate ia atoko: Tirikapi atoko inakari hĩtxauako Xoteo minakaniua ĩkapani nisãkire atão ninoa imarotini ĩkapani, ninoa maerekani nimakatxakini ĩkapani, ikini itixiti auakani ikara imarotini ĩkapani, —itxa Paoro. ");
INSERT INTO apuNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Xoteo minakaniua kenakotakasaakiri ikara Paoro sãkire, ipoxokoniuatana. Ininiã ninoa: —Peerekari Apiananiri sãkire —itxanãtana. Teoso mereẽri kãkiti ãtipirika iuakata auini ĩkapani, ininiã iuasaaki kãkiti kenakotakasaakiri Paoro sãkire, ninoa Teoso mereẽkini auikari iua sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Iuasaaki Teoso sãkire iaripireta ikinipoko iua tixini. ");
INSERT INTO apuNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Txamari Xoteoakori !apokaerekatari Xoteo minakaniua auikiniri Xesosi sãkire. Ininiã isãpiretarina aãpirena sitoakoro apiatakani Teoso paxitakanimoni, sitatxi auakani auĩteakorimoni pakini. Ininiã ikara xika ninoa omanatana Paoro, Panapee pakini. Ininiã iokanatana ãtiãtaã isinina. ");
INSERT INTO apuNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ininiã Paoro, Panapee pakini takanapari iuaã. Itakanaparina kipatxi ikiti mataã auakari apaka, kotxi kona ninoa nirekaikari Teoso sãkire. Ininiã isana Ikónio sitatxitimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ãtxiokia sitatxiti auakani Xesosi sãkire auiãkani poxokoniuata. Iteene ikamarina Erekari Matamatakoti nireẽkiti. ");
INSERT INTO apuNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Paoro, Panapee pakini auakasaaki Ikónio sitatxitiã, isana aiko Xoteo apotiitiniãtaãua. Isãpiretarina Teoso sãkire kãkitimoni, ininiã kaiãopokori Xoteoakori, Xoteo minakaniua pakini auikapiretari Teoso sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Txamari apanakini Xoteoakori Teoso sãkire mauiãkani kamaomanãkaretana Xoteo minakaniua. Ininiã ninoa omanatana Teoso sãkire auiãkani. ");
INSERT INTO apuNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Xesosi iokanatakini Paoro, Panapee pakini okanani auana Ikónio sitatxiti. Ninoa sãpiretari Apiananiri pirena itaparaxinireritikana. Isãpiretarina Apiananiri sikiniri ikinipoko erekari maerekanimoni. Apiananiri oerekari isãkirena atão inini, kotxi isikaposotiiretana ninoa, posotiiretxi, kãkiti mimarotakiniti pakini ikaminina. ");
INSERT INTO apuNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kãkiti sitatxi auakani omanatakakana. Apanakini auikari Xoteoakori sãkire. Apanakini auikari Xesosi iokanatakini sãkire. ");
INSERT INTO apuNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ininiã Xoteo minakaniua, Xoteoakori pakini, ninoa auĩteakorikata imisãkiretakakaua Xesosi iokanatakini imisiritinina ĩkapani, kai soroã ikiporonakinina ĩkapani. ");
INSERT INTO apuNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Paoro, Panapee pakini kenakotakasaakiri ikiporonakikona pirena, imitekana. Arisitara sitatxitimoni, Tepi sitatxitimoni, Arikaónia tixini isana. ");
INSERT INTO apuNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Iuaã isãpiretarina Teoso iokanapirena erekari kãkitimoni. ");
INSERT INTO apuNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Arisitara sitatxiti aua kiki petokakititakari iuasaaki. Matĩpokotakati. Iponaniãkasaaki, ipetokakititapeka. ");
INSERT INTO apuNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ikenakotakasaakiri Paoro sãkire, Paoro atamatari iua. Iuasaaki Paoro imarotari iua kiki auikapiretiniri Xesosi sãkire erekape inini ĩkapani. Ininiã iteene a